﻿USE sofia;
DROP TABLE IF EXISTS sofia.att_vpl;
CREATE TABLE att_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES att_vpl WRITE;
INSERT INTO att_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yawe yù naketúratán nayù ira naggaká kâ Apu Kesu Kiristu. Neyanâ si Apu Kesu sù ira ginaká ni Patul Dabid. Á neyanâ si Patul Dabid sù ira ginaká ni Kákay Abrakam. ");
INSERT INTO att_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Danniaw yù ira nelistá nga namegapu kâ Kákay Abrakam. Á si Abrakam yù ammò ni Isak, á yù apù ni Abrakam si Akup, á yù ira ápù na ta siku si Juda ánna yù ira wáwwagi ni Juda. ");
INSERT INTO att_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Á yù ira ápù ni Abrakam ta dulung di Peres kâ Sera nga ánâ ni Juda, á si Tamar yù innò da. Á yù apù ni Abrakam ta tumang si Esron. Á si Esron yù ammò ni Ram. ");
INSERT INTO att_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Á yù apù ni Esron si Amminadab, á yù apù na ta siku si Nassion, á yù apù na ta dulung si Salmun. ");
INSERT INTO att_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Á si Salmun yù ammò ni Boas, ánna yù innò ni Boas si Rakab. Á si Boas yù ammò ni Obed, ánna yù innò ni Obed si Lus. Á yù apù ni Boas si Jesse, nga anâ ni Obed. ");
INSERT INTO att_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Á yù apù ni Boas ta siku si Patul Dabid, nga anâ ni Jesse. Á si Patul Dabid yù ammò ni Solomon. Á yù innò ni Solomon yù babay nga atáwa na ngaw ni Uraya. ");
INSERT INTO att_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Á yù apù ni Patul Dabid si Robowam, á yù apù na ta siku si Abiya, á yù apù na ta dulung si Asa. ");
INSERT INTO att_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Á yù apù ni Patul Dabid ta tumang si Josapat. Á si Josapat yù ammò ni Joram. Á yù apù ni Josapat si Ussiya. ");
INSERT INTO att_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Á yù apù ni Josapat ta siku si Jotam, á yù apù na ta dulung si Akas, á yù apù na ta tumang si Esakiya. ");
INSERT INTO att_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Á si Esakiya yù ammò ni Manasse, á yù apù ni Esakiya si Amos, á yù apù na ta siku si Josiya. ");
INSERT INTO att_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Á si Josiya yù ammò di Jekoniya ánna yù ira wáwwagi na. Danniaw yù ira ginaká ni Abrakam nga nelistá ta áddè ta pangappù nayù patul na Babilonia nira ánna yù pamaggagakkâ na nira nga iniyánge na ta Babilonia, tapè aripanan na ira. ");
INSERT INTO att_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Á ta keggá nayù ira Kudio ta Babilonia áddè ta keyanâ ni Apu Kesu Kiristu, danniaw yù ira nelistá nga naggaká kuna. Si Jekoniya yù ammò ni Salatiel, á yù apù ni Jekoniya si Sirubbabel. ");
INSERT INTO att_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Á yù apù ni Jekoniya ta siku si Abiud, yù apù na ta dulung si Eliakim, á yù apù na ta tumang si Asor. ");
INSERT INTO att_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Á si Asor yù ammò ni Sadok, á yù apù ni Asor si Akim. Á yù apù na ta siku si Eliud. ");
INSERT INTO att_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Á yù apù na ta dulung si Eleyasar, á yù apù na ta tumang si Mattan. Á anâ ni Mattan si Akup. ");
INSERT INTO att_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Akup yù ammò ni Kusè. Á yù atáwa ni Kusè si Maria, nga innò ni Apu Kesu, nga mangngágan ta Kiristu, nga Mangiyígù ánna Mammaguray. ");
INSERT INTO att_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Á yáyù nga mapulu appâ yù gaká nayù ira naggapu kâ Kákay Abrakam áddè kâ Patul Dabid. Á mapulu appâ yù gaká ra gapay nayù ira naggapu kâ Patul Dabid áddè ta pangiyánge na patul sù ira Kudio ta gián na nga Babilonia. Á kunnian gapay, mapulu appâ yù ira gaká ra áddè ta pamegapu nayù ira Kudio nga naggián ta Babilonia áddè ta keyanâ nayù Mangiyígù. ");
INSERT INTO att_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Á kunniaw yù kesimmu nayù keyanâ ni Apu Kesu Kiristu. Netarátu si Maria nga meyatáwa kâ Kusè. Ngam lage ra magatáwa, nánnámmuán ni Maria ta mabussikin negapu sù pakapangnguá nayù Mangilin nga Ikararuá ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Á pakánnámmu ni Kusè ta mabussì yù katarátu na, á gapu ta napiá nga laláki si Kusè, nga mangikállà ánna arán na ikáyâ ta mepasiránán si Maria, yáyù nga ninonò na ta igúnge na nga awán ta makánnámmu. ");
INSERT INTO att_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Á ta pannononò na paga ni Kusè karannian, á nakakaturuk, á nattatagenà. Á pattatagenà na, ajjan nappasingan kuna yù daroban ni Namarò. Á kinagi na kuna, “Kusè, sikaw nga ginaká ni Dabid, ari ka mabbábáng nga mangatáwa kâ Maria, ta mabussì lápay sù pakapangnguá nayù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Á iyanâ na sangaw yù laláki, nga ingágan naw ta Kesu, gapu ta aggina yù mangiyígù sù ira tatole na, tapè ari ira mapagikáru sù liwiliwâ da,” kun nayù daroban ni Namarò kâ Kusè. ");
INSERT INTO att_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Á nesimmu ngámin danniaw tapè matuppál yù bilin ni Namarò nga inipeyubobuk na sù ngaw ábbilinán na, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ginnán naw yù kagiak ku nikayu. Mabussì sangaw yù magingánay nga narenu, á iyanâ na sangaw yù laláki nga ingágan naw ta Imanuel.” Á yá kebalinán nayù ngágan na, ajjan si Namarò nittam. ");
INSERT INTO att_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Á kalukák ni Kusè, kinuruk na yù kinagi nayù daroban ni Namarò, á inâ na si Maria ta bale na. ");
INSERT INTO att_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngam arán na bulubugá siniggek si Maria áddè sù paganâ na ta laláki, nga ningágan ni Kusè ta Kesu. ");
INSERT INTO att_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Á sù pammagure ni Patul Erodo ta Judiya, neyanâ si Apu Kesu sù ili na Betlekem, sù purubinsia na Judiya. Á ari kuruk nga nabayák nga nappasá yù keyanâ na, á minay ta ili na Jerusalem yù ira lálláki nga naggapu ta arayyu nga lugár ta lalassangán. Nasírik ira nga naggigiámmu sù ira bituan. ");
INSERT INTO att_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Á iniyabbû da sù ira tatolay nga taga Jerusalem, á kinagi ra, “Sisaw gián nayù abbing nga neyanâ gangù, nga mabbalin ta Patul nga mammaguray sù ira Kudio? Ta nasingam mi yù bituan na nga ajjan gangù ta lalassangán, á yáyù nga umay kami makimoray kuna,” kud da. ");
INSERT INTO att_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Á pakarámak ni Patul Erodo karannian, kuruk nga nabbagal, á nepatalugáring sù ira ngámin nga tatolay ta Jerusalem gapay, marakè talián nayù abbing si Patul Erodo nga mammaguray ta Judiya. ");
INSERT INTO att_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Á gapu ta naburung si Patul Erodo, inipágál na yù ira ngámin nga kátannangán nga pári ánna yù ira mangituddu sù tunung da, á iniyabbû na nira, nga kun na, “Sogián nayù nakeyanatán nayù mammaguray nga mangngágan ta Kiristu?” ");
INSERT INTO att_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Á simibbák yù ira kátannangán, á kinagi ra kâ Patul, “Á tán nga ili na Betlekem sù purubinsia na Judiya, ta yáyù yù inipetúrâ ni Namarò sù ngaw ira ábbilinán na, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sikayu nga tatolay nga taga Betlekem, sù purubinsia na Judiya, mássiki nu baddì yù ili naw, meparámak sù ira ngámin nga mammaguray sù purubinsia na Judiya, gapu ta duttál sangaw nga maggapu sù ili na Betlekem yù mammaguray nga manaron sù ira tatolè nga Israel.’ ” ");
INSERT INTO att_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Á pakaginná ni Erodo karannian, inagálán na laguk yù ira álliuk nga naggapu ta lalassangán. Á inilímak na yù pakiubobuk na nira, á iniyabbû na nira nu káni yù lattuák nayù bituan. Á kinagi ra kuna. ");
INSERT INTO att_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Á jinok na ira ta ili na Betlekem, á kinagi na nira, “En naw aleran ta napiá yù gián nayù abbing. Á sangaw nu málerán naw, iránuk naw nikán, tapè ek ku gapay makimoray kuna,” kun ni Erodo nira. ");
INSERT INTO att_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Á pakaginná nayù ira álliuk sù kinagi nayù patul, nánaw ira. Á pakalakalakák da ta dálan, nasingad da má yù bituan nga limittuák ta lalassangán. Á napolu yù bituan nira, á sinututtul da áddè ta pagginnà na sù aruk na gián nayù abbing. ");
INSERT INTO att_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Á nerallà yù pagayáyâ da megapu sù bituan, nga nangituddu sù gián nayù abbing. ");
INSERT INTO att_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Á simillung ira sù balay, á nasingad da yù abbing kâ Maria nga yená na. Á namalittúkak ira nga nakimoray sù abbing. Á binukatád da laguk yù kárgá ra, tapè ilawád da yù nanginá nga kukuá ra. Á iniyawâ da kuna yù buláwán ánna duá kaláse nga bábbanguk, nga insensu ánna mirrá. ");
INSERT INTO att_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Á sù páno ra nga nanoli ta lugár da, tanakuán yù nallakarád da, gapu ta pinagimuguk ni Namarò ira megapu sù ipatatagenà na nira, ta ari ira manoli kâ Patul Erodo. ");
INSERT INTO att_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Á páno nayù ira álliuk nga taga lalassangán, á nattatagenà mángin si Kusè. Á nappasingan kuna yù daroban ni Namarò, á kinagi na kuna, “Arà! Gumikkáng ka, ta em mu itálaw yù ira masíná, ta iyángem ira ta lugár na Egipto. Á maggián kayu túrin áddè ta kagiak ku nikayu ta mánaw kayu tán. Ta ipálek na sangaw ni Patul Erodo yù abbing, ta igagánge na nga ipapátay,” kun na kâ Kusè. ");
INSERT INTO att_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Á dagarágâ nga giminikkáng si Kusè ta yian nga gabi, á nánaw ira, ta en na iniyánge ni Kusè yù masíná ta lugár na Egipto. ");
INSERT INTO att_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Á naggián ira ta Egipto áddè ta pate ni Patul Erodo. Á yáyù nga natuppál yù ubobuk ni Namarò nga inipeyubobuk na ngaw sù ira ábbilinán na, ta kinagi na, “Agálák ku yù Anâ ku nga maggapu ta lugár na Egipto,” kun na. ");
INSERT INTO att_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Á pakánnámmu ni Patul Erodo ta sinestemán nayù ira masírik nga lálláki, nga ari manoli nga mangiránuk kuna, á nepallà yù pore na. Á jinok na yù ira umay mamapátay sù ira ngámin nga ábbing nga lálláki sù ili na Betlekem ánna yù ira bárriu na. Á pinapáte ra ngámin yù ira kapángngiyanâ ánna áddè ta duá yù dagud da, gapu ta pabbisítá ni Erodo sù ira masírik nga lálláki, nánnámmuán na ta duá ragunin yù nappasá áddè sù olu nga pakasingad da sù bituan. ");
INSERT INTO att_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Á yáyù nga natuppálin laguk yù inipeyubobuk na ngaw ni Namarò kâ Jeremia nga ábbilinán na, sù keggá na ngaw ta dabbuno. Ta kinagi na, ");
INSERT INTO att_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Maginná nayù ira tatolay yù ira gikulukuletán, nga nepallà yù daddam da, túrin sù lugár na Rama. Maraddam yù ira ginaká ni Rakel, megapu sù pámmatay nayù ira ánâ da. Awán bulubugá ta ággayáyâ da, ta natayin yù ira ábbing.” ");
INSERT INTO att_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Á pappasá nayù pate ni Patul Erodo, á kapamidduá na nga nappasingan yù daroban ni Namarò kâ Kusè túrin ta lugár na Egipto sù pattatagenà na. ");
INSERT INTO att_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Á kinagi nayù daroban kâ Kusè, “Gumikkáng ka, á ilabbè min yù ira masíná sù lugár na Israel, ta natayin yù ira mangigagángay nga mamapátay sù abbing,” kun na. ");
INSERT INTO att_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Á giminikkáng laguk si Kusè, á inipáno na yù ira masíná, ta nanoli ira sù lugár na Israel. ");
INSERT INTO att_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Á labbè da ta lugár na Israel, narámak ni Kusè ta nammaguray ta lugár na Judiya si Arkelò, nga táli ni Patul Erodo nga yáma na. Á naganássing si Kusè nga manoli ta lugár na Judiya. Á pattatagenà na mángin ni Kusè, inipakánnámmu ni Namarò kuna ta umay ira sù purubinsia na Galilia. ");
INSERT INTO att_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Á minay ira laguk ta Galilia, nga nakipaggián ta ili na Nasaret. Á yáyù nga natuppálin yù inipeyubobuk na ngaw ni Namarò sù ira ábbilinán na, nga kinagi ra, “Meparámak sangaw nga taga Nasaret.” ");
INSERT INTO att_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Á pappasá na aru nga dagun, jimittál si Kuan nga Minánnigù, nga mangilayalayâ sù kalállammatán sù purubinsia na Judiya. Á aru yù ira tatolay nga minay ta kalállammatán, tapè ginniginnád da yù kagian na. ");
INSERT INTO att_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Á kinagi ni Kuan nira, “Maraddam kayu sù liwâ naw, á mabbabáwi kayu laguk sù narákè nga akka-akkuán naw, tapè dán nga naparán kayin, ta duttálin yù pammagure ni Namarò sù ira tatolay ta dabbuno,” kun na. ");
INSERT INTO att_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Á si Kuan, aggina yù kinagi na ngaw ni Isaya, nga ábbilinán ni Namarò, nga kun na, “Ajjan yù makkatakatol ta kalállammatán. Yaw ikatakátol na: ‘Umayin si Apu! Paránan naw yù dálan na. Tunungan naw yù pallakarán na.’ ” ");
INSERT INTO att_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Á nabbarawási si Kuan ta gámì nga napadday ta duddù na kamel, nga kun na barawási na pobare. Á nabbarakà ta tabbì na ayám. Á yá ipakkatole na yù durun ánna issi. ");
INSERT INTO att_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Á aru yù ira minay kâ Kuan tapè maginná ra yù ituddu na. Naggagapu ira ta ili na Jerusalem ánna ngámin nga purubinsia na Judiya ánna ngámin nga babálay nga aranni sù danum na Jordan. ");
INSERT INTO att_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Á nabbabáwi ira ta liwiliwâ da tapè pakomán ni Namarò ira. Á pakkagi ra ta pabbabáwi ra, jinigù na ira ni Kuan ta danum na Jordan. ");
INSERT INTO att_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Á gapu ta aru yù ira nga minay kâ Kuan tapè makirigù ira kuna, á aru gapay yù ira Parisio ánna yù ira Sadusio nga minay kuna. Aggira yù naggigiámmu ta rilisiod da. Á pakasingan ni Kuan nira, kinagi na nira, “Sikayu nga ginaká na iráw, ngattá ta kagian naw ta melillì kayu sù pamagikáru ni Namarò megapu sù karigù naw? Ari! ");
INSERT INTO att_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Likuránán naw laguk yù liwiliwâ naw, á akka-akkuán naw yù napiá, tapè mepasingan ta kukurugán nga nabbabáwi kayu. ");
INSERT INTO att_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Á arán naw gapay kagian ta makalillì kayu sù pamagikáru ni Namarò gapu ta ginaká na kayu ni Kákay Abrakam. Ta ikállà na galâ ni Namarò yù ira nga manguruk kuna, nga ginaká ni Kákay Abrakam. Á awayyá ni Namarò gemma nga pabbalinan ta gaká ni Kákay Abrakam yawe ira batu ta dabbun, tapè tuppálan na yù ngaw initabbá na kâ Abrakam. ");
INSERT INTO att_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Á yaw keyarigán nayù pamagikáru ni Namarò yù wátay nga megangngà ta gamù na káyu. Á kunnay ta dán nga naparán yù wátay nga áttukák ta káyu, dán nga naparán gapay yù pamagikáru ni Namarò. Á ngámin ira nga kun na káyu nga ari napiá yù ábbungá ra, matukák ira nga matuggi.” ");
INSERT INTO att_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Á inupù ni Kuan yù magubobuk, á kinagi na, “Nu makirigù kayu nikán, nga pakasinganán ta pabbabáwi naw ta liwâ naw, á danum lâ yù irigù ku nikayu. Ngam ajjan sangaw yù umay, nga dakal yù pakáwayyá na ánnè nikán. Á aringà mepángngà nga maggawing ta sapátù na. Á dumá yù ánnigù na, ta isipà na yù ira manguruk kuna sù Mangilin nga Ikararuá na, nga kun na irigù na nira. Á kun na api yù irigù na sù ira áppè pípiá, ta ari ira melillì sù pangukum na. ");
INSERT INTO att_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Á sangaw nu lubbè, isinná na yù ira manguruk kuna sù ira ari manguruk, nga kun na tolay nga massâ ta aggì. Unnuran na yù aggì, nga pakappián na sangaw sù ággubbuán na. Ngam tuggian na sangaw yù attá sù api nga ari bulubugá máddà.” Yáyù inilayalayâ ni Kuan, nga Minánnigù. ");
INSERT INTO att_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Á minay si Apu Kesu kâ Kuan ta dappâ na Jordan, nga naggapu ta purubinsia na Galilia, tapè makirigù kuna. ");
INSERT INTO att_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Á gapu ta mappasirán si Kuan, á kinagi na kâ Apu Kesu, “Apu, sikán nakuan yù máwák nga makirigù nikaw, ngam ngattá, ta umay ka makirigù nikán?” kun ni Kuan. ");
INSERT INTO att_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Á kinagi ni Apu Kesu, “Paguráyám mu, ta napiá nu palurotat ta ngámin yù ipakuá ni Namarò nitta,” kun na. Á yáyù nga inanugù ni Kuan, á jinigù na. ");
INSERT INTO att_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Á kabalin ni Apu Kesu nga nakirigù kuna, á giminon nga naggapu sù danum. Á dagarágâ nabbukâ yù lángì, á nasingan na yù Ikararuá ni Namarò, nga kun na lummun nga minay naddappá kuna. ");
INSERT INTO att_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Á nappáginná yù ngárál ni Namarò nga naggapu ta lángì, á kinagi na, “Yawe yù Anâ ku nga iddukak ku, á ayatánà megapu kuna.” ");
INSERT INTO att_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Á gon ni Apu Kesu nga naggapu ta danum, iniyánge nayù Ikararuá ni Namarò ta kalállammatán, tapè parubán ni Satanas nga liwatan. ");
INSERT INTO att_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Á ari nakkákán si Apu Kesu ta appátapulu nga ággaw, á nepallà yù bisin na. ");
INSERT INTO att_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Á jimikkì kuna si Satanas, á kinagi na kuna, “Nu kuruk ta sikaw yù Anâ ni Namarò, arakè! Pabbalinam mè laguk ta kanan yawe ira batu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Á simibbák si Apu Kesu, á kinagi na, “Ajjan yù inipetúrâ ni Namarò nga kinagi na, ‘Ari lâ kanan yù ákkatolayán na tolay, nu ari gapay yù ngámin nga ubobuk ni Namarò,’ ” kun na. ");
INSERT INTO att_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Á tabbák ni Apu Kesu kâ Satanas, iniyánge na laguk ni Satanas sù ili na Jerusalem, á inipotun na sù kátannangán nayù bubbungán nayù karakalán nga kapilliá, nga mangilin nga bale ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Á kinagi ni Satanas kâ Apu Kesu, “Nu kuruk nga Anâ naka ni Namarò, makkassú ka ngè laguk, ta ajjan yù netúrâ nga kunniaw: ‘Ipataron naka ni Namarò sù ira daroban na, á tangngalád da ka, tapè ari ka mabigarán, mássiki yù takkim,’ ” kun ni Satanas. ");
INSERT INTO att_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Á simibbák si Apu Kesu, á kinagi na kâ Satanas, “Wan á, ngam ajjan gapay yù netúrâ, ‘Arám mu paraparubán si Namarò nga Yápum.’ ” ");
INSERT INTO att_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Á inipángè na laguk má ni Satanas si Apu Kesu sù kátannangán nga puddul, á inipasingan na yù ira ngámin nga páppatulán, ánna ngámin nga nakástá nga kukuá nayù ira mammaguray nira. ");
INSERT INTO att_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Á kinagi na, “Iyawâ ku sangaw nikaw ngámin danniaw, nu mamalittúkak ka nga makimoray nikán,” kun ni Satanas. ");
INSERT INTO att_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Á simibbák si Apu Kesu, á kinagi na, “Mánaw ken, Satanas! Ta ajjan yù inipetúrâ ni Namarò nga kunniaw, ‘Pakimorayám mu lâ si Namarò nga Yápum. Aggina lâ yù passerbiám mu!’ ” ");
INSERT INTO att_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Á gapu ta pinapáno ni Apu Kesu, á nánaw laguk si Satanas. Á limittuák laguk yù ira daroban ni Namarò, nga minay kâ Apu Kesu tapè abbágád da. ");
INSERT INTO att_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Á pakarámak ni Apu Kesu ta nebáluk si Kuan nga Minánnigù, nanoli ta Galilia. ");
INSERT INTO att_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Á ari nga naggián ta ili na Nasaret, nga jinakalán na, ngam minay naggián ta ili na Kapernium nga aranni ta bebay na Galilia, ta dabbun na Sabulon ánna Neptali. ");
INSERT INTO att_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Á yáyù nga natuppál yù initúrâ na ngaw ni Isaya, nga ábbilinán ni Namarò, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Túrin sù dabbun na Sabulon ánna yù dabbun na Neptali, á túrin ta aruk na bebay ánna ta dammáng na danum na Jordan, ajjan yù purubinsia na Galilia, nga lugár nayù ira tatolay nga ari Kudio. ");
INSERT INTO att_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Á yù ira tatolay nga maggián tán, kun na nakallà yù nonò da, ta arád da ammu si Apu. Ngam manawagán yù nonò da sangaw nu umay yù mamannawák nira, ta ipakánnámmu na nira yù bilin ni Namarò. Nesinná ira ngaw kâ Namarò nga kun na natay. Ngam sangaw nu maginná ra yù bilin ni Namarò, pannawagan ni Namarò yù nonò da.” ");
INSERT INTO att_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Á natuppál yane ubobuk ni Namarò, ta yáyù pamegapu ni Apu Kesu nga mangilayalayâ sù ubobuk ni Namarò. Á kinagi na, “Mabbabáwi kayu sù liwâ naw, á likuránán nawin yù ággangnguá naw. Ta duttálin yù pammagure ni Namarò ta dabbuno.” ");
INSERT INTO att_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Á pallakalakák ni Apu Kesu ta aggik na bebay na Galilia, nasingan na yù ira duá nga mawwagi, di Simon, nga mangngágan gapay ta Eduru, ánna si Andares, nga mattabatabukul, ta yáyù ángngalluád da. ");
INSERT INTO att_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Á kinagi ni Apu Kesu nira, “Tuttulan nawà. Á abbágát takayu, tapè kunnay ta aru nga sirá yù málâ naw kunangan, aru sangaw gapay yù ira tatolay nga ipálâ ku nikayu, nga patuttulan naw nikán, tapè mesipà ira sù pammagure ni Namarò,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Á dagarágâ nga nánawád da yù ira tabukul da, á siminuttul ira kuna. ");
INSERT INTO att_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Á pallakalakák di Apu Kesu paga ta aggik na bebay, nasingan na má yù duá paga nga mawwagi, di Ime kâ Kuan, nga anâ ni Sebedo. Ajjan ira nga mepulupulù kâ yáma ra, nga nagitubang ta barange ra nga mappolì ta tabukul da. Á pakasingan ni Apu Kesu nira, inagálán na ira gapay. ");
INSERT INTO att_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Á dagarágâ nga nánawád da si Sebedo nga ammò da sù barange ra, á siminuttul ira kâ Apu Kesu gapay. ");
INSERT INTO att_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Á kabalin na nagágál ni Apu Kesu sù ira appâ nga kábulun na, pinassiár da yù tangapáddabbunán na Galilia, tapè maddagâ si Apu Kesu nga mangituddu sù ira tatolay ta ngámin nga kapilliá ra. Á inilayalayâ na yù napiá nga dámak nga meyannung sù pammagure ni Namarò ánna pinammapiá na yù ngámin nga máttakì ánna yù ira tatolay nga makkakerumá yù tulágad da. ");
INSERT INTO att_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Á yáyù nga neparámak si Apu Kesu sù tangapáddabbunán na Siria, á iniyánge nayù ira tatolay ngámin nga máttakì, ánna yù ira nga makkakerumá yù tulágad da, ánna yù ira maganánutû baggi ra, á yù ira gapay nga nagunagán na anitu, yù ira minábballiák, ánna yù ira ari makaguyu baggi ra. Á pinammapiá na ira ngámin. ");
INSERT INTO att_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Á yáyù nga nagaru yù ira tatolay nga siminuttul kuna nga naggapu ta lugár na Galilia ánna yù ira dakal nga ili na Dikapulis ánna Jerusalem, ánna yù purubinsia na Judiya, áddè ta dammáng na Jordan. ");
INSERT INTO att_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Á pakasingan ni Apu Kesu sù ira magaru nga tatolay, giminon ta puddul, á nagitubang. Á jimikkì kuna yù ira tudduán na. ");
INSERT INTO att_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Á inituddu na nira, á kinagi na: ");
INSERT INTO att_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mapagayáyâ yù ira manukkalak, nga ammu ra ta nakaliwâ ira nga ari makatuppál sù ngámin nga ipakuá ni Namarò nira, ta ikatalà da si Namarò ta mangabbák nira. Mammapiá yù ággiád da sangaw, ta aggira yù mesipà sù pammagurayán ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mapagayáyâ yù ira maraddam. Mammapiá yù ággiád da sangaw, ta bannabannáyán na ira ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mapagayáyâ yù ira tumulù. Mammapiá sangaw yù ággiád da, gapu ta iyawâ na sangaw ni Namarò nira yù ngámin nga napiá nga initabbá na. ");
INSERT INTO att_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mapagayáyâ yù ira makkaragâ nga manuppál sù ipakuá ni Namarò nira, nga kunnay ta mabisinin nga maláppà nga magalek ta kanan na. Mammapiá sangaw yù ággiád da gapu ta pakáppagan na sangaw ni Namarò ira. ");
INSERT INTO att_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mapagayáyâ yù ira mangikállà sù ira kábulud da. Mammapiá sangaw yù ággiád da gapu ta ikállà na sangaw ni Namarò ira. ");
INSERT INTO att_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mapagayáyâ yù ira nga pareku nga matunung yù nonò da. Mammapiá sangaw yù ággiád da, ta aggira sangaw yù makasingan kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mapagayáyâ yù ira mamakkakápiá sù ira maddamá. Mammapiá yù ággiád da, ta aggira ibiláng ni Namarò ta ánâ na. ");
INSERT INTO att_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mapagayáyâ yù ira nga marigirigâ gapu ta panguruk da kâ Namarò. Mammapiá sangaw yù ággiád da, ta aggira yù mesipà sù pammagurayán ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Á sikayu, mapagayáyâ kayu nu uyu-uyawad da kayu nayù ira tatolay ánna jigirigátad da kayu ánna paraparáketad da kayu gapu ta pangikatalà naw nikán, ta mammapiá sangaw yù ággián naw. ");
INSERT INTO att_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ta kunnian gapay yù panigirigâ nayù ira ngaw tatolay sù ira ngaw ábbilinán ni Namarò. Magayáyâ kayu laguk, mássiki nu marigirigâ kayu, ta aru yù napiá nga bálà naw nga pinakappián ni Namarò ta lángì, nga málâ naw sangaw nu lubbè kayu tán.” ");
INSERT INTO att_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Á inituddu na paga ni Apu Kesu, á kinagi na, “Sikayu nga manguruk nikán, yá keyarigán naw yù asin. Ta napiá ánna nasingngà yù kanat tam nu ajjan yù asin kuna. Á sikayu nga manguruk nikán, nekiruk kayu sù ira tatolay nga ari manguruk, tapè ituddu naw nira yù napiá, á máwayyá ra laguk nga mabbáli nakuan ta napiá gapay. Ngam nu mallállágin yù asin, awánin ta paggák na. Á kengá lâ, ta awán ta serbi na, nu ari lâ nga metabbà nga meguppuguppè sangaw. ");
INSERT INTO att_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Á yù ili nga napatáddak ta puddul, ari gemma metuttù. Kunnian gapay yù keyarigán naw. Ta sikayu nga manguruk nikán yù kun na nawák, á manawagán yù nonò nayù ira tatolay megapu sù ituddu naw nira. ");
INSERT INTO att_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Á awán ta tolay nga mamaggatang ta isingan, nu ikáyâ na sangaw ituttù sù unak na palanggána. Ngam paggatangan na yù isingan nga ipotun na gemma sù ággianán na, tapè manawagán yù ira ngámin nga tatolay nga ajjan ta balay. ");
INSERT INTO att_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Á kunnian gapay yù keyarigán naw. Arán naw ilímak yù ángnguruk naw kâ Namarò. Á tuppálan naw yù ipakuá na nikayu, tapè masingan nayù ira tatolay yù napiá nga akka-akkuán naw ánna dayáwad da si Namarò nga Yáma naw ta lángì.” ");
INSERT INTO att_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Á kinagi ni Apu Kesu, “Arán naw kagian ta umayà manguli sù tunung ni Moyses ánna yù ituddu nayù ira ngaw ábbilinán. Arák ku patalián yù kinagi ra nu arák ku galâ tuppálan yù ngámin nga kinagi ra. ");
INSERT INTO att_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Á kuruk yù kagiak ku nikayu, nga ari mapatalián yù tunung ni Moyses áddè ta pagáddekán nayù lángì ánna dabbuno. Ta ari bulubugá mapangarián yù tunung, mássiki lâ nu baddì, áddè ta matuppál ngámin. ");
INSERT INTO att_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Á yáyù gapu na nga yù tolay nga malliwâ ta baddì sù tunung, ánna ituddu na sù ira kábulun na tapè malliwâ ira gapay, aggina yù kagukábán sù pammagurayán ni Namarò ta lángì. Ngam yù tolay nga manuppál sù tunung ni Namarò, ánna ituddu na sù ira kábulun na tapè tuppálad da gapay, aggina yù meparáyaw sù pammagurayán ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Á yáyù laguk nga kagiak ku nikayu, nu ari napiá yù ánnuppál naw sù ipakuá ni Namarò ánnè sù ánnuppál nayù ira Parisio ánna yù ira mangituddu sù tunung, ari kayu gemma mesipà sù pammagurayán ni Namarò ta lángì.” ");
INSERT INTO att_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Á kinagi ni Apu Kesu, “Ammu naw gemma yù netuddu gári sù ira ngaw tatolay, nga ‘Ari kayu mamapátay, ta gaputad da sangaw yù tolay nga mamapátay, á ikeká ra.’ ");
INSERT INTO att_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngam sikán, yawe yù kagiak ku nikayu. Pasikkálan naw yù akka-akkuán naw. Ta yù tolay nga mapporay sù kabbulun na, ipagápù da sangaw sù ira pulis. Á yù tolay nga manguyaw sù kabbulun na, ikeká ra sangaw sù arubáng nayù ira kues. Á yù tolay nga pakkakagián na yù kabbulun na, mapagikáru sangaw ta impiernu. ");
INSERT INTO att_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Á yáyù nga tabarangat takayu, ta nu umay kayu sù mangilin nga bale ni Namarò, nga makimoray kuna, ánna manonò naw ta ajjan yù kabbulun naw nga natakì yù nonò na nikayu, ");
INSERT INTO att_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","á mapolu kayu bì nga umay makipakomá sù kabbulun naw. Á kabalin naw makkakápakomá, manoli kayu laguk nga makimoray kâ Namarò sù bale na. ");
INSERT INTO att_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Á ta ángngarigán nu ajjan yù mangikeká nikayu, á mapolu kayu bì nga makipakomá kuna, marakè ipagápù na kayu nga ipeyángay ta kues, á ipaparesu na kayu sù ira pulis. ");
INSERT INTO att_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta kuruk yù kagiak ku nikayu, nga maggián kayu ta ábbalurán ta áddè ta arán naw mekáru yù ngámin. ");
INSERT INTO att_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Á ammu naw gemma yawe nakagi, nga ‘Ari kayu mangarallaw.’ ");
INSERT INTO att_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngam sikán, yawe yù kagiak ku nikayu, ta nu inni-innan na tolay yù babay ánna nononopan na yù pakkaragâ na nga makiruruk kuna, nakaliwákin kâ Namarò megapu sù nonò na. ");
INSERT INTO att_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Á nu mapaliwâ kayu sangaw megapu sù jiwanán nga matá naw, baddulan naw laguk nga itabbà naw. Ta napiá yù kesipà naw sangaw kâ Namarò ta lángì, mássiki nu nakúráng yù baggi naw ta tádday nga matá na, ánnè sù ketabbà nayù ngámin nga baggi naw sù impiernu. ");
INSERT INTO att_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Á nu mapaliwâ kayu sangaw megapu sù jiwanán nga limá naw, gappulan naw laguk nga itabbà naw, gapu ta napiá yù kesipà naw sangaw kâ Namarò ta lángì, mássiki nu nakúráng yù baggi naw ta tádday nga limá na, ánnè sù dattál nayù ngámin nga baggi naw sù impiernu. ");
INSERT INTO att_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Á nakagi ngaw gapay ta nu ajjan yù laláki nga mangigúngay sù atáwa na, á iyawâ na laguk yù túrâ na nga pakasinganán ta paggúnge ra. ");
INSERT INTO att_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngam sikán, yawe yù kagiak ku nikayu, ta makaliwâ yù laláki nu igúnge na yù atáwa na nga ari nakilaláki, gapu ta nu makiatáwa yù babay ta tanakuán, yáyù pakikarallo na megapu sù olu nga atáwa na. Á mangarallaw gapay yù laláki nga mangatáwa sù babay nga negúngay. ");
INSERT INTO att_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Á naginná naw gapay yù kinagi ra gári sù ira ngaw olu nga tatolay, nga ‘Arán naw pallikuránán yù initabbá naw. Ngam tuppálan naw yù inipagássingán naw nga initabbá kâ Namarò.’ ");
INSERT INTO att_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngam sikán, kagiak ku nikayu ta ari kayu bulubugá mappagássingán. Á arán naw ikanâ yù gián ni Namarò ta lángì onu yù ággitubangán na, ");
INSERT INTO att_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","onu yù dabbuno, nga kun na pabbatayán na takki na, ánna yù ili na Jerusalem, nga ili nayù kotunán nga Patul. ");
INSERT INTO att_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Á arán naw ipappagássingán yù ulu naw, ta arán naw mapappuraw onu mapangngisì yù mássiki lâ tangalábák nga duddù naw. ");
INSERT INTO att_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Napiá lâ nu kagian naw ‘Wan,’ nu uwan, onu ‘Ari,’ nu ari, ta naggapu kâ Satanas yù ilannà naw. ");
INSERT INTO att_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Á naginná naw gapay yù nakagi gári, nga kud da, ‘Nu ajjan yù mamuling sù kabbulun na, á bulingan naw gapay. Onu ajjan yù manultù sù ngipan na kabbulun na, á tappulán naw gapay.’ ");
INSERT INTO att_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngam sikán, yawe yù kagiak ku nikayu. Arán naw bálatan yù ira nga mangnguá nikayu. Á ta ángngarigán nu ajjan yù mallappák sù jiwanán naw, ipalappák naw paga yù jimigi naw. Arán naw bálatan, mássiki nu palapalingngian na kayu ta lappák. ");
INSERT INTO att_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Á nu ajjan yù mangikeká nikayu, tapè apan na yù barawási naw, á paguráyán naw nu apan na gapay yù latuk na barawási naw. ");
INSERT INTO att_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Á nu ajjan yù mamuersá nga mappakáttu nikayu sù kárgá na ta tangakilometro, á pulutan naw nga mangáttu sù mekaruá nga kilometro gapay. ");
INSERT INTO att_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Á nu ajjan yù makkiddaw nikayu, á iyawâ naw laguk yù kiddawan na. ");
INSERT INTO att_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Á naginná naw gemma yù nakagi, nga ‘Iddukan naw yù ira kákkopun naw, ánna ikalusso naw yù ira malussaw nikayu.’ ");
INSERT INTO att_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngam sikán, kagiak ku nikayu ta iddukan naw yù ira malussaw nikayu ánna ipakimállà naw kâ Namarò yù ira nga manigirigâ nikayu. ");
INSERT INTO att_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tanu kunnian yù akkuán naw, ipasingan naw ta kuruk nga ánâ na kayu ni Namarò, nga Yáma naw ta lángì. Ta palassangan ni Namarò yù bilák megapu sù ngámin nga tatolay, mássiki yù ira nga narákè yù akkuád da ánna yù ira nga napiá yù akkuád da. Á iyawâ na gapay ni Namarò yù urán sù ira nga napiá yù akkuád da ánna yù ira nga mangnguá ta narákè. ");
INSERT INTO att_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Á arán naw laguk kagian ta iddán na kayu ni Namarò sù bálà naw nu iddukan naw lâ yù ira mangiddù nikayu. Ta kunnian gapay yù akkuán nayù ira mináttuki ta buwì, nga massuítì. ");
INSERT INTO att_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Á napiá kayu panò ánnè sù ira tatolay nga ari manguruk kâ Namarò, nu paddulotan naw ta bale naw yù ira kábulun naw? Mássiki yù ira tatolay nga ari manguruk kâ Namarò, paddulotad da gapay yù ira kábulud da. ");
INSERT INTO att_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Párigán naw laguk si Namarò nga Yáma naw ta lángì, tapè pareku lâ nga napiá yù akkuán naw, nga kunnay kuna.” ");
INSERT INTO att_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Á pangituddu na paga ni Apu Kesu, kinagi na, “Magimuguk kayu, ta ari lâ yù paddáyo na tatolay yù gapu na nga tuppálan naw yù napiá. Ta nu tuppálan naw yù napiá nga akkuán naw ta arubáng nayù ira tatolay tapè dayáwad da kayu, awán laguk bulubugá ta bálà naw nga naggapu kâ Namarò nga Yáma naw ta lángì. ");
INSERT INTO att_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Á yáyù nu mallimù kayu sù ira pobare, arán naw párigán yù ira áppè pípiá, nga umay mallimù ta arubáng nayù ira tatolay sù paggagammungán ánna yù dálan, tapè mepasingan yù napiá nga akkuád da ánna meparáyaw ira sù ira tatolay. Ta kuruk yawe nga kagiak ku nikayu. Yù paddáyo nayù ira tatolay nira, yáyù laguk yù bálà da. ");
INSERT INTO att_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngam sikayu, nu mallimù kayu, ilímak naw yù pallimù naw. Arán naw ipakánnámmu, mássiki nu kopun naw onu yù wagi naw. ");
INSERT INTO att_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Á si Namarò nga Yáma naw, nga makasingan sù ngámin nga akka-akkuán naw, mássiki yù ilímak naw, aggina yù mabbalabálà nikayu. ");
INSERT INTO att_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Á nu makimállà kayu kâ Namarò, arán naw párigán yù ira áppè pípiá. Ta ikáyâ da umay makimállà, nga manáddak sù tangngá na kapilliá onu tangngá na dálan, tapè mepasingan ira sù ira tatolay. Á kuruk yù kagiak ku nikayu, nga nálâ den yù bálà da, nga paddáyo nayù ira tatolay nira. ");
INSERT INTO att_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngam sikayu, nu makimállà kayu kâ Namarò, tullung kayu sù bale naw ánna ilitù naw yù puertá, tapè awán ta tolay nga makasingan nikayu. Á makimállà kayu laguk kâ Namarò nga Yáma naw nga ari masingan, nga ajjan ta lángì. Ta masingan ni Namarò ngámin yù akkuán naw, mássiki nu ilímak naw, á aggina yù mabbalabálà nikayu. ");
INSERT INTO att_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Á sù pakimállà naw, arán naw patturutan yù ubobuk naw, nga kunnay sù ira nga ari manguruk kâ Namarò. Ta kagiad da ta ginnán na yù ipakimállà da megapu sù aru nga ubobuk da. ");
INSERT INTO att_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Arán naw ira párigán, ta ammu ni Namarò nga Yáma naw yù máwák naw lage naw makkiddaw kuna. ");
INSERT INTO att_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Á yáyù nga kunniaw laguk yù ákkimállà naw: ‘Ammò mi nga ajjan ta lángì, parè lâ ta meparáyaw yù ngágam mu sù ira ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Á parè lâ ta mabì nga duttál yù pammagurem sawe dabbuno, tapè mapatuppál yù urem saw dabbuno nga kunnay sù katuppál na ta lángì. ");
INSERT INTO att_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Á iyawâ mu nikami yù kanam mi ta ággawo. ");
INSERT INTO att_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Á pakomák kami sù ira liwiliwâ mi, nga kunnay sù pamakomá mi sù ira nakaliwâ nikami. ");
INSERT INTO att_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Á arák kami pángayan sù ira mangituddu ta narákè, á ilillì kami kâ Satanas nga maddok nira.’ ");
INSERT INTO att_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ta nu pakomán naw yù ira nakaliwâ nikayu, á pakomán na kayu gapay sangaw nayù Yáma naw ta lángì. ");
INSERT INTO att_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngam nu arán naw pakomán yù ira nakaliwâ nikayu, á arán na gapay sangaw pakomán nayù Yáma naw yù liwiliwâ naw. ");
INSERT INTO att_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Á nu ngilinan naw yù ággaw nga arán naw pakkákán, arán naw párigán yù ira áppè pípiá, gapu ta áppè daddaddam ira lâ, nga ari magámmuâ ánna ari mattagetay, tapè masingan na tatolay ta ngilinad da yù ággaw. Á kuruk yù kagiak ku nikayu, nga nálâ den yù bálà da, nga paddáyo nayù ira tatolay nira. ");
INSERT INTO att_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngam sikayu, nu ngilinan naw yù arán naw pakkákán, magámmuâ kayu laguk ánna mattagetay kayu, ");
INSERT INTO att_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tapè awán ta makasingan sù pangilin naw sù ággaw, nu ari lâ si Namarò nga Yáma naw ta lángì. Á yù Yáma naw nga makasingan sù inilímak naw, aggina yù mabbalabálà nikayu.” ");
INSERT INTO att_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Á kinagi na paga ni Apu Kesu, “Arán naw unnu-unnuran yù masserbi nikayu saw dabbuno, ta malogon gemma nga mararál megapu sù ulak ánna ulolak onu masináyán, onu apan na sangaw nayù makkokò. ");
INSERT INTO att_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Akkuán naw laguk yù napiá nga ipakuá ni Namarò nikayu, tapè pakappián na ta lángì yù aru nga ipagayáyâ naw nga iyawâ na sangaw nikayu nu lubbè kayu ta gián na. Ta awán bulubugá ta makatallung nga manarál onu makkokò sù kukuá naw ta lángì. ");
INSERT INTO att_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Á nu yù gián ni Namarò ta lángì yù káríkuán naw, si Namarò gapay yù nononopan naw. Á nu yawe dabbuno yù paggianán nayù kukuá naw, arán naw si Namarò bulubugá manonò.” ");
INSERT INTO att_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Á kinagi na má ni Apu Kesu, “Á yù matá na tolay, meyárik ta isingan na baggi na. Á nu napiá yù matá naw, napiá gapay yù akkuán naw, gapu ta manawák gapay yù nonò naw. ");
INSERT INTO att_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngam nu jikkù yù matá naw, nakallà yù nonò naw, á awán ta napiá nga akkuán naw. Tanu kagian naw ta manawagán kayin, ngam narákè yù nonò naw, á kuruk nga nepallà laguk yù kallà na nonò naw.” ");
INSERT INTO att_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Á nagubobuk má si Apu Kesu, á kinagi na, “Á awán ta tolay nga makapasserbi sù duá nga yápu na, gapu ta ari naggittá yù ayâ na nira, ta ikalusso na ánna iluddè na yù tádday, á iddukan na ánna pakimorayán na yù tádday. Á kunnay gapay nikayu, ta ari kayu makapalurò kâ Namarò nu yá lâ ikáyâ naw yù kuártu ánna yù kegatángán na sawe dabbuno. ");
INSERT INTO att_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Á yáyù nga kagiak ku nikayu ta arán naw ipakkaburung yù áttole naw saw dabbuno, nga kanan naw ánna inuman naw, onu yù gámì nga ipabbarawási naw. Ta nu iniyawâ ni Namarò nikayu yù baggi naw nga sinole na, arán na panò iyawâ gapay yù ngámin nga máwák naw nga kanan ánna gámì? ");
INSERT INTO att_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Á ta ángngarigán, nonopan naw yù ira mammánù. Ari ira mammulá, á ari ira maggaták ta pakappiád da sù ággubbuán. Ngam si Namarò nga Yáma naw nga ajjan ta lángì, pakapakanan na yù ira mammánù. Á arán na kayu panò iddukan ni Namarò ánnè sù ira mammánù? Wan gemma! ");
INSERT INTO att_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Á ajjan panò nikayu yù mamakápaddu sù inángà na ta mássiki lâ tangoras megapu sù pannononò na? Awán gemma ta awayyá na. ");
INSERT INTO att_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Á ngattá laguk, ta ipakkaburung naw yù gámì nga ipabbarawási naw? Á ta ángngarigán, nonopan naw yù ira lappáw sù kakáddapán, nu kunnasi yù áddakal da. Ari ira mattarabáku. Arád da ammu mappadday ta gámì. ");
INSERT INTO att_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngam yawe yù kagiak ku nikayu. Binarawasián ni Namarò ira ta nakástá ánnè sù kakástán nga ipabbarawási ni Patul Solomon, nga yù ngaw maríku nga mammaguray. ");
INSERT INTO att_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Á gapu ta barawasián ni Namarò ta nakástá yù ira lappáw nga ajjan ta kakáddapán ta ággawo, ngam meruppáng ira sangaw nu ummá, á arán na kayu panò barawasián gapay? Wan, nepatalugáring nikayu. Ngattá panò ta arán naw ikatalà si Namarò? ");
INSERT INTO att_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Á yáyù nga ari kayu laguk mabburuburung nu sisaw pangápán naw ta kanan naw ánna inuman naw onu gagámì naw. ");
INSERT INTO att_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta si Namarò, nga Yáma naw ta lángì, ammu na gemma ta máwák naw ngámin danniaw. Á yù ira nga ari manguruk kuna, danniaw lâ nga magannagannuk yù ala-alerad da. ");
INSERT INTO att_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ngam sikayu, tángngagan naw laguk ta olu yù meyannung sù pammagure ni Namarò, ánna palurotan naw yù napiá nga ipakuá na nikayu, á aggina sangaw yù manángngák sù ngámin nga máwák naw. ");
INSERT INTO att_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Á yáyù nga arán naw laguk ipakkaburung yù jigâ nga duttál sangaw nu ummá. Ngattá, ta lannapán naw yù ipakkaburung naw ta ággawo? Ta ajjanin gemma yù jigâ naw ta ággawo. Á sangaw nu ummá lâ yù pakanonò naw sù jigâ nga duttálin nikayu sangaw nu ummá.” ");
INSERT INTO att_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Á kinagi ni Apu Kesu, “Arán naw panunnután yù ira kábulun naw, tapè arán na kayu sangaw panunnután ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Á ta kunnay ta pamanunnù naw sù ira kábulun naw, kunnian gapay yù ámmanunnù na sangaw ni Namarò nikayu. Á nu bilángan naw yù liwâ nayù ira kábulun naw, á kunnian gapay sangaw yù ábbiláng ni Namarò sù liwâ naw. ");
INSERT INTO att_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Á sikayu nga mappakagi sù kabbulun naw, á ngattá laguk ta ibúyá naw yù liwâ nayù wagi naw, nga baddì nga kunnay ta apuling nga ajjan sù matá na, ngam arán naw matagenà yù liwâ naw nga kunnay ta malakay nga apuling nga ajjan ta matá naw? ");
INSERT INTO att_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Á kunnasi yù pakári naw ta kun na apuling nga ajjan sù matá nayù wagi naw, nu ajjan gemma yù liwâ naw nga kun na apuling ta matá naw nga pinaguráyán naw? ");
INSERT INTO att_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Áppè pípiá kayu! Irián naw bì nga olu yù liwâ nga kun na apuling nga ajjan ta matá naw, tapè manawák yù ánningan naw, á máwayyá naw nga abbágán yù wagi naw, tapè mári yù liwâ na, nga kun na apuling nga ajjan sù matá na. ");
INSERT INTO att_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Á arán naw ituddu yù napiá nga meyannung kâ Namarò sù ira manakì magginná, marakè akkuád da kayu, nga kunnay ta ítu nga maggabbuâ nga mangagâ. Arán naw ilayalayâ yù ubobuk ni Namarò sù ira mangipuerá sù ubobuk na, ta mangilin yù ubobuk ni Namarò. Á kunnay nakuan ta iwárì naw yù nakástá nga dusáriu nga perlás ta arubáng nayù ira bábi, á iguppuguppè da lâ.” ");
INSERT INTO att_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Á kinagi ni Apu Kesu, “Nu ajjan yù máwák naw, makkiddaw kayu kâ Namarò, á iddán na kayu sangaw. Á magalek kayu, gapu ta ituddu na sangaw yù pakálerán naw. Á nu mattottò kayu ta puertá, mabukatán sangaw, tapè makatallung kayu. ");
INSERT INTO att_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta meddán yù ira ngámin nga mangupù nga makkiddaw. Á makálek yù tolay nga magala-alek. Á mabukatán sangaw yù puertá megapu sù tolay nga mattottottò. ");
INSERT INTO att_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Á ta ángngarigán, egga panò nikayu yù yáma nga mangiyawâ ta batu sù anâ na nga makkiddaw ta kanan na? ");
INSERT INTO att_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Á iddán na panò ta asisípì nu kiddawan na yù ikán na? Ari gemma. ");
INSERT INTO att_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Á sikayu, mássiki nu narákè kayu, ammu naw mangiyawâ sù napiá sù ira ánâ naw. Á nepatalugáring sù Yáma naw nga ajjan ta lángì, ta iyawâ na gemma yù napiá sù ira ngámin nga makkiddaw kuna. ");
INSERT INTO att_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Á sikayu, akkuán naw laguk yù ngámin nga napiá nga ángngabbák naw sù ira ikáttole naw nga kunnay sù ikáyâ naw nga akkuád da nakuan nikayu, ta yáyù gemma yù kebalinán nayù tunung ni Moyses ánna yù inituddu nayù ira ngaw ábbilinán ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Á kinagi ni Apu Kesu, “Á taddánát takayu ta tullung kayu sù nasirì nga áttallungán. Ta aláwa garè yù áttallungán ánna yù dálan nga makáddè sù impiernu nga ari máddà yù api na, á aru garè yù ira mappángè tán. ");
INSERT INTO att_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Á marigâ yù ira mappángè sù pakkatolayán ni Namarò, gapu ta nasirì yù áttallungán sù dálan nga makáddè sù gián na, á baddì yù ira makálek kuna.” ");
INSERT INTO att_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Á kinagi ni Apu Kesu, “Magimuguk kayu, tapè ari kayu melogò sù ira áppè ábbilinán. Ta umay ira nikayu mappásingan nga kunnay ta masippà nga karneru, ngam magigúbâ ira ta kun na ítu nga mabisin. ");
INSERT INTO att_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Á tákkilalán naw ira megapu sù akka-akkuád da, nga kunnay ta panákkilalán naw ta káyu megapu sù bungá na. Egga panò sî nga mabbungá ta malobák? Egga panò kaddà nga mabbungá ta kapáya? ");
INSERT INTO att_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Á nu napiá yù káyu, á napiá gapay yù bungá na. Á yù káyu nga ari napiá, nu mabbungá, á jikkù gapay yù bungá na. ");
INSERT INTO att_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Á nu napiá yù káyu, ari mabbungá ta jikkù. Á nu jikkù yù káyu, ari mabbungá ta napiá. ");
INSERT INTO att_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Á yù ira ngámin nga káyu nga ari napiá yù bungá ra, matukák ira nga meruppáng. ");
INSERT INTO att_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Á ta kunnian matákkilalán naw yù ira ábbilinán nga áppè pípiá megapu sù akka-akkuád da. ");
INSERT INTO att_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Á yù ira nga makkagi ta ‘Apu, Apu,’ kud da nikán, ari ira ngámin mesipà sù pammagurayán ni Namarò ta lángì, ngam yù ira galâ nga mangupù nga manuppál sù ipakuá na nira nayù Yámà nga ajjan ta lángì. ");
INSERT INTO att_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Á sangaw nu duttál yù ággaw nga pamanunnù ku, aru yù ira nga makkagi nikán ta ‘Apu, ari panò sikami yù ira pannakabaggim nga nangilayalayâ? Á iniyusá mi yù ngágam mu ta pamapáno mi sù ira nattaliponak nga anitu ánna namagaddátu kami ta aru megapu sù ngágam mu,’ kud da nikán sangaw. ");
INSERT INTO att_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngam sikán, kagiak ku laguk sangaw nira nga ‘Arát takayu bulubugá amma-ammu! Panawán nawà, sikayu nga mangnguá ta narákè!’ kuk ku sangaw nira. ");
INSERT INTO att_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Á yáyù laguk nga kagiak ku nikayu ta yù ira tatolay nga magginná karannian nga ubobuk ku ánna uputad da nga tuppálan yù kinagì, yá keyarigád da yù tolay nga ammu na yù napiá, nga nappatáddak ta kallang nga inikokkok na sù utun na dakal nga batu. ");
INSERT INTO att_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Á ajjan yù nasikan nga urán, á nalítù yù dabbun. Á nabbaggiu ánna nassikan yù paddák. Á ari natombá yù balay, gapu ta nepatáddak sù batu. ");
INSERT INTO att_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Á yù ira tatolay nga makaginná karannian nga ubobuk ku, ngam arád da tuppálan yù kinagì, meyárik ira sù tolay nga ulapá, nga nappatáddak sù karagátán. ");
INSERT INTO att_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Á ajjan yù nasikan nga urán, á nalítù yù dabbun. Á nabbaggiu ánna nassikan yù paddák. Á natombá yù bale na, nga mekákkássing yù keruppu na.” ");
INSERT INTO att_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Á kabalin na nagubobuk ni Apu Kesu karannian, napállâ yù ira tatolay. Á nepallà yù kapállâ da, ");
INSERT INTO att_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","gapu ta makáwayyá yù ángngituddu na nga kunnay sù ángngituddu na mammaguray, nga ari kunnay sù ángngituddu nayù ira mesturu sù tunung. ");
INSERT INTO att_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Á kabalin ni Apu Kesu nga nangituddu, minutù sù puddul. Á jimináddán kuna yù magaru nga tatolay. ");
INSERT INTO att_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Á ajjan yù tolay nga naggoggong nga jimikkì kuna. Á namalittúkak ta arubáng na, á kinagi na, “Apu, ammù ta makáwayyá ka nga mamammapiá nikán nu ikáyâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Á sinonnâ ni Apu Kesu yù limá na, á sinámmì na yù tolay. Á kinagi na kuna, “Wan, ikáyâ ku. Mammapiá ka laguk,” kun na. Á dagarágâ nga nammapiá. ");
INSERT INTO att_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Á gapu ta nammapiángin yù tolay, á kinagi ni Apu Kesu kuna, “Magimuguk ka, ta arám mu lábbì kagian yù pamammapiâ nikaw. Ngam e ka bì mappasingan nga dagarágâ sù pári, tapè bisítán naka. Á iyawâ mu laguk sù pári yù iyátáng na megapu nikaw, nga kunnay sù kinagi ni Moyses, tapè ipakánnámmum sù ira tatolay ta kuruk nga nammapiá ken,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Á minay si Apu Kesu ta ili na Kapernium. Kalalabbè na tán, ajjan yù kapitán na suddálu nga taga Roma nga minay jiminápun kuna, tapè makkiddaw ta pangabbák na kuna. ");
INSERT INTO att_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apu,” kun nayù kapitán kâ Apu Kesu, “matakì yù abbing ku nga nagiddá túrin ta balè, nga kun na natay yù baggi na, á kuruk nga najjigâ yù abbing,” kun nayù kapitán. ");
INSERT INTO att_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Á et ten, ta ek ku pammapián,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Á initabbák nayù kapitán, á kinagi na, “Apu, aringin máwák nga umay ka, ta mappasiránà nga mamaddulò nikaw sù balè. Á ammù gemma ta mássiki nu ari ka umay, ngam kagiam mu lâ ta mammapiá yù aripak ku, á mammapiángin. ");
INSERT INTO att_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Á mássiki sikán, ajjan yù maddok nikán, á ajjan gapay yù ira suddálu nga dobak ku. Á nu kagiak ku sù tádday, ‘E ka túrin,’ onu ‘E ka saw,’ á umay. Á nu kagiak ku sù aripak ku yù ikáyâ ku nga akkuán na, á dagarágâ nga akkuán na,” kun nayù kapitán. ");
INSERT INTO att_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Á pakaginná ni Apu Kesu sù initabbák nayù kapitán, napállâ sù ángngikatalà na kuna, á kinagi na sù ira dumaddáddán kuna, “Kuruk yù kagiak ku nikayu, nga awán ta nálek ku nga mangikatalà nikán, mássiki sù ira ngámin nga taga Israel, nga kunnay sù ángngikatalà na yawe kapitán nga taga Roma. ");
INSERT INTO att_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Á kagiak ku nikayu ta aru sangaw yù ira ari Kudio, nga maggapu ta makkakerumá nga lugár ta lalassangán ánna lalammarán nga mesipà sù pappabbúyá ra ánna pakkákád da ta pammagurayán ni Namarò ta lángì, kári Abrakam, kâ Isak, kâ Akup. ");
INSERT INTO att_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngam yù ira nga kagittâ nga ginaká ni Israel, nga mesipà nakuan sù pammagurayán ni Namarò ta lángì, ari ira sangaw mesipà. Ngam metabbà ira sangaw ta lawán sù gián nga nakallà, á gikulukuletán yù ira tatolay tán ánna mangngarangngaringngì ira,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Á nallipay si Apu Kesu sù kapitán, á kinagi na kuna, “Mánaw ken nga lubbè laguk, ta mapalurokin yù inipakimállà mu, nga kunnay sù panguruk mu,” kun na. Á negiddán yù pammapiá nayù aripan na kapitán sù pagubobuk ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Á minay si Apu Kesu sù bale ni Eduru. Á ta labbè na, nasingan na yù babay nga katugángán ni Eduru, nga nagiddá nga makkulikuk. ");
INSERT INTO att_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Á sinangngalán ni Apu yù limá nayù babay nga matakì, á dagarágâ nammapiá. Á gimikkáng laguk, tapè passerbián na ira. ");
INSERT INTO att_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Á ta pajjibbà, iniyánge nayù ira tatolay kâ Apu Kesu yù ira aru nga nagunagán na anitu. Á pinapáno ni Apu yù ira anitu megapu sù pagubobuk na, á pinammapiá na yù ira ngámin nga máttakì. ");
INSERT INTO att_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yáyù kingnguá na tapè matuppál yù kinagi na ngaw ni Isaya, nga yù ngaw ábbilinán ni Namarò, nga kunniaw: “Aggina lápay yù mamammapiá sù ngámin makkakerumá nga takì tam ánna yù mangari ta ngámin nga makkakerumá nga tulágat tam.” ");
INSERT INTO att_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Á pannarek na bilák ta tádday nga ággaw, ajjan di Apu Kesu ta aggik na bebay. Á pakasingan ni Apu sù magaru nga tatolay nga nallepuán kuna, á kinagi na sù ira sinudduán na, “Dumákì ittam,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Á lage ra nánaw, jimikkì kuna yù tádday nga minángngituddu ta tunung, á kinagi na kuna, “Apu, naparánà nga tumuttul nikaw ta ngámin nga angayám mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Á simibbák si Apu Kesu, á kinagi na, “Napiá yù ággián na basikaw ánnè nikán, ta ajjan yù abbû na. Á yù ira mammánù, ajjan gapay yù umù da. Ngam awánà ta pagibannagán, sikán nga Kaká na ngámin na tatolay,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Á yù tádday nga siminuttul kuna, ta pakaginná na karannian nga kinagi na, minay kuna, á kinagi na, “Apu, anugutam mu bì ta ek ku mapolu nga itanam yù ammò ku pángè ku tumuttul nikaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Á kinagi ni Apu Kesu kuna, “Paguráyám mu. Ta yù ira nga ari manguruk nikán, meyárik ira ta natay. Á yáyù aggira yù mangitanam sù kagittá ra. Á sikaw, tuttulam mà,” kun na. ");
INSERT INTO att_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Á kabalin na yaw, nánaw si Apu Kesu sù ira magaru, á minay nappittà sù barangay. Á nepulù kuna yù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Á paddákì da, nagiddá si Apu Kesu nga nakakaturuk. Á ikáddagâ lâ nga nassikan yù paddák, á sinábbuetán na palung yù unak na barangay. ");
INSERT INTO att_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Á naganássing yù ira sinudduán na, á ed da linukák, nga kud da, “Apu, iyígù mu ittam bì, ta awán ittamin!” kud da. ");
INSERT INTO att_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Á ngattá ta maganássing kayu?” kun ni Apu Kesu. “Anni ngillâ yù kakapi na ángngikatalà naw nikán!” kun na. Á gimikkáng laguk, á gimmá na yù paddák ánna yù palung. Á dagarágâ nga nagimammà. ");
INSERT INTO att_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Á nepallà yù assing nayù ira sinudduán na, á napállâ ira. Á kinagi ra, “Asinni yaw, nga anni panò yù katatole na! Ta mássiki nu paddák ánna palung, á kurugad da yù kagian na nira!” kud da. ");
INSERT INTO att_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Á jiminung di Apu Kesu laguk ta dammáng na bebay, ta dabbun na Gadara. Á ajjan yù duá nga tolay nga nagunagán na anitu, nga naggián ta kuebá sù katanamán. Á makánnanássing ira megapu ta pore ra ánna uyung da. Á yáyù nga awán ta makeyangngà nga mallakák ta dálan nga mattalebák tán. Á pakasingan nayù ira duá nga nagunagán kâ Apu Kesu, minay ira jiminápun kuna. ");
INSERT INTO att_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Á dagarágâ nga nakkalli ira, nga kud da, “Ye, sikaw nga Anâ ni Namarò, anni yù akkuám mu nikami? Arák kami bì jigirigátan lage na ággaw nga natullà nga pamanunnù mu nikami!” kud da. ");
INSERT INTO att_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Á gapu ta ajjan yù aru nga bábi nga madduki ta kakáddapán nga aranni nira, ");
INSERT INTO att_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","á nakimállà yù ira anitu, á kud da kâ Apu Kesu, “Á nu papanáwak kami, anugutam mu laguk ta umay kami tullung táne ira bábi,” kud da. ");
INSERT INTO att_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Á “Umay kayin!” kun ni Apu Kesu nira. Á dagarágâ nánaw ira laguk sù ira duá nga lálláki, á minay ira simillung sù ira aru nga bábi. Á nakkarerá ngámin yù ira bábi nga minutù nga nappángè ta danum, á nalaggabán ira, á natay ira ngámin. ");
INSERT INTO att_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Á gapu ta kunnian yù nesimmu sù ira bábi, á nattálaw yù ira nga minánnaron ta bábi. Á nakkakarerá ira nga nanoli ta ili, á iniparámak da yù ngámin nga nesimmu sù ira bábi ánna yù kapammapiá nayù ira duá nga lálláki nga nagunagán nayù ira anitu. ");
INSERT INTO att_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Á yáyù nga minay yù ira ngámin nga magili nga jiminápun kâ Apu Kesu ta aggik na bebay, á nakimállà ira kuna ta panawán na lábbì yù giád da. ");
INSERT INTO att_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Á gapu ta manakì yù ira tatolay kâ Apu Kesu, nappittà di Apu Kesu ta barangay, á nánaw ira nga nanoli ta dammáng, sù ili na. ");
INSERT INTO att_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Á labbè da tán, minay kâ Apu Kesu yù ira tatolay, nga nangáttu sù kabbulud da nga nagiddá nga kun na natay yù baggi na. Á pakasingan ni Apu Kesu nira, nánnámmuán na ta ajjan yù pangikatalà da kuna. Á yáyù nga kinagi na sù tolay nga nagiddá, “Anâ ku, pálappawam mu yù nonò mu, ta napakomángin yù ira liwiliwâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Á ajjan tán yù ira mangituddu ta tunung. Á pakaginná ra sù kinagi ni Apu sù tolay nga natay yù baggi na, kagiad da ta nonò da, “Narákè yian! Ngattá ta magubobuk yane tolay nga kun na aggina si Namarò!” kud da. ");
INSERT INTO att_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Á ammu ni Apu Kesu yù ninononò da, á kinagi na nira, “Ngattá, ta nononopan naw yù narákè nikán? ");
INSERT INTO att_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anni panò yù ikáyâ naw nga kagiak ku nakuan sù tolay nga kun na natay yù baggi na? Ta mabbábáng kayu megapu sù kinagì kuna nga, ‘Napakomángin yù ira liwiliwâ mu.’ Á nu kuk ku lâ, ‘Gumikkáng ka, apam mu yù dapam mu, á mallakák ka,’ manguruk kayu panò? ");
INSERT INTO att_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Á yaw laguk yù akkuák kin, tapè kánnámmuán naw ta sikán nga Kaká na ngámin na tatolay yù makáwayyá saw dabbuno nga mamakomá ta liwiliwâ na tatolay,” kun na. Á nallipay laguk si Apu Kesu, á kinagi na sù tolay nga kun na natay yù baggi na, “Gumikkáng ka laguk, á akkatam mu yù ággiddám mu, á mánaw ken nga manoli ta balem,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Á kinuruk nayù tolay yù kinagi na, á giminikkáng, á nanoli ta bale na. ");
INSERT INTO att_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Á pakasingan nayù ira magaru nga tatolay ta nammapiángin yù kabbulud da, napállâ ira, á nepallà yù assing da. Á nakimoray ira kâ Namarò gapu ta iniyawâ na ta tolay yù kunnian nga pakáwayyá na. ");
INSERT INTO att_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Á nánaw si Apu Kesu laguk tán nga lugár. Á pakalakalakák na, nasingan na si Mattiu, nga mináttuki ta buwì, nga nagitubang sù áttarabakuán na. Á kinagi ni Apu kuna, “Tuttulam mà,” kun na. Á kinuruk ni Mattiu, á gimikkáng, á siminuttul kuna. ");
INSERT INTO att_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Á minay laguk di Apu Kesu ta bale ni Mattiu, tapè mepakkákán ira. Á aru yù ira káruán nga mináttuki ta buwì ánna yù ira káruán nga minálliwâ sù tunung da nga minay gapay nga mepakkákán kári Apu Kesu ánna yù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Á ajjan gapay tán yù ira Parisio. Pakasingad da ta mepakkákán di Apu Kesu sù ira kábulud di Mattiu, kinagi ra sù ira sinudduán ni Apu, “Ngattá, ta mepakkákán yù mesturu naw sù ira mináttuki ta buwì ánna yù ira káruán nga minálliwâ ta tunung tam?” kud da. ");
INSERT INTO att_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Á pakaginná ni Apu Kesu sù iniyabbû da, simibbák nga nagángngarigán, á kinagi na nira, “Ari yù ira nga napiá yù gawagawáyád da yù magáwák ta minángnguru, nu ari galâ yù ira máttakì. ");
INSERT INTO att_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Á yáyù nga minayà saw dabbuno. Ta arák ku agálán yù ira nga makkagi ta napiá ira, nu ari galâ yù ira nga ammu ra ta ajjan yù liwâ da. Á sikayu, umay kayu laguk ánna gigiámmuan naw yù kebalinán na yaw nga napiá nga bilin ni Namarò nga netúrâ nga kunniaw: ‘Yaw karagaták ku, ari yù pangiyátáng na tolay nikán, nu ari galâ yù pangikállà da sù ira kábulud da.’ Á mássiki nu tuppálan naw yù tunung, awán ta serbi na nu awán ta pangikállà naw sù ira kábulun naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Á kabalin na nakiubobuk ni Apu Kesu sù ira Parisio, minay kuna yù ira makituddu kâ Kuan nga Minánnigù. Á kinagi ra, “Ngilinam mi yù ággaw nga arám mi pakkákán, nga kunnay gapay sù ira Parisio. Ngam yù ira tudduám mu, anni má ta arád da ngilinan yù kustombare mi nga ari kumán?” kud da. ");
INSERT INTO att_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Á nagángngarigán si Apu Kesu, á iniyárik na yù ira tudduán na sù ira makibodá. Á kinagi na, “Maraddam panò yù ira makibodá nu ajjan nira yù nobiu? Ari gemma! Ngam sangaw nu mepánaw yù nobiu nira, á yáyù sangaw yù pangilid da sù ággaw nga arád da pakkákán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Á nagángngarigán má si Apu Kesu nira, tapè ipakánnámmu na ta ari metádday yù bagu nga ituddu na sù dán nga kustombare ra. Á kinagi na, “Awán gemma ta tolay nga magappíl ta bagu sù dán nga gámì, gapu ta nu mabábbalán sangaw, á kuddan yù bagu, á mappanà yù pisil nayù gámì. ");
INSERT INTO att_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Á ta kunnian gapay, nu mappadday ira ta binaráyáng, awán ta tolay nga mangipay ta bagu nga tabbuk na úbas sù dán nga ággianán na nga tabbì. Ta nu dán nga tabbì yù payyád da, á nataggâ garè nga mabì lâ mabattâ sangaw, á metabbà yù binaráyáng ánna kengá lággapay yù naggianán na nga tabbì. Á yáyù nga ipe tam laguk yù bagu nga binaráyáng sù bagu nga ággianán na, tapè lumánnâ sangaw yù tabbì ánna ari mabattâ, á mapakappián yù binaráyáng gapay.” ");
INSERT INTO att_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Á sù arán na paga kabalin ni Apu Kesu nga nagubobuk, jimikkì kuna yù Kudio nga makáwayyá nga mammaguray, nga namalittúkak sù arubáng na. Á kinagi na, “Ikállà mà bíkay, ta kapáppate na lâ nayù anâ ku nga magingánay! Em mu bì támmitan, tapè matolay,” kun na. ");
INSERT INTO att_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Á pakaginná ni Apu Kesu, limikkâ nga nepulù sù mammaguray. Á nepulù nira gapay yù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Á ajjan gapay tán yù babay nga mapulu duá nga dagun yù papparaparága na. Á jimikkì ta likuk ni Apu Kesu, á siniggek na yù kiddanán nayù barawási na, ");
INSERT INTO att_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","gapu ta kinagi na ta nonò na, “Mássiki nu yù barawási na lâ yù masiggek ku, mammapiángakin,” kun na. ");
INSERT INTO att_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Á pakánnámmu ni Apu Kesu ta ajjan yù naniggek kuna, nallipay, á nasingan na yù babay. Á kinagi na, “Pataggatam mu yù nonò mu, Anâ ku, ta nammapiá ken megapu sù pangikatalà mu nikán,” kun ni Apu. Á dagarágâ nammapiángin yù babay. ");
INSERT INTO att_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Á pakáddè di Apu Kesu sù bale nayù mammaguray, nasingan ni Apu yù ira mináppaláwatá ánna yù ira aru nga mepaddaddam nga matarabiángál. ");
INSERT INTO att_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Á kinagi na nira, “Mánaw kayin ngámin, ta ari natay yù abbing, nu ari lâ nakkaturuk,” kun na. Á yáyù nga inipappagalà da si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Á pamalawán ni Apu Kesu nira, simillung sù gián nayù magingánay, á singngalán na yù limá na. Á panangngal ni Apu Kesu sù limá na, gimikkáng nga nammapiángin. ");
INSERT INTO att_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Á neparámak dannian sù ngámin nga ili ta lugár da. ");
INSERT INTO att_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Á kabalin ni Apu Kesu nga namammapiá sù magingánay, nánaw sù giád da. Á pakalakalakák na ta dálan, siminuttul yù duá nga lálláki nga buling, á inikatakatol da, “Ikállà kami, sikaw nga Ginaká ni Patul Dabid,” kud da. ");
INSERT INTO att_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Á manganánnuán, nakáddè di Apu Kesu sù pakipaggianád da. Á tallung ni Apu sù unak na balay, simillung gapay yù ira duá nga buling nga jimikkì kuna. Á iniyabbû ni Apu Kesu nira, “Kurugan naw panò nga makáwayyángà nga manuppál sù ipakimállà naw?” kun na. “Wan, Apu,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Á yáyù nga sinámmì ni Apu yù matá nayù ira buling, á kinagi na nira, “Mapalurò laguk nga kunnay sù pangikatalà naw nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Á pagubobuk ni Apu, dagarágâ nga nakasingan iren. Á sinaddánán ni Apu ira, nga kinagi na, “Arán naw bulubugá kagian yaw nga nesimmu nikayu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngam nánaw ira, á ed da iniparámak yù ngámin nga meyannung kâ Apu Kesu sù ira ngámin nga tatolay ta lugár da. ");
INSERT INTO att_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Á kapapáno nayù ira duá nga lálláki nga napammapiá, iniyánge nayù ira tatolay kâ Apu Kesu yù laláki nga umal megapu sù nattaliponak nga anitu. ");
INSERT INTO att_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Á pinapáno ni Apu yù anitu kuna, á nagubobugin yù tolay. Á napállâ yù ira tatolay nga ajjan tán, á nakkaká-ubobuk ira, á kinagi ra, “Awán bulubugá ta nakasingan paga ta kunniaw sù giát tam nga Israel!” kud da. ");
INSERT INTO att_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngam yù ira Parisio, kinagi ra, “Si Satanas nga yápu nayù ira anitu yù paggapuán nayù pakáwayyá na nga mamapánaw sù ira anitu,” kud da. ");
INSERT INTO att_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Á minay si Apu Kesu sù ngámin nga ili ánna ngámin nga babálay, nga mangituddu sù ira tatolay ta iskuelá ra, ánna nangilayalayâ sù napiá nga dámak nga meyannung sù pammagure ni Namarò. Á pinammapiá na yù ira tatolay sù ngámin nga takitad da ánna ngámin nga tulágad da. ");
INSERT INTO att_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Á pakasingan na sù ira magaru nga tatolay, nerallà yù allà na sù ira ngámin, gapu ta nakállállà ira, negapu sù karigirigâ da, á kunnay ira ta karneru nga awán ta manaron nira. ");
INSERT INTO att_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Á kinagi na laguk sù ira sinudduán na, “Aru yù ira tatolay nga ari manguruk, nga meyárik sù magaták. Ngam nakúráng yù ira umay maggaták. ");
INSERT INTO att_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Makimállà kayu laguk nga makkiddaw sù makákkuá sù ákkomanán, ta doban na bì yù ira umay maggaták sù ákkomanán na,” kun na. Á yù ira maggaták yù keyarigán nayù ira mangituddu sù bilin ni Namarò, tapè mesipà kuna yù ira tatolay nga magginná. ");
INSERT INTO att_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Á kabalin na, inagálán na laguk ni Apu Kesu yù ira mapulu duá nga sinudduán na, á iniyawâ na nira yù pakáwayyá ra nga mamapánaw ta anitu ánna yù pakáwayyá ra gapay nga mamammapiá ta tatolay sù ngámin nga takitad da ánna ngámin nga tulágad da. ");
INSERT INTO att_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Á danniaw yù ngágan nayù ira mapulu duá nga tudduán na. Napolu di Simon nga mangngágan gapay ta Eduru ánna si Andares nga wagi na. Á di Ime kâ Kuan, nga mawwagi nga ánâ ni Sebedo. ");
INSERT INTO att_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Á di Pilippi kâ Bartolome, di Tomâ kâ Mattiu nga mináttuki ta buwì, á si Ime nga anâ ni Alpio, ánna si Tajjio. ");
INSERT INTO att_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Á si Simon nga netádday sù ira Mengal, ánna si Kudas nga Iskariote, nga nangituddu kâ Apu Kesu sù ira minay naggápù kuna. ");
INSERT INTO att_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Á danniaw nga mapulu duá yù jinok ni Apu Kesu, ta umay ira mangipakánnámmu sù meyannung kuna. Á lage ra nánaw, kinagi ni Apu Kesu nira, “Ari kayu umay sù gián nayù ira tatolay nga ari Kudio, á ari kayu tullung sù ira ili na Samaria. ");
INSERT INTO att_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Umay kayu galâ sù gián nayù ira kagittá tam nga ginaká ni Israel, ta kunnay ira ta náwáwán nga karneru. ");
INSERT INTO att_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Á ta ngámin nga labbetán naw, yá ilayalayâ naw, ‘Duttálin nikayu yù pammagure ni Namarò,’ kun naw. ");
INSERT INTO att_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Á iyawâ ku nikayu yù pakáwayyá naw, tapè pammapián naw yù ira máttakì, á paginnanolayan naw yù ira nga natay, ánna pammapián naw yù ira naggoggong ánna nabbuni. Á papanáwan naw yù ira anitu. Á gapu ta arán naw gemma pinagán yù pakáwayyá naw nga iniyawâ ku nikayu, yáyù nga arán naw laguk ipapagá sù ira tatolay nga abbágán naw. ");
INSERT INTO att_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Á nu mánaw kayu, arán naw ipulù yù kuártu. Mássiki nu sinsilliu, arán naw ibolsá. ");
INSERT INTO att_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Á ari kayu gapay bulubugá mangárgá ta magamaguray, mássiki nu barawási onu sapátù onu tagukuk, ta mepángngà nga iyawâ da nikayu nayù ira abbágán naw yù ngámin nga máwák naw. ");
INSERT INTO att_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Á nu lubbè kayu ta ili onu babálay, aleran naw yù napiá nga tolay nga magayáyâ nga mamaddulò nikayu, á makipaggián kayu kuna áddè ta páno naw tán nga lugár. ");
INSERT INTO att_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Á tallung naw sù bale na, bindisionán naw yù ira nga maggián tán. Kagian naw nira, ‘Mepagimammà kayu kâ Namarò,’ kun naw. ");
INSERT INTO att_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Á nu magayáyâ ira nga mamaddulò nikayu, á kuruk nga abbágán na ira ni Namarò megapu sù pamindision naw nira. Ngam nu manakì ira nga mangálliuk nikayu, arán na ira abbágán ni Namarò, nu ari sikayu galâ yù abbágán na. ");
INSERT INTO att_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Á maguray lâ nga ili onu balay nga angayán naw, nu awán ta tolay nga mangálliuk nikayu sangaw onu manakì ira nga magginná sù ituddu naw, panawán naw ira laguk. Á pápparán naw yù káppù ta takki naw, nga panákkilalán ta panakì da. ");
INSERT INTO att_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Á kuruk yawe nga kagiak ku nikayu. Sinuggi na ngaw ni Namarò yù ngaw ira ili na Sodoma ánna Gomorra gapu ta karákè nayù ira tatolay nga naggián nira. Á sangaw nu duttál yù ággaw nga pangukum ni Namarò, aláppaw yù ámmagikáru na sù ira tatolay nga taga Sodoma ánna taga Gomorra ánnè sù ámmagikáru na sù ira tatolay nga manakì nga magginná sù ituddu naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Á inupù ni Apu Kesu nga kinagi nira, “Tángngagan naw yaw nga kagiak ku nikayu. Dobat takayu, nga kun na nasippà nga karneru, nga umay sù ira tatolay nga kun na simaron nga ítu, nga mapporay ánna makánnanássing. Magimuguk kayu laguk nga kun na iráw, ánna massippà kayu gapay nga kun na kalapáti. ");
INSERT INTO att_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mappalán kayu, ta ajjan yù ira maggápù nikayu sangaw, á iyarubáng da kayu sù ira mamanunnù. Á palapaligatad da kayu ta arubáng nayù ira tatolay ta paggagammung da sù kapilliá ra. ");
INSERT INTO att_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Á gapu ta panuttul naw nikán, iyánge ra kayu nayù ira malussaw ta arubáng nayù ira mammaguray, nga gubinador ánna patul. Á yáyù awayyá naw nga mangipakánnámmu sù napiá nga dámak nga meyannung nikán sù ira mammaguray ánna yù ira gapay nga ari Kudio. ");
INSERT INTO att_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Á sangaw nu bisítád dakayu, arán naw laguk ikaburung nu anni yù kagian naw nira ánna kunnasi yù ággubobuk naw, ta mepakánnámmu ta nonò naw yù kagian naw nira. ");
INSERT INTO att_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta ari sikayu nu ari galâ yù Ikararuá nayù Yáma naw ta lángì yù mamagubobuk nikayu,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Á pagubobuk ni Apu Kesu, kinagi na gapay, “Á sangaw nu duttál yù ággaw nga jigâ, ipagápù nayù ira tatolay yù ira wáwwagi ra, nga ipapátay. Á kunnian gapay sangaw yù akkuán nayù ira yáma sù ira ánâ da. Á potuán nayù ira ábbing yù ira yáma ra ánna ipagápù da yù yáma ra sù ira mamapátay nira. ");
INSERT INTO att_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Á sikayu nga manguruk nikán, ikalusso nakayu nayù ira tatolay gapu ta pangikatalà naw nikán. Ngam meyígù sangaw yù ira ngámin nga mangiyattam sù jigâ ánna mapasigaggà yù ángngikatalà da nikán ta áddè ta pagáddekán. ");
INSERT INTO att_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Á nu jigirigátad da kayu sù tádday nga ili, mattálaw kayu laguk nga umay makiyígù ta tanakuán nga ili. Á kukurugán nga kuruk yù kagiak ku nikayu. Arán naw sangaw paga mabalin nga umay sù ira ngámin nga ili na Israel nga mangilayalayâ sù bilik ku pángè ku má lubbè ta dabbuno, sikán nga Kaká na ngámin na tatolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Á kinagi ni Apu Kesu gapay nira, “Ari motun yù makituddu sù mesturu na. Á kunnay gapay sù aripan, ari motun sù yápu na. ");
INSERT INTO att_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Á yáyù nga makáppak nakuan yù makituddu, nu mepaggittá sù mesturu na. Á kunnian gapay sù aripan, nu mepaggittá sù yápu na. Á nu pakkakagiád dangà, ánna ingágad dangà ta Belsebul nga patul na anitu, á kunnasi panò yù pakkakagi ra nikayu nga mesipà nikán!” ");
INSERT INTO att_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Á kinagi ni Apu Kesu, “Ari kayu laguk maganássing sù ira tatolay, ta awán ta ituttù da nga ari sangaw mepalappâ, á awán gapay ta ilímak da nga ari gapay sangaw mepakánnámmu. ");
INSERT INTO att_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Á yù nelímak nga ipakánnámmù nikayu sangaw nu gabingin, yáyù ubobugan naw sù ira tatolay sangaw nu manawák. Á kunnian gapay sù meyanasâ ta talingá naw tapè awán ta tanakuán nga makaginná, yáyù ilayalayâ naw nga kun na ajjan kayu ta utun na balay nga makkatakatol, tapè maginná nayù ira ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Á ari kayu maganássing sù ira nga mamapátay ta baggi naw lâ, gapu ta arád da makuá yù ikararuá naw nga mannanáyun. Si Namarò galâ yù ikássing naw, ta aggina yù makáwayyá nga mangnguá ta baggi na tolay ánna ikararuá na gapay sù mannanáyun nga api ta impiernu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Á ta meyannung sù ángngiddù ni Namarò, kinagi ni Apu Kesu, “Ari panò tádday lâ nga pirâ yù pagá na duá nga ballì? Á mássiki nu kunnian, awán bulubugá ta mapannâ ta dabbun nga natay, mássiki lâ tádday nira, nu arán na anugutan nayù Yáma naw ta lángì. ");
INSERT INTO att_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Á nu kunnian yù ángngiddù na nira, nepatalugáring nikayu, ta ammu na ngámin nga meyannung nikayu, mássiki yù biláng na duddù sù ulu naw nga katággitádday. ");
INSERT INTO att_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Á yáyù nga ari kayu maganássing, ta kuruk nga dakal yù ángngiddù ni Namarò nikayu ánnè sù ángngiddù na ta aru nga ballì,” kun na. ");
INSERT INTO att_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Á namappalán si Apu Kesu, á kinagi na, “Á yù ira nga makkagi ta pakiyápu ra nikán ta arubáng na tatolay, aggira gapay yù kagiak ku kâ Ammò ku ta lángì. ");
INSERT INTO att_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngam yù ira mappasirán ta arubáng na tatolay megapu nikán, arák ku ira gapay tákkilalán ta arubáng ni Ammò ku ta lángì,” kun na. ");
INSERT INTO att_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Á kinagi ni Apu Kesu, “Arán naw laguk kagian ta yá iniyángè sawe dabbuno yù pamagimammà ku sù ira maddaráma. Ari kunnian yù iniyángè saw nu ari galâ yù ipaddaráma ra, ta ajjan garè yù ira nga ari manguruk nikán. ");
INSERT INTO att_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Á gapu ta ari ira metádday nikán, yáyù nga makikontará yù abbing nga laláki sù yáma na, ánna yù abbing nga babay sù yená na, ánna yù manugáng nga babay sù katugángán na nga babay. ");
INSERT INTO att_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Á yù ira kanakanáyun na tolay yù malussaw kuna. ");
INSERT INTO att_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Á yù tolay nga nepallà yù ángngayâ na sù yáma na onu yená na ánnè sù ángngayâ na nikán, ari mepángngà nga mepulù nikán. Á yù tolay nga nepallà yù ángngayâ na sù anâ na ánnè sù ángngayâ na nikán, ari nga mepángngà nga mepulù nikán. ");
INSERT INTO att_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Á ari gapay mepángngà nga mepulù nikán yù tolay nga ari magiyangngà sù panigirigâ da kuna nayù ira ari nanguruk, mássiki áddè ta pate na megapu sù panguruk na nikán. Á yaw keyarigán na yù tolay nga ari mangáttu ta kurù na, nga ari tumuttul nikán. ");
INSERT INTO att_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Á yù tolay nga mangiddù sù áttole na sawe dabbuno, lonán na yù pangisipà ku kuna ta áddè ta áddè. Ngam yù tolay nga lonán na yù áttole na sawe dabbuno gapu ta panguruk na nikán, málawâ na sangaw yù mannanáyun nga áttole na gapu ta mesipà nikán ta áddè ta áddè,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Á kinagi na gapay ni Apu Kesu, “Á yù ira nga mamaddulò nikayu nga manguruk nikán, á kunnay ta sikán gapay yù paddulotad da. Á yù ira nga mamaddulò nikán, á kunnay ta paddulotad da gapay yù Yámà nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Á yù ira nga mamaddulò ta ábbilinák ku gapu ta sikán yù nangibilin kuna, á málawâ da gapay sangaw yù bálà da nga kunnay sù pabbalabálà ni Namarò gapay sangaw sù ábbilinán na. Á kunnian gapay sù ira nga mamaddulò sù napiá nga tolay gapu ta tákkilalád da ta matunung megapu sù panguruk na nikán, málawâ da gapay sangaw yù bálà da nga kunnay sù pabbalabálà ni Namarò gapay sangaw sù matunung nga tolay nga manguruk nikán. ");
INSERT INTO att_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Á yù tolay nga mangiyawâ ta mássiki lâ tangabásu nga danum sù tádday nga abbing nga makiaripan nikán, gapu ta mánnámmuán na ta aggina yù manguruk nikán, á bálatan na sangaw ni Namarò gapay ta napiá,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Á kabalin ni Apu Kesu nabbilin sù ira mapulu duá nga sinullà na, nánaw nga minay sù ira káruán nga ili nga aranni, tapè mangituddu ánna mangilayalayâ sù ira tatolay tán. ");
INSERT INTO att_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Á ajjan si Kuan nga Minánnigù nga napukù sù ábbalurán. Á pakarámak ni Kuan sù kingngikingnguá ni Apu Kesu, jinok na yù ira sinudduán na nga umay sù gián ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Á yáyù nga ed da iyabbû kâ Apu Kesu, nga kud da, “Apu, sikaw panò yù iddagám mi nga duttál nga naggapu kâ Namarò, nga kunnay sù inilayalayâ ni Kuan? Onu iddagám mi nakuan yù tanakuán?” kud da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Á simibbák si Apu Kesu nira, á kinagi na, “Manoli kayu, ta en naw kagian kâ Kuan yù ngámin nga naginná naw ánna yù nasingan naw saw giák ku. ");
INSERT INTO att_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kagian naw kâ Kuan ta makasinganin yù ira buling. Makalakárin yù ira pilay. Nammapiángin yù ira naggoggong ánna yù ira nabbuni. Makaginnángin yù ira kitul. Á maginnanolay yù ira natay, ánna melayalayâ yù napiá nga dámak sù ira pobare. ");
INSERT INTO att_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Á mapagayáyâ yù tolay nga ari mabbábáng ta meyannung nikán, ta mammapiá yù ággián na sangaw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Á sù páno nayù ira sinudduán ni Kuan, nakiubobuk si Apu Kesu sù ira magaru nga tatolay ta meyannung kâ Kuan. Á iniyabbû na nira, “Anni yù inikáyâ naw nga iningan sù ánge naw ngaw túrin ta kalállammatán? En naw panò iningan yù tolay nga ajjan yù nonò na nga kun na kaddà nga pagguyuguyuan na paddák? Ari gemma! ");
INSERT INTO att_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Á anni laguk yù en naw iningan? En naw panò iningan yù tolay nga nabbísti ta nakástá? Ari gemma, ta maggián ta dakal nga bale na patul yù tolay nga nabbísti ta kunnian. ");
INSERT INTO att_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Á anni laguk yù en naw iningan, nu ari galâ yù ábbilinán ni Namarò! Wan! Á kuruk yù kagiak ku nikayu, ta si Kuan yù kátannangán nga ábbilinán nga awán bulubugá ta meyárik kuna. ");
INSERT INTO att_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta aggina yù ubobugan ni Namarò sù dán nga netúrâ nga kunniaw: ‘Yawe yù ábbilinák ku nga dobak ku ta mapolu ánnè nikaw, tapè paránan na yù dálan nga pallakarám mu sangaw.’ ");
INSERT INTO att_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Á kuruk yawe nga kagiak ku nikayu; awán ta tolay nga neyanâ sawe dabbuno nga makáwayyá ánnè kâ Kuan nga Minánnigù. Ngam yù kagukábán nga tolay nga mesipà sù pammagure ni Namarò, aggina yù makáwayyá ánnè kuna. ");
INSERT INTO att_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Á áddè ngaw ta pamegapu na nga nangilayalayâ ni Kuan nga Minánnigù, ta áddè kunangan, makkaragâ yù ira magaru nga tatolay nga mesipà sù pammagure ni Namarò. Á yù ira nasikan nga mapattû, puersád da nakuan yù kesipà da sù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Á áddè ngaw ta áddè kunangan nepakánnámmu yù meyannung sù pammagure ni Namarò nga duttál ta dabbuno megapu ta yù pangilayalayâ da ngaw nayù ira ngámin nga ábbilinán ni Namarò ánna yù tunung ni Moyses, ánna yù pangilayalayâ na gapay ni Kuan nga Minánnigù. ");
INSERT INTO att_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Á nu ikáyâ naw manguruk sù kinagi ra, si Kuan yù ngaw Elias nga kinagi ra nga duttál mángin. ");
INSERT INTO att_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sikayu nga makaginná, tángngagan naw laguk yù naginná naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Á kinagi na gapay ni Apu Kesu, “Kunnasi panò yù pangiyarigák ku nikayu nga ginaká ni Israel ta ággawo? Ari kayu bulubugá makáppak, á yaw lâ ammu naw yù mamaliwâ. Kunnay kayu ta ábbing nga makkukkul ta dápun, nga áppè mabbodá ánna áppè magitanam. Á makkatakatol ira sù ira kábulud da, á kagiad da nira, ");
INSERT INTO att_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ngattá, ta naggássá kami, ngam manakì kayu mattála? Á nakkansion kami ta makaraddaddam, ngam manakì kayu gapay nga mepattatádday nikami nga matarabiángál?’ ");
INSERT INTO att_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Á sikayu, kunnay kayu sù ira ábbing, ta ari kayu makáppak. Ta minay si Kuan ngam baddì lâ yù akkákán na ánna ari bulubugá namissán. Ngam kagian naw ta nagunagán na anitu. ");
INSERT INTO att_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Á sikán nga Kaká na ngámin na tatolay, minayà nepakkákán ánna nepaginum sù ira tatolay. Á kagian naw laguk, ‘Ye, masingan naw yù tolay nga nabukátù ánna minámmissán, nga makikopun sù ira massuítì nga mináttuki ta buwì ánna yù ira káruán nga minálliwâ!’ Á awán ta awayyá mi kâ Kuan nga mamagayáyâ nikayu. Ngam mepasingan ta kuruk nga masírik nga naggapu kâ Namarò yù ituddu mi, megapu sù akka-akkuám mi ánna yù ira manguruk nikami,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Á kabalin ni Apu Kesu nakkagi karannian, pinegapuanán na nga pinappalán yù ira tatolay nga naggián sù tallu nga ili nga pangipasinganán na ngaw ta aru nga pinagaddátu na nga makapállâ. Ta mássiki nu nakasingan yù ira tatolay sù ira makapállâ nga pinagaddátu na sù ili ra, arád da inibabáwi yù liwiliwâ da. ");
INSERT INTO att_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Á kinagi na nira, “Kábbi kayu lâ. Makállállà kayu sangaw, sikayu nga taga Korasin! Ánna sikayu nga taga Betseda, makállállà kayu gapay! Ta nu inipasingak ku nakuan yù pagaddatuak ku nga makapállâ sù ira ngaw nakaliwâ nga taga Tiro ánna taga Sidon, nga kunnay sù pinagaddátù nga inipasingak ku nikayu, nabbabáwi nakuan yù ngaw ira ngámin nga tatolay ta nabayágin, á inipasingad da nakuan yù pabbabáwi ra megapu sù pabbarawási ra ta bayon ánna pagitubang da ta abu, nga kunnay sù kustombare ra. ");
INSERT INTO att_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Á kagian naw ta sangaw nu ukuman ni Namarò ira, narámmà yù pamagikáru na nira gapu ta kitarákè yù kingngikingnguá ra. Ngam yawe yù kagiak ku nikayu, ta mappanà yù ággián naw ánnè sù ággiád da nga taga Tiro ánna taga Sidon sangaw nu duttál yù pangukum ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Á sikayu gapay nga taga Kapernium, ikáyâ naw panò ta meparáyaw kayu ta lángì? Ngam ari mesimmu, gapu ta yá labbetán naw sangaw garè yù api ta impiernu nga mannanáyun. Ta nu mepasingan nakuan sù ngaw ili na Sodoma yù makapállâ nga kunnay sù pinagaddátù ta gián naw, maggián lâ paga nakuan yù ili na Sodoma. ");
INSERT INTO att_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Á kuruk yù kagiak ku nikayu, ta sangaw nu duttál yù pangukum ni Namarò ta tatolay, mappanà yù ággián naw ánnè sù ággiád da nga taga Sodoma, nga neparámak megapu sù karákè da,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Á ta kabalin ni Apu Kesu namappalán sù ira tatolay, nakimállà laguk sù Yáma na. Á kinagi na, “Ammò, dayáwat taka, nga Yápu na ngámin nga ajjan ta lángì ánna ngámin nga ajjan ta dabbuno. Á dayáwat taka gapu ta inipakánnámmum yù kuruk nga bilim mu sù ira nga kun na abbing nga tumulù, ngam inilímak mu sù ira nga kagiad da ta nasírik ira ánna naggigiámmu. ");
INSERT INTO att_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wan gemma, Ammò, ta yáyù gemma yù ikáyâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Á kabalin na nakimállà ni Apu Kesu kâ Yáma na, kinagi na sù ira tatolay, “Inikárgu nayù Yámà nikán yù ngámin nga ajjan ta lángì ánna dabbuno. Á awán ta makánnámmu nikán nga Anâ na nu ari galâ si Namarò nga Yámà. Á kunnian gapay nga awán ta makánnámmu sù Yámà, nu ari galâ sikán nga Anâ na ánna yù ira gapay nga ikáyâ ku nga pangipakánnámmuán kuna. ");
INSERT INTO att_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Á sikayu ngámin nga nabannák ánna marigirigâ, e kayu nikán, ta pagibannagat takayu. ");
INSERT INTO att_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Á tuppálan naw yù ipakuâ nikayu ánna gigiámmuan naw yù ituddù nikayu. Ta sikán yù masippà nga minángngabbák nikayu. Á mepagimammà kayu sangaw nikán. ");
INSERT INTO att_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta malogon nga matuppál yù ipakuâ nikayu, ánna pakálappawak ku yù jigâ naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Á ta ággaw na Sabadu, nga pagibannák da, nallakalakák di Apu Kesu, nga nattalebák sù komán nga namulán ta tarígu. Á nabisin yù ira kábulun ni Apu Kesu nga makituddu kuna. Á yáyù nga inâ da yù nataggatán nga dáwa na tarígu, nga binussilád da ta kanad da. ");
INSERT INTO att_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Á ajjan gapay tán yù ira Parisio, nga sigídá massísim. Á pakasingad da sù kingnguá nayù ira kábulun ni Apu, kinagi ra kâ Apu Kesu, “Masingam mu yù akka-akkuán nayù ira tudduám mu, ta potuád da yù tunung tam sù pamussil da ta tarígu ta ággawo nga pagibannák tam,” kud da. ");
INSERT INTO att_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Á kinagi ni Apu Kesu nira, “Arán naw panò binibbik yù dán nga netúrâ nga meyannung sù kingnguá na ngaw ni Patul Dabid ta kabisid da ánna yù ira kábulun na? ");
INSERT INTO att_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Simillung si Dabid sù bale ni Namarò, á inâ na yù pán nga neyátáng kâ Namarò. Á yáyù kinád di Dabid ánna yù ira kábulun na, nga mekontará sù tunung tam, ta kagian nayù tunung ta awán ta makáwayyá nga kumán sù neyátáng kâ Namarò nu ari lâ yù ira pári. ");
INSERT INTO att_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Á arán naw panò binibbik yù tunung nga initúrâ ni Moyses nga meyannung ta pakimore nayù ira pári kâ Namarò sù mangilin nga bale ni Namarò? Kinagi na ta kunnay ta makaliwatád da yù ággaw nga ággibannák da ta káda Sabadu, megapu sù passerbi ra kâ Namarò ta unak nayù mangilin nga bale na, ngam ari mebiláng ta liwâ da. ");
INSERT INTO att_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ginnán naw yawe nga kagiak ku nikayu. Ajjan saw yù kapiánán nga passerbián naw nakuan ánnè sù mangilin nga bale ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Binibbik naw gemma yaw, ‘Yawe karagaták ku, nga ari yù pangiyátáng naw nikán nu ari galâ yù pangikállà naw sù ira kábulun naw.’ Á nu nánnámmuán naw nakuan yù kebalinán na, arán naw nakuan paliwatan yù ira awán ta liwâ da. ");
INSERT INTO att_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta sikán lâ nga Kaká na ngámin na tatolay yù makáwayyá nga makkagi sù mepángngà nga akkuán naw ta Sabadu, nga ággibannák,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Á kabalin ni Apu Kesu nakiubobuk sù ira Parisio, nánaw nga minay sù iskuelá, nga ággagammungád da. ");
INSERT INTO att_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Á ajjan tán yù tolay nga nassesseng yù tádday nga limá na. Á ajjan gapay yù ira káruán nga malussaw kâ Apu Kesu, á sinissimmurád da gapu ta alerad da yù awayyá ra nga mangikeká kuna. Á yáyù nga iniyabbû da kuna, “Ari panò makaliwâ yù tolay sù tunung nu pammapián na yù matakì ta ággaw na Sabadu?” kud da. ");
INSERT INTO att_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Á kinagi ni Apu Kesu nira, “Á ta ángngarigán, nu ajjan yù karneru naw nga napannâ ta abbû ta ággaw na Sabadu, arán naw panò umay igon? ");
INSERT INTO att_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Á nepatalugáring sù tolay, ta napanapiá gemma yù tolay ánnè sù ayám! Á yáyù nga iyanugù nayù tunung yù napiá nga akkuán na tolay ta ággaw na ággibannák.” ");
INSERT INTO att_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Á kabalin ni Apu Kesu nanabbák karanniaw, nallipay laguk sù tolay nga nassesseng yù limá na, á kinagi na kuna, “Sonnatam mu yù limám,” kun na. Á sinonnâ nayù tolay yù limá na, á nammapiángin nga kunnay sù tádday nga limá na. ");
INSERT INTO att_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ngam yù ira Parisio, pakasingad da ta nammapiá yù limá na, nánaw ira, á ed da nakkaká-ubobugan nu kunnasi yù ámmapáte ra kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Á gapu ta ammu ni Apu Kesu yù pangigagánge nayù ira Parisio kuna, nánaw sù lugár. Á aru yù ira tatolay nga dumaddáddán kuna, á pinammapiá na yù ira ngámin nga máttakì. ");
INSERT INTO att_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Á kinagi na nira ta arád da bulubugá ipakánnámmu sù ira ta tolay, ");
INSERT INTO att_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tapè matuppál yù kinagi ni Namarò nga inipeyubobuk na ngaw kâ Isaya, nga ábbilinán na, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yawe yù pinílì nga masserbi nikán. Aggina yù iddi-iddukak ku ánna ayatánà kuna. Á ipè kuna yù Ikararuâ. Á yáyù nga aggina yù mangilayalayâ ta meyannung sù taddák ku ánna yù pamanunnù ku sù ira ngámin nga tatolay, mássiki yù ira nga ari Kudio. ");
INSERT INTO att_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ari makiramá onu makkalli. Ari makalittang yù ággubobuk na ta kalsáda. ");
INSERT INTO att_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Masippà, á kábbian na yù ira marigirigâ ánna yù ira máttakì, ánna abbágán na yù ira nga magiddi-iddak kuna, áddè ta arán na pamalurò sù pamanunnù na nga matunung, ");
INSERT INTO att_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ánna umay kuna yù ira ngámin makkakerumá nga tatolay, gapu ta matákkilalád da ta aggina yù iddanamád da.” ");
INSERT INTO att_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Á kabalin na yaw, ajjan yù ira tatolay nga minay sù gián ni Apu Kesu, á iniyánge ra kuna yù laláki nga buling ánna umal gapay gapu ta nagunagán na anitu. Á pinammapiá ni Apu Kesu, tapè makobobuk ánna makasingan. ");
INSERT INTO att_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Á napállâ ngámin yù ira tatolay, á kinagi ra, “Yaw panò yù Ginaká ni Patul Dabid, nga kinagi nayù ira ábbilinán ni Namarò ta iddagát tam?” kud da. ");
INSERT INTO att_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngam yù ira Parisio, ta pakaginná ra sù kinagi nayù ira tatolay, á kinagi ra, “Si Belsebul nga yápu nayù ira anitu yù mangabbák kuna, tapè papanáwan na ira,” kud da. ");
INSERT INTO att_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Á ammu ni Apu Kesu yù nonopan nayù ira Parisio, á kinagi na nira, “Nu maddaráma yù ira tatolay nga maggián sù páppatulán, mapatalián sangaw yù patul da ánna massisinná yù ira tatole na. Á yù ira tangelián onu yù ira máttatáma ánna mássisíná, nu ari nakástá yù áttatádde ra, mewarawarâ ira. ");
INSERT INTO att_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Á nu papanáwan ni Satanas yù ira pinatuttul na nga anitu, kontarán na yù páppatulán na lápay. Á kunnasi panò laguk yù ámmaláddá na sù pammagure na nira? Awánin gemma! ");
INSERT INTO att_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Á nu kuruk nakuan yù kagian naw nga palawanak ku yù ira anitu megapu sù pakáwayyá ni Belsebul, á yù ira kábulun naw laguk, asinni panò yù paggapuán na pakáwayyá ra nga mamalawán ta anitu? Ari gemma naggapu kâ Belsebul. Á gapu ta naggittá yù paggapuán na pakáwayyá mi ánna yù ira kábulun naw, á yù ira kábulun naw sangaw yù mamanunnù nikayu. ");
INSERT INTO att_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Á gapu ta yù Ikararuá ni Namarò yù paggapuán nayù pakáwayyâ, mánnámmuán naw gapay laguk ta jimittálin nikayu yù pammagure ni Namarò,” kun ni Apu Kesu sù ira Parisio. ");
INSERT INTO att_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Á kun ni Apu Kesu paga, “Á ta ángngarigán, awán ta tullung nga magâ sù bale nayù masikan, nu arán na paga bináluk. Á kabalin na mamáluk, awayyá na apan yù ikáyâ na nga kukuá na. ");
INSERT INTO att_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Á yù tolay nga ari makipulù nikán, ikalusso nangà. Á kunnian gapay, yù tolay nga ari mangabbák nikán nga mangunnuk, mamawwarawarâ lállaguk sù ira tatolay nga unnurak ku nakuan. ");
INSERT INTO att_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Á yáyù nga kagiak ku nikayu ta mapakomá ngámin yù makaliwâ ánna magubobuk ta narákè, ngam ari mapakomá yù mamarákè sù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mapakomá yù magubobuk ta narákè nikán nga Kaká na ngámin na tatolay, ngam ari mapakomá yù magubobuk ta narákè sù Mangilin nga Ikararuá, mássiki kunangane nga ággaw, mássiki ta áddè noka nga ággaw nga duttál,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Á kinagi na paga ni Apu Kesu, “Á ta ángngarigán, nu ajjan yù napiá nga káyu, napiá gapay yù bungá na. Á kunnian gapay, nu jikkù yù káyu, jikkù gapay yù bungá na, á ammu tam gemma mappíli ta káyu megapu sù bungá na. ");
INSERT INTO att_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sikayu yù kun na ánâ na iráw, ta kitarákè ngámin yù ubobugan naw! Á yá lâ ubobugan na tolay yù ajjan ta nonò na. ");
INSERT INTO att_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yù napiá nga tolay, tuppálan na yù napiá nga naggapu sù napiá nga nonò na. Á yù narákè nga tolay, kitarákè yù ággangnguá na ánna ággubobuk na megapu sù narákè nga nonò na. ");
INSERT INTO att_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Á yawe yù kagiak ku nikayu, ta sangaw nu duttál yù ággaw nga pangukum ni Namarò, á tabbagan nayù ira tatolay nga katággitádday yù inubobuk na nga awán ta serbi na. ");
INSERT INTO att_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta mapakomá kayu onu mapagikáru kayu megapu sù inubobuk naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Á ajjan tán yù ira káruán nga Parisio ánna yù ira mangituddu ta tunung. Á kinagi ra kâ Apu Kesu, “Mesturu,” kud da, “ipasingam mu ngè nikami yù pagaddatuam mu, tapè matákkilalám mi nu kuruk nga sikaw yù iddagám mi nga naggapu kâ Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Á, “Anni ngillâ danniaw nga tatolay ta karanniaw nga ággaw, nga narákè, nga awán ta panguruk da kâ Namarò!” kun ni Apu Kesu. “Kiddaw kayu lâ kiddaw ta panákkilalán naw! Ngam awán ta mepasingan nikayu, nu ari lâ yù panákkilalán nga nepasingan ngaw megapu kâ Jona, nga ábbilinán ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ta naggián ngaw si Jona sù bitúká na dakal nga sirá ta tallu nga ággaw. Á kunnay kâ Jona ngaw, kunnian gapay sangaw nikán nga Kaká na ngámin na tatolay, ta maggiánà sangaw ta tallu nga ággaw sù unak na dabbun. ");
INSERT INTO att_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Á sangaw nu duttál yù ággaw nga pangukum ni Namarò, manáddak yù ira ngaw tatolay nga taga Ninaba, nga mamaliwâ nikayu, gapu ta nabbabáwi ira ngaw ta liwiliwâ da megapu sù pangilayalayâ ni Jona, á ajjanin yù minay saw nikayu nga makáwayyá ánnè kâ Jona. ");
INSERT INTO att_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Á yù ngaw rena nga nammaguray túrin ta Abagátán, aggina gapay yù umay sangaw nu duttálin yù ággaw nga pangukum, nga mangikeká nikayu, gapu ta minay ngaw nga naggapu ta arayyu nga lugár, tapè en na ginnán yù sírik nga inituddu na ngaw ni Patul Solomon, á ajjanin yù minay saw nikayu nga makáwayyá ánnè kâ Solomon,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Á kinagi ni Apu Kesu paga nira, “Á ta ángngarigán, nu ajjan yù anitu nga mallawán sù tolay nga nagunagán na, umay mappassapassiár ta namagá nga lugár, nga magalek ta pagibannagán na. Á sangaw nu awán ta málerán nayù anitu, ");
INSERT INTO att_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","á kun na lâ ta nonò na, ‘Toliak ku lápay yù nánawák ku,’ kun na. Á labbè nayù anitu sù tolay, málek na nga kun na balay nga napakarenuánin, ta awán ta maggián tán. ");
INSERT INTO att_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Á yáyù nga en na apatan yù pitu nga kábulun na nga anitu, nga narákè ánnè kuna, á tullung yù ira walu nga maggián ta tolay. Á nappanà laguk yù ággián nayù tolay nga nagunagán na ngaw nayù tádday lâ. Á kunnian sangaw gapay yù mesimmu sù ira narákè nga tatolay kunangane nga ággaw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Á ta pakiubobuk ni Apu Kesu sù ira tatolay, limibbè yù yená na ánna yù ira wáwwagi na. Á ajjan ira ta lawán nga magiddak, ta ikáyâ da makiubobuk kuna. ");
INSERT INTO att_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Á yáyù nga ajjan yù minay nakkagi kâ Apu Kesu, á kinagi na, “Ajjan ta lawán di Yenám ánna yù ira wáwwagim, á ikáyâ daka nga kobobuk,” kun na. ");
INSERT INTO att_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Á simibbák si Apu Kesu, á kinagi na kuna, “Asinni yù yenâ? Á asinni gapay yù ira wáwwagì?” kun na. ");
INSERT INTO att_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Á sinonnâ na yù limá na ánna inituddu na yù ira sinudduán na nga ajjan tán, á kinagi na, “Masingam mu yawe ira, nga kunnay sù yenâ ánna yù ira wáwwagì. ");
INSERT INTO att_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ta yù ira ngámin nga manguruk kâ Yámà nga ajjan ta lángì ánna manuppál sù ipakuá na nira, aggira yù kun na wáwwagì nga lálláki ánna bábbay ánna kun na yenâ,” kun na. ");
INSERT INTO att_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Á tán galâ nga ággaw, nánaw si Apu Kesu sù balay, á minay nagitubang ta aggik na bebay. ");
INSERT INTO att_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Á kitáru yù ira tatolay nga nagarimummung kuna ta karagátán. Á yáyù nagalì nga minay nagitubang si Apu Kesu sù barangay, á naggián yù ira tatolay, nga gitatáddagán ta aggik. ");
INSERT INTO att_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Á pangituddu ni Apu Kesu nira, nagángngarigán sù aru nga inituddu na. Á kinagi na nira, “Ajjan yù minákkomán nga minay nangiwárì ta bini sù ákkomanán na. ");
INSERT INTO att_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Á pangiwárì na sù bini, negassì ta aggik na dálan yù baddì, á kinán na mammánù. ");
INSERT INTO att_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Á ajjan gapay yù bini nga negassì ta kabatuán, nga nabì lâ nga nattubbu gapu ta baddì garè yù dabbun na. ");
INSERT INTO att_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Á yáyù nga nabì lâ nalelay yù kapássungngì, á pattangngá na ággaw, dagarágâ nga nakatáng, gapu ta ari nakapapponak yù gamù na. ");
INSERT INTO att_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Á ajjan yù bini nga negassì gapay ta kasisítán. Á gapu ta alistu yù áddakal nayù sî, ari nakarakal yù bini. ");
INSERT INTO att_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Á yù káruán nga bini, nepay sù napiá nga dabbun. Á yáyù nga jiminakal ánna nabbungá. Ajjan nga kustu yù bungá na, ánna ajjan nga aru yù bungá na, ánna yù káruán nga kitáru yù bungá na. ");
INSERT INTO att_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Á sikayu nga makaginná, tángngagan naw laguk yù kagiak ku nikayu,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Á minay laguk yù ira sinudduán ni Apu Kesu, á iniyabbû da, “Anni má ta magángngarigán ka nu tudduám mu yù ira tatolay?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Á simibbák si Apu Kesu, á kinagi na nira, “Ari lâ aggira yù neddán, nu ari galâ sikayu yù neddán ta pakáwayyá naw nga makánnámmu sù ngaw nelímak nga meyannung sù pammagure ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Á yù tolay nga magginná ánna makánnámmu, malannapán sangaw yù nánnámmuán na. Ngam yù tolay nga ari magginná ta napiá, mári kuna sangaw mássiki yù baddì nga kagian na nga kánnámmuán na. ");
INSERT INTO att_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Á yáyù nga iyarigák ku yù ituddù sù ira tatolay, gapu ta maggigimmúlák ira, ngam arád da matákkilalán yù kuruk, ánna maggiginná ira, ngam arád da maginná ánna arád da mánnámmuán. ");
INSERT INTO att_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Á yáyù nga megapu nira, matuppál yù kinagi na ngaw ni Isaya, nga ábbilinán ni Namarò. Kunniaw yù inipetúrâ na ngaw ni Namarò kuna: ‘Ginná kayu lâ ginná, ngam arán naw mánnámmuán, ánna singan kayu lâ singan, ngam arán naw matákkilalán. ");
INSERT INTO att_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Danniaw ira nga tatolay, lalang ira, ta arád da ikáyâ mannononò sù kuruk, á yáyù nga mabbáli mataggâ yù nonò da. Kitakitul ira ánna inikimmà da yù matá ra, marakè masingad da, ánna maginná ra, ánna mánnámmuád da yù bilin nga meyannung nikán, á nu mabbabáwi ira nakuan sù liwâ da, pakomák ku ira nakuan.’ ");
INSERT INTO att_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ngam sikayu, napiá yù ággián naw, gapu ta matákkilalán naw yù masingan naw ánna mánnámmuán naw yù maginná naw. ");
INSERT INTO att_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Á kuruk yù kagiak ku nikayu. Aru yù ira ngaw ábbilinán ni Namarò ánna yù ira ngaw napiá nga tatolay nga matunung, nga máyâ nga maningan karanniaw nga masingan naw kunangan, ngam arád da nasingan, ánna inikáyâ da nga maginná yù ngámin nga maginná naw kunangan, ngam arád da naginná,” kun ni Apu Kesu sù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Á kinagi na paga nira ni Apu Kesu, “Ginnán naw laguk yù kebalinán nayù ángngarigák ku nga meyannung sù minángngiwárì ta bini. ");
INSERT INTO att_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yaw yù kebalinán na bini nga natágâ ta aggik na dálan, yù tolay nga makaginná sù bilin nga meyannung sù pammagure ni Namarò, ngam arán na kánnámmuán. Á umay laguk si Satanas, á irián na yù bilin nga naginná nayù tolay. ");
INSERT INTO att_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Á yù bini nga negassì ta kabatuán yù keyarigán nayù tolay nga dagarágâ nga magayáyâ nga mangalawâ sù bilin nga maginná na. ");
INSERT INTO att_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngam kunnay ta bini nga ari makapaggamù ta kabatuán, ari mepatattam ta napiá yù bilin ni Namarò ta nonò nayù tolay, gapu ta inilillíngá na, á yáyù nga ari napasigaggà yù panguruk na. Á sangaw nu marigirigâ yù tolay megapu sù panguruk na kâ Namarò, mabì lâ mallurâ, ánna likuránán na yù panguruk na. ");
INSERT INTO att_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Á yù bini nga natágâ sù kasisítán yù keyarigán nayù tolay nga makaginná sù ubobuk ni Namarò, ngam gapu ta burung na ta jigâ nga umay nakuan kuna ánna yù pakkaragâ na nga mangunnuk sù aru nga magannagannuk nga kukuá na, arán na tángngagan yù napiá nga ipakuá ni Namarò kuna. Á ta kunnay ta bini ta kasisítán nga ari makarakal ánna ari makapabbungá, kunnian gapay sù bilin ni Namarò, ta ari mepatattam ta nonò nayù tolay. ");
INSERT INTO att_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Á yù kebalinán nayù bini nga newárì sù napiá nga ákkomanán, yáyù yù tolay nga magginná sù bilin ni Namarò ánna kánnámmuán na. Á tángngagan na ta napiá, ánna kurugan na. Á tuppálan na yù napiá nga ipakuá ni Namarò kuna, nga kunnay ta ajjan nga kustu yù bungá, ánna ajjan nga aru yù bungá na, ánna yù káruán nga kitáru yù bungá na.” ");
INSERT INTO att_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Á ajjan paga yù tádday nga ángngarigán nga inistoriá ni Apu Kesu sù ira tatolay. “Á meyárik yù pammagure ni Namarò sù tolay nga nangiwárì sù napiá nga bini sù ákkomanán na. ");
INSERT INTO att_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Á ta pakkaturuk da ngámin, minay yù kalusso na, á inimulá na yù kaddà sù komán nga nemulán na tarígu. Á kabalin na nangiwárì sù komán, nánaw. ");
INSERT INTO att_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Á nattubbu yù bini nga tarígu, á naddáwa. Á paddáwa nayù tarígu, nattubbu gapay yù kaddà. ");
INSERT INTO att_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Á yù ira aripan nayù makákkuá sù ákkomanán, ed da kinagi sù yápu ra, ‘Apu, ari panò napiá yù bini nga nipemulám sù ákkomanám mu? Á anni má ta mattubbu gapay yù kaddà? Isaw panò paggapuán na?’ kud da. ");
INSERT INTO att_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Á yaw inimulá nayù malussaw nikán,’ kun nayù yápu ra. Á kinagi ra kuna, ‘Apu, baddulam mi panò yù kaddà laguk?’ ");
INSERT INTO att_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ari lábbì,’ kun na nira, ‘marakè mekanakanâ mabaddul gapay yù tarígu,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Paguráyán naw lâ tapè mepaggigittá nga tulluâ yù tarígu sù kaddà, áddè ta kagaták na. Á sangaw nu magaták, kagiak ku sù ira maggaták ta papoluad da nga baddulan yù kaddà, pángè da babbaran, tapè tuggiad da sangaw. Á kabalid da mamabbak sù kaddà, gatabad da laguk yù tarígu, tapè pakappiád da sù ággubbuák ku,’ kun na.” ");
INSERT INTO att_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ajjan paga yù ángngarigán nga kinagi ni Apu Kesu nira. “Kunniaw yù keyarigán nayù pammagurayán ni Namarò ánna yù ira tatolay nga mesipà sù pammagure na. Kunnay sù kabadditán nga bukal, nga inimulá na tolay sù ákkomanán na. ");
INSERT INTO att_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Á mássiki nu kabadditán sù ngámin makkakerumá nga bukal, dumakal sangaw, nga mabbáli ta káyu, nga karakalán nayù ira ngámin nga mulá, á umay nga magumù yù ira mammánù sù ira pangá na.” ");
INSERT INTO att_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Á nagángngarigán si Apu Kesu paga, á kinagi na nira, “Meyárik gapay yù pammagure ni Namarò sù áppalappák ta pán nga inâ na babay nga inikiruk na sù arená áddè ta nekiruk ta napiá. Á limippák yù ngámin nga pán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Á ta pangituddu ni Apu Kesu sù ira magaru nga tatolay, nagángngarigán sù ngámin nga inituddu na. Awán bulubugá ta inubobuk na nira, nu arán na galâ iniyángngarigán. ");
INSERT INTO att_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Á yáyù nga natuppál yù nakagi nayù ngaw ábbilinán ni Namarò, nga kunniaw: “Magángngarigánà lâ sangaw nu tudduák ku yù ira tatolay. Á kagiak ku nira yù nelímak nga ari paga nánnámmuán áddè ngaw sù kaparò na dabbuno ta áddè kunangan.” ");
INSERT INTO att_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Á kabalin na yaw, nánaw laguk si Apu Kesu nga minay simillung ta balay. Á jimikkì kuna yù ira sinudduán na, á kinagi ra kuna, “Ibukalám mungè nikami yù ángngarigán nga meyannung sù kaddà ta ákkomanán,” kud da. ");
INSERT INTO att_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Á kinagi ni Apu Kesu nira, “Wan, á. Yù tolay nga nammulá sù napiá nga bukal, aggina yù keyarigák ku, nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Á meyárik ta ákkomanán yù dabbuno. Á yù napiá nga bukal nga nemulá sù ákkomanán, yáyù keyarigán nayù ira tatolay nga mesipà sù pammagure ni Namarò. Á yù kaddà yù keyarigán nayù ira makiyáma kâ Satanas, nga maddok sù ira narákè. ");
INSERT INTO att_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Á yù malussaw, nga nangiwárì ta kaddà, aggina gemma si Satanas. Á yù ággo na kagaták nayù nemulá, yáyù keyarigán nayù pagáddekán na ággaw. Á yù ira maggaták yù keyarigán nayù ira daroban ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Á kunnay ta mabaddul ánna matuggi yù kaddà, kunnian gapay yù mesimmu sangaw nu pagáddekán na ággaw. ");
INSERT INTO att_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta sangaw nu duttál yane ággaw, á sikán nga Kaká na ngámin na tatolay, dobak ku yù ira daroban nga umay mangukum sù ira ngámin nga tatolay nga mamalliwâ sù ira kábulud da, ánna yù ira ngámin nga mangnguá ta narákè. ");
INSERT INTO att_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Á itabbà da ira ngámin ta gumaggággáng nga api sù impiernu, á gikuletán ira ánna mangngarangngaringngì ira ta jigâ da. ");
INSERT INTO att_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngam yù ira tatole ni Namarò, mepaggián ira kâ Yáma ra sù pammagurayán na, á maddalingáráng ira nga kunnay ta bilák. Á sikayu nga makaginná, tángngagan naw laguk yù kagiak ku nikayu,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Á nagángngarigán paga si Apu Kesu, á kinagi na, “Yù pammagure ni Namarò sù ira nga mesipà kuna, kunnay gapay sù aru nga pirâ nga nekokkok ta ákkomanán. Á nakesimmu yù tolay ta pirâ. Á pakálek na, nepallà yù pagayáyâ na. Á yáyù nga tábbunán na, á en na laguk iláku ngámin yù kukuá na, tapè manoli nga en na gatángan yù ákkomanán,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Á kinagi ni Apu Kesu paga, “Á kunniaw gapay yù keyarigán nayù pammagure ni Namarò. Ta ajjan yù tolay nga minálláku, á en na aleran yù paddayan na ta dusáriu, nga nanginá yù katággitádday. ");
INSERT INTO att_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Á pakálek na sù tádday nga kakástán, en na iniláku ngámin yù kukuá na tapè gatángan na yù kakástán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Á kinagi na paga ni Apu Kesu, “Yawe gapay yù keyarigán nayù pammagure ni Namarò sù ira tatole na. Kunnay sù tabukul nga nipe ra ta bebay, tapè málâ da yù makkakerumá nga sirá. ");
INSERT INTO att_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Á sangaw nu mapannu yù tabukul, igod da, á magitubang ira nga mamassisinná ta sirá ta meyannung sù kaláse ra, tapè ipe ra sù lappi ra yù napiá ánna itabbà da yù jikkù. ");
INSERT INTO att_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Á kunnian gapay sangaw nu pagáddekán na ággaw. Ta umay yù ira daroban tapè isinná ra yù ira narákè nga tatolay sù ira napiá nga tatole ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Á itabbà da yù ira narákè sù gumaggággáng nga api ta impiernu. Á gikulukuletán ira ánna mangngarangngaringngì ira gapu ta jigâ da.” ");
INSERT INTO att_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Á kabalin na nagángngarigán ni Apu Kesu, iniyabbû na sù ira sinudduán na, “Nánnámmuán naw panò yù kebalinán na ngámin danniaw nga pagángngarigák ku?” kun na nira. “Ammán,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Á kinagi ni Apu Kesu nira, “Á yù ira ngámin nga maggigiámmu sù tunung ni Namarò, nga manguruk sù netuddu, ánna mesipà ira sù pammagure ni Namarò, meyárik ira ta maríku, nga ammu na mangiyusá sù ngámin nga aruátan na, nga dán nga pinakappián na ta bale na, ánna yù bagu nga aruátan na gapay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Á ta kabalin ni Apu Kesu nagángngarigán, nánaw laguk. ");
INSERT INTO att_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Á nanoli ta ili na. Á minay sù iskuelá nga ággagammungád da, á inituddu na yù ira katangelián na. Á pangituddu na nira, napállâ ira sù ituddu na. Á kinagi ra, “Sisaw panò nangápán na sù kasírik na ánna yù pakáwayyá na nga mamagaddátu?” kud da. ");
INSERT INTO att_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Ari pánò nga aggina yù anâ nayù kalapinteru? Á si Maria gemma yù yená na, ánna yù ira wáwwagi na di Ime, kári Kusè, si Simon, ánna si Kudas. ");
INSERT INTO att_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Á ari panò mepaggián saw nittam gapay ngámin yù ira wáwwagi na nga bábbay? Sisaw panò nagiskuelán na nga naggigiámmuán na ta ngámin karanniaw?” kud da. ");
INSERT INTO att_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Á napporay ira kâ Apu Kesu. Á yáyù nga kinagi ni Apu Kesu nira, “Pakimorayád da yù ábbilinán ni Namarò ta ngámin nga lugár. Ngam yù ira katangelián na ánna kanakanáyun na, awán ta ákkimore ra kuna,” kun na. ");
INSERT INTO att_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Á yáyù nga baddì lâ yù pinagaddátu na sù ili na, gapu ta awán ta ángnguruk da kuna. ");
INSERT INTO att_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Á tán nga ággaw, si Patul Erodo yù mammaguray ta Galilia. Á narámak nayù patul yù akka-akkuán ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Á yáyù nga kinagi na sù ira gádde na, “Yane meparámak, aggina si Kuan nga Minánnigù, nga naginnanolayin. Yáyù gapu na nga makáwayyá nga mamagaddátu!” kun nayù patul. ");
INSERT INTO att_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yáyù kagian ni Patul Erodo gapu ta inipagápù na ngaw si Kuan, nga inipegálù na ánna inipapukù na, megapu kâ Erodia nga atáwa na. Ta inatáwa ni Patul Erodo si Erodia, nga atáwa ni Pilippi, nga urián nayù patul. ");
INSERT INTO att_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Á nalussaw si Erodia kâ Kuan ngaw, megapu sù kinagi na sù patul nga atáwa na, nga “Mekontará ta tunung yù pangatáwam kâ Erodia, nga atáwa nayù uriám mu!” kun ni Kuan ngaw kâ Patul Erodo. ");
INSERT INTO att_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Á yáyù nga inikáyâ na papatáyan ni Patul Erodo si Kuan, ngam naganássing sù ira Kudio gapu ta inibiláng da ta ábbilinán ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Á jimittál yù panaddamád da ta keyanâ nayù patul. Á pappabbúyá ra, nattála yù magingánay, nga anâ ni Erodia, nga yù siúmán nayù patul, ta arubáng di patul ánna yù ira álliuk na. Á nepallà yù ayâ nayù patul nga naggíraw ta pattála nayù abbing. ");
INSERT INTO att_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Á yáyù nga nappagássingán nga nangitabbá yù patul ta iyawâ na kuna yù maguray lâ nga kiddawan na. ");
INSERT INTO att_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Á en na laguk nayù abbing nga iniyabbû kâ innò na nu anni yù kiddawan na. Á kinagi ni Erodia sù anâ na yù kagian na sù patul. Á kinagi nayù abbing sù patul, “Iyawâ mu nikán sawe yù ulu ni Kuan nga Minánnigù nga nepay ta ámmagonán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Á pangikomá nayù magingánay sù ulu ni Kuan, nakalò yù daddam nayù patul. Ngam gapu sù pangipagássingán na sù arubáng nayù ira álliuk na, inibilin na ta matuppál yù kinagi nayù abbing. ");
INSERT INTO att_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Á dagarágâ nga pinutulád da si Kuan sù ábbalurán. ");
INSERT INTO att_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Á inituluk da yù ulu na nga nepay ta ámmagonán, nga iniyawâ da sù magingánay. Á iniyawâ na laguk kâ innò na. ");
INSERT INTO att_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Á yù ira sinudduán ni Kuan, pakaginná ra ta kunniaw, ed da inâ yù baggi na, ta initanam da. Á ed da laguk iniparámak kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Á ta pakarámak ni Apu Kesu sù nesimmu kâ Kuan, nattakay ta barangay nga nánaw, nga minay ta kalállammatán. Á pakarámak nayù ira tatolay sù páno ni Apu Kesu, nánawád da ngámin yù ira ili ra, á nappatalay ira nga jimináddán kuna. ");
INSERT INTO att_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Á pakáddè ni Apu Kesu ta aggik, minutták ta barangay, á giminon ta kannak, á nasingan na yù magaru nga tatolay. Á nepallà yù allà na nira, á pinammapiá na ngámin yù ira máttakì nira. ");
INSERT INTO att_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Á ta púgágin, minay kâ Apu Kesu yù ira sinudduán na. Á kinagi ra kuna, “Kalállammatán yawe giát tam, á mággè gabingin,” kud da. “Papanáwam mu bì yù ira tatolay, tapè umay ira gumátáng ta kanad da tukewà babálay,” kud da. ");
INSERT INTO att_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Á kinagi ni Apu Kesu nira, “Ari máwák nga mánaw ira. Sikayu yù mamakán nira,” kun na. ");
INSERT INTO att_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Á kinagi ra kuna, “Ajjan saw lillímá bullung nga pán ánna dudduruá lâ nga sirá,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Iyánge naw saw nikán,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Á pinagitubang na laguk yù ira tatolay, ta nakástá nga kakáddapán yù giád da. Á pakálâ ni Apu Kesu sù límá bullung nga pán ánna duá nga sirá, nattánguk ta lángì, á nabbalabálà kâ Namarò sù kanan. Á giddigidduá na yù pán, á iniyawâ na sù ira sinudduán na, tapè isinek da sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Á kiminán ira ngámin, á nabattuk ira. Á yù ira sinudduán na, ed da inunnuk yù buná ra, á mapulu duá nga lappi yù nagunnurád da. ");
INSERT INTO att_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Á límá ribu nga lálláki yù kiminán, ánna yù ira bábbay ánna ábbing gapay. ");
INSERT INTO att_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Á gapu ta mággè gabingin, lage na pamalabbè ni Apu Kesu sù ira tatolay ta bale ra, pinatake na ta barangay yù ira sinudduán na, ta pinapolu na ira nga dumákì ta dammáng. ");
INSERT INTO att_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Á pamapáno na sù ira tatolay, giminon nga maguroray ta puddul, tapè makimállà sù Yáma na. Á pajjibbakin, ajjan paga si Apu Kesu nga maguroray tán. ");
INSERT INTO att_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Á keggá na paga ni Apu Kesu ta puddul nga makimállà kâ Namarò, nakárayyungin yù barangay nga nattakayán nayù ira sinudduán na, nga nakáddè ta tangngá na bebay, nga mepappáttu ta palung, gapu ta arubangad da yù paddák. ");
INSERT INTO att_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Á ta maddaggunin mannawák, nallakalakák si Apu Kesu sù utun na danum, nga jimikkì sù barangay nga nattakayád da. ");
INSERT INTO att_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Á pakasingan nayù ira sinudduán na kuna nga mallakalakák ta utun na danum, nakkalli ira ta nepallà yù assing da, á “Ye! Annáni! Annáni!” kud da. ");
INSERT INTO att_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngam dagarágâ nga kinagi ni Apu Kesu nira, “Sikán yaw! Ari kayu maganássing,” kun na. ");
INSERT INTO att_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Á pakkagi ni Apu karannian, “Apu,” kun ni Eduru, “nu kuruk nga sikaw, agálám makè laguk ta mallakágà sawe utun na danum nga umay nikaw tán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Á kinagi ni Apu Kesu kuna, “Wan, umay ka saw,” kun na. Á kinuruk na laguk ni Eduru, á gimitták ta barangay, á nallakák ta utun na danum nga minay kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngam pakasingan na ta dakal yù palung megapu sù paddák nga nasikan, naganássing. Á limimmak, á nakkalli nga kinagi na, “Apu, iyígù mà bì!” kun na. ");
INSERT INTO att_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Á dagarágâ nga singngalán ni Apu Kesu yù limá na, á ginápù na. “Anni ngillâ ta kabaddì na ángngikatalà mu nikán! Ngattá, ta mabbábáng ka?” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Á nappittà ira ta barangay, á dagarágâ nga nattukkâ yù paddák. ");
INSERT INTO att_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Á yù ira nga ajjan sù barangay, jináyo ra si Apu Kesu, á kinagi ra, “Apu, kuruk nga sikaw yù Anâ ni Namarò!” kud da. ");
INSERT INTO att_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Á pakáddè di Apu Kesu ta dammáng, naddung ira ta Gennesaret. ");
INSERT INTO att_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Á yù ira tatolay nga taga Gennesaret, natákkilalád da si Apu Kesu. Á yáyù nga ed da iniparámak yù labbè na tán ta ngámin nga tatolay ta lugár da. Á iniyánge ra kuna yù ira ngámin nga máttakì. ");
INSERT INTO att_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Á nakimi-imállà ira kuna ta anugutan na nga siggeran nayù ira máttakì yù kiddanán nayù barawási na. Á nammapiá ngámin yù ira nga naniggek kuna. ");
INSERT INTO att_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Á ajjan yù ira Parisio ánna yù ira mesturu nga mangituddu ta tunung na Kudio, nga naggapu ta Jerusalem, á minay ira kâ Apu Kesu. Á iniyabbû da kuna, ");
INSERT INTO att_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ngattá, ta arád da tuppálan nayù ira sinudduám mu yù kustombare nayù ira ngaw naggaká nittam? Nu kumán ira, arád da baggawán yù limá ra, nga nekontará gemma sù kustombare tam ngámin,” kud da. ");
INSERT INTO att_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Á simibbák si Apu Kesu, á kinagi na nira, “Á sikayu, ngattá, ta giddang naw yù bilin ni Namarò, tapè tuppálan naw yù kustombare naw? ");
INSERT INTO att_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta kinagi ni Namarò, ‘Makimoray kayu sù ira darakal naw ánna iddi-iddukan naw ira.’ Á kinagi na gapay, ‘Mapapátay laguk yù tolay nga mangiparaparákè sù yáma na ánna yená na.’ ");
INSERT INTO att_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngam sikayu, kagian naw ta ángngarigán nu ajjan yù tolay nga makkagi kári ammò na kâ innò na ta awán ta awayyá na nga mangabbák nira gapu ta neyátáng lâ kâ Namarò yù kukuá na nga ángngabbák na nira nakuan, ");
INSERT INTO att_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","á arán nen máwák nga abbágán yù ira darakal na. Á gapu ta kunnian yù ángngituddu naw, inuli naw yù ubobuk ni Namarò tapè tuttulan naw yù ággangnguá naw! ");
INSERT INTO att_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sikayu nga áppè pípiá! Kuruk nga nekanná nikayu yù inipetúrâ na ngaw ni Namarò kâ Isaya, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Danniaw nga tatolay,’ kun ni Namarò, ‘dayáwad dangà megapu sù simù da, ngam arayyu yù nonò da nikán. ");
INSERT INTO att_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awán ta serbi nayù pakimore ra nikán, gapu ta ibiláng da ta bilin ni Namarò yù ituddu ra lápay, nga naggapu galâ ta nonò na tolay,’ kun ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Á kabalin ni Apu Kesu nga nakkagi karannian, inagálán na yù ira tatolay, á kinagi na nira, “Ginnán naw yawe nga kagiak ku nikayu, tapè kuruk nga kánnámmuán naw,” kun na. ");
INSERT INTO att_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Ari yù kanan nga itallung na tolay ta simù na yù mamaddaping ta tolay, nu ari galâ yù iniyubobuk na nga mallawán ta simù na yù paggapuán nayù karaping na. Yù pagubobuk na ta narákè nga naggapu ta nonò na, yawe yù mangari sù awayyá na nga makimoray kâ Namarò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Á yáyù nga minay laguk kâ Apu Kesu yù ira sinudduán na, á kinagi ra kuna, “Apu, arám mu panò ammu ta natakitán yù nonò nayù ira Parisio ta pakaginná ra sù kinagim?” ");
INSERT INTO att_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“Wan ay,” kun ni Apu Kesu. “Á mabaddul sangaw gemma ngámin nga katággitádday nga mulá nga arán na inimulá nayù Yámà nga ajjan ta lángì. ");
INSERT INTO att_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paguráyán naw lâ yù ira buling nga mangering sù ira kagittá ra nga buling nga umay mappetuluk nira. Á nu ituddu na buling sù kabbulun na nga buling yù pallakarád da, mapannâ ira duá sangaw ta abbû,” kun na. ");
INSERT INTO att_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Á kinagi na laguk ni Eduru kuna, “Ibukalám mungè nikami yù kebalinán nayù ángngarigán nga kinagim nira,” kun na. ");
INSERT INTO att_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Á kinagi ni Apu Kesu, “Arán naw panò lâ paga kánnámmuán? ");
INSERT INTO att_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Arán naw panò ammu ta maguray lâ nga kanan yù itallung na tolay ta simù na, umay galâ ta bitúká na, á mallawán sangaw? ");
INSERT INTO att_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngam ta pagubobuk na, yù mallawán ta simù na, yaw naggapu ta nonò na tolay, á yáyù yù mamaddaping ta tolay, ánna mangari sù awayyá na nga makimoray kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta yù nonò na tolay yù paggapuán nayù narákè nga ággangnguá na nga mamapátay, mangarallaw ánna makikarallaw, makkokò, á malladduk nga massistígu, ánna mallilíbâ. ");
INSERT INTO att_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Danniaw yù mamaddaping ta tolay ánna mangari ta awayyá na nga makimoray kâ Namarò. Ngam nu kumán nga ari mabaggawán yù limá na, ari yian yù mamaddaping ta tolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Á nánaw laguk si Apu Kesu tán nga lugár, nga minay ta lugár nayù ira ili na Tiro ánna Sidon. ");
INSERT INTO att_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Á ajjan tán yù babay nga taga Kenan, nga minay kâ Apu Kesu. Á inikatol na nga kinagi kâ Apu Kesu, “Ikállà makè, Apu, sikaw nga Ginaká ni Patul Dabid, ta narigirigâ yù anâ ku nga babay, nga nagunagán na anitu!” kun nayù babay. ");
INSERT INTO att_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngam ari bulubugá simibbák si Apu Kesu. Á nakkallakalli yù babay nga jimináddán nira. Á yáyù nga jimikkì kâ Apu Kesu yù ira sinudduán na nga makikomá kuna, á kinagi ra, “Apu, papanáwam mu bì yù babay,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Á gapu ta ari Kudio yù babay nga makkiddaw kâ Apu Kesu, kinagi ni Apu Kesu, “Jinok nangà nayù Yámà, tapè ek ku tudduán yù ira ginaká ni Israel, nga meyárik ta nagawáwán nga karneru.” ");
INSERT INTO att_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Á pakkagi ni Apu Kesu karanniaw, namalittúkak yù babay sù arubáng na, á kinagi na, “Apu, abbágám mà bì,” kun na. ");
INSERT INTO att_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Á simibbák si Apu Kesu, á kinagi na kuna, “Ari mepángngà nga mepamakán sù ítu yù mepamakán nakuan sù abbing.” Yáyù kinagi ni Apu, gapu ta ari Kudio yù babay nga makikomá kuna, á meyárik yù ira ari Kudio ta ítu, nga ari mesipà sù ira Kudio, nga tatole ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Á simibbák yù babay, á kinagi na, “Wan, Apu. Ngam yù ira ítu, kanad da yù buttá nga naggapu ta lamesá nayù yápu ra,” kun nayù babay kuna. ");
INSERT INTO att_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Á kinagi na laguk ni Apu Kesu sù babay, “Tíyá, mapalurò laguk yù ikáyâ mu megapu sù napasigaggà nga ángngikatalà mu nikán.” Á dagarágâ nga nammapiá yù anâ nayù babay. ");
INSERT INTO att_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Á nánaw si Apu Kesu tán, nga nappatalay. Á nattalebák ta aggik na bebay na Galilia, á giminon sù puddul, á nagitubang tán. ");
INSERT INTO att_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Á jimináddán kuna yù kitáru nga tatolay nga mangiyángay sù ira pilay, pukul ánna nagappul, buling, umal, ánna aru paga nga máttakì, nga inipe ra ta arubáng na. Á pinammapiá na ira ngámin. ");
INSERT INTO att_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Á napállâ yù ira tatolay ta pakasingad da ta nammapiángin ngámin yù ira máttakì nga mepulù nira, ta naginná ra nga makobobugin yù ira umal, á nasingad da yù ira pukul ánna nagappul nga egga ngin yù limá ra ánna takki ra, ánna makalakák yù ira pilay, ánna makasinganin yù ira buling. Á jinaráyo ra si Namarò, nga pakimorayán nayù ira ginaká ni Israel. ");
INSERT INTO att_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Á gapu ta nabayák ira ta kakáddapán nga aranni ta bebay na Galilia, inagálán ni Apu Kesu yù ira sinudduán na nga umay kuna. Á kinagi na nira, “Nakalò yù allà ku sawe ira tatolay, ta tallu nga ággaw iren saw giák ku, á awánin ta kanad da. Á arák ku ikáyâ nga palabbetan ira, nga gibisibisinán, marakè makkakápi ira ánna magaliwawwang nga matombá ta pallakák da ta dálan,” kun na. ");
INSERT INTO att_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Á kinagi nayù ira sinudduán na kuna, “Sisaw yù pangápát tam ta ipamakát tam sawe ira kitáru nga tatolay saw kalállammatán?” kud da. ");
INSERT INTO att_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Á kinagi ni Apu Kesu nira, “Pígiá bullung nga pán yù ajjan nikayu?” kun na. “Pitu bullung nga pán, ánna ajjan baddì nga sirá gapay,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Á yáyù nga pinagitubang na laguk ni Apu Kesu yù ira tatolay ta dabbun. ");
INSERT INTO att_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Á inâ na yù pitu bullung nga pán ánna yù ira sirá. Á kabalin na nabbalabálà kâ Namarò, giddigidduá na ira, á iniyawâ na sù ira sinudduán na. Á inisinek da sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Á kiminán ira ngámin áddè ta kabattuk da. Á pitu nga darakal nga lappi yù napannu sù buná ra, nga inunnuk nayù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Á appátaribu nga lálláki yù kiminán, ánna yù ira bábbay ánna ábbing paga. ");
INSERT INTO att_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Á ta kabalid da kiminán nayù ira magaru, pinalabbè ni Apu Kesu ira ta giád da. Á nánaw gapay di Apu Kesu nga nattakay ta barangay, á minay ira ta lugár na Magadan. ");
INSERT INTO att_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Á minay kâ Apu Kesu yù ira Parisio ánna yù ira Sadusio gapay, ta nattatádday ira nga magalek sù awayyá ra nga manukuk kuna. Á yáyù nga kinagi ra kuna ta ipasingan na nira yù pamagaddátu na, nga panákkilalád da ta kuruk nga ajjan kuna yù pakáwayyá na nga naggapu kâ Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Á simibbák si Apu Kesu nira nga kun na, “Á ta lammak na bilák, nu masingan naw ta ujjojjin yù lángì, ammu naw ta mapiá támma yù tiempu sangaw nu ummá. ");
INSERT INTO att_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Á ta alippánnawák nu masingan naw ta ujjojjin ánna maribbà yù lángì, ammu naw ta magurán onu mabbaggiu sangaw támma. Ammu naw manákkilála ta tiempu megapu sù lángì, ngam arán naw mánnámmuán yù kebalinán nayù panákkilalán ni Namarò nga mesimmu ta kággággaw! ");
INSERT INTO att_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anni ngillâ kinarákè nayù ira tatolay karanniaw nga ággaw, nga awán ta ángnguruk da kâ Namarò! Alek kayu lâ alek ta panákkilalán nga makapállâ, ngam awán ta mepasingan nikayu, nu ari galâ yù kunnay sù napagaddátu nga nesimmu ngaw kâ Jona,” kun ni Apu Kesu nira. Á nánawán na ira. ");
INSERT INTO att_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Á pakarákì di Apu Kesu ta dammáng na bebay, nanonò nayù ira sinudduán na ta náttamád da yù nabbálun ta pán. ");
INSERT INTO att_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Á kinagi ni Apu Kesu nira, “Magimuguk kayu ánna mappalán sù áppalappák ta pán nayù ira Parisio ánna Sadusio,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Á arád da kánnámmuán yù kinagi na nira. Á yáyù nga nakkaká-ubobuk ira sù kinagi na nira, “Yawe kinagi na nittam támma gapu ta awán ittam ta pán,” kud da. ");
INSERT INTO att_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Á ammu ni Apu Kesu ta arád da nánnámmuán yù kebalinán nayù kinagi na, á yáyù nga kinagi na, “Aro, baddì garè yù ángngikatalà naw! Anni má ta ubu-ubobugan naw yù káwán na bálun naw nga pán? ");
INSERT INTO att_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Arán naw paga kánnámmuán? Arán naw panò manonò yù límá bullung nga pán nga nepakán sù ira límáribu nga lálláki, ánna pígiá nga lappi yù nonnuk naw nga buná ra? ");
INSERT INTO att_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Onu yù pitu nga bullung nga pán nga nepakán sù ira appátaribu nga lálláki, ánna pígiá lappi nga buná ra yù nonnuk naw gapay tán? ");
INSERT INTO att_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngattá, ta arán naw paga kánnámmuán ta ari meyannung ta pán yù ubobugak ku nikayu? Mappalán kayu sù áppalappák ta pán nayù ira Parisio ánna Sadusio!” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Á yáyù nga nánnámmuád da laguk ta ari gemma meyannung ta pán yù kinagi na nga palánad da, nu ari galâ yù ituddu nayù ira Parisio ánna Sadusio. ");
INSERT INTO att_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Á minay laguk di Apu Kesu ánna yù ira sinudduán na ta lugár nga aranni sù ili na Sesaria Pilippi. Á keggá ra tán, nakiubobuk si Apu Kesu sù ira sinudduán na, á iniyabbû na nira, “Anni, kanu, yù kagian na tatolay nga meyannung nikán? Sikán nga Kaká na ngámin nga tatolay, asinningà, kanu?” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Á initabbák da kuna, “Ajjan yù ira makkagi ta sikaw kanu si Kuan nga Minánnigù,” kud da. “Á yù ira káruán kanu, kagiad da ta sikaw si Elias, nga yù ngaw ábbilinán ni Namarò. Á ajjan paga yù ira nga makkagi ta sikaw kanu si Jeremia onu tádday sù ira ngaw ábbilinán ni Namarò,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Á kinagi ni Apu Kesu nira, “Á sikayu. Asinningà ta ánninganán naw?” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Á simibbák si Simon Eduru, á kinagi na, “Sikaw si Kiristu, nga Anâ nayù sigga-inángà nga Namarò, nga sinullà na nga umay mammaguray ta dabbuno,” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Á kinagi na laguk ni Apu Kesu kuna, “Napiá yù ággiám mu, Simon, nga anâ ni Jona! Ta ari tolay yù nangipakánnámmu nikaw sawe nga kinagim, nu ari galâ yù Yámà nga ajjan ta lángì. ");
INSERT INTO att_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Á yáyù nga kagiak ku nikaw, ta ingágat taka laguk ta Eduru, nga batu yù kebalinán na, gapu ta kun na batu nga maláddá yù kinagim nga meyannung nikán, nga pangikatalakán nayù ira ngámin nga metádday nikán. Á aggira nga metádday nikán, meyárik ira ta kapilliâ nga patáddagak ku. Á gapu ta pangikatalà da nikán, awán bulubugá ta makáppù nira, mássiki nu si Satanas ánna yù ira girakaráketán nga tumuttul kuna. ");
INSERT INTO att_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Á ikatalà ku nikaw yù pakáwayyám nga mangilayalayâ ta meyannung sù pammagure ni Namarò, nga kun na ánnúsi nga mangibukâ sù pammagurayán na ta lángì. Á yù ngámin nga ipugik mu nga mangnguá sawe dabbuno, yáyù gapay mepugik ta lángì. Á ta kunnian gapay, ngámin yù anugutam mu nga mangnguá sawe dabbuno, yáyù gapay meyanugù ta lángì,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Á kabalin na nakkagi kâ Eduru karanniaw, pinappalán na laguk yù ira sinudduán na ta arád da iparámak ta aggina si Kiristu nga Mammaguray nga sinullà ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Á áddè tán nga ággaw, pinegapuanán ni Apu Kesu nga ipakánnámmu sù ira sinudduán na yù mesimmuán na sangaw. Á kinagi na nira, “Máwák nga umayà ta Jerusalem, tapè attamák ku yù panigirigâ da nikán nayù ira giriámán ánna yù ira kátannangán nga pári ánna yù ira mesturu nga mangituddu sù tunung. Á ipapáte rangà sangaw, ngam paginnanolayan nangà ni Namarò sangaw nu mekatallu nga ággaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Á pakaginná ni Eduru sù kinagi ni Apu Kesu, inilillì na, á kinagi na kuna, “Apu, parè bì ta ilillì naka ni Namarò, tapè ari bulubugá mesimmu nikaw danniaw nga kinagim!” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngam inarubáng ni Apu Kesu si Eduru ánna kinagi na kuna, “Arayyuám mà, ta iniyubobuk mu nikán yù ubobuk ni Satanas. Arám mà igaggak, ta tuppálak ku yù ipakuá ni Namarò nikán. Á ari naggapu kâ Namarò yù ánnonò mu, nu ari galâ negagángay nga ánnononò na tolay,” kun na. ");
INSERT INTO att_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Á kabalin na nakiubobuk kâ Eduru, kinagi ni Apu Kesu sù ira ngámin nga sinudduán na, “Yù tolay nga máyâ nga metádday nikán, máwák na nga tumulù nikán. Á yaw lâ tuppálan na yù ipakuâ kuna galâ, nga ari yù ikáyâ na, mássiki nu máwák nga attamán na lâ yù jigâ onu yù pate na megapu sù panguruk na nikán. Á ta kunnian iyabága na yù kurù na ánna tuttulan nangà. ");
INSERT INTO att_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta yù tolay nga mangengá sù ággián na, matay sangaw, á kengá lâ yù inángà na, gapu ta mesinná yù tolay kâ Namarò ta áddè ta áddè. Ngam yù tolay nga ari mangengá sù ággián na, mássiki nu matay megapu sù panguruk na nikán, ajjan kuna yù mannanáyun nga inángà, gapu ta mesipà kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Á napiá panò yù ággián na tolay, nu málâ na ngámin yù egga ta dabbuno, ngam awán ta ákkiyápu na kâ Namarò? Ari gemma napiá, tanu awán ta ákkiyáma na kâ Namarò, mesinná kuna. Ajjan panò yù awayyá na nga mappagá sù mannanáyun nga inángà? Awán gemma. ");
INSERT INTO att_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Á duttál sangaw yù ággaw na panolì ta dabbuno, sikán, nga Kaká na ngámin na tatolay, nga maddalingáráng ta karáyo nayù Yámà ánna áddalingáráng na. Á mepulù nikán yù ira darobak ku. Á bálatak ku yù ngámin ira nga tatolay nga katággitádday ta meyannung galâ sù kingngikingnguá na. ");
INSERT INTO att_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Á kukurugán nga kuruk yù kagiak ku nikayu. Ajjan ira saw nikayu nga ari sangaw paga matay áddè ta arád dangà masingan nga umay mammaguray sù ira tatolè, sikán nga Kaká na ngámin na tatolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Á pappasá na annam nga ággaw, á inipulù ni Apu Kesu di Eduru ánna yù ira duá nga mawwagi, di Ime kâ Kuan. Á aggira lâ yù giminon sù puddul. ");
INSERT INTO att_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Á labbè da ta utun na puddul, nanguli yù baggi ni Apu Kesu sù pakkaká-arubáng da, nga naddalingáráng nga kunnay ta bilák. Á nerallà yù kapuro na barawási na, nga makatulang nga kunnay ta pattangngá na ággaw. ");
INSERT INTO att_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Á ikáddagâ lâ limittuák nira di Moyses kâ Elias, nga yù ira ngaw ábbilinán ni Namarò, nga makiubobuk kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Á yáyù nga kinagi ni Eduru kâ Apu Kesu, “Apu, napiá ta ajjan ittam saw. Á nu ikáyâ mu, ipappadde takayu laguk ta tallu nga amíngán, nga ággitádde naw, sikayu kári Moyses kâ Elias,” kun na. ");
INSERT INTO att_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Á ta pagubobuk na lâ paga ni Eduru, nalepuanán ira ta kunam nga makatulang. Á naginná ra yù ngárál nga naggapu sù kunam, á kinagi na, “Yawe yù Anâ ku nga iddukak ku. Á kuruk nga ayatánà kuna. Magginná kayu laguk sù kagian na,” kun nayù ngárál. ");
INSERT INTO att_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Á pakaginná nayù ira sinudduán ni Apu Kesu sù ngárál, napállâ ira. Á nallakak ira ta dabbun, gapu ta nerallà yù assing da. ");
INSERT INTO att_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Á mináranni si Apu Kesu nira, á siniggek na ira, á kinagi na, “Gumikkáng kayu. Ari kayu maganássing,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Á panánguk da kuna, awát ta tanakuán nga nasingad da nu ari lâ si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Á minutù di Apu Kesu ta puddul. Á utù da, sinaddánán na ira ni Apu Kesu ta napiá, “Arán naw ubobugan yù nasingan naw ta puddul áddè ta aringà maginnanolay, sikán nga Kaká na ngámin na tatolay,” kun na. ");
INSERT INTO att_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Á iniyabbû da kuna, “Á ngattá laguk, ta kagian nayù ira mangituddu sù tunung ta máwák nga mapolu bì nga duttál si Elias lage nayù Kiristu nga mammaguray?” kud da. ");
INSERT INTO att_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Á initabbák ni Apu Kesu, “Wan, kuruk yian, ta mapolu nga umay si Elias, tapè paránan na ngámin. ");
INSERT INTO att_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Á kuruk yawe nga kagiak ku nikayu. Minay ngin si Elias, ngam arád da garè natákkilalán. Á kingnguá ra lâ kuna yù inikákáyâ da. Á kunnian gapay sangaw yù akkuád da nikán, nga Kaká na ngámin na tatolay,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Á yáyù nga nánnámmuán nayù ira sinudduán na ta si Kuan nga Minánnigù yù ubobugan na nira. ");
INSERT INTO att_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Á utù di Apu Kesu, ajjan yù magaru nga tatolay nga jiminápun nira. Á jimikkì kâ Apu Kesu yù tádday, nga namalittúkak ta arubáng na. Á nakimállà kuna, á kinagi na, ");
INSERT INTO att_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apu, ikállà mu bì yù anâ ku nga laláki, ta minábballiák, á nepallà yù jigâ na, ta sigídá mapannâ ta api onu danum. ");
INSERT INTO att_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Á iniyángè sù ira sinudduám mu, ngam arád da mapammapiá,” kun na. ");
INSERT INTO att_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Á simibbák si Apu Kesu, á kinagi na, “Aro! Anni yù katatole naw nga kitáttaggâ nonò naw! Ngattá, ta awán paga ta ángngikatalà naw kâ Namarò? Pígiá nga ággaw paga yù paggiák ku nikayu? Kunnasi panò yù ággiyattam ku nikayu áddè ta arán nawà ikatalà? Iyánge naw bì saw nikán yù abbing,” kun na. ");
INSERT INTO att_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Á iniyánge ra yù abbing sù gián na. Á gimmá ni Apu Kesu yù nattaliponak, á nallawán sù abbing. Á dagarágâ nga nammapiá yù abbing. ");
INSERT INTO att_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Á kabalin na yaw, nu awánin yù ira káruán nga tatolay, minay lâ kâ Apu Kesu yù ira sinudduán na, á iniyabbû da kuna, “Á anni má ta arám mi mapalawán yù anitu?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Á kinagi na nira, “Baddì lâ garè yù ángngikatalà naw kâ Namarò. Á kuruk yawe nga kagiak ku nikayu. Nu ajjan nakuan yù ángngikatalà naw nga kun na karakal na kabadditán nga bukal, makáwayyá kayu nga makkagi ta magalì yawe puddul, á magalì. Ta awán bulubugá ta arán naw makuá nu mangikatalà kayu kâ Namarò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngam yù anitu nga kunnian, nu ikáyâ naw mapalawán, máwák nga ari kayu bì kumán, tapè tángngagan naw lâ yù pakimi-imállà naw kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Á ta keggá di Apu Kesu ánna yù ira sinudduán na ta Galilia, kinagi na nira, “Sangaw nu manganánnuán, gaputad dangà, á iyawâ dangà sù ira tatolay nga malussaw nikán. ");
INSERT INTO att_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Á papatáyad dangà. Á nu mappasá yù tallu nga ággaw, maginnanolayà,” kun na. Á ta pakaginná nayù ira sinudduán na ta papatáyad da, nakalò yù daddam da. ");
INSERT INTO att_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Á labbè di Apu Kesu ánna yù ira sinudduán na ta ili na Kapernium, jimikkì kâ Eduru yù ira mináttuki ta buwì sù bale ni Namarò. Á iniyabbû da kuna, “Mappagá panò yù mesturu naw sù buwì nayù mangilin nga kapilliá?” kud da. ");
INSERT INTO att_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Wanay,” kun ni Eduru nira. Á simillung laguk si Eduru sù balay nga pagginán ni Apu Kesu. Á tallung ni Eduru ta balay, lage na nagubobuk, kinagi ni Apu Kesu kuna, “Anni yù kagiam mu, Simon? Asinni yù ira mappagá ta buwì onu seddulá sù ira patul nga mammaguray ta dabbuno? Mabbuwì panò yù ira pamiliá ra? Onu yù ira káruán nga tatolay?” kun na kâ Eduru. ");
INSERT INTO att_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Á kinagi ni Eduru, “Yù ira káruán nga tatolay,” kun na. “Wan,” kun ni Apu. “Á yáyù nga sittam nga pamiliá ni Namarò, arát tam máwák yù mappagá ta buwì sù bale na. ");
INSERT INTO att_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngam arát tam akkuán yù ipappore ra. E ka laguk ta bebay nga mamannuì. Á yù olu nga sirá nga málâ mu, á ungngátam mu yù simù na, á masingam mu yù kuártu. Apam mu, ta makatò ta pabbuwì na duá. Á em mu laguk ipappagá ta buwì ta,” kun ni Apu kâ Eduru. ");
INSERT INTO att_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Á sangaw nu manganánnuán, minay kâ Apu Kesu yù ira sinudduán na, á iniyabbû da kuna, “Apu, asinni nikami yù kátannangán sù pammagurayán ni Namarò ta lángì?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Á inagálán na laguk ni Apu Kesu yù baddì nga abbing, nga inipe na ta tangngá ra. ");
INSERT INTO att_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Á kinagi na nira, “Innan naw yawe abbing. Kuruk yù kagiak ku nikayu, ari kayu bulubugá mesipà sù pammagurayán ni Namarò ta lángì nu arán naw ulian yù nonò naw ta kunnay ta nonò na yawe abbing nga tumulù. ");
INSERT INTO att_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ta yù tolay nga tumulù ta kunnay sawe abbing, aggina yù kátannangán sù pammagurayán ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Á yù tolay nga manguruk nikán, nu iddukan na yù kunniaw nga abbing megapu sù panguruk na nikán, sikán gapay yù iddukan na,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Á nagubobuk paga si Apu Kesu, á kinagi na, “Yù tolay nga manudduák nga mamalliwâ sù tádday nga kunniaw nga abbing nga mangikatalà nikán, napiá nakuan nu gakkakád da ta batu nga ággilingán, á ed da itabbà ta bebay, tapè malaggabán nga ari maketuddu ta narákè sù ira ábbing. ");
INSERT INTO att_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Á nakállállà yù ira tatolay ta dabbuno, ta aru yù ira mangituddu ta narákè, tapè makaliwâ yù ira kábulud da. Á negagángay gemma nga ajjan yù ira manudduák sù ira kábulud da ta malliwâ ira. Ngam kábbi yù tolay nga mamalliwâ sù ira kábulun na, gapu ta narámmà sangaw yù pamagikáru ni Namarò kuna. ");
INSERT INTO att_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Á ta ángngarigán nu yù limá naw onu takki naw yù paggapuán nayù pakaliwatán naw, á más napiá nu gappulan naw nakuan ánna itabbà naw, tapè arán naw mapidduán yù malliwâ. Ta mássiki nu nagappul yù limá naw onu takki naw, á napiá lâ nu mesipà kayu kâ Namarò sù pagginán na ta lángì, ánnè sù keggá na duá nga limá naw onu duá nga takki naw, ngam metabbà kayu sangaw ta impiernu gapu ta arán naw likuránán yù liwâ naw. ");
INSERT INTO att_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Á ta ángngarigán nu yù matá naw yù paggapuán nayù pakaliwatán naw, mabbabáwi kayu laguk, ánna arán naw pidduán yù malliwâ. Ta mássiki nu baddulan naw nakuan yù matá naw ánna itabbà naw, napiá lâ nu táttádday lâ yù matá naw, ánna mesipà kayu kâ Namarò ta lángì, ánnè sù keggá na duá nga matá naw, nga ketabbatán naw sangaw ta impiernu. ");
INSERT INTO att_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Magimuguk kayu laguk, tapè arán naw uyawan yù ira ábbing. Ta ajjan yù ira daroban ni Namarò nga maggián ta lángì ta arubáng nayù Yámà, nga manaron sù ira ábbing nga katággitádday. ");
INSERT INTO att_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Á yáyù nga minayà sawe dabbuno, sikán nga Kaká na ngámin na tatolay, tapè iyígù ku yù ira tatolay nga náwáwán. ");
INSERT INTO att_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Á anni laguk ta ure naw? Ta ángngarigán anni akkuán nayù tolay nga ajjan magatù nga karneru na, nu náwáwán yù tádday nira? Arán na panò panawán yù ira siámapulu ta siám, nga magárak sù garek na puddul, tapè en na aleran yù tádday nga náwáwán? Wan, gemma. ");
INSERT INTO att_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Á kuruk yù kagiak ku nikayu, ta sangaw nu náleránin, magayáyâ yù tolay megapu sù tádday, ánnè sù ira siámapulu ta siám nga ari náwáwán. ");
INSERT INTO att_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Á nu arán na ikáyâ na tolay ta máwáwán yù ayám na, mássiki nu tádday lâ, á nepatalugáring kâ Yáma naw ta lángì. Ta arán na ikáyâ ta mesinná kuna yù mássiki lâ tádday sù ira ábbing. ");
INSERT INTO att_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Á sikayu nga katággitádday, nu ángngarigán ta makaliwâ nikaw yù kabbulum mu nga manguruk nikán, umay ka sù gián na, á sangaw nu dudduruá kayu lâ, kagiam mu kuna yù liwâ na. Á nu ginnán na yù kagiam mu, mapiángin yù áwwagi naw. ");
INSERT INTO att_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngam nu arán na ka ginnán, á ipulù mu yù tádday onu duá nga kábulum mu, á pidduám mu umay makiubobuk kuna, tapè matuppál yù tunung nga netúrâ, nga máwák na yù duá onu tallu nga massistígu ta kuruk ngámin yù kagian naw. ");
INSERT INTO att_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Á nu arán na ira ginnán gapay, kagiam mu sù ira ngámin nga kábulum mu nga manguruk nga nepattatádday ta paggagammungán naw. Á nu panakitán na yù kagian nayù ira ngámin nga kábulum mu nga manguruk, ibiláng naw yian ta kunnay sù ira ari manguruk kâ Namarò ánna yù ira kagittá na mináttuki ta buwì, nga mangilogò. ");
INSERT INTO att_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Á kuruk yaw nga kagiak ku nikayu, ta magamaguray lâ yù kagian naw nga mepugik nga akkuán na tolay ta dabbuno, yáyù gapay mepugik ta lángì. Á magamaguray lâ yù anugutan naw nga akkuán na tolay ta dabbuno, yáyù gapay meyanugù ta lángì. ");
INSERT INTO att_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Á ajjan paga yù kagiak ku nikayu, ta nu ajjan duá nikayu nga metádday ta nonò da nga meyannung sù ipakimállà da kâ Namarò, yáyù palurotan na sangaw nayù Yámà ta lángì megapu nira. ");
INSERT INTO att_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta nu ajjan mássiki dudduruá lâ onu tallu nga maggagammung megapu sù pakiyápu ra nikán, ajjanà gapay ta tangngá ra.” ");
INSERT INTO att_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Á minay laguk si Eduru kâ Apu Kesu, á iniyabbû na, “Apu, ta ángngarigán, nu ajjan yù kabbuluk ku nga makaliwâ nikán, mamepígiá panò yù pamakomâ kuna? Mameppitu panò?” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Á simibbák si Apu Kesu, á kinagi na, “Ari lâ mameppitu yù pamakomám kuna, ngam mássiki mamepígiá yù pakaliwâ na nikaw, kunnian gapay yù pamakomám kuna,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Á yáyù nga nagángngarigán si Apu Kesu, á kinagi na, “Á kunniaw laguk yù keyarigán nayù pammagure ni Namarò ta lángì. Ajjan yù patul nga ikáyâ na pasikkálan yù nelistá nga gatù nayù ira tatole na. ");
INSERT INTO att_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Á pamegapu na nga mattuki sù pagatù na, iniyánge ra ta arubáng na yù tádday nga jinibu yù gatù na. ");
INSERT INTO att_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Á gapu ta awán bulubugá ta awayyá na nga mappagá, ipeláku nayù patul laguk ánna yù atáwa na konsu yù ira ánâ na, ánna yù ngámin nga kukuá ra, tapè mapagán yù gatù na. ");
INSERT INTO att_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Á dagarágâ nga namalittúkak yù tolay ta arubáng nayù yápu na nga patul, nga nakimi-imállà kuna, ‘Apu, ikállà mà, á pagák ku sangaw ngámin yù gatù ku nikaw,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Á nakalò yù allà nayù patul sù tole na, á pinakomá na ngámin yù gatù na, á pinalubbáng na yù tolay. Á pinapáno na, tapè lubbekin ta bale na. ");
INSERT INTO att_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Á ta páno nayù tolay sù bale nayù patul, nerapunán na yù kabbulun na nga nakagatù kuna ta baddì lâ. Nakúráng ta magatù yù gatù na kuna. Á ginápù na ánna piddal na. ‘Pagám mu yù gatù mu nikán!’ kun na kuna. ");
INSERT INTO att_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Á dagarágâ nga namalittúkak yù kabbulun na ta arubáng na nga nakikomá kuna, ‘Ikállà mà, ta pagák ku sangaw ngámin yù gatù ku nikaw,’ kun na kuna. ");
INSERT INTO att_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngam nanakì, á en na laguk inipepukù áddè ta pakapagá na sù gatù na. ");
INSERT INTO att_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Á pakasingan nayù ira kábulun na sù kingnguá nayù tolay nga napakomá nen nayù patul ta gatù na, nerallà yù daddam da. Á ed da iniránuk sù yápu ra. ");
INSERT INTO att_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Á inipágál nayù patul yù tolay, á kinagi na kuna, ‘Anni yù narámak ku nga kingnguám! Anni ngillâ kinarákè mu! Pinakomá taka sù ngámin nga gatù mu nikán gapu ta nakimállà ka nikán. ");
INSERT INTO att_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ari panò napiá nu ikállà mu gapay nakuan yù kabbulum mu, nga kunnay sù pangikállà ku nikaw?’ kun nayù patul sù tolay. ");
INSERT INTO att_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Á kitaporay yù patul, á inipebáluk na, tapè jigirigátad da áddè ta mapagán na ngámin yù gatù na. ");
INSERT INTO att_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Á kunnian gapay sangaw yù akkuán ni Ammò ku ta lángì sù katággitádday nikayu nga ari mamakomá sù kabbulun na nga nakaliwâ kuna,” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Á kabalin na nagubobuk ni Apu Kesu karanniaw, nánaw ta purubinsia na Galilia, nga minay sù lugár na Judiya ta dammáng na danum na Jordan. ");
INSERT INTO att_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Á jimináddán kuna yù ira magaru nga tatolay. Á pinammapiá ni Apu Kesu ngámin yù ira máttakì tán nga lugár. ");
INSERT INTO att_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Á jiminikkì kâ Apu Kesu yù ira Parisio nga makiubobuk kuna, ta ikáyâ da nakuan nga tukubán nu kunnasi yù itabbák na sù iyabbû da. “Máyâ panò sù tunung na rilisiot tam nu igúnge na laláki yù atáwa na, maguray lâ yù kegapuánán na?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Á simibbák si Apu Kesu, á kinagi na, “Arán naw panò binibbik yù netúrâ sù dán nga libru, ta pinarò ni Namarò yù tolay nga laláki ánna babay sù ngaw o-olu nga ággaw? ");
INSERT INTO att_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Á kinagi ni Namarò, ‘Yáyù gapu na nga panawán na laláki yù ira darakal na, tapè metádday sù atáwa na. Á mabbáli yù ira magatáwa nga kunnay ta táttádday lâ yù baggi ra.’ ");
INSERT INTO att_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Á gapu ta ari iren duá, nu ari lâ nga táttádday, yáyù nga ari mánugù nga passinnán na tolay yù ira nga pinattádde ni Namarò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Á pakaginná nayù ira Parisio sù kinagi na, iniyabbû da laguk, “Á ngattá, ta initúrâ ni Kákay Moyses yù tunung nga makkagi ta ajjan yù awayyá na laláki nga igúngay yù atáwa na nu iyawâ na yù permá na nga pakasinganán ta paggúnge ra, lage na papanáwan yù atáwa na?” kud da. ");
INSERT INTO att_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Á kinagi ni Apu Kesu nira, “Nataggâ garè yù ulu naw, á yáyù nga inanugù ni Moyses ta igúnge naw yù atáwa naw. Ngam ari nga kunnian áddè ngaw sù ngaw o-olu nga ággaw. ");
INSERT INTO att_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Á yawe laguk yù kagiak ku nikayu. Yù tolay nga mangigúngay ta atáwa na, mássiki nu ari nga nakikarallaw yù babay, á nu mangatáwa yù laláki sangaw ta tanakuán nga babay, makaliwâ, ta mebiláng ta mangarallaw,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Á pakaginná nayù ira sinudduán ni Apu Kesu sawe nga kinagi na sù ira Parisio, kinagi ra kuna, “Á nu kunnian yù ággián nayù magatáwa, napiángin lállaguk nu awán ta mangatáwa,” kud da. ");
INSERT INTO att_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Á simibbák si Apu Kesu, á kinagi na, “Arán na ngámin ira mágalán ni Namarò nga manuppál sawe netuddu, nu ari galâ yù ira pinassikan ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta nakkakerumá yù gapu na nga ari mangatáwa yù ira lálláki. Ajjan yù ira nga nakeyanatád da yù ari mangatáwa. Á ajjan yù ari mangatáwa gapu ta nakapun. Á ajjan gapay yù mabbaluntáriu nga ari mangatáwa tapè tángngagan na yù pangipakánnámmu na ta meyannung sù pammagure ni Namarò. Á yù makatuppál sawe ituddù, tuttulan na laguk,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Á ajjan yù ira tatolay nga nangiyángay sù ira ábbing kâ Apu Kesu, tapè támmitan na ira ánna ipakimállà na ira kâ Namarò. Ngam gimmá ra ira nayù ira sinudduán ni Apu. ");
INSERT INTO att_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Á kinagi ni Apu Kesu, “Anugutan naw ta umay nikán yù ira ábbing. Arán naw ira gammán. Ta yù ira tatolay nga tumulù, nga mangikatalà nikán ta kunnay sawe ira ábbing, aggira yù mesipà sù pammagure ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Á inipotun na laguk yù limá na nira. Á kabalin na nanangngal nira, á nánawin. ");
INSERT INTO att_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Á ajjan yù tolay nga minay kâ Apu Kesu, á kinagi na kâ Apu, “Mesturu, anni laguk yù napiá nga akkuák ku nakuan, tapè mepattolayà nga mesipà kâ Namarò ta áddè ta áddè?” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Á simibbák si Apu Kesu, á kinagi na, “Ngattá, ta iyabbû mu nikán yù meyannung sù napiá? Si Namarò yù napiá, nga táttádday lâ. Á nu ikáyâ mu nga mepattolay nga mesipà kâ Namarò ta áddè ta áddè, kurugam mu yù ngámin nga tunung ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Á anni nga tunung?” kun nayù tolay kâ Apu. Initabbák ni Apu Kesu, “Ari ka mamapátay. Ari ka mangarallaw. Ari ka makkokò. Ari ka malladduk nga massistígu. ");
INSERT INTO att_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Makimoray ka sù ira darakal mu, á iddukam mu yù ira kábulum mu ta kunnay ta pangiddù mu sù baggim,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Á kinagi nayù tolay kuna, “Kurugak ku ngámin dannian. Á anni paga yù máwák ku nga akkuán?” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Á kinagi na laguk ni Apu Kesu, “Nu ikáyâ mu nga palurotan yù kukurugán nga napiá, em mu iláku ngámin yù kukuám, á isinek mu yù pallakuám mu sù ira pobare nga marigirigâ, tapè ajjan yù tagikuám mu ánna yù napiá nga paggianám mu ta lángì. Á umay ka laguk mepulù nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Á pakaginná nayù tolay sù kinagi ni Apu Kesu, nánaw nga nepallà yù daddam na, gapu ta aru yù kukuá na. ");
INSERT INTO att_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Á pakasingan ni Apu Kesu sù páno nayù maríku, kinagi na sù ira sinudduán na, “Kuruk yù kagiak ku nikayu, ta marigâ garè nga tumulù yù maríku kâ Namarò tapè mesipà nakuan sù pammagurayán ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Á ta ángngarigán, yù kamel. Más malogon yù állabbû na kamel sù abbû na dágum, ánnè ta tumulù yù tolay nga maríku kâ Namarò, tapè mesipà sù pammagure na,” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Á pakaginná nayù ira sinudduán na karannian, nepallà yù kapállâ da. Á kinagi ra, “Asinni laguk meyígù nga mesipà kâ Namarò?” ");
INSERT INTO att_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Á iningan na ira ni Apu Kesu, á kinagi na, “Awán ta tolay nga makakuá karanniaw. Si Namarò lâ yù makáwayyá ta ngámin, ta awán gemma ta áddè na pakáwayyá na,” kun na. ");
INSERT INTO att_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Á yáyù nga nagubobuk si Eduru, á kinagi na, “Ye, sikami, nilikuránám mingin ngámin ánna siminuttul kami nikaw. Á anni laguk sangaw yù balabálà mi?” ");
INSERT INTO att_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Á kinagi ni Apu Kesu nira, “Kukurugán nga kuruk yù kagiak ku nikayu. Manguli si Namarò sawe dabbuno sangaw, á sikán, nga Kaká na ngámin na tatolay yù meparáyaw nga magitubang sù maddalingáráng nga pagitubangán nayù patul nga mammaguray. Á sikayu nga mapulu duá nga siminuttul nikán, magitubang kayu gapay ta mapulu duá nga pagitubangán naw, nga mammaguray ánna mamanunnù sù ira ngámin nga Kudio, nga ginaká nayù ira mapulu duá nga ánâ ni Israel. ");
INSERT INTO att_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Á ngámin yù ira tatolay nga panawád da yù bale ra, onu yù wáwwagi ra, darakal da, ánâ da, onu yù ákkomanád da megapu sù pangayâ da ánna panguruk da nikán, á aru yù bálà da nga alawatad da sangaw, á mepattolay ira nga mesipà kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngam aru sù ira kátannangán kunangan, nga mapagukák sangaw. Á aru yù ira nagukák kunangan, nga kátannangán sangaw.” ");
INSERT INTO att_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Á pagángngarigán ni Apu Kesu paga, kinagi na, “Á kunniawe yù keyarigán nayù pammagurayán ni Namarò ta lángì. Ajjan yù tolay nga makákkuá ta namulán ta úbas. Á naggammiá yù tolay nga minay magágál sù ira mangallu nga umay mattarabáku ta kobasán na. ");
INSERT INTO att_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Á pagágál na nira, initarátu na ta táddanán na ira nga katággitádday sù negagángay ta tangággaw, á minay ira laguk nga mattarabáku sù kamulán na. ");
INSERT INTO att_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Á sangaw nu ággawin, minay yù tolay ta dápun, á nasingan na yù ira káruán nga lálláki nga awán ta pattarabakuád da. ");
INSERT INTO att_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Á kinagi na nira, ‘E kayin mattarabáku gapay sù kobasák ku, ta iyawâ ku nikayu sangaw yù mepángngà nga táddán naw,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Á minay ira laguk. “Á manganánnuán, pattangngá na ággaw, minay galâ yù tolay ta dápun, á inagálán na yù ira nga ajjan tán. Á pannarek na bilák, kunnian galâ má kingnguá na, ta en na jinok yù ira nálek na ta umay ira mattarabáku. ");
INSERT INTO att_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Á ta púgágin, minay má galâ yù tolay, á nasingan na yù ira nga lálláki paga tán, á iniyabbû na nira, ‘Ngattá, ta tangatangággaw kayu nga makiubobuk saw?’ kun na. ");
INSERT INTO att_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Á initabbák da, ‘Awán garè ta pattarabakuám mi.’ Á kinagi na nira, ‘E kayu gapay laguk mattarabáku sù kobasák ku,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Á pajjibbà, minay yù makákkuá ta kobasán, á kinagi na sù pangikárguán na, ‘Agálám mu yù ira mangallu, á táddanám mu ira. Papoluam mu nga táddanán yù ira tatolay nga naporián, á paporianam mu nga táddanán yù ira napolu,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Á ánge nayù ira mangallu nga naporián, sináddanán na ira laguk nga katággitádday sù negagángay ta tangággaw. ");
INSERT INTO att_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Á ánge ra gapay nayù ira napolu, kagiad da ta malannapán támma yù táddád da. Ngam negittá galâ yù táddád da sù neyawâ sù ira naporián. ");
INSERT INTO att_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Á pakálawâ da sù táddád da, naddagaragim ira. ");
INSERT INTO att_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Á kinagi ra sù makákkuá ta dabbun, ‘Ngattá, ta inigittám yù táddád da sù táddám mi? Ta danniaw ira, táttádday lâ nga oras yù pattarabáku ra. Ngam sikami, tangatangággaw kami nga nagiyangngà ta pátu na bilák!’ kud da. ");
INSERT INTO att_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Ey, kopun,’ kun nayù makákkuá sù kobasán sù tádday nira, ‘arát taka nilogò, á awán ta liwâ ku nikaw. Arát ta panò nattarátuán nga táddanát taka sù mepángngà ta tangággaw? ");
INSERT INTO att_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Apam mu laguk yawe táddám mu, á lubbè kangin ta balem. Ari panò napiá nu ikáyâ ku nga igittá yù itáddák ku sù naporián ánna yù itáddák ku nikaw? ");
INSERT INTO att_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Awán panò ta awayyâ nga maggástu sù kukuâ? Mamassil ka támma garè, gapu sù ángngikállà ku!’ kun na.” ");
INSERT INTO att_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Á inibalin na laguk nga kinagi ni Apu Kesu, “Á kunnian yù ággián nayù ira tatolay ta pammagurayán ni Namarò ta lángì. Ta mapolu nga mabálatán sangaw yù ira maporián nga mágalán kunangan. Á maporián nga mabálatán sangaw yù ira mapolu nga mágalán kunangan,” kun na. ");
INSERT INTO att_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Á god di Apu Kesu ta ili na Jerusalem, inilillì na yù ira mapulu duá nga sinudduán na sù ira káruán nga tatolay. Á ta pallakalakák da ta dálan, nakiubobuk nira, á kinagi na, ");
INSERT INTO att_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ginnán naw yawe kagiak ku. Gumon ittam ta Jerusalem. Á labbè tam sangaw, gaputad dangà, sikán nga Kaká na ngámin na tatolay. Á ikeká rangà ta arubáng nayù ira kátannangán nga pári ánna yù ira mesturu nga mangituddu sù tunung. Á pagikaruad dangà sangaw ta patay. ");
INSERT INTO att_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Á iyawâ dangà sangaw sù ira ari Kudio. Á uyoyungád dangà, á palapaligatad dangà. Á ipátà dangà laguk sangaw ta kurù. Á sangaw sù mekatallu nga ággaw, maginnanolayà,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Á manganánnuán, jimikkì kâ Apu Kesu yù atáwa ni Sebedo, nga nepappupúlù sù ira ánâ na, di Ime kâ Kuan. Á namalittúkak yù babay ta arubáng ni Apu Kesu, ta ajjan yù ipakimállà na. ");
INSERT INTO att_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Á iniyabbû ni Apu Kesu kuna, “Anni yù ikáyâ mu?” Á simibbák yù babay, “Apu, parè bì lâ nakuan tanu magitubang ka sangaw nga mammaguray sù páppatulám mu, á mepagitubang bì nakuan gapay nikaw yawe ira duá nga ánâ ku, á passidduá nga bangád daka, nga tádday ta jiwanám mu ánna tádday ta jimigim,” kun na. ");
INSERT INTO att_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Á kinobobuk ni Apu yù ira sinudduán na, di Ime kâ Kuan, á kinagi na nira, “Arán naw garè ammu yù kiddawan naw. Tumulù kayu panò nga mepagiyattam sù panigirigâ nayù ira tatolay, ta kunnay sù attamák ku sangaw?” kun na. Á kinagi ra, “Wan, meyattam mi,” kud da. ");
INSERT INTO att_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Á kinagi ni Apu Kesu nira, “Kuruk nga attamán naw noka yù jigâ nga kunnay ta ággiyattam ku sangaw. Ngam awán ta awayyâ nga mappíli sù ira mepagitubang ta jiwanák ku ánna jimigì. Dannian nga pagitubangán yù naparán megapu sù ira nga piníli ni Ammò ku,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Á pakaginná nayù ira mapulu nga sinudduán ni Apu sù kiniddo nayù ira duá nga kábulud da kuna, nakujjà yù mammang da laguk sù ira duá nga mawwagi. ");
INSERT INTO att_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Á yáyù nga inagálán ni Apu Kesu yù ira sinudduán na, á kinagi na, “Ammu naw gemma yù kustombare nayù ira patul nga mammaguray, ta kitarok ira sù ira tatole ra. Á yù ira makáwayyá nga gádde ra, aripanad da yù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngam sikayu, arán naw ira párigán! Ari nga kunnian yù akkuán naw. Ta yù tolay nga máyâ nga mebiláng ta kotunán naw, tumulù laguk nga mabbaluntáriu nga masserbi nikayu. ");
INSERT INTO att_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Á yù tolay nga máyâ nga mebiláng ta kátannangán naw, máwák na laguk nga mangabbák nikayu nga kun na aripan naw. ");
INSERT INTO att_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Á yáyù yù kunnay gapay nikán, nga Kaká na ngámin na tatolay. Aringà minay nga passerbián na tatolay, ngam umayakin masserbi nira ánna metapilà nga magikáru sù liwâ na aru nga tatolay, tapè makipakomá ira kâ Namarò ánna meyígù ira sù liwâ da,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Á ta páno di Apu Kesu ánna yù ira sinudduán na ta ili na Jeriku, jimináddán kuna yù ira magaru. ");
INSERT INTO att_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Á ajjan yù duá nga buling nga nagitubang ta aggik na dálan. Á pakaginná ra ta nattalebák si Apu Kesu, pine ra nakkatol, “Apu, ikállà kami bì, sikaw nga ginaká ni Patul Dabid,” kud da. ");
INSERT INTO att_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Á napporayád da ira nayù ira tatolay. Á kinagi ra nira ta ari ira mattannuk. Ngam pine ra lâ nakkatakatol nga iniyássikad da, “Apu, ikállà kami bì, sikaw nga ginaká ni Patul Dabid!” kud da. ");
INSERT INTO att_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Á pakaginná ni Apu Kesu, nagginnà ta dálan, á inagálán na ira. Á iniyabbû na nira, “Anni yù ikáyâ naw nga akkuák ku megapu nikayu?” kun na. ");
INSERT INTO att_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Á kinagi ra, “Apu, ikáyâ mi ta makasingan kamingin,” kud da. ");
INSERT INTO att_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Á nakalò yù allà ni Apu Kesu nira ánna siniggek na yù matá ra. Á dagarágâ nakasingan iren, á nepappupúlù ira kuna. ");
INSERT INTO att_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Á ánge ra paga di Apu Kesu ta ili na Jerusalem, nakáranni ira ta babálay na Bepagi, ta garek na puddul na Olibo. Á pinapolu ni Apu Kesu yù duá nga sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Á kinagi na nira, “Mapolu kayu lâ nga umay ta babálay,” kun na. “Á labbè naw tán, dagarágâ masingan naw yù dongki nga negálù ánna yù kígo na. Ubbarán naw ira laguk ta iyánge naw saw nikán. ");
INSERT INTO att_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Á nu ajjan yù mangiyabbû nikayu, kagian naw lâ kuna, ‘Máwák na ira ni Apu,’ kun naw, á iyanugù na nga dagarágâ nga apan naw ira,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Á nesimmu danniaw tapè matuppál yù inipeyubobuk na ngaw ni Namarò nga nabayák, sù ngaw ábbilinán na, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kagiam mu sù ira tatolay ta Jerusalem, ‘Innan nawè. Umayin yù patul naw, nga tumulù, nga mattakay ta kígaw na dongki. Ammán! Yù kígaw na dongki yù pattakayán na.’ ” ");
INSERT INTO att_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Á yáyù nga minay laguk yù ira duá nga sinudduán ni Apu Kesu, á sinuppál da yù kinagi na. ");
INSERT INTO att_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Iniyánge ra yù ayám ánna yù kígo na. Á iniyullák da yù gámì da sù barâ nayù ayám, á nattakay si Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Á aru yù ira tatolay nga nepappupúlù kuna, nga iniyullák da yù ira gagámì da sù dálan nga pallakarán na. Á yù ira káruán nga magaru, sippisippáng da yù pangapangá na káyu, nga iniyullák da gapay sù dálan. ");
INSERT INTO att_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Á nagayáyâ nga nagaragiák ngámin yù ira magaru nga napolu kâ Apu ánna yù ira naporián kuna gapay. Á inikatakatol da nga kinagi, “Dayáwat tam yù Patul tam, nga ginaká ni Patul Dabid! Mepagayáyâ kâ Namarò yù Patul nga jinok na ta umay mammaguray! Meparáyaw si Apu Namarò ta lángì!” kud da. ");
INSERT INTO att_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Á labbè ni Apu Kesu ta Jerusalem, napállâ yù ira ngámin nga tatolay sù ili. “Asinni yaw?” kud da ngámin. ");
INSERT INTO att_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Á simibbák yù ira magaru nga nepulupulù kâ Apu Kesu, á kinagi ra, “Si Apu Kesu yaw, nga ábbilinán ni Namarò nga taga Nasaret sù purubinsia na Galilia,” kud da. ");
INSERT INTO att_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Á pakatunù ni Apu Kesu ta Jerusalem, simillung sù karakalán nga kapilliá, nga mangilin nga bale ni Namarò, á pinaturiák na ngámin yù ira nga minálláku ta lágum nayù balay ánna yù ira nga gumugumátáng. Á binalabalittak na yù ira lamesá nayù ira minánnáli ta kuártu ánna yù ira ággitubangán nayù ira minálláku ta lummun. ");
INSERT INTO att_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Á kinagi ni Apu Kesu nira, “Ajjan yù kinagi ni Namarò, nga netúrâ sù dán nga libru, nga kunniaw, ‘Mangngágan yù balè ta Balay nga Ákkimállatán na ngámin na tatolay.’ Ngam sikayu, pabbalinan naw ta patuttukán nayù ira minákkokò!” kun na. ");
INSERT INTO att_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Á minay laguk kâ Apu Kesu sù bale ni Namarò yù ira tatolay nga buling ánna pilay, á pinammapiá na ira ngámin. ");
INSERT INTO att_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngam yù ira kátannangán nga pári ánna yù ira mesturu nga mangituddu sù tunung na rilisiod da, napporay ira nu nasingad da yù pinagaddátu ni Apu Kesu nga makapállâ. Á nepallà yù pore ra ta pakaginná ra sù paddáyo nayù ira ábbing tán, nga nakkatakatol, nga kud da, “Dayáwat tam yù ginaká ni Patul Dabid.” ");
INSERT INTO att_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Á iniyabbû da laguk nayù ira pári kâ Apu Kesu, “Arám mu panò maginná yù kagian nayù ira ábbing?” kud da kuna. “Á wan,” kun ni Apu Kesu. “Maginnákay. Á arán naw panò binibbik yaw nga netúrâ nga Ubobuk ni Namarò? Ajjan netúrâ nga kunniaw, ‘Yù ira ábbing, mássiki yù ira babaddì, netuddu nira yù makkagi sù mepángngà nga áddáyo ra kâ Apu.’ ” ");
INSERT INTO att_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Á kabalin na nakkagi ni Apu Kesu karanniaw, nánawán na ira laguk, á nánaw ta ili nga minay nagammâ sù babálay na Bitania. ");
INSERT INTO att_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Á ta pannawák, pattoli di Apu Kesu ta ili, á nabisinán. ");
INSERT INTO att_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Á nasingan na yù káyu nga igò ta aggik na dálan, á jimikkì kuna, ta innan na nu ajjan bungá na. Ngam awán bulubugá ta nasingan na nga bungá na, nu ari lâ dipúru don. Á kinagi na laguk sù káyu, “Ari ken bulubugá mabbungá!” Á dagarágâ nallelay ánna nakkatáng yù káyu. ");
INSERT INTO att_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Á yù ira sinudduán na, napállâ ira ta pakasingad da karanniaw. “Á ngattá, ta dagarágâ nga nakatáng yawe káyu?” kud da. ");
INSERT INTO att_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Á simibbák si Apu Kesu, á kinagi na nira, “Kuruk yù kagiak ku nikayu. Nu kuruk nga mangikatalà kayu kâ Namarò, ánna ari kayu bulubugá mabbábáng, makuá naw gapay sangaw yù kunnay sù kingnguâ sawe káyu. Á ari lâ kunnian yù awayyá naw, ta nu kagian naw táne puddul, ‘Magalì ka tán nga umay ta bebay,’ á makuá laguk. ");
INSERT INTO att_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Á nu mangikatalà kayu kâ Namarò, maguray lâ yù kiddawan naw nga pakimállà naw kuna, á mapalurò sangaw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Á nanoli laguk si Apu Kesu sù dakal nga bale ni Namarò, tapè mangituddu sù ira tatolay. Á pangituddu na nira, minay kuna yù ira kátannangán nga pári ánna yù ira karakalán nga Kudio, á iniyabbû da kuna, “Anni yù pakáwayyám nga mangnguá ta ngámin karanniaw nga akka-akkuám mu? Asinni yù nangiyawâ nikaw sù pakáwayyám?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Á simibbák si Apu Kesu nira, á kinagi na, “Ajjan gapay bì yù iyabbû ku nikayu. Nu matabbák nawà, á kagiak ku gapay nikayu yù paggapuán nayù pakáwayyâ. ");
INSERT INTO att_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Á yawe yù iyabbû ku. Isaw panò yù paggapuán nayù pakáwayyá ni Kuan nga Minánnigù? Naggapu kâ Namarò, onu naggapu ta tolay?” kun na. Á nakkaká-abba-abbû ira, “Anni yù itabbák tam? Nu kagiat tam ta naggapu kâ Namarò, á kun na sangaw nittam, ‘Á ngattá, ta ari kayu nanguruk kuna?’ ");
INSERT INTO att_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Á nu kagiat tam ta naggapu ta tolay, maganássing ittam sù ira tatolay, marakè akkuád da ittam. Ta aggira ngámin, ibiláng da ta kuruk nga ábbilinán ni Namarò si Kuan,” kud da. ");
INSERT INTO att_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Á yáyù nga initabbák da kâ Apu Kesu, “Arám mi garè ammu,” kud da. Á kinagi ni Apu Kesu nira, “Á arák ku gapay laguk kagian nikayu yù paggapuán nayù pakáwayyâ nga mangnguá sù akka-akkuák ku,” kun na. ");
INSERT INTO att_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Á nagángngarigán si Apu Kesu laguk, á kinagi na, “Anni yù kagian naw ta ure naw nga meyannung karanniaw. Ajjan yù tolay nga yáma na duá nga ánâ na nga lálláki. Á minay sù kaká, á kinagi na kuna, ‘Anâ ku, e ka bì mattarabáku sù komán,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Molang ku,’ kun na anâ na kuna. Ngam sangaw, nabbabáwi sù initabbák na kâ ammò na, á minay galâ. ");
INSERT INTO att_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Á minay yù yáma ra sù mekaruá nga anâ na, á kinagi na gapay kuna ta kunnay sù kinagi na sù kaká na. ‘Wan, Ammò. Umayà,’ kun nayù urián. Ngam ari minay. ");
INSERT INTO att_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Asinni nira yù nanuppál sù kinagi nayù yáma ra?” kun ni Apu Kesu. Á kinagi ra, “Yù kaká ngay!” Á kinagi ni Apu Kesu nira, “Wan, á kuruk yawe nga kagiak ku nikayu nga karakalán, ta yù ira minálliwâ nga kunnay sù ira minángngilogò nga mináttuki ta buwì ánna yù ira bábbay nga minákkarallaw, mapolu ira nga mesipà sù pammagurayán ni Namarò ánnè nikayu. ");
INSERT INTO att_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta si Kuan nga Minánnigù, minay nga mangituddu nikayu sù napiá ánna matunung nga tuttulan naw nakuan, tapè mabbalin ta napiá yù ággangnguá naw, ngam arán naw kinuruk. Ngam nanguruk kuna yù ira mináttuki ta buwì ánna yù ira bábbay nga minákkarallaw. Á mássiki nu nasingan naw yù pabbabáwi ra, ari kayu paga nabbabáwi tapè kurugan naw yù inituddu na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Á kinagi na laguk ni Apu Kesu nira, “Ginnán naw paga yù tádday nga ángngarigák ku. Ajjan yù tolay nga nammulá ta úbas sù ákkomanán na. Á inalitukán na yù kobasán, á pidde na gapay yù áppappatán ta úbas, tapè apan na yù tabbuk na. Á pidde na gapay yù atannáng nga balay, nga ájjipatán nayù magguárdiá sù kobasán. Á ta kabalin na nappadday, inikárgu na sù ira minánnaron, á nánaw nga minay ta arayyu nga lugár. ");
INSERT INTO att_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Á gapu ta jiminakal nga nabbungá yù úbas, á jiminittál yù pappusik da. Á jinok na laguk nayù makákkuá ta kobasán yù ira aripan na sù ira manaron ta kobasán na, tapè málâ da yù balle na. ");
INSERT INTO att_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngam ta labbè da ta kobasán, ginápù da ira nayù ira minánnaron. Á tádday yù pinalapalù da, á pinapáte ra yù mekaruá, ánna pinayáng da ta batu yù mekatallu. ");
INSERT INTO att_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Á yáyù nga jinok na mángin nayù makákkuá yù aru nga aripan na ánnè sù ira olu nga minay. Ngam kingnguá ra má gapay ira nayù ira minánnaron ta kobasán. ");
INSERT INTO att_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Á yáyù nga ninonò nayù makákkuá ta kobasán ta doban na laguk yù anâ na nga umay sù ira minánnaron, ta kagian na ta nonò na, ‘Yawe nga anâ ku yù kukurugán nga pakimorayád da,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngam ta pakasingan nayù ira minánnaron sù anâ na, inigagánge ra, ta kagiad da, ‘Ye! Aggina yù makákkuá ta kobasán sangaw nu matay yù yáma na. Arà! Et tamin, ta papatáyat tam tapè kukuá tam sangawin yù kobasán,’ kud da. ");
INSERT INTO att_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Á ginápù da laguk, á inilawád da sù nálitukán nga kobasán, á pinapáte ra. ");
INSERT INTO att_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Á anni laguk yù akkuán nayù makákkuá ta kobasán sù ira minánnaron sangaw nu umay sù kobasán na?” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Á simibbák ira kuna, á kinagi ra, “Ari bulubugá mabbábáng nga mamapátay sù ira narákè nga minánnaron, tapè ikárgu na yù kobasán na sangaw sù ira tanakuán nga minánnaron nga mangiyawâ kuna sù balle na sangaw nu mapusik,” kud da. ");
INSERT INTO att_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Á kinagi ni Apu Kesu nira, “Uwan á! Á arán naw paga panò nabibbik yù dán nga netúrâ nga Ubobuk ni Namarò? Ajjan yù netúrâ nga kunniaw, ‘Yù tádday nga batu nga panakitán nayù ira mappadday ta balay, aggina galâ yù nabbáli ta ánnáddagán na balay. Yaw yù kingnguá ni Apu Namarò, á nerallà yù kapállâ tam megapu kuna.’ ");
INSERT INTO att_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Á yáyù nga kagiak ku nikayu,” kun ni Apu Kesu nira, “mássiki nu sikayu nga Kudio yù piníli ni Namarò áddè ngaw, patalián na kayu sangaw. Ta gapu ta panakitán naw yù sinullà na nga mammaguray, ari kayu mesipà sù pammagure ni Namarò nu ari galâ yù ira tatolay nga magayáyâ nga manuppál sù ipakuá na nira. ");
INSERT INTO att_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Á ngámin ira nga kun na mesiddúkal sù batu, kunnay ira ta mapakkapakká. Á ngámin yù ira mapannátán nayù batu sangaw, marappì ira nga maburuburâ,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Á pakaginná nayù ira kátannangán nga pári ánna yù ira Parisio sù ira ángngarigán ni Apu Kesu, nánnámmuád da ta aggira yù ubu-ubobugan na, nga meyárik sù ira nanakì sù makákkuá ta kobasán ánna meyárik ira gapay sù ira nanakì sù batu nga nabbáli ta ánnáddagán na balay. Á yáyù nga mappanà yù pore ra. ");
INSERT INTO att_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Á pinarubád da nakuan gaputan, ngam naganássing ira sù ira magaru nga tatolay, gapu ta kinuruk nayù ira tatolay ta ábbilinán ni Namarò si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Á nagángngarigán paga si Apu Kesu. Á kinagi na, ");
INSERT INTO att_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Á kunniaw yù keyarigán nayù ángngisipà ni Namarò ta tatolay sù pammagure na. Ajjan yù patul nga namarán ta bodá nayù anâ na nga laláki. ");
INSERT INTO att_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Á kabalid da namarán, jinok nayù patul yù ira aripan na nga umay magágál sù ira tatolay nga inapà na. Ngam nanakì yù ira inapà na nga umay makibodá. ");
INSERT INTO att_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Á yáyù nga jinok na laguk nayù patul yù ira tanakuán nga aripan na. Á kinagi na nira, ‘Kagian naw bì sù ira inapà ku ta umay lâ ira nga umay, ta dán nga naparán yù ipabbodá mi. Napártingin yù ira báka ánna yù ira matabá nga kígaw, á naparánin ngámin yù máwák tam,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngam pinaguráyád da yù pangágál nayù patul nira, á inupù da yù akka-akkuád da. Ajjan yù ira nga minay ta ákkomanád da ánna yù ira minay nalláku. ");
INSERT INTO att_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Á yù ira káruán, ginápù da yù ira káruán nga aripan nayù patul, á inipasapasiránád da ira, ánna pinapáte ra yù ira káruán. ");
INSERT INTO att_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Á pakarámak nayù patul karannian, nepallà yù pore na, á jinok na yù ira suddálu na, ta ed da papatáyan yù ira namapátay. Á sinuggi ra yù ili ra. ");
INSERT INTO att_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Á kinagi na laguk nayù patul sù ira aripan na, ‘Dán nga naparánin ngámin yù ipabbodâ, ngam ari mepángngà yù ira olu nga inagálák ku. ");
INSERT INTO att_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","E kayu ta dápun, á apatan naw nga umay makibodá yù ira ngámin nga masingan naw,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Á minay laguk yù ira aripan nayù patul, á inagálád da ngámin yù ira narángnganád da ta dálan, nga tatolay nga napiá onu narákè. Á yáyù nga napannu yù bale nayù patul sù ira makibodá. ");
INSERT INTO att_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Á minay laguk yù patul nga nakiubobuk sù ira álliuk na, á nasingan na yù tádday nga ari nappabbisti ta ákkibodá. ");
INSERT INTO att_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Á iniyabbû nayù patul kuna, ‘Kopuk ku, ngattá, ta simillung ka saw nga ari nappabbisti ta ákkibodá?’ kun nayù patul. Á ari nakatabbák yù tolay. ");
INSERT INTO att_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Á kinagi na laguk nayù patul sù ira masserbi kuna, ‘Gaputan naw ta baluran naw, á ilappák naw ta lawán sù kakallatán, nga gián nayù ira gikulukuletán, nga mangngarangngaringngì megapu sù jigâ da.’ ” ");
INSERT INTO att_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Á kinagi na laguk ni Apu Kesu, “Aru yù ira nga agálán ni Namarò nga tumuttul kuna, ngam baddì lâ yù ira napíli na nga mesipà kuna.” ");
INSERT INTO att_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Á ta kabalin na yaw, nánaw laguk yù ira Parisio tán, á minay ira nakkaká-ubu-ubobuk nu kunnasi yù ánnukuk da kâ Apu Kesu ta meyannung sù ubobuk na. ");
INSERT INTO att_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Á yáyù nga jinok da laguk kâ Apu Kesu yù ira kábulud da nga Parisio, nga nepappupúlù sù ira kábulun ni Patul Erodo. Á labbè da sù gián ni Apu Kesu, kinagi ra kuna, “Apu, ammu mi nga awán ta ángngilogò mu ánna kuruk yù ituddum nga bilin ni Namarò nga ipakuá na ta tatolay. Á awán ta irumurumám nga tatolay, gapu ta awán ta ikaburung mu nu anni yù kagiad da, mássiki nu makáwayyá ira. ");
INSERT INTO att_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kagiam mu bì laguk yù nonò mu nga meyannung karanniaw. Arán na panò ipugik nayù tunung tam yù pappagá tam ta buwì kâ Sisar, nga patul nga mammaguray ta Roma?” kud da. ");
INSERT INTO att_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngam natagenà ni Apu Kesu yù narákè nga nonò da. Á yáyù nga kinagi na nira, “Sikayu, nga agippípiá! Ngattá, ta paraparubán nawà nga tukubán? ");
INSERT INTO att_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipasingan naw bì nikán yù kuártu nga ipappagá naw ta buwì,” kun na. Á iniyawâ da kuna yù pirâ. ");
INSERT INTO att_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Á iniyabbû ni Apu Kesu nira, “Asinni yù maká-alinu ánna makángngágan nga nemárká sawe pirâ?” kun na. ");
INSERT INTO att_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Si Patul Sisar,” kud da. Á kun na laguk ni Apu Kesu, “Á kukuá ni Patul Sisar laguk yù pirâ nga namárkán ta kágappà nayù mammang na ánna yù ngágan na. Á yáyù nga pagán naw yù buwì nga meyannung sù pakáwayyá na. Á tuppálan naw gapay yù ipakuá ni Namarò nikayu, nga meyannung sù pakáwayyá na gapay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Á pakaginná nayù ira kábulun ni Patul Erodo ánna yù ira Parisio sù kinagi ni Apu Kesu, nepallà yù kapállâ da sù kasírik nayù itabbák na. Á nánawád da. ");
INSERT INTO att_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Á tán nga ággaw galâ, minay gapay yù ira káruán nga Sadusio. Aggira yù makkagi ta ari maginnanolay yù ira námmatay. Á jiminikkì ira nga nagiyabbû kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Á kinagi ra, “Mesturu, ajjan yù netúrâ nga inituddu na ngaw ni Moyses. ‘Nu matay yù laláki nga natayán na yù atáwa na nga awán ta anâ da, máwák nayù wagi nayù natay nga atawán na yù bálu, tapè maganâ ira, á mebiláng yù anâ da ta anâ nayù wagi na nga natay.’ ");
INSERT INTO att_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Á gári, ajjan sawe giám mi yù ira pitu nga mawwawági nga lálláki. Á nangatáwa yù kaká, á natay nga awán ta anâ na. Á yáyù nga inatáwa nayù urián na yù bálu, nga asípák na. ");
INSERT INTO att_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Á natay laguk yù mekaruá nga laláki gapay nga awán ta anâ na. Á kunnian gapay yù nesimmu sù mekatallu nga laláki ánna yù ira dumaddáddán nga wáwwagi na áddè sù mekapitu. Aggira ngámin, nattutubbátád da nga inatáwa yù babay nga bálu nayù kaká ra, á natay ngámin yù ira mawwawági nga awán ta anâ da. ");
INSERT INTO att_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Á naporián nga natay gapay yù babay. ");
INSERT INTO att_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Á yawe bì yù iyabbû mi nikaw. Noka nu duttál yù ággaw na paginnanolay nayù ira námmatay, asinni laguk sù ira ngaw pitu nga lálláki yù atáwa nayù babay? Nepatalugáring ta inatáwa ra ngámin nga pitu,” kud da. ");
INSERT INTO att_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Á simibbák si Apu Kesu nira, á kinagi na, “Nakaliwâ kayu ta pannononò naw, gapu ta arán naw garè mánnámmuán yù dán nga netúrâ nga Ubobuk ni Namarò, ánna arán naw gapay mánnámmuán yù pakáwayyá ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sangaw nu maginnanolay yù ira námmatay, mapataliánin yù ággián na tatolay, á kunnay ira sù ira daroban ni Namarò ta lángì, nga ari makiatáwa ánna mangatáwa. ");
INSERT INTO att_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Á ta meyannung sù paginnanolay nayù ira námmatay, arán naw paga panò nabibbik yù kinagi ni Namarò nikayu? Netúrâ yaw nga kinagi na, ");
INSERT INTO att_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sikán si Namarò, nga pakimorayád di Abrakam kári Isak kâ Akup,’ kun ni Namarò. Á si Namarò, ari gemma yù pakimorayán nayù ira námmatay, nu ari galâ yù pakimorayán nayù ira matolay,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Á ta pakaginná nayù ira magaru nga tatolay karannian nga kinagi ni Apu Kesu, napállâ ira sù pangituddu na. Ta nánnámmuád da ta mepattolay lâ paga yù ira ngaw naggaká nira, di Abrakam kári Isak kâ Akup, mássiki nu natay yù baggi ra ngaw nga nabayágin lage na nakkagi ni Namarò ta aggina yù pakimorayád da. ");
INSERT INTO att_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Á pakaginná nayù ira Parisio ta ari nakatabbák yù ira Sadusio kâ Apu Kesu, naggagammung ira, á jiminikkì ira kuna. ");
INSERT INTO att_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Á ajjan nira yù abugádu nga makáwayyá ta meyannung sù tunung nayù rilisiod da. Nagiyabbû kâ Apu Kesu, ta parubán na tukubán, á kinagi na, ");
INSERT INTO att_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mesturu, anni yù kapoluán nayù ira ngámin nga taddán ni Namarò nga máwák na tolay nga tuppálan?” kun na. ");
INSERT INTO att_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Á kinagi ni Apu Kesu kuna, “ ‘Iddi-iddukam mu yù Yápum nga namarò nikaw megapu sù ngámin nga ayâ nayù putum, megapu sù ngámin nga urem, ánna megapu sù ngámin nga nonò mu.’ ");
INSERT INTO att_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yane yù napolu nga tunung nga máwák na tolay nga tuppálan. ");
INSERT INTO att_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Á negittá sù kapoluán yù mekaruá nga tunung ni Namarò, nga kunniaw: ‘Iddi-iddukam mu yù ira ikáttolem gapay nga kunnay sù pangiddù mu sù baggim.’ ");
INSERT INTO att_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Á yawe ira duá nga tunung ni Namarò yù nabbatayán nayù ira ngámin nga tunung nga inikatalà ni Namarò kâ Moyses ánna yù ngámin nga inituddu nayù ira ábbilinán ni Namarò áddè ngaw.” ");
INSERT INTO att_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Á gapu ta ajjanin yù ira Parisio nga naggagammung, á lage ra nánaw, nagiyabbû si Apu Kesu nira, nga kun na, ");
INSERT INTO att_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Anni laguk yù kagian naw nga meyannung sù Mangiyígù nga mangngágan ta Kiristu, nga umay mammaguray? Asinni yù naggaká kuna?” kun na. Á simibbák ira, á kinagi ra, “Aggina yù ginaká nayù ngaw Patul Dabid,” kud da. ");
INSERT INTO att_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Á iniyabbû na laguk ni Apu Kesu nira, “Á nu kuruk nga ginaká nayù ngaw Patul Dabid, ngattá laguk ta kinagi ni Patul Dabid ta aggina yù Yápu na? Ta yáyù inipeyubobuk na ngaw nayù Ikararuá ni Namarò kâ Dabid, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Si Apu Namarò, kinagi na sù Yápù: E ka bì magitubang ta jiwanák ku, sù ággitubangán nayù meparáyaw, áddè ta arák ku appútan yù ira malussaw nikaw.’ ");
INSERT INTO att_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Á gapu ta pakkagi ni Dabid ta aggina yù Yápu na, ngattá laguk ta kagian naw ta ginaká na galâ ni Dabid?” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Á awán bulubugá ta makatabbák kâ Apu Kesu. Á yáyù nga namegapu tán nga ággaw, awán bulubugá ta makeyangngà nga magiyabbû kuna. ");
INSERT INTO att_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Á pagubu-ubobuk ni Apu Kesu sù ira magaru nga tatolay ánna yù ira sinudduán na, kinagi na laguk, ");
INSERT INTO att_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yù ira mesturu nga mangituddu ta rilision ánna yù ira Parisio, ajjan yù pakáwayyá ra nga ibukalán yù tunung ni Namarò nga inipetúrâ na kâ Moyses. ");
INSERT INTO att_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Á yáyù nga kurugan naw ánna tuppálan naw laguk ngámin yù kagiad da nikayu. Ngam arán naw párigán yù akka-akkuád da, ta arád da tuppálan yù ubu-ubobugad da. ");
INSERT INTO att_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Á aru yù ilannà da sù tunung nga ipakuá ra nikayu, nga narigâ nga mapalurò, nga kunnay ta narámmà nga ipakáttu ra nikayu, ngam arád da kayu bulubugá abbágán nga mangáttu. ");
INSERT INTO att_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Á ngámin yù akka-akkuád da, akkuád da ta arubáng na tatolay, tapè masingan nayù ira tatolay ánna dayáwad da ira. Yáyù nga parakalad da yù ággianán nayù papel nga netúratán nayù Ubobuk ni Namarò, nga ibabbak da ta mukâ da ánna labunagád da. Á pakápadduad da yù uge na barawási ra, nga ipappeddaráyo ra gapay. ");
INSERT INTO att_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Á nu umay ira makilálláng, onu maggagammung ira sù paggagammungád da, ikáyâ da magitubang sù kapiánán nga ággitubangán nayù tolay nga meparáyaw. ");
INSERT INTO att_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Á pappassiár da ta dápun, káyatád da yù pakimore nayù ira tatolay nira ánna mangabbún nira ta Mesturu. ");
INSERT INTO att_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ngam sikayu, arán naw iyanugù nga abbúnad da kayu ta Mesturu nayù ira kábulun naw. Ta mawwawági kayu, á awán gemma ta mesturu naw nu ari sikán galâ nga táttádday. ");
INSERT INTO att_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Á arán naw abbúnan ta Ammò yù ira kábulun naw sawe dabbuno, gapu ta táttádday lâ yù Ammò naw nga si Namarò nga ajjan ta lángì. ");
INSERT INTO att_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Á arán naw iyanugù nga abbúnad da kayu ta Apu, gapu ta táttádday lâ yù pakiyápuán naw, nga sikán nga si Kiristu nga naggapu kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Á yù makáwayyá nga tolay nga kátannangán naw, máwák nga aggina yù masserbi nga mangabbák nikayu, nga kun na aripan naw. ");
INSERT INTO att_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta yù tolay nga mappeddaráyaw, aggina yù mepagukák sangaw nga mepasiránán. Á yù tolay nga tumulù nga gumukák, aggina yù mepotun sangaw nga meparáyaw.” ");
INSERT INTO att_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Á kinagi na paga ni Apu Kesu, “Magimuguk kayu, sikayu nga mesturu nga mangituddu ta rilision naw ánna sikayu nga Parisio, nga áppa-áppè nga tumuttuttul kâ Namarò. Agippípiá kayu! Anni ngillâ yù ámmagikáru ni Namarò sangaw nikayu! Nakaliwâ kayu ta pangituddu naw, megapu sù kotun na nonò naw. Ari kayu bulubugá nga mesipà sù pammagure ni Namarò megapu sù narákè nga ággangnguá naw. Ari lâ yù panakì naw nga mesipà, nu ari gapay ta ilogò naw yù ira tatolay nga makkaragâ nga mesipà sù pammagure ni Namarò. Manakì kayu nga tumuttuttul kâ Namarò, á arán naw ira anugutan nga tumuttuttul kuna. ");
INSERT INTO att_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Magimuguk kayu, sikayu nga mesturu nga mangituddu ta rilision ánna sikayu nga Parisio. Napiá yù lawán naw, ngam narákè yù unak naw. Agippípiá kayu! Ngattá, ta lannapán naw yù ikáru naw kâ Namarò? Ngattá, ta darogatan naw yù ira bábbay nga bálu, tapè gubatan naw yù kukuá ra ánna bale ra. Á kabayagan naw yù ákkimállà naw, tapè mepasingan sù ira tatolay ta napiá kayu, ngam áppè pípiá kayu lâ. Yáyù nga mappanà sangaw yù ámmagikáru ni Namarò nikayu. ");
INSERT INTO att_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Magimuguk kayu, sikayu nga mesturu nga mangituddu ta rilision ánna sikayu nga Parisio. Agippípiá kayu! Ngattá, ta dumákì kayu ta dammáng na bebay nga umay ta arayyu nga lugár, tapè aleran naw mássiki táttádday nga patuttulan naw. Á nu ajjan sangaw yù mapatuttul naw, yá lâ mepángngà nga labbetán na yù api ta impiernu nga ari máddà ta áddè ta áddè, nepatalugáring ta narákè yù akka-akkuán na ánnè sù kingnguá naw. ");
INSERT INTO att_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Magimuguk kayu, sikayu nga kun na buling nga mangituddu ta dálan sù ira kábulun na nga buling. Ta pangituddu naw, á ngattá, ta kagian naw, ‘Nu ipappagássingán na tolay yù mangilin nga bale ni Namarò sù pangitabbá na, arán na máwák nga tuppálan yù initabbá na. Awán ta liwâ na nu arán na tuppálan yù initabbá na. Ngam nu yù buláwán nga ajjan ta lágum nayù mangilin nga bale ni Namarò yù ipappagássingán na, máwák nga tuppálan na yù initabbá na,’ kun naw. ");
INSERT INTO att_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kunnay ta buling kayu ánna ulapá! Anni panò yù kangilinán? Mangilin panò nakuan yù buláwán nga ajjan ta bale ni Namarò nu ari lâ megapu sù kangilin nayù bale ni Namarò? ");
INSERT INTO att_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Á ngattá ta kagian naw, ‘Nu ipappagássingán na tolay yù ángngiyátangán, arán na máwák nga tuppálan yù initabbá na, ta awán ta liwâ na nu arán na tuppálan. Ngam nu ipappagássingán na yù iyátáng na kâ Namarò nga ipotun na sù ángngiyátangán, á máwák nga tuppálan na yù initabbá na,’ kun naw. ");
INSERT INTO att_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ari panò kuruk nga kunnay kayu ta buling! Anni panò yù kangilinán? Mangilin panò yù iyátáng na tolay kâ Namarò, nu ari galâ megapu ta nepotun sù mangilin nga ángngiyátangán? ");
INSERT INTO att_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Á yáyù nu ajjan yù itabbá na tolay kâ Namarò, á nu ipappagássingán na yù ángngiyátangán nga mangilin, mesipà gemma gapay yù ngámin nga meyátáng tán. ");
INSERT INTO att_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Á kunnian gapay, nu ipappagássingán na tolay yù mangilin nga bale ni Namarò, mesipà gemma gapay sù pappagássingán na si Namarò nga maggián ta bale na. ");
INSERT INTO att_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Á nu ipappagássingán na tolay yù lángì, nga pammagurayán ni Namarò, mesipà gemma gapay si Namarò nga mammaguray tán. ");
INSERT INTO att_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Magimuguk kayu, sikayu nga mesturu nga mangituddu ta rilision ánna sikayu nga Parisio, ta pagikaruan na kayu sangaw ni Namarò. Agippípiá kayu! Ngattá, ta iyawâ naw kâ Namarò yù mekamapulu nga makkakerumá nga kiruk na atang nga inimulá naw, ngam arán naw tuppálan yù tunung nga kuruk nga máwák naw nga tuppálan. Ari matunung yù akka-akkuán naw. Awán ta ángngikállà naw sù ira kábulun naw. Á ari kayu mekatalà. Napiá yù pangiyawâ naw sù mekamapulu kâ Namarò, ngam máwák naw gapay nakuan nga ari lonán yù napiá nga akka-akkuán naw nga matunung ánna yù ángngikállà naw sù ira kábulun naw ánna yù panuppál naw sù pakáwayyá naw nga mekatalà nikayu. ");
INSERT INTO att_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Meyárik kayu ta buling nga mangituddu ta dálan sù ira kábulun na nga buling. Tángngagan naw ta napiá yù káruán nga ituddu nayù tunung, ngam pinaguráyán naw yù kapiánán nga ituddu na nga máwák naw tuppálan. Meyárik kayu gapay ta mangalissî sù inuman na, tapè irián na yù ilà, ngam golpian na tallanan sangaw yù kamel! ");
INSERT INTO att_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Magimuguk kayu laguk, sikayu nga mesturu nga mangituddu sù rilision ánna sikayu nga Parisio, ta pagikaruan na kayu sangaw ni Namarò. Agippípiá kayu! Ngattá, ta magugâ kayu ta passuelu ánna tariaw, tapè narenu yù lawán na. Ngam ari narenu yù ajjan ta unak naw, ta arán naw napakarenuán yù nonò naw. Mangilogò kayu ánna mokkuk kayu nga ari makáppak! ");
INSERT INTO att_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikayu nga Parisio, kunnay kayu ta buling! Papoluan naw nga pakarenuán bì yù narákè nga nonò naw, nga ari masingan, tapè mepasingan sangaw ta napiá gapay yù akka-akkuán naw. ");
INSERT INTO att_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Magimuguk kayu, sikayu nga mesturu nga mangituddu ta rilision naw ánna sikayu nga Parisio, ta pagikaruan na kayu sangaw ni Namarò. Agippípiá kayu! Ta kunnay kayu ta tanam nga napappuraw ta píntá, nga nakástá yù lawán na, ngam ta unak ajjan yù tulutuláng na natay ánna narúnù nga nabuyù. ");
INSERT INTO att_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Á kuruk nga karannian yù keyarigán naw, ta kunnay ta napiá ánna matunung kayu ta ánninganán na tatolay, ngam narákè yù unak naw, ta áppè pípiá kayu nga minálliwâ.” ");
INSERT INTO att_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Á kinagi na paga ni Apu Kesu, “Magimuguk kayu, ta pagikaruan na sangaw ni Namarò nikayu, sikayu nga mesturu nga mangituddu ta rilision ánna sikayu nga Parisio. Agippípiá kayu, ta pakástán naw yù katanamán nayù ira ngaw ábbilinán ni Namarò ánna yù pantiong nayù ira ngaw napiá nga tatolay. ");
INSERT INTO att_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Á kagian naw, ‘Nu ajjan kami lâ nakuan sù ngaw ággaw nayù ira naggaká nikami, ari kami nepattádday sù ira minámmapátay sù ira kábulud da nga ábbilinán ni Namarò,’ kun naw. ");
INSERT INTO att_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Á megapu sù kagian naw, palappátan naw ta kuruk nga sikayu yù ginaká nayù ira ngaw namapátay sù ira ngaw ábbilinán ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arà! Balinan naw laguk yù narákè nga pinegapuanán nayù ngaw ira naggaká nikayu. ");
INSERT INTO att_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kunnay kayu ta ánâ na iráw, ta naggigittá kayu sù ira ngaw naggaká nikayu, nga narákè yù nonò da ánna minángngilogò ira. Egga panò yù awayyá naw nga mattálaw, tapè ari kayu mekanakanâ sù pamagikáru ni Namarò ta impiernu? Ari kayu gemma makalillì kuna! ");
INSERT INTO att_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Á yáyù nga dobak ku sangaw nikayu yù ira ábbilinán ni Namarò, yù ira masírik, ánna yù ira mesturu, ta ed da kayu nakuan tudduán. Á papatáyan naw sangaw yù ira káruán nira, á ipátà naw ta kurù yù ira káruán, á ajjan yù ira nga paligatan naw sangaw sù ira ággagammungán naw. Á ta pattálo ra, sissimmátan naw ira lâ, á jigirigátan naw ira ta ngámin nga ili nga angayád da. ");
INSERT INTO att_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Á yáyù nga mekanakanâ kayu galâ sangaw sù pamagikáru ni Namarò sù ira namapátay sù ira ngámin nga napiá nga tatolay, nga namegapu ta áddè ngaw kâ Abel nga anâ ni Lákay Adan, ta áddè kâ Sakariâ, nga anâ ni Barakiâ, nga pinapáte naw sù lállátán nayù bale ni Namarò ánna yù ánnuggián ta meyátáng. ");
INSERT INTO att_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Á kuruk yù kagiak ku nikayu, sikayu nga gakagaká ngawe, mekanakanâ kayu sù pamagikáru ni Namarò, megapu sù pamapáte nayù ira ngaw naggaká nikayu sù ngámin ira nga ábbilinán na.” ");
INSERT INTO att_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Á kinagi na laguk ni Apu Kesu, “Sikayu nga taga Jerusalem! Nepallà yù daddam ku, ta arán nawà ginnán! Papatáyan naw yù ira ábbilinán ni Namarò ánna payangan naw ta batu yù ira nga jinok na nga manuddu nikayu! Á namepígiá yù inamma-ammung ku nakuan nikayu nga kunnay sù ángngammung na úpá sù píyà na, ngam manakì kayu! ");
INSERT INTO att_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Á yáyù nga sikayu lállaguk maguray, ta nánawán na kayin, nga pinaguráyán ni Namarò. ");
INSERT INTO att_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Á yaw kagiak ku nikayu. Arán nawà sangawin masingan ta áddè ta dattál na ággaw nga panolì, á tákkilalán nawà ánna kagian naw, ‘Dayáwat tam yù Umay nga pannakabaggi ni Apu Namarò nga mammaguray!’ ” ");
INSERT INTO att_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Á páno ni Apu Kesu sù mangilin nga kapilliá, nga bale ni Namarò, minay kuna yù ira sinudduán na, ta ituddu ra kuna yù ira makkakerumá nga balay sù dakal nga kapilliá. ");
INSERT INTO att_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Á simibbák si Apu Kesu nira, a kinagi na, “Innan nawè ngámin yawe ira nakástá nga balay kunangan, ta kukurugán nga kuruk yù kagiak ku nikayu, nga awán bulubugá ta dakal nga batu nga mabattáng sangaw sù gián na, mássiki lâ tádday, nga ari sangaw mewarawarâ, gapu ta marabbâ ngámin sangaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Á ta páno ni Apu Kesu ta Jerusalem, minay sù puddul na Olibo, á nagitubang tán. Á jimikkì kâ Apu yù ira sinudduán na, aggira lâ, á kinagi ra kuna, “Apu, kagiam mungè bì nikami, nu káni yù kesimmu nayù ngámin nga kinagim gangù nikami? Á anni yù panákkilalám mi ta duttálin yù panolim ánna yù pagáddekán na ággaw?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Á kun ni Apu Kesu nira, “Magimuguk kayu tapè awán ta mangilogò nikayu, marakè mepakkáttuay kayu laguk sù panguruk naw nikán. ");
INSERT INTO att_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta aru yù ira mattutubbâ nga umay, nga makkagi ta aggira yù MakKiristu. Á aru yù ira nga ilogò da sangaw, nga mepakkáttuay sù panuttul da nikán. ");
INSERT INTO att_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Á marámak naw sangaw yù ira makigerrá nga aranni nikayu ánna yù ira makigerrá gapay sangaw ta arayyu nga lugár. Ari kayu mabburung nu mamegapu danniaw, ta máwák nga mesimmu danniaw, ngam ari paga yaw yù pagáddekán na dabbuno. ");
INSERT INTO att_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta makigerrá sangaw yù makkakerumá nga tatolay sù ngámin nga lugár da ánna páppatulád da. Á duttál sangaw yù bisin ta makkakerumá nga lugár, ánna lunik sù makkakerumá nga gián. ");
INSERT INTO att_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Á ngámin danniaw yù pamegapu na jigâ nga kunnay sù pappasíkál nayù maganâ. ");
INSERT INTO att_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Á sangaw nu mamegapu yù jigâ, ikalusso ra kayu nayù ira tatolay megapu sù panguruk naw nikán. Á gaputad da kayu laguk ánna ikeká ra kayu ta arubáng nayù ira makáwayyá, tapè jigirigátad da kayu ánna papatáyad da yù ira káruán nikayu. ");
INSERT INTO att_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Á aru yù ira nga pallikuránád da yù ángnguruk da nikán. Á makkakálussaw ira ánna makkakáránuk ira. ");
INSERT INTO att_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Á aru yù ira mattá-ábbilinán nga arán na jinok ni Namarò, á aru yù ira tatolay nga ilogò da, nga mekáttuay sù panuttul da nikán. ");
INSERT INTO att_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Á gapu ta yù pagaru na kinarákè nga akka-akkuán na tatolay, mallummin sangaw yù ayâ nayù ira aru nga tatolay. ");
INSERT INTO att_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngam yù ira nga makeyattam sù jigâ, nga napasigaggà yù panguruk da nikán ta áddè ta pagáddekán, meyígù ira nga mepattolay kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Á lage na pagáddekán na ággaw, melayalayâ ta ngámin nga tatolay ta dabbuno yù napiá nga dámak nga meyannung sù pammagure ni Namarò. Á ta kabalin na yaw, duttálin laguk yù pagáddekán na ággaw na dabbuno.” ");
INSERT INTO att_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Á kinagi na paga ni Apu Kesu, “Masingan naw sangaw yù makálla-állirák nga makánnanássing, nga mappassippíl nga manáddak sù mangilin nga gián nga arán na pakáwayyá nga panáddagán, nga kunnay sù kinagi na ngaw gári ni Daniel, nga yù ngaw ábbilinán ni Namarò. Á yù ira mabbibbik karanniaw, parè bì ta kánnámmuád da laguk yù kebalinán na. ");
INSERT INTO att_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Á nu masingan naw yaw sangaw, á sikayu nga maggián ta Judiya, máwák naw mattálaw sù gián naw nga umay ta puddul. ");
INSERT INTO att_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Á yù tolay nga ajjan ta námmuák na bale na, aringin laguk tullung sù unak na bale na nga mangâ ta kukuá na. ");
INSERT INTO att_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Á yù tolay nga ajjan ta ákkomanán, aringin laguk lubbè nga umay mangâ ta gámì na. ");
INSERT INTO att_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bay! Kábbi, ta makállállà yù ira mabussì ánna yù ira mappasusu sangaw nu duttál dannian nga ággaw. ");
INSERT INTO att_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Á yáyù nga ipakimállà naw laguk kâ Namarò ta ari mekanná yù pattálo naw ta ammián onu ta ággaw na ággibannák. ");
INSERT INTO att_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta yáyù nga duttálin yù nepallà nga jigâ paga ánnè sù nesimmu ta áddè ngaw kaparò na dabbuno ta áddè kunangan, á mássiki ta áddè noka awán bulubugá ta kagittá na. ");
INSERT INTO att_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Á nu arán na pangarián ni Namarò yù ággaw na jigâ, awán nakuan ta tolay nga matolay ta dabbuno. Á yáyù nga pangarián na sangaw laguk ni Namarò danniaw nga ággaw megapu sù ira piníli na nga tatole na.” ");
INSERT INTO att_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Á kinagi na paga ni Apu Kesu, “Á yáyù gapu na nga nu ajjan yù makkagi nikayu, ‘Innan nawè, ajjanin saw yù Kiristu!’ onu ‘Ajjanin tuke!’ nu kud da, arán naw kurugan. ");
INSERT INTO att_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta duttál sangaw yù ira nga áppè Kiristu ánna yù ira áppè ábbilinán ni Namarò, á ipasingad da sangaw yù pamagaddátu ra nga makapállâ, tapè ilogò da nakuan mássiki yù ira piníli ni Namarò, tapè mekáttuay ira nakuan sù panuttuttul da kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ginnán naw laguk ta napiá, ta kinagikin nikayu danniaw lage na mesimmu, tapè dán nga ammu naw ánna ari kayu melogò. ");
INSERT INTO att_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Á yáyù nga nu kagiad da nikayu, ‘Ye, ajjanin si Kiristu tukewà sù puddul!’ ari kayu gumon. Á nu kagiad da, ‘Ajjan nga nattuttù sù lágum na balay!’ arán naw kurugan. ");
INSERT INTO att_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta sangaw nu manolingà, sikán nga Kaká na ngámin na tatolay, mepasingan yù panolì nga kunnay sù kilâ nga mamannawák ta lángì áddè ta lalassangán ta áddè ta lalammarán. ");
INSERT INTO att_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Á ammu naw yù bunnakè nga, ‘Mássiki nu sisaw nga gián nayù natay, yáyù paggagammungán nayù ira gayáng,’ ” kun na. ");
INSERT INTO att_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Á kinagi na paga ni Apu Kesu, “Á sangaw nu mappasá danniaw nga jigirigâ, á dagarágâ nga makkallà yù bilák ánna ari mannawák yù bulán. Á mappannâ yù ira bituan, á mewarawarâ ngámin yù ajjan ta lángì. ");
INSERT INTO att_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Á mappasingan laguk ta lángì yù panákkilalán sù panolì, sikán nga Kaká na ngámin na tatolay. Á ngámin makkakerumá nga tatolay ta dabbuno, makalò yù daddam da ánna nerallà yù pábbo ra. Á masingad dangà nga umay nga naggapu ta utun nga mepulù ta kunam, sikán nga Kaká na ngámin na tatolay, nga makáwayyá ta ngámin ánna maddalingáráng megapu sù karáyò nga naggapu kâ Apu Namarò. ");
INSERT INTO att_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Á ajjan sangaw yù magamariung nga masikan. Á ta pagamariung na, dobak ku laguk yù ira darobak ku nga umay mangammung sù ira tatolay nga piníli ni Apu Namarò, aggira ngámin nga naggapu sù giád da ta ngámin nga lugár nga aranni ánna arayyu, ta aruk na ammiánán, abagátán, lalassangán, ánna lalammarán. ");
INSERT INTO att_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Innan nawè yù káyu nga igò,” kun ni Apu Kesu. “Nu masingan naw ta mallugu yù pangá na, ammu nawin ta nappasángin yù ammián ánna mangulingin yù tiempu. ");
INSERT INTO att_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Á kunnian gapay, nu masingan naw sangaw ta mesimmu danniaw nga kunnay sù kinagì nikayu, ammu naw ta kuruk nga mabíkin, á manolingà. ");
INSERT INTO att_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Á kuruk yù kagiak ku nikayu, nga mesimmu ngámin danniaw nga kinagì lage na matay ngámin yù ira tatolay nga matolay kunangan. ");
INSERT INTO att_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Á mássiki nu mapasá sangaw yù dabbuno ánna ngámin yù ajjan ta lángì, ngam maggián lâ ta áddè ta áddè yù ngámin nga ubobuk ku, nga ari bulubugá moli. ");
INSERT INTO att_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Á ta meyannung ta dattál na ággaw onu oras nga panolì, awán bulubugá ta makánnámmu, nu ari galâ si Ammò. Ta mássiki yù ira daroban ni Apu Namarò nga maggián ta lángì, arád da ammu. Á sikán gapay nga Anâ na, arák ku ammu, gapu ta si Ammò lâ yù makánnámmu. ");
INSERT INTO att_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Á ta kunnay sù kingngikingnguá nayù ira tatolay sù ngaw keggá ni Noe, kunnian gapay yù akka-akkuán nayù ira tatolay sangaw nu ággaw nga panolì. ");
INSERT INTO att_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta yù ira ngaw tatolay ta keggá na ngaw ni Noe, awán ta assing da lage na nalítù yù ngámin nga dabbuno, á sinuttul da lâ yù negagángay nira nga nakkakákán ánna ámma-ámminum ánna naggagáttáwa áddè ta tallung ni Noe sù dakal nga barangay. ");
INSERT INTO att_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Á arád da ninonò yù mesimmu nira áddè ta jiminakal yù danum ánna nalítù yù dabbun, á neburuk ira ngámin nga nalaggabán. Á kunnian gapay yù mesimmu sangaw nu manolingà. ");
INSERT INTO att_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Á yáyù nga sangaw nu manolingà, ta ángngarigán nu ajjan duá nga lálláki nga mattarabáku sù ákkomanád da, á málâ sangaw yù tádday, ánna mabattáng yù kabbulun na. ");
INSERT INTO att_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Á nu ajjan duá nga bábbay nga mabbáyu, á málâ yù tádday, ánna mabattáng yù kabbulun na. ");
INSERT INTO att_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Á yáyù nga magimuguk kayu laguk, ta arán naw gemma ammu yù ággaw nga labbè ku, sikán nga Yápu naw. ");
INSERT INTO att_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Á ta ángngarigán, nu ajjan yù makábbalay, á nu ammu na nakuan yù oras na ánge nayù minákkokò, á ari nakuan makkaturuk nu ari lâ magguárdiá, tapè ari makatallung yù minákkokò sù unak na bale na. ");
INSERT INTO att_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yáyù nga kunnian gapay nikayu, magimuguk kayu laguk, tapè dán nga naparán kayu, ta sikán nga Kaká na ngámin na tatolay, umayà sangaw nu arán nawà iddanamán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Á kinagi ni Apu Kesu, “Á ta ángngarigán, nu ajjan yù aripan nga mekatalà ánna masírik, aggina yù tullatan nayù yápu na nga manaron sù ira kábulun na nga aripan, tapè aggina yù mangiyawâ nira ta kanad da sù negagángay nga pakkákád da. ");
INSERT INTO att_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Á napiá yù ággián na yane aripan nu maratang nayù yápu na nga kunnian yù akka-akkuán na. ");
INSERT INTO att_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kuruk yù kagiak ku nikayu, nga yane aripan yù ikatalà na sangaw nga makkárgu ta ngámin nga kukuá na. ");
INSERT INTO att_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Á ta ángngarigán nu narákè yù aripan, á kagian na ta nonò na ta megaggak támma nga mabayák paga yù labbè na yápu na. ");
INSERT INTO att_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Á yáyù nga palapalutan na laguk yù ira kábulun na nga aripan. Á yá lâ tángngagan na yù makipakán ánna makipappissán sù ira minággillellaw. ");
INSERT INTO att_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Á ikáddagâ lâ sangaw nga lubbè yù yápu na sù ággaw nga arán na iddanamán, á makaddák yù aripan sù labbè na. ");
INSERT INTO att_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Á pakarámak na yápu na sù narákè nga kingnguá na, talamánan na laguk, á ipe na sù gián nayù ira agippípiá, tapè mekanakanâ sù ira gikulukuletán nga mangngarangngaringngì megapu sù jigâ da.” ");
INSERT INTO att_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Á kinagi na paga ni Apu Kesu, “Á sangaw nu pagáddekán na ággaw, nu duttál yù pammagure ni Namarò ta dabbuno, kunniaw yù ággián nayù ira tatolay ta dabbuno. Meyárik ira ta mapulu nga mámmagingánay nga inipulù da yù tulu ra, tapè ed da dapunan yù nobiu nga umay ta bodá. ");
INSERT INTO att_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Á loku yù límá ira nga mámmagingánay. Á límá gapay yù ira nasírik. ");
INSERT INTO att_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","“Á yù ira límá nga magingánay nga loku, inipulù da gapay yù tulu ra, ngam arád da garè binálun yù mayán na tulu ra. ");
INSERT INTO att_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngam yù ira límá nga nasírik, inipulù da yù tulu ra, ánna binálud da gapay yù mayán na tulu ra, tapè ari ira sangaw mapunuán. ");
INSERT INTO att_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Á gapu ta nabayák nga ari limibbè yù nobiu, nakatummà nga nakakaturuk laguk yù ira ngámin nga mámmagingánay. ");
INSERT INTO att_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Á tangngá na gabi, ajjan yù nakkatol, á kinagi na, ‘Ajjanin yù nobiu! Umay ngin! Arà! En nawin dapunan!’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Á giminikkáng laguk yù ira mapulu nga mámmagingánay, á pinarád da yù ággisinganád da. ");
INSERT INTO att_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Á kinagi nayù ira loku nga mámmagingánay sù ira nasírik, ‘Iddán naw kami ngè sù bálun nayù tulu naw, ta máddakánin garè yù ira isingam mi!’ kud da. ");
INSERT INTO att_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Ari!’ kun nayù ira nasírik nira. ‘Marakè ari makatò nittam ngámin. E kayu ngillâ gumátáng ta máwák naw,’ kud da. ");
INSERT INTO att_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Á nánaw laguk yù ira loku nga mámmagingánay, tapè umay ira gumátáng. Á sù kapállikuk da, nattállabbè yù nobiu. Á yù ira mámmagingánay nga dán nga naparán ánna magiddi-iddak, nepulù ira sù nobiu nga simillung sù ábbodán, á naserrán yù puertá. ");
INSERT INTO att_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Á manganánnuán, limibbè yù ira loku nga mámmagingánay. Á naggián ira ta puertá nga nakkatol, nga kud da, ‘Apu, Apu, patallungan kami bì,’ kud da. ");
INSERT INTO att_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Á simibbák yù nobiu nira, á kinagi na nira, ‘Molangà, ta arát takayu amma-ammu,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Á yáyù nga kagiak ku nikayu nga mapparán kayu laguk, ta arán naw ammu yù ággaw ánna oras nga panolì!” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Á nagángngarigán si Apu Kesu paga, á kinagi na, “Á sangaw nu manolingà, kunniaw yù keyarigán nayù pammagure ni Namarò. Ajjan yù maríku nga tolay nga maggagannuâ nga umay ta arayyu nga lugár. Á kabalin na naggagannuâ, inagálán na yù ira aripan na, á inikárgu na nira yù kukuá na. ");
INSERT INTO att_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iniyawâ na yù límá ribu sù tádday nga aripan na. Á duá ribu yù iniyawâ na sù mekaruá. Á maribu yù iniyawâ na sù mekatallu, ta iniyawâ na sù ira katággitádday yù meyannung sù pakáwayyá na. Á kabalin na nangiyawâ nira, nánaw laguk. ");
INSERT INTO att_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Á páno nayù yápu ra, á yù aripan na nga nangalawâ ta límá ribu, dagarágâ nga pinakkumersiu na ngámin yù iniyawâ nayù yápu na, á nakaganánsiá ta límá ribu. ");
INSERT INTO att_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Á kunnian gapay sù aripan na nga nangalawâ ta duá ribu, nakaganánsiá ta duá ribu. ");
INSERT INTO att_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngam yù aripan na nga nangalawâ ta maribu, en na inikokkok yù kuártu nayù yápu na, tapè awán ta makálek kuna. ");
INSERT INTO att_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Á pappasá na aru nga ággaw, nanoli yù yápu nayù ira aripan, á inagálán na ira, tapè umay ira makikuentá kuna. ");
INSERT INTO att_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Á minay kuna yù neddán ta límá ribu, á kinagi na kuna, ‘Apu, límá ribu yù iniyawâ mu nikán. Á ajjanin yawe mapulu ribu, gapu ta nakaganánsiángà ta lannà na nga límá ribu,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Á kinagi nayù yápu na kuna, ‘Napiá yù kingnguám. Kuruk nga napiá ka nga masserbi nikán, ta pangikatalakán ka! Á gapu ta mekatalà ka sù baddì nga inikárgù nikaw, aru sangaw yù ikatalà ku nikaw. E ka saw laguk, ta mesipà ka nga mepagayáyâ nikán nga yápum!’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Á kabalin na yaw, siminubbâ nga minay laguk sù yápu na yù mekaruá nga aripan na nga neddán na ta duá ribu. Á kinagi na, ‘Apu, ajjan yù iniyawâ mu nikán nga duá ribu ánna yù lannà na gapay nga duá ribu nga naganánsiâ,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Á kinagi nayù yápu na gapay kuna, ‘Napiá yù kingnguám. Kuruk nga napiá ka nga masserbi nikán, ta pangikatalakán ka. Á gapu ta mekatalà ka sù baddì nga inikárgù nikaw, aru sangaw yù ikatalà ku nikaw. Arà! E ka saw laguk, ta mesipà ka nga mepagayáyâ nikán nga yápum!’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Á kabalin na yaw, minay laguk yù mekatallu nga aripan na nga neddán ta maribu, á kinagi na sù yápu na, ‘Apu, ammù gemma ta mapporay ka nga awán ta allà mu, ta apam mu yù bungá nayù arám mu inimulá ánna maggaták ka sù arám mu kinomán. ");
INSERT INTO att_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Á yáyù nga naganássingà, á inikokkok ku yù kuártum nga iniyawâ mu nikán. Itolì yawe ngin nga kukuám,’ kun na. ");
INSERT INTO att_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Á kinagi nayù yápu na kuna, ‘Kitarákè ka nga aripan nga kitatalakák! Ngattá, ta kagiam mu ta mappusigà sù arák ku inimulá ánna maggatágà sù arák ku kinomán? ");
INSERT INTO att_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Á nu kuruk nga ammum, ngattá, ta arám mu pinakappián ta bángku yù iniyawâ ku, tapè sangaw nu manolingà, á itolim laguk nakuan yù kuártù ánna yù anâ na?’ ");
INSERT INTO att_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Á kinagi na laguk sù ira káruán nga aripan na, ‘Apan naw yù kuártu nga ajjan kuna, á iyawâ naw sù tádday nga ajjan yù mapulu ribu kuna. ");
INSERT INTO att_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta yù tolay nga mekatalà, malannapán sangaw yù neyawâ kuna, tapè aru sangaw yù ajjan kuna. Ngam yù tolay nga ari mekatalà, mári sangaw mássiki yù baddì nga neyawâ kuna. ");
INSERT INTO att_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Á yawe tolay nga awán ta serbi na, itabbà naw laguk ta lawán sù kakallatán. Yane yù gián nayù ira gikulukuletán nga mangngarangngaringngì megapu sù jigâ da.’ ” ");
INSERT INTO att_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Á kinagi na paga ni Apu Kesu, “Sangaw nu manolingà nga mammaguray, sikán nga Kaká na ngámin na tatolay, ajjan nga mepulù nikán yù ira ngámin nga daroban ni Namarò. Á magitubangà nga meparáyaw sù ággitubangán nayù Mamanunnù. ");
INSERT INTO att_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Á meyarubáng nikán sangaw ngámin yù ira tatolay nga makkakerumá, nga naggapu ta ngámin nga lugár ta dabbuno. Á passinnák ku ira laguk ta duá nga sinná nga kunnay sù pamassinná nayù minánnaron sù ayám na nga karneru ánna kajjing. ");
INSERT INTO att_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Á yù ira tatolay nga napiá yù nonò da, aggira yù ipè ta jiwanák ku. Á ta jimigì yù pangipayák ku sù ira narákè yù nonò da. ");
INSERT INTO att_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Á kabalik ku sangaw mamassinná nira, sikán nga Patul nga mammaguray, kagiak ku sù ira ajjan ta jiwanák ku, ‘Sikayu yù inikállà nayù Yámà. Umay kayu laguk mesipà sù pammagurayán na, nga dán nga iniparán na nikayu áddè ngaw ta kaparò na dabbuno. ");
INSERT INTO att_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta ammu naw mangikállà, á nu nabisinà ngaw ánna napangálà, pinakán nawà ánna pinenum nawà. Á nu minayà ngaw nikayu nga naggapu ta arayyu nga lugár, napiá yù ángngálliuk naw nikán, ta inilágum nawà. ");
INSERT INTO att_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Á sù ngaw awánà ta barawási, á binarawasián nawà. Á nu natakikà ngaw, sinaronán nawà. Á sù kebáluk ku ngaw, en nawà sinullúnán,’ kuk ku sangaw nira. ");
INSERT INTO att_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Á iyabbû da laguk nikán nayù ira matunung nga ajjan ta jiwanák ku, á kagiad da, ‘Apu, káni yù pakasingam mi ngaw nikaw nga mabisin ánna mapangál, á sikami yù namakán ánna namenum nikaw? ");
INSERT INTO att_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Á káni yù pappassiár mu ngaw ta giám mi nga kun na álliuk nga naggapu ta arayyu nga lugár, á sikami yù nangálliuk nikaw? Á káni yù pakasingam mi ngaw nikaw nga nagilongán, á sikami yù namarawási nikaw? ");
INSERT INTO att_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Á káni yù pakasingam mi ngaw nikaw, nga natakì ka ánna nebáluk, á sikami yù nanúllun nikaw?’ kud da sangaw. ");
INSERT INTO att_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Á sikán, nga Patul nga mammaguray, kagiak ku sangaw nira, ‘Kuruk yawe nga kagiak ku nikayu, ta mássiki nu táttádday lâ yù inikállà naw nga inabbágán, nga kagukábán nga tolay nga makituddu nikán, á nebiláng ta pangikállà naw nikán,’ kuk ku nira sangaw. ");
INSERT INTO att_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Á kagiak ku sangaw laguk sù ira tatolay nga ajjan ta jimigì, ‘Mánaw kayu nikán, sikayu nga pagikaruan ni Apu Namarò. Metabbà kayu sangaw sù api nga ari bulubugá máddà, nga dán nga neparán kári Satanas ánna yù ira daroban na. ");
INSERT INTO att_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta sù ngaw kabisik ku ánna kapangál ku, awán bulubugá ta iniyawâ naw nikán. ");
INSERT INTO att_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Á ta pakiálliuk ku ngaw nikayu, arán nawà pinaddulò. Á ta pagilongák ku ngaw, arán nawà iniddán ta barawásì. Á ta katakì ku ánna kebáluk ku ngaw, arán nawà garè sinullúnán,’ kuk ku sangaw nira. ");
INSERT INTO att_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Á iyabbû da sangaw gapay nikán, á kagiad da, ‘Apu, káni panò yù pakasingam mi ngaw nikaw nga nabisin ánna napangál, nga nakiálliuk onu nagilongán, nga natakì ánna nebáluk, ngam arám mi ka inikállà nga inabbágán?’ kud da nikán sangaw. ");
INSERT INTO att_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Á kagiak ku nira sangaw laguk, ‘Kuruk yù kagiak ku nikayu, ta gapu ta panakitán naw nga abbágán yù tádday nga kagukábán nga tolay nga manguruk nikán, á nebiláng ta sikán yù nanakitán naw nga inikállà,’ kuk ku sangaw nira. ");
INSERT INTO att_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Á yáyù nga danniaw yù umay sangaw ta impiernu, nga api nga ari bulubugá máddà, á marigirigâ ira ta áddè ta áddè. Ngam yù ira matunung, mepattolay ira nga mesipà kâ Namarò ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Á kabalin ni Apu Kesu nga nagubobuk ta ngámin karanniaw, kinagi na sù ira sinudduán na, ");
INSERT INTO att_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ammu naw gemma nga duá nga ággaw lákin pángè nayù piestá nga panaddamát tam ta pattalebák nayù daroban. Yúrin sangaw nga ággaw yù kepagápù ku, sikán nga Kaká na ngámin na tatolay, tapè mepátakà ta kurù,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Á tán nga ággaw, ajjan yù ira kátannangán nga pári ánna yù ira karakalán, nga naggagammung ta dakal nga bale nayù kotunán nga pári nga mangngágan ta Kayapas. ");
INSERT INTO att_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Á inigagánge ra nu kunnasi yù paggápù da ánna pamapáte ra kâ Apu Kesu nga awán bulubugá ta makánnámmu. ");
INSERT INTO att_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Á naggigittá yù nonò da nga nakagi, “Arát tam igiddán sù piestá, marakè akkuád da ittam nayù ira tatolay nga makipiestá,” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Á ta keggá di Apu Kesu ta Bitania, ajjan ira sù bale ni Simon nga yù ngaw naggoggong nga pinammapiá na. ");
INSERT INTO att_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Á ta pakkákád da, ajjan nga jimikkì kâ Apu Kesu yù babay nga nanangngal ta nakástá nga boteliá nga napadday ta puraw nga batu nga alabaster. Á napannu ta nanginá nga denu nga bábbanguk. Á inibubbù nayù babay ngámin yù bábbanguk ta ulu ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Á pakasingan nayù ira sinudduán na sù kingnguá nayù babay, napporay ira. Á nakkaká-ubobuk ira, á kinagi ra, “Ye! Kengá lâ yù bábbanguk!” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Aru nakuan yù kelakuán na, nga meyawâ nakuan sù ira pobare,” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngam ammu ni Apu Kesu yù ubobugad da, á kinagi na nira, “Ngattá, ta buruburionán naw yawe babay? Kuruk nga napiá yù kingnguá na nikán. ");
INSERT INTO att_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Á yù ira pobare, mepaggián ira nikayu ta áddè ta áddè. Ngam sikán, aringà nikayu mepaggián ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Á pangibubbù nayù babay sù bábbanguk ta ulù, pinarán na yù baggì ta ketanam ku sangaw. ");
INSERT INTO att_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Á kuruk yù kagiak ku nikayu, nga mássiki sisaw nga gián sù ngámin nga dabbuno yù pangilayalayatán na tolay sù napiá nga dámak, mepakánnámmu gapay yù kingnguá na yawe babay nikán, nga panaddamán na tatolay kuna.” ");
INSERT INTO att_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Á kabalin na yaw, nánaw yù mekamapulu duá nga sinudduán ni Apu Kesu, nga mangngágan ta Kudas Iskariote, á minay sù gián nayù ira kátannangán nga pári. ");
INSERT INTO att_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Á iniyabbû na nira nga kun na, “Pígiá yù itáddán naw nikán, nu ituddù nikayu si Kesu?” Á pinagád da ta tallupulu nga pirâ nga pinaláta. ");
INSERT INTO att_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Á yáyù nga pinegapuán ni Kudas nga nagala-alek ta awayyá na nga mangituddu kâ Apu Kesu, tapè magápù da. ");
INSERT INTO att_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Á jimittál laguk yù olu nga ággaw nayù Piestá, nga pakkákán nayù ira Kudio sù pán nga awán ta állapparán na. Á minay kâ Apu Kesu yù ira sinudduán na, á iniyabbû da kuna, “Sisaw yù ikáyâ mu nga pangiparánám mi ta pamúgák tam sù piestá?” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Á kinagi na, “E kayu sù tádday nga tolay nga ajjan tán nga ili na Jerusalem, á kagian naw kuna ta ipakagi nayù mesturu naw ta ‘Duttál ngin yù ággò, á matayà sangaw. Umay kamingin laguk ta balem, sikán ánna yù ira sinudduák ku gapay, tapè kumán kami sù panaddamán sù pattalebák,’ kun naw kuna.” ");
INSERT INTO att_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Á yáyù nga sinuppál nayù ira sinudduán na yù inibilin na nira, á iniparád da yù pamúgák da ta piestá na panaddamán ta pattalebák nayù daroban. ");
INSERT INTO att_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Á ta pajjibbà, nakkakálalláng di Apu Kesu ánna yù ira mapulu duá nga sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Á ta pakkákád da, kinagi na nira, “Kuruk yù kagiak ku nikayu, nga ajjan nikayu yù tádday nga mangituddu nikán sangaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Á pakaginná ra karanniaw, nepallà yù daddam da, á kinagi ra nga katággitádday kuna, “Apu, ari sikán yù kagiam mu, unè?” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Á initabbák ni Apu Kesu, á kinagi na, “Aggina yù kagiddák ku nga nangisosaw ta pán sù nangisosawák ku. ");
INSERT INTO att_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Á sikán nga Kaká na ngámin na tatolay, matayà sangaw gemma, nga kunnay sù inipalappâ na ngaw ni Namarò sù dán nga netúrâ. Ngam kakábbi lâ yù tolay nga mangiránuk nikán. Napiá ngillâ nakuan nu ari neyanâ!” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Á si Kudas Iskariote, nga mangituddu sangaw kuna sù ira maggápù kuna, kinagi na, “Mesturu, sikán panò yù kagiam mu?” Á kinagi ni Apu Kesu kuna, “Asinni paga laguk dumá?” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Á pakkákád da paga, inâ ni Apu Kesu yù pán, á nabbalabálà kâ Namarò. Á kabalin na nabbalabálà, giddigidduá na yù pán nga inisinek na sù ira sinudduán na ánna kinagi na nira, “Mangâ kayu ta kanan naw, ta baggì yaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Á kabalin na yian, inâ na laguk ni Apu Kesu yù inumad da, á nabbalabálà kâ Namarò. Á kabalin na nabbalabálà, iniyawâ na nira ánna kinagi na nira, “Sikayu ngámin, mattutubbâ kayu nga ámminum sawe. ");
INSERT INTO att_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ta yawe yù dágà nga mamalláddá sù bagu nga tarátu ni Namarò, yù dágà nga mebubbù sangaw megapu ta aru nga tatolay, tapè mapakomá ira ta liwiliwâ da. ");
INSERT INTO att_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Á kagiak ku nikayu, aringakin ámminum sù naggapu sù tabbuk na úbas ta áddè noka nu mepattatádday ittam nga ámminum sù bagu, sangaw nu ajjan ittam sù pammagurayán ni Ammò ku.” ");
INSERT INTO att_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Á kabalin na yaw, nattatádday ira nga nakkansion sù áddáyo ra kâ Namarò. Á nánaw ira laguk nga minay ta puddul na Olibo. ");
INSERT INTO att_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Á gapu ta pallakák di Apu Kesu nga umay ta puddul, kinagi na sù ira sinudduán na, “Sikayu ngámin, kunangane galâ nga gabi, táttájjián nawà, ta yáyù sangaw yù kapalurò nayù dán nga netúrâ nga Ubobuk ni Namarò, nga kunniaw: ‘Papatáyak ku yù mináppárák, á mewarawarâ sangaw yù ira karneru na, gapu ta awán ta manaron nira.’ ");
INSERT INTO att_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngam sangaw nu maginnanolayà, oluát takayu túrin ta purubinsia na Galilia, á iddagát takayu tán.” ");
INSERT INTO att_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Á sù pakkagi ni Apu Kesu nira ta táttájjiád da sangaw, kinagi ni Eduru kuna, “Ari sikán. Mássiki nu aggira ngámin nga kábuluk ku yù manájji nikaw, ngam sikán, arát taka bulubugá nga tájjián,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngam kinagi na laguk ni Apu Kesu kuna, “Kuruk yù kagiak ku nikaw, ta sangaw nu gabi, lage na magittarákkò yù manù, á kapamillum sangawin nga nakkagi ta arám mà ammu.” ");
INSERT INTO att_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngam kinagi na paga ni Eduru kuna, “Mássiki nu matayà sangaw nga mekanâ nikaw, arák ku bulubugá ilímak ta ammu taka!” kun na. Á kunnian gapay yù kinagi nayù ira ngámin nga sinudduán na. ");
INSERT INTO att_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Á kabalid da kiminán, nánaw laguk di Apu Kesu ánna yù ira sinudduán na, á minay ira ta gián nga mangngágan ta Getsemani. Á kinagi ni Apu Kesu nira, “Magitubang kayu saw, ta ek ku bì tuke nga makimi-imállà,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Á inipulù na di Eduru ánna yù ira duá nga ánâ ni Sebedo. Á nakalò laguk yù daddam na ánna narámmà yù gáko na. ");
INSERT INTO att_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Á kinagi na nira, “Mággekakin matay ta nepallà nga daddam ku! Maggián kayu bì saw nga mepatturá nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Á kabalin ni Apu Kesu nakkagi nira, minárayyu nira ta baddì laguk, á namalittúkak nga nallakak ta dabbun, nga nakimállà, nga kinagi na, “Ammò ku, nu awayyá na, ilillì mà sù jigâ nga patayák ku. Ngam ari yù urè yù mapalurò, nu ari galâ yù urem,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Á kabalin na nakimállà, nanoli sù gián nayù ira tallu nga nepulù kuna, á naratang na ira nga nakkaturuk. Á kinagi na kâ Eduru, “Ngattá panò, ta arán naw awayyá nga mepatturá nikán ta mássiki lâ tangoras? ");
INSERT INTO att_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Matturá kayu laguk nga makimállà, tapè ari kayu mekáttuay sù ángnguruk naw. Ta mássiki nu dán nga naparán yù nonò na tolay nga manguruk, ngam makapi garè yù baggi na, nga ari mamalurò,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Á kabalin na nga nilukák ira, minárayyu si Apu Kesu má ta baddì nira, á pinidduán na nakimállà, á kinagi na, “Ammò ku, nu kuruk nga máwák ku, á parubák ku yawe jigâ, tapè mapalurò laguk ngámin yù ipakuám nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Á nanoli má sù ira tallu, á naratang na ira nga gikakaturugán ira lâ paga, ta arád da megimmúlák. ");
INSERT INTO att_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Á nánawán na ira má, á namillu nga minay nakimállà nga kunnian galâ sù inipakimállà na. ");
INSERT INTO att_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Á ta kabalin na nakimállà ni Apu Kesu, nanoli laguk sù ira kábulun na. Á iniyabbû na nira, “Ngattá, ta makkaturuk ánna magibannák kayu lâ paga? Jimittálin yù oras nga keyalawâ ku sù ira minálliwâ, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gumikkáng kayu laguk. Et tamin! Innan nawè. Ajjanin yù umay mangituddu nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Á pagubobuk na paga ni Apu Kesu, limibbè si Kudas, nga mekamapulu duá sù ira sinudduán ni Apu Kesu. Á nepulupulù kâ Kudas yù magaru nga tatolay nga aru ármas da nga badáng ánna palù, nga jinok nayù ira kátannangán nga pári ánna yù ira karakalán na Kudio. ");
INSERT INTO att_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Á lage ra umay, kinagi ni Kudas nira yù panákkilalád da kâ Apu Kesu. Ta kinagi na, “Yù tolay nga ummaták ku sangaw, aggina yù aleran naw. Á gaputan naw laguk,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Á yáyù nga dagarágâ nga jimikkì si Kudas kâ Apu Kesu. “Apu!” kun na kâ Apu Kesu, á inummatán na. ");
INSERT INTO att_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Á kinagi ni Apu Kesu kuna, “Arà! Tuppálam mu yù sinalákkuruk mu,” kun na. Á jimikkì laguk kâ Apu Kesu yù ira nagármas, á ginápù da. ");
INSERT INTO att_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Á gapu ta paggápù da kâ Apu Kesu, ajjan yù tádday nga kabbulun na nga inásù na yù badáng na, á kittak na yù aripan nayù kotunán nga pári, á napingarán yù talingá na. ");
INSERT INTO att_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngam kinagi ni Apu Kesu kuna, “Iyalák mu yù badáng mu, ta yù tolay nga mangiyusá ta badáng nga mangnguá ta tolay, aggina gapay yù matay ta badáng. ");
INSERT INTO att_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Arám mu panò ammu ta ajjan yù awayyâ nga makimállà ta abbágán nangà nayù Yámà, á dagarágâ nga doban na yù jinibiribu nga daroban na nga umay mangiyígù nikán? ");
INSERT INTO att_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngam nu kiddawak ku nakuan yù kunnian nga ángngabbák na nikán, ari garè mapatuppál yù dán nga inipetúrâ na ngaw.” ");
INSERT INTO att_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Á kinagi na laguk ni Apu Kesu sù ira magaru nga ajjan tán, “Tulisánà panò, ta nattagibadáng ánna nattagipalù kayu nga umay maggápù nikán? Arán nawà ginápù sù ngaw pagitubang ku ta kággággaw sù mangilin nga bale ni Namarò nga nangituddu nikayu. ");
INSERT INTO att_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngam mesimmu ngámin danniaw tapè matuppál yù inipetúrâ na ngaw ni Namarò sù ira ngaw ábbilinán na,” kun ni Apu Kesu. Á yù ira ngámin nga sinudduán na, dagarágâ nga nattaláwád da laguk si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Á paggápù nayù ira nagármas kâ Apu Kesu, inipáno ra ta ed da ituluk sù bale ni Kayapas nga kotunán nayù ira pári. Á nepaggagammung tán yù ira mesturu nga mangituddu sù tunung ánna yù ira karakalán na Kudio. ");
INSERT INTO att_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Á jimináddán si Eduru, ngam arayyu lâ nira. Á pakáddè da ta námmuák na bale nayù kotunán nayù ira pári, minay si Eduru gapay ta námmuák ánna nepagitubang sù ira magguárdiá, tapè mánnámmuán na yù kabalin na. ");
INSERT INTO att_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Á yù ira kátannangán nga pári ánna yù ira giriámán nga Kudio, nagala-alek ira ta massistígu nga massirisiri ta ipappaliwâ da kâ Apu Kesu, tapè mapapáte ra. ");
INSERT INTO att_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Á mássiki nu aru yù ira massirisiri ta pangikeká ra kuna, awán ta nálerád da nga ipamapáte ra kuna. Á ta manganánnuán, ajjan yù duá nga tolay nga minay, ");
INSERT INTO att_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nga nakkagi, “Yane tolay, kinagi na ta ajjan yù awayyá na nga dabbátan yù mangilin nga bale ni Namarò, á patáddagan na galâ, á balinan na ta mekatallu nga ággaw,” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Á pakaginná nayù kotunán na pári sù kinagi ra, limikkâ laguk, á iniyabbû na kâ Apu Kesu, “Anni yù itabbák mu karanniaw nga ipappaliwâ da nikaw?” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngam ari bulubugá nakkituk si Apu Kesu. Á kinagi nayù kotunán nga pári, “Mappagássingán ka sù ngágan nayù siggatotolay nga Namarò, á kagiam mu nikami nu sikaw yù Kiristu nga Anâ ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Á kinagi ni Apu Kesu kuna, “Wan, kuruk yù nakagim. Á kagiak ku nikayu ngámin, ta pappasá na yaw sangaw, nga ari mabayák, masingan nawà, nga Kaká na ngámin na tatolay, nga magitubang sù ággitubangán nayù maráyaw ta jiwanán ni Namarò nga Makáwayyá. Á masingan nawà nga duttál ta kunam nga maggapu ta lángì.” ");
INSERT INTO att_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Á pakaginná nayù kotunán nga pári sù kinagi ni Apu Kesu, pinisil na yù barawási na lápay, nga kunnay ta maguyung. Á kinagi na sù ira kábulun na nga pári, “Narákè yù inubobuk na, ta ipotun na yù baggi na tapè mepaggittá kâ Namarò. Arát tam máwák yù ira massistígu sù ipappaliwâ da kuna. Ye! Naginná naw yù kinagi na nga aggina yù Anâ ni Namarò! ");
INSERT INTO att_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anni laguk yù ure naw?” kun na. Á kinagi ra, “Kuruk nga nalliwâ nga mepángngà nga matay,” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Á nallulutábád da laguk yù mammang ni Apu Kesu, ánna sinusultù da. Á lippilippák da gapay nayù ira káruán. ");
INSERT INTO att_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Á kinagi ra kuna, “Sikaw nga Kiristu, kanu, labbúnam mè nu asinni yù mallappák nikaw!” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Á ajjan lâ paga si Eduru nga nepagitubang ta námmuák nayù balay. Á jimikkì kâ Eduru yù babay nga aripan nayù kotunán nga pári, á kinagi na, “Ari panò sikaw gapay yù nepulupulù kâ Kesu nga taga Galilia?” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Á nilímak ni Eduru ta arubáng da ngámin. Kinagi na, “Arák ku amma-ammu yù kagiam mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Á minárayyu si Eduru ta baddì laguk nga nappángè ta puertá ta jijjing na alitù. Á ajjan tán yù tádday nga aripan nga babay. Á pakasingan na kâ Eduru, kinagi na sù ira tatolay tán, “Yawe laláki yù kabbulun ni Kesu nga taga Nasaret,” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Á pidduá na nilímak ni Eduru. Á nappagássingán, á kinagi, “Arák ku amma-ammu yane tolay!” kun na. ");
INSERT INTO att_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Á manganánnuán, mináranni kâ Eduru yù ira tatolay nga nattatáddak tán, á kinagi ra kuna, “Kuruk nga sikaw gapay yù kabbulud da! Awán ta awayyám nga mangilímak, ta mepaggittá yù ággubobuk mu sù ággubobuk nayù ira taga Galilia,” kud da. ");
INSERT INTO att_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Á nappagássingán má si Eduru, á kinagi na, “Mássiki pagikaruan nangà ni Apu Namarò nu ari kukurugán yù kagiak ku! Arák ku bulubugá amma-ammu yian nga tolay!” kun na. Á dagarágâ nagittarákkò yù manù. ");
INSERT INTO att_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pakaginná ni Eduru ta pagittarákkò na manù, nanonò na yù kinagi ni Apu Kesu kuna, “Lage na pagittarákkò na manù sangaw nu gabi, namillungin yù pakkagim ta arám mà ammu.” Á nánaw si Eduru, ta nepallà yù daddam na, á inigabbuâ na nakkulukulè. ");
INSERT INTO att_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Á ta pannawák, naggagammung yù ira kátannangán nga pári ánna yù ira karakalán, nga nakkaká-ubobuk, tapè igagánge ra yù ámmapáte ra kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Á kabalid da nakkaká-ubobuk, bináluk da si Apu Kesu, á iniyánge ra laguk kâ Gubinador Pilatto nga taga Roma, tapè ikeká ra ta arubáng na. ");
INSERT INTO att_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Á si Kudas nga nangiránuk kâ Apu Kesu, narámak na ta pagikaruad da ta pate na si Apu Kesu nga awán ta liwâ na. Á pakánnámmu ni Kudas sù akkuád da, nakalò yù daddam na, á nabbabáwi laguk sù kingnguá na. Á en na initoli yù tallupulu nga pirâ nga pinaláta sù ira kátannangán nga pári ánna yù ira karakalán. ");
INSERT INTO att_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Á pangitoli na sù pirâ, kinagi na nira, “Apan naw, ta nakaliwákà gapu ta inipagápù ku yù tolay nga awán ta liwâ na,” kun na. Á simibbák ira nga kinagi kuna, “Á arám mi ammu yian! Sikaw lápay yù makaliwâ tán!” kud da kâ Kudas. ");
INSERT INTO att_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Á iniwárì ni Kudas yù tallupulu nga pirâ sù áttallungán nayù mangilin nga kapilliá ni Namarò, á nánaw laguk nga minay nga binesin na yù baggi na, á natay. ");
INSERT INTO att_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Á ta páno ni Kudas, jimmà da laguk nayù ira kátannangán nga pári yù pirâ. Á kinagi ra, “Yawe pirâ yù nepappagá sù inángà na tolay. Mekontará sù tunung tam nu ilannà tam nakuan yawe pirâ sù ággianán nayù kuártu nga nelimù nga napakappián ta mangilin nga kapilliá,” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Á kabalid da nakkaká-ubobuk, ed da laguk inigátáng yù pirâ ta dabbun nayù mináddamili, nga pabbalinad da ta pangitanamád da sù ira ari Kudio. ");
INSERT INTO att_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Á yáyù nga mangngágan yane katanamán ta Naragán ta áddè kunangan, gapu ta ginátáng da sù kuártu nga pagá nayù inángà nayù pinapáte ra. ");
INSERT INTO att_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Á kunnian natuppál yù kinagi na ngaw ni Jeremia, nga yù ngaw ábbilinán ni Namarò, nga dán nga netúrâ nga kunniaw: “Inâ da yù tallupulu nga pirâ nga pinaláta, nga pagá na inángà na tolay nga kinagi nayù ira taga Israel ta pattarátu ra, ");
INSERT INTO att_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","á inigátáng da ta dabbun nayù mináddamili, gapu ta yáyù kinagi ni Namarò nikán.” ");
INSERT INTO att_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Á pakáddè nayù ira karakalán na Kudio ta gián ni Gubinador Pilatto, iniyarubáng da si Apu Kesu sù Gubinador, tapè bestigarán na. Á iniyabbû ni Pilatto kuna, “Sikaw panò yù patul nayù ira Kudio?” Á simibbák si Apu Kesu, nga kun na, “Kuruk yù nakagim,” kun na. ");
INSERT INTO att_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngam sù pamaliwâ da kuna nayù ira kátannangán nga pári ánna yù ira karakalán, awán bulubugá ta itabbák na. ");
INSERT INTO att_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Á yáyù nga kinagi nayù Gubinador kuna, “Arám mu panò maginná yù ipappaliwâ da nikaw?” kun na. ");
INSERT INTO att_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngam ari bulubugá simibbák si Apu Kesu. Awán bulubugá ta initabbák na sù ipappaliwâ da kuna. Á yáyù nga nakalò yù kapállâ nayù Gubinador sù pagimammà na. ");
INSERT INTO att_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Á kádaragun sù piestá na panaddamád da sù pattalebák nayù daroban, ajjan yù kustombare nayù Gubinador nga mamalubbáng sù tádday nga nebáluk nga pilian nayù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Á tán nga ággaw, ajjan yù nebáluk nga mangngágan ta Kesu Barabas, nga neparámak sù ira ngámin nga tatolay megapu sù narákè nga kingngikingnguá na. ");
INSERT INTO att_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Á paggagammung nayù ira magaru nga tatolay, yáyù nga iniyabbû na laguk ni Gubinador Pilatto nira, “Asinni yù ikáyâ naw nga palubbángak ku? Si Kesu Barabas? Onu si Kesu nga mangngágan ta Kiristu?” kun na. ");
INSERT INTO att_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ta ammu ni Pilatto ta mangabubu yù ira karakalán nga Kudio kâ Apu Kesu, á yáyù lâ yù ipangikeká ra kuna. ");
INSERT INTO att_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Á pagitubang na paga ni Gubinador Pilatto sù ámmanunnután, inipakagi nayù atáwa na kuna, “Arám mu akkuán bulubugá yane tolay nga awán ta liwâ na. Ta narigákà ta pattatagenà ku sù gabi, á nepallà yù burung ku megapu kuna!” ");
INSERT INTO att_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ngam yù ira kátannangán nga pári ánna yù ira karakalán, pinappatapátu ra yù ira magaru nga tatolay ta kiddawad da kâ Pilatto ta palubbángan na si Barabas ánna ipapáte na si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Á pidduán na laguk nayù Gubinador nga nangiyabbû nira, “Asinni sawe ira duá yù ikáyâ naw nga palubbángak ku?” kun na. Á kinagi ra, “Si Barabas!” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Á iniyabbû ni Pilatto nira, “Anni laguk yù akkuák ku kâ Kesu nga mangngágan ta Kiristu?” kun na. “Ipepátà mu ta kurù!” kud da ngámin. ");
INSERT INTO att_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Á iniyabbû na má ni Pilatto, “Anni má? Anni panò yù liwâ na?” kun na. Á nappanà ira nga nangikatakatol, nga kud da, “Arà! Ipepátà mu ta kurù!” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Á pakánnámmu ni Pilatto ta awánin ta awayyá na sù ira magaru, ánna natagenà na ta ajjan sangaw yù akkuád da nga jikkù gapu ta nappanà yù pagaragiák da, á nangâ yù Gubinador ta danum tapè baggawán na yù limá na ta arubáng nayù ira tatolay. Á pabbaggo na, kinagi na nira, “Akkuák ku yaw nga ipakánnámmù nikayu ta awán ta liwâ ku megapu sù pamapáte naw sawe tolay! Sikayu lággapay noka yù manabbák kuna!” kun na nira. ");
INSERT INTO att_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Á inikatol nayù ira ngámin nga tatolay nga kinagi ra, “Paguráyám mu lâ, ta sikami ánna yù ira gakagaká mi noka yù manabbák sù kapapáte na!” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Á yáyù nga pinalubbáng na laguk ni Pilatto si Barabas nira. Á kabalin na nangipapaligà kâ Apu Kesu, iniyawâ na sù ira suddálu, tapè ipátà da ta kurù. ");
INSERT INTO att_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Á initallung da laguk nayù ira suddálu ni Pilatto si Apu Kesu sù bale nayù Gubinador. Á inagálád da ngámin yù ira káruán nga kábulud da nga suddálu, á nagarimummungád da si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Á niluppù da yù barawási na, á binarawasiád da ta apaddu nga ujjojjin, nga kun na barawási na patul. ");
INSERT INTO att_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Á nilubik da yù sî nga pidde ra ta kun na kuroná, nga inibarungù da kuna. Á inipatangngal da yù tagisi ta jiwanán nga limá na nga kun na baston na patul. Á namalittúkak ira ta arubáng na, nga áppè maddayaráyaw ta panguyo ra kuna. Á kinagi ra, “Ajjan ka pá nga maráyaw nga Patul nayù ira Kudio!” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Á nallulutábád da, á inâ da yù tagisi nga sinangngalán na, á inipalapalù da ta ulu na. ");
INSERT INTO att_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Á kabalid da nanguyoyung kuna, iniriád da yù apaddu nga inibarawási ra kuna, á inibarawási ra lággapay kuna yù barawási na lápay. Á inilawád da, tapè ed da ipátà ta kurù. ");
INSERT INTO att_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Á páno nayù ira suddálu ta ili, nga mammártiá ta dálan, nerapunád da yù tolay nga taga Sirine nga mangngágan ta Simon. Á inipakáttu ra kuna yù kurù ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Á nakáddè ira ta gián nga mangngágan ta Golgota, nga Gián na Balakábâ yù kebalinán nayù ngágan na. ");
INSERT INTO att_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Á iniyawâ da nakuan kâ Apu Kesu yù binaráyáng nga nakirugán ta uru nga napè, nga ámmannay ta anutù. Ngam ta pakakákkâ na kuna, arán na ininum. ");
INSERT INTO att_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Á inipátà da ta kurù. Kabalid da nangipátà kâ Apu Kesu ta kurù, nabbúnù ira tapè pabballáyád da yù gámì na. ");
INSERT INTO att_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Á nagitubang ira laguk nga magguárdiá kuna. ");
INSERT INTO att_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Á sù kurù ta aruk na ulu na ajjan yù nipe ra nga netúratán nga inipappaliwâ da kuna nga kunniaw: “Yaw si Kesu nga Patul nayù ira Kudio.” ");
INSERT INTO att_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Á ajjan gapay duá ira nga tulisán nga inipátà da ta kurù da. Á pamatáddak da sù ira kurù da, nattangngán nayù ira tulisán si Apu Kesu, ta pinatáddak da yù tádday sù jiwanán na ánna yù tádday sù jimigi na. ");
INSERT INTO att_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Á yù ira tatolay nga nattalebák tán, gilingilingián ira nga makkakagi kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kinagi ra kuna, “Sikaw yù nakkagi ta dabbátam mu yù bale ni Namarò, á patáddagam mu galâ nga balinan ta tallu nga ággaw! Ye! Arà! Iyígù mu ngè laguk yù baggim, nu Anâ naka ni Namarò! Ámmutták ka ngè laguk saw!” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Á yù ira kátannangán nga pári, yù ira mesturu nga mangituddu ta tunung ánna yù ira karakalán, kunnian gapay yù ángnguyo ra kuna. ");
INSERT INTO att_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kinagi ra, “Ajjan kanu yù ira iniyígù na, ngam arán na meyígù yù baggi na, mássiki nu aggina kanu yù Patul nayù ira taga Israel! Ámmutták laguk nakuan kunangan, á manguruk ittam kuna! ");
INSERT INTO att_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ikatalà na kanu si Apu Namarò! Á kinagi na ta aggina yù kuruk nga Anâ ni Namarò. Si Namarò nakuan laguk yù mangiyígù kuna, nu kuruk nga ikáyâ na,” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Á kunnian gapay yù pamarabárù da kuna nayù ira tulisán nga kagiddán na nga nepátà ta kurù da. ");
INSERT INTO att_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Á ta tangngá na ággaw, nakkallà yù tangapáddabbunán áddè ta alas tares, nga pannarek na bilák ta púgák. ");
INSERT INTO att_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Á ta alas tares ta púgák, inikáddagâ na lâ nakkatol ni Apu Kesu ta nasikan, á kinagi na, “Eli, Eli, lema sabák tani?” kun na. Á yaw kebalinán nayù kinagi na, “Ammò ku nga Apu Namarò, ngattá, ta sinájjiám mà?” kun na. ");
INSERT INTO att_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pakkatol ni Apu Kesu, á yù ira tatolay nga aranni kuna, naginná ra, á kinagi ra, “Katolán na támma yù ngaw Elias nga ábbilinán,” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Á dagarágâ nga nakkarerá yù tádday nira nga en na inâ yù kun na sine na áttabbatabbúrù nga nakatáng. Á inipasassà na sù nássam nga inumad da, á inipe na ta áttukil, tapè ipasussù na kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngam yù ira káruán nga tatolay, kinagi ra, “Magiddak ittam lábbì, tapè masingat tam nu umay si Elias nga mangiyígù kuna,” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Á nakkalli mángin laguk ta nasikan si Apu Kesu, á inibbatán na yù ikararuá na, á nagattâ yù inángà na. ");
INSERT INTO att_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Á pakagattâ na inángà ni Apu Kesu, negiddán nga napisil nga naggadduá yù nakannak nga kortíná nga nerijjing sù kangilinán nga lágum, nga paggianán ni Namarò sù mangilin nga kapilliá. Á namegapu yù pisil na kortíná ta utun na ta áddè ta gukák, ánna nallunik, á napakkapakká yù ira darakal nga batu. ");
INSERT INTO att_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Á nabbukâ yù ira kuebá nga katanamán, á aru yù ira nanguruk kâ Namarò nga naginnanolay laguk nga naggapu sù ira námmatay. ");
INSERT INTO att_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Á gilawalawanán ira sù tanam da. Á ta kabalin ni Apu Kesu nga naginnanolay, minay dannian laguk sù mangilin nga ili na Jerusalem, á aru yù ira tatolay nga nakasingan nira. ");
INSERT INTO att_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Á yù kapitán ánna yù ira suddálu na nga magguárdiá kâ Apu Kesu, pakasingad da ta nallunik ánna yù ngámin nga nesimmu, á nepallà yù assing da. Á kinagi ra, “Kuruk nga Anâ ni Namarò yaw lagugam!” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Á aru gapay yù ira bábbay nga naggián ta arayyu ta baddì, nga mangirípâ. Aggira yù nepulupulù kâ Apu Kesu ánna nangabbák kuna áddè sù páno na ta Galilia. ");
INSERT INTO att_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Á ajjan sù ira bábbay di Maria Maddalena, kári Maria nga yená di Ime kâ Kusè, ánna yù yená nayù ira ánâ ni Sebedo. ");
INSERT INTO att_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Á ta púgágin limibbè yù tádday nga maríku, nga mangngágan ta Kusè nga taga Arimatia. Aggina gapay yù siminuttul kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Á minay laguk kâ Pilatto, á kiniddo na kuna yù baggi ni Apu Kesu. Á binilin ni Pilatto ira ta iyawâ da kuna. ");
INSERT INTO att_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Á en na laguk inâ ni Kusè yù baggi ni Apu Kesu, á binungubungun na sù bagu nga sinnun nga kun na kustombare ra. ");
INSERT INTO att_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Á pineddá na sù unak na kuebá, nga kapákkokkok na lâ paga ta batu tapè dán nga naparán ta baggi na lápay nu matay nakuan. Á iniserrá na sù áttallungán na tanam yù dakal nga batu nga kinarebu na sù puertá na, á nánaw. ");
INSERT INTO att_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Á ajjan paga tán di Maria Maddalena ánna yù tádday nga Maria, nga nabattáng nga nagitubang ta arubáng nayù tanam. ");
INSERT INTO att_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Á ta pannawák na Sabadu, nga ággibannák nayù ira Kudio, minay yù ira kátannangán nga pári ánna yù ira Parisio ta gián ni Gubinador Pilatto. ");
INSERT INTO att_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Á kinagi ra kuna, “Apu, manonò mi yù kinagi nayù minángngilogò ta keggá na paga nga matolay. Kinagi na ta maginnanolay sangaw nu mappasá yù tallu nga ággaw. ");
INSERT INTO att_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Á yáyù nga ikomá mi nikaw ta dobam mu yù ira magguárdiá sù tanam na áddè ta mappasá yù mekatallu nga ággaw, marakè ed da kokotan nayù ira sinudduán na yù baggi na, nepatalugáring ta istoriá ra sangaw ta naginnanolayin. Á nu kunnian yù ángngilogò da sangaw, mappanà laguk sangaw yù pangiloku ra nikami,” kud da. ");
INSERT INTO att_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Wan á,” kun ni Pilatto. “Mangâ kayu laguk sù ira magguárdiá, ánna ipataron naw nira ta napiá yù netanamán na,” kun na. ");
INSERT INTO att_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Á minay ira laguk sù kuebá nga netanamán na, á nasingad da ta naserrán yù tanam ta napiá, á minárkád da yù batu nga tákkak na kuebá, tapè ammu ra nu ajjan yù mabbukâ sù tanam. Á bittáng da laguk tán yù ira suddálu nga magguárdiá. ");
INSERT INTO att_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Á pappasá na Sabadu, nga ággibannák, á ta alippánnawák na Liggu, minay di Maria Maddalena ánna yù tádday nga Maria, sù netanamán ni Apu Kesu, ta ed da sinullúnán. ");
INSERT INTO att_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Á inikáddagâ lâ nallunik ta masikan. Ta ajjan yù daroban ni Namarò nga nappagukák nga naggapu ta lángì, á en na laguk kinarebu yù batu nga nepanerrá sù áttallungán na tanam, á yáyù nagitubangán na. ");
INSERT INTO att_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Á makatulang yù mammang na nga kun na kilâ, ánna kitapuraw yù gámì na. ");
INSERT INTO att_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Á yù ira suddálu nga magguárdiá, pakasingad da kuna, namippippik ira ta assing da, á napeddá ira nga kun na natay. ");
INSERT INTO att_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Á nagubobuk yù daroban sù ira bábbay. Kinagi na nira, “Ari kayu maganássing. Ammù gemma ta ala-aleran naw si Apu Kesu nga nepátà ta kurù. ");
INSERT INTO att_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Awánin saw, ta naginnanolayin nga kun na kinagi na ngaw. Tullung kayu laguk, ta en naw innan yù nagiddán na. ");
INSERT INTO att_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Á mabbíbì kayu lâ, ta mánaw kayu nga umay mangipakánnámmu sù ira sinudduán na ta naginnanolayin, á mapolungin ánnè nikayu nga umay ta Galilia. Maporián kayu laguk, ta masingan naw lâ sangaw túrin. Arà! Mánaw kayin, ta yaw lâ kagiak ku nikayu,” kun nayù daroban nira. ");
INSERT INTO att_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Á pakkagi nayù daroban, inapurá ra laguk nayù ira bábbay nga nánaw sù tanam. Á mássiki nu maganássing ira, ngam nepallà yù pagayáyâ da gapay. Á nakkarerá ira, ta umay ira mangiparámak sù ira sinudduán ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Á páno ra nga nakkarerá, inikáddagâ lâ jiminápun nira si Apu Kesu, á kinagi na nira, “Ajjan kayu pá!” Á pakasingad da kuna, namalittúkak ira ta arubáng na, á sinangngalád da yù takki na ánna nakimoray ira kuna. ");
INSERT INTO att_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Á kinagi ni Apu Kesu nira, “Ari kayu maganássing. En naw laguk kagian sù ira wáwwagì ta umay ira ta Galilia. Á túrin sangaw yù pakkakásinganát tam,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Á páno nayù ira bábbay, nánaw gapay yù ira káruán nga suddálu nga nagguárdiá, á minay ira ta ili na Jerusalem tapè iránuk da sù ira kátannangán nga pári yù ngámin nga nesimmu. ");
INSERT INTO att_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Á yáyù nga nepaggagammung yù ira kátannangán nga pári sù ira karakalán, tapè ubobugad da nu anni laguk yù akkuád da. Á kabalid da nakkaká-ubobuk, aru yù kuártu nga iniyawâ da sù ira suddálu. ");
INSERT INTO att_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Á kinagi ra nira, “Kagian naw lâ sù ira tatolay ta minay yù ira sinudduán ni Kesu ta tangngá na gabi sù pakkaturuk naw, á kinokò da yù baggi na. ");
INSERT INTO att_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Á nu marámak na sangaw nayù Gubinador ta nakkaturuk kayu ta pagguárdiá naw, ari kayu maburung, ta sikami yù makiubobuk kuna, tapè arán nakayu pagikaruan,” kud da nira. ");
INSERT INTO att_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Á inâ da laguk nayù ira suddálu yù kuártu, á kinuruk da yù kinagi ra nga akkuád da. Á yáyù lâ paga yù dámak nga massamâ sù ira Kudio áddè ta ággawo. ");
INSERT INTO att_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Á minay laguk yù ira mapulu tádday nga sinudduán ni Apu Kesu túrin ta Galilia, sù puddul nga kinagi ni Apu nga angayád da. ");
INSERT INTO att_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Á pakasingad da kâ Apu, nakimoray ira kuna, mássiki nu nabbábáng paga yù ira káruán. ");
INSERT INTO att_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Á jimikkì si Apu Kesu nira, á kinagi na nira, “Neddánà sù ngámin pakáwayyá nayù mammaguray ta lángì ánna dabbuno. ");
INSERT INTO att_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Umay kayu laguk ta ngámin nga tatolay ta ngámin nga lugár, á ituddu naw nira yù inituddù nikayu, tapè manguruk ira gapay nikán. Á jigutan naw ira laguk, megapu sù pakáwayyá ni Ammò ku ánna yù pakáwayyâ nga Anâ na, ánna yù pakáwayyá nayù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Á ituddu naw nira ta napiá, tapè tuppálad da ngámin yù bilik ku nikayu. Á nonopan naw yaw, nga ajjanà nga mannanáyun nga mepulupulù nikayu ta áddè ta pagáddekán na ággaw.”");
INSERT INTO att_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Netúrâ sawe yù napiá nga dámak nga meyannung kâ Apu Kesu Kiristu nga Anâ ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kunniaw yù pamegapu nayù napiá nga bilin ni Namarò. Ajjan yù inipetúrâ ni Namarò kâ Isaya, nga yù ngaw nabbilinán na. Á initúrâ ni Isaya yù kinagi na ngaw ni Namarò sù Anâ na, nga kun na, “Yawe yù ábbilinák ku nga dobak ku ta mapolu ánnè nikaw, tapè paránan na yù dálan nga pallakarám mu. ");
INSERT INTO att_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aggina yù makkatakatol ta kalállammatán. Yaw ikatakátol na: ‘Umayin si Apu! Paránan naw yù dálan na. Tunungan naw yù pallakarán na.’ ” ");
INSERT INTO att_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Á napalurò yawe nga initúrâ ni Lákay Isaya, ta jimittál ta kalállammatán si Kuan nga Manigù. Á aru yù ira tatolay nga minay ta kalállammatán, tapè ginniginnád da yù kagian na. Á kinagi na nira, “Mabbabáwi kayu sù liwiliwâ naw, ánna makirigù kayu, nga pangipasinganán naw sù pabbabáwi naw, á pakomán na kayu ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Á naddagaráddán yù ira tatolay nga minay kâ Kuan ta kalállammatán, nga naggapu ta tanga purubinsia na Judiya ánna yù ira ngámin nga taga Jerusalem. Á inipalapalappâ da yù liwiliwâ da, á jinigù ni Kuan ira sù danum na Jordan. ");
INSERT INTO att_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nabbarawási si Kuan ta gámì nga napadday ta duddù na kamel, nga ayám nga sináppukul barâ na. Á nabbarakà ta tabbì na ayám. Á yá lâ kanan na yù durun ánna issi na asúkán. ");
INSERT INTO att_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Á yawe yù bilin nga inilayalayâ ni Kuan: “Ajjan yù umayin nga maporián nga tumubbâ nikán, nga makáwayyá ánnè nikán. Á aringà mepángngà nga mangubbák ta kaddang na sapátù na. ");
INSERT INTO att_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Á jigutat takayu, á danum lâ yù ipanigù ku nikayu. Ngam aggina, ta panigù na nikayu, tanakuán yù ánnigù na. Ta ari danum yù ipanigù na nu ari galâ yù Mangilin nga Ikararuá, nga ipepulù na nikayu,” kun ni Kuan sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Á pangilayalayâ ni Kuan ta kalállammatán, minay kuna si Apu Kesu, nga naggapu ta ili na Nasaret ta purubinsia na Galilia. Á jinigù na laguk ni Kuan sù danum na Jordan. ");
INSERT INTO att_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gon ni Apu Kesu nga naggapu ta danum, dagarágâ nga nasingan na yù lángì nga nabukatán ánna yù Ikararuá ni Namarò nga mappagukák nga umay maddappá kuna ta kun na palomá. ");
INSERT INTO att_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Á ajjan yù ngárál nga naggapu ta lángì, á kinagi na, “Sikaw yù Anâ ku nga iddukak ku, á ayatánà nikaw!” ");
INSERT INTO att_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Á kabalin ni Namarò nga nagubobuk, dagarágâ nga inipángè nayù Mangilin nga Ikararuá si Apu Kesu ta kalállammatán. ");
INSERT INTO att_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Á naggián si Apu Kesu ta kalállammatán ta appátapulu nga ággaw, ánna pinarubán ni Satanas nga liwatan na. Á awán ta kabbulun na, nu ari lâ yù ira simaron nga ayám. Ngam minay yù ira daroban ni Namarò nga mangabbák kuna. ");
INSERT INTO att_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Á nipagápù nayù mammaguray ta Judiya si Kuan, nga pinukù na ta ábbalurán. Á ta keggá ni Kuan ta ábbalurán, nánaw si Apu Kesu nga nanoli ta Galilia, nga mangilayalayâ sù napiá nga dámak nga bilin ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yá inilayalayâ na, “Natuppálin yù ággaw nga sinullà ni Namarò. Á duttálin nikayu yù pammagure ni Namarò. Likurán naw laguk yù liwiliwâ naw, á kurugan naw yù napiá nga dámak,” kun na. ");
INSERT INTO att_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Á ta pattalebák ni Apu Kesu ta aggik na bebay na Galilia, nasingan na yù ira duá nga mawwagi, di Simon kâ Andares, nga mattabukul, gapu ta yáyù ángngalluád da. ");
INSERT INTO att_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pakasingan ni Apu Kesu nira, inagálán na ira, “E kayu saw ta tumuttul kayu nikán,” kun na. “Á ta kun na káru na sirá nga apan naw kunangan, á kunnian gapay yù káru na tatolay nga patuttulan naw nikán noka,” kun na. ");
INSERT INTO att_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pakaginná ra sù kinagi na, dagarágâ nga nánawád da yù ira tabukul da. Á minay ira nepulupulù nga makituddu kuna. ");
INSERT INTO att_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Á nallakák di Apu Kesu ta baddì paga ta aggik na bebay. Á pakáddè da ta baddì, nasingan na yù ira duá nga ánâ ni Sebedo, di Ime kâ Kuan, nga ipolì da yù ikà da sù barange ra. ");
INSERT INTO att_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pakasingan ni Apu Kesu nira, dagarágâ nga inagálán na ira gapay. Á nánawád da di Sebedo nga ammò da sù barangay, ánna yù ira kábulud da nga minággissirá. Á minay ira nepulupulù nga makituddu kâ Apu Kesu gapay. ");
INSERT INTO att_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Manganánnuán, limibbè di Apu Kesu ta ili na Kapernium. Á kunnay ta kustombare na Kudio ta ággaw na Sabadu nga ággibannák da, dagarágâ nga simillung si Apu Kesu ta kapilliá, á nangituddu sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Á pakaginná ra kuna, napállâ ira sù pangituddu na, gapu ta makáwayyá yù ángngituddu na ánnè sù ángngituddu nayù ira mesturu na rilisiod da. ");
INSERT INTO att_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Á simillung laguk sù kapilliá yù tolay nga naggusapel ta mamopoyung nga anitu. ");
INSERT INTO att_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Á iniyássa-ássikan na yù ubobugan na, á kinagi na, “Anni yù akkuám mu nikami nga anitu, Kesu nga taga Nasaret? Em mu kami talamánan? Ammu taka gemma, sikaw yù Mangilin nga naggapu kâ Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngam gimmá ni Apu Kesu, “Arám mà ubu-ubobugán. Panawám mu yawe tolay.” ");
INSERT INTO att_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Á pinabballiák nayù anitu yù tolay. Á pakkalli nayù anitu, nánawán na. ");
INSERT INTO att_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Á yù ira tatolay nga naggagammung, pakasingad da karanniaw, napállâ ira. Á nakkaká-ubobuk ira, á kinagi ra, “Anni panò danniaw? Kuruk nga bagu yù ituddu na gemma! Sigga-pakáwayyá nga maggammá, mássiki sù ira mamopoyung nga anitu, á kurugad da yù kagian na!” kud da. ");
INSERT INTO att_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Á dagarágâ nga iniparámak da yù meyannung kuna sù tanga purubinsia na Galilia. ");
INSERT INTO att_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Á kabalin ni Apu Kesu namapánaw sù anitu, dagarágâ nga nánaw sù kapilliá, nga nepulù kári Ime kâ Kuan, á minay ira ta bale ri Simon kâ Andares. ");
INSERT INTO att_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Á labbè da ta bale ra, naratang da yù bakabákà nga katugángán ni Simon, nga nagiddá gapu ta makkulikuk. Á dagarágâ da nga kinagi kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pakaginná ni Apu Kesu, jimikkì kuna. Á sinangngalán na yù limá na, á pinagikkáng na. Á gikkáng nayù bakabákà, nammapiá ngin. Á en na ira pinakán. ");
INSERT INTO att_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Á manganánnuán, ta pajjibbà, minay kâ Apu Kesu yù ira tatolay nga nangituluk sù ira máttakì ánna yù ira tarepoyungán na anitu. ");
INSERT INTO att_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Á naggagammung ira ngámin nga tangelián nga naddarassil sù lawán na puertá na balay. ");
INSERT INTO att_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Á aru yù ira pinammapiá ni Apu Kesu, nga natakì ta makkakerumá nga takitan. Á aru yù ira anitu nga pinapáno na, á arán na ira anugutan nga magubobuk, ta ammu ra ta aggina yù Anâ ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Á ta alippánnawák, pagittarákkò na manù, nallákuâ nga nánaw si Apu Kesu nga minay ta gián nga awán ta tatolay, tapè makimállà kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Á pakánnámmu ra ta awán si Apu Kesu, minay di Simon ánna yù ira kábulun na nga magalek kuna. ");
INSERT INTO att_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pakálek da kuna, kinagi ra, “Ngámin nga tatolay, alerad daka,” kud da. ");
INSERT INTO att_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","“Mánaw ittam laguk,” kun ni Apu Kesu nira. “Et tamin sù ira káruán nga babálay, tapè ilayalayâ ku nira gapay yù napiá nga dámak, ta yáyù sinalákkuruk ku nga minay saw,” kun na. ");
INSERT INTO att_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Á minay laguk nga mangilayalayâ sù ngámin nga kapilliá na Kudio sù tanga purubinsia na Galilia, á pinapáno na yù ira anitu sù ira tatolay nga baránituán. ");
INSERT INTO att_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Á minay jimikkì kâ Apu Kesu yù naggoggong, á namalittúkak ta arubáng na nga makimállà kuna, á kinagi na, “Apu, nu ikáyâ mu, makáwayyá ka nga mamammapiá nikán,” kun nayù naggoggong kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Á pakasingan ni Apu Kesu kuna, nakalò yù allà na. Á sinonnâ na yù limá na, á sinámmì na yù naggoggong. Á kinagi na kuna, “Yáyù gemma ikáyâ ku akkuan! Mammapiá ken laguk,” kun na. ");
INSERT INTO att_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Á ta pagubobuk ni Apu Kesu, dagarágâ nga nammapiá yù naggoggong, ánna napakarenuánin yù baggi na. ");
INSERT INTO att_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Á lage na pinapáno ni Apu Kesu yù tolay, sinaddánán na. ");
INSERT INTO att_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Á kinagi na, “Arám mu bulubugá kagian ta tolay. Daretiu ka nga umay mappasingan sù pári na Kudio. Á ipeyátáng mu sù pári yù iyawâ mu kâ Namarò nga kunnay sù kinagi ni Moyses, tapè manguruk yù ira tatolay ta napakarenuán ken,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngam ta páno na tolay, en na garè iniparámak sù ili ánna babálay. Á yáyù nga ari makángay si Apu Kesu ta ili, marakè maggugúru yù ira tatolay kuna. Á naggián lâ ta agayyuán. Á naddagaráddán yù ira tatolay nga minay kuna nga naggapu ta ngámin nga lugár. ");
INSERT INTO att_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Á pappasá nayù ira ággaw nga pangituddu ni Apu Kesu ta agayyuán, nanoli ta ili na Kapernium. Á narámak nayù ira tatolay yù labbè na. ");
INSERT INTO att_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Á minay ira naggagammung sù gián na, áddè ta awán ta paggianád da mássiki sù lawán na puertá. Á inilayalayâ na nira yù bilin ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Á pangilayalayâ ni Apu Kesu, limibbè yù appâ nga tolay, á kináttu ra yù tolay nga matakì, nga kun na natay baggi na. ");
INSERT INTO att_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Á gapu ta ari ira makarakkì kâ Apu Kesu megapu ta magaru nga tatolay, minunè ira ta sináttatapán nga atà na balay. Á binobbotád da yù atà sù aruk ni Apu Kesu, nga pangilabbutád da sù matakì, nga nagiddá sù dapan na. Á inayáyud da sù arubáng ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Á pakasingan ni Apu Kesu ta inipanapanà da lâ nga inituluk kuna, natagenà na yù ángngikatalà da kuna, á kinagi na sù tolay nga kun na natay yù baggi na, “Kopun, napakomá ngin yù ira liwiliwâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Á nagitubang gapay tán yù ira mesturu nga mangituddu sù tunung. Á pakaginná ra sù kinagi ni Apu Kesu sù matakì, kagiad da ta nonò da, ");
INSERT INTO att_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ngattá, ta kunniaw yù ubobuk na yawe tolay? Potuán na pá si Namarò! Asinni panò makapakomá ta liwâ nu ari lâ si Namarò!” kud da ta nonò da. ");
INSERT INTO att_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Á dagarágâ nga natagenà ni Apu Kesu yù nonò da. Á kinagi na nira, “Ngattá, ta kagian naw ta nonò naw ta awánà ta awayyá nga makkagi sù kinagì sù matakì? ");
INSERT INTO att_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Anni panò yù ikáyâ naw nga kagiak ku nakuan sù tolay nga kun na natay yù baggi na? Á ta ángngarigán, nu kagiak ku kuna nakuan, ‘Napakomá ngin yù ira liwiliwâ mu,’ onu kuk ku lâ, ‘Gumikkáng ka, apam mu yù dapam mu, á mallakák ka,’ kuk ku nakuan? ");
INSERT INTO att_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngam yawe yù akkuák ku, tapè kánnámmuán naw ta sikán nga Kaká na ngámin na tatolay yù makáwayyá sawe dabbuno nga mamakomá ta liwâ,” kun ni Apu Kesu nira. Á kinagi na sù matakì nga natay yù baggi na, ");
INSERT INTO att_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Yawe yù kagiak ku nikaw. Gumikkáng ka laguk, á apam mu yù dapam mu, á lubbè ka lâ ta balem,” kun na. ");
INSERT INTO att_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Á gimikkáng yù matakì, á dagarágâ inakkâ na yù dapan na. Á ta arubáng da ngámin, nappabattáng nira nga nánaw. Á napállâ ira, á jináyo ra si Namarò. Á kinagi ra, “Awán paga ta nasingam mi nga kunniaw, nu ari lâ paga kunangan,” kud da. ");
INSERT INTO att_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Á nánaw si Apu Kesu nga nanoli ta aggik na bebay. Á nallalabbè kuna yù magaru nga tatolay. Á sinudduán na ira. ");
INSERT INTO att_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Á manganánnuán, nallakák paga, á nasingan na si Libi nga anâ ni Alpio nga mináttuki ta buwì nga nagitubang sù upisína na. Á kinagi ni Apu Kesu kâ Libi, “Tuttulam mà.” Á gimikkáng si Libi, á siminuttul kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Á minay laguk di Apu Kesu ánna yù ira makituddu kuna nga nepakkákán sù bale ni Libi. Á nepagitubang tán gapay yù ira kábulun ni Libi nga minángngalawâ ta buwì ánna yù ira káruán nga minálliwâ, gapu ta aru yù ira danniaw nga siminuttul kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Á yù ira mesturu nga Parisio, nasingad da si Apu Kesu nga nepakkákán sù ira minálliwâ ánna yù ira mináttuki ta buwì, nga maddarogà ánna mangilogò. Pakasingad da ta nepakkákán si Apu Kesu sù ira ilulluddè da, kinagi ra sù ira tudduán ni Apu Kesu, “Ngattá ta mepakkákán sù ira mináttuki ta buwì ánna yù ira káruán nga minálliwâ?” kud da. ");
INSERT INTO att_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Á pakaginná ni Apu Kesu sù iniyabbû da, kinagi na nira, “Á yù ira nga napiá yù gawagawáyád da, ari ira magáwák ta minángnguru, nu ari galâ yù ira máttakì. Á sikán, aringà umay nga magágál sù ira nga kagiad da ta awán ta liwâ da, nu ari galâ ta umayà nga magágál sù ira nga ammu ra yù liwâ da.” ");
INSERT INTO att_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Á yù ira makituddu kâ Kuan ánna yù ira makikultu ta Parisio, ngilinad da yù tádday nga ággaw nga ari ira kumán, tapè makimállà ira kâ Apu Namarò. Á minay yù ira káruán nga tatolay nga nangiyabbû kâ Apu Kesu, á kinagi ra, “Mesturu, ari kumán yù ira makituddu kâ Kuan ánna yù ira Parisio. Ngam yù ira tudduám mu, anni má ta kumán ira?” kud da. ");
INSERT INTO att_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Á kinagi ni Apu Kesu nira, “Á ta ángngarigán, nu ajjan yù bodá, manakì panò kumán yù ira makibodá nu ajjan yù nobiu nira? Arán na awayyá nga ari ira kumán nu ajjan paga yù nobiu nira. ");
INSERT INTO att_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Á duttál sangaw yù ággaw nga páno nayù nobiu nira, á maraddam ira, á ari ira laguk kumán,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Á nagángngarigán si Apu Kesu, ta ipakánnámmu na nira ta ari metádday yù ngaw netuddu nira ánna yù ituddu na nira. Á kinagi na, “Awán ta magappíl ta bagu ta dán nga sinnun, ta nu meyappíl kuna, kubbà yù bagu sangaw nu mebábbál ánna mapisil yù dán, á mappanà laguk yù pisil na sangaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Á kunnian gapay sù ira nga mappadday ta binaráyáng. Awán ta mangipay ta issi sù dán nga tabbì, gapu ta nataggâ yù tabbì. Ta nu dán nga tabbì yù pangipayyán na, mabattâ sangaw ta pagassam nayù issi, á mebuttu laguk, á kengá lâ yù binaráyáng ánna yù ággianán na gapay. Máwák yù tabbì nga bagu nga malapà, nga pangipayyád da, tapè ari mabattâ,” kun na. ");
INSERT INTO att_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Á sù tádday nga Sabadu, nga ággaw nga ággibannák da, nallakák di Apu Kesu sù dálan nga natangngán na ákkomanán. Pattalebák da, nangâ yù ira tudduán ni Apu Kesu sù nataggatán nga dáwa. ");
INSERT INTO att_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Á yù ira Parisio, nasingad da ira. “Innam mè!” kud da kâ Apu Kesu. “Ngattá ta akkuád da yù ipugik nayù tunung tam sù ággaw na ággibannák?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","“Wan ay,” kun ni Apu Kesu nira. “Á arán naw panò binibbik yù meyannung sù kingnguá na ngaw ni Patul Dabid nga ipugik nayù tunung tam gapay? Nabisinán di Dabid ánna yù ira kábulun na. ");
INSERT INTO att_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Á dagarágâ simillung si Dabid sù bale ni Namarò sù keggá ni Abiatar nga kátannangán nga pári. Á inâ na yù pán nga neyátáng nayù pári kâ Namarò, á kinán na ánna iniyawâ na gapay sù ira kábulun na, nga mepugik nga kanan na tolay. Yù lâ pári yù mepángngà nga kumán kuna. Ngam arán na paliwatan ni Namarò si Dabid sù kingnguá na. ");
INSERT INTO att_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta pinarò ni Namarò yù tolay, nga ari megapu sù ággaw nga ággibannák, ngam sinullà na yù ággaw nga ággibannák megapu sù máwák na tolay nga magibannák. ");
INSERT INTO att_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngam egga gapay yù máwák na tolay nga kanan. Á sikán nga Kaká na ngámin na tatolay, makáwayyángà nga makkagi sù mepángngà nga akkuán na tolay ánna mepugik nga akkuád da ta ággaw nga ággibannák,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Á minay má ngin simillung si Apu Kesu ta kapilliá na Kudio sù ággaw nga ággibannák. Á ajjan sù kapilliá yù tolay nga nassesseng limá na. ");
INSERT INTO att_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Á ajjan gapay tán yù ira Parisio, á sisímád da si Apu Kesu tapè masingad da nu pammapián na yù nassesseng sù ággaw nga ággibannák, tapè ikeká ra. ");
INSERT INTO att_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pakasingan ni Apu Kesu sù nassesseng, kinagi na kuna, “E ka bì saw.” ");
INSERT INTO att_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A kinagi na laguk sù ira massísim kuna, “Anni yù kagian nayù tunung tam nga meyannung sù akkuát tam sù ággaw na ággibannák? Máyâ yù mangabbák onu yù mangnguá ta tolay? Iyígù tam nakuan yù ikáttole tam onu papatáyat tam ira?” kun na nira. Ngam ari ira bulubugá nakkituk. ");
INSERT INTO att_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Á nallipilipay si Apu Kesu nira, á napporay ánna nakalò yù daddam na gapu ta nataggâ yù nonò da, ta arád da ikállà yù tolay. Á kinagi na laguk ni Apu Kesu sù tolay nga nassesseng limá na, “Sonnatam mu yù limám.” Á sinonnâ na, á nammapiá ngin yù limá na. ");
INSERT INTO att_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Á pakasingan nayù ira Parisio sù kingnguá ni Apu Kesu, dagarágâ nallawán ira ta kapilliá, á makiubobuk ira sù ira tatole ni Patul Erodo, nu kunnasi yù ámmapáte ra kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Á nallillì laguk di Apu Kesu ánna yù ira tudduán na ta ili, nga minay ta bebay. Á jimináddán nira yù ira magaru nga tatolay nga naggapu sù ira purubinsia na Galilia ánna Judiya. ");
INSERT INTO att_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Á aru ira gapay nga naggapu ta ili na Jerusalem, ánna yù lugár na Iddumia, yù dammáng na Jordan, á yù ira ili na Tiro ánna Sidon ánna yù lugár ta lepuád da. Minay yù ira ngámin nga tatolay kâ Apu Kesu, gapu ta narámak da yù akka-akkuán na nga makapállâ. ");
INSERT INTO att_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Á gapu sù ira magaru nga minay kâ Apu Kesu, inipaparán na sù ira makituddu kuna yù barangay nga pagitubangán na, tapè ari marappì sù ira tatolay nga naddarassil ta aggik na bebay. ");
INSERT INTO att_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Á gapu ta aru yù ira máttakì nga pinammapiá na, naggugúru yù ira ngámin nga máttakì nga maniggek kuna. ");
INSERT INTO att_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Á yù ira nagunagán na anitu, pakasingad da kuna, namalittúkak ira ta arubáng na, á inikalli ra, “Sikaw yù Anâ ni Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngam gimmá na ira ta arád da ipakánnámmu. ");
INSERT INTO att_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Á giminon si Apu Kesu ta puddul. Á inagálán na yù ira tatolay nga inikáyâ na, á minay ira kuna. ");
INSERT INTO att_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Á sinullà na yù ira mapulu duá, tapè mepulù ira kuna, ánna doban na ira ta umay mangilayalayâ. ");
INSERT INTO att_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Á inipe na nira yù pakapangnguá na nga mamapánaw ta anitu. ");
INSERT INTO att_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Á danniaw yù ira mapulu duá nga sinullà na: si Simon nga iningágan na ta Eduru, ");
INSERT INTO att_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","á yù ira duá nga ánâ ni Sebedo, di Ime kâ Kuan, nga iningágan na ta Buanages. Á yù kebalinán na, ánâ na alittúgaw. ");
INSERT INTO att_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Á si Andares gapay kâ Pilippi, si Bartolome, si Mattiu, si Tomâ, si Ime nga anâ ni Alpiu, si Tajjio, si Simon nga Mengal, ");
INSERT INTO att_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","á si Kudas Iskariote nga nabbalin ta mappagápù kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Á gapu ta kabalin na nanullà sù ira tudduán na, limibbè si Apu Kesu ta paggianán na. Á naggagammung mángin yù ira magaru sù gián na. Á yáyù nga arád di Apu Kesu natángngák nga kumán. ");
INSERT INTO att_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Á pakarámak nayù ira kanakanáyun ni Apu Kesu, ed da nakuan gaputan, ta kagiad da ta magisassay maguyung. ");
INSERT INTO att_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Á ajjan gapay yù ira mesturu na Kudio, nga naggapu ta ili na Jerusalem. Á kinagi ra sù ira tatolay, “Aggina, nagunagán ni Satanas, nga patul nayù ira anitu, á iyawâ ni Satanas kuna yù pakapangnguá na nga mamapánaw ta anitu,” kud da. ");
INSERT INTO att_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Á inagálán na ira laguk ni Apu Kesu. Á iniyángngarigán na yù itabbák na nira, á kinagi na, “Ikáyâ ni Satanas panò papanáwan yù ira anitu sù ira tatolay? ");
INSERT INTO att_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Á nu ángngarigán ta ajjan yù páppatulán, nga maddaráma yù ira tatole na, mabì lâ yù pagáddekán nayù páppatulád da. ");
INSERT INTO att_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Á kunnian gapay sù ira makkakábbalay, nu maddaráma ira, ari ira gemma makapaggián sù bale ra. ");
INSERT INTO att_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Á nu maddaráma di Satanas ánna yù ira anitu nga masserbi kuna, ari mabayák yù pammagure na, ta duttálin yù áddè na. ");
INSERT INTO att_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Á ta ángngarigán, awán ta makatallung sù bale nayù masikan, nu arán na olu nga igálù, tapè apan na yù maguray lâ nga ikáyâ na. ");
INSERT INTO att_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ginnán naw laguk, ta kuruk yù kagiak ku nikayu, mapakomá yù ira tatolay sù ngámin nga liwiliwâ da, mássiki yù ira nga magubobuk ta narákè kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngam yù makkakagi ta narákè sù Mangilin nga Ikararuá, ari bulubugá mapakomá yù liwâ na ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yáyù initabbák ni Apu Kesu nira, gapu ta kinagi ra ta aggina yù nagunagán na anitu. ");
INSERT INTO att_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Á limibbè yù yená ni Apu Kesu ánna yù ira wáwwagi na, á naggián ira ta námmuák na balay. Á inipágál da si Apu Kesu ta umay nira ta lawán. ");
INSERT INTO att_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Á aru yù ira tatolay nga nagarimummung kâ Apu Kesu sù unak na balay. Á kinagi ra kuna, “Ajjan ta lawán si innò mu ánna yù ira wáwwagim, á ipágál daka,” kud da. ");
INSERT INTO att_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Á simibbák si Apu Kesu, á kinagi na, “Asinni yù kuruk nga yenâ? Asinni yù ira kuruk nga wáwwagì?” kun na. ");
INSERT INTO att_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nilipilipe na yù ira nagarimummung kuna, á kinagi na, “Danniaw ira yù pannakayenâ ánna pannakawáwwagì! ");
INSERT INTO att_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ta ngámin ira nga mamalurò sù ipakuá ni Namarò nira, aggira yù meyárik ta wáwwagì nga lálláki ánna wáwwagì nga bábbay ánna yenâ,” kun na. ");
INSERT INTO att_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Uli otturu nga pangituddu ni Apu Kesu ta aggik na bebay, kitáru yù ira tatolay nga minay kuna. Á yáyù nga nappittà ta barangay nga nappatangngá ta baddì, á naggián yù ira tatolay ta aggik. Á nagitubang si Apu Kesu nga nangarubáng nira. ");
INSERT INTO att_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Á ta pangituddu na, nagángngarigán, á aru yù inituddu na nira. Kinagi na, ");
INSERT INTO att_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ginnán naw laguk. Ajjan yù tolay nga minámmulá, á en na iwárì yù bini sù ákkomanán na. ");
INSERT INTO att_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pangiwárì na ta bini, natágâ yù baddì ta aggik na dálan, á dagarágâ nga kinán nayù mammánù ira. ");
INSERT INTO att_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Á natágâ yù baddì ta gián na batu, nga baddì lâ yù dabbun na, á mabì mattubbu. ");
INSERT INTO att_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Á sangaw nu mabilagán, malelay gapu ta ari naggamù ta napiá. ");
INSERT INTO att_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Á natágâ yù baddì nga bini paga ta kasisítán. Á gapu ta alistu yù paddakal nayù sî, nabalabáluk yù bini, á ari makapabbungá. ");
INSERT INTO att_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Á yù bini nga iniwárì na tolay sù ákkomanán na, jiminakal, á nabbungá ngámin. Ajjan yù bini nga kustu yù ábbungá na, ánna ajjan nga kitapiá yù ábbungá na, ánna ajjan gapay nga kapiánán yù ábbungá na. ");
INSERT INTO att_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Á sikayu nga makaginná, ginnán naw ta napiá yù kagiak ku,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Manganánnuán, páno nayù ira magaru, ajjan lâ paga kâ Apu Kesu yù ira nga makituddu kuna ánna yù ira mapulu duá nga sinullà na. Á iniyabbû da kuna yù meyannung sù kebalinán nayù ira ángngarigán na. ");
INSERT INTO att_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Á simibbák, á kinagi na nira, “Sikayu yù iniddán ni Namarò ta pakánnámmu naw sù nelímak ngaw nga meyannung sù ira mesipà ta pammagure ni Namarò. Ngam iyángngarigák ku lâ sù ira káruán nga tatolay, ");
INSERT INTO att_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tapè mapalurò yù dán nga netúrâ ni Isaya, nga yù ngaw ábbilinán ni Namarò. Kinagi na: ‘Mássiki nu inni-innad da, ngam arád da tákkilalán, á mássiki nu ginniginnád da, ngam arád da kánnámmuán. Ta nu kánnámmuád da, likurád da nakuan yù liwiliwâ da, ánna mattoli ira kâ Namarò, tapè pakomán na ira.’ ” ");
INSERT INTO att_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Á kinagi ni Apu Kesu nira, “Ngattá, ta arán naw kánnámmuán yù kinagì? Á nu arán naw kánnámmuán yaw, kunnasi laguk pakánnámmu naw sù ira káruán nga pagángngarigák ku? ");
INSERT INTO att_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yù minángngiwárì ta bini, yáyù keyarigán nayù tolay nga mangituddu ta bilin ni Namarò sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Á kunnay ta aggik na dálan nga natágatán ta bini, kunnian gapay sù ira káruán nga tatolay nga magginná sù ubobuk ni Namarò. Pakaginná ra, dagarágâ nga umay si Satanas, á irián na ta nonò da yù ubobuk ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Á kunnay ta gián na batu nga natágatán ta bini, kunnian gapay sù ira káruán nga tatolay, gapu ta pakaginná ra sù ubobuk ni Namarò, magayáyâ ira nga mangalawâ kuna, ");
INSERT INTO att_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ngam ari mapatattam ta nonò da, a mabì lâ ira manguruk. Á sangaw nu umay yù jigâ da, onu ajjan yù manigirigâ nira megapu sù ángnguruk da, dagarágâ nga likurád da yù ángnguruk da. ");
INSERT INTO att_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Á yù ira káruán nga tatolay nga magginná sù ubobuk ni Namarò, kunnay ta mesimmu ta bini nga newárì ta kasisítán, kunnian gapay nira, ");
INSERT INTO att_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","gapu ta tángngagad da lâ yù pagalerád da ánna yù pangayâ da sù kukuá ra, ánna yù pakkaragâ da ta aru nga makkakerumá. Á yáyù nga kunnay ta bini nga ari tulluâ ta kasisítán, kunnian gapay sù ubobuk ni Namarò ta nonò da, gapu ta arád da tángngagan. ");
INSERT INTO att_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Á yù ira tatolay nga magginná ánna manguruk sù ubobuk ni Namarò, kunnay ira ta napiá nga komán nga newáritán na bini nga mabbungá ta napiá. Ta mepatattam ta nonò da yù ubobuk ni Namarò, á napasigaggà yù ángnguruk da, ánna aru yù napiá nga palurotad da.” ");
INSERT INTO att_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Á kinagi ni Apu Kesu nira, “Á ta ángngarigán, nu paggatangat tam yù isingan, kallabát tam panò, onu ipe tam panò ta silárung na katri? Ari gemma! Ngam ipotut tam ta lamesá. ");
INSERT INTO att_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Á kunnian gapay sù pangituddù ta meyannung sù pammagure ni Namarò, ta awán gemma ta metuttù nga ari galâ sangaw mepakánnámmu. Á awán ta melímak nga ari galâ sangaw mepalappâ. ");
INSERT INTO att_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu egga yù talingá naw nga makaginná, magginná kayu laguk.” ");
INSERT INTO att_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Á kinagi na paga nira, “Tángngagan naw ta napiá yù maginná naw. Ta ángngarigán, yù saluk nga egga nikayu, yáyù mepattappang nikayu, á malannapán sangaw gapay. Kunnian sù ira tatolay nga manángngák sù metuddu nira. Nu manguruk ira, á aru paga sangaw yù kánnámmuád da. ");
INSERT INTO att_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Á nu patattamad da ta nonò da yù ubobuk ni Namarò, aru paga sangaw ipakánnámmu ni Namarò nira. Á yù ira tatolay nga ari manguruk sù metuddu nira, máttamád da sangaw yù baddì nga kagiad da ta kánnammuád da.” ");
INSERT INTO att_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pangituddu na má ni Apu Kesu, kinagi na, “Kunniaw yù keyarigán nayù paddakal nayù pammagurayán ni Namarò. Ta ángngarigán, ajjan yù tolay nga mangiwárì ta bini sù ákkomanán na. ");
INSERT INTO att_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Á kabalin na nangiwárì sù komán na, magiddá nga makkaturuk káda gabi ánna gumikkáng kággággaw. Á mattubbu yù bini, nga dumakal lâ dumakal, ngam arán na ammu nayù tolay nu kunnasi yù áddakal na. ");
INSERT INTO att_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Á palattuáran na dabbun ta olu yù don na pángè nayù dáwa na nga dumakal áddè ta pattaggâ na. ");
INSERT INTO att_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kalutu nayù dáwa na, doban nayù tolay yù ira umay maggaták kuna, gapu ta náddekánin yù kagaták na.” ");
INSERT INTO att_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Á kinagi na má ni Apu Kesu sù ira tatolay, “Anni panò yù pangigitták ku sù pammagure ni Namarò? Onu anni yù pangiyarigák ku kuna? ");
INSERT INTO att_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kunnay sù kabadditán nga bukal nga nemulá ta dabbun. ");
INSERT INTO att_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nu nemulá ngin, mattubbu nga dumakal ta áddè ta mabbáli ta karakalán na mulá nga darakal yù pangá na. Á umay magumù yù ira mammánù sù pangá na.” ");
INSERT INTO att_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Á ta pangituddu na nira, aru nga kunnian yù iniyángngarigán na nira, ta yáyù lâ maginná ra ta áddè ta arád da kánnámmuán. ");
INSERT INTO att_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Á awán bulubugá ta kinagi na sù ira tatolay nu ari lâ megapu sù pagángngarigán na. Ngam ta kepulù da lâ kuna nayù ira makituddu kuna, inibukalán na ngámin nira. ");
INSERT INTO att_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Á ta pajjibbà, kinagi ni Apu Kesu sù ira makituddu kuna, “Et tamin, ta dumákì ittam ta dammáng na bebay,” kun na. ");
INSERT INTO att_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Á nánawád da yù ira magaru, á nappittà ira sù barangay nga gián ni Apu Kesu, á inipulù da nga irákì ta dammáng. Á ajjan yù ira káruán nga barangay nga namulun nira. ");
INSERT INTO att_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Á nikáddagâ lâ nappaddák ta nasikan, á lappágan nayù palung yù barangay, á massabbuetán ta áddè ta maddaggun mapannu. ");
INSERT INTO att_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngam nakkaturuk si Apu Kesu nga nappungán sù gián na ulin na barangay. Á ed da nilukák. “Mesturu!” kud da. “Arám mu kemámmatán yù kalaggak tam?” kud da. ");
INSERT INTO att_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Á kalukák na, gimmá na yù paddák ánna palung, á kinagi na, “Magimammà ken.” Á nagimammà yù paddák, á nalínák yù danum. ");
INSERT INTO att_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Á kinagi na sù ira makituddu kuna, “Ngattá, ta maganássing kayu? Arán nawà paga ikatalà?” kun na. ");
INSERT INTO att_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Á nappanà yù assing da ánna nakalò yù kapállâ da. Á nakkaká-ubobuk ira nga kinagi, “Asinni laguk yaw? Ta mássiki yù paddák ánna danum, tuppálad da yù kagian na!” kud da. ");
INSERT INTO att_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Á nakáddè di Apu Kesu ta dammáng na bebay sù gián nga mangngágan ta Gerasa. ");
INSERT INTO att_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Gatták ni Apu Kesu ta barangay, minay jiminápun kuna yù tolay nga naggapu ta katanamán, nga nagunagán na anitu. ");
INSERT INTO att_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Á kuebá ta katanamán yù paggianán na, gapu ta awán ta tolay nga makegálù kuna, mássiki nu káwák yù gálù na. ");
INSERT INTO att_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ta name-aru nga nagalután ta káwák nga balayáng yù takki na ánna yù limá na, ngam gattakan na lâ, á awán ta tolay nga masikan nga makegaggak kuna. ");
INSERT INTO att_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Á kággággaw ánna káda gabi magagga-aggay sù katanamán ánna puddupuddul ira, á bigibigarán na yù baggi na ta batu nga nataram. ");
INSERT INTO att_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pakerípâ nayù naggusapel kâ Apu Kesu ta arayyu paga, nakkarerá nga minay namalittúkak sù arubáng na. ");
INSERT INTO att_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Á nikalli na nga kinagi kuna, “Anni akkuám mu nikán, sikaw Apu Kesu nga Anâ ni Namarò nga Kotunán? Á ta arubáng ni Namarò, kiddawak ku nikaw ta arám mà jigirigátan,” kun nayù maguyung kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yáyù kiniddo na, gapu ta makiubobugin si Apu Kesu, á kinagi na sù anitu nga nagunak, “Mallawán ka nga mánaw sù tolay, sikaw, anitu!” ");
INSERT INTO att_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Á iniyabbû na laguk ni Apu Kesu kuna, “Anni yù ngágam mu?” “Jibu yù ngágak ku gapu ta apípiá kami,” kun nayù naggusapel. ");
INSERT INTO att_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Á inikukkuttù na nga nakimállà kuna ta arán na ira papanáwan sù lugár da. ");
INSERT INTO att_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Á naggián tán apípiá nga bábi ira nga nadduki sù garek na puddul. ");
INSERT INTO att_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Á nakimállà yù ira anitu kâ Apu Kesu, á kinagi ra, “Dobam mu kami bì sù ira bábi, tapè tullung kami nira,” kud da. ");
INSERT INTO att_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Á iniyanugù na nira, á nallawán ira nga simillung sù ira bábi. Á ngámin yù ira bábi nga maddaggun duá ribu, nakkarerá ira nga minutù nga minay sù danum na bebay. Á nalaggabán ira ngámin nga natay ta bebay. ");
INSERT INTO att_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pakasingan nayù ira minánnaron ta bábi sù nesimmu, nattálaw ira, á ed da iniparámak sù ili ánna ngámin nga bárriu. Á pakarámak nayù ira tatolay, ed da pinasikkál nu anni yù nesimmu. ");
INSERT INTO att_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pakáddè da kâ Apu Kesu, nasingad da yù tolay nga naggusapel ngaw, nga nagitubang nga nabbarawási ngin. Nanoli ngin yù napiá nga nonò na. Pakasingad da kuna, nakalò yù assing da, á nepallà yù kapállâ da megapu sù pakáwayyá ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Á yù ira tatolay nga nakasingan, inistoriá ra sù ira káruán yù ngámin nga nesimmu sù tolay nga naggusapel ánna yù ira aya-ayám da. ");
INSERT INTO att_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Á dagarágâ makikomá ira ngámin kâ Apu Kesu ta panawán na bì yù lugár da. ");
INSERT INTO att_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Á gapu ta panakì da kuna, minay si Apu Kesu nga nappittà ta barangay. Á yù tolay nga nagunagán na ngaw na anitu, minay laguk nakimállà kâ Apu Kesu, ta gustu na mepulù kuna. ");
INSERT INTO att_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngam arán na inanugù ni Apu Kesu, á kinagi ni Apu kuna, “Manoli ka lâ ta balem, á kagiam mu sù ira kanakanáyum mu yù ngámin nga kingnguá ni Apu nikaw ánna yù ángngikállà na nikaw,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Á nánaw laguk yù tolay, á dagarágâ nanoli ta lugár na nga mangngágan ta Mapulu Ili, ta en na inilayalayâ yù kingnguá ni Apu Kesu kuna. Á pakaginná nayù ira tatolay, napállâ ira ngámin. ");
INSERT INTO att_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Á nabbarangay laguk si Apu Kesu nga nanoli ta dammáng na bebay. Pakatunù na tán, nagarimummungád da nayù ira magaru nga tatolay ta aggik na bebay. ");
INSERT INTO att_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Á minay gapay yù tádday nga tolay, nga mangngágan ta Jeru, nga kapatás ta kapilliá na Kudio. Á pakasingan ni Jeru kâ Apu Kesu, namalittúkak laguk ta arubáng na. ");
INSERT INTO att_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Á inikomá na kuna, nga kun na, “Magisassay matay yù anâ ku nga babay. Em mu bì támmitan, tapè mammapiá ánna matolay,” kun ni Jeru kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Á binulun na laguk ni Apu Kesu, ta umay ira sù bale na. Á nepulù nira yù magaru nga tatolay. Á masirisirì ira sù dálan. ");
INSERT INTO att_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Á ta kasirisirì nayù ira tatolay, ajjan yù babay nga mapparága ta mapulu duá nga dagun. ");
INSERT INTO att_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Á aru yù jigâ nga inattamán na megapu ta panguru ra kuna nayù ira aru nga minángnguru. Á napúnu ngin yù kuártu na, á ari paga nammapiá, nu ari galâ nga mappanà lâ mappanà yù takì na. ");
INSERT INTO att_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Á narámak na yù meyannung kâ Apu Kesu, á minay laguk nga jimikkì sù likuk na. Á siniggek na yù barawási na. ");
INSERT INTO att_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta nanonò na, “Nu ek ku siggeran mássiki yù gámì na, á mammapiángà,” kun na ta nonò na. ");
INSERT INTO att_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Á paniggek na kuna, dagarágâ nattukkâ yù papparága na! Á natagenà na ta nammapiá ngin yù baggi na. ");
INSERT INTO att_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Á ta pammapiá nayù babay, dagarágâ natagenà ni Apu Kesu ta nammapiá yù tolay megapu sù ámmagaddátu na, á nagginnà laguk ta dálan, nga nallipay sù ira tatolay, á iniyabbû na nira, “Asinni naniggek ta gámì ku?” kun na. ");
INSERT INTO att_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Á kinagi nayù ira makituddu kuna, “Arám mu panò masingan yù ira tatolay nga manirisirì nikaw? Ngattá, ta iyabbû mu lâ paga ta asinni naniggek nikaw?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Á nilipilipe na ira ngámin tapè masingan na yù naniggek kuna. ");
INSERT INTO att_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Á yù babay, natákál na ta nammapiá ngin, á minay namalittúkak ta arubáng ni Apu Kesu, nga mamippippik nga maganássing, a kinagi na yù kurugán. ");
INSERT INTO att_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Á kinagi ni Apu Kesu kuna, “Tíyá, nammapiá ken megapu sù ángngikatalà mu nikán. Lubbè ken, á ari ka maburung, ta kuruk nga nammapiá ken nga ari mapatolián,” kun na. ");
INSERT INTO att_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Á pakiubobuk na paga ni Apu Kesu sù babay, jimittál yù ira tatolay nga naggapu ta bale nayù kapatás, á kinagi ra sù kapatás, “Natayin yù anâ mu. Ngattá, ta bannagam mu paga yù mesturu?” kud da. ");
INSERT INTO att_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngam arán na sinángngák ni Apu Kesu yù kinagi ra, á kinagi na sù kapatás, “Ari ka maganássing. Ipasigaggà mu lâ yù ángngikatalà mu nikán,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Á arán na inanugù nga mepulù yù ira tatolay kuna. Tallu ira lâ yù mepulù kuna, di Eduru ánna yù duá nga mawwagi, di Ime kâ Kuan. ");
INSERT INTO att_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Á labbè da ta bale nayù kapatás, nasingan ni Apu Kesu yù ira matannuk nga gikulukuletán. ");
INSERT INTO att_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Á tallung ni Apu Kesu sù balay, kinagi na nira, “Ngattá, ta matannuk kayu ánna makkulè? Yù abbing, ari natay, ngam makkaturuk lâ,” kun na. ");
INSERT INTO att_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Á inipappagalà da. Ngam pinapáno ni Apu Kesu ira sù balay. Á yù yená nayù abbing ánna yù yáma na, á si Apu Kesu ánna yù ira tallu nga kábulun na, aggira lâ yù simillung sù gián nayù abbing. ");
INSERT INTO att_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tallung da ta lágum, jimikkì si Apu Kesu sù abbing, á singngalán na yù limá na. Á kinagi na kuna sù ággubobuk na, “Talita kumi.” Á yù kebalinán na, “Abè, gumikkáng ka.” ");
INSERT INTO att_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Á dagarágâ giminikkáng yù abbing, á nallakák, ta dakalin, ta mapulu duá yù dagun na. Á pakasingan nayù ira darakal na, nakalò yù kapállâ da. ");
INSERT INTO att_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Á sinabarangán na ira ni Apu Kesu ta arád da bulubugá ipakánnámmu. Á kinagi na nira ta pakanad da yù abbing. ");
INSERT INTO att_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Á nánaw laguk si Apu Kesu nga nanoli sù lugár na ta ili na Nasaret. Á nepulupulù kuna yù ira makituddu kuna. ");
INSERT INTO att_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Á sù ággaw nga ággibannák da, minay nangituddu ta kapilliá na Kudio. Á aru yù ira tatolay nga napállâ ta pakaginná ra sù ituddu na. Á kinagi ra, “Isaw panò pangápán na danniaw nga kagian na nittam? Anni panò yù sírik nga nepay kuna? Á kunnasi panò yù pamagaddátu na ta makapállâ nga akka-akkuán na? ");
INSERT INTO att_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ari panò aggina yù kalapinteru, nga anâ ni Maria, ánna yù kaká ri Ime, kári Kusè, si Kudas, si Simon? Á ajjan gapay saw yù ira wáwwagi na nga bábbay,” kud da. Á natakì yù nonò da kuna. ");
INSERT INTO att_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Á kinagi na laguk ni Apu Kesu nira, “Ngámin nga tatolay, makimoray ira sù ábbilinán ni Namarò. Awán ta manakì kuna, nu ari lâ yù ira katangelián na ánna yù ira kanakanáyun na ánna yù kábbale na,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Á ari makapagaddátu tán, gapu ta awán ta manguruk kuna, ngam yù ira lâ nga káruán nga máttakì, sinámmì na ira ánna pinammapiá na ira. ");
INSERT INTO att_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Á napállâ, gapu ta awán ta ángnguruk da. Á minay laguk mangituddu ta tatolay sù ira barrabárriu. ");
INSERT INTO att_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Á inagálán ni Apu Kesu yù mapulu duá nga sinullà na, tapè doban na ira nga taggiruá, ta umay ira mangilayalayâ sù bilin ni Namarò. Á ipe na nira yù pakáwayyá na nga maggammá sù ira anitu. ");
INSERT INTO att_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Á sinabarangán na ira ta awán bulubugá ta ipulù da, ngam yù lâ tagukuk da sù lakarad da. Yáyù lâ, ta arán na nira inipálâ yù bálud da nga kanan onu gámì onu kuártu sù arikáwà da. ");
INSERT INTO att_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kinagi na nira ta massapátù ira, ngam arád da ipulù yù pappataliád da. ");
INSERT INTO att_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Á kinagi na nira, “Á yù labbetán naw nga balay, yáyù lâ ággammátán naw áddè ta páno naw ta lugár da. ");
INSERT INTO att_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Á nu lubbè kayu ta gián nga awán ta mangalawâ nikayu, ánna manakì ira magginná sù bilin naw, mánaw kayu laguk. Á ta páno naw, pápparán naw yù káppù sù takki naw, nga pangipanonò naw nira ta liwâ da lápay nu manakì ira magginná sù bilin naw,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Á nánaw laguk yù ira mapulu duá nga sinullà na, á minay ira mangilayalayâ ta máwák nga mabbabáwi yù ira tatolay ánna likuránád da yù narákè nga ággangnguá ra. ");
INSERT INTO att_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Á aru yù ira anitu nga pinapáno ra ta tatolay, á aru yù ira máttakì nga jinenuád da, á nammapiá ira. ");
INSERT INTO att_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Á gapu ta neparámak yù kingngikingnguá ni Apu Kesu, naginná na gapay ni Patul Erodo. Á yù ira káruán nga tatolay, kinagi ra, “Naginnanolayin si Kuan, nga yù ngaw Minánnigù. Á yáyù gapu na nga egga ngin kuna yù ámmagaddátu na,” kud da. ");
INSERT INTO att_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Á yù ira káruán nga tatolay, kagiad da, “Aggina si Elias nga yù ngaw ábbilinán,” kud da. Á yù ira káruán, kagiad da, “Aggina yù ábbilinán ni Namarò nga kagittá nayù ira ngaw ábbilinán,” kud da. ");
INSERT INTO att_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngam si Patul Erodo, pakaginná na sù kagiad da, kinagi na, “Asinni panò, nu ari si Kuan nga inipaputul ku ngaw, nga naginnanolayin!” kun na. ");
INSERT INTO att_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yáyù kinagi ni Patul Erodo, gapu ta manononò na lâ yù kingnguá na ngaw kâ Kuan, sù ngaw pangipukù na kuna. Á yawe yù istoriá ra nga meyannung sù kingnguá na ngaw ni Patul Erodo kâ Kuan. Egga yù urián ni Patul Erodo, nga laláki, nga si Pilippi yù ngágan na. Á nagatáwa di Pilippi kâ Erodia. Ngam inâ ni Patul Erodo si Erodia, nga asípák na, ta atawán na. ");
INSERT INTO att_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Á pakánnámmu ni Kuan sù kingnguá ni Patul Erodo, kinagi na kuna, “Arám mu inuru-uray yù katunungán, ta inâ mu yù atáwa ni Pilippi nga uriám mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Á pakánnámmu ni Erodia sù kinagi ni Kuan sù patul, kitaporay si Erodia kâ Kuan, á gustu na papatáyan, ngam awán ta awayyá na. ");
INSERT INTO att_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ta makimoray si Patul Erodo kâ Kuan, gapu ta ammu na ta katunungán nga tolay, nga ábbilinán ni Namarò. Á yáyù nga jinok na ngaw ni Patul Erodo yù umay maggápù kâ Kuan, á inipapukù na, tapè melillì kâ Erodia nga mamapátay kuna nakuan. Á sinángngák nayù patul nga gininná yù ituddu ni Kuan, ta ikáyâ na nga ginnán, mássiki nu nabbábáng sù bilin na. ");
INSERT INTO att_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Á manganánnuán, jimittál yù awayyá ni Erodia nga mangipapátay kâ Kuan, ta ággaw nga pabbúyá ra ta keyanâ ni Patul Erodo. Ta inapà ni Erodo yù ira mammaguray nga gádday kuna ánna yù ira kapitán na suddálu, á yù ira girikuán ta purubinsia na gapay, tapè umay ira mepallálláng ánna mabbúyá ta keyanâ na. ");
INSERT INTO att_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Á ajjan yù anâ ni Erodia nga magingánay. Á minay mattála megapu sù ira álliuk. Á ayatán di Erodo ánna yù ira álliuk na sù pattála na. Á kinagi ni Patul Erodo kuna, “Á Parinsesa, kiddawam mu nikán yù gustum, á iyawâ ku nikaw,” kun na. ");
INSERT INTO att_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Á inipagássingán ni Erodo kuna, á kinagi na, “Maguray lâ yù kiddawam mu nikán, kuruk nga iyawâ ku nikaw, mássiki nu gadduá na kukuâ,” kun na. ");
INSERT INTO att_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Á nánaw nira yù magingánay sù ira álliuk, nga minay kâ innò na. Á kinagi na kâ innò na, “Anni yù kiddawak ku?” kun na. “Á yù ulu ni Kuan nga Minánnigù,” kun ni innò na kuna. ");
INSERT INTO att_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Á dagarágâ nanoli yù magingánay sù patul, á kinagi na, “Gustù daretiu nga iyawâ mu nikán kunangane yù ulu ni Kuan nga Minánnigù nga nepay ta palanggána,” kun na. ");
INSERT INTO att_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Á nakalò yù daddam nayù patul, ngam arán na gustu nga ari mamalurò sù kinagi na, megapu sù nepagássingán na ánna sù ira álliuk nga nakaginná sù kinagi na. ");
INSERT INTO att_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Á dagarágâ jinok na patul yù suddálu nga magguárdiá, tapè en na apan yù ulu ni Kuan. En na pinutulán si Kuan sù áppukután. ");
INSERT INTO att_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Inipe na yù ulu na sù palanggána nga inituluk na sù magingánay, á iniyawâ na kuna. Á iniyawâ nayù magingánay kâ innò na. ");
INSERT INTO att_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Á yù ira sinudduán ni Kuan, pakaginná ra karanniaw, ed da inâ yù baggi na, á initanam da. ");
INSERT INTO att_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Á kabalid da nangilayalayâ nayù ira makituddu kâ Apu Kesu, naggagammung ira sù gián ni Apu Kesu. Á inistoriá ra yù kingngikingnguá ra ánna inituddu ra sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Á kinagi ni Apu Kesu nira, “Et tamin ta ággimammatán, sittam lâ, tapè magibannák kayu bì,” kun na. Ta aru yù ira tatolay nga naddagaráddán nga umay sù giád da, á mássiki nu kumán ira nakuan, arád da natángngák. ");
INSERT INTO att_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Á nappittà ira sù barange ra ta mánaw ira nga umay sù ággimammatán. ");
INSERT INTO att_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Á aru yù tatolay nga nakasingan sù páno ra, á natákkilalád da. Á nakkarakarerá ira nga naggapu ta ngámin nga barrabárriu ra, á napolu ira nga nakáddè ta dammáng. ");
INSERT INTO att_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Á tappì da ta aggik, gimitták si Apu Kesu sù barangay. Á nasingan na yù magaru nga tatolay, á nakalò yù allà na nira, gapu ta kunnay ira ta karneru nga awán ta manaron nira. Á namegapu nga mangituddu nira, á aru yù inituddu na nira. ");
INSERT INTO att_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Á ta púgágin, minay kâ Apu Kesu yù ira tudduán na. Á kinagi ra, “Kalállammatán yawe giát tam, á ajjan mággè gabi ngin. ");
INSERT INTO att_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dobam mu bì yù ira tatolay, tapè umay ira gumátáng ta kanad da túrin ta babálay,” kud da. ");
INSERT INTO att_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Á sikayu lâ yù umay mamakán nira,” kun ni Apu Kesu nira. “Á kunnasi laguk? Awán ta ipangâ mi ta pán. Á nu egga nakuan nikami yù sueldu na tolay ta tangaragun, á makatò mapúgák, tapè makagátáng kami ta pán ta ipamakám mi nira,” kud da. ");
INSERT INTO att_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Á kinagi ni Apu Kesu nira, “Á pígiá bullung nga pán egga nikayu? En naw bì innan.” Á kabalid da naningan, ed da kinagi kuna, “Ajjan límá bullung nga pán ánna duá nga sirá.” ");
INSERT INTO att_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Á kinagi ni Apu Kesu sù ira tatolay ta mattatádday ira nga makkakanáyun, á mesisinná ira nga magitubang sù kakáddapán. ");
INSERT INTO att_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Á nagitubang ira nga taggimagatù ánna taggilímápulu. ");
INSERT INTO att_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Á pakálâ ni Apu Kesu sù límá bullung nga pán ánna duá nga sirá, sinánguk na yù lángì, á nabbalabálà kâ Namarò sù kanan. Á giddigidduá na ánna iniyawâ na sù ira makituddu kuna, tapè isinek da sù ira tatolay. Á giddigidduá na gapay yù duá nga sirá nga mesinek sù ira ngámin. ");
INSERT INTO att_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Á kiminán ira ngámin, á nabattuk ira. ");
INSERT INTO att_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Á ed da inâ yù buná ra nga pán ánna sirá, á mapulu duá yù lappi nga napannu sù buná ra. ");
INSERT INTO att_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Á límá ribu yù ira tatolay nga lálláki nga kiminán, á ari nebiláng yù ira ábbing ánna yù ira bábbay. ");
INSERT INTO att_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Á kabalid da kiminán, dagarágâ pinapolu ni Apu Kesu yù ira sinudduán na ta mappittà ira ta barangay nga umay ta dammáng na bebay, ta ili na Betseda. Á nabattáng lâ si Apu Kesu, tapè palabbetan na lábbì yù magaru nga tatolay sù bale ra. ");
INSERT INTO att_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Á naguroray si Apu Kesu nga giminon ta puddul, tapè makiubobuk kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Á manganánnuán, pajjibbakin, nakáddè yù barangay ta tangngá na bebay. Á naguroray si Apu Kesu ta kannak. ");
INSERT INTO att_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Á nerípâ na yù jigâ nayù ira makabarabarangay ta tangngá na danum, nga mallapalápák nga ari makálì gapu ta nasikan yù paddák. Á ta tangngá na gabi, nga lage na magittarákkò na manù, minay si Apu Kesu nga mappángè nira nga mallakák ta utun na danum. Á mattalebák nakuan nira. ");
INSERT INTO att_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ngam nasingad da yù nallakák sù utun na danum, á kagiad da ta annáni, á nakaráring ira! ");
INSERT INTO att_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ta aggira ngámin nakasingan kuna, á nepallà yù assing da. Ngam dagarágâ kinagi ni Apu Kesu nira, “Pataggatan naw yù nonò naw, ta sikán yaw. Ari kayu maganássing,” kun na. ");
INSERT INTO att_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Á nappittà laguk si Apu Kesu sù barange ra. Á nattukkâ yù paddák. Á nerallà yù kapállâ da, ");
INSERT INTO att_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ta arád ta paga kánnámmuán yù kebalinán nayù pagaru na pán nga inipamakán ni Apu Kesu sù ira magaru, ta arád da nonotan. ");
INSERT INTO att_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Á ta pakáddè di Apu Kesu ta dammáng, minay ira jiminung sù dappâ na Gennesaret. ");
INSERT INTO att_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Á gatták da ta barangay, dagarágâ natákkilalán nayù ira tatolay si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Á gikarakarerán ira ta ngámin nga lepuán, ta ed da apan yù ira máttakì, nga kináttu ra sù dapad da, tapè iyánge ra ira kuna ta maguray nga gián na. ");
INSERT INTO att_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Á maguray lâ yù angayán ni Apu Kesu, nga babálay, ánna ili, ánna lelepuán, minay gapay ta ngámin nga pakirapunán yù ira tatolay nga mangiyánge sù ira máttakì. Á inikomá ra kuna ta anugutan na yù paniggek da lâ ta kiddanán na barawási na. Á ngámin ira nga naniggek, nammapiá iren. ");
INSERT INTO att_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Á egga yù ira tatolay nga naggapu ta Jerusalem, nga Parisio ánna yù ira káruán nga mangituddu sù tunung nayù ira Kudio, á ed da nagarimummungán si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Á nemámmatád da yù ira káruán nga makituddu kâ Apu Kesu, nga kumán nga arád da paga binaggawán yù limá ra ta kunnay sù ituddu nayù tunung. ");
INSERT INTO att_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ta yù ira Parisio ánna yù ira ngámin nga Kudio, ari ira gemma kumán, nu ari ira paga nabbaggaw ta kunnay sù negagángay nga kustombare nayù ira naggaká nira. ");
INSERT INTO att_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Á nu maggapu ira ta dápun, ari ira kumán nu ari ira paga nabbaggaw. Á aru paga yù tuppálad da nga ituddu nayù rilisiod da, yù ággugâ da ta ákkilò, ánna garapon, ánna kalderu. ");
INSERT INTO att_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Á yáyù iniyabbû da kâ Apu Kesu nayù ira Parisio ánna yù ira mangituddu sù tunung, á kinagi ra, “Yù ira sinudduám mu, kumán ira, nga ari nabbaggaw. Ngattá, ta arád da tuppálan yù kustombare nayù ira naggaká nittam?” ");
INSERT INTO att_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Á kinagi ni Apu Kesu nira, “Sikayu nga agippípiá! Kurugán yù Ubobuk ni Namarò nga inipetúrâ na kâ Isaya, nga yù ngaw ábbilinán na. Ta netúrâ yù kinagi ni Namarò, ‘Danniaw ira nga tatolay, yù lâ paddáyo ra nikán yù pagubobuk da, ngam awán bulubugá ta ángnguruk da nikán ta nonò da. ");
INSERT INTO att_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awán ta serbi nayù ákkimore ra nikán, ta ituddu ra yù inipapílì da ta nonò da, nga kagiad da ta tunung nga naggapu nikán,’ kun ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Á sikayu gemma yù ubobugan na, gapu ta paguráyán naw yù tunung ni Namarò, tapè tuppálan naw lâ yù ituddu na tolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Á kinagi ni Apu Kesu nira, “Kitasírik kayu! Ammu naw yù mamotu sù taddán ni Namarò, tapè tuppálan naw galâ yù kustombare nayù ira ngaw naggaká nikayu. ");
INSERT INTO att_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ta inituddu na ngaw ni Moyses yù taddán ni Namarò, á kinagi na, ‘Makimoray kayu sù ira darakal naw.’ Á kinagi na má, ‘Yù tolay nga magubobuk ta narákè sù ira darakal na, matay, tapè magikáru ta liwâ na.’ ");
INSERT INTO att_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngam sikayu, ngattá, ta kagian naw ta máyâ nu kagian na tolay sù ira darakal na, ‘Awán ta awayyâ nga mangabbák nikayu, gapu ta Korbánin yù kukuâ.’ Á yù kebalinán na Korbánin yù neyawákin kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Á nu kagian nayù tolay ta neyawákin yù kukuá na kâ Namarò, á ngattá, ta arán naw laguk anugutan yù ángngabbák na sù ira darakal na. ");
INSERT INTO att_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Á ta kunnian potuán naw yù ubobuk ni Namarò megapu sù kustombare naw nga ituddu naw sù ira ánâ naw. Á aru yù akkuán naw nga kunniaw,” kun ni Apu Kesu sù ira Parisio ánna sù ira káruán nga mesturu na Kudio. ");
INSERT INTO att_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Á inagálán ni Apu Kesu yù ira káruán nga tatolay ta umay ira kuna. Á kinagi na nira, “Sikayu ngámin, ginnán naw yù kagiak ku, á kánnámmuán naw laguk. ");
INSERT INTO att_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Awán ta itammul na tolay ta simù na nga makararál sù ákkiyápu na kâ Namarò, nu ari galâ yù ilawán na ta simù na nga ubobuk na nga maggapu ta narákè nga nonò na. ");
INSERT INTO att_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nu egga yù talingá naw nga makaginná, magginná kayu laguk!” kun na nira. ");
INSERT INTO att_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kabalin na nagubobuk, nánaw di Apu Kesu sù ira tatolay, á simillung ira sù balay. Á yù ira makituddu kuna, iniyabbû da kuna yù kebalinán nayù gangù nga ángngarigán na. ");
INSERT INTO att_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Á kinagi ni Apu Kesu nira, “Á mássiki sikayu, arán naw panò ammu? Arán naw paga kánnámmuán ta ari yù kanan na tolay yù manarál sù ákkiyápu na kâ Namarò, ");
INSERT INTO att_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","gapu ta ari makatallung yù kanan na tolay ta nonò na, ngam tullung lâ ta gutù na, á ikawè na sangaw,” kun na nira. Á ta kunniane, inituddu na ta awán ta kanan nga kanniawan. ");
INSERT INTO att_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Á kinagi na má, “Yù naggapu ta nonò na tolay, yáyù maddaping ta tolay, nga makararál sù ákkiyápu na kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta naggapu ta nonò na tolay yù narákè nga nononotan na, nga kunnay sù mamabay ánna makilaláki, yù makkokò, yù mamapátay, yù makkarallaw, ");
INSERT INTO att_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yù mokkuk, yù kitarákè, yù mangilogò, yù mangiyappa-appà, yù mamassil, yù mallilíbâ, yù mappeddaráyaw, ánna yù mallokuloku. ");
INSERT INTO att_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ngámin danniaw nga narákè yù maggapu ta nonò na tolay, á danniaw ira maddarál sù ákkiyápu ra kâ Namarò,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Gapu ta kabalin na nangituddu nira, nánaw si Apu Kesu nga minay sù lugár na Tiro ánna Sidon. Á simillung sù balay, ta gustu na nga ari mappasingan sù ira magaru nga tatolay, ngam ari makalillì nira. ");
INSERT INTO att_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Á ajjan tán yù babay nga egga yù anâ na nga babay nga nagunagán na anitu. Pakarámak na babay ta keggá ni Apu Kesu, dagarágâ nga minay namalittúkak ta arubáng na. ");
INSERT INTO att_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Á ari Kudio yù babay, ta Sirupinisia yù ikáttole na. Á inikomá na kâ Apu Kesu ta palawanan na yù anitu sù anâ na. ");
INSERT INTO att_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Á iniyángngarigán ni Apu Kesu yù itabbák na, á kinagi na kuna, “Iddagám mu lábbì yù kabattuk nayù ira ábbing sù kanad da, ta ari mepángngà nga mepakán yù kanad da sù ira ítu,” kun na. ");
INSERT INTO att_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Á kánnámmuán nayù babay yù kebalinán nayù kinagi ni Apu Kesu kuna, nga ari mepángngà nu abbágán na yù ira ari Kudio lage na mangabbák sù ira Kudio. Á kinagi nayù babay kâ Apu Kesu, “Wan, Apu. Ngam dánnaman nayù ira ítu yù buttá nayù ira ábbing,” kun na. ");
INSERT INTO att_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Á kurugán yù nakagim! Napiá yù initabbák mu nikán,” kun ni Apu Kesu kuna. “Manoli ka ta balem, ta nánawin yù anitu sù anâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Á limibbè yù babay ta bale na, á naratang na yù anâ na nga nagiddá ta katri na, á awánin ta anitu. ");
INSERT INTO att_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Á nánaw laguk si Apu Kesu ta ili na Tiro. Á sinalebarán na yù ili na Sidon ánna yù gián na Mapulu Ili, ta umay ta bebay na Galilia. ");
INSERT INTO att_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Á yù ira tatolay nga naggián tán, inituluk da kâ Apu Kesu yù tolay nga kitul nga umal, á inikomá ra kuna ta támmitan na bì. ");
INSERT INTO att_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Á inilillì ni Apu Kesu yù umal sù ira káruán nga tatolay. Á initulâ ni Apu Kesu yù amassisiddu na sù talingá na. Á niluluán na, á inisiggek na sù jilá na. ");
INSERT INTO att_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Á sinánguk na yù lángì, á nanalasigà, á kinagi na, “Epata,” á yù kebalinán na, “Mabukatán ken laguk.” ");
INSERT INTO att_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Á dagarágâ nga nabukatánin yù ágginná nayù umal, á nakaginná. Á nabbalikâ yù jilá na, á nagubobuk, ánna napiá yù ággubobuk na. ");
INSERT INTO att_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Á sinabarangán ni Apu Kesu yù ira tatolay, ta arád da bulubugá iparámak yù kingnguá na. Á mássiki nu initotoli na nga kinagi nira, mappanà ira laguk nga mangiparámak sù ira ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Á pakarámak nayù ira tatolay, napállâ ira, á nepallà yù kapállâ da. Á kinagi ra, “Napiá yù ngámin nga kingnguá na,” kud da. “Mássiki yù kitul, pakaginnán na, á mássiki yù umal, pakobobugan na,” kud da. ");
INSERT INTO att_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Á keggá ni Apu Kesu tán nga lugár, uli otturu nga minay yù magaru nga tatolay nga naggagammung ta gián na. Á napúnu yù kanad da. Á inagálán ni Apu Kesu yù ira tudduán na, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nakalò yù allà ku sù ira magaru nga tatolay, gapu ta naggián ira nikán ta tallu nga ággaw, á awán ta kanad da,” kun na. ");
INSERT INTO att_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","“Á nu palabbetak ku ira sù babále ra, malupulupuk ira ta dálan megapu ta bisid da, ta kuruk nga arayyu yù naggapuán nayù ira káruán.” ");
INSERT INTO att_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Á simibbák yù ira tudduán na, á kinagi ra, “Á kunnasi ámmakám mi nira sawe kalállammatán?” ");
INSERT INTO att_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Á iniyabbû na nira, “Á pígiá nga bullung nga pán yù egga nikayu?” Á kinagi ra, “Pitu bullung.” ");
INSERT INTO att_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Á kinagi ni Apu Kesu sù ira magaru nga tatolay ta magitubang ira sù kakáddapán. Á inâ na laguk yù pitu bullung nga pán. Kabalin na nabbalabálà kâ Namarò, giddigidduá na yù pán, á iniyawâ na sù ira tudduán na, tapè isinek da sù ira tatolay. Á ed da iniyawâ nira. ");
INSERT INTO att_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Á egga gapay nira yù baddì nga sirá. Kabalin ni Apu Kesu nabbalabálà kâ Namarò sù sirá, giddigidduá na gapay, á iniyawâ na nira, tapè isinek da gapay sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Á kiminán ira ngámin, á nabattuk ira. Á inunnuk da yù buná ra nga nakkákán, á napannu yù pitu nga lappi. ");
INSERT INTO att_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Á mággè appátaribu nga tatolay yù kiminán. ");
INSERT INTO att_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Á kabalid da kiminán nayù ira magaru nga tatolay, pinapáno ni Apu Kesu ira. Á dagarágâ nappittà di Apu Kesu ta barangay ánna yù ira tudduán na, á minay ira sù lugár nga Dalmanuta. ");
INSERT INTO att_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Á minay nira yù ira Parisio, á pinereperang da ta ubobuk si Apu Kesu, ta parubád da. Á kiniddo ra kuna ta ipasingan na nira yù pagaddatuan na, tapè kurugad da ta naggapu kâ Namarò yù pakáwayyá na. ");
INSERT INTO att_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Á nanalasigà si Apu Kesu. Á kinagi na, “Anni má ta magiddak danniaw ira nga tatolay ta pagaddatuak ku nga panákkilalád da? Kukurugán yù kagiak ku nikayu, nga awán bulubugá ta pagaddatuak ku nga panákkilalán naw,” kun na. ");
INSERT INTO att_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kabalin na nakkagi sù ira Parisio, nánawán na ira. Á nappittà sù barangay, á nanoli ta dammáng na bebay. ");
INSERT INTO att_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pakabarabarange ri Apu Kesu, náttamán nayù ira tudduán na yù bálud da, á ajjan lâ nira yù táttádday nga bullung nga pán sù barangay. ");
INSERT INTO att_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Á sinabarangán ni Apu Kesu ira, á iniyángngarigán na yù meyannung sù áppalappák ta pán, ta mássiki nu baddì lâ yù áppalappák nga nekiruk ta pán, á palappáran na yù ngámin nga pán. Á ta kunnay gapay sù kustombare nga narákè, nga massamâ sù ira tatolay. Á kinagi na nira, “Ginnán naw. Mappalán kayu sù kun na áppalappák ta pán nga ajjan kári Patul Erodo ánna yù ira Parisio,” kun na nira. ");
INSERT INTO att_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ngam arád da matákál yù kakágian na, gapu ta nononotad da lâ yù náttamád da nga bálud da. Á nakkaká-ubobuk ira nga makkaká-anasâ, á kinagi ra, “Kunniaw yù kagian na gapu ta awán ittam ta pán,” kud da. ");
INSERT INTO att_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Á ammu ni Apu Kesu ta arád da kánnámmuán yù kebalinán nayù kinagi na, ngam nononotad da lâ yù pán. Á kinagi na nira, “Anni má ta ubobugan naw nga awán kayu ta pán? Ngattá ta arán naw paga matákál yù ituddù nikayu? Arán naw panò manonokin? ");
INSERT INTO att_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ajjan yù mepasingan nikayu. Ngattá ta arán naw masingan? Á ajjan yù mepakánnámmu nikayu. Ngattá ta arán naw maginná? Máttamán naw panò yù kingnguâ? ");
INSERT INTO att_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Á paggaddagadduâ ta límá bullung nga pán nga nepakán sù ira límá ribu nga tatolay, pígiá nga lappi yù napannu ta buná ra nga nonnuk naw?” kun na nira. Á kinagi ra kuna, “Mapulu duá yù lappi nga napannu,” kud da. ");
INSERT INTO att_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Á sù paggaddagadduâ ta pitu bullung nga pán sù ira appátaribu nga tatolay, pígiá yù napannu nga lappi nga nangipayyán naw ta buná ra?” kun ni Apu Kesu nira. “Pitu,” kud da. ");
INSERT INTO att_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Á arán naw panò paga kánnámmuán?” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Á pappatale ri Apu Kesu, nakáddè ira ta ili na Betseda, á iniyánge nayù ira tatolay yù buling kâ Apu Kesu, á inikomá ra kuna ta támmitan na. ");
INSERT INTO att_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Á kinering ni Apu Kesu yù buling, á inipáno na sù babálay. Á niluluán na yù matá nayù buling, á sinámmì na. Á iniyabbû na kuna, “Ajjan yù masingam mu?” kun na. ");
INSERT INTO att_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Á maningan yù buling, á kinagi na, “Masingak ku yù ira tatolay, ngam kun na káyu ira nga mallakák,” kun na. ");
INSERT INTO att_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Á sinámmì na má ni Apu Kesu yù matá na. Á inni-innan nayù buling ta napiá, á nammapiá yù matá na, á nalitáwin yù ánningan na. ");
INSERT INTO att_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Á pamalabbè ni Apu Kesu kuna ta bale na, kinagi na, “Ari ka manoli sù babálay,” kun na. ");
INSERT INTO att_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Á nánaw di Apu Kesu ánna yù ira tudduán na, ta umay ira sù ira babálay ta lugár na Sesaria Pilippi. Á sù pakalakalakák da ta dálan, iniyabbû ni Apu Kesu nira, “Asinningà kanu nga kun na tatolay?” ");
INSERT INTO att_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Á kinagi ra, “Sikaw kanu si Kuan nga Minánnigù,” kud da. “Á yù ira káruán, kagiad da ta sikaw si Elias nga ábbilinán ni Namarò, onu yù tádday sù ira ngaw ábbilinán ni Namarò,” kud da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Á iniyabbû ni Apu Kesu nira, “Á sikayu, anni yù kagian naw? Asinningà gapay?” Á simibbák si Eduru, á kinagi na, “Sikaw yù MakKiristu nga sinullà ni Namarò nga umay mammaguray.” ");
INSERT INTO att_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Á sinaddánán ni Apu Kesu ira, ta arád da lábbì kagian yù meyannung kuna. ");
INSERT INTO att_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Á inigapu ni Apu Kesu nga inipakánnámmu nira yù mesimmu kuna sangaw. Kinagi na nira, “Á jigirigátad dangà sangaw, sikán nga Kaká na ngámin na tatolay. Á máwák ku nga magattam, ta ipuerá rangà nayù ira karakalán ánna yù ira kátannangán nga pári ánna yù ira mesturu ta rilision. Á ipapapáte rangà sangaw. Á pappasá na tallu nga ággaw, maginnanolayà.” ");
INSERT INTO att_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Á yane nga meyannung ta pate ni Apu Kesu, kinagi na nga daretiu nira. Á si Eduru, inilillì na laguk si Apu Kesu ta baddì sù ira kábulud da, á gimmá na. “Ari ka magubobuk ta kunnian,” kun ni Eduru kuna. ");
INSERT INTO att_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngam nallipay si Apu Kesu, nga maningan sù ira tudduán na. Á ginammá na laguk si Eduru. Kinagi na kuna, “Mánaw ka saw nikán, ta naggapu kâ Satanas yù kinagim! Ta kunnay ta negagángay ta tolay yù nonotam mu, nga ari naggapu kâ Namarò.” ");
INSERT INTO att_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Á inagálán ni Apu Kesu yù magaru nga tatolay ánna yù ira tudduán na, ta umay ira kuna. Á kinagi na nira, “Yù tolay nga ikáyâ na tumuttul nikán, arán na laguk tuttulan yù ikáyâ na baggi na, ngam tuttulan na lâ yù ikáyâ ku. Á attamán na gapay yù jigâ nga umay kuna, mássiki nu matay megapu sù ángnguruk na nikán. Á ta kunnian, kunnay ta káttuan na yù kurù na, á tuttulan nangà. ");
INSERT INTO att_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta yù tolay nga nonotan na lâ yù ákkatole na ta dabbuno, matay galâ sangaw nga mesinná kâ Namarò ta áddè ta áddè. Ngam yù tolay nga tumulù nikán, tapè tuppálan na yù ipakuâ kuna, á mássiki nu matay megapu sù ángnguruk na nikán ánna megapu sù pangipakánnámmu na sù napiá nga dámak nga meyannung nikán, aggina yù mepattolay kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Á ta ángngarigán nu málâ na tolay yù ngámin nga káríkuán nga ajjan ta dabbuno ta kukuá na, á egga panò yù serbi na, nu lonán na yù mannanáyun nga áttole na nga iyawâ ni Namarò nakuan kuna? ");
INSERT INTO att_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Awán bulubugá ta metáli na tolay sù mannanáyun nga áttole na ánna yù kesipà na kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Á yù tolay nga mangipasirán nikán ta arubáng nayù ira tatolay nga manakì nikán ánna narákè yù nonò na, á ipasirák ku gapay sangaw nu manolingà saw. Ta sikán nga Kaká na ngámin na tatolay, manolingà sangaw, nga mangipalappâ sù áddalingáráng ánna yù pakáwayyá ni Namarò nga Yámà. Á mepulù nikán yù ira mangilin nga daroban ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Á kinagi na laguk ni Apu Kesu nira, “Kurugán yù kagiak ku nikayu. Ajjan saw nikayu yù ira tatolay nga ari matay lage ra masingan yù dattál nayù pammagure ni Namarò nga makáwayyá.” ");
INSERT INTO att_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Á pappasá na annam nga ággaw, inapà ni Apu Kesu di Eduru ánna yù ira duá nga mawwagi, di Ime kâ Kuan. Á aggira lâ yù nepulù kuna, á giminon ira ta atannáng nga puddul. Labbè da ta utun, naddalingáráng yù baggi ni Apu Kesu sù ánningad da. ");
INSERT INTO att_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Á nerallà yù kapuro nayù gámì na nga nassiling. Á awán bulubugá ta negittá sù kapuro na ta dabbuno. ");
INSERT INTO att_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Á limittuák di Elias kâ Moyses, nga yù ira ngaw ábbilinán ni Namarò. Á makiubu-ubobuk ira kâ Apu Kesu. Á di Eduru, nasingad da ira. ");
INSERT INTO att_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Á kinagi ni Eduru kâ Apu Kesu, “Apu, napiá ta ajjan ittam saw. Ipappadde mi kayu nakuan ta ággitádde naw nga amíngán. Sikayu kári Moyses kâ Elias.” ");
INSERT INTO att_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Á yáyù lâ nakagi ni Eduru, gapu ta arán na ammu yù kagian na nakuan, ta naganássing ira ánna yù ira duá nga kábulun na, di Ime kâ Kuan. Á nerallà yù assing da. ");
INSERT INTO att_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Á minay yù kunam nga nilirúmán na ira. Á naggapu sù kunam yù ngárál nga nakkagi, á kinagi na, “Yaw yù Anâ ku nga iddukak ku. Ginnán naw yù kagian na.” ");
INSERT INTO att_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Á nallipilipay ira. Á nakkaddák ira, ta táttádday lâ yù nasingad da, nga si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Á minutù ira sù puddul. Utù da, sinaddánán na ira ni Apu Kesu ta arád da kagian sù ira tatolay yù nasingad da ta utun áddè ta kabalin na nga maginnanolay nayù Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Á kinuruk da. Pinatattam da ta nonò da yù nasingad da. Ngam aggira lâ, nakkaká-ubu-ubobuk ira nu anni yù kebalinán nayù kinagi na nga paginnanole na. ");
INSERT INTO att_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Á iniyabbû da laguk kuna, “Anni má ta kagian nayù ira mesturu na Kudio ta mapolu nga umay yù ngaw ábbilinán, nga si Elias, ánnè sù MakKiristu?” kud da. ");
INSERT INTO att_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“Wan,” kun ni Apu Kesu nira. “Mapolu si Elias nga umay, ta paránan na ngámin, tapè dán nga naparán sù dattál nayù MakKiristu. Á anni laguk yù kebalinán nayù dán nga netúrâ nga meyannung nikán nga Kaká na ngámin na tatolay? Ta ajjan nga netúrâ ta máwák nga attamák ku yù panigirigâ da nikán ánna yù pangiluddè da nikán. ");
INSERT INTO att_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngam kagiak ku nikayu, ta minay ngin si Elias, á kingnguá nayù ira tatolay yù ngámin nga gustu ra nga narákè, ta kun nayù netúrâ nga meyannung kuna.” Á ubobugan ni Apu Kesu si Kuan nga Minánnigù. ");
INSERT INTO att_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Á pakáranni ra sù ira káruán nga tudduán ni Apu Kesu, nasingad da yù magaru nga tatolay nga nagarimummung. Á ajjan gapay yù ira mesturu na Kudio nga mameperang nira ta ubobuk. ");
INSERT INTO att_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pakasingan nayù magaru nga tatolay kâ Apu Kesu, nakaddák ira nga ayatán. Á nakkarakarerá ira nga jiminápun kuna. ");
INSERT INTO att_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Á iniyabbû ni Apu Kesu nira, “Anni yù pakkakáperangán naw nga ubobuk?” kun na. ");
INSERT INTO att_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","“Mesturu,” kun nayù tádday, “ituluk ku nikaw yù anâ ku nga laláki gapu ta nagunagán na anitu nga umal. ");
INSERT INTO att_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Á sù pattaliponak nayù anitu kuna, pannátan na yù abbing, á mabbugubugâ yù simù na ánna mangngarangngaringngì ánna mangngattuk. Á inikomâ sù ira tudduám mu ta palawanad da bì yù anitu, ngam arád da makuá,” kun nayù tolay kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Á simibbák si Apu Kesu, á kinagi na nira, “Innan nawè yawe ira tatolay nga awán bulubugá ta ángngikatalà da! Kunnasi paga yù kabayák nayù paggiák ku ánna keyattam ku nikayu? Iyánge naw saw yù abbing.” ");
INSERT INTO att_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Á iniyánge ra kuna yù abbing. Á pakasingan nayù anitu kâ Apu Kesu, dagarágâ nga pinabballiák na yù abbing, á napannâ ta dabbun nga nakkarakarebu, á nabbugubugâ yù simù na. ");
INSERT INTO att_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Á iniyabbû ni Apu Kesu sù yáma nayù abbing nu káni yù pamegapu nayù takì na. Á sibbák nayù tolay, á kinagi na, “Namegapu sù kabajjì na. ");
INSERT INTO att_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Á name-aru ngaw initupâ nayù anitu ta api ánna danum, tapè papatáyan na. Ngam nu egga yù awayyám nga mangabbák, ikállà kami bì, á abbágám kami.” ");
INSERT INTO att_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Á kinagi ni Apu Kesu kuna, “Nu egga yù awayyám nga mangikatalà! Si Namarò yù makáwayyá nga mamalurò ta ngámin, á awán bulubugá ta arán na makuá megapu sù ira nga mangikatalà kuna.” ");
INSERT INTO att_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Á inigarù na nga kinagi nayù yáma nayù abbing, “Apu, ikatalà taka! Abbágám mà, tapè aringà mabbábáng!” ");
INSERT INTO att_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Á pakasingan ni Apu Kesu ta makkarakarerá yù magaru nga tatolay nga magarimummung nira, gimmá na yù anitu, á kinagi na kuna, “Sikaw nga umal ánna kitul nga anitu, dobat taka ta mánaw ka sù abbing, á ari ka bulubugá manoli kuna.” ");
INSERT INTO att_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Á nakkalli, á pinabballiák na, nga nepallà yù pamabballiák na sù abbing, á nallawán kuna. Á nagiddá yù abbing ta kun na natay. Á aru yù ira nakkagi, nga kud da, “Ye! Natayin.” ");
INSERT INTO att_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngam sinangngalán ni Apu Kesu yù limá na, á pinagikkáng na, á nanáddak. ");
INSERT INTO att_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Á simillung di Apu Kesu lâ ánna yù ira tudduán na ta balay. Á iniyabbû da kuna, “Anni má ta arám mi gangù napapánaw yù anitu sù abbing?” ");
INSERT INTO att_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Á kinagi ni Apu Kesu nira, “Awán ta makapapánaw ta kunnian nga anitu, nu ari galâ megapu sù pakimállà na kâ Namarò.” ");
INSERT INTO att_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Á nánaw di Apu Kesu táne lugár. Á nattalebák ira sù purubinsia na Galilia. Á arán na ikáyâ ni Apu Kesu ta ammu nayù ira tatolay yù angayád da. ");
INSERT INTO att_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ta ikáyâ na matángngák yù pangituddu na sù ira tudduán na. Á kinagi na nira, “Sikán nga Kaká na ngámin na tatolay, mekekángà sangaw sù ira malussaw nikán, á papatáyad dangà. Á nu mapasá yù tallu nga ággaw, maginnanolayà,” kun na. ");
INSERT INTO att_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngam yù ira tudduán na, arád da kánnámmuán yù kinagi na, á awán ta makeyattam nga makeyabbû kuna. ");
INSERT INTO att_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Á nakáddè di Apu Kesu ta Kapernium, á simillung ira ta balay. Á keggá ra ta lágum na balay, iniyabbû ni Apu Kesu nira, “Anni yù pakkakáperangán naw ta ubobuk gangù sù pallakák tam ta dálan?” ");
INSERT INTO att_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngam ari ira nakkituk, gapu ta mappasirán ira, ta nakkakáperang ira nu asinni nira yù kátannangán. ");
INSERT INTO att_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Á nagitubang si Apu Kesu, á inagálán na yù ira mapulu duá ta umay ira kuna. Á kinagi na nira, “Yù tolay nga máyâ mabbáli ta kátannangán na tatolay, máwák nga mabbáli ta kagukábán ánna makiaripan sù ira ngámin nga tatolay.” ");
INSERT INTO att_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Á inâ na laguk ni Apu Kesu yù baddì nga abbing, á pine na sù tangngá ra. Á sinábbì na, á kinagi na sù ira tudduán na, ");
INSERT INTO att_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nu iddukan na tolay yù kunniaw nga abbing megapu nikán, á nebiláng ta sikán gapay yù iddukan na. Á nu iddukan nangà, ari lâ sikán yù iddukan na, nu ari gapay yù naddok nikán.” ");
INSERT INTO att_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Á kinagi ni Kuan, “Mesturu, nasingam mi yù tádday nga tolay nga mangabbún sù ngágam mu ta pamapáno na ta anitu sù ira nagunagán nga minay kuna. Á pinatukkâ mi, gapu ta arát tam kabbulun.” ");
INSERT INTO att_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Á kinagi ni Apu Kesu nira, “Arán naw gammán! Nu ajjan yù tolay nga mamagaddátu megapu sù pakáwayyá nayù ngágak ku, arán nangà sangaw táttájjián. ");
INSERT INTO att_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta yù tolay nga ari makikontará nittam, aggina yù kopun nga mangabbák nittam. ");
INSERT INTO att_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Á kurugán yù kagiak ku nikayu. Mássiki nu baddì lâ yù ángngabbák na tolay nikayu gapu ta sikán nga MakKiristu yù Yápu naw, mássiki nu mamenum nikayu lâ, á alawatan na gemma noka alawatan yù balabálà na.” ");
INSERT INTO att_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Á kinagi ni Apu Kesu nira, “Yù tolay nga mangituddu ta narákè sù ira baddì nga abbing nga mangikatalà nikán, napiá nu magakkátán yù bullo na ta dakal nga batu, á metabbà ta kálaramán na bebay, tapè ari mangituddu ta narákè sù ira nga manguruk nikán. ");
INSERT INTO att_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Á nu yù limá naw yù kegapuánán nayù liwâ naw, más napiá nu gappulan naw. Ta napiá nu mepattolay kayu ta áddè ta áddè sù gián ni Namarò ta lángì, mássiki nu tádday lâ yù limá naw, ánnè ta keggá na duá nga límá naw, ánna metabbà kayu ta ornu, nga api nga ari bulubugá máddà. ");
INSERT INTO att_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Á yù labbetán nayù ira minálliwâ yù ornu, á pagikaruan ni Namarò ira tán. Awán ta pagibannagád da, á awán ta áddè nayù jigâ da. ");
INSERT INTO att_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Á nu yù takki naw yù mangituluk nikayu ta liwâ, más napiá galâ nu gappulan naw. Ta mássiki nu gappul yù takki naw, napiá nu mepattolay kayu ta áddè ta áddè sù gián ni Namarò ta lángì, ánnè ta keggá na duá nga takki naw nga mangituluk nikayu ta liwâ, á metabbà kayu sù ornu nga awán ta káddà na. ");
INSERT INTO att_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Á yù labbetán nayù ira minálliwâ yù ornu, á pagikaruan ni Namarò ira tán. Awán ta pagibannagád da kuna, á awán ta áddè nayù jigâ da. ");
INSERT INTO att_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Á nu malliwâ kayu megapu sù masingan nayù matá naw, baddulan naw yù matá naw. Ta más mapiá galâ mássiki nu buling kayu sù tádday nga matá naw, á mesipà kayu sù pammagurayán ni Namarò, ánnè ta keggá na duá nga matá naw nga mangituddu nikayu ta liwâ, á metabbà kayu sù ornu nga awán ta káddà na. ");
INSERT INTO att_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Á yù labbetán nayù ira minálliwâ yù ornu, á pagikaruan ni Namarò ira tán. Awán ta pagibannagád da kuna, á awán ta áddè nayù jigâ da.” ");
INSERT INTO att_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Á kinagi na má ni Apu Kesu, “Yù ira ngámin nga tatolay, máwák nga kunnay ira ta másinán, megapu sù kun na api nga iyattam da. Á yaw kebalinán na, ta máwák nga mapasigaggà yù ángngikatalà da nikán, mássiki nu anni yù mesimmu nira, tapè mepángngà ira nga mesipà nikán gapay ta pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masingngà gemma yù asin. Ngam másin panò nu nári yù paggák na? Magimuguk kayu laguk, ta arán naw lonán yù pakkaká-iddù naw ánna pakkaká-abbák naw, tapè napiá lâ yù ággián naw.” ");
INSERT INTO att_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nánaw laguk si Apu Kesu ta Galilia, á minay ta lugár na Judiya ta dammáng na Jordan. Á yù magaru nga tatolay, nagarimummungád da má, á sinudduán na ira ta kunnay ta gagángay nga ángnguá na. ");
INSERT INTO att_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Á minay gapay yù ira Parisio, á jimikkì ira nga maki-ubobuk kuna, tapè parubád da nu anni yù kagian na. Iniyabbû da kuna, “Anni yù ituddu nayù tunung tam? Egga panò yù awayyá na tolay nga maggúngay ta atáwa na?” ");
INSERT INTO att_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Á simibbák si Apu Kesu, á kinagi na nira, “Anni yù ituddu ni Moyses, nga ábbilinán ni Namarò, nga meyannung ta paggúnge nayù ira magatáwa?” ");
INSERT INTO att_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Á kinagi ra, “Á inanugù ni Moyses ta igúnge na tolay yù atáwa na nu itúrâ na yù paninganán ta pangigúnge na sù atáwa na,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Á kinagi ni Apu Kesu nira, “Yáyù inituddu ni Moyses gapu ta nataggâ yù nonò naw. ");
INSERT INTO att_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngam ajjan yù netúrâ nga meyannung sù pamarò ni Namarò ta tolay, nga kunniaw: ‘Pidde ni Namarò yù tolay nga laláki ánna babay.’ ");
INSERT INTO att_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Yáyù nga panawán na laláki yù darakal na ta umay metádday sù atáwa na. ");
INSERT INTO att_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Á yù ira magatáwa, mabbáli ta kun na táttádday nga baggi yù ággiád da.’ Yáyù bibbirat tam sù dán nga netúrâ. Á kuruk nga aringin laguk duá yù ira magatáwa, ngam táttádday lâ yù baggi ren. ");
INSERT INTO att_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yáyù nga arán na tolay passinnán yù ira magatáwa nga pinattádday ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Á limibbè di Apu Kesu ánna yù ira tudduán na ta balay. Á iniyabbû da kâ Apu Kesu yù meyannung sù ituddu na. ");
INSERT INTO att_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kinagi ni Apu Kesu nira, “Yù laláki nga igúnge na yù atáwa na, á mangatáwa sangaw ta tanakuán, makaliwâ, ta mebiláng ta mangarallaw ánna malliwâ sù olu nga atáwa na. ");
INSERT INTO att_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Á yù babay nga igúnge na yù atáwa na, á makiatáwa sangaw ta tanakuán, makaliwâ gapay, ánna mebiláng ta makikarallaw.” ");
INSERT INTO att_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Á manganánnuán, minay yù ira tatolay, ta inituluk da kâ Apu Kesu yù ira ánâ da, tapè támmitan na ira, ánna bindisionán na ira. Ngam yù ira tudduán ni Apu Kesu, gimmá ra yù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Á pakasingan ni Apu Kesu sù kingnguá nayù ira tudduán na, napporay nira. Á kinagi na nira, “Arán naw ira gammán. Iyanugù naw yù ánge nayù ira ábbing nikán, ta aggira mesipà sù pammagure ni Namarò, ánna ngámin ira nga tatolay nga kunnay karanniaw nga ábbing nga mangikatalà nikán. ");
INSERT INTO att_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kurugán yù kagiak ku nikayu, nga ari mesipà yù tolay sù pammagure ni Namarò nu ari mangikatalà kâ Namarò ta kunnay sù pangikatalà nayù ira ábbing.” ");
INSERT INTO att_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Á sinábbì na yù ira ábbing nga taggitádday. Á sinámmì na ira ta ulu ra, á kiniddo na kâ Namarò yù kapiánád da. Kinagi na sù ira katággitádday, “Alluárán na ka ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Á ta páno di Apu Kesu ta umay ira ta tanakuán nga lugár, nakkarerá nga minay kuna yù tádday nga laláki nga namalittúkak ta arubáng na, á kinagi na, “Mesturu, napiá nga tolay ka. Anni yù kagiam mu nga máwák nga akkuák ku, tapè mepattolayà nga mesipà kâ Namarò ta áddè ta áddè?” ");
INSERT INTO att_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Á kinagi ni Apu Kesu kuna, “Ngattá, ta kagiam mu ta sikán yù napiá? Awán ta kuruk nga napiá nu ari galâ ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ammum yù taddán ni Namarò nga netúrâ. ‘Ari ka mamapátay ta tolay. Ari ka mangarallaw. Ari ka makkokò. Ari ka massiri nu massistígu ka. Ari ka maddarogà. Makimoray ka sù ira darakal mu.’ ” ");
INSERT INTO att_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Á kinagi nayù tolay kâ Apu Kesu, “Mesturu, ngilinak ku ngámin danniaw áddè sù kabajjì ku.” ");
INSERT INTO att_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Á inimámmatán ni Apu Kesu yù tolay, á nakalò yù iddù na kuna. Á kinagi na kuna, “Ajjan paga tádday nga pakkúrangám mu. Em mu bì iláku yù ngámin nga kukuám, á isinek mu yù pallakuám mu sù ira pobare, tapè maríku ka galâ ta lángì kâ Namarò. Á manoli ka saw laguk nga tumuttul nikán.” ");
INSERT INTO att_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pakaginná nayù tolay sù kinagi na, nakalò yù daddam na, á siggaraddam nga nánaw, gapu ta egga kuna aru nga kukuá na. ");
INSERT INTO att_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Páno nayù maríku, nilipilipe ni Apu Kesu yù ira tudduán na, á kinagi na nira, “Marigâ nga tumulù yù ira maríku sù pammagure ni Namarò, tapè mesipà ira kuna.” ");
INSERT INTO att_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Á napállâ yù ira tudduán na sù kinagi na. Á pidduá na nakkagi nira, “Wáwwagì, kuruk nga marigâ nga tumulù yù tolay, tapè mesipà sù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más malogon yù állabbû na kamel ta abbû na dágum, ánnè ta tumulù yù maríku nga tolay kâ Namarò, tapè mesipà sù pammagure na.” Á dakal nga ayám ánnè ta kabáyu onu nuáng yù kamel, nga sináppukul yù barâ na. ");
INSERT INTO att_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Á nerallà yù kapállâ da, á kinagi ra kuna, “Asinni laguk yù meyígù ánna mesipà kâ Namarò ta lángì?” ");
INSERT INTO att_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Á inni-innan ni Apu Kesu ira, á kinagi na, “Á awán ta tolay nga makáwayyá. Ngam si Namarò yù mamalurò galâ, ta aggina yù makáwayyá ta ngámin.” ");
INSERT INTO att_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Á kinagi na laguk ni Eduru kuna, “Á sikami, pinanawám mi ngámin, á tumuttuttul kamingin nikaw.” ");
INSERT INTO att_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Á kinagi ni Apu Kesu, “Kurugán yù kagiak ku nikayu. Yù tolay nga panawán na yù bale na onu wáwwagi na, darakal na, ánâ na, ánna dabbun na, nu nánawán na ira megapu sù panguruk na nikán, tapè umay mangipakánnámmu sù napiá nga dámak nga meyannung nikán, ");
INSERT INTO att_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","á kuruk nga bálatan ni Namarò. Ta iddán ni Namarò ta aru nga paggianán na, wáwwagi na, yená na, ánâ na, ánna dabbun na ta keggá na sawe dabbuno. Ngam parubán nayù tolay gapay yù panigirigâ da kuna megapu sù panuttul na nikán. Á sangaw nu duttál yù ággaw, meddán gapay ta inángà na nga awán ta áddè na. ");
INSERT INTO att_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ngam aru yù ira nga makáwayyá kunangan nga baddì yù pakáwayyá ra sangaw nu duttál yù ággaw. Á yù ira nga awán ta pakáwayyá ra kunangan, makáwayyá ira tán nga ággaw.” ");
INSERT INTO att_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Á nappatalay di Apu Kesu ánna yù ira tudduán na nga mappángè ta Jerusalem. Á pallakák da, mapolu si Apu Kesu ta dálan ánnè nira. Á napállâ yù ira tudduán na, á naganássing yù ira tatolay nga tumuttul kuna, gapu ta umay si Apu Kesu ta ili na Jerusalem, nga paggianán nayù ira malussaw kuna. Á inilillì na má ngin ni Apu Kesu yù ira tudduán na, tapè kagian na nira yù mesimmu kuna sangaw. ");
INSERT INTO att_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Á kinagi na, “Ginnán naw. Gumon ittam ta ili na Jerusalem. Á labbè ku tán, sikán nga Kaká ngámin na tatolay, gaputad dangà, á ipatangngal dangà sù ira kátannangán nga pári ánna yù ira mesturu. Á kagiad da yù pamagikáru ra nikán ta patè. Á ipatangngal dangà sù ira ari Kudio nga mammaguray. ");
INSERT INTO att_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Á yù ira ari Kudio, uyoyungád dangà. Pallulutábád dangà, á paligatad dangà, á papatáyad dangà. Ngam sangaw nu mapasá tallu nga ággaw sù patè, á maginnanolayà.” ");
INSERT INTO att_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Á jimikkì laguk kâ Apu Kesu di Ime kâ Kuan, nga duá nga ánâ ni Sebedo. Á kinagi ra kuna, “Mesturu, ajjan yù ikomá mi nga akkuám mu megapu nikami.” ");
INSERT INTO att_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Á kinagi na nira, “Anni yù ikomá naw nga akkuák ku megapu nikayu?” ");
INSERT INTO att_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Á kinagi ra kuna, “Nu mammaguray ka sù páppatulám mu, anugutam mu ta pattangngám mi sikaw sù pagitubangám mu, tádday sù jiwanám mu ánna tádday sù jimigim, nga mesipà sù keparáyom.” ");
INSERT INTO att_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngam kinagi na laguk ni Apu Kesu nira, “Arán naw garè kánnámmuán yù kebalinán nayù ikomá naw. Makeyangngà kayu panò ta jigâ nga kunnay ta jigâ nga attamák ku sangaw? Attamán naw panò yù pate naw nga kunnay sù patè?” ");
INSERT INTO att_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Á kinagi ra kuna, “Makeyattam kami ngay.” Á kinagi ni Apu Kesu nira, “Yáyù gemma noka yù attamán naw. ");
INSERT INTO att_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngam aringà makáwayyá nga mangiyawâ nikayu ta pagitubangán naw sù jiwanák ku ánna jimigì. Napakappiánin yù ira ággitubangán nga naparán sù ira nga sinullà ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Á pakaginná nayù ira mapulu nga tudduán na sù pakkiddo nayù ira kábulud da, di Ime kâ Kuan, napporay ira, ta kiniddo ri Ime yù ira ággitubangán nayù ira maráyaw. ");
INSERT INTO att_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Á inagálán ni Apu Kesu ira ta umay ira ta gián na, á kinagi na nira. “Ammu naw ta kitarok yù ira nga mammaguray sù ira makkakerumá nga tatolay nga ari Kudio. Á yù ira kátannangád da, makáwayyá ira nga mamatuttul sù ure ra. ");
INSERT INTO att_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngam ari kunnian nikayu. Yù tolay nga máyâ nakuan nga mepotun ánnè nikayu, aggina laguk yù tumulù nga masserbi nikayu. ");
INSERT INTO att_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Á yù tolay nga ikáyâ ta aggina yù makáwayyá ánnè nikayu, aggina laguk yù mabbaluntáriu nga makiaripan ta ngámin. ");
INSERT INTO att_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Á mássiki sikán nga Kaká ngámin na tatolay, minayà saw, nga ari passerbián nayù ira tatolay, nu ari galâ ta sikán yù masserbi sù ira tatolay, ánna itapil ku yù baggì, nga mebuwì ta aru nga tatolay, tapè pakomán na ira ni Namarò ta liwâ da.” ");
INSERT INTO att_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Á nakáddè di Apu Kesu ánna yù ira tudduán na ta ili na Jeriku, nga pattalebarád da lâ. Á páno ra ta Jeriku, magaru yù ira tatolay nga mepulù nira. Á ajjan yù buling nga minákkilimù, nga nagitubang sù aggik na dálan. Si Bartimio yù ngágan na, nga anâ ni Timio. ");
INSERT INTO att_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Á pakaginná ni Bartimio ta mattalebák si Apu Kesu nga taga Nasaret, á nakkatakatol, á kinagi na, “Kaw! Apu Kesu, nga Ginaká ni Patul Dabid, ikállà mà bì!” kun na. ");
INSERT INTO att_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Á aru yù ira tatolay, á gimmá ra, á kinagi ra kuna, “Ari ka mattannuk,” kud da kuna. Ngam inipappanà na nakkatakatol, “Ginaká ni Patul Dabid, ikállà mà bì!” ");
INSERT INTO att_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Á pakaginná ni Apu Kesu kuna, nagginnà, á kinagi na nira, “Agálán naw ta umay saw.” Á ed da kinagi kuna, “Pataggatam mu yù nonò mu. Á gumikkáng ka, ta ipágál na ka.” ");
INSERT INTO att_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Á inirián na laguk yù ulolà na, á nattábbarikuâ nga gimikkáng, á minay kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Á kinagi ni Apu Kesu kuna, “Anni yù ikáyâ mu nga akkuák ku nikaw?” Á kinagi nayù buling kuna, “Apu, parè bì ta makasinganà.” ");
INSERT INTO att_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Á kinagi ni Apu Kesu kuna, “Makapánaw ken, ta nammapiá ken megapu sù pangikatalà mu nikán.” Á dagarágâ nanoli yù ánningan nayù buling, á nepulù kâ Apu Kesu ta pappatale na ta dálan. ");
INSERT INTO att_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pakáddè di Apu Kesu ta puddul nga namulán ta káyu nga olibo, nerípâ da yù ira babálay na Bepagi ánna Bitania, nga aranni ta ili na Jerusalem. Á pinapolu ni Apu Kesu yù duá ira nga tudduán na. ");
INSERT INTO att_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Á kinagi na nira, “E kayu lábbì tukewà babálay, ta masingan naw sangaw tán yù kígaw na dongki nga negálù, nga ari bulubugá paga nga nattakayán. Ubbarán naw laguk, tapè iyánge naw saw. ");
INSERT INTO att_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Á nu ajjan yù mangiyabbû nikayu ta ‘Ngattá ta apan naw?’ á kagian naw, ‘Wan, ta máwák ni Apu, á ipetoli na galâ sangaw,’ kun naw kuna.” ");
INSERT INTO att_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Á gapu ta paddok ni Apu Kesu nira, nánaw ira, á nálek da yù kígaw sù kalsáda, nga negálù ta puertá na balay, á inubbarád da. ");
INSERT INTO att_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Á ajjan yù ira tatolay nga nanáddak ta kalsáda, á nasingad da yù kingnguá ra. Á iniyabbû da nira, “Ngattá ta ubbarán naw yù kígaw?” ");
INSERT INTO att_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Á initabbák da yù nipakagi ni Apu Kesu nira, á nipálâ da laguk nira. ");
INSERT INTO att_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Á nánaw ira, á ed da iniyángay yù kígaw kâ Apu Kesu. Á ininánnâ da yù gagámì da sù barâ na ayám, á nattakayán na laguk ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Á aru yù ira tatolay nga ajjan tán, á ininánnâ da yù gagámì da ta dálan. Á yù ira káruán, ininánnâ da yù pangapangá na káyu nga naddon, nga sippisippáng da ta aggik na dálan. ");
INSERT INTO att_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Á ngámin yù ira nga mapolu kári Apu Kesu ta dálan ánna yù ira maporián ta likuk da, magayáyâ ira nga nagaragiák, á kinagi ra, “Dayáwat tam si Namarò. Dayáwat tam yù Patul nga jinok ni Namarò ta umay mammaguray nittam, ");
INSERT INTO att_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ta aggina yù táli nayù ngaw mammaguray nga naggaká nittam, si Patul Dabid, á napiá yù pammagure na. Maráyaw si Namarò ta lángì.” ");
INSERT INTO att_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Á labbè da ta Jerusalem, simillung si Apu Kesu sù mangilin nga kapilliá, nga bale ni Namarò, ta en na sinullúnán ngámin yù ajjan ta lágum na. Á gapu ta púgágin, kabalin na maningan, nánaw, á minay ira ta Bitania, di Apu Kesu ánna yù ira mapulu duá nga tudduán na. ");
INSERT INTO att_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Á sù tádday nga ággaw, panoli ra ta Jerusalem nga naggapu ta Bitania, nabisin si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Á nerípâ na yù káyu nga igò, nga naddon ta napiá. Á en na iningan nu egga bungá na, ta nasingngà gemma yù bungá na igò. Labbè na kuna, nasingan na ta dipúru don na, nga awán bulubugá ta bungá na, gapu ta ari paga yù ággaw na pabbungá na. ");
INSERT INTO att_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Á kinagi ni Apu Kesu, “Aringin bulubugá mabbungá yawe káyu áddè kunangan ta áddè ta áddè.” Á naginná nayù ira tudduán na yù kinagi na. ");
INSERT INTO att_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Á labbè da ta Jerusalem, simillung mángin si Apu Kesu sù mangilin nga kapilliá, nga bale ni Namarò. Á pinaturiák na yù ira malláku ánna yù ira nga umay gumátáng. Á sinottombá na yù lamesá ira nayù ira minánnáli ta kuártu ánna yù bángku nayù ira malláku ta mammánù. ");
INSERT INTO att_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Á arán na anugutan yù ira mattalebák nga mangáttu sù námmuák nayù mangilin nga kapilliá. ");
INSERT INTO att_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Á inituddu na sù ira tatolay, á kinagi na, “Arán naw panò ammu yù netúrâ nga Ubobuk ni Namarò, nga kunniaw: ‘Yù balè yù ákkimállatán na ngámin nga tatolay.’ Ngam sikayu, pinatalián naw ta ággianán nayù ira maddarogà.” ");
INSERT INTO att_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Á yù ira kátannangán nga pári ánna yù ira mesturu ta tunung, narámak da yù kingnguá ni Apu Kesu, á inigagánge ra nu kunnasi yù ámmapáte ra kuna. Ta maganássing ira kuna, ánna passilad da, gapu ta napállâ yù ira magaru nga tatolay megapu sù pakáwayyá nayù ángngituddu na. ");
INSERT INTO att_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Á ta pajjibbà, nánaw di Apu Kesu sù ili. ");
INSERT INTO att_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Á ta pannawák, panoli ri Apu Kesu ta Jerusalem, nasingad da yù káyu nga igò nga sinalebarád da sù tádday ággaw, nga nakatángin ngámin áddè ta gamù na. ");
INSERT INTO att_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Á manonò ni Eduru yù kinagi ni Apu Kesu nga meyannung sù káyu, á kinagi na, “Apu, innam mè yù káyu nga inigagek mu. Nakatángin!” ");
INSERT INTO att_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Á simibbák si Apu Kesu, á kinagi na nira, “Mangikatalà kayu kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kurugán yù kagiak ku nikayu. Nu manguruk yù tolay kâ Namarò ánna ari mabbábáng ta pangikatalà na, ajjan yù awayyá na nga maddok ta puddul, nga kagian na, ‘Meyalì ka, puddul, nga melappák ta bebay,’ á kurugan na. ");
INSERT INTO att_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yáyù nga kagiak ku nikayu ta maguray lâ yù ikomá naw kâ Namarò ta pakimállà naw, ikatalà naw ta alawatan nawin, á kuruk nga meyawâ nikayu. ");
INSERT INTO att_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Á sù pakimállà naw kâ Namarò, nu matakì yù nonò naw sù tolay nga nakaliwâ nikayu, máwák nga pakomán naw laguk, tapè pakomán nakayu gapay nayù Yáma naw nga Namarò nga maggián ta lángì. ");
INSERT INTO att_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta nu ari kayu mamakomá sù ira kábulun naw, arán na kayu gapay pakomán nayù Yáma naw nga Namarò nga maggián ta lángì.” ");
INSERT INTO att_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Á limibbè di Apu Kesu má ngin ta Jerusalem. Á nallakalakák si Apu Kesu sù námmuák nayù mangilin nga kapilliá nga najjijjingán. Á jimikkì kuna yù ira kátannangán nga pári ánna yù ira mesturu ta tunung ánna yù ira karakalán. ");
INSERT INTO att_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Á iniyabbû da kuna, “Anni yù paggapuán nayù pakáwayyám sù kingnguám? Asinni yù nangiyawâ nikaw sù pakáwayyám?” kud da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Simibbák si Apu Kesu, á kinagi na nira, “Ajjan gapay yù iyabbû ku nikayu. Á nu tabbagan nawà, kagiak ku laguk nikayu yù naggapuán nayù pakáwayyâ. ");
INSERT INTO att_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Si Kuan, nga yù ngaw minánnigù sù ira tatolay, asinni naggapuán nayù pakáwayyá na? Naggapu kâ Namarò, onu naggapu ta tolay? Kagian naw nikán.” ");
INSERT INTO att_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Á nakkakápereperang ira ta ubobuk, nga kud da, “Anni yù itabbák tam? Nu itabbák tam ta naggapu kâ Namarò yù pakáwayyá na, á iyabbû na sangaw, ‘Ngattá, ta arán naw laguk kinuruk si Kuan?’ ");
INSERT INTO att_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Á metabbák tam panò ta naggapu ta tolay?” Yáyù kinagi ra gapu ta maganássing ira sù ira tatolay nga makimoray kâ Kuan, gapu ta kinagi nayù ira tatolay ta kuruk nga ábbilinán ni Namarò si Kuan. ");
INSERT INTO att_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Á yáyù nga initabbák da kâ Apu Kesu, “Arám mi ammu yù naggapuán nayù pakáwayyá ni Kuan.” Á kinagi ni Apu Kesu nira, “Á yáyù nga arák ku laguk kagian nikayu yù naggapuán nayù pakáwayyâ sù akka-akkuák ku.” ");
INSERT INTO att_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Á nagángngarigán si Apu Kesu ta pangituddu na paga sù mangilin nga kapilliá, á kinagi na nira, “Ajjan yù tolay nga namulá ta úbas sù komán na, á inalitukán na. Á kinokkok na yù abbû ta áppaggalán ta bungá na. Á pidde na yù atannáng nga balay nga paggianán nayù ira minánnaron, tapè merípâ da yù ngámin nga áddè na kamulán. Á inikatalà na yù kamulán sù ira minánnangngal kuna, á nánaw nga minay ta arayyu nga lugár. ");
INSERT INTO att_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Á ta áppupúsik na bungá na úbas, jinok nayù tolay yù aripan na ta umay sù ira minánnangngal, tapè apan na nira yù balle na. ");
INSERT INTO att_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngam ginápù da yù aripan, á pinalapaligà da, á pinapáno ra nga awán ta inâ na. ");
INSERT INTO att_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Á jinok na má yù mekaruá nga aripan na. Á kingnguá ra yù ulu na ánna pinasiránád da. ");
INSERT INTO att_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Á jinok na má nira yù mekatallu nga aripan na, á pinapáte ra. Á kunniaw gapay kingnguá ra sù ira káruán nga jinok na, biddibiddù da yù ira káruán, á pinapáte ra yù ira káruán. ");
INSERT INTO att_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Á ta kabalin na yaw, ajjan lâ sù makáddabbun yù táttádday nga awayyá na nga doban, yù anâ na nga laláki nga iddukan na. Aggina yù naporián nga jinok na, ta kagian na ta nonò na, ‘Kuruk nga pakimorayád da yù anâ ku.’ ");
INSERT INTO att_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngam yù ira minángngallu, pakasingad da sù anâ nayù makáddabbun, makkaká-ubobuk ira, á kinagi ra, ‘Ye! Aggina yù anâ na nga makákkuá noka ngámin. Et tam papatáyan, á sittam galâ yù makákkuá.’ ");
INSERT INTO att_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Á ginápù da, á pinapáte ra ánna inilappák da sù liák na alitù.” ");
INSERT INTO att_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Á kinagi ni Apu Kesu nira, “Anni laguk akkuán nayù makáddabbun sù ira minánnaron ta kobasán na? Umay mamapátay nira, á ipataron na yù kamulán na sù ira tanakuán. ");
INSERT INTO att_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Arán naw panò binibbik yaw nga netúrâ, nga Ubobuk ni Namarò: ‘Ajjan yù batu nga inipuerá nayù ira nabbalay ta batu, gapu ta kagiad da ta awán ta serbi na. Á aggina yù batu nga mabbáli ta ánnáddagán nayù balay. ");
INSERT INTO att_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yaw yù kingnguá ni Apu Namarò, nga makapállâ nittam.’ ” ");
INSERT INTO att_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Á yù ira karakalán na Kudio, nánnámmuád da ta aggira yù ituddu ni Apu Kesu megapu sù pagángngarigán na nga meyannung sù ira narákè nga minánnaron ta kamulán ánna megapu sù netúrâ nga meyannung sù ira nabbalay ta batu, nga nangipuerá sù kapiánán. Á gaputad da nakuan, ngam pinaguráyád da, gapu ta maganássing ira sù ira magaru nga tatolay nga makimoray kuna. Á nánawád da laguk. ");
INSERT INTO att_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Á jinok da yù ira káruán nga Parisio ánna yù ira káruán nga kákkapárán ni Patul Erodo, tapè parubád da si Apu Kesu megapu sù pangiyabbû da kuna. ");
INSERT INTO att_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Á jimikkì ira kuna, á kinagi ra, “Mesturu, ammu mi ta kurugán ngámin yù ubobuk mu. Á arám mu paddurúmán yù ira tatolay, mássiki nu maríku ira onu pobare. Á ituddum lâ yù kurugán nga bilin ni Namarò nga meyannung sù ipakuá na sù ira tatole na. Kagiam mu laguk nikami nu ipugik nayù tunung tam yù mappagá ta buwì kâ Patul Sisar, nga mammaguray ta ili na Roma? Mappagá ittam laguk, onu ari?” ");
INSERT INTO att_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngam natákál ni Apu Kesu ta áppè pípiá ira, tapè ilogò da. Á yáyù nga kinagi na nira, “Ngattá, ta parubán nawà? Ipasingan nawè bì nikán yù pirâ.” ");
INSERT INTO att_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Á iniyawâ da kuna. Á kinagi na nira, “Asinni yù makámmammang ánna makángngágan nga masingat tam sawe kuártu?” Á kinagi ra, “Si Patul Sisar.” ");
INSERT INTO att_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Á kinagi ni Apu Kesu nira, “Iyawâ naw laguk kâ Sisar yù kukuá na. Á iyawâ naw gapay kâ Namarò yù kukuá ni Namarò.” Á yù kebalinán na, pagán naw yù buwì sù mammaguray, á iddukan naw ánna kurugan naw si Namarò. Á napállâ ira megapu sù napiá nga itabbák na. ");
INSERT INTO att_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kabalin na yaw, minay nga jimikkì kâ Apu Kesu yù ira káruán nga Sadusio. Aggira yù Kudio nga kagiad da ta ari maginnanolay yù baggi na tolay sù pagáddekán na ággaw. Á iniyabbû da kâ Apu Kesu, á kinagi ra, ");
INSERT INTO att_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mesturu, ajjan yù tunung nga initúrâ ni Moyses megapu nittam, ta nu patayán na tolay yù atáwa na ngam awán ta anâ da, máwák nga atawán nayù urián na yù bálu na, tapè maganâ ira sù pannakabaggi nayù kaká na nga natay. ");
INSERT INTO att_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Á gári, naggián saw pitu nga mawwawági nga lálláki. Á nangatáwa yù kaká, ngam natay nga awán ta anâ na. ");
INSERT INTO att_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Á inatáwa nayù mekaruá yù asípák na, ngam natay gapay nga awán ta anâ na. Á kunnian gapay yù nesimmu sù mekatallu ánna ngámin nga káruán. ");
INSERT INTO att_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aggira ngámin nga pitu, nattutubbâ ira nga nangatáwa sù babay, ngam awán bulubugá ta ánâ da. Á naporián nga natay gapay yù babay. ");
INSERT INTO att_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Á kagiam mu nikami laguk, sù ággaw nga paginnanole nayù ira námmatay, asinni sù ira pitu yù atáwa nayù babay, nepatalugáring ta nakiatáwa sù ira ngámin nga pitu,” kud da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Á kinagi ni Apu Kesu nira, “Yáyù nga makaliwâ kayu, ta arán naw garè ammu yù netúrâ sù mangilin nga ubobuk ni Namarò ánna yù pakapangnguá ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Á noka nu duttál yù paginnanole nayù ira námmatay, ari ira mangatáwa ánna makiatáwa, gapu ta megittá ira sù ira daroban ni Namarò nga maggián ta lángì. ");
INSERT INTO att_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Á ta meyannung sù paginnanole nayù ira námmatay, arán naw panò binibbik yù netúrâ sù libru ni Moyses nga meyannung sù káyu nga naggatang, nga ari nakassà? Pakasingan ni Moyses sù káyu nga naggatang, jimikkì kuna, á naginná na yù ngárál ni Namarò, á kinagi ni Namarò kâ Moyses: ‘Sikán si Namarò, nga pakiyápuán nayù ira naggaká nikaw. Sikán yù Yápu di Abrakam kári Isak kâ Akup.’ ");
INSERT INTO att_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Á yù ira námmatay, ari ira makiyápu kâ Namarò, ngam yù ira matolay yù makiyápu kuna. Ari matunung yù nonotan naw, ta arán naw ammu yù kuruk.” ");
INSERT INTO att_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Á ajjan tán yù tádday nga mesturu ta tunung, á naginná na yù pakkakápereperang nayù ira Sadusio kâ Apu Kesu. Á gapu ta kemámmatán na ta napiá yù initabbák ni Apu Kesu nira, jimikkì kuna ta iniyabbû na gapay kuna, á kinagi na, “Apu, anni yù purmeru nga tunung sù ira ngámin nga initaddán ni Namarò?” ");
INSERT INTO att_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Á simibbák si Apu Kesu, á kinagi na, “Yawe yù purmeru nga tunung sù ira initaddán ni Namarò: ‘Sikayu nga ginaká ni Israel, ginnán naw yù kagiak ku nikayu. Si Apu Namarò nga Yápu tam, aggina lâ yù táttádday. ");
INSERT INTO att_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Iddukan naw si Namarò nga Yápu naw, á itulù naw kuna yù ayâ nayù putu naw, yù ure naw, yù nonò naw, ánna yù sikan nayù baggi naw.’ ");
INSERT INTO att_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Á ajjan gapay nga netúrâ yù mekaruá nga máwák nga kurugam mu: ‘Iddukan naw yù ikáttole naw ta kunnay ta ángngiddù naw ta baggi naw.’ Awán ta tanakuán nga máwák nga kurugam mu, nu ari galâ danniaw nga duá,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Á kinagi na laguk nayù mesturu ta tunung kâ Apu Kesu, “Á kustu, Mesturu. Kurugán yù kinagim, nga táttádday lâ si Namarò, á awán ta tanakuán, nu ari lâ aggina. ");
INSERT INTO att_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Á máwák nga iddukat tam si Namarò nga Yápu tam, megapu sù napasigaggà nga ayâ nayù putu tam, ánna ngámin yù nonò tam, ánna yù sikan nayù baggi tam. Á iddukat tam gapay yù ira ikáttole tam ta kunnay ta ángngiddù tam ta baggi tam. Napiá yaw. Más napiá ta tuppálat tam danniaw nga tunung nga initaddán ni Namarò ánnè sù mangiyátáng ta aya-ayám nga natuggi ánna ngámin yù meyátáng nga meyawâ kâ Namarò.” ");
INSERT INTO att_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Á pakaginná ni Apu Kesu ta napiá yù initabbák na, kinagi na kuna, “Nu tuppálam mu yù egga ta nonò mu, mesipà ken sù pammagure ni Namarò.” Á kabalin ni Apu Kesu nakkagi karannian, awán laguk ta mangiyabbû kuna, ta napállâ ira gapu ta makáwayyá yù pagubobuk na. ");
INSERT INTO att_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Á pangituddu ni Apu Kesu sù mangilin nga kapilliá, nga bale ni Namarò, iniyabbû na sù ira tatolay, nga kun na, “Á yù ira mesturu sù tunung, anni má ta kagiad da ta ginaká ni Patul Dabid yù MakKiristu? ");
INSERT INTO att_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta si Patul Dabid, kinagi na yù inipalappâ nayù Mangilin nga Ikararuá kuna, á kinagi na, ‘Nagubobuk si Apu Namarò, á kinagi na sù Yápù: Magitubang ka sù jiwanák ku, nga ággitubangán nayù meparáyaw, áddè ta ipeguppè ku nikaw yù ira malussaw nikaw.’ ");
INSERT INTO att_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Á yáyù nga abbúnan ni Patul Dabid ta Yápu na yù MakKiristu. Á nu Yápu na yù MakKiristu, ngattá ta kagiad da ta ginaká na lâ? Ari galâ motun yù Yápu na ánnè kuna?” Á ayatán yù ira magaru nga tatolay nga magginná sù inituddu ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Á ta pangituddu ni Apu Kesu, kinagi na, “Mappalán kayu sù ira mesturu ta tunung. Ta ikáyâ da mabbarawási ta apaddu nga barawási ra ánna mappasingan ta dápun, tapè pakimorayád da ira nayù ira tatolay ta pappassapassiár da. ");
INSERT INTO att_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Á piliad da yù kapiánán na ággitubangán ta kapilliá ánna yù ággitubangán nayù maráyaw ta pakilálláng da ta piestá. ");
INSERT INTO att_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Á ilogò da yù ira bálu nga bábbay, tapè apad da yù kukuá ra, á áppa-áppè ira nga makimállà ta mabayák kâ Namarò, tapè ilímak da yù narákè nga akka-akkuád da. Á mepallà yù pamagikáru ni Namarò nira ta pagáddekán na ággaw.” ");
INSERT INTO att_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Á nagitubang si Apu Kesu aranni sù ángngipayyán ta kuártu nga ajjan sù lágum nayù mangilin nga kapilliá. Á inni-innan ni Apu Kesu yù ira tatolay nga umay mangipay ta limù da. Á aru yù ira maríku nga minay nangipay ta aru nga kuártu. ");
INSERT INTO att_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Á minay gapay yù bálu nga babay nga pobare, á pine na duá nga baddì nga pirâ, nga negittá ta duá nga sintábu. ");
INSERT INTO att_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Á inagálán ni Apu Kesu yù ira tudduán na, á kinagi na nira, “Innan nawè yù kingnguá nayù babay. Kurugán yù kagiak ku nikayu, aru yù kuártu nga inipe nayù pobare nga bálu ánnè sù inipe nayù ngámin ira káruán. ");
INSERT INTO att_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta inipe ra yù kuártu nga naggapu ta sobará ra. Ngam yù bálu, inipe na ngámin yù áddè na kapobare na, á awánin bulubugá ta ipakkatole na.” ");
INSERT INTO att_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Á ta páno ri Apu Kesu sù mangilin nga bale ni Namarò, kinagi nayù tádday nga tudduán na, “Mesturu, innam mu yawe ira mallakay nga batu, ánna yù ira nakástá nga bale nayù mangilin nga kapilliá!” kun na. ");
INSERT INTO att_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Wan,” kun ni Apu Kesu kuna. “Á innan naw yawe ira nakástá nga balay nga kapilliá! Ta duttál yù ággaw nga awán bulubugá ta batu na nga mallalátuk, ta mewarawarâ ira ngámin.” ");
INSERT INTO att_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Á labbè da sù puddul nga namulán ta káyu nga olibo, ta ábbák nayù mangilin nga kapilliá, á nagitubang ira. Á jimikkì kâ Apu Kesu yù ira lâ nga appâ nga tudduán na, si Eduru, si Ime, si Kuan, ánna si Andares, aggira lâ, ta ajjan yù iyabbû da kuna. ");
INSERT INTO att_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Á kinagi ra kuna, “Kagiam mungè nikami nu anni yù ággaw nga kesimmu na danniaw nga kinagim gangù nga meyannung sù mangilin nga kapilliá. Á anni yù panákkilalán ta duttál yù kapalurò na?” ");
INSERT INTO att_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Á simibbák si Apu Kesu, á kinagi na nira, “Mappalán kayu, tapè ari kayu melogò. ");
INSERT INTO att_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta aru yù ira nga umay noka nga mappassippíl nikán. Á kagiad da ta aggira sikán nga MakKiristu, á aru yù ira tatolay nga ilogò da. ");
INSERT INTO att_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Á nu marámak naw yù meyannung sù ira maggerrá ánna yù ira nga makigerrá ta arayyu nga lugár, ari kayu maburung ta máwák nga mesimmu yaw, ngam ari paga yaw yù pagáddekán na dabbuno. ");
INSERT INTO att_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Á yù ira tatolay nga naggapu ta dumá nga lugár, umay ira makigerrá sù ira nga maggián ta tanakuán nga lugár, á umay yù ira nga naggapu ta tádday nga páppatulán nga makigerrá sù ira nga maggián ta tanakuán nga páppatulán. Á mallunik ta aru nga lugár, ánna mabbisin yù ira tatolay ta aru nga lugár. Danniaw ira nga mesimmu yù pamegapu na lâ nayù jigâ, nga kunnay sù jigâ na babay nga maganâ yù keyarigán na. ");
INSERT INTO att_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ngam sikayu, magimuguk kayu, ta gaputad da kayu nga ikeká sù ira Kudio nga mamanunnù, á mabaddù kayu sù ira kapilliá ra. Á gapu ta panguruk naw nikán, ikeká ra kayu ta arubáng nayù ira gubinador ánna yù ira patul. Á keyarubáng naw nira, yáyù yù awayyá naw nga mangipakánnámmu nira sù napiá nga dámak nga meyannung nikán. ");
INSERT INTO att_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta máwák nga melayalayâ yù napiá nga dámak ta ngámin nga makkakerumá nga tatolay pángè na duttál yù áddè nayù dabbuno. ");
INSERT INTO att_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Á ta pangikeká ra nikayu, ari kayu maburung nu anni yù itabbák naw nira. Á ta pangiyabbû da nikayu, mepakánnámmu nikayu yù kagian naw nira. Ta ari maggapu ta nonò naw yù kagian naw nira, nu ari galâ nga maggapu sù Mangilin nga Ikararuá ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Á yù ira nga mawwagi nga lálláki, ikeká nayù tádday yù wagi na, á ipapapáte na. Á ikeká nayù yáma yù anâ na, á ipapapáte na. Á yù ira ábbing, mapporay ira sù ira darakal da, á ikeká ra yù ira darakal da, á ipapapáte ra ira. ");
INSERT INTO att_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","“Á sikayu nga makituddu nikán, ikalusso ra kayu na ngámin na tatolay gapu ta panguruk naw nikán. Ngam yù tolay nga mapasigaggà yù pangikatalà na nikán áddè ta pagáddekán, aggina yù meyígù nga mesipà kâ Namarò sù pammagurayán na ta áddè ta áddè,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Á kinagi ni Apu Kesu paga nira, “Masingan naw sangaw yù mangala-állirák nga makánnanássing nga mamassippíl, nga manáddak sù gián nga arán na nakuan panáddagán. Á sikayu nga mabbibbik, nonotan naw yù kebalinán na! Á yù ira tatolay nga maggián sù purubinsia na Judiya ta ággo na dattál nayù makánnanássing, máwák nga mattálaw ira nga umay ta puddul. ");
INSERT INTO att_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Á yù tolay nga ajjan ta lawán na bale na, onu magibannák ta utun nayù sináttatapán nga bale na, ari tullung ta bale na, nga umay mangâ ta ipulù na. ");
INSERT INTO att_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Á yù tolay nga mattarabáku sù ákkomanán na, máwák nga ari manoli ta bale na, nga umay mangâ ta ulolà na. ");
INSERT INTO att_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Á kábbi yù ira nga mabussì ánna yù ira nga konsu tagibi tán nga ággaw, ta ari ira makakarerá. ");
INSERT INTO att_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Makimállà kayu kâ Namarò ta ari mekanná ta ammián yù ággo nayù jigâ naw. ");
INSERT INTO att_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta umay sangaw yù jigâ nga mappanà ánnè ta ngámin nga jigâ ta áddè ngaw pamarò ni Namarò ta dabbuno ta áddè kunangan, á awánin bulubugá ta jigâ nga kagittá na ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Á nu arán na nakuan pangarián ni Namarò yù ággo na jigâ, awán bulubugá ta matolay. Ngam pangarián na megapu sù ira nga piníli na ta tatole na. ");
INSERT INTO att_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Á nu ajjan yù tolay nga makkagi nikayu ta ‘Innan nawè, ajjanin saw yù MakKiristu,’ onu kagian na, ‘Innan nawè, ajjanin tukewà yù MakKiristu,’ arán naw kurugan yù kagian na. ");
INSERT INTO att_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta duttál yù ira nga mattákiristu ánna yù ira nga mattá-ábbilinán, á aru yù ipasingad da nga panákkilalán nga makapállâ, tapè ilogò da nakuan mássiki yù ira piníli ni Namarò ta tatole na. ");
INSERT INTO att_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngam sikayu, magimuguk kayu, ta dán nga kinagì nikayu pángè na mesimmu dannian.” ");
INSERT INTO att_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Á kinagi ni Apu Kesu paga, “Á ta kabalin nayù jigâ, makkallà yù bilák. Á ari manawák yù bulán gapay. ");
INSERT INTO att_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Á gipannátán yù ira bituan, nga maggapu ta lángì. Á yù ira nga maggián ta lángì, meyalì ira sù giád da. ");
INSERT INTO att_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Á masingad dangà laguk nayù ira tatolay, sikán nga Kaká ngámin na tatolay, nga umay nga mepulù sù kunam, nga maddalingáráng ánna makáwayyá. ");
INSERT INTO att_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Á dobak ku yù ira daroban nga maggián kâ Namarò, tapè ed da ammungan yù ira piníli ni Namarò nga siminuttul nikán ta dabbuno, aggira ngámin nga naggapu ta ngámin nga lugár da sù utun na dabbuno,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Á kinagi ni Apu Kesu nira, “Ginnán naw yù ángngarigán nga meyannung ta igò ánna yù ira káruán nga káyu. Nu masingan naw ta mapatalián yù don na káyu, ammu naw ta mapatalián sangaw yù ággián na ággaw. ");
INSERT INTO att_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Á ta kunnian gapay, nu masingan naw yù kesimmu nayù ngámin nga jigâ nga kinagì nga umay, mánnámmuán naw ta aranni ngin yù panolì saw, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kurugán yù kagiak ku nikayu, mesimmu ngámin danniaw nga kinagì nikayu lage na pate nayù ira tatolay nga matolay kunangan. ");
INSERT INTO att_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Duttál yù ággaw nga awánin yù dabbuno ánna yù lángì ánna ngámin nga ajjan nira. Ngam ari bulubugá mapatalián yù ubobuk ku,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Á kinagi na laguk, “Á ta meyannung sù ággaw ánna oras nga kesimmu na ngámin danniaw, awán ta makánnámmu. Mássiki yù ira daroban ni Namarò nga maggián ta lángì, arád da ammu. Á sikán, nga Anâ ni Namarò, arák ku ammu. Ngam si Ammò ku nga Namarò, aggina lâ makánnámmu. ");
INSERT INTO att_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Á mappalán kayu laguk. Napiá nu kunnay kayu ta matturá, ta arán naw ammu nu anni nga oras yù dattál na. ");
INSERT INTO att_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Á kunniaw yù keyarigán na. Ajjan yù tolay nga maggagannuâ ta umay ta arayyu nga lugár. Á inipataron na ngámin yù kukuá na sù ira aripan na, á kagian na sù ira katággitádday yù tarabáku na. Á kagian na sù ira magguárdiá ta matturá ira nga manaron ta ngámin. ");
INSERT INTO att_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yáyù nga magiddi-iddak kayu laguk, ta arán naw ammu nu káni yù labbè nayù makábbalay, nu lubbè sangaw nu pajjibbà onu tangngá na gabi, onu pagittarákkò na manù, onu alippánnawák. ");
INSERT INTO att_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Magimuguk kayu laguk nga magiddak, tapè arán na kayu maratang nga ari paga maparán nga kunnay ta makkaturuk, nu ikáddagâ na lâ manoli. ");
INSERT INTO att_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Á yaw nga kagiak ku nikayu, kagiak ku sù ira ngámin nga tatolay, magimuguk kayu nga magiddak, tapè dán nga naparán kayu,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Á ajjan duá nga ággaw paga lage na piestá na pattalebarán nayù daroban, nga pakkákád da ta pán nga awán ta állapparán na. Á yù ira kátannangán nga pári na Kudio ánna yù ira mesturu ta tunung, alerad da yù paggápù da kâ Apu Kesu nga awán ta makánnámmu, tapè papatáyad da. ");
INSERT INTO att_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yáyù gapu na nga makkakátabarang ira, á kinagi ra, “Arát tam lábbì gubatan sù keggá ra nga makipiestá, marakè akkuád da ittam nayù ira tatolay.” ");
INSERT INTO att_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Á minay di Apu Kesu ta ili na Bitania, ta bale ni Simon nga naggoggong ngaw. Á pakkákád da, minay yù babay sù gián ni Apu Kesu, nga nanangngal ta boteliá nga napadday ta puraw nga batu, nga napannu ta denu nga bábbanguk nga naggapu ta gamù na nardu, nga kitanginá. Á pikká nayù babay yù bullo na boteliá, á inibubbù na yù denu ta ulu ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngam yù ira káruán nga makasingan, napporay ira. Á nakkaká-ubobuk ira, á kinagi ra, “Kengá lâ yù bábbanguk. Ngattá, ta initabbà na? ");
INSERT INTO att_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mapiá nakuan nu meláku ta maturù nga tallu gatù nga pesù ta meyawâ nakuan sù ira pobare,” kud da. Á gimmá ra yù babay. ");
INSERT INTO att_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngam simibbák si Apu Kesu nira, á kinagi na, “Arán naw akkuán. Ngattá, ta pasiránán naw? Napiá yù kingnguá na nikán. ");
INSERT INTO att_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Maggián gemma ta áddè sù gián naw yù ira pobare, á awayyá naw ira abbágán, nu anni nga ággaw nga gustu naw nga mangabbák nira. Ngam sikán, aringà maggián nikayu ta áddè. ");
INSERT INTO att_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Á kingnguá nayù babay yù lâ awayyá na nga akkuan. Arán na iniddagán yù patè, ta jinenuán na yù baggì, nga paránan na ta ketanam ku. ");
INSERT INTO att_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Á kurugán yù kagiak ku nikayu, maguray lâ ta dabbuno yù pangilayalayatán sù napiá nga dámak, mepakánnámmu gapay yù kingnguá nayù babay nikán, ta panaddamán nayù ira tatolay kuna.” ");
INSERT INTO att_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Á si Kudas Iskariote, nga mebiláng sù ira mapulu duá nga sinullà ni Apu Kesu, minay laguk sù gián nayù ira kátannangán nga pári na Kudio, tapè makitarátu nira ta ipagápù na si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Á pakaginná ra sù kinagi na, nagayáyâ ira, á initabbá ra ta iddád da ta kuártu. Á inalek na laguk ni Kudas yù awayyá na nga mappagápù kâ Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Á jimittál yù olu nga ággo nayù piestá, nga pakkákád da ta pán nga awán ta állapparán na, ánna pappárti ra ta karneru. Á iniyabbû da kâ Apu Kesu nayù ira tudduán na, “Sisaw ikáyâ mu nga papparánám mi ta pakkákanát tam?” ");
INSERT INTO att_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Á jinok ni Apu Kesu yù duá nga tudduán na, á kinagi na nira, “E kayu bì tuke ili, á maratang naw yù laláki nga mangáttu ta ammutu. Á tumuttul kayu kuna. ");
INSERT INTO att_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Á sù balay nga tallungán na, kagian naw yaw sù makábbalay, ‘Iyabbû nayù Mesturu nikaw nu sisaw gián nayù paggianán na álliuk, tapè umay sangaw kumán ta panaddamán ta pattalebák nayù daroban, aggina ánna yù ira tudduán na?’ kun naw sangaw kuna. ");
INSERT INTO att_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Á ipasingan na nikayu sangaw yù aláwa nga lágum ta utun. Á dán nga naparán sù lágum yù ngámin nga awágan naw. Paránan naw tán yù kanat tam,” kun ni Apu Kesu sù ira duá. ");
INSERT INTO att_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Á nánaw yù ira duá, á minay ira ta ili. Á naratang da ngámin nga kunnay sù kinagi na, á pinarád da yù kanad da nga panaddamán ta pattalebák nayù daroban. ");
INSERT INTO att_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Á ta pajjibbà, limibbè di Apu Kesu ánna yù ira mapulu duá nga tudduán na. ");
INSERT INTO att_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Á pallalálláng da paga, kinagi ni Apu Kesu nira, “Kurugán yù kagiak ku nikayu, ajjan nikayu yù mappagápù nikán, nga mepallálláng nikán kunangane.” ");
INSERT INTO att_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Á pakaginná ra karanniaw, inikáddagâ da lâ naraddam. Á nattutubbâ ira nga nangiyabbû kuna, á kinagi ra, “Ari nga sikán, unè?” ");
INSERT INTO att_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Wan, tádday nikayu, nga mepasuddà ta pán sù tangalosá nga jigu. ");
INSERT INTO att_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Matayà gemma, sikán nga Kaká na ngámin na tatolay, ta yáyù inipetúrâ ni Namarò sù dán nga netúrâ, ngam kábbi yù tolay nga mappagápù nikán. Mapiá nakuan nu ari neyanâ.” ");
INSERT INTO att_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Á sù pakkákád da paga, inâ ni Apu Kesu yù pán. Á kabalin na nabbalabálà kâ Namarò, giddigidduá na yù pán nga iniyawâ na nira. Á kinagi na, “Mangâ kayu sawe, ta kanan naw. Yawe yù baggì.” ");
INSERT INTO att_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Á inâ na yù tangapassuelu nga binaráyáng nga naggapu ta tabbuk na úbas. Á pabbalabálà na kâ Namarò, iniyawâ na nira, á aggira ngámin mininum kuna. ");
INSERT INTO att_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Á kinagi na nira, “Yawe yù dágà nga mebubbù ta ketapil ku megapu ta aru nga tatolay, tapè pakomán ni Namarò ira ta liwiliwâ da. Yù dágà yù panákkilalán ta napasigaggà ánna mekatalà yù bagu nga tarátu ni Namarò sù ira tatole na. ");
INSERT INTO att_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kurugán yù kagiak ku nikayu, arák kin ulian nga inuman áddè ta inumak ku noka yù bagu sù pammagurayán ni Namarò.” ");
INSERT INTO att_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Á nakkansion ira ta áddáyo ra kâ Namarò. Kabalid da nakkansion, nánaw ira nga minay sù puddul nga namulán ta káyu nga olibo. ");
INSERT INTO att_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Á pallakalakák da, kinagi ni Apu Kesu sù ira tudduán na, “Sikayu ngámin yù manájji nikán sangaw nu mappanà yù ággiák ku. Ta ajjan yù netúrâ nga kinagi ni Namarò nga kunniaw: ‘Papatáyak ku yù mináppárák, á mewarawarâ yù ira karneru, gapu ta awán ta manaron nira.’ ");
INSERT INTO att_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngam maginnanolayà, á ta paginnanolè, mapolungà ánnè nikayu nga umay túrin ta purubinsia na Galilia.” ");
INSERT INTO att_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Á pakkagi ni Apu Kesu ta táttájjiád da, kinagi ni Eduru kuna, “Mássiki nu aggira ngámin yù mánaw nikaw, ngam sikán lápay, arát taka tájjián.” ");
INSERT INTO att_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Á kinagi ni Apu Kesu kuna, “Kurugán yù kagiak ku nikaw, lage na mamidduá magittarákkò yù manù sangaw nu gabi, mamillu ka nga makkagi ta arám mà ammu.” ");
INSERT INTO att_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngam initaggâ ni Eduru nga kinagi, “Mássiki nu sitta duá yù matay, arák ku ilímak ta ammu taka.” Á kunnian yù kinagi ra ngámin nga katággitádday. ");
INSERT INTO att_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Á labbè di Apu Kesu ta kamulán nga mangngágan ta Getsemani, kinagi ni Apu Kesu sù ira tudduán na, “Magiddak kayu saw, ta ek ku bì tán nga makimállà kâ Namarò.” ");
INSERT INTO att_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ngam inipulù na yù ira tallu lâ, si Eduru, ánna si Ime kâ Kuan. Á inikáddagâ na lâ ni Apu Kesu napábbaw ánna naburung. ");
INSERT INTO att_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Á kinagi na nira, “Mággekà mappassì sù kepallà nga daddam ku. Maggián kayu saw nga matturá.” ");
INSERT INTO att_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Á nallillì si Apu Kesu ta baddì paga nira, á namalittúkak, á nakimállà kâ Namarò tanu awayyá na, ari nakuan mesimmu kuna yù jigâ nga umay kuna. ");
INSERT INTO att_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Á kinagi na, “Ammò ku, Ammò ku, sikaw ngámin yù makáwayyá. Ilillì mà sù jigâ nga umay nikán. Ngam arám mu anugutan yù urè nu ari galâ yù urem,” kun na kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Á ta kabalin na nga nakimállà, nattoli si Apu Kesu sù ira tallu nga kábulun na, á naratang na ira nga makkaturuk. Á kinagi na kâ Eduru, “Simon, makkaturuk ka? Ari ka panò makapatturá ta mássiki lâ tangoras? ");
INSERT INTO att_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Matturá kayu nga makimállà, tapè arán na kayu appútan na liwâ. Ta mássiki nu molang kayu malliwâ, ngam makapi yù baggi naw.” ");
INSERT INTO att_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kabalin na nga nilukák ira, nallillì si Apu Kesu má, á inuli na má yù ákkimállà na kâ Namarò. ");
INSERT INTO att_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Á nanoli má nira, á naratang na ira má nga makkaturuk, ta arád da magimmúlák yù matá ra. Á arád da ammu nu anni yù itabbák da nakuan kuna. ");
INSERT INTO att_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Á namillu nga nanoli si Apu Kesu nira, á iniyabbû na nira, “Makkaturuk kayu paga nga magibannák? Kustu ngin. Jimittál ngin yù oras nga kagápù ku, á iyawâ dangà sù ira minálliwâ, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gumikkáng kayu, ta et tamin. Innan nawè. Ajjanin yù mappagápù nikán.” ");
INSERT INTO att_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Á sù arán na paga kabalin nga nagubobuk ni Apu Kesu nira, dagarágâ nga limibbè si Kudas, nga mebiláng sù ira mapulu duá nga tudduán na. Á nepulù kâ Kudas yù ira kitáru nga nagármas ta badáng ánna palù. Aggira ngámin yù jinok nayù ira kátannangán nga pári na Kudio ánna yù ira mesturu ta tunung ánna yù ira karakalán. ");
INSERT INTO att_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Á pattatarátu ra gangù, kinagi ni Kudas nira yù panákkilalád da kâ Apu Kesu. “Yù tolay nga ummaták ku, aggina yù gaputan naw sangaw. Á ipáno naw, á taronán naw ta napiá.” ");
INSERT INTO att_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Á pakáddè da ta kamulán, dagarágâ nga jimikkì si Kudas kâ Apu Kesu. Á kinagi na, “Apu,” á inummatán na. ");
INSERT INTO att_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Á ginápù da si Apu Kesu, á inigaggak da ta napiá. ");
INSERT INTO att_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngam ajjan yù tádday nga kabbulun na, á inilayâ na yù badáng na, á kittak na yù aripan nayù pári nga kátannangán, á nalasápán yù talingá na. ");
INSERT INTO att_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Á kinagi ni Apu Kesu sù ira naggápù kuna, “Kagian naw panò ta tulisánà, ta umay kayu maggápù nikán nga nagármas ta badáng ánna palù? ");
INSERT INTO att_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Á kággággaw, naggiánà nikayu nga mangituddu sù mangilin nga bale ni Namarò, á arán nawà ginápù. Ngam mesimmu yaw, tapè matuppál yù inipetúrâ ni Namarò sù dán nga netúratán.” ");
INSERT INTO att_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Á ngámin yù ira nga sinudduán ni Apu Kesu, nattálaw ira, á nánawád da. ");
INSERT INTO att_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Á ajjan tán gapay yù bagitolay nga nagulolà. Á yù ira mangikeká, ginápù da. ");
INSERT INTO att_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ngam bittáng na nira lâ yù ulà na, á nagilongán nga nattálaw. ");
INSERT INTO att_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Á inituluk da laguk si Apu Kesu ta bale nayù kátannangán nga pári. Á ngámin ira nga káruán nga kátannangán nga pári ánna yù ira karakalán, á yù ira mesturu ta tunung, naggagammung ira tán. ");
INSERT INTO att_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Á jimináddán si Eduru ta arayyu ta likuk da. Á labbè da ta bale nayù kátannangán nga pári, simillung si Eduru sù nálitukán nga námmuák, á minay nepagitubang nga nepaggirínu sù ira magguárdiá. ");
INSERT INTO att_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Á yù ira kátannangán nga pári ánna ngámin ira nga mammaguray, alerad da yù ipangikeká ra kâ Apu Kesu, tapè ajjan yù awayyá ra nga mamapátay kuna, ngam awán ta nálek da. ");
INSERT INTO att_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ta aru yù ira nga nassirisiri nga nangikeká kuna, ngam ari naggigittá yù kinagi ra. ");
INSERT INTO att_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Á manganánnuán, ajjan yù ira káruán nga minay nga mangikeká kuna, á nassirisiri ira gapay, á kinagi ra, ");
INSERT INTO att_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Naginná mi yù kinagi na. Kinagi na ta iwarâ na yù mangilin nga bale ni Namarò nga pidde na tolay, á nu mapasá tallu nga ággaw, patáddagan na yù tanakuán nga arán na pidde na tolay.” ");
INSERT INTO att_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Á mássiki nu kunnian yù pangikeká ra, ari negittá yù kinagi ra. ");
INSERT INTO att_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Á limikkâ yù kátannangán nga pári ta tangngá ra, á iniyabbû na kâ Apu Kesu, “Awán panò ta itabbák mu sù ira mamaliwâ nikaw?” ");
INSERT INTO att_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngam ari bulubugá nakkituk si Apu Kesu. Awán bulubugá ta itabbák na nira. Á iniyabbután na má nayù kátannangán nga pári, “Sikaw panò yù MakKiristu, nga Anâ ni Namarò?” ");
INSERT INTO att_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Á kinagi ni Apu Kesu, “Wan, sikán. Á masingan nawà nga Kaká na ngámin na tatolay, nga magitubang sù ággitubangán nayù maráyaw, ta jiwanán ni Namarò nga Makáwayyá ta ngámin. Á masingan nawà nga umay nga mepulù ta maddalingáráng nga kunam ta lángì.” ");
INSERT INTO att_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Á pakaginná nayù kátannangán nga pári sù kinagi ni Apu Kesu, pinisil nayù pári yù bisti na nga apaddu, gapu ta napátu yù nonò na. Á kinagi na, “Awánin ta máwák tam nga magalek paga ta tolay nga makkagi ta liwâ na. ");
INSERT INTO att_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Naginná naw yù kinagi na, nga aggina yù Anâ ni Namarò. Anni yù ure naw nga meyannung kuna?” kun nayù pári nira. Á aggira ngámin, kinagi ra ta ikáru na yù liwâ na ta pate na. ");
INSERT INTO att_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Á pakaginná nayù ira káruán ta mapapátay si Apu Kesu, nilutábád da. Á kinallabád da yù mammang na, á sinultù da, ánna kinagi ra kuna, “Labbúnam mu yù manultù nikaw.” Á ed da laguk inâ nayù ira magguárdiá, ánna lippilippák da. ");
INSERT INTO att_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Á paggián ni Eduru paga ta námmuák, minay yù babay nga aripan nayù kátannangán nga pári. ");
INSERT INTO att_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Á pakasingan nayù babay kâ Eduru nga mepaggirínu, inimámmatán na, á kinagi na kuna, “Sikaw gapay yù kabbulun nayù tolay nga taga Nasaret.” ");
INSERT INTO att_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngam inilímak ni Eduru, á kinagi na, “Arák ku ammu. Arák ku kánnámmuán yù kagiam mu nikán.” Á nallillì si Eduru nga minay ta puertá nayù alitù. Á dagarágâ nagittarákkò yù manù. ");
INSERT INTO att_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Á manganánnuán, nasingan na má nayù babay, á kinagi na sù ira tatolay nga nanáddak tán, “Aggina gemma yù kabbulud da.” ");
INSERT INTO att_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngam inilímak na má ni Eduru. Á manganánnuán, á yù ira káruán nga ajjan tán, kinagi ra gapay kâ Eduru, “Sikaw yù kabbulun na, ta taga Galilia ka gemma gapay.” ");
INSERT INTO att_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ngam inigagek ni Eduru yù baggi na, á nappagássingán kâ Namarò ta kurugán yù kagian na. Á kinagi na nira, “Arák ku ammu yawe nga laláki nga kagian naw.” ");
INSERT INTO att_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Á inikáddagâ pidduá nayù manù nagittarákkò. Á dagarágâ, nanonò ni Eduru laguk yù kinagi ni Apu Kesu kuna, nga “Sangaw nu gabi, lage na mamidduá magittarákkò yù manù, mamillu ka nga makkagi ta arám mà ammu.” Pakanonò ni Eduru karannian, inigabbuâ na nga nakkulè. ");
INSERT INTO att_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Á ta pannawák, naggagammung yù ira ngámin nga kátannangán nga pári, yù ira karakalán, yù ira mesturu ta tunung, ánna yù ira káruán nga makáwayyá. Á nakkaká-ubobuk ira ta meyannung sù akkuád da kâ Apu Kesu. Á bináluk da laguk, nga iniyánge ra kâ Gubinador Pilatto, ta ikeká ra kuna. ");
INSERT INTO att_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Á iniyabbû ni Gubinador Pilatto kâ Apu Kesu, “Sikaw yù Patul nayù ira Kudio?” Á simibbák si Apu Kesu, á kinagi na, “Kurugán yù kinagim.” ");
INSERT INTO att_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Á yù ira kátannangán nga pári, aru yù kinagi ra kâ Gubinador Pilatto nga ipamaliwâ da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Á pakaginná ni Gubinador Pilatto ta aru nga kinagi ra, iniyabbû na má kâ Apu Kesu, “Awán panò ta itabbák mu? Arám mu panò naginná yù aru nga ipamaliwâ da nikaw?” ");
INSERT INTO att_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngam ari má simibbák si Apu Kesu, á napállâ si Pilatto ta pagimammà na. ");
INSERT INTO att_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Á sù piestá nga panaddamád da ta pattalebák nayù daroban, ajjan yù kustombare ni Gubinador Pilatto nga palubbángan na yù tádday nga nebáluk nga pilian nayù ira tatolay. ");
INSERT INTO att_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Á ajjan yù tolay nga nebáluk nga mangngágan ta Barabas, nga netádday ngaw sù ira nakikontará ta gubermente. Á aggina namapátay ta paggerrá ra, á yáyù nga inibáluk da. ");
INSERT INTO att_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Á minay kâ Gubinador Pilatto yù magaru nga tatolay, nga makkiddaw ta akkuán na yù kustombare na nira. ");
INSERT INTO att_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Á iniyabbû ni Pilatto nira, “Ikáyâ naw nu palubbángak ku yù Patul na Kudio?” ");
INSERT INTO att_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yáyù iniyabbû ni Pilatto nira, ta ammu na ta inikeká nayù ira kátannangán nga pári gapu ta mapassil ira kuna. ");
INSERT INTO att_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngam pinappatapátu nayù ira kátannangán nga pári yù ira magaru nga tatolay, ta kiddawad da galâ ta si Barabas yù palubbángan na. ");
INSERT INTO att_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Á iniyabbû na má ni Pilatto nira, “Anni akkuák ku laguk sù tolay nga abbúnan naw ta Patul na Kudio?” ");
INSERT INTO att_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Á nagagga-aggay ira má nga mapporay, á kinagi ra, “Papatáyam mu! Ipepátà mu ta kurù!” kud da ngámin. ");
INSERT INTO att_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Á kinagi ni Pilatto nira, “Ngattá? Anni yù liwâ na?” Ngam nappanà ira nga nagagga-aggay, á kinagi ra, “Papatáyam mu! Ipepátà mu ta kurù!” ");
INSERT INTO att_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Á gapu ta ikáyâ ni Pilatto nga pakáppagan na yù ira tatolay, pinalubbáng na laguk si Barabas. Á kabalin na nangipaligà kâ Apu Kesu, iniyawâ na sù ira suddálu, tapè ipátà da ta kurù. ");
INSERT INTO att_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Á yù ira suddálu, iniyánge ra si Apu Kesu ta námmuák na palásiu nayù Gubinador. Á inagálád da yù ira káruán nga suddálu gapay, á naggagammung ira ngámin. ");
INSERT INTO att_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Á áppè ira naddáyaw kâ Apu Kesu. Á inibarawási ra kuna yù apaddu nga ujjojjin, nga kun na barawási na patul. Á inipe ra sù ulu na yù kuroná nga sî nga nalubik. ");
INSERT INTO att_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Á áppè ira naddáyaw nga nagagga-aggay, á kinagi ra, “Káy! Ajjan yù Patul na Kudio!” ");
INSERT INTO att_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Á pinalapalù da yù ulu na, á nallulutábád da, á namalittúkak ira nga áppè maddáyaw ta arubáng na. ");
INSERT INTO att_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Á kabalid da nga nanguyoyung, iniriád da kuna yù barawási nga ujjojjin, á pine ra kuna yù barawási na lápay. Á iniyánge ra ta lawán, tapè papatáyad da ta kurù. ");
INSERT INTO att_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Á pangiyánge nayù ira suddálu kâ Apu Kesu, nerapunád da ta dálan si Simon nga taga Sirine, nga yáma ri Alekanduru kâ Rupo, nga naggapu ta ákkomanán na. Á inipakáttu ra kuna yù kurù ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Á iniyánge ra ta gián nga mangngágan ta Golgota, á yù kebalinán na sù ággubobuk da yù gián na balakábâ. ");
INSERT INTO att_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Á iniyalawâ da kuna yù binaráyáng nga nakkiruk ta uru nga mirrá nga ámmatukkâ ta takì, ngam arán na inalawâ. ");
INSERT INTO att_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Á inipátà da sù kurù. Á nabbubúnù ira, tapè natunung yù ábballe ra ta gagámì na. ");
INSERT INTO att_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Á yá pangipátà da kuna yù pannarek na bilák ta ummá. ");
INSERT INTO att_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Á netúrâ sù utun na kurù na yù ipangikeká ra kuna nga kunniaw, “Yù Patul na Kudio.” ");
INSERT INTO att_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Á nipátà da gapay yù duá nga tulisán ta kurù da, nga nattangngád da si Apu Kesu, tádday sù jiwanán na, á tádday sù jimigi na. ");
INSERT INTO att_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yáyù nga napalurò yù dán nga netúrâ nga bilin ni Namarò: “Aggina inibiláng da sù ira minálliwâ.” ");
INSERT INTO att_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Á yù ira tatolay nga nattalebák sù kurù, inuyo ra nga binilibilawád da si Apu Kesu. Á kinagi ra kuna, “Asakay! Sikaw yù makkagi ta iwarawarâ mu nakuan yù batu nayù mangilin nga kapilliá, á paddayam mu má ta tallu nga ággaw! ");
INSERT INTO att_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iyígù mu laguk yù baggim! Ámmuluk ka laguk sù kurù,” kud da. ");
INSERT INTO att_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Á yù ira kátannangán nga pári ánna yù ira mesturu ta tunung, inuyoyungád da si Apu Kesu, á makkaká-ubobuk ira, á kinagi ra, “Iniyígù na yù ira káruán nga tatolay, ngam arán na meyígù yù baggi na. ");
INSERT INTO att_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nu aggina yù Kiristu nga Piníli ni Namarò, nga Patul na Israel, ámmuluk laguk nakuan sù kurù, tapè masingat tam. Á nu masingat tam, manguruk ittam,” kud da. Á yù ira kábulun na nga nepátà, aggira pay manguyaw kuna. ");
INSERT INTO att_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Á ta tangngá na ággaw, nakkallà sù tangapáddabbunán ta tallu oras, áddè ta pannarek na bilák ta púgák. ");
INSERT INTO att_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Á ta alas tares ta púgák, nakkatakatol si Apu Kesu, á kinagi na, “Eloy, Eloy, lama sabák tani?” Á yù kebalinán na, “Apu Namarò, Apu Namarò, anni má ta sinájjiám mà?” kun na. ");
INSERT INTO att_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Á yù ira tatolay nga nanáddak tán, naginná ra. Á kinagi ra, “Ginnán nawè! Agálán na támma si Elias,” kud da, ta arád da ammu yù ággubobuk na. ");
INSERT INTO att_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Á nakkarerá yù tádday nga en na inâ yù sine na áttabbatabbúrù nga nakatáng, á inipasassà na yù nássam nga binaráyáng. Sinubbà na ta káyu, á iniyalawâ na kuna, tapè sussutan na. Á kinagi na sù ira naggíraw tán, “Iddagát tam lábbì, tapè masingat tam nu umay si Elias nga mangiyuluk kuna.” ");
INSERT INTO att_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Á nakkalli si Apu Kesu ta masikan, á dagarágâ nagattâ yù inángà na. ");
INSERT INTO att_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Á napisil yù nakannak nga kortíná nga nelippak sù lágum nga kangilinán, sù mangilin nga kapilliá ta ili na Jerusalem. Namegapu nga naggadduá yù kortíná ta utun na áddè ta gukák na. Á negiddán sù pate ni Apu Kesu yù paggadduá na. ");
INSERT INTO att_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Á ajjan yù kapitán na suddálu nga mepagarubáng kâ Apu Kesu. Á pakasingan na ta kagattâ nayù inángà na, kinagi na, “Aggina yù kukurugán nga Anâ ni Namarò!” ");
INSERT INTO att_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Á ajjan gapay tán yù ira bábbay nga mangirípâ kâ Apu Kesu. Á nepulù nira di Maria nga taga Maddala, kári Saloma, kâ Maria nga yená nayù ira duá nga lálláki, di Kusè kâ Ime nga urián na. ");
INSERT INTO att_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Danniaw ira yù siminuttul kâ Apu Kesu nga nangabbák kuna sù keggá na ta Galilia. Á ajjan tán gapay aru ira paga nga nepulù kuna sù ánge na ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Á Biernes yù papparán nayù ira Kudio ta ággibannák da nga Sabadu. ");
INSERT INTO att_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Á ta pajjibbà, limibbè ta Jerusalem si Kusè nga taga Arimatia. Aggina yù tádday nga mammaguray nga ipakimore ra. Á iniddagán na gapay yù dattál nayù pammagure ni Namarò ta dabbuno. Á pinataggâ ni Kusè yù nonò na, á en na kiniddaw kâ Pilatto yù baggi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Á napállâ si Pilatto ta pakarámak na ta natayin. Á gapu ta nabbábáng, inipágál na yù kapitán, ta iyabbû na nu natayin. ");
INSERT INTO att_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Á pakaginná na sù kagian nayù kapitán ta kurugán nga natayin, inipálâ na kâ Kusè yù baggi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Á giminátáng si Kusè ta puraw nga gámì. Á iniyutták na yù baggi ni Apu Kesu, á binungun na sù gámì nga kapággátáng na. Á pineddá na ta abbû, sù batu nga nakokkobán, á kinarebu na yù dakal nga batu sù tanam. ");
INSERT INTO att_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Á di Maria nga taga Maddala kâ Maria nga yená ri Kusè, nasingad da yù nangitanamán na kuna. ");
INSERT INTO att_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Á ta pappasá na Sabadu nga ággibannák da, minay di Maria nga taga Maddala, kári Saloma, kâ Maria nga yená ri Ime, á giminátáng ira ta bábbanguk nga nakkakerumá, tapè ed da denuán yù baggi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Á alippánnawák na Liggu, ta apállassáng na bilák, minay ira sù tanam. ");
INSERT INTO att_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pakalakalakák da paga sù dálan, nakkaká-abbû ira nga kud da, “Asinni yù mangikarebu ta batu nga ajjan ta abbû na tanam?” Ta mallakay yù batu. ");
INSERT INTO att_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Á pakerípâ da sù tanam, nasingad da ta nakarebu ngin yù batu, á aringin naserrán yù tanam. ");
INSERT INTO att_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Á pakáddè da ta tanam, simillung ira, á nasingad da ta jiwanán na lágum na tanam yù bagitolay nga magitubang, nga nabbarawási ta gámì nga puraw nga apaddu. Á pakasingad da kuna, nakaráring ira. ");
INSERT INTO att_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Á kinagi na nira, “Ari kayu maganássing. Ammù ta aleran naw si Apu Kesu nga taga Nasaret, nga nepátà ta kurù. Ngam awánin saw, ta naginnanolayin. Innan nawè yù nameddád da kuna. ");
INSERT INTO att_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Á lubbè kayu laguk, ta en naw bì kagian kári Eduru ánna yù ira káruán nga tudduán na ta mapolu si Apu Kesu ánnè nira nga umay túrin ta purubinsia na Galilia. Yáyù pakasinganád da kuna, nga kunnay sù kinagi na ngaw nira,” kun nayù bagitolay sù ira bábbay. ");
INSERT INTO att_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Á nánaw ira ta tanam, á nattálaw ira, ta ikáddagâ lâ yù pamippippik da ánna nerallà yù kapállâ da. Á awán bulubugá ta kinagi ra sù ira nerapunád da gapu ta ikássing da. ");
INSERT INTO att_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Á ta pannawák na Liggu, nga mapolu nga ággaw ta tangaligguán, kabalin ni Apu Kesu naginnanolay, nappasingan ta olu kâ Maria nga taga Maddala. Si Maria yù babay nga namalawanán na ta pitu nga anitu. ");
INSERT INTO att_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Á minay si Maria ta gián nayù ira kábulun ni Apu Kesu. Á gikulukuletán ira ta daddam da. Á kinagi na nira ta nasingan na si Apu. ");
INSERT INTO att_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngam pakaginná ra ta matolay má ngin si Apu Kesu, ánna nasingan ni Maria, arád da kinuruk. ");
INSERT INTO att_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Á manganánnuán, nappasingan si Apu Kesu sù duá nga sinudduán na ta pallakák da ta dálan nga umay ta agayyuán, ngam dumá yù paninganád da kuna. ");
INSERT INTO att_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Á nanoli yù ira duá ta Jerusalem, ta ed da kagian sù ira kábulud da yù ngámin nga nesimmu. Ngam arád da ira gapay kinuruk. ");
INSERT INTO att_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Á kabalin na yaw, limittuák si Apu Kesu nga mappasingan sù ira mapulu tádday nga sinudduán na ta pallalálláng da. Á gimmá na ira gapu ta pabbábáng da ánna kataggâ nayù nonò da, ta arád da garè kinuruk yù kinagi nayù ira nakasingan kuna ta kabalin na naginnanolay. ");
INSERT INTO att_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Á kinagi na laguk ni Apu Kesu nira, “E kayu mangilayalayâ sù napiá nga dámak sù ira ngámin nga tatolay ta ngámin nga lugár. ");
INSERT INTO att_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Á meyígù yù ira nga manguruk ánna marigù megapu sù ángnguruk da nikán, á mepattolay ira kâ Namarò ta áddè ta áddè. Ngam yù ira nga ari manguruk, mekanakanâ ira sù pamagikáru ni Namarò. ");
INSERT INTO att_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Á yù ira manguruk nikán, meyawâ nira yù pakáwayyá ra nga mamagaddátu ta makapállâ. Á mamalawán ira ta anitu megapu sù pakapangnguá nayù ngágak ku. Á magubobuk ira ta tanakuán nga ággubobuk nga arád da ammu. ");
INSERT INTO att_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Á nu mesimmuád da yù iráw nga maritá onu ajjan yù akáppatay sù inumad da, ari ira manganni. Á nu támmitad da yù ira máttakì, mammapiá ira.” ");
INSERT INTO att_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Á kabalin ni Apu Kesu nakiubobuk nira, nálâ ni Namarò ta lángì, á nagitubang ta jiwanán ni Namarò, nga ággitubangán nayù maráyaw. ");
INSERT INTO att_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Á nánaw laguk yù ira sinudduán ni Apu Kesu, á minay ira nga mangilayalayâ sù napiá nga dámak ta ngámin nga lugár. Á nangabbák si Apu Namarò nira, ta iniyawâ na nira yù pakáwayyá ra nga mamagaddátu ta makapállâ, tapè mepakánnámmu sù ira tatolay ta kurugán yù bilid da.");
INSERT INTO att_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mattúrákà nikaw nga kopuk ku, Don Topilu. Á aru yù ira tatolay nga nattúrâ ta meyannung sù ngámin nga pinalurò ni Namarò sù giám mi. ");
INSERT INTO att_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Á yù ira olu nga nakasingan sù nesimmu áddè ngaw pamegapu na, aggira yù mangipakánnámmu sù nasingad da, á mangilayalayâ ira sù bilin ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Á yáyù nga ginigiámmù ta napiá yù meyannung ta ngámin nga nesimmu, ta napiá ta urè nu itúrâ ku gapay nikaw, Don Topilu. Á pattutuppangak ku ta napiá yù ngámin nga itúrâ ku, ");
INSERT INTO att_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tapè kánnámmuám mu nu kukurugán yù neparámak nikaw. ");
INSERT INTO att_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ta keggá na ngaw ni Patul Erodo nga mammaguray ta Judiya, ajjan yù pári nga Kudio nga mangngágan ta Sakariâ, nga nepulù sù ira kábulun na nga pári nga mangngágan ta Kábulun ni Abiya megapu sù ngaw Abiya. Á yù atáwa ni Sakariâ si Elisabet, nga ginaká nayù ngaw Aron, nga olu nga pári. ");
INSERT INTO att_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Á napiá di Elisabet kâ Sakariâ ta ánningan ni Namarò. Á matunung yù panuppál da sù ngámin nga taddán ni Namarò ánna yù tunung na, á awán ta kapaliwatád da. ");
INSERT INTO att_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngam awán ira ta anâ, gapu ta nabbalá si Elisabet, á bakabákà ánna lakalákay iren. ");
INSERT INTO att_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Á jimittál yù passerbi di Sakariâ ánna yù ira kábulun na nga pári ta arubáng ni Namarò sù mangilin nga kapilliá. ");
INSERT INTO att_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Á nabbubúnù ira ta kun na kustombare ra, tapè ammu ra nu asinni yù manuggi ta bábbanguk. Á natullà si Sakariâ. Á simillung laguk sù mangilin nga kapilliá nga umay manuggi ta bábbanguk. ");
INSERT INTO att_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Á keggá ni Sakariâ ta unak na kapilliá, naggián ta lawán yù ira magaru nga tatolay nga makimállà. ");
INSERT INTO att_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Á panuggi ni Sakariâ ta bábbanguk sù mangilin nga kapilliá, nappasingan kuna yù daroban ni Namarò nga nanáddak sù jiwanán nayù ánnuggián. ");
INSERT INTO att_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pakasingan ni Sakariâ sù daroban, nakaráring. Á nerallà yù assing na. ");
INSERT INTO att_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Á kinagi nayù daroban kuna: “Sakariâ, ari ka maganássing, ta naginná ni Namarò yù ipakimállà mu. Á sangaw nu manganánnuán, mangáguk yù atáwam, á maganâ ta laláki. Ingágam mu ta Kuan. ");
INSERT INTO att_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Á ayatán ka sangaw sù anâ mu. Á aru yù ira tatolay nga mepagayáyâ sù keyanâ na. ");
INSERT INTO att_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Á makáwayyá yù anâ mu ta ánningan ni Namarò. Ari bulubugá mamissán, á mássiki lage na meyanâ, mepaggián kuna yù Ikararuá ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Á yáyù nga aru yù ira kábulun na nga ginaká ni Israel nga pabbabawian na ta liwâ da, megapu sù ángngituddu na, tapè manguruk ira kâ Namarò nga Yápu ra. ");
INSERT INTO att_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Á aggina yù mapolu nga umay, tapè ipakánnámmu na sù ira tatolay yù labbè nayù Mangiyígù. Á makáwayyá nga kunnay kâ Elias nga yù ngaw ábbilinán ni Namarò nga mamagaddátu. Á megapu sù pangituddu ni Kuan, mammapiá yù ángngiddù nayù ira giriámán sù ira ánâ da. Á yù ira ari manguruk kâ Namarò, ipakánnámmu na nira yù napiá, tapè manguruk ira gapay ánna mepaggittá yù nonò da ta nonò nayù ira manguruk. Yáyù akkuán na, tapè paránan na yù ira tatolay, tapè dán nga naparán ira sù labbè ni Apu.” Yáyù kinagi nayù daroban kâ Sakariâ. ");
INSERT INTO att_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Á kinagi ni Sakariâ sù daroban, “Kunnasi laguk pakánnámmù nu kuruk nga mesimmu yù kagiam mu? Ammum ta lakalákayakin, ánna bakabákà gapay yù atáwà.” ");
INSERT INTO att_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Á simibbák yù daroban, á kinagi na kuna, “Sikán si Gabriel nga daroban ni Namarò. Maggiánà ta arubáng ni Namarò. Á jinok nangà nga umay nikaw, tapè kagiak ku nikaw yawe napiá nga dámak. ");
INSERT INTO att_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Á gapu ta ari ka manguruk sù kinagì nikaw, yáyù nga magumal ka laguk. Á ari ka makobobuk áddè ta kapalurò nayù initabbâ nikaw. Á kuruk nga mesimmu yù ngámin nga kinagì sangaw nu duttál yù ággo na,” kun nayù daroban. ");
INSERT INTO att_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Á yù ira tatolay nga naggián sù lawán nayù mangilin nga kapilliá, nabayák ira nga magiddak sù pallawán ni Sakariâ. Á ninononò da nu anni yù inikabayák na. ");
INSERT INTO att_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Á manganánnuán, nallawán si Sakariâ sù kapilliá, á ari makobobuk. Á natákál yù ira tatolay ta ajjan yù nappasingan kuna ta keggá na sù unak nayù mangilin nga kapilliá. Á nassennias lâ nira, ánna nagumal lâ. ");
INSERT INTO att_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Á ta pappasá nayù ira ággaw nga passerbi ni Sakariâ sù mangilin nga kapilliá, nánaw nga nanoli sù gián na. ");
INSERT INTO att_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Á ari kuruk nga nabayák, á nangáguk si Elisabet nga atáwa na. Á yáyù nga naggián lâ ta bale ra ta límá nga bulán. ");
INSERT INTO att_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ta kinagi na, “Nepallà yù allà ni Apu nikán, ta inabbágán nangà, tapè aringà mappasirán sù ira kábuluk ku,” kun na. ");
INSERT INTO att_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Á sù mekánnam nga bulán nayù kabussì ni Elisabet, jinok ni Namarò si Gabriel nga daroban na ta umay ta ili na Nasaret sù purubinsia na Galilia. ");
INSERT INTO att_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ta inibilin ni Namarò kuna yù kagian na sù magingánay nga naggián tán, nga mangngágan ta Maria. Nakitarátu si Maria sù laláki nga mangngágan ta Kusè. Á si Kusè yù ginaká nayù ngaw Patul Dabid. ");
INSERT INTO att_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Á limibbè yù daroban sù gián ni Maria, á kinagi nayù daroban kuna, “Ye, Maria, nga meddù ni Apu! Mapagayáyâ ka, ta mepulù nikaw si Apu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Á pakaginná ni Maria sù kinagi na, nerallà yù bagal na. Á ninononò na nu anni yù kebalinán na. ");
INSERT INTO att_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Á kinagi nayù daroban kuna, “Ari ka maganássing, Maria, ta nepallà yù pangikállà ni Namarò nikaw. ");
INSERT INTO att_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Á yáyù nga mangáguk ka sangaw, á maganâ ka ta laláki nga ingágam mu ta Kesu. ");
INSERT INTO att_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aggina yù Kotunán, á ingágad da ta Anâ ni Namarò. Á pabbalinan ni Apu Namarò ta patul, nga táli nayù ngaw Patul Dabid nga naggaká kuna. ");
INSERT INTO att_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Á mammaguray ta áddè ta áddè sù ira ginaká ni Akup. Á awán ta áddè nayù pammagure na.” Yáyù kinagi nayù daroban kâ Maria. ");
INSERT INTO att_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Á kinagi ni Maria sù daroban, “Kunnasi yù kesimmu na yaw, ta awánà ta atáwa?” ");
INSERT INTO att_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Á kinagi nayù daroban kuna, “Umay nikaw yù Mangilin nga Ikararuá, ánna malirúmán naka nayù pakáwayyá ni Namarò nga mamagaddátu. Á yáyù nga mangilin yù assítay nga meyanâ, á ingágad da ta Mangilin nga Anâ ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Á mabussì gapay si Elisabet nga kanakanáyum mu, mássiki nu bakabákakin, nga kagiad da ta mabbalá. Á annam nga bulánin yù bussì na. Á maganâ sangaw ta laláki. ");
INSERT INTO att_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta awán ta arán na makuá ni Namarò,” kun nayù daroban. ");
INSERT INTO att_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Á kinagi ni Maria, “Sikán yù masserbi kâ Apu. Parè bì ta mesimmu nikán ngámin danniaw nga kinagim,” kun na. Á nánaw yù daroban. ");
INSERT INTO att_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Á ari nabayák, á naggagannuâ si Maria, á nánaw ta inapurán na nga umay ta ili sù puddul sù purubinsia na Judiya. ");
INSERT INTO att_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Á minay sù bale ri Sakariâ. Á kinagi ni Maria kâ Elisabet, “Et taka tullúnán, Elisabet. Kunnasi ka?” ");
INSERT INTO att_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pakaginná ni Elisabet sù ubobuk ni Maria, inikáddagâ na lâ nagguyu ta nasikan yù assítay sù sán na. Á dagarágâ nga minay yù Ikararuá ni Namarò kâ Elisabet. ");
INSERT INTO att_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Á yáyù nga iniyássikan ni Elisabet yù ngárál na, á kinagi na kâ Maria: “Mapagayáyâ ka ánnè sù ira ngámin nga bábbay, gapu ta piníli naka ni Namarò. Á mapagayáyâ gapay yù abbing nga iyanâ mu sangaw! ");
INSERT INTO att_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Á magayáyákà megapu sù ángngiparáyom nikán, ta em mà sinullúnán, sikaw nga yená nayù yápù! ");
INSERT INTO att_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Á ta pakaginnâ sù ubobuk mu, matagenà ku yù pagayáyâ nayù anâ ku, ta nasikan yù pagguyu na sù sák ku. ");
INSERT INTO att_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Á pagayáyatan na ka ni Namarò gapay, gapu ta panguruk mu ta palurotan ni Namarò yù ngámin nga kinagi na nikaw.” Yáyù kinagi ni Elisabet. ");
INSERT INTO att_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Á kinagi ni Maria, “Dayáwak ku si Apu Namarò, á nepallà yù paddáyò kuna. ");
INSERT INTO att_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Á ayatánà kâ Namarò, ta aggina yù mangiyígù nikán. ");
INSERT INTO att_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Á kemámmatán nangà, nga tumulù nga masserbi kuna. Á ta áddè kunangan ta áddè noka, iparámak nayù ira ngámin nga tatolay ta sikán yù piníli ni Namarò nga pagayáyatan na. ");
INSERT INTO att_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Si Namarò yù makáwayyá ta ngámin, á makapállâ yù kingnguá na megapu nikán. Aggina yù kotunán nga mangilin. ");
INSERT INTO att_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Á ikállà na yù ira ngámin nga tatolay nga makimoray kuna, yù ira ngaw olu nga tatolay ánna yù ira ginaká ra ta áddè noka. ");
INSERT INTO att_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ipasingan ni Namarò yù pakáwayyá na nga mamagaddátu, á pawwarawaratan na yù ira tatolay nga mappeddaráyaw, nga notun yù nonò da. ");
INSERT INTO att_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Irián na yù ira motun nga patul sù pammagure ra, á ipotun na yù ira kagukábán nga tumulù, tapè meparáyaw ira. ");
INSERT INTO att_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pakáppagan na ta magannagannuk nga napiá yù ira magáwák. Ngam yù ira maríku, papanáwan na ira nga awán bulubugá ta ipáno ra. ");
INSERT INTO att_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Abbágán na yù ira masserbi kuna, nga ginaká nayù ngaw Kákay Israel, ta arán na káttamán yù initabbá na, nga allà na nittam nga tatole na ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tuppálan na yù initabbá na ngaw kâ Kákay Abrakam ánna yù ira ngaw naggaká nittam, ta ikákkállà na ittam nga ginaká ni Kákay Abrakam ta áddè ta áddè.” Yáyù kinagi ni Maria sù paddáyo na kâ Apu Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Á naggián si Maria ta bale ni Elisabet ta tallu bulán. Á pappasá na tallu bulán, nánaw nga nanoli ta gián na. ");
INSERT INTO att_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Á jimittál yù paganâ ni Elisabet. Á laláki yù iyanâ na. ");
INSERT INTO att_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Á pakaginná nayù ira karúbá ra ánna kanakanáyud da ta meyannung sù makapállâ nga pinalurò ni Apu Namarò megapu kâ Elisabet, mepagayáyâ ira gapay nira. ");
INSERT INTO att_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Á sù mekawalu nga ággaw nayù abbing, naggagammung yù ira kábulud da ta bale ra, ta tuppálad da yù kustombare ra nga mangugì sù abbing. Á ingágad da nakuan ta Sakariâ, nga ngágan nayù yáma na. ");
INSERT INTO att_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngam kinagi nayù yená na, “Ari! Ari mangngágan ta Sakariâ, ngam si Kuan yù ngágan na.” ");
INSERT INTO att_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Á kinagi ra kuna, “Ngattá, ta awán gemma ta kanakanáyun naw nga mangngágan ta Kuan!” kud da. ");
INSERT INTO att_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Á sinenniasád da laguk yù yáma nayù abbing, ta iyabbû da nu anni yù ikáyâ na nga ingágan sù abbing. ");
INSERT INTO att_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Á kiniddo ni Sakariâ yù pattúratán na, á initúrâ na, “Kuan yù ngágan na.” Á napállâ ira ngámin. ");
INSERT INTO att_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Á kabalin ni Sakariâ nangitúrâ, dagarágâ nakobobuk, á naddáyaw kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Á yù ira ngámin nga karúbá ra, maganássing ira ánna nepallà yù kapállâ da. Á pinassamâ da yù dámak ta ngámin nga ili ta puddul na Judiya. ");
INSERT INTO att_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Á yù ira ngámin nga nakarámak, inipatattam da lâ ta nonò da yù narámak da ta meyannung sù abbing. Á kinagi ra, “Anni panò laguk yù pabbalinán nayù abbing?” kud da. Ta natákál da ta nepulù kuna yù pakáwayyá ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Á minay laguk yù Ikararuá ni Namarò kâ Sakariâ, nga yáma nayù abbing. Á nagubobuk si Sakariâ sù ipakagi nayù Mangilin nga Ikararuá kuna, á kinagi na: ");
INSERT INTO att_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayáwat tam si Apu Namarò nga pakimorayát tam, sittam nga ginaká nayù ngaw Kákay Israel, ta en na ittam sinullúnán ni Namarò, ta palubbángan na ittam tapè arán na ittam pagikaruan. ");
INSERT INTO att_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Á sinullà ni Namarò yù makáwayyá nga umay nittam mangiyígù. Aggina yù ginaká nayù ngaw Patul Dabid nga aripan ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yáyù inipakánnámmu ni Namarò gári, megapu sù ubobuk na nga inipakagi na ngaw sù ira mangilin nga ábbilinán na. ");
INSERT INTO att_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Initabbá ni Namarò ta iyígù na ittam, tapè arád da ittam aripanan nayù ira malussaw nittam. ");
INSERT INTO att_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Á palurotan ni Namarò yù initabbá na sù ira ngaw naggaká nittam. Arán na káttamán yù mangilin nga tarátu na nira nga meyannung sù allà na nittam. ");
INSERT INTO att_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Initabbá ni Namarò kâ Kákay Abrakam, nga yù ngaw naggaká nittam, ");
INSERT INTO att_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ta iyígù na ittam, á ilillì na ittam sù panangngal nayù ira malussaw nittam, tapè makapasserbi ittam kuna nga awán ta assing tam. ");
INSERT INTO att_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Á yawe yù ásserbi tam kâ Namarò, nu napiá yù ángnguruk tam kuna, ánna pareku nga matunung yù akkuát tam sù ira kábulut tam ta kággággaw nga keggá tam ta utun na dabbuno.” ");
INSERT INTO att_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Á kinagi na laguk ni Sakariâ sù anâ na, “Á sikaw, anâ ku, sangaw nu dumakal ka, sikaw yù ábbilinán ni Namarò, si Namarò nga Kotunán. Á mapolu ka nga umay, ta em mu iparámak yù ánge ni Apu, tapè dán nga naparán yù ira tatolay sù labbè na. ");
INSERT INTO att_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ipakánnámmum sù ira tatolay ta meyígù ira, megapu sù pamakomá ni Namarò ta liwâ da, tapè mesipà ira kuna. ");
INSERT INTO att_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Á nepallà nga allà ni Namarò nittam. Á doban na yù mangiyígù nga umay nittam nga naggapu ta lángì, nga mamannawák ta nonò na tolay nga kunnay ta lassáng na bilák, ");
INSERT INTO att_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tapè pannawagan na ittam ngámin nga kunnay nga naggián sù kallà, nga ikássing tam yù pate tam. Á ituddu na nittam yù napiá nga tuttulat tam, tapè mepagimammà ittam kâ Namarò.” Yáyù áddè nayù kinagi ni Sakariâ, nga inipakagi nayù Mangilin nga Ikararuá kuna. ");
INSERT INTO att_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Á similluâ si Kuan nga anâ ni Sakariâ, á napasigaggà yù ángnguruk na kâ Namarò. Á naggián ta kalállammatán ta áddè ta pappasingan na nga mangilayalayâ sù ira ginaká ni Israel. ");
INSERT INTO att_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Á ta kássíte ni Kuan, si Sisar Agusto yù kotunán nga mammaguray ta Roma. Á inibilin na sù ira ngámin nga tatolay ta ngámin nga lugár ta umay ira mappalistá ta ngágad da sù ili nayù ngaw ira naggaká nira. ");
INSERT INTO att_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yaw yù olu nga pappalistá nayù ira tatolay, ta keggá ni Kirinu nga gubinador ta Siria. ");
INSERT INTO att_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Á minay laguk nappalistá yù ira ngámin nga tatolay sù ili nayù ngaw ira naggaká nira. ");
INSERT INTO att_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A nánaw laguk di Kusè sù paggianád da ta Nasaret sù purubinsia na Galilia, á minay ira ta Betlekem sù purubinsia na Judiya, nga nakeyanatán na ngaw ni Patul Dabid, gapu ta di Kusè yù ginaká ni Patul Dabid. ");
INSERT INTO att_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Á minay ira nappalistá ta ngágad da tán, ta nepulù kâ Kusè si Maria nga nakitarátu kuna. Á nabussì si Maria. ");
INSERT INTO att_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Á keggá ra ta Betlekem, jimittál yù paganâ ni Maria. ");
INSERT INTO att_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Á gapu ta awán ta paggianád da sù áddagatán na álliuk megapu sù káru na tatolay, minay ira sù ággianán na ayám, á naganâ si Maria sù kaká nga anâ na nga laláki. Á inappitán na, á pineddá na ta lutung, nga ángngipayyád da ta ipamakád da ta ayám. ");
INSERT INTO att_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Á tán nga gabi ajjan yù ira mináppárák nga naggián ta kakáddapán nga aranni sù ili na Betlekem, nga matturá nga manaron sù ira karneru ra. ");
INSERT INTO att_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Á inikáddagâ na lâ nappasingan nira yù daroban ni Namarò. Á nanawagán ira sù dalingáráng ni Namarò. Á nerallà yù assing da. ");
INSERT INTO att_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Á kinagi nayù daroban sù ira mináppárák, “Ari kayu maganássing, ta minayà tapè ipakánnámmù nikayu yù napiá nga dámak. Á magayáyâ ngámin yù ira tatolay megapu kuna. ");
INSERT INTO att_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ta ajjan tán nga ili nayù ngaw Patul Dabid yù assítay nga kapángngiyanâ na kunangane, nga umay mangiyígù nikayu. Aggina yù sinullà ni Apu Namarò nga mammaguray. Aggina si Apu Kiristu nga Yápu tam! ");
INSERT INTO att_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Á yawe yù ánnákkilalán naw kuna. Masingan naw sangaw yù assítay nga náppitán nga nepeddá sù lutung,” kun nayù daroban. ");
INSERT INTO att_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Á kabalin na nakkagi nayù daroban karanniawe, dagarágâ nappasingan yù ira kábulun na nga naggapu ta lángì. Aru ira, á nakkansion ira nga naddáyaw kâ Apu Namarò. Á kinagi ra, ");
INSERT INTO att_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Meparáyaw si Apu Namarò ta lángì. Á yù ira tatolay ta dabbuno nga mamagayáyâ kuna, á mapagimammà ira, tapè napiá yù ággigiád da!” ");
INSERT INTO att_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Á páno nayù ira daroban nga nanoli ta lángì, nakkaká-ubobuk yù ira mináppárák, á kinagi ra, “Et tamin tuke ta Betlekem, ta et tam innan yù assítay nga inipakánnámmu ni Apu Namarò nittam,” kud da. ");
INSERT INTO att_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Á inapurád da laguk nga nánaw, ta ed da aleran yù abbing. Á naratang da di Maria kâ Kusè, á nasingad da yù assítay nga nagiddá sù lutung. ");
INSERT INTO att_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Á pakasingan nayù ira mináppárák sù assítay, inistoriá ra sù ira darakal na yù kinagi nayù daroban ni Namarò nira nga meyannung sù abbing. ");
INSERT INTO att_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Á napállâ yù ira ngámin nga nakaginná sù kinagi nayù ira mináppárák. ");
INSERT INTO att_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Á si Maria, pinatattam na ta nonò na yù ngámin nga naginná na, á yáyù ninononò na. ");
INSERT INTO att_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Á nánaw yù ira mináppárák, á nanoli ira sù gián nayù ira ayám da, nga maddáyaw kâ Namarò megapu sù ngámin nga nasingad da ánna naginná ra, ta napalurò yù ngámin nga kinagi nayù daroban nira. ");
INSERT INTO att_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Á sù mekawalu nga ággo nayù assítay, jimittál yù pangugì da kuna, á iningágad da ta Kesu, ta yáyù kinagi nayù daroban ni Namarò kâ Maria lage na kabussì na. ");
INSERT INTO att_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Á pappasá na appátapulu nga ággaw áddè sù paganâ ni Maria, jimittál yù ággaw nga panuppál da sù tunung ni Moyses nga meyannung sù pamakarenu ta babay nga naganâ. Á minay ira ta Jerusalem, ta umay ira sù mangilin nga kapilliá. Á iniyánge ra yù abbing, ta iyawâ da kâ Apu Namarò, tapè dumakal, ánna masserbi kuna. ");
INSERT INTO att_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ta ajjan yù netúrâ nga tunung ni Namarò sù ira ginaká ni Israel, nga kun na, “Ngámin yù ira mapolu nga meyanâ nga lálláki, meyawâ ira kâ Apu, tapè mangilin ira nga masserbi kuna.” ");
INSERT INTO att_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Á ajjan gapay nga netúrâ sù tunung ta iyánge nayù ira darakal na abbing gapay yù ipeyátáng da nga duá nga lummun onu duá nga ibbung na kalapáti. Á yáyù sinuppál di Maria kâ Kusè. ");
INSERT INTO att_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Á ajjan yù lakalákay nga taga Jerusalem nga mangngágan ta Simion. Napiá nga tolay si Simion, nga matunung yù panguruk na kâ Namarò, á mepulupulù kuna yù Mangilin nga Ikararuá. Á ta nabayák nagiddi-iddak ta pamalurò ni Apu sù initabbá na ngaw sù ira ginaká ni Israel, nga pangiyígù na nira. ");
INSERT INTO att_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Á inipakánnámmu nayù Mangilin nga Ikararuá kâ Simion ta ari matay ta áddè ta arán na pakasingan sù MakKiristu nga sinullà ni Apu Namarò ta mangiyígù nira. ");
INSERT INTO att_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Á iniyánge nayù Mangilin nga Ikararuá si Simion sù mangilin nga kapilliá. Á yáyù nga ajjan tán si Simion sù paddulò di Maria nga pangiyánge ra sù abbing, tapè tuppálad da yù tunung ni Namarò nga meyannung kuna. ");
INSERT INTO att_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Á pakasingan ni Simion sù abbing, sinubbâ na kâ Maria nga binállo na. Á jináyo na si Namarò, á kinagi na, ");
INSERT INTO att_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apu Namarò, ikállà mà, nga aripam mu, á anugutam mu ta matayakin, ta nakáppagakin, gapu ta pinalurò mu ngin yù initabbám nikán. ");
INSERT INTO att_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ta nasingak ku ngin yù Mangiyígù nga naggapu nikaw, ");
INSERT INTO att_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nga sinullà mu ngaw ta umay, á aggina yù mepakánnámmu sù ira ngámin makkakerumá nga tatolay. ");
INSERT INTO att_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Á kunnay sù nawák, aggina yù mamannawák ta nonò nayù ira ari Kudio, ta ipakánnámmu na nira yù ángngiyígù ni Namarò. Á yù ira tatolem nga ginaká ni Israel, meparáyaw ira megapu kuna.” Yáyù kinagi ni Simion, nga inipakánnámmu nayù Mangilin nga Ikararuá kuna. ");
INSERT INTO att_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Á yù ira darakal nayù abbing, napállâ ira sù kinagi ni Lákay Simion nga meyannung sù abbing. ");
INSERT INTO att_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Á nakimállà si Lákay Simion ta iddukan na ira ni Namarò. Á kinagi na gapay kâ Maria, “Yawe anâ mu yù sinullà ni Namarò. Á aru yù ira ginaká ni Israel nga meyawáwán megapu kuna, á aru gapay yù ira meyígù megapu kuna. Ta aggina yù pangurugán, ngam aru yù ira mangipuerá kuna. ");
INSERT INTO att_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Á yáyù nga mepalappâ yù nelímak nga nonò nayù ira tatolay. Á sikaw, mepallà yù daddam mu nga kunnay sù áddujjuk na nataram nga píká sù baggim,” kun ni Lákay Simion kâ Maria. ");
INSERT INTO att_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Á ajjan yù bakabákà, nga ábbilinán ni Namarò nga mangngágan ta Ana, nga anâ ni Panuel, á yù ngaw Lákay Aser yù naggaká kuna. Á áddè sù kamagingáne na, pitu ragun yù pattádde na sù atáwa na lage na nabálu. ");
INSERT INTO att_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Á nabálu paga, nga walupulu ta appâ yù dagun na. Á ta kággággaw minay sù mangilin nga kapilliá, tapè makimoray kâ Namarò ánna makimállà kuna ta ággaw ánna gabi. Á nu káruán, linonán na yù pakkákán na. ");
INSERT INTO att_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Á pakasingan ni Bákò Ana kári Maria, jimikkì nira. Á naddáyaw si Bákò Ana kâ Namarò, á kinagi na yù meyannung sù abbing, nga iddanamán nayù ira ngámin nga taga Jerusalem ta mamalubbáng sù ira ngámin nga ginaká ni Israel. ");
INSERT INTO att_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Á kabalid da nattuppál di Maria sù ngámin nga netúrâ nga tunung ni Namarò nga meyannung sù naganâ ánna yù mapolu nga anâ na, á nanoli ira ta Nasaret, nga ili ra, sù purubinsia na Galilia. ");
INSERT INTO att_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Á similluâ yù abbing, nga massikan ánna malannapán yù ammu na, á iniddù ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Á ajjan yù kustombare nayù ira darakal ni Apu Kesu nga manoli ta Jerusalem kádaragun, tapè makipiestá ira sù panaddamán nayù ira ginaká ni Israel sù pattalebák nayù daroban ni Namarò sù ira naggaká nira ta pamapáte na sù ira Egipto. ");
INSERT INTO att_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Á sù mapulu duá nga dagun ni Apu Kesu, nepulù sù ira darakal na sù ánge ra ta piestá ta kun na kustombare ra. ");
INSERT INTO att_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Á ta kabalin na piestá, nánaw di Maria ta manoli ira ta giád da. Ngam nabattáng yù abbing ta Jerusalem, á arád da nánnámmuán nayù ira darakal na. ");
INSERT INTO att_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kagiad da ta ajjan sù ira káruán nga nakipiestá nga mepattoli nira. Á nallakalakák ira ta tangatangággaw. Á sù pagammâ da, inala-alek da sù ira kanakanáyud da ánna kákkopud da nga nepulupulù nira. ");
INSERT INTO att_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngam arád da nálek. Á sù tádday ággaw, nanoli yù ira darakal ni Apu Kesu ta Jerusalem, ta ed da aleran yù abbing tán. ");
INSERT INTO att_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Á sù mekatallu nga ággaw, naratang da sù mangilin nga kapilliá nga nepagitubang sù ira lállakalákay nga mamesturu, nga magginná sù kagiad da ánna magiyabbû nira. ");
INSERT INTO att_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Á yù ira ngámin nga nakaginná kuna, napállâ ira sù pakánnámmu na ánna yù napiá nga ákkitabbák na sù ira mamesturu. ");
INSERT INTO att_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Á pakasingan nayù ira darakal na kuna nga mepagitubang sù ira mamesturu, napállâ ira gapay. Á kinagi ni innò na kuna, “Anâ ku! Ngattá ta kunniaw kingnguám? Nepallà yù burung mi kâ amám nga magala-alek nikaw!” kun na. ");
INSERT INTO att_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Á kinagi na nira, “Ngattá ta ala-aleran nawà? Arán naw panò ammu ta máwák nga maggiánà sawe bale ni Ammò ku?” kun na. ");
INSERT INTO att_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngam arád da nánnámmuán yù kebalinán nayù kinagi na. ");
INSERT INTO att_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Á nepanoli si Apu Kesu sù ira darakal na sù giád da ta Nasaret, á napiá yù ángnguruk na nira. Á si innò na, pinatattam na ta nonò na yù ngámin nga kingnguá ni Kesu, nga ninononò na. ");
INSERT INTO att_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Á jiminakal yù abbing ánna nassikan yù baggi na ánna nalannapán ta napiá yù ammu na. Á si Apu Namarò ánna yù ira ngámin nga tatolay, ayatán ira kuna. ");
INSERT INTO att_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Á sù mekamapulu límá nga dagun nayù pammagure ni Sisar Tiberio ta Roma ánna ngámin nga dabbun, ajjan si Pontius Pilatto nga gubinador ta Judiya. Á si Erodo yù mammaguray sù purubinsia na Galilia. Á si Pilippi nga wagi ni Erodo yù mammaguray sù ira lugár na Ituria ánna Tarakonita. Á si Lisanio yù mammaguray ta Abilena. ");
INSERT INTO att_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Á di Annas kâ Kayapas yù ira kátannangán na pári. Á páppári ra, binilin ni Namarò si Kuan nga anâ ni Sakariâ ta paggián na ta kalállammatán. ");
INSERT INTO att_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Á pakálâ ni Kuan sù bilin ni Namarò, minay laguk ta ngámin nga lugár nga aranni sù danum na Jordan, nga mangilayalayâ sù ira ngámin nga tatolay ta mabbabáwi ira ánna likuránád da yù narákè nga akka-akkuád da, ánna makirigù ira laguk tapè mepasingan ta pakomán ni Namarò ira sù liwâ da. ");
INSERT INTO att_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ta pinalurò ni Kuan yù inipetúrâ ni Namarò ngaw kâ Isaya, nga kinagi na, “Ajjan yù makkatakatol ta kalállammatán. Yaw ikatakátol na: ‘Umayin si Apu! Paránan naw yù dálan na. Tunungan naw yù pallakarán na. ");
INSERT INTO att_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Á munitán naw yù ngámin nga likkong. Limpián naw yù ngámin nga puddul, tapè pareku yù pallakarán na. Tunungan naw yù dálan nga nakkillikillu, Á linísan naw yù ari nalínis, ");
INSERT INTO att_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","tapè ngámin nga tatolay ta dabbuno, masingad da laguk yù doban ni Namarò ta mangiyígù nira.’ ” Yáyù initúrâ ni Isaya ngaw. ");
INSERT INTO att_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Á pangilayalayâ ni Kuan, kitáru yù ira tatolay nga minay makirigù kuna, mássiki arád da inibabáwi yù liwâ da. Á yáyù nga kinagi ni Kuan nira, “Kunnay kayu ta ánâ na iráw! Asinni panò nakkagi nikayu ta marigù kayu, tapè ari kayu nakuan mekanakanâ sù pangukum ni Namarò? ");
INSERT INTO att_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nu kuruk nga nabbabáwi kayu, likuránán naw laguk yù narákè nga ággangnguá naw. Á arán naw kagian ta ari kayu mekanâ sù pamagikáru ni Namarò gapu ta si Lákay Abrakam yù naggaká nikayu. Ari yù kesipà naw sù ginaká ni Abrakam yù gapu na nga mesipà kayu nakuan kâ Namarò. Ta nu ikáyâ ni Namarò, ajjan yù awayyá na nga pabbalinan yawe ira batu ta ginaká ni Abrakam, nu makúráng ira nakuan. ");
INSERT INTO att_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Á naparánin yù ángngukum ni Namarò, nga kunnay ta wátay nga ipattukák ta káyu. Á ngámin nga káyu nga jikkù yù bungá ra, tukáran na ira ánna tuggian na ira,” kun ni Kuan. ");
INSERT INTO att_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Á pakaginná nayù ira tatolay ta meyannung sù pangukum ni Namarò, iniyabbû da kâ Kuan, “Anni laguk akkuám mi?” ");
INSERT INTO att_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Á kinagi na nira, “Yù tolay nga ajjan yù duá nga barawási na, iyawâ na laguk yù tádday sù awán ta barawási na. Á yù tolay nga egga kanan na, isipà na gapay yù awán ta kanan na,” kun na. ");
INSERT INTO att_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Á ajjan yù ira mináttuki ta buwì, nga minay gapay tapè makirigù ira kâ Kuan. Á iniyabbû da kuna, “Mesturu, anni laguk yù akkuám mi?” kud da. ");
INSERT INTO att_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Nu alawatan naw yù buwì, arán naw passobarán yù apan naw ánnè sù mepángngà,” kun na nira. ");
INSERT INTO att_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Á ajjan gapay tán yù ira suddálu. Á iniyabbû da kâ Kuan, “Á sikami nga suddálu, anni akkuám mi laguk?” kud da gapay. Á kinagi na nira, “Arán naw akkuán yù ira tatolay ánna arán naw ira iddâ nga ikeká tapè apan naw yù kuártu ra. Á magayáyâ kayu lâ sù sueldu naw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Á pakaginná nayù ira tatolay sù kinagi ni Kuan, ninononò da yù initabbá ni Namarò nga meyannung sù MakKiristu nga umay mammaguray. Á nakkaká-abbû ira, á kinagi ra, “Ari panò yawe tolay yù MakKiristu nga iddagát tam?” kud da. ");
INSERT INTO att_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Á yáyù nga kinagi ni Kuan nira ngámin, “Á sikán, jigutat takayu lâ ta danum. Ngam ajjanin sangaw yù umay nga makáwayyá ánnè nikán, á aringà mepángngà nga mangubbák ta kaddang na sapátù na. Á dumá yù ájjigù na nikayu, ta iyawâ na nikayu yù Ikararuá ni Namarò, nga kunnay ta ipanigù na nikayu. Ngam sikayu nga tumuttul ta liwâ, kunnay ta api yù ipanigù na nikayu, ta mekanakanâ kayu sù pangukum na. ");
INSERT INTO att_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Á labbè na, kunnay sù tolay nga mangisâ ta aggì, tapè pakappián na yù aggì sù ággianán na. Á kunnian yù keyarigán nayù ira tatolay, ta passisinnán ni Apu yù ira manguruk ánna yù ira ari manguruk. Á yù ira manguruk, meyígù ira. Ngam yù ira ari manguruk, nga kunnay ta attá nga nesinná sù aggì, metabbà ira sù api nga ari máddà ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Á aru paga yù initabarang ni Kuan sù ira tatolay sù pangilayalayâ na sù napiá nga dámak. Á jinudduák na ira ta pataliád da yù narákè nga ággangnguá ra. ");
INSERT INTO att_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Á kinagi ni Kuan gapay kâ Gubinador Erodo ta aru yù liwâ na, nepatalugáring ta ginubâ na sù wagi na si Erodia, nga asípák na. ");
INSERT INTO att_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngam nappanà nga nalliwâ si Erodo, ta linnapán na yù ngámin nga liwâ na, ta pinukù na si Kuan sù ábbalurán. ");
INSERT INTO att_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Á ta panigù ni Kuan sù ira tatolay, lage na napukù sù ábbalurán, jinigù na gapay si Apu Kesu. Á pakimállà ni Apu Kesu, nabbukâ yù lángì. ");
INSERT INTO att_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Á minay kuna yù Ikararuá ni Namarò, nga kun na lummun yù baggi na. Á nappáginná yù ngárál ni Namarò, á kinagi na, “Sikaw yù Anâ ku nga iddukak ku, á ayatánà nikaw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Á sù pamegapu ni Apu Kesu sù pangituddu na, tallupulungin yù dagun na. Á yù ira tatolay, kagiad da ta anâ ni Kusè. Á yù káke ni Apu Kesu si Keli. ");
INSERT INTO att_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Á yù ammò ni Keli si Matat, yù káke ni Keli si Libi, yù káke na ta siku si Melki, yù káke na ta dulung si Jannay, á yù káke na ta tumang si Kusè. ");
INSERT INTO att_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Á yù ammò ni Kusè si Matatias, yù káke ni Kusè si Amos, yù káke na ta siku si Nakum, yù káke na ta dulung si Esli, á yù káke na ta tumang si Naggay. ");
INSERT INTO att_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Á yù ammò ni Naggay si Mat, yù káke ni Naggay si Matatias, yù káke na ta siku si Semi, yù káke na ta dulung si Josek, á yù káke na ta tumang si Joda. ");
INSERT INTO att_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Á yù ammò ni Joda si Jowanan, yù káke ni Joda si Resa, yù káke na ta siku si Sirubbabel, yù káke na ta dulung si Salatiel, á yù káke na ta tumang si Neri. ");
INSERT INTO att_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Á yù ammò ni Neri si Melki, yù káke ni Neri si Addi, yù káke na ta siku si Kosam, yù káke na ta dulung si Elmadam, á yù káke na ta tumang si Er. ");
INSERT INTO att_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Á yù ammò ni Er si Josiuwa, yù káke ni Er si Elieser, yù káke na ta siku si Jorim, yù káke na ta dulung si Matat, á yù káke na ta tumang si Libi. ");
INSERT INTO att_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Á yù ammò ni Libi si Simion, yù káke ni Libi si Juda, yù káke na ta siku si Kusè, yù káke na ta dulung si Jonam, á yù káke na ta tumang si Eliakim. ");
INSERT INTO att_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Á yù ammò ni Eliakim si Meleya, yù káke ni Eliakim si Minna, yù káke na ta siku si Mattata, yù káke na ta dulung si Natan, á yù káke na ta tumang si Patul Dabid. ");
INSERT INTO att_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Á si Patul Dabid, yù ammò na si Jesse, á yù káke ni Patul Dabid si Obed, yù káke na ta siku si Boas, yù káke na ta dulung si Salmon, á yù káke na ta tumang si Nassion. ");
INSERT INTO att_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Á yù ammò ni Nassion si Amminadab, yù káke ni Nassion si Admin, yù káke na ta siku si Arni, yù káke na ta dulung si Esron, á yù káke na ta tumang si Peres, nga anâ ni Juda. ");
INSERT INTO att_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Á yù ammò ni Juda si Akup, yù káke na si Isak, yù káke na ta siku si Abrakam, yù káke na ta dulung si Tera, á yù káke na ta tumang si Nakor. ");
INSERT INTO att_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Á yù ammò ni Nakor si Seruk, yù káke ni Nakor si Ragaw, yù káke na ta siku si Peleg, yù káke na ta dulung si Eber, á yù káke na ta tumang si Selak. ");
INSERT INTO att_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Á yù ammò ni Selak si Kaynan, yù káke ni Selak si Arpaksad, yù káke na ta siku si Sem, yù káke na ta dulung si Noe, á yù káke na ta tumang si Lamek. ");
INSERT INTO att_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Á yù ammò ni Lamek si Lákay Matusala, yù káke ni Lamek si Enok, yù káke na ta siku si Jared, yù káke na ta dulung si Makalaliel, á yù káke na ta tumang si Kenan. ");
INSERT INTO att_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Á yù ammò ni Kenan si Enos, yù káke ni Kenan si Set, yù káke na ta siku si Kákay Adan. Á si Kákay Adan yù anâ ni Apu Namarò. ");
INSERT INTO att_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Á kabalin na nakirigù ni Apu Kesu kâ Kuan nga Minánnigù, nánaw sù danum na Jordan. Á nepulù kuna yù Ikararuá ni Namarò, á iniyánge na si Apu Kesu ta kalállammatán. ");
INSERT INTO att_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Á paggián na ta kalállammatán ta appátapulu nga ággaw, pinarubán ni Satanas nga liwatan. Á ari bulubugá kiminán ta paggián na tán. Á kabalin nayù appátapulu nga ággaw, nepallà yù bisin na. ");
INSERT INTO att_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Á kinagi ni Satanas kuna, “Nu kuruk nga anâ naka ni Namarò, pabbalinam mu yawe batu ta kanam.” ");
INSERT INTO att_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Á simibbák si Apu Kesu, á kinagi na, “Ajjan yù inipetúrâ ni Namarò nga kinagi na, ‘Ari lâ yù kanan yù ipakkatole na tolay,’ ” kun na. ");
INSERT INTO att_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Á iniyánge ni Satanas si Apu Kesu sù kátannangán nga puddul, á inipasingan na yù ira ngámin páppatulán ta dabbuno. ");
INSERT INTO att_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Á kinagi ni Satanas kuna, “Masingam mu danniawe ngámin nga nakástá nga páppatulán ta dabbuno. Á iyawâ ku nikaw yù pakáwayyám sù ira ngámin nga masingam mu. Ta yáyù gemma ngin yù neyawâ nikán, á makáwayyángà nga mangiyawâ sù gustù nga pangiyawatán. ");
INSERT INTO att_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Á sikaw laguk yù pangiyawaták ku nu mamalittúkak ka nga makimoray ta arubáng ku,” kun ni Satanas kâ Apu. ");
INSERT INTO att_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Á simibbák si Apu Kesu, á kinagi na, “Ajjan yù inipetúrâ ni Namarò nga kun na, ‘Si Apu Namarò lâ yù pakimorayám mu, á aggina lâ yù pangurugám mu!’ ” kun na. ");
INSERT INTO att_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Á iniyánge ni Satanas si Apu Kesu ta Jerusalem. Á initun na sù bubbungán nayù mangilin nga kapilliá. Á kinagi na kuna, “Nu kuruk nga anâ naka ni Namarò, makkassú ka laguk ta gowang. ");
INSERT INTO att_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta ajjan yù inipetúrâ ni Namarò nga kun na, ‘Ipataron naka ni Namarò sù ira daroban na.’ ");
INSERT INTO att_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Á ajjan gapay yù netúrâ nga kun na, ‘Tangngalád daka, tapè ari ka bulubugá manganni, á mássiki nu takkim, ari ira mabigarán.’ ” ");
INSERT INTO att_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngam simibbák si Apu Kesu, á kinagi na, “Wan á, ngam ajjan gapay yù netúrâ ta ‘Arám mu parubán si Apu nga Namarò nikaw,’ ” kun na. ");
INSERT INTO att_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Á kabalin ni Satanas namarubá kâ Apu Kesu ta ngámin nga makkakerumá nga mamalliwâ, á nánawán na lábbì. ");
INSERT INTO att_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Á nanoli laguk si Apu Kesu ta Galilia. Á ajjan kuna yù pakáwayyá nayù Mangilin nga Ikararuá ni Namarò. Á nassamâ yù dámak nga meyannung kuna sù ira ngámin nga páppatulán. ");
INSERT INTO att_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Á minay nangituddu sù ira kapilliá ra. Á ngámin ira nga tatolay, naddáyaw ira kuna. ");
INSERT INTO att_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Á nakáddè si Apu Kesu ta Nasaret nga naddakalán na. Á ta Sabadu nga ággibannák nayù ira Israel, minay má sù kapilliá ra, ta yáyù kustombare na. Á minay nanáddak ta arubáng da, ta inikáyâ da nga mabbibbik sù netúrâ nga ubobuk ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Á iniyawâ da kuna yù nalukù nga nangitúratán ni Isaya, nga yù ngaw ábbilinán ni Namarò. Á binullarán na, á nálek na yù gián nayù ikáyâ na bibbiran nira. Á yawe yù binibbik na: ");
INSERT INTO att_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yù Ikararuá ni Apu Namarò yù kapulupulù ku. Ta sinullà nangà ta ek ku ilayalayâ yù napiá nga dámak sù ira pobare. Á jinok nangà ta ek ku ilayalayâ sù ira nabáluk yù pamalubbáng ni Namarò nira. Á pagimmulagak ku yù ira buling ánna abbágák ku yù ira marigirigâ. ");
INSERT INTO att_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Á ek ku gapay ilayalayâ ta jimittálin yù pangikállà ni Apu sù ira tatolay.” ");
INSERT INTO att_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Á kabalin na nabbibbik ni Apu Kesu, nilukù na yù netúratán na bilin, á initoli na sù nangiyawâ kuna. Á nagitubang laguk, tapè ituddu na nira. Á yù ira ngámin nga tatolay tán, jinúlangád da. ");
INSERT INTO att_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Á kinagi na nira, “Ta pakaginná naw, napalurokin yù ubobuk ni Namarò nga binibbik ku.” ");
INSERT INTO att_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Á yù ira ngámin nga nakaginná, napállâ ira megapu sù napiá nga ubobuk na, á kinagi ra, “Kuruk nga napiá yù kagian na. Á ari panò aggina yù anâ ni Kusè?” kud da. ");
INSERT INTO att_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Á kinagi ni Apu Kesu nira, “Ikáyâ naw támma kagian nikán yù dán nga nakagi nayù ira lállakalákay, nga kun na, ‘Doktor, pammapiám mu yù baggim lápay.’ Yáyù kagian naw, ta arán naw garè kurugan. Á ikáyâ naw nu akkuák ku sawe giát tam yù kunnay sù narámak naw nga kingngikingnguâ ta Kapernium. ");
INSERT INTO att_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngam yawe yù kagiak ku nikayu, ta awán bulubugá ta ábbilinán ni Namarò nga pakimorayád da sù gián nga naddakalán na. ");
INSERT INTO att_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Á ta ángngarigán á, ammu naw yù ngaw nesimmu sù keggá na ngaw ni Elias nu ari nagurán ta tallu ragun ta gadduá, á nassamâ yù bisin ta ngámin nga dabbun. Á kuruk ta aru yù ira bálu nga kelián na. ");
INSERT INTO att_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngam arán na jinok ni Namarò sù ira kagittá na nga naggián ta Israel, ta jinok na lâ ta en na abbágán yù tádday nga bálu nga ari Kudio, nga naggián sù ili na Serepta ta lugár na Sidon. ");
INSERT INTO att_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Otturu, sù keggá na ngaw gapay ni Elisio nga ábbilinán ni Namarò, aru yù ira Kudio nga taga Israel nga naggoggong, á awán bulubugá ta pinammapiá ni Elisio nira, ngam si Naaman lâ nga taga Siria nga ari Kudio,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Á yù ira ngámin nga tatolay sù kapilliá, pakaginná ra sù kinagi ni Apu Kesu, napporay ira kuna. Á nerallà yù pore ra. ");
INSERT INTO att_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Á ikáddagâ da gimikkáng, á ginuggud da. Á pinalawád da ta ili, á iniyánge ra sù tappáng, tapè itabbà da nakuan. ");
INSERT INTO att_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngam nattalebák sù tangngá nayù ira magaru nga tatolay, á nánawán na ira. ");
INSERT INTO att_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Á nánaw laguk si Apu Kesu ta Nasaret, nga gimitták nga nanoli ta Kapernium sù purubinsia na Galilia gapay. Á ta Sabadu nga ággibannák da, minay sù kapilliá ra, tapè tudduán na ira. ");
INSERT INTO att_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Á napállâ ira ngámin sù ángngituddu na, á ta makáwayyá gemma yù ággubobuk na. ");
INSERT INTO att_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Á ajjan sù kapilliá yù nagunagán na anitu, á nakkalli, á kinagi na kâ Apu Kesu, ");
INSERT INTO att_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ye! Kesu nga taga Nasaret, anni iniyángem saw? Arám mu kami akkuán! Ammu taka. Sikaw yù mangilin nga naggapu kâ Namarò!” kun nayù anitu. ");
INSERT INTO att_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngam gimmá ni Apu Kesu yù anitu, á kinagi ni Apu kuna, “Magimammà ka, á pánawám mu yù tolay!” Á inilappák na laguk nayù anitu yù nagunagán na ta arubáng nayù ira tatolay, á nallawán kuna. Á mássiki natombá yù tolay, ngam ari nanganni. ");
INSERT INTO att_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Á napállâ yù ira nga naggagammung tán, á nakkaká-ubobuk ira, á kinagi ra, “Anni ngillâ yù pakáwayyá nayù ubobuk na! Gammán na yù ira anitu, á kurugad da ánna mallawán ira sù nagunagád da!” kud da. ");
INSERT INTO att_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Á nassamâ yù dámak nayù kingnguá na sù ngámin nga lugár nga aranni ta Kapernium. ");
INSERT INTO att_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Á kabalin ni Apu Kesu nangituddu nira, nánaw ta kapilliá nga minay sù bale ri Simon Eduru. Á nakkulikuk yù katugángán ni Simon, á inikomá ra bì kâ Apu Kesu megapu kuna, ta nerallà yù kulikuk na. ");
INSERT INTO att_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Á jimikkì si Apu Kesu sù babay nga nagiddá nga natakì, á gimmá na yù kulikuk na. Á dagarágâ nakkáppù yù babay, á gimikkáng laguk nga minay namagon, tapè mepakkákán ira. ");
INSERT INTO att_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Á lammak na bilák, iniyánge ra kâ Apu Kesu nayù ira tatolay yù ira nga máttakì ta makkakerumá nga tulágan. Á simmì na ira ngámin nga taggitádday, á pinammapiá na ira. ");
INSERT INTO att_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Á aru gapay yù ira anitu nga pinalawán na sù ira nagunagán. Á pallawád da, nakkalli ira, á kinagi ra, “Sikaw yù Anâ ni Namarò.” Ngam gimmá na ira ta arán na inanugù yù pakkagi ra, gapu ta ammu ra ta aggina yù MakKiristu nga sinullà ni Namarò ta mammaguray. ");
INSERT INTO att_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Á ta alippánnawák, nánaw si Apu Kesu nga minay ta nalappang nga lugár. Á ed da ala-aleran nayù ira tatolay. Pakálek da kuna, igaggak da nakuan ta arán na ira pánawán. ");
INSERT INTO att_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngam kinagi na nira, “Pánawát takayu, ta máwák nga ek ku ilayalayâ sù ira káruán na ili gapay yù napiá nga dámak nga meyannung sù pammagure ni Namarò, ta yáyù gemma yù gapu na jinok nangà ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Á minay laguk nangilayalayâ sù ira kapilliá nayù ira Kudio sù ira káruán nga ili ra. ");
INSERT INTO att_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Á sù tádday ággaw, minay si Apu Kesu sù karek na Bebay na Gennesaret. Á kitáru yù ira tatolay nga jimináddán kuna. Á maddarassil ira, tapè ginnád da yù bilin ni Namarò nga ilayalayâ na. ");
INSERT INTO att_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Á nasingan na yù duá nga barangay nga nereddè sù karagátán, nga nánawán nayù ira minággissirá, ta ed da baggawán yù ira tabukul da. ");
INSERT INTO att_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Á nappittà si Apu Kesu sù barange ni Simon, á kinagi na ta ipatangngá na yù barangay ta baddì. Á nagitubang si Apu Kesu nga nangituddu sù ira magaru nga tatolay nga naggián ta karagátán. ");
INSERT INTO att_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Á kabalin ni Apu Kesu nangituddu nira, kinagi na kâ Simon, “Patangngám mu bì tuke alaram, á itán naw yù ira sansoru tán, tapè makálâ kayu ta aru,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Á simibbák si Simon, á kinagi na, “Mesturu, tangatangagabi kami sù gabi nga nassansoru, á awán bulubugá ta nálâ mi. Ngam nu dobak kami, á itám mi laguk,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Á kabalid da nanuppál sù kinagi na, kitáru yù nálâ da, á maddaggun mapisil yù sansoru ra. ");
INSERT INTO att_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Á pinayápayád da yù ira kábulud da sù tádday nga barangay, ta ed da ira abbágán. Á minay ira gapay, á pinnu ra yù ira duá nga barangay ta sirá, áddè ta maddaggun ira lummak sù kárammà nayù kárgá ra. ");
INSERT INTO att_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Á pakasingan ni Simon Eduru sù nesimmu, namalittúkak ta arubáng ni Apu Kesu, á kinagi na kuna, “Pánawám mà, Apu, ta mappasiránà nikaw, ta minálliwákà garè!” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ta napállâ di Eduru ánna yù ira kábulun na sù káru nayù sirá nga nálâ da. ");
INSERT INTO att_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Á napállâ gapay di Ime kâ Kuan, nga ánâ ni Sebedo nga mepattarabáku kâ Simon sù tádday nga barangay. Á kinagi ni Apu Kesu kâ Simon, “Ari ka lâ maganássing. Aringin sirá yù tarabakuan naw, ta dobat takayu ta umay kayu mangapà ta tatolay nga umay metádday nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Á pakaginná ra sù kinagi na, inireddè da yù ira barange ra sù karagátán, á nánawád da ngámin tapè tuttulad da si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Á sù tádday ággaw, limibbè si Apu Kesu sù tádday nga ili. Á ajjan tán yù tolay nga naggoggong. Á pakasingan na kâ Apu, minay namalittúkak nga nallakak ta arubáng na, á inikomá na kuna, “Apu, nu ikállà mà, á pammapiám mà bì!” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Á sinonnâ ni Apu Kesu yù limá na, á sinámmì na yù naggoggong, á kinagi na, “Wan gemma. Mammapiá ken!” kun na. Á dagarágâ nammapiá yù tolay sù tulágan na. ");
INSERT INTO att_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Á sinaddánán ni Apu Kesu, á kinagi na kuna, “Arám mu iparámak yawe kingnguâ nikaw. Em mu lâ ipasingan yù baggim sù pári, tapè mánnámmuán na ta nári ngin yù tulágam mu. Á ipeyátáng mu kuna yù kinagi ni Moyses, nga netúrâ sù tunung na, tapè manguruk gapay yù ira tatolay ta kuruk nga nammapiá ken,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Á mássiki nu kinagi ni Apu Kesu sù tolay ta arán na iparámak yù nesimmu kuna, ngam nassamâ paga yù dámak nga meyannung sù kingnguá ni Apu Kesu, á kitáru yù ira jimibbuáng kuna, tapè maginná ra yù ituddu na ánna pammapián na ira gapay sù ira tulágad da. ");
INSERT INTO att_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Á nallillì sù ira tatolay, á minay nga kunnay sù kustombare na ta nalappang nga lugár nga makimállà kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Á sù tádday ággaw nga pangituddu ni Apu Kesu, aru yù ira tatolay nga magginná kuna. Á ajjan gapay yù ira Parisio ánna yù ira mangituddu sù tunung ni Moyses, nga naggapu ta ngámin nga ili sù ira purubinsia na Galilia ánna Judiya ánna yù ili na Jerusalem gapay. Á ajjan kâ Apu Kesu yù ámmagaddátu ni Namarò nga mamammapiá sù ira máttakì. ");
INSERT INTO att_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Á limibbè laguk yù ira mangisu sù tolay nga nabbannak yù baggi na. Á itallung da nakuan sù balay, tapè ipeddá ra ta arubáng ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngam arád da máwayyá gapu sù káru na tatolay. Á yáyù nga iniyunè da ta atà na balay, á binobbotád da yù atà. Á inilabbû da yù matakì nga inayáyud da nga pineddá sù arubáng ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Á pakasingan ni Apu Kesu sù kingnguá ra, natákál na yù ángngikatalà da kuna. Á kinagi na laguk sù matakì, “Kopun, napakomá ken sù ira liwiliwâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Á pakaginná ra sù kinagi ni Apu Kesu, nakkaká-anasâ yù ira mangituddu sù tunung ni Moyses ánna yù ira Parisio nga ajjan tán, á kinagi ra, “Tolay lâ yaw, á ngattá, ta igittá na yù baggi na kâ Namarò, ta asinni panò yù mamakomá ta liwâ nu ari lâ si Namarò? Ngattá, ta kunniaw yù ággubobuk na!” kud da. ");
INSERT INTO att_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ngam ammu ni Apu Kesu yù nononopad da, á simibbák nira, á kinagi na, “Ngattá, ta kunnian yù nononopan naw! ");
INSERT INTO att_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Anni panò yù ikáyâ naw nakuan nga kagiak ku sù tolay nga kun na natay yù baggi na? Ta mabbábáng kayu megapu sù kinagì kuna nga, ‘Napakomá ngin yù ira liwiliwâ mu.’ Á nu kuk ku lâ, ‘Gumikkáng ka, á mallakák ka,’ á manguruk kayu panò? ");
INSERT INTO att_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngam nu masingan naw ta nammapiá yawe tolay megapu sù ubobuk ku, á kánnámmuán naw laguk ta makáwayyángà gapay sawe dabbuno nga mamakomá ta liwâ, sikán nga Kaká na ngámin na tatolay,” kun ni Apu Kesu nira. Á kinagi na laguk ni Apu Kesu sù matakì, “Yáyù nga kagiak ku nikaw. Gumikkáng ka. Apam mu yù nagiddám mu, á lubbè ka ta balem,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Á dagarágâ gimikkáng yù matakì ta arubáng da ngámin. Á inâ na yù nagiddán na, á nánaw ta lubbè ta bale na, nga maddáyaw kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Á ngámin yù ira nakasingan, nerallà yù kapállâ da, á naddáyaw ira gapay kâ Namarò. Á kinagi ra, “Nasingat tam yù kuruk nga makapállâ ta ággawo!” kud da ngámin. ");
INSERT INTO att_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Á kabalin ni Apu Kesu namammapiá sù tolay nga nabbannak yù baggi na, nánaw laguk. Á pallakák na, nasingan na yù tolay nga mangngágan ta Libi, nga mináttuki ta buwì, nga nagitubang sù upisína na. Á kinagi ni Apu Kesu kuna, “Tuttulam mà,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Á dagarágâ gimikkáng si Libi, á nánawán na ngámin yù kukuá na tán, á siminuttul kuna. ");
INSERT INTO att_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Á inapà na laguk ni Libi yù ira kákkopun na ánna di Apu Kesu sù bale na, tapè mepallálláng ira kuna nga mangiparáyaw kâ Apu Kesu. Á aru yù ira kákkopun ni Libi nga minay, nepatalugáring sù ira kábulun na nga mináttuki ta buwì. ");
INSERT INTO att_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Á pakasingan nayù ira Parisio ánna yù ira kábulud da nga mangituddu sù tunung ni Moyses ta mepallálláng di Apu Kesu ta gián ni Libi, naddagaragim ira sù ira sinudduán ni Apu Kesu. Á kinagi ra nira, “Ngattá, ta mepallálláng kayu sù ira minálliwâ, nepatalugáring sù ira mináttuki ta buwì!” kud da nira. ");
INSERT INTO att_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Á si Apu Kesu yù simibbák nira, á kinagi na, “Ari yù ira napiá yù gawagawáyád da yù magáwák ta minángnguru, nu ari galâ yù ira máttakì. ");
INSERT INTO att_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Á yáyù iniyángè saw, ta ek ku pabbabawian yù ira minálliwâ. Aringà umay nga magágál sù ira nga kagiad da ta awán ta liwâ da, nu ari galâ ta umayà nga magágál sù ira nga ammu ra yù liwâ da, tapè mabbabáwi ira,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Á ajjan yù ira nga minay nagiyabbû kâ Apu Kesu, á kinagi ra, “Yù ira makituddu kâ Kuan nga Minánnigù, sigídá ra ngilinan yù ággaw nga ari ira kumán tapè makimállà ira kâ Apu Namarò. Á kunnian gapay yù kustombare nayù ira makikultu sù ira Parisio. Ngam yù ira makituddu nikaw, sigídá ira kumán ánna ámminum. Ngattá ta arád da tuttulan yù kustombare nga ari kumán?” kud da. ");
INSERT INTO att_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Á simibbák si Apu Kesu, á kinagi na, “Á ta ángngarigán, nu ajjan yù bodá, á yù ira álliuk nga makibodá, arád da gemma lonán yù pakkákád da, ta mepallalálláng ira ngámin sù nobiu. Á ajjanakin lâ paga nga kunnay sù nobiu sù ira makituddu nikán. Á yáyù nga kumán ira. ");
INSERT INTO att_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngam duttál yù ággaw nga kepánò nira, á yáyù nga lonád da laguk yù pakkákád da megapu sù daddam da nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Á kinagi na paga ni Apu Kesu yù tádday nga ángngarigán na, tapè ipakánnámmu na nira ta ari máyâ nu tuttulad da yù dán nga kustombare ra nu ikáyâ da nga tumuttul sù bagu nga ituddu na. Á kinagi na, “Awán ta magappíl ta bagu sù dán. Á nu kunnian yù akkuán na nakuan, mapittang yù dán, á mapisil, ta ari negittá gapay yù bagu sù dán. ");
INSERT INTO att_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Á ta kunnian gapay sù ira mappadday ta binaráyáng. Awán ta mangipay ta tabbuk na úbas sù dán nga ággianán na nga tabbì, marakè mabattâ sangaw yù tabbì. Á metabbà laguk yù tabbuk, á kengá lâ yù binaráyáng ánna yù ággianán na gapay. ");
INSERT INTO att_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ngam yawe yù máwák nga akkuád da. Ipe ra yù bagu nga tabbuk ta bagu nga ággianán na nga tabbì,” kun na. ");
INSERT INTO att_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Á kinagi na gapay yù meyannung sù tolay nga molang na patalián yù dán nga ággangnguá na, nga kun na, “Á ta ángngarigán, nu ajjan yù tolay nga mamissán, á nu napenám sù dán, arán na ikáyâ yù bagu, gapu ta kagian na ta napiá yù dán ánnè sù bagu.” ");
INSERT INTO att_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Á tádday nga Sabadu, nga ággibannák nayù ira Kudio, nallakák di Apu Kesu nga mattalebák ta ákkomanán. Á yù ira makituddu kuna, inurù da yù bungá na ammay, á binussilád da ta jinum da. ");
INSERT INTO att_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Á pakasingan nayù ira Parisio sù kingnguá ra, inibúyá ra ira, nga kud da, “Ngattá, ta magiurù kayu ta ammay sù ággaw nga ággibannák? Ta kunnay ta maggaták kayin, á arán na anugutan nayù tunung tam yù maggaták sù ággaw nga ággibannák,” kud da. ");
INSERT INTO att_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Á simibbák si Apu Kesu nira, á kinagi na, “Á arán naw panò paga binibbik yù kingnguá ra ngaw di Patul Dabid ánna yù ira kábulun na ta kabisid da? ");
INSERT INTO att_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Simillung si Dabid sù bale ni Namarò, á inâ na yù pán nga mangilin nga meyátáng kâ Apu, á kinán na, á iniyawâ na gapay sù ira kábulun na. Á kagian nayù tunung tam ta awán ta makáwayyá nga makkákán nu ari galâ yù ira pári. Ngam arán na liwâ ni Dabid, mássiki nu kinán na ánna inipamakán na sù ira kábulun na.” ");
INSERT INTO att_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Á kinagi ni Apu Kesu paga, “Sikán, nga Kaká na ngámin na tatolay, sikán yù makáwayyá nga makkagi sù mepángngà ánna mepugik nga akkuán na tolay sù ággaw nga ággibannák,” kun na. ");
INSERT INTO att_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Á sù tádday nga Sabadu, nga ággibannák, minay si Apu Kesu sù kapilliá na Kudio, tapè mangituddu. Á ajjan tán yù tolay nga nassesseng yù limá na nga jiwanán, nga arán na masonnâ. ");
INSERT INTO att_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Á yù ira Parisio ánna yù ira mangituddu sù tunung ni Moyses, sinissimmurád da si Apu Kesu, tapè masingad da nu mamammapiá sù ággaw nga ággibannák, ta ikáyâ da nga ikeká. ");
INSERT INTO att_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngam ammu ni Apu Kesu yù nonopad da. Á kinagi na sù tolay nga nassesseng limá na, “Kopun, e ka bì manáddak sawe arubáng mi,” kun na. Á gimikkáng yù laláki nga minay nanáddak sù gián ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Á keggá nayù tolay nga nassesseng limá na ta arubáng da, kinagi na laguk ni Apu Kesu sù ira tatolay, “Ajjan bì iyabbû ku nikayu. Anni yù anugutan nayù tunung nga akkuát tam sù ággaw nga ággibannák? Abbágát tam yù ira kábulut tam, onu akkuát tam ira? Anni yù kustu nga akkuát tam? Yù panole tam ta tolay onu pamapáte tam?” kun na. ");
INSERT INTO att_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Á iningan na yù ira ngámin nga ari makkituk. Á kinagi na laguk sù tolay nga nassesseng yù limá na, “Sonnatám mu yù limám,” kun na. Á sinonnâ na. Á ta panonnâ na kuna, dagarágâ nammapiá ngin. ");
INSERT INTO att_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngam yù ira Parisio ánna yù ira mangituddu sù tunung, nepallà yù pore ra kâ Apu Kesu, á nakkaká-ubobuk ira nu anni yù akkuád da kuna. ");
INSERT INTO att_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pappasá na yaw, giminon si Apu Kesu ta puddul, tapè umay makimállà kâ Namarò. Á tangatangagabi nga nakimállà tán. ");
INSERT INTO att_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Á ta alippánnawák, inagálán na yù ira makituddu kuna, á sinullà na nira yù ira mapulu duá, nga iningágan na ta minángngilayalayâ. ");
INSERT INTO att_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aggira di Simon nga iningágan na ta Eduru, ánna yù wagi na nga si Andares, á di Ime kâ Kuan, di Pilippi kâ Bartolome, ");
INSERT INTO att_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","di Mattiu, kâ Tomâ, á si Ime nga tádday, nga anâ ni Alpio, ánna si Simon nga tádday nga abbúnad da ta Mengal sù ággubobuk da, ");
INSERT INTO att_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","á si Kudas, nga anâ ni Ime, ánna si Kudas Iskariote, nga nabbalin nga mappagápù kâ Apu Kesu sù ira Kudio nga nalussaw kuna. ");
INSERT INTO att_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kabalin ni Apu Kesu nanullà nira, minutù ira ngámin sù puddul nga minay ta aláwa nga lugár. Á ajjan nga naggagammung tán yù ira káruán nga makituddu kuna ánna yù ira magaru gapay nga naggapu ta Jerusalem ánna káruán nga ili gapay sù purubinsia na Judiya, ánna yù ira nga naggapu sù duá nga ili ta aggik na bebay, nga Tiro ánna Sidon, tapè maginná ra yù ituddu na ánna iddagád da yù pamammapiá na sù tulágad da. ");
INSERT INTO att_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Á minay gapay yù ira buruburionán nayù ira anitu, á pinammapiá na ira gapay. ");
INSERT INTO att_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Á yù ira ngámin nga magaru, pinarubád da siniggek si Apu Kesu. Á ngámin yù ira naniggek kuna, nammapiá ira megapu sù ámmagaddátu na. ");
INSERT INTO att_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Á nallipay si Apu Kesu sù ira makituddu kuna, á kinagi na nira, “Napiá yù ággián naw, sikayu nga tumulù nga magáwák! Ta mapagayáyâ kayu sangaw, gapu ta mesipà kayu sù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Napiá yù ággián naw, sikayu nga makkaragâ nga makituddu nikán ánna manuppál sù ipakuá ni Namarò nikayu! Mapagayáyâ kayu sangaw, gapu ta pakáppagan na kayu sangaw ni Namarò, nga kunnay sù mabisin, nga mappálâ ta kanan na. Á napiá yù ággián naw, sikayu nga maraddam nga makkulè! Ta pagayáyatan na kayu sangaw ni Namarò, á maggagálà kayu. ");
INSERT INTO att_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Napiá yù ággián naw, nu malussaw yù ira tatolay nikayu, ánna manakì ira nikayu ánna iluddè da kayu, ánna paraparáketad da kayu megapu sù pangikatalà naw ánna panuttul naw nikán nga Kaká na ngámin na tatolay, ta mapagayáyâ kayu sangaw. ");
INSERT INTO att_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Naggittá yù ira manigirigâ nikayu sù ira ngaw naggaká nira, ta yáyù gapay yù kingnguá ra ngaw sù ira ngaw ábbilinán ni Namarò. Á nu kunnian yù akkuád da nikayu, paguráyán naw. Magayáyâ kayu laguk sù dattál nayù ággaw nga panigirigâ da nikayu. Ayatán kayu lâ nga kunnay ta mattatála megapu sù ayâ na, ta aru yù napiá nga bálà naw nga pinakappián ni Namarò ta lángì, nga málâ naw sangaw nu lubbè kayu tán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Á kinagi na paga, “Ngam sikayu nga maríku. Bay e! Makállállà kayu, ta ikatalà naw lâ yù karíku naw, nga ari gemma mannanáyun. Nálâ nawin yù napiá nga ikáyâ naw ánna yù napiá nga ággián naw sawe dabbuno, á yáyù áddè na. ");
INSERT INTO att_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Bay e! Makállállà kayu, sikayu nga sigídá makákkáppagin, ta kagian naw ta napiá kayu ánna awán ta máwák naw. Ta kunnay kayu sangaw ta mabisin, gapu ta yáyù pagáddekán nayù pagayáyâ naw. Bay e! Makállállà kayu, sikayu nga sigídá maggagálà kunangan, ta kagian naw ta napiá kayu nga awán bulubugá ta ikaburung naw. Maburung kayu sangaw ta liwâ naw, á mepallà sangaw yù daddam naw ánna pakkulukulè naw, gapu ta linonán naw yù awayyá naw nga mabbabáwi. ");
INSERT INTO att_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Bay e! Makállállà kayu lâ nu dayáwad da kayu nayù ira ngámin nga tatolay, gapu ta kunnian gapay yù paddáyo nayù ira ngaw naggaká nikayu sù ira ngaw mattá-ábbilinán nga nakkagi ta naggapu kâ Namarò yù bilid da, ngam ari kuruk, ta nassirisiri ira.” ");
INSERT INTO att_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Á kinagi ni Apu Kesu paga, “Ngam sikayu nga magginná sù kagiak ku, iddukan naw yù ira makiramá nikayu. Á ikállà naw yù ira malussaw nikayu. ");
INSERT INTO att_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kiddawan naw kâ Namarò yù allà na sù ira mangigagek nikayu, tapè pakomán ni Apu ira. Á makimállà kayu megapu sù ira manigirigâ nikayu. ");
INSERT INTO att_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Á nu ajjan yù tolay nga mallappák nikayu, ari kayu mabbálà, mássiki nu palapalingngian na kayu. Á nu ajjan yù maggubâ ta gámì naw, paguráyán naw lâ. Iyawâ naw paga yù barawási naw kuna gapay nu apan na paga. ");
INSERT INTO att_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iddán naw yù ira ngámin nga makkiddaw nikayu. Á nu ajjan yù mangâ ta kukuá naw, paguráyán naw nu arán na itoli. ");
INSERT INTO att_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Á yù napiá nga ikáyâ naw nga akkuán nayù ira kábbulun naw nikayu, yáyù lâ akkuán naw nira. ");
INSERT INTO att_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Á nu yù ira lâ nga mangiddù nikayu yù iddukan naw, bálatan na kayu panò ni Namarò? Ari gemma, ta mássiki yù ira nga mangnguá ta narákè, iddukad da gapay yù ira mangiddù nira. ");
INSERT INTO att_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Á kunnian gapay, nu yù ira lâ nga mangabbák nikayu yù abbágán naw, bálatan na kayu panò ni Namarò? Ari gemma, ta mássiki yù ira minálliwâ, kunnian gapay yù akkuád da. ");
INSERT INTO att_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Á nu yù ira lâ nga ammu ra nga mappagá yù pagatukán naw, dayáwan na kayu panò ni Namarò? Ari gemma, ta mássiki yù ira minálliwâ, makkakápagatù ira gapay sù ira nga ammu ra mappagá. ");
INSERT INTO att_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Ngam sikayu, máwák naw iddukan yù ira ngámin nga kábulun naw, mássiki yù ira malussaw nikayu, ánna ikállà naw ira. Á mappagatù kayu sù ira ngámin nga makkiddaw, mássiki yù ira nga arád da máwayyá nga itoli nikayu. Á nu kunnian yù akkuán naw, dakal yù bálà naw ta lángì. Á mabbáli kayu ta ánâ ni Apu Namarò nga Kotunán, gapu ta kunnian gapay yù akkuán na. Ta ikákkállà na yù ira narákè gapay ánna yù ira ari mabbalabálà kuna. ");
INSERT INTO att_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Párigán naw laguk si Namarò nga Yáma naw, á mangikállà kayu ta kunnay kuna, ta nepallà yù allà na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Á kinagi ni Apu Kesu, “Arán naw panunnután yù ira kábulun naw, ánna arán naw ira pagikaruan. Á si Namarò, arán na kayu panunnután, ánna arán na kayu pagikaruan. Pakomán naw yù ira kábulun naw, á pakomán na kayu laguk ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Á iyawâ naw sù ira kábulun naw yù ángngabbák naw nira. Á si Namarò, iyawâ na gapay nikayu yù napiá nga tappangan na, nga inittà na, nga pinnu na, nga pinallábi na nga arán na kinarì. Ta igittá ni Namarò yù tappang na sù tappang naw, á kunnay sù tappangan naw ta iyawâ naw sù ira kábulun naw, kunnian gapay yù tappangan ni Namarò nga iyawâ na nikayu.” ");
INSERT INTO att_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Á nagángngarigán si Apu Kesu, á kinagi na nira, “Nu ajjan yù buling, máwayyá na panò nga aggina yù mamulù sù kabbulun na nga buling? Ari gemma, ta mesawwâ ira duá ta abbû, gapu ta arád da masingan yù angayád da. ");
INSERT INTO att_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Á kunnian gapay sù makituddu, nga ari makáwayyá ánnè sù mesturu na. Ngam sangaw nu ammu na ngámin yù netuddu kuna, á megittá sù mangituddu kuna.” ");
INSERT INTO att_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Á nagángngarigán si Apu Kesu ta meyannung sù ira nga makkakagi sù ira kábulud da, á kinagi na, “Ngattá, ta ibúyá naw yù baddì nga apuling sù matá nayù kabbulun naw, ngam arán naw matagenà yù karakal nayù apuling nga ajjan ta matá naw! ");
INSERT INTO att_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Máwayyá naw panò nga kagian sù kabbulun naw, ‘Kopun, ápulingát taka,’ ngam ajjan ga yù dakal nga apuling ta matá naw? Áppè pípiá kayu! Napiá nu mapolu bì irián naw yù dakal nga apuling ta matá naw, tapè masingan naw ta napiá, á mári naw gapay yù baddì nga apuling sù matá nayù kabbulun naw.” ");
INSERT INTO att_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Á kinagi na paga ni Apu Kesu, “Yù napiá nga káyu, ari mabbungá ta jikkù. Á yù jikkù nga káyu, ari mabbungá ta napiá. ");
INSERT INTO att_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta tákkilalát tam yù káyu megapu sù bungá na. Á arát tam gemma málâ yù lubbán sù guráwing. Á arát tam gemma málâ yù bayábà sù baribbì. ");
INSERT INTO att_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Á kunnian gapay, napiá lâ yù akkuán nayù napiá nga tolay, nga naggapu ta napiá nga nonò na. Á narákè yù akkuán nayù narákè nga tolay nga naggapu ta narákè nga nonò na. Ta akkuán na tolay yù nononopan na, á yáyù gapay yù ubobugan na.” ");
INSERT INTO att_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Á kinagi na paga ni Apu Kesu, “Ngattá, ta kagian naw ta sikán yù yápu naw, ta ‘Apu,’ kun naw lâ nikán, ngam arán naw kurugan yù kagiak ku nikayu! ");
INSERT INTO att_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Á yù ira tatolay nga umay nikán, nga magginná sù kagiak ku ánna kurugad da, á kagiak ku nikayu yù keyarigád da. ");
INSERT INTO att_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kunnay ira ta nabbalay, nga alaram yù kinokkobán na. Á pakatunù na sù batu ta unak, yáyù pamatáddagán na sù kallang na. Á nu maddakal yù danum, malítù yù balay ánna masikan yù agì na danum. Ngam ari meburuk yù balay, gapu ta maláddá yù kapadde na. ");
INSERT INTO att_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngam yù tolay nga makaginná sù kagiak ku nga arán na kurugan, kunnay sù nabbalay, nga ababbaw yù inikokkok na sù kallang na, nga pinatáddak na lâ sù dabbun. Á paddakal nayù danum, nalítù yù dabbun, á nagagì yù danum sù gián nayù bale na. Á dagarágâ nakutukutáng yù balay nga neburuk, á kengá lâ.” ");
INSERT INTO att_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kabalin na nattuddu ni Apu Kesu sù ira tatolay nga nagginná, nánaw nga minay ta ili na Kapernium. ");
INSERT INTO att_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Á naggián tán yù ari Kudio, nga kapitán na suddálu nga taga Roma. Á ajjan kuna yù aripan na nga iddukan na ta napiá, nga magisassay matay. ");
INSERT INTO att_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Á pakarámak nayù kapitán ta ajjan tán si Apu Kesu, jinok na kuna yù ira karakalán na Kudio ta ed da agálán bì ta umay nga mamammapiá sù aripan na nga matakì. ");
INSERT INTO att_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Á dakkì da kâ Apu Kesu, inikomá ra kuna ta abbágán na yù kapitán. Á kinagi ra, “Apu, mássiki nu ari Kudio yù kapitán, kuruk nga napiá nga tolay, ");
INSERT INTO att_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ta nepallà yù allà na nittam nga Kudio, ta aggina yù nappapadday sù kapilliá tam,” kud da. ");
INSERT INTO att_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Á nepulù laguk si Apu Kesu nira. Á pakáranni di Apu Kesu sù bale nayù kapitán, jinok nayù kapitán yù ira kopun na ta ed da ira dapunan. Á kinagi ra kâ Apu Kesu, “Apu, paguráyám mu lâ kanu, ta mappasirán yù kapitán nikaw, nu umay ka ta bale na. ");
INSERT INTO att_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Á yáyù gapay yù gapu na nga arán na ángay panápun nikaw, ta ammu na nu magubobuk ka lâ, á mammapiá yù aripan na. ");
INSERT INTO att_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ta aggina gapay yù tolay nga manuppál sù kagian nayù maddok kuna. Á ajjan gapay yù ira suddálu na, nga manuppál sù kagian na. Nu kagian na sù tádday, ‘Mánaw ka,’ á dagarágâ mánaw. Á nu kagian na sù tanakuán, ‘E ka saw,’ á dagarágâ umay. Á nu ajjan yù kagian na sù aripan na, dagarágâ kurugan na. Á yáyù nga ammu na ta matuppál gemma yù kagiam mu,” kud da. ");
INSERT INTO att_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Á pakaginná ni Apu Kesu sù kinagi ra nga bilin nayù kapitán, napállâ sù ángngikatalà na kuna. Á nallipay sù ira aru nga tatolay nga mepulupulù kuna, á kinagi na nira, “Awán ta naratang ku nga mangikatalà nikán, mássiki sù ira ngámin kábulut tam nga ginaká ni Israel, nga kunnay sù kapitán yù ángngikatalà na nikán!” kun na. ");
INSERT INTO att_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Á panoli nayù ira jinok nayù kapitán ta bale na, nasingad da ta nammapiá ngin yù aripan na. ");
INSERT INTO att_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Á manganánnuán, minay si Apu Kesu ta ili na Nen. Á nepulupulù kuna yù ira makituddu kuna ánna yù ira magaru nga tatolay. ");
INSERT INTO att_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Á pakáranni ra sù áttallungán nayù ili, nerapunád da yù magaru nga tatolay nga naggapu ta ili nga umay mananam. Á yù natay yù laláki nga táttádday nga anâ na babay nga nabálu. Á nepulù nira gapay yù babay. ");
INSERT INTO att_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Á pakasingan ni Apu Kesu sù babay nga yená nayù natay, nepallà yù allà na kuna. Á kinagi na kuna, “Ari ka bì makkulè,” kun na. ");
INSERT INTO att_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Á minay si Apu Kesu sù ira nangáttu sù natay, á sinámmì na yù lungun na, tapè magginnà ira. Á pagginnà da, nagubobuk si Apu Kesu sù bagitolay nga natay, á kinagi na kuna, “Ilû, gumikkáng ka.” ");
INSERT INTO att_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Á dagarágâ nga gimikkáng yù bagitolay, nga magubobuk nira. Á initoli na laguk ni Apu Kesu sù yená na. ");
INSERT INTO att_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Á maganássing yù ira ngámin nga tatolay tán, á nerallà yù kapállâ da. Á naddáyaw ira kâ Apu Namarò, á kinagi ra, “Ajjan yù jimittál nittam nga makáwayyá nga ábbilinán ni Namarò,” kud da. Á kinagi ra gapay, “Napiá ta arán na ittam náttamán ni Namarò nga tatole na, ta en na ittam sinullúnán,” kud da. ");
INSERT INTO att_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Á paginnanole nayù bagitolay, nassamâ yù dámak nga meyannung sù kingnguá ni Apu Kesu ta ngámin nga ili sù purubinsia na Judiya ánna yù ira ngámin nga babálay. ");
INSERT INTO att_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Á narámak gapay ni Kuan nga Minánnigù, gapu ta minay yù ira sinudduán na sù gián na ta ábbalurán nga makkagi kuna. ");
INSERT INTO att_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Á yáyù nga inipágál ni Kuan yù duá nga sinudduán na. Á jinok na ira ta ed da iyabbû kâ Apu Kesu nu aggina yù patul nga initabbá ni Namarò nga umay mammaguray, onu ajjan lâ paga tanakuán nga iddagád da. ");
INSERT INTO att_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Á labbè nayù ira nabilin ni Kuan ta gián ni Apu Kesu, kinagi ra kuna, “Si Kuan nga Minánnigù yù naddok nikami, ta em mi iyabbû nikaw nu sikaw yù umay mammaguray, onu iddagám mi lâ paga yù tanakuán?” kud da. ");
INSERT INTO att_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Á negiddán ta keggá ra yù pangnguá ni Apu Kesu sù aru nga makapállâ, ta aru yù ira máttakì nga pinammapiá na ta tulágad da nga makkakerumá, á pinalawán na yù ira nattaliponak sù ira tatolay. Á aru gapay yù ira buling nga pinakasingan na. ");
INSERT INTO att_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Á simibbák si Apu Kesu laguk sù ira jinok ni Kuan, á kinagi na, “Manoli kayu kâ Kuan, ta en naw kagian kuna yù nasingan naw ánna naginná naw saw, ta makasinganin yù ira ngaw buling, á makalakák yù ira ngaw pilay. Nammapiá yù ira ngaw naggoggong, á makaginná ngin yù ira ngaw kitul. Naginnanolayin yù ira natay. Á nelayalayâ sù ira makállállà yù napiá nga dámak. ");
INSERT INTO att_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Á kagian naw gapay kuna ta magayáyâ yù tolay nga ari mabbábáng nga mangikatalà nikán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Á ta páno nayù ira binilin ni Kuan, kinagi ni Apu Kesu sù ira magaru nga tatolay yù meyannung kâ Kuan, nga kun na, “Anni panò yù en naw iningan ta kalállammatán? Ikáyâ naw panò masingan yù mimì nga mepayapayák ta paddák? ");
INSERT INTO att_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Á nu ari, anni laguk? En naw panò iningan yù tolay nga nabbísti ta nakástá? Ngam ari! Ta yù ira nabbísti ta nakástá, maggián ira ta palásiu na patul, nga awán bulubugá ta awágad da. ");
INSERT INTO att_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Á anni laguk yù kuruk nga en naw iningan? En naw panò iningan yù ábbilinán ni Namarò? Wan, á kuruk gemma! Ta si Kuan yù kotunán ánnè sù ira ngámin nga káruán nga ábbilinán. ");
INSERT INTO att_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aggina yù ubobugan ni Namarò sù inipetúrâ na ngaw nga kunniaw: ‘Yawe yù ábbilinák ku nga dobak ku ta mapolu ánnè nikaw, tapè ituddu na sù ira tatolay yù akkuád da nakuan, tapè dán nga naparán ira sù labbè mu.’ ");
INSERT INTO att_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Á kuruk yawe nga kagiak ku nikayu, nga awán ta tolay nga neyanâ sawe dabbuno nga napiá ánnè kâ Kuan. Ngam yù kagukábán nga tolay nga mesipà sù pammagure ni Namarò, aggina yù napiá ánnè kâ Kuan, megapu sù allà ni Namarò.” ");
INSERT INTO att_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Á yù magaru nga tatolay, mássiki yù ira minálliwâ, nepatalugáring sù ira magâ ta buwì nga mangilogò, nagayáyâ ira ngámin ta pakaginná ra sù pangituddu ni Kuan sù bilin ni Namarò. Á kinuruk da yù ubobuk ni Namarò nga kinagi ni Kuan, á yáyù nakirigù ira kuna. ");
INSERT INTO att_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngam yù ira Parisio ánna yù ira mangituddu sù tunung ni Moyses, inipuerá ra yù ure ni Namarò nira, á nanakì ira nakirigù kâ Kuan. ");
INSERT INTO att_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Á kinagi na paga ni Apu Kesu, “Á sikayu, anni laguk yù pangiyarigák ku nikayu? Anni yù keyarigán naw? ");
INSERT INTO att_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kunnay kayu sù ira ábbing nga makkukkul ta dápun. Á kagian nayù ira káruán sù ira kábulud da, ‘Naggássá kami, tapè mattála kayu nakuan, ngam manakì kayu. Á kinagi mi ta makkulè kami nga áppa-áppè mananam, ngam manakì kayu gapay!’ kud da. ");
INSERT INTO att_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Á sikayu yù kagittá ra, ta jimittál si Kuan, á manakì kayu kuna, á lillibatan naw, ta kagian naw ta nagunagán, gapu ta dumá yù kanan na sù kanan naw, ánna ari bulubugá mamissán. ");
INSERT INTO att_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Á minayà laguk, sikán nga Kaká na ngámin na tatolay, nga naporián kâ Kuan, nga mepallálláng nga mepámminum nikayu. Á manakì kayu gapay nikán. Á paliwatan nawà, ta kagian naw ta kitadullágà ánna magilellaw. Á paliwatan nawà gapay megapu ta pakikopuk ku sù ira minálliwâ, nepatalugáring sù ira mináttuki ta buwì. ");
INSERT INTO att_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Ngam yù ira nga manguruk nikán, ipakánnámmu ra ta napiá ánna masírik yù bilin ni Namarò, nga ituddù ánna ituddu ni Kuan, megapu sù napiá nga akka-akkuád da,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Á tádday ággaw, ajjan yù Parisio nga mangngágan ta Simon, á inapà na si Apu Kesu ta umay kumán ta bale ra. Á nepulù si Apu Kesu kuna nga minay kiminán ta bale ra. ");
INSERT INTO att_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Á ajjan gapay táne ili yù babay nga minákkikarallaw. Á pakarámak na ta ajjan si Apu Kesu nga mepallálláng sù bale nayù Parisio, á minay gapay sù bale nayù Parisio, tapè makimoray kâ Apu Kesu. Á inipulù na yù boteliá na nga nasiling nga napannu ta bábbanguk nga nanginá. ");
INSERT INTO att_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Á tallung na sù bale nayù Parisio, minay namalittúkak nga nakkulè sù gián ni Apu Kesu. Á napannátán sù kalulluá na yù takki ni Apu, á nabasá ira. Á inipappunâ na yù duddù na sù takki na. Á inummatán na yù takki na, megapu sù pakimore na kuna. Á binukatán na yù nasiling nga boteliá na, á jinenuán na yù takki na sù bábbanguk. ");
INSERT INTO att_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Á yù Parisio nga mangálliuk kâ Apu Kesu, pakasingan na sù kingnguá nayù babay, nakujjà yù mammang na, á nonotan na nga kun na, “Yawe tolay, nu kuruk nga ábbilinán ni Namarò, ammu na nakuan yù nonò na yawe babay nga maniggek kuna, á gimmá na nakuan,” kun na ta nonò na. ");
INSERT INTO att_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ngam si Apu Kesu, ammu na yù ninonò nayù Parisio, á yáyù kinagi na laguk kuna, “Simon, ajjan yù kagiak ku nikaw,” kun na. “Wan, Mesturu,” kun ni Simon kuna. ");
INSERT INTO att_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Á kinagi ni Apu Kesu kuna, “Ajjan yù duá nga naggagatù. Á límágatù yù gatù nayù tádday. Á yù mekaruá, singkuentá lâ yù gatù na. ");
INSERT INTO att_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Á gapu ta arád da máwayyá nga pagán yù gatù da, pinakomá nayù tolay ira. Á yawe iyabbû ku bì nikaw, Simon. Asinni sù ira duá yù egga nga nepallà nga ayâ na sù mappagatù?” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Á simibbák si Simon, á kinagi na, “Á yù tolay támma nga aru yù gatù na nga pinakomá na,” kun na. “Wan, kuruk!” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Á nallipay si Apu Kesu sù babay, á kinagi na paga kâ Simon, “Á kunnay gapay sawe babay, nga masingam mu. Ta inapà mà, á minayà. Ngam tallung ku sù balem, arám mà iniddán ta danum, tapè baggawák ku nakuan yù takkì ta kunnay ta kustombare tam. Ngam yawe babay, binaggawán na yù takkì sù kalulluá na, á pinunatán na sù duddù na. ");
INSERT INTO att_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Á sikaw, arám mà pakimorayán sù tallung ku ta balem. Ngam yawe babay, ummu-ummatán na yù takkì áddè ta tallung ku, ta áddè kunangan. ");
INSERT INTO att_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Á sikaw, arám mu jinenuán yù ulù ta kunnay sù kustombare tam. Ngam yawe babay, jinenuán na yù takkì sù nanginá nga bábbanguk. ");
INSERT INTO att_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Á yawe laguk yù kagiak ku nikaw, ta napakomángin yù ngámin nga liwâ na, á yáyù nga ipasingan na yù nepallà nga ayâ na nikán. Ngam yù tolay nga baddì lâ yù napakomá kuna, baddì lággapay yù ayâ na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Á kinagi ni Apu Kesu sù babay, “Kuruk nga napakomá ngin yù liwâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Á yù káruán nga tatolay nga mepallálláng nira, nakkaká-anasâ ira nga kud da, “Asinni panò yaw, nga kagian na ta pakomán na yù tolay ta liwâ na?” kud da. ");
INSERT INTO att_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Á kinagi na paga ni Apu Kesu sù babay, “Neyígù ken megapu sù ángngikatalà mu nikán. Lubbè ka ta balem nga mabannáyánin yù nonò mu,” kun na sù babay. ");
INSERT INTO att_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Á ari nabayák, á nánaw si Apu Kesu nga minay sù ira ili ánna babálay, nga nangilayalayâ sù napiá nga dámak nga meyannung sù pammagure ni Namarò. Á nepulupulù kuna yù ira mapulu duá nga tudduán na. ");
INSERT INTO att_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Á ajjan gapay nga nepulù kâ Apu Kesu yù ira bábbay nga pinammapiá na sù takì da ánna yù ira nga pinapáno na yù ira anitu nira. Ajjan si Maria, nga taga Maddala, nga nánawán na pitu nga anitu. ");
INSERT INTO att_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Á ajjan gapay si Juana nga atáwa ni Kosa. Si Kosa yù minánnaron sù ngámin nga kukuá ni Patul Erodo. Á ajjan si Susana ánna aru ira paga nga bábbay, nga mangisipà kári Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Á kitáru yù ira tatolay nga jimináddán kâ Apu Kesu, nga naggapu sù ira ngámin nga ili ánna babálay. Á paggagammung da, nagángngarigán si Apu Kesu, á kinagi na, ");
INSERT INTO att_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ajjan yù tolay, nga en na iniwárì yù bini sù komán na. Á pangiwárì na ta bini, natágâ yù baddì sù dálan, nga neguppuguppè, á kinán na mammánù. ");
INSERT INTO att_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Á ajjan gapay yù baddì nga natágâ ta kabatuán. Á pattubbu na, nalelay gapu ta namagá yù gián na. ");
INSERT INTO att_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Á ajjan paga yù baddì nga natágâ ta kasisítán. Á nattubbu gapay, ngam nepattubbu gapay kuna yù sî nga jiminakal, á narubbù yù gián na. ");
INSERT INTO att_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Á yù káruán na bini, natágâ sù napiá nga dabbun, á jiminakal áddè ta paddáwa na. Á napiá yù áddáwa na, nga kitáru yù bungá na.” Á kabalin ni Apu Kesu nagángngarigán, nikatol na nga kinagi, “Sikayu nga makaginná, magginná kayu ta napiá sù ubobuk ku!” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Á yù ira makituddu kâ Apu Kesu, iniyabbû da kuna, “Anni yù kebalinán nayù ángngarigám mu?” kud da. ");
INSERT INTO att_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Á simibbák si Apu Kesu nira, á kinagi na, “Sikayu lâ yù pangipakánnámmuák ku ta meyannung sù pammagure ni Namarò, nga nelímak áddè kunangan. Ngam iyángngarigák ku lâ sù ira káruán, gapu ta inni-innad da yù akkuák ku, ngam ari ira manguruk ta si Namarò yù naddok nikán. Á ginniginnád da yù bilin ni Namarò, ngam arád da manonò yù kebalinán na,” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Á kinagi na laguk ni Apu Kesu, “Á yawe yù kebalinán nayù ángngarigán nga kinagì. Yù bini yù keyarigán nayù bilin ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Á ta kunnay sù bini nga natágâ sù dálan, ajjan yù ira tatolay nga nakaginná sù bilin ni Namarò, ngam umay si Satanas mepassassábbarâ ta nonò da, marakè manguruk ira, tanu manguruk ira nakuan, á meyígù ira. ");
INSERT INTO att_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Á yù bini nga natágâ ta kabatuán yù kunnay sù ira tatolay nga magayáyâ nga manguruk sù bilin ni Namarò ta pakaginná ra kuna. Ngam ta kunnay sù bini nga ari makapaggamù ta kabatuán, awán bulubugá ta ipatattam da ta nonò da. Á yáyù nga mabì lâ yù panguruk da. Á sangaw nu umay yù jigâ da, pallikuránád da yù ángnguruk da. ");
INSERT INTO att_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Á yù bini nga natágâ ta kasisítán yù kunnay sù ira tatolay nga magginná sù bilin ni Namarò, ngam ari makatalluâ yù ángnguruk da. Á kunnay ira sù bini nga nakkurítal gapu ta narubbù yù gián na, ta megaggak yù ángnguruk da megapu sù ikaburung da nga ággiád da ta dabbuno ánna yù ukkuk da ta kukuá ra, ánna yù ngámin nga ala-alerad da nga ipagayáyâ da. ");
INSERT INTO att_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Á yù bini nga natágâ ta napiá nga dabbun, nga nabbungá ta napiá, yù kunnay sù ira tatolay nga magginná sù bilin ni Namarò, nga ipatattam da ta napiá sù nonò da. Á yáyù nga mássiki nu umay nira yù jigâ, napasigaggà yù ángnguruk da. Á kunnay sù bini nga napiá yù ábbungá na, napiá gapay yù akka-akkuád da megapu sù bilin ni Namarò nga inipatattam da ta nonò da.” ");
INSERT INTO att_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Á nagángngarigán paga si Apu Kesu, á kinagi na, “Egga panò yù tolay nga paggatangan na yù isingan, nga kallabán na ta palanggána onu ipe na ta silárung na katri? Awán gemma, ta ipotun na gemma sù ággianán na, tapè manawagán yù ira tatolay nga tullung ta balay. ");
INSERT INTO att_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Á kunnian gapay sù pangituddù ta meyannung sù pammagure ni Namarò, ta mepasingan sangaw yù ari ngaw netuddu, á mepakánnámmu sangaw yù ari ngaw nánnámmuán, tapè manawagán yù nonò naw. ");
INSERT INTO att_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tángngagan naw laguk yù ágginná naw sù bilin ni Namarò. Ta yù tolay nga manguruk sù bilin ni Namarò, malannapán sangaw yù ammu na. Ngam yù tolay nga ari manguruk sù bilin na, máttamán na sangaw yù kagian na nga kánnámmuán na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Á kabalin ni Apu Kesu nagubobuk, simippì di innò na ánna yù ira wáwwagi na, ngam arád da marakkitán gapu ta káru na tatolay. ");
INSERT INTO att_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Á yù tádday nga tolay, kinagi na kâ Apu Kesu, “Ajjan ta lawán di innò mu ánna yù ira wáwwagim, á ipágál da ka.” ");
INSERT INTO att_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Á kinagi ni Apu Kesu sù ira ngámin nga tatolay, “Ngámin yù ira nga magginná ánna manuppál sù bilin ni Namarò, aggira yù yenâ ánna yù ira wáwwagì.” ");
INSERT INTO att_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Á tádday ággaw, ajjan di Apu Kesu ta aggik na bebay. Á kinagi na sù ira makituddu kuna, “Et tamin, ta dumákì ittam ta dammáng,” kun na. Á nappittà ira ta barangay, á nánaw ira ta umay ira ta dammáng na bebay. ");
INSERT INTO att_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Á paddákì da, nakkaturuk si Apu Kesu. Á ikáddagâ lâ nappaddák ta nasikan. Á nasibi ira ta barangay, á naganássing yù ira sinudduán na, marakè lummak yù barangay nu mapannu ta danum. ");
INSERT INTO att_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Á ed da nilukák si Apu Kesu, á kinagi ra kuna, “Mesturu, awán ittamin!” kud da. Á dagarágâ gimikkáng, á gimmá na yù paddák ánna palung, á nagimammà yù paddák ánna palung. Á kitalínák yù bebay. ");
INSERT INTO att_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Á kinagi na sù ira makituddu kuna, “Anni má ta mabbábáng kayu sù ángngikatalà naw nikán?” kun na. Á naganássing ira, á nerallà yù kapállâ da. Á nakkaká-ubobuk ira, á kinagi ra, “Asinni yaw maggammá ta paddák ánna palung, nga tuppálan nayù paddák ánna yù palung yù kagian na!” kud da. ");
INSERT INTO att_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Á manganánnuán, nakáddè di Apu Kesu ánna yù ira sinudduán na ta lugár na Gerasa, ta dammáng na Galilia. ");
INSERT INTO att_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Á gatták di Apu Kesu sù barangay, jiminápun nira yù tolay nga taga ili, nga nagunagán na aru ira nga anitu. Á nabayágin nga nagili-ilongán, nga ari naggián ta bale ra, ngam maggián lâ ta kuebá sù katanamán. ");
INSERT INTO att_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Á pakasingan nayù nagunagán kâ Apu Kesu, naganássing nga nakkalli nga napalakak ta arubáng na. Á kinagi na, “Sikaw, Kesu, nga Anâ ni Namarò nga Kotunán, anni yù akkuám mu nikán? Ikállà mà bì, ta arám mà jigirigátan!” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Á yáyù kinagi nayù anitu kâ Apu, gapu ta sinaddánán nen ni Apu Kesu yù anitu ta mánaw sù tolay. Ta sigídá nga umay yù anitu kuna. Á yù ira kábulun nayù tolay, mássiki nu balurad da ta káwák yù limá na ánna yù takki na, ngam gattagattakan na lâ, á pakarerán nayù anitu nga umay ta kalállammatán. ");
INSERT INTO att_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Á iniyabbû na laguk ni Apu Kesu sù anitu, “Anni yù ngágam mu?” kun na. “Sikán si Jinibu,” kun na, ta aru yù ira anitu nga nattaliponak kuna. ");
INSERT INTO att_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Á inikomá ra kâ Apu Kesu ta arán na ira doban nga umay nga magikáru sù abbû nga awán ta áddè nayù kálaram na. ");
INSERT INTO att_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Á gapu ta ajjan tán aru nga bábi nga magárak sù garek na puddul, inikomá nayù anitu kâ Apu Kesu ta doban na ira ta umay ira tullung sù ira bábi. Á iniyanugù na nira. ");
INSERT INTO att_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Á dagarágâ nánawád da yù tolay, á simillung ira sù ira bábi, á gikarerán yù ira bábi nga minay nga nelappák ta bebay. Á nalaggabán ira ngámin. ");
INSERT INTO att_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Á pakasingan nayù ira mináppárák sù nesimmu sù ira bábi ra, nattálaw ira, á ed da iniparámak sù ira ili ánna babálay. ");
INSERT INTO att_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Á yù ira nakarámak, ed da pinasikkál. Á labbè da ta gián ni Apu Kesu, naratang da yù tolay nga nánawán nayù ira anitu, nga nagitubang ta taging ni Apu Kesu. Á nabbarawási ngin, nga nammapiá ngin yù nonò na. Á naganássing laguk yù ira tatolay megapu sù pakáwayyá ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Á yù ira nakasingan sù nesimmu, inistoriá ra sù ira tatolay yù pamammapiá ni Apu Kesu sù tolay. ");
INSERT INTO att_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Á yù ira ngámin nga tatolay nga taga Gerasa, inikomá ra kâ Apu Kesu ta mánaw nira, ta nerallà yù assing da kuna. Á gapu ta pamapáno ra kâ Apu Kesu, nappittà laguk ta barangay, ta mánaw nira. ");
INSERT INTO att_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Á yù tolay nga nammapiá nga nánawán nayù ira anitu, inikomá na kâ Apu Kesu ta mepulù kuna. Ngam pinapáno ni Apu Kesu, á kinagi na kuna, ");
INSERT INTO att_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Lubbè ka lâ ta balem, tapè kagiam mu sù ira kábulum mu yù pangikállà ni Namarò nikaw,” kun na. Á kinuruk nayù tolay, á en na inistoriá sù ira ngámin nga kelián na yù kingnguá ni Apu Kesu megapu kuna. Á nattoli di Apu Kesu ta dammáng na bebay nga naggapuád da. ");
INSERT INTO att_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Á labbè di Apu Kesu ta dammáng, nagayáyâ yù ira tatolay nga magiddi-iddak kuna. ");
INSERT INTO att_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Á minay yù tolay nga mangngágan ta Jeru. Aggina yù lakalákay nga kapatás ta kapilliá na Kudio. Á labbè na ta gián ni Apu Kesu, namalittúkak ta arubáng na, á inikomá na kuna ta umay lábbì ta bale ra, ");
INSERT INTO att_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ta magisassay matay yù táttádday nga anâ na, nga babay nga mapulu duá yù dagun na. Á nepulù si Apu Kesu kuna. Á pallakák da ta dálan, aru yù ira tatolay nga nepulupulù nira, á narassarassil ira sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Á ajjan yù babay nga mapparága ta mapulu duá nga dagun, nga pinunu na ngámin nga kukuá na ta ipappagá na sù ira manguru, ngam awán ta nakoru kuna. ");
INSERT INTO att_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Á jimikkì yù babay ta likuk ni Apu Kesu, á siniggek na yù kiddanán na barawási na, á dagarágâ nattukkâ yù papparága na. ");
INSERT INTO att_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Á kinagi ni Apu Kesu, “Asinni naniggek nikán?” kun na. Á yù ira tatolay, simibbák ira, nga kud da nga katággitádday, “Ari sikán,” kud da. Á kinagi ni Eduru kâ Apu, “Mesturu, marassarassil ittam gemma, á iyabbû mu paga?” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngam kinagi ni Apu Kesu, “Wan á, ngam ammù ta ajjan yù naniggek nikán, ta natákál ku ta ajjan yù nammapiá megapu sù pakáwayyâ,” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Á pakánnámmu nayù babay ta ari nelímak yù kingnguá na, minay nga mamippippik ta assing na, nga namalittúkak ta arubáng ni Apu Kesu. Á sù pakaginná nayù ira ngámin nga tatolay, kinagi nayù babay yù ipaniggek na kuna ánna yù pammapiá na nga naddagarágâ. ");
INSERT INTO att_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Á kinagi ni Apu Kesu kuna, “Anâ ku, nammapiá ken megapu sù ángngikatalà mu nikán. Lubbè ka ta balem nga mabannáyánin,” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Á sù arán na paga kabalin nga nagubobuk ni Apu Kesu sù kagian na, minay yù tolay nga naggapu sù bale ni Jeru, á kinagi na kâ Jeru, “Arám mu pattaláttanan yù Mesturu, ta natayin yù anâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Á pakaginná ni Apu Kesu ta natayin, kinagi na sù yáma na, “Ari ka lâ maburung sù kinagi na. Ikatalà mà lâ, á mammapiá sangaw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Á labbè di Apu Kesu sù balay, arán na pinatallung yù ira tatolay, ngam di Eduru lâ, kári Kuan, kâ Ime, kári Jeru nga magatáwa, nga darakal nayù abbing. ");
INSERT INTO att_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Á gikulukuletán yù ira ngámin nga naggián ta lawán megapu sù abbing. Ngam kinagi ni Apu Kesu nira, “Mattukkâ kayu nga makkulè, ta ari natay yù abbing! Nakkaturuk lâ!” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Á inuyoyungád da, gapu ta ammu ra ta natayin yù abbing. ");
INSERT INTO att_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngam sinangngalán ni Apu Kesu yù limá nayù abbing, á kinagi na kuna, “Abè, malukák ka!” kun na. ");
INSERT INTO att_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Á nattoli sù abbing yù inángà na, á dagarágâ gimikkáng. Á kinagi na laguk ni Apu Kesu sù ira darakal na ta pakanad da. ");
INSERT INTO att_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Á napállâ yù ira darakal na. Ngam sinaddánán ni Apu Kesu ira ta arád da bulubugá kakágian. ");
INSERT INTO att_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Á ta tádday ággaw, inagálán ni Apu Kesu yù ira mapulu duá nga sinudduán na, á iniddán na ira ta pakáwayyá ra nga mamapánaw sù ira nattaliponak ánna mamammapiá sù ira makkakerumá nga tulágan. ");
INSERT INTO att_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Á jinok na ira ta umay ira mangilayalayâ ta meyannung sù pammagure ni Namarò ánna mamammapiá ira sù ira máttakì. ");
INSERT INTO att_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Á kinagi na nira, “Á ta ánge naw, awán bulubugá ta ipulù naw, nga tagukuk naw, onu bungun naw, bálun naw, kuártu naw, onu pappatalián naw. ");
INSERT INTO att_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Á maguray lâ yù labbetán naw nga babálay, nu ajjan yù mamaddulò nikayu ta bale na, maggián kayu lâ tán áddè ta páno naw sù giád da. ");
INSERT INTO att_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Á nu arád da kayu paddulotan, panawán naw yù giád da, á pápparán naw yù káppù sù takki naw, nga sinniál ta mappalán kayu nira ta aggira lâ maguray nu manakì ira mesipà sù pammagure ni Namarò,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kabalin na nanabarang nira, nánaw ira nga nakkakáttuay, á minay ira sù ira ngámin nga babálay nga mangilayalayâ sù napiá nga dámak ánna mamammapiá sù ira máttakì. ");
INSERT INTO att_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Á si Gubinador Erodo yù mammaguray ta Galilia. Á narámak ni Erodo yù ngámin nga kingngikingnguá ri Apu Kesu. Á nakusukusu yù nonò na, ta maburuburung, ta ajjan yù ira nakkagi ta si Apu Kesu si Kuan nga Minánnigù, nga naginnanolayin kanu. ");
INSERT INTO att_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Á yù ira káruán, kagiad da ta naginnanolayin si Elias, nga yù ngaw ábbilinán ni Namarò. Á ajjan gapay yù ira nakkagi ta naginnanolayin yù ngaw ábbilinán ni Namarò nga tanakuán, nga ari si Elias. ");
INSERT INTO att_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngam kinagi ni Erodo, “Si Kuan yù inipaputul ku ngaw! Ngam asinni yane tolay nga narámak ku yù aru nga akka-akkuán na?” kun na. Á yáyù mapattû nga makasingan kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Á kabalid da nangilayalayâ nayù ira mapulu duá nga sinudduán ni Apu Kesu, nanoli ira kuna, á inistoriá ra kuna yù ngámin nga kingngikingnguá ra. Á nánaw laguk si Apu Kesu nga nepulù lâ sù ira sinudduán na, á aggira lâ nallillì nga minay ta kalállammatán nga nappángè ta ili na Betseda. ");
INSERT INTO att_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ngam pakarámak nayù ira magaru sù páno ra, jimináddán ira. Á inikállà na ira ni Apu Kesu, á inubobuk na nira yù meyannung sù pammagure ni Namarò, á pinammapiá na yù ira máttakì. ");
INSERT INTO att_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Á ta púgágin, minay kâ Apu Kesu yù ira mapulu duá nga sinudduán na. Á kinagi ra kuna, “Papanáwam mu yù ira tatolay, tapè umay ira tán nga babálay nga magalek ta kanad da ánna pagammátád da, ta nalappang nga lugár yaw,” kud da. ");
INSERT INTO att_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Á kinagi ni Apu Kesu nira, “Sikayu yù mamakán nira.” Á kinagi ra kuna, “Ajjan lillímá bullung lâ nga pán ánna dudduruá lâ nga sirá nikami. Nu dobak kami, umay kami gumátáng ta ipamakám mi nira,” kud da. ");
INSERT INTO att_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Á ajjan tán mággè límáribu nga lálláki ánna yù ira bábbay ánna yù ira ábbing paga. Á kinagi ni Apu Kesu sù ira sinudduán na, “Pagitubangan naw ira ta ággilímápulu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Á sinuppál da, á nagitubang ira ngámin. ");
INSERT INTO att_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Á inâ ni Apu Kesu yù límá bullung nga pán ánna duá nga sirá, á nattánguk ta lángì, nga makimállà kâ Namarò ta pamindision na ta kanan. Á paggaddagadduá na sù pán ánna sirá, iniyawâ na sù ira sinudduán na, ta isinisinek da sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Á kiminán ira ngámin, á nabattuk ira. Á yù ira sinudduán na, ed da inammung yù buná nayù ira nga kiminán, á pinnu ra yù mapulu duá nga lappi. ");
INSERT INTO att_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Á tádday nga ággaw, naguroray si Apu Kesu nga nakimállà. Á minay kuna yù ira sinudduán na. Á iniyabbû ni Apu Kesu nira, “Anni yù kagian nayù ira tatolay? Asinningà kanu nga kud da?” ");
INSERT INTO att_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Á simibbák ira, á kinagi ra, “Kagiad da ta sikaw si Kuan nga Minánnigù nga naginnanolayin, kanu. Á yù ira káruán, kagiad da ta sikaw yù tádday sù ira ngaw ábbilinán ni Namarò nga naginnanolayin, nepatalugáring kanu ta sikaw yù ngaw Elias,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Á kinagi na laguk nira, “Á sikayu? Anni yù kagian naw? Asinningà laguk?” kun na nira. Á simibbák si Eduru, á kinagi na, “Sikaw yù MakKiristu nga sinullà na ngaw ni Namarò ta mammaguray,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ngam pinappalán ni Apu Kesu ira ánna sinaddánán na ira ta arád da kakágian sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Á kinagi na nira, “Sikán nga Kaká na ngámin na tatolay, máwák nga attamák ku sangaw yù aru nga mesimmu nikán. Á yù ira giriámán, yù ira kátannangán nga pári, ánna yù ira mesturu ta tunung, manakì ira nikán. Á ipapapáte rangà sangaw. Ngam paginnanolayan nangà ni Namarò sù mekatallu nga ággaw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Á kinagi na laguk ni Apu Kesu sù ira ngámin nga tatolay, “Nu ajjan yù tolay nga ikáyâ na tumuttul nikán, arán na laguk tuppálan yù ikáyâ na baggi na, ngam tuppálan na galâ ta kággággaw yù ipakuâ kuna. Á mássiki nu umay kuna yù jigâ onu pate na, attamán na lâ megapu sù panguruk na nikán. Á tumuttul nikán laguk. Á ta kunnian mepárik nikán, gapu ta kunnian yù pangiyabága na ta kurù na ta kággággaw, á tuttulan nangà. ");
INSERT INTO att_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Á yù tolay nga iddukan na yù áttole na sawe dabbuno, lonán na yù awayyá na nga mesipà kâ Namarò. Ngam yù tolay nga paguráyán na yù ággián na ta dabbuno tapè tumuttul nikán, mássiki nu matay megapu sù ángnguruk na nikán, paginnanolayan ni Namarò, á mesipà kâ Namarò sù pammagurayán na ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Á egga panò yù pammakapián na tolay, nu ukkugan na yù ngámin nga napiá ta utun na dabbun, á matay nga mesinná kâ Namarò? Kengá lâ, ta awán ta serbi. ");
INSERT INTO att_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Á yù tolay nga mangipasirán nikán ánna manakì sù bilik ku, ipasirák ku gapay sangaw, sikán nga Kaká na ngámin na tatolay, nu manolingà nga meparáyaw nga maddalingáráng nga mepulù sù áddalingáráng nayù Yámà ánna yù áddalingáráng nayù ira mangilin nga daroban na. ");
INSERT INTO att_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Á kagiak ku nikayu ta ajjan ira saw nikayu nga ari matay lage ra masingan yù pamegapu nayù pammagure ni Namarò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Á pappasá na tangaligguán sù pagubobuk ni Apu Kesu karannian, inipulù ni Apu Kesu di Eduru kári Kuan kâ Ime sù ánge na ta puddul tapè makimállà tán. ");
INSERT INTO att_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Á pakimállà na, dagarágâ nabáli makatulang yù mammang na, á nappuraw nga naddalingáráng yù barawási na. ");
INSERT INTO att_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Á ikáddagâ lâ nappasingan di Moyses kâ Elias nga mepagubobuk kuna. ");
INSERT INTO att_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Á naddalingáráng ira gapay, á inubobuk da yù meyannung sù pate na sangaw ta Jerusalem, nga ipakuá ni Namarò kuna. ");
INSERT INTO att_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Á di Eduru, nakatummà ira. Á ikáddagâ da lâ nalukák, á nasingad da di Apu Kesu nga maddalingáráng ánna yù ira duá nga lálláki nga mepanáddak kuna. ");
INSERT INTO att_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Á paddaggud da mánaw di Moyses kâ Elias, á iddâ na lâ ni Eduru nagubobuk, á kinagi na kâ Apu Kesu, “Apu, napiá ta ajjan ittam saw! Á ipappadde mi sikayu laguk ta ággitádde naw nga amíngán kári Moyses kâ Elias,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Á pagubobuk ni Eduru karannian, ikáddagâ nga natábbunán ira ta kunam, á naganássing ira. ");
INSERT INTO att_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Á dagarágâ ajjan yù ngárál nga naggapu sù kunam, á kinagi na, “Yawe yù Anâ ku nga sinullà ku ta mammaguray ta ngámin nga dabbuno. Ginnán naw ta napiá yù kagian na!” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Á kabalin na nagubobuk, limimmà yù kunam, á nasingad da si Apu Kesu lâ nga nabattáng. Á nabayák nga arád da kakágian yù nasingad da sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Á sù tádday ággaw, minutù di Apu Kesu nga naggapu ta puddul, á aru yù ira tatolay nga jiminápun nira. ");
INSERT INTO att_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Á ikáddagâ nakkatol yù tádday nga tolay, á kinagi na kâ Apu Kesu, “Mesturu, ikállà kami bì, ta innam mu yawe anâ ku nga táttádday. ");
INSERT INTO att_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta ajjan yù mattaliponak kuna. Á pattaliponak na kuna, pabballiárán na. Á makkalli nga mabugubugâ yù simù na. Á mabayák nga maggián yù anitu, nga mággè ari mánaw kuna ta áddè ta sinalamán na. ");
INSERT INTO att_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Á nakimállakà sù ira sinudduám mu ta papanáwad da, ngam arád da nakuá,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Á kinagi na laguk ni Apu Kesu sù ira tatolay, “Innan nawè yawe ira tatolay nga awán bulubugá ta ángngikatalà da nikán! Anni yù ikataggâ nayù ulu naw! Nabayágakin nga naggián nikayu nga mangituddu. Kunnasi panò yù ággiyattam ku nikayu áddè ta arán nawà ikatalà?” kun na. Á kinagi na sù laláki, “Iyángem bì saw yù anâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Á pangituluk da kuna, initupâ nayù nattaliponak yù abbing, á pinabballiák na. Ngam gimmá ni Apu Kesu yù nattaliponak, á pinapáno na. Á nammapiá yù abbing, á inipálâ ni Apu Kesu sù yáma na. ");
INSERT INTO att_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Á yù ira ngámin nga nakasingan, napállâ ira sù pakáwayyá ni Namarò. Á kapállâ nayù ira ngámin nga tatolay sù pakasingad da ta kingngikingnguá ni Apu Kesu, á kinagi ni Apu Kesu sù ira sinudduán na, ");
INSERT INTO att_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ginnán naw ta napiá yaw nga kagiak ku nikayu, á patattaman naw ta nonò naw. Sangaw nu mabì lâ, gaputad dangà, sikán nga Kaká na ngámin na tatolay, á iyawâ dangà sù ira malussaw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngam arád da nánnámmuán nayù ira sinudduán na yù kinagi na, gapu ta nelímak nira tapè arád da matákál yù kebalinán na, á nappasirán ira nga mangiyabbû ta meyannung sù kinagi na. ");
INSERT INTO att_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Á sangaw, namegapu nga nakkakápereperang ta ubobuk yù ira sinudduán ni Apu Kesu, ta meyannung ta asinni nira yù kátannangán. ");
INSERT INTO att_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Á natákál ni Apu Kesu yù egga ta nonò da, á yáyù nga inâ na laguk yù baddì nga abbing nga pinatáddak na sù taging na. ");
INSERT INTO att_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Á kinagi na sù ira sinudduán na, “Nu iddukan naw yù tolay nga kunniaw nga abbing, megapu sù panguruk naw nikán, yáyù nga ángngipasingan naw gapay sù ángngiddù naw nikán ánna yù ángngiddù naw sù naddok nikán. Á yù tolay nga tumulù nikán nga kunnay sù abbing, aggina yù mebiláng ta kátannangán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Á kinagi na laguk ni Kuan kâ Apu Kesu, “Apu, nasingam mi yù tolay nga mamapánaw sù ira nattaliponak, á abbúnan na yù ngágam mu, á kinagi na ta sikaw kanu yù paggapuán nayù pakáwayyá na. Á gimmá mi gapu ta arán na ittam kapulupulù,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngam kinagi ni Apu Kesu nira, “Arán naw gammán. Ta yù tolay nga ari makikontará nittam, aggina yù koput tam nga mangabbák nittam.” ");
INSERT INTO att_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Á nu maddaggun makatunù yù ággo nayù kálâ ni Apu Kesu ta lángì, á pinataggâ na yù nonò na ta umay ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Á pinapolu na yù ira binilin na ta umay ira ta babálay sù purubinsia na Samaria, tapè iparád da yù pagammátád da, ta yáyù pallakarád da nga umay ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngam nabì lâ ira nattoli, ta manakì yù ira tatolay nga taga Samaria nga mamaddulò nira, gapu ta ammu ra ta umay ira ta Jerusalem, á arád da kurugan ta Jerusalem yù mepángngà nga ákkimorayán kâ Apu Namarò. ");
INSERT INTO att_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Á di Ime kâ Kuan, nga sinudduán na, pakánnámmu ra sù nesimmu, kinagi ra kuna, “Apu, dobak kami ta kiddawam mi kâ Namarò yù api nga naggapu ta lángì nga umay manuggi nira,” kud da. ");
INSERT INTO att_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngam nilipe ni Apu Kesu ira nga gimmá. ");
INSERT INTO att_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Á nattalebák ira nga minay sù tanakuán nga babálay. ");
INSERT INTO att_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Á pallakák da ta dálan, ajjan yù tolay nga nakkagi kâ Apu Kesu, “Apu, tumuttulà nikaw, mássiki nu sisaw angayám mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Á kinagi ni Apu Kesu kuna, “Wan á, ngam nonotam mu yawe, ta yù ira simaron nga ayám, ajjan yù ájjimonád da. Á yù ira mammánù, ajjan yù ággapunád da. Ngam sikán nga Kaká na ngámin na tatolay, awán bulubugá ta labbeták ku,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Á ajjan yù tádday nga tolay, á kinagi ni Apu Kesu kuna, “Tumuttul ka nikán.” Ngam kinagi nayù tolay kuna, “Wan, Apu, ngam ari lábbì, ta mapolu bì nga itanam ku yù yámà pángè ku tumuttul nikaw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Á kinagi ni Apu Kesu kuna, “Yù ira ari tumuttul nikán, kunnay ira sù natayin. Aggira yù mangitanam sù ira kábulud da nga natay. Ngam sikaw, umay ka mangilayalayâ ta meyannung sù pammagure ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Á yù tádday nga tolay, kinagi na, “Apu, tumuttulà nikaw, ngam anugutam mu ta lubbekà bì ta bale mi, ta ek ku bì kagian nira,” kun na. ");
INSERT INTO att_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Á kinagi ni Apu Kesu kuna, “Yù tolay nga mamegapu nga mattarabáku sù ipakuá ni Namarò kuna, arán na nakuan nonotan yù tanakuán, marakè melingun na yù ipakuá ni Namarò kuna. Ta yù tolay nga mangilingun, ari makapasserbi sù pammagure ni Namarò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Á pappasá na yaw, piníli ni Apu Kesu yù pitupulu duá nga tatolay. Á jinok na ira nga ággiruá, ta mapolu ira nga umay mangituddu ta ngámin nga ili nga angayán na sangaw. ");
INSERT INTO att_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Á kinagi na nira, “Aru yù ira tatolay nga tumuttul nikán nakuan nu ajjan yù umay mangapà nira. Á kunnay ira ta nalutu nga ammay nga magiddak ta kagaták na. Ngam nakúráng garè yù ira umay maggaták. Á yáyù makimállà kayu laguk kâ Apu Namarò nga makákkuá ta ammay, ta doban na yù ira nga umay maggaták. ");
INSERT INTO att_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","E kayin laguk. Ngam mappalán kayu, ta dobat takayu nga kunnay ta kígaw na karneru nga nasippà nga umay sù ira tatolay nga kunnay ta simaron nga ayám nga nalulluk. ");
INSERT INTO att_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Á ari kayu mangipulù ta bungun naw, onu kuártu, onu pappatalián naw nga sapátù. Umay kayu daretiu nga ari mattaláttán nga makiubobuk sù ira tatolay ta dálan. ");
INSERT INTO att_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Á maguray yù balay nga paddulotán naw, yawe yù mapolu nga kagian naw nira. ‘Parè bì ta iyawâ ni Namarò yù kuruk nga ággimammà na nikayu saw balay,’ kun naw nira. ");
INSERT INTO att_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Á nu ajjan yù ira nga mangalawâ sù kagian naw, nabbalin ta napiá yù ággiád da. Ngam nu manakì ira, paguráyán naw lâ, ta awán ta serbi nayù kagian naw nira. ");
INSERT INTO att_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Á nu ikáyâ da kayu alliugan, maggián kayu ta bale ra. Ari kayu magala-alì. Á kanan naw ánna inuman naw yù iyawâ da nikayu. Ta kuruk nga mepángngà nu alawatan na tolay yù táddán na ta pattarabáku na. ");
INSERT INTO att_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Á kunnian laguk yù akkuán naw ta ngámin nga ili nga labbetán naw. Nu ilágum da kayu, á kanan naw laguk yù iyawâ da nikayu. ");
INSERT INTO att_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Á pammapián naw yù ira máttakì. Á kagian naw nira, ‘Ipakánnámmu mi nikayu yù dattál nayù pammagure ni Namarò, tapè mesipà kayu kuna,’ kun naw nira. ");
INSERT INTO att_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Ngam nu makalabbè kayu sù ili nga ajjan yù ira tatolay nga manakì mamaddulò nikayu, paguráyán naw lâ. Mallakalakák kayu lâ sù ira kalsáda, á kagian naw sù ira tatolay, ");
INSERT INTO att_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pápparám mi yù káppù ta takki mi, nga sinniál ta minay kamingin nga mangipakánnámmu sù dattál nayù pammagure ni Namarò, ta apatam mi kayu nakuan nga umay mesipà sù pammagure na, ngam manakì kayu,’ kun naw nira. ");
INSERT INTO att_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Á kagiak ku nikayu ta sangaw nu duttál yù pangukum ni Namarò sù ira tatolay ta dabbuno, nerallà yù ámmagikáru na sù ira tatolay nga manakì nikayu táne lugár ánnè sù ámmagikáru na sù ira taga Sodoma, nga natay ngaw sù katuggi nayù ili ra megapu sù liwâ da!” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Á kinagi ni Apu Kesu paga yù daddam na sù ira Kudio nga nánawán na megapu sù panakì da kuna. “Bay e! Sikayu nga taga Korasin ánna taga Betseda, kábbi kayu gapu ta narámmà yù pamagikáru ni Namarò nikayu. Ta mássiki aru yù makapállâ nga kingnguâ sù lugár naw, ngam ari kayu manguruk. Makállállà kayu ánnè sù ira ngaw taga Tiro ánna taga Sidon nga ari Kudio. Tanu kingnguâ nakuan yù makapállâ sù ira ili na Tiro ánna Sidon, inalistuád da ngaw nakuan nga pinatalián yù barawási ra ta bayon, á nagitubang ira nakuan nga payyád da ta abu yù baggi ra, tapè ipasingad da yù daddam da ánna pabbabáwi ra ta liwâ da. ");
INSERT INTO att_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Á sangaw nu duttál yù pangukum ni Namarò sù ngámin ira nga tatolay, aláppaw yù pamagikáru na sù ira taga Tiro ánna taga Sidon ánnè sù pamagikáru na sù ira taga Korasin ánna taga Betseda. ");
INSERT INTO att_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Á sikayu gapay nga taga Kapernium nga mappeddaráyaw! Kagian naw ta mepotun kayu ta lángì nga meparáyaw. Ngam ari gemma! Ta gapu ta ari kayu mabbabáwi ta liwâ naw, mepettung kayu laguk sù impiernu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Á nagubobuk si Apu Kesu sù ira makituddu kuna, nga piníli na ta umay ira mangilayalayâ, á kinagi na nira, “Yù ira tatolay nga magginná sù kagian naw, sikán gapay yù kurugad da, gapu ta sikán yù nabbilin nikayu. Ngam yù ira nga manakì nikayu, á panakitád dangà gapay. Á nu manakì ira nikán, panakitád da gapay si Namarò nga naddok nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Á ta kabalid da nangilayalayâ nayù ira pitupulu duá nga jinok ni Apu Kesu sù ira ngámin nga ili ánna babálay, ayatán ira nga nanoli kâ Apu. Á kinagi ra kuna, “Apu, nasikan yù pakáwayyá mi nga iniyawâ mu nikami, ta mássiki yù ira nattaliponak, kinuruk da yù kinagi mi nira ta pamapáno mi nira megapu sù pannakabaggim,” kud da. ");
INSERT INTO att_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Á kinagi ni Apu Kesu nira, “Wan á, ta náppù si Satanas, á nasingak ku yù kepannâ na nga naggapu ta lángì nga kunnay sù kilâ. ");
INSERT INTO att_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Á iniyawâ ku nikayu yù pakáwayyá naw, tapè awán ta mesimmu nikayu, mássiki nu iguppè naw yù iráw onu asisípì. Á appútan naw yù pakáwayyá ni Satanas nga malussaw nikayu, á awán bulubugá ta manganni nikayu. ");
INSERT INTO att_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngam arán naw laguk ipagayáyâ yù pakawayyá naw nga mamapánaw sù ira nattaliponak. Ngam ipagayáyâ naw galâ yù kelistá nayù ira ngágan naw kâ Namarò ta lángì, gapu ta mepattolay kayu kâ Namarò ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Á kabalin na nagubobuk ni Apu Kesu nira, á pinagayáyâ na si Apu Kesu nayù Mangilin nga Ikararuá. Á nakimállà kâ Namarò, á kinagi na, “Ammò ku, sikaw yù Yápu ta lángì ánna dabbuno. Á dayáwat taka, ta inipakánnámmum yù bilim mu nga meyannung sù pammagurem sù ira matulù nga mangikatalà nikaw nga kunnay sù ira ábbing. Ngam inilímak mu sù ira masírik ánna yù ira naggigiámmu. Wan, Ammò, ta yáyù ikáyâ mu nga akkuán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Á kinagi ni Apu Kesu sù ira tatolay, “Inikatalà na nikán nayù Yámà yù pakáwayyâ sù ngámin nga egga. Á awán ta makánnámmu nu asinningà, nu ari lâ si Ammò Namarò. Á awán gapay ta makánnámmu nu asinni yù Yámà, nu ari lâ sikán nga Anâ na ánna aggira ngámin nga pangipakánnámmuák ku,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kabalin ni Apu Kesu nagubobuk sù ira tatolay, nallillì di Apu ánna yù ira sinudduán na, á kinagi na lâ nira, “Nepallà yù pangikállà ni Namarò nikayu, ta masingan naw yù akka-akkuák ku ánna maginná naw yù kagiak ku. ");
INSERT INTO att_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Á kagiak ku nikayu ta aru yù ira ngaw ábbilinán ni Namarò ánna yù ira ngaw papatul, nga kinaragatád da nga masingan yù masingan naw kunangane, ngam arád da nasingan. Á iniddanamád da nga maginná yù maginná naw kunangane, ngam arád da naginná,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Á ajjan yù tolay nga mesturu sù tunung ni Moyses, á en na pinarubán nga ilogò si Apu Kesu. Á iniyabbû na kâ Apu, “Mesturu, anni yù máwák ku nga akkuán, tapè málâ ku yù inángà nga awán ta áddè na?” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Á kinagi ni Apu Kesu kuna, “Anni yù netúrâ sù tunung ni Moyses? Anni yù kánnámmuám mu ta pabbibbik mu kuna?” ");
INSERT INTO att_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Á simibbák yù tolay, á kinagi na, “Máwák nga napasigaggà yù ángngiddù tam kâ Apu Namarò, tapè metádday yù nonò tam ta nonò na. Á akkuát tam yù napiá nga ipakuá na nittam. Á iddukat tam gapay yù ira kábulut tam ta kunnay sù ángngiddù tam ta baggi tam,” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Á kinagi ni Apu Kesu kuna, “Wan, kustu yù kinagim. Nu kurugam mu yian, mepattolay ka kâ Namarò ta áddè ta áddè,” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Á pakaginná nayù tolay sù kinagi ni Apu Kesu, ikáyâ na nga ipasingan ta matunung yù akka-akkuán na, tapè ari mepasiránán. Á yáyù nga iniyabbû na kâ Apu Kesu, “Asinni yù ira kábuluk ku nga iddukak ku nakuan?” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Á simibbák si Apu Kesu nga nagángngarigán, á kinagi na, “Ajjan yù tolay nga kagittá tam nga Kudio nga taga Jerusalem, nga minutù ta umay ta ili na Jeriku. Á pallakák na ta dálan, sinanabán nayù ira minákkokò. Á inâ da ngámin yù barawási na ánna kukuá na, á sinalamád da. Á nánawád da nga magisassay matayin. ");
INSERT INTO att_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Á manganánnuán, ajjan gapay yù pári nga nallakák tán nga dálan. Á pakasingan na sù tolay, nallillì, á sinalebarán na. ");
INSERT INTO att_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Á pappasá na yaw, ajjan má yù tádday nga tolay, nga minay tán. Aggina yù ginaká ni Libi, nga nasserbi sù mangilin nga kapilliá ta Jerusalem. Á pakasingan na sù tolay nga kingnguá ra, nattalebák gapay ta kunnay sù pári. ");
INSERT INTO att_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Á minay gapay yù tolay nga taga Samaria, nga ikalusso nayù ira Kudio nga taga Jerusalem. Á pakasingan na sù tolay, nerallà yù allà na kuna. ");
INSERT INTO att_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Á jimikkì kuna, á inuru na ta denu ánna binaráyáng yù bigibigák na, á binabbak na. Á pinakkabáyu na sù ayám na, á inituluk na sù ággammátán na tolay nga mattalebák, á sinaronán na ta gabi. ");
INSERT INTO att_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Á ta ággawin, iniyawâ nayù taga Samaria sù makákkuá ta ággammátán yù kuártu, á kinagi na kuna, ‘Taronám mu, á nu makúráng yù kuártu nga iniyawâ ku, pagák ku sangaw nu manolingà,’ kun na.” ");
INSERT INTO att_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Á ta kabalin ni Apu Kesu nagángngarigán, kinagi na sù tolay, “Á asinni ta urem sù tallu ira yù kuruk nga kabbulun nayù tolay nga sinalamád da?” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Á yù tolay nga nangikállà kuna,” kun nayù tolay nga masírik. Á kinagi ni Apu Kesu kuna, “Wan, á napiá nu kunniû gapay yù akkuám mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Á nánaw di Apu Kesu ánna yù ira sinudduán na. Á nakáddè ira sù tádday nga babálay. Á ajjan tán yù babay nga mangngágan ta Marta, á pinaddulò na ira ta bale na. ");
INSERT INTO att_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Á ajjan gapay yù urián na nga mangngágan ta Maria. Á nepaggitubang si Maria kâ Apu Kesu, tapè ginnán na yù ituddu na. ");
INSERT INTO att_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ngam si Marta, arán na matángngák yù ituddu ni Apu Kesu gapu ta aru yù paránan na. Á mabagal sù ikalángan na, á en na kinagi kâ Apu, “Apu, ikállà mà bì, ta innam mu yù wagì, ta pinaguráyán nangà. Á ajjanà lâ nga masserbi. Kagiam mu bì kuna ta abbágán nangà bì!” kun na. ");
INSERT INTO att_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Á kinagi ni Apu Kesu kuna, “Ey, Marta! Anni má ta mabagabagal ka? Anni yù ikaburung mu? ");
INSERT INTO att_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ta piníli ni Maria yù kapiánán, nga ari mepugik kuna,” kun ni Apu. ");
INSERT INTO att_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Á tádday ággaw nakimállà si Apu Kesu mángin. Kabalin na nakimállà, jimikkì kuna yù tádday nga sinudduán na, á kinagi na kuna, “Apu, ituddum bì nikami gapay yù ákkimállà mi ta kunnay ta pangituddu ni Kuan sù ira makituddu kuna.” ");
INSERT INTO att_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Á kinagi ni Apu Kesu nira, “Nu makimállà kayu, kunniaw yù kagian naw: ‘Ammò, parè lâ ta sikaw yù meparáyaw sù ira ngámin nga tatolay. Á parè lâ ta mabì nga duttál yù pammagurem ta dabbuno. ");
INSERT INTO att_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Á iyawâ mu nikami yù kanam mi ta kággággaw. ");
INSERT INTO att_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Á pakomák kami ta liwâ mi, ta pakomá mi gapay yù liwâ da nikami nayù ira ngámin nga ikáttole mi. Á ilillì kami lâ sù mamalliwâ nikami.’ ” ");
INSERT INTO att_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Á kinagi ni Apu Kesu gapay nira, “Á ta ángngarigán nu ajjan yù tádday nikayu nga umay ta bale nayù kopun na ta tangngá na gabi, á kagian na kuna, ‘Kopun, iddám mà bì ta ipamakák ku ta álliuk ku. ");
INSERT INTO att_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ta ajjan yù kopuk ku nga kalalabbè na lâ ta balè, á awán bulubugá ta ipamakák ku kuna!’ ");
INSERT INTO att_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Á ta ángngarigán nu itabbák nayù kopun na, nga kun na, ‘Arák kami bì sikkágan, ta nelitukin yù puertá, á nakkaturugin yù ira ánâ ku, á molangà gumikkáng nga mangiyawâ nikaw,’ kun na nakuan. ");
INSERT INTO att_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Á kagiak ku nikayu ta mássiki nu napiá yù ákkopud da, manakì nga gumikkáng nga mangiyawâ. Ngam mapuersá sangaw nga gumikkáng nga mangiyawâ sù ngámin nga awágan na, gapu ta ari mattukkâ nga makkiddaw kuna. ");
INSERT INTO att_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Á kunnian gapay nakuan nikayu sù pakimállà naw kâ Apu. Ari kayu mappasirán nga makimi-imállà kâ Namarò. Taddánát takayu ta kiddawan naw lâ kiddawan kuna yù awágan naw, tapè iyawâ na nikayu. Á magala-alek kayu, tapè málek naw, ánna makkatakatol kayu, tapè patallungan na kayu. ");
INSERT INTO att_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta yù ira ngámin nga makimállà kâ Apu, iddán na ira. Á yù ira ngámin nga magalek, málek da. Á patallungan ni Apu yù ira ngámin nga makkatol kuna. ");
INSERT INTO att_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Á sikayu nga egga anâ na, ta ángngarigán nu makkiddaw yù abbing ta sirá, iddán naw panò ta iráw? Ari gemma! ");
INSERT INTO att_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Á nu makkiddaw ta illuk, iddán naw panò ta asisípì? Ari gemma! ");
INSERT INTO att_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Á sikayu, mássiki nu narákè kayu, ammu naw mangiyawâ ta napiá sù ira ánâ naw. Á nepatalugáring kâ Yáma tam ta lángì, ta awán ta kárik piá nayù ángngiddù na nittam, á iyawâ na yù Mangilin nga Ikararuá na sù ira ngámin nga makkiddaw kuna.” ");
INSERT INTO att_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Á ajjan yù tolay nga umal megapu sù nattaliponak. Á pinapáno ni Apu Kesu yù anitu nga nagumal sù tolay. Á páno nayù anitu, nagubobuk yù ngaw nagumal, á nepallà yù kapállâ nayù ira tatolay. ");
INSERT INTO att_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngam yù ira káruán nga tatolay, kinagi ra, “Papanáwan na yù ira nattaliponak megapu sù pakáwayyá ni Satanas, nga abbúnat tam ta Belsebul, nga kátannangán nayù ira anitu,” kud da. ");
INSERT INTO att_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Á yù ira káruán nga tatolay, ari ira nanguruk sù pakáwayyá ni Apu Kesu, á yáyù nga inikomá ra kuna ta akkuán na paga yù makapállâ, tapè masingad da. ");
INSERT INTO att_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngam ammu ni Apu Kesu yù egga ta nonò da. Á kinagi na nira, “Á ta ángngarigán nu ajjan yù tangapáppatulán, nga maddaráma yù ira tatolay, á makkakátalamán ira sangaw. Onu ajjan yù tangapamiliá, nga maddaráma yù ira mawwawági ánna yù ira darakal da, á ari iren mattatádday, ta makkakátalamán ira gapay. ");
INSERT INTO att_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Á yáyù nga ammu tam ta ari máyâ nu papanáwan ni Satanas yù ira anitu nga masserbi kuna, ta nu kunnian yù akkuán na nakuan, makkakákontará ira, á makkakátalamán ira gapay sangaw. Ngam kagian naw ta papanáwak ku yù ira nattaliponak megapu sù pakáwayyá ni Satanas. Kuruk panò? Ari gemma kuruk. ");
INSERT INTO att_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Á ta ángngarigán nu si Satanas nakuan yù mangiyawâ nikán sù pakáwayyâ sù ira anitu, á asinni laguk panò yù mangiyawâ sù ira kábulun naw ta pakáwayyá ra nga mamapánaw sù ira nattaliponak? Ari panò si Namarò galâ yù mangiyawâ nira? Wan, kuruk nga si Namarò yù paggapuán nayù pakáwayyá ra, á yáyù nga aggira yù mamanunnù nikayu, nga mangipakánnámmu ta ari kustu yù kagian naw nga meyannung nikán. ");
INSERT INTO att_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta kuruk nga si Namarò gapay yù paggapuán nayù pakáwayyâ nga mamapánaw sù ira nattaliponak. Á yáyù panákkilalán naw ta ajjanin nikayu yù pammagure ni Namarò.” ");
INSERT INTO att_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Á nagángngarigán si Apu Kesu, tapè ipakánnámmu na ta masikan yù pakáwayyá ni Namarò ánnè kâ Satanas. Kinagi na nira, “Masikan si Satanas nga kunnay ta tolay nga naparán yù ira ármas na, nga magguárdiá sù bale na, tapè awán ta makatallung nga maggubâ ta kukuá na. ");
INSERT INTO att_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngam nu ajjan yù masikan ánnè kuna nga umay mangnguá kuna, appútan na ánna gubatan na yù ármas na nga ikatalà na ta ángngiyígù na ta baggi na. Á gubatan na gapay yù ngámin nga kukuá na, nga balláyan na sù ira kábulun na.” ");
INSERT INTO att_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Á kinagi ni Apu Kesu paga, “Ngámin yù ira tatolay nga ari metádday nikán, aggira yù makikontará nikán. Á yù ira tatolay nga ari mangabbák nikán ta pagágál ku sù ira umay metádday nikán, aggira yù mamawarawarâ sù ira umay nakuan nikán.” ");
INSERT INTO att_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Á nagubobuk paga si Apu Kesu nga kinagi na nira, “Á yù anitu, ta páno na sù nagunagán na, umay ta namagá nga lugár nga magalek ta pagibannagán na. Á gapu ta arán na málek yù paggianán na tán, nonotan na ta mattoli sù nánawán na. ");
INSERT INTO att_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Á mattoli laguk, á masingan na yù tolay nga nammapiá ngin ta kun na balay nga napakarenuánin, nga awán ta maggián kuna. ");
INSERT INTO att_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Á umay laguk yù anitu nga magágál ta pitu nga kábulun na nga anitu nga narákè ánnè kuna, tapè mepaggián ira kuna. Á mattoli ira nga maggián sù tolay, á mappanà laguk yù ággián nayù tolay.” ");
INSERT INTO att_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Á ta pagubobuk ni Apu Kesu sù ira magaru nga tatolay, ajjan yù babay nga iniyássikan na yù ággubobuk na, á kinagi na, “Magayáyâ yù babay nga nangiyanâ nikaw, nga namasusu nikaw!” kun na. ");
INSERT INTO att_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngam simibbák si Apu Kesu, á kinagi na, “Más magayáyâ paga yù tolay nga magginná sù bilin ni Namarò ánna manguruk sù taddán na!” ");
INSERT INTO att_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Á nalannapán yù ira magaru nga tatolay nga nagarimummung kâ Apu Kesu. Á kinagi na nira laguk, “Narákè yù ira tatolay ta ággawo, ta yá lâ gustu ra innan yù makapállâ nga panákkilalád da, ta lage ra manguruk ta si Namarò yù maddok nikán. Ngam awán ta ipasingak ku nikayu nga panákkilalán naw, nu ari lâ yù kunnay sù makapállâ nga inipasingan na ngaw ni Jona, nga yù ngaw ábbilinán ni Namarò túrin ta Ninaba. ");
INSERT INTO att_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ta yù nesimmu ngaw kâ Jona, yáyù yù panákkilalán nayù ira taga Ninaba ta si Namarò yù naddok kuna. Á kunniû gapay nikán, sikán nga Kaká na ngámin na tatolay. Ta ajjan sangaw yù mesimmu nikán, nga panákkilalán nayù ira tatolay ta ággawo. ");
INSERT INTO att_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Á nu duttál yù ággaw nga pamanunnù ni Namarò sù ira ngámin nga tatolay, gumikkáng yù ngaw rena nga nammaguray ta Seba, á massistígu ta kuruk nga liwâ naw. Ta minay yù rena nga naggapu ta arayyu nga páppatulán tapè ginnán na yù aru nga napiá nga inituddu nayù ngaw Patul Solomon. Á yáyù nga awayyá nayù ngaw rena nga mangikeká nikayu, ta manakì kayu magginná, mássiki nu ajjan ta arubáng naw kunangane yù makáwayyá ánnè kâ Patul Solomon. ");
INSERT INTO att_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Á yù ira ngaw taga Ninaba gapay, gumikkáng ira sù ággaw nga pamanunnù ni Namarò ta tolay, á massistígu ira ta kuruk nga liwâ naw. Ta nabbabáwi ira ngaw ta liwâ da ta pakaginná ra sù bilin ni Namarò nga inilayalayâ na ngaw nira ni Jona. Á yáyù awayyá ra nga mangikeká nikayu, ta mássiki nu ajjanin nikayu kunangane yù makáwayyá ánnè kâ Jona, ngam manakì kayu manguruk kuna.” ");
INSERT INTO att_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Á kinagi ni Apu Kesu paga, “Á ta ángngarigán, nu paggatangan na tolay yù isingan, arán na gemma ituttù onu kallabán ta palanggána. Ngam ipe na sù ággianán na ta utun, tapè manawagán yù ira ngámin nga tullung ta balay. ");
INSERT INTO att_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Á yù keyarigán nayù matá na tolay yù isingan, nga paggapuán na nawák, tapè makasingan. Á ta ángngarigán nu napiá yù matá na, napiá gapay yù ánningan na. Ngam nu jikkù yù matá na, á buling nga maggián ta kallà. Á ta kunnian gapay sù ángnguruk na kâ Namarò. Nu napiá yù ángnguruk na, manawagán yù nonò na megapu sù bilin ni Namarò, á kánnámmuán na yù napiá, á napiá gapay yù akka-akkuán na. ");
INSERT INTO att_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Mappalán kayu laguk, marakè kun na kallà yù nonò naw! ");
INSERT INTO att_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nu napiá yù ángnguruk naw kâ Namarò, kuruk nga manawagán kayu nga awán bulubugá ta kallà ta nonò naw. Á kunnay ta manawagán na kayin nayù isingan.” ");
INSERT INTO att_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Á kabalin na nagubobuk ni Apu Kesu, ajjan yù tádday nga Parisio nga nangapà kuna ta umay kumán ta bale ra. Á minay laguk nepallálláng nira. ");
INSERT INTO att_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ngam nakaddák yù Parisio ánna napállâ, ta arán na sinuppál ni Apu Kesu yù kustombare na Kudio nga mabbaggaw lage ra kumán. ");
INSERT INTO att_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Á kinagi ni Apu Kesu kuna, “Sikayu nga Parisio, mabbaggaw kayu ta passuelu ánna tariaw, tapè malínis yù masingan. Ngam arán naw pakarenuán yù egga ta nonò naw nga ari masingan, ta mangilogò kayu ánna narákè yù akka-akkuán naw. ");
INSERT INTO att_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Maguyung kayu! Awán ta awayyá naw nga ilímak kâ Namarò yù egga ta nonò naw. Ta aggina lâ yù namarò sù masingan ánna ari masingan. Pidde na kayu ánna yù nonò naw, á ammu na gemma yù pinatattam naw ta nonò naw. ");
INSERT INTO att_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","“Pakarenuán naw laguk yù nonò naw nga ari masingan, tapè ammu naw mangikállà sù ira kábulun naw. Ta nu napiá yù egga ta nonò naw nga ari mepasingan, á napiá gemma gapay yù mepasingan nga akka-akkuán naw sù ira kábulun naw. ");
INSERT INTO att_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Magimuguk kayu, sikayu nga Parisio, ta mapanunnután kayu! Ta mássiki nu matunung kayu sù ángngiballe naw kâ Namarò sù mekamapulu sù ngámin nga makkakerumá nga kiruk nga atang, ngam mangilogò kayu sù ira kábulun naw ánna arán naw iddukan si Namarò. Máwák nakuan nga tángngagan naw yù iddù naw kâ Namarò ánna iddukan naw gapay yù ira kábulun naw. Á uputan naw gapay nga iballay kâ Namarò yù mekamapulu. ");
INSERT INTO att_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Magimuguk kayu, sikayu nga Parisio! Ta paggagammung naw sù kapilliá, karagatán naw yù magitubang sù kapiánán nga ággitubangán nayù maráyaw ánna yù pakialimánu nayù ira tatolay ta pappassiár naw ta dápun. ");
INSERT INTO att_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Magimuguk kayu, sikayu nga Parisio! Sikayu yù kunnay ta tanam nga ari namárkán, nga iguppuguppè nayù ira tatolay gapu ta arád da ammu ta ajjan.” Yáyù kinagi ni Apu Kesu sù ira Kudio nga Parisio, ta nu iguppè da yù tanam, mebiláng ira ta marapingán, nga ari mepaggagammung sù ira kábulud da nga maddáyaw kâ Namarò. Á yáyù keyarigád da gapu ta agippípiá ira. Á mekanakanâ nira yù ira káruán nga tatolay gapu ta arád da ammu ta narákè yù nonò da. ");
INSERT INTO att_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Á simibbák yù tádday nga mangituddu sù tunung ni Moyses, á kinagi na kâ Apu Kesu, “Mesturu, mekanakanâ kami nga mepasiránán sù kinagim sù ira Parisio!” kun na. ");
INSERT INTO att_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Á kinagi ni Apu Kesu kuna, “Sikayu nga mesturu sù tunung ni Moyses, magimuguk kayu gapay, ta mapanunnután kayu sangaw gapay. Sikayu yù kun na maddok sù ira mangáttu ta narámmà, nga arán na ira bulubugá abbágán. Jigirigátan naw yù ira tatolay, ta ipatuppál naw nira yù tunung nga lannapán naw, á arád da matuppál. ");
INSERT INTO att_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Magimuguk kayu! Ta pakkástán naw yù ira tanam nayù ngaw ira ábbilinán ni Namarò, nga pinapáte nayù ira ngaw naggaká nikayu. ");
INSERT INTO att_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Á sikayu, negittá yù nonò naw ta nonò nayù ira ngaw naggaká nikayu ánna anugutan naw yù kingnguá ra sù ira ngaw ábbilinán. Ta ari kayu manguruk sù bilin ni Namarò nga initúrâ nayù ira ngaw ábbilinán. Áppè pípiá kayu nga maddáyaw sù ira námmatay megapu ta pamakkástá naw sù tanam da. Á nu doban na má ni Namarò yù ira káruán na ábbilinán na, á sikayu nga kunnay sù ira ngaw naggaká nikayu, sikayu yù mamapátay nira. ");
INSERT INTO att_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Á yáyù nga nappasingan ta kuruk yù kinagi ni Namarò ngaw nga nabayágin. Kinagi na, ‘Dobak ku ta umay nira yù ira ábbilinák ku, á papatáyad da yù ira káruán, á jigirigátad da yù ira káruán,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Á sikayu laguk yù pabbabálatán ni Namarò sù pamapáte ra ngaw sù ira ngámin nga ábbilinán na ta áddè ngaw o-olu nga napapátay ta áddè kunangan. ");
INSERT INTO att_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Si Abel nga anâ ni Adan yù ngaw o-olu nga natay megapu sù panguruk na kâ Apu Namarò, á aggira ngámin nga ábbilinán nga siminubbâ kuna ta áddè kâ Sakariâ nga naporián, nga pinapáte ra ta námmuák nayù mangilin nga kapilliá ta taging nayù pangiyátangán. Wan, á kagiak ku nikayu ta sikayu nga matolay kunangan yù pabbabálatán ni Namarò megapu ta pate nayù ngaw ira ngámin nga ábbilinán na. ");
INSERT INTO att_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Magimuguk kayu, sikayu nga mangituddu sù tunung ni Moyses! Kunnay ta inituttù naw yù ánnúsi nga mabbukâ ta pakánnámmu na tolay sù kuruk nga bilin ni Namarò nga meyannung ta ángngiyígù na ta tolay. Mapanunnután kayu, gapu ta manakì kayu manguruk, á ipugik naw gapay yù panguruk nayù ira tatolay nga umay nakuan kâ Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Á ta páno di Apu Kesu tán nga balay, nakujjà yù mammang nayù ira Parisio ánna yù ira mesturu sù tunung ni Moyses, megapu sù kinagi ni Apu Kesu nira. Á ninonò da yù aru nga makkakerumá nga iyabbû da kuna, ");
INSERT INTO att_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tapè makagi na nakuan yù ipamaliwâ da kuna. ");
INSERT INTO att_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Á yù ira jinibu nga tatolay nga maddarassil ánna makkakáguppè, nagarimummungád da di Apu Kesu. Á nagubobuk si Apu Kesu sù ira sinudduán na, á kinagi na nira, “Mappalán kayu sù ituddu nayù ira Parisio nga ari kuruk, tapè arád da kayu ilogò. Ta agippípiá ira, á kunnay ta áppalappák ta pán yù narákè nga ituddu ra nga malogon massamâ. ");
INSERT INTO att_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Á kagiad da ta awán ta makánnámmu sù akka-akkuád da. Ngam mepakánnámmu sangaw, ta duttál sangaw yù ággo na nga mepalappâ yù ngámin nga nelímak kunangan. ");
INSERT INTO att_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Á yù ubobugan naw ta gabi sù lágum na balay, mepalappâ sangaw ta lawán ta tangngá na ággaw. Á yù iyanasâ naw ta unak na balay nga nelitù, yáyù melayalayâ ta ággaw sù tangngá na ili. ");
INSERT INTO att_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Á yawe yù kagiak ku nikayu nga kákkopuk ku, arán naw ikássing yù ira tatolay nga mamapátay ta baggi naw, á ta kabalin na, awán ta awayyá ren nga manganni nikayu. ");
INSERT INTO att_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngam kagiak ku yù ikássing naw! Maganássing kayu laguk kâ Namarò, ta ari lâ nga makáwayyá nga mamapátay ta baggi na tolay, nu ari gapay makáwayyá nga mangipettung ta impiernu. Á yáyù nga pappalánat takayu ta si Namarò laguk yù ikássing naw! ");
INSERT INTO att_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ngam si Namarò gapay yù mangiddù, á nepallà yù allà ni Namarò nikayu. Á mássiki yù ira límá nga ballì, nga iláku ra ta dápun ta duá sintábu, arán na ira máttamán ni Namarò, nga taggitádday. ");
INSERT INTO att_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Á ammu na ngámin yù meyannung nikayu, mássiki yù biláng na duddù naw. Á yáyù nga ari kayu laguk maganássing, ta nepallà yù ángngiddù ni Namarò nikayu nga katággitádday ánnè sù kitáru nga ballì. ");
INSERT INTO att_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Á kagiak ku nikayu, nu ari kayu mappasirán nga makkagi sù ira kábulun naw ta sikán yù Yápu naw, mássiki nu uyoyungád da kayu megapu sù panguruk naw nikán nga Kaká na ngámin na tatolay, á sikayu gapay yù tákkilalák ku ta arubáng nayù ira daroban ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngam nu makkagi kayu ta arubáng nayù ira kábulun naw ta arán nawà tuttulan, á panakitát takayu gapay ta arubáng nayù ira daroban ni Namarò ta lángì. ");
INSERT INTO att_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Á yù tolay nga makkakagi nikán, á nu mabbabáwi ánna makipakomá, á pakomán ni Namarò. Ngam yù tolay nga makkakagi sù Mangilin nga Ikararuá ni Namarò, ari bulubugá mapakomá ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Á nu ajjan yù mangiyángay nikayu sù ira kátannangán naw ta kapilliá onu sù ira makáwayyá, tapè ikeká ra kayu ta arubáng da megapu ta panguruk naw nikán, ari kayu mabburung nu kunnasi yù itabbák naw nira. ");
INSERT INTO att_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ta pamestigá ra nikayu, á yù Mangilin nga Ikararuá yù mangipakánnámmu nikayu sù itabbák naw nira.” ");
INSERT INTO att_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Á ta pangituddu ni Apu Kesu sù ira kitáru nga tatolay, ajjan yù tádday nga nagubobuk kuna, á kinagi na, “Mesturu, kagiam mu bì sù wagì ta iballáyán nangà sù kukuá nayù yáma mi nga bittáng na nikami,” kun na. ");
INSERT INTO att_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Á kinagi ni Apu Kesu kuna, “Kopun, sikayu lággapay, ta aringà minay saw nga umay mamanunnù ánna mamabballay.” ");
INSERT INTO att_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Á kinagi na laguk sù ira ngámin nga naggagammung tán, “Magimuguk kayu, marakè passilan naw yù egga ta dabbuno. Ta yù kuruk nga napiá nga áttole na tolay ari megapu sù aru nga kukuá na.” ");
INSERT INTO att_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Á nagángngarigán si Apu Kesu, á kinagi na, “Ajjan ngaw yù tolay nga maríku, nga aru yù ákkomanán na ánna aru yù ginaták na. ");
INSERT INTO att_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Á yáyù nga ninonò na, ‘Massirì yù ira balay nga ángngipayyák ku ta ammè. Anni yù akkuák ku?’ ");
INSERT INTO att_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Á kinagi na, ‘Á yawe laguk yù akkuák ku. Táttakak ku lâ yù ira balay nga ángngipayyák ku, á mappaddayà sù ira darakal nga ángngipayyák ku, tapè pakappiák ku nira yù ammè ánna ngámin nga kukuâ!’ kun na. ");
INSERT INTO att_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Á ninonò na paga, ‘Maríkungakin, ta ajjan yù kanak ku ta mabayák nga dagun, mássiki aringakin mattarabáku. Magibannágà lâ nga kumán, ámminum, ánna makipabbúyá!’ kun na nga mannononò. ");
INSERT INTO att_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngam kinagi ni Namarò laguk kuna, ‘Maguyung ka! Matay ka sangaw nu gabingo. Á asinni panò sangaw yù mangâ sù ngámin nga pinakappiám mu nga kagiam mu ta kukuám?’ ");
INSERT INTO att_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Á kunnian gapay yù ággián nayù ira ngámin nga tatolay nga mokkuk, ta lonád da yù ákkiyápu ra kâ Namarò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Á nagubobuk si Apu Kesu sù ira sinudduán na, á kinagi na nira, “Yáyù nga kagiak ku nikayu ta arán naw laguk ikaburung yù máwák naw ta áttole naw sawe dabbuno, nga kanan naw ánna gámì naw. ");
INSERT INTO att_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ta máwák nga tángngagan naw yù áttole naw kâ Namarò ánnè sù kanan naw, ánna iddukan naw yù baggi naw ánnè sù gámì naw. ");
INSERT INTO att_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Á ta ángngarigán, nonopan naw yù ira mammánù. Ari ira mammulá, á ari ira makigaták, á awán ta ággubbuád da. Ngam pakanan ni Namarò ira. Á nepallà yù ángngiddù na nikayu ánnè sù ira mammánù. ");
INSERT INTO att_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Á awán ta napiá nga pabbalinán nayù burung naw, ta arán naw awayyá nga lannapán yù ággaw nga áttole naw, mássiki lâ tádday, megapu sù burung naw. ");
INSERT INTO att_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Á nu arán naw makuá yù kunniû nga baddì, anni laguk yù serbi nayù burung naw sù aru nga makkakerumá! ");
INSERT INTO att_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Á nonopan naw yù ira lappáw. Ari ira mattarabáku. Ari ira mangabal. Ngam nakástá ira ánnè sù ipabbarawási ni Patul Solomon, nga yù ngaw maríku nga patul. ");
INSERT INTO att_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Á nu kunnian yù ámmarawási ni Namarò sù ira lappáw, nga ajjan ta kakáddapán nga nakástá kunangan, nga tuggiad da sangaw nu ummá, á arán na panò iyawâ nikayu gapay yù ipabbarawási naw nga mepángngà? Iyawâ na nikayu gemma! Á sikayu, ngattá ta arán naw ikatalà si Namarò? ");
INSERT INTO att_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ari kayu laguk maburung nga mannononò nu anni sangaw yù kanan naw onu anni sangaw yù ipabbarawási naw. ");
INSERT INTO att_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta yáyù lâ ikaburung nayù ira tatolay ta dabbuno nga ari mangikatalà kâ Namarò. Ngam sikayu, arán naw ira párigán, ta ammu ni Namarò nga Yáma naw ta lángì yù máwák naw. ");
INSERT INTO att_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Á yáyù nga tángngagan naw lállaguk yù meyannung sù pammagure ni Namarò ánna yù ákkiyápu naw kuna, á iyawâ na laguk nikayu yù máwák naw.” ");
INSERT INTO att_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Á kinagi ni Apu Kesu paga, “Sikayu nga makituddu nikán, ari kayu maganássing, mássiki baddì kayu lâ, ta magayáyâ yù Yáma naw ta lángì nga mangisipà nikayu sù pammagure na. ");
INSERT INTO att_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Iláku naw laguk yù kukuá naw, á ilimù naw yù pallakuán naw sù ira ikáttole naw nga magáwák. Á nu kunnian yù akkuán naw, pakappián ni Namarò ta lángì yù iyawâ na nikayu sangaw nu umay kayu tán. Á kunnay ta ajjan yù kuártu naw nga ari bulubugá napangarián, nga nepay ta pitáka nga ari mabbáli ta dán ánna ari marúnù, nga napakappián sù gián nga awán ta makkokò ánna awán ta ulolak nga manarál. ");
INSERT INTO att_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta yù paggianán nayù kukuá naw, yáyù gapay tángngagan naw nga nonopan. Arán nawin laguk nononopan yù ággián naw ta dabbuno, ngam nononopan nawin galâ yù ákkiyápu naw kâ Yáma naw ta lángì.” ");
INSERT INTO att_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Á kinagi ni Apu Kesu paga nira, “Dán nga naparán kayu laguk nga magiddak sù labbè ku, mássiki nu gabi, ta kunnay sù tolay nga egga yù isingan na nga makegagátang. ");
INSERT INTO att_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yáyù nga keyarigán naw yù kunnay sù ira aripan nga matturá nga magiddi-iddak sù labbè nayù yápu ra nga manoli nga maggapu ta bodá. Á nu mattottò sangaw ta puertá, dagarágâ nga bukatád da. ");
INSERT INTO att_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Á magayáyâ yù ira aripan nu maratang na ira nayù yápu ra nga magiddi-iddak sù labbè na. Kagiak ku nikayu ta pagitubangan na ira laguk nayù yápu ra, tapè mallalálláng ira, á aggina yù masserbi nira. ");
INSERT INTO att_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Á yáyù nga magayáyâ ira nu dán nga naparán iren, mássiki nu lubbè nakuan ta tangngá na gabi onu alippánnawák. ");
INSERT INTO att_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Á kánnámmuán naw laguk! Ta ángngarigán, nu ammu nayù tolay yù dattál nayù makkokò sù bale na, á matturá nga magiddak, tapè ari makatallung yù makkokò ta bale na. ");
INSERT INTO att_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Á kunnian gapay nikayu, máwák nga dán nga naparán kayu gapay, ta awán ta makánnámmu sù oras na labbè ku, ta ikáddagâ ku lâ lubbè, sikán nga Kaká na ngámin na tatolay.” ");
INSERT INTO att_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Á kabalin na nagubobuk ni Apu Kesu, kinagi ni Eduru kuna, “Apu, sikami lâ yù pakkagiám mu sù ángngarigám mu? Onu kagiam mu gapay sù ira tatolay?” kun na. ");
INSERT INTO att_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Á simibbák si Apu Kesu megapu sù tádday nga ángngarigán, á kinagi na, “Nu ajjan yù napiá nga aripan nga kunnay nikayu nga manuppál sù ipakuâ nikayu, aggina yù ikatalà nayù yápu na ta manaron sù ira kábulun na nga aripan. Á aggina laguk yù mangiyawâ nira sù kanad da ta pakkákád da. ");
INSERT INTO att_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Á magayáyâ yù aripan ta labbè nayù yápu na, nu maratang nayù yápu na nga matuppál yù ngámin nga inikatalà na kuna! ");
INSERT INTO att_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Á gapu ta napiá yù ánnaron na sù ira kábulun na nga aripan, napiá yù ábbalabálà nayù yápu na kuna, ta aggina yù mekatalà nayù yápu na sù ngámin nga kukuá na. ");
INSERT INTO att_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ngam ta ángngarigán nu nonopan nayù aripan ta mabayák paga támma lubbè yù yápu na, á yáyù nga maguray lâ yù akkuán na, á jigirigátan na yù ira kábulun na nga aripan, ánna kumán lâ ánna mappissán ánna magilellaw. ");
INSERT INTO att_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Á ikáddagâ lâ lubbè yù yápu na, á marángnganán na nga mangngamangnguá ta narákè. Á pagikaruan na laguk yù aripan, á metádday nga mekanakanâ sù ira ari manguruk. ");
INSERT INTO att_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Á yù aripan nga makánnámmu sù ipakuá nayù yápu na kuna, ngam arán na tuppálan ánna ari naparán sù labbè na, nepallà yù pamagikáru nayù yápu na kuna. ");
INSERT INTO att_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ngam yù aripan nga ari makánnámmu sù ipakuá nayù yápu na kuna ánna malliwâ, á aláppaw lâ yù pamagikáru na kuna. Ngam yù tolay nga ikatalà nayù yápu na ta pakáwayyá na, iddagán na gapay yù panuppál na sù ipakuá na. Á yù tolay nga ikatalà nayù yápu na ta aru nga pakáwayyá na, aru gapay yù iddagán nayù yápu na nga palurotan na.” ");
INSERT INTO att_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Á kinagi ni Apu Kesu gapay, “Yaw iniyángè sawe dabbuno yù bilin ni Namarò nga kun na api nga maggatang, tapè manawagán yù nonò nayù ira makaginná, ngam mabáli ta kun na api nga manarál sù nonò nayù ira malussaw nikán, á parè bì ta maggatangin nga mabì mabalin. ");
INSERT INTO att_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngam máwák nga attamák ku yù jigâ ánna patè, á ari magimammà yù nonò ku áddè ta arán na kabalin. ");
INSERT INTO att_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Á kagian naw mápugák ta minayà tapè pagimammatak ku yù ira tatolay ta dabbuno. Ngam ari, ta mepakkakáttuay ira ta nonò, ta ajjan yù ira tumuttul nikán, ánna ajjan yù ira manakì. ");
INSERT INTO att_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Á yáyù nga mamegapu kunangane nga makkakáttuay yù nonò nayù ira mawwawági. Á ta ángngarigán nu ajjan yù límá nga tolay sù tádday nga balay, á yù ira tallu, makikontará ira sù ira duá. Á yù ira duá gapay, makikontará ira sù ira tallu. ");
INSERT INTO att_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Á yù ira matáma, makkákontará ira. Á kunnian gapay sù ira masíná, makkákontará ira. Á yù katugángán, kontarán na yù manugáng na, á yù manugáng, kontarán na yù katugángán na.” ");
INSERT INTO att_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Á kinagi ni Apu Kesu sù ira magaru nga tatolay, “Á sikayu, ammu naw ta magurán támma sangaw, nu masingan naw yù naribbà ta lalammarán. Á kuruk nga magurán sangaw. ");
INSERT INTO att_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Á nu mappaddák nga naggapu ta abagátán, ammu naw ta mapátu yù ággaw sangaw, á kuruk nga mapátu. ");
INSERT INTO att_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Agippípiá kayu! Ngattá, ta matákkilalán naw yù masingan naw ta lángì ánna dabbun, ngam arán naw tákkilalán yù mesimmu kunangan! ");
INSERT INTO att_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ngattá, ta arán naw nonopan yù mepángngà nga akkuán naw nakuan! ");
INSERT INTO att_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Á ta ángngarigán, nu ajjan yù tolay nga nakaliwatán naw, lage naw makáddè ta kues, makká-ubobuk kayu, tapè mammapiá yù ággián naw. Ta nu iddagán naw yù pangikeká na nikayu ta kues, á yù kues, ipaparesu na kayu sù ira pulis. ");
INSERT INTO att_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Á kagiak ku nikayu, ta maggián kayu laguk ta karsel áddè ta arán naw pakekáru.” ");
INSERT INTO att_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Á pangituddu ni Apu Kesu, ajjan yù ira tatolay nga minay nangiparámak kuna sù pamapáte ni Gubinador Pilatto sù ira taga Galilia, ta pangiyátáng da ta ayám kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Á pakarámak ni Apu Kesu, kinagi na nira, “Á gapu ta natay ira, kagian naw mápugák ta nepallà yù liwâ da ánnè sù ira kábulud da nga taga Galilia. ");
INSERT INTO att_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngam ari gemma kuruk. Á kagiak ku nikayu, nu arán naw ibabáwi yù liwâ naw, matay kayu gapay nga kunnay nira, á mesinná kayu laguk kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Á anni ta ure naw sù ira mapulu ta walu nga tatolay nga narámak tam nga natay ta karabbâ nayù atannáng nga balay tuke ta Silowam sù ili na Jerusalem? Kagian naw mápugák ta nepallà yù liwâ da ánnè sù ira ngámin nga keliád da nga maggián ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngam ari kuruk gemma, á kagiak ku nikayu, nu arán naw ibabáwi yù liwâ naw, á ikáddagâ lâ nga matay kayu gapay ta kunnay nira, á mesinná kayu laguk kâ Namarò ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Á nagángngarigán si Apu Kesu, á kinagi na nira, “Ajjan yù tolay nga egga yù káyu nga igò nga nemulá sù kamulán na ta úbas. Á en na sinullúnán nu egga bungá na. Ngam awán bulubugá ta bungá na. ");
INSERT INTO att_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Á kinagi na sù tolay nga minánnaron ta mulá na, ‘Innam mu yawe káyu! Tallu ragunakin nga umay mangâ ta bungá na nakuan, á awán bulubugá ta málâ ku! Tukáram mu laguk, ta awán gemma ta serbi na, tapè memulá yù dumá,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ngam yù minánnaron sù kamulán, kinagi na sù yápu na, ‘Paguráyám mu lábbì, Apu, ta tanga ragun, ta kokkobák ku yù pun na ánna payyák ku ta attay na ayám. ");
INSERT INTO att_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Á nu mabbungá sangaw nu tádday ragun, á napiá laguk! Á nu ari, ipattukák mu sangawin laguk.’ ” ");
INSERT INTO att_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Á ta ággaw na Sabadu, nga ággibannák da, minay si Apu Kesu nangituddu sù kapilliá nayù ira Kudio. ");
INSERT INTO att_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Á ajjan tán yù babay nga natakì ta mapulu ta walu nga dagunin, nga nagunagán na anitu, á nakkabbuk nga ari makatáddak. ");
INSERT INTO att_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Á pakasingan ni Apu Kesu kuna, inagálán na, á kinagi na kuna, “Tíyá, napammapiá ken sù takì mu!” kun na. ");
INSERT INTO att_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Á singngalán na, á dagarágâ nammapiá nga nanáddak, á jináyo na si Namarò. ");
INSERT INTO att_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Á gapu ta pinammapiá ni Apu Kesu yù matakì ta Sabadu nga ággibannák da, napporay kuna yù kapatás ta kapilliá. Á yáyù nga kinagi na sù ira tatolay, “Ngattá, ta umay kayu mapporu sù ággaw na Sabadu, nga mangilin nga ággaw? Ajjan gemma annam nga ággaw nga awayyá tam nga mattarabáku, nga umay kayu nakuan mapporu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Á simibbák si Apu Kesu, á kinagi na, “Agippípiá kayu! Egga panò nikayu yù tádday nga arán na ikállà yù ayám na ánna arán na ubbarán, nga en na penuman, mássiki nu Sabadu? ");
INSERT INTO att_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Á ngattá, ta kagian naw ta ari máyâ ta Sabadu yù pamalubbáng ku sawe babay nga ginaká ni Lákay Abrakam, nga jinigirigâ ni Satanas ta mapulu ta walu nga dagunin!” kun na. ");
INSERT INTO att_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Á tabbák ni Apu Kesu, nepasiránán yù ira malussaw kuna. Ngam yù ira ngámin nga káruán nga tatolay, magayáyâ ira sù ngámin nga makapállâ nga kingnguá ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Á nangituddu si Apu Kesu mángin, á kinagi na, “Nonopan naw nu kunnasi yù pammagure ni Namarò ta tolay. Anni yù pangiyarigák ku sù pammagure na? ");
INSERT INTO att_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kunnay sù babaddì nga bukal nga inimulá na tolay sù ákkomanán na. Á nattubbu, á dumakal lâ dumakal, áddè ta umay magumù yù ira mammánù kuna.” ");
INSERT INTO att_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Á kinagi na má nira, “Anni paga yù meyárik sù pammagure ni Namarò? ");
INSERT INTO att_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Massamâ yù pammagure na sù ira tatolay nga kunnay sù passamâ na áppalappák ta pán nga inâ nayù babay, nga inikiruk na sù tallu súpá nga arená, tapè luppák yù pán.” ");
INSERT INTO att_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Á nánaw di Apu Kesu ta umay ira ta Jerusalem. Á naddagâ nga mangituddu sù ira ngámin nga babálay nga talebarád da. ");
INSERT INTO att_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Á ajjan yù tádday nga minay nangiyabbû kuna, “Apu, baddì panò lâ yù ira meyígù, tapè ari ira magikáru ta impiernu?” kun na. Á simibbák si Apu Kesu nga nagángngarigán, á kinagi na, ");
INSERT INTO att_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Meyárik yù pammagure ni Namarò sù balay nga nasirì yù puertá na. Italákkuruk naw nga tullung kunangane! Ta aru sangaw yù ira mamarubá, ngam ari ira makatallung. ");
INSERT INTO att_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Á ta ángngarigán, nu inilitù nen nayù makákkuá ta balay, arán na kayin patallungan. Á sangaw nu umay kayu mattottò ta puertá, á katolán naw, ‘Apu, bukatám mu bì!’ Ngam kagian na nikayu, ‘Arák ku nikayu bukatán, ta arát takayu ammu ánna arák ku ammu yù naggapuán naw!’ kun na. ");
INSERT INTO att_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Á kagian naw kuna, ‘Apu, nepallálláng kami nikaw, á sikaw yù nangituddu ta babále mi.’ ");
INSERT INTO att_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ngam kagian na má, ‘Arát takayu ammu, á arát ta kayu kábulun. Mánaw kayu, sikayu nga minálliwâ!’ ");
INSERT INTO att_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Á yáyù nga gikuletán kayu nga mangngarangngaringngì ta pakerípâ naw sù ira naggaká nikayu, di Abrakam kári Isak kâ Akup ánna yù ira ngámin nga ábbilinán ni Namarò, nga mesipà sù pammagurayán ni Namarò. Ngam sikayu, mapaturiák kayu, á maggián kayu ta lawán. ");
INSERT INTO att_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Á umay yù ira makkakerumá nga tatolay nga naggapu ta ngámin nga makkakerumá nga lugár, tapè mepallalálláng ira sù pammagurayán ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Á ajjan yù ira maporián kunangane, nga mapolu sangaw. Á ajjan yù ira mapolu kunangane, nga maporián sangaw.” ");
INSERT INTO att_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Á ajjan yù ira Parisio nga minay kâ Apu Kesu, á kinagi ra kuna, “Mánaw ka saw, á umay ka ta tanakuán nga lugár, tapè melillì ka kâ Patul Erodo, ta gustu na ka ipapapátay,” kud da. ");
INSERT INTO att_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Á kinagi na nira, “En naw kagian táne minángngilogò ta tángngagak ku bì yù tarabákù nga mamapánaw sù ira nattaliponak ánna pammapiák ku yù ira máttakì ta ággawo ánna sangaw nu ummá, áddè ta arák ku mabalin sù mekatallu nga ággaw. ");
INSERT INTO att_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Á yawe lâ kagiak ku nikayu, ta uputak ku yù akkuák ku ta ággawo ánna sangaw nu ummá, ánna tádday nga ággaw, ta áddè ta arák ku labbè ta Jerusalem. Á umayà ta Jerusalem gapu ta yáyù namapatayád da sù ira ábbilinán ni Namarò, á ari máyâ nu matay yù ábbilinán ni Namarò ta tanakuán nga lugár. ");
INSERT INTO att_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Sikayu nga taga Jerusalem, maraddamà megapu nikayu, á nepallà yù daddam ku, ta narákè yù ággangnguá naw. Pinapáte naw yù ira ábbilinán ni Namarò, á pinayáng naw ta batu yù ira nabilin nga umay nikayu mangituddu! Á namepígiá nga inapà takayu nga umay nikán, nga kunnay sù ángngiddù na manù sù píyà na, ngam manakì kayu lâ! ");
INSERT INTO att_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Á yáyù nga manakikin laguk si Namarò sù ira tatolay ta Jerusalem, á nánawán na yù gián naw. Á kagiak ku laguk ta arán nawà má sangaw masingan áddè ta matunù yù panolì saw nikayu, á tákkilalán nawà, ánna kagian naw sù ira kábulun naw, ‘Dayáwat tam yù Yápu tam nga jinok ni Namarò nga umay mammaguray!’ ” ");
INSERT INTO att_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Á ta Sabadu nga ággibannák da, minay nakilálláng si Apu Kesu ta bale nayù tádday nga kátannangán nayù ira Parisio. Á yù ira tatolay, iningad da si Apu Kesu, nu anni yù akkuán na, ");
INSERT INTO att_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","gapu ta jimikkì kuna yù tolay nga nallábbák. ");
INSERT INTO att_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Á nakiubobuk si Apu Kesu sù ira mangituddu sù tunung ni Moyses ánna yù ira Parisio, á kinagi na, “Anni yù mepugik nayù tunung tam nga meyannung ta pangilit tam sù ággaw nga ággibannák? Malliwâ ittam panò sù ággaw nu pammapiát tam yù ira máttakì?” ");
INSERT INTO att_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngam arád da sibbák si Apu Kesu. Á singngalán na yù tolay nga matakì, á pinammapiá na, á pinapáno na ta lubbè ta bale na. ");
INSERT INTO att_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Á kinagi na laguk nira, “Sikayu nga katággitádday, ta ángngarigán nu ajjan yù ayám na nga napannâ ta abbû, arán na panò dagarágâ nga igon, mássiki ta ággaw na Sabadu?” ");
INSERT INTO att_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Á awán bulubugá ta matabbák da sù kinagi na. ");
INSERT INTO att_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Á nasingan ni Apu Kesu ta ajjan yù ira napolu ta bale nayù Parisio, á minay ira nagitubang sù kapiánán nga ággitubangán nayù ira kotunán. Á yáyù nga kinagi ni Apu Kesu nira, ");
INSERT INTO att_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Á ta ángngarigán, nu ajjan yù mangapà nikayu ta bodá, napiá nu ari kayu nakuan magitubang sù ággitubangán nayù ira kotunán. Ta ajjan mápugák yù inapà na nga maráyaw ánnè nikayu. ");
INSERT INTO att_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Á nu magitubang kayu sù ággitubangán nayù maráyaw, á umay yù nangapà nikayu, á kagian na, ‘Magalì ka bì, ta tanakuán yù magitubang saw,’ kun na. Á yáyù nga mappasirán kayu, ta mapuersá kayu nga magitubang sù ággitubangán nayù kagukábán. ");
INSERT INTO att_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ngam napiá galâ nu mapolu kayu nga magitubang sù ággitubangán nayù kagukábán. Á sangaw nu umay yù mangálliuk, á kagian na nikayu, ‘Kopun, umay ka magitubang táne napiá nga ággitubangán nayù maráyaw,’ kun na. Á ta kunnian meparáyaw kayu gapay ta arubáng nayù ira káruán nga tatolay. ");
INSERT INTO att_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ta yù ira ngámin nga mappeddaráyaw, mepagukák ira nga mepasiránán. Á yù ira tumulù nga gumukák, mepotun ira nga meparáyaw.” ");
INSERT INTO att_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Á kinagi ni Apu Kesu sù mangálliuk kuna, “Nu mamakán ka, ari ka mangapà sù ira lâ nga makápà gapay nikaw, nga kopum mu, wagim, kanakanáyum mu ánna yù ira maríku nga karúbám, marakè apatad da ka gapay sangaw sù pappabbúyá ra, á yáyù nga mabalabálà ka. ");
INSERT INTO att_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ngam sikaw á, kunniaw yù akkuám mu nakuan. Nu mamakán ka, mangapà ka galâ sù ira nga ari makápà nikaw, yù ira pobare, pilay, gappung, ánna buling. ");
INSERT INTO att_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nu kunnian yù ángngikállà mu nira, mapagayáyâ ka, gapu ta ari ira makabalabálà nikaw, á si Namarò yù mabbalabálà nikaw sangaw nu matunù yù ággo na pamaginnanole na sù ira ngámin nga napiá nga tatolay.” ");
INSERT INTO att_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Á ajjan yù tádday nga mepakkákán kári Apu Kesu, á pakaginná na sù kinagi ni Apu Kesu, kinagi na kuna, “Magayáyâ gemma yù ira tatolay nga alliúgan na sangaw ni Namarò nga mallalálláng sù pammagurayán na!” kun na. ");
INSERT INTO att_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngam kinagi ni Apu Kesu kuna, “Á ta ángngarigán, ajjan yù tolay nga mapparán ta aru nga kanan, tapè mangapà sangaw ta aru nga tatolay ta umay ira makilálláng. ");
INSERT INTO att_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Á ta kabalin na napparán, jinok na yù aripan na ta en na agálán yù ira apatan na. Á kinagi nayù aripan nira, ‘Umay kayu bì, ta naparánin,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Á ta pagágál nayù aripan sù ira tatolay, ajjan yù angayád da ngámin nga katággitádday. Yù napolu nga inapà na, kinagi na sù aripan, ‘Kagiam mu bì kâ yápum ta pakomán nangà bì ta aringà makángay, ta ajjan ginátáng ku nga ákkomanák ku, á máwák ta ek ku tullúnán,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Á yù tádday nga inapà na, kinagi na, ‘Kagiam mu bì kâ yápum ta pakomán nangà lábbì ta aringà makángay, ta ek ku tullúnán yù mapulu nga báka nga ginátáng ku,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Á yù mekatallu nga inapà na, kinagi na, ‘Aringà garè makángay ta apángngatáwangà garè,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Á nanoli yù aripan, á kinagi na sù yápu na yù ngámin nga kinagi ra. Á pakaginná na karannian, napporay gapu ta ari minay yù ira inapà na. Á kinagi na sù aripan na, ‘Apurám mu nga umay sù ira dálan ánna kalsáda, á iyángem saw yù ira marángnganám mu sangaw nga pobare, pilay, buling, ánna gappung,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Á sinuppál nayù aripan. Á kinagi na sù yápu na, ‘Apu, natuppálin yù kinagim, á ajjanin yù ira inapà ku, ngam aru lâ paga yù paggianán,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Á kinagi na má sù aripan na, ‘E ka laguk ta arayyu nga lugár, á apatam mu yù ira maratang mu ta umay ira makilálláng ta balè, tapè mapannu yù balè. ");
INSERT INTO att_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta awán bulubugá sù ira napolu nga inapà ku nga pakákkapak ku sù kanan nga pinarák ku!’ ” ");
INSERT INTO att_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Á ta pallakák di Apu Kesu nga pappángè ta Jerusalem, aru yù ira tatolay nga siminuttul kuna. Á nallipay si Apu Kesu nira, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yù tolay nga umay nikán gapu ta gustu na tumuttul nikán, máwák nga sikán yù iddukan na ánnè sù ángngiddù na sù ira darakal na, atáwa na, ánâ na, wáwwagi na, ánna baggi na gapay. ");
INSERT INTO att_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Á yù tolay nga ari makeyangngà sù jigâ ánna pate na megapu sù panuttul na nikán, á ari makatuttul nikán. ");
INSERT INTO att_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Á ta ángngarigán nu ajjan nikayu yù tolay nga mappadday ta balay, á mapolu bì bilángan na nu egga kuna yù makatò áddè ta kabalin na. ");
INSERT INTO att_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta nu patáddagan na yù kallang, ánna awán ta makatò, awán ta awayyá na nga mamalin. Á pakasingan nayù ira tatolay ta arán na mabalin, uyoyungád da. ");
INSERT INTO att_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Á kagiad da, ‘Mamegapu yù tolay nga mabbalay, ngam arán na balinan!’ kud da. ");
INSERT INTO att_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Á kunnian gapay nu ajjan yù patul nga egga lâ yù mapulu ribu nga suddálu na, á lage na umay makigerrá sù tádday nga patul nga egga yù duápulu ribu nga suddálu na, á nonopan na nu egga yù awayyá na nga mangappù nira. ");
INSERT INTO att_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Á nu nonopan na ta awán ta awayyá ra nga mangappù, doban na yù gádde na ta en na dapunan yù patul ánna yù ira suddálu na lage ra umaranni kuna, tapè makikomá kuna ta magimammà ira. ");
INSERT INTO att_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Á kunnian gapay nikayu nga katággitádday, nu ajjan nikayu yù ikáyâ na makituddu nikán, máwák nga mapolu nga nonopan na nu awayyá na nga ikatalà ngámin nikán yù ayatan na ánna ure na, ánna lonán na ngámin yù kukuá na, tapè makituddu nikán. ");
INSERT INTO att_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Á nu ajjan yù tumututtul nikán, ngam arán na ngámin ikatalà nikán, kunnay sù asin nga nári yù paggák na. Ta napiá yù asin, ngam nu awánin yù paggák na, á nalállák, á kunnasi panò nga manguli? Awán. ");
INSERT INTO att_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Á kengá lâ yù asin, ta awán ta serbi na. Mássiki ikiruk da ta dabbun, ari máyâ ta abúno, á itabbà da lâ. Á sikayu nga makaginná, ginnán naw ta napiá yù kinagì!” ");
INSERT INTO att_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Á yù ira mináttuki ta buwì ánna yù ira káruán nga minálliwâ, minay ira kâ Apu Kesu, tapè ginnád da yù inituddu na. ");
INSERT INTO att_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Á naddagaragim yù ira Parisio ánna yù ira mangituddu sù tunung ni Moyses, á kinagi ra, “Yawe tolay, alawatan na yù ira minálliwâ nga metádday kuna, á mepallalálláng nira gapay!” kud da. ");
INSERT INTO att_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Á yáyù nga nagángngarigán si Apu Kesu, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Á ta ángngarigán, ajjan yù tolay nga nagayám ta magatù nga karneru. Á anni panò yù akkuán na, nu magawáwán sangaw yù tádday? Arán na panò ibattáng yù ira siámapulu ta siám ta ággarabád da, tapè en na aleran yù tádday nga nagawáwán áddè ta arán na pakálek kuna? ");
INSERT INTO att_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Á nu málek na, ayatán, á buttungan na nga ilabbè na ta bale na. ");
INSERT INTO att_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Á labbè na ta bale na, agálán na yù ira kákkopun na ánna yù ira karúbá na, á kagian na nira, ‘Mepagayáyâ kayu nikán, á mappabbúyá ittam, ta nálek ku yù karnerù nga nagawáwán!’ kun na. ");
INSERT INTO att_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Á kagiak ku nikayu, ta kunnay sù pagayáyâ nayù mináppárák ta pakálek na sù tádday nga karneru na nga nagawáwán, á kunnian gapay yù kepagayáyâ di Namarò ánna yù ira nga maggián kuna ta lángì megapu sù tádday nga tolay nga mabbabáwi ta liwâ na, ánnè sù ira siámapulu ta siám nga tatolay nga makkagi ta matunung ira nga awán ta liwâ nga máwák da ibabáwi.” ");
INSERT INTO att_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Á kinagi ni Apu Kesu, “Á ta ángngarigán, ajjan yù babay nga egga pirâ na nga mapulu. Á nu metabbà sangaw yù tádday, anni panò yù akkuán na? Paggatangan na yù isingan, á aleran na. Kuregán na yù ngámin nga unak na bale na áddè ta arán na pakálek kuna! ");
INSERT INTO att_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Á pakálek nayù babay sù pirâ na, agálán na yù ira kákkopun na ánna yù ira karúbá na, tapè makipabbúyá ira kuna. Á kagian na nira, ‘Mepagayáyâ kayu nikán, ta nálek ku yù pirâ ku nga netabbà,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Á kuruk yù kagiak ku, ta kunnay sù pagayáyâ da, kunnian gapay yù pagayáyâ nayù ira daroban ni Namarò megapu sù táttádday nga tolay nga mabbabáwi ánna likuránán na yù liwâ na.” ");
INSERT INTO att_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Á nagángngarigán paga si Apu Kesu, á kinagi na, “Ajjan yù tolay nga maríku, nga egga duá nga ánâ na nga lálláki. ");
INSERT INTO att_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Á yù anâ na nga urián, en na kinagi kâ yáma na, ‘Ammò, iyawâ mu nikán yù ballè sù kukuám,’ kun na. Á bille na laguk nayù yáma ra yù kukuá na sù ira duá nga ánâ na. ");
INSERT INTO att_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Á ari nabayák, á en na iniláku nayù urián yù ngámin nga balle na nga iniyawâ nayù yáma na, á inâ na yù kuártu, á nánaw, nga minay naggián ta arayyu nga lugár. Á ginástu na ngámin yù kuártu na sù narákè nga akkuán na. ");
INSERT INTO att_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Á ta kapunu na kuártu na, jimittál yù bisin tán nga lugár. Á yáyù nga nabbisin gapay yù bagitolay, gapu ta awánin bulubugá ta ipangâ na ta kanan na. ");
INSERT INTO att_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Á minay laguk nakiaripan sù tolay nga maggián táne lugár, á inipataron na kuna yù ira bábi na. ");
INSERT INTO att_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Á nepallà yù bisin nayù bagitolay, á ikáyâ na nakuan kumán sù ipamakán na sù ira bábi, ta awán bulubugá ta tolay nga mangiyawâ ta kanan na. ");
INSERT INTO att_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Á gapu ta nepallà yù bisin na, á ninonò na yù kaloku na, á nakemmunaw. Á kinagi na ta nonò na, ‘Aru yù ira mangallu kâ yámà, á massobará ira ngámin ta kanan. Ngam ajjanà saw nga magisassay matay ta bisin! ");
INSERT INTO att_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mattolingà laguk kâ Ammò, á kagiak ku sangaw kuna ta nakaliwákà kuna, á nepatalugáring kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Á kagiak ku gapay kuna ta nilonák ku yù pakáwayyâ nga mebiláng ta anâ na, tapè apan nangà ta makiaripan kuna,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Á pakanonò na karannian, gimikkáng nga nánaw táne lugár ta lubbè kâ yáma na. “Á pallakák nayù bagitolay paga ta dálan, á neripâ nayù yáma na nga arayyu paga sù bale na. Á nakkarerá nga en na jinápun yù anâ na, gapu ta nerallà yù allà na kuna. Á ináppungulán na, á inummatán na. ");
INSERT INTO att_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Á kinagi nayù bagitolay sù yáma na, ‘Ammò, nakaliwákà nikaw, á nepatalugáring kâ Namarò, á aringà mepángngà nga mebiláng ta anâ mu,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngam yù yáma na, inagálán na yù ira aripan na, á kinagi na nira, ‘Alistuán naw nga umay mangâ ta barawási nga kapiánán, ta barawasián naw. Á passapátukan naw ánna passákkalángan naw gapay. ");
INSERT INTO att_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Á kabalin naw mamarawási, apan naw yù kígaw nga báka nga matabá, ta pártian naw. Ta kumán ittam nga mappabbúyá, ");
INSERT INTO att_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","gapu ta yawe anâ ku yù kunnay ta natay, ngam kun na naginnanolayin. Á kunnay ta nagawáwán, ngam náleránin,’ kun na. Á yáyù nga nappakán ira ánna nappabbúyá. ");
INSERT INTO att_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Á pappabbúyá ra, limibbè yù kaká nga anâ na nga naggapu ta ákkomanán nayù yáma na. Á pakáranni na sù bale ra, nakaddák sù pakaginná na ta paggássá ra ánna pattatála ra. ");
INSERT INTO att_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Á inagálán na yù tádday nga aripad da, á iniyabbû na kuna nu anni yù akkuád da. ");
INSERT INTO att_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Á kinagi nayù aripan kuna, ‘Limibbè yù uriám mu, á inipapárti nayù yámam yù kígaw nga natabá, gapu ta napalabbè na nga napiá gawagawáyán na.’ ");
INSERT INTO att_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Á pakaginná nayù kaká karannian, nappattunnuk, á ari simillung sù balay gapu ta pore na. Á pakasingan nayù yáma na nga ajjan ta lawán yù anâ na nga kaká, á en na laguk patallungan. ");
INSERT INTO att_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngam simibbák sù yáma na, á kinagi na, ‘Pígiá nga dagunin yù pattarabákù nikaw ánna arát taka bulubugá pinotuán! Ngam arám mà bulubugá paga iniddán ta mássiki kajjing nga ipappabbúyá mi sù ira kákkopuk ku. ");
INSERT INTO att_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ngam yawe anâ mu, ginástu na yù ngámin nga kukuám sù ira minákkikarallaw. Á aggina yù inipártiám mu sù kígaw!’ kun na. ");
INSERT INTO att_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Á kinagi nayù yáma na kuna, ‘Anâ ku, sigídá ka nga maggián nikán, á kukuám ngámin yù kukuâ. ");
INSERT INTO att_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngam napiá nu mappabbúyá ittam nga magayáyâ, gapu ta nakalabbè galâ yù wagim nga kunnay ta natay, ngam matolay. Á kunnay gapay ta nagawáwán, ngam nálegin.’ ” ");
INSERT INTO att_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Á nagángngarigán paga si Apu Kesu, á kinagi na sù ira makituddu kuna, “Ajjan yù tolay nga maríku nga ajjan kuna yù maggián nga manaron ta ngámin nga kukuá na. Á ajjan yù ira minay nangiránuk sù maríku ta ginástu nayù minákkárgu yù nekárgu kuna. ");
INSERT INTO att_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Á pakaginná nayù maríku, inipágál na, á kinagi na kuna, ‘Anni yawe naginnâ nga kingnguám sù inikárgù nikaw? Arà! Itúrâ mu laguk yù ngámin nga kingnguám sù kukuâ, ta mapatalián ka sangaw,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Á pakánnámmu nayù minákkárgu ta mári sù tarabáku na, ninonò na, nga kun na, ‘Á kunnasi laguk yù áttolè, ta irián nangà sangaw nayù yápù sù tarabákù? Á anni yù akkuák ku, ta nakapi yù baggì nga makkomán, á mappasiránà makilimù!’ kun na. ");
INSERT INTO att_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Á pakanonò na, kinagi na, ‘E, ajjan yù akkuák ku, tapè ajjan yù ira kákkopuk ku nga mangilágum nikán sangaw nu máringà sù tarabákù,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Á kunniaw yù kingnguá na laguk, ta inipágál na yù ira ággitádday nga naggagatù sù yápu na. Á labbè nayù mapolu, kinagi na kuna, ‘Pígiá yù gatù mu sù yápù?’ ");
INSERT INTO att_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Á kinagi na, ‘Magatù nga láta nga denu,’ kun na. Á kinagi nayù minákkárgu kuna, ‘Ajjan saw yù risíbum. Apam mu, ta alistuám nga ulian, ta itúrâ mu yù límápulu lâ nga láta,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Á manganánnuán, minay yù tádday, á kinagi na gapay kuna, ‘Pígiá yù gatù mu sù yápù?’ Á kinagi na, ‘Magatù nga kaban nga baggâ.’ Á kinagi na kuna, ‘Á apam mu laguk yawe risíbum ta uliam mu, ta itúrâ mu yù walupulu lâ.’ ");
INSERT INTO att_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Á pakánnámmu nayù yápu na sù kingnguá nayù narákè nga aripan na, á kinagi na, ‘Ye, masírik yù tolay, ta ammu na nga paránan yù pakkatolayán na!’ ” Á kinagi ni Apu Kesu nira, “Napiá yù ánnonò nayù minákkárgu nga nangilogò, nga kunnay sù ira ari manguruk kâ Namarò, ta masírik ira ánnè sù ira manguruk kâ Namarò, gapu ta ammu ra iyusá yù kukuá ra, tapè napiá yù ággiád da. ");
INSERT INTO att_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Á yawe laguk yù itabarang ku nikayu ta napiá nu iyusá naw yù kukuá naw sawe dabbuno ta ángngabbák naw sù ira kábulun naw, tapè sangaw nu mapúnu, á mapaddulò kayu sù mannanáyun nga paggianán naw ta lángì.” ");
INSERT INTO att_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Á kinagi na paga ni Apu Kesu, “Á yù tolay nga ammu na manaron sù baddì nga mekatalà kuna, ammu na gapay manaron sangaw nu aru yù mekatalà kuna. Ngam yù tolay nga arán na ammu manaron ta baddì, kunnian gapay yù akkuán na, nu aru nakuan yù mekatalà kuna. ");
INSERT INTO att_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Á sikayu gapay, nu ari napiá yù ánnaron naw sù mekatalà nikayu sawe dabbuno, egga panò yù mangikatalà nikayu sù kukurugán nga karíku naw nga mannanáyun ta lángì? Awán! ");
INSERT INTO att_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Á nu ari kayu mekatalà nga manaron sù kukuá na tanakuán nga mepataron nikayu, egga panò yù mangiyawâ nikayu, tapè ajjan yù kukuá naw lápay? Awán! ");
INSERT INTO att_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Á awán ta tolay nga makapasserbi sù duá nga yápu na, gapu ta ayatan na yù tádday ánna ikalusso na yù tádday. Á nu pakimorayán na yù tádday, iluddè na yù tádday. Á kunnay gapay nikayu, ari kayu makapasserbi kâ Namarò nu yá lâ ikáyâ naw yù kuártu ánna yù kegatángán na sawe dabbuno.” ");
INSERT INTO att_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Á yù ira Parisio, nakaginná ra sù kinagi ni Apu Kesu, á inuyoyungád da, gapu ta kitokkuk ira ta kuártu, á yáyù lâ ikáyâ da. ");
INSERT INTO att_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Á kinagi ni Apu Kesu nira, “Sikayu, agippípiá kayu, ta ipasingan naw sù ira tatolay yù piá naw, ngam ammu ni Namarò yù nonò naw! Á yù mappeddaráyaw ánna yù agippípiá, nga mepotun sawe dabbuno, aggira yù ikálirák ni Namarò.” ");
INSERT INTO att_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Á kinagi na gapay ni Apu Kesu, “Yù tunung nga inituddu ni Moyses ánna yù inituddu nayù ira ngaw ábbilinán ni Namarò, yáyù sinuttul nayù ira tatolay áddè ngaw, ta áddè ta dattál ni Kuan nga Minánnigù. Ngam dattál ni Kuan, pinegapuanán na mangilayalayâ sù napiá nga dámak nga meyannung sù pammagure ni Namarò, á aru laguk yù ira nga mapattû nga mesipà kuna. ");
INSERT INTO att_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngam yù tunung nga inituddu ni Moyses, ari mapangarián, mássiki nu baddì lâ. Á lummà yù lángì ánna dabbuno lage na pangarián nayù tunung ni Moyses. ");
INSERT INTO att_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Á ginnán naw yù tunung. Nu igúnge na laláki yù atáwa na pángè na mangatáwa ta tanakuán, á mangarallaw. Á nu mangatáwa yù laláki ta babay nga negúngay ta atáwa na, á mangarallaw gapay.” ");
INSERT INTO att_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Á kinagi na paga ni Apu Kesu, “Ajjan yù tolay nga maríku nga nabbísti ta kunnay ta patul, nga mappabbúyá nga mappakán ta kággággaw. ");
INSERT INTO att_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Á ajjan gapay yù pobare nga mangngágan ta Lasaru, nga nallutulutu yù baggi na, á ta kággággaw iyánge ra nga peddád da lâ ta aranni sù áttallungán na bale nayù maríku, ");
INSERT INTO att_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ta iddanamán na ta iyawâ da yù buttá ra kuna. Á minay yù ira ítu nga najjijjil sù lutu na. ");
INSERT INTO att_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Á manganánnuán, natay yù pobare. Á yù ira daroban ni Namarò, inâ da yù ikararuá nayù pobare ta makipabbúyá sù giád di Kákay Abrakam. Á manganánnuán, natay gapay yù maríku, á initanam da. ");
INSERT INTO att_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Á yá labbetán nayù ikararuá nayù maríku yù impiernu. “Á karigirigâ nayù maríku ta impiernu, nattánguk ta arayyu, á nasingan na di Kákay Abrakam kâ Lasaru nga namerik kuna. ");
INSERT INTO att_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Á kinatolán nayù maríku laguk si Kákay Abrakam, á kinagi na, ‘Kákay Abrakam, ikállà mà ta dobam bì si Lasaru, ta en na pasínatán yù jilâ ta danum, tapè malannáwán, ta marigirigákà sawe api,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngam kinagi ni Abrakam kuna, ‘Ilû, nonotam mu ta aru yù napiá nga nálâ mu ngaw sù katolem ta dabbun. Ngam si Lasaru, narigirigâ ngaw. Á kunangane, nabannáyánin saw nga magayáyâ si Lasaru, á sikaw, maparigirigâ ka. ");
INSERT INTO att_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Á nepatalugáring ta awán ta awayyá mi nga mangabbák nikaw, ta ajjan yù aláwa nga abbû nga namassinná nittam, á awán ta makángay tán nga maggapu saw, á awán gapay ta makángay saw nga maggapu tán.’ ");
INSERT INTO att_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Á kinagi na laguk nayù ngaw maríku, ‘Á Kákay, ikállà mà bì, á dobam bì si Lasaru ta bale nayù yámà, ");
INSERT INTO att_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta en na kagian sù ira límá nga wáwwagì ta pataliád da yù narákè nga ággangnguá ra, tapè ari ira gapay lubbè sawe giák ku, nga gián na jigâ,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngam kinagi ni Abrakam kuna, ‘Ajjan nira yù inipetúrâ na ngaw ni Namarò kári Moyses ánna yù ira ábbilinán. Ajjan laguk yù awayyá ren nayù ira wáwwagim nga manguruk.’ ");
INSERT INTO att_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Á kinagi na, ‘Wan, Kákay, ngam arád da ira tángngagan. Á nu ajjan yù naginnanolay nga umay nira, ta ipakánnámmu na nira yù kuruk, á likuránád da támma yù liwâ da, á manguruk ira mápugák.’ ");
INSERT INTO att_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngam kinagi ni Abrakam kuna, ‘Nu arád da ginnán yù inituddu ni Moyses ánna yù ira káruán nga ábbilinán ni Namarò, arád da gapay kurugan nu umay nakuan yù naginnanolay nga makkagi nira.’ ” ");
INSERT INTO att_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Á kinagi ni Apu Kesu sù ira makituddu kuna, “Negagángay yù awayyá na tolay nga malliwâ. Ngam makállállà ira nga mamápáyâ ánna mangirudduák ta malliwâ yù ira kábulud da. Bay e! Kábbi ira! ");
INSERT INTO att_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ta más napiá nakuan nu igakkâ da yù ággilingán ta mangì sù bullo nayù tolay, á itabbà da ta bebay tapè matay, tapè awán ta mangituddu ta narákè sù ira kapángnguruk kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Magimuguk kayu laguk, ta arán naw tudduán ta narákè yù ira ikáttole naw. Á nu malliwâ yù kabbulun naw, gammán naw. Á nu mabbabáwi ta liwâ na, pakomán naw. ");
INSERT INTO att_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Á nu ajjan yù tolay nga mameppitu nga malliwâ nikayu ta tangággaw, á mameppitu nga mattotoli nikayu nga makipakomá, máwák naw pakomán.” ");
INSERT INTO att_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Á yù ira sinudduán ni Apu Kesu, kinagi ra kuna, “Apu, pasikanam mu bì yù ángngikatalà mi kâ Namarò.” ");
INSERT INTO att_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Á kinagi ni Apu, “Mássiki nu makapi paga yù ángngikatalà naw, nga kunnay ta kabajjitán nga bini, á ajjan nakuan yù awayyá naw nga makkagi sawe káyu, ‘Mabaddul ka nga meyalì nga memulá ta bebay!’ á mapalurò!” ");
INSERT INTO att_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Á kinagi ni Apu Kesu, “Á ta ángngarigán nu ajjan yù tolay nga egga yù aripan na, á mattarabáku yù aripan na sù ákkomanán nayù yápu na onu manaron sù ayám na. Á sangaw nu púgák, lubbè ta balay nga maggapu sù ákkomanán. Á anni panò yù kagian nayù yápu na kuna? Kagian na panò ta umay kumán? ");
INSERT INTO att_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ari gemma, ngam kagian na galâ, ‘E ka bì mabbaggaw, á pataliám mu yù barawásim, á magapi ka tapè kumánà, ta sikán yù mapolu nga kumán, á ta kabalik ku kumán, á kumán ka gapay,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Á ta ángngarigán nu tuppálan nayù aripan yù ipakuá nayù yápu na kuna, dayáwan na panò nayù yápu na? Ari gemma, ta yáyù gemma yù tarabáku nayù aripan. ");
INSERT INTO att_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Á sikayu gapay, ta kabalin naw manuppál sù ngámin nga ipakuá ni Namarò nikayu, á kagian naw lâ, ‘Ara-aripan kami lâ, á sinuppál mi lâ yù inipakuá na nikami nayù yápu mi megapu sù allà na nikami.’ ” ");
INSERT INTO att_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Á sù ánge ri Apu Kesu ta Jerusalem, nallakák ira sù lállátán na purubinsia na Samaria ánna Galilia. ");
INSERT INTO att_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Á pakáranni ra ta tádday nga babálay, nerapunád da yù mapulu nga tatolay nga naggoggong, ngam arayyu lâ yù nanáddagád da. ");
INSERT INTO att_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Á kinatolád da si Apu Kesu, á kinagi ra kuna, “Mesturu, ikállà kami bì!” kud da. ");
INSERT INTO att_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Á pakasingan ni Apu Kesu sù ira naggoggong, kinagi na nira, “E kayu sù ira pári, tapè innad da yù baggi naw,” kun na. Á sù pappángè da nga umay sù pári, ikáddagâ lâ nammapiá iren. ");
INSERT INTO att_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Á yù tádday nira, pakasingan na ta nammapiá ngin, dagarágâ nanoli, nga makkatakatol sù áddáyo na kâ Namarò. ");
INSERT INTO att_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Á pakáddè na kâ Apu Kesu, namalittúkak ta arubáng na nga nabbalabálà. Á yane tolay nga nanoli nga nabbalabálà kâ Apu Kesu, aggina yù taga Samaria nga ari Kudio, nga ikalusso nayù ira Kudio. ");
INSERT INTO att_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Á kinagi ni Apu Kesu sù ira mepulupulù kuna, “Ari panò mapulu yù ira nammapiá? Á ajjan saw yù tádday. Isaw giád da panò nayù ira siám? ");
INSERT INTO att_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Á ngattá, ta yawe lâ nga ari Kudio yù nattoli nga maddáyaw kâ Namarò!” ");
INSERT INTO att_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Á kinagi na gapay sù tolay, “Gumikkáng ka, ta mánaw ken, ta nammapiá ken megapu sù ángngikatalà mu nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Á ajjan yù ira Parisio nga minay nangiyabbû kâ Apu Kesu nu káni yù dattál nayù pammagure ni Namarò. Á simibbák si Apu Kesu, á kinagi na, “Awán bulubugá ta pakasinganán naw sù dattál nayù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Á ari makagi na tolay ta ajjan saw onu ajjan tán, gapu ta ajjanin galâ sù nonò nayù ira manguruk.” ");
INSERT INTO att_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Á kinagi ni Apu Kesu sù ira makituddu kuna, “Mapattû kayu sangaw nga maningan sù mássiki lâ tádday nga ággo nayù pammagurè saw dabbuno, sikán nga Kaká na ngámin na tatolay, ngam arán naw masingan. ");
INSERT INTO att_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Á sangaw ajjan yù ira umay makkagi ta ‘Ye, ajjan tán!’ Onu kagiad da, ‘Ajjan saw!’ Ari kayu mepulù nira! Arán naw pasikkálan! ");
INSERT INTO att_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta kunnay ta kilâ nga mamannawák ta lángì, kunnian sangaw yù pattolì ta dabbuno, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngam máwák ta olu nga attamák ku yù aru nga panigirigâ da nikán ánna panakì da nikán nayù ira tatolay nga matolay ta ággawo. ");
INSERT INTO att_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Á noka nu maddaggunà mattoli, sikán nga Kaká na ngámin na tatolay, á naggittá yù kustombare nayù ira tatolay sù kustombare ra ngaw ta keggá ra ngaw di Noe. ");
INSERT INTO att_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta yá lâ sinángngák da ngaw yù pakkákád da, pamissád da ánna pangatáwa ra, áddè ta ággaw nga pamatallung ni Namarò kári Noe sù dakal nga barangay. Á jimittál yù paddakal na danum, á nalítù yù dabbun, á neburuk yù ira tatolay nga ari simillung sù barangay, á nalaggabán ira. ");
INSERT INTO att_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Á kunnay gapay sù kingnguá ra ngaw ta keggá ri Lot, ta sinángngák da lággapay yù pakkákád da, pamissád da, paggatagátáng da, pallakaláku ra, pammulá ra, ánna pabbalabale ra. ");
INSERT INTO att_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Á kapállikuk di Lot nga nánaw ta ili na Sodoma, ikáddagâ lâ ajjan yù api ánna asupri nga naggapu ta lángì, nga nappannâ sù ili na Sodoma, á natuggi yù ira ngámin nga tatolay tán. ");
INSERT INTO att_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Á kunnay sù kustombare ra ngaw nayù ira tatolay ta keggá ri Lot, kunnian gapay sangaw yù ággaw nga pattolì, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Á yáyù nga pappalánat takayu, ta sangaw nu duttál yù ággaw, á yù ira tatolay nga ajjan ta lawán na bale ra, ari iren nakuan tullung nga umay mangâ sù kukuá ra. Á yù ira nga ajjan ta ákkomanád da, ari ira nakuan lubbè. ");
INSERT INTO att_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Á nonotan naw yù ngaw atáwa ni Lot, tapè arán naw párigán! Ta pattálo ra ta ili na Sodoma, ninonò na lâ nayù babay yù kukuá na, á arán na kinuruk yù kinagi ni Namarò. Á nabbáli ta asin nga nanáddak ta kun na kallang. ");
INSERT INTO att_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Á yù tolay nga mangiddù ta baggi na ta dabbuno, á matay gemma galâ. Ngam yù tolay nga mangitapil sù baggi na megapu sù ángnguruk na kâ Namarò, napiá yù ággián na, ta mesipà kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Á kagiak ku nikayu, ta ángngarigán nu gabi yù tappì ku, á nu ajjan duá nga tolay nga madduruk nga makkaturuk, á málâ yù tádday, á mabattáng yù tádday. ");
INSERT INTO att_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Á kunnay gapay sù ira duá nga bábbay nga mabbáyu, ta málâ yù tádday á mabattáng yù tádday. ");
INSERT INTO att_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Á mássiki yù ira duá gapay nga mattarabáku sù ákkomanán, málâ yù tádday á mabattáng yù tádday.” ");
INSERT INTO att_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Á yù ira makituddu kâ Apu Kesu, pakaginná ra karannian, kinagi ra kuna, “Apu, isaw gián na?” Á kinagi na, “Yù gián nayù natay, yáyù pagunnurán nayù ira bukkaw.” ");
INSERT INTO att_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Á nagángngarigán si Apu Kesu sù ira makituddu kuna, ta ituddu na nira ta máwák da nga ari malurâ nga makimállà kâ Namarò, á ari ira mabbábáng sù ángngikatalà da kuna. ");
INSERT INTO att_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Á kinagi ni Apu Kesu, “Ajjan sù tádday nga ili yù kues nga ari bulubugá maganássing kâ Namarò, á arán na gapay pakimorayán yù ira kábulun na nga tatolay. ");
INSERT INTO att_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Á táne ili, ajjan yù babay nga bálu nga sigídá nga umay sù kues, á kagian na kuna, ‘Abbágám mà bì, ta ajjan yù tolay nga iddâ nangà lâ ikeká, nga awánà gemma ta liwâ,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Á ta olu, arán na sinángngák nayù kues. Ngam manganánnuán, ninonò na, nga kun na, ‘Mássiki arák ku ikássing si Namarò ánna awán ta pasirák ku sù ira ikáttolè, ");
INSERT INTO att_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ngam panunnuták ku yù mangikeká sù babay, marakè makkara-ángay yù babay nikán, áddè ta arák ku kalurâ!’ ” ");
INSERT INTO att_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Á kabalin na nagángngarigán ni Apu Kesu, á kinagi na, “Naginná naw yù kingnguá nayù kues, ta mássiki nu arán na inabbágán yù babay ta olu nga ánge na kuna, ngam inabbágán na galâ. ");
INSERT INTO att_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Á nepatalugáring kâ Namarò, ta ari panò dán nga naparán nga mangabbák sù ira tatole na, nga sigídá makimállà kuna ta ággaw ánna gabi? Abbágán na ira gemma, á arán na ira ikikkítulán. ");
INSERT INTO att_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta kuruk yù kagiak ku nikayu, ta dagarágâ nga abbágán ni Namarò yù ira tatole na. Ngam sangaw nu mattolingà ta dabbuno, sikán nga Kaká na ngámin na tatolay, ajjan panò sangaw yù ira marángnganák ku nga manguruk nikán? Baddì ira lâ, ta aru yù ira manakì nikán.” ");
INSERT INTO att_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Á nagángngarigán si Apu Kesu, ta ammu na ta ajjan yù ira makkagi ta aggira yù kapiánán, á iluddè da yù ira kábulud da. ");
INSERT INTO att_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Á kinagi ni Apu Kesu nira, “Ajjan yù duá nga lálláki nga minay sù mangilin nga kapilliá ta Jerusalem, tapè makimállà ira. Á Parisio yù tádday, á yù tádday yù mináttuki ta buwì. ");
INSERT INTO att_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Á minárayyu yù Parisio ta baddì sù mináttuki ta buwì, á nanáddak nga nakimállà, á kinagi na, ‘Apu Namarò, mabbalabálakà nikaw ta aringà negittá sù ira káruán, ta aringà mokkuk, aringà massiri, aringà minángngarallaw, á aringà gapay negittá táne tolay nga mináttuki ta buwì. ");
INSERT INTO att_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Á sikán, mamidduángà nga ari kumán ta tangaligguán tapè makimállakà. Á iyawâ ku nikaw yù mekamapulu sù ngámin nga málâ ku,’ kun na. Yáyù yù ákkimállà nayù Parisio. ");
INSERT INTO att_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ngam yù tolay nga mináttuki ta buwì, minay nanáddak ta arayyu, á nakkummak ánna kidduk na yù gáko na, gapu ta maraddam sù liwâ na. Á kinagi na, ‘Apu Namarò, ikállà mà bì, ta minálliwákà!’ kun na. ");
INSERT INTO att_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Á kuruk yawe nga kagiak ku nikayu, ta pinakomá ni Namarò galâ yù mináttuki ta buwì ánnè sù Parisio. Á yù ira nga mappeddaráyaw, aggira yù mepasiránán ta arubáng ni Namarò. Ngam yù tolay nga tumulù, nga makipakomá kâ Namarò sù liwâ na, aggina yù meparáyaw.” ");
INSERT INTO att_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Á tádday ággaw sù arád da paga pakáddè di Apu Kesu ta Jerusalem, á minay yù ira tatolay nga iniyánge ra yù ira ánâ da kâ Apu Kesu, tapè ipotun na yù limá na sù ira ábbing ta kunnay ta kustombare ra, á kagian na yù pangiddù ni Namarò nira. Á yù ira makituddu kâ Apu Kesu, nasingad da yù pangiyánge ra sù ira ábbing, á gimmá ra ira. ");
INSERT INTO att_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngam inagálán ni Apu Kesu yù ira ábbing, á kinagi na sù ira makituddu kuna, “Arán naw gammán yù ánge nayù ira ábbing nikán, ta yù ira tatolay nga kunnay nira, aggira yù mesipà sù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Á kuruk yawe nga kagiak ku nikayu, nu ari kayu tumulù nga mangikatalà kâ Namarò ta kunnay sù ángngikatalà na abbing, ari kayu bulubugá mesipà sù pammagure na.” ");
INSERT INTO att_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Á minay kâ Apu Kesu yù tádday nga Kudio nga makáwayyá, á kinagi na, “Mesturu, sikaw yù kapiánán nga mangituddu. Á anni laguk yù akkuák ku, tapè mesipakà kâ Namarò ta áddè ta áddè?” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Á kinagi ni Apu Kesu kuna, “Ngattá, ta kagiam mu ta sikán yù kapiánán? Awán bulubugá ta kapiánán, nu ari lâ si Namarò! ");
INSERT INTO att_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Á ammum gemma yù tuttulam mu nakuan nga tunung ni Namarò: Ari ka mangarallaw, ari ka mamapátay, ari ka makkokò, ari ka massirisiri, á pakimorayám mu yù ira darakal mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Á kinagi nayù tolay, “Wan, á sinuppál ku ngámin dannian áddè sù kabaddì ku,” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Á kinagi ni Apu Kesu kuna, “Ajjan lâ paga yù akkuám mu nakuan, ta em mu iláku yù ngámin nga kukuám, á isinek mu yù pallakuám mu sù ira magáwák, tapè ajjan yù táli nayù kukuám nga pakappián ni Namarò ta lángì. Á kabalim mu manuppál karannian, umay ka laguk tumuttul nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngam ta pakaginná nayù tolay sù kinagi na, nerallà yù daddam na, gapu ta aru yù kukuá na. ");
INSERT INTO att_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Á pakasingan ni Apu Kesu ta maraddam yù maríku, kinagi na sù ira makituddu kuna, “Marigâ garè nga tumulù yù maríku kâ Namarò, tapè mesipà nakuan sù pammagure na. ");
INSERT INTO att_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Á ta ángngarigán, kunnay ta karigâ na labbû na dakal nga ayám nga kamel sù abbû na dágum, á kunnian gapay, marigâ yù kesipà nayù maríku sù pammagure ni Namarò.” ");
INSERT INTO att_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Á napállâ yù ira nakaginná sù kinagi na. Á kinagi ra, “Á nu arán na awayyá na maríku nga mesipà sù pammagure ni Namarò, á asinni laguk yù mesipà?” ");
INSERT INTO att_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Á kinagi ni Apu Kesu nira, “Mássiki nu arán na awayyá na tolay nga palurotan, awayyá ni Namarò nga palurotan. Á yáyù nga meyígù yù ira ngámin nga manguruk kuna, mássiki nu maríku onu pobare,” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Á kinagi ni Eduru, “Apu, nonopam mu kami, ta nánawám mi ngámin, tapè tumuttul kami nikaw.” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Á kinagi ni Apu Kesu nira, “Kuruk yawe nga kagiak ku nikayu, ta nu pánawán na tolay yù bale na, atáwa na, wáwwagi na, darakal na, onu ánâ na tapè mesipà sù pammagure ni Namarò, ");
INSERT INTO att_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","á aru yù bálà na nga napiá nga meyawâ kuna ta paggián na paga ta dabbuno ánnè sù nánawán na, á mepattolay noka kâ Namarò ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Á si Apu Kesu, inilillì na yù ira mapulu duá nga sinudduán na, á kinagi na nira, “Ginnán naw bì yù kagiak ku, ta umay ittam ta Jerusalem. Á tappì tam tán, mapalurò yù ngámin nga inipetúrâ na ngaw ni Namarò sù ira ábbilinán na, nga mesimmu nikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta gaputad dangà sangaw, á iyawâ dangà sù ira ari Kudio. Á uyu-uyawad dangà, pakkakagiád dangà, ánna pallulutábád dangà. ");
INSERT INTO att_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Á palapaligatad dangà, á papatáyad dangà. Ngam maginannolayà ta mekatallu nga ággaw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngam arád da bulubugá nánnámmuán nayù ira sinudduán na yù kinagi na, gapu ta kunnay ta monak nga nelímak nira, á arád da nánnámmuán yù kebalinán na. ");
INSERT INTO att_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Á paddaggud di Apu Kesu tumunù sù ili na Jeriku, ajjan yù tolay nga buling nga nagitubang nga makilimù ta aggik na dálan. ");
INSERT INTO att_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Á ta pakaginná nayù buling ta aru yù ira tatolay nga mattalebák, á kinagi na, “Anni yù nesimmu? Ngattá, ta aru yù mattatalebák?” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Á kinagi ra kuna, “Mattalebák si Apu Kesu nga taga Nasaret,” kud da. ");
INSERT INTO att_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Á nakkatol, á kinagi na, “Apu Kesu, nga ginaká ni Patul Dabid, ikállà mà bì!” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Á yù ira tatolay nga napolu, gimmá ra, á kinagi ra, “Magimammà ka!” kud da. Ngam iniyássikan na nakkatol, nga kun na, “Sikaw nga ginaká ni Patul Dabid, ikállà mà bì!” ");
INSERT INTO att_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Á pakaginná ni Apu Kesu sù pakkatol nayù buling, á nagginnà, á kinagi na nira ta iyánge ra yù buling kuna. Á pakerakkì da kuna, nagiyabbû si Apu Kesu sù buling, ");
INSERT INTO att_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Anni yù ikáyâ mu nga akkuák ku megapu nikaw?” Á kinagi na, “Apu, gustù ta makasinganakin,” kun na. ");
INSERT INTO att_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Á kinagi ni Apu Kesu kuna, “Wan. Makasingan ken laguk, ta napammapiá ken megapu sù ángngikatalà mu nikán.” ");
INSERT INTO att_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Á dagarágâ nakasingan, á nepattututtul nira nga maddáyaw kâ Namarò. Á yù ira tatolay, naddáyaw ira gapay kâ Namarò gapu ta nasingad da yù nesimmu. ");
INSERT INTO att_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Á nattalebák di Apu Kesu ta ili na Jeriku. ");
INSERT INTO att_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Á ajjan tán yù tolay nga maríku nga mangngágan ta Sakio. Aggina yù tádday nga kátannangán nayù ira mináttuki ta buwì. ");
INSERT INTO att_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Á gustu na nga innan si Apu Kesu, ngam awán ta awayyá na, gapu sù káru nayù ira tatolay ánna alinnâ garè si Sakio. ");
INSERT INTO att_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Á yáyù nga nakkarerá nga napolu nga nakkalay ta káyu, tapè masingan na sangaw nu mattalebák tán. ");
INSERT INTO att_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Á pakáddè ni Apu Kesu ta káyu nga gián ni Sakio, á nattánguk, á kinagi na kâ Sakio, “Á apurám mu ámmutták, ta ek ku ta balem magammâ!” kun na. ");
INSERT INTO att_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Á dagarágâ gimitták si Sakio, á ayatán nga mamaddulò kuna. ");
INSERT INTO att_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Á pakasingan nayù ira tatolay ta minay si Apu Kesu sù bale ni Sakio, naddagaragim ira, á kinagi ra, “Ngattá, ta makiálliuk yawe tolay sù bale nayù minálliwâ!” kud da. ");
INSERT INTO att_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngam si Sakio, nanáddak ta arubáng nayù ira tatolay, á kinagi na kâ Apu Kesu, “Apu, iyawâ ku yù gadduá nayù ngámin nga kukuâ sù ira pobare. Á yù sinuítì ku, taliák ku ta taggiappâ yù taggitádday,” kun na. ");
INSERT INTO att_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Á pakaginná ni Apu Kesu sù kinagi ni Sakio, nga italákkuruk na, á kinagi ni Apu Kesu kuna, “Sakio, kunangane ta ággawo meyígù kayin ánna yù ira kábbalem! Á ari kayu mekanakanâ sù pamagikáru ni Namarò ta tolay, gapu ta negittá yù ángngikatalà mu kâ Namarò sù ángngikatalà ni Abrakam. Yáyù nga mepasingan ta kuruk nga ginaká na ka ni Abrakam. ");
INSERT INTO att_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Á yáyù nga minayà saw, sikán nga Kaká na ngámin na tatolay, ta ek ku agálán ánna iyígù yù ira tatolay nga nagawáwán megapu sù liwâ da, tapè umay ira makiyápu kâ Namarò ánna mesipà ira kuna.” ");
INSERT INTO att_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Á pallakák di Apu Kesu ta dálan, maddaggun ira nga makáddè ta Jerusalem. Á yù ira tatolay, gininná ra ta napiá yù kinagi ni Apu Kesu, ta kagiad da ta sangaw nu makalabbè ira ta Jerusalem, yáyù pamegapu nayù pammagure ni Namarò ta dabbuno. Á yáyù nga nagángngarigán si Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Á kinagi ni Apu Kesu nira, “Ajjan yù tolay nga ginaká na patul nga nágalán ta umay ta arayyu nga páppatulán, tapè málâ na yù pakáwayyá na nga mappatul, á tapè manoli nga mammaguray sù gián na. ");
INSERT INTO att_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Á lage na mánaw sù gián na, inagálán na yù ira mapulu nga aripan na, á iniyawâ na nira nga katággitádday yù pirâ nga buláwán, á kinagi na nira, ‘Sù káwák ku, pagaruan naw yawe kuártu,’ kun na. Á nánaw. ");
INSERT INTO att_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Á yù ira káruán nga tatolay nga maggián sù lugár na, malussaw ira kuna. Á yáyù nga jinok da yù ira tumuttul kuna nga makkagi ta panakitád da nga mappatul nira. ");
INSERT INTO att_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Á mássiki nu manakì ira kuna, ngam nálâ na yù pakáwayyá na nga mappatul, á nanoli sù gián na. Á inipágál na yù ira aripan na nga iniddán ta pirâ, tapè ammu na nu pígiá yù naganánsiá ra. ");
INSERT INTO att_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Á minay yù tádday nga aripan, á kinagi na, ‘Apu Patul, nabbalin ta mapulu yù tádday nga pirâ nga iniyawâ mu nikán,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Á napiá yù kingnguám,’ kun nayù patul kuna. ‘Á sikaw yù napiá nga aripan. Á gapu ta pangikatalakán ka ta baddì nga inikatalà ku nikaw, á iyawâ ku nikaw yù pakáwayyám sù mapulu nga ili,’ kun nayù patul kuna. ");
INSERT INTO att_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Á manganánnuán, minay yù mekaruá nga aripan, á kinagi na, ‘Apu Patul, pinabbalik ku ta límá yù tádday nga iniyawâ mu nikán,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Á sikaw gapay, mammaguray ka laguk ta límá nga ili,’ kun nayù patul kuna. ");
INSERT INTO att_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Á minay yù tádday nga aripan ta arubáng nayù patul, á kinagi na, ‘Apu Patul, ajjan saw yù pirâ mu nga nabungun, nga pinakappiák ku, ");
INSERT INTO att_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","gapu ta maganássingà nikaw. Ta ammù ta mapporay ka nga maríku megapu sù bannák nayù ira káruán nga tatolay, ta apam mu ta kukuám yù arám mu pabbannagán,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Á kinagi nayù patul kuna, ‘Mapanunnután ka megapu sù kinagim, sikaw nga narákè nga aripan! Ta kinagim ta ammum ta sikán yù mapporay nga mangâ sù arák ku pabbannagán. ");
INSERT INTO att_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Á nu ammum yian, ngattá ta arám mu inibángku yù kuártù, tapè málâ ku yù baddì nga ganánsiá na sù panolì!’ ");
INSERT INTO att_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Á kinagi na laguk nayù patul sù ira nanáddak tán, ‘Apan naw yù kuártu na, á iyawâ naw sù tolay nga egga kuna yù mapulu,’ kun na. ");
INSERT INTO att_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ngam kinagi ra, ‘Á wan, Apu, ngam ajjanin gemma yù mapulu kuna!’ kud da. ");
INSERT INTO att_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Á kinagi nayù patul nira, ‘Wan, á kuruk yawe nga kagiak ku nikayu. Yù tolay nga mekatalà, nga napiá yù ángngiyusá na sù egga kuna, malannapán yù egga kuna. Ngam yù tolay nga ari napiá yù ángngiyusá na sù nekatalà kuna, mári kuna mássiki yù baddì nga nekatalà kuna. ");
INSERT INTO att_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Á yù ira nga malussaw nikán, nga nanakì ta sikán yù mammaguray nira, iyánge naw ira saw, tapè papatáyan naw ira ta arubáng ku.’ ” ");
INSERT INTO att_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kabalin na nagángngarigán ni Apu Kesu nira, á minay napolu nga mappángè ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Á pakarakkì da sù ira ili na Bepagi ánna Bitania, naginnà ira sù puddul nga mangngágan ta Olibo. Á inagálán ni Apu Kesu yù duá nga makituddu kuna, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mapolu kayu sù ili, á sù tallung naw, marángnganán naw yù kígaw nga kabáyu nga ari paga nattakayán. Ubbarán naw, á iyánge naw saw. ");
INSERT INTO att_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Á nu ajjan yù mangiyabbû ta anni má ta ubbarán naw, á kagian naw lâ kuna, ‘Máwák ni Apu,’ kun naw kuna.” ");
INSERT INTO att_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Á minay yù ira jinok ni Apu Kesu, á nálek da ngámin yù kunnay sù kinagi na. ");
INSERT INTO att_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Á pagubbák da sù kaddang nayù kígaw, iniyabbû na nira nayù makákkuá, “Anni má ta ubbarán naw?” ");
INSERT INTO att_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Á kinagi ra, “Máwák ni Apu.” ");
INSERT INTO att_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Á iniyánge ra yù kígaw kâ Apu Kesu. Á ininánnâ da yù gámì da sù barâ na, á pinakkabáyu ra si Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Á pakkabáyu na nga mappángè ta Jerusalem, ininánnâ nayù ira káruán nga tatolay yù gámì da ta dálan. ");
INSERT INTO att_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Á maddaggun nga makáddè di Apu Kesu ta ili na Jerusalem. Á kitáru yù ira nga mepulù kuna. Á utù da sù puddul na Olibo, namegapu ira ngámin nga ikatakatol da yù áddáyo ra kâ Namarò, gapu ta pagayáyâ da sù ngámin nga pinagaddátu na nga nasingad da. ");
INSERT INTO att_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Á kinagi ra, “Dayáwat tam yù Patul nga jinok ni Namarò, nga umay mammaguray nittam! Meparáyaw ta lángì si Namarò nga Kotunán, ánna napiá ánna magimammà yù gián na!” ");
INSERT INTO att_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Á yù ira káruán nga Parisio nga nepulù nira, gapu ta kagiad da ta tolay lâ si Apu Kesu, kinagi ra kuna, “Mesturu, gammám mu yù paddáyo nayù ira tatolay, ta malliwâ ira!” kud da. ");
INSERT INTO att_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Á simibbák si Apu Kesu, á kinagi na nira, “Kuruk yù kagiak ku nikayu, ta nu magimammà ira nakuan, á yù ira batu ta dálan yù makkatol nga maddáyaw kâ Namarò.” ");
INSERT INTO att_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Á pakáranni ra ta ili na Jerusalem, nasingan ni Apu Kesu yù ili, á nakalò yù pangikállà na sù ira tatolay nga taga Jesusalem, á nakkulè si Apu Kesu megapu nira. ");
INSERT INTO att_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Á kinagi na, “Sikayu nga taga Jerusalem, parè bì nakuan ta kánnámmuán naw yù paggapuán nayù ággimammà naw. Parè bì ta kánnámmuán naw yù máwák naw nga makipakomá kâ Namarò kunangane ta ággawo, tapè mapiá nakuan yù ággián naw kuna! Ngam awánin ta awayyá naw nga mánnámmuán, ta nelímak nikayu. ");
INSERT INTO att_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Á kábbi kayu, ta duttál yù ággaw nga umay yù ira malussaw nga makigerrá nikayu. Á alikúbungad da kayu, tapè ari kayu makalawán. ");
INSERT INTO att_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Á papatáyad da kayu ánna yù ira ánâ naw. Á bugayad da yù ngámin nga babále naw, á iwarawarâ da yù batu nga napadday ta balay, gapu ta panakì naw sù ánge ni Namarò nga mangiyígù nikayu!” ");
INSERT INTO att_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Á pakatunù di Apu Kesu ta Jerusalem, dagarágâ nga minay sù mangilin nga bale ni Namarò, á pinaturiák na yù ira nga malláku tán. ");
INSERT INTO att_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Á pamaturiák na nira, kinagi na nira, “Ajjan yù netúrâ nga kinagi ni Namarò, ‘Yù mangilin nga balè yù ákkimállatán nayù ira tatolay.’ Ngam sikayu, pabbalinan naw ta pallakuán nayù ira minángngilogò!” ");
INSERT INTO att_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Á ta kággággaw minay si Apu Kesu nga mangituddu sù mangilin nga bale ni Namarò. Á yù ira kátannangán nga pári ánna yù ira mangituddu sù tunung ni Moyses ánna yù ira tatolay nga makáwayyá, inigagánge ra ipapátay. ");
INSERT INTO att_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ngam arád da bulubugá paga makuá, gapu ta makkaragâ yù ira tatolay nga magginná sù ngámin nga kagian na. ");
INSERT INTO att_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Á tádday ággaw nga pangituddu ni Apu Kesu sù ira tatolay sù mangilin nga kapilliá, inilayalayâ na yù napiá nga dámak nga meyannung sù ángngiyígù ni Namarò. Á minay sù gián na yù ira kátannangán nga pári ánna yù ira mangituddu sù tunung ni Moyses ánna yù ira giriámán na Kudio. ");
INSERT INTO att_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Á kinagi ra kuna, “Asinni yù nangiyawâ nikaw sù pakáwayyám nga akkuám mu nga kunniaw? Asinni naddok nikaw?” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Á kinagi ni Apu Kesu nira, “Ajjan bì mapolu iyabbû ku nikayu nga tabbagan naw. ");
INSERT INTO att_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Isaw naggapuán nayù pakáwayyá ni Kuan nga Minánnigù? Jinok ni Namarò, onu tolay yù naddok kuna?” kun na. ");
INSERT INTO att_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Á nallillì ira laguk nga nakkaká-ubobuk nu anni yù itabbák da. Á kinagi ra, “Nu kagiat tam nakuan ta si Namarò yù naddok kâ Kuan, á iyabbû na sangaw nu anni má ta arát tam kurugan yù kinagi ni Kuan nga meyannung kâ Namarò? ");
INSERT INTO att_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngam máyâ panò nu kagiat tam ta tolay yù paggapuán nayù pakáwayyá na, marakè payangan nayù tatolay ittam? Ta kurugan nayù ira tatolay ta ábbilinán ni Namarò si Kuan,” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Á kabalid da nakkaká-ubobuk, kinagi ra galâ kâ Apu Kesu, “Arám mi garè ammu nu asinni yù naddok kâ Kuan.” ");
INSERT INTO att_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Á kinagi ni Apu Kesu nira, “Arák ku gapay kagian nikayu yù naggapuán nayù pakáwayyâ.” ");
INSERT INTO att_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Á nagángngarigán si Apu Kesu mángin sù ira tatolay, á kinagi na, “Ajjan yù tolay nga nammulá ta úbas. Á inipataron na yù kamulán na sù ira makirabbun, gapu ta ajjan yù angayán na ta arayyu nga lugár, á ammu na ta mabayák tán. ");
INSERT INTO att_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Á dattál na kapusik nayù bungá na úbas, jinok nayù makáddabbun yù tádday nga aripan na ta umay mangâ ta balle na. Á labbè na sù ira makirabbun, pinalapalù da, á pinapáno ra nga awán bulubugá ta iniyawâ da kuna. ");
INSERT INTO att_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Á jinok na yù mekaruá nga aripan na, ngam kunnay sù napolu, pinalapalù da má nga inipasiránád da, á pinapáno ra gapay nga awán bulubugá ta inâ na. ");
INSERT INTO att_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Á jinok na má yù mekatallu gapay. Á binigarád da ánna pinapáno ra má. ");
INSERT INTO att_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Á ninonò na laguk nayù makákkuá ta dabbun nu anni yù akkuán na. Á kinagi na, ‘Yawe yù akkuák ku. Dobak ku yù anâ ku nga iddukak ku, abernu pakimorayád da.’ ");
INSERT INTO att_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngam ta pakasingan nayù ira makirabbun sù anâ na, nakkaká-ubobuk ira, á kinagi ra, ‘Yawe yù pangiyawatán na sangaw nayù makákkuá sawe dabbun. Papatáyat tam laguk tapè kukuá tam yù dabbun na.’ ");
INSERT INTO att_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Á ginápù da, á inilawád da sù kamulán, á pinapáte ra. “Á gapu ta kunnian kingnguá ra, á anni panò yù akkuán nayù makákkuá ta kamulán sù ira makirabbun? ");
INSERT INTO att_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Á aggina laguk yù umay, á papatáyan na ira. Á ipataron na sangaw yù kamulán na sù ira tanakuán,” kun ni Apu Kesu. Á pakaginná nayù ira tatolay sù kinagi na, napállâ ira, á kinagi ra, “Ari lâ nakuan mesimmu!” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ngam inni-innan ni Apu Kesu ira, á kinagi na nira, “Nu ari nakuan kunnian yù mesimmu, á anni panò yù kebalinán nayù dán nga inipetúrâ ni Namarò? ‘Yù batu nga inipuerá nayù ira mabbalay, aggina yù sinullà ni Namarò nga panáddagán nayù balay.’ ");
INSERT INTO att_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Á yù ira tatolay nga mangipuerá sù sinullà ni Namarò nga meyárik ta batu, á kunnay ira ta napannâ nga makattakattu ta batu. Á yù ira nga kunnay ta napannátán nayù batu, kunnay ira ta marappì nga maburâ.” Á yá kebalinán na, si Apu Kesu yù awayyá ra nga pakiyígután. Á nu lonád da yù awayyá ra, ari ira makipakomá kâ Namarò, á maggián ira lâ nga ari napakomá yù liwâ da, á mekanakanâ ira sù pore ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Á yù ira mangituddu sù tunung ni Moyses ánna yù ira kátannangán nga pári, ammu ra ta aggira yù inubobuk ni Apu Kesu sù ángngarigán na, á nappanà yù lusso ra kuna. Á gaputad da nakuan, ngam arád da pinalurò gapu ta maganássing ira sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Á yáyù nga sinissimmurád da. Á inagálád da yù ira nga jinok da ta umay ira manukuk kuna. Á áppè pípiá ira nga magiyabbû kuna, tapè málek da yù awayyá ra nga mangikeká kuna ta arubáng nayù gubinador. ");
INSERT INTO att_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Á jimikkì ira laguk kâ Apu Kesu, á kinagi ra kuna, “Mesturu, ammu mi ta matunung yù ngámin nga ituddum ánna ngámin nga kagiam mu, á arám mu irumá yù ira tatolay, ta ituddum yù napiá nga ure ni Namarò nga ipatuppál na nittam. ");
INSERT INTO att_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Á yáyù nga iyabbû mi nikaw, ari panò mekontará sù tunung ni Moyses nu mappagá ittam ta buwì kâ Patul Sisar ta Roma?” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Á natákál ni Apu Kesu yù ángngilogò nayù ira nagiyabbû, á yáyù nga kinagi na nira, ");
INSERT INTO att_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipasingan naw bì nikán yù pirâ nga ipappagá naw nakuan ta buwì.” Á pakasingan ni Apu Kesu sù pirâ, iniyabbû na nira, “Asinni yù makámmammang ánna makángngágan nga nemárká sawe pirâ?” kun na. “Si Patul Sisar,” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Á kinagi ni Apu Kesu nira, “Wan gemma! Á yáyù nga mappagá kayu ta buwì sù patul, ta kukuá na gemma. Á kunnian gapay sù kukuá ni Namarò, ta iyawâ naw gapay kuna yù kukuá na,” kun na. ");
INSERT INTO att_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Á awán ta málek da nga liwâ na sù kinagi na ta arubáng nayù ira tatolay. Á nerallà yù kapállâ da sù napiá nga initabbák na nira, á ari ira nakkituk. ");
INSERT INTO att_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Á ajjan gapay tán yù ira Sadusio. Aggira yù makkagi ta ari maginnanolay yù ira námmatay. Á minay ira gapay kâ Apu Kesu, á kinagi ra kuna, ");
INSERT INTO att_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mesturu, ajjan yù initúrâ na ngaw ni Moyses nga kagian na, ‘Nu matay yù laláki nga natayán na yù atáwa na nga awán ta anâ da, atawán nayù wagi na yù atáwa na, tapè nu maganâ ira, á ajjan yù mebiláng ta anâ nayù natay.’ ");
INSERT INTO att_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Á ajjan ngaw yù pitu nga lálláki nga mawwawági, á nangatáwa yù kaká, á natayán na yù atáwa na nga awán ta anâ da. ");
INSERT INTO att_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Á yù mekaruá nga wagi na, inatáwa na yù atáwa nayù kaká na, á natayán na má, nga awán ta anâ da. ");
INSERT INTO att_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Á kunnian má gapay sù mekatallu nga wagi na, áddè sù mekapitu. Natay ira ngámin nga awán ta anâ da. ");
INSERT INTO att_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Á naporián nga natay gapay yù babay. ");
INSERT INTO att_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Á nu kuruk ta maginnanolay yù ira námmatay noka, asinni laguk yù kukurugán nga atáwa na, ta inatáwa ra ngámin nga pitu?” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Á kinagi ni Apu Kesu nira, “Mangatáwa yù ira tatolay ta dabbuno. ");
INSERT INTO att_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngam sangaw nu duttál yù paginnanole nayù ira nga ibiláng ni Namarò ta mepángngà nga mepaginnanolay nga mesipà kuna ta lángì, ari ira maggagáttáwa tán nga ággaw. ");
INSERT INTO att_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Á ari ira matamatay, ngam kunnay ira sù ira daroban ni Namarò, ta ánâ na ira ni Namarò nga paginnanolayan na. ");
INSERT INTO att_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Á mássiki si Kákay Moyses, inituddu na ngaw yù paginnanole nayù ira námmatay. Ta nabibbik tam yù pangistoriá na sù dakkì na sù maggatagatang nga káyu, sù pakiubobuk ni Namarò kuna. Á kinagi ni Moyses ta si Namarò yù pakimorayád di Abrakam kári Isak kâ Akup. ");
INSERT INTO att_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Á yáyù nga ammu tam ta matolay paga di Abrakam, gapu ta yù ira lâ nga matolay yù makapaddáyaw kâ Namarò, ngam ari gemma yù ira námmatay. Á ta ánninganán ni Namarò, matolay paga yù ira ngámin, mássiki yù ira nga natayin yù baggi ra.” ");
INSERT INTO att_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Á yù ira káruán nga mangituddu sù tunung ni Moyses, kinagi ra lâ kâ Apu Kesu, “Mesturu, napiá yù initabbák mu!” kud da. ");
INSERT INTO att_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Á napállâ ira ngámin, á yáyù nga awán bulubugá ta tolay nga magiyabbû kuna. ");
INSERT INTO att_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Á kinagi na laguk ni Apu Kesu nira, “Ajjan bì yù iyabbû ku nikayu. Ngattá ta ituddu ra ta ginaká ni Patul Dabid yù MakKiristu nga patul nga sinullà ni Namarò ta umay mammaguray? ");
INSERT INTO att_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta ajjan yù initúrâ na ngaw ni Dabid sù libru nga Salmo, nga kunniaw: ‘Si Apu Namarò, kinagi na sù Yápù, “E ka bì magitubang ta jiwanák ku, sù ággitubangán nayù Kotunán nga Patul, ");
INSERT INTO att_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","áddè ta arák ku appútan yù ira malussaw nikaw.” ’ Yáyù yù ubobuk ni Namarò nga initúrâ ni Dabid. ");
INSERT INTO att_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Á gapu ta kinagi ni Dabid ta Yápu na yù Patul nga sinullà ni Namarò, á kunnasi laguk ta kagiad da ta ginaká na galâ ni Dabid?” ");
INSERT INTO att_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Á ta pakaginná nayù ira ngámin nga tatolay, sinabarangán ni Apu Kesu yù ira makituddu kuna. Á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mappalán kayu, tapè arán naw párigán yù ira mangituddu sù tunung ni Moyses. Ta gustu ra lâ mabbarawási ta apaddu nga nakástá, nga mappassapassiár, tapè makialimánu yù ira tatolay nira. Á ánge ra ta kapilliá, magitubang ira sù kapiánán nga ággitubangán. Á nu umay ira mepallálláng, gustu ra magitubang sù ággitubangán nayù meparáyaw. ");
INSERT INTO att_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Á ilogò da yù ira bábbay nga nabálu, ánna gubatad da yù ngámin nga kukuá ra. Á ta pakimállà da, umay ira mappasingan nga makimállà ta mabayák, nga kunnay ta napiá. Ngam agippípiá ira, á aru yù ikáru ra sangaw nu pagikaruan ni Namarò ira.” ");
INSERT INTO att_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Á ta keggá ra paga ta mangilin nga kapilliá, nallipay si Apu Kesu, á nasingan na yù ira maríku nga mangipay ta kuártu sù ággipayyán ta melimù. ");
INSERT INTO att_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Á nasingan na gapay yù babay nga nabálu nga pobare nga minay nangipay ta duá lâ nga sintábu. ");
INSERT INTO att_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Á kinagi ni Apu Kesu sù ira makituddu kuna, “Kuruk yawe nga kagiak ku nikayu, ta masingan naw yane babay nga bálu, á ta ánningan ni Namarò, aru yù inilimù na ánnè sù ira ngámin. ");
INSERT INTO att_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Á yù ira maríku, inilimù da yù baddì lâ nga naggapu sù sobará ra nga arád da igátáng. Ngam yù babay nga nabálu, inilimù na yù ngámin nga kuártu na, nga ipangâ na nakuan ta máwák na,” kun na. ");
INSERT INTO att_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Á ajjan yù ira makkaká-ubobuk ta meyannung sù kapiá nayù mangilin nga kapilliá, gapu ta nakástá yù jijjing na nga batu ánna yù aru nga makkakerumá nga aruátan na nga neyawâ kâ Namarò. Á pakaginná ni Apu Kesu sù kinagi ra, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Á danniaw ira nga masingan naw, duttál sangaw yù ággaw nga kabugubuge na, á awán ta batu nga ari mabugay,” kun na. ");
INSERT INTO att_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Á iniyabbû da kuna, “Mesturu, sangaw nu anni yù kesimmu nayù kinagim? Á anni yù panákkilalám mi ta dattál na?” ");
INSERT INTO att_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Á kinagi na nira, “Mappalán kayu, tapè ari kayu melogò, ta aru yù umay nga makkagi ta aggira si Apu Kesu Kiristu. Á kagiad da gapay ta duttálin yù pagáddekán na ággaw. Mappalán kayu laguk, á arán naw ira tuttulan. ");
INSERT INTO att_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Á mássiki nu marámak naw sangaw ta ajjan yù ira makigerrá ánna yù ira makiramá sù ira mammaguray nira, ngam ari kayu mabbagal, gapu ta kunniúrin yù mapolu nga mesimmu, ngam ari paga yù pagáddekán na ággaw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Á kinagi na laguk ni Apu Kesu nira, “Á yù tádday nga ili, makigerrá ira sù ira tanakuán nga ili. Á yù ira makkakerumá nga páppatulán ta dabbuno, makigerrá ira. ");
INSERT INTO att_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Á aru yù lunik nga masikan. Á duttál yù bisin ánna makkakerumá nga tulágan ta káruán nga lugár. Á aru yù mesimmu ta lángì nga makapállâ ánna makánnanássing. ");
INSERT INTO att_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ngam lage na kesimmu na, mapolu nga gaputad da kayu nayù ira malussaw nikayu, á jigirigátad da kayu. Á ikeká ra kayu sù ira makáwayyá ta kapilliá na Kudio, tapè ikarsel da kayu. Á iyánge ra kayu gapay ta arubáng nayù ira patul ánna yù ira gubinador megapu sù ángnguruk naw nikán. ");
INSERT INTO att_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Á yáyù sangaw yù awayyá naw nga ipakánnámmu nira yù napiá nga dámak nga meyannung nikán. ");
INSERT INTO att_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Á lage na kesimmu na, ipe naw yù urà naw laguk ta arán naw ikaburung yù itabbák naw nira. ");
INSERT INTO att_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ta nu bestigarád da kayu, sikán yù mangipakánnámmu nikayu sù kagian naw nira. Á arád da matabbák yù kagian naw, gapu ta ipakánnámmù nikayu yù napiá nga itabbák naw sù ira malussaw nikayu. Á ari ira makatubáng nikayu. ");
INSERT INTO att_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Á mássiki yù ira kanakanáyun naw, yù ira darakal naw ánna wáwwagi naw, á yù ira kákkopun naw gapay, aggira yù mangikeká nikayu, á papatáyad da yù ira káruán nikayu. ");
INSERT INTO att_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Á yù ira ngámin nga tatolay, malussaw ira nikayu megapu sù ángnguruk naw nikán. ");
INSERT INTO att_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","“Ngam si Namarò, arán na kayu bulubugá tájjián. Ari kayu mabburung! ");
INSERT INTO att_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Magattam kayu laguk. Ta mepattolay kayu kâ Namarò ta áddè ta áddè megapu sù napasigaggà nga ángngikatalà naw nikán.” ");
INSERT INTO att_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Á kinagi na gapay ni Apu Kesu nira, “Á nu masingan naw yù aru nga suddálu nga lepuanád da yù ili na Jerusalem, yáyù nga kánnámmuán naw ta maddaggunin yù katalamán na. ");
INSERT INTO att_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Á yù ira tatolay nga maggián ta purubinsia na Judiya, mattálaw ira nga umay ta puddul. Á nepatalugáring sù ira nga maggián ta ili na Jerusalem, mabbakkuì ira. Á yù ira nga ajjan ta ákkomanád da ta lawán na ili, ari iren mattoli sù ili. ");
INSERT INTO att_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ta yáyù pamagikáru ni Namarò sù ira tatolay nga nangipuerá kuna, tapè mapalurò yù ngámin nga inipetúrâ na sù ira ngaw ábbilinán na. ");
INSERT INTO att_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Á kábbi yù ira mabussì ánna yù ira mappasusu, ta mepallà yù karigirigâ nayù ira ngámin nga tatolay megapu sù ámmagikáru ni Namarò nira. ");
INSERT INTO att_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Á mapapátay ta bayunetá yù ira káruán. Á yù káruán nga ari matay, gaputad da ira nayù ira ari Kudio, á iyánge ra ira nga mebáluk ta arayyu ta makkakerumá nga páppatulán. Á ta ili na Jerusalem, mammaguray yù ira ari Kudio, á maguray lâ yù akkuád da áddè ta pamatukkâ ni Namarò nira.” ");
INSERT INTO att_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Á kinagi na gapay ni Apu Kesu, “Á ta lage na pagáddekán na ággaw, ajjan gapay yù mesimmu sù bilák, bulán ánna bituan. Á kunnay gapay sù bebay, nga makánnanássing yù gurù na ánna palung na. Á yù ira tatolay ta ngámin nga lugár, merallà yù assing da, á mabagabagal ira megapu sù mesimmu. ");
INSERT INTO att_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Á maganássing yù ira tatolay ánna malupulupuk ira nga magiddak sù mesimmu ta ngámin nga dabbuno, nepatalugáring nu masingad da yù panguli nayù ággián nayù bilák, bulán, ánna bituan ta lángì, ta mapagalì yù ngámin nga ajjan ta lángì. ");
INSERT INTO att_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Á umayà laguk nga mappasingan sù kunam ta lángì, nga mattoli sawe dabbuno, sikán nga Kaká na ngámin na tatolay, nga makáwayyá ánna maddalingáráng. ");
INSERT INTO att_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Á nu mamegapu dannian nga ikássing, patattaman naw yù nonò naw ánna magiddi-iddak kayu, ta duttálin yù kapalubbáng naw sù jigâ naw.” ");
INSERT INTO att_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Á nagángngarigán si Apu Kesu ta meyannung sù panoli na ta dabbuno, á kinagi na nira, “Inni-innan naw yù káyu nga igò ánna yù ira ngámin nga káruán nga káyu gapay. ");
INSERT INTO att_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu masingan naw ta massungngì yù don na, á ammu naw ta maddaggunin yù dagun. ");
INSERT INTO att_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Á ta kunnian gapay, nu masingan naw danniaw nga mamegapu nga mesimmu ta kunnay sù kinagì, yáyù pakánnámmuán naw ta duttálin yù pammagure ni Namarò ta dabbuno. ");
INSERT INTO att_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Á kuruk yù kagiak ku nikayu, ajjan yù ira tatolay nga ari paga natay lage na kesimmu na ngámin. ");
INSERT INTO att_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Á mássiki nu mappasá noka yù ngámin nga ajjan ta lángì ánna yawe dabbuno, ngam ari bulubugá mapatalián yù kinagì nikayu, gapu ta mapalurò ngámin.” ");
INSERT INTO att_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Á kinagi na nira paga ni Apu Kesu, “Magimuguk kayu, marakè melingúnán naw sangaw yù kinagì nikayu, nu yá lâ tángngagan naw yù pabbúyá naw, pappissán naw, ánna pajjigirigâ naw sawe dabbuno. Ta nu máttamán naw, makaráring kayu sangaw nga kunnay ta masikuatán, nu duttál yù pagáddekán na ággaw. ");
INSERT INTO att_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ta ikáddagâ lâ duttál yù ággaw nga pamanunnù ni Namarò sù ira ngámin nga tatolay ta ngámin nga dabbuno, á makaráring ira. ");
INSERT INTO att_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Á yáyù nga napiá nu mapparán kayu, á makimállà kayu kâ Namarò ta abbágán na kayu, tapè mapasigaggà yù ángnguruk naw kuna. Ta nu dán nga naparán kayu, á ajjan yù awayyá naw nga magattam ta jigâ nga kinagì nikayu nga mesimmu sangaw, ánna mappelò kayu nu umay kayu ta arubáng ku, sikán nga Kaká na ngámin na tatolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Á naggián si Apu Kesu sù mangilin nga kapilliá ta kággággaw, nga mangituddu sù ira tatolay. Á ta kádagabi minay nagammâ sù puddul na Olibo. ");
INSERT INTO att_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Á yáyù nga minay yù ira ngámin nga tatolay ta káda alippánnawák sù mangilin nga kapilliá nga magginná sù ituddu na. ");
INSERT INTO att_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Á maddaggunin yù piestá nga pakkákán nayù ira Kudio ta pán nga awán ta áppalappák na, nga mangngágan ta Panaddamád da sù Pattalebák nayù Daroban ni Namarò sù ira ngaw ginaká ni Israel túrin ta Egipto. ");
INSERT INTO att_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Á yù ira kátannangán nga pári ánna yù ira mangituddu sù tunung ni Moyses, inigagánge ra nga ipapátay si Apu Kesu, ngam inilímak da yù akkuád da, gapu ta assing da sù ira tatolay nga tumututtul kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Á si Satanas, nagunagán na si Kudas Iskariote, nga tádday sù ira mapulu duá nga sinudduán ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Á minay laguk si Kudas nakiubobuk sù ira kátannangán nga pári ánna yù ira kapitán nayù ira magguárdiá sù mangilin nga kapilliá, nu kunnasi sangaw yù pangipagápù na kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Á nagayáyâ ira, á kinagi ra kuna ta táddanád da. ");
INSERT INTO att_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Á pattatarátu ra, namegapu si Kudas nga massísim kâ Apu Kesu, tapè málek na yù awayyá na nga mangipagápù kuna sangaw nu awán ta tolay nga magaru nga mepulù kuna. ");
INSERT INTO att_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Á ta piestá, jimittál yù ággaw nga pakkákád da ta pán nga awán ta áppalappák na, nga pangiyátáng da gapay sù kígaw na karneru kâ Namarò, nga kanad da ta panaddamád da. ");
INSERT INTO att_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Á jinok ni Apu Kesu di Eduru kâ Kuan, á kinagi na nira, “Umay kayu mapparán ta kanat tam ta panaddamát tam sù pattalebák nayù daroban ni Namarò sù ira ngaw naggaká nittam,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Á kinagi ra kuna, “Á isaw em mi papparánán?” kud da. ");
INSERT INTO att_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Á kinagi na nira, “Umay kayu ta ili. Á labbè naw sangaw, marápun naw yù tolay nga namuttung ta ammutu. Tuttulan naw, ta yù balay nga tallungán na, yáyù gapay tallungán naw. ");
INSERT INTO att_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Á kagian naw sù makábbalay, ‘Yù Mesturu, ipeyabbû na nikami nu isaw gián nayù pakkákanám mi ta panaddamám mi sù pattalebák nayù daroban, aggina ánna sikami nga makituddu kuna,’ kun naw. ");
INSERT INTO att_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Á ituluk na kayu ta utun, sù dakal nga lágum nga ajjan kuna yù ngámin nga máwák tam. Yáyù papparánán naw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Á minay di Eduru, á nálek da yù ngámin nga kunnay sù kinagi na, á pinarád da yù kanad da. ");
INSERT INTO att_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Á ta pamúgák da, nallalálláng di Apu Kesu ánna yù ira mapulu duá nga sinudduán na. ");
INSERT INTO att_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Á kinagi na nira, “Napiá ta ajjan ittam saw, ta karagaták ku nga kuruk nga mepallalálláng nikayu kunangan sù panaddamát tam sù pattalebák nayù daroban ni Namarò, pángè ku marigirigâ. ");
INSERT INTO att_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta kagiak ku nikayu ta yawe lâ yù pakkákák ku sù panaddamát tam, ta áddè ta kapalurò nayù ngámin nga kebalinán nayù piestá, sangaw nu ajjan ittam ta pammagurayán ni Namarò.” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Á inâ na yù passuelu nga ajjan kuna yù inumad da, á nabbalabálà kâ Namarò, á iniyawâ na nira. Á kinagi na nira, “Pattutubbátán naw nga inuman ta ággibaddì. ");
INSERT INTO att_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Á aringakin makenum ta tabbuk na úbas, áddè ta dattál nayù pammagure ni Namarò ta dabbuno, á yáyù pakenum ku má,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Á inâ na laguk ni Apu Kesu yù pán, á nabbalabálà kâ Namarò. Á giddigidduá na, á inisinek na nira. Á kinagi na nira, “Alawatan naw yù baggì nga metapil megapu nikayu. Mapiá nu kunniaw yù akkuán naw ta panaddamán naw nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Á kabalid da nga namúgák, inâ na má ni Apu Kesu yù inumad da nga tabbuk na úbas, á iniyawâ na nira, á kinagi na nira, “Yawe yù panákkilalán naw sù bagu nga tarátu ni Namarò nikayu, nga mapalurò megapu sù dágà sangaw nu matayà nga metapil megapu nikayu. ");
INSERT INTO att_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Á ajjan saw nga nepallalálláng nittam yù mappagápù nikán. ");
INSERT INTO att_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Á sikán, nga Kaká na ngámin na tatolay, matayà sangaw gapu ta yáyù netúrâ nga sinalákkuruk na ngaw ni Namarò. Ngam kábbi yù tolay nga mappagápù nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Á pakaginná ra karannian, naburuburung ira, á nakkaká-abbû ira nga kinagi, “Asinni panò nittam yù mangnguá ta kunnian?” kud da. ");
INSERT INTO att_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Á yù ira sinudduán ni Apu Kesu, nakkakápereperang ira ta ubobuk nu asinni yù kotunán nira. ");
INSERT INTO att_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Á yáyù nga kinagi ni Apu Kesu nira, “Yù ira mammaguray sawe dabbuno, darobad da yù ira tatolay, ngam iparámak da ta aggira yù mangabbák nira. ");
INSERT INTO att_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngam sikayu, ari kunnian yù ággián naw. Ta napiá nu yù kotunán nikayu yù kunnay sù urián nga tumulù nga masserbi. Á yù mangituddu nikayu, napiá nu aggina yù masserbi nikayu nga kunnay sù makiaripan. ");
INSERT INTO att_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Á asinni panò yù ibiláng na tolay ta kotunán? Á ta ángngarigán, yù tolay nga magitubang nga kumán? Onu yù doban na nga masserbi kuna? Á ibiláng da gemma ta kotunán yù magitubang nga kumán. Ngam sikán, ajjanà nikayu nga kunnay ta masserbi. ");
INSERT INTO att_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Á sikayu yù ira nga maggián nikán nga mangabbák nikán ta jigâ ku. ");
INSERT INTO att_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Á yáyù nga sikayu yù sinullà ku ta mepammaguray nikán, ta kunnay ta panullà nayù Yámà nikán ta mammaguray. ");
INSERT INTO att_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Á mepallalálláng kayu nikán ánna mesipà kayu sù pammagurè, á magitubang kayu nga mammaguray ánna mamanunnù sù ira ginaká nayù mapulu duá nga ánâ ni Akup, nga mangngágan ta Israel.” ");
INSERT INTO att_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Á kinagi ni Apu Kesu kâ Eduru, “Simon, nga kopuk ku, tángngagam mu yù kagiak ku nikaw. Inanugù ni Namarò si Satanas nga mamarubá nikayu nga katággitádday, nga kunnay ta mangisâ ta aggì, tapè mári yù kupì. ");
INSERT INTO att_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Á nepatalugáring nikaw, Simon. Ngam inipakimállà taka, tapè ari mári yù ángnguruk mu nikán. Á sangaw nu mabbabáwi ka ta liwâ mu, ánna mattoli ka nikán, tabarangám mu laguk yù ira kábulum mu, tapè mapasigaggà yù ángngikatalà da nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngam kinagi ni Eduru kuna, “Apu, naparánakin nga mepulù nikaw, mássiki nu mekársel itta, mássiki nu matay itta!” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Á kinagi ni Apu Kesu, “Kuruk yù kagiak ku nikaw, Eduru, ta pilluam mu nga kagian ta arám mà ammu, lage na pagittarákkò na manù sangaw nu gabi.” ");
INSERT INTO att_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Á iniyabbû ni Apu Kesu sù ira sinudduán na, nga kun na, “Á ta paddok ku ngaw nikayu, nga ari nangipulù ta kuártu, bungun, onu sapátù naw, á nakúráng panò yù awágan naw?” kun na. “Ari, Apu!” kud da. ");
INSERT INTO att_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Á kinagi na nira, “Ngam dumá yù ággián naw kunangane, ta nu egga yù kuártu naw onu bungun, napiá nu ipulù naw yù egga. Á nu ajjan yù tolay nga awán ta badáng na, á iláku na yù barawási na, tapè ajjan yù ipangâ na ta badáng na. ");
INSERT INTO att_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta máwák nga mapatuppál yawe dán nga inipetúrâ ni Namarò nga kinagi na sù ngaw ábbilinán na nga meyannung nikán: ‘Yù sinullà ku ta mammaguray, ibiláng nayù ira tatolay ta tulisán, á pagikaruad da.’ Á duttálin yù kapalurò nayù ngámin nga netúrâ nga meyannung nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Á kinagi nayù ira sinudduán na kuna, “Apu, innam mè. Ajjan duá nga badáng saw,” kud da. Á kinagi na, “Kustu nen!” ");
INSERT INTO att_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Á nánaw si Apu Kesu sù balay, á minay sù puddul na Olibo, ta yáyù kustombare na. Á nepulù kuna yù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Á labbè da tán, kinagi ni Apu Kesu nira, “Makimállà kayu kâ Namarò ta melillì kayu sù narákè nga mamarubá nikayu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Á bittáng na ira ni Apu Kesu, á minárayyu nira ta baddì, nga namalittúkak nga nakimállà kâ Namarò. Á kinagi na, ");
INSERT INTO att_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ammò, nu urem nakuan ta melillikà sù jigâ nga umay nikán, á ilillì mà. Ngam ari yù urè yù matuppál, nu ari galâ yù urem,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Á nappasingan kuna yù daroban ni Namarò nga naggapu ta lángì, á en na pinassikan yù baggi na ánna nonò na. ");
INSERT INTO att_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Á gapu ta nepallà yù karigirigâ na ánna yù daddam na, pine na má nakimállà, nga naguggáng, á kun na dága yù uggáng na nga massísínâ ta dabbun. ");
INSERT INTO att_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Á kabalin na nakimállà, gimikkáng nga nattoli sù gián nayù ira sinudduán na, á narángnganán na ira nga nakkaturuk gapu ta nappunaw ira sù nerallà nga daddam da. ");
INSERT INTO att_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Á kinagi na nira, “Anni má ta nakkaturuk kayu? Gumikkáng kayu nga makimállà, tapè melillì kayu sù narákè nga mamarubá nikayu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Á ta arán na paga kabalin ni Apu Kesu nga nagubobuk, limibbè yù ira tatolay nga magaru, nga nepulù kâ Kudas nga tádday sù ira mapulu duá nga sinudduán na. Á jimikkì si Kudas, á inummatán na yù paringil ni Apu Kesu ta kunnay ta kustombare ra. ");
INSERT INTO att_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngam kinagi ni Apu Kesu kuna, “Kudas, napiá panò yù akkuám mu? Ta iyummà mu yù panájjim nikán, sikán nga Kaká na ngámin na tatolay!” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Á ta pakasingan nayù ira sinudduán na ta ajjan yù akkuán nayù ira tatolay kuna, kinagi ra, “Apu, magibadáng kami nira?” kud da. ");
INSERT INTO att_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Á yù tádday nga kabbulun ni Apu Kesu, á dagarágâ na kittak yù aripan nayù kátannangán nga pári, á napingarán yù jiwanán nga talingá na. ");
INSERT INTO att_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngam kinagi ni Apu Kesu, “Kustu nen!” Á sinámmì ni Apu Kesu yù talingá nayù tolay, á nammapiá ngin. ");
INSERT INTO att_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Á yù ira nga minay naggápù kâ Apu Kesu yù ira kátannangán nga pári, yù ira suddálu nga magguárdiá sù mangilin nga kapilliá, ánna yù ira giriámán. Á kinagi ni Apu Kesu nira, “Kunnayà panò ta tulisán? Ta nattagibadáng ánna nattagipalù kayu nga umay maggápù nikán! ");
INSERT INTO att_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Á mássiki nu nepulupulukà nikayu ta kággággaw sù mangilin nga kapilliá, á arán nawà ginápù! Ngam jimittálin yù awayyá naw nga mangnguá nikán, ánna yù pakapangnguá ni Satanas, nga meyárik ta kallà.” ");
INSERT INTO att_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Á gapu ta paggápù da kâ Apu Kesu, inituluk da sù bale nayù kátannangán nga pári. Á sinuttul na ira ni Eduru, ngam arayyu lâ nira. ");
INSERT INTO att_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Á nappagaddul ira ta námmuák na balay. Á nepaggirínu si Eduru nira. ");
INSERT INTO att_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Á ajjan tán yù babay nga masserbi ta balay. Á nasingan na si Eduru nga nanawagán ta dalingáráng na api, á inni-innan na ta napiá, á kinagi na, “Yane paga yù kabbulun ni Kesu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngam nallímak si Eduru, á kinagi na, “Amma-ammù panò yù tolay?” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Á manganánnuán, ajjan gapay yù tádday nga tolay nga nakasingan kâ Eduru, á kinagi na kuna, “Sikaw pá gemma yù sigídá nga kabbulud da!” Ngam kinagi ni Eduru, “Ari gemma sikán!” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Á pappasá na tangoras, á kinagi nayù tádday nga tolay, “Kuruk gemma ta mepulupulù yawe tolay kuna, ta taga Galilia gemma gapay!” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngam kinagi ni Eduru, “Arák ku ammu yù kakágiam mu!” kun na. Á pagubobuk ni Eduru karannian, dagarágâ nagittarákkò yù manù. ");
INSERT INTO att_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Á nilipe ni Apu Kesu si Eduru, á nanonò ni Eduru yù kinagi ni Apu Kesu kuna, nga “Pilluam mu nga kagian nga arám mà ammu, lage na pagittarákkò na manù sangaw nu gabi.” ");
INSERT INTO att_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Á nánaw si Eduru, nga makkulè, nga nepallà yù kulè na ta pakanonò na sù kingnguá na. ");
INSERT INTO att_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Á yù ira tatolay nga nagguárdiá kâ Apu Kesu, inuyoyungád da ánna pinalapalù da. ");
INSERT INTO att_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Á binabbarád da yù matá na, á lippilippák da, á kinagi ra kuna, “Asinni yù nallappák nikaw? Abbúnam mu yù ngágad da nu ammum!” kud da. ");
INSERT INTO att_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Á aru gapay yù pamasapasirád da kuna. ");
INSERT INTO att_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Á ta pannawák, naggagammung mángin yù ira giriámán, yù ira kátannangán nga pári, ánna yù ira mesturu sù tunung ni Moyses. Á inipágál da si Apu Kesu ta mepagarubáng nira. ");
INSERT INTO att_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Á kinagi ra kuna, “Nu kuruk ta sikaw yù MakKiristu nga sinullà ni Namarò ta mammaguray, á kagiam mu laguk!” kud da. Á simibbák, á kinagi na nira, “Á nu kagiak ku nakuan, arán nawà gemma kurugan. ");
INSERT INTO att_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Á kunnian gapay nu ajjan yù iyabbû ku nikayu, arán nawà tabbagan. ");
INSERT INTO att_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","“Ngam kagiak ku galâ nikayu, ta sangaw nu mappasá yaw, á sikán nga Kaká na ngámin na tatolay, mepagitubangà sù jiwanán ni Namarò nga Kotunán nga makáwayyá ta lángì,” kun na. ");
INSERT INTO att_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Á naggigiddán ira nga nagubobuk, á kinagi ra, “Sikaw yù Anâ na laguk ni Namarò?” kud da. Á kinagi na nira, “Wan, kuruk yù kagian naw. Sikán,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Á kinagi ra, “Ye, arát tam máwák yù tanakuán nga massistígu, ta aggina yù nakkagi, á naginná tam yù kinagi na,” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Á yù ira ngámin nga minámmanunnù, ed da laguk inituluk si Apu Kesu kâ Gubinador Pilatto. ");
INSERT INTO att_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Á nassirisiri ira nga nangikeká kuna, á kinagi ra kâ Gubinador, “Ginápù mi yawe laláki, ta buruburionan na yù ira tatolay, ta ipakontará na nira si Patul Sisar ta Roma, á ipugik na yù pappagá ra ta buwì kâ Patul Sisar. Á kagian na gapay ta aggina yù patul nga sinullà ni Namarò ta mammaguray,” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Á iniyabbû na laguk ni Pilatto kâ Apu Kesu, “Á kuruk nga sikaw yù patul nayù ira Kudio?” kun na. Á kinagi ni Apu Kesu, “Ammán, kuruk yù kagiam mu,” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Á kinagi ni Pilatto sù ira kátannangán nga pári ánna yù ira tatolay, “Awán ta ammù nga liwâ na yawe tolay,” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Á inipappanà da nga kinagi kâ Pilatto, “Á buruburionan na yù ira ngámin nga tatolay ta Judiya megapu sù ituddu na, ta pinegapuanán nen nga binuruburion ira túrin ta Galilia, áddè saw,” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Á pakaginná ni Gubinador Pilatto ta yù purubinsia na Galilia yù namegapuanán na, iniyabbû na nira, “Taga Galilia lagugam?” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Wan,” kud da. Á pakánnámmu ni Pilatto ta taga Galilia si Apu Kesu, inipeyánge na kâ Gubinador Erodo, nga mammaguray ta Galilia, ta ajjanin ta Jerusalem sù kesimmu na yaw. ");
INSERT INTO att_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Á nagayáyâ si Erodo ta pakasingan na kâ Apu Kesu, gapu ta nabayágin nga narámak na, ánna yù kingngi-kingnguá na, á gustu na masingan yù pamagaddátu na. ");
INSERT INTO att_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Á yáyù nga aru yù iniyabbû na kâ Apu Kesu. Ngam ari bulubugá simibbák si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Á aru yù ipamaliwâ da kuna nayù ira kátannangán nga pári ánna yù ira mangituddu sù tunung ni Moyses. ");
INSERT INTO att_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Á di Erodo gapay ánna yù ira suddálu na, iniluddè da ánna inuyu-uyo ra, á binarawasiád da ta barawási na patul lage ra initoli kâ Pilatto. ");
INSERT INTO att_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Á yáyù namegapuanád da nga makkákopun di Erodo kâ Pilatto, mássiki nu dán nga makkálussaw ira. ");
INSERT INTO att_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Á pangitoli ra kâ Apu Kesu kâ Pilatto, inipágál ni Pilatto yù ira kátannangán nga pári, yù ira giriámán, ánna yù ira káruán nga tatolay. ");
INSERT INTO att_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Á kinagi na nira, “Iniyánge naw yawe tolay ta arubáng ku nga kagian naw ta aggina yù minámmuruburion sù ira tatolay, á binestigá kin ta arubáng naw, á ammu naw ta awán ta nánnámmuák ku nga liwâ na nga kunnay sù kinagi naw nga akkuán na. ");
INSERT INTO att_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Á si Erodo gapay, awán ta nánnámmuán na nga liwâ na, ta initoli na gemma nittam. Á ammu nawin laguk ta awán bulubugá ta kingnguá na nga ipamapáte tam kuna. ");
INSERT INTO att_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Á yáyù nga ipabaddû ku lâ, á palubbángak ku sangaw,” kun ni Pilatto. ");
INSERT INTO att_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Á yáyù kinagi na gapu ta ajjan yù kustombare na nga mamalubbáng ta tádday nga nabáluk nu mappiestá yù ira Kudio ta kádaragun. ");
INSERT INTO att_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngam nagaragiák yù ira tatolay nga nakkagi, “Papatáyam mu, ta si Barabas yù palubbángam mu,” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Á nabáluk si Barabas negapu sù pakikontará na ta gubermente ánna yù pamapáte na. ");
INSERT INTO att_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Á gapu ta gustu ni Pilatto nga palubbángan si Apu Kesu, pinidduá na nga kinagi nira. ");
INSERT INTO att_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngam nagaragiák ira lállaguk nga nakkagi, “Ipepátà mu ta kurù tapè matay!” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Á gapu ta manakì yù ira tatolay nga matabarangán, pinillu na laguk ni Pilatto nga kinagi nira, “Anni má? Anni yù liwâ na? Awán gemma ta ammù nga liwâ na nga ipamapátè kuna. Ipabaddû ku lâ, á palubbángak ku!” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngam nerallà yù káragiák da. Á inikalli ra, “Ipepátà mu ta kurù tapè matay,” kud da. Á napuersá si Pilatto sù ikáyâ da. ");
INSERT INTO att_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Á kinagi na yù anugù na sù gustu ra, nga matay si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Á pinalubbáng na laguk yù piníli ra nga tolay nga nabáluk negapu sù pakikontará na ta gubermente ánna pamapáte na. Ngam si Apu Kesu, initulù na nira tapè matuppál yù ure ra kuna. ");
INSERT INTO att_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Á ta pangipáno ra kâ Apu Kesu, nerapunád da si Simon nga taga Sirine nga lubbè ta ili, á pinuersá ra nga inipakáttu kuna yù kurù nga ituttul na kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Á aru yù ira tatolay gapay nga siminuttul kuna. Á ajjan gapay yù ira bábbay nga gikuletán megapu kuna. ");
INSERT INTO att_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ngam nilipe ni Apu Kesu ira, á kinagi na nira, “Sikayu nga bábbay nga taga Jerusalem, arán nawà kuletán, ngam kuletán naw lâ nakuan yù baggi naw ánna yù ira ánâ naw! ");
INSERT INTO att_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta nu duttál sangaw yù ággaw na jigâ, á kagian nayù ira tatolay, nga kud da, ‘Magayáyâ yù ira bábbay nga awán ta anâ da, nga ari nakaparubá nga maganâ, nga ari nappasusu,’ kud da. ");
INSERT INTO att_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Á pegapuanád da gapay nga kagian, ‘Maddaggay ngillâ nakuan yù puddul, tapè matábbunán kami,’ kud da. ");
INSERT INTO att_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Á gapu ta kunniaw yù akkuád da nikán nga awán gemma ta liwâ ku, á pappanganâ lâ sangaw nikayu nga minálliwâ!” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Á ajjan gapay yù duá nga tulisán nga iniyánge ra, tapè megiddán ira nga matay kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Á pakáddè da sù gián nga mangngágan ta Balakábâ, inipátà da si Apu Kesu ta kurù tán. Á inipátà da yù ira duá nga tulisán, yù tádday sù jiwanán na, á yù tádday sù jimigi na. ");
INSERT INTO att_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Á nakimállà si Apu Kesu, á kinagi na, “Ammò, pakomám mu ira, ta arád da garè ammu yù akkuád da,” kun na. Á kabalid da nga nangipátà nira nayù ira suddálu, á nabbubúnù ira, tapè pabbaballáyád da yù barawási ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Á aru yù ira tatolay nga naggíraw. Á yù ira kamotungán nga Kudio, inuyoyungád da, á kinagi ra, “Ye! Niyígù na yù ira tatolay! Ngam yù baggi na, arán na meyígù! Á nu aggina yù kuruk nga Mangiyígù nga sinullà ni Namarò, iyígù na gapay nakuan yù baggi na!” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Á yù ira suddálu, inuyoyungád da gapay. Á jimikkì ira kuna ta iyalawâ da kuna yù silam. ");
INSERT INTO att_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Á kinagi ra kuna, “Nu kuruk nga sikaw yù patul nayù ira Kudio, iyígù mu laguk yù baggim!” kud da. ");
INSERT INTO att_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Á ajjan gapay yù netúrâ nga inipátà da ta utun na kurù, nga kunniaw, “Yawe yù Patul nayù ira Kudio.” ");
INSERT INTO att_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Á yù tádday nga tulisán nga nepátà tán, inuyo na gapay si Apu Kesu, á kinagi na, “Sikaw panò yù kuruk nga Mangiyígù nga sinullà ni Namarò? Arà! Iyígù mu ittam laguk!” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Á gimmá nayù kabbulun na nga tulisán, á kinagi na, “Ngattá, ta ari ka maganássing kâ Namarò, nepatalugáring ta naggigittá ittam nga matay? ");
INSERT INTO att_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Á sitta, magikáru itta ta liwâ ta. Á yawe tolay, awán ta liwâ na!” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Á kinagi na laguk kâ Apu Kesu, “Apu, nonopam mà lággapay nu duttál yù ággaw nga pattolim nga umay mammaguray!” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Á kinagi ni Apu Kesu kuna, “Kuruk yù kagiak ku nikaw, ta mepulù ka nikán ta ággawo ta lángì,” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Á ta tangngá na ággaw, iddâ na lâ nakkallà yù ngámin nga dabbun áddè ta alas tares ta púgák. ");
INSERT INTO att_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Á pakkallà na bilák, iddâ na lâ naggadduá yù nakannak nga kortíná nga nelippak sù kangilinán nga lágum sù mangilin nga kapilliá ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Á nakkatol si Apu Kesu ta nasikan, á kinagi na, “Ammò, ikatalà ku yù ikararuâ nikaw!” kun na. Á kabalin na nakkagi ta kunnian, á nagattâ yù inángà na. ");
INSERT INTO att_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Á ta pakasingan nayù kapitán nayù ira suddálu sù nesimmu, jináyo na si Namarò, á kinagi na, “Kuruk nga napiá lâ yawe tolay nga awán ta liwâ na!” kun na. ");
INSERT INTO att_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Á yù ira tatolay nga naggíraw tán, pakasingad da sù nesimmu, á limibbè ira ta bale ra, nga nepallà yù daddam da. ");
INSERT INTO att_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Á yù ira ngámin nga kákkopun na ánna yù ira bábbay nga nepulupulù kuna sù paggapu ra ta Galilia, naggián ira ta arayyu ta baddì nga maningan sù ngámin nga nesimmu kuna. ");
INSERT INTO att_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Á ajjan si Kusè nga taga Arimatia, nga tádday nga ili sù purubinsia na Judiya. Á napiá nga tolay si Kusè, nga matunung yù ngámin nga akkuán na. ");
INSERT INTO att_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Á aggina gapay yù tádday sù ira kamotungán nga Kudio, ngam ari netádday yù nonò na ta nonò da, ta arán na inikáyâ yù kingnguá ra kâ Apu Kesu, á iddanamán na gapay yù dattál nayù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Á minay si Kusè kâ Gubinador Pilatto, ta en na kiddawan yù baggi ni Apu Kesu, tapè en na itanam. ");
INSERT INTO att_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Á iniyanugù ni Pilatto kuna. Á minay si Kusè sù gián nayù baggi ni Apu Kesu. Á iniyutták na, á binungun na ta puraw nga gámì. Á initanam na sù nakokkobán nga batu nga awán paga ta netanam kuna. ");
INSERT INTO att_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Á púgák na Biernes yù pate ni Apu Kesu, á inikukkuttù ni Kusè nga initanam, gapu ta lammak na bilák yù pamegapu nayù ággaw na ággibannák. ");
INSERT INTO att_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Á yù ira bábbay nga nepulupulù kâ Apu Kesu sù paggapu na ta Galilia, sinuttul da si Kusè, á nasingad da yù pangitanamán na ta baggi ni Apu Kesu ánna kunnasi yù ángngitanam na kuna. ");
INSERT INTO att_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Á limibbè ira laguk, tapè paránad da yù makkakerumá nga bábbanguk nga ipe ra sù baggi nayù natay. Á sù tádday ággaw, nga ággaw na Sabadu, naggián ira ta bale ra nga magibannák, ta kunnay sù ituddu nayù tunung ni Moyses. ");
INSERT INTO att_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Á ta alippánnawák na Liggu, minay yù ira bábbay ta tanam, ta ed da iyángay yù makkakerumá nga bábbanguk nga pinarád da. ");
INSERT INTO att_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Á labbè da ta tanam, narángnganád da nga nabukatán, nga nakarebu yù batu nga nelippak kuna. ");
INSERT INTO att_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Á simillung ira laguk ta unak. Ngam tallung da, á nasingad da ta awánin yù baggi ni Apu Kesu tán. ");
INSERT INTO att_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Á pakasingan nayù ira bábbay ta awán, nanáddak ira tán nga namáyyang. Á inikáddagâ da lâ nga limittuák yù duá nga lálláki nga nepanáddak nira, nga naddalingáráng yù barawási ra. ");
INSERT INTO att_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Á naganássing yù ira bábbay, á nalipay ira nga nakkummak. Á kinagi nayù ira lálláki nira, “Anni má ta aleran naw yù matolay sù gián nayù ira námmatay? ");
INSERT INTO att_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Awánin saw, ta naginnanolayin! Nonopan naw yù kinagi na ngaw nikayu sù arán na paga pánaw ta Galilia. ");
INSERT INTO att_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ta kinagi na ta metulù yù Kaká na ngámin na tatolay sù ira minálliwâ, á mepátà ta kurù tapè matay, á maginnanolay sù mekatallu nga ággaw,” kud da. ");
INSERT INTO att_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Á pakaginná nayù ira bábbay sù kinagi ra, á nanonò da. ");
INSERT INTO att_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Á nánawád da yù tanam, ta ed da kagian sù ira mapulu tádday ánna yù ira káruán nga kábulud da. ");
INSERT INTO att_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Á yù ira bábbay nga nakkagi sù ira mapulu tádday nga minángngilayalayâ, aggira di Maria Maddala, si Juana, si Maria nga yená ni Ime, ánna yù ira káruán nga bábbay gapay nga nepulù nira. ");
INSERT INTO att_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngam yù ira lálláki, arád da kinuruk yù kinagi nayù ira bábbay, ta kagiad da ta gaggátung da lâ yù kagiad da. ");
INSERT INTO att_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngam si Eduru lâ, pine na nakkarerá nga minay sù gián na tanam, ta en na pasikkálan nu kuruk. Á sinígik na yù unak na tanam, á yá lâ nasingan na yù nakabungunán na. Á limibbè nga napállâ sù nesimmu. ");
INSERT INTO att_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Á ajjan yù duá ira nga nakituddu kâ Apu Kesu, nga yane yù ággaw nga páno ra nga umay ta babálay nga mangngágan ta Emmos. Á mapulu tádday nga kilometro yù kárayyu na ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Á pallakalakák da, nakká-ubobugad da yù ngámin nga nesimmu. ");
INSERT INTO att_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Á pakká-ubu-ubobuk da, á narángnganán ni Apu Kesu ira, á nepappapulukin laguk nira. ");
INSERT INTO att_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ngam arád da natákkilalán. ");
INSERT INTO att_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Á kinagi ni Apu Kesu nira, “Anni yù pakká-ubobugan naw?” kun na. Á nagginnà ira, nga melásin yù daddam da. ");
INSERT INTO att_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Á yù tádday nga mangngágan ta Kalopas, gapu ta arán na paga matákkilalán si Apu Kesu, á kinagi na kuna, “Á makiálliuk ka támma ta Jerusalem, á sikaw lâ yù táttádday nga arán na ammu yù ngámin nga nesimmu tán nga ili gangù!” kun na. ");
INSERT INTO att_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Á iniyabbû ni Apu Kesu kuna, á kinagi na, “Á anni panò laguk yù nesimmu?” kun na. Á kinagi ra kuna, “Yù kingngikingnguá ra kâ Apu Kesu nga taga Nasaret. Aggina yù kukurugán nga ábbilinán ni Namarò. Ta inipasingan na yù pakáwayyá na nga makapállâ megapu sù aru nga pinagaddátu na ta arubáng na ngámin nga tatolay, ánna makáwayyá yù ággubobuk na gapay. ");
INSERT INTO att_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngam yù ira kátannangán nga pári ánna yù ira káruán nga karakalám mi nga Kudio, narákè yù nonò da kuna, á ginápù da, á nassirisiri ira nga nangikeká kâ Gubinador Pilatto, tapè aggina yù mamagikáru kuna. Á inipepátà na ta kurù tapè matay, ta yáyù ámmagikáru na kuna. ");
INSERT INTO att_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Á sikami, á kinagi mi ta aggina yù iddanamám mi nga maddaggunin nga mangiyígù nikami nga ginaká ni Israel. Á mekatallungin ta ággawo áddè sù pate na. ");
INSERT INTO att_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Á napállâ kami gapay sù kinagi nayù ira bábbay nga kábulum mi. Ta minay ira ta alippánnawák ta katanamán, ");
INSERT INTO att_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngam awán yù baggi na. Á labbè da, kinagi ra nikami ta nasingad da yù ira daroban ni Namarò nga nakkagi nira ta naginnanolayin. ");
INSERT INTO att_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Á pakarámak mi, á minay yù ira káruán nga kábulum mi, ta ed da innan nu kuruk yù kinagi nayù ira bábbay. Á naratang da nga kunnay sù kinagi ra, ngam arád da gapay nasingan si Apu Kesu.” ");
INSERT INTO att_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Á kinagi na laguk ni Apu Kesu nira, “Ngattá, ta nakúráng paga yù ángnguruk naw sù ngámin nga kinagi nayù ira ngaw ábbilinán ni Namarò! ");
INSERT INTO att_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Arán naw panò ammu ta ajjan yù netúrâ, nga marigirigâ yù MakKiristu nga sinullà ni Namarò, lage na mepotun nga meparáyaw?” kun na. ");
INSERT INTO att_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Á inibukalán na laguk ni Apu Kesu nira yù ngámin nga meyannung sù baggi na nga netúrâ sù libru ni Namarò, nga namegapu sù initúrâ ni Moyses ánna yù ira ngámin nga initúrâ nayù ira káruán nga ábbilinán ni Namarò. ");
INSERT INTO att_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Á manganánnuán ta pakáranni ra ta ili nga angayán nayù ira duá, á nekáttuay si Apu Kesu nira nga kunnay ta arayyu paga yù angayán na. ");
INSERT INTO att_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngam inigaggak da, á kinagi ra kuna, “Ari ka lákin mánaw, ta púgágin. Mepagammâ ka nikami,” kud da. Á nepulù nira laguk nga nepaddulò. ");
INSERT INTO att_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Á nepallalálláng si Apu Kesu laguk nira nga nakkákán. Á inâ ni Apu Kesu yù pán, á nabbalabálà kâ Namarò. Á gidduá na yù pán, á iniyawâ na nira. ");
INSERT INTO att_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Á ikáddagâ da lâ natákkilalán si Apu Kesu. Á dagarágâ limimmà. ");
INSERT INTO att_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Á nakkaká-ubobuk ira, á kinagi ra, “Á yáyù ga nga nalunnáyán yù nonò ta, sù pappatale tam ta dálan, sù pangibukalán na sù kebalinán nayù initúrâ ni Moyses ánna yù ira ngaw ábbilinán ni Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Á dagarágâ nga nánaw yù ira duá nga nattoli ta Jerusalem. Á labbè da, narángnganád da nga naggagammung yù ira mapulu tádday ánna yù ira káruán nga kábulud da. ");
INSERT INTO att_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Á kinagi nayù ira naggagammung, “Kuruk nga naginnanolay si Apu, ta nappasingan kâ Simon Eduru!” kud da. ");
INSERT INTO att_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Á inistoriá ra laguk nayù ira duá yù pakesimmu ni Apu Kesu nira ta dálan ánna yù pakatákkilála ra kuna sù paggadduá na ta pán. ");
INSERT INTO att_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Á pakkaká-ubobuk da, ikáddagâ lâ limittuák si Apu Kesu nga nepanáddak nira. Á kinagi na nira, “Á napiá ta ajjan kayu ngámin saw,” kun na. ");
INSERT INTO att_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Á nakaddák ira ánna nepallà yù assing da, ta kagiad da ta annáni. ");
INSERT INTO att_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Á kinagi na nira, “Anni má ta maganássing kayu? Anni má ta arán naw kurugan ta sikán yaw? ");
INSERT INTO att_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Innan naw yù limâ ánna takkì, tapè ammu naw ta sikán yaw. Tangngalán nawà, tapè kurugan naw nga aringà annáni. Ta yù annáni, awán ta pattak na ánna tuláng na. Ngam sikán, masingan naw ta ajjan yù tuláng ku ánna pattak ku,” kun na. ");
INSERT INTO att_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Á pakkagi ni Apu Kesu karannian, inipasingan na nira yù limá na ánna takki na. ");
INSERT INTO att_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ngam napállâ ira nga nabbábáng paga, gapu ta nerallà yù ayâ da. Á yáyù nga kinagi na nira, “Egga panò kanan saw nikayu?” kun na. ");
INSERT INTO att_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","“Ajjan!” kud da. Á iniyawâ da yù sirá nga nesuppá. ");
INSERT INTO att_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Á kinán na ta arubáng da ngámin. ");
INSERT INTO att_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Á kinagi na gapay ni Apu Kesu sù ira mapulu tádday ánna yù ira káruán nga kábulud da, “Á yù ngámin nga nesimmu nikán, nakagì ngaw nikayu ta keggâ lâ paga nikayu. Ta kinagì ta máwák nga mapatuppál yù ngámin nga meyannung nikán nga netúrâ sù libru nga tunung ni Moyses ánna yù libru nayù ira káruán nga ábbilinán ni Namarò, ánna yù netúrâ sù libru nga Salmo, nga kansion nga áddáyo ra kâ Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Á pagubobuk ni Apu Kesu karannian, pinannawák na yù nonò da, tapè mánnámmuád da yù inipetúrâ na ngaw ni Namarò sù ira ábbilinán na. ");
INSERT INTO att_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Á kinagi na nira, “Ajjan yù dán nga netúrâ, nga maparigâ nga matay yù Mammaguray nga sinullà ni Namarò, á maginnanolay sù mekatallu nga ággaw. ");
INSERT INTO att_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Á ajjan gapay yù dán nga netúrâ, nga máwák nga melayalayâ yù bilin ni Namarò ta ngámin nga lugár, ta mabbabáwi yù ira ngámin makkakerumá nga tatolay sù liwiliwâ da, ánna mangikatalà ira nikán, tapè pakomán ni Namarò ira. Á sawe Jerusalem yù pangigapuád da nga mangilayalayâ. ");
INSERT INTO att_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Á sikayu yù umay mangipakánnámmu nikán, gapu ta nasingan naw yù ngámin nga nesimmu nikán. ");
INSERT INTO att_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngam ari kayu lábbì mánaw sawe ili, ta dobak ku sangaw nga umay nikayu yù Mangilin nga Ikararuá nga initabbá na ngaw nayù Yámà. Á iddagán naw yù tappì na, nga maggapu ta lángì, ta iyawâ na nikayu yù pakáwayyá naw.” ");
INSERT INTO att_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Á sù dattál nayù oras nga páno ni Apu Kesu nga umay ta lángì, á iniyánge na yù ira siminuttul kuna ta lawán na Jerusalem áddè ta babálay na Bitania. Á labbè da tán, á sinonnâ ni Apu Kesu yù limá na, á kinagi na yù pangikállà ni Namarò nira, nga pamindision na nira. ");
INSERT INTO att_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Á pakkagi na karannian, nánawán na ira, á neyángay ta lángì. ");
INSERT INTO att_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Á yù ira ngámin nga siminuttul kuna, jináyo ra si Apu. Á nanoli ira laguk ta Jerusalem nga nerallà yù ayâ da. ");
INSERT INTO att_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Á yáyù nga kággággaw manotoli ira sù mangilin nga kapilliá, nga maddáyaw kâ Namarò.");
INSERT INTO att_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gári, sù ngaw lage na kaparò na dabbuno, egga yù mangngágan ta Ubobuk ni Namarò. Á yù mangngágan ta Ubobuk ni Namarò yù kapulupulù ni Namarò, nga magubobuk sù ubobuk ni Namarò. Á aggina si Namarò. ");
INSERT INTO att_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Á ta áddè ngaw kapámmegapu na ngámin, dán nga maggián kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Á megapu sù mangngágan ta Ubobuk ni Namarò, pinarò ni Namarò yù ngámin nga ajjan, á awán bulubugá ta pinarò na nga ari megapu sù pagubobuk na. ");
INSERT INTO att_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Á sigga-inángà yù Ubobuk ni Namarò, nga manotolay, nga paggapuán nayù inángà na ngámin nga matolay. Á aggina yù meyárik ta nawák, nga mamannawák ta nonò na tolay, gapu ta ipakánnámmu na si Namarò. ");
INSERT INTO att_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Á ta kunnay ta pannawagan na nawák yù kallà, á pannawagan nayù meyárik ta nawák yù nonò na tolay. Ta arád da ammu si Namarò, á kunnay ta maggián ira ta kallà. Á arán na bulubugá máppù na kallà yù nawák. ");
INSERT INTO att_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Á sinullà ni Namarò yù tolay nga mangngágan ta Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Á jinok ni Namarò si Kuan ta umay mangipakánnámmu ta meyannung sù tádday nga umay, nga meyárik ta nawák, tapè ajjan yù awayyá nayù ira ngámin nga tatolay nga mangikatalà ánna manguruk kuna, megapu sù pangituddu ni Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ari si Kuan yù meyárik ta nawák, ngam minay galâ, tapè ipakánnámmu na yù tádday nga meyárik ta nawák. ");
INSERT INTO att_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yù MagUbobuk yù kukurugán nga meyárik ta nawák, nga duttálin ta dabbuno, nga mamannawák ta nonò na ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jimittál yù MagUbobuk ta dabbuno. Á mássiki nu pinarò ni Namarò yù ira ngámin nga tatolay ta dabbuno megapu sù pagubobuk nayù MagUbobuk, ngam arád da natákkilalán. ");
INSERT INTO att_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Á yá labbetán na ta dabbuno yù lugár nayù ira ikáttole na, ngam arád da inalawâ. ");
INSERT INTO att_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngam ajjan yù ira nga mangalawâ ánna mangikatalà kuna, á iniyawâ na nira yù pakáwayyá ra nga mabbáli ta ánâ ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Á yù pabbáli ra ta ánâ ni Namarò, ari megapu sù pangatáwa nayù ira darakal da. Á ari megapu sù pakkaragâ na tolay, onu yù ure ra. Ngam si Namarò galâ yù mamabbalin nira ta ánâ na. ");
INSERT INTO att_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Á dattál nayù MagUbobuk ta dabbuno, nabbáli ta tolay, nga neyanâ ta tolay ánna nakipaggián ta tolay. Aggina yù siggapiá ánna sigga-allà nga minángngikállà ta tolay, á kuruk ngámin yù kinagi na. Á sikami, nasingam mi yù dalingáráng na nga naggapu sù Yáma na, nga dalingáráng nga iniyawâ nayù Yáma na sù táttádday nga Anâ na. ");
INSERT INTO att_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Á yù MagUbobuk, aggina yù inipakánnámmu na ngaw ni Kuan. Inikatakatol na ngaw ni Kuan, á kinagi na, “Aggina yù kinagì nikayu nga maporián nga tumubbâ nikán, nga makáwayyá ánnè nikán, ta mannanáyun nga egga sù ngaw aringà paga neyanâ,” kun na. ");
INSERT INTO att_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Á gapu ta sigga-allà yù MagUbobuk, mesipà ittam sù pangikállà na nittam. Á ta kággággaw lannapán na yù iyawâ na nittam megapu sù ángngikállà na, ta uputan na yù pangikállà na nittam nga awán ta áddè na. ");
INSERT INTO att_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Si Lákay Moyses, nga yù ngaw ábbilinán ni Namarò, aggina yù nangituddu sù tunung ni Namarò. Ngam si Apu Kesu Kiristu yù mangipakánnámmu sù allà ni Namarò nittam, ánna ipakánnámmu na gapay nittam yù ngámin nga kuruk nga meyannung kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Á kuruk gemma nga awán bulubugá ta tolay nga nakasingan kâ Namarò. Ngam yù táttádday nga Anâ ni Namarò nga ajjan kuna ánna iddukan na, aggina yù mangipakánnámmu sù Yáma na. ");
INSERT INTO att_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Á yù ira karakalán na Kudio nga naggián ta Jerusalem, jinok da yù ira pári ánna yù ira kábulud da nga ginaká ni Lákay Libi, ta ed da iyabbû kâ Kuan yù meyannung ta baggi na. “Asinni ka?” kud da kâ Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Á arán na inilímak nira ni Kuan yù kuruk. Kinagi ni Kuan nira, “Ari sikán yù mangiyígù nga mangngágan ta Kiristu nga iddagát tam ta umay nga mammaguray ta dabbuno,” kun na. ");
INSERT INTO att_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Á asinni ka laguk? Sikaw panò si Lákay Elias nga yù ngaw ábbilinán ni Namarò nga kagiad da ta manoli?” kud da kâ Kuan. Á “Ari,” kun ni Kuan. Á namidduá ira nga nangiyabbû, á kinagi ra, “Ari panò sikaw yù ábbilinán ni Namarò nga iddagám mi?” kud da. “Ari,” kun ni Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Á kinagi ra laguk kuna, “Kagiam mu ngè nu asinni ka, tapè ammu mi yù kagiam mi sù ira naddok nikami. Anni kagiam mu nga meyannung ta baggim?” kud da. ");
INSERT INTO att_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Á initabbák ni Kuan yù kunnay sù dán nga netúrâ nga ubobuk ni Lákay Isaya, nga yù ngaw ábbilinán ni Namarò. Kinagi ni Kuan nira, “Sikán yù makkatakatol ta kalállammatán. Yá ikatakatol ku, ‘Umayin si Apu. Tunungan naw yù pallakarán na.’ ” ");
INSERT INTO att_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Á ajjan gapay yù ira nga jinok nayù ira karakalán na Kudio, nga Parisio. ");
INSERT INTO att_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Á iniyabbû da laguk kâ Kuan, “Nu ari sikaw yù MakKiristu nga mammaguray, onu si Lákay Elias, onu yù ábbilinán ni Namarò nga iddagám mi, á ngattá, ta manigù ka?” kud da. ");
INSERT INTO att_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Á kinagi ni Kuan nira, “Á sikán, danum lâ yù ipanigù ku. Ngam ajjanin nikayu yù tádday nga arán naw ammu. ");
INSERT INTO att_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aggina yù maporián nga tumubbâ nikán, nga makáwayyá ánnè nikán, á aringà mepángngà nga mangubbák ta kaddang na sapátù na.” ");
INSERT INTO att_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Á nesimmu ngámin danniaw túrin ta Bitania ta dammáng na danum na Jordan, ta keggá na ngaw ni Kuan nga nanigù sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Á ta tádday ággaw, nasingan ni Kuan si Apu Kesu nga mappángè kuna. Á kinagi ni Kuan sù ira tatolay, “Aggina yù meyárik ta karneru, ta aggina yù iyawâ ni Namarò nga meyátáng, tapè mári yù ngámin nga liwâ na tolay. ");
INSERT INTO att_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aggina yù kinagì nikayu nga maporián nga tumubbâ nikán, nga makáwayyá ánnè nikán, ta egga nga mannanáyun sù ngaw aringà paga neyanâ. ");
INSERT INTO att_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Á mássiki sikán, sù ngaw, arák ku ammu nu asinni. Ngam yáyù nga minayà ta danum na Jordan nga manigù sù ira tatolay, tapè aggina yù mepakánnámmu sù ira ginaká ni Kákay Israel,” kun ni Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Á kinagi na laguk ni Kuan, “Nasingak ku yù Ikararuá ni Namarò ta pappagukák na nga kun na kalapáti nga maggapu ta lángì, á minay naddappá nga naggián sù tádday nga tolay. ");
INSERT INTO att_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Á arák ku paga natákkilalán. Ngam si Namarò nga naddok nikán ta umayà manigù, kinagi na nikán, ‘Masingam mu sangaw yù Mangilin nga Ikararuá nga mappagukák, á maddappá nga maggián sù tádday nga tolay. Aggina yù sinullà ku ta manigù ta tolay, nga tanakuán yù ánnigù na. Ta ari danum yù ipanigù na, nu ari galâ yù Mangilin nga Ikararuá, nga ipepulù na sù ira tatolay,’ kun ni Namarò nikán. ");
INSERT INTO att_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Á gapu ta nasingak ku yù pappagukák nayù Mangilin nga Ikararuá ni Namarò nga naggapu ta lángì ta kun na kalapáti, nga naddappá nga naggián táne tolay, á yáyù nga ipakánnámmù nikayu ta aggina yù Anâ ni Namarò,” kun ni Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Á ta tádday nga ággaw, ajjan di Kuan ánna duá ira nga tudduán na. ");
INSERT INTO att_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Á nasingan ni Kuan si Apu Kesu nga mattalebák nira. Á kinagi ni Kuan sù ira kábulun na, “Yane yù meyárik ta karneru, gapu ta iyawâ ni Namarò, tapè mári yù liwâ na tolay!” ");
INSERT INTO att_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Á pakaginná nayù ira duá nga kábulun ni Kuan sù kinagi na, sinuttul da si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Á nallipay si Apu Kesu, á nasingan na yù ira tumuttul kuna. Á kinagi na nira, “Anni yù ikáyâ naw?” Á iniyabbû da, “Rabbi, sisaw paggianám mu?” kud da. Á “Mesturu” yù kebalinán na Rabbi. ");
INSERT INTO att_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Á kinagi ni Apu Kesu nira, “Et tamin ta en naw innan,” kun na. Á binulud da laguk tapè masingad da yù paggianán na. Á nepagammâ ira kuna, gapu ta púgágin yù labbè da. ");
INSERT INTO att_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Á si Andares nga wagi ni Simon Eduru yù tádday sù ira duá nga siminuttul kâ Apu Kesu ta pakaginná ra sù kinagi ni Kuan. ");
INSERT INTO att_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Á dagarágâ en na laguk inalek ni Andares si Simon nga wagi na. Pakálek na kuna, kinagi na, “Nesimmuám mi ngin yù Messiya!” kun ni Andares. Á yù kebalinán na “Messiya” yù “MakKiristu, nga kamotungán nga patul nga initabbá na ngaw ni Namarò nga umay mammaguray ta ngámin nga dabbuno.” ");
INSERT INTO att_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Á inituluk ni Andares si Simon nga wagi na kâ Apu Kesu. Á inni-innan ni Apu Kesu si Simon, á iniyabbû na kuna, “Á sikaw laguk si Simon, nga anâ ni Kuan? Ingágat taka ta Eduru,” kun ni Apu Kesu kuna. Á “Batu” yù kebalinán na “Eduru.” ");
INSERT INTO att_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Á ta tádday ággaw, ninonò ni Apu Kesu ta umay ta Galilia. Á nesimmuán na si Pilippi. Á kinagi na kuna, “Tuttulam mà,” kun na kâ Pilippi. ");
INSERT INTO att_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Taga Betseda gapay si Pilippi, nga keliád di Andares kâ Eduru. ");
INSERT INTO att_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Á nálerán na laguk ni Pilippi si Nataniel, á kinagi na kuna, “Nálerám mi ngin yù tolay nga kakágiad da ngaw di Lákay Moyses ánna yù ira ngaw ábbilinán ni Namarò, nga netúrâ sù tunung ánna yù dán nga netúrâ. Ajjan tuke. Aggina si Apu Kesu nga taga Nasaret, nga anâ ni Lákay Kusè,” kun ni Pilippi kâ Nataniel. ");
INSERT INTO att_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Egga panò yù napiá nga taga Nasaret?” kun ni Nataniel kuna. “Á et ta ngè innan,” kun ni Pilippi kuna. ");
INSERT INTO att_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Á pakáranni ra ta gián ni Apu Kesu, nasingan na laguk ni Apu Kesu si Nataniel nga mappángè kuna. Á kinagi ni Apu Kesu sù ira kábulun na, “Aggina yù tolay nga kuruk nga ginaká ni Israel, nga ajjan kuna yù napiá nga nonò nga awán ta jibak,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Á iniyabbû ni Nataniel kuna, “Kunnasi nga ammum yù nonò ku?” kun na. “Nasingat taka ta kapállirum mu paga ta káyu nga igò, sù arán na ka paga jinagâ ni Pilippi,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Á kinagi ni Nataniel kuna, “Mesturu, sikaw yù Anâ ni Namarò! Sikaw yù Patul nga mammaguray nikami nga ginaká ni Kákay Israel!” kun na. ");
INSERT INTO att_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Á kinagi ni Apu Kesu kâ Nataniel, “Yaw panò ipanguruk mu nikán yù pakkagì ta nasingat taka sù silárung na igò? Ngam masingam mu paga noka yù akka-akkuák ku nga makapállâ ánnè sawe. ");
INSERT INTO att_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Á kukurugán nga kuruk yù ngámin nga kagiak ku nikayu. Masingan naw noka yù pabbukâ na lángì ánna yù ira daroban ni Namarò nga mánaw nga umay ta utun ánna mappagukák nga umay nikán, sikán nga Kaká ngámin na tatolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Á pappasá na duá nga ággaw áddè sù pakiubobuk ni Apu Kesu kâ Nataniel, ajjan yù bodá ta ili na Kana sù purubinsia na Galilia. Á ajjan tán yù yená ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Á inapà da gapay di Apu Kesu ánna yù ira tudduán na. ");
INSERT INTO att_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Á yù ira tatolay nga nakibodá, napúnu ra yù binaráyáng. Kapúnu na binaráyáng, en na kinagi nayù yená ni Apu Kesu kuna, “Napúnungin yù binaráyáng,” kun na. ");
INSERT INTO att_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Á kinagi ni Apu Kesu sù yená na, “Paguráyám mu, Innò, ta ammù gemma. Ari paga jimittál yù oras nga sinullà ni Namarò nga kepalappâ ku,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Á kinagi na laguk nayù yená na sù ira aripan, “Mássiki nu anni yù ipakuá na sangaw nikayu, á kurugan naw,” kun na nira. ");
INSERT INTO att_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Á ajjan tán annam nga angáng nga darakal, nga pangipayyád da ta danum nga ájjigután nayù ira Kudio ta meyannung sù kustombare ra nga mappakarenu megapu sù rilisiod da. Á makárgá támma ta límá láta yù taggitádday nga angáng. ");
INSERT INTO att_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Á kinagi ni Apu Kesu sù ira aripan, “Pannuan naw yù ira angáng ta danum,” kun na. Á pinnu ra ira. ");
INSERT INTO att_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Á kinagi na nira, “Sirutan naw, ta en naw ituluk sù minángngálliuk,” kun na. Á kinuruk da. ");
INSERT INTO att_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Á yù minángngálliuk, kinákkapán na lâ ta baddì yù danum nga nabbáli ta binaráyáng, ngam arán na gemma ammu nu sisaw nangápád da. Ngam yù ira nanágak, aggira lâ makánnámmu sù naggapuán na. Á pangákkâ nayù minángngálliuk, inagálán na yù nobiu. ");
INSERT INTO att_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Á kinagi na kuna, “Gagángay nittam ta papoluat tam yù kasingngatán, á sangaw nu nakapissán ira ta napiá, á paporianat tam yù jikkù. Ngam sikaw, pinakappiám mu yù kasingngatán, á kapangilattuák mu lâ kunangane,” kun na. ");
INSERT INTO att_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Á yù makapállâ nga kingnguá ni Apu Kesu ta keggá na ta bodá sù ili na Kana ta purubinsia na Galilia, yáyù olu nga pinagaddátu na, nga pangipasingan na ta pakáwayyá na. Á pakasingan nayù ira makituddu sù kingnguá na, nangikatalà ira kuna. ");
INSERT INTO att_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Á ta kabalin na yaw, nappupúlù di Apu Kesu nga nánaw nga minay ta Kapernium, aggira ánna yù ira wáwwagi na ánna si innò da ánna yù ira tudduán na, á nakipaggián ira lábbì tán. ");
INSERT INTO att_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Á maddaggunin yù Piestá ta Jerusalem, nga panaddamán nayù ira Kudio sù ngaw pattalebák nayù mangilin nga daroban sù ira ngaw naggaká nira ta keggá ra ta lugár na Egipto. Á minay laguk di Apu Kesu ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Labbè da ta Jerusalem, simillung si Apu Kesu sù mangilin nga kapilliá, á naratang na yù ira minálláku ta báka, karneru, mammánù ánna yù ira minánnáli ta kuártu. ");
INSERT INTO att_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Á inâ ni Apu Kesu yù lubik, nga pidde na ta paligà, á pinaturiák na ira ngámin ánna yù ira ayám da sù mangilin nga kapilliá. Á sinottombá na yù ira lamesá nayù ira minánnáli ta kuártu ánna iniwárì na yù kuártu ra. ");
INSERT INTO att_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Á kinagi na sù ira malláku ta mammánù, “Ipáno naw danniaw. Ngattá, ta pabbalinán naw ta dápun yawe mangilin nga bale nayù Yámà!” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Á pakasingan nayù ira tudduán na sù kingnguá na, ninonò da laguk yù inipetúrâ ni Namarò sù dán nga netúrâ, nga kunniaw: “Apu Namarò, nakalò yù ángngiddù ku sù balem, nga kun na api ta unak ku. Á nepallà yù daddam ku, gapu ta arád da pakimorayán yù balem.” ");
INSERT INTO att_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Á gapu ta pinaturiák ni Apu Kesu yù ira minálláku, minay yù ira karakalán na Kudio, á kinagi ra kuna, “Anni yù ipasingam mu nikami nga makapállâ, nga panákkilalám mi ta ajjan yù pakáwayyám sù kingnguám?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Simibbák si Apu Kesu nira, á kinagi na, “Táttakan naw yawe mangilin nga bale ni Namarò, á ta tallu ággaw patáddagak ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Á kinagi nayù ira Kudio kuna, “Appátapulu ta annam ta dagunin yù pappadde ra sù mangilin nga kapilliá nga bale ni Namarò! Á patáddagam mu panò ta tallu nga ággaw?” kud da. ");
INSERT INTO att_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngam yù mangilin nga bale ni Namarò nga kinagi ni Apu Kesu yù baggi na. ");
INSERT INTO att_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Á ta pappasá na pate ni Apu Kesu ánna yù paginnanole na, yáyù lâ pakanonò nayù ira tudduán na sù kinagi na, á yáyù panguruk da sù ngámin nga inipetúrâ ni Namarò sù dán nga netúrâ ánna yù ngámin gapay nga kinagi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Á ta keggá ni Apu Kesu ta Jerusalem nga nakipiestá, aru yù ira nanguruk kuna ta pakasingad da sù aru nga pinagaddátu na nga makapállâ. ");
INSERT INTO att_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngam arán na ira inikatalà, ta ammu na ta negagángay ta nonò na tolay yù mattá-iki-ikáyâ. Ta ammu na yù nonò na ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Á arán na máwák yù umay maddaránuk kuna ta meyannung sù kakágian nayù ira tatolay ta nonò da, ta ammu na lápay ngámin yù ajjan ta nonò da. ");
INSERT INTO att_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ajjan yù tádday sù ira karakalán na Kudio nga Parisio, nga mangngágan ta Nikudemu. ");
INSERT INTO att_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Á ta tádday nga gabi, minay si Nikudemu nakiubobuk kâ Apu Kesu. “Mesturu,” kun ni Nikudemu kuna, “ammu mi ta sikaw yù mangituddu nga jinok ni Namarò, ta awán gemma ta makapagaddátu ta kun na kingnguám, nu ari mepulù si Namarò kuna,” kun ni Nikudemu kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Á simibbák si Apu Kesu, á kinagi na, “Kukurugán nga kuruk yù kagiak ku nikaw, nga ari bulubugá mesipà yù tolay sù pammagure ni Namarò nu ari moli nga meyanâ,” kun na. ");
INSERT INTO att_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Á kinagi ni Nikudemu, “Á kunnasi? Egga panò yù awayyá na tolay nga meyanâ nu lakalákayin? Makatallung panò paga ta sán ni innò na, tapè mamidduá nga meyanâ?” kun ni Nikudemu. ");
INSERT INTO att_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Á simibbák si Apu Kesu, á kinagi na, “Kukurugán nga kuruk yù kagiak ku nikaw, nu ari moli meyanâ yù tolay megapu sù danum ánna yù Ikararuá ni Namarò, ari mesipà sù pammagure ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ta yá lâ meyanâ ta tolay yù tolay lâ gemma, nga egga kuna yù nonò na tolay. Ngam yù tolay nga moli meyanâ megapu sù Ikararuá ni Namarò, á pabbalinan ni Namarò ta anâ na, nga moli gapay yù nonò na. ");
INSERT INTO att_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ari ka laguk mapállâ sù kagiak ku nikaw, nga máwák naw ngámin moli nga meyanâ. ");
INSERT INTO att_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ta mássiki nu arán naw ammu nu kunnasi yù kesimmu na, á mesimmu gemma. Á yù paddák yù keyarigán na, ta arán naw ammu yù paggapuán na ánna pappángetán na, ngam ginnán naw yù sarò na. Á kunnian gapay sù keyanâ na tolay kâ Namarò megapu sù Ikararuá na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Á kinagi ni Nikudemu kâ Apu Kesu, “Á kunnasi yian?” kun na. ");
INSERT INTO att_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Á simibbák si Apu Kesu, á kinagi na kuna, “Sikaw yù maráyaw nga mangituddu sù ira ikáttole tam nga ginaká ni Israel, ngam arám mu ammu yù kinagì nikaw? ");
INSERT INTO att_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kukurugán nga kuruk yù kagiak ku nikaw. Á kagiak ku yù ammù ánna yù nasingak ku. Ngam sikayu nga Parisio, arán naw kurugan yù kagiak ku. ");
INSERT INTO att_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Á nu arán naw kurugan yù kinagì nikayu nga meyannung ta dabbuno, manguruk kayu panò nu kagiak ku nikayu yù meyannung ta lángì? ");
INSERT INTO att_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Awán bulubugá ta minay ta lángì nu ari lâ sikán nga naggapu ta lángì, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Á gári, ta keggá ri Moyses ánna yù ira ginaká ni Israel ta kalállammatán, pidde ni Moyses yù baronsi ta siná-iráw, nga initaráng na ta káyu nga inisiddà na ta dabbun, tapè mammapiá yù ira kinagâ na iráw ta pattánguk da kuna. Á kunniúrin gapay yù keyarigák ku. Ta sikán nga Kaká na ngámin na tatolay, ipotud dangà sangaw nga mepátà ta kurù nga patáddagad da. ");
INSERT INTO att_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Á yù ira ngámin nga mangikatalà nikán, mepattolay ira kâ Namarò, á mesipà ira sù pammagurayán ni Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Á gapu ta napasigaggà yù ángngiddù ni Namarò sù ira tatolay ta dabbuno, yáyù nga iniyawâ na yù Anâ na nga táttádday ta metapil megapu nira, tapè aggira ngámin nga mangikatalà kuna, ari ira mesinná kâ Namarò, nu ari galâ nga mesipà ira nga mepattolay kuna ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta yáyù gapu na nga jinok ni Namarò yù Anâ na ta dabbuno, nga ari nga mamagikáru ta tolay, nu ari galâ ta aggina yù magikáru ta liwiliwâ nayù ira ngámin nga tatolay, tapè meyígù ira megapu kuna. ");
INSERT INTO att_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Á yù ira nga mangikatalà sù Anâ ni Namarò, ari ira mekanâ sù pamagikáru ni Namarò. Ngam yù ira nga ari mangikatalà kuna, nekanâ iren sù pamagikáru ni Namarò, gapu ta arád da ikatalà yù táttádday nga Anâ ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Á yáyù nga pagikaruan ni Namarò ira, gapu ta minayin ta dabbuno yù Anâ na, nga mamannawák ta nonò na tolay, ngam manakì yù ira tatolay kuna. Á yá ipanakì da, ta arád da ikáyâ yù nawák, nu ari galâ yù kallà yù ikáyâ da, gapu ta narákè yù akka-akkuád da. ");
INSERT INTO att_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Á ngámin nga tatolay nga narákè yù akka-akkuád da, malussaw ira sù mamannawák, á molang ira umay kuna, marakè mepasingan yù narákè nga akka-akkuád da. ");
INSERT INTO att_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngam yù ira tatolay nga napiá yù akka-akkuád da, umay ira sù mamannawák, tapè mepasingan ta akkuád da lâ yù ngámin nga napiá nga ipakuá ni Namarò nira megapu sù ángngabbák na nira.” ");
INSERT INTO att_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Á ta kabalin na yaw, minay di Apu Kesu ánna yù ira tudduán na ta purubinsia na Judiya, á naggián ira nga nanigù ta tatolay tán. ");
INSERT INTO att_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Á nanigù gapay si Kuan ta gián na Enon nga aranni ta ili na Salim, gapu ta napiá yù danum tán. Á minay yù ira tatolay, tapè makirigù ira kâ Kuan, á jinigù na ira. ");
INSERT INTO att_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ta ari paga nebáluk si Kuan. ");
INSERT INTO att_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Á ajjan yù tádday nga Kudio nga minay nakipereperang ta ubobuk sù ira makituddu kâ Kuan ta meyannung sù kustombare na rilisiod da nga mappakarenu. ");
INSERT INTO att_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Á minay ira laguk kâ Kuan. “Mesturu,” kud da kuna, “manonò mu yù ngaw kabbulum mu nga inipakánnámmum nikami ta paggiát tam ngaw ta dammáng na Jordan? Ajjanin nga manigù, á umay yù ira ngámin nga tatolay makirigù kuna!” kud da kâ Kuan. ");
INSERT INTO att_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Á simibbák si Kuan, á kinagi na nira, “Á napiá laguk, ta si Namarò yù mangiyawâ kuna ta pakáwayyá na sù akkuán na, ta awán ta pakáwayyá na tolay nga arán na iniyawâ ni Namarò kuna. ");
INSERT INTO att_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Á sikayu, naginná naw yù kinagì ngaw nikayu, nga aringà MakKiristu nga umay mammaguray. Sikán galâ yù pinapolu ni Namarò nga umay mangipakánnámmu kuna, tapè manguruk kayu kuna. ");
INSERT INTO att_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Á nu ángngarigán ta ajjan yù bodá, yù nobiu yù mangalawâ ta babay nga atáwa na. Á yù kopun nayù nobiu, nepallà yù pagayáyâ na sù labbè nayù nobiu. Á kunnay gapay nikán, ta nepallà yù pagayáyâ ku megapu sù ira tatolay nga umay kâ Apu. ");
INSERT INTO att_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kuruk nga aggina yù mepotun nga meparáyaw. Ngam sikán, máwák ta gukágà lâ gukák,” kun ni Kuan nga Minánnigù. ");
INSERT INTO att_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Á yù Anâ ni Namarò yù naggapu ta lángì, á aggina yù kotunán ta ngámin. Á yù ira tatolay nga yawe dabbuno yù paggapuád da, á maggián ira lâ ta dabbuno, á ammu ra lâ yù meyannung ta dabbuno, ánna yáyù lâ ubobugad da. Ngam yù naggapu ta lángì, aggina yù kotunán nga makáwayyá ta ngámin. ");
INSERT INTO att_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Á ubobugan na yù nasingan na ánna naginná na ta lángì, ngam awán garè ta manguruk sù kagian na. ");
INSERT INTO att_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ngam yù ira tatolay nga manguruk sù bilin na, ipakánnámmu ra ta kuruk yù ngámin nga ubobuk ni Namarò, megapu sù panguruk da. ");
INSERT INTO att_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","“Á si Apu Kesu Kiristu yù jinok ni Namarò, á ipakánnámmu na yù ubobuk ni Namarò, ta awán ta pakáddekán nayù pakapangnguá na ánna pakáwayyá na megapu sù Ikararuá ni Namarò nga iniyawâ na kuna. ");
INSERT INTO att_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ta iddukan ni Namarò yù Anâ na, ánna inikatalà na kuna yù pakáwayyá na ta ngámin nga egga ta lángì ánna dabbuno. ");
INSERT INTO att_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Á yù tolay nga mangikatalà sù Anâ ni Namarò, mesipà kâ Namarò nga mepattolay kuna ta áddè ta áddè. Ngam yù tolay nga ari manguruk sù Anâ ni Namarò, ari bulubugá mepattolay kâ Namarò, nu ari galâ ta ukuman na ira ni Namarò, ánna pagikaruan na ira ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Á yù ira karakalán na Kudio nga Parisio, narámak da ta napakáru yù ira tatolay nga umay makituddu ánna makirigù kâ Apu Kesu ánnè sù ira nga makituddu ánna makirigù kâ Kuan. ");
INSERT INTO att_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ngam ari gemma si Apu Kesu yù manigù, nu ari galâ yù ira tudduán na. ");
INSERT INTO att_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Á pakaginná ni Apu Kesu ta narámak nayù ira Parisio yù pakirigù nayù ira tatolay sù gián na, nánaw laguk ta Judiya nga nepulù sù ira tudduán na, ta umay ira ta purubinsia na Galilia. ");
INSERT INTO att_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Á pallakák di Apu Kesu nga umay ta Galilia, mattalebák ira sù purubinsia na Samaria. ");
INSERT INTO att_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Á nakáddè ira ta ili na Sikar sù purubinsia na Samaria nga aranni ta dabbun nga bittáng na ngaw ni Akup sù ngaw anâ na, nga si Kusè. ");
INSERT INTO att_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Á ajjan tán yù bubun ni Akup. Á gapu ta nabannák si Apu Kesu ta pallakalakák na, nagitubang ta aggik na bubun. Á tangngá na ággaw yù labbè da tán. ");
INSERT INTO att_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pagitubang ni Apu Kesu ta aggik na bubun, minay nanágak yù babay nga taga Samaria. Á kinagi ni Apu Kesu kuna, “Penumam mà bì,” kun na sù babay. ");
INSERT INTO att_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ta nánawin garè yù ira makituddu kâ Apu Kesu, nga minay ta ili, ta ed da gatángan yù kanad da. ");
INSERT INTO att_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Á yù babay nga kobobuk ni Apu Kesu, nakaddák ta pakiubobuk na kuna, gapu ta iluddè nayù ira Kudio yù ira taga Samaria. Á yáyù nga simibbák yù babay, á kinagi na kâ Apu Kesu, “Kunnasi laguk ámmenum ku nikaw, ta sikaw, Kudio ka. Ngam sikán, taga Samariangà,” kun nayù babay kuna. ");
INSERT INTO att_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Á simibbák si Apu Kesu, á kinagi na kuna, “Nu ammum nakuan yù iyawâ ni Namarò ta tolay, á nu ammum gapay nakuan nu asinningà nga makkiddaw nikaw, á sikaw nakuan laguk yù makkiddaw nikán ta inumam mu, á iyawâ ku nikaw yù tanakuán nga danum nga manotolay ta áddè ta áddè,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Apu,” kun nayù babay kuna, “awán ka gemma ta itágak, á alaram yawe bubun! Sisaw pangápám mu sù danum nga manotolay ta áddè ta áddè? ");
INSERT INTO att_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ta gári, si Kákay Akup nga yù ngaw naggaká nittam, aggina yù nakkokkok sawe bubun nga bittáng na nikami. Á aggira ngaw ánna yù ira ngámin nga ánâ na ánna ayám da, ininum da yù sinágak da sawe bubun. Makáwayyá ka panò ánnè kâ Kákay Akup?” kun nayù babay. ");
INSERT INTO att_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Á simibbák si Apu Kesu kuna, á kinagi na, “Yù ira ngámin nga ámminum ta danum na yawe bubun, mapangál ira paga sangaw. ");
INSERT INTO att_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ngam yù tolay nga ámminum sù tanakuán nga danum nga iyawâ ku, ari ngin bulubugá mapangál. Ta nu inuman na yù iyawâ ku, mabbáli ta kun na wek ta unak na, nga mallatuâ nga manotolay kuna ta áddè ta áddè,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Á kinagi nayù babay kuna, “Apu, iyawâ mu bì nikán, tapè aringà mabannák nga manoli sawe bubun nga umay manágak,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Á pakkiddo nayù babay, kinagi na laguk ni Apu Kesu kuna, “Em mu bì agálán yù atáwam, ta umay kayu saw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Awánà ta atáwa,” kun nayù babay. Á kinagi ni Apu Kesu kuna, “Wan ay, kuruk yù kinagim, nga awán ka ta atáwa. ");
INSERT INTO att_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ngam límá gemma ngin yù nangatáwa nikaw. Á yù laláki nga kabbulum mu kunangane, ari nga kukurugán nga atáwam. Kuruk yù kinagim nga awán ka ta atáwa,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Á kinagi nayù babay, “Apu, sikaw yù ábbilinán ni Namarò lagugam! ");
INSERT INTO att_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Á ajjan bì yù iyabbû ku nikaw. Yù ira naggaká nikami nga taga Samaria, yawe puddul yù naggagammungád da ta pakimore ra kâ Namarò. Ngam sikayu nga Kudio, kagian naw ta Jerusalem nakuan yù paggagammungán nayù ira tatolay nga umay makimoray kâ Namarò. Sisaw gián na laguk nayù kuruk nga paggagammungát tam nga makimoray kâ Namarò?” kun nayù babay. ");
INSERT INTO att_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Á kinagi ni Apu Kesu kuna, “Kurugam mu yù kagiak ku nikaw. Duttál sangaw yù ággo na nga ari sawe puddul ánna ari tuke Jerusalem yù paggagammungán nayù ira tatolay nga makimoray kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Á sikayu nga taga Samaria, makimoray kayu, ngam arán naw garè ammu nu asinni yù pakimorayán naw. Ngam sikami nga Kudio, ammu mi yù pakimorayám mi, ta Kudio gemma yù naggaká sù mangiyígù ta tolay. ");
INSERT INTO att_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Á umayin yù ággo na, mássiki kunangane, nga ajjan yù ira nga kuruk nga makimoray kâ Namarò nga Yáma tam ta lángì, nga ari nga áppa-áppè yù pakimore ra, ngam kukurugán nga makimoray ira megapu sù nonò da ánna megapu sù panguruk da, gapu ta kunniaw nga tatolay yù agálán ni Namarò nga Yáma tam nga umay makimoray kuna. ");
INSERT INTO att_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Namarò yù sigga-inángà nga ari masingan, nga manotolay ta tolay. Á yù ira tatolay nga makimoray nakuan kuna, máwák da makimoray kuna megapu sù nonò da ánna yù panguruk da kuna,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Á kinagi nayù babay kuna, “Á sikán, ammù gemma ta umay ta dabbuno yù Mangiyígù nga mammaguray nittam. Aggina yù mangngágan ta Kiristu. Á sangaw nu lubbè, aggina yù mangipakánnámmu nittam ta ngámin nga kuruk,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Á kinagi ni Apu Kesu kuna, “Sikán yaw nga makiubobuk nikaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Á ta pagubobuk na paga ni Apu Kesu sù babay, limibbè yù ira tudduán na nga naggapu ta ili, á narángnganád da ira. Á nakaddák ira ta pakiubobuk ni Apu Kesu sù babay, ngam awán ta nangiyabbû kuna nu anni yù ikáyâ nayù babay, onu anni yù gapu na nga pakiubobuk ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Á yù babay, pakaginná na sù kinagi ni Apu Kesu kuna, dagarágâ nga nánaw laguk nga bittáng na yù ammutu na, á nanoli ta ili. Á en na kinagi sù ira katangelián na, ");
INSERT INTO att_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Et tamin, ta en naw innan yù tolay nga nakkagi nikán ta ngámin nga kingnguâ. Ari panò aggina yù Mangiyígù nga mangngágan ta Kiristu, nga iddagát tam?” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Á nánaw ira laguk ta ili, ta ed da innan si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Á ta kapapáno nayù babay kári Apu Kesu ta bubun, á yù ira tudduán ni Apu Kesu, kinagi ra kuna, “Mesturu, kumán ka bì,” kud da. ");
INSERT INTO att_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngam simibbák si Apu Kesu, á kinagi na nira, “Ajjan yù tanakuán nga kanak ku nga arán naw ammu,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Á yáyù nga nakkaká-abbû yù ira tudduán na, á kinagi ra, “Egga panò yù minay nangiyawâ kuna?” kud da. ");
INSERT INTO att_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Á kinagi ni Apu Kesu nira, “Yaw galâ ipakkatolè yù pamalurò ku sù ure ni Namarò nga naddok nikán ánna yù panuppál ku sù ipakuá na nikán. ");
INSERT INTO att_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ari panò nakagi nikayu ta ajjan paga appátabulán áddè ta ággagaták? Ngam kagiak ku nikayu ta namegapungin yù paggagaták. Irípâ nawè yù ira tatolay nga umayin nikán. Meyárik ira ta ammay nga nalutu, nga máyâ magatágin kunangane, ta naparán iren nga umay manguruk nikán. ");
INSERT INTO att_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Á yù ira nga mamatuttul nira, málâ da yù napiá nga bálà da. Á yù ira nga patuttulad da nikán, málâ da yù kepáttole ra kâ Namarò ta áddè ta áddè. Á yáyù nga mepagayáyâ ira, nga kunnay sù ira mammulá ánna yù ira maggaták. ");
INSERT INTO att_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ta kuruk yù dán nga nakagi, nga ‘Ajjan yù mammulá, á tanakuán yù umay maggaták.’ ");
INSERT INTO att_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Á dobat takayu, ta en naw patuttulan yù ira tatolay nga arán naw sinudduán. Á ajjan yù ira nangituddu nira nga napolu ánnè nikayu, tapè mesipà kayu sù pabbalinán na bannák na baggi ra.” ");
INSERT INTO att_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Á aru yù ira nga taga Sikar nga nangikatalà kâ Apu Kesu megapu sù kinagi nayù babay nira, nga kun na, “Kinagi na nikán yù ngámin nga kingnguâ,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Á yáyù nga minay ira kâ Apu Kesu. Á pakáddè da sù gián ni Apu Kesu, inigaggak da ta maggián bì nira. Á naggián si Apu Kesu nira ta duá nga ággaw. ");
INSERT INTO att_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Á kitáru yù ira nga nanguruk megapu sù ubobuk ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Á kinagi ra sù babay, “Ari lâ yù kinagim yù ipanguruk mi kuna, ta gininná mi ngin gapay yù ubobuk na, á yáyù nga ammu mi ta kukurugán nga aggina yù iddanamát tam nga Mangiyígù ta tolay ta dabbuno,” kud da. ");
INSERT INTO att_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Á pappasá na duá nga ággaw, nánaw di Apu Kesu ta Sikar nga minay ta Galilia, nga naddakalán ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Á kinagi na ngaw ni Apu Kesu, “Pakimorayád da yù ábbilinán ni Namarò ta ngámin nga lugár. Ngam yù ira katangelián na, arád da pakimorayán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngam ta labbè ni Apu Kesu ta Galilia, magayáyâ yù ira tatolay nga mamaddulò kuna, gapu ta nasingad da yù pinagaddátu na ta pakipiestá ra ngaw ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Á keggá ni Apu Kesu ta Galilia, nanoli ta ili na Kana ta purubinsia na Galilia, nga gián na ngaw sù pamabbáli na sù danum ta binaráyáng. Á egga tán yù tolay nga kátannangán, nga matakì yù anâ na nga laláki ta bale ra ta ili na Kapernium. ");
INSERT INTO att_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pakaginná nayù tolay ta limibbè si Apu Kesu ta Kana, nga naggapu ta purubinsia na Judiya, minay laguk nga nakikomá kuna ta umay ta Kapernium, tapè pammapián na yù anâ na nga magisassay matay. ");
INSERT INTO att_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Á kinagi ni Apu Kesu kuna, “Nu arán naw masingan yù pagaddatuak ku nga makapállâ, egga panò yù ángnguruk naw nikán?” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Apu,” kun nayù tolay, “et ten, ta kúragat ta yù arán na paga patay!” kun na. ");
INSERT INTO att_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Á kinagi ni Apu Kesu kuna, “Lubbè ken, ta nammapiá ngin yù anâ mu,” kun na. Á kinuruk nayù tolay yù kinagi ni Apu Kesu kuna, á nánaw, ta manoli sù gián na. ");
INSERT INTO att_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Á sù tádday ággaw, pallakák nayù tolay paga nga lubbè sù gián na ta Kapernium, nerapunán na ta dálan yù ira aripan na. Á kinagi ra ta nammapiá ngin yù anâ na. ");
INSERT INTO att_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Á iniyabbû na nira nu káni yù pammapiá na. Á kinagi ra kuna, “Kagabi ta pannarek na bilák ta púgák yù kári na kulikuk na,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Á nanonò nayù tolay ta yáyù gapay yù oras nga pakkagi ni Apu Kesu kuna ta nammapiá ngin yù anâ na. Á aggira ngámin nga makkakábbalay, nanguruk ira kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Á ta keggá ni Apu Kesu paga ta Galilia nga naggapu ta Judiya, yawe yù mekaruá nga pinagaddátu na nga makapállâ. ");
INSERT INTO att_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Á kabalid da nappassiár ta ili na Kana, jimittál yù piestá nayù ira Kudio, á giminon di Apu Kesu ta ili na Jerusalem, tapè nakipiestá ira. ");
INSERT INTO att_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Á ajjan ta Jerusalem yù danum nga ájjigután nga mangngágan ta Betseda sù ággubobuk nga Kebru, nga aranni ta puertá na ili nga ángngitallungád da ta karneru. Á nalepuanán yù danum ta límá nga állirumán nga nattutuppang. ");
INSERT INTO att_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Á kitáru yù ira tatolay nga gipeddán nga máttakì nga naggián tán, nga buling, pilay, ánna yù ira natay yù gadduá na baggi ra, ta iddi-iddagád da lâ yù pappalung na danum. ");
INSERT INTO att_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ta ajjan kanu yù daroban ni Namarò nga en na ikáddagâ palapalungan yù danum. Á pappalung na danum, mammapiá yù mapolu nga tolay nga mabbassung kuna. ");
INSERT INTO att_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Á ajjan tán yù tolay nga natakì ta tallupulu ta walu nga dagunin. ");
INSERT INTO att_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Á nasingan ni Apu Kesu, á ammu na ta nagiddá ta nabayágin. Á iniyabbû na laguk ni Apu Kesu kuna, “Ikáyâ mu ta mammapiá ka?” kun na. ");
INSERT INTO att_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Á simibbák yù matakì, á kinagi na kâ Apu Kesu, “Wan, Apu, ngam awán ta mangipay nikán sù danum ta pappalung na. Á pakáddè ku ta danum, ajjanin yù mapolu ánnè nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Á kinagi ni Apu Kesu kuna, “Arà, manáddak ka laguk. Apam mu yù dapam mu, á mallakák ka,” kun na. ");
INSERT INTO att_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Á dagarágâ nammapiá yù tolay, á inâ na yù dapan na, á nallakák nga nánaw. Á Sabadu yù pammapiá nayù tolay, nga ággibannák na Kudio. ");
INSERT INTO att_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Á gapu ta Sabadu yù pammapiá nayù tolay, kinagi nayù ira karakalán nga Kudio kuna, “Sabadu ággawo, nga mangilin nga ággaw. Á mekontará gemma sù tunung tam yù mangáttu ta ággaw nga ággibannák tam. Ngattá, ta káttuam mu yù dapam mu?” kud da. ");
INSERT INTO att_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Á simibbák yù tolay, á kinagi na nira, “Yù tolay nga namammapiá nikán, aggina yù nakkagi nikán ta apak ku yù dapak ku ánna mallakárà,” kun na. ");
INSERT INTO att_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Á iniyabbû da kuna, “Asinni yù tolay nga naddok nikaw ta apam mu yù dapam mu ta mallakák ka?” ");
INSERT INTO att_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngam arán na garè ammu nayù tolay nu asinni yù namammapiá kuna, ta napakáru yù ira tatolay tán, á dagarágâ nga nánaw si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Á manganánnuán, narángnganán ni Apu Kesu yù tolay sù mangilin nga kapilliá, á kinagi na kuna, “Innam mè! Nammapiá ken! Ari ka laguk mamidduá nga malliwâ, marakè mappanà yù mesimmu sangaw nikaw ánnè sù ngaw jigâ mu,” kun na. ");
INSERT INTO att_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Á pakasingan nayù tolay kâ Apu Kesu, á nánaw laguk, á en na kinagi sù ira karakalán nga Kudio ta si Apu Kesu yù namammapiá kuna. ");
INSERT INTO att_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Á yáyù nga napporay yù ira karakalán nga Kudio kâ Apu Kesu, á jinigirigâ da, gapu ta ággaw nga ággibannák da yù pamammapiá na sù matakì. ");
INSERT INTO att_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngam simibbák si Apu Kesu, á kinagi na nira, “Si Namarò nga Ammò ku, uputan na paga yù pattarabáku na, maguray lâ nga ággaw. Á kunnian gapay nikán, mattarabákungà, ta uputak ku nga tuppálan yù ngámin nga ipakuá nayù Yámà nikán, maguray lâ nga ággaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Á yáyù nga nappanà yù lusso nayù ira karakalán nga Kudio kâ Apu Kesu, á inigagánge ra papatáyan, nga ari lâ megapu sù arán na kinuruk nga kustombare ra ta meyannung sù ággaw nga ággibannák da, ngam megapu paga ta pangigittá na sù baggi na kâ Namarò, ta kinagi na ta si Namarò yù yáma na. ");
INSERT INTO att_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Á gapu ta pamaliwâ nayù ira karakalán nga Kudio kâ Apu Kesu, kinagi na laguk nira, “Kukurugán nga kuruk yù kagiak ku nikayu. Arák ku mororay yù akkuák ku. Ngam yá lâ akkuák ku yù masingak ku nga akkuán ni Namarò nga Yámà. Á ngámin yù akkuán nayù Yámà, yáyù gapay akkuák ku, sikán nga Anâ na. ");
INSERT INTO att_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta ayatan nangà nayù Yámà, á yáyù nga ipasingan na nikán yù ngámin nga akkuán na. Á ipakuá na paga sangaw nikán yù akka-akkuák ku nga makapállâ ánnè karannian nga kingnguâ, tapè mapállâ kayu sangaw. ");
INSERT INTO att_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","“Á kunnayà kâ Yámà, ta paginnanolayan na yù ira námmatay, ánna iddán na ira ta inángà tapè matolay ira. Á kunnian gapay yù akkuák ku, sikán nga Anâ na, ta paginnanolayak ku ánna tolayak ku yù ira nga ikáyâ ku tolayan. ");
INSERT INTO att_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Á ari yù Yámà yù mamanunnù ta tolay, nu ari lâ sikán nga Anâ na, ta inikatalà na nikán nga Anâ na yù mamanunnù ta ngámin, ");
INSERT INTO att_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tapè dayáwad dangà nayù ira ngámin nga tatolay ta kunnay sù áddáyo ra kâ Namarò nga Yámà. Á yù tolay nga ari maddáyaw nikán nga Anâ na, arán na gapay dayáwan yù Yámà nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kukurugán nga kuruk yawe nga kagiak ku nikayu. Yù tolay nga magginná ta ubobuk ku ánna manguruk kâ Namarò nga naddok nikán, mepattolay nga mepaggián kâ Namarò ta áddè ta áddè. Á aringin mokum, ta napakomá ngin yù liwiliwâ na, á ásigurán nen ni Namarò, á apan na sangaw nga mesipà kuna ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Á kuruk yù kagiak ku nikayu. Ngámin nga tatolay nga ari paga manguruk nikán, kunnay ta natay iren gapu ta nesinná ira kâ Namarò. Ngam ajjanin yù awayyá ra kunangane nga makaginná ta pagágál ku, á yù ira nga magginná ánna manguruk nikán nga Anâ ni Namarò, mepattolay ira nga mesipà kâ Namarò ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ta sigga-inángà si Ammò ku, nga manotolay. Á sikán gapay, sigga-inángakà, ta iniyawâ ni Ammò ku nikán nga Anâ na yù awayyâ nga manotolay. ");
INSERT INTO att_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Á iniyawâ na gapay nikán yù pakáwayyâ nga mamanunnù ta ngámin, gapu ta sikán yù Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ari kayu mapállâ sù kinagì, ta duttál sangaw yù pakáddekán nga ággaw, á ngámin yù ira námmatay, maginná ra yù ngárál ku. ");
INSERT INTO att_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Á pakaginná ra, mallawán ira sù tanam da. Á yù ira nga napiá yù kingngikingnguá ra ta keggá ra ta dabbuno, maginnanolay ira nga mepattolay kâ Namarò ta áddè ta áddè. Á yù ira nga narákè yù kingngikingnguá ra ta keggá ra ta dabbuno, mallawán ira gapay ta tanam da nga mekanâ sù pangukum ni Namarò, ta pagikaruan na ira,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Á kinagi na laguk ni Apu Kesu, “Arák ku mororay yù akkuák ku, ta si Namarò nga Yámà yù naddok nikán, á ta kun na kagian nayù Yámà nikán, kunnian galâ yù pamanunnù ku. Á yáyù nga matunung yù ámmanunnù ku, ta ari yù urè yù tuttulak ku, nu ari galâ yù ure nayù Yámà. ");
INSERT INTO att_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Á nu sikán lápay nakuan yù makkagi ta meyannung ta baggì, arán naw gemma kurugan yù kagiak ku. ");
INSERT INTO att_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngam ajjan yù tanakuán nga mangipakánnámmu ta meyannung nikán, nga yù Ammò ku, á ammù ta kuruk ngámin yù kagian na. ");
INSERT INTO att_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Á sikayu, jinok naw yù ira mangiyabbû kâ Kuan ta meyannung nikán, á kuruk gapay yù kinagi ni Kuan. ");
INSERT INTO att_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Á arák ku gemma awágan yù tolay nga makkagi ta meyannung nikán, ngam ipanonò ku nikayu yù kinagi ni Kuan, tapè meyígù kayu. ");
INSERT INTO att_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Á meyárik si Kuan ta isingan nga maggatang, ta pannawagan na yù nonò na tolay. Á pakaginná naw ngaw sù pangilayalayâ ni Kuan, nagayáyâ kayu ta mabì. ");
INSERT INTO att_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngam ajjan yù makáwayyá nga mangipakánnámmu ta kuruk yù ubobuk ku, nga yù ira makapállâ nga pinagaddátù, nga inipakuá nayù Yámà nikán. Á danniaw nga inipakuá ni Ammò nikán yù makáwayyá ánnè sù pangilayalayâ ni Kuan. Danniaw yù ipanguruk naw ta si Namarò yù Yámà nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Á yù Yámà nga naddok nikán, aggina gapay yù mangipakánnámmu sù meyannung nikán. Ngam sikayu, arán naw bulubugá gininná yù ngárál na, á arán naw nasingan. ");
INSERT INTO att_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Á arán naw inalawâ yù bilin na, ta arán nawà kurugan, nga jinok na. ");
INSERT INTO att_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Á gigiámmuan naw yù dán nga netúrâ nga ubobuk ni Namarò, gapu ta kagian naw ta yáyù pakálerán naw sù mannanáyun nga ipakkatole naw. Á mássiki uputan naw nga bibbiran dannian nga netúrâ, arán naw tákkilalán ta sikán gemma yù kakágiad da. ");
INSERT INTO att_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngattá, ta manakì kayu manguruk nikán, á sikán yù makáwayyá nga manotolay nikayu ta áddè ta áddè?” kun ni Apu Kesu sù ira Kudio. ");
INSERT INTO att_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Á kinagi na paga ni Apu Kesu sù ira karakalán nga Kudio, “Arák ku aleran yù paddáyo na tolay nikán. ");
INSERT INTO att_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngam ammù gemma yù nonò naw, á ammù ta awán ta ángngiddù naw kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Á minayà nikayu ta pannakabaggi ni Namarò nga Yámà, ngam arán nawà alawatan. Á sangaw nu ajjan yù tanakuán nga umay megapu sù ure na lápay, aggina laguk yù alawatan naw. ");
INSERT INTO att_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Egga panò laguk yù awayyá naw nga manguruk nikán, gapu ta yá galâ aleran naw yù paddáyo nayù ira ikáttole naw, ngam manakì kayu mapalurò sù ipakuá ni Namarò nikayu tapè málâ naw yù paddáyo nayù táttádday nga si Namarò? ");
INSERT INTO att_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Á arán naw laguk kagian ta sikán yù mangikeká nikayu kâ Namarò nga Yámà. Ari sikán yù mangikeká, nu ari galâ si Moyses, nga nangiyawâ sù netúratán nga tunung nga iddanamán naw. Si Moyses yù mangikeká nikayu, ta arán naw kurugan yù initúrâ na. ");
INSERT INTO att_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Á nu kinuruk naw nakuan yù initúrâ na ngaw ni Moyses, á kurugan nawà gapay nakuan, gapu ta sikán yù kakágian na sù initúrâ na. ");
INSERT INTO att_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngam nu arán naw kurugan yù initúrâ na, á kunnasi laguk ta manguruk kayu sù kagiak ku nikayu?” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pappasá na danniaw, ajjan di Apu Kesu ánna yù ira tudduán na nga nanoli ta purubinsia na Galilia. Á ta tádday ággaw, minay ira ta dammáng na Bebay na Galilia, nga mangngágan gapay ta Tiberio. ");
INSERT INTO att_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Á ajjan yù ira magaru nga tatolay nga jimináddán kâ Apu Kesu gapu ta nasingad da yù makapállâ nga pinagaddátu na ta pamammapiá na sù ira máttakì. ");
INSERT INTO att_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Á pakáddè di Apu Kesu ánna yù ira tudduán na ta dammáng, giminon ira ta puddul, á nagitubang ira tán. ");
INSERT INTO att_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Á maddaggunin yù piestá na Kudio nga panaddamád da ta pattalebák nayù daroban ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Á pagitubang da, nerípâ ni Apu Kesu yù ira magaru nga tatolay nga mappángè nira. Á iniyabbû na laguk kâ Pilippi, “Sisaw yù pangápát tam ta ipamakát tam sawe ira magaru nga tatolay?” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Á dán nga ammu ni Apu Kesu yù akkuán na sangaw, ngam yáyù iniyabbû na kâ Pilippi, tapè mepasingan nakuan yù pangikatalà ni Pilippi kuna. ");
INSERT INTO att_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Á kinagi ni Pilippi kuna, “Á kunnasi laguk, Apu, ta napakáru ira. Á mássiki nu pígiá yù kuártu nga igátáng tam nakuan, á makúráng paga yù ipamakát tam sù ira tatolay, mássiki nu isinek tam ta ággibaddì nira,” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Á si Andares yù tádday sù ira makituddu kâ Apu Kesu, nga wagi ni Simon Eduru. Á simibbák si Andares, á kinagi na kâ Apu Kesu, ");
INSERT INTO att_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ajjan saw yù abbing nga egga kuna yù bálun na nga límá bullung nga pán ánna duá nga baddì nga sirá. Ngam pígiá lâ kapúnu na yian sù ira magaru nga tatolay?” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Á kinagi na laguk ni Apu Kesu nira, “Pagitubangan naw ira bì,” kun na. Á nagitubang ira laguk, gapu ta aláwa yù kakáddapán. Á límáribu támma yù biláng da nga lálláki, nu ari nebiláng yù ira bábbay ánna ábbing ira. ");
INSERT INTO att_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Á inâ na laguk ni Apu Kesu yù bálun nayù abbing. Á nakimállà kâ Namarò megapu sù iniyawâ na nga pán ánna sirá, á inipesinek na yù pán. Á nallabbuk yù pán ta pangisinek da sù ira tatolay. Á ta kunnay gapay sù sirá, ta iniddád da ira ta gustu ra nga kanan. ");
INSERT INTO att_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Á kiminán ira ta áddè ta kabattuk da. Á kabalid da kiminán, kinagi ni Apu Kesu sù ira tudduán na, “Unnuran naw yù buná ra, tapè ari metabbà,” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Á inunnuk da laguk yù buná ra, á mapulu duá yù lappi nga napannu sù buná ra. ");
INSERT INTO att_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Á pakasingan nayù ira tatolay sawe pinagaddátu ni Apu Kesu, napállâ ira, á kinagi ra, “Aggina gemma yù ábbilinán ni Namarò nga initabbá na ngaw nga umay ta dabbuno!” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Á natagenà ni Apu Kesu yù nonò da, ta gaputad da nakuan nga puersán nga mappatul nira. Á yáyù nga nánaw nga naguroray nga giminon ta puddul. ");
INSERT INTO att_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Á ta pajjibbà, minutù yù ira tudduán ni Apu Kesu ta aggik na bebay. ");
INSERT INTO att_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Á gapu ta gabingin ánna awán paga si Apu Kesu nira, nappittà ira ta barangay, ta dumákì ira ta dammáng, nga manoli ta ili na Kapernium. ");
INSERT INTO att_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Á pattake ra ta barangay, jimittál yù masikan nga paddák, á nappalapalung yù danum. ");
INSERT INTO att_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Á pangilápák da sù barangay, annam nga kilometro támma yù kárayyu ra ta aggik. Á nasingad da si Apu Kesu nga mallakalakák sù utun na danum nga umay sù barange ra. Á nepallà yù assing da. ");
INSERT INTO att_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngam kinagi ni Apu Kesu nira, “Sikán yaw. Ari kayu maganássing,” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Á ayatán ira nga namattakay kuna ta barangay, á dagarágâ ira nga nakáddè ta aggik. ");
INSERT INTO att_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Á sù tádday ággaw, naggián lâ paga yù ira magaru nga tatolay nga nabattáng ta dammáng, nga magiddak kâ Apu Kesu. Ta nasingad da yù páno nayù ira tudduán ni Apu Kesu sù táttádday nga barangay nga ajjan tán, ánna ari nepattakay si Apu Kesu nira. Á yáyù nga iniddagád da lâ paga. ");
INSERT INTO att_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Á ta pannawák, aru yù ira barangay nga jiminung nga naggapu ta Tiberio. Aranni yù áddungád da sù nakkákanán nayù ira tatolay ta pán ta kabalin ni Apu Kesu nabbalabálà kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Á pakánnámmu nayù ira tatolay ta awán lâ awán si Apu Kesu ánna yù ira tudduán na, á nakipattakay ira laguk sù ira barangay nga naddagâ tán, ta ed da aleran si Apu Kesu ta Kapernium. ");
INSERT INTO att_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Á pakáddè nayù ira tatolay ta dammáng na bebay, nálek da si Apu Kesu. Á pakálek da kuna, kinagi ra, “Mesturu, káni yù ángem saw?” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Á simibbák si Apu Kesu, á kinagi na nira, “Kukurugán nga kuruk yù kagiak ku nikayu. Ari yá ipagalek naw nikán, gapu ta nasingan naw ánna kánnámmuán naw yù kebalinán nayù makapállâ nga pinagaddátù ta arubáng naw. Ngam yá lâ ipagalek naw nikán yù kabattuk naw ta pán. ");
INSERT INTO att_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ari kayu nakuan mabbannabannák nga magala-alek sù kanan nga mabì malabbak. Aleran naw galâ yù tanakuán nga ákkatole naw nga mannanáyun, tapè mepattolay kayu kâ Namarò ta áddè ta áddè. Á sikán nga Kaká na ngámin na tatolay yù mangiyawâ sù ákkatole naw nga mannanáyun, ta sikán yù neddán ni Namarò nga Yámà sù pakáwayyâ,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Á yáyù nga iniyabbû da laguk kâ Apu Kesu, “Anni nakuan yù akkuám mi, tapè tuppálam mi yù ipakuá ni Namarò nikami?” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Á simibbák si Apu Kesu, á kinagi na nira, “Yawe lâ yù ipakuá ni Namarò nikayu, ta ikatalà nawà, ta sikán yù jinok na saw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Á pakaginná ra karannian, kinagi ra kuna, “Á anni laguk yù makapállâ nga ipasingam mu nikami, tapè manguruk kami nikaw? Anni laguk yù akkuám mu? ");
INSERT INTO att_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yù ira ngaw naggaká nittam, gári ta keggá ra ta kalállammatán, kinád da yù inipamakán na nira ni Lákay Moyses nga mangngágan ta manna, ta ajjan yù netúrâ nga, ‘Iniyawâ na nira yù kanad da nga naggapu ta lángì,’ ” kud da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Á kinagi ni Apu Kesu nira, “Kurugán nga kuruk yù kagiak ku nikayu. Tanakuán yù manna nga iniyawâ ni Moyses, nga ari yù kanan nga ubobugak ku. Yù Yámà yù mangiyawâ nikayu sù kuruk nga kanan nga ubobugak ku, nga maggapu ta lángì. ");
INSERT INTO att_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Á yù kuruk nga kanan nga iyawâ ni Namarò nga maggapu ta lángì yù umay saw dabbuno nga manotolay ta tolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Á kinagi ra kuna, “Apu, ta keggá mi nga matolay ta utun na dabbun, sigídá iddák kami ngè sawe kanan,” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Á kinagi ni Apu Kesu nira, “Sikán yù ubobugak ku nga kanan nga maggapu ta lángì. Sikán yù manotolay. Á yù ira nga umay makituddu ánna mangikatalà nikán, ari iren kun na mabisin ánna mapangál, á ari iren bulubugá magala-alek. ");
INSERT INTO att_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngam sikayu, máwák nga kagiak ku lâ má yù kinagì nikayu, ta mássiki nu masingan nawà, awán galâ ta ángnguruk naw nikán. ");
INSERT INTO att_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“Ngam yù ira ngámin nga iyawâ nayù Yámà nikán, aggira yù umay mesipà nikán. Á alawatak ku yù ngámin ira nga umay makituddu nikán, nga arák ku bulubugá papanáwan. ");
INSERT INTO att_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Á yá iniyángè saw nga maggapu ta lángì, ta arák ku tuppálan yù urè, nu ari galâ yù ngámin nga ure nayù Yámà nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Á yawe yù ure nayù naddok nikán, ta ásigurák ku yù ira ngámin nga tatolay nga iniyawâ na nikán, tapè awán bulubugá ta meyawáwán, ngam paginnanolayak ku ira galâ ta panguriánán nga ággaw, tapè mepattolay ira kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta yáyù ure nayù Yámà, ta aggira ngámin nga makituddu ánna mangikatalà nikán nga Anâ na, aggira mannanáyun nga mepattolay kuna ta áddè ta áddè. Á sikán yù mamaginnanolay nira ta panguriánán nga ággaw.” ");
INSERT INTO att_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Á ta pakaginná nayù ira Kudio sù kinagi ni Apu Kesu, nga aggina yù kanan nga naggapu ta lángì, naddagaragim ira. ");
INSERT INTO att_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Á kinagi ra, “Ari panò aggina si Kesu nga anâ di Kusè, ta ammu tam gemma di ammò na kâ innò na!” kud da. “Á ngattá laguk, ta kagian na ta naggapu ta lángì?” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Á simibbák si Apu Kesu, á kinagi na nira, “Mattukkâ kayin nga maddagaragim. ");
INSERT INTO att_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Awán ta umay makituddu nikán nu arán na agálán nayù Yámà nga naddok nikán, á paginnanolayak ku ta panguriánán nga ággaw. ");
INSERT INTO att_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ajjan yù netúrâ nga inipetúrâ ni Namarò sù ira ngaw ábbilinán na, nga kunniaw: ‘Aggira ngámin nga tatolay yù tudduán ni Namarò.’ Á ngámin ira nga magginná ánna manguruk sù ituddu nayù Yámà, aggira yù umay mangikatalà nikán. ");
INSERT INTO att_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Á arák ku kagian ta nasingan na tolay si Namarò nga Yámà. Awán gemma ta nakasingan kâ Namarò nga Yámà, nu ari galâ sikán nga Anâ na nga naggapu ta gián na. ");
INSERT INTO att_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Á kukurugán nga kuruk yù kagiak ku nikayu, ta mannanáyun nga mepattolay kâ Namarò yù ira nga mangikatalà nikán. ");
INSERT INTO att_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Sikán yù áttotole na tolay. Sikán yù manotolay, á yá keyarigák ku yù kanan na tolay. ");
INSERT INTO att_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Á yù ngaw ira naggaká nikayu, mássiki nu kinád da yù ngaw kanan nga manna, ta pallakalakák da túrin ta kalállammatán, ngam natay ira galâ. ");
INSERT INTO att_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngam yù kanan nga ubobugak ku, yáyù yù maggapu ta lángì nga umay saw, tapè ajjan yù awayyá na tolay nga kumán kuna, ánna ari matay. ");
INSERT INTO att_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sikán yawe kanan nga maggapu ta lángì. Nu kumán yù tolay sawe kanan nga ubobugak ku, mannanáyun nga mepattolay kâ Namarò ta áddè ta áddè. Á yù kanan nga iyawâ ku, yáyù yù baggì, nga metapil tapè matolay yù ira tatolay,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Á pakaginná nayù ira Kudio sù ubobuk ni Apu Kesu, makkakápereperang ira ta ubobuk, á kinagi ra, “Kunnasi panò yù ángngipakán na ta baggi na nittam, nga ari gemma makán?” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Á yáyù nga kinagi ni Apu Kesu nira, “Kukurugán nga kuruk yù kagiak ku nikayu. Sikán nga Kaká na ngámin na tatolay, á ta ángngarigán, nu arán naw kanan yù baggì ánna arán naw inuman yù dágà, awán bulubugá ta áttole naw. ");
INSERT INTO att_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngam yù ira ngámin nga kumán ta baggì ánna ámminum ta dágà, mannanáyun nga mepattolay ira kâ Namarò ta áddè ta áddè, á paginnanolayak ku ira ta panguriánán nga ággaw. ");
INSERT INTO att_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta kuruk nga kanan yù baggì, ánna kuruk nga inuman yù dágà. ");
INSERT INTO att_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","“Á yù tolay nga kumán ta baggì ánna ámminum ta dágà, aggina yù mepaggián nikán, á sikán gapay yù mepaggián kuna. ");
INSERT INTO att_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Á yù Yámà nga naddok nikán, aggina yù sigga-inángà nga manotolay, nga paggapuán nayù áttolè. Á yáyù nga matolayà megapu kuna. Á kunnian gapay sù ira ngámin nga kumán ta baggì, matolay ira megapu nikán. ");
INSERT INTO att_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ta sikán yù kanan nga naggapu ta lángì, nga dumá sù ngaw kinán nayù ira naggaká nittam, ta mássiki nu kinád da, ngam natay ira galâ. Ngam yù ira ngámin nga kumán sawe kanan nga ubobugak ku, mannanáyun ira nga mepattolay kâ Namarò ta áddè ta áddè.” ");
INSERT INTO att_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yáyù kinagi ni Apu Kesu sù pangituddu na ta ággagammungán na Kudio ta ili na Kapernium. ");
INSERT INTO att_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Á ta pakaginná nayù ira siminuttul kâ Apu Kesu sù kinagi na, aru yù ira nga manakì sù kinagi na. Á naddagaragim ira, á kinagi ra, “Jikkù yù kagian na. Egga panò yù manguruk sù kagian na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Á mássiki nu awán ta nakkagi kâ Apu Kesu, ngam ammu na lápay ta maddagaragim ira. Á yáyù nga kinagi na nira, “Ngattá, ta manakì kayu sù kagiak ku? ");
INSERT INTO att_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Á anni laguk yù kagian naw sangaw nu masingan nawà nga umay ta lángì, nga manoli ta gián nga naggapuák ku? ");
INSERT INTO att_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yù Ikararuá ni Namarò yù manotolay ta tolay. Á yù sikan na baggi na tolay ánna yù pakáwayyá na, awán ta serbi ra. Yù bilin ni Namarò nga kinagì nikayu, yáyù yù manotolay nikayu ta áddè ta áddè megapu sù Ikararuá ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngam ajjan nikayu yù ira nga ari manguruk,” kun na. Yáyù kinagi ni Apu Kesu nira, gapu ta áddè ngaw, dán nga ammu ni Apu Kesu yù ira nga ari manguruk kuna ánna yù tádday nga mappagápù kuna. ");
INSERT INTO att_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Á kinagi na laguk ni Apu Kesu nira, “Yáyù gapu na nga kinagì nikayu ta awán ta umay manguruk nikán nu arán na iyawâ nayù Yámà nira yù ángnguruk da,” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Á gapu ta panakì da sù ubobuk ni Apu Kesu, aru yù ira nalurâ nga siminuttul kuna, á nánaw ira nga aringin nepulupulù kuna. ");
INSERT INTO att_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Á kinagi ni Apu Kesu sù ira mapulu duá nga sinudduán na, “Á sikayu, ikáyâ naw nga mánaw gapay?” kun na. ");
INSERT INTO att_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Á simibbák si Simon Eduru, á kinagi na, “Apu, asinni paga panò dumá nga pakiyápuám mi nakuan? Ta sikaw lâ yù makáwayyá nga mangipakánnámmu sù ubobuk ni Namarò nga manotolay ta tolay ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Á kuruk nga manguruk kami nikaw, ánna ammu mingin ta kuruk nga sikaw yù Mangilin nga jinok ni Namarò,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Á pakkagi ni Eduru karannian, simibbák si Apu Kesu nira, á kinagi na, “Ari panò sikayu yù mapulu duá nga pinílì? Sikayu gemma, ngam ajjan nikayu yù tádday nga nagunagán ni Satanas.” ");
INSERT INTO att_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yáyù kinagi ni Apu Kesu ta meyannung kâ Kudas, nga anâ ni Simon Iskariote, ta nebiláng sù ira mapulu duá nga sinudduán na, ngam aggina yù mangipagápù kuna. ");
INSERT INTO att_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Á ta kabalin na yaw, naddagâ si Apu Kesu nga nangituddu sù ira ili ánna babálay sù purubinsia na Galilia, ta molang na umay ta Judiya, gapu ta inigagánge ra papatáyan nayù ira karakalán nga Kudio tán. ");
INSERT INTO att_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Á maddaggun yù piestá na Kudio nga mangngágan ta Piestá na Amíngán. ");
INSERT INTO att_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Á yù ira wáwwagi ni Apu Kesu, kinagi ra kuna, “Ngattá, ta maggián ka saw? Napiá nu mánaw ka nga umay ta Judiya, tapè masingan nayù makituddu nikaw yù akka-akkuám mu. ");
INSERT INTO att_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta yù tolay nga ikáyâ na nga meparámak, arán na gemma ilímak yù akkuán na. Umay ka laguk ta dakal nga ili, tapè mepasingan sù ira ngámin nga tatolay yù makapállâ nga akka-akkuám mu.” Yáyù kinagi nayù ira wáwwagi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ta mássiki yù ira wáwwagi na, ari ira paga manguruk kuna. ");
INSERT INTO att_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Á kinagi ni Apu Kesu nira, “Ari paga jimittál yù oras nga pappásingak ku ta ili na Jerusalem. Ngam sikayu, maguray lâ nga ággaw yù pappasingan naw. ");
INSERT INTO att_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ta ari sikayu yù ikalusso nayù ira tatolay nga ari manguruk kâ Namarò. Ngam sikán, ikalusso rangà, gapu ta sikán yù makkagi nira ta narákè yù akka-akkuád da. ");
INSERT INTO att_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Umay kayu lápay, ta aringà lábbì umay, gapu ta ari paga oras nga pappásingak ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Á ta pakkagi na karannian, nabbattáng lábbì ta Galilia. ");
INSERT INTO att_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Á ta páno nayù ira wáwwagi ni Apu Kesu nga minay nakipiestá ta Jerusalem, minay gapay nakipiestá si Apu Kesu, nga naguroray nga awán ta kepulután na, tapè ari mappasingan. ");
INSERT INTO att_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Á yù ira karakalán na Kudio, ala-alerad da si Apu Kesu ta áppiestán. Á iniyabbû da sù ira kábulud da, “Sisaw gián na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Á magaru yù ira tatolay nga makipiestá, á nakkaká-anasâ ira ta meyannung kâ Apu Kesu. “Aggina yù napiá nga tolay,” kun nayù ira káruán. Á “Ari,” kud da gapay nayù ira káruán, “ta ilogò na yù ira tatolay,” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ngam arád da lâ ipágginná yù ubobuk da nga meyannung kuna, gapu ta ikássing da sù ira karakalán na Kudio. ");
INSERT INTO att_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Á pattangngá nayù piestá, minay si Apu Kesu sù mangilin nga kapilliá, nga nangituddu sù ira tatolay nga ajjan tán. ");
INSERT INTO att_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Á napállâ yù ira karakalán na Kudio sù pangituddu na, á kinagi ra, “Ari bulubugá naggigiámmu yane tolay! Á kunnasi laguk ta napakáru yù kánnámmuán na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Á yáyù nga simibbák si Apu Kesu, á kinagi na nira, “Yawe nga ituddù, ari nga maggapu sù nonò ku, ngam maggapu galâ sù nonò nayù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Á nu italákkuruk nayù tolay nga manuppál sù ipakuá ni Namarò kuna, kánnámmuán na nu si Namarò yù paggapuán nayù ituddù, onu maggapu galâ ta nonò ku. ");
INSERT INTO att_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Á nu ubobugan na tolay yù uru-ure na lápay, yá lâ ikáyâ na yù keparáyo na. Ngam yù tolay nga ikáyâ na ta meparáyaw yù naddok kuna, á kuruk ngámin yù kagian na, nga awán bulubugá ta siri na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Á kinagi na paga sù ira karakalán na Kudio, “Á ari panò sikayu yù iniddán na ngaw ni Moyses sù tunung ni Namarò? Ngam awán nikayu ta mamalurò sù tunung. Ngattá, ta igagánge nawà papatáyan?” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Á simibbák yù ira magaru, á kinagi ra kuna, “Maguyung ka! Asinni panò mangigagángay nga mamapátay nikaw?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Á simibbák si Apu Kesu, á kinagi na nira, “Tádday lâ yù pinagaddátù sù ággaw nga ággibannák, ta pinammapiâ yù tolay nga natakì, á mapállâ kayu. ");
INSERT INTO att_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ngam sikayu, palurotan naw yù pakkugì naw sù ira ánâ naw ta mekawalu nga ággo ra, mássiki nu Sabadu nga ággibannák, gapu ta yáyù inituddu na ngaw ni Moyses nikayu. Ngam ari gemma si Moyses yù naggapuán nayù kustombare, nu ari galâ yù ira ngaw naggaká nittam. ");
INSERT INTO att_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Á nu ángngarigán ta mabigarán yù baggi na tolay sù ággaw nga ággibannák tapè mapalurò yù tunung ni Moyses nga meyannung ta pakkugì na, ngattá laguk, ta mapporay kayu nikán nu pammapiák ku yù matakì sù ággaw nga ággibannák? ");
INSERT INTO att_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nu mamanunnù kayu, arán naw nakuan panunnután ta meyannung ta ánninganán naw, nu arán naw bì iyabbû ta olu yù meyannung ta kuruk, tapè kánnámmuán naw, ánna matunung yù ámmanunnù naw,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Á yù ira tatolay ta Jerusalem, nakkaká-ubobuk ira laguk, á kinagi nayù ira káruán, “Ari panò aggina yù ala-alerad da, nga ikáyâ da papatáyan? ");
INSERT INTO att_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Á innan nawè! Ajjanin nga magubobuk ta arubáng na ngámin na tatolay, ngam awán ta mamattukkâ kuna! Ammu ra panò ta kuruk nga aggina yù MakKiristu nga umay mammaguray nittam nga Israel? ");
INSERT INTO att_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngam ari támma, ta ammu tam gemma yù naggapuán na, á nu duttál yù kuruk nga MakKiristu, awán ta makánnámmu sù paggapuán na,” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Á ta pangituddu ni Apu Kesu paga sù mangilin nga kapilliá, inikáddagâ na laguk iniyássikan yù ubobuk na, á kinagi na sù ira tatolay, “Ammu nawà panò? Á ammu naw panò yù naggapuák ku? Ngam ari nga sikán yù maká-uray ta ángè saw, nu ari galâ si Namarò yù naddok nikán. Aggina yù kuruk nga napiá, á kuruk ngámin yù kagian na. Á aggina gapay arán naw ammu. ");
INSERT INTO att_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngam sikán, ammù gemma, ta aggina yù naggapuák ku, á aggina yù naddok nikán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Á ta pakaginná nayù ira karakalán na Kudio sù kinagi ni Apu Kesu, ikáyâ da gaputan. Ngam awán ta maggápù kuna, gapu ta ari paga yaw yù oras nga sinullà ni Namarò nga paggápù da kuna. ");
INSERT INTO att_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ngam aru yù ira tatolay nga nanguruk kuna. Á kinagi ra, “Egga panò yù tanakuán nga MakKiristu nga iddagát tam? Á nu ángngarigán ta duttál nakuan yù tanakuán nga MakKiristu, makapagaddátu panò ta makapállâ ánnè karanniawe nga pinagaddátu na? Awán!” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Á pakaginná nayù ira Parisio sù kagakagian nayù ira tatolay ta meyannung kâ Apu Kesu, dagarágâ nga nattatádday ira sù ira kátannangán nga pári, á jinok da yù ira magguárdiá sù mangilin nga kapilliá, ta ed da gaputan si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Á kinagi na laguk ni Apu Kesu sù ira tatolay, “Makipaggiánà lábbì paga ta baddì nikayu, ta maddaggunakin mánaw nga manoli sù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Á sangaw nu awánakin saw, ala-aleran nawà, ngam arán nawà málek, ta ari kayu makángay sù giák ku,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Á pakaginná nayù ira karakalán na Kudio sù kinagi na, nakkaká-ubobuk ira, á kinagi ra, “Sisaw panò angayán na nga arát tam pakángayán? Umay panò sù ira ikáttole tam nga makipaggián ta arayyu nga lugár sù ira nga ari Kudio, tapè tudduán na gapay yù ira nga ari Kudio?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Anni panò yaw nga kagian na, nga alerat tam, ngam arát tam málek ánna ari ittam makángay sù angayán na? Anni panò yù kebalinán na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Á ta kaporianán nga ággo nayù piestá, nga nanginá nga ággaw, nanáddak si Apu Kesu ta arubáng nayù ira tatolay, á iniyássikan na yù ubobuk na, á kinagi na, “Nu egga yù tolay nga mapangál, umay laguk nikán, tapè penumak ku. ");
INSERT INTO att_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta ajjan yù netúrâ sù bilin ni Namarò nga kunniaw: ‘Yù tolay nga mangikatalà nikán, ajjan yù kun na wek nga mallatuâ nga maggapu ta nonò na, nga manotolay ta áddè ta áddè,’ ” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Á yawe nga wek nga inubobuk ni Apu Kesu, yá kebalinán na yù Ikararuá ni Namarò nga alawatad da sangaw nayù ira nga mangikatalà kuna. Ta ari paga neyawâ yù Ikararuá ni Namarò, gapu ta ari paga jimittál yù pangiparáyo ni Namarò kâ Apu Kesu ta panoli na ta lángì. ");
INSERT INTO att_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Á ta pakaginná nayù ira tatolay sawe nga kinagi ni Apu Kesu, kinagi nayù ira káruán, “Yawe tolay yù kuruk nga ábbilinán ni Namarò nga iddi-iddagát tam,” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Á yù ira káruán, kinagi ra, “Aggina gemma yù MakKiristu nga jinok ni Namarò ta mammaguray nittam,” kud da. “Ari,” kun nayù ira káruán, “ta taga Galilia gemma, á Galilia panò yù paggapuán nayù MakKiristu? ");
INSERT INTO att_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ari panò netúrâ sù dán nga bilin ni Namarò ta yù MakKiristu yù ginaká nayù ngaw Patul Dabid, ánna Betlekem yù keyanatán na, nga ili ni Patul Dabid?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Á yáyù nga ari tangapareku yù nonò nayù ira tatolay ta meyannung kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Á yù ira káruán, ikáyâ da nakuan gaputan, ngam awán paga bulubugá ta maggápù kuna. ");
INSERT INTO att_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Á nanoli laguk yù ira magguárdiá sù ira naddok nira nga Parisio ánna yù ira kátannangán nga pári. Á kinagi nayù ira Parisio nira, “Ngattá, ta arán naw ginápù, nga iyánge naw nakuan saw?” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Á simibbák yù ira magguárdiá, á kinagi ra nira, “Awán ta tolay nga magubobuk ta kunnay sù ággubobuk na! Awán bulubugá ta kagittá na nga mangituddu!” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Á kinagi nayù ira Parisio nira, “Nelogò kayu gapay ngam! ");
INSERT INTO att_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Egga panò nikami nga karakalán ánna yù ira Parisio yù manguruk kuna, mássiki nu tádday? Awán. ");
INSERT INTO att_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Danniaw ira nga magaru nga tumuttul kuna, ari ira naggigiámmu, á arád da ammu yù tunung ni Moyses, á yáyù nga mokum ira laguk,” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Á ajjan gapay nira si Nikudemu, nga Parisio gapay, nga minay ngaw kâ Apu Kesu ta tangngá na gabi. Á pakaginná ni Nikudemu sù kinagi nayù ira kábulun na nga Parisio, simibbák, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nu kurugat tam yù tunung ni Moyses, arát tam nakuan panunnután ánna pagikaruan yù tolay, nu arát tam bì olu nga ginnán yù kagian na, tapè ammu tam yù akka-akkuán na,” kun na. ");
INSERT INTO att_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Á simibbák yù ira kábulun ni Nikudemu, á kinagi ra kuna, “Taga Galilia ka panò gapay?” kud da. “Bibbiram mu laguk ta napiá yù dán nga netúrâ nga ubobuk ni Namarò, tapè kánnámmuám mu gapay ta awán bulubugá ta ábbilinán ni Namarò nga duttál nga maggapu ta Galilia,” kud da. ");
INSERT INTO att_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Á kabalid da nagubobuk, nallalabbè ira nga katággitádday ta bale na. ");
INSERT INTO att_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta páno nayù ira Parisio ánna yù ira karakalán na Kudio sù mangilin nga kapilliá, nánaw gapay si Apu Kesu nga minay ta puddul na Olibo. ");
INSERT INTO att_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Á ta alippánnawák, nanoli si Apu Kesu sù mangilin nga kapilliá. Á minay nga naggagammung yù magaru nga tatolay, á nagarimummungád da si Apu Kesu. Á nagitubang si Apu Kesu nga nangituddu nira. ");
INSERT INTO att_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Á ta pangituddu ni Apu Kesu nira, minay yù ira mesturu ta tunung na Kudio ánna yù ira nga Parisio, á iniyánge ra kuna yù babay nga ginápù da gapu ta narángnganád da nga nakiruruk sù arán na atáwa. Á iniyarubáng da yù babay sù ira tatolay. ");
INSERT INTO att_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Mesturu,” kud da kâ Apu Kesu, “narángnganám mi yawe babay nga nakiruruk sù arán na atáwa. ");
INSERT INTO att_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Á ajjan netúrâ sù tunung tam yù kinagi ni Moyses nga meyannung sù pamagikáru tam sù kunniaw nga babay, ta payapayangat tam nakuan ta batu, tapè matay. Á sikaw, anni laguk yù urem kuna?” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yáyù kinagi ra kâ Apu Kesu, gapu ta parubád da, ta ikáyâ da nu ajjan nakuan yù ipamaliwâ da kuna nga meyannung sù itabbák na nira. Ta nu kagian na nakuan ta arád da papatáyan, kontarán na yù tunung ni Moyses. Ngam nu kagian na nakuan ta palurotad da yù tunung ni Moyses, á mekontará laguk sù tunung nayù patul nga taga Roma. Á yáyù nga maguray lâ yù itabbák na, yáyù ipangikeká ra kuna. Á nakkummak lâ si Apu Kesu, á nattúrâ ta amassisiddu na ta dabbun. ");
INSERT INTO att_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Á gapu ta mangupù ira nga mangiyabbû kuna, á gimikkáng si Apu Kesu, á kinagi na nira, “Yù tolay nikayu nga awán bulubugá ta liwâ na, aggina yù olu nga mamayang sù babay,” kun na. ");
INSERT INTO att_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Á nagitubang nga nakkummak má, nga nangupù nga nattúrâ ta amassisiddu na ta dabbun. ");
INSERT INTO att_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Á ta pakaginná ra sù kinagi na, nappasirán ira ngámin, á nassisínù ira nga nánaw. Napopolu yù kalakalákayád da, á jimináddán ira ngámin. Á nabattáng lâ si Apu Kesu ánna yù babay. ");
INSERT INTO att_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Á sinánguk na laguk ni Apu Kesu yù babay, á kinagi na kuna, “Sisaw ine ra? Awán panò ta mamayang nikaw ta batu?” ");
INSERT INTO att_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Awánin, Apu. Nánaw iren,” kun nayù babay. Á kinagi ni Apu Kesu kuna, “Á sikán gapay, arát taka pagikaruan. Mánaw ken laguk, ngam arám mu ngin pidduán yù malliwâ,” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Á manganánnuán, ta pangituddu na mángin ni Apu Kesu sù ira magaru nga tatolay, kinagi na nira, “Sikán yù meyárik ta nawák, ta sikán yù mamannawák ta nonò na tolay. Á yù tolay nga umay makituddu nikán, ari bulubugá magawáwán nga kunnay sù mallakák ta gabi nga awán ta tulu na, nga makkarakarárà sù kallà. Ta sikán yù mepulù kuna, sikán nga mamannawák ánna manotolay ta áddè ta áddè,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Á ta pakaginná nayù ira Parisio sù kinagi ni Apu Kesu nga meyannung ta baggi na, kinagi ra kuna, “Awán gemma ta manguruk nikaw, ta táttádday ka lápay nga makkagi ta meyannung ta baggim. Á yáyù nga ari kuruk yù kagiam mu,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Á simibbák si Apu Kesu, á kinagi na nira, “Mássiki nu sikán lápay yù makkagi, á kuruk yù kagiak ku gapu ta ammù yù naggapuák ku ánna yù angayák ku. Ngam sikayu, arán naw gemma ammu yù naggapuák ku ánna yù angayák ku. ");
INSERT INTO att_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Á sikayu, nu mamanunnù kayu, á kunnay ta ánninganán na tolay yù ámmanunnù naw. Ngam sikán, awán ta panunnuták ku. ");
INSERT INTO att_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Á ta ángngarigán nu sikán yù mamanunnù, matunung yù ámmanunnù ku, ta aringà maguroray nga mamanunnù, nu ari galâ sikami nga duá kâ Yámà nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Á ajjan yù netúrâ sù tunung naw, ta nu egga duá nga naggittá yù kagiad da, á kuruk laguk yù kagiad da. ");
INSERT INTO att_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Á kunnian gemma nikami, ta duá kami nga makkagi ta meyannung nikán, ta sikán yù tádday, á yù mekaruá yù Yámà nga naddok nikán,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Á yáyù nga kinagi nayù ira Parisio kâ Apu Kesu, “Sisaw gián nayù yámam?” kud da. Á simibbák si Apu Kesu, á kinagi na nira, “Arán naw kami ammu, sikami ánna yù Yámà. Nu ammu nawà, ammu nawin gapay nakuan yù Yámà,” kun na. ");
INSERT INTO att_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yáyù kinagi ni Apu Kesu ta pangituddu na sù mangilin nga kapilliá, sù lágum nga ággianán nayù kakon nga pangipayyád da ta kuártu nga inilimù nayù ira tatolay. Ngam awán ta minay naggápù kuna, gapu ta arán na paga oras nga kagápù na nga sinullà ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Á manganánnuán, pidduán na nakkagi ni Apu Kesu sù kinagi na nira, “Mánawakin sangaw, á ala-aleran nawà, ngam arán nawà málek, ta matay kayu nga ari paga napakomá yù liwâ naw. Á yáyù nga ari kayu makángay sù angayák ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Á yáyù nga nakkaká-ubobuk yù ira karakalán na Kudio, á kinagi ra, “Anni panò yù kagian na nga ari ittam makángay sù angayán na? Papatáyan na panò sangaw yù baggi na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Á kinagi ni Apu Kesu nira, “Sikayu, taga dabbuno kayu, á nonopan naw lâ yù egga ta dabbuno. Ngam sikán, túrin ta lángì yù naggapuák ku, á yáyù nga nonopak ku ánna ubobugak ku yù meyannung ta lángì. ");
INSERT INTO att_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Á yáyù nga kinagì nikayu ta matay kayu nga ari paga napakomá yù liwâ naw, ta nu arán naw kurugan yù kinagì nga sikán gemma, á sangaw nu matay kayu, maggián nikayu yù ikáru naw nga liwâ, á mesinná kayu kâ Namarò ta áddè ta áddè,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Á yáyù nga iniyabbû nayù ira karakalán nga Kudio kâ Apu Kesu, “Á sikaw, asinni ka laguk?” kud da. Á kinagi ni Apu Kesu nira, “Sikán pá gemma aggina nga kinagì nikayu áddè ngaw pamegapu na pangituddù. ");
INSERT INTO att_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Á aru paga yù kagiak ku nakuan nikayu nga meyannung sù akka-akkuán naw nga narákè, ánna aru yù ággangnguá naw nga panunnuták ku nakuan. Ngam yá lâ kagiak ku sù ira tatolay sawe dabbuno yù naginnâ nga kinagi nayù naddok nikán, á kuruk gemma yù ngámin nga kagian na,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ngam arád da nánnámmuán ta si Namarò yù ubobugan na, nga Yáma na. ");
INSERT INTO att_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Á yáyù nga kinagi ni Apu Kesu nira, “Sangaw nu ipotun nawà ta kurù, nga Kaká na ngámin na tatolay, á yáyù pakánnámmuán naw ta sikán gemma. Á kánnámmuán naw gapay ta awán ta akkuák ku megapu sù urè, ngam ubobugak ku galâ yù inituddu nayù Yámà nikán. ");
INSERT INTO att_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Á mannanáyun nga mepulù nikán yù Yámà nga naddok nikán. Arán nangà bulubugá pagurorayan, ta akkuák ku lâ yù ipakuá na nikán,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Á pagubobuk na karanniaw, aru yù ira tatolay nga nanguruk kuna. ");
INSERT INTO att_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Á kinagi na laguk ni Apu Kesu sù ira Kudio nga nanguruk kuna, “Nu uputan naw yù panguruk naw sù ituddù nikayu, á sikayu yù kuruk nga makituddu nikán. ");
INSERT INTO att_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Á ipakánnámmù nikayu yù kuruk nga maggapu kâ Namarò, tapè mapalubbáng kayu sù mangaripan nikayu,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Á simibbák ira, á kinagi ra kuna, “Sikami yù ginaká ni Kákay Abrakam! Awán bulubugá ta mangaripan nikami áddè ngaw ta áddè kunangane! Ngattá, ta kagiam mu nikami ta mapalubbáng kami sù mangaripan nikami?” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Á simibbák si Apu Kesu nira, á kinagi na, “Kukurugán nga kuruk yù kagiak ku nikayu. Ngámin yù ira malliwâ, aripanan na ira na liwâ. ");
INSERT INTO att_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Á ari mannanáyun nga maggián yù aripan ta bale nayù yápu na. Ngam yù kuruk nga anâ na tolay, mannanáyun nga maggián kuna. ");
INSERT INTO att_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Á yáyù nga kagiak ku nikayu laguk, nu yù Anâ ni Namarò yù mamalubbáng nikayu, á kukurugán nga napalubbáng kayin! ");
INSERT INTO att_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Ammù gemma ta ginaká na kayu ni Abrakam. Ngam igagánge nawà papatáyan, gapu ta arán naw alawatan yù ituddù nikayu. ");
INSERT INTO att_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A ituddù lâ yù ipasingan nayù Yámà nikán. Ngam sikayu, akkuán naw yù kagian nayù yáma naw nikayu,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Á simibbák yù ira Kudio, á kinagi ra, “Si Kákay Abrakam yù yáma mi,” kud da. Á kinagi ni Apu Kesu nira, “Nu kuruk nga ginaká nakayu ni Abrakam, párigán naw nakuan yù napiá nga kingnguá na ngaw ni Abrakam. ");
INSERT INTO att_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngam ari gemma kunnay sù akkuán naw yù kingnguá na ngaw ni Abrakam. Ta sikayu, aleran naw yù awayyá naw nga mamapátay nikán, mássiki nu sikán yù makkagi nikayu ta kuruk nga kinagi ni Namarò nikán. ");
INSERT INTO att_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","“Á naggittá galâ yù akka-akkuán naw sù ággangnguá nayù yáma naw,” kun ni Apu Kesu nira. Á kinagi ra kuna, “Ari kami labbuák. Ajjan táttádday nga yáma mi nga si Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Á kinagi ni Apu Kesu nira, “Nu kukurugán nga yáma naw si Namarò, iddukan nawà nakuan laguk, ta si Namarò gemma yù naggapuák ku, á yáyù gapu na nga minayà saw. Ta arák ku uray yù ángè saw, ngam si Namarò galâ yù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Ngattá, ta arán naw kánnámmuán yù kagiak ku nikayu? Wan, yáyù gapu na nga arán naw kánnámmuán, gapu ta kun na kitul kayu, nga manakì nga magginná sù kagiak ku. ");
INSERT INTO att_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ánâ na kayu ni Satanas nga yáma naw, á yá lâ ikáyâ naw nga akkuán yù ipakuá na nikayu. Á minámmapátay si Satanas ta áddè ngaw nga pamegapu na ngámin, á arán na ammu yù kuruk, ta awán bulubugá ta kuruk sù nonò na. Sirisiri galâ yù kagian na, ta negagángay ta nonò na yù passirisiri na. Aggina yù minássirisiri ánna yù paggapuán na ngámin na siri. ");
INSERT INTO att_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngam sikán, kuruk lâ yù kagiak ku, á yáyù nga arán nawà kurugan. ");
INSERT INTO att_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Asinni nikayu yù makkagi ta ajjan liwâ ku? Awán! Á nu kagiak ku yù kuruk, ngattá, ta arán nawà kurugan! ");
INSERT INTO att_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yù ira ánâ ni Namarò, ginniginnád da yù bilin ni Namarò. Ngam sikayu, arán naw ginnán yù ubobuk ni Namarò. Á yáyù nga arán na kayu anâ,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Á pakkagi ni Apu Kesu ta arán na ira ánâ ni Namarò, simibbák yù ira Kudio, á kinagi ra kuna, “Kuruk yù kagiam mi, nga taga Samaria ka, ta makikontará ka nikami nga taga Israel! Á nagunagán naka na anitu!” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Á simibbák si Apu Kesu, á kinagi na nira, “Aringà nagunagán na anitu. Ngam iparáyò galâ yù Yámà megapu sù akkuák ku. Á sikayu, pakkakagián nawà. ");
INSERT INTO att_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Á arák ku aleran yù keparáyò. Ngam ajjan yù tádday nga magalek sù ira maddáyaw nikán. Á aggina yù mamanunnù. ");
INSERT INTO att_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Á kukurugán nga kuruk yù kagiak ku nikayu. Yù tolay nga manguruk sù kagiak ku, ari bulubugá matay, mássiki ta áddè ta áddè,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Á kinagi nayù ira Kudio kuna, “Á ammu mi ngin ta maguyung ka, nga nagunagán na anitu! Ta natay si Kákay Abrakam ánna natay gapay yù ngaw ira ngámin nga ábbilinán ni Namarò. Ngattá, ta kagiam mu ta ari bulubugá matay yù ira nga manguruk sù kagiam mu? ");
INSERT INTO att_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Makáwayyá ka panò ánnè sù ngaw Kákay Abrakam nga naggaká nikami? Ta natay gemma, á natay gapay yù ngaw ira ngámin nga ábbilinán ni Namarò. Asinni ka panò laguk?” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Á simibbák si Apu Kesu, á kinagi na nira, “Ta ángngarigán nu dayáwak ku yù baggì nakuan, awán ta serbi na. Ngam yù Yámà yù mangiparáyaw nikán. Aggina si Namarò, nga kagian naw nga Yápu naw. ");
INSERT INTO att_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Arán naw bulubugá ammu si Namarò. Ngam sikán, ammù. Á nu ángngarigán ta kagiak ku nakuan ta arák ku ammu si Namarò, mepárigà nakuan nikayu nga massiri. Ngam kuruk nga ammù gemma, á palurotak ku yù ngámin nga ubobuk na. ");
INSERT INTO att_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Á si Abrakam, nga káke naw, nagayáyâ sù ngaw pagiddanáma na ta masingan na sangaw yù ángè sawe dabbuno. Á nasingan nen yù dattál ku saw, á nepallà yù pagayáyâ na,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Á gapu ta natay ta nabayágin si Abrakam, kinagi nayù ira Kudio kâ Apu Kesu, “Awán ka paga ta límápulu nga dagun. Nasingam mu panò si Kákay Abrakam?” kud da. ");
INSERT INTO att_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Á kinagi ni Apu Kesu nira, “Kukurugán nga kuruk yù kagiak ku nikayu. Gári, lage na neyanâ paga ni Abrakam, dán nga ajjanakin,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Á pakaginná ra sù kinagi na, minay ira nangâ ta batu, ta payangad da nakuan. Ngam nattuttù si Apu Kesu, á nallammang nga nánaw laguk sù mangilin nga kapilliá. ");
INSERT INTO att_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Á pallakalakák di Apu Kesu, nasingad da yù tolay nga buling nakeyanakán na. ");
INSERT INTO att_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Á yù ira makituddu kâ Apu Kesu, iniyabbû da kuna, “Mesturu, asinni yù nakaliwâ, nga gapu na nga buling nakeyanakán na? Megapu panò ta liwâ na lápay, onu megapu galâ ta liwâ nayù ira darakal na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Á simibbák si Apu Kesu, á kinagi na nira, “Ari megapu sù liwâ na ánna ari megapu sù liwâ nayù ira darakal na, ngam buling galâ tapè mepasingan yù pakáwayyá ni Namarò megapu kuna. ");
INSERT INTO att_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Á kunangane yù ággo na pattarabáku tam ta keggá tam paga ta utun na dabbun, tapè palurotat tam yù ipakuá nayù naddok nikán. Awán ta makatarabáku sangaw nu gabingin. Á kunniû gapay nittam, ta nu natay ittamin, awánin ta awayyá tam nga mattarabáku. ");
INSERT INTO att_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Á keggâ paga ta dabbuno, sikán yù mamannawák, á pannawagak ku yù nonò nayù ira tatolay.” ");
INSERT INTO att_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Á kabalin ni Apu Kesu nakkagi karannian, nilutábán na yù dabbun. Á inikiruk na yù luták na ta dabbun, ta paddayan na ta lupè. Á yáyù inâ na nga inileruk na ta matá nayù buling. ");
INSERT INTO att_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Á kinagi na sù buling, “Arà! E ka magámmuâ ta danum nga ájjigután nga mangngágan ta Silowam.” Á “Narok” yù kebalinán na “Silowam.” Á minay laguk nagámmuâ yù buling ta Silowam. Á pagámmuâ na, nakasinganin, á limibbè ta balay. ");
INSERT INTO att_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Á labbè nayù tolay, nasingan nayù ira karúbá na ánna yù ira nga nakasingan kuna ngaw nga nakilimù, á kinagi ra, “Ari panò aggina yù tolay nga magitubang nga makilimù?” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","“Wan, aggina,” kun nayù ira káruán. Á yù ira káruán, kinagi ra, “Ari, ngam kagittá na lâ,” kud da. Ngam yù tolay, kinagi na, “Sikán yù tolay nga buling ngaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Á kinagi ra kuna, “Anni má ta makasingan ken?” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Á simibbák yù tolay, á kinagi na nira, “Yù tolay nga mangngágan ta Kesu, inâ na yù dabbun nga binasá na ta luták na, á inileruk na ta matâ. Á kinagi na nikán ta ek ku magámmuâ ta Silowam. Á yáyù kinuruk ku. Á ta pagámmuâ ku, makasinganakin,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Á kinagi ra kuna, “Sogián nen?” kud da. “Arák ku ammu. Arák ku ammu yù ine na,” kun na nira. ");
INSERT INTO att_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Á yù ira karúbá na, inituluk da laguk sù ira Parisio yù tolay nga buling ngaw. ");
INSERT INTO att_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Á Sabadu yù pappadde ni Apu Kesu ta lupè ánna pamammapiá na sù buling, nga ággo na ággibannák. ");
INSERT INTO att_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Á yáyù nga iniyabbû da má nayù ira Parisio sù ngaw buling nu anni yù inipammapiá na. Á kinagi na nira gapay, “Inileruk na sù matâ yù dabbun nga binasá na ta luták na, á nagámmuákà, á makasinganakin,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Á yáyù nga kinagi nayù ira káruán nga Parisio, “Ari naggapu kâ Namarò, ta arán na ngilinan yù ággibannák tam nga Sabadu,” kud da. Ngam yù ira káruán, kinagi ra, “Nu makaliwâ nakuan, ari makapagaddátu ta kunniawe nga makapállâ,” kud da. Á naddurúmá yù nonò da ta meyannung kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Á yáyù nga iniyabbû da má nayù ira Parisio sù tolay nga buling ngaw, “Á gapu ta kagiam mu ta aggina yù namakasingan nikaw, á anni laguk yù kagiam mu nga meyannung kuna?” kud da. Á kinagi na nira, “Aggina yù ábbilinán ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Á danniaw ira nga karakalán na Kudio, arád da kinuruk ta buling ngaw yù tolay nga makasinganin. Á yáyù nga inipágál da yù ira darakal na. ");
INSERT INTO att_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Á iniyabbû da nira, “Kuruk panò nga aggina yù anâ naw nga kagian naw ta nakeyanakán na yù buling na? Á ngattá laguk, ta makasinganin?” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Á simibbák yù ira darakal na, á kinagi ra, “Wan, kuruk nga aggina yù anâ mi, á kuruk nga neyanâ nga buling. ");
INSERT INTO att_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngam arám mi ammu nu kunnasi pakasingan nen. Á arám mi gapay ammu nu asinni yù namakasingan ta matá na. Iyabbû naw galâ sù anâ mi, ta dakalin gemma, á awayyá nen nga kagian nikayu,” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yáyù kinagi nayù ira darakal na, ta maganássing ira sù ira karakalán na Kudio. Ta nattatádday yù ira karakalán ta nonò da ta papanáwad da ta kapilliá ánna arád da bulubugá patallungan yù tolay nga makkagi ta si Kesu yù MakKiristu. ");
INSERT INTO att_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Á yáyù nga kinagi nayù ira darakal na ta aggina lâ yù pangiyabbutád da, “ta dakalin gemma, á awayyá nen nga kagian nikayu,” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Á pakaginná nayù ira Parisio sù kinagi nayù ira darakal na, pinidduá ra nga inipágál yù tolay nga buling ngaw. Á kinagi ra kuna, “Kagiam mu yù kuruk ta arubáng ni Namarò, ta ammu mi ta nakaliwâ yù tolay nga namammapiá nikaw,” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Á simibbák yù tolay, á kinagi na nira, “Arák ku ammu nu nakaliwâ, onu ari. Yá lâ ammù, ta bulingà ngaw gemma, á makasinganakin,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Á iniyabbû da kuna, “Anni yù kingnguá na nikaw? Kunnasi yù pamakasingan na sù matám?” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Á simibbák, á kinagi na nira, “Yáyù gemma kinagì nikayu gangù nga arán naw gininná. Ngattá garè, ta itotoli naw nga iyabbû? Ikáyâ naw panò nga makituddu gapay kuna?” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Á pakaginná ra sù initabbák nayù tolay nga buling ngaw, napporay ira. Á nakkakagiád da, á kinagi ra kuna, “Sikaw yù tumuttul kuna! Ngam sikami, si Moyses yù tuttulam mi! ");
INSERT INTO att_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ta ammu mi ta nakiubobuk si Namarò kâ Moyses. Ngam yane tolay, arám mi ammu yù naggapuán na,” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Á simibbák yù tolay nga buling ngaw, á kinagi na, “Yawe yù kuruk nga makapállâ lagugam! Ta pinammapiá na yù matâ, ngam arán naw paga ammu yù naggapuán na! ");
INSERT INTO att_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ammu tam gemma ta arán na ginnán ni Namarò yù kagian nayù ira malliwâ. Ngam ginnán na yù tolay nga makimoray kuna ánna manuppál ta ure na. ");
INSERT INTO att_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Á áddè ngaw sù kaparò na dabbuno ta áddè kunangan, awán bulubugá ta narámak nga namakasingan ta tolay nga nakeyanakán na yù buling na! ");
INSERT INTO att_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Á nu ari naggapu kâ Namarò, awán bulubugá ta makuá na nga kunniaw,” kun na nira. ");
INSERT INTO att_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Á napporay yù ira karakalán na Kudio, á simibbák ira, á kinagi ra kuna, “Minálliwâ ka gemma áddè ngaw lage na keyanâ mu, á tudduám mu kami panò?” kud da. Á pinapáno ra ta kapilliá, nga arád den bulubugá patallungan. ");
INSERT INTO att_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Á nakarámak si Apu Kesu ta napapánaw yù ngaw buling sù kapilliá, á en na laguk inalek. Pakálek na, iniyabbû na kuna, “Kurugán nga manguruk ka panò sù Kaká na ngámin na tatolay?” kun ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Á simibbák yù tolay nga buling ngaw, á kinagi na kuna, “Asinni, Apu, tapè mangurugà kuna?” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Á kinagi ni Apu Kesu kuna, “Masingam mu ngin, ta aggina yù makiubobuk nikaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Á kinagi nayù tolay, “Apu, mangurugà,” kun na. Á dagarágâ nga namalittúkak nga makimoray kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Á kinagi ni Apu Kesu laguk, “Minayà sawe dabbuno, tapè mesinná yù ira tatolay nga manguruk kâ Namarò sù ira nga ari manguruk kuna. Á yù ira nga kun na buling gapu ta arád da kánnámmuán yù kuruk, á pannawagak ku yù nonò da, tapè manguruk ira. Ngam yù ira nga kagiad da ta makasingan ira, ngam manakì ira nga mangikatalà nikán, mabbáli ira ta kun na buling,” kun na. ");
INSERT INTO att_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Á yù ira káruán nga Parisio tán, naginná ra yù kinagi ni Apu Kesu. Á iniyabbû da kuna, “Anni yane nga kagiam mu? Kagiam mu panò ta kun na buling kami gapay?” kud da. ");
INSERT INTO att_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Á kinagi ni Apu Kesu nira, “Ta ángngarigán nu kuruk nga buling kayu nakuan, nga arán naw paga ammu yù bilin ni Namarò, á awán laguk ta pakaliwatán naw. Ngam gapu ta kagian naw ta makasingan kayu, maggián lâ paga nikayu yù ikáru naw megapu sù pakaliwatán naw.” ");
INSERT INTO att_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Á nagángngarigán laguk si Apu Kesu, á kinagi na, “Kukurugán nga kuruk yù kagiak ku nikayu. Nu ángngarigán ta umay yù tolay ta ággianán na karneru, á ari tullung ta puertá na, ngam magalek ta tanakuán nga pattallungán na, aggina yù minákkokò ánna tulisán. ");
INSERT INTO att_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngam yù tullung ta puertá, aggina yù mináppárák sù ira karneru. ");
INSERT INTO att_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Á yù magguárdiá ta puertá, bukatán na, tapè tullung yù mináppárák. Á yù ira karneru na, tákkilalád da yù ngárál nayù yápu ra. Á agálán na ira, á ingagánán na ira nga kukuá na nga katággitádday, tapè ilawán na ira. ");
INSERT INTO att_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Á ta kabalin na nangilawán sù ira ngámin nga kukuá na, mallakák nga mapolu nira, á tuttulad da, gapu ta ammu ra yù ngárál na. ");
INSERT INTO att_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Á nu ángngarigán ta umay yù tanakuán nga tolay nga magágál nira, ikarerád da, gapu ta arád da ammu yù ngárál na,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yáyù inistoriá ni Apu Kesu sù ira tatolay, ngam arád da nánnámmuán yù kebalinán na. Arád da kánnámmuán ta yù ira nga manguruk kâ Apu Kesu yù meyárik ta karneru na, á aggina yù meyárik ta mináppárák nga manaron nira. ");
INSERT INTO att_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Á gapu ta arád da kánnámmuán yù pagángngarigán na, yáyù nga kinagi ni Apu Kesu nira, “Kukurugán nga kuruk yù kagiak ku nikayu. Sikán yù meyárik ta puertá nga áttallungán nayù ira karneru ta ággianád da. ");
INSERT INTO att_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Á yù ira ngámin nga minay nga napolu ánnè nikán, kunnay ta minákkokò ira ánna tulisán, gapu ta kagiad da ta tanakuán yù meyárik ta áttallungán. Ngam yù ira tatolay nga manguruk nikán, arád da ira gininná. ");
INSERT INTO att_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sikán yù meyárik ta áttallungán. Á yù ira nga tullung megapu nikán, meyígù ira. Á napiá yù ánnarok ku nira, nga kunnay ta karnerù nga makatallung ánna makalawán nga umay magárak. ");
INSERT INTO att_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Á yù tulisán, yá lâ iyánge na yù makkokò ánna mamapátay ánna manarál. Ngam sikán, minayà manotolay ta tolay, tapè mepattolay ira kâ Namarò ta áddè ta áddè, ánna nepallà yù piá nayù áttole ra,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Á kinagi ni Apu Kesu, “Sikán yù napiá nga minánnaron, nga meyárik sù napiá nga mináppárák ta karneru, nga itapil na yù baggi na megapu sù ira karneru na, tapè meyígù ira. ");
INSERT INTO att_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Á yù minángngallu, ari kuruk nga mináppárák, gapu ta arán na kukuá yù ira karneru. Á ta ángngarigán nu masingan na yù simaron nga ayám nga umay mangnguá sù ira karneru, ikarerán na ánna panawán na ira. Á umay yù simaron nga ayám, á akkuán na yù ira karneru, á mawwarawarâ ira. ");
INSERT INTO att_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Á yá ipattálo nayù minángngallu, gapu ta awán ta ákkengá na sù ira karneru, ta arán na ira kukuá. ");
INSERT INTO att_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Sikán yù napiá nga minánnaron, á ammù yù ira ngámin nga kukuâ. Á yù ira kukuâ, ammu rangà gapay. ");
INSERT INTO att_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Á kunniû gapay nikami kâ Yámà, ta ammu nangà, á ammù yù Yámà. Á itapil ku yù baggì megapu sù ira nga meyárik ta karnerù, tapè meyígù ira. ");
INSERT INTO att_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Á ajjan paga yù ira káruán nga kukuâ, nga meyárik ta karnerù nga ari paga námmung. Aggira gapay itallung ku paga, á ginnád da yù ngárál ku, tapè mepattatádday yù ira ngámin nga kukuâ, nga kun na tangapangan, á táttádday lâ yù minánnaron nira. ");
INSERT INTO att_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Á yáyù nga iddukan nangà nayù Yámà, gapu ta itapil ku yù baggì megapu sù ira kukuâ, tapè maginnanolayà sangaw. ");
INSERT INTO att_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Awán ta makapapátay nikán nu arák ku uray, ngam mabbaluntáriungà nga mangitapil ta baggì. Ta sikán galâ yù makáwayyá nga mangitapil ta baggì, á sikán lággapay yù makáwayyá nga mamaginnanolay ta baggì, ta yáyù ipakuá na nikán nayù Yámà,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Á pakaginná nayù ira Kudio karannian nga kinagi ni Apu Kesu, naddurúmá yù nonò da ta meyannung kuna. ");
INSERT INTO att_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aru nira yù ira nga nakkagi, nga kud da, “Nagunagán ánna maguyung! Ngattá, ta ginniginnán naw yù kagian na?” kud da. ");
INSERT INTO att_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Á yù ira káruán, kinagi ra, “Nu nagunagán, ari kunniaw nakuan yù ággubobuk na. Á makapammapiá panò yù anitu ta matá na buling?” kud da. ");
INSERT INTO att_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Á ta kalummin na tiempu, jimittálin yù piestá nga panaddamán nayù ira Kudio sù ngaw pamolì da sù mangilin nga kapilliá ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Á ajjan si Apu Kesu sù mangilin nga kapilliá, nga nallakalakák sù balkon nga ingágad da ta Balkon nayù ngaw Patul Solomon. ");
INSERT INTO att_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Á yù ira karakalán na Kudio, nagarimummungád da si Apu Kesu, á kinagi ra kuna, “Anni ikabayák mu nga ipeddak nikami? Nu kuruk nga sikaw yù MakKiristu nga sinullà ni Namarò ta mammaguray nikami, á kagiam mu laguk nikami nga daretiu,” kud da. ");
INSERT INTO att_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Á simibbák si Apu Kesu, á kinagi na nira, “Yáyù kinagikin nikayu, ngam arán naw kurugan. Á yù makapállâ nga akka-akkuák ku megapu sù pakáwayyá nayù Yámà, danniawe nakuan yù ipanguruk naw nikán. ");
INSERT INTO att_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngam sikayu, ari kayu mebiláng sù ira nga kun na karnerù, ta ari kayu manguruk. ");
INSERT INTO att_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yù ira tatolè, meyárik ira ta karnerù, á ginnád da yù kagiak ku nira. Á ammù ira nga taggitádday, á tuttulad dangà. ");
INSERT INTO att_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Á totolayak ku ira tapè mepattolay ira kâ Namarò ta áddè ta áddè. Ari ira bulubugá mesinná kâ Namarò, á awán ta makagubâ nira, gapu ta tangngalák ku ira. ");
INSERT INTO att_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Á yù Yámà yù nangiyawâ nira nikán. Aggina yù kotunán, nga makáwayyá ta ngámin. Á awán ta makagubâ sù ira tatolè gapu ta yù Yámà yù manangngal nira. ");
INSERT INTO att_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sikami kâ Yámà, tádday kami lâ,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Á pakaginná nayù ira karakalán na Kudio karannian nga kinagi ni Apu Kesu, minay ira nangâ ta batu, tapè payapayangad da. ");
INSERT INTO att_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ngam kinagi ni Apu Kesu nira, “Aru yù napiá nga kingngikingnguâ nga inipakuá nayù Yámà nikán megapu sù pakáwayyá na. Anni yù ipamayáng naw nikán?” kun na nira. ");
INSERT INTO att_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Á simibbák yù ira Kudio, á kinagi ra kuna, “Ari yù napiá nga kingnguám yù ipamayáng mi nikaw, nu ari galâ yù pamotum kâ Namarò. Ta tolay ka lâ gemma, á pattáddiosam mu yù baggim!” kud da. ");
INSERT INTO att_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Á simibbák si Apu Kesu, á kinagi na nira, “Arán naw panò binibbik yù netúrâ sù tunung naw nga kinagi na ngaw ni Namarò sù ngaw ira gillakalakayán naw, nga kunniaw: ‘Kinagì nikayu ta kunnay ta dios kayu gapay.’ ");
INSERT INTO att_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Á ammu tam ta ari gemma mapatalián yù netúrâ nga ubobuk ni Namarò. Á nu kinagi ni Namarò ta kunnay ta dios yù ira ngaw karakalán naw nga nangiyawatán na sù ubobuk na, ");
INSERT INTO att_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","á nepatalugáring nikán nga sinullà nayù Yámà ánna jinok na ta umay ta dabbuno! “Ngattá laguk ta kagian naw ta potuák ku si Namarò gapu ta kinagì ta sikán yù Anâ na? ");
INSERT INTO att_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Á ta ángngarigán nu arák ku nakuan akkuán yù ipakuá nayù Yámà nikán, á arán nawà laguk kurugan. ");
INSERT INTO att_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngam nu akkuák ku yù ipakuá nayù Yámà nikán, mássiki nu arán naw kurugan yù kinagì, kemámmatán naw laguk yù kingngikingnguâ, tapè ammu naw ánna kánnámmuán naw ta ajjan yù Yámà nikán ánna ajjanà gapay kâ Yámà,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Á yù ira Kudio, pakaginná ra sù kinagi ni Apu Kesu, gaputad da nakuan, ngam arád da nagápù gapu ta nallillì nira nga nánaw. ");
INSERT INTO att_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Á páno ni Apu Kesu ta Jerusalem, minay nanoli ta dammáng na danum na Jordan, nga nanigután na ngaw ni Kuan, á naggián lâ tán. ");
INSERT INTO att_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Á aru yù tatolay nga minay kuna. Á nakkaká-ubobuk ira, á kinagi ra, “Awán bulubugá ta pinagaddátu na ngaw ni Kuan, ngam kuruk yù ngámin nga kinagi na nga meyannung sawe tolay,” kud da. ");
INSERT INTO att_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Á aru yù ira tatolay tán nga lugár nga nanguruk kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Á naggián ta ili na Bitania yù ira tallu nga mawwawági, di Lasaru ánna yù ira bábbay, di Maria kâ Marta. Á natakì si Lasaru. ");
INSERT INTO att_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Á si Maria, aggina yù nangipay ta bábbanguk sù takki ni Apu Kesu, á pinunatán na sù duddù na. Á si Lasaru nga wagi na yù natakì. ");
INSERT INTO att_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Á di Maria kâ Marta, nabbilin ira ta umay kâ Apu Kesu, á kinagi na, “Apu, matakì yù kopum mu nga ayatam mu.” ");
INSERT INTO att_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Á pakarámak ni Apu Kesu, kinagi na, “Arán na ipate ni Lasaru yawe takì na. Ngam mesimmu galâ tapè maddáyaw yù ira tatolay kâ Namarò. Á sikán gapay, nga Anâ ni Namarò, meparáyawà gapay megapu sù takì ni Lasaru,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Á kurugán nga iniddù ni Apu Kesu yù ira mawwawági, di Marta kári Maria kâ Lasaru. ");
INSERT INTO att_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Á mássiki nu ammu ni Apu Kesu ta matakì si Lasaru, inipappánná na lâ ta duá nga ággaw yù páno na sù gián na. ");
INSERT INTO att_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Á pappasá na duá nga ággaw, kinagi ni Apu Kesu sù ira tudduán na, “Mánaw ittam laguk, ta manoli ittam ta Judiya,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Á kinagi ra kuna, “Mesturu, gangù lâ mággè pinayáng daka nayù ira karakalán na Kudio tán! Á manoli ka panò paga tán?” kud da kuna. ");
INSERT INTO att_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Á simibbák si Apu Kesu nga nagángngarigán, á kinagi na nira, “Ari kayu maburung. Ari panò mapulu duá nga oras nga manawák ta tangággaw? Á ajjan yù awayyá tam paga nga palurotan yù ipakuá ni Namarò nittam, nga kunnay ta tolay nga mallakák ta kanawák, nga ari mesiddúkal, gapu ta masingan na yù pallakarán na. ");
INSERT INTO att_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ngam yù tolay nga mallakák ta gabi, mesiddúkal gapu ta kallà garè,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Á kabalin ni Apu Kesu nakkagi karannian, kinagi na laguk sù ira tudduán na, “Si Lasaru nga koput tam, makkaturugin. Et tamin, ta lukagak ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Á kinagi ra kuna, “Apu, nu makkaturugin si Lasaru, mammapiá ngin sangaw,” kud da. ");
INSERT INTO att_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yáyù kinagi ra gapu ta kagiad da ta makkaturuk lâ si Lasaru nga magibannák. Ngam inubobuk ni Apu Kesu yù pate na nga kunnay ta pakkaturuk na. ");
INSERT INTO att_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Á gapu ta arád da nánnámmuán yù kinagi na, yáyù nga kinagi na nira nga daretiu, “Natayin si Lasaru. ");
INSERT INTO att_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Á magayáyákà, gapu ta awánà ta gián na sù pate na, tapè ajjan yù awayyá naw sangaw nga manguruk. Et tamin laguk sù gián na,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Á si Tomâ nga iningágad da ta Jiping, nakiubobuk sù ira kábulun na nga makituddu kâ Apu Kesu, á kinagi na nira, “Á et tamin laguk, ta nu papatáyad da si Mesturu tam, á sittam ngámin yù mekanakanâ kuna nga matay gapay,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Á ta labbè di Apu Kesu ta Bitania, nánnámmuád da ta appâ ta ággawin nga ajjan si Lasaru ta tanam. ");
INSERT INTO att_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Á aranni ta Jerusalem yù bárriu na Bitania. Tallu kilometro lâ yù kárayyu na. ");
INSERT INTO att_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Á aru yù ira Kudio nga taga Jerusalem nga minay manganna-annay kári Marta kâ Maria, tapè mabannáyán ira sù pate nayù wagi ra. ");
INSERT INTO att_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Á si Marta, pakarámak na ta umayin si Apu Kesu, en na jinápun. Ngam si Maria, naggián lâ nga nagitubang sù bale ra. ");
INSERT INTO att_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Á pakáddè ni Marta kâ Apu Kesu, kinagi na kuna, “Apu, nu egga ka nakuan saw, ari nakuan natay yù wagì. ");
INSERT INTO att_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Á mássiki nu natayin, ammukin ta iyawâ ni Namarò nikaw yù maguray lâ nga kiddawam mu,” kun ni Marta. ");
INSERT INTO att_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Á kinagi ni Apu Kesu kuna, “Maginnanolay yù wagim,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Á kinagi ni Marta kuna, “Wan, Apu, ammù ta mepaginnanolay sù ira námmatay ta panguriánán nga ággaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Á simibbák si Apu Kesu, á kinagi na kuna, “Sikán yù sigga-inángà nga mamaginnanolay sù ira námmatay. Sikán yù manotolay nira. Á yù tolay nga mangikatalà nikán, mássiki nu matay, á matolay. ");
INSERT INTO att_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Á ngámin yù ira nga matolay nga mangikatalà nikán, ari ira bulubugá mesinná kâ Namarò ta áddè ta áddè.” Á iniyabbû na laguk kâ Marta, “Kurugam mu panò yaw?” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Á kinagi ni Marta kuna, “Wan, Apu. Mangurugà ta sikaw yù MakKiristu, nga Anâ ni Namarò nga iddagám mi nga umay mammaguray ta dabbuno,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kabalin ni Marta nga nakkagi karanniaw, limibbè ta bale na. Á en na iniyanasâ nga kinagi kâ Maria, “Ajjanin yù Mesturu, á ipágál na ka,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pakaginná ni Maria ta limibbè si Apu Kesu, dagarágâ nga limikkâ nga nánaw, ta umay sù gián na. ");
INSERT INTO att_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ta ari paga nakáddè si Apu Kesu ta babále ra, ngam naggián lâ paga ta nanapunán ni Marta kuna. ");
INSERT INTO att_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Á yù ira Kudio nga ajjan ta bale ra, nga manganna-annay kâ Maria, pakasingad da ta ikáddagâ lâ yù páno ni Maria, siminuttul ira kuna, ta kagiad da ta umay makkulè sù tanam nayù wagi na. ");
INSERT INTO att_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Á pakáddè ni Maria sù gián ni Apu Kesu, namalittúkak ta arubáng na, á kinagi na kuna, “Apu, nu ajjan ka lâ nakuan saw, ari nakuan natay yù wagi mi,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Á pakasingan ni Apu Kesu sù ira Kudio nga nepakkulè kári Maria, nakalò yù daddam na ánna nepallà yù allà na nira. ");
INSERT INTO att_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Á iniyabbû na nira, “Sisaw nangitanamán naw kuna?” kun na. Á kinagi ra kuna, “Apu, et tam ta em mu innan,” kud da. ");
INSERT INTO att_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Á nepakkulè gapay nira si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Á yáyù nga nakkaká-ubobuk yù ira Kudio, á kinagi ra, “Innan nawè! Nepallà yù ayâ na kuna,” kud da. ");
INSERT INTO att_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngam yù ira káruán, kinagi ra, “Aggina yù mamammapiá ta matá na buling. Á ngattá garè, ta arán na pinammapiá si Lasaru, tapè ari nakuan natay?” kud da. ");
INSERT INTO att_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Á jimikkì ta tanam si Apu Kesu, nga nakalò má laguk yù daddam na. Á kuebá yù nangitanamád da, nga naserrán ta mallakay nga batu. ");
INSERT INTO att_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Á kinagi ni Apu Kesu nira, “Irián naw yù batu,” kun na. Á si Marta nga wagi nayù natay, kinagi na, “Apu, nabuyukin garè, ta appâ tangággawin nga netanam,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Á kinagi ni Apu Kesu kuna, “Arák ku panò kinagi nikaw gangù tanu mangikatalà ka, masingam mu sangaw yù pakáwayyá ni Namarò nga makapállâ?” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Á yáyù nga iniriád da yù batu. Á sinánguk ni Apu Kesu yù lángì, á kinagi na, “Ammò, magayáyákà ta gininnám yù kinagì nikaw. ");
INSERT INTO att_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Á ammù gemma ta tángngagam mu ngámin yù kagiak ku nikaw, ngam yaw lâ yù kagiak ku megapu sawe ira tatolay, tapè manguruk ira ta sikaw yù naddok nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Á kabalin na nakkagi sawe, nakkátol, á kinagi na, “Lasaru, mallawán ka saw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Á dagarágâ nga nallawán, nga naputápután ta sinnun áddè ta takki na áddè ta limá na ánna mammang na gapay. Á kinagi ni Apu Kesu nira, “Bullarán naw, tapè lubbekin,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Á aru yù ira Kudio nga mamulun kári Maria, á nasingad da yawe nga kingnguá ni Apu Kesu, á yáyù nga aru nira yù manguruk kuna. ");
INSERT INTO att_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngam yù ira káruán, nanoli ira ta Jerusalem, ta ed da iránuk yù kingnguá ni Apu Kesu sù ira Parisio nga malussaw kuna. ");
INSERT INTO att_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Á yáyù nga naggagammung yù ira Parisio ánna yù ira kátannangán nga pári sù ira karakalán na Kudio. Á kinagi ra, “Anni yù akkuát tam sù tolay? Ta aru garè yù makapállâ nga pagaddatuan na. ");
INSERT INTO att_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Á nu paguráyát tam tapè uputan na yù kunniaw nga akkuán na, á manguruk sangaw yù ira ngámin nga tatolay kuna. Á mappanà yù ággiát tam sangaw, gapu ta marámak da sangaw nayù ira kátannangán nga taga Roma, á umay ira laguk saw giát tam, á darálad da yù mangilin nga kapilliá ánna sittam ngámin ánna yù ira ili tam,” kud da. ");
INSERT INTO att_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ngam yù tádday nira si Kayapas, nga kamotungán na pári tán nga dagun, á simibbák, á kinagi na nira, “Sikayu, awán ta ammu naw, ");
INSERT INTO att_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ta arán naw kánnámmuán yawe, nga más mapiá nu metapil yù tádday nga tolay megapu nittam, tapè ari ittam ngámin mámmatay, nga tangapáddabbunán nga Kudio,” kun na. ");
INSERT INTO att_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Á yù kinagi ni Kayapas, ari naggapu ta nonò na. Ngam gapu ta aggina yù kamotungán na pári tán nga dagun, á yáyù nga inipakkagi ni Namarò kuna yawe nga meyannung sù ketapil na sangaw ni Apu Kesu megapu sù ira tangapáddabbunán nga Kudio. ");
INSERT INTO att_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Á yù ketapil ni Apu Kesu, ari lâ megapu sù ira Kudio, nu ari galâ megapu sù ira ngámin nga mangikatalà kuna, tapè pattatáddayan ni Namarò yù ira ngámin nga makkakerumá nga ánâ na nga nesinisinek ta ngámin nga tatolay ta dabbuno. ");
INSERT INTO att_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Á áddè sù paggagammung nayù ira kátannangán na Kudio, yáyù pamegapu ra nga mangigagángay sù ámmapáte ra kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Á yáyù gapu na nga ari mappasapasingan si Apu Kesu sù ira tatolay sù purubinsia na Judiya. Nánaw laguk di Apu Kesu ánna yù ira tudduán na, á minay ira ta babálay na Epraim nga aranni ta kalállammatán. Á nakipaggián ira tán. ");
INSERT INTO att_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Á naddaggunin nga duttál yù Piestá na Kudio, nga panaddamád da sù pattalebák nayù daroban ni Namarò. Á aru yù ira Kudio nga naggapu ta arayyu nga minay ta Jerusalem, ta ed da tuppálan yù kustombare ra nga mappakarenu ta baggi ra lage na piestá, tapè dán nga naparán ira sù pamegapu na. ");
INSERT INTO att_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Á ala-alerad da si Apu Kesu. Á ta paggagammung da ta mangilin nga kapilliá, nakkaká-ubobuk ira, á kinagi ra, “Anni kagian naw? Ari támma umay makipiestá?” kud da. ");
INSERT INTO att_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Á yù ira kátannangán nga pári ánna yù ira Parisio, kinagi ra sù ira tatolay tanu ajjan yù makánnámmu sù gián ni Apu Kesu, á ipakánnámmu na bì nira, tapè gaputad da. ");
INSERT INTO att_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Á annam paga yù ággaw pángè na pamegapu na piestá. Á minay di Apu Kesu ta Bitania, ta gián ni Lasaru nga pinaginnanole ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Á pinarád di Lasaru yù pamúgák di Apu Kesu. Á si Marta yù nasserbi nira, á si Lasaru yù tádday nga nepallálláng kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Á inâ ni Maria yù tangaboteliá nga bábbanguk nga nanginá, nga denu na nardu, á inibubbù na sù takki ni Apu Kesu, á pinunatán na yù takki na sù duddù na. Á limingngák yù aguk nayù bábbanguk sù balay. ");
INSERT INTO att_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Á ajjan si Kudas Iskariote, nga tádday sù ira mapulu duá nga makituddu kâ Apu Kesu, á matakì yù nonò na ta pakasingan na sù kingnguá ni Maria. Yawe Kudas yù mappagápù sangaw kâ Apu Kesu. Á kinagi ni Kudas, ");
INSERT INTO att_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngattá, ta ari neláku yawe bábbanguk ta tallu gatù, tapè ilimù tam yù pagá na sù ira magáwák?” kun ni Kudas. ");
INSERT INTO att_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Á ari kuruk nga mangikállà si Kudas sù ira magáwák, ngam áppè lâ yù kinagi na, gapu ta aggina yù minákkokò, á aggina yù manangngal ta kuártu ra nga kokokotan na lâ. ");
INSERT INTO att_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Á kinagi ni Apu Kesu kuna, “Paguráyám mu si Maria. Iyanugù mu kuna, tapè paránan na yù baggì ta ketanam ku. ");
INSERT INTO att_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta ajjan nga mannanáyun nikayu yù ira magáwák. Ngam sikán, mabíkà lâ maggián nikayu,” kun na. ");
INSERT INTO att_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Á pakarámak nayù ira magaru nga Kudio ta ajjan si Apu Kesu ta Bitania, minay ira sù gián na, ta ed da innan. Á ari lâ si Apu Kesu yù ikáyâ da nga innan, ngam si Lasaru gapay nga pinaginnanole na. ");
INSERT INTO att_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Á yáyù nga inigagánge ra nga papatáyan nayù ira kátannangán nga pári si Lasaru gapay, ");
INSERT INTO att_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta aggina yù gapu na nga aru yù ira Kudio nga manguruk kâ Apu Kesu, nga likuránád da yù ira kátannangád da. ");
INSERT INTO att_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Á sù tádday nga ággaw, ajjan yù ira magaru nga tatolay nga minay nakipiestá, á narámak da ta umayin si Apu Kesu ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Á nangâ ira ta palákkay, ta ed da jinápun, tapè dayáwad da. Á nagaragiák ira, á kinagi ra, “Dayáwat tam si Namarò. Dayáwat tam yawe nga jinok ni Namarò ta umay mammaguray nittam. Dayáwat tam yù Patul na Israel!” kud da. ");
INSERT INTO att_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Á inikko ni Apu Kesu yù kígo na kabáyu nga dongki, nga nattakayán na. Á yáyù nga napalurò yù inipalappâ ni Namarò nga inipetúrâ na sù dán nga libru nga kunniaw: ");
INSERT INTO att_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sikayu nga taga Jerusalem, ari kayu maganássing. Ajjanin yù patul naw nga umay nikayu, nga mattakay ta kígo na dongki.” ");
INSERT INTO att_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Á yù ira sinudduán ni Apu Kesu, arád da nánnámmuán yù kebalinán nayù netúrâ. Ngam ta kabalin na naginnanolay nga limibbè ta lángì, ninonò da laguk ta yáyù kapalurò nayù dán nga netúrâ nga meyannung sù pattake na ta dongki nga minay ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Á yù ira magaru nga tatolay nga nakasingan kâ Apu Kesu sù pagágál na kâ Lasaru ta tanam na ta pamaginnanole na kuna, kinagi ra yù nasingad da sù ira tatolay ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Á yáyù nga minay yù ira magaru nga tatolay nga jiminápun kâ Apu Kesu, ta narámak da yù makapállâ nga pinagaddátu na. ");
INSERT INTO att_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Á nakkaká-ubobuk laguk yù ira Parisio, á kinagi ra laguk, “Ye, innan nawè! Awán garè ta awayyá tam, ta siminuttul ngámin nga tangapáddabbunán kuna!” kud da. ");
INSERT INTO att_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Á ajjan gapay yù ira nga ari Kudio nga taga Garesia nga minay makipiestá ta Jerusalem, tapè makimoray ira gapay kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Á minay ira laguk kâ Pilippi, nga taga Betseda sù purubinsia na Galilia, ta ed da kagian kuna, “Apu, ikáyâ mi makiammu kâ Apu Kesu,” kud da. ");
INSERT INTO att_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Á en na kinagi ni Pilippi kâ Andares, á nappulù ira, ta ed da kagian kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Á pakkagi di Andares ta ajjan yù ira umay nga taga Garesia, simibbák si Apu Kesu, á kinagi na nira, “Duttálin yù ággo na keparáyò, nga kepotuk ku sangaw ta lángì, sikán nga Kaká na ngámin na tatolay. ");
INSERT INTO att_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kukurugán nga kuruk yù kagiak ku nikayu. Máwák nga matayà sangaw ánna metanamà, tapè aru yù ira meyígù. Á yaw keyarigán na, yù tangabullung nga bini. Nu ari memulá ta dabbun, táttádday lâ nga ari umaru. Ngam nu memulá ta dabbun nga kunnay ta natay, á mattubbu, á mabbáli ta aru. ");
INSERT INTO att_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Á kunnian gapay yù keyarigán nayù tolay nga tángngagan na lâ yù ákkatole na ta baggi na sawe dabbuno, ta lonán na ngámin ta pate na sangaw ánna mesinná kâ Namarò ta áddè ta áddè. Ngam yù tolay nga máyâ nga mamalurò sù ipakuâ kuna, mássiki nu lonán na ngámin yù ikáyâ na sawe dabbuno, ngam meyígù, á málâ na yù áttole na kâ Namarò nga awán ta áddè na. ");
INSERT INTO att_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Á yù tolay nga máyâ nga makiaripan nikán, máwák na tumuttuttul nikán, tapè maguray lâ yù giák ku, ajjan lâ nikán yù aripak ku. Á iparáyo nayù Yámà ngámin yù ira nga makiaripan nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Á inupù ni Apu Kesu nga kinagi, “Á duttálin yù jigâ ku, á maburungà nga mapábbaw. Anni laguk ipakimállà ku kâ Yámà? Makimállakà nakuan panò kuna ta ilillì nangà sù jigâ nga duttál nikán sangaw? Ngam ari gemma, ta yáyù iniyángè saw, tapè attamák ku yù jigâ,” kun na. ");
INSERT INTO att_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Á kinagi na laguk ni Apu Kesu kâ Namarò, “Ammò ku, meparáyaw yù ngágam mu ta arubáng nayù ira tatolay megapu nikán,” kun na. Á dagarágâ ajjan yù ngárál nga naggapu ta lángì, á kun na, “Neparáyawin yù ngágak ku nga kamotungán, á meparáyaw paga sangaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Á yù ira magaru nga tatolay nga nanáddak ta aranni kuna, naginná ra yù ngárál, á kagiad da ta nagalittúgaw. Á yù ira káruán, “Ari,” kud da, “ngam nagubobuk yù daroban ni Namarò kuna,” kud da. ");
INSERT INTO att_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Á kinagi ni Apu Kesu nira, “Yane ngárál nga naginná naw, ari nagubobuk megapu nikán, nu ari galâ megapu nikayu, tapè manguruk kayu. ");
INSERT INTO att_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Á duttálin yù pamegapu nayù pamanunnù ni Namarò sù ira tatolay sawe dabbuno, ánna duttálin yù káppù ni Satanas, ánna yù ketabbà na. ");
INSERT INTO att_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Á sikán, sangaw nu mepotunà, agálák ku yù ira tatolay ta ngámin nga lugár, á abbágák ku ira, tapè umay ira mangikatalà nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Á yáyù kinagi ni Apu Kesu, tapè ipakánnámmu na nira yù ipate na nga mepátà ta kurù nga mapatáddak. ");
INSERT INTO att_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Á yáyù nga simibbák yù ira magaru nga tatolay, á kinagi ra kuna, “Naginná mi yù binibbik da nga netúrâ sù tunung tam, nga matolay yù MakKiristu ta áddè ta áddè nga mammaguray nittam. Ngattá laguk, ta kagiam mu ta mepotun nga mepátà ta kurù yù Kaká na ngámin na tatolay? Ari panò aggina yù mammaguray nga mangngágan ta Kiristu? Asinni laguk yù Kaká na ngámin na tatolay nga kum mu?” kud da. ");
INSERT INTO att_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Á yáyù nga kinagi na laguk ni Apu Kesu nira, “Maggiánà paga nikayu ta mabì. Á keggâ lâ paga nga mamannawák ta nonò naw, tuttulan nawà, tapè ari kayu sangaw mepárik sù tolay nga magabíyán. Ta yù tolay nga mallakák ta kallà, magawáwán gapu ta arán na ammu yù angayán na. ");
INSERT INTO att_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Á ta keggâ paga ta dabbuno nga mamannawák ta nonò na tolay, ikatalà nawà, tapè manawagán yù nonò naw nga mepagittá ta nonò ku,” kun ni Apu Kesu nira. Á kabalin ni Apu Kesu nagubobuk sù ira magaru nga tatolay, nánawán na ira, á nattuttù nira. ");
INSERT INTO att_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ta mássiki nu aru yù pinagaddátu na nga makapállâ ta arubáng da, nanakì ira nga manguruk kuna. ");
INSERT INTO att_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Á yáyù nga napatuppál yù initúrâ na ngaw ni Lákay Isaya, nga ábbilinán ni Namarò, nga kunniaw: “Apu, awán ta manguruk sù kinagi mi nira nga meyannung nikaw. Á awán gapay ta makánnámmu sù inipalappâ mu nga ámmagaddátum!” ");
INSERT INTO att_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Á gapu ta ari ira manguruk, kinagi na paga nayù ngaw Lákay Isaya yù meyannung sù ipanakì da, ta kinagi na, ");
INSERT INTO att_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pinabbalin na ira ni Namarò ta kun na buling, ánna pinataggâ na yù nonò da. Yáyù nga arád da kemámmatán yù mepasingan nira ánna arád da kánnámmuán yù mepalappâ nira. Ta kinagi ni Namarò, ‘Nu mabbabáwi ira nakuan ánna umay ira nikán, á pakomák ku ira,’ kun na.” ");
INSERT INTO att_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yáyù kinagi na ngaw ni Lákay Isaya sù ngaw gári, gapu ta nasingan na yù dalingáráng nayù MakKiristu, á kinagi na yù meyannung kuna. ");
INSERT INTO att_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Á mássiki nu ari nanguruk yù ira káruán nga Kudio, aru yù ira nga makáwayyá nga Kudio nga manguruk kâ Apu Kesu. Ngam inilímak da yù ángnguruk da gapu ta maganássing ira sù ira Parisio, marakè palawanad da ira sù ággagammungád da. ");
INSERT INTO att_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ta ikáyâ da yù paddáyo nayù ira ikáttole ra ánnè sù paddáyo ni Namarò nira. ");
INSERT INTO att_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Á uliotturu nga pangituddu ni Apu Kesu, iniyássikan na yù ubobuk na, á kinagi na, “Yù tolay nga manguruk nikán, ari lâ sikán yù kurugan na, nu ari gapay si Namarò nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Á yù tolay nga maningan nikán, imámmatán na gapay yù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Sikán yù meyárik ta nawák, á minayà ta dabbuno nga mamannawák ta nonò na tolay, tapè ari maggián ta kallà yù ira nga mangikatalà nikán. ");
INSERT INTO att_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Á nu ajjan yù tolay nga makaginná sù kagiak ku, ngam ari manguruk, á ari sikán yù mamanunnù kuna. Ta aringà minay nga mamanunnù ta tolay, ngam minayà ta dabbuno tapè sikán yù mangiyígù nira. ");
INSERT INTO att_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Ngam ajjan yù mamanunnù sù ira tatolay nga manakì nikán ánna ari manguruk sù kinagì, ta mokum ira sù pagáddekán na ággaw. Á yá ikokum da yù ubobuk ku nga arád da kinuruk. ");
INSERT INTO att_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta aringà magubobuk megapu sù pakáwayyâ, nu ari galâ megapu sù pakáwayyá nayù Yámà nga naddok nikán. Ta inibilin na nikán ngámin yù kagiak ku ánna ituddù. ");
INSERT INTO att_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Á ammù gemma ta manotolay yù taddán nayù Yámà ta tolay ta áddè ta áddè. Á yáyù nga kagiak ku yù ngámin nga inibilin nayù Yámà nikán.” ");
INSERT INTO att_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Á maddaggunin yù Piestá na panaddamád da ta pattalebák nayù daroban ni Namarò, á ammu ni Apu Kesu ta duttálin yù ággaw nga páno na ta dabbuno, nga manoli sù Yáma na ta lángì. Á ajjan yù ángngiddù ni Apu Kesu sù ira tatole na ta utun na dabbuno ta áddè ngaw pamegapu na ngámin. Á yáyù nga inipasingan na yù ángngiddù na nira nga napasigaggà ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Á ta púgágin, nakkakálálláng nga namúgák di Apu Kesu ánna yù ira tudduán na. Á kinuríru nen ni Satanas yù nonò ni Kudas nga anâ ni Simon Iskariote, ta ipagápù na si Apu Kesu sù ira malussaw kuna. ");
INSERT INTO att_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Á ammu ni Apu Kesu ta inikatalà nayù Yáma na kuna yù pakáwayyá na ta ngámin, ánna ammu na gapay ta si Namarò yù naggapuán na ánna labbetán na sangaw. ");
INSERT INTO att_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Á kabalid da kiminán, gimikkáng laguk si Apu Kesu, á inirián na yù latuk na barawási na, á inibarakà na yù tuálliá. ");
INSERT INTO att_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Á inâ na yù palanggána nga piniyyán na ta danum, á pinegapuanán na nga binaggawán yù takki nayù ira tudduán na ánna pinunatán na ira sù tuálliá nga inibarakà na. ");
INSERT INTO att_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Á pabbaggo ni Apu Kesu paga ta takki ra, jimikkì kâ Simon Eduru, tapè baggawán na yù takki na. Ngam nanakì si Eduru, á kinagi na kuna, “Apu, sikaw panò yù mamaggaw ta takkì?” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Á kinagi ni Apu Kesu kuna, “Arám mu kánnámmuán yawe nga akkuák ku kunangan, ngam kánnámmuám mu sangaw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Á kinagi ni Eduru kuna, “Apu, ari nakuan sikaw yù mamaggaw ta takki. Arák ku bulubugá ipabbaggaw nikaw yù takkì,” kun na. Á kinagi ni Apu Kesu kuna, “Nu arát taka baggawán, ari ka mesipà nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Apu,” kun ni Simon Eduru kuna, “nu kunniû laguk, ari lâ yù takkì yù baggawám mu, nu ari gapay yawe limâ ira ánna ulù,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Á kinagi ni Apu Kesu kuna, “Yù tolay nga najjigukin, ari má majjigù, ngam yù lâ takki na yù mabaggawán, tapè pareku nga marenu yù baggi na. Á sikayu, napakarenuán kayin, ngam ari sikayu ngámin,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ta ammu ni Apu Kesu yù tolay nga mappagápù kuna, á yáyù gapu na nga kinagi na ta ari ira ngámin yù napakarenuán. ");
INSERT INTO att_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Á kabalin ni Apu Kesu namaggaw ta takki ra, inâ na yù barawási na, á nanoli sù nagitubangán na. Á kinagi na nira, “Kánnámmuán naw panò yù kebalinán nayù kingnguâ nikayu? ");
INSERT INTO att_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Makimesturu kayu ánna makiyápu kayu nikán, á yáyù kustu, ta sikán gemma yù kukurugán nga yápu naw. ");
INSERT INTO att_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Á nu sikán, nga yápu naw ánna mesturu naw, yù mamaggaw ta takki naw, á sikayu gapay nakuan laguk yù makkakábaggaw ta takki naw. ");
INSERT INTO att_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Á inipasingak ku yawe nga kingnguâ nikayu, tapè kánnámmuán naw ta tumulù nakuan yù nonò naw, ánna párigán naw gapay yù akkuák ku. ");
INSERT INTO att_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta kukurugán nga kuruk yù kagiak ku nikayu. Ari makáwayyá yù aripan ánnè sù yápu na. Á kunniû gapay, ari makáwayyá yù ábbilinán ánnè sù maddok kuna. ");
INSERT INTO att_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Á nu kánnámmuán naw yawe nga ituddù nikayu, magayáyâ kayu laguk nu kurugan naw.” ");
INSERT INTO att_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Á kinagi ni Apu Kesu paga, “Yawe nga kinagì nikayu, ari nga sikayu ngámin yù keyannungán na, ta ammù yù ira nga pinílì. Ngam egga yù mappagápù nikán, tapè mapalurò yù dán nga netúrâ nga kunniaw: ‘Yù kapulupulù ku nga nepakkákán nikán, aggina yù mappagápù nikán.’ ");
INSERT INTO att_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yáyù nga kagiak ku nikayu kunangane pángè na kesimmu na, tapè sangaw nu mesimmu, manguruk kayu nikán, ta sikán yù Mangiyígù. ");
INSERT INTO att_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Á kukurugán nga kuruk yù kagiak ku nikayu. Yù tolay nga mangalawâ sù ira nga dobak ku, kunnay ta sikán gapay yù alawatan na. Á yù tolay nga mangalawâ nikán, kunnay ta alawatan na gapay yù naddok nikán.” ");
INSERT INTO att_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Á kabalin ni Apu Kesu nakkagi, mapábbaw yù nonò na, á kinagi na, “Kuruk yù kagiak ku nikayu. Ajjan nikayu yù mappagápù nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Á yù ira tudduán na, nakkakálipilipay ira, ta arád da ammu nu asinni yù kagian na. ");
INSERT INTO att_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Á ajjan yù tádday nira nga nagitubang ta taging ni Apu Kesu. Aggina yù kuruk nga iddukan na. ");
INSERT INTO att_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Á inisenias ni Simon Eduru ta iyabbû na kâ Apu Kesu nu asinni yù kagian na. ");
INSERT INTO att_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Á yù tolay nga iddukan ni Apu Kesu, nga namerik kuna, iniyabbû na kuna. “Apu, asinni yù kagiam mu nga mappagápù nikaw?” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Á kinagi ni Apu Kesu kuna, “Yù iddák ku ta pán nga itunnà ku ta jigu,” kun na. Á pangitunnà na sù pán, iniyawâ na kâ Kudas nga anâ ni Simon Iskariote. ");
INSERT INTO att_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Á pangalawâ ni Kudas sù pán, dagarágâ nga simillung si Satanas kuna. Á kinagi na laguk ni Apu Kesu kâ Kudas, “Mabì ka lâ sù akkuám mu,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Á awán bulubugá sù ira nepakkákán ta makánnámmu nu anni yù ipangapurá ni Apu Kesu kâ Kudas. ");
INSERT INTO att_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Á gapu ta ammu nayù ira tudduán ni Apu Kesu ta si Kudas yù minánnangngal ta pitáka, kagian nayù ira káruán ta nonò da ta kinagi ni Apu Kesu kuna ta umay bì gumátáng ta kanan nga awágad da ta piestá, onu jinok na támma ta umay mangilimù sù ira magáwák. ");
INSERT INTO att_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Á pakálâ ni Kudas sù pán, nallawán nga nánaw. Á gabi ngin yù páno na. ");
INSERT INTO att_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Á kapállikuk ni Kudas nga nánaw, kinagi ni Apu Kesu, “Mepalappákin yù keparáyò, sikán nga Kaká na ngámin na tatolay. Á meparáyaw gapay si Namarò megapu nikán. ");
INSERT INTO att_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Á ta pangipalappâ ku sù keparáyo ni Namarò, ipalappâ na gapay yù keparáyò. Á dagarágâ yù pangipalappâ na sù keparáyò,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Sikayu nga makituddu nikán, sikayu yù ánâ ku,” kun na gapay ni Apu Kesu. “Á mabíkà lâ paga maggián nikayu. Á aleran nawà sangaw. Ngam kagiak ku gapay nikayu yù kun na kinagì gangù sù ira karakalán na Kudio, ta ari kayu makángay sù angayák ku. ");
INSERT INTO att_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Á yáyù nga kagiak ku nikayu yù bagu nga tunung ku, ta makkaká-iddù kayu. Á kunnay sù ángngiddù ku nikayu, kunnian gapay yù ángngiddù naw sù ira kábulun naw. ");
INSERT INTO att_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta yáyù pakánnámmuán nayù ira ngámin na tatolay ta sikayu yù kuruk nga makituddu nikán, nu masingad da yù pakkaká-iddù naw.” ");
INSERT INTO att_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Á iniyabbû na laguk ni Simon Eduru kâ Apu Kesu, “Apu, sisaw angayám mu?” kun na. Á simibbák si Apu Kesu, á kinagi na, “Ari ka lábbì makatuttul nikán sù angayák ku kunangane, ngam tumuttul ka galâ noka nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Á kinagi ni Eduru kuna, “Apu, anni má, ta aringà mepulù nikaw kunangane? Ta naparánakin, mássiki nu metapil yù baggì megapu nikaw,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Á simibbák si Apu Kesu, á kinagi na, “Naparán ken panò nga metapil megapu nikán? Ngam kuruk galâ yawe nga kagiak ku nikaw. Sangaw nu ari paga nagittarákkò yù manù, namillu ken nga nakkagi ta arám mà ammu,” kun ni Apu Kesu kâ Eduru. ");
INSERT INTO att_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Gapu ta kunnian, kinagi ni Apu Kesu paga, “Ari kayu mabbagal ta nonò naw megapu sù kinagì. Ikatalà naw si Namarò, á ikatalà nawà gapay. ");
INSERT INTO att_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta ajjan yù kitáru nga paggianán na tatolay sù gián ni Ammò ku. Nu ari kuruk yian, arák ku gemma nakuan kagian nikayu. Á ek ku paránan yù paggianán naw. ");
INSERT INTO att_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Á kabalik ku mamarán sangaw sù paggianán naw, manolingà saw ta et takayu apan, tapè ilabbè takayu ta balè, á mepaggián kayu nikán. ");
INSERT INTO att_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Á ammu naw yù angayák ku ánna yù dálan nga makáddè tán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Á si Tomâ, kinagi na kuna, “Apu, arám mi gemma ammu yù angayám mu. Á kunnasi laguk pakánnámmu mi ta dálan?” kun na. ");
INSERT INTO att_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Á kinagi ni Apu Kesu, “Sikán yù meyárik ta dálan nga mappángè kâ Namarò, ta sikán yù mangipakánnámmu ta kuruk, ánna sikán yù manotolay. Awán bulubugá ta makángay kâ Ammò Namarò nu ari nga mangikatalà nikán. ");
INSERT INTO att_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu kuruk nga ammu nawà, ammu naw gapay yù Yámà. Á kunangane, ammu nawin yù Yámà ánna nasingan nawin,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Á pakaginná ni Pilippi karannian, kinagi na, “Apu, ipasingam mu nikami yù Yámam, tapè makáppak kami laguk,” kun na. ");
INSERT INTO att_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Á kinagi ni Apu Kesu kuna, “Nabayágà nga nepulupulù nikayu, Pilippi, á arán nawà paga ammu? Yù tolay nga nakasingan nikán, nemámmatán na gapay yù Yámà. Ngattá ta kagiam mu nikán ta ipasingak ku bì nikayu yù Yámà? ");
INSERT INTO att_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Arám mu paga kurugan ta ajjanà sù Yámà, á ajjan gapay yù Yámà nikán? Á ari nga naggapu ta urè yù ngámin nga ubobugak ku, nu ari galâ naggapu ta ure nayù Yámà. Ta maggián yù Yámà nikán, á aggina yù mangipakuá ta ngámin nga akkuák ku. ");
INSERT INTO att_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Manguruk kayu laguk megapu sù kinagì nikayu nga ajjanà sù Yámà ánna ajjan gapay yù Yámà nikán. Á mássiki nu arán naw kurugan yù kinagì nikayu, ngam kurugan naw galâ megapu sù pinagaddátù nga makapállâ nga nasingan naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Á kinagi ni Apu Kesu paga, “Á kukurugán nga kuruk yù kagiak ku nikayu. Yù tolay nga manguruk nikán, akkuán na gapay yù kunnay sù kingnguâ. Á napakáru paga yù makapállâ nga akkuán na ánnè sù kingnguâ, gapu ta manolingà sù Yámà. ");
INSERT INTO att_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Á maguray lâ yù ipakimállà naw sù Yámà megapu ta panguruk naw nikán, á yáyù akkuák ku tapè meparáyaw yù Yámà megapu nikán. ");
INSERT INTO att_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nu ajjan yù ipakimállà naw megapu sù pangikatalà naw nikán, yáyù akkuák ku,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Á kinagi ni Apu Kesu, “Nu kuruk nga iddukan nawà, á tuppálan naw yù taddák ku nikayu. ");
INSERT INTO att_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Á makimállakà sù Yámà, ta iyawâ na nikayu yù tanakuán nga mangabbák nikayu, nga mepulupulù nikayu ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aggina yù Ikararuá ni Namarò, á ipakánnámmu na nikayu yù kuruk nga meyannung kâ Namarò. Á yù ira tatolay nga ari manguruk, arád da málawâ gapu ta arád da ammu ánna arád da kánnámmuán. Ngam sikayu, ammu naw, ta sigídá mepulupulù nikayu ánna maggián ta nonò naw. ");
INSERT INTO att_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Á mássiki nu panawát takayu, arát takayu táttájjián nga kun na ulilá, ta manolingà sangaw nikayu. ");
INSERT INTO att_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Á sangaw nu manganánnuán, arád dangà masingan nayù ira nga ari manguruk. Ngam sikayu nga manguruk, masingan nawà. Á gapu ta sikán yù sigga-inángà nga manotolay, mepattolay kayu gapay nikán ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Á sangaw nu duttál yù Ikararuá ni Namarò nikayu, yáyù nga pakánnámmuán naw ta ajjanà kâ Yámà. Á kánnámmuán naw gapay ta netádday kayu nikán, nga kunnay ta ajjanà gapay nga netádday nikayu. ");
INSERT INTO att_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Á yù tolay nga magginná sù bilik ku ánna tángngagan na yù ipakuâ kuna, aggina yù mangiddù nikán. Á yù tolay nga mangiddù nikán, iddukan nayù Yámà. Á sikán gapay yù mangiddù kuna, á ipakánnámmù kuna yù ngámin nga meyannung nikán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Á si Kudas nga tanakuán, nga ari MagIskariote, iniyabbû na laguk kâ Apu Kesu, “Apu, ngattá, ta sikami yù pangipalappátám mu sù nonò mu, ngam ari sù ira ngámin nga tatolay?” kun na. ");
INSERT INTO att_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Á simibbák si Apu Kesu, á kinagi na, “Yù tolay nga mangiddù nikán, tuppálan na yù bilik ku. Á aggina yù iddukan nayù Yámà. Á sikami kâ Yámà yù umay makipaggián kuna. ");
INSERT INTO att_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngam yù tolay nga ari mangiddù nikán, arán na tuppálan yù bilik ku. Á yù bilik ku nga ginnán naw, ari nga sikán yù paggapuán na nu ari galâ nga naggapu sù Yámà nga naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Á kagiak ku nikayu ngámin danniaw ta keggâ paga nikayu. ");
INSERT INTO att_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngam doban na sangaw nayù Yámà yù Mangilin nga Ikararuá nga umay nikayu nga pannakabaggì nga mangabbák nikayu. Á aggina yù mangituddu nikayu sù ngámin nga napiá ánna ipanonò na gapay nikayu yù ngámin nga kinagì nikayu. ");
INSERT INTO att_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Á gapu ta panawát takayu sangaw, ibattáng ku nikayu yù ággimammà ku nga maggapu sù nonò ku. Á yù ággimammà ku nga iyawâ ku nikayu, awán ta kárik piá na sawe dabbuno. Ari kayu laguk mabburung, ánna ari kayu maganássing. ");
INSERT INTO att_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naginná nawin yù kinagì gangù nikayu, nga mánawakin, á manolingà sangaw nikayu. Nu kuruk nga iddukan nawà, magayáyâ kayu laguk, gapu ta umayà sù Yámà, á makáwayyá yù Yámà ánnè nikán. ");
INSERT INTO att_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Á kinagikin yù pánò nikayu lage na kesimmu na, tapè sangaw nu mesimmu ngin, manguruk kayu laguk. ");
INSERT INTO att_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Á aringakin mabbayák nga makiubobuk nikayu, ta umay sangaw yù mammaguray sù ira narákè ta dabbuno. Awán gemma ta awayyá na nga mammaguray nikán. ");
INSERT INTO att_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngam meyanugù yù akkuán na, tapè ipasingak ku ta ngámin nga tolay ta iddukak ku yù Yámà, ánna tuppálak ku ngámin yù ipakuá na nikán,” kun ni Apu Kesu nira. Á kabalin na nakkagi karannian, kinagi na nira, “Arà! Gumikkáng kayu laguk, ta mánaw ittamin,” kun na. ");
INSERT INTO att_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Á nagángngarigán si Apu Kesu, á kinagi na sù ira tudduán na, “Sikán yù meyárik sù napiá nga nemulá nga úbas, á meyárik yù Yámà ta manaron sù nemulá. ");
INSERT INTO att_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Á tappángan na yù ira pangapangá na nga ari mabbungá, ánna pakarenuán na yù ira pangapangá na nga mabbungá, tapè mapakáru yù bungá ra. ");
INSERT INTO att_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Á kunnay gapay nikayu, ta napakarenuán kayin megapu sù kuruk nga bilin nga inipakánnámmù nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Maggián kayu laguk nga mepattatádday nikán, á maggiánà gapay nga mepattatádday nikayu. Á ta ángngarigán, nu ari maggián yù pangá nayù nemulá sù pun na, ari gemma makapabbungá. Á kunnay gapay nikayu, tanu arán nawà ikatalà nga mangabbák nikayu, arán naw makuá yù napiá nga ipakuâ nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Sikán yù kun na pun na úbas nga nemulá, á sikayu yù kun na pangapangá na. Á nu napasigaggà yù ángngikatalà naw nikán, maggiánà nikayu nga mangabbák, á aru yù napiá nga akkuán naw. Ngam nu mesinná kayu nikán, awán bulubugá ta makuá naw nga napiá. ");
INSERT INTO att_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Á yù tolay nga ari maggián nikán, meyárik ta pangá nga natappáng. Á yù ira pangapangá nga natappáng, monnuk ira nga metabbà ta api nga matuggi. ");
INSERT INTO att_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Ngam sikayu, nu napasigaggà yù ángngikatalà naw nikán ánna nepittà ta nonò naw yù bilik ku, á maguray lâ yù ipakimállà naw kâ Yámà, yáyù mapalurò megapu nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Á ta kunnian, meparáyaw yù Yámà megapu sù aru nga napiá nga akka-akkuán naw, ánna mepasingan ta kuruk nga sikayu yù makituddu nikán. ");
INSERT INTO att_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Iddukat takayu. Á kunnay sù ángngiddù nayù Yámà nikán, kunniû gapay yù ángngiddù ku nikayu. Arán nawà laguk ikalurâ. Maggián kayu galâ nikán, nga mesipà sù ángngiddù ku nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu kurukurugan naw yù itaddák ku nikayu, mesipà kayu sù ángngiddù ku nikayu. Á kunnian gapay nikán, ta kurukurugak ku yù kagian nayù Yámà nikán, ánna mesipakà sù ángngiddù na nikán. ");
INSERT INTO att_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Á kagiak ku danniawe nikayu, tapè mepagayáyâ kayu nikán ánna mepallà yù ággayáyâ naw nga awán kárik piá na. ");
INSERT INTO att_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Á yawe yù itaddák ku nikayu, ta makkaká-iddù kayu ta kunnay sù ángngiddù ku nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","“Nu mabbaluntáriu yù tolay nga mangitapil sù baggi na megapu sù ira kopun na, awán ta nepallà nga ángngiddù ánnè sawe. ");
INSERT INTO att_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Á sikayu yù kopuk ku nu tuppálan naw yù itaddák ku nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Arát takayin laguk ingágan ta aripak ku, gapu ta arán na gemma ammu nayù aripan yù akkuán nayù yápu na. Ingágat takayin ta kopuk ku, gapu ta inipakánnámmù nikayu yù ngámin nga kinagi nayù Yámà nikán. ");
INSERT INTO att_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Á ari sikayu yù nappíli nikán, nu ari galâ ta sikán yù nappíli nikayu. Sinullà takayu tapè umay kayu mamalurò sù aru nga napiá nga ipakuâ nikayu, ánna mannanáyun yù napiá nga akka-akkuán naw. Á yáyù nga maguray lâ yù kiddawan naw sù Yámà ta pannakabaggì, yáyù iyawâ na nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Á yaw itaddák ku nikayu, ta makkaká-iddù kayu.” ");
INSERT INTO att_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Á kinagi ni Apu Kesu, “Ari kayu mapállâ nu malussaw nikayu yù ira tatolay nga ari manguruk nikán, ta ammu naw gemma ta sikán yù kegapuánán nayù kalusso ra nikayu. ");
INSERT INTO att_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Á ta ángngarigán nu naggigittá yù nonò naw ta nonò da, ayatad da kayu nakuan. Ngam ari ngin negittá yù nonò naw ta nonò da, gapu ta piníli takayu ta manguruk nikán, á yáyù nga ikalusso ra kayu. ");
INSERT INTO att_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Manonò naw yù kinagì nikayu, nga ari notun yù aripan ánnè sù yápu na. Nu jinigirigâ dangà, nga Yápu naw, jigirigátad da kayu gapay sangaw. Nu sinángngák da yù kinagì nira, tángngagad da gapay yù kagian naw. ");
INSERT INTO att_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Á ikalusso ra kayu ánna jigirigátad da kayu, gapu ta pangikatalà naw nikán, ta arád da garè ammu yù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Á nu aringà nakuan minay saw nga umay mangituddu nira, awán ira nakuan ta liwâ. Ngam minayà gemma nangituddu nira, á ari ira manguruk. Á yáyù nga ari ira makalillì sù ikáru ra nga liwâ. ");
INSERT INTO att_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Á yù tolay nga malussaw nikán, ikalusso na gapay yù Yámà. ");
INSERT INTO att_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu arák ku nakuan pinagaddátu ta arubáng da yù makapállâ nga arán na makuá na tanakuán nga tolay, awán ira nakuan ta liwâ. Ngam nasingad da yù akka-akkuák ku, á ikalusso ra kami kâ Yámà. ");
INSERT INTO att_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Á nesimmu yaw, tapè mapalurò yù dán nga netúrâ nga ubobuk ni Namarò nga kunniawe: ‘Ikalusso rangà, nga awán ta gapu na.’ ” ");
INSERT INTO att_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Á dobak ku sangaw ta umay saw nikayu yù Mangabbák nga maggapu kâ Yámà. Aggina yù Mangilin nga Ikararuá, nga mangipakánnámmu ta ngámin nga kuruk nga meyannung kâ Namarò, á ipakánnámmu na yù meyannung nikán. ");
INSERT INTO att_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Á sikayu gapay yù makkagi ta kuruk nga meyannung nikán, gapu ta sikayu yù mepulupulù nikán áddè ngaw pamegapu na pangituddù,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Á kinagi na paga ni Apu Kesu sù ira tudduán na, “Kinagì nikayu ngámin danniaw nga panigirigâ da nikayu nayù ira nga ari manguruk, tapè arán naw likuránán yù ángngikatalà naw nikán, mássiki nu anni yù mesimmu sangaw nikayu. ");
INSERT INTO att_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ta yù ira kábulun naw nga Kudio nga manangngal sù tunung, papanáwad da kayu sangaw ta kapilliá ra, á arád da kayu patallungan. Á nu ajjan yù mamapátay nikayu, kagian na ta arán na liwâ, nu ari galâ ta passerbi na kâ Namarò. ");
INSERT INTO att_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Á kunnian yù akkuád da nikayu, gapu ta arád da ammu yù Yámà. Á sikán, arád dangà ammu gapay. ");
INSERT INTO att_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Á kagiak ku danniaw nikayu kunangan, tapè sangaw nu duttál yù panigirigâ da nikayu, manonò naw laguk yù kinagì nga meyannung sù akkuád da. “Arák ku ngaw kinagi nikayu, gapu ta ajjanà paga nikayu. ");
INSERT INTO att_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ngam mánawakin sangaw, á manolingà sù Yámà nga naddok nikán. Á awán nikayu ta mangiyabbû nu sisaw angayák ku. ");
INSERT INTO att_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ta nakalò yù daddam naw gapu ta kinagì nikayu yù pánò. ");
INSERT INTO att_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Á kuruk yù kagiak ku nikayu, ta mammapiá yù ággián naw nu panawát takayu. Ta nu arát takayu nakuan panawán, ari nakuan umay yù Ikararuá ni Namarò nga mangabbák nikayu. Ngam nu mánawà sangaw nikayu, dobak ku laguk yù Mangilin nga Ikararuá ta umay maggián nga mangabbák nikayu. ");
INSERT INTO att_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Á tappì nayù Mangilin nga Ikararuá saw nikayu, ipakánnámmu na sù ira tatolay ta dabbuno yù meyannung ta liwâ da. Á ipakánnámmu na yù meyannung sù kuruk nga matunung, ánna yù meyannung ta pangukum ni Namarò sù ira nga ari manguruk. ");
INSERT INTO att_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Á gapu ta pangituddu nayù Ikararuá ta meyannung ta liwâ da, á yáyù nga kánnámmuád da ta yá pakaliwâ da kâ Namarò yù panakì da nikán, ta arád dangà ikatalà. ");
INSERT INTO att_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Á ta meyannung ta katunungán, ipakánnámmu nayù Ikararuá gapay ta sikán yù matunung, gapu ta pinalurò ku ngámin yù inipakuá nayù Yámà nikán, á mánawakin nga umay sù Yámà, á arán nawà masingan. ");
INSERT INTO att_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Á ipakánnámmu na gapay yù meyannung ta pangukum ni Namarò sù ira nga ari manguruk nikán, gapu ta dán nga naparán yù ángngukum ni Namarò kâ Satanas, nga mammaguray sù ira nga ari manguruk nikán ta dabbuno. ");
INSERT INTO att_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Á ajjan paga aru nga arák ku makagi, gapu ta arán naw paga kánnámmuán. ");
INSERT INTO att_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngam sangaw nu umay saw yù Ikararuá ni Namarò, ituddu na nikayu yù ngámin nga kuruk. Á ari yù ure na lápay yù paggapuán nayù ipakánnámmu na, ta ipakánnámmu na lâ yù kuruk nga maginná na kâ Namarò. Á ipalappâ na gapay nikayu yù duttál noka. ");
INSERT INTO att_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Á aggina yù mangiparáyaw nikán, gapu ta ipakánnámmu na nikayu yù kuruk nga maggapu nikán. ");
INSERT INTO att_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ta kukuâ ngámin yù kukuá nayù Yámà. Á yáyù nga kinagì nikayu ta ipakánnámmu na nikayu yù kuruk nga maggapu nikán,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Á kinagi ni Apu Kesu nira, “Sangaw, á arán nawà masingan. Á ari mabayák, á masingan nawà má,” kun na. ");
INSERT INTO att_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Á nakkaká-ubobuk yù ira káruán nga tudduán na, á kinagi ra, “Anni yawe nga kagian na nittam, nga arát tam sangaw masingan, á ari mabayák, á masingat tam má? Á yù kinagi na paga, nga ‘Manolingà sù Yámà’? ");
INSERT INTO att_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anni panò yù kebalinán nayù kinagi na nittam, nga ‘sangaw’ ánna ‘ari mabayák’? Arát tam kánnámmuán yù kagian na,” kud da. ");
INSERT INTO att_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Á ammu ni Apu Kesu yù ikáyâ da nga iyabbû nakuan kuna, á yáyù nga kinagi na nira, “Yawe panò yù ikáyâ naw nga iyabbû nikán, nu anni yù kebalinán nayù kinagì gangù, nga ‘Sangaw, á arán nawà masingan, á ari mabayák, á masingan nawà má sangaw’? ");
INSERT INTO att_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kukurugán nga kuruk yù kagiak ku nikayu. Sangaw nu arán nawà masingan, makkulukulè kayu, ta nerallà yù daddam naw. Ngam yù ira nga ari manguruk nikán, magayáyâ ira. Á mepallà yù daddam naw. Ngam mapatalián yù daddam naw ta pagayáyâ naw, sangaw nu masingan nawà má. ");
INSERT INTO att_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Á yá keyarigán naw yù babay nga maganâ, nga mabagal sù jigâ na ta paganâ na. Ngam ta pallawán nayù abbing, arán nen manonò yù jigâ na gapu ta ayâ na sù anâ na. ");
INSERT INTO att_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Á kunnay gapay nikayu, ta nakalò yù daddam naw sangaw. Ngam masingat takayu má sangaw, á mepallà yù pagayáyâ naw, á awán ta makári ta pagayáyâ naw. ");
INSERT INTO att_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Á sangaw nu duttál yù ággaw nga pakkakásingat tam má, aringin sikán yù pakkiddawán naw, nu ari galâ yù Yámà. Á kukurugán nga kuruk yù kagiak ku nikayu, makkiddaw kayu ta pannakabaggì, á maguray lâ yù kiddawan naw sù Yámà, yáyù iyawâ na nikayu megapu sù pangikatalà naw nikán. ");
INSERT INTO att_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Á ta áddè kunangan, ari kayu paga minay nga pannakabaggì nga makkiddaw sù Yámà. Makkiddaw kayu laguk megapu sù pangikatalà naw nikán, tapè málawâ naw, ánna mepallà yù pagayáyâ naw,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Á kinagi ni Apu Kesu paga nira, “Pangituddù nikayu, yá ángngituddù nikayu yù pagángngarigán. Ngam sangaw arák ku iyángngarigán yù kagiak ku, ngam ibukalák ku nikayu nga daretiu yù meyannung sù Yámà. ");
INSERT INTO att_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Á dattál nayù ággaw, ari ngin sikán yù makimállà sù Yámà megapu nikayu, nu ari galâ sikayu nga pannakabaggì yù makkiddaw sù Yámà. ");
INSERT INTO att_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta ayatan na kayu lággapay nayù Yámà, gapu ta ayatan nawà ánna kurugan naw ta sikán yù naggapu kuna. ");
INSERT INTO att_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Á si Namarò nga Yámà yù naggapuák ku, á minayà sawe dabbuno. Á mánawakin sangaw ta dabbuno nga manoli sù Yámà.” ");
INSERT INTO att_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Á pakaginná ra sù kinagi ni Apu Kesu, nga umayin sù Yámà na, kinagi nayù ira tudduán na, “Á kánnámmuám mi ngin yù kagiam mu, ta malitáwin, gapu ta arám min iniyángngarigán. ");
INSERT INTO att_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Á ammu mi ngin ta sikaw yù makánnámmu ta ngámin. Á mássiki nu awán ta mangiyabbû nikaw, ammum yù ajjan ta nonò mi. Á yáyù nga manguruk kami ngin ta sikaw yù naggapu kâ Namarò,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Á simibbák si Apu Kesu, á kinagi na nira, “Kuruk panò nga manguruk kayin? ");
INSERT INTO att_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Duttál sangaw yù oras, á makkáttuay kayu nga mallalabbè ta bale naw, á sikán lâ mabattáng. Ngam aringà maguroray, ta ajjan lâ nikán yù Yámà. ");
INSERT INTO att_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Á kinagì yaw nikayu, tapè magimammà yù nonò naw megapu sù ketádde naw nikán. Ta keggá naw ta dabbuno, marigirigâ kayu. Pataggatan naw lâ yù nonò naw, ta ippù kin si Satanas, nga pakiyápuán nayù ira nga ari manguruk nikán.” ");
INSERT INTO att_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Á ta kabalin ni Apu Kesu nagubobuk karannian, nattánguk ta lángì, á nakimállà kâ Namarò, á kinagi na, “Ammò, jimittálin yù ággò. Iparáyom laguk yù Anâ mu, tapè iparáyo taka gapay. ");
INSERT INTO att_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ta iniyawâ mu nikán yù pakáwayyâ sù tolay, tapè iyawâ ku sù ira ngámin nga tatolè yù áttole ra nga awán ta áddè na. ");
INSERT INTO att_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Á yawe yù áttole ra nga awán ta áddè na, ta pakánnámmuád da ta kuruk nga sikaw si Namarò nga táttádday, ánna sikán yù MakKiristu, nga jinok mu ta dabbuno. ");
INSERT INTO att_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Á meparáyaw ka sawe dabbuno megapu nikán, ta sinuppál kin ngámin yù inipakuám nikán. ");
INSERT INTO att_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ammò, ipotum mà bì laguk ta arubáng mu, tapè metoli nikán yù dalingáráng nayù keparáyò, nga ajjan ngaw nikán sù keggâ paga nikaw lage na kaparò na dabbuno. ");
INSERT INTO att_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Sikaw yù inipakánnámmù sù ira tatolay ta dabbuno nga iniyawâ mu nikán. Tatolem ira gemma, á iniyawâ mu ira nikán, á kinuruk da yù bilim mu. ");
INSERT INTO att_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Á nánnámmuád da ta sikaw yù paggapuán nayù ngámin nga kingnguâ. ");
INSERT INTO att_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta inituddù nira yù ngámin nga bilim mu nikán, á kinuruk da. Á ammu ra ta kuruk nga sikaw yù naggapuák ku ánna sikaw yù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Á Ammò ku, aggira yù ipakimállà ku. Arák ku ipakimállà yù ira ngámin ta dabbuno, nu ari galâ yù ira nga iniyawâ mu nga mangikatalà nikán, ta tatolem ira gemma. ");
INSERT INTO att_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngámin yù ira tatolè, tatolem ira gemma, ánna ngámin nga kukuám, kukuâ ira gapay. Á meparáyawà megapu nira. ");
INSERT INTO att_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Á mánawà sangaw ta dabbuno, nga umay nikaw. Ngam mabattáng paga ta dabbuno yù ira tatolay nga iniyawâ mu nikán, gapu ta lubbekakin nikaw. Ammò nga Mangilin, ásigurám mu yù ira tatolè nga iniyawâ mu nikán, megapu sù pakáwayyám ta ngámin, tapè maggigittá yù nonò da nga kunnay ta nonò ta. ");
INSERT INTO att_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Á ta keggâ paga nira, sikán yù pannakabaggim nga manaron nira. Inásigurák ku yù ira ngámin nga iniyawâ mu nikán, tapè awán ta magawáwán nira, ngam yù tádday lâ, tapè mattuppál yù dán nga netúrâ nga bilim mu. ");
INSERT INTO att_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Á lubbekakin nikaw, Ammò. Ngam kagiak ku yawe ta keggâ paga nira, tapè maginná ra ánna mesipà ira sù pagayáyâ ku. ");
INSERT INTO att_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inikatalà ku nira yù bilim mu, á manguruk iren. Á yáyù nga aggira yù ikalusso nayù ira nga ari manguruk, gapu ta kunnay nikán, ari ira mepulù sù ira nga ari manguruk. ");
INSERT INTO att_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Á yawe lâ ipakimállà ku nikaw, ta arám mu ira ipánaw ta dabbuno, ngam taronám mu ira, tapè arán na ira melogò ni Satanas. ");
INSERT INTO att_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ta aggira yù kunnay nikán nga ari gemma mepulù sù ira nga ari manguruk, ta ari negittá yù nonò da. ");
INSERT INTO att_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pakarenuám mu laguk yù nonò da megapu sù bilim mu, tapè mabbáli ira ta tatolem nga mangilin. Ta kuruk gemma yù bilim mu. ");
INSERT INTO att_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Á kunnay ta paddok mu nikán ta umay sù ira tatolay ta dabbuno, dobak ku ira ta umay ira ta ngámin nga lugár, tapè ipakánnámmu ra yù bilim mu sù ira nga ari paga nakaginná. ");
INSERT INTO att_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Á gapu ta ángngiddù ku nira, itulù ku yù baggì nikaw, nga metapil megapu nira, tapè mabbáli ira ta tatolem megapu sù bilim mu,” kun ni Apu Kesu sù Yáma na. ");
INSERT INTO att_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Á ari lâ yawe ira yù ipakimállà ku, Ammò, nu ari gapay yù ira ngámin nga manguruk nikán noka megapu sù pangituddu ra. ");
INSERT INTO att_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Á yá ipakimállà ku, Ammò, ta naggigittá ngámin yù nonò da, nga kunnay nitta nga naggigittá yù nonò ta, tapè mesipà ira nitta. Á yáyù ipakimállà ku, tapè kurugan nayù ira tatolay ta dabbuno ta sikaw yù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Á iniparáyò ira gapay nga kunnay sù pangiparáyom nikán, tapè mepaggittá yù nonò da nga kunnay ta naggittá nga nonò ta. ");
INSERT INTO att_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Á ajjanà nira, nga kunnay ta ajjan ka nikán, tapè kuruk nga napiá yù áttatádde na nonò da. Á ta kunnian, kánnámmuán nayù ira nga ari manguruk ta sikaw yù naddok nikán, ánna ammu ra ta iddukam mu yù ira nga mangikatalà nikán ta kunnay ta ángngiddù mu nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ammò, iniyawâ mu nikán ta tatolè yù ira nga manguruk nikán. Á ikáyâ ku ta mesipà ira gapay noka nikán ta paggianák ku ta lángì, tapè masingad da yù keparáyò ánna yù dalingáráng ku nga iniyawâ mu nikán sù arán na paga kaparò na dabbuno megapu sù ángngiddù mu nikán. ");
INSERT INTO att_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ammò, napiá yù nonò mu nga awán kárik piá na. Á yù ira tatolay nga ari manguruk, arád da ka ammu. Ngam sikán, ammu taka. Á yù ira tatolè nga iniyawâ mu nikán, ammu ra ta sikaw yù naddok nikán. ");
INSERT INTO att_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Á sikaw yù inipakánnámmù nira, á aringà mattukkâ nga mangipakánnámmu nikaw, tapè maggiánà nira ánna makkaká-iddù ira. Á kunnay sù ángngiddù mu nikán, kunnian gapay yù ángngiddù da sù ira kábulud da.” ");
INSERT INTO att_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Á kabalin ni Apu Kesu nakimállà sù Yáma na, nánaw di Apu Kesu ánna yù ira tudduán na ta Jerusalem. Á minay ira sù kamulán ta dammáng na danum na Kidron. ");
INSERT INTO att_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Á si Kudas, nga nabbalin ta mappagápù kâ Apu Kesu, ammu na gapay yawe lugár nga angayád da, ta yáyù ággangayád da kári Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Á inipulù ni Kudas yù ira tangapangan nga suddálu ánna yù ira magguárdiá nga jinok nayù ira kátannangán nga pári ánna yù ira Parisio. Á minay ira nga konsu ármas ánna tulu sù giád di Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Á pakáranni nayù ira nagármas sù giád di Apu Kesu ta kamulán, á mássiki nu ammu ni Apu Kesu yù mesimmu kuna sangaw, en na ira jinápun. “Asinni aleran naw?” kun na nira. ");
INSERT INTO att_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Á simibbák ira, á kinagi ra, “Si Kesu nga taga Nasaret,” kud da. “Sikán yaw,” kun ni Apu Kesu nira. Á ajjan nga nepulù nira si Kudas, nga mangituddu kâ Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Á pakkagi ni Apu Kesu nira, “Sikán yaw,” á nassanuk ira, á natombá ira. ");
INSERT INTO att_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Á pidduá ni Apu Kesu nangiyabbû nira, á kinagi na, “Asinni aleran naw?” kun na. “Si Kesu nga taga Nasaret,” kud da má. ");
INSERT INTO att_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Simibbák si Apu Kesu, á kinagi na, “Sikán, kuk ku pá gangù. Á nu sikán lâ aleran naw, paguráyán naw yawe ira kábuluk ku, tapè mánaw ira,” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yáyù kinagi na tapè mapalurò yù ngaw kinagi na sù Yáma na, nga kun na, “Yù ira tatolay nga iniyawâ mu nikán, awánà bulubugá ta máwáwán nira.” ");
INSERT INTO att_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Á ajjan kâ Simon Eduru yù badáng na nga konsu alák. Á inásù na, á kittak na yù talingá nayù aripan nayù kotunán na pári, á nalasápán yù jiwanán nga talingá na. Á si Malkus yù ngágan nayù aripan. ");
INSERT INTO att_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Á kinagi na laguk ni Apu Kesu kâ Eduru, “Iyalák mu yù badáng mu. Kagiam mu panò ta arák ku meyangngà yù jigâ ku nga sinullà nayù Yámà nikán?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Á yù ira suddálu ánna yù kapatás da, ánna yù ira magguárdiá, ginápù da laguk si Apu Kesu, á bináluk da. ");
INSERT INTO att_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Á napolu iniyánge ra kâ Annas, nga katugángán ni Kayapas nga kotunán na pári tán nga dagun. ");
INSERT INTO att_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kayapas yù nanabarang sù ira Kudio ta más napiá nu metapil yù tádday nga tolay megapu sù ira ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Á paggápù da kâ Apu Kesu, ajjan yù ira duá nga sinudduán ni Apu Kesu, di Simon Eduru ánna yù tádday paga nga siminuttul nira ta pangituluk da kuna sù kotunán na pári. Á yù kabbulun ni Eduru, ammu na yù kotunán na pári, á yáyù nga nepulù kâ Apu Kesu nga simillung sù nálitukán nga námmuák na bale na pári. ");
INSERT INTO att_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngam naggián lâ si Eduru ta puertá nayù alitù. Á minay laguk yù kabbulun na nga nakkagi sù babay nga manaron ta puertá, ta patallungan na gapay si Eduru ta námmuák nayù balay. ");
INSERT INTO att_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tallung ni Eduru, iniyabbû nayù babay kuna, “Ari gapay sikaw yù tádday nga makituddu sù tolay nga ginápù da?” kun na. “Ari sikán,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Á gapu ta malummin yù gabi, nappagaddul yù ira aripan ánna yù ira magguárdiá ta bága, á nanáddak ira nga naggirínu. Á nepaggirínu gapay si Eduru nira. ");
INSERT INTO att_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Á paggirínu ni Eduru ta námmuák, ajjan ta balay yù kotunán na pári, á binestigá na si Apu Kesu ta meyannung sù ira sinudduán na ánna yù meyannung sù ituddu na. ");
INSERT INTO att_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Á simibbák si Apu Kesu, á kinagi na kuna, “Sinudduák ku yù ira tatolay ta arubáng na tangapáddabbunán, sù ira kapilliá ra ánna sù mangilin nga kapilliá, nga paggagammungán na ngámin na Kudio, á awán bulubugá ta inilímak ku. ");
INSERT INTO att_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ngattá, ta sikán yù pangiyabbutám mu? Iyabbû mu lâ sù ira tatolay nga nakaginná sù inituddù, ta ammu ra gemma yù kinagì nira,” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pakkagi na karannian, á lippák nayù tádday nga magguárdiá si Apu Kesu. Á kinagi nayù magguárdiá kuna, “Ngattá, ta kunnian ákkitabbák mu sù kotunán na pári?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Á simibbák si Apu Kesu sù magguárdiá, á kinagi na, “Nu nakaliwaták ku nakuan yù ákkitabbák ku kuna, kagiam mu yù liwâ ku. Ngam nu kuruk yù kinagì, ngattá, ta lippák mà?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Á yáyù nga nipabáluk ni Annas si Apu Kesu, á inipeyánge na laguk kâ Kayapas, nga kamotungán na pári. ");
INSERT INTO att_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Á nepattáddak lâ paga si Simon Eduru nga mepaggirínu nira. Á kinagi ra kuna, “Ari sikaw gapay yù tádday nga tudduán na?” kud da. “Ari sikán,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Á ajjan yù tádday nga aripan nayù pári, nga kanakanáyun nayù tolay nga kittak ni Eduru, á iniyabbû na kâ Eduru, “Ari sikaw yù nasingak ku gangù nga kabbulun na túrin ta kamulán?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Á nilímak na má ni Eduru. “Ari,” kun na. Á dagarágâ nagittarákkò yù manù. ");
INSERT INTO att_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Á ta alippánnawák, lage na lussáng yù bilák, inipáno ra si Apu Kesu ta palásiu ni Kayapas, á ed da iniyángay sù palásiu nayù gubinador nga taga Roma. Ngam yù ira Kudio nga nangiyángay kuna, ari ira simillung sù palásiu, ta nu tullung ira nakuan sù bale na ari Kudio, á ari ira meyanugù nga kumán sù Piestá na panaddamád da ta pattalebák nayù daroban ni Namarò, gapu ta mebiláng ira ta marapingán. ");
INSERT INTO att_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Á yáyù nga nallawán si Gubinador Pilatto nira, á iniyabbû na sù ira Kudio, “Anni ipangikeká naw sawe tolay?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Á simibbák ira, á kinagi ra kuna, “Nu awán ta liwâ na, arám mi nakuan ikeká nikaw,” kud da. ");
INSERT INTO att_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Á kinagi ni Gubinador Pilatto nira, “Apan naw laguk, ta sikayu mabbestigá kuna ta meyannung sù tunung na Kudio,” kun na. Á kinagi nayù ira Kudio kuna, “Awán ta awayyá mi nga mamagikáru kuna ta patay, ta sikayu lâ nga taga Roma yù makáwayyá nga mamagikáru ta tolay ta pate na ta kurù,” kud da. ");
INSERT INTO att_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Á nesimmu yaw, tapè mattuppál yù kinagi ni Apu Kesu nga meyannung sù ámmapáte ra kuna. ");
INSERT INTO att_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Á simillung si Pilatto laguk sù palásiu na, á inipágál na si Apu Kesu, á iniyabbû na kuna, “Sikaw panò yù patul nayù ira Kudio?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Á simibbák si Apu Kesu, á kinagi na, “Asinni nakaginnám mu? Naggapu panò ta nonò mu, onu egga panò yù nakkagi nikaw?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Á simibbák si Pilatto, á kinagi na, “Kudiongà panò? Yù ira ikáttolem nga Kudio ánna yù ira kátannangán nga pári yù mangikeká nikaw. Anni panò kingnguám nga ipangikeká ra nikaw?” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Simibbák si Apu Kesu, á kinagi na, “Tanakuán yù pammagurayák ku, nga ari saw dabbuno. Nu saw dabbuno nakuan yù pammagurayák ku, makigerrá nakuan yù ira tatolè, tapè arád dangà magápù nayù ira Kudio. Ngam ari saw dabbuno yù pammagurayák ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Á kinagi ni Pilatto kuna, “Á kuruk nga patul ka lagugam?” kun na. Á simibbák si Apu Kesu, á kinagi na, “Sikaw yù nakkagi ta patulà. Á yawe inikeyanâ ku ta dabbuno, tapè ituddù yù meyannung sù kuruk. Á yù ira tatolay nga makánnámmu sù kuruk, magginná ira sù kagiak ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Á kinagi ni Pilatto kuna, “Anni panò yù kuruk?” kun na. Kabalin na nagubobuk karanniaw, minay si Pilatto sù gián nayù ira Kudio ta lawán, á kinagi na nira, “Awán bulubugá ta ammù nga liwâ na,” kun na. ");
INSERT INTO att_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Ngam ajjan yù kustombare naw nga palubbángak ku yù tádday nga nebáluk megapu sù piestá na panaddamán naw ta pattalebák nayù daroban. Gustu naw ta palubbángak ku yawe Patul na Kudio?” kun ni Pilatto nira. ");
INSERT INTO att_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ngam nagagga-aggay ira, á kinagi ra, “Ari yawe tolay, ngam si Barabas yù palubbángam mu,” kud da. Á tulisán si Barabas. ");
INSERT INTO att_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Á gapu ta piníli nayù ira Kudio si Barabas ta mapalubbáng, yáyù inipapaligà na laguk ni Gubinador Pilatto si Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Á yù ira suddálu, nilubik da yù sî nga pidde ra ta kun na kuroná, nga pine ra sù ulu na. Á binarawasiád da ta ujjojjin nga kun na barawási na patul. ");
INSERT INTO att_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Á jimikkì ira kuna, á inuyoyungád da. Kinagi ra kuna, “Maráyaw ka, sikaw nga patul na Kudio!” kud da. Á lippilippák da. ");
INSERT INTO att_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Á minay laguk si Pilatto ta lawán sù ira Kudio, ta en na má kinagi nira, “Iyarubáng ku nikayu, tapè kánnámmuán naw ta awán ta ammù nga liwâ na,” kun na. ");
INSERT INTO att_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Á yáyù nga nallawán si Apu Kesu nga neyarubáng nira, nga nakuronán paga ta sî ánna nabbarawási ta ujjojjin nga kun na patul. Á kinagi ni Pilatto nira, “Ye! Innan nawè yawe tolay!” kun na. ");
INSERT INTO att_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Á yù ira kátannangán nga pári na Kudio ánna yù ira magguárdiá sù mangilin nga kapilliá, pakasingad da kâ Apu Kesu, nga napaligà ánna nakuronán ta sî, nagagga-aggay ira, á kinagi ra, “Papatáyam mu! Ipepátà mu ta kurù!” kud da. Á kinagi ni Pilatto nira, “Apan naw laguk, ta sikayu lággapay mangipátà kuna, ta awán ta ammù nga liwâ na,” kun na. ");
INSERT INTO att_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Á simibbák yù ira Kudio, á kinagi ra kâ Pilatto, “Ajjan yù tunung na Kudio nga makkagi ta mepángngà nu mapagikáru ta patay yawe tolay, gapu ta pabbalinan na ta dios yù baggi na, ta kinagi na ta aggina yù Anâ ni Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pakaginná ni Pilatto sù kinagi ra nga meyannung kâ Apu Kesu, nga aggina yù Anâ ni Namarò, nakalò yù assing ni Pilatto. ");
INSERT INTO att_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Á simillung sù palásiu na, á iniyabbû na kâ Apu Kesu, “Naggapuám mu?” kun na. Ngam arán na bulubugá ni Apu Kesu sinabbák. ");
INSERT INTO att_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Á kinagi ni Pilatto kuna, “Ngattá, ta arám mà tabbagan?” kun na. “Arám mu panò ammu ta egga yù pakáwayyâ nga mamalubbáng nikaw? Á egga gapay yù pakáwayyâ nga mangipepátà nikaw ta kurù,” kun ni Pilatto. ");
INSERT INTO att_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Á simibbák si Apu Kesu, á kinagi na kuna, “Awán nakuan ta pakáwayyám nikán nu arán na iniyawâ ni Namarò nikaw. Á yáyù nga narámmà yù liwâ nayù mangikeká nikán ta arubáng mu ánnè sù liwâ mu,” kun ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pakaginná ni Pilatto sù kinagi ni Apu Kesu, á nappanà yù pakkaragâ na nga mamalubbáng kuna. Ngam yù ira Kudio, pine ra má nagagga-aggay, á kinagi ra, “Nu palubbángam mu yawe tolay, arán na ka kopun ni Patul Sisar. Ta kinagi nayù tolay ta aggina yù patul, á yáyù nga kontarán na si Patul Sisar nga patul tam,” kud da. ");
INSERT INTO att_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pakaginná ni Pilatto karannian, pinalawán na má si Apu Kesu. Á minay si Pilatto nagitubang sù ággitubangán na kues. Naratagán ta batu nga nalínis yù gián nayù ággitubangán na, nga Gabbata yù ngágan na ta ággubobuk nga Kebru. ");
INSERT INTO att_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Á pagitubang ni Pilatto nga mamestigá kâ Apu Kesu, mággè tangngá na ággawin, nga ággaw nayù papparán nayù ira Kudio ta piestá ra. Á kinagi ni Pilatto nira, “Innan nawè yawe patul naw!” kun na. ");
INSERT INTO att_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Á nagagga-aggay yù ira Kudio, á kinagi ra, “Ipepánom! Ipapátem! Ipepátà mu ta kurù!” kud da. Á kinagi ni Pilatto nira, “Yawe yù patul naw! Ngattá, ta ipepátà ku nakuan ta kurù yù patul naw?” kun na. Á simibbák yù ira kotunán nga pári, á kinagi ra, “Awán ta patul mi nu ari lâ si Patul Sisar túrin ta Roma!” kud da. ");
INSERT INTO att_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Á yáyù nga iniyawâ na laguk ni Pilatto nira, ta ipepátà da ta kurù. ");
INSERT INTO att_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Á yáyù nga inâ nayù ira suddálu si Apu Kesu, á inipakáttu ra kuna yù kurù nga pangipátakád da sangaw kuna. Á iniyánge ra ta puddul nga mangngágan ta Golgota sù ággubobuk nga Kebru, á yù kebalinán na yù Gián na Balakábâ. ");
INSERT INTO att_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Á pakáddè da ta gián na Golgota, inipátà nayù ira suddálu si Apu Kesu ta kurù. Á inipátà da gapay yù duá nga tolay ta kurù, nga pinatáddak da. Á pine ra si Apu Kesu ta tangngá ra. ");
INSERT INTO att_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Á inipetúrâ ni Pilatto yù panákkilalán nga pine ra ta utun na kurù, nga kunniaw yù kinagi na, “Yawe si Kesu nga taga Nasaret, yù Patul na Kudio,” kun nayù inipetúrâ na. ");
INSERT INTO att_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yáyù inipetúrâ na ta tallu nga makkakerumá nga ággubobuk, yù ággubobuk na Kudio, ánna yù Latin nga ággubobuk na taga Roma, ánna yù ággubobuk na Gareko gapay. Á aru yù ira Kudio nga nabbibbik sù netúrâ, ta aranni ta ili yù nangipátakád da kuna. ");
INSERT INTO att_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Á yù ira kátannangán nga pári na Kudio, kinagi ra kâ Pilatto, “Arám mu nakuan itúrâ, ‘Yù Patul na Kudio.’ Kunniawe lâ nakuan itúrâ mu, ‘Yawe tolay, kinagi na ta aggina yù Patul na Kudio,’ ” kud da. ");
INSERT INTO att_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Á simibbák si Pilatto, á kinagi na nira, “Yù initúrâ ku, netúrákin. Aringin mapatalián,” kun na. ");
INSERT INTO att_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Á kabalid da nangipátà nayù ira suddálu kâ Apu Kesu, inâ da yù gagámì na ta baggi na, á pinakkáppâ da sù pabballe ra. Ngam yù apaddu nga barawási na, arád da pinakkáppâ, ta inabal nga ari naragè. ");
INSERT INTO att_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Á yáyù nga nakkaká-ubobuk ira, á kinagi ra, “Arát tam pisilan yawe, ngam mabbibinnúnù ittam bì, tapè ammu tam yù makálâ kuna,” kud da. Yáyù nesimmu tapè mapatuppál yù dán nga netúrâ sù libru nga ubobuk ni Namarò, nga kunniaw: “Nabbaballáyád da yù gagámì ku, á nabbibinnunutád da yù barawásì.” Á yáyù kingnguá nayù ira suddálu. ");
INSERT INTO att_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Á ajjan tán di yená ni Apu Kesu nga nanáddak ta aranni ta kurù, aggira ánna yù wagi na yená ni Apu Kesu nga babay, á si Maria nga atáwa ni Kalopas, ánna si Maria Maddala. ");
INSERT INTO att_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Á pakasingan ni Apu Kesu kári innò na ánna yù sinudduán na nga iddukan na, kinagi ni Apu Kesu sù innò na, “Innò, anâ mu yù tolay nga kataging mu,” kun na. ");
INSERT INTO att_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Á kinagi na laguk sù sinudduán na, “Yená min yane,” kun na. Á yáyù nga inâ na yù yená ni Apu Kesu ta makipaggián kuna ta bale na tán nga ággaw. ");
INSERT INTO att_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Á ta kabalin na yaw, ammu ni Apu Kesu ta nabalinin ngámin. Á kinagi na laguk, “Makenumà,” kun na. Yáyù kinagi na tapè mapalurò yù dán nga netúrâ nga ubobuk ni Namarò. ");
INSERT INTO att_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Á ajjan tán yù angáng nga napannu ta binaráyáng, nga náppà nga inuman nayù ira suddálu. Á nisoso ra yù áttabbatabbúrù kuna, á pine ra ta tuppák na káyu. Á inigawâ da ta simù na. ");
INSERT INTO att_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Á pakakákkâ ni Apu Kesu kuna, kinagi na, “Netuppálin ngámin!” kun na. Á nakkummagin, á nagattâ yù inángà na. ");
INSERT INTO att_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Á gapu ta ággo nayù papparád da ta piestá, minay yù ira Kudio, á kinagi ra kâ Pilatto ta ipakattu na yù tuláng na takki nayù ira nepátà, tapè mabì ira matay ánna mári ira sù kurù, ta ari mepángngà nu naggián yù pate ra ta kurù ta pappiestá ra, gapu ta mangilin nga ággaw na Sabadu. ");
INSERT INTO att_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Á yáyù nga minay yù ira suddálu, á kittu ra yù tuláng na takki nayù ira duá nga kábulun ni Apu Kesu nga nepátà. ");
INSERT INTO att_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ngam pakáddè da kâ Apu Kesu, nasingad da ta natayin, á arád da kittu yù takki na. ");
INSERT INTO att_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngam yù tádday nga suddálu, piníká na yù bikà ni Apu Kesu, á dagarágâ nallawán yù dága ánna danum. ");
INSERT INTO att_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Á yù tolay nga nakasingan sù kesimmu na ngámin karanniaw, aggina yù nangitúrâ sawe, á kuruk ngámin yù inistoriá na, ta ammu na gemma yù nesimmu. Á kuruk ngámin yù kinagi na, tapè manguruk kayu gapay. ");
INSERT INTO att_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nesimmu danniaw tapè mapalurò yù dán nga netúrâ nga ubobuk ni Namarò nga kunniaw: “Awán bulubugá ta makattu nga tuláng na.” ");
INSERT INTO att_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Á ajjan gapay yù netúrâ nga kunniaw: “Inni-innad da yù piníká ra.” ");
INSERT INTO att_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Á ajjan yù tádday nga makituddu kâ Apu Kesu, si Kusè nga taga Arimatia. Ngam inilímak ni Kusè yù ángnguruk na gapu ta assing na sù ira karakalán na Kudio. Á pakarámak ni Kusè ta natayin si Apu Kesu, minay kâ Pilatto, ta en na kiddawan yù baggi ni Apu Kesu, tapè itanam na. Á inanugù ni Pilatto, á en na inâ yù baggi ni Apu Kesu, nga inipáno na. ");
INSERT INTO att_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Á nepulù kâ Kusè si Nikudemu. Si Nikudemu yù nallammang ngaw sù ánge na kâ Apu Kesu ta gabi. Á inipulù na yù bábbanguk nga mirrá ánna álo nga nekiruk, nga límápulu nga kílo yù kárammà na. ");
INSERT INTO att_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Á pangâ da sù baggi ni Apu Kesu, pinatáputád da ta puraw nga sinnun nga napayyán sù bábbanguk ta kun na kustombare na Kudio. ");
INSERT INTO att_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Á ajjan tán yù kamulán nga aranni sù nangipátakád da kâ Apu Kesu. Egga sù kamulán yù kuebá nga kapákkokkok lâ paga nga pangitanamád da nakuan, ngam awán paga bulubugá ta netanam tán. ");
INSERT INTO att_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Á gapu ta maddaggunin yù nanginá nga ággaw na Sabadu, nga ággibannák na Kudio, ánna aranni yù kuebá sù nangipátakád da ta kurù, á yáyù nga inikúrák da nga initanam tán yù baggi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pappasá na ággibannák da, á ta alippánnawák na Liggu, minay di Maria Maddala sù tanam ni Apu Kesu. Labbè da ta kuebá, nasingad da ta náringin yù dakal nga batu nga iniserrá ra ta puertá na kuebá nga nangitanamád da kuna. ");
INSERT INTO att_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Á nakkarerá si Maria nga minay kári Simon Eduru ánna yù tádday nga sinudduán ni Apu Kesu nga iddukan na. Á kinagi ni Maria nira, “Iniriád da si Apu sù tanam, á arám mi ammu yù nangikuád da kuna,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Á pakaginná ra sù kinagi ri Maria, dagarágâ nga minay di Eduru ánna yù tádday nga sinudduán ni Apu Kesu nga iddukan na, nga nappángè sù tanam. ");
INSERT INTO att_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nakkarerá ira, á napolu nga nakáddè sù kuebá yù tádday, nga kabbulun ni Eduru. ");
INSERT INTO att_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Á nakkummak, á nilákkawán na yù unak na tanam. Á nasingan na ta awánin si Apu Kesu. Nasingan na lâ yù sinnun nga neputápù nga kimibbà, ta awánin ta mayán na. Ngam ari simillung. ");
INSERT INTO att_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Á pakáddè na gapay ni Simon Eduru ta puertá na kuebá, dagarágâ nga inoluán na yù kabbulun na nga simillung sù unak na tanam, á nasingan na gapay yù sinnun nga nabattáng, ");
INSERT INTO att_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ánna yù gámì nga inibubbud da ngaw ta mammang na, nga náringin nga nakappil ánna nesinná ta baddì sù káruán na sinnun. ");
INSERT INTO att_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Á yù tádday nga sinudduán ni Apu Kesu nga napolu sù tanam na, simillung gapay ta en na iningan. Pakasingan na ta awánin, nangurugin ta naginnanolayin. ");
INSERT INTO att_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta mássiki nu nepalappâ sù dán nga netúrâ nga ubobuk ni Namarò yù meyannung sù máwák ni Apu Kesu nga matay ánna maginnanolay, arád da paga nánnámmuán yù dán nga netúrâ. ");
INSERT INTO att_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Á pakasingad da ta awán ta baggi ni Apu Kesu tán, nánaw ira laguk nga limibbè ta bale ra. ");
INSERT INTO att_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ngam si Maria Maddala, naggián lâ nga nakkulè ta lawán na tanam. Pakkulè na, nakkummak nga iningan na yù unak na kuebá. ");
INSERT INTO att_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Á pallákko na ta unak, nasingan na yù duá nga daroban ni Namarò nga nabbarawási ta puraw, nga nagitubang sù naggianán na gangù na baggi ni Apu Kesu. Naggián yù tádday nga daroban sù uluán na, á naggián yù mekaruá sù kiddanán na. ");
INSERT INTO att_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Á pakasingan nayù ira daroban kâ Maria, kinagi ra kuna, “Anni ipakkulè mu?” kud da kuna. Á kinagi na nira, “Inâ da garè si Yápù, á inipáno ra, á arák ku ammu yù nangipeddád da kuna,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Á kabalin ni Maria nakiubobuk sù ira daroban, nallipay, á nasingan na si Apu Kesu nga nanáddak tán, nga arán na tákkilalán. ");
INSERT INTO att_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Á kinagi ni Apu Kesu kuna, “Abè, anni ipakkulè mu?” kun na. “Asinni aleram mu?” kun na. Á kagian ni Maria ta yù minámmulá yù makiubobuk kuna, á yáyù kinagi na kuna, “Tíyu, nu sikaw yù nangâ kuna, kagiam mu bì yù nangipeddám mu kuna, ta ek ku apan,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Á kinagi ni Apu Kesu kuna, “Maria,” kun na. Nallipay si Maria, á kinagi na kuna sù ággubobuk nga Kebru, “Rabboni!” kun na. Á yù kebalinán na, “Mesturu!” ");
INSERT INTO att_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Á kinagi na laguk ni Apu Kesu kuna, “Arám mà igaggak, ta aringà paga minay ta lángì sù Yámà. Ngam em mu bì kagian sù ira wáwwagì ta umayakin ta lángì sù gián nayù Yámà, nga Yáma naw gapay. Aggina yù Yápù nga pakimorayák ku ánna yù Yápu naw gapay nga pakimorayán naw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Á nánaw laguk si Maria Maddala, á en na kinagi sù ira sinudduán ni Apu Kesu, “Nasingak ku si Apu!” kun na. Á kinagi na nira yù ngámin nga kinagi ni Apu Kesu kuna. ");
INSERT INTO att_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Á ta gabi na Liggu, naggagammung yù ira sinudduán ni Apu Kesu ta lágum na balay. Nelitù yù puertá na, ta maganássing ira sù ira karakalán na Kudio. Á limittuák laguk si Apu Kesu sù giád da. Á kinagi na nira, “Ajjawà saw. Mapagimammà yù nonò naw,” kun na nira. ");
INSERT INTO att_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Á inipasingan na laguk nira yù limá na ánna yù bikà na. Á ayatán ira ta pakasingad da sù Yápu ra. ");
INSERT INTO att_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Á pidduán na laguk ni Apu Kesu yù kinagi na nira, “Mabannáyán kayin ánna mapagimammà yù nonò naw. Dobat takayin ta kunnay sù paddok nayù Yámà nikán, ta umay kayu mangipakánnámmu nikán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Á pakkagi na karannian, inisù na ira, á kinagi na nira, “Alawatan nawin yù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Á nu pakomán naw yù liwâ nayù ira tatolay, pakomán ni Namarò ira gapay. Ngam nu arán naw pakomán yù liwâ da, arán na ira gapay pakomán ni Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Á pappasingan ni Apu Kesu sù ira sinudduán na, awán lâ si Tomâ, nga tádday sù ira mapulu duá nga iningágad da ta Jiping. ");
INSERT INTO att_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Á yáyù nga kinagi nayù ira káruán nga sinudduán ni Apu kuna, “Nasingam mi si Apu,” kud da. Ngam kinagi ni Tomâ nira, “Nu arák ku masingan yù pilâ nga napátakán ta limá na, ánna nu arák ku karápan gapay yù pilâ ta limá na ánna yù bikà na nga piníká ra, á arák ku kurugan,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Á pappasá na walu nga ággaw, sù tádday Liggu, naggagammung yù ira sinudduán ni Apu Kesu mángin sù balay. Á ajjanin gapay nira si Tomâ. Nelitù yù puertá. Á limittuák si Apu Kesu nira, á kinagi na, “Mabannáyán kayin, ánna mapagimammà yù nonò naw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Á kinagi na laguk kâ Tomâ, “Innam mu yù pilâ na limâ. Á em mu ira karápan ánna yù bikà ku nga piníká ra, tapè ari ka mabbábáng nga manguruk,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Á simibbák si Tomâ, á kinagi na kuna, “Sikaw yù Yápù! Sikaw yù Pakimorayák ku,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Á kinagi ni Apu Kesu, “Tomâ, napiá ta manguruk ka gapu ta pakasingam mu nikán. Á mepallà yù pagayáyâ nayù ira nga manguruk, mássiki arád dangà masingan,” kun na. ");
INSERT INTO att_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Á aru paga yù makapállâ nga pinagaddátu ni Apu Kesu ta arubáng nayù ira sinudduán na, nga ari netúrâ sawe libru. ");
INSERT INTO att_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Á netúrâ danniawe, tapè kurugan naw ta si Apu Kesu yù MakKiristu nga Anâ ni Namarò nga Makáwayyá nga Mangiyígù. Ta nu kurugan naw ánna ikatalà naw, mepattolay kayu kuna ta áddè ta áddè. ");
INSERT INTO att_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ta kabalin na yaw, nappasingan má si Apu Kesu sù ira sinudduán na ta keggá ra ta aggik na bebay na Tiberio. Nesimmu ta kunniawe. ");
INSERT INTO att_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nappupúlù di Simon Eduru, ánna si Tomâ nga iningágad da ta Jiping, si Nataniel nga taga Kana sù purubinsia na Galilia, yù ira duá nga ánâ ni Sebedo, ánna duá ira paga nga sinudduán ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Á kinagi ni Simon Eduru nira, “Ek ku magissirá.” Á kinagi ra kuna, “Á em mi sikaw bulunan,” kud da kâ Eduru. Á minay ira nappittà ta barangay. Á tangatangagabi ira nga nanígay, ngam awán bulubugá ta nálâ da. ");
INSERT INTO att_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Á ta alippánnawák, ajjan si Apu Kesu nga nanáddak ta aggik na bebay, ngam arád da natákkilalán nayù ira sinudduán na. ");
INSERT INTO att_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Á kinatolán ni Apu Kesu ira, á iniyabbû na, “Kopun, egga panò yù nálâ naw?” kun na. “Awán,” kud da kuna. ");
INSERT INTO att_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Á kinagi na nira, “Itán naw lâ ta jiwanán na barangay, ta yá pakálapán naw,” kun na. Á yáyù initád da, á arád den mákkâ gapu sù napakáru nga inâ na. ");
INSERT INTO att_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Á yáyù nga kinagi na laguk kâ Simon Eduru nayù tádday nga sinudduán ni Apu Kesu nga iddukan na, “Ye, si Apu!” kun na. Á pakaginná ni Eduru ta kuruk nga si Apu, inisillong na yù barawási na, ta nagilongán nga mattarabáku, á nakkassú sù danum ta umay ta aggik. ");
INSERT INTO att_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Á yù ira káruán nga nabattáng sù barangay, naporián ira nga umay ta aggik, á ginuggud da yù sígay nga napannu ta sirá. Aranni ira lâ ta aggik, ta magatù nga metro lâ támma yù kárayyu ra. ");
INSERT INTO att_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Á pakáddè da ta aggik, gimitták ira, á nasingad da yù bága na api ánna yù dán nga nesuppá nga sirá ánna pán gapay. ");
INSERT INTO att_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Á kinagi ni Apu Kesu nira, “Mangâ kayu bì sù sirá nga inâ naw, á iyánge naw saw,” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Á yáyù nga minay si Simon Eduru ta barangay, á inigon na yù sígay ta kannak, nga napannu ta darakal nga sirá. Magatù ta límápulu tallu yù biláng na sirá. Á mássiki nu aru yù nálâ na, ngam ari napisil. ");
INSERT INTO att_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Á kinagi na laguk ni Apu Kesu nira, “Umay kayu bì kumán,” kun na. Á awán nira ta nakeyabbû kuna nu asinni, ta ammu ra ta si Apu. ");
INSERT INTO att_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Á en na laguk inâ ni Apu Kesu yù pán, á bille na nira. Á kunnay gapay sù sirá, bille na nira. ");
INSERT INTO att_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Á yane yù mekatallu nga pappasingan ni Apu Kesu sù ira sinudduán na áddè sù paginnanole na. ");
INSERT INTO att_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Á kabalid di Apu Kesu kiminán, iniyabbû na laguk ni Apu Kesu kâ Simon Eduru, “Simon, nga anâ ni Kuan, nepallà panò yù ángngiddù mu nikán ánnè karannian?” kun na. Á kinagi ni Eduru kuna, “Wan, Apu, ammum ta ayatat taka,” kun na. Á kinagi ni Apu Kesu kuna, “Taronám mu laguk yù ira mangikatalà nikán, ta meyárik ira ta kígò,” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Á pidduán ni Apu Kesu nga iyabbû kâ Eduru, nga kun na, “Simon, nga anâ ni Kuan, egga panò yù ángngiddù mu nikán?” kun na. Á kinagi na má ni Eduru kuna, “Wan, Apu. Ammum ta ayatat taka,” kun na. Á kinagi ni Apu Kesu kuna, “Taronám mu laguk yù ira tatolè nga meyárik ta karnerù,” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Á pillu ni Apu Kesu nga iyabbû kâ Eduru, “Simon, nga anâ ni Kuan, egga panò yù ayâ mu nikán?” kun na. Á maraddam si Eduru gapu ta namillu si Apu Kesu nga nangiyabbû kuna. Á kinagi ni Eduru kuna, “Apu, ammum ngámin. Ammum ta ayatat taka,” kun na. Á kinagi na laguk ni Apu Kesu kuna, “Taronám mu yù ira tatolè nga meyárik ta karnerù. ");
INSERT INTO att_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kukurugán nga kuruk yù kagiak ku nikaw. Áddè sù ngaw kabagitolem, sikaw lággapay yù mamarawási ta baggim ánna sikaw lággapay yù maguray ta angayám mu. Ngam nu mallakalákay ka noka, á tanakuán yù mabbáluk ta baggim. Á sonnatam mu yù limám, á iyánge naka ta arám mu ikáyâ nga angayán,” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yáyù kinagi ni Apu Kesu ta ipakánnámmu na yù áppate ni Eduru noka tapè meparáyaw si Namarò. Á kabalin na nakkagi ni Apu Kesu karannian, kinagi na laguk kâ Eduru, “Tuttulam mà,” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Á nallipay si Eduru laguk, á nasingan na ta likuk da yù tádday nga tumuttuttul nira. Aggina yù sinudduán ni Apu Kesu nga iddukan na, nga kataging na ngaw sù pakkákád da lage na pate na. Á aggina yù nangiyabbû kâ Apu nu asinni yù mappagápù kuna. ");
INSERT INTO att_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Á pakasingan ni Eduru sù kabbulun na ta likuk da, kinagi na kâ Apu Kesu, “Apu, anni panò yù mesimmu sangaw sawe tolay?” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Á kinagi ni Apu Kesu kuna, “Á ta ángngarigán nu ikáyâ ku ta matolay yane tolay ta dabbuno ta áddè ta panolì saw, sikán lâ yù makánnámmu. Paguráyám mu lápay. Tumuttul ka nikán!” kun na. ");
INSERT INTO att_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Á yáyù nga neparámak sù ira kábulud da nga makituddu kâ Apu ta ari matay yane sinudduán na. Ngam arán ni Apu Kesu kinagi ta ari matay. Yá lâ kinagi na, “Ta ángngarigán nu ikáyâ ku ta matolay yane tolay ta dabbuno ta áddè ta panolì saw, sikán lâ yù makánnámmu,” kun na kâ Eduru. ");
INSERT INTO att_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Á yane sinudduán ni Apu Kesu nga ubobugan na, aggina yù mangipakánnámmu karanniaw nga nesimmu. Á aggina yù nangitúrâ, á ammu mi ta kuruk yù ngámin nga kinagi na. ");
INSERT INTO att_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Á aru paga yù kingngikingnguá ni Apu Kesu. Á nu metúrâ nakuan ngámin, ari mopù. Á ta urè, ari támma mekárgá yù paketúratán na ta tangapáddabbunán.");
INSERT INTO att_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mattúrákà nikaw, Don Topilu. Á sù ngaw olu nga initúrâ ku, kinagì nikaw yù ngámin nga kingnguá na ngaw ni Apu Kesu áddè ngaw ta pamegapu na mangituddu, ");
INSERT INTO att_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ta áddè ta kálâ na ta lángì. Á lage na nánaw, sinaddánán ni Apu Kesu yù ira sinudduán na nga sinullà na megapu sù pakáwayyá nayù Mangilin nga Ikararuá ni Namarò, ta umay ira mangilayalayâ sù bilin ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Á pappasá na pate ni Apu Kesu ta kurù, sù paginnanole na, á naggián ta dabbuno ta appátapulu nga ággaw ánna nappasingan sù ira sinullà na. Name-aru nga nappasingan nira, á aru yù kingngikingnguá na ta arubáng da, tapè ammu ra ta kuruk nga matolayin. Á kinagi na nira yù meyannung sù pammagure ni Namarò ta dabbuno. ");
INSERT INTO att_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Á paggián ni Apu Kesu paga nira, kinagi na nira, “Ari kayu lábbì mánaw ta Jerusalem. Iddagán naw yù iyawâ ni Namarò nikayu nga Mangilin nga Ikararuá, ta aggina yù kinagì ngaw nikayu nga initabbá na ngaw ni Ammò Namarò. ");
INSERT INTO att_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Á si Kuan ngaw, jinigù na kayu ta panákkilalán ta panguruk naw kâ Apu Namarò. Á danum yù inipanigù na nikayu. Ngam dumá yù ipanigù ni Namarò nikayu, ta umay sangaw nikayu yù Mangilin nga Ikararuá,” kun ni Apu Kesu nira. ");
INSERT INTO att_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Á paggagammung nayù ira sinudduán na, iniyabbû da kâ Apu Kesu, “Apu, sangaw nu anni yù pamatolim nikami nga ginaká ni Israel sù pammagurayám mi, nga ginubâ nayù ira kalusso mi?” ");
INSERT INTO att_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Á kinagi ni Apu Kesu nira, “Arán naw awayyá nga kánnámmuán yù ággaw nga kesimmu na. Si Ammò ku nga Namarò, aggina lâ yù makáwayyá nga manullà ta ággaw nga kapalurò na ngámin. ");
INSERT INTO att_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Á sangaw nu umay nikayu yù Mangilin nga Ikararuá, iyawâ na nikayu yù pakáwayyá naw nga mangilayalayâ sù napiá nga dámak. Á ilayalayâ naw yù ngámin nga meyannung nikán sawe ili na Jerusalem ánna ngámin táne lugár na Judiya ánna tuke lugár na Samaria ta áddè túrin ta pagáddekán na dabbuno.” ");
INSERT INTO att_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Á kabalin ni Apu Kesu nakkagi, á ta paningan nayù ira sinudduán na, nálâ nga nagayáyun nga minay ta lángì, á nalipparán nga nattukiâ ta kunam, á arád den masingan. ");
INSERT INTO att_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Á sinánguk da lâ paga ta lángì. Á pattánguk da, inikáddagâ lâ limittuák yù duá nga daroban ni Namarò, nga lálláki nga nabbarawási ta puraw nga gámì nga makatulang. ");
INSERT INTO att_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Á kinagi ra, “Sikayu nga taga Galilia, anni yù kabayák naw nga mattatáddak nga mattánguk ta lángì? Si Apu Kesu, nga nasingan naw nga minay ta lángì, aggina yù manoli saw noka, á kunnay ta páno na nga nasingan naw, kunnian gapay noka yù panoli na,” kud da nira. ");
INSERT INTO att_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pakaginná ra sù kinagi nayù ira daroban, nánaw ira laguk ta puddul nga mangngágan ta Olibo, á nanoli ira ta Jerusalem. Tangakilometro lâ yù kárayyu nayù puddul ta ili na Jerusalem. ");
INSERT INTO att_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Á labbè da ta Jerusalem, naddulò ira ta balay nga paggianád da, á minunè ira ta lágum ta utun, aggira ngámin kári Eduru, á si Kuan, si Ime, si Andares, si Pilippi, si Tomâ, si Bartolome, si Mattiu, si Ime nga anâ ni Alpio, si Simon nga Maláppà, á si Kudas nga anâ ni Ime. ");
INSERT INTO att_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Á naggagammung ira ta kággággaw, ta nattatádday yù nonò da nga nakimállà kâ Apu Namarò, aggira ngámin ánna yù ira bábbay kári Maria nga yená ni Apu Kesu ánna yù ira lálláki nga wáwwagi ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Á paggagammung da sù tádday nga ággaw, mággè magatù ta duápulu ira nga naggagammung tán. Á nanáddak si Eduru, á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wáwwagi, napalurokin yù inipalappâ nayù Mangilin nga Ikararuá nga inipetúrâ na ngaw kâ Patul Dabid sù ngaw pammagure na ta Israel. Yáyù initúrâ ni Patul Dabid nga meyannung kâ Kudas nga nappagápù kâ Apu Kesu. Á napalurokin, ta inipagápù ni Kudas si Apu Kesu sù ira nangnguá kuna. ");
INSERT INTO att_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Á nebiláng si Kudas nikami nga mapulu duá nga sinullà ni Apu, nga mesipà ta pattarabáku mi. ");
INSERT INTO att_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Á gapu ta pangabbák ni Kudas sù ira nga maggápù kâ Apu Kesu, inâ na yù kuártu nga táddán na megapu sù narákè nga kingnguá na, á yáyù inigátáng na ta dabbun nga natayán na. Ta napannâ si Kudas nga nallakak, á nabattâ yù sán na, á nallawán yù sine na. ");
INSERT INTO att_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yaw yù narámak da ngámin ta Jerusalem. Yáyù gapu na nga iningágad da yù dabbun ta Akaldama sù ággubobuk da, á yá kebalinán na yù Naragán nga Dabbun. ");
INSERT INTO att_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Á ajjan yù netúrâ nga kinagi na ngaw ni Patul Dabid sù kansion na, nga netúrâ ta libru nga Salmo, nga meyannung kâ Kudas, nga kunniaw: ‘Nánawán yù paggianán na, á awán bulubugá ta maggián kuna.’ Á ajjan gapay nga netúrâ, ‘Meyawâ laguk sù tanakuán nga tolay yù pakáwayyá na nga mattarabáku.’ ");
INSERT INTO att_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Á yáyù nga piliat tam laguk yù tádday sù ira nga nepappapulù ngaw nikami ta ngámin nga dagun nga keggá ni Apu Kesu nikami, ");
INSERT INTO att_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ta áddè ngaw sù panigù ni Kuan ta áddè sù kálâ ni Apu ta lángì. Á yù tolay nga piliat tam, aggina yù mepattatádday nikami, tapè ipakánnámmu na gapay yù paginnanole ni Apu.” Yáyù áddè nayù kinagi ni Eduru. ");
INSERT INTO att_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Á kabalin ni Eduru nanabarang nira, pinaddepuák da laguk yù duá nga lálláki, si Kusè nga iningágad da ta Barsabas, nga Justo yù apulídu na, ánna si Matias. ");
INSERT INTO att_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Á nakimállà ira kâ Apu ta meyannung sù duá nga lálláki. Á kinagi ra, “Apu, ammum yù nonò na ngámin nga tatolay ánna danniaw nga duá. Ituddum nikami bì nu asinni yù piliam mu, ");
INSERT INTO att_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tapè aggina yù málâ sù pakáwayyá na nga mangilayalayâ ta bilim mu ánna masserbi nikaw, ta nilonán ni Kudas yù pattarabáku na, tapè umay sù gián nga mepángngà kuna,” kud da kâ Apu. ");
INSERT INTO att_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Á kabalid da nakimállà, nabbúnù ira megapu sù duá, á napíli si Matias, nga nelannà sù ira mapulu tádday nga minángngilayalayâ. ");
INSERT INTO att_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Á jimittál yù piestá nga mangngágan ta Pentekosto, á nattatádday yù ira ngámin nga manguruk sù tádday nga balay. ");
INSERT INTO att_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Á inikáddagâ lâ yù gurù nga naggapu ta lángì, nga kun na gurù na paddák nga masikan. Á kitagurù sù lágum na balay nga paggagammungád da. ");
INSERT INTO att_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Á limittuák nga nappasingan nira yù kun na api nga nesinisinek nga naddappá nira nga katággitádday. ");
INSERT INTO att_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Á napayyán ira ngámin sù Mangilin nga Ikararuá ni Namarò. Á dagarágâ nagubobuk ira ta makkakerumá nga ággubobuk, megapu sù Mangilin nga Ikararuá nga mangiyawâ nira ta pakáwayyá ra. ");
INSERT INTO att_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Á aru yù ira nga naggián ta Jerusalem, nga Kudio nga nakimoray kâ Namarò nga naggapu ta ngámin nga áppatulán ta dabbuno. ");
INSERT INTO att_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Á pakaginná ra ta gurù nga kun na masikan nga paddák, gikarakarerán ira nga minay nakipagammung. Á naginná ra yù pagubobuk nayù ira tatolay nga manguruk kâ Apu Kesu. Á nakalalang ira, ta mássiki nu makkakerumá yù katatole ra, naginná ra nga katággitádday yù ággubobuk na nga nakeyanatán na. ");
INSERT INTO att_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Á nepallà yù kapállâ da, á kinagi ra, “Asinni ngámin danniaw ira nga giyubu-ubobugán ta makkakerumá? Ari panò aggira yù taga Galilia? ");
INSERT INTO att_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Á kunnasi laguk ta maginná tam yù ággubobuk tam nga nakeyanatát tam nga katággitádday? Ta arád da gemma ammu nayù ira taga Galilia yù ira makkakerumá nga ággubobuk tam! ");
INSERT INTO att_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Á sittam, naggapu ittam ta aru nga áppatulán. Ajjan yù ira taga Partia ánna taga Media, taga Elam, á taga Mesopotamia gapay ánna taga Judiya, taga Kappadosia, taga Pontu, ánna taga Asia. ");
INSERT INTO att_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Á ajjan gapay yù ira taga Parigia ánna taga Pampilia, taga Egipto, ánna yù ira nga naggapu ta lugár na Libia nga aranni ta Sirene. Á ajjan gapay yù ira álliuk nga taga Roma, nga Kudio ánna yù ira nattudduán ta kustombare na Kudio, nga nakKudiongin. ");
INSERT INTO att_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Á ajjan gapay yù ira taga Kareta ánna taga Arabia. Á sittam ngámin, kánnámmuát tam yù kagian nayù ira taga Galilia, gapu ta magubu-ubobuk ira sù makkakerumá nga ággubobuk tam nga katággitádday. Á mangilayalayâ ira ta meyannung sù ngámin nga makapállâ nga kingngikingnguá ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anni panò yù kebalinán na?” Yáyù inubobuk nayù ira tatolay, gapu ta napállâ ira, ánna nakalalang ira. ");
INSERT INTO att_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngam ajjan gapay tán yù ira nga nanguyaw sù ira sinudduán ni Apu Kesu, á kinagi ra, “Námmellaw lâ danniaw ira!” kud da. ");
INSERT INTO att_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Á gapu ta panguyo nayù ira káruán nga tatolay, nanáddak laguk tán di Eduru ánna yù ira mapulu tádday nga sinudduán ni Apu Kesu nga mepulù kuna. Á si Eduru, iniyássikan na yù ngárál na, á kinagi na sù ira ngámin nga tatolay tán, “Sikayu nga kagittâ nga Kudio, ánna sikayu ngámin nga maggián ta Jerusalem, tángngagan naw yù kagiak ku nikayu, tapè mepakánnámmu nikayu yù kukurugán. ");
INSERT INTO att_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sikayu, kagian naw ta mellaw danniaw ira nga magubobuk, ngam ari kuruk, ta ari ira gemma namissán, ta awán ta mamissán ta pannawák. ");
INSERT INTO att_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngam yawe nga pagubobuk da nga maginná naw kunangan, kunnian yù kinagi na ngaw ni Joel, nga yù ngaw ábbilinán ni Namarò. Ta ajjan yù netúrâ nga inipakkagi ni Namarò kâ Joel, nga kun na: ");
INSERT INTO att_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nu duttál yù ira panguriánán nga ággaw, iyawâ ku sù ira ngámin nga tatolay yù Ikararuâ. Á yù ira ánâ naw, mangilayalayâ ira sù bilik ku. Á yù ira bábbagitole naw, masingad da yù ipalappâ ku nira. Á yù ira lállakaláke naw, mattatagenà ira, gapu ta pattatagenatak ku ira. ");
INSERT INTO att_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Á karanniúrin nga ággaw nga maporián, iddák ku ta Ikararuâ yù ira masserbi nikán, nga lálláki ánna bábbay, á ilayalayâ da yù bilik ku, megapu sù pakáwayyá nayù Ikararuâ. ");
INSERT INTO att_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Á pagaddatuak ku yù makapállâ nga panákkilalán ta lángì ánna dabbuno. Ipasingak ku yù dága, ánna api, ánna atû. ");
INSERT INTO att_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Makkallà yù bilák, á magujjin yù bulán ta kun na dága, lage nayù pangukum ku, ta pagáddekán na ággaw, nga ággaw nga mangilin, nga awán bulubugá ta kagittá na. ");
INSERT INTO att_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Á aggira ngámin nga makimállà nikán nga Yápu ra, meyígù ira, á arák ku ira ukuman,’ kun ni Namarò. Yáyù initúrâ na ngaw ni Joel, nga yù ngaw ábbilinán,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Á kabalin ni Eduru nga nangiyubobuk sù initúrâ ni Joel, kinagi na, “Sikayu nga kábuluk ku nga ginaká ni Israel, ginnán naw yù kagiak ku nikayu nga meyannung kâ Apu Kesu nga taga Nasaret. Inipakánnámmu ni Namarò nikayu ta aggina yù sinullà na, megapu sù aru nga pinagaddátu na nga makapállâ, nga inipakuá ni Namarò kuna. Á ammu naw gemma ngámin danniaw, ta nesimmu saw giát tam. ");
INSERT INTO att_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Á lage na namarò, dán nga ammu ni Namarò ngámin, ánna sinalákkuruk na nga ipetulù nikayu nga Kudio si Apu Kesu nga taga Nasaret. Á aggina yù ginápù naw ánna inipapapáte naw sù ira ari Kudio, á inipátà da ta kurù. ");
INSERT INTO att_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngam si Namarò, pinaginnanole na. Á nallawán sù tanam, nga matolay, ta ari megaggak megapu sù pate na. ");
INSERT INTO att_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Á initúrâ na ngaw ni Patul Dabid yù kuruk nga ubobuk ni Apu Kesu. Kinagi na: ‘Matákál ku si Apu Namarò nga sigídá mepulupulù nikán. Aringà bulubugá maburung, gapu ta maggián nikán nga mangabbák. ");
INSERT INTO att_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yáyù gapu na nga ayatán yù putù. Á ubobugak ku yù pagayáyâ ku, ta mássiki nu matay yù baggì, ajjan yù iddanamák ku, megapu nikaw, Apu. ");
INSERT INTO att_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ta arám mà tájjián sù gián nayù ira námmatay. Arám mu iyanugù ta malabbak yù baggì ta tanam, ta sikán yù Anâ mu nga iddukam mu, nga masserbi nikaw. ");
INSERT INTO att_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Á inipakánnámmum nikán yù napiá, nga meyárik ta dálan nga mappángè ta mannanáyun nga katolè, ta maginnanolayà nga mepattolay nikaw ta áddè ta áddè. Á magayáyákà nga mepappapulù nikaw.’ Yáyù initúrâ na ngaw ni Patul Dabid,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Á kinagi ni Eduru paga, “Wáwwagi, ammu tam gemma ta natay ngaw nga nabayágin yù ngaw Patul Dabid nga naggaká nittam, á netanam, á ajjan lâ paga nittam yù tanam na. Ari gemma yù baggi ni Patul Dabid yù inubobuk na sù initúrâ na. ");
INSERT INTO att_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“Ngam ta keggá na ngaw ni Patul Dabid, aggina yù ábbilinán ni Namarò, á ammu na ta kuruk nga mapalurò yù initabbá ni Namarò kuna. Á kinagi ni Namarò ta duttál noka yù ginaká ni Patul Dabid, nga táli na nga mammaguray sù áppatulán na. ");
INSERT INTO att_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ta inipalappâ ni Namarò kuna yù mesimmu noka pángè na kesimmu na, á yáyù nga kinagi na ngaw ni Patul Dabid yù meyannung sù duttál nga MakKiristu, nga maginnanolay, nga ari matájjián sù gián nayù ira námmatay, ánna ari malabbak yù baggi na ta tanam. ");
INSERT INTO att_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Aggina si Apu Kesu, nga pinaginnanole ni Namarò. Á sikami ngámin yù massistígu ta kukurugán nga naginnanolay, gapu ta nasingam mi. ");
INSERT INTO att_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Á kunangan ajjanin si Apu Kesu ta lángì, nga nagitubang ta jiwanán ni Namarò nga Yáma na, nga paggianán na maráyaw. Á iniyawâ nayù Yáma na kuna yù Mangilin nga Ikararuá nga initabbá na ngaw kuna. Á jinok ni Apu Kesu yù Mangilin nga Ikararuá ta umay nikami nga sinudduán na. Á yáyù nga masingan naw ánna maginná naw kunangan yawe nga akkuám mi, megapu sù pakáwayyá nayù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Wáwwagi, ari gemma si Patul Dabid yù minay ta lángì, nu ari galâ si Apu Kesu Kiristu. Ngam kinagi ni Patul Dabid, ‘Si Apu Namarò, kinagi na sù Yápù, “E ka bì magitubang ta jiwanák ku, nga pagitubangán nayù maráyaw, ");
INSERT INTO att_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","áddè ta arák ku pangappù sù ira nga malussaw nikaw,” kun ni Patul Dabid.’ ");
INSERT INTO att_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Á sikayu ngámin nga wáwwagi mi nga ginaká ni Israel, mánnámmuán naw laguk ta si Apu Kesu nga inipepátà naw ta kurù, aggina yù sinullà ni Namarò ta Yápu tam nga MakKiristu nga mammaguray.” ");
INSERT INTO att_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Á ta pakaginná nayù ira tatolay karannian, napábbaw ira. Á kinagi ra kári Eduru ánna yù ira kábulun na, “Wáwwagi, anni laguk yù akkuám mi?” ");
INSERT INTO att_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Á kinagi ni Eduru nira, “Mabbabáwi kayu nga katággitádday ta liwiliwâ na. Á mapparigù kayu megapu sù pakáwayyá nayù ngágan ni Apu Kesu Kiristu, tapè ipakánnámmu naw yù pangikatalà naw ánna pakiyápu naw kâ Apu Kesu Kiristu. Á pakomán na kayu sù liwiliwâ naw, ánna iyawâ na gapay nikayu yù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ta kinagi na ngaw ta aggira ngámin nga agálán na yù pangiyawatán na sù initabbá na. Mesipà kayu gapay ánna yù ira ánâ naw ánna ngámin yù ira tatolay ta dabbuno nga magginná ta pagágál ni Apu Namarò ta manguruk kuna,” kun ni Eduru nira. ");
INSERT INTO att_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Á aru paga yù kinagi ni Eduru nira. Á sinabarangán na ira, á kinagi na, “Ari kayu mepattádday sù ira narákè, tapè ari kayu mekanakanâ sù liwiliwâ da nga ipamanunnù ni Apu nira,” kun na. ");
INSERT INTO att_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Á aru sù ira nga nakaginná yù nanguruk sù kinagi ni Eduru. Á nakirigù ira, á talluribu yù ira tatolay nga nelannà sù ira manguruk. ");
INSERT INTO att_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Á naggagammung ira ta kággággaw nga maggigiámmu sù ituddu nayù ira sinudduán ni Apu, ánna makkaká-ubobuk ira ta meyannung sù napiá nga bilin ni Namarò. Á nakkakálálláng ira nga kun na tangapamiliá. Á giddigidduá ra yù pán nga kinád da ta panaddamád da ta pate ni Apu Kesu, ta pakimore ra kâ Apu Namarò, ánna nakimállà ira kuna. ");
INSERT INTO att_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Á aru yù ira makapállâ nga pinagaddátu nayù ira sinudduán ni Apu Kesu. Á yáyù nga napállâ yù ira ngámin nga tatolay. ");
INSERT INTO att_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Á ngámin ira nga manguruk, nattatádday ira ta nonò da, á nakkakásipà ira sù ngámin nga kukuá ra. ");
INSERT INTO att_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Á iniláku ra yù dabbud da ánna kukuá ra, á inisinek da yù nallakuád da sù ira ngámin nga manguruk ta meyannung sù awágad da. ");
INSERT INTO att_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Á ta kággággaw naggagammung ira nga nakimállà kâ Namarò sù mangilin nga kapilliá. Á minay ira kiminán sù bale ra ánna nakkakásipà ira ta kanad da, á nagayáyâ ira. ");
INSERT INTO att_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Á naddáyaw ira kâ Apu Namarò. Á ngámin yù ira katangeliád da, mássiki yù ira nga ari manguruk, nakimorayád da yù ira nga manguruk. Á kággággaw linnapán na ira ni Namarò sù ira bagu nga mangikatalà kuna. ");
INSERT INTO att_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Á ta pannarek na bilák ta púgák, nga negagángay nga oras nga pakimállà nayù ira Kudio, nappulù di Eduru kâ Kuan nga minay sù mangilin nga kapilliá, tapè makimállà ira. ");
INSERT INTO att_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pakáranni ra ta puertá nayù kapilliá nga mangngágan ta Kakástán nga Puertá, naratang da yù laláki nga pilay yù nakeyanatán na. Á ta kággággaw initotoli ra yù pilay tapè makilimù sù ira nga mattatallung sù kapilliá. ");
INSERT INTO att_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pakasingan nayù pilay kári Eduru kâ Kuan, nakilimù nira gapay. ");
INSERT INTO att_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Á inni-innad di Eduru, á kinagi ra kuna, “Innam kami,” kud da. ");
INSERT INTO att_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Á sinángngák na ira, ta iniddagán na yù iyawâ da kuna. ");
INSERT INTO att_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ngam kinagi ni Eduru kuna, “Awán kami ta kuártu, ngam ajjan yù awayyá mi nga mangabbák nikaw megapu sù pakáwayyá ni Apu Kesu Kiristu nga taga Nasaret. Gumikkáng ka laguk, tapè mallakák ka.” ");
INSERT INTO att_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Á sinangngalán ni Eduru yù limá na nga jiwanán, tapè pagikkangan na. Á dagarágâ nga nassikan yù takki na. ");
INSERT INTO att_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Á nikáddagâ na lâ gimikkáng. Á nepulù nira nga simillung sù mangilin nga kapilliá, nga nallakalakák nga nakkassakassú, ánna naddáyaw kâ Namarò. ");
INSERT INTO att_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Á ngámin nga tatolay, nasingad da yù tolay nga nallakalakák ánna naddáyaw kâ Namarò. ");
INSERT INTO att_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Á natákkilalád da ta aggina yù ngaw nagitubang nga minákkilimù sù puertá nga Kakástán. Á nepallà yù kapállâ da sù nesimmu kuna. ");
INSERT INTO att_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Á ta pakikering nayù ngaw pilay paga kári Eduru kâ Kuan ta balkon nayù kapilliá nga mangngágan ta balkon ni Patul Solomon, minay yù ira ngámin nga tatolay nga makkarakarerá nga magarimummung nira ta balkon, ta nerallà yù kapállâ da. ");
INSERT INTO att_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Á pakasingan ni Eduru ta napállâ yù ira tatolay, kinagi na nira, “Sikayu nga kábuluk ku nga ginaká ni Israel, ngattá, ta napállâ kayu gapu ta makalakák yù ngaw pilay? Ngattá, ta dúlangán naw kami? Kagian naw panò ta sikami yù nammapiá ánna namalakák sawe tolay, megapu sù ámmagaddátu mi onu piá mi? ");
INSERT INTO att_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ari gemma sikami yù mappagaddátu, nu ari galâ si Namarò nga Yápu di Abrakam kári Isak kâ Akup, ánna ngámin nga naggaká nittam. Á pinalakák ni Namarò yawe tolay, tapè meparáyaw si Apu Kesu nga Anâ na. Ngam sikayu, ginápù naw si Apu Kesu, á inikeká naw ta arubáng ni Gubinador Pilatto nga awán ta liwâ na. Á manakì kayu kuna. Á mássiki nu inikáyâ ni Pilatto nga palubbángan, ngam ari makatubáng sù ure naw. ");
INSERT INTO att_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sinájjián naw yù kuruk nga napiá nga mangilin, nga awán ta liwâ na, á kinagi naw kâ Pilatto ta palubbángan na yù namapátay. ");
INSERT INTO att_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Á pinapáte naw yù manotolay. Ngam pinaginnanole ni Namarò, á sikami yù massistígu ta kuruk yian, ta nasingam mi. ");
INSERT INTO att_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Á yawe tolay, inikatalà na si Apu Kesu. Á megapu sù pakáwayyá ni Apu Kesu, nammapiángin ánna nasikanin. Aggina yù ngaw pilay nga masingan naw ánna matákkilalán naw. Á megapu ta pangikatalà na kâ Apu Kesu nga Yápu mi, napammapiángin ta arubáng naw.” ");
INSERT INTO att_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Wáwwagi,” kun na paga ni Eduru sù ira tatolay, “ta pamapáte naw kâ Apu Kesu, ammù ta arán naw kánnámmuán ta aggina yù MakKiristu nga jinok ni Namarò saw. Á yù ira kátannangán naw, arád da gapay ammu. ");
INSERT INTO att_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ngam si Namarò, inibilin na sù ngaw ira ábbilinán na yù jigâ nga umay sù MakKiristu nga doban na ta umay saw. Á yáyù nga mapatuppál laguk yù kinagi nayù ira ábbilinán na sù kepátà ni Apu Kesu ta kurù. ");
INSERT INTO att_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mabbabáwi kayu laguk, á kurugan naw si Namarò ánna likuránán naw yù liwiliwâ naw. Á pakomán na kayu ni Namarò sù liwiliwâ naw, ");
INSERT INTO att_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ánna pabannáyán na yù nonò naw. Á doban na má sangaw sawe dabbuno si Apu Kesu, nga sinullà na ta mammaguray nittam. ");
INSERT INTO att_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ngam maggián lábbì ta arubáng ni Namarò ta lángì ta áddè ta dattál nayù ággaw nga sinullà ni Namarò nga panguli na ta dabbuno. Yáyù inibilin na ngaw ni Namarò sù ira ngaw ábbilinán na sù ira olu nga ággaw.” ");
INSERT INTO att_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Á kinagi na paga ni Eduru, “Ajjan yù kinagi na ngaw ni Moyses, nga yù ngaw ábbilinán ni Namarò, nga kun na, ‘Doban na sangaw ni Apu Namarò yù ábbilinán na, nga kagittá tam nga Kudio, ta kunnay sù paddok na nikán. Á tángngagan naw ngámin yù kagian na nikayu. ");
INSERT INTO att_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Á ngámin yù ira tatolay nga ari manguruk, ari iren mesipà sù ira tatole ni Namarò, nu ari galâ ta mesinná ira kâ Namarò ta áddè ta áddè.’ ");
INSERT INTO att_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yáyù kinagi na ngaw ni Moyses. Á di Samuel ánna yù ira ngaw ábbilinán ni Namarò nga naporián nga siminubbâ kuna, kinagi ra yù meyannung sù karannian nga ággaw. ");
INSERT INTO att_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Á sittam ngámin nga Kudio yù mesipà sù initarátu na ngaw ni Namarò sù ira ngaw naggaká nittam, gapu ta ánâ da ittam nga naporián. Ta yawe yù initarátu ni Namarò kâ Kákay Abrakam, nga kun na, ‘Mammapiá yù ággián nayù ira ngámin nga tatolay ta dabbuno, megapu sù tádday nga ginakám.’ ");
INSERT INTO att_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yáyù kinagi ni Namarò kâ Kákay Abrakam. Á yáyù gapu na nga sittam nga Kudio yù olu nga naddobán na kâ Apu Kesu nga Anâ na, tapè pammapián na yù ággiát tam, ánna ituddu na nittam ta likuránát tam yù narákè nga akka-akkuát tam, ánna palurotat tam yù ipakuá na nittam,” kun ni Eduru. ");
INSERT INTO att_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Á pagubobuk di Eduru kâ Kuan paga sù ira magaru nga tatolay, nappángè nira yù ira pári na Kudio ánna yù kapitán nayù ira nga magguárdiá sù mangilin nga kapilliá, ánna yù ira Sadusio. ");
INSERT INTO att_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Á napporay ira, gapu ta pangituddu ri Eduru ánna yù ira kábulun na sù ira tatolay. Ta inituddu ri Eduru ta naginnanolayin si Apu Kesu, á yáyù nga pakánnámmuád da ta kuruk nga maginnanolay gapay noka yù ira nga námmatay. ");
INSERT INTO att_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Á ginápù da laguk di Eduru kâ Kuan. Á gapu ta gabingin, pinukù da ira áddè ta pannawák. ");
INSERT INTO att_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ngam napakáru yù ira nga manguruk, gapu ta pagginná ra sù bilin ni Namarò nga kinagi ri Eduru nira. Á mággè límáribu yù ira lálláki nga manguruk. ");
INSERT INTO att_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Á ta pannawák, naggagammung ta Jerusalem yù ira Kudio nga mammaguray ánna yù ira giriámán, ánna yù ira mesturu nga mangituddu ta tunung da gapay. ");
INSERT INTO att_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ajjan gapay tán di Annas nga kotunán na pári, kári Kayapas, ánna si Kuan, si Alekanduru, ánna ngámin ira nga kanakanáyun nayù kotunán na pári. ");
INSERT INTO att_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Paggagammung da, inipágál da di Eduru ta meyarubáng nira, tapè bestigád da ira. Á iniyabbû da nira, “Sisaw yù paggapuán nayù pakáwayyá naw? Asinni naddok nikayu ta kingnguá naw?” kud da kári Eduru. ");
INSERT INTO att_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Á yù Mangilin nga Ikararuá, inipakánnámmu na kâ Eduru yù itabbák na, á kinagi ni Eduru laguk nira, “Sikayu nga mammaguray nikami, ánna sikayu nga karakalám mi, ");
INSERT INTO att_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nu bestigán naw kami megapu sù napiá nga kingnguá mi sù pilay kagabi ánna yù nipammapiá mi kuna, ");
INSERT INTO att_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","á mánnámmuán naw laguk, ánna yù ira ngámin nga kagittá tam nga ginaká ni Israel, ta nammapiángin yù tolay nga manáddak sawe arubáng naw megapu sù pakáwayyá ánna ámmagaddátu ni Apu Kesu Kiristu nga taga Nasaret. Aggina yù inipátà naw ta kurù, ngam pinaginnanole ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aggina yù meyárik ta batu nga inubobuk nayù ngaw ábbilinán ni Namarò sù dán nga netúrâ, nga batu nga nanakitán naw. Á sikayu yù meyárik sù ira minábbalay. Á yù iniwallián naw, aggina yù piníli ni Namarò, nga nabbáli ta panáddagán nayù bale na, nga keyarigán nayù ira ngámin nga mangikatalà kuna. ");
INSERT INTO att_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Á ta ngámin nga dabbuno, awán ta mangiyígù ta tatolay, nu ari galâ si Apu Kesu Kiristu. Awán ta tanakuán nga mangiyígù nittam.” ");
INSERT INTO att_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Á ta pakaginná nayù ira mammaguray sù initabbák di Eduru, napállâ ira, gapu ta pobare di Eduru nga ari naggigiámmu, ngam ari ira nappasirán nga nagubobuk nira. Á yáyù nga kánnámmuád da ta kábulun na ira ngaw ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Á awán ta ipaliwâ da kári Eduru kâ Kuan, ta nepanáddak gapay nira yù tolay nga pilay ngaw, nga nammapiángin. ");
INSERT INTO att_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Á pinalawád da ira laguk nayù ira mamestigá nira, tapè makkaká-ubobuk ira. ");
INSERT INTO att_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Á kinagi ra, “Anni yù akkuát tam sù ira tolay? Ta nappasingan yù pinagaddátu ra sù ira ngámin nga tatolay nga maggián ta Jerusalem, á awán ta awayyá tam gemma nga makkagi ta ari kuruk. ");
INSERT INTO att_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ngam ananássingat tam ira laguk, tapè ari ira má mangituddu ta meyannung kâ Kesu, ánna ari massamâ paga yù dámak nga meyannung kuna sù ira tatolay.” ");
INSERT INTO att_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Á kabalid da nakkaká-ubobuk, pinatallung da di Eduru, á inipugik da yù pangilayalayâ da ánna pangituddu ra ta meyannung kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngam simibbák nira di Eduru kâ Kuan, á kinagi ra, “Nononopan naw nu anni yù napiá ta ánninganán ni Namarò, nu kurugam mi yù kagian naw ánnè sù kagian ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ta awán ta awayyá mi nga mattukkâ nga makkagi sù nasingam mi ánna naginná mi nga kingnguá ni Apu Kesu ánna inituddu na,” kud da. ");
INSERT INTO att_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Á yù ira mammaguray, inananássing da má di Eduru. Á pinalubbáng da ira laguk, ta arád da nálek yù awayyá ra nga mamággáng nira, gapu ta naddayaráyaw yù ira ngámin nga tatolay kâ Namarò, megapu sù nesimmu sù ngaw pilay. ");
INSERT INTO att_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Á matturù ta appátapulu ngin yù dagun nayù tolay nga nammapiángin megapu sù pakáwayyá ri Eduru nga naggapu sù ámmagaddátu ni Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Á ta kapalubbáng di Eduru kâ Kuan, minay ira ta gián nayù ira kákkopud da, á kinagi ra nira yù ngámin nga kinagi nayù ira kátannangán nga pári ánna yù ira giriámán. ");
INSERT INTO att_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Á ta pakaginná nayù ira kákkopud da ta inananássing da ira, nattatádday ira nga nakimállà kâ Namarò, á kinagi ra: “Apu Namarò, sikaw yù mammaguray ánna sikaw yù namarò ta lángì ánna dabbuno, bebay, ánna ngámin yù maggián nira. ");
INSERT INTO att_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Á si Patul Dabid, nga yù ngaw naggaká nikami nga masserbi nikaw, kinagi na yù bilim mu nga nipakagi nayù Mangilin nga Ikararuá kuna. Á ajjan nga netúrâ yù kinagi na ngaw, nga kunniaw: ‘Yù ira nga ari Kudio nga mammaguray ta dabbuno, ngattá, ta mapporay ira kâ Namarò? Á yù ira Kudio, ngattá, ta potuád da si Namarò! ");
INSERT INTO att_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mattatádday yù ira patul ánna yù ira ngámin nga mammaguray ta dabbuno, tapè igagánge ra yù pakikontará ra kári Namarò ánna yù MakKiristu nga sinullà na ta mammaguray.’ ");
INSERT INTO att_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Apu Namarò, napalurokin kunangane yù kinagi na ngaw ni Patul Dabid, ta nepaggagammung ngaw gemma sawe ili na Jerusalem yù ira kagittá mi nga ginaká ni Israel ánna yù ira ngámin nga ari Kudio gapay, kári Patul Erodo kâ Gubinador Pilatto. Á nattatádday ira tapè igagánge ra nu kunnasi yù ámmapáte ra sù mangilin nga Anâ mu nga masserbi nikaw. ");
INSERT INTO att_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Á kingnguá ra yù ngámin nga dán nga sinalákkuruk mu ngaw, megapu sù pakáwayyám ánna urem. ");
INSERT INTO att_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Apu, naginnám yù pangananássing da nikami. Á pataggatam mu bì yù nonò mi ngámin nga masserbi nikaw, tapè ari kami maganássing nga mangilayalayâ sù bilim mu nga meyannung kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pammapiám mu yù ira máttakì ánna ipasingam mu yù pagaddatuam mu nga makapállâ, megapu sù pakáwayyá ni Apu Kesu, nga mangilin nga Anâ mu nga masserbi nikaw.” ");
INSERT INTO att_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Á kabalid da nakimállà, nagguyu yù balay nga naggagammungád da. Á minay yù Mangilin nga Ikararuá sù ira ngámin. Á ari ira maganássing nga mangilayalayâ sù bilin ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Á yù ira ngámin nga manguruk, nattatádday ira ta nonò da ánna ayâ da. Á awán nira ta nakikkì, nga makkagi ta kukuá na lápay yù ngámin nga kukuá na, ngam pinattatádde ra yù ngámin nga kukuá ra, tapè makkakásipà ira. ");
INSERT INTO att_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Á yù ira minángngilayalayâ, naláppà ira nga ari nattukkâ nga makkagi ta naginnanolayin si Apu Kesu, nga kuruk nga matolay mángin. Á nepallà yù pangikállà ni Namarò sù ira ngámin nga manguruk. ");
INSERT INTO att_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Á awán nira ta magáwák, gapu ta yù ira nga ajjan kuá na nga dabbun ánna balay, iniláku ra nga katággitádday, ");
INSERT INTO att_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","á inipaggiwâ da yù nallakuád da sù ira minángngilayalayâ, tapè aggira mangisinek ta kuártu sù ira magáwák ta meyannung ta awágad da. ");
INSERT INTO att_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Á ajjan si Kusè, nga ginaká ni Libi nga taga Sipro, nga iningágan nayù ira minángngilayalayâ ta Bernabe. Á yù kebalinán na “Bernabe” yù minánnabarang. ");
INSERT INTO att_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Á iniláku ni Kusè yù dabbun na, á inipaggiwâ na yù pagá na sù ira minángngilayalayâ. ");
INSERT INTO att_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Á naggián gapay tán di Ananiâ kâ Sapira nga atáwa na. Á iniláku ra gapay yù dabbud da. ");
INSERT INTO att_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Á nagittá yù nonò da ta pakappiád da yù káruán nga nallakuád da, á inituluk ni Ananiâ yù káruán nga inipe na ta arubáng nayù ira minángngilayalayâ. Ngam inilímak na yù pinakappiád da. ");
INSERT INTO att_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Á kinagi ni Eduru, “Ananiâ, ngattá, ta initulù mu yù nonò mu kâ Satanas? Ngattá, ta passiriám mu yù Mangilin nga Ikararuá? Ta kinagim ta iniyawâ mu ngámin yù nallakuám mu ta dabbun, nga arám mu inipaggiwâ, ngam initágum yù káruán. ");
INSERT INTO att_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Á nu arám mu iláku, kukuám gemma lâ. Á pallákum, maguray ka lággapay sù nallakuám mu. Ngattá, ta ninononò mu yù massiri? Ari gemma tolay yù passiriám mu, nu ari gabba galâ si Namarò.” ");
INSERT INTO att_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Á pakaginná ni Ananiâ karannian, nikáddagâ lâ natombá nga natay. Á yù ira ngámin nga nakarámak sù nesimmu kuna, nepallà yù assing da. ");
INSERT INTO att_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Á yù ira bábbagitolay, gimikkáng ira, á ed da binungun yù natay. Á nipáno ra, á ed da initanam. ");
INSERT INTO att_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Á manganánnuán, pappasá na tallu nga oras, limibbè gapay si Sapira, ngam arán na ammu ta natayin yù atáwa na. ");
INSERT INTO att_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Á kinagi ni Eduru kuna, “Kagiam mu bì nikán nu iniyawâ naw ngámin nga nallakuán naw ta dabbun naw.” Á kinagi nayù babay, “Wan, ngámin.” ");
INSERT INTO att_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Á kinagi ni Eduru kuna, “Ngattá ta naggittá yù nonò naw kâ atáwam nga mamaraparubá nga mangilogò sù Ikararuá ni Apu Namarò? Ginnám mu! Manolingin yù ira nga nangitanam sù atáwam, á ed da ka gapay apan,” kun na. ");
INSERT INTO att_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Á dagarágâ nga natombá yù babay ta arubáng ni Eduru nga natay. Á tallung nayù ira bábbagitolay, naratang da yù pate na, á inipáno ra gapay, á initanam da ta taging na atáwa na. ");
INSERT INTO att_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Á ngámin ira nga manguruk kâ Apu Kesu ánna ngámin ira nga nakarámak sù nesimmu, nepallà yù assing da. ");
INSERT INTO att_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Á yù ira minángngilayalayâ, pinagaddátu ra yù aru nga makapállâ sù ira tatolay ta Jerusalem. Á yù ira ngámin nga manguruk kâ Apu, sigídá nga naggagammung ira, ta kunnay sù kustombare ra, sù mangilin nga kapilliá, sù balkon ni Patul Solomon. ");
INSERT INTO att_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Á ngámin yù ira ari manguruk, nasingad da ta napiá nga tatolay yù ira manguruk kâ Apu ánna nakimorayád da ira, ngam naganássing ira nga metádday sù ira manguruk. ");
INSERT INTO att_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Á nalannalannapán paga yù ira manguruk ta magaru nga lálláki ánna bábbay nga manguruk kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Á gapu ta pamagaddátu nayù ira minángngilayalayâ, iniyánge nayù ira tatolay yù ira máttakì ta kalsáda, nga pinagiddá ra ta katri ra ánna dapad da, tapè malirumán ira sù alinu ni Eduru ta pattalebák na nira. ");
INSERT INTO att_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Á yù ira magaru nga naggapu ta ngámin nga barrabárriu na Jerusalem, iniyánge ra yù ira máttakì ánna yù ira nagunagán na anitu. Á nammapiá ira ngámin. ");
INSERT INTO att_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Á yù kotunán na pári ánna yù ira ngámin nga kábulun na nga Sadusio, nalussaw ira sù ira minángngilayalayâ. Á nerallà yù passil da nira. ");
INSERT INTO att_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Á ginápù da ira, á pinukù da ira ta karsel. ");
INSERT INTO att_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngam ta tangngá na gabi, minay yù daroban ni Namarò, á binukatán na yù puertá nayù karsel, á inilawán na yù ira minángngilayalayâ. Á kinagi na nira, ");
INSERT INTO att_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Sangaw nu pannawák, umay kayu ta mangilin nga kapilliá, á ilayalayâ naw sù ira ngámin nga tatolay yù meyannung sù awayyá ra nga mesipà sù áttole ni Namarò nga awán ta áddè na,” kun na nira. ");
INSERT INTO att_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Á pakaginná ri Eduru sù kinagi nayù daroban ni Namarò, kinuruk da. Á ta pannawák, minay ira sù mangilin nga kapilliá nga mangituddu sù ira tatolay. Á manganánnuán, naggagammung yù kotunán na pári ánna yù ira kábulun na sù mangilin nga kapilliá, á inipágál da laguk yù ira karakalán na Kudio. Á jinok da yù ira magguárdiá ta ed da apan yù ira minángngilayalayâ nga pinukù da ta karsel, tapè iyánge ra ira nga meyarubáng nira. ");
INSERT INTO att_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ngam labbè nayù ira magguárdiá ta karsel, awán ira tán. Á nanoli ira sù ira minámmaguray, á kinagi ra nira, ");
INSERT INTO att_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Labbè mi ta karsel, netúsi ta napiá yù puertá na, á naggián paga yù ira magguárdiá ta puertá, ngam pabbukâ mi, awán ta tolay ta unak.” ");
INSERT INTO att_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Á yù kapitán nayù ira magguárdiá ta mangilin nga kapilliá ánna yù ira kátannangán na pári, pakaginná ra ta awán yù ira nepukù ta karsel, nakalalang ira ánna nononopad da nu anni yù nesimmu sù ira minángngilayalayâ. ");
INSERT INTO att_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Á minay laguk yù tádday nga tolay, á kinagi na nira, “Yù ira tatolay nga pinukù naw, nasingak ku ira gangù ta kapilliá nga mangituddu sù ira tatolay.” ");
INSERT INTO att_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Á minay laguk di kapitán ánna yù ira magguárdiá, á inâ da yù ira minángngilayalayâ, á inilabbè da ira ta ámmanunnután, ngam arád da ira pinuersá, gapu ta ikássing da yù ira tatolay nga tudduád di Eduru, marakè payangad da ira ta batu. ");
INSERT INTO att_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Á pangiyánge ra nira, iniyarubáng da ira sù ira minámmanunnù. Á binestigá na ira nayù kotunán na pári. ");
INSERT INTO att_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Á kinagi na, “Sinaddánám mi kayu ta napiá ta ari kayu bulubugá mangituddu ta meyannung sù tolay nga tuttulan naw, ngam pinassamâ naw yù ituddu na ta ngámin nga tatolay ta Jerusalem! Á ngattá, ta ipaliwâ naw paga nikami yù pate na!” kun nayù kotunán nga pári. ");
INSERT INTO att_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ngam simibbák di Eduru ánna yù ira kábulun na, á kinagi ra, “Máwák nga kurugam mi yù taddán ni Apu Namarò ánnè sù taddán na tolay. ");
INSERT INTO att_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Á si Namarò, nga pakiyápuán nayù ira naggaká nittam, pinaginnanole na si Apu Kesu nga pinapáte naw, nga inipepátà naw ta kurù. ");
INSERT INTO att_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Á inâ ni Namarò ta lángì, á pinagitubang na ta jiwanán na, tapè aggina yù mammaguray ánna mangiyígù ta tatolay. Á yáyù nga ajjan yù awayyá tam nga ginaká ni Israel nga mabbabáwi ta liwiliwâ tam, tapè pakomán ni Namarò ittam. ");
INSERT INTO att_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Á sikami yù makkagi ta kuruk ngámin danniaw. Á yù Mangilin nga Ikararuá, nga iniyawâ ni Namarò nikami ánna yù ira ngámin nga manguruk kuna, aggina gapay yù mangipakánnámmu ta kukurugán.” ");
INSERT INTO att_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Á pakaginná nayù ira minámmaguray sù kinagi di Eduru, napporay ira, á gustu ra nga papatáyan yù ira minángngilayalayâ. ");
INSERT INTO att_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngam ajjan tán yù tádday nga Parisio nga mangngágan ta Gamaliel, nga mangituddu ta tunung na Kudio, á aggina yù pakimorayán na ngámin nga tatolay. Á gimikkáng si Gamaliel, á pinalawán na lábbì ta manganánnuán yù ira minángngilayalayâ. ");
INSERT INTO att_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Á kabalid da namalawán nira, kinagi ni Gamaliel sù ira kábulun na nga minámmaguray, “Wáwwagì, nga ginaká ni Israel, magimuguk ittam, á nononopat tam ta napiá yù akkuát tam karanniaw nga tatolay. ");
INSERT INTO att_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ta manonò ku yù ngaw Teras, nga nappeddaráyaw, á mággè appátagatù yù ira siminuttul kuna. Ngam napapátay si Teras, á newarawarâ ngámin yù ira nga siminuttul kuna, á awán ta nabbalinád da. ");
INSERT INTO att_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Á siminubbâ yù ngaw Kudas nga taga Galilia, nga jimittál sù pangilistá nayù ira mammaguray sù ira ngámin nga tatolay ta áppatulán. Á aru gapay yù ira tatolay nga pinatuttul na ta baggi na. Ngam natay gapay si Kudas, á newarawarâ gapay yù ira siminuttul kuna. ");
INSERT INTO att_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Á yáyù nga kagiak ku nikayu, wáwwagì, ta paguráyát tam lábbì yù ira minángngilayalayâ. Arát tam ira akkuán, tanu tolay yù paggapuán nayù ituddu ra, á mattukkâ sangaw, á yáyù áddè na. ");
INSERT INTO att_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngam nu si Namarò yù paggapuán na, ari ittam makatubáng. Paguráyát tam ira laguk, marakè matákál tam sangaw ta si Namarò galâ yù pakikontarát tam,” kun ni Gamaliel nira. Á gininná ra yù kinagi na. ");
INSERT INTO att_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Á kabalin na nanabarang ni Gamaliel sù ira kábulun na, inipágál da yù ira minángngilayalayâ. Á nipabaddù da ira, mássiki nu awán ta liwâ da. Á inipugik da má nira yù pangituddu ra ta meyannung kâ Apu Kesu. Á pinalubbáng da ira. ");
INSERT INTO att_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Á nánaw laguk yù ira minángngilayalayâ ta ámmanunnután. Á nagayáyâ ira gapu ta ammu ra ta inikatalà ni Namarò nira yù pangituddu ra sù bilin na ánna yù pangiyangngà da ta panigirigâ nayù ira tatolay nira megapu sù panguruk da kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Á kággággaw, minay ira sù mangilin nga kapilliá ánna ta gibbalayán nayù ira tatolay, tapè ituddu ra ánna ilayalayâ da ta si Apu Kesu yù MakKiristu nga sinullà ni Namarò ta mammaguray ta dabbuno. ");
INSERT INTO att_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Á ta kággággaw, nalannapán yù ira manguruk kâ Apu Kesu. Á yù ira Kudio nga naggapu ta arayyu, nga Gareko yù ággubobuk da, netádday ira sù ira Kudio nga taga Jerusalem, nga magubobuk ta Kebru. Á ta pangisinek nayù ira minángngilayalayâ ta máwák nayù ira tatolay, naddagaragim yù ira Kudio nga Gareko yù ággubobuk da, gapu ta nakúráng yù neyawâ sù ira kábulud da nga bábbay nga bálu. ");
INSERT INTO att_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Á pakarámak nayù ira mapulu duá nga minángngilayalayâ, pinaggagammung da yù ira manguruk, á kinagi ra nira, “Arám mi nakuan iginnà yù pangilayalayâ mi ta bilin ni Namarò, tapè matángngák mi lâ yù pangisinek mi ta pakkatole naw. ");
INSERT INTO att_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wáwwagi, mappíli kayu laguk ta pitu nikayu nga lálláki nga pangikatalakán, nga tumulù sù Mangilin nga Ikararuá ánna napiá yù nonò da, tapè aggira yù mangisinek ta máwák na tolay. ");
INSERT INTO att_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ngam sikami, tángngagam mi galâ yù ipakimállà mi kâ Apu ánna yù pangilayalayâ mi sù bilin ni Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Á nagayáyâ yù ira magaru nga manguruk megapu sù kinagi ra. Á danniaw ira yù piníli ra: si Esteban, nga mapasigaggà yù ángnguruk na kâ Apu Kesu ánna tumulù sù Mangilin nga Ikararuá. Á si Pilippi, si Porokoro, si Nikanor, si Timon, si Parmenas, á si Nikolas nga taga Antokia nga nakKudiongin. ");
INSERT INTO att_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Á iniyarubáng da ira sù ira mapulu duá nga minángngilayalayâ, tapè ipakimállà da ira kâ Namarò. Á ta pakimállà nayù ira minángngilayalayâ, inipotud da yù limá ra ta ulu nayù ira katággitádday nga napíli, nga panákkilalán ta aggira yù ira natullà nga manaron ánna mangisinek ta máwák na tolay. ");
INSERT INTO att_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Á yáyù nga nassamâ yù bilin ni Namarò. Á nalannapán ta aru yù ira manguruk ta ili na Jerusalem. Á nanguruk gapay kâ Apu Kesu yù aru nga pári ira nga Kudio. ");
INSERT INTO att_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Á si Esteban, aru yù ira pinagaddátu na nga makapállâ ta arubáng nayù ira tatolay ta Jerusalem megapu sù allà ni Namarò kuna, ta iniyawâ ni Namarò kuna yù ámmagaddátu na. ");
INSERT INTO att_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngam ajjan gapay ta Jerusalem yù ira Kudio nga makkakábulun ta ággagammungán nga mangngágan ta Kapilliá nayù ira Napalubbáng, nga taga Sirene ánna taga Alekandria. Á ajjan gapay yù ira nga taga Silisia ánna taga Asia. Á nattatádday ira nga minay nakikontará kâ Esteban, ánna naríri ira ta ubobuk na. ");
INSERT INTO att_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngam arád da náppù, gapu ta napiá yù itabbák ni Esteban megapu sù pangabbák nayù Mangilin nga Ikararuá kuna. ");
INSERT INTO att_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Á yáyù nga inagálád da yù ira lálláki nga sináddanád da ta kuártu, tapè massiri ira ta meyannung kâ Esteban. Á kinagi nayù ira massiri, “Naginná mi yù pakkagi ni Esteban ta narákè nga meyannung ta yù ngaw Moyses ánna si Namarò,” kud da. ");
INSERT INTO att_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Á yù ira massirisiri, pinappatapátu ra yù ira káruán nga tatolay, ánna yù ira giriámán na Kudio, ánna yù ira mesturu nga mangituddu ta tunung ni Moyses. Á inikáddagâ da lâ ginápù si Esteban, á iniyánge ra sù ira minámmanunnù. ");
INSERT INTO att_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Á minay yù ira nga sináddanád da ta kuártu, á nanáddak ira ta arubáng nayù ira minámmanunnù, tapè massistígu ira. Ngam massiri ira, á kinagi ra, “Yawe tolay, arán na tukkatan yù narákè nga kagian na nga meyannung sawe mangilin nga kapilliá ánna yù tunung ni Moyses. ");
INSERT INTO att_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Naginná mi yù kinagi na, nga umay sangaw si Kesu nga taga Nasaret, á darálan na yawe kapilliá, á patalián na yù kustombare tam nga inituddu ni Moyses sù ira naggaká nittam,” kud da. ");
INSERT INTO att_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Á yù ira minámmaguray nga nagitubang ta ámmanunnután, pakaginná ra sù kinagi nayù ira massiri, inimámmatád da si Esteban, á nasingad da yù mammang na nga maddalingáráng ta kun na mammang nayù daroban ni Namarò nga naggapu ta lángì. ");
INSERT INTO att_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Á yù kotunán na pári, pakaginná na ta pangikeká ra kâ Esteban, iniyabbû na kâ Esteban, “Kuruk panò yù ipangikeká ra nikaw?” ");
INSERT INTO att_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Á simibbák ni Esteban, á kinagi na nira, “Wáwwagi ánna giriámán, nononopan naw bì yù kingnguá ni Namarò megapu nittam nga Kudio. Ta gári, piníli ni Namarò si Kákay Abrakam, nga yù ngaw naggaká nittam. Á paggián ni Abrakam paga ta Mesopotamia, nga ari paga minay nakipaggián ta Karan, nappasingan si Namarò kuna nga maddalingáráng. ");
INSERT INTO att_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Á kinagi ni Namarò kuna, ‘Panawám mu yù ira kanakanáyum mu ánna yù lugár nga paggianám mu, á umay ka sù gián nga ipasingak ku nikaw sangaw.’ ");
INSERT INTO att_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Á nánaw laguk di Kákay Abrakam ta paggianád da sù ira kagittá ra nga taga Kaldia, á minay ira naggián ta dabbun na Karan. “Á keggá ri Kákay Abrakam paga ta Karan, natay si ammò na. Á iniyánge na ira laguk ni Namarò sawe dabbun nga paggianát tam. ");
INSERT INTO att_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Á arán na iniyawâ kâ Abrakam yawe dabbun, mássiki nu baddì lâ. Ngam initabbá ni Namarò ta iyawâ na yù dabbun noka kári Abrakam ánna yù ira ginaká na. Á ta pangitabbá ni Namarò kuna, awán paga ta anâ ni Kákay Abrakam. ");
INSERT INTO att_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Á kinagi ni Namarò gapay kuna, ‘Yù ira ginakám, umay ira noka makipaggián ta tanakuán nga dabbun. Á yù ira pakipaggianád da, aripanad da ira ánna jigirigátad da ira ta appátagatù nga ragun. ");
INSERT INTO att_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngam nu napasángin yù paggiád da túrin, panunnuták ku yù ira mangaripan nira. Á megapu sù panigirigâ ku sù ira mangaripan, palubbángak ku yù ira ginakám, á ipánò ira tapè umay ira makimoray nikán sawe dabbun,’ kun ni Namarò kâ Kákay Abrakam.” ");
INSERT INTO att_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Á kinagi ni Esteban paga, “Á pangitabbá ni Namarò kári Kákay Abrakam ánna yù ira ginaká na, inipakugì ni Namarò yù ira ánâ da nga lálláki ta panaddamád da ta pattarátu na nira. Á yáyù nga kinugì ni Abrakam si Isak nga anâ na sù mekawalu nga ággo nayù abbing, gapu ta yáyù kinagi ni Namarò kuna. Á kunnian gapay yù kingnguá ni Isak, ta kinugì na si Akup nga anâ na. Á kunnian gapay yù kingnguá ni Akup, ta kinugì na gapay yù ira mapulu duá nga ánâ na nga lálláki nga naggaká nittam. ");
INSERT INTO att_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Á yù ira ánâ ni Kákay Akup nga naggaká nittam, napassil ira kâ Kusè nga uriád da. Á iniláku ra si Kusè sù ira mangaripan kuna ta arayyu nga lugár na Egipto. Ngam nepulù si Namarò kâ Kusè. ");
INSERT INTO att_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Á inabbágán ni Namarò, á yáyù nga napiá lâ yù pabbalinán na ngámin nga jigâ ni Kusè. Á iniyawâ ni Namarò kuna yù napiá nga nonò na ánna inipakámmu na kuna yù mappíli ta napiá. Á ta keyarubáng ni Kusè kâ Paro nga patul ta Egipto, nagayáyâ si Paro kuna, á sinullà na ta gubinador, ánna pine na ta mammaguray ta ngámin nga áppatulán na, ánna inipataron na gapay kuna yù ngámin ira kábbale na ta palásiu na. ");
INSERT INTO att_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Á pammagure na ngaw ni Kusè ta Egipto, jimittál yù bisin ta ngámin nga lugár na Egipto ánna yù lugár na Kenan. Á narigirigâ ngámin yù ira tatolay. Á di Kákay Akup ánna yù ira ánâ na nga naggaká nittam, awán ta málek da nga kanad da. ");
INSERT INTO att_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ngam ta pakarámak ni Kákay Akup ta egga kanan ta Egipto, jinok na yù ira ánâ na ta umay ira mangâ ta kanad da. Yáyù lâ paga yù olu nga ánge ra ta Egipto. ");
INSERT INTO att_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Á ta mekaruá nga ánge nayù ira wáwwagi ni Kusè ta Egipto, inipakánnámmu ni Kusè yù baggi na nira. Á inipakánnámmu na gapay kâ Paro yù ira kanakanáyun na. ");
INSERT INTO att_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Á inipágál ni Kusè di Kákay Akup nga ammò na ánna ngámin nga kanakanáyun na ta umay ira ta Egipto. Pitupulu límá nga tatolay yù ira ngámin. ");
INSERT INTO att_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Á yáyù nga minay di Akup ta Egipto, á naggián ira ta Egipto ta áddè ta pate ra. Ta Egipto yù natayád di Kákay Akup ánna yù ira ngámin nga ánâ na nga naggaká nittam. ");
INSERT INTO att_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ngam nelabbè yù baggi ra ta Sekem nga naggianád da ngaw di Kákay Akup, á netanam ira ta Sekem sù ángngitanamán nga ginátáng na ngaw ni Kákay Abrakam sù ira ánâ ni Amor. ");
INSERT INTO att_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Á mággè nga jimittál yù ággaw nga sinullà ni Namarò nga pamapáno na nira ta Egipto, tapè ipetoli na ira sawe lugár tam ta kunnay sù initabbá na ngaw kâ Abrakam. Á gapu ta nabayák iren nga naggián túrin ta lugár na Egipto, minaru yù ira tatolay. ");
INSERT INTO att_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Á napatalián yù patul ta Egipto ta tanakuán nga patul, nga arán na ammu yù napiá nga kingnguá nayù ngaw Kusè. ");
INSERT INTO att_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Á arán na inikállà yù ngaw ira naggaká nittam. Inilogò na ira. Á pinuersá na ira ta tájjiád da yù ira ánâ da, tapè matay ira. ");
INSERT INTO att_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Á tán nga ággaw ngaw yù keyanâ ni Moyses. Á napiá nga abbing, á ayatán si Namarò kuna. Á inituttù di innò na ánna sinaronád da ta tallu nga bulán sù bale ra. ");
INSERT INTO att_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Á nu awánin ta awayyá ra nga mangituttù, napuersá ira nga nangipay ta lawán. Á nálek nayù babay nga anâ nayù patul, á jimmà na, nga pinataganatán na ta kun na anâ na. ");
INSERT INTO att_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","“Á naggigiámmu si Moyses ta ngámin nga ituddu nayù ira Egipto, á napiá ánna makáwayyá yù ággubu-ubobuk na ánna napiá ngámin yù akkuán na. ");
INSERT INTO att_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Á nu appátapulu yù dagun ni Moyses, nanonò na ta en na tullúnán yù ira kuruk nga wáwwagi na nga ginaká ni Israel. ");
INSERT INTO att_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Á naratang na yù tádday nga jigirigátan nayù Egipto. Á en na iniyígù yù kagittá na, á pinapáte na yù Egipto. ");
INSERT INTO att_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ta kagian ni Moyses ta kánnámmuán nayù ira kanakanáyun na ta aggina yù jinok ni Namarò ta mamalubbáng nira sù ira mangaripan nira. Ngam arád da nánnámmuán. ");
INSERT INTO att_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Á sù tádday ággaw, naratang na yù duá nga ginaká ni Israel nga maddamá, á gimmá na ira. ‘Wáwwagi,’ kun ni Moyses nira, ‘anni ipaddamá naw, ta mawwagi kayu gemma?’ kun na. ");
INSERT INTO att_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Á yù tolay nga iddâ na lâ nakiramá, inirubbâ na si Moyses, á kinagi na, ‘Asinni panò naddok nikaw ta mammaguray ánna mamanunnù nikami? ");
INSERT INTO att_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ipárik mà sù Egipto nga pinapátem kagabi?’ kun na. ");
INSERT INTO att_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Á pakaginná ni Moyses sù kinagi na, naganássing, ta ammu na ta neparámak yù pamapáte na sù Egipto. Á nattálaw, á minay nakipaggián ta dabbun na Midian. Paggián na tán, nangatáwa. Á tán nga lugár yù neyanakán nayù ira duá nga ánâ na nga lálláki. ");
INSERT INTO att_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Á naggián si Moyses ta Midian ta nabayák. Á pappasá na appátapulu ta dagun, ta panaron na ta ayám ta kalállammatán nga aranni ta puddul na Saynay, nappasingan si Namarò kuna, ta limittuák yù daroban na ta api sù alinnâ nga káyu nga maggatang nga ari makán na api. ");
INSERT INTO att_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Á napállâ si Moyses ta pakasingan na sù káyu nga naggatang, á jimikkì kuna, tapè imámmatán na ta napiá. Á naginná na yù ngárál ni Apu Namarò nga naggapu ta api, á kinagi ni Apu, ");
INSERT INTO att_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Sikán si Namarò, nga Yápu nayù ira naggaká nikaw, nga Yápu di Abrakam kári Isak kâ Akup.’ Á pakaginná ni Moyses, namippippik nga ari makeyangngà nga maningan. ");
INSERT INTO att_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Á kinagi ni Apu kuna, ‘Iriám mu yù sapátù mu, ta mangilin yù dabbun nga nanáddagám mu.’ ");
INSERT INTO att_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Á kabalin ni Moyses nangari ta sapátù na, á kinagi ni Apu kuna, ‘Masingak ku gemma yù karigirigâ nayù ira tatolè túrin ta Egipto, á maginnâ yù paggaráyad da. Á yáyù nga minulugakin, tapè iyígù ku ira. Arà! Umay ken laguk, ta dobat taka ta umay ka túrin ta Egipto,’ kun ni Namarò kuna. ");
INSERT INTO att_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Wáwwagi,” kun ni Esteban paga, “ta keggá ra ngaw nayù ira naggaká nittam ta Egipto, nanakitád da si Moyses. Ta kinagi ra ngaw kuna, ‘Asinni panò naddok nikaw ta mammaguray ánna mamanunnù nikami?’ Á si Moyses, aggina yù jinok ni Namarò nga mangiyígù ánna mammaguray nira, á inabbágán ni Namarò megapu sù daroban na nga nasingan ni Moyses sù káyu nga naggatang. ");
INSERT INTO att_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Á si Moyses yù nangituluk sù ira naggaká nittam ta páno ra ta Egipto, á aru yù pinagaddátu na nga makapállâ ta keggá ra paga ta Egipto, ánna pallakák da nga umay ta dammáng nayù bebay nga mangngágan ta Ujjojjin, ánna keggá ra gapay ta kalállammatán ta appátapulu nga dagun. ");
INSERT INTO att_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Á si Moyses yù nakkagi sù ira ngaw ginaká ni Israel, nga kun na, ‘Si Namarò, doban na noka nikayu yù ábbilinán na ta kunnay ta paddok na nikán, nga naggapu sù ira ginaká naw,’ kun na. ");
INSERT INTO att_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Á paggagammung nayù ira naggaká nittam ta kalállammatán, si Moyses yù kobobuk nayù daroban ni Namarò ta puddul na Saynay. Á si Moyses yù neddán sù bilin ni Namarò nga netúrâ, nga paggapuán nayù ákkatole na tolay ta áddè ta áddè, tapè aggina yù mangiyawâ nittam. ");
INSERT INTO att_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ngam yù ngaw ira naggaká nittam, nanakì ira nga manguruk kâ Moyses, á inipuerá ra, ta ikáyâ da manoli ta Egipto. ");
INSERT INTO att_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Á nakiubobuk yù ira tatolay kâ Aron, nga wagi ni Moyses ánna yù olu nga pári na Kudio, á kinagi ra kuna, ‘Mappadday ka laguk sù ira didios tam nga mangipulù nittam, tapè tuttulat tam ira, ta arát tam ammu yù nesimmu kâ Moyses nga nangituluk nittam ta páno tam ta Egipto,’ kud da. ");
INSERT INTO att_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Á pidde ra laguk yù sináddios nga kun na kígaw nga báka, nga kinagi ra ta yápu ra, á pinárti ra yù ira ayám da nga iniyátáng da kuna. Á nabbúyá ira gapu ta pagayáyâ da sù pidde ra. ");
INSERT INTO att_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Á yáyù nga napporay si Namarò nira, á nilikuránán na ira. Á pinaguráyán na ira, tapè maguru-uray ira lâ nga makimoray sù ira bituan ta lángì. Á kingnguá ra ta kunnay ta netúrâ sù libru nayù ira ábbilinán ni Namarò, nga kunniaw: ‘Sikayu nga ginaká ni Israel, ngattá, ta ari sikán yù nangiyátangán naw sù ira ayám naw, ta pangiyátáng naw ta kalállammatán ta appátapulu ta dagun? ");
INSERT INTO att_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ari sikán yù nakimorayán naw, nu ari galâ yù ira sináddios! Inakkâ naw nga inipulupulù yù paggianán nayù sináddios nga mangngágan ta Molok ánna yù sináddios nga pidde naw ta kun na bituan, nga mangngágan ta Repan. Aggira yù ira sináddios nga pidde naw nga pakimorayán naw, á namalittúkak kayu nira! Á yáyù liwâ naw, nga gapu na nga papanáwat takayu ta dabbun naw, á mánaw kayu nga umay túrin ta abbák na dabbun na Babilonia, á marigirigâ kayu tán.’ ");
INSERT INTO att_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wáwwagi,” kun ni Esteban, “ta keggá nayù ira ngaw naggaká nittam ta kalállammatán, egga nira yù balay nga ákkimorayád da kâ Namarò, ta naggián si Namarò nira. Á pidde ra ta bale na yù gámì ánna tabbì na ayám, ta kunnay sù inipasingan ni Namarò kâ Moyses. ");
INSERT INTO att_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Á bittáng da yù balay ni Namarò sù ira ginaká ra. Á ta pate ni Moyses, si Josiuwa yù táli na. Á inipulù da yù bale ni Namarò nira ta áddè ngaw tallung di Josiuwa sawe dabbun nga initabbá ni Namarò nittam. Á naratang da yù ira olu nga naggián saw, ngam pinapáno na nira ni Namarò, á iniyawâ na yù dabbud da sù ira ngaw naggaká nittam. Á naggián lâ paga yù bale ni Namarò sù ira naggaká nittam ta áddè ta pammagure na ngaw ni Patul Dabid. ");
INSERT INTO att_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Á ta keggá na ngaw ni Patul Dabid, ayatán si Namarò kuna. Á inikomá ni Patul Dabid kâ Namarò ta ipapadde na kuna yù bale na, nga pakimorayán nayù ginaká ni Akup sù Yápu ra. ");
INSERT INTO att_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngam arán na inanugù. Á si Patul Solomon, nga anâ ni Patul Dabid, aggina yù namadday ta bale ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ngam si Apu Namarò, ari gemma maggián ta balay nga pidde na tolay. Ta netúrâ yù ubobuk ni Apu Namarò, nga kinagi nayù ábbilinán na, nga kunniaw: ");
INSERT INTO att_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Yù lángì, kunnay lâ ta pagitubangák ku. Á yù dabbuno, kunnay lâ ta pangipotunák ku ta takkì. Egga panò yù paddayan naw nga paggianák ku? Awán! Egga panò yù paddayan naw nga pagibannagák ku? Awán! ");
INSERT INTO att_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ta sikán galâ yù nappadday ta lángì ánna dabbuno, ánna ngámin nga egga nira,’ kun ni Namarò.” ");
INSERT INTO att_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Á kinagi na laguk ni Esteban sù ira minámmanunnù ánna yù ira tatolay, “Sikayu, anningillâ yù kataggâ na ulu naw! Narákè yù nonò naw ánna kitul kayu, á arán naw tángngagan yù bilin ni Namarò. Naggigittá kayu sù ira ngaw naggaká nittam, ta makikontará kayu gapay sù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Egga panò yù tádday sù ira ngaw ábbilinán ni Namarò nga arád da jinigirigâ? Awán! Pinapáte ra yù ira ngámin ngaw nga nangilayalayâ ta umay ta dabbuno yù napiá nga Masserbi kâ Apu Namarò, nga MakKiristu. Á labbè na, sináttájjián naw ánna pinapáte naw. ");
INSERT INTO att_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Á sikayu yù iniddán nayù ira daroban ni Namarò ta tunung na. Ngam ari kayu manguruk!” Yáyù áddè nayù kinagi ni Esteban. ");
INSERT INTO att_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Á pakaginná nayù ira minámmanunnù sù kinagi ni Esteban, napporay ira, á nangngarangaringngì ira megapu sù nepallà nga pore ra. ");
INSERT INTO att_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngam si Esteban, ajjan nga nepulù kuna yù Mangilin nga Ikararuá, nga mangabbák kuna. Á sinánguk ni Esteban yù lángì, á nasingan na yù dalingáráng ni Namarò ánna si Apu Kesu nga makáwayyá nga manáddak ta jiwanán ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Á kinagi ni Esteban, “Innan nawè! Nabukatán yù lángì, á masingak ku yù Kaká na Ngámin na Tatolay nga manáddak ta jiwanán ni Apu Namarò,” kun na. ");
INSERT INTO att_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Á pakaginná nayù ira tatolay sù kinagi ni Esteban, lippà da laguk yù talingá ra, ánna nagaggay ira ta pore ra kâ Esteban. Á gikarakarerán ira nga minay naggápù kuna. ");
INSERT INTO att_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Á pinalawád da ta ili, á pinayapayáng da ta batu. Á yù ira nga namayáng kuna, iniriád da yù barawási ra nga inipatarod da sù bagitolay nga mangngágan ta Saulo. ");
INSERT INTO att_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Á pamayáng da kâ Esteban, nakimállà si Esteban kâ Apu, á kinagi na, “Apu Kesu, paddulotam mà,” kun na. ");
INSERT INTO att_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Á namalittúkak, ánna iniyássikan na yù ngárál na, á kinagi na, “Apu, arám mu lâ ibiláng nga liwâ da yawe akkuád da nikán,” kun na. Á yáyù lâ áddè na kinagi na, á natayin. ");
INSERT INTO att_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Á si Saulo, inanugù na yù pamapáte ra kâ Esteban, ta aggina yù manangngal ta barawási nayù ira namayáng kuna. Á sù ággo na pamapáte ra kâ Esteban, yáyù pamegapu ra manigirigâ sù ira ngámin nga manguruk kâ Apu Kesu nga naggián ta Jerusalem. Á nawwarawarâ yù ira manguruk ta purubinsia na Judiya ánna Samaria. Ngam yù ira mapulu duá nga minángngilayalayâ nga sinudduán ni Apu Kesu, naggián ira ta Jerusalem. ");
INSERT INTO att_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Á ajjan yù ira tatolay nga napasigaggà yù ángnguruk da kâ Apu, á pakarámak da ta pate ni Esteban, kinulukuletád da, á inâ da yù baggi na, á ed da initanam. ");
INSERT INTO att_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ngam si Saulo, jinigirigâ na ira ngámin nga manguruk kâ Apu Kesu. Simillung ta katággitádday nga bale ra, á inipagápù na yù ira nga lálláki ánna bábbay, á inipabáluk na ira. ");
INSERT INTO att_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Á yù ira manguruk nga nawwarawarâ ta arayyu nga lugár, minay ira nga nangilayalayâ sù bilin nga meyannung kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Pilippi yù tádday. Á páno ni Pilippi ta Jerusalem, minay ta ili sù purubinsia na Samaria, á inilayalayâ na nira si Apu Kesu Kiristu. ");
INSERT INTO att_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Á ngámin yù ira tatolay, sinángngák da ta napiá yù kinagi ni Pilippi ánna yù nasingad da nga pinagaddátu na. ");
INSERT INTO att_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Á aru yù ira anitu nga pinapáno ni Pilippi, nga nakkalli ta nasikan ta páno ra sù ira nagunagád da. Á aru gapay ira nga tatolay nga natay baggi ra ánna yù ira pilay gapay nga pinammapiá ni Pilippi. ");
INSERT INTO att_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Á yáyù nga magayáyâ yù ira ngámin nga tatolay ta ili. ");
INSERT INTO att_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Á naggián gapay ta ili yù laláki nga mangngágan ta Simon, nga minágganánitu nga mamappállâ sù ira tatolay ta Samaria sù angnga-angnguá na nga májik. Mappeddaráyaw, á kinagi na nira ta aggina yù makáwayyá. ");
INSERT INTO att_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Á ngámin ira nga maríku ánna pobare, sinángngák da si Simon ta napiá. Á kud da, “Ajjan támma kuna yù pakapangnguá ni Namarò nga mamagaddátu,” kud da. ");
INSERT INTO att_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Á sinángngák da ta napiá, gapu ta nabayágin nga minássalamangká ta arubáng da, á napállâ ira. ");
INSERT INTO att_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngam ta panguruk da sù napiá nga dámak nga kinagi ni Pilippi nga meyannung sù pammagure ni Namarò ánna yù pakáwayyá ni Apu Kesu Kiristu, nakirigù ira laguk, aggira nga lálláki ánna bábbay. ");
INSERT INTO att_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Á mássiki si Simon, nanguruk gapay ánna nakirigù. Á nepulupulù kâ Pilippi. Á napállâ si Simon, nga nepallà yù kapállâ na ta pakasingan na ta aru nga pinagaddátu ni Pilippi. ");
INSERT INTO att_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Á yù ira minángngilayalayâ nga naggián ta Jerusalem, pakarámak da ta manguruk yù ira tatolay ta Samaria ta bilin ni Namarò, jinok da di Eduru kâ Kuan ta umay nira. ");
INSERT INTO att_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Á tappì di Eduru ta Samaria, nakimállà ira kâ Namarò ta ipepulù na sù ira bagu nga manguruk yù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ta arán ni Namarò paga jinok yù Mangilin nga Ikararuá ta umay nira, ngam narigù ira lâ nga netádday kâ Apu Kesu. ");
INSERT INTO att_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Á di Eduru, sinámmì da ira, á jimittál nga naggián nira yù Mangilin nga Ikararuá. ");
INSERT INTO att_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Á nasingan ni Simon ta minay naggián sù ira manguruk yù Mangilin nga Ikararuá ta panámmì di Eduru nira. Á en na laguk iniyalawâ kâ Eduru yù kuártu, ");
INSERT INTO att_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ta kinagi na kuna, “Iddám mà gapay ta pakáwayyâ nga kunnay sù pakáwayyám, tapè umay yù Mangilin nga Ikararuá nga maggián sù ira ngámin nga támmitak ku gapay,” kun na. ");
INSERT INTO att_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Á kinagi ni Eduru kuna, “Mokum ka ánna yù kuártum, nu kagiam mu ta magátáng yù iyawâ na lâ ni Namarò ta ikáyâ na nga pangiyawatán! ");
INSERT INTO att_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ari ka meballay karanniawe nga akkuám mi, gapu ta ari pareku nga napiá yù nonò mu ta ánninganán ni Apu Namarò. ");
INSERT INTO att_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ibabáwim laguk yù narákè nga nonò mu, á makimállà ka kâ Apu ta abernu pakomán na ka ta narákè nga nononotam mu. ");
INSERT INTO att_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Matákál ku ta nepallà yù passil mu, ánna ari ka paga napalubbáng ta passerbim ta narákè nga karagatám mu,” kun ni Eduru kuna. ");
INSERT INTO att_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Á simibbák si Simon, á kinagi na, “Ipakimállà mà bì kâ Apu ta ari bulubugá mesimmu nikán yù kinagim.” ");
INSERT INTO att_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Á kabalid di Eduru nangilayalayâ sù bilin ni Namarò tán, nánaw ira, ta manoli ira ta Jerusalem. Á ta ánge ra, inilayalayâ da yù napiá nga dámak nga meyannung kâ Apu Kesu ta aru nga babálay nga sinalebarád da ta purubinsia na Samaria. ");
INSERT INTO att_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Á ajjan yù daroban ni Apu Namarò nga limittuák, á kinagi na kâ Pilippi, “Umay ka ta abagátán, sù dálan nga naggapu ta Jerusalem nga mappángè túrin ta Gasa.” Á yù dálan nga kinagi na, talebarán na yù namagá nga gián ta kalállammatán. ");
INSERT INTO att_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Á naggagannuâ si Pilippi, á nánaw. Á pakáddè na sù dálan, naratang na yù tolay nga nattakay ta kalesá nga naggapu ta Jerusalem. Aggina yù makáwayyá nga laláki nga taga Etiopia, nga minángngikárgu nga masserbi kâ Kandase nga rená nga mammaguray ta áppatulán na Etiopia. Á yù tolay yù manaron ta ngámin nga kuártu ánna kukuá nayù rená. Á minay ta Jerusalem, tapè makimoray kâ Namarò. ");
INSERT INTO att_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Á ta kabalin na nakimoray, nánaw ta Jerusalem, á manolingin ta Etiopia. Á pattake na ta kalesá na, bibbiran na yù libru nga initúrâ na ngaw ni Isaya, nga yù ngaw ábbilinán ni Namarò. ");
INSERT INTO att_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Á pakaratang ni Pilippi sù kalesá, kinagi nayù Mangilin nga Ikararuá kuna, “Dukkì ka táne kalesá ta mepulù ka kuna.” ");
INSERT INTO att_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Á sinimmâ ni Pilippi yù kalesá, á mináranni kuna. Á naginná na laguk yù tolay nga mabbibbik sù libru ni Isaya nga yù ngaw ábbilinán ni Namarò. Á iniyabbû ni Pilippi kuna, “Kánnámmuám mu yù bibbiram mu?” ");
INSERT INTO att_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Á simibbák yù tolay, á kinagi na kâ Pilippi, “Kunnasi laguk pakánnámmù, ta awán gemma ta tolay nga mangituddu nikán?” Á inapà na si Pilippi ta mepattakay kuna. Á nappittà si Pilippi nga nepaggitubang kuna. ");
INSERT INTO att_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Á yawe yù bilin nga binibbik nayù laláki sù libru: “Aggina yù meyárik ta karneru nga iyánge ra ta áppártián. Á magimammà nga kunnay ta kígaw na karneru nu usitád da yù duddù na, ta ari bulubugá makkituk. ");
INSERT INTO att_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nepasiránán ta arubáng nayù ira tatolay, á ari kustu yù pamestigá ra kuna, ngam iddâ da lâ pinapátay nga awán ta liwâ na. Á awán ta makkagi ta meyannung sù ira ginaká na, ta nári ngin yù inángà na sù dabbuno.” ");
INSERT INTO att_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kabalin na nabbibbik, iniyabbû nayù tolay kâ Pilippi, “Asinni yù ubobugan ni Isaya sawe túrâ na? Kagian na panò yù meyannung ta baggi na, onu kagian na yù meyannung ta tanakuán?” ");
INSERT INTO att_vpl VALUES ("AC8_35","074_8_35","ACT"