﻿USE sofia;
DROP TABLE IF EXISTS sofia.atgNT_vpl;
CREATE TABLE atgNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES atgNT_vpl WRITE;
INSERT INTO atgNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ona o khi akẹkẹ shi ekẹ abi unuẹkpẹ oyi iJesu iKirisiti Omi iDefidi ni ọ khi Omi Aburaamu o li zẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburaamu ọ bia Aziki, Aziki ọ bia iGiekọpu, IGiekọpu ọ bia iJuda ali inyọghuo ọli nya. ");
INSERT INTO atgNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","IJuda ọ bia iPẹrẹzi ali iZẹra, ọkpotso ni ọ bia wẹ, a lu iTama. IPẹrẹzi ọ bia Ezirọni. Ezirọni ọ bia iRamu. ");
INSERT INTO atgNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","IRamu ọ bia Aminadabu. Aminadabu ọ bia iNashọni, iNashọni ọ bia iSalimọni. ");
INSERT INTO atgNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ISalimọni ọ bia iBoazi, ọkpotso ni ọ bia iBoazi, a lu iRe-abu. IBoazi ọ bia Obẹdi ni a lu inyọli iRutu. Obẹdi ọ bia iJese. ");
INSERT INTO atgNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","IJese ọ bia iDefidi ni ọ khi oghie. IDefidi ọ bia iSolomoni ni inyọli ọ kpẹ khi ughuẹ Uraya. ");
INSERT INTO atgNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ISolomoni ọ bia iReobuamu. IReobuamu ọ bia Abija. Abija ọ bia Asa. ");
INSERT INTO atgNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ọ bia iJeoshafati. IJeoshafati ọ bia iJeoramu, iJeoramu ọ bia Uzaya. ");
INSERT INTO atgNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaya ọ bia iJotamu. IJotamu ọ bia Aazi. Aazi ọ bia Ezekaya. ");
INSERT INTO atgNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekaya ọ bia iManasẹ, iManasẹ ọ bia Amọni. Amọni ọ bia iJosaya. ");
INSERT INTO atgNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","IJosaya ọ bia iJekonaya ali inyọghuo ọli nya ẹghẹghẹ ni a rọ muno ẹgbọ iZirẹni ighumha je iBabilọ. ");
INSERT INTO atgNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Abi e ke rọ rọte iBabilọ jele, iJekonaya ọ bia iShalitiẹni. IShalitiẹni ọ bia IZerubabẹli. ");
INSERT INTO atgNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","IZerubabẹli ọ bia Abiudu. Abiudu ọ bia Eliakimu. Eliakimu ọ bia Azori. ");
INSERT INTO atgNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori ọ bia iZadọki. IZadọki ọ bia Akimu. Akimu ọ bia Eliudu. ");
INSERT INTO atgNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudu ọ bia Eliaza. Eliaza ọ bia iMataani. IMataani ọ bia iGiekọpu. ");
INSERT INTO atgNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","IGiekọpu ọ bia iJosẹfu, ni ọ rue iMeli inyi iJesu shi ni a lu iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Rọte ẹghẹghẹ Aburaamu bhale ẹghẹghẹ iDefidi, e khi agbhotu igbẹne. Ke rọte ẹghẹghẹ iDefidi bhale ẹghẹghẹ ni a rọ muno ẹgbọ iZirẹni ighumha je iBabilọ, e khi agbhotu igbẹne. Ke rọte ẹghẹghẹ iBabilọ bhale ẹghẹghẹ ni a rọ bia iJesu iKirisiti, e gbo li khi agbhotu igbẹne ghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Abi a li bia iJesu iKirisiti na. Neni iMeli inyọli ọ ngeli na iJosẹfu ni ọọ gue ọli. A bhale ya ẹ khi iMeli ọọ mẹ ọmọ ni ọ rọte obọ oyi Ayẹmhẹ-nọ-pfuasẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Itobọ khi iJosẹfu ughuọli, ọ khi ọgbọ ni ọ guẹ angeli, ọọ sali shi udu khi lọli ya kuegbe-a ri imeli shi ekẹ, ini lọli khi yẹghẹ ọlia ukpẹloe agbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Abi ọ lii sa ona shi udu, agẹni ọ bhale deba li alo ẹlena, ọọ li, “IJosẹfu omi iDefidi, khi ke zẹ ni ulishi o mu ẹ abi u li ya rue iMeli shi ughuẹ, irari khi ọmọ ni ọọ mẹ, obọ oyi Ayẹmhẹ-nọ-pfuasẹ ọ te bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ọ ya bia ọmọ ọmọse, eva ni u ya lu ọni ọmọ khi iJesu, irari khi ọ ya mie ẹgbọ eyọli olamhẹ pfuese.” ");
INSERT INTO atgNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eri a mẹ enana ni a rọ bhẹ ya ẹ khi ingmemhi ni Ẹshinẹgba ọ rọte unu oyi ọmekẹguele ngme, ni e bhale ya tsẹ. Ni ọọ, ");
INSERT INTO atgNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ghe khẹ! Ọmueshi ni ọa lẹ deba ọmọse ghue ọ ya ke mẹ ọmọ, ọ bia ọmọ ọmọse, eva oyọli a ya ke lu iManuẹni.” Abi ona o ngme khi, “Ẹshinẹgba ọ nu awa la.” ");
INSERT INTO atgNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Abi iJosẹfu ọ rọ guale, ọ riẹlẹ emini Ọnọmhuẹ ọ mhẹsẹ na li ọ riẹlẹ, ọ rue iMeli ughuẹ abi Ẹshinẹgba ọ gueyẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Eri-tsẹ khi iJosẹfu ọa tigbe lẹ deba iMeli, ramhi ni ọ rọ bia ọni ọmọ ọmọse. IJosẹfu ọ lu eva oyi ọni ọmọ, iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ẹoli ni a lu iBẹtilẹẹmu obini ekẹ iJudia a bia iJesu shi, ẹghẹghẹ ni oghie ni a lu Erọdu ọ rọ khi oghie. Emọse elẹsingme eghuo e rọte obini ovọ o te ẹ ngale bhale ekẹ iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ee mhila, ee liẹ, “Obo a bia ọni ọmọ ni ọ ya khi oghie ọyi ẹgbọ iJu shi? Irari khi anye she mẹ ukpẹtata oyọli obini ovọ o te ẹ ngale, lọli o zẹ khi anye bhale ni anye ya ga li.” ");
INSERT INTO atgNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Abi ọni oghie Erọdu ọ rọ suọ ona, egbe ẹa ke sheshe lọli ali ẹgbọ kpa ni e la iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ọ luno ighie eyi ekpodalo-ugamhi nya ali esẹsẹ Ishi eyi iMosisi kugbe. Ọ mhila wẹ, ọọ wẹ, “Obo ẹ khi a ya bia iKirisiti Ọmiepfuese shi?” ");
INSERT INTO atgNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","E gueyẹ ọli, “Ẹoli iBẹtilẹẹmu na ekẹ iJudia lọ.” “Irari khi ighọ emekẹguele e kẹkẹ shi ekẹ khi: ");
INSERT INTO atgNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘IBẹtilẹẹmu na ekẹ iJudia, yẹyẹ u ga khi ọni ọ mu ẹloe nẹ nya elemhi ẹoli eniẹmhi ni e la ekẹ iJudia. Ayẹ oghie ọ te ya lasele, ni ọ ya ri ẹgbọ iZirẹni khasẹ odẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ighọ oghie Erọdu ọ lu eni emọse eghọ ochi, ọ mhila wẹ, “Ẹghẹghẹ onoghuo a rọ mẹ oni ukpẹtata?” ");
INSERT INTO atgNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ighọ ọ ghie wẹ je iBẹtilẹẹmu, ọọ wẹ, “A ke lẹ, a kuegbe-a ya nono ọli. A kha da mẹ ọli ne, a nyenẹ egbe bhale ya gueyẹ mhẹ ni mhi li ya ga li.” ");
INSERT INTO atgNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Abi e rọ suọ abi Erọdu ọ ngme se, e te aghọ fiẹ lasele. Ighọ e gbo mẹ oni ukpẹtata ni e kpẹ mẹ obini ovọ o te ẹ ngale. O rẹ wẹ khasẹ odẹ ya ramhi ni o rọ migha ukhomhi oni owa ni ọni ọmọ ọ la. ");
INSERT INTO atgNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Egbe e mema mu wẹ abi e rọ mẹ oni ukpẹtata. ");
INSERT INTO atgNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ighọ e lo elemhi oni owa. Abi e rọ mẹ ọni ọmọ ali inyọli iMeli, e wugha e ga li. E khueghie ẹkuẹ ni e tsua-a, e rue igolu ali afu ituale ali oili ituale ni ẹẹ pfie ni e ghalẹ somhi ọli opfa. ");
INSERT INTO atgNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ighọ Ẹshinẹgba ọ tse agua yẹ wẹ alo ẹlena e khi gbo nyenẹ egbe ukhokho deba ọni oghie. Itobọ ighọ e rọte odẹ olese ya je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Abi eni emọse e rọ je se, agẹni ọyi Ọnọmhuẹ ọ gueyẹ iJosẹfu alo ẹlena, ọọ li, “Erọdu ọọ nono ọni ọmọ ọna ni luẹ gbe ọli-a. Rue ọli ali inyọli na je ekẹ iJipiti. La aghọ ramhi ẹghẹghẹ ni mhi rọ ya gueyẹ u rọte aghọ vu.” ");
INSERT INTO atgNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Obili o bi, iJosẹfu ọ rue ọni ọmọ ali inyọli na je ekẹ iJipiti. ");
INSERT INTO atgNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Oobọ ọ la ramhi ni oghie Erọdu ọ rọ ghu-a. Eri Ẹshinẹgba ọ riẹlẹ ona ni a rọ bhale ya ẹ khi emini ọmekẹguele ọ ngme khi o bhale ya tsẹ. Ni ọọ, “Ekẹ iJipiti mhi te lu omi mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Abi Erọdu ọ rọ mẹ khi eni emọse ni e rọte obini ovọ o te ẹ ngale bhale eghọ khi e di luẹ, Elemhi ee bi ọ egbegbọ. Ọ shi ushi a gbolo eniyẹ emọse enikeke ni e la ẹoli iBẹtilẹẹmu ali ẹoli ni e la gasẹ ọli-a nya. Eniyẹ rọte ikpe eva tiemhi ekẹ, abi eni epfẹse e gueyẹ ọni oghie ẹghẹghẹ ni e rọ mẹ oni ukpẹtata. ");
INSERT INTO atgNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abi a li mẹ ọli ena, o ri ungmemhi ni ọmekẹguele iJeremaya ọ ngme bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A suọ okokokhuẹ ekẹ iRama, ni o khi oyi eviẹ, ali eviẹ oya. IRechẹ ọọ viẹ imi ọli, Àá yẹsẹ ọli, ọa zẹ yẹsẹ, irari khi imi ọli e ghulo-a.” ");
INSERT INTO atgNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erọdu ọ ghu-a se, agẹni ọyi Ẹshinẹgba ọ bhale deba iJosẹfu alo ẹlena obini ekẹ iJipiti. ");
INSERT INTO atgNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ọọ, “IJosẹfu, vule, rue omiẹ ali ughuẹ, a ke je ekẹ iZirẹni irari khi eni ẹẹ nono ni wẹwẹ e gbe ọni ọmọ-a, e she ghuloa.” ");
INSERT INTO atgNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ighọ iJosẹfu ọ vule, ọ rue ọni ọmọ ali inyọli, ọ nyenẹ egbe je ekẹ iZirẹni. ");
INSERT INTO atgNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Eri-tsẹ khi abi iJosẹfu ọ rọ suọ khi Achẹlusi ọ ke shitọ ukpẹkhomhi oyi itali shi ekẹ iJudia, ulishi o mu ọli ọa gbudu je oobọ, ọ ri ochoghọ ya je obini ekẹ iGalili abi agẹni ọ she kpẹ tse agua yẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ọ ri iNazarẹti mele apfẹ oyọli-a. Irarighọ, ungmemhi ni emekẹguele e ngme, o bhale ya tsẹ. Ni ọọ. “A ya ke lu ọli ọngi iNazarẹti.” ");
INSERT INTO atgNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ikpe ni e bu e dọsẹ, iJọni Ọni ọọ batazi ẹgbọ ọ lasele shi elemhi ọdagbe ifufu na ekẹ iJudia, ọọ tse abọ. ");
INSERT INTO atgNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ọọ liẹ, “A rọte olamhẹ eyẹ ẹ mu pfi irari khi Eghiele oyi Ẹshinẹgba o she ti bhale.” ");
INSERT INTO atgNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ingme oyi iJọni ọna, Azaya ọmekẹguele ọọ ngme abi ọ rọ liẹ, “Ọgbọ ọghuo ọ la elemhi ọdagbe ifufu ẹ tsẹsẹ, ọọ liẹ, ‘Bẹ odẹ-a na Ọnọmhuẹ rọte, bẹ ọli sheshe.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Itsua ni iJọni ọ rọ sọ, iriria akphẹrẹ a rọ do wẹ. Ọ ri ọgbẹnẹ ẹkuẹ ẹlamhi mu oku. Initso ali oribo e khi eminale eyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","IJerusalẹmu ali ekẹ iJudia ali ẹdẹli ni e mama okẹ iJọdani nya ẹgbọ e rọte e bhale ni e suọ ungmemhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ọ la elemhi okẹ iJọdani batazi ẹgbọ, ee zọnọ olamhẹ eyẹwẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Abi iJọni ọ rọ mẹ khi ẹgbọ otu iFarisi ali iSadusi ni e bu e bhale deba li ọ batazi wẹwẹ, ọọ wẹ, “Ẹẹ enyẹ ali imi enyẹ! Ọghuo ọ tse agua yẹ ẹ, a na, khi anasẹmhẹ ọọ bhale ni Ẹshinẹgba ọ ya ghie ghi ẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","A ke ngeli ingeli eni e ya rọkhasẹ khi a she mu pfi. ");
INSERT INTO atgNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A khi ke sa khi a ya na pfue anasẹmhẹ ini a da liẹ, ‘Aburaamu ọ khi itita anye.’ Itobọ khi Ẹshinẹgba ọ dobẹ ya rọte echẹ ena wolọ eniyẹ lasele na Aburaamu. ");
INSERT INTO atgNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A she tọ uze sọ udi ọara. Ọara ni ọa da mọ umọmhi onete ne, a ya khi ọli pfilo erali. ");
INSERT INTO atgNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Amẹ mhi rọ ọ batazi ẹ memena, irari khi a she mu pfi. Ọgbọẹse ni ọọ bhale ikpukhokho oyẹmhẹ, ọ fu dọsẹ mhẹ. Mhi a fẹ futẹ ọni ọ tsua ekuẹ oyọli ekẹ. Lọli ọ ya ri Ayẹmhẹ-nọ-pfuasẹ ali erali batazi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ọ̀ mu ukpokpo ni a tọ akhuli ni o zẹ epfia sọ mhuẹ obọ oyọli, ni ọ rọ ya ke ghiaghiẹ wẹ, ọ pfie efuẹ ado-a, ashini a la kpishi wẹ. Ọọ ti wẹ gbili shi ashini a ri eminale ẹ shi, eni efuẹ wẹ eghọ, ọ ya ri erali ni ẹa ya pfua ghue tosẹ wẹ-a.” ");
INSERT INTO atgNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","IJesu ọ ya rọte ekẹ iGalili bhale okẹ iJọdani ni iJọni ọ batazi luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","IJọni, ọọ nono ni lọli khu iJesu oni ibatizi, ọọ iJesu, “Yẹyẹ u kha batazi mhẹ, sẹ u ke gbo li bhale deba mhẹ mhi batazi ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","IJesu ọ sọli ọ, ọọ li, “Iiye. Kie zẹ ni awa lina riẹlẹ ọli ẹghẹghẹ ona, ni awa mẹ asha ri ọghuẹmhẹ oyi Ẹshinẹgba gbe akanya pfo.” IJọni ọ lama shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","A batazi iJesu se, khi ọ lẹsẹ na rọte elemhi okẹ ngale esọ egele, ọ mẹ khi idane o khueghie a. Ighọ ọ mẹ khi Ayẹmhẹ oyi Ẹshinẹgba ọ li abi anekhukhu tiemhile bhale ya ma li egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A suọ khi uruli o rọte idane ngme, ọọ li, “Omimhẹ ni mhi nono ingme oyọli na, ni ọ ri egbe ẹ mu mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ayẹmhẹ ọ rue iJesu je ọdagbe ifufu ni Ọkphaghiẹ ọ mẹ asha mu ọli fẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Abi iJesu ọ rọ pfi azumhi ogbẹlẹ egbhuẹva se, okiamhi oo gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ighọ Ọkphaghiẹ ọ bhale deba li, ọọ li, “Ini o khia khi Omi Ẹshinẹgba u khi, nu eni echẹ ena ngme ni e mele eminale-a nẹ ni u le.” ");
INSERT INTO atgNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","IJesu ọọ li, “Ebe-no-pfuasẹ o ngme ghọ khi: “ ‘Ọa khi eminale tsẹ, o ri agbọ a na ọgbọ, ama ungmemhi ni o rọte Ẹshinẹgba unu lasele kpa.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ighọ Ọkphaghiẹ ọ rue iJesu je iJerusalẹmu, ẹoli no pfuasẹ. Ọ rue ọli ya nga apfiẹpfiẹmhi ashini o yagha nẹ shi Owa Oyi Ẹshinẹgba ya migha. ");
INSERT INTO atgNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ọọ iJesu, “Ini o khi Omi Ẹshinẹgba u khi, rọte ukhomhi ana ji ya tiemhi ekẹkhẹ.” Irari khi Ebe-no-pfuasẹ o ngme ọli khi: “ ‘Ẹshinẹgba ọ ya ri unu na igẹni eyọli e ri ẹloe shi ẹ egbe e kpe abọ muẹ, Ini u khi khi owẹ shi ẹchẹ.’” ");
INSERT INTO atgNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","IJesu ọọ li, “A gbo li kẹkẹ ọ shi Ebe-no-pfuasẹ khi, ‘Khi mu Ẹshinẹgba Ọnọmhuẹ ọyẹ fẹ bino.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ighọ Ọkphaghiẹ ọ rue iJesu nga ukhomhi ute ni o lolo yagha, ọ ga ri eghiele ni e la agbọ ona nya ali isomhotse oyẹwẹ khasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ọọ li, “Ena nya mhi ya rọ nẹ ini u lẹsẹ nyẹsẹ ukhomhi ga mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","IJesu ọọ li, “Vu mhẹ alo-a, Ọkphaghiẹ! Ebe-no-pfuasẹ òó liẹ, “ ‘Nyẹsẹ ukhomhi na Ẹshinẹgba Ọnọmhuẹ oyẹ, lọlighuo kpe wa ke ga.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ighọ Ọkphaghiẹ ọ zẹ iJesu obọ, igẹni e bhale ya kpaghiẹ ọli obọ. ");
INSERT INTO atgNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Abi iJesu ọ rọ suọ khi a mu iJọni shi owa ighumha, ọ nyenẹ egbe je ẹdẹli iGalili. ");
INSERT INTO atgNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ọa migha iNazarẹti, ọ je iKapanọmu, ẹdẹli ni o la ukiẹkiẹ okẹ iGalili ni o la ekẹ iZebulọ ali iNafutali. ");
INSERT INTO atgNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eri a mẹ ena ni a rọ bhale ya ẹ khi ungmemhi ni Azaya ọmekẹguele ọ ngme, o bhale ya tsẹ, ni ọ la liẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ẹẹ ekẹ iZebulọ ali ekẹ iNafutali, ni a la ini a da okẹ iJọdani lase, IGalili, ni ẹgbọ iJẹta e ngeli, ni o la odẹ ni o je okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ẹgbọ ni e la alo ebili e ya mẹ ákpá oniẹmhi. Oni ákpá ọọ ngale na ẹgbọ ni o li abinẹ khi eghuli o ti mama wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Rọte aghọ vu iJesu ọ rọte tse abọ kia guele, “Ọgbọgbọ ọ mu pfi, irari khi Eghiele oyi Ẹshinẹgba o she ramhi.” ");
INSERT INTO atgNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Abi iJesu ọ li kia epfepfẹ okẹ oniẹmhi iGalili, ighọ ọ mẹ iPita ali Aduru, ọgbọ ali inyọghuo ni e khi egbifẹlẹ khi e ri aga a gbe ifẹlẹ oni okẹ-no-khishi. ");
INSERT INTO atgNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","IJesu ọọ wẹ, “A bhale deba mhẹ khi mhi ya sẹsẹ ẹ abi a ke liẹ ke lu ẹgbọ bhale, ocho ni a rọ ọ gbe ifẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aghọaghọ e zẹ aga eyẹwẹ obọ, e deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ọ ke lẹ, ọ mẹ ọgbọ ali inyọghuo, iJemhisi ali iJọni imi iZebedi khi e nu itawẹ la elemhi ọkọ okẹ ni e lo, e riẹlẹ aga oyẹwẹ ẹ riẹlẹ. IJesu ọ lu wẹ e bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aghọaghọ e lase ọkọ-okẹ le, e pfi itawẹ shi aghọ, e deba li vu. ");
INSERT INTO atgNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","IJesu ọ kia asha kpa ekẹ iGalili ọ la owa ugamhi eyẹwẹ sẹsẹ wẹ usomhi onete oyi iloghie, ali ọ ri ẹgbọ ni e mhuẹ ighuamhi ọdọda ze. ");
INSERT INTO atgNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ighọ a li suọ eko ọli ushishi iSiria oghọ nya, ya ramhi khi ẹgbọ e tsua eni mhuẹ ighuamhi ali anasẹmhẹ ọdọda, ghe eni e mhuẹ ayẹmhẹ ọkphaghiẹ ali ughuamhi ni ọọ mu ọgbọ pfi gbe ali eni e guọghọ-a bhale deba iJesu. Ọ ga rẹwẹ ze nya. ");
INSERT INTO atgNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ighọ ebubu ẹgbọ e rọte iGalili ali ẹoli iDikapolisi ali iJerusalẹmu, ekẹ iJudia ali ẹgbọ ni e la ukiẹkiẹ obinokpọle oyi okẹ iJọdani, e deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Abi iJesu ọ rọ mẹ oni olele ẹgbọ, ọ ti nga esọ ute dẹnẹ, ọ shitọ. Eniyẹ odukhokho eyọli e bhale ya shitọ gasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ọọ sẹsẹ wẹ, ọọ liẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ikhivọsẹ o khi oyi ẹgbọ ni e lẹsẹ khi Ẹshinẹgba ọ mhuẹ emhikpa, wẹwẹ e mhọli obọ shi Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ikhivọsẹ o khi na ẹgbọ ni ẹẹ viẹ, Ẹshinẹgba ọ ya yẹsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ikhivọsẹ o khi oyi ẹgbọ ni e ti egbewẹ tiemhile, Ẹshinẹgba ọ ya ri agbọ ona nya na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ikhivọsẹ o khi oyi ẹgbọ ni okiamhi ali okiamẹ iguẹ-ngeli ọọ gbe, Ẹshinẹgba ọ ya ri emini ẹ nono na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ikhivọsẹ o khi oyi ẹgbọ ni e mhọli ilẹlemhi na ẹgbọẹse, Ẹshinẹgba ọ ya mhọli ilẹlemhi na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ikhivọsẹ o khi oyi ẹgbọ ni e mhọli udu no pfuasẹ, e ya mẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ikhivọsẹ o khi oyi ẹgbọ ni ẹẹ dua ini opfọmhẹ o la ọ, Ẹshinẹgba ọ ya lu wẹ imiọli. ");
INSERT INTO atgNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ikhivọsẹ o khi oyi ẹgbọ ni a mu okhọli vule shi ọ irari khi e da riẹlẹ emini Ẹshinẹgba ọ nono, wẹwẹ e mhọli obọ shi eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ikhivọsẹ o khi nẹ, ini ẹgbọ e mu okhọli vule shi ẹ ọ, ẹẹ kiẹ iwali ẹgbhọli ọdọda mẹ irari khi u mie mhẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Zẹ ni u ke ghẹlẹ, egbe ẹẹ muẹ, irari khi eleli oyẹ ni o la iloghie oo gbẹdi gba. Ina e li mu okhọli vule shi emekẹguele ọ ni e kpẹ bhale khẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Eri a li abi ugbheli shi agbọ ọ. Ini ugbheli o wasẹ oviọlọ oyọli-a, aa ke tigbe mhọli abi a li ya rọli gbo mele ugbheli-a. Aa ke rọli ya li emhikhọghuo dọsẹ a ku ọli kua ni a ri awẹ lighi ọli ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Eri a li abi ákpá shi agbọ ọ. Owa ni a tọ shi ukhomhi ute ọa ya sheli. ");
INSERT INTO atgNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aa mẹ ọgbọ ni ọ ya ri ákpá ru se, ọ khukhu ọli shi atalabi. Eri ọ ya ri ochoghọ rue ọli nga asha na keghe, ni o ke mẹ ekẹ ni ẹgbọ ni e la oni owa e ke mẹ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lighọ zẹ ni ákpá oyẹ o ke gẹ khasẹ ẹgbọ, ni e rọ mẹ ikanya enete eyẹ ni e mẹ asha kuẹghiẹ Ẹshinẹgba ni ọ la iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“A khi dabi khi eri mhi bhale ya shishi Ishi eyi iMosisi ekẹ-a, a khi a dabi khi eri mhi bhale ya shishi emini emekẹguele e sẹsẹ-a. Iiye! Eri mhi bhale ya rẹ wẹ tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Zẹ mhẹ gueyẹ khi ekẹ ali ukhuli e kha da kie la ọ ne, ukpamhi ingme okhọghuo ọa ya wa Ishi eyi iMosisi-a, ini emini e kẹkẹ wẹ shi ekẹ shi nya ẹa li bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Itobọ ighọ, ọnini ọ da gbe ushi ni o ga shẹ nẹ a nya, ni ọ gbolo ẹ sẹsẹ ẹgbọ e li lighọ ne, lọli ọ ga ya shẹ nẹ nya Eghiele oyi Ẹshinẹgba, ọnini ọ da riẹlẹ wẹ ni ọ gbolo ẹ sẹsẹ ẹgbọ eni ishi eyi Ẹshinẹgba ne, ọ ya khi ọnọfunẹ Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mhi gueyẹ ẹ khi ini iguẹ-ngeli oyẹẹ ọa da dọsẹ iguẹ-ngeli oyi esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi ne, aa ya lo Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“A suọ khi ẹghẹghẹ ni o dọsẹ khi a gueyẹ eni egbhali, ẹẹ, ‘Khi gbe ugbeli, ọnini ọ da lighọ ne, a ya ri ọli gue ẹzọ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama memena mhi gueyẹ ẹ khi ọni ọ da mhuẹ ofu deba inyọghuo ọli ne, a ya rọli gue ẹzọ. Ọni ọ da liẹ inyọghuo ọli, ‘Yẹyẹ ọgbọ afuẹ ọna!’ A ya rue ọli bhale deba enighie. Ọni ọ da lu inyọghuo ọli, ‘Yẹyẹ ọyẹghẹ ọna!’ Ọ ya la okhẹna erali na ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ini u mhuẹ isomhopfa ni u wa nono ni u rọ ghi Ẹshinẹgba ukhomhi atẹtẹ, ni u rọ da sato khi inyọghuo ẹ ọ mhuẹ ofu nẹ shi emini u riẹlẹ ọli ne, ");
INSERT INTO atgNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","zẹ oni isomhopfa oghọ obọ shi odalo atẹtẹ, u je apfẹ ni yẹyẹ ali ọni inyọghuo ẹ ni a rọ riẹlẹ, u tigbe bhale ya ri isomhopfa oyẹ na Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ini ọbe ẹ ọ rue ẹ lẹ ikọtu, nyanya lema li abi a li la odẹ ẹ lẹ eghọ neni a ramhi aghọ. Ini ọa khi ighọ, ọ ya rue ẹ na ọsọ-ẹzọ, ọni ọsọ-ẹzọ ọ rue ẹ na ọgbanelemhi, ọ́ rue ẹ ya khukhu shi owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Abi o li mhi li gue ọli ẹ yẹ ẹ khi, waa ya rọte aghọ lasele ini u waa li zẹ oko na fiẹ pfo nya. ");
INSERT INTO atgNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“A suọ ẹghẹghẹ ni o dọsẹ khi a liẹ, ‘Khi kia okia.’ ");
INSERT INTO atgNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama memena mhi gueyẹ ẹ khi ọnini ọ da ri ọghuẹmhẹ itsẹbọ bino ọkpotso ne, ọ she kia okia deba ọni ọkpotso elemhi usamhi udu oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Irarighọ, ini o khia khi ẹloe na obita oyẹ o ya zẹ ni u lo owa erẹ, vuọnyọ li pfia, irari khi o ti nẹ ini egbe ẹa gba nẹ ya lo iloghie, dọsẹ khi yẹyẹ nya u lo ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ini o khia khi obita oyẹ o ya zẹ ni u pfidọ ya lo owa erẹ, khi ọli pfia. O tinẹ ni u zẹ obọ oghuo ya lo iloghie dọsẹ khi yẹyẹ nya u lo ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“A li ngme ọli shi Ishi eyi iMosisi khi, ‘Ọmọse ọ kha khu ughuẹ ọli, ọ nya ebe ipfa ughuẹ-a na li.’ ");
INSERT INTO atgNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama memena mhi gue ẹ yẹ ẹ khi, ọni ọ da khu ughuẹ ọli ni o khia khi ọa khi eri ọ kia okia ne, ọ she yẹsẹ ọni ọkpotso mele ọkiokia-a. Ọmọse ni ọ rue ọni ọkpotso ọghọ, eri ọ li kia okia. ");
INSERT INTO atgNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“A gbo li suọ khi a gueyẹ ẹgbọ ena ẹlẹlẹ, ‘A khi da irọnga ni a rọ nga, ama emini u romhi Ọnọmhuẹ rọ nga, khi da ọ, lighọ rọli tsẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Emini mhi ke gue ẹ yẹ ẹ mena khi, khi ga romhi isheli kpa. Khi romhi idane irari khi oobọ ukpẹkhomhi oyi Ẹshinẹgba o la. ");
INSERT INTO atgNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Khi gbo li romhi ekẹkhẹ, irari khi lọli khi akphawẹ-nga oyi Ẹshinẹgba. Wẹkhi iJerusalẹmu, irari khi lọli o khi ẹoli oyi Oghie nọ funẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Khi ga ri ukhomhi oyẹ romhi ishe, irari khi waa ya dobẹ ri ẹtsui oghuo kpe bishi a wẹ khi eri u dobẹ rọli ya pfuasẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ungmemhi oyẹ o lẹsẹ migha shi ii, okekhi iiye, emini o da dọsẹ ighọ ne, obọ oyi Ọkphaghiẹ o te bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“A suọ khi a kpẹ ngme ọli, khi, ‘A ri ukpẹloe fata ukpẹloe, ali ẹkọli o fata ẹkọli.’ ");
INSERT INTO atgNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama mena, mhi gueyẹ ẹ, a khi riẹlẹ ọgbọ to ọ ini ọ riẹlẹ ẹ onobe. Ini ọgbọ, ọ lase ẹ esọ obita nyenẹ ona ọgobọ na li gbo lase. ");
INSERT INTO atgNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ini ọgbọ ọọ nono ni lọli luẹ ẹzọ, ni lọli rọ mie ẹ awulu oyẹ, bie gbo gueghie oni u sọ kpọkẹ ma ọ nali. ");
INSERT INTO atgNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ini ọgbọ ọ ri itoto liẹ u tsua itsua na luẹ imali oghuo, tsua wẹ imali eva. ");
INSERT INTO atgNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ini ọgbọ ọ mhila ẹ emhi, rọna li. Ngmomhi na ọni ọ ye ongmomhi deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“A she suọ khi a liẹ, ‘Nono ingme oyi ọnuzi-ava ọyẹ, u ke biselemhi ọbe ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama mhi gueyẹ ẹ. Nono ingme oyi ọbe ẹ, u gbo sọ iromhi na eni mu okhọli vule shi ẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","U kha lina, eri u wa ngeli abi itẹ na iloghie. Irari khi lọli ọ ri ovọ oyọli ẹ to na ẹgbọ ọkhọlọ ali ẹgbọ enete. Ighọ ọ gbo liẹ ruẹsẹ amẹ na ẹgbọ ọkhọlọ abi ọ liẹ ruẹsẹ ọli na ẹgbọ enete. ");
INSERT INTO atgNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sẹ u ke li ya mẹ asha mhuẹ eleli obọ oyi Ẹshinẹgba ini u lẹsẹ nono ẹgbọ ni e nono ingme oyẹ? Egbegbi emionoga e lili ẹ lighọ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ini o khia khi inyọghuo ẹ tsẹ u lẹsẹ ẹ tsẹ, ighe ikhiọda ni o la yẹyẹ ali eni ẹa miesuọ ọ? Eni ẹa miesuọ e lili ẹ lighọ. ");
INSERT INTO atgNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Itobọ ona, zẹ ni u gba pfo abi Itẹ na iloghie ọ li gba pfo.” ");
INSERT INTO atgNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Guẹ kia ini u khi riẹlẹ iguẹ-ngeli abamẹmhẹ ukpẹloe ẹgbọ. Ini u wa a lighọ, wa a ya mhuẹ eleli obọ oyi Ẹshinẹgba Ita ni ọ la iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ini u ri isomhopfa na ẹgbọ ni ẹa mhuẹ, khi rọli pfi akala ke kiakia, abi eni ẹa miesuọ ẹẹ li elemhi owa ugamhi ali ifuapfẹ. Eri ẹ lighọ ni ẹgbọ e ba kuẹghiẹ wẹ. Abi o li mhi li gue ẹ yẹ ẹ, khi, e she mie eleli eyẹwẹ se. ");
INSERT INTO atgNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama rọna ọni ọ la ọmunu, khi zẹ ni ọgbọẹse ọ lẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ẹghẹghẹ aghọ o khi emhi osheli, ni Itẹ ni ọ la iloghie ni ọọ mẹ emini u riẹlẹ elemhi osheli, ọ ri eleli nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Yẹyẹ o yẹ ini u ya sọ iromhi khi ya riẹlẹ ọli abi eri ugamhi ku alo ni ẹẹ migha epfẹ odẹ ali elemhi owa ugamhi ini ẹgbọ e ba ke mẹ wẹ. Abi o li mhi liẹ gue ọli ẹ yẹ ẹ khi e she mhuẹ eleli oyẹwẹ gba se. ");
INSERT INTO atgNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama ini u ya sọ iromhi, lo elemhi owa oyẹ, u khukhu odẹ, u sọ iromhi ghi Ita ẹ ni ọ la osheli, Itẹ ni ọ la osheli ni ọọ mẹ emini a li osheli, ọ ya ri eleli gba nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ini u ya sọ iromhi, khi ke riẹlẹ ungmemhi oghuo ngme itingmingmẹ, abi eni ẹa miesuọ ẹẹ li. Eri ẹẹ dabi khi ingmemhi ni e bu dọsẹ Ẹshinẹgba ọyẹwẹ ọ rọ suọ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Khi li abi wẹwẹ. Itobọ khi Itẹ ọ shẹ kpẹ lẹsẹ emini u wa nono neni u mhila li. ");
INSERT INTO atgNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“U kha sọ iromhi, ke liẹ: “Ita anye ni ọ la iloghie, anye ri ufumhi na eva oyẹ no pfuasẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","zẹ ni Omhẹsẹ oyẹ o bhale. Zẹ ni a riẹlẹ ọghuẹmhẹ oyẹ ekẹ agbọ abi a liẹ riẹlẹ ọli obini iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ri eminale ona ogbe-namo na anye. ");
INSERT INTO atgNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gbe olamhẹ kua na anye, abi anye liẹ gbe kua na ẹgbọ ni e lamhẹ shi anye ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","‘Khi zẹ ni anye de pfilo imufẹ, mie anye pfuese obọ oyi ọkphaghiẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","U kha gbekua na eni e lamhẹ shi ẹ ọ, Itẹ na iloghie ọ ya li gbekua nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama ini u wa a gbekua na eni e lamhẹ shi ẹ ọ, Itẹ na iloghie ọa ya li gbekua nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“U kha pfi azumhi, khi wushe alo-a shi ukhomhi abi eni ẹa miesuọ ẹẹ li. Eri ẹẹ nyenẹ alo zẹ shi ukhomhi ini ẹgbọ e ba lẹsẹ khi ẹẹ pfi azumhi. Abi o li mhi li gue ẹ yẹ ẹ, e she mhuẹ eleli oyẹwẹ se. ");
INSERT INTO atgNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama u kha pfi azumhi, ri oili shishi ukhomhi rọ dala egbe-a, u pfiono itsu-a shi ukhomhi, ");
INSERT INTO atgNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ini ẹgbọ e khi lẹsẹ khi azumhi wa pfi. Ama ọni Itẹ ni ọọ mẹ osheli nya ọ ya ri eleli nẹ gbodojo. ");
INSERT INTO atgNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Khi ti ẹpfue ma leghe na egbe ẹ shi elemhi agbọ ona, ni ifu e la le emhi, ni emhi e la mu ọghuọghuọ-a, ali ni ighiatọ e la dobẹ ẹ do. ");
INSERT INTO atgNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ochoghọ ti ẹpfue ma iloghie ni ifu ẹa dobẹ la le emhi, ali ni emhi ẹa la mu ọghuọghuọ-a wẹkhi ighiatọ e dobẹ la do. ");
INSERT INTO atgNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Irari khi asha ni ẹpfue oyẹ o la aghọ udu oyẹ ọọ la. ");
INSERT INTO atgNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ikpamhi alo e khi ákpá ni idiegbe o mhuẹ. Ini ukpẹloe oyẹ o dala, egbe eyẹ nya o khi ákpá. ");
INSERT INTO atgNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama ini alo eyẹ ẹa ti, idiegbe eyẹ nya e khi alo ebili. Ini a ke bhale ya ẹ khi ákpá ni o la idiegbe oyẹ o khi obili, sẹ oni obili o ke bẹshi liẹ gba ramhi shi idiegbe oyẹ! ");
INSERT INTO atgNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ọgbọkhọghuo ọa dobẹ ya ga ega ava. Eri ọ ya nono ingme oyi ọghuo, elemhi ọnọkpọle ẹẹ bi ọli. Ọ ya ke suọ esọ na ọghuo, ọ ri ukpẹloe gbe ọnọkpọle. Ọgbọ ọa ya dobẹ ga Ẹshinẹgba ali ukpaghọlọ utoghuo. ");
INSERT INTO atgNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Onana o zẹ ni mhi rọ gueyẹ u khi ke sa usamhi emini a le ali emini a da, wẹkhi usamhi egbe ẹ emini u ya sọ. Agbọ oyẹ ọa fu dọsẹ eminale? Abi khi eri idiegbe oyẹ ọa fu dọsẹ ode? ");
INSERT INTO atgNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","A bino ipfeli ni e la idane, ẹa rọ kọ wẹkhi eri ẹẹ khiẹsẹ tima shi aka. Ama eri Itẹ na iloghie ọ kie ri ẹloe ẹ khu wẹ. Aa mu ẹloe dọsẹ wẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ọngẹẹ ọnọghuo ọ dobẹ ya ri isamhi ali ayele khi iwakati oghuo kpe ma agbọ oyọli? ");
INSERT INTO atgNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Elọ o zẹ ni a rọ ọ sa usamhi ode ni a rọ ọ ku egbe? A bino idodo ni e la ifui ebuli, khi ẹa ya gbe akanya wẹkhi eri ẹ fia ide zu egbewẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ama mhi gueyẹ ẹ khi ashini Oghie iSolomoni ọ mhuẹ ufumhi ramhi, ọa khuẹ akhuẹ ramhi udodo okhọghuo ena. ");
INSERT INTO atgNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ini Ẹshinẹgba ọ lina ri ide ku ebuli tsẹ, ni o kha la ọ amo, akọ o to-a, sẹ ọa kẹ liẹ li ri ode ku ẹ? Ẹẹ ẹgbọ ni irudunga oyẹẹ o shẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Itobọ ighọ khi ke yele obini u ya mẹ eminale le ali obini u te ya mẹ da, ali obini u te ya mẹ ide ku egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Emhi enana eni ẹa miesuọ e na khu, ama Itẹ na iloghie ọ lẹsẹ khi a kha mhọli emhi eghọghọ kpa. ");
INSERT INTO atgNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ochoghọ kpẹ zẹ ni Ẹshinẹgba ọ mhẹsẹ shi agbọ oyẹ ne, ni u ri eni omhẹsẹ gbe akanya, khi ọ ya ri emhi enekpọle nya ma ọ nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Irarighọ, khi ke zẹ ni ayele akọ o nasẹ udu amo, akọ o ya sa usamhi egbọli. Ogbẹlẹ ọgbọgbọ o mhuẹ anasẹmhẹ oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“A khi gue ẹgbọ ẹzọ, ini Ẹshinẹgba ọ khi gue ẹ ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Irari khi abi u li gue ẹgbọẹse ẹzọ, ighọ Ẹshinẹgba ọ li ya gue ẹzọ oyẹ. Emini u rọ mhẹsẹ na ọgbọẹse a li rọ ya mhẹsẹ nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Elọ o zẹ ni u rọ mẹ uku ni o la inyọghuo ẹ ẹloe ni u waa rọ mẹ ufolo ọara ni o pfida ẹ ẹloe? ");
INSERT INTO atgNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sẹ u ke liẹ gueyẹ inyọghuo ẹ, ‘Zẹ ni mhi rue ẹ uku ẹloe le,’ ni yẹyẹ ọyẹ wa a rọ mẹ ufolo ọara ni o pfida ẹ ẹloe? ");
INSERT INTO atgNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yẹyẹ ọ ri ugamhi ku alo, kpẹ rue ufolo ọara ni o pfida ẹ ẹloe-a ne neni u tigbe ya mekẹ rue oni o la oyi inyọghuo ẹ ọ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Khi ri emhi ipfuasẹ na ewa. Khi pfi emini o mu ẹloe abi igolu ghi igulu. Eri e ya wu wẹ ekẹ-a, e sọ alo okhọli ghue ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mhila khi a ya rọ nẹ. Nono khi u ya mẹ rue, kpheli obọ odẹ khi a ya khueghie-a nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Irari khi ọni ọ mhila, lọli a rọ ọ na. Ọgbọ ni ọ nono lọli ọ mẹ ẹ rue. Ọni ọ kpheli obọ odẹ, lọli a khueghie-a a na. ");
INSERT INTO atgNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ọngẹẹ ọnọghuo ọ bia ni omiọli ọ ya mhila li ibulẹdi ni ọ ya rue ẹchẹli na li? ");
INSERT INTO atgNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ọ kha mhila ẹ afẹlẹ, ẹnyẹ u ya rue na li? ");
INSERT INTO atgNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ini ẹẹ ni a khi ẹgbọ ebe a lẹsẹ abi a li ri eminete ẹ na imi ẹ, sẹ Ita ni ọ la iloghie ọ ke bẹshi li ya ri eminete na ẹgbọ ni e mhila li? ");
INSERT INTO atgNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Irarighọ, abi u nono ni ọgbọ li riẹlẹ deba ẹ, yẹyẹ li lighọ riẹlẹ deba li. Irari khi emini Ushi oyi iMosisi ali emekẹguele e sẹsẹ nya na. ");
INSERT INTO atgNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Rọ te odẹ unuẹkpẹ na pfi lo. Irari khi odẹ unuẹkpẹ na gbada ali odẹ agbala na gbada o khi odẹ ni o je owa erẹ, ebubu ẹgbọ e rọte ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Odẹ ni o je iloghie eri oo riele, odẹ unuẹkpẹ ni a te ẹ je ọ, oo pfi, ama ikuku ẹgbọ e rọte ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“A bẹ ekẹ ma emekẹguele ẹgbhọli. Eri e ri ẹkuẹ osumha ku egbe, ama elemhi udu oyẹwẹ, idumhi ni ẹ nyanọ ọgbọ le e khi. ");
INSERT INTO atgNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Angeli oyẹwẹ o rẹ wẹ ẹ khasẹ emini e khi. Ọkphẹkphẹ ọa ya mọ udumhi olomu, wẹ khi eri ọọ mọ udumhi ọkhua eni. ");
INSERT INTO atgNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ọara onete ọọ mọ udumhi onete. Ọara ni ọa ti ọọ mọ udumhi ni ọa ti. ");
INSERT INTO atgNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ọara onete ọa ya mọ udumhi ni ọa ti, wẹkhi eri ọara ni ọa ti o dobẹ ya mọ udumhi onete. ");
INSERT INTO atgNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ọara kpa ni ọa da mọ udumhi onete ne, eri a ya khi ọli pfia, a tosẹ ọli a. ");
INSERT INTO atgNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Itobọ ighọ emini emekẹguele ẹgbhọli ẹẹ riẹlẹ, u te ẹ lẹsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ọa khi ọgbọkpa ni ọọ lu mhẹ, ‘Ọnọmhuẹ, Ọnọmhuẹ’ ọ ya lo eghiele oyi Ẹshinẹgba, ama ẹgbọ ni ẹ riẹlẹ ọghuẹmhẹ oyi Itamhẹ ni ọ la iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ini ẹlẹ iguẹzọ o ramhi, ebubu ẹgbọ e ya liẹ mhẹ, ‘Ọnọmhuẹ, Ọnọmhuẹ, anye ẹẹ she ri eva oyẹ mẹ ekẹ guele, anye ri eva oyẹ khu ẹgbọ iyẹmhẹ ebe egbe-a, anye gbo gbe ikanya ọnyaloa ọdọda?’ ");
INSERT INTO atgNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ẹghẹghẹ aghọ mhi ya gueyẹ wẹ gboo, ‘Mhi aa lẹsẹ ẹ. A vu mhẹ ana le pia, ẹẹ ẹgbọ ọkhọlọ ena.’ ");
INSERT INTO atgNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ọgbọkpa ni ọ da suọ ungmemhi oyẹmhẹ ni ọ da rọli gbe akanya ne, eri ọ li abi ọgbọ ọlẹsingme ni ọ tọ owa nga ukhomhi ẹchẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ini amẹ o riẹ ruẹ, ni ochikpho o rọ tu, khi akpekpeli o riẹ li gbe oni owa oghọ, ọa o ya de, irari khi ukhomhi ẹchẹ a tọ li nga. ");
INSERT INTO atgNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama ọgbọ ni ọ da suọ ungmemhi oyẹmhẹ ni ọa da rọli gbe akanya ne eri ọ li abi ọyẹghẹ ni ọ tọ owa nga ekhashẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Amẹ o kha ruẹ, ni ochikpho o rọ tu, ni akpekpeli o rọ li gbe oni owa oghọ, oni owa o de kua, o de udemhi ọsanabẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Abi iJesu ọ rọ ngme se, osẹsẹ oyọli o ri abọ sha eni e legba. ");
INSERT INTO atgNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Irari khi eri ọ sẹsẹ ẹgbọ abi ọgbọ ni ọ lẹsẹ emini ọọ sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Abi iJesu ọ rọte ukhomhi ute tiemhile, ebubu ẹgbọ e bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ighọ ọmọse ashọmha ọghuo ọ bhale ya wugha iJesu odalo, ọọ li, “Ọnọmhuẹ, ini o ghọle ẹ, u dobẹ ya rẹ mhẹ ze.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","IJesu ọ nise obọ-a ti ọli, ọọ li. “O ghọle mhẹ, khi ọni ọ ze.” Aghọaghọ ọni ọmọse ọ ze. ");
INSERT INTO atgNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","IJesu ọọ li, “Khi gueyẹ ọgbọkhọghuo, ama ka ri egbe ẹ khasẹ ekpodalo-ugamhi eyi Ẹshinẹgba, ni u riẹlẹ iluasobo ni iMosisi ọọ a ke riẹlẹ ini a ri ọni efafe mu pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Abi iJesu ọ rọ lo iKapanọmu le, ọkhọli-okhuẹ ni ọ mhẹsẹ na ekhọli-okhuẹ egbhuẹshe ọyi iRomu ọghuo ọ bhale ya lema li ikpaghiobọ. ");
INSERT INTO atgNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ọọ li, “Ọnọmhuẹ, ọni ọọ ga mhẹ ọ ga yẹshi apfẹ ẹ ghu-a egbegbọ. Eri ọ guọghọ a.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","IJesu ọọ li, “Mhi ya bhale ya rọli ze.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ọni ọkhọli-okhuẹ ọọ li, “Ọnọmhuẹ, iiye, lẹsẹ ngme oni ungmemhi tsẹ, khi ọni ọọ ga mhẹ ọ ya ze. Irari khi mhia fu tẹ ni u wa bhale apfẹ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mhẹmhẹ oyẹmhẹ, mhi li mhọli ekhọli-okhuẹ eni e fu dọsẹ mhẹ, mhi li mhuẹ elese ni mhia mhẹsẹ na. Mhi kha gueyẹ ọna ọ ke lẹ, ọọ lẹ, mhiẹ ọlese ọ bhale, ọ bhale. Mhi khẹ ọni ọọ ga mhẹ ọ li ona, ọ li ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Abi iJesu ọ rọ suọ emini ọni ọmọse ọ ngme, abọ e sha li. Ọọ eni ẹ deba li, “Abi o li mhi li gue ọli ẹ yẹ ẹ ena khi mhia mẹ irudunga onabi onana ghue ekẹ iZirẹni. ");
INSERT INTO atgNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mhi gueyẹ ẹ khi ebubu ẹgbọ e ya rọte obini ovọ o te ẹ ngale ali obini ovọ o te ẹ lo eko, bhale ya nu Aburaamu ali Aziki ali iGiekọpu shitọ ukue na eghiele na iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama ẹgbọ ni é khá lá iloghie, a ya pfi wẹ je ekẹ alo ebili ni e la ke viẹ, ẹẹ le akọ akọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","IJesu ọọ ọni ọkhọli-okhuẹ ọghọ, “Ke je khi o ya lighọ nẹ abi u li mhọli irudunga eghọ.” Ighọ ọni ọọ ga li ọ ze oni ẹghẹghẹ ni iJesu ọ la ngme ọli ighọ tee. ");
INSERT INTO atgNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Abi iJesu ọ rọ bhale apfẹ oyi iPita, ọ mẹ khi ọgọ iPita ni ọkpotso ọ yẹshi khi ọọ ghu ughuamhi iba. ");
INSERT INTO atgNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","IJesu ọ ri obọ ti ọli, eni iba e lase ọli egbe le. Ọ vule ọ fẹli ọli epfẹse. ");
INSERT INTO atgNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Abi ogbọmhi o rọ mu ekẹ, ebubu ẹgbọ e wolọ eni e mhọli ayẹmhẹ ebe ọdọda bhale ghi iJesu. Ighọ iJesu ọ ri ungmemhi unu khu wẹ eni ayẹmhẹ ebe eghọ egbe ku a. Ọ gbo ri eni ẹẹ ghua nya ze. ");
INSERT INTO atgNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Eri a mẹ enana ni ungmemhi ni Azaya ọmekẹguele ọ ngme o bhale ya tsẹ; Ni ọọ, “Lọlighuo ọ mie awa umha-ze, ọ tsua ighuamhi eyawa ya kua.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","IJesu ọ mẹ olele ẹgbọ ni e le gasẹ ọli, ọọ e zẹ ni wẹwẹ e da je ukiẹkiẹ obini o kpọle oyi okẹ oniẹmhi iGalili. ");
INSERT INTO atgNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ọsẹsẹ Ishi eyi iMosisi ọghuo ọ bhale deba li ọọ li, “Ọsẹsẹ, mhi ya debẹ ke je obiobini wa je kpa.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","IJesu ọ sọli ọ, ọọ li. “Inyakọ e mhọli esẹ, ipfeli e mhọli eko, ama Omi Ọgbọ ọa mhọli ashini ọ de ukhomhi ẹ gbe.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ọmọse olese ni ọ khi ọmọ odukhokho oyọli, ọ lu ọli, ọọ li, “Ọsẹsẹ, zẹ mhẹ kpẹ je apfẹ ya ri itamhẹ ni ọ ghu-a tọ ne.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","IJesu ọ sọli ọ, ọọ li “Ke deba mhẹ, zẹ ni eni e ghu-a e ri eni e ghu-a tọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","IJesu ọ lo elemhi ọkọ-okẹ oniẹmhi, eniyẹ odukhokho eyọli e li lo deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Utoghuo-kpe, akpekpeli oniẹmhi oo li oni ukhomhi okẹ oniẹmhi. Ukuku emhi o kpọle dẹnẹ ni oni ọkọ-okẹ oniẹmhi ọa rọ ku luẹ. Ama iJesu ọọ lesẹ-a ");
INSERT INTO atgNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eniyẹ odukhokho eyọli e ya guise ọli le, ẹ ọli, “Ọnọmhuẹ, tsumhi anye! Awa ya pfua!” ");
INSERT INTO atgNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ọọ wẹ, “Elọ o zẹ ni a rọ lina na ulishi, Eri irudunga oyẹẹ oo na bẹshi shẹ?” Ighọ ọ vule nu oni akpekpeli ngme, oni okẹ o de ma. ");
INSERT INTO atgNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abọ e sha ẹgbọ nya ni e la aghọ, e mhila, “Ọgbọ nabisẹ ọnana ọ khi, egbegbi ozughu oyi okẹ oniẹmhi ali akpekpeli e ga suọ esọ ọ na li.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Abi iJesu ọ rọ da je ukiẹkiẹ obini o kpọle oyi okẹ oniẹmhi iGalili obini iGadara, emọse ava ni e rọte atalimhi lasele e bhale deba li. Eni emọse ava ena e mhọli ayẹmhẹ ebe ni e yẹsẹ wẹ ngme ni o rẹwẹ nono ingme. Ẹgbọ ẹa ke gbudu rọte oni odẹ dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eni ayẹmhẹ ebe eghọ ni e la eni emọse egbe, e tsẹsẹ utoghuokpe, ẹ ọli, “Elọ e ku anye ali yẹyẹ gbe, yẹyẹ Omi Ẹshinẹgba? Eri u bhale ya nasẹ anye neni oni ẹghẹghẹ o ramhi?” ");
INSERT INTO atgNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Igulu ni e bu é la epfẹ aghọ le eminale. ");
INSERT INTO atgNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ighọ eni ayẹmhẹ ebe eghọ e lema iJesu, ẹ ọli, “Ini u khu anye ya fiẹ, khu anye ya lo eni igulu eghọ egbe.” ");
INSERT INTO atgNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ighọ iJesu ọọ, “A ke vu!” Ighọ e lasele ya lo eni igulu egbe. Eni igulu nya e na ya tiemhi esesọ oni ute, ya lo oni okẹ, e ghuloa. ");
INSERT INTO atgNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Emọse ni e ri eni igulu u kia, e na kua, e je ifui apfẹ ya guele emini a mẹ ali emini eni emọse ni e mhọli ayẹmhẹ ebe e mẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ighọ ẹgbọ ni e la oni ẹoli nya e fiẹ lasele deba iJesu. Abi e rọ mẹ ọli, e lema li ọ kpẹkpẹ ọ lase wẹwẹ ekẹ le. ");
INSERT INTO atgNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","IJesu ọ̀ lo ọkọ-okẹ oniẹmhi, ọ́ da oni okẹ iGalili mu egbe pfi je ukiẹkiẹ obini o kpọle, ọ́ bhale apfẹ oyọli obini iKapanọmu. ");
INSERT INTO atgNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Emọse eghọ e tsua ọmọse ni ọ guọghọ-a shi iya bhale. Abi iJesu ọ rọ mẹ irudunga oyẹwẹ, ọọ ọni ọmọse ni ọ guọghọ-a, “Ri obọ shi udu, omimhẹ, a she ri olamhẹ topfa ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ighọ esẹsẹ Ishi eyi iMosisi eghuo e nu egbe wẹ ngme, e liẹ, “Ọni ọmọse ọna ọ pfi unu-a!” ");
INSERT INTO atgNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","IJesu ọ lẹsẹ usamhi ni ẹ sa, ọ mhila wẹ, “Elọ o zẹ ni a rọ sa isamhi ebe udu? ");
INSERT INTO atgNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Onoghuo o kẹlẹ mhẹ ya ngme ọni ọmọse nẹ? Ni mhi liẹ, ‘A she gbe olamhẹ kua nẹ,’ Ali ‘Vule ke kia?’ ");
INSERT INTO atgNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama, ni a rọ lẹsẹ khi Omi Ọgbọ ọ mhuẹ afu elemhi ekẹ agbọ ni ọ rọ gbe olamhẹ kua na ọgbọ.” Ighọ, ọọ ọni ọmọse ni ọ guọghọ-a, “Vule, rue iya oyẹ u ke je apfẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ighọ ọni ọmọse ọ vule ọọ je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Abi eni ebubu ẹgbọ e rọ mẹ ona, abọ e sha wẹ. E kuẹghiẹ Ẹshinẹgba ni ọ ri afu onana na ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Abi iJesu ọ rọte aghọ je odalo, ọ mẹ khi ọmionoga ọghuo ni a lu iMatiu, ọ shitọ okholo ni a la miono oga. Ọọ li, “Deba mhẹ.” Ighọ ọ vule deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Abi iJesu ọ rọ la owa oyi iMatiu le eminale, emionoga eni e bu elese ali ena olamhẹ e bhale ya ku ma wẹ ọ, e ga nu ọli ali eniyẹ odukhokho eyọli le eminale. ");
INSERT INTO atgNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Abi ẹgbọ iFarisi eghuo e rọ mẹ ona, e mhila eniyẹ odukhokho eyọli, ẹẹ, “Elọ o zẹ ni ọsẹsẹ oyẹ ẹ ọ rọ nu emionoga ali ena olamhẹ ẹ le eminale?” ");
INSERT INTO atgNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","IJesu ọ suọ ona, ọọ wẹ, “Ọni ọ toto ọa mhuẹ emini ọ ri ọbo ẹ li, ama ọni ọ́ọ́ to ọọ ye apfẹ ọbo. ");
INSERT INTO atgNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","A ka wẹna emini a ri ona ngme, ikhi, ‘Ọa khi iluasobo e ghọle mhẹ, ama isomhelemhi’ Ọa khi ẹgbọ eni e pfuasẹ ne mhi bhale ya lu e mu pfi, ama ẹgbọ ena olamhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Eniyẹ odukhokho eyi iJọni Ọni ọọ batazi ẹgbọ, e bhale deba iJesu, e mhila li, “Elọ o fẹ zẹ khi anye ali ẹgbọ iFarisi, khi anye ẹ pfi azumhi ni eniyẹ odukhokho eyẹ ẹa rọ pfi?” ");
INSERT INTO atgNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","IJesu ọọ wẹ, “Emọle ọmọse ni ọọ rue ọmueshi ọnọgbọ e famhi ya mhuẹ iyese udu-a ini ọni ọọ rue ọmueshi ọ kie la wẹ iteva? Ẹghẹghẹ ọọ bhale ni a rọ ya rue ọni ọmọse ni ọọ rue ọmueshi ọnọgbọ iteva oyẹwẹ vu, ẹghẹghẹ aghọ e rọ tigbe ya ke pfi azumhi. ");
INSERT INTO atgNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ọgbọ ọa ya gbẹla ode onogbọ toma onodiọ, ini a mẹ ghọ, onodiọ oghọ o ya nyanọ-a toma onogbọ, o fia esẹ ni o ke fu nẹ shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","U kẹ neta khi eri ọgbọ ọ ya ku onyọ onogbọ kulo akpaba ẹkuẹ ẹlamhi onodiọ, ini a mẹ ghọ, eri oni akpaba o ya vẹ-a, oni onyọ o ku kua, oni akpaba onyọ o li opfu-a. Onyọ onogbọ a ku ẹ shi akpaba onogbọ, ẹghẹghẹ aghọ, oni onyọ ali oni akpaba onyọ e ga migha.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Abi oni ungmemhi o kie la iJesu unu, ọkhẹmhuẹ iJu ọghuo ọ bhale ya wugha li odalo, ọọ li, “Kpẹkpẹ bhale ya ri obọ ti omimhẹ ni ọ lẹsẹ ghu-a, ni ọ guale.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ighọ iJesu ọ vule deba li vu, eniyẹ odukhokho eyọli e li deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ighọ ọkpotso ọghuo ni ọlia e she ku ọli egbe ramhi ikpe igbẹva ọ rọte ukhokho ti mama iJesu, ọ ri obọ ti ọli esọ ode. ");
INSERT INTO atgNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Itobọ khi ọ she ngme ọli shi udu khi, “Mhi kha da lẹsẹ ri obọ ti iJesu ode tsẹ ne, mhi ya ze.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ighọ iJesu ọ mu egbe nyenẹ, ọ mẹ ọli, ọọ li, “Kpotso khi ke zẹ ni ulishi o muẹ irudunga ni u mhuẹ o she rẹ ze.” Aghọaghọ ọni ọkpotso ọ ze. ");
INSERT INTO atgNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Abi iJesu ọ rọ ramhi owa oyi ọni ọkhẹmhuẹ, ọ bhale ya ẹ khi ẹgbọ e la aghọ. Ee viẹ ọni ọmueshi ni ọ ghu-a eghọ. Aghọ oo li nyoghoo. ");
INSERT INTO atgNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ọ gueyẹ ọgbọkpa ọ lase aghọ le, khi ọni ọmueshi ọa ghu ne khi eri ọ lesẹ-a. Eni ẹgbọ e suọ ungmemhi ni ọ ngme, ee gia li. ");
INSERT INTO atgNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Eni ẹgbọ e fiẹ je olase se, iJesu ọ lo elemhi oni owa, ọ mu ọni ọmueshi obọ, ọni ọmueshi ọ vule. ");
INSERT INTO atgNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Okeke oni ingme ona o gbhiaku asha kpa oni ẹdẹli. ");
INSERT INTO atgNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","IJesu ọ ke rọte aghọ vu je odalo, ezalo ava e deba li. Ee tsẹsẹ lema li, e liẹ ọli, “Mhuẹ isomhelemhi na anye, omi iDefidi.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Abi iJesu ọ rọ lo elemhi oni owa, eni ezalo ava e bhale deba li. Ọ mhila wẹ, “A miesuọ khi mhi ya dobẹ rẹ ẹ ze?” Ẹ kẹ ọli, “Guẹguẹguẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ighọ iJesu ọ ri obọ ti wẹ alo, ọọ wẹ, “Alo eyẹ ẹ e khueghie-a abi a mhuẹ irudunga.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ikpamhi alo eyẹwẹ e khueghie-a. IJesu ọ tse agua yẹ wẹ e khi gueyẹ ọgbọkhọghuo emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama asha ni e ramhi kpa, eri e gueyẹ ẹgbọ, e gue ingme oyi iJesu yẹ ẹgbọ asha kpa. ");
INSERT INTO atgNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Eni emọse e vu, a tsua ọmọse ọghuo ni ọ mhuẹ ayẹmhẹ ebe bhale, ni ọa li ngme unu. ");
INSERT INTO atgNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","IJesu ọ khu ọli oni ayẹmhẹ ebe oghọ egbe ya lase, ọni ọmọse ọ ngme. Abọ e sha ọgbọkpa e liẹ, “Anye ẹa kpẹ mẹ ingme onana ghue ekẹ iZirẹni.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama ẹgbọ iFarisi e liẹ khi oghie ọyi iyẹmhẹ ebe ọ ri ekpabọ na li. Lọli o zẹ ni ọ rọ dobẹ ẹ khu ẹgbọ ayẹmhẹ ebe egbe-a. ");
INSERT INTO atgNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","IJesu ọ kia la ẹoli khi ẹoli sẹsẹ ungmemhi oyi Ẹshinẹgba elemhi owa ugamhi eyẹwẹ, ọ tse abọ usomhi onete oyi Eghiele oyi Ẹshinẹgba. Ọ ri ẹgbọ ni e mhuẹ ighuamhi khi ighuamhi i ze. ");
INSERT INTO atgNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Abi ọ rọ mẹ eni ebubu ẹgbọ, elemhi wẹ e lala li irari khi udu oyẹwẹ ọa sheshe itobọ khi ẹa mhọli ọni ọọ kpaghiẹ wẹ obọ, abi isumha ni ẹa mhuẹ ọrẹwẹkia. ");
INSERT INTO atgNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ọ gueyẹ eniyẹ odukhokho eyọli, “Oni ikhiẹsẹ oo gbẹdi gba, ama khi eni ẹ khiẹsẹ wẹ, ẹa bu.” ");
INSERT INTO atgNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","“A sọ iromhi, ni Ẹshinẹgba ọni ọ mhuẹ ikhiẹsẹ, ni ọ ghie eni e ya khiẹsẹ oni ikhiẹsẹ fiẹ lasele.” ");
INSERT INTO atgNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","IJesu ọ lu eniyẹ odukhokho ogbava eyọli kugbe. Ọ ri afu na wẹ, e ke ya khu iyẹmhẹ ebe ọdọda ẹgbọ egbe-a, e gbo ri ẹgbọ ni e mhuẹ ighuamhi ọdọda ke ze. ");
INSERT INTO atgNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Eva eyi eni ighiusomhi na kẹẹ ogbava na. Ọni ododẹ khi ISamọ ni a gbolo o lu iPita, ali inyọghuo ọli, Aduru. IJemhisi ali inyọghuo ọli ni a lu iJọni ni e khi imi iZebedi. ");
INSERT INTO atgNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","IFilipu ali iBatolomiu. ITọmọsi ali iMatiu ni e khi emionoga. IJemhisi omi Afeusi ali iTadiusi. ");
INSERT INTO atgNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ISamọ ni ingme o ghọ mu egbe ali iJudasi Isikarọti ni ọ ri iJesu dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","IJesu ọ ghie eniyẹ odukhokho ogbava ena fiẹ, ọ tse agua yẹwẹ, ọọ wẹ, “A khi je ẹoli oyi ẹgbọ iJẹta wẹkhi ẹoli na ekẹ iSameria. ");
INSERT INTO atgNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ochoghọ a lẹ deba ẹgbọ iZirẹni ni e li abi isumha ni e waa. ");
INSERT INTO atgNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Abi a liẹ ke lẹ, a ke tse abọ usomhi ona-yẹwẹ, a liẹ wẹ, ‘Eghiele oyi Ẹshinẹgba o she ti bhale.’ ");
INSERT INTO atgNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","A ri ẹgbọ ni e mhuẹ ighuamhi ze, a ri eni e mhuẹ efafe ze, a guise eni e ghu-a le, eni e mhuẹ ayẹmhẹ ebe, a khu wẹ ẹwẹ egbe lasele. Afuẹ a ri eni ekpabọ ena na ẹ, a rẹ wẹ kpaghiẹ ẹgbọ obọ afuẹ, a khi mie ifata shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Abi a liẹ lẹ ena, a khi tsua ukpaghọ okhọghuo shi ọmọ-emhi. ");
INSERT INTO atgNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A khi tsua ẹkuẹ pfi sọ, wẹkhi itsua na rọ sọ elese, wẹkhi ekuẹ ni a sọ, wẹkhi ukpokpo na rọ a to ọkpọ, irari khi asha ni ọgbọ ọ la gbe aghọ ọ te ẹ le. ");
INSERT INTO atgNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ẹoli oni a da bhale kpa, a kushi ayi ọgbọ nọ da kpẹ abọ mie ẹ, ramhi ẹghẹghẹ ni a ya rọte aghọ vu. ");
INSERT INTO atgNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Neni a ya sọ ukhomhi owa okhọghuo, a kpe liẹ, ‘Opfọmhẹ o la oni owa ona.’ ");
INSERT INTO atgNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ini ẹgbọ ne la oni owa e kpe abọ mie ẹ, opfọmhẹ oyẹẹ o ka nu wẹ la, ama, ini ẹa mie ẹ, opfọmhẹ oyẹẹ o gbo nyenẹ deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ini a bhale ẹoli, khi ẹgbọ ne la oni ẹoli ẹa da kpe abọ mie ẹ ne, a kpe abọ ọ-a na wẹ ini a te ọ fiẹ lase. ");
INSERT INTO atgNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ogbẹlẹ iguẹzọ, mhi gueyẹ ẹ khi Ẹshinẹgba ọ ya mhọli isomhelemhi na ẹgbọ iSodomu ali iGomora dọsẹ oni ẹoli oghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A sato khi eri mhi ghie ẹ fiẹ lase abi isumha ne la ifuabọ idumhi. Irarighọ, a zẹ ni a lẹsẹ ingme abi ẹnyẹ, ama a mhuẹ ikuegbe-a abi anekhukhu. ");
INSERT INTO atgNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“A mu egbe ẹ tsukẹ, irari khi ẹgbọ e ya mu ẹ bhale ikọtu, odalo egbhali ni ẹẹ sọ ẹzọ. E gbe ẹ itali elemhi owa ugamhi eyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","E ya ri itobọ eva oyẹmhẹ muno e bhale deba igọvunọ ali enighie, ni a gue usomhi onete oyẹmhẹ yẹ wẹ. A gbo pfi ọtsẹlẹ oyẹmhẹ yẹ ẹgbọ iJu ali ẹgbọ iJẹta. ");
INSERT INTO atgNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A khi yele abi a ya ngme ali abi a ya sọ wẹ, ini e muno ẹ bhale agbala ẹzọ. Irari khi emini a ya ngme o ya bhale unu oyẹ ẹ ẹghẹghẹ ni a nono ọli shi. ");
INSERT INTO atgNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Irari khi ingmemhi ni a ya ngme, ẹa ya khi eyẹ ẹ. Ayẹmhẹ-nọ-pfuasẹ oyi Ẹshinẹgba ni ọ khi ita ẹ, ọ ya ri ungmemhi ni a ke ngme shi ẹ unu. ");
INSERT INTO atgNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ẹghẹghẹ na ngme ena, ẹgbọ e ya ri inyọghuo wẹ bhale ni a gbe-a, ita eniyẹ e wolọ imi wẹ bhale na gbolo-a, ighọ eniyẹ e li ya rue itawẹ bhale na gbe-a. ");
INSERT INTO atgNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ẹgbọ kpa e ya ke biselemhi ẹ shi irari oyẹmhẹ. Ama ọgbọ ni ọ da mu irudunga oyọli mhuẹ ramhi ukpẹsẹ ne, lọli a ya mie pfuese. ");
INSERT INTO atgNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ini a la asheghuo mu okhọli vule shi ẹ ọ, a na je ẹoli olese. Mhi zẹ ẹ lẹsẹ khi, aa ya gbe akanya ona pfo ne ekẹ iZirẹni neni Omi Ọgbọ ọ nyenẹ egbe ẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ọmọ odukhokho ọa lẹsẹ dọsẹ ọga ọyọli, wẹkhi eri ọni ọọ ga ọgbọ ọ ya fu dọsẹ ọga ọyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ọmọ odukhokho ọ dobẹ ya li abi ọga ọyọli, ọni ọọ ga ọgbọ ọ ya dobẹ li abi ọga ọyọli. Ini a lu ọdapfẹ iBezebọ, sẹẹ a ke bẹshi ẹ lu eni e la oni ọmhuẹ-apfẹ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Itobọ ighọ a khi zẹ ni ulishi o mu ẹ irari khi aa mẹ emini a gba khukhu ni ọa ya khueghie a, wẹkhi eri a mẹ emini o sheli ni ọa ya lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Emini mhi gueyẹ ẹ ẹliyọsẹ a ngme ọli lasele ini ogbe o gbe-a. Ungmemhi ni a bẹna gueyẹ ẹ, a la ukhomhi owa ngme ọli lase ni ẹgbọ e suọ gboo. ");
INSERT INTO atgNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A khi na ulishi ẹgbọ ni o khia khi idiegbe e lẹsẹ dobẹ ya gbe-a, ni ẹa dobẹ ya pfuse ọgbọ ayẹmhẹ-a. Ama a na ulishi oyi Ẹshinẹgba nọ kha gbe-a se ọ gbo mhuẹ ekpabọ rọ ya pfuse ayẹmhẹ-a elemhi ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","U lẹsẹ khi ukpaghuo a ri ipfeli otuava dẹ? Ama aa mẹ ọngẹwẹ ni ọ ya ghu-a ni Ẹshinẹgba ọa ya lẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ẹshinẹgba ọ she leli egbegbi itsu ni e la ẹ ukhomhi nya. ");
INSERT INTO atgNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Itobọ ighọ, a khi zẹ ni ulishi o mu ẹ, irari khi a mu ẹloe dọsẹ ipfeli ni e bububu. ");
INSERT INTO atgNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ọgbọ ni ọ da gue ungmemhi oyẹmhẹ yẹ ẹgbọ ne, mhi ya li gue ingme oyọli ye Itamhẹ ni ọ la iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama ọnini ọ da la ukpẹloe ẹgbọ kie mhẹ, mhi ya li kie ọli ukpẹloe oyi Itamhẹ na obini iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“A khi sa khi opfọmhẹ mhi rọ bhale ekẹ agbọ. Mhi aa rọ opfọmhẹ bhale, ama ọgbhọrọ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eri mhi bhale ya to okhuẹ na “ ‘Ọmọse ali itali, ọkpotso ali inyọli, ọsamọ ali inyọdọli. ");
INSERT INTO atgNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Unuẹkpẹ oyi ọgbọ, ebe ọli e la.’ ");
INSERT INTO atgNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ọgbọ ni ọ da nono ingme oyi ita okekhi inyọ dọsẹ ingme oyẹmhẹ ne, ọa ya dobẹ khi ọmọ odukhokho ọyẹmhẹ. Ọgbọ ni ọ da nono ingme oyi omi ọli dọsẹ mhẹ ne, ọa ya dobẹ khi ọmọ odukhokho ọyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ọgbọ ni ọa da kpha apfida oyọli tsua ni ọ ke deba ẹtẹ-awẹ oyẹmhẹ ne, ọa ya dobẹ khi ọmọ odukhokho ọyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ọni ọ da mu agbọ oyọli mhuẹ gagaga ne, o mema ya de ọli obọ-a, ama ọni rue agbọ oyọli obọ-a shi ekẹ itobọ oyẹmhẹ ne, ọ ya mẹ eleli agbọ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ọgbọ ni ọ da kpe abọ mie ẹ ne, mhẹmhẹ ọ kpe abọ mie. Ọni ọ da kpe abọ mie mhẹ, ọni ọ ghie mhẹ ọ kpe abọ mie. ");
INSERT INTO atgNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ọgbọ ni ọ da kpe abọ mie ọmekẹguele ọyi Ẹshinẹgba ne, ọ ya mhuẹ isomhopfa onayi ọmekẹguele. Ọni ọ da kpe abọ mie ọgbọ ni ọ pfuasẹ ne irari khi ọ da khi ọgbọ ni ọ pfuasẹ, ọ ya mhuẹ eleli oyi ọgbọ ni ọ pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ini ọgbọkhọghuo ọ diẹ amẹ ni e pfọmhẹ na ẹgbọ eni ẹa mu ẹloe ena da ne, irari khi e da khi eniyẹ odukhokho eyẹmhẹ, mhi gue ọ yẹ ẹ guẹguẹguẹ khi eleli oyọli ọa ya de ọli obọ a.” ");
INSERT INTO atgNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Abi iJesu ọ rọ gueyẹ eniyẹ odukhokho ogbava eyọli emini e ya riẹlẹ se, ọ je ẹoli ni e la ekẹ iGalili ya sẹsẹ, ọ gbolo tse abọ oni usomhi onete. ");
INSERT INTO atgNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Abi iJọni Ọni ọọ batazi ẹgbọ ọ rọ la owa ighumha suọ ikanya ni iKirisiti ọọ gbe, ọ ghie eniyẹ odukhokho eyọli ghi ọli, ");
INSERT INTO atgNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","E lẹ ya lina mhila li. “Yẹyẹ u khi ọni iJọni ọ ngme khi ọ ya bhale, abi anye ri ẹloe shi ekẹ ke khẹ ọgbọ ọlese?” ");
INSERT INTO atgNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","IJesu ọ sọ wẹ ọ, ọọ wẹ, “A nyenẹ egbe ya gueyẹ iJọni emini a suọ ni a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ezalo ẹẹ khueghie alo-a, eni e guọghọ awẹ-a, e vule ẹẹ kia, a ri eni e mhuẹ ighuamhi ẹkuẹ idiegbe ọdọda ze, elesọ ẹẹ suọ esọ, ẹgbọ ni e ghu-a, a guise wẹ le. A gbolo ẹ tse abọ usomhi onete yẹ ẹgbọ eni ẹa mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ikhivọsẹ o khi na ọgbọ ni ọa mhọli akhọkhọmhẹ shi ingme oyẹmhẹ!” ");
INSERT INTO atgNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eniyẹ odukhokho eyi iJọni ee vu se, iJesu ọọ ngme ingme oyi iJọni khasẹ eni e legba. Ọ mhila wẹ, ọọ. “Abi a rọ fiẹ je ọdagbe ifufu ni a rọ ya bino iJọni, ọgbọ nabisẹ a dabi khi a ya mẹ? Ebuli ifulọ ni akpekpeli ọ pfi ẹ nga pfi ẹ tiemhi a dabi khi a ya mẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ini ọa khi ighọ shọ, elọ a dabi khi a ya mẹ abi a rọ fẹ fiẹ lase? Ọmọse ni ọ sọ itsua eni e somhi otse a sa khi a ya mẹ? Iiye o! Ẹgbọ eni ẹẹ sọ itsua eni e somhotse, apfẹ oyi oghie ẹẹ la. ");
INSERT INTO atgNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Elọ a fẹ fiẹ lase khi a ya mẹ shọ? Ọmekẹguele? Guẹguẹguẹ, ama mhi gueyẹ ẹ, ọni ọ gbo fu dọsẹ ọmekẹguele a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","IJọni ọ khi ọni ọgbọ ni Ebe-no-pfuasẹ o ngme ingme oyọli, ni Ẹshinẹgba ọ la liẹ, “ ‘Mhi ya kpẹ ghie aghiusomhi ọyẹmhẹ ralo nẹ, ni ọ ya khueghie odẹ-a nẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Abi o li mhi li gue ọli yẹ ẹ khi, iJọni ọ fu dọsẹ ọgbọkpa ni ọ la agbọ ona ghue, ama, ọgbọ ni ọ ga kpọkẹ nya obini Eghiele oyi Ẹshinẹgba, ọ fu dọsẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Rọte ẹghẹghẹ oyi iJọni Ọni ọọ batazi ẹgbọ ya ramhi ogbe na amo, Ẹshinẹgba ọ te ẹ ri ikakabọ mhọli omhẹsẹ oyọli shi agbọ oyi ẹgbọ, ama ikakabọ ẹgbọ e ke rọ ọ lo ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Irari khi emekẹguele nya ali Ishi eyi iMosisi, e mẹ guele shi ekẹ ramhi ẹghẹghẹ oyi iJọni. ");
INSERT INTO atgNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ini a ya lama shi ọ, iJọni ọ khi ọni Elaja ni ẹ khi ọ ya nyenẹ egbe bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A mhọli esọ, a suọ emini mhia gueyẹ ẹ, ni a rọli gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Elọ mhi ri agbhotu ona ya khọkhọ? Eri e li abi ikuku eniyẹ ni e shitọ epfepfẹ oki ni e lu egbe wẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Anye pfi ofele na ẹ, aa lama gbe ishimhi, anye to uwolo ni a rọ viẹ olimhi shi ẹ ọ, ama aa lama viẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Abi iJọni ọ rọ bhale, eri ọọ pfi azumhi, ọa lama da onyọ, irarighọ ẹgbọ e liẹ khi, ‘Ayẹmhẹ Ọkphaghiẹ oo nasẹ ọli.’ ");
INSERT INTO atgNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ama Omi Ọgbọ ọ ke bhale, ọọ le ọọ da, ẹgbọ kpa e kẹ liẹ khi, ‘Ọgbọ unu-emhi ali ọdonyọ ọ khi, ni ọ nu emionoga ali ena olamhẹ ẹ mu ọmọle.’ Emini Ẹshinẹgba ọọ riẹlẹ, o ri ilẹsingme oyọli ẹ khasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ighọ iJesu ọ li zẹ ẹmuẹbe na ẹgbọ ni e la ẹoli ni ọ la gbe ikanya ọnyaloa ebubu eyọli, itobọ khi ẹa mu pfi, ọọ li. ");
INSERT INTO atgNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Epfua o khi nẹ, iKorazi! Epfua o khi nẹ, iBẹtisaida! Irari khi ini ikanya ọnyaloa ni a gbe ifui ẹoli eyẹ ẹ khi a li gbe wẹ iTai ali iSidọni lọ, e kha she viẹ osoli na egbewẹ shi olamhẹ eyẹwẹ, e te olamhẹ eyẹwẹ mu pfi agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ama mhi gueyẹ ẹ khi, o ya somhi iTai ali iSidọni egbe dọsẹ ẹ, ogbẹlẹ isọ-ẹzọ ");
INSERT INTO atgNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yẹyẹ iKapanọmu, eri a nono ni a ya yasẹ ẹ nga idane ramhi irarogbe? Iiye o! Eri a ya pfi ẹ tiemhi ọọkẹ ilimhi iriẹriẹ. Irari khi ini ọnyaloa ni a gbe khasẹ ẹ khi a gbe wẹ ekẹ iSodomu lọ, o kha la ọ ramhi amo. ");
INSERT INTO atgNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ama mhi gueyẹ ẹ khi o ya somhi iSodomu egbe dọsẹ ẹ, ogbẹlẹ isọ-ẹzọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ẹghẹghẹ aghọ iJesu ọ liẹ, “Ita, Ọnọmhuẹ, ni ọ mhuẹ ekẹ ali ukhuli, mhi tsẹ uwegbe khi emini u rọ sheli na eguebe, ali eni e fialo-a, khi u rẹwẹ khasẹ ẹgbọ ni ẹa mu ẹloe. ");
INSERT INTO atgNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ighọ, Ita, ina o li ghọle ẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Itamhẹ ọ she ri emhikpa nga mhẹ obọ. Ọgbọkhọghuo ọa la ọ, ni ọ lẹsẹ ọni Ọmọ, sẹ ni Ita. Ọgbọkhọghuo ọa la ọ ni ọ lẹsẹ Ita sẹ ni ọni Ọmọ, ali eni ọni Ọmọ ọ lama ri ọni Ita khasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“A bhale deba mhẹ, ẹẹ nya ni a tsua itsua ni ẹẹ khọsẹ ẹ, mhi ya ri iyẹmhẹa na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","A ri egbe mie emini mhiẹ a ke riẹlẹ, a rọte obọ oyẹmhẹ wẹna, itobọ khi mhii pfọmhẹ gba, ali khi udu oyẹmhẹ o mhọli iriegbe-tiemhile, ni a mhuẹ iyẹmhẹa. ");
INSERT INTO atgNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Irari khi emini mhia liẹ a riẹlẹ oni o zẹ ẹ riẹlẹ yẹghẹlẹ lọ, ali khi eri itsua eyẹmhẹ ee fuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ẹghẹghẹ ni a ngme ena, iJesu ọ rọte ifui ishemhi iakpa dọsẹ ẹlẹ iyẹmhẹa. Okiamhi oo gbe eniyẹ odukhokho eyọli. Ighọ e li bẹ eni iakpa, e le wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Abi ẹgbọ iFarisi e rọ mẹ ona, ẹ ọli, “Ghe khẹ! Eniyẹ odukhokho eyẹ ẹẹ riẹlẹ emini Ishi eyi iMosisi ọa lama shi a riẹlẹ ẹlẹ iyẹmhẹa.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ọ sọ wẹ ọ, ọọ, “Aa she kpe zẹ emini iDefidi ọ riẹlẹ abi okiamhi o rọ gbe ọli ali apfọli? ");
INSERT INTO atgNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Eri ọ lo elemhi owa oyi Ẹshinẹgba, lọli ali apfọli, e ya rue ibulẹdi oni o pfuasẹ le, ni ushi ọa lama shi e le. Oni ibulẹdi ona, ekpodalo-ugamhi eyi Ẹshinẹgba tsẹ, e lẹsẹ le ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Abi khi aa rọte ebe ushi iMosisi zẹ ọli khi ekpodalo-ugamhi eyi Ẹshinẹgba ni e la Owa Oyi Ẹshinẹgba, ee gbe ushi-a ogbẹlẹ iyẹmhẹa, ama ọgbọ ọa rọ mu ota sọ wẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ama mhi gueyẹ ẹ khi ọgbọ ni ọ fu dọsẹ Owa Oyi Ẹshinẹgba ọ la ana. ");
INSERT INTO atgNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ini a lẹsẹ emini a ri oni ungmemhi ona ngme shi Ebe-no-pfuasẹ lọ, ni ọọ, ‘Ilẹlemhi o ghọle mhẹ, ọa khi iluasobo,’ aa kha ke pfa ẹzọ mu eni ẹa lue. ");
INSERT INTO atgNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Irari khi mhẹmhẹ Omi Ọgbọ mhi khi Ọnọmhuẹ ọyi ogbẹlẹ iyẹmhẹa.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Abi iJesu ọ rọte aghọ vu, ọ lo elemhi owa ugamhi oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ighọ ọmọse ọghuo ni ọ chẹghẹlẹ obọ oghuo-a, ọ la akaghọ. Ẹgbọ eghuo e la aghọ ni e nono ni wẹwẹ e mu ingme shi iJesu egbe, ighọ e mhila li. Ẹ ọli, “O fẹ ti ni a ri ọgbọ ze ẹlẹ iyẹmhẹa?” ");
INSERT INTO atgNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","IJesu ọọ wẹ, “Ini ọngẹẹ ọ fẹ mhọli osumha, ni ọ rọ de pfilo atekẹ ẹlẹ iyẹmhẹa, wa a ya fẹ mu ọli ọ lasele? ");
INSERT INTO atgNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ọgbọ ọ mu ẹloe dọsẹ osumha! Irarighọ, Ishi eyi iMosisi o lama shi ọ, ọgbọ ọ riẹlẹ onete ogbẹlẹ iyẹmhẹa.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ighọ ọọ ọni ọmọse ni ọ chẹghẹlẹ obọ oghuo a eghọ, “Nise obọ oyẹ-a.” Ighọ ọ nise ọli-a. Oni obọ o na ya to abi onokpọle ");
INSERT INTO atgNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ighọ eni ẹgbọ iFarisi e fiẹ ya ye ugbamhi abi e li ya gbe iJesu-a. ");
INSERT INTO atgNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Abi iJesu ọ ke rọ lẹsẹ ugbamhi ni e gba, ọ rọte aghọ vu je oboese, ebubu ẹgbọ e deba li. Ọ ri eni e mhọli umha-ze nya ze. ");
INSERT INTO atgNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ọ tse agua yẹ wẹ e khi gueyẹ ẹgbọ ọni lọli khi. ");
INSERT INTO atgNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eri a ri ona ri ungmemhi ni Azaya ọmekẹguele ọ ngme bhale ya tsẹ, ni ọ la liẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ọni ọọ ga oyẹmhẹ ni mhi zẹ na, ọni mhi nono ingme oyọli, ni ọ ri egbe ẹ mu mhẹ, mhi ya ri Ayẹmhẹ oyẹmhẹ shi ọli egbe, ọ ya ri iguẹ-sọ-ẹzọ oyẹmhẹ khasẹ ishishi nya. ");
INSERT INTO atgNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ọa ya nu ẹgbọ wola wẹkhi eri ọ ya tsẹsẹ ni ọgbọ suọ ifui apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ọ ya kuegbe-a nu eni ẹa mhuẹ ekpabọ ngeli, abi a li kuegbe-a mu ọakpa ni akpekpeli o pfigbe vule. Ọ ya lẹ elemhi eni ẹẹ nono ikpaghiobọ, abi ọgbhali ọa liẹ la apfẹ ni amẹ o gbe erali ni o la umutse pfuse-a, ya ramhi ni ọ rọ ri iguẹ-sọ-ẹzọ leghie. ");
INSERT INTO atgNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Itobọ ighọ ẹgbọ iJẹta nya e rọ regbenga eva oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ighọ ẹgbọ eghuo e rue ọmọse ọghuo ni ọ mhọli ayẹmhẹ obe bhale ghi iJesu. Ọ zalo ọ gbo khi ungmenu. IJesu ọ ri ọni ọmọse ze. Ọọ ngme, ọ gbolo ẹ mẹ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ighọ abọ e sha eni ẹgbọ nya, e mhila, e liẹ, “Abi khi iJesu ọna ọ khi Ọni Ọmiepfuese omi iDefidi ni ẹ khi ọ ya bhale?” ");
INSERT INTO atgNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Abi ẹgbọ iFarisi e rọ suọ ona, e kẹ, “Ekpabọ eyi iBezebọ ni ọ khi oghie ọyi iyẹmhẹ ebe nya, ọ rọ khu ẹgbọ iyẹmhẹ ebe egbe lasele.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","IJesu ọ she lẹsẹ usamhi oyẹwẹ, ọọ wẹ, “Eghiele ni o da kemhi shi iku-iku ni o nu egbewẹ ẹ khọli ne, eri o ya pfua. Ighọ khi ẹoli ali unuẹkpẹ ni e kemhi egbe nu egbewẹ ẹ khọli, ẹa dobẹ ya migha. ");
INSERT INTO atgNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ini Ọkphaghiẹ ọọ khu Ọkphaghiẹ lase, ọ she kemhi egbọli. Sẹẹ eghiele oyọli o ke li dobẹ ya migha? ");
INSERT INTO atgNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ini mhi ri ekpabọ eyi iBezebọ ẹẹ khu ẹgbọ ayẹmhẹ ebe egbe a, ekpabọ eyi ọghuo ẹgbọ eyẹ ẹ e rọ khu wẹ kua? Emini eni ẹẹ deba ẹ ẹẹ riẹlẹ o rọkhasẹ khi aa rọte odẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama ini o khia khi Ayẹmhẹ oyi Ẹshinẹgba mhi rọ ọ khu ayẹmhẹ ebe kua, lọli o rọkhasẹ khi Ẹshinẹgba ọ she ẹ mhẹsẹ shi ẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ọghuo ọ fẹ lẹsẹ ya vule, ọ dọsẹ lo apfẹ oyi ọmọse akama ya tsua li itsua vu. Ọa khi eri ọ kpẹ ya gẹ ọli shi ekẹ? Ọ tigbe dobẹ tsua li itsua owa? ");
INSERT INTO atgNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ọni ọa da nu mhẹ la ne, eri ọ biselemhi mhẹ, ali khi ọni ọa da nu mhẹ ti ẹ gbili ne, eri ọ miatsẹ ku a. ");
INSERT INTO atgNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Irarighọ, mhi gueyẹ ẹ khi, a ya ri olamhẹ ali ungmemhi ipfiunu-a nya topfa ọgbọ, ama aa ya tigbe ri ungmemhi ipfiunu-a ni a ngme deba Ayẹmhẹ-nọ-pfuasẹ topfa ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","A ya dobẹ rọ topfa ọnini ọ da pfi unu-a deba Omi Ọgbọ, ama aa ya rọ topfa ọni ọ da pfi unu-a deba Ayẹmhẹ-nọ-pfuasẹ, elemhi agbọ ni a la memena, ghe agbọ ni o ke ẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ri ẹloe khu ọara, o ya mọ umọmhi onete, ini u waa ri ẹloe khu ọara, o mọ umọmhi ni ọa ti. Irari khi umọmhi oyi ọara a te ẹ lẹsẹ emini oni ọara o khi. ");
INSERT INTO atgNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sẹẹ ẹẹ ẹgbọ ebe ni a khọlọ abi ẹnyẹ afue, a liẹ ngme ungmemhi onete unu? Usamhi ni e vọ ọgbọ udu o rọli ẹẹ ngme ungmemhi rọte unu lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Udu onete ọgbọ ọnete ọ te ẹ ngme ungmemhi onete lasele. Ighọ ungmemhi obe o li rọte udu oyi ọgbọbe ẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ama a lẹsẹ khi ọgbọgbọ ọ ya zọnọ abi ọ li ngme ungmemhi afuẹ unu lasele ogbẹlẹ isọ-ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Irari khi ungmemhi unu oyẹ a rọ ya pfa ẹzọ nẹ, ungmemhi unu oyẹ a gbo rọ ya pfa ẹzọ mu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ighọ ẹgbọ iFarisi ali esẹsẹ Ishi eyi iMosisi eghuo ẹẹ iJesu, “Ọsẹsẹ, ri ọlẹlẹ ọnyaloa oghuo khasẹ anye.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ọ sọ wẹ ọ, ọọ, “Ẹẹ ẹgbọ ọkhọlọ ni aa ri igẹsikia ga Ẹshinẹgba.” Àá mhila mhẹ ọlẹlẹ ọnyaloa? Ọgbọkhọghuo ọa ya ri ọlẹlẹ okhọghuo khasẹ ẹ, sẹẹ ni onabi a rọkhasẹ oyi iJona ọmekẹguele. ");
INSERT INTO atgNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Irari khi abi iJona ọ li la elemhi oyi afẹlẹ ogbẹlẹ esẹ ẹlẹ ọguota ali ẹlẹ iyọsẹ, ighọ Omi Ọgbọ ọ li ya li la elemhi ekẹ ogbẹlẹ esẹ, ẹlẹ ọguota ali ẹlẹ iyọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ẹgbọ iNinevẹ e ya mu ẹzọ vule shi ẹ ẹgbọ agbhotu ona ọ ogbẹlẹ iguẹzọ, irari khi e mu nyenẹ abi iJona ọ rọ tse abọ ungmemhi oyi Ẹshinẹgba yẹ wẹ. Ama memena, ọni ọ ga fu dọsẹ iJona ọ la akana, ama aa lama mu pfi. ");
INSERT INTO atgNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Oghie-ọkpotso ọyi ekẹ iShẹba ọ ya mu ẹzọ vule shi ẹ ẹgbọ agbhotu ona ọ ogbẹlẹ iguẹzọ, ọ pfa ẹzọ mu wẹ. Itobọ khi ọọ rọte obini odonuẹ bhale ya ri esọ kpẹ osẹsẹ ilẹsingme oyi iSolomoni. Ama memena ọni ọ fu dọsẹ iSolomoni ọ la akana, ama aa lama pfi esọ shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ini ayẹmhẹ ebe o rọte ọgbọ egbe lasele, eri ọ kpẹ je ekẹ okhakha ya dudu kia nono ashini ọ je ya yẹmhẹ-a. Ama ini ọa mẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ọ gueyẹ egbọli, ‘Mhi ya nyenẹ egbe ukhokho je owa ni mhi kpẹ te vu.’ Ini ọ nyenẹ egbe bhale aghọ ni ọ rọ ya ẹ khi aghọ o gboo, khi asha kpa oo pfuasẹ nguẹnẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ẹghẹghẹ aghọ, ọ fiẹ je olase ya rue ayẹmhẹ ebe ishilua elese ni e khọlọ dọsẹ ọli bhale ya lo aghọ, e la aghọ. Ẹghẹghẹ aghọ, ikpukhokho oyi ọni ọgbọ ọghọ o ke ya khọlọ dọsẹ abi o kpẹ li. Ighọ o ya li ẹ egbe ẹẹ ẹgbọ ọkhọlọ ena.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","IJesu ọ kie ghọ nu eni ebubu ẹgbọ ọ ngme, inyọli ali inyọghuo ọli e bhale. E migha olase, e nono ni wẹwẹ e nu ọli ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ọgbọghuo aghọ, ọọ li, “Inyẹ ali inyọghuo ẹ, e migha olase, ẹẹ nono ni wẹwẹ e nu ẹ ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","IJesu ọ sọli ọ, ọọ, “Eghuo e khi inyẹmhẹ ali inyọghuo-mhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ọ nise obọ ghue eniyẹ odukhokho eyọli, ọọ, “Enana e khi inyẹmhẹ ali inyọghuo-mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ọnini ọ da ri ungmemhi oyi Itamhẹ na iloghie gbe akanya, lọli ọ khi inyọghuo-mhẹ ọni ọmọse ali ọni ọkpotso ali inyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ẹlẹ ni a ngme ena, iJesu ọ fiẹ owa ya lase, ọ shitọ epfẹ okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ebubu ẹgbọ e le gasẹ ọli ramhi ni ọ rọ vu ya lo ọkọ-okẹ oniẹmhi shitọ, eni ẹgbọ nya e migha egele oni okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ọ ri okhẹ irọkhọkhọ gue emhi ebubu u yẹ wẹ, ọọ wẹ, “A ghe i! Ọghiale ọghuo ọ je ishemhi ya ku ikpamhi emhi. ");
INSERT INTO atgNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Abi ọ li i ku eni ikpamhi emhi eghọ, eghuo ọ e de kua epfẹ odẹ. Ipfeli e bhale ya sanọ wẹ le. ");
INSERT INTO atgNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eghuo ọ, e de nga ukhomhi ọkpegbhẹ, ni ọa mhuẹ ekẹ ni e bu. E nyanya zẹ. Ama itobọ khi oni ekẹ ọa mhuẹ ẹlamhi ni e pfi imhili lo, ");
INSERT INTO atgNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ovọ o gbolo wẹ-a. E khakha-a, irari khi ẹa mẹ asha pfi imhili lo ekẹ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ikpamhi eghuo ọ, e de kulo ashini igba e la. Eni igba e zẹ, e tono wẹ gbolo-a. ");
INSERT INTO atgNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ama ikpamhi eghuo, e de shi egbegbi ekẹ, e fu, e nyẹsẹ ekhẹ. Eghuo e ri imọmhi asha egbhuẹshe lasele, elese e ri asha egbhuẹsẹ lasele, enekpọle, asha uye ali igbe. Ẹghẹghẹ aghọ e ke ya bu dọsẹ emini a kpẹ rọ kọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","A zẹ esọ, a suọ emini mhia gueyẹ ẹ, ni a rọli gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Eniyẹ odukhokho eyọli e bhale deba li, e mhila li, “Elọ o zẹ ni u rọ ri okhẹ irọkhọkhọ ọ sẹsẹ eni ẹgbọ?” ");
INSERT INTO atgNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","IJesu ọọ wẹ, a she mhọli ilẹsẹ oyi osheli abi Ẹshinẹgba ọ she mhọli omhẹsẹ shi ẹ egbe, ama a rọli sheli wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ọnini ọ da kpẹ mhọli, a ya rọ ma ọ na li, ọ mhọli gbeku ọ. Ama ọni ọa mhuẹ, a ya mie ọli oni ọ kpẹ mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Emini o zẹ ni mhi rọ ri okhẹ irọkhọkhọ nu wẹ ngme khi. Ini e riẹ bino, ẹa ya mẹ ekẹ, ini e riẹ ri esọ shi ekẹ, ọa ya lo wẹ esọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lọli o zẹ khi ungmemhi ni ọmekẹguele Azaya ọ ngme o tsẹ shi wẹ egbe ni ọ la liẹ. “A ya ri esọ shi ekẹ khue, ama ọa ya tigbe lo ẹ esọ, a fẹli ofẹli khue, aa mẹ emhikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Udu oyẹwẹ o bi obili-a. Itobọ khi eri esọ eyẹwẹ e zuse, e gbo guese alo. Ini ọa khi ighọ, e kha ri alo eyẹwẹ ke mẹ ekẹ, esọ eyẹwẹ e kha suọ, udu oyẹwẹ o kha mhọli ilẹsingme, ee kha mu pfi bhale deba mhẹ, mhi rẹwẹ ze.” “Eni ẹgbọ e ya ri esọ shi ekẹ khue, ama ọa ya tigbe lo wẹ esọ, e fẹli ofẹli khue, ama ẹa mẹ emhikhọghuo.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ama oyẹẹ ọa khi ighọ. Á mẹ afa gba. A ri alo eyẹ ẹ mẹ ekẹ, a ri esọ eyẹ ẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Abi o li mhi li gue ọli yẹ ẹ khi, emekẹguele ebubu ali ẹgbọ eyi Ẹshinẹgba ebubu, e li dua ini wẹwẹ e mẹ emini a mẹ ali ini wẹwẹ e suọ emini a suọ, ama ẹa dobẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","IJesu ọọ. “A ri esọ shi ekẹ, ni e suọ emini oni okhẹ irọkhọkhọ o ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ọgbọ ni suọ ungmemhi omhẹsẹ ni Ẹshinẹgba ọ mhọli shi agbọ oyi ẹgbọ, ni ọa lo ọli esọ ne, lọli ọ li abi ikpamhi emini e de kua epfẹ odẹ. Eri ọkphaghiẹ ọ́ọ́ bhale ya sanọ li wẹwẹ udu kua. ");
INSERT INTO atgNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eni e zẹ nga ukhomhi ọkpegbhẹ, eri e li abi ọgbọ ni ọ kha suọ ungmemhi, ọ ga ri oghẹlẹ mie ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama ọa tiemhi ọli udu, itobọ ighọ, ọa migha tẹsẹ. Irarighọ, ini ọmunu o bhale ali ni a rọ mu okhọli vule shi ọli ọ shi itobọ oni ungmemhi, ọ de odẹ a aghọaghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ikpamhi ni e zẹ shi ifu igba, wẹwẹ e li abi ọgbọ ni ọ kha suọ ungmemhi oyi Ẹshinẹgba, inasẹ-udu shi ingme agbọ ali ọghuẹmhẹ oyi ẹpfue, e tono oni ungmemhi abi igba, ọa dobẹ mọ umọmhi. ");
INSERT INTO atgNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ikpamhi ni e zẹ shi egbegbi ekẹ, e li abi ọgbọ ni ọ kha suọ ungmemhi oyi Ẹshinẹgba o lo ọli esọ. O mọ umọmhi. Eghuo e kha mọ imọmhi egbhuẹshe, elese mọ egbhuẹsẹ, eghuo ọ uye ali igbe.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","IJesu ọ gbo zẹ okhẹ irọkhọkhọ olese khasẹ wẹ, ọọ wẹ, “Eri omhẹsẹ oyi Eghiele oyi Ẹshinẹgba o li abi ọmọse ọghuo ni ọ kọ ado enete shi ishemhi oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ẹliyọsẹ, khi ẹgbọkpa e ya lesẹ-a, ọbe ọli ọ bhale ya kọ ebuli ọfaghue sọlọ shi ọli ọ, ọ vu. ");
INSERT INTO atgNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Eni ado e zẹ khi e fu khi e ri itsagha lasele, eni ebuli ọfaghue e li zẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ighọ eni ẹẹ ga eyi ọni ọmọse e bhale ya gueyẹ ọli, ẹẹ ọli, ‘Ọga egbegbi ado ni u kọ shi ishemhi oyẹ, ebuli ọfaghue e nu wẹ zẹ lasele kia sọlọ shi wẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ọbe mhẹ ọ riẹlẹ ona. “Eni ẹẹ ga e mhila li, ‘Wa a nono ni anye vuolo eni ebuli ọ kua?’ ");
INSERT INTO atgNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ọọ wẹ, Iiye! Irari khi ini a vuolo eni ebuli-a, a ya dọ obọ vuolo eni ado ma eni ebuli. ");
INSERT INTO atgNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A zẹ ni e ga fu kugbe ya ramhi ẹghẹghẹ ikhiẹsẹ. Ẹghẹghẹ aghọ, mhi ya gueyẹ eni ẹẹ khiẹsẹ, e kpẹ vuolo eni ebuli-a, e gẹ wẹ ikhuli, e tosẹ wẹ-a, e tigbe khiẹsẹ eni egbegbi ado shi aka na mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","IJesu ọ zẹ okhẹ irọkhọkhọ olese khasẹ wẹ. Ọọ wẹ, “Eri omhẹsẹ ni Ẹshinẹgba ọ mhọli shi agbọ oyi ẹgbọ o li abi ukpamhi ọara ni a lu imọsitadi ni ọmọse ọghuo ọ rọ ya kọ ishemhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ukpamhi ọli, o khi oghuo ikpamhi ẹẹra ni e shẹ nẹ nya, ama ini o fu vule, lọli o ke fu dọsẹ emini a kọ shi oni ishemhi nya. O mele ọara oni ofunẹ a. Ipfeli e bhale ya ku eko shi iguabọ eyọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","IJesu ọ gbo zẹ okhẹ irọkhọkhọ olese khasẹ wẹ, ọọ wẹ, “Eri omhẹsẹ ni Ẹshinẹgba ọ mhọli shi agbọ oyi ẹgbọ o li abi ifuma ni ọkpotso ọ rọ ma ifulawa ni o bu wushe, ni o rọli fuma shi ọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Okhẹ irọkhọkhọ iJesu ọ rọ gue ingme ena yẹwẹ. Ọa tigbe gue ingme okhọghuo yẹwẹ ni ọa khi okhẹ irọkhọkhọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eri ona o ya tse shi ungmemhi ni ọmekẹguele ọ ngme. Ni ọọ, “Okhẹ irọkhọkhọ mhi rọ ya nu wẹ ngme. Mhi ya gue ingme ni a rọte igbaekẹle oyi agbọ rọ sheli yẹ wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Abi iJesu ọ rọ zẹ eni ebubu ẹgbọ obọ, ni ọ rọ ya lo elemhi owa, eniyẹ odukhokho eyọli e bhale deba li. Ẹẹ ọli, “Gueyẹ anye emini okhẹ irọkhọkhọ oyi ebuli ọfaghue oghọ o ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","IJesu ọọ, “Ọgbọ ni ọ ri eni egbegbi ikpamhi emhi ẹkọmhi kọ, ọ khi Omi Ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Oni ishemhi o khi oni agbọ ona, eni ikpamhi ado enete eghọ e khi ẹgbọ ni e ya ri egbewẹ na Eghiele oyi Ẹshinẹgba. Eni ebuli ọfaghue e khi ẹgbọ eyi Ọkphaghiẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ọkphaghiẹ ọ khi Ọbe ni ọ ri eni ebuli kọ ifu ishemhi. Oni ẹghẹghẹ ikhiẹsẹ o khi ikpukhokho agbọ, eni eni ẹẹ ga eghọ e khi igẹni eyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ẹzẹzẹ abi a li ti eni ebuli gbili tosẹ-a eghọ, ighọ ikpukhokho agbọ o ya li. ");
INSERT INTO atgNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Omi Ọgbọ ọ ya ghie igẹni eyọli ya wolọ ẹgbọ ni e yẹsẹ ẹgbọ pfidọ ali eni e li ọkhọlọ elemhi eghiele oyọli lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A ya pfi wẹ kulo elemhi avuerẹ, aghọ ẹgbọ e la ya ke viẹ ẹ le akọ akọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ẹghẹghẹ aghọ ẹgbọ eyi Ẹshinẹgba e ya ke gẹ abi ovọ elemhi agbọ onogbọ oyi Ẹshinẹgba. A mhọli esọ, a suọ emini mhia gueyẹ ẹ ni a rọli gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Eri omhẹsẹ ni Ẹshinẹgba ọ mhọli shi agbọ oyi ẹgbọ o li abi ẹpfue ni a rọ sheli ifui ishemhi, ni ọmọse ọ tọnọ ekẹ mẹ rue, ni ọ nyanya gbo rọli sheli. Egbe e mu ọli, ọ ya ri emini ọ mhọli nya dẹ, ọ ya dẹ oni ishemhi oghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Eri omhẹsẹ ni Ẹshinẹgba ọ mhọli shi agbọ oyi ẹgbọ o li abi ọmọse ni ọ́ nònò ugbhẹ-ema. ");
INSERT INTO atgNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ini ọ mẹ oni o lo mu ẹloe, ọ je apfẹ ya ri emini ọ mhọli nya dẹ, ọ dẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Eri omhẹsẹ ni Ẹshinẹgba mhọli shi agbọ oyi ẹgbọ o gbo li abi aga ni egbifẹlẹ e pfi lo okẹ oniẹmhi ni o khishi, e muno ifẹlẹ ọdọda. ");
INSERT INTO atgNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Abi oni aga o rọ vọ, e ti ọli ngale egele. Ighọ, e shitọ e sanọ ifẹlẹ eni e khi egbegbewẹ ọ kulo ughughu, e tsua eni ẹa ti kua. ");
INSERT INTO atgNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ighọ o ya li ogbẹlẹ ni o kpe ukhokho. Igẹni eyi Ẹshinẹgba e ya sanọ ẹgbọ ọkhọlọ ifuabọ ẹgbọ eni e pfuasẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","E pfi ẹgbọ ọkhọlọ eghọ kulo owa erẹ, ni e la ke viẹ, ẹẹ le akọ akọ. ");
INSERT INTO atgNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Eni ingmemhi ena nya e she lo ẹ esọ?” Ẹ ọli, “Ii.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ọọ wẹ, “Irarighọ, eri ọsẹsẹ ushi nya ni ọ mele ọmọ odukhokho-a, ni ọ da mie Eghiele oyi Ẹshinẹgba shi udu, ọ li abi ọgbọ ni ọ mhọli owa, ni ọ rọte elemhi owa ni ọ ri itsua shi ẹ rue ẹpfue onogbọ ali onodiọ lasele.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Abi iJesu ọ rọ zẹ eni okhẹ irọkhọkhọ ena se, Ọ lase aghọ le. ");
INSERT INTO atgNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ọ nyenẹ egbe je ẹoli oyọli. Ọ la owa ugamhi sẹsẹ, ẹgbọ ni e suọ ọli, abọ e sha wẹ. E mhila, e liẹ, “Obo ọ te mhuẹ ilẹsingme enana, obo ọ te mẹ ikanya ọshabọ ena a gbe?” ");
INSERT INTO atgNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Ọa she khi omi ikapita na? Ọa khi iMeli ọ khi inyọli, iJemhisi ali iJosẹfu ali iSamọ ali iJudasi ẹa she khi inyọghuo ọli? ");
INSERT INTO atgNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ena ẹa khi inyọghuo ọli eni ikpotso ni e ga nu awa la ana ena? Mhiẹ, Obo ọ te mẹ enana nya?” ");
INSERT INTO atgNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Irarighọ, ọ ri elemhi bi wẹ. Ighọ iJesu ọọ wẹ, “Aa mẹ ashini aa la mu ekpẹ na ọmekẹguele, sẹ ni apfẹ oyọli ali unuẹkpẹ oyọli tsẹ aa la mu ekpẹ na li.” ");
INSERT INTO atgNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Itobọ khi ẹa mhuẹ irudunga, ọa la aghọ gbe ikanya ọnyaloa ni e bu. ");
INSERT INTO atgNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ẹghẹghẹ aghọ, Erọdu oghie ekẹ iGalili ọ suọ eko iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ọ gueyẹ eni ẹ ga li, ọọ, “IJọni Ọni ọọ batazi na, ni ọ nyenẹ egbe bhale agbọ. Lọli o zẹ ni ọ rọ lighọ mhọli afu rọ ọ gbe ikanya ọnyaloa enana.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Irari khi Erọdu ọ ke kpẹ ghie ya mu iJọni. Ọọ, a ri iwẹghẹ gẹ ọli, a mu ọli pfilo owa ighumha shi itobọ ingme oyi Ẹrodiasi ughuẹ iFilipu inyọghuo ọni Erọdu. ");
INSERT INTO atgNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eri iJọni ọ ke gueyẹ Erọdu khi ushi oyi ẹgbọ iJu ọa lama shi ọ ni ọ rọ rue ughuẹ inyọghuo ọli iFilipu shi. ");
INSERT INTO atgNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Oni ẹghẹghẹ Erọdu ọ nono ni lọli gbe iJọni-a shi oni ingme, ama ulishi oyi ẹgbọ iJu oo mu ọli irari khi ọ lẹsẹ khi ẹgbọ kpa e lẹsẹ khi ọmekẹguele iJọni ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ama, ẹlẹ ni Erọdu ọ ghẹlẹ shi ogbẹlẹ ni a rọ bia li, omi Ẹrodiasi ọ gbe ishimhi khasẹ wẹ ni o ri egbe mu ọni Erọdu dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","O ri ọni Erọdu romhi ishe, ọ neta ọmọse gueyẹ ọni ọmueshi khi lọli ya ri emiemini ọ mhila luẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ighọ inyọli ọ ya sẹsẹ ọni ọmueshi, ọ ka gueyẹ itali ọ khi iJọni ukhomhi shi ukpẹko na luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Abi ọ rọ ngme ọli ghọ, egbe pfọ ọni oghie-a. Ama irari ishe ni ọ romhi ali apfọli ni e nu ọli shitọ, ọọ a ri emini ọ mhila na li. ");
INSERT INTO atgNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ighọ ọ ghie ya khi iJọni ukhomhi ọ elemhi owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A khi oni ukhomhi shi ukpẹko a ri ọli na ọni ọmueshi, ọni ọmueshi ọ tsua li ghi inyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Eniyẹ odukhokho eyi iJọni e bhale ya tsua ekuli oyọli rọ ya tọ. E vu ya gueyẹ iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Abi iJesu ọ rọ suọ emini a mẹ, ọ fiẹ aghọ lase. Ọ lo ọkọ-okẹ oniẹmhi je asha ni o da-ya ya shitọ. Abi eni ẹgbọ e rọ suọ ona e ri awẹ kia lẹ deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Abi iJesu ọ rọte oni ọkọ-okẹ oniẹmhi fiẹ lase, ni ọ rọ mẹ eni ebubu ẹgbọ eghọ, elemhi wẹ e ala li, eni ẹa ze, ọ rẹ wẹ ze. ");
INSERT INTO atgNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ogbọmhi o mu ekẹ, eniyẹ odukhokho e bhale, ẹẹ ọli, “Waa ke zẹ ẹgbọ ena ke je, irari khi oola o nuata shi apfẹ, ni e je ifu ẹoli ya dẹ emhi le.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","IJesu ọọ wẹ, “Ọa ti ni e lighọ vu tsẹ, a nono eminale na wẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ẹẹ iJesu, “Ibulẹdi ishe ali ifẹlẹ ava e khi emini awa lẹsẹ mhuẹ shi ana.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","IJesu ọọ wẹ, “A rue wẹ bhale ghi mhẹ ghue.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ọọ, ọgbọgbọ ọ shitọ ukhomhi ebuli. Ọ rue eni ifẹlẹ ava ali ibulẹdi ishe eghọ, ọ tsua wẹ idane ọ ri ikphẹmhi na Ẹshinẹgba. Ọ kholo eni ibulẹdi-a, ọ rẹ wẹ na eniyẹ odukhokho eyọli. Eni eniyẹ odukhokho eyọli e kemhi wẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ọgbọgbọ ọ le, ọ khue, e kpọle. Ighọ eniyẹ odukhokho eyọli e sanọ eni e kpọle vọ ighughu igbẹva tsululu. ");
INSERT INTO atgNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Emọse agbẹlẹ ishe (5,0000) e le eni eminale, ini aa leli ikpotso ali eniyẹ ma ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aghọaghọ iJesu ọ gueyẹ eniyẹ odukhokho eyọli e lo ọkọ-okẹ da je ukiẹkiẹ okẹ obini o kpọle, ọ gueyẹ eni ebubu ẹgbọ, ọgbọgbọ ọ ke je. ");
INSERT INTO atgNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ọ vẹsẹ eni ẹgbọ kua se, ọ je ukhomhi ute ya sọ iromhi. Ogbọmhi o mu ekẹ, iJesu lọlighuo ọ kie la oobọ. ");
INSERT INTO atgNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ẹghẹghẹ ni a ngme ena, oni ọkọ-okẹ o she rọte ekẹ lo oni okẹ kia nuata. Ighọ akpekpeli oniẹmhi oo zughuse oni okẹ, ni o tsua oni ọkọ-okẹ ya nga ya tiemhi. ");
INSERT INTO atgNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ẹlẹ uzogbe neni ogbe o gbe-a, iJesu bhale deba wẹ, ọ la oni ukhomhi okẹ ẹ kia. ");
INSERT INTO atgNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Abi eni eniyẹ odukhokho e rọ mẹ ọli khi ọ la ukhomhi oni okẹ ẹ kia, e yila. E tsẹsẹ, e liẹ, “Ayẹmhẹ olimi lọ!” ");
INSERT INTO atgNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","IJesu ọ nyanya nu wẹ ngme, ọọ, “A mhọli udu, mhẹmhẹ lọ, a khi ke na ulishi.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","IPita ọọ, “Ọnọmhuẹ ini yẹyẹ lọ igẹsikia, wẹẹ mhẹ mhi bhale debẹ oni ukhomhi okẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","IJesu ọọ li, “Bhale.” Ighọ iPita ọ fiẹ oni ọkọ-okẹ lasele, ọọ kia ukhomhi okẹ, ọọ lẹ deba iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama abi ọ ke rọ mẹ abi oni ukpokpomhi akpekpeli o li pfiolo, ulishi o mu ọli, ọọ tiemhi elemhi oni okẹ. Ọ tsẹsẹ, ọọ, “Ọnọmhuẹ tsumhi mhẹ!” ");
INSERT INTO atgNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ighọ iJesu ọ nise obọ-a ọ mu ọli. Ọọ li, “Elọ o zẹ ni irudunga oyẹ o rọ na shẹ. Elọ o zẹ ni u rọ mhuẹ akhọkhọmhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ighọ e ga ya lo elemhi oni ọkọ-okẹ, oni akpekpeli o pfọmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ighọ eniyẹ odukhokho eyọli e nyẹsẹ ukhomhi na li ẹẹ ọli, “Igẹsikia lọ khi, Omi Ẹshinẹgba u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Abi e ke rọ da oni okẹ ni o khishi, e bhale ekẹ iGẹnẹsarẹti. ");
INSERT INTO atgNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Abi ẹgbọ ni e la oni ekẹ e rọ lẹsẹ khi iJesu lọ, e ghie ghi ẹgbọ ni e la ẹoli i kia gasẹ oni ẹoli nya. Ẹgbọ e tsua ẹgbọ eyẹwẹ nya ni ẹẹ ghua ghi ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","E lema li ọ kpẹkpẹ ọ lẹsẹ zẹ ni eni ẹ ghua e ri obọ ti esọ awulu ni ọ sọ. Ẹgbọ nya ni e ri obọ ti ọli, e ze. ");
INSERT INTO atgNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ighọ ẹgbọ iFarisi ali esẹsẹ Ishi eyi iMosisi eghuo e te iJerusalẹmu bhale ya mhila iJesu, ẹẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Elọ o zẹ khi eniyẹ odukhokho eyẹ ẹa ya ri osẹsẹ ni ititawa e rọ shi ekẹ gbe akanya? Ẹa ya kpe abọ-a neni e le eminale!” ");
INSERT INTO atgNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","IJesu ọọ wẹ, “Elọ o zẹ ni a rọ ri itobọ ushi oyẹẹ gbe ushi oyi Ẹshinẹgba-a? ");
INSERT INTO atgNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Irari khi Ẹshinẹgba ọọ liẹ, ‘Ọgbọ ọ ke ri ekpẹ na itali ali inyọli,’ ali khi, ‘Ọnini ọ da ku itsẹ na itali okekhi inyọli ne, a gbe ọli-a.’ ");
INSERT INTO atgNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama abi ẹẹ a ke ngme khi, ini ọgbọ ọ mhọli ikpaghọ ni ọ kha rọ na itali okekhi inyọli, ni ọ ke rọ liẹ khi eni ikpaghọ eghọ khi lọli mu udu pfi, khi Ẹshinẹgba lọli ke ri eni ikpaghọ ya na. ");
INSERT INTO atgNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Khi ọ guẹ kia ini ọa ke riẹ ri ikpaghọ na itali ali inyọli. Ina a li ri ẹloe ẹ gbe ushi oyi Ẹshinẹgba ni a ba mẹ asha ke deba osẹsẹ oyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ẹẹ e ri ugamhi ku alo! Azaya Ọmekẹguele ọ kpẹ lina ngme ọli shi ẹ egbe ni ọ rẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Eni ẹgbọ ena, unu e rọ mu ekpẹ ẹ na mhẹ, ama udu oyẹwẹ o nuata shi mhẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Afuẹ e mema ga mhẹ, irari khi osẹsẹ oyi ẹgbọ ẹẹ sẹsẹ ẹgbọ, abinẹ khi ishi eyẹmhẹ lo.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","IJesu ọ lu ẹgbọ ni e legba, ọọ wẹ, “A ri esọ shi mhẹ ekẹ, ni a mhuẹ ilẹsingme. ");
INSERT INTO atgNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ọa khi emini ọgbọ ọ rọte unu le tiemhi elemhi e rọli ẹ khi ọni ọa pfuasẹ, ama emini e te ọli unu ya fiẹ e ri ọgbọ khi ọni ọa pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ighọ eniyẹ odukhokho eyọli e bhale deba li e mhila li, ẹẹ ọli, “U li lẹsẹ khi ingmemhi ni u ngme amo khi, o ri elemhi ẹ bi ẹgbọ iFarisi?” ");
INSERT INTO atgNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","IJesu ọọ wẹ, “Ọara ni Itamhẹ na iloghie ọa da rọ kọ ne, a ya vu ọli ekẹ-a.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","A khi zẹ ni ingme oyẹwẹ o nasẹ ẹ udu. Ezalo ni eri ezalo ẹ kia e khi. Ini ọzalo ọ mu ọzalo ọnabi lọli obọ rọ ọ kia, eri wẹwẹ ava e ga de ya pfilo atekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","IPita ọọ iJesu, “Gueyẹ anye abi oni okhẹ irọkhọkhọ ena e ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","IJesu ọọ wẹ “Aa kie lẹsẹ emini mhia ngme?” ");
INSERT INTO atgNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","A lẹsẹ khi emini o da te unu ya tiemhi elemhi khi eri a nẹ ọli ẹ kua? ");
INSERT INTO atgNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama emini o da te unu lasele ne, elemhi udu o te lasele. Ena e khi emini e dobẹ ri ọgbọ ọ khi ọni ọa pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Irari khi elemhi udu isamhi ebe e te ẹ lasele. Usamhi abi a liẹ gbe ugbeli, ali abi a liẹ kia okia, abi liẹ do ighiatọ ni a rọ na eta ali iku itsẹbọ ali iyese ọgbọ-a, ali ni a rọ ọ pfi ọtsẹlẹ ẹgbhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Emhi enana e ri ọgbọ ọ khi ọni ọa pfuasẹ. Ama ini ọgbọ ọ le eminale ni ọa rọ kpe abọ, ọa ri ọgbọ khi ọni ọa pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","IJesu ọ te aghọ vu, ọ bhale ekẹ iTai ali iSidọni. ");
INSERT INTO atgNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ọkpotso ọngi iKena ni ọ la ukiẹkiẹ ekẹ oghọ ọ bhale deba iJesu ọ lema li, ọọ li, “Ọnọmhuẹ Omi iDefidi kpẹkpẹ mhọli ilẹlemhi na mhẹ. Omimhẹ ni ọmueshi ọ mhuẹ ayẹmhẹ ọkphaghiẹ. Oo ze mu ọli gba memena.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama iJesu ọa sọ ọli ọ. Eniyẹ odukhokho eyi iJesu, ẹ iJesu ọ khu ọni ọkpotso khi ọọ kpe okeke deba ẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","IJesu ọọ wẹ, “Isumha eyi iZirẹni ni e waa, a ghie mhẹ ghi tsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ọni ọkpotso ọ suọ ona, ọ bhale ya de wugha odalo oyi iJesu, ọọ li, “Ọnọmhuẹ kpẹkpẹ kpaghiẹ mhẹ obọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","IJesu ọọ li, “Ọa ti ni a rue eminale oyi eniyẹ pfi ghi ewa.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ọni ọkpotso ọọ, “Ighọ lọ guẹguẹguẹ, Ọnọmhuẹ. Ama ewa ẹẹ le eminale ni o rọte ukhomhi itebu oyi ọni ọ mhọli wẹ de kua ekẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","IJesu ọọ ọni ọkpotso, “Egbegbọ u mhuẹ irudunga, a ya ri emini u nono nẹ.” Aghọaghọ omi ọli ọ ze. ");
INSERT INTO atgNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","IJesu ọ te aghọ vu, ọ rọte okẹ oniẹmhi iGalili lẹ. Ọ nga ukhomhi ute ya shitọ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ebubu ẹgbọ e bhale deba li aghọ, e tsua ẹgbọ ni e guọghọ awẹ-a, ali eni e zẹ alo ali eni e le esọ, ali eni e ki shi, ali ingmenu ali ebubu ẹgbọ ni e mhuẹ ighuamhi ọdọda bhale ya shi ufuẹgẹ oyi iJesu. Ọ ri wẹwẹ nya ze. ");
INSERT INTO atgNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abọ e sha ẹgbọ abi e rọ mẹ khi ingmenu ee ngme, ẹgbọ ni e guọghọ a, e vule kia, eni e zẹ alo e mẹ ekẹ, ighọ, ee kuẹghiẹ Ẹshinẹgba ọyi iZirẹni. ");
INSERT INTO atgNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","IJesu ọ lu eniyẹ odukhokho eyọli, ọ́ọ́ wẹ, “Elemhi ẹgbọ ena e ga lala mhẹ irari khi ẹlẹ-esẹ na ni e te nu mhẹ la akana. Ẹa mẹ eminale le. Mhi aa nono ni mhi gueyẹ wẹ e ri elemhi ofuẹ ke je, ini ubi o khi rue wẹ shi odẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eniyẹ odukhokho eyọli e mhila li, “Obo a te ya mẹ eminale ni ebubu ẹgbọ ena e ya le ifu oyẹmhi ni awa la ena?” ");
INSERT INTO atgNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","IJesu ọ mhila wẹ, “Ibulẹdi ingmẹ a mhọli shi aghọ?” Ẹ ọli “Iruli ishilua ali ikuku ifẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ighọ iJesu ọọ eni ẹgbọ e shitọ ekẹkhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ighọ ọ rue eni ibulẹdi eghọ ali eni ifẹlẹ ọ kphẹmhi na Ẹshinẹgba shi ọ. Ọ khi wẹ a, ọ rẹwẹ na eniyẹ odukhokho eyọli e kemhi wẹ na eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ọgbọkpa ọ le, ọ khue. Eniyẹ odukhokho eyọli e sanọ eni e le kpọle shi ighughu ishilua e vọ tsuulu. ");
INSERT INTO atgNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Emọse agbẹlẹ ene 4,000 e le eni eminale. Ini ọgbọ ọa leli ikpotso ali eniyẹ ma ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","IJesu ọ vẹsẹ eni ebubu ẹgbọ kua se, ọ lo ọkọ-okẹ oniẹmhi je ukiẹkiẹ ekẹ iMagidaleni. ");
INSERT INTO atgNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ẹgbọ iFarisi ali iSadusi eghuo e bhale deba iJesu e ya mu ọli fẹ. E mhila li ọ ri ọlẹlẹ ni o te iloghie bhale khasẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","IJesu ọọ wẹ, “Ini ogbọmhi ọọ mu ekẹ, a guele khi, ‘Ogbe-namo o ma ti irari khi idane o yilẹ-a.’ ");
INSERT INTO atgNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ẹlẹ uzogbe, a guele khi, ‘Amẹ o ya ruẹ amo irari khi idane ọọ yilẹ, o gbo bishi-a.’ A guẹ bino irarogbe guele abi ogbe o ya li, ama aa dobẹ ẹ guele emini ẹghẹghẹ ni a la memena o ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ẹẹ ẹgbọ ebe na agbhotu ona ni aa ri igẹsikia ga Ẹshinẹgba! A mhila mhẹ ọlẹlẹ? Aa ya ri okhọghuo khasẹ ẹ, sẹ ni onayi iJona ọmekẹguele.” Ighọ iJesu ọ pfi wẹ shi aghọ vu. ");
INSERT INTO atgNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Abi eniyẹ odukhokho eyọli e rọ́ da oni okẹ oniẹmhi ni o khi shi je egele ukiẹkiẹ obini o kpọle se, e sato khi wẹwẹ ẹa yelele tsua ibulẹdi. ");
INSERT INTO atgNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","IJesu ọọ wẹ a mhuẹ ẹgbhẹ ẹ shi angeli oyi ẹgbọ iFarisi ali iSadusi ni o li abi afuma oyi oyese. ");
INSERT INTO atgNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eni eniyẹ odukhokho e nu egbewẹ ngme ọli khi itobọ khi wẹwẹ ẹa tsua ibulẹdi bhale iJesu ọ rọ ngme ona. ");
INSERT INTO atgNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","IJesu ọ suọ emini e ngme, ọọ wẹ, “Eni ẹa mhọli irudunga ena, elọ o zẹ ni a rọ gue ẹzọ eminale? ");
INSERT INTO atgNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aa kie lẹsẹ ingme? Aa sato abi mhi rọ kemhi ibulẹdi ishe na ẹgbọ agbẹlẹ ishe, ighughu ingmẹ a sanọ eni e le kpọle vọ? ");
INSERT INTO atgNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ali ibulẹdi ishilua ni mhi rọ na ẹgbọ agbẹlẹ ene le, ighughu ingmẹ a sanọ eni e le kpọle vọ? ");
INSERT INTO atgNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Elọ o zẹ khi aa kie lẹsẹ khi ọa khi ingme ibulẹdi mhi nu ẹ gue? Ama, mhiẹ a mu egbe ẹ shi oyese oyi ẹgbọ iFarisi ali iSadusi ni o li abi ifuma.” ");
INSERT INTO atgNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lọli eniyẹ odukhokho eyọli e rọ tigbe lẹsẹ khi, ọa khi ingme ifuma ni a rọ nye ibulẹdi ọ nu wẹ ngme ẹ shi, ama ingme osẹsẹ ẹgbhọli oyi ẹgbọ iFarisi ali iSadusi ọọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Abi iJesu ọ rọ bhale ekẹ iSizeria iFilipi, ọ mhila eniyẹ odukhokho eyọli, ọọ wẹ, “Ọghuo ẹgbọ e famhi ẹ liẹ khi Omi Ọgbọ ọ khi?” ");
INSERT INTO atgNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ẹẹ iJesu, “Eri ẹgbọ eghuo ẹ khi iJọni Ọni ọọ batazi ẹgbọ u khi, eghuo ẹ lu ẹ, Elaja, eghuo ọ ẹ khi, iJeremaya u khi, eghuo ẹ khi, ọọghuo emekẹguele u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","IJesu ọọ wẹ, “Ẹẹ oyẹ ẹ, ọghuo ẹ khi mhi khi?” ");
INSERT INTO atgNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ISamọ iPita ọ rọ ọli, “Yẹyẹ u khi ọni iKirisiti Omi Ẹshinẹgba ni ọ la ọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","IJesu ọọ li, “Ọni a khi vọsẹ na u khi, iSamọ omi iJona. Ọa khi ọgbọ ọ ri igẹsikia ona khasẹ ẹ, obọ oyi Itamhẹ na iloghie o te bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mhi gueyẹ, yẹyẹ iPita, (ni u khi ẹchẹ). Oni ungmemhi ni u ngme ena mhi ya ma Igbaa oyẹmhẹ ni e mie mhẹ suọ nga, ekpabọ oyi eghuli ọa dobẹ ya mu ọli ọ le. ");
INSERT INTO atgNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mhi ya rue okpẹ oyi eghiele oyi Ẹshinẹgba nẹ, emiemini u waa da lama shi elemhi agbọ ona ne, Ẹshinẹgba ọa ya li lama shi ọ obini iloghie, emini u da lama shi elemhi agbọ ona ne, ọ ya lama shi ọ obini iloghie.” ");
INSERT INTO atgNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","IJesu ọ gueyẹ eniyẹ odukhokho eyọli e khi gueyẹ ẹgbọ khi lọli khi ọni iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Rọte ẹghẹghẹ aghọ vu iJesu ọ te gueyẹ eniyẹ odukhokho eyọli, ọọ, liẹ, “Mhi mema ya je ekẹ iJerusalẹmu ni mhi la ya mẹ osoli ebubu abọ eyi eni egbhali ali ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi. A mema ya gbe mhẹ-a, ama ẹlẹ nuzi-esẹ a ya guise mhẹ le bhale agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ighọ iPita ọ lu ọli fiẹ je olase ọ liẹ ọli ọ khi ke gbo ngme ghọ, “Ẹshinẹgba ọ bighi ọli ku a, oghọ ọa ya tsẹ shi ẹ egbe!” ");
INSERT INTO atgNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","IJesu ọ mu egbe pfi ọọ iPita, “Vu mhẹ ana, ọkphaghiẹ! Ọzuodẹ u khi shi mhẹ ọ, irari khi waa ya sa isamhi ni e rọte obọ oyi Ẹshinẹgba bhale, ama usamhi oyi agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ighọ iJesu ọ gueyẹ eniyẹ odukhokho eyọli, ọọ wẹ, “Ini ọgbọ ọ da nono ni lọli deba mhẹ ne ọ mema ya kie egbọli ọ tsua apfida oyọli ọọ deba mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Irari khi ọgbọ ni ọ́ da dua ni lọli tsumhi ayẹmhẹ oyọli ne, agbọ onabi oyi Ẹshinẹgba o ya de ọli obọ-a, ama ọgbọ ni ọ da ri itobọ oyẹmhẹ rue ayẹmhẹ oyọli pfi-a ne, ọ ya tsumhi ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ighe eleli ni ọgbọ ọ ya mẹ ini ọ le ugu agbọ ona nya, ni ayẹmhẹ oyọli o rọ de ọli obọ-a? Abi khi elọ ọgbọ ọ dobẹ rọ ya fali ota rọ to ayẹmhẹ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Irari khi Omi Ọgbọ ọ ya bhale elemhi ufumhi oyi Ẹshinẹgba lọli ali igẹni eyọli, ẹghẹghẹ aghọ ọ ya ri eleli na ọgbọgbọ abi ọ li gbe. ");
INSERT INTO atgNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mhi gueyẹ ẹ khi ẹgbọ eghuo e la ana memena ni ẹa ya ghu ne, ni e rọ ya mẹ khi Omi Ọgbọ ọọ bhale abi oghie.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ogbẹlẹ-esesa o dọsẹ se, iJesu ọ rue iPita ali iJemhisi ali iJọni ikhi inyọghuo iJemhisi, wẹwẹghuo kpe e ya nga ukhomhi ute ni o yagha. ");
INSERT INTO atgNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ọ la aghọ mu mela-a ukpẹloe wẹ. Alo eyọli e gẹ abi ovọ, itsua ni ọ sọ e gẹ abi ákpá. ");
INSERT INTO atgNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","O li dẹnẹ, ghe khẹ, e mẹ khi iMosisi ali Elaja khi e nu iJesu ẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ighọ iPita ọọ iJesu, “Ọnọmhuẹ, o ma guẹ ti khi anye la ana! Ini o ghọle ẹ, mhi ya tọ okholo esẹ, oghuo ọ o khi o yẹ, olese ọ o khi oyi iMosisi, onokpọle o khi oyi Elaja.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Abi ọ kie li ngme, ighọ otughunu ni o gẹ nyanyanya o bhale ya khukhu wẹ-a. E suọ khi uruli o rọte oni otughunu liẹ, “Omimhẹ ni mhi nono ingme oyọli na, ni ọ ri egbe ẹ mu mhẹ. A suọ emini ọ gueyẹ ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Abi eni eniyẹ odukhokho e rọ suọ ona, e de yẹshi ta alo rughu, ulishi oo mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ighọ iJesu ọ bhale ya ri obọ ti wẹ, ọọ wẹ, “A vule, a khi ke zẹ ni ulishi o mu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Abi e ke rọ yasẹ alo ekẹ, ẹa ke mẹ ọgbọkhọghuo aghọ sẹ ni iJesu lọlighuo kpe. ");
INSERT INTO atgNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Abi e rọ tiemhi oni ute le, iJesu ọ tse agua yẹ wẹ, ọọ. “A khi gueyẹ ọgbọkhọghuo emini a mẹ, ini aa li rọte eghuli guise Omi Ọgbọ le.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Eni eniyẹ odukhokho eyọli e mhila li, ẹẹ, “Elọ o zẹ khi esẹsẹ Ishi eyi iMosisi ẹ liẹ khi Elaja ọ mema kpẹ ya bhale?” ");
INSERT INTO atgNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","IJesu ọọ wẹ, “Elaja ọ mema kpẹ ya te odẹ bhale ya mu egbe emhikpa shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama mhi gue ẹ yẹ ẹ khi Elaja ọ she bhale ama ẹgbọ ẹa lama khi lọli ọ khi, e li ọli abi o ghọle wẹ. Ighọ e ya li na Omi Ọgbọ osoli.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ighọ eniyẹ odukhokho eyọli e tigbe lẹsẹ khi ingme oyi iJọni Ọni ọọ batazi ẹgbọ ọọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Abi e rọ nyenẹ egbe bhale deba eni ebubu ẹgbọ, ọmọse ọghuo ọ bhale ya wugha odalo oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ọọ, “Ọnọmhuẹ, kpẹkpẹ lẹ elemhi omi mhẹ ni ọ mhuẹ ughuamhi ni ọ mu ọgbọ pfi gbe. O ma nasẹ ọli gba. Isheghuo o mu ọli ẹ pfilo erali, isheghuo ọ de pfilo okẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eri mhi rue ọli ghi eniyẹ odukhokho eyẹ, ẹa dobẹ rọli ze.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","IJesu ọọ, “Ashi mhi bẹshi ri abọ mu udu na ẹ ya ramhi, ẹẹ ẹgbọ ni ẹa mhuẹ irudunga ali iwali ẹgbọ, ẹlẹ ingmẹ mhi ke bẹshi ri abọ mu udu na ẹ ya ramhi? A rue ọni ọmọ ghi mhẹ ana.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ighọ iJesu ọ mhẹsẹ na oni ayẹmhẹ ọkphaghiẹ ọghọ, o te ọli egbe fiẹ ya lase, ọni ọmọ ọ ze aghọaghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ighọ eniyẹ odukhokho e bhale deba iJesu abi o rọ kpe lọlighuo le, e mhila li, ẹẹ ọli. “Elọ o fẹ zẹ khi anye ẹa dobẹ khu oni ayẹmhẹ ọkphaghiẹ ya lase?” ");
INSERT INTO atgNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","IJesu ọọ wẹ, “Itobọ khi irudunga oyẹ ẹ oo shẹ lọ. Mhi gueyẹ ẹ khi ini a mhuẹ irudunga ni o shẹ abi ukpamhi ọara imọsitadi, a ya dobẹ gueyẹ ute ona, ẹẹ ọli, ‘Vu ana lasele je oobọ.’ O lighọ nẹ abi u ngme. Aa mẹ emini ọa ya zẹ ẹ ke li.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama odẹ ni a te dobẹ khu ayẹmhẹ obe onana fiẹ lase khi, ode iromhi isọsọ ali azumhi ipfipfi. ");
INSERT INTO atgNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Abi eniyẹ odukhokho eyọli e rọ bhale iGalili, iJesu ọọ wẹ, “Ẹghẹghẹ o she ramhi ni a rọ ya ri Omi Ọgbọ na ẹgbọ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","E ya gbe ọli-a, ama ẹlẹnuzi-esẹ a ya guise ọli le bhale agbọ.” Oni ungmemhi o ri egbe pfọ wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Abi iJesu ali eniyẹ odukhokho eyọli e rọ nyenẹ egbe jele iKapanọmu, emionoga na Owa oyi Ẹshinẹgba e bhale deba iPita, e mhila li, “Ọsẹsẹ oyẹẹ ọ li fẹ zẹ oga oyi Owa oyi Ẹshinẹgba?” ");
INSERT INTO atgNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","IPita ọọ wẹ, “Ee.” Abi iPita ọ rọ lo elemhi owa le ya mhila iJesu, iJesu ọ kpẹ ngme. Ọọ, “ISamọ, eghuo u fẹ sa khi enighie ena agbọ ona e famhiẹ mie oga? Emọ-ekẹ abi epfẹse?” ");
INSERT INTO atgNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","IPita ọọ, “Epfẹse.” IJesu ọ li, “O ti shọ! Oghọ o rọkhasẹ khi ọmọ ekẹ ọa khi ọni ọọ zẹ oga.” ");
INSERT INTO atgNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Ama ini awa khi lue na wẹ, je okẹ ya pfi ugba oyẹ pfilo. Afẹlẹ ni u todẹ ya mu, khueghie ọli unu-a, u ya mẹ ọli ukpaghọ unu rue. Rue ọli ni u rọli ya zẹ oni oga oyẹmhẹ ali oyẹẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ẹghẹghẹ aghọ, eni eniyẹ odukhokho e bhale deba iJesu, e mhila li, “Ọghuo ọ fẹ funẹ shi Eghiele oyi Ẹshinẹgba?” ");
INSERT INTO atgNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ighọ iJesu ọ lu ukuku ọmọ bhale migha wẹ odalo. ");
INSERT INTO atgNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ọọ wẹ, “Abi o li mhi li gue ọli ẹ yẹ ẹ, khi, ini aa li mu pfi ni a li abi ikuku eniyẹ, aa ya lo Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ọgbọ ni ọ ga funẹ shi Eghiele oyi Ẹshinẹgba khi, ọni ọ ri egbọli tiemhile abi ukuku ọmọ ọnana. ");
INSERT INTO atgNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ọnini ọ da ri irari eva oyẹmhẹ mie ọmọ ọnana ne, mhẹmhẹ ọ mie. ");
INSERT INTO atgNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ama ini ọgbọkhọghuo ọ yẹsẹ enana ni e mie mhẹ suọ pfidọ, ini a bie mu iko zu ọgbọ ọghọghọ uruli tsua pfilo elemhi okẹ oniẹmhi, o ti nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“O maa khọlọ mu ẹgbọ ni e yẹsẹ ẹgbọ ọ lamhẹ. Ọgbọ ọa dobẹ ya na pfue imufẹ oyi olamhẹ. Ama o ma khọlọ ẹgbọ ni e zẹ khi a mẹ eni imufẹ eghọghọ egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ini obọ oyẹ, okekhi owẹ oyẹ, o zẹ ni u lamhẹ, khi ọli pfi-a. Irari khi o ti nẹ ini ọgbọ ọ khi ọkhomhi ya lo agbọ na agbọagbọ, ni abọ ali awẹ e gba pfo nali ya lo owa erẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ini o khia khi ẹloe oyẹ o zẹ ẹ lamhẹ, vuọnyọ li pfia. O ti nẹ u ri ukpẹloe oghuo ya lo iloghie, ni alo e rọ gba nẹ, pfi ẹ ya lo ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“A khi zẹ ni a ri ẹloe gbe eni ẹa mu ẹloe enana, irari khi eri igẹni eyẹwẹ na iloghie ẹ migha odalo oyi Itamhẹ ẹghẹghẹkpa. ");
INSERT INTO atgNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Eri mhẹmhẹ Omi Ọgbọ mhi bhale ya tsumhi eni e wa-a. ");
INSERT INTO atgNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sẹ a sa shi ọ? Ini ọgbọ ọ mhuẹ isumha egbhuẹshe ni ọghuo ọ, ọ rọ wa-a. Ọa khi eri ọ ya zẹ ọghuo ọa la egbhuẹshe eghọ obọ, ọ ya nono ọghuo ni ọ wa a eghọ? ");
INSERT INTO atgNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ini ọ mẹ ọli, mhi gue ẹ yẹ ẹ khi egbe e ya mu ọli shi ọghuo ọghọ dọsẹ ọghuo ọa la egbhuẹshe enekpọle ni ẹa waa. ");
INSERT INTO atgNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ighọ Ita ẹ na iloghie ọa li nono eni ẹa mu ẹloe enana ni e wa-a. ");
INSERT INTO atgNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ini inyọghuo ẹ ọ lue nẹ, lẹ deba li ka gueyẹ ọli emini ọ li. Ama zẹ ni o khi yẹyẹ ali lọlighuo kpe. Ini ọ ri esọ shi ẹ ekẹ, u she gbo sheshe ọli shi odẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama ini ọa ri esọ shi ẹ ekẹ, lu ọgbọ ọghuo abi ava elese, ẹghẹghẹ aghọ ni e khi ọtsẹlẹ abi Ebe-no-pfuasẹ o ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ini ọa ri esọ shi ẹ ọ, lẹ ya gue eni ingme nya yẹ ena igbaa oyi eni e mie iJesu iKirisiti suọ. Ini ọa gbo da ri esọ shi igbaa oyi eni e mie iJesu iKirisiti suọ ọ ne, a ti kia nali. A rue ọli shi ọgbọ ni ọa miesuọ ali ọmionoga ọgbọ ọkhọlọ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Abi o li mhi li gue ọli ẹ yẹ ẹ khi emiemini aa da lama shi oni agbọ ona ne, aa ya li lama shi ọ na ẹ obini iloghie. Ali khi emiemini a da lama shi agbọ ona ne, a ya lama shi ọ na ẹ obini iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mhi gbo gueyẹ ẹ khi ini ẹẹ otuava a da lama shi emhikhọghuo agbọ ona ni a rọ sọ iromhi shi ọ ne, Itamhẹ ni ọ la iloghie ọ ya riẹlẹ ọli na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Irari khi asha ni ẹgbọ ava o khi aasẹ e da lona kugbe irari eva oyẹmhẹ ne, mhi nu wẹ la aghọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","IPita ọ bhale deba iJesu, ọ mhila li, “Iti-ingmẹ inyọghuo-mhẹ ọ fẹ ya lue na mhẹ ramhi ni mhi rọ ya gbe kua nali? Iti ishilua?” ");
INSERT INTO atgNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","IJesu ọọ li, “Iiye, ọa khi iti ishilua tsẹ, ama iti egbhuẹsẹ ali igbe asha ishilua. ");
INSERT INTO atgNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Irari khi eri Eghiele oyi Ẹshinẹgba o li abi oghie ọghuo ni ọọ eni ẹẹ ga eyọli e bhale ya rọkhasẹ luẹ abi e li gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Abi ọ rọ ghọ bino na wẹ abi e li gbe na li, a rue ọmọse ọghuo ni ọ lo ọli ẹkpa idududu bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Abi ọni ọmọse ọa rọ dobẹ fali eni ikpaghọ, ọni oghie ọọ e mu ọli ali ughuẹ ọli ali imi ọli ya dẹ ni ọ rọ fali eni ota. ");
INSERT INTO atgNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ọni ọọ ga ọghọ ọ de ya wugha odalo oyi ọni oghie, ọọ li, ‘Kpẹkpẹ, rabọmudu na mhẹ, mhi ya fali ẹ eni ikpaghọ nya.’ ");
INSERT INTO atgNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ighọ ọni oghie ọ ya mhuẹ isomhelemhi na li, ọ gbe eni ota kua na li, ọ zẹ ọli vu. ");
INSERT INTO atgNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ama abi ọni ọọ ga ọ rọ fiẹ lase, ọ mẹ ọni ọọ ga nabi lọli ni ọ lo ọli ikuku ikpaghọ. Ighọ, ọ khi awulu shi ọli uruli, ọọ li, ‘Fali mhẹ ota ni u lo mhẹ!’ ");
INSERT INTO atgNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ọnuzava ọyọli ọghọ, ọ de ya wugha, ọọ lema li, ọọ li, ‘Kpẹkpẹ rabọmudu na mhẹ, mhi ya fali ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ama ọa lama na li. Ọọ a mu ọli ya shi owa ighumha ya ramhi ni ọ rọ ya fali eni ota. ");
INSERT INTO atgNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Abi eni ẹẹ ga enekpọle e rọ mẹ emini ọ li, elemhi ee bi wẹ. E lẹ ya gue eni ingme nya yẹ ọni oghie ọghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ighọ ọni oghie ọ ghie ya lu ọni ọọ ga ọghọ, ọọ li, ‘Yẹyẹ ọni ọọ ga ọna ọkhọlọ ọna, mhẹmhẹ mhi gbe ikpokpomhi ikpaghọ ni u lo mhẹ kua nẹ irari khi u lema mhẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","waa khi ọni ọ kha li mhuẹ isomhelemhi na ọnuzi-ava ọyẹ abi mhi mhuẹ isomhelemhi nẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ighọ elemhi e bi ọni oghie, ọ mu ọli ya shi owa ighumha ni a nali osue ya ramhi ni ọ rọ ya fali eni ota ni o lo nya. ");
INSERT INTO atgNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ina Itamhẹ na iloghie ọ li ya li ẹ ini aa rọte ekelemhi udu gbekua na inyọghuo ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Abi iJesu ọ rọ ngme se, ọ te ekẹ iGalili vu je ekẹ iJudia ukiẹkiẹ okẹ iJọdani, ");
INSERT INTO atgNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ebubu ẹgbọ ẹ vẹ deba li. Ọ rẹwẹ la aghọ ze. ");
INSERT INTO atgNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ẹgbọ iFarisi eghuo e bhale ya mu ọli fẹ ni e ba mẹ asha mu ingme ma li obọ. E mhila li, “Ushi oyawa o fẹ lama shi ọ ọmọse ọ ri itobọ emhikhọghuo khu ughuẹ ọli?” ");
INSERT INTO atgNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","IJesu ọ mhila wẹ, “Aa zẹ abi Ebe-no-pfuasẹ o ngme khi eri Ẹshinẹgba ni ọ ma ẹgbọ te igbaekẹle, ọ ma ẹgbọ ọmọse ali ọkpotso? ");
INSERT INTO atgNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ẹshinẹgba ọ gbolo ẹ, ‘Itobọ ona ọmọse ọ ya zẹ itali ali inyọli obọ, ọ to ma ughuẹ-ọli ọ, wẹwẹ ava e mele ọgbọ ọghuo-a.’ ");
INSERT INTO atgNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ẹghẹghẹ aghọ ẹa ke khi ava ama ọghuo. Itobọ ona, emini Ẹshinẹgba ọ she to ma, ọgbọ khi vasẹ ọli-a.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eni ẹgbọ iFarisi e mhila iJesu, “Elọ o zẹ khi Ushi oyi iMosisi o lama ọgbọ ọ nya ebe ipfa-ughuẹ-a mhọli ughuẹ ọli obọ, ọ khu ọli?” ");
INSERT INTO atgNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","IJesu ọọ wẹ, “Itobọ khi aa gbe udu o zẹ ni Ushi oyi iMosisi o rọ lama li na ẹ, ama ọa kpẹ te igbaekẹle lighọ. ");
INSERT INTO atgNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mhi gueyẹ ẹ khi ọnini ọ khu ughuẹ ọli ni ọa rọ khi itobọ okia, ni ọ rọ ya rue ọkpotso ọlese ne, o she kia okia.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eniyẹ odukhokho eyi iJesu ẹẹ, ini o khia khi ina o bie khi iteva ọmọse ali ughuẹ ọli, o bie ti nẹ ọgbọ khi rue ọkpotso shi. ");
INSERT INTO atgNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","IJesu ọọ wẹ, “Ọa khi ọgbọkpa oni osẹsẹ ona o gọ lu, sẹ ni eni Ẹshinẹgba ọ ri oni afu na e khi rue ọkpotso. ");
INSERT INTO atgNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Irari khi emhi ebubu ẹẹ zẹ khi ebubu ẹgbọ ẹa ya rue ọkpotso, eghuo, itobọ khi ighọ Ẹshinẹgba ọ ma wẹ, eghuo, itobọ khi ẹgbọ e rẹ wẹ khi ighọ, elese e ri egbewẹ mele ọwali-a ni e mẹ asha ga Ẹshinẹgba egbegbọ. Ọgbọ ni ọ dobẹ ya ri egbe mie oni osẹsẹ, ọ ri egbe mie.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ẹghẹghẹ aghọ, ẹgbọ eghuo e wolọ eniyẹ enikeke bhale ghi iJesu ini ọ ri obọ nga wẹ ukhomhi, ni ọ sọ iromhi na wẹ. Ama eniyẹ odukhokho eyọli ee khu wẹ, e ti je ukhokho. ");
INSERT INTO atgNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","IJesu ọọ wẹ “A zẹ ni ikuku eniyẹ e bhale deba mhẹ, a khi ke khu wẹ irari khi wẹwẹ enana e mhọli agbọ oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ọ ri obọ nga wẹ ukhomhi sẹ, ọ rọte aghọ vu. ");
INSERT INTO atgNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ọzẹo ọghuo ọ bhale ya mhila iJesu, ọọ, “Ọsẹsẹ ọnete, elọ mhi fẹ ya li ni mhi rọ ya mhọli agbọ onabi oyi Ẹshinẹgba?” ");
INSERT INTO atgNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","IJesu ọọ li, “Elọ o zẹ ni u rọ ọ lu mhẹ ọnete? Ẹshinẹgba luẹghuo kpe ọ lẹsẹ ti. Ini u wa nono ni u mhọli agbọ onabi oyọli, ri ishi eyọli gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ọ mhila iJesu, “Ishi eneghuo ọ?” IJesu ọọ li, “ ‘Khi gbe ugbeli, khi kia okia, khi do ughiatọ, khi pfi ọtsẹlẹ ẹgbhuẹ mu ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mu ekpẹ na itẹ ali inyẹ, gbo zẹ ni, u nono ingme oyi ọnuzava ọyẹ abi u li nono egbe ẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ọni ọzẹo ọọ iJesu, “Te ekẹ vu mhi te ri eni u ga ngme ena nya a gbe akanya, onoghuo o ke kpọ mhẹ le?” ");
INSERT INTO atgNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","IJesu ọọ li, “Ini u wa nono ni u gba pfo, lẹ ya ri itsua ni u mhọli nya dẹ u kemhi eni ikpaghọ na ẹgbọ ni ẹa mhọli, ni u mhọli ẹpfue shi obini iloghie. U tigbe bhale ke ya deba mhẹ kia.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Abi ọni ọzẹo ọ rọ suọ ona, egbe e pfọ li-a itobọ khi ọọ pfue gba. ");
INSERT INTO atgNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","IJesu ọọ eniyẹ odukhokho eyọli, “Mhi gue ọli ẹ yẹ ẹ khi, o ma munu ni ẹgbọ ni e pfue e zẹ ni Ẹshinẹgba ọ mhẹsẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mhi gbo gueyẹ ẹ khi, ni ọgbọ ni ọ pfue ọ rọ lo eghiele oyi Ẹshinẹgba, o ya munu dọsẹ, ni ọgbọ ke dua ni lọli ri akphẹrẹ rọte esẹ asugẹ ya fiẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Abi eniyẹ odukhokho eyi iJesu e rọ suọ ona, abọ e sha wẹ, e mhila li, “Ọghuo ọ ke dobẹ ya lo Eghiele oyi Ẹshinẹgba shọ?” ");
INSERT INTO atgNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","IJesu ọ bino wẹ, ọọ, “Ini a ri oyi ọgbọ ngme, ona o ya munu, ama obọ oyi Ẹshinẹgba, emhikpa o zẹ ọli ẹ riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","IPita ọ mhila iJesu, ọọ li, “Anye ni anye zẹ emhikpa obọ bhale deba ẹ ena, elọ anye ya mẹ ọ rue?” ");
INSERT INTO atgNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","IJesu ọọ wẹ, “Abi o li mhi li gue ọli ẹ yẹ ẹ khi ini Omi Ọgbọ ọ da shitọ ukpẹkhomhi ufumhi oyọli ẹghẹghẹ agbọ Onogbọ, ẹẹ ogbava ni a deba mhẹ a ya nu mhẹ shitọ ikpẹkhomhi igbẹva, a mhẹsẹ ẹ na ẹdẹli igbẹva eyi iZirẹni. ");
INSERT INTO atgNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ọgbọkpa ni ọ da zẹ owa oyọli obọ, okekhi inyọghuo ọli, ni ọ zẹ itali ali inyọli obọ ali inyọghuo ọli ali imiọli ali ẹpfue eyọli obọ shi itobọ oyẹmhẹ ne, ọ ya mhuẹ ẹpfue eghọghọ asha egbhuẹshe, ọ gbo mhuẹ agbọ onabi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama ẹgbọ eghuo ni e ralo e ya kpukhokho eni e kpe ukhokho, e ya ralo.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Eri Eghiele oyi Ẹshinẹgba o li abi ọmọse ọghuo ni ọ fiẹ lase ya wolọ ẹgbọ ẹluzogbe je ogba ipfonu oyọli ya gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ọ lama khi lọli ya fali ọgbọgbọ ingmẹ ni a mie ogbẹlẹ. Ọ rẹwẹ je ogba ẹẹra ipfonu oyọli ya gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Elemhi agogo itili ẹluzogbe, ọ fiẹ lasele, ọ mẹ khi emọse eghuo e migha elemhi oki ni ẹa mhuẹ oni ẹẹ gbe. ");
INSERT INTO atgNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ọọ wẹ, ‘A je ogba ẹẹra ipfonu oyẹmhẹ ya gbe akanya khi mhi ya fali ẹ emini o ti.’ ");
INSERT INTO atgNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ighọ e vu. “Elemhi agogo igbẹva ẹlẹ ọguota ali agogo esẹ ẹlẹ ogbọmhi, ọ gbo lighọ ya wolọ emọse elese. ");
INSERT INTO atgNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Agogo ishe o she ramhi, ọ gbo bhale ya ẹ emọse elese ni ẹa li gbe okhọghuo. Ọ mhila wẹ, ọ wẹ, ‘Elọ o zẹ ni a rọ migha ana amo kpa pfuse ẹghẹghẹ-a, ni aa rọ gbe okhọghuo?’ ");
INSERT INTO atgNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ẹ ọli, ‘Irari khi ọgbọkhọghuo ọa lu anye shi akanya lọ.’ “Ọọ wẹ, ‘A je ogba ipfonu oyẹmhẹ ya gbe akanya.’ ");
INSERT INTO atgNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ogbọmhi o ke mu ekẹ, ọni ọ mhuẹ ogba ọghọ, ọ lu ọni ọ ri ẹgbọ ẹ gbe akanya na li, ọọ, ‘Lu eni e gbe akanya ni u fali ọgbọgbọ ota. Ọ kpẹ rọte ẹgbọ ni e kpẹ ukhokho bhale fali ota ya ramhi eni e kpẹ bhale.’ ");
INSERT INTO atgNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ọ fali ẹgbọ ni e te agogo ishe ẹlogbọmhi gba akanya le ukpaghuo. ");
INSERT INTO atgNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Abi eni e te ododẹ gba akanya le e rọ bhale ya mie ifata, e dabi khi ikpaghọ eyẹwẹ e ya bu dọsẹ eni e kpe ukhokho bhale oni akanya. Ama a ga fali wẹ abizize. ");
INSERT INTO atgNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","E mie ifata se, ee wọlọ ọni ọ mhuẹ ishemhi. ");
INSERT INTO atgNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","E ọli, ‘Emọse ena ni a kpukhokho mie, iwakati oghuo e lẹsẹ gbe akanya, ama rọte ẹlẹ uzogbe fiefie anye te ri ukhomhi shi ovọ ya ramhi ogbọmhi. Ama u ya fali anye abizize!’ ");
INSERT INTO atgNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ọmhuẹ-ishiemhi ọ rọ ọtuọghuo elemhi wẹ, ‘Ọmuẹ, mhi aa liẹle. Ọa khi ukpaghuo-ghuo a lama na mhẹ shi akanya ogbẹlẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","A mọ ikpaghọ eyẹ ẹ ni a ke je apfẹ. Onoghuo o de ẹ shi ọ ini mhi fali ọmọse ni mhi kpukhokho mie abi mhi fali ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Abi khi mhia dobẹ ya li ikpaghọ eyẹmhẹ abi o ghọle mhẹ? Eri a kẹ kpe ofuma irari khi mhi da khi ọgbọ ni ọ somhopfa?’ ");
INSERT INTO atgNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ama ẹgbọ eghuo ni e ralo e ya kpukhokho eni e kpe ukhokho e ya ralo.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Abi iJesu ọ rọ ọ nga iJerusalẹmu, ọ lu eniyẹ odukhokho eyọli je asheghuo ya gueyẹ, ọọ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“IJerusalẹmu ni awa je ena, a ya la oobọ ri Omi Ọgbọ na ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi dẹ, aghọ e la ya pfa ẹzọ igbe-a mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","E tigbe rue ọli na ẹgbọ iJẹta, e rọli li egia, e gbe ọli itẹ, e ta li ma apfida, ama ẹlẹnuzi-esẹ, a guise ọli le bhale agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ighọ ughuẹ iZebedi ọ rue imi ọli ava bhale deba iJesu, ọ wugha li odalo, ọọ li ọ kpẹkpẹ ọ somhi luẹ opfa. ");
INSERT INTO atgNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","IJesu ọ mhila li, “Elọ wa nono.” Ọọ li, “Lama na mhẹ khi imimhẹ aava ena, khi ọghuo ọ kha shitọ ẹ obọ ita, ọnọkpọle ọ shitọ ẹ ọgobọ eghiele oyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","IJesu ọọ wẹ, “Aa lẹsẹ emini a mhila. A ya dobẹ da uko osoli ni mhi ya da?” Ẹ ọli, “Anye ya dobẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","IJesu ọọ, “A rọte uko ni mhi te da ya da, ama, ọa khi mhẹmhẹ mhi ya zẹ ọni ọ ya shitọ mhẹ obọ ita ali ọgobọ. Eni Ita ọ riẹlẹ wẹ shi na e mhọli wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Abi eniyẹ odukhokho ogbe enekpọle e rọ suọ, e pfaa na ọgbọ ali inyọghuo eghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ighọ iJesu ọ lu wẹ tigbili, ọọ wẹ, “A lẹsẹ khi ighie eyi ẹgbọ iJẹta eri ẹẹ jili ẹgbọ eyẹwẹ. Eni e kpeda e ri omhẹsẹ ri itoto ẹ sha wẹ ma. ");
INSERT INTO atgNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama, ọa khi ighọ iteva oyẹ ẹ. Ọni ọ da nono ni lọli fu ne, ọ khi ọni ọọ ga enekpọle. ");
INSERT INTO atgNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ini ọngẹẹ ọọ nono ni lọli khi ọnododẹ, ọ mele ọni ọọ ga ọyi enekpọle a. ");
INSERT INTO atgNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ẹzẹzẹ abi Omi Ọgbọ, ọa li bhale ni a ke ga li, ama ọ bhale ni ọ rọ ga ẹgbọ ali ni ọ gbo ri agbọ oyọli mie ebubu pfuese.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","IJesu ali eniyẹ odukhokho eyọli e rọte iJẹriko vu, ebubu ẹgbọ e vẹ deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Emọse ezalo aava e shitọ epfẹ-odẹ. Abi e suọ khi iJesu ọ rọte aghọ dọsẹ. E tsẹsẹ, e liẹ. “Ọnọmhuẹ, Omi iDefidi, lẹ elemhi anye.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Oni ebubu ẹgbọ e dese wẹ, e khukhu unu, ama e kiele tsẹsẹ leghe, e liẹ, “Ọnọmhuẹ, Omi iDefidi kpẹkpẹ lẹ elemhi anye.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ighọ iJesu ọ migha, ọ lu wẹ, ọọ wẹ, “Elọ a nono ni mhi riẹlẹ na ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ẹẹ ọli. “Ọnọmhuẹ, kpẹkpẹ anye ẹ nono ni u khueghie anye alo-a.” ");
INSERT INTO atgNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","IJesu ọ mhuẹ ilẹlemhi na wẹ, ọ ri obọ ti wẹ alo, eni alo e khueghie-a, e deba li. ");
INSERT INTO atgNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Abi iJesu ali eniyẹ odukhokho eyọli e li ti i mama iJerusalẹmu, e bhale ikuku ẹoli na lui iBẹtifagi ni o la Ute ẹẹra Olivu. IJesu ọ la aghọ ghie eniyẹ odukhokho eyọli aava je ẹoli ni o la odalo. ");
INSERT INTO atgNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ọọ wẹ, “A je ẹoli ni a fẹ odalo oyẹẹ ena, khi a ya mẹ akphẹrẹ ali omiọli. A taghiẹ wẹ-a, a mu wẹ ghi mhẹ ana. ");
INSERT INTO atgNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ini ọgbọkhọghuo ọ mhila ẹ emhikhọghuo, a gueyẹ ọli khi Ọnọmhuẹ ọ ya rẹwẹ riẹlẹ emhi, ọ gbo ya nyenẹ wẹ bhale lẹna.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eri a mẹ enana ni a rọ bhale ya ẹ khi ungmemhi ni emekẹguele e ngme, ni e bhale ya tsẹ. Ni ọọ ");
INSERT INTO atgNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“A gueyẹ ẹdẹli iZayọ, ‘A bino khi oghie ọyẹ ẹ ọọ bhale deba ẹ. Ọ mhọli ikuegbe-a, ọ nga ozele akphẹrẹ, ikhi Omi akphẹrẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ighọ eniyẹ odukhokho eyi iJesu e ye abi ọ ghie wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ighọ e rue ọni akphẹrẹ ali omi ọli bhale, e banọ ide eyẹwẹ egbe nga li egbe, iJesu ọ nga li shitọ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ebubu ẹgbọ e gueghie itsua eyẹwẹ naghiẹ-a shi odẹ, eghuo e kholo eyamhi naghiẹ-a shi odẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eni ẹgbọ ni e ralo ali eni e kpe ukhokho e tsẹsẹ, e kuẹghiẹ ọli, e liẹ, “Tsumhi anye, Tsumhi anye, Omi iDefidi!” “Ikhivọsẹ khi ọni ọ ri eva oyi Ọnọmhuẹ bhale.” Ikuẹghiẹ khi oyi Ẹshinẹgba. “Tsumhi anye.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Abi iJesu ọ rọ lo elemhi iJerusalẹmu, oni ẹdẹli nya o wushe-a, ẹgbọ e mhila, e liẹ, “Ọghuo ọni ọmọse onana ọ fẹ khi?” ");
INSERT INTO atgNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eni ẹgbọ ni e nu ọli kia e gueyẹ wẹ, ẹẹ “Ọna khi iJesu ọni ọmekẹguele ọnge iNazarẹti na ekẹ iGalili, ni a shobọ na awa khi ọọ bhale, ikhi ọni awa migha khẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","IJesu ọ lo elemhi Owa Oyi Ẹshinẹgba. Ọ khu ẹgbọ ni e la elemhi ọli ẹ du oki kua. Ọ ghino wẹ abọ itebu ni e la ngmomhi ikpaghọ kua, ali ibẹchi oyi eni e ri inekhukhu u ẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ọọ wẹ “A she kẹkẹ ọli shi Ebe-no-pfuasẹ, ‘Owa oyẹmhẹ, owa ni a la lema o khi,’ ama a she rọli mele owa oyi ighiatọ-a.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ezalo ali eni e guọghọ awẹ-a e bhale deba li obini Owa Oyi Ẹshinẹgba, Ọ rẹwẹ ze nya. ");
INSERT INTO atgNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Abi ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi e rọ mẹ khi iJesu ọọ gbe ikanya ọnyaloa ọdọda, elemhi Owa oyi Ẹshinẹgba, ali khi eniyẹ e la akaghọ tsẹsẹ leghe kuẹghiẹ ọli, e liẹ, “Ikuẹghiẹ o khi oyi Omi iDefidi,” elemhi e bi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ighọ e mhila iJesu, ẹ ọli “Wa a suọ abi eniyẹ ẹẹ ngme ẹ?” IJesu ọọ, “Mhi suọ.” Ọ mhila wẹ, “Aa kpẹ suọ abi Ebe-no-pfuasẹ o ngme ni ọ. “ ‘U she ri eniyẹ ali emọfẹ kuẹghiẹ ikuẹghiẹ ni o gba pfo’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","IJesu ọ te aghọ vu je iBẹtani. Ọ gbhẹ aghọ ni ogbe o gbe. ");
INSERT INTO atgNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ẹlẹ uzogbe abi ọ ke rọ nyenẹ egbe ukhokho je iJerusalẹmu, okiamhi o gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ighọ ọ mẹ ọkhua-eni epfẹ odẹ, ọ lẹ ya bino ọli, ama ọa mẹ udumhi okhọghuo ukhomhi ọ, sẹ ni ebebe. Ighọ ọọ oni ọara oghọ “Wa gbo ya mọ udumhi ghue!” Aghọaghọ oni ọara o ku ebe-a. ");
INSERT INTO atgNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abi eni eniyẹ odukhokho eyọli e rọ mẹ ọli, abọ e sha wẹ. E mhila li, ẹẹ. “Sẹ o li kia khi oni ọkhua o rọ ghọ nyanya ku ebe-a?” ");
INSERT INTO atgNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","IJesu ọọ wẹ, “Mhi gueyẹ ẹ khi, ini a mhuẹ irudunga ni aa rọ mhuẹ akhọkhọmhẹ, a ya dobẹ li emini mhi li oni ọkhua ona. Ọa khi onana tsẹ, a ya liẹ oni ute ona, ‘Vu ya de pfilo okẹ oniẹmhi,’ oni ute o suọ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Irari khi ini a mhuẹ irudunga, emiemini a sọ iromhi mhila a ya mhọli ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","IJesu ọ lo elemhi apfẹ oyi Owa oyi Ẹshinẹgba le, ighie eyi ekpodalo-ugamhi ali eni egbhali e mhila li, “Afu eyi ọghuo u rọ gbe ikanya enana? Ọghuo ọ ri afu nẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","IJesu ọọ wẹ, “Mhẹmhẹ mhi ya li mhila ẹ ogbọ oghuo, ini a da gbaghiẹ ọlia ne, mhi ya gueyẹ ẹ ọni ọ ri afu ona na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mhiẹ i, ibatazi ni iJọni ọọ batazi na ẹgbọ, ọghuo ọ ri afu na li ọ ke batazi ẹgbọ? Ẹgbọ e ri ọli na li abi khi Ẹshinẹgba lọ?” E nu egbewẹ khakọ, e liẹ, “Ini awa ẹ khi ‘Obọ oyi Ẹshinẹgba o te bhale,’ ọ ya mhila awa, ‘Elọ o zẹ ni aa rọ mie ọli suọ?’ ");
INSERT INTO atgNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama ini awa ẹ khi, ‘Obọ oyi ọgbọ o te bhale,’ ulishi apfọwa ọọ mu awa, irari khi ọgbọkpa ọ lẹsẹ khi ọmekẹguele iJọni ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Itobọ ighọ e kẹ iJesu “Anye aa lẹsẹ.” IJesu ọọ wẹ “Mhẹmhẹ mhi aa li ya gueyẹ ẹ obini mhi te mẹ afu.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Sẹ a mẹ ona shi? Ọmọse ọghuo ọ mhuẹ eniyẹ emọse aava. Ọ bhale deba ọni ọgbhali, ọọ li, ‘Ọmọ ke lẹ ogba ipfonu amo ni u ya gbe akanya.’ ");
INSERT INTO atgNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ọọ itali, ‘Mhi a ya ye.’ Ama o li dẹnẹ, ọ mu udu pfi, ọọ lẹ oni ogba ipfonu. ");
INSERT INTO atgNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ọni itawẹ ọ gbo lẹ deba ọnikeke, ọ gbo ngme ọli abi ọ kpẹ ngme ọni ọgbhali. Ọni ikeke ọghọ ọ lama khi lọli ya ye, ama ọa tigbe ye. ");
INSERT INTO atgNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ọnọghuo eniyẹ aava ena ọ riẹlẹ emini itawẹ ọ nono?” Ẹẹ iJesu, “Ọni ọgbhali.” IJesu ọọ wẹ, “Abi o li mhi li gue ọli ẹ yẹ ẹ khi emionoga ali idegbe e she pfi ẹ shi ana kpẹ lo Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Irari khi abi iJọni Ọni ọọ batazi ẹgbọ ọ̀ọ́ bhale ya sẹsẹ ẹ odẹ ni a ya rọte, ni aa lama mie ọli suọ. Ama emionoga ali idegbe e mie ọli suọ, e mu pfi. Abi a tseku ri ẹloe oyẹẹ mẹ, aa kie mu udu pfi ni a miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“A suọ okhẹ irọkhọkhọ olese. Ọmhuẹ-apfẹ ọghuo ọ ya laọ ni ọ gua ogba ipfonu shi ukhokho apfẹ oyọli. Ọ khi ogba gasẹ ọli, ọ riẹlẹ ashini a la nye onyọ shi ọ, Ọ gbo tọ owa ni o yagha ni a la khẹ-ekhẹ shi ọ. Ọ rọli na ẹgbọ e ke ri ẹloe khu ọli, ọ vu ẹoli oboese. ");
INSERT INTO atgNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Abi ẹghẹghẹ ikhiẹsẹ o rọ ramhi, ọ ghie eni ẹẹ ga eyọli ghi eni ẹgbọ, e ka mie wẹ eni e khi eyẹluẹ ghi luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Eni ẹgbọ ni ọ rọ shi oni ogba oghọ, e mu eni eni ẹẹ ga eyọli, e gbe ọghuo, e gbe ọghuo-a, e tono ọnọkpọle echẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ighọ ọni ọmọse ọ gbo ghie eni ẹẹ ga elese ghi wẹ ni e ke bu dọsẹ eni ọ kpẹ ghie. Ighọ eni e la oni ogba e li wẹ abi e kpẹ li eghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ikpukhokho ọ, ọ ghie omi ọli ghi wẹ. Ọọ, ‘E ya mu ekpẹ na li.’ ");
INSERT INTO atgNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ama abi eni e la oni ogba e rọ mẹ khi ọni omi ọli ọọ bhale, e lu egbewẹ ochi, ẹẹ egbe, ‘Awa gbe ọni omi ọli-a, ni awa le ugu oyọli.’ ");
INSERT INTO atgNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ighọ e mu ọli e rue ọli je olase oni ogba, e gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Irarighọ, ini ọni ọ mhuẹ oni ogba ipfonu oghọ ọ fẹ bhale, sẹ ẹẹ a sa khi ọ ya li eni ẹgbọ eghọ?” ");
INSERT INTO atgNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ẹẹ iJesu, “Eri ọ ya gbolo eni ẹgbọ ọkhọlọ eghọ-a, ọ ri oni ogba na ẹgbọ elese, eni e ya ke ri eni e khi eyọli ghi ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","IJesu ọọ wẹ, “Ẹẹ a kpẹ zẹ ọli abi a li kẹkẹ ọli shi Ebe-no-pfuasẹ khi: “ ‘Ẹchẹ ni itsọna e kie pfia, lọli o ke ya mele egbegbi ẹchẹ ni o kẹ mu ẹloe nẹ nya-a. Ọnọmhuẹ ọ lighọ riẹlẹ ona, óó ti anye ẹloe gba’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Irarighọ, ighọ a li ya mie ẹ Eghiele oyi Ẹshinẹgba obọ, a rue ọli na ẹgbọ ni ẹ riẹlẹ emini Ẹshinẹgba ọọ a ke riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ọgbọ ni ọ da ya de nga oni ẹchẹ ne, ọ ya guọghọ-a, ama ọgbọ ni oni ẹchẹ o da de nga egbe ne ọ ya mhẹli-a abi ifufu.” ");
INSERT INTO atgNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Abi ighie eyi ekpodalo-ugamhi ali ẹgbọ iFarisi e rọ suọ oni okhẹ irọkhọkhọ ona, e lẹsẹ khi wẹwẹ iJesu ọ nu ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","E nono odẹ ni wẹwẹ e tẹ mu ọli ya khukhu, ama ulishi o mu wẹ irari khi ẹgbọ e lẹsẹ khi ọmekẹguele iJesu ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","IJesu ọ gbo ri okhẹ irọkhọkhọ ona nu wẹ ngme, ọọ, ");
INSERT INTO atgNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Eri Eghiele oyi Ẹshinẹgba o li abi oghie ọghuo ni ọ gbhẹ ukue na omiọli ni ọọ rue ọmueshi. ");
INSERT INTO atgNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ọ ghie eni ẹẹ ga eyọli e ka gueyẹ ẹgbọ ni ọ gbhẹ oni ukue na e bhale, ama ẹa lama ye. ");
INSERT INTO atgNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ighọ ọ gbo ghie eni ẹẹ ga elese, ọọ wẹ, ‘A ka gueyẹ eni a lu shi oni ukue khi mhi she nye ekhe shi ekẹ. Mhi she gbolo ena-a, ena ni e mhuẹ ila, shi elamhakọ eyẹmhẹ, a she mu egbe emhikpa shi ekẹ. A bhale oni ukue ikhuẹsẹ ọmueshi.’ ");
INSERT INTO atgNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ama eni ẹgbọ ẹa pfi esọ shi, e vu asha. Ọghuo ọ vu ishemhi, ọlese ọ vu oki. ");
INSERT INTO atgNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Eghuo ọ ni a lu shi oni ukue e mu eni eni ẹẹ ga eghọ, e gbe wẹ, e gbolo wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ighọ elemhi e bi ọni oghie, ọ ghie ekhọli-okhuẹ eyọli, e ka gbolo eni ẹgbọ ni e gbolo eni ẹẹ ga eyọli-a, e tosẹ wẹ apfẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ighọ ọni oghie ọ luno eni eni ẹẹ ga eyọli, ọọ wẹ, ‘A she mu egbe ukue oyẹmhẹ shi ekẹ se, ama ẹgbọ ni mhi lu shi ọ, ẹa khi eni a kha lu shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mena, a ke je ifu ẹoli ikpe ni ebubu ẹgbọ e legba, ọgbọkpa ni a da mẹ ne, a lu ọli bhale oni ukue.’ ");
INSERT INTO atgNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ighọ eni eni ẹẹ ga e lo ifu ẹoli e luno ẹgbọ ni e mẹ kpa tigbili, ghe ẹgbọ enete ali ikhiakhiamhi ẹgbọ. Oni ashini a gbhẹ oni ukue shi o vọ ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ama abi ọni oghie ọ rọ bhale ya bino eni ẹgbọ, ọ mẹ khi ọmọse ọghuo ọ la aghọ ni ọa sọ itsua ukue ni a rọ khuẹsẹ ọmueshi ye ughuẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ọni oghie ọ mhila li, ‘Ọmuẹ sẹ u li lo ana le ni u wa rọ sọ itsua oyi ukue ni a rọ khuẹsẹ ọmueshi,’ Ọni ọmọse ọa dobẹ sọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ighọ ọni oghie ọ gueyẹ eni eni ẹẹ ga eghọ, ‘A mu ọli gẹ abọ ali awẹ, a tsua li pfi je olase alo ebili ni a la viẹ, ni a la le akọ akọ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ọgbọkpa a lu ama ikuku wẹ ni e mie oni ulumhi, a zẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ighọ ẹgbọ iFarisi e fiẹ ya gba abi e li ya ri omhila mẹ asha mu iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","E ghie eniyẹ odukhokho eyẹwẹ ali eniyẹ odukhokho eyi Erọdu deba iJesu, ẹ ọli, “Ọsẹsẹ, anye lẹsẹ khi ọgbọ igẹsikia u khi, u gbolo ẹ sẹsẹ igẹsikia oyi ọghuẹmhẹ oyi Ẹshinẹgba. Wa a ya na ulishi oyi ọgbọkhọghuo, itobọ khi ẹgboliẹ ọa la ọnini ọgbọ ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gueyẹ anye, sẹ o fẹ li udu oyẹ? Abi ushi oyawa o ngme, o fẹ ti ni awa zẹ oga na oghie iSiza abi khi ọa ti?” ");
INSERT INTO atgNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","IJesu ọ lẹsẹ ugbamhi obe ni e gba, ọọ wẹ, “Ẹẹ eri ugamhi ku alo, elọ o zẹ ni a rọ nono ni a di mhẹ mu? ");
INSERT INTO atgNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","A rue ukpaghuo ni a rọ zẹ oga khasẹ mhẹ ghue!” Ighọ e rue ukpaghuo bhale ghi ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ọ mhila wẹ “Alo eyi ọghuo na? Eva oyi ọghuo na?” ");
INSERT INTO atgNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ẹ ọli “Eyi iSiza.” Ighọ iJesu ọọ wẹ, “Irarighọ, a ri oni o khi oyi iSiza na iSiza a ri oyi Ẹshinẹgba na Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Abi e rọ suọ ona, abọ e sha wẹ, e zẹ ọli obọ, e vu. ");
INSERT INTO atgNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Oni ogbẹlẹ ẹlẹghọ, ẹgbọ iSadusi ni ẹ khi iteghuli guale ọa la ọ, e bhale deba iJesu ya mhila li ogbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ẹ ọli “Ọsẹsẹ, iMosisi ọ gueyẹ anye khi, ini ọmọse ọ ghu-a ni ọa rọ bia eniyẹ, inyọghuo ọli ọ rue ọni ọsamhi olimhi ni ọ bia eniyẹ na li na inyọghuo ọli ni ọ ghu-a ọghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mena inyọghuo etuoshilua e ke nu anye la ana. Ọni ọgbhali ọ rue ọkpotso ọ ghua, abi ọa rọ bia eniyẹ, ọ zẹ ọni ọkpotso obọ na inyọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ighọ eghuli o li gbe inyọghuo ọli ọnuzava ali ọnuzasẹ ya ramhi ọnuzi-oshilua ẹa ga bia ọmọ ọkhọghuo na ọni ọkpotso. ");
INSERT INTO atgNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ikpukhokho ọ ọni ọkpotso ọ ghu a. ");
INSERT INTO atgNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mena, ogbẹlẹ iteghuli guale, ughuẹ ọghuo ọ fẹ ya khi elemhi ẹwẹ nya, aborọkhia khi wẹwẹ oshilua e ga rue ọli shi?” ");
INSERT INTO atgNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","IJesu ọọ wẹ, “Eri a da odẹ! Itobọ khi aa lẹsẹ ungmemhi oyi Ẹshinẹgba ali itoto eyọli lọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Irari khi ini ẹgbọ e rọte eghuli guale, ẹa ke ya rue ikpotso, wẹ khi ikpotso e ke ya ke ngeli na emọse, eri e ke ya li abi igẹni na iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ama oyi ingme ite-eghuli-guale oyi ẹgbọ ni e ghu-a ne, eri aa suọ abi Ẹshinẹgba ọ ngme ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ọ khi, ‘Mhẹmhẹ mhi khi Ẹshinẹgba ọyi Aburaamu ali Ẹshinẹgba ọyi Aziki, ali Ẹshinẹgba ọyi iGiekọpu.’ Ẹshinẹgba ọyi ẹgbọ ni e la agbọ ọ khi, ọa khi Ẹshinẹgba ọyi ẹgbọ ni e ghua.” ");
INSERT INTO atgNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Abi eni ebubu ẹgbọ e rọ suọ ona, abọ e sha wẹ shi osẹsẹ ni ọ sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Abi ẹgbọ iFarisi e rọ suọ khi iJesu ọ pfi ẹgbọ iSadusi okpẹ unu, e le gba. ");
INSERT INTO atgNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ọghuo ọ elemhi wẹ ni ọ khi ọsẹsẹ ushi ọ rọshẹka ni lọli dobẹ ri ushi mu iJesu. Ọ mhila li ogbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ọọ li, “Ọsẹsẹ, Ushi onoghuo o ga funẹ nya elemhi Ishi eyi iMosisi?” ");
INSERT INTO atgNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","IJesu ọọ li, “ ‘Ri udu oyẹ nya ali ayẹmhẹ oyẹ nya ali usamhi udu oyẹ nya nono ingme oyi Ọnọmhuẹ Ẹshinẹgba ọyẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Onana o khi ushi onododẹ ali oni o ga fu nẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Eri onuzi-eva o gbo li abi lọli, ni ọọ li, ‘Nono ingme oyi ọgbọ ọlese abi u li nono ingme egbe ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ishi eva ena elemhi Ishi eyi iMosisi ali emekẹguele nya, e te zẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Abi ẹgbọ iFarisi e kie li la aghọ eghọ, iJesu ọ mhila wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sẹ a khọkhọ shi Ọmiepfuese ọ? Omi ọghuo ọ fẹ khi?” Ẹ ọli “Omi iDefidi.” ");
INSERT INTO atgNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","IJesu ọọ wẹ, “Elọ o ke ze khi iDefidi ọ rọte elemhi ayẹmhẹ lu ọli, ‘Ọnọmhuẹ’? Irari khi iDefidi ọ liẹ, ");
INSERT INTO atgNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Ọnọmhuẹ gueyẹ Ọnọmhuẹ ọyẹmhẹ. Shitọ mhẹ ukiẹkiẹ obita ramhi ni mhi rọ ya ri ebe ẹ shi ẹ ufu ẹkowẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ini iDefidi ọ lu ọli ‘Ọnọmhuẹ,’ sẹẹ ọni Ọmiepfuese ọ ke gbolo ẹ khi omiomi iDefidi?” ");
INSERT INTO atgNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ọngẹwẹ ọa dobẹ gbaghiẹ oni ogbọ-a. Rọte ẹlẹghọ vu ọgbọ okhọghuo ọa ke gbo gbudu mhila li ogbọ okhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ighọ iJesu ọ nu ẹgbọ ni e ri esọ shi ọli ekẹ ali eniyẹ odukhokho eyọli i ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ọọ wẹ, “Esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi a ri afu na ni e ke guele abi Ushi oyi iMosisi o ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Irarighọ, a mema ya suọ esọ na wẹ, a li abi e gueyẹ ẹ a ke li, ama a khi khọnya wẹ ngeli ingeli enabi eyẹwẹ. Irari khi wẹwẹ ẹa ri emini ẹẹ sẹsẹ ẹgbọ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eri ẹ gẹ itsua ni e khọ na ẹgbọ tsua. Ama wẹwẹ ọyẹwẹ ẹa lama ri umiesobọ da wẹ ọ kpaghiẹ wẹ tsua eni itsua. ");
INSERT INTO atgNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Emhikpa e ri abamẹmhẹ ẹ riẹlẹ. E ri ọgbẹnẹ ni a fia ọtsuọtsuọ shi mu alukpo ali abọ. E pfi emini a rọte ebe-no-pfuasẹ kẹkẹ emhi shi lo eni ọtsuọtsuọ. E gbo fia emhi na yayagha na dọlọdọlọ shi esọ iwulu ni ẹẹ sọ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ashini o mhuẹ ekpẹ ukue ali ikpẹkhomhi ni e funẹ ọọ ghọle wẹ ini e bhale owa ugamhi. ");
INSERT INTO atgNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","E ma nono ni a ke tsẹ wẹ otsẹ ekpẹ atuoki, ali ni a gbo ke lu wẹ, ‘Ọsẹsẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ama ẹẹ ọyẹ ẹ a khi lama ni ẹgbọ e lu ẹ ‘Osẹsẹ,’ irari khi Ọga ọghuo ọ ga mhọli ẹ nya, a gbo khi inyọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A khi lu ọgbọkhọghuo agbọ ona ‘Ita,’ irari khi Ita ọghuo kpe a mhuẹ, iloghie ọ la. ");
INSERT INTO atgNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wẹ khi a zẹ ni ọgbọ ọ lu ẹ ‘Ọsẹsẹ,’ irari khi Ọsẹsẹ ọghuo kpe a mhuẹ ni ọ khi iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ọni ọ ga funẹ elemhi ẹ, ọ mema mele ọni ọọ ga ọyẹẹ a. ");
INSERT INTO atgNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ọnini ọ da ya ti egbọli nga ne, a ya ti ọli tiemhile. Ama ọnini ọ da ti egbọli tiemhile ne, a ya ti ọli nga. ");
INSERT INTO atgNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“O ma khọlọ ẹ egbe, ẹẹ esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi erugamhi-ku-alo, ni e pfi okpẹ odẹ iloghie zuse ẹgbọ shi olase. Ẹẹ oyẹẹ na, aa lama lo elemhi ọ wẹkhi eri a zẹ ni eni ẹ nono ni wẹwẹ e lo, ni e mẹ asha le. ");
INSERT INTO atgNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O ma khọlọ ẹ egbe, ẹẹ esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi! Ẹẹ eri-ugamhi ku alo! Eri a li esamhi olimhi le, ni a ri abamẹmhẹ a sọ iromhi ni o nuata. Itobọ ighọ a ya na ẹ osoli egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“O ma khọlọ ẹ egbe, ẹẹ esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi erugamhi-ku-alo! A ga rọshẹka kia ekẹ ali ukhomhi okẹ ye obini odonuẹ ya nono ọgbọ mu pfi lama shi osẹsẹ oyẹẹ. O kha da tsẹ na ẹ se, osoli ni ọni ọgbọ ọghọ ọ ke ya mẹ ilimhi iriẹriẹ, o ke fu dọsẹ oni ẹẹ a ya mẹ agbhagbhamhi eva. ");
INSERT INTO atgNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“O ma khọlọ ẹ egbe irari khi ezalo a khi ni a sẹsẹ ẹgbọ. Ẹẹ ni a sẹsẹ khi, ‘Ini ọgbọ ọ romhi Owa Oyi Ẹshinẹgba ọa mhuẹ abi o ngme, ama ini ọ romhi igolu ni o la ukhomhi oni Owa Oyi Ẹshinẹgba, oni ishe o ya mu ọli.’ ");
INSERT INTO atgNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ẹẹ eyẹghẹ, ezalo, onoghuo o fẹ funẹ? Igolu abi Owa oyi Ẹshinẹgba ni o ri oni igolu rọ khi oni o pfuasẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A gbolo ẹ sẹsẹ ẹgbọ khi ini ọgbọ ọ romhi atẹtẹ khi ọa mhuẹ abi o ngme, ama ọ khada romhi emini a rọ luasẹ oni atẹtẹ, oni ishe o ya mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ẹẹ ezalo, onoghuo o fẹ funẹ? Emini a rọ luasẹ obo ni o la ukhomhi oni atẹtẹ abi oni atẹtẹ ni o ri oni iluasobo khi oni o pfuasẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Itobọ ighọ, ini ọgbọ ọ da romhi atẹtẹ ne, oni atẹtẹ ali emini o la ukhomhi ọli nya ọ romhi eghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ini ọgbọ ọ romhi Owa Oyi Ẹshinẹgba, oni Owa Oyi Ẹshinẹgba ali Ẹshinẹgba ni ọ la ọ ọ romhi eghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ini ọgbọ ọ romhi iloghie, ukpẹkhomhi oyi Ẹshinẹgba ali ọni ọ shitọ ọ ọ romhi eghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“O ma a khọlọ ẹ egbe, ẹẹ esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi. Ẹẹ erugamhi-ku-alo. Aa zẹ azẹ-oghuo-igbe oyi ebe akhọkhọ ali okphasa, ama a ri ẹloe ẹ gbe emini e mu ẹloe shi elemhi ishi, nabi, umha gbe azẹba ali isomhelemhi ali igbe akanya te ode igẹsikia. Enana khi egbegbi emini a kha riẹlẹ, aa kha pfi enana shi ekẹ ni aa riẹlẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ẹẹ ezalo ni a ri ẹgbọ ọ kia, a pfiolo akia onyọ-a, ama a to akphẹrẹ luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“O ma a khọlọ ẹ egbe, ẹẹ esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi, erugamhi-ku-alo. A kpe ukhokho iko ali itasa-a, ama emini a ri emhi itoegbe ali ufa mie e vọ elemhi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ẹgbọ iFarisi ezalo! A kpẹ ke kpe elemhi uko ali utasa-a ne, ẹghẹghẹ aghọ ikhokho wẹ e li pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“O ma a khọlọ ẹ egbe, esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi, erugamhi-ku-alo. Eri a li abi uji ni a ri ẹtseli opfopfo gbolo-a, ni o te odato ọli ti ẹloe, ama elemhi wẹ, e vọ igua ẹgbọ ni e ghu-a ni e kẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ighọ a lili ẹ li, eri a rọte odato idiegbe ga li abi egbegbi ẹgbọ, ama ọkhọlọ ali irugamhi ku alo, o vọ ẹ elemhi. ");
INSERT INTO atgNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“O ma a khọlọ ẹ egbe ẹẹ esẹsẹ Ishi eyi iMosisi ali ẹgbọ iFarisi, erugamhi-ku-alo! A ga tọ iji na emekẹguele a riẹlẹ iji eyi eni e guẹ ngeli somhotse. ");
INSERT INTO atgNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A gbolo ọ liẹ, ‘Ini anye la agbọ ẹghẹghẹ oyi itita anye lọ, anye a kha nu wẹ mhọli obọ shi emekẹguele igbolo-a.’ ");
INSERT INTO atgNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eri a ri ona pfi ọtsẹlẹ mu egbe ẹ khi a lama shi ọ khi imimi eni e gbolo emekẹguele-a, a khi. ");
INSERT INTO atgNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","A ke je odalo, ni a pfuse gbe ikanya ni ititaẹ e gbaekẹle gbe. ");
INSERT INTO atgNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ẹẹ enyẹ ali imi enyẹ, sẹ a dabi khi a li ya na pfue ilimhi iriẹriẹ ni ọọ bhale? ");
INSERT INTO atgNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Itobọ ighọ mhi ya gueyẹ ẹ khi mhi ya ghie emekẹguele ghi ẹ ali ẹgbọ ni e fialo-a ali esẹsẹ ni e bu, a ya gbolo eghuo ọ-a, a tanọ wẹ ma apfida, elese a gbe wẹ itẹ elemhi owa ugamhi eyẹ ẹ, a khu wẹ te ẹoli oghuo ya je olese. ");
INSERT INTO atgNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Itobọ ighọ a ya ri ọlia eyi ẹgbọ eni e pfuasẹ nya ni a gbolo-a shi ekẹ agbọ ona mu ota sọ ẹ, rọte idiegbe oyi Ebẹli ni ọa mhuẹ abi ọ li vu, ya ramhi idiegbe oyi iZakaraya omi iBẹrẹkaya ni a gbe-a shi agadamhi eva atẹtẹ ali Owa Oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Abi o li mhi li gue ọli ẹ yẹ ẹ khi, osoli ni a ya mẹ shi ugbeli ni a gbe idiegbe oyi ẹgbọ eghọ, ẹgbọ na agbhotu ona oni osoli o ya de rughu.” ");
INSERT INTO atgNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","IJesu ọ rọ liẹ, “Eekhue-oo! IJerusalẹmu, iJerusalẹmu! A gbolo emekẹguele-a, a tono eni Ẹshinẹgba ọ ghie ghi ẹ echẹ gbolo-a. Iti-ingmi-ingmẹ mhi she rọshẹka ni mhi kolo ẹgbọ eyẹ ẹ kugbe, abi ọkhọkhọ ọ liẹ kolo imiọli shi ifui ipfua, ama aa lama na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ghe i! Ẹshinẹgba ọ ya te Owa oyi Ẹshinẹgba oyẹ ẹ vu, o mele afuẹ a. ");
INSERT INTO atgNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mhi gueyẹ ẹ khi rọte memena vu, khi aa ke gbolo ya mẹ mhẹ ya ramhi ni ẹghẹghẹ ni a rọ ya ke liẹ, ‘Oghẹlẹ o khi ni ọni ọ ri eva oyi Ọnọmhuẹ bhale.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Abi iJesu ọ rọte oni Owa oyi Ẹshinẹgba fiẹ lasele, eniyẹ odukhokho eyọli e rọli khasẹ ugbe oyi oni owa. ");
INSERT INTO atgNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","IJesu ọ rọ wẹ, “A ga mẹ emhi enana nya, ama mhi gue a yẹ ẹ khi aa mẹ ẹchẹli ni a rọ nga egbe egbe rọ tọ oni owa ona ni aa ya che kua.” ");
INSERT INTO atgNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Abi iJesu ọ li shitọ ukhomhi Ute ẹẹra Olivu, eniyẹ odukhokho eyọli e bhale ya ye ọli ochi, ẹẹ ọli. “Gueyẹ anye ẹghẹghẹ ni eni ingme enana e rọ bhale ya tsẹ, ali emini a ya ke mẹ ni anye rọ ya lẹsẹ khi a she ramhi ukpẹsẹ agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","IJesu ọ sọ wẹ ọ, ọọ. “A ke tọkpẹ ekẹ ini ọgbọkhọghuo ọ khi di ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Irari khi ebubu ẹgbọ e ya ri eva oyẹmhẹ bhale, ẹẹ liẹ ‘Mhẹmhẹ mhi khi ọni iKirisiti,’ ẹẹ di ebubu ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A ya suọ eko okhọli ali okeke okhọli. Ama a khi zẹ ni ulishi o mu ẹ. A mema ya mẹ emhi eghọghọ, ama ukpẹsẹ agbọ ọa kie ramhi ne. ");
INSERT INTO atgNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ushishi e ya mu okhọli vule shi ushishi ọ, ẹgbọ e mu egbe iku iku nu egbe ẹ khọli. Ukpokpomhi okiamhi o ya ke pfi, ekẹ e ya ke dekuluẹ asha khi asha. ");
INSERT INTO atgNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eri enana nya e ya li abi khi oku o lẹsẹ to ọkpotso ni ọ ya bia. ");
INSERT INTO atgNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ẹghẹghẹ aghọ a ya mu ẹ na wẹ ni e nasẹ ẹ, a gbolo ẹ-a. Ẹgbọ na agbọ nya e ya ke biselemhi ẹ, itobọ khi a khi ẹgbọ eyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ẹghẹghẹ aghọ ebubu ẹgbọ e ya de irudunga lasele, e ri egbe ẹ dẹ, ẹẹ biselemhi egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ẹghẹghẹ aghọ ebubu emekẹguele eyi ẹgbhọli e ya lasele, ẹẹ di ebubu ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Irari khi ọkhọlọ o ya gba ekẹ dọsẹ, imhuẹ-inono na egbe ọa ke lolo ẹ la ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama ọgbọ ni ọ da migha irudunga oyọli gbagbagba ramhi ukpẹsẹ, ọ ya khi ọni a mie pfuese. ");
INSERT INTO atgNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A ya she ri oni usomhi onete oyi oni Eghiele oyi Ẹshinẹgba onana, tse abọ gasẹ agbọ kpa, ni o khi ọtsẹlẹ na ishishi nya, ẹghẹghẹ aghọ ukpẹsẹ agbọ o tigbe ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ ‘Irarighọ, a kha da mẹ emhi obe ni o vẹsẹ ẹgbọ ọ kua khi ighuighuẹ ni ọọ vẹsẹ ẹgbọ kua, ni oo pfi ebemulishi, khi o da ya migha ashini o pfuasẹ ne,’ ẹzẹzẹ abi ọmekẹguele iDaniẹ ọ gue ọli le ne, ọni ọọ zẹ ebe ọ lẹsẹ emini ọ zẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ẹghẹghẹ aghọ, ẹgbọ ni e la ekẹ iJudia e na ya nga ukhomhi ite. ");
INSERT INTO atgNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ọgbọ ni ọ la ukhomhi owa ọ khi tiemhile ya rue emhikhọghuo elemhi owa. ");
INSERT INTO atgNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ọgbọ ni ọ la ishemhi ọ khi jele apfẹ ya rue awulu oyọli apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","O ma khọlọ ikpotso ni ẹ mẹ egbe ali eni e ri emọfẹ shi egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","A lema Ẹshinẹgba ọ khi zẹ ni ẹlẹ unamhi oyẹẹ o khi ẹghẹghẹ oruẹ wẹkhi ogbẹlẹ iyẹmhẹa. ");
INSERT INTO atgNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Irari khi osoli oniẹmhi o ya lasele ọ. Osoli ni ọgbọ aa kpẹ mẹ ghue rọte igbaekẹle agbọ ya ramhi ogbe ni amo, wẹkhi eri a ke gbolo ya mẹ oghọghọ ghue. ");
INSERT INTO atgNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ini aa rọte eni ogbẹlẹ eni a ngme ena khi-a, ọgbọkhọghuo ọa ya pfue ọ. Ama itobọ oyi ẹgbọ ni Ẹshinẹgba ọ zẹ, ọ ya khi eni ogbẹlẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ẹghẹghẹ aghọ, ini ọgbọkhọghuo ọọ u, ‘Bino, ghe ọni iKirisiti!’ Okekhia khi eri ọ li, ‘Ghe ọli oobọ khẹ,’ khi mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Irari khi iromhi emiepfuese ali emekẹguele eyi ẹgbhọli e ya lasele, ẹẹ ri ọlẹlẹ eniẹmhi ẹ khasẹ, ali ẹẹ gbe ikanya ọnyaloa rọ ke di egbegbi eni Ẹshinẹgba ọ zẹ, ini o ya zẹ li lọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","A ghe i, eri mhi gue onana yẹ ẹ shi ekẹ neni oni ẹghẹghẹ o ya ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ighọ, ini ọgbọkhọghuo ọ gueyẹ ẹ, ‘Ghe ọli oobọ, obini ọdagbe ifufu,’ a khi je oobọ. Okekhia khi eri ọọ, ‘Ghe ọli ana, elemhi owa aza,’ a khi mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Irari khi eri inyenegbe bhale oyi Omi Ọgbọ o ya li abi akphala o liẹ nyamhise alo nyaa, o rọte udi ukhuli gẹ ya je udi ukhuli, rọte obini ovọ o te ẹ ngale ya je obini o te ẹ lo eko. ");
INSERT INTO atgNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Itobọ khi ashini elamhakọ ọ kẹ-a shi aghọ ighuli ẹẹ legba. ");
INSERT INTO atgNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ẹghẹghẹ osoli oghọ o kha da lẹsẹ dọsẹ tee, “ ‘Ovọ o ya bishi alo-a, uki ọa kẹ gẹ ikpẹtata e deno ukhuli kule, ekpabọ ena ukhuli ẹẹ nighise.’ ");
INSERT INTO atgNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ẹghẹghẹ aghọ, ọlẹlẹ irọkhasẹ oyi Omi Ọgbọ o ya lasele shi ukhomhi idane. Ẹgbọ ni e la agbọ ona nya, e ya ke viẹ oya abi Omi Ọgbọ ọ li rọte irarogbe ẹ tiemhile elemhi ekpabọ ali ukpokpomhi ufumhi. ");
INSERT INTO atgNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ẹghẹghẹ aghọ akala onofunẹ o ya de. Omi Ọgbọ ọ ghie igẹni eyọli je iguabọ enenene na ekẹ agbọ nya, e ka ti ẹgbọ eyọli ni ọ zẹ gbili. ");
INSERT INTO atgNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“A zẹ ni ọara ọkhua o sẹsẹ ẹ ingme. Ini iguabọ eyọli e da tsọtsọghọ ne, ni o rọ ta ebe, a lẹsẹ khi okasẹ o she ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ighọ ini a da mẹ emini mhi gue ẹ yẹ ena ne, a lẹsẹ khi oni ẹghẹghẹ o she ti ramhi ana. ");
INSERT INTO atgNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Abi o li mhi li gue ẹ yẹ ẹ khi agbhotu ona ọa ya dọsẹ ne, ni emhi ena nya e rọ bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ekẹ ali ukhuli e ya dọsẹ, ama ingmemhi eyẹmhẹ, ẹa ya de kua. ");
INSERT INTO atgNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ọgbọkhọghuo ọa lẹsẹ oni ogbẹlẹ wẹkhi oni ẹghẹghẹ. Egbegbi igẹni na iloghie ẹa lẹsẹ wẹkhi Omi Ọgbọ ọ lẹsẹ, sẹ ni Ita lọlighuo tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Abi o ke li ẹghẹghẹ oyi iNoa, ighọ ibhale oyi Omi Ọgbọ o ya li. ");
INSERT INTO atgNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Neni a mẹ ogbẹlẹ oyi ochikpho oniẹmhi, eri ẹgbọ e le, e da, eghuo e wolọ ikpotso, a ri ikpotso ye ughuẹ, ya ramhi ogbẹlẹ ni iNoa ọ rọ mu ọkọ-okẹ oniẹmhi nga, ");
INSERT INTO atgNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ama ẹa kie lẹsẹ emini a ya mẹ ramhi ni ochikpho o rọ bhale ya tsua wẹ kua nya. Ighọ ibhale oyi Omi Ọgbọ o ya li. ");
INSERT INTO atgNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Emọse aava e ya la ishemhi ke gbe akanya, a rue ọghuo vu, a zẹ ọni ọ kpọle obọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ikpotso aava e ya la iko ke mhẹli emhi, a rue ọghuo vu, a zẹ ọni ọ kpọle obọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“A ri ukpẹloe shi ekẹ irari khi aa lẹsẹ ẹlẹ ni Ọnọmhuẹ ọyẹ ẹ ọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","A lẹsẹ khi ini ọmhuẹ-apfẹ ọ lẹsẹ ẹghẹghẹ ni ighiatọ e rọ ya do ọli lọ, eri ọ ya shitọ ni ogbe o gbe-a. Ọa ya zẹ ni ighiatọ e gbe ọli odẹ-a lo owa le. ");
INSERT INTO atgNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Itobọ ighọ, a mema ya mu egbe shi ekẹ, irari khi ẹghẹghẹ ni aa sa shi, Omi Ọgbọ ọ rọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ọghuo ọ fẹ khi ọni ọọ ga ni ri egbe ẹ nga ni ọ lẹsẹ ingme. Ni ọga ọyọli ọ zẹ kpeda na eni ẹẹ ga eyọli, ọ ri ẹloe khu ọmhọapfẹ oyọli, ni ọ ke ri emhi na wẹ le shi ẹghẹghẹ? ");
INSERT INTO atgNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Oghẹlẹ o khi na ọni ọọ ga ọghọ ini ọga ọyọli ọ jele ya ẹ khi ọọ riẹlẹ emini ọ mhẹsẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Abi o li mhi li gue ẹ yẹ ẹ khi ọga ọyọli ọ ya ri emini ọ mhọli nya nga li obọ. ");
INSERT INTO atgNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama ini ọ khi ọni ọọ ga ni ọa ya suọ esọ lọ, eri ọ ya ke gueyẹ egbọli, ‘Ọga ọyẹmhẹ ọ ya la oobọ tẹsẹ,’ ");
INSERT INTO atgNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ọọ gbe eni ẹẹ ga ni e kpọle, ọ le, ọ deba edonyọ a da onyọ kia kia. ");
INSERT INTO atgNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ọga ọyi ọni ọọ ga ọghọ ọ ya jele apfẹ ogbẹlẹ ali ẹghẹghẹ ni ọni ọọ ga ọghọ ọa sa shi. ");
INSERT INTO atgNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ọni ọga ọyọli ọghọ ọ ya nasẹ ọli agbọagbọ, ọ rọli je asha ni a ri erugamhi-ku-alo shi. Aghọ ọ la ke viẹ ọ le akọ akọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ẹghẹghẹ ni a ngme ena, eri Eghiele oyi Ẹshinẹgba o ya li abi imueshi etuogbe ni ẹa mẹ ọmọse ghue, ni e ya rue ikpa eyẹwẹ, ni e vu ya a lu ọmọse ọni ọọ rue ọmueshi ọnọgbọ odẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Imueshi oshe elemhi wẹ e khi eyẹghẹ, oshe eni e kpọle e khi elẹsingme. ");
INSERT INTO atgNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Eyẹghẹ ni e la ọ, e wolọ ikpa eyẹwẹ ama ẹa sato tsua oili olese shi emhi. ");
INSERT INTO atgNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Elẹsingme ni e la ọ, e wolọ ikpa, gbo diẹ oili olese shi emhi. ");
INSERT INTO atgNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Abi ọni ọmọse ni ọọ rue ọmueshi eghọ ọa rọ kẹlẹ ẹ bhale, eni imueshi nya e ri ukhomhi bọ, olesẹ o dọwẹ rue. ");
INSERT INTO atgNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Abi itsotsogbiẹ rọ mu ekẹ, uruli o de leghe, ọọ, ‘A ghe khẹ! Ọni ọọ rue ọmueshi ọ she ẹ bhale o! A vule ni a ya lu ọli odẹ!’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ighọ eni imueshi e ti vule, e ti ikpa eyẹwẹ ngale. ");
INSERT INTO atgNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ama ikpa eyi eyẹghẹ ni e la ọ, e ẹa ke dobẹ lala. E lẹ deba eni e khi elẹsingme, ẹẹ wẹ, ‘A kpẹkpẹ a te oili oyẹẹ diẹ na anye irari khi ikpa eyanye e she ẹ pfua.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ighọ imueshi elẹsingme eghọ, ẹẹ wẹ, ‘Iiye e! Oni anye mhuẹ ena ọa ya lo anye ni o gbolo lo ẹ ọ. A lẹ deba eni e ri oili ẹ dẹ ya dẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ighọ eni imueshi eyẹghẹ oshe eghọ, e le deba eni e rọ dẹ ya a dẹ. Abi e rọ vu ya dẹ oni oili, ọni ọọ rue ọmueshi ọ lole. Eni imueshi oshe ni e mu egbe oili olese eghọ e deba li lo elemhi owa ukue. A khukhu odẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“O ke li dẹnẹ, enekpọle e bhale, é ya kpheli odẹ, e liẹ, ‘Ọga! Ọga! Khueghie odẹ-a na anye.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ama ọni ọọ rue ọmueshi ọghọ, ọọ wẹ, ‘Abi o li mhi li gue ẹ yẹ ẹ, mhi aa lẹsẹ ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Irarighọ, a ri ẹloe shi ekẹ, itobọ khi aa lẹsẹ oni ogbẹlẹ wẹ khi oni ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ẹghẹghẹ aghọ, eri Eghiele oyi Ẹshinẹgba o ya li abi ọmọse ọghuo ni ọọ vu asha, ni ọ lu eni ẹẹ ga eyọli, ọ ri ẹpfue eyọli nga wẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ọ kemhi ikpaghọ na ọgbọgbọ abi e li mhuẹ afu ramhi. Ọ ri ikpẹshe na ọghuo, ọ ri ikpẹva na ọlese. Ọ ri ukpaghuo na ọnọkpọle. Ọ vu ẹoli. ");
INSERT INTO atgNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ọni ọga ọ lẹsẹ vu se, ọni ọ mie ikpẹshe eghọ, ọ nyanya ya ri ikpẹshe eyọli du oki, ọ mẹ eleli ikpẹshe elese nga ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ighọ ọni ọ mhuẹ ikpẹva eghọ, ọ li ri eyọli du oki, ọ li mẹ eleli ikpẹva elese nga ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama ọni a ri ukpaghuo na eghọ, ọ vu ya tọ oni ukpaghọ ekẹ sọ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“O tẹsẹ, ọni ọga ọyẹwẹ ọ jele. Ọ lu wẹ ọgbọgbọ ọ bhale ya guele abi ọ li gbe. ");
INSERT INTO atgNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ọni ọọ ga ni ọ mhuẹ ikpẹshe eghọ, ọ bhale deba ọga ọyọli, ọọ, ‘Ọga, ikpẹshe u rọ na mhẹ, ama mhi she rọli du oki, mhi mẹ ikpẹshe eleli.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ọni Ọga ọyọli ọọ li, ‘Mu akanya, yẹyẹ ọni ọọ ga ọnete ni ọ mhuẹ igẹsikia! U she ri igẹsikia khasẹ shi ukuku emini mhi rọ ngẹẹ obọ, mhi ya ri emini e bu ngẹẹ obọ. Bhale ni awa ga la oghẹlẹ!’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ighọ ọni a ri ikpẹva na eghọ, ọọ li, ‘Ọga, ikpẹva u rọ na mhẹ, mhi she mẹ eleli ikpẹva.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ọni ọga ọyọli ọọ li, ‘Mu akanya, yẹyẹ ọni ọọ ga ọnete ni ọ mhuẹ igẹsikia! U she ri igẹsikia khasẹ shi ukuku emini mhi rọ ngẹẹ obọ. Mhi ya ri emini e bu ngẹẹ obọ. Bhale ni awa ga la oghẹlẹ!’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ighọ ọni ọ mie ukpaghuo eghọ ọ bhale, ọọ li, ‘Ọga, mhi lẹsẹ khi uwali ọgbọ u khi; khi ashini u waa gua shi wa je ya khiẹsẹ, ali khi ashini u waa ri ukpamhi kọ, u je ya tima. ");
INSERT INTO atgNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Itobọ ighọ eri ulishi oyẹ oo mu mhẹ, lọli o zẹ ni mhi rọ ya tọ ikpaghọ eyẹ ekẹ sọ. Ghe ikpaghọ eyẹ emhikhọghuo ẹa li wẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ọni ọga ọyọli, ọ sọli ọ, ọọ li, ‘Yẹyẹ ọgbọ ọkhọlọ ọwaza ọna. U lẹsẹ khi eri mhia khiẹsẹ emini mhi aa rọkọ, mhi gbo rọte asha ni mhi aa pfi ukpamhi shi ẹ khiẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Abi o rọ khi ighọ, wa a kẹ ri ikpaghọ eyẹmhẹ shi ilu ikpaghọ, mhi kha jele, mhi kha bhale ya ẹ khi e gbe nga ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘A mie ọli oni ukpaghọ, a ri ọli na ọni ọ mhuẹ ikpẹshe. ");
INSERT INTO atgNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Irari khi ọgbọ ni ọ mhuẹ, a ya rọ ma ọ na li, ọ mhuẹ gbeku ọ, ama ọni ọa mhuẹ kpa, ukukuọ ni ọ kpẹ mhuẹ a ya mie ọli luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ama ọni ukhiakhiamhi ọni ọọ ga ọnana, a mu ọli pfi lase ya pfia alo ebili, aghọ ọ la ke viẹ ọọ le akọ akọ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ini Omi Ọgbọ o bhale abi Oghie Ọnọmhuẹ, ni igẹni eyọli nya e rọ nu ọli bhẹ, ọ ya shitọ eghiele oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ẹgbọ ni e la agbọ nya a ya tigbili odalo oyọli. Ẹghẹghẹ aghọ ọ khi wẹ-a asha eva, abi ọrisumha-kia ọ liẹ vasẹ isumha ali elamhi-a. ");
INSERT INTO atgNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ọ ya wolọ ẹgbọ ni e pfuasẹ je ukiẹkiẹ obita. Enekpọle e la obọgobọ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ighọ ọni oghie ọ ya gueyẹ ẹgbọ ni e la li obọ obita, ọọ wẹ, ‘A bhale ni a ke li agbọ elemhi iloghie ni Itamhẹ ọ riẹlẹ na ẹ rọte ẹghẹghẹ ni agbọ o te gba ekẹ le. Ẹẹ ni Ẹshinẹgba ọ khi vọsẹ na. ");
INSERT INTO atgNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Irari khi abi okiamhi o rọ gbe mhẹ, a ri emhi na mhẹ le, okiamẹ o gbe mhẹ, a diẹ amẹ na mhẹ da. Abi mhi rọ khi ọpfẹse, a mie mhẹ shi owa oyẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Abi mhi rọ la irumheba a ri itsua na mhẹ sọ. Mhii ghua, a ri ẹloe khu mhẹ. Mhi la owa ighumha, a bhale ya bino mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ighọ eni ẹgbọ ni e pfuasẹ eghọ e ya mhila mhẹ, ẹ mhẹ, ‘Ọnọmhuẹ, ẹghẹghẹ onoghuo anye rọ mẹ khi okiamhi oo gbe ẹ ni anye rọ ri eminale nẹ le, ni okiamẹ o rọ gbe ẹ ni anye rọ rọ nẹ da? ");
INSERT INTO atgNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ẹghẹghẹ onoghuo u rọ khi ọpfẹse ni anye rọ mie lo owa le. Ẹghẹghẹ onoghuo u rọ banọ-a ni anye rọ ri itsua nẹ sọ? ");
INSERT INTO atgNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ẹghẹghẹ onoghuo u rọọ ghua ni u rọ la owa ighumha ni anye rọ bhale ya bino ẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ọni oghie ọ ya sọ wẹ ọ, ọ wẹ, ‘Abi o li mhi li gue ẹ yẹ ẹ eghọ khi, emiemini u da riẹlẹ na ẹgbọ ni e khi Inyọghuo-mhẹ ni e miesuọ ni ẹa mu ẹloe ena ne, mhẹmhẹ u riẹlẹ ọli na.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ẹghẹghẹ aghọ ọni oghie ọ ya gueyẹ ẹgbọ ni e la li ukiẹkiẹ obọ ọgobọ, ‘A vu mhẹ ana le, ẹẹ ni a pfi unu na, a ke je owa erẹ ni Ẹshinẹgba ọ riẹlẹ na ọkphaghiẹ ali igẹni eyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Irari khi abi okiamhi o rẹ gbe mhẹ, aa ri emhi na mhẹ le. Abi okiamẹ o rẹ gbe mhẹ, aa bọ amẹ na mhẹ da. ");
INSERT INTO atgNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Abi mhi rọ khi ọpfẹse, aa lama ni mhi lo ẹ apfẹ le. Abi mhi rọ la irumheba, aa bọ ide na mhẹ sọ. Mhi ghua, aa ri ẹloe khu mhẹ. Mhi la owa ighumha aa bhale ya bino mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ẹghẹghẹ aghọ e ya liẹ mhẹ, ‘Ọnọmhuẹ, obo anye la mẹ khi okiamhi o gbe ẹ, ni u rọ khi ọpfẹse, ni u rọ la irumheba, ni u rọ ọ ghua, ni u rọ la owa ighumha ni anye aa rọ kpaghiẹ obọ?’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ọni oghie ọ ya sọ wẹ ọ, ọ wẹ, ‘Abi o li mhi li gue ẹ yẹ ẹ eghọ khi, emiemini wa a da riẹlẹ na ẹgbọ ena ni ẹa mu ẹloe ni e mie mhẹ suọ ne, mhẹmhẹ wa a riẹlẹ ọli na.’ ");
INSERT INTO atgNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ẹghẹghẹ aghọ, e vu ya lo osoli na agbọagbọ, ama eni e guẹ ngeli, e je agbọ na agbọagbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Abi iJesu ọ li sẹsẹ emhi ena se, ọọ eniyẹ odukhokho eyọli, ");
INSERT INTO atgNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“A lẹsẹ khi akọpfua khi ukpe iPasova. A ya mu Omi Ọgbọ, a gbe ọli-a shi apfida.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ẹghẹghẹ aghọ, ighie eyi ekpodalo-ugamhi ali eni egbhali e ya lona agbala oyi iKefasi ni ọ khi Ọga ọyi ekpodalo ugamhi nya. ");
INSERT INTO atgNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","E la aghọ gba ugbamhi abi e li ya bẹna mu iJesu ya gbe-a. ");
INSERT INTO atgNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","E gueyẹ egbe khi, ọa ya khi ẹghẹghẹ oyi oni imu, ini ẹgbọ khi ri itobọ ighọ tsua onyaghu lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","IJesu ọ bhale iBẹtani, ikhi owa oyi ọmọse ọghuo ni a lu iSamọ ni efafe e kpẹ mu. ");
INSERT INTO atgNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Abi iJesu ọ li la aghọ le eminale, ọkpotso ọghuo ọ tsua ituale ni o lolo ghalẹ shi ukoko alabasita ni a ri ẹchẹ riẹlẹ bhale. Ọ ya ku ọli shi iJesu ukhomhi. ");
INSERT INTO atgNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Abi eniyẹ odukhokho eyi iJesu e rọ mẹ ona, e liẹ, “Elọ o zẹ ni a rọ na pfuẹchẹ oni ituale kua shi afuẹ?” Elemhi e bi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“A kha ri ituale ona dẹ ghalẹ lọ, a kemhi eni ikpaghọ na eni ẹa mhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","IJesu ọ lẹsẹ emini e ngme, ọ mhila wẹ, ọ wẹ, “Elọ o zẹ ni a rọ nyama ọni ọkpotso ọna? Emini o somhi otse ọ riẹlẹ na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ẹghẹghẹ kpa eni ẹa mhuẹ e rọ a la ẹ ifuabọ. Ama aa ya ke mẹ mhẹ ẹghẹghẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Emini o zẹ ni ọkpotso ọna ọ rọ ku ituale ona shi mhẹ egbe khi, ni ọ rọ mu mhẹ egbe khẹ irọtọ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mhi gueyẹ ẹ khi ashiashini a da la tse abọ usomhi onete ona ekẹ agbọ ona ne, a ya ngme emini ọni ọkpotso ọna ọ riẹlẹ rọ sato ọli egbe.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ighọ ọghuo eniyẹ odukhokho ogbava eyi iJesu ni a lu iJudasi na Isikarọti, ọ fiẹ deba ighie eyi ekpodalo-ugamhi. ");
INSERT INTO atgNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ọ mhila wẹ, “Ingmẹ a ya rọ na mhẹ ini mhi ri odẹ khasẹ ẹ ni a te ya mu ọli?” Ighọ e leli ikpaghuo-ghuo uye ali igbe na li. ");
INSERT INTO atgNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Rọte aghọ vu, eri iJudasi ọ ke ri ukpẹloe shi ekẹ nono ode ni ọ te ya ri iJesu na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ogbẹlẹ onododẹ oyi oni ukpe na ibulẹdi ni aa ri ifuma wushe o ramhi, eniyẹ odukhokho eyi iJesu e bhale deba li, e mhila li, ẹ ọli, “Obo wa nono ni anye mu egbe shi ni u la le eminale iPasova?” ");
INSERT INTO atgNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ọọ wẹ “A lẹ deba ọmọse ọghuo ni ọ la elemhi oni ẹoli, a ka gueyẹ ọli khi, ‘Ọsẹsẹ ọ khi ẹghẹghẹ oyẹmhẹ o she ti ramhi, owa oyẹ, mhẹmhẹ ali eniyẹ odukhokho eyẹmhẹ anye la le eminale iPasova.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ighọ eni eniyẹ odukhokho eyi iJesu e riẹlẹ abi ọ li ghie wẹ. E ya mu egbe oni eminale shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Abi ogbọmhi o rọ mu ekẹ, iJesu ali eniyẹ odukhokho ogbava eyọli ee shitọ shi eminale. ");
INSERT INTO atgNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Abi e rọ le oni eminale, iJesu ọọ wẹ, “Ọghuo elemhi ẹ ọ ya rẹmhẹ dẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ighọ egbe e pfọ wẹ a. Ọghuo ọghuo ọ mhila li “Ọnọmhuẹ she khi ọa khi mhẹmhẹ wẹ khi o khi?” ");
INSERT INTO atgNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","IJesu ọọ wẹ, “Ọghuo ẹ ni ọ nu mhẹ ẹ sọ obọ utasa, ọ ya rẹ mhẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Omi ọgbọ ọ ya ghu-a abi a kẹkẹ nali. Ama o ma khọlọ ọmọse ni ọ ri Omi Ọgbọ ya dẹ egbe. O kha bie ti nẹ ini ọgbọ aa bie bia li.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","IJudasi ni ọ ya rọli dẹ ọọ li, “Ọsẹsẹ, she khi ọa khi mhẹmhẹ wẹkhi o khi?” IJesu ọọ li, “Ii, yẹyẹ lọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Abi e li le eghọ, iJesu ọ rue ibulẹdi, ọ kphẹmhi, ọ khi ọli a, ọ rọli na eniyẹ odukhokho eyọli, ọọ wẹ, “A mọ, a le khi idiegbe oyẹmhẹ na.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ighọ ọ gbo li rue uko, ọ kphẹmhi, ọ rọli na wẹ, ọ wẹ, “Ẹẹ nya a rọte ọ da. ");
INSERT INTO atgNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ọlia eyẹmhẹ ni a ku rọ luasẹ obo na ẹgbọkpa a na, ni o gbe olamhẹ kua na wẹ. Ọlia ena Ẹshinẹgba ọ rọ nu ẹgbọ eyọli mhuẹ ishobọ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mhi gueyẹ ẹ khi mhi a ke gbo rọte oni ukpamhi ọara upfonu onana ya da rọte memena vu. Sẹẹ ni ẹlẹ ni mhi ke ya nu ẹ da li odẹ onogbọ Iloghie oyi Itamhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Abi e rọ to uwolo se, e vu ya je ute ẹẹra Olivu. ");
INSERT INTO atgNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abi e li lẹ eghọ, iJesu ọọ wẹ, “Amiọsẹ ena, ẹẹ nya a ya mhuẹ akhọkhọmhẹ shi mhẹ egbe, a na tsua mhẹ pfia, irari khi ebe o ngme ọli khi. “ ‘Mhi ya ri emhi li ọrisumhakia, eni isumha e ya gbhiaku-a.’ ");
INSERT INTO atgNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Ama ini mhi rọte eghuli guale, mhi ya ralo na ẹ iGalili.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","IPita ọọ li, “Ini ẹgbọ nya e tseku mhuẹ akhọkhọmhẹ shi ẹ egbe, mhẹmhẹ mhi aa ya mhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","IJesu ọọ li, “Abi o li mhi li gue ọli ẹ yẹ, khi amiọsẹ ena, neni ọkpa ọ gbiẹghẹ, itesẹ u ya liẹ khi waa lẹsẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","IPita ọọ li, “Mhi aa ya ngme ghọ ini o tseku khia khi oni mhi ya nu ẹ ghu-a lọ, mhi aa ya liẹ khi mhi aa lẹsẹ.” Eniyẹ odukhokho enekpọle nya e li ngme ghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ighọ iJesu ọ lu eniyẹ odukhokho eyọli, e je ashini a lu iGẹtisẹmani, ọọ wẹ, “A shitọ ana khi mhi ya je oobọ ya sọ iromhi.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ọ rue iPita ali imi iZebedi aava ma egbe. Ọ viẹ osoli, egbe ẹa ke sheshe ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ọọ wẹ, “Udu oyẹmhẹ o vọ osoli ramhi khi mhi ya ghua. A shitọ ana, a nu mhẹ ke tọkpẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ọ ti lẹ dẹnẹ, ọ de yẹshi tọ alo mu ekẹ ọ sọ iromhi. Ọọ, “Ita, ini o ya tsẹ lọ, zẹ ni u mie mhẹ uko osoli ona. Ama ọa khi abi o li ghọle mhẹ, ama abi o li ghọle ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ọ nyenẹ egbe bhale deba eni eniyẹ odukhokho, ọ mẹ khi ẹẹ lesẹa. Ọọ wẹ, “Aa dobẹ nu mhẹ tọkpẹ ukuku ẹghẹghẹ tsẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“A ke tọkpẹ, a sọ iromhi ini a khi de pfilo imufẹ. Ayẹmhẹ o mu egbe, ama o lọsẹ idiegbe.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ọ gbo vu utonuzi-eva, ọ ya lema, ọọ, “Itamhẹ, ini o khia khi ọa zẹ li ni uko osoli ona o dọsẹ, sẹẹ khi mhi da li, zẹ ni ọghuẹmhẹ oyẹ o tsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ọ gbo nyenẹ egbe ukhokho bhale, ọ mẹ khi e lesẹa ẹa ke dobẹ khueghie alo-a. ");
INSERT INTO atgNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ighọ ọ zẹ wẹ obọ shi aghọ. Ọ gbo ya lema utonuzi-esẹ, o gbo ngme abi ọ kpẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ighọ ọ nyenẹ egbe ukhokho bhale deba eni eniyẹ odukhokho, ọọ wẹ, “Eri a kiele ẹ lesẹ-a, a kiele ẹ yẹmhẹ-a? A bino khi ẹghẹghẹ o she ramhi khi a she ri Omi Ọgbọ na ẹgbọ olamhẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","A vule ni awa vu! Ọni ọ rẹmhẹ ẹ dẹ ọọ bhale!” ");
INSERT INTO atgNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","IJesu ọ kie lighọ ngme, iJudasi ni ọ khi ọghuo eni eniyẹ odukhokho ogbava, ọ bhale. Ebubu ẹgbọ ni e tsua epia ali itakobi e nu ọli bhale, eni ighie eyi ekpodalo-ugamhi ali eni egbhali e ghie. ");
INSERT INTO atgNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ọni ọ rọli dẹ ọ she ri ọlẹlẹ na eni ẹgbọ, ọọ wẹ, “Ọni mhi da ya pfipfi egbe ne, lọli lọ, a mu ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ọni iJudasi ọ lẹ deba iJesu, ọọ li, “Opfọmhẹ o ka nu ẹ la Ọsẹsẹ,” ọ pfipfi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","IJesu ọọ li, “Ọmuẹ, nyanya riẹlẹ emini u bhale shi.” Ighọ eni emọse e fiẹ lasele, e mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ghe i, abi a rọ mẹ na, ọghuo eni e nu iJesu kia, ọ ji itakobi emhi lasele. Ọ khi ọni ọọ ga ọyi Ọga ekpodalo ugamhi esọ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","IJesu ọọ li, “Rue itakobi oyẹ shi irari khi ọni ọ ji itakobi, ọ ya li ghu eghuli itakobi. ");
INSERT INTO atgNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eri u dabi khi mhi aa dobẹ ya mhila Itamhẹ ikpaghiobọ, aghọaghọ ọ ri igẹni ni e dọsẹ agbhagbhamhi igbẹva ghi mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama, sẹ Ebe-no-pfuasẹ o ke li bhale ya tsẹ, ni ọọ khi a mema lina mẹ ọli?” ");
INSERT INTO atgNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ighọ iJesu ọọ eni ebubu ẹgbọ eghọ, “Eri mhi ri ẹgbọ ẹ pfi ozughu ni a rọ tsua igbhọrọ ali itakobi bhale ya mu mhẹ? Ẹlẹ kpa mhi rọ shitọ Owa oyi Ẹshinẹgba ẹ sẹsẹ, ama aa mu mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama eri a mẹ ena nya ni a bhale ya ẹ khi emini emekẹguele e ngme shi ebe o bhale ya tsẹ.” Ighọ eniyẹ odukhokho nya e zẹ ọli obọ, e na kua. ");
INSERT INTO atgNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Eni e mu iJesu e rue ọli je apfẹ oyi iKefasi ni ọ khi Ọga ọyi ekpodalo ugamhi, ashini eni ẹ sẹsẹ ishi ali eni egbhali e legbe. ");
INSERT INTO atgNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ama iPita ọ tapfia a deba wẹ. Ọ deba wẹ lo ramhi atukpapfẹ oyi Ọga ọyi ekpodalo ugamhi. Ọ lo se, ọ nu eni ẹẹ khẹ ekhẹ shitọ, ni ọ mẹ abi oni ingme o ke li ya kia. ");
INSERT INTO atgNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ighie eyi ekpodalo-ugamhi ali eni iSahẹdiri nya, e nono ọtsẹlẹ ẹgbhọli ni e ya mu mhọli iJesu obọ ni e ba mẹ asha gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama ẹa mẹ okhọghuo, abi ebubu ẹgbọ e tseku fiẹ lasele ya pfi ọtsẹlẹ ẹgbhọli. Ikpukhokho ọ, emọse aava e fiẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ẹ li “Ọmọse ọna ọ̀ọ́, ‘Mhi ya dobẹ guọghọ Owa Oyi Ẹshinẹgba-a, mhi gbo riẹlẹ ọli tọ ogbẹlẹ esẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ọga ọyi ekpodalo ugamhi ọ vule, ọọ iJesu, “Waa bie mhuẹ emini u ya ngme shi ẹzọ ni a gue ẹ shi ẹ egbe ena?” ");
INSERT INTO atgNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama iJesu tsaghiẹ-a. Ighọ Ọga ọyi ekpodalo ugamhi ọ gbo vule migha, ọọ iJesu, “Mhi ri eva oyi Ẹshinẹgba ni ọ la ọ rẹ romhi ishe, gueyẹ anye, ini yẹyẹ u khi Ọmiepfuese Omi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","IJesu ọọ li, “Ighọ o khi abi u ngme. Ama mhi gueyẹ ẹẹ nya khi, rọte memena vu, a ya mẹ khi Omi Ọgbọ ọ shitọ obita oyi Ẹshinẹgba ni ọ funẹ nya, ọ la elemhi otughunu te irarogbe ẹ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ighọ, Ọga ọyi ekpodalo ugamhi ọ nyanọ awulu a shi egbọli uruli. Ọọ, “Ọ she pfi unu-a! Ọtsẹlẹ olese awa ke gbolo ẹ nono? Ẹẹ a she suọ oni ungmemhi ipfiunu-a ni ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sẹ a sa shi ọ?” Ẹ ọli “Ọ she lue, ọ mema ya ghua.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ighọ e tono etẹ ku iJesu alo, e ri ekpa gbe ọli. Eghuo, e lase ọli esọ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","E liẹ ọli “Mẹ ekẹ na anye ghue yẹyẹ Ọmiepfuese. Gueyẹ anye ghue ọni ọ ri emhi gbe ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","IPita ọ shitọ olase, ọmueshi ọghuo ọyi Ọga ọyi ekpodalo ugamhi ọ bhale deba li, ọọ li, “Yẹyẹ, u li nu iJesu ọnge iGalili kia.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","IPita ọ tia li ukpẹloe wẹ nya, ọọ li, “Mhi aa fẹ lẹsẹ emini a ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ọ ke rọte aghọ fiẹ je unu odẹ unuẹkpẹ ni a rọte ẹ lo oni apfẹ le, ọkpotso ọni ọọ ga ọlese ọ gbo mẹ ọli, ọ gueyẹ emọse ni e la aghọ, ọọ “Ọmọse ọna ọ nu iJesu na iNazarẹti kia.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ighọ iPita ọ gbo tia li. Utona, ọ romhise ma ọ, ọọ, “Mhi romhi ishe, khi mhi aa lẹsẹ ọni ọmọse ọghọ!” ");
INSERT INTO atgNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","O kẹ li dẹnẹ, emọse ni e migha aghọ e bhale deba iPita, ẹ ọli, “Igẹsikia lọ khi ọtuọghuo elemhi wẹ u khi. Ungmemhi oyẹ o she ngmasẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ighọ ọ li sẹ egbọli isheli, ọọ romhi isheli. Ọ liẹ, “Mhi aa ga lẹsẹ ọni ọmọse!” Utoghuokpe ọkpa ọ gbiẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ighọ iPita ọ sato ungmemhi ni iJesu ọ gueyẹ ọli ni ọ rẹ ọli, “Neni ọkpa ọ ya gbiẹghẹ, itesẹ u ya liẹ khi waa lẹsẹ mhẹ.” Ọ fiẹ je olase ya viẹ oya. ");
INSERT INTO atgNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ogbe o gbe-a ogbeakọlọ, ighie eyi ekpodalo-ugamhi nya ali egbhali e mhẹsẹ abi e li ya gbe iJesu-a. ");
INSERT INTO atgNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","E gẹ ọli, e rue ọli vu ghi iPaleti ni ọ khi igọvunọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Abi iJudasi ni ọ rọli dẹ, ọ rọ suọ khi a pfa ẹzọ mu ọli khi a ya gbe ọli-a, o ri egbe pfọ li-a, ọ nyenẹ egbe rue ikpaghuo uye ali igbe eghọ ghi ighie eyi ekpodalo-ugamhi ali eni egbhali. ");
INSERT INTO atgNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ọọ wẹ, “Mhi she lamhẹ, irari khi mhi she ri ọgbọ ni ọa mhọli olamhẹ okhọghuo dẹ,” Ẹ ọli, “Ẹgboli oyi anye onoghuo o ke la oghọ? Yẹyẹ u lẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ighọ iJudasi ọ ku eni ikpaghọ kua ekẹ elemhi Owa oyi Ẹshinẹgba, ọ vu ya soli egbọli-a. ");
INSERT INTO atgNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ighọ ighie eyi ekpodalo-ugamhi e sanọ eni ikpaghọ ekẹ, ẹ ọli, “Ikpaghọ ọlia na, awa aa ya ku wẹ ma ikpaghọ ugamhi.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","E gba ugbamhi nga eni ikpaghọ se, e rẹwẹ ya dẹ ekẹ onayi ọni ọọ ma ekhe, ni a ri ilimhi epfẹse ke tọ aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lọli o zẹ ni a rọ lu ọli Ekẹ Ọlia ramhi ogbe na amo. ");
INSERT INTO atgNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ighọ ungmemhi ni ọmekẹguele ni a lu iJeremaya ọ ngme, o li bhale ya tsẹ. Ni ọọ, “E rue ikpaghuo uye ali igbe ni e khi ikpaghọ ni ẹgbọ iZirẹni e lama fali shi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","E rue eni ikpaghọ ya dẹ ekẹ ẹmẹ onayi eni ẹẹ ma ekhe, abi Ẹshinẹgba ọ mhẹsẹ na mhẹ mhi ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","IJesu ọ migha odalo oyi igọvunọ iRomu, ọni igọvunọ ọ mhila li, “Yẹyẹ u khi oghie ọyi ẹgbọ iJu?” IJesu ọọ li, “Ii, Ighọ o khi abi u ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama ọa mhọli emini ọ sọ shi ingme ni ighie eyi ekpodalo-ugamhi ali egbhali e ngme shi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ighọ iPaleti ọ mhila li, ọọ. “Wa a suọ emini a ngme shi ẹ egbe?” ");
INSERT INTO atgNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama iJesu ọa lama sọ ọli abikhọghuo, o ga lolo ri abọ sha ọni igọvunọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ini a da li ukpe iPasova, eri igọvunọ ọọ rue ọgbọ ọghuo ni a mu shi owa ighumha obọ-a na ẹgbọ iJu. Ikhi ọni e zẹ, a rue igha le na wẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ẹghẹghẹ aghọ, a mẹ ọmọse ni a mema lẹsẹ shi ukhiakhiamhi ọgbọ, ni aa khẹna, ni a mu shi owa ighumha, ni a lu iBarabasi. ");
INSERT INTO atgNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ighọ abi eni ẹgbọ e rọ le gba, iPaleti ọ mhila wẹ, “Ọnọghuo elemhi ẹgbọ aava ena a nono ni mhi wolọ abọ-a na ẹ? IBarabasi abi iJesu ni a lu Ọmiepfuese?” ");
INSERT INTO atgNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Irari khi ọ she lẹsẹ khi itobọ khi ighie eyi ẹgbọ iJu ẹẹ biselemhi iJesu e rọ mu ọli ghi luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Abi iPaleti ọ li shitọ ukpẹkhomhi ẹzọ oyọli, ughuẹ ọli ọ ghie usomhi ghi ọli, ọọ. “Khi mhuẹ emini u li ọmọse ni ọa mhuẹ emini ọ li eghọ. Irari khi mhii mẹ osoli elemhi ẹlena ooyọsẹ shi ingme oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ama ighie eyi ekpodalo-ugamhi ali eni egbhali, e tanọ shi eni ebubu ẹgbọ elemhi, e liẹ iPaleti ọ rue iBarabasi obọ-a, ama a gbe iJesu-a. ");
INSERT INTO atgNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ighọ igọvunọ ọ mhila wẹ, “Elemhi aava ena, ọnọghuo ọ, a nono ni mhi rue obọ-a?” Wẹwẹ nya ẹẹ. “IBarabasi!” ");
INSERT INTO atgNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ọ mhila wẹ, “Sẹ mhi ya li iJesu ni a lu Ọmiepfuese ọna shọ?” Wẹwẹ nya ẹẹ, “A ka ta li ma apfida!” ");
INSERT INTO atgNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ama iPaleti ọ mhila wẹ, “Elọ o zẹ, onobe onoghuo ọ riẹlẹ?” Ama e kie tsẹsẹ leghe “A ta li ma apfida!” ");
INSERT INTO atgNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Abi iPaleti ọ rọ mẹ khi lọli ẹa mhọli emini lọli ke ya li ọ, khi onyaghu o tigbe te ọ lasele, ọ diẹ amẹ, ọ kpe abọ-a ukpẹloe wẹ nya, ọọ wẹ “Mhi aa mhuẹ obọ shi eghuli oyi ọmọse ọna o! Obọ oyẹẹ o la o!” ");
INSERT INTO atgNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eni ẹgbọ nya ẹ li, “Ọlia eyọli e la ukhomhi oyanye ali oyi eniyẹ eyanye.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ighọ ọọ rue iBarabasi obọ-a na wẹ. Ọọ a gbe iJesu itali, ọ rue ọli na ekhọli-okhuẹ eyi iRomu e ka ta li ma apfida. ");
INSERT INTO atgNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ighọ ekhọli-okhuẹ eyi iPaleti e rue iJesu lo elemhi agbala oyọli, ọ rue eni ekhọli-okhuẹ nya le gasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ighọ e gueghie ọli itsua ni ọ sọ, e ri itsua ọyilẹ sọ li. ");
INSERT INTO atgNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","E ri igba do arula rughu ọli. E ri ukpokpo mhọli ọli obọ ita, e wugha li odalo, e ri ọli li egia. E liẹ ọli, “Ẹshinẹgba ọ zẹ ni u tọ agbọ yẹyẹ oghie iJu.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","E to etẹ ku ọli, e mie ọli oni ukpokpo gbe ọli ukhomhi. ");
INSERT INTO atgNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","E ri ọli li egia se, e gueghie ọli itsua eyilẹ ni e rọ sọ li eghọ, e tigbe ri itsua eyọli sọ li. E rue ọli je obini a la ya gbọli-a. ");
INSERT INTO atgNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Abi e li lẹ eghọ, wẹwẹ ali ọmọse ni a lu iSamọ ọngi iZirẹni e ya lona, e ri itoto mu ọli ọ tsua apfida oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E bhale asha ni a lu iGọgọta. Abi iGọgọta o ngme khi “Asha ugua ukhomhi ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aghọ e la ri onyọ ni a ri emhi oyala shi na iJesu da, ama ọ to unu ọ bino, ọa lama da li. ");
INSERT INTO atgNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","E ta li ma apfida se, e pfi onolo rọ kemhi itsua ni ọ sọ mhọli egbe abọ. Onana o ri emini ọmekẹguele ọ ngme bhale ya tsẹ, ni ọọ. “E kemhi iwulu eyẹmhẹ, e pfi onolo shi ide eyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E riẹlẹ se, e shitọ, e khẹ ọli ekhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","E kẹkẹ emini a gue shi ọli egbe shi upẹpẹ ọara rọ kphase kpeda nali. Emini a kẹkẹ shi ọ khi, Ọna khi iJesu, Oghie ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ighọ e gbe ighiatọ aava ma li egbe. Ọghuo ọ la ukiẹkiẹ obita, ọnọkpọle ọ la li ukiẹkiẹ ọgobọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ẹgbọ ni ee dọsẹ, e pfi itsue ọdọda manya iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","E liẹ “Yẹyẹ ni u ya guọghọ Owa Oyi Ẹshinẹgba-a, ogbẹlẹ nuzi-esẹ u gbo tọli pfo. Tsumhi egbe ẹ! Rọte ukhomhi apfida ona tiemhile shọ, ini Omi Ẹshinẹgba u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ina ighie eyi ekpodalo-ugamhi, ali esẹsẹ Ishi eyi iMosisi ali egbhali e gbo li tsue ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","E liẹ, “Ọ tsumhi ẹgbọẹse,” “Ama ọa dobẹ tsumhi egbọli! Ọa khi lọli khi oghie ọyi iZirẹni? Ini ọ da te ukhomhi apfida onana tiemhile ne, anye ya mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eri ọ ri egbe da Ẹshinẹgba o gbo liẹ khi, ‘Omi Ẹshinẹgba mhi khi.’ Awa ke bino ini Ẹshinẹgba ọ ya tsumhi ọli mena.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ighọ khi ighiatọ ni a ta ma apfida e li tsue ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ọguota o mu ekẹ obili o todẹ bi asha kpa elemhi iwakati esẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Agogo esẹ o de te, iJesu ọ viẹ lasele leghe ọọ “Eloi, Eloi, Lama Sabachi tani?” Abi ona o ngme khi “Ẹshinẹgba ọyẹmhẹ, Ẹshinẹgba ọyẹmhẹ, elọ o zẹ ni u rọ pfi mhẹ esọ a?” ");
INSERT INTO atgNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ẹgbọ eghuo ni e la aghọ e suọ ona, e liẹ li, “Elaja ọọ lu.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aghọaghọ, ọghuo ọ, ọ na ya rue isoso, ọ sọ li onyọ ni o khẹ-a, ọ gẹnọ li shi ukpokpo nise a ji iJesu unu ni ọ da. ");
INSERT INTO atgNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ama enekpọle ẹ ọli, “Migha, zẹ ọli obọ ni awa mẹ ini Elaja ọ ya bhale ya tsumhi ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ighọ iJesu ọ gbo viẹ leghe, ọ ghu-a. ");
INSERT INTO atgNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ẹghẹghẹ aghọ tee, ode ugbakpi, ni a rọ ta pfa odẹ-a ni o la elemhi Owa Oyi Ẹshinẹgba o te ododẹ rọte idane kiẹsẹ-a ya tiemhi ekẹ. Ekẹ agbọ o nighise, echẹ e vẹnọ-a. ");
INSERT INTO atgNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iji e khueghie-a, ebubu ẹgbọ ni e pfuasẹ ni eghuloa e guale bhale agbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","E fiẹnọ iji lasele. Abi iJesu ọ rọ rọte eghuli guale se, e je elemhi ẹoli no pfuasẹ, e ri egbe khasẹ ebubu ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Abi ekhọli-okhuẹ ni a zẹ e ke khẹ iJesu ekhẹ e rọ mẹ abi ekẹ o li nighise ali emhi elese ni e mẹ nya, ulishi oo mu wẹ, e liẹ li, “Egbegbọ lọ khi Omi Ẹshinẹgba ọmọse ọna ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ikpotso ebubu e la aghọ ni e ta pfi-a fẹ. Eri e deba iJesu rọte iGalili bhale ni wẹwẹ e ri ukpẹloe khu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eghuo ọ khi, iMeli ọngi iMagidaleni, iMeli inyi iJemhisi ali iJosẹfu, ali inyi iJemhisi ali iJọni. ");
INSERT INTO atgNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Abi ogbọmhi o rọ mu ekẹ, ọmọse ni ọ pfue ọngi Arimatia ni a lu iJosẹfu ni ọ li khi ọghuo eniyẹ odukhokho eyi iJesu, ");
INSERT INTO atgNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ọ lẹ deba iPaleti ya mhila li olimhi ọyi iJesu, ọ rọli na luẹ ya tọ. IPaleti ọ ri unu bhale e ka rue ọli na iJosẹfu. ");
INSERT INTO atgNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ighọ iJosẹfu ọ rue ọli, ọ ri ode onogbọ no pfuasẹ khuli ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ọ ri ọli tọ uji onogbọ oyọli ni a lẹsẹ tọ shi elemhi ẹchẹ. Ọ gheghele ẹchẹ oniẹmhi khukhu oni uji unu, ọ vu je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ighọ iMeli ọngi iMagidaleni ali iMeli ọnọkpọle e shitọ sọ alo ghue oni uji. ");
INSERT INTO atgNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ogbeakọlọ, ni o khi ẹlẹ Iyẹmhẹa oyi ẹgbọ iJu, ighie eyi ekpodalo-ugamhi ali ẹgbọ iFarisi e bhale deba iPaleti, ẹ ọli, ");
INSERT INTO atgNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ọga, anye sa ya to khi abi ọni ọloẹgbhuẹ ọghọ ọ rọ la agbọ ọ liẹ khi, ‘Mhi ya guale ẹlẹ-esẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mena ri unu bhale a ke ya khẹ aghọ ekhẹ ramhi ẹlẹ nuzi-esẹ, ini eniyẹ odukhokho eyọli e khi bẹna ya tsua olimhi oyọli, ni e ke gueyẹ ẹgbọ khi a she te eghuli guise ọli le. Ẹgbhọli oni o ya kpukhokho ona, lọli o ke ya khọlọ dọsẹ oni ododẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","IPaleti ọọ wẹ, “A rue ekhe-khẹ, a zẹ ni ẹ khẹ ekhẹ aghọ. A lolo khukhu ọli abi o ti ẹ ẹloe shi.” ");
INSERT INTO atgNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ighọ e ya khukhu oni uji egbegbọ, e zuse ọli, e zẹ ekhe-khẹ shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ogbe o ya gbe khi ẹlẹ Iyẹmhẹa o dọsẹ ni o khi ẹlẹ ni ododẹ elemhi ẹfo uka, iMeli ọngi iMagidaleni ali iMeli ọnọkpọle e lẹ ya bino oni uji. ");
INSERT INTO atgNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Utoghuokpe ekẹ o nighise, irari khi agẹni ọyi Ọnọmhuẹ ọ rọte idane tiemhile. Ọ gheghele oni ẹchẹ ni o khukhu oni unu uji odẹ-a. Ọ shitọ nga ọ. ");
INSERT INTO atgNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ọ li abi erali akphala. Itsua ni ọ sọ e pfuasẹ pẹpẹpẹ abi otughunu opfopfo. ");
INSERT INTO atgNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ulishi o mu eni e la aghọ khẹ ekhẹ, ee guọ, ubi o rue wẹ pfi gbe. ");
INSERT INTO atgNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ọni agẹni ọọ eni ikpotso, “A khi zẹ ni ulishi o mu ẹ irari khi mhi lẹsẹ khi iJesu ni a gbe-a shi apfida a nono. ");
INSERT INTO atgNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ọa la akana, ọ she te eghuli guale abi ọ kie kpẹ ngme. A bhale ya bino ashini a ri ọli yẹshi. ");
INSERT INTO atgNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A nyanya ke lẹ memena, a ka gueyẹ eniyẹ odukhokho eyọli khi. ‘A she te eghuli guise ọli le, khi mena, ọọ kia khẹ ẹ, ọ je elemhi iGalili. Oobọ a ya mẹ ọli.’ Ghe i, a khi yele-a abi mhi gueyẹ ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ighọ eni ikpotso e nyanya rọte oni uji vu, ulishi o mu wẹ ama oghẹlẹ o vọ wẹ elemhi, e na ya gueyẹ eniyẹ odukhokho eyọli. ");
INSERT INTO atgNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Utoghuokpe iJesu ọ bhale deba wẹ, ọọ. “Opfọmhẹ o ka nu ẹ la.” E bhale deba li, e mu ọli awẹ, e nyẹsẹ ukhomhi ga li. ");
INSERT INTO atgNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","IJesu ọọ wẹ, “A khi zẹ ni ulishi o mu ẹ, ama a ka gueyẹ Inyọghuo-mhẹ e ke je iGalili. Aghọ e te ya mẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Abi eni ikpotso e rọ vu se, eni ekhọli-okhuẹ ni e khẹ oni uji ekhẹ, e vu ya gueyẹ ighie eyi ekpodalo-ugamhi emini a ga mẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ighọ ighie eyi ekpodalo-ugamhi e lẹ deba eni egbhali e lona ye ugbamhi abi e ke ya li. E gba, e ri ikpokpomhi ikpaghọ na eni ekhọli-okhuẹ eghọ. ");
INSERT INTO atgNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ẹẹ wẹ. “A liẹ khi, ‘Eniyẹ odukhokho eyọli e bhale ya tsua li vu abi obili o rọ bi ni anye rọ lesẹa.’ ");
INSERT INTO atgNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ini igọvunọ ọ suọ ona, anye ya pfa ẹ shi ekẹ, a khi zẹ ni emhikhọghuo o nasẹ ẹ udu.” ");
INSERT INTO atgNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ighọ eni ekhọli-okhuẹ e mie wẹ eni ikpaghọ e li abi e sẹsẹ wẹ. Eri ingme emini e riẹlẹ o gbhiaku asha kpa ifuabọ ẹgbọ iJu. Ramhi ogbe-namo, eri a kiele ẹ zẹ oni okhẹ ona. ");
INSERT INTO atgNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ighọ eniyẹ odukhokho ogbaghuo eyọli e je iGalili deba iJesu ukhomhi ute ni ọ sẹsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Abi e rọ mẹ ọli, e nyẹsẹ egbe ga li, ama eghuo ọ e kiele khọkhọ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ighọ iJesu ọ kia ti mama wẹ, ọọ. “A she rue afu nya na agbọ ona ali iloghie na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Irarighọ, a fiẹ lase je asha kha asha, a ke ya ri ẹgbọ mele eniyẹ odukhokho eyẹmhẹ-a, a ri eva oyi Ita, ali oyi Ọmọ ali oyi Ayẹmhẹ-nọ-pfuasẹ batazi. ");
INSERT INTO atgNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A sẹsẹ wẹ, e ke ri emhi nya ni mhi mhẹsẹ na ẹ gbe akanya. A ghe i, mhi nu ẹ la ramhi ukpẹsẹ agbọ.”");
INSERT INTO atgNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ona o khi igbaekẹle oyi usomhi onete oyi iJesu iKirisiti Omi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A kẹkẹ ọli shi Ebe-no-pfuasẹ ni ọmekẹguele ọyọli ni a lu Azaya ọ kẹkẹ. Ni Ẹshinẹgba ọ la liẹ, “Mhi ya ghie aghiusomhi ọyẹmhẹ ralo nẹ. Ọni ọ ya bẹ odẹ shi ekẹ khẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ọgbọ ọ la ọdagbe ẹ pfie okokokhuẹ. Ọọ liẹ, ‘A riẹlẹ odẹ shi ekẹ khẹ Ọnọmhuẹ, ni ọ́ọ́ bhale. Riẹlẹ oni odẹ sheshe ni ọ rọte.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ighọ IJọni ọ li bhale, ọọ batazi ẹgbọ obini ọdagbe ifufu, ọọ tse abọ, ọọ liẹ, “A mu pfi lase olamhẹ eyẹ ẹ le bhale deba Ẹshinẹgba ini a ri olamhẹ topfa ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ighọ ẹgbọ e rọte ekẹ iJudia ali ẹoli iJerusalẹmu lẹ deba IJọni. Ee zọnọ olamhẹ eyẹwẹ yẹ ọli. Ọ la okẹ iJọdani batazi ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ode ni a ri iriria eyi alakumi do, iJọni ọ rọ fia itsua sọ. Ọ ri ẹkuẹ riẹlẹ ọgbẹnẹ mu oku. Initso ali oribo e khi eminale eyọli. ");
INSERT INTO atgNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Abọ ni ọọ tse gueyẹ agbọ khi: “Ọmọse ni ọ ke ya bhale ẹlẹlese odẹ ukhokho oyẹmhẹ, ọ fu dọsẹ mhẹ, ọ mhọli ekpabọ dọsẹ mhẹ. Mhi aa fu ramhi ọni ọọ taghiẹ uli ni o la ekuẹ ni ọ sọ-a. ");
INSERT INTO atgNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Amẹ mhi rọ batazi ẹ memena, ama Ayẹmhẹ-nọ-pfuasẹ ọ ke rọ ya batazi ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ọa te aghọ tẹsẹ ne, ni iJesu ọ rọ rọte iNazarẹti ni o la ekẹ iGalili bhale ni iJọni ọ la okẹ iJọdani batazi ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Abi iJesu ọ rọ lẹsẹ rọte elemhi okẹ ji egbe ngale te, ọ mẹ khi idane ọ khueghie. Ayẹmhẹ oyi Ẹshinẹgba ọ li abi anekhukhu rọte idane tiemhile ya ma li egbe. ");
INSERT INTO atgNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A suọ khi uruli o rọte idane ngme tiemhile, ọọ, “Omimhẹ ni mhi nono ingme oyọli u khi. U ma ri egbe ẹ mu mhẹ gba.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Utoghuokpe, Ayẹmhẹ oyi Ẹshinẹgba o rue iJesu je ọdagbe. ");
INSERT INTO atgNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ogbẹlẹ egbhuẹva ọ la oobọ. Ọkphaghiẹ, ni ọ khi oghie ayẹmhẹ ebe, ọ mu ọli fẹ. IJesu ọ nu elamhakọ la oobọ, ama igẹni eyi Ẹshinẹgba e ri ukpẹloe e khu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Abi a rọ mu iJọni shi owa ighumha se, iJesu ọ je iGalili ya tse abọ usomhi onete oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ọọ liẹ, “Oni ẹghẹghẹ o she bhale, Eghiele oyi Ẹshinẹgba o she ti mama awa. A mu pfi lase olamhẹ eyẹ ẹ le, ni a mie oni usomhi onete suọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Abi iJesu ọ rọte epfepfẹ okẹ oniẹmhi oni o khi shi, na lui iGalili kia lẹ, ọ mẹ iSamọ ali inyọghuo ọli Aduru. Egbifẹlẹ e khi. E pfi aga lo elemhi oni okẹ, ee gbe ifẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","IJesu ọọ wẹ, “A deba mhẹ, mhi ya sẹsẹ e abi a ke liẹ ke ti ẹgbọ gbili.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aghọaghọ e ku iga eyẹwẹ shi ekẹ, ẹ deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ọ̀ ke te aghọ je odalo dẹnẹ, ọ gbo mẹ inyọghuo etuava, iJemhisi ali iJọni imi iZebedi e la elemhi ọkọ-okẹ oniẹmhi, e zu iga eyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Abi iJesu ọ rọ lẹsẹ mẹ wẹ, o lu wẹ e deba luẹ, aghọaghọ e pfi itawẹ ali ẹgbọ ni e nu wẹ ye shi elemhi ọkọ-okẹ oniẹmhi, e deba li vu. ");
INSERT INTO atgNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","IJesu ali eniyẹ odukhokho eyọli e bhale ẹoli iKapanọmu. Ogbẹlẹ iyẹmhẹa ni o ke deba li, iJesu ọ dọsẹ lo elemhi owa ugamhi, ọ la aghọ sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","O ri abọ sha ẹgbọ ni e ri esọ kpe abi ọ li sẹsẹ, itobọ khi eri ọ sẹsẹ ẹgbọ abi ọgbọ ni ọ lẹsẹ emini ọọ sẹsẹ, osẹsẹ oyọli o kiọda shi oyi eni e sẹsẹ Ishi eyi iMosisi. ");
INSERT INTO atgNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Utoghuo kpe ọmọse ni ayẹmhẹ ebe o la egbe, ọ lo elemhi oni owa ugamhi le. Ọ́ tsẹsẹ gbaa! Ọọ, ");
INSERT INTO atgNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Elọ wa nono anye egbe, iJesu na iNazarẹti? Eri u bhale ya pfuse anye-a? Mhi ga lẹsẹ ọni u khi. Ọni Ọ pfuasẹ ọyi Ẹshinẹgba u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","IJesu ọ́ dese oni ayẹmhẹ obe, ọọ li, “Guese unu pia, te ọli egbe lase le.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Oni ayẹmhẹ obe o nighise ọni ọmọse, o mu ọli pfi gbe. Ọ pfie okokokhuẹ, o rọte ọni ọmọse egbe ya lase. ");
INSERT INTO atgNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","O ga ri abọ sha ẹgbọ nya. E mhila egbe wẹ, “Onoghuo na? Osẹsẹ onogbọ ni o mhọli ekpabọ! Eri ọ ga nu ayẹmhẹ ebe ẹ ngme, e ga suọ esọ na li.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aghọaghọ ingme oyi iJesu o gbe ekẹ-a asha kpa ekẹ iGalili. ");
INSERT INTO atgNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","IJesu ali eniyẹ odukhokho eyọli, ghe iJemhisi ali iJọni, e ga rọte owa ugamhi fiẹ lasele, e ya je apfẹ oyi iSamọ ali Aduru ");
INSERT INTO atgNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ọgọ iSamọ ọni ọkpotso, ọ yẹshi ghua ughuamhi iba. IJesu ọ lẹsẹ ramhi aghọ, a gue ingme oyọli yẹ iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ighọ ọ lo deba li, ọ mu ọli obọ, ọ mu ọli ukpho vule. Ighọ eni iba e lase ọli egbe le. Ọ fẹli wẹ epfẹse. ");
INSERT INTO atgNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ẹlogbọmhi ẹlẹghọ khi ovọ ọọ tiemhi eko, ẹgbọ e tsua eni ẹa ze, ali eni iyẹmhẹ ọkphaghiẹ e yẹsẹ ngme bhale ghi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ẹgbọ nya ni e la oni ẹoli e le gba odalo oni owa. ");
INSERT INTO atgNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","IJesu ọ ri eni ẹ ghua, ighuamhi khi ighuamhi, ze. Ọ khu ayẹmhẹ ebe ebubu ẹgbọ egbe a, ama ọa zẹ ni eni ayẹmhẹ ebe eghọ e ngme emhikhọghuo unu lasele, itobọ khi e lẹsẹ ọni ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ogbiẹ-fiefie ogbeakọlọ khi obili ọa pfo ogbe ne, iJesu ọ fiẹ lase je ashini o da-ya, ọ ya sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ISamọ ali apfọli ni e kpọle, e vu ya nono ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Abi e rọ mẹ ọli, ẹẹ ọli, “Ẹgbọ kpa ẹẹ nono ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","IJesu ọọ wẹ, “Awa mema ya je ẹoli oboese, ikhi apfẹ eni e timama akana, ni mhi li la oobọ tsẹ abọ, irari khi ona o zẹ ni mhi rọ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ighọ ọ kia gasẹ ekẹ iGalili nya tse abọ. Ọ la owa ugamhi eyẹwẹ tse abọ. Ọ khu ẹgbọ ayẹmhẹ ebe egbe ku-a. ");
INSERT INTO atgNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ọmọse ni efafe e mu ọ bhale deba iJesu. Ọ wugha li odalo, ọọ lema li, ọọ, “Ini o ghọle ẹ, u dobẹ ya rẹmhẹ ze, u rẹmhẹ khi ọni ọ pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ighọ elemhi ọli, ee ala iJesu, ọ nise obọ-a ti ọni ọmọse, ọọ li, “O ghọle mhẹ, khi ọni ọ pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aghọaghọ eni efafe e lase ọli egbe le, ọ ze, ọ khi ọni ọ pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","IJesu ọ́ gueyẹ ọli, ọ ke vu. Ọ lolo tse agua ye ọli, ");
INSERT INTO atgNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ọọ li, “Khi gue ingme ona yẹ ọgbọkhọghuo, ama lẹ ya ri egbe ẹ khasẹ ekpodalo-ugamhi eyi Ẹshinẹgba, ni e tẹ ọkpẹ ne, ni u luasẹ obo ni iMosisi ọọ a ke luasẹ, ini a ri ọgbọ lina ze. Isheghọ, ni o khi ọtsẹlẹ na wẹ khi u she ze.” ");
INSERT INTO atgNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Eri ọni ọmọse ọ ri ochoghọ ngme ọli kiakiala gboo, ọ miatsẹ oni ingme onete ku asha kpa. Itobọ ona, iJesu ọa ke dobẹ lo ẹoli okhọghuo le gboo. Eri ọ ke la ọdagbe obini o da-ya. Abi o riẹ khi ighọ, eri ẹgbọ nya e kie rọte asha kpa ẹ bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ikuku ogbẹlẹ e dọsẹ, iJesu ọ gbo lo elemhi iKapanọmu, eni ẹgbọ e suọ khi ọ she bhale apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ebubu ẹgbọ e le gba ramhi ni ọgbọ a ke mẹ ashikhọghuo ni o kpọle, ya ramhi olase unu-odẹ. IJesu ọ tse abọ oni usomhi yẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ighọ emọse aane e tsua ọmọse ni ọ guọghọ-a adigege shi iya bhale ghi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Abi eni emọse ẹa rọ mẹ asha tsua li lole ashini iJesu ọ la, itobọ ẹgbọ ni e ghọ bu dọsẹ, e nga ukhomhi oni owa rọte ashini iJesu ọ la gbese ekpha-a. Abi e rọ gbese ọlia se, e ri ili ri ọni ọmọse tiemhile, abi ọ́ kie li yẹshi iya. ");
INSERT INTO atgNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Abi iJesu ọ rọ mẹ irudunga oyẹwẹ, ọọ ọni ọmọse ni ọ guọghọ-a, “Omimhẹ, a she ri olamhẹ topfa ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ama eni ẹ sẹsẹ Ishi eyi iMosisi ni e shitọ akaghọ, e sa ọ udu oyẹwẹ, e liẹ, ");
INSERT INTO atgNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Elọ o zẹ ni ọni ọgbọ ọna ọ rọ ngme ungmemhi onana unu. Eri ọ pfi unu-a! A li mẹ ọni ọ dobẹ ya gbe olamhẹ kua na ọgbọ? Ọa khi Ẹshinẹgba luẹghuo?” ");
INSERT INTO atgNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aghọaghọ iJesu ọ she lẹsẹ elemhi ayẹmhẹ oyọli emini e sa shi elemhi udu oyẹwẹ, ọọ wẹ, “Elọ o zẹ ni a rọ sa usamhi onana. ");
INSERT INTO atgNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Onoghuo o kẹlẹ nẹ, ni a rọ liẹ ọni ọmọse ni ọ guọghọ-a, ‘A ri olamhẹ topfa ẹ,’ abi khi ‘Vule, rue iya oyẹ ni u ke kia’? ");
INSERT INTO atgNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mhi ya rọ li khasẹ ẹ khi Omi Ọgbọ ọ mhọli ekpabọ elemhi agbọ ona ni ọ rọ gbe olamhẹ kua na ọgbọ.” Ighọ ọ gueyẹ ọni ọmọse ni ọ guọghọ-a eghọ, ");
INSERT INTO atgNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mhiẹ yẹ u vule, u rue iya oyẹ, u ke je apfẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ọni ọmọse ọ vule, ọ rue iya oyọli, ọ la akpẹwẹ nya kia vu. O ri abọ sha ẹgbọ kpa. Ee kuẹghiẹ Ẹshinẹgba, e liẹ, “Anye ẹa kpẹ mẹ onana ghue oo!” ");
INSERT INTO atgNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","IJesu ọ gbo je epfẹ okẹ oniẹmhi ni o khishi. Ebubu ẹgbọ e bhale deba li, ọ sẹsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Abi ọ kia lẹ, ọ mẹ ọmionoga iLiva omi Afeusi khi ọ shitọ okholo eyi eni ẹ mie oga. IJesu ọọ li, “Deba mhẹ.” Ighọ ọ vule deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Abi iJesu ọ la ayi iLẹvi le eminale ẹlogbọmhi, emionoga ni e bu ali ẹgbọ ena olamhẹ e li nu ọli ali eniyẹ odukhokho eyọli le emhi, irari khi ẹgbọ ni e bu e deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Abi ẹgbọ eni ẹẹ sẹsẹ ishi na lui iFarisi e rọ mẹ khi iJesu ọ nu egbushia ali emionoga ẹ le eminale, e mhila eniyẹ odukhokho eyọli, “Elọ o zẹ ni ọ rọ nu emionoga ali egbushia ẹ le eminale?” ");
INSERT INTO atgNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","IJesu ọ suọ onana, ọọ wẹ, “Ẹgbọ ni e ze ẹa mhuẹ emini e ri ọbo ẹ li. Ọni ọọ to, ọ́ ye apfẹ ọbo. Ọa khi eni e pfuasẹ ne mhi bhale ya lu, ama egbushia.” ");
INSERT INTO atgNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ẹghẹghẹ oghuo eniyẹ odukhokho eyi iJọni Ọni ọọ batazi ẹgbọ ali ẹgbọ iFarisi ee pfi azumhi. Ẹgbọ eghuo e bhale ya mhila iJesu, ẹ ọli, “Elọ o zẹ ni eniyẹ odukhokho eyi iJọni ali enayi ẹgbọ iFarisi e rọ pfi azumhi ni eyẹ ẹa rọ́ pfi?” ");
INSERT INTO atgNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","IJesu ọ sọ wẹ ọ, ọọ wẹ, “Sẹ epfẹse eyi ọmọse ni ọ rue ọmueshi ọnọgbọ e liẹ ke pfi azumhi ini oni ọmọse ọ kie nu wẹ shitọ? Ẹa mẹ asha pfi azumhi ini ọ kie nu wẹ shitọ. ");
INSERT INTO atgNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama ẹghẹghẹ o ya bhale ni a rọ rue ọni ọdọ ọni ọmueshi vu. Ẹghẹghẹ aghọ, e rọ tigbe ya ke pfi azumhi. ");
INSERT INTO atgNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ọgbọ a ya khi ode onogbọ gbẹla ma ode onodiọ. Ini u lighọ, eri oni ode onogbọ o ya nyanọ oni ode onodiọ-a. O ke nyanọ-a dọsẹ abi o kpẹ li. ");
INSERT INTO atgNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ali khi ọgbọ ọa ya ku onyọ onogbọ shi akpaba onodiọ. Ikhi akpaba ni ẹgbọ iJu e ku onyọ shi. Ini u lighọ, eri oni onyọ o ya vẹsẹ oni akpaba-a. Oni onyọ ali oni akpaba e ga li opfu-a. Akpaba onogbọ a ku onyọ onogbọ ẹ lo.” ");
INSERT INTO atgNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ogbẹlẹghuo ẹlẹ iyẹmhẹa oyi ẹgbọ iJu, iJesu ọ rọte ifui ishemhi iakpa kia dọsẹ. Eniyẹ odukhokho eyọli e li nu ọli kia. Ighọ e li bẹ eni iakpa. ");
INSERT INTO atgNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ighọ iFarisi e mhila iJesu, “Elọ o zẹ khi eniyẹ odukhokho eyẹ ẹẹ riẹlẹ emini a ghuẹ ẹlẹ iyẹmhẹa?” ");
INSERT INTO atgNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","IJesu ọ sọ wẹ ọ, ọọ, “Aa kpẹ mẹ ọli zẹ Ebe-no-pfuasẹ emini Oghie iDefidi ọ riẹlẹ abi okiamhi o rọ gbe ọli ali eni e nu ọli kia? ");
INSERT INTO atgNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ẹghẹghẹ ni Abiata ọ rọ khi Ọkpeda na ekpodalo-ugamhi eyi Ẹshinẹgba, ni Oghie iDefidi ọ rọ lo Owa oyi Ẹshinẹgba ya rue ibulẹdi ni a rọọ ga Ẹshinẹgba le, ọ kholo na eni e nu ọli kia le. Ibulẹdi ona ighie eyi ekpodalo-ugamhi tsẹ, ushi o lama e ke le wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ighọ ọọ wẹ, “Eri a ma ogbẹlẹ iyẹmhẹa na ọgbọ, aa ma ọgbọ na ogbẹlẹ iyẹmhẹa. ");
INSERT INTO atgNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Itobọ ighọ, Omi Ọgbọ ọ khi Ọnọmhuẹ, li shi ọyi ogbẹlẹ iyẹmhẹa.” ");
INSERT INTO atgNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ẹlẹlese khi iJesu ọ gbo je owa ugamhi, ọmọse ni obọ oyọli oghuo o ghua, ọ la akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ẹgbọ eghuo e nono ashini e te ya mẹ asha gue ingme shi iJesu egbe. E ri ukpẹloe shi ọli egbe ini ọ ya ri ọgbọ ze ẹlẹ iyẹmhẹa. ");
INSERT INTO atgNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","IJesu ọọ ọni ọmọse ni ọ ghu obọ-a, “Vule migha odalo oyi ẹgbọ kpa.” ");
INSERT INTO atgNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","IJesu ọ mhila wẹ, “Onoghuo o gbe akanya elemhi ushi oyawa nẹ ẹlẹ Iyẹmhẹa? Ni a rọ riẹlẹ onete abi ni a rọ riẹlẹ onobe? Ni a rọ tsumhi agbọ oyi ọgbọ abi ni a rọ pfuse ọlia?” Ama e tsaghiẹ a. ");
INSERT INTO atgNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ighọ iJesu ọ ri elemhi ibibi bino wẹ gasẹ, udu oyọli o yese-a shi udu obe ni e mhuẹ. Ọọ, “Nọmọse nise obọ-a.” Ọ nise ọli-a. Ighọ obọ oyọli o gbo li abi o kpẹ te ekẹ li ");
INSERT INTO atgNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ighọ ẹgbọ iFarisi e fiẹ deba eniyẹ odukhokho eyi Erọdu, e ya gba ugbamhi abi e li ya gbe iJesu-a. ");
INSERT INTO atgNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ighọ iJesu ali eniyẹ odukhokho eyọli e lase wẹ iteva le ya je okẹ na iGalili. Ebubu ẹgbọ e rọte iGalili deba iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Abi e rọ suọ emini ọ riẹlẹ, ebubu ẹgbọ e bhale deba li, rọte ekẹ iJudia ali iJerusalẹmu, ali Idumia ali ekẹ ni o kpe obọ na iJọdani ali epfepfẹ iTirẹ ali iSidọni. ");
INSERT INTO atgNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Itobọ khi eni ẹgbọ e bu dọsẹ, iJesu ọ gueyẹ eniyẹ odukhokho eyọli e nono ọkọ-okẹ oni ikeke ni lọli lo ọ ini ẹgbọ e khi sha mu luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Itobọ khi ọ she kpẹ ri ebubu ẹgbọ ze, ẹgbọ eni ẹa ze, e mise egbe ini e mẹ asha ramhi ọli egbe ri obọ ti ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ẹghẹghẹ kpa ni ẹgbọ ni ayẹmhẹ ebe e yẹsẹ ẹ ngme e rọ da mẹ iJesu ne, e de ya yẹshi ekẹ odalo oyọli. Ẹẹ tsẹsẹ, ẹẹ liẹ, “Omi Ẹshinẹgba u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama, ọ tse agua yẹ eni ayẹmhẹ ebe eghọ e khi gue ọni lọli khi le. ");
INSERT INTO atgNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","IJesu ọ nga ukhomhi ute, ọ lu emọse ni e ghọle ọli. E bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ọ ya zẹ ẹgbọ ogbava kẹ, ọ lu wẹ ighiusomhi na kẹẹ. Ọ zẹ wẹ ni e nu luẹ ke kia, ali ni luẹ mẹ wẹ ke ghie usomhi fiẹ ke tse abọ usomhi onete, ");
INSERT INTO atgNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ali ni e gbo mhuẹ ekpabọ ni e rọ ke khu ẹgbọ ayẹmhẹ ebe egbe kua. ");
INSERT INTO atgNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ena e khi otuogbava ni ọ zẹ. ISamọ, ọni iJesu ọ lu iPita. ");
INSERT INTO atgNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","IJemhisi ali inyọghuo-ọli iJọni imi iZebedi (eni iJesu ọ ri akiseva iBonajisi na. Ni o migha shi Imi Akphala), ");
INSERT INTO atgNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ali Aduru, iFilipu, iBatolomiu, iTọmọsi, iJemhisi omi Afeusi, ali iTadiusi, iSamọ ọni ije-odalo oyi ẹdẹli iJu oo ghọ mu egbe. ");
INSERT INTO atgNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ali iJudasi Isikarọti ọni ọ ri iJesu dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","IJesu ọ nyenẹ egbe je apfẹ. Ighọ ebubu ẹgbọ e gbo tigbili ramhi khi iJesu ali eniyẹ odukhokho eyọli ẹa mẹ asha, wẹ khi eminale e ya le. ");
INSERT INTO atgNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abi apfẹ ọ e rọ suọ ona, E nono khi wẹwẹ e ya mu ọli je apfẹ. Irari khi eri e liẹ, “Ujili o she ẹ kpha li.” ");
INSERT INTO atgNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Eni ẹẹ sẹsẹ ishi ni e rọte iJerusalẹmu tiemhie, e liẹ, “Ayẹmhẹ iBezebọ ni ọ khi Ọkphaghiẹ o la li egbe yẹsẹ ọli ẹ ngme! Lọli ọ khi oghie ọyi iyẹmhẹ ebe ni ọ ri ekpabọ na li ni ọ rọ ke khu ẹgbọ iyẹmhẹ ebe egbe kua.” ");
INSERT INTO atgNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ighọ iJesu ọ lu wẹ, ọ ri okhẹ irọkhọkhọ nu wẹ ngme, Ọọ wẹ, “Sẹ ọkphaghiẹ ọ liẹ ke khu ọkphaghiẹ? ");
INSERT INTO atgNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ini ushishi e kemhi egbe wẹ shi ikui-iku ni e rọ nu egbe wẹ ẹ khọli, eri oni ushishi ọọ de. ");
INSERT INTO atgNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ini ọmhuẹ-apfẹ o kemhi shi ikui-iku ni e rọ nu egbewẹ ẹ khọli, eri oni ọmhuẹ-apfẹ o ya de. ");
INSERT INTO atgNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ini ọkphaghiẹ ọ mu okhọli vule shi egbọli ọ, ọa ya tọ, eri ọ ya de, ukpẹsẹ oyọli o she ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ọgbọ ọkhọghuo ọa la ọ ni ọ dobẹ ya lo owa oyi ọmọse-akama ya ti ọli itsua ekẹ-a ini ọa kpẹ mu ọni ọmọse-akama gẹ shi ekẹ. Ẹghẹghẹ aghọ, ọ tigbe dobẹ ti ọli itsua ekẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Egbegbi ingme mhi gueyẹ ẹ, khi, aa mẹ olamhẹ ni ọgbọ ọ lamhẹ ali ungmemhi ipfiunu-a ni ọgbọ ya ngme, ni aa dobẹ rọ ya gbekua na li. ");
INSERT INTO atgNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama ọnini ọ da ngme ungmemhi ipfiunu-a deba Ayẹmhẹ-nọ-pfuasẹ ne, aa ya rọ topfa li, irari khi olamhẹ ona agbọagbọ ọ pfi obọ lo.” ");
INSERT INTO atgNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Itobọ khi ẹ ọli khi, “Ọ mhọli ayẹmhẹ ebe,” ọ rọ ngme ona. ");
INSERT INTO atgNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ighọ inyọ iJesu ali inyọghuo ọli ee bhale. E migha oolase. E ghie ọgbọ ọ ka lu iJesu ghi ẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ebubu ẹgbọ e shitọ gasẹ ọli. E bhale ya gueyẹ ọli khi inyọli ali inyọghuo ọli e la oolase, khi ẹẹ nono ni wẹwẹ e mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ọ mhila wẹ, “Eghuo e khi inyẹmhẹ ali Inyọghuo-mhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ighọ ọ bino eni e shitọ gasẹ ọli, ọọ, “Enana e khi inyẹmhẹ ali Inyọghuo-mhẹ! ");
INSERT INTO atgNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ọnini ọ́ da riẹlẹ emini e ghọle Ẹshinẹgba, ọ khi Inyọghuo-mhẹ ọnọmọse ali ọnọkpotso ali inyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","IJesu ọ ke gbo la epfẹ okẹ ni o khi shi na iGalili sẹsẹ. Ẹgbọ ni e le gasẹ ọli e bu dọsẹ ramhi ni ọ rọ ya lo elemhi ọkọ-okẹ shitọ. Oni ọkọ-okẹ o la elemhi oni okẹ. Eni ẹgbọ e ke migha egele esesọ oni okẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Emhi ebubu ọ ri okhẹ irọkhọkhọ ọ sẹsẹ wẹ. Ọọ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“A ghe i! Ọghiale ọ́ ya la ọ. Ọ fiẹ yá kọ iakpa. ");
INSERT INTO atgNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Abi ọ li kia miatsẹ eni iakpa, ikpamhi eghuo ọ e de kua odẹ, ighọ ipfeli e bhale ya sanọ wẹ le. ");
INSERT INTO atgNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eghuo ọ, e de kushi ekẹ ni o khi ọkpegbhẹ, ni ekẹ ẹa lolo la. Ighọ e nyanya zẹ, e fu, ama oni ekẹ ọa limhi. ");
INSERT INTO atgNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ama abi ovọ o rọ to, o tosẹ wẹ a, e khakha, itobọ khi ẹa mẹ ekẹ ni o limhi pfi imhili lo. ");
INSERT INTO atgNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ikpamhi emhi elese e de kulo ifui igba. Ighọ igba e zẹ lasele tono eni iakpa abi e rọ fu vule. Itobọ ighọ, ẹa ke dobẹ ni e fu nyanọ ekhẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ama ikpamhi eghuo, e de shi ekẹ onete. Eni ikpamhemhi e zẹ, e fu, e nyanọ ekhẹ lasele. Eghuo ọ, e mhuẹ ikpamhi uye ali igbe, eghuo ọ, e mhuẹ ikpamhi egbhuẹsẹ, elese e mhuẹ egbhuẹshe.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ighọ iJesu, ọọ, “Ọni ọ mhọli esọ, ọ suọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Abi iJesu lọlighuo ọ rọ shitọ, eniyẹ odukhokho ogbava eyọli ali ẹgbọẹse ni e li suọ abi ọ rọ ngme, e bhale deba li, ọ gueyẹ wẹ emini ọ ri oni okhẹ irọkhọkhọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ọọ wẹ, “A she ri osheli oyi Eghiele oyi Ẹshinẹgba na ẹ. Ama okhẹ irọkhọkhọ a rọ gue ungmemhi nya yẹ ẹgbọẹse. ");
INSERT INTO atgNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ni a bhale ya ẹ khi, “ ‘E kha riẹ nya alo-a shi ekẹ ẹa tigbe ya mẹ emhikhọghuo, ali e kha riẹ ku esọ a shi ekẹ, ọa ya lo wẹ esọ. Irari khi ini ọa khi ighọ, e dobẹ mẹ ekẹ, e suọ esọ, e mu pfi deba Ẹshinẹgba, ọ rọ topfa wẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","IJesu ọ mhila wẹ, ọọ wẹ, “Aa lẹsẹ emini a ri okhẹ irọkhọkhọ ona ngme? Sẹ a li tigbe ya lẹsẹ emini a ri okhẹ irọkhọkhọ okhọghuo ngme shọ? ");
INSERT INTO atgNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Eni iakpa ni ọni ọghiale ọ miatsẹ ẹ ku, e migha shi ungmemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Eri ikpamhi iakpa ni e de shi odẹ e li abi ẹgbọ eghuo ni e kha da lẹsẹ suọ oni ungmemhi ne, Ọkphaghiẹ ọ bhale ya rue wẹ luẹ udu le. ");
INSERT INTO atgNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ikpamhi emhi ni e de shi ekẹ ni o li echechẹ, e li abi ẹgbọ ni e kha da lẹsẹ suọ oni ungmemhi ne, e ri udu oghẹlẹ mie ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama, ọa ya tiemhi wẹ ekẹ elemhi. Ẹa dobẹ migha tẹsẹ, itobọ khi ọa pfi imhili lo ekẹ. Itobọ ighọ, ini ọmunu o bhale ali ni a rọ mu okhọli vule shi wẹ ọ rọte oni ungmemhi ni e suọ, e kẹlẹ de odẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ikpamhi emhi ni e de pfilo ifui igba eri e li abi ẹgbọ ni e kha suọ oni ungmemhi, ");
INSERT INTO atgNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","isamhi ingme agbọ ona, ali ọghuẹmhẹ ẹpfue, ali ọghuẹmhẹ khi ọghuẹmhẹ e lu guese oni ungmemhi-a, ẹẹ tono ọli igba, itobọ ighọ ọa mọ imọmhi. ");
INSERT INTO atgNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ama ikpamhi emhi ni e de shi ekẹ onete, e li abi ẹgbọ ni e suọ ungmemhi, e mie ọli suọ, e mọ imọmhi enete. Eghuo e mhuẹ ikpamhi uye ali igbe, eghuo e mhuẹ egbhuẹsẹ. Eghuo, e mhuẹ egbhuẹshe.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","IJesu ọ gbolo ẹ wẹ “Ọgbọkhọghuo ọ̀ọ́ ya ri ákpá ru lasele, ọ ya rue atalabi guese ọli mu ekẹ, wẹkhi eri ọ ke ya rue ọli ya sheli ufui ukpho? ");
INSERT INTO atgNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Emiemini a rọ sheli, o ya lasele gbo alo gbugbugbu. Aa mẹ emhi osheli ni aa ya khueghie a. ");
INSERT INTO atgNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ọnini ọ mhọli esọ, ọ ri esọ shi ekẹ ni ọ suọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ọ gbolo ẹ wẹ, “Emiemini u da suọ kpa, sa ọ bie! Emiemini u da rọ shi ushi rọ gue ẹgbọẹse ẹzọ, Ẹshinẹgba ọ li ya rọli gue ẹ ẹzọ. Oyẹ o gbo ya ze nẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ọni ọ kpẹ mhọli ne, a ya gbo rọ ma ọ na li, ama ọni ọa mhọli a ya mie ọli ukukuọ ni ọ gbo mhọli.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","IJesu ọ gbolo ẹ, “Abi Eghiele oyi Ẹshinẹgba o li na. Eri o li abi ini ọmọse ọ miatsẹ ikpamhi iakpa kia ku shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Obili o kha bi, ọ ya lesẹ a, ogbe o kha gbe ọ guale, ama eni ikpamhi emhi ẹẹ zẹ lasele, ẹẹ fu vule. Ama ọa ya lẹsẹ abi o li kia. ");
INSERT INTO atgNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ekẹ lọlighuo ọ lẹsẹ abi o li ri emhi ẹkọmhi ẹẹ bie. Oni ododẹ, o kha zẹ ukhuli, o ke fu vule, o nyanọ ifẹlẹ, o ya ri umọmhi lasele. ");
INSERT INTO atgNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eni iakpa e kha da bie ne, ọni ọ gua wẹ ọ rue agaga ya gbe wẹ, itobọ khi ẹghẹghẹ ikhiẹsẹ o ramhi.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","IJesu ọ gbolo ẹ wẹ, “Elọ awa mema ri Eghiele oyi Ẹshinẹgba ya khọkhọ? Okhẹ irọkhọkhọ onoghuo awa mema ya zẹ rọli lo ẹgbọ esọ eghọ o? ");
INSERT INTO atgNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eri o li abi ukpamhi ọara imọsitadi ni ukpamhi ọli o shẹ nẹ nya agbọ ona, ni ọgbọ ọ rọ kọ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ini a rọli kọ, o zẹ, o fu vule, o mele unyanọ ni o funẹ a shi ishemhi, ni o mhọli iguabọ eniẹmhi, ni ipfeli ẹ bhale ya ku eko shi.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Okhẹ irọkhọkhọ enana iJesu ọ rọ nu wẹ ngme oni ungmemhi, ramhi ashini o lo wẹ esọ ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aa mẹ ungmemhi ni ọ nu wẹ ngme, ni ọa ri okhẹ irọkhọkhọ nu wẹ ngme. Ama ini o de tẹ ọli ali eniyẹ odukhokho eyọli, ọ rọ ri emini ọ nu wẹ ngme nya a lo wẹ esọ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ẹlẹ ogbọmhi ẹlẹghọ, iJesu ọọ eniyẹ odukhokho eyọli, “Awa da je ukiẹkiẹ okẹ obini o kpọle.” ");
INSERT INTO atgNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ighọ e zẹ ẹgbọ ni e legba obọ shi aghọ, eni eniyẹ odukhokho e ya lo elemhi ọkọ-okẹ oni ikeke ni iJesu ọ she lo shitọ. E gua li vu. Ọkọ-okẹ elese e li deba wẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Utoghuokpe, akpekpeli oniẹmhi oo li, oo zughuse oni okẹ, ni amẹ e fiase kulo elemhi oni ọkọ-okẹ, ramhi ni o rọ vọ amẹ. Ukukuọ o kpọle ni ọa rọ kuluẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","IJesu ọ la ukhokho oni ọkọ-okẹ oniẹmhi, ọ́ lesẹ-a ri ukhomhi nga akpẹsukhomhi. Ighọ eniyẹ odukhokho eyọli e guise ọli le. Ẹ ọli, “Ọsẹsẹ, wa bie ga liẹ ini awa ghọ ghua?” ");
INSERT INTO atgNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ighọ iJesu ọ ti vule, ọ dese oni akpekpeli, ọọ li, “Li tsukẹ.” Ighọ oni akpekpeli ó pfọmhẹ te. Asha kpa o pfọmhẹ tsukẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ighọ iJesu ọọ eniyẹ odukhokho eyọli, “Elọ o zẹ ni a rọ́ lighọ́ ọ́ na ulishi. Eri aa kie mhọli irudunga?” ");
INSERT INTO atgNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ulishi oo mu wẹ, e mhila egbe wẹ, “Ọghuo ọna ọ khi? Ghe akpekpeli ali izughuse okẹ e ga suọ esọ a na li.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","IJesu ali eniyẹ odukhokho eyọli e da okẹ iGalili je ukiẹkiẹ ekẹ iGẹrasẹnẹsi. ");
INSERT INTO atgNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Abi iJesu ọ lẹsẹ rọte elemhi ọkọ-okẹ lasele, ọmọse ni ọ mhọli ayẹmhẹ ebe, ọ rọte atalimhi ni o la aghọ bhale deba iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ifui atalimhi ọni ọmọse ọọ la. Ọgbọkhọghuo ọa ke dobẹ ri iwẹghẹ gẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ẹghẹghẹ kpa, a rọ́ ri iwẹghẹ gẹ ọli abọ ali awẹ, ama eri ọọ kphuru wẹ a, ọ taghiẹ wẹ a, ọ shashe wẹ a. Ọgbọkhọghuo ọa dobẹ mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nobi-nogbe ọ́ rọ la ifui atalimhi ali ikhomhi ite dudu gasẹ. Ọọ pfi okokokhuẹ. Ọ ri echẹ fianọ egbeọli. ");
INSERT INTO atgNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Abi ọ lẹsẹ ta pfia mẹ iJesu te, ọ na bhale ya wugha li odalo. ");
INSERT INTO atgNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ọ tsẹsẹ leghe, ọ́ọ́, “IJesu Omi Ẹshinẹgba ni ọ Yagha Ne Nyaa, elọ wa nono mhẹ egbe? Mhi ri Ẹshinẹgba lema ẹ khi na mhẹ osoli!” ");
INSERT INTO atgNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Itobọ emini ọ rọ ngme na khi, iJesu ọ she kpẹ gueyẹ ọli, “Yẹyẹ ayẹmhẹ obe, lase ọni ọmọse ọna egbe le.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ighọ iJesu ọ mhila li, “Sẹ a lui eva oyẹ?” Ọọ, “Eva oyẹmhẹ o khi Olele ẹgbọ, itobọ khi anye bu gba.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ọ gbo lema iJesu ọ kpẹkpẹ, ọ khi khu ẹwẹ oni ekẹ ya lase. ");
INSERT INTO atgNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Igulu ni e bububu e la epfẹ ute ni o la aghọ le eminale. ");
INSERT INTO atgNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eni ayẹmhẹ e lema iJesu, “Khu anye ya lo igulu eghọ, zẹ ni anye ya lo wẹ egbe.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","IJesu ọ ri ẹghẹghẹ na wẹ, e ka lo eni igulu egbe. Ighọ e rọte ọni ọmọse egbe lasele e ya lo eni igulu egbe. Eni igulu ni e ramhi agbẹlẹ eva, e rọte egele na ya kulo oni okẹ, e ghuloa nya. ");
INSERT INTO atgNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eni e ri ukpẹloe ẹ khu eni igulu e na je ifui apfẹ ali ẹoli nya ni e la oni ekẹ ya guele emini a mẹ. Ighọ ẹgbọ e bhale ya bino emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Abi eni ẹgbọ e rọ bhale deba iJesu, e mẹ ọni ọmọse ni ayẹmhẹ ebe ni e bu e kpẹ la egbe, khi ọ shitọ aghọ, ọ ri itsua sọ, ẹgbhali eyọli e she gba na li. Ulishi oo mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eni e mẹ emini a mẹ e gueyẹ ẹgbọ emini ọni ọmọse ni ayẹmhẹ obe e la egbe ọ mẹ egbe ali emini e li eni igulu. ");
INSERT INTO atgNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ighọ, e gueyẹ iJesu ọ lase wẹwẹ ekẹ le. ");
INSERT INTO atgNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Abi iJesu ọ lo elemhi ọkọ-okẹ oniẹmhi khi ọọ ke vu, ọni ọmọse ni ayẹmhẹ ebe e kpẹ la egbe, ọ lema iJesu ọ zẹ ni lọli deba li vu. ");
INSERT INTO atgNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama iJesu ọa lama na li. Ọ ri ochoghọ liẹ ọli, “Ke je apfẹ ni u ya gueyẹ ẹgbọ ena unuẹkpẹ oyẹ emini Ọnọmhuẹ ọ riẹlẹ nẹ, ali abi ọ li lẹ elemhi ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ighọ ọni ọmọse ọ lui ifui ẹoli igbe ọdọda ena ekẹ iDikapolisi. Ọ kia gueyẹ ẹgbọ abi iJesu ọ li riẹlẹ na luẹ. O ri abọ sha ẹgbọ nya. ");
INSERT INTO atgNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Abi iJesu ọ rọ gbo nyenẹ egbe da je ukiẹkiẹ okẹ obini o kpọle, ẹgbọ e le gasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ọmọse ọghuo ni a lu iJarọsi, ni ọ khi ọtuọghuo eni ẹ mhẹsẹ shi owa ugamhi, ọ bhale akaghọ. Abi ọọ mẹ iJesu te, ọ de ya wugha li odalo. ");
INSERT INTO atgNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ọ mema lolo lema li, ọ́ọ́ li, “Omimhẹ ọni ọmueshi ọ ma ghua gba memena, kpẹkpẹ bhale ya ri obọ ti ọ li egbe ni ọ ze, ini ọ khi ghua.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ighọ iJesu ọ deba li vu. Ighọ ebubu ẹgbọ e deba li e vẹ mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ọkpotso ọghuo ọ la aghọ ni ọ she ku ọlia ishitọ egbe ramhi ikpe igbẹva. ");
INSERT INTO atgNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ọ̀ she mẹ osoli obọ oyi ebubu ẹgbọ abi ọ rọ kia dua oni ughuamhi. Ọ́ she ri ẹpfue eyọli nya dua ọ, ama ọa pfo, oo ga khọlọ ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Abi ọ rọ suọ ingme oyi iJesu, ighọ ọ te ifuabọ oyi ẹgbọ ri obọ ti ọli awulu ni ọ sọ. ");
INSERT INTO atgNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ọ rọ li shi udu khi, “Ini mhi da mẹ asha ri obọ ti ọli awulu ne, mhi ya ze.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Abi ọ ri obọ ti ọli awulu te, eni ọlia ni e ku ọli egbe, e khakha utoghuo kpe. Aghọaghọ ọ lẹsẹ khi emini o yẹsẹ luẹ ẹ ngme, khi o pfo. ");
INSERT INTO atgNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aghọaghọ, iJesu ọ lẹsẹ khi itoto o she rọte luẹ egbe ya lase. Ighọ ọ migha, ọ mu egbe pfi iteva ẹgbọ ni e sha mu ọ. Ọ mhila wẹ, ọ́ọ́. “Ọghuo ọ ri obọ ti mhẹ awulu?” ");
INSERT INTO atgNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eniyẹ odukhokho eyọli ẹẹ ọli, u ga mẹ abi ẹgbọ e liẹ vẹ mu ẹ, u kiele ẹ mhila, “Ọghuo ọ ri obọ ti mhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama, iJesu ọ kie bino gasẹ ini ọ mẹ ọni ọ ri obọ ti ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Abi ọni ọkpotso ọ rọ mẹ abi o ke li ọli egbe, ọ bhale odalo oyi iJesu ya wugha, ulishi o mema mu ọli, ọ gue igẹsikia le abi o ga li kia nya. ");
INSERT INTO atgNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","IJesu ọ́ọ́ ọni ọkpotso, “Omi mhẹ, irudunga oyẹ o she mie ẹ pfuese. Ri opfọmhẹ ke je, anasẹmhẹ oyẹ o she pfo.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Abi iJesu ọ kie li ngme, emọse eghuo, e rọte owa oyi iJarọsi bhale. Ẹẹ iJarọsi, “Omiẹ ọ she ghua, khi ke yẹsẹ Ọsẹsẹ ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","IJesu ọa fẹ ri esọ shi emini e ngme, ọ́ọ́ ọni ọmọse “Khi zẹ ni ulishi o mu ẹ, ama lẹsẹ mhọli irudunga.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ọa zẹ ni ọgbọkhọghuo ọ deba li sẹ ni iPita, ali iJemhisi ali iJọni inyọghuo iJemhisi. ");
INSERT INTO atgNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Abi e rọ bhale owa oyi iJarọsi, iJesu ọ mẹ abi ẹgbọ e li i kpe okeke, ni e li i viẹ gbii. ");
INSERT INTO atgNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ighọ, ọ lo elemhi oni owa, ọ́ọ́, “Elọ o pfi onyaghu onana? Elọ o rẹ ẹ viẹ? Ọni ọmọ ọa ghu, eri ọ lesẹ a.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ama eni ẹgbọ e gia li. Abi ọ rọ khu wẹ fiẹ se, ọ rue ita ali inyọ ọni ọmueshi ali eniyẹ odukhokho otuasẹ eghọ mhuẹ obọ je ashini ọni ọmọ ọ yẹshi. ");
INSERT INTO atgNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","IJesu ọ mu ọli obọ, ọọ ọni ọmueshi, “Talita kumi.” Emini a ri ona ngme khi, “Ọnọmueshi, mhiẹ yẹ u vule.” ");
INSERT INTO atgNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Utoghuo kpe, ọni ọmueshi ọ vule, ọ́ kia gasẹ. Ọmọ ikpe igbẹva ọ khi. Abi a rọ mẹ ona, o ri abọ sha wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ama iJesu ọ lolo tsẹ agua yẹ wẹ e khi gueyẹ ọgbọkhọghuo. Ọọ wẹ, “A ri emhi na li le.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","IJesu ọ rọte aghọ vu je ẹoli oyọli, eniyẹ odukhokho eyọli e deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu o ramhi, ọ́ọ́ sẹsẹ elemhi owa ugamhi. O ri abọ sha ebubu ẹgbọ eni e ri esọ shi ọli ọ. E mhila egbe, “Obo ọni ọmọse ọna ọ rọte mẹ eni emhi enana? Ilẹsingme nabi onoghuo na ni a rọ na li, ni ọ gbo rọ gbe ikanya ọnyaloa? ");
INSERT INTO atgNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ọna ọa she khi ikapita, omi iMeli, ni ọ gbo khi inyọghuo iJemhisi ali iJosisi ali iJudasi ali iSamọ? Ena ẹa khi inyọghuo ọli eni imueshi, ni e ga li nu awa la akana enana?” O ri elemhi bi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ama iJesu ọ́ọ́, “Ashakpa a la mu ekpẹ na ọmekẹguele, sẹ ni apfẹ oyọli ali unuẹkpẹ oyọli aa la mu ekpẹ na li.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ọa dobẹ la akaghọ gbe akanya ọnyaloa okhọghuo, sẹ ni ikuku ẹgbọ ni ẹa ze ni ọ́ rọ ze abi ọ rọ ri obọ ti wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Umha-mhọli irudunga oyẹwẹ o ri abọ sha iJesu. Ighọ iJesu ọ kia rọte ẹoli je ẹoli sẹsẹ eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ọ lu eniyẹ odukhokho etuogbava eyọli tigbili, ọ ghie wẹ ava-ava fiẹ, ọ ri ekpabọ na wẹ ni e rọ́ mhuẹ itoto rọ khu ayẹmhẹ ebe. ");
INSERT INTO atgNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ọ gueyẹ wẹ, “Ini a lẹ, a lẹsẹ rue orọkpọ mhuẹ obọ, a khi tsua eminale, wẹkhi akpaba ni a pfi ẹ sọ, wẹkhi ukpaghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","A sọ ekuẹ, ama a khi tsua awulu olese ma oni a rọ sọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ọ gbolo ẹ wẹ, a kha da lo apfẹ okhọghuo le ni e rọ da mie ẹ, a la akaghọ ramhi ni a rọ ya rọte oni ẹoli vu. ");
INSERT INTO atgNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ini o khia khi a bhale ẹoli okhọghuo khi eni ẹgbọ ẹa mie ẹ, ni ẹa rọ gbo ri esọ shi emini a ngme, a rọte aghọ vu. A kpe abọ ọ-a na wẹ, a rọte aghọ vu. Eri ona o ya khi ọtsẹlẹ shi wẹ egbe.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ighọ e fiẹ ya tsẹ abọ gasẹ, e liẹ ẹgbọ e rọte olamhẹ oyẹwẹ mu pfi. ");
INSERT INTO atgNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","E khu ebubu ẹgbọ ayẹmhẹ ebe egbe-a, e ri oili to eni ẹẹ ghua ebubu egbe, e rẹwẹ ze. ");
INSERT INTO atgNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ẹghẹghẹ ana, oghie Erọdu ọ li suọ eko eni ingme ena nya, itobọ khi eva oyi iJesu o she gasẹ asha kpa. Ẹgbọ eghuo e liẹ khi iJọni Ọni ọọ batazi lọ ni ọ nyenẹ egbe bhale agbọ, lọli o zẹ ni ọ rọ lighọ mhọli ekpabọ rọ gbe ikanya ọnyaloa. ");
INSERT INTO atgNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ẹgbọ eghuo e liẹ khi, “Elaja Ọmekẹguele ọ khi.” Elese ẹ khi, “Ọmekẹguele nabi emekẹguele ena ẹlẹlẹ ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ama abi Erọdu ọ rọ suọ ona, ọ kẹ, “IJọni, ni mhi khi ukhomhi ọ, a rọte eghuli guise le!” ");
INSERT INTO atgNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Itobọ khi Erọdu ọọ ke mhẹsẹ a mu iJọni gẹ pfilo owa ighumha. Ini egbe e ba mu Ẹrodiasi. Eri Erọdu ọ mie iFilipu inyọghuo ọli Ẹrodiasi. ");
INSERT INTO atgNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ẹghẹghẹ kpa IJọni ọ rọ gueyẹ Erọdu khi, ọa ti ni ọ rue ughuẹ inyọghuo ọli shi. ");
INSERT INTO atgNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Itobọ ona, ọni Ẹrodiasi ọ̀ọ́ biselemhi iJọni, ọ̀ọ́ nono odẹ ni ọ te ya gbe ọli-a, ama ọa dobẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","A gbo bhale ya ẹ khi Erọdu ọ̀ọ́ na ulishi iJọni itobọ khi ọ lẹsẹ khi iJọni khi ọgbọ onete ali ọgbọ ọ ni ọ pfuasẹ ọ khi. Ọ ri irarighọ ri ukpẹloe ẹ khu ọli. Ọ̀ ma nono ni lọli ri esọ ke shi ungmemhi oyi iJọni, ini o ri riẹ khia khi ingmemhi eyọli e ma yese ọli udu-a ẹghẹghẹ kpa ni ọ rọ suọ li. ");
INSERT INTO atgNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ikpukhokho ọ, Ẹrodiasi ọ mẹ ashini ni ọ te ya mu ota sọ iJọni. Ighọ ẹlẹghuo ni o ikhi ogbẹlẹ ni Erọdu ọ rọ mhọli ukue ni ọ rọ yelele ogbẹlẹ ni a rọ bia li le. Ọ ya luno idenọmọ eyọli ali ẹgbọ eni mu ẹloe ali ẹgbọ igọmẹti ali eni ẹẹ gbe ikanya igọmẹti ni e la ekẹ iJudia shi oni ukue. ");
INSERT INTO atgNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Abi ọmọ ọmueshi omi Ẹrodiasi ọ rọ fiẹ lasele gbe ishimhi, o mema ti Erọdu ali ẹgbọ eni e bhale ya bino ọli ẹloe. Ighọ ọni oghie ọọ ọni ọmueshi, “Mhila mhẹ emiemini o ga ghọle ẹ, mhi ya rọli nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ọ romhi isheli khasẹ ọni ọmueshi, “Emiemini u mhila, mhi ya rọli ne, o kha riẹ khi agbekhi-eva eghiele oyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ighọ ọni ọmueshi ọ fiẹ ya mhila inyọ li, “Elọ mhi ya mhila?” Inyọli ọọ li, “Ukhomhi oyi iJọni Ọni ọọ batazi ẹgbọ wa mhila.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aghọaghọ ọni ọmueshi ọ nyanya na ya lo deba oghie, ọ mhila li, “Ukhomhi oyi iJọni Ọni ọọ batazi ẹgbọ mhia nono ni u khi shi ukpẹko na mhẹ memena.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Udu o todẹ yese oghie a. Ama itobọ ekha ni ọ tse ukpẹloe oyi epfẹse ni ọ lu shi oni ukue, ọa ke dobẹ ti da oni ekha. ");
INSERT INTO atgNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aghọaghọ ọ ghie eni ẹẹ gbolo ẹgbọ-a e ka pfa iJọni ukhomhi ọ bhale. Eni emọse e je owa ighumha ya khi iJọni ukhomhi ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","E rue ọli shi ukpẹko bhẹ. Ighọ oghie ọ kpha li na ọni ọmueshi. Ọni ọmueshi ọ kpha li na inyọ li. ");
INSERT INTO atgNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Abi eniyẹ odukhokho eyi iJọni e rọ suọ ona, e bhale ya tsua etuli oyọli ya rọ tọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Eni ighiusomhi na kẹẹ e jele, e le gasẹ ọli, e gueyẹ ọli emini e riẹlẹ ali emini e sẹsẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ighọ, itobọ ebubu ẹgbọ, ni ee bhale ni ee vu, iJesu ali eniyẹ odukhokho eyọli ẹa mẹ asha le eminale. IJesu ọọ wẹ, “A bhale ni awa je ashini awa-eghuo tsẹ awa ya la, ni a yẹmhẹ-a ukuku ọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ighọ wẹwẹghuo tsẹ ee lo ọkọ-okẹ oniẹmhi ya je ashini o da-ya. ");
INSERT INTO atgNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama ebubu ẹgbọ ni e mẹ wẹ abi e rọ vu, e lẹsẹ khi wẹwẹ lọ. Ighọ eni ẹgbọ e rọte ẹoli nya ri awẹ na ya ralo ashini iJesu ali eniyẹ odukhokho eyọli e je. ");
INSERT INTO atgNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Abi iJesu ọ rọ ramhi aghọ, ọ mẹ abi eni ẹgbọ e bu, elemhi wẹ e lala li. Itobọ khi eri e li abi isumha ni ẹa mhọli ọni ọ rẹ wẹ ẹ kia. Ighọ ọ li sẹsẹ wẹ emhi ebubu. ");
INSERT INTO atgNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ẹghẹghẹ ana, ogbe o she vu. Ighọ eniyẹ odukhokho eyi iJesu e bhale deba li, e kẹ ọli, “Aborọkhia khi oola óó nuata shi apfẹ ena, ni ẹghẹghẹ o rọ she vu dọsẹ ena, ");
INSERT INTO atgNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","waa ke gueyẹ eni ẹgbọ ena e kia je ifui apfẹ ya nono emhi dẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ama, iJesu ọ́ọ́ wẹ, “A ri emhi na wẹ le.” E mhila li, “Ifata eyi ogbẹlẹ elele eyi ọgbọ e ya lo ni a rọ dẹ ibulẹdi ghi wẹ le?” ");
INSERT INTO atgNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ighọ iJesu ọ mhila wẹ, “Iruli ibulẹdi ingmẹ a mhọli shi aghọ? A ka bino ghue.” Abi e rọ bino se, e ọli, “Iruli wẹ ishe ali ifẹlẹ aava.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ighọ iJesu ọ́ọ́ wẹ e riẹlẹ eni ẹgbọ shitọ ikui-iku, ukhomhi ebuli. ");
INSERT INTO atgNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","E shitọ ikui-iku, ẹgbọ egbhuẹshi-she ali egbhuẹ-eveva ali ogbogbe. ");
INSERT INTO atgNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ighọ iJesu ọ́ọ́ rue eni ibulẹdi ishe ali ifẹlẹ aava eghọ, ọ bino idane, ọ tsẹ Ẹshinẹgba uwegbe. Ọ gbe eni ibulẹdi khia, ọ rọ na eniyẹ odukhokho eyọli e ke kemhi na ẹgbọ. Ọ gbo kemhi eni ifẹlẹ aava na wẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ọgbọkpa ọ le, ọ khue. ");
INSERT INTO atgNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iku wẹ ni eniyẹ odukhokho eyọli e sanọ ekẹ, e vọ ighughu igbẹva. ");
INSERT INTO atgNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Emọse agbẹlẹ ishe, e le eni eminale. ");
INSERT INTO atgNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aghọaghọ ọ ri ọmọ odukhokho eyọli lo ọkọ-okẹ oniẹmhi, e ka ralo iBẹtisaida ya migha khẹ luẹ ukiẹkiẹ obinokpọle. Ighọ ọ gueyẹ oni ukpokpomhi ebubu ẹgbọ e ke je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Abi ọ rọ tsẹ wẹ okhila se nya, ọ nga ukhomhi ute ya sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ogbọmhi ò mu ekẹ, oni ọkọ-okẹ oniẹmhi o kia ramhi iteva oni okẹ, o ke kpe iJesu lọlighuo tsẹ le shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ọ́ mẹ́ khi akpekpeli óó nasẹ eniyẹ odukhokho eyọli. O ramhi itsotso ogbiẹ, iteteva elemhi agogo esẹ ali agogo esesa, ọ̀ọ́ kia ukhomhi oni okẹ lẹ deba wẹ. Ọ́ she kia ya dọsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ama abi e mẹ iJesu khi ọ́ọ́ kia ukhomhi amẹ, e dabi khi ayẹmhẹ olimhi lọ, e tsẹsẹ leghe. ");
INSERT INTO atgNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Itobọ khi eri wẹwẹ nya e yila abi e rọ mẹ ọli. Aghọaghọ ọ nu wẹ ngme, ọọ wẹ, “A mhọli udu! Mhẹmhẹ lọ! A khi ke na ulishi.” ");
INSERT INTO atgNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ọ lo elemhi ọkọ-okẹ oniẹmhi deba wẹ, oni akpekpeli o pfọmhẹ. O ri abọ sha eni eniyẹ odukhokho, ");
INSERT INTO atgNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","itobọ khi ẹa kie dobẹ lẹsẹ udi ingme eminale ni ọ kpẹ rọ na ẹgbọ agbẹlẹ ishe le; a toto wẹ udu. ");
INSERT INTO atgNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Abi e rọ da oni okẹ se, e lasele shi iGẹnẹsarẹti, e mu oni ọkọ-okẹ oniẹmhi zu aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Abi e lẹsẹ rọte ọkọ-okẹ oniẹmhi tiemhie, ẹgbọ e she lẹsẹ khi iJesu lọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ighọ eni ẹgbọ e nyanya kia gasẹ oni ekẹ nya, ashiashini e da suọ khi ọ da la ne, e tsua eni ẹẹ ghua shi iya bhale aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Obiobini iJesu ọ da je ne, o ke khi ẹoli ni e gbẹdi, o ke khi enikeke o, ghe ifui ishemhi o, eri ee tsua eni ẹẹ ghua bhale agbagbajighana atuoki. E lema iJesu ọ lẹsẹ zẹ ni eni ẹẹ ghua e ri obọ ti ọ esọ awulu ni ọ rọ sọ tsẹ. Eni e da ri obọ ti ọli nya e ze. ");
INSERT INTO atgNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","IFarisi ali esẹsẹ Ishi eyi iMosisi eghuo ni e rọte iJerusalẹmu bhale, e le gasẹ iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","E mẹ khi eniyẹ odukhokho eyọli eghuo e ri abọ ni ẹa pfuasẹ ni aa kpe-a a le eminale. Emini a ri ona ngme khi ẹa kpe abọ-a abi ẹgbọ iFarisi ẹẹ a ke li. ");
INSERT INTO atgNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Irari khi iFarisi ali ẹgbọ iJu eni e kpọle nya ẹa ya le eminale ini ẹa li kpe abọ-a. Abi ititawẹ e sẹsẹ wẹ na, ni e rọ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ini e rọte oki jele khi ẹa li kpe egbe a, ẹa ya le eminale. E gbo mhọli ighuighuẹ ebubu elese ni e gbolo ẹ ghuẹ, Ighuighuẹ abi a liẹ kpe iko, ekhe, itasa ali igege-a. ");
INSERT INTO atgNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Irarighọ, eni iFarisi ali esẹsẹ Ishi eyi iMosisi e mhila iJesu, “Elọ o zẹ khi eniyẹ odukhokho eyẹ ẹa ri ishi ni itita awa e rọ shi ekẹ gbe akanya, ni e rọ ri abọ eni ẹa pfuasẹ ẹ le eminale?” ");
INSERT INTO atgNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","IJesu ọ́ọ́ wẹ, “Igẹsikia Azaya ọ ngme abi ọ rọ ngme ungmemhi oyi Ẹshinẹgba ni o gọ lu ẹẹ ni a di egbe ẹ. Oni a kẹkẹ shi ekẹ khi, “ ‘Ungmemhi unu ẹgbọ ena e rọ ri ekpẹ ẹ na mhẹ, ama udu oyẹwẹ o nuata shi mhẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ugamhi afuẹ ẹẹ ga mhẹ, ushi eni ẹgbọ e rọ shi ekẹ, ẹẹ sẹsẹ ẹgbọ.’ ");
INSERT INTO atgNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","A she pfi ishi eyi Ẹshinẹgba shi ekẹ, a ri osẹsẹ eyi ẹgbọ ẹ gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ọ gbolo ẹ wẹ, “A ga lẹsẹ odẹ ni a te ri ishi eyi Ẹshinẹgba shi ukhokho obọ, ini a ba mẹ asha ri osẹsẹ eyẹ ẹ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Itobọ khi iMosisi ọọ liẹ, ‘Mu ekpẹ na itẹ ali inyẹ.’ Ọ gbolo ẹ, ‘Ọnini ọ da ku itsẹ ni itali okekhi inyọli ne, a gbe ọlia.’ ");
INSERT INTO atgNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ama ẹẹ a sẹsẹ ẹgbọ khi ini ọgbọ ọ gueyẹ itali okekhi inyọli, khi emini lọli kha kpẹ rọ kpaghiẹ itali ali inyọli obọ khi Ikobani o ke khi, khi ọa mhuẹ abi o ngme. Khi ushi ọa mu ọli ini ọa ke ririẹ ri emhikhọghuo na itali ali inyọ li. (Emini a rọ somhi Ẹshinẹgba opfa se, áá lui Ikobani). ");
INSERT INTO atgNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Eri a ri osẹsẹ ona a shishi ungmemhi oyi Ẹshinẹgba ekẹ a. A gbo mhọli emhi elese eghọghọ ebubu ni a gbolo ẹ riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","IJesu ọ gbo lu eni ebubu ẹgbọ gbili, ọ́ọ́ wẹ, “A ku esọ a shi mhẹ ọ, ni ona o lo ẹ esọ. ");
INSERT INTO atgNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Emhikhọghuo ọa la ọ ni ọgbọ le, ni o ri ọgbọ khi ọna umha pfuasẹ. Sẹ ni emini o rọte ọgbọ ekelemhi lasele, o ri ọgbọ ọ khi oni ọa pfuasẹ odalo oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ọni ọ mhọli esọ, ọ rọ suọ. ");
INSERT INTO atgNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Abi iJesu ọ rọ pfi eni ebubu ẹgbọ shi aghọ ni ọ rọ ya lo owa se, eniyẹ odukhokho eyọli e bhale deba li, e mhila li emini oni ungmemhi o ngme. ");
INSERT INTO atgNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ọ mhila wẹ, “Aa kie lẹsẹ udi emini mhia ngme? Ọa kie lo ẹ esọ khi emhikhọghuo ni o rọte odato lo ọgbọ elemhi khi ọa ya ri ọli khi ọni ọa pfuasẹ odalo oyi Ẹshinẹgba? ");
INSERT INTO atgNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Irari khi oni emhi ọa ya je ọli udu, ama ekẹ elemhi ọọ tiemhi, o gbo rọte idiegbe ya fiẹ lase.” Eri iJesu ọ ri ona guele khi eminale ni a le nya, khi e ti. ");
INSERT INTO atgNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","IJesu ọ gbo liẹ. “Emini o rọte ọgbọ ekelemhi udu lasele, o ri ọgbọ ọ khi ọna umha-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Itobọ khi rọte ekelemhi udu oyi ọgbọ, isamhi ebe e rọte ẹ lasele, enabi, itsẹbọ, ighiatọ, ọgbọ ugbeli, okia, ");
INSERT INTO atgNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","emhi ituegbe, ọbe imumu, ikpamhika, efiala, ubọgbọ, iyese-egbe eva a, umha-mhọli ekpẹ, iditsẹa. ");
INSERT INTO atgNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ekelemhi udu eni ingeli ena nya e rọte ẹ lasele ni e ri ọgbọ ọ khi ọna umha-pfuasẹ odalo oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ighọ iJesu ọ rọte aghọ vu, ọ je ukiẹkiẹ ekẹ iTai. Ọ lo owa oghuo, ọa nono ni ọgbọkhọghuo ọ lẹsẹ khi lọli la akaghọ. Ama ọa dobẹ ri egbe ọli sheli. ");
INSERT INTO atgNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Abi ọkpotso ọghuo ni ayẹmhẹ ebe o la omi ọli ọni ọmueshi egbe, ọ rọ suọ eko iJesu, ọ nyanya bhale ya de wugha li odalo. ");
INSERT INTO atgNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ọngi iJẹta ọni ọkpotso ọ khi, a bia li shi ekẹ iFonisha ni o la iSiria. Ọ lema iJesu ọ khu oni ayẹmhẹ ebe omi ọli egbe a. ");
INSERT INTO atgNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","IJesu ọ́ọ́ li, “Zẹ ni eniyẹ e kpẹ le eminale ne, ọa ti ni eminale ni a kha rọ na eniyẹ le, ni a pfi ọli ghi ewa.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ọni ọkpotso ọ́ọ́, “Guẹguẹguẹ Ọnọmhuẹ! Ama ewa e kiele la ifui itebu ẹ sanọ eminale ni eniyẹ kẹsẹ le le.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","IJesu ọọ ọli, “Itobọ oni ungmemhi ni u rọ sọ mhẹ ọ ena, ke je, u ya bhale ya ẹ khi oni ayẹmhẹ ebe, o she rọte omi ẹ egbe ya lase.” ");
INSERT INTO atgNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ighọ, ọli je apfẹ, ọ ya ẹ khi omi ọli o yẹshi ukpho khi oni ayẹmhẹ ebe o she rọte ọli egbe vu. ");
INSERT INTO atgNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ighọ iJesu ọ rọte ukiẹkiẹ obini iTai vu, ọ rọte iSidọni ya tiemhi okẹ iGalili, ọ je ekẹ iDikapolisi ");
INSERT INTO atgNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oobọ ẹgbọ eghuo e la tsua ọmọse oghuo ni ọ khi ọlesọ, ni ọ gbo khi ungmenu, bhale ghi iJesu. E lema li ọ kpẹkpẹ ọ lẹsẹ ri obọ nga li egbe. ");
INSERT INTO atgNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ighọ iJesu ọ rue lọlighuo fiẹ iteva oyi eni ebubu ẹgbọ, ọ ri imiesabọ shi ọni ọmọse esọ, ọ to etẹ, ọ ri obọ ti ọni ọmọse ẹlẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ighọ iJesu ọ bino idane, ọ tu ekperumhẹ-a, ọ́ọ́ ọni ọmọse “Efata!” Emini a ri ona ngme khi, “Khueghie-a!” ");
INSERT INTO atgNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Utoghuo kpe esọ eyi ọni ọmọse e khueghie a, ẹlẹmhi oyọli o taghiẹ-a, ọ ngme lasele gboo. ");
INSERT INTO atgNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ighọ iJesu ọ tse agua yẹ wẹ e khi gueyẹ ọgbọkhọghuo. Ama abi ọ dobẹ tse agua yẹ wẹ kpa, ighọ e dobẹ ngme oni ingme. ");
INSERT INTO atgNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","O ri abọ sha ẹgbọ eni e suọ nya. E liẹ, “Ọ ma guẹ riẹlẹ emhikpa,” e gbo liẹ, “Ọ ri eni e le esọ ọ suọ esọ, ọ khueghie ingmenu unu a, ẹẹ ngme.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ọa rọte aghọ tẹsẹ ni ebubu ẹgbọ elese e rọ legba. Abi eni ẹgbọ ẹa rọ mẹ emhi le, iJesu ọ lu eniyẹ odukhokho eyọli, ọ́ọ́ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Elemhi ẹgbọ ena ẹẹ ala mhẹ, ò she gba ẹlẹ esẹ ni e te nu mhẹ la ana ni ẹa te mẹ emhikhọghuo le. ");
INSERT INTO atgNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ini mhiẹ e ri okiamhi ke je apfẹ mena, ubi o ya rue wẹ shi odẹ, itobọ khi eghuo ọ, e rọte odonuẹ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eniyẹ odukhokho eyọli e mhila li, “Obo u sa khi a te ya mẹ eminale ni e bu ifu ọdagbe ona, ni e ya khuese ẹgbọ ena nya?” ");
INSERT INTO atgNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","IJesu ọ mhila wẹ, “Ibulẹdi ingmẹ a mhọli?” Ẹ ọli “Ishilua.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ọ gueyẹ eni ebubu ẹgbọ e shitọ ekẹ. Ighọ ọ rue eni ibulẹdi ishilua eghọ, ọ kphẹmhi na Ẹshinẹgba, ọ khi wẹ-a, ọ rue wẹ na eniyẹ odukhokho eyọli e ke kemhi wẹ na eni ẹgbọ. Ighọ eniyẹ odukhokho eyọli e li kemhi na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","E gbo mhọli ikuku imi ifẹlẹ shi aghọ. Ọ gbo kphẹmhi na Ẹshinẹgba shi ọ. Ọ rẹwẹ na eniyẹ odukhokho eyọli e gbo li kemhi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eni ẹgbọ e le, e khue. E le se, eni eniyẹ odukhokho e sanọ iku wẹ ni e le kpọle vọ ighughu ishilua. ");
INSERT INTO atgNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ẹgbọ agbẹlẹ asha ene e khi. IJesu ọọ eni ẹgbọ e ke je. ");
INSERT INTO atgNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lọli ali eniyẹ odukhokho eyọli e lo ọkọ-okẹ oniẹmhi e je ukiẹkiẹ obini iDalamanuta. ");
INSERT INTO atgNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ẹgbọ iFarisi e bhale, e mhila iJesu ogbọ ni e rọ mu ọli fẹ. Ẹẹ ọli ọ ri irọkhasẹ ni o rọte iloghie bhale khasẹ ẹwẹ ni wẹwẹ e lẹsẹ khi Ẹshinẹgba ọ ghie ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","IJesu ọ tu ekperumhẹ-a, ọ́ọ́, “Elọ o zẹ ni ẹẹ ẹgbọ a rọ́ mhila irọkhasẹ ọnyaloa? Abi o li mhi li gue ọli ẹ yẹ ẹ khi, aa ya mẹ irọkhasẹ ọnyaloa okhọghuo.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ighọ ọ pfi wẹ shi aghọ vu, ọ nyenẹ egbe ukhokho gbo ya lo ọkọ-okẹ oniẹmhi, ọ da je ukiẹkiẹ obinuzeva. ");
INSERT INTO atgNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Eniyẹ odukhokho eyọli ẹa sato tsua ibulẹdi ni e bu, sẹ ni uruli oghuo ni e mhuẹ shi oni ọkọ-okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","IJesu ọ tse agua yẹ wẹ, ọ́ọ́ wẹ, “A mhuẹ ẹgbhẹ shi ifuma eyi iFarisi ali Erọdu.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eniyẹ odukhokho eyọli e nu egbewẹ ngme, e liẹ, “Itobọ khi awa a mhuẹ ibulẹdi ọ rọ ngme ona.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","IJesu ọ lẹsẹ emini e ngme. Ọ mhila wẹ, “Elọ o zẹ ni a rọ gue ẹzọ khi aa mhọli ibulẹdi? Eri aa ya mẹ ekẹ abi khi eri ọa kie lo ẹ esọ? Eri udu oyẹẹ o na khukhu? ");
INSERT INTO atgNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A mhọli alo, aa rẹwẹ a mẹ ekẹ? A gbo mhuẹ esọ aa rẹwẹ ẹ suọ? Aa sato? ");
INSERT INTO atgNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Abi mhi rọ kholo ibulẹdi ishe-a na ẹgbọ agbẹlẹ asha ishe, ighughu ingmẹ a sanọ iku wẹ ekẹ vọ?” Ẹẹ ọli, “Igbẹva!” ");
INSERT INTO atgNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Abi mhi rọ gbo kemhi ibulẹdi ishilua na ẹgbọ agbẹlẹ asha ene, ighughu ingmẹ a sanọ iku wẹ vọ?” Ẹ ọli “Ishilua.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ọọ, “Eri emini mhia ngme ọa kie lo ẹ esọ?” ");
INSERT INTO atgNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E bhale iBẹtisaida. Ẹgbọ eghuo e tsua ọmọse ọzalo bhale ghi iJesu, Ẹ ọli ọ kpẹkpẹ ọ ri obọ ti ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ighọ iJesu ọ mu ọni ọmọse ọzalo obọ-obọ ya fiẹ ifui oni apfẹ. Ọ̀ to etẹ shi obọ rọ shishi ọli alo-a. IJesu ọ mhila li ini ọ mẹ emhikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ọni ọmọse ọ bino idane, ọọ “Mhia mẹ ẹgbọ khi e li abi ẹẹra a kia gasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ighọ iJesu ọ gbo ri abọ shi ọni ọmọse alo. Alo eyọli e tigbe khueghie-a, ọ mẹ ekẹ gboo. ");
INSERT INTO atgNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","IJesu ọọ ke je, ọ ọli, “Khi gbo je elemhi ifui ẹoli.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ighọ iJesu ali eniyẹ odukhokho eyọli e vu je ikuku ẹoli ni e la gasẹ iSizeria iFilipi. Abi e li lẹ, ọ mhila wẹ, “Ọghuo ẹgbọ e famhi ẹ liẹ khi mhi khi?” ");
INSERT INTO atgNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ẹ ọli, “Eri eghuo ẹ khi iJọni ni ọọ batazi ẹgbọ u khi; eghuo ẹ khi Elaja u khi; elese ẹ khi ọtuọghuo emekẹguele na ẹlẹ u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ọ ke mhila wẹ, “Ama, ọghuo ẹẹ oyẹẹ a liẹ khi mhi khi?” IPita ọ sọ li ọ, ọọ li, “Yẹyẹ u khi iKirisiti ni ọ khi Ọmiepfuese?” ");
INSERT INTO atgNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","IJesu ọ tse agua yẹ wẹ e khi gueyẹ ọgbọkhọghuo ọni lọli khi. ");
INSERT INTO atgNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ighọ ọ sẹsẹ eniyẹ odukhokho eyọli khi Omi Ọgbọ ọ mema ya mẹ osoli egbegbọ. Eni egbhali, ali ighie eyi ekpodalo-ugamhi ali eni ẹ sẹsẹ ishi, e ya kie ọli. A ya gbe lọli-a, ama ẹlẹ onuzi-esẹ, ọ gbo ya guale. ");
INSERT INTO atgNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ọ ngme ona lasele gboo. Ighọ iPita ọ lu ọli ochi, ọọ li ọ khi ke ngme ungmemhi onana ghue. ");
INSERT INTO atgNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama abi iJesu ọ rọ nyenẹ alo ukhokho bino eniyẹ odukhokho eyọli, ọ dese iPita. Ọọ li, “Vu mhẹ odalo le yẹyẹ Ọkphaghiẹ. Wa mhọli ingme Ẹshinẹgba shi udu, ama emhi agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ighọ ọ lu eni ebubu ẹgbọ ali eniyẹ odukhokho eyọli, ọọ wẹ, “Ini ọgbọkhọghuo ọọ nono ni lọli bhale deba mhẹ, ọ mema ya kie egbọli, ọ rue apfida oyọli, ọọ deba mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Itobọ khi ọnini ọ da dua ni lọli tsumhi agbọ oyọli ne, o ya de ọli obọ a, ama ọni ọ da ri irari oyẹmhẹ ali irari oyi usomhi onete oyi Ẹshinẹgba rue agbọ oyọli pfia, ọ ya tsumhi ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Eleli onoghuo ọgbọ ọ ya mẹ ini ọ mhọli agbọ nya khi ayẹmhẹ oyọli o li opfu-a? ");
INSERT INTO atgNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Elọ ọgbọ ọ ya rọ ọọghiẹ ayẹmhẹ oyọli? ");
INSERT INTO atgNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ini omama oyẹmhẹ ali omama oyi ingme oyẹmhẹ o da mu ọgbọkhọghuo elemhi agbọ ichimhi ali agbọ ọkhọlọ ona ne, omama oyi ọnọgbọ o ya li mu Omi Ọgbọ ẹlẹghọ ini ọ bhale elemhi ufumhi oyi Itali ali oyi igẹni ni e pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ọ gbolo ẹ wẹ, “Mhi gue igẹsikia yẹ ẹ khi, ẹgbọ eghuo e migha ana, ni ẹa ya ghu ne, ni e rọ mẹ khi Eghiele oyi Ẹshinẹgba o bhale, elemhi ekpabọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Abi ẹlẹ-esesa e rọ dọsẹ, iJesu ọ rue iPita, ali iJemhisi ali iJọni, ya nga ute oniẹmhi ni o yagha, asha ni wẹwẹghuo kpe e la. Ighọ e mẹ khi iJesu ọ mu melaa. ");
INSERT INTO atgNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Itsua ni ọ rọ sọ, e pfuasẹ-a, e gẹ pẹ̀pẹ̀pẹ̀. E todẹ pfuasẹ dọsẹ utsakolo, e dọsẹ abi ọgbọkhọghuo ọa tigbe dobẹ ya li pfuẹ wẹ-a pfuasẹ ramhi agbọ ona. ");
INSERT INTO atgNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ighọ eni eniyẹ odukhokho aasẹ eyọli e mẹ khi Elaja ali iMosisi e lasele nu iJesu ghẹta. ");
INSERT INTO atgNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","IPita ọọ iJesu, “Ọsẹsẹ, o guẹ ti khi awa la akana. Zobẹ ni anye tọ ikholo esẹ shi ana. Ọghuo ọ o kha khi oyẹ, oghuo o khi oyi iMosisi, onokpọle o khi oyi Elaja.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ọa ke lẹsẹ emini ọ ke ya ngme, itobọ khi eri lọli ali enekpọle e yila dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ighọ otughunu o lasele ya guese wẹ-a, Ẹshinẹgba ọ rọte elemhi oni otughunu ngme, ọ́ọ́, “Omimhẹ ni Ọmọse na, ni mhi nono ingme oyọli egbegbọ. A ke suọ esọ na li.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Utoghuokpe khi e ke pfi alo bino, ẹa ke mẹ ọgbọkhọghuo sẹ ni iJesu lọlighuo. ");
INSERT INTO atgNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Abi e li rọte oni ukhomhi ute e tiemhi le, iJesu ọ gueyẹ wẹ e khi gueyẹ ọgbọkhọghuo emini e mẹ ini Omi Ọgbọ ọa li rọte eghuli guale. ");
INSERT INTO atgNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E ri oni ungmemhi gbe akanya, ama e nu egbewẹ ghẹta emini irọte eghuli guale o ngme. ");
INSERT INTO atgNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ighọ e mhila iJesu, “Elọ o zẹ ni eni ẹ sẹsẹ e rọ liẹ khi Elaja ọ kpẹ ya bhale?” ");
INSERT INTO atgNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","IJesu ọọ, “Egbegbọ lọ khi Elaja ọ kpẹ ya bhale, ọ ya bhale ya mu egbe emhi nya shi ekẹ. Elọ o mema zẹ ni Ebe-no-pfuasẹ o rọọ khi Omi Ọgbọ ọ mema mẹ osue egbegbọ, a gbo kie ọli?” ");
INSERT INTO atgNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ama a ghe i, Elaja ọ she bhale, e riẹlẹ emini o ghọle wẹ deba li ẹzẹzẹ abi a li kẹkẹ ingme oyọli shi Ebe-no-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Abi e ke rọ ya kugbe eniyẹ odukhokho ni e kpọle ọ, e mẹ khi ebubu ẹgbọ o le gasẹ wẹ, esẹsẹ Ishi eyi iMosisi e nu wẹ la akaghọ khakọ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Abi eni ẹgbọ e lẹsẹ mẹ iJesu te, abọ e sha wẹ egbegbọ. E na ya tsẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ọ mhila wẹ, “Elọ o khi ni a nu wẹ khakọ ọ shi?” ");
INSERT INTO atgNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ọmọse ọghuo ọ rọte elemhi eni ebubu ẹgbọ ya rue unu, ọ́ọ́, “Ọsẹsẹ, omimhẹ ọni ọmọse mhi rọ bhale ghi ẹ, ayẹmhẹ obe ọ nasẹ ọli, ni ọa ke zẹ ọli ẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ini oni ughuamhi o da tsua rughu ọli ne, eri o pfi ọli ẹ gbe, ọọ chi ofulu unu, ọọ le akọ unu, ọ zese a. Mhi gueyẹ eniyẹ odukhokho eyẹ e khu ọli oni ayẹmhẹ egbe-a, ama ẹa dobẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","IJesu ọọ, “Ẹẹ ẹgbọ ni ẹa mhọli irudunga ena, ẹlẹ-ingmẹ mhi ke mhọli rọ nu ẹ ya la akana, ẹlẹ-ingmẹ mhi bẹshi ya la onana ramhi, Mu ọni ọmọ ghi mhẹ!” ");
INSERT INTO atgNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ighọ e mu ọni ọmọ bhale. Abi oni ayẹmhẹ o rọ mẹ iJesu tee, o de rughu ọni ọmọ, o pfi ọni ọmọ gbe, ọọ kpi abọ ali awẹ-a, oo wu ọli ekẹ, ọọ chi ofulu unu. ");
INSERT INTO atgNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","IJesu ọ mhila ita ọni ọmọ, “Aẹlẹ ọ te lina?” Ọọ, “Abi ọ te khi ọmọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“O she lina mu ọli pfi lo elemhi erali ali elemhi okẹ itingmingmẹ abi o kha gbe ọli-a. Ini u mhọli emini u dobẹ ya riẹlẹ, kpẹkpẹ lẹ elemhi anye ni u kpaghiẹ anye obọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","IJesu ọ́ọ́, “Eri u wẹ ini mhi dobẹ? Emhikpa ọọ tsẹ na ọni ọ da mhọli irudunga.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aghọaghọ ita ọni ọmọ ọ nyanya liẹ, “Mhi miesuọ ukukuọ, kpaghiẹ mhẹ obọ ni mhi gbo miesuọ shi ọ egbegbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Abi iJesu ọ rọ mẹ khi eni ebubu ẹgbọ e na bhale ashini oni ingme o de shi, ọ tsẹsẹ ku oni ayẹmhẹ obe. “Yẹyẹ ayẹmhẹ ungmenu ali ilesọ, rọte ọli egbe ya lasele, khi gbo nyenẹ egbe bhale ọ ghue.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Oni ayẹmhẹ o tsẹsẹ, ri itoto nighise ọni ọmọ, ọ rọte ọli egbe ya fiẹ. Ọni ọmọ ọ ke li abi ọni ghua. Ẹgbọ e liẹ, “Ọ she ghua.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama, iJesu ọ mu ọni ọmọ obọ vule migha. Ọ migha. ");
INSERT INTO atgNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Abi iJesu ọ rọ lo elemhi owa se, eniyẹ odukhokho eyọli e bẹna mhila li, “Elọ o zẹ ni anye aa rọ dobẹ khu ọli oni ayẹmhẹ egbe-a?” ");
INSERT INTO atgNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","IJesu ọ sọ wẹ ọ, ọọ wẹ, “Iromhi isọsọ ali azumhi tsẹ o dobẹ a khu onana.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","IJesu ali eniyẹ odukhokho eyọli e rọte aghọ vu, e rọte iGalili dọsẹ, ọa nono ni ọgbọkhọghuo ọ lẹsẹ ashini wẹwẹ e la, ");
INSERT INTO atgNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Itobọ khi ọ sẹsẹ eniyẹ odukhokho eyọli, ọọ yẹ, “A ya ri Omi Ọgbọ na ẹgbọ de. E gbe ọli-a. Ẹlẹ nuzi-esẹ ọ gbo guale.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama emini ọ ngme ọa lo wẹ esọ, ulishi o mu wẹ abi e li ya mhila li emini ọ rọli ngme. ");
INSERT INTO atgNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","E bhale ẹoli iKapanọmu. Abi ọ rọ la elemhi owa, ọ mhila wẹ, “Elọ a khakọ shi amo abi a rọ la odẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ama e tsaghiẹ-a, itobọ khi ọni ọ kpeda nya elemhi wẹ e la odẹ khakọ shi. ");
INSERT INTO atgNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","IJesu ọ shitọ, ọ lu eniyẹ odukhokho ogbava eyọli, ọ́ọ́ wẹ, “Ini ọgbọkhọghuo ọọ nono ni lọli khi ọni ododẹ, ọ kpe ya ri egbọli khi ọni ọ kpukhokho nya, ali ọni ọ ga ẹgbọ nya.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ọ mu ukuku ọmọ vule migha wẹ iteva. Ọ mu ọli shi abọ, ọ́ọ́ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ọnini ọ ri itobọ oyẹmhẹ mie ọtuọghuo ikuku eniyẹ enana ne, mhẹmhẹ ọ mie. Ọnini ọ da mie mhẹ ne, ọni ọ ghie mhẹ ọ mie, ọa khi mhẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","IJọni ọ́ọ́, “Ọsẹsẹ, anye mẹ ọmọse ọghuo ni ọ́ ri eva oyẹ khu ayẹmhẹ ebe kua. Ama anye gueyẹ ọli ọ khi gbo lighọ, itobọ khi ọa khi ọghuo elemhi awa.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","IJesu ọ́ wẹ, “A khi ke khu ọli ọ, itobọ khi ọni ọ ri eva oyẹmhẹ gbe akanya ọnyaloa, ọa tigbe ẹ vule ke ngme onobe oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Itobọ khi ọni ọa khi obe awa, ọyawa ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Abi o li mhi li gue ọli ẹ yẹ ẹ khi, ọnini ọ da diẹ uko amẹ na ẹ da irari eva oyẹmhẹ ne, ali irari khi ọnayi iKirisiti a khi, ọ ya mẹ eleli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ini ọgbọkhọghuo ọ yẹsẹ ikuku eniyẹ enana ni e mie mhẹ suọ lamhẹ, o bie tinẹ ni a gẹ ẹchẹ iko oniẹmhi shi ọgbọ ọghọghọ uruli tsua pfilo elemhi okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ini obọ oyẹ o rẹ ya lamhẹ, khi ọli pfia. O ti ẹ egbe nẹ ini u waa mhọli obọ ya lo iloghie na agbọagbọ, ni u rọ tsua abọ eve-eva eyẹ ya lo ilimhi iriẹriẹ, ashini erali ẹa tigbe ẹ pfọ-a ghue. ");
INSERT INTO atgNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Akaghọ ikpatsọ ni ẹ le wẹ ni ẹa tigbe ẹ ghu e la, ali ashini erali ni ẹ tosẹ wẹ-a, ẹa tigbe ẹ pfu ghue. ");
INSERT INTO atgNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ini owẹ oyẹ o rẹ ya lamhẹ, khi ọli pfia, o ti ẹ egbe nẹ ini u waa mhọli awẹ rọ lo iloghie na agbọagbọ ni u rọ mhọli awẹ eve-eva, ni u rọ ya lo ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Akaghọ ikpatsọ ni ẹ le wẹ ni ẹa tigbe ẹ ghu e la, ali ashini erali ni ẹ tosẹ wẹ-a, ẹa tigbe ẹ pfu ghue. ");
INSERT INTO atgNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ini ukpẹloe oyẹ o rẹ ẹ lamhẹ, vuọnyọ li pfia, o ti ẹ egbe nẹ ini u ri ukpẹloe oghuo lo Eghiele oyi Ẹshinẹgba, ocho ni u rọ ya mhọli ikpamhi alo eva, a pfi ẹ ya lo ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Akaghọ, “ ‘Ikpatsọ ni ẹ le wẹ ni ẹa tigbe ẹ ghu e la, ali ashini erali ni ẹ tosẹ wẹ-a, ẹa tigbe ẹ pfu ghue.’ ");
INSERT INTO atgNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Erali a rọ nye ọgbọgbọ-a, a rọli khi ọni ọ pfuasẹ abi a li ri ugbheli ẹ ri iluasobo khi pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ugbheli o ma ti, ama ini oviọlọ oyọli o kala, sẹ o ke li zẹ gbolo rọ ya mele ugbheli-a? “A zẹ ni a mhọli ugbheli shi agbọ oyẹ ẹ. A nu egbe ke ngeli angeli opfọmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","IJesu ọ rọte aghọ vu je ekẹ iJudia, ini a da iJọdani. Ighọ ẹgbọ ni e bu e gbo vẹ ngale deba li, ọ sẹsẹ wẹ abi ọ kpẹ̀ li. ");
INSERT INTO atgNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ẹgbọ iFarisi eghuo e bhale ya mu ọli fẹ, e mhila li, “Ushi oyawa o lama, ọmọse ọ khu ughuẹ ọyọli?” ");
INSERT INTO atgNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ọọ, “Elọ iMosisi ọ gueyẹ ẹ a ke li?” ");
INSERT INTO atgNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","E kẹ, “Eri iMosisi ọ lama ọmọse ọ kẹkẹ ebe ni a rọ pfa ughuẹ-a mhọli ughuẹ ọli obọ, ọ khu ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","IJesu ọọ wẹ, “Itobọ khi udu oyẹẹ ọọ gbe, iMosisi ọ rọ lighọ kẹkẹ oni ushi na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","‘Ama ọmọse ali ọkpotso, Ẹshinẹgba ọ rọte igbaekẹle agbọ ma wẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Onana o zẹ ni ọmọse ọ rọ ọ pfi itali ali inyọli shi ekẹ, ọ ya toma ughuẹ ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wẹwẹ aava e mele idiegbe ọghuo a.’ Ẹghẹghẹ aghọ ẹa ke khi etuava, ama ọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Irarighọ, emini Ẹshinẹgba ọ da toma ne, ọgbọkhọghuo ọ khi vasẹ wẹ a.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Abi e rọ gbo la elemhi owa, eniyẹ odukhokho eyi iJesu e mhila li ogbọ ona. ");
INSERT INTO atgNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","IJesu ọọ wẹ, “Ọnini ọ da khu ughuẹ ọli ni ọ ya rue ọkpotso ọlese ne, eri ọ kia okia shi oni ughuẹ ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ini ọni ọkpotso ọ lase ayi ọdọli le khi ọ ya ngeli na ọmọse ọlese, eri ọ kia okia.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ẹgbọ eghuo e mu eniyẹ bhale deba iJesu ni ọ ri obọ ti wẹ, ama eniyẹ odukhokho eyọli ee khu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Abi iJesu ọ rọ mẹ ghọ, o ri elemhi bi ọli. Ọ́ọ́ wẹ, “A zẹ ni ikuku eniyẹ e bhale deba mhẹ. A khi ke khu wẹ, itobọ khi enabi wẹwẹ e li mhọli obọ shi Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Zẹ mhẹ gue igẹsikia yẹ ẹ khi ọni ọa da rue Eghiele oyi Ẹshinẹgba abi eniyẹ enikeke ne, ọa tigbe ya lo iloghie.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ọ muno eniyẹ shi egbe, ọ ri obọ nga wẹ ukhomhi, ọ sọ iromhi na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Abi iJesu ọ ke rue okiali ekẹ khi ọ vu, ọmọse ọghuo ọ na bhale ya wugha li odalo, ọọ li, “Ọsẹsẹ nete! Elọ mhi ya riẹlẹ ni mhi rọ ya mhuẹ agbọ na agbọagbọ?” ");
INSERT INTO atgNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","IJesu ọ li, “Elọ e zẹ ni u rọ ọ lu mhẹ ọnọti. Ọgbọkhọghuo ọa laọ ni ọ ti, sẹ ni Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ni mhi rọ sọ ẹ ogbọ ni u mhila mhẹ, u lẹsẹ ushi ni Ẹshinẹgba ọ rọ shi ekẹ. Ni ọ lẹ, ‘A khi gbe ugbeli, a khi kia okia, a khi do ughiatọ, a khi pfi ọtsẹlẹ ẹgbhọli mu ọgbọ, a khi li ọgbọ le, mu ekpẹ na ita ẹ ali inyẹ ẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ọni ọzẹo ọọ, “Ọsẹsẹ, abi a te bia mhẹ mhi te ri ena nya a gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","IJesu ọ ri ẹloe inono bino ọli, ọọ li, “Emhi oghuo tsẹ o kpe ẹ le ni waa riẹlẹ ne. Je ya ri emini u mhọli nya dẹ ni u kemhi wẹ na eni ẹa mhọli emhi, ẹghẹghẹ aghọ ni u mhọli ẹpfue shi obini iloghie, u tigbe bhale ya deba mhẹ ke kia.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Abi ọni ọmọse ọ rọ suọ ona, alo eyọli e yese a, ọ ri iyeseudu-a ya vu, itobọ khi ọ mhọli ẹpfue eniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","IJesu ọ bino gasẹ kpa, ọọ eniyẹ odukhokho eyọli, “O ma mu ọgbọ ni ọ pfue unu ni ọ rọ lo Eghiele oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ingmemhi eyọli e ri abọ sha eniyẹ odukhokho eyọli. Ama iJesu ọ gbolo ẹ, “Eniyẹ eyẹmhẹ, o ma mu eni e ri egbe da ẹpfue oyẹwẹ unu ni e rọ lo Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni ọgbọ ni ọ pfue ọ rọ lo Eghiele oyi Ẹshinẹgba, o ya munu dọsẹ, ni ọgbọ ke dua ni lọli ri alakumi rọte esẹ asugẹ ya fiẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ona o ke ri abọ sha eniyẹ odukhokho eyọli nẹ, e rọ mhila egbe, “Ọghuo ọ dobẹ ya lo ọ shọ?” ");
INSERT INTO atgNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","IJesu ọ pfi ukpẹloe bino wẹ, ọ́ọ̀, “Ona ọa zẹ ọgbọ ya li ama emhikpa o zẹ Ẹshinẹgba a li.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","IPita ọ́ọ̀ iJesu, “Emhinya anye tsua kua bhale deba ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","IJesu ọ́ọ̀ wẹ, egbegbi-ingme mhi gue ẹ yẹ ẹ khi ọnini ọ da pfi apfẹ ọli shi ekẹ, ali inyọghuo ọli eni emọse ali eni ikpotso, ali ita ali inyọ, ni ọ pfi eniyẹ ali ishemhi, ghe ọwolọ shi ekẹ irari oyẹmhẹ ali usomhi onete oyi Ẹshinẹgba, ");
INSERT INTO atgNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a ya somhi ọli opfa. Elemhi agbọ ona, a ya khivọsẹ na li asha egbhuẹshe, ikhivọsẹ owa ali ikhivọsẹ inyọghuo, ali inyọ ali eniyẹ ali ishemhi, ali anasẹmhẹ. Ọ ya mhuẹ agbọ na agbọagbọ, elemhi agbọ ni o kẹ ẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama ẹgbọ eghuo ni e ralo, e ya kpẹ ukhokho. Eni e kpẹ ukhokho amo, e ya khi eni ododẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Abi iJesu ọ rọ tsua wẹ lẹ iJerusalẹmu, ni ọ rọ ralo na wẹ, eni ingme e pfuse ghagha a shi eniyẹ odukhokho eyi iJesu udu. Ulishi o mu ẹgbọ ni e deba wẹ. Ighọ iJesu ọ gbo li rue eniyẹ odukhokho ogbava eyọli ye ochi, ọ gueyẹ wẹ emini lọli ya mẹ ini wẹwẹ e ramhi iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ọọ, “IJerusalẹmu awa je ena, a ya la oobọ rue Omi ọgbọ na ighie eyi ekpodalo-ugamhi ali eni ẹ sẹsẹ ishi dẹ, a ri ọli na wẹ mu. E pfa ẹzọ igbe-a mu ọli, e ghi ọli abọ ghi ẹgbọ iJẹta. ");
INSERT INTO atgNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","E ya rọli ke li egia, e tono etẹ ku ọli, e gbe ọli itẹ, e tigbe gbe ọli-a. Ama ẹlẹ nuzi-esẹ, ọ ya rọte eghuli guale.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ighọ iJemhisi ali iJọni imi iZebedi e bhale deba iJesu, ẹ ọli, “Ọsẹsẹ, anye ẹ nono ni u riẹlẹ emini anye ya mhilẹ ena na anye.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","IJesu ọọ wẹ, “Elọ a nono ni mhi riẹlẹ na ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","E kẹ, anye ẹ nono, ini u da shitọ ukpẹkhomhi oyẹ obini Eghiele oniẹmhi oyẹ ne, ni u zẹ ni ọtuọghuo anye ọ kha shitọ ẹ ukiẹkiẹ obita, ọnọkpọle ọ shitọ ẹ obọgobọ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","IJesu ọọ wẹ, “Aa lẹsẹ emini aa mhila. Uko ni mhi rọte da, a dobẹ ya rọte ọ da, abi khi eri a dobẹ ya mie ibatizi onabi mhi mie?” ");
INSERT INTO atgNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","E kẹ, “Anye ya dobẹ.” IJesu ọọ wẹ, “A dobẹ ri uko ni mhi rọ da ya da, a gbo dobẹ mie ibatizi onabi mhi mie, ");
INSERT INTO atgNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ama mhia mhọli afu ni a rọ ri ọgbọ ọ shitọ mama mhẹ ukiẹkiẹ obita ali obọgobọ ukpẹkhomhi oghie obini iloghie. Ẹshinẹgba ọ ri asha eghọghọ ya na ẹgbọ ni ọ rẹ wẹ shi aghọ khẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Abi eniyẹ odukhokho etuogbe enekpọle e rọ suọ ingmemhi ena, e nu iJemhisi ali iJọni i wola shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ighọ iJesu ọ lu wẹ tigbili, ọọ wẹ, “A lẹsẹ khi eni ẹ lu egbewẹ ighie eyi ẹgbọ eni ẹa ya ga Ẹshinẹgba, khi eri ẹ li wẹ abi o ghọle wẹ, ighọ eni e kpeda omhẹsẹ e li ẹ mhẹsẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama, a khi li abi wẹwẹ. Ama ọnini ọ nono ni lọli khi ọniẹmhi elemhi ẹ, ọ khi ọni ọ ga ẹẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ọnini ọ nono ni lọli khi ọnododẹ, ọọ mema kpẹ ri egbọli khi oghumha ọyi ẹgbọ kpa. ");
INSERT INTO atgNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Itobọ khi Omi Ọgbọ ọa bhale ni a ke ga li, ama eri ọ bhale ya ga ali ni ọ gbo ri agbọ oyọli bhale ni a rọ luasẹ obo na ebubu ẹgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ighọ e bhale iJẹriko. Abi iJesu ali eniyẹ odukhokho eyọli ali ebubu ẹgbọ ni e deba li, e rọ rọte oni ẹoli vu, ọmọse ọghuo ni ọ tasẹ alo-a na lui iBatimeusi (omi iTimeusi a ri iBatimeusi ngme) ọ shitọ epfẹ odẹ mhila omhila. ");
INSERT INTO atgNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Abi ọ rọ suọ khi iJesu ọna iNazarẹti lọ, ọ́ọ́ tsẹsẹ leghe, ọọ liẹ, “IJesu omi iDefidi, kpẹkpẹ, lẹ elemhi mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ebubu ẹgbọ e tsẹsẹ ku ọli, ẹẹ ọli ọ zẹ ni a suọ esọ. Ama eena ọ mema lolo pfi okokokhuẹ lu ọli nẹ, “Omi iDefidi lẹ elemhi mhẹ!” ");
INSERT INTO atgNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","IJesu ọ migha, ọ́ọ́, “A lu ọli na mhẹ.” Ighọ e lu ọni ọtasalo-a, ẹ ọli, “Ke ghẹlẹ, vule, khi ọọ lu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ọ rue awulu nọ ọ sọ pfi a, ọ ti vule pia bhale deba iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","IJesu ọ mhila li, “Elọ wa nono ni mhi riẹlẹ nẹ?” Ọni ọmọse ni ọ tasẹ alo-a, ọ́ọ́, “Ọsẹsẹ, mhia nono ni mhi gbo ke mẹ ekẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","IJesu ọ́ọ́, “Ke lẹ, khi irudunga oyẹ o she rẹ ze.” Aghọaghọ, ọọ mẹ ekẹ, ọ deba iJesu rọte odẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Abi e rọ ti ramhi iJerusalẹmu ni e rọ bhale iBẹtifagi ali iBẹtani Udi Ute Olivu, iJesu ọ ghie etuava elemhi eniyẹ odukhokho eyọli, ");
INSERT INTO atgNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ọọ wẹ, “A je ẹoli ni o la odalo oobọ eghọ. A kha lẹsẹ lo oni ẹoli le, a ya mẹ omi akphẹrẹ ni a muzu, ni ọgbọkhọghuo ọa nga shitọ ghue. A taghiẹ ọli bhale ana. ");
INSERT INTO atgNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ini ọgbọkhọghuo ọ mhila ẹ, ‘Elọ o ze ni a rọ taghiẹ ọli? A gueyẹ ọli khi, Ọnọmhuẹ ọ́ọ́ nono ni lọli ri ọli riẹlẹ emhi, ali khi ọ gbo rọli bhale ya shi ekẹ lẹna.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ighọ ee bhale ya ẹ ọni ozele akphẹrẹ ni a muzu shi ifui apfẹ epfẹ odẹ. Abi e li taghiẹ ọli-a, ");
INSERT INTO atgNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ẹgbọ eghuo ni e migha akaghọ e mhila wẹ, “Elọ a la akaghọ a riẹlẹ ni a rọ taghiẹ ọni omi akphẹrẹ ọghọ-a?” ");
INSERT INTO atgNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","E sọ wẹ ọ abi iJesu ọ́ọ́ e li sọ wẹ ọ. Ighọ eni ẹgbọ e zẹ wẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Abi e rọ mu ọni ozele akphẹrẹ bhale ghi iJesu se, e banọ ide egbe-a pfino nga ọni ozele akphẹrẹ ukhokho. Ighọ, iJesu ọ nga li shitọ. ");
INSERT INTO atgNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ebubu ẹgbọ elese e li ba ide rọ ku odẹ, eghuo, e nyanọ eyamhi ku odẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ẹgbọ ni e ralo ali eni e deba li e gbe ukua, e tsẹsẹ, e liẹ, “Okuekhoogo! Oolo!” Ẹshinẹgba ọ ka khivọsẹ na ọni ọ ri eva oyi Ọnọmhuẹ bhale! ");
INSERT INTO atgNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ẹshinẹgba ọ ka khivọsẹ shi Eghiele oyi oghie iDefidi ita awa ni ọọ bhale.” “Ikuẹghiẹ o khi oyi Ẹshinẹgba!” ");
INSERT INTO atgNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Abi iJesu ọ rọ ramhi iJerusalẹmu, ọ dọsẹ ya lo elemhi Owa oyi Ẹshinẹgba. Ọ bino emhi nya gasẹ, ama aborọkhia khi obili o she bi dọsẹ, lọli ali eniyẹ odukhokho ogbava eyọli e je iBẹtani. ");
INSERT INTO atgNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ogbeakọlọ abi e li rọte ẹoli iBẹtani fiẹ, okiamhi oo gbe iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ighọ ọ̀ tapfia mẹ ọara ọkhua-eni ni o guẹ ta ebe. Ọ lẹ ya bino ini o she mọ udumhi. Abi ọ rọ ramhi aghọ ọa mẹ emhikhọghuo ọ, sẹ ni ebe, itobọ khi ọa ramhi ẹghẹghẹ ni ọkhua-eni e rọ mọ ne. ");
INSERT INTO atgNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ighọ ọọ oni ọkhua-eni, “Ọgbọkhọghuo ọa ke gbo rọte ẹ ukhomhi ya pfa udumhi ghue.” Eniyẹ odukhokho eyọli e suọ khi ọ ngme na. ");
INSERT INTO atgNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Abi e ke rọ ramhi iJerusalẹmu, iJesu ọ lo Owa oyi Ẹshinẹgba, ọ vẹsẹ eni e la akaghọ du oki kua. Ọ kpha okphẹ oyi eni e pfa ikpaghọ ali eni e ri inekhukhu dẹ kua. ");
INSERT INTO atgNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ọa zẹ ni ọgbọkhọghuo ọ tsua itsua-oki rọte elemhi apfẹ oni Owa oyi Ẹshinẹgba dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abi ọ́ ke rọ́ sẹsẹ ẹgbọ, ọ́ rọ́ liẹ, “A she kpẹ kẹkẹ ọli shi Ebe-no-pfuasẹ khi, “ ‘Owa iromhi oyi ishishi nya, a ya ke lu Owa oyẹmhẹ,’ Ama ẹẹ, a she rọli mele owa ighiatọ a.” ");
INSERT INTO atgNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Abi ighie eyi ekpodalo-ugamhi ali eni ẹ sẹsẹ ishi e rọ suọ ona, ee dua odẹ ni e te mẹ asha ya gbe iJesu a. Ama ulishi oyi iJesu óó mu wẹ, itobọ khi eri osẹsẹ oyọli o ri abọ sha ẹgbọ kpa. ");
INSERT INTO atgNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ogbọmhi o mu ekẹ, iJesu ali eniyẹ odukhokho eyọli e rọte oni ẹoli ya fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ẹluzogbe oogbeakọlọ khi e rọte oni odẹ dọsẹ, e mẹ khi oni ọara ọkhua-eni o khakha ya ramhi imhili. ");
INSERT INTO atgNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","IPita ọ sato, ọọ iJesu, “Ọsẹsẹ, bino khẹ! Ọara ọkhua-eni ni u pfi unu na o she khakha-a.” ");
INSERT INTO atgNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","IJesu ọ sọ li ọ, ọọ, “Mhọli irudunga na Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Egbegbi-ingme mhi gue ẹ yẹ ẹ khi ọnini ọ gueyẹ oni ute ona, ‘Rọ te akana lasele ya je elemhi okẹ oniẹmhi,’ ni ọa rọ da mhọli akhọkhọmhẹ shi udu shi emini ọ ngme ne, ni ọ rọ mhọli miesuọ khi emini lọli ngme o ya bhale ya tsẹ, oo ya lighọ na li. ");
INSERT INTO atgNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Irarighọ, emiemini u sọ iromhi mhila, miesuọ khi u she mhọli ọli, oyẹ o kẹ khi. ");
INSERT INTO atgNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","U kha da migha a lema, ni u rọ ri ingme oyi ọgbọ shi elemhi, nyanya rọ topfa li. Ini itẹ ni ọ la iloghie ọ ri olamhẹ eyẹ li topfa ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Ama ini u waa da rọ topfa ọgbọẹse ne, itẹ na iloghie ọa ya li ri olamhẹ eyẹ topfa ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ighọ ee gbo lo iJerusalẹmu le. Abi iJesu ọ li kia elemhi apfẹ Owa oyi Ẹshinẹgba gasẹ, ighie eyi ekpodalo-ugamhi ali eni ẹ sẹsẹ ishi ali egbhali e bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","E mhila li, “Ọghuo ọ ri afu nẹ ni u rọ riẹlẹ eni emhi enana nya, ọghuo ọ ri unu nẹ u ke riẹlẹ ena.” ");
INSERT INTO atgNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","IJesu ọ sọ wẹ ọ, Ọ́ọ́, “Mhi ya mhila ẹ ogbọ oghuo. A sọ mhẹ ọ, ni mhi tigbe gueyẹ ẹ ọni ọ ri afu na mhẹ mhi ke riẹlẹ emhi ena. ");
INSERT INTO atgNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ọghuo ọ fẹ ri itoto na iJọni ọ ke batazi ẹgbọ abi ẹgbọ?” ");
INSERT INTO atgNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ighọ, e ya ye egbe ochi, e nu egbe wẹ ngme ọli khi, “Awa khẹ ‘Rọte iloghie’ lọ, ọ ya mhila awa, ‘Elọ o zẹ ni aa rọ mie ọli suọ?’ ");
INSERT INTO atgNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama ini awa kẹ, ‘Obọ oyi ẹgbọ.’ ” Ulishi oyi ẹgbọ o mu wẹ, itobọ khi ọgbọkpa ọ lẹsẹ khi ọmekẹguele iJọni ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ighọ ẹẹ iJesu, “Anye ẹa lẹsẹ.” Ighọ iJesu ọọ wẹ, “Mhi aa ya li gueyẹ ẹ ọni ọ ri afu na mhẹ mhi rọ ke riẹlẹ eni emhi ena.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ighọ iJesu ọ ke ri okhẹ irọkhọkhọ sẹsẹ wẹ. Ọọ, “Ọmọse ọghuo ọ ke ya gua ogba ẹẹra ipfonu. Ọ ma ugbe gasẹ oni ogba. Ọ tọ esẹ shi ọ, ni a mino amẹ ikpamhi eni ẹẹra kulo. Ọ gbo tọ owa ni o yagha ni a la khẹ-ekhẹ shi ọ. Ighọ ọ ya ri oni ogba nga eghiale eghuo obọ e nu lọli ri ukpẹloe ke khu. Ọ vu asha obini odonuẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ẹghẹghẹ ikhiẹsẹ o ramhi, ọni ọmọse ọ ghie oghumha ọyọli ghi eni ọ ri ogba nga obọ, ọ lẹ ya mie wẹ idumhi emhi ni a kọ shi oni ogba bhale ghi luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ama e mu ọli, e gbe ọli, e khu ọli. Ọ pfino abọ efuẹ ya je. ");
INSERT INTO atgNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ọ gbo ghie oghumha ọyọli ọlese ghi wẹ, E pfi emhi shi ọli ukhomhi, e yẹghẹ ọli-a ");
INSERT INTO atgNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ọ gbo ghie ọlese, e gbe onana-a. Ọ ghie elese ni e bu, e gbe eghuo itali, e gbolo eghuo-a. ");
INSERT INTO atgNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“O kpọli ọghuo le ni ọa ghie ne, ikhi omi ọli ni ọ lolo nono ingme oyọli. Lọli ọ kpukhokho ghie. Ọ sa, ọọ, ‘E ya mu ekpẹ na omi mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ama eni e la oni ogba, ẹẹ egbewẹ. ‘Ọna ọ ya le ugu oni ogba ona, a bhale ni awa gbe ọli-a. Ẹghẹghẹ aghọ ni oni ugu o mele oyawa-a.’ ");
INSERT INTO atgNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ighọ e mu ọli, e gbe ọli-a, e pfi ọli rọte oni ogba ya lase. ");
INSERT INTO atgNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sẹ ọni ọ mhọli oni ogba ona ọ fẹ ya li? Eri ọ bhale ya gbolo eni ẹgbọ ni ọ ri oni ogba nga obọ-a, ọ rue oni ogba na ẹgbọẹse. ");
INSERT INTO atgNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aa she zẹ ọli Ebe-no-pfuasẹ khi. “ ‘Ẹchẹ ni itsọna e kie pfia, lọli o ke ya mele egbegbi ẹchẹ ni o kẹ mu ẹloe nẹ nya-a. ");
INSERT INTO atgNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ọnọmhuẹ ọ lighọ riẹlẹ ona, óó ti anye ẹloe gba’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ighọ egbhali eyi ẹgbọ iJu, e nono odẹ ni e te ya mu iJesu, itobọ khi e lẹsẹ khi wẹwẹ ọ ri oni okhẹ irọkhọkhọ ona nu ngme. Ama e na ulishi oyi ebubu ẹgbọ ni e la aghọ, e zẹ ọli obọ, e vu. ");
INSERT INTO atgNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ighọ e tigbe ya nyenẹ egbe ya ghie iFarisi eghuo ali eniyẹ odukhokho eyi Erọdu ghi iJesu, ni e mẹ asha rọte emini ọ ya ngme ri ingme de ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ighọ e bhale deba iJesu, ẹẹ ọli, “Ọsẹsẹ, anye lẹsẹ khi u ma ngme igẹsikia, khi emiemini ẹgbọ ẹẹ ngme ali emiemini ọgbọ ọ khi ọa ya mu ẹ ẹloe, ama odẹ oyi Ẹshinẹgba wa sẹsẹ ni o te odẹ igẹsikia. Mhiẹ i, o famhi ti abi khi ọa ti elemhi ushi, ni a rọ zẹ oga na oghie iSiza? ");
INSERT INTO atgNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Anye ke zẹ, abi anye khi zẹ?” Ama iJesu ọ she mẹ ikpamhika oyẹwẹ. Ọ́ọ́ wẹ, “Elọ o zẹ ni a rọ nono ni a di mhẹ mu? A rue ukpamhi anini bhale ghue ni mhi bino.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","E rue oghuo bhale ghi ọli, ọọ wẹ, “Alo ali eva eyi ọghuo na ni a mu shi ọ ena?” Ẹẹ ọli, “Eyi iSiza lọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","IJesu ọ́ọ́ wẹ, “A ri emini o khi oyi iSiza na iSiza, a ri emini o khi oyi Ẹshinẹgba na Ẹshinẹgba.” Ighọ ingme oyi iJesu o sha wẹ abọ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ighọ ẹgbọ ena otu na lui iSadusi ni ẹẹ sẹsẹ khi ite-eghuli-guale ọa ya la ikpukhokho agbọ, e bhale deba iJesu ya mhila li ogbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ẹẹ ọli, “Ọsẹsẹ, iMosisi ọ kẹkẹ ọli shi ebe ushi na awa khi, ‘Ini ọmọse ọ ghu-a pfi ughuẹ ọli shi agbọ, ni ọa rọ bia ọmọ na li, inyọghuo ọni ọmọse ọ́ mema rue ọni ọsamhi-olimhi ughuẹ ni ọ bia eniyẹ na ọni ọkpotso na inyọghuo ọli ni ọ ghu-a ọghọ’ ");
INSERT INTO atgNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ẹghẹghẹ oghuo ó ya la ọ, a mẹ emọse oshilua ni e khi inyọghuo. Ọni ọgbhali ọ rue ọkpotso. Ọni ọmọse ya ghua, ọa bia ọmọ na ọni ọkpotso. ");
INSERT INTO atgNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Inyọghuo ọli ni ọọ deba li ọ ke rue ọni ọkpotso, ọ gbo ghua, ọa bia ọmọ. Ighọ o gbo li inyọghuo ọli ọnuzasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ighọ o gbo li khi eni inyọghuo ọni ọmọse ni e kpọle nya. Eni inyọghuo oshilua nya e ga rue ọni ọkpotso ughuẹ ni ẹa bia ọmọ ọkhọghuo na li. Ikpukhokho ọ, ọni ọkpotso ọ li ghua. ");
INSERT INTO atgNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ini ogbẹlẹ iguale o ramhi, ni eni e ghu-a nya e rọ guale, ọghuo ọ famhi ya khi ughuẹ ọni ọkpotso? Aborọkhia khi wẹwẹ oshilua nya e ga rue ọli ughuẹ eghọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","IJesu ọ sọ wẹ ọ, Ọ́ọ́, “Wa a mẹ khi eri a da odẹ khi aa lẹsẹ emhikhọghuo elemhi Ebe-no-pfuasẹ, wẹkhi eri a lẹsẹ emhikhọghuo elemhi ekpabọ oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ini eni e ghu-a e guale, ẹa kẹ ke rue ughuẹ wẹkhi eri a ke rẹ wẹ kẹ yẹ ughuẹ. Eri e kẹ li abi igẹni ena iloghie. ");
INSERT INTO atgNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ama ingme iguale oyi eni e ghua, aa she kpẹ zẹ ọli ebe ni iMosisi ọ kẹkẹ ni ọ ngme ingme ebuli ni oo to shi? Abi Ẹshinẹgba ọ gueyẹ iMosisi khi, ‘Mhẹmhẹ mhi khi Ẹshinẹgba ọyi Aburaamu ali Ẹshinẹgba ọyi Aziki, ali Ẹshinẹgba ọyi iGiekọpu.’ ");
INSERT INTO atgNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ẹshinẹgba oyi eni e la agbọ ọ khi, ọa khi ọyi eni e ghua. Eri a ga da odẹ pfo nya.” Emini a ri ona ngme khi, ẹgbọ eni ghu-a eghuo e kie mhọli agbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ọtuọghuo eni ẹ sẹsẹ ishi, ọ la aghọ suọ abi e rọ khakọ, ọ mẹ khi iJesu ọ ga guẹ sọ ẹgbọ iSadusi ogbọ ni e mhila li, ọ mhila li, “Elemhi ishi nya, onoghuo o ga funẹ nya?” ");
INSERT INTO atgNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","IJesu ọ sọ li ọ, ọ́ọ́, “Oni o mu ẹloe ne nya na, ‘Ku esọ-a yẹyẹ iZirẹni, Ọnọmhuẹ Ẹshinẹgba ọyawa, lọlighuo kpe ọ khi Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nono ingme oyi Ẹshinẹgba Ọnọmhuẹ ọyẹ, ri udu oyẹ nya ali agbọ oyẹ nya, ghe isamhi ali ekpabọ eyẹ nya nono ingme oyi Ẹshinẹgba.’ ");
INSERT INTO atgNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Onuzi-eva ni o gbo lolo mu ẹloe khi, ‘Nono ingme oyi ọnuzava ọyẹ abi u li nono ingme egbe ẹ.’ Ushi olese okhọghuo ọa ke la ọ ni o gbo mu ẹloe dọsẹ ena.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ọni ọmọse ọ́ọ́, “U ga guẹ ngme, Ọsẹsẹ. Igẹsikia u ngme ni u wẹ khi Ẹshinẹgba ọghuo ọ khi, ali khi ọlese ọa ke la ọ, sẹ ni lọlighuo. ");
INSERT INTO atgNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ali khi awa ri udu oyi awa nya, ali isamhi eyi awa ali ekpabọ eyi awa nono ingme oyi Ẹshinẹgba. Ali awa nono ingme oyi ọnuzava ọyawa abi awa li nono ingme egbe awa. Ni awa rọ ri ishi eva ena gbe akanya, o ghọle Ẹshinẹgba dọsẹ ni awa ya ri iluasobo ali isomhopfa ọdọda bhale ghi ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Abi iJesu ọ rọ mẹ ilẹsingme ni ọ rọ sọ luẹ ọ, iJesu ọọ li, “Wa a ga nuata shi Eghiele oyi Ẹshinẹgba.” Rọte aghọ vu ọgbọ okhọghuo ọa ke gbolo mhila li ogbọ okhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Abi iJesu ọ rọ la elemhi apfẹ ni o la Owa oyi Ẹshinẹgba sẹsẹ ẹgbọ, ọ mhila wẹ ogbọ. Ọ́ọ́, Elọ o zẹ ni esẹsẹ Ishi eyi iMosisi e rọ liẹ khi omi iDefidi Ọmiepfuese ọ khi? ");
INSERT INTO atgNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Abi Ayẹmhẹ-nọ-pfuasẹ o rọ kpha iDefidi sọ, ọ rọ rọte unu oyọli liẹ. “ ‘Ẹshinẹgba ọ́ọ́, Ọnọmhuẹ oyẹmhẹ. Shitọ mama mhẹ ramhi ẹghẹghẹ ni mhi rọ ya ri ebe ẹ shi ẹ ufui ẹkoawẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ini iDefidi ọ rọte unu oyi lọlighuo lu ọli Ọnọmhuẹ, sẹ ọni Ọnọmhuẹ ọyọli ọ ke gbo liẹ khi omi ọli? Ebubu ẹgbọ e ku esọ a shi ekẹ shi emini ọ ngme, ni o ri egbe mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","IJesu ọ sẹsẹ wẹ, Ọ́ọ́ wẹ, “A mu egbe ẹ shi esẹsẹ Ishi eyi iMosisi egbe. Itsua na dọlọdọlọ e ma ghọle wẹ e isọ ke kia ifui oki, ni ẹgbọ e ke tsẹ wẹ otsẹ ekpẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","E ma nono ni wẹwẹ e shitọ ukpẹkhomhi ni ọ mu ẹloe elemhi owa ugamhi oyi awa ali ashini o mu ẹloe elemhi ilegba, ni a la le, ni a la da. ");
INSERT INTO atgNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Itoto e rọ li esamhi-olimhi ẹ le. Iromhi ni e nuẹ, eyi abamẹmhẹ, ẹ sọ. Ẹshinẹgba, ọ ya na wẹ osoli oniẹmhi to ọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Abi iJesu ọ rọ shitọ ti mama oni akpati ni a pfi ukpaghọlọ irọna a lo elemhi Owa oyi Ẹshinẹgba, ọọ bino ẹgbọ abi e li pfi ikpaghọ lo ọ. Ẹgbọ ni e pfue ebubu e pfi ikpokpomhi ikpaghọ lo. ");
INSERT INTO atgNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ighọ ọsamhi-olimhi ni ọa mhuẹ emhikhọghuo, ọ li ya pfi anini eva lo. ");
INSERT INTO atgNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ighọ iJesu ọ lu eniyẹ odukhokho eyọli, Ọ́ọ́ wẹ, “Igẹsikia mhi gue ẹ yẹ ẹ, khi ọni ọsamhi-olimhi ni ọa mhọli emhikhọghuo ọna, lọli ọ ri irọna ni o funẹ nya bhale dọsẹ ẹgbọ enekpọle nya ");
INSERT INTO atgNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Itobọ khi eri eni e pfue e rọte ẹpfue ni e mhuẹ mu ẹpfiẹ rọ riẹlẹ irọna. Ama ọni ọsamhi-olimhi ọna, rọte elemhi umhamẹ oyọli, ọ kie rue emini ọ mhọli nya ni ọ kha rọ ke le, riẹlẹ irọna.” ");
INSERT INTO atgNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Abi iJesu ọ rọte elemhi Owa oyi Ẹshinẹgba fiẹ lasele tee, ọmọ odukhokho ọyọli ọghuo, ọ́ọ́ li, “Bino ghue, Ọsẹsẹ! Ghe abi ukpokpomhi owa ona ali echẹ ni a rọ ma li e li somhi otse khẹ!” ");
INSERT INTO atgNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","IJesu ọ sọ li ọ, ọ́ọ́, “Wa mẹ ukpokpomhi owa ona. Ẹghẹghẹ o ya bhale ni ẹchẹli okhọghuo ọa ke rọ ya migha ukhomhi okhọghuo. Wẹwẹ nya e ya de kua.” ");
INSERT INTO atgNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Abi iJesu ọ li shitọ ukhomhi Ute ẹẹra Olivu, ni o sọ alo ghue oni Owa oyi Ẹshinẹgba, iPita ali iJemhisi ali iJọni ali Aduru e bẹna bhale ya mhila li, ");
INSERT INTO atgNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ẹ ọli, “Gueyẹ anye, ẹghẹghẹ ni a rọ ya ke mẹ eni ingme enana. Elọ a ya ke mẹ ni a rọ ya lẹsẹ khi oni ẹghẹghẹ ni eni emhi ena e rọ ya tsẹ khi o she ramhi?” ");
INSERT INTO atgNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ighọ iJesu ọọ wẹ, “A kuegbe-a ke tọkpẹ, ini ọgbọkhọghuo ọ khi di ẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ebubu ẹgbọ e ya ri eva oyẹmhẹ bhale deba ẹ, ẹ liẹ khi, ‘Mhẹmhẹ mhi khi lọli,’ ẹẹ di ebubu ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ini a suọ khi a khọli, o ke khi eri a suọ eko ingme okhọli obini odonuẹ, a khi ze ni o nighise ẹ udu. Emhi eghọghọ e mema bhale ya tsẹ, ama ukpẹsẹ agbọ ọa kie ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ishishi ali ishishi e ya mu okhọli vule shi egbe ọ, eghiele ali eghiele e ya li mu okhọli vule shi egbe wẹ ọ. Ekẹ o ya la asha kpa ke nighise, ẹẹ kuluẹ. Okiamhi oniẹmhi ọ́ọ̀ pfi. Igbaekẹle osoli na abi ọọ li ọkpotso ni oku o lẹsẹ bẹlẹ ẹ to egbe. ");
INSERT INTO atgNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“A ri ukpẹloe shi ekẹ lolo ke tọkpẹ. A ya mu ẹ je owa ni a la guẹ ẹzọ. A la elemhi Owa ugamhi gbe ẹ. A ya ri itobọ oyẹmhẹ mu ẹ bhale odalo oyi enighie ali eni ẹ mhẹsẹ ni a rọ gue usomhi onete oyi Ẹshinẹgba yẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ama neni ukpẹsẹ agbọ o ya ramhi, a mema she ya tse abọ oni usomhi onete oyi Ẹshinẹgba yẹ ẹgbọ na ishishi nya. ");
INSERT INTO atgNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ini a da mu e bhale khi a rẹ ẹ gue ẹzọ, khi zẹ ni udu o nasẹ ẹ shi emini u ya ngme. Ama lẹsẹ ngme emiemini Ẹshinẹgba o ya rọ nẹ oni ẹghẹghẹ aghọ, itobọ khi ọa khi yẹyẹ wa ngme, ama Ayẹmhẹ-nọ-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ẹgbọ e ya ri inyọghuo wẹ bhale na gbolo-a, ita e li ri imi wẹ li bhale ni a li gbolo-a. Ẹghẹghẹ aghọ, eniyẹ e ya ke sọ alo okhọli ghue eni e bia wẹ ọ, e gbolo wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ẹgbọ nya e ya ri itobọ oyẹmhẹ ke biselemhi ẹ, ama ọni ọ ri egbe mie ya ramhi ukpẹsẹ, a ya mie pfuese. ");
INSERT INTO atgNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ama, a kha da mẹ emini ẹ pfi oyese, ashini aa kha mẹ ọli, ikhi oni ọ vẹsẹ ẹgbọ kua, ẹghẹghẹ aghọ ọni ọ zẹ ebe ọ lẹsẹ abi a ri emini ọ zẹ ngme. Eni e la ekẹ iJudia e na nga ikhomhi ite. ");
INSERT INTO atgNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ọni ọ la ukhomhi owa ne ọ khi tiemhile elemhi owa ya rue emhikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ọni ọ la ifui ishemhi ọ khi na bhale apfẹ ya rue awulu oyọli. ");
INSERT INTO atgNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","O ma ze mu ikpotso ni ẹ mẹ ali eni e mhọli eniyẹ ni ẹ nye ẹnyeli shi egbe ẹghẹghẹ aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lema Ẹshinẹgba ọ khi bie zẹ ni o de shi ẹghẹghẹ ni ulili oniẹmhi o la gbe ẹgbọ elemhi ukpe. ");
INSERT INTO atgNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Itobọ khi onana o ya khi osoli ni o khọlọ ne nya rọte ẹghẹghẹ ni Ẹshinẹgba ọ te ma agbọ. Ọgbọ a ke gbo ya mẹ osoli uza onana ghue ekẹ agbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ini Ẹshinẹgba ọa li rọte ogbẹlẹ osoli ni a ngme ena khi-a, ọgbọkhọghuo ọa ya dobẹ ji ukhomhi ọ le. Ama irari oyi ẹgbọ eyọli ni ọ zẹ ọda kẹ, ọ rọ rọte eni ogbẹlẹ osoli ena khi-a. ");
INSERT INTO atgNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ẹghẹghẹ aghọ ini ọgbọkhọghuo ọ gueyẹ, ‘Ghekhẹ, ghe Ọmiepfuese!’ Okekhia khi eri ọ́ yẹ, ‘Ghe ọli oobọ khẹ!’ Khi mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Itobọ khi iromhi emiepfuese ali emekẹguele e ya lasele. E ya ke riẹlẹ ọlẹlẹ ali ikanya ọnyaloa ọdọda rọ ke di ẹgbọ. Ni o khia khi ini ọa gue kia, e ga li ya di egbegbi eni Ẹshinẹgba ọ zẹ ọda kẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Irarighọ, a ga lolo kuegbe-a ke tọ ẹloe ekẹ. Mhi she gue emhi nya yẹ ẹ shi ekẹ se neni oni ẹghẹghẹ o ya ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ini ẹghẹghẹ osoli ona o ga dọsẹ se nya, “ ‘Ovọ o ya bishi alo-a, uki ọa ke dobẹ gẹ, ");
INSERT INTO atgNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ikpẹtata e deno ukhuli kule, ukhuli ali ekpabọ ni e la irarogbe ẹ mhẹsẹ e ya ke nighise.’ ");
INSERT INTO atgNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ẹghẹghẹ aghọ, ẹgbọ nya e ya mẹ khi Omi Ọgbọ ọ kia elemhi otughunu ẹ bhale, elemhi ekpabọ ali ufumhi ni ọ gẹ nyanyanya. ");
INSERT INTO atgNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ẹghẹghẹ aghọ, ọ ya ghie igẹni eyọli e te asha kpa, ikhi ukpẹsẹ agbọ nya, ti ẹgbọ eyọli ni ọ zẹ ọda kẹ gbili. ");
INSERT INTO atgNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Bino abi ọkhua-eni o li ẹ te. O kha da kpẹsẹ ukhuli, ni o rọ ke ta ebe ne, lẹsẹ khi okasẹ o kẹlẹ ya le. ");
INSERT INTO atgNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A kha da gbo li lighọ mẹ khi eni emhi ena khi a da mẹ wẹ ne, lẹsẹ khi ẹghẹghẹ o she ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Abi o li mhi li gue ọli ẹ yẹ ẹ khi, ẹgbọ eghuo ni e la agbọ memena ẹa ya ghu ne, ni eni emhi ena nya e rọ bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ekẹ ali ukhuli e ya dọsẹ, ama ingmemhi eyẹmhẹ ẹa ya tigbe dọsẹ ghue. ");
INSERT INTO atgNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ọgbọkhọghuo ọa lẹsẹ oni ogbẹlẹ wẹkhi oni ẹghẹghẹ. Ghe egbegbi igẹni ena iloghie ali mhẹmhẹ Omi ọli, sẹ ni Itamhẹ lọlighuo. ");
INSERT INTO atgNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A ri ukpẹloe shi ekẹ ke tọkpẹ, itobọ khi waa lẹsẹ ẹghẹghẹ ni ọ la ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eri ona o li abi ọmọse ni ọ vu asha obini odonuẹ, ni ọ ri ighumha eyọli shi apfẹ e ri ukpẹloe khu shi na luẹ. Ọ gueyẹ ọgbọgbọ akanya ni ọ ya gbe. Ọ gueyẹ ọni ọ khẹ ekhẹ ọ ke khẹ ekhẹ apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Irarighọ, ke khẹ ekhẹ, itobọ khi waa lẹsẹ ẹghẹghẹ ni ọga ọ rọ ya jele. Ini ẹlogbọmhi lọ o, okekhi itsotso ogbiẹ lọ o, okekhi ẹghẹghẹ obili-atso lọ o, abi khi ogbiẹ-fiefie lo. ");
INSERT INTO atgNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ini ọ bhale guo, khi zẹ ni ọ bhale ya ẹ khi u wa lesẹ a. ");
INSERT INTO atgNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Abi mhi li gue ọli yẹ ẹ ena mhi li gbo gueyẹ ọgbọkpa. ‘A ke khẹ ekhẹ!’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","O ke kpe ogbẹlẹ eva le ni a rọ ya li ukpe iPasova ali ukpe ni a la le ibulẹdi ni aa ri ifuma shi nye, ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi, ee nono odẹ ni e te ya bẹna mu iJesu gbe-a. ");
INSERT INTO atgNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ẹ egbe, “Awa khi riẹlẹ ọli ini a li imu, onyaghu ọa ya lasele shi ọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Abi iJesu ọ rọ la ẹoli iBẹtani, owa oyi iSamọ ni efafe e kpẹ mu shitọ le eminale, ọkpotso ọghuo ọ rue ukoko ituale ni o lolo ghalẹ, ni o pfie lasele. Ọ gbe oni ukoko a, ọ ku oni ituale shi iJesu ukhomhi. ");
INSERT INTO atgNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ẹgbọ eghuo ni e la aghọ, e ri elemhi ibibi liẹ egbe, “Elọ o zẹ ni a rọ na pfuẹchẹ oni ituale kua shi afuẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A kha ri ọli dẹ ramhi ifata ukpe ali emhi, a kemhi eni ikpaghọ na eni ẹa mhuẹ. E shi ọni ọkpotso unu egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama iJesu ọ́ọ́ wẹ, “A zẹ ọli obọ. Elọ a yẹsẹ ọli ẹ ngme shi? Egbegbi emini o ti ni o somhi otse ọ riẹlẹ na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ẹghẹghẹ kpa eni ẹa mhuẹ e rọ nu ẹ la ana, ẹghẹghẹ ni o ghọle ẹ kpa a kpaghiẹ wẹ obọ. Ama aa ya mẹ mhẹ ẹghẹghẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Emini ọ dobẹ ya riẹlẹ ọ riẹlẹ eghọ. Eri ọ ku ituale ku mhẹ egbe shi ekẹ khẹ ẹghẹghẹ irọtọ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Igẹsikia mhi gue ẹ yẹ ẹ khi, ashashini a da la tse abọ usomhi onete ekẹ agbọ ona nya ne, a ya yele emini ọkpotso ọna ọ riẹlẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ẹghẹghẹ aghọ iJudasi Isikarọti, ni ọ khi ọtuọghuo eniyẹ odukhokho ogbava, ọ lẹ deba ighie eyi ekpodalo-ugamhi, ni ọ ya ri iJesu na wẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Onana ni ọ gueyẹ wẹ, o ga ghọle wẹ. E shobọ khi wẹwẹ e ya ri ikpaghọ na li. Ighọ iJudasi ọ li nono ẹghẹghẹ ni ọ ti ni ọ rọ ya mẹ asha ri iJesu na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ogbẹlẹ ni ododẹ ni a li oni ukpe ni a la le ibulẹdi ni aa ri ifuma shi nye o ramhi, ni o khi ogbẹlẹ ni a rọ gbe ozele Osumha ọyi oni iPasova-a, eniyẹ odukhokho eyi iJesu e mhila li “Ashi o ghọle ẹ ni anye mu egbe shi ekẹ nẹ, ni u la le eminale iPasova?” ");
INSERT INTO atgNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ighọ, ọ ghie eniyẹ odukhokho etuava eyọli, ọ́ọ́ wẹ, “A lo ifuapfẹ, ọmọse ni ọ tsua ubene amẹ, ọ ya lona ẹ odẹ. A deba li je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A gueyẹ ọni ọ mhọli apfẹ ni ọ ya lo, khi, ‘Ọsẹsẹ ọọ, anye mhilẹ u ri anye khasẹ elemhi owa ni lọli ali eniyẹ odukhokho eyẹluẹ wẹwẹ e la ya le eminale iPasova?’ ");
INSERT INTO atgNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ọ ya rẹ ẹ khasẹ agbala ni emhi nya e gba shi ukhomhi owa atọnga, a muno egbe shi akaghọ na awa.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eni eniyẹ odukhokho e vu, e lo ifui apfẹ, e ya mẹ eni emhi tee abi iJesu ọ gue ọli yẹ wẹ. Ighọ e mu egbe oni eminale iPasova. ");
INSERT INTO atgNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ogbọmhi o mu ekẹ, iJesu ali eni eniyẹ odukhokho ogbava e bhale. ");
INSERT INTO atgNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Abi e li shitọ gasẹ itebu le eminale, iJesu ọ́ọ́ wẹ, “Egbegbi-ingme mhi gue ẹ yẹ ẹ khi ọtuọghuo elemhi ẹ ọ ya rẹ mhẹ dẹ. Ọni ọ nu mhẹ le emhi memena.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Udu o yese wẹ-a, ọtuọghuo-ọghuo ọọ mhila li, “She khi ọa khi mhẹmhẹ o khi?” ");
INSERT INTO atgNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ọ sọ wẹ ọ, ọ́ọ́ wẹ, “Ọtuọghuo elemhi ẹẹ ogbava ọ ya khi, ọni ọ ga ri ibulẹdi nu mhẹ ẹ sọmhi elemhi utasa memena. ");
INSERT INTO atgNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Eri Omi Ọgbọ ọ ya ghu-a abi a li kẹkẹ ọli shi ekẹ na li. Eri-tsẹ khi, o maa khọlọ ọni ọ ya rọli dẹ egbe! O kha ga ti nẹ, ini ọgbọ ọa bie bia li lọ!” ");
INSERT INTO atgNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Abi e li le eminale eghọ, iJesu ọ rue ibulẹdi, ọ kphẹmhi, ọ khi ọli a, ọ rọ na eniyẹ odukhokho eyọli, ọ́ọ́, “A mọ le; Idiegbe oyẹmhẹ na.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ighọ ọ gbo sọ onyọ shi uko, ọ kphẹmhi, ọ rọli na wẹ, wẹwẹ nya e ga te ọ da. ");
INSERT INTO atgNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","IJesu ọ́ọ́ wẹ, “Ọlia eyẹmhẹ na ni e migha shi ishiobọ onogbọ, ni a ku kua na ebubu ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mhi gue igẹsikia yẹ ẹ khi mhi aa ke gbo ya rọte onyọ upfonu ona da, sẹ ni obini Eghiele oyi Ẹshinẹgba, ni mhi la da onyọ onogbọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Abi e rọ to uwolo se, e fiẹ lasele, e je Ute Ẹẹra olivu. ");
INSERT INTO atgNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","IJesu ọ́ọ́ wẹ, “Ẹẹ nya, a ya na kua, a zẹ mhẹmhẹ-ghuo obọ, irari khi a she kẹkẹ ọli shi Ebe-no-pfuasẹ khi. “ ‘Mhi ya ri emhi li ọrisumhakia, isumha e ya vẹ kua.’ ");
INSERT INTO atgNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ama ini a guise mhẹ le se, mhi ya ralo khẹ ẹ iGalili.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","IPita ọọ li, “Ini ẹgbọ nya e ririẹ kie ẹ, mhi aa ya kie ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","IJesu ọ́ọ́ iPita, “Mhi gueyẹ khi, neni ọkpa ọọ gbiẹghẹ iteva amiọsẹ, u ya kie mhẹ itesẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","IPita ọ kie gẹma ọ gue gagaga, ọ liẹ, “Ini o ri riẹ khia khi oni mhi la nu ẹ ghu-a lọ, mhi aa ya tigbe kie-ẹ.” Enekpọle nya e li ngme ghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","E je ashini a lu iGẹtisẹmani, iJesu ọọ eniyẹ odukhokho eyọli, “A shitọ ana ni mhi ya sọ iromhi bhale.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ọ rue iPita ali iJọni ali iJemhisi ma egbe vu. Iyesudu-a ali anasẹmhẹ e bhale na li. ");
INSERT INTO atgNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ọ wẹ, “Oya ni o la mhẹ udu memena o gba a. O ga nono ni luẹ gbe mhẹ. A migha akana khẹ mhẹ, a ke tọkpẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ọ ti je odalo dẹnẹ, ọ de ya yẹshi ekẹ, ọọ sọ iromhi ini o ya zẹ riẹlẹ ni oni ẹghẹghẹ ona o dọsẹ luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ọ́ọ́, “Itamhẹ, Itamhẹ, emhikpa o zẹ ẹ riẹlẹ. Rue mhẹ oni uko osoli ona odalo le. Eri-tsẹ khi, ọa khi abi o ghọle mhẹ, sẹẹ ni abi o li ghọle ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Abi ọ nyenẹ egbe bhale, ọ mẹ khi eni eniyẹ odukhokho e lesẹ-a. Ọọ iPita, “ISamọ, eri u lesẹ-a? Aa dobẹ nu mhẹ tọkpẹ ukuku ẹghẹghẹ tsẹ? ");
INSERT INTO atgNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ri ukpẹloe shi ekẹ gboo ke sọ iromhi ini u khi de ini u mhọli imufẹ. Ayẹmhẹ oyẹ o mu egbe ni o rọ riẹlẹ, eri-tsẹ khi, idiegbe oyẹ ọa dobẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ighọ ọ gbo vu ya sọ iromhi enabi ọ kpẹ sọ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Abi ọ rọ nyenẹ egbe bhale, ọ gbo bhale ya ẹ wẹ khi e lesẹ-a, irari khi olesẹ o la wẹ alo, ẹa lẹsẹ abi e ke ya ngme ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Abi ọ rọ nyenẹ egbe bhale utonuzesẹ, ọ́ọ́ wẹ, “Olesẹ a kie la, ni a yẹmhẹ-a? Olesẹ oghọ o she bu ẹ! Oni ẹghẹghẹ o she ramhi. A bino khẹ khi, a ri Omi Ọgbọ na ena olamhẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","A vule ni awa vu! Ọni ọ́ rẹmhẹ dẹ ọ́ọ́ bhale ena!” ");
INSERT INTO atgNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Abi ọ li ngme, iJudasi, ni ọ khi ọtuọghuo elemhi eni eniyẹ odukhokho ogbava ọ bhale. Ẹgbọ ni e tsua itsua okhọli ali itakobi ali ikpokpo, ni ighie eyi ekpodalo-ugamhi, ali esẹsẹ Ishi eyi iMosisi ali egbhali e ghie, e nu ọli bhale. ");
INSERT INTO atgNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ọni ọ rọli dẹ ọ she kpẹ gueyẹ eni e nu ọli kia, ọọ wẹ, “Ọni mhi da pfipfi ekphamhi ne, lọli ọ khi ọni a nono. A mu ọli, a khẹ ọli ekhẹ rue vu.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Abi e rọ lẹsẹ lole, iJudasi ọ lẹ deba iJesu, ọ́ọ́, “Ọsẹsẹ.” Ọ pfipfi ọli ekphamhi. ");
INSERT INTO atgNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eni emọse e mu iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ighọ ọtuọghuo eni e migha epfẹ-aghọ ọ ji itakobi oyọli emhi lasele, ọ bẹ oghumha ọyi Ọga ọyi ekpodalo ugamhi esọ-a. ");
INSERT INTO atgNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","IJesu ọ́ọ́ wẹ, “Okhọli mhi tsua, ni a rọ lina tsua itsua okhọli ali itakobi ali ikpokpo bhale ya mu mhẹ? ");
INSERT INTO atgNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ogbẹlẹ kpa mhi rọ nu ẹ la, mhi la Owa oyi Ẹshinẹgba ẹ sẹsẹ. Aa mu mhẹ. Eri a mẹ emhi ena ni emini a kẹkẹ shi Ebe-no-pfuasẹ o bhale ya tsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ighọ eniyẹ odukhokho eyọli nya ni e deba li e vẹ kua, o kpe lọlighuo le. ");
INSERT INTO atgNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ọzẹo ọghuo ni ọ sọ awulu ona yẹyẹyẹ, ọọ deba iJesu. Abi e rọ tọ obọ sọ li, khi wẹwẹ e ya mu ọli, ");
INSERT INTO atgNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ọ nyanọ awulu-a mhuẹ wẹ abọ, ọ ri irumheba na vu. ");
INSERT INTO atgNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E mu iJesu bhale owa oyi Ọga ọyi ekpodalo ugamhi, ighie eyi ekpodalo-ugamhi nya, ali egbhali ali ekẹkebe ali esẹsẹ Ishi eyi iMosisi nya e le gba. ");
INSERT INTO atgNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","IPita ọ tapfia deba li ukhu-khokho, ya ramhi elemhi apfẹ oyi Ọga ọyi ekpodalo ugamhi. Ọ nu eni ẹ khẹ ekhẹ shitọ khasẹ erali. ");
INSERT INTO atgNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eni ighie eyi ekpodalo-ugamhi ali oni igbaa oyi iSaẹdiri nya, e nono emhi ushi ni e ya mu mhọli iJesu obọ, ni e ba mẹ asha gbe ọli-a. Ẹa mẹ emhikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ebubu ẹgbọ e pfi ọtsẹlẹ eyi ẹgbhọli mu ọli, eni ọtsẹlẹ nya, ẹa de shi oghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ikpukhokho, ẹgbọ eghuo e vule pfi ọtsẹlẹ ẹgbhọli ona mu iJesu. Ẹẹ, ");
INSERT INTO atgNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Anye suọ khi ọọ liẹ khi, ‘Mhi ya guọghọ Owa oyi Ẹshinẹgba onana ni ẹgbọ e ri abọ ma-a, ẹlẹ-esẹ mhi tọ olese ni ẹgbọ ẹa ri abọ ma.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Abi e riẹ kie ngme ona, ọtsẹlẹ eyẹwẹ ẹa kie de shi oghuo. ");
INSERT INTO atgNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ighọ Ọga ọyi ekpodalo ugamhi ọ vule migha odalo oyẹwẹ nya, ọ mhila iJesu. “Waa bie ya sọ wẹ ọ? Ẹzọ elọ na ni ẹgbọ ena ẹẹ gue shi ẹ egbe?” ");
INSERT INTO atgNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama iJesu ọ tsaghiẹ a, ọa sọ wẹ ọ. Ọga ọyi ekpodalo ugamhi, ọ gbo mhila li, “Yẹyẹ u khi Ọmiepfuese, Omi Ẹshinẹgba ọna Kuẹghiẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","IJesu ọ́ọ́ li, “Lọli mhi khi. Ẹẹ nya a ya mẹ khi Omi Ọgbọ ọ shitọ obita oyi Ẹshinẹgba ni ọ funẹ, ali khi ọ la otughunu rọte irarogbe ẹ tiemhie.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ọga ọyi ekpodalo ugamhi ọ nyanọ itsua shi egbọli uruli abi ọ li yila. Ọ́ọ́, “Awa ke gbo nono ọtsẹlẹ olese. ");
INSERT INTO atgNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ẹẹ nya a she suọ abi ọ pfi unu-a deba Ẹshinẹgba. Sẹ a sọ shi ọ?” Wẹwẹ nya e pfa ẹzọ mu ọli khi ọni a gbe-a ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ẹgbọ eghuo ọ, e tono etẹ ku ọli. E ri emhi gẹnọ ọli alo. E pfi ọli emhi, ẹ ọli, “Mẹ ekẹ guele, gueyẹ anye ọni ọ pfi ẹ emhi?” Eni ẹ khẹ ekhẹ e mu ọli, e lase ọli esọ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Abi iPita ọ kie shitọ elemhi apfẹ eghọ, ọmueshi ọghuo ni ọ khi ọni ọọ ga ọyi Ọga ọyi ekpodalo ugamhi ọ bhale. ");
INSERT INTO atgNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ọ mẹ iPita abi ọ rọkhasẹ erali, ọ tọli ọkpẹ tsukẹ. Ọọ li, “Yẹyẹ u li nu iJesu na iNazarẹti i kia.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ama iPita ọ tia. Ọ́ọ́, “Mhi a lẹsẹ emini wa ngme.” Ọ lase aghọ le je odẹ ni a tẹ ẹ lo elemhi apfẹ. Ighọ ọkpa ọ gbiẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Abi ọni ọmueshi ni ọ ga ọgbọ ọghọ ọ rọ gbo mẹ iPita aghọ, ọ gbo riẹlẹ eni ingmemhi ngme khasẹ eni e migha epfẹ aghọ. Ọọ, “Ọtuọghuo elemhi wẹ, ọni ọmọse ọna ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","IPita ọ gbo tia. Oo li dẹnẹ, eni e migha epfẹ aghọ e kẹ iPita, “Igẹsikia lọ khi ọtuọghuo elemhi wẹ u khi, irari khi ọnge iGalili u khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ighọ ọ li sẹ egbọli isheli, ọ romhi eni isheli. Ọ liẹ, “Mhi aa ga lẹsẹ ọmọse ọna ni a ngme ena.” ");
INSERT INTO atgNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Utoghuokpe, ọkpa ọ gbiẹghẹ utonuzi-eva. IPita ọ sato emini iJesu ọ gueyẹ ọli khi, “Neni ọkpa ọ ya gbiẹghẹ utonuzi-eva, u ya kie mhẹ itesẹ.” Ighọ ọ gbe akhe eviẹ a. ");
INSERT INTO atgNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ẹluzogbe fiefie, ighie eyi ekpodalo-ugamhi, ali egbhali ali esẹsẹ Ishi eyi iMosisi ali igbaa eyi iSaẹdiri nya, e ye ugbamhi. E gẹ iJesu rue vu ghi iPaleti. ");
INSERT INTO atgNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ọni iPaleti ọ mhila iJesu ogbọ, ọọ li, “Oghie ọyi ẹgbọ iJu u khi?” IJesu ọ́ọ́, “Eee! Ighọ lọ abi u ngme ọli.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eni ighie eyi ekpodalo-ugamhi eyi Ẹshinẹgba e ga gue ẹzọ emhi ebubu shi iJesu egbe. ");
INSERT INTO atgNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ighọ iPaleti ọ gbo mhila li ogbọ, ọ́ọ́, “Wa ya pfunu, u suọ iwali ẹzọ ni e gue ẹ shi ẹ egbe?” ");
INSERT INTO atgNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama iJesu ọa sọ li ọ. O ri abọ sha iPaleti. ");
INSERT INTO atgNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Abi áá li ini o lina ramhi ẹghẹghẹ ukpe iPasova, eri iPaleti ọ rue ọgbọ ọghuo owa ighumha lasele na wẹ abi o ghọle wẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ẹghẹghẹ aghọ ọmọse ọghuo ni a lu iBarabasi ọ la owa ighumha, ni ọ khi ọghuo ẹgbọ ni a mu. Eri a mu ọli shi ugbeli ni ọ gbe ẹghẹghẹ ni a rọ mẹ onyaghu. ");
INSERT INTO atgNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Abi eni ẹgbọ e rọ bhale gbii ya mhila iPaleti ọ riẹlẹ emini ọ kie kpẹ riẹlẹ na wẹ, ");
INSERT INTO atgNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","IPaleti ọ mhila wẹ, ọọ, “A nono ni mhi rue oghie iJu abọ a na ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ọ́ ga lẹsẹ gboo khi itobọ ibiselemhi, ighie eyi ekpodalo-ugamhi e rọ mu iJesu ghi luẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama ighie eyi ekpodalo-ugamhi e sẹsẹ ẹgbọ e gueyẹ iPaleti ọ ri ochoghọ wolọ iBarabasi obọ a na ẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","IPaleti ọ mhila wẹ, ọ́ọ́, “Elọ mhi kẹ li ọni a lu oghie iJu shọ?” ");
INSERT INTO atgNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","E tsẹsẹ leghe, “A ta li ma ọara apfida.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","IPaleti ọ mhila wẹ, ọ́ọ́, “Elọ o zẹ, umha-guẹkia onoghuo ọ riẹlẹ?” Ama eena e tsẹsẹ nẹ, “A ta li ma ọara apfida!” ");
INSERT INTO atgNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ni ọ rọ riẹlẹ emini oo ghọle eni ẹgbọ, ọ wolọ iBarabasi abọ-a na wẹ. Ọ́ọ́ e gbe iJesu itẹ, ọ rue ọli na wẹ e ka ta li ma ọara apfida. ");
INSERT INTO atgNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eni ekhọli-okhuẹ e rue iJesu lo elemhi apfẹ agbala oyi igọvunọ. E lu ekhọli-okhuẹ apfẹwẹ eni e kpọle. ");
INSERT INTO atgNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","E ri awulu ichẹ ni o khi ẹgholi ibulu, sọ li, e ri igba do arula rughu ọli ukhomhi. ");
INSERT INTO atgNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","E liẹ ọli, “A da abọ na oghie ọyi ẹgbọ iJu!” ");
INSERT INTO atgNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","E pfino ọli ukpokpo ukhomhi iti ingmi-ingmẹ, e tono etẹ ku ọli. E de ya wugha li odalo, e nyẹsẹ ukhomhi na li. ");
INSERT INTO atgNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Abi e rọ lighọ ri iJesu li egia se nya, e gueghie ọli oni awulu ichẹ ni o khi ẹgholi ibulu oghọ, e nyenẹ egbe ri itsua eyọli sọ li. Ighọ e rue ọli vu ya tama ọara apfida. ");
INSERT INTO atgNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Abi e rọ lẹ, e ya ẹ ọmọse ọghuo ni a lu iSamọ ni ọ rọte odẹ oyọli dọsẹ, ni ọ rọte asha jele. Ighọ eni ekhọli-okhuẹ e ri itoto mu ọli ọ tsua ọara apfida oyi iJesu. ISamọ ọngi iZirẹni ọ khi, ọ gbo khi ita Alẹzada ali iRufọsi. ");
INSERT INTO atgNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","E rue iJesu bhale ashini a lu iGọgọta. Ugua ukhomhi olimhi a ri iGọgọta ngme ");
INSERT INTO atgNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A ri onyọ ni a ku ikhumhi na lui Imari shi na li ọ rọ da, ama ọa lama da li. ");
INSERT INTO atgNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","E ta li ma ọara apfida. E kemhi itsua ni ọ sọ mhọli egbe abọ. E ti ebe rọ kemhi eni ide eyọli, ni e lẹsẹ oni o ya tẹ ọgbọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ẹghẹghẹ agogo itili ẹluzogbe a rọ ta li ma ọara apfida. ");
INSERT INTO atgNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Emini e kẹkẹ rọ kphase oni ọara apfida kpeda na li khi. Oghie Ọyi Ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","E li gbo ta ighiatọ etuava ma ọara apfida mama li, ọtuọghuo ọ la li obọ-ita, ọnọkpọle ọ la li obọgobọ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ona o ri emini a kẹkẹ shi Ebe-no-pfuasẹ bhale ya tsẹ, ni ọ́ọ́, “A leli ọli ma ighiatọ.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ẹgbọ eni e te epfẹ aghọ dọsẹ, e pfi itsue manya iJesu, ee nighise ukhomhi, e liẹ, “Ebanẹkẹ! Yẹyẹ ni u ya guọghọ Owa oyi Ẹshinẹgba-a, u gbo riẹlẹ ọ tọ ogbẹlẹ esẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Rọ te ọara apfida tiemhie shọ ya mie egbe ẹ pfuese.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ighọ ighie eyi ekpodalo-ugamhi, ali esẹsẹ Ishi eyi iMosisi e li ri iJesu li egia, e liẹ egbe wẹ. “Ọ mie ẹgbọẹse pfuese, ama ọa dobẹ mie egbọli pfuese. ");
INSERT INTO atgNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A zẹ ni ọni Ọmiepfuese ọna, ikhi oghie iZirẹni, ni ọ rọte ọara apfida tiemhie ni awa mẹ, ni awa mie ọli suọ.” Eni a li ta ma ọara apfida mama li, e ga li nu wẹ tsue ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Agogo igbẹva ọguota, obili o bi oni ekẹ a nya. Elemhi iwakati esẹ oni obili o la ogbe ramhi. ");
INSERT INTO atgNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Agogo esẹ o ramhi, iJesu ọ tsẹsẹ leghe, ọ ri unu ẹoli oyẹwẹ liẹ, “Eloi, Eloi, Lama Sabachi tani?” Emini a ri ona ngme khi, “Ẹshinẹgba ọyẹmhẹ, Ẹshinẹgba ọyẹmhẹ, elọ o zẹ ni u rọ tsua mhẹ pfia.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abi ẹgbọ eghuo ni e migha epfẹ aghọ e rọ suọ khi ọ ngme na, e kẹ, “Ri esọ shi ekẹ khi ọ lui Elaja.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ọmọse ọghuo elemhi eni ẹgbọ ọ na ya rue isoso sọ li onyọ ni okhẹ a, ọ gẹ ọli shi ukpokpo rọli kpẹ iJesu unu ọ rọ da. Ọni ọmọse ọ kẹ. “A zẹ ọli obọ, ni awa mẹ ini Elaja ọ ya bhale ya rue ọli ukhomhi ọara apfida tiemhie.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","IJesu ọ tsẹsẹ leghe, ọ ghua. ");
INSERT INTO atgNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ukpokpomhi ode ugbakpi ni a rọ pfa odẹ-a shi elemhi Owa Oyi Ẹshinẹgba, o rọte idane kiẹsẹ-a asha eva ya to ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Abi ọkhọli-okhuẹ ọniẹmhi ni ọ migha odalo oni ọara apfida ọ rọ suọ abi iJesu ọ́ tsẹsẹ leghe, ni ọ rọ mẹ abi ọ li ghua, ọ́ọ́, “Egbegbọ lọ khi, Omi Ẹshinẹgba ọmọse ọna ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ikpotso eghuo e ta pfia bino, iMeli ọnge iMagidaleni, ali iMeli inyi iJemhisi ọni ọ kpọkẹ, ni ọ gbo khi inyi iJosisi ali iSalomẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ikpotso ena e mema deba iJesu ni e ri ukpẹloe khu ọli obini iGalili. Ikpotso elese ni e deba iJesu bhale iJerusalẹmu e li ga migha aghọ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ogbọmhi o she mu ekẹ ẹlẹghọ ni o khi ẹlẹ ni a rọ mu egbe khẹ ẹlẹ iyẹmhẹa ọyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","IJosẹfu ọnge Arimatia, ni ọ khi ọghuo eni ẹ mhẹsẹ, ni ọ khi ọgbọ ni ọ li mu ẹloe. Eri ọ bie kpẹ ri ẹloe shi ekẹ khẹ Eghiele oyi Ẹshinẹgba. Ọ gbe udu lẹ ya gueyẹ iPaleti o rue olimhi oyi iJesu na luẹ ya tọ. ");
INSERT INTO atgNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","O ga sha iPaleti abọ khi iJesu ọ she gbhẹ ghọ kẹlẹ ghua. Ọ lui ọni ọkhọli-okhuẹ ọniẹmhi ọghọ mhila ini iJesu ọ she gbhẹ ghua. ");
INSERT INTO atgNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Abi iPaleti ọ rọ rọte unu oyi ọni ọkhọli-okhuẹ ọniẹmhi ọghọ suọ khi ighọ o khi egbegbọ, ọ tsua olimhi ọyi iJesu na iJosẹfu. ");
INSERT INTO atgNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ighọ iJosẹfu ọ dẹ ide, ọ rue ọni olimhi tiemhile ọara, ọ khuli ọli, ọ ri ọli tọ uji ni a tọ shi echẹ. Ọ gheghele ẹchẹ oniẹmhi guese oni uji. ");
INSERT INTO atgNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","IMeli ọnge iMagidaleni, ali iMeli inyọ iJosisi e mẹ ashini a ri ọli tọ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Abi ẹlẹ iyẹmhẹa o rọ dọsẹ se, iMeli ọnge iMagidaleni, ali iSalomẹ, ali iMeli inyi iJemhisi, e dẹ afu ituale ni ẹẹ pfie mhuẹ obọ ni wẹwẹ e ya khakha li shi idiegbe olimhi oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ogbiẹ-fiefie ni o khi uka, khi ovọ o lẹsẹ ngale, e je atalimhi ni a rọli tọ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ighọ e mhila egbe wẹ́, “Ọghuo ọ ya gheghele ẹchẹ unu oni atalimhi-a na awa?” ");
INSERT INTO atgNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ama abi e ke rọ yasẹ alo ekẹ bino, e mẹ khi a she gheghele oni ẹchẹ ni o ghọ gbẹdi unu oni atalimhi-a a. ");
INSERT INTO atgNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Abi e rọ lo oni uji, e mẹ ọzẹo ni ọ sọ itsua epfopfo na dogo, khi ọ shitọ epfẹ obita. O sha wẹ abọ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ọ́ọ́ wẹ, “Abọ e khi sha ẹ.” “IJesu ọnge iNazarẹti ọni a ta ma ọara apfida a nono? Ọ she te eghuli guale. Ọa la akana. Ghe ashini a rọli tọ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ama a ke vu, a ka gueyẹ eniyẹ odukhokho eyọli ali iPita khi, ‘Ọ she ralo iGalili ẹ khẹ ẹ. A ya bhale ya ẹ ọli shi aghọ abi ọ kie kpẹ gueyẹ ẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eni ikpotso e lasele, e na ya je apfẹ. Abọ e sha wẹ, ulishi oo mu wẹ, ẹa nu ọgbọkhọghuo ngme irari khi ulishi ó mu wẹ. Ebe eni ododẹ eghuo eni a rọte kẹkẹ oni Usomhi Onete ona, ẹa mhọli ọdada 9-20 oyi ukhomhi 16 ona. ");
INSERT INTO atgNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Abi iJesu ọ rọ rọte eghuli guale ẹlẹ uka se, ọ ri egbe ọli kpẹ khasẹ iMeli ọnge iMagidaleni, ọni iJesu ọ khu ayẹmhẹ ebe ishilua rọte egbe ya fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ọ vu ya gueyẹ apfẹ iJesu ni ee viẹ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Abi e rọ suọ khi iJesu ọ she guale khi ọ la agbọ ali khi iMeli ọngi IMagidaleni ọ mẹ ọli, ẹa mie shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Abi a rọ mẹ ona se, iJesu ọ rọte odẹ ọdọda ri egbọli khasẹ ẹwẹ aava abi e li lo elemhi oni ẹoli. ");
INSERT INTO atgNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","E nyenẹ egbe jele, e gbo gueyẹ eniyẹ odukhokho ni e kpọle, ama, ẹa gbo li mie shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ikpukhokho, iJesu ọ ri egbọli khasẹ eni eniyẹ odukhokho ogbaghuo abi e rọ le eminale. Ọ dese wẹ shi umha-mhọli irudunga oyẹwẹ, ali umha-nono ni e mie shi emini eni e mẹ luẹ e ngme abi ọ rọ guale se. ");
INSERT INTO atgNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ọọ wẹ, “A lo elemhi ekẹ agbọ nya, a ke gue usomhi onete oyẹmhẹ yẹ ọgbọkpa. ");
INSERT INTO atgNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ọnini ọ da mie ẹ suọ, ni a da batazi ne, ọ ya mhọli imiepfuese, ama ọni ọa da miesuọ, a she pfa ẹzọ mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ọlẹlẹ ona o ya ke deba eni e miesuọ, e ya ri eva oyẹmhẹ khu ayẹmhẹ ebe kua, e ya ngme ẹmuẹ onogbọ unu. ");
INSERT INTO atgNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","E ya ri abọ eyẹwẹ mu enyẹ ekẹ, ini e riẹ rue ikhumhi ni ọọ gbe ọgbọ da, ọa ya li wẹ abikhọghuo. E kha ri abọ nga eni ẹ ghua egbe, e ya toto.” ");
INSERT INTO atgNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Abi iJesu Ọnọmhuẹ ọ rọ nu wẹ ngme se, a rue ọli nga idane iloghie. Ọ shitọ ukiẹkiẹ obita oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ighọ eniyẹ odukhokho eyi iJesu e li fiẹ ya tse abọ oni usomhi onete gasẹ asha kpa. Ighọ Ọnọmhuẹ ọ rẹ wẹ gbe ikanya, ọ ri ikanya ọnyaloa ni e gbe ri ungmemhi oyọli tsẹ.");
INSERT INTO atgNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ebubu ẹgbọ e she rọshẹka kẹkẹ emini e bhale ya tsẹ nya ẹghẹghẹ oyi anye. ");
INSERT INTO atgNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ẹzẹzẹ abi ẹgbọ eni ẹ gue ungmemhi oyi Ẹshinẹgba le, ni e rọte igbaekẹle ri ẹloe mẹ wẹ abi e li de, ighọ e li gue wẹ yẹ anye, ni anye rọ lighọ kẹkẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aborọkhia khi eni ingme ena, khi rọte igbaekẹle mhi te tọwẹ ọkpẹ, lọli o rọ ti mhẹ ẹloe, ni mhi kuegbe-a kẹkẹ abi e li de ghi ẹ, yẹyẹ iTiofilọsi ni a ri ekpẹ ẹ na, ");
INSERT INTO atgNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Isheghọ ni u rọ ya lẹsẹ egbegbi ingme ni e la emini a sẹsẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ọkpodalo-ugamhi ọyi Ẹshinẹgba ọghuo ni a lu iZakaraya ọ ya la ọ ẹghẹghẹ oyi oghie ni a lu Erọdu ni ọ mhuẹ ekẹ iJudia. Ọni iZakaraya ọ khi ọtuọghuo igbhogbho ekpodalo-ugamhi eyi Ẹshinẹgba ni Abija ọ li la. A lu ughuẹ ọli Enizabẹti ni ọ khi omiomi Erọni. ");
INSERT INTO atgNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ọni ọmọse ọna ali ughuẹ ọli, e khi ẹgbọ ni e pfuasẹ shi odalo oyi Ẹshinẹgba, ni e ri ishi eyi Ẹshinẹgba á gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ẹa bia ọmọ itobọ khi Enizabẹti aga ọ khi. Wẹwẹ ava-ava e she womhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ẹlẹghuo, khi ugamhi o tẹ iku ẹgbọ ekpodalo-ugamhi eyi Ẹshinẹgba ni iZakaraya ọ la, ");
INSERT INTO atgNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","obọ o mu iZakaraya khi lọli ọ ya lo Owa oyi Ẹshinẹgba ya tosẹ ituale afu ẹẹra ukhomhi atẹtẹ. Ighọ eni igbhogbho ekpodalo-ugamhi eyi Ẹshinẹgba e kie kpẹ ẹ li. ");
INSERT INTO atgNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Abi ẹghẹghẹ ni a rọ ọ tosẹ eni ituale o rọ ramhi, eni ẹgbọ ni e bhale shi oni ugamhi, e legba atukpapfẹ, e sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ighọ agẹni ọyi Ẹshinẹgba ọ bhale ya migha ukiẹkiẹ obọ ita oni adido ni a la tosẹ ituale. ");
INSERT INTO atgNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Abi iZakaraya ọ rọ mẹ ọni agẹni, ọ yila, ulishi oo mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama ọni agẹni ọọ li, “Khi zẹ ni ulishi o muẹ, Ẹshinẹgba ọ she suọ iromhi ni u sọ. Ughuẹ Enizabẹti, o ya bia ọmọ nẹ. IJọni khi eva ni u ya lu ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ọni ọmọ, ọ ya ri oghẹlẹ ali iregbemu ghi ẹ. Ebubu ẹgbọ e ya ghẹlẹ shi ubiamhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Irari khi ọ ya fu shi odalo oyi Ẹshinẹgba. Ọ́ khi tigbe da onyọ ni o toto ghue. Rọte ẹlẹ ni a te ya bia li, ọ te ya mhuẹ Ayẹmhẹ-nọ-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ẹgbọ iZirẹni ebubu ọ ya mu pfi bhale deba Ẹshinẹgba Ọnọmhuẹ ọyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ọnọmhuẹ ọ ya ghie ọli ralo, ọ mhuẹ ekpabọ ali ayẹmhẹ enabi eyi Elaja. Ọ ya mu udu oyi eni e khi ita pfi ni e ke nono ingme oyi imi wẹ. Ẹgbọ eni ẹa kpẹ ẹ suọ esọ na Ẹshinẹgba, ẹẹ suọ esọ na Ẹshinẹgba abi egbegbi ẹgbọ ẹẹ li. Ọ̀ gbo mu ẹgbọ egbe shi ekẹ khẹ Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","IZakaraya ọ rọ mhila ọni agẹni, “Sẹẹ o li ya khuese mhẹ khi igẹsikia u ngme? Irari khi mhẹmhẹ ali ughuẹmhẹ anye she womhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ọni agẹni ọọ li, eva oyẹmhẹ khi iGebulẹni. Mhẹmhẹ mhia migha odalo oyi Ẹshinẹgba. Lọli ọ ghie mhẹ mhi ka nu ẹ ngme, mhi gue oni usomhi onete ona yẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ama ungmenu u kẹ ya melea ramhi ẹghẹghẹ ni oni ungmemhi ona o rọ bhale ya tsẹ, itobọ khi u waa mie emini mhi gueyẹ suọ ni ó bhale ya tsẹ shi ẹghẹghẹ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ẹghẹghẹ ni a ngme ena, ẹgbọ e kie migha olase khẹ iZakaraya. Abọ e sha wẹ, irari khi ọ she ke tẹsẹ oni elemhi Owa oyi Ẹshinẹgba dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Abi ọ ke rọ lasele ọa ke ngme unu. Eni ẹgbọ e te ododẹ lẹsẹ khi imekẹ ọ mẹ oni elemhi Owa oyi Ẹshinẹgba irari khi obọ ọ ke rọ nu wẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Abi ogbẹlẹ ni iZakaraya ọ rọ ya ga oni ugamhi e rọ gba, ọ je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ighọ, ughuọli Enizabẹti ọọ mẹ. Ọ la ufui owa iki ishe, ọa ke lasele ni ẹgbọ e mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ọni ọkpotso ọọ, “Ẹshinẹgba ọ she riẹlẹ onana na mhẹ. Ọ mhuẹ isomhelemhi na mhẹ, Ọ rue mhẹ omama egbe le ukpẹloe oyi ẹgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Uki onuzi-esesa o gba ni Enizabẹti ọ te e mẹ, Ẹshinẹgba ọ ghie agẹni ni a lu iGebulẹni bhale ẹoli iNazarẹti ni o la ekẹ iGalili. ");
INSERT INTO atgNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ọni agẹni ọ bhale deba ọmueshi ni ọa lẹsẹ ọmọse ne ni a lu iMeli ni ọmọse ni a lu iJosẹfu ọọ gue. Unuẹkpẹ oyi iDefidi iJosẹfu ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ọni agẹni ọ bhale deba iMeli. Ọ tsẹ ọli, ọọ li, “Moo mueshi! Ẹshinẹgba ọ she khivọsẹ nẹ! Ẹshinẹgba ọ nuẹ la!” ");
INSERT INTO atgNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oni otsẹ ona o ri abọ sha iMeli irari khi ọa lẹsẹ emini otsẹ onana o ngme. Egbe ẹa ke sheshe ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ama ọni agẹni ọọ li, “Khi ke zẹ ni ulishi o muẹ, irari khi Ẹshinẹgba ọ she mhọli isomhelemhi nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","U ya ke mẹ, u bia ọmọ ọmọse, iJesu wa lu eva oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ọgbọ ọniẹmhi ọ ya khi, Omi Ẹshinẹgba nọ Yagha nẹ Nya a ya ke lu ọli. Ẹshinẹgba ọ ya rue ukpẹkhomhi eghiele oyi itali iDefidi na li. ");
INSERT INTO atgNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ọ ya mhuẹ omhẹsẹ shi ọmhuẹ-apfẹ oyi iGiekọpu agbọagbọ. Eghiele oyọli ọa ya mhuẹ ukpẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","IMeli ọ mhila ọni agẹni, ọọ, “Sẹ ingme ni u ngme ena e li bhale ya tsẹ? Irari khi mhi aa lẹsẹ ọmọse ghue.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ọni agẹni ọọ li, “Ayẹmhẹ-nọ-pfuasẹ ọ ya bhale debẹ, ẹghẹghẹ aghọ ekpabọ eyi Ẹshinẹgba nọ Yagha nẹ Nya e ya tsua rughuẹ, ọmọ ni u ya bia, ọni ọ pfuasẹ Omi Ẹshinẹgba a ya ke lu ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Enizabẹti inyọghuoẹ ni a kpẹ ẹ lu aga, ọ she liẹ mẹ umẹmhi, iki esesa o la memena, abi ọ tseku khia khi ọ she womhẹ eghọ, ọ ya bia ọmọ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Irari khi aa mẹ emini Ẹshinẹgba ọa dobẹ ẹ riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","IMeli ọọ li, “Ẹshinẹgba ọ mhuẹ mhẹ. O ka a tsẹ na mhẹ abi u li ngme ọli.” Ighọ ọni agẹni ọ li vu. ");
INSERT INTO atgNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ẹghẹghẹ ana iMeli ọ nyanya muno egbe, ọ je ẹoli ni e la epfepfẹ ute ena ekẹ iJudia. ");
INSERT INTO atgNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ọ ramhi apfẹ oyi iZakaraya, ọ tsẹ Enizabẹti. ");
INSERT INTO atgNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Abi Enizabẹti ọ rọ suọ otsẹ oyi iMeli, ọmọ ni ọ la li elemhi ọ mu egbe nyenẹ. Ayẹmhẹ-nọ-pfuasẹ o bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Enizabẹti ọ khueghie unu a leghe, ọọ li, “Ọni a khivọsẹ na u khi elemhi ikpotso. Ọni a khivọsẹ na ọmọ ni u ya bia ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ọghuo mhi khi, ni inyọ Ọnọmhuẹ ọyẹmhẹ ọ kọ ya fẹli? ");
INSERT INTO atgNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Abi mhi rọ lẹsẹ suọ otsẹ oyẹ, ọmọ ni ọ la mhẹ elemhi ọ ri oghẹlẹ mu egbe nyenẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ikhivọsẹ o khi na ọgbọ ni ọ mie ungmemhi ni Ẹshinẹgba ọ ngme khi ọ ya rọli tsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","IMeli ọọ, “Mhi ri ayẹmhẹ oyẹmhẹ kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mhi rọte elemhi ayẹmhẹ oyẹmhẹ kuẹghiẹ Ẹshinẹgba Ọmiepfuese ọyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Irari khi ọ yele mhẹ ni mhia mu ẹloe le. Rọte ana vu, ẹgbọ kpa, e ya ke e lu mhẹ, Ọni a khi vọsẹ na. ");
INSERT INTO atgNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ipfuasẹ o khi eva oyi Ẹshinẹgba nọ funẹ, Irari khi ọ riẹlẹ eminiẹmhi na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ọ mhuẹ isomhelemhi na ẹgbọ nya ni ẹ na ulishi oyọli rọte agbhotu ya je agbhotu. ");
INSERT INTO atgNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ọ ri abọ eyọli gbe ikanya ọnyaloa, ọ vẹsẹ ẹgbọ ni e mhuẹ itiegbenga elemhi isamhi udu eyẹwẹ kua. ");
INSERT INTO atgNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ọ ti ighie tiemhile ekẹ, ama ọ yasẹ ẹgbọ ni e ti egbewẹ tiemhie nga idane. ");
INSERT INTO atgNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ọ ri eminete na ẹgbọ ni okiamhi ọ́ọ́ gbe le. Ama eni e pfue, ọ ku wẹ ẹpfue abọ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ọ she ri ishiobọ ni ọ shi na itawa tsẹ. Ọ bhale ya kpaghiẹ ẹgbọ iZirẹni eni ẹẹ ga li obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abi ọ li shi ishobọ na agbọagbọ na Aburaamu ali imimi ọli, ni ọ gbo li nu ititawa ngme ọli agbọagbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","IMeli ọ nu Enizabẹti la iki esẹ neni ọ je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ẹghẹghẹ o ramhi ni Enizabẹti ọ rọ ya bia, ọ ya bia ọmọ ọmọse. ");
INSERT INTO atgNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Idogbapfẹ ali ẹgbọ eyọli e suọ abi Ẹshinẹgba ọọ somhi elemhi ọli. E nu ọli ghẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ogbẹlẹ-elele o ramhi ni a rọ ya shẹlẹ ọni ọmọ a, ee nono ni e lu ọli iZakaraya ni o khi eva oyi ita li. ");
INSERT INTO atgNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Inyọli ọọ wẹ, “Iiye! Eva oyọli khi iJọni.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eni ẹgbọ ẹ ọli, “Ọgbọkhọghuo ọa la unuẹkpẹ oyẹ ni ọ kpẹ le eva onana ghue.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ighọ e ri abọ nu ita ọni ọmọ ngme rọ mhila li abi a ya ke lu ọni ọmọ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ọọ wẹ, e rue emini a kẹkẹ emhi ẹ shi ali ugba na luẹ. Ọ kẹkẹ khi, “Eva oyọli khi iJọni.” O ri abọ sha wẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Utoghuokpe, unu oyọli o khueghie-a, ọọ ngme, ọọ kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ulishi oo mu idogbapfẹ eghọ nya. Oni ungmemhi ẹgbọ nya e ke ngme asha kpa ekẹ iJudia. ");
INSERT INTO atgNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","O ri abọ sha ọgbọkpa ni ọ suọ oni ungmemhi. Ee mhila, “Ọmọ nabi sẹ ọna ọ ya khi?” Irari khi obọ oyi Ẹshinẹgba o nu ọli la. ");
INSERT INTO atgNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ayẹmhẹ-nọ-pfuasẹ ọ tiemhile shi iZakaraya ita ọni ọmọ ọ. Ọọ ngme ungmemhi aguele, ọọ liẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ikuẹghiẹ o khi na Ẹshinẹgba Ọnọmhuẹ ọyi iZirẹni, itobọ khi ọ she bhale ya pfa ẹgbọ iZirẹni eyọli shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ọ rọte unuẹkpẹ oyi iDefidi, ọmọ ọyọli, mu adenọmọ Ọmiepfuese vule na anye. ");
INSERT INTO atgNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Abi ọ li rọte unu emekẹguele ni e pfuasẹ eyọli ena ẹlẹlẹ shobọ, ");
INSERT INTO atgNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","khi lọli ya tsumhi awa obọ oyi ebe awa ali eni ẹ biselemhi awa. ");
INSERT INTO atgNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ali khi lọli ya somhelemhi itita awa, ni sato ishobọ oyọli ni ọ shi na wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ikhi isheli ni ọ romhi shi emini ọ gueyẹ ita awa Aburaamu, ");
INSERT INTO atgNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","khi lọli ya rue awa obọ oyi ebe awa le, ini awa khi ri ulishi ga luẹ ");
INSERT INTO atgNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","elemhi ipfuasẹ ali ingeli enete, agbọagbọ kpa. ");
INSERT INTO atgNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yẹyẹ omimhẹ, a ya luẹ ọmekẹguele ọyi Ẹshinẹgba nọ Yagha nẹ Nya; irari khi u ya ralo ya bẹ odẹ-a khẹ Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni u rọ gueyẹ ẹgbọ eyọli khi rọte igbe-olamhẹ-kua na wẹ, e te ya mhọli imiepfuese. ");
INSERT INTO atgNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Irari khi Ẹshinẹgba ọyawa ọọ mhọli ilẹlemhi, ọ ya zẹ ni ovọ imiepfuese oyọli o te idane ngale shi awa ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ali ni o rọte idane gẹ nga eni e la alo ebili egbe ali eni e la okhẹna eghuli. Ni ọ ri awa te odẹ opfọmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ighọ ọni ọmọ ọ lii fu, ọ lẹsẹ ingme. Ọ la ifui ọdagbe ifufu ramhi ẹghẹghẹ ni ọ rọ lasele tse abọ ungmemhi oyi Ẹshinẹgba yẹ ẹgbọ iZirẹni. ");
INSERT INTO atgNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ẹghẹghẹ aghọ, Oghie Ọgọsitọsi iSiza ọ shi ushi a ka leli ẹgbọ ni e la ishishi ni igọmẹti iRomu e mhẹsẹ shi nya. ");
INSERT INTO atgNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ona o ya khi ileli ẹgbọ oni ododẹ ni a kpẹ mẹ ẹghẹghẹ ni iKuirinusi ọ rọ khi igọvunọ shi ekẹ iSiria. ");
INSERT INTO atgNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ọgbọgbọ ọ je apfẹ oyọli ya kẹkẹ eva shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","IJosẹfu ọ te ẹoli iNazarẹti ona ekẹ iGalili li je iBẹtilẹẹmu ona ekẹ iJudia apfẹ oyi itali ni a bia oghie ni a lu iDefidi shi, ọni iJosẹfu ọ khi unuẹkpẹ oyi iDefidi. ");
INSERT INTO atgNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ọ rue iMeli ni ọọ gue ughuẹ mhuẹ obọ je oobọ li ya kẹkẹ eva shi ekẹ. Ọni iMeli ọ she mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Abi e rọ la oobọ, oku oo to iMeli. ");
INSERT INTO atgNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ọ bia ọmọ ọmọse ni ọ khi ọmọdiọli. Ọ ri ide gẹnọ li yẹshi ukpẹko ni a ri eminale ẹ shi na elamhakọ le. Ogba ni a sọ elamhakọ shi ọ bia li shi, itobọ khi ẹa mẹ asha kushi ashini ẹgbọ e ku a shi. ");
INSERT INTO atgNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eni e ri elamhakọ ẹ kia eghuo, e la oni ukiẹkiẹ oni ẹoli ri ẹloe e khu elamhakọ eyẹwẹ ẹliyọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ighọ agẹni ọyi Ẹshinẹgba ọ bhale deba wẹ aghọ, ufumhi oyi Ẹshinẹgba o gẹ nyanyanya gasẹ wẹ, ulishi o mu wẹ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ọni agẹni ọọ wẹ, “A khi zẹ ni ulishi o mu ẹ, irari khi usomhi onete ni o ri oghẹlẹ oniẹmhi ya ghi ọgbọkpa mhi rọ bhale ghi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Irari khi ogbe ni amo ena, a she bia ọmiepfuese shi ẹoli oyi iDefidi na ẹ. IKirisiti Ọnọmhuẹ lọ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Emini o ya rọkhasẹ ẹ khi, a ya mẹ khi a ri ide gẹnọ ọmọfẹ shi ukpẹko ni a ri eminale ẹ shi na elamhakọ le.” ");
INSERT INTO atgNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Udemhija, igẹni ebubu e lasele, e bhale ya ku ma ọni agẹni, ee to uwolo kuẹghiẹ Ẹshinẹgba. E liẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ufumhi o khi oyi Ẹshinẹgba ni ọ la obini o yagha nẹ. Opfọmhẹ o la ekẹ agbọ na ni ọ mhuẹ isomhelemhi na.” ");
INSERT INTO atgNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Abi eni igẹni e rọ pfi eni e ri isumha ẹ kia shi aghọ nga idane se, e gueyẹ egbewẹ, “Awa je ekẹ iBẹtilẹẹmu ya ri ẹloe mẹ onana ni Ẹshinẹgba ọ bhale ya gueyẹ awa.” ");
INSERT INTO atgNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ighọ e nyanya rọte aghọ vu ya je oobọ. E bhale ya ẹ iJosẹfu ali iMeli ali ọni ọmọ khi a rọli yẹshi ukpẹko ni a ri eminale ẹ shi na elamhakọ le. ");
INSERT INTO atgNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Abi eni e ri elamhakọ ẹ kia e rọ mẹ ọli se, ee gueyẹ ẹgbọ kpa emini ọni agẹni ọ gueyẹ wẹ idiegbe oyi ọni ọmọ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ẹgbọ nya ni e suọ emini eni e ri elamhakọ ẹ kia eghọ e ngme, o ri abọ sha wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ama iMeli ọ ri ingme enana nya shi udu, ọ sa ọ, ọ tọ ẹloe ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eni e ri elamhakọ ẹ kia ee je apfẹ, e to uwolo kuẹghiẹ Ẹshinẹgba irari ungmemhi ni e suọ ni e gbo ri ẹloe mẹ, abi a li gue ọli yẹwẹ te, ighọ e li ri ẹloe mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ẹlẹ eleli o ramhi ni a rọ ya shẹlẹ ọli a, a lu ọli eva iJesu, ni o khi eva ni agẹni ọyi Ẹshinẹgba ọ lu ọli neni a mẹ umẹmhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Abi ẹghẹghẹ irọpfuasẹ oyi iJosẹfu ali iMeli o rọ ramhi abi Ushi oyi iMosisi o ngme, iJosẹfu ali iMeli e rue ọni ọmọ bhale iJerusalẹmu deba Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Abi o li la ushi oyi Ẹshinẹgba khi, “Ọmọ ododẹ ni ọ khueghie ọkpotso elemhi a, ọ khada khi ọmọse ne, a ri ọni ọmọ ke nga Ẹshinẹgba obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A rue ipfeli inekhukhu aava rọ riẹlẹ iluasobo na li abi Ishi eyi iMosisi o ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ọmọse ọghuo ọ la ọ ni a lu iSamọ ni ọ la ekẹ iJerusalẹmu, Ayẹmhẹ-nọ-pfuasẹ o la li egbe. Ọ khi ọgbọ ni ọ guẹ ngeli ni ọ migha khẹ Ọmiepfuese ni ọ ya mie ẹgbọ iZirẹni pfuese. ");
INSERT INTO atgNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ayẹmhẹ-nọ-pfuasẹ ọ she kpẹ gueyẹ ọli khi ọa ya ghu-a neni ọ rọ ya mẹ iKirisiti ni Ẹshinẹgba ọ shobọ khi lọli ya rọ bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ayẹmhẹ-nọ-pfuasẹ ọ kpha li sọ, ọ rue ọli lo elemhi apfẹ na owa oyi Ẹshinẹgba abi ita iJesu ali inyọli e rọ rue iJesu bhale ni a rọ riẹlẹ na li abi Ishi eyi iMosisi o ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ISamọ ọ mu ọni ọmọ shi abọ, ọ kuẹghiẹ Ẹshinẹgba, ọọ, ");
INSERT INTO atgNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ita ni ọ funẹ, abi u li shobọ na mhẹ, zẹ ni u rọli tsẹ na mhẹ ni mhi ghu shi opfọmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Irari khi alo eyẹmhẹ, e she mẹ Ọmiepfuese ni u ghie bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ni u she rọ ghi agbọ nya. ");
INSERT INTO atgNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ákpá ni o ri ọghuẹmhẹ oyi Ẹshinẹgba a khasẹ ẹgbọ iJẹta na alo ebili, ni o ri ufumhi ẹ na iZirẹni ẹgbọ eyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Abọ e sha ita ali inyọ ọni ọmọ abi e rọ suọ khi a ngme eni ingmemhi ena shi ọni ọmọ egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ISamọ ọ sọ iromhi na wẹ, ọọ iMeli, “Eri ibhale oyi ọmọ ọnana ó ya ri ebubu ẹgbọ de, ọ ri ebubu vule ekẹ iZirẹni, ọ gbo khi irọkhasẹ ni ẹgbọ e ya ke ngme emini ẹa ti shi egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ni a rọ bhale ya ẹ khi osheli oyi isamhi eyi ebubu ẹgbọ e khueghie-a, yẹyẹ ọyẹ u ya mẹ oya abi ọni a sọ ọgbhọrọ udu.” ");
INSERT INTO atgNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ọkpotso ọghuo ni ọ khi ọmekẹguele ni a lu Ana, omi iFanuẹli na unuẹkpẹ oyi Asha, ọ li la akaghọ. Ikpe ishilua ọ nu ọdọli la ughuẹ ni ọni ọdọli ọ rọ ghua. ");
INSERT INTO atgNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ọni ọkpotso ọna ọa gbo ye ughuẹ ramhi ni ọ rọ gbe ikpe egbhuẹne ali ene. Ọa gbo tigbe rọte Owa oyi Ẹshinẹgba vu. Ọọ pfi azumhi ẹlẹ ọguota ali ẹlẹ iyọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Abi ọ rọ lole deba iJosẹfu ali iMeli oni ẹghẹghẹ, ọ kuẹghiẹ Ẹshinẹgba, Ọ gue ingme oyi ọni ọmọ yẹ ẹgbọ kpa ni e la aghọ ni e migha khẹ ipfashekẹ oyi iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Abi iJosẹfu ali iMeli e rọ riẹlẹ abi Ishi eyi iMosisi o ngme se, ee je apfẹ oyẹwẹ obini iNazarẹti na ekẹ iGalili. ");
INSERT INTO atgNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ọni ọmọ ọọ fu, ọ mhuẹ ekpabọ, ọ mhọli ilẹsingme khi ilẹsingme, ekpabọ oyi Ẹshinẹgba o la li egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ukpe kpa ita iJesu ali inyọli e rọ je iJerusalẹmu ya li ukpe iPasova. ");
INSERT INTO atgNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Abi iJesu ọ ke rọ gbe ikpe igbẹva, e ye shi ukpe iPasova oyẹwẹ abi e kie kpẹ ẹ li. ");
INSERT INTO atgNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oni ukpe o pfo li se, itali ali inyọli ee je apfẹ, ama iJesu ọ kie la iJerusalẹmu, itali ali inyọli ẹa lẹsẹ khi ọ kie la ukhokho. ");
INSERT INTO atgNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E dabi khi ọ nu wẹwẹ kia. E she kia ẹlẹghuo gbada ẹa mẹ ọli, e nono ọli ifuabọ apfẹwẹ ali emọle wẹ ni e ga kia. ");
INSERT INTO atgNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Abi e rọ mẹ khi wẹwẹ ẹa mẹ ọli, e nyenẹ egbe ukhokho je iJerusalẹmu ya nono ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ẹlẹ nuzi-esẹ, e tigbe mẹ ọli khi ọ la owa ugamhi nu esẹsẹ Ishi eyi iMosisi shitọ, ọ ku esọ-a a shi emini e sẹsẹ, ọ mhila wẹ omhila. ");
INSERT INTO atgNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ilẹsingme oyọli ali abi ọ li i gbaghiẹ ogbọ-a, o ri abọ sha ọgbọkpa ni ọ suọ li. ");
INSERT INTO atgNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Abi itali ali inyọli e rọ mẹ ọli, abọ e sha wẹ. Inyọli ọọ li, “Ọmọ elọ o zẹ ni u rọ li anye na? Odẹ o she nuẹ ni anye te ẹ nono ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","IJesu ọ mhila li, “Elọ o zẹ ni a rọ nono mhẹ? Aa lẹsẹ khi mhi mema ya la owa oyi itamhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama ọa ye wẹ abi ọ li sọ wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ighọ ọ li deba wẹ je iNazarẹti, ọ ri ungmemhi oyi itali ali inyọli gbe akanya. Ama inyọli ọ gẹnọ ingme ena nya shi udu. ");
INSERT INTO atgNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ighọ iJesu ọọ womhẹloe elemhi ẹgbhali ali idiegbe, ẹgbọ ali Ẹshinẹgba e nono ingme oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Abi o rọ gbe ikpe igbẹshe ni oghie iSiza ni a lu iTibẹrusi ọ rọ khi oghie, oni ẹghẹghẹ iPọtiusi iPaleti ọ rọ li khi igọvunọ shi ekẹ iGalili ali ekẹ iJudia. Ẹghẹghẹ aghọ Erọdu ọ rọ ọ mhẹsẹ shi ekẹ iGalili. Inyọghuo ọli, ikhi iFilipu ọ mhẹsẹ ẹ shi ekẹ Iturea ali ekẹ iTirakọnitisi. Oghie iLisaniasi, ọ mhẹsẹ shi ekẹ Abilini. ");
INSERT INTO atgNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ẹghẹghẹ ni Anasi ali iKefasi e rọ khi eni e kpeda nya na ekpodalo-ugamhi eyi Ẹshinẹgba, Oni ẹghẹghẹ ungmemhi oyi Ẹshinẹgba o rọ bhale deba iJọni omi iZakaraya, elemhi ifu ọdagbe ifufu. ");
INSERT INTO atgNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ọ rọ tse abọ ekẹ iJọdani nya kiakia. Ọ liẹ, “A mu nyenẹ rọte olamhẹ eyẹẹ lasele ni a batazi ni a rọ gbe olamhẹ eyẹ ẹ kua na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Abi a li kẹkẹ ọli shi ebe Azaya ọmekẹguele, ni ọ rẹ, “A ya suọ khi ọgbọ ọ la ifu ọdagbe ifufu ẹ tsẹsẹ. Ọọ liẹ, riẹlẹ odẹ shi ekẹ khẹ Ọnọmhuẹ, ‘Bẹ odẹ ni o sheshe na Ọnọmhuẹ’ ");
INSERT INTO atgNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A ka tsua ekẹ suli igbilimhi ekẹ nya, a gbọmọ ute ọgbọgbọ tiemhie ekẹ, e mele ugbẹrekẹ-a. A ka ri odẹ na gẹnẹ-gẹnẹ mele eni sheshe-a, ena fuọnyọ-fuọnyọ, a ku wẹ gbe lẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ọgbọkpa ọ ya mẹ Imiepfuese oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ebubu ẹgbọ e fiẹ bhale deba iJọni ni ọ batazi wẹ, iJọni ọ rẹ wẹ, “Ẹẹ enyẹ ifue, ọghuo ọ tse agua yẹ ẹ a na, khi ẹghẹghẹ ofu oyi Ẹshinẹgba ọọ bhale? ");
INSERT INTO atgNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","A ke ngeli angeli imu-nyenẹ, a khi ke liẹ, ‘Aburaamu ọ khi ita anye.’ Irari khi abi o li mhi li gue ọli ẹ yẹ ẹ khi, Ẹshinẹgba ọ dobẹ ya rọte echẹ ena wolọ eniyẹ lasele na Aburaamu. ");
INSERT INTO atgNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A she rue uze shi ekẹ ni a rọ ya rọte imhili ẹẹra te eni ẹẹra gbe, ọọra kpa ni ọa da mọ udumhi onete ne, eri a ya tọli gbe, a tosẹ ọlia.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eni ẹgbọ e mhila iJọni, “Sẹ anye ke li ya kia mena?” ");
INSERT INTO atgNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","IJọni ọọ wẹ, “Ọni ọ mhuẹ iwulu eva ọ ka rue oghuo ọ na ọgbọ ni ọa mhuẹ. Ọni ọ mhuẹ eminale ọ ka kemhi na ọni ọa mhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Emionoga eghuo e li bhale deba li ni a batazi wẹ. Ẹẹ ọli, “Ọsẹsẹ, sẹ anye li ya kia?” ");
INSERT INTO atgNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ọọ wẹ, “A khi ke miono oga dọsẹ ingmẹ ni ẹẹ a ke miono.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ekhọli-okhuẹ eghuo e mhila li, “Sẹ anye li ya kia?” Ọọ wẹ, “A khi ri itoto rue ikpaghọ ni ẹa khi e yẹ ẹ, a khi ke gbo gue ingme ni ẹa la ọgbọ egbe shi ọli egbe. A zẹ ni ifata eyẹ ẹ e bu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Egbe e mu eni ẹgbọ, e ri udu oyẹwẹ khọkhọ ini iJọni ọ khi ọni Ọmiepfuese ni áá ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ama iJọni ọọ wẹ, “Amẹ mhi rọ batazi ẹ, ama ọgbọ ọọ bhale ni ọ toto dọsẹ mhẹ, ẹkuẹ ni ọ sọ shi owẹ, mhi aa fu tẹ ni mhia taghiẹ ọli-a. Ọ ya ri Ayẹmhẹ-nọ-pfuasẹ ali erali batazi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ọ mu ukpokpo ni a tọ akhuli ni o zẹ epfia sọ oyọli mhuẹ obọ. Lọli ọ rọ la ashini a la kpishi ado a ke pfie ado-a. Ọọ ti egbegbi ado ni e la ọ ọ gbili, ọ sọ wẹ ẹ shi ikpulu tsua ya shi owa eminale. Ama ọ ya ri erali ni ẹa ya a pfu ghue tosẹ efuẹwẹ-a.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Odẹ ebubu iJọni ọ te tse abọ ungmemhi oyi Ẹshinẹgba yẹ wẹ, ọọ liẹ wẹ e mu ingeli eyẹwẹ pfi. ");
INSERT INTO atgNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","IJọni ọ gue emhi ebubu yẹ oghie Erọdu ni ọọ riẹlẹ ni ẹa ti, ali ọ gbo gueyẹ ọli khi ọa guẹ kia ni ọ rue Ẹrodiasi ni ọ khi ughuẹ iFilipu inyọghuo ọli shi. ");
INSERT INTO atgNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Itobọ ona, Erọdu ọ riẹlẹ ingmobe ni o rue nga ọ, ọ ya mu iJọni shi owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Abi iJọni ọ rọ batazi eni ẹgbọ ọ se, ọ li batazi iJesu. Abi iJesu ọ li sọ iromhi, idane o khueghie-a. ");
INSERT INTO atgNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ayẹmhẹ-nọ-pfuasẹ ọ li abi anekhukhu rọte idane tiemhile shi ọli egbe. Uruli o rọte idane ngme, ọọ, “Omimhẹ u khi. Mhi i nono ingme oyẹ gba, irari khi u ma ri egbe ẹ mu mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ikpe uye ali igbe iJesu ọ gbe ni ọ rọ gbe ikanya eyọli ekẹ le. Ọ khi omi ọmọse ni a lu iJosẹfu abi ẹgbọ e kie li khọkhọ li shi, iJosẹfu ni ọ khi omi Eli. ");
INSERT INTO atgNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Omi iMatati ni ọ khi omi iLẹvi, ni ọ khi omi iMẹlki, ni ọ khi omi iJana, omi iJosẹfu. ");
INSERT INTO atgNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ni ọ khi Omi iMatatiasi, omi Emọsi, omi iNaumu, omi Esili, omi iNagai, ");
INSERT INTO atgNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Omi iMaati omi iMatatiasi, omi iSemeini, omi iJosẹchi, omi iJoda, ");
INSERT INTO atgNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Omi iJoana, omi iResa, omi iZerubabẹli, omi iShalitieli, omi iNeri. ");
INSERT INTO atgNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Omi iMẹlki, omi Adi, omi iKosamu, omi Emadamu, omi Eri, ");
INSERT INTO atgNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","omi iJoshua, omi Eliaza, omi iJorimu, omi iMatati, omi iLẹvi, ");
INSERT INTO atgNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","omi iSamọ, omi iJuda, omi iJosẹfu, omi iJonamu, omi Eliakimu. ");
INSERT INTO atgNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Omi iMelea, omi iMena omi iMatata, omi iNatani, omi iDefidi, ");
INSERT INTO atgNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","omi iJese, omi Obẹdi, omi iBoazi, omi iSamọ, omi iNashọni, ");
INSERT INTO atgNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","omi Aminadabu, omi Adimi, omi Ani, omi Ezirọni, omi iPẹrẹzi, omi iJuda, ");
INSERT INTO atgNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Omi iGiekọpu, omi Aziki, omi Aburaamu, omi iTẹra, omi iNaọ. ");
INSERT INTO atgNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Omi iSẹrugu, omi iRẹu, omi iPẹlegi, omi Eba, omi iShẹla, ");
INSERT INTO atgNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","omi iKenani, omi Afazadi, omi iShẹmu, omi iNoa, omi iLameki, ");
INSERT INTO atgNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Omi iMẹtusẹla, omi Enọki, omi iJarẹdi, omi iMaalalẹli, omi iKena, ");
INSERT INTO atgNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","omi Enọshi, omi iSẹti, omi Adamu, Omi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","IJesu ọ rọte okẹ iJọdani jele, Ayẹmhẹ-nọ-pfuasẹ ọ vọli egbe. Ọni Ayẹmhẹ ọ rue ọli je ọdagbe ifufu, ");
INSERT INTO atgNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ọkphaghiẹ ọ la oobọ mu ọli fẹ elemhi ogbẹlẹ egbhuẹva. Ọa le emhikhọghuo ogbẹlẹ ingmẹ ni a ngme ena. Ikpukhokho ọ okiamhi oo gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ọkphaghiẹ ọọ li, “Ini u lẹsẹ khi Omi Ẹshinẹgba u khi, wẹẹ oni ẹchẹ ona o mele ibulẹdi-a.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ama iJesu ọọ li, “A she kẹkẹ ọli shi Ebe-no-pfuasẹ khi ọa khi eminale tsẹ o ri agbọ a na ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ighọ ọkphaghiẹ ọ rue ọli nga ashini o yagha egbegbọ, ọ ri eghiele na agbọ nya khasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ọọ li, “Mhi ya ri itoto ali ẹpfue ni e la agbọ nya nẹ, irari khi a she rẹwẹ na mhẹ, ọni ọ ghọle mhẹ mhi ya rue wẹ na. ");
INSERT INTO atgNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Irarighọ, lẹsẹ nyẹsẹ ukhomhi na mhẹ tsẹ, eyẹ ena nya e ke ya khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","IJesu ọ rọ oli, “A she kẹkẹ ọli shi ebe no pfuese. Ke ga Ọnọmhuẹ Ẹshinẹgba oyẹ, lọlighuo kpe u ya ke ga.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ọni ọkphaghiẹ ọ ke rue ọli bhale iJerusalẹmu, ọ rọli migha ashini o yagha nẹ ukhomhi owa ugamhi oyi Ẹshinẹgba, ọọ li, “Ini Omi Ẹshinẹgba u khi, te akana ji tiemhi.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Irari khi a she kẹkẹ ọli shi Ebe-no-pfuasẹ khi, “ ‘Ẹshinẹgba ọ ya ghie igẹni eyọli, e ka kpe abọ rue.’ ");
INSERT INTO atgNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","E ya ri abọ tsua ẹ idane, ini u khi khi owẹ shi ẹchẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","IJesu ọ oli, “A she kẹkẹ oli shi Ebe-no-pfuasẹ, ‘Khi mu Ọnọmhuẹ Ẹshinẹgba ọyẹ fẹ bino.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ọni ọkphaghiẹ ọ mu iJesu fẹ se, o zẹ ọli obọ ne, ọ ke migha khẹ ẹghẹghẹ olese. ");
INSERT INTO atgNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","IJesu ọ nyenẹ egbe bhale iGalili, ekpabọ eyi Ayẹmhẹ-nọ-pfuasẹ e rọli gbe ikanya. A suọ eko ingme oyọli asha khi asha. ");
INSERT INTO atgNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ọ la owa ugamhi oyẹwẹ sẹsẹ. Wẹwẹ nya e kuẹghiẹ oli. ");
INSERT INTO atgNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ọ je ekẹ iNazarẹti obini ọ la fu vule, ighọ ogbẹlẹ iyẹmhẹa, ọ lo owa ugamhi abi ọ kie kpẹ ẹ li. Ighọ ọ vule migha a zẹ ebe. ");
INSERT INTO atgNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","A rue ebe oyi Ọmekẹguele Azaya mhọli ọli obọ. Ọ naghiẹ ọli-a, Ọ mẹ ashini a kẹkẹ ọli shi khi. ");
INSERT INTO atgNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ayẹmhẹ oyi Ẹshinẹgba ọ la mhẹ ọ, irari khi ọ she zẹ mhẹ ni mhi ke gue usomhi onete oyi Ẹshinẹgba yẹ eni ẹa mhuẹ. Ọ ghie mhẹ mhi guele khi mhi ya rue eni a mu shi owa ighumha lasele, ni mhi khueghie ezalo alo-a, mhi pfuese eni a na osoli. ");
INSERT INTO atgNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ni mhi rọ gue le khi isomhelemhi oyi Ẹshinẹgba o she ramhi.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ọ zẹ se, o khili oni ebe, ọ rue ọli na ọni ọ ri ẹloe a khu oni ugamhi, Ọ shitọ, ighọ ọgbọkpa ni ọ la oni owa ugamhi ọ wolọ alo shi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ighọ ọli gueyẹ wẹ, “Amo, emini mhi zẹ lẹna o bhale ya tsẹ shi ẹ esọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ọgbọkpa ọ ngme onete oyọli. Abi e rọ bhale ya ẹ ingmemhi ọnyaloa ni e rọte ọli unu u lasele, e mhila, “Ọna ọa she khi omi iJosẹfu?” ");
INSERT INTO atgNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","IJesu ọọ wẹ mhi lẹsẹ khi a ya ri ekpita liẹ mhẹ, “Ọbo, ri egbe ẹ ze. ‘A ya gbo liẹ mhẹ la akana gbe ikanya ọnyaloa ni u gbe obini iKapanọmu.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Abi o li mhi li gue ọli ẹ yẹ ẹ khi, aa mu ekpẹ ẹ na ọmekẹguele ẹoli oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mhi gueyẹ ẹ khi esamhi-olimhi ebubu e la ekẹ iZirẹni ẹghẹghẹ oyi Elaja, ni amẹ o rọ mu ikpe esẹ ali ukhukhui ni ukpokpomhi okiamhi o rọ pfi oni ekẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Abi o tseku khi ighọ, aa ghie Elaja ghi ọngẹwẹ ọkhọghuo, sẹ ni ọsamhi-olimhi na iZarifati ni ọ la ekẹ iSidọni. ");
INSERT INTO atgNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ebubu ẹgbọ ni efafe e mu e gbo la ekẹ iZirẹni ẹghẹghẹ oyi Elasha Ọmekẹguele, ni o rọ khia khi aa mẹ ọngẹwẹ ọkhọghuo ni a rọ ze, sẹ ni iNamani ọngi iSiria.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ighọ elemhi e li bi eni e la elemhi oni owa ugamhi nya abi e rọ suọ ungmemhi ona. ");
INSERT INTO atgNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ighọ e vule khu ọli oni ẹoli ya fiẹ. E rue ọli bhale esesọ ute oyi oni ẹoli, ni wẹwẹ e ba pfi ọli ya tiemhi. ");
INSERT INTO atgNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama ọ rọte wẹ ifuabọ ya lase, ọ vu. ");
INSERT INTO atgNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ighọ iJesu ọ tiemhi ẹoli iKapanọmu ni o la iGalili ẹlẹ iyẹmhẹa, ọ sẹsẹ eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Emini ọ sẹsẹ wẹ e ri abọ sha wẹ, irari khi ekpabọ e la ungmemhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ọmọse ọghuo ọ la oni elemhi owa ugamhi ni ọ mhuẹ ayẹmhẹ ọkphaghiẹ. Ọ tsẹsẹ leghe. ");
INSERT INTO atgNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ghi ẹ! Elọ wa nono anye egbe, iJesu na iNazarẹti? Eri u bhale ya pfuse anye-a? Mhi lẹsẹ ọni u khi, yẹyẹ u khi ọni ọ pfuasẹ ọyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ighọ iJesu ọ tsẹsẹ ku ọli, “Khukhu unu, rọte ọli egbe lasele.” Ighọ oni ayẹmhẹ ọkphaghiẹ o mu ọni ọmọse pfi ekẹ kpọ ukpẹloe oyi eni ẹgbọ nya, ọ lase ọli egbe le, ama ọa kuale ọli utse. ");
INSERT INTO atgNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Oni ingme o ri abọ sha eni ẹgbọ, e mhila egbe, “Obo áá mẹ osẹsẹ onana? Itobọ khi afu ali ekpabọ ọ rọọ mhẹsẹ na iyẹmhẹ ọkphaghiẹ, eni iyẹmhẹ e suọ esọ na li, e na ya lase!” ");
INSERT INTO atgNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ighọ eva oyọli o gbhiaku ashakpa. ");
INSERT INTO atgNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","IJesu ọ te oni owa ugamhi fiẹ, ọ je owa oyi iSamọ, ọ bhale ya ẹ khi iba ne funẹ ee to ọgọ iSamọ ọni ọkpotso. E gueyẹ iJesu ọ kpaghiẹ ọni ọkpotso obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ighọ iJesu ọ nyẹsẹ egbe ti mama li, ọ khu eni iba, ighọ eni iba e lase ọli egbe le. Aghọaghọ ọni ọkpotso ọ vule, ọọ fẹli wẹ epfẹse. ");
INSERT INTO atgNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Abi ogbọmhi o ke rọ mu ekẹ, a tsua ebubu ẹgbọ ni e mhọli ighuamhi ọdọda bhale ghi iJesu, ọ ri obọ nga wẹ ukhomhi, ọ rẹwẹ ze nya. ");
INSERT INTO atgNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iyẹmhẹ ebe e gbo li rọte ebubu ẹgbọ egbe ya lase, eni iyẹmhẹ e tsẹsẹ, e liẹ, “Omi Ẹshinẹgba u khi oo!” Ama iJesu ọ dese wẹ, ọa zẹ ni e ngme, irari khi e lẹsẹ ọli khi Ọmiepfuese ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ogbe o gbe-a, iJesu ọ te oni ẹoli je ashini o da-ya, eni ẹgbọ ee nono ọli. Abi e rọ mẹ ọli, ẹa ke zẹ ọli vu. ");
INSERT INTO atgNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama ọ gueyẹ wẹ, “Mhi mema ya gue ungmemhi onete oyi Eghiele oyi Ẹshinẹgba yẹ ẹoli eni e kpọle, itobọ khi emini o zẹ ni Ẹshinẹgba ọ rọ ghie mhẹ bhale na.” ");
INSERT INTO atgNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ighọ ọ kiele tse abọ kia eni owa ugamhi ni e la ekẹ iJudia gasẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ogbẹlẹghuo khi iJesu ọ nu ẹgbọ migha ukiẹkiẹ okẹ ni o khishi na iGẹnẹsarẹti, eni ẹgbọ e le gasẹ ọli ri esọ ọ shi ungmemhi oyi Ẹshinẹgba ");
INSERT INTO atgNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ọ mẹ ọkọ-okẹ eva epfepfẹ oni okẹ, ni ẹgbọ eni ẹ gbe ifẹlẹ e zẹ obọ shi aghọ. Eni ẹgbọ ee yẹghẹ iga ni e rọọ gbe ifẹlẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","IJesu ọ lo elemhi oghuo ni o khi oyi iSamọ, ọọ iSamọ ọ gua li ti lase oni egele oni okẹ dẹnẹ. Ighọ ọ shitọ oni ọkọ-okẹ oniẹmhi, ọọ sẹsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Abi ọ rọ sẹsẹ wẹ se, ọọ iSamọ, “Pfi aga lo ashini o limhi ni ọ mu ifẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ISamọ ọọ li, “Ọga, a-ooyọsẹ anye te ẹ rọshẹka ini anye mu ifẹlẹ, anye a mu emhikhọghuo. Ama itobọ khi u ngme ghọ, mhi ya pfi aga lo.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Abi e rọ pfi aga lo oni okẹ, e mu ifẹlẹ ni e bububu, ni o ri aga eyẹwẹ kphuru-a. ");
INSERT INTO atgNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ighọ e ri obọ lu apfẹwẹ ni e ga rọ gbe ifẹlẹ, ẹẹ e bhale ya kpaghiẹ wẹwẹ obọ. E muno eni ifẹlẹ kulo ọkọ-okẹ eni e kpọle. Eni ọkọ-okẹ e vọ ifẹlẹ ya ramhi unu, ni eni ifẹlẹ e rọ khọsẹ eni ọkọ-okẹ ramhi ni e rọ tiemhi udi okẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Abi iSamọ iPita ọ rọ mẹ ona, ọ de ya yẹshi awẹ eyi iJesu, ọọ li, “Kpẹkpẹ ke vu ni u zẹ mhẹ obọ, irari khi ọna olamhẹ mhi khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Abọ e sha li ali ẹgbọ ni e nu ọli la aghọ, itobọ ifẹlẹ ebubu ni e mu. ");
INSERT INTO atgNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ighọ abọ e li sha iJemhisi ali iJọni imi iZebedi, ni e khi enuzava eyi iPita. Ighọ iJesu ọọ iSamọ, “Khi ke na ulishi. Rọte amo vu, ẹgbọ u ke ẹ ke muno.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ighọ e tialọ ọkọ-okẹ oniẹmhi eyẹwẹ ngale egele. ");
INSERT INTO atgNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Abi iJesu ọ rọ la ẹoli oghuo, ọmọse ọghuo ni efafe e mu ọ bhale deba li. Abi ọni ọmọse ọ rọ mẹ iJesu, ọ de ya yẹshi ọli odalo, ọ lema li, ọọ li, “Ọnọmhuẹ, ini o ghọle ẹ, u dobẹ ya rẹmhẹ ze.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","IJesu ọ nise obọ-a rọ ti ọni ọmọse, ọọ li, “O ghọle mhẹ, khi ọni ọ ze.” Aghọaghọ eni efafe e lase ọli egbe le. ");
INSERT INTO atgNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ighọ iJesu ọ tse agua yẹ ọli, ọọ li, “Khi gueyẹ ọgbọkhọghuo, eri-tsẹ ka ri egbe ẹ khasẹ ọkpodalo-ugamhi ni u riẹlẹ iluasobo ikhuẹ-pfuasẹ ni iMosisi ọ mhẹsẹ na ẹ, ẹghẹghẹ aghọ ni o khi ọtsẹlẹ na wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ighọ ingme oyọli oo gbhiaku shi ọ. Ebubu ẹgbọ e bhale deba li ni e rọ mẹ asha suọ ungmemhi oyọli ali ni ọ gbo rẹwẹ ze elemhi iwali ighuamhi ọdọda. ");
INSERT INTO atgNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama eri iJesu ọọ bi egbe-a je ashini o da-ya, ọ ya sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ẹlẹghuo abi iJesu ọ li sẹsẹ, ẹgbọ iFarisi ali eni ẹẹ sẹsẹ Ishi eyi iMosisi ni e te ẹoli iGalili ali ekẹ iJudia ali iJerusalẹmu bhale, e shitọ aghọ. Ighọ Ẹshinẹgba ọ li ri ekpabọ na li rọ ri eni ẹẹ ghua toto. ");
INSERT INTO atgNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ẹgbọ ni e tsua ọmọse ọghuo ni ọ ghu abọ ali awẹ a bhale, e nono abi e li ya rọli lo oni owa bhale odalo oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Abi e ke rọ mẹ khi wẹwẹ ẹa mẹ asha, itobọ khi ẹgbọ e bu dọsẹ, e nga ukhomhi oni owa, e ri ili gẹ ọli abi ọ yẹshi iya eghọ, e rọte ekpha rọli tiemhile shi iteva ẹgbọ, e rọ li shi odalo oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Abi iJesu ọ rọ mẹ abi irudunga oyẹwẹ oo fu, ọọ ọni ọmọse, “Ọmuẹ, a she gbe olamhẹ eyẹ kua nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eni ẹgbọ iFarisi ee sa udu oyẹwẹ, e liẹ, “Ọghuo ọni ọgbọ ọna ọ khi ni ọọ pfi unu-a, ọghuo ọ dobẹ ẹ gbe olamhẹ kua, sẹẹ ni Ẹshinẹgba lọlighuo?” ");
INSERT INTO atgNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","IJesu ọ lẹsẹ emini e sa, ọ mhila wẹ, “Elọ o zẹ ni a rọ sa isamhi enana a shi udu oyẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Onoghuo o ya kẹlẹ ọgbọ ngme nẹ? ‘A she gbe olamhẹ kua nẹ,’ ali, ‘Vule ke kia,’ ");
INSERT INTO atgNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Emini o zẹ ni a rọ mẹ na khi ni a rọ lẹsẹ lọ khi Omi Ọgbọ ọ mhọli afu shi elemhi agbọ ni a rọ gbe olamhẹ kua.” Ọọ ọni ọmọse ni ọ ghu abọ ali awẹ-a eghọ, “Mhiẹ u vule, rue iya oyẹ, ni u ke je apfẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Utoghuo kpe ọ vule migha odalo oyẹwẹ, ọ rue iya ni ọ rọ yẹshi mhuẹ obọ, ọ je apfẹ, ọọ kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Abọ e sha eni ẹgbọ nya, ee kuẹghiẹ Ẹshinẹgba. Abọ e sha wẹ, ulishi o mu wẹ, ee liẹ, “Awa mẹ ọshabọ amo.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Onana o dọsẹ se, ọ fiẹ lase, ọ mẹ ọmionoga ni a lu iLiva khi ọ shitọ elemhi okholo oyọli ni ọ la mie oga, iJesu ọọ li, “Deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ighọ iLiva ọ vule, ọ zẹ emini ọọ riẹlẹ obọ, ọ deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ighọ iLiva ọ nye ekhe, ọ lu ukpokpomhi ukue na iJesu shi apfẹ oyọli. Emionoga ebubu ali ẹgbọ elese ni e bu e li bhale shi oni ukue, e nu wẹ le emhi. ");
INSERT INTO atgNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ama ẹgbọ iFarisi ali eni e sẹsẹ ishi ee wọlọ khasẹ eniyẹ odukhokho eyi iJesu, ee liẹ, “Elọ o zẹ ni ọ rọ nu emionoga ali ena olamhẹ ẹẹ le eminale?” ");
INSERT INTO atgNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","IJesu ọ sọ wẹ ọ, ọọ wẹ, “Ọni ọọ to, ọọ ye apfẹ ọbo. ");
INSERT INTO atgNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mhi aa bhale ni mhi rọ ya lu ẹgbọ ni e pfuasẹ ne, ama ena olamhẹ mhi bhale ya lu, ni e rọ mhuẹ imiepfuese.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ẹgbọ eghuo e mhila iJesu, “Elọ o zẹ khi eniyẹ odukhokho eyi iJọni ali eniyẹ odukhokho eyi iFarisi ẹ pfi azumhi, ni eyẹ e rọ le ni e rọ da?” ");
INSERT INTO atgNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","IJesu ọ sọ wẹ ọ, “A liẹ mẹ ghọ khi a ri epfẹse ni e nu ọdọ ọmueshi ọnọgbọ shitọ ọ pfi azumhi, ini ọni ọdọ ọmueshi ọ nu wẹ la aghọ? ");
INSERT INTO atgNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama khi ẹghẹghẹ ọọ bhale ni a rọ ya rue ọdọ ọmueshi iteva oyẹwẹ le, ẹghẹghẹ aghọ, e ya pfi azumhi.” ");
INSERT INTO atgNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ọ zẹ okhẹ irọkhọkhọ onana khasẹ wẹ, ọọ, “Ọgbọkhọghuo ọa ya khi ode onogbọ ya gbẹla ma ode onodiọ, ini ọ lighọ, eri ọ mema ya khi oni ode onogbọ-a shi afuẹ. Ini a gbẹla ode onogbọ ma onodiọ, ẹa ya li abeghuo. ");
INSERT INTO atgNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wẹkhi eri ọgbọ ọ ya ku onyọ onogbọ shi akpaba oyi ẹkuẹ-ẹlamhi onodiọ, ini ọgbọ ọ li ghọ, eri oni akpaba o ya nyanọ-a, oni onyọ o ku kua, oni akpaba o li opfu-a. Akpaba ẹkuẹ ẹlamhi ẹgbọ iJu e ku onyọ ọ shi. ");
INSERT INTO atgNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Onyọ onogbọ a ku ẹ shi akpaba onogbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aa mẹ ọgbọ ni ọ ya da onyọ onodiọ se, ni ọ tigbe ya mhila onyọ onogbọ, irari khi ọ ya liẹ khi onodiọ o ti nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ogbẹlẹ iyẹmhẹa, iJesu ali eniyẹ odukhokho eyọli e rọte ifu ishemhi iakpa dọsẹ, e bẹ eni iakpa mhuẹ abọ, e kphali ikpamhi wẹ le. ");
INSERT INTO atgNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ẹgbọ iFarisi eghuo, e mhila wẹ, “Elọ o zẹ ni a rọ gbe ushi ona ogbẹlẹ iyẹmhẹa-a?” ");
INSERT INTO atgNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","IJesu ọ sọ wẹ ọ, ọọ wẹ, “Aa kpẹ zẹ emini iDefidi ọ riẹlẹ abi okiamhi o rọ gbe ọli ali apfọli? ");
INSERT INTO atgNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Abi ọ li lo Owa oyi Ẹshinẹgba ya rue ibulẹdi ni a rọ ọ ga Ẹshinẹgba le, ni ọ gbo rọ na apfọli le. Eri a ghue oni ibulẹdi oghọ, sẹ ni ekpodalo-ugamhi eyi Ẹshinẹgba tsẹ ẹẹ le ọli.” ");
INSERT INTO atgNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Lọli iJesu ọ rọ ọọ wẹ, “Ọnọmhuẹ ọyi ogbẹlẹ iyẹmhẹa Omi Ọgbọ ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ighọ ẹlẹlese ni o khi ogbẹlẹ iyẹmhẹa, iJesu ọ la elemhi owa ugamhi sẹsẹ ẹgbọ. Ọmọse ọghuo ọ la aghọ ni obọ ita oyọli o ghua. ");
INSERT INTO atgNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Eni ẹgbọ iFarisi ali esẹsẹ Ishi eyi iMosisi e nono emini wẹwẹ e rọ ya mu umha-guẹkia shi iJesu obọ. Ighọ e li tọ ọli ọkpẹ ini ọ ya ri ọgbọ ze ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","IJesu ọ lẹsẹ isamhi eyẹwẹ ọọ ọni ọmọse ni ọ ghu obọ oghuo-a eghọ, “Vule migha ana, ni ọgbọkpa ọ lolo ke mẹ.” Ighọ ọni ọmọse ọ vule migha wẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","IJesu ọọ, “Mhiẹ i, onoghuo ushi oyi awa o lama shi ọgbọ ọ riẹlẹ ogbẹlẹ iyẹmhẹa? Ni a rọ riẹlẹ onete abi ni a rọ riẹlẹ onobe, ni a rọ tsumhi agbọ oyi ọgbọ, abi ni a rọ pfuse ọli-a?” ");
INSERT INTO atgNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ọ bino wẹ gasẹ nya, ọọ ọni ọmọse ọ nise obọ-a. Ọ lighọ. Oni obọ o nise a. ");
INSERT INTO atgNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama elemhi e bi wẹ egbegbọ, e gba ugbamhi abi e ya li iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ogbẹlẹghuo, iJesu ọ nga ute ya sọ iromhi. Ọ la aghọ ẹliyọsẹ ẹlẹghọ nya ọọ sọ iromhi lema Ẹshinẹgba ");
INSERT INTO atgNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Abi ogbe o rọ gbe-a, ọ luno eniyẹ odukhokho eyọli, ọ zẹ ogbava elemhi wẹ, ọ lu wẹ ighiusomhi na kẹẹ ");
INSERT INTO atgNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ISamọ, ni ọ lu iPita ali inyọghuo Aduru, iJemhisi, iJọni, iFilipu ali iBatolomiu. ");
INSERT INTO atgNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","IMatiu ali iTọmọsi, iJemhisi omi Afeusi, ali iSamọ, ni e lu iZilọti. ");
INSERT INTO atgNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","IJudasi omi iJemhisi, ali iJudasi Isikarọti ni ọ ri iJesu dẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Abi iJesu ali eniyẹ odukhokho eyọli e rọ rọte oni ute tiemhile, ọ migha ugbẹrekẹ, eniyẹ odukhokho eyọli ebubu e la aghọ. Ebubu ẹgbọ e la aghọ ni e rọte ukiẹkiẹ ekẹ iJudia nya ali ẹoli iJerusalẹmu ali ẹoli iSidọni ali ẹoli iTai ni e ngeli epfepfẹ okẹ oniẹmhi bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Eri e bhale ya suọ ingmemhi eyọli ali ni ọ gbo rẹ wẹ ze elemhi ighuamhi ọdọda. Eni ayẹmhẹ ebe e nasẹ e li bhale, ọ rẹwẹ ze. ");
INSERT INTO atgNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eni ẹgbọ nya e rọshẹka ri obọ ti ọli, irari khi itoto e te ọli egbe lasele, o rẹ wẹ nya ze. ");
INSERT INTO atgNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","IJesu ọ bino eniyẹ odukhokho eyọli, ọọ wẹ, “Ikhivọsẹ o khi na ẹẹ ni aa pfue, irari khi ẹẹ a mhọli Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ikhivọsẹ o khi na eni okiamhi ọ gbe memena irari khi a ya mẹ le khue. Ikhivọsẹ o khi na ẹẹ ni a viẹ memena, irari khi a ya gia. ");
INSERT INTO atgNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ikhivọsẹ o khi na ẹ, ini ẹgbọ ẹ biselemhi ẹ, ni e rọ kie ẹ, ni e rọ tsue ẹ, ni e rọ kie ẹ khi ẹgbọ ebe a khi, itobọ oyi Omi Ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“A ke ghẹlẹ ini a da mẹ ghọ. A gbe ishimhi irari khi a ri eleli ni o funẹ shi iloghie ẹ khẹ ẹ. Irari khi ighọ eni e bia wẹ e li nasẹ emekẹguele eyi Ẹshinẹgba ẹghẹghẹ oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ama, o ma khọlọ ẹ egbe, ikhi ẹẹ ni a mhuẹ ẹpfue memena, irari khi a she mie eleli oyẹẹ se. ");
INSERT INTO atgNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O ma khọlọ ẹ egbe, ikhi ẹẹ ni a she le khue memena, irari khi okiamhi o ya gbe ẹ. O ma khọlọ ẹ egbe, ikhi, ẹẹ ni a gia memena, irari khi a ya viẹ ẹ viẹ oya. ");
INSERT INTO atgNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","O ma khọlọ ẹ egbe, ikhi ẹẹ ni ẹgbọ ẹẹ ngme onete oyẹẹ, irari khi ighọ eni e bia wẹ e li ngme onete oyi emekẹguele eyi ẹgbhọli. ");
INSERT INTO atgNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mhi gueyẹ ẹ, ẹẹ ni a suọ mhẹ, a nono ingme oyi ọbe ẹẹ. A ke riẹlẹ onete na ẹgbọ ni ẹẹ biselemhi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","A ke sọ iromhi na ẹgbọ ni ẹẹ tsue ẹ, a sọ iromhi ke na ẹgbọ ni ẹa guẹ ẹ ngeli deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ini ọgbọ ọ lase ukiẹkiẹ esọ oghuo, nyenẹ oni o kpọle gbo na li lase. Ini ọgbọ ọ ri itoto mhiẹ awulu, gbo zẹ ni ọ rue oni u sọ kpọkẹ ma ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ke ri emini ọgbọkpa ọ mhila ẹ na li, ini ọgbọ ọ rue ẹ emhi, zẹ ọli obọ na li, khi gbo mhila li luẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngeli ke deba ọgbọ abi u liẹ nono ni a li ngeli deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ini o khia khi ẹgbọ ni e nono ingme oyẹ u lẹsẹ a nono ingme oyẹwẹ, ighe ikhivọsẹ ni o la ọ nẹ? Irari khi ena olamhẹ e lili ẹ nono ingme oyi ẹgbọ ni e nono ingme oyẹwẹ to ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ini o khia khi eni e riẹlẹ onete nẹ u lẹsẹ li ẹ riẹlẹ na, ighe ikhivọsẹ ni o ke la ọ nẹ? Egbegbi ena olamhẹ e lili ẹ lighọ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ini o khia khi eni e ngmomhi ẹ nẹ u lẹsẹ li ngmomhi ẹ na, ighe ikhivọsẹ ni o la ọ nẹ? Irari khi ena olamhẹ e li ngmomhi ẹ na egbewẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama zẹ ni u nono ingme ọbe ẹ, ke riẹlẹ onete na wẹ. Ke ngmomhi na wẹ, khi ngmomhi na wẹ ni u ke ri ẹloe shi ekẹ khi e ya fali ẹ ota to ọ. Ẹghẹghẹ aghọ ikhivọsẹ oyẹ o ya gbẹdi, u khi omi Ẹshinẹgba nọ Yagha nẹ Nya. Irari khi lọli ọọ somhi elemhi eni ẹa lẹsẹ obodẹ ali ena ọkhọlọ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Khi ọna ilẹlemhi, ẹzẹzẹ abi Ita ẹ ọ li khi ọna ilẹlemhi. ");
INSERT INTO atgNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Khi gue ọgbọ ẹzọ ini a khi li gue yẹyẹ ẹzọ, khi ri unu pfuẹchẹ ọgbọ-a, ini a khi li ri unu pfuẹchẹ-a. Gbekua na ọnuzava ọyẹ, ni Ẹshinẹgba ọ li gbe kua nẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Rọna khi a ya rọ nẹ. Ukiẹkiẹ onete, oni a lolo mimi, ni a jighise ni o tsua kua, a ya rọ somhiẹ opfa. Irari khi ukiẹkiẹ ni u rọ mhẹsẹ na ẹgbọ, Ẹshinẹgba ọ li rọ ya mhẹsẹ nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ọ gbo zẹ okhẹ irọkhọkhọ ona khasẹ wẹ, ọọ wẹ, “Ọzalo ọ fẹ dobẹ ya ri ọzalo nabi luẹ ke kia? Eri wẹwẹ aava e ya de pfilo uchokẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ọmọ ni ọ la owẹna ọa ya fu dọsẹ ọni ọọ sẹsẹ ọli, Eri-tsẹ ini ọmọ ni ọọ ye owẹna ọ ye owẹna oyọli se, ọ ya li abi ọni ọ sẹsẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Elọ o zẹ ni u rọọ mẹ uku ni o la inyọghuẹ ẹloe ni u waa rọ mekẹ mẹ ufolo ọara ni o pfida ẹloe oyẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sẹ u liẹ liẹ inyọghuẹ, ‘Inyọghuo zẹ ni mhi rue ẹ uku ẹloe a,’ ni yẹyẹ ọyẹ waa rọ mẹ ufolo ọara ni o pfi da ẹloe oyẹ? Yẹyẹ ọgbọ ọrugamhi ku alo, kpẹ todẹ rue ufolo ọara ni o la ẹloe oyẹ-a ni u tigbe mekẹ gboo rue uku ni o la inyọghuẹ ẹloe a. ");
INSERT INTO atgNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ọara ni ọa ti ọa dobẹ ya mọ ukpamhi onete, u ke ya liẹ khi eri ọara onete o ya mọ ukpamhi ni ọa ti. ");
INSERT INTO atgNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ikpamhi ni ọara ọọ mọ, a rọ ọ lẹsẹ ọara ni o khi. Aa rọte ọkphẹkphẹ ẹ pfanọ ọkhua-eni. ");
INSERT INTO atgNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Eri ọgbọ onete ọ rọte emini o ti ni ọ rọshi udu ẹ rue emini e ti lasele, Ama ọgbọ ọbe, ọ rọte udu obe oyọli rue emhi obe ni ọ rọshi udu ẹ lasele. Irari khi isamhi ebubu ni e la ọgbọ udu, ọ te ẹ ngme ungmemhi lasele. ");
INSERT INTO atgNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Elọ o zẹ ni a rọ lu mhẹ, ‘Ọnọmhuẹ, Ọnọmhuẹ,’ ni aa rọ ri emini mhia ngme gbe akanya? ");
INSERT INTO atgNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mhi ya rọkhasẹ ẹ abi ọgbọ ni ọ bhale deba mhẹ, ni ọ ri esọ ẹ shi mhẹ ekẹ, ni ọ gbo ri ingmemhi eyẹmhẹ a gbe ikanya ọ li. ");
INSERT INTO atgNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Eri ọ li abi ọgbọ ni ọ tọ owa, ọ tọnọ ekẹ-a limhi, ni ọ ri owa gbe ukhomhi ẹchẹ. Abi ukpokpomhi amẹ o rọ ruẹ, ochikpho o ri itoto ghi oni owa abọ, ama ọa dobẹ nighise ọli, irari khi eri a tọli egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama ọgbọ ni ọọ suọ ungmemhi oyẹmhẹ ni ọa rọ li gbe akanya, eri ọ li abi ọgbọ ni ọ tọ owa nga ekhashẹ. Abi amẹ o rọ ruẹ, ochikpho o ri itoto tsua oni owa, oni owa o de, o khi oyese oniẹmhi.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Abi iJesu ọ rọ ngme enana nya shi esọ eyi eni ẹgbọ se, ọ lo elemhi ẹoli iKapanọmu. ");
INSERT INTO atgNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oobọ a mẹ ọmọse ni ọọ ga ọkhọli-okhuẹ ọniẹmhi, ni ingme oyọli o lolo mu ọga ọyọli egbe. Ọni ọmọse ọọ ghu ughuamhi ni o rọli ramhi eghuli. ");
INSERT INTO atgNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Abi ọni ọkhọli-okhuẹ ọnọfunẹ ọ rọ suọ eko iJesu, ọ ghie egbhali eyi ẹgbọ iJu ghi ọli, ọ bhale ya ri ọni ọọ ga ọyẹluẹ ze. ");
INSERT INTO atgNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abi e rọ bhale deba iJesu, e lema li egbegbọ, ẹẹ iJesu, “Ọni ọmọse ọna, ọ khi ọni u kha kpaghiẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Irari khi ọ ma nono ingme oyi ẹgbọ eyi anye gba, ọ gbo tọ owa ugamhi na anye.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ighọ iJesu ọ deba wẹ vu. Ọ she kia a ramhi owa oyi ọni ọkhọli-okhuẹ ni ọ rọ ghie emọle ọli e liẹ iJesu, “Khi ke nasẹ egbe ẹ, mhia somhi ramhi ni u wa lo owa oyẹmhẹ le. ");
INSERT INTO atgNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Lọli o zẹ ni mhi rọ bino khi mhiaa ti ramhi ni mhi a bhale deba ẹ. Lẹsẹ ngme oni ungmemhi khi ọni ọọ ga mhẹ ọ ya ze. ");
INSERT INTO atgNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Irari khi mhẹmhẹ oyẹmhẹ, ọna omhẹsẹ mhi li khi, ni ekhọli-okhuẹ e li kpọkẹ na. Mhia mhẹsẹ na ọna, ‘Vu,’ ọ vu. Mhi mhẹsẹ na ọghọ, ‘Bhale,’ ọ bhale. Mhi gueyẹ oghumha ọyẹmhẹ, ‘Riẹlẹ ona,’ ọ riẹlẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Abi iJesu ọ rọ suọ oni ungmemhi ona, abọ e sha li. Ọ nyenẹ alo ukhokho bino ebubu ẹgbọ ni e deba li, ọọ wẹ, “Mhi gueyẹ ẹ khi mhia kie kpẹ mẹ irudunga ni o na fu ghue, mhia kpe mẹ ọli ekẹ iZirẹni ne.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ighọ eni a kpẹ ghie, e nyenẹ egbe je apfẹ oyi ọni ọkhọli-okhuẹ nọ funẹ, e bhale ya ẹ khi ọni ọọ ga li ọ she ze. ");
INSERT INTO atgNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Oo li dẹnẹ, iJesu ọ te aghọ vu, ọ je ẹoli ni a lu iNei, eniyẹ odukhokho eyọli ali ebubu ẹgbọ elese e deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Abi ọ li ti ramhi odẹ unuẹkpẹ ni a te ẹ lo oni ẹoli le, ọ mẹ khi a tsua ọgbọ ni ọ ghu-a a lasele. Lọlighuo kpe inyọli ọ mẹ bia. Ọni ọkpotso ọ gbo khi ọsamhi-olimhi. Ebubu ẹgbọ e rọte oni ẹoli vẹ deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Abi Ọnọmhuẹ ọ rọ mẹ ọni ọkpotso, ọ mhuẹ ilẹlemhi na li. Elemhi ọ e ala li, ọọ li, “Khi ke viẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ighọ ọ vu ya ri obọ ti oni akpati olimhi, ẹgbọ ni e tsua li e mu migha, iJesu ọ, “Ọni ọzẹo mhiẹ yẹ vule.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ighọ ọni ọmọse ni ọ ghu-a eghọ ọ vule shitọ, ọọ ngme. IJesu ọ mu ọli obọ na inyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ulishi o mu eni ẹgbọ nya, e kuẹghiẹ Ẹshinẹgba, e liẹ, “Ọmekẹguele ọniẹmhi ọ she bhale iteva oyi awa. Ẹshinẹgba ọ she bhale ya kpaghiẹ ẹgbọ eyọli obọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ingme oyi iJesu o gbhiaku ekẹ iJudia nya ali ẹoli ni e la gasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Abi eniyẹ odukhokho eyi iJọni e rọ gue eni ingme enana nya yẹ iJọni, ọ lu aava elemhi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ọ ghie wẹ e ka mhila iJesu, “Yẹyẹ u khi ọni ọ ya bhale abi anye ri ẹloe shi ekẹ ke khẹ ọlese?” ");
INSERT INTO atgNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Abi e rọ bhale deba iJesu, ẹ ọli, “IJọni Ọni ọọ batazi ẹgbọ ọ ghie anye ghi ẹ, anye ka mhila ẹ, ‘Yẹyẹ u khi ọni ọ ya bhale abi anye ri ẹloe shi ekẹ ke khẹ ọgbọẹse?’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ẹghẹghẹ aghọ te iJesu ọ ri ebubu ẹgbọ ni e mhuẹ ighuamhi ali iyẹmhẹ ọkphaghiẹ ze. Ọ khueghie ebubu ezalo alo-a. ");
INSERT INTO atgNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ọ rọ gueyẹ eniyẹ odukhokho eyi iJọni, “A nyenẹ egbe ukhokho ya gueyẹ iJọni emini a mẹ, ni a gbo ri esọ suọ. Ezalo ẹẹ mẹ ekẹ, eni e guọghọ awẹ-a, ẹẹ kia, eni efafe e mu e ze, elesọ e suọ esọ. Eni e ghu-a e guale. A kiele ẹ tse abọ usomhi onete oyi iloghie yẹ ẹgbọ ni ẹa mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oghẹlẹ o khi ni ọgbọ ni ọa da de odẹ-a itobọ khi ọa mhuẹ akhọkhọmhẹ shi mhẹ ọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Abi eniyẹ odukhokho eyi iJọni e rọ vu se, iJesu ọ́ gue ingme oyi iJọni yẹ eni ẹgbọ, ọọ wẹ, “Abi a rọ fẹ fiẹ je ọdagbe ifufu ya bino ọli, ọgbọ ọnabi ọnọghuo a dabi khi a ya mẹ? Ọgbọ ọyẹghẹ ni ọ li abi ebuli ifulọ ni akpekpeli o kha pfi je ana, o pfi ọli ẹ je oobọ a dabi khi a ya mẹ oobọ? ");
INSERT INTO atgNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ini ọa khi ọgbọ ọghọghọ a dabi khi a ya mẹ oobọ, ọnabi isẹ a ke nono je oobọ shọ? Ọmọse ni ọ sọ itsua ni e somhi otse? Ẹgbọ ni ẹ sọ itsua ni e somhi otse, apfẹ oyi oghie ẹ la. ");
INSERT INTO atgNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ọgbọ nabisẹ a dabi khi a je oobọ ya mẹ? Ọmekẹguele? Abi o li mhi li gue ọli ẹ yẹ ẹ khi ọni ọ dọsẹ ọmekẹguele lọ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ọnana a kẹkẹ ingme oyọli kpẹ shi ekẹ, ni ẹẹ, “ ‘Ghe khẹ, mhi ya ghie aghiusomhi ọyẹmhẹ ralo nẹ, ni ọ ya khueghie odẹ-a shi ekẹ khẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Mhi gueyẹ ẹ khi aa mẹ ọgbọ ni a bia bhale ekẹ agbọ ona ni ọ fu dọsẹ iJọni, eri-tsẹ khi ọni ọ ga shẹ nẹ nya shi Eghiele oyi Ẹshinẹgba ọ fu dọsẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ẹgbọ nya, li shi emionoga, abi e rọ suọ ingmemhi eyi iJesu, e mie shi ọ khi odẹ oyi Ẹshinẹgba o gbe akanya, irari khi iJọni ọ she batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ẹgbọ iFarisi ali eni e lẹsẹ emhi ingme ushi e kie ugbamhi ni Ẹshinẹgba ọ gba na wẹ, irari khi ẹa lama ni iJọni ọ batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aghọ iJesu ọ rẹ, elọ mhi fẹ ri ẹgbọ ena agbhotu ona ya khọkhọ, sẹ e fẹ ga li ena? ");
INSERT INTO atgNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eri e li abi eniyẹ ni e shitọ oki ni e nu egbe ẹ ngme ni e liẹ, “ ‘Anye pfi ofele na ẹ, ama aa lama gbe ishimhi, anye viẹ eviẹ olimhi khasẹ ẹ, ama aa lama nu anye viẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Itobọ khi abi iJọni Ọni ọọ batazi ẹgbọ ọ rọ bhale, ọa li le emhi wẹkhi eri ọ da onyọ, eri ẹ khi, ‘Ayẹmhẹ ọkphaghiẹ ọ mhuẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Omi ọgbọ ọ bhale, ọọ le, ọọ da, a kẹ liẹ khi, ‘Ọgbọ unu-emhi ali ọgbọ ọdonyọ ọ khi, ali khi ọni ọ nu emionoga ali ẹgbọ ena olamhẹ ẹ mu ọmọle ọ khi.’ ");
INSERT INTO atgNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eri ẹgbhali oyi Ẹshinẹgba o rọte obọ oyi ẹgbọ ni e miesuọ ri egbọli khasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ọgbọ iFarisi ọghuo ọọ iJesu ọ bhale ka kọ fẹli luẹ ni ọ nu luẹ le eminale. Ighọ ọ je owa oyi ọni iFarisi, ọ shitọ, ọ le emhi. ");
INSERT INTO atgNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ighọ ọkpotso ọghuo, ọngi oni ẹoli ni ọ la agbọ olamhẹ, ọ suọ khi iJesu ọ la oni owa oyi ọgbọ iFarisi ọghọ. Ọ dẹ akanama ituale ni o ghalẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ọ bhale, ọ de ya wugha iJesu idi awẹ. Ọọ viẹ ku ameviẹ shi ọli awẹ. Ọ ri itsu ni e la li ukhomhi shishi ọli wẹwẹ-a, ọ pfipfi ọli awẹ. Ọ gbo ku ituale ni ọọ pfie shi ọli awẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Abi ọni iFarisi ni ọ lu iJesu bhale apfẹ oyọli ya mu oli epfẹse, ọ rọ mẹ onana, ọ la ekẹ elemhi udu liẹ, ini ọmekẹguele ọyi Ẹshinẹgba ọmọse ọna ọ kha khi lọ, ọ kha lẹsẹ uwali ọkpotso ni ọna ọ khi ni ọ ri egbe a ti ọli ena, khi ọna olamhẹ ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","IJesu ọọ, “ISamọ mhi mhuẹ emini mhi ya gue yẹ.” ISamọ ọọ li, “Gueyẹ mhẹ, Ọsẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","IJesu ọọ li, “Ọmọse ọghuo ọ la ni ẹgbọ aava e lo ọli ota, ọghuo ọ, ọ lo ọli ẹkpa eva ali ukhukhui, ọni ọ kpọle ọ lo ọli ipọmhi uye ali ishe. ");
INSERT INTO atgNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Abi ẹa ke rọ dobẹ fali ọli ẹwẹ, ọ gbe eni ota kua na wẹ. Mena gueyẹ mhẹ ọni ọ ya nono ingme oyi ọli nẹ elemhi wẹwẹ ava-ava?” ");
INSERT INTO atgNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ISamọ ọọ li, khi ọni ọ lo ikpaghọ eni e bu nẹ lọ. IJesu ọọ li, “U guẹ sọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","IJesu ọ nyenẹ alo ghue ọni ọkpotso, ọọ iSamọ “Wa mẹ ọni ọkpotso ọna, abi mhi rọ bhale owa oyẹ wa diẹ amẹ na mhẹ rọ kpe awẹ-a, eri ọni ọkpotso ọnana ọ ri ameviẹ eyọli kpe mhẹ awẹ-a, ọ ri itsu ni e la li ukhomhi shishi wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Waa pfipfi mhẹ unu egbe, rọte ẹghẹghẹ ni mhi te lo ana le, ọni ọkpotso ọna ọ te pfipfi mhẹ unu awẹ ramhi memena. ");
INSERT INTO atgNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Waa ku oili shi mhẹ ukhomhi, ọni ọkpotso ọna, ọ she ku ituale ni ọ pfie shi mhẹ awẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Itobọ ighọ mhi gue ẹ yẹ ẹ khi a she gbe olamhẹ eyọli ni e bububu kua na li, irari khi ọni ọ nono emini e bu ọ khi. Ọni a gbe ukukuọ kua na, ukukuọ ọ nono.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ọ gueyẹ ọni ọkpotso, “A she gbe olamhẹ eyẹ kua nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ẹgbọ ni e nu ọli shitọ e mhila egbewẹ “Ọghuo ọnana ọọ dabi khi lọli khi ni ọọ gbe olamhẹ kua na ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","IJesu ọ gueyẹ ọni ọkpotso “Irudunga oyẹ o she mie ẹ pfuese, ri opfọmhẹ ke je.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ona o dọsẹ, iJesu ọ kia rọte ẹoli je ẹoli. Ọọ gue usomhi onete oyi Eghiele oyi Ẹshinẹgba le. Eniyẹ odukhokho ogbava eyọli e nu ọli kia. ");
INSERT INTO atgNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ikpotso eghuo ni e kpẹ mhuẹ ayẹmhẹ ọkphaghiẹ ali iwali ighuamhi ni ọ rọ ze, e li la aghọ: IMeli ọngi iMagidaleni ni ayẹmhẹ ishilua e rọte egbe lasele; ");
INSERT INTO atgNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","IJoana ni ọ khi ughuẹ iChuza ni ọ gbe akanya na oghie Erọdu; ISuzana ali ikpotso elese ghọ, e ga la akaghọ. Enana e rọte ẹkuẹ oyẹwẹ ẹ kpaghiẹ iJesu ali eniyẹ odukhokho eyi ọli obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Abi ebubu ẹgbọ e rọ rọte ẹoli ọdọda bhale ya lona kugbe, ni e rọ le gasẹ iJesu, iJesu ọ zẹ okhẹ irọkhọkhọ khasẹ wẹ, ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ọghiale ọ ya ri ikpamhi emhi kọ. Abi ọ rọ ku eni ikpamhi emhi kia kọ, eghuo ọ e ku shi epfepfẹ odẹ. Eghuo ọ ẹgbọ e ri awẹ muno wẹ. Ipfeli e bhale ya sanọ wẹ le. ");
INSERT INTO atgNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eghuo ọ e de ku nga ẹchẹ, abi e rọ zẹ ngale, e khakha. Itobọ khi ẹa mẹ asha lolo pfi imhili lo ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ikpamhi eghuo ọ e de shi ifu igba, eni igba e tono wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ighọ eghuo ọ e ku shi ekẹ onete, e fu, e mọ ikpamhi agbhagbhamhi egbhuẹshe. Abi ọ rọ ngme ona se, ọọ li, Ọni ọ mhọli esọ ọ rọ suọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Eniyẹ odukhokho eyọli e mhila li emini a ri oni okhẹ irọkhọkhọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ọọ wẹ, “A she khueghie osheli ni o la Eghiele oyi Ẹshinẹgba-a khasẹ ẹ. Ama aa rọli khasẹ ẹgbọ ni e kpọle. Lọli o zẹ ni mhi rọ ri okhẹ irọkhọkhọ nu wẹ ẹ ngme. “ ‘Irari khi ini e ririẹ ẹ fẹ, ẹa ya mẹ ekẹ, ẹẹ suọ, ọa lo wẹ esọ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Emini a ri oni okhẹ irọkhọkhọ ngme na. Oni ukpamhi emhi oghọ, ungmemhi oyi Ẹshinẹgba lọ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Eni e de kua epfepfẹ odẹ eghọ, e khi ẹgbọ ni e kha suọ ungmemhi oyi Ẹshinẹgba, ọkphaghiẹ ọ bhale ya sanọ wẹ oni ungmemhi udu-a, ini e khi miesuọ, ni e ba mhuẹ imiepfuese. ");
INSERT INTO atgNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Eni e zẹ nga ọkpegbhẹ e to ẹoli ẹgbọ ni e miesuọ, ni e khia khi abi imufẹ o rọ bhale ẹa ke dobẹ migha, e de odẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ikpamhi ni e zẹ shi ifu igba, wẹwẹ e khi ẹgbọ ni e suọ oni ungmemhi ama ẹa dobẹ migha shi ọ, isamhi eyi emhi agbọ ali anasẹmhẹ ali ẹpfue ni o la agbọ ali ọghuẹmhẹ ni o la ọ, ọa zẹ ni e mhuẹ iwomhẹloe shi irudunga. ");
INSERT INTO atgNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ikpamhi ni e zẹ shi ekẹ onete ni e mọ ikpamhi, wẹwẹ e khi egbegbi ẹgbọ ali udu ọnete ni e kha suọ oni ungmemhi, e mu ọli shi, e kha ri egbe mie o ri emini a rọ kọ ọ zẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Aa mẹ ọgbọ ni ọ ri ákpá ya ru, ni ọ ya rue ọli sheli elemhi ukoko, wẹkhi ufu ukpho. Eri ọ ri ochoghọ ya rue ọli nga asha na keghe ni eni ẹẹ lo le e ke mẹ ekẹ, ẹẹ mẹ oni ákpá. ");
INSERT INTO atgNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Irari khi aa mẹ emiemini a rọ sheli ni aa ya rọ lasele gboo, wẹkhi eri a mẹ emini a khukhu shi elemhi, ni aa ya khueghie-a gboo. ");
INSERT INTO atgNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Itobọ ighọ mhuẹ ẹgbhẹ shi emini u wa suọ. Ọni ọ mhuẹ, a ya rọ ma li ọ. Ama ọni ọa mhuẹ a ya gbo mie ọli ukuku ọli ni ọ sa khi lọli mhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ighọ inyọli ali inyọghuo ọli e bhale deba li, ama ẹa mẹ asha ramhi ọli egbe, irari ebubu ẹgbọ ni e le gasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ọgbọ ọ ya gueyẹ iJesu, ọọ li, “Inyẹ ali inyọghuẹ, e migha olase, ẹẹ nono ni wẹwẹ e mẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","IJesu ọọ wẹ, “Inyẹmhẹ ali inyọghuo-mhẹ wẹwẹ e khi ẹgbọ ena ni ẹẹ suọ ungmemhi oyi Ẹshinẹgba, ni e gbo rọli ẹ gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ẹlẹghuo iJesu ọọ eniyẹ odukhokho eyọli, “A bhale ni awa da je ukiẹkiẹ obinokpọle oyi okẹ ni o khishi.” E lo ọkọ-okẹ e lẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Abi e li lẹ, iJesu ọ lesẹa. Utoghuokpe ukpokpomhi akpekpeli o lo oni ọkọ-okẹ le ya ramhi khi oni ọkọ-okẹ o ku ya luẹ, wẹwẹ nya e la okhẹna. ");
INSERT INTO atgNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eniyẹ odukhokho eyọli e bhale ya guise ọli le. Ẹẹ ọli “Ọnọmhuẹ, Ọnọmhuẹ okẹ o ya ku awa luẹ.” Ọ vule, ọ nu oni akpekpeli ali okẹ ni o zughuse ngme. Oni akpekpeli o mu migha. Okẹ ni o zughuse eghọ o dema, asha kpa oo tsukẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ọ mhila eniyẹ odukhokho eyọli, “Ighe irudunga oyẹẹ?” E ri ulishi ali ọshabọ mhila egbewẹ, “Ọghuo ọnana ọ fẹ ga khi ena? Irari khi ọọ mhẹsẹ na akpekpeli ali okẹ, e suọ na li.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","E kia ramhi ekẹ iGẹrasẹnẹsi ni o gbe okẹ ni o khishi na iGalili khi-a. ");
INSERT INTO atgNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Abi IJesu ọọ da tiemhile ekẹ, Ọmọse ọngi oni ẹoli, ni ọ mhọli ayẹmhẹ ọkphaghiẹ ni o she tẹsẹ ni ọa te kẹ sọ awulu, wẹkhi eri ọ ke la owa ghue, ama atalimhi ọ ke la, ọ bhale ya ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Abi ọ rọ mẹ iJesu, ọ de yẹshi ọli awẹ, ọ tsẹsẹ leghe, ọ liẹ, “Elọ u rẹmhẹ ya li, iJesu Omi Ẹshinẹgba ọnọfunẹ, kpẹkpẹ khi nasẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Eri ọ ngme ona irari khi iJesu ọ she mhẹsẹ na oni ayẹmhẹ ọkphaghiẹ oghọ o rọte ọli egbe lasele. Iti-ingmi-ingmẹ oni ayẹmhẹ o she mu ọli, ni o khia khi ini a riẹ mu ọli ri iwẹghẹ shi ọli abọ ali awẹ, ọ pfanọ eni iwẹghẹ-a, oni ayẹmhẹ ọkphaghiẹ o tsua li je ọdagbe ifufu. ");
INSERT INTO atgNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","IJesu ọ mhila li, “Sẹ a lu eva oyẹ?” Ọni ayẹmhẹ ọọ li, eva oyẹmhẹ khi, “ILigiọni,” irari khi ayẹmhẹ ọkphaghiẹ ebubu e she lo ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eni ayẹmhẹ ọkphaghiẹ e lema iJesu ọ khi khu wẹwẹ je ilimhi na ningọlọ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Igulu ebubu e la epfẹ ute le eminale. Ighọ eni ayẹmhẹ e lema li ọ kpẹkpẹ ọ zẹ ni wẹwẹ e ya lo eni igulu egbe. Ighọ ọ zẹ ni e ya lo eni igulu eghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Eni ayẹmhẹ ọkphaghiẹ eghọ e rọte egbe oyi ọni ọmọse lasele, e ya lo elemhi eni igulu eghọ. Eni igulu e rọte oni epfẹ ute na ya kulo okẹ ni o khishi eghọ, okẹ o gbe wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abi eni e ri eni igulu ẹ kia e rọ mẹ emini a mẹ, e na je ifu apfẹ ya gueyẹ ẹgbọ emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ẹgbọ e lẹ ya bino emini a mẹ. Abi e rọ bhale deba iJesu, e bhale ya ẹ khi ọni ọmọse ni iyẹmhẹ ọkphaghiẹ e te egbe lase khi ọ shitọ ufuẹgẹ oyi iJesu. Ọ ga pfọmhẹ, ọ ku egbe-a shitọ, ulishi o mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ẹgbọ ni e mẹ oni ingme e gueyẹ ẹgbọ elese abi ọni ọmọse ọ́ li kia ni ọ rọ ze. ");
INSERT INTO atgNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ighọ eni ẹgbọ iGẹrasẹnẹsi e gueyẹ iJesu ọ lase ẹwẹ ekẹ le, irari khi ulishi o mu wẹ. IJesu ọ lo ọkọ-okẹ ọ vu. ");
INSERT INTO atgNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ọni ọmọse ni eni iyẹmhẹ ọkphaghiẹ e rọte egbe lasele ọọ iJesu, “Kpẹkpẹ zẹ ni mhi deba ẹ vu.” Ama iJesu ọọ li, ọ ke vu. ");
INSERT INTO atgNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nyenẹ egbe je apfẹ ni u ya guele emini Ẹshinẹgba ọ riẹlẹ nẹ. Ighọ ọni ọmọse ọ vu ya gueyẹ ẹgbọ ni e la oni ẹoli oghọ nya, emini iJesu ọ riẹlẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Abi iJesu ọ rọ nyenẹ egbe je ukiẹkiẹ okẹ ni o kpọle, ẹgbọ e tsẹ ọli ọ mu awẹ itobọ khi o she tẹsẹ ni e te migha a khẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ighọ ọmọse ọghuo ni a lu iJarusi ni ọ khi ọgbọ ọni ọ mhẹsẹ shi owa ugamhi oyi ẹgbọ iJu, ọ de ya wugha iJesu awẹ. Ọọ lema li ọ kpẹkpẹ ọ bhale apfẹ oyẹluẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Irari khi ọmọ ọmueshi ọghuo kpe ni ọ mẹ bia ni ọ lẹsẹ gbe ikpe igbẹva ọ ya ghua. Abi iJesu ọ li lẹ, ẹgbọ e le gasẹ ọli, e ma mu ọli ashakpa. ");
INSERT INTO atgNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ọkpotso ọghuo ọ la ifuabọ wẹ ni ọ she ku ọlia egbe elemhi ikpe igbẹva. Ọ she ga pfuse emini ọ mhuẹ-a nya na idọkita, ama aa mẹ ọni ọ dobẹ dua ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ighọ ọ rọte ifuabọ oyi eni ẹgbọ lase bẹna ya ri obọ ti esọ ode ni iJesu ọ sọ, ọlia ni e ku ọli egbe e pfa tee. ");
INSERT INTO atgNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","IJesu ọ mhila, “Ọghuo ọ ri obọ ti mhẹ?” Ọgbọkpa ọ tia. IPita ọọ li, “Ọnọmhuẹ, ebubu ẹgbọ e le gasẹ ni e ma mu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama iJesu ọ li, “Ọgbọ ọ ri obọ ti mhẹ, mhi lẹsẹ khi itoto e she rọte mhẹ egbe ya lase, lọli mhi rọ lẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ọni ọkpotso ọ mẹ khi lọli a dobẹ ya vu ni a rọ ya mẹ luẹ, ọ ri ulishi fiẹ lasele, ọ de ya wugha odalo oyi iJesu. Ukpẹloe oyi eni ẹgbọkpa, ọ gueyẹ iJesu emini o zẹ ni lọli rọ ri obọ ti ọli ali abi lọli ze utoghuokpe. ");
INSERT INTO atgNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ighọ iJesu ọ li, “Omimhẹ ke je khi irudunga oyẹ o she rẹ ze. Ri opfọmhẹ ke je apfẹ oyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","IJesu ọ kie lighọ ngme, ọgbọ ọ rọte owa oyi iJarusi ni ọ khi ọni ọ mhẹsẹ elemhi owa ugamhi bhale. Ọọ li, “Omiẹ ọ she ghua-a. Khi ke bie nasẹ ọsẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Abi iJesu ọ rọ suọ ona, ọ gueyẹ iJarusi, “Khi zẹ ni ulishi o muẹ. Lẹsẹ miesuọ tsẹ khi ọ ya toto.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Abi ọ ke rọ ramhi apfẹ oyi iJarusi, ọa zẹ ni ọgbọkhọghuo ọ nu luẹ lo aghọ, sẹẹ ni iPita ali iJọni ali iJemhisi ali inyọ ọni ọmọ ali itali. ");
INSERT INTO atgNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ọgbọkpa e she kie kpẹ viẹ eviẹ oyi ọni ọmọ. IJesu ọọ wẹ, “A khi ke viẹ irari khi ọni ọmọ ọa ghu, eri ọ lesẹa.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wẹwẹ nya ee gia iJesu, irari khi e lẹsẹ khi ọni ọmọ ọ she ghua. ");
INSERT INTO atgNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ama iJesu ọ mu ọli obọ ọ lu ọli leghe, “Omimhẹ, vule.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ayẹmhẹ oyọli o nyenẹ egbe bhale deba li. Ọ vule migha utoghuokpe. Ighọ iJesu ọọ wẹ, “A ri eminale na ọni ọmọ le.” ");
INSERT INTO atgNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abọ e sha ita ali inyọli. IJesu ọ gueyẹ wẹ e khi gueyẹ ọgbọkhọghuo emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","IJesu ọ lu eniyẹ odukhokho ogbava eyọli kugbe, ọ ri itoto ali afu na wẹ ni e rọ ke khu ẹgbọ iyẹmhẹ ni ẹa ti egbe lasele, ali ni e gbo ri ẹgbọ ni e mhuẹ ighuamhi ọdọda toto. ");
INSERT INTO atgNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ọ ghie wẹ fiẹ e ke ya tse abọ ungmemhi oyi Eghiele oyi Ẹshinẹgba kiakia ali ni e gbo ke ri ẹgbọ ze. ");
INSERT INTO atgNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ọ́ọ́ wẹ, “A khi tsua emhikhọghuo abi a liẹ le ena, a khi tsua ukpokpo wẹkhi akpaba wẹkhi eminale wẹkhi ikpaghọ wẹkhi iku itsua eva ni a sọ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Owa ni a da lo ne, a la aghọ ramhi ni a rọ ya te oni ẹoli vu. ");
INSERT INTO atgNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ini ẹgbọ ẹa da mie ẹ ne, a kpishi itutu ni e la ẹ awẹ-a shi oni ekẹ ini a rọte oni ẹoli ẹ vu, ni o khi ọtsẹlẹ ni a ya pfi mu wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ighọ eni eniyẹ odukhokho e vu, rọte ẹoli je ẹoli. E ri usomhi onete oyi Ẹshinẹgba tse abọ kiakia. E ri ẹgbọ ọ toto ashakpa. ");
INSERT INTO atgNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ighọ Erọdu ni ọ khi oghie shi ekẹ iGalili ọ suọ ikanya ọnyaloa ni iJesu ọọ gbe. Abọ e sha li itobọ khi ẹgbọ eghuo e liẹ khi iJọni Ọni ọọ batazi ẹgbọ lọ ni ọ rọte eghuli guale. ");
INSERT INTO atgNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Eghuo ẹ khi Elaja ọ khi ni ọ bhale, eghuo elese e liẹ khi ọghuo ọmekẹguele enediọ ọ khi ni ọ nyenẹ egbe bhale agbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ama, Erọdu ọ́ọ́, “Mhẹmhẹ mhi khi iJọni ukhomhi ọ. Ọghuo ọnana ọ khi ni mhia suọ eko?” Ọọ dua abi ọ li ya mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Abi eni ighiusomhi na kẹẹ e rọ jele, e gueyẹ iJesu abi e li kia. Ighọ ọ rue wẹ vu je epfẹ ẹoli na lu iBẹtisaida, ");
INSERT INTO atgNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ama eni ebubu ẹgbọ e suọ obini ọ je, e deba li. Ọ mie wẹ, ọ gue ungmemhi Eghiele oyi Ẹshinẹgba yẹ wẹ, ọ ri eni e mhuẹ ighuamhi toto. ");
INSERT INTO atgNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","O te aghọ li dẹnẹ abi ogbọmhi o ke rọ mu ekẹ, eniyẹ odukhokho ogbava e bhale deba li, ẹẹ ọli. “Gueyẹ eni ẹgbọ e vu je ẹoli ni e ti mama ana ni e ya nono ashini e ya ku shi ali eminale ni e ya le, irari khi ifui ọdagbe ifufu awa la.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ọ sọ wẹ ọ, ọ́ọ́ wẹ, “A ri eminale na wẹ le.” Ẹ ọli, “Ibulẹdi eva ali ifẹlẹ aava e lẹsẹ la ana, sẹ ni awa vu ya dẹ eminale ghi wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Irari khi emọse agbẹlẹ asha ishe e la aghọ. Ama ọ́ọ́ eni eniyẹ odukhokho, “A rẹ wẹ shitọ ikui-iku ẹgbọ egbhuẹva ali igbigbe.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eni eniyẹ odukhokho e li ghọ, ọgbọkpa ọ shitọ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","IJesu ọ rue eni ibulẹdi ishe ali ifẹlẹ aava eghọ, ọ bino idane, ọ kphẹmhi shi eni eminale, ọ kholo wẹ a. Ọ rue wẹ na eniyẹ odukhokho eyọli ni e kemhi wẹ na eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ighọ wẹwẹ nya e le, e khue. Eni eniyẹ odukhokho e wolọ eni e le kpọle shi ighughu igbẹva. ");
INSERT INTO atgNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ẹlẹghuo khi iJesu ọ la ashini o da-ya ẹ sọ iromhi, eniyẹ odukhokho eyọli e nu ọli la aghọ, ọ mhila wẹ, “Ọghuo ẹgbọ e fẹ ẹ liẹ khi mhi khi?” ");
INSERT INTO atgNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ẹ oli, “Ẹgbọ eghuo ẹ khi iJọni Ọni ọọ batazi ẹgbọ u khi, elese ẹ liẹ Elaja, elese ghọ ẹ khi ọmekẹguele ọnọdiọ u khi ni u nyenẹ egbe bhale agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ọ rọ mhila wẹ “Ọghuo ẹẹ ẹ khi mhi khi?” IPita ọọ li, “Yẹyẹ u khi Ọmiepfuese ọnayi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","IJesu ọ tse agua yẹ wẹ e khi gueyẹ ọgbọkhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ighọ, Ọ́ọ́ wẹ, “Omi Ọgbọ ọ mema ya mẹ osue emhi ebubu. Eni egbhali ali ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi, e kie ọli. E mema ya gbe ọli-a, ama ẹlẹnuzi-esẹ, ọ ya guale.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ighọ ọ gueyẹ wẹ nya, “Ini ọgbọkhọghuo ọ́ nono ni lọli khi ọmọ odukhokho ọyẹmhẹ, ọ mema ya kie egbọli, ọ rue apfida oyọli ogbẹlẹ kpa, ọ́ọ́ deba mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Itobọ khi ọni ọ da nono ni lọli tsumhi agbọ oyọli ne, ọ ya wasẹ ọli-a, ama ọni ọ da wasẹ agbọ oyi ọli-a ne shi itobọ oyẹmhẹ, ọ ya tsumhi ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ighe eleli ni ọgbọ ọ ya mẹ ini ọ mhuẹ agbọ ona nya ni ọ rọ wasẹ ayẹmhẹ oyọli-a? ");
INSERT INTO atgNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ini ọgbọ ọ da na omama mhẹ ali ungmemhi oyẹmhẹ ne, Mhẹmhẹ Omi Ọgbọ mhi li ya na omama oyi oni ọgbọ, ini mhi bhale elemhi ufumhi oyẹmhẹ, ali ufumhi oyi Ita ali oyi igẹni ni e pfuasẹ ");
INSERT INTO atgNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mhi gue ọli ẹ yẹ ẹ abi o li, khi, ẹgbọ eghuo e la ana ni ẹa ya ghu ne, neni e rọ ya mẹ oni Eghiele oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Abi ogbẹlẹ nuzi eleli o rọ gba abi iJesu ọ te ngme eni ingme, ọ rue iPita ali iJọni ali iJemhisi nga ute ya lema. ");
INSERT INTO atgNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Abi ọ li sọ iromhi eghọ, alo eyọli e mu nyenẹ, itsua ni ọ sọ e gẹ nyanyanya abi ákpá. ");
INSERT INTO atgNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ighọ Emọse aava, iMosisi ali Elaja, ");
INSERT INTO atgNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","e li lasele e gẹ nyanyanya, e nu iJesu u ngme, e ghẹta eghuli ni iJesu ọ ya ghu obini iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Olesẹ o mema rẹ IPita ali apfọli. Abi e rọ guale ni olesẹ o rọ kala wẹ alo-a, e mẹ ufumhi oyi iJesu ali emọse aava ni e nu ọli migha. ");
INSERT INTO atgNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Abi eni emọse aava e li vu, iPita ọ́ọ́ iJesu, “Ọga, oo ga guẹ ti khi anye la akana. Zẹ ni anye tọnọ okholo esẹ, oghuo oyẹ, oghuo oyi iMosisi, onokpọle oyi Elaja.” Eri ọ li ngme tsẹ, ọa lẹsẹ emini ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ọ kie lighọ ngme, otughunu o bhale ya khukhu wẹ-a. Ulishi o mu wẹ abi e rọ lo elemhi oni otughunu. ");
INSERT INTO atgNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ighọ uruli o rọte oni otughunu ngme, ọọ, “Omimhẹ na ni mhi zẹ, a ri esọ shi emini ọ ngme.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Abi oni uruli o rọ ngme se, e mẹ khi iJesu luẹghuo ọ ke migha. Eni eniyẹ odukhokho e ri ingme ona shi udu, ẹa gueyẹ ọgbọkhọghuo emini e mẹ ẹghẹghẹ aghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ogbeakọlọ abi e rọte ukhomhi ute tiemhile, ebubu ẹgbọ e bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ighọ ọmọse ọghuo ọ rọte elemhi eni ebubu ẹgbọ tsẹsẹ leghe, ọ li “Ọsẹsẹ, kpẹkpẹ bino omimhẹ, lọli ọ khi ọmọ ọghuo kpe ni mhi mẹ bia. ");
INSERT INTO atgNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ayẹmhẹ obe ó tsua mu ọli, eri ọọ mu ọli pfi ekẹ, ọọ kpi awẹ-a, o rọli ẹ chi ofulu unu. Ọa ga nono ni lọli rue ọli obọ-a kpa. Eri ọọ nono ni lọli pfuse ọli ayẹmhẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mhi she lema eniyẹ odukhokho eyẹ e khu ọli oni ayẹmhẹ egbe-a, ẹa dobẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","IJesu ọọ wẹ, “Ẹẹ ẹgbọ ni aa mhuẹ irudunga wẹkhi ilẹsẹ. Ẹlẹ ingme mhi dobẹ ya ri egbe mie umhalẹsẹ oyẹ ẹ ramhi? Ẹlẹ ingme mhi ke nu ẹ ya la akana?” Ọọ ọni ọmọse, “Rue omiẹ bhale ana ghi mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Abi ọni ọmọ ọ li bhale, oni ayẹmhẹ ọkphaghiẹ o mu ọli pfi ekẹ jighise, ọọ chi ofulu unu. Ighọ iJesu ọ dese oni ayẹmhẹ ọkphaghiẹ, ọ ri ọni ọmọ ze. Ọ rue ọli na itali. ");
INSERT INTO atgNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abọ e sha eni ẹgbọ nya shi ekpabọ oyi Ẹshinẹgba ni e funẹ. Abọ e kie lighọ sha eni ẹgbọ shi emini iJesu ọ riẹlẹ, iJesu ọ́ọ́ eniyẹ odukhokho eyọli, ");
INSERT INTO atgNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“A ri esọ shi ekẹ shi ingme ni mhi ya gueyẹ ẹ ena. A ya ri Omi Ọgbọ na ẹgbọ dẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eri-tsẹ khi eni eniyẹ odukhokho ẹa lẹsẹ abi oni ungmemhi o ngme. Irari khi eri a rọli sheli wẹ ini e khi lẹsẹ emini a rọli ngme. Ama ulishi oo mu wẹ shi abi e liẹ mhila li. ");
INSERT INTO atgNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ekhakọ o bhale iteva oyi eniyẹ odukhokho eyọli shi ọni ọ ya funẹ elemhi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","IJesu ọ lẹsẹ emini ee sa udu oyẹwẹ, ọ rue ukuku ọmọ lasele migha wẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ọ́ọ́ wẹ, “Ọnini ọ da ri eva oyẹmhẹ mie ọmọ ọna ne, mhẹmhẹ ọ mie. Ọnini ọ da mie mhẹ ne, ọni ọ ghie mhẹ ọ mie. Irari khi ọnini ọ da ri egbọli tiemhie-ekẹ nẹ elemhi ẹ, lọli ọ khi ọni ọ funẹ nya.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","IJọni ọ́ọ́, “Ọga, anye mẹ ọmọse ni ọ ri eva oyẹ ẹ khu ayẹmhẹ ọkphaghiẹ lase, anye nono ni anye gueyẹ ọli ọ khi ke lighọ irari khi ọa ya debẹ abi anye liẹ debẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","IJesu ọọ wẹ, “A khi ke lighọ, irari khi ọgbọ ni ọa da khi ọbe awa ne, ọnayi awa ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Abi ẹghẹghẹ o rọ ramhi ni a rọ ya rue iJesu je iloghie, ọ mhọli ọli shi udu khi lọli ya je iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ọ ghie ighiusomhi ralo, ni e lo elemhi ẹoli nikeke na elemhi iSameria ni e ya mu egbe emhikpa shi ekẹ khẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama eni ẹgbọ iSameria ẹa lama mie ọli irari khi e lẹsẹ khi iJerusalẹmu ọọ je. ");
INSERT INTO atgNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abi eniyẹ odukhokho eyọli ikhi iJemhisi ali iJọni e rọ mẹ ghọ, ẹ ọli, “Ọnọmhuẹ, waa ke zẹ ni anye lu erali rọte idane tiemhie rọ tosẹ wẹ a nya?” ");
INSERT INTO atgNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","IJesu ọ nyenẹ alo ukhokho, ọ dese wẹ, ọọ wẹ, aa lẹsẹ ayẹmhẹ ni a mhuẹ. Ọa khi eri omi ọgbọ ọ bhale ya yese ẹgbọ agbọ-a, ama eri ọ bhale ya tsumhi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ighọ iJesu ali eniyẹ odukhokho eyọli e vu je ẹoli olese. ");
INSERT INTO atgNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Abi e li lẹẹ eghọ, ọmọse ọghuo ọ́ọ́ iJesu, “Ọga mhi ya ke debẹ je obiobini wa je kpa.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","IJesu ọ́ọ́ li, “Inyakọ e mhuẹ esẹ, ipfeli e mhuẹ eko, ama Omi Ọgbọ ọa mhuẹ ashini ọ dọ ukhomhi ẹ gbe.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","IJesu ọ gueyẹ ọmọse ọlese, “Deba mhẹ.” Ọni ọgbọ ọ́ọ́ li, “Ọga, kpẹ zẹ ni mhi ya ri itamhẹ tọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","IJesu ọ́ọ́ li, “Zobẹ ni eni e ghu-a e ri eni e ghu-a tọ. Yẹyẹ fiẹ ke ya gue ungmemhi Eghiele oyi Ẹshinẹgba le.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ọlese ọ́ọ́ li, “Ọga mhi ya debẹ, kpẹ zẹ ni mhi ya tsẹ apfẹmhẹ, okhila.” ");
INSERT INTO atgNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","IJesu ọọ li, “Ọgbọ ni ọ da ri obọ nga ẹgba ni ọọ she ẹ gua ẹsẹ, ni ọ da bino ukhokho ne, ọa tẹ ni ọ lo Eghiele oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ona o dọsẹ se, Ọnọmhuẹ ọ zẹ ẹgbọ egbhuẹsẹ etuogbava, ọ mu wẹ ava-ava, ọ e ralo na luẹ ni e kia je ikpe ni ọọ nono ni lọli kia ramhi. ");
INSERT INTO atgNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ọọ wẹ, “Ikhiẹsẹ oniẹmhi o la ọ, eri-tsẹ eni ẹ khiẹsẹ wẹ ẹa bu. Itobọ ighọ, a sọ lema ita ọni ọ mhuẹ okhiẹsẹ, ni ọ ghie eni ẹ khiẹsẹ bhale ishemhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","A ke lẹ! Eri mhia ghie ẹ abinẹ isumha ne la ifuabọ idumhi. ");
INSERT INTO atgNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A khi tsua ẹkuẹ ukpaghọ wẹ khi akpulu wẹ khi ekuẹ, a khi tsẹ ẹgbọ odẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ini a lo owa okhọghuo, a kpẹ to dẹ liẹ ‘Opfọmhẹ o ka la oni owa ona.’ ");
INSERT INTO atgNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ini ọgbọ opfọmhẹ ọ la aghọ, opfọmhẹ oyẹ ẹ o deba li, ini aa mẹ, opfọmhẹ oyẹ ẹ o nyenẹ egbe deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Apfẹ okhọghuo ni a da lo ne, a la aghọ le, a la aghọ da emiemini e da rọ ya na ẹ. Irari khi o ti ni ọgbakanya ọ mie ifata. A khi ke kia te owa da je owa. ");
INSERT INTO atgNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ini a da lo ẹoli le ni e rọ da mie ẹ ne, a le emini e rọshi ekẹ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A ri eni ẹẹ ghua ni e la aghọ ze, a gueyẹ wẹ, ‘Eghiele oyi Ẹshinẹgba o she ti mama ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ẹoli ni a bhale kpa ni ẹa da mie ẹ, a je ifu apfẹ ya liẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Itutu oyi ekẹ oyẹ ni e la anye awẹ, anye she kpishi wẹ shi ekẹ na ẹ, ni e ya pfi ọtsẹlẹ mu ẹ. Ama ẹẹ ọyẹ ẹ, a lẹsẹ khi Eghiele oyi Ẹshinẹgba o she ti mama ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mhi gueyẹ ẹ khi ogbẹlẹ isọ-ẹzọ khi o ya somhi iSodomu egbe dọsẹ oni ẹoli oghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O ma khọlọ ẹ egbe, ikhi ẹẹ ẹgbọ iKorazi! O ma khọlọ ẹ egbe, ẹẹ ẹgbọ iBẹtisaida! Irari khi ini ikanya ọnyaloa ni a la elemhi ẹ gbe khi a la ekẹ iTai ali iSidọni li gbe wẹ lọ, e kha mu nyenẹ agbọagbọ. E sọ ide eviẹ, e shitọ ukhomhi emuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eri-tsẹ khi Ẹshinẹgba ọ ya mhuẹ isomhelemhi na ẹgbọ iTirẹ ali ẹgbọ iSodomu dọsẹ ẹ ogbẹlẹ iguẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ẹẹ ẹgbọ iKapanọmu, eri a dabi khi a ya ti ẹ nga idane? Iiye! Eri a ya ti ẹ tiemhi ilimhi iriẹriẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Ọọ wẹ, ọni ọ da ri esọ shi ẹ ọ ne, mhẹmhẹ ọ ri esọ shi ọ. Ọni ọ da kie ẹ, mhẹmhẹ o kie. Ọni ọ da kie mhẹ ne, ọni ọ ghie mhẹ ọ kie.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ighọ eni ẹgbọ egbhuẹsẹ etuogbava eghọ e ri oghẹlẹ jele. Ẹẹ ọli, “Ọnọmhuẹ, eri egbegbi iyẹmhẹ ọkphaghiẹ e ri irari eva oyẹ nyẹsẹ ukhomhi na anye.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","IJesu ọọ wẹ, “Mhi mẹ khi ọkphaghiẹ ọ rọte idane de pfile abi erali akphala. ");
INSERT INTO atgNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A ghe khẹ! Mhi she ri afu na ẹ, ni a rọ lighi enyẹ ali ikpi dọsẹ, ali ni a gbo mu itoto ali ekpabọ alo ebili nyaa ọ le. Emhikhọghuo ẹa ya li ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","A khi ghẹlẹ khi ọkphaghiẹ ọ ri irari eva oyẹmhẹ nyẹsẹ ukhomhi na ẹ, ama a ke ghẹlẹ khi a kẹkẹ eva oyẹ ẹ shi iloghie.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ẹghẹghẹ aghọ, oghẹlẹ o te elemhi Ayẹmhẹ-nọ-pfuasẹ vọ iJesu egbe, ọọ li, “Mhi tsẹ uwegbe, Ita ni ọ mhuẹ ekẹ ali ukhuli. Irari khi u she ri emhi ena sheli ẹgbọ ni e fia alo-a ali eni e mema wẹna ebe. Ama u rẹwẹ khasẹ ikuku eniyẹ. Ighọ lọ Ita, irari khi abi o li ghọle ẹ shi ghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Itamhẹ ọ she ri emhikpa shi mhẹ obọ. Aa mẹ ọgbọ ni ọ lẹsẹ ọni ọmọ ọ khi, sẹ ni Ita. Aa mẹ ọgbọ ni ọ lẹsẹ ọni Ita ọ khi, sẹ ni ọmọ. Eni e ghọle ọni ọmọ ọ ri Ita a khasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ighọ ọ nyenẹ alo ghue eniyẹ odukhokho eyọli, ọ bẹna nu wẹ ngme, ọọ wẹ, “Ikhivọsẹ o khi na ikpalo ni e mẹ emini ẹẹ a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mhi gueyẹ ẹ khi emekẹguele ali ighie ebubu e nono ni wẹwẹ e mẹ emini ẹẹ a mẹ ali ni e suọ emini a suọ ena, ama ẹa dobẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ighọ ọsẹsẹ Ishi eyi iMosisi ọghuo ọ vule ya mu iJesu fẹ bino. Ọ mhila li, “Elọ mhi fẹ ya li ni mhi rọ ya mhuẹ agbọ na agbọagbọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","IJesu ọ li, “Elọ a kẹkẹ shi ebe Ishi eyi iMosisi? Sẹ u liẹ zẹ emini a kẹkẹ shi ọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ọ iJesu, “Rọte ekelemhi udu oyẹ nya ali ayẹmhẹ oyẹ nya ali ekpabọ eyẹ nya ali isamhi eyẹ nya nono ingme oyi Ẹshinẹgba. U gbo nono ingme oyi ọnuzava ọyi ẹ abi u nono ingme egbe ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","IJesu ọọ li, “U ga guẹ gbaghiẹ-a. Lina ke ngeli khi u ya mhuẹ agbọ ona agbọagbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eri ọni ọsẹsẹ Ishi eyi iMosisi ọna ọ nono ni lọli rọkhasẹ khi lọli lẹsẹ enana nya. Ọ mhila iJesu, “Ọghuo ọ fẹ khi ọnuzava ọyẹmhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","IJesu ọ lina sọ ọli ọ, “Ọmọse ọghuo ọ ke rọte ẹoli iJerusalẹmu tiemhi ẹoli iJẹriko. Ighọ ọ de ya pfilo ighiatọ abọ. E gbe ọli banọ-a, e kẹsẹ ukuku ayẹmhẹ shi ọli ọ, e mie ọli emini ọ mhuẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A bhale ya ẹ khi ọkpodalo-ugamhi ọyi Ẹshinẹgba ọ rọte oni odẹ ẹ dọsẹ. Abi ọ rọ mẹ ọni ọmọse ni ighiatọ e gbe eghọ, ọ da je ukiẹkiẹ odẹ ni o kpọle ya dọsẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ighọ ọni ọ la Owa oyi Ẹshinẹgba gbe akanya ọghuo, eni a lu iLivaiti, ọ ramhi aghọ, ọ mẹ ọli, ọ li rọte ukiẹkiẹ odẹ ni ọ kpọle ya dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ọmọse ọngi iSameria ọghuo ni ọ lẹ asha, ọ ramhi ashini ọni ọmọse ọ la. Ọ mẹ ọli, elemhi ọli e lala li. ");
INSERT INTO atgNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ọ lẹ deba li, ọ ku oili ali onyọ shi ọli ikpe ni ọ kuali utse. Ọ ri ide gẹnọ li ẹwẹ. Ọ tsua li nga akphẹrẹ ọyọli, ọ tsua li bhale owa ni a ku ẹ shi, ọọ gueyẹ wẹ e ri ẹloe khu ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ogbeakọlọ ọ ri ifata ogbẹlẹ eva na ọni ọ mhuẹ oni ashini a ku ẹ shi. Ọ ọli, ‘Kpẹkpẹ ri ẹloe khu ọmọse ọna. Ingmẹ ni o ke ya gbe nya, ini mhia jele mhi ya fali ẹ wẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ọghuo ọ elemhi ẹgbọ aasẹ ena u sa khi ọ khi ọnuzava ọyi ọni ọmọse ọna ni ighiatọ e gbe?” ");
INSERT INTO atgNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ọni ọsẹsẹ ushi ọọ li, “Ọni ọ mhuẹ ilẹlemhi na li.” Ighọ iJesu ọọ li, “Li lighọ ke ngeli.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Abi iJesu ali eniyẹ odukhokho eyọli e li lẹ, e bhale ẹoli oyi ọkpotso ni a lu iMata. Ọni iMata ọ mie ọli shi owa. ");
INSERT INTO atgNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ọni iMata ọ mhuẹ inyọghuo ọkpotso ni a lu iMeli ni ọ shitọ kpẹsẹ iJesu ri esọ shi emini ọ sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Abi a li ya mu iJesu epfẹse, o zu iMata alo, ọa mẹ asha ri esọ shi emini iJesu ọ sẹsẹ. Ighọ ọ bhale deba iJesu, ọọ li, “Wa mẹ khi inyọghuo-mhẹ ọ zobẹ ikanya nya na mhẹmhẹ-ghuo a gbe? Wẹ ọ bhale ya kpaghiẹ mhẹ obọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ọnọmhuẹ ọọ li, “IMata, iMata, u ma kphakpha egbe ke nasẹ egbe ẹ shi itobọ emhi ebubu. ");
INSERT INTO atgNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ama emhi oghuo o mema mu egbe. IMeli ọ she zẹ oni o tinẹ ni o laọ, ọgbọ ọa ya mie ọli luẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ogbẹlẹghuo, iJesu ọ la asheghuo o sọ iromhi, Abi ọ rọ sọ se, ọmọ odukhokho ọyọli ọghuo, ọọ li, “Ọnọmhuẹ, sẹsẹ anye abi a liẹ sọ iromhi abi iJọni ọ li sẹsẹ eniyẹ odukhokho eyọli.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","IJesu ọọ wẹ, “U kha sọ iromhi, ke liẹ: “ ‘Ita anye ni ọ la iloghie, anye ri ufumhi na eva oyẹ no pfuasẹ, Zẹ ni eghiele oyẹ o bhale. Zẹ ni a riẹlẹ ọghuẹmhẹ oyẹ ekẹ agbọ abi o li shi obini iloghie. ");
INSERT INTO atgNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ri eminale ona ogbe-namo na anye le. ");
INSERT INTO atgNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gbe olamhẹ kua na anye, abi anye li ẹ gbe kua na ẹgbọ ni e lamhẹ shi anye ọ. Khi zẹ ni anye de pfilo imufẹ, ama tsumhi anye obọ oyi ọkphaghiẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","IJesu ọọ wẹ, “Ini o khia khi ọngẹ ẹ ọ mhuẹ ọmọle ni ọ rọ lẹ deba ọmọle ọli itsotso ogbiẹ, ni ọ rẹ ọli, ‘Ọmuẹ kpẹkpẹ ngmomhi irui ibulẹdi esẹ na mhẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Irari khi ọmọle mhẹ ni ọ la asha ọ bhale ya kushi na mhẹ, ama mhia mhuẹ emini mhi ya rọ fẹli ọli epfẹse.’ ");
INSERT INTO atgNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ini ọni ọmọle ọ, ọ rọte elemhi owa liẹ ọli, ‘Khi ke nasẹ mhẹ ghue irari khi mhi she pfi okpẹ odẹ, mhẹmhẹ ali imimhẹ anye she yẹshi, mhia ke ya dobẹ vule ya rue emhi okhọghuo nẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mhi gueyẹ ẹ khi ini ọmọle ọli ọa tseku ri itobọ khi wẹwẹ e khi ọmọle vule ya rue emini ọọ mhila li na li, ama itobọ khi ọ mema kie le ẹ mhila li tsẹ, ọ mema ya vule ya rue emiemini ọ nono na li. ");
INSERT INTO atgNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mhi gue ẹ yẹ ẹ: Mhila khi a ya rọ nẹ, nono khi u ya mẹ, kpheli obọ odẹ khi a ya khueghie-a nẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Irari khi ọni ọ mhila lọli a rọ ọ na, ọni ọ nono lọli ọọ mẹ, ọni ọ kpheli obọ odẹ lọli a khueghie-a a na. ");
INSERT INTO atgNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ẹẹ ni a khi ita, ọghuo elemhi ẹ omiọli ọ ya mhila li afẹlẹ ni ọ ya rue ẹnyẹ na li, ocho ni ọ kha rọ ri afẹlẹ na li? ");
INSERT INTO atgNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ke khia khi ini ọ mhila li ẹkẹli, ni u ya rue okpi na li? ");
INSERT INTO atgNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ini ẹẹ ni a khi ẹgbọ ebe a lẹsẹ abi a liẹ ri egbegbi emhi somhi imiẹ opfa, sẹ Ita ẹ ni ọ la iloghie ọa ke li ya ri Ayẹmhẹ-nọ-pfuasẹ na eni e mhila li?” ");
INSERT INTO atgNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ẹlẹ oghuo khi iJesu ọ khu ayẹmhẹ ọkphaghiẹ ungmenu fiẹ, ọ khu ọni ayẹmhẹ fiẹ lase, ọni ungmenu ọọ ngme. Oni ingme o ri abọ sha ẹgbọ ni e la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama ẹgbọ eghuo ẹ, “Ekpabọ ebe oyi iBezebọ ni ọ khi oghie ọyi iyẹmhẹ ebe, ọ rọ a khu iyẹmhẹ ebe fiẹ lase.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Eghuo ọ, e mu ọli fẹ bino, ẹ ọli ọ riẹlẹ ọnyaloa ni o ri wẹwẹ ya mie shi ọli ọ khi Ẹshinẹgba ọ mie shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama iJesu ọ she lẹsẹ usamhi oyẹwẹ, ọ, “Eghiele ni o da kemhi egbọli o ya de, ọmhuẹ-apfẹ ni o da kemhi egbọli o ya de. ");
INSERT INTO atgNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ini Ọkphaghiẹ ọ kemhi egbọli, sẹ eghiele oyọli o li ya migha? Eri mhi a ngme ona itobọ khi ẹ khi ekpabọ oyi iBezebọ mhi rọ ọ khu iyẹmhẹ ọkphaghiẹ kua. ");
INSERT INTO atgNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mena ini mhi ri ekpabọ eyi iBezebọ ọ khu iyẹmhẹ ọkphaghiẹ kua, ekpabọ onoghuo eniyẹ eyi ẹẹ e rọ a khu wẹ kua? Eniyẹ eyi ẹẹ e ya gue ẹ ẹzọ itobọ ungmemhi ni a ngme ena. ");
INSERT INTO atgNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama ini o khia khi ekpabọ oyi Ẹshinẹgba mhi rọ ẹ khu iyẹmhẹ ọkphaghiẹ kua, oghọ o rọkhasẹ khi Eghiele oyi Ẹshinẹgba o she bhale ẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ọmọse ni ọ mhuẹ ekpabọ ọ kha ri itsua okhọli gbanọ egbe egbegbọ ni ọ rọọ khẹ owa oyọli ekhẹ, itsua eyọli e ya mhuẹ akhukhu. ");
INSERT INTO atgNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama ọmọse ni ọ toto dọsẹ ọli ọ kha tsua okhọli mu ọli ni ọ rọ nẹ ọli abọ, eri ọọ miono ọli itsua okhuẹ nya ni ọ regbenga. Ọ tsua ọli ẹpfue ni ọ mhuẹ shi oni owa vu ya kemhi. ");
INSERT INTO atgNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ọni ọa da ku ma mhẹ ọ ne, ọbe mhẹ ọ khi. Ọgbọ ni ọa da mu ma mhẹ ọ ti ẹgbọ gbili ne, eri ọọ vẹsẹ ẹgbọ kua. ");
INSERT INTO atgNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ini ayẹmhẹ ọkphaghiẹ ọ rọte ọgbọ egbe ya fiẹ, eri ọ kpẹ a kia je ifu ọdagbe ifufu ni amẹ ẹa la ya nono ashini ọ kpẹ je ya yẹmhẹ-a, ama ini ọa mẹ asha, ọ egbeluẹ, ‘Mhi gbo lo a je owa ni mhi kpẹ te vu.’ ");
INSERT INTO atgNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ini ọ bhale ọ ni ọ rọ bhale ya ẹ khi, a ga fuomhi oni owa muẹnẹ, emhikpa o ga guẹ la ayọli kuete. ");
INSERT INTO atgNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ighọ, ọ vu ya wolọ iyẹmhẹ oshilua elese ni e khọlọ dọsẹ lọli, e bhale ya la ọni ọmọse egbe, ikpukhokho oyi ọni ọmọse o ke khọlọ dọsẹ abi ọ kpẹ li.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Abi iJesu ọ li ngme oni ungmemhi ona, ọkpotso ọghuo ọ rọte oni elemhi ebubu ẹgbọ tsẹsẹ leghe ọọ, “Ọni a khi vọsẹ na ọkpotso ni ọ bia ẹ, ni ọ kuẹlẹ, ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","IJesu ọọ li, “Ẹgbọ ni e suọ ungmemhi oyi Ẹshinẹgba ni e rọ ọli gbe akanya, wẹwẹ e mema mhuẹ ikhivọsẹ nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Abi eni ẹgbọ e ke li bua shi ọ, iJesu ọọ, “Ẹgbọ ebe, ẹgbọ agbhotu onana e khi. Ẹ mhila ọlẹlẹ ọnyaloa, ama aa ya mẹ ọnyaloa okhọghuo, sẹ ni ọlẹlẹ oyi iJona ọmekẹguele. ");
INSERT INTO atgNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Abi iJona ọ khi ọlẹlẹ na ẹgbọ iNinevẹ, ighọ Omi ọgbọ ọ gbo li ya khi ọlẹlẹ na ẹgbọ ena agbhotu ona. ");
INSERT INTO atgNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Oghie-ọkpotso ọyi ekẹ iShẹba ọ ya shitọ ukpẹkhomhi ẹzọ ya gue agbhotu ona ẹzọ, ọ pfa ẹzọ mu wẹ, irari khi ọ ke rọte ekẹ odonuẹ bhale ya ri esọ suọ ungmemhi ẹgbhali oyi oghie iSolomoni, ama ọgbọ ni ọ fu dọsẹ iSolomoni ọ la akana. ");
INSERT INTO atgNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ẹgbọ iNinevẹ e ya mu ẹzọ vule shi agbhotu ona ọ, e pfa ẹzọ mu wẹ irari khi e mu pfi abi iJona ọ rọ ya ri ungmemhi oyi Ẹshinẹgba tse abọ yẹ wẹ, memena ọgbọ ni ọ fu dọsẹ iJona ọ la akana. ");
INSERT INTO atgNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Aa mẹ ọgbọ ni ọ ya ri ákpá ru ni ọ ya ri ọli sheli, eri ọ ri ochoghọ ya rue ọli nga ashini o yagha, ni a bhale ya ẹ khi ẹgbọ ni ẹẹ lole ẹ mẹ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ikpamhalo eyẹ e khi ákpá oyi idiegbe oyẹ. Ini ikpamhalo eyẹ ẹẹ mẹ ekẹ egbegbọ, idiegbe oyẹ nya o khili ákpá. Ama ini u tasẹ alo-a, idiegbe oyẹ nya o khili alo ebili. ");
INSERT INTO atgNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Itobọ ona khi zẹ ni ákpá oyẹ o khi alo ebili. ");
INSERT INTO atgNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ini idiegbe oyẹ e khili ákpá ni obili ọa rọ la ashikhọghuo ọ, eri o ya ke gẹ nyanyanya abinẹ khi ákpá o nga ọgbọ egbe.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Abi iJesu ọ rọ ngme se, iFarisi ọghuo ọ lu ọli ọ bhale ya nu luẹ le eminale. Ọ lo deba li ya shitọ shi oni eminale. ");
INSERT INTO atgNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ama abọ e sha ọni iFarisi abi ọ rọ mẹ khi iJesu ọa kpe abọ a neni ọ le emhi. ");
INSERT INTO atgNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ighọ Ọnọmhuẹ ọọ li, “Wa mẹ mena khi ẹẹ ẹgbọ iFarisi khi eri a kpe ukhokho uko ali itasa eyẹ-a, ama elemhi oyẹẹ o vọ emhi ituegbe ali ọkhọlọ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ẹẹ ẹgbọ eyẹghẹ! Ọa khi Ẹshinẹgba ni ọ riẹlẹ ukhokho ọ ọ gbolo ẹ riẹlẹ elemhi ọ? ");
INSERT INTO atgNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ama a rue emini e la elemhi uko ali utasa na ẹgbọ ni ẹa mhuẹ, ẹghẹghẹ aghọ emhikpa e ya pfuasẹ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O ma a khọlọ ẹẹ ẹgbọ iFarisi egbe gba, itobọ khi a guẹ zẹ azẹ-oghuo-igbe ebe akhọkhọ, ali ebe alagho ali ebe elese ni a rọte ogba ẹ khiẹsẹ, emini ẹa lolo mu ẹloe. Ama iguẹ-sọ-ẹzọ ali inono onayi Ẹshinẹgba, a ri obọ gbe wẹ shi. Ena e khi emini a kha mema ke riẹlẹ, ma eni a riẹlẹ eghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O ma a khọlọ ẹẹ ẹgbọ iFarisi egbe gba, irari khi ukpẹkhomhi ni o yagha a nono elemhi owa ugamhi ali otsẹ ekpẹ elemhi oki. ");
INSERT INTO atgNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“O ma a khọlọ ẹ egbe irari khi eri a li abi uji oyi ẹgbọ ni ọgbọ ọa shi ọlẹlẹ shi ni ẹgbọ e lighi ẹ dọsẹ, ni ẹa lẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ọsẹsẹ ushi ọghuo ọ sọli ọ, ọọ, “Ọsẹsẹ, ini u wa ngme enana, eri u li ri anye ma ọ mẹ bie.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","IJesu ọ sọli ọ, ọọ, “O ma a khọlọ ẹẹ ni a sẹsẹ Ishi eyi iMosisi egbe, irari khi eri a sọ itsua ni ẹgbọ ẹa dobẹ ya tsua na wẹ tsua, ama ẹẹ aa lama ya tsua ugegemhọ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“O ma a khọlọ ẹ egbe irari khi ẹẹ a manọ iji na emekẹguele ni itita ẹ e gbolo-a. ");
INSERT INTO atgNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Eri a pfi ọtsẹlẹ shi ọ, a gbo mu ma emini ititaẹ e riẹlẹ irari khi wẹwẹ e gbolo emekẹguele eyi Ẹshinẹgba a, ẹẹ a manọ iji na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Itobọ ona, rọte ilẹsingme oyi Ẹshinẹgba, ọ rọ liẹ, ‘Mhi ya ghie emekẹguele ali ighiusomhi na kẹẹ ghi wẹ, e ya gbolo eghuo ọ-a, e mu okhọli vule shi elese ọ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Itobọ ighọ Ẹshinẹgba ọ ya mu ota sọ ẹgbọ ena agbhotu ona, shi ọlia eyi emekẹguele nya, rọte ẹghẹghẹ ni agbọ ona o te gba ekẹ le. ");
INSERT INTO atgNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Rọte ọlia eyi Ebẹli ya ramhi ọlia eyi iZakaraya ni a gbe-a shi iteva Owa oyi Ẹshinẹgba ali atẹtẹ. Ighọ lọ! Mhi gueyẹ ẹ khi a ya na ẹ osue to ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O ma khọlọ ẹẹ ni a lẹsẹ Ishi eyi iMosisi pfo egbe, irari khi a she rue okpẹ ni a rọ ẹ khueghie odẹ ilẹsingme sheli. Ẹẹ na, aa lama lo, ẹgbọ ni ẹ nono ni wẹwẹ e lo, aa zẹ ni e mẹ asha dọsẹ lo.” ");
INSERT INTO atgNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Abi iJesu ọ rọ rọte aghọ vu, ẹgbọ iFarisi ali esẹsẹ Ishi eyi iMosisi e mu okhọli vule shi ọli ọ egbegbọ. E ri omhila ọdọda a khi ọli odẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ini e ba mẹ asha mu ungmemhi mhọli ọli obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ẹghẹghẹ ana ebubu ẹgbọ agbẹlẹ agbẹlẹ e legba, ni o ramhi ni e rọ lighi egbewẹ, iJesu ọ nu eniyẹ odukhokho eyọli ngme, ọọ wẹ. “A mu egbe ẹ shi iri-ugamhi ku alo oyi ẹgbọ iFarisi ni o li abi ifuma ni a rọ ma ibulẹdi ẹ nye.” ");
INSERT INTO atgNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Irari khi aa mẹ emini a rọ sheli ni ọa ya lasele, wẹkhi eri a mẹ emini a khukhu ni ọa ya khueghie-a. ");
INSERT INTO atgNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ungmemhi ni u ngme ẹliyọsẹ a ya suọ ọli ẹlẹ ọguota. Emini u nyẹsẹ ọgbọ esọ gueyẹ elemhi owa aza, a ya suọ ọli eko ukhomhi owa. ");
INSERT INTO atgNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Emọle mhẹ, abi o la mhi li gue ọli ẹ yẹ ẹ, a khi na ulishi ẹgbọ ni o khia khi idiegbe e lẹsẹ dobẹ ya gbe-a, ini e gbe idiegbe-a, ẹa ke mhuẹ emhi olese ni e ke dobẹ ya li. ");
INSERT INTO atgNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama mhi ya gueyẹ ẹ ọni a ya na ulishi. A na ulishi Ẹshinẹgba ni ọ mhuẹ itoto ni ọ kha gbe ọgbọa se, ọ gbo pfi ọli lo ilimhi iriẹriẹ. Abi o li mhi li gue ọli ẹ yẹ ẹ, a na ulishi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ọa khi ikọbọ eva a ri ipfeli isuẹsuẹ oshe ẹ dẹ? Ama abi o riẹ khi ighọ, Ẹshinẹgba ọa yele ọngẹwẹ ọkhọghuo a. ");
INSERT INTO atgNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Egbegbọ lọ khi, Ẹshinẹgba ọ she leli itsu ni e la ẹ ukhomhi nya. Itobọ ighọ a khi zẹ ni ulishi o mu ẹ, irari khi a mu ẹloe dọsẹ ipfeli isuẹsuẹ ebubu. ");
INSERT INTO atgNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Abi o li mhi li gue ọli ẹ yẹ ẹ khi, ọni ọ da lama gue ingme oyẹmhẹ yẹ ẹgbọ ne, Omi ọgbọ ọ li ya gue ingme oyọli yẹ igẹni eyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama ọni ọ da kie mhẹ ukpẹloe ẹgbọ, mhi ya li kie ọli ukpẹloe igẹni eyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ọgbọ ni ọ da zẹ ẹmuẹbe na Omi ọgbọ ne, a ya gbekua na li. Ama ọgbọ ni ọ da pfi unu-a deba Ayẹmhẹ-nọ-pfuasẹ, ọgbọ a ya gbekua na li. ");
INSERT INTO atgNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ini a rue ẹ bhale owa ugamhi oyi ẹgbọ iJu ali ẹgbọ eni ẹẹ mhẹsẹ ali enighie, a khi zẹ ni a yele abi a ya ngme, ali abi a li ya pfa egbe ẹ shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Irari khi Ayẹmhẹ-nọ-pfuasẹ ọ ya sẹsẹ ẹ abi a ya ngme oni ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ọgbọ ọghuo elemhi eni ebubu ẹgbọ ọ lu iJesu, ọọ li, “Ọsẹsẹ kpẹkpẹ gueyẹ inyọghuo-mhẹ ni ọ kemhi ugu na mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","IJesu ọ sọ ọli ọ, ọọ, “Ọghuo ọ zẹmhẹ shi ọni ọ rẹ ẹ a gue ẹzọ ali ọni ọọ kemhi ugu na ẹgbọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ighọ ọ gueyẹ wẹ nya, “A mu egbe ẹ shi emhi ituegbe, irari khi agbọ oyi ọgbọ ọa migha nga ukhomhi ẹpfue ni ọ mhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ọ zẹ okhẹ irọkhọkhọ ona khasẹ wẹ, ọọ wẹ, “Ekẹ oyi ọmọse ni ọ pfue ọghuo, o lolo ti emhi na li. ");
INSERT INTO atgNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ọni ọmọse ọ shitọ sa, Ọọ, ‘Sẹ mhi li ya kia eghọ? Mhi a mẹ asha ke ri emhi ya shi aka oyẹmhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ighọ ọọ, ‘Emini mhi ya riẹlẹ na. Mhi ya guọghọ aka oyẹmhẹ-a, mhi ya tọ aka onofunẹ olese ni mhi rọ sọ iakpa ali itsua elese shi. ");
INSERT INTO atgNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ẹghẹghẹ aghọ mhiẹ egbemhẹ, Ọmuẹ u zẹ ukhomhi onete gba e! Irari khi u mhuẹ ẹpfue ni e bububu, ni e ya tsua-ẹ ramhi ikpe ebubu. Ka yẹmhẹ-a, ke le, ke da. Wa li agbọ abi o ghọle ẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ama Ẹshinẹgba ọọ li, ‘Yẹyẹ ọyẹghẹ! U ya ghu-a amiọsẹ; mena ọghuo ọ ke ya mhọli eni ugu ni u she ti ma na egbe ẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ighọ o ya li ọgbọkpa egbe ni ọ da ti ẹpfue ma na egbọli, ni ọa mhuẹ ẹpfue oyi emini o mu Ẹshinẹgba ẹloe.” ");
INSERT INTO atgNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ighọ iJesu ọ gueyẹ eniyẹ odukhokho eyọli, ọọ wẹ, “Irarighọ, a khi zẹ ni usamhi emini a ya le ali usamhi emini a ya da, o nasẹ ẹ, wẹkhi usamhi idiegbe oyẹ emini u wa sọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Agbọ oyẹ o mu egbe dọsẹ eminale, idiegbe oyẹ o gbo mu egbe dọsẹ ode ni a sọ ẹ shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","A bino ipfeli na ukhomhi idane, ẹa rọ kọ wẹkhi eri ẹẹ khiẹsẹ, ẹa mhuẹ ashini e tsua eminale a shi wẹkhi eri e mhuẹ aka, ama eri Ẹshinẹgba ọ rọ na wẹ a le. A mu ẹloe dọsẹ wẹ! ");
INSERT INTO atgNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ọngẹẹ ọnọghuo ọ ya dobẹ ri irari inyama-egbe oyọli khi ogbẹlẹ oghuo ma agbọ oyọli? ");
INSERT INTO atgNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aborọkhia khi u wa ya dobẹ riẹlẹ ukuku emhi onana, elọ o zẹ ni u rọ a nasẹ egbe ẹ shi emini e kpọle? ");
INSERT INTO atgNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Sa ọ bino abi ebuli idodo e li ẹ fu. Ẹa ya gbe akanya wẹkhi eri ẹẹ do ide. Ama mhi gue a yẹ ẹ khi egbegbi iSolomoni ni ọ tseku lighọ mhuẹ itsua ni e somhi otse, ọa khuẹ akhuẹ nabi ebuli okhọghuo o khuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ẹẹ ni a mhuẹ ukuku irudunga, ini o khia khi ighọ Ẹshinẹgba ọ ri ide ku ebuli egbe, ni e kha laọ amo, akọ a tosẹ wẹ-a, sẹ u ke liẹ sa khi ọa ya li ri egbegbi itsua sọ ẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Irarighọ, a khi ke sa emini a ya le ali emini a ya sọ; a khi zẹ ni o nasẹ ẹ udu. ");
INSERT INTO atgNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Irari khi ẹgbọ ena agbọ ona nya, wẹwẹ e na khu emhi enana, ama Ita ẹ ni ọ la iloghie ọ lẹsẹ khi e to ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ochoghọ emiemini u wa riẹlẹ nya, zẹ ni Eghiele oyi Ẹshinẹgba o khi onododẹ, emhi elese ni u wa nono nya, ọ ya rẹwẹ ma ọ nẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“A khi zẹ ni ulishi o mu ẹ, ẹẹ ikuku isumha, irari khi ọghuẹmhẹ oyi Ita ẹ o khi ni ọ rọ ri oni eghiele na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","A ri emhikpa ni a mhuẹ dẹ, a kemhi eni ikpaghọ na eni ẹa mhuẹ. A zẹ ni a mhuẹ ẹkuẹ ukpaghọ ni ọa ya khakha, ali ni a gbo mhuẹ ẹpfue shi iloghie ni ọa ya pfo wẹkhi oghiatọ ọ mẹ asha a ti bhale ọ, wẹkhi ifu e mẹ asha a tọwẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Irari khi ashini ẹpfue oyẹ o la, aghọ udu oyẹ ọọ la. ");
INSERT INTO atgNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“A mu egbe shi ugamhi, a zẹ ni ikpa eyẹ ẹ e ke gẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Abi eni ẹ ga ọgbọ e migha khẹ ijele oyi ọni ọ mhuẹ wẹ ni ọ ye ukue ni a rọ a rue ọkpotso, ini ọọ bhale ni ọ rọ kpheli obọ odẹ, e nyanya khueghie odẹ a na li aghọaghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","O ma ti eni ẹ ga ọgbọ eghọ egbe ini ọni ọ mhuẹ wẹ ọ bhale ya ẹ khi e mu egbe migha khẹ luẹ. Abi o la mhi gue a yẹ ẹ khi, ọ ya mu egbe akanya, ọ lu wẹ, ọ nu wẹ shitọ, ọ ri eminale na wẹ le. ");
INSERT INTO atgNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Oghẹlẹ o ya khi na eni eni ẹẹ ga eghọ ini ọni ọ mhuẹ wẹ ọ bhale ya ẹ khi e mu egbe shi ekẹ ini o tseku khi itsotso ogbiẹ, o ke khi ini ogbe o ya gbe ọ rọ bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","A lẹsẹ ona khi ini ọni ọ mhuẹ apfẹ ọ lẹsẹ ẹghẹghẹ ni oghiatọ ọ rọ ọ bhale ọli owa ya do lọ, ọa kha zẹ ni ọ lo ọli owa ya do. ");
INSERT INTO atgNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ẹẹ oyẹẹ a ke mu egbe, irari khi Omi ọgbọ ọ dobẹ ya bhale ẹghẹghẹ ni aa sa shi.” ");
INSERT INTO atgNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","IPita ọ mhila li, ọọ, “Ọnọmhuẹ anye u kpe ekpita ona yẹ abi ọgbọkpa?” ");
INSERT INTO atgNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ọnọmhuẹ ọọ li, “Ọghuo ọ fẹ khi ọni ọrẹloekhu, ni ọ mhọli ilẹsingme, ni ọọ gbe akanya te odẹ igẹsikia, ni ọga ọyọli ọ ri apfẹ nga obọ, ni ọ gueyẹ ọli ọ ri eminale na eni ẹ ga li ke le shi ẹghẹghẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ikhivọsẹ o khi na ọni ọ ga ọgbọ ọghọ, ini ọga ọyọli ọ bhale ya ẹ ọli shi iguẹ-riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mhi gue a yẹ ẹ khi eri ọ ya ri emini ọ mhuẹ nya nga ọli obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama ini ọni ọọ ga ọgbọ ọghọ ọ la udu oyọli liẹ, ‘Ọga ọyẹmhẹ ọ she tẹsẹ ẹ dọsẹ,’ ni ọ rọ gbe eni ẹẹ ga eni ikpotso ali eni emọse ni a rọ shi ọli obọ, ọọ le, ọọ da, onyọ ọọ gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Eri ọni ọga ọyọli ọ ya bhale ẹlẹ ni ọa sa shi ni ọa ri ẹloe shi ekẹ ẹ khẹ ọli, ikhi ẹghẹghẹ ni ọa sa shi. Ọni ọga ọyọli ọ gbe ọli, ọ kuale ọli utse, ọ ghie ọli abọ pfilo deba ẹgbọ umha-suesọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ama ọni ọọ ga ọgbọ ọghọ, ni ọ lẹsẹ ọghuẹmhẹ oyi ọga ọyọli, ni ọa mu egbe ni ọ rọ riẹlẹ ọghuẹmhẹ oyọli, a ya gbe ọli itali, a nali osoli egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama ọni ọ ga ọgbọ ni ọa lẹsẹ ọghuẹmhẹ oyi ọga ọyọli ni ọọ riẹlẹ emini o ye ni a gbe ọli shi, a ya gbe ọli ukukuọ. Irari khi ọni a ri emini e bu na, emini e bu a ya mhila li. Ọni a ri emini e lolo bu nga obọ, emini e lolo bu a ya mhila li. ");
INSERT INTO atgNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Erali mhi bhale ya pfi shi ekẹ agbọ ona. Abi a khẹ khi e she a lala. ");
INSERT INTO atgNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mhi mhuẹ ibatizi ni mhi ya mie shi egbe. Egbe ẹa ke sheshe mhẹ ne ini mhia li mie ọli se. ");
INSERT INTO atgNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Eri a dabi khi opfọmhẹ mhi rọ bhale ekẹ agbọ? IIye! Okemhi mhi rọ bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rọte memena vu, ẹgbọ oshe ni e la ọmhuẹ-apfẹ oghuo e ya kemhi egbe. Aasẹ ọ e mu okhọli vule shi aava ọ, aava ọ e mu okhọli vule shi aasẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ita ali omiọli ọnọmọse e ya mu okhuẹ vule shi egbe wẹ ọ. Inyọ ali omiọli ọnọkpotso e mu okhuẹ vule shi egbe wẹ ọ. Inyọdọ ali ọsami ọli, e ya mu okhuẹ vule shi egbe wẹ ọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","IJesu ọ gueyẹ eni ẹgbọ nya, ọọ, “Ini a da mẹ khi otughunu o gbe shi obini ovọ o te ẹ tiemhi eko ne, aghọaghọ a liẹ khi amẹ o ya ruẹ, amẹ o ruẹ esheshighọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ini akpekpeli o rọte ukiẹkiẹ ọgobọ ini a sọ alo ghue obini ovọ o te ẹ lo eko ẹ li ne, ẹ khi ogbe o ya nye amo, esheshighọ o lighọ. ");
INSERT INTO atgNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ẹẹ erugamhi-ku-alo, a lẹsẹ abi a liẹ bino abi ekẹ ali ukhui o ngme, a guele abi ogbe o ya li. Elọ o zẹ khi aa lẹsẹ abi ẹghẹghẹ o ngme memena? ");
INSERT INTO atgNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Elọ o zẹ khi a gueyẹ egbe ẹ emini o te odẹ ni a ke riẹlẹ ọli? ");
INSERT INTO atgNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Abi yẹyẹ ali ọni ọ luẹ ẹzọ a liẹ ke lẹ ikọtu, rọshẹka ni a rọ riẹlẹ neni a ramhi ikọtu. Ini ọa khi ighọ, eri ọ ya ti ẹ bhale ufuẹgẹ oyi ọsọ-ẹzọ, ọni ọsọ-ẹzọ ọ muẹ ghi ọni ọ omhẹsẹ, ọni ọ mhẹsẹ eghọ muẹ ya pfilo owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mhi gueyẹ ẹ khi u wa ya tigbe lase aghọ le, ini u wa li fali oko ni a ya fiẹ pfo nya.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ẹghẹghẹ aghọ, ẹgbọ eghuo ni e la aghọ e gueyẹ iJesu abi oghie iPaleti ọ ku ọlia eyi ẹgbọ iGalili eghuo ni ọ gbolo-a ma ọlia eyi elamhakọ ni a rọ luasẹ obo. ");
INSERT INTO atgNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","IJesu ọọ wẹ, “Eri a dabi khi olamhẹ eyi eni ẹgbọ iGalili eghọ e dọsẹ olamhẹ eyi ẹgbọ iGalili ni e kpọle, ni o zẹ khi e ghọ na wẹ osue? ");
INSERT INTO atgNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iiye! Aa khi ighọ, ini ẹẹ aa li mupfi, ighọ ẹẹ a ya li pfua. ");
INSERT INTO atgNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Abi khi eri a dabi khi ẹgbọ ogbalale ni owa atọnga ni o la ekẹ iSiloamu o de mu gbolo-a eghọ, khi olamhẹ eyẹwẹ e khọlọ dọsẹ eyi ẹgbọ ni e kpọle ni e la iJerusalẹmu? ");
INSERT INTO atgNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","IIye! Mhi gue ẹ yẹ ẹ khi ini ẹẹ aa li mu pfi, ighọ a li ya pfua.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aghọ iJesu ọ la zẹ okhẹ irọkhọkhọ oyi ọara ọkhua-eni ni ọa ya mọ. Ọọ wẹ, “Ọmọse ọghuo ọ kọ ọkhua-eni shi ogba upfonu. Ọ je ọ ya bino ini lọli mẹ udumhi ọ pfa, ama ọa mẹ emhikhọghuo ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ọ gueyẹ ọmọse ni ọ ri ẹloe a khu oni ogba upfonu, ọọ li, ‘Oonokpe-esẹ na ni mhi te ẹ kiasẹ oni ọara ona ini mhi mẹ udumhi ọ, mhia mẹ okhọghuo. Ka khi ọli-a, elọ o zẹ ni o rọ le ekẹ shi afuẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ọni ọmọse ọ lema ọni ọ mhuẹ oni ogba ipfonu, ọọ li, ‘Ọga kpẹkpẹ zẹ ọli obọ ukpe ona bino ni mhi gua gasẹ udi ọli, ni mhi ku ifatalaza shi ọ bino. ");
INSERT INTO atgNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","O kha mọ idumhi ishukpe, o ti, ama ini ọa ke mọ, u khi ọli-a.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ẹlẹ iyẹmhẹa, iJesu ọ la owa ugamhi u sẹsẹ ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ọkpotso ọghuo ọ la aghọ ni o khia khi o gbe ikpe igbẹlele ni ayẹmhẹ ọkphaghiẹ o te mu ọli gọnọ-a. Eri ọ ke nyẹsẹ, ọa ke dobẹ ẹ vule migha. ");
INSERT INTO atgNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Abi iJesu ọ rọ mẹ ọli, ọ lu ọli lasele, ọọ li, “Kpotso, ughuamhi oyẹ o she pfo.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ọ ri abọ nga ọli egbe, aghọaghọ ọni ọkpotso ọ vule migha, ọ kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Elemhi e bi ọni ọ mhẹsẹ shi oni owa ugamhi khi iJesu ọ ri ọni ọkpotso ze ẹlẹ iyẹmhẹa. Ọni ọmọse ọọ ẹgbọ ni e le gba, “Ogbẹlẹ esesa e la ẹfo uka ni awa rọ ọ gbe ikanya, a ke bhale eni ogbẹlẹ esesa eghọ ni a la ọ rẹ ẹ ke ze, ama a khi ke bhale ẹlẹ iyẹmhẹa.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ọnọmhuẹ ọ sọ li ọ, ọọ, “Ẹẹ ẹgbọ eri ugamhi ku alo, ọa khi eri a taghiẹ ichi ali ikphẹrẹ eyẹ-a shi ashini a gẹnọ wẹ shi, a rue wẹ je okẹ ya da amẹ ẹlẹ iyẹmhẹa?” ");
INSERT INTO atgNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Elọ o ke zẹ ni ọkpotso ọna ni ọ li khi omiomi Aburaamu ni ọkphaghiẹ ọ she gẹnọ ikpe igbẹlele, ni aa rọ li ya taghiẹ ọli-a ẹlẹ iyẹmhẹa? ");
INSERT INTO atgNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Abi iJesu ọ rọ ngme ona se, omama o mu ẹgbọ ni e mu okhọli vule shi ọli ọ, ama ikanya ọnyaloa nya ni ọ gbe o ri egbe e mu eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","IJesu ọ mhila wẹ, ọọ, “Sẹ Eghiele oyi Ẹshinẹgba o fẹ li? Elọ mhi fẹ ya ri ọli khọkhọ? ");
INSERT INTO atgNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eri o li abi ukpamhi ọara iMọsitadi ni ọgbọ ọ rue ya kọ ogba. Oo fu, o mele ukpokpomhi ọara ni ipfeli e ku eko shi iguabọ eyọli a.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ọ gbo rọ mhila wẹ, “Elọ mhi fẹ ya ri Eghiele oyi Ẹshinẹgba khọkhọ? ");
INSERT INTO atgNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Eri o li abi ifuma ni ọkpotso ọ rọ ma italabi ifulawa esẹ wushe ni o fuma shiọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ẹghẹghẹ aghọ, iJesu ọ kiakia ẹoli khi ẹoli, ọ sẹsẹ ẹgbọ abi ọ li je iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ọgbọ ọghuo ọ mhila li, ọọ, “Ọnọmhuẹ, ikuku ẹgbọ tsẹ Ẹshinẹgba ọ ya mie pfuese?” IJesu ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“A rọshẹka ni a rọte unu-odẹ na pfi lo. Mhi gue a yẹ ẹ khi ebubu ẹgbọ e ya rọshẹka ni wẹwẹ e lo, ama, ẹa ya dobẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Itobọ khi ini ọni ọ mhuẹ owa ọ da vule ya pfi okpẹ odẹ ne, eri a mema migha olase ke kpheli odẹ shi afuẹ, a lema, a liẹ, ‘Ọga kpẹkpẹ khueghie odẹ a na anye.’ “Ama ọ sọ wẹ ọ, ọọ, ‘Mhi aa lẹsẹ ẹ wẹkhi eri mhi lẹsẹ obini a te bhale.’ ");
INSERT INTO atgNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ẹghẹghẹ aghọ, a ya liẹ, ‘Anye nu ẹ le, anye nu ẹ da, u gbo la ifu apfẹ eyi anye e sẹsẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ama ọ ya gbo liẹ, ‘Mhia lẹsẹ obini a te bhale. Ẹẹ nya a vu mhẹ ana lasele, ẹẹ ẹgbọ ọkhọlọ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aghọ ẹgbọ e la ke viẹ, ẹẹ gbe akọ akọ, ini a mẹ Aburaamu ali Aziki ali iGiekọpu ali emekẹguele obini Eghiele oyi Ẹshinẹgba ama a khu ẹ ya lase. ");
INSERT INTO atgNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ẹghẹghẹ aghọ ẹgbọ e ya rọte obini ovọ o te ẹ ngale ali obini ovọ o te ẹ lo eko, ali ukiẹkiẹ obita ali ukiẹkiẹ ọgobọ ini a sọ alo ghue obini ovọ o te ẹ lo eko bhale, e ya shitọ shi ukue na Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A bino khi a ya mẹ ẹgbọ eghuo ni e kpẹ kpe ukhokho e ya kpe odalo, ẹgbọ ni e kpẹ kpe odalo e ya ke kpe ukhokho.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ẹghẹghẹ aghọ ẹgbọ iFarisi eghuo e bhale deba iJesu, ẹ ọli, “Vu ana lasele irari khi oghie Erọdu ọ nono ni lọli gbe-a.” ");
INSERT INTO atgNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","IJesu ọọ wẹ, “A ka gueyẹ ọni anyakọ ọghọ, ‘Khi mhi ya khu ayẹmhẹ ọkphaghiẹ ẹgbọ egbe lasele ali mhi gbo ri ẹgbọ ya ze amo ali akọ, ama akọpfua mhi ya gbe akanya oyẹmhẹ pfo.’ ");
INSERT INTO atgNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Abibi o riẹ li, mhi mema ya ti okiali ke je odalo, amo ali akọ ali akọpfua, irari khi ọmekẹguele ọkhọghuo ọa khi ọni ọ mẹ asha a ghu shi ẹoli oboese sẹ ni iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Eekhue-oo! IJerusalẹmu, iJerusalẹmu. Ẹẹ ni a gbolo emekẹguele-a, ni a gbolo ẹ tono eni a ghie ghi ẹ echẹ, iti-ingmẹ o ghọle mhẹ ni mhi kono imiẹ kugbe, abi ọkhọkhọ ọ liẹ kono imi ọli shi ifu ipfua, ama ọa ghọle ẹ! ");
INSERT INTO atgNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A bino khi apfẹ oyẹ ẹ khi ikpukpu igbe e ke khi. Khi ọgbọ ọa ke la ọ, mhi gue a yẹ ẹ khi aa ke ya mẹ mhẹ, sẹ ini oni ẹghẹghẹ o ramhi ni a ke rọ a liẹ, ‘Ẹshinẹgba ọ khi vọsẹ na ọni ọ ri eva oyi Ọnọmhuẹ bhale.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ogbẹlẹghuo ẹlẹ iyẹmhẹa, iJesu ọ je apfẹ oyi ọkhẹmhuẹ iFarisi ọghuo ya le eminale, ẹgbọ e ri ẹloe mema shi ọli egbe ni e mẹ emini ọ ya li. ");
INSERT INTO atgNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Itobọ khi ọmọse ọghuo ọ la aghọ ni ọ fumhi abọ ali awẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","IJesu ọ mhila eni iFarisi ali eni ẹ sẹsẹ Ishi eyi iMosisi, “O fẹ ti elemhi Ishi eyi iMosisi ni ọgbọ ọ rọ ri ọgbọ ze ẹlẹ iyẹmhẹa, abi khi ọa ti?” ");
INSERT INTO atgNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ama ẹa pfa shi ọli ekẹ. Ighọ ọ pfi obọ rue ọni ọmọse, ọ rọli ze, ọ rue ọli obọ-a, ọli ọ ke je. ");
INSERT INTO atgNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ọ mhila wẹ, ọọ wẹ, “Ọngẹẹ ọnọghuo ọ ya mhọli ọmọ, o ke khi ẹna ni ọ ya de pfilo ilija ni ọa ya nyanya mu ọli ọ lasele, ini o riẹkhi ẹlẹ iyẹmhẹa?” ");
INSERT INTO atgNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ẹa mẹ sọ shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","IJesu ọ mẹ abi ẹgbọ eni a lu bhale oni ukue, e li ya shitọ ashini o mhuẹ ekpẹ shi oni ukue, ọ zẹ okhẹ irọkhọkhọ khasẹ wẹ, ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ini ọgbọ ọ lu ẹ bhale ukue ni a la rue ọmueshi khi kpẹ todẹ ya shitọ ashini o mhuẹ ekpẹ, itobọ khi, otsẹ a she li kpẹ lu ọgbọ ni ọ mu ẹloe dọsẹ li shi oni ukue. ");
INSERT INTO atgNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ini a mẹ ghọ, ọni ọ lu ẹ shi ukue, ọ ya bhale deba ẹ, ọọ, ‘Kpẹkpẹ vule ni ọmọse ọna ọ shitọ.’ Ẹghẹghẹ aghọ u ri omama ya shitọ ukpẹkhomhi onikeke. ");
INSERT INTO atgNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama ini a lu ẹ shi ukue, kpẹ ya rue ukpẹkhomhi onikeke shitọ na rọ bhale ya ẹ khi ọni ọ luẹ shi oni ukue ọ bhale deba ẹ, ọọ ‘Ọmuẹ, vule je ukpẹkhomhi ni o yagha.’ Ẹghẹghẹ aghọ u mhuẹ ekpẹ shi ukpẹloe oyi ọgbọkpa ni ọ ga la oni ukue. ");
INSERT INTO atgNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Irari khi ọni ọ da ti egbọli nga, a ya ti ọli tiemhi, ama ọni ọ da ti egbọli tiemhi, a ya ti ọli nga.” ");
INSERT INTO atgNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ighọ iJesu ọ gueyẹ ọni ọ lu ọli shi oni ukue, “Ini u ya nye ekhe fẹli ẹgbọ, khi lẹsẹ lu emọle ẹ, ali inyọghuo ẹ, ali ẹgbọ eyẹ ali eni e pfue tsẹ, irari khi e li dobẹ ẹ ghie lu ẹ shi ekhe ni e nye ẹlẹlese, ni o li abinẹ khi e she fali ẹ ota to ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama ini u mhọli ukue, luno ẹgbọ eni ẹa mhọli ali ẹgbọ eni ẹa mhọli awẹ ẹ kia ali eni e guọghọ awẹ-a ali ezalo. ");
INSERT INTO atgNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ẹghẹghẹ aghọ u mhọli ikhivọsẹ. Itobọ khi ẹa ya dobẹ fali ẹ oru to ọ. U ya mẹ eleli ogbẹlẹ ite-eghuli-guale oyi ẹgbọ ni e pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Abi ọmọse ọghuo ni e ga shitọ shi eni ekhe, ọ rọ suọ abi iJesu ọ ngme, ọọ li, “Oghẹlẹ o ya khi na ọgbọ ni ọ ya la ukue na Eghiele oyi Ẹshinẹgba le emhi.” ");
INSERT INTO atgNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","IJesu ọ sọ ọli ọ, ọọ li, “Ọmọse ọghuo ọ mu egbe ni ọ rọ ya mhuẹ ukue oniẹmhi. Ọ lu ebubu ẹgbọ shi oni ukue. ");
INSERT INTO atgNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ẹghẹghẹ oni ukue o ramhi, ọ ghie ọni ọọ ga li ghi ẹgbọ ni ọ lu shi oni ukue, ọ ọli ọ ka gueyẹ wẹ, ọ liẹ, ‘A bhale khi mhi she mu egbe se.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ama ọgbọgbọ ọ guele emini o zẹ khi lọli a ya mẹ asha bhale. Ọni ododẹ ọọ li, ‘Mhi lẹsẹ dẹ ekẹ ishemhi, mhi ya lẹ ya bino ọli. Kpẹkpẹ khi wola.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ọlese ọọ li, ‘Mhi lẹsẹ dẹ ena agbhagbhamhi ishe ni a gẹ toma aava aava kugbe, ni a rọ gua ishemhi. Mhi ya lẹ ya rẹwẹ gbe akanya bino. Kpẹkpẹ khi wola.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ighọ ọlese ọọ, ‘Mhi lẹsẹ rue ọkpotso mhi aa ya mẹ asha bhale.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ighọ ọni ọọ ga ni a ghie eghọ, ọ nyenẹ egbe ukhokho ya gueyẹ ọga ọyọli, abi eni ẹgbọ e ngme nya. Ighọ elemhi e li bi ọni ọdapfẹ. Ọọ ọni ọ ga li, ‘Nyanya fiẹ je olase, ka kia odẹ ni e je ifu apfẹ nya, wolọ ẹgbọ eni ẹa mhuẹ. Eni e ghu abọ ali awẹ-a ali ezalo ali eni ẹa dobẹ a kia bhale.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ighọ ọni ọọ ga ọgbọ ọ bhale, ọọ ‘Ọga mhi she ye usomhi ni u ghie mhẹ, ama owa ọa kie vọ ẹgbọ ne.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ighọ ọni ọga ọ gueyẹ ọni ọọ ga ọgbọ ọghọ, ọọ, ‘Je odẹ ali ifu apfẹ ya lu wẹ lole ni owa oyẹmhẹ o vọ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mhi gueyẹ ẹ khi ọgbọkhọghuo ọa la ẹgbọ ni mhi ri ebe ghi ni ọ ya ri unu mu eminale ni mhi nye.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ebubu ẹgbọ e deba iJesu lẹ iJerusalẹmu, iJesu ọ nyenẹ alo gueyẹ wẹ, ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ini ọgbọ ọkhọghuo ọ da nono ni lọli bhale deba mhẹ ni ọa rọ da kie itali ali inyọli ali ughuẹ ọli ali imiọli, ali inyọghuo ọli, ali agbọ ọyọli ne, ọa ya dobẹ khili ọmọ odukhokho ọyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ọgbọ ni ọa da tsua apfida oyọli ke deba mhẹ ne, ọa ya dobẹ khi ọmọ odukhokho ọyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ọngẹẹ ọnọghuo ọ ya tọ owa atọnga ni ọa ya kpẹ todẹ shitọ ta ingmẹ ni o ya gbe ọli, ni ọ mẹ ini lọli ya mhuẹ ikpaghọ tọ li pfo? ");
INSERT INTO atgNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ini ọa khi ighọ, ọ kha ri ọli gbe ni ọa ke rọ dobẹ tọ li pfo, eri ẹgbọkpa ni e da mẹ oni owa e ri ọni ọmọse ya ke li egia. ");
INSERT INTO atgNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","E liẹ, ‘Ọmọse ọna ọọ tọ owa ama ọa ke dobẹ tọ li pfo.’ ");
INSERT INTO atgNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Oghie ọnọghuo ọọ nono ni lọli ri okhuẹ ghie oghie ọlese ni ọa kpẹ todẹ ya shitọ sa bino ini lọli ya dobẹ ri ẹgbọ agbẹlẹ igbe 10,000 ya nu ọni oghie ọghọ ni ọ mhuẹ ẹgbọ agbẹlẹ uye 20,000 khọli? ");
INSERT INTO atgNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ini ọ mẹ khi lọli aa ya tẹ ọli ọ, eri ọ ya nyanya ghie ẹgbọ ghi ọni oghie abi ọa li ramhi ọli egbe ne, ọọ li zẹ ni wẹwẹ e rọ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ighọ khi ọgbọ ni ọa rue emhikpa ni ọ mhuẹ obọ-a, ọa ya dobẹ khi ọmọ odukhokho ọyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ugbheli o ma ti gba, ama ini ugbheli ọa ke mhuẹ iviọlọ oyọli, sẹ a ka gbo dobẹ ya ri ọli ke gbo mhuẹ iviọlọ oyi ugbheli? ");
INSERT INTO atgNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ẹghẹghẹ aghọ aa ke ri ọli ya riẹlẹ emhi okhọghuo, wẹkhi eri a ya ku ọli shi ekẹ ni o ri ekẹ wọghọ, ama eri a ke ya ku ọli kua. “Ọni ọ mhuẹ esọ ọ rọ suọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ighọ ebubu emionoga ali ena olamhẹ e bhale ti mama iJesu ni e rọ suọ ingmemhi ni ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ama ẹgbọ iFarisi ali esẹsẹ Ishi eyi iMosisi ẹ, “Ọni ọmọse ọna ọ kpe abọ ẹ mie ẹgbọ olamhẹ, ọ gbo nu wẹ ẹ le eminale.” ");
INSERT INTO atgNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ighọ iJesu ọ zẹ okhẹ irọkhọkhọ khasẹ wẹ, ọ, ");
INSERT INTO atgNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ini o khia khi ọngẹ ẹ ọ mhuẹ isumha egbhuẹshe, ni a rọ bhale ya ẹ khi ọghuo ọ wa ọ a, sẹ ọ ya li? Aa khi eri ọ ya zẹ ọghuo ọa la egbhuẹshe eni e kpọle obọ shi ifu ọdagbe ifufu, ọ vu ya nono ọghuo ni ọ wa eghọ, ramhi ni ọ rọ ya mẹ ọli mu? ");
INSERT INTO atgNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ini ọ mẹ ọli, egbe ẹẹ mu ọli, ọ mu ọli ta ike. ");
INSERT INTO atgNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ini ọ ramhi apfẹ, ọ luno emọle ọli ali idogbapfẹ eyọli, ọọ wẹ, ‘A bhale ya nu mhẹ ghẹlẹ irari khi osumha ọyẹmhẹ ni ọ wa, mhi she mẹ ọli mu.’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mhi gueyẹ ẹ khi ini ọgbọ olamhẹ ọ mu pfi, oghẹlẹ o la iloghie dọsẹ ọgbọ ọghuo ọa la egbhuẹshe ni e she pfuasẹ ni ẹa ke nono imupfi. ");
INSERT INTO atgNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ini o khia khi ọkpotso ọ mhọli ikpẹkhuli igbe, ni ọ rọ wasẹ oghuo ọ-a, sẹ ọ ya li? Ọa khi eri ọ ya ri ákpá ru, ọ fuomhi owa nguẹnẹ, ọ kuegbe-a nono ọli ramhi ni ọ rọ ya mẹ ọli rue? ");
INSERT INTO atgNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ini ọ mẹ ọli rue, ọ luno emọle ọli ali idogbapfẹ eyọli, ọọ wẹ, ‘A bhale ya nu mhẹ ghẹlẹ irari khi ukpẹkhuli oni o wa mhẹ-a, mhi she mẹ ọli rue.’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mhi gueyẹ ẹ khi ighọ igẹni eyi Ẹshinẹgba e liẹ ghẹlẹ ini ọgbọ olamhẹ ọghuo ọ mu pfi.” ");
INSERT INTO atgNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","IJesu ọ gbo zẹ okhẹ irọkhọkhọ ona khasẹ wẹ, ọọ wẹ, “Ọmọse ọghuo ọ ya laọ ni ọ mhuẹ eniyẹ emọse aava. ");
INSERT INTO atgNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ọnikeke ni ọ laọ, ọọ itali, ‘Itamhẹ, kemhi ugu ni o ya khi oyẹmhẹ na mhẹ.’ Ighọ ọni itali ọ kemhi oni ugu na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ọa tẹsẹ ne, ọni ọmọ ọghọ ọ tsua ugu eyọli. Ọ vu je ẹoli odonuẹ oboese, ọ ya pfuse ẹpfue eghọ kua. ");
INSERT INTO atgNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ọ pfuse ẹpfue eghọ nya kua se, ukpokpomhi okiamhi o lo oni ushishi oghọ nya le. Ọyẹmhẹ o gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ighọ ọ lẹ deba ọmọse ni ọ khi ọmọ ekẹ aghọ. Ọ ri egbọli mele ọni ọọ ga ọni ọmọse-a. Ọ ghie ọli je ishemhi oyọli ni ọ ri eminale na igulu eyọli ke le. ");
INSERT INTO atgNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ọ nono ini lọli mẹ asha ke le eminale ni eni igulu e le kpọle. Ama ọgbọkhọghuo ọa bọ eminale na li. ");
INSERT INTO atgNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Abi ẹgbhali eyọli e rọ tiemhile, ọ mhila egbọli, ‘Ọa khi eri ighumha eyi itamhẹ nya e mẹ eminale a le, e kẹsẹ shi, ni mhi rọ la ana ri egbe na okiamhi a gbe ya ghua! ");
INSERT INTO atgNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mhi nyenẹ egbe ya je apfẹ deba itamhẹ, ni mhi ya liẹ ọli, Ita mhi she lamhẹ na Ẹshinẹgba ali yẹyẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mhia ke tẹ ọni abi a lu omiẹ, rue mhẹ abi oghumha ọghuo ọyẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ighọ ọ vu ya je deba itali. Ama abi ọ li bhale ni ọ kie nuata shi apfẹ eghọ, itali ọ mẹ ọli, ọ mhuẹ ilẹlemhi na li. Ọ na ya mu ọli, ọ pfi abọ gege ọli uruli, ọ pfi ọli ẹlẹmhi egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ọni ọmọ ọọ itali, ‘Itẹ, mhi she lamhẹ shi Ẹshinẹgba ali yẹyẹ ọ, mhia ke tẹ ni a lu omiẹ, ke riẹlẹ mhẹ abi eni ẹẹ ga ẹ ọtuọghuo.’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama itali ọ luno eni ẹẹ ga li, ọọ, ‘Okuekhoogo! A nyanya a rue egbegbi itsua ni e somhi otse nya bhale sọ li. A rue ukhui shi ọli obọ, ni a ri ekuẹ sọ li. ");
INSERT INTO atgNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A mu ẹna ni ọ khọbọ bhale ni a gbe ọli-a ni awa mhuẹ ukue ke ghẹlẹ gbii. ");
INSERT INTO atgNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Irari khi eri omimhẹ ọna ọ kpẹ ghu-a ama ọ she guale. Eri ọ kpẹ wa ama a she mẹ ọli rue.’ Ighọ e lu ukue, e ghẹlẹ gbii. ");
INSERT INTO atgNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ẹghẹghẹ aghọ omiọli ọnọgbhali ni ọ kpẹ la ifui ishemhi ọ rọte ishemhi jele. Abi ọ rọ ti mama apfẹ, ọ suọ eko ebọla ali ishimhi. ");
INSERT INTO atgNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ọni omiọli ọghọ ọ lu ọni ọọ ga ọyi itali ọghuo, ọ mhila li, ọ, ‘Elọ a mẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ọni ọọ ga ọọ li, ‘Inyọghuo ẹ ọ jele, ni itẹ ọ rọ gbe ẹna ni ọ gbẹdi ọghuo-a. Irari khi ọ jele shi itoto ali oghẹlẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ighọ elemhi e bi ọni inyọghuo ọli ọnọgbhali ọghọ, ọa ke lama lo owa le. Ighọ itali ọ lẹ deba li, ọ lema li ọ lo le. ");
INSERT INTO atgNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama ọọ itali, ‘Bino oonokpe-ingme ni mhi te la ana a gẹ, ni mhia a tigbe da ushi oyẹ okhọghuo ghue, ama agbọagbọ wa tigbe mu ẹlamhi ọkhọghuo na mhẹ ghue, ni emọle mhẹ e li nu mhẹ ghẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama abi omiẹ ọna ni ọ tsua itsua ẹpfue eyẹ ya pfuẹchẹ kua na idegbe ọ rọ jele, u ya gbe ẹna ni ọ gbẹdi-a na li.’ ");
INSERT INTO atgNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Itali ọọ li, ‘Omimhẹ, ẹghẹghẹ kpa u te nu mhẹ la akana, emhikpa ni mhi mhuẹ eyẹ e khi. ");
INSERT INTO atgNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama o ti ni awa ghẹlẹ, irari khi eri inyọghuẹ ọna ọ kpẹ ghua, ama ọ she nyenẹ egbe bhale agbọ; eri ọ kpẹ wa ama a she mẹ ọli rue.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","IJesu ọ zẹ okhẹ irọkhọkhọ khasẹ eniyẹ odukhokho eyọli, ọọ wẹ, “Ọmọse ọghuo ni ọ pfue ọ la ọ, ọ mhuẹ ọrẹloekhu ẹpfue enayọli. A gueyẹ ọni ọmọse khi ọni ọrẹloekhu ọ pfuse luẹ ẹpfue-a. ");
INSERT INTO atgNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ighọ ọ lu ọli, ọ mhila li, ‘Elọ ona o khi ni mhi a suọ idiegbe oyẹ? Rọkhasẹ mhẹ ghue abi u li gbe akanya oyẹ irari khi waa ke gbolo ya khi ọrẹloekhu ọyẹmhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ighọ ọni ọrẹloekhu ọ sa ọ, ‘Sẹ mhi li ya kia abi ọga oyẹmhẹ ọ rọ ya khu mhẹ akanya ena? Mhi aa mhuẹ itoto ni mhi rọ dobẹ ya gua ishemhi. Omama omhila kia-kia ọọ mu mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mhi lẹsẹ abi mhi ya li ini ẹgbọ e zẹmhẹ lo apfẹ oyẹwẹ le ini a khu mhẹ akanya.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ighọ ọ lu ẹgbọ ni e lo ọga ọyọli ota. Ọ mhila ọnododẹ, ‘Ingmẹ u lo ọga ọyẹmhẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ọọ li, ‘Igalọ oili olivu egbhuẹshe asha elele.’ Ọni ọrẹloekhu ọọ li, ‘Mọ ebe, shitọ khi wẹ-a, ni u kẹkẹ igalọ egbhuẹshe asha ene.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ọ mhila ọnuzava, ‘Ingmẹ yẹyẹ u lo?’ “Ọọ li, ‘Ikpulu ado agbẹlẹ.’ “ ‘Ọọ li, mọ ebe shitọ khi wẹ-a ni u kẹkẹ egbhuẹshe asha eleli.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ọni ọga ọghọ ọ kuẹghiẹ ọni ọrẹloekhu ọna ikpamhika ọghọ, irari khi ọ riẹlẹ ingme ikpamhika ni o li abi ilẹsingme. Irari khi ẹgbọ ena agbọ ona e lẹsẹ abi e li ri ikpamhika nu egbe ẹ ngeli dọsẹ abi ẹgbọ ni e khi ena ákpá ẹ li. ");
INSERT INTO atgNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mhi gue ọli ẹ yẹ ẹ, a ri ẹpfue ni a mhuẹ mu emọle shi agbọ ona ni a rọ bhale ya ẹ khi ini e pfo, a ya zẹ ẹ lo iloghie. ");
INSERT INTO atgNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ọgbọ ni a da dobẹ ri egbe ẹ nga shi ukuku emhi ni a rọ nga li obọ ne, ọ ya zẹ regbenga shi eminiẹmhi, ini a rọli nga ọli obọ. Ọni ọa da zẹ ri egbe ẹ da shi ukuku emhi ne, ọa ya zẹ ri egbe da shi eminiẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ini u wa zẹ ni a regbenga shi ẹpfue na agbọ ni a rọ shi ẹ obọ, sẹ a li ya ri egbegbi ẹpfue ngẹ obọ? ");
INSERT INTO atgNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ini o khia khi u wa zẹ ri egbe ẹ nga shi ẹpfue oyi ọgbọẹse, ọghuo ọ ya ri oyẹ nẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Aa mẹ ọni ọọ ga ọgbọ ni ọ dobẹ ya ke ga ega aava utoghuo. Eri ọ ya nono ingme oyi ọghuo, ọa nono ingme oyi ọnọkpọle. Ọọ suọ esọ na ọghuo dọsẹ ọnọkpọle. Wa dobẹ ya ke ga Ẹshinẹgba u gbolo ẹ ga ukpaghọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Abi ẹgbọ iFarisi ni e nono ingme ukpaghọ dọsẹ e rọ suọ ona, e dọ iJesu ọkọnyọ. ");
INSERT INTO atgNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","IJesu ọọ wẹ, “Eri a ngeli ukpẹloe agbọ ni a rọ ke khasẹ khi eni angeli oyẹwẹ o migha shi ipfuasẹ a khi, ama Ẹshinẹgba ọ lẹsẹ usamhi udu oyẹẹ. Emini ẹgbọ ẹẹ bino khi oo mu ẹloe gba, eri ọọ kpasẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Eri a ri Ushi oyi iMosisi ali emini emekẹguele e kẹkẹ gbe akanya ramhi ẹghẹghẹ oyi iJọni Ọni ọọ batazi ẹgbọ. Rọte ẹghẹghẹ aghọ vu ya ramhi memena, eri a ri ungmemhi oyi Eghiele oyi Ẹshinẹgba a tse abọ, ọgbọkpa ọ rọshẹka ini lọli dobẹ lo ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","O ya kẹlẹ ni ekẹ ali ukhuli ni e kelea, ama ukpamhi ungmemhi okhọghuo kpele ọa ya de Ishi eyi iMosisi pfi-a. ");
INSERT INTO atgNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ọmọse ni ọ da khu ughuẹ ọli pfia ni ọ ya rue ọkpotso ọlese ne, ọ she kia okia. Ọmọse ni ọ da rue ọkpotso ni a khu ughuẹ, ọ she li kia okia. ");
INSERT INTO atgNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ọmọse ọghuo ọ ya laọ ni ọ mema pfue. Ọọ sọ itsua enete ni e somhi otse ni e ghalẹ, ọ li agbọ nyafunyafu ogbẹlẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ọmọse ọghuo ọna umhamẹ ni a lu iLazarọsi, ọ li ya la ọ. Igboko e gẹ ọli. A tsua li bhale odẹ unuẹkpẹ oyi ọni ọmọse ni ọ ghọ pfue ọghọ ẹghẹghẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eri ọni iLazarọsi ọ shitọ oni odẹ unuẹkpẹ oyọli ini lọli mẹ eminale ni e rọte ọli ukhomhi itebu de kua rue le. Eri ewa e gbolo bhale ya lalọ ọli eni igboko. ");
INSERT INTO atgNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ẹghẹghẹ o bhale ni ọni iLazarọsi ọ rọ ghua. Igẹni eyi Ẹshinẹgba e bhale ya tsua li je ashini Aburaamu ọ la. Ọmọse ni ọ lighọ pfue eghọ, ọ li ghua, a ri ọli tọ. ");
INSERT INTO atgNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ilimhi iriẹriẹ ni ọ la mẹ osue, ọ yasẹ alo idane, ọ mẹ Aburaamu khi ọ nuata shi luẹ egbe, iLazarọsi ọ shitọ mama li. ");
INSERT INTO atgNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ighọ ọ lu leghe, ‘Aburaamu ita! Kpẹkpẹ mhuẹ ilẹlemhi na mhẹ. Ghie iLazarọsi ni ọ to obọ amẹ to mhẹ ẹlẹmhi, itobọ khi mhi la ukpokpomhi osoli elemhi erẹ memena.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ama Aburaamu ọọ li, ‘Ọmọ sato khi abi u rọ la agbọ, u she mie eminete eyẹ, ama iLazarọsi ọ mie emini ẹa ti eyọli. Mena egbe e pfọmhi ọli shi ana, yẹyẹ u la ukpokpomhi osoli. ");
INSERT INTO atgNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ini a ri obọ rue ona ọ shi ekẹ, rọte ashini u la bhale ana ugbilimhi ekẹ o pfa awa a. Irarighọ, eni ẹẹ nono ni wẹwẹ e rọte ana da je obini u la, ẹa ya dobẹ wẹkhi eni e la obini u la e dobẹ ya da bhale deba anye oola.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ọni ọmọse ọọ ọli, ‘kpẹkpẹ mhia lema ẹ, ghie iLazarọsi je apfẹ oyi itamhẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","irari khi mhi mhuẹ inyọghuo emọse oshe. Zobẹ ni ọ ya tse agua yẹ wẹ ini e khi bhale asha osoli ona.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aburaamu ọ sọ ọli ọ, ọọ li, ‘E mhuẹ Ishi eyi iMosisi ali emekẹguele, e ri esọ shi wẹ ekẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ọni ọmọse ọọ li, ‘IIye, Aburaamu ita, ini ọgbọ ọ rọte eghuli guale ya tse agua yẹ wẹ, e ya mu nyenẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aburaamu ọọ li, ‘Ini ẹa ri esọ shi emini Ishi eyi iMosisi ali emekẹguele e ngme, ẹa ya ri esọ shi ekẹ ini ọgbọ ọ tseku rọte eghuli guale.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","IJesu ọọ eniyẹ odukhokho eyọli, “Emini e ri ọgbọ ọ lamhẹ olamhẹ e mema ya bhale, ama o ma khọlọ ọni ọgbọ ni o rọte obọ oyọli bhale egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","O ti nẹ ini a mu ẹchẹ iko zu ọgbọ ọghọghọ uruli tsua pfilo okẹ oniẹmhi, dọsẹ ni ọ rọ ya zẹ ni ọtuọghuo ikuku eniyẹ enana ke lamhẹ olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","A mhọli ẹgbhẹ shi emini a riẹlẹ. “Ini inyọghuo ẹ ọ lamhẹ, gue ọli yẹ ọli. Ini ọ mu nyenẹ, gbekua na ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ini ọ lamhẹ nẹ iti ishilua ogbẹlẹ, ni ọ rọ bhale ya lema ẹ eni iti ishilua eghọ, ni ọ rẹ, ‘Mhi mu nyenẹ.’ U mema ya gbekua na li.” ");
INSERT INTO atgNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eni ighiusomhi na kẹẹ ogbava ni iJesu ọ zẹ, ẹẹ, “Ọnọmhuẹ, zese irudunga oyanye-a.” ");
INSERT INTO atgNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ọnọmhuẹ ọọ wẹ, “Ini u mhuẹ irudunga ni o she abi ukpamhi imọsitadi, u ya liẹ ọara ọaghiẹ ona, ‘Ọọ ekẹ-a, ni u ya gbọla shi elemhi okẹ oniẹmhi!’ O ya suọ nẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ini ọngẹẹ ọ fẹ mhuẹ ọni ọọ ga li ni ọ gua ishemhi ẹ nali, okekhi isumha ọ ri ẹloe ẹ khu nali. Eri ọ ya liẹ ọli, ‘Nyanya bhale ya le eminale ini ọ rọte ishemhi jele’? ");
INSERT INTO atgNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ọa khi eri ọ ri ochoghọ ya kpẹ liẹ ọli, ‘Ka nye emhi ogbọmhi na mhẹ, u kpha li na mhẹ ni mhi le. Mhi kha le se, ni mhi rọ da se, u tigbe ya le oyẹ’? ");
INSERT INTO atgNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ọ ya tsẹ ọni ọ ga ọgbọ ọghọ ọ mu ikanya irari khi ọ da ye usomhi ni ọ ghie ọli? ");
INSERT INTO atgNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ighọ khi ẹẹ, ini a riẹlẹ abi a ghie ẹ se, a ke liẹ, ‘Eni ẹ ga ọgbọ tsẹ anye khi, akanya khi akanya oyi anye, anye ẹ gbe.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Abi iJesu ọ rọ je iJerusalẹmu, ọ rọte iteva ẹoli iSameria ali ẹoli iGalili ii dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Abi ọ li lo ẹoli oghuo le, emọse ogbe ni efafe e mu e bhale deba li, e ta pfia migha. ");
INSERT INTO atgNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","E tsẹsẹ leghe, ee liẹ, “IJesu Ọnọmhuẹ, mhuẹ ilẹlemhi na anye!” ");
INSERT INTO atgNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Abi iJesu ọ rọ mẹ wẹ, ọọ wẹ, “A ka ri egbe ẹ khasẹ ekpodalo-ugamhi eyi Ẹshinẹgba.” Abi e li lẹ eghọ, eni efafe e kala wẹ egbe-a, e ze. ");
INSERT INTO atgNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ighọ ọghuo ọ elemhi wẹ, abi ọ rọ mẹ khi lọli ze, ọ nyenẹ egbe ukhokho bhale, ọ kuẹghiẹ Ẹshinẹgba leghe. ");
INSERT INTO atgNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ọ bhale ya de yẹshi iJesu odalo, ọ tsẹ ọli uwegbe. Ọngi iSameria ọni ọmọse ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ighọ iJesu ọ mhila wẹ, “Ọa khi ẹgbọ ogbe a rọ ze? Ighe otiale ni e kpọle? ");
INSERT INTO atgNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aa mẹ ọngẹwẹ ọkhọghuo ni ọ nyenẹ egbe ukhokho bhale ya kuẹghiẹ Ẹshinẹgba, sẹ ni ọpfẹse ọnana?” ");
INSERT INTO atgNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","IJesu ọ li, “Vule ke je, irudunga oyẹ o she rẹ ze.” ");
INSERT INTO atgNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","IFarisi eghuo e mhila iJesu ẹghẹghẹ ni Eghiele oyi Ẹshinẹgba o rọ ya bhale. IJesu ọọ wẹ, “Eghiele oyi Ẹshinẹgba ọa ya bhale ni a ke mẹ alo gbugbugbu. ");
INSERT INTO atgNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ọa khi oni a liẹ, ‘Ghe ọli ana.’ Wẹ khi, ‘Ghe ọli aghọ.’ Irari khi Eghiele oyi Ẹshinẹgba ọ la iteva oyẹ ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ighọ ọ eniyẹ odukhokho eyọli, “Ẹghẹghẹ ọ bhale ni a ya nono ogbẹlẹ oghuo oyi omi ọgbọ, ama a ya mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ẹgbọ e ya ke gueyẹ ẹ, ‘Bino khi ọ la aghọ.’ Ali khi, ‘Ọ la ana.’ Ama a khi na deba wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Irari khi ẹlẹ ni Omi Ọgbọ ọ ya bhale, eri ọ ya li abi erali akphala ni ọ nyamhise alo rọte ukiẹkiẹ ukhui oghuo ya je ukiẹkiẹ ni ọ kpọle. ");
INSERT INTO atgNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama ọ mema kpẹ ya mẹ osue egbegbọ, ẹgbọ agbhotu ena e kie ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Abi o ke lẹsẹ li ẹghẹghẹ oyi iNoa, ighọ o ya li ogbẹlẹ ni Omi Ọgbọ ọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eri ẹgbọ e le, e da, e rue ikpotso, a ri ikpotso ye ughuẹ ya ramhi ni iNoa ọ rọ lo ọkọ-okẹ oniẹmhi. Ighọ amẹ ni ofunẹ o rọte idane tiemhile ya pfuse wẹ-a nya. ");
INSERT INTO atgNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ighọ o gbo li ẹghẹghẹ oyi iLọti. Ẹgbọ e le, e da. E dẹ, e rọ dẹ. E kọ, e tọ apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama ẹlẹ ni iLọti ọ lase ekẹ iSodomu le, erali ali ingamhi e rọte idane zẹ kule ya pfuse wẹ-a nya. ");
INSERT INTO atgNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ighọ o ya li ẹlẹ ni Omi Ọgbọ ọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ẹlẹ ni a ngme ena, ọni ọ la ukhomhi owa, ọ khi tiemhile ya wolọ itsua eyọli. Ighọ o khi ọni ọ la ishemhi, ọ khi nyenẹ egbe je apfẹ shi emhi khọghuo. ");
INSERT INTO atgNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","A sato ingme oyi ughuẹ iLọti! ");
INSERT INTO atgNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ọgbọ ni ọ da nono ni lọli tsumhi agbọ oyọli ne, o ya de ọli obọ-a, ama ọgbọ ni rue agbọ oyọli obọ-a shi ekẹ itobọ oyẹmhẹ ne, ọ ya mẹ ọli rue. ");
INSERT INTO atgNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ẹliyọsẹ ni a ngme ena, emọse aava e ya lesẹ shi ukpho oghuo, a ya rue ọghuo ọ vu, o kpe ọtuọghuo ọ le. ");
INSERT INTO atgNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ikpotso aava e ya ke mhẹli emhi kugbe, a ya rue ọghuo ọ vu, o kpe ọtuọghuo ọ le.” ");
INSERT INTO atgNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Emọse aava e ya la ishemhi, a ya rue ọtuọghuo ọ vu, o kpe ọtuọghuo ọ le. ");
INSERT INTO atgNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eniyẹ odukhokho eyọli e mhila li, ẹ ọli, “Obo lọ Ọnọmhuẹ?” IJesu ọọ wẹ, “Ashini idiegbe olimhi o la, aghọ ighuli ẹẹ legba.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","IJesu ọ zẹ okhẹ irọkhọkhọ khasẹ eniyẹ odukhokho eyọli, ni ọ rọ sẹsẹ wẹ khi o ti ni a ke lema ẹghẹghẹ kpa, ali e khi zẹ ni o lọsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ọọ wẹ, “Elemhi ẹoli oghuo, ọmọse ọsọ-ẹzọ ọ ya la ọ ni ọa li na ulishi Ẹshinẹgba wẹkhi eri ọ mu ekpẹ na ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ọsamhi-olimhi ọ li la oni ẹoli ni ọ bhale deba ọni ọsọ-ẹzọ, ọọ li, ‘Kpẹkpẹ pfa ẹzọ na mhẹ shi ingme ni o de mhẹmhẹ ali ọgbọ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","O ga tẹsẹ ọni ọmọse ọa kie pfa shi ọli ekẹ. Ama ikpukhokho ọ, ọni ọmọse ọọ egbeọli, ‘Ini o riẹ khia khi mhi aa ya na ulishi Ẹshinẹgba wẹkhi eri mhia mu ekpẹ na ọgbọ, ");
INSERT INTO atgNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ni o rọ khia khi ọni ọkpotso ọna ọ lina bhale ya nasẹ mhẹ ena, mhi ya pfa ẹzọ na li, ini ọ khi ya ri ibhale oyọli ona kie ke nasẹ mhẹ!’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ọnọmhuẹ ọọ wẹ, “Aa suọ abi ọsọ-ẹzọ ọna ọkhọlọ ọna ọ ngme? ");
INSERT INTO atgNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ẹshinẹgba ọa ya li pfa ẹzọ na eniyẹ eyọli ni e viẹ ẹ lu ọli, ghe ẹlẹ-ọguota, ghe ẹlẹ-iyọsẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mhi gueyẹ ẹ khi ọ ya pfa ẹzọ na wẹ pia. Abi o li ena, ini Omi Ọgbọ ọ nyenẹ egbe bhale, ọ li bhale ya ẹ irudunga ekẹ agbọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","IJesu o gbo zẹ okhẹ irọkhọkhọ ona khasẹ ẹgbọ eghuo ni e regbenga khi wẹwẹ e mhọli iguẹ-ngeli dọsẹ ẹgbọẹse, ni e ri ẹloe a gbe ẹgbọẹse. ");
INSERT INTO atgNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Emọse aava e je Owa Oyi Ẹshinẹgba ya sọ iromhi. Ọghuo ọ ọ khi iFarisi, ọnọkpọle ọ khi ọmionoga. ");
INSERT INTO atgNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ọni iFarisi ọ vule, ọ sọ iromhi, ọ kuẹghiẹ egbọli, ọọ liẹ, ‘Ẹshinẹgba, mhi kphẹmhi nẹ khi mhi aa li abi ẹgbọẹse ni e khi ighiatọ ni ẹẹ li ingmobe, ni ẹẹ kia okia abi ọmọse ọmionoga ọnana. ");
INSERT INTO atgNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iteva mhia pfi azumhi elemhi ẹfo uka. Mhi a zẹ azẹ-oghuo-igbe elemhi emini mhi mhuẹ kpa.’ ");
INSERT INTO atgNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ama ọni ọmionoga ọghọ, ọ tapfia migha ọa gbudu yasẹ alo fẹli idane, ama ọ lẹsẹ gbe abọ nga aye, ọ liẹ, ‘Ẹshinẹgba mhuẹ ilẹlemhi na mhẹ, mhẹmhẹ ọgbọ olamhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mhi gue egbegbi ingme a yẹ ẹ khi ọni ọmionoga ọna Ẹshinẹgba ọ bino khi ọ pfuasẹ dọsẹ ọni ọmọse ni ọ kpọle. Egbe e mu ọli je apfẹ. Itobọ khi ọgbọ ni ọ da ti egbọli nga ne, eri a ya ti ọli tiemhi ekẹ, ama ọni ọ da ti egbọli tiemhi ekẹ, a ya ti ọli nga.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ẹlẹghuo, ẹgbọ e li mu eniyẹ enikeke bhale ghi iJesu ni ọ ri obọ ti wẹ. Abi eniyẹ odukhokho eyọli e rọ mẹ wẹ, ẹẹ e khi bhale ya nasẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama iJesu ọ lu eni eniyẹ, ọọ wẹ, “A zẹ ni ikuku eniyẹ e bhale deba mhẹ, a khi ke mu wẹ migha irari khi enabi wẹwẹ e mhuẹ Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Abi o li mhi li gue ọli yẹ ẹ khi, ọni ọa da mie Eghiele oyi Ẹshinẹgba abi ukuku ọmọ ọ li mie ọli ne, ọa ya lo ọli le.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ọkhẹmhuẹ ọghuo ọ mhila iJesu, ọọ, “Ọsẹsẹ ọnete, sẹ mhi ya li ni mhi rọ ya mhuẹ agbọ na agbọagbọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","IJesu ọ mhila li, “Elọ o zẹ ni u rọ ọ lu mhẹ ọsẹsẹ ọnete? Ọgbọkhọghuo ọa la ọ ni ọ khi ọnọti, sẹ ni Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U lẹsẹ abi ishi eyi Ẹshinẹgba e ngme, “Khi kia okia, khi gbe ugbeli, khi do ughiatọ, khi pfi ọtsẹlẹ ẹgbhuẹ mu ọgbọ, mu ekpẹ na itẹ ali inyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ọọ iJesu, “Rọte abi mhi te khi ọmọ mhi te ri ishi ena nya a gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Abi iJesu ọ rọ suọ ona, ọọ li, “O kpọ ẹ emhi oghuo le, lẹ ya ri emini u mhuẹ nya dẹ, u kemhi eni ikpaghọ na ẹgbọ ni ẹa mhọli khi u ya mhuẹ ẹpfue shi iloghie. Ni u tigbe bhale ke deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Abi ọni ọmọse ọ rọ suọ ona, egbe e pfọ li-a itobọ khi ọ pfue gba. ");
INSERT INTO atgNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","IJesu ọ mẹ abi egbe e pfọ li-a shi ọ, Ọọ, “O ma mu unu ni ẹgbọ ni e lolo pfue ni e rọ lo Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ni ọgbọ ni ọ pfue ọ rọ lo Eghiele oyi Ẹshinẹgba, o ya munu dọsẹ, ni ọgbọ ke dua ni lọli ri alakumi rọte esẹ asugẹ ya fiẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ẹgbọ ni e suọ ona e mhila, “Ọghuo ọ ke ya mhuẹ imiepfuese shọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","IJesu ọọ wẹ, “Emini ọa zẹ ọgbọ a riẹlẹ lọli ọ zẹ Ẹshinẹgba a riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","IPita ọọ iJesu, “Bino, anye she tsua emhi eyanye nya kua se, anye bhale deba ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","IJesu ọọ wẹ, “Abi o li mhi li gue ọli ẹ yẹ ẹ khi, aa mẹ ọni ọ ya tsua apfẹ-ọli, okekhi ughuẹ-ọli pfia, ni ọ tsua inyọghuo ọli, ghe itali ghe inyọli ali imiọli pfia, itobọ Eghiele oyi Ẹshinẹgba, ");
INSERT INTO atgNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ni ọa ya mhuẹ eleli ni e bu dọsẹ eghọghọ, elemhi agbọ ona ali agbọ oni o ke ẹ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","IJesu ọ rue eniyẹ odukhokho ogbava eyọli je asha eghuo, ọ gueyẹ wẹ. “A ri esọ shi ekẹ, awa ya nga obini iJerusalẹmu. Emini emekẹguele e kẹkẹ shi Omi Ọgbọ egbe nya, e bhale ya tsẹ oobọ. ");
INSERT INTO atgNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A ya mu ọli, a rue ọli na ẹgbọ iJẹta. E ya rọli li egia, ẹẹ tsue ọli, e tono etẹ ku ọli, e gbe ọli itali, e tigbe gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ẹlẹ onuzi-esẹ, ọ ya guale.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Eniyẹ odukhokho eyọli ẹa lẹsẹ udi ingme ena irari khi eri a ri ingme enana sheli wẹ, ali khi ẹa gbo lẹsẹ emini ọọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Abi iJesu ọ li ti i mama iJẹriko, ọzalo ọghuo ọ shitọ epfẹ odẹ, ọ mhila. ");
INSERT INTO atgNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Abi ọ rọ suọ okeke ẹgbọ ni e dọsẹ, ọ mhila wẹ emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A gueyẹ ọli khi iJesu na iNazarẹti ọọ dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ọ lu leghe, ọọ li, “IJesu Omi iDefidi mhuẹ isomhelemhi na mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ẹgbọ ni e ralo na li ẹ ọli ọ khukhu unu. Ama ighọ ọ kie li tsẹsẹ ọọ liẹ, “Omi iDefidi mhuẹ isomhelemhi na mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","IJesu ọ migha, ọ e lu ọni ọmọse ghi luẹ. Abi ọ rọ ti mama li, iJesu ọ mhila li. ");
INSERT INTO atgNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Elọ wa nono ni mhi riẹlẹ nẹ?” Ọọ iJesu, “Ọnọmhuẹ mhi a nono ni mhi ke mẹ ekẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","IJesu ọọ li, “Alo eyẹ e khueghie-a, irudunga oyẹ o she rẹ ze.” ");
INSERT INTO atgNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aghọaghọ alo eyọli e khueghie-a. Ọ deba iJesu kia, ọ kuẹghiẹ Ẹshinẹgba. Abi eni ẹgbọ nya e rọ mẹ ọli e li li kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","IJesu ọ́ rọte ẹoli iJẹriko dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ọmọse ọghuo ọ la oni ẹoli ni a lu iZakiọsi, lọli ọ khi ọga ọyi emionoga. Ọ ga mema mhuẹ ẹpfue egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ọ nono ni lọli mẹ ọni iJesu ọ khi, ama ọa dobẹ. Ọa mẹ asha itobọ khi ẹgbọ e bu dọsẹ. Ali khi ọgbọ ni ọa yagha ọ khi ni ọ lolo she. ");
INSERT INTO atgNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ighọ ọ na ya ralo odẹ ni iJesu ọ te ya dọsẹ, ọ ya nga ọara ugbẹlẹ shitọ, ini lọli mẹ asha mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","IJesu ọ ramhi aghọ, ọ yasẹ alo idane lu ọli, Ọọ li, “IZakiọsi, nyanya tiemhile, mhi mema ya kushi apfẹ oyẹ amo.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ighọ ọ nyanya tiemhile. Egbe e mu ọli, ọ ri oghẹlẹ kpe abọ mie iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ẹgbọ nya ni e mẹ ona, e wọlọ, e liẹ, “Ọ she ya kushi na ọgbọ ọna olamhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","O ke lẹsẹ li dẹnẹ tee, iZakiọsi ọ ti vule, ọọ, “Ọnọmhuẹ ghe i, mhi ya khi ẹpfue eyẹmhẹ shi asha eva, mhi ri asheghuo ọ na ẹgbọ ni ẹa mhuẹ. O kha khia khi mhi li ọgbọkhọghuo le ghue, mhi ya fali ọli eni ota agbhagbhamhi ene.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","IJesu ọọ li, “Amo ena imiepfuese o she bhale apfẹ ona, itobọ khi omi Aburaamu, ọmọse ọna ọ li khi. ");
INSERT INTO atgNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Irari khi eri Omi Ọgbọ ọ bhale ya nono ẹgbọ ni e waa, ali ni ọ gbo rọ ya mie wẹ pfuese.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Abi e kie li suọ ingmemhi ena, iJesu ọ zẹ okhẹ irọkhọkhọ khasẹ wẹ irari khi ọ she ti i mama iJerusalẹmu. Eni ẹgbọ e dabi khi utoghuokpe Eghiele oyi Ẹshinẹgba o rọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ọọ wẹ, “Ọmọse ọkhẹmhuẹ ọghuo ọ ye ushishi odonuẹ ni a rọ ya ri oghie na li, ikpukhokhọ, ọ gbo jele. ");
INSERT INTO atgNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ighọ ọ luno eni ẹẹ ga li ogbe, ọ kemhi ikpaghọ eyi igolu na wẹ. Ọọ wẹ, ‘A ri ikpaghọ ena du oki ramhi ni mhi rọ ya jele.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Eri tsẹ khi eri apfọli e biselemhi ọli, e ghie usomhi ghi eni e ya gbanọ ọli ukhomhi khi wẹwẹ ẹa nono ni ọni ọmọse ọna, ni ọ khi oghie ọyi wẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“A kie ri oghie na li, ọ jele. Ighọ ọ luno eni ẹ ga li eghọ ni ọ ri ikpaghọ na, ni lọli mhila wẹ abi e ri eni ikpaghọ kia. ");
INSERT INTO atgNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ọni ododẹ ọ bhale, ọọ li, ‘Ọga, ukpaghọ igolu oyẹ o she bia igbe elese.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ọni ọga ọọ li, ‘Mu akanya, ọni ọọ ga ọnete ọyẹmhẹ. Itobọ khi u khi ọni a ri egbe ẹ nga shi ukukuọ ni a rọ shi ẹ obọ, mọ ẹoli igbe ke mhẹsẹ shi.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ọnuzava ọ bhale, ọọ li, ‘Ọga ukpaghọ igolu oyẹ o she bia ishe elese.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ọni ọga ọọ li, ‘Yẹyẹ mọ ẹoli ishe ri ẹoli ke khu.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ọnuzasẹ ọ bhale, ọọ, ‘Ọga ghe ukpaghọ igolu oyẹ. Eri mhi gẹnọ li shi ode ya shi nẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Eri ulishi oyẹ o mu mhẹ itobọ khi ọgbọ ni ọ ze alo u khi. Ashini u waa rọshi u te ẹ rue, ashini u wa rọ kọ shi u te a khiẹsẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ọni ọga ọyọli ọọ li, ‘Mhi ya rọte emini yẹyẹghuo u ngme sẹ unu ingme ikhi yẹyẹ ọni ọ ga ọgbọ ọbe ọna. Abi u rọ lẹsẹ khi ọmọse ni ọ ze alo mhi khi, khi ashini mhia rọ shi mhi te a rue, mhi gbo rọte ashini mhia rọkọ shi a khiẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Elọ o zẹ ni u waa rọ ri ukpaghọ oyẹmhẹ ya shi owa ukpaghọ na mhẹ ni e la aghọ ke gbe nga ọ, ni mhi mẹ ọli ali eleli eyọli mie ini mhi nyenẹ egbe jele?’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ighọ ọ gueyẹ eni e migha, ‘A mie ọli oni ukpaghọ igolu ona na ọni ọ mhuẹ eleli asha igbe.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Eni ẹgbọ ẹ ọli, ‘Ọga, ọ she kpẹ mhuẹ igbe.’ ");
INSERT INTO atgNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ọni ọga ọọ wẹ, ‘Abi o li mhi li gue ọli ẹ yẹ ẹ khi, ọgbọ ni ọ da kpẹ mhuẹ ne, a ya rọ ma li ọ. Ama ọni ọa kpẹ mhuẹ a ya gbo mie ọli ọni ọ kpẹ mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ama ebe mhẹ eghọ ni ẹa nono ni mhi le eghiele shi wẹ ukhomhi, a wolọ wẹ lase ana, a gbolo wẹ-a ukpẹloe mhẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Abi iJesu ọ rọ ngme ona se, ọ ya ralo na wẹ. E nga iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Abi ọ rọ ti mama ẹoli iBẹtifagi ali iBẹtani obini ukhomhi ute ni o khi ẹẹra olivu, ọ ghie eniyẹ odukhokho eyọli aava ralo, ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“A je ẹoli ni o la ẹ odalo. Ini a ramhi aghọ, a ya mẹ omi akphẹrẹ ni ọgbọ ọa nga ghue khi a mu ọli zu. A taghiẹ ọli-a, a mu ọli ghi mhẹ ana. ");
INSERT INTO atgNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ini ọgbọkhọghuo ọ mhila ẹ, khi ọọ, ‘Elọ o zẹ ni a rọ taghiẹ ọlia?’ A liẹ ọli, ‘Ọnọmhuẹ ọ mhuẹ emini ọ ri ọli ya li.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eni ọ ghie, e bhale ya ẹ ọni akphẹrẹ tee abi iJesu ọ li gueyẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Abi e li taghiẹ ọlia, eni e mhọli ọli e mhila wẹ, “Elọ ọ zẹ ni a rọ taghiẹ ọni akphẹrẹ a?” ");
INSERT INTO atgNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ẹ wẹ, “Ọnọmhuẹ ọ mhuẹ emini ọ rọli ya li.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","E mu ọli ghi iJesu. E ri ide ku ọli egbe, e mu iJesu nga ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Abi ọ li lẹ, ẹgbọ e naghiẹ ide ku odẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Abi ọ rọ ti i mama ashini ute Olivu o te pfi ukhomhi kpọkẹ, eni eniyẹ odukhokho nya ee kuẹghiẹ Ẹshinẹgba leghe shi ikanya ọnyaloa ni e mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ee liẹ, “Ikhivọsẹ o khi oyi oghie ni o ri eva oyi Ọnọmhuẹ bhale.” “Opfọmhẹ o la iloghie, ufumhi o la obini o yagha nẹ nya.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ighọ iFarisi eghuo ni e la ifuabọ eni ẹgbọ ẹẹ iJesu, “Ọsẹsẹ, gueyẹ eniyẹ odukhokho eyẹ e khukhu unu.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ọọ wẹ, “A ri esọ shi ekẹ, ini e khukhu unu, echẹ e ya ke tsẹsẹ leghe.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Abi ọ rọ ti i mama iJerusalẹmu ni ọ rọ mẹ oni ẹoli, ọ viẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ọọ, “Abi a khẹ khi u lẹsẹ emini o ya ri opfọmhẹ ghi ẹ amo ena lọ! Eri tsẹ khi a she ri ọli sheli na ẹ mena.” ");
INSERT INTO atgNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ogbẹlẹ ọọ bhale ni ebe ẹ e rọ ya gbe ogba gasẹ ẹ, e khi ẹ shi iteva, e rọte ashakpa gasẹ ẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","E ya khọli ẹ pfuse-a. Ẹa ya kẹsẹ ọmọ wẹkhi ọdiọ le, e shashe ẹ apfẹ-a. Ẹa ya kẹsẹ ukpolo nga ukpolo, itobọ khi aa lẹsẹ ẹghẹghẹ ni Ẹshinẹgba ọ rọ bhale ya tsumhi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ighọ ọ lo Owa Oyi Ẹshinẹgba, ọ khu ẹgbọ ni e la aghọ ẹ du oki fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ọọ wẹ, “A she kẹkẹ ọli shi Ebe-no-pfuasẹ khi, ‘Owa oyẹmhẹ owa iromhi lọ.’ Ama, a she ri ọli mele egbha ighiatọ a!” ");
INSERT INTO atgNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ogbẹlẹkpa iJesu ọ la Owa oyi Ẹshinẹgba sẹsẹ, ama eni ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi ali eni e ralo na eni ẹgbọ, ee nono ni wẹwẹ e gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama ẹa mẹ odẹ ni e te ya riẹlẹ ọli, itobọ khi eni ẹgbọ e ri esọ shi osẹsẹ oyọli, ẹa nono ni ungmemhi oyọli okhọghuo o de wẹ esọ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ẹlẹghuo khi iJesu ọ la Owa Oyi Ẹshinẹgba tse abọ usomhi onete oyi Ẹshinẹgba, ighie eyi ekpodalo-ugamhi ali esẹsẹ Ishi eyi iMosisi, ali eni egbhali e bhale deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ẹ ọli, “Gueyẹ anye afu oyi ọni u rọ ọ gbe ikanya enana. Ọghuo ọ ri eni afu ena nẹ?” ");
INSERT INTO atgNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","IJesu ọọ wẹ, “Mhi ya li mhila ẹ ogbọ, a sọ mhẹ ọ! ");
INSERT INTO atgNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ibatizi ni iJọni ọọ batazi ẹgbọ, obọ oyi Ẹshinẹgba o te bhale abi obọ oyi ọgbọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","E lu egbe wẹ ochi, e kẹ, “Awa khẹ, ‘Obọ oyi Ẹshinẹgba o te bhale.’ Ọ ya mhila awa, ‘Elọ o zẹ khi aa mie ọli suọ?’ ");
INSERT INTO atgNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ini awa kẹ, ‘Obọ oyi ẹgbọ.’ Ẹgbọ nya e ya tono awa echẹ irari khi ọgbọkpa ọ lẹsẹ khi ọmekẹguele iJọni ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ighọ ẹẹ iJesu, “Anye aa lẹsẹ obini o te bhale.” ");
INSERT INTO atgNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","IJesu ọọ wẹ, “Mhia li ya gueyẹ ẹ afu ni mhi rọ a gbe ikanya enana.” ");
INSERT INTO atgNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","IJesu ọ zẹ okhẹ irọkhọkhọ ona khasẹ eni ẹgbọ, ọọ wẹ, “Ọmọse ọghuo ọ gua ipfonu shi ogba, ọ rọli ye ongmomhi na eghiale. Ọ vu ẹoli ni ọ la tẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ẹghẹghẹ ikhiẹsẹ o ramhi, ọ ghie ọni ọọ ga li ghi wẹ e rọte oni ogba pfanọ idumhi ghi luẹ. Ama eni eghiale e gbe ọni a ghie ọghọ. Ọ pfino abọ efuẹ je. ");
INSERT INTO atgNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ọni ọmọse ọ gbo ghie ọni ọọ ga li ọnuzava ghi wẹ. E gbe ọli, e yẹghẹ ọlia. Ọ gbo pfino abọ efuẹ ya je. ");
INSERT INTO atgNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ọni ọmọse ọ gbo ghie ọnuzasẹ. E kuale ọli utse, e khu ọli ya fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ọni ọ mhuẹ oni ogba ipfonu ọghọ, ọọ, ‘Sẹ mhi fẹ ya li eghọ? Mhi ya ghie omimhẹ ni mhi nono ingme oyọli egbegbọ, otsẹ, e ya mu ekpẹ na li.’ ");
INSERT INTO atgNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ama abi eni eghiale e rọ mẹ ọli, ẹẹ, ‘Egbegbi omi ọli na ni ọ ya le ugu ogba ona, awa gbe ọli-a ni awa rue oni ugu le.’ ");
INSERT INTO atgNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ighọ e ti ọli je olase oni ogba ipfonu, e gbe ọlia. “Sẹ ọni ọ mhuẹ oni ogba ipfonu eghọ ọ fẹ ya li wẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eri ọ ya bhale ya gbolo eni eghiale eghọ-a, ọ tigbe rue oni ogba na eghiale elese.” Abi eni ẹgbọ e rọ suọ oni ingme, ẹ, “Ẹshinẹgba ọ gbe etse kua!” ");
INSERT INTO atgNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","IJesu ọ bino wẹ alo ukhomhi, ọọ wẹ, “Sẹ emini a kẹkẹ ona o fẹ ngme, ni ọọ, “ ‘Ẹchẹ ni itsọna e kie pfia, o tigbe ya mele ẹchẹ ẹbẹ ni o mu ẹloe nẹ nya-a?’ ");
INSERT INTO atgNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ọni ọ da ya de nga oni ẹchẹ ne, ọ guọghọ-a, ali ọni oni ẹchẹ o da ya de mu ne, o mhẹli ọlia.” ");
INSERT INTO atgNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eni ẹ sẹsẹ Ishi eyi iMosisi ali ighie eyi ekpodalo-ugamhi e nono odẹ ni e te ya mu ọli aghọaghọ, irari khi wẹwẹ ọ zẹ oni okhẹ irọkhọkhọ tsue. Ama ulishi oyi ẹgbọ oo mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ighọ e li ri ẹloe shi ọli egbe egbegbọ. E zẹ ẹgbọ ni e riẹlẹ abi ẹgbọ ni ee mie shi iJesu ọ deba li, e ke de ọli awẹ, ini e mẹ ushi mu shi ọli obọ, ni e mu ọli ghi ena omhẹsẹ eyi igọvunọ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ighọ eni a zẹ eghọ ee mhila li ogbọ, “Ọsẹsẹ, anye ga lẹsẹ khi abi ungmemhi oyi Ẹshinẹgba o li u liẹ ngme ọli, u gbolo a sẹsẹ emini e te odẹ, waa ya gbe ọgbọkhọghuo azẹba, ama eri wa sẹsẹ egbegbi ingme oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","O fẹ ti ni anye zẹ oga na oghie iSiza abi anye khi zẹ?” ");
INSERT INTO atgNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","IJesu ọ she lẹsẹ oshili eyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ọọ wẹ, “A ri ukpaghọ ẹlomho khasẹ mhẹ. Alo eyi ọghuo a fẹ mu shi ọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ẹ ọli, “ISiza.” IJesu ọọ wẹ, “A ri emini e khi eyi iSiza na iSiza, a ri emini e khi eyi Ẹshinẹgba na Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ẹa dobẹ rọte emini ọ ngme igbaa mẹ emhikhọghuo mu shi ọli obọ. Abọ e sha wẹ shi abi ọ li gbaghiẹ oni ogbọ-a, e khukhu unu. ");
INSERT INTO atgNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ẹgbọ iSadusi eghuo ni ẹa lama shi ọ khi a ya mẹ irọte eghuli guale, e ri omhila bhale deba iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ẹ ọli, “Ọsẹsẹ, iMosisi ọ kẹkẹ shi ekẹ na awa khi ini ọmọse ọ ghu-a pfi ughuẹ ọli shi ekẹ agbọ ni ọa rọ bia eniyẹ, inyọghuo ọni ọmọse ọ rue ọni ọkpotso ughuẹ ni ọ bia eniyẹ shi agbọ na inyọghuo ọli ni ọ ghu-a eghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Inyọghuo egbe etuoshilua e ya la ọ. Ọni ododẹ ọ rue ọkpotso, ọ ghua, ọa bia ọmọ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ọnuzava ọ rue ọni ọkpotso. ");
INSERT INTO atgNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ighọ ọnuzasẹ ọ gbo rue ọli. Ighọ wẹwẹ nya e rue ọli, e ghulo-a, ẹa bia ọmọ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ikpukhokho ọ, ọni ọkpotso ọ li ghua. ");
INSERT INTO atgNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mena, ogbẹlẹ ni ẹgbọ e ya te eghuli guale, ughuẹ oghuo ọni ọkpotso ọ ya khi, aborọkhia khi wẹwẹ oshilua e ga rue ọli ughuẹ eghọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","IJesu ọọ wẹ, “Ẹgbọ ena agbọ ona ẹ rue ikpotso, wẹwẹ e gbo ri ikpotso a ye ughuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama ẹgbọ ni a leli shi eni e mhuẹ okemhi shi agbọ oghọ ali irọte eghuli guale, ẹa ya rue ikpotso, wẹkhi eri a rẹwẹ ya ye ughuẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ẹa kẹ ke ghu, irari khi eri e ke ya li abi igẹni eyi Ẹshinẹgba. Imi Ẹshinẹgba e ke ya khi, irari khi e she rọte eghuli guale. ");
INSERT INTO atgNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ashini a kẹkẹ ingme oyi ebuli ni oo to shi, iMosisi ọ te rọkhasẹ ẹ gboo khi eni e ghua, ẹ guale, irari khi ọ lu Ọnọmhuẹ, ‘Ẹshinẹgba ọyi Aburaamu ali Ẹshinẹgba ọyi Aziki ali Ẹshinẹgba ọyi iGiekọpu.’ ");
INSERT INTO atgNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ẹshinẹgba oyi ẹgbọ ni e la agbọ ọ khi. Ọa khi Ẹshinẹgba ọyi ẹgbọ ni e ghua.” ");
INSERT INTO atgNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Esẹsẹ Ishi eyi iMosisi eghuo ni e la aghọ ẹẹ ọli, “Ọsẹsẹ, u ga guẹ ngme!” ");
INSERT INTO atgNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ọgbọkhọghuo ọa ke gbo gbudu mhila li ogbọ olese. ");
INSERT INTO atgNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ighọ iJesu ọ mhila wẹ, “Sẹ ẹẹ a liẹ liẹ khi ọni Ọmiepfuese khi omi iDefidi ọ khi? ");
INSERT INTO atgNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Irari khi ọni iDefidi ọ ngme ọli shi ebe Iwolo, ni ọ rẹ, “ ‘Ọnọmhuẹ ọọ Ọnọmhuẹ ọyẹmhẹ: Shitọ mhẹ ukiẹkiẹ obita ");
INSERT INTO atgNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ramhi ni mhi rọ ya ri ebe ẹ shi ẹ ẹkoawẹ ni u kpha awẹ ukhomhi.’ ");
INSERT INTO atgNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ini iDefidi ọ lu ọli, ‘Ọnọmhuẹ.’ Sẹ ọ ke gbo liẹ khi omi iDefidi?” ");
INSERT INTO atgNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Abi eni ẹgbọ e kie ku esọ-a shi ekẹ eghọ, iJesu ọọ eniyẹ odukhokho eyọli, ");
INSERT INTO atgNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“A mhuẹ ẹgbhẹ shi esẹsẹ Ishi eyi iMosisi egbe. O ma ghọle wẹ ni e ke sọ itsua na dọlọdọlọ ke kia gasẹ, ni ẹgbọ e ba ke tsẹ wẹ otsẹ ekpẹ atu oki. Ẹẹ shitọ ashini o mhuẹ ekpẹ elemhi owa ugamhi, e gbolo ẹ shitọ ashini o yagha ni o funẹ ukue. ");
INSERT INTO atgNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ẹẹ lo apfẹ oyi esamhi-olimhi ya ri itoto miono wẹ emini e mhuẹ. Ẹẹ sọ iromhi ni e nuẹ eyi abamẹmhẹ. A ya na ẹgbọ eghọghọ osue egbegbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","IJesu ọ bino gasẹ, ọ mẹ khi ẹgbọ ni e mhuẹ ẹpfue e pfi ukpaghọ lo akpati ni a pfi ukpaghọ a lo elemhi Owa oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ighọ ọsamhi-olimhi ni ọa mhuẹ emhi ọ li pfi ikpamhi inini eva lo oni akpati. ");
INSERT INTO atgNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","IJesu ọọ eniyẹ odukhokho eyọli, “Mhi gueyẹ ẹ khi ọsamhi-olimhi ọna ọ ga rọna dọsẹ ẹgbọ eni e kpọle nya. ");
INSERT INTO atgNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Eri ẹgbọ eni e kpọle ena e rọte ẹpfue eyẹwẹ rọna, ama ọsamhi-olimhi ọna ọ rọte umhamẹ ri ukukuọ ni ọ mhuẹ rọna.” ");
INSERT INTO atgNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eniyẹ odukhokho eyọli eghuo e ngme abi a li ri echẹ ni e somhi otse li atsọna shi ugbe oyi oni Owa Oyi Ẹshinẹgba, li shi itsua isomhopfa ni a rọ ma ọ na Ẹshinẹgba. Ama iJesu ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Emini a bino ena ii, ẹghẹghẹ ọọ bhale ni o khia khi ẹchẹli okhọghuo ọa ke ya nga ọlese egbe, irari khi a ya bighi wẹ kua.” ");
INSERT INTO atgNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","E mhila li, ẹẹ ọli, “Ọsẹsẹ, ẹghẹghẹ onoghuo a rọ ya mẹ ona. Elọ a ya mẹ ni o rọ ya khasẹ khi oni ẹghẹghẹ o she ramhi?” ");
INSERT INTO atgNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","IJesu ọọ wẹ, “A mhuẹ ẹgbhẹ ini ọgbọ ọ khi di ẹ. Ebubu ẹgbọ e ya ri eva oyẹmhẹ bhale, ẹẹ liẹ, ‘Mhẹmhẹ mhi khi Ọmiepfuese,’ ali khi, ‘Oni ẹghẹghẹ o she ti bhale.’ A khi deba wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ini a suọ eko okhuẹ ali ozughu, a khi zẹ ni egbe e guọghọ ẹ a, irari khi emhi enana e mema bhale ya tsẹ, eri-tsẹ khi ukpẹsẹ agbọ ọa kie ramhi ne oni ẹghẹghẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ọọ wẹ, “Ishishi e ya mu okhuẹ vule shi ishishi ọ, eghiele e mu okhuẹ vule shi eghiele ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ekẹ e ya ke de kuluẹ. Okiamhi ali ighuamhi ebe e ya la asha ọdọda. A ya mẹ ebemulishi ali ukpokpomhi irọkhasẹ khi e te idane bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Eri-tsẹ khi neni a ya mẹ ena, a ya muno ẹ a nasẹ ẹ, a muno ẹ je owa ugamhi ali owa ighumha. A mu ẹ ghie enighie ali igọvunọ irari oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ona o ya khi ẹghẹghẹ ni a rọ ya mẹ asha pfi ọtsẹlẹ na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","A mhọli ọli shi udu memena, a khi zẹ ni udu o nighise ẹ shi emini a ya mẹ sọ wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mhi ya ri ungmemhi shi ẹ unu ali ẹgbhali ni ọ khia khi ebe ẹ ẹa ya dobẹ nu ẹ khẹ akọ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ita ẹ, ali inyọghuo ẹ, ali ẹgbọ eyẹ ẹ, ali emọle ẹ, e ya ri ẹgbhuẹ rẹ ẹ dẹ, e gbolo eghuo elemhi ẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ẹgbọkpa e ya ri itobọ oyẹmhẹ kie ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama, ẹtsui okhọghuo oyi ọngẹẹ ọa ya pfua. ");
INSERT INTO atgNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ini a migha egbegbọ, a ya tsumhi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ini a mẹ khi ekhọli-okhuẹ e pfi gasẹ iJerusalẹmu, a lẹsẹ khi ipfuẹchẹ-a oyọli o shi ti ramhi. ");
INSERT INTO atgNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ẹghẹghẹ aghọ, ẹgbọ ni e la ekẹ iJudia, e na nga ikhomhi ite. Ẹgbọ ni e la ifu apfẹ, e na ifu apfẹ ọ vu. Eni e la oboese e khi ke gbo nyenẹ egbe bhale ifu apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Irari khi ẹghẹghẹ isọ-ẹzọ ni a she kpẹ kẹkẹ shi ekẹ na ni o bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ẹghẹghẹ aghọ o ma khọlọ ikpotso ni ẹ mẹ umẹmhi egbe, ali eni e ri eniyẹ shi egbe. Osue onofunẹ o ya la oni ekẹ. Ofu oyi Ẹshinẹgba o ya de rughu eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Eghuo ọ e ya ghu eghuli ọgbhọrọ, a muno eghuo ighumha je ishishi ọdọda. Ẹgbọ iJẹta e ya guọghọ iJerusalẹmu-a ya ramhi, ni ẹghẹghẹ oyi ẹgbọ iJẹta e rọ ya dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“A ya ke mẹ irọkhasẹ elemhi ovọ ali uki ali ikpẹtata. Ishishi e ya le oya ekẹ agbọ, abọ e sha wẹ abi okẹ oniẹmhi o li ya ke vuna. ");
INSERT INTO atgNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ubi o ya rue ẹgbọ, irari ulishi ẹ sa usamhi emini ọ a bhale ekẹ agbọ itobọ khi ekpabọ ni e la ukhui e ya ke nighise. ");
INSERT INTO atgNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ẹghẹghẹ aghọ, e ya mẹ khi Omi Ọgbọ ọ la elemhi otughunu tsua ekpabọ ali ufumhi oniẹmhi, rọte idane ẹ tiemhile. ");
INSERT INTO atgNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ini a da mẹ na ne, a vule a yasẹ ukhomhi ekẹ irari khi ẹghẹghẹ ipfashekẹ oyẹ ẹ o she ti bhale.” ");
INSERT INTO atgNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","IJesu ọ zẹ okhẹ irọkhọkhọ ona khasẹ wẹ, ọọ wẹ, “A ke bino ọara ọkhua ali ẹẹra nya. ");
INSERT INTO atgNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ini e da ta ebe enegbọ ne, a lẹsẹ khi oruamẹ o shi ti ẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ighọ o li khi ini a da mẹ emhi enana ne, a lẹsẹ khi Eghiele oyi Ẹshinẹgba o she ti ramhi. ");
INSERT INTO atgNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Abi o li mhi li gue ọli ẹ yẹ ẹ khi, agbhotu ona ọa ya dọsẹ ne neni a mẹ eni emhi ena nya. ");
INSERT INTO atgNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ekẹ ali ukhuli e kha bhale ya dọsẹ, ingmemhi eyẹmhẹ e mema bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“A kuegbe-a ini ukue iditsẹa, ali onyọ idada ali usamhi agbọ e khi ya rue ẹ ẹgbhali, ini ogbẹlẹ ibhale oyẹmhẹ o khi ya de shi ẹghẹghẹ ni a sa shi. ");
INSERT INTO atgNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Irari khi oni ibhale ona ọgbọkpa ni ọ la agbọ o ya bhale na. ");
INSERT INTO atgNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","A ke mu egbe ẹghẹghẹ kpa, a lema ni a toto migha, ni a pfue okhẹna ni ọọ bhale, ali ni a rọ dobẹ migha odalo oyi Omi Ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ogbẹlẹkpa iJesu ọ rọ la Owa oyi Ẹshinẹgba ii sẹsẹ. Ini obili ọọ bi, ọ fiẹ nga Ute Ẹẹra Olivu. ");
INSERT INTO atgNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ẹluzogbe kpa, eni ẹgbọ nya e bhale Owa Oyi Ẹshinẹgba ya ri esọ shi ọli ekẹ ni e suọ ungmemhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ukpe ni a la le ibulẹdi ni ọgbọ ri ifuma ma nye na lu iPasova o ti bhale. ");
INSERT INTO atgNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ighie eyi ekpodalo-ugamhi eyi Ẹshinẹgba ali eni ẹ sẹsẹ Ishi eyi iMosisi, e nono abi e li ya gbe iJesu a, ama ulishi oyi ẹgbọ o mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ighọ Ọkphaghiẹ ọ lo iJudasi ni a gbolo a lu Isikarọti udu, ni ọ khi ọghuo eniyẹ odukhokho ogbava eyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ọni iJudasi ọ fiẹ deba ighie eyi ekpodalo-ugamhi ali eni ẹ khẹ ekhẹ Owa Oyi Ẹshinẹgba. Ọ nu wẹ ye ochi abi ọ li ya ri iJesu na wẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Egbe e mu wẹ, e lama khi wẹwẹ e ya fali ọli ikpaghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ọ lama shi wẹ ọ, ọ nono abi lọli ri ya mẹ asha ri ọli na wẹ mu ini ebubu ẹgbọ ẹa la akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ukpe ni a la le ibulẹdi ni aa ri ifuma shi nye, ni a rọ omi osumha ẹ luasẹ obo, o ramhi. ");
INSERT INTO atgNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ighọ iJesu ọ ghie iPita ali iJọni ralo, ọọ wẹ, “A ka mu egbe eminale iPasova oyi awa.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","E mhila li, “Obo wa nono ni anye je ya mu egbe?” ");
INSERT INTO atgNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","IJesu ọọ wẹ, “Abi a liẹ ke lo iJerusalẹmu le te, a ya mẹ ọmọse ọghuo ni ọ tsua ubene amẹ. A deba li je owa ni ọọ je. ");
INSERT INTO atgNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ini a ramhi aghọ, a liẹ ọni ọ mhọli oni owa oghọ, ‘Ọsẹsẹ ọ́ọ́, ighe elemhi owa oyẹ ni epfẹse e ku ẹ shi, ni mhẹmhẹ ali eniyẹ odukhokho eyẹmhẹ anye la ya le eminale iPasova?’ ");
INSERT INTO atgNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ọ̀ ya ri ukpokpomhi agbala khasẹ ẹ ukhomhi owa atọnga ni a lolo riẹlẹ somhi otse. A mu egbe oni eminale shi aghọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ighọ e bhale ya ẹ khi abi iJesu ọ li ngme ọli te o khi. Ighọ e mu egbe oni eminale iPasova shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Oni ẹghẹghẹ o ramhi, iJesu ali ighiusomhi na kẹẹ eyọli e shitọ shi gasẹ ni e rọ ya le eminale. ");
INSERT INTO atgNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ọ́ọ́ wẹ, “Ọ kie kpẹ ghọle mhẹ egbegbọ ni mhi nu ẹ le eminale iPasova ona neni mhi ya mẹ osoli. ");
INSERT INTO atgNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mhi gueyẹ ẹ khi, mhi aa ke gbo ya le eminale ona, sẹ ni awa kẹ le oni o khi egbegbọ obini Eghiele oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ọ rue oni uko, ọ kphẹmhi. Ọ́ọ́ wẹ, “A mọ uko ona, a kemhi ọli da. ");
INSERT INTO atgNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mhi gue ọli ẹ yẹ ẹ khi, mhia ke gbo ya da onyọ ọọra upfonu ona, sẹ ni Eghiele oyi Ẹshinẹgba o bhale.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ighọ ọ rue ibulẹdi mhuẹ obọ, ọ kphẹmhi, ọ khi ọli a, ọ rọ na wẹ, ọ́ọ́, “Idiegbe oyẹmhẹ na ni mhi rọ na ẹ. A lina ke riẹlẹ ọli rọ sato mhẹ egbe.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ighọ ọ gbo rue uko abi ọ rọ le emhi se, ọọ, “Uko ona o khi ishobọ onogbọ ni o rọte ọlia eyẹmhẹ bhale, ni a ku shi ekẹ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","A ghe i, obo oyi ọni ọ ya rẹmhẹ dẹ o nu mhẹ shitọ ẹ le emhi memena. ");
INSERT INTO atgNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Abi ẹ khi omi ọgbọ ọ li ya kia, ighọ a li ya mẹ ọli, ama epfua o khi ni ọgbọ ni o ya rọli dẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ee mhila egbewẹ ọni ọ khi ni ọ ya gbe ikanya enana. ");
INSERT INTO atgNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ighọ ekhakọ o gbo li lasele shi iteva oyẹwẹ shi ọni ọ funẹ nya shi elemhi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","IJesu ọọ wẹ, “Eri ighie eyi ẹgbọ iJẹta ẹẹ jili wẹ. E kha jili wẹ se, ẹ liẹ wẹ khi eri wẹwẹ ẹ kpaghiẹ wẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama a khi li abi wẹwẹ, ochoghọ, ọni ọ nono ni lọli funẹ elemhi ẹ, ọ ri egbọli tiemhie ekẹ nya, ọni ọ ralo o ke ga enekpọle. ");
INSERT INTO atgNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ọghuo ọ fu nẹ, ọni ọ shitọ ukhomhi itebu ẹ le emhi, abi ọni ọọ kphanọ eminale ghi eni e shitọ ọ le? Ọa khi ọni ọ shitọ le? Ama eri mhẹmhẹ mhi le ẹ iteva abi ọni ọ ga ẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ẹẹ a nu mhẹ migha abi mhi rọ la imufẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mhi ri eghiele na ẹ, abi itamhẹ ọ li ri eghiele na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ni a rọ bhale ya ẹ khi a nu mhẹ le, a nu mhẹ da obini iloghie oyẹmhẹ. A ya shitọ ukpẹkhomhi oghie, a gue unuẹkpẹ igbẹva eyi iZirẹni ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ISamọ, iSamọ, ghe i, Ọkphaghiẹ o she mhila khi lọli ẹ nono ni lọli kpishi ẹ-a nya abi a liẹ kpishi ado. ");
INSERT INTO atgNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama mhi she sọ iromhi nẹ, iSamọ, ini irudunga oyẹ o khi nighise. Ini u pfue ọ se, ri udu shi inyọghuo ẹ enekpọle ọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ama iPita ọ́ọ́ li, “Ọnọmhuẹ, mhi ga mu egbe ni mhi rọ deba ẹ ya lo owa ighumha, ali ni mhi nu ẹ ya ghua.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","IJesu ọ́ ọli, “Mhi gue ẹ yẹ, khi, yẹyẹ iPita ọna, neni ọkpa ọ ya gbiẹghẹ amo u ya kie mhẹ itesẹ khi u waa lẹsẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","IJesu ọ rọ mhila wẹ, “Abi mhi rọ ghie ẹ fiẹ lase, ni aa rọ tsua ẹkuẹ ukpaghọ wẹkhi akpaba wẹkhi ekuẹ, emhikhọghuo o fẹ to ẹ?” Ẹ ọli, “Iiye.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ọọ wẹ, ama memena, ọgbọ ni ọ mhuẹ ẹkuẹ ukpaghọ ọ rue ọli, ọni ọ mhuẹ akpaba ọ tsua li, ini u waa kpẹ mhuẹ ọgbhọrọ, ka ri awulu oyẹ dẹ, ni u ya dẹ oghuo. ");
INSERT INTO atgNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mhi gueyẹ ẹ khi emini a kẹkẹ shi mhẹ egbe ni o la Ebe-no-pfuasẹ, ni ọọ, “A leli ọli ma ẹgbọ ni e lue,” o mema bhale ya tsẹ shi mhẹ egbe. Irari khi emini a kẹkẹ shi mhẹ egbe o she ramhi ni e rọ bhale ya dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eniyẹ odukhokho eyọli ẹ ọli, “Bino, Ọnọmhuẹ, ọgbhọrọ eva e la ana.” Ọ́ọ́ wẹ, “O somhi aghọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","IJesu ọ fiẹ lase, e je Ute Ẹẹra Olivu, abi ọ kpẹ li. Eniyẹ odukhokho eyọli e deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","E ramhi aghọ, ọ́ọ́ wẹ, “A ke sọ iromhi ini a khi de pfilo imufẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ọ tikia na wẹ dẹnẹ, ọ wugha, ọ sọ iromhi, ọọ, ");
INSERT INTO atgNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ita, ini o ghọle ẹ, mie mhẹ uko osoli imẹmẹ onana, ama ọa khi abi o ghọle mhẹ, ama abi o li ghọle ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ighọ agẹni ọ rọte idane bhale ya ri ekpabọ na li. ");
INSERT INTO atgNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Rọte ọtomhẹ, ọ sọ iromhi egbegbọ ramhi ni ọpfọ ni e rọte ọli egbe e ku shi ekẹ, e khọ tikpọ abi ọlia. ");
INSERT INTO atgNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Abi ọ rọte iromhi isọsọ vule, ọ nyenẹ egbe bhale deba eniyẹ odukhokho eyọli. Ọ mẹ khi osoli ni e viẹ o ri ọlọsẹmhẹ shi wẹ egbe, e lesẹa. ");
INSERT INTO atgNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ọ mhila wẹ. “Elọ o zẹ khi a lesẹ-a? A vule ni a ke sọ iromhi ini a khi de pfilo imufẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Abi ọ kie li ngme eghọ, ẹgbọ e vẹ lole gbii. Ọmọse ni a lu iJudasi ni ọ li khi ọtuọghuo eniyẹ odukhokho ogbava eyi iJesu ọ rẹwẹ kia. Ọ lẹ deba iJesu ni lọli ya pfi ọli ẹlẹmhi egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","IJesu ọ mhila li, ọọ li, “IJudasi, eri u ri otsẹ ri Omi Ọgbọ ọ dẹ ena?” ");
INSERT INTO atgNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eni eniyẹ odukhokho eyi iJesu e mẹ emini a ya mẹ ena, e mhila li, “Ọnọmhuẹ anye ri itakobi ni e la anye abọ khọli?” ");
INSERT INTO atgNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ighọ ọghuo ọ, ọ ri itakobi fia ọni ọọ ga ọni ọ kpeda nya ọye ekpodalo-ugamhi esọ a. ");
INSERT INTO atgNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","IJesu ọ́ọ́ li, “Taa! Khi ke gbo li ighọ.” Ọ ri obọ ti ọni ọmọse oni esọ, oni esọ o gbẹla. ");
INSERT INTO atgNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","IJesu ọ mhila ighie eyi ekpodalo-ugamhi, ali eni ẹẹ khekhẹ Owa Oyi Ẹshinẹgba, ali eni egbhali ni e bhale ya mu ọli, “Eri mhia pfi ozughu ni a rọ tsua epia ali itakobi ali ikpokpo bhale ẹ deba mhẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ẹlẹ kpa mhi rọ la Owa Oyi Ẹshinẹgba ẹ sẹsẹ, ọngẹẹ ọa ri obọ ti mhẹ, ama ẹghẹghẹ oyẹẹ na ni ekpabọ alo ebili e rọ mhẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ighọ e mu ọli vu ya je owa oyi Ọkpodalo-ugamhi ọyi Ẹshinẹgba ni ọ kpeda nya. IPita ọ tapfia a deba wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Abi e ke rọ pfie erali shi iteva oyi oni atukpapfẹ ni e rọ shitọ, iPita ọ li bhale ya nu wẹ shitọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Abi ọkpotso ọni ọọ ga ọghuo ọ li mẹ khi iPita ọ nu wẹ shitọ, ọ bino ọli tsukẹ, ọ́ọ́ li, “Ọmọse ọna ọ li nu iJesu kia.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama iPita ọ tia. Ọ́ọ́ li, “Kpotso, Mhia fẹ ga lẹsẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","O dẹnẹ, ọmọse ọlese ọ ke gbo mẹ iPita, ọ mhila li, “U li nu iJesu u kia.” IPita ọ kẹ, “Mọse mhia nu ọli kia.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","O ke te aghọ ri emhi abi agogo oghuo dọsẹ, ọmọse ọlese ọ gẹ ma ọ gue, ọ́ọ́, “Mhi lẹsẹ gboo khi ọmọse ọna ọ nu iJesu u kia, irari khi ọnge iGalili ọ li khi!” ");
INSERT INTO atgNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ama iPita ọ sọ li ọ, ọ́ọ́ li, “Mọse, mhi a lẹsẹ emini u wa ngme ena.” Utoghuo kpe abi ọ kie li ngme, ọkpa ọ gbiẹghẹ ");
INSERT INTO atgNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ọnọmhuẹ ọ pfi alo bino iPita chii. IPita ọ todẹ sato ungmemhi ni iJesu ọ ngme ni ọ khi, “Neni ọkpa ọ ya gbiẹghẹ, u ya tia itesẹ, wẹ khi u waa lẹsẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","IPita ọ fiẹ je olase, ọ ya viẹ oya. ");
INSERT INTO atgNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Eni emọse ni e khẹ iJesu ekhẹ, e rọli li egia, e gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","E gẹnọ ọli alo, e mhila li, “Bọbọbọ! Ọghuo ọ ri emhi liẹ?” ");
INSERT INTO atgNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ighọ e ngme iwali ingmemhi ẹmuẹbe ebubu deba li. ");
INSERT INTO atgNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ogbe o gbe-a, eni egbhali ali ighie eyi ekpodalo-ugamhi, ali esẹsẹ Ishi eyi iMosisi e legba. E rue iJesu lasele migha iteva oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","E liẹ ọli, “Ini yẹyẹ u khi ọni ọmiagbọpfuese, gueyẹ anye.” IJesu ọ́ọ́ wẹ, “Ini mhi tseku gueyẹ ẹ, aa ya mie shi mhẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ini mhi mhila ẹ, aa ya gbaghiẹ a na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama rọte memena vu, omi ọgbọ ọ ya shitọ obita oyi Ẹshinẹgba obini iloghie.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wẹwẹ nya e mhila li, “Omi Ẹshinẹgba u khi?” Ọọ wẹ, “A guẹ ngme ni ẹ khi Omi ọ mhi khi.” ");
INSERT INTO atgNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ẹ egbewẹ, “Awa ke gbolo ẹ nono ọtsẹlẹ ọlese, awa-eghuo awa she ri esọ eyawa suọ abi ọ ri unu oyọli ngme.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ighọ eni igbaa nya e vule, e pfi ọli ukhomhi ralo ghi iPaleti. ");
INSERT INTO atgNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wẹwẹ nya e gue ẹzọ shi ọli egbe, ẹ liẹ, “Anye she mẹ ọmọse ọna khi ọ sẹsẹ ẹgbọ odẹ ẹgbhọli. Ọ́ọ́ ẹgbọ e khi ke zẹ oga na oghie iSiza, ọ gbolo a liẹ khi lọli khi Ọmiepfuese ni ọ gbo khi oghie.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ighọ iPaleti ọ mhila li, “Suọ khi yẹyẹ u khi oghie ọyi ẹgbọ iJu?” IJesu ọọ li, “Abi o li ghọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ighọ iPaleti ọ gueyẹ ighie eyi ekpodalo-ugamhi ali eni igbaa, “Mhi a mẹ ushi mu mhuẹ ọmọse ọna obọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wẹwẹ nya e liẹ, “Eri ọ ri osẹsẹ oyọli pfi ozughu ẹ shi ekẹ iJudia nya. Ekẹ iGalili ọ te gba li ekẹ le ni ọ rọ ramhi ana ena.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Abi iPaleti ọ rọ suọ ona, ọ mhila wẹ ini ọngi iGalili ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Abi ọ ke rọ suọ khi ekẹ ni Erọdu ọ mhẹsẹ shi iJesu ọ khi, ọ e rue ọli ghi Erọdu ni ọ li la iJerusalẹmu oni ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Abi Erọdu ọ rọ mẹ iJesu, egbe e mu ọli, itobọ khi o she tẹsẹ ni ọ te nono ni lọli mẹ ọli, irari khi ọ she kpẹ suọ eko ọli, ọ gbolo nono ni ọ la ukpẹloe luẹ gbe ikanya ọnyaloa eghuo. ");
INSERT INTO atgNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ọ mhila iJesu ogbọ ebubu ama iJesu ọa pfa shi ọli ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Eni Ighie eyi ekpodalo-ugamhi eyi Ẹshinẹgba ali esẹsẹ Ishi eyi iMosisi e migha aghọ, e pfi oni o nga ọ shi ọ ");
INSERT INTO atgNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ighọ Erọdu ali ekhọli-okhuẹ eyọli e gia li e gbo rọli li egia. E sọnọ li itsua ni e somhi otse ni e ghalẹ. E gbo rue ọli nyenẹ egbe ukhokho ghi iPaleti. ");
INSERT INTO atgNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ẹlẹghọ, iPaleti ali Erọdu e rọ somhi irari khi ọbe e kpẹ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","IPaleti ọ luno ighie eyi ekpodalo-ugamhi ali eni ẹ mhẹsẹ ali eni ẹgbọ nya, ");
INSERT INTO atgNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ọọ wẹ, “A rue ọmọse ọna ghi mhẹ, a liẹ khi ọ pfi ozughu shi ẹgbọ iteva. Ama ukpẹloe ẹ mhi la mhila li ogbọ lẹna, mhi aa mẹ emhi khọghuo ni a rọ gue ẹzọ shi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wẹkhi eri Erọdu ọ pfa ẹzọ mu ọli, irari khi ọ nyenẹ ọli egbe ukhokho ghi awa. A ga mẹ ọli gboo khi ọni ọmọse ọna ọa li ingme okhọghuo nabi a rọ ya liẹ a gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Irari ghọ mhi ya nasẹ ọli, mhi rue ọli obọ-a.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ini a li ukpe iPasova, iPaleti, ọ̀ọ́ mema rue ọgbọ ọghuo ighumha lasele na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wẹwẹ nya e ku unu a nyogho, “A rue ọli vu ya gbe-a! A ri ochoghọ rue iBarabasi obọ-a na anye!” ");
INSERT INTO atgNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Eri a kie kpẹ mu iBarabasi shi owa ighumha irari onyaghu ni ọ pfi shi oni ẹoli ali khi ọ gbo gbe ugbeli. ");
INSERT INTO atgNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","IPaleti ọ́ nono ni luẹ rue iJesu obọ-a, ọ gbo lema wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","E kiele tsẹsẹ nyoghoo, “A ta li ma ọọra apfida gbe-a! A ta li ma ọọra apfida gbe-a!” ");
INSERT INTO atgNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Utonuzesẹ, ọ gbo nu wẹ ngme, ọọ, “Elọ o zẹ, Ingmobe onoghuo ọ riẹlẹ? Irari khi mhia mẹ emini o zẹ ni a rọ ya gbe ọli-a. Itobọ ighọ, mhi lẹsẹ ya nasẹ ọli, mhi rue ọli obọ-a.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","E kiele tsẹsẹ nyoghoo, a ta iJesu ma ọọra apfida gbe-a. Atsẹsẹ oyẹwẹ o rọli tsẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ighọ iPaleti ọ lama shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ọ rue iBarabasi ni a mu shi owa khi ọ pfi ozughu shi oni ekẹ, ni o gbo gbe ugbe, obọ-a na wẹ. Ighọ ọ ri iJesu na wẹ, e ka li ọli abi o ghọle wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abi e li rue ọli lẹẹ, e mẹ ọmọse ọghuo ni a lu iSamọ ọngi iZirẹni ni ọ rọte ẹoli odonuẹ lo oni ẹoli le. E ri itoto mu ọli, sheli ọli oni ọọra apfida oghọ, ọ́ tsua li nga ike deba iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ebubu ẹgbọ e deba iJesu, shi ikpotso ni e viẹ e viẹ oya na li. ");
INSERT INTO atgNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","IJesu ọ nyenẹ alo ghue wẹ, ọ́ọ́ wẹ, “Ikpotso iJerusalẹmu, a khi ke viẹ na mhẹ. A ke viẹ na egbe ẹ ali imi ẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Irari khi oni ẹghẹghẹ ọọ bhale ni a rọ ya ke liẹ, ‘Ikhivọsẹ o khi na ikpotso ni ẹa bia eniyẹ, ni ẹa mẹ umẹmhi ghue, wẹkhi e ri e mu ẹnyeli shi ọmọ unu ghue.’ ");
INSERT INTO atgNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","E ya liẹ ute, ‘De mu anye,’ ẹẹ ite enikeke, ‘A de khukhu anye a.’ ");
INSERT INTO atgNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Irari ini ẹgbọ ẹẹ li na ini egua o vọ ebuli-a zughu, sẹ e kẹ ẹ li ini o khakha?” ");
INSERT INTO atgNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A li muno ighiatọ aava ni a li ya gbe-a toma li egbe. ");
INSERT INTO atgNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Abi e rọ ramhi ashini a lu, “Ugua ukhomhi olimhi,” aghọ e gbe ọli ali ighiatọ eghọ a shi. E ta ọghuo ma ọọra shi ọli ukiẹkiẹ obita, e ta ọnọkpọle shi ukiẹkiẹ obọ ọgobọ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","IJesu ọli, “Ita, gbekua na wẹ irari khi ẹa lẹsẹ emini ẹẹ li.” E ri amukpaghọ pfi onolo rọ kemhi itsua eyọli. ");
INSERT INTO atgNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Eni ẹgbọ e migha bino, enighie e dọli ọkọnyọ. E liẹ, “Ọọ tsumhi ẹgbọẹse, ọ tsumhi egbọli ini lọli ọ khi Ọmiepfuese ọyi Ẹshinẹgba ni a zẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Eni ekhọli-okhuẹ e li bhale ya rọli li egia. E ri onyọ ni ọ yala nali ọ mọ da. ");
INSERT INTO atgNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ẹ ọli, “Ini o khia khi yẹyẹ u khi oghie ọyi ẹgbọ iJu, tsumhi egbe ẹ shọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","E kẹkẹ emhi tama kpeda na li ni o ngme khi, “Ọna ọ khi Oghie ọyi Ẹgbọ iJu.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oghiatọ ọghuo ni a li tama ọara, ọ tsue iJesu. Ọ liẹ ọli, “Óá khi yẹyẹ wẹ khi Ọmiepfuese u khi? Tsumhi egbe ẹ, ni u li tsumhi anye.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama oghiatọ ọnọkpọle, ọ dese ọli, ọọ li, “Ulishi Ẹshinẹgba ọa ya muẹ, aborọkhia khi eri ushi oghuo o ga mu awa? ");
INSERT INTO atgNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Akanya ni awa gbe awa mie ifata to e na. Ama ọmọse ọna, ọa li emhikhọghuo ni ọ mẹ osue a shi.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ighọ ọ́ọ́ iJesu, “Sato mhẹ egbe ini u bhale ukpẹkhomhi eghiele oyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","IJesu ọọ li, “Mhi gueyẹ khi, ogbe-namo ena, u ya nu mhẹ la Apfẹ oyi Ẹshinẹgba na iloghie.” ");
INSERT INTO atgNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Agogo igbẹva ẹlẹ ọguota o lẹsẹ nu, obili o te bi oni ekẹ nya ya ramhi agogo esẹ ẹlẹ ogbọmhi. ");
INSERT INTO atgNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Irari khi ovọ ọa ke to, ode ugbakpi ni a rọ pfa odẹ a shi elemhi Owa Oyi Ẹshinẹgba o te iteva kiẹsẹ-a eva ya to ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","IJesu ọ lu leghe, ọọ, “Ita, mhi ri ayẹmhẹ oyẹmhẹ mhọli ẹ obọ.” Abi ọ rọ na ngme se, ọ ghua. ");
INSERT INTO atgNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Abi ọga ọkhọli-okhuẹ ni ọ la aghọ ọ rọ mẹ emini a mẹ, ọ kuẹghiẹ Ẹshinẹgba, ọọ li, “Egbegbọ lọ khi ọmọse ọna ọni ọ pfuasẹ ọ khi!” ");
INSERT INTO atgNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abi ẹgbọ ni e le gba aghọ ni wẹwẹ e ri ukpẹloe mẹ emini a mẹ, e rọ mẹ emini a mẹ, ee viẹ osue, e je. ");
INSERT INTO atgNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ama ẹgbọ nya ni e lẹsẹ ọli ali ikpotso ni e rọte iGalili deba li, e migha tapfia bino emini a ga mẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ọmọse ọghuo ọ la ọ na lu iJosẹfu. Ọ khi ọghuo emọse ni ẹẹ mhẹsẹ. Ọ khi ọmọse ọnete ni ọ pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ọa lama shi ọ a ka gbe iJesu a. Ọngi ẹoli Arimatia na ekẹ iJudia ọ khi. Ọ migha khẹ Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ọ lẹ deba oghie iPaleti ya mhila li olimhi oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ọ rọte ọọra apfida rue ọli tiemhile, ọ ri ide enegbọ khuli ọli. Ọ ya rọli shi uji ufuẹchẹ ni a tọ-a, ni ọgbọ ọa kpẹ ri olimhi tọ ghue. ");
INSERT INTO atgNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ogbẹlẹ ni o mama ẹlẹ iyẹmhẹa oyi ẹgbọ iJu lọ. Ẹlẹ iyẹmhẹa o she lẹsẹ ya ramhi. ");
INSERT INTO atgNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eni ikpotso ni e rọte iGalili deba iJesu bhale e deba li ya mẹ uji ni ọ ri iJesu tọ. Ali abi ọ li rọli tọ. ");
INSERT INTO atgNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ighọ e nyenẹ egbe je apfẹ ya rue ituale ni a ku ẹ shi olimhi egbe. Ama e yẹmhẹ-a ogbẹlẹ iyẹmhẹa. E ri ona ri ushi ogbẹlẹ iyẹmhẹa gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ẹlẹ ni ododẹ na elemhi ẹfo uka, ogbiẹ fiefie, eni ikpotso e bhale uji ni a ri iJesu tọ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ẹ mẹ khi ẹchẹ ni a rọ khukhu oni uji, khi a gheghele ọli odẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ama abi e rọ lo elemhi oni uji, ẹa mẹ idiegbe oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Abọ e sha wẹ, abi e li migha a sa ọ eghọ, e mẹ khi emọse aava ni e sọ itsua epfopfo ni e gẹ nyanyanya e nu wẹ migha. ");
INSERT INTO atgNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ulishi oo mu wẹ, e nyẹsẹ ukhomhi sọ alo ghue ekẹ. Ama eni emọse e mhila wẹ, “Elọ o zẹ ni a rọ nono ọgbọ ni ọ la agbọ ifuabọ oyi ẹgbọ ni e ghua? ");
INSERT INTO atgNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ọa ke la ana, ọ she guale. A sato emini ọ gueyẹ ẹ abi ọ rọ la iGalili khi: ");
INSERT INTO atgNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Omi Ọgbọ ọ mema ya mẹ osue obọ oyi ẹgbọ olamhẹ, e gbe ọli-a shi apfida, ama ẹlẹnuzi-esẹ ọ ya guale.’ ” ");
INSERT INTO atgNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","E tigbe yele eni ingme eyọli le. ");
INSERT INTO atgNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","E rọte atalimhi bhale, e gueyẹ eniyẹ odukhokho ogbaghuo enekpọle ali ẹgbọ elese ni e la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","IMeli ọngi iMagidaleni ali iJoana ali iMeli inyi iJemhisi ali ikpotso ni e nu wẹ kia e gueyẹ eni ighiusomhi na kẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama eni eniyẹ odukhokho e dabi khi ingmemhi afuẹ eni ikpotso ee ngme, ẹa pfi esọ shi wẹ ọ ");
INSERT INTO atgNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama iPita ọ vule, ọ na ya je oni atalimhi, ọ ramhi aghọ, ọ nyẹsẹ egbe bino elemhi oni uji, ọ lẹsẹ mẹ ide ni a rọ khuli ọli eghọ aghọ, ama ọa mẹ idiegbe oyi iJesu. Ighọ ọ li je apfẹ, abọ e sha li. ");
INSERT INTO atgNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Oni ogbẹlẹ ni ẹ ngme ena, eniyẹ odukhokho aava eyi iJesu e je ẹoli Emausi ni o khi imali igbaghuo rọte iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","E nu egbewẹ ngme ingme enana ni a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Abi e li ngme ni e li lẹẹ eghọ, iJesu ọ khu wẹ ẹ, e ga kia lẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","E mẹ ọli ama ẹa lẹsẹ ọni ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","IJesu ọ mhila wẹ, “Elọ a nu egbe a ngme abi a li kia lẹẹ ena?” E mu migha, alo eyẹwẹ e khi osoli-osoli. ");
INSERT INTO atgNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ọghuo elemhi wẹ ni a lu iKilopasi ọ mhila li, “Ọpfẹse ọshẹbhẹ u khi shi ekẹ iJerusalẹmu ni ọa lẹsẹ emini a mẹ ekẹ ona aenẹluẹ?” ");
INSERT INTO atgNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Emhi eneghuo a mẹ?” IJesu ọ mhila wẹ. Eni emọse ẹ ọli, “Emini e li iJesu ọna iNazarẹti. Ọmekẹguele ọmọse ọna ọ khi, ọ mhuẹ ekpabọ oyi Ẹshinẹgba. Ẹgbọ e lẹsẹ ọli shi emini ọ riẹlẹ ali ingmemhi ni ọ gbolo o ngme. ");
INSERT INTO atgNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ighie eyi ekpodalo-ugamhi eyi Ẹshinẹgba ali enighie e rue ọli lasele ni a gbe-a shi ọọra apfida. ");
INSERT INTO atgNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eri anye dabi khi lọli ọ ya pfa ẹgbọ iZirẹni shi ekẹ. Amo li ẹlẹ esẹ abi a te mẹ ingme ena. ");
INSERT INTO atgNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ikpotso eghuo eyi anye e ri abọ sha anye. E je uji oyọli amo uzogbe fiefie, ");
INSERT INTO atgNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ama ẹa mẹ idiegbe oyọli. E nyenẹ egbe bhale ya gue khi wẹwẹ e mẹ igẹni ni e gueyẹ wẹwẹ khi ọ she guale. ");
INSERT INTO atgNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ẹgbọ eghuo elemhi anye e she je obọ ya bino e mẹ khi abi e ngme o khi, ama ẹa mẹ iJesu.” ");
INSERT INTO atgNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","IJesu ọọ wẹ, “A khi eyẹghẹ e, ni udu oyẹẹ ọa nyanya mie emini emekẹguele e ngme suọ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aa lẹsẹ khi ina ọni Ọmiepfuese ọ li ya mẹ osue neni ọ lo ufumhi oyọli?” ");
INSERT INTO atgNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ọni iJesu ọ tigbe ri emini a kẹkẹ shi Ebe-no-pfuasẹ lo wẹ esọ ni e la ebe Ushi oyi iMosisi ali eyi emekẹguele nya. ");
INSERT INTO atgNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Abi e li ti ramhi ukuku ẹoli ni e je, iJesu ọ riẹlẹ abinẹ khi lọli ti okiali oyẹluẹ ya je odalo. ");
INSERT INTO atgNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ama ee ti ọli, ẹẹ ọli, “Nu anye kushi ana irari khi ogbe o she vu, obili o she gbolo-a bi.” Ighọ ọ deba wẹ ọ ya kushi na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Abi e kerọ shitọ ya ke le eminale, ọ rue oni ibulẹdi, ọ kphẹmhi, ọ khi ọli-a, ọ kemhi na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ẹghẹghẹ ana, alo eyẹwẹ e khueghie-a, e tigbe lẹsẹ khi lọli lọ. Eri-tsẹ ọ kele-a, ẹa ke mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ẹ egbewẹ, “Ọọ khi eri ọ li abi erali shi awa udu abi ọ rọ la odẹ nu awa ngme ni ọ gbo rọ gue abi Ebe-no-pfuasẹ o ngme yẹ awa?” ");
INSERT INTO atgNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aghọaghọ e vule nyenẹ egbe ukhokho je iJerusalẹmu. E bhale ya ẹ eniyẹ odukhokho ogbaghuo ali ẹgbọ enekpọle ni e ga legba, ");
INSERT INTO atgNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ni e liẹ, “Egbegbi ingme lọ khi Ọnọmhuẹ ọ she guale, ọ ri egbọli gbo khasẹ iSamọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ighọ eni etuava eghọ e guele emini a mẹ odẹ, ali abi e lẹsẹ iJesu ẹghẹghẹ ni ọ rọ khi ibulẹdi-a na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Abi e rọ kie ghọ ngme oni ungmemhi, iJesu ọ migha wẹ iteva ọọ wẹ, “Opfọmhẹ o nu ẹ la.” ");
INSERT INTO atgNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","E yila, ulishi óó mu wẹ, e dabi khi ayẹmhẹ olimhi ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ọọ wẹ, “Elọ o zẹ ni udu oyẹ ẹ o rọ nighise, ni a rọ gbo mhọli akhọkhọmhẹ shi udu oyẹ ẹ? ");
INSERT INTO atgNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","A bino abọ ali awẹ eyẹmhẹ. Mhẹmhẹ lọ. A ri obọ timhẹ ni a mẹ khi olimhi ọgbọ ọa ya mhọli idiegbe ali igua, nabi a mẹ khi mhi mhọli ena.” ");
INSERT INTO atgNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Abi ọ rọ ngme na se, ọ ri abọ ali awẹ eyọli khasẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abi oghẹlẹ ali ọshabọ ni o vọ wẹ udu ọa kie zẹ wẹ mie shi ọ ne, iJesu ọ mhila wẹ, “A li mhọli emhikhọghuo shi akana ni a le ghọ?” ");
INSERT INTO atgNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","E rue afẹlẹ ni a nye na li, ");
INSERT INTO atgNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ọ rue ọli la akpẹwẹ rọli le. ");
INSERT INTO atgNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ọọ wẹ, “Ena e khi emini mhi gueyẹ ẹ abi mhi rọ kie nu ẹ la. Ingme eyẹmhẹ nya ni a kẹkẹ shi Ushi oyi iMosisi ali, ebe eyi Emekẹguele eyi Ẹshinẹgba ali Ebe Iwolo, e mema bhale ya tsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ighọ ọ khueghie wẹ udu-a ni e mẹ asha lẹsẹ emini a kẹkẹ shi Ebe-no-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ọ gueyẹ wẹ, “Emini a kẹkẹ shi ekẹ na. Ọmiepfuese ọ ya mẹ osoli, ọ rọte eghuli guale ẹlẹnuzi-esẹ, ");
INSERT INTO atgNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ẹghẹghẹ aghọ a ya ri eva oyọli ri imupfi ali irolamhẹ-topfa tse abọ ushishi nya, rọte iJerusalẹmu gba ekẹ le. ");
INSERT INTO atgNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A ga mẹ eni emhi enana nya. ");
INSERT INTO atgNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mhi ya ri emini Itamhẹ ọ shobọ ghie usomhi ghi ẹ, eri-tsẹ a la elemhi ẹoli iJerusalẹmu ramhi ni a rọ ya ri itoto rọte obini o yagha ghi ẹ ni o ya kpha ẹ sọ.” ");
INSERT INTO atgNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Abi ọ rọ rue wẹ vu ya fiẹ, ni e rọ kia ramhi iBẹtani, ọ tsua abọ idane, ọ ku isẹmhẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Abi ọ li ku isẹmhẹ na wẹ, ọ́ọ́ zẹ wẹ obọ, a rue ọli nga idane. ");
INSERT INTO atgNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ighọ e nyẹsẹ ukhomhi ga li. E mu egbe pfi ri ukpokpomhi oghẹlẹ je iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","E kiele la owa ugamhi no funẹ tsẹ, e kuẹghiẹ Ẹshinẹgba.");
INSERT INTO atgNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Igbaekẹle, Ungmemhi Ọ she kpẹ la ọ. Ọni Ungmemhi ọ nu Ẹshinẹgba la. Ọni Ungmemhi Ọ khi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Igbaekẹle lọli ali Ẹshinẹgba e te ga la. ");
INSERT INTO atgNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Obọ oyọli a te ma emhikpa. Aa mẹ emhikhọghuo ni a ma ni aa rọte obọ oyọli ma. ");
INSERT INTO atgNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lọli ọ mhọli agbọ na agbọagbọ. Oni agbọ oyọli, o ri ákpá na ẹgbọ na agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Oni ákpá o gẹ nga alo ebili, ama alo ebili ọa dobẹ pfuse ọli a. ");
INSERT INTO atgNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ẹshinẹgba ọ ghie ọmọse ọghuo ni a lu iJọni ghi ẹgbọ na agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Lọli ọ bhale ya pfi ọtsẹlẹ shi ọni ọgbọ ni ọ khi oni ákpá, ni ẹgbọ nya e rọte oni ọtsẹlẹ miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ọa khi ọni iJọni ọ khi oni ákpá; eri ọ li bhale ya pfi ọtsẹlẹ shi oni ákpá. ");
INSERT INTO atgNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lọli ọ khi oni egbegbi ákpá, ni ọ ya bhale agbọ ni ọ ya ri imekẹ na ẹgbọ nya. ");
INSERT INTO atgNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ọni Ungmemhi ọ la agbọ, ẹgbọ ẹa lẹsẹ ọli, abi o ri riẹ khia khi lọli a rọte obọ oyọli ma agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ọ bhale deba ẹgbọ eyọli, ẹa lama mie ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama, ebubu ni e da lama mie ọli, ni e lẹsẹ mie eva oyọli suọ, wẹwẹ ọ ri afu na e rọ̀ mele imi Ẹshinẹgba a. ");
INSERT INTO atgNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ọa khi abi ita ali inyọ e liẹ bia ọgbọ alo-gbugbugbu a ri ona ngme, ama Ẹshinẹgba ọ khi ita wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ọni Ungmemhi ọ mele ọgbọ-a, ọ nu awa la agbọ ona, awa mẹ ufumhi oyọli, ikhi ufumhi oyi omi Ita ọtuọghuo kpe ni Ita ọ mhọli, ọni ọ rọte obọ oyi Ita bhale, ọni ọ mhọli isomhelemhi ali igẹsikia gbeku ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","IJọni ọ́ kia tse abọ ingme oyọli yẹ ẹgbọ, ọ́ọ́ tsẹsẹ, ọ́ọ́ liẹ, “Ọna mhi gueyẹ ẹ khi ọ ya bhale odukhokho oyẹmhẹ, ama ọ fu dọsẹ mhẹ itobọ khi ọ kpẹ la agbọ neni a bia mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Rọte isomhelemhi oyọli ni o gbeku ọ, awa te mhọli ikhivọsẹ ọdọda. ");
INSERT INTO atgNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Obọ oyi iMosisi Ẹshinẹgba ọ te ri ushi na awa, ama obọ oyi iJesu iKirisiti isomhelemhi ali igẹsikia e te bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ọgbọkhọghuo ọa mẹ Ẹshinẹgba ghue. Ama, Omi Ẹshinẹgba ọtuọghuo kpe, ni lọli ali Ẹshinẹgba e khi ọghuo, ni lọli ali Ita e ga la, lọli o zẹ ni agbọ e rọ lẹsẹ Ita. ");
INSERT INTO atgNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Egbhali eyi iJu ni e la iJerusalẹmu e ghie eni ẹẹ ralo ugamhi oyi Ẹshinẹgba ali eni ẹ nu wẹ gbe ikanya owa-ugamhi, e ka mhila iJọni ọni ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","IJọni ọa rọ sheli wẹ, ọ nyanya sọ wẹ ọ, ọ gueyẹ wẹ gboo khi ọa khi lọli khi ọni Ọmiepfuese. ");
INSERT INTO atgNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","E mhila li, “Ọghuo u ke khi shọ? Elaja u khi?” IJọni ọọ, “Iiye.” E gbo mhila li. “Ọmekẹguele ọyi Ẹshinẹgba u khi?” Ọ ọ “Iiye.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","E gbolo ẹ, “Gueyẹ anye ọni u khi shọ, ni anye mẹ emini anye ya gueyẹ eni e ghie anye, elọ yẹyẹ u khi shọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","IJọni ọ rọte ungmemhi ni Azaya ọmekẹguele ọyi Ẹshinẹgba ọ ngme sọ wẹ ọ, ọọ, “Mhẹmhẹ mhi khi uruli oyi ọgbọ ni o la ọdagbe ẹ tsẹsẹ, ni ọọ liẹ, ‘A riẹlẹ udu oyẹ ẹ shi ekẹ khẹ Ọnọmhuẹ ni ọ́ ọ bhale.’ ” ");
INSERT INTO atgNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ẹgbọ ni ẹgbọ iFarisi e ghie ghi iJọni, e mhila li, ");
INSERT INTO atgNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Abi u a rọ khi Ọmiepfuese, ni u a rọ khi Elaja, wẹkhi ọni ọmekẹguele ọyi Ẹshinẹgba u khi ena, elọ o zẹ ni u rọ ọ batazi ẹgbọ shọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","IJọni ọ sọ wẹ ọ, ọọ, “Amẹ mhi rọ batazi ẹgbọ memena, ama ọgbọ ọghuo ọ la ẹ iteva memena ni aa lẹsẹ ne. ");
INSERT INTO atgNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Lọli ọ ke ya bhale odukhokho oyẹmhẹ, ni o khia khi mhia fu ramhi ọni ọ́ ọ̀ taghiẹ uli oyi ẹkuẹ ni ọ rọ sọ a.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Obini iBẹtani ni o la ukiẹkiẹ obini ovọ o te ẹ ngale shi okẹ iJọdani, ashini iJọni ọ la batazi ẹgbọ, a la mẹ eni ingme ena nya. ");
INSERT INTO atgNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ogbeakọlọ iJọni ọ mẹ khi iJesu ọọ bhale, iJọni ọ gueyẹ ẹgbọ, ọọ, “Omi Osumha ọyi Ẹshinẹgba ni ọ́ rue olamhẹ eyi agbọ vu na! ");
INSERT INTO atgNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ọna mhi ngme abi mhi rọ liẹ, ‘Ọmọse ọghuo ọ ya bhale ni ọ́ fu dọsẹ mhẹ, itobọ khi ọ she kpẹ la ọ neni a bia mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Egbegbi mhẹmhẹ mhia kpẹ lẹsẹ ọli ghue, ama eri mhi bhale ri amẹ ẹ batazi ẹgbọ ini mhi mẹ asha ri ọli khasẹ ẹgbọ iZirẹni.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ighọ iJọni ọ pfi ọtsẹlẹ ona khi, “Mhi mẹ khi Ayẹmhẹ ọ li abi anekhukhu rọte idane tiemhie ya ma li egbe. ");
INSERT INTO atgNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mhia kha kpẹ lẹsẹ ọli, ama ọni ọ ghie mhẹ mhi ri amẹ ke batazi ẹgbọ, ọọ mhẹ, ‘Ọni u da mẹ khi oni Ayẹmhẹ ọ tiemhie shi ọ khi ọ migha li egbe ne, lọli ọ khi ọni ọ ya ke ri Ayẹmhẹ-nọ-pfuasẹ batazi ẹgbọ.’ ");
INSERT INTO atgNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ighọ eni emini a gueyẹ mhẹ ena e li de shi ukpẹloe oyẹmhẹ, ni o rẹmhẹ gueyẹ ẹ khi Omi Ẹshinẹgba ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ogbeakọlọ iJọni ali eniyẹ odukhokho eyọli etuava e gbo migha akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Abi iJọni ọ rọ mẹ khi iJesu ọọ dọsẹ, ọọ, “Bino Omi osumha ọyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Abi eniyẹ odukhokho etuava eghọ e rọ suọ ona te, e deba iJesu vu. ");
INSERT INTO atgNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","IJesu ọ pfi alo ukhokho, ọ mẹ wẹ khi ẹẹ deba luẹ, ọ mhila wẹ, “Elọ a nono.” Ẹẹ ọli, “Ọsẹsẹ, obo wa la?” ");
INSERT INTO atgNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ọọ wẹ, “A bhale ya bino.” Ighọ e deba li, e mẹ obini ọ la. Aghọ e ke nu ọ la ẹlẹghọ nya rọte agogo ene ẹlẹ ọguota vu. ");
INSERT INTO atgNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ọtuọghuo eniyẹ odukhokho etuava ni e suọ emini iJọni ọ ngme ni e deba iJesu vu ọ khi Aduru, inyọghuo iSamọ iPita. ");
INSERT INTO atgNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ighọ Aduru ọ nyanya kpẹ te ododẹ nono iSamọ inyọghuo ọli gueyẹ, ọọ, “Anye she mẹ Ọmiepfuese.” (Emini a ri iKirisiti ngme khi, Ọmiepfuese.) ");
INSERT INTO atgNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aduru ọ rue iSamọ bhale ghi iJesu. IJesu ọ bino ọli, ọọ, “Yẹyẹ u khi ISamọ omi iJọni, iKefasi a kẹ ẹ ke lu ẹ. IPita ali iKefasi emhi oghuo a rẹwẹ ngme.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ogbeakọlọ, iJesu ọ ke mu egbe khi lọli rọte aghọ vu ya ke je iGalili. Ọ mẹ iFilipu, ọọ li, “Deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ọnge iBẹtisaida ni Aduru ali iPita e khi iFilipu ọ li khi. ");
INSERT INTO atgNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","IFilipu ọ ke nono iNataniẹli mẹ. Ọọ li, “Anye she mẹ ọni iMosisi ọ kẹkẹ ingme oyọli shi ebe ushi, ni emekẹguele e gbo kẹkẹ ingme oyọli shi Ebe-no-pfuasẹ, ikhi iJesu ọnge iNazarẹti Omi iJosẹfu.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","INataniẹli ọọ, “INazarẹti wẹ, eminete o li rọte iNazarẹti ẹ lase?” IFilipu ọọ, “Lẹsẹ bhale ya bino tsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Abi iJesu ọ rọ mẹ iNataniẹli khi ọọ bhale obini luẹ la, iJesu ọọ, “Egbegbi ọnge iZirẹni na, ọni ọa ya lo ẹgbhọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","INataniẹli ọ mhila li, “Sẹ u ghọ lẹsẹ mhẹ?” IJesu ọọ, “Mhi she mẹ abi u rọ la udi ọkhua eni neni iFilipu ọ lu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","INataniẹli ọọ, “Ọsẹsẹ, Omi Ẹshinẹgba u khi, oghie oyi iZirẹni!” ");
INSERT INTO atgNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","IJesu ọọ, “Itobọ khi mhiẹ khi mhi mẹ ẹ udi ọkhua eni u rọ tigbe miesuọ, u ya mẹ emini e dọsẹ ona.” ");
INSERT INTO atgNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ọ gbo gueyẹ wẹ, “A ya mẹ khi idane o khueghie-a, a mẹ khi igẹni eyi Ẹshinẹgba e rọte idane ẹ tiemhile ya nga shi mhẹmhẹ Omi Ọgbọ ọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ogbẹlẹ onuzi-esẹ, a la iKena na ekẹ iGalili ri ọmueshi ya ngeli. Inyọ iJesu ọ la aghọ, ");
INSERT INTO atgNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A li lu iJesu ali eniyẹ odukhokho eyọli shi oni ilegba ni a la ri ọmueshi ngeli. ");
INSERT INTO atgNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Abi onyọ ni a la aghọ da o rọ pfo, inyọ iJesu ọọ iJesu, “Onyọ e pfo wẹ rọ da.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","IJesu ọọ, “Inyọ, khi ke gueyẹ mhẹ emini mhi ya li, itobọ khi ẹghẹghẹ oyẹmhẹ ọa ramhi ne.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inyọ iJesu ọ gueyẹ eni e sọ onyọ, “A ri emini ọ da gueyẹ ẹ gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ikpokpomhi idubọ echẹ esesa e la epfẹ aghọ na diẹ amẹ ẹ shi ni ẹgbọ iJu e rọ kpe egbe a abi ushi oyẹwẹ o ngme. Udubọ oghuo oghuo, ọọ mie italabi amẹ ene. ");
INSERT INTO atgNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","IJesu ọ gueyẹ eni e sọ onyọ, “A ka diẹ amẹ vọ eni idubọ esesa.” Ighọ e diẹ amẹ vọ ẹwẹ nya tẹ unu tsuẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ighọ ọọ, “A diẹ ọ ghi ọni ọ ri ukpẹloe ẹ khu oni ilegba.” Ighọ e diẹ ọ ghi ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ọni ọ ri ukpẹloe ẹ khu ilegba ọ rọte eni amẹ ni a she rọ mele onyọ a da bino, ọa kpẹ lẹsẹ obini a mẹ wẹ, ama eni ẹ sọ onyọ e lẹsẹ obini a mẹ wẹ. Ighọ ọni ọmọse ọ lu ughuẹ-ọmueshi je epfẹ etẹ, ");
INSERT INTO atgNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ọọ li, “Ashini a la riẹlẹ emhi onana kpa, onyọ onete onana a kpẹ rọ lasele na ẹgbọ da khue neni a ri onyọ oni o kpọ-a lasele, Elọ o zẹ ni a rọ ri onyọ ona kpe shi aghọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ona o khi akanya ọnyaloa oni ododẹ ni iJesu ọ gbe. Ẹoli iKena na ekẹ iGalili ọ la riẹlẹ ọ. Onana ọ rọ ri ufumhi oyọli khasẹ, ni eniyẹ odukhokho eyọli e rọ mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ona o dọsẹ se, iJesu ali inyọli, ghe inyọghuo ọli eni emọse ali eniyẹ odukhokho eyọli e tiemhi obini iKapanọmu. E la oobọ ukuku ogbẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Abi ẹghẹghẹ ukpe oyi ẹgbọ iJu ni a lu iPasova o rọ ti bhale, iJesu ọ nga obini iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ọ́ bhale ya ẹ khi ẹgbọ e la elemhi apfẹ oyi Owa oyi Ẹshinẹgba ri ena ali isumha ali inekhukhu ẹ dẹ. Eghuo e shitọ pfa ikpaghọ na ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ighọ iJesu ọ rue ili rọ lali utali ulumhekie rọ khu wẹ ya lase nya, ghe eni ena ali isumha; ọ miatsẹ wẹ ikpaghọ kua, ọ ghi wẹ abọ okphẹ kpha ku-a. ");
INSERT INTO atgNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ọ́ọ́ eni e ri inekhukhu ẹ de, “A muno wẹ ana-a! Sẹ a li ri owa oyi Ita mhẹmhẹ ẹ mele oki a.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Eniyẹ odukhokho eyọli e ya yelele emini a kpẹ kẹkẹ shi Ebe-no-pfuasẹ khi, “Ingme owa oyẹ o mu mhẹ egbe gba.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ighọ enighie eyi iJu e mhila iJesu ini ọ mhọli ikanya ọnyaloa ni ọ ya gbe ni o ya rọkhasẹ ẹwẹ khi ọ mhọli afu ni ọ rọ riẹlẹ enana nya. ");
INSERT INTO atgNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","IJesu ọọ wẹ, “A bighi oni Owa oyi Ẹshinẹgba ona nya gbe, mhi ya gbo riẹlẹ ọ tọ ogbẹlẹ esẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Enighie eyi iJu e ke mhila, “Owa ni a ri ikpe egbhuẹva ali esesa tọ wa liẹ khi u ri ogbẹlẹ esẹ tsẹ ya riẹlẹ tọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama egbe oyọli ọ ri oni Owa oyi Ẹshinẹgba ni ọ ngme khọkhọ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Abi ọ rọ ghu-a ni Ẹshinẹgba ọ rọ gbo guise ọ le, eniyẹ odukhokho eyọli e rọ tigbe sa ya to emini ọ ke ngme. Ona o rẹwẹ mie ungmemhi oni o la Ebe-no-pfuasẹ, ali ingme oyi iJesu lolo suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ẹghẹghẹ ni iJesu ọ rọ la iJerusalẹmu, ikhi ẹghẹghẹ ukpe iPasova, ebubu ẹgbọ e rọ mie ọli suọ itobọ khi e mẹ ikanya ọnyaloa ni ọ gbe. ");
INSERT INTO atgNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama iJesu ọa ya regbenga wẹ obọ itobọ khi ọ lẹsẹ emini ẹgbọ e khi pfo nya. ");
INSERT INTO atgNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ọa khi ọgbọ ọ ke gbo ya gue ingme oyi ẹgbọ yẹ ọli, itobọ khi ọ she lẹsẹ emini o la wẹ udu. ");
INSERT INTO atgNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ọmọse ọghuo ọ la ọ ni ọ la otu iFarisi, ọ khi ọkhẹmhuẹ ni ọ mu ẹloe shi elemhi iJu, a lu ọli iNikodemọsi. ");
INSERT INTO atgNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ọni ọmọse ọna ọ bhale deba iJesu ẹliyọsẹ ẹlẹghuo, ọọ li, “Ọsẹsẹ, anye lẹsẹ khi ọni ọọ sẹsẹ ni ọ rọte obọ oyi Ẹshinẹgba bhale u khi. Itobọ khi ọgbọkhọghuo ọa ya dobẹ ke gbe ikanya ọnyaloa enabi u wa gbe ena ini Ẹshinẹgba ọa nu ọli la.” ");
INSERT INTO atgNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","IJesu ọọ li, “Mhi gue igẹsikia yẹ khi, ini aa li riẹlẹ ọgbọ bia, ọa ya mẹ Eghiele oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","INikodemọsi ọọ li, “Sẹ a li gbo riẹlẹ ọgbọ ni ọ womhẹ se bia? Eri ọ gbo ya lo inyọli elemhi ni ọ gbo riẹlẹ ọli bia?” ");
INSERT INTO atgNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","IJesu ọ sọli ọ, ọọ li, “Mhi gue igẹsikia yẹ khi, aa mẹ ọgbọkhọghuo ni ọ ya lo Eghiele oyi Ẹshinẹgba ini aa bia li elemhi amẹ ali elemhi Ayẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ọmọse ali ọkpotso ẹẹ bia ọgbọ alo gbugbugbu, ama Ayẹmhẹ oyi Ẹshinẹgba a rọ riẹlẹ ọgbọ ọ bia elemhi ayẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Khi zẹ ni ungmemhi ni mhiẹ khi, ‘A mema riẹlẹ ẹ ya bia,’ o lighọ ri abọ shẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Obini o ghọle akpekpeli o li ẹ je, eri awa liẹ suọ abi o liẹ li, ama awa aa ya mẹ ọli. Ighọ ingme oyi eni a riẹlẹ bia elemhi Ayẹmhẹ oyi Ẹshinẹgba e li.” ");
INSERT INTO atgNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","INikodemọsi ọ mhila iJesu, “Sẹ a liẹ mẹ ghọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","IJesu ọọ, “Yẹyẹ ukpokpo-ọgbọ ọguebe ni u liẹ sẹsẹ ẹgbọ ekẹ iZirẹni waa lẹsẹ ona? ");
INSERT INTO atgNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Abi o li mhi li gue ọli ẹ yẹ khi emini anye lẹsẹ, anye ẹ ngme. Emini anye mẹ, anye ẹ gueyẹ agbọ. Ama aa nono ni a mie usomhi oyi anye suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ini waa mie mhẹ suọ ini mhi gue ingme ena agbọ ona yẹ, sẹ u liẹ mie mhẹ suọ ini mhi gue ingme iloghie yẹ? ");
INSERT INTO atgNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ọgbọkhọghuo ọa kpẹ ye iloghie jele ghue, sẹ ni mhẹmhẹ Omi Ọgbọ ni mhi rọte iloghie tiemhie. ");
INSERT INTO atgNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Abi iMosisi ọ ke li gẹ ẹnyẹ ni a ri igolu lumhi shi ukpokpo, ni ọ tsua li idane obini ọdagbe ifufu, ighọ a mema li tsua Omi Ọgbọ idane. ");
INSERT INTO atgNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ẹghẹghẹ aghọ, ọnini ọ da mie ọli suọ, ọ ya mhọli agbọ na agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Irari khi Ẹshinẹgba ọ̀ ọ́ nono ingme oyi agbọ gba, lọli ọ rọ rue Omiọli ọni ọmọse ọtuọghuo kpe na agbọ, ẹghẹghẹ aghọ ọnini ọ da mie ọli suọ ne, ọa ya pfua, ama ọ ya mhọli agbọ na agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ẹshinẹgba ọa ghie omi ọli bhale agbọ, ni ọ bhale ya pfa ẹzọ mu ẹgbọ na agbọ, eri ọ ghie ọli, ọ bhale ya mie agbọ pfuese. ");
INSERT INTO atgNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aa ya pfa ẹzọ mu ọni ọ da mie Omi Ẹshinẹgba suọ, ama ọni ọa da mie ọli suọ, a she pfa ẹzọ mu ọli se, itobọ khi ọa mie Omi Ẹshinẹgba ọtuọghuo kpe suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Abi a liẹ sọ oni ẹzọ na. Ákpá o bhale agbọ, ama ẹgbọ e nono alo ebili nẹ, itobọ khi ikanya ebe ẹẹ gbe. ");
INSERT INTO atgNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ọni ọ́ gbe ikanya ebe ọa ya nono ákpá, ọa tigbe ẹ bhale ákpá itobọ khi ikanya eyọli e ya ri udi lasele ini e bhale ákpá. ");
INSERT INTO atgNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama ọni ọ da ri ungmemhi oyi Ẹshinẹgba ni o khi igẹsikia a gbe akanya ne, ọ́ bhale ákpá ashini a te ẹ mẹ ekẹ, ni ikanya eyọli e rọkhasẹ khi odẹ oyi Ẹshinẹgba ọ rọte.” ");
INSERT INTO atgNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ẹlẹ lese iJesu ali eniyẹ odukhokho eyọli e je ekẹ iJudia. Ọ nu wẹ la oobọ ukuku ẹghẹghẹ, ọọ batazi ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","IJọni ọ la Ainoni ni ọa nuẹ shi iSalimu li batazi ẹgbọ, itobọ khi amẹ e lo bu shi aghọ. Ẹgbọ e je aghọ deba li ni ọ batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ẹghẹghẹ aghọ aa mu IJọni shi owa ighumha ne. ");
INSERT INTO atgNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Eniyẹ odukhokho eyi iJọni eghuo e nu ọgbọ iJu ọghuo khakọ shi ingme ikpegbe a ona ugamhi. ");
INSERT INTO atgNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ighọ e le deba iJọni, ẹẹ, “Ọsẹsẹ, u ke yelele ọmọse ọghuo ni u ke batazi, ọni u ngme ingme oyọli epfẹ okẹ iJọdani ẹlẹghọ, ọ li ẹ batazi ẹgbọ, lọli ẹgbọ nya e ke na deba memena.” ");
INSERT INTO atgNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","IJọni ọọ wẹ, “Aa mẹ emhikhọghuo ni ọgbọ ọ mhọli ni ọa khi Ẹshinẹgba ọ rọli na. ");
INSERT INTO atgNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ẹẹ ena a ga suọ abi mhi rọ liẹ khi ọa khi mhẹmhẹ mhi khi Ọmiepfuese, khi eri a li ghie mhẹ ralo na li. ");
INSERT INTO atgNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ọmọse ọni ọ rue ọmueshi ọ́ khi ughuẹ ọmueshi. Eri ọmọle ọni ọmọse ọni ọ rue ọmueshi ọ́ ri esọ shi ekẹ migha ke khẹ ughuẹ ọmueshi. Ọ kha da suọ khi ọmọle ọ da ngme ne, egbe ẹẹ mu ọli. Ighọ egbe e liẹ mu mhẹ memena, ighọ oghẹlẹ oyẹmhẹ o gbo vọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ufumhi oyọli o mema ke nga shiọ, ufumhi oyẹmhẹ ọ̀ ọ ke tiemhi. ");
INSERT INTO atgNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ọni ọ rọte ilimhi tiemhie ọ́ fu dọsẹ ẹgbọ nya. Ọni ọ rọte agbọ ana lasele, ọna agbọ ona ọ khi. Irarighọ, ingmemhi eyi agbọ ana a ke ngme. Ama ọni ọ rọte ilimhi tiemhie ọ́ fu dọsẹ ẹgbọ nya. ");
INSERT INTO atgNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Emini ọ mẹ ali emini ọ suọ ilimhi, ọ gue ẹ yẹ ẹgbọ, ama ọgbọkhọghuo ọa mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ọni ọ da mie emini ọ gueyẹ agbọ suọ ne, eri ọ rọkhasẹ khi igẹsikia Ẹshinẹgba ọ́ ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ọni Ẹshinẹgba ọ́ ghie, ọọ ngme ungmemhi oyi Ẹshinẹgba, itobọ khi eri Ẹshinẹgba ọ ri Ayẹmhẹ oyọli na li gbe ku ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eri Ẹshinẹgba Ita ọ nono ingme oyi Omiọli ọni ọmọse, irarighọ ọ rọ ri emhikpa nga li obọ. ");
INSERT INTO atgNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ọni ọ da mie Omiọli suọ ne, eri ọọ mhọli agbọ na agbọagbọ, ama ọni ọ da kie ọli ne, ọa ya mhọli agbọ, eri ibiselemhi oyi Ẹshinẹgba ọọ deba li agbọagbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ẹgbọ iFarisi e suọ khi ebubu ẹgbọ ẹ deba iJesu, ali khi ọ gbo batazi eniyẹ odukhokho bu dọsẹ iJọni. ");
INSERT INTO atgNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ọa khi iJesu ọ ri obọ oyọli mema batazi ẹgbọ, ama eniyẹ odukhokho eyọli e batazi ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ighọ abi iJesu ọ́ rọ̀ suọ ingme ni ẹgbọ e ngme, ọ rọte ekẹ iJudia vu, ọ mu egbe pfi je iGalili. ");
INSERT INTO atgNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ọ ya rọte odẹ iSameria dọsẹ abi ọ rọ lẹ iGalili. ");
INSERT INTO atgNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ighọ ọ́ bhale ẹoli na lu iSicha ni o la ekẹ iSameria, ni ọa nuẹ shi ekẹ ni iGiekọpu ọ rọ na iJosẹfu omiọli ọni ọmọse. ");
INSERT INTO atgNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aghọ ilijia oni a lu ilijia oyi iGiekọpu o la. O lọsẹ iJesu itobọ okiali ni ọ kia ramhi aghọ, ighọ ọ shitọ epfẹ oni ilijia. Ọguota o lẹsẹ mu ekẹ oni ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ọkpotso ọnge iSameria ọghuo ọ bhale ya a amẹ. IJesu ọọ li, “Diẹ amẹ na mhẹ da.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ẹghẹghẹ aghọ eniyẹ odukhokho eyọli e she lo ifuapfẹ ya dẹ eminale. ");
INSERT INTO atgNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ọni ọkpotso ọnge iSameria ọọ iJesu, “Ọnge iJu u khi, mhẹmhẹ mhi khi ọnge iSameria, sẹ u ke li a liẹ mhi diẹ amẹ nẹ da?” Emini o zẹ ni ọ rọ ngme na khi, ẹgbọ iJu ali ẹgbọ iSameria ẹa ri egbe ẹ ti emhi egbe. ");
INSERT INTO atgNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","IJesu ọ li, “Ini u lẹsẹ isomhopfa ni Ẹshinẹgba ọ́ rọ́ na ọgbọ lọ, ni u gbo rọ lẹsẹ emini ọgbọ ni ọọ mhila ẹ amẹ ọ khi lọ, u kha mhila li ọ ri amẹ nẹ da. Ẹghẹghẹ aghọ ni ọ ri amẹ ni e ri agbọ ọ na ọgbọ nẹ da.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ọni ọkpotso ọ ke mhila iJesu, ọọ, “Ọga, waa mhọli emhi ni a rọ ọ a amẹ, oni ilijia o limhi. Obo u ke te ya mẹ eni amẹ ni e ri agbọ ọ na ọgbọ na a mhẹ da? ");
INSERT INTO atgNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Eri u kẹ liẹ khi yẹyẹ u fu dọsẹ iGiekọpu ita anye kpa?” Lọli ọ tọ oni ilijia ona, ni ọ ri ọli na anye, ni lọli ali imiọli ali elamhakọ eyọli e gbo te ọ da. ");
INSERT INTO atgNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","IJesu ọ ya sọ li ọ, ọ li, “Onini ọ da da amẹ eyi ilijia ena, okiamẹ o gbo ya gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama okiamẹ ọa tigbe kẹ ẹ gbe ọnini ọ da da amẹ ni mhi ya rọ na li da. Itobọ khi amẹ eyẹmhẹ e ya mele okẹ ni ọa ke ya khakha ghue shi ọli elemhi, ni o ya ke sha kule ri agbọ na agbọagbọ na li.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ọni ọkpotso ọọ, “Ọga Kpẹkpẹ ri eni amẹ na mhẹ da ini okiamẹ o khi ke gbo gbe mhẹ, ini mhi khi ke gbo bhale akana ya a amẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","IJesu ọọ, “Ka lu ọmọse ni ọ rue ẹ shi bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ọni ọkpotso ọọ, “Mhia mhọli ọmọse.” IJesu ọọ li, “Igẹsikia lọ, ni u wẹ khi u a mhọli ọmọse, ");
INSERT INTO atgNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","itobọ khi u she kpẹ mhọli emọse oshe ni u kpẹ ngeli na. Ọni u ga nu la memena, ọa khi lọli ọ rẹ shi.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ọni ọkpotso ọọ, “Kie! Ọga, mhi she mẹ ọli khi ọmekẹguele ọyi Ẹshinẹgba u khi. ");
INSERT INTO atgNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ukhomhi ute onana eni e bia anye ẹgbọ iSameria, e kpẹ la ga ugamhi, ama ẹẹ ẹgbọ iJu, ẹ khi iJerusalẹmu awa mema la ke ga ugamhi.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","IJesu ọọ li, “Mie mhẹ suọ khi ẹghẹghẹ ọọ bhale ni u a ke rọ la ukhomhi ute ona, wẹ khi iJerusalẹmu ya ga Ita. ");
INSERT INTO atgNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Emini ẹẹ ẹgbọ iSameria aa lẹsẹ, a ga, ama anye lẹsẹ emini anye ẹ ga itobọ khi obọ oyi iJu imiepfuese o te bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama, ẹghẹghẹ ọọ bhale, oni ẹghẹghẹ o she ramhi ni ẹgbọ eni e ri igẹsikia ẹ ga Ẹshinẹgba e rọ ya ke ga li abi Ayẹmhẹ oyọli o li rọkhasẹ wẹ, e gbo te odẹ igẹsikia ga li, itobọ khi ẹgbọ eni e lighọ ọ ga li, ọọ nònō. ");
INSERT INTO atgNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ayẹmhẹ oyi Ẹshinẹgba ọ khi, eni ẹẹ ga li e mema ya ke ga li abi Ayẹmhẹ o rọkhasẹ wẹ, ali rọte odẹ igẹsikia.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ọni ọkpotso ọọ iJesu, “Mhi lẹsẹ khi Ọmiepfuese (ọni a lu iKirisiti) ọ̀ ọ bhale. Ọ kha bhale, ọ ya khueghie emhikpa gueyẹ anye.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","IJesu ọ sọ ọni ọkpotso ọ, “Lọli mhi khi ni mhi nu ẹ ngme ena.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Abi e kie li ngme, eniyẹ odukhokho eyọli e bhale ya ẹ khi ọ nu ọkpotso o ngme, o ri abọ sha wẹ. Ọngẹwẹ ọa mhila li, “Elọ wa nono?” Wẹkhi e ri e mhila li, “Elọ o zẹ nu u rọ nu ọli ẹ ngme?” ");
INSERT INTO atgNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ighọ ọni ọkpotso ọ zẹ akhe amẹ oyọli obọ shi aghọ, ọ je ifuapfẹ kia gueyẹ ẹgbọ, ọọ liẹ, ");
INSERT INTO atgNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“A bhale ka ghe ọmọse ọghuo ni ọ gue emini mhi ga riẹlẹ ghue nya yẹ mhẹ. Ọmiepfuese ọ fẹ ya khi?” ");
INSERT INTO atgNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ẹgbọ e vẹ gbii te ifuapfẹ bhale ashini iJesu ọ la. ");
INSERT INTO atgNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ẹghẹghẹ aghọ, eniyẹ odukhokho eyọli e ke lema li, “Ọsẹsẹ, waa ke le eminale.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","IJesu ọọ wẹ, “Mhi mhọli eminale ni mhia le ni aa lẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Eniyẹ odukhokho eyọli e mhila egbe wẹ́, “Eri ọgbọkhọghuo ọ̀ kpẹ ri eminale ghi ọ le?” ");
INSERT INTO atgNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","IJesu ọọ wẹ, “Eminale oyẹmhẹ khi, ni mhi riẹlẹ ọghuẹmhẹ oyi ọni ọ ghie mhẹ, ni mhi rọ gbo gbe akanya oyọli pfo. ");
INSERT INTO atgNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aa she ngme ọ khi, ‘Iki ene e ke kpọle ni a rọ ke ya khiẹsẹ emhi ẹkọmhi’? Mhi gue ẹ yẹ ẹ memena, a bino khi emhi ẹkọmhi na ishemhi e she bie ni a khiẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Memena a she ẹ fali eni ẹ khiẹsẹ ishemhi ota akanya, ni e ke khiẹsẹ ikhiẹsẹ ni o ri agbọ na agbọagbọ ọ bhale. Ẹghẹghẹ aghọ ni a bhale ya ẹ khi eni e rọ kọ ali eni ẹ khiẹsẹ e ga kugbe ke ghẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Onana o rọkhasẹ khi emini ẹgbọ ẹ ngme khi igẹsikia o khi, ikhi ungmemhi ni ọọ, ‘Ọni ọ rọ kọ, ọ kiọda shi ọni ọ khiẹsẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Eri mhi ghie ẹ a ka khiẹsẹ emini aa rọ kọ. Ẹgbọ elese e ya gbe ikanya ni e toto rẹwẹ kọ, ama ẹẹ a mẹ eleli ikanya eyẹwẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ebubu ẹgbọ iSameria ni e la oni ẹoli e ri itobọ emini ọni ọkpotso ọghọ ọ́ gueyẹ wẹ mie iJesu suọ, ikhi emini ọ ngme ni ọọ, “A bhale ya ghe ọni ọ gue emini mhi ga riẹlẹ ghue nya yẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Abi eni ẹgbọ iSameria e rọ bhale deba iJesu, e lema li ọ kpẹkpẹ ọ ku shi na ẹwẹ. Ighọ iJesu ọ ku shi na wẹ ogbẹlẹ eva. ");
INSERT INTO atgNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ebubu ẹgbọ elese e gbo mie iJesu suọ itobọ ingmemhi ni ọ nu wẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eni ẹgbọ e kẹ ọni ọkpotso, “Anye she miesuọ memena. Ọa khi itobọ emini u gueyẹ anye tsẹ anye rọ miesuọ, ama itobọ khi anye she suọ emini ọ ngme, anye gbo lẹsẹ egbegbọ khi ọni ọmọse ọna ọ ga khi ọni Ọmiepfuese.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","IJesu ọ la iSameria ramhi ogbẹlẹ eva. Ọ rọte aghọ vu je iGalili. ");
INSERT INTO atgNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ọ she kpẹ liẹ khi ẹgbọ ẹa la ẹoli oyi ọmekẹguele ọyi Ẹshinẹgba a mu ekpẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Abi ọ rọ lo ekẹ iGalili le, ẹgbọ iGalili e mie ọli egbegbọ, itobọ khi ukpẹloe oyẹwẹ iJesu ọ la gbe ikanya ọnyaloa ni ọ la iJerusalẹmu gbe abi e rọ riẹlẹ ukpe iPasova. ");
INSERT INTO atgNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ighọ iJesu ọ gbo nyenẹ egbe je iKena ni o la ekẹ iGalili, ashini ọ ke la ri amẹ mele onyọ a. Ọmọse ọghuo ni ọ gbe akanya igọmẹti ọ la akaghọ, ni omi ọli ọ la iKapanọmu ghua. ");
INSERT INTO atgNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ọni ọmọse ọ suọ khi iJesu ọ rọte ekẹ iJudia ẹ bhale iGalili. Ighọ ọ bhale ya lema iJesu ọ kpẹkpẹ ọ deba luẹ ya nu lọli ri omi luẹ, ni ọa ze ni ọ la akọ eghuli ze. ");
INSERT INTO atgNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","IJesu ọọ, “Ini aa li mẹ ọlẹlẹ ọnyaloa ali ọshabọ, aa ya miesuọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ọni ọmọse ni ọ gbe akanya igọmẹti, ọọ, “Ọnọmhuẹ, kpẹkpẹ bhale neni omimhẹ ọọ ghua.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","IJesu ọọ li, “Ke je khi omiẹ ọ ya ze, ọa ya ghu.” Ọni ọmọse ọ mie emini iJesu ọ gueyẹ ọ suọ, ọ́ọ̀ je. ");
INSERT INTO atgNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Abi ọ rọ je, eni ẹẹ ga li, e bhale ya lona li odẹ, e gueyẹ ọli, “Omiẹ ọ she ze.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ọni ọmọse ọ mhila wẹ, “Ẹghẹghẹ onoghuo ọni ọmọ ọ la ze?” E gueyẹ oli khi, “Agogo oghuo ọguota oodẹ ọni ọmọ ọ la ze.” ");
INSERT INTO atgNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ọni ita ọni ọmọ ọ sato khi ẹghẹghẹ aghọ tee iJesu ọ la gueyẹ luẹ, “Omiẹ ọ ya ze.” Lọli ali apfẹ ọli nya e mie iJesu suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Onana o khi akanya ọnyaloa onuzi-eva ni iJesu ọ gbe abi ọ rọ rọte ekẹ iJudia bhale iGalili. ");
INSERT INTO atgNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Abi a rọ mẹ ingme ena se, iJesu ọ nga obini iJerusalẹmu shi ukpe ni ẹgbọ iJu e riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mena, odẹ unuẹkpẹ ni a lu Isumha o la iJerusalẹmu. Atekẹ ni okẹ o chọchọ shi o la aghọ. IBẹtisaida a ri ẹlẹmhi Iburu ẹẹ lu oni okẹ. Ikuku ikholo ishe ni a ghi e la gasẹ oni okẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ebubu ẹgbọ ni ẹa ze, ikhi ezalo, ali eni ẹa dobẹ ẹ kia ali eni e ghu egbe-a, e yẹshi gasẹ oni okẹ. Eri e migha khẹ ẹghẹghẹ ni a rọ ọ wushe oni okẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Irari khi o mhọli ẹghẹghẹ ni agẹni ọyi Ẹshinẹgba ọ rọọ tiemhi elemhi oni okẹ ya wushe ọli-a. Ẹghẹghẹ aghọ ọnini ọ da kpẹ te ododẹ ya tiemhi oni okẹ ini ọni agẹni ọ lẹsẹ wushe ọli-a se, a rọli ze, ughuamhi onini o tseku yẹsẹ ọli ẹ ngme ");
INSERT INTO atgNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ọmọse ọghuo ọ la aghọ ni o she gba ikpe uye-ali-igbẹlele abi ọ te ẹ ghua. ");
INSERT INTO atgNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","IJesu ọ bhale ya ẹ ọni ọmọse shi aghọ, ọ lẹsẹ khi ọ she la aghọ tẹsẹ. IJesu ọ mhila li, ọọ li, “Wa nono ni u ze?” ");
INSERT INTO atgNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ọni ọmọse ni ọ ghua ọ sọ li ọ, ọọ, “Ọga mhi aa mhọli ọgbọ ni ọ ya kpaghiẹ mhẹ obọ mu mhẹ tiemhi elemhi okẹ. A kha da lẹsẹ wushe okẹ-a se, ni mhi rọ da mu egbe ni mhi tiemhi ne, ọgbọ ọlese ọ kpẹ tiemhi khẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ighọ iJesu ọọ li, “Vule! Rue iya oyẹ mhuẹ obọ ni u ke kia.” ");
INSERT INTO atgNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ighọ ọni ọmọse ọ ze aghọ aghọ, ọ rue iya oyọli, ọọ kia. Ẹlẹghọ o khi Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Enighie eyi iJu ẹẹ ọni ọmọse ni a rọ ze, “Kieee! Amo o khi Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu. Eri u gbe ushi ni Ẹshinẹgba ọ rọ na iMosisi-a. Ighuighuẹ lọ ni u rọ tsua iya oyẹ ẹlẹ iyẹmhẹa.” ");
INSERT INTO atgNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ọni ọmọse ọọ, wẹ, “Ọmọse ni ọ rẹ mhẹ ze ọọ mhẹ, ‘Rue iya o yẹ, u ke kia.’ ” ");
INSERT INTO atgNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","E mhila li, “Ọghuo ọ khi ọni ọgbọ ni ọ gueyẹ u rue ọli ekẹ u ke kia?” ");
INSERT INTO atgNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ọni ọmọse ni a she rọ ze, ọa ke lẹsẹ ọgbọ ni ọ rọ li ze, itobọ khi iJesu ọ she lo ifuabọ ẹgbọ oni ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Abi a rọ mẹ ena se, iJesu ọ bhale ya ẹ ọni ọmọse ni ọ rọ ze elemhi Owa oyi Ẹshinẹgba. IJesu ọọ li. “Ghekhẹ, abi u rọ da ze se ena, khi ke gbo lamhẹ, ini emhi obe olese ni o dọsẹ ana o khi ya li ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ighọ ọni ọmọse ọ vu, ọ ya gueyẹ ẹgbọ iJu khi iJesu ọ rẹ luẹ ze. ");
INSERT INTO atgNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Itobọ khi iJesu ọ gbe ikanya enana Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu, ẹgbọ iJu ee jili ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","IJesu ọ gueyẹ wẹ, ọọ, “Ẹghẹghẹ kpa Itamhẹ ọ rọ gbe akanya, ighọ mhẹmhẹ mhi li liẹ gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Itobọ ungmemhi onana ẹgbọ iJu e rọ mema gba li abi e li ya gbe ọli-a. Ọa khi itobọ khi ọ gbe ushi oyi Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu tsẹ e rọ ye ugbamhi oyọli, ama itobọ khi ọ̀ọ́ khi Ẹshinẹgba ọ khi Ita lọli. Ẹ liẹ khi e li ọ ri onana a liẹ khi otu lọli ali Ẹshinẹgba e khi. ");
INSERT INTO atgNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","IJesu ọ gueyẹ wẹ, ọọ, “Abi o li mhi li gue ọli ẹ yẹ ẹ, khi mhẹmhẹ Omi Ẹshinẹgba mhi aa dobẹ ya riẹlẹ emhikhọghuo ọọtsobọ oyẹmhẹ, ama emini mhi mẹ khi Ẹshinẹgba itamhẹ ọọ riẹlẹ, mhi ya ke riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Irari khi Ita ọ̀ nono ingme oyi omiọli ọ rọ ri emini ọ riẹlẹ nya khasẹ ọli. Ọ ya gbo ri emini e fu dọsẹ ena khasẹ mhẹ ni o ya sha ẹ abọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Abi Ita ọ li guise eni e ghu-a le ni ọ gbo ri agbọ na wẹ, ighọ mhẹmhẹ omi ọli mhi li ya ri agbọ na ọni ọ ghọle mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ita ọa ya ri ọgbọkhọghuo gue ẹzọ, ama omiọli ọ ri afu na, ni ọ rọ ri ẹgbọ gue ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ni a bhale ya ẹ khi ọgbọkpa ọ mu ekpẹ na ọni Ọmọ abi a li mu ekpẹ ẹ na Ita. Ọni ọa da mu ekpẹ na ọni Ọmọ ọa mu ekpẹ na ọni Ita ni o ghie oni Ọmọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Abi o li mhi li gue ọli ẹ yẹ ẹ khi, ọni ọ da suọ ungmemhi oyẹmhẹ ni ọ da gbo mie ọni ọ ghie mhẹ suọ, ọ she mhọli agbọ na agbọagbọ. Ọgbọ ọa ya pfa ẹzọ mu ọli, itobọ khi ọ she rọte odẹ eghuli lasele bhale odẹ agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Abi o li mhi li gue ọli ẹ yẹ ẹ khi ẹghẹghẹ ọọ bhale, oni ẹghẹghẹ na, ni eni e ghu-a e rọ ya suọ ungmemhi oyi Omi Ẹshinẹgba, eni e da suọ ungmemhi oyọli, e ya la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Abi Ita ọ li khi ọni ọ ri agbọ ọ na ọgbọ, ighọ ọ ri oni agbọ na Omiọli, ni ọ li ke rọ na ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ọ she gbo ri afu ni a rọ sọ ẹzọ na Omi ọli, itobọ khi lọli ọ khi Omi Ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Emini mhi gueyẹ ẹ, o khi sha ẹ abọ, itobọ khi ẹghẹghẹ ọọ bhale ni ilimhi nya ni a she rọ tọ e ya suọ uruli oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","E kha da suọ oni uruli ne, e ya guale, e te uji fiẹ lase, eni e da riẹlẹ onete, e ya mhọli agbọ, ama ẹgbọ ebe e ya guale shi epfua. ");
INSERT INTO atgNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Emhikhọghuo ọa la ọ ni mhi dobẹ ya riẹlẹ ọọtsobọ oyẹmhẹ. Abi itamhẹ ọ gueyẹ mhẹ mhi li sọ ẹzọ mhi liẹ sọ ẹzọ. Isọ-ẹzọ oyẹmhẹ oni o migha lọ, itobọ ọa khi abi o ghọle mhẹ mhi liẹ gbe ikanya, ama emini o ghọle Itamhẹ ni ọ ghie mhẹ mhi rọ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Mhi aa ya pfi ọtsẹlẹ na egbe mhẹ. Mhi kha pfi ọtsẹlẹ na egbe mhẹ, ẹgbọ ẹa ya rue oni ọtsẹlẹ shi egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ọgbọẹse ọ la ọ ni ọ pfi ọtsẹlẹ na mhẹ. Mhi lẹsẹ ọtsẹlẹ oyọli ni ọ pfi ẹ na mhẹ khi egbegbọ lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“A she kpẹ ghie usomhi ghi iJọni, ọ pfi ọtsẹlẹ shi ọni ọ khi igẹsikia. ");
INSERT INTO atgNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ama ọa khi eri mhi mu ma ọtsẹlẹ oyi ọgbọ, eri mhi mema gue ọtsẹlẹ ni iJọni ọ pfi na mhẹ yẹ ẹ ini a mhọli imiepfuese. ");
INSERT INTO atgNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Eri iJọni ọ gẹ abi ákpá ni o rọ odẹ ẹ khasẹ ẹ. Ukuku ẹghẹghẹ a lama mie oni ákpá ni o ri egbe mu ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Mhi mhọli ọtsẹlẹ ni ọ fu dọsẹ ọtsẹlẹ ni iJọni ọ pfi na mhẹ. Ika ni Itamhẹ ọ rọ na mhẹ mhi gbe pfo ni mhi kiele ẹ gbe, e pfi ọtsẹlẹ khi Itamhẹ ọ ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Itamhẹ ni ọ ghie mhẹ ọ she pfi ọtsẹlẹ shi ingme oyẹmhẹ. Aa tigbe kpẹ suọ uruli oyọli wẹkhi eri a tigbe kpẹ mẹ abi ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ungmemhi oyọli ọa la elemhi oyẹ ẹ, itobọ khi aa mie ọni ọ ghie suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","À rọshẹka wẹna Ebe-no-pfuasẹ, ni a dabi khi lọli o ya ri agbọ na agbọagbọ na ẹ. Oni ebe ona lọli o gbo pfi ọtsẹlẹ shi ingme oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ama aa nono ni a bhale deba mhẹ, ini a mhọli agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ọa khi ikuẹghiẹ oyi ẹgbọ mhia nono. ");
INSERT INTO atgNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ama mhi lẹsẹ ẹ. Mhi lẹsẹ khi aa mhọli inono oyi Ẹshinẹgba shi udu o yẹ ẹ ");
INSERT INTO atgNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eva oyi Itamhẹ mhi rọ bhale, ama aa mie mhẹ, ọgbọẹse ọ kha ri eva oyọli bhale deba ẹ, a ya mie ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Emini o zẹ khi aa miesuọ khi, ikuẹghiẹ ni o rọte obọ oyi ẹgbọ bhale á nono, ocho ni a kha rọ ke nono oni o rọte obọ oyi Ẹshinẹgba bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“A khi sa khi mhia ya pfa ẹzọ mu ẹ odalo oyi Itamhẹ. Ọni ọ pfa ẹzọ mu ẹ khi iMosisi ni a regbenga. ");
INSERT INTO atgNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ini a mie iMosisi suọ lọ, a kha mie mhẹ suọ itobọ khi ọ kẹkẹ ingme oyẹmhẹ shi ebe. ");
INSERT INTO atgNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama abi aa rọ mie emini ọ kẹkẹ shi ebe suọ, sẹẹ a ke li ya mie emini mhi gueyẹ ẹ suọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Abi a rọ mẹ ingme enana se, iJesu ọ da okẹ oniẹmhi no khishi na lu iGalili lasele je egele ọ. (ITibẹriasi a gbolo ẹ lu oni okẹ.) ");
INSERT INTO atgNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ighọ ebubu ẹgbọ e vẹ deba li gbii, itobọ khi e mẹ ikanya ọnyaloa ni ọ ri eni ẹ ghua ze. ");
INSERT INTO atgNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ighọ iJesu ali eniyẹ odukhokho eyọli e nga ukhomhi ute ya shitọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ẹghẹghẹ aghọ ukpe iPasova oyi iJu o she ramhi. ");
INSERT INTO atgNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Abi iJesu ọ yasẹ alo, ọ mẹ ebubu ẹgbọ ni e bhale deba li, ighọ ọ mhila iFilipu, ọọ li. “Obo awa te ya dẹ eminale ni e ya lo ẹgbọ ena le?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Eri iJesu ọ mema mhila li ni ọ rọ mhẹsẹ ọli bino, itobọ khi ọ she kpẹ lẹsẹ emini lọli ya riẹlẹ shi udu. ");
INSERT INTO atgNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","IFilipu ọ sọ iJesu ọ, ọọ li. “O kha tseku khi ifata iki elele, ẹa ya lo ni a rọ de eminale ni a mẹ ya kemhi pfiẹlẹ-pfiẹlẹ na wẹ tono unu!” ");
INSERT INTO atgNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ọtuọghuo eniyẹ odukhokho eyọli ni a lu Aduru ni ọ khi inyọghuo iSamọ iPita, ọọ li, ");
INSERT INTO atgNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ukuku ọmọ ọ la akana ni ọ tsua irui ibulẹdi ishe ali ifẹlẹ aava. Ashi enana e kia ya ramhi, ni aa kemhi na ẹgbọ ena nya?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","IJesu ọọ li, “A ri eni ẹgbọ shitọ.” Ebuli iyẹyẹ e vọ aghọ egbegbọ. Eni ẹgbọ nya e shitọ, emọse ni e laọ tsẹ, e khi ẹgbọ agbẹlẹ asha ishe. ");
INSERT INTO atgNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","IJesu ọ rue eni ibulẹdi, ọ tsẹ Ẹshinẹgba uwegbe shi ọ, ọ kia kemhi na wẹ. Ọ gbo lighọ rue eni ifẹlẹ, ọ tsẹ Ẹshinẹgba uwegbe shi ọ, ọ kemhi na wẹ. Eni ẹgbọ e le, e khue. ");
INSERT INTO atgNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Abi e rọ le khue se, iJesu ọ gueyẹ eniyẹ odukhokho eyọli, ọọ, “A kia sanọ iku wẹ eni e le kpọle, a khi zẹ ni e li opfu-a.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Abi e ke rọ sanọ wẹ gbili, ighughu igbẹva e vọ iku ibulẹdi ni ẹgbọ e le kpọle. ");
INSERT INTO atgNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Abi eni ẹgbọ e rọ mẹ ikanya ọnyaloa ni iJesu ọ gbe, ẹẹ li, “Igẹsikia lọ khi ọmọse ọna ọ khi ọmekẹguele ni ẹ khi ọ ya bhale agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","IJesu ọ lẹsẹ khi eni ẹgbọ e she gba abi e li ya ri itoto rọli khi oghie, ighọ, lọlighuo ọ te wẹ ifuabọ vu ya nga ukhomhi ute. ");
INSERT INTO atgNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Abi ogbọmhi o rọ mu ekẹ ẹlẹghọ, eniyẹ odukhokho eyọli e tiemhi okẹ ni o khishi. ");
INSERT INTO atgNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Aghọ e te lo ọkọ-okẹ oniẹmhi ni o tsua wẹ da lase je iKapanọmu. Oni ẹghẹghẹ obili o she bi, iJesu ọ́ a nu wẹ la akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ighọ akpekpeli oniẹmhi o tsua rughu wẹ, okẹ o wushe kugbe. ");
INSERT INTO atgNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Abi e rọ kia ukhomhi okẹ ramhi abi imali esẹ ali ene ghọ, e mẹ khi iJesu ọ kia ukhomhi okẹ ẹ bhale. Ulishi oo mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","IJesu ọọ wẹ, “Mhẹmhẹ lọ, ulishi o khi ke mu ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ighọ, o ghọle wẹ ni e tsua iJesu shi elemhi ọkọ-okẹ oniẹmhi. Aghọaghọ oni ọkọ-okẹ oniẹmhi o ramhi egele obini e je. ");
INSERT INTO atgNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ogbeakọlọ eni ebubu ẹgbọ ni e kpẹ la olase egele okẹ ukiẹkiẹ obini o kpọle ni eniyẹ odukhokho e kpẹ te vu. E lẹsẹ khi ọkọ-okẹ oniẹmhi oghuo tsẹ o kpẹ la aghọ, eni ẹgbọ e lẹsẹ khi eniyẹ odukhokho eyọli tsẹ e la oni elemhi ọkọ-okẹ oniẹmhi, ali khi iJesu ọa nu wẹ lo oni ọkọ-okẹ oniẹmhi abi o rọte aghọ vu. ");
INSERT INTO atgNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ikọ-okẹ elese e rọte obini iTibẹriasi bhale epfepfẹ ashini iJesu ọ la ri eminale ni ebubu ẹgbọ le, ni ọ la tsẹ Ẹshinẹgba uwegbe shi eni eminale. ");
INSERT INTO atgNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Abi eni ẹgbọ e mẹ khi iJesu ali eniyẹ odukhokho eyọli ẹa la akaghọ, e dọsẹ lo ikọ-okẹ, ni e tsua wẹ je iKapanọmu, ni e ya nono iJesu gasẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Abi e ke rọ mẹ iJesu ukhomhi egele olase okẹ ukiẹkiẹ obini uzeva, ẹẹ ọli, “Ọsẹsẹ, ẹghẹghẹ onoghuo u rọ ramhi oola?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","IJesu ọ sọ wẹ ọ, ọọ wẹ, “Egbegbi-ingme mhi gue ẹ yẹ ẹ, ọa khi itobọ khi a mẹ ikanya ọnyaloa ni mhi gbe a rọ nono mhẹ, ama itobọ eminale ni mhi rọ na ẹ le khue. ");
INSERT INTO atgNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A khi ke kuẹlẹa nono eminale oyi agbọ ona ni ọọ yese-a, ama a ke kuẹlẹa nono eminale ni ọọ la ọ agbọagbọ ni Omi Ọgbọ ọ rọ ya na ẹ le. Itobọ khi Ẹshinẹgba Ita ọ she ri obọ nga li ukhomhi ọ mie shi ọli ọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ighọ, e ke mhila li, ẹ ọ li, “Elọ anye ya ke li ni anye rọ ya ke gbe akanya ni o ghọle Ẹshinẹgba?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","IJesu ọọ wẹ, “Akanya oyi Ẹshinẹgba khi ni a rọ mie ọni ọ ghie suọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","E gbo mhila li, ẹẹ ọli, “Ikanya ọnyaloa eneghuo u ya riẹlẹ khasẹ ni anye mẹ ni anye rọ ya mie ẹ suọ? Elọ u ya riẹlẹ? ");
INSERT INTO atgNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Eni e bia awa e le eminale ni e rọte idane de kule, Abi Ebe-no-pfuasẹ o ngme khi. ‘Ọ ri eminale ni e te idane de kule na wẹ le.’ ” ");
INSERT INTO atgNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","IJesu ọ sọ wẹ ọ, ọọ. “Egbegbi-ingme mhi gue ẹ yẹ ẹ, a khi iMosisi ọ ri eminale te idane tiemhile na ẹ le, ama Itamhẹ lọlighuo ọ rọte idane ri egbegbi eminale tiemhile ni e le. ");
INSERT INTO atgNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Itobọ khi eminale ni Ẹshinẹgba ọ rọ na ọgbọ, lọli khi ọni ọ rọte iloghie bhale ya ri agbọ na ẹgbọ na agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ẹẹ ọli, “Ọnọmhuẹ, kpẹkpẹ rọte ana vu, ke ri oni eminale ona na anye le.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","IJesu ọ sọ wẹ ọ, ọọ wẹ. “Mhẹmhẹ mhi khi eminale ni o ri agbọ ọ na ọgbọ. Ọnini ọ da bhale deba mhẹ, okiamhi ọa kẹa gbe ọli ghue, ọni ọ da mie mhẹ suọ okiamẹ ọa tigbe ke ya gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama mhi gueyẹ ẹ khi a she mẹ mhẹ, ama aa kie mie mhẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ẹgbọ ni Itamhẹ ọ rọ na mhẹ nya e ya bhale deba mhẹ, ọni ọ da bhale deba mhẹ ne mhia ya khu ọli vu. ");
INSERT INTO atgNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Itobọ khi eri mhi rọte iloghie ilimhi tiemhile ni mhi rọ riẹlẹ ọghuẹmhẹ oyi ọni ọ ghie mhẹ, a khi ni mhi riẹlẹ ọghuẹmhẹ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ọghuẹmhẹ oyi Ita ni ọ ghie mhẹ khi, ni a bhale ya ẹ khi ọkhọghuo eni ọ rọ na mhẹ ọa wa mhẹ-a, ali ni mhi rọ guise wẹ le ri agbọ na wẹ, ogbẹlẹ ni o kpukhokho. ");
INSERT INTO atgNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ọghuẹmhẹ oyi Itamhẹ khi ni ọgbọkpa ni ọ da pfi alo bino omiọli, ni ọ gbo mie ọli suọ ọ ya mhọli agbọ na agbọagbọ. Mhi ya guise ọli le mhi gbo ri agbọ na li ogbẹlẹ ni o kpukhokho.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Itobọ khi iJesu ọọ wẹ, “Mhẹmhẹ mhi khi eminale ni o rọte iloghie ilimhi tiemhile,” ẹgbọ iJu e wọlọ shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ighọ e liẹ, “Ọnana ọa she khi iJesu omi iJosẹfu, ni anye lẹsẹ itali ali inyọli? Sẹẹ ọ ke liẹ liẹ khi, ‘Mhẹmhẹ khi ibulẹdi ni o rọte iloghie ilimhi tiemhile.’ ” ");
INSERT INTO atgNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","IJesu ọ sọ wẹ ọ, ọọ, “A khi ke wọlọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ọgbọkhọghuo ọa la ọ ni ọ ya bhale deba mhẹ ini ọa li khia khi Ita lọlighuo ni ọ ghie mhẹ ọ ti ọ bhale, mhi ya guise ọli le gbo ri agbọ na li ogbẹlẹ ni o kpukhokho. ");
INSERT INTO atgNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ọmekẹguele ọyi Ẹshinẹgba ọghuo ọ kpẹ kẹkẹ ọli shi Ebe-no-pfuasẹ khi, ‘Ẹshinẹgba lọli oghuo ọ ya sẹsẹ ẹgbọ eyọli nya.’ Ọgbọkpa ni ọ da ku esọ-a na Ita, ni ọ rọte obọ oyọli wẹna, ọ ya bhale deba mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Aa mẹ ọgbọ ni ọ mẹ Ẹshinẹgba Ita ghue, ini ọa li khi ọni ọ rọte obọ oyọli bhale. Lọlighuo tsẹ ọ mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Egbegbi ingme mhi gueyẹ ẹ, ọni ọ da mie mhẹ suọ, ọ she mhọli agbọ na agbọagbọ ");
INSERT INTO atgNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mhẹmhẹ mhi khi eminale ni o ri agbọ ọ na ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Eni e bia ẹ, e le eminale ni e rọte idane de kule obini ọdagbe-ifufu, e kie ghuloa. ");
INSERT INTO atgNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama ọna ọ khi eminale ni o rọte iloghie tiemhile, ọni ọ da le ọli, ọa ya ghu. ");
INSERT INTO atgNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mhẹmhẹ mhi khi eminale ni o ri agbọ ọ na ọgbọ, ni o rọte iloghie tiemhile. Ọnini ọ da le eminale ona, ọ ya mhọli agbọ na agbọagbọ. Oni eminale ona, idiegbe oyẹmhẹ lọ, ni mhi ya rọ shi ekẹ na agbọ ni e rọ mhọli agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Abi iJesu ọ rọ ngme ona se, ẹgbọ iJu e nu egbe wẹ khakọ ekhakọ oniẹmhi, ikhi. “Sẹẹ ọmọse ọna ọ li ri idiegbe oyọli na awa ya le?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","IJesu ọọ, “Egbegbi ingme mhi gueyẹ ẹ, ini u a li le idiegbe, ni u gbo da ọlia eyi Omi Ọgbọ, wa ya mhọli agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ọni ọ da le idiegbe oyẹmhẹ ni ọ gbo da ọlia eyẹmhẹ, ọ ya mhọli agbọ na agbọagbọ. Ọ ya mhọli agbọ itobọ khi mhi ya guise ọli le gbo ri agbọ na li ogbẹlẹ ni o kpukhokho. ");
INSERT INTO atgNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Idiegbe oyẹmhẹ khi egbegbi eminale, ọlia eyẹmhẹ e gbo khi egbegbi emini a da. ");
INSERT INTO atgNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ọni ọ da le idiegbe ọyẹmhẹ ni ọ gbo da ọlia eyẹmhẹ, ọ la elemhi oyẹmhẹ, mhẹmhẹ mhi li la elemhi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Abi Ita ni ọ mhọli agbọ ọ́ ghie mhẹ, mhi li mhọli oni agbọ, Ighọ ọni ọ da le idiegbe oyẹmhẹ ọ li ya mhọli agbọ itobọ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Onana lọli khi eminale ni o te iloghie tiemhile, ọa li abi eminale ni e rọte idane de kule ni eni e bia ẹ e kpẹ le, ni e rọ kie ghua. Ama ọni ọ da le idiegbe oyẹmhẹ ọ ya la agbọ agbọagbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Eni ingmemhi ena iJesu ọ ngme abi ọ li la elemhi owa ugamhi ni o la iKapanọmu sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Abi e rọ suọ eni ingmemhi ni iJesu ọọ ngme, ebubu eniyẹ odukhokho eyi iJesu e kẹ, “Osẹsẹ, ena e ma ze dọsẹ e. Ọghuo ọ dobẹ ya mie shi ọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Abi iJesu ọ́ rọ́ lẹsẹ khi eniyẹ odukhokho eyọli ẹ wọlọ, ọọ, “Eri ingmemhi eyẹmhẹ e yese ẹ udu-a? ");
INSERT INTO atgNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sẹẹ a kẹ ẹ ngme ini a mẹ Omi Ọgbọ khi ọ nga iloghie ya shitọ obini ọ kpẹ te tiemhile? ");
INSERT INTO atgNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ayẹmhẹ oyi Ẹshinẹgba ọ ri agbọ ẹẹ na ọgbọ, ama ọgbọ ọa dobẹ ri agbọ ẹẹ na ọgbọ. Ingmemhi ni mhi nu ẹ ngme, obọ oyi Ayẹmhẹ e te ẹẹ bhale, wẹwẹ e ri agbọ ẹẹ na ọgbọ ");
INSERT INTO atgNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Abi o riẹ khi ighọ, eghuo elemhi ẹ, ẹa miesuọ.” Itobọ khi iJesu ọ she kpẹ te ekẹ lẹsẹ eni ẹa mie ọli suọ ali ọni ọ ya ri ọli dẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","IJesu ọ gbo gueyẹ wẹ, ọọ wẹ, “Ona o zẹ khi mhi gueyẹ ẹ khi ọgbọ lọlighuo ọa dobẹ ya bhale deba mhẹ sẹẹ ini Ita ọ ri oni afu na li.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Rọ te ana vu eniyẹ odukhokho eyọli ebubu e mu egbe pfi ẹa ke lama deba li. ");
INSERT INTO atgNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","IJesu ọ mhila eniyẹ odukhokho etuogbava eyọli, ọọ wẹ, “Eri a nono ni a li vu?” ");
INSERT INTO atgNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ISamọ iPita ọ sọ ọli ọ, ọọ li, “Ọnọmhuẹ, ọghuo anye ya lẹ deba? Yẹyẹghuo u mhọli ungmemhi ni e ri agbọ na agbọagbọ ọ na ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Anye miesuọ, anye gbo lẹsẹ khi yẹyẹghuo u khi Ọni ọ pfuasẹ ọyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","IJesu ọ sọ li ọ, ọọ, “Ọa khi ẹẹ ogbava mhi zẹ? Ama ọghuo elemhi ẹ, ọkphaghiẹ ọ khi!” ");
INSERT INTO atgNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","IJudasi ni ọ khi omi iSamọ Isikarọti lọli iJesu ọ la ana ngme ingme oyọli. IJudasi ọ khi ọghuo eniyẹ odukhokho Ogbava ni ọ kie te ikpukhokho ri ọli dẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Abi a rọ mẹ ona se, iJesu ọ kia gasẹ ekẹ iGalili. Ọa lama je ekẹ iJudia itobọ khi eni ẹ mhẹsẹ eyi ẹgbọ iJu e nono abi e li ya gbe ọli a. ");
INSERT INTO atgNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Oni ẹghẹghẹ ukpe okholo oyi iJu o ti bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ighọ Inyọghuo iJesu, ẹẹ ọli, “Wa ke rọte ana lase, ni u ke je obini ekẹ iJudia ni eniyẹ odukhokho eyẹ e mẹ ikanya ọnyaloa ni u wa gbe? ");
INSERT INTO atgNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ọgbọ ni ọ nono ni agbọ e lẹsẹ luẹ ọa ya riẹlẹ ingme sheli. Abi u rọ gbe ikanya ọshabọ ena, ri egbe ẹ khasẹ agbọ gbo ni e lẹsẹ ọni u khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Egbegbọ inyọghuo ọli ẹa mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","IJesu ọọ, “Ẹghẹghẹ oyẹmhẹ ọa ramhi ne, Ẹghẹghẹ ni a mẹ kpa o ti ẹ ẹloe. ");
INSERT INTO atgNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ẹgbọ na agbọ ẹa dobẹ ya biselemhi ẹ, ama ẹẹ biselemhi mhẹ itobọ khi mhia gueyẹ wẹ khi emini ẹẹ riẹlẹ khi ẹa ti. ");
INSERT INTO atgNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","A ke je obini a la riẹlẹ ukpe, mhẹmhẹ mhia vu ne, itobọ khi ẹghẹghẹ oyẹmhẹ ọa ramhi ne.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Abi iJesu ọ ngme ghọ se, ọa ke te iGalili je ashikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Abi inyọghuo ọli e rọ je obini oni ukpe okholo se, ọ li je oobọ, ama ọa zẹ ni ẹgbọ e mẹ luẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Eni e khi enighie eyi ẹgbọ iJu e la aghọ nono iJesu gasẹ, e mhila, “Ighe ọni ọmọse ọghọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ebubu ẹgbọ e la oni igbaa khẹ akọ shi ingme oyi iJesu. Eghuo e liẹ khi iJesu khi ọgbọ ọnete lọ, eghuo ẹ khi eri ọ mema di ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama ọgbọkhọghuo ọa ngme ingme oyọli lase gboo, itobọ khi e na ulishi enighie eyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Abi a rọ li oni ukpe ramhi odẹ, iJesu ọ lo elemhi owa oniẹmhi oyi Ẹshinẹgba, ọ sẹsẹ ẹgbọ ungmemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Enighie eyi iJu ni e suọ oni osẹsẹ, abọ e sha wẹ, ẹ liẹ, “Obo ọmọse ọna ni ọa ye owẹna okhọghuo ne ọ te mhọli ilẹsẹ enana?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","IJesu ọ sọ wẹ ọ, ọ li, “Osẹsẹ ni mhia sẹsẹ, ẹa khi obọ oyẹmhẹ o te bhale, ama obọ oyi ọni ọ ghie mhẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ọni o ghọle ni ọ riẹlẹ ọghuẹmhẹ oyi Ẹshinẹgba ọ ya lẹsẹ khi osẹsẹ ni mhia sẹsẹ ini obọ oyi Ẹshinẹgba o te bhale, abi khi ungmemhi ni o ghọle mhẹ mhia ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ọni ọ da ngme ungmemhi oyi egbọli, ekpẹ ọọ nono ni ẹgbọ e ke mu na lọli, eri-tsẹ khi ọni ọ da gbe akanya ni ọ rọ ti ọni ọ ghie ọ nga ne, lọli o khi ọgbọ ni ọ ti, ọa ga khi ọgbọ ẹgbhọli. ");
INSERT INTO atgNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","IMosisi ọa ri ishi na ẹ? Ama ongẹ ẹ, ọa ri eni ishi gbe. Elọ o ke zẹ khi a nono ni a gbe mhi a?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eni ẹgbọ e sọ ọli ọ, ẹẹ ọli, “Ayẹmhẹ ọkphaghiẹ o la ẹ egbe! Ọghuo ọ nono ni lọli gbe-a?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","IJesu ọọ, “Mhi riẹlẹ ọnyaloa oghuo, o rọ abọ sha ẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ama abi o riẹ khia khi iMosisi ọ ri ushi ishẹlẹ-a na ẹ (ọa mema khi obọ oyi iMosisi o te bhale, ama rọte obọ oyi eni e bia awa, o rọte bhale), eri a kiele ẹ shẹlẹ ọmọ a ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ini a shẹlẹ ọmọ a ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu, ini a khi gbe Ushi oyi iMosisi a, elọ zẹ khi a wola khi mhi rọ ọni ọọ ghua ze ogbẹlẹ iyẹmhẹa? ");
INSERT INTO atgNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A khi ke bino ọgbọ alo gue ọgbọ ẹzọ, a ke sọ ẹzọ shi abi o li.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ẹghẹghẹ aghọ ẹgbọ eghuo ni e la iJerusalẹmu e liẹ, “Ọa khi ọmọse ọna enighie eyi iJu ẹẹ dua abi e li ya gbe a? ");
INSERT INTO atgNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ghe ọli shọ! Ọa khi lọli ọ la ana ngme gbo ena ni ọgbọkhọghuo ọa li ọli emhikhọghuo! Abi khi eri enighie e she lama egbegbọ khi lọli ọ khi iKirisiti? ");
INSERT INTO atgNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Awa aa lẹsẹ obini ọmọse ọna ọ te bhale. Ama ẹghẹghẹ ni iKirisiti ọ rọ ya bhale, ọgbọkhọghuo ọa ya lẹsẹ obini ọ te ya bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Abi iJesu ọ rọ la elemhi Owa oyi Ẹshinẹgba sẹsẹ, ọ tsẹsẹ lasele, ọọ, “A lẹsẹ mhẹ, a gbo lẹsẹ udi-apfẹ ni mhi te lasele, ọa khi mhẹmhẹghuo mhi ghie egbemhẹ bhale akana, ama ọni ọ ghie mhẹ, ọna igẹsikia lọ. Aa lẹsẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ama mhi lẹsẹ ọli itobọ khi obọ oyọli mhi te bhale, lọlighuo ọ ghie mhẹ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Itobọ ona e nono abi e li ya mu ọli. Ama ọgbọ khọghuo ọa khu ọli, ẹa ri obọ ti ọli, itobọ khi ẹghẹghẹ oyọli ọa ramhi ne ");
INSERT INTO atgNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama ebubu ẹgbọ e kie mie ọli suọ, e kẹ, “Ini ọni iKirisiti ọ bhale, ọ ya gbe ikanya ọnyaloa ni e dọsẹ eni ọmọse ọna ọọ gbe ena?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ẹgbọ iFarisi e suọ ingme ni ẹgbọ e ngme shi iJesu egbe. Eni iFarisi ali ighie eyi ekpodalo-ugamhi e ghie eni e la Owa Oyi Ẹshinẹgba ẹ khẹ ekhẹ e ka mu ọli bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","IJesu ọọ li, “Ukuku ẹghẹghẹ mhi mhọli ya nu ẹ la akana, mhi ya nyenẹ egbe je oyi Ita ni ọ ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A ya nono mhẹ, ama aa ya mẹ mhẹ, ashini mhi ya la aa dobẹ ya ramhi aghọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Enighie eyi iJu e nu egbe wẹ ẹ ngme, e liẹ, “Obo ọmọse ọna ọọ lẹ ni ọ rọ liẹ khi awa aa ke ya mẹ luẹ? Eri ọ vu ẹ je ifui ẹoli oyi ẹgbọ iGiriki, obini ẹgbọ eyawa e kia miatsẹku, ni ọ la obọ ke sẹsẹ ẹgbọ iGiriki? ");
INSERT INTO atgNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Elọ iJesu ọ rọ li ngme, abi ọ rẹẹ, a ya nono mhẹ aa mẹ mhẹ, ali obini mhi ya la aa dobẹ ya ramhi aghọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ogbẹlẹ ni o kpukhokho oni ukpe, ni khi khi ogbẹlẹ ni o mu ẹloe nẹ nya, iJesu ọ vule, ọ rue unu leghe, ọọ li, “Ọni okiamẹ ọọ gbe ọ bhale deba mhẹ ya mọ amẹ da. ");
INSERT INTO atgNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ebe-no-pfuasẹ o ngme ghọ khi ọni ọ mie mhẹ suọ khi okẹ ni o mhọli amẹ eni ri agbọ a na ọgbọ o ya rọte agbọ oyọli ke tu lasele.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ayẹmhẹ ni eni mie ọli suọ e ya mie ẹlẹlese, iJesu ọ ri oni amẹ agbọ o na a ngme. Ramhi oni ẹghẹghẹ, oni Ayẹmhẹ ọa bhale ne, itobọ khi aa yasẹ iJesu nga ufumhi oniẹmhi ne. ");
INSERT INTO atgNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Abi eni ẹgbọ e rọ suọ ingmemhi eyọli, ẹgbọ eghuo e ke, “Ọmekẹguele ọmọse ọna ọ khi egbegbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ẹgbọ elese e kẹ, “Lọli ọ khi ọni Ọmiepfuese.” Elese ẹẹ, “Sẹẹ Ọmiepfuese ọ li rọte iGalili lasele? ");
INSERT INTO atgNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ebe-no-pfuasẹ o guele khi ọni Ọmiepfuese, khi unuẹkpẹ oyi iDefidi ọ ya te lasele, iBẹtilẹẹmu a ya bia li shi, ẹoli oyi iDefidi.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ighọ okemhi o ri itobọ iJesu lo wẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ẹgbọ eghuo e nono ni ẹwẹ e mu ọli, ama ọgbọkhọghuo ọa ri obọ ti ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Abi eni e la Owa oyi Ẹshinẹgba oniẹmhi ẹẹ khẹ ekhẹ e rọ je deba iFarisi ali ighie eyi ekpodalo-ugamhi, e mhila wẹ, “Elọ e zẹ khi a mu iJesu bhale ghi anye?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eni ẹgbọ ni ẹ khẹ ekhẹ, e sọ wẹ ọ, e li. “Ọgbọkhọghuo ọa tigbe ngme abi ọmọse ọna ọ liẹ ngme ghue.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","IFarisi e mhila wẹ, ẹẹ, “Eri iJesu ọ she li di ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Aa tigbe mẹ ọgbọ iFarisi ali enighie eyi ẹgbọ iJu ni e mie ọli suọ? ");
INSERT INTO atgNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Iiye! Ama eni ẹgbọ ebubu ena ẹa lẹsẹ Ishi eyi iMosisi. Itobọ ighọ ẹgbọ ni Ẹshinẹgba ọ pfi unu na e khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","INikodemọsi ni ọ li khi ọtuọghuo eni ẹ mhẹsẹ elemhi ẹgbọ iJu ni ọ kpẹ ya mẹ iJesu ẹliyọsẹ, ọ mhila eni ẹgbọ, ọọ, ");
INSERT INTO atgNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ushi oyawa ọa fẹ ngme ghọ a khi pfa ẹzọ umha-guẹli mu ọgbọ ini aa li suọ ẹzọ ni ọ ya gue, ali a gbo guanọ emini ọọ riẹlẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","E kẹ ọ li, “Ọnge iGalili yẹyẹ u li khi? Ka riẹlẹ ebe zẹ egbegbọ khi u ya mẹ khi ọmekẹguele ọọ ya rọte iGalili bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ighọ ọgbọgbọ nya ni ọ la aghọ, ọ je apfẹ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","IJesu ọ je ukhomhi ute oyi ẹẹra olivu. ");
INSERT INTO atgNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ẹluzogbe fiefie, iJesu ọ gbo bhale elemhi Owa oyi Ẹshinẹgba, ebubu ẹgbọ e bhale deba li, ọ shitọ ọ sẹsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Esẹsẹ Ishi eyi iMosisi ali iFarisi e mu ọkpotso ni a gazu okia obọ-obọ bhale ghi iJesu, e rọ ọli migha odalo igbaa. ");
INSERT INTO atgNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ẹẹ iJesu, “Ọsẹsẹ, eri a ga ọkpotso ọna zu okia. ");
INSERT INTO atgNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","IMosisi ọ she kpẹ rọ oni ushi shi ekẹ na anye, khi, ọkpotso ni a da lighọ gazu okia, a ke tono ọli echẹ gbe-a. Elọ u mhuẹ ya ngme shi ona mena?” ");
INSERT INTO atgNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eri e ri ona kpẹ igha khẹ iJesu ini ọ ngme ungmemhi ni e ya rọ ri ingme de ọ. Ighọ iJesu ọ nyẹsẹ egbe, ọ ri umiesobọ ọ kẹkẹ emhi shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Abi e kie li mhila iJesu oni ogbọ ona, iJesu ọ vule, ọọ, “Ọni ọ lẹsẹ khi lọli ẹa kpẹ lamhẹ olamhẹ ghue ọ kpẹ to ọli ẹchẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ọ gbo nyẹsẹ egbe, ọ kẹkẹ emhi shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Abi e rọ suọ ingme ni iJesu ọ ngme, e gbhiaku-a ọtuọghuo-ọghuo rọte eni egbhali. O ke lẹsẹ kpe iJesu ali ọni ọkpotso le shi aghọ ni ọ kie migha. ");
INSERT INTO atgNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","IJesu ọ vule, ọọ ọni ọkpotso, “Ighe eni ẹgbọ ni e pfa ẹzọ mu ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ọni ọkpotso ọọ li, “Mhi aa mẹ ọgbọkhọghuo, Ọnọmhuẹ.” IJesu ọọ li, “Mhẹmhẹ mhi aa li pfa ẹzọ mu ẹ, ama ke lẹ, khi ke gbo lamhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","IJesu ọ gbo nu iFarisi ngme, ọọ wẹ, “Mhẹmhẹ mhi khi ákpá oyi agbọ. Ọni ọ da deba mhẹ ne, ọa ya tigbe kia alo ebili, ọ ya mhọli ákpá ni o ri odẹ agbọ a khasẹ ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Eni iFarisi ẹẹ ọli, “Egbe ẹ u pfi ọtsẹlẹ na, ẹgbọ ẹa ya rue ọtsẹlẹ oyẹ shi igẹsikia.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","IJesu ọọ, “Iiye, ini mhi tseku pfi ọtsẹlẹ na egbemhẹ, egbegbi ọtsẹlẹ lọ ni mhi pfi na egbemhẹ, itobọ khi mhi lẹsẹ obini mhi te bhale ali obini mhia je. Ẹẹ, aa lẹsẹ obini mhi te bhale wẹkhi obini mhia je. ");
INSERT INTO atgNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Abi ẹgbọ na agbọ e li ẹ sọ ẹzọ ẹẹ a liẹ sọ ẹzọ, ama mhẹmhẹ mhi aa pfa ẹzọ mu ọgbọkhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ini mhi ya sọ ẹzọ, egbegbọ ẹzọ mhia sọ, itobọ khi ọa khi mhẹmhẹghuo mhi la. Ita ni ọ ghie mhẹ ọ nu mhẹ la. ");
INSERT INTO atgNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A kẹkẹ ọli shi ebe ushi oyẹẹ khi ọtsẹlẹ oyi ẹgbọ aava, o migha shi egbegbi ọtsẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mhi pfi ọtsẹlẹ na egbe mhẹ, Ita ni ọ ghie mhẹ ọ́ gbo pfi ọtsẹlẹ na mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ẹghẹghẹ ana eni ẹgbọ e mhila li, “Ighe Itẹ?” IJesu ọọ wẹ, “Aa lẹsẹ mhẹ wẹkhi Itamhẹ a lẹsẹ. Ini a lẹsẹ mhẹ lọ, a kha li lẹsẹ Itamhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Elemhi Owa oyi Ẹshinẹgba ọ la ngme eni ingmemhi ena abi ọ kie li sẹsẹ ẹgbọ, epfẹ ashini a ri ikpati ni a ri ikpaghọ isomhopfa a shi ọ migha. Ọgbọkhọghuo ọa kie mu ọli, itobọ khi ẹghẹghẹ oyọli ọa ramhi ne. ");
INSERT INTO atgNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","IJesu ọ gbolo liẹ wẹ, “Mhi ya vu, a ya nono mhẹ, a ya ghu shi olamhẹ oyẹ ẹ. Aa ya dobẹ ramhi obini mhia je.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ẹgbọ iJu ẹẹ, “Ọ́ khi awa aa dobẹ ya a ramhi obini lọli a je. Eri ọ fẹ ri ona a liẹ khi lọli ya gbe egbeọli-a?” ");
INSERT INTO atgNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","IJesu ọọ, “Ẹgbọ ena ọọkẹ-ola a khi, mhẹmhẹ mhi rọte iloghie tiemhie. Ẹgbọ ena agbọ ona ẹẹ a khi, mhẹmhẹ mhia khi ọnge agbọ ona. ");
INSERT INTO atgNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Itobọ ighọ mhi rọ liẹ khi a ya ghu shi olamhẹ oyẹ ẹ ini a da miesuọ khi mhẹmhẹ mhi khi ọni mhiẹ khi mhi khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ẹgbọ iJu e mhila li, “Ọghuo u khi?” IJesu ọọ, Ọni mhi kie kpẹ rọte igbaekẹle liẹ khi mhi khi, mhi khi. ");
INSERT INTO atgNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mhi mhọli ebubu ingme ali ebubu umha-guẹkia ni mhi kha gue shi ẹ egbe. Ọni ọ ghie mhẹ, ọna igẹsikia ọ khi, ingmemhi ni ọ gueyẹ mhẹ, mhi gue ẹ yẹ agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ẹa lẹsẹ khi ingme oyi Ita li iJesu ọ gueyẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","IJesu ọọ, “Ini a da tsua Omi Ọgbọ idane shi ukhomhi ọọra apfida a ya lẹsẹ khi ọni mhiẹ khi mhi khi, mhi khi. Oni ẹghẹghẹ a ya lẹsẹ khi ọa khi itoto oyẹmhẹ mhi rọ riẹlẹ emini mhia riẹlẹ, ama emini Ita ọ sẹsẹ mhẹ, mhia gueyẹ agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ọni ọ ghie mhẹ ọ nu mhẹ la, ọa pfi mhẹ shi ekẹ tsẹ, itobọ khi ọghuẹmhẹ oyọli mhia riẹlẹ ẹghẹghẹ kpa.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ebubu ẹgbọ ni e suọ khi iJesu ọ ngme eni ingmemhi ena e mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","IJesu ọ gueyẹ ẹgbọ iJu ni e mie ọli suọ, ọọ wẹ, “Ini a ri emini mhia sẹsẹ ẹ gba akanya, egbegbi eniyẹ odukhokho eyẹmhẹ a khi. ");
INSERT INTO atgNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A ya lẹsẹ igẹsikia ni o la ingme oyi Ẹshinẹgba, oni igẹsikia o ya rue ẹ ọ le.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eni ẹgbọ iJu ẹẹ ọli, “Imi Aburaamu anye khi, anye aa tigbe kpẹ lo ighumha oyi ọgbọkhọghuo ghue! Elọ u rọ li ẹ ngme, ini u wa liẹ khi anye ya khi eni a rue ighumha lasele?” ");
INSERT INTO atgNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","IJesu ọ sọ wẹ ọ, ọọ, “Egbegbi-ingme mhi gue ẹ yẹ ẹ, khi ọgbọkpa ni ọ da lamhẹ olamhẹ, oghumha ọyi olamhẹ ọ khi ");
INSERT INTO atgNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Oghumha ọa ya la apfẹ oyi ọni ọ mhọli ọli agbọagbọ, ama, omi ọmhuẹ-apfẹ ọọ la apfẹ agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ini Omi Ẹshinẹgba ọ da rue ẹ ighumha le, egbegbọ a rue ẹ ighumha le. ");
INSERT INTO atgNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mhi lẹsẹ khi imi Aburaamu a khi, ama a nono odẹ ni a te ya gbe mhẹ a, itobọ khi aa nono ingme ni mhi gueyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Emini Itamhẹ ọ rọkhasẹ mhẹ mhi gueyẹ ẹ, ama emini Ita ẹ ọ gueyẹ ẹ, a riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ẹ ọ li, “Aburaamu khi Ita anye.” IJesu ọ kẹ, “Ini imi Aburaamu a kha khi egbegbọ lọ, a kha ke riẹlẹ emhi enabi ọ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Abi o ri riẹ khia khi egbegbọ ingmemhi ni Ẹshinẹgba ọ gueyẹ mhẹ mhi gueyẹ ẹ, ama a dua abi a li ya gbe mhẹ a. Aburaamu ọa riẹlẹ emhi eghọghọ! ");
INSERT INTO atgNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Abi a li ena, ighọ ita ẹ ọ kpẹ li.” Ẹẹ ọli, “Anye a khi eniyẹ ni a bia shi ukhomhi okia, Ẹshinẹgba ọ khi Ita ọghuo kpe ni anye mhọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","IJesu ọọ wẹ, “Ini Ẹshinẹgba ọ khi Ita ẹ lọ, a kha nono ingme oyẹmhẹ, itobọ khi obọ oyi Ẹshinẹgba mhi te bhale, ni mhi rọ la akana, ọa khi omhẹsẹ oyẹmhẹ o rẹ mhẹ bhale, ama lọli ọ ghie mhẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Elọ o zẹ khi ingmemhi ni mhi ngme khi ẹa lo ẹ esọ? Itobọ khi aa lama ri egbe mie ingme ni mhi gueyẹ lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eniyẹ eyi Ọkphaghiẹ ni ọ khi ita ẹ a khi, ọghuẹmhẹ oyi ita ẹ a nono ni a ke riẹlẹ. Rọte igbaekẹle ọ te khi ọgbolo-ẹgbọ-a ali ọloẹgbhuẹ. Igẹsikia ọa la li unu. Ingmemhi eyi ọli, ẹgbhọli e khi nya, itobọ khi eri ọọ lo ẹgbhọli abi ọ li. Lọli ọ khi ita ẹgbhọli nya. ");
INSERT INTO atgNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama igẹsikia mhi gueyẹ ẹ khi, itobọ ighọ aa rọ lama mie mhẹ suọ ");
INSERT INTO atgNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ọghuo elemhi ẹ ọ dobẹ ya guele khi mhi mhọli ipfidọ? Ini igẹsikia mhi gueyẹ ẹ, elọ e zẹ khi aa mie mhẹ suọ? ");
INSERT INTO atgNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ọni ọ da khi ọyi Ẹshinẹgba ọ mema ya ri esọ shi ingmemhi eyi Ẹshinẹgba, ama ẹẹ aa khi eyi Ẹshinẹgba lọli o zẹ khi aa lama rọ shi ungmemhi oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Eni ẹgbọ iJu e sọ ọli ọ, “Anye a guẹ ngme ọli mena ni anye rọ yẹ khi ọnge iSameria u khi, ali khi ayẹmhẹ ọkphaghiẹ o la ẹ egbe?” ");
INSERT INTO atgNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","IJesu ọ ke wẹ, “Mhi aa mhọli ayẹmhẹ ọkphaghiẹ. Ama mhi ri ekpẹ na Itamhẹ, ama ẹẹ a ri ẹloe gbe mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aa khi eri mhia nono ni ẹgbọ e ri ufumhi na mhẹ; ama ọni ọọ nono ni a rọ ekpẹ na mhẹ, lọli ọ khi ọni ọ sọ ẹzọ ti ẹloe. ");
INSERT INTO atgNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Egbegbi-ingme mhi gue ẹ yẹ ẹ, ọni ọ da rọ shi osẹsẹ oyẹmhẹ ne, ọa tigbe ya ghu ghue.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ẹgbọ iJu ẹẹ ọli, “Eena anye tigbe lẹsẹ khi ayẹmhẹ ọkphaghiẹ o la ẹ egbe. Aburaamu ọ she ghua, emekẹguele e she ghua, ama wa guele khi ọni ọ da rọ shi osẹsẹ eyẹ ọa tigbe ya ghu ghue. ");
INSERT INTO atgNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ita awa Aburaamu ọ she ghua, eri u kẹ ẹ liẹ khi u fu dọsẹ Aburaamu? Emekẹguele e she li ghua. Ọghuo u fẹ sa khi u khi?” ");
INSERT INTO atgNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","IJesu ọọ li, “Ini mhi ti egbe mhẹ nga, oni itinga o khi afuẹ. Itamhẹ ọni ẹẹ a lu Ẹshinẹgba ọyẹ ẹ, lọli ọ khi ọni ọ ti mhẹ nga. ");
INSERT INTO atgNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ẹẹ a kpẹ tigbe lẹsẹ ọli, ama mhi lẹsẹ ọli. Ini mhiẹ khi mhia lẹsẹ ọli, ọloẹgbhuẹ ọni abi ẹẹ ena mhi kha khi. Ama mhi lẹsẹ ọli, mhi gbo ri ungmemhi oyọli gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Eri o ri egbe mu Aburaamu ita ẹ, abi ọ rọ sa usamhi abi lọli ya li mẹ ogbẹlẹ ibhale oyẹmhẹ. Abi ọ rọ mẹ ibhale oyẹmhẹ, ọ ghẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ẹgbọ iJu ẹẹ ọli, “Waa gbe ikpe egbhuẹva ali igbe ne, wẹkhi eri u mẹ Aburaamu!” ");
INSERT INTO atgNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","IJesu ọ li, “Abi o li mhi li gue ọli yẹ ẹ, neni a bia Aburaamu, mhi she kpẹ laọ!” ");
INSERT INTO atgNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ighọ e sanọ echẹ khi wẹwẹ ya tono ọli, ama, ọ ri egbọli sheli, ọ rọte wẹ ifuabọ wa, ọ ya fiẹ Owa oyi Ẹshinẹgba lase. ");
INSERT INTO atgNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Abi iJesu ọ li kia odẹ lẹ, ọ mẹ ọmọse ọghuo ni a bia shi ọzalo. ");
INSERT INTO atgNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eniyẹ odukhokho eyi iJesu e mhila li, “Ọsẹsẹ, ọghuo ọ lamhẹ ni o zẹ khi a bia ọmọse ọnana ọzalo? Olamhẹ oyọli lọ, abi eyi eni e bia li?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","IJesu ọọ wẹ, “Ọa khi olamhẹ oyọli, wẹkhi eni e bia li, ama eri ọ zẹ alo ni Ẹshinẹgba ọ ri ekpabọ eyọli khasẹ elemhi agbọ oyi ọni ọzalo. ");
INSERT INTO atgNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ogbe o kha da kie laọ ne, awa mema ya ke gbe ikanya eyi ọni ọ ghie mhẹ, ẹlẹ iyọsẹ ọ̀ọ́ bhale ni ọgbọkhọghuo ọa kẹ rọ dobẹ ya gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Abi mhi li la agbọ ena, mhẹmhẹ mhi khi ọni ọ ri ákpá a na ẹgbọ ni e la agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","IJesu ọ ngme ona se, ọ tono etẹ shi ekẹ fọsẹ igbọlọ rọ ma li alo. ");
INSERT INTO atgNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ọ́ọ́ ọni ọmọse, “Ke je okẹ ni a lu iSiloamu ni u ya kpe alo a.” Usomhi ni a ghie, a ri iSiloamu ngme. Ighọ ọni ọmọse ọ li vu ya kpe alo-a. Ọọ jele apfẹ, ọọ mẹ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ẹgbọ eni e ga la kugbe ali ẹgbọ ni e kpẹ mẹ ọli khi ọọ ye omhila, ẹẹ. “Ọnana ọa she khi ọzalo ni ọ kpẹ ẹ shitọ akana mhila?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ẹgbọ eghuo ẹẹ, “Lọli lọ,” ama eghuo ẹẹ, “Iiye o! Ọa khi lọli, eri ọna ọ li khọ li.” Ama ọni ọmọse ọọ, “Mhẹmhẹ o khi guẹguẹguẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","E mhila li, “Sẹ o li kia ni u rọ ke ẹ mẹ ekẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ọ wẹ, “Ọmọse ọghuo ni a lu iJesu ọ fọsẹ igbọlọ ma mhẹ alo, ọ mhẹ mhi je okẹ iSiloamu ya kpe alo a. Ighọ mhi lẹ ya kpe alo-a, lọli mhi rọ ọ mẹ ekẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","E ọli. “Ighe ọli?” Ọọ wẹ, “Mhi aa lẹsẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","E rue ọni ọmọse ni ọ kpẹ zẹ alo ghi ẹgbọ iFarisi. ");
INSERT INTO atgNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu iJesu ọ rọ fọsẹ igbọlọ rọ khueghie ọni ọmọse alo-a. ");
INSERT INTO atgNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eni iFarisi e mhila ọni ọmọse abi o li kia ni ọ rọ ke ẹ mẹ ekẹ. Ọọ wẹ, “IJesu ọ ri igbọlọ ma mhẹ alo, mhi kpe alo-a, mhi rọ ọ mẹ ekẹ memena.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Eghuo eni iFarisi ẹẹ, “Ọmọse ni ọ riẹlẹ ona ọa rọte obọ oyi Ẹshinẹgba bhale, itobọ khi ọa ri ushi oyi ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu gbe akanya.” Ẹgbọ iFarisi elese ẹẹ, “Sẹ ọgbọ olamhẹ ọ li dobẹ ya gbe akanya ọnyaloa onana?” Ingme ona o pfi umhalama shi egbe ọ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ighọ eni ẹgbọ iFarisi e mhila ọni ọmọse, “Yẹyẹ ni iJesu ọ khueghie alo-a, elọ u mẹ ya ngme shi ingme oyọli?” Ọọ wẹ, “Ọmekẹguele lọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Eni ẹgbọ iJu ẹa kie miesuọ khi ọni ọmọse ọ kpẹ zẹ alo, ali khi eri a khueghie ọli alo-a. O ya ramhi ni e rọ ghie ya lu eni e bia ọni ọmọse, ");
INSERT INTO atgNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","E mhila wẹ, “Omi ẹ na? Onana ẹ khi ọzalo a bia li? Sẹ o ke li kia ni ọ rọ ke ẹ mẹ ekẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eni e bia li ẹẹ wẹ, “Anye lẹsẹ khi omi anye lọ, anye gbo lẹsẹ khi ọzalo anye bia li. ");
INSERT INTO atgNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama anye aa lẹsẹ abi ọ li kia ni ọ rọ ke ẹ mẹ ekẹ, anye aa gbo lẹsẹ ọni ọ khueghie ọli alo-a. A mhila li, ọa ke khi ọmọ, ọ dobẹ ya ngme na egbọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Itobọ khi ulishi ẹgbọ iJu o mu eni e bia li e rọ ngme na. Irari khi eni ẹgbọ iJu e she kpẹ ngme ọli shi oghuo, khi ọgbọ ni ọ da mie shi ọ khi iJesu khi iKirisiti, khi eri a khu ọli owa ugamhi ya fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Itobọ ona eni e bia li e rọ liẹ, “Ọ fu tẹ ni ọ ngme ẹ na egbọli, a mhila li.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Utonuzeva, e gbo lu ọmọse ni ọ kpẹ zẹ alo, ẹẹ ọli, “Romhi Ẹshinẹgba khi u ya gue igẹsikia yẹ anye. Itobọ khi anye lẹsẹ khi ọmọse ni ọ rẹ ze khi ọgbọ olamhẹ lọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ọọ wẹ, “Mhi aa lẹsẹ ini ọgbọ olamhẹ lọ, ama emhi oghuo ni mhi lẹsẹ khi, ọzalo mhi kpẹ khi, ama memena mhi she ẹ mẹ ekẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","E mhila li, “Sẹ ọ fẹ li ẹ? Sẹ ọ li khueghie-a ẹ alo a?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ọ́ọ́ wẹ, “Mhi kpẹ gueyẹ ẹ, aa lama shi mhẹ ọ, elọ o ke zẹ ni a rọ ọ nono ni a gbo suọ oni ungmemhi? Eri a li ẹ nono ni a li khi eniyẹ odukhokho eyọli?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","E tsue ọli, ẹẹ ọli, “Ọmọ odukhokho ọyi ọni ọmọse ọna yẹyẹ u khi, ini itse lọ, ama eniyẹ odukhokho eyi iMosisi anye khi. ");
INSERT INTO atgNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anye lẹsẹ khi Ẹshinẹgba ọ nu iMosisi ngme, ama anye aa lẹsẹ obini ọmọse ọna ọ te bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ọni ọmọse ọọ wẹ, “Uza lọ e, ni aa rọ lẹsẹ obini ọ te bhale, ama lọli ọ khueghie mhẹ alo-a. ");
INSERT INTO atgNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Awa lẹsẹ khi Ẹshinẹgba ọa ya suọ iromhi oyi ẹgbọ olamhẹ, ama iromhi oyi eni e ri ekpẹ na li ọọ suọ, ali eni ẹ riẹlẹ emini ọọ nono e riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Rọte igbaekẹle agbọ, aa tigbe suọ ọgbọ ni ọ khueghie ọzalo ni o khia khi ighọ a bia li alo a ghue. ");
INSERT INTO atgNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ini ọa khia khi ọmọse ọna khi obọ oyi Ẹshinẹgba ọ te bhale lọ, ọa kha dobẹ li emhikhọghuo.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","E ọli, “Elemhi olamhẹ a bia ẹ shi, ni a la kuẹlẹ, sẹ u li a nono ni u ke sẹsẹ anye?” Ighọ e khu ọli elemhi owa ugamhi ya lase ọ khi ke gbo bhale ọ ghue. ");
INSERT INTO atgNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Abi iJesu ọ rọ suọ khi a khu ọni ọmọse owa ugamhi ya lase, ọ nono ọli mẹ, ọ mhila li, ọọ li, “U mie Omi Ọgbọ suọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ọni ọmọse ọ li, “Ọga, gueyẹ mhẹ ọni Omi Ọgbọ ọ khi, ni mhi mie ọli suọ!” ");
INSERT INTO atgNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","IJesu ọọ li, “U she mẹ ọli, lọli ọ ga nu ẹ ngme ena.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ọni ọmọse ọ li, “Ọnọmhuẹ mhi miesuọ.” Ọ wugha ọ kuẹghiẹ iJesu. ");
INSERT INTO atgNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","IJesu ọli, “Eri mhi bhale agbọ ona ya gue ẹgbọ ẹzọ, isheghọ ni ẹgbọ ni e zalo e ke mẹ ekẹ, ni eni e kpẹ ẹ mẹ ekẹ ni e zẹ alo.” ");
INSERT INTO atgNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ẹgbọ iFarisi eghuo ni e la akaghọ e suọ ingme ni ọ ngme, e mhila li, “Eri u wẹ khi ezalo anye li khi?” ");
INSERT INTO atgNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","IJesu ọọ wẹ, “Ini ezalo a khi lọ, aa kha mhọli umha-guẹkia, ama abi ẹẹ a ke rọ yẹ khi a mẹ ekẹ na, onana o rọkhasẹ khi ena olamhẹ a khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","IJesu ọọ, “Abi o li mhi li gue ọli ẹ yẹ ẹ, khi, ọgbọ ni ọa da rọte odẹ unuẹkpẹ lo ogba ni a ri isumha shi, ni ọ rọte oboese nga fiala lo ne oghiatọ ali ọni ọ li iko ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ọgbọ ni ọ rọte odẹ unuẹkpẹ lo, lọli ọ khi ọrisumhakia ọyi isumha. ");
INSERT INTO atgNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Eri ọni ọọ khẹ ekhẹ odẹ unuẹkpẹ ọ khueghie odẹ-a na li, eni isumha ẹ suọ uruli oyọli ini ọ lu isumha eyọli eva abi ọ ri eva na wẹ, ọ rẹ wẹ kia lase. ");
INSERT INTO atgNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ọ kha da rẹ wẹwẹ nya fiẹ lase ne, eri ọọ ralo na wẹ, eni isumha ẹẹ deba li, itobọ khi e lẹsẹ uruli oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ẹ a ya deba ọgbọẹse, eri ẹ ri ochoghọ mẹ ọli ya ke na, itobọ khi ẹa lẹsẹ uruli oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Eri iJesu ọ zẹ okhẹ ona rọ nu wẹ ngme, ama ẹa lẹsẹ emini ọ ri ọli ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ighọ iJesu ọ gbo lẹ, “Egbegbi-ingme mhi gue ẹ yẹ ẹ, mhẹmhẹ mhi khi odẹ unuẹkpẹ ni isumha e rọte ẹ lo, ni e gbo te ẹ dọsẹ fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ẹgbọ ni e kpẹ bhale khẹ mhẹ, ighiatọ ali eni ẹ li iko e khi, ama eni isumha ẹa ri esọ shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mhẹmhẹ mhi khi odẹ unuẹkpẹ, ọnini ọ da rọte mhẹmhẹ egbe ne, a ya mie ọli pfuese, ọ ya fiẹ, ọ lo le, ọ mẹ emhi le. ");
INSERT INTO atgNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Eri oghiatọ ọ lẹsẹ bhale ya do, ọ gbe-a, ọ pfuse-a tsẹ, ama mhi she bhale ni a mhọli agbọ, ni a mhọli ọli gba pfo. ");
INSERT INTO atgNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mhẹmhẹ mhi khi ọrisumhakia ọnete. Eri ọrisumhakia ọnete ọ ri agbọ oyọli shi ekẹ ni eni isumha eyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ọni a mie shi akanya irisumhakia ọa khi lọli ọ mhọli eni isumha, ini ọ mẹ khi akpogene ọọ bhale, ọ na tsua isumha kua, ọni akpogene ọ tsua rughu eni isumha, ọ vẹsẹ wẹ kua. ");
INSERT INTO atgNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ọni a mie shi oni akanya irisumhakia ọ na vu, itobọ khi eni isumha ẹa khi eyọli, ali khi ẹa mu ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Mhẹmhẹ mhi khi ọrisumhakia ọnete, mhi lẹsẹ isumha eyẹmhẹ, eni isumha e lẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Abi Ita ọ li lẹsẹ mhẹ, ighọ mhẹmhẹ mhi lẹsẹ ọli, ighọ mhi rọ ri agbọ oyẹmhẹ shi ekẹ na eni isumha. ");
INSERT INTO atgNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Isumha elese e laọ ni ẹa la elemhi ogba oyi isumha ona memena. Mhi mema fiẹ ya wolọ wẹ ma ọ. E ya suọ uruli oyẹmhẹ. E ya kugbe khi ọghuo, e mhọli ọrisumhakia ọghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ita ọ nono ingme oyẹmhẹ, itobọ khi mhi lama ri agbọ oyẹmhẹ shi ekẹ, ni a rọ bhale ya ẹ khi mhi ya gbo mẹ ọli rue. ");
INSERT INTO atgNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aa mẹ ọgbọkhọghuo ni ọ ya dobẹ mie mhẹ agbọ oyẹmhẹ. Mhẹmhẹ ọghuo mhi rọ li shi ekẹ. Mhi mhọli afu ni mhi rọ ọ zẹ ọli obọ, mhi gbo dobẹ ya rue ọli ini o ghọle mhẹ. Omhẹsẹ ona Itamhẹ ọ gueyẹ mhẹ mhi riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Eni ingmemhi enana e gbo pfi umhalama shi egbe ọ na ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ebubu ẹgbọ e liẹ, “Ayẹmhẹ ọkphaghiẹ o la li egbe, ujili ọọ kpha li. Elọ e zẹ khi a ri esọ ọ shi ọli ọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama ẹgbọ elese, ẹẹ ọli, “Ingmemhi enana ẹa dobẹ ya rọte unu oyi ọgbọ ni ọ mhọli ayẹmhẹ ọkphaghiẹ lasele! Ayẹmhẹ ọkphaghiẹ o dobẹ ya khueghie ọzalo alo a?” ");
INSERT INTO atgNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oni ẹghẹghẹ o khi ẹghẹghẹ oruamẹ ni a rọ li ukpe ni a rọ yelele abi a li ri Owa oyi Ẹshinẹgba riẹlẹ nga Ẹshinẹgba obọ. Ẹghẹghẹ ulili lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","IJesu ọ la atukpapfẹ oyi Owa oyi Ẹshinẹgba kia, ashini a lu arakpha oyi iSolomoni. ");
INSERT INTO atgNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ebubu ẹgbọ iJu e le gasẹ ọli, e mhila li, “Ẹlẹ u ri anye ya shi alo ebili ramhi? Khueghie igẹsikia ni o la ọ-a khasẹ anye ini yẹyẹ u khi iKirisiti!” ");
INSERT INTO atgNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","IJesu ọọ wẹ, “Mhi she kpẹ gueyẹ ẹ, ama aa lama mie mhẹ suọ. Ikanya ọnyaloa ni mhi ri itoto oyi Ita a gbe, wẹwẹ e pfi ọtsẹlẹ na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama aa lama miesuọ, itobọ khi aa la elemhi isumha eyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Isumha eyẹmhẹ ẹẹ suọ uruli oyẹmhẹ, mhi lẹsẹ wẹ, ẹẹ deba mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mhi ri agbọ na agbọagbọ na wẹ, ẹa tigbe ya pfua. Aa mẹ ọni ọ ya dobẹ mie mhẹ ẹwẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Itamhẹ ni ọ ri eni isumha nga mhẹ obọ, ọ fu dọsẹ ọgbọkpa. Aa mẹ ọni ọ dobẹ ya mie Ita ẹwẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mhẹmhẹ ali Itamhẹ ọghuo anye khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Eni ẹgbọ iJu e gbo sanọ echẹ ekẹ ẹ tono ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","IJesu ọọ wẹ, “Mhi she gbe ikanya ebubu ukpẹloe oyẹ ẹ, ni o khia khi Itamhẹ ọ́ ri itoto na mhẹ ni mhi rọ gbe wẹ, onoghuo a tono mhẹ echẹ ẹ shi ọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eni ẹgbọ iJu ẹẹ ọli, “Ọa khi itobọ ikanya enete e zẹ ni anye rọ a tono ẹ echẹ, ama, itobọ khi u pfi unu-a! Sẹ yẹyẹ ọgbọ afuẹ-afuẹ u li ẹ ke liẹ khi Ẹshinẹgba u khi?” ");
INSERT INTO atgNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","IJesu ọọ wẹ, “A she kpẹ kẹkẹ ọli shi ebe Ishi eyi iMosisi khi Ẹshinẹgba ọọ liẹ khi, ishinẹgba ẹẹ a khi. ");
INSERT INTO atgNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anye she kpẹ lẹsẹ khi emini ebe onopfuasẹ o ngme khi igẹsikia o khi agbọagbọ, khi ẹgbọ ni a she kpẹ gue ingme oyi Ẹshinẹgba yẹ, Ẹshinẹgba ọ lu ishinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ita ọ she zẹ mhẹ ọda kẹẹ neni ọ ghie mhẹ bhale agbọ, ini mhi ngme ghọ khi Omi Ẹshinẹgba mhi khi, sẹ a ke li a liẹ khi mhi a pfi unu-a? ");
INSERT INTO atgNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","A khi mie mhẹ suọ, ini mhi aa ya riẹlẹ emini Itamhẹ ọ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama ini mhia riẹlẹ wẹ, ini aa rọ tseku mie mhẹ suọ, a mie ikanya ọnyaloa ni mhia gbe suọ, ni a rọ lẹsẹ khi Ita ọ la elemhi oyẹmhẹ, mhẹmhẹ mhi li la elemhi oyi Ita.” ");
INSERT INTO atgNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ighọ e ke gbo li dua ni wẹwẹ e mu iJesu, ama ọ pfue wẹ, ọa zẹ wẹ mu. ");
INSERT INTO atgNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","IJesu ọ da okẹ iJọdani je ukiẹkiẹ ashini iJọni ọ ke la batazi ẹgbọ. Ighọ ọ bie ya la akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ebubu ẹgbọ e bhale akaghọ deba li. Ẹẹ, “IJọni ọa gbe ikanya ọnyaloa okhọghuo, ama ingmemhi ni iJọni ọ ngme shi ingme eyi iJesu, e bhale ya tsẹ nya.” ");
INSERT INTO atgNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ebubu ẹgbọ ni e la akaghọ e mie iJesu suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ọmọse ọghuo ni a lu iLazarọsi ni ọ la ẹoli iBẹtani, Ọ́ọ́ ghua. IBẹtani iMeli ali inyọghuo ọli ni ọkpotso ni a lu iMata e la. ");
INSERT INTO atgNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","IMeli ọna ọ ke ku ituale ni ọ pfie ku Ọnọmhuẹ awẹ, ni ọ gbo ri itsu ni e la li ukhomhi shishi ọ ẹwẹ-a. Lọli ọ khi inyọghuo iLazarọsi ni ọ yẹshi i ghua. ");
INSERT INTO atgNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Inyọghuo ọli eni ikpotso e ghie usomhi ghi iJesu, ẹ ọ li, “Ọnọmhuẹ, ọmọle ẹ ọ̀ọ́ ghua.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Abi iJesu ọ rọ suọ ona, ọọ li, “Ughuamhi ona, ọa ya gbe ọli, ama, eri a mẹ onana ni a mẹ asha khi ufumhi na Ẹshinẹgba ali Omi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","IJesu ọọ nono ingme oyi iMata ali iMeli ali iLazarọsi. ");
INSERT INTO atgNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Abi ọ rọ tseku suọ khi iLazarọsi ọ ghua, ọ kie la ashini ọ la ramhi ogbẹlẹ eva. ");
INSERT INTO atgNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ighọ ọ gueyẹ eniyẹ odukhokho eyọli, ọọ wẹ, “A zẹ ni awa mu egbe pfi je obini ekẹ iJudia.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Eniyẹ odukhokho eyọli ẹ ọ li, “Ọsẹsẹ, odẹ ọ́ a nuẹ ne ni ẹgbọ iJu e rọ ọ nono ni wẹwẹ tono ẹ echẹ. Oobọ wa nono ni u gbo nyenẹ egbe je?” ");
INSERT INTO atgNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","IJesu ọọ wẹ, “Ọa khi te ẹlẹ uzogbe ramhi ẹlẹ ogbọmhi awa rọ ọ mẹ ekẹ? Ọni ọọ kia ini ogbe o la ọ, ọa ya khi owẹ, itobọ khi ákpá oyi agbọ ona ọ rọ ọ mẹ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama ini ọ ri alo ebili ẹ kia, ọ ya khi owẹ, itobọ khi ọa mhọli ákpá ni ọ rọ ọ mẹ ekẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Abi ọ ke rọ ngme onana se, ọ gueyẹ wẹ, ọọ wẹ, “ILazarọsi ọmọle awa ọ she lesẹa, ama mhia lẹ ni mhi ya guise ọli le.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eniyẹ odukhokho eyọli ẹ ọ li, “Abi ọ rọ da lesẹ-a eghọ, ọ ya ze.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Eri IJesu ọ rọ li liẹ khi iLazarọsi ọ she ghua, ama e dabi khi egbegbi olesẹ ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ighọ iJesu ọ guele gboo khi iLazarọsi ọ she ghu-a. ");
INSERT INTO atgNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ama itobọ oyẹ ẹ, egbe ẹ mu mhẹ shi ọ khi mhi aa nu ọli la akaghọ ni ọ rọ ghu-a, ni a rọ mie mhẹ suọ. A zẹ ni awa lẹ deba li. ");
INSERT INTO atgNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ITọmọsi ni a gbo li ẹ lu iDidimọsi, ọọ eniyẹ odukhokho enekpọle, “A zẹ ni awa li deba Ọsẹsẹ je oobọ ni awa nu ọli ghu-a.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ẹghẹghẹ ni iJesu ọ ke rọ ramhi aghọ, ọ bhale ya ẹ khi o she ramhi ẹlẹ ene abi a te ri iLazarọsi tọ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Rọte iBẹtani je iJerusalẹmu ọa ramhi imali eva. ");
INSERT INTO atgNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ighọ ebubu ẹgbọ iJu e she kpẹ bhale iBẹtani ya tsẹ iMeli ali iMata e mu opfu shi inyọghuo wẹ ni ọ ghu-a. ");
INSERT INTO atgNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Abi iMata ọ rọ suọ khi iJesu ọ̀ọ́ bhale, ọ fiẹ lase ya lona li odẹ, ama iMeli ọ la elemhi owa. ");
INSERT INTO atgNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","IMata ọọ iJesu, “Ọnọmhuẹ, ini u la akana lọ, inyọghuo-mhẹ ọa kha ghu. ");
INSERT INTO atgNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama mhi lẹsẹ khi memena khi Ẹshinẹgba ọ ya ri emiemini u wa mhila li nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","IJesu ọọ li, “Inyọghuo ẹ, ọ gbo ya guale bhale agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","IMata ọ li, “Mhi lẹsẹ khi ọ ya te eghuli guale ogbẹlẹ iguale ni o khi ogbẹlẹ ni o kpukhokho.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","IJesu ọọ ọli, “Mhẹmhẹ mhi rọte eghuli ya guise eni e ghu-a le, ni mhi ri agbọ ya na wẹ, ọni ọ da mie mhẹ suọ ọ ya mhọli agbọ, ini ọ tseku ghu-a. ");
INSERT INTO atgNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ọni ọ la agbọ ni ọ da mie mhẹ suọ, ọa tigbe ya ghu-a. U fẹ mie ona suọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ọọ li, “Ii Ọnọmhuẹ! Mhi miesuọ khi yẹyẹ u khi iKirisiti, Omi Ẹshinẹgba ni ọ ya bhale ekẹ agbọ ona.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Abi iMata ọ rọ ngme ghọ se ọ lẹ ya ri ọfiẹ gueyẹ iMeli, ọọ, “Ọsẹsẹ ọ she bhale, ọ̀ọ́ nono ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Abi iMeli ọ rọ suọ ona ọ ti vule, ọ nyanya fiẹ lase je ashini iJesu ọ la. ");
INSERT INTO atgNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","IJesu ọa kie ramhi oni ẹoli ni ọ́ọ̀ je ne, ama ọ kie la ashini ọ kia ramhi ni iMata ọ rọ lona li odẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ẹgbọ iJu ni e la elemhi owa yẹsẹ ọli, e vule deba li je olase abi e rọ mẹ khi ọ ti vule je olase. E dabi khi eri ọ je obini uji ya viẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Abi iMeli ọ rọ ramhi ashini iJesu ọ la ni ọ mẹ ọli, ọ de ya wugha li odalo, ọọ li, “Ọnọmhuẹ, ini u la akana lọ, inyọghuo-mhẹ ọa kha ghu!” ");
INSERT INTO atgNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Abi iJesu ọ mẹ khi lọli ali ẹgbọ iJu ni e kphase ọli khi ee viẹ, o rọ obọ ti iJesu udu, egbe e guọghọ ọli a. ");
INSERT INTO atgNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","IJesu ọ mhila wẹ, ọọ, “Ashi a rọ li tọ?” Ẹ ọ li, “Ọnọmhuẹ bhale ya ghe ọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","IJesu ọ́ viẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ẹgbọ iJu ni e la aghọ, ẹẹ, “A ghe abi ọli nono ingme oyi ọli khẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama eghuo ọ e liẹ, “Lọli ni ọ khueghie ọzalo alo-a ọọ kha dobẹ tsumhi iLazarọsi ini ọ khi ghua?” ");
INSERT INTO atgNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","O gbo ri obọ ti iJesu udu. Ọ kia je obini uji ni o khi irui, ni a gheghele ẹchẹ zuse unu. ");
INSERT INTO atgNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","IJesu ọọ, “A gheghele oni ẹchẹ unu oni uji-a.” IMata inyọghuo ọni ọmọse ni ọ ghu-a ọọ, “Ọnọmhuẹ, ọ shẹ ya ke wẹ! Amo o li ẹlẹ onuzi-ene abi a te rọ li tọ!” ");
INSERT INTO atgNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","IJesu ọ li, “Mhi a kpẹ gueyẹ khi u ya mẹ ufumhi oyi Ẹshinẹgba ini u miesuọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ighọ e gheghele oni ẹchẹ unu uji lase. IJesu ọ yasẹ alo idane, ọ li, “Mhi kphẹmhi nẹ Ita, khi u suọ mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mhi lẹsẹ khi u ma suọ oyẹmhẹ, itobọ oyi ẹgbọ ena mhi rọ ọ ngme ona ni e miesuọ khi yẹyẹ u ghie mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Abi ọ rọ ngme ona se, ọ lu ọli leghe, “ILazarọsi e! Fiẹ lasele!” ");
INSERT INTO atgNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ọni ọmọse ni ọ ghu-a ọ fiẹ lasele, a ri ide olimhi gẹnọ li abọ ali awẹ, ghe eni a rọ ku ọli alo. IJesu ọọ wẹ, “A taghiẹ ọli a ni a zẹ ọli vu.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ebubu ẹgbọ iJu ni e bhale ya tsẹ iMeli ọ mu opfu e mẹ emini iJesu ọ riẹlẹ, e mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama eghuo elemhi wẹ e vu ya gueyẹ ẹgbọ iFarisi emini iJesu ọ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ighie eyi ekpodalo-ugamhi ali iFarisi e ya lu eni ẹ mhẹsẹ ni a lu iSaẹdiri ya nu wẹ mhọli ilegba. E mhila egbewẹ, “Elọ awa li ena? Aa mẹ ikanya ọnyaloa ni ọmọse onana ọ gbe? ");
INSERT INTO atgNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ini awa lina zẹ ọli obọ, ọgbọkpa ọ ya mie ọli suọ. Ẹgbọ iRomu e ya shashe Owa oyi Ẹshinẹgba oyawa-a.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ọmọse ọghuo elemhi wẹ ni a lu iKefasi, ni ọ ralo ugamhi oni ukpe oghọ, ọọ li, “Aa lẹsẹ ingme! ");
INSERT INTO atgNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","A lẹsẹ khi ọgbọ ọtuọghuo ọ kha ghu-a na ẹgbọ kpa, khi o ti dọsẹ ni ẹgbọ nya e pfua?” ");
INSERT INTO atgNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ọa khi ibe eyọli ọ rọ sa ngme oni ungmemhi ona, ama ungmemhi angme-shi-ekẹ ni o ya tsẹ ogbe na akọ, khi iJesu ọ ya ghu-a na ẹgbọ iJu o khi ni ọ ngme, itobọ khi lọli ọ ralo ugamhi oni ukpe. ");
INSERT INTO atgNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ọa khi oyi iJu tsẹ, ama ni ọ sanọ ẹgbọ eyi Ẹshinẹgba ni e kia miatsẹ ku agbọ nya gbili rẹ wẹ khili oghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Rọte ẹlẹ ghọ vu, ẹgbọ iJu e te gba ugbamhi abi wẹwẹ e li ya gbe iJesu a. ");
INSERT INTO atgNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Itobọ ighọ, iJesu ọa ke kia lase gboo iteva oyi ẹgbọ iJu. Ọ ri ochoghọ vu je ẹoli ni a lu Efuremu, ni o ti mama ọdagbe ifufu. Aghọ lọli ali eniyẹ odukhokho eyọli e ke ga la. ");
INSERT INTO atgNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Abi ẹghẹghẹ ukpe iPasova oyi ẹgbọ iJu o rọ ti i bhale, ebubu ẹgbọ e te ẹoli ọdọda je iJerusalẹmu ya ri egbe wẹ khi eni e pfuasẹ, abi ushi oyẹwẹ ọọ e ke li neni oni ukpe o ramhi. ");
INSERT INTO atgNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ee nono iJesu. Abi e rọ la elemhi Owa oyi Ẹshinẹgba, e mhila egbewẹ, e liẹ, “A li sa khi ọ ya bhale? Otsẹ ọa ya bhale shi oni ukpe ona.” ");
INSERT INTO atgNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ama ighie eyi ekpodalo-ugamhi ali iFarisi e she kpẹ mhẹsẹ na eni ẹgbọ, ọni ọ da lẹsẹ obini iJesu ọ la, ọni ọgbọ ọ guele ni wẹwẹ e mẹ asha mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Abi o rọ kpọ ogbẹlẹ esesa oni ukpe iPasova le, iJesu ọ nyenẹ egbe bhale obini iBẹtani, obini iLazarọsi ni iJesu ọ rọte eghuli guise le ọ la. ");
INSERT INTO atgNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","E nye akhe na iJesu, iMata ọ kphanọ eni eminale ghi wẹ. ILazarọsi ọ li nu wẹ shitọ shi ilele oyi eni ekhe. ");
INSERT INTO atgNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ighọ iMeli ọ rue egbegbi akanama ituale ni ọ pfie ni o lolo ghalẹ. Ọ́ ku ọli shi iJesu awẹ, ọ ri itsu ni e la li ukhomhi shishi ọ awẹ a. Upfiemhi oyi oni ituale o kphela vọ oni elemhi owa nya. ");
INSERT INTO atgNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","IJudasi Isikarọti ni ọ khi ọtuọghuo eniyẹ odukhokho eyi iJesu, ni ọ rọte ikpukhokho ya ri iJesu dẹ, ọ mẹ emini iMeli ọ riẹlẹ, ọọ, ");
INSERT INTO atgNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Elọ o zẹ ni aa rọ ri oni ituale dẹ ni a kemhi eni ikpaghọ na eni ẹa mhuẹ? Oni ituale o ghalẹ ramhi ifata ukpe oyi ọgbọ ọghuo.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ọa khi itobọ khi ọ mhọli udu iamhẹ na eni ẹa mhuẹ, ọ rọ ngme ungmemhi ona. Ama itobọ khi oghiatọ ọ khi, ali khi lọli ọ tsua ikpaghọ ọ mhuẹ na wẹ, ni ọ rọte muno epfia. ");
INSERT INTO atgNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ama iJesu ọọ li, “Zẹ ọli obọ riẹlẹ emini o la li udu, eri ọ mu mhẹ egbe ẹ khẹ irọtọ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ẹghẹghẹ kpa ẹgbọ ni ẹa mhuẹ e rọ nu ẹ a la, ama mhẹmhẹ mhia nu ẹ ya la ana ẹghẹghẹ kpa.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ebubu ẹgbọ iJu e suọ khi iJesu ọ la iBẹtani, ighọ e je oobọ. Ọa khi itobọ iJesu tsẹ e rọ je oobọ, ama ni e ba mẹ iLazarọsi ni iJesu ọ te eghuli guise le. ");
INSERT INTO atgNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ighọ ighie eyi ekpodalo-ugamhi ee gba ugbamhi abi e li ya li gbe iLazarọsi a, ");
INSERT INTO atgNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","itobọ khi ingme oyọli o zẹ khi ebubu ẹgbọ iJu e ku ma iJesu ọ, ni e rọ mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ogbeakọlọ ebubu ẹgbọ ni e bhale shi oni ukpe iPasova e suọ khi iJesu ọ̀ọ́ je iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ighọ e yanọ eyamhi mhuẹ abọ fiẹ ya ẹẹ ọli. E kpe okeke gbii, e liẹ, “Tsumhi anye. Awa kuẹghiẹ Ẹshinẹgba. Ẹshinẹgba ọ khivọsẹ na ọni ọ ri eva oyi Ẹshinẹgba Ọnọmhuẹ ẹ bhale! Ẹshinẹgba ọ ka khivọsẹ na oghie iZirẹni!” ");
INSERT INTO atgNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","IJesu ọ mẹ ozele akphẹrẹ. Ọ nga li shitọ abi Ebe-no-pfuasẹ o ngme ọli, ni ọọ, ");
INSERT INTO atgNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ẹgbọ iJerusalẹmu, ulishi o khi mu ẹ! Oghie ọyẹ ẹ ọọ bhale ena, ọ nga ozele akphẹrẹ ẹẹ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eniyẹ odukhokho eyi iJesu ẹa kpẹ rọte ekẹ lẹsẹ obini eni ingme ena e je. Ama abi Ẹshinẹgba ọ rọte eghuli guise iJesu le ni ọ ri ufumhi na li, e rọ tigbe sato khi a kpẹ kẹkẹ eni ingme eyọli ena shi Ebe-no-pfuasẹ, ali khi e ke riẹlẹ eni ingme ena deba li ghue. ");
INSERT INTO atgNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Olele ẹgbọ ni e nu ọli la aghọ abi ọ rọ rọte uji lu iLazarọsi lasele, ni ọ rọ rọte eghuli guise ọli le, e kie kia gueyẹ ẹgbọ abi a li mẹ oni ingme. ");
INSERT INTO atgNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Itobọ khi ebubu ẹgbọ e suọ khi iJesu ọ gbe akanya ọnyaloa ona e rọ vẹ lasele ya mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ighọ ẹgbọ iFarisi e nu egbe wẹ ngme ọli, e liẹ, “Awa aa mhọli emini awa dobẹ ya li ona. Aa mẹ khi ẹgbọ nya e ke ẹ deba li!” ");
INSERT INTO atgNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ẹgbọ iGiriki e li la eni e je iJerusalẹmu ya ga ẹghẹghẹ oni ukpe iPasova. ");
INSERT INTO atgNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","E ya mhila iFilipu (ni ọ khi ọnge iBẹtisaida ni o la iGalili) ẹ ọ li “Ọga, anye ẹ nono ni anye mẹ iJesu, ni anye nu ọli ngme.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","IFilipu ọ vu ya gueyẹ Aduru, wẹwẹ aava e ya gueyẹ iJesu. ");
INSERT INTO atgNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","IJesu ọọ, “Oni ẹghẹghẹ o she ramhi ni a rọ́ ri ufumhi oniẹmhi oyi Omi Ọgbọ ya khasẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Abi o li mhi li gue ọli ẹ yẹ ẹ khi, ini aa li ri ukpamhi ado kọ ekẹ ni o ghua, eri o kie ya li abi o kie kpẹ li. Ini a rọli kọ ekẹ ni o rọ zẹ, o ghua, o fu, o ri imọmhi ni e bu lasele. ");
INSERT INTO atgNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ọnini ọ da nono ingme agbọ oyọli dọsẹ odẹ ne, o ya de ọli obọ a, ama ọni ọa da nono ingme agbọ oyọli elemhi agbọ ona ne, eri ọ kẹsẹ ọ shi ẹ khẹ agbọ na agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ọni ọ nono khi lọli ya ga mhẹ, ọọ mema ya ke deba mhẹ. Ashini mhi da la kpa, ọ li la akaghọ. Itamhẹ ọ mu ekpẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Memena udu oyẹmhẹ ọa ke sheshe. Elọ mhi kẹ ya ngme? ‘Eri mhi kẹ ya liẹ, Ita, khi zẹ ni ẹghẹghẹ ona o bhale deba mhẹ’? Iiye, oni ẹghẹghẹ ni o zẹ ni mhi rọ bhale agbọ na! ");
INSERT INTO atgNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ita ri ufumhi ni o la eva oyẹ khasẹ.” Ighọ Ẹshinẹgba ọ rọte idane ngme lase, ọọ, “Mhi she kpẹ ri ufumhi ni o la eva oyẹmhẹ khasẹ ẹgbọ na agbọ, mhi ya gbo lighọ riẹlẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ebubu ẹgbọ ni e migha epfepfẹ aghọ e suọ khi uruli oyi Ẹshinẹgba o ngme. Ẹgbọ eghuo ẹẹ, “Akphala o de!” Ẹgbọ elese ẹẹ, “Agẹni ọ nu ọli ngme!” ");
INSERT INTO atgNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ama iJesu ọọ, “Ọa khi itobọ oyẹmhẹ uruli oyi Ẹshinẹgba oghọ o rọ ngme ungmemhi oghọ, ama itobọ oyẹ ẹ lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Oni ẹghẹghẹ o she ramhi ni a rọ ri agbọ ẹ gue ẹzọ. Memena, a ya khu Ọkphaghiẹ ọni ọ kpẹ ẹ mhẹsẹ shi agbọ ona ukpẹkhomhi pfia. ");
INSERT INTO atgNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A kha da yasẹ mhẹ nga idane ọọra apfida ne, mhi ya ti ọgbọkpa bhale deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eri ọ ngme ona ni ọ rọ rọkhasẹ wẹ uwali eghuli ni ọ ya ghu. ");
INSERT INTO atgNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Eni ẹgbọ ẹẹ ọli, “Ushi ni Ẹshinẹgba ọ rọ na iMosisi na awa o gue ọli yẹ anye khi agbọagbọ Ọmiepfuese ọ ya la ọ. Sẹẹ u ke li a liẹ khi a mema ya yasẹ Omi Ọgbọ nga idane? Ọghuo ọ khi ọni Omi Ọgbọ ọna?” ");
INSERT INTO atgNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","IJesu ọọ wẹ, “Ákpá o ya la ẹ iteva ukuku ẹghẹghẹ. A ke kia okiali abi oni ákpá o kie la ẹ iteva memena, ini obili o khi ya bi ẹ, itobọ khi ọni ọ la alo ebili ọa lẹsẹ obini ọọ je. ");
INSERT INTO atgNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","A regbenga ọni ákpá ni ọ ri ákpá na ẹ abi ọ kie li la ẹ iteva, ni a li khi ẹgbọ ni e ri imekẹ ẹ na ẹgbọ.” Abi iJesu ọ li ngme ona se, ọ lase wẹ iteva le, je ashini ẹa ke te e mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Abi iJesu ọ tseku gbe ikanya ọnyaloa ena ukpẹloe oyẹwẹ, ẹa kie lama mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Onana o ri emini Azaya ni ọ khi Ọmekẹguele ọ kpẹ ngme shi ekẹ ya tsẹ, ni ọọ, “Ọnọmhuẹ, ọghuo ọ lama mie usomhi oyanye suọ? Ọghuo Ọnọmhuẹ ọ mema khueghie ekpabọ eyọli-a khasẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Onana o zẹ khi ẹa dobẹ miesuọ, itobọ khi Azaya ọ gbo ngme ọli shi ashese khi, ");
INSERT INTO atgNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ẹshinẹgba ọ she tasẹ wẹ alo a, ọ gbo zuse wẹ udu ini e khi mẹ ekẹ ali ini udu oyẹwẹ e khi lẹsẹ ingme. Ini e khi ya mu pfi, ni mhi mẹ asha rẹ wẹ ze.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Eri Azaya ọ ngme ona itobọ khi ọ she kpẹ mẹ ufumhi oyi iJesu, ọ gbo kpẹ ngme ingme oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Abi o tseku khia khi ebubu eni ẹẹ ralo eyi ẹgbọ iJu e mie iJesu suọ ẹghẹghẹ ni a ngme ena, ẹa ngme ọli lasele, itobọ khi e na ulishi oyi iFarisi ini e khi khu ẹwẹ owa ugamhi ya lase. ");
INSERT INTO atgNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Irari khi e nono ikuẹghiẹ ni o rọte obọ oyi ẹgbọ bhale dọsẹ oni o rọte obọ oyi Ẹshinẹgba bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","IJesu ọ tsẹsẹ leghe guele, ọọ, “Ọni ọ da mie mhẹ suọ, ọa khi mhẹmhẹ tsẹ ọ miesuọ, ama ọni ọ ghie mhẹ ọ li miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ọnini ọ da mẹ mhẹ, ọ she li mẹ ọni ọ ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mhi she bhale agbọ ya ri ákpá gẹ na ẹgbọ na agbọ, ini eni e mie mhẹ suọ ọkhọghuo ọ khi la alo ebili. ");
INSERT INTO atgNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ọni ọ suọ ungmemhi oyẹmhẹ ni ọa da rọ shi ọ, ọa khi mhẹmhẹ mhi ya pfa ẹzọ mu ọli. Ọa khi eri mhi bhale ya ri ẹgbọ na agbọ gue ẹzọ, ama eri mhi bhale ya mie agbọ pfuese. ");
INSERT INTO atgNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ọni ọọ pfa ẹzọ mu ọni ọ da kie mhẹ ali ungmemhi oyẹmhẹ, ọ la aghọ. Eni ingmemhi ni mhia ngme e ya pfa ẹzọ mu ọli ogbẹlẹ ni o kpukhokho. ");
INSERT INTO atgNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Itobọ khi ọa khi ungmemhi ọọtsobọ oyẹmhẹ mhia ngme, ama ungmemhi ni Ita ni ọ ghie ọ mhẹsẹ na mhẹ mhi ngme mhia ngme.” ");
INSERT INTO atgNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mhi lẹsẹ khi oni ushi oyi Ẹshinẹgba, o ri agbọ na agbọagbọ ọ na ọgbọ. Irarighọ, eri mhi ẹ ngme emini Ita ọ gueyẹ mhẹ mhi ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Abi o rọ kpọ ẹlẹghuo ukpe iPasova le, iJesu ọ lẹsẹ khi oni ẹghẹghẹ o she ramhi ni ọ rọ ya te agbọ lasele je oyi Ita. Ọ ma kie kpẹ nono ingme oyi ẹgbọ eyọli ni e la agbọ, ọ rọli khasẹ wẹ khi eri lọli nono ingme oyẹwẹ pfo. ");
INSERT INTO atgNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","IJesu ali eniyẹ odukhokho eyọli e la ashini e la le eminale ẹlẹ ogbọmhi. Ọkphaghiẹ ọ she rọli shi udu oyi iJudasi omi iSamọ Isikarọti ọ ka rọ iJesu dẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","IJesu ọ lẹsẹ khi Ita ọ she rọ ekpabọ nga luẹ obọ, ọ lẹsẹ khi obọ oyi Ẹshinẹgba lọli kpẹ te bhale, ali khi obọ oyọli lọli gbo nyenẹ egbe ya je. ");
INSERT INTO atgNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ighọ iJesu ọ rọte ashini ọ shitọ ti vule, ikhi ashini e la le eminale, ọ gueghie awulu ni ọ sọ kpeda, ọ ri ode ni a rọ ọ muno amẹ egbe-a mu oku. ");
INSERT INTO atgNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ighọ ọ ku amẹ shi atalabi, ọ kpe eniyẹ odukhokho eyọli awẹ-a. Ọ rue ode ni a rọ ọ muno amẹ egbe a ni ọ rọ mu oku shishi wẹ amẹ awẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Abi ọ rọ kpe ramhi iSamọ iPita ọ, iPita ọọ, “Kie! Ọnọmhuẹ yẹyẹ u kha ke kpe mhẹ awẹ a?” ");
INSERT INTO atgNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","IJesu ọọ li, “Wa lẹsẹ emini mhia riẹlẹ memena, ama u ya lẹsẹ okhẹse.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ISamọ iPita ọọ, “Ọnọmhuẹ, atsobọ oghọ! Wa ya tigbe kpe mhẹ awẹ-a.” IJesu ọọ, “Ini mhia kpe ẹ awẹ-a, wa aa ke khi ọyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ISamọ iPita ọọ, “O kha khi ighọ, Ọnọmhuẹ, ọa khi awẹ tsẹ u ke lẹsẹ ya kpe mhẹ-a! Ama kpe mhẹ abọ ali ukhomhi-a ma ọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","IJesu ọọ li, “Ọgbọ ni ọ da khuẹ se, ọ she pfuasẹ, ọa khi ọni ọ ke gbo ya khuẹ-a, ama awẹ ọ ke lẹsẹ ẹ yẹghẹ-a. Ẹẹ nya a she pfuasẹ, sẹ ni ọtuọghuo elemhi ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Irari khi iJesu ọ she kpẹ lẹsẹ ọni ọ ya rọ ọli dẹ, lọli o zẹ ni ọ rọ liẹ, “Ẹẹ nya a she pfuasẹ, sẹ ni ọtuọghuo elemhi ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Abi iJesu ọ rọ kpe wẹ awẹ a se, ọ riẹlẹ awulu ni ọ kpẹ gueghie rọ sọ, ọ ya shitọ ashini ọ kpẹ te vule. Ọọ mhila wẹ, “A li lẹsẹ akanya ni mhi gbe na ẹ lẹna?” ");
INSERT INTO atgNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“A lu mhẹ ‘Ọsẹsẹ’ ali ‘Ọnọmhuẹ.’ A ga guẹ ngme, itobọ khi emini mhi khi ghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Memena ni mhẹmhẹ ni mhi khi Ọnọmhuẹ ali Ọsẹsẹ ọyẹẹ mhi she kpe ẹ awẹ-a, ẹẹ a li ke kpe egbe ẹ awẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mhi she ri irọkhọkhọ khasẹ ẹ, ni a li ke riẹlẹ emini mhi riẹlẹ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Egbegbi ingme mhi gueyẹ ẹ, khi ọni ọ ga ọgbọ, ọa ya fu dọsẹ ọni ọọ ga, ọni a aghiusomhi ọa ya fu dọsẹ ọni ọ ghie ọli usomhi. ");
INSERT INTO atgNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Abi a rọ lẹsẹ eni ingme ena eghọ, a ya khivọsẹ na ẹ, ini a rọ li gba akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Aa khi ẹẹ nya mhi nu ẹ ngme. Mhi lẹsẹ abi ingeli eyi eni mhi zẹ e li. Ama, emini Ebe-no-pfuasẹ o ngme, o mema bhale ya tsẹ, ikhi oni ọọ, ‘Ọgbọ ni ọ nu mhẹ ẹ le eminale ọ ya nyenẹ egbe mu okhọli vule shi mhẹ ọ.’ ");
INSERT INTO atgNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Eri mhia gue ona yẹ ẹ shi ekẹ neni a lighọ mẹ ọli, isheghọ ini a lighọ mẹ ghọ, a ya miesuọ khi ‘Mhẹmhẹ mhi khi ọni mhi khi.’ ");
INSERT INTO atgNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Abi o li mhi li gue ọli ẹ yẹ ẹ, khi ọni ọ da kpe abọ mie aghiusomhi ni mhi ghie, mhẹmhẹ ọ li mie, ọni ọ da mie mhẹ, ọni ọ ghie mhẹ ọ li mie.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Abi iJesu ọ rọ ngme ona se, udu ọa ke sheshe ọli, ọ guele gboo, ọọ, “Egbegbi ingme mhi gueyẹ ẹ, khi ọtuọghuo elemhi ẹ, ọ ya rẹmhẹ dẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Eniyẹ odukhokho eyọli e bino egbe alo gasẹ, o lolo sha wẹ abọ ọni iJesu ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ọghuo ọmọ odukhokho ni iJesu ọ mema nono ingme oyọli, ọ shitọ mama iJesu. ");
INSERT INTO atgNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ISamọ iPita ọ rọ ikpialo nu ọni ọmọ odukhokho ngme, ọọ li, “Mhila iJesu, ọghuo ọni ọgbọ ọ fẹ khi elemhi awa.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ighọ ọni ọmọ odukhokho ni ọ shitọ mama iJesu ọ mhila li, ọọ, “Ọnọmhuẹ, ọghuo ọni ọgbọ ọ khi elemhi anye?” ");
INSERT INTO atgNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","IJesu ọ sọ li ọ, ọọ, “Ọni mhi ya ri ibulẹdi ona sọmhi utasa oni awa te ẹ le emhi enana na ne, lọli lọ.” Ighọ ọ sọ oni ibulẹdi elemhi utasa, ọ rọ na iJudasi omi iSamọ Isikarọti. ");
INSERT INTO atgNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Abi iJudasi ọ lẹsẹ mie oni ibulẹdi se, Ọkphaghiẹ ọ lo ọli udu. IJesu ọ gueyẹ ọli, “Nyanya ya riẹlẹ emini wa nono ni u riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ọgbọkhọghuo abi e ga li shitọ ọ le eminale, ọa la ni ọ lẹsẹ emini o zẹ ni iJesu ọ rọ ngme ọli ghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aborọkhia khi iJudasi ọ tsua ikpaghọ ọ mhuẹ na wẹ, eghuo e dabi khi eri iJesu ọ gueyẹ ọli ọ ka dẹ emini e rọ ọ li ukpe iPasova. Elese e dabi khi otsẹ eri ọọ ọ ka somhi eni ẹa mhuẹ opfa. ");
INSERT INTO atgNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Abi iJudasi ọ mie oni ibulẹdi se. Ọ fiẹ lase aghọaghọ. Ẹliyọsẹ o she ramhi. ");
INSERT INTO atgNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Abi iJudasi ọ rọ vu se, iJesu ọọ, “Eena ẹgbọ e ya mẹ ufumhi oyi mhẹmhẹ Omi Ọgbọ, e ya te idiegbe oyi Omi Ọgbọ mẹ ufumhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ini ẹgbọ e rọte idiegbe oyi Omi Ọgbọ mẹ ufumhi oyi Ẹshinẹgba, ẹghẹghẹ aghọ Ẹshinẹgba lọlighuo ọ ya nyanya ri ufumhi oyi Omi Ọgbọ khasẹ ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Eniyẹ eyẹmhẹ, mhia ke nu ẹ ya la akana tẹsẹ. A ya nono mhẹ, aa ke mẹ mhẹ. Mhi gue ona yẹ ẹ memena, abi mhi kpẹ li gueyẹ eni ẹẹ mhẹsẹ eyi ẹgbọ iJu, ni mhiẹ, Aa dobẹ ya ramhi obini mhi-a je.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Memena mhi rọ ushi onogbọ na ẹ: A nono ingme oyi egbe ẹ. Abi mhi li nono ingme oyẹ ẹ, a mema li ya nono ingme oyi egbe ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","A kha da mhọli inono na egbe ẹ ne, ẹgbọ kpa e ya lẹsẹ khi eniyẹ odukhokho eyẹmhẹ a khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ISamọ iPita ọ mhila li, ọọ, “Ọnọmhuẹ, obo wa lẹ?” IJesu ọọ li, “Waa ya dobẹ deba mhẹ je obini mhia je, ama u ya deba mhẹ okhẹse.” ");
INSERT INTO atgNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","IPita ọ mhila li, ọọ “Elọ e zẹ ni mhi aa rọ dobẹ ya deba ẹ? Mhi mu egbe ni agbọ oyẹmhẹ o li opfu-a!” ");
INSERT INTO atgNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","IJesu ọ ke gbo sọ li ọ, “U ga mema mu egbe agbọ oyẹ o rọ liẹ opfu-a na mhẹ? Mhi gueyẹ khi, neni ọkpa ọ gbiẹghẹ, u ya liẹ khi u waa lẹsẹ mhẹ ramhi itesẹ!” ");
INSERT INTO atgNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","IJesu ọ gueyẹ eniyẹ odukhokho eyọli, ọọ wẹ, “Aa khi zẹ ni udu o yese ẹ-a, a mie Ẹshinẹgba suọ, a gbo li mie mhẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Elemhi owa ni a la e kpọku shi apfẹ oyi Itamhẹ. Ini ọa khi ighọ lọ, mhi kha gueyẹ ẹ. Mhia ya vu ni mhi ya mu egbe asha shi ekẹ khẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mhi kha vu ya mu egbe shi ekẹ khẹ ẹ se, mhi ya gbo nyenẹ egbe bhale ya wolọ ẹ ma egbe vu, isheghọ ashini mhi ya la, ni a li nu mhẹ la akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A lẹsẹ odẹ ni a tẹ ẹ je ashini mhia je.” ");
INSERT INTO atgNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ITọmọsi ọọ li, “Ọnọmhuẹ, anye ẹa lẹsẹ obini u wa je. Sẹẹ anye li ya lẹsẹ odẹ je obini u wa je?” ");
INSERT INTO atgNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","IJesu ọọ li, “Mhẹmhẹ mhi khi odẹ ni a te ẹ je obini oyi Ẹshinẹgba. Mhẹmhẹ mhi ri igẹsikia ni o la Ẹshinẹgba a khasẹ. Mhẹmhẹ mhi ri agbọ ọ na ọgbọ. Ọgbọ khọghuo ọa mẹ asha ya je obini oyi Ita ini ọa li rọte obọ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eri a kha lẹsẹ mhẹ lọ, a kha li lẹsẹ ọni Ita. Rọ te memena vu, a she lẹsẹ ọli, a gbo mẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","IFilipu ọọ, “Ọnọmhuẹ, ri ọni Ita khasẹ anye, emini anye lẹsẹ nono ghọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","IJesu ọ sọli ọ, ọ, “IFilipu, mhi she nu ẹ la tẹsẹ, waa kie lẹsẹ ọni mhi khi? Ọni ọ da mẹ mhẹ, ọ she mẹ ọni Ita. Sẹẹ u kiele ẹ liẹ ‘Ri ọni Ita khasẹ anye?’ ");
INSERT INTO atgNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipu, waa miesuọ khi mhi la elemhi oyi Ita, ali khi Ita ọ la elemhi oyẹmhẹ? Ingmemhi ni mhi gueyẹ ẹ nya ẹa khi eyẹmhẹ. Ita ni ọ la mhẹ elemhi ọ ga gbe ikanya ena nya. ");
INSERT INTO atgNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","A mie emini mhi ngme suọ ini mhiẹ khi mhi la elemhi oyi Ita ali khi Ita ọ li la elemhi oyẹmhẹ. Ini aa mie emini mhi ngme suọ, a ri itobọ ikanya ọnyaloa ni mhia gbe miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Egbegbi-ingme mhi gue ẹ yẹ ẹ, ọni ọ da mie mhẹ suọ, ọ ya gbe ikanya enabi mhia gbe. Ọ ya gbe ikanya eni e fu dọsẹ eni abi mhia gbe, itobọ khi mhia je oyi Ita. ");
INSERT INTO atgNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Emini a rọ eva oyẹmhẹ mhila nya mhi ya riẹlẹ ọ, ẹghẹghẹ aghọ ni ọmọ ri ufumhi oyi Ita khasẹ ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Emini a rọ eva oyẹmhẹ mhila nya, mhi ya riẹlẹ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“A kha nono ingme oyẹmhẹ, a ya ri omhẹsẹ oyẹmhẹ gba akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ẹghẹghẹ aghọ, mhi ya lema Ita, ọ ri Ọkpaghiobọ ọlese na ẹ, ni ọ ya nu ẹ la agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Lọli ọ khi Ayẹmhẹ ni o ri igẹsikia ni o la Ẹshinẹgba a khasẹ agbọ. Ẹgbọ na agbọ ẹa dobẹ mie ọli itobọ khi ẹa mẹ ọli wẹkhi eri e lẹsẹ ọli. Ama, ẹẹ ena a lẹsẹ ọli, itobọ khi ọ nu ẹ la, ọ la elemhi oyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Mhia ya zẹ ẹ obọ shi ekẹ abi omi-olimhi, mhi ya gbo nyenẹ egbe bhale deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","O kha dẹnẹ, ẹgbọ na agbọ ẹa kẹ ẹ mẹ mhẹ, ama ẹẹ ena, a ya mẹ mhẹ. Itobọ khi mhi ya gbo la agbọ, a ya li la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ini ogbe ni ẹlẹghọ o ramhi, a ya lẹsẹ khi mhi la elemhi oyi Itamhẹ, khi ẹẹ a la elemhi oyẹmhẹ, abi mhi li la elemhi oyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ọni ọ mie ishi eyẹmhẹ ni ọ ri ẹwẹ gbe akanya, ọ nono ingme oyẹmhẹ. Itamhẹ ọ ya nono ingme oyi ọni ọda nono ingme oyẹmhẹ, mhi ya li nono ingme oyi ọni ọgbọ, mhi ri egbe mhẹ khasẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","IJudasi (ọa khi ọni a lu Isikarọti) ọọ, “Ọnọmhuẹ, elọ o zẹ khi u fẹ ya ri egbe ẹ khasẹ anye tsẹ, ni u wa rọ ya ri egbe ẹ khasẹ agbọ kpa?” ");
INSERT INTO atgNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","IJesu ọ sọ li ọ, ọọ, “Ọni ọ da nono ingme oyẹmhẹ, ọ ya ri osẹsẹ oyẹmhẹ gbe akanya. Itamhẹ ọ ya nono ingme oyi ọli, mhẹmhẹ ali Itamhẹ, anye bhale ya nu ọli la. ");
INSERT INTO atgNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ọni ọa da nono ingme oyẹmhẹ, ọa rọ osẹsẹ oyẹmhẹ ya gbe akanya. Eni osẹsẹ ni mhia sẹsẹ ẹ, ẹa khi eyẹ mhẹ, ama obọ oyi Itamhẹ ni ọ ghie mhẹ e te bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mhi she gue ena yẹ ẹ, abi mhi kie li nu ẹ la. ");
INSERT INTO atgNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama oni, Ayẹmhẹ-nọ-pfuasẹ ikhi Ọkpaghiobọ, ni Ita ọ ya rọ eva oyẹmhẹ rọ ghi ẹ, ọ ya sẹsẹ ẹ emhikpa. Ọ ya gbo rẹ ẹ yelele emhikpa ni mhi gueyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mhi zẹ ẹ obọ shi agbọ ona shi opfọmhẹ, mhi ri opfọmhẹ oyẹmhẹ na ẹ. Ọa khi oni abi ẹgbọ na agbọ e rọ ọ na ọgbọ mhi rọ na ẹ. A khi zẹ udu yese ẹa, ali a khi zẹ ni ulishi o mu ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“A suọ abi mhi rọ gueyẹ ẹ khi mhi ya rọte iteva oyẹẹ vu, khi mhi ya gbo bhale deba ẹ. Ini a nono ingme oyẹmhẹ lọ, a kha ke ghẹlẹ khi mhia je oyi Itamhẹ, irari khi lọli ọ fu dọsẹ mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mhi she gue ingme ena yẹ ẹ shi ekẹ neni a mẹ wẹ, isheghọ ini a da kie lighọ mẹ wẹ, a mie mhẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mhia kẹ nu ẹ ngme tẹsẹ, itobọ khi ọkphaghiẹ ni ọ kpẹ mhẹsẹ shi agbọ ona, ọọ bhale. Ọa mhọli ekpabọ shi agbọ oyẹmhẹ, ");
INSERT INTO atgNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ama ẹgbọ na agbọ e mema ya lẹsẹ khi mhi ma nono ingme oyi Ita, ali khi emini Itamhẹ ọ mhẹsẹ na mhẹ mhi riẹlẹ, mhia riẹlẹ tee. “A bhale ni awa vu ana le. ");
INSERT INTO atgNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mhẹmhẹ mhi li abi oni upfonu ni ọ mọ umọmhi onete, Itamhẹ ọ́ riẹlẹ ẹ shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lọli ọọ kanọ uguabọ oyẹmhẹ ni ọa ya mọ umọmhi a. Ọọ riẹlẹ uguabọ oyẹmhẹ ni ọọ mọ umọmhi, ni o gbo mọ imọmhi eni e bu. ");
INSERT INTO atgNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ungmemhi ni mhi she nu ẹ ngme o she riẹlẹ ẹ ti ni a rọ dobẹ mọ imọmhi enete. ");
INSERT INTO atgNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","A toma mhẹ idiegbe, mhẹmhẹ mhi ya toma ẹ idiegbe. Uguabọ ọọra okhọghuo ọa dobẹ ya mọ umọmhi ọọtsobọ oyọli, o mema ya to ma idiegbe ọọra. U kẹ neta khi eri a dobẹ ya riẹlẹ eminete ini aa toma mhẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mhẹmhẹ mhi khi ọọra upfonu, ẹẹ a li abi iguabọ. Ini u toma mhẹ egbe ni mhi rọ li toma ẹ egbe, u ya mọ imọmhi eni e bu. Ini a rọ obọ rue mhẹ ọ le, aa dobẹ ya riẹlẹ emhikhọghuo onete. ");
INSERT INTO atgNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ini u waa da toma mhẹ egbe ne, eri a ya khi ẹ pfia. Eri u ya li abi iguabọ ekhakha ni, a ti ẹ ma ri erali tosẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ini u toma mhẹ egbe, ni ingmemhi eyẹmhẹ e rọ la elemhi oyẹ, emiemini o ghọle ẹ kpa wa mhila, a ri ọli nẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Eminete ni a riẹlẹ o ri ufumhi ghi Itamhẹ. Ona o rọkhasẹ khi eniyẹ odukhokho eyẹmhẹ a khi. ");
INSERT INTO atgNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Abi Ita ọ nono ingme oyẹmhẹ, ighọ mhi li nono ingme oyẹẹ. A la elemhi inono oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ini a rọ ishi eyẹmhẹ gbe akanya, a ya la inono oyẹmhẹ, abi mhi li ri ishi eyi Itamhẹ gbe akanya ni mhi li la inono oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Eri mhi gue ona yẹ ẹ ni oghẹlẹ oyẹmhẹ o vọ ẹ udu, ni oni oghẹlẹ oyẹ ẹ o gba pfo. ");
INSERT INTO atgNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ushi ni mhi rọ na ẹ khi, a nono ingme oyi egbe ẹ, abi mhi nono ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aa mẹ inono olese ni o fu dọsẹ oni ọgbọ ọ rọ ghu-a na emọle ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Emọle mhẹ a khi ini a da ri ishi eyẹmhẹ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mhi aa kẹ lu ẹ eni ẹ ga mhẹ, itobọ khi ọni ọ ga ọgbọ ọa lẹsẹ akanya ni ọga ọyọli ọ gbe. Ochoghọ, emọle mhi ke ẹ lu ẹ, itobọ emini mhi rọte obọ oyi Itamhẹ wẹna nya mhi gueyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ọa khi ẹẹ a zẹ mhẹ, mhẹmhẹ mhi zẹ ẹ ni mhi ri akanya na ẹ, a ka gbe ikanya enete ni ikanya eyẹ ẹ e migha. Isheghọ Ita ọ ya rọ emini a rọ eva oyẹmhẹ mhila nya na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ushi oyẹmhẹ ni mhi shi na ẹ khi, a nono ingme oyi egbe ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ini ẹgbọ na agbọ ẹ biselemhi ẹ, a sato khi ighọ e kpẹ li biselemhi mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ini a khi eyi ẹgbọ na agbọ lọ, e kha nono ingme oyẹ ẹ abi enayẹwẹ. Abi o ke li memena khi, aa ke khi eyi ẹgbọ na agbọ itobọ khi mhi she rọte elemhi agbọ zẹ ẹ, lọli o zẹ khi ẹgbọ na agbọ e rọ́ biselemhi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","A sato ingme ni mhi gueyẹ ẹ, ‘Ọni ọọ ga ọgbọ ọa fu ẹ dọsẹ ọga ọyọli.’ Ini e kpẹ mu okhọli vule shi mẹ ọ ghue, e ya mu okhọli vule shi ẹ ọ. Ama ini e rọ osẹsẹ ni mhi sẹsẹ gbe akanya, e ya rọ osẹsẹ oyẹ ẹ li gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","E ya lina ngeli deba ẹ itobọ khi enayẹmhẹ a khi, ali itobọ khi ẹa lẹsẹ ọni ọ ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ini mhi aa bhale ya nu wẹ ngme lọ, ẹa kha mhọli umha-guẹkia oyi olamhẹ. Ama ẹa ke mhọli emini e gue ọli ya nga egbe khi o rẹwẹ a lamhẹ olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ọni ọ da biselemhi mhẹ, Itamhẹ ọ li liẹ biselemhi. ");
INSERT INTO atgNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ini mhi aa la akpẹwẹ gbe ikanya ni ọgbọẹse ọa dobẹ gbe ghue lọ, ẹa kha mhọli umha-guẹkia oyi olamhẹ. Ama memena e she mẹ eni ikanya ọnyaloa, ama e kiele ẹ biselemhi mhẹ ali Itamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ama ona o zẹ ni emini a kẹkẹ shi ebe ushi oyẹwẹ o rọ bhale ya tsẹ, oni ọ́ khi, ‘Afuẹ ẹ biselemhi mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ini ọni Ọkpaghiobọ ọ bhale, ọni mhi rọte obọ oyi Itamhẹ ya ghie ghi ẹ, lọli ọ khi Ayẹmhẹ nọ ọ ri igẹsikia ni o la Ita a khasẹ, ọ ya pfi ọtsẹlẹ shi ingme oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ẹẹ a ya li mema pfi ọtsẹlẹ na mhẹ, itobọ khi rọte igbaekẹle a te nu mhẹ la. ");
INSERT INTO atgNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Eri mhi gue ona a yẹ ẹ ini a khi tsua irudunga pfia. ");
INSERT INTO atgNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ẹgbọ e ya khu ẹ owa ugamhi fiẹ lase, ẹghẹghẹ o ga ya ramhi ni ọgbọ ọ kha gbe ọngẹẹ a, ọ dabi khi eri lọli ẹ ga Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","E ya riẹlẹ eni emhi ena deba ẹ, itobọ khi ẹa lẹsẹ Ita, wẹkhi mhẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ama, eri mhi gue ona yẹ ẹ, ini oni ẹghẹghẹ o ramhi, a ya sato khi mhi kpẹ tse agua yẹ ẹ. Itobọ khi mhi kie nu ẹ la mhi aa rọ kpẹ gue ingme ena yẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Memena, mhia lẹ deba ọni ọ ghie mhẹ, ama ọngẹẹ ọa kie mhila mhẹ, ‘Obo wa je?’ ");
INSERT INTO atgNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Itobọ khi mhi gue ingme ena yẹ ẹ, udu oyẹẹ o she yese-a. ");
INSERT INTO atgNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama igẹsikia mhi gueyẹ ẹ, ni o rọ ti ẹ egbe mhi rọ rọte ẹ iteva a vu. Itobọ khi ini mhi aa vu, ọni Ọkpaghiobọ ọa ya bhale. Ama ini mhi da vu mhi ya ghie ọli ghi ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ini Ọ da bhale, Ọ ya rẹwẹ lẹsẹ umha-guẹkia ni o la ingme olamhẹ, ọ gbo rẹwẹ li lẹsẹ ipfuasẹ oyi Ẹshinẹgba ali isọ-ẹzọ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ọ ya rẹwẹ lẹsẹ khi umha-guẹkia ni o la olamhẹ o khi, umha mie mhẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ọ ya rẹwẹ lẹsẹ khi e ya mhọli ipfuasẹ oyi Ẹshinẹgba, itobọ khi mhi je oyi Ita ni aa ke te tigbe ya mẹ mhẹ ");
INSERT INTO atgNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ọ ya rẹwẹ lẹsẹ emini isọ-ẹzọ oyi Ẹshinẹgba o khi. Itobọ khi a she pfa ẹzọ mu ọkphaghiẹ ọni ọ mhẹsẹ ẹ shi agbọ ona. ");
INSERT INTO atgNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mhi mhọli emini e bububu ni mhi kha gbo gueyẹ ẹ, ama e bu dọsẹ ni a dobẹ ya mie. ");
INSERT INTO atgNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama ini Ayẹmhẹ ni ọ ri igẹsikia a khasẹ ọ da bhale, ọ ya ri igẹsikia ni o la ingme oyi Ẹshinẹgba nya khasẹ ẹ. Ọa ya ngme ungmemhi ọọtsobọ oyọli, ama emini ọ suọ ọ ya ke ngme. Ọ gbo gueyẹ ẹ ingme ni a ya mẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mhẹmhẹ ọ ya ke ti nga, itobọ khi ọ ya mie mhẹ ungmemhi ni mhi ngme gueyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Emini Itamhẹ ọ mhuẹ nya, eyẹmhẹ lọ, lọli o zẹ khi mhi kpẹ gueyẹ ẹ khi emini mhi rọ na Ayẹmhẹ-nọ-pfuasẹ, ọ ya gueyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“O kha dẹnẹ, aa kẹ mẹ mhẹ, o kha ke gbo dẹnẹ a gbo mẹ mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Eniyẹ odukhokho eghuo ee mhila egbewẹ, “Elọ ọ ri ona a ngme, ni ọọ liẹ awa khi, o kha dẹnẹ khi awa aa ke a mẹ luẹ, ali khi o kha ke gbo dẹnẹ khi awa gbo lo ya mẹ luẹ? Ọ gbolo ẹ, ‘Itobọ khi mhi ya je obini oyi Ita.’ ");
INSERT INTO atgNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Elọ ọ ri ‘O kha dẹnẹ’ ngme? Awa aa lẹsẹ ingme ni ọ rọ ọli ngme!” E kie lina mhila egbewẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","IJesu ọ́ she lẹsẹ khi ẹẹ nono ni e mhila luẹ oni ungmemhi ona, ọ mhila wẹ, “Eri a mhila egbe ẹ abi mhi ri oni ungmemhi ngme, ni mhi rọ liẹ, ‘O kha dẹnẹ aa ke ya mẹ mhẹ ali khi o kha gbo dẹnẹ a ya mẹ mhẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Egbegbi ingme mhi gue ẹ yẹ ẹ, a ya viẹ, a viẹ oya. Ama ẹgbọ na agbọ e ya ke ghẹlẹ, ẹẹ a mhuẹ iyeseudu-a, oni iyeseudu-a o ya mele oghẹlẹ-a na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ini ọkpotso ọ ya bia, udu o yese ọli a itobọ khi ẹghẹghẹ osue o she bhale, ama ini ọ bia ọni ọmọ se, ọọ ghẹlẹ, ọ yele osue ni ọ mẹ a. Irari khi ọọ ghẹlẹ khi lọli bia ọmọ shi agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ighọ o li li ẹ egbe, memena udu o yese ẹ a, ama mhi ya gbo mẹ ẹ. Ẹghẹghẹ aghọ oghẹlẹ o vọ ẹ udu, oghẹlẹ ni ọgbọ ọa dobẹ ya mie. ");
INSERT INTO atgNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ini oni ogbẹlẹ o ramhi, aa kẹ ẹ mhila mhẹ emhikhọghuo. Mhi gue igẹsikia a yẹ ẹ khi Itamhẹ ọ ya rọ emini a ri eva oyẹmhẹ mhila kpa na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ga ramhi memena, aa kie ri eva oyẹmhẹ mhila emhikhọghuo. A mhila khi a ya mẹ mie, isheghọ ni oghẹlẹ oyẹẹ o gba pfo. ");
INSERT INTO atgNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mhi aa lolo kpẹ khueghie ingme-a gue ẹ yẹ e. Ama ẹghẹghẹ ọọ bhale ni mhi aa ke rọ lighọ nu ẹ ngme, ama mhi ya gue ingme oyi Ita yẹ ẹ gboo. ");
INSERT INTO atgNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ini oni ogbẹlẹ o ramhi, a ya ri eva oyẹmhẹ mhila Ita emini o ghọle ẹ. Mhi aa liẹ khi mhẹmhẹ mhi ya mhila na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ita ọọ nono ingme oyẹẹ, itobọ khi a nono ingme oyẹmhẹ, a gbo miesuọ khi obọ oyi Ẹshinẹgba mhi te bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Obọ oyi Ita mhi te bhale ya lo elemhi agbọ, memena mhi gbo te elemhi agbọ ya vu je deba Ita.” ");
INSERT INTO atgNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eniyẹ odukhokho eyọli ẹẹ ọli, “Ena u tigbe ẹ khueghie ingmemhi eyẹ-a gueyẹ anye gboo, waa ke ẹ biẹbiẹ eni ingme-a gueyẹ anye. ");
INSERT INTO atgNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Eena anye lẹsẹ khi u lẹsẹ emhikpa, ọa ke khi ọgbọ ọ ke gbo ya ke mhila ẹ ogbọ. Onana o zẹ khi anye miesuọ khi obọ oyi Ẹshinẹgba u te bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","IJesu ọ sọ wẹ ọ, ọ, “A she miesuọ memena? ");
INSERT INTO atgNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ẹghẹghẹ ọọ bhale, oni ẹghẹghẹ o she ramhi, ni ẹẹ nya a rọ ya miatsẹ ku, ọgbọgbọ ọ je apfẹ oyọli. Mhẹmhẹ-ghuo tsẹ mhi ke ya la. Ama ọa khi mhẹmhẹghuo tsẹ mhi la, itobọ khi Ita ọ nu mhẹ la. ");
INSERT INTO atgNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Eri mhi gue ingme ena yẹ ẹ, ni a ri itobọ khi a kugbe mhẹ ọ mhuẹ opfọmhẹ. Ẹgbọ na agbọ e ya ri osue na ẹ mẹ. Ama a mhọli udu, itobọ khi mhi she mu agbọ ọ le.” ");
INSERT INTO atgNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Abi iJesu ọ rọ nu eniyẹ odukhokho eyọli ngme se, ọ yasẹ alo bino idane, ọ sọ iromhi, ọọ, “Ita, oni ẹghẹghẹ o she ramhi. Ri ufumhi oyi Omiẹ khasẹ agbọ, ni Omiẹ ọ li ri ufumhi oyẹ khasẹ agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Itobọ khi u she ri ekpabọ na li, shi ukhomhi oyi ẹgbọ na agbọ kpa, ni ọ ri agbọ na agbọagbọ na ẹgbọ ni u rọ na li. ");
INSERT INTO atgNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Agbọ na agbọagbọ khi, ni a rọ lẹsẹ ẹ, ikhi yẹyẹ ni u khi egbegbi Ẹshinẹgba ọghuo kpe. Ni a gbo rọ lẹsẹ mhẹ iJesu iKirisiti, ni u ghie. ");
INSERT INTO atgNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mhi she ri ufumhi oyẹ khasẹ ẹgbọ na agbọ, abi mhi rọ ọ gbe akanya ni u rọ na mhẹ, ni mhi gbe ọli pfo. ");
INSERT INTO atgNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ita, gbo ri ufumhi ni mhi kpẹ mhọli na mhẹ memena, ikhi ufumhi ni mhi rọte ekẹ mhọli neni a ma agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mhi she ri ẹ khasẹ ẹgbọ ni u te elemhi agbọ rọ na mhẹ. Ẹgbọ eyẹ e khi ni u rọ na mhẹ. E she ri ungmemhi oyẹ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Memena e she lẹsẹ khi emhikpa ni u rọ na mhẹ khi obọ oyẹ e te bhale. ");
INSERT INTO atgNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mhi she gueyẹ wẹ usomhi ni u rọ na mhẹ, wẹwẹ e she mie oni usomhi. E she lẹsẹ egbegbọ khi obọ oyẹ mhi te bhale, e gbo miesuọ khi yẹyẹ u ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mhi sọ iromhi na wẹ, ọa khi ẹgbọ na agbọ nya mhi sọ iromhi na, ama eni u rọ na mhẹ irari khi ẹgbọ eyẹ e khi. ");
INSERT INTO atgNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Emhikpa ni mhi mhọli eyẹ e khi, emini u mhọli eyẹmhẹ e li khi. Wẹwẹ e ri ufumhi oyẹmhẹ khasẹ ẹgbọ na agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Memena mhia bhale deba ẹ, mhia ke la elemhi agbọ, ama wẹwẹ e kie la elemhi agbọ. Ita ni ọ pfuasẹ, ri itoto ni o la eva oyẹ ni u rọ na mhẹ, khukhu wẹ, ni e khi ọghuo abi mhẹmhẹ ali yẹyẹ awa khi ọghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ẹghẹghẹ ni mhi rọ nu wẹ la, mhi ri itoto ni o la eva oyẹ ni u rọ na mhẹ, khukhu wẹ, mhi khẹ wẹ ekhẹ. Ọkhọghuo ọ ọa pfua, sẹ ni ọghuo elemhi wẹ ni ọ khi ọni ọ ya pfua, ni emini a kẹkẹ shi Ebe-no-pfuasẹ o bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Memena mhia bhale deba ẹ, mhia ngme ingmemhi ena, abi mhi kie li la elemhi agbọ, ini eniyẹ odukhokho eyẹmhẹ e mhọli oghẹlẹ ni o gba pfo, onabi oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mhi she gue usomhi oyẹ yẹ wẹ, ama agbọ ẹ biselemhi wẹ, itobọ khi ẹa ke khi enayi agbọ abi mhia li khi ọnayi agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mhi aa liẹ u wolọ wẹ elemhi agbọ lasele, ama tsumhi wẹ obọ oyi Ọna ọkhọlọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ẹa khi enayi agbọ abi mhi aa li khi ọna agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ri igẹsikia oyẹ rẹwẹ pfuasẹ. Irari khi egbegbi ungmemhi ungmemhi oyẹ o khi. ");
INSERT INTO atgNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Abi u li ghie mhẹ je elemhi agbọ, ighọ mhi li ghie wẹ je elemhi agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Itobọ ẹwẹ mhi rọ ri egbe mhẹ nẹ, ini wẹwẹ ee li lighọ ri egbe wẹ nẹ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ọa khi itobọ oyi eniyẹ odukhokho eyẹmhẹ tsẹ mhi rọ sọ iromhi ona. Mhi li sọ iromhi na ẹgbọ ni e li ya te ọtsẹlẹ oyẹwẹ mie mhẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mhi sọ iromhi e ga kugbe khi ọghuo. Ita! Mhi sọ iromhi e la elemhi oyi awa, ẹzẹzẹ abi u li la elemhi oyẹmhẹ ni mhẹmhẹ mhi li la elemhi oyẹ. Mhi sọ iromhi e khi ọghuo ini agbọ e mie wẹ suọ khi yẹyẹ u ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mhi ri ufumhi ni u rọ na mhẹ na wẹ ini e kugbe khi ọghuo abi mhẹmhẹ ali yẹyẹ awa khi ọghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mhẹmhẹ mhi la elemhi oyẹwẹ, yẹyẹ u la elemhi oyẹmhẹ, ni e ga kugbe khi ọghuo, isheghọ ni agbọ e lẹsẹ khi yẹyẹ u ghie mhẹ, ali khi u nono ingme oyẹwẹ abi u nono ingme oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ita, yẹyẹ u ri wẹ na mhẹ. Mhia nono ni e nu mhẹ la ashini mhi ya la kpa, isheghọ ni e mẹ ufumhi ni u rọ na mhẹ itobọ khi u nono ingme oyẹmhẹ neni a ma agbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ita ni ọ pfuasẹ! Agbọ ẹa lẹsẹ ọni u khi, ama mhẹmhẹ mhi lẹsẹ ọni u khi, enana e lẹsẹ khi yẹyẹ u ghie mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mhẹmhẹ mhi ri ọni u khi khasẹ, ighọ mhi kie li ya ke riẹlẹ ọli, isheghọ inono ni u mhọli na mhẹ, o la wẹ egbe, ni mhẹmhẹ mhi li la elemhi oyẹwẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Abi iJesu ọ rọ sọ iromhi ona se, lọli ali eniyẹ odukhokho eyọli e da uchokẹ ni a lu iKidirọni lase. Ogba ni a kọ ẹẹra na lu olivu shi o la epfẹ aghọ, iJesu ali eniyẹ odukhokho eyọli e lo elemhi oni ogba oyi ẹẹra olivu. ");
INSERT INTO atgNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","IJudasi ọni ọ ri ọli dẹ ọ lẹsẹ oni ogba, itobọ khi iJesu ali eniyẹ odukhokho eyọli e kẹlẹ lona akaghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ighọ iJudasi ọ tsua ekhọli-okhuẹ eyi iRomu, ali ẹgbọ ni e la Owa oyi Ẹshinẹgba ẹ khẹ ekhẹ ali ighie eyi ekpodalo-ugamhi eyi iJu ali iFarisi ma egbe. E tsua itsua okhọli, ali igbili igọlọ ali ikpa. E lo ogba oyi ẹẹra olivu le. ");
INSERT INTO atgNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","IJesu ọ she kpẹ lẹsẹ emini lọli ya mẹ, ọ mhila wẹ, ọọ. “Ọghuo a nono?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ẹẹ ọli, “IJesu ọnge iNazarẹti!” IJesu ọọ, “Mhẹmhẹ na.” IJudasi ni ọ ri ọli dẹ ọ migha mama wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Abi IJesu ọ rọ gueyẹ wẹ khi, “Mhẹmhẹ na,” ighọ e ti je ukhokho, e de ya gbe. ");
INSERT INTO atgNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","IJesu ọ gbo mhila wẹ, ọọ, “Ọghuo ẹ khi a nono wẹ?” E gbo liẹ ọ li, “IJesu ọnge iNazarẹti.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","IJesu ọọ, “Mhi she kpẹ gueyẹ ẹ khi mhẹmhẹ na. O kha khia khi mhẹmhẹghuo a nono, a zẹ ni eni e kpọle e vu.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eri iJesu ọ ngme ona ni emini ọ kpẹ ngme o bhale ya tsẹ, ni ọọ: “Ita! Mhi aa wasẹ ọkhọghuo elemhi ẹgbọ ni u rọ na mhẹ a.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ighọ iSamọ iPita, ni ọ tsua itakobi shi emhi ọ ji ọli lasele rọ bẹ ọni ọ gbe akanya a deba ọga ọyi ekpodalo ugamhi esọ na obita ukhomhi pfi-a. IMakọsi a lu ọni ọmọse. ");
INSERT INTO atgNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","IJesu ọọ iPita, “Rue itakobi oghọ shi ashini u kpẹ te ji ọli lasele. Eri u dabi khi mhia ya rọte uko osue ni Itamhẹ ọ mhẹsẹ na mhẹ ya da?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ighọ ekhọli-okhuẹ eyi iRomu ali eni e kpeda na wẹ ali eni e khẹ ekhẹ owa ugamhi ni o funẹ eyi ẹgbọ iJu, e gba iJesu mu, e gẹ ọli abọ je ukhokho. ");
INSERT INTO atgNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","E te ododẹ rue ọli bhale ayi Anasi, ni ọ khi ọgọ iKefasi. IKefasi ọ khi ọkpodalo-ugamhi ọyi Ẹshinẹgba ọni ọ kpeda ọyi ẹgbọ iJu oni ukpe oghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","IKefasi ọ́ ke kpẹ ye ẹgbọ iJu ude, khi ini ọgbọ ọtuọghuo ọ ghu-a na ẹgbọ ni e bu, o ti dọsẹ ni ẹgbọ ni e la ẹoli nya e pfua. ");
INSERT INTO atgNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ISamọ iPita ali ọmọ odukhokho ọyi iJesu ọlese, e deba iJesu. Ọni ọmọ odukhokho ali oni ọ kpeda nya na ekpodalo-ugamhi eyi Ẹshinẹgba e kpẹ lẹsẹ egbe. Ighọ ọni ọmọ odukhokho ọ deba iJesu lo elemhi apfẹ oyi oni ọ kpeda nya na ekpodalo-ugamhi eyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Abi iPita ọọ migha olase epfẹ odẹ unuẹkpẹ, ọni ọmọ odukhokho ọghọ ọ nyenẹ egbe je olase, ọ ya nu ọni ọmueshi ni ọ la aghọ ngme, ọ rue iPita lo elemhi apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ọni ọmueshi ni ọ la odẹ unuẹkpẹ ọ̀ mẹ iPita, ọ́ ọ̀ li, “Ọa khi ọmọ odukhokho ọyi ọni ọmọse ọghọ u li khi?” IPita ọọ, “Iiye, mhia khi lọli.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ulili o gbe. Eni ẹ khẹ ekhẹ ali ighumha e migha gasẹ erali ingamhi ni e pfie, e khasẹ erali. IPita ọ li nu wẹ migha a khasẹ erali. ");
INSERT INTO atgNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ọni ọga ọyi ekpodalo ugamhi eyi Ẹshinẹgba ọ mhila iJesu ogbọ osẹsẹ eyọli ali eniyẹ odukhokho eyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","IJesu ọ́ sọli ọ, ọ, “Mhi aa tigbe na sheli sẹsẹ osẹsẹ elemhi Owa Oyi Ẹshinẹgba ali owa ugamhi ni mhi la a sẹsẹ gboo ẹghẹghẹ kpa, ikhi ashini ẹgbọ iJu ẹ legba. ");
INSERT INTO atgNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Elọ o zẹ khi áá mhila mhẹ ogbọ? A ka mhila ẹgbọ ni e suọ osẹsẹ oyẹmhẹ. E lẹsẹ emini mhi ngme.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Abi iJesu ọ ngme ona se, ọghuo eni ẹ khẹ ekhẹ ọ lase iJesu esọ, ọ li, “Elọ o zẹ ni u rọ lighọ nu Ọga ọyi ekpodalo ugamhi a ngme?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","IJesu ọọ, “Ini u lẹsẹ khi mhi aa gue ngme, gue emini ọa ti ni mhi ngme le, ni ẹgbọ e suọ. Ama o kha khia khi mhi guẹ ngme, elọ o zẹ ni u rọ lase mhẹ esọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ana Anasi ọ la liẹ e rue ọli ghi iKefasi ni ọ khi Ọga ọyi ekpodalo ugamhi, abi a kie li gẹ ọli abọ je ukhokho. Ẹghẹghẹ ona, iKefasi ali Anasi e ga khi ekpodalo-ugamhi eyi Ẹshinẹgba ni e kpeda. ");
INSERT INTO atgNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","IPita ọ kie migha akaghọ, ọọ khasẹ erali. Ẹgbọ elese e mhila li, “Wa she khi ọghuo eniyẹ odukhokho eyi ọmọse ọghọ?” IPita ọ sọ wẹ ọ, ọọ, “Iiye! Ọa khi mhẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ọghuo ọni ọ gbe akanya a deba oni ọ kpeda nya na ekpodalo-ugamhi eyi Ẹshinẹgba, ni ọ khi ọgbọ ọyi ọmọse ni iPita ọ bẹ esọ ukhomhi a, ọ gbo mhila iPita, “Ọa khi yẹyẹ mhi she mẹ khi u nu ọmọse ọghọ la elemhi ogba?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","IPita ọ gbo lẹ, “Iiye!” Utoghuokpe, ọkpa ọ gbiẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ẹlẹ uzogbe fiefie, e rue iJesu fiẹ owa oyi iKefasi je apfẹ oyi igọvunọ oyi ẹgbọ iRomu. Enighie eyi ẹgbọ iJu ẹa lama lo elemhi oni apfẹ, itobọ khi ẹa nono ni ichimhi umha-pfuasẹ ni o mu wẹ, ini ee dobẹ le eminale iPasova. ");
INSERT INTO atgNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Itobọ ighọ ọni igọvunọ na lu iPaleti ọ fiẹ je olase deba eni ẹgbọ iJu, ọọ wẹ, “Umha-guẹli onoghuo a gue shi ọmọse ọna egbe?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ẹẹ ọli, “Ini ọa mhuẹ umha-guẹli lọ anye ẹa kha rue ọli bhale ghie.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","IPaleti ọọ wẹ, “A rue ọli vu ya gue ẹzọ egbe-a abi ushi oyẹẹ o ngme shọ.” Ẹgbọ iJu ẹẹ ọli, “Anye aa mhọli afu ni a rọ ọ liẹ a ka gbe ọgbọa.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Eri a lina mẹ onana ni emini iJesu ọ kpẹ ngme ni o bhale ya tsẹ, ikhi ungmemhi ni ọ la guele uwali eghuli ni lọli ya ghu. ");
INSERT INTO atgNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","IPaleti ọ nyenẹ egbe je elemhi apfẹ oyọli, ọ lu iJesu mhila, ọọ, “Yẹyẹ u khi oghie ọyi ẹgbọ iJu?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","IJesu ọọ. “Udu oyẹ ogbọ ona ni u mhila mhẹ o te bhale abi khi ọgbọ ọ gue ingme oyẹmhẹ yẹ ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","IPaleti ọọ li, “Ọnge iJu wẹ khi mhi khi? Ẹgbọ eyẹ ali ighie eyi ekpodalo-ugamhi e rue ẹ bhale ghi mhẹ, Elọ u li?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","IJesu ọọ li, “Eghiele oyẹmhẹ ọa khi onayi agbọ ona. Ini ighọ o khi lọ, eni ẹ deba mhẹ e kha ye okhọli na mhẹ, ini a khi dobẹ mu mhẹ ghi eni ẹ mhẹsẹ eyi ẹgbọ iJu. Ama memena, eghiele oyẹmhẹ ọa khi onayi agbọ ona.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ighọ iPaleti ọ mhila li, “Oghie u ti ẹ khi?” IJesu ọọ, “U guẹ ga ngme ọli ni u rọ khi oghie mhi khi. Onana o zẹ khi a bia mhẹ bhale elemhi agbọ, ni mhi rọ ri emini o khi igẹsikia khasẹ ẹgbọ na agbọ. Ọni ọ da khi ọna igẹsikia ne, ọọ suọ oyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","IPaleti ọ mhila li, “Elọ o khi igẹsikia?” Ighọ iPaleti ọ gbo fiẹ je olase, ọ gueyẹ ẹgbọ iJu, ọọ, “Mhi aa mẹ umha-guẹli shi ọli obọ ni o rẹmhẹ ya pfa ẹzọ mu ọli a gbe ọlia ");
INSERT INTO atgNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama, abi a li ini a da li ukpe iPasova khi, ukpe khi ukpe kpa, eri mhia rue ọgbọ ọghuo ẹgbọ eyẹ ẹ eni a mu shi owa ighumha abọ-a na ẹ. A nono ni mhi wolọ oghie iJu abọ a na ẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ighọ e tsẹsẹ gbii, ẹẹ ọli, “Iiye! Ri Ochoghọ rue iBarabasi obọ a na anye.” (IBarabasi iko ọ li, ọni ọ gbe ọgbọ a ọ khi ni a mu shi owa ighumha.) ");
INSERT INTO atgNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ighọ iPaleti ọọ a gbe iJesu itali egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Eni ekhọli-okhuẹ e nyanọ iguabọ ẹẹra igba riẹlẹ arula oghie rughu iJesu ukhomhi, e rue awulu ni o khi ẹgholi ni ọ li abi oyilẹ nabi a rọ ọ sọ oghie sọ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","E gbo bhale deba li, e rọ ọli li egia, e liẹ ọli, “A yasẹ obọ ekẹ na oghie ọyi iJu!” E lase ọli alo. ");
INSERT INTO atgNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","IPaleti ọ ke gbo fiẹ je olase deba ẹgbọ iJu, ọọ, “A ghe ọli e, mhi rue ọli lasele na ẹ ni a rọ lẹsẹ khi mhi aa mẹ umha-guẹli shi ọli obọ ni o rẹ mhẹ ya liẹ a ka gbe ọli a.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Abi iJesu ọ rọ fiẹ lasele ni ọ rọ rughu arula igba, ọ gbo sọ awulu ẹgholi oyilẹ ni oghie ọ sọ, iPaleti ọọ, “A ghe ọni ọmọse!” ");
INSERT INTO atgNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Abi ighie eyi ekpodalo-ugamhi ali eni ẹ khẹ ekhẹ Owa oyi Ẹshinẹgba e rọ mẹ ọli, e tsẹsẹ, ẹẹ, “A ta li ma ọọra apfida! A ta li ma ọọra apfida!” IPaleti ọọ, “Ẹẹ a rue ọli vu ya ta ma ọọra. Mhi aa mẹ umha-guẹli shi ọli obọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ẹgbọ iJu ẹẹ ọli, “Anye mhuẹ ushi ni o guele a gbe ọlia, itobọ khi ọọ lu egbọli Omi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Abi iPaleti ọ rọ suọ ona, ulishi o tigbe mema lolo mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ọ nyenẹ egbe je elemhi apfẹ oyọli, ya mhila iJesu, “Ọnge obo u khi?” Ama iJesu ọ tsaghiẹ ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","IPaleti ọọ, “Wa ya mie mhẹ unu? Wa lẹsẹ khi mhi mhọli ekpabọ ni mhi rọ dobẹ ya pfa ẹ shi ekẹ, ali khi mhi gbo dobẹ ya liẹ a ka tẹ ma ọọra apfida gbe-a?” ");
INSERT INTO atgNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","IJesu ọọ ọli, “Wa kha mhọli afu shi mhẹ idiegbe ini ọa khi Ẹshinẹgba o ri ọli nẹ lọ, ama ọgbọ ni ọ mu mhẹ bhale ghi ẹ, lọli ọ mhọli umha-guẹli oyi olamhẹ ni o fu nẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Abi iPaleti ọ rọ suọ ona se, ọ nono odẹ ni ọ te ya wolọ iJesu abọ a, ama eni ẹgbọ iJu e kiele tsẹsẹ, e liẹ ọli, “Ini u zẹ ọli obọ, wa khi ọmọle iSiza oghie ọniẹmhi ọyi iRomu. Ọnini ọ da guele khi oghie lọli khi, ọbe iSiza ọ khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Abi iPaleti ọ rọ suọ ingmemhi ena, ọ rue iJesu je olase, iPaleti ọ ya shitọ ukpho ẹchẹ ni ọ shitọ la sọ ẹzọ, ni a lu Ẹtẹtẹ ẹchẹ (iGabata a ri ẹlẹmhi Iburu ẹẹ lu ọli) ");
INSERT INTO atgNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ẹghẹghẹ aghọ ovọ o lẹsẹ ramhi iteteva ukhomhi ẹlẹghọ, ikhi ogbẹlẹ ni a mu egbe ẹ shi ukpe iPasova. IPaleti ọọ eni ẹgbọ iJu, “Oghie ọyẹẹ ghọ o!” ");
INSERT INTO atgNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ama e tsẹsẹ, “A rue ọli ya gbe-a! A rue ọli ya gbe-a! A ta li ma ọọra apfida!” IPaleti ọ mhila wẹ, ọọ, “A nono ni mhi ta oghie ọyẹ ẹ ma ọọra apfida?” Ighie eyi ekpodalo-ugamhi ẹẹ ọ li, “Anye aa mhọli oghie ọlese dọsẹ oghie iSiza.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ighọ iPaleti ọ ri iJesu na ekhọli-okhuẹ e ka ta li ma ọọra apfida. Rọ te aghọ vu ekhọli-okhuẹ e te rue iJesu vu. ");
INSERT INTO atgNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","IJesu ọ fiẹ lasele, lọlighuo ọ tsua ọọra apfida oyọli, ọ je ashini a lu “Ukhomhi olimhi ni o ku igua-a.” (IGọgọta a ri ẹlẹmhi Iburu ẹ lu akaghọ.) ");
INSERT INTO atgNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aghọ e tali ma ọọra apfida shi, e ta ẹgbọ aava ma ẹẹra mama li. Ọghuo epfẹ obita, ọnọkpọle epfẹ obọgobọ, iJesu ọ la wẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","IPaleti ọ kẹkẹ emhi rọ kphase oni ọọra-apfida. Emini ọ kẹkẹ shi ọ khi, “IJesu Ọnge iNazarẹti, Oghie ọyi Ẹgbọ IJu.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ebubu eni ẹgbọ iJu e zẹ oni emhi, itobọ khi ashini a ta iJesu ma ọọra apfida shi ọa nuata shi apfẹ. Ẹlẹmhi Iburu, ghe iLatini ali iGiriki a rọ kẹkẹ oni emini a rọ kphase ọọra apfida ni a ta iJesu ma. ");
INSERT INTO atgNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ighie eyi ekpodalo-ugamhi eyi ẹgbọ iJu ẹa lama shi emini iPaleti ọ kẹkẹ. E ya gueyẹ ọli, ẹẹ ọli, “Anye ẹa nono ni u kẹkẹ oghie ọyi iJu shi ọ, emini u kha kẹkẹ shi ọ khi, Oghie ọyi ẹgbọ iJu ọmọse ọna ọ khi lọli khi.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","IPaleti ọọ wẹ, “Mhi she kẹkẹ emini mhi kẹkẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Abi eni ekhọli-okhuẹ e rọ ta iJesu ma ọọra apfida se, e wolọ ide eyọli kemhi shi asha ene. Ọgbọgbọ ọ rue asha eghuo ọ, e gbo rue awulu oyọli ni a do ni aa rọte ashikhọghuo gbẹla toma. ");
INSERT INTO atgNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Eni ekhọli-okhuẹ e gueyẹ egbe wẹ, “Awa khi nyanọ li-a, awa ti ebe shi ọ, ni awa mẹ ọni o ya mu, ni ọ rue ọli.” Eri a mẹ onana ni emini a kẹkẹ shi Ebe-no-pfuasẹ o bhale ya tsẹ, ni ọọ, “E kemhi ide eyẹmhẹ, e gbo ti ebe shi awulu oyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inyọ iJesu, ali inyọghuo inyọli nọkpotso, ali iMeli ughuẹ iKilopasi, ali iMeli ọnge iMagidaleni e migha mama oni ọọra apfida ni a ta iJesu ma. ");
INSERT INTO atgNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","IJesu ọ mẹ inyọli ali ọmọ odukhokho ọyọli ni ọ nono ingme oyọli, khi ọ migha epfẹ aghọ, iJesu ọọ, “Inyọ! Omi-ẹ ghọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ọ gueyẹ ọni ọmọ odukhokho, ọọ li, “Inyẹ ghọ.” Rọ te aghọ vu ọni ọmọ odukhokho ọ te rue ọni inyọ iJesu je apfẹ ni ọ te nu ọ la. ");
INSERT INTO atgNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","IJesu ọ lẹsẹ khi emhikpa e she zẹ ukhomhi, ọọ, “Okiamẹ ọa gbe mhẹ.” Onana o ri emini a kẹkẹ shi Ebe-no-pfuasẹ bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ubene ni o vọ onyọ ni o khẹ-a o la epfẹ aghọ, e sọ isoso elemhi oni onyọ e rọ oni isoso kphase ukpokpo oyi ọọra ni a lu isopu ni o nuẹ, e nise ọli je iJesu unu. ");
INSERT INTO atgNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Abi iJesu ọ rọ to unu oni onyọ, ọ, “O she pfo.” Ọ dọ ukhomhi gbe, ọ ghua. ");
INSERT INTO atgNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ekhẹmhuẹ eyi ẹgbọ iJu e vu ya mhila iPaleti ọ zẹ ni wẹwẹ e ya pfi emhi shi awẹ eyi emọse ni a ta ma ẹẹra apfida guọghọ-a. Ali ni wẹwẹ e taghiẹ wẹ te eni ẹẹra apfida tiemhile. Emini o zẹ ni e rọ lighọ mhila khi, ẹlẹghọ khi ogbẹlẹ ni ala mu egbe khẹ ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu. Eri ẹa nono ni e la ikhomhi ẹẹra apfida ramhi ogbẹlẹ iyẹmhẹa, itobọ khi oni ogbẹlẹ iyẹmhẹa oghọ, ogbẹlẹ ipfuasẹ na kẹ o khi. ");
INSERT INTO atgNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eni ekhọli-okhuẹ e vu ya pfi emhi shi ọgbọ ọni ododẹ ni a ta ma ọọra apfida mama iJesu awẹ guọghọ a. E gbo lighọ ya guọghọ eyi ọni o kpọle a. ");
INSERT INTO atgNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama abi e rọ ramhi ayi iJesu, e bhale ya ẹ khi ọ she ghua, itobọ ighọ ẹa ke pfi emhi shi iJesu awẹ guọghọ a. ");
INSERT INTO atgNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ọghuo eni ekhọli-okhuẹ ọ sọ iJesu ọgbhọrọ epfẹ, utoghuokpe, ọlia ali amẹ e te ọli egbe ku lasele. ");
INSERT INTO atgNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ọgbọ ni ọ ri ẹloe mẹ ona ọ pfi ọtsẹlẹ shi ọ, ọtsẹlẹ ni ọ pfi o khi igẹsikia itobọ khi ọ lẹsẹ gboo khi igẹsikia ona o khi. Eri ọ pfi ọtsẹlẹ ona ni a khi eni e miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Onana o ri emini a kpẹ kẹkẹ shi Ebe-no-pfuasẹ bhale ya tsẹ, ni o guele khi, “Ọgbọkhọghuo ọa ya khi ugua shi ọli idiegbe.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ebe-no-pfuasẹ o gbo ngme ghọ shi asha olese khi, “E ya ke bino ọni e ya to ọgbhọrọ gbese a.” ");
INSERT INTO atgNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Abi a rọ mẹ ona se, iJosẹfu ọnge Arimatia, ni ọ khili ọtuọghuo eniyẹ odukhokho ni e bẹna e deba iJesu itobọ khi ọ na ulishi oyi ekhẹmhuẹ eyi ẹgbọ iJu, ọ lẹ ya mhila iPaleti olimhi oyi iJesu. IPaleti ọ lama na li ọ rue olimhi oyi iJesu ya rọ tọ. Ighọ iJosẹfu ọ bhale ya rue ọli vu. ");
INSERT INTO atgNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","INikodemọsi ni ọ ke ya mẹ iJesu ẹlẹ iyọsẹ ọ kphase iJosẹfu. Ọ tsua ikhumhi ni a rọ ọ to olimhi egbe ini ọ khi kẹlẹ kẹa. Eni ikhumhi e bu ramhi akpulu ikoko oghuo. Ọ gbo tsua ituale ni ẹ pfie mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Eni emọse aava e tsua olimhi ọyi iJesu, e ri ide epfopfo gẹnọ ọli. Abi e li i gẹnọ ọni olimhi, ighọ e pfi ituale shi ọli egbe, ni e ri ikhumhi na rọ ọ shi olimhi egbe ma ọ, abi ẹgbọ iJu e liẹ mu olimhi egbe shi irọtọ, abi ushi oyẹwẹ o ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ukuku ogba o la ashini a ta iJesu ma ọọra apfida shi, uji ona ufuegbhẹ onogbọ ni aa ri ọgbọ tọ ghue o li la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Itobọ khi ẹlẹghọ o khi ogbẹlẹ ni a rọ mu egbe ẹ shi ekẹ khẹ ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu, ali khi oni uji na ufuegbhẹ o ti mama wẹ, e ri olimhi oyi iJesu yẹshi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ẹlẹ uzogbe fiefie ẹlẹ ni ọọ deba ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu, obili o kie la ogbe. IMeli ọnge iMagidaleni ọ̀ je uji ashini a ri iJesu yẹshi, ọ bhale ya ẹ khi a she gheghele ẹchẹ unu oni uji-a. ");
INSERT INTO atgNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ighọ ọ sọ awẹ unamhi na je ayi iSamọ iPita ali ọmọ odukhokho ọghọ ni iJesu ọ nono ingme oyọli, ọ gueyẹ wẹ, ọọ, “E tsua olimhi oyi Ọnọmhuẹ elemhi uji ufuegbhẹ a! Anye aa lẹsẹ obini e tsua li je.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ighọ iPita ali ọni ọmọ odukhokho ọghọ e vu ya je oni uji ufuegbhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wẹwẹ aava ee na, ama ọni ọmọ odukhokho ọghọ ọ na dọsẹ iPita, ọ kpẹ ramhi oni uji ufuegbhẹ khẹ iPita. ");
INSERT INTO atgNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ọ nyẹsẹ egbe bino elemhi oni uji ufuegbhẹ, ama ọa lo elemhi ọ. Ọ mẹ ide ni a kpẹ rọ khuli idiegbe oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ighọ iSamọ iPita ni ọ kpukhokho ramhi aghọ ọ dọsẹ ya lo elemhi oni uji ufuegbhẹ. Ọ mẹ eni ide khi e la elemhi uji ufuegbhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ode olimhi ni a rọ gẹ iJesu ukhomhi o li la aghọ. Oni ode o khili shi ashaọda shi ide enekpọle ọ. O kie khili shi aghọ abi a kie kpẹ li rọli khili olimhi oyi iJesu, ọa taghiẹ a. ");
INSERT INTO atgNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ighọ ọni ọmọ odukhokho ọghọ ni ọ kpẹ ramhi oni uji, ọ li lo elemhi ọli, ọ ri ẹloe mẹ, ọ miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Oni ẹghẹghẹ ẹa kie lẹsẹ emini a kẹkẹ shi ebe khi iJesu ọ ya te eghuli guale. ");
INSERT INTO atgNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ighọ eni eniyẹ odukhokho e nyenẹ egbe je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","IMeli ọ migha olase oni uji ufuegbhẹ ọọ viẹ. Abi ọ li kie le viẹ, ọ nyẹsẹ egbe bino elemhi oni uji ufuegbhẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ọ mẹ khi igẹni aava ni e sọ itsua epfopfo e shitọ elemhi oni uji ufuegbhẹ ni a ri olimhi oyi iJesu yẹshi. Ọghuo ọ shitọ obini iJesu ọ kpẹ ri ukhomhi shi, ọni ọ kpọle ọ shitọ obini ọ kpẹ ri awẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ẹ mhila li, ẹẹ ọli, “Nọ kpotso, elọ u viẹ ẹ shi?” Ọọ wẹ, “E she tsua Ọnọmhuẹ ọyẹmhẹ vu, mhi aa lẹsẹ obini e rọli shi.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ighọ ọ nyenẹ egbe ọ mẹ khi iJesu ọ migha aghọ, ama ọa lẹsẹ khi iJesu lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","IJesu ọ mhila li, ọọ li, “Nọ kpotso elọ u viẹ ẹ shi, ọghuo wa nono?” IMeli ọ dabi khi ọni ọ riẹlẹ shi oni ogba ni o la aghọ lọ, ọ, “Ọga ini yẹyẹ u tsua li vu kpẹkpẹ gueyẹ mhẹ obini u rọli shi ni mhi je aghọ ya tsua li.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","IJesu ọ li, “Meli.” Ọ sọ alo ghue ọli, ọ tsẹsẹ leghe ri ẹlẹmhi oyi ẹgbọ iJu yemhẹ ọli, ọọ, “Raboni!” Ọsẹsẹ a ri ona ngme ẹlẹmhi Iburu. ");
INSERT INTO atgNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","IJesu ọ gueyẹ ọli, “Khi mu mhẹ mhuẹ, itobọ khi mhi aa nyenẹ egbe je oyi Ita ne. Ama ka gueyẹ inyọghuo-mhẹ khi mhi ya nyenẹ egbe je oyi Itamhẹ ni ọ li khi Ita wẹ, ali Ẹshinẹgba ọyẹmhẹ ni ọ li khi Ẹshinẹgba ọyẹwẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ighọ iMeli ọnge iMagidaleni ọ vu ya gueyẹ eniyẹ odukhokho khi lọli mẹ iJesu Ọnọmhuẹ. Ọ gueyẹ wẹ ingme ni Ọnọmhuẹ ọ gueyẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Abi ogbọmhi o rọ mu ekẹ ẹlẹghọ ni o khi ogbeakọlọ oyi ẹlẹ iyẹmhẹa oyi ẹgbọ iJu, ni o khi ẹlẹ ni ododẹ elemhi ẹfo uka, eniyẹ odukhokho eyọli e le gba elemhi owa, e sọnọ okpẹ odẹ itobọ khi ee na ulishi oyi ẹgbọ iJu eni ẹẹ mhẹsẹ. Udemhija, iJesu ọ bhale ya migha wẹ iteva bia, ọọ, “Opfọmhẹ o ka nu ẹ la.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Abi ọ rọ ngme ona se, ọ ri abọ ali epfẹ khasẹ wẹ. Oghẹlẹ o vọ wẹ elemhi shi abi e li mẹ Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","IJesu ọ gbo liẹ wẹ, “Opfọmhẹ o ka nu ẹ la. Abi Ita ọ li ghie mhẹ mhi li liẹ ghie ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ighọ ọ yẹmhẹ ku wẹ, ọọ, “A mie Ayẹmhẹ-nọ-pfuasẹ, ");
INSERT INTO atgNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ọgbọ ni a da gbe olamhẹ kua na, a she gbe kua na li, ama ini aa da gbe kua na wẹ ne, aa gbe kua na wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Otu ọghuo elemhi eni eniyẹ odukhokho ogbava ni a lu iTọmọsi ni a gbolo ẹẹ lu itsema, ọa nu wẹ la aghọ ni iJesu ọ rọ bhale wẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eniyẹ odukhokho eni e kpọle e gueyẹ ọli, ẹ ọ li, “Anye mẹ Ọnọmhuẹ!” ITọmọsi ọọ, “Ini mhi aa li mẹ ẹmẹli ni o la ashini a te ta itse shi ọli abọ ni mhi ri umiesobọ oyẹmhẹ ti ọli, ni mhi aa rọ ri obọ shiọ oni o la li epfẹ, mhi aa ya miesuọ khi ọ she guale.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Abi o rọ gbe utui, eniyẹ odukhokho eyọli e gbo lona elemhi owa, iTọmọsi ọ nu wẹ la aghọ, e sọ okpẹ odẹ. Udemhija iJesu ọ gbo bhale ya migha wẹ iteva bia, ọọ wẹ, “Opfọmhẹ o ka nu ẹ la.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ọ gueyẹ iTọmọsi, ọọ li, “Ri umiesobọ ti ana, bino mhẹ abọ, gbo nise obọ ti mhẹ epfẹ. Khi ke mhọli akhọkhọmhẹ, miesuọ!” ");
INSERT INTO atgNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ITọmọsi ọ li, “Ọnọmhuẹ ọyẹmhẹ, ali Ẹshinẹgba ọyẹ mhẹ!” ");
INSERT INTO atgNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","IJesu ọọ li, “Itobọ khi u mẹ mhẹ u rọ miesuọ? Ikhivọsẹ o khi na eni ẹa mẹ mhẹ ne ni e miesuọ.” ");
INSERT INTO atgNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","IJesu ọ la ukpẹloe oyi eniyẹ odukhokho eyọli gbe ikanya ọnyaloa ni e bububu elese ni ọgbọ ọa kẹkẹ shi ebe ona. ");
INSERT INTO atgNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama eri a kẹkẹ ena shi ebe ini a miesuọ khi iJesu khi iKirisiti, ikhi Ọmiepfuese Omi Ẹshinẹgba, ali, ini a mhọli irudunga, a ya mhọli agbọ itobọ eva oyọli. ");
INSERT INTO atgNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Abi a rọ mẹ ingme ena se, iJesu ọ gbo ri egbe ọli khasẹ eniyẹ odukhokho eyọli, epfẹ okẹ oniẹmhi ni a lu iGalili. Ina a li mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ISamọ iPita, ali iTọmọsi na lu itsema, ali iNataniẹli ọnge iKena na ekẹ iGalili, ghe IJọni ali iJemhisi imi iZebedi, ali eniyẹ odukhokho eyi iJesu aava elese e ga legba asheghuo nya. ");
INSERT INTO atgNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ISamọ iPita ọọ, “Mhia vu ya mu ifẹlẹ.” Ẹẹ ọli, “Anye ya deba ẹ ye.” Ighọ e lo elemhi ọkọ-okẹ oniẹmhi oni ikeke. Ama ẹliyọsẹ ẹlẹghọ nya, ẹa mu emhikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ẹlẹ uzogbe fiefie, iJesu ọ migha egele oyi okẹ oniẹmhi, ama wẹwẹ ẹa lẹsẹ khi iJesu ọ nu wẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","IJesu ọ mhila wẹ, ọọ, “Emọle mhẹ, aa kie mẹ afẹlẹ ọkhọghuo mu?” Ẹẹ ọli, “Anye ẹa mẹ emhikhọghuo mu.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ọọ wẹ, “Pfi aga oyẹ je epfẹ obita oyi ọkọ-okẹ oniẹmhi khi a ya mẹ ifẹlẹ mu.” Ighọ e pfi aga je obini ọ ngme, ẹa ke dobẹ ti oni aga lọ elemhi oni ọkọ-okẹ oniẹmhi itobọ khi o she mu ifẹlẹ ni e bu. ");
INSERT INTO atgNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ighọ ọni ọmọ odukhokho ni iJesu ọ nono ingme oyọli, ọ́ ọ̀ iPita, “Ọnọmhuẹ lọ!” Abi iSamọ iPita ọ suọ khi Ọnọmhuẹ lọ ni ọ nu wẹ ngme lẹna, ọ nyanya rọ itsua sọ (itobọ khi eri ọ kpẹ taghiẹ ide eghuo egbe-a), ọ ji pfilo elemhi amẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Eniyẹ odukhokho eni e kpọle e gua oni ọkọ-okẹ oniẹmhi bhale esọ okẹ, e e ti oni aga bhale epfẹ egele. Ekẹkhẹ ọa ke lolo nuẹ shi wẹ ọ, emhi nabi ẹtẹ-awẹ egbhuẹshe o ke rọte aghọ khi. ");
INSERT INTO atgNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Abi e rọ ramhi egele, e mẹ ingamhi erali aghọ, a ri afẹlẹ tọ ọ, ibulẹdi e li nga ọ. ");
INSERT INTO atgNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","IJesu ọọ wẹ, “A rọte ifẹlẹ ni a mu lẹna rue bhale.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","IPita ọ nga egele le, ọ ya tialọ oni aga ni o vọ ifẹlẹ enieniẹmhi ngale egele, eni ifẹlẹ e kugbe khi egbhuẹshilua ali igbẹsẹ. Abi eni ifẹlẹ e riẹ lighọ bu, oni aga ọa nyanọ a. ");
INSERT INTO atgNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","IJesu ọọ wẹ, “A bhale ya le emhi.” Ọgbọkhọghuo eni eniyẹ odukhokho ọa mhila li, “Ọghuo u khi?” Itobọ khi e lẹsẹ khi Ọnọmhuẹ lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ighọ iJesu ọ ya rue oni ibulẹdi kemhi na wẹ, ọ gbo kemhi oni afẹlẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Onana o khi utonuzi-esẹ ni iJesu ọ ri egbọli yaa khasẹ eniyẹ odukhokho eyọli abi ọ te rọte eghuli guale. ");
INSERT INTO atgNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Abi e rọ le se, iJesu ọọ iSamọ iPita, “Samọ omi iJọni! U fẹ nono ingme oyẹmhẹ dọsẹ emhi enana nya?” IPita ọ sọ li ọ, ọ Ii, “Ọnọmhuẹ, u lẹsẹ khi mhi nono ingme oyẹ.” IJesu ọọ, “Ri eminale na imi isumha eyẹmhẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Utonuzeva, iJesu ọọ li, “Samọ omi iJọni, u fẹ nono ingme oyẹmhẹ?” IPita ọọ Ii, “Guẹguẹguẹ Ọnọmhuẹ, U lẹsẹ khi mhi nono ingme oyẹ.” IJesu ọọ, “Ri eminale na isumha eyẹmhẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Utonuzesẹ iJesu ọọ li, “Samọ omi iJọni, u fẹ nono ingme oyẹmhẹ?” Oni ingme o to iPita egbe, itobọ khi iJesu ọ mhila li itesẹ, “U fẹ nono ingme oyẹmhẹ?” Ighọ iPita ọ sọ li ọ, ọ, “Ọnọmhuẹ, u lẹsẹ emhikpa, u lẹsẹ khi mhi nono ingme oyẹ.” IJesu ọọ li, “Rọ ẹloe khu isumha eyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","IJesu ọọ, “Igẹsikia mhi gue yẹ khi, abi u rọ khi ozele, eri u ri itsua sọ u fiẹ je obini o ghọle ẹ, ama ini u womhẹ, ọgbọẹse ọ ke ya ri itsua ke sọ ẹ, ọ mu ẹ obọ je obini ọa ghọle ẹ ni u je.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Eri iJesu ọ ngme ona ni ọ rọkhasẹ abi iPita ọ li ya ghua ni o ya rọ ufumhi ghi Ẹshinẹgba. Ighọ ọọ iPita, “Ke deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","IPita ọ nyenẹ egbe, ọ mẹ ọni ọmọ odukhokho ni iJesu ọ nono ingme oyọli, ọni ọ shitọ mama iJesu abi e rọ nu iJesu le eminale ni o kpukhokho khi ọọ deba wẹwẹ. Lọli ọọ ke mhila iJesu ogbọ ni ọọ, “Ọnọmhuẹ, ọghuo ọ ya rẹ dẹ?” ");
INSERT INTO atgNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Abi iPita ọ rọ mẹ ọli, ọ mhila iJesu, ọọ, “Sẹ ẹgbọ na agbọ e fẹ ya li ọni ọmọse ọna?” ");
INSERT INTO atgNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","IJesu sọ li ọ, ọ, “Ini mhia nono ni ọ la agbọ ramhi ni mhi rọ ya gbo nyenẹ egbe bhale agbọ, onoghuo o khi oyẹ shi ọ? Ke deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ona o zẹ ni e rọ bẹna ngme ọli iteva oyi eniyẹ odukhokho eyi iJesu, khi ọni ọmọ odukhokho ọna ọa ya ghu ghue. Ama iJesu ọa liẹ khi ọa ya ghu ghue. Eri ọ́ lẹsẹ liẹ, “Ini mhia nono ni ọ la agbọ ramhi ni mhi rọ ya gbo mu egbe nyenẹ bhale, onoghuo o khi oyẹ shi ọ?” ");
INSERT INTO atgNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Lọli khi ọmọ odukhokho ni ọ pfi ọtsẹlẹ shi eni ingmemhi ena, lọli ọ gbo kẹkẹ wẹ shi ebe. Awa gbo lẹsẹ khi emini ọ ngme khi igẹsikia lọ. ");
INSERT INTO atgNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ikanya ebubu e laọ ni iJesu ọ gbe. Ini ẹẹ a kẹkẹ wẹ nya ukpamhi oghuo-oghuo lọ, mhi sa khi agbọ ona nya ọa kha luẹsẹ ebe ni a kha kẹkẹ wẹ shi.");
INSERT INTO atgNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Elemhi ebe oni ododẹ ni mhi kpẹ kẹkẹ ghi yẹyẹ iTiofilọsi, mhi kẹkẹ ikanya ni IJesu ọọ gbe ali emini ọ sẹsẹ rọte igbaekẹle, ");
INSERT INTO atgNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ya ramhi ogbẹlẹ ni a rọ rue ọli nga idane. Neni a rue ọli nga idane, ọ rọte Ayẹmhẹ-nọ-pfuasẹ ri omhẹsẹ na ighiusomhi na kẹẹ ni ọ zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Abi ọ rọ ghu-a se, ogbẹlẹ egbhuẹva ọ la elemhi agbọ ọ ri egbọli kia khasẹ ighiusomhi eyọli, ni o rọkhasẹ gboo khi akhọkhọmhẹ ọa la ọ khi ọ la agbọ. E mẹ ọli, ọọ gue ungmemhi oyi Eghiele oyi Ẹshinẹgba yẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ẹlẹghuo khi e legba asheghuo, khi ọ nu wẹ ẹ le eminale, ọ ri omhẹsẹ ona na wẹ, ọọ wẹ, “A khi rọte iJerusalẹmu vu, a migha khẹ isomhopfa ni mhi gueyẹ ẹ, ikhi isomhopfa ni itamhẹ ọ shobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Amẹ iJọni ọ rọ ọ batazi ẹgbọ, ama ọa ke ya tẹsẹ neni a ri Ayẹmhẹ-nọ-pfuasẹ ya batazi ẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Abi ighiusomhi e rọ nu iJesu legba kugbe, e mhila li, ẹẹ ọli, “Ọnọmhuẹ, u ya la ẹghẹghẹ ona rue eghiele oyi ẹgbọ iZirẹni nyenẹ gbo na wẹ?” ");
INSERT INTO atgNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ọọ wẹ: “Aa khi eni ẹ lẹsẹ oni ẹghẹghẹ ali oni ogbẹlẹ ni Ita ọ ri afu eyọli mhẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama ini Ayẹmhẹ-nọ-pfuasẹ ọ bhale ẹ idiegbe, a ya mhọli ekpabọ, a ya ke pfi ọtsẹlẹ na mhẹ elemhi ekẹ iJerusalẹmu, ali ekẹ iJudia, ali iSameria ali elemhi ekẹ agbọ ona nya.” ");
INSERT INTO atgNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Abi ọ rọ ngme eni ingmemhi enana se, a rue ọli nga idane abi e kie li ghọ fẹli ọli. Otughunu o khukhu ọli-a, o rue ọli odalo oyẹwẹ le. ");
INSERT INTO atgNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","E bino idane chii abi ọ li vu, utoghuokpe emọse aava ni e sọ ide epfopfo e migha wẹ iteva. ");
INSERT INTO atgNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ẹẹ wẹ, “Ẹgbọ iGalili, elọ o zẹ ni a rọ migha a fẹli idane chii? Ọni iJesu ọna ni a rue odalo oyẹẹ vu nga idane, abi a li rue ọli vu, ighọ ọ li ya gbo nyenẹ egbe bhale.” ");
INSERT INTO atgNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ighọ, eni ighiusomhi na kẹẹ e rọte oni ukhomhi Ute Ẹẹra Olivu ni e migha vu je iJerusalẹmu, aghọ ọa lolo nuẹ shi iJerusalẹmu, okiali imali oghuo lọ, ni Ishi eyi iMosisi o lama shi ọgbọ ke kia ogbẹlẹ iyẹmhẹa. ");
INSERT INTO atgNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Abi e rọ ramhi iJerusalẹmu, e nga ukhomhi atọnga, e lo elemhi owa ni ee legba. Eni e la akaghọ khi iPita, iJọni, iJemhisi ali Aduru, iFilipu ali iTọmọsi, iBatolomiu ali iMatiu, iJemhisi ọlese ni ọ khi omi Afeusi, iSamioni ni ọ la otu iZilọti ali iJudasi omi iJemhisi. ");
INSERT INTO atgNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wẹwẹ nya e lona a kugbe ẹghẹghẹ kpa a sọ iromhi. Ghe eni ikpotso ali, iMeli inyọ iJesu, ali inyọghuo iJesu. ");
INSERT INTO atgNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ogbẹlẹ ni a ngme ena, iPita ọ vule migha iteva oyi igbaa oyi eni e mie iJesu iKirisiti suọ. Ẹgbọ egbhuẹsesa e la aghọ (120) ");
INSERT INTO atgNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ighọ ọọ, “Inyọghuo, a mema ya ri emini ebe-no-pfuasẹ o ngme tsẹ, ni Ayẹmhẹ-nọ-pfuasẹ ọ rọte unu oyi iDefidi ngme shi ekẹ shi iJudasi egbe, lọli ọni iJudasi ni ọ ri odẹ khasẹ ẹgbọ ni e mu iJesu. ");
INSERT INTO atgNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ọtuọghuo elemhi awa ọ khi ni ọ nu awa gbe akanya abi aghiusomhi.” ");
INSERT INTO atgNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","IJudasi ọ wolọ ikpaghọ ni ọ mie shi ikanya ọkhọlọ ni ọ gbe ya dẹ ekẹ. Aghọ ọ de tu ukhomhi ekẹ ku itọ-a shi. ");
INSERT INTO atgNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ọgbọkpa ni ọ la iJerusalẹmu ọ suọ ona, e ri irarighọ ri unu ẹoli oyẹwẹ lu akaghọ Akẹdama, ni o migha shi Ekẹ Ọlia. ");
INSERT INTO atgNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","IPita ọọ, “Irari khi, a kẹkẹ ọli shi ebe Iwolo khi, “ ‘A tsua owa oyọli pfia. A khi mẹ ọgbọkhọghuo ni ọ gbo la oni owa,’ “A gbo li kẹkẹ ọli: “ ‘Ọgbọẹse ọ rue asha omhẹsẹ oyọli.’ ");
INSERT INTO atgNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Itobọ onana, o ti ni awa zẹ ọgbọ ọghuo ni ọ to ẹlolo iJudasi, ọni ọgbọ ọ mema ya khi ọgbọ ni ọ nu awa la ọ rọte ẹghẹghẹ ni iJesu ọ rọ la iteva oyi awa, ");
INSERT INTO atgNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","rọte ẹghẹghẹ ni iJọni ọ rọ batazi ẹgbọ ya ramhi ogbẹlẹ ni Ẹshinẹgba ọ rọ rue iJesu lasele elemhi iteva oyi awa nga idane. Ọgbọ ni awa ya zẹ ọ mema ya nu awa gbe akanya aguele irọte eghuli guale oyi iJesu.” ");
INSERT INTO atgNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ighọ e khọkhọ emọse aava. Ọmọse ọghuo ni a lu iJosẹfu ni a lu iBasabasi, ni a gbolo ẹ lu iJọsitọsi, ali ọmọse ọlese ni a lu iMatayasi. ");
INSERT INTO atgNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ighọ e lema, ẹ li, “Ọnọmhuẹ, u lẹsẹ udu oyi ọgbọkpa, kpẹkpẹ rọte elemhi ẹgbọ etuava ena zẹ ");
INSERT INTO atgNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ọni ọ ya rue ikanya aghiusomhi na kẹẹ ni iJudasi ọ zẹ obọ je obini o khili oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ighọ e bọ shi ọ, obọ o mu iMatayasi, Ighọ e li ya rue ọli ma ighiusomhi na kẹẹ ogbaghuo ni iJesu ọ zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Abi ogbẹlẹ ukpe iPẹtikọsiti o rọ ramhi, igbaa oyi eni e mie iJesu iKirisiti suọ nya e lona kugbe asheghuo. ");
INSERT INTO atgNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Utoghuo-kpe, okeke o rọte idane tiemhile abi akpekpeli ni o toto, oni okeke o vọ elemhi oni owa ni e shitọ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ighọ e mẹ emini e li abi ẹlẹmhi erali khi e rọte ashakhasha a tiemhile shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ighọ Ayẹmhẹ-nọ-pfuasẹ ọ vọ wẹwẹ nya egbe, ee ngme ẹmuẹ oyi ẹoli ọdọda abi ọni Ayẹmhẹ ọ li khueghie wẹ unu-a. ");
INSERT INTO atgNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ẹgbọ iJu ni ẹ na ulishi Ẹshinẹgba ni e rọte ushishi ọdọda na ekẹ agbọ jele, e la elemhi iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Abi e rọ suọ oni okeke ona, ebubu ẹgbọ e kpeli bhale. O nya wẹ alo-a abi e rọ suọ khi eni ẹgbọ ni e miesuọ khi ẹ ngme ẹmuẹ ọdọda eyi wẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ighọ abọ e sha wẹ egbegbọ, e liẹ egbe. “Eni ẹgbọ ena, ni ẹẹ ngme ẹmuẹ eyawa ena, ọa khi ẹgbọ iGalili e she khi? ");
INSERT INTO atgNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sẹ awa ke liẹ suọ wẹ khi ẹẹ ngme ẹmuẹ ọdọda eyawa? ");
INSERT INTO atgNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ẹoli ọdọda awa te lasele, eghuo e rọte iPatia bhale, eghuo ọ, iMedisi ali Elamu, eghuo ọ, iMẹsopotemia, eghuo, ekẹ iJudia ali iKapadosha, eghuo, iPọtusi ali Esha, ");
INSERT INTO atgNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","eghuo, iFirigia ali iPafilia, eghuo, iJipiti ali ukiẹkiẹ ekẹ iLibiya ni o ti mama ekẹ iSairin, eghuo e rọte iRomu bhale, ");
INSERT INTO atgNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","li shi ẹgbọ iJu ali ẹgbọ iJẹta ni e mu pfi bhale irudunga oyi ẹgbọ iJu. Eghuo elemhi awa e rọte iKirẹti ali Arebia bhale. Abi o riẹ khi ighọ, awa kie ga suọ khi ẹ ngme ẹmuẹ eyawa, ẹẹ guele ikanya eniẹmhi ni Ẹshinẹgba o gbe.” ");
INSERT INTO atgNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eni ingme ni a mẹ e sha ọgbọkpa abọ, ẹa lẹsẹ udi wẹ, e mhila egbe wẹ. “Sẹẹ onana o ngme?” ");
INSERT INTO atgNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ẹgbọ eghuo e rẹwẹ ẹ li egia, ẹ liẹ, “Onyọ ọọ gbe wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ighọ iPita ọ vule migha, lọli ali ogbaghuo ni e kpọle, ọ khueghie unu-a leghe, ọ nu eni ebubu ẹgbọ ngme, ọọ, “Apfẹmhẹ iJu, ali ẹẹ ẹgbọ nya ni a la elemhi iJerusalẹmu, a rọ esọ shi mhẹ ekẹ ni mhi gue ingme ni a mẹ ena yẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ọa khi onyọ ọọ gbe eni ẹgbọ ena abi a dabi. Irari khi ogbe ọa dala ne, agogo itili ẹlẹ uzogbe awa la! ");
INSERT INTO atgNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iiye! Emini a mẹ ena o khi emini ọmekẹguele iJoẹl ọ guele ẹghẹghẹ ni o dọsẹ ni ọ rẹ: ");
INSERT INTO atgNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Ẹshinẹgba ọọ, Ogbẹlẹ ni e kpukhokho, mhi ya ri Ayẹmhẹ oyẹmhẹ na ẹgbọkpa. Imi ẹ eni emọse ali eni ikpotso e ya ke gue usomhi ni mhi ghie wẹ le. Izẹo eyẹ ẹ, e ya ke mekẹguele, egbhali eyẹ ẹ, e ya ke la ẹlena. ");
INSERT INTO atgNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Shi eni ẹ ga ọgbọ eni emọse ali eni ikpotso eyẹmhẹ, Mhi ya ri Ayẹmhẹ oyẹmhẹ na wẹ ogbẹlẹ ni a ngme ena, e ya gue emini mhi rọkhasẹ wẹ le. ");
INSERT INTO atgNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mhi ya rọ ọnyaloa khasẹ, obini irarogbe, ali khi mhi ya gbo ri irọkhasẹ khasẹ ekẹ agbọ. Mhi ya pfi okhọli shi elemhi agbọ, ni ẹgbọ e mẹ ọlia ali erali ali ewọli ");
INSERT INTO atgNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ovọ o ya bi obili a, mhi ya ri uki yilẹ-a rarara abi ọlia, neni ogbẹlẹ ni o funẹ oyi Ọnọmhuẹ o ya bhale ni ọ rọ ya gue ọgbọkpa ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ọgbọkpa ni ọ da pfie lu eva oyi Ọnọmhuẹ ne, a ya tsumhi ọli.’ ");
INSERT INTO atgNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ẹẹ ẹgbọ ni a la ekẹ iZirẹni, a rọ esọ shi ungmemhi onana. Ẹẹ a lẹsẹ khi iJesu ọngi iNazarẹti, ọ khi ọgbọ ni Ẹshinẹgba ọ ri egbe khasẹ, ọ gbo ghie ọli, itobọ khi Ẹshinẹgba ọ ri ekpabọ na li ọ ke gbe ikanya ọnyaloa elemhi iteva o yẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Abi o rọ tseku khia khi a lẹsẹ ona, a kie zẹ ni ẹgbọ ebe e mu ọli ghi ẹ ni a gbe ọli-a. Ama Ẹshinẹgba ọ she kpẹ gba onana ọ lẹsẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama Ẹshinẹgba ọ rọte eghuli guise ọli le. Eghuli ọa dobẹ ri ekpabọ oyọli mu ọli mama, abi ọkpotso ni oku ọọ to ọa li dobẹ a mu ọmọ ọ khi lasele. ");
INSERT INTO atgNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Itobọ khi oghie iDefidi ọọ ngme ingme oyi iKirisiti ni ọ rẹẹ, “ ‘Mhi mẹ khi Ọnọmhuẹ ọ migha kpẹsẹ mhẹ ẹghẹghẹ kpa, ọ la ukiẹkiẹ obita oyẹmhẹ, udu ọa ya nighise mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Itobọ ona udu oyẹmhẹ o rọ ọ ghẹlẹ, mhi ri uruli oyẹmhẹ ẹ kuẹghiẹ-ẹ, mhi ri egbe dẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Itobọ khi waa ya zẹ mhẹ obọ shi elemhi uji, wẹkhi eri u ya zẹ ni Ọni ọ pfuasẹ ọyẹ ọ kẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","U she kpẹ gueyẹ mhẹ khi mhi ya la agbọ ini u guise mhẹ te eghuli le. U ya ri oghẹlẹ oniẹmhi na mhẹ odalo oyẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Inyọghuo, mhi mema ya ri igbedu gueyẹ ẹ khi oghie iDefidi ni ọ khi itita awa, ọ she kpẹ ghu-a ni ẹgbọ e rọ tọ, oni uji ni a rọ ọli tọ o kie la akaghọ ramhi ogbe na amo. ");
INSERT INTO atgNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Awa lẹsẹ khi iDefidi ọ ngme aguele-shi-ekẹ shi iKirisiti egbe, irari khi ọ lẹsẹ khi Ẹshinẹgba ọ she kpẹ shobọ na luẹ ni ọ mema rọ ya tsẹ, khi lọli ya ri ọgbọ ọghuo unuẹkpẹ oyẹluẹ shitọ ukpẹkhomhi oghie oyẹluẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Eri Ẹshinẹgba ọ rọli khasẹ iDefidi emini a ya mẹ ogbenakọ, lọli ọ rọ ngme ọli khi Ẹshinẹgba ọ ya rọte eghuli guise iKirisiti le. Ọọ khi Ẹshinẹgba ọa ya zẹ ọli ghua ni idiegbe oyọli o kẹa shi elemhi uji. ");
INSERT INTO atgNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ẹshinẹgba guise iJesu le bhale agbọ. Awa nya awa ri ukpẹloe oyawa pfi ọtsẹlẹ shi ọ khi iJesu ọ she guale. ");
INSERT INTO atgNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ẹshinẹgba ọ she ri ekpẹ oniẹmhi na iJesu, ọ shitọ ukiẹkiẹ obita oyi Ẹshinẹgba. IJesu ọ she rọte obọ oyi ita mie Ayẹmhẹ-nọ-pfuasẹ, abi Ẹshinẹgba o kie kpẹ li shobọ na li. Ọni iJesu ọ she rue oni Ayẹmhẹ-nọ-pfuasẹ tutu vọ anye egbe, lọli o khi emini a mẹ, ni a gbolo a suọ memena. ");
INSERT INTO atgNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ama lẹsẹ khi iDefidi ọa nga iloghie. Itobọ ighọ, áà khi ingme egbọli iDefidi ọọ ngme abi ọ rọ liẹ, “ ‘Ọnọmhuẹ ọ gueyẹ Ọnọmhuẹ ọyẹmhẹ: Shitọ ukiẹkiẹ obita oyẹmhẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ramhi ni mhi rọ ya ri ebe ẹ mele akphawẹ-nga oyẹ-a’ ");
INSERT INTO atgNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Itobọ ona, mhia nono ni ẹẹ ẹgbọ iZirẹni nya a lolo lẹsẹ onana khi, Ẹshinẹgba ọ zẹ ọni iJesu ọnana ni a gbe-a shi apfida ọ khi Ọnọmhuẹ ali iKirisiti.” ");
INSERT INTO atgNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Abi eni ẹgbọ e rọ suọ eni ingmemhi ena se, oo nasẹ wẹ udu. Ighọ ẹ li mhila iPita ali ighiusomhi na kẹẹ eni e kpọle, ẹẹ wẹ, “Inyọghuo, Sẹẹ anye li ya kia ni Ẹshinẹgba ọ rọ ọ gbe olamhẹ kua na anye?” ");
INSERT INTO atgNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","IPita ọọ, “Ẹẹ nya a mupfi ni anye ri eva oyi iJesu iKirisiti batazi ẹ, isheghọ ni Ẹshinẹgba ọ gbe olamhẹ kua na ẹ, itobọ khi eni e mie iJesu suọ a ke khi, ni a mie isomhopfa Ayẹmhẹ-nọ-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Emini Ẹshinẹgba ọ shobọ ena, oyẹ ẹ lọ ali oyi imi ẹ, ali oyi ọgbọkpa ni Ẹshinẹgba ọ ya zẹ obiobini e la.” ");
INSERT INTO atgNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","IPita ọ ngme ingmemhi ni e bu, ọ tse agua yẹ wẹ, ọọ wẹ, “A na pfue anasẹmhẹ ni ẹgbọ ikpamhika ena e ya mẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ighọ a li batazi eni e mie oni ungmemhi suọ. Ẹgbọ agbẹlẹ esẹ e khi ni e kuma igbaa oyi eni e mie iJesu iKirisiti suọ ọ ẹlẹghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eni ẹgbọ e ri emini ighiusomhi na kẹẹ e sẹsẹ wẹ gbe akanya, e ga kugbe, e le eminale kugbe (e le eminale no pfuasẹ kugbe), e sọ iromhi kugbe. ");
INSERT INTO atgNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ọgbọkpa ọ́ mu ekpẹ ni o funẹ ẹ na Ẹshinẹgba irari ọlẹlẹ ọnyaloa ali ọshabọ ebubu ni eni ighiusomhi na kẹẹ e gbe. ");
INSERT INTO atgNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Eni e mie iJesu suọ nya e kudugbe, e kemhi emini e mhọli nya na egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eni e mhọli ekẹ e ri ekẹ eyẹwẹ dẹ, elese eni e mhọli itsua, e rẹ wẹ dẹ, e wolọ ikpaghọ kugbe kemhi ni eni ẹa mhọli. ");
INSERT INTO atgNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ogbẹlẹ kpa e rọ ọ legba elemhi apfẹ ni i la Owa Oyi Ẹshinẹgba. E ri oghẹlẹ ali udu ni o pfuasẹ nu egbe la apfẹ egbe e le eminale. E le eminale no pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ee kuẹghiẹ Ẹshinẹgba, ighọ ẹgbọ e li somhi elemhi wẹ. Ogbẹlẹ kpa Ẹshinẹgba ọ rọ ri ẹgbọ ni a mie e pfuese ma wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ogbẹlẹghuo khi iPita ali iJọni ee je Owa Oyi Ẹshinẹgba ẹghẹghẹ agogo esẹ ọguota ni a la sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A tsua ọmọse ni ọ rọte abi a te bia li guọghọ-a bhale ya shi odẹ unuẹkpẹ ni a lu Isomhotse oyi Owa Oyi Ẹshinẹgba. Akaghọ a tsua li bhale ya shitọ ni ọ te mẹ asha mhila ẹgbọ ni ẹ lo oni Owa Oyi Ẹshinẹgba le ikpaghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Abi ọ rọ mẹ iPita ali iJọni khi e lo oni Owa Oyi Ẹshinẹgba, ọ mhila wẹ ikpaghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ighọ iPita ọ bino ọli alo tatata, ighọ li khi iJọni. IPita ọọ li, “Bino anye!” ");
INSERT INTO atgNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ighọ ọ li bino wẹ, ọ ri udu sa khi lọli ya mẹ wẹ emhi obọ mie. ");
INSERT INTO atgNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ama iPita ọọ li, “Mhi aa mhuẹ ukpaghọ ya nẹ, ama mhi ri emini mhi mhọli nẹ. Irari eva oyi iJesu iKirisiti ọnge iNazarẹti, vule ni u ke kia!” ");
INSERT INTO atgNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ighọ iPita ọ mu ọli obọ-ita vule. Udemhija, awẹ ali ili awẹ eyọli e na ya to. ");
INSERT INTO atgNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ighọ ọ ti vule migha, ọọ kia gasẹ. Ọ nu wẹ lo elemhi oni Owa Oyi Ẹshinẹgba, ọ kia, ọ jino, ọ kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abi ẹgbọ ni e la akaghọ nya e rọ mẹ ọli khi ọ kia gasẹ, khi ọ kuẹghiẹ Ẹshinẹgba, ");
INSERT INTO atgNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","e lẹsẹ ọni ọ khi, khi lọli ọ́ kpẹ ẹ shitọ odẹ unuẹkpẹ ni a lu Isomhotse e lema, oni ingme o sha ọgbọkpa abọ, ẹa lẹsẹ abi ọ li kia. ");
INSERT INTO atgNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Abi ọni ọmọse ọ li mu iPita ali iJọni mhuẹ eghọ, ọshabọ o sha eni ebubu ẹgbọ, e kpikpi fiẹ deba wẹ ya lo arakpha ni a lu Arakpha oyi iSolomoni ni o la oni Owa Oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Abi iPita ọ rọ mẹ abi eni ẹgbọ ee li, ọọ wẹ. “Ẹẹ ẹgbọ iZirẹni, elọ o zẹ ni onana o rọ lighọ ri abọ sha ẹ ni a rọ lina a bino anye abinẹ khi ekpabọ ali ipfuasẹ eyi anye, anye rọ rọli ze? ");
INSERT INTO atgNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ẹshinẹgba ọyi Aburaamu, ali Aziki ali iGiekọpu, ni ọ khi Ẹshinẹgba oyi itita awa, ọ she ri ufumhi oyọli na iJesu, Ọni ọọ ga li. Ama eri a rue ọli na ena omhẹsẹ, a kie ọli odalo oyi iPaleti abi ọ tseku mhọli ọli shi udu khi lọli ya rue ọli obọ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A kie iJesu ọni ọ pfuasẹ ali ọni ọ guẹ ẹ ngeli, a ri ochoghọ liẹ iPaleti ọ rue ọgbọ ni ọ gbe ugbeli abọ-a na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ama a gbe ọgbọ ni ọ ri ọgbọ a je agbọ-a. Ama Ẹshinẹgba ọ gbo guise ọli le abi ọ rọ ghua. Anye aava anye mẹ ọli abi ọ rọ guale, anye rọ pfi ọtsẹlẹ shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Itobọ ekpabọ ni e la eva oyi iJesu anye rọ dobẹ ri ọmọse ọna ni a lẹsẹ ni a fẹli ena ze, oni irudunga oyi ọni ọmọse lọli o zẹ khi ọ ga ze pfo nya ni a ga mẹ memena. ");
INSERT INTO atgNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Inyọghuo-mhẹ, mhi lẹsẹ khi emini ẹẹ ali eni e ralo na ẹ a riẹlẹ iJesu, khi elemhi umhalẹsẹ a te riẹlẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ina Ẹshinẹgba ọ li ri ungmemhi oyọli ya tsẹ, oni ọ rọte ekẹ rọte unu oyi emekẹguele ngme khi iKirisiti ọ ya mẹ osoli. ");
INSERT INTO atgNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","A zọnọ khasẹ Ẹshinẹgba khi a pfidọ, ni a mu pfi deba Ẹshinẹgba, ni ọ shishi olamhẹ eyẹ ẹ a, Ini a lighọ, ẹghẹghẹ iyẹmhẹa o ya rọte obọ oyi Ọnọmhuẹ bhale deba ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ini ọọ ghie ọni ọ shobọ bhale agbọ ghi awa kpa, ikhi iJesu, ọni Ọmiepfuese. ");
INSERT INTO atgNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","IJesu ọ mema ya kie la obini iloghie ramhi ẹghẹghẹ ni Ẹshinẹgba ọ rọ ya mu emhikpa pfi gbo mele enegbọ-a, abi Ẹshinẹgba ọ li rọte unu oyi emekẹguele eni e pfuasẹ eyọli shobọ na awa ẹghẹghẹ ni o dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","IMosisi ọ ngme ọli, ọọ, ‘Ọnọmhuẹ Ẹshinẹgba ọyẹẹ ọ ya rọte iteva oyẹẹ mu Ọmekẹguele nabi mhẹmhẹ vule na ẹ. A ya mema ri esọ shi ingmemhi ni ọ ya gueyẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ọni ọa da ri esọ shi ọli ọ, Ẹshinẹgba ọ ya khi ọli ẹgbọ eyọli ku-a.’ ");
INSERT INTO atgNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Egbegbọ lọ khi emekẹguele nya rọte iSamuẹ ya je odalo, e kpẹ ngme emini a ya mẹ ẹghẹghẹ oyawa shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Emini eni emekẹguele enana e ngme, ẹẹ o gọ lu, a li mhọli okemhi shi ishobọ ni Ẹshinẹgba ọ shi na itita ẹ, ni ọ la liẹ Aburaamu, ‘Mhi ya rọte obọ oyi imimi ẹ khi vọsẹ na ẹgbọ na agbọ nya.’ ");
INSERT INTO atgNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abi Ẹshinẹgba ọ rọ mu Ọni ọọ ga oyọli vule, Ọ te ododẹ ghie ọli ghi ẹ ni ọ khi vọsẹ na ẹ abi ọ rọ mu ẹ nyenẹ lase ingmobe eyẹ ẹ le.” ");
INSERT INTO atgNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Abi iPita ali iJọni e kie nu eni ẹgbọ ọ ngme, eni ẹẹ khekhẹ oni Owa Oyi Ẹshinẹgba ali ẹgbọ iSadusisi eghuo e bhale deba iPita ali iJọni. ");
INSERT INTO atgNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Elemhi e bi wẹ itobọ khi eni ighiusomhi na kẹẹ eyi iJesu ee sẹsẹ eni ẹgbọ khi iJesu ọ rọte eghuli guale. Eri onana guele khi ẹgbọ eni e ghu-a khi e gbo ya rọte eva oyi iJesu guale. ");
INSERT INTO atgNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ighọ eni ẹgbọ e li mu iPita ali iJọni, irari obili o she bi ẹlẹghọ, e mu wẹ shi owa ighumha ramhi ogbeakọlọ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ama ebubu ẹgbọ ni e suọ ingme ni iPita ọ ngme e mie iJesu suọ. Emọse ni e ke miesuọ e ya khi ẹgbọ agbẹlẹ ishe. ");
INSERT INTO atgNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ogbeakọlọ, eni ẹẹ mhẹsẹ eyi iJu ali eni egbhali ali esẹsẹ Ishi eyi iMosisi eyi ẹgbọ iJu e legba iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","E ya mẹ Ọga ọyi ekpodalo ugamhi ni a lu Anasi ali iKefasi, ali iJọni ali Alẹzada ali ena ọmhuẹ-apfẹ oyi Ọga ọyi eni ẹẹ ralo ugamhi. ");
INSERT INTO atgNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ighọ e mu iPita ali iJọni bhale iteva oyẹwẹ migha. E mhila wẹ, “Ekpabọ nabisẹ ali eva oyọghuo a rọ gbe akanya ona?” ");
INSERT INTO atgNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ighọ iPita ni Ayẹmhẹ-nọ-pfuasẹ o vọ egbe ọ wẹ: “Ẹẹ enighie eyi ẹgbọ ali egbhali, ");
INSERT INTO atgNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","A mhila anye amo akanya onete ni a gbe na ọni ọ guọghọ-a ọna, ali abi a li rọ ọli toto. ");
INSERT INTO atgNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Emhi oghuo o la ọ ni anye ya gueyẹ ẹ ali ẹgbọ iZirẹni nya. Itobọ eva oyi iJesu iKirisiti ọnge iNazarẹti, ọmọse ona ọ rọ migha iteva oyẹẹ ni ọ rọ toto ngmala ena. Lọli ọ khi ọni iJesu ni a ta ma apfida, ni Ẹshinẹgba ọ rọte eghuli guise le. ");
INSERT INTO atgNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","IJesu khi ọgbọ ni Ebe-no-pfuasẹ o ngme ni ọọ, “ ‘Ẹchẹ ni itsọna e kie pfia, o tigbe mele oni ẹchẹli ẹbẹ ni o mu ẹloe nẹ nya-a.’ ");
INSERT INTO atgNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Imiepfuese ọa la obọ oyi ọgbọlese, irari khi eva olese ọa la ni Ẹshinẹgba ọ rọ na ọgbọkhọghuo elemhi agbọ onana ni awa ya te mhọli imiepfuese.” ");
INSERT INTO atgNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Abi eni ẹẹ mhẹsẹ na ẹgbọ iJu e rọ mẹ igbedu ni iPita ali iJọni e mhọli, ni e rọ ya lẹsẹ khi ẹgbọ tsẹ ni ẹa ye owa ebe e khi, abọ e sha wẹ, e mẹ-wẹ-mẹ khi e kpẹ nu iJesu u kia. ");
INSERT INTO atgNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ama, abi e rọ mẹ ọmọse ni a rọ ze khi ọ nu wẹ migha aghọ, ẹa ke mhuẹ abi e ya ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","E gueyẹ wẹ e vu wẹwẹ iteva lase ne, ighọ e li nu egbewẹ ye ochi. ");
INSERT INTO atgNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ẹẹ, “Sẹ awa ya li eni emọse ena?” Ẹgbọkpa ni e la iJerusalẹmu e she lẹsẹ ikanya ọnyaloa ni e gbe, ọa zẹ awa ya tia. ");
INSERT INTO atgNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ini ingme ona o khi gbekẹ-a, awa mema tse agua yẹ wẹ e khi gbo gbudu ri eva oyi iJesu nu ọgbọkhọghuo ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ighọ e lu iPita ali iJọni nyenẹ egbe bhale elemhi oni owa ugamhi, e gueyẹ wẹ e khi mẹ emini o rẹ wẹ gbo gbudu ri eva oyi iJesu nu ọgbọkhọghuo ngme wẹkhi irọli sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama iPita ali iJọni ẹẹ wẹ, “Ẹẹ a sọ ọ ghue, ini o ya ti Ẹshinẹgba ẹloe, ini ẹẹ o fẹ ti ni anye suọ esọ na, ocho ni anye kha rọ suọ esọ na Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Irari khi aa tigbe ya mẹ khi anye ẹa ya gueyẹ ẹgbọ emini anye mẹ ni anye suọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Abi e rọ nyamhise wẹ alo se, e zẹwẹ obọ vu. E mẹ khi ẹa zẹ wẹ ya nasẹ itobọ khi ẹgbọ ni e la aghọ nya ee kuẹghiẹ Ẹshinẹgba shi itobọ ọmọse ni ọa kpẹ dobẹ ẹ kia ni e rọ ze. ");
INSERT INTO atgNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Irari khi ọni ọmọse ni a ri akanya ọnyaloa rọ ze ọ dọsẹ ikpe egbhuẹva. ");
INSERT INTO atgNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Abi a rọ rue iPita ali iJọni abọ-a, e lẹ deba apfẹwẹ. E gueyẹ wẹ abi ighie eyi ekpodalo-ugamhi ali egbhali e ngme ẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Abi e rọ suọ ona, e ku unu a nyogho lema Ẹshinẹgba, ẹẹ, “Ọnọmhuẹ, yẹyẹ u ma ekẹ ali ukhuli ali okẹ oniẹmhi ali emini e la elemhi wẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yẹyẹ u ri Ayẹmhẹ-nọ-pfuasẹ rọte unu oyi oghie iDefidi ita anye ni ọ khi ọni ọọ ga oyẹ liẹ, “ ‘Elọ o zẹ ni ishishi ẹgbọ e rọ ọ nyaghu ni ẹgbọ e rọ ọ dọmhi mhẹ shi afuẹ? ");
INSERT INTO atgNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ni ighie ni e la agbọ e rọ mu egbe shi okhọli, ẹgbọ eni ẹẹ mhẹsẹ e tigbili ni e rọ mu okhọli vule shi Ẹshinẹgba Ọnọmhuẹ ọ, ali iKirisiti ni ọ she zẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Esheshi ghọ Erọdu ali iPọtiusi iPaleti e ya nu ẹgbọ iJẹta ali ẹgbọ iZirẹni lona kugbe elemhi oni ẹoli ona. E gba kugbe, e gbe iJesu ọni ọọ ga ọyẹ-a, ọni u zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","E riẹlẹ emini u ri ekpabọ ali ọghuẹmhẹ oyẹ gba shi ekẹ khi a ya mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ama memena, Ọnọmhuẹ, bino abi e liẹ dọmhi, ni u ri ekpabọ na anye eni ẹẹ ga eyẹ, ni anye gbe udu ke ngme ungmemhi oyẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nise obọ-a ri ẹgbọ ke ze, u gbolo ẹ gbe ọlẹlẹ ọnyaloa ali ọshabọ rọte eva oyi iJesu Ọni ọọ ga ni ọ pfuasẹ oyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Abi e rọ lema se, elemhi owa ni e la oo jighise, Ayẹmhẹ-nọ-pfuasẹ o tiemhie shi wẹ ọ, ọ ri igbedu na wẹ ẹ ngme ungmemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Igbaa oyi eni e mie iJesu iKirisiti suọ e mhọli udu ali usamhi oghuo. Ọngẹwẹ ọa ke liẹ khi eri lọli mhọli emhikhọghuo ọtsobọ oyẹluẹ, ama eri e ku emhikpa gbe ke mhọli. ");
INSERT INTO atgNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Eni ighiusomhi na kẹẹ e ri ekpabọ ọ pfi ọtsẹlẹ je odalo shi ungmemhi irọte-eghuli guale oyi iJesu Ọnọmhuẹ. Ẹgbọ nya e mu ekpẹ ẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Aa mẹ ọngẹwẹ ni emhikhọghuo o to. Irari khi ẹghẹghẹ kpa, eni e mhọli ekẹ ali apfẹ e rọ rẹwẹ ẹ dẹ, e rue eni ikpaghọ ni e rẹ wẹ dẹ bhale ufuẹgẹ oyi ighiusomhi na kẹẹ. E kemhi wẹ na ọgbọgbọ abi o li to ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ighọ iJosẹfu ni ọ khi unuẹkpẹ oyi iLiva, ni a bia shi ekẹ iSapurọsi. IBanabasi, eni ighiusomhi na kẹẹ ee lu ọli. Emini a ri eva ona ngme khi Ọrudushi-ẹgbọ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","IBanabasi ọ ri ekẹ ni ọ mhọli dẹ, ọ rue eni ikpaghọ ni ọ rọli dẹ bhale ya shi ufuẹgẹ oyi ighiusomhi na kẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ọmọse ọghuo ọ la ọ ni a lu Ananayasi ali ughuẹ ọli iSafira, e ku abọ gbe ri ekẹ oyẹwẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ọ te eni ikpaghọ ni ọ ri oni ekẹ dẹ rue sheli na egbọli, ughuẹ ọ lama shi ọli ọ. Ọ tsua ikhukhui eni ikpaghọ ghi ighiusomhi na kẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ighọ iPita ọọ, “Ananayasi, elọ o zẹ ni u rọ zẹ ni ọkphaghiẹ ọ lo ẹ udu, ni u rọ lo ẹgbhọli khasẹ Ayẹmhẹ-nọ-pfuasẹ, ni u rọ rọte eni ikpaghọ ni u ri oni ekẹ dẹ rue shi na egbe ẹ? ");
INSERT INTO atgNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ọ́á khi oyẹ oni ekẹ o khi neni u rọli dẹ? Abi u rọ rọli dẹ se, eni ikpaghọ ẹa kie khili eyẹ? Elọ o rẹẹ sa usamhi onana? Ọa khi ọgbọ u lo ẹgbhọli khasẹ ama Ẹshinẹgba!” ");
INSERT INTO atgNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Abi Ananayasi ọ rọ suọ ungmemhi ona se, ọ de ekẹ, ọ ghua. Ulishi oniẹmhi o ku rughu ẹgbọ kpa ni e suọ emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ighọ izẹo e rọte iteva oyẹwẹ fiẹ lasele ya ri ide khuli olimhi oyọli, e tsua li fiẹ je olase ya rọ tọ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iwakati esẹ e lẹsẹ na dọsẹ te, ughuẹ ọli ọ lole, ọa lẹsẹ emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","IPita ọ mhila li, ọọ, “Gueyẹ mhẹ ghue, ingme ni yẹyẹ ali Ananayasi ọdọẹ a ri oni ekẹ dẹ na?” Ọọ li, “Ii.” “Ighọ anye ri oni ekẹ dẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","IPita ọọ, “Sẹ ẹẹ ava-ava a li yemhẹ shi oghuo ni a mhẹsẹ Ayẹmhẹ-nọ-pfuasẹ bino? Emọse ni e tsua ọdọẹ ya tọ lẹna e la odẹ kia bhale. Wẹwẹ e gbo li tsuẹ ya tọ!” ");
INSERT INTO atgNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Utoghuokpe ọ de ekẹ, ọ ghua. Eni emọse e bhale, e ya ẹ khi ọ she ghua, ighọ e tsua li ya tọ mama ọdọli. ");
INSERT INTO atgNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ulishi oniẹmhi o mu igbaa oyi eni e mie iJesu iKirisiti suọ nya ni e suọ emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Eni ighiusomhi na kẹẹ e gbe ebubu ọlẹlẹ ọnyaloa ali ọshabọ ọdọda iteva oyi eni ẹgbọ. Igbaa oyi eni e mie iJesu iKirisiti suọ e lona Arakpha oyi iSolomoni na elemhi Owa Oyi Ẹshinẹgba elemhi ikudugbe. ");
INSERT INTO atgNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ọgbọkhọghuo ọa gbudu kugbe wẹ ọ aboriẹkhia khi ẹgbọ nya e ri ekpẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Abi o riẹ khi ighọ, eri ebubu emọse ali ikpotso elese e mie Ọnọmhuẹ suọ, a ku wẹ ma igbaa oyi eni e mie iJesu iKirisiti suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Irari ikanya ọnyaloa ni ighiusomhi na kẹẹ e gbe, ẹgbọ e tsua ẹgbọ ni ẹa ze bhale odẹ ifu apfẹ rẹwẹ yẹshi ukpho ali iya, ini akphakpha oyi iPita oo nga wẹ egbe ini ọọ dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Olele ẹgbọ e rọte ẹoli ni e la gasẹ iJerusalẹmu bhale. E tsua ẹgbọ ni ẹa ze ali eni e mhọli ayẹmhẹ ọkphaghiẹ bhale, ighọ a ri wẹwẹ nya ze. ");
INSERT INTO atgNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ọga ọyi ekpodalo ugamhi ali apfọli ni e ga rọ la otu oghuo ni a lu otu iSadusisi, e kpe ofuma a deba ighiusomhi na kẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","E muno eni ighiusomhi na kẹẹ ku lo owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama ẹliyọsẹ, agẹni ọ khueghie odẹ oyi oni owa ighumha-a na wẹ, ọ rue wẹ ya lase. ");
INSERT INTO atgNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ọọ wẹ, “A ke vu, a je elemhi ogba na Owa Oyi Ẹshinẹgba ya migha ni a gueyẹ ẹgbọ usomhi onete oyi agbọ onogbọ ona.” ");
INSERT INTO atgNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Abi ogbe o rọ gbe-a, eni ighiusomhi na kẹẹ e dọsẹ lo Owa oyi Ẹshinẹgba, ee sẹsẹ. Abi Ọga ọyi ekpodalo ugamhi ali apfọli ni e rọ ga la otu oghuo e rọ bhale, e lu ilegba oyi eni egbhali eyi ẹgbọ iZirẹni (ni a lu iSaẹdiri), ighọ e lu eni e ri ẹloe ẹ khu owa ighumha e ka wolọ eni ighiusomhi na kẹẹ igha ghi ẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ama abi e rọ ramhi aghọ, e bhale ya ẹ khi eni ighiusomhi na kẹẹ ẹa la oni owa ighumha, ighọ e nyenẹ egbe je ya gueyẹ eni e ghie wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ẹ li, “Anye bhale ya ẹ khi a sọ okpẹ owa ighumha gba-i! Khi ekhekhẹ e migha unu odẹ. Ama abi anye rọ khueghie eni odẹ-a lo elemhi aghọ, anye ẹa mẹ ọgbọkhọghuo elemhi aghọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Abi e rọ suọ ona, abọ e sha oghie ọyi eni ẹ khẹ ekhẹ Owa Oyi Ẹshinẹgba, ali ighie eyi ekpodalo-ugamhi, itobọ khi ẹa dobẹ lẹsẹ udi emini a mẹ ena idiegbe oyi ighiusomhi na kẹẹ. Oni ingme ọa zẹ wẹ sa. ");
INSERT INTO atgNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ighọ ọmọse ọghuo ọ bhale wẹ iteva, ọọ wẹ, “A bino! Ẹgbọ ni a mu shi owa ighumha e la Owa Oyi Ẹshinẹgba a sẹsẹ ẹgbọ!” ");
INSERT INTO atgNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ighọ eni ẹ khẹ ekhẹ e vu ya mu eni ighiusomhi na kẹẹ. Ẹa ri itoto riẹlẹ ọli itobọ khi ulishi eni ẹgbọ o mu wẹ ini ẹ ya tono wẹ echẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","E muno eni ighiusomhi na kẹẹ bhale ya migha agbala, ọni oghie ọyi ekpodalo-ugamhi eyi Ẹshinẹgba ọ mhila wẹ ogbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Anye tse agua gueyẹ ẹ aa khi ke ri eva ona sẹsẹ ẹgbọ. Ama a kiele ẹ sẹsẹ ẹgbọ, osẹsẹ oyẹẹ o gbhiaku ekẹ iJerusalẹmu nya. A yẹsẹ ni ẹgbọ e ya ke dabi khi anye gbe iJesu-a!” ");
INSERT INTO atgNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","IPita ali ighiusomhi na kẹẹ eni e kpọle ẹ wẹ, “Anye mema ya ri oyi Ẹshinẹgba gbe dọsẹ oyi ẹgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ẹshinẹgba ọyi itawa ọ rọte eghuli guise iJesu le, ọni a soli-a shi ọọra gbe-a. ");
INSERT INTO atgNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ẹshinẹgba ọ she yasẹ ọli nga obita ni o pfuasẹ oyọli abi Omi Oghie ali Ọmiepfuese, ni ọọ ri ẹghẹghẹ na iZirẹni gbo mhọli imupfi ali igbekua shi olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Anye khi ọtsẹlẹ shi eni ingme ena nya, ighọ li khi Ayẹmhẹ-nọ-pfuasẹ, ni ọ khi isomhopfa ni Ẹshinẹgba ọ rọna eni e suọ esọ na li. ");
INSERT INTO atgNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Abi e rọ suọ ona, e pfaa, e nono abi e li ya gbolo wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama iGamaliẹ ni ọ khi otu iFarisi ni ọọ sẹsẹ Ishi eyi iMosisi, ni ọ khi ọni ẹgbọ e ri ekpẹ ẹ na, ọ vule migha elemhi oni igbaa oyi eni egbhali, ọ a wolọ wẹ fiẹ ne ukuku ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ighọ ọọ wẹ, “Ẹẹ emọse iZirẹni a kuegbe-a sa emini a nono khi a ya riẹlẹ eni emọse ena. ");
INSERT INTO atgNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ẹghẹghẹ ni o dọsẹ, ọmọse ọghuo ni a lu iTeudasi ọ lasele, ọọ lu egbọli emhi, ẹgbọ egbhuẹshe asha ene e kpikpi deba li. Abi a rọ gbe ọli-a, ẹgbọ eyọli e gbhiaku-a, oni okiali oyọli o mele afuẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","IJudasi ọngi iGalili ọ gbo lasele ẹghẹghẹ ni a rọ leli ẹgbọ, lọli ali ẹgbọ eyọli e pfi onyaghu. Abi a rọ gbe ọli a ẹgbọ eyọli e gbhiaku-a. ");
INSERT INTO atgNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Irarighọ, mhi ye ẹ ude shi idiegbe oyi ẹgbọ ena, a zẹ wẹ obọ! Zẹ wẹ obọ ni e vu! Ini emini e rọ bhale khi obọ oyi ọgbọ o te bhale, e ya de. ");
INSERT INTO atgNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama ini o khi obọ oyi Ẹshinẹgba o te bhale, aa ya tigbe dobẹ mu wẹ gba, ama khi Ẹshinẹgba a nu ẹ khọli.” ");
INSERT INTO atgNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Oni ungmemhi ni ọ ngme o lo wẹ udu. E lu eni ighiusomhi na kẹẹ lasele, e gbe wẹ itali, e gueyẹ wẹ e khi ke ngme ingme oyi iJesu, e zẹ wẹ obọ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Eni ighiusomhi na kẹẹ e rọte aghọ vu, ee ghẹlẹ khi wẹwẹ e li tẹ ọ na ri omama a mu shi eva oyi iJesu. ");
INSERT INTO atgNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ẹa tigbe yẹmhẹ-a, ogbẹlẹ kpa e rọ ọ sẹsẹ, ni e gbo rọ ọ tse abọ usomhi onete khi iJesu ọ khi Ọmiepfuese, elemhi ọgba na Owa oyi Ẹshinẹgba ali rọte owa ya je owa. ");
INSERT INTO atgNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ẹghẹghẹ ni a ngme ena khi igbaa oyi eni e mie iJesu iKirisiti suọ khi ee ke bu shi ọ, ẹgbọ iJu eni ee ngme ẹlẹmhi iGiriki elemhi wẹ, ee wọlọ khi ẹgbọ iJu eni ẹẹ ngme ẹlẹmhi Iburu, e ri ukpẹloe ẹ gbe esamhi-olimhi eyi wẹwẹ ini ẹẹ kemhi eminale ogbẹlẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ighọ ighiusomhi ogbava e luno igbaa oyi eni e mie iJesu iKirisiti suọ nya kugbe, ẹẹ wẹ, “Ọa ti ni anye pfi akanya itsabọ ungmemhi oyi Ẹshinẹgba shi ekẹ, ni anye sọ alo ghue eminale ikemhi. ");
INSERT INTO atgNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","A zẹ emọse oshilua elemhi iteva oyẹ ẹ, ni a lẹsẹ khi e mhọli Ayẹmhẹ-nọ-pfuasẹ ali ilẹsingme. Ni awa ri akanya irẹloe-khu ingme eminale ali itsua ikemhi na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Isheghọ, ni anye mẹ asha ri ẹloe shi iromhi isọsọ ali itsabọ usomhi onete.” ");
INSERT INTO atgNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Oni akhọkhọmhẹ ona o ga ghọle ẹgbọ kpa ni e le gba. E zẹ iSitivini ni ọ mhọli irudunga ali Ayẹmhẹ-nọ-pfuasẹ, ali iFilipu, ali iPirokorusi, ali iNikanọ, ali iTimọni, ali iPamẹnasi, ali iNikolasi ni ọ khi ọngi Atiọki ni a mu pfi je irudunga oyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","E ri ẹgbọ ena khasẹ eni ighiusomhi na kẹẹ, eni ighiusomhi na kẹẹ e ri abọ nga wẹ ukhomhi lema na. ");
INSERT INTO atgNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ighọ ungmemhi oyi Ẹshinẹgba oo gẹ shi ọ. Igbaa oyi eni e mie iJesu iKirisiti suọ e bu shi ọ elemhi iJerusalẹmu. Ebubu ekpodalo-ugamhi eyi Ẹshinẹgba e lama shi oni irudunga. ");
INSERT INTO atgNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ISitivini, ọmọse ni Ẹshinẹgba ọ khivọsẹ na, ọ mhọli ekpabọ oyi Ẹshinẹgba rọ gbe ikanya ọnyaloa ali ọshabọ iteva oyi ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama ẹgbọ eghuo ni e khi igbhogbho na owa ugamhi oyi eni e kpẹ khi ighumha, e nu iSitivini i khakọ. IJu eni ẹgbọ ena e khi ni e rọte ekẹ iSairini, ali Alẹzadira bhale ali eni e rọte ekẹ iSilisha ali Esha bhale, ni e ke ngeli iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama ẹa dobẹ nu ilẹsingme ali Ayẹmhẹ ni ọ rọ ọ ngme khẹ abọ. ");
INSERT INTO atgNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ighọ e bẹna tanọ shi ẹgbọ eghuo elemhi, e liẹ, “Anye suọ abi iSitivini ọ rọ pfi unu-a deba iMosisi ali Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ighọ e ngmiasẹ eni ẹgbọ ali eni egbhali ali eni ẹ sẹsẹ Ishi eyi iMosisi. E mu iSitivini bhale ilegba oyi eni ẹẹ mhẹsẹ ali esọ-ẹzọ eyi ẹgbọ iJu ni a lu iSaẹdiri. ");
INSERT INTO atgNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","E wolọ ẹgbọ lasele ni e pfi ọtsẹlẹ ẹgbhọli khi, “Ọmọse ọna ọa tigbe yẹmhẹ-a ingme-ingmemhi ipfiunu-a ni ọ ngme ẹ deba Owa Oyi Ẹshinẹgba no pfuasẹ ali ushi. ");
INSERT INTO atgNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Irari khi anye suọ khi ọọ li khi iJesu ọnge iNazarẹti ọna, ọ ya guọghọ Owa oyi Ẹshinẹgba oyi ẹgbọ iJu-a, ọ ya gbo mu ighuighuẹ ni iMosisi ọ rọ shi ekẹ na anye pfi.” ");
INSERT INTO atgNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ẹgbọ ni e la oni ilegba nya ee bino iSitivini, e mẹ khi alo eyọli e gẹ nyanyanya abi alo eyi agẹni. ");
INSERT INTO atgNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ighọ Ọga ọyi ekpodalo ugamhi ọ mhila li, ọọ li, “Igẹsikia ingme ni a gue shi ẹ egbe ena e khi?” ");
INSERT INTO atgNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ISitivini ọọ li, “Inyọghuo ali ita ni e le gba, a ri esọ shi mhẹ ekẹ! Ẹshinẹgba ni ọ mhọli ufumhi, ọ ri egbe khasẹ ita awa Aburaamu abi ọ rọ kie la ekẹ iMẹsopotemia, neni ọ tigbe je ẹoli Arani ya la. ");
INSERT INTO atgNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ẹshinẹgba ọọ li, ‘Lase ekẹ ali iteva oyi ẹgbọ eyẹ le, ke je ekẹ ni mhi ya rọkhasẹ ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ighọ ọ rọte oni ekẹ iKadia vu ya la ẹoli Arani. Abi itali ọ rọ ghu-a se, Ẹshinẹgba ọ ghie ọli je ekẹ ni a ngeli ogbe namo. ");
INSERT INTO atgNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ọa ri ugu okhọghuo akana na li, wẹkhi ukuku ekẹ okhọghuo ọ khi na li. Ama khi Ẹshinẹgba ọ she kpẹ shobọ na li khi lọli ali imimi ọli, e ya le ugu oni ekẹ, abi o rọ tseku khia khi ẹghẹghẹ aghọ Aburaamu ọa bia ọmọ ọkhọghuo ne. ");
INSERT INTO atgNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ina Ẹshinẹgba ọ li nu ọli ngme. ‘Imimiẹ e ya khi epfẹse shi ekẹ ni ọa khi oyẹwẹ, e ya khi ighumha, a nasẹ wẹ elemhi ikpe egbhuẹshe asha ene. ");
INSERT INTO atgNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ẹshinẹgba ọọ, ama mhi ya nasẹ ushishi ni e ya muno wẹ ighumha. Ini mhi nasẹ wẹ na wẹ se, e ya rọte ushishi oghọ lasele bhale ekẹ ona ya ngeli, e gbo la akana a ga mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ighọ Ẹshinẹgba ọ nu Aburaamu shobọ ishẹlẹ-a ni o ya khi irọkhasẹ khi ọgbọ ọ mhuẹ obọ shi oni ishobọ. Ighọ Aburaamu ọ bia Aziki, ọ shẹlẹ ọli-a abi ọ rọ gbe ogbẹlẹ elele. Ighọ Aziki ọ gbo li khi ita iGiekọpu, iGiekọpu ọ gbo li khi ita emọse ogbava ni e khi ititawa. ");
INSERT INTO atgNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Itobọ khi eni imi iGiekọpu ee dọ iJosẹfu ọkọnyọ, e rọli dẹ abi oghumha ya je ekẹ iJipiti. Ama Ẹshinẹgba ọ nu ọli la. ");
INSERT INTO atgNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ọ tsumhi ọli obọ ikphakphamhẹ nya. Ọ ri ilẹsingme na iJosẹfu, ọ gbo kpaghiẹ ọli obọ ni ingme oyọli o rọ ghọle iFero ni ọ khi oghie ọyi ekẹ iJipiti. Ighọ ọni oghie ọ rọli leghie ukhomhi iJipiti ali agbala oyọli nya. ");
INSERT INTO atgNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ighọ okiamhi oniẹmhi o la ekẹ iJipiti ali iKena a pfi ni o pfi osoli oniẹmhi na ititawa ni ẹa ke rọ mẹ eminale e le. ");
INSERT INTO atgNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Abi iGiekọpu ọ rọ suọ khi eminale e kpọku shi ekẹ iJipiti, ọ ghie imiọli ni e khi ititawa je oobọ ya bino ododẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Utonuzeva ni e ke ye, ọni iJosẹfu ọ gueyẹ inyọghuo ọli ọni lọli khi, aghọ iFero ọ la lẹsẹ ẹgbọ eyi iJosẹfu. ");
INSERT INTO atgNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ighọ iJosẹfu ọ ghie ya rue itali iGiekọpu ali ẹgbọ eyọli nya ni e kugbe khi oshe ẹa la egbhuẹne. ");
INSERT INTO atgNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ighọ iGiekọpu ọ je ekẹ iJipiti, ashini lọli ali ititawa e ghu-a shi. ");
INSERT INTO atgNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A tsua ilimhi eyẹwẹ nyenẹ egbe je iShẹkẹmu ya rọ tọ uji ni Aburaamu ọ ri ikpaghọ nu unuẹkpẹ oyi Amọni dẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abi oni ẹghẹghẹ o rọ ti ramhi ni Ẹshinẹgba ọ rọ ya ri ishobọ oyọli tsẹ na Aburaamu, ẹgbọ eyawa ni e la iJipiti e lolo bu shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ighọ oghie ọlese ni ọa lẹsẹ emhikhọghuo ingme oyi iJosẹfu ọ ke la ukpẹkhomhi shi ekẹ iJipiti. ");
INSERT INTO atgNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ọọ na ẹgbọ eyawa osoli obe, ọ jili ititawa, ọ ri itoto liẹ wẹ, e pfino imiwẹ kua ni eni eniyẹ e ba ghuloa. ");
INSERT INTO atgNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Oni ẹghẹghẹ a rọ bia iMosisi, ni ọa khi ọmọ na tsẹ. A la owa oyi itali kuẹlẹ ọli iki esẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Abi ẹẹ ke rọ dobẹ rọli sheli, e rue ọli ya shi epfẹ okẹ. Omi iFero ni ọkpotso ọ mẹ ọli rue, ọ kuẹlẹ ọli abi omi ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","IMosisi ọ wẹna owẹna ali ilẹsingme oyi iJipiti, ekpabọ o la ẹmuẹ oyọli ali emini ọọ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Abi iMosisi ọ rọ gbe ikpe egbhuẹva, ọ mhọli shi udu khi lọli lẹ ya bino ẹgbọ eyọli ni e khili ẹgbọ iZirẹni. ");
INSERT INTO atgNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ighọ ọ mẹ khi ọngi iJipiti ọọ nasẹ ọngi iZirẹni. Ighọ ọ li ye odọsẹ, ọ gbe ọngi iJipiti-a. ");
INSERT INTO atgNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Eri iMosisi ọ dabi khi ẹgbọ eyẹluẹ e ya mẹ ọli mẹ khi eri Ẹshinẹgba ọ rẹ luẹ ẹ tsumhi ẹgbọ eyọli, ama ẹa lighọ mẹ ọli mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ogbeakọlọ khi iMosisi ọ bhale ya ẹ khi ẹgbọ iZirẹni aava e nu egbewẹ ẹ khọli, ọọ nono ni lọli rẹwẹ riẹlẹ. Ọọ wẹ, ‘Elọ o zẹ ni ẹẹ ni a gbo li khi inyọghuo egbe a rọ nu egbe ẹ a khọli?’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ama ọni ọa guẹli ni ọ la ọ ọ ghi iMosisi abọ pfia, ọọ li, ‘Ọghuo ọ rẹ khi ọni ọọ mhẹsẹ na anye ali ọni ọọ sọ ẹzọ na anye? ");
INSERT INTO atgNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Eri u wa nono ni u li gbe mhẹ-a abi u li gbe ọngi iJipiti a oodẹ?’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Abi iMosisi ọ rọ suọ ona, ọ na pfia je ekẹ oyi iMidiani ya la abi ọpfẹse, ọ bia eniyẹ aava shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ikpe egbhuẹva e dọsẹ se, agẹni ọ ri egbe khasẹ iMosisi elemhi ẹlẹmhi erali ni oo to ukhomhi ebuli. ");
INSERT INTO atgNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","IMosisi ọ mẹ ọli, o sha li abọ. Ọọ lẹ ni ọ ya bino, uruli oyi Ọnọmhuẹ o lu ọli, ọọ li, ");
INSERT INTO atgNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mhẹmhẹ mhi khi Ẹshinẹgba ọyi itita ẹ, Ẹshinẹgba ọyi Aburaamu ali ọyi Aziki, ali ọyi iGiekọpu.’ IMosisi ọọ guọ elemhi ulishi, ọa ke gbudu bino oobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ọnọmhuẹ ọọ li, ‘Gueghie ekuẹ ni u sọ, ekẹ ni o pfuasẹ u migha. ");
INSERT INTO atgNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mhi she mẹ ajilimhẹ ni ẹgbọ eyẹmhẹ ni e la iJipiti ẹ mẹ memena. Mhi she suọ ekperumhẹ oyẹwẹ, mhi she bhale ya mie wẹ pfuese. Bhale memena khi mhi ya ghie ẹ nyenẹ egbe je ekẹ iJipiti.’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ọni iMosisi ọna ẹgbọ eyọli e ke ekpẹ kie, ni ẹẹ ọ li, ‘Ọghuo ọ rẹ khi ọni ọ mhẹsẹ ẹ na anye ali ọni ọọ sọ ẹzọ ọyi anye?’ Ẹshinẹgba lọlighuo ọ ri agẹni ni ọ ri egbe khasẹ ọli elemhi ẹlẹmhi erali ni e to ghie iMosisi ọ ka khi ọni ọọ mhẹsẹ ali ọmiepfuese ọyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Lọli ọ rẹwẹ ya fiẹ lase ekẹ iJipiti, ọ la ekẹ iJipiti ali obini Okẹ Ifulọ ali udu oyẹmhi elemhi ikpe egbhuẹva gbe akanya ọnyaloa ali irọkhasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“IMosisi lọlighuo ọọ ẹgbọ iZirẹni, ‘Ẹshinẹgba ọ ya rọte elemhi ẹ ghie ọmekẹguele ọnabi mhẹmhẹ ghi ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ọ la iteva ebubu ẹgbọ elemhi udu oyẹmhi, li shi agẹni ni ọ ke nu ọli ngme ukhomhi ute iSinai, li she ititawa, ọ mie ungmemhi ni o ri agbọ ọ na ọgbọ, ọ rue ọli na awa. ");
INSERT INTO atgNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ama eni ititawa ẹa nono ni wẹwẹ e suọ esọ na li, eri e kie iMosisi, e ri udu oyẹwẹ nyenẹ egbe ukhokho je ekẹ iJipiti. ");
INSERT INTO atgNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ẹẹ Erọni, ‘Mama ikhumhi na anye ni e ya ri anye ke kia, irari khi anye ẹa lẹsẹ abi iMosisi ni ọ rue anye te iJipiti lasele ọ ke li kia.’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Oni ẹghẹghẹ eni ẹgbọ e rọ mama ikhumhi ni o li abi ozele ena, ee luasẹ ọli, e ghẹlẹ shi oni ikhumhi ni e ri abọ eyẹwẹ mama. ");
INSERT INTO atgNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ighọ Ẹshinẹgba ọ sọ ukhokho gbe wẹ, ọ zẹ ni e ga ovọ, ali uki, ali ikpẹtata abi a li kẹkẹ ọli shi ebe emekẹguele, ni ọọ: “ ‘Ẹẹ ẹgbọ iZirẹni, abi a rọ la udu oyẹmhi ikpe egbhuẹva a luasobo, mhẹmhẹ a ri iluasobo na? ");
INSERT INTO atgNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A yasẹ okula oyi ikhumhi iMolẹki ali ukpẹtata oyi iRefani, ni e khi ikhumhi ni a ri abọ mama ni a ga. Irarighọ, mhi ya ri ẹgbọ bhale ya mu ẹ okhọli vu, e tsua ẹ dọsẹ obini ekẹ iBabilọ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ititawa e mhọli igholo oyi ọtsẹlẹ obini elemhi udu oyẹmhi. Abi Ẹshinẹgba ọ li khọkhọ li ye iMosisi, ighọ ọ li riẹlẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Abi e rọ le oni igholo ugu se, iJoshua ọ tsua li ma egbe bhale ekẹ oyi ishishi ni Ẹshinẹgba ọ khu kua na wẹ. O nu wẹ la ramhi ẹghẹghẹ oyi iDefidi. ");
INSERT INTO atgNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","IDefidi ni Ẹshinẹgba ọ ri afu na ọ mhila li ini lọli tọ owa na Ẹshinẹgba ọyi iGiekọpu ");
INSERT INTO atgNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama iSolomoni ọ tọ owa na Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Abibi o ririẹ li, a lẹsẹ khi Ẹshinẹgba nọ Yagha nẹ Nya ọa ya la owa ni ẹgbọ e ri abọ tọ. Lọli o zẹ khi Azaya ọmekẹguele ọ guele khi. ");
INSERT INTO atgNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ẹshinẹgba ọọ, ‘Iloghie o khi ukpẹkhomhi ni mhia shitọ. Ekẹ agbọ o khi akphawẹ-nga oyẹmhẹ. Owa nabisẹ ẹẹ ẹgbọ a ya tigbe tọ na mhẹ? Asha no ghuo o ya gua mhẹ la? ");
INSERT INTO atgNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ọa khi mhẹmhẹ-ghuo mhi ma eni emhi ena nya?’ ");
INSERT INTO atgNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ẹẹ ẹgbọ usuesọ-akhuẹ ni e zese udu oyẹwẹ-a khali igba zuse esọ. A li abi itita ẹ, ni e kie Ayẹmhẹ-nọ-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A famhi mẹ ọmekẹguele ọkhọghuo ni itita ẹ ẹa mu okhọli vule shi ọ? Eri e gbo gbolo eghuo-a, ni e mẹ ekẹ guele khi, Ọni ọọ suọ esọ na Ẹshinẹgba ọ ya bhale. Memena ẹẹ a she rọ ọni iKirisiti ọna dẹ, a gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ẹẹ ni a rọte obọ oyi agẹni ni Ẹshinẹgba ọ ghie mie ishi, ẹẹ áà kie gbo ri eni ishi gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Abi eni igbaa eyi iSahẹdiri e rọ suọ ingmemhi ena, e pfaa na li ramhi ni e rọ gbe akọ akọ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama iStivini ni ọ mhọli Ayẹmhẹ-nọ-pfuasẹ ọ yasẹ alo idane, ighọ ọ mẹ ugẹmhi oyi ufumhi oyi Ẹshinẹgba, ali iJesu khi ọ migha obita oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ighọ iSitivini ọọ, “Mhi mẹ khi iloghie o khueghie-a, mhi gbo mẹ iJesu ọni Omi Ọgbọ khi ọ migha obita oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Abi eni igbaa eyi eni iSahẹdiri e rọ suọ ona, e ri abọ khukhu esọ. Ẹ tsẹsẹ leghe, e vẹ rughu ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","E tialọ ọli fiẹ ifuapfẹ je ukhokho oni ẹoli, ee tono ọli echẹ. Eni ee tono ọli echẹ e gueghie itsua ni e sọ na ọmọse ọghuo ni a lu iSọlu mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Abi e rọ ọ tono iSitivini echẹ, ọ sọ iromhi, ọọ, “IJesu Ọnọmhuẹ, kpẹkpẹ kpe abọ mie ayẹmhẹ oyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ọ de wugha, ọ tsẹsẹ, ọọ li, “Ọnọmhuẹ, kpẹkpẹ khi ri olamhẹ ona mu ota sọ wẹ.” Abi ọ rọ ngme ona se, ọ ghua. ");
INSERT INTO atgNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ighọ iSọlu ọ migha wẹ ukhokho shi igbe-a oyi iSitivini. Abi iSitivini ọ rọ ghu-a se, ẹgbọ eghuo ni e mhọli ulishi oyi Ẹshinẹgba e ya rọli tọ. E viẹ eviẹ oyọli egbegbọ. Ẹlẹghọ ukpokpomhi ajilimhẹ o lasele shi igbaa oyi eni e mie iJesu iKirisiti suọ ni e la ekẹ iJerusalẹmu ọ. Eni ighiusomhi na kẹẹ eghọ e miatsẹ ku ekẹ iJudia ali iSameria. ");
INSERT INTO atgNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ama iSọlu ọ rọshẹka a yese igbaa oyi eni e mie iJesu iKirisiti suọ-a. Ọ kia owa khi owa muno wẹ shi owa ighumha, ghe emọse, ghe ikpotso. ");
INSERT INTO atgNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Igbaa oyi eni e mie iJesu iKirisiti suọ eghọ ni e kia miatsẹ ku, e kia a gue ungmemhi oyi iJesu le asha ni e ramhi kpa. ");
INSERT INTO atgNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","IFilipu o je ekẹ iSameria. Ọ la oobọ ọ gueyẹ ẹgbọ khi iJesu ọ khi iKirisiti ni a shobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Abi ebubu ẹgbọ e rọ mẹ ikanya ọshabọ ni iFilipu ọ gbe, e nyanya mie shi emini ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","IFilipu ọ kha da lema na eni e mhọli ogbhọ ne, eni ẹgbọ e kpa oni ogbhọ pfia. Ebubu eni e guọghọ-a ali eni e ghua e toto nya. ");
INSERT INTO atgNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ukpokpomhi oghẹlẹ o la oni ẹoli oghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ọmọse ọghuo ọ laọ ni a lu iSamọ. Egbegbi ọbo ọ la iSameria ẹ li. Ọ kia ri ọbo ni ọ li tono obọ udu. ");
INSERT INTO atgNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ẹgbọ nya e ri ekpẹ ẹ na li. Ẹgbọ ọdọda ee liẹ li, “Ọmọse ọna Ẹshinẹgba ọ ri ekpabọ nali a gbe ikanya.” E lu ọli ekpabọ ni o fu. ");
INSERT INTO atgNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ingme ni ọ ngme kpa, e rọ ọ shi itobọ ọshabọ ni ọ ri ogbhọ oyọli i gbe ni o she tẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama iFilipu ọ gueyẹ wẹ ingme oyi Eghiele oyi Ẹshinẹgba ali iJesu iKirisiti, e mie shiọ. Ọ batazi wẹ, ghe ikpotso ghe emọse. ");
INSERT INTO atgNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ISamọ ọ li miesuọ, iFilipu ọ li batazi ọli. Ọ deba iFilipu u kiakia irari ikanya ọnyaloa ali ọshabọ nefunẹ ni ọ mẹ khi iFilipu ọ gbe. ");
INSERT INTO atgNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Abi ighiusomhi na kẹẹ ni e la iJerusalẹmu e rọ suọ khi ẹgbọ iSameria e mie ungmemhi oyi Ẹshinẹgba suọ, e ghie iPita ali iJọni ghi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Abi iPita ali iJọni e rọ ramhi iSameria, e sọ iromhi na eni e miesuọ ni e la oobọ Ayẹmhẹ-nọ-pfuasẹ ọ tiemhile shi wẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ayẹmhẹ-nọ-pfuasẹ ọa kie kpẹ tiemhile shi ọngẹ wẹ egbe ne, eri a kpẹ lẹsẹ ri eva oyi iJesu Ọnọmhuẹ batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Abi iPita ali iJọni e rọ ri abọ nga wẹ ukhomhi, Ayẹmhẹ-nọ-pfuasẹ ọ tiemhile shi wẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Abi iSamọ ọ rọ mẹ khi ẹgbọ ni eni ighiusomhi na kẹẹ e ri abọ nga ukhomhi kpa khi e mie Ayẹmhẹ-nọ-pfuasẹ, ọ nise obọ-a ni lọli ri ikpaghọ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ọọ wẹ. “A li ri oni itoto na mhẹ ni mhi ke ri Ayẹmhẹ-nọ-pfuasẹ na ogbọ ini mhi da ri obọ nga li ukhomhi ne.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama iPita ọọ li, “Yẹyẹ ali ikpaghọ eyẹ a li opfu-a, itobọ khi u sa khi u ya dobẹ ri ikpaghọ dẹ isomhopfa oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Itobọ khi u waa mhọli obọ shi akanya onana, irari khi udu oyẹ ọa pfuasẹ deba Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Irarighọ, mu udu pfi deba Ẹshinẹgba. U lema li ni ọ gbe olamhẹ kua nẹ, otsẹ ọ ya gbe isamhi ebe ni u mhọli shi udu kua nẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Itobọ khi mhi she mẹ khi wa a kpe ofuma irari akanya ni anye a gbe ali khi olamhẹ o she dẹ ẹ ighumha.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ISamọ ọọ wẹ. “A kpẹkpẹ a sọ iromhi na mhẹ ini emini a ngme ena e khi tsẹ shi mhẹ egbe ni mhi pfua.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Abi iPita ali iJọni e rọ ngme ingmemhi eyi iJesu se, e mu egbe pfi je iJerusalẹmu, ee gue ungmemhi eyi iJesu kiakia elemhi ebubu inuẹkpẹ ni e la iSameria. ");
INSERT INTO atgNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Agẹni ọyi Ẹshinẹgba ọ gueyẹ iFilipu, ọọ li, “Ke tiemhi ukiẹkiẹ ọgobọ ini a sọ alo ghue obini ovọ o te ẹ lo eko je odẹ ọdagbe ifufu ni o rọte iJerusalẹmu je iGaza.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ighọ iFilipu ọ mu egbe ọọ lẹẹ. Abi ọ li lẹ eghọ, lọli ali ọmọse ọghuo ọngi Ẹtiopia ni ọ khi ọwali e ya lona. Ọmọse ọna ọkhẹmhuẹ ọ khi ni ọ ri ẹloe ẹ khu ẹpfue eyi iKadakhẹ ni ọ khi ọlele ọyi oni ekẹ. Ọ rọte iJerusalẹmu ni ọ je ya ga ugamhi i jele. ");
INSERT INTO atgNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Abi ọ li i je apfẹ eghọ, ọ nga ọkọ ni ichi e rọ ọ na. Ọọ zẹ ebe ni Azaya ọmekẹguele ọ kẹkẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ayẹmhẹ-nọ-pfuasẹ ọ gueyẹ iFilipu, ọọ li. “Je ọkọ oghọ ni u timama li migha.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Abi iFilipu ọ rọ ramhi aghọ, ọ suọ khi ọni ọmọse ọọ zẹ ebe oyi Azaya ọmekẹguele. IFilipu ọ mhila ọni ọmọse. “Ebe ni u wa zẹ eghọ o fẹ lo ẹ esọ?” ");
INSERT INTO atgNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ọọ iFilipu, “Iiye oo. Ọa ya lighọ lo mhẹ esọ ini ọgbọ ọa li gueyẹ mhẹ abi o ngme.” Ọ iFilipu ọ nga oni ọkọ le ni ọ nu luẹ shitọ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ashini ọọ zẹ oni elemhi Ebe-no-pfuasẹ o khi, asha ni ọọ: “Eri a mu ọli abi omi osumha ni a ya fa uruli. Ẹzẹzẹ abi omi osumha ni a ya va kemhi, ni ọa khueghie unu-a. ");
INSERT INTO atgNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","E ri omama mu ọli, e gbe ọli azẹba, e pfa ẹzọ mu ọli a gbe ọli-a. Ọghuo ọ ya mie shi ọ khi ọ ya dobẹ mhọli akhẹmhẹ-ukhokho, irari khi eri e mie ọli agbọ?” ");
INSERT INTO atgNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ọni ọmọse ọwali ọ́ọ́ iFilipu, “Kpẹkpẹ gueyẹ mhẹ ọni ọmekẹguele ọnana ọọ ngme, ingme oyi egbọli ọọ ngme abi ingme oyi ọgbọẹse?” ");
INSERT INTO atgNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","IFilipu ọ gueyẹ ọli emini oni Ebe-no-pfuasẹ ni ọọ zẹ eghọ o ngme. Ọ gue ungmemhi oyi okhale oyi iJesu ye ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Abi e kie li kia lẹẹ eghọ, e mẹ okẹ. Ọni ọmọse ọwali ọghọ ọọ li, “Bino, ghe okẹ ana, bie batazi mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","IFilipu ọọ li, “Ini u mie iJesu suọ mhi ya batazi ẹ.” Ọni ọmọse ọọ li, “Mhi she miesuọ khi iJesu iKirisiti ọ khi Omi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ighọ ọni ọmọse ọọ ọni ọ gua oni ọkọ oghọ ọ mu ọli migha. Lọli ali iFilipu e kia tiemhi oni okẹ, iFilipu ọ batazi ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","E lẹsẹ rọte oni okẹ nga egele le, Ayẹmhẹ-nọ-pfuasẹ ọ kele iFilipu-a je oboese. Ọni ọmọse ọa ke tigbe mẹ iFilipu, ama oghẹlẹ o la li elemhi i je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ama iFilipu ọ mẹ egbọli ẹoli Azotusi. Ọ rọte oobọ ri oni ungmemhi i tse abọ kia kia ẹoli khi ẹoli ya ramhi ni ọ rọ ramhi ẹoli iSizeria. ");
INSERT INTO atgNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ISọlu ọ kiele tse ekha abi lọli li ya gbolo eni e mie iJesu suọ-a. Ọ lẹ deba Ọkpeda na ekpodalo-ugamhi eyi Ẹshinẹgba, ");
INSERT INTO atgNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ọ mhila li ọ ri ebe na luẹ ghi eni e la owa ugamhi na ekẹ iDamasikọsi. Ni lọli rọ mhọli afu dobẹ muno ikpotso ali emọse ni e mie iJesu suọ ighumha je obini iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Abi iSọlu ọ li ri okiali ti i ramhi iDamasikọsi, utoghuokpe, ákpá o rọte idane mi nga li egbe nyagha. ");
INSERT INTO atgNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ọ de ta alo mu ekẹ. Ọ suọ khi ọgbọ ọ nu luẹ ngme, ọọ li, “ISọlu, iSọlu, elọ o zẹ ni u rọ mu okhọli vule ẹ shi mhẹ ọ?” ");
INSERT INTO atgNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ISọlu ọ mhila li, ọọ, “Ọnọmhuẹ, ọghuo u khi?” Oni uruli ọli, “IJesu mhi khi, ni u mu okhọli vule shi ọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Memena, vule ni u lo elemhi ẹoli ona. U ya mẹ ọmọse ni ọ ya gueyẹ emini u mema ya riẹlẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ẹgbọ ni e nu iSọlu kia e gbe ẹruẹ unu-a, e ga suọ oni ungmemhi, ama ẹa mẹ ọni ọọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ikpukhokho ọ, iSọlu ọ rọte ekẹ vule, abi ọ rọ khueghie alo-a ọa ke dobẹ ẹ mẹ ekẹ. Ẹgbọ ni e nu ọli kia e ke mu ọli obọ kia lo elemhi iDamasikọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ogbẹlẹ esẹ iSọlu ọ ga zalo shi aghọ. Ọa le eminale wẹkhi amẹ ọ da. ");
INSERT INTO atgNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ọmọse ọghuo ni ọ miesuọ ni a lu Ananayasi, ọ la elemhi iDamasikọsi. Ọ la imekẹ, ọ suọ khi Ọnọmhuẹ ọ lu luẹ, “Ananayasi!” Ọọ li, “Ee o.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ọnọmhuẹ ọọ li, “Ke je owa oyi iJudasi, ni o la odẹ ifuapfẹ ni a lu Isheshe, ni u ya mhila ogbọ oyi ọngi iTasọsi ni a lu iSọlu, ọ la aghọ ọ sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Rọte ẹlena iSọlu o li kpẹ mẹ irọkhasẹ khi ọmọse ni a lu Ananayasi ọ ri obọ nga luẹ egbe sọ iromhi na, alo eyẹluẹ e khueghie-a.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananayasi ọọ Ọnọmhuẹ, “Mhi she kpẹ suọ eko ebubu eyi ọmọse ọna abi ọ li ẹ nasẹ ẹgbọ ni e miesuọ, ọ la iJerusalẹmu gbolo eghuo-a. ");
INSERT INTO atgNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ighie eyi ekpodalo-ugamhi eyi Ẹshinẹgba e ri afu na li ọ ka muno ẹgbọ ni ẹẹ lu eva oyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama Ọnọmhuẹ ọọ Ananayasi, “Ke lẹ, irari khi mhi she zẹ iSọlu ni ọ tsua ungmemhi oyẹmhẹ ghi ẹgbọ iJẹta ali ighie eyẹwẹ ali ẹgbọ iZirẹni nya.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mhi ya rọkhasẹ ọli khi ọ mema ya mẹ osoli shi ungmemhi oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Abi Ananayasi ọ rọ mẹ oni owa, ọ dọsẹ lo ya ri obọ nga iSọlu egbe, ọọ li, “ISọlu inyọghuo-mhẹ, iJesu Ọnọmhuẹ ni ọ lonẹ odẹ abi u rọ ọ bhale oola, lọli ọọ mhi ka nono ẹ mẹ, ni u gbolo ke mẹ ekẹ ali ni Ayẹmhẹ-nọ-pfuasẹ ọ bhale egbe oyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Utoghuokpe, emini e li abi ipfiapfia afẹlẹ o rọte ọli ikpamhi alo de pfia, ọ gbolo o mẹ ekẹ. Ọ vule migha, Ananayasi ọ batazi ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Abi ọ rọ le eminale se, ọ tigbe mhọli ochi. Ebubu ogbẹlẹ iSọlu ọ nu eni e miesuọ la elemhi iDamasikọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Eloawẹ iSọlu ọ la elemhi owa ugamhi gueyẹ ẹgbọ khi iJesu Omi Ẹshinẹgba ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ẹgbọkpa ni e suọ ungmemhi oyi iSọlu ee mhila, “Ọa khi ọmọse ọnana ọọ nasẹ eni e miesuọ ni e la iJerusalẹmu? Ọa khi eri ọ bhale ya muno wẹ abi ighumha ghi ighie eyi ekpodalo-ugamhi?” ");
INSERT INTO atgNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ẹshinẹgba ọ ri ekpabọ na iSọlu ni ọ rọ ya ke gue oni ungmemhi le. Ama ẹgbọ iJu ni e la iDamasikọsi ẹa dobẹ mu iSọlu ekhakọ ọ le. O sha ẹgbọ iJu abọ abi e rọ mẹ ilẹsingme ni ọ rọ ọ guele khi iJesu ọ khi ọni iKirisiti ni a shobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ebubu ogbẹlẹ iSọlu ọ ga la iDamasikọsi. Ẹgbọ iJu e gba abi e li ya gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ama iSọlu ọ suọ khi ẹgbọ ẹ gba abi e li ya gbeluẹ-a. Eri e shitọ unu odẹ unuẹkpẹ ni a te a lo oni ẹoli le ni e mẹ asha mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ama ẹgbọ ni e miesuọ e pfi uli rọte oni ugbe rọli shi ughughu bẹna ya tiemhi oni ugbe ẹliyọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Abi iSọlu ọ rọ ramhi iJerusalẹmu, ọọ dua ni lọli ya kuma ẹgbọ ni e miesuọ ọ, ama ulishi ọli o mu wẹ. E khọkhọ ini ọ she mie iJesu suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama iBanabasi ọ rue ọli bhale deba eni ighiusomhi na kẹẹ. Ọ gueyẹ wẹ abi iSọlu ọ li mẹ Ọnọmhuẹ odẹ abi ọ rọ lẹ iDamasikọsi ali abi Ọnọmhuẹ ọ li nu ọli ngme. Ọ gbo gueyẹ wẹ abi ọ li la ekẹ iDamasikọsi ri eva oyi iJesu tse abọ ni ulishi ọa li mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ighọ ISọlu ọ nu wẹ la iJerusalẹmu kia kugbe. Ọ ri igbedu ri eva oyi Ọnọmhuẹ ẹ tse abọ gboo. ");
INSERT INTO atgNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ighọ ọ nu ẹgbọ iJu ni ẹẹ ngme ẹlẹmhi iGiriki i khakọ, ama ee dua ni wẹwẹ e gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Abi eni e miesuọ e rọ suọ ugbamhi ni eni ẹgbọ ẹẹ gba, e rue ọli je ekẹ iSizeria, e te aghọ rue ọli ya je iTasọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Igbaa eyi eni e mie iJesu iKirisiti suọ ni e la ekẹ iJudia ali iGalili ali iSameria nya e mhọli opfọmhẹ, e toto-a, Ayẹmhẹ-nọ-pfuasẹ ọ ri udu shi wẹ ọ, ee bua shi ọ, ee ngeli angeli ni o pfuasẹ ri ekpẹ ẹ na Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Abi iPita ọ li i kia oni ekẹ gasẹ, ọ kọ ya fẹli eni e miesuọ ni e la ẹoli iLida. ");
INSERT INTO atgNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ọ bhale ya ẹ ọmọse ni a lu Eniasi ni ọ guọghọ-a, o she gba ikpe elele abi ọ te yẹshi a ghua. ");
INSERT INTO atgNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","IPita ọọ, “Eniasi, iJesu iKirisiti ọ rẹ ze. Vule migha khili iya oyẹ ni u ke kia.” Utoghuo kpe Eniasi ọ vule migha, ọ toto. ");
INSERT INTO atgNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abi ẹgbọ ni e la ẹoli iLida ali iSharọ e rọ mẹ khi Eniasi ọ toto, e mu pfi deba Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ọkpotso ọghuo ni ọ miesuọ ni a lu iTabita ọ la ẹoli iJopa, abi iTabita o ngme ẹmuẹ iGiriki khi “Ẹruẹ,” Ọ khi ọgbọ onete. Ọ gbolo mema ẹ kpaghiẹ eni ẹa mhuẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ẹghẹghẹ ni a ngme ena, ọọ ghua, ighọ ọ ghua. Abi a rọ khuẹsẹ olimhi oyọli-a se, a rọli yẹshi elemhi owa atọnga. ");
INSERT INTO atgNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Abi eni e miesuọ e rọ suọ khi iPita ọ la iLida, e ghie emọse aava ghi ọli, ẹ ọli, “Kpẹkpẹ bhale pia.” Irari khi ẹoli iLida ali ẹoli iJopa e ti mama egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ighọ iPita ọ deba wẹ. A ri ọli ya khasẹ asha ni a rọli yẹshi. Esamhi-olimhi e la aghọ ọ viẹ. E ri itsua ni iDọkasi ọ fia na wẹ khasẹ ọli abi ọ rọ la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","IPita ọ ẹgbọ ni e la aghọ nya e fiẹ je atukpapfẹ. Ọ de wugha sọ iromhi. Ọ sọ alo ghue ọni olimhi, ọọ li, “Tabita, guale!” Ọni olimhi ọ khueghie alo-a, abi ọ mẹ khi iPita ọ migha mama luẹ, ọ vule shitọ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","IPita ọ mu ọli obọ vule. Ọ luno eni e miesuọ ali eni esamhi-olimhi, ọ ri ọli khasẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iguisele oyi iDọkasi o gbekẹ-a shi ẹoli iJopa. Itobọ ighọ, ebubu ẹgbọ e mie iJesu suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","IPita ọ la iJopa ogbẹlẹ ni e bu. Ọ la owa oyi iSimọni ni ọ ri ekuẹ elamhakọ ọ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ọmọse ọghuo ọ la ẹoli iSizeria ni a lu iKọnilusi. Ọ khi ọga ọyi ekhọli-okhuẹ eyi Itili. ");
INSERT INTO atgNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Lọli ali apfọli e khi ẹgbọ ni ẹ na ulishi Ẹshinẹgba. Ọ khi ọgbọ ni ọ pfo elemhi i somhi ẹgbọ ni ẹa mhuẹ opfa. Ọ gbo khi ọgbọ ni ọ sọ iromhi ẹghẹghẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ẹlẹghuo elemhi agogo esẹ ẹlẹ ọguota, ọ mẹ imẹ-alo, ọ mẹ khi agẹni ọyi Ẹshinẹgba ọ bhale ọ lu ọli, “IKọnilusi!” ");
INSERT INTO atgNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ọ sọ alo ghue ọni agẹni, ulishi o mu ọli. Ọọ li, “Ọnọmhuẹ elọ o zẹ khi u bhale.” Ọni agẹni ọọ li, “Iromhi eyẹ ni u wa sọ ali isomhopfa ni u wa somhi e she bhale deba Ẹshinẹgba, Ọ she mu egbe ni ọ rọ ya yele ẹ le. ");
INSERT INTO atgNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Memena nyanya ghie ẹgbọ je ẹoli iJopa ni e ya lu iSamọ ni a gbolo ẹ lu iPita, ni ọ bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ọ kushi ayi iSamọ ni ọ ri ekuẹ elamhi ẹ gbe akanya. Oni owa oyọli o la epfẹ okẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Abi ọni agẹni ọ rọ vu se, iKọnilusi ọ lu eni ẹ ga li etuava ali ọkhọli-okhuẹ ni ọ khi adogẹli ọyọli ni ọọ ga Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","IKọnilusi ọ gueyẹ wẹ emini a mẹ nya. Ọ ghie wẹ je obini iJopa. ");
INSERT INTO atgNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ogbeakọlọ khi itsotso ọguota o mu ekẹ, khi e lẹsẹ ri okiali ramhi epfepfẹ iJopa, iPita ọ nga owa atọnga ya sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Okiamhi oo gbe ọli. Ọọ nono emini ọ ya le. Abi a rọ ọ nye eminale ni ọ ya le, ọ mẹ imẹ-alo. ");
INSERT INTO atgNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ọ mẹ khi emini e li abi ode ni o zẹ igo ene o rọte idane e tiemhile. ");
INSERT INTO atgNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ighọ ọ mẹ khi iwali elamhakọ e laọ, ghe eni e zẹ awẹ ene ali eni ẹẹ tialọ idi ekẹ ali ipfeli. ");
INSERT INTO atgNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ighọ uruli o ngme, ọọ li, “Vule iPita, gbe ni u le.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ama iPita ọọ, “Iiye e, Ọnọmhuẹ! Mhia kpẹ tigbe le eminale ni ẹa pfuasẹ ni a ghuẹ ghue, a ti ẹ bia mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Oni uruli o gbo nu ọli ngme, ọọ li, “Emini Ẹshinẹgba ọ da rọ khi oni o pfuasẹ se, khi ke lu ọli emini ọa pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Itesẹ o lighọ mhẹsẹ abọ ri egbọli khasẹ neni a rue oni emhi nga idane. ");
INSERT INTO atgNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Abi iPita ọ kie li i sa ingme imẹ-alo ni ọ mẹ, emọse ni iKọnilusi ọ ghie usomhi, e nono owa oyi iSamọ mẹ. E migha odalo odẹ unuẹkpẹ oyi oni apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","E lu mhila, “A mhọli ọpfẹse shi ana ni a lu iSamọ iPita?” ");
INSERT INTO atgNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Abi iPita ọ kiele khọkhọ emini oni imẹ-alo ona o ngme, Ayẹmhẹ ọ rọ gueyẹ ọli, “Ri esọ kpẹ emọse aasẹ ẹẹ nono ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nyanya mu egbe ni u deba wẹ vu, khi mhẹmhẹ mhi ghie wẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ighọ iPita ọ tiemhi deba wẹ, ọọ wẹ, “Mhẹmhẹ a nono, elọ e rẹ ẹ bhale?” ");
INSERT INTO atgNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ẹẹ ọli, “Ọga ọyi ekhọli-okhuẹ ni a lu iKọnilusi ọ ghie anye ghi ẹ. Ọgbọ ọniẹmhi ni ẹgbọ iJu e mu ekpẹ a na ọ khi. Ọ gbo khi ọgbọ ni ọ pfuasẹ ni ọọ ga Ẹshinẹgba. Agẹni ọ gueyẹ oli ọ ghie ghi ẹ, u bhale owa oyọli, ni ọ suọ ingme ni u ya gueyẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ighọ iPita ọ lu eni emọse lo owa oyọli, e gbhẹ aghọ ni ogbe o gbe. Ogbeakọlọ, lọli ali eni e miesuọ eghuo e rọte iJopa deba wẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ogbeakọlọ, e lo elemhi ẹoli iSizeria le, ashini iKọnilusi ali apfọli ali egbegbi emọle ọli, e legba migha ẹ khẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Abi iPita ọ rọ ramhi aghọ, iKọnilusi ọ lo ọ li odẹ, ọ wugha, ọ nyẹsẹ ukhomhi tsẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama iPita ọ mu ọli vule, ọọ li, “Vule khi ọgbọ ọnabi yẹyẹ mhi khi.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","IPita ọ nu ọli ngme, ọ lo owa, ọ bhale ya ẹ ẹgbọ ni e bu shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ọọ wẹ, “Ẹẹ a she lẹsẹ khi eri Ishi eyi iMosisi ọọ ẹgbọ iJu e khi kugbe ẹgbọ iJẹta ọ, wẹkhi eri e kọ ya fẹli ọgbọ ni ọa khi iJu. Ama Ẹshinẹgba ọ rọli khasẹ mhẹ mhi khi leli ọgbọkhọghuo shi ọni ọa pfuasẹ ali ọni a ghuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Irarighọ, abi u rọ ghie lu mhẹ, mhia mhọli akhọkhọmhẹ shi ọ. Elọ u mema lu mhẹ shi?” ");
INSERT INTO atgNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","IKọnilusi ọọ li, “Amo o li ẹlẹ ene, ẹghẹghẹ agogo esẹ ọguota, mhi rọ la owa oyẹmhẹ ẹ sọ iromhi. Udemhija mhi mẹ khi ọmọse ọghuo ọ sọ itsua ni ẹẹ gẹ nyanyanya ọ migha mhẹ odalo. ");
INSERT INTO atgNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ọọ li, ‘IKọnilusi, Ẹshinẹgba ọ she suọ iromhi eyẹ, ọ she gbo mẹ ikanya isomhelemhi ni u gbe ẹ deba ẹgbọ eni ẹa mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ghie ọgbọ ghi ọmọse ni a lu iSamọ iPita ni ọ la iJopa. Ọpfẹse ọ khi shi owa oyi iSamọ ni ọ ri ekuẹ ẹlamhi ẹ gbe akanya, ni ọ la epfẹ okẹ oku.’ ");
INSERT INTO atgNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lọli mhi rọ ghie ọgbọ ghi ẹ pia. Oo guẹ ti, abi u bhale. Memena awa nya awa la odalo oyi Ẹshinẹgba ni anye suọ emini Ọnọmhuẹ o gueyẹ u gueyẹ anye.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","IPita ọọ, “Mhi she mẹ ọli mẹ khi igẹsikia o khi, khi Ẹshinẹgba ọa mhọli khi ọna ọ kpe ọli nẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ama ẹgbọ kpa ni e da a na ulishi oyi Ẹshinẹgba, ni e gbolo ẹ riẹlẹ emini o rọte odẹ, Ẹshinẹgba ọ kpe obọ ọọ mie. ");
INSERT INTO atgNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ẹẹ a lẹsẹ usomhi ni ọ ghie ghi ẹgbọ iZirẹni, ni o khi usomhi onete oyi opfọmhẹ ni o rọte obọ oyi iJesu iKirisiti ni ọ khi Ọnọmhuẹ ọyi agbọ kpa bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ẹẹ a lẹsẹ ingme ni a mẹ elemhi ekẹ iJudia nya, ni o rọte iGalili gbaekẹle, abi iJọni ọ́ rọ ọ tse abọ usomhi gueyẹ ẹgbọ, khi a mema batazi wẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","abi Ẹshinẹgba ọ li ri Ayẹmhẹ-nọ-pfuasẹ ali ekpabọ kpha iJesu ọnge iNazarẹti sọ, ali abi ọ li i kiakia ashakpa riẹlẹ onete, ni ọ mie ẹgbọ pfuese obọ oyi ekpabọ eyi ọkphaghiẹ, itobọ khi Ẹshinẹgba ọ́ nu ọli la. ");
INSERT INTO atgNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Anye ri ẹloe mẹ ikanya ni ọ gbe nya, elemhi ẹoli eyi ẹgbọ iJu ali iJerusalẹmu. Wẹwẹ e tali ma ọọra apfida gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama ẹlẹ nuzi-esẹ, Ẹshinẹgba ọ rọte eghuli guise ọli le ni a mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ọa khi ọgbọkpa ọ mẹ ọli, sẹẹ ni anye ni Ẹshinẹgba ọ she kpẹ zẹ, anye khi ọtsẹlẹ, anye ni anye nu ọli le eminale ni anye gbo nu ọli da abi ọ rọ rọte eghuli guale se. ");
INSERT INTO atgNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ọ mhẹsẹ na anye, anye kia ke gueyẹ ẹgbọkpa ali anye gbo ke pfi ọtsẹlẹ shi ọ khi lọli iJesu, Ẹshinẹgba ọ zẹ, lọli khi ọsọ-ẹzọ ọyi eni e laọ ali eni e ghu-a. ");
INSERT INTO atgNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Emekẹguele nya e kpẹ ngme ungmemhi oyọli khi eni e da mie ọli suọ khi a ya gbe olamhẹ kua na wẹ, rọte ekpabọ ni o la eva oyọli.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Abi iPita ọ kie li i ngme, Ayẹmhẹ-nọ-pfuasẹ ọ tiemhile na ẹgbọ ni e suọ oni ungmemhi. ");
INSERT INTO atgNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abọ e sha eni e miesuọ ni e shẹlẹ-a, ni e rọte ẹoli iJopa kphase iPita bhale aghọ, khi Ẹshinẹgba ọ li ri Ayẹmhẹ-nọ-pfuasẹ na ẹgbọ iJẹta. ");
INSERT INTO atgNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Irari khi e suọ khi e ngme ẹmuẹ ọdọda eyi Ayẹmhẹ nọ pfuasẹ, e kuẹghiẹ Ẹshinẹgba. Ighọ iPita ọ ri irarighọ liẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ọgbọkhọghuo ọ dobẹ ya liẹ ọgbọ khi ri amẹ batazi ẹgbọ ena mena? E she li mie Ayẹmhẹ-nọ-pfuasẹ abi awa li mie ọli.” ");
INSERT INTO atgNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ighọ iPita ọọ a ka ri eva oyi iJesu iKirisiti batazi wẹ. Ighọ e gueyẹ ọli ọ nu wẹwẹ la aghọ ikukumi ogbẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Eni ighiusomhi na kẹẹ ali eni e miesuọ ni e la ekẹ iJudia nya e suọ khi ẹgbọ iJẹta e li mie ungmemhi oyi Ẹshinẹgba suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Abi iPita ọ rọ nga obini iJerusalẹmu, eni e miesuọ ni e shẹlẹ-a, ee shi iPita unu. ");
INSERT INTO atgNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ẹẹ ọli, “Yẹyẹ u lo owa oyi ẹgbọ iJẹta ni ẹa shẹlẹ-a, u gbo la aghọ le eminale!” ");
INSERT INTO atgNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ighọ iPita ọ rọte ekẹ rọli lo wẹ esọ abi a ga li mẹ oni ingme nya. Ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ẹoli iJopa mhi la a sọ iromhi, ni ukuku olesẹ o rọ kia mhẹ alo-a, ni mhi rọ mẹ imẹ-alo, mhi mẹ khi emini o li abi ode ni o zẹ igo ene, o te idane tiemhile ashini mhi la. ");
INSERT INTO atgNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mhi bino elemhi ọli, mhi mẹ elamhakọ ni e zẹ awẹ-ene, ali elamhakọ ebuli, ali elamhakọ ni ẹ tialọ idi ekẹ, ipfeli na idane e li la elemhi ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ighọ mhi suọ khi uruli o nu mhẹ ngme, ọọ mhẹ, ‘Vule, iPita gbe elamhi ena, ni u le.’ ");
INSERT INTO atgNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ama, mhiẹ ọli, ‘Iiye e, Ọnọmhuẹ! Mhi aa le eminale ni ẹa pfuasẹ ni a ghuẹ ghue abi a te bia mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Oni uruli o gbo nu mhẹ ngme, ọọ mhẹ, ‘Emini Ẹshinẹgba ọ she rọ pfuasẹ, khi ke rọli shi emhi ni ọa pfuasẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Itesẹ o li ighọ mhẹsẹ abọ ri egbọli khasẹ neni a rue oni ode nga idane. ");
INSERT INTO atgNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Aghọaghọ, eni emọse aasẹ ni e te iSizeria nono mhẹ bhale, e lo owa ni mhi la le. ");
INSERT INTO atgNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ayẹmhẹ ọ gueyẹ mhẹ mhi deba wẹ vu, mhia aa khẹ akọ. Ẹgbọ osasa ena e te ẹoli iJopa kphase mhẹ je ẹoli iSizeria ni anye rọ ga bhale owa oyi iKọnilusi. ");
INSERT INTO atgNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Lọli ọ gueyẹ anye abi ọ li mẹ agẹni elemhi owa oyọli, ni ọ ọli, ‘Ghie ọgbọ je iJopa ya lu ọmọse ni a lu iSamọ ni a gbo lo a lu iPita. ");
INSERT INTO atgNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Lọli ọ ya gueyẹ abi yẹyẹ ali apfẹ a li ya mhọli imiepfuese.’ ");
INSERT INTO atgNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Abi mhi li i ngme, Ayẹmhẹ-nọ-pfuasẹ ọ tiemhile shi wẹ ọ abi ọ li rọte igbaekẹle li tiemhile shi awa ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ighọ mhi yelele emini Ọnọmhuẹ ọ ngme ni ọọ, ‘Amẹ iJọni ọ rọ batazi ẹgbọ, ama Ayẹmhẹ-nọ-pfuasẹ a ke rọ ya batazi ẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Abi o rọ khia khi Ẹshinẹgba ọ she ri isomhopfa enabi ọ rọ na awa abi awa rọ mie iJesu iKirisiti Ọnọmhuẹ suọ li na ẹgbọ ni ẹ a khi iJu. Ọghuo ọ khi mhẹmhẹ ni mhi ya nu Ẹshinẹgba khabọ?” ");
INSERT INTO atgNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Abi e rọ suọ ona se, e yẹmhẹ awọlọ-a, ee kuẹghiẹ Ẹshinẹgba, ee liẹ, “Ẹshinẹgba ọ li zẹ ni ẹgbọ iJẹta e li mu pfi ni e li mhuẹ agbọ na agbọagbọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Eni e mie iJesu iKirisiti suọ e kia gbhiaku ekẹ iFonisha ali ekẹ iSapurọsi ali ẹoli Atiọki itobọ okhọli ni a mu vule shi wẹ ọ ẹghẹghẹ ni a rọ gbe iSitivini-a. E kia gue oni usomhi yẹ ẹgbọ iJu wẹwẹghuo tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eghuo ọ e rọte ekẹ iSapurọsi ali ekẹ iSairini bhale, e vu je ẹoli Atiọki, e lili gue usomhi onete oyi Ọnọmhuẹ yẹ ẹgbọ iGiriki ");
INSERT INTO atgNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ekpabọ oyi Ọnọmhuẹ o nu wẹ la, Ebubu ẹgbọ e miesuọ, e mu udu pfi deba Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Igbaa oyi eni e mie iJesu iKirisiti suọ ni e la iJerusalẹmu e suọ oni ingme, ighọ e ghie iBanabasi je ẹoli Atiọki. ");
INSERT INTO atgNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Abi ọ rọ ramhi aghọ, ni ọ rọ mẹ abi Ẹshinẹgba ọ li somhi-elemhi eni ẹgbọ, egbe e mu ọli. Ọ ri udu shi wẹ ọ e ri udu oyẹwẹ nya na Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","IBanabasi ọ khi egbegbi ọgbọ ọnete ni ọ mhuẹ Ayẹmhẹ-nọ-pfuasẹ ali irudunga oniẹmhi. Ebubu ẹgbọ e ri itobọ emini ọ riẹlẹ mie Ọnọmhuẹ suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ighọ iBanabasi ọ je ẹoli iTasọsi ya nono iSọlu. ");
INSERT INTO atgNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Abi ọ rọ mẹ ọli, ọ rue ọli je ẹoli Atiọki, e la aghọ ukpe oghuo, ee sẹsẹ ebubu ẹgbọ. Elemhi ẹoli Atiọki a la te ododẹ kpẹ lu eni e miesuọ, iKirisiti enikeke. ");
INSERT INTO atgNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Oni ẹghẹghẹ, emekẹguele eghuo e rọte ẹoli iJerusalẹmu je Atiọki. ");
INSERT INTO atgNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ọghuo elemhi eni emekẹguele ni a lu Agabusi ọ vule, ọ guele abi Ayẹmhẹ ọ ghie ọli, khi úkhúmhi o ya pfi ushishi na ekẹ iRomu nya. (Ẹghẹghẹ ni iKiladiusi ọ rọ khi Oghie iRomu nya ona o rọ bhale ya tsẹ.) ");
INSERT INTO atgNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Eniyẹ odukhokho eyi iJesu ni e la Atiọki e gba ugbamhi, abi e li ya ri ikpaghiobọ ghie usomhi ghi eni e miesuọ ni e la ekẹ iJudia, abi ọgbọgbọ ọ mhuẹ ekpabọ ramhi. ");
INSERT INTO atgNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ighọ e zẹla ikpaghọ kugbe, e rẹwẹ ghie iBanabasi ali iSọlu usomhi ghi eni egbhali ni e la igbaa oyi eni e mie iJesu iKirisiti suọ na iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Oni ẹghẹghẹ aghọ, oghie Erọdu ọ muno ẹgbọ eghuo ena igbaa oyi eni e mie iJesu iKirisiti suọ, ọọ nono ni lọli nasẹ wẹ shi afuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ọ ri unu bhale a ri uwẹrẹ gbe iJemhisi ni ọ khi inyọghuo iJọni-a. ");
INSERT INTO atgNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Abi ọ rọ mẹ khi o ti ẹgbọ iJu ẹloe, ọ gbo mu iPita shi owa. Oni ẹghẹghẹ e rọ li ukpe ibulẹdi ni aa ri ifuma ma nye. ");
INSERT INTO atgNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ọ mu ọli se, ọ rọli shi owa ighumha, ọ zẹ ekhọli-okhuẹ ikuwẹ asha ene ni e ọọghiẹ egbe, e ri ẹloe shi ọli egbe. Erọdu ọ mhọli ọli shi udu khi a kha da li oni ukpe se, lọli rue ọli lasele gboo, ni a gue ọli ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ighọ a ri iPita shi owa ighumha, ama igbaa oyi eni e mie iJesu iKirisiti suọ e toto obọ ọ sọ iromhi lu Ẹshinẹgba na li. ");
INSERT INTO atgNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ẹliyọsẹ ni Erọdu ọ kha rọ rue iPita lasele ogbeakọlọ, iPita ọ lesẹ-a shi ifuabọ eyi iku ekhọli-okhuẹ aava, a ri iwẹghẹ eva gẹ ọli. Eni ẹ khẹ ekhẹ aava elese e la odẹ unuẹkpẹ oni owa ighumha ẹ khẹ ekhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Udemhija, agẹni ọyi Ọnọmhuẹ ọ lole, ighọ ákpá o la elemhi oni owa ighumha a gẹ. Ọni agẹni ọ pfi iPita emhi epfẹ, guise ọli le. Ọọ li, “Nyanya vule!” Utoghuokpe, iwẹghẹ ni a sọ li e ku ọli abọ kua. ");
INSERT INTO atgNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ighọ ọni agẹni ọọ li, “Ri ọgbẹnẹ oyẹ mu oku, ri ekuẹ sọ.” IPita ọ nyanya lighọ. Ọọ li, “Ri itsua eyẹ sọ, ke deba mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ighọ IPita ọ deba li je olase oni owa ighumha, ama ọa lẹsẹ khi emini ọni agẹni ọ riẹlẹ khi egbegbi ingme lọ, ọ dabi khi ẹlena lọli ii la. ");
INSERT INTO atgNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","É dọsẹ eni ẹ khẹ ekhẹ eni ododẹ ali enuzava. E bhale odẹ unuẹkpẹ akhuli ni a rọte a lasele shi ifui apfẹ. Oni odẹ unuẹkpẹ akhuli lọlighuo o khueghie-a. E rọte ọ dọsẹ. Abi e rọ kia ifui apfẹ lẹ dẹnẹ, ọni agẹni ọ kele-a. ");
INSERT INTO atgNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ighọ ẹgbhali eyi iPita e na ya to. Ọọ, “Ena mhi lẹsẹ, ni ọa mhuẹ akhọkhọmhẹ khi Ọnọmhuẹ ọ ghie agẹni ọyọli, ọ ka pfa mhẹ shi ekẹ obọ oyi Erọdu ali emini ẹgbọ iJu ẹẹ sa khi mhi ya mẹ nya.” ");
INSERT INTO atgNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Abi ẹgbhali eyọli e rọ na ya to se, ọ je owa oyi iMeli ni ọ khi inyọ iJọni ni a gbolo ẹ lu iMaki. Aghọ eni e miesuọ e legba la a sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","IPita ọ kpheli odẹ na olase. Ighọ ọmueshi ni ọọ ga ọgbọ ni a lu iRoda ọ bhale ya mie ọli unu. ");
INSERT INTO atgNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Abi ọ rọ suọ uruli oyi iPita, oghẹlẹ o vọ ọli udu. Ọa je okpẹ odẹ-a ne, ọ nyanya nyenẹ egbe ukhokho ya tsẹsẹ gueyẹ wẹ, “IPita ọ she jele!” ");
INSERT INTO atgNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ẹẹ ọli, “Ujili ọọ kphẹ!” Ama ọ li khi egbegbi ingme lọli ẹ ngme. Ighọ ẹ ọli, “Ayẹmhẹ olimhi ọyọli lọ!” ");
INSERT INTO atgNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ama iPita ọ kiele kpheli obọ odẹ. Abi e ke rọ khueghie oni odẹ-a, e mẹ khi lọli lọ. Abọ e sha wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ọ ri obọ gbe wẹ akhiakhia. Ọ tigbe gueyẹ wẹ abi Ọnọmhuẹ ọ li rue luẹ owa ighumha le. Ọọ wẹ, “A gueyẹ iJemhisi ali eni e miesuọ eni e kpọle.” Ighọ ọ vu je oboese. ");
INSERT INTO atgNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ogbeakọlọ, ozughu o lo iteva oyi eni ekhọli-okhuẹ le shi abi iPita ọ li kia. ");
INSERT INTO atgNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Abi Erọdu ọ rọ ọ e lolo nono iPita kia gasẹ, ni ẹa rọ mẹ ọli. Ọ ri eni ẹẹ khẹ ekhẹ eghọ gue ẹzọ. Ọọ a gbolo wẹ-a. Abi a rọ mẹ enana se, Erọdu ọ rọte ekẹ iJudia je iSizeria ya la ukuku ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Elemhi e lolo bi Erọdu deba ẹgbọ iTai ali iSidọni. Ighọ eni ẹgbọ e to ukhomhi ma, ee dua abi e li ya mẹ asha nu oni oghie shitọ ngme. Abi iBilasitọsi ni ọ khi adogẹli ọyi oghie ọ rọ lama shi wẹ ọ, e tigbe lama khi wẹwẹ e ya lema oghie ni wẹwẹ e rọ riẹlẹ. Itobọ khi ẹoli oyi ọni Erọdu eni ẹgbọ e rọte mẹ eminale ẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Oni ogbẹlẹ o ramhi Erọdu ọ gbanọ itsua oghie eyọli, ọ shitọ ukpẹkhomhi oghie oyọli. Ọ nu eni ẹgbọ ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Eni ẹgbọ e ku unu-a nyoghoo, ẹ li, “Uruli oyi Ẹshinẹgba na, ọa ke khi oyi ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Utoghuo kpe agẹni ọyi Ọnọmhuẹ ọ pfi Erọdu emhi, itobọ khi ọa ri ekpẹ na Ẹshinẹgba. Ekhọli e ri ọli le. Ọ ghu eghuli osoli. ");
INSERT INTO atgNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ungmemhi oyi Ẹshinẹgba o gbhiaku ashakpa, oo gẹ shọ. ");
INSERT INTO atgNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","IBanabasi ali iSọlu e rọte iJerusalẹmu, obini a ri ikpaghọ ghie wẹ usomhi je jele. Abi e rọ ọ jele, e rue iJọni ni a gbolo ẹ lu iMaki mhuẹ obọ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Emekẹguele ali eni ẹ sẹsẹ e la igbaa oyi eni e mie iJesu iKirisiti suọ ni ọ la Atiọki, ni e khi iBanabasi, ali iSamọ ni ọ khi ọgbọ ọbishi, ali iLushọsi ọngi iSairini, iMaini ọni a ga kuẹlẹ ọli ali oghie Erọdu, ali iSọlu. ");
INSERT INTO atgNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Abi e li i kuẹghiẹ Ọnọmhuẹ ni e li i pfi azumhi, Ayẹmhẹ-nọ-pfuasẹ ọọ wẹ, “A zẹ iBanabasi ali iSọlu-ọ lase na mhẹ ni e ya gbe akanya ni mhi lu wẹ shi.” ");
INSERT INTO atgNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","E pfi azumhi, e ri abọ nga wẹ ukhomhi sọ iromhi na, e ghie wẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ayẹmhẹ-nọ-pfuasẹ ọ ghie iBanabasi ali iSọlu je iSelusha aghọ e te lo ọkọ okẹ je ekẹ ni oku o khi shi na lu iSapurọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Abi e rọ ramhi ẹoli iSalamisi, e la owa ugamhi oyi ẹgbọ iJu gue ungmemhi oyi Ẹshinẹgba le. IJọni ni a gbolo ẹ lu iMaki ọ la aghọ ri obọ da wẹ oni akanya. ");
INSERT INTO atgNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","E kia je ukiẹkiẹ iSapurọsi ni o kpọle nya, e bhale ẹoli iPafọsi. Aghọ e ya ẹ ọbo ni a lu iBajisọsi ọngi iJu ni ọọ li ẹboli, ni ọ khi ọmekẹguele ọyi ẹgbhọli. ");
INSERT INTO atgNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Lọli ọ khi ọmọle ọni igọvunọ ni ọ la oni ekẹ, eva oyi ọni igọvunọ khi iSajọsi iPọlọsi ni ọ khi ọtsẹgbhẹ. Ọni igọvunọ ọ lu iBanabasi ali iSọlu itobọ khi ọ nono ni lọli suọ ungmemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ama ọni iBajisọsi ni ọ liẹ Ẹlimasi ni ọọ li ọbo, ọ tsua ozughu lo aghọ le ini ọni igọvunọ ọ khi mẹ asha miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ighọ iSọlu ni a liẹ lu iPọlu, ni Ayẹmhẹ-nọ-pfuasẹ ọ vọ egbe, ọ fẹli ọni ọbo chii. ");
INSERT INTO atgNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ọọ li, “Yẹyẹ omi ọkphaghiẹ! Yẹyẹ ọbe eminete ni u wa li ikẹnẹguẹ. Ẹlẹ u ya rọte imu-ungmemhi oyi Ẹshinẹgba pfi ukhomhi kpọkẹ lasele? ");
INSERT INTO atgNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Memena Ẹshinẹgba ọ ya nise obọ oyọli ti ẹ, u ya zẹ alo, waa kẹ gbo dobẹ ya mẹ ugẹmhi oyi ovọ ukuku ẹghẹghẹ ne.” Aghọaghọ, Ẹlimasi ọ mẹ khi alo eyẹluẹ e bi obili-a, Ọọ bibi, ọọ nono ọni ọ ya mu ọli obọ ke kia. ");
INSERT INTO atgNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Abi ọni igọvunọ ọ rọ mẹ ingme ni a mẹ, ọ miesuọ, irari khi osẹsẹ ingme ọyi Ọnọmhuẹ o ri abọ sha li. ");
INSERT INTO atgNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","IPọlu ali apfọli e rọte iPafọsi lo ọkọ okẹ da okẹ oniẹmhi je iPẹriga, ni o khi ẹoli ni o la iPafilia. Ana iJọni ni a gbolo ẹ lu iMaki ọ pfi wẹ shi nyenẹ egbe je iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","E rọte iPẹriga je ẹoli Atiọki ni o la ekẹ iPisidia. Ogbẹlẹ iyẹmhẹa oyi iJu, e lo owa ugamhi ya shitọ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Abi e rọ rọte ebe ishi oyi iMosisi ali ebe eyi emekẹguele zẹ se, eni ẹẹ mhẹsẹ shi oni owa ugamhi e ghie usomhi ya gueyẹ iPọlu ali iBanabasi, ẹẹ wẹ, “Inyọghuo anye, ini a mhọli ungmemhi ni a mẹ ya guele ni o ya ri udu shi ẹgbọ ọ, a ke ngme.” ");
INSERT INTO atgNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","IPọlu ọ vule migha ọ ri obọ nu wẹ ngme. Ọọ, “Ẹẹ ẹgbọ iZirẹni ali ẹẹ iJẹta ni a ga Ẹshinẹgba a ri esọ shi mhẹ ekẹ! ");
INSERT INTO atgNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ẹshinẹgba ọyi ẹgbọ iZirẹni ọ zẹ eni e bia awa, lọli ọ rẹwẹ khi ẹgbọ eniẹmhi, oni ẹghẹghẹ e khi epfẹse shi ekẹ iJipiti. Ẹshinẹgba ọ ri ekpabọ eyọli wolọ wẹ ekẹ iJipiti lasele. ");
INSERT INTO atgNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Elemhi ikpe egbhuẹva ọ ri abọ mu udu na ẹ elemhi ọdagbe ifufu. ");
INSERT INTO atgNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ẹdẹli ishilua ọ pfusea ekẹ iKena. Ọ ri ekẹ oyẹwẹ na ẹgbọ eyọli le ugu. ");
INSERT INTO atgNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Elemhi ikpe egbhuẹ-uye ali eva ali ikpe igbe (450) a mẹ ingme enana. “Abi a rọ mẹ ena se, ọ ri esọ-ẹzọ na wẹ ni ee mhẹsẹ, ya ramhi ẹghẹghẹ oyi iSamuẹni ọmekẹguele. ");
INSERT INTO atgNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ighọ eni ẹgbọ e mhila Ẹshinẹgba ọ ri oghie na wẹwẹ, Ẹshinẹgba ọ rue iSọlu omi iKishi ọyi unuẹkpẹ oyi iBẹjami na wẹ. Lọli ọ khi oghie ọyẹwẹ elemhi ikpe egbhuẹva. ");
INSERT INTO atgNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Abi Ẹshinẹgba ọ rọ rue iSọlu oghie le, ọ ri iDefidi le oghie na wẹ. Ingme ni Ẹshinẹgba ọ ngme shi iDefidi egbe na, ‘Mhi she mẹ khi iDefidi omi iJese ọ khi ọmọse ọnabi udu oyẹmhẹ ọọ nono, ọ ya riẹlẹ ọghuẹmhẹ oyẹmhẹ nya.’ ");
INSERT INTO atgNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Rọte unuẹkpẹ oyi ọni iDefidi, iJesu ni ọ khi Ọmiepfuese ọyi ẹgbọ iZirẹni ọ te bhale, abi Ẹshinẹgba ọ li rọli shobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Neni iJesu ọ bhale, iJọni ọ she kpẹ gueyẹ ẹgbọ iZirẹni e ti olamhẹ le, e mupfi deba Ẹshinẹgba, ẹghẹghẹ aghọ ni a batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Abi iJọni ọ rọ gbe akanya se, ọ mhila eni ẹgbọ, ọọ, ‘Ọghuo a khọkhọ mhẹ shi? Mhi aa khi ọni a migha a khẹ. Ọni ọ ya bhale ini mhi gbe akanya oyẹmhẹ se, mhi aa fu tẹ ni mhia taghiẹ uli ekuẹ ni ọ sọ-a.’ ");
INSERT INTO atgNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Inyọghuo-mhẹ imi Aburaamu, ali ẹẹ iJẹta ni a na ulishi Ẹshinẹgba ni a la akana, oni ungmemhi imiepfuese ona, oyawa lọ! ");
INSERT INTO atgNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ẹgbọ ni e la iJerusalẹmu ali eni ẹẹ mhẹsẹ na wẹ, ẹa lẹsẹ iJesu shi Ọmiepfuese. Ama igbe-a ni e gbe iJesu-a, o ri emini emekẹguele ee ngme, ni ee zẹ khasẹ wẹ ẹlẹ iyẹmhẹa kpa bhale ya tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Abi o tseku khia khi ẹa mẹ ẹzọ gue shi ọli egbe, ẹẹ li ipaleti ọ zẹ ni a gbe ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Abi e rọ riẹlẹ emini Ebe-no-pfuasẹ o ngme shi ọli egbe se, e rue ọli apfida tiemhile, e rọli tọ uji. ");
INSERT INTO atgNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Ẹshinẹgba ọ rọte eghuli guise ọli le. ");
INSERT INTO atgNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ogbẹlẹ ebubu ọ ri egbọli khasẹ ẹgbọ eni e nu ọli rọte iGalili je iJerusalẹmu. Wẹwẹ e ke pfi ọtsẹlẹ shi ingme oyọli khasẹ ẹgbọ eyawa. ");
INSERT INTO atgNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Eri anye bhale akana ni anye ya ri oni usomhi onete na ẹ, ikhi ishobọ ni Ẹshinẹgba ọ shi na eni e bia awa. ");
INSERT INTO atgNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ọ she ri oni ishobọ ona tsẹ na awa imi wẹ, abi ọ li guise iJesu le. Abi a li kẹkẹ ọli shi ebe Iwolo ni uzeva, khi, “ ‘Omimhẹ u khi, ogbe namo, mhẹmhẹ mhi khi Itẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Abi Ẹshinẹgba ọ rọte eghuli guise ọli le, ni ọa zẹ ọli ghu kẹ-a, o mu ma ungmemhi oyọli ni ọ la liẹ, “ ‘Mhi ya ri ikhivọsẹ no pfuasẹ, ni a ri egbe ẹ nga egbegbọ ni mhi shobọ na iDefidi nẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ighọ ọ kie gbo li ngme ọli shi ashese. “ ‘Waa ya zẹ ni ọni ọ pfuasẹ ọyẹ ọ ghu kẹ-a.’ ");
INSERT INTO atgNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Irari khi eri iDefidi ọ ga Ẹshinẹgba abi ọ rọ la agbọ, ighọ ọ ghu-a, a ri ọli tọ mama eni e bia li. Ọ kẹ-a shi elemhi uji. ");
INSERT INTO atgNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama idiegbe oyi iJesu ni Ẹshinẹgba ọ rọte eghuli guise le, ọa kẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Irarighọ, inyọghuo, anye tse abọ yẹ ẹ khi obọ oyi iJesu a te ya mhọli igbe olamhẹ kua. ");
INSERT INTO atgNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ọnini ọ da mie ọli suọ ne, a she pfa na li, ọa ke lue shi emini Ushi oyi iMosisi ọa dobẹ pfa na wẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","A mhuẹ ẹgbhẹ, ini emini emekẹguele e ngme o khi ya tsẹ shi ẹ egbe, ni ẹẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘A ghe i, ẹẹ ni a ri Ẹshinẹgba a li egia Ọshabọ ọ sha ẹ, a pfua. Irari khi mhi ya riẹlẹ emhi ẹghẹghẹ oyẹ ẹ ni aa ya mie shi ghue, ini ọgbọ ọ tseku gue ọli yẹ ẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Abi iPọlu ali iBanabasi e rọ rọte oni owa ugamhi vu, eni ẹgbọ e gbo lu wẹ e nyenẹ egbe bhale ogbẹlẹ ugamhi olese ya nu wẹwẹ ngme oni ungmemhi. ");
INSERT INTO atgNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Abi oni ilegba o rọ gbhia khuse, ẹgbọ iJu ali ẹgbọ iJẹta eni e she mu pfi bhale ugamhi oyi ẹgbọ iJu, e kpikpi i deba iPọlu ali iBanabasi. IPọlu ali iBanabasi e ye wẹ ude, e kie ke deba okhale ni ẹa fu tẹ ni Ẹshinẹgba ọ riẹlẹ na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ẹlẹ iyẹmhẹa ni o deba li, ẹgbọ ni e la oni ẹoli nya e legba ni e ri esọ shi ungmemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Abi ẹgbọ iJu e rọ mẹ oni ilegba, ee kpe ofuma, ee kholo ingmemhi zu iPọlu unu, e tsue ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ama iPọlu ali iBanabasi e ngme ungmemhi igbedu, ẹ li, “Ẹẹ a khi eni anye kha mema kpẹ gue ungmemhi oyi Ẹshinẹgba yẹ neni o ramhi ẹgbọẹse egbe. Ama abi a ke rọ kie oni ungmemhi ni aa rọ sa khi o ti ni a mhọli agbọ na agbọagbọ eghọ, mena, anye ya zẹ ẹ obọ, anye deba ẹgbọ iJẹta. ");
INSERT INTO atgNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Irari khi ona khi omhẹsẹ ni Ọnọmhuẹ o mhẹsẹ na anye, ni ọ rẹẹ, “ ‘Mhi she rẹ ẹ khi ákpá na ẹgbọ iJẹta, ni agbọ nya e mhuẹ imiepfuese.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abi ẹgbọ iJẹta e rọ suọ ona, ee ghẹlẹ, ee kuẹghiẹ Ẹshinẹgba shi oni ungmemhi, ẹgbọ eni a she zẹ shi agbọ na agbọagbọ, e mie iJesu suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Oni ungmemhi oyi Ọnọmhuẹ o gbhiaku asha kpa oni ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama ẹgbọ iJu e tanọ shi ikpotso ni ẹẹ na ulishi Ẹshinẹgba ni a mu ekpẹ a na ali ekhẹmhuẹ eyi oni ẹoli. E sẹsẹ ẹgbọ ni e mu okhọli oniẹmhi vule shi iPọlu ali iBanabasi ọ, e khu wẹ fiẹ lase oni ẹoli. ");
INSERT INTO atgNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ama eni eniyẹ odukhokho eyi iJesu e kpishi itutu awẹ shi ekẹ, ni e pfi ọtsẹlẹ mu eni ẹgbọ. E rọte aghọ dọsẹ je ẹoli iKoniọmu. ");
INSERT INTO atgNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Oghẹlẹ ali Ayẹmhẹ-nọ-pfuasẹ ọ lo eni e miesuọ eghọ egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","IPọlu ali iBanabasi e lo owa ugamhi oyi ẹgbọ iJu obini iKoniọmu, abi e kie kpẹ ẹ li. E lolo guẹ ẹ ngme ungmemhi ni o lo ẹgbọ esọ, ni o ri ebubu ẹgbọ iJu ali iJẹta miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama ẹgbọ iJu ni ẹa lama miesuọ, e tanọ ẹgbọ iJẹta abọ ni elemhi o yese wẹ-a deba eni e miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ighọ iPọlu ali iBanabasi e kushi aghọ tẹsẹ, e ri igbedu u ngme ungmemhi oyi Ọnọmhuẹ ni ọ pfi ọtsẹlẹ shi ungmemhi okhale oyọli, rọte ekpabọ ni ọ rọ na wẹ ẹ gbe akanya ọnyaloa ali ọshabọ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Okemhi o lo oni ẹdẹli le, ẹgbọ eghuo e kugbe ẹgbọ iJu ọ, eghuo ọ e la ukhokho oyi ighiusomhi na kẹẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ighọ ẹgbọ iJẹta eghuo ali ẹgbọ iJu ali enighie eyẹwẹ, e gba abi e li ya gbe wẹ ali abi e li ya tono wẹ echẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Abi eni ighiusomhi e rọ suọ ona, e na je ẹoli iLisitira ali iDẹbi ni o la ekẹ iLikaonia ali ẹoli elese ni e mama wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aghọ e la a gue usomhi onete le. ");
INSERT INTO atgNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ọmọse ọghuo ọni a bia ọkhomhi ni ọa kia ghue abi a te bia li, ọ li la oni iLisitira. ");
INSERT INTO atgNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ọ shitọ aghọ ri esọ shi ungmemhi ni iPọlu ọọ ngme. IPọlu ọ mẹ khi ọ mhọli irudunga ni o dobẹ ya rọ li ze, iPọlu ọ bino ọli chii. ");
INSERT INTO atgNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ọ tsẹsẹ leghe, ọọ, “Vule migha!” Ọni ọmọse ọ ti vule, ọọ kia gasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Abi eni ẹgbọ e rọ mẹ akanya ni iPọlu ọ gbe, e ngme ẹlẹmhi iLikaonia, ee tsẹsẹ, ee liẹ, “Ilitsa e mele ẹgbọ-a bhale iteva oyawa o!” ");
INSERT INTO atgNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Eva ni e lu iBanabasi khi iZeusi, itobọ khi iPọlu khi ọni ọ mema e ngme, e lu ọli Amẹsi. ");
INSERT INTO atgNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ọni ọọ luasẹ oni olitsa iZeusi, ni okula oyọli o la ukhokho apfẹ oni ẹoli, ọ muno ena enokpo ali idodo je oni odẹ unuẹkpẹ oyi oni ẹoli, itobọ khi lọli ali eni ẹgbọ ee nono ni wẹwẹ ya luasẹ iBanabasi ali iPọlu abi ilitsa. ");
INSERT INTO atgNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Abi iBanabasi ali iPọlu e rọ suọ emini eni ẹgbọ e mu egbe khi e ya riẹlẹ, e nyanọ itsua shi egbewẹ uruli, e nanọ lo eni ẹgbọ ifuabọ. Ee tsẹsẹ liẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Elọ e zẹ khi a li na?” Ẹgbọ enabi ẹẹ anye khi! Ungmemhi usomhi onete anye rọ tse abọ khasẹ ẹ, ni a rọte ugamhi afuẹ mu pfi deba Ẹshinẹgba ni ọ laọ, ni ọ ma ekẹ ali ukhuli ali okẹ oniẹmhi ali emini e la elemhi wẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ẹghẹghẹ ni o dọsẹ, Ẹshinẹgba ọ zẹ ni ushishi ọgbọgbọ ọ ngeli abi o ghọle ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ama ọ kie rọte akanya onete oyọli ri ọlẹlẹ khasẹ khi lọli laọ, lọli ọ rọte idane e ruẹsẹ amẹ shi emhi ẹkọmhi shi ẹghẹghẹ, lọli ọ ri eminale na ẹ ẹ le, ọ ri oghẹlẹ ẹ shi ẹ udu. ");
INSERT INTO atgNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Abi iPọlu ali iBanabasi e riẹ lina nu wẹ ngme ingmemhi ena, ẹa kie dobẹ mu wẹ gba e khi luasẹ ẹwẹ abi ilitsa. ");
INSERT INTO atgNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ẹgbọ iJu eghuo e rọte Atiọki ali iKoniọmu bhale, e ri eta-ọlẹlẹmhunu ti eni ẹgbọ mama egbe, e tono iPọlu echẹ, e tialọ ọli ekẹ fiẹ je ukhokho oni ẹoli, e dabi khi ọ she ghua. ");
INSERT INTO atgNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama abi eni e miesuọ e rọ le gasẹ ọli, ọ vule, ọ nyenẹ egbe je ifuapfẹ ni a la tono ọli echẹ. Ogbeakọlọ, lọli ali iBanabasi e je ẹoli iDẹbi. ");
INSERT INTO atgNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","IPọlu ali iBanabasi e gue usomhi onete le elemhi iDẹbi, ebubu ẹgbọ e miesuọ. Ighọ e nyenẹ egbe je iLisitira ali iKoniọmu ali Atiọki ni o la iPisidia, ");
INSERT INTO atgNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","e ri udu shi eni e miesuọ ọ e ri igẹsikia migha shi oni irudunga. Ẹẹ wẹ, “Neni awa lo Eghiele oyi Ẹshinẹgba, awa ya mẹ anasẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Elemhi igbaa nya eyi eni e mie iJesu iKirisiti suọ ọdọda, ee zẹ egbhali shi, ee pfi azumhi sọ iromhi na wẹ rẹwẹ nga Ọnọmhuẹ ni e regbenga obọ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Abi e rọ kia gasẹ ekẹ iPisidia se, e je ekẹ iPafilia. ");
INSERT INTO atgNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Abi e rọ la ẹoli iPẹga gue usomhi onete le se, e te aghọ je ẹoli Atalia. ");
INSERT INTO atgNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Aghọ e te lo ọkọ-okẹ oniẹmhi nyenẹ egbe jele obini Atiọki; Ashini eni e miesuọ e ke la sọ iromhi na wẹ rẹ wẹ nga okhale oyi Ẹshinẹgba obọ shi akanya ni e ye ya gbe se. ");
INSERT INTO atgNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Abi e rọ jele Atiọki, e lu eni e miesuọ tigbili, e gueyẹ wẹ ikanya ni Ẹshinẹgba ọ rẹ wẹ gbe ali abi ọ li khueghie odẹ-a na ẹgbọ iJẹta ni e miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","E nu eni e miesuọ la akaghọ tẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ẹgbọ eghuo e rọte ekẹ iJudia bhale Atiọki, ee sẹsẹ eni e miesuọ khi, Ini aa li shẹlẹ wẹ-a abi Ushi oyi iMosisi o ngme ẹa ya khi eni a miepfuese. ");
INSERT INTO atgNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Onana o pfi ingme ni o zẹ khi iPọlu ali iBanabasi e nu eni ẹgbọ ni e rọte iJudia bhale e khakọ. Irarighọ, a zẹ iPọlu ali iBanabasi ali eni e miesuọ elese e nga iJerusalẹmu ya mẹ ighiusomhi na kẹẹ ali eni egbhali shi oni ingme. ");
INSERT INTO atgNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ighọ e ghie wẹ e ke lẹ, abi e li rọte ekẹ iFonisha ali iSameria dọsẹ ẹ lẹ, ee gueyẹ ẹgbọ abi ẹgbọ iJẹta e li mu pfi deba Ẹshinẹgba. Onana o pfi oghẹlẹ oniẹmhi na eni e miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Abi e rọ ramhi iJerusalẹmu, eni e miesuọ ali eni egbhali ali ighiusomhi na kẹẹ, e mu wẹ epfẹse. Eni a ghie usomhi e gueyẹ wẹ ikanya ọdọda ni Ẹshinẹgba ọ rọte obọ oyẹwẹ gbe. ");
INSERT INTO atgNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama eni e miesuọ eghuo ni e la otu iFarisi e vule, ẹẹ li, “Ẹgbọ iJẹta e mema shẹlẹ-a. A gueyẹ wẹ e ri Ushi oyi iMosisi ke gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ighiusomhi na kẹ ali eni egbhali e ye ochi shi oni ingme ona. ");
INSERT INTO atgNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Abi e rọ khakọ shi ọ tẹsẹ se, iPita ọ vule, ọọ wẹ, “Inyọghuo, a lẹsẹ khi ẹghẹghẹ ni o dọsẹ, Ẹshinẹgba ọ rọte iteva oyẹ ẹ zẹ mhẹ mhi ka gue oni usomhi onete yẹ ẹgbọ iJẹta ni e mẹ asha suọ, ni e miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ẹshinẹgba ni ọ lẹsẹ isamhi ni e la ọgbọkpa udu, ọ ri Ayẹmhẹ-nọ-pfuasẹ na ẹgbọ iJẹta, rọ rọli khasẹ khi lọli li mie wẹ, ẹzẹzẹ abi ọ li li mie awa. ");
INSERT INTO atgNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ọa ri ikhiọda shi iteva oyawa ali wẹwẹ, irari khi ọ khuẹsẹ udu oyẹwẹ-a pfuasẹ itobọ khi e imiesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Memena, elọ o zẹ khi a nono ni a mhẹsẹ Ẹshinẹgba bino, ni a rọ ọ sheli iJẹta ni e miesuọ itsua ni awa ali eni e bia awa ẹa dobẹ tsua? ");
INSERT INTO atgNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Iiye e! Awa lama shi ọ khi okhale oyi iJesu iKirisiti Ọnọmhuẹ o mie awa pfuese, ighọ li khi wẹwẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Oni igbaa e tsaghiẹ-a tsukẹ, abi e rọ suọ ọlẹlẹ eyi ọnyaloa ali ọshabọ nya ni Ẹshinẹgba ọ rọte obọ oyi iPọlu ali iBanabasi gbe iteva oyi ẹgbọ iJẹta. ");
INSERT INTO atgNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Abi e rọ ngme se, iJemhisi ọọ, “Inyọghuo, a ri esọ shi mhẹ ekẹ! ");
INSERT INTO atgNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ISamọ iPita ọ lẹsẹ guele abi Ẹshinẹgba ọ li mhọli ọmuegbe shi ingme oyi ẹgbọ iJẹta, ni ọ rọte elemhi wẹ sanọ ẹgbọ, rọ mele ẹgbọ eyọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Onana o ri emini emekẹguele e kẹkẹ shi Ebe-no-pfuasẹ bhale ya tsẹ, ni ọọ, ");
INSERT INTO atgNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘Ini a mẹ enana se, mhi ya nyenẹ egbe bhale, mhi rue eghiele oyi iDefidi gbo nyenẹ egbe bhale, mhi riẹlẹ ikpukpu-igbe ni e de kua oyọli ma, mhi gbo zese ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Isheghọ ẹgbọ ni e kpọle nya e nyenẹ egbe bhale deba Ọnọmhuẹ, ẹgbọ iJẹta nya ni mhi lu, e bhale ya khi eyẹmhẹ, Ọnọmhuẹ ọ ngme ghọ, ni ọ riẹlẹ emhi ena.’ ");
INSERT INTO atgNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Lọli ọ she kpẹ zẹ ni a lẹsẹ ona shi ekẹ agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Abi mhi sọ ọ shi khi, awa khi pfi ẹgbọ iJẹta ni e nyenẹ egbe bhale deba Ẹshinẹgba lo ọmunu. ");
INSERT INTO atgNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Awa ri ochoghọ kẹkẹ ebe ya gueyẹ wẹ, e khi ke le eminale ni a rọ luasẹ ikhumhi. Awa gbo gueyẹ wẹ e khi ke ku itsẹbọ, e khi ke le ẹlamhi ni aa fa uruli, e khi ke da ọlia. ");
INSERT INTO atgNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Irari khi o she tẹsẹ ni a te la owa ugamhi ẹ zẹ ebe Ushi oyi iMosisi ẹlẹ Iyẹmhẹa kpa, a ri ingme oyọli ẹ tse abọ ifui ẹoli kpa.” ");
INSERT INTO atgNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ighọ ighiusomhi na kẹẹ ali eni egbhali ali eni e miesuọ nya e te eni ẹgbọ zẹ emọse aava ni a mu ekpẹ ẹ na ma iPọlu ali iBanabasi egbe, je Atiọki. IJudasi iBasabasi ali iSalasi e zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ebe ni e kẹkẹ rọ ghie wẹ usomhi na: Anye ighiusomhi na kẹẹ ali eni egbhali ni anye khi inyọghuo ẹ, anye tsẹ ẹẹ Inyọghuo anye ni a khi ẹgbọ iJẹta ni a la Atiọki ali iSiria ali iSilisha. ");
INSERT INTO atgNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Anye suọ khi ẹgbọ eghuo e rọte anye iteva vu ni o khia khi ọa khi anye ghie wẹ, ni e bhale ya nu ẹ ngme ingmemhi ni oo yese ẹ elemhi-a ali ni oo nasẹ ẹ udu. ");
INSERT INTO atgNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Irarighọ, anye rọ kugbe ghie emọse eghuo ghi ẹ, e deba iBanabasi ali iPọlu emọle anye bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Emọse ena e she ri agbọ oyẹwẹ shi okhẹna itobọ eva oyi iJesu iKirisiti Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Irarighọ, anye rọ ghie iJudasi ali iSalasi ni e ri unu gue emini anye kẹkẹ shi ebe yẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","O ti Ayẹmhẹ-nọ-pfuasẹ ali anye ẹloe, ini anye khi ri itsua elese nasẹ ẹ tsua dọsẹ ishi enana. ");
INSERT INTO atgNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","A ti egbe eminale ni a rọ luasẹ ikhumhi le, a khi ke da ọlia, a khi le ẹlamhi ni aa fa uruli. A khi ku itsẹbọ. O ma a ti ẹ egbe ini a lase emhi enana le. Ẹshinẹgba ọ nu ẹ la. ");
INSERT INTO atgNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Eni emọse ni a ghie usomhi e vu ya tiemhi Atiọki. E ti eni e miesuọ nya gbili, e ri oni ebe na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Abi eni ẹgbọ e rọ zẹ oni ebe se, oghẹlẹ o vọ wẹ elemhi itobọ khi usomhi onete ni o ri udu ẹ shi ọgbọ ọ o tsua. ");
INSERT INTO atgNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","IJudasi ali iSalasi ni e khi emekẹguele e nu wẹ ngme ebubu ingmemhi ri udu shi wẹ ọ, e zese wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","E nu wẹ la aghọ ukuku ẹghẹghẹ, eni e miesuọ e tsẹ wẹ okhila. Wẹwẹ ni a ghie usomhi e nyenẹ egbe je iJerusalẹmu deba eni e ghie wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama iSalasi ọ lama nu wẹ la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","IPọlu ali iBanabasi e la Atiọki, wẹwẹ ali ẹgbọ elese e la aghọ ọ sẹsẹ, ee tse abọ ungmemhi oyi Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Abi ebubu ogbẹlẹ e rọ dọsẹ, iPọlu ọ gueyẹ iBanabasi, ọọ li, “Awa nyenẹ egbe je ẹoli ni awa te dọsẹ ni awa ya bino ẹgbọ ni awa gue ungmemhi oyi Ọnọmhuẹ yẹ, ni awa mẹ abi e ke laọ shi.” ");
INSERT INTO atgNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","O ghọle iBanabasi ni e tsua iJọni ni a gbolo ẹ lu iMaki ma egbe vu. ");
INSERT INTO atgNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama ọa ghọle iPọlu ni e tsua li. Itobọ khi ọni iJọni ni a gbolo ẹ lu iMaki ọa nu wẹ gbe ikanya ramhi ukpẹsẹ ni ọ rọ tsua wẹ kua ekẹ iPafilia vu, ọ sọ ukhokho gbe wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","IPọlu ali iBanabasi e mhọli ekhakọ ni o toto shi ingme ona, e kemhi egbe. IBanabasi ọ rue iJọni iMaki ma egbe, e lo ọkọ-okẹ oniẹmhi da je iSapurọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ama iPọlu ọ pfi obọ rue iSalasi, e vu abi eni e miesuọ e rọ sọ iromhi na wẹ, rẹ wẹ nga okhale irẹloe-khu oyi Ọnọmhuẹ se. ");
INSERT INTO atgNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","E kia rọte ekẹ iSiria ali iSilisha, e ri udu u shi igbaa nya eyi eni e mie iKirisiti suọ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","IPọlu ọ bhale ẹoli iDẹbi ali iLisitira, ashini ọmọ odukhokho ni a lu iTimoti ọ la. Inyọli ni ọ li miesuọ ọ khi ọngi iJu, ama itali ọ khi ọngi iGiriki. ");
INSERT INTO atgNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Igbaa oyi eni e mie iJesu iKirisiti suọ ni e la iLisitira ali iKoniọmu nya e ngme onete oyi iTimoti. ");
INSERT INTO atgNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","IPọlu ọọ nono ni lọli ri iTimoti ma egbe vu, ighọ ọ shẹlẹ ọli-a. Itobọ khi ẹgbọ iJu ni e la oobọ e ga lẹsẹ khi ita iTimoti khi ọngi iGiriki lọ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Abi e li kia ẹoli i gasẹ, e sẹsẹ eni e miesuọ ilamashi ni ighiusomhi na kẹẹ ali eni egbhali ni e la iJerusalẹmu e kẹkẹ shi ebe na wẹ, e gueyẹ wẹ, e rẹwẹ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ighọ igbaa nya eyi eni e mie iKirisiti suọ, e fu u shi irudunga, ee bua shi ọ ẹlẹkpa. ");
INSERT INTO atgNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","IPọlu ali eni e ga kia, e rọte ekẹ iFirigia ali iGalesha, itobọ khi Ayẹmhẹ-nọ-pfuasẹ ọa zẹ wẹ gue usomhi onete le ekẹ Esha. ");
INSERT INTO atgNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Abi e rọ ramhi ekẹ iMisia, ee nono ni wẹwẹ e lo elemhi ekẹ iBitinia, ama Ayẹmhẹ oyi iJesu ọa zẹ wẹ lo. ");
INSERT INTO atgNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ighọ e rọte ekẹ iMisia dọsẹ je iTiroasi. ");
INSERT INTO atgNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ẹliyọsẹ ẹlẹghọ iPọlu ọ mẹ imẹ-alo, ọ mẹ khi ọngi iMasidonia ọ migha a lema, “Bhale iMasidonia ni u ya kpaghiẹ anye obọ!” ");
INSERT INTO atgNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Abi iPọlu ọ rọ mẹ oni imekẹ se, anye mu egbe e lẹ iMasidonia, itobọ khi anye lẹsẹ khi Ẹshinẹgba ọ she lu anye, anye je aghọ ya gue usomhi onete le. ");
INSERT INTO atgNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Anye rọte iTiroasi lo ọkọ-okẹ oniẹmhi da okẹ oniẹmhi je iSamotirasi, ogbeakọlọ, anye te aghọ je iNiapolisi. ");
INSERT INTO atgNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Aghọ anye te je ifuapfẹ oyi iFilipi ni o khi ẹoli ni o mu ẹloe shi ekẹ iMasidonia ni ebubu ẹgbọ iRomu e ngeli. Anye ga la aghọ ebubu ogbẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ogbẹlẹ iyẹmhẹa oyi ẹgbọ iJu, anye te oni ẹoli vu je oni okẹ, ashini anye khọkhọ khi ẹgbọ iJu ee lona shi iromhi isọsọ. Anye shitọ nu ikpotso ni e legba aghọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ọkpotso ọghuo elemhi wẹ ni ọ ri esọ shi ekẹ khi iLidia ọngi iTiatira, ọni ọ ri ide eyilẹ ẹ dẹ. Ọ khi ọkpotso ni ọọ na ulishi Ẹshinẹgba. Abi iPọlu ọ li i ngme, Ẹshinẹgba ọ khueghie ọli udu-a shi oni ungmemhi. ");
INSERT INTO atgNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Abi a rọ batazi ọli ali apfọli se, ọ lu anye je owa oyọli, ọọ anye, “A kha lẹsẹ khi egbegbi ọni ọ miesuọ mhi khi, a bhale ya ku shi na mhẹ.” Ọ ti anye shi ọ ramhi ni anye rọ lama shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ẹlẹghuo abi anye li i je ashini anye la a sọ iromhi, ọmueshi oghumha ọghuo ni ọ mhọli ayẹmhẹ obe ni ọ rọ ọ mekẹ guele emini a ya mẹ, ọ ya to anye ukhomhi. Eri ọ ri oni ekpabọ imẹguele ona a gbe ikpaghọ na eni e mhọli ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ọọ deba iPọlu ali anye, ọọ tsẹsẹ, ọọ liẹ, “Eni ẹ ga Ẹshinẹgba ni ọ funẹ eni ẹgbọ ena e khi! Eri ẹ tse abọ guele abi a li ya mhọli imiepfuese!” ");
INSERT INTO atgNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ina ọ li i riẹlẹ ọli ogbẹlẹ kpa ya ramhi ni oni ingme o rọ ri elemhi i bi iPọlu, ighọ iPọlu ọ nyenẹ egbe gueyẹ oni ayẹmhẹ, ọọ li, “Mhi ri eva oyi iJesu mhẹsẹ nẹ, fiẹ ọli idiegbe ya lase!” Aghọaghọ oni ayẹmhẹ o fiẹ ọli idiegbe ya lase. ");
INSERT INTO atgNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Abi eni e mhọli ọli e rọ mẹ khi ẹa ke mẹ ikpaghọ afa ni e kpẹ te ẹ ọli obọ ọ mẹ, e mu iPọlu ali iSalasi tialọ ghi enighie obini agbala oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","E wolọ wẹ bhale odalo oyi esọ-ẹzọ, ẹẹ wẹ, “Emọse ena, ẹgbọ iJu e khi ni e pfi ozughu ẹ shi awa ifuapfẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","E kia a sẹsẹ ẹgbọ imu ni e khi ọda shi eyi awa. Awa ni awa khi iRomu, awa aa ya dobẹ ri osẹsẹ oyẹwẹ gbe akanya.” ");
INSERT INTO atgNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Eni ebubu ẹgbọ e kuma wẹ ọ gue ẹzọ shi iPọlu ali iSalasi egbe. Ighọ eni esọ-ẹzọ e gueyẹ wẹ e banọ wẹ a, e gbe wẹ itali. ");
INSERT INTO atgNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Abi e rọ gbe wẹ egbegbọ se, e tigbe pfi wẹ lo owa ighumha. E gueyẹ ọni ọọ khẹ-ekhẹ ọ pfi okpẹ ashini ọ rẹwẹ shi egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Abi a rọ ri oni omhẹsẹ na li se, ọ mu wẹ kulo owa aza elemhi oni owa ighumha, ọ sọ wẹ awẹ igha. ");
INSERT INTO atgNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Abi itsotso ogbiẹ o rọ mu ekẹ, iPọlu ali iSalasi ee sọ iromhi, ee to uwolo kuẹghiẹ Ẹshinẹgba. Ighumha eni e kpọle e ri esọ shi wẹ ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Udemhija, ekẹ o ri itoto nighise. Oni owa ighumha o rọte ekẹ jighise egbegbọ. Eloawẹ eloawẹ, odẹ nya ni e lo oni owa le e khueghie-a. Iwẹghẹ ni e rọ gẹ eni ighumha nya e ku wẹ awẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Abi ọni ọọ khẹ ekhẹ aghọ ọ rọ mẹ khi odẹ ni e la oni owa ighumha nya khi e khueghie-a, ọ dabi khi ighumha ni e la aghọ nya e she pfue. Ighọ ọ ji itakobi emhi lasele ni luẹ rọ gbe egbeluẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ama iPọlu ọ tsẹsẹ leghe, ọọ li, “Khi gbe egbe ẹ-a! Anye nya anye la ana.” ");
INSERT INTO atgNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ọni ọọ khẹ ekhẹ ọghọ ọ lu ọgbọ ọ nyanya rue ugbili bhale. Ọ ri ulishi-ulishi na buẹ buẹ, ọ de ya wugha odalo oyi iPọlu ali iSalasi. ");
INSERT INTO atgNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ighọ ọ rue wẹ lasele, ọ mhila wẹ, “Elọ mhi ya li ni mhi rọ ya mhọli imiepfuese?” ");
INSERT INTO atgNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ẹẹ ọli, “Yẹyẹ ali apfẹ nya a mie iJesu Ọnọmhuẹ suọ khi a ya mhọli imiepfuese.” ");
INSERT INTO atgNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ighọ e gue ungmemhi oyi Ọnọmhuẹ ye ọli ali apfẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ighọ ọni ọmọse ọ wolọ wẹ, ọ dua wẹ utse ni a kuali wẹ. IPọlu ali iSalasi e rue ọli ali apfọli ya batazi na aghọaghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ighọ ọ rue iPọlu ali iSalasi nga owa oyọli ya ri eminale na le. Oghẹlẹ o vọ ọli ali apfọli nya udu irari khi e she mie Ẹshinẹgba suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ẹlẹ uzogbe ogbeakọlọ, eni esọ-ẹzọ e ri unu na ipolisi e ka gueyẹ ọni ọọ khẹ-ekhẹ ọghọ, “Zobẹ emọse eghọ obọ ni e vu.” ");
INSERT INTO atgNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ighọ ọni ọọ khẹ ekhẹ ọghọ ọọ iPọlu, “Esọ-ẹzọ e she ri unu bhale a wolọ ẹ abọ-a ni a ke vu. Opfọmhẹ o ka nu ẹ kia.” ");
INSERT INTO atgNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama iPọlu ọọ li, “Anye a li ingme okhọghuo ni a rọ mu anye gbe itali ukpẹloe oyi ẹgbọ nya, aboriẹkhia khi ẹgbọ iRomu anye khi! Ama e mu anye kulo owa ighumha. Memena, ẹẹ nono ni wẹwẹ e bẹna rue anye abọ-a, ọa ya tsẹ e! Eni esọ-ẹzọ wẹwẹ-ghuo e bhale ya wolọ anye lasele.” ");
INSERT INTO atgNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Eni ipolisi e lẹ ya gueyẹ eni enighie abi e ngme. Abi e rọ suọ khi ẹgbọ iRomu iPọlu ali iSalasi e khi, ulishi o mu wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ighọ e vu ya kuegbe-a lema wẹ, e wolọ wẹ owa ighumha le, e lema wẹ e kpẹkpẹ e lase ẹwẹ ifuapfẹ le. ");
INSERT INTO atgNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ighọ iPọlu ali iSalasi e lase oni owa ighumha le, e ya je apfẹ oyi iLidia. E bhale ya ẹ eni e miesuọ aghọ. E ri udu shi wẹ ọ, e rọte aghọ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","IPọlu ali iSalasi e rọte Afipolisi ali Apolonia dọsẹ e bhale iTẹsalonika ashini owa ugamhi oyi ẹgbọ iJu o la. ");
INSERT INTO atgNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","IPọlu ọ dọsẹ je owa ugamhi abi ọ kie kpẹ ẹ li. Ẹfo uka esẹ ọ la aghọ nu wẹ rọte Ebe-no-pfuasẹ ku ochi. ");
INSERT INTO atgNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ọ rọte Ebe-no-pfuasẹ rọli khasẹ gboo, khi ọni Ọmiepfuese, ọ mema ya mẹ osoli, ọ rọte eghuli guale. IPọlu ọ gueyẹ wẹ, “IJesu ni mhi rọ ọ tse abọ yẹ ẹ ọ khi ọni Ọmiepfuese ni Ẹshinẹgba ọ shobọ khi lọli ya rọ bhale.” ");
INSERT INTO atgNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ẹgbọ iJu eghuo e mie shi emini iPọlu ali iSalasi e ngme, e ku ma wẹ ọ ọ ga Ẹshinẹgba. Ighọ li khi ẹgbọ iGiriki eni ẹ na ulishi Ẹshinẹgba ali ebubu ikpotso ni e fialo-a e li miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ama ẹgbọ iJu ee kpe ofuma, e kia ya luno ẹgbọ usuesọ-akhuẹ tigbili shi okhọli. E pfi ozughu shi oni ẹdẹli nya. E tsua okhọli lo owa oyi ọmọse ni a lu iJasi ya nono iPọlu ali iSalasi ni wẹwẹ e muno wẹ lasele na eni ẹgbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama abi ẹa rọ mẹ wẹ, e tialọ iJasi ali eni e miesuọ elese ghọ je odalo oyi enighie eyi oni ẹoli, e tsẹsẹ leghe, e liẹ, “Emọse ena e she pfi ozughu shi asha kpa! Memena e gbo bhale ifuapfẹ eyi awa, ");
INSERT INTO atgNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","IJasi ọ mie wẹ shi owa oyọli. Ẹ da ishi eyi iSiza, ẹẹ khi oghie ọlese ọ laọ ni a lu iJesu.” ");
INSERT INTO atgNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Abi e rọ suọ eni ingmemhi ena, elemhi e te ododẹ yese eni ebubu ẹgbọ ali enighie eyi oni ẹoli-a. ");
INSERT INTO atgNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","E ri iJasi ali eni a ga muno wẹ eghọ zẹ oko, neni a tigbe zẹwẹ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Obili o lẹsẹ bi ẹlẹghọ, eni e miesuọ e ghie iPọlu ali iSalasi je iBẹrea. Abi e rọ ramhi aghọ, e je owa ugamhi oyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ẹgbọ ni e la aghọ e mhọli udu ni o khueghie-a dọsẹ eni e la iTẹsalonika. E ri esọ shi oni usomhi onete egbegbọ. Ogbẹlẹ kpa e rọ wẹna Ebe-no-pfuasẹ ni e mẹ ini emini iPọlu ọ gueyẹ wẹ ini igẹsikia lọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ẹgbọ iJu ebubu e miesuọ, ikpotso iGiriki ni e fia alo-a, ali emọse iGiriki e li miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ama abi ẹgbọ iJu ni e la iTẹsalonika e rọ suọ khi iPọlu ọ la iBẹrea a tse abọ ungmemhi oyi Ẹshinẹgba, e bhale aghọ ya ngmiasẹ ẹgbọ e ka pfi ozughu. ");
INSERT INTO atgNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Eloawẹ eloawẹ, eni e miesuọ ẹẹ iPọlu vu ke je egele okẹ oniẹmhi, ama iSalasi ali iTimoti e kie la iBẹrea. ");
INSERT INTO atgNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Eni emọse ni e kphase iPọlu, e rọ li bhale Atẹni, e gbo nyenẹ egbe je iBẹrea. IPọlu ọ ghie wẹ ghi iSalasi ali iTimoti e kẹlẹ bhale ya ẹ luẹ shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Abi iPọlu ọ li migha Atẹni i khẹ iSalasi ali iTimoti, ọ mẹ ilitsa ọdọda ni e la oni ekẹ, o nighise ọli ayẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ighọ ọ nu ẹgbọ iJu ali ẹgbọ iJẹta ni ẹẹ na ulishi Ẹshinẹgba ku ochi elemhi owa ugamhi. Ighọ ọ li gbo nu ẹgbọ kpa ni e rọte olele e dọsẹ ẹ ngme ogbẹlẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ẹgbọ eghuo ni ẹ sẹsẹ, ni e khi Ẹpikuria ali iSitoiki e nu ọli i khẹ akọ. Abi iPọlu ọ rọ ngme ungmemhi oyi iJesu ali irọte eghuli guale, eghuo ọ e liẹ, “Elọ ọyẹghẹ ọna ọ mẹ ẹ ngme?” Eghuo ẹẹ li, “Abi khi eri ọọ liẹ awa ke ga ilitsa eyi ẹoli oboese?” ");
INSERT INTO atgNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ighọ e rue iPọlu bhale owa ni a lu Aropagọsi. (Owa ona eguebe ni e la ẹoli Atẹni ẹẹ legba.) “Anye ẹ nono ni u gueyẹ anye abi osẹsẹ onogbọ ona o ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ingmemhi ni u wa ngme, enegbọ e khi shi anye esọ, gueyẹ anye abi e ngme.” ");
INSERT INTO atgNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Irari khi ẹgbọ Atẹni nya, ali epfẹse ni e la ọ, e ma pfuse ẹghẹghẹ-a ke ngme ingmemhi ali ke ri esọ shi owẹna ali ilẹsẹ enegbọ ni e shẹ lasele ẹ gbigbi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","IPọlu ọ vule migha wẹ iteva ọ wẹ, “Emọse Atẹni, mhi mẹ ẹ mẹ khi ẹgbọ ni e mhuẹ ulishi oyi Ẹshinẹgba a khi. ");
INSERT INTO atgNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Irari khi abi mhi rọọ kia ifuapfẹ eyẹ ẹ gasẹ mhi bino ikhumhi ebubu ni aa ga. Mhi mẹ okula oghuo ni a kẹkẹ emhi shi, ni ọọ, ‘Oyi olitsa ni aa lẹsẹ.’ Emini a ga ni ẹẹ khi aa lẹsẹ, mhi ya gue ingme oyọli yẹ ẹ ena. ");
INSERT INTO atgNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ẹshinẹgba ni ọ ma agbọ ali emhikpa ni e la elemhi wẹ, lọli ọ khi Ọnọmhuẹ ọyi ekẹ ali ukhuli ni ọa ya la Owa ugamhi ni ẹgbọ e ri abọ tọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wẹkhi eri ọ nono emhikhọghuo ali ikpaghiobọ oyi ẹgbọ. Itobọ khi lọli ọ ri agbọ ali ayẹmhẹ ali emhikpa na ẹgbọ nya. ");
INSERT INTO atgNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ọgbọ ọghuo ọ te ma ẹgbọ ọdọda na ushishi ni e la agbọ nya, Lọlighuo ọ ri ẹghẹghẹ shi ekẹ na ushishi ni e rọ ya la agbọ ali khi ọ shi ughuli oyi ọgbọgbọ nali. ");
INSERT INTO atgNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Lọli ọ lighọ riẹlẹ ona ini ẹgbọ e rọshẹka ke nono ọli, ini e mẹ asha ramhi ọli egbe. Ama Ẹshinẹgba ọa nuata shi ọngẹ-awa ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Lọli ọ ri ekpabọ na awa la agbọ ni awa rọ́ ọ kia, ni awa rọ khi ọni awa khi,’ ali khi, ‘imi ọli awa khi,’ abi ekẹkebe eyẹ ẹ eghuo e li ngme ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Irarighọ, aborọkhia khi imi Ẹshinẹgba awa khi, awa khi ke rọli khọkhọ isheli ni ẹgbọ e ri ẹnẹli ri igolu ali ẹlomho ali echẹ ma. ");
INSERT INTO atgNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ẹghẹghẹ ni o dọsẹ, eri Ẹshinẹgba ọ mu alo kua shi umhalẹsẹ oyi ẹgbọ. Memena ọ she ri omhẹsẹ ni ọgbọkpa ni ọ la ashakpa ọ mu nyenẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Irari khi ọ she shi ogbẹlẹ shi ekẹ ni ọ rọ ya ri ọmọse ọghuo gue agbọ kpa ẹzọ. Ẹshinẹgba ọ she rọkhasẹ agbọ khi igẹsikia onana o khi ni ọ rọ rọte eghuli guise ọni ọmọse ọna lẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Abi e rọ suọ khi iPọlu ọ ngme ramhi irọte eghuli guale, e ri ọli i li egia, ama elese ẹẹ ọli, “Anye a nono ni anye gbo suọ ungmemhi ona ẹlẹlese.” ");
INSERT INTO atgNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ighọ iPọlu ọ rọte ọni ilegba vu. ");
INSERT INTO atgNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Emọse eghuo e deba li, e mie ọli suọ. IDionisusi ni ọ khi ọghuo oni igbaa Aropagọsi ọ li deba li. Ighọ li khi ọkpotso ọghuo ni a lu iDamarisi ali ẹgbọ eghuo elese e li laọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Abi a rọ mẹ eni ingme ena se, iPọlu ọ rọte ẹoli Atẹni vu je ẹoli iKọriti. ");
INSERT INTO atgNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Aghọ ọ bhale ya ẹ ọngi iJu ọghuo ni a lu Akuila ni a bia shi ekẹ iPọtusi. Ọni lọli ali ughuẹ ọli ni a lu iPisila e lẹsẹ rọte ekẹ Itili bhale, irari khi oghie iRomu nya ni a lu iKiladiusi ọ shi ushi na ẹgbọ iJu nya ni e la ẹoli iRomu nya e lase ẹoli iRomu lẹ. IPọlu ọ lẹ ya bino wẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","irari khi akanya ọni ọ ri ide ẹ ghi okholo ọọ gbe, ọ nu Akuila ali iPisilia a gbe oni akanya ni ee gbe. Ọ nu wẹ la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ogbẹlẹ Iyẹmhẹa oyi ẹgbọ iJu kpa ọ rọ je owa ugamhi oyi ẹgbọ iJu ya nu wẹ ku ochi ini ọ dobẹ ri oni ungmemhi lo ẹgbọ iJu ali ẹgbọ iGiriki esọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Abi iSalasi ali iTimoti e rọ rọte ekẹ iMasidonia bhale, iPọlu ọ ri ẹghẹghẹ ni ọ mhọli nya gue oni ungmemhi yẹ ẹgbọ iJu, khi iJesu ọ khi Ọmiepfuese ni Ẹshinẹgba ọ shobọ khi ọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Abi eni ẹgbọ iJu e rọ nu ọli khẹ akọ ni e rọ zẹ ẹmuẹ ebe na li, ọa lama shi wẹ ọ, ọ kpe abọ shi wẹ ọ, Ọọ, “Mhi kpe abọ shi ẹ ọ. Ini a pfua, ẹẹ a ya mu ota sọ. Ọa khi mhẹmhẹ a ya mu ota sọ shi ọlia eyẹẹ. Rọte memena vu, mhia je ekẹ oyi ẹgbọ iJẹta.” ");
INSERT INTO atgNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ọ pfi wẹ shi aghọ vu, ọ je owa oyi ọgbọ iJẹta ni a lu iTatọsi iJọsitọsi ni ọọ ga Ẹshinẹgba, ni owa oyọli o la mama owa ugamhi oyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","IKirisipusi ni ọ khi ọga shi oni owa ugamhi ali apfọli e mie Ọnọmhuẹ suọ; ebubu ẹgbọ ni e la iKọriti ni e suọ oni usomhi e miesuọ, a batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ẹliyọsẹ ẹlẹghuo, iPọlu ọ mẹ imẹ-alo ni Ọnọmhuẹ ọ la nu ọli ngme, ọọ li, “Ulishi o khi mu ẹ, ama kie ke gue ungmemhi le, khi tsaghiẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Irari khi mhi nu ẹ la. Ọgbọ ọa la ọ ni ọ ya kuali ẹ utse. Irari khi mhi mhọli ebubu ẹgbọ shi ẹoli ona ni e khi ẹgbọ eyẹmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ighọ iPọlu ọ la iKọriti ukpe oghuo ali ukhukhui, ọọ sẹsẹ eni ẹgbọ ungmemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Abi iGalilio ọ rọ khi igọvunọ ni iRomu e zẹ shi obini ekẹ Akhaya, ẹgbọ iJu eghuo e kugbe mu okhọli vule shi iPọlu ọ, e mu ọli je ikọtu. ");
INSERT INTO atgNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ẹẹ li, “Eri ọmọse ọna ọọ sẹsẹ ẹgbọ odẹ ẹgbhọli ni a te ẹ ga Ẹshinẹgba abi ushi oyi awa ọa ngme.” ");
INSERT INTO atgNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Abi iPọlu ọ li i nono ni lọli ngme, ighọ iGalilio ọ nu ẹgbọ iJu ngme, ọọ, “Ini ẹzọ ni a lu ena o khia khi oyi umhaguẹli lọ okekhi oyi ingmobe okhọghuo lọ, mhi kha kuegbe-a ri esọ shi ẹ ẹẹ ẹgbọ iJu ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama abi o rọ khi ungmemhi ekhakọ ni o la ingmemhi ali eva ali ushi oyẹẹ eghọ, ẹẹ-ghuo a ya sọ oni ingme, mhi aa ya sọ ọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ọọ a khu wẹ ikọtu ya fiẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","E gamhi iSositẹnisi ni ọ khi ọga shi owa ugamhi mu. E la odalo oni ikọtu gbe ọli. Ama iGalilio ọa fẹ pfi esọ shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","IPọlu ọ nu eni e miesuọ la iKọriti ogbẹlẹ ni e bu, ighọ ọ li tsẹ wẹ okhila, lọli ali iPisilia ali Akuila e lo ọkọ-okẹ oniẹmhi da okẹ oniẹmhi je iSiria. Neni iPọlu ọ rọte iKẹnkhiria da okẹ oniẹmhi, ọ yamhi itsu ukhomhi-a itobọ irọnga ni ọ rọ nga. ");
INSERT INTO atgNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","E ramhi Efesọsi, ashini iPọlu ọ pfi iPisilia ali Akuila shi. Ọ je owa ugamhi ni ọ nu ẹgbọ iJu ku ochi. ");
INSERT INTO atgNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Eni ẹgbọ ẹ ọ nu wẹwẹ la aghọ tẹsẹ, ama ọa lama. ");
INSERT INTO atgNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ochoghọ, ọ gueyẹ wẹ abi ọ rọ ọ vu, ọọ, “Ini o da khi ọghuẹmhẹ ọyi Ẹshinẹgba, mhi ya nyenẹ egbe bhale deba ẹ.” Ighọ ọ rọte Efesọsi lo ọkọ-okẹ oniẹmhi vu da okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Abi ọ rọ ramhi iSizeria, ọ te aghọ je iJerusalẹmu ya tsẹ eni e miesuọ, ọ ke te aghọ je ẹoli Atiọki. ");
INSERT INTO atgNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Abi ọ rọ la aghọ ukuku ẹghẹghẹ, ọ te aghọ vu, ọ rọte ekẹ iGalesha ali iFirigia ya ri udu shi eni e miesuọ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Oni ẹghẹghẹ, ọmọse ọnge iJu ni a lu Apolosi ni a bia shi Alẹzadira ni ọ khi ọni ọ mema guẹ ebe, o gbo lolo lẹsẹ ebe nọ pfuasẹ, ọ bhale Efesọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ọ khi ọgbọ ni a rọte ekẹ sẹsẹ odẹ oyi Ọnọmhuẹ. Ọ mhọli ọmuegbe ni o fu ni ọ rọ sẹsẹ ingme oyi iJesu. Emini ọọ sẹsẹ o rọte odẹ igẹsikia. Ama osẹsẹ oyi iJọni Ọni ọọ batazi ẹgbọ ọ lẹsẹ guẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ighọ ọ li la owa ugamhi oyi ẹgbọ iJu ri igbedu u ngme. Abi iPisila ali Akuila e rọ suọ ẹmuẹ ni o la li unu, e rue ọli ma egbe je apfẹ, e kuegbe-a sẹsẹ ọli odẹ oyi Ẹshinẹgba shi ọ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolosi ọ rọli shi udu khi lọli ya je Akhaya, eni e miesuọ ni e la Efesọsi e kpaghiẹ ọli obọ, e kẹkẹ ebe ghi eni e miesuọ ni e la Akhaya. E gueyẹ wẹ e kpe abọ mie ọli. Abi ọ rọ ramhi akaghọ, ọ khi ikpaghiobọ oniẹmhi na eni e rọte okhale oyi Ẹshinẹgba miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Irari khi ọ nu ẹgbọ iJu khẹ akọ egbegbọ, ọ rọ mu wẹ ọ le. Ọ rọte Ebe-no-pfuasẹ rọkhasẹ wẹ khi iJesu ọ khi Ọmiepfuese ni a shobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Abi Apolosi ọ li la elemhi iKọriti, iPọlu ọ rọte elemhi oni ekẹ kia rọte ugbogbode ni o khi ute ute e dọsẹ, ọ bhale Efesọsi. Aghọ ọ bhale ya ẹ eni e miesuọ eghuo, ");
INSERT INTO atgNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ọ mhila wẹ, ọọ wẹ, “Abi a rọ miesuọ, a li mie Ayẹmhẹ-nọ-pfuasẹ?” Ẹẹ ọli, “Anye a fẹ suọ khi a mẹ emini a lu Ayẹmhẹ-nọ-pfuasẹ ghue.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","IPọlu ọọ wẹ, “Ibatizi onabi onoghuo a kpẹ mie?” Ẹẹ ọli, “Ibatizi oyi iJọni.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","IPọlu ọọ wẹ, “Ibatizi oyi iJọni, ibatizi ona imupfi lọ. Ama ọni iJọni ọ gueyẹ ẹgbọ iZirẹni e mie ọni ọ ya bhale ikpukhokho oyẹluẹ suọ, ikhi iJesu.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Abi e rọ suọ ona se, a ri eva oyi iJesu Ọnọmhuẹ batazi wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","IPọlu ọ ri abọ nga wẹ ukhomhi, Ayẹmhẹ-nọ-pfuasẹ ọ tiemhile shi wẹ ọ, ee ngme ẹmuẹ onogbọ. E gbolo o ngme ungmemhi ni Ẹshinẹgba ọ rọ shi wẹ unu. ");
INSERT INTO atgNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wẹwẹ nya e khi emọse ogbava. ");
INSERT INTO atgNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","IPọlu ọ lo elemhi owa ugamhi, ọ la aghọ iki esẹ, ọ ri igbedu nu eni ẹgbọ ngme. Ọ nu wẹ ku ochi, ọọ sẹsẹ wẹ ni e mie shi ingme Eghiele oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama eghuo ọ e khi isuesọ-akhuẹ ni ẹa lama miesuọ. E la ukpẹloe oni igbaa ngme ingmemhi ebe deba oni odẹ. Ighọ iPọlu ọ pfi wẹ shi aghọ vu, ọ rue eni e deba li je owa oyi iTiranọsi. Ọ la aghọ nu wẹ ẹ ku ochi ingme iloghie ogbẹlẹ kpa. ");
INSERT INTO atgNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ikpe eva ọ la aghọ sẹsẹ wẹ, ghe ẹgbọ iJu ali ẹgbọ iGiriki ni e la ekẹ Esha, e suọ ungmemhi oyi Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ẹshinẹgba ọ te obọ oyi iPọlu u gbe ikanya ọshabọ ọdọda. ");
INSERT INTO atgNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","O ya ramhi khi ibẹde ali ọgbẹnẹ ni a rọte iPọlu egbe wolọ, e ri ẹgbọ ni ẹa ze e toto, ali e khu ẹgbọ ayẹmhẹ ọkphaghiẹ idiegbe ya lase. ");
INSERT INTO atgNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ẹgbọ iJu eghuo ni ee kia ukhomhi ẹoli gasẹ ri imajiki i khu ayẹmhẹ obe kua, e li nono ni e ri eva oyi iJesu Ọnọmhuẹ riẹlẹ abi imajiki khu ayẹmhẹ obe. E liẹ, “Anye ri eva oyi iJesu ni iPọlu ọ rọ tse abọ mhẹsẹ nẹ, fiẹ lase!” ");
INSERT INTO atgNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Imi ọga ọyi ekpodalo ugamhi ọnge iJu ọghuo ni a lu iSikiva etuoshilua, ee li ona. ");
INSERT INTO atgNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ighọ, oni ayẹmhẹ obe, ọọ wẹ, “Mhi lẹsẹ iJesu, mhi lẹsẹ iPọlu, eghuo a khi?” ");
INSERT INTO atgNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ọni ọmọse ni ọ mhọli oni ayẹmhẹ obe ọghọ, ọ kpha rughu wẹ, ọ gbe wẹ kuali utse. E ri irumheba na kua. ");
INSERT INTO atgNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Abi ẹgbọ iJu ali iJẹta ni e la ekẹ Efesọsi e rọ suọ emini a mẹ, ulishi oo mu wẹ. E ri ékpẹ́ na eva oyi iJesu Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Igbaa oyi eni e mie iJesu iKirisiti suọ e fiẹ lasele gboo, e zọnọ olamhẹ eyẹwẹ le nya. ");
INSERT INTO atgNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ebubu wẹ ni e kpẹ ẹ li ẹboli, e wolọ ebe ni e rọ ọ li ẹboli nya lasele tosẹ-a. Abi a rọ ta ingmẹ ni a rọ dẹ eni ebe ni e tosẹ-a, e ya khi ẹkpa udududu. ");
INSERT INTO atgNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ighọ ungmemhi oyi Ọnọmhuẹ oo gẹ shi ọ tsẹ, oo toto-a. ");
INSERT INTO atgNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Abi a rọ mẹ ingme ena se, iPọlu ọ sa ọ khi lọli ya rọte ekẹ iMasidonia ali Akhaya dọsẹ je iJerusalẹmu. Ọọ eni ẹgbọ, “Mhi kha ramhi aghọ se, mhi ya rọte oobọ je ẹoli iRomu.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ighọ ọ ghie iTimoti ali Erasitọsi ni e nu ọli a gbe akanya je iMasidonia. Lọli ọ la ekẹ Esha ukuku ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Oni ẹghẹghẹ, ukpokpomhi onyaghu o ya de shi ẹoli Efesọsi irari osẹsẹ ni iPọlu ọọ sẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ọmọse ọghuo ọ la ọ, ni a lu iDẹmẹtiriusi ni ọọ lumhi igolu rọ riẹlẹ irọkhọkhọ okula oyi olitsa Atẹmisi. Ọ tsua oki oniẹmhi ghi eni e gbe oni akanya. ");
INSERT INTO atgNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ighọ ọni ọmọse ọ luno wẹwẹ nya kugbe, ọọ wẹ, “A lẹsẹ khi egbegbi eleli awa rọte oni oki ona mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mena a she mẹ, a gbolo suọ ikanya ni iPọlu ọọ gbe. Lọli ọọ gueyẹ ẹgbọ khi ilitsa ni a ri abọ mama khi afuẹ e khi. Ebubu ẹgbọ ni e la ẹoli Efesọsi ali ekẹ Esha nya e she mie ọli suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Oki oyawa o she la okhẹna ni o rọ ọ le eva obe. Ali khi ekpẹ oniẹmhi ni a rọ na olitsa Atẹmisi ali okula oyọli o ya mele afuẹ-a. Olitsa ona ẹgbọ ni e la ekẹ Esha ali agbọ nya ẹẹ ga.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Abi eni ẹgbọ e rọ suọ ona, elemhi ee bi wẹ. E ri ofu tsẹsẹ ẹ gasẹ ekẹ gbii, ee liẹ, “Olitsa ọnọfunẹ, Atẹmisi o khi ni anye ẹgbọ Efesọsi anye ẹẹ ga.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Oni okeke o gbhiaku oni ẹoli. Eni ẹgbọ e mu iGayusi ali Arisitakusi ni e khi engi iMasidonia ni e nu iPọlu kia a gasẹ. E rue wẹ bhale olele. ");
INSERT INTO atgNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","IPọlu ọọ nono ni lọli je odalo oyi oni igbaa, ama eni e miesuọ ẹa zẹ ọli obọ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ekhẹmhuẹ eghuo ni ẹẹ mhẹsẹ shi oni ekẹ ni e khi emọle iPọlu e li ghie usomhi ya lema li ọ khi bie je elemhi olele ya ri egbọli khasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Oni ẹghẹghẹ, okeke oniẹmhi o de elemhi oni igba. Eghuo e kha ngme ẹ je ola, elese e ngme ẹ je oobọ. Ẹgbọ eghuo ni e la aghọ ẹa lẹsẹ emini o pfi oni ozughu. ");
INSERT INTO atgNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Eni ẹẹ ralo na ẹgbọ iJu eghuo e tanọ Alẹzada abọ je odalo ọ ka ngme na ẹwẹ. E gueyẹ ọli emini ọ ya ngme. Ighọ ọni Alẹzada ọ ri abọ gbe wẹ akhiakhia. Ọ guele emini a mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama abi eni ebubu ẹgbọ e rọ lẹsẹ khi ọngi iJu ọ khi, e ri uruli oghuo tsẹsẹ gbii, elemhi iwakati eva, ee liẹ, “Olitsa onofunẹ Atẹmisi o khi ni anye ẹgbọ Efesọsi ẹẹ ga.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ikpukhokho ọ, ọkẹkẹ-ebe ọyẹwẹ ọ fiẹ lasele, ọ ri abọ gbe wẹ akhiakhia. Ọọ wẹ, “Inyọghuo-mhẹ ẹgbọ Efesọsi, ọgbọkpa ọ lẹsẹ khi awa khi eni ẹ khekhẹ okula Atẹmasi, ali ẹchẹli oyọli ni o rọte idane de tiemhile? ");
INSERT INTO atgNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Aa mẹ ọgbọkhọghuo ni ọ dobẹ ya tia onana. Itobọ ighọ a diẹ oili lalọ ni udu oyẹẹ o pfọmhẹ. A khi ri inyanya-dọsẹ riẹlẹ emhikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Eri a muno emọse ena bhale abi o riẹ khia khi ẹa rọte oni owa ugamhi do ughiatọ, wẹkhi eri e zẹ ẹmuẹbe na olitsa ni awa a ga. ");
INSERT INTO atgNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ini iDẹmẹtiriusi ali apfọli e mhuẹ ọgbọkhọghuo ni ọ li wẹ ingme, a lẹsẹ khi awa mhọli ikọtu ali esọ-ẹzọ, ọ ka lu eni ẹgbọ ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ama ini a mẹ emhese ni a nono ni a rọ lasele, a zẹ ni a la igba ni a la gue ẹzọ sọ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Irari khi ini a bino emini a mẹ amo, awa la okhẹna ipfa ẹzọ mu khi awa, awa pfi ozughu. Awa aa ya mẹ ẹzọ gue pfa egbe awa shi ekẹ, irari khi awa aa mhọli emini o pfi oni ozughu onana.” ");
INSERT INTO atgNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Abi ọ rọ ngme se, ọọ oni igba o vẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Abi oni okeke o rọ pfọmhẹ, iPọlu ọ ghie ya lu eni e miesuọ. Ọ ye wẹ ude se, ọ tsẹ wẹ okhila. Ọ je ekẹ iMasidonia. ");
INSERT INTO atgNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ọ rọte oni ekẹ dọsẹ. Ọ kia ri ingmemhi ni e bu ri udu shi eni e miesuọ ni e la oni ekẹ ọ. Ikpukhokho, ọ ramhi ekẹ iGirisi. ");
INSERT INTO atgNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ọ la aghọ iki esẹ. Irari khi ẹgbọ iJu è gba ugbamhi obe khẹ ọli, abi ọ li nono ni lọli lo ọkọ-okẹ oniẹmhi je iSiria, ọ ri ochoghọ mu egbe pfi rọte odẹ iMasidonia vu. ");
INSERT INTO atgNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ISopata omi iParọsi ọngi iBẹrea ọ deba li, li shi Aristakusi ali iSẹkudọsi ni e khi engi iTẹsalonika, ghe iGayusi ali iTimoti engi iDẹbi, gbo li shi iTakikọsi ali iTirofimọsi ni e khi engi ekẹ Esha. ");
INSERT INTO atgNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Etuava ni a ngme kpukhokho enana, e je odalo ya migha khẹ anye obini ẹoli iTiroasi. ");
INSERT INTO atgNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Anye rọte iFilipi kia ukhomhi okẹ oniẹmhi ogbẹlẹ ishe, abi a rọ li ukpe ibulẹdi ni aa ri ifuma shi nye se. Anye bhale ya ẹ eni e migha ẹ khẹ anye ẹoli iTiroasi, anye la aghọ ogbẹlẹ ishilua. ");
INSERT INTO atgNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ogbẹlẹ nododẹ elemhi ẹfo uka, anye bhale kugbe ni anye ya le eminale ni o pfuasẹ. IPọlu ọ nu eni ẹgbọ ngme tẹsẹ irari khi ọ ya vu ogbeakọlọ. Ọ ngme ya ramhi itsotso ogbiẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A ri igbili ni e bu ru shi elemhi owa ukhomhi atọnga ni anye legba. ");
INSERT INTO atgNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ọzẹo ọghuo ni a lu Iyutikọsi ọ shitọ okele ni o la oni atọnga. Ukpokpomhi olesẹ o dọ li rue abi iPọlu ọ rọ ngme e tẹsẹ dọsẹ. Abi iPọlu ọ kie li i ngme, oni olese o lo ọli egbe ramhi ni ọ rọ rọte ukhomhi atọnga nuzi-esẹ de ya tiemhi ekẹ. Abi ẹ rọ mu ọli vule, ọ she ghua. ");
INSERT INTO atgNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ama iPọlu ọ tiemhi ekẹ, ọ mu ọli ko elemhi, ọ to ọli etuli, ọọ, “A li tsukẹ, ayẹmhẹ oyọli ọ kie laọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ighọ, ọ nyenẹ egbe nga atọnga, e le eminale ni o pfuasẹ. Ọ nu wẹ ngme ramhi ni ovọ o rọ ngale. IPọlu ọ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eni ẹgbọ e rue ọni ọzẹo je apfẹ, ọa mhọli ikuatse okhọghuo. Onana o ri udu pfọmhẹ wẹ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Anye lo ọkọ-okẹ oniẹmhi je odalo ya migha khẹ iPọlu Asọsi, asha ni iPọlu ọ te ya deba anye lo ọkọ-okẹ oniẹmhi. Lọli ọ mhẹsẹ ona itobọ khi awẹ ọ rọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Abi ọ rọ bhale ya ẹ anye shi Asọsi, anye ga lo ọkọ okẹ oniẹmhi oghuo je iMitileni. ");
INSERT INTO atgNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ogbeakọlọ, anye lo ọkọ okẹ oniẹmhi te aghọ ya je iKhiosi, ogbẹlẹ ni o de bali, anye rọte aghọ da je iSamosi, ogbeakọlọ anye ramhi iMilẹtusi. ");
INSERT INTO atgNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","IPọlu ọa nono ni lọli migha ẹoli Efesọsi itobọ ini lọli khi pfuse ẹghẹghẹ a shi ekẹ Esha, irari khi inyanya ọ la ini lọli kẹlẹ ramhi iJerusalẹmu shi ogbẹlẹ iPẹtikọsiti. ");
INSERT INTO atgNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ẹoli iMilẹtusi iPọlu ọ te ghie usomhi ghi egbhali ni e la igba oyi ẹgbọ eni e miesuọ ni e la ẹoli Efesọsi e bhale ya ẹ luẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Abi e rọ ramhi aghọ, ọọ wẹ, “A lẹsẹ abi mhi li nu ẹ ngeli abi mhi rọ la iteva oyẹẹ, rọ tẹ ogbẹlẹ onododẹ ni mhi te lo ekẹ Esha le. ");
INSERT INTO atgNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Rọte iregbemhẹ-tiemhile ali amẹ eviẹ mhi rọ gbe ikanya eyẹmhẹ abi ọni ọọ ga ọyi Ọnọmhuẹ, ẹghẹghẹ ni o rọ ze mu mhẹ ni ẹgbọ iJu e rọ gba khẹ mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ẹa lẹsẹ khi mhi aa ri emhikhọghuo ni o ya kpaghiẹ ẹ obọ sheli ẹ abi mhi rọ ọ tse abọ ali ni mhi rọ ọ sẹsẹ ẹ elemhi igbaa ali ifuapfẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mhi she kpẹ gueyẹ ẹgbọ iJu ali ẹgbọ iJẹta khi e mema a te olamhẹ eyẹwẹ mu pfi deba Ẹshinẹgba ni e mie iJesu Ọnọmhuẹ ọyawa suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Memena, ni mhi rọ suọ esọ na Ayẹmhẹ-nọ-pfuasẹ, mhia lẹ iJerusalẹmu, ni o khia khi mhi aa lẹsẹ emini mhi ya mẹ oobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mhi lẹsẹ khi asha kpa ni mhi je, Ayẹmhẹ-nọ-pfuasẹ ọ she kpẹ gueyẹ mhẹ khi owa ighumha ali anasẹmhẹ e migha a khẹ mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama eri mhi leli agbọ oyẹmhẹ shi afuẹ, ini mhi lẹsẹ mẹ asha gbe akanya ni iJesu Ọnọmhuẹ ọ mhẹsẹ na mhẹ pfo. Ikhi itsabọ usomhi onete isomhelemhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mhi she kia rọte asha je asha tse abọ ungmemhi Eghiele oyi Ẹshinẹgba yẹ ẹ. Memena mhi lẹsẹ khi ọngẹẹ, ọa kẹ tigbe ya mẹ mhẹ ghue. ");
INSERT INTO atgNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Irarighọ, mhi gueyẹ ẹ amo khi ini ọngẹẹ ọ pfua, ọa ke la obọ oyẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Irari khi ulishi ọgbọkhọghuo ọa mu mhẹ ni mhi rọ gue ungmemhi oyi Ẹshinẹgba yẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ighọ, a ri ẹloe khu egbe ẹ, ali ọgbọkpa ni Ayẹmhẹ-nọ-pfuasẹ ọ rọ nga ẹ obọ. Khi ọrisumha-kia ọyi igbaa oyi eni e mie iJesu iKirisiti suọ oyi Ẹshinẹgba ni ọ ri ọlia eyọli dẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mhi lẹsẹ khi ini mhi da vu se, ẹgbọ ni e khọlọ abi ekpẹ ali idumhi e ya lo ẹ iteva le, ẹa ya zẹ eni isumha obọ khi ẹa kuali wẹ utse. ");
INSERT INTO atgNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ẹghẹghẹ o ya ramhi ni ẹgbọ eghuo elemhi ẹ e rọ ya ri ingmemhi ẹgbhuẹ di eni e miesuọ, e rue iteva oyẹẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Irarighọ, a ri ẹloe shi ọ, a gbo sato khi elemhi ikpe esẹ mhi aa tigbe yẹmhẹ-a itse agua ye ẹ, shi ẹlẹ ọguota ghe ẹliyọsẹ, elemhi eviẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Memena, mhi rẹ ẹ nga Ẹshinẹgba obọ, ali ungmemhi isomhelemhi oyọli, ni o ya rẹ ẹ fu shi irudunga, ni o ya rẹ ẹ mhọli ugu ni eni Ẹshinẹgba ọ she khuẹsẹ pfuasẹ e ya mhọli. ");
INSERT INTO atgNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mhi aa dọ ọgbọkhọghuo ọkọnyọ ẹlomho ali igolu wẹkhi ode oyọli. ");
INSERT INTO atgNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ẹẹ a lẹsẹ khi abọ eyẹmhẹ ena mhi rọ gbe akanya rọ dẹ emini mhẹmhẹ ali eni e nu mhẹ kia ẹẹ nono kpa. ");
INSERT INTO atgNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Elemhi emini mhi riẹlẹ kpa, mhi rọkhasẹ ẹ khi awa mema ya ri akanya igbegbe onana kpaghiẹ eni ẹa mhọli obọ. A sato ungmemhi oyi iJesu Ọnọmhuẹ, ni ọọ, ‘Ikhivọsẹ o la irọna dọsẹ imiemie.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Abi iPọlu ọ rọ ngme se, lọli ali ẹwẹ e wugha, ọ sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ee viẹ abi e li i tsẹ ọli okhila, e mu ọli, ni e pfipfi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Oni o lolo ri egbe pfọ wẹ-a khi oni ọ gueyẹ wẹ khi ẹa kẹ tigbe ya mẹ luẹ ghue. Ighọ e kphase ọli ya lo ọkọ-okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Anye tsẹ wẹ okhila se, anye kia okẹ oniẹmhi talala a je ẹoli iKọsi. Ogbeakọlọ anye je ekẹ iRodisi, anye rọte aghọ je ẹoli iPatara. ");
INSERT INTO atgNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Anye lo ọkọ-okẹ oniẹmhi ni oo je ekẹ iFonisha, ighọ anye lo ọ vu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Anye nise alo mẹ iSapurọsi, anye rọte ukiẹkiẹ ọgobọ ini a sọ alo ghue obini ovọ o te ẹ lo eko. Anye je ekẹ iSiria. Anye migha ẹoli iTai, aghọ ọkọ oyi anye o la tiese itsua shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Anye mẹ ẹgbọ eni e miesuọ eghuo, anye nu wẹ la aghọ ogbẹlẹ ishilua. Ayẹmhẹ-nọ-pfuasẹ ọ gueyẹ wẹ iPọlu ọ khi je ekẹ iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Anye nu wẹ la aghọ ramhi ẹghẹghẹ ni anye nu wẹ ya la akaghọ ramhi se, anye rue okiali ekẹ. Igbaa oyi eni e mie iJesu iKirisiti suọ nya ali ighuẹwẹ ali imiwẹ e kphase anye fiẹ lasele oni ẹoli, anye ramhi esesọ okẹ oniẹmhi, anye wugha sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Anye tsẹ egbe okhila se, anye ya lo ọkọ-okẹ, wẹwẹ e nyenẹ egbe ukhokho, e je apfẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Anye rọte iTai vu, anye bhale iTolẹmasi. Anye la aghọ tsẹ eni e miesuọ, anye nu wẹ la aghọ ogbẹlẹghuo. ");
INSERT INTO atgNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Anye vu ogbeakọlọ, anye ramhi iSizeria. Anye kushi owa oyi iFilipu ọni ọ kia gue ungmemhi oyi Ẹshinẹgba le, ni ọ khi ọghuo ẹgbọ oshilua ni a la iJerusalẹmu zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ọ mhọli eniyẹ imueshi aane ni ẹa ye ughuẹ ne, ni e mẹ ekẹ ẹ guele. ");
INSERT INTO atgNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Abi anye rọ la aghọ ogbẹlẹ ni e bu, ọmekẹguele ni a lu Agabusi ọ rọte ekẹ iJudia bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ighọ ọ rue ugbhogbho ni a rọ ọ mu oku oyi iPọlu. Ọ rọli gẹnọ egbọli abọ ali awẹ. Ọọ, “Ayẹmhẹ-nọ-pfuasẹ ọọ khi, ‘Ina ẹgbọ iJu ni e la iJerusalẹmu e li ya gẹ ọni ọ mhọli ugbhogbho ona, e mu ọli na ẹgbọ iJẹta.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Abi anye rọ suọ ona, anye ali ẹgbọ elese ni e la aghọ, anye lema iPọlu ọ khi je iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ama iPọlu ọọ, “Elọ o zẹ ni a rọ ọ viẹ, ni a rọ ọ yese mhẹ udu-a. Aa khi eri mhi lẹsẹ mu egbe ni a rọ ya gẹ mhẹ tsẹ, ama mhi ga mu egbe ni mhi rọ ya ghu-a shi iJerusalẹmu, irari eva oyi iJesu Ọnọmhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Abi anye aa rọ dobẹ zu ọli odẹ, anye yẹmhẹ-a, anye ẹ ọli, “O ka tsẹ abi o ghọle Ọnọmhuẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Onana o dọsẹ se, anye mu egbe, anye nga iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Eniyẹ odukhokho eghuo ni e la iSizeria, e kphase anye, e ri anye bhale owa oyi iMinasọ, ni ọ khi ọngi iSapurọsi ni ọ khi ọghuo eni e kpẹ tododẹ miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Abi anye rọ ramhi iJerusalẹmu, eni e miesuọ e kpe abọ mie anye egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ogbeakọlọ iPọlu ali anye enekpọle anye ya mẹ iJemhisi, eni egbhali eni e miesuọ nya e li la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","IPọlu ọ tsẹ wẹ, ọ kuegbe-a gueyẹ wẹ ikanya ni Ẹshinẹgba ọ gbe shi iteva oyi ẹgbọ iJẹta rọte akanya oyi Ẹshinẹgba ni ọọ gbe. ");
INSERT INTO atgNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Abi e rọ suọ ingmemhi ni iPọlu ọ ngme se, e kuẹghiẹ Ẹshinẹgba. Ighọ ẹ iPọlu, “Inyọghuo, wa a mẹ ẹgbọ agbẹlẹ-agbẹlẹ eyi iJu ni e mie iJesu suọ, wẹwẹ nya e mhọli ọmuegbe shi iri ushi gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","E she kpẹ suọ khi eri u wa sẹsẹ ẹgbọ iJu nya e tsua Ishi eyi iMosisi kua, khi u wẹ e khi shẹlẹ imi wẹ-a ali e khi ke deba ighuighuẹ eyi ẹgbọ iJu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sẹ awa ya li, irari khi e mema ya suọ khi u she bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ina anye nono u li, emọse aane e nu anye la ana ni e she rọ nga. ");
INSERT INTO atgNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Rue emọse ena, ni a ga ya riẹlẹ ikhuẹ-pfuasẹ. U gbo fali ota na wẹ ni a rọ ya ta wẹ itsu-a. Isheghọ, ọgbọkpa ọ ya lẹsẹ khi ẹgbhọli a kie mẹ, khi u ri Ishi eyi iMosisi ẹ gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ama anye she ri ebe ghi ẹgbọ iJẹta eni e miesuọ rọ gueyẹ wẹ abi anye ngme, khi e ti egbe eminale ni a rọ luasẹ obo le, ali e khi ke da ọlia ali e khi le ẹlamhi ni aa fa uruli, ali e lase itsẹbọ ikuku le.” ");
INSERT INTO atgNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ogbeakọlọ, iPọlu ọ rue eni emọse, e ga ya riẹlẹ ikhuẹ-pfuasẹ. Ighọ ọ je Owa Oyi Ẹshinẹgba ya gueyẹ wẹ ogbẹlẹ ni oni ikhuẹ-pfuasẹ o ya pfo ali emini a rọ ya riẹlẹ iluasobo na ọgbọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Abi eni ogbẹlẹ ishilua e rọ ya gba, ẹgbọ iJu eghuo ni e rọte ekẹ Esha bhale e mẹ iPọlu elemhi Owa Oyi Ẹshinẹgba. E tanọ shi eni ebubu ẹgbọ elemhi, e mu iPọlu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","E tsẹsẹ leghe, ẹẹ li, “Ẹgbọ iZirẹni, a kpaghiẹ anye obọ. Eri ọni ọmọse ọna ọ kia sẹsẹ ẹgbọ ashakpa, mu okhọli vule shi ẹgbọ eyawa ọ, ali ishi eyawa ali Owa Oyi Ẹshinẹgba onana. Ọa khi ena tsẹ, ọ she gbo rue ẹgbọ iGiriki lo Owa oyi Ẹshinẹgba oyawa ya ri ichimhi mu asha ni o pfuasẹ onana.” ");
INSERT INTO atgNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Eri e ngme ona itobọ khi e mẹ iTirofimọsi ọngi Efesọsi ali iPọlu ifuapfẹ, e dabi khi ọ she rọli lo Owa Oyi Ẹshinẹgba.) ");
INSERT INTO atgNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Onyaghu o lo oni ifuapfẹ nya le, eni ẹgbọ e rọte ashakhasha na a bhale. E mu iPọlu, e rọte oni Owa oyi Ẹshinẹgba ti ọli lasele, aghọaghọ, e sọ okpẹ odẹ nya. ");
INSERT INTO atgNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Abi eni ẹgbọ e li nono ni wẹwẹ gbe ọli-a, oni ingme o ramhi esọ oyi ọni ọọ mhẹsẹ na ekhọli-okhuẹ eyi iRomu khi ẹdẹli iJerusalẹmu nya o la onyaghu oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Eloawẹ eloawẹ, ọ wolọ ekhọli-okhuẹ ma egbe e na tiemhi deba eni ebubu ẹgbọ. Abi eni ẹ nyaghu eghọ e rọ mẹ ọli ali eni ekhọli-okhuẹ, e mu mhuẹ, ẹ a ke gbe iPọlu. ");
INSERT INTO atgNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ọni ọ mhẹsẹ na ekhọli-okhuẹ ọghọ ọ mu iPọlu, ọ e ri iwẹghẹ eva gẹ ọli. Ọ mhila eni ẹgbọ ọni ọ khi ali emini ọ li. ");
INSERT INTO atgNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ẹgbọ eghuo ni e la oni igba ee tsẹsẹ, ọgbọgbọ ọ ngme oyọli. Abi ọni ọga ọkhọli-okhuẹ ọghọ ọa rọ lẹsẹ emini ee ngme, ọọ a mu iPọlu ya shi apfẹ ekhọli-okhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Abi e rọ ramhi unu owa, eni ekhọli-okhuẹ e mu iPọlu tsua irari khi eni ẹ dọmhi ọli e bu dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ighọ e li kpikpi deba li, ee tsẹsẹ gbii, e liẹ, “A gbe ọli-a, a gbe ọli-a.” ");
INSERT INTO atgNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Abi eni ekhọli-okhuẹ e li mu iPọlu lo apfẹ eyi ekhọli-okhuẹ, ọọ ọga ọyẹwẹ, “Mhia nono ni mhi nu ẹ ngme?” Ọni ọga ọọ li, “U guẹ ẹ ngme ẹlẹmhi iGiriki?” ");
INSERT INTO atgNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Ọa khi yẹyẹ u khi ọngi iJipiti ni ọ ke gba onyaghu ekẹ le? Ni u wolọ ẹgbọ agbẹlẹ ene ni ee gbolo ekhọli-okhuẹ eyi iRomu-a, ni u rue wẹ je ọdagbe ifufu ya mu wẹ egbe shi onyaghu?” ");
INSERT INTO atgNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","IPọlu ọ sọ li ọ, ọọ li, “Ọngi iJu ni a bia shi ẹoli iTasọsi ni o la ekẹ iSilisha mhi khi. Ọmọ ekẹ ẹoli ni o mu ẹloe. Kpẹkpẹ zẹ mhẹ nu eni ẹgbọ ena ngme.” ");
INSERT INTO atgNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Abi ọga ọyi ekhọli-okhuẹ ọ rọ ri oni ẹghẹghẹ na li, iPọlu ọ migha atẹtẹ unu odẹ, ọ ri abọ nu wẹ ngme e tsaghiẹ-a. Abi e rọ tsaghiẹ-a, iPọlu ọ ri ẹlẹmhi Iburu nu wẹ ẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Inyọghuo-mhẹ ali itamhẹ ni a mu ekpẹ ẹ na, a ri esọ shi ekẹ ni a suọ ẹzọ ni mhi ya gue pfa egbemhẹ shi ekẹ ena.” ");
INSERT INTO atgNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Abi e suọ khi ọ nu wẹ ngme ẹlẹmhi Iburu, e ga lolo tsaghiẹ-a. Ighọ iPọlu ọọ, ");
INSERT INTO atgNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ọngi iJu mhi khi, ni a bia shi ẹoli iTasọsi ni o la ekẹ iSilisha. Ẹoli iJerusalẹmu ona mhi la fu vule. Ayi iGamaliẹ a la sẹsẹ mhẹ egbegbọ abi a liẹ deba ishi eyi ititawa. Eri mhi mhọli ọmuegbe shi ingme oyi Ẹshinẹgba egbegbọ ẹzẹzẹ abi ẹẹ a ke li ogbe na amo. ");
INSERT INTO atgNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Eri mhi mu okhọli vule shi ẹgbọ ni e rọte Odẹ oyi Ọnọmhuẹ ọ, ramhi ni mhi rọ gbolo eghuo-a. Mhi mu emọse ali ikpotso kulo owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ọkpeda na ekpodalo-ugamhi eyi Ẹshinẹgba ali enighie e ya pfi ọtsẹlẹ shi ọ khi igẹsikia mhia ngme. Mhi mie wẹ ebe ghi eni eralo na ẹgbọ iJu ni e la iDamasikọsi, ni mhi rọ ya ri iwẹghẹ shi eni e miesuọ ni e la oobọ abọ, ni mhi muno wẹ je iJerusalẹmu ya nasẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ẹlẹghuo khi mhi i lẹ iDamasikọsi, itsotso ọguota khi mhi lẹsẹ ti ramhi oni ẹoli, ákpá ni o lolo gẹ nyanyanya o rọte irarogbe mi nga mhẹ egbe udemhija. ");
INSERT INTO atgNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ighọ mhi de ya gbe, mhi suọ khi uruli ọọ mhẹ, ‘ISọlu! ISọlu! Elọ e zẹ ni u rọ mu okhọli vule shi mhẹ ọ?’ ");
INSERT INTO atgNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Mhi mhila li, ‘Ọghuo u khi, Ọnọmhuẹ?’ “Ọọ mhẹ, ‘Mhẹmhẹ khi iJesu ọnge iNazarẹti ni u mu okhọli vule shi ọ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Emọse ni e nu mhẹ kia, e mẹ oni ákpá, ama ẹa suọ uruli ni o nu mhẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Mhi mhila li, ‘Elọ mhi ya riẹlẹ, Ọnọmhuẹ?’ “Ọnọmhuẹ ọọ mhẹ, ‘Vule ni u lo elemhi ẹoli iDamasikọsi, a ya la aghọ gueyẹ emini a mhẹsẹ nẹ nya ni u ya riẹlẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mhi zẹ alo itobọ ugẹmhi ákpá ni o mi nga mhẹ alo. Eni anye ga kia e ke mu mhẹ obọ lo elemhi ẹoli iDamasikọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ọmọse ọghuo ọ la aghọ ni a lu Ananayasi. Ọni ọ ga ugamhi, ni ọ ri ushi ẹ gbe akanya ọ khi. Ẹgbọ iJu nya e mu ekpẹ a na li. ");
INSERT INTO atgNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Lọli ọ bhale ya migha mama mhẹ, ni ọọ, ‘Inyọghuo-mhẹ iSọlu, alo eyẹ e khueghie-a,’ utoghuo kpe, alo eyẹmhẹ e khueghie-a, mhi mẹ ekẹ mẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ọọ mhẹ, ‘Ẹshinẹgba ọyi ititawa ọ she zẹ kẹẹ, ni u lẹsẹ ọghuẹmhẹ oyọli, ni u mẹ Ọni ọ suọ esọ na Ẹshinẹgba, ni ọ ri unu oyọli nu ẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Irari khi u ya khi ọtsẹlẹ ọyọli, ni u ke ngme emini u suọ ali ni u gbo ri alo mẹ, gueyẹ ẹgbọ nya. ");
INSERT INTO atgNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Memena, elọ u ke migha khẹ? Vule ni mhi batazi ẹ, ni a gbe olamhẹ eyẹ kua nẹ, rọte eva oyi Ọnọmhuẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Aghọ mhi te mu egbe pfi je ẹoli iJerusalẹmu. Abi mhi rọ la Owa Oyi Ẹshinẹgba lema, mhi mẹ imẹ-alo, ");
INSERT INTO atgNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ighọ mhi mẹ Ọnọmhuẹ, ọ gueyẹ mhẹ, ‘Nyanya rọte ẹoli iJerusalẹmu vu, itobọ khi eni ẹgbọ ena, ẹa ya mie shi ọtsẹlẹ oyẹ ni u ya pfi na mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Mhiẹ ọli, ‘Ọnọmhuẹ, eni ẹgbọ ena e ga lẹsẹ khi mhẹmhẹ mhi kia kia owa ugamhi muno ẹgbọ ni e mie ẹ suọ kulo owa ighumha, mhi gbe wẹ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ali, ẹlẹ ni e gbe iSitivini-a ni ọ li khi ọtsẹlẹ, mhẹmhẹ mhi la aghọ, mhii mie obọ shi oni eghuli, mhi ri ẹloe khu itsua na eni e tono ọli echẹ gbe-a.’ ");
INSERT INTO atgNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ọni Ọnọmhuẹ ọọ mhẹ, ‘Ke lẹ, mhi ya ghie ẹ je odonuẹ ghi ẹgbọ iJẹta.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Eni ebubu ẹgbọ e ku esọ-a na iPọlu kie ramhi ana ni ọ rọ ngme na, ighọ e li tsẹsẹ leghe, ẹẹ li, “A mu ọli vu, A gbe ọli-a. Ọna ọa ke khi ọni ọ́ọ́ la agbọ!” ");
INSERT INTO atgNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","E tsẹsẹ, ee pfi ide idane wiliwili, e yalọ ifufu ku nga idane. ");
INSERT INTO atgNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ọni ọọ mhẹsẹ na ekhọli-okhuẹ, ọọ a rue iPọlu lo apfẹ oyi ekhọli-okhuẹ. Ọọ wẹ, e gbe ọli itẹ ni e mhila li ini e lẹsẹ emini o zẹ khi ẹgbọ iJu e lina a tsẹsẹ ku ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ama abi e rọ gẹ iPọlu, ni wẹwẹ e gbe ọli, iPọlu ọ mhila ọni ọga ọyi ọkhọli-okhuẹ ni ọ migha aghọ, “Ushi o lama a shi ọ u gbe ọmọ ekẹ iRomu itali ini aa mẹ umhaguẹli ọli obọ ne?” ");
INSERT INTO atgNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Abi ọni ọga oyi ọkhọli-okhuẹ ọ rọ suọ ona, ọ lẹ ya gueyẹ ọni ọọ mhẹsẹ na wẹ ni ọ kpeda na li. Ọọ, “Guẹ kia e, sẹẹ u wa li ena? Ọmọse ọna ọmọ-ekẹ iRomu ọ khi e.” ");
INSERT INTO atgNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ighọ ọni ọọ mhẹsẹ na wẹ ọ lẹ deba iPọlu ọ mhila li, “Mhiẹ i, ọmọ-ekẹ iRomu u khi?” IPọlu ọọ, “Ii, ọmọ-ekẹ mhi khi.” ");
INSERT INTO atgNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ọni ọọ mhẹsẹ na ekhọli-okhuẹ ọọ, “Ọmọ-ekẹ ni mhẹmhẹ mhi khi, ikpokpomhi ikpaghọ mhi fali rọ mie ebe rọ khi ọmọ ekẹ.” IPọlu ọọ, “Ama mhẹmhẹ oyẹmhẹ, ọngi iRomu a bia mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ẹloawẹ-ẹloawẹ, eni ekhọli-okhuẹ ni e nono ni wẹwẹ e mhila iPọlu ingme unu, e ti egbe je ukhokho, abi ọni ọọ mhẹsẹ na ekhọli-okhuẹ ọ rọ lẹsẹ khi ọngi iRomu iPọlu ọ khi, ulishi oo mu ọli, irari khi ọ she gueyẹ wẹ e ri iwẹghẹ shi ọli abọ, e gbe ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ogbeakọlọ, ọni ọọ mhẹsẹ na ekhọli-okhuẹ ọọ nono ni lọli lẹsẹ emini ẹgbọ iJu e nu iPọlu ẹ gue, ọ taghiẹ iPọlu iwẹghẹ-a. Ọ gueyẹ ighie eyi ekpodalo-ugamhi ali iSaẹdiri e legba. Ọ rue iPọlu bhale ya migha odalo oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","IPọlu ọ bino oni igbaa iSaẹdiri tatata, ọọ wẹ, “Inyọghuo-mhẹ, mhi she rọte udu onete oyẹmhẹ nya gbe akanya oyẹmhẹ pfo na Ẹshinẹgba ya ramhi amo.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Abi ọ rọ ngme ona, Ọga ọyi ekpodalo ugamhi ni a lu Ananayasi ọọ eni e ti mama iPọlu e lase ọli unu. ");
INSERT INTO atgNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","IPọlu ọọ li, “Ẹshinẹgba ọ ya ri emhi liẹ, yẹyẹ ugbe ni a ri ẹtseli gboloa. Yẹyẹ u shitọ aghọ a gue mhẹ ẹzọ egbe-a, ama yẹyẹ ọyẹ u gbe ushi-a abi u li ri unu bhale a ri emhi li mhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Eni e ti mama iPọlu ẹ ọli, “Ú ga gbudu ri unu a ghi ọga ọyi ekpodalo ugamhi eyi Ẹshinẹgba?” ");
INSERT INTO atgNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","IPọlu ọọ wẹ, “Inyọghuo-mhẹ, mhi aa lẹsẹ khi lọli ọ khi ọga ọyi ekpodalo ugamhi eyi Ẹshinẹgba! A kẹkẹ ọli shi ebe-no-pfuasẹ, ‘Khi gbudu ngme onobe oyi ọni ọ mhẹsẹ na ẹgbọ eyẹ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Abi iPọlu ọ rọ lẹsẹ khi eghuo eni ẹgbọ khi iSadusi e khi, eni e kpọle e khi iFarisi, ọ la oni igbaa ngme lasele leghe, ọọ, “Inyọghuo-mhẹ, otu iFarisi mhi la, mhi gbo khi omi iFarisi. Eri a la ana a gue mhẹ ẹzọ itobọ khi mhi mhọli irudushọ khi eni e ghu-a e ya gbo guale.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Abi ọ li ngme ona se, uwola o de ni otu iFarisi ali otu iSadusi, oni igbaa o kemhi. ");
INSERT INTO atgNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Irari khi otu iSadusi ẹa lama shi ọ khi ẹgbọ e ya rọte eghuli guale, ẹa gbo lama khi igẹni ali iyẹmhẹ e la ọ, ama otu iFarisi e lama shi enana nya.) ");
INSERT INTO atgNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ukpokpomhi okeke o de, esẹsẹ Ishi eyi iMosisi eghuo ni e khi otu iFarisi e vule e khẹ akọ ni o toto, ẹẹ li, “Anye aa mẹ emhikhọghuo obọ oyi ọmọse ọna,” e gbolo ẹ, “Ini o fẹ khi-a khi ayẹmhẹ, o ke khi agẹni ọ nu ọli ngme?” ");
INSERT INTO atgNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Oni ekhakọ o pfuse toto-a shọ, ulishi o mu ọni ọga ọyi ekhọli-okhuẹ khi e tigbe khẹrẹ iPọlu-a. Ighọ ọ mhẹsẹ na eni ekhọli-okhuẹ e tiemhi ya ri itoto mie wẹ iPọlu obọ ni e rọli bhale apfẹ oyi eni ekhọli-okhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ẹlẹ iyọsẹ ni oo deba li, Ọnọmhuẹ ọ migha mama iPọlu, ọọ li, “Mhuẹ igbedu! Abi u li la iJerusalẹmu pfi ọtsẹlẹ na mhẹ, ighọ u li mema ya li pfi ọtsẹlẹ na mhẹ ẹoli iRomu.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ogbeakọlọ, ẹgbọ iJu eghuo e ya mhẹsẹ kugbe, e romhi isheli khi wẹwẹ ẹa ya le eminale wẹkhi eri wẹwẹ e ya da amẹ, ini ẹa li gbe iPọlu-a. ");
INSERT INTO atgNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ẹgbọ ni e gba ugbamhi onana, e dọsẹ ẹgbọ egbhuẹva. ");
INSERT INTO atgNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","E lẹ deba ọga ọyi ekpodalo ugamhi eyi Ẹshinẹgba ali eni egbhali, ẹ li, “Anye she romhi ukpokpomhi isheli khi anye aa ya le emhikhọghuo sẹ khi anye gbe iPọlu-a. ");
INSERT INTO atgNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Memena, yẹyẹ ali igbaa iSaẹdiri a kẹkẹ ebe ghi ọga ọyi ekhọli-okhuẹ, a liẹ khi a nono ni a lolo suọ oni ingme bie. Anye mu egbe ni anye rọ ya gbe ọli-a neni a rọli ya ramhi ana.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ama abi ọmọ ọmọse ni ọ khi omi inyọghuo iPọlu ọni ọkpotso ọ rọ suọ oni ugbamhi, ọ je oni apfẹ ekhọli-okhuẹ ya gueyẹ iPọlu. ");
INSERT INTO atgNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ighọ iPọlu ọ lu ọga ọyi ekhọli-okhuẹ ọghuo, ọọ, “Rue ọzẹo ona ghi ọni ọọ mhẹsẹ na ẹ, ọ mhọli emini ọ ya gueyẹ ọli.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ighọ ọ rue ọli ghi ọni ọọ mhẹsẹ na wẹ. Ọ li, “IPọlu ni a mu shi igha ọọ mhi rue ọzẹo ọna ghi ẹ, itobọ khi ọ mhọli emini ọ ya gueyẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ọni ọọ mhẹsẹ ọghọ, ọ mu ọni ọzẹo obọ, e ti je olase, ọ mhila li, “Elọ wa nono ni u gueyẹ mhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ọọ li, “Ẹgbọ iJu e she gba li khi wẹwẹ e ya ghie ghi ẹ akọ, ni u rue iPọlu bhale odalo oyi iSaẹdiri khi ẹẹ nono ni e te unu oyọli suọ oni ingme bie. ");
INSERT INTO atgNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Khi lama shi wẹ ọ, itobọ khi e bu dọsẹ ẹgbọ egbhuẹva ni e kpe odẹ khẹ ọli. E she romhi ishe khi wẹwẹ ẹa ya le, wẹkhi eri wẹwẹ e ya da ini wẹwẹ ẹa li gbe iPọlu-a. E migha a khẹ ni e suọ emini u ya sọ shi emini e mhila ẹ ena.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ọni ọọ mhẹsẹ na eni ekhọli-okhuẹ ọ gueyẹ ọli, ọọ, “Khi gueyẹ ọgbọ ọkhọghuo khi u she gueyẹ mhẹ.” Ọọ li ọ ke lẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ighọ ọni ọ mhẹsẹ ọghọ ọ lu ega ekhọli-okhuẹ aava eyọli, ọ mhẹsẹ na wẹ, ọọ wẹ, “A wolọ ekhọli-okhuẹ egbhuẹgbe, ali eni ẹ nga ichi egbhuẹsẹ ali ogbe, ali epfi-ote egbhuẹgbe ni a ke lẹ iSizeria agogo itili amiọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","A ri achi na iPọlu nga ni a rọli je oobọ ini emhikhọghuo e khi li ọli, ni a rue ọli ghi iFẹlisi ni ọ khi igọvunọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ọ lina kẹkẹ ebe na wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Mhẹmhẹ iKiladiusi iLisiasi mhi kẹkẹ ebe onana ghiẹ: Yẹyẹ igọvunọ iFẹlisi ni a mu ekpẹ ẹ na, Mhia tsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ẹgbọ iJu e mu ọmọse ọna, e nono ni wẹwẹ e gbe ọli-a. Ama eri mhi ri ekhọli-okhuẹ eyẹmhẹ bhale ya pfa li shi ekẹ irari khi mhi suọ khi ọmọ-ekẹ iRomu ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mhi i nono ni mhi lẹsẹ emini e zẹ ni e rọ gue ẹzọ ọ shi ọli egbe, mhi rue ọli je igbaa iSaẹdiri oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mhi bhale ya ẹ khi ẹzọ ingme ishi eyẹwẹ e rọ nali i gue, ama ọa mhuẹ emini ọ li ni abi a gbe ọli-a shi, wẹkhi imuọli shi ọgba igha. ");
INSERT INTO atgNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Abi a rọ gueyẹ mhẹ ugbamhi ni e gba khẹ ọni ọmọse, mhi rọ nyanya rue ọli ghi ẹ, mhi gbo gueyẹ eni e gue ẹzọ a shi ọli egbe e bhale deba ẹ ni e guele emini ọ li. ");
INSERT INTO atgNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Oni ẹliyọsẹ ẹlẹghọ, eni ekhọli-okhuẹ e rue iPọlu mhọli obọ vu, abi a li mhẹsẹ ọli na wẹ, e ramhi Atipatirisi. ");
INSERT INTO atgNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ogbeakọlọ, eni ekhọli-okhuẹ e rọli na eni e nga ichi ni e rue ọli kie ke lẹ, wẹwẹ e nyenẹ egbe ukhokho je apfẹ ekhọli-okhuẹ oyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Abi eni e nga ichi eghọ e rọ ramhi ẹoli iSizeria, e rue oni ebe na ọni igọvunọ iFẹlisi, e rue iPọlu na li. ");
INSERT INTO atgNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ọni igọvunọ ọ zẹ oni ebe, ọ mhila iPọlu ukiẹkiẹ obini ọ khi. Abi ọ rọ bhale ya lẹsẹ khi ekẹ iSilisha ọ te bhale, ");
INSERT INTO atgNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ọọ, “Mhi ya suọ ẹzọ oyẹ ini eni e gue ẹzọ shi ẹ egbe e ramhi ana.” Ighọ ọ mhẹsẹ a ri iPọlu nga ekhe-khẹ obọ ni e la agbala oyi Erọdu. ");
INSERT INTO atgNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Abi ogbẹlẹ ishe e rọ dọsẹ, Ọga ọyi ekpodalo ugamhi ni a lu Ananayasi ọ je iSizeria, lọli ali egbhali eghuo ali ilọya ni a lu iTatulọsi. E bhale odalo oyi igọvunọ ni a lu iFẹlisi ni e ya gue ẹzọ shi iPọlu egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Abi a rọ lu iPọlu bhale, iTatulọsi ọ gue ẹzọ oyọli shi ekẹ khasẹ iFẹlisi: Ọọ, “Irẹloe-khu oyẹ o she ri anye mhọli opfọmhẹ ali emhi enegbọ ukhomhi ekẹ ona. ");
INSERT INTO atgNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ashakhasha ali odẹkhodẹ anye te ẹ kuẹghiẹ ẹ, anye ẹ nono ni anye kphẹmhi nẹ shi ona, yẹyẹ iFẹlisi oghie. ");
INSERT INTO atgNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ini anye khi pfuse ẹ ẹghẹghẹ-a, mhi lema ẹ u kpẹkpẹ u ku esọ-a shi anye ekẹ ukuku ẹghẹghẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Eri anye mẹ ọmọse ọna shi ọgbọ ingme, ni ọ tsua okhọli ẹ lasele ke tanọ ẹgbọ iJu ni e la ekẹ agbọ nya, e ke pfi onyaghu ali umha-suesọ. Lọli ọ ralo na ẹgbọ otu iNazarini ");
INSERT INTO atgNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ọ gbolo o nono ni lọli ri ichimhi mu Owa oyi Ẹshinẹgba, lọli anye rọ gba li mu. Anye e nono ni anye gue ọli ẹzọ abi ushi oyanye o ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ama iLisiasi ọni ọ mhẹsẹ na ekhọli-okhuẹ, ọ bhale ya ri itoto ti anye luẹ abọ mie rue vu. ");
INSERT INTO atgNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ọọ eni e mẹ umha-guẹli oyi ọmọse ọna e bhale odalo oyẹ. Ini u mhila ọmọse onana ogbọ u ya mẹ igẹsikia ni o la ẹzọ ni anye gue shi ọli egbe ena.” ");
INSERT INTO atgNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Eni ẹgbọ iJu ni e la aghọ e kugbe lama shi ẹzọ ni a gue shi ekẹ, khi igẹsikia lọ. ");
INSERT INTO atgNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Abi ọni igọvunọ ọ ri obọ nu iPọlu ngme ọ gue shi ọli ọ. IPọlu ọọ, “Mhi lẹsẹ khi ikpe ni e bu u te la ukhomhi ẹoli ona a sọ ẹzọ, itobọ ona egbe ẹ mu mhẹ ni mhi rọ migha odalo oyẹ ya gue ẹzọ pfa egbemhẹ shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Abi u kie kpẹ lẹsẹ, amo o gbe ẹlẹ igbẹva ni mhi rọ je iJerusalẹmu ni mhi ya ga ugamhi. ");
INSERT INTO atgNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ẹgbọ iJu ni e gue ẹzọ shi mhẹ egbe ẹa bhale ya ẹ mhẹ shi elemhi Owa Oyi Ẹshinẹgba khi mhi nu ọgbọkhọghuo ẹ khẹ akọ, wẹkhi eri mhi la owa ugamhi, wẹkhi ifuapfẹ ashikhọghuo tanọ ebubu ẹgbọ abọ shi onyaghu. ");
INSERT INTO atgNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ẹa mhọli abi e li dobẹ rọ ya migha pfi ọtsẹlẹ shi ẹzọ ni e gue shi mhẹ egbe khi igẹsikia lọ. ");
INSERT INTO atgNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mhi lama shi ọ khi, eri mhia ga Ẹshinẹgba ọyi eni e bia awa, mhi khi ọni ọ rọte oni Odẹ ona, ni ẹẹ khi ẹgbhọli o khi. Ama mhi mie shi Ushi oyi iMosisi ali emini a kẹkẹ shi ebe eyi emekẹguele. ");
INSERT INTO atgNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mhi miesuọ abi ẹgbọ enana e li miesuọ, khi Ẹshinẹgba ọ ya rọte eghuli guise ọgbọ nya le, ghe eni e guẹ ngeli ghe ena ọkhọlọ. ");
INSERT INTO atgNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Irarighọ mhi rọ rọshẹka, emini mhia riẹlẹ nya, ini udu ni ọọ gue ọgbọ ẹzọ oyẹmhẹ o pfuasẹ shi odalo oyi Ẹshinẹgba ali ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“O she gba ikpe eni e bu abi mhi te lase ẹoli iJerusalẹmu le. Eri mhi jele aghọ ni mhi ya rue ikpaghọ ghi ẹgbọ ni ẹa mhuẹ ali ni mhi ri isomhopfa ghi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Emini mhii riẹlẹ na ni e rọ bhale ya ẹ mhẹ shi Owa oyi Ẹshinẹgba abi mhi la ipfuasẹ abi ushi o ngme. Ẹgbọ ekhọghuo ẹa le gasẹ mhẹ, wẹkhi eri a mẹ onyaghu. ");
INSERT INTO atgNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama ẹgbọ iJu eghuo ni ẹ rọte ekẹ Esha bhale e ga li la akaghọ. E kha bhale odalo oyẹ ẹ ya gue ẹzọ oyẹwẹ, ini e mhọli emini e ya gue shi mhẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Okekhi emọse ni e la akana ena, a mhila wẹ e guele umhaguẹli ni e gue shi mhẹ egbe abi a rọ rue mhẹ bhale odalo iSaẹdiri. ");
INSERT INTO atgNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ama emhi oghuo mhi la akpẹwẹ tsẹsẹ ngme khi, ‘Eri a gue mhẹ ẹzọ itobọ khi mhi mie shọ khi eni e ghu-a e ya gbo guale bhale agbọ.’ ” ");
INSERT INTO atgNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ighọ iFẹlisi ni ọ ga lolo lẹsẹ emhi oni Odẹ ona, ọọ, a yẹmhẹ oni ẹzọ-a ne. Ọọ, “Ini iLisiasi ọni ọ mhẹsẹ na ekhọli-okhuẹ ọ da bhale mhi rọ ya sọ ẹ oni ingme.” ");
INSERT INTO atgNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ọ gueyẹ ọga ekhọli-okhuẹ ọghọ ọ lolo ri ẹloe shi iPọlu egbe, ama e zẹ ọli pfi ẹfo-a ukukuọ. E zẹ ni emọle ọli e ke bhale ya tsẹ ọli ali ni e ke ri emini ọ nono bhale ghi ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Abi ikuku ogbẹlẹ e rọ dọsẹ se, iFẹlisi ọ tsua ughuẹ ọli ni a lu iDurusila ni ọ khi ọngi iJu ma egbe bhale. Ọ ghie ya lu iPọlu, ọ ri esọ shi ekẹ suọ abi iPọlu ọ li ngme ungmemhi irudunga ni o la iJesu iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama abi iPọlu ọ li ngme ungmemhi iguẹ-ngeli, ali ikuegbe-a ali isọ-ẹzọ oyi Ẹshinẹgba ni ọ bhale, ulishi oo mu iFẹlisi, ọọ, “Osomhi ghọ ne! Ke vu. Mhi ya ghie lu ẹ ini mhi ke mẹ asha.” ");
INSERT INTO atgNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Oni ẹghẹghẹ ọ dabi khi iPọlu ọ ya vi ufa na luẹ, itobọ ighọ ọ rọ kẹlẹ ẹ ghie lu ọli, ọ́ bhale ni wẹwẹ e ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Abi ikpe eva e rọ dọsẹ, iPọshusi iFẹsitọsi ọ ke khi igọvunọ ni iFẹlisi ọ kpẹ khi. Ama itobọ khi iFẹlisi ọ nono ni lọli guẹ riẹlẹ ti ẹgbọ iJu ẹloe, ọ zẹ iPọlu obọ shi owa ighumha. ");
INSERT INTO atgNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","A liẹ amo o li ẹlẹ esẹ abi iFẹsitọsi ọ te khi igọvunọ, ọ rọte ẹoli iSizeria nga ẹoli iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Oobọ ighie eyi ekpodalo-ugamhi ali enighie eyi ẹgbọ iJu e la gue ẹzọ shi iPọlu egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","E nyanya lema iFẹsitọsi ọ rue iPọlu je iJerusalẹmu ni ọ rọli kpaghiẹ ẹwẹ obọ. Irari khi e she gba khi ẹwẹ e ya kpẹ odẹ gbe iPọlu-a ini ẹẹ lẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","IFẹsitọsi ọọ wẹ, “A she ri iPọlu shi owa ighumha obini ẹoli iSizeria, mhẹmhẹ mhi ya nyenẹ egbe kẹlẹ je oobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","A zẹ ni eni ẹẹ ralo na ẹ e deba mhẹ je iSizeria ya gue ẹzọ shi ọni ọmọse egbe, ini o khia khi eri ọ lue.” ");
INSERT INTO atgNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ogbẹlẹ elele ya ramhi ogbẹlẹ igbe iFẹsitọsi ọ nu wẹ la aghọ, ni ọ rọ kia tiemhi ẹoli iSizeria. Ogbeakọlọ ọ khueghie ikọtu-a, ọọ a rue iPọlu bhale odalo oyẹluẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Abi iPọlu ọ rọ bhale, ẹgbọ iJu ni e rọte iJerusalẹmu bhale e migha gasẹ ọli, e gue ẹzọ ni o toto shi ọli egbe, ama ẹa dobẹ to eni ẹzọ migha. ");
INSERT INTO atgNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ama iPọlu ọ gue ẹzọ pfa egbọli shi ekẹ, ọọ, “Mhi aa riẹlẹ emhikhọghuo ni o da ushi oyi ẹgbọ iJu, wẹkhi Owa Oyi Ẹshinẹgba, wẹkhi eri mhi lue na iSiza iRomu.” ");
INSERT INTO atgNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ama iFẹsitọsi ọ nono ni lọli riẹlẹ ọghuẹmhẹ oyi ẹgbọ iJu, ighọ ọ mhila iPọlu, “O ghọle ẹ ni a rue ẹ je iJerusalẹmu, ni a la aghọ gue ẹzọ oyẹ ukpẹloe mhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","IPọlu ọọ, “Iiye. Ikọtu oyi iSiza ni a kha mema la gue ẹzọ oyẹmhẹ mhi la ena. Mhi aa mhọli onobe ni mhi li ẹgbọ iJu ni yẹyẹ u lẹsẹ gboo. ");
INSERT INTO atgNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ini o khia khi mhi lue nabi a gbe ọgbọ-a shi, mhi mu egbe ni mhi rọ ya ghua. Ama o kha da khia khi ẹzọ ni ẹgbọ iJu ena e gue ẹ shi mhẹ egbe khi ẹgbhọli lọ, ọgbọkhọghuo ọa dobẹ ya rue mhẹ na wẹ. Irarighọ, mhi lema a zẹ ni iSiza luẹghuo ọ rẹmhẹ gue oni ẹzọ ona.” ");
INSERT INTO atgNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","IFẹsitọsi ọ ri eni e nu ọli ẹ sọ ẹzọ ye ochi se, ọọ iPọlu, “U she lema a rue ẹzọ ona je ayi iSiza ya gue, ayi iSiza u mema ya je.” ");
INSERT INTO atgNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ogbẹlẹ ingmẹ-na e dọsẹ, oghie Agiripa ali iBẹnisi e bhale ekẹ iSizeria ni e ya tsẹ iFẹsitọsi. ");
INSERT INTO atgNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Aborọkhia khi e la akaghọ ogbẹlẹ ebubu, iFẹsitọsi ọ gue ingme oyi iPọlu yẹ oni oghie, ọọ, “Ọmọse ọghuo ọ la owa ighumha shi ana ni iFẹlisi ni ọ kpẹ khi igọvunọ ọ zẹ obọ shi aghọ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Abi mhi rọ ye iJerusalẹmu, ighie eyi ekpodalo-ugamhi ali egbhali eyi ẹgbọ iJu e tsua ẹzọ bhale ya gue shi ọli egbe, ẹẹ mhi pfa ẹzọ igbe-a mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Ama mhi gueyẹ wẹ khi awa ẹgbọ iRomu awa aa ya pfa ẹzọ mu ọgbọ ni a gue ẹzọ shi egbe, ini ọgbọ a ri ẹghẹghẹ nali gue shi ẹzọ ni a gue shi ọli egbe ne. ");
INSERT INTO atgNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Abi e rọ deba mhẹ bhale ana, mhi nyanya shi oni ẹzọ shi ogbeakọlọ, mhi shitọ elemhi ikọtu, mhiẹ a lu ọni ọmọse bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Abi eni ẹẹ gue ẹzọ shi ọli egbe e rọ vule ngme, ẹa gue ẹzọ umhaguẹli ni mhi dabi khi e ya gue. ");
INSERT INTO atgNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ochoghọ ẹzọ ekhakọ tsẹ e lẹsẹ mẹ gue shi ọli egbe, ni o khi ingme oyi ugamhi oyẹwẹ, ali ekhakọ ni o khi ingme oyi ọmọse ni a lu iJesu, ni ọ ghua, ni iPọlu ọ khi ọ kie la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mhi aa lẹsẹ abi mhi li ya tọnọ udi oni ingme onana. Mhi ri irarighọ mhila li ini ọ nono ni a rue oli je iJerusalẹmu ya gue eni ẹzọ ni a gue ẹ shi ọli egbe enana, oobọ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama iPọlu ọ lema a kie mu luẹ shi igha ne, ni a ri oni ingme ghi iSiza ni ọ sọ ọ. Irarighọ mhi rọ liẹ a rọ ọli shi owa ighumha ramhi ni mhi rọ ya rue ọli ghi iSiza.” ");
INSERT INTO atgNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ighọ Agiripa ọ gueyẹ iFẹsitọsi, ọọ li, “Mhi kha nono ni mhẹmhẹ-ghuo ni mhi li ri esọ suọ ungmemhi oyi ọni ọmọse.” IFẹsitọsi ọọ li, “U ya suọ ọli akọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ogbeakọlọ, a ri ebọla kphase Agiripa ali iBẹnisi lo elemhi ikọtu le. Ega ekhọli-okhuẹ ni e lolo fu, ali ẹgbọ eniẹmhi ni e la oni ẹoli e deba li lo. IFẹsitọsi ọ ghie ya rue iPọlu bhale. ");
INSERT INTO atgNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","IFẹsitọsi ọọ, “oghie Agiripa ali ẹgbọ ni e la ana nya, a bino ọmọse ọna. Ẹgbọ iJu ni e la ana ali iJerusalẹmu ali iSizeria e she bhale deba mhẹ, ẹẹ tsẹsẹ a khi ke zẹ ni ọ la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mhi mẹ khi ọa li emhikhọghuo onabi a ya gbe ọli-a shi, ama abi ọ rọ da lema a rue luẹ ghi Oghie iRomu nya eghọ, mhi ya rue ọli je iRomu. ");
INSERT INTO atgNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama mhi aa mẹ ingme nabi mhi kha kẹkẹ shi ọli egbe ghi Oghie iRomu nya. Irarighọ, mhi rọ rue ọli bhale ghi ẹ ẹẹ nya, yẹyẹ oghie Agiripa kpaashi, ni a bhale ya ẹ khi ini a bino oni ingme se, otsẹ mhi ya mẹ emini mhi ya kẹkẹ shi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Irari khi mhia sa khi o gbe akanya ni a rọ rue ọni a mu shi igha ke ghi Oghie iRomu nya, ini aa mẹ ushi okhọghuo kẹkẹ shi ọli egbe gboo.” ");
INSERT INTO atgNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ighọ Agiripa ọọ iPọlu, “A she lama nẹ u ngme na egbe ẹ.” Ighọ iPọlu ọ tsua obọ ekẹ, ọ bẹlẹ ẹ gue ẹzọ, ọọ, ");
INSERT INTO atgNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Agiripa ni oghie, mhi mẹ egbe mhẹ shi ọni ọ mẹ afa ni mhi rọ migha odalo oyẹ amo, ni mhi rọ ọ gue ẹzọ pfa egbe mhẹ shi ekẹ shi ingme nya ni ẹgbọ iJu e gue shi mhẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Oo guẹ ti gba irari khi u ga lẹsẹ imu eyi ẹgbọ iJu nya ali emini e mie shi. Irarighọ, mhi lolo lemẹ u mhọli irabọmudu na mhẹ ni mhi ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ẹgbọ iJu nya e lẹsẹ abi mhi laọ shi abi mhi te khi ọmọ, rọte igbaekẹle agbọ oyẹmhẹ obini ushishi ẹgbọ iJu eyẹmhẹ ali ẹoli iJerusalẹmu. ");
INSERT INTO atgNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Odẹ o she nuẹ ni e te lẹsẹ mhẹ, e ya dobẹ pfi ọtsẹlẹ shi ọ ini o ghọle wẹ, khi abi ugamhi oyawa o ngme khi eri mhi mhọli ọmuegbe egbegbọ shi ọ abi ọna otu iFarisi ni mhi khi. ");
INSERT INTO atgNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ama mena, itobọ khi mhi mhọli iregbeda shi emini Ẹshinẹgba ọ shi na itita awa mhi rọ migha shi imufẹ amo. ");
INSERT INTO atgNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ona o khi ishobọ ni unuẹkpẹ igbẹva eyawa e migha a khẹ, abi e li rọshẹka a ga Ẹshinẹgba ghe ẹlẹọguota ali ẹlẹ iyọsẹ. Oghie, irari oni iregbeda onana ẹgbọ iJu e gue ẹzọ shi mhẹ egbe ẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Elọ e zẹ ni a rọ lama shiọ khi Ẹshinẹgba ọ dobẹ ẹ guise ọni ọ ghu-a le? ");
INSERT INTO atgNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mhẹmhẹ mhi kpẹ mhọli ọli shi udu khi eri o ye ni mhi mu okhọli vule shi oni eva oyi iJesu ọngi iNazarẹti ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ighọ mhi li i riẹlẹ ọli obini ẹoli iJerusalẹmu. Irari afu ni ọga ọyi ekpodalo ugamhi eyi Ẹshinẹgba ọ rọ na mhẹ, mhi muno ebubu eni e miesuọ shi owa ighumha, abi a rọ ọ gbolo wẹ-a, mhii mie obọ shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ebubu ẹghẹghẹ mhi te owa ugamhi je owa ugamhi ya nasẹ wẹ, mhi gbolo ri ajilimhẹ rẹwẹ ngme ungmemhi ipfiunu-a deba Ẹshinẹgba. Irari elemhi wẹ ni e bi mhẹ. Mhi gbolo je ẹoli oboese ya mu okhọli vule shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ẹlẹghuo mhi i lẹ ẹoli iDamasikọsi, rọte afu ali omhẹsẹ ni ọga ọyi ekpodalo ugamhi eyi Ẹshinẹgba ọ rọ na mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Itsotso ọguota o mu ekẹ, oghie, abi mhi la odẹ, mhi mẹ khi ákpá ni o gẹ dọsẹ ovọ o rọte idane mi gasẹ mhẹ ali eni anye ga kia. ");
INSERT INTO atgNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Anye nya, anye de ekẹ, ighọ mhi suọ khi uruli o nu mhẹ ngme ẹlẹmhi Iburu, ọọ, ‘ISọlu, iSọlu, elọ o zẹ ni u rọ mu okhọli vule ẹ shi mhẹ ọ, ọọyẹghẹ wa li ini u nu mhẹ ẹ khọli.’ ");
INSERT INTO atgNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ighọ mhi mhila, ‘Ọghuo u khi Ọnọmhuẹ?’ “Ọọ mhẹ, ‘Mhẹmhẹ iJesu lọ ni u mu okhọli vule shi ọ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","‘Memena, vule migha. Mhi she ri egbe mhẹ khasẹ irari khi mhi she zẹ shi ọni ọọ ga mhẹ ali ni u ke pfi ọtsẹlẹ ọyẹmhẹ shi emini u ri ukpẹloe oyẹ mhẹ, ali emini mhi ya rọkhasẹ okhẹse. ");
INSERT INTO atgNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mhi ya tsumhi ẹ obọ oyi ẹgbọ eyẹ ali obọ oyi ẹgbọ iJẹta. Mhi ghie ẹ ghi wẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ni u khueghie wẹ alo-a, ni u mu wẹ pfi lase alo ebili le bhale ákpá, ali u rue wẹ ekpabọ eyi ọkphaghiẹ lasele bhale deba Ẹshinẹgba, ni a gbe olamhẹ kua na wẹ, ali ni e kugbe ẹgbọ eyi Ẹshinẹgba eni e pfuasẹ ọ, itobọ irudunga ni e mhọli na mhẹ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Irarighọ, oghie Agiripa, mhia rọ ri ukpẹloe gbe ekẹ ni mhi rọte iloghie mẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mhi kpẹ te ododẹ gue ọli yẹ ẹgbọ iDamasikọsi, mhi ke gbo gue ọli yẹ ẹgbọ iJerusalẹmu ali ẹgbọ ni e la ekẹ iJudia nya ali ẹgbọ iJẹta. Mhi rọli tse abọ, e lase olamhẹ le ni e mupfi deba Ẹshinẹgba, e rọkhasẹ khi wẹwẹ e she mu nyenẹ rọte ikanya ebe eyẹwẹ lasele. ");
INSERT INTO atgNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ona o zẹ ni ẹgbọ iJu e rọ bamhẹ rue Owa Oyi Ẹshinẹgba ni e rọ rọshẹka ini wẹwẹ e gbe mhẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama mhi she mhọli ikpaghiobọ oyi Ẹshinẹgba ramhi ogbe na amo, ali mena mhi migha akana a pfi ọtsẹlẹ ye ọgbọ ọnọfunẹ ali ọnikeke abeghuo. Mhi aa ngme dọsẹ emini emekẹguele ali iMosisi ẹ khi a ya mẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","khi ọni Ọmiepfuese ni a shobọ khi ọọ bhale ọ ya mẹ osue, ali khi lọli ni ọ kpẹ te ododẹ rọte eghuli guale khi ọ ya ri ákpá ru na ẹgbọ eyọli ali ẹgbọ iJẹta.” ");
INSERT INTO atgNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Abi iPọlu ọ rọ ngme ramhi ana, iFẹsitọsi ọ mu ọli migha, ọọ li, “Eri waa ke lẹsẹ emini u wa li? Ebe ni u zẹ dọsẹ e she ri ujili ẹ kphẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","IPọlu ọọ li, “Ujili ọa kpha mhẹ, iFẹsitọsi ọgbẹgbẹdu, emini mhia ngme egbegbingme lọ ni o tsua ẹgbhali. ");
INSERT INTO atgNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Oghie Agiripa ọ ga lẹsẹ eni ingme enana nya, emhikhọghuo ena, ẹa lase ọli ẹgbhali-a irari khi aa riẹlẹ wẹ osheli. Ona o zẹ khi mhi ga dobẹ nu ọli a ngme oni ingme ona gboo. ");
INSERT INTO atgNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Oghie Agiripa, u fẹ mieshi emini emekẹguele e ngme? Mhi lẹsẹ khi u mie shọ ọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ighọ Agiripa ọọ iPọlu, “Eri u dabi khi u dobẹ ya ri oni ukuku ẹghẹghẹ ona ti mhẹ ni u rẹmhẹ mele ọni ọ miesuọ-a?” ");
INSERT INTO atgNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","IPọlu ọọ li, “O kẹlẹ, o tẹsẹ oo, mhi lema Ẹshinẹgba o khi khi yẹyẹ-ghuo tsẹ, ama li shi ọgbọkpa ni ọ ri esọ shi mhẹ ekẹ ogbenamo, ni e li abi mhi li, ini a da ri obọ rue iwẹghẹ ni e lamhẹ abọ ena ọ le.” ");
INSERT INTO atgNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ighọ ọni oghie ọ vule, li shi ọni igọvunọ ali iBẹnisi ali eni e nu wẹ shitọ. ");
INSERT INTO atgNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","E rọte oni agbala vu, ee ngme, ẹẹ, “Ọmọse ona ọa li ingme ni a ya gbe ọli-a shi wẹkhi oni a rọ ọ mu ọli shi owa ighumha.” ");
INSERT INTO atgNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiripa ọọ iFẹsitọsi, “Áá kha wolọ ọmọse ọna abọ-a ini ọa she lema a ri oni ingme je ayi iSiza lọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Abi e rọ lama shi ọ, anye lo ọkọ-okẹ oniẹmhi je Itili, e rue iPọlu ali ighumha ni e kpọle mhọli obọ oyi ọga ekhọli-okhuẹ ni a lu iJuliọsi, ni ọ khi ọghuo ọyi ekhọli-okhuẹ eyi Oghie iRomu nya, ni a zẹ ọda kẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Anye lo ọkọ-okẹ oniẹmhi rọte Adiramitiọmu, ikhi ọkọ-okẹ ni o ya kia migha ikpe eghuo ni ọkọ-okẹ ẹẹ migha, ni e la epfepfẹ okẹ ni e la ekẹ Esha. Arisitakusi ni ọ khi ọngi iMasidonia ọ nu anye kia. ");
INSERT INTO atgNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ogbeakọlọ anye migha iSidọni. IJuliọsi ọ mhọli isomhelemhi na iPọlu, ọ zẹ ọli obọ ya mẹ emọle ọli, ni e ri emini ọọ nono na li. ");
INSERT INTO atgNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Anye ke gbo rọte aghọ mu oni ọkọ nga, anye rọte odane ukiẹkiẹ ekẹ ni okẹ oniẹmhi o khi shi ni a lu iSapurọsi irari khi akpekpeli oo nasẹ anye. ");
INSERT INTO atgNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Abi anye rọ gua ọkọ ọ da je ọdada iSilisha ali iPafilia, anye migha ẹoli iMara na ekẹ iLisia. ");
INSERT INTO atgNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Aghọ ọni ọga ekhọli-okhuẹ ọ te mẹ ọkọ-okẹ oniẹmhi oyi ẹoli Alẹzadira ni oo je Itili, ọ ri anye lo ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Anye e kia fiẹ, ogbẹlẹ ebubu, anye mhọli ọmunu neni anye ramhi iKinidusi. Abi akpekpeli ọa rọ zẹ anye rọte ashini anye kha rọte, anye gua ọkọ-okẹ je ukiẹkiẹ ekẹ ni okẹ oniẹmhi o khi shi iKirẹti ni o sọ alo ghue ẹoli iSalimọ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Anye mhọli ọmunu rọte oni okẹ oniẹmhi. Ikpukhokho, anye bhale ashini ọkọ-okẹ ẹẹ migha ni a lui ọpfọmhẹgbe ni o ti mama ẹoli iLasia. ");
INSERT INTO atgNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ẹghẹghẹ o she pfu anye-a. Oni okiali o de shi ẹghẹghẹ ni a rọ lẹsẹ pfi azumhi se, ni o khi ẹghẹghẹ ni okhẹna o la la okiali na ukhomhi okẹ oniẹmhi. Ighọ iPọlu ọ tse agua ye wẹ, ọọ wẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Emọse, mhi she mẹ khi okiali oyawa o ya khi okhẹna ali khi o ya ri ukpokpomhi opfu ghi oni ọkọ ali itsua ni o tsua ali agbọ oyawa.” ");
INSERT INTO atgNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama, ocho ni ọni ọga ekhọli-okhuẹ ọ kha rọ ri esọ shi emini iPọlu ọ ngme, ọ deba abi ọni ọ gua oni ọkọ ọ ngme ali emini ọni ọ mhọli oni ọkọ ọ ngme. ");
INSERT INTO atgNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Aborọkhia khi ashini anye migha ọa ya ti egbe ẹghẹghẹ oruẹ; ebubu ẹgbọ e yemhẹ anye gua ke lẹ, e dabi khi anye ya ramhi ẹoli iFonisi, ni anye la aghọ ẹghẹghẹ oruẹ. Aghọ ọkọ okẹ eniẹmhi nya ẹẹ migha yẹmhẹ-a. Ekẹ ni okẹ oniẹmhi o khishi ni a lu iKirẹti ni ọ sọ alo ghue obini ovọ o te ẹ lo eko o khi. ");
INSERT INTO atgNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Abi akpekpeli okẹ o rọ ri ọfiẹ rọte ukiẹkiẹ ọgobọ ọ pfiolo, eni emọse e dabi khi okiali o ya zẹ wẹ kia ke je odalo, ighọ e leli uli ali akhuli ni a rọ gba ọkọ ọọ zu. Ee kia esesọ oni okẹ oniẹmhi na iKirẹti. ");
INSERT INTO atgNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ama o li dẹnẹ, akpekpeli oniẹmhi, o li rọte ukiẹkiẹ obita ini a sọ alo ghue obini ovọ o te ẹ tiemhi eko pfiolo rọte oni ekẹ ni o la iteva okẹ oniẹmhi i dọsẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Oni akpekpeli o tsua rughu ọkọ-okẹ oyanye, ọa dobẹ ke kia je obini akpekpeli o te pfiolo o bhale. O lọsẹ anye. Anye bie zẹ ọli obọ na akpekpeli lọlighuo oo tsua. ");
INSERT INTO atgNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Anye kia rọte ukiẹkiẹ ukuku ekẹ ni o la iteva okẹ oniẹmhi ni a lu iKauda, ikhi ukiẹkiẹ obini oni akpekpeli ọa ri egbe ramhi. Irọshẹka anye rọ dobẹ tialọ ọkọ onikeke ni a rọ ọ tsumhi ẹgbọ lo elemhi oni ọkọ-okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Abi eni emọse e rọ tialọ li lo se, e ri ili gẹ oni ọkọ-okẹ oniẹmhi gasẹ, ini eni ili e dobẹ mu ọli mhuẹ toto. Irari khi ee na ulishi ini oni ọkọ o ya gbe aye shi ugbe ekẹ, ni o la egele ekẹ iLibiya, ni o sọ alo ghue wẹ. Ighọ e gbaghiẹ ode na kpishi oyi oni ọkọ-a, irari khi ẹa bie ke mhuẹ abi e ya li ọ. Isheghọ ni oni akpekpeli o bie tsua wẹ ke le. ");
INSERT INTO atgNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Oni akpekpeli o kie ri itoto tsua oni ọkọ-okẹ ramhi ogbeakọlọ, ramhi ni, eni emọse e rọ tino itsua ni e tsua shi oni ọkọ ọ pfino kulo oni okẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ogbeakọlọ e pfino ikhuli ni oni ọkọ o rọ ọ gbe akanya kulo oni okẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Aborọkhia khi ogbẹlẹ ebubu ni e dọsẹ khi anye a ri ẹloe ti ovọ wẹkhi ukpẹtata, ni oni akpekpeli o kiele rọ ri itoto o pfiolo, anye a ke ri udu shi ọ khi anye mẹ odẹ ni anye te ya pfue ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Abi eni emọse ẹa rọ le eminale ogbẹlẹ ebubu, iPọlu ọ vule, ọ wẹ, “Emọse a kha suọ ude ni mhi ye ẹ lọ, a kha migha iKirẹti, Ẹghẹghẹ aghọ, a kha tsumhi egbe ẹ oyese onana ali opfu. ");
INSERT INTO atgNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama mena mhi gueyẹ ẹ a mhọli udu, itobọ khi ọngẹẹ ọkhọghuo ọa ya pfua sẹ ni oni ọkọ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ooyọsẹ agẹni ọyi Ẹshinẹgba ni ọ mhọli mhẹ ali ni mhi a ga ọ migha mama mhẹ, ");
INSERT INTO atgNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ọọ mhẹ, ‘Khi zẹ ni ulishi o muẹ, iPọlu. U mema ya migha ẹzọ odalo oyi iSiza ali khi Ẹshinẹgba ọ she rọte ilẹlemhi ri agbọ oyi eni a ga kia mhọli ẹ obọ.’ ");
INSERT INTO atgNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Irarighọ, a mu igbedu oyẹ mhọli, emọse, irari khi mhi mhuẹ irudunga khi Ẹshinẹgba ọ ya riẹlẹ ọli abi ọ gueyẹ mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ama ọkọ oyawa o mema ya gbe aye shi ugbe ekẹ okhọghuo ni o la iteva okẹ oniẹmhi, o tigbe migha.” ");
INSERT INTO atgNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ẹliyọsẹ ẹlẹnuzi-igbẹne, akpekpeli o kie tsua anye e kiakia okẹ oniẹmhi Adiriatiki. Itsotso ogbiẹ, o li eni ẹẹ gbe akanya oni ọkọ ẹloe abinẹ khi e she ti ẹ mama ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","E mhẹsẹ oni okẹ bino, e mẹ khi ilimhi oyọli o khi ẹtẹ-awẹ egbhuẹsesa. O gbo li dẹnẹ, e gbo mhẹsẹ ọli, o ke khi ẹtẹ-awẹ egbhuẹne ali igbe. ");
INSERT INTO atgNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ulishi o mu wẹ khi oni ọkọ o ya gbe aye shi echẹ, e rọte ukhokho pfi ikhuli ene ni a rọ a mu ọkọ ọ gbashi lo oni okẹ oniẹmhi, ee sọ iromhi ogbe o gbe a. ");
INSERT INTO atgNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Eni e la oni ọkọ ọ gbe akanya e dua abi e li mẹ asha a na kua. Ee tiese ukuku ọkọ ni e tialọ lole eghọ nga okẹ oniẹmhi, abinẹ khi eri e nono ni e rọte odalo ya pfi ikhuli lo okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ama iPọlu ọọ ọni ọga ekhọli-okhuẹ ali eni ekhọli-okhuẹ, “Ini emọse enana ẹa li la elemhi oni ọkọ, ọngẹẹ, ọa ya pfue ọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ighọ eni ekhọli-okhuẹ e pfa uli ni o mu oni ọkọ onikeke mhuẹ-a. E zẹ ọli de tiemhi elemhi okẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Neni ogbe o maghiẹ-a, iPọlu ọ lema wẹ nya e le eminale. Ọọ wẹ, “O she ramhi ogbẹlẹ igbẹne ni udu ọa ke te sheshe ẹ, ni a le eminale kpẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mena mhia lema ẹ, a le eminale. A lemhi ini a nono ni a kie dobẹ la agbọ, A lemhi khi emhikhọghuo ọa ya li ọngẹẹ.” ");
INSERT INTO atgNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Abi ọ rọ ngme na se, ọ rue ibulẹdi lasele, o kphẹmhi na Ẹshinẹgba ukpẹloe wẹ nya, ọ khi ọli-a, ọọ le. ");
INSERT INTO atgNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wẹwẹ nya e mhọli udu, e le eminale. ");
INSERT INTO atgNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Anye nya ni anye la oni ọkọ, ẹgbọ egbhuẹgbẹsẹ ali ogbasasa 276 anye khi. ");
INSERT INTO atgNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Abi e rọ ga le eminale se abi e nono, e tino ikpulu ikpamhi emhi ni e tsua kulo okẹ oniẹmhi, ini oni ọkọ o kpẹ li fuẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Abi ogbe o rọ gbe-a se, eni ẹẹ gua oni ọkọ ẹa ke lẹsẹ egele okẹ oniẹmhi bie, ama e mẹ ashini ekhashẹ e kpi gbili shi. Aghọ e ke bie rọli shi udu khi wẹwẹ e ya gua oni ọkọ ya migha ini o zẹ wẹ ẹ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ighọ e pfanọ eni ili ni e mu ukpokpomhi akhuli ni o mu ọkọ-okẹ oniẹmhi ẹ gbashi kulo udi okẹ oniẹmhi. Ẹghẹghẹ aghọ e taghiẹ uli ni a rọ mu emini a rọ mu oni ọkọ ukhomhi ẹ nyenẹ-a. E taghiẹ ugbakpi oyi oni ọkọ-a nga idane, ni e dobẹ ramhi ashini e nono. ");
INSERT INTO atgNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama oni ọkọ-okẹ o ya tọ aye sọ ugbe ekẹ ni o la elemhi okẹ oniẹmhi, o migha, akpekpeli o kie ri itoto o li, o tsẹkẹ udi oni ọkọ-a. ");
INSERT INTO atgNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Eni ekhọli-okhuẹ ee gba abi e li ya gbolo eni ighumha nya a, ini e ya gua okẹ ramhi egele ni e na vu. ");
INSERT INTO atgNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama ọni ọga ekhọli-okhuẹ, ọọ nono abi lọli li ya tsumhi iPọlu, ọa zẹ wẹ riẹlẹ emini e gba. Ochoghọ ọ gueyẹ eni e guẹ ẹ gua okẹ e kpẹ danọ kulo okẹ ni e ramhi egele. ");
INSERT INTO atgNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Eni e kpọle nya e mu ikiẹkiẹ ẹẹra mhuẹ okekhi izaga oyi oni ọkọ-okẹ. Ighọ wẹwẹ nya e ramhi ekẹkhẹ emhikhọghuo ọa li wẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Abi anye rọ ri ẹpfua-ẹpfua ramhi egele se, anye bhale ya ẹ khi iMọta a lu oni ekẹ ni o la iteva okẹ oniẹmhi. ");
INSERT INTO atgNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ẹgbọ ni e ngeli oni ekẹ e somhelemhi anye odẹ ni anye aa sa shi. E pfi avuerẹ rọ mu anye epfẹse irari khi eri amẹ oo ruẹ, ogbe o pfọ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","IPọlu ọ ya nu iguagha ẹẹra, ọ rẹwẹ kpẹ eni erali, ighọ ẹnyẹ afue ọ te eni iguagha lasele ya tsakọ shi iPọlu obọ, itobọ khi erali e she basẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Abi ẹgbọ ni e la oni ekẹ ee mẹ khi ọni ẹnyẹ ọ ngomhi iPọlu obọ, e gueyẹ egbe, ẹẹ, “Ọmọse ọna, ọgbọ ugbeli ni ọ gbolo ẹgbọ-a ọ fẹ khi memena. Aa mẹ khi abi ọ ririẹ na pfue eghuli okẹ oniẹmhi, odeba oyi iguẹzọ ọa kie zẹ ọli obọ ni ọ la agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama iPọlu ọ kpishi ọni ẹnyẹ pfilo elemhi erali. Ingomhi ni ọni ẹnyẹ ọ ngomhi ọli, ọa li ọli abikhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","E migha ri ẹloe shi ekẹ ẹ khẹ abi ọ li ya fumhi, okekhi abi ọ li ya fiagbe ekẹ ghua. Ama abi e rọ khẹ ọli ramhi ni ẹa rọ mẹ khi emhikhọghuo e li ọli, e mu udu pfi, ẹẹ khi olitsa ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Epfẹ-aghọ iPọbiliọsi ni ọ khi ọgbọ igọmẹti oyi oni ekẹ ni okẹ oniẹmhi o khi shi, ọ mhọli apfẹ shi. Ọ rue anye je apfẹ oyọli, ọ fẹli anye epfẹse egbegbọ ogbẹlẹ esẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ita iPọbiliọsi ọ yẹshi i ghua, iba ali ukpokpomhi elemhi ofu e to ọli. IPọlu ọ lo elemhi owa ya sọ iromhi na li, ọ ri abọ nga li egbe, ọ rọli zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Abi a rọ mẹ ghọ se, ẹgbọ elese ni e ghua ni e la oni ekẹ ni okẹ oniẹmhi o khishi e bhale, a rẹwẹ zẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Eni ẹgbọ e lolo mu ekpẹ na anye, e somhi anye opfa. Abi anye rọ ya lo ọkọ-okẹ oniẹmhi ke vu, e wọlọ itsua ọdọda ni e to anye na anye. ");
INSERT INTO atgNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Abi o rọ gbe iki esẹ dọsẹ, anye lo ọkọ-okẹ oniẹmhi ni o migha aghọ khẹ ni oruẹ o dọsẹ. Ẹoli Alẹzadira oni ọkọ o te e bhale, isheli itsema iKasito ali iPolukisi a lu oni ọkọ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Anye ramhi ẹoli iSirakusi, anye la aghọ ẹlẹ esẹ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Anye rọte aghọ kia okẹ-oniẹmhi ramhi ẹoli iRẹgiumu. Ogbeakọlọ, akpekpeli o rọte ukiẹkiẹ ọgobọ ini a sọ alo ghue obini ovọ o te ẹ lo eko e pfiolo. Ogbẹlẹ onuzi-eva, anye lo ẹoli iPuteoli. ");
INSERT INTO atgNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Anye ya ẹ eni e miesuọ ni ẹẹ anye nu wẹwẹ la aghọ elemhi ẹfo uka oghuo. Anye rọte aghọ vu, anye ramhi iRomu. ");
INSERT INTO atgNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Igbaa oyi eni e mie iJesu iKirisiti suọ ni e la iRomu e she suọ khi anye ẹ bhale. Ighọ eni e miesuọ eghuo e bhale ya lu anye odẹ, e kia ramhi Oki Apiọsi ali Owa Esẹ ni a ku ẹ shi. Abi iPọlu ọ rọ mẹ wẹ, ọ tsẹ Ẹshinẹgba uwegbe, o ri udu shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Abi anye rọ ramhi iRomu, a zẹ ni iPọlu lọlighuo ọ la owa ni o ghọle ọ, a zẹ ọkhọli-okhuẹ ọghuo ọ ri ukpẹloe ke khu ọli. ");
INSERT INTO atgNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Abi o rọ gba ẹlẹ esẹ dọsẹ, iPọlu ọ lu eni e ralo na ẹgbọ iJu shi ilona. Abi e rọ bhale shi oni ilona, ọọ wẹ, “Inyọghuo-mhẹ, mhi aa li ẹgbọ eyawa emhikhọghuo wẹkhi eri mhi gbe ushi ni eni e bia awa, e rọ nga awa obọ-a, ni e rọ la iJerusalẹmu mu mhẹ, rue mhẹ na igọmẹti iRomu. ");
INSERT INTO atgNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Abi e rọ gue mhẹ ẹzọ egbe-a se, e nono abi wẹwẹ e liẹ rue mhẹ obọ-a, itobọ khi mhia lue, ni a ya gbe mhẹ-a shi. ");
INSERT INTO atgNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama abi ẹgbọ iJu ẹa rọ lama shi ọ, lọli mhi rọ lema a tsua oni ẹzọ bhale odalo oyi iSiza. Ọa khi eri mhi mhuẹ emini mhi bhale ya gue shi ẹgbọ eyẹmhẹ egbe. ");
INSERT INTO atgNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Onana o zẹ khi mhiẹ a bhale ni awa ngme. Itobọ irudushi ni ẹgbọ iZirẹni e mhọli a rọ ri iwẹghẹ shi mhẹ awẹ ena.” ");
INSERT INTO atgNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ẹ ọli, “Anye a mẹ ebe okhọghuo ni a kẹkẹ ingme oyẹ shi, rọte ekẹ iJudia bhale, ghi anye, wẹkhi inyọghuo awa ni e rọte oobọ bhale e gue ingme oyẹ okhọghuo ni ọa ti ye anye. ");
INSERT INTO atgNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama anye ẹ nono ni anye suọ unu oyẹ, itobọ khi ashakpa ẹgbọ e la ngme onobe shi oni otu onogbọ ona.” ");
INSERT INTO atgNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ighọ e shi ogbẹlẹ na iPọlu. Ebubu ẹgbọ e bhale asha ni iPọlu ọ la oni ogbẹlẹ. Rọte ẹlẹ uzogbe ya ramhi ẹliyọsẹ iPọlu ọ te gue ungmemhi oyi Eghiele oyi Ẹshinẹgba yẹ wẹ. Ọ rọte ebe Ushi oyi iMosisi ali eyi Emekẹguele rọli lo wẹ esọ ini e lama mie iJesu suọ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ingmemhi ni ọ ngme e lo ẹgbọ eghuo esọ, ama ẹgbọ eghuo ẹa mie shi ọli ọ. ");
INSERT INTO atgNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ighọ e li nu egbe e khakọ, e vu, abi iPọlu ọ rọ ngme ungmemhi ona ni o kpọli ukhokho unu se ni ọọ, “Ayẹmhẹ-nọ-pfuasẹ ọ she kpẹ rọte unu oyi Azaya ọmekẹguele gueyẹ eni e bia awa: ");
INSERT INTO atgNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“ ‘Lẹ deba ẹgbọ ena ni u gueyẹ wẹ, “A ya ri esọ shi ekẹ khue, ama ọa ya tigbe lo ẹ esọ, a fẹli ofẹli khue, ama aa mẹ emhikhọghuo.” ");
INSERT INTO atgNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Udu oyẹwẹ o bi obili-a, esọ eyẹwẹ e zuse, e gbo guese alo. Ini ọa khi ighọ lọ, e kha ri alo eyẹwẹ ke mẹ ekẹ, e ri esọ eyẹwẹ ẹ suọ, udu oyẹwẹ o kha mhọli ilẹsingme, e kha mu pfi bhale deba mhẹ, mhi rẹwẹ ze.’ ");
INSERT INTO atgNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Irarighọ, mhia nono ni a lẹsẹ khi imiepfuese oyi Ẹshinẹgba khi a she rọli ghi ẹgbọ iJẹta. E ya ri esọ shi ọ!” ");
INSERT INTO atgNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Abi ọ rọ ngme oni ungmemhi ona se, eni ẹgbọ iJu e vu, e nu egbewẹ khakọ ni o toto. ");
INSERT INTO atgNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ikpe eva gbada iPọlu ọ la owa ni lọlighuo ọ ngmomhi shi. Aghọ ọ la a mu ẹgbọ ni e bhale ya fẹli ọli epfẹse. ");
INSERT INTO atgNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Igbe-udu ni ọ mhuẹ ya, ọ rọ ọ gue ungmemhi Eghiele oyi Ẹshinẹgba le, ọ gbolo sẹsẹ ẹgbọ ingme eyi iJesu iKirisiti Ọnọmhuẹ, emhikhọghuo ọa zu ọli odẹ.");
INSERT INTO atgNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mhẹmhẹ iPọlu, ọni ọọ ga ọyi iJesu iKirisiti ni a lu mhi khi aghiusomhi na kẹẹ, ni a zẹ ọ le mhi ke tsabọ usomhi onete oyi Ẹshinẹgba. Mhẹmhẹ mhi kẹkẹ ebe ona. ");
INSERT INTO atgNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Oni usomhi onete ona khi, oni Ẹshinẹgba ọ shobọ shi ekẹ, rọte unu oyi emekẹguele eyọli ni a kẹkẹ shi Ebe-no-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Oni usomhi onete o ya khi, ingme oyi omi ọli ni ọ rọte unuẹkpẹ oyi iDefidi lasele elemhi idiegbe. ");
INSERT INTO atgNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","A rọte ekpabọ oyi Ayẹmhẹ-nọ-pfuasẹ rọli khasẹ, ikhi iJesu iKirisiti Ọnọmhuẹ ọyawa, khi, Omi Ẹshinẹgba ọ khi, abi ọ rọ rọte eghuli guise ọli le. ");
INSERT INTO atgNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Rọte obọ oyi iKirisiti ali eva oyọli anye te mie afu rọ khi ighiusomhi na kẹẹ eyọli, ni anye rọ ri ẹgbọ iJẹta nya bhale ya suesọ na Ẹshinẹgba. Isuesọ ni o rọte irudunga bhale. ");
INSERT INTO atgNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ẹẹ ẹgbọ iRomu a li la eni Ẹshinẹgba ọ lu, ni a li khi enayi iJesu iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ẹẹ ni a la iRomu nya a kẹkẹ ebe ona ghi. Ẹẹ ni Ẹshinẹgba ọ nono ingme oyẹwẹ ni ọ zẹ, ni a khi ẹgbọ eyọli. Okhale ali opfọmhẹ e ka khi eyẹ ẹ, rọte obọ oyi Ẹshinẹgba ita awa ali rọte obọ oyi iJesu iKirisiti Ọnọmhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Onododẹ, mhi ri eva oyi iJesu iKirisiti tsẹ Ẹshinẹgba ọyẹmhẹ uwegbe shi agbọ oyẹ ẹ nya, irari khi a she la ashakpa elemhi ekẹ agbọ suọ eko irudunga ni a mhọli. ");
INSERT INTO atgNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ẹshinẹgba ni mhi ri udu oyẹmhẹ nya a ga, ni mhi a tse abọ usomhi onete oyi omi ọli, ọ khi ọtsẹlẹ ọyẹmhẹ, khi igẹsikia mhia ngme, khi ẹghẹghẹ kpa mhi rọ ọ sa to ẹ egbe ini mhia sọ iromhi. ");
INSERT INTO atgNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mhia lema Ẹshinẹgba ọ khueghie odẹ-a na mhẹ ni mhi mẹ asha bhale ya mẹ ẹ ikpukhokho abi o ghọle ọli shi. ");
INSERT INTO atgNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","O ma ghọle mhẹ gba ni mhi rọ mẹ ẹ, ni mhi ri osẹsẹ eyi ayẹmhẹ na ẹ, ni ó rẹ ẹ ya toto irudunga. ");
INSERT INTO atgNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Emini mhi ri ọna ngme khi ni a rọ bhale ya ẹ khi awa mhuẹ ikpaghiobọ na egbe. Mhi kha zese ẹ-a, ẹẹ a zese mhẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Emọle mhẹ, mhia nono ni a lẹsẹ khi, ebubu ẹghẹghẹ mhi she gba li khi mhi bhale ya fẹli ẹ, ni mhi gbo ri ẹgbọ bhale irudunga abi mhi kpe liẹ riẹlẹ ọli ifuabọ ẹgbọẹse ni e khi iJẹta, ama, ọzuodẹ o zu mhẹ odẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ẹgboli oyẹmhẹ o khi ni mhi rọ tse abọ ona ye ẹgbọ kpa, ghe ẹgbọ iGiriki ali eni ẹa khi iGiriki, ene fialo-a ali eni ẹa fialo-a, shi eni mhọli ẹgbhali ali eni ẹa mhọli ẹgbhali. ");
INSERT INTO atgNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ighọ, o gbo liẹ kphakpha mhẹ egbe ni mhi rọ li gue oni usomhi onete yẹ ẹ ni a la iRomu. ");
INSERT INTO atgNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Omama oni usomhi onete ọa ya mu mhẹ, irari khi lọli o khi ekpabọ oyi Ẹshinẹgba ni a rọ ọ tsumhi ọgbọkpa ni ọ miesuọ, ẹgbọ iJu o kpẹ ramhi egbe, neni o tigbe ramhi ẹgbọ iJẹta egbe. ");
INSERT INTO atgNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Oni usomhi onete ona o guele abi Ẹshinẹgba ọ liẹ mie ọgbọkpa ni ọ mhọli irudunga. Ẹzẹzẹ abi Ebe-no-pfuasẹ ọ ngme khi, “Ọni Ẹshinẹgba ọ ri irari irudunga oyọli pfa na, ọ ya la agbọ.” ");
INSERT INTO atgNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Idane elemhi ibibi oyi Ẹshinẹgba o te ẹ tiemhile shi ẹgbọ ni ẹa miesuọ ali ena ọkhọlọ nya ọ, ni e ri ọkhọlọ oyẹwẹ ẹ khukhu ẹgbọ alo ini e khi lẹsẹ igẹsikia oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Aborọkhia khi e lẹsẹ emini a dobẹ a lẹsẹ ingme oyi Ẹshinẹgba, itobọ khi ọ khueghie ọli-a khasẹ wẹ gboo. ");
INSERT INTO atgNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Irari khi rọte igbaekẹle agbọ a te mẹ ekpabọ ali ufumhi ali abi Ẹshinẹgba ọ li gboo. Emini ọ ma nya o ri awa mhọli ilẹsẹ abi ọ li. Onana o zẹ khi ẹgbọ ẹa mhuẹ emini e ya liẹ khi o zẹ ni wẹwẹ ẹa rọ miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","E lẹsẹ Ẹshinẹgba, ama ẹa kuẹghiẹ ọli abi Ẹshinẹgba, wẹkhi eri e kphẹmhi ọli. Ochoghọ, isamhi afuẹ ẹẹ sa, ighọ udu ọọyẹghẹ oyẹwẹ o bishi-a. ");
INSERT INTO atgNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ẹ khi, eni e fialo-a wẹwẹ e khi, ama e mele eyẹghẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","E ya ọghiẹ ufumhi ni a rọ na Ẹshinẹgba ni ọ la agbọagbọ na ikhumhi ni a mama rọ khọkhọ ọgbọ ni ọọ ghu ali ipfeli ali elamhakọ ali emini ẹẹ ti akpidi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Irarighọ, Ẹshinẹgba ọ rọ rue wẹ obọ-a na ọghuẹmhẹ olamhẹ oyi udu eyẹwẹ ali itsẹbọ ni e nu egbewẹ ẹ li. ");
INSERT INTO atgNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","E ri ẹgbhọli ọghiẹ igẹsikia oyi Ẹshinẹgba. Ee ga emini a ma, ocho ni e kha rọ ke ga Ima, ọni ọ khi ọni a kuẹghiẹ ya ramhi ẹlẹ ni agbọagbọ. Atsẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Itobọ ona, Ẹshinẹgba ọ rọ rue wẹ obọ-a na ọghuẹmhẹ omama. Egbegbi ikpotso eyẹwẹ, e nu egbe wẹ ẹ gbhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ighọ li khi eni emọse, ocho ni e kha rọ le ke deba ikpotso, emọse na abi wẹwẹ ẹẹ ghọle wẹ inu-gbhẹ. Emọse ẹ gbe ikanya omama ke deba emọse, irarighọ, e she mie ifata ikanya ebe eyẹwẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Irari khi ẹa lama ri egbegbi ilẹsẹ oyi Ẹshinẹgba ni e mhuẹ shi udu, Ẹshinẹgba ọ rọ zẹ wẹ obọ na isamhi ebe udu oyẹwẹ ni e ke riẹlẹ emini ẹa kha riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ọkhọlọ khi ọkhọlọ nya o kẹsẹ wẹ-a, ghe ingmobe, ghe emhi ito-egbe, ghe ubọgbọ. Ofuma ikpekpe o vọ wẹ egbe, ghe ugbeli, ghe okhọli, ghe ikpamhika, ghe ọbe-imumu. Eni ẹ tsue ẹgbọ kiakia e khi. ");
INSERT INTO atgNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","E ri unu ẹ yese ọgbọ-a, ẹẹ biselemhi Ẹshinẹgba, ezunu-obe, ni ẹa mhuẹ ekpẹ, ni ẹẹ tono obọ udu. Odẹ ebe ni a rọ li ọkhọlọ enegbọ, ẹẹ sa rọ lasele ẹghẹghẹ kpa. Ẹa ya suọ esọ na itawẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ẹa mhuẹ ilẹsingme, ẹa ri ishobọ oyẹwẹ a gbe akanya, ẹa ya ti elemhi ọgbọ wẹkhi eri e mhuẹ ilẹlemhi na ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","E lẹsẹ khi ushi oyi Ẹshinẹgba, ọọ khi, ẹgbọ ni e li na ngeli, eni e ya pfua e khi, ọa khi eri e lẹsẹ ẹ riẹlẹ emhi eghọghọ tsẹ, ama ẹẹ mie obọ shi eni ẹ gbe ikanya eghọghọ ọ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yẹyẹ ni u wa gue ẹgbọẹse ẹzọ, waa mhọli obini u pfue ọ ya je, irari khi ẹghẹghẹ kpa ni u rọ gue ọgbọẹse ẹzọ ne, egbe ẹ wa gue ẹzọ, itobọ khi yẹyẹ oyẹ u lili ẹ riẹlẹ eni emhi. ");
INSERT INTO atgNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Awa lẹsẹ khi ẹzọ ni Ẹshinẹgba ọ gue ẹgbọ ni ẹẹ riẹlẹ emhi eghọghọ, khi igẹsikia ọ deba gue ọli. ");
INSERT INTO atgNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Eri u dabi khi ini yẹyẹ ọgbọ afuafuafuẹ u gue ẹgbọẹse ẹzọ, khi yẹyẹ u li riẹlẹ oni emhi oghọghọ, khi u ya pfue ẹzọ oyi Ẹshinẹgba? ");
INSERT INTO atgNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Abi khi eri u ri ẹloe ẹ gbe isomhelemhi ali iregbemie ali irabọmudu eniẹmhi eyọli, nu waa lẹsẹ khi isomhelemhi oyi Ẹshinẹgba o rẹ ramhi imupfi? ");
INSERT INTO atgNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ama irari igbiti ali udu ni ọa mhuẹ imupfi ni a mhuẹ, a rọ khi ma ofu oyi Ẹshinẹgba, ni ọ rọ ya na ẹ osoli, ẹghẹghẹ ni iguẹzọ oyọli ni ọa mhuẹ azẹba o rọ ya feli lasele. ");
INSERT INTO atgNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ẹshinẹgba, “Ọ ya fali ọgbọgbọ ota abi ọ li gbe.” ");
INSERT INTO atgNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ọ ya ri agbọ na agbọagbọ na ẹgbọ ni e mhuẹ irabọmudu ẹ riẹlẹ onete, ni ẹẹ nono ufumhi ali agbọ ni ọa mhuẹ ukpẹsẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ama ẹgbọ ni ẹẹ na shi oyẹwẹ tsẹ, ni ẹa ri esọ shi igẹsikia ni o la ungmemhi oyi Ẹshinẹgba, ni e deba onobe vu, Ẹshinẹgba ọ ya tiese ofu ali elemhi ibibi oyọli le shi wẹ ọ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ẹgbọ eni ẹẹ riẹlẹ onobe nya e ya mẹ osoli ali oya. Okekhi ẹgbọ iJu, okekhi ẹgbọ iJẹta. ");
INSERT INTO atgNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ama Ẹshinẹgba ọ ya ri ufumhi ali itinga ali opfọmhẹ na ẹgbọ nya ni ẹ riẹlẹ onete. Okekhi ẹgbọ iJu, okekhi ẹgbọ iJẹta ");
INSERT INTO atgNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Irari khi Ẹshinẹgba ọa ya zọlọ ọgbọkhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ẹgbọkpa ni e lamhẹ olamhẹ ni ẹa mẹ ebe ushi deba, ọgbọ ọa rọte ebe ushi ya gue wẹ ẹzọ, ama ẹgbọkpa ni e mhuẹ ushi deba ni e lamhẹ olamhẹ, a ya rọte ushi gue wẹ ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Irari khi ọa khi ẹgbọ ni e suọ abi ushi ọ ngme tsẹ Ẹshinẹgba ọ ya liẹ khi e pfuasẹ, ama eni e suọ abi ushi ọ ngme ni e rọli ẹ gbe akanya, Ẹshinẹgba ọ ya pfa na khi e pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ẹghẹghẹ kpa ni ẹgbọ iJẹta, ni ẹa mhọli ushi, e rọ rọte angeli oyẹwẹ ri ushi gbe akanya ne, eri e rọkhasẹ khi e lẹsẹ emini ọa ti ali emini o ti ni a riẹlẹ, ini ẹa ririẹ mhuẹ ushi. ");
INSERT INTO atgNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Eri angeli oyẹwẹ o rọkhasẹ khi emini ushi ọọ a ke riẹlẹ, khi e kẹkẹ ọli shi udu, udu oyẹwẹ ọ pfi ọtsẹlẹ shi ọ, isamhi eyẹwẹ ni ẹ gue wẹ ẹzọ isheghuo, e gbo khẹ wẹ shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ighọ o ya li ogbẹlẹ ni Ẹshinẹgba ọ ya rọte obọ oyi iJesu iKirisiti gue wẹ ẹzọ ri osheli oyẹwẹ lasele abi mhi li ri usomhi onete tse abọ. ");
INSERT INTO atgNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ini a lu egbe ẹ ẹgbọ iJu, a ri egbe da ushi ri Ẹshinẹgba a tono obọ udu, ");
INSERT INTO atgNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ini a zẹ Ebe-no-pfuasẹ lẹsẹ ọghuẹmhẹ oyi Ẹshinẹgba, ni a gbo lẹsẹ emini o gbe akanya, ");
INSERT INTO atgNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ini a lẹsẹ khi ẹẹ a khi eni ẹẹ sẹsẹ ezalo odẹ, ni a rọ gbo khi ákpá na ẹgbọ ni e la alo ebili, ");
INSERT INTO atgNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","a ye ẹgbọ ni e khi eyẹghẹ ude, a sẹsẹ eni ẹa lẹsẹ. A mhọli ọli shi udu khi ilẹsẹ ali igẹsikia o gba pfo shi elemhi ushi. ");
INSERT INTO atgNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ẹẹ ni a sẹsẹ ẹgbọẹse, elọ o zẹ khi aa ya sẹsẹ egbe ẹ? Ẹẹ ni a liẹ ọgbọ ọ khi do ughiatọ, àá liẹ do? ");
INSERT INTO atgNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ẹẹ ni a liẹ ọgbọ ọ khi kia okia, aa liẹ kia okia? Ẹẹ ni ikhumhi igaga ọọ kpasẹ, aa liẹ do ughiatọ elemhi Owa oyi Ẹshinẹgba? ");
INSERT INTO atgNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ẹẹ ni a tono obọ udu khi a mhuẹ ishi eyi Ẹshinẹgba, aa ri omama mu Ẹshinẹgba abi a liẹ gbe eni ishi-a? ");
INSERT INTO atgNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ebe-no-pfuasẹ ọọ khi: “Irari ẹẹ ni a khi ẹgbọ iJu ẹgbọ iJẹta e rọ ọ zẹ ẹmuẹbe na eva oyi Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ini a ri ishi a gbe ikanya, oshẹlẹ oyẹ ẹ o rọ mu ẹloe, ama ini a gbe ushi-a, eri a li abinẹ khi aa shẹlẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ini ọgbọ ni ọa khi iJu ni ọgbọ aa shẹlẹ-a ọ ri ushi oyi Ẹshinẹgba gbe akanya, Ẹshinẹgba ọa ya leli ọli shi ọni aa shẹlẹ-a? ");
INSERT INTO atgNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Itobọ ighọ, ẹgbọ iJẹta e ya pfa ẹzọ mu ẹ iJu itobọ khi a gbe ushi-a, aboriẹkhia khi a kẹkẹ oni ushi shi ebe na ẹ ni a gbo shẹlẹ-a, ama wẹwẹ e ri ushi ẹ gbe akanya ini aa ririẹ shẹlẹ wẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ọa khi itobọ khi ọgbọ ọọ ngeli abi ọgbọ iJu ali itobọ khi a da shẹlẹ ọli-a ọ rọ khi egbegbi iJu. ");
INSERT INTO atgNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ama ọni ọ khi egbegbi iJu ọ khi ọni ọ ri ushi ẹ gbe akanya, Oshẹlẹ na ekelemhi udu o khi igẹsikia oyi oshẹlẹ, ọa khi ona ẹkuẹ idiegbe oyẹ. Ọgbọ ọghọghọ Ẹshinẹgba ọọ kuẹghiẹ ọli, aa khi ẹgbọ ẹẹ kuẹghiẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ighe eleli ni ẹgbọ iJu, ikhi eni a lu eni a shẹlẹ-a, e mhọli dọsẹ ẹgbọ iJẹta? Ighe eleli ni o la ọ na ẹgbọ ni ẹ lu egbewẹ eni a shẹlẹ-a? ");
INSERT INTO atgNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Èleli o la ọ na ọgbọgbọ odẹ khi odẹ. Ododẹ, ẹgbọ iJu Ẹshinẹgba ọ kpẹ ri oni ungmemhi nga obọ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ini o fẹ khia khi eghuo ọ ẹa mhuẹ irudunga? Eri umha mhuẹ irudunga oyẹwẹ o ya liẹ khi Ẹshinẹgba ọa ke zẹ ri egbe ẹ nga? ");
INSERT INTO atgNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Iiye e! Ini ọgbọkpa o tseku khi ọloẹgbhuẹ, igẹsikia Ẹshinẹgba ọ khi. Abi Ebe-no-pfuasẹ o ngme, ni ọọ. “A mema mẹ khi yẹyẹ u te odẹ ini u ngme, ali khi u ya mu ọ le ini a gue ẹ ẹzọ.” ");
INSERT INTO atgNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ama ini umha guẹ ẹ ngeli oyawa o ri ipfuasẹ oyi Ẹshinẹgba khasẹ gboo, sẹẹ awa ke fẹ ya ngme? Eri awa ya liẹ khi Ẹshinẹgba ọ gbe awa azẹba ini ọ na awa osoli tọ onobe ni awa li? Eri mhi la ana ngme abi ọgbọ ọ liẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Emini a sọ shi ona khi, IIye o, ini o khia khi Ẹshinẹgba ọọ gbe azẹba lọ, se ọ kha li dobẹ gue agbọ ẹzọ? ");
INSERT INTO atgNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ẹgbọ eghuo e ya ke khakọ, ẹẹ li, “Ini o khia khi ẹgbhọli ni mhi lo o ri izẹ-ri-egbenga oyi Ẹshinẹgba khasẹ, ni o khi ma ufumhi oyọli, sẹ a ke gbo liẹ pfa ẹzọ mu mhẹ abi ọgbọ ọna olamhẹ?” ");
INSERT INTO atgNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Elọ o ke zẹ ni awa a rọ liẹ khi o tinẹ ni awa ke li ingmobe ni onete o rọte ọ lasele? A ya gue ọgbọgbọ eni e ngme na ẹzọ. Ẹzẹzẹ abi ẹgbọ eghuo e she kpẹ li kiẹnọ ẹgbhọli ma mhẹ khi emini mhia sẹsẹ ẹgbọ ghọ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ini a fẹ bino ọ bie, eri awa iJu awa fẹ ti dọsẹ iJẹta? IIye o! Mhi she kpẹ rọli khasẹ khi ẹgbọ iJu ali ẹgbọ iJẹta nya elemhi olamhẹ awa la a kia. ");
INSERT INTO atgNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Abi Ebe-no-pfuasẹ o ngme ni ọọ: “Ọgbọkhọghuo ọa la ọ ni ọ guẹ ẹ ngeli, ọgbọ aa mẹ, ");
INSERT INTO atgNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Aa mẹ ọni ọ mhuẹ ilẹsẹ, wẹkhi eri ọgbọkhọghuo ọọ ga Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ẹgbọ nya e she sọ ukhokho gbe Ẹshinẹgba. Wẹwẹ nya e she rọte odẹ oboese ni ọa ti. Ọgbọkhọghuo ọa la ni ọọ riẹlẹ onete, ọgbọ aa mẹ ọghuo kpe!” ");
INSERT INTO atgNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Eri ukokoluọluọ oyẹwẹ o li abi uji ni o khueghie-a shi ekẹ. Eri ẹlẹmhi oyẹwẹ O ri udimhi ẹ pfi itsee.” “Osuẹ ẹnyẹ afue o la wẹ unu.” ");
INSERT INTO atgNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Inu eyẹwẹ o vọ itsẹ ebe ikuku ali oyala.” ");
INSERT INTO atgNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Ọa ya mu wẹ unu ni e rọ gbe ugbeli, ");
INSERT INTO atgNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","epfua ali oyese ẹẹ pfi shi obini e je kpa, ");
INSERT INTO atgNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ẹa lẹsẹ abi a liẹ la opfọmhẹ.” ");
INSERT INTO atgNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Wẹkhi eri e mhọli ekpẹ na Ẹshinẹgba.” ");
INSERT INTO atgNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Mena, awa lẹsẹ khi emini a kẹkẹ shi ushi nya, khi eni e deba ushi ẹ ngeli a kẹkẹ ọli na. Ni a rọ bhale ya ẹ khi ọgbọ okhọghuo ọa ya liẹ khi emini o zẹ ni luẹ rọ gbe ushi-a na, ini Ẹshinẹgba ọ gue agbọ nya ẹzọ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ọgbọ ọa la ọ ni a ya pfa na khi ọ pfuasẹ irari khi ọ ri ushi ẹ gbe akanya. Ochoghọ eri ushi o zẹ awa lẹsẹ khi olamhẹ o la ọ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ama Ẹshinẹgba ọ she ri odẹ onogbọ ni ọ te pfa na awa khasẹ awa ni ọa khi abi ushi o sẹsẹ awa. Ni ebe Ushi ali emekẹguele e pfi ọtsẹlẹ shi. ");
INSERT INTO atgNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Oni odẹ onogbọ ona ni Ẹshinẹgba ọ rọ bhale, irudunga iJesu iKirisiti o te ẹ bhale deba eni e mie ọli suọ nya. Ikhiọda ọa la ọ na eni e khi iJu ali iGiriki. ");
INSERT INTO atgNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Irari khi ọgbọkpa ọ she lamhẹ, ẹgbọ e she nuata shi Ẹshinẹgba ni ọọ tsumhi ọ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ama afuẹ afuẹ ọ ri okhale oyọli pfa na awa khi awa pfuasẹ, rọte ipfashekẹ ni o te obọ oyi iJesu iKirisiti bhale. ");
INSERT INTO atgNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Eri Ẹshinẹgba ọ ri iKirisiti khasẹ agbọ nya, khi lọli ọ khi ọni ọ dobẹ ya ri olamhẹ topfa agbọ, abi ọ li ku ọlia eyọli kua ukhomhi apfida. Awa kha regbenga emini iKirisiti ọ riẹlẹ, awa mhọli ipfashekẹ ni o rọ rọkhasẹ khi Ẹshinẹgba ọa ya gbe azẹba. Itobọ khi Ẹshinẹgba ọ mhọli irabọmudu ali khi ọa ya gbe azẹba, ọ rọọ gbe olamhẹ kua na ẹgbọ, ọ guele khi ọgbọkpa ni ọ ri udu nga iJesu, khi ọni a pfa na ọ khi. ");
INSERT INTO atgNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Elọ awa ke tono obọ udu ẹ shi? Afuẹ! Elọ o zẹ ona? Itobọ khi awa ma rọ ri ushi a gbe lọ? Iiye o, ama itobọ khi awa miesuọ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Irari khi awa zọli ukhomhi khi eri Ẹshinẹgba ọọ pfa na ẹgbọ ni e mhuẹ irudunga ni ọa khi irari iri-ushi-gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ẹshinẹgba ọyi ẹgbọ iJu tsẹ ọ lẹsẹ khi, ọa ke li khi Ẹshinẹgba oyi ẹgbọ iJẹta? Ọyẹwẹ ọ khi guẹguẹguẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ẹshinẹgba ọghuo ọ khi, ọni ọọ pfa na ẹgbọ eni e shẹlẹ-a rọte irudunga oyẹwẹ ali eni áà shẹlẹ-a rọte oni irudunga oghuo. ");
INSERT INTO atgNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Eri ona o ke liẹ khi itobọ irudunga oyawa, khi awa a ke mhuẹ emini awa ri ushi ẹ li? IIye e. Ochoghọ awa kie mu ushi mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Sẹ awa ke ya ngme shi ingme oyi Aburaamu ni ọ khi ititawa? Elọ ọ fẹ mẹ eni ingme ipfana rọte irudunga onana? ");
INSERT INTO atgNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ini o khia khi ikanya ni Aburaamu ọ gbe a rọ pfa na li lọ, ọ kha mẹ emhi rọ ke tono obọ udu, ama ọa khi odalo oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Eri Ebe-no-pfuasẹ ọọ, “Eri Aburaamu ọ mie Ẹshinẹgba suọ, lọli a rọ leli ọli na li shi ipfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ini ọgbọ gbe akanya, ọgbọ ọa ya liẹ khi ifata ni ọ mie khi isomhopfa lọ, ama eri ọ gbe akanya shi ọ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ama ọgbọ ni ọa ri egbe da ikanya obọ oyọli ni ọ gbe, ni ọ regbenga Ẹshinẹgba ni ọọ pfa na ọna ọkhọlọ, oni irudunga ni ọ mhọli eghọ a deba guele khi ọ pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Abi iDefidi ọ rọ ngme nga ikhivọsẹ oyi ọni Ẹshinẹgba ọ pfa na, ni ọa khi itobọ ikanya obọ oyi lọlighuo, ọ mu ma ingme ena, abi ọ rẹẹ, ");
INSERT INTO atgNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Oghẹlẹ o khi na ẹgbọ ni Ọnọmhuẹ ọ gbe umha guẹli oyẹwẹ kua, ni a ri olamhẹ oyẹwẹ topfa wẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Oghẹlẹ o khi na ọgbọ ni Ọnọmhuẹ ọa kẹkẹ olamhẹ eyọli shi na li.” ");
INSERT INTO atgNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Oni ikhivọsẹ ona, ẹgbọ ni a shẹlẹ-a e lẹsẹ mhọli ọli? Abi khi ẹgbọ ni aa shẹlẹ-a e li mhọli ọli? Awa kie kpẹ ẹ ngme ọli khi irudunga ni Aburaamu ọ mhuẹ, lọli a rọ guele khi ọ pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ẹghẹghẹ onoghuo a rọ leli ọli na li? Abi a rọ shẹlẹ ọli-a se lọ, abi khi neni a shẹlẹ ọli-a? Ọa khi abi a rọ shẹlẹ ọli-a se, ama abi aa rọ shẹlẹ ọli-a ne lọ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Itobọ khi ọ mhọli irudunga, Ẹshinẹgba ọ rọ pfa na li khi ọ mhọli ipfuasẹ neni ọ shẹlẹ-a. Irarighọ, ọ rọ khi ita ọyi ẹgbọ nya ni e miesuọ, ini aa tseku shẹlẹ wẹ-a. Ẹghẹghẹ aghọ ni e khi eni a pfa na khi e pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ita oyi ẹgbọ eni e shẹlẹ-a ọ li khi. Aa khi itobọ khi a shẹlẹ wẹ-a tsẹ, ama irari khi e deba ẹtẹ-awẹ agbọ irudunga nabi itawa Aburaamu, neni a shẹlẹ ọli-a. ");
INSERT INTO atgNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ọa khi iri ushi gbe akanya Aburaamu ali imimi ọli e te mie oni ishobọ khi lọli ọ ya le ugu agbọ nya, ama rọte angeli ipfuasẹ ni o rọte irudunga bhale oyọli lọ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Irari khi ini eni e ri ushi gbe akanya e le oni ugu lọ, irudunga ọa kha ke mu ẹloe, oni ishobọ o mele afuẹ-a. ");
INSERT INTO atgNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Eri ushi o ri ofu oyi Ẹshinẹgba bhale, irari khi ini ushi ọa la ọ, igbushi-a ọa kha la ọ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Irarighọ, oni ishobọ, irudunga o te ẹ bhale, isheghọ ni o khi oyi okhale, ali ni o migha na imimi Aburaamu. Ọa khi oyi ẹgbọ ni e ri ushi ẹ gbe akanya tsẹ, ama li shi oyi eni e miesuọ abi Aburaamu. Irari khi Aburaamu ọ khi ita awa nya elemhi ayẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Abi Ebe-no-pfuasẹ o ngme ni ọọ, “Mhi she rẹ mele ita ọyi ushishi ebubu-a.” Irudunga ni Aburaamu ọ mhuẹ Ẹshinẹgba ọ rọ shobọ na li. Ẹshinẹgba ni ọọ ri eni e ghu-a guale bhale agbọ, ni ọ ma emhi enegbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Eri Aburaamu ọ miesuọ, ọ mhuẹ irudushi, abi ọa rọ tseku mẹ emini ọ ri udu shi ne, itobọ ighọ ọ rọ khi, “Ita ishishi ebubu.” Abi a kie kpẹ li gue ọli ye ọli khi, “Imimiẹ e ya bu abi ikpẹtata.” ");
INSERT INTO atgNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ọa tigbe lọsẹ Aburaamu shi irudunga oyọli, aboriẹkhia khi ọ she gbe ikpe egbhuẹshe, ni ọ gbo lẹsẹ khi lọli she womhẹ ramhi eghuli ali khi iSera ughuọli ọ she li womhẹ dọsẹ ni ọ ke dobẹ ya bia eniyẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Irudunga oyọli ọa mhuẹ ọlọsẹmhẹ wẹkhi eri ọ khọkhọ udu shi emini Ẹshinẹgba ọ ngme. Oni irudunga oyọli o ri itoto na li, ọ kuẹghiẹ Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Eri ọ lama shi ọ egbegbọ khi Ẹshinẹgba ọ ya dobẹ riẹlẹ emini ọ shobọ na luẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Lọli o zẹ khi, “A pfa na li khi ọ pfuasẹ.” ");
INSERT INTO atgNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ungmemhi khi, “A leli ọli na li shi angeli ipfuasẹ,” ọa khi lọlighuo tsẹ a kẹkẹ ọli na. ");
INSERT INTO atgNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ama a li kẹkẹ ọli na awa, eni Ẹshinẹgba ọ liẹ leli angeli ipfuasẹ na, ni awa mie ọli suọ ikhi lọli ni ọ rọte eghuli guise iJesu Ọnọmhuẹ ọyawa le. ");
INSERT INTO atgNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Eri Ẹshinẹgba ọ rue ọli obọ-a ni ọ ghu-a shi ingmobe eyawa. O guise ọli le bhale agbọ ni ọ khuẹsẹ awa pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Irarighọ, aborọkhia khi a she pfa na awa eghọ khi awa pfuasẹ rọte irudunga oyawa, awa she mhuẹ opfọmhẹ odalo oyi Ẹshinẹgba rọte obọ oyi iJesu iKirisiti Ọnọmhuẹ oyawa. ");
INSERT INTO atgNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Lọli awa rọte obọ oyọli mhọli odẹ lo isomhelemhi oyi Ẹshinẹgba, te irudunga ni awa migha nga memena. Awa ke ghẹlẹ shi irudushi oyi ufumhi oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ọa khi ighọ tsẹ, ama awa liẹ ghẹlẹ shi osoli oyawa, irari khi awa lẹsẹ khi eri osoli ọọ sẹsẹ ọgbọ iregbemie. ");
INSERT INTO atgNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Iregbemie o ri ọgbọ ọ mhuẹ egbegbi angeli, egbegbi angeli o ri ọgbọ ọ mhuẹ irudushi. ");
INSERT INTO atgNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Oni irudushi ona, ọa ya zẹ awa mẹ omama. Irari khi Ẹshinẹgba ọ she tutu inono oyọli ku awa udu rọte Ayẹmhẹ-nọ-pfuasẹ, ni ọ rọ na awa. ");
INSERT INTO atgNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Irari khi ẹghẹghẹ ni awa aa rọ mhọli ekpabọ ni awa rọ khi ena olamhẹ, iKirisiti ọ bhale ya ghu-a na awa. ");
INSERT INTO atgNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","O ma munu ni ọgbọ ọ rọ ghu-a na ọgbọ ni ọ guẹ ẹ ngeli, otsẹ ọgbọ ọ ya rọshẹka ni luẹ ghu-a na ọgbọ onete. ");
INSERT INTO atgNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ama eri Ẹshinẹgba ọ ri inono ni ọ mhọli na awa khasẹ. Lọli o zẹ khi ẹghẹghẹ ni awa rọ kie khi ena olamhẹ, iKirisiti ọ rọ bhale ya ghu-a na awa. ");
INSERT INTO atgNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Aborọkhia khi a she rọte ọlia eyọli pfa na awa mena, sẹẹ ọa liẹ tsumhi awa ofu oyi Ẹshinẹgba! ");
INSERT INTO atgNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Irari khi ini ẹghẹghẹ ni awa rọ khi ebe Ẹshinẹgba khi a rọte eghuli ni omiọli ọ ghu ri awa nu ọli mhuẹ irọ-riẹlẹ, sẹẹ awa ni a she rọ nu Ẹshinẹgba somhi awa aa li gbo ya rọte agbọ oyọli mhuẹ imiepfuese! ");
INSERT INTO atgNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ọa khi ighọ tsẹ, ama awa li mhọli oghẹlẹ ayi Ẹshinẹgba rọte iJesu iKirisiti Ọnọmhuẹ ọyawa, ọni awa rọte obọ oyọli mhuẹ irọsomhi. ");
INSERT INTO atgNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Olamhẹ ni Adamu ọ lamhẹ o ri eghuli lo agbọ le. Olamhẹ oyọli o zẹ khi ọgbọkpa ọ khi ọna olamhẹ, irarighọ ọgbọkpa ọ rọ ya ghua. ");
INSERT INTO atgNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Irari khi neni a ri ushi bhale olamhẹ, ọ she kpẹ lo agbọ le, ama ashini ushi ọa la, aa ya leli olamhẹ na ọgbọkhọghuo. ");
INSERT INTO atgNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Aboriẹkhi ighọ, eri eghuli o kie rọte ẹghẹghẹ oyi Adamu gbe ẹgbọ ya ramhi ẹghẹghẹ oyi iMosisi, li shi ẹgbọ ni ẹa gbe ushi-a abi Adamu ọ li da omhẹsẹ oyi Ẹshinẹgba. Adamu ọ khi irọkhọkhọ oyi ọni ọ ya bhale. ");
INSERT INTO atgNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ama wẹwẹ aava ẹa li abeghuo irari khi isomhopfa onayi Ẹshinẹgba ọa li abi olamhẹ oyi Adamu. Igẹsikia o khi, khi ebubu ẹgbọ e ghu-a irari olamhẹ oyi ọgbọghuo ọghọ. Ama okhale oyi Ẹshinẹgba o funẹ. Ighọ khi isomhopfa ni ọ rọ na ebubu ẹgbọ rọte isomhelemhi oyi ọgbọ ọghuo, ikhi iJesu iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ikhiọda o la isomhopfa oyi Ẹshinẹgba ali olamhẹ oyi Adamu. Oni olamhẹ oghuo oghọ o ri ina-osoli bhale. Ama isomhopfa oyi Ẹshinẹgba o ri ipfana bhale ghi awa aboriẹkhia khi eni e lamhẹ awa khi. ");
INSERT INTO atgNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Igẹsikia o khi, khi rọte olamhẹ oyi ọgbọ ọghuo, eghuli o te bhale agbọ. Ama emini ọgbọ ọghuo ọ riẹlẹ, ikhi iJesu iKirisiti, o funẹ. Ẹgbọ nya ni e mie okhale oniẹmhi ali isomhopfa afuẹ afuẹ oyi ipfuasẹ oyi Ẹshinẹgba, e ya mu olamhẹ ọ le, rọte obọ oyi iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Abi olamhẹ oyi Adamu o li ri ina-osoli ghi ẹgbọkpa, ighọ ipfuasẹ oghuo oyi iKirisiti o li ri ipfana ali isomhopfa agbọ oyi Ẹshinẹgba na ọgbọkpa. ");
INSERT INTO atgNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Irari khi, abi umha-suesọ oyi ọgbọ oghuo o ri ẹgbọ nya khi ena olamhẹ, ighọ a li ya pfa na ebubu ẹgbọ shi odẹ oyi Ẹshinẹgba irari isuesọ oyi ọgbọ oghuo. ");
INSERT INTO atgNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Eri ushi o bhale ni ẹgbọ lẹsẹ ashini e khi ena olamhẹ ramhi, ama abibi olamhẹ e tseku li bu, ilẹlemhi oyi Ẹshinẹgba o bu dọsẹ wẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ẹghẹghẹ aghọ ni a bhale ya ẹ khi ẹzẹzẹ abi olamhẹ o ri eghuli bhale, okhale oyi Ẹshinẹgba o ri ipfuasẹ leghie, o ri agbọ na agbọagbọ bhale, rọte obọ oyi iJesu iKirisiti Ọnọmhuẹ ọyawa. ");
INSERT INTO atgNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Sẹ awa ya ngme mena, eri awa ya ke li ingmobe lẹ tsẹ ni okhale oyi Ẹshinẹgba o ke bua shi ọ dọsẹ aghọ? ");
INSERT INTO atgNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Iiye o! Awa ni idiegbe oyawa o ghu pfa olamhẹ, sẹẹ awa ke gbo liẹ ke lamhẹ? ");
INSERT INTO atgNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Abi khi aa lẹsẹ khi awa nya ni a batazi shi iJesu iKirisiti, khi eri awa batazi shi eghuli oyọli? ");
INSERT INTO atgNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Irarighọ, eri a ri awa nu ọli tọ abi a rọ sọ awa okẹ batazi awa shi eghuli oyọli, ni a bhale ya ẹ khi abi a li rọte eghuli guise iKirisiti le rọte ufumhi oyi Ita, ni awa li mhọli agbọ onogbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Abi a rọ ku awa ali lọli gbe she eghuli oyọli eghọ, ighọ a gbo liẹ ku awa ali lọli gbe shi iguisele oyọli. ");
INSERT INTO atgNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Awa lẹsẹ ona khi idiegbe oyawa onodiọ khi eri o nu iJesu ghu-a shi apfida, ni a rọ bhale ya ẹ khi idiegbe olamhẹ oyawa o mele afuẹ-a. Ini awa khi ke gbo khi ighumha olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Itobọ khi ini ọgbọ ọ ghu-a, ọ she pfue ekpabọ olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Mena, ini awa she nu iKirisiti ghua, awa miesuọ khi awa ya li nu ọli la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Irari khi awa lẹsẹ khi abi a she rọte eghuli guise iKirisiti le eghọ, ọa ke gbo ya ghu ghue, eghuli ọa ke gbo mhọli ekpabọ shi ọli egbe. ");
INSERT INTO atgNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Eghuli ni ọ ghu, utoghuokpe ọ ghu ọli rọ mu ekpabọ eyi olamhẹ ọ le. Agbọ ni ọ la, ọ la ọ na Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","A li lighọ leli egbe ẹ shi eni e ghu pfa olamhẹ, ama a la agbọ na Ẹshinẹgba elemhi iJesu iKirisiti. ");
INSERT INTO atgNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Irarighọ, a khi zẹ ni olamhẹ o le eghie shi ẹ egbe ni a ri ọghuẹmhẹ ebe eyọli ke gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","A khi ri ukiẹkiẹ idiegbe okhọghuo oyẹẹ na olamhẹ, wẹkhi eri u rẹ wẹ shi ekẹ shi akanya ọkhọlọ, ochoghọ, a ri egbe ẹ na Ẹshinẹgba abi eni a she rọte eghuli nyenẹ bhale agbọ, ama a ri idiegbe oyẹẹ na li abi itsua ipfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Irari khi olamhẹ ọa ke ya khi ọga ọyẹẹ, itobọ khi ushi ọa kẹ ẹ ke mhẹsẹ na ẹ, ama elemhi okhale oyi Ẹshinẹgba a ke la. ");
INSERT INTO atgNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Sẹ o ke li mena? Awa ke lamhẹ itobọ khi ushi ọa ke mhẹsẹ ẹ na awa, sẹ ni okhale oyi Ẹshinẹgba? Iiye o! ");
INSERT INTO atgNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Aa lẹsẹ khi oghumha ọyi emini a suọ esọ ọ na a khi? U dobẹ ya khi oghumha ọyi olamhẹ ni o ri eghuli ẹ bhale, u gbo dobẹ ẹ zẹ isuesọ na Ẹshinẹgba ni o ri ọgbọ ọ bhale angeli ipfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ama awa tse Ẹshinẹgba uwegbe, irari khi ẹghẹghẹ ni o dọsẹ, a kpẹ khi ighumha eyi olamhẹ, ẹghẹghẹ aghọ a ga ri udu oyẹ ẹ nya a suọ esọ na osẹsẹ ni a sẹsẹ ẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","A she pfuese ẹ olamhẹ, ama ighumha eyi Ẹshinẹgba a ke khi, ni a ke riẹlẹ emini o ghọle Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Eri mhi ngme ona abi ọgbọ liẹ ngme, itobọ khi aa lolo toto. Abi a kpẹ li ri idiegbe eyẹ ẹ shi ighumha na ikanya ichimhi ali ọkhọlọ, a li lighọ ri egbe ẹ shi ighumha angeli ni o ghọle Ẹshinẹgba, ni o ri ipfuasẹ ẹ bhale. ");
INSERT INTO atgNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Abi a rọ khi ighumha olamhẹ, aa mhuẹ emini a ri angeli ni o ghọle Ẹshinẹgba riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ighe eleli ni a mhuẹ oni ẹghẹghẹ shi ikanya ni e ke tigbe ri omama a mu ẹ ena? Emhi eghọghọ eghuli ẹẹ pfi. ");
INSERT INTO atgNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ama mena ni a she rọte olamhẹ pfuese ẹ, ni a ke rọ khi ighumha eyi Ẹshinẹgba eghọ, eleli ni a khiẹsẹ, ipfuasẹ o rẹ ẹ ya khuẹ pfuasẹ, o ri agbọ na agbọagbọ ọ na ẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Irari khi ifata oyi olamhẹ khi eghuli lọ, ama isomhopfa oyi Ẹshinẹgba agbọ na agbọagbọ lọ rọte obọ oyi iJesu iKirisiti Ọnọmhuẹ oyawa. ");
INSERT INTO atgNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","A lẹsẹ inyọghuo, khi eri mhi nu ẹ ngme abi ẹgbọ ni e lẹsẹ ushi, khi ushi o mhọli ekpabọ shi ọgbọ egbe ini ọni ọgbọ ọ kie da la agbọ ne. ");
INSERT INTO atgNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ẹzẹzẹ abi ushi o ngme khi ọkpotso ni ọ la ughuẹ ọa gbudu vu ọdọ li obọ ini ọni ọmọse ọ kie da la agbọ ne, ama khi ini ọ ghu-a oni ushi ọa ke mu ọli. ");
INSERT INTO atgNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Irarighọ, ini ọ vu ya ngeli na ọmọse ọlese, abi ọdọli ọ li kie la agbọ eghọ, a ya lu ọli ọkiokia. Ama ini ọdọ li ọ ghua, oni ushi oghọ ọa ke mu ọli, ọa ke khi ọkiokia, ini ọ tseku ngeli na ọmọse ọlese. ");
INSERT INTO atgNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ighọ o li khi shi ẹ ọ inyọghuo-mhẹ. Idiegbe oyi iKirisiti a ke khi, ẹẹ a she li ghu-a pfa ekpabọ oyi ushi. A she ga li mhọli ẹghẹghẹ ni a rọ mele ọyi ọgbọẹse-a, ikhi ọni a rọte eghuli guise le, ni a mẹ asha ke gbe akanya enete na Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Irari khi abi idiegbe olamhẹ o rọ ọ mhẹsẹ na awa, ighọ ọghuẹmhẹ oyi olamhẹ ni ushi o zese-a o la awa idiegbe gbe akanya, ena e ri awa ngeli angeli ni ọọ pfi eghuli. ");
INSERT INTO atgNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ama mena, abi awa rọ she ghu pfa emini e ke kpẹ gẹnọ awa eghọ, a she pfuese awa obọ oyi ushi, ni awa mẹ asha rọte odẹ onogbọ oyi Ayẹmhẹ ke ga, ni ọa ke khi odẹ oyi ushi ni a kẹkẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Sẹ awa ke ya ngme mena? Olamhẹ oni ushi o ke khi shọ? Iiye o. Egbegbọ lọ khi, mhi aa kha lẹsẹ emini olamhẹ o khi, ini ọa khi ushi lọ. Irari khi mhi aa kha lẹsẹ emini iviẹ shi emhi ọgbọ o khi ini ushi ọa liẹ, “Khi viẹ shi emhi ọgbọ.” ");
INSERT INTO atgNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Rọte oni ushi oghọ, olamhẹ o te mẹ asha guise iwali ọghuẹmhẹ ukphẹ nya ni e la mhẹ egbe le. Ini a rue ushi odẹ-a eri olamhẹ o ghua. ");
INSERT INTO atgNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Eri mhi kpẹ la agbọ tse abi mhi aa rọ lẹsẹ ushi ne, ama abi ushi o ke rọ bhale, olamhẹ o gbo bhale agbọ, lọli mhi rọ ghua. ");
INSERT INTO atgNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Mhi mẹ khi ushi ni o kha ri agbọ bhale, khi eghuli o rọ bhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Olamhẹ o mẹ asha migha rọte ushi di mhẹ. Rọte oni ushi, eghuli o gbe mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Abokieli khi, oni ushi o pfuasẹ, omhẹsẹ o pfuasẹ, e migha, e ti. ");
INSERT INTO atgNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Eri emini o ti oghọ o ke ri eghuli ghi mhẹ eghọ? Iiye o! Ama ni a rọ lẹsẹ olamhẹ shi olamhẹ o rọ pfi eghuli na mhẹ, rọte emini o ti, ni a bhale ya ẹ khi rọte oni ushi, olamhẹ o mema khi olamhẹ egbegbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Irari khi awa lẹsẹ khi ushi emhi Ayẹmhẹ o khi, ama mhẹmhẹ ọgbọ tsẹ, mhi khi ọni a rọ na olamhẹ dẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mhi aa lẹsẹ emini e li mhẹ, irari khi emini mhia nono ni mhi ke riẹlẹ, mhi aa dobẹ riẹlẹ ọli. Ama emini ọa ghọle mhẹ, mhia riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ini mhi riẹlẹ emini mhi aa nono ni mhi riẹlẹ, mhi lama shi ọ khi ushi o ti. ");
INSERT INTO atgNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Abi oli khi, ọa ke khi mhẹmhẹ mhia riẹlẹ ọli ama olamhẹ ni o la mhẹ egbe lọ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mhi lẹsẹ khi emhikhọghuo ni o ti ọa lamhẹ egbe, ikhi idiegbe olamhẹ oyẹmhẹ. Irari khi ini o tseku ghọle mhẹ ni mhi riẹlẹ emini o ti, mhia dobẹ ẹ riẹlẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Irari khi emini mhia riẹlẹ ọa khi emini o ti ni mhia nono ni mhi riẹlẹ, ochoghọ onobe ni mhi aa nono ni mhi riẹlẹ, mhi kiele ẹ riẹlẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Mena, ini mhia riẹlẹ emini mhi aa nono ni mhi riẹlẹ, ona o rọkhasẹ khi ọa khi mhẹmhẹ mhi riẹlẹ ọli, olamhẹ ni o la agbọ oyẹmhẹ ọọ riẹlẹ oli. ");
INSERT INTO atgNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ina o ga limhẹ egbe ẹghẹghẹkpa. Ini mhia nono ni mhi riẹlẹ onete, onobe o nu mhẹ la aghọ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Irari khi ekelemhi udu oyẹmhẹ, ushi oyi Ẹshinẹgba o te ẹ ghọle mhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ama mhi mẹ khi ushi olese o la mhẹ egbe ẹ gbe akanya, ni o mu okhọli vule shi ushi ni o la mhẹ udu ọ, o rẹmhẹ mele oghumha ushi oyi olamhẹ-a, ni o la mhẹ egbe a gbe akanya. ");
INSERT INTO atgNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ọgbọ umẹobinuje nabisẹ mhi fẹ khi ena. Ọghuo ọ ya tsumhi mhẹ idiegbe eghuli ona lasele? ");
INSERT INTO atgNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mhi kphẹmhi na Ẹshinẹgba rọte obọ oyi iJesu iKirisiti Ọnọmhuẹ ọyawa. Irarighọ, mhẹmhẹ oyẹmhẹ, oghumha ọyi ushi oyi Ẹshinẹgba mhi khi udu oyẹmhẹ, elemhi idiegbe olamhẹ, mhi khi oghumha ọyi ushi olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Irarighọ, ipfẹzọ-mu ọa ke la ọ na ẹgbọ ne mie iJesu iKirisiti suọ, ni ẹa kẹ ngeli rọte odẹ olamhẹ, ama eni ẹẹ ngeli rọte odẹ Ayẹmhẹ-nọ-pfuasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ayẹmhẹ ni o ri agbọ a na awa itobọ khi awa mie iJesu iKirisiti suọ, ọ she taghiẹ mhẹ obọ oyi ushi olamhẹ ali eghuli-a. ");
INSERT INTO atgNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Emini Ushi oyi iMosisi ọa dobẹ riẹlẹ irari khi idiegbe olamhẹ o mie ọli ekpabọ, Ẹshinẹgba lọlighuo ọ ke ya pfuese awa abi ọ ghie Omi ọli, ni ọ li abi awa ẹgbọ olamhẹ ali ni ọ ya khi iluasobo shi olamhẹ eyawa. Oni idiegbe ọgbọ ni ọni iKirisiti ọ zẹ ọ rọ pfuẹchẹ olamhẹ-a shi idiegbe ọgbọ olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Eri Ẹshinẹgba ọ riẹlẹ ona ni ipfuasẹ ni ushi oo nono ni awa mhọli o tsẹ shi awa egbe, ini awa khi kẹ ngeli te odẹ olamhẹ, ama ni awa ke ngeli rọte odẹ Ayẹmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ẹgbọ ni ẹ ngeli rọte odẹ olamhẹ, eri e ri udu shi emini idiegbe oyẹwẹ ọọ nono. Eri ẹgbọ ni ẹẹ ngeli rọte odẹ Ayẹmhẹ, e ri udu shi emini Ayẹmhẹ ọọ nono. ");
INSERT INTO atgNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Irari khi udu oyi ọgbọ eghuli o tsua. Ama udu ọ riẹlẹ emini Ayẹmhẹ ọ gueyẹ ọli, eri ọ ya la agbọ ọ mhuẹ opfọmhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ọbe Ẹshinẹgba ọgbọ ọọ khi, ini udu olamhẹ oyọli ọọ mhẹsẹ na li, irari khi ọa ya suọ esọ na Ẹshinẹgba. Irari khi ọa zẹ ni ushi oyi Ẹshinẹgba o mhẹsẹ ke na li, wẹkhi eri ọ́ tigbe ya lama ghue ni ọ mhẹsẹ na li. ");
INSERT INTO atgNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ẹgbọ ni idiegbe olamhẹ oyẹwẹ o mhẹsẹ ẹ na, ẹa dobẹ riẹlẹ emini o ghọle Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Yẹyẹ oyẹ idiegbe olamhẹ ọa ke mhẹsẹ ẹ nẹ ama Ayẹmhẹ o ke mhẹsẹ ẹ nẹ, ini Ayẹmhẹ ọyi Ẹshinẹgba o da la agbọ oyẹ ne. Ọgbọ ni ọa da mhuẹ Ayẹmhẹ oyi iKirisiti ne, ọa khi ọnayọli. ");
INSERT INTO atgNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Eri-tsẹ khi ini iKirisiti ọ da la agbọ oyẹ ne, idiegbe oyẹ o fu pfa olamhẹ, ayẹmhẹ oyẹ o kie la agbọ irari ipfuasẹ ni awa rọte obọ oyi iKirisiti mhuẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ini Ayẹmhẹ oyi ọni ọ rọte eghuli guise iJesu le o da la agbọ oyẹ ne, lọli ni ọ rọte eghuli guise iJesu le ọ ya rọte Ayẹmhẹ oyọli ni o la agbọ oyẹ ri agbọ na idiegbe ni ọọ ghu oyẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Irarighọ, inyọghuo-mhẹ, awa mema ya ke ngeli abi ayẹmhẹ Ẹshinẹgba o gueyẹ awa. Awa khi ke ngeli abi o ghọle idiegbe olamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Irari khi, ini u wa ngeli abi idiegbe olamhẹ o gueyẹ, eri u ya ghu-a, ama ini u wa ngeli abi Ayẹmhẹ o gueyẹ, eri u wa gbe ekpabọ olamhẹ a shi idiegbe oyẹ, u la agbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ẹgbọ ni Ayẹmhẹ oyi Ẹshinẹgba ọ mhẹsẹ ẹ na imi Ẹshinẹgba e khi. ");
INSERT INTO atgNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Irari khi Ayẹmhẹ ni Ẹshinẹgba ọ rọ nẹ, ọa khi oni o gbolo rẹ khi oghumha ulishi, ama Ayẹmhẹ ni ọ rọ rẹ khi Ọmọ ọyọli u mie. Ọni Ayẹmhẹ ọ ri awa mhuẹ itoto ẹ viẹ lu Ẹshinẹgba, awa lu ọli Itamhẹ, Itamhẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ọni Ayẹmhẹ lọlighuo ọ pfi ọtsẹlẹ shi ayẹmhẹ oyawa khi eniyẹ eyi Ẹshinẹgba awa khi. ");
INSERT INTO atgNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ayẹmhẹ oyọli ọ zẹ ni awa lẹsẹ khi awa ya nu iKirisiti mhọli okemhi shi emini Ẹshinẹgba ọ rọ shobọ khi lọli ya riẹlẹ. Ẹghẹghẹ aghọ awa nu iJesu mhọli okemhi ufumhi oyọli ini awa li mẹ osoli. ");
INSERT INTO atgNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mhi mẹ ọli mẹ khi osoli ni awa a mẹ memena khi ọa khi oni a rọ khọkhọ emini a rọ ya khasẹ elemhi agbọ oyawa ikpukhokho. ");
INSERT INTO atgNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Irari khi eri emini Ẹshinẹgba ọ ma nya e ri ikphakpha-egbe migha khẹ ẹghẹghẹ ni Ẹshinẹgba ọ rọ ya ri eni e khi egbegbi imiọli khasẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Irari khi emini a ma nya, a rọ mele afuẹ-a, ni ọa khi ọghuẹmhẹ oyẹwẹ, ama abi o li ghọle ọni Ẹshinẹgba lọ, ni ọ rẹwẹ mele afuẹ-a, elemhi irudushi, ");
INSERT INTO atgNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","khi ọ ya tsumhi emini ọ ma nya ini e khi ke kẹ-a ali khi e ya nu imi Ẹshinẹgba kemhi ẹpfua ni o mhọli ufumhi. ");
INSERT INTO atgNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Awa lẹsẹ khi emini a ma nya e kiele ẹ lomhẹ memena e la ọtomhẹ, abi ọkpotso ni oku ọọ to. ");
INSERT INTO atgNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ọa khi emini a ma wẹwẹghuo tsẹ, ama li shi awa ni awa mie Ayẹmhẹ-nọ-pfuasẹ ni o khi igbaekẹle agbọ onogbọ oyi Ẹshinẹgba. Awa liẹ lomhẹ abi awa li ri ẹloe shi ekẹ ẹ khẹ ogbẹlẹ ni Ẹshinẹgba ọ ya la ukpẹloe ọgbọkpa guele khi imi Ẹshinẹgba awa khi ali ni a rọ ya pfa awa ikẹ-a shi ekẹ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Irari khi rọte irudushi ona a te mie awa pfuese. Eri-tsẹ khi irudushi ni aa mẹ gboo ọa fẹ khi irudushi. Ọghuo ọ gbo ri ẹloe shi ekẹ ẹ khẹ emini ọ she mẹ ẹloe ne? ");
INSERT INTO atgNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Eri-tsẹ khi ini awa ri udu shi emini awa aa mẹ ne, irabọmudu awa rọ ke ẹ khẹ ọli. ");
INSERT INTO atgNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ighọ Ayẹmhẹ ọ liẹ kpaghiẹ awa obọ umhagbapfo oyawa, Irari khi awa aa lẹsẹ abi a liẹ sọ iromhi, ọni Ayẹmhẹ lọlighuo ọ ri ilomhẹ ẹ sọ iromhi na awa shi emini unu ọa dobẹ ẹ ngme. ");
INSERT INTO atgNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ọni Ẹshinẹgba ni ọ́ọ́ mẹ elemhi udu oyi ẹgbọ, ọ́ lẹsẹ usamhi eyi Ayẹmhẹ. Irari khi eri ọni Ayẹmhẹ ọ sọ iromhi na ẹgbọ eyi Ẹshinẹgba abi o li de shi ọghuẹmhẹ oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Awa lẹsẹ khi eri Ẹshinẹgba ọ́ọ́ riẹlẹ emhi nya te odẹ onete na ẹgbọ ni ẹ nono ingme oyọli. Ẹgbọ ni o khia khi ọ lu shi omhẹsẹ oyọli. ");
INSERT INTO atgNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Eni Ẹshinẹgba ọ she kpẹ lẹsẹ, wẹwẹ ọ zẹ ọda kẹ ni e ya li abi Omi ọli, ni ọni Omi ọli ọ khi ọnododẹ elemhi inyọghuo ebubu. ");
INSERT INTO atgNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ighọ eni Ẹshinẹgba ọ zẹ ọda kẹ, wẹwẹ ọ li lu. Eni ọ lu, wẹwẹ ọ li pfa na, eni ọ pfa na wẹwẹ ọ li rọ khi eni e mhuẹ ufumhi onabi oyọli. ");
INSERT INTO atgNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Abi awa ke rọ mhuẹ ena shi udu oyawa, sẹ awa ke ya sọ shi ena mena? Ini Ẹshinẹgba ọ nu awa la, ọghuo o ya dobẹ mu okhuẹ vule shi awa ọ? ");
INSERT INTO atgNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Lọli ni ọa to ukphẹ Omi ọli na awa, ni ọ rọli luasobo na awa nya, sẹẹ ọa ya pfo udu gbo ri emhi nya ma ọni Omi ọli na awa? ");
INSERT INTO atgNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ọghuo ọ ya gue ingme shi ẹgbọ ni Ẹshinẹgba ọ she zẹ egbe? Ẹshinẹgba luẹghuo ọ pfa na ọgbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ọghuo ọ dobẹ pfa ẹzọ ọ mu ọgbọ? IJesu iKirisiti luẹghuo lọ, ọni ọ ghua. O gbo dọsẹ aghọ, Ọni a guise le bhale agbọ, mena ọ shitọ obọ ita oyi Ẹshinẹgba, ọ sọ iromhi ẹ na awa. ");
INSERT INTO atgNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ọghuo ọ ke dobẹ ya vasẹ awa rọte inono ni iKirisiti ọ nono awa lasele? Osoli abi khi ọmunu abi okhọli ni a mu vule shi awa ọ o ya dobẹ? Abi khi okiamhi abi khi umha mẹ sọ lọ, abi khi ini i igbe-a tsekha deba lọ? ");
INSERT INTO atgNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Abi a li kẹkẹ ọli shi ebe-no-pfuasẹ, khi, “Itobọ oyẹẹ anye rọ la okhẹna eghuli ẹlẹkpa, a ri anye khọkhọ isumha ni a ya gbolo a.” ");
INSERT INTO atgNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Iiye, abi a riẹ mẹ eni emhi enana nya, anye fu dọsẹ ọni ọ khọli mu ọ le, rọte obọ oyi ọni ọ nono ingme oyanye. ");
INSERT INTO atgNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Irari khi mhi mẹ ọli mẹ khi emhikhọghuo ọa la agbọ ona, eghuli wẹkhi agbọ ilala, wẹkhi igẹni wẹkhi iyẹmhẹ ọkphaghiẹ ali emini e la irarogbe ẹ mhẹsẹ shi agbọ ni awa la memena okekhi agbọ ni o ke ẹ bhale wẹkhi ekpabọ, ");
INSERT INTO atgNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wẹkhi iyagha ali ilimhi, wẹkhi emhikhọghuo ni a ma, o dobẹ ya vasẹ awa rọte inono ni Ẹshinẹgba ọ nono awa rọte iJesu ọyawa lasele. ");
INSERT INTO atgNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Egbegbi ingme mhia ngme itobọ khi ọnayi iKirisiti mhi khi. Ọa khi ẹgbhọli mhia lo. Udu oyẹmhẹ o pfi ọtsẹlẹ shi ọ elemhi Ayẹmhẹ-nọ-pfuasẹ, ");
INSERT INTO atgNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ini mhiẹ khi mhi mhọli oya ali udu ialamhẹ ni ọa mhuẹ ukpẹsẹ, ");
INSERT INTO atgNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","na ẹgbọ eyẹmhẹ ni anye khi ẹgbọ eghuo ali ọlia eghuo. Itobọ oyẹwẹ, eri mhia liẹ khi Ẹshinẹgba ọ kha pfi unu na mhẹ ali khi a kha rue mhẹ ikugbe ni mhi kugbe iKirisiti ọ le, ini lọli rẹwẹ mhọli imiepfuese. ");
INSERT INTO atgNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Wẹwẹ e khi imimi iZirẹni ni Ẹshinẹgba ọ zẹ, ni ọ rọ khi imi ọli, ọ ri ufumhi oyọli khasẹ wẹ, ọ nu wẹ riẹlẹ ilama kugbe, ọ ri ushi oyọli na wẹ. Wẹwẹ e mhọli egbegbi ugamhi, e she mie ishobọ oyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Wẹwẹ e mhọli eni egbhali ena ẹlẹlẹ ni a suọ eko, ni e gba ushishi Iburu ekẹ le. Wẹwẹ e li khi itita iKirisiti. Ẹshinẹgba ni ọọ mhẹsẹ na emhikpa, ọ khi ọni áá kuẹghiẹ agbọagbọ. ");
INSERT INTO atgNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Mhi aa liẹ khi ishobọ ni Ẹshinẹgba ọ shi, khi, o fia kua. Irari khi ọa khi ẹgbọ ni e rọte iZirẹni lasele nya, e khi ẹgbọ eyi Ẹshinẹgba. ");
INSERT INTO atgNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Wẹkhi imimi Aburaamu nya e khi egbegbi imi Aburaamu. Ẹshinẹgba ọ gueyẹ Aburaamu khi, “Imimi Aziki a ya leli shi eni u bia.” ");
INSERT INTO atgNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Onana o guele khi eniyẹ ni ọ bia elemhi ọghuẹmhẹ idiegbe nya ẹa khi imi Ẹshinẹgba. Ama eniyẹ ni a bia rọte ishobọ onayi Ẹshinẹgba wẹwẹ a leli shi egbegbi imimi Aburaamu. ");
INSERT INTO atgNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Irari khi ishobọ onayi Ẹshinẹgba khi, “Ẹghẹghẹ ni ọ rọshi ekẹ o kha da ramhi ne, mhi ya ri ishobọ oyẹmhẹ tsẹ, iSera ọ bia ọmọ ọmọse.” ");
INSERT INTO atgNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ọa pfo ghọ. Irari khi itsema emọse eyi iRebeka, ita ọghuo ọ bia wẹ ikhi Aziki itita awa. ");
INSERT INTO atgNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Ọgbọ a bia itsema ena ne wẹkhi eri e lẹsẹ ingme e riẹlẹ onete ali onobe ne, ni Ẹshinẹgba ọ rọ she gueyẹ inyẹwẹ iRebeka khi, “Ọnọgbhali ọ ya ke ga ọnikeke.” Eri Ẹshinẹgba ọ riẹlẹ ona rọkhasẹ khi, uzẹmhi ni lọli ẹ zẹ ọgbọ ni ọ khi emini ọ ya khi elemhi agbọ, khi ọa khi itobọ akanya ni ọ gbe ama abi o ghọle Ẹshinẹgba ọ li lu ọli. ");
INSERT INTO atgNT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Abi Ebe-no-pfuasẹ o ngme ni ọọ, “IGiekọpu mhi nono dọsẹ iSọ.” ");
INSERT INTO atgNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Sẹ awa kẹ ngme mena? Khi Ẹshinẹgba ọọ zọlọ? Iiye o, ọa khi ighọ kpa! ");
INSERT INTO atgNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Irari khi ọ gueyẹ iMosisi ọọ li, “Mhi ya mhọli ilẹlemhi na ọni mhi ya mhọli ilẹlemhi na, mhi viẹ osue na ọni mhi ya viẹ osue na.” ");
INSERT INTO atgNT_v