﻿USE sofia;
DROP TABLE IF EXISTS sofia.atbNT_vpl;
CREATE TABLE atbNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES atbNT_vpl WRITE;
INSERT INTO atbNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham é awut ashín, Dawiq é yhangzo yhangshu, Yesuq Hkrisduq é byùxik labaû gi, a-ô mâ é eq rajung za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham gi, Isak lé hkû; Isak gi, Yakup lé hkû; Yakup gi, Yudaq eq yhanggu yhangmâng pé lé hku é nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaq gi, Hparet eq Zera lé hkû, haú nhik é yhângnu gi, Tamar nghut ri. Hparet gi, Hesrun lé hkû; Hesrun gi, Ram lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram gi, Aminada lé hkû; Aminada gi, Nashon lé hkû; Nashon gi, Salamun lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamun gi, Buaq lé hkû; Buaq é yhângnu gi, Rahap nghut ri. Buaq gi, Obet lé hkû; Obet é yhângnu gi, Ruhtaq nghut ri. Obet gi, Yese lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese gi, Hkohkâm Dawiq lé hkû; Dawiq gi, Sholumon lé hkû; Sholumon é yhângnu gi, Uriaq yhangmyi dut wú sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sholumon gi, Rehoboam lé hkû; Rehoboam gi, Abiyaq lé hkû; Abiyaq gi, Asa lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gi, Yehoshaphat lé hkû; Yehoshaphat gi, Yoram lé hkû; Yoram gi, Uzi-aq lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzi-aq gi, Yohtam lé hkû; Yohtam gi, Ahaza lé hkû; Ahaza gi, Hezekiaq lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiaq gi, Manase lé hkû; Manase gi, Amon lé hkû; Amon gi, Yosiaq lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiaq gi, Babelon má shúm dut huî é hkûn, Yehkoniaq eq yhanggu yhangmâng pé lé hku é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babelon má shúm dut huî é htâng má, Yehkoniaq gi, Shalahtila lé hkû; Shalahtila gi, Zerubabelaq lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabelaq gi, Abiut lé hkû; Abiut gi, Eliakim lé hkû; Eliakim gi, Azor lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor gi, Zaduk lé hkû; Zaduk gi, Ahkim lé hkû; Ahkim gi, Eliut lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut gi, Eliaza lé hkû; Eliaza gi, Mahtan lé hkû; Mahtan gi, Yakup lé hkû; ");
INSERT INTO atbNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakup gi, Mariq é yhanglâng Yosep lé hku é nghut ri; Mariq gi, Hkrisduq gâ é Yesuq lé hku é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Haû mù, Abraham é pyat mai Dawiq é pyat jé shoq gi, byùxik raxe myi xik; Dawiq pyat mai Babelon má shúm dut huî é hkûn jé shoq gi, byùxik raxe myi xik; shúm dut huî é hkûn mai Hkrisduq é pyat jé shoq gi, byùxik raxe myi xik nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesuq Hkrisduq hku lé lo é hkyô gi, a-ô mâ é eq rajung za nghut ri: Yesuq é yhângnu Mariq gi, Yosep èq dûng tô é sû nghut ri; nghut kôlhang, yhangnhik a zùm shi má, yhang gi, Chyoiyúng Woi-nyí mai zogûng dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yhâng é yhumsîng hpó Yosep gi, dingmán sû nghut luî, yhang lé byu pê hí má hoq a kâm lhoq hpu nau é yanmai, tsik za lhoq kâng pyám râ dâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nghut kôlhang, yhang haû su myit nyi é hkûn, yhupmoq má, haû Yhumsing é maumang lagyo gi, yhang lé, lé htoq shit luî, \"Dawiq é yhangzo yhangshu Yosep ê, haû náng é yhumsîng myhí Mariq lé hâng yù râ hkyô lé, hkâ-myit chiq; haî mù gâ le, yhang wun tô é zoshâng gùng gi, Chyoiyúng Woi-nyí dông lo é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yhang gi, yuqzo rayuq hkû râ nghut luî, nàng gi, zoshâng haú lé, Yesuq nghû myìng myhíng byi ra râ nghut lhê; hkâsu mù gâ le, Yhang gi, Yhâng é byu pé lé, yhangmoq é yubak mara mai hkyi yù râ sû nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Shí hkyô banshoq gi, Garai Gasâng èq, haû myiqhtoi dông taî é dang lé lhoq dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Myiqhtoi dang haû gi, \"Haû zomyi gyíng gi, zogûng dut luî, yuqzo rayuq hkû râ nghut lhê; Yhâng é myìng lé gi, Emanuelaq ga kó râ nghut lhê.\" gâ ri. Hau é lichyúm gi, \"Garai Gasang gi, nga-nhúng eq rahá nghut nyi lhê.\" gâ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosep gi, yhup bûn lo é hkûn, haû Yhumsing é maumang lagyo taî é eq rajung za, Mariq lé, yhangmyi dông yhûm má shuî yù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nghut kôlhang, yhang gi, yuqzo haû hku é hkûn jé shoq, Mariq eq gungsho a zùm nghut ri. Yuqzo haú lé, yhang gi, Yesuq ga myhíng byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herut hkohkâm up nyi é u lé, Yuda mau mâ é Betlehem wà má Yesuq lé hku é nghut ri. Hau htâng, buihtoq hkyam mâ é hpaqchyî bò bang gi, Yerusalem wà mó má jé lé kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","\"Haû hku lé lô bê Yudaq byu pê é Hkohkâm gi, hkâmá nghut lhê lhú? Yhâng é kyî lé, buihtoq hkyam má ngamoq myàng luî, Yhang lé noq râ matú jé lé é nghut lhê.\" ga luî, myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herut hkohkâm gi, haú hkyô lé wó gyo jáng myit myô nyi ri; hau htoq agó, Yerusalem wà mó mâ é lhunglhâng bang le, myit myô bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Haû mù luî, yhang gi, byu pê é hkyangjong agyi pé eq tarâ sará pé banshoq lé, ji tsîng yù mù, haû Hkrisduq hkâmá hku lé lô râ nghut é hkyô lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Haú hkûn, yhangmoq gi, \"Yuda mau Betlehem wà má nghut lhê. Hkâsu mù gâ le, shí hkyô eq séng luî, haû myiqhtoi kâ tô é má, ");
INSERT INTO atbNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Yudaq mau mâ é Betlehem wà ê, nàng gi, Yudaq mau mâ é wà pé má, je tiq sû a nghut; hkâsu mù gâ le, ngá é Israelaq byu pé lé upzúng râ Zau gi, náng chyáng mai htoq lô râ nghut lhê.' ga bo tô ri.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hau htâng, Herut gi, haû hpaqchyî bò bang lé haq ji yù mù, kyî lé htoq shit é ahkyíng lé, yhangmoq chyáng mai hkyak wó myî sê yù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Haû mù, yhang gi, \"Nungmoq, zoshâng haú lé rago ê ho wú keq. Ngò le, Yhang lé ê wó noq râ matú, Yhang lé nungmoq ê myâng eq yhang, ngo lé lo shit kyo keq.\" ga taí luî, haú bang lé Betlehem wà shut nhang kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yhangmoq gi, haû hkohkam é dang lé gyô yu é htâng má, htoq e ló bekô nghut ri. Haû buihtoq hkyam má yhangmoq myang é kyî gi, haû zonú nyi é ahtoq ang ang má ló nô é jé shoq, yhangmoq é hí má e ló byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Yhangmoq gi, kyî haú lé myàng jáng, gyai yhang gabú bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yhangmoq gi, haú yhûm má wang e ló kô é hkûn, zonú eq yhângnu Mariq lé myàng kômù, hkyihput htuq luî, haû zonú lé noqkuq akô; hau htâng, yhangmoq é sutdek pé lé le hpóng luî, hîng, namngón jung loban eq mura pé lé yù mù, Yhang lé chyunghuq byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yhangmoq gi, Herut chyáng a dum taû ló râ matú, yhupmoq má, yhangmoq lé sidiq byî é hui kômù, hkyô gó hkat dông yhangmoq é mau shut taû ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yhangmoq ló byuq é htâng má, haû Yhumsing é maumang lagyo rayuq gi, Yosep lé yhupmoq má htoq shit mù, \"Toq aq! Haû zoshâng eq yhângnu lé, Egutuq ming shut shuî hpang ê aq. Ngò, nang lé dum ji yu é ahkyíng jé shoq, haú má nyi nyì keq. Haî mù gâ le, Herut gi, zoshâng haú lé sat râ matú, ho nyì bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Haû mù, yhang gi, toq luî, myín lé yhang, zôshang me lé shuî chûng mù, Egutuq ming shut e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yhangmoq gi, Herut shi é jé shoq, haú má nyi nyi akô. Haû gi, \"Ngá zo lé, ngò, Egutuq ming mai wut htoq yû bê nghut lhê.\" ga, haû Yhumsing èq myiqhtoi dông taî é dang lé lhoq dik é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herut gi, yhang lé, hpaqchyî bò bâng èq mhaû pyâm tô é lé sé jáng, nhikmo-yo bê nghut ri; haû mù, yhang gi, haû hpaqchyî bò bâng chyáng mai wó sê yu é ahkyíng lé sôn wú mù, Betlehem wà eq hau é awui ayàm mâ é wà pé má nyi é, í zân mai a-ô mâ é yuqzo pé banshoq lé, sat pyám nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Haû gi, \"Ramaq gâ é jowò má, yón kuq é eq ngau garû é htê lé wó gyô ri; Rahkelaq gi, yhang zô pé a nyi byuq lo kô é yanmai, ngau nyi é eq nhik a wó tíng dut ri.\" ga luî, ");
INSERT INTO atbNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","myiqhtoi Yeremiaq dông taî tô é dang lé lhoq dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herut shi byuq é htâng, Egutuq ming má, haû Yhumsing é maumang lagyo gi, Yosep chyáng yhupmoq dông lé htoq shit mù, ");
INSERT INTO atbNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","\"Toq aq, haû zôshang me lé shuî chûng mù, Israelaq ming má taû ló aq; hkâsu mù gâ le, haû zoshâng lé sat naû bang shi byuq bekô nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Haû mù, Yosep gi, zôshang me lé shuî chûng mù, Israelaq ming shut taû ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nghut kôlhang, yhang gi, Yuda mau má, Arhkela-uq, yhângwa Herut é hkó má xoq up nyi é hkyô lé wó gyo jáng, haú má a wám ló lo nghut ri. Yhupmoq má sidiq byî é huî é eq rajung za, yhang gi, Galile mau shut e ló mù, ");
INSERT INTO atbNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret gâ é wà má ló nyi nyì bê nghut ri. Haû mù, \"Yhang lé, Nazaret wà byù ga râ nghut lhê.\" ga luî, haû myiqhtoî pé dông taî tô é dang lé lhoq dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Haú yoq má, Wui-myhup Sará Yohan htoq lô mù, Yuda mau mâ é yoso má hko kyô é gi, ");
INSERT INTO atbNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","\"Myit lhîng keq; hkâsu mù gâ le, mauhkûng mingdán gi, chyâng lò bê nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Haú yuq gi, \"Haû yoso má, byù rayuq garû taî é htê gi, 'Haû Yhumsing é matú, hkyô hen to keq; Yhâng é matú, hkyô lhoq nyhang to keq.' gâ ri.\" ga myiqhtoi Esai-aq taî tô é sû yuq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohan gi, gola-uq shomaú èq saî é mebu wut mù, yhâng é hpyidum má gi, shokuq hpyihit hit ri. Yhâng é zoshuq gi, dinggám eq yosô byo-î pé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yerusalem wà mó mâ é bang, Yuda mau banshoq mâ é bang eq Yodan làng awui ayàm lhunglháng mâ é bang gi, yhâng chyáng htoq e bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yhangmoq gi, yhumsing é mara lé yín yû kôluî, yhâng chyáng mai Yodan làng má wui-myhup hkâm yu bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nghut kôlhang, yhang gi, yhang wui-myhup hkám byî é jang má, Hparishe pé eq Saduke pé myo myo lé lo nyì kô é lé myàng jáng, yhangmoq lé taî é gi, \"Duq htân lhangmuì amyû pé ê, jé lô râ yubak dam mai wó hpang lut kó sháng gaq ga, nungmoq lé ó yuq taî pûn é lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Myit lhîng hkyô eq gingdán é ashi pé zui keq. ");
INSERT INTO atbNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Ngamoq gi, Abraham é yhangzo yhangshû pé nghut lhê.' nghû luî, yhumsing é i-myit unghkaû má hkâlum to kó. Hkâsu mù gâ le, ngò, nungmoq lé taî kyo kôlé, Garai Gasang gi, luqgok shí pé mai, Abraham é matú yhangzô pé wó hpan htoq kat lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ahkuî lháng, Garai Gasang gi, Yhâng é wazung lé haû sikgâm wang pé má tô to bê nghut ri; haû mù, ge é ashi a zuî é agàm hkangmó lé gi, htuq lhêng pyám mù, myi má dú kat pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngò gi, nungmoq myit lhîng kó sháng gaq nghû, wui èq za wui-myhup hkám byî lhê. Nghut kôlhang, ngá htoq má wum-o a-tsam je bo é sû rayuq, ngá htâng má jé lé lô shirâ nghut luî, ngò gi, Yhâng é hkyî-tsung chûng byi râ lháng a gingdán; Yhang gi, Chyoiyúng Woi-nyí má le, myi má le, nungmoq lé wui-myhup hkám byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yhang gi, loq má byò chung to mù, guq chyarâng mâ é guq bùm lé hik sân pyám luî, já é guq cham lé gi, guqchyî má tsîng kat to mù, guqsôm lé kúm gi, hkâ-nhám le shi byuq a sê é myî èq nyhê hkyô pyám râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Haú hkûn, Yesuq gi, Yohan chyáng wui-myhup hkâm yù râ ga, Galile mau mai Yodan làng má jé lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nghut kôlhang, Yohan gi, \"Ngò sheq Náng chyáng wui-myhup hkâm yù râ sû ru nghut lhê nhîng! Nàng sheq ngá chyáng lé lo lhê lhú?\" ga luî, lhom taî hkûm ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Haú hkûn, Yesuq gi, \"Dingmán hkyô banshoq lé, nga-nhúng lhoq dik râ é yanmai, Ngo lé wui-myhup hkám byi laq.\" ga tû taî ri. Haû mù, Yohan le, gyo byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesuq gi, wui-myhup hkâm yù eq yhang, wuì mai htoq lo ri. Haú hkûn, mauhkûng bóng lô mù, Garai Gasâng é Woi-nyí gi, hpûngkyui gunghkyâng sû é dông mai, Yhâng ahtoq má lé gyó nô tô é lé, Yhang myang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Haú hkûn, \"Shí yuq gi, Ngò chyitdap é Ngá zo nghut lhê; Yhâng é ahtoq má Ngò gabú myit ngón nyi lhê.\" ga mauhkûng mai danghtê htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hau htâng má, Chyoiyúng Woi-nyí gi, Yesuq lé, nat Tsadán èq gunglaú é hui nhâng râ matú, yoso shut shuî ê ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesuq gi, zoshuq gám é myi xê nyí myi xê myìn jé jáng, zòmut hui bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Haú hkûn, gunglaú sû gi, Yhâng chyáng lé mù, \"Nàng, Garai Gasâng é Yhangzo nghut le gi, luqgok shí pé lé muk dut nhâng aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Haû jáng, Yesuq gi, \"'Byù gi, muk èq za asak duì râ a nghut; Garai Gasâng é nhut mai htoq lo é mungdang hkangmó èq sheq asak duì râ nghut lhê.' ga luî, Chyúmdang má kâ tô ri.\" ga yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Haú hkûn, nat Tsadán gi, Yesuq lé, chyoiyúng myuq má shuî ê mù, noqkuq yhum je myhang é shûhtâng htoq má yap nhang to luî, ");
INSERT INTO atbNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","\"Nàng, Garai Gasâng é Yhangzo nghut le gi, byam gyó kat wú aq. Hkâsu mù gâ le, 'Náng é matú, Garai Gasang gi, Yhâng é maumang lagyô pé lé taî to râ nghut mù, luqgok má Náng é hkyî a ló htung shoq, yhangmoq é loq èq Nang lé lhom bún yû kó râ nghut lhê.' ga luî, Chyúmdang má kâ tô ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nghut kôlhang, Yesuq gi, \"'Haû Yhumsîng, nungmoq é Garai Gasang lé, wó chyam wú râ a nghut.' ga luî le, Chyúmdang má kâ tô ri.\" ga, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nat Tsadán gi, Yesuq lé, gyai yhang myhang é bùm htoq má shuî doq ló mù, mingkan má joq é mingdán pé banshoq eq haú pê é hkikhkâm hkyô lé tûn shit ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hau htâng, yhang gi, \"Nàng hkyihput htuq mù, ngo lé noq é nghut jáng, shí pé banshoq, Nang lé ngò byi râ.\" ga, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Haú hkûn, Yesuq gi, \"Tsadán nàng, ló byuq aq! Hkâsu mù gâ le, 'Haû Yhumsîng náng é Garai Gasang lé za, nàng noqkuq dojaú ra râ nghut lhê.' ga luî, Chyúmdang má kâ tô ri.\" ga, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Haû mù, nat Tsadán gi, ló byuq bê nghut luî, maumang lagyô pé gi, Yesuq lé, lé dojaú nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesuq gi, Wui-myhup Sará Yohan htóng gyó é hkyô lé wó gyo jáng, Galile mau shut dum taû ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yhang gi, Nazaret wà mai htoq ló mù, Zebulun eq Nahtali mau mâ é nhông yàm má joq é Kaperna-um wà má ló nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Haû gi, myiqhtoi Esai-aq laiká má, ");
INSERT INTO atbNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","\"Zebulun mau eq Nahtali mau, wuimau mâ é hkyô, Yodan làng yàm, tûngbaù pé nyi é Galile mau ê, ");
INSERT INTO atbNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mauchut hkaû má nyi nyi é bang, maubó mó lé myàng bê nghut ri; shî wup hkaû má nyi to bâng é matú, maubó lô bê nghut ri.\" ga kâ tô é dang lé lhoq dik râ matú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Haú hkûn mai, Yesuq gi, \"Myit lhîng keq! Mauhkûng mingdán gi, chyâng lò bê nghut ri.\" ga, mungdang hko hi e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuq gi, Galile nhông yàm má hkyô sô wún é hkûn, Petruq gâ é Simun eq yhanggu Andre nhiktâng lé myang ri. Yhangnhik tâng gi, ngozo kóng zo su nhik nghut mù luî, nhông má gùn dú nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Haû mù, Yhang gi, haú nhiktâng lé, \"Ngá htâng cháng keq; Ngò, nungnhik lé, byù lé châng kóng su nhik dut nhâng râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Haú hkûn, yhangnhik gi, radá dâm, gùn pé lé tô pyâm to luî, Yhang htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuq gi, jowò haú mai xoq sô e ló le, Zebedi é yhangzo, Yakuq eq yhanggu Yohan nhiktâng lé myang ri. Yhangnhik gi, yhangnhik é yhângwa Zebedi eq rahá, lhaî hkaû má gùn hpo nyi akô. Yhangnhik lé, Yesuq wut kat jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yhangnhik gi, radá dâm, yhangnhik é yhângwa eq lhaî haú lé, tô pyâm to kôluî Yesuq htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuq gi, Galile mau ramau gón má htoq ê mù, tarajong pé má, mhoqshit luî, mauhkûng mingdán eq sêng é gabú danglù lé, hko kyo uchyang, byu pê chyáng mâ é nòhpyo ajung jung hui bang eq nolì nojàng amyû myû dap bang lé, lhoq gê byî wún ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesuq eq sêng é hkyô ludang gi, Suriq ramau gón má byo myín ló mù, byu pé gi, awáng nòhpyo ajung jung huî é bang, hkê-nhô jamjaû nyi é bang, nat gang wang júng é bang, mhûngtuq tuq é bang, gùngjum shi é bang lé, shuî lé lô kôluî, Yhang gi, haú bang lé lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galile mau, Dekapoli, Yerusalem, Yuda mau eq, Yodan làng tû tap mâ é byù moq mó gi, Yesuq htâng châng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuq gi, byù moq mó lé myàng jáng, bùm má doq ló luî, ló zung tô ri. Haú hkûn, Yhâng é chángzô pé gi, Yhâng chyáng lé lô kôjáng, ");
INSERT INTO atbNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yhang nhut hkum hpóng luî, yhangmoq lé mhoqshit é gi: ");
INSERT INTO atbNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","\"Woi-nyí má, asho awui dut é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, mauhkûng mingdán gi, yhangmoq é mingdán nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Myit iyon huî é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, yhangmoq gi, nhik lhoq tîng é hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","I-myit nú-nhâm é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, yhangmoq gi, mingkan lé wó sîng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dingmán hkyô lé mut shit nyi é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, yhangmoq gi, nhik dik shoq myàng zo kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Shogyo nhikmyin myit bo é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, yhangmoq gi, shogyo nhikmyîn yu é hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Myit sansêng é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, yhangmoq gi, Garai Gasang lé myàng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nguingón hkyô sô xoq byî é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, yhangmoq gi, Garai Gasâng é yhangzô pé gâ é hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dingmán hkyo é yanmai zing-ri huî é bang gi, hkungsô wó nyi ri; hkâsu mù gâ le, mauhkûng mingdán gi, yhangmoq é nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ngá é yanmai, byu pê èq, nungmoq lé rhoi é, zing-rî é, a teng a mán é dông agè ashop é dang amyû myû taí tso kô é hkûn, nungmoq hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nguingón gabú nyî keq, hkâsu mù gâ le, nungmoq é matú kô é chyunghuq gi, mauhkûng mingdán má joq tô ri. Nungmoq é hí lhê é myiqhtoî pé lé le, yhangmoq gi, haú dông zing-rî laî lo wú bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nungmoq gi, myidàm htoq mâ é xo nghut nyi lhê. Nghut kôlhang, xo gi, màn kân byuq jáng, haú lé hai èq dum wó lhoq ngam yù râ lhú? Shinggan shut dú pyám mù, byu pê èq nâng pyeq pyâm é mai lai luî, hai akyû le bò râ a nghut lo. ");
INSERT INTO atbNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nungmoq gi, mingkân é maubó nghut akô; bùm htoq mâ é myuq lé gi, wó nghop to râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Myibung lé tap mù, mûng èq nghop tô é ó a kut wú kó; haû su kut râ malaî, yhúmhkaû má lúng tô é bang yuq hkangmó myoq wó myâng râ matú, tsungjang má kúm tsung to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Haû eq rajung za, byu pé gi, nungmoq é ge é muzó pé lé byu-myàng luî, mauhkûng htoq mâ é nungmoq é Îwa lé hkya-on kó sháng gaq, nungmoq é maubó lé yhangmoq é hí má duq nhang to keq. ");
INSERT INTO atbNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ngò gi, myiqhtoî pê é dang eq jep é tarâ lé lhoq hpyoq pyám râ matú, jé lé é nghut nhô hkâ-ngâm kó; haú pé lé lhoq dik râ matú sheq jé lé é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngò, nungmoq lé teng za taí kôlé, mauhkûng eq myigùng byuq byuq le lháng, haú pé a ban lhoq dik dik gi, jep é tarâ mâ é tiq dik é dangjí eq myihkyet zo ralhum lháng byuq byuq râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jep é tarâ shí pé mâ é tiq dik é dang rahkun lé lu lai luî, góbang lé le, haú su kut râ matú mhoq byî é sû ó yuq nghut kôle, mauhkûng mingdán má tiq dik sû gâ é hui râ nghut lhê; nghut kôlhang, jep é tarâ shí pé lé châng kut luî, mhoq byi sû kúm gi, mauhkûng mingdán má, hkik sû gâ é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngò, nungmoq lé taí kôlé, nungmoq dingmán é hkyô má, haû Hparishe pé eq tarâ sará pé dingmán é htoq je a gyaú le gi, mauhkûng mingdán má, nungmoq wó wâng kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","'Byù hkâsat, sat é sû gi, jéyáng é hui râ nghut lhê' ga, hí hpyang lhê é bang lé taî tô é dang, nungmoq wó gyô wú bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nghut kôlhang, Ngò, nungmoq lé taí kôlé, gumang rayuq yuq lé nhikjum yô é sû gi, jéyáng é hui râ nghut lhê. Hau htoq agó, gumang hpó lé, 'Byù gang' ga taî é sû gi, Yudaq byìn tú wapdoq má jéyáng é hui râ nghut lhê; 'Byù bam ê' ga wut é sû gi, ngaraî myi eq gingdán nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Haû mù, hkungga gyap má, nàng hkungga nhông râ dâ é hkûn, náng é gumang rayuq yuq, nang lé mara hun é hkyô rajung jung joq é lé, myit bûn kat é nghut jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","náng é hkungga lé, haû hkungga gyap hí má tô pyâm to mù, náng é gumang hpó haú yuq eq hí nguingón hkyô ló yû luî sheq, hkungga lé nhông byi aq. ");
INSERT INTO atbNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nang lé yui tsuq sû gi, nang lé tarâ rûng má dé e ló é hkûn, hkyô má ru nghut nyi ashî u lé, yhang eq nguingón hkyô hí hân yù aq. Haû a nghut jáng, haú yuq gi, nang lé, tarâ agyi chyáng ê ap pyám mù, haû tarâ agyì gi, nang lé htóng hkyô pyám râ matú, htóng suwún hpô é loq má ap pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngò, nang lé teng za taí lé, yuichyîn haû a ban xap xap gi, htóng haú mai nàng wó htoq ló râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","'Su-myi sulàng hkâlú' gâ é dang lé, nungmoq wó gyo wú bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nghut kôle, Ngò, nungmoq lé taí kôlé, myiwe rayuq lé shut nau é myit èq wú é sû gi, yhâng é myit hkaû má, myiwe haú yuq eq su-myi sulàng lú hkyô kut é sû nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Haû mù, náng é loqyo myoq èq, nang lé mara kut shut nhang é nghut le gi, haú lé lap choq yû mù, dú pyám aq. Hkâsu mù gâ le, náng é ragùngdu gón ngaraî ming gyó râ htoq má, náng é gungsho rajung jung za htên byuq é nghut le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Haû eq rajung za, náng é loqyo loq èq, nang lé mara kut shut nhang é nghut le gi, haú lé hpyit yû mù, dú pyám aq. Hkâsu mù gâ le, náng é ragùngdu gón ngaraî ming gyó râ htoq má, náng é gungsho rajung jung za htên byuq é nghut le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","'Yhumsing é yhangmyi lé kâng é sû gi, lhoq kang laiká byi râ dut lhê.' gâ é dang joq lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nghut kôlhang, Ngò, nungmoq lé taí kôlé, myiwe dông mai làng shut é a nghut é za, yhumsing é yhangmyi lé kâng é sû gi, myiwe haú lé sulàng lú sû dut nhâng bê nghut ri; hau htoq agó, yhumsing yhanglâng eq gang bê myiwe lé hâng yu é sû le, su-myi lú é sû dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hau htoq agó, 'Danggidiq a zùng hkâmû; Yhumsîng lé byî tô é danggidiq eq rajung za cháng aq.' ga luî, hí hpyang lhê é bang lé, taî tô é dang lé nungmoq wó gyô wú bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nghut kôlhang, Ngò, nungmoq lé taí kôlé, hai èq le hkâdakâm kó: mauhkûng lé lang luî le, hkâdakâm kó; hkâsu mù gâ le, haû gi, Garai Gasâng é zùng tanghkuq nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","myigùng lé lang luî le, hkâdakâm kó; hkâsu mù gâ le, haû gi, Garaî é hkyî nang jang nghut lhê; Yerusalem lé lang luî le, hkâdakâm kó; hkâsu mù gâ le, haû gi, Hkohkâm mó é myuq nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hau htoq agó, yhumsing é ulhûm èq le, hkâdakâm kó; hkâsu mù gâ le, xâm rahkat lé lháng hpyû shoq noq shoq, nàng wó kut é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Náng é dang lé, 'nghut lhê' lé gi, 'nghut lhê' nghû, 'a nghut é' lé gi, 'a nghut' nghû, taí aq; haû mai laî é gi, haû agè ashop su chyáng mâ é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","'Myoqjí matú myoqjí xap, zui matú zuì xap' gâ é dang lé, nungmoq wó gyô wú bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nghut kôlhang, Ngò, nungmoq lé taí kôlé, agè ashop kut é sû lé lató hkâhpuq. Náng é loqyo bowâm má pyuq byi sû lé, loqpaî hkyam le hkâm byi shi aq. ");
INSERT INTO atbNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Byù rayuq yuq, nang lé mara tsuq mù, náng é buzo lé yu pyám byî é nghut jáng, bumó lé le, hkyut byi shi aq. ");
INSERT INTO atbNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Byù rayuq yuq, nang lé zik mù, radéng ê nhâng jáng, yhang eq rahá í déng châng ê byi aq. ");
INSERT INTO atbNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nang lé dung sû lé, byi aq; náng chyáng mai chyi naû sû lé le, nunghtáng hkâlhik pyám. ");
INSERT INTO atbNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","'Náng é chyangnâm mâ é bang lé gi, chyitdap mù, náng é gyè lé gi, a jú kut aq' gâ é dang lé, nungmoq wó gyô wú bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nghut kôlhang, Ngò, nungmoq lé taí kôlé, nungmoq gi, mauhkûng htoq mâ é nungmoq é Îwâ é yhangzô pé wó dut kó sháng gaq, nungmoq é gye pé lé chyitdap mù, nungmoq lé zing-ri bâng é matú kyûdung byi keq; ");
INSERT INTO atbNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","hkâsu mù gâ le, Yhang gi, agè ashop bâng é ahtoq má le, gè bâng é ahtoq má le, buì tsô byi nhâng mù, dingmán bâng é ahtoq má le, a dingmán bâng é ahtoq má le, mau wô byi nhâng Sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nungmoq lé chyitdap é bang lé za chyitdap kô le gi, nungmoq é matú hai chyunghuq wó kó râ lhú? Kang guq bang lháng, haû su kut lhê a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hau htoq agó, nungmoq é gumang wuì lé za shi-kyám kô le gi, nungmoq kut é muzó gi, góbâng htoq má haî wá laklaí râ lhú? Tûngbaù pé lháng haû su kut lhê a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Haû mù, mauhkûng htoq mâ é nungmoq é Îwa gumjup é su, nungmoq le gumjup nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nungmoq dingmán é hkyô lé, byu pé myàng sháng gaq nghû, byu pê hí má a kut shit loshoq, sidiq nyì keq. Haû su kut é nghut jáng, mauhkûng htoq mâ é nungmoq é Îwâ chyáng mai, chyunghuq wó yû kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Haû mù, haû gegùn labyoq kut bang gi, byu pê èq shigyaú é hui sháng gaq ga, tarajong pé hká, hkyô pé hká kut é su, nàng gi, alu byî é hkûn, tut htê su hkâlhoq htoq. Ngò, nungmoq lé teng za taí kôlé, haú bang gi, yhangmoq é chyunghuq lé hkúm shoq wó yû bekô nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ra châ to bang lé nàng alu byî é hkûn, náng é loqyo loq kut é hkyô lé, loqpaî loq lé lháng hkâsé nhâng. ");
INSERT INTO atbNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Haú hkûn, nàng alu byî é lé, ó a châng sé râ nghut lhê. Haû jáng sheq, ó a sé loshoq kut é hkyô lé myang é sû, náng é Îwa gi, nang lé chyunghuq shigyaú râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nungmoq kyûdûng le, gegùn labyoq kut bang su hkâkut kó; hkâsu mù gâ le, yhangmoq gi, byu pé byu-myàng shoq ga, tarajong pé eq hkyô kang pé má yap mù, kyûdung râ ô nau akô. Ngò, nungmoq lé teng za taí kôlé, haú bang gi, yhangmoq é chyunghuq lé wó yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nghut kôlhang, nàng kyûdûng le, náng é gok hkaû má wang ló mù, hkum myhî pyám luî, a byu-myang é náng é Îwâ chyáng dung aq. Haû jáng, ó a byu-myang é lé myàng sû, náng é Îwa gi, nang lé jeju dum tau byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Haû mù, kyûdûng le, tûngbaù pé su kut luî, dang puq hkâhtau kó; hkâsu mù gâ le, yhangmoq gi, dang hîng chín luî dung jáng sheq, gyo byi nhô ngam akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Haú bang su hkâkut kó; hkâsu mù gâ le, nungmoq é Îwa gi, nungmoq râ é hkyô lé, nungmoq a dung shi mai sê to Sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Haû mù, nungmoq kyûdûng le, 'Mauhkûng htoq tsáng myhâng mâ é ngamoq é Âwa ê, Náng é myìng gi, chyoiyúng nyî sháng gaq, ");
INSERT INTO atbNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Náng é mingdán jé lô sháng gaq, Nàng ô nau é hkyô, mauhkûng htoq má dik é su, myigùng htoq má le dik sháng gaq ô. ");
INSERT INTO atbNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ngamoq nyí wuî râ é zoshuq lé, ngamoq lé hkû-nyí byi laq. ");
INSERT INTO atbNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ngamoq lé shut é bâng é mara lé ngamoq hkyut pyám byî é su, ngamoq é mara lé le hkyut pyám byi laq. ");
INSERT INTO atbNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngamoq lé, agúng alaú hkyô má a wàng nhang é za, agè ashop jang mai hkyi yù laq ô. (Hkâsu mù gâ le, kô dik é up sîng hkyô, a-tsam eq hpungwup shingkang gi, pyat dedu ahtum abyuq Náng chyáng ru joq nyi ri ô! Amen.)' nghû dung keq. ");
INSERT INTO atbNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Supê èq, nungmoq lé kut shut é mara lé, nungmoq hkyut pyám byî é nghut le gi, mauhkûng htoq mâ é nungmoq é Îwa le, nungmoq lé mara hkyut pyám byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nghut kôlhang, haú bâng é mara lé, nungmoq a hkyut pyám byî é nghut le gi, nungmoq é Îwa le, nungmoq é mara lé hkyut pyám byi râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nungmoq gi, zoshuq gám é hkûn, gegùn labyoq kut bang su myoqdong hkâlhoq nyhui kó; hkâsu mù gâ le, haú bang gi, yhangmoq zoshuq gám é hkyô lé, tûn shit râ matú myoqdong lhoq nyhuî shit akô nghut ri. Ngò, nungmoq lé teng za taí kôlé, haú bang gi, yhangmoq é chyunghuq wó yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nungmoq kúm gi, zoshuq gám é hkûn, nungmoq zoshuq gám é hkyô lé, byu pê hí má de de a dut é za, nungmoq a byu-myang é Îwa za myàng sháng gaq, myoq chî pyám luî, u xû but keq; ");
INSERT INTO atbNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","haû jáng sheq, ó a sé loshoq kut é hkyô lé myang é Sû, nungmoq é Îwa gi, nungmoq lé chyunghuq shigyaú râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jàngkon, jogyik èq wó lhoq htên pyâm é eq hkaú su èq le wó wang hkaû yu pyám byî é myigùng htoq má, nungmoq é matú, sutzè lé hkâhkong to kó. ");
INSERT INTO atbNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jàngkon, jogyik èq le a wó lhoq htên pyâm é eq, hkaú su èq le a wó wang hkaû yu pyâm byî é mauhkûng htoq má sheq, nungmoq é matú sutzè hkong to keq. ");
INSERT INTO atbNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hkâsu mù gâ le, náng é sutzè joq jang má, náng é i-myit le jé nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Myoqjí gi, gungdû é myibung nghut nyi ri. Náng é myoqjí ge é nghut le gi, náng é gungdu gón má maubó byíng mui to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nghut kôlhang, náng é myoqjí a ge é nghut le gi, náng é gungdu gón gi, mauchut tuq dut nyì râ nghut lhê. Náng chyáng bo é maubó gi, mauchut byuq é nghut jáng, mauchut haû gi, hkâ-í yhang htû râ lhâ! ");
INSERT INTO atbNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ó yuq nghut kôle, yhumsîng í yuq lé wó dojaú râ a nghut. Hkâsu mù gâ le, yhang gi, rayuq lé a jú kut mù, rayuq lé gi, chyitdap râ nghut lhê; haû a nghut jáng, rayuq lé lhumzui mù, rayuq lé gi, hpau a tap kut râ nghut lhê. Nungmoq gi, Garai Gasang lé le, ngunzè lé le, radá dâm wó dojaú kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Haû mù luî, Ngò, nungmoq lé taí kôlé, nungmoq é asak matú haî zo haî shuq râ eq nungmoq é gungdû matú haî wut haî tsang râ lé, hkâ-myit chiq kó. Asak gi, zoshuq htoq má, gungdu gi, mebû htoq má, je ahkyak lhê a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Maulat mâ é nghoqzô pé lé wú wú keq; yhangmoq gi, kyô hkyó kyô shu a kut é htoq agó, chyî pé má le haî a tsîng kat to kô é nghut le lháng, mauhkûng htoq mâ é nungmoq é Îwa gi, yhangmoq lé, byi tso byi huq nyi lhê. Nungmoq gi, nghoq haú pé htoq má je riyhang hpaudap nyi lhê a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nungmoq má, ó yuq wá, myit chiq é èq, yhumsing é asak lé radúng kô wó jat yù kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Haû nghut le nhîng, haî mù, mebû matú myit chiq akô lhú? Myigùng má yuq tô é htutbó ban pé hkâsu kut kô lo é lé, myit wú keq. Haú pé gi, mû le a zui, hkyîng le a duì kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nghut kôlhang, Ngò, nungmoq lé taí kyo kôlé, hkohkâm Sholumon hpung kô dik u lé wut é mebu lháng, ban haû rabó lé a hkyit nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lumjíng myit tiq é bang ê, hkû-nyí joq mù, napmá myihkyóm má dú kat pyám hui râ nghut é yosô mhan pé lé za lháng, Garai Gasang haû su kut hut é nghut le gi, nungmoq lé je riyhang hut râ a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Haû mù, 'Haî zo râ lhi?' 'Haî shuq râ lhi?' 'Haî wut râ lhi?' nghû hkâ-myit chiq myhíng kó. ");
INSERT INTO atbNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tûngbaù pé kúm gi, haú pé banshoq lé châng hkat ho nyi akô; nghut kôlhang, mauhkûng htoq mâ é nungmoq é Îwa gi, haú pé lé nungmoq râ é hkyô, sé byî nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nghut kôlhang, Yhâng é mingdán eq dingmán hkyô lé hí hô keq, haû jáng, haú pé banshoq, nungmoq lé puq byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Haû mù, napmá lhê é matú hkâ-myit chiq kó; hkâsu mù gâ le, napmá gi, yhâng é yhang myit chiq râ nghut lhê. Hkû-nyí é wuîhke hkyô gi, hkû-nyí é matú gé bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nungmoq jéyáng é a hui kó sháng gaq, ó lé le, hkâjéyáng kó. ");
INSERT INTO atbNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hkâsu mù gâ le, nungmoq jéyáng é su, nungmoq le, jéyáng é hui kó râ nghut é htoq agó, nungmoq lik byî é bung èq, nungmoq lé dum lik byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yhumsing myoq hkaû má lúng tô é siktúm lé lháng a myit wú é nhîng, haî mù luî, nunggu nungmâng é myoqwàng lé myang lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Yhumsing é myoq má siktúm lhûng to luî nhîng, 'Náng myoq má lúng tô é myoqwàng lé, ngò choq pyám byi lé.' nghû luî, náng é gumang hpó lé hkâsu wó taí râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gegùn labyoq kut sû ê, náng é myoq má lúng tô é siktúm lé hí choq pyám aq. Haû jáng sheq, nunggu nungmâng é myoq má wang tô é myoqwàng choq pyám byi râ matú, nàng san za myàng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Hkuî pé lé, yunglhô é zê hkâbyi kó; waq pê hí má, nungmoq é palhé wuizo lé hkâdú byi kó. Haû su kut jáng, haú bang gi, zè haú pé lé nâng pyeq pyám mù, nungmoq lé dum taû ngat lò râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dung keq, haû jáng, nungmoq lé byi râ nghut lhê; hô keq, haû jáng, nungmoq myàng kó râ nghut lhê; hkum má kok keq, haû jáng, nungmoq lé hpóng byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hkâsu mù gâ le, ó yuq nghut kôle, dung sû wó râ; hô sû myàng râ; hkum kok sû lé gi, hpóng byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nungmoq má, ó yuq wá, yhumsing yhangzo muk dûng le, luqgok byi kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngozo dûng le, lhangmuì byi kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Agè ashop é bang nungmoq lháng gi, nungmoq é zo wuî lé, ge é chyunghuq dat byi kô le nhîng, mauhkûng htoq tsáng myhâng mâ é nungmoq é Îwa gi, Yhang lé dûng é bang lé, je riyhang ge é chyunghuq byi râ nghut lhê! ");
INSERT INTO atbNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Haû mù, hai hkyô má nghut kôlhang, nungmoq gi, yhumsîng ô nau é dông supé lé kut nhâng nau é su, yhangmoq lé le kut byi keq. Haî mù gâ le, haû gi, jep é tarâ eq myiqhtoî pê é dang lo jup tô é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chyap é hkúmdong mai wàng keq. Hkâsu mù gâ le, lam é hkúmdong eq hkyô mó gi, htên byoq hkyô shut shuî e é nghut mù luî, haú dông wàng bang gi, myô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chyap é hkúmdong eq hkyô zo kúm gi, asak hkyô shut shuî e é nghut mù luî, haú lé myang ho é bang gi, shaû akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nungmoq chyáng jé lé lo é myiqhtoi pyoq pé lé, sidiq nyì keq; yhangmoq gi, sau-kuq wut mù, nungmoq chyáng jé lé kôlhang, myaq zo myaq shuq nau é wamhkuî pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yhangmoq é muzó jizó lé wú mù, nungmoq gi, yhangmoq lé wú sé kó râ nghut lhê. Zubyap mai tsibyiq shi, zugâm mai maihpáng-shi wó yu wú akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ge é agàm gi, ge é ashi zui mù, a ge é agàm gi, a ge é ashi za dat zui ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ge é agàm gi, a ge é ashi a wó zui, a ge é agàm le, ge é ashi a wó zui nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ge é ashi a zuî é shigâm hkangmó lé gi, htuq pyám mù, myi má dú kat pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Haû mù, yhangmoq é muzó jizó lé wú mù, nungmoq gi, yhangmoq lé wú sé kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ngo lé, 'Yhumsîng ê, Yhumsîng ê,' ga, wut é bang yuq hkangmó gi, mauhkûng mingdán má myang wàng kó râ a nghut; haû mauhkûng htoq mâ é Ngá Wa ô nau é dông kut sû za sheq, myang wàng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Haú buinyì má, byù myo myo gi, 'Yhumsîng ê, Yhumsîng ê, Náng é myìng mai, ngamoq gi, myiqhtoi le htoi bê; nat gang lé hkat htoq bê; laklaí kumlhá ajung jung lé, kut bê a nghut lhú?' ga luî, Ngo lé myi kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Haú hkûn, Ngò gi, 'Nungmoq lé, Ngò hkâ-nhám le a sé; agè ashop hkyô kut é bang nungmoq, Ngá chyáng mai gâng ló byuq keq.' nghû, yhangmoq lé san za tû taî kat râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Haû mù, Ngá é dang shí pé lé wó gyô yù luî, châng kut é sû gi, hpaqchyî bò mù, lunghtân htoq má, yhûm saî é sû eq wuí nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mau wô, wuì je, laidun lò mù, yhûm haú lé lo htung kôlhang, yhûm haû gi, a htên byoq byuq râ nghut lhê; hkâsu mù gâ le, yhûm haû gi, lunghtân htoq má tsuq tô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nghut kôlhang, Ngá é dang lé, wó gyô yù mù, a cháng sû gi, semuî-jàng má, yhûm saî é byù ngok eq wuí nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mau wô, wuì je, laidun wò yup dut lò mù, yhûm haú lé lo htung jáng, yù whuî a mù loshoq htên byoq byuq râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuq mungdang ban taî é hkûn, shiwa byu pé gi, Yhang mhoqshit é hkyô lé maúhong bum akô; ");
INSERT INTO atbNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","hkâsu mù gâ le, Yhang gi, yhangmoq é tarâ sará pé eq a pung é za, ahkáng ayá wó sû rayuq su, mhoqshit é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuq gi, bùm htoq mai gyó lo é hkûn, byù moq mó gi, Yhâng htâng châng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Haú hkûn, manggâm dap é byù rayuq gi, Yhâng é hí má, lé mù, hkyihput htuq luî, \"Yhumsîng ê, Nàng dóng é nghut le gi, ngo lé Nàng wó lhoq sân-yúng byi râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuq gi, loq lhâm kat mù, haú yuq lé ê záng luî, \"Ngò dóng lhê, sân-yúng aq hkoi.\" ga taî kat ri. Haú hkûn jáng, haú yuq é manggâm gi, ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Haú hkûn, Yesuq gi, \"Nàng, shí hkyô ó lé le hkâtaî kyo. Nghut kôlhang, náng é gungdu lé, hkyangjong hpô chyáng ló tûn shit mù, yhangmoq é matú saksé dut sháng gaq, Mosheq taî tô é eq rajung za, hkungga ló nhông byi aq.\" ga haú yuq lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuq, Kaperna-um wà má wang e ló le, Romaq gyezau hpó rayuq gi, Yhâng chyáng lé jé mù, ");
INSERT INTO atbNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","\"Yhumsîng ê, ngá é dui-nhâng zoshâng gi, gùngjum shi é htoq agó, yhûm má gyaí no jamjaû leq tô ri.\" ga garúm lé dung ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Haú hkûn, Yesuq gi, yhang lé, \"Ngò, lé lhoq gê byi râ.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gyezau hpó haû, Yhang lé dum tû taî é gi, \"Yhumsîng ê, Nàng, ngá é laishîn-htâng má, lé nang râ lháng ngò má a gingdán. Nàng, dang rahkun za taî kat laq; haú hkûn, ngá é dui-nhâng zoshâng ge ló râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hkâsu mù gâ le, ngò le ahkáng ayá wó é zau rayuq é a-ô mâ é zau nghut lhê; ngá é a-ô má le gyezô pé nyi lhê; rayuq lé, 'Ê aq!' nghu le, yhang e ló lhê; góyuq lé, 'Lò aq!' nghu le, yhang lo lhê; ngá jûn lé le, 'Shî kut aq!' nghu le, yhang kut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuq gi, dang haú lé wó gyo jáng, maú byuq luî, Yhâng htâng cháng bang lé, \"Ngò, nungmoq lé teng za taí kôlé, Israelaq amyû má lháng, shî í lumjíng é sû lé, Ngò, rayuq lé le a myàng wú é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngò, nungmoq lé taí kôlé, buihtoq buiwàng hkyam mâ é byu pé myo myo gi, mauhkûng mingdán má, Abraham, Isak, Yakup pé eq rahá, zoshuq poî mó má myang zùng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nghut kôlhang, mingdán haú má wàng âng é bang kúm gi, shinggan mauchut hkaû shut dú pyâm é hui luî, haú jowò má ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyi bùm bekô râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hau htâng, Yesuq gi, gyezau lé, \"Ló aq hkoi! Nàng lumjíng é eq rajung za, dut râ nghut lhê.\" ga taî ri. Haú-u má yhang, haû dui-nhâng zoshâng gi, ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuq gi, Petruq é yhûm má jé wang e é hkûn, Petruq é yhâng-aumó gyai yhang no leq tô é lé, ê myang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesuq gi, yhâng é loq má ê záng kat é hkûn, Petruq yhâng-aumó gi, nòhpyo ge byuq mù, toq luî, Yhang lé wó gaí tso gaí huq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Myinhtâng mauchut lô jáng, nat gang wang júng nyi é bang myo myo lé, Yhâng chyáng shuî lé lo akô. Yhang gi, agè ashop é nat gâng pé lé dâng èq hkat htoq pyám mù, nòhpyo huî é bang banshoq lé lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Haû gi, \"Yhang gi, nga-nhûng é nolì nojàng lé yu pyám byi mù, nga-nhûng é nolì nojàng lé, wùn waq pyám byi bê nghut ri.\" ga, myiqhtoi Esai-aq taî tô é dang lhoq dik râ matú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuq gi, Yhâng é lhînghkyuq má byù moq mó zup míng nyi é lé myàng jáng, Yhâng é chángzô pé lé, nhông hé hpoq shut gû dap ê sháng gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Haú hkûn, tarâ sará rayuq gi, lé lô mù, \"Sará ê, ngò gi, Nàng hká e le hká cháng râ nghut lhê.\" ga Yhang lé lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Haû jáng, Yesuq gi, \"Wamhkuî pé gi, hkyûng wó akô; nghoq pé le, nghoqsut wó akô. Nghut kôlhang, haû Byu Yhangzo gi, u nghê jowò lháng a wó nghut ri.\" ga lhom taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Haú hkûn, chángzo rayuq gi, \"Yhumsîng ê, ngá wa lé ló yhûm pyám râ ahkáng hí byi shilaq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nghut kôlhang, Yesuq gi, \"Shî bê bang gi, shî bê bang yhangchang yhûm lhum kó sháng gaq, nàng gi, Ngá htâng cháng aq.\" ga dum taû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hau htâng, Yesuq lhaî hkaû má wàng mù, Yhâng é chángzô pé le, Yhâng htâng châng wàng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Haú hkûn, nhông má byodan-htik laidun mó lò mù, wuìlhêng pé gi, lhaî má bat ûm lò bê nghut ri. Nghut kôlhang, Yesuq gi, yhup myhî tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chángzô pé gi, Yhâng chyáng jé ê mù, Yhang lé nhaû pun luî, \"Yhumsîng ê, hkyi yù laq ô! Nga-nhúng myup ló nyi ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yhang gi, \"Lumjíng myit shaû é bang ê! Haî mù, haû-í gyuq bum akô lhú?\" ga taî kat ri. Hau htâng, Yhang gi, toq luî, laidun eq wuìlhêng pé lé tân kat jáng, banshoq zîm byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Byù haú bang gi, maúhong byuq kômù, \"Shí yuq gi, hkasû é byù lhà? Laì eq wuìlhêng pé lháng gi, Yhâng é dang lé gyo byî ri myhi-nhung!\" ga luî, rayuq eq rayuq myî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuq gi, Gadara byu pê é mau hpoq má jé dap ló jáng, nat gang wang júng é byù í yuq gi, lupdùng mai htoq lé lo kômù, Yhang lé lé huî akô. Haú nhik gi, haú hkyô mai ó lháng a wám lai loshoq wuî é su nhik nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yhangnhik gi, Yesuq lé, \"Garaî Yhangzo ê, Nàng, ngamoq eq haî sêng lhê lhú? Ahkyíng a jé shimá, ngamoq lé zing-ri râ matú jé lé lo é nghut lhê lhú?\" ga taî garû akô. ");
INSERT INTO atbNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Haú mai a lûm wê é jowò má, waq rajùm mó gi, myì dû but zô nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nat gâng pé gi, Yesuq lé, \"Nàng, ngamoq lé hkat htoq râ nghut jáng, hê waq pê chyáng wàng nhâng laq.\" ga dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuq gi, \"Htoq ló keq!\" ga taî kat ri. Haû mù, yhangmoq gi, htoq ló luî, waq pê chyáng wàng mù, waq haú jûm gi, gampyoq mai nhông hkaû shut din yán wang ló kôluî, wuì hkaû má myup shi byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Waq zúng bang gi, myuq hkaû shut hpang din wang ló kômù, dut laî lo é hkyô banshoq lé le, nat gang wang júng huí su nhik hkâsu dut é hkyô lé le, ló taî kyo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Haû mù, rawa bang gi, Yesuq lé hui râ matú htoq lé lo bùm kômù, Yhang lé myàng jáng, yhangmoq é mau mai htoq ló byuq râ matú, chôm dûng tôngbán akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesuq gi, lhaî má wàng mù, yhumsing é wà shut jî dap ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Byù ra-am gi, gùngjum shî sû rayuq lé, taphkang mai Yhâng chyáng waq lé lo akô. Yesuq gi, yhangmoq é lumjíng myit lé byu-myàng jáng, haû gùngjum shî sû lé, \"Ngá zo ê, nhik hkâ-ngê; náng é yubak mara lé hkyut pyám byi bê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Haú hkûn, tarâ sará pé ra-am gi, yhangmoq é i-myit hkaû má, \"Byù shí yuq gi, Garai Gasang lé rhoî dang taî nyi ri.\" ga myit nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuq gi, yhangmoq myit nyi é hkyô lé sé mù, \"Nungmoq é i-myit hkaû má, haû su agè ashop é dông haî mù myit nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Náng é yubak mara lé hkyut pyám byi bê.' nghû taí râ eq 'Toq luî, hkyô so aq.' nghû taí râ má, hká hkun je taí lui lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nghut kôlhang, haû Byu Yhangzo gi, mingkan htoq má, mara hkyut byi râ ahkáng wó Sû nghut é lé, nungmoq lé sé nhâng nau lhê.\" ga taí luî, haû gùngjum shî sû lé, \"Toq aq, náng é taphkang yu chûng luî, yhûm taû ló aq hkoi.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Haû mù, haú yuq gi, toq mù, yhûm shut ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Byù hpûng mó gi, haú hkyô lé myàng kôjáng, gyuq maú kômù, byu pé lé haû su é ahkáng ayá byi tô é Garai Gasang lé hkya-on kungton bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuq gi, haú jowò mai sô e ló é hkûn, kang guq zúm má zung tô é Mahte ga sû lé myàng mù, \"Ngá htâng cháng aq.\" ga taí jáng, haú yuq gi, toq luî, Yhâng htâng cháng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuq gi, Mahte é yhûm má myinzang zô nyi é hkûn, kang guq bang myo myo eq yubak dap bang myo myo lé jé kômù, Yhang eq Yhâng é chángzô pé eq rahá zo shuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Haû lé, Hparishe pé myàng kôjáng, Yhâng é chángzô pé lé, \"Nungmoq é sará gi, haî mù luî, kang guq bang eq yubak dap bang eq rahá zo shuq nyi lhê lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesuq gi, haû su ga kô é lé wó gyo jáng, \"Wángzán bang gi, chi sará a ra kó; nòhpyo hui bang za sheq ru râ lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'Ngò ô nau é gi, hkungga nhông hkyô a nghut, shogyo nhikmyin hkyô sheq ru nghut lhê.' gâ é lichyúm lé mhoq yû keq. Hkâsu mù gâ le, Ngò gi, dingmán bang lé wut yù râ matú jé lé é a nghut, yubak dap bang lé ji yù râ matú sheq jé lé é ru nghut lhê.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hau htâng, Wui-myhup Sará Yohan é chángzô pé gi, Yesuq chyáng jé lé kômù, \"Ngamoq eq Hparishe pé gi, zoshuq gám gám kut lhê; nghut kôle, Náng é chángzô pé gi, haî mù a gám kô é lhú?\" ga luî, lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Haû mù, Yesuq tû taî é gi, \"Bíng pé gi, lusik eq rahá nghut nyi to ashî hkûn, hkâsu ge yón kó râ lhú? Lusik lé, yhangmoq chyáng mai shuî yu pyâm é hkyíng jé râ nghut lhê; haú hkûn kúm gi, yhangmoq zoshuq gám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ó yuq le, mebu xau má pán sik èq a lhaq hpo wú kó; hkâsu mù gâ le, pán sik kun byuq jáng, mebu xau le je lhoq cheq pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tsibyiq wing asik lé le, shokuq htûng axau má ó a kat wú kó. Kat é nghut jáng, tsibyiq wing asik soq htân luî, htûng buq goq byuq mù, tsibyiq wing le yui shun byuq, htûng le htên byuq, dut râ nghut lhê. Haû mù, tsibyiq wing asik lé, shokuq htûng sik má kat jáng sheq, haû í jûng é a hten râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuq haû su ga taî nyi é hkûn, suwún rayuq jé lé lô mù, Yhâng é hí má hkyihput htuq luî, \"Ngá zo byizo gi, ahkuî za shi byuq bê. Nghut kôlhang, Nàng lé mù, yhâng é ahtoq má loq lé ke byi laq, haû jáng, yhang, asak dum dui lò râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesuq gi, toq mù, Yhâng é chángzô pé eq rahá, haú yuq htâng châng e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Haú hkûn, raxe í zân yhang, suí yui nyi é myiwe myhí rayuq gi, Yhâng é nunghtáng má huî lé mù, Yhâng é bushi htâng má ê záng kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Myiwe myhí haû gi, yhang gûng yhang, \"Ngò, Yhâng é buhtâng má ê wó záng jáng gi, ge byuq râ nghut lhê.\" ga, wó myit é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuq gi, lhing wú kat luî, yhang lé myàng jáng, \"Ngá zo ê, nhik hkâ-ngê, náng é lumjíng myit gi, nang lé lhoq gê byi bê nghut ri.\" ga taî ri. Haú hkûn jáng yhang, myiwe myhí haû gi, ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuq gi, suwún hpô é yhûm má jé wang ló é hkûn, sampyí mut bang eq garu garín dut nyi é bang lé, ê myâng mù, ");
INSERT INTO atbNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","yhangmoq lé, \"Hui keq. Myiwe zo gi, shi byuq é a nghut, yhup myhî tô é sheq ru nghut lhê.\" ga taí jáng, yhangmoq gi, Yhang lé wuìzuì kut pyám byî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yesuq gi, byù hpûng lé, shinggan shut htoq ló nhâng mù, Yhang wang ê luî, myiwe zo haú lé loq èq zuî kat jáng, myiwe zo haû gi, dum dui toq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Haú hkyo é danglù gi, ramau gón yhang jam ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuq gi, haú jowò mai xoq e ló nyì le, Yhâng é htâng má, myoqjit í yuq gi, châng dìn uchyang, \"Dawiq é Yhangzo ê, ngá-nhik lé shogyô yù laq ô!\" ga wut taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesuq gi, yhúmhkaû má jé wang ló é hkûn, myoqjit su nhik châng wang lò kômù, haú nhik lé, \"Ngò wó kut byî é lé, nungnhik lumjíng akô luq?\" ga myî ri. Haú hkûn, yhangnhik gi, \"Lumjíng lhê ô, Yhumsîng ê.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hau htâng, Yhang gi, haú nhik é myoqjí má ê záng htung luî, \"Nungnhik lumjíng é eq rajung za dut sháng gaq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Haû mù, yhangnhik gi, myoq wó myâng bekô nghut ri. Yesuq gi, \"Shí hkyô, ó lé le hkâsé nhâng kó.\" ga, yhangnhik lé htân htân sidiq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nghut kôlhang, yhangnhik gi, haú hkyô lé, haú mau ramau gón yhang taî pyo ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Haú nhik htoq ló nyî kô é hkûn, nat gang wang júng luî, dang a wó nyô sû rayuq lé, Yesuq chyáng shuî lé lo akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nat gang lé hkat htoq pyâm é hkûn, nhutjit sû haû gi, dang wó nyô bê nghut ri. Byù hpûng mó gi, haú lé wú maú byuq kômù, \"Shî su dut é hkyô lé, Israelaq amyû má radàm lháng a myang wú.\" ga taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nghut kôlhang, Hparishe pé kúm gi, \"Nat gâng pê é zaû é wum-o a-tsam èq za, nat gâng pé lé hkat htoq pyâm é nghut ri.\" ga taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuq gi, myuq pé eq wà pé banshoq má wàng luî, haú pé mâ é tarajong pé má mhoqshit é eq, mauhkûng mingdán hkyô eq sêng é gabú danglù lé hko kyo uchyang, nòhpyo ajung jung eq nolì nojàng hui bang yuq hkangmó lé, lhoq gê byî wún ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesuq gi, byù moq mó lé myàng jáng, wú shogyô nyi ri. Hkâsu mù gâ le, yhangmoq gi, sau zúng sû a nyi é sau pé su, awui ahke dut é eq byo myín bûm kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Haû mù, Yhang gi, Yhâng é chángzô pé lé, \"Kyôshû yù râ myo shoq joq kôlhang, mû zui râ byù gi, shaû nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Haû mù, haû kyô Yhumsîng lé, Yhâng é kyô yô má, kyô shu byù myo myo nhâng byi râ matú, dung keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuq gi, Yhâng é chángzo raxe í yuq lé wut yù mù, agè ashop é nat pé lé wó hkat htoq râ eq, nolì nojàng eq nòhpyo ajung jung lé wó lhoq gê râ ahko ahkáng yhangmoq lé byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Haû lagyo raxe í yuq é myìng gi, (Petruq ga sû) Simun eq yhanggu Andre; Zebedi é yhangzô nhiktang Yakuq eq yhanggu Yohan; ");
INSERT INTO atbNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Hpilip eq Barhtolume; Htomaq eq kang guq sû Mahte; Alhpe é yhangzo Yakuq, Htade, ");
INSERT INTO atbNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Zelutuq dut é Simun eq, Yesuq lé ap pyám râ sû, Yudaq Iskarut pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuq gi, haú bang raxe í yuq lé dangsâng mù, nhang htoq kat ri. Yhang sang kat é dang gi, \"Tûngbaù pê chyáng le hkâ-ê kó; Samariq wà rawà má le hkâwâng kó. ");
INSERT INTO atbNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Haû byuq byuq é sau pé su nghut nyi é Israelaq byu pê chyáng sheq ê keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nungmoq gi, ê mù, 'Mauhkûng mingdán gi, chyâng lò bê nghut ri.' nghu é danglù lé hko kyo keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nò bang lé lhoq gê byi, shî bê bang lé lhoq dui toq, manggâm dap bang lé lhoq san lhoq yúng byi, nat gâng pé lé hkat htoq pyám, kut keq. Laí laí wó é lé, laí laí byi keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nungmoq é hpyihit má, hîng, ngùn eq gyi pé hkâkat chûng kó; ");
INSERT INTO atbNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","hkyowui é matú, etap, mebu htaí, hkyî-tsung eq dumbáng pé hkâyu chûng kó; hkâsu mù gâ le, mû zui sû gi, zoshuq wó gíng lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hká wâ hká dum má jé wang ló le le, haú mâ é gingdán é byù lé hô mù, haú mai htoq ló é hkûn jé shoq, haú yuq é yhûm má za nyi nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Haú yhûm má wang é hkûn, shichyên yù keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Haú yhûm gi, gingdán é nghut jáng, nungmoq shimân byî é hkyô, yhangmoq chyáng joq nyì sháng gaq; a gingdán é nghut jáng, nungmoq chyáng dum taû lò sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nungmoq lé a lhom hap yu é eq nungmoq é dang lé a lhom gyo byi kô é nghut jáng, haú yhûm haú wâ mai htoq ló é hkûn, nungmoq é hkyiwa má dap é hpuilhaû lé ko hkyô pyâm to keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngò, nungmoq lé teng za taí kôlé, tarâ jéyáng é buinyì má, haú wâ gi, Sodom eq Gomoraq myuq htoq má je hpuzo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wamhkui hpúng má nhang hâng kat é sau pé lé su, Ngò, nungmoq lé nhang kat é nghut lhê. Haû mù, lhangmuì su hpaqchyî bò luî, hpûngkyui su nú-nhâm nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Byu pé lé sidiq keq; hkâsu mù gâ le, yhangmoq gi, nungmoq lé, tarâ rûng pé má ê ap pyám kó râ nghut é htoq agó, yhangmoq é tarajong pé má, nungmoq lé nhuq bat kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nungmoq gi, Ngá é yanmai, mauzau wuì eq hkohkam pê é hí má shuî jé é hui luî, yhangmoq é hí má le, tûngbaù pê é hí má le, saksé myang hkám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nghut kôlhang, nungmoq lé ap pyám kô é hkûn, nungmoq hkâsu taí râ eq haî taí râ lé, hkâ-myit chiq kó. Haú hkûn taí râ dang, nungmoq wó kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hkâsu mù gâ le, haû gi, nungmoq é dang a nghut, nungmoq é Yhângwâ é Woi-nyí sheq, nungmoq dông taí râ ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nhiktâng gi, nhiktâng yhangchang, îwa gi, yhangzo lé, shî shoq ap pyâm lhum kó râ nghut lhê; zo wuî gi, mó wuî lé gumlau toq mù, sat pyám nhâng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Byù lhunglhâng bang gi, Ngá é yanmai, nungmoq lé a nguì kut kó râ nghut lhê; nghut kôlhang, jihtûm jé shoq wó hkam jân nyi é sû gi, hkyi yu é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Rawò má zing-ri é hui jáng, rawò shut hpang ê keq. Ngò, nungmoq lé teng za taí kôlé, Israelaq byu pê é myuq pé má, nungmoq a ban wang ngap shimá, haû Byu Yhangzo jé râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jongzo gi, sará htoq, dui-nhâng zoshâng gi, yhumsing htoq, gyaú râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jongzo gi, yhâng é sará su, dui-nhâng zoshâng gi, yhâng é yhumsîng su, wó dut jáng gé bê. Yhumsîng hpó lé lháng Bezebulaq ga kô le gi, Yhâng é yhumbyù wuì lé gi, je riyhang nghû kó râ a nghut lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Haû mù, yhangmoq lé hkâgyuq kó. A byông htoq loshoq wó zaú nghop tô é haî le a joq râ nghut lhê; a sé loshoq wó haq tô é le, haî a joq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngò, nungmoq lé mauchut hkaû má taî é hkyô lé, myoq myàng maubó má taî kyo keq; Ngò, nungmoq lé dangsoq soq kyo é hkyô lé, yhumhkûng htoq mai taî pyô keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gungdu lé za wó sat pyám mù, woi-nyí lé a wó sat bang lé, hkâgyuq kó. Woi-nyí lé le, gungdu lé le, ngaraî ming má wó lhoq htên é Sû lé sheq, gyuq nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Johkyáng í du lé, gyi htingchap rachap èq wó ûng pyâm lhê a nghut kó lhú? Nghut kôlhang, haû radu lháng, nungmoq é Îwâ é myit èq a nghut jáng, myigùng má wó byit gyó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nungmoq é ulhum mâ é xâm banshoq lé lháng, nghap to gù nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Haû mù, hkâgyuq kó; nungmoq gi, haû johkyáng myo myô htoq má lháng gù je bo é bang nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Byu pê hí má, Ngo lé lhom yín yu é sû ó yuq lé nghut kôle, mauhkûng htoq mâ é Ngá Wâ é hí má, Ngò lhom yín yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Byu pê é hí má, Ngo le he-ngik pyâm é sû ó yuq lé nghut kôle, mauhkûng htoq mâ é Ngá Wâ é hí má, Ngò he-ngik pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ngo lé, haû myidàm htoq má simsaq hkyô byi râ matú lé lo é sû su hkâ-ngâm kó. Ngò gi, simsaq hkyô byi râ matú lé lo é a nghut, shâm byi râ matú sheq lé lo é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hkâsu mù gâ le, 'Yuqzo gi, yhângwa eq, byizo gi, yhângnu eq, dumó gi, yhângmhoí eq, byoq lhum kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yhumsing é yhumbyù wuì gi, yhumsing é gyè taû dut râ nghut lhê.' gâ tô é matú sheq, Ngò jé lé é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ngo lé chyit é htoq yhumsing é înu îwa lé je chyit é sû ó yuq nghut kôle, Ngá é chángzo kut râ gingdán sû a nghut; Ngo lé chyit é htoq yhumsing é zo wuî lé je chyit é sû ó yuq nghut kôle, Ngá é chángzo kut râ gingdán sû a nghut; ");
INSERT INTO atbNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yhumsing é tapzîng lé a waq é za, Ngá htâng châng é sû ó yuq nghut kôle, Ngá é chángzo kut râ gingdán sû a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yhumsing é asak lé ha bûn é sû ó yuq nghut kôle, asak sum râ nghut lhê; Ngá é yanmai, yhumsing é asak sûm pyâm é sû ó yuq nghut kôle, asak wó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nungmoq lé hap yù sû gi, Ngo lé hap yu é sû nghut bê; Ngo lé hap yù sû gi, haû Ngo lé nhang kat Sû lé hap yu é sû nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Myiqhtoi rayuq lé, myiqhtoi dông lhom hap yu é sû ó yuq nghut kôle, myiqhtoi rayuq é chyunghuq lé wó yû râ nghut lhê; dingmán sû rayuq lé, dingmán sû dông lhom hap yu é sû ó yuq nghut kôle, dingmán sû rayuq é chyunghuq lé wó yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Shî, tiq bang mâ é rayuq yuq lé, Ngá é chángzo nghut é yanmai, uchyam ragóm byi huq é sû gi, Ngò, nungmoq lé teng za taí kôlé, yhâng é chyunghuq lé hkyak myang hkam yù râ za nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuq gi, Yhâng é chángzo raxe í yuq lé dang ban pying é htâng má, Galile mau mâ é wà pé má mhoqshit râ matú eq hko kyo râ matú, haú jowò mai htoq e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wui-myhup Sará Yohan gi, Hkrisduq kut nyi é hkyô lé, htóng hkaû má wó gyo jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","\"Nàng gi, haû jé lé lô râ Sû nghut lhê lhú? Haû a nghut jáng, ngamoq gi, góyuq lé láng ra shirâ lhú?\" ga, yhâng é chángzô pé lé myí nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuq tû taî é gi, \"Nungmoq wó gyo wó myang é hkyô, Yohan lé ló taî kyo keq; ");
INSERT INTO atbNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","myoqjit bang, myoq wó myâng bekô; hkyî hten bang le, wó so bekô; manggâm dap bang le, lhoq gê byî é hui bekô; nojit bang le, wó gyo bekô; shî bê bang le, lhoq dui toq é hui bekô; myùng bâng é matú, gabú danglù hko kyô nyì bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngá é yanmai, Ngo lé lum shut é hkyô a bò sû gi, hkungsô wó nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohan é chángzô pé taû ló kô é u lé, Yohan eq séng luî, byù moq mó lé Yesuq taî é gi; \"Nungmoq gi, haî lé hpuq wú râ matú, haû yoso shut e akô lhú? Laì èq hik nhûn é jamgàm lé wú râ matú nghut akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Haû a nghut jáng, haî lé wú râ matú e akô lhú? Nú-nhâm é mebu wut sû lé wú râ matú e akô lhú? A nghut. Nú-nhâm é mebu wut bang gi, hkohkâm-wâng pé má sheq rû nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Haû nghut lé gi, haî lé wú râ matú ê kô é lhú? Myiqhtoi rayuq lé lhú? Haû kúm nghut ri; Ngò, nungmoq lé taí kôlé, Yohan gi, myiqhtoî htoq lháng gyaú sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Haú yuq é hkyô lé, Chyúmdang má kâ tô é gi, 'Wú aq, Náng é hkyô lajang láng râ matú, Ngá é lagyo lé, Náng é hí má Ngò nhang kat râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngò, nungmoq lé teng za taí kôlé, myiwe wuì mai hku kat é bang má, Wui-myhup Sará Yohan htoq je kô é rayuq lháng a htoq wú shi; nghut kôlhang, Garai Gasâng é mauhkûng mingdán má je tiq dik sû gi, Yohan htoq je kô lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wui-myhup Sará Yohan é buinyì mai ahkuî jé shoq, mauhkûng mingdán gi, lú chyîn wang nyi é hui mù, sarhé pé gi, haú lé wó yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hkâsu mù gâ le, Yohan é ahkyíng jé shoq, haû myiqhtoî pé banshoq eq tarâ gi, haú hkyô eq séng luî, myiqhtoi htoî to gù nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nungmoq hap yù nau é nghut jáng, Yohan gi, haû jé lé lô râ ga sû Eliyaq nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gyô yù râ nohkyap dap sû gi, gyô yù sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Shí ipyat lhê é byu pé lé, Ngò, hai eq taî kê wú râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Yhangmoq gi, 'Nungmoq é matú, ngamoq sampyí mut byi kôlhang, nungmoq gi, a gó kó; ngamoq, ngaù hkyangsâng kôlhang, nungmoq gi, a ngaù kó.' ga luî, gaì pé má zùng mù, góbang lé wut taî lhûm nyi é zoshâng wuì eq wuí akô. ");
INSERT INTO atbNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hkâsu mù gâ le, Yohan gi, jé lé mù, a zo a shuq kut jáng le, yhangmoq gi, yhang lé, 'Yhang gi, nat gang dap sû nghut ri.' ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Haû Byu Yhangzo jé lé luî, zo mù shuq mù kut jáng le, 'Shí yuq gi, zo myoq shuq myoq noq sû eq, kang guq bang eq yubak dap bâng é buinùm hpó nghut ri.' ga dum taî akô. Nghut kôlhang, hpaqchyî byéng-yá gi, yhâng é muzó èq saksé tûn shit nyi ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hau htâng, Yesuq gi, laklaí kumlhá pé je myo kut shit bê nghut kôlhang, myit a lhing é myuq pé lé tân é gi, ");
INSERT INTO atbNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","\"Kurazin wà mó ê! Nàng dingnyé wó ri! Bet-saida wà mó ê! Nàng dingnyé wó ri! Nungmoq chyáng lé kut shit é laklaí kumlhá pé lé, Turuq myuq eq Sidun myuq má kut shit é ru nghut le gi, yhangmoq, noq noq mai myit lhîng mù, jimê tû wut lhê, myiwap kyaq gyûn lhê kut bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngò, nungmoq lé taí kôlé, tarâ jéyáng é buinyì má, nungmoq gi, Turuq myuq eq Sidun myuq htoq má je hpuzo kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dum mù, Kaperna-um wà nàng ê, nàng gi, mauhkûng jé shoq waq toq é hui râ lhú? A nghut, mosumhkung má sheq gyó râ nghut lhê. Náng chyáng kut shit é laklaí kumlhá lé, haû Sodom wà má kut shit é ru nghut le gi, myuq haû hkû-nyí jé shoq joq nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngò, nungmoq lé taí kôlé, tarâ jéyáng é buinyì má, Sodom wà hpuzô é gi, náng htoq shau râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Haú u lé, Yesuq taî é gi, \"Mauhkûng eq myigung é Yhumsîng, Âwa ê, Nàng gi, haú pé lé, hpaqchyî byéng-yá bò bang eq myit hpaqchyî sé bâng é hí má nghop to luî, zoshâng wuì lé tûn shit bê nghut é yanmai, Ngò, Nang lé hkya-on lhê ô. ");
INSERT INTO atbNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nghut bê, Âwa ê, haû gi, Nàng ô nau é hkyô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ngá Wa gi, lhunglháng lé Ngá é loq má ap byî to bê. Haû Zo lé, Âwa mai lai luî ó le a sé; Âwa lé le, haû Zo eq haû Zo mai sé nhâng râ matú hkyin yu é bang mai lai luî ó a sé. ");
INSERT INTO atbNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ngú é eq wòlai wun é lhunglhâng bang ê, Ngá chyáng lé keq; Ngò, nungmoq lé bánno nhâng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngò gi, myit nú-nhâm é eq myit lhoq nyhum é sû nghut é yanmai, Ngá é kandang lé waq keq; Ngá chyáng mai mhoq yû keq; haú hkûn, nungmoq é asak woi-nyí bánno kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Haî mù gâ le, Ngá é kandang gi, waq lui é htoq agó, Ngá é wò le sôm lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Haú yoq lhê é Bánno buinyì ra-nyí má, Yesuq gi, Yhâng é chángzô pé eq rahá yò hkaû mai sô lai ló nyi ri. Yhâng é chángzô pé gi, zòmut é yanmai, kyôshi ratsuí langshap yû mù, zô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hparishe pé gi, haú lé myàng kôjáng, \"Wú aq! Náng é chángzô pé gi, Bánno buinyì má a ge kut jung lé kut nyi akô.\" ga taí kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Haú hkûn, Yesuq tû taî é gi, \"Dawiq lháng gi, yhâng htâng châng é bang eq rahá zòmut huî é hkûn hkâsu kut é hkyô lé, nungmoq a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawiq gi, Garai Gasâng é yhúmhkaû má wang ê mù, hkyangjông pé mai lai luî, ó le a ge zô é, kyâng tô é muk lé, yhang eq yhâng htâng châng é bang yù zo kô é a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hau htoq agó, Bánno buinyì má, hkyangjông pé gi, noqkuq yhúmhkaû má Bánno buinyi é tarâ lé shut kôlhang mara a wó é lé, haû tarâ laiká má nungmoq a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngò, nungmoq lé taí kôlé, haû noqkuq yhûm htoq je ko sû gi, shí má nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Ngò ô nau é gi, hkungga nhông hkyô a nghut, shogyo nhikmyin hkyô sheq ru nghut lhê' gâ é lichyúm lé nungmoq sé kô é ru nghut le gi, mara a bò bang lé mara hûn kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hkâsu mù gâ le, haû Byu Yhangzo gi, haû Bánno buinyi é Yhumsîng nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Hau htâng, Yhang gi, haú jowò mai e ló mù, yhangmoq é tarajong má wang e ló ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Loq rahkyam ajum shi byuq é byù rayuq le, haú má nyi tô ri. Yhangmoq gi, Yesuq lé, \"Bánno buinyì má, nòhpyo lhoq gê byi le, tarâ wang lhê lhú?\" ga myi é dông, Yhang lé mara hûn râ hkyô ho akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Haú hkûn, Yesuq gi, \"Nungmoq chyáng mâ é ó yuq wá, yhumsing é sau radu, Bánno buinyì má dong gyó tô le, a xe htoq yu é nyì kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Byù gi, saû htoq má hpaudap dik é nghut lhê! Haû mù, Bánno buinyì má ge é hkyô kut le, tarâ wang lhê.\" ga yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hau htâng, Yhang gi, haû loq jum shî sû lé, \"Náng é loq nyhang kat aq.\" ga taî kat jáng, haú yuq gi, loq nyhang kat jáng, loq haû gi, a no é loq su ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hparishe pé kúm gi, htoq ló kômù, Yesuq lé hkâsu kut wó sat pyám râ hkyô lé, chôm hpyê lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuq gi, haú hkyô lé sé jáng, haú jowò mai htoq ló bê nghut ri. Byù myo myo le, Yhâng htâng châng bùm kômù, Yhang gi, nòhpyo hui bang banshoq lé lhoq gê byi luî, ");
INSERT INTO atbNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yhang ó yuq nghut é hkyô lé, a taî byông htoq râ matú, yhangmoq lé taî hkûm tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Haû gi, myiqhtoi Esai-aq é nhut dông mai taî tô é dang lé lhoq dik râ matú nghut ri. Dang haú pé gi, ");
INSERT INTO atbNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","\"Shí yuq gi, Ngò chyit, Ngò myit nguì luî, hkyin tô é Ngá é dui-nhâng zoshâng nghut lhê; Ngò gi, Ngá é Woi-nyí, Yhang lé kat byi râ nghut mù, Yhang gi, tarâ dingmán é hkyô lé byù myû banshoq pé má taî kyo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yhang gi, haî a hpuq tû é htoq agó, a garu râ nghut lhê; Yhâng é htê lé, hkyô mó pé má wó gyo râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yhang gi, tarâ dingmán é hkyô lhoq ung é hkûn jé shoq, nâng chap pyám bê jàm gàm lé le, lhoq hkyui râ a nghut, myihkau za htoq nyî bê myi lé le, lhoq sat pyám râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Byù myû chângjup gi, Yhâng é myìng má myit myoqbyù kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hau htâng, agè ashop é nat gang wang júng luî, myoqjit nhutjit é byù rayuq lé, Yesuq chyáng shuî lé lô kôjáng, Yesuq gi, haú yuq lé lhom lhoq gê byî ri; haû mù, haú yuq gi, dang le wó nyô, myoq le wó myâng dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Byù hpûng mó gi, haú lé wú maú byuq kômù, \"Shí yuq, Dawiq é Yhangzo za gi, nghut lhê laq?\" ga taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nghut kôlhang, Hparishe pé gi, haú lé wó gyo kôjáng, \"Shí yuq gi, nat gâng pê é zau Bezebulaq é wum-o a-tsam èq za nat gâng pé lé wó hkat htoq é nghut ri.\" ga taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yhangmoq myit nyi é hkyô lé Yesuq sé mù, yhangmoq lé taî é gi, \"Hká mingdán nghut kôle, ahkaû má byoq gâng lhûm nyì kô é nghut jáng, htên byoq byuq râ za nghut lhê; haû eq rajung za, myuq ralhum nghut nghut, yhumhtu ralhum nghut nghut, yhangchang byoq lhûm nyì kô é nghut jáng, haû gi, wó gîng nyì râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tsadán gi, Tsadán lé hkat htoq pyâm é nghut jáng, yhumsing gùng yhumsîng lhoq hpyoq nyî gù bê nghut ri. Haû su nghut jáng, yhâng é mingdán gi, hkâsu kut wó gîng to râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Haû mù luî, Ngò gi, Bezebulaq é wum-o a-tsam èq za nat gâng pé lé hkat htoq é nghut jáng, nungmoq é byu pé gi, ó yuq é wum-o a-tsam èq hkat htoq pyám kô é nghut lhê lhú? Haû su nghut jáng, haú bang gi, nungmoq lé tarâ jéyáng bang dut kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nghut kôlhang, Ngò gi, Garai Gasâng é Woi-nyí èq nat gâng pé lé hkat htoq pyâm é nghut jáng, Garai Gasâng é mingdán gi, nungmoq chyáng jé bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ó yuq nghut kôle, wum-o bò sû lé hí tuî zing pyâm é a nghut le gi, yhâng é yhûm má lú wâng mù, yhâng é sutzè lé hkâsu wó lú yû râ lhú? Haú yuq lé hí tuî zing pyám jáng sheq, yhâng é sutzè lé wó lú yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ngá hkyam shut a dap sû gi, Ngo lé gyè kut sû nghut lhê; Ngò eq rahá a shûm tsing sû gi, lhoq pyo pyâm é sû nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Haû mù, Ngò, nungmoq lé taí kôlé, byu pê é yubak mara hkangmó eq Garai Gasang lé rhoî dang taî pyâm é lhunglháng gi, mara hkyut byî é wó hui râ nghut lhê. Nghut kôlhang, haû Chyoiyúng Woi-nyí lé rhoî dang taî pyâm é gi, mara hkyut byî é hui râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Haû Byu Yhangzo lé dang dông shut é sû gi, mara hkyut byî é wó hui râ nghut lhê; nghut kôlhang, haû Chyoiyúng Woi-nyí lé dang taî shut é sû gi, shí ipyat má le, htang pyat má le, mara hkyut byî é hui râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ashi lé wú luî, agàm lé sé râ nghut é yanmai, agàm lé lhoq gê jáng, ashi le gè râ nghut lhê; agàm lé a lhoq gê jáng, ashi le gè râ a nghut; ");
INSERT INTO atbNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Duq htân lhangmuì amyû ê, nungmoq gi, agè ashop é bang nghut to kôluî nhîng, dang gè hkâsu wó taí kó râ lhú? Hkâsu mù gâ le, i-myit unghkaû má byíng mui tô é lé za, nhut mai taí htoq lo é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ge é sû gi, yhumsing é i-myit unghkaû mâ é sutdò mai ge é zè pé lé lhoq htoq shit lhê. Agè ashop é sû gi, yhumsing é i-myit unghkaû mâ é agè ashop é sutdò mai, agè ashop é zè pé lé lhoq htoq shit lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ngò, nungmoq lé taí kôlé, byù gi, yhumsîng taî kat é akyû a bo é dang pê é matú, tarâ jéyáng é buinyì má taî sân kyo ra kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hkâsu mù gâ le, yhumsîng mara lut râ le, ó le ó taî é dang pé mai; mara byî é hui râ le, ó le ó taî é dang pé mai, nghut râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hau htâng má, Hparishe pé eq tarâ sará pé ra-am gi, \"Sará ê, ngamoq gi, Nàng, limik kumlhá kut shit râ lé myàng nau ri.\" ga Yhang lé dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Haû mù, Yhang tû taî é gi, \"Agè ashop é eq lhum a zuî é ipyat shî gi, limik kumlhá dung nyi ri myhi-nhung! Myiqhtoi Yonaq é kumlhá mai lai luî, gotû haî le tûn shit râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hkâsu mù gâ le, Yonaq gi, ngo mó é wamdau hkaû má sum nyí sum myîn lúng é su, haû Byu Yhangzo le, myigùng káng má sum nyí sum myîn lúng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninewe wà byù wuì gi, Yonaq mungdang hko kyô é hkûn myit lhîng kô é nghut mù, tarâ jéyáng é buinyì má, ipyat shí mâ é bang eq rahá toq lò luî, ipyat shí mâ é bang lé mara hûn kó râ nghut lhê; haû Yonaq htoq ko sû gi, ahkuî shí má jé nyì to bê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Maupyî mâ é hkohkâm myhí gi, maumyî ló htâng é mai lé lô mù, Sholumon é hpaqchyî dang lé, lé gyô yù bê nghut mù, haû tarâ jéyáng é buinyì má, ipyat shí mâ é bang eq rahá toq lô luî, ipyat shí mâ é bang lé mara hûn râ nghut lhê; haû Sholumon htoq ko sû gi, ahkuî shí má jé nyì to bê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Haû agè ashop é nat gi, byù rayuq chyáng mai htoq ló mù, kyuq huî é jowò pé má sô yông e ló luî, no râ jowò hkat ho wú le, a myang hô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Haú hkûn, yhang gi, 'Ngò nyi laî lo é yhûm má dum taû ló wú râ.' ga taí ri. Yhang dum taû jé ló wú le, yhûm haú lé, ó le a sing yu hpyuq é htoq agó, san za rago dut to láng é lé ló myang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Haû jáng, yhang gi, dum taû ê mù, yhâng htoq je wuî é nat nyhit nat lé shuî lò luî, haú má lo wang nyi to bekô. Haû mù, haú yuq é nyì yap sâmlai gi, hí lhê htoq má je wuî lò bê nghut ri; agè ashop é ipyat shî le, haû eq rajung za dut râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuq, shiwa byu pé lé dang rû nyo nyi ashî hkûn, yhângnu eq yhanggu pé gi, Yhang lé nyò naù kômù, shinggan má lé yap tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Haû mù, Yesuq lé, \"Náng nu eq nunggu pé gi, Nang lé nyò naù mù, shinggan má láng yap bum akô.\" ga taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Haú hkûn, Yhang gi, \"Ô pé gi, Ngá nu eq Ngá gu pé nghut akô lhú?\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hau htâng, Yhang gi, Yhâng é chángzô pé lé loq tun luî, \"Wú keq, shí bang gi, Ngá nu eq Ngá é gumang wuì nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hkâsu mù gâ le, mauhkûng htoq mâ é Ngá Wa ô nau é hkyô châng é sû ó yuq nghut kôle, Ngá gu Ngá mang, Ngá gu Ngá nhá, Ngá nu chyat nghut bê.\" ga xoq taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Haú nyí má yhang, Yesuq gi, yhúmhkaû mai htoq ló mù, wuì nhông yàm má ê zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Byù hpûng mó gi, Yhâng é lhînghkyuq má zup zîng lé bûm kô é yanmai, Yhang gi, lhaî hkaû má doq zùng tô ri. Shiwa byu pé kúm gi, gin-gau htoq má yap tô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Hau htâng, Yhang gi, haú bang lé, dangtú pé dông myo myo taî é má, \"Kyô hkyó sû rayuq gi, kyôshi san râ ga htoq e ló ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yhang, kyôshi sân kat é hkûn, ra-am gi, hkyô má gyó ang mù, nghoq pê èq lé hte zô pyám ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ra-am gi, myi-tse a htu é luqgok yò pé má gyó ang mù, myi-tse a htu é yanmai, luì za yuq htoq lô kôle, ");
INSERT INTO atbNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","amyit a wó chîn hing é nghut mù, buì htoq lô jáng, lhap kyuq pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dum ra-am gi, zugyóm hkaû má gyó ang luî, zubyap haú pé kô lò mù, wup pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ra-am dum nghut jáng, myìhpún bo é jang má gyó ang luî, ashi zuî lo é gi, sân kat é htoq rashô tú, hkyuq xê tú, sum xê tú, myô jat lo é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gyô yù râ nohkyap dap sû gi, gyô yù sháng gaq.\" ga le taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Haú hkûn, chángzô pé gi, Yhâng chyáng lé mù, \"Nàng gi, haî mù, shí bang lé, dangtú dông taî lhê lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Haû jáng, Yhang tû taî é gi, \"Mauhkûng mingdán eq sêng é sê gyo wuî é hkyô pé lé sê gyo râ ahko ahkáng, nungmoq lé byî to bê, nghut kôlhang, yhangmoq lé gi, a byi shî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wó to sû lé gi, yhang agùn agó wó râ matú, jat byi shirâ nghut lhê. A wó su chyáng mai kúm gi, yhang wó tô é lé lháng yu pyám byi shirâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yhangmoq gi, wú to kôlhang, a myàng kó; gyô nyì kôlhang, a wó gyo, a sê gyo kó nghut é yanmai, yhangmoq lé Ngò dangtú dông taí râ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Haû gi, 'Nungmoq gi, wó gyô tô nyì kôlhang, sê gyo kó râ a nghut; myang tô nyì kôlhang, wú sé kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hkâsu mù gâ le, byù shí bang gi, myit nhikshi jit byuq bê; yhangmoq é nohkyap gi, a wó gyo kó, myoqjí le chûm byuq bekô nghut ri. Haû su a nghut le gi, yhangmoq, myoq myàng no gyo mù, i-myit bun bóng luî, lhîng lò kômù, Ngò, yhangmoq lé yâ gè byi berâ nghut lhê.' gâ é, Esai-aq é myiqhtoi dang lé lhoq dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nghut kôlhang, nungmoq é myoq gi, wó myâng mù, nungmoq é nohkyap gi, wó gyô é yanmai, nungmoq gi, hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hkâsu mù gâ le, Ngò, nungmoq lé teng za taí kôlé, nungmoq wó myâng, wó gyô é pé lé, myiqhtoî pé eq dingmán bang myo myo gi, myàng naù gyo naû kôlhang, a wó myâng, a wó gyo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ahkuî, kyôshi san sû eq sêng é dangtû é lichyúm lé rago gyô wú keq; ");
INSERT INTO atbNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hkyô má gyó âng é kyôshi gi, mauhkûng mingdán eq sêng é danglù lé wó gyo kôlhang, a sê gyô é yanmai, haû agè ashop sû lé lô mù, yhâng é i-myit hkaû má san kat tô é kyôshi lé, lé yu pyám byî é hui sû lé gá nau é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Luqgok yò pé má gyó âng é kyôshi gi, mungdang lé wó gyo jáng, radá dâm gabú myit èq hap yù kôlhang, ");
INSERT INTO atbNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","amyit a wó chîn é yanmai, razup zo za yuq mù, mungdâng é yanmai, wuîhkê é eq zing-rî é hui kôjáng, hân hân htak ló byuq é sû lé gá nau é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Zugyóm má gyó âng é kyôshi gi, haû mungdang lé wó gyô yù kôlhang, shí ipyat lhê é myit wui myit hke hkyô pé eq hkyô shuî nghoq jung ngùn hîng zèhkoq èq hup pyâm é yanmai, ashi a wó zuî é sû lé gá nau é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nghut kôlhang, myìhpún bo é jang má gyó âng é kyôshi kúm gi, mungdang lé wó gyo mù, sê gyô yu é sû lé gá nau é nghut lhê. Haú yuq ashi zuî é gi, san kat é htoq rashô tú, hkyuq xê tú, sum xê tú, myô jat lo é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuq, yhangmoq lé dangtú dông xoq taî kyô é gi, \"Mauhkûng mingdán gi, ge é kyôshi lé, yò má san kat sû rayuq eq du ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Byu pé yhup myhî tô bum é u lé, yhâng é gyè gi, lé jé mù, guq gàm gyoro má, myoqshi lé sân to hkó luî, taû ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Guq gàm yuq lò mù, guq nhâm htoq lo é hkûn, myoqgàm le bo yuq htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yhumsîng hpô é dui-nhâng zoshâng wuì gi, yhâng chyáng lé jé mù, 'Yhumsîng ê, ge é kyôshi lé za yò má sân tô é a nghut lhú? Myoqgàm pé gi, hkâmai htoq lo é lhú?' ga myi kôjáng, ");
INSERT INTO atbNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","haû yhumsîng hpó gi, 'Gumlau gye èq kut é nghut ri.' ga tû taî ri. Haû jáng, dui-nhâng zoshâng wuì gi, 'Ngamoq, myoq haú pé lé ê nut pyám râ lé, nàng ô nau ri lhú?' ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Haú hkûn, yhang gi, 'Hká nut pyám kó; hkâsu mù gâ le, nungmoq, myoq haú pé lé nut é hkûn, guq gàm pé lé le bo záng nut pyám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kyôshu yoq jé shoq rahá yuq to kó sháng gaq; haú hkûn, myoqgàm pé lé hí hkyin tsîng yù mù, nyhê hkyô pyám râ matú hkyom dîng to luî, guq lé kúm gi, shû yù mù, ngá é chyî má tsing kat to râ matú, kyô shu bang lé ngò taí râ nghut lhê.' ga tû taî ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hau htâng, Yesuq gi, yhangmoq lé gotû dangtú ralhum dum xoq taî é gi; \"Mauhkûng mingdán gi, byù rayuq èq, yhâng hkyâm má hô tô é angshi cham eq wuí ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Angshi cham haû gi, kyômyui jí banshoq htoq má je tiq é nghut kôle, yuq kô lò jáng, hkyâm má hô é mhan-haq hpoqnoq gàm banshoq htoq má je kô é agàm dut lò mù, akoq pé má, maulat nghoq zô pé lé wó zung nô bum lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yhang, gotû dangtú dum xoq taî é gi, \"Mauhkûng mingdán gi, myiwe rayuq èq sungsô mún sum bûng má yu nyhó luî, haú pé banshoq lé wó lhoq dau nhang é múnchi eq wuí ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuq gi, byù moq mó lé, haú pé banshoq dangtú dông mai chyat taî ri; yhangmoq lé, dangtú a bo é haî lháng a taí wú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Haû gi, \"Ngá nhut lé hpóng mù, dangtú dông mai taí râ; mingkan lé sâng-hi hpan é mai zaú tô é hkyô pé lé taî sân kyo râ nghut lhê.\" ga, myiqhtoi dông taî tô é dang lo dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hau htâng má, Yesuq gi, byù moq mó mai htoq ló mù, yhúmhkaû má wang ló ri. Haú hkûn, Yhâng é chángzô pé gi, Yhâng chyáng lé lô kômù, \"Yò mâ é myoqgàm dangtú eq sêng é hkyô lé taî sân kyo laq.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Haû jáng, Yhang tû taî é gi, \"Ge é kyôshi san sû gi, haû Byu Yhangzo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yò gi, mingkan nghut ri; ge é kyôshi gi, mauhkûng mingdán é yhangzô pé nghut akô. Myoqgàm pé kúm gi, haû Tsadán é yhangzô pé nghut akô; ");
INSERT INTO atbNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","haú lé châng hkat sân é gumlau gyè gi, nat Tsadán nghut ri. Kyôshu yoq gi, mingkan htûm é ahkyíng nghut ri; kyô shu bang gi, maumang lagyô pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Haû myoqgàm pé lé, nut yù mù, myi má nyhê pyâm é su, haû mingkan htûm é ahkyíng má dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Haû Byu Yhangzo gi, Yhâng é maumang lagyô pé lé nhâng râ nghut lhê; haû mù, haú bang gi, hkyô lhoq nghoq nhang é bang banshoq eq agè ashop hkyô kut é bang lhunglháng lé, Yhâng é mingdán mai hkyin she htoq yû mù, ");
INSERT INTO atbNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","gyúng nyi é myibung hkyûng hkaû má dú kat pyám kó râ nghut lhê; hau má, ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyì kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Haú hkûn, dingmán bang gi, yhangmoq Yhângwâ é mingdán má buì su duqbó nyî kó râ nghut lhê. Nohkyap dap sû gi, gyô yù sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mauhkûng mingdán gi, yò má haq tô é sutzè eq wuí ri. Sutzè haú lé myang é sû gi, haú lé saî haq to mù, gabú myit èq taû ló luî, yhang wó é banshoq lé ûng pyám mù, yò haú lé wui yu ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Dum, mauhkûng mingdán gi, réng é palhé lé châng ho wún é hpugá hpó eq wuí ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yhang gi, gyai hpaû é palhé lé myàng jáng, yhang wó é banshoq lé ló ûng pyám mù, haú lé wui yu ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mauhkûng mingdán gi, nhông má, ngozo ajà jà lé wó dú nghop yu é gùn eq le wuí ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gùn haú má ngozo byíng jáng, ngo kóng bang gi, wuì yàm má she htoq yû mù, zung to luî, ge é pé lé gi, ngo-pyap má guq kat yû luî, a ge é pé lé gi, dú pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Haû eq rajung za, mingkan htûm é ahkyíng má le, maumang lagyô pé gi, gyó lé lô mù, agè ashop é bang lé, dingmán bâng chyáng mai gam htoq yû luî, ");
INSERT INTO atbNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyì râ nghut é, gyúng nyi é myibung hkyûng hkaû má dú kat pyám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Shí hkyô banshoq lé nungmoq sê gyo bekô lhú?\" gâ ri. Haú hkûn, yhangmoq gi, \"Sê gyo bê.\" ga tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hau htâng, Yesuq gi, yhangmoq lé, \"Mauhkûng mingdán eq séng luî mhoq yû bê é tarâ sará ó nghut kôle, yhang mhoq é hkyô gi, yhumsing é sut-púnglhúng hkaû mai zè sik zè xau lé yu htoq é yhumsîng hpó rayuq eq wuí ri.\" ga dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuq gi, dangtú haú pé lé ban taí jáng, haú jowò mai htoq e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yhang gi, Yhâng é yhummau má jé ló jáng, byu pé lé, yhangmoq é tarajong má mhoqshit ri; haú hkûn, yhangmoq gi, gyô maú byuq kôluî, \"Byù shí yuq gi, hpaqchyî byéng-yá shî eq hpungwup a-tsam mó shí pé lé, hkâmai wó yu é nghut lhê lhà? ");
INSERT INTO atbNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yhang gi, laksîma hpô é yhangzo a nghut lhú? Yhângnû é myìng gi, Mariq gâ lhê a nghut lhú? Yhanggû pé gi, Yakuq, Yosep, Simun eq Yudaq gâ é bang a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yhâng nhammó pé le, nga-nhúng eq rahá nghut nyi lhê a nghut kó lhú? Haû su nghut le nhîng, haú pé banshoq lé, Yhang hkâmai wó yu é nghut lhê lhà?\" ga myî bùm kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yesuq lé myit a ngón dut bùm bekô nghut ri. Yesuq kúm gi, yhangmoq lé, \"Myiqhtoi rayuq gi, yhumsing é yhummau eq yhumsing é yhûm má za, myoqdong a lhaq wó wú é nghut lhê.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yhangmoq lumjíng myit a bò kô é yanmai, Yesuq gi, haú má, laklaí kumlhá myo myo a kut shit lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Haú hkûn, mauzau Herut gi, Yesuq eq sêng é ludang lé wó gyo jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yhâng a-ô mâ é bang lé, \"Shí yuq gi, Wui-myhup Sará Yohan nghut ri-nhung; Yhang gi, shi é mai dum dui toq lo é nghut mù, hpungwup a-tsam haú pé lé wó kut é nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herut haû su gâ é gi, yhanggu Hpilip é yhangmyi Herudiaq é yanmai, Yohan lé chyup tuî yù mù, htóng hkyô pyâm é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hkâsu mù gâ le, Yohan gi, yhang lé, \"Nàng, myiwe haú lé hâng yu é gi, tarâ a wang é nghut lhê.\" ga taí byî nyi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herut gi, Yohan lé sat pyám naû kôlhang, mingbyû wuì lé gyuq é yanmai, a wám sat nghut ri; haî mù gâ le, yhangmoq gi, Yohan lé myiqhtoi tsuq nyî kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nghut kôlhang, Herut é hkû ladu hkyúm buinyì má, Herudiaq é yhangzo byizo gi, yhangmoq é hí má gó shit é lé, Herut gi, gyai yhang wú myit nguì mù, ");
INSERT INTO atbNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","byizo haú lé, yhang haî dung le haî byi râ ga dakam é danggidiq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Byizo haû gi, yhângnu hpaqchyî byî é lé gyô yù mù, \"Shî, bó má, Wui-myhup Sará Yohan é ulhum lé, kat byi laq.\" ga, Herut lé dûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mauzau hpó gi, myit a ngón dut byuq kôlhang, yhang dakam tô é danggidiq é yanmai le, bíng pê é myoqdong lé tê nau é yanmai le, yhang dûng é lé, byi râ matú, ");
INSERT INTO atbNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","htóng hkaû má lúng tô é Yohan é ulhum lé hpyit râ hkunmó hkyô kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yohan é ulhum lé bó má kat luî, myiwe zo haú lé byi jáng, myiwe zo haû gi, haú lé yhângnû chyáng yu ló byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Haû mù, Yohan é chángzô pé gi, yhâng é màng lé lé yû luî, myhup pyám bekô nghut ri. Hau htâng, yhangmoq gi, Yesuq lé ló taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuq gi, haú hkyô lé wó gyo jáng, haû mai lhaî ji mù, tsím tsâm é jowò shut Yhang baú e ló ri. Haú lé, byu pé wó gyô bùm kôjáng, wà mó pé mai htoq lé lô kômù, hkyî hkyô Yhâng htâng châng e ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuq gi, lhaî mai gyó dap ló é hkûn, byù moq mó nyi to láng é lé myàng jáng, yhangmoq lé wú shogyo luî, nò bang lé lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Myinhtâng jé lô jáng, haû chángzô pé gi, Yhâng chyáng lé kômù, \"Shí má gi, tsím tsâm é jowò nghut é htoq agó, buì le gyum ló bê nghut mù, shiwa byu pé gi, wà pé shut ló luî, yhangmoq é matú zôjung ló wó wuî kó sháng gaq, yhangmoq lé nhang kat aq hkoi.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Haú hkûn, Yesuq gi, \"Yhangmoq ló a ra. Nungmoq, yhangmoq lé rajung jung byi tso keq.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Haû su ga jáng, yhangmoq gi, \"Muk ngo long eq ngozo í du za ru wó lhê.\" ga dum tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Haû jáng, Yesuq gi, \"Yu lò keq.\" ga tû taí mù, ");
INSERT INTO atbNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","shiwa byu pé lé, wàhu yò má zùng nhang ri. Hau htâng, Yhang gi, haû muk ngo long eq ngozo í du lé yù mù, mauhkûng shut tu wú to luî, jeju ban hkya-on jáng, muk lé hpê gàm mù, chángzô pé lé byî ri. Haû chángzô pé gi, shiwa byu pé lé gàm byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yhangmoq banshoq bang zô gyî bùm kô é htâng má, haû chángzô pé gi, zô myhit tô é pé lé, raxe í mung byíng shoq wó guq tsîng yu ashî kô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Haú má zô é bang gi, myiwe wuì eq zoshâng wuì lé a nghap lhôm é za, yuqgè baú ngo hkyîng kô bo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuq gi, haû shiwa byu pé lé byo ló nhang nyi é hkûn jáng, chángzô pé lé lhaî má wang ji nhâng mù, tû tap shut dap ló láng nhâng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Shiwa byu pé lé nhang pyâm é htâng má, Yhang gi, kyûdung râ ga, Yhang baú bùm shut doq e ló ri. Myinhtâng chutshúm zó jé shoq, Yhang baú haú má nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Haú u lé, lhaî gi, gin-gau mai tsómra wê é jowò má jé é hkûn, laì tau mut é yanmai, wuìlheng èq gyai yhang lo bat nhûn é hui zô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Htang napsûn maubó zó sum hkyíng eq hkyuq hkyíng gyoro má, Yesuq gi, nhông htoq má so mù, yhangmoq chyáng lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Haû mù, chángzô pé gi, Yesuq nhông htoq má sô nyi é lé myàng kôjáng, gyuq dàn kômù, \"Sobyô ô!\" ga gyuq nán é èq taî garû akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Haû jáng yhang, Yesuq gi, yhangmoq lé, \"Hkâgyuq kó! Ngò ru nghut lhê; myit wum lhoq kíng keq.\" ga nyo kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Haú hkûn, Petruq gi, \"Yhumsîng ê, Nàng yhang ru nghut le gi, ngo lé, wuì htoq mai sô lé lô nhâng laq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Haû jáng, Yesuq gi, \"Lé lô aq.\" ga tû taî kat ri. Haû mù, Petruq gi, lhaî mai gyó mù, wuì htoq mai Yesuq chyáng sô e ló ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nghut kôlhang, yhang gi, laidun htan é lé myang kat jáng, wú gyuq luî, wuì má nop ló nyî mù, \"Yhumsîng ê, ngo lé hkyi yù laq.\" ga wut garû kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesuq gi, radá dâm yhâng é loq lhâm kat luî, Petruq lé lâng zing to mù, \"Lumjíng myit shau sû ê, nàng haî mù úng-âng lhê lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yhangnhik, lhaî má wàng kôjáng, laidun le zîm byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hau htâng, haû lhaî má lúng tô é bang gi, Yhang lé paî gop mù, \"Nàng gi, gè gè yhang, Garai Gasâng é Yhangzo nghut bê.\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yhangmoq gi, gû dap ló kômù, Genesarat mau má jé wang ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Haú mau mâ é bang gi, Yesuq lé wú sé kôjáng, awui ayàm mâ é bang banshoq lé kyô kat akô. Haû mù, byu pé gi, nòhpyo hui bang lhunglháng lé, shuî lé lô kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","nòhpyo hui bang lé, Yhâng é bushi htâng má za lháng záng nhâng râ matú dûng tôngbán akô; Yhang lé záng é lhunglhâng bang gi, lhoq gê byî é huî bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hau htâng má, Hparishe pé eq tarâ sará pé ra-am gi, Yerusalem wà mó mai Yesuq chyáng jé lé lô kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"Náng é chángzô pé gi, haî mù luî, îchyí îwa pê é htûngli lé a cháng kut akô lhú? Yhangmoq gi, loq hí a chî é zang zô akô nghut ri.\" ga, lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Haû jáng, Yesuq tû taî é gi, \"Nungmoq gi, haî mù, nungmoq é htûnglî é yanmai, Garai Gasâng é hkunmó lé a cháng kô é lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hkâsu mù gâ le, Garai Gasang gi, 'Nungmoq é înu îwa lé, hkungga keq.' ga le, 'Înu îwa lé, nhîng é sû ó yuq nghut kôle, sat pyâm é hui râ lhê.' ga le, taî tô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nghut kôlhang, nungmoq taî é gi, 'byù rayuq yuq, yhumsing é yhângnu yhângwa lé byi âng é zè lé, Garai Gasang lé byi râ chyunghuq nghut lhê ga taî é nghut jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","haú yuq gi, yhângwa lé hkungga nó a ra.' gâ akô nghut ri. Haú dông mai, nungmoq gi, nungmoq é htûnglî é yanmai, Garai Gasâng é mungdang lé he-ngik pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gegùn labyoq kut bang ê! Nungmoq eq séng luî, myiqhtoi Esai-aq htoî tô é dang gi, têng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Myiqhtoi dang haû gi, 'Byù shí bang gi, nhut htoq mai za Ngo lé hkunggâ akô; yhangmoq é myit nhiklhum gi, Ngò eq wê gâng nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yhangmoq, Ngo lé noqkuq nyi kô é gi, akôm má za nghut nyi ri; hkâsu mù gâ le, yhangmoq é mhoqshit hkyô pé gi, byù dông mai mhoqshit é hkyô pé za nghut nyi ri.' gâ é nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hau htâng, Yesuq gi, shiwa byu pé lé, Yhâng chyáng wut yù luî, \"Gyô yù mù, sé lo keq. ");
INSERT INTO atbNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nhut má wang lo é haí jung le, byù lé a sanséng dut nhang é a nghut, nhut mai htoq lo é pé sheq, byù lé a sanséng dut nhang é ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Haú hkûn, haû chángzô pé gi, Yhâng chyáng lé lô kôluî, \"Hparishe pé gi, shí hkyô lé wó gyo mù, nhik-yô nyi bùm kô é lé, Nàng sê lhê lhú?\" ga myi kôjáng, ");
INSERT INTO atbNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yhang gi, \"Mauhkûng htoq tsáng myhâng mâ é Ngá Wa a hô tô é agàm hkangmó gi, apûn eq roq nut pyâm é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yhangmoq é yanmai, myit hkâ-myo kó; yhangmoq gi, myoqjit bang nghut kôle, myoqjit é bang lé hkyô-u she é bang nghut akô. Myoqjit yhangchang hkyô-u she lhûm é nghut le gi, í yuq é yhang donghkong má byit gyó kó râ za nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Haú hkûn, Petruq gi, \"Ngamoq lé, dangtú hau é lichyúm taî sân kyo laq.\" ga taí jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuq gi, \"Nungmoq, ahkuî le haû-í yhang go nyi ashi kô luq? ");
INSERT INTO atbNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nhut má wang lo é haí jung le, wamdau hkaû má jé wang ló mù, gungdu mai dum htoq ló é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nghut kôlhang, nhut mai htoq lo é gi, myit nhiklhum mai htoq lo é nghut mù, byù lé a sanséng dut nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Hkâsu mù gâ le, myit nhiklhum mai htoq lo é gi, agè ashop é dông myit é hkyô pé, byù sat é hkyô, su-myi sulàng lú hkyô, ashop é dông gungsho zùm yap é hkyô, hkaû é hkyô, a tengmán é saksé hkâm é hkyô, lumù gansang é hkyô pé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Haû pé gi, byù lé a sanséng dut nhang é hkyô pé nghut ri; loq a chî e za zo shuq é gi, byù lé a sanséng a dut nhang é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hau htâng, Yesuq gi, haú mai Turuq eq Sidun mau shut htoq e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Haú hkûn, haú mau má nyi é Hkanan myiwe myhí rayuq gi, Yhâng chyáng lé jé mù, \"Dawiq é Yhangzo, Yhumsîng ê, ngo lé shogyô yù laq ô! Ngá byizo gi, nat gang wang júng mù, gyai yhang nò gyîn nyi ri.\" ga taî garû ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nghut kôlhang, Yesuq gi, dang rahkun le a tû taí nghut ri. Haû mù, Yhâng é chángzô pé gi, Yhâng chyáng lé jé kômù, \"Myiwe myhí haú lé ló nhang pyám aq; haî mù gâ le, yhang gi, nga-nhûng é htâng má châng garû nyi ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuq gi, \"Byuq byuq é sau pé su nghut nyi é Israelaq byu pê chyáng sheq, Ngo lé nhang kat é ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Haú hkûn, myiwe myhí haû gi, Yhâng é hí má lé mù hkyihput htuq luî, \"Yhumsîng ê, ngo lé garúm yû laq ô!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesuq gi, \"Zô wui chyáng mâ é zoshuq lé yù mù, hkuî pé lé byi tsô é jung a nghut.\" ga tû taí jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","myiwe myhí haû gi, \"Yhumsîng ê, haû kúm nghut ri; nghut kôlhang, hkuî pé lháng, yhumsîng hpô é zohpoq mai gyó é zang cham zang htâng lé, zô akô mhaî.\" ga dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Haû mù, Yesuq gi, \"Myiwe zo ê, náng é lumjíng myit gi, kô nyi ri! Nàng dûng é hkyô lé gyo byi bê nghut lhê.\" ga tû taî ri. Haú hkûn jáng, myiwe myhí hau é byizo le ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuq gi, haú mai htoq ló luî, Galile nhông yàm má ê jé mù, bùm shut doq ló luî, ló zung nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Haú hkûn, byù moq mó gi, hkyî hten bang, myoqjit bang, gung-yùn bang, nhut jit bang eq nò bang gotû myo myo lé shuî lé lô kômù, Yhâng é hkyî wang má lé nyhi to kô é nghut luî, Yhang gi, haú bang lé lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Haû shiwa byu pé gi, nhut jit bang dang wó nyò kô é lé le, gung-yùn bang ge byuq é le le, hkyî hten bang hkyô wó sô é lé le, myoqjit bang myoq wó myang é lé le, myàng kôjáng, wú maú kômù, Israelaq é Garai Gasang lé hkya-ôn bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuq gi, Yhâng é chángzô pé lé wut yù mù, \"Ngò, shí bang lé wú shogyô ri; yhangmoq gi, Ngò eq rahá nghut nyi é sum nyí bò bê, haî le a myàng zo kó nghut ri. Yhangmoq, hkyolat má mut yut ló yut kó abe, yhangmoq zòmut to gû lé, Ngò a nhang kat naù.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Haú hkûn, Yhâng é chángzô pé gi, \"Isû é yoso má nhîng, byù shî myhô bang lé luq shoq byi tso râ zoshuq gi, hkarâ é wó râ lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yhang gi, \"Nungmoq, muk hkâ-myhó long wó akô lhú?\" ga tau myi jáng, yhangmoq gi, \"Muk nyhit long eq ngo-nú zo ratsuí wó lhê.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Haû mù, Yhang gi, byù hpûng lé, myigùng htoq má zùng nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hau htâng, Yhang gi, haû muk nyhit long eq ngozo lé yù mù, jeju ban hkya-on jáng, myhik hpé luî, haû chángzô pé lé byi jáng, yhangmoq gi, byù hpûng lé gàm byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yhangmoq lhunglhâng bang zô gyî bùm kô é htâng má, haû chángzô pé gi, amyit ahtâng lé nyhit mung byíng shoq wó guq tsîng yu ashî kô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Haú hkûn zô é bang má, myiwe wuì eq zoshâng wuì lé a nghap lhôm é za, yuqgè wuì baú myi hkyîng yuq bo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuq gi, byù hpûng lé ló nhang pyâm é htâng má, lhaî má wang ji mù, Magadan mau shut dap e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hparishe pé eq Saduke pé gi, Yesuq chyáng lé jé kômù, Yhang lé chyam wú é dông, mauhkûng mâ é kumlhá kut shit râ matú, dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Haû mù, Yhang gi, yhangmoq lé, \"Nungmoq gi, myinhtâng jé jáng, 'Mau hpong râ nghut lhê, hkâsu mù gâ le, mauhkûng ne ri.' ga le, ");
INSERT INTO atbNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","napkyó lé nghut jáng, 'Hkû-nyí laidun lò râ nghut lhê, hkâsu mù gâ le, mauhkûng nè mù, noq ri.' ga le, lhaq taî akô. Nungmoq gi, mauhkung é isâm lé wú mù sê gam hkoq yû kô é nghut kôlhang, shí ipyat lhê é kumlhá lé gi, a sê gam hkoq yû kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Agè ashop é eq lhum a zuî é ipyat shî gi, limik kumlhá lé ho nyi akô; nghut kôlhang, Yonaq é kumlhá mai lai luî, gotû haî le tûn shit râ a nghut.\" ga taî ri. Hau htâng, Yesuq gi, yhangmoq chyáng mai htoq ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yhangmoq, nhông hé hpoq shut gû dap ló kô é hkûn, haû chángzô pé gi, muk yu chûng râ lé tô-myhî pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Haú hkûn, Yesuq gi, \"Hparishe pé eq Saduke pê é múnchi lé, sidiq luî, koi pyâm nyì keq.\" ga, yhangmoq lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yhangmoq gi, \"Nga-nhúng, muk a yu chung é yanmai, haû su ga taî é nghut ri.\" ga luî, taî lhum bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yhangmoq haû su taî lhûm nyì kô é lé Yesuq sé jáng, yhangmoq lé, \"Lumjíng myit shaû é bang ê, muk a bo é hkyô lé, haî mù taî lhûm nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ahkuî jé shoq, nungmoq gi, a sê gyo shi kó lhú? Muk ngo lông èq byù ngo hkyîng lé byi tsô é htâng, nungmoq hkâ-myhó mung wó dum guq tsîng yù kô é lé le, ");
INSERT INTO atbNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","muk nyhit lông èq byu myi hkyîng lé byi tsô é htâng, nungmoq hkâ-myhó mung wó dum guq tsîng yù kô é lé le, nungmoq a myit bun kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngò gi, muk eq séng luî taî é a nghut é lé, nungmoq, hkâsu mù a sê gyo kô é lhú? Hparishe pé eq Saduke pê é múnchi lé koi pyám keq nghû taî é ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Haú hkûn sheq, Yhang taî é gi, muk má chung é múnchi lé koi pyám râ matú taî é a nghut e za, Hparishe pé eq Saduke pê é mhoqshit hkyô lé koi pyám râ matú taî é ru nghut é lé, yhangmoq sê gyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuq gi, Kesare-Hpilipi wà mó nâm mâ é mau má jé é hkûn, Yhâng é chángzô pé lé, \"Haû Byu Yhangzo gi, ó yuq nghut lhê ga, byu pé taî akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Haú hkûn, yhangmoq gi, \"Ra-am gi, Wui-myhup Sará Yohan ga, góbang gi, Eliyaq ga, dum ra-am gi, Yeremiaq, a nghut jáng, gotû myiqhtoi rayuq yuq nghut ri ga, taî akô.\" ga tû taí kôjáng, ");
INSERT INTO atbNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yhang gi, \"Haû jáng, nungmoq gi, Ngo lé ó yuq nghut lhê nghu akô lhú?\" ga, yhangmoq lé xoq myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Haú hkûn, Simun Petruq gi, \"Nàng gi, rû dui nyi é Garai Gasâng é Yhangzo, Hkrisduq nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Haû mù, Yesuq tû taî é gi, \"Yonaq é yhangzo Simun ê, nàng gi, hkungsô wó nyi ri; hkâsu mù gâ le, nang lé haú hkyô tûn shit é gi, byù mai a nghut, mauhkûng htoq má nyi é Ngá é Îwa mai tûn shit é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ngò, nang lé taí lé, nàng gi, Petruq nghut luî, luqgok shî má, Ngò, Ngá é noqkuq hpúng lé xuq to râ nghut mù, haû moming hkúmdong pé gi, hpúng haú lé wó ûng râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mauhkûng mingdán é zoqshi pé lé, Ngò, nang lé ap byi râ nghut lhê; myigùng htoq má, nàng tuî to má tuî to lé, mauhkûng htoq má le, tuî to râ nghut lhê; myigùng htoq má, nàng lhoq lhut má lhoq lhut lé, mauhkûng htoq má le, lhoq lhut byi râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hau htâng, Yhang Hkrisduq nghut é hkyô lé, ó lé le a taî kyo râ matú, Yhâng é chángzô pé lé taî hkûm kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yesuq gi, Yhang Yerusalem wà mó má ló mù, suwún wuî, hkyangjong agyi pé eq tarâ sará pê é loq má, zing-rî é myo myo hui zo luî, sat pyâm é hui ra râ nghut kôle, sum nyí nghû râ buinyì má, lhoq toq yu é hui râ nghut é hkyô lé, haú hkûn mai, Yhâng é chángzô pé lé taî kyo hi ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Haû mù, Petruq gi, Yhang lé rahkyam shut shuî htoq yû mù, \"Yhumsîng ê, haú hkyô Náng chyáng hkâ-nhám le a dut sháng gaq.\" ga Yhang lé tân ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuq gi, lhing wú kat mù, Petruq lé, \"Tsadán nàng, Ngá chyáng mai hpâng aq! Nàng gi, Garai Gasang eq sêng é hkyô lé a myit e za, byù eq sêng é hkyô lé za myit é sû nghut mù, Ngá é matú myit leqbat jowò nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hau htâng, Yhang gi, Yhâng é chángzô pé lé, \"Ngá htâng cháng naû sû ó yuq nghut kôle, yhumsing gùng yhumsîng he-ngik pyám mù, yhumsing é tapzîng lé waq chûng luî, cháng ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hkâsu mù gâ le, yhumsing é asak lé hkyi yù naù sû ó yuq nghut kôle, asak sum râ nghut lhê; nghut kôlhang, Ngá é yanmai, yhumsing é asak sûm pyâm é sû kúm gi, asak wó yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Byù gi, mingkan gón lé wó sing to kôlhang, yhumsing é asak woi-nyí sûm byuq é nghut le gi, yhang é matú, hai akyû bò râ lhú? Byù gi, yhumsing é asak woi-nyí lé, hai èq wó htaî yù râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Haû Byu Yhangzo gi, Yhâng Wâ é hpungwup shingkang bo é èq, Yhâng Wâ é maumang lagyô pé eq rahá jé lé lô râ nghut lhê; haú hkûn, Yhang gi, yuq hkangmó lé, yhumsîng kut lai bê eq rajung za akyû byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngò, nungmoq lé teng za taí kôlé, ahkuî shí má yap to bang ra-am gi, haû Byu Yhangzo, Yhâng é mingdán eq jé lé lo é lé, a myang é za shî kó râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hkyuq nyí laî htâng má, Yesuq gi, Petruq lé le, Yakuq eq yhanggu Yohan nhiktâng lé le, shuî chûng mù, yhangmoq baú myhang é bùm ralhum má doq ló akô. ");
INSERT INTO atbNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Haú má, yhangmoq é myoq hí tê má, Yesuq é ihpyô isâm htaî byuq mù, Yhâng é myoqdong gi, buì su duqbó tô é eq, Yhâng é mebu gi, maubó su hpyu zan tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Haú hkûn jáng, Mosheq eq Eliyaq gi, yhangmoq é hí má htoq shit mù, Yesuq eq dáng nyo lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Haû mù, Petruq gi, Yesuq lé, \"Yhumsîng ê, shí jowò má nga-nhúng nyi le ge ri. Nàng ô nau é nghut le gi, Náng é matú ralhum, Mosheq é matú ralhum, Eliyaq é matú ralhum kut, ngò zúm sûm lhum saí bá.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petruq dang ru taî nyi ashî le, duqbó é mhut gi, yhangmoq lé htup zíng lô mù, mhut hkaû mai htoq lo é htê gi, \"Shí yuq gi, Ngò chyitdap é Ngá Zo nghut lhê; Yhang má Ngò myit dik nyi lhê. Yhâng é dang gyo keq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Haû su gâ é htê lé, chángzô pé wó gyo kôjáng, yhangmoq gi, gyuq nán mù, myigùng má gop bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nghut kôlhang, Yesuq gi, yhangmoq chyáng jé lé lô mù, yhangmoq lé loq èq záng kat luî, \"Toq keq, hkâgyuq kó.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yhangmoq tu wú kat kô le, Yesuq mai lai luî, ó lé le a myàng lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bùm mai taû gyó lô kô é hkûn, Yesuq gi, \"Ahkuî nungmoq myang é hkyô lé, haû Byu Yhangzo shi é mai lhoq dui toq yu é a hui hui gi, ó lé le hkâtaî kyo kó.\" ga, yhangmoq lé taî hkûm tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Haû jáng, chángzô pé gi, \"Eliyaq hí lé ra râ nghut lhê ga, tarâ sará pé haî mù taí kô é lhú?\" ga, Yesuq lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Haú hkûn, Yesuq gi, \"Eliyaq hí lé luî, lhunglháng lé hen lajâng to râ gâ é gi, têng lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nghut kôlhang, Ngò, nungmoq lé taí kôlé, Eliyaq gi, jé lé bê nghut lhê; nghut kôle, yhangmoq gi, yhang lé a lhom wú sé kômù, yhangmoq ô nau é dông banshoq kut bekô nghut ri. Haû eq rajung za, haû Byu Yhangzo le, yhangmoq é loq má hpuzo râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Haú hkûn sheq, Yhang taî nyi é gi, Wui-myhup Sará Yohan eq sêng é hkyô nghut é lé, haû chángzô pé sê gyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yhangmoq, byù moq mó pê chyáng dum taû jé lô kô é hkûn, byù rayuq gi, Yesuq chyáng lé jé mù, hkyihput htuq luî, ");
INSERT INTO atbNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","\"Yhumsîng ê, ngá é yuqzo lé shogyô yù laq; yhang gi, mhûngtuq tuq luî, gyai yhang jamjaû nyi ri. Myihkyóm má le, wuì má le, anum num lêng wàng wàng dut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yhang lé, Náng é chángzô pê chyáng shuî ê kôlhang, yhangmoq a wó lhoq gê byi kó nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Haû mù, Yesuq gi, \"Lumjíng myit a bo é eq agè ashop é amyû pé ê, Ngò gi, hkâ-myháng jé shoq nungmoq eq rahá nyì mù, wó jân nyì râ lhú? Yuqgè zo haú lé, Ngá chyáng shuî lé lô keq.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesuq gi, nat gang lé tân kat jáng, nat gang haû gi, yuqgè zo haú yuq chyáng mai htoq ló byuq bê nghut mù, haú hkûn jáng, yuqgè zo haû gi, ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hau htâng, chángzô pé gi, ó a nyi é u má, Yesuq chyáng lé lô kômù, \"Ngamoq gi, haî mù, nat haú lé a wó hkat htoq é lhú?\" ga, lé myi kôjáng, ");
INSERT INTO atbNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yhang gi, \"Nungmoq é lumjíng myit shaû é yanmai nghut ri. Ngò, nungmoq lé teng za taí kôlé, nungmoq é lumjíng myit angshi cham í za hkâlháng bò kô é nghut le gi, bùm shî lé, 'Hé shut htot ló aq.' ga taî le, htot râ nghut lhê. Nungmoq a wó kut é haî lháng joq râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Shí jung gi, kyûdung é eq zoshuq gám é dông za a nghut jáng, a htoq ló é nghut lhê.\" ga dum tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yhangmoq, Galile mau má rahá zup nyì kô é hkûn, Yesuq gi, yhangmoq lé, \"Haû Byu Yhangzo gi, byu pê é loq má ap pyâm é hui zo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Haú bang gi, Yhang lé sat pyám kó râ nghut lhê; nghut kôlhang, Yhang gi, shi é htâng sum nyí nghû râ nyí má lhoq dui toq é hui râ nghut lhê.\" ga taî ri. Haû mù, haû chángzô pé gi, gyai yhang gyô yón nyî bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuq eq Yhâng é chángzô pé gi, Kaperna-um wà má jé kô é hkûn, noqkuq yhûm hkansê hkyuî bang gi, Petruq chyáng lé jé kômù, \"Nungmoq é sará gi, noqkuq yhûm hkansê a kat lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petruq gi, \"Kat lhê.\" ga tû taî ri. Hau htâng, Petruq yhúmhkaû má wang ló le, Yesuq hí lhom taî é gi, \"Simun ê, mingkan hkohkam pé gi, kang eq hkansê pé lé, ô pê chyáng mai guq yu akô lhú? Yhumsing byu pê chyáng mai lhú? Haû a nghut jáng, góbâng chyáng mai lhú? Nàng, hkâsu wó myit lhê lhú?\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Haû mù, Petruq gi, \"Góbâng chyáng mai nghut ri.\" ga tû taí jáng, Yesuq gi, \"Haû su nghut le gi, yhumsing byu pé gi, lut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nghut kôlhang, yhangmoq é i-myit a ngón a dut kó sháng gaq, nhông má ê mù, ngo-nhe ê hkyó aq. Sâng-hi wó nhê yu é ngozô é nhut lé lâng há kat jáng, ngùn htingchap rachap lé myàng râ nghut lhê. Haú lé yù mù, Ngá é matú eq náng é matú, yhangmoq lé ló byi aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Haú hkûn, haû chángzô pé gi, Yesuq chyáng lé jé kômù, \"Mauhkûng mingdán má, kô dik sû gi, ó yuq nghut lhê lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesuq gi, zoshâng zo rayuq lé wut yù mù, yhangmoq é gung gûng má shap to luî, ");
INSERT INTO atbNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, nungmoq gi, myit htaî lhik luî, zoshâng zo wuî su dut kô é za a nghut jáng, mauhkûng mingdán má hkâ-nhám le wó wâng kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Haû mù, zoshâng zo shí yuq su, yhumsing é i-myit wó lhoq nyhum é sû ó yuq nghut kôle, mauhkûng mingdán má, kô dik sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Shî sû é zoshâng lé, Ngá é myìng mai hap yu é sû ó yuq nghut kôle, Ngo lé hap yu é sû nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nghut kôlhang, Ngo lé lumjíng é zoshâng wuì mâ é rayuq yuq lé, mara kut shut nhang é sû gi, yhâng é lingzing má luqluí long mó tuî hut byi luî, nik é wuimau má, dú hkyô pyâm é huî é nghut le gi, yhâng é matú je gè râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Haû mingkan gi, byu pé lé mara kut shut nhâng jang joq é yanmai, dingnyé wó ri. Haû mara kut shut nhâng hkyô gi, htoq lugù bê; nghut kôlhang, haú lé lhoq htoq sû gi, dingnyé wó ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Náng é loq èq, a nghut jáng, náng é hkyi èq, nang lé mara kut shut nhang é nghut le gi, haú lé hpyit dú pyám aq. Ahtum abyuq é myi má, hkyî hkúm loq hkúm gû dú hkyô pyâm é hui râ htoq má, hkyî loq a hkûm é za, asak wó yu é nghut le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Náng é myoqjí èq, nang lé mara kut shut nhang é nghut le gi, haú lé lap choq yû mù, dú pyám aq; myoqjí í jí dap gû ngaraî myi má dú hkyô pyâm é hui râ htoq má, myoq rají eq za, asak wó yu é nghut le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Shî sû é zoshâng zo wuî mâ é rayuq lé lháng a wú tiq râ matú, sidiq nyì keq. Hkâsu mù gâ le, Ngò, nungmoq lé taí kôlé, mauhkûng mâ é yhangmoq é maumang lagyô pé gi, mauhkûng htoq mâ é Ngá Wâ é myoqdong lé, hkâ-nhám le myang nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Hkâsu mù gâ le, haû Byu Yhangzo gi, byuq byuq bê bang lé hkyi yù râ matú, jé lé é nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Byù rayuq gi, sau rashô du wó é nghû sháng, sau haú gû mâ é radu byuq byuq é nghut jáng, haû gaú xe gaû du lé, bùm pé má nyhi pyâm to luî, byuq byuq é sau lé a châng ho é nyì râ lhú? Haú lé, nungmoq hkâsu wó myit ngam akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ngò, nungmoq lé teng za taí kôlé, yhang gi, haû byuq byuq é sau haú lé myang ho é hkûn, a lám byuq é sau gaú xe gaû dû é matú gabú é htoq má, haú dû matú je riyhang gabú ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Haû eq rajung za, mauhkûng htoq mâ é nungmoq é Îwa gi, shî tiq bang mâ é rayuq htên byoq byuq râ lé lháng, ô nau é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Náng é gumang hpó, nang lé mara kut shut é nghut jáng, yhâng chyáng ê mù, nungnhik baú za nghut é hkûn, yhâng é mara lé tûn shit aq. Yhang, náng é dang lé gyô é nghut jáng, nàng gi, gumang rayuq dum wó bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nghut kôlhang, yhang, náng é dang lé a gyô é nghut jáng, 'Mara hun é hkyô hkangmó lé, saksé í yuq sum yuq lòm jáng, wó lhoq teng sháng gaq.' gâ tô é eq rajung za, nàng, gotû byù ra-í yuq lé shuî chûng aq. ");
INSERT INTO atbNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yhang gi, haú bâng é dang lé le a lhom yu é nghut jáng, haú hkyô lé, noqkuq hpúng má shit kyo aq; hpûng é dang lé le a gyô é nghut jáng, yhang lé, a lumjíng é byù rayuq dông le, kang guq sû rayuq dông le sôn pyám aq. ");
INSERT INTO atbNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ngò, nungmoq lé teng za taí kôlé, myigùng htoq má, nungmoq tuî to má tuî to lé, mauhkûng htoq má le, tuî to râ nghut lhê; myigùng htoq má, nungmoq lhoq lhut má lhoq lhut lé, mauhkûng htoq má le, lhoq lhut byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ngò, nungmoq lé dum taí kôlé, myigùng htoq má, nungmoq mâ é í yuq myit hui luî, haî lé dung kôlhang, mauhkûng htoq mâ é Ngá Wa gi, haú nhik lé gyo byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Hkâsu mù gâ le, Ngá myîng lé lang luî, í yuq sum yuq zup zîng é jang hkâmá nghut kôlhang, haú bâng é gyoro má Ngò nyi lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Haú hkûn, Petruq gi, Yesuq chyáng huî ê mù, \"Yhumsîng ê, ngá é gumang, ngo lé mara kut shut é nghut le, yhang lé hkâ-myhó dâm mara hkyut byi ra râ lhú? Nyhit dâm jé shoq hkyut byi ra râ lhí?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Haû jáng, Yesuq tû taî é gi, \"Ngò, nang lé taí lé, nyhit dâm za a nghut, nyhit xe nyhit tú dâm hkyut byi râ lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mauhkûng mingdán gi, yhumsing é dui-nhâng zoshâng wui é jihpán lé jep nau é hkohkâm rayuq eq du ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yhang gi, jihpán lé jep hi ló é u lé, yhâng chyáng ngùn wan myo myo chyîn dap to sû lé shuî lé lo akô. ");
INSERT INTO atbNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Haû yhumsîng hpó gi, haú yuq chyîn a wó xap é yanmai, chyîn wó yû râ matú, yhang lé le, yhangmyi lé le, yhangzo banshoq eq yhang wó é zèhkoq banshoq lé le, ûng pyám râ hkunmó hkyô kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Haû mù, dui-nhâng zoshâng haú yuq gi, yhâng é hí má hkyihput htuq luî, 'Ngo lé myit hîng byi shi laq; banshoq lé, ngò xap râ.' ga dûng tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Haû dui-nhâng zôshang é yhumsîng hpó gi, haú yuq lé wú shogyo luî, chyîn banshoq lhut pyám byi mù, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nghut kôlhang, dui-nhâng zoshâng haû gi, htoq ló mù, yhang lé, denari rashô chyîn dap tô é dui-nhâng zoshâng luzúm rayuq lé myàng jáng, haú yuq é lingzing má gyaq myhik zing to mù, 'Ngo lé dap tô é chyîn hân xap aq!' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Haú hkûn, yhâng é luzúm dui-nhâng zoshâng haû gi, yhâng é hí má hkyihput htuq luî, 'Ngo lé myit hîng byi shi laq; ngò xap râ.' ga dûng tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nghut kôlhang, yhang gi, a gyo byî e za, yhâng é chyîn dum wó xap é hkûn jé shoq, haú yuq lé htóng hkyô pyám nhâng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gotû dui-nhâng zoshâng wuì gi, haú hkyô lé myàng kôjáng, i-myit wú nô kôluî, yhangmoq é yhumsîng hpó lé, haú hkyô banshoq ló taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Haû mù, haû yhumsîng hpó gi, dui-nhâng zoshâng haú lé wut hâng yù mù, 'Agè ashop é dui-nhâng zoshâng ê, nàng, ngo lé dûng tôngbán é yanmai, nàng, ngo lé dap é chyîn banshoq lé, ngò lhut pyám byi bê nghut lhê mhaî. ");
INSERT INTO atbNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Haû su é nhîng, ngò, nang lé shogyô yu é su, náng é luzúm dui-nhâng zoshâng lé, nàng ge shogyô yu lhê a nghut lhú?' ga taí luî, ");
INSERT INTO atbNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","yhang gi, nhikjum yo mù, yhâng é chyîn ban xap é hkûn jé shoq, jamjau hui zo râ matú, yhang lé, htóng suwún pê chyáng ap byî pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nungmoq é gumang wuì lé, nungmoq é myit mai mara a wó hkyut byi kô é nghut jáng, mauhkûng htoq tsáng myhâng mâ é Ngá Wa le, nungmoq lé haú dông kut râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuq gi, mhoqshit é dang haú pé lé ban taí jáng, Galile mau mai htoq ló mù, Yodan làng tû tap mâ é Yuda mau má ê jé ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Byù moq mó gi, Yhâng htâng cháng kô é nghut mù, Yhang gi, haú bang mâ é nòhpyo hui bang lé, haú má lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Haú hkûn, Hparishe pé ra-am gi, Yhâng chyáng lé jé kômù, Yhang lé chyam wú é dông, \"Byù rayuq gi, hai hkyô mai nghut nghut, yhumsing é yhangmyi lé lhoq kâng pyâm le, tarâ wang lhê lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Haû jáng, Yhang tû taî é gi, \"A-nham sâng-hi lé, Hpân Sû, 'byu hpan é hkûn, yuqgè eq myiwe lé hpan é nghut lhê.' ");
INSERT INTO atbNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Hau é yanmai, yuqgè gi, yhumsing é înu îwâ chyáng mai htoq luî, yhangmyi eq rahá rading ralhum za kut nyî mù, yhangnhik gi, gungsho ralhum za dut byuq kó râ nghut lhê.' ga kâ tô é lé, nungmoq a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Haû mù luî, yhangnhik gi, í yuq a nghut lô e za, rayuq za dut bê nghut ri. Haû mù luî, Garai Gasang lhoq tsûm tô é lé, byù gi, a lhoq kang sháng gaq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Haú hkûn, yhangmoq gi, \"Haû lé nhîng, yuqgè rayuq gi, lhoq kang laiká za ká byi mù, yhangmyi lé wó nhang pyâm lhê ga, haî mù, Mosheq, hkunmó hkyô tô lhê lhú?\" ga, Yhang lé dum taû myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Haû mù, Yesuq gi, \"A-nham sâng-hi mai gi, haú dông a nghut. Nghut kôlhang, nungmoq é myit nhiklhum htân kô é yanmai, nungmoq é yhangmyî pé lé lhoq kang râ ahkáng, Mosheq byî tô é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngò, nungmoq lé taí kôlé, sulàng lú é za a nghut jáng, yhumsing é yhangmyi lé kâng pyám mù, myiwe gotû dum hâng yu é sû ó yuq nghut kôle, su-myi lú é sû dut bê.\" ga, yhangmoq lé dum tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Haú hkûn, haû chángzô pé gi, \"Myi làng hkyô má haú dông ru nghut le gi, a yu le lháng je ge nyo ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Haû mù, Yesuq gi, \"Yuq hkangmó gi, dang haú lé wó hap yu é a nghut, wó hkâm râ jeju wó é bang za sheq, wó hap yu é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Byù ra-am gi, înû unghkaû mai yhang, yuqgè a jé gû hku lé lo é bang nghut akô; ra-am gi, góbâng èq kut é yanmai, yuqgè a jé dut byuq akô; ra-am nghut jáng, mauhkûng mingdán é matú, yuqgè a jé râ dông kut yu pyâm akô nghut ri. Shí hkyô lé wó hap yù sû gi, hap yù sháng gaq.\" ga dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hau htâng, Yesuq mai zoshâng wui htoq má loq ke mù, shimân byi sháng gaq ga, zoshâng wuì lé Yhâng chyáng shuî lé lo akô. Haû chángzô pé kúm gi, haû shuî lé lô bang lé lhom tân hkûm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nghut kôlhang, Yesuq gi, \"Haû zoshâng wuì lé, Ngá chyáng lé nhâng keq; yhangmoq lé hkâhkûm zing to kó; hkâsu mù gâ le, mauhkûng mingdán gi, haû sû é bâng é mingdán ru nghut lhê.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yhang gi, zoshâng wui htoq má loq ke shimân byi mù, haú jowò mai htoq ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Byù rayuq gi, Yesuq chyáng lé jé mù, \"Sará ê, ahtum abyuq é asak wó yû râ matú, ge é muzó haî kut ra râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Haû jáng, Yesuq gi, \"Ge é hkyô eq séng luî, haî mù Ngo lé myî lhê lhú? Ge é Sû gi, rayuq za nyi lhê. Nàng, asak dui é má wàng nau é nghut le gi, jep é tarâ pé lé cháng aq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Haú yuq gi, \"Hká gû lé lhú?\" ga dum myi jáng, Yesuq gi, \"'Byù hkâsat, su-myi hkâlú, hkâhkau, a teng a mán é saksé hkâhkám, ");
INSERT INTO atbNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nángnu nángwa lé hkungga aq,' ga le, 'náng gûng lé nàng chyitdap e su, náng é chyangnâm mâ é bang lé le chyitdap aq.' ga le bo tô ri.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Haú hkûn, zorâm hpó haû gi, \"Haú pé banshoq lé, ngò cháng bê nghut lhê; haî kut râ ashî lhú?\" ga dum taû myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuq gi, \"Nàng, gumjup sû dut nau le gi, ló mù, nàng wó é sutzè pé lé ûng pyám luî, myùng bang lé byî pyám aq; haû jáng, nàng, mauhkûng htoq má sutzè wó râ nghut lhê; haû mù, Ngá htâng lé cháng aq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Zorâm hpó haû gi, sutzè gyai wó sû nghut é yanmai, dang haú lé wó gyo jáng, gyai yhang myit a ngón é èq ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hau htâng, Yesuq gi, Yhâng é chángzô pé lé, \"Ngò, nungmoq lé teng za taí kôlé, sutzè wó bang gi, mauhkûng mingdán wó wâng râ gyai yhang wuî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hau htoq agó, Ngò, nungmoq lé taí kôlé, sutzè wó sû rayuq, Garai Gasâng é mingdán má wó wâng râ htoq, gola-uq radu âpno mai wó wang lai râ gi, je luì râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Haû chángzô pé gi, haû su gâ é lé wó gyo kôjáng, haû ru nghut le gi, ó yuq za hkyi yu é hui râ nghut lhê lhú?\" ga Yhang lé myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Haú hkûn, Yesuq gi, yhangmoq lé wú kat mù, \"Haú hkyô lé byù mai gi, wó kut râ a nghut; nghut kôlhang, Garai Gasang gi, lhunglháng lé wó kut é Sû nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Haú hkûn, Petruq gi, Yhang lé, \"Ngamoq gi, wó é gû lhunglháng lé tô pyâm to luî, Náng htâng cháng bê nghut lhê. Ngamoq, haî wá wó râ nghut lhê lhú?\" ga myî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Haû mù, Yesuq tû taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, lhunglháng lé asik dum saî dut nhang é má, haû Byu Yhangzo gi, Yhâng é hpungwup bo é hkohkâm-tanghkuq má zùng tô é hkûn, Ngá htâng châng é bang nungmoq le, hkohkâm-tanghkuq raxe í lhûm htoq má zùng to kômù, Israelaq amyû raxe í hú lé jéyáng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ngá é yanmai, yhumsing é yhûm, nhiktâng wuì, înu îwa, zo dù wuì eq yò pé rajung jung lé tô pyâm tô é sû ó yuq nghut kôle, rashô tú akyû myo jat shoq wó râ nghut é htoq agó, ahtum abyuq é asak le, wó yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nghut kôlhang, hí nghut nyi é bang myo myo gi, htâng gyó byuq kó râ nghut mù, htâng gyó nyî bang yuq gi, hí bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hkâsu mù gâ le, mauhkûng mingdán gi, yhumsing é tsibyiq hkyâm má mû zui nhâng râ langchyáng ê lûng râ ga, napsûn noq le htoq e ló é hkyâm yhumsîng eq du ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yhang gi, ra-nyí é matú denari rachap byi râ dông, haú bang eq myit huî yù mù, yhangmoq lé, yhâng é tsibyiq hkyâm má nhang hâng kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Napkyó gau hkyíng kô má, yhang gi, htoq e ló le, hai mû le a kut é za, gaì má yap tô é bang ra-am lé ê myang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Haû mù, yhang gi, haú bang lé, 'Nungmoq le, ngá é hkyâm má mû ê zui keq; byi âng é ahpau, ngò, nungmoq lé byi râ nghut lhê.' ga taí jáng, yhangmoq gi, e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hau htâng, yhang gi, raxe í hkyíng má le, myinhtâng sum hkyíng kô má le, dum htoq ê mù, haû eq rajung za langchyâng pé ê lung kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Myinhtâng ngo hkyíng kô má, yhang dum htoq e ló wú le, góbang ra-am le yap tô bum é lé, ê myâng mù, haú bang lé, 'Nungmoq gi, haî le a kut é za, ra-nyí buî haî mù shî má yap tô bum akô lhú?' ga myi jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","haú bang gi, 'Ngamoq lé, ó yuq èq le a lùng kô é yanmai nghut lhê.' ga tû taî akô. Haú hkûn, yhang gi, 'Nungmoq le, ngá é hkyâm má mû ê zui keq.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Myinhtâng jé jáng, tsibyiq hkyâm yhumsîng gi, yhâng é mû shuî u sû lé, 'Haû langchyâng pé lé ji yù mù, je htâng má lung yu é bang mai hî luî, sâng-hi lung yu é bang jé shoq, mû zui hpau byi aq.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Myinhtâng ngo hkyíng má mû wàng bang le, denari rachap chap wó yu bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Haû mù, je hí má mû wàng bang gi, yhangmoq je myo wó nhô ngam akô. Nghut kôlhang, yhangmoq le, rayuq denari rachap chap za wó akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yhangmoq gi, haú myhó za wó yu bùm kô é yanmai, haû hkyâm yhumsîng lé, ");
INSERT INTO atbNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Shí bang gi, je htâng má mû lé wâng mù, nayí rahkum za mû zui kôlhang, nàng gi, ra-nyí buigyùm chap buì htân yò má mû zuî é bang ngamoq eq rajung za byî ri.' ga mara hûn dang taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nghut kôlhang, haû hkyâm yhumsîng gi, haú bang mâ é rayuq lé, 'Buinùm hpó ê, ngò, nang lé a tarâ é dông kut é a nghut. Denari rachap byi râ nghû, nàng eq ngò myit huî to bê a nghut lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nàng wó âng é lé yu chûng mù, ló aq. Je htâng má mû lé wang é sû lé le, nang lé byî é myhó, ngò byí nau ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngá é ngùn lé, ngò kut nau é su a ge kut lhú? Ngò, ge é kut le, nàng manôn ri lhú?' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Haû mù luî, htâng gyó nyî bang gi, hí bekô râ nghut mù, hí nghut nyî bang gi, htâng gyó byuq kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ahkuî, Yesuq gi, Yerusalem wà mó shut doq ló nyi é u lé, haû chángzo raxe í yuq lé, gotû kut wut yù mù, ");
INSERT INTO atbNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","\"Nga-nhúng gi, Yerusalem wà mó shut doq ló nyi lhê; haû Byu Yhangzo gi, hkyangjong agyi pé eq tarâ sará pê é loq má ap byî pyâm é hui râ nghut lhê; haú bang gi, Yhang lé, shî râ mara byi kó râ nghut é htoq agó, ");
INSERT INTO atbNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jóng pyâm é, nhuq bat é eq tapzîng má jén sat pyâm é hui râ matú, haû tûngbaù pê é loq má ap pyám kó râ nghut lhê. Nghut kôlhang, Yhang gi, sum nyí nghû râ buinyì má, lhoq dui toq é dum hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hau htâng má, Zebedi é yhangzô nhiktang é yhângnu gi, yhangzô nhik eq rahá jé lé lô kômù, rajung dung râ matú, Yesuq é hí má hkyihput htuq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Haû mù, Yesuq gi, \"Nàng, haî ô nau ri lhú?\" ga yhang lé myi jáng, yhang gi, \"Náng é mingdán má, shî ngá zô nhiktâng lé, Náng é loqyò hkyam má rayuq, loqpaî hkyam má rayuq kut, zùng râ ahkáng byi laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Haú hkûn, Yesuq gi, \"Nungnhik haî dûng nyi é lé, nungnhik a sé kó nghut ri. Ngò shuq râ góm lé, nungnhik wó shuq kó râ lhú?\" ga myi jáng, yhangnhik tâng gi, \"Wó shuq lhê.\" ga tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Haû mù, Yesuq gi, yhangnhik lé, \"Ngò shuq râ góm lé, nungnhik shuq ra kó râ za nghut lhê. Nghut kôlhang, Ngá é loqyò, loqpaî hkyam má zùng râ ahkáng lé gi, Ngò byî jung a nghut. Jowò haú pé gi, Ngá Wa hen to byi bâng é matú za ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gotû chángzo raxê yuq gi, haú hkyô lé wó gyo kôjáng, haú nhiktâng lé nhik-yô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Haû mù, Yesuq gi, yhangmoq banshoq bang lé wut tsîng yù luî, \"Tûngbaù pé lé uphkang é ga bang gi, tûngbaù pé lé up zô nyì kô é hkyô lé le, haû eq rajung za, yhangmoq é ming up suwún wuî le, yhumsing é ahkáng ayá lé chûng mù, up zô nyì kô é hkyô lé le, nungmoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nungmoq chyáng gi, haû su a dut kó sháng gaq; haû Byu Yhangzo lháng gi, dojaú é lé hkam yù râ matú jé lé é a nghut é za, dojaú râ matú eq byù myo myô é matú, shîhtaí gunglik hkungga dông, Yhâng é asak lé byi pyám râ matú sheq, jé lé é ru nghut é su, ");
INSERT INTO atbNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nungmoq má, byù mó dut naù sû ó yuq nghut kôle, nungmoq é dui-nhâng zoshâng dut ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hau htoq agó, nungmoq má ushuq dut naù sû ó yuq nghut kôle, nungmoq é jùn dut ra râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesuq eq Yhâng é chángzô pé gi, Yerihko myuq mai htoq ló nyî kô é hkûn, byù moq mó gi, yhangmoq é htâng má châng e ló bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Haû hkyô yàm má zung tô é myoqjit í yuq gi, Yesuq laî ló nyi é hkyô lé wó gyo kôjáng, \"Dawiq é Yhangzo, Yhumsîng ê, ngá-nhik lé shogyô yù laq ô!\" ga, wut garû kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Byù moq mó gi, yhangnhik zîm byuq râ matú tân hkúm kôlhang, yhangnhik gi, \"Dawiq é Yhangzo, Yhumsîng ê, ngá-nhik lé shogyô yù laq ô!\" ga, je riyhang htê mó èq wut garû kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Haû mù, Yesuq gi, yap kat mù, \"Ngò, nungnhik lé haî kut byi râ ô nau akô lhú?\" ga, yhangnhik lé wut myî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Haú hkûn, yhangnhik gi, \"Yhumsîng ê, ngá-nhik myoq myàng nau ri.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuq gi, yhangnhik lé wú shogyo luî, yhangnhik é myoqjí má ê záng byî ri. Haú hkûn jáng, yhangnhik gi, myoq wó myâng kômù, Yhâng htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesuq eq Yhâng é chángzô pé gi, Yerusalem wà mó eq chyâng lo nyì kô é hkûn, Tsanlun Bùm mâ é Bethpage wà má jé ló kôjáng, Yesuq gi, chángzo í yuq lé, ");
INSERT INTO atbNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","\"Nungnhik, hí mâ é wà má ê keq; wà haú má, logúng zîng radu lé, logúng zo eq rahá tuî to láng é lé, ê myâng kó râ nghut lhê; haú lé hpyi yù mù, Ngá chyáng she lò keq. ");
INSERT INTO atbNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Byù rayuq yuq, nungnhik lé rajung jung gâ lò jáng, 'Shî í du lé, haû Yhumsîng chûng râ ri.' gâ nghû tû taí keq; haû jáng, yhang, radá dâm nhâng byi râ nghut lhê.\" ga Yesuq taí luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Haû gi, myiqhtoi dang lhoq dik râ matú dut lo é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Myiqhtoi dang haû gi, \"Zi-un byizo lé, shî su nghû keq; 'Wú aq, náng é hkohkâm gi, nú-nhâm é myit eq logúng htoq má ji mù, nghut bê, logúng zo htoq má ji mù, náng chyáng lé lô bê nghut ri.'\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Haû chángzô nhik gi, e ló mù, Yesuq taî kat é eq rajung za ê kut bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yhangnhik gi, logúng me lé she lò mù, yhangnhik é buhîng pé lé, haû logúng mê é htoq má ke byi kôjáng, Yesuq gi, doq jî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Byù moq mó mâ é myo myo gi, yhangmoq é buhîng lé, hkyô má hkyut hkang byî akô; ra-am gi, mhandíng pé lé zân hkyô yù mù, hkyô má hkang byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yhâng é hí má htâng má châng sô nyi bum é bang gi, \"Dawiq é Yhangzo gi, hosana nghut nyî sháng gaq ô!\" \"Haû Yhumsing é myìng mai jé lé lô Sû gi, hkungsô wó nyî sháng gaq ô!\" \"Htoq tsáng myhâng má, hosana nghut nyî sháng gaq ô!\" ga luî, taî garû bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuq, Yerusalem wà mó má wang ló é hkûn, rawà gón é bang gi, gabyông lo bùm kômù, \"Shí yuq gi, ó wá nghut lhê lhà?\" ga luî, myi lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Haú hkûn, byù moq mó gi, \"Shí yuq gi, Galile mau, Nazaret wà byù Yesuq gâ é myiqhtoi nghut lhê.\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuq gi, noqkuq yhûm má wang ê mù, haú mâ é zè ung zè wuì kut nyi é bang banshoq lé, hkat htoq pyám luî, ngùn htaí zo bâng é siboî pé eq hpûngkyui ung zo bâng é tanghkuq pé lé, tu mhuq pyám byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Haú hkûn, Yhang gi, \"'Ngá yhûm gi, kyûdung yhûm ga râ nghut lhê.' ga kâ to kôlhang, nungmoq gi, jowò shî lé 'damyaq hkyûng' kut nyi akô.\" ga, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesuq, noqkuq yhûm má nyi tô é hkûn, myoqjit bang eq hkyî hten bang Yhâng chyáng lé lô kômù, Yhang gi, haú bang lé lhom lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nghut kôlhang, hkyangjong agyi pé eq tarâ sará pé gi, Yhang kut é mauhpo muzó pé lé le, \"Dawiq é Yhangzo gi, hosana nghut sháng gaq.\" ga, noqkuq yhûm má zoshâng wuì garû nyi bùm kô é lé le, myàng kôjáng, wú nhik-yô bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Haû mù, yhangmoq gi, \"Zoshâng shí bang haî taî nyì kô é lé, Nàng wó gyô lhê lhú?\" ga, Yesuq lé myi kôjáng, Yhang gi, \"Wó gyô ri. Nungmoq gi, 'Zoshâng wuì eq nyheqnú pê é nhut mai hkya-on kungtôn râ matú, nàng lajâng to bê nghut ri.' ga kâ tô é lé, Chyúmdang má a nghap wú kó lhú?\" ga yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hau htâng má, Yhang gi, haú bang lé nyhi to luî, wà hkaû mai htoq ló mù, Behtani wà má ê jé luî, haú myîn, haú má bíng yu ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yhang gi, htang napkyó noq le, Yerusalem wà mó shut dum taû ló é hkûn, hkyô má zòmut hui bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Haû mù, Yhang gi, hkyô yàm má yuq tô é maihpáng gâm lé myang kat mù, chyâng e wú le, ahaq mai lai luî, haî lé le a myàng nghut ri. Haû mù, Yhang gi, shigâm haú lé, \"Nàng má, hkâ-nhám le ashi a zui sháng gaq.\" ga taî kat ri. Haú hkûn jáng, agàm haû gi, nyhuî kyuq shi ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Haû chángzô pé gi, haú lé myàng kôjáng, maú byuq kômù, \"Maihpáng gâm shî gi, haî mù haû-í hân nyhuî kyuq shi ló lhê lhà?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuq gi, \"Ngò, nungmoq lé teng za taí kôlé, nungmoq, úng-âng é myit a bo é za, lumjíng kô é nghut le gi, maihpáng gâm má Ngò kut é muzó lé, nungmoq wó kut kó râ nghut é htoq agó, bùm shî lé, 'Htot mù, wuimau má ló gyó wâng aq.' ga taí jáng, taî é eq rajung za dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nungmoq, lumjíng myit èq dung kô é nghut jáng, haî dûng le le wó yû kó râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuq gi, noqkuq yhûm wàng hkaû má wang ê mù, mhoqshit nyi é hkûn, hkyangjong agyi pé eq mingbyu é suwún wuî gi, Yhâng chyáng lé jé kômù, \"Hai ahko ahkâng èq, Nàng, shí pé lé kut nyi lhê lhú? Ahko ahkáng shî, Nang lé ó yuq byî é lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Haú hkûn, Yesuq gi, \"Ngò le, nungmoq lé rajung myî wú kôlé, nungmoq wó tû taí kô é nghut jáng, hai ahko ahkâng èq, Ngò, shí pé kut é hkyô lé taî kyo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohan byî é baptisma gi, ó yuq é ahko ahkáng mai nghut lhê lhú? Mauhkûng mai lhú? A nghut jáng, byu chyáng mai lhú?\" ga taû myî kat ri. Haú hkûn, yhangmoq, chôm hpyê lhum kô é gi, \"'Mauhkûng mai nghut lhê.' nghû, nga-nhúng taí jáng le, 'Haû nghut le nhîng, haî mù, yhang lé a lumjíng kô é lhú?' ga râ nghut; ");
INSERT INTO atbNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'Byu chyáng mai nghut lhê.' nghû jáng le, yhangmoq lhunglhâng bang gi, Yohan lé, myiqhtoi rayuq ga lumjíng bûm kô é nghut lhê yanmai, haú bang lé, nga-nhúng gyuq râ lhê nghut.\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Haû mù, yhangmoq gi, Yesuq lé, \"Ngamoq a sé.\" ga tû taî akô. Haú hkûn, Yesuq gi, \"Haû jáng, Ngò le, hai ahko ahkâng èq shí pé kut é hkyô lé, nungmoq lé a taî kyo.\" ga, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuq xoq taî é gi, \"Nungmoq hkâsu wó myit akô lhú? Byù rayuq gi, yuqzo í yuq wó ri. Yhang gi, ko sû yuq chyáng ê mù, 'Ngá zo ê, nàng, hkû-nyí tsibyiq hkyâm má mû ê zui aq.' ga taí jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","yuqzo haû gi, 'Ngò a kâm ê.' ga tû taî ri; nghut kôlhang, htâng má, yhang gi, myit dum lhîng mù, ê bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hau htâng, yhângwa gi, yhang zo tiq sû yuq chyáng ê mù, rajung za ga ê dum taí jáng, yuqzo haû gi, 'Ê râ, âwa!' ga yín yû kôlhang, a ê kut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Haú nhiktâng mâ é hká yuq sheq, yhângwa ô nau é hkyô lé kut sû nghut ri lhú?\" gâ ri. Haú hkûn, yhangmoq gi, \"Ko sû nghut ri.\" ga tû taî akô. Haû mù, Yesuq gi, yhangmoq lé, \"Ngò, nungmoq lé teng za taí kôlé, kang guq bang eq shiwa myhî pé gi, Garai Gasâng é mingdán má, nungmoq a wàng shimá, wang ló nyi bùm kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hkâsu mù gâ le, Yohan gi, nungmoq chyáng lé jé mù, dingmán hkyô lé tûn shit kôlhang, nungmoq gi, yhang lé a jíng kut akô nghut ri; nghut kôlhang, haû kang guq bang eq shiwa myhî pé gi, yhâng dang lé jíng akô nghut ri. Nungmoq gi, haú hkyô lé myang é nghut kôlhang, myit a lhîng kô é htoq agó, yhang lé a lumjíng shi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Gotû dangtú lé gyô wú shi keq; hkyâm yhumsîng rayuq gi, tsibyiq hkyâm ralhum saî to mù, lhînghkyuq kyâm to luî, tsibyiq wing pyik htoq râ donghkong dû to mù, machya ralhum saî tô ri. Hau htâng, yhang gi, hkyâm haú lé, hkyâm saí zo bâng chyáng ngho byî to mù, gó ming shut e ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kyôshu yoq jé jáng, yhang gi, yhang eq sêng é tsibyiq shi ê yû râ matú, yhâng é dui-nhâng zoshâng wuì lé, haû hkyâm saí zo bâng chyáng nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Haû hkyâm saí zo bang gi, dui-nhâng zoshâng wuì lé, lhom chyup yû kômù, rayuq lé gi, lhom nhuq bat, rayuq lé gi, lhom sat pyám, rayuq lé gi, luqgok èq lhom dú sat pyám, kut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hau htâng má, yhang gi, hî dam lhê htoq je myo shoq gotû dui-nhâng zoshâng wuì lé dum nhang kat le le, haû hkyâm saí zo bang gi, hí lhê bang lé su lhom dum kut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ló htáng má, yhang gi, 'Ngá zo lé gi, yhangmoq lhom hkungga kó râ nghut lhê.' ga, yhang zo lé, haú bâng chyáng nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nghut kôlhang, haû hkyâm saí zo bang gi, yhang zo lé myàng kôjáng, 'Shí yuq gi, silí wunlí sing yù râ sû nghut lhê; lé keq, yhang lé sat pyám mù, yhâng é silí wunlí lé yu pyám byi sháng.' ga, rayuq eq rayuq taî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Haû mù, yhangmoq gi, yhang lé, chyup yû luî, hkyâm shinggan shut dú htoq kômù, sat pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Haû mù luî, tsibyiq hkyâm yhumsîng lé jé é hkûn lé, haû hkyâm saí zo bang lé hkâsu kut nhô ngam akô lhú?\" ga Yesuq myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Haú hkûn, haû hkyangjong agyi pé eq suwún wuî gi, \"Haû agè ashop bang lé gi, agè ashop é dông sat pyám râ nghut lhê. Haû tsibyiq hkyâm lé gi, kyô shu yoq má, yhâng é gambùm lé byi râ bang lé, htot ngho byî pyám râ nghut lhê.\" ga, tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Haû jáng, Yesuq dum taî é gi, \"Chyúmdang má, 'Yhûm saí bâng èq hkyin htoq pyâm é luqgok gi, htungchyûn mâ é ahkyak dik é luqgok dut bê. Shí hkyô gi, haû Yhumsîng kut é nghut luî, nga-nhûng é myoq hí má mauhpo dut bê nghut ri.' ga bo tô é lé, nungmoq a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Haû mù, Ngò, nungmoq lé taí kôlé, Garai Gasâng é mingdán lé, nungmoq chyáng mai yù mù, hau é ashi wó zui râ byuhú lé byî pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Luqgok haú má gyó záng é sû gi, gyuî gyop byuq râ nghut lhê. Luqgok hau èq gyó nhê záng é sû le, nhê pyeq pyâm é hui râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hkyangjong agyi pé eq Hparishe pé gi, haû Yesuq taî é dangtú pé lé wó gyo kôjáng, yhangmoq lé taî nyi é hkyô lé, sê gyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Haû mù, yhangmoq gi, Yhang lé chyup yû râ hkyô ho nyi akô; nghut kôlhang, byu pé gi, Yhang lé, myiqhtoi rayuq ga myit lum to kô é yanmai, yhangmoq gi, haú bang lé gyuq akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuq, dangtú pé dông yhangmoq lé dum taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","\"Mauhkûng mingdán gi, yhumsing yhangzô é matú myiháng poî hen lajâng to byî é hkohkâm rayuq eq du ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hkohkâm hpó haû gi, yhang ji tô é bang, haû poî má lé lô râ matú, yhâng é dui-nhâng zoshâng wuì lé ê tsing taí nhang ri; nghut kôlhang, haú bang gi, a lé kut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hau htâng má, yhang gi, gotû dui-nhâng zoshâng wuì lé, 'Ngò haî le hen to bê; ngá é no eq xu-myum é gau-nyhaú pé lé sat mù, jung hkangmó rì rì nghut to bê. Myiháng poî má lé lò keq hkoi nghû, haû ji tô é bang lé ê taí keq.' ga pyîng luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nghut kôlhang, haû ji to huî é bang gi, dang haú lé haî su a gyô ngàm kômù, rayuq gi, yohtung shut, rayuq gi, hpugá dinggá hkyô shut ê byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ra-am dum nghut jáng, yhâng é dui-nhâng zoshâng wuì lé lhom chyup yû kômù, nhuq bat luî, sat pyám byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Haû mù, hkohkâm gi, nhikjum yo luî, yhâng é gyezô pé lé, haû byù sat bang lé sat pyám nhâng mù, yhangmoq é myuq lé nyhê hkyô pyám nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hau htâng má, yhang gi, yhâng é dui-nhâng zoshâng wuì lé, 'Myiháng poî gi, rì rì nghut to bê; nghut kôlhang, haû ji to huî é bang gi, lé râ a gingdán kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Haû mù, hkyô kang pé má ê luî, myang é yuq hkangmó lé, poî má lé râ matú ê jî keq.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Haû jáng, dui-nhâng zoshâng haú bang gi, hkyô kang pé má htoq ê luî, myang é byù gè byù gang lhunglháng lé ji tsîng yù kô é nghut mù, myiháng poî gi, bíng pé zung byíng bùm bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nghut kôlhang, bíng haú bang lé, hkohkâm hpó, lé wang wú é hkûn, myiháng poî wàng hking a wut tô é byù rayuq lé, yhang byu-myang ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Haû mù, yhang gi, haú yuq lé, 'Buinùm hpó ê, nàng gi, myiháng poî wàng hking le a wut é nhîng, shí má hkâsu kut wang lo é lhú?' ga myi jáng, haú yuq gi, haî le a dat tû taí lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Haú hkûn, hkohkâm hpó gi, yhâng é dui-nhâng zoshâng wuì lé, 'Yhâng é hkyî loq má tui luî, haû ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyì râ nghut é shinggan mauchut hkaû má, dú htoq pyám keq.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hkâsu mù gâ le, byù myo myo gi, ji yu é hui kôlhang, hkyin yù huî é bang gi, shaû ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hau htâng má, Hparishe pé gi, htoq ló kômù, Yhâng é dang pé má mara chyup râ hpaqchyî dâ akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yhangmoq gi, Herut é byu pé eq rahá, yhangmoq é chángzô pé lé, Yesuq chyáng nhang kat akô. Haú bang gi, Yesuq chyáng lé jé kômù, \"Sará ê, Nàng gi, tengmán sû nghut é eq, Garai Gasâng é hkyô lé, tengmán é dông mhoqshit é sû nghut é lé le, Nàng gi, ó haî ga râ lé le haî su a ngàm sû nghut é yanmai, ó yuq é myoqdong lé le a tê byi sû nghut é hkyô lé le, ngamoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Haû mù, hkoséng Kehtaq lé kang kat byî le gi, ge lhê lhú? A gè lhú? Nàng, hkâsu wó myit é hkyô taî kyô wú aq.\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesuq kúm gi, yhangmoq é agè ashop hkyô lé sé byi mù, \"Gegùn labyoq kut bang ê, nungmoq gi, haî mù, Ngo lé lé chyam wú akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kang kat râ ngùn htingchap rachap, Ngo lé byî wú keq.\" ga taî kat ri. Haú hkûn, yhangmoq gi, denari rachap yù byî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Haû mù, Yhang gi, yhangmoq lé, \"Shí má, ó yuq é alhô eq masat laiká dap tô ri lhú?\" ga myi jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","yhangmoq gi, \"Kehtaq é nghut ri.\" ga tû taî akô. Haû mù, Yhang gi, yhangmoq lé, \"Kehtaq é lé gi, Kehtaq lé byi keq; Garai Gasâng é lé gi, Garai Gasang lé byi keq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Haû su gâ é lé, wó gyo kôjáng, haú bang gi, maú byuq kômù, Yhâng chyáng mai htoq ló byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Haú nyí má yhang, haû dum dui toq hkyô a joq gâ é Saduke pé gi, Yesuq chyáng lé jé kômù, dangmyi lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yhangmoq myi kô é gi, \"Sará ê, 'Myiwe wó é byù rayuq gi, zo dù a dap é za shi byuq é nghut jáng, yhanggu gi, yhangmâng é awut ashín xoq byi râ matú, yhâng rhat lé chui gon ra râ nghut lhê.' ga, nga-nhúng lé, Mosheq taî tô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hí hpyang lé, ngamoq chyáng, gumang nhiktâng wuì nyhit yuq nyi akô. Lagám yuq gi, myiwe yù luî, zo dù a dap é za yhangmyi lé shi lhuî pyâm to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Haû eq rajung za, Lanong, Lalaq mai Lahkâ jé shoq, chuimó haú lé gon luî, ó le zo dù a dap é za shi ló byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ló htáng má, myiwe myhí haû le châng shi ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haû mù luî, haû dum dui toq é buinyì má, myiwe myhí haû gi, haú nhiktâng wuì nyhit yuq mâ é hká yuq é yhangmyi nghut râ lhú? Hkâsu mù gâ le, yhang gi, haú nhiktâng wuì banshoq bâng é yhangmyi dut wú bê sû nghut ri.\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Haú hkûn, Yesuq gi, yhangmoq lé, \"Nungmoq gi, Chyúmdang eq Garai Gasâng é wum-o a-tsam lé a sé kô é yanmai, hkyô nghoq akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Haû dum dui toq é buinyì má gi, myi byi myi yû hkyô joq lo râ a nghut; yhangmoq gi, mauhkûng htoq mâ é maumang lagyô pé su dut byuq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Shi é mai dum dui toq bang eq séng luî, ");
INSERT INTO atbNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Garai Gasang gi, 'Ngò gi, Abraham é Garai Gasang, Isak é Garai Gasang, Yakup é Garai Gasang nghut lhê.' ga, nungmoq lé taî tô é lé, nungmoq a nghap wú kó lhú? Yhang gi, shi to bâng é Garai Gasang a nghut; dui nyì bâng é Garai Gasang sheq ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Byù moq mó gi, dang haû wó gyo kôjáng, Yhang mhoqshit é hkyô lé maú byuq bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduke pé lé, Yesuq lhoq zîm pyâm é hkyô lé, Hparishe pé wó gyo kôjáng, yhangmoq gi, Yesuq chyáng zup zîng lé bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yhangmoq má bo é tarâ sará rayuq gi, Yesuq lé chyam wú é dông, ");
INSERT INTO atbNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","\"Sará ê, jep é tarâ má, hká lhum gi, je ahkyak dik lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Haû mù, Yesuq gi, \"'Haû Yhumsîng náng é Garai Gasang lé, náng é myit nhiklhum banshoq, náng é asak woi-nyí lhum gón, nàng myit é hkyô banshoq èq, chyitdap râ lhê.' gâ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tarâ haû gi, je hî lhum eq je ahkyak dik é lhum nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hau htang lhum le haû eq du é nghut mù, 'Náng gûng lé nàng chyitdap é su, náng é chyangnâm mâ é bang lé le chyitdap aq.' gâ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tarâ haû í lhum gi, jep é tarâ banshoq eq myiqhtoi laiká banshoq é dangchyûng nghut lhê.\" ga, yhang lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hparishe pé zup zîng to kô é hkûn, Yesuq gi, yhangmoq lé, ");
INSERT INTO atbNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","\"Nungmoq gi, Hkrisduq eq séng luî hkâsu myit ngam akô lhú? Yhang gi, ó yuq é yhangzo nghut lhê lhú?\" ga myi jáng, yhangmoq gi, \"Dawiq é yhangzo nghut ri.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Haû mù, Yhang gi, yhangmoq lé, \"Haú hkûn, Dawiq gi, Woi-nyí dông mai, Yhang lé, 'Yhumsîng' ga, haî mù wut lhê lhú? Hkâsu mù gâ le, Dawiq taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Haû Yhumsîng Garai gi, ngá é Yhumsîng lé, \"Ngò, náng é gumlau gye pé lé, náng é hkyiwa ô má tô pyâm é hkyíng jé shoq, Ngá é loqyo hkyam shut zung nyì shi aq.\" ga taî ri.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Haû mù, Dawiq yhang lháng, Hkrisduq lé, 'Yhumsîng' gâ é nghut le gi, yhangzo za hkâsu ge nghut râ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Haû mù, ó yuq le, dang rahkun lháng a wó tû taí lo kô é nghut mù luî, haú nyí mai, ó yuq lháng Yhang lé dangmyi a wám myi lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hau htâng, Yesuq gi, byù moq mó eq Yhâng é chángzô pé lé taî é má, ");
INSERT INTO atbNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","\"Tarâ sará pé eq Hparishe pé gi, Mosheq é tanghkuq má zung akô. ");
INSERT INTO atbNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Haû mù, yhangmoq mhoqshit é hkyô chângjup lé, nungmoq châng kut ra kó râ nghut lhê. Nghut kôlhang, yhangmoq kut é dông gi, hkâkut kó; hkâsu mù gâ le, yhangmoq gi, yhangmoq taî é dông a kut kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yhangmoq gi, byu pê é goqsân má wòlai ke byi kôlhang, yhangmoq yhang gi, wò haú pé lé bo waq râ matú, loqnyhui lháng a kâm lhoq tuî kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yhangmoq kut é hkyô lhunglháng gi, byu pé myàng râ matú za kut shit é nghut akô; haû chyúmbun bo é showuî-htûng pé lé lhoq kô yù kômù, buhîng pé mâ é banbyaú pé lé lhoq hing yu akô nghut ri; ");
INSERT INTO atbNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","yhangmoq gi, poî pé mâ é réng é jowò pé eq tarajong pé mâ é ahkyak dik é zùng jang pé má, myang zùng râ lé ô nau nyi akô; ");
INSERT INTO atbNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","yhangmoq gi, gaì pé má lhom shi-kyâm yù kó râ eq, byu pé mai, yhangmoq lé, 'Rabai' ga lhom wut kó râ lé ô nau nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nungmoq kúm gi, 'Rabai' ga wut râ lé hkâ-ô naù kó; hkâsu mù gâ le, nungmoq gi, sará rayuq za wó lhê nghut é htoq agó, nungmoq banshoq bang gi, gumang chyat ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Haû mù, myidàm htoq má, ó yuq lé le, 'âwa' hkâ-nghû kó; hkâsu mù gâ le, mauhkûng htoq mâ é Îwa rayuq za, nungmoq é Îwa nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hau htoq agó, 'sará' ga wut râ lé, hkâ-ô naù kó; hkâsu mù gâ le, Hkrisduq za, nungmoq é Sará nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nungmoq mâ é je gyaú sû gi, nungmoq é dui-nhâng zoshâng dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hkâsu mù gâ le, yhumsing gùng lé waq toq sû ó yuq nghut kôle, lhoq nyhum pyâm é hui râ nghut lhê, yhumsing gùng lé lhoq nyhûm sû kúm gi, waq toq é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, byu pê hí má, mauhkûng mingdán hkyô lé xaû tô akô; nungmoq yhang le a wàng kó, wàng nau nyì bang lé le a wàng nhâng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, chuimó pê é yhûm-yò pé lé hpyoq zo hpyoq shuq é eq kyû hîng hîng dûng shit mhaû é bang nghut akô; haû mù, dam byî é je myo hui zo kó râ nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, byù rayuq lé nungmoq é noqkuq htûng má wó lhoq lhik yû râ matú, myì hkyô, wuì hkyô, châng jón wún kômù, wó lhoq lhik yu é sû lé gi, nungmoq su ngaraî byù í tú shuî dut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hkyô-u she é myoqjit pé ê, nungmoq gi, dingnyé wó ri. Nungmoq gi, 'Noqkuq yhûm lé lang luî dakam é sû gi, haî a ra; noqkuq yhûm mâ é hîng lé lang mù dakam é sû kúm gi, cháng ra bê.' ga lhaq taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Myoqjit é byù nâ pé ê! Haû hîng eq hîng lé lhoq yúnglhô é noqkuq yhûm gi, hká lhum je ahkyak lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hau htoq agó, nungmoq gi, 'Haû hkungga gyap lé lang luî dakam é sû gi, haî a ra, nghut kôlhang, haû hkungga zè lé lang mù dakam é sû gi, cháng ra bê.' ga le, lhaq taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Myoqjit pé ê! Haû hkungga zè eq hkungga zè lé lhoq yúnglhô é hkungga gyap gi, hká lhum je ahkyak lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Haû mù, haû hkungga gyap lé lang luî dakam é sû gi, haû hkungga gyap eq hau é ahtoq má ke tô é zè banshoq lé lang luî dakam é sû dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Noqkuq yhûm lé lang luî dakam é sû gi, haû noqkuq yhûm eq haú má nyi é Sû lé lang luî dakam é sû dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hau htoq agó, mauhkûng lé lang luî dakam é sû gi, Garai Gasâng é tanghkuq eq haú má zung é Sû lé lang luî dakam é sû dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, xunmân nghut é gau-tsáng shingtón, bantsaí, hpakkyí pé mâ é xê gambùm ragambùm lé gi, byî nyì kômù, je ahkyak é tarâ nghut é, tarâ rap-rá hkyô, shogyo nhikmyin hkyô eq lhumzui hkyô pé lé gi, lhaî pyâm tô akô nghut ri. Hî lhum lé kut é su, htang lhum lé le kut râ lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hkyô-u she é myoqjit pé ê! Nungmoq, pyup lé gi, jân pyám kômù, gola-uq lé gi, myui pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, zo hkoq shuq góm pé lé ahtoq shut za chî yúng mù, ahte má gi, lú zo lú shuq é eq yhumsing maiwáng zat é myit byíng zan tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hparishe myoqjit pé ê! Zo hkoq shuq góm é ahte lé hí chî yúng pyám keq, haû jáng, ahtoq le sân-yúng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, but hpyu tô é lup pé eq du akô; haú pé gi, ahtoq má wú yúng kôlhang, ahkaû má gi, màng bup showui pé eq achaq achyut é chângjup byíng tô é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Haû eq rajung za, nungmoq gi, byu pê hí má, ahtoq pyâm dingmán é su kut shit kôlhang, ahkaû má gi, gegùn labyoq kut é eq agè ashop é hkyô pé byíng zan tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Gegùn labyoq nghut é, tarâ sará pé eq Hparishe pé ê, nungmoq gi, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, myiqhtoî pê é lup lé luptsuq tsuq kômù, dingmán bâng é lup pé lé mhón byi kôluî, ");
INSERT INTO atbNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Ngamoq gi, ngamoq é îchyí îwa pê é ipyat má nyì âng é ru nghut le gi, haû myiqhtoî pê é sui lhoq shun é bang má, ngamoq bo lòm râ a nghut.' ga lhaq taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Haû su mù, nungmoq gi, haû myiqhtoî pé lé sat pyám bâng é awut ashín pé nghut é hkyô lé, nungmoq gùng nungmoq saksé hkam yu nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Haû mù, nungmoq é îchyí îwa pé hi tô é muzó lé, banshoq châng kut pán keq! ");
INSERT INTO atbNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lhangmuì pé ê, duq htân lhangmuì amyû pé ê! Ngaraî mîng é dam byi hkyô mai, hkâsu wó hpang lut kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hau é yanmai, myiqhtoî pé, hpaqchyî bò bang eq chyúm sará pé lé, Ngò, nungmoq chyáng nhang kat râ nghut lhê. Haú bang mâ é ra-am lé gi, nungmoq lhom sat pyám mù, tapzîng má jén pyám kó râ nghut lhê; ra-am lé gi, nungmoq é tarajong pé má, nhuq bat kômù, ra-myuq htâng ra-myuq châng hkat zing-rî wún kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hau é yanmai, haû dingmán sû Abelaq é sui mai hî luî, noqkuq yhûm eq hkungga gyap gyoro má nungmoq sat pyâm é, Berehkiaq é yhangzo Zahkariq é sui jé shoq, myidàm htoq má shun pyâm é dingmán bang banshoq é sui gi, nungmoq é ahtoq má jé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngò, nungmoq lé teng za taí kôlé, shí hkyô banshoq gi, ipyat shi é ahtoq má jé râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalem ê, Yerusalem ê, myiqhtoî pé lé sat pyám pyám kut mù, náng chyáng nhang kat é bang lé luqgok èq dú sat sat kut é myuq nàng ê, woqzìng gi, yhangzô pé lé, yhâng é dùng hkaû má tsîng lhûng yu é su, nungzô pé lé, Ngò, hkâ-myhó dâm shuî tsîng yù naù kôlhang, nàng a dóng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wú keq, nungmoq é yhûm gi, nungmoq é matú chamchyuiyuì dut pyâm to berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hkâsu mù gâ le, Ngò, nungmoq lé taí kôlé, 'Yhumsing é myìng mai jé lé lo é Sû gi, hkungsô wó nyî sháng gaq.' ga, nungmoq a taí taí gi, Ngo lé wó myâng kó râ a nghut lo.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuq gi, noqkuq yhûm mai htoq e ló é u lé, Yhâng é chángzô pé gi, Yhâng é nàm má huî lé lô kômù, haû noqkuq yhum é loqmú pé lé tûn shit akô. ");
INSERT INTO atbNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Haú hkûn, Yesuq gi, yhangmoq lé, \"Haú pé banshoq lé, nungmoq myang lhê a nghut kó lhú? Ngò, nungmoq lé teng za taí kôlé, luqgok haú pé gi, rachâm htoq racham lháng a kê lhum loshoq, hpyoq hpyi pyâm é hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuq gi, Tsanlun Bùm má zung tô é hkûn, haû chángzô pé gi, yhangmoq baú Yhâng chyáng lé jé kômù, \"Haú hkyô pé gi, hkâ-nhám dut lò râ lhú? Nàng gyó lé râ hkûn eq ló htâng buinyì má, hkasû é kumlhá htoq lô râ nghut lhê lhú? Ngamoq lé taî kyô wú laq.\" ga, Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Haú hkûn, Yesuq, yhangmoq lé tû taî é gi, \"Nungmoq lé, ó yuq èq le a wó shuî nghoq sháng gaq, sidiq nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hkâsu mù gâ le, 'Ngò gi, haû Hkrisduq nghut lhê.' ga, Ngá myîng lé lâng é byù myo myo pô htoq lô mù, byù myo myo lé hkyô shuî nghoq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nungmoq gi, majan dut nyi é hkyô eq majan eq sêng é danglám pé lé, wó gyo kó râ nghut lhê; nghut kôlhang, hkâgyuq dàn kó. Haú hkyô pé gi, dut lò râ za nghut lhê; nghut kôlhang, ló htâng é buinyì gi, a nghut shi. ");
INSERT INTO atbNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Byù ra-myû eq ra-myû, mingdán ralhum eq ralhum majan zân lhûm lò kó râ nghut lhê. Jowò myo myo má, mutmó gyó é pé eq layàng nún é pé dut lò râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Haú pé gi, wuîhke jamjau hkyo é apûn awang za ru nghut ashî. ");
INSERT INTO atbNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Haú hkûn, nungmoq gi, zing-rî é eq sat pyâm é hui zo râ matú, ap pyâm é hui kó râ nghut lhê. Byù myû lhunglhâng bang gi, Ngá é yanmai, nungmoq lé a nguì kut kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Haú u lé, byù myo myo gi, lumjíng myit lé tô pyám kômù, rayuq eq rayuq a ngui lhum dut é htoq agó, rayuq eq rayuq ap pyâm lhum kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hau htoq agó, myiqhtoi pyoq pé myo myo pô htoq lô kômù, byù myo myo lé hkyô shuî nghoq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Agè ashop é hkyô myô jat lo é yanmai, byù myo myô é chyitdap myit gi, kân ló byuq râ nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","nghut kôlhang, jihtûm jé shoq wó hkam jân nyi é sû gi, hkyi yu é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Byù myû banshoq má saksé dut râ matú, haû mingdán eq sêng é gabú danglù lé, mingkan gón má hko kyo râ nghut lhê. Hau htâng má sheq, ló htum buinyì jé râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Haû mù luî, myiqhtoi Danielaq dông mai taî tô é eq rajung za, 'haû lhoq hten lhoq hpyoq é achaq achyut hkyô' gi, chyoiyúng jowò má shap tô é lé, nungmoq myàng kó râ nghut lhê. (Chyúmlaiká nghap sû gi, sê gyo sháng gaq). ");
INSERT INTO atbNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Haú hkûn, Yuda mau má nyi é bang gi, bùm pé shut hpang doq ló kó sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yhumhkûng htoq má nyi tô é sû gi, yhúmhkaû mâ é zè haî lé le, a ló gyó wang yù lo sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yò má nyi tô é sû gi, yhâng é buhîng lé a ló taû yu nyì lo sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Haú buinyì pé má, zogûng dut é myiwe eq naú huq ashî nghut é înu wuì gi, gyai yhang wuîhke jamjau kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Haû nungmoq hpâng râ buinyì gi, gyoqmyò, a nghut jáng, Bánno buinyì má a ang râ matú, kyûdûng nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Hkâsu mù gâ le, mingkan lé joq é hkûn mai ahkuî jé shoq, hkâ-nhám le a dut wú shî é wuîhke jamjau mó gi, haú buinyì pé má dut lò râ nghut lhê; haû sû é hkyô gi, htângnùng má hkâ-nhám le dum dut lo râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Buinyì haú pé lé lhoq shaû pyâm é za a nghut le gi, ó yuq le asak wó lut râ a nghut; nghut kôlhang, Garai Gasang èq hkyin yù hui bâng é matú gi, buinyì haú pé lé, lhoq shaû pyám byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Haú ahkyíng má, byù rayuq yuq mai, nungmoq lé, 'Wú keq, shí má Hkrisduq nyi ri.' ga, haû a nghut jáng, 'Wú keq, Yhang hê má nyi ri.' ga taí jáng, nungmoq hkâjíng kó. ");
INSERT INTO atbNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hkâsu mù gâ le, Hkrisduq pyoq pé eq myiqhtoi pyoq pé pô htoq lô mù, wó dut é nghut jáng, hkyin yù hui bang lé lháng, wó lhoq nghoq shoq ga, kumlhá mó pé eq laklaí kumlhá pé lé kut shit kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gyo keq, shí hkyô a dut shimá, Ngò, nungmoq lé taî kyô nyì gù nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Haû mù, rayuq yuq èq, nungmoq lé, 'Yhang gi, yoso má nyi ri.' gâ jáng le, hkâ-ê kó; 'Yhang gi, shî gok hkaû má lúng tô ri.' ga jáng le, hkâjíng kó. ");
INSERT INTO atbNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hkâsu mù gâ le, buì htoq hkyam má lhap hpyat é gi, buì wang hkyam má lháng jé shoq duqbó é su, haû Byu Yhangzo jé lé é hkûn le, dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Màng leq é jang má, langdâ pé, lé zîng bùm râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Buinyì haú pé mâ é wuîhke jamjau lai eq yhang, 'Buì gi, noq byuq mù, lhamó gi, a tsô dut byuq râ nghut lhê; kyî pé gi, mauhkûng mai byit gyó lo bùm mù, mauhkûng mâ é wum-o a-tsam pé gi, lhoq nhûn é huî bùm kó râ nghut lhê.' ");
INSERT INTO atbNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Haú hkûn, haû Byu Yhangzô é kumlhá gi, mauhkûng má htoq shit lô râ nghut mù, myidàm htoq mâ é byù myû lhunglháng gi, yón ngau bùm kó râ nghut lhê. Haû Byu Yhangzo gi, mauhkûng mai, mhut ji mù, hpungwup a-tsam mó eq le, hpungwup shingkâng eq le, gyó lé lo é lé, yhangmoq byu-myàng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hau htâng má, Yhang gi, Yhâng é maumang lagyô pé lé, tut htê mó èq nhang kat luî, yhangmoq gi, maumyî chyûn myi chyûn eq mauhkûng rahkyam mai, gó hkyam htum shoq mâ é, Yhang hkyin yu tô é bang lé shuî tsîng yù kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Maihpáng gâm lé wú mù, mhoq yû keq; agàm mai a-nyuq nyún lô mù, ahaq htut lô jáng, buì nyé nám chyâng lò bê lé, nungmoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Haû eq rajung za, shí hkyô banshoq lé, nungmoq myàng kôjáng, Yhang gi, chyáng bê nghut mù, hkúmdong má lháng nghut nyî bê hkyô lé, nungmoq sé lo keq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ngò, nungmoq lé teng za taí kôlé, shí pyat mâ é byu pé a ban shi byuq shimá, haú hkyô pé banshoq dut byuq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mauhkûng eq myigùng gi, a joq lo dut byuq râ nghut lhê; nghut kôlhang, Ngá é dang gi, ru joq nyî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Buinyì eq ahkyíng haú lé gi, ó yuq le a sé; mauhkûng htoq mâ é maumang lagyô pé lháng a sé; haû Zo le a sé; haû Îwa za ru sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noaq é tsîn pyat má dut é su, haû Byu Yhangzo lé lo é hkûn le, dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hkâsu mù gâ le, dowuî a díng shî é buinyì pé má, byu pé gi, Noaq, wuì-sanghpo mó hkaû má wang é hkûn jé shoq, zo zo shuq shuq, myi byi myi yû, kut nyi bum akô nghut ri; ");
INSERT INTO atbNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","yhangmoq gi, dowuî díng lô mù, yhangmoq banshoq lé ûm sat pyâm é hkûn jé shoq, haî dut lò râ lé, a sé kó dut bùm é su, haû Byu Yhangzo lé lo é hkûn le, dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Haú hkûn, yò má rahá nyi tô é byù í yuq mâ é rayuq gi, shuî yu é hui mù, rayuq gi, myit gyó to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Luqluí chôm lâng nyi é myiwe í yuq mâ é rayuq gi, shuî yu é hui mù, rayuq gi, myit gyó pyâm to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Haû su mù, haû nungmoq é Yhumsîng gi, hká nyí jé lé lô râ lé, nungmoq a sê kô é yanmai, sidiq machya nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Myín hká u má hkau sû jé lé lò râ lé, yhumsîng sê é ru nghut le gi, yhâng é yhûm má a wó hput wâng nhâng loshoq, yhang machya nyì râ nghut é lé, nungmoq sê gyô nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Haû mù, nungmoq le rì rì nghut nyî keq; hkâsu mù gâ le, haû Byu Yhangzo gi, a bûn nùng má jé lé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yhumsîng hpô é dui-nhâng zoshâng wuì lé, uphkâng râ eq ahkyíng jé jáng zoshuq gàm byi râ matú, yhumsîng hpô èq mû nhang tô é, lhumzui luî, hpaqchyî bo é dui-nhâng zoshâng gi, ó yuq nghut râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yhumsîng hpó dum taû lo é hkûn, haû su kut nyî láng é dui-nhâng zoshâng gi, hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngò, nungmoq lé teng za taí kôlé, yhumsîng hpó haû gi, yhâng é sutzè banshoq, dui-nhâng zoshâng haú yuq lé ap to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nghut kôlhang, laqmá mù, dui-nhâng zoshâng haú yuq gi, agè ashop sû nghut luî, 'Ngá é yhumsîng hpó jé lô râ gyai myáng ashî.' ga, yhâng é i-myit unghkaû má myit yù mù, ");
INSERT INTO atbNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","gotû dui-nhâng zoshâng luzúm wuî lé nhuq bat é htoq agó, î shuq wut bang eq rahá zo zo shuq shuq kut nyi é nghut le gi, ");
INSERT INTO atbNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","dui-nhâng zoshâng hau é yhumsîng hpó gi, yhang a myitngam tô é buinyì eq yhang a sê tô é ahkyíng má jé lô mù, ");
INSERT INTO atbNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","yhang lé jap pyám luî, gegùn labyoq kut bang hkâm zô é, ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyì râ jowò má hkyô pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Haú hkûn, mauhkûng mingdán gi, myibung yu chûng mù, lusik lé te yù râ ga, htoq e ló é zomyi raxê yuq eq pûng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Haú bang má, ngo yuq gi, nhik a gying kó; ngo yuq gi, nhik gyîng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Haû nhik a gyîng é bang gi, myibung yu chûng kôlhang, xû a yu chûng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nghut kôlhang, haû nhik gyîng é bang kúm gi, yhangmoq é myibung lé le, xû bo é bòng lé le yu chung akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lusik jé lé lô râ myáng nyi é yanmai, yhangmoq banshoq bang gi, yhup mui lò kômù, yhup myhî byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Myín gunggàm jé jáng, 'Lusik jé bê ô! Yhang lé te yù râ matú, htoq lé lô keq hkoi ô!' ga, garû é htê htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Haú hkûn, zomyi haú bang banshoq gi, toq lô mù, yhangmoq é myibung lé hen lajâng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Haû nhik a gyîng bang gi, 'Ngamoq lé, xû ratsuí byi kó laq; hkâsu mù gâ le, ngamoq é myibung shi ló nyi ri.' ga, haú nhik gying bâng chyáng dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Haú hkûn, haû nhik gying bang gi, 'Nungmoq eq ngamoq é matú ga jáng, luq râ a nghut. Haû mù, nungmoq é matú, xû ung bâng chyáng ê wui yù keq.' ga tû taî kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yhangmoq, xû wuì e ló kô é hkûn, lusik gi, jé lé lô mù, haû rì rì hen tô é zomyi wuì gi, yhang eq rahá myiháng poî má wang ló bekô. Hkum le myhî byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hau htâng má, hau htâng gyó tô é zomyi wuì gi, tau jé lô kômù, 'Yhumsîng ê! Yhumsîng ê! Ngamoq lé, hkum hpóng byi laq ô!' ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nghut kôlhang, haû lusik gi, 'Ngò, nungmoq lé teng za taí kôlé, nungmoq lé ngò a sé.' ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Haû mù luî, haû Byu Yhangzo jé lé râ buinyì eq ahkyíng lé, nungmoq a sé kô é yanmai, sidiq machya nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mauhkûng mingdán gi, byù rayuq byìn we htoq râ hen nyi é nghut mù, yhâng é dui-nhâng zoshâng wuì lé wut yù luî, yhâng é sutzè lé ap byî to sû eq pung ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yhang gi, yhangmoq é a-tsam má cháng luî, rayuq lé gi, ngùn ngo joí, rayuq lé gi, í joí, htâng rayuq lé gi, rajoí kut byî to mù, byìn we shut htoq ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ngùn ngo joí wó yû sû gi, haú hkûn jáng htoq ló mù, hpugá gá luî, ngùn ngo joí wó myat yù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Haû eq rajung za, ngùn í joí wó yû sû le, í joí wó myat yù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nghut kôlhang, rajoí za wó yû sû gi, htoq e ló mù, myigùng má du luî, yhâng yhumsîng hpô é ngùn lé haq myhup tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hau htâng tsómra myáng jáng, dui-nhâng zoshâng haú bâng é yhumsîng hpó gi, dum taû jé lô mù, yhangmoq é ngùn chyarâng lé, lo jep ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ngùn ngo joí wó yû sû gi, amyat ngo joí lé le yu lé lô mù, 'Yhumsîng ê, nàng, ngo lé, ngùn ngo joí ap tô é nghut lhê. Wú aq, amyat ngo joí wó ho jat yù bê.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Haú hkûn, haû yhumsîng hpó gi, 'Arâ! Nghut bê. Nàng gi, kyet é eq lumgíng é dui-nhâng zoshâng nghut ri! Tiq é mû má lháng wó lum é sû nghut é yanmai, ngò, nang lé, kô é mû lé le ap byi râ nghut lhê. Náng yhumsîng hpô é gabú hkyô má bo wang lòm aq hkoi!' ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Haû eq rajung za, í joí wó yû sû le, lé lô mù, 'Yhumsîng ê, nàng, ngo lé ngùn í joí ap tô é nghut lhê. Wú aq, amyat í joí wó ho jat yù bê.' ga, lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Haú hkûn, haû yhumsîng hpó gi, 'Arâ! Nghut bê. Nàng gi, kyet é eq lumgíng é dui-nhâng zoshâng nghut ri! Tiq é mû má lháng wó lum é sû nghut é yanmai, ngò, nang lé, kô é mû lé le ap byi râ nghut lhê. Náng yhumsîng hpô é gabú hkyô má bo wang lòm aq hkoi!' ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hau htâng, rajoí wó yû sû le, lé lô mù, 'Yhumsîng ê, nàng gi, byù wui nghut mù, yhumsîng a hô tô é jang mâ é shû yù nau é htoq agó, yhumsîng, kyôshi a sân hkyô tô é jang mâ é tsîng yù naù sû nghut é lé, ngò sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Haû mù, ngò gi, gyuq luî, htoq ê mù, náng é ngùn lé, myigùng má ê haq myhup tô é nghut lhê. Wú aq, shî gi, nàng é ngùn nghut lhê.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Haû mù, yhumsîng hpó gi, yhang lé, 'Agè ashop é eq lagôn é dui-nhâng zoshâng ê! Ngò gi, yhumsîng a hô tô é jang mâ é shû yù nau é eq, yhumsîng, kyôshi a sân hkyô tô é jang mâ é tsing yù naù sû nghut é lé, nàng sê to gù nghut le nhîng, ");
INSERT INTO atbNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ngá é ngùn lé, ngò dum taû jé lô jáng, aráng eq amyat wó yû shoq, ngùn hpún kat jang má, haî mù a kat tô é lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Haû mù, haû ngùn rajoí lé, náng chyáng mai yù luî, raxê joí wó to sû lé, byî pyám nhâng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hkâsu mù gâ le, wó sû ó yuq lé nghut kôle, yhang agùn agó wó râ matú, jat byi râ nghut lhê. A wó su chyáng mai kúm gi, yhang wó tô é lé lháng yu pyám byi shirâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Haû mù, haû akyû a bo é dui-nhâng zoshâng lé gi, ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyì râ jowò nghut é, shinggan mauchut hkaû má dú htoq pyám keq.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Haû Byu Yhangzo gi, Yhâng é hpungwup shingkang mai, maumang lagyo lhunglhâng bang eq rahá jé lé lo é hkûn, Yhâng é hpungwup shingkang bo é hkohkâm-tanghkuq htoq má zùng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Haú hkûn, byù myû chângjup gi, Yhâng é hí má zîng lé lo bùm kó râ nghut mù, Yhang gi, sau zúng sû mai, sau eq bainám lé gotû tû kut gam hkoq é su, byu pé lé gam hkoq pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yhang gi, sau pé lé, loqyo hkyam shut, bainám pé lé, loqpaî hkyam shut kut, nyhi to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hau htâng má, haû Hkohkâm gi, Yhâng é loqyo hkyam shut mâ é bang lé, 'Ngá Wâ chyáng mâ é shimân jeju hkam yu é hui bang ê, lé keq; mingkan lé hpan é hkûn mai, nungmoq é matú ga hen lajâng tô é muì mingdán má wang ló keq. ");
INSERT INTO atbNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hkâsu mù gâ le, Ngò zòmut é u lé, nungmoq, Ngo lé byi tso kô é nghut lhê; Ngò wuìshit é u lé, nungmoq, Ngo lé byi huq kô é nghut lhê; Ngò bíng kut wún é u lé, nungmoq, Ngo lé lhom hkulum yù kô é nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngò gùngchîn dut é u lé, nungmoq, Ngo lé byi hut kô é nghut lhê; Ngò nòhpyo huî é u lé, nungmoq, Ngo lé wú gon kô é nghut lhê; Ngò htóng lúng é u lé, nungmoq, Ngo lé lé kum kô é nghut lhê.' ga taí râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Haú hkûn, haû dingmán bang gi, Yhang lé, 'Yhumsîng ê, Nàng zòmut huî é lé, ngamoq, hkâ-nhám myàng luî, byi tsô wú é lhú? Nàng wuìshit é lé, ngamoq, hkâ-nhám myàng luî, byi huq wú é lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nàng bíng kut wún é lé, ngamoq, hkâ-nhám myàng luî, lhom hkulum wú é lhú? Nàng gùngchîn dut é hkûn, ngamoq, hkâ-nhám byi hut wú é lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nàng nòhpyo huî é lé le, htóng lúng é lé le, ngamoq, hkâ-nhám myàng luî, lé gon lé kûm wú é lhú?' ga myi kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Haú hkûn, haû hkohkâm gi, 'Ngò, nungmoq lé teng za taí kôlé, shî, Ngá gumang wuì mâ é je tiq sû lé, nungmoq kut byî é hkyô haî le, Ngo lé kut byî é nghut bê.' ga tû taí râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hau htâng má, Yhang gi, Yhâng é loqpaî hkyam shut mâ é bang lé, 'Dingnyé wó é bang ê, Ngá chyáng mai gâng ló mù, nat Tsadán eq yhâng é maumâng pê é matú hen tô é, ahtum abyuq é myi má wang ló keq. ");
INSERT INTO atbNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hkâsu mù gâ le, Ngò zòmut é u lé, nungmoq, Ngo lé a byi tso kó; Ngò wuìshit é u lé, nungmoq, Ngo lé a byi huq kó; ");
INSERT INTO atbNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngò bíng kut wún é u lé, nungmoq, Ngo lé a lhom hkulum yù kó; Ngò gùngchîn dut é u lé, nungmoq, Ngo lé, mebu a byi hut kó; Ngò nòhpyo huî é eq htóng lúng é u lé, nungmoq, Ngo lé a gon kó nghut ri.' ga taí râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Haú hkûn, yhangmoq gi, 'Yhumsîng ê, nàng zòmut wuìshit é, bíng kut wún é, gùngchîn dut é, nòhpyo huî é eq htóng lúng é lé, ngamoq, hkâ-nhám myàng luî, a wú gon kut wú é lhú?' ga taû myi kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Haú hkûn, Yhang gi, 'Ngò, nungmoq lé teng za taí kôlé, shí bang mâ é je tiq sû lé, nungmoq, a kut byî é hkyô haî le, Ngo lé a kut byî é nghut bê.' ga, yhangmoq lé tû taí râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Haû mù luî, haú bang gi, ahtum abyuq mara dam byî é má wang ló kó râ nghut lhê; haû dingmán bang kúm gi, ahtum abyuq é asak má wang ló kó râ nghut lhê.\" ga Yesuq taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuq gi, haú hkyô pé lé ban taî é htâng má, Yhâng é chángzô pé lé, ");
INSERT INTO atbNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","\"Nungmoq sê tô é eq rajung za, í nyí laî é htâng má, Lhoqlhai Poî jé râ nghut mù, haû Byu Yhangzo gi, tapzîng má jén sat é hui râ matú, ap pyâm é hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Haú u lé, hkyangjong agyi pé eq suwún wuî gi, Kayahpaq gâ é hkyangjong mó rayuq é yhumwàng má zup zîng to kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesuq lé haq chyup yû râ eq sat pyám râ hkyô lé, hpyê lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nghut kôlhang, yhangmoq gi, \"Byu pé gabyông lò kó abe, poî gyoro má gi, a kut shi sháng.\" ga, taî lhûm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuq gi, Behtani wà má nyi é manggâm dap wú sû Simûn é yhûm má nyi tô é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","myiwe myhí rayuq gi, gyai hpaû é namngón xû bo é luq hpyû bòng yu lé lô mù, Yesuq zo shuq nyi é hkûn, namngón xû haú lé, Yhâng é ulhum má hut gyun byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Haú hkyô lé, haû chángzô pé myàng kôjáng, wú nhik-yo kômù, \"Haî mù luî, haú lé aha agó kut pyâm lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xû haú lé, ahpau myo myô èq ûng pyám mù, myùng bang lé byî le ge lhê mhaî!\" ga taí kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuq gi, haú hkyô lé sé luî, \"Haî mù, myiwe zo haú lé, i-myit lhoq myô nyi akô lhú? Yhang gi, Ngá é ahtoq má ge é hkyô kut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Haû myùng bang gi, nungmoq eq rahá hkâ-nhám le nyì râ nghut lhê; nghut kôlhang, Ngò gi, nungmoq eq rahá ayang nyi nyì râ sû a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yhang, Ngá gûng má namngón xû hut gyûn é gi, Ngá gûng lé yhum râ matú, hen lajâng é hkyô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ngò, nungmoq lé teng za taí kôlé, haû gabú danglù lé, mingkan gón hko kyô é jowò hkangmó má, yhang lé myit bûn é dông, yhang kut é hkyô shî lé, taî kyo bekô râ nghut lhê.\" ga taî kyo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hau htâng, haû chángzo raxe í yuq má bo é Yudaq Iskarut ga sû gi, hkyangjong agyi pê chyáng ê mù, ");
INSERT INTO atbNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","\"Ngò, Yesuq lé nungmoq é loq má ap byî é nghut jáng, nungmoq, ngo lé haî byi kó râ lhú?\" ga myî ri. Haû mù, yhangmoq gi, yhang lé ngùn denggá sum xê chap nghap byî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Haú hkûn mai, Yudaq gi, Yesuq lé ap pyám râ hkyô ho nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Múnchi a kat é Muk Zo Poî sâng-hi nyí má, haû chángzô pé gi, Yesuq chyáng lé lô kômù, \"Nàng zo râ Lhoqlhai Poî zoshuq lé, ngamoq hkâmá món to râ lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Haû mù, Yhang gi, \"Myuq hkaû shut wang ló mù, byù rayuq chyáng ê luî, haú yuq lé, 'Ngá é ahkyíng chyáng bê; Ngá é chángzô pé eq rahá, Ngò, náng é yhûm má Lhoqlhai Poî kut râ nghut lhê.' gâ Sará taî ri nghû, ê taí keq.\" ga pying kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Haû mù, haû chángzô pé gi, Yesuq pying kat é eq rajung za ê taí kômù, Lhoqlhai Poî lé món to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Myinhtâng jé lô jáng, Yesuq gi, haû chángzo raxe í yuq eq rahá, zohpoq má zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yhangmoq zô nyi bùm kô é u lé, Yesuq gi, \"Ngò, nungmoq lé teng za taí kôlé, nungmoq mâ é rayuq sû gi, Ngo lé ap pyám râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Haú hkûn, yhangmoq gi, gyai gyô yón kômù, rayuq htâng rayuq, \"Yhumsîng ê, ngò a nghut hkaî?\" ga, Yhang lé chôm myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Haú hkûn, Yesuq gi, \"Ngò eq rahá, hkoq shí má loq lap bê sû gi, Ngo lé ap pyám râ sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Haû Byu Yhangzo gi, Yhang eq séng luî kâ tô é eq rajung za, shî râ za nghut lhê. Nghut kôlhang, haû Byu Yhangzo lé ap pyâm é sû gi, dingnyé wó ri; haú yuq gi, a hku lé le lháng, je ge ri.\" ga dum taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hau htâng, Yhang lé ap pyám râ sû, Yudaq gi, \"Rabai ê, ngò a nghut hkaî?\" ga myi jáng, Yesuq gi, \"Nàng nghut ri.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yhangmoq zô nyì kô é u lé, Yesuq gi, muk lé yù mù, jeju hkya-on luî, muk lé myhik hpé mù, \"Shî gi, Ngá é gungsho nghut lhê; yù mù zo keq.\" ga taí uchyang, Yhâng é chángzô pé lé gàm byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hau htâng, Yhang gi, góm lé le, yù mù, jeju hkya-on luî, yhangmoq lé byi mù, taî é gi, \"Nungmoq banshoq bang, shuq keq. ");
INSERT INTO atbNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Shî gi, yubak mara hkyut pyám byi râ, byù myo myô é matú htoq pyâm é, dangshikaq eq sêng é Ngá sui nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngò, nungmoq lé taí kôlé, ahkuî mai gi, Ngò, Ngá Wâ é mingdán má, nungmoq eq rahá tsibyiq wing asik lé shuq é buinyì a jé jé, tsibyiq wing lé dum shuq râ a nghut lo.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yhangmoq gi, hkya-on mahkôn ralhum ban hkôn jáng, Tsanlun Bùm shut htoq e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hau htâng má, Yesuq gi, yhangmoq lé, \"Nungmoq lhunglhâng bang gi, hkû-myîn yhang jáng, Ngá é yanmai, myit lingbat kó râ nghut lhê; hkâsu mù gâ le, 'Haû sau zúng sû lé, Ngò bat sat pyám mù, sau hpúng mâ é sau pé gi, lhoq pyo pyâm é hui kó râ nghut lhê.' ga kâ tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nghut kôlhang, Ngò gi, lhoq dui toq é huî htâng má, Galile mau shut, nungmoq é hí má e ló láng râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Haú hkûn, Petruq gi, \"Náng é yanmai, góbang banshoq myit lingbat kôlhang, ngò gi, hkâ-nhám le myit lingbat râ a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuq gi, \"Ngò, nang lé teng za taí lé, hkû-myîn yhang jáng, woq a tûn shimá, nàng, Ngo lé sum dâm he-ngik pyám râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nghut kôlhang, Petruq gi, \"Ngò, Nàng eq rahá shî râ dut kôlhang, Nang lé ngò he-ngik pyám râ a nghut.\" ga saî taî ri. Haû chángzô pé góbang banshoq le, haû su ga châng taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hau htâng má, Yesuq gi, Yhâng é chángzô pé eq rahá Get-samane gâ é jowò má ê kômù, yhangmoq lé, \"Ngò, hé má ê mù, kyûdûng nyi é u lé, nungmoq shí má zùng láng keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yesuq gi, Petruq eq Zebedi yhangzô nhik lé shuî chûng ri. Yhang gi, myit gyai a ngón é eq myit wui nhik hkyik dut lò bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hau htâng, Yhang gi, yhangmoq lé, \"Ngò gi, shî râ í yhang myit yón nyi ri; nungmoq gi, Ngò su machyâ luî, shî má láng nyî keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesuq gi, haû mai ratsuí zo sô ê mù, myigùng má ngóm gop to luî, \"Âwa ê, wó dut é nghut le gi, góm shí lé, Ngá chyáng mai lhaî pyám byi laq. Nghut kôlhang, Ngò ô nau é dông a nghut, Nàng ô nau é dông sheq nghut sháng gaq.\" ga kyûdûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hau htâng, Yhang gi, Yhâng é chángzô pê chyáng dum taû lo le, yhangmoq yhup myhî to kô é lé lo myàng ri. Haû mù, Yhang gi, Petruq lé, \"Nungmoq gi, hkyíng hkum rahkum za lháng, Ngò eq rahá a wó machya nyì kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gunglaú é a hui sháng gaq, machyâ luî, kyûdûng nyì keq. Haû woi-nyí gi, kâm nyì kôlhang, gungsho gi, wum nyhôm nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yhang gi, radàm dum ê mù, \"Âwa ê, góm shî lé, Ngò a shuq é a wó lai râ nghut jáng gi, Nàng ô nau é dông nghut sháng gaq hkoi.\" ga kyû dum dûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yhang dum taû lo le, yhangmoq gi, myoqkuq lai kô é yanmai, yhup myhî to láng kô é lé, lo dum myàng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Haû mù, Yhang gi, yhangmoq lé tô pyâm to mù, sum dâm nghû râ dàm dum ê luî, hí lé dûng é dang lé roq ê dum dûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Haû mù, Yhang gi, haû chángzô pê chyáng dum taû jé lô mù, yhangmoq lé, \"Nungmoq gi, ahkuî jé shoq yhup ngón nyi ashî kó lhú? Wú keq! Haû ahkyíng gi, jé bê nghut luî, haû Byu Yhangzo gi, yubak dap bâng é loq má ap pyâm é hui râ nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Toq keq! Ló losháng hkoi! Ngo lé ap pyám râ sû gi, jé lé bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuq, dáng nyo nyi ashî u lé, haû chángzo raxe í yuq má bo é Yudaq gi, jé lé lo ri; haû hkyangjong agyi pé eq mingbyu é suwún wui chyáng mai nhang kat é bang nghut é, shâm eq dumbáng pé chung tô é byù moq mó le, yhang eq rahá nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesuq lé ap pyám râ sû gi, haú bang lé, \"Ngò, bopuq puq é sû gi, haú yuq nghut bê; Yhang lé chyup yû keq.\" ga kumlhá byî tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudaq gi, Yesuq chyáng hkyê za ê mù, \"Rabai ê, wángzán nyi lhê lhú?\" ga taí luî, Yhang lé bopuq puq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Haú hkûn, Yesuq gi, \"Buinùm hpó ê, nàng kut râ muzó lé kut aq hkoi.\" ga tû taî kat ri. Hau htâng, yhangmoq gi, hí shut huî ê luî, Yesuq lé chôm zuî zìng mù, chyup yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Haû mù, Yesuq eq rahá nyì bang mâ é rayuq gi, shâm she htoq yû mù, hkyangjong mó é dui-nhâng zôshang é nohkyap lé pyoq hkyô kat byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Haû jáng, Yesuq gi, haú yuq lé, \"Náng é shâm lé, xâng pyám aq; hkâsu mù gâ le, shâm shê sû gi, ó yuq nghut kôle, sham èq shî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngò gi, Ngá Wa lé dung jáng, Yhang gi, radá dâm, maumang lagyo dap pé raxe í dap htoq myo shoq nhang kat byi râ nghut é lé, nungmoq a sé kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nghut kôlhang, haû su nghut é nghut jáng, shí hkyô dut lò râ nghut lhê ga Chyúmdang pé má bò tô é hkyô gi, hkâsu wó dik lò râ lhú?\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hau htâng, Yhang gi, byù moq lé, \"Nungmoq gi, damyaq rayuq lé chyup é su, Ngo lé chyup râ matú, shâm eq dumbáng pé chûng mù, lé lo akô lhú? Ngò gi, nyí wuî, noqkuq yhûm má zùng mù, mhoqshit nyî kôlhang, nungmoq, Ngo lé a chyup yû kô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nghut kôlhang, shî su dut é hkyô pé banshoq gi, haû myiqhtoî pé kâ tô é hkyô pé lo dik râ matú dut é nghut ri.\" ga taî ri. Haú hkûn, haû chángzô pé banshoq gi, Yesuq lé tô pyâm to kôluî, hpang byo byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesuq lé chyup yu é bang gi, haû tarâ sará pé eq suwún wuî zup zîng nyi é jang, hkyangjong mó Kayahpaq é yhûm má, Yhang lé shuî e akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petruq gi, hkyangjong mó é yhumwàng hkaû má châng jé wâng shoq, we we mai Yesuq htâng châng tô ri. Yhang gi, hkâsu dut lò râ lé myàng naù luî, wâng hkaû má wang ê mù, zúng bang eq rahá zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Haû hkyangjong agyi pé eq Yudaq byìn tú wapdoq mâ é góbang gi, Yesuq lé sat pyám nhâng râ matú, a têng é saksé ho nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A têng é saksé myo myo htoq lô kôlhang, wó sat râ î é saksé a myàng kó nghut ri. Ló htáng má, byù í yuq gi, lé lô kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","\"Shí yuq gi, 'Ngò gi, haû Garai Gasâng é noqkuq yhûm lé lhoq hten pyám mù, sum nyí gyoro má dum wó saî lhê,' ga taí sû nghut ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Haú hkûn, haû hkyangjong mó gi, toq yap mù, \"Nàng, haî le a tû taí luq? Shí bang, Nang lé mara hun nyi é saksé gi, hká dông nghut lhê lhú?\" ga, Yesuq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nghut kôlhang, Yesuq gi, jit le a ga nyi tô ri. Haú mù, hkyangjong mó gi, Yhang lé, \"Haû rû dui nyi é Garai Gasâng é myìng lé lang luî, ngò, Nang lé myî wú lé: Nàng gi, Garai Gasâng é Yhangzo, Hkrisduq nghut lhê luq, ngamoq lé taî kyô wú aq.\" ga taí jáng, ");
INSERT INTO atbNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuq gi, \"Nàng taî é eq rajung za nghut lhê. Ngò, nungmoq banshoq lé taí kôlé, nungmoq gi, ahkuî mai htâng hpyang má, haû Byu Yhangzo gi, a-tsam bo dik Su é loqyo hkyam má zung tô é lé le, mhuthtui ji mù, mauhkûng mai lé lo é lé le, nungmoq myàng kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Haú hkûn, hkyangjong mó gi, yhâng é bu lé lâng cheq pyám mù, \"Yhang gi, Garai Gasang lé rhoî dang taí bê nghut ri! Nga-nhúng, hai saksé râ ashî lhú? Yhang, Garai Gasang lé rhoî dang taî é lé, nungmoq, ahkuî wó gyo bekô nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nungmoq hkâsu wó myit akô lhú?\" ga myi jáng, yhangmoq gi, \"Yhang gi, shî gíng sû nghut lhê.\" ga tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hau htâng má, yhangmoq gi, Yesuq é myoqdong má sôkan byé gyun luî, loqtsup èq htui byî akô nghut ri. Góbang gi, Yhang lé bo-pyuq pyuq byi luî, ");
INSERT INTO atbNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","\"Hkrisduq Nàng, Nàng lé bat sû ó yuq nghut é lé, myiqhtoi htoî wú aq.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petruq gi, wâng hkaû má nyi tô é u lé, dui-nhâng zoshâng myhí rayuq gi, yhâng chyáng lé jé mù, \"Nàng le, haû Galile byù Yesuq eq rahá nyì sû nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nghut kôlhang, Petruq gi, haú bang banshoq é hí má yhang, \"Nàng haî taî nyi é lé, ngò a sé.\" ga he kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hau htâng, yhang gi, wâng hkúmdong shut htoq e ló le, haú jowò má, dui-nhâng zoshâng myhí góyuq le, yhang lé myàng mù, \"Shí yuq gi, Nazaret wà byù Yesuq eq rahá nyì sû nghut ri.\" ga, haú mâ é bang lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Haú hkûn, yhang gi, \"Byù haú yuq lé, ngò a sé!\" ga dakam é dông he pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hau htâng razup zo má, haú jowò má yap to bang gi, Petruq chyáng huî ê kômù, \"Nàng le, haú bang má bò sû yhang nghut ri; náng é danghtê lé sê gyô ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Haú hkûn, yhang gi, yhânggùng yhang nhing luî, \"Haú yuq lé, ngò a sé.\" ga dakâm dang taî ri. Haú-u yhang, woq tûn bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Haû mù, Petruq gi, \"Woq a tûn shi má, nàng, Ngo lé sum dâm he pyám râ nghut lhê.\" ga, Yesuq, yhang lé taî é dang lé, myit bûn kat mù, shinggan shut htoq ê luî, gyai yhang ê ngau ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Napsûn noq le, hkyangjong agyi pé banshoq bang eq mingbyu é suwún wuî gi, Yesuq lé sat pyám nhâng râ matú chôm myit hpyit yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Haû mù, yhangmoq gi, Yhang lé tuî yù luî, shuî htoq ê kômù, mauzau Pilat chyáng ê ap byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesuq lé ap pyâm é sû Yudaq gi, Yesuq lé jéyáng doqdân é hkyô lé myang sé jáng, nungngham wó mù, haû ngùn sum xê chap lé, hkyangjong agyi pé eq suwún wui chyáng ló dum taû byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Haû mù, yhang gi, \"Mara a bò Su é sui lé, ngò ap pyám bê nghut é yanmai, ngò mara wó bê.\" ga taí jáng, yhangmoq gi, \"Haú hkyô, ngamoq eq haî sêng lhê lhú? Haû gi, nàng eq sheq ru sêng lhê.\" ga lhom taî kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Haû mù, Yudaq gi, ngùn haú lé, noqkuq yhúmhkaû má dú pyâm to luî, htoq ló mù, yhang gûng yhang ê juîshi byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Haû hkyangjong agyi pé gi, ngùn chap haú pé kui yù luî, \"Shî gi, sui hpau ngùn nghut lhê yanmai, alu sidek má a ge kat.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Haû mù, yhangmoq gi, tûngbaù pê é lupdùng kut râ matú, au saí zo su é maumyî lé, ngùn hau èq wui hpyit yû râ dông, chôm myit hpyit to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hau é yanmai, ahkuî jé shoq, haú jowò lé, sui myigùng ga myhîng tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Haû gi, \"Haû Israelaq byu pé mai, Yhang lé gù hpyit tô é ngùn sum xê chap lé, yhangmoq yù mù, haû Yhumsîng Garai, ngo lé pying tô é eq rajung za, ");
INSERT INTO atbNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","haû au saí zo su é maumyî lé, yhangmoq wui yù bekô nghut ri.\" ga myiqhtoi Yeremiaq taî tô é dang lo dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Haú u lé, Yesuq gi, mauzau hpô é hí má yap tô é nghut mù, haû mauzau hpó gi, Yhang lé, \"Nàng gi, Yudaq byu pê é hkohkâm nghut lhê lhú?\" ga myi jáng, Yesuq gi, \"Nàng taî é eq rajung za nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Haû hkyangjong agyi pé eq suwún wuî gi, Yhang lé, mara hûn kôjáng, Yhang gi, haî le a tû taí nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Haú hkûn, Pilat gi, Yhang lé, \"Yhangmoq, Nang lé mara hûn saksé haû-í hkâm nyì kô é lé, Nàng a wó gyo lhú?\" ga saî myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nghut kôlhang, Yesuq gi, dang rahkun lháng a tû taî é yanmai, haû mauzau hpó gi, gyai maú byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Haû Lhoqlhai Poî u lé, mingbyû wuì ô nau é má cháng luî, haû mauzau hpó gi, htóng byû rayuq yuq lé nhâng byî é htûng joq ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Haú u lé, a gè myìng htoq é htóng byû, Barabaq ga sû rayuq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Haû mù, byù moq mó zup zîng lò kô é hkûn, Pilat gi, yhangmoq lé, \"Nungmoq é matú, hká yuq lé lhut byi nhâng nau akô lhú? Barabaq luq? Haû a nghut jáng, Hkrisduq gâ é Yesuq lé luq?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yhang haû su ga myî é gi, yhangmoq, Yesuq lé manôn kôluî, yhâng chyáng lé ap byi kô é hkyô lé sê é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilat gi, tarâ jéyáng tingnyâng htoq má zung tô ashî hkûn, yhangmyi gi, \"Haû mara a bò Sû lé, haî le hkâkut; hkâsu mù gâ le, hkû-nyí za lháng, yhupmoq má, haú yuq é yanmai, ngò tsómra hpuzô pyám bê nghut lhê.\" ga, yhâng chyáng dang pying kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nghut kôlhang, haû hkyangjong agyi pé eq suwún wuî gi, Barabaq lé dûng htoq yû râ eq Yesuq lé sat pyám nhâng râ matú, shiwa byu pé lé wum byi bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Haû mauzau hpó gi, \"Shî í yuq mâ é hká yuq lé, nhâng byi nhâng nau akô lhú?\" ga myi jáng, yhangmoq gi, \"Barabaq!\" ga tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Haû mù, Pilat gi, \"Haû jáng gi, Hkrisduq gâ é Yesuq lé, ngò hkâsu kut râ lhú?\" ga dum myî kat jáng, yhangmoq banshoq bang gi, \"Yhang lé tapzîng má jén sat pyám aq!\" ga dum tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nghut kôlhang, yhang gi, \"Haî mù luî lhú? Yhang gi, hai mara kut shut bê lhú?\" ga dum myi jáng, yhangmoq gi, htê mó èq, \"Yhang lé tapzîng má jén sat pyám aq!\" ga je riyhang garû lo bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat gi, hká dông le a dat kut lô é eq byu pé gabyông lò kó râ nghut é hkyô lé myàng luî, uchyam yù mù, shiwa byu pê hí má loq chi luî, taî é gi, \"Shí yuq é sui gi, ngò eq haî a séng; nungmoq eq za ru sêng lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Haû shiwa byù lhunglhâng bang gi, \"Yhâng é sui gi, ngamoq eq ngamoq é yhangzo yhangshû pê htoq má joq nyì sháng gaq.\" ga, dum tû taî kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Haú hkûn, Pilat gi, Barabaq lé nhâng byi bê nghut ri. Yesuq lé kúm gi, nhuq bat nhâng mù, tapzîng má jén sat pyám râ matú ap byî kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hau htâng, mauzau hpô é gyezô pé gi, Yesuq lé, mauzau hpô é yhumwàng mó hkaû má shuî wang ló kômù, Yhâng é lhînghkyuq má, gyedap gón lé ji tsîng tô akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yhangmoq gi, Yesuq é mebu hkyut pyám byi kôluî, zam zam ne é buhîng hut byi kômù, ");
INSERT INTO atbNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","zujanmaú ralhum saî yù kôluî, Yhâng é ulhum má tsung byî akô nghut ri. Yhangmoq gi, jàm-yang rahkat lé, Yhâng é loqyo loq má kat byi kômù, Yhâng é hí má hkyihput htuq kôluî, \"Yudaq byu pê é hkohkâm hpó ê! Chyung hîng xê hing nyì sháng gaq ô!\" ga, jihpoi dang taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yhangmoq gi, Yhang lé sôkan byé gyun luî, Yhâng é loq mai jàm-yang lú yû mù, Yhâng é ulhum má dum bat bat kut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yhangmoq gi, Yhang lé rhoî jihkyoî ban kut yû kôjáng, Yhang wut tô é buhîng lé hkyut yû kômù, Yhâng é mebu lé dum hut byi luî, tapzîng má jén sat pyám râ matú, Yhang lé shuî htoq e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yhangmoq htoq e ló nyi le, Kuruni myuq byû nghut é Simun ga sû lé myàng kômù, yhang lé, zik luî tapzîng waq nhang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yhangmoq gi, Golgahta gâ é jowò má jé e ló bekô nghut ri. Golgahta gâ é lichyúm gi, ugyap joq é jowò lé gâ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Haú má jé jáng, yhangmoq gi, Yesuq lé, hkô jung eq nyhô tô é tsibyiq wing lé byi huq akô; nghut kôlhang, Yhang gi, haú lé chyam wú mù, a shuq byi kut pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yhangmoq gi, Yesuq lé tapzîng má jén tap tô é htâng, Yhâng é mebu lé lháng, hkyîn shosé shé é dông gam yu pyâm byî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hau htâng, yhangmoq gi, haú jowò má zung to mù, Yhang lé zúng nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yhâng é u htoq má, \"SHÍ YUQ GI, YUDAQ BYU PÊ É HKOHKÂM, YESUQ NGHUT LHÊ.\" ga, Yhang lé mara hun é laiká kâ tap tô akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Haú hkûn, Yhang eq rahá, damyaq í yuq lé le, Yhâng é loqpaî hkyam shut rayuq, loqyo hkyam shut rayuq kut, tapzîng htoq má jén tap tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hkyô sô laî ló é bang gi, nyhap é dông u-ngut ngut mù, taî kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","\"Noqkuq yhûm lé hpyoq pyám luî, sum nyí gyoro má dum wó saî lhê ga Sû ê! Nàng, Garai Gasâng é Yhangzo nghut le gi, Náng gûng nàng hkyi yù luî, tapzîng mai gyó lo wú aq mhaî!\" ga akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Haû eq rajung za, hkyangjong agyi pé, tarâ sará pé eq suwún wuî le, Yhang lé rhoî jihkyoî kut mù, taí kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","\"Shí yuq gi, góbang lé hkyi yù sû nghut kôlhang, Yhânggùng yhang gi, a wó hkyi yù nghut ri myhi-nhung! Yhang gi, Israelaq byu pê é hkohkâm nghut lhê lhà! Ngamoq wó lumjíng râ matú, Yhang, tapzîng mai gyó lo wú sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yhang gi, Garai Gasang lé lumhkaû sû nghut lhê mù, Garai ô nau é sû nghut le gi, ahkuî Yhang lé hkyi yù sháng gaq; hkâsu mù gâ le, Yhang gi, 'Ngò, Garai Gasâng é Yhangzo nghut lhê.' ga taî ri.\" ga bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Haû eq rajung za, Yhang eq rahá tapzîng má jén to huî é damyaq í yuq le, Yhang lé rhoî dang taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nyí-káng raxe í hkyíng mai myinhtâng sum hkyíng jé shoq, ramau gón mauchut tuq dut byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Myinhtâng sum hkyíng kô má, Yesuq gi, \"Eloi, Eloi, lama sabakhtani?\" ga, htê mó èq garû kat ri. Hau é lichyúm gi, \"Ngá Garai ê, Ngá Garai ê, Nàng, haî mù, Ngo lé tô pyâm tô lhê lhú?\" gâ é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Haú nâm má yap tô é bang ra-am gi, haú lé wó gyo kôjáng, \"Yhang gi, myiqhtoi Eliyaq lé wut nyi ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Haú hkûn jáng, yhangmoq mâ é rayuq gi, din e ló mù, wuìmaù lé ê yu ri. Yhang gi, haú lé tsibyiq wing chyîn má jum yù luî, jàm-yang má tuî tap mù, Yesuq shuq râ matú yhun byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Góbang gi, \"Yhang lé, Eliyaq, lé hkyi yu lhê laq, nga-nhúng chôm láng wú sháng.\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Haú hkûn, Yesuq gi, htê mó èq dum garû kat luî, Yhâng é soqkâng byit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Haú u lé, haû noqkuq yhûm mâ é pán-gyang gi, ahtoq mai a-ô í hkyam byáng goq byuq bê nghut ri. Myigùng le nún lô mù, luqgok pé le goq byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lup pé gi, bóng lô mù, shi byuq bê é chyoiyúng bang myo myo gi, lhoq dui é hui akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Haú bang gi, Yesuq dum dui toq é htâng, lup mai htoq lô kômù, chyoiyúng myuq má wang ê luî, byù myo myô hí má htoq shit akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Shô up gyezau hpó eq, yhang eq rahá Yesuq lé zúng nyi é bang gi, layàng nún é eq dut lo é hkyô banshoq lé myàng kôjáng, gyuq dàn kômù, \"Yhang gi, gè gè yhang, Garai Gasâng é Yhangzo nghut ri-nhung!\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Myiwe wuì myo myo le, we we mai wú nyi bum akô. Haú bang gi, Yesuq râ é má garúm râ matú, Galile mau mai Yhang htâng châng lé é bang nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Haú bang má, Magadalaq wà mâ é Mariq, Yakuq eq Yose nhiktâng é yhângnu Mariq eq Zebedi é yhangzô nhiktang é yhângnû pé le bo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Myinhtâng jé lô jáng, Yesuq é chángzo dut bê nghut é, sùt wó sû, Aramahti myuq byù Yosep ga sû lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yhang gi, Pilat chyáng ê mù, Yesuq é gungsôm lé ê dung jáng, Pilat gi, yhang lé byi râ matú hkunmó hkyô kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosep gi, gungsôm lé yù mù, pán yúng èq htup yup luî, ");
INSERT INTO atbNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","luqgok lé kyûng tô é, yhâng é lup sik hkaû má ê kat tô ri. Hau htâng, yhang gi, luphkum má, luqlông èq lhêng chî pyâm to luî, ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magadalaq wà mâ é Mariq eq goyuq Mariq gi, lup hí má zung tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Haû Hên Lajang Buinyì laî é htâng nyí lé, hkyangjong agyi pé eq Hparishe pé gi, Pilat chyáng ê mù, ");
INSERT INTO atbNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","\"Yhumsîng ê, Yhang, asak dui nyi ashî hkûn, 'Sum nyí nghû râ buinyì má, Ngò dum dui toq lô râ.' ga, haû byù mhaú taî é dang lé, ngamoq bûn nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Haû mù, haû sum nyí nghû râ buinyì jé shoq, lup lé rago za zúng nhang to aq. Haû a nghut jáng, Yhâng é chángzô pé, màng lé lé hkaû yu ló mù, Yhang shi é mai dum dui toq lô bê ga, byu pé lé taí kó râ nghut lhê. Shî, ló htâng dàm mhaû é hkyô gi, sâng-hi dàm htoq je wui râ nghut lhê.\" ga, lé taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Haú hkûn, Pilat gi, \"Nungmoq sê é dông, lup lé haî a dut loshoq, gyezô pé lé zúng nhang to keq.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Haû mù, yhangmoq gi, ê luî, lup lé gau shoq ga, luqgok má dizik htung mù, lup zúng byû nyhi to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bánno buinyì lai jáng, rabat é sâng-hi nyí maubó zó má, Magadalaq wà mâ é Mariq eq goyuq Mariq gi, lup má ê wú râ ga, e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Haú hkûn, layàng mó nún lo ri; hkâsu mù gâ le, Yhumsîng Garaî é maumang lagyo rayuq gi, mauhkûng mai gyó lé lô mù, lup má ê luî, haû luqlong lé tu lheng mù, hau ahtoq má zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yhâng é isâm gi, lhap su duqbó mù, Yhâng é mebu gi, gyo su hpyu zan tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Zúng nyi é bang gi, yhang lé lûm wú gyuq kômù, pyik pyik nán luî, shî gùng su dut bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Haû maumang lagyo gi, myiwe haú nhik lé, \"Hkâgyuq kó! Haû tapzîng má jén sat huî é Yesuq lé, nungnhik ho nyi kô é lé, ngò sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yhang gi, shí má a nyì lo; Yhang taî tô é eq rajung za, lhoq dui toq é hui bê nghut ri. Yhang lé lheq é jowò lé, lé wú keq. ");
INSERT INTO atbNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Haû mù, hân taû ló luî, Yhâng é chángzô pé lé, 'Yhang, shi é mai lhoq dui toq é hui bê nghut ri; nungmoq é hí má, Galile mau shut ló láng berâ. Nungmoq, Yhang lé, haú má ló myâng kó râ nghut lhê.' nghû ló taî kyo keq. Nungnhik lé, ngò taî é lé matsîng chûng keq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Haû mù luî, myiwe myhí haú nhik gi, gyuq kôlhang, gyai gabú é myit èq lup mai hân taû ló mù, Yhâng é chángzô pé lé ló taî kyo râ matú, din ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Haú hkûn, Yesuq gi, radá dâm yhangnhik lé lhom tê mù, \"Wángzán nyî kó sháng gaq.\" ga taî ri. Haû mù, yhangnhik gi, huî ê luî, Yhâng é hkyî má po zing to mù, Yhang lé noqkuq akô. ");
INSERT INTO atbNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Haú hkûn, Yesuq gi, yhangnhik lé, \"Hkâgyuq kó. Ngá é gumang wuì lé, Galile mau shut e ló keq nghû ló taî kyo keq; haú má, yhangmoq, Ngo lé myàng kó râ nghut lhê.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Myiwe haú nhik hkyô má ru nghut nyi ashî le, lup zúng é gyezô pé ra-am gi, myuq hkaû má wang ló mù, dut lai lo é hkyô banshoq lé, haû hkyangjong agyi pé lé ló taî kyo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Haû hkyangjong agyi pé gi, suwún wuî eq huî lhum luî, hpyê lhûm é htâng má, haû gyezô pé lé, ngùn myo myo tsup byi mù, ");
INSERT INTO atbNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","\"'Myín lé, ngamoq yhup myhî tô é hkûn, Yhâng é chángzô pé lé lô mù, màng lé, lé hkaû yu ló bekô nghut ri.' nghû taí keq. ");
INSERT INTO atbNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Shí hkyô lé, haû mauzau hpó wó gyô é nghut jáng, yhang myit ngón shoq, ngamoq taí râ nghut lhê; haú hkûn, nungmoq gi, hai manghkáng a htoq râ nghut lhê.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Haû mù, gyezô pé gi, ngùn haú pé lé yù luî, yhangmoq lé taî kat é eq rajung za kut bekô nghut ri. Haû su mù, haú hkyô gi, Yudaq byu pé má taî pyo myhîn ló bê nghut mù, ahkuî jé shoq taî nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hau htâng má, haû chángzo raxe rayuq gi, yhangmoq lé, Yesuq ê nhang tô é Galile mau mâ é bùm shut e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yhangmoq gi, Yesuq lé myàng kôjáng, noqkuq akô; nghut kôlhang, ra-am gi, a dê jíng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hau htâng, Yesuq gi, yhangmoq chyáng lé lô mù, \"Mauhkûng eq myigùng htoq mâ é ahkáng ayá banshoq, Ngo lé byî to bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Haû mù, nungmoq gi, htoq ê luî, byù myû chângjup lé, Ngá é chángzô pé dut nhâng mù, haû Îwa, Yhangzo, Chyoiyúng Woi-nyí é myìng lang luî, wui-myhup hkám byi mù, ");
INSERT INTO atbNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nungmoq lé, Ngò hkunmó hkyô tô é lhunglháng lé châng kut râ matú, yhangmoq lé mhoqshit keq. Ngò gi, mingkan pyat htûm é hkûn jé shoq lháng, nungmoq eq rahá ru nghut nyî râ nghut lhê.\" ga pying tô ri.");
INSERT INTO atbNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Haû Garai Gasâng é Yhangzo, Yesuq Hkrisduq eq sêng é gabú danglù hi é hkyô gi, ");
INSERT INTO atbNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","haû myiqhtoi Esai-aq laiká má: \"Náng é hkyô lajang láng râ matú, Ngá é lagyo lé, Náng é hí má Ngò nhang kat râ nghut lhê.\" ga luî le, ");
INSERT INTO atbNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"Haû yoso má, byù rayuq garû taî é htê gi, 'Haû Yhumsing é matú, hkyô hen to keq; Yhâng é matú hkyô lhoq nyhang to keq.'\" ga luî le, kâ tô é eq rajung za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Haû mù, Wui-myhup Sará Yohan gi, yoso hkaû má jé lé luî, wui-myhup hkám byî nyi é eq, yubak mara hkyut pyám byî é hui râ matú myit lhîng mù, wui-myhup hkâm yù râ hkyô lé, hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Haú hkûn, Yuda mau jowò hkangmó mâ é bang eq Yerusalem wà mó mâ é banshoq bang gi, yhâng chyáng htoq e bum akô. Yhangmoq gi, yhumsing é mara lé yín yû kôluî, yhâng chyáng mai Yodan làng má wui-myhup hkâm yu bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohan gi, gola-uq shomaú èq saî é mebu wut mù, yhâng é hpyidum má gi shokuq hpyihit hit ri; yhang gi, dinggám eq yosô byo-î pé lé zo sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yhang taî kyô é dang gi, \"Ngá htoq má wum-o a-tsam je bo é sû rayuq, ngá htâng má jé lé râ nghut lhê; ngò gi, yhâng é hkyî-tsung tui lé hpyî râ lháng a gingdán é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngò gi, nungmoq lé, wui èq za wui-myhup wó hkám byi lhê; nghut kôlhang, Yhang gi, Chyoiyúng Woi-nyí má nungmoq lé wui-myhup hkám byi râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Haû yoq má, Yesuq gi, Galile mau Nazaret wà mai lé jé mù, Yohan chyáng Yodan làng má wui-myhup hkâm yu ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesuq gi, wuì mai htoq lo é u lé, mauhkûng bóng lo é lé le, Woi-nyí gi, hpûngkyui gunghkyâng sû é dông mai, Yhang ahtoq má gyó lé lo é lé le, Yhang myang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Haú hkûn, \"Nàng gi, Ngò chyitdap é Ngá zo nghut lhê; Náng é ahtoq má Ngò gabú myit ngón nyi lhê.\" ga mauhkûng mai danghtê htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Haú hkûn jáng, Woi-nyí gi, Yhang lé yoso shut wang e ló nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Haû mù, Yhang gi, yoso má myi xê nyí nyì luî, Tsadán èq gunglaú é huî ri; tân jung yosô zè pé le, Yhang eq rahá nghut nyi ri; maumang lagyô pé gi, Yhang lé, lé dojaú nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohan htóng gyó é htâng má, Yesuq gi, Galile mau má ló jé mù, ");
INSERT INTO atbNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","\"Ahkyíng gi, jé bê; Garai Gasâng é mingdán gi, chyâng lò bê nghut ri; myit lhîng mù, haû gabú danglù lé lumjíng keq hkoi.\" ga luî, Garai Gasâng é gabú danglù lé hkô kyo wún ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuq gi, Galile nhông yàm mai sô laî ló le, Simun eq yhanggu Andre nhiktâng, nhông má gùn dú nyî kô é lé, myang ri; haû nhik gi, ngozo kóng zo su nhik nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Haû mù, Yesuq gi, haú nhiktâng lé, \"Ngá htâng cháng keq; Ngò, nungnhik lé, byù lé châng kóng su nhik dut nhâng râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Haú hkûn, yhangnhik gi, radá dâm, gùn pé lé tô pyâm to luî, Yhang htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuq gi, radun zo dum sô e ló é hkûn, Zebedi é yhangzo, Yakuq eq yhanggu Yohan nhiktâng, lhaî hkaû má gùn hpo nyì kô é lé, myang ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Haú hkûn, Yhang gi, radá dâm, yhangnhik tâng lé wut kat jáng, yhangnhik tâng gi, yhangnhik é yhângwa Zebedi eq langchyâng pé lé, lhaî hkaû má nyhi pyâm to kôluî, Yhang htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yhangmoq gi, Kaperna-um wà má e akô; Bánno buinyì nyí jé jáng, Yesuq gi, tarajong má wang ê mù, mhoqshit hi ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Shiwa byu pé kúm gi, Yhang mhoqshit é hkyô lé mauhong bum akô; hkâsu mù gâ le, Yhang gi, tarâ sará pé eq a pung é za, ahkáng ayá wó sû rayuq su, yhangmoq lé mhoqshit é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Haú u lé, agè ashop é nat wang júng é byù rayuq tarajong má bo lom nyì luî, wut garû kat é gi, ");
INSERT INTO atbNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"Nazaret wà byù Yesuq ê, ngamoq gi, Nàng eq haî sêng lhê lhú? Ngamoq lé lhoq hten râ matú, Nàng jé lé é nghut lhê lhú? Nàng gi, Garai Gasâng é Chyoiyúng Sû nghut é lé, ngò sê lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Haú hkûn, Yesuq gi, \"Hkâjop, yhâng chyáng mai htoq ló aq.\" ga yhang lé tân kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Haú hkûn, agè ashop é nat haû gi, byù haú yuq lé wum kat langhtân nhâng luî, htê mó èq garu uchyang htoq ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Shiwa byù banshoq bang gi, gyai yhang maú byuq kômù, rayuq eq rayuq, \"Shí yuq é dang gi, hkasû é dang wá nghut lhê lhú? Ahko ahkáng bo é dông mhoqshit é hkyô asik nghut ri-nhung! Yhang gi, agè ashop é nat pé lé hkunmó hkyó jáng, haú bang lháng gyo byî akô nghut ri.\" ga luî, taî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesuq eq sêng é ludang gi, Galile mau jàm shoq, yang é dông byo myín ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yhangmoq gi, tarajong mai htoq luî, haú hkûn jáng, Yakuq eq Yohan nhik le mù, Simun eq Andre nhiktâng é yhûm má wang e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simûn é yhâng-aumó gi, gyai yhang nò leq tô é nghut mù luî, yhangmoq gi, Yesuq lé haú yuq no é hkyô lhom taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Haû mù luî, Yesuq gi, yhâng chyáng huî ê mù, yhâng é loq má zui luî tu tsung ri; haú hkûn jáng, nò ge byuq luî, yhang gi, yhangmoq lé gaí tso gaí huq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Haû nyí buiwang é htâng má, byu pé gi, no é bang eq nat gang wang júng nyi é bang banshoq lé, Yesuq chyáng shuî lé lo bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Rawa bang, hkúmdong nàm má lé zup zing tô akô. ");
INSERT INTO atbNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Haû mù, Yesuq gi, awáng nòhpyo ajung jung huî é bang myo myo lé lhoq gê byî ri; nat gang myo myo lé le, hkat htoq pyâm ri; nghut kôlhang, Yhang ó nghut é lé nat gang haú bang sé kô é yanmai, nat gang haú bang lé dang a taí nhâng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesuq gi, htang napkyó mau lháng a bó shimá, toq mù, gaû é jowò ralhum má htoq ê luî, kyû ê dûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simun eq yhâng é luzúm wuî kúm gi, Yhang lé châng hô kômù, ");
INSERT INTO atbNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yhang lé myang hô kôjáng, \"Yuq hkangmó gi, Nang lé châng hkat ho nyi akô.\" ga luî, taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Haú hkûn, Yesuq gi, yhangmoq lé, \"Awui ayàm mâ é wà pé má le, ngò, mungdang wó hkô râ matú ê sháng, hau é matú ngò lé é ru nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Haû mù luî, Yhang gi, Galile mau ramau gón, tarajong pé má mungdang hkat hko wún é htoq agó, nat gâng pé lé le hkat htoq pyám byî wún ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Manggâm dap é byù rayuq gi, Yesuq chyáng lé mù, hkyihput htuq luî, \"Nàng dóng é nghut le gi, ngò lé Nàng wó lhoq sân-yúng byi râ nghut lhê.\" ga dung wut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Haú hkûn, Yesuq gi, yhang lé wú shogyo luî, loq lhâm kat mù, haú yuq lé ê záng luî, \"Ngò dóng lhê, sân-yúng aq hkoi.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Haú hkûn jáng, manggâm ana byuq byuq luî, yhang gi, gè bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesuq gi, \"Nàng, shí hkyô ó lé le hkâtaî kyo. Nghut kôlhang, náng é gungdu lé, hkyangjong hpô chyáng ló tûn shit mù, nàng sân-yúng bê hkyô lé yhangmoq é matú saksé dut sháng gaq, Mosheq tarâ tô tô é eq rajung za, hkungga ló nhông byi aq.\" ga, yhang lé gyai yhang sidiq byi mù, radá dâm nhang kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nghut kôlhang, haú yuq gi, htoq ló mù, haú hkyô lé je taî pyo myhîn ló bê nghut ri. Hau é yanmai, Yesuq gi, wà hkaû má de de a ge wang ló lo mù, shinggan mâ é chamchyuiyuì dut é jowò má za nyì nyi ri. Nghut kôlhang, byu pé gi, jowò hkangmó mai Yhâng chyáng ru zîng lé nyi bum ashî kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Buinyì hkâ-myháng a myáng má, Yesuq gi, Kaperna-um wà má dum wang lò jáng, Yhang yhûm dum taû jé lô bê gâ é hkyô lé, byu pé wó gyô bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Haû mù, byù myo myo zîng lé lô kôluî, yhúmhkaû má jowò a joq lô é htoq agó, hkumtot má lháng a joq lo nghut ri; Yesuq gi, yhangmoq lé mungdang hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Haú hkûn, byù myi yuq gi, gùngjum shî sû rayuq lé chôm dang waq luî, Yhâng chyáng lé lo akô. ");
INSERT INTO atbNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yhangmoq gi, byù lûm myô chyîn chyap to mù, byù haú yuq lé Yesuq chyáng a wó shuî jé ê kô é yanmai, Yesuq é u htoq mâ é yhumhkûng lé dong htông yù luî, gùngjum shî sû lé taphkang eq roq hkyô kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesuq gi, yhangmoq é lumjíng myit lé byu-myàng jáng, gùngjum shî sû lé, \"Ngá zo ê, náng é yubak mara lé hkyut pyám byi bê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Haú hkûn, tarâ sará pé ra-am gi, haú má zung to kôluî, yhangmoq é i-myit unghkaû má, ");
INSERT INTO atbNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"Byù shí yuq gi, haî mù luî haû su gâ lhê laq? Yhang gi, Garai Gasang lé rhoî dang taî nyi ri; Garai Gasang mai lai luî, ó yuq wá mara wó hkyut byi râ lhú?\" ga luî, myit són wuî nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesuq gi, yhangmoq é unghkaû má myit wú nyî kô é hkyô lé, radá dâm Yhang é myit mai sé mù, \"Nungmoq é i-myit hkaû má, haî mù haû su nghû myit són wuî nyi bum akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Haû gùngjum shî sû lé, 'Náng é yubak mara lé hkyut pyám byi bê.' nghû taî é dang eq, 'Toq aq, náng é taphkang lé yù mù, hkyô so aq.' nghû taí râ má, hká hkun je taí lui lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nghut kôlhang, haû Byu Yhangzo gi, mingkan htoq má, mara hkyut byi râ ahkáng wó Sû nghut é lé, nungmoq lé sé nhâng nau lhê.\" ga, yhangmoq lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Hau htâng, Yhang gi, haû gùngjum shî sû lé, \"Ngò, nang lé taí bá, toq aq, náng é taphkang lé yu chûng luî, yhûm taû ló aq hkoi.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Haú yuq gi, toq mù, yhâng é taphkang lé yu chûng luî, yhangmoq banshoq bang wú tsuq tô é myoq hí mai sô htoq ló byuq bê nghut ri. Hau é yanmai, yuq hkangmó gi, mauhong bùm kômù, \"Isû é hkyô gi, hkâ-nhám lháng a myàng wú shi.\" ga, Garai Gasang lé hkya-on kungton bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuq gi, nhông yàm má radàm dum htoq e ri. Haú hkûn, byù moq mó gi, Yhâng chyáng jé lé lo bùm kômù, Yhang gi, haú bang lé lhom mhoqshit nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yhang gi, sô yông ló nyi é hkûn, kang guq zúm má zung tô é, Alhpe yhangzo Lewiq lé myang kat luî, \"Ngá htâng cháng aq.\" ga taî ri. Haú hkûn, Lewiq gi, toq luî, Yhang htâng cháng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuq gi, Lewiq é yhûm má myinzang ê zô nyi é hkûn, kang guq bang myo myo eq yubak dap bang le, Yhang eq Yhâng é chángzô pé eq rahá zo shuq bum akô. Hkâsu mù gâ le, Yhang htâng châng é bang gi, ajùm ayò nghut é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tarâ sará nghut é Hparishe pé ra-am gi, yubak dap bang eq kang guq zo bang le mù rahá, Yesuq zang zô nyi é lé myàng kôjáng, Yhâng é chángzô pé lé, \"Yhang gi, haî mù luî, kang guq bang eq yubak dap bang eq rahá zo shuq nyi lhê lhú?\" ga myî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Haû su ga myi kô é lé Yesuq wó gyo jáng, Yhang gi, yhangmoq lé, \"Wángzán bang gi, chi sará a ra kó, nòhpyo hui bang za sheq ru râ lhê. Haû eq rajung za, Ngò gi, dingmán bang lé wut yù râ matú jé lé é a nghut, yubak dap bang lé ji yù râ matú sheq jé lé é ru nghut lhê.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohan é chángzô pé eq Hparishe pé gi, zoshuq gám nyi akô nghut ri. Haû mù, ra-am gi, Yesuq chyáng jé lé kômù, \"Wui-myhup Sará Yohan é chángzô pé eq Hparishe pê é chángzô pé gi, zoshuq gám akô; nghut kôlhang, náng é chángzô pé gi, haî mù a gám kô é lhú?\" ga luî, myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Haú hkûn, Yesuq tû taî é gi, \"Bíng pé gi, lusik eq rahá nghut nyi tô ashî hkûn, zoshuq hkâsu wó gám râ lhú? Yhangmoq gi, lusik eq rahá nghut nyi é u lé, zoshuq gám kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nghut kôlhang, lusik lé yhangmoq chyáng mai shuî yu pyâm é hkyíng jé râ nghut lhê; haú buinyì pé má kúm gi, yhangmoq, zoshuq gám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ó yuq le, mebu xau má pán sik èq a lhaq hpo wú kó; haû su kut é nghut jáng, pán sik gi, kun byuq mù, mebu xau le je lhoq cheq pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Haû eq rajung za, tsibyiq wing asik lé le, shokuq htûng axau má ó a kat wú kó. Kat é nghut jáng, tsibyiq wing asik gi, htûng lé lhoq buq goq nhâng luî, tsibyiq wing eq shokuq htûng htên byuq râ nghut lhê. Haû mù, tsibyiq wing asik gi, shokuq htûng sik má za ge kat é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bánno buinyì ra-nyí má, Yesuq gi, Yhâng é chángzô pé eq rahá yò hkaû mai sô laî ló é hkûn, Yhâng é chángzô pé gi, kyôshi ratsuí langshap yu akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Haû mù, Hparishe pé gi, Yesuq lé, \"Wú aq, Bánno buinyì má a ge kut jung lé, haî mù, náng é chángzô pé kut nyi akô lhú?\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Haú hkûn, Yesuq gi, yhangmoq lé, \"Dawiq lháng gi, yhâng htâng châng é bang eq rahá zòmut hui luî, zoshuq râ tô é hkûn, hkâsu kut é hkyô lé, nungmoq hkâ-nhám le a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiahta, hkyangjong mó kut nyi é u lé, Dawiq gi, Garai Gasâng é yhúmhkaû má wang ê mù, hkyangjông pé mai lai luî, ó le a ge zô é, kyâng tô é muk lé yù zo mù, yhang htâng châng é bang lé le ratsuí tsuí byi tso é nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hau htâng, Yhang gi, yhangmoq lé, \"Bánno buinyì gi, byù é matú kut tô é nghut lhê; byù gi, Bánno buinyi é matú a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Haû mù, haû Byu Yhangzo gi, haû Bánno buinyi é Yhumsîng lháng nghut lhê.\" ga xoq taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuq gi, tarajong má radàm dum wang e le, loq raloq ajum shi byuq é byù rayuq nyi to láng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Haú hkûn, haú má nyi tô é bang ra-am gi, Bánno buinyì má, Yesuq mai haú yuq lé lhoq gê byi râ lhú ga, mara hûn râ matú gyám wú nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuq gi, haû loq jum shî sû lé, \"Banshoq bâng é hí má, toq yap shit aq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hau htâng, Yhang gi, haú má nyi tô é bang lé, \"Bánno buinyì má, ge é muzó kut râ, a ge é muzó kut râ, byù asak hkyî râ eq byù sat râ hkyô pé má, hká lhum kut le sheq tarâ wang lhê lhú?\" ga myî kat jáng, yhangmoq kúm gi, jit le a ga kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Haû mù, Yhang gi, nhik-yô nau é myit èq haú bang lé lhîng wú mù, yhangmoq myit htan é hkyô lé, wú yón luî, haû loq jum shî sû lé, \"Náng é loq nyhang kat aq.\" ga taî kat jáng, haú yuq gi, loq nyhang kat luî, yhâng é loq gi, shoq za ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hau htâng má, Hparishe pé gi, htoq ló kômù, Yesuq lé hkâsu kut wó sat pyám râ hkyô lé, Herut é byu pé eq chôm hpyê lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuq gi, Yhâng é chángzô pé eq rahá, nhông shut dum e ló le, Galile mau mâ é byù ajùm ayò gi, Yhang htâng châng e ló bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Hau htoq agó, Yuda mau mâ é bang, Yerusalem wà mó mâ é bang, Idumia mau mâ é bang, Yodan làng hé hpoq mâ é bang, Turuq myuq eq Sidun myuq awui ayàm jé shoq mâ é bang, ajùm ayò gi, Yhang kut nyi é hkyô banshoq lé wó gyo kôjáng, Yhâng chyáng jé lé bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesuq gi, byù myo myo lé lhoq gê byî é yanmai, nòhpyo hui to bang gi, Yhang lé wó záng shoq ga, chyîn chyap wang ló bum akô. Byù lûm myo luî, Yesuq gi, Yhang lé a nhê pyet pyám sháng gaq ga, Yhâng é chángzô pé lé lhaî ralhum hen to nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Agè ashop é nat pé gi, Yhang lé myàng hkangmó, Yhâng é hí má lêng ngop to luî, \"Nàng gi, Garai Gasâng é Yhangzo nghut ri.\" ga luî, taî garû akô. ");
INSERT INTO atbNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nghut kôlhang, Yesuq gi, Yhang ó yuq nghut é hkyô lé a taî byông htoq râ matú, tân hkúm kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesuq gi, bùm shut doq ló mù, Yhang ô nau é bang lé ji kat luî, haú bang gi, Yhâng chyáng jé lé lo bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Haú hkûn, Yesuq gi, byù raxe í yuq lé hkyin yù luî, lagyo ayá byî ri; haú bang gi, Yhang eq rahá nyì râ matú le, mungdang hkô râ matú Yhang nhang htoq kat râ eq, ");
INSERT INTO atbNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nat gâng pé lé hkat htoq râ ahko ahkáng wó râ matú le, nghut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Haû raxe í yuq gi, Simun (Yesuq mai Petruq ga myìng myhíng byi sû); ");
INSERT INTO atbNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi é yhangzô nhiktâng Yakuq eq yhanggu Yohan (Yháng nhiktâng lé Yesuq mai Buanerga ga myìng myhíng byî ri; hau é lichyúm gi, maugum zô nhik gâ é nghut lhê.); ");
INSERT INTO atbNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Hpilip, Barhtolume, Mahte, Htomaq, Alhpe é yhangzo Yakuq, Htade, Zelutuq dut é Simun eq, ");
INSERT INTO atbNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yhang lé ap pyám râ sû, Yudaq Iskarut pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hau htâng, Yesuq gi, yhûm má wang ló le, byù ajùm ayò dum zîng lé lô kômù, Yhang eq Yhang é chángzô pé gi, zang zo hkyíng lháng a wó kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yhâng é yhumbyù wuì gi, haú hkyô lé wó gyo kôjáng, \"Yhang, myit a gying lo nghut ri.\" ga luî, Yhang lé hung shuî yù râ matú, e akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yerusalem wà mó mai gyó lé lo é tarâ sará pé gi, \"Shí yuq gi, Bezebulaq gâ é nat gâng pê é zau lúng sû nghut ri-nhung! Yhang gi, nat zaû é wum-o a-tsam èq za, nat gâng pé lé hkat htoq pyâm é nghut ri.\" ga taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Haû mù luî, Yesuq, yhangmoq lé wut yù mù, dangtú dong taî é gi, \"Tsadán gi, Tsadán lé hkâsu kut wó hkat htoq râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mingdán ralhum gi, ahkaû má byoq gâng lhûm nyì kô é nghut jáng, mingdán haû wó gîng nyì râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yhumhtu ralhum má le, ikun byù yhangchang byoq gâng lhûm nyi é nghut le gi, yhumhtu haû wó gîng nyì râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Haû eq rajung za, Tsadán le, yhânggùng yhang lhoq hpyoq luî, gam hkoq nyi é nghut le gi, yhang wó nyi nyì râ a nghut, htûm byuq râ za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ó yuq nghut kôle, wum-o bò sû lé hí tui zing pyâm é a nghut le gi, yhâng é yhûm má lú wâng mù, yhâng é sutzè lé wó lú yû râ a nghut: Haú yuq lé hí tuî zing pyám jáng sheq, yhâng é sutzè lé wó lú yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ngò, nungmoq lé teng za taí kôlé, byu pé kut shut é mara banshoq eq rhoî dang taî pyâm é pé lé gi, mara wó hkyut pyám byî lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nghut kôlhang, haû Chyoiyúng Woi-nyí lé rhoî dang taî pyâm é sû gi, hkâ-nhám le, mara hkyut byî é wó hui râ a nghut; haú yuq gi, ahtum abyuq yubak wó sû nghut nyi ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yhang haû su ga taî é gi, yhangmoq mai, \"Yhang gi, agè ashop é nat wó sû nghut ri.\" ga kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hau htâng, Yesuq é yhângnu eq yhanggu pé gi, jé lé mù, yhûm hkun má yap to kôluî, Yesuq htoq lô râ matú, byù rayuq lé wang taí nhang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Byù ajùm ayò gi, Yhâng é lhînghkyuq má zung tô akô; haú bang gi, Yhang lé, \"Wú aq, náng nu eq nunggu pé gi, nang lé hui naû luî, shinggan má láng bum akô.\" ga taí kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Haú hkûn, Yhang gi, \"Ô pé gi, Ngá nu eq Ngá gu pé nghut akô lhú?\" ga myi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hau htâng, Yhang gi, Yhâng é lhînghkyuq má zung hkyuq tô é bang lé wú mù, taî é gi, \"Shí bang gi, Ngá nu eq Ngá é gumang wuì nghut bê! ");
INSERT INTO atbNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Garai Gasang ô nau é hkyô châng é sû ó yuq nghut kôle, Ngá gu, Ngá mang, Ngá nhá, Ngá nu chyat nghut bê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuq gi, nhông yàm má radàm dum mhoqshit hi ló bê nghut ri. Haú hkûn, Yhâng é lhînghkyuq má byù moq mó lûm yán zîng lé lo bùm kô é yanmai, Yhang gi, nhông hkaû mâ é lhaî má wang zung tô ri; haú u lé, byù moq mó gi, nhông yàm gin-gau htoq má nyi míng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yhang gi, haú bang lé, dangtú pé dông myo myo mhoqshit byî nyi ri; Yhang mhoqshit é má, ");
INSERT INTO atbNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"Gyo wú keq! Kyô hkyó sû rayuq gi, kyôshi san râ gâ htoq e ló ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yhang, kyôshi sân kat é hkûn, ra-am gi, hkyô má gyó ang mù, nghoq pê èq lé hte zô pyám ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ra-am gi, myi-tse a htu é luqgok yò pé má gyó ang mù, myi-tse a htu é yanmai, luì za yuq htoq ló kôle, ");
INSERT INTO atbNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","amyit a wó chîn hing é nghut mù, buì htoq lô jáng, lhap kyuq pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dum ra-am gi, zugyóm hkaû má gyó ang luî, zubyap haú pé kô lò mù, wup pyâm é yanmai, ashi a wó zui nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nghut kôlhang, ra-am gi, myìhpún bo é jang má gyó âng é yanmai, yuq kô lò mù, ashi sum xê tú, hkyuq xê tú, rashô tú lháng, zui myô lo é nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hau htâng, Yesuq dum taî é gi, \"Gyo yù râ nohkyap dap sû gi, gyô yù sháng gaq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yhang baú za nghut nyi é hkûn, haû lagyo raxe í yuq eq Yhang nàm má nyi tô é bang gi, dangtú haû eq sêng é hkyô lé, lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Haú hkûn, Yhang, yhangmoq lé taî kyô é gi, \"Garai Gasâng é mingdán eq sêng é sê gyo wuî é hkyô lé sé gyo râ ahko ahkáng, nungmoq lé byî to lugù nghut bê. Nghut kôlhang, góbâng é matú gi, jung hkangmó lé dangtú dông chyat taî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Haû mù luî, 'Yhangmoq gi, myang nyì kôlhang, a wú sé kó, gyô nyì kôlhang, a sê gyo kó; sé wú sê gyo kô é ru nghut le gi, lhîng taû lò mù, mara hkyut pyám byî é hui kó râ nghut lhê!' gâ ri.\" ga tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hau htâng, Yhang, yhangmoq lé dum xoq taî é gi, \"Nungmoq, dangtú shî lé a sê gyo kô é nghut le gi, gotû dangtú pé lé hkâsu kut ung sê gyo kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yò mû zui sû san kat é kyôshi gi, mungdang nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Byù ra-am gi, hkyô má gyó âng é kyôshi eq wuí akô; yhangmoq gi, mungdang lé wó gyô yu é hkûn yhang, Tsadán gi, lé mù, yhangmoq chyáng mâ é mungdang lé lé yù pyám byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ra-am gi, luqgok yò pé má gyó âng é kyôshi eq wuí akô; yhangmoq gi, mungdang lé wó gyo jáng, radá dâm gabú myit èq hap yù akô. ");
INSERT INTO atbNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nghut kôlhang, yhangmoq gi, amyit a wó chîn é yanmai, razup zo za yuq kômù, mungdâng é yanmai, wuîhke é eq zing-rî é pé hui kôjáng, hân hân htak ló byuq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dum ra-am nghut jáng, zugyóm hkaû má gyó âng é kyôshi eq wuí akô; yhangmoq gi, mungdang lé wó gyô yù kôlhang, ");
INSERT INTO atbNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","shí ipyat lhê é myit wui myit hke hkyô, hkyô shuî nghoq jung ngùn hîng zèhkoq eq gotû zè pé lé ô nau é hkyô pé, yhangmoq chyáng wang lò jáng, haû mungdang lé hup pyâm é yanmai, ashi a wó zui dut kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ra-am kúm gi, myìhpún bo é jang má gyó âng é kyôshi eq wuí akô; yhangmoq gi, haû mungdang lé gyô yù mù, lhom yù luî, sân kat é htoq sum xê tú, hkyuq xê tú, rashô tú lháng myo shoq ashi zuî lò kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuq, yhangmoq lé xoq taî é gi, \"Nungmoq gi, myibung lé yù mù, tsungjang má a tsung e za, mûng èq nghop tô é, a nghut jáng, yhupchong ô má tsung tô é, ó yuq wá kut wú akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hkâsu mù gâ le, haq tô é zè haí jung le htoq ze lò râ eq, zaú tô é pé haí jung le byông htoq lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gyô yù râ nohkyap dap sû ó yuq nghut kôle, gyô yù sháng gaq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hau htoq agó, Yhang dum taî é gi, \"Nungmoq gi, wó gyô yu é hkyô lé rago myit wú keq; nungmoq lik byî é bung èq, nungmoq lé dum lik byi râ nghut lhê; hau htoq lháng myo shoq wó kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hkâsu mù gâ le, wó to sû lé gi, jat byi shirâ, a wó su chyáng mai kúm gi, yhang wó tô é lé lháng yu pyám byi shirâ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hau htâng, Yhang dum xoq taî é gi, \"Garai Gasâng é mingdán gi, byù rayuq mai, myigùng má sân kat é kyôshi eq wuí ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Byù haú yuq gi, myín lé yhup tô é nghut nghut, nyí lé toq lo é nghut nghut, kyôshi gi, zuí htoq lô mù, yuq kô lo nyi ri; nghut kôlhang, yhang gi, hkâsu kut yuq lo nyi é hkyô lé a sé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Myigùng gi, yhang baú yhang, kyôshi lé, sâng-hi má abum bum nhâng, hau htâng má a-nhâm htoq nhâng mù luî, ashi zui shoq kut é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kyôshi myhíng jáng, kyô shu yoq jé bê nghut é yanmai, yhang gi, zaiyik èq yâm yù râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuq dum xoq taî é gi, \"Garai Gasâng é mingdán lé, hai èq lhoq whuî wú râ lhú? Haí jung dangtú yù mù, shit wú râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Garai Gasâng é mingdán gi, angshi cham eq wuí ri. Angshi cham haû gi, myigùng má hô é kyômyui jí pé má je tiq é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nghut kôlhang, ho mù, yuq kô lô jáng, xun hkyâm má hô é mhan-haq hpoqnoq gàm banshoq htoq má je kô é agàm dut lò mù, akoq kô lò luî, hau é buishûm hkaû má, maulat nghoq zô pé lé wó zung nô nyi é nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Haû sû é dangtú myo myo dông mai, Yesuq gi, yhangmoq wó sê gyô é myhó, mungdang hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yhang gi, yhangmoq lé, dangtú a bo é haî lháng a taî wú nghut ri; nghut kôlhang, Yhang eq chángzô pé baú nghut nyi é hkûn kúm gi, jung hkangmó é lichyúm lé taî sân kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Haû nyí, myinhtâng lé, Yesuq gi, Yhâng é chángzô pé lé, \"Nga-nhúng nhông hé hpoq shut dap e ló sháng.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Haú hkûn, chángzô pé gi, byù moq mó lé nyhi pyâm to luî, Yhang zung tô é lhaî mai yhang, Yhang lé shuî gû dap ló bekô; gotû lhaî pé le, yhangmoq eq rahá bo gû dap ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Haú u lé, laidun mó jé lô mù, wuìlhêng hta toq lô luî, lhaî má lo bat hâng é yanmai, wuì byíng lô bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Haú hkûn, Yesuq gi, lhaî htâng má uhkuq hkuq mù yhup myhî tô ri; haû chángzô pé gi, Yhang lé nhaû pun luî \"Sará ê, nga-nhúng myup shi ló râ dut é lé, nàng a chiq byi lhú?\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesuq gi, toq mù, laidun lé tan luî, wuìlhêng lé, \"Zim aq.\" ga taí kat jáng, haû laidun num ló byuq luî, banshoq zîm byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hau htâng, Yhang gi, Yhâng é chángzô pé lé, \"Haî mù, haû-í gyuq bum akô lhú? Nungmoq gi, lumjíng myit a bò shi kó lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yhangmoq gi, gyai yhang gyuq dan bùm kômù, \"Shí yuq gi, hkasû é byù nghut lhê lhà? Laì eq wuìlhêng pé lháng gi, Yhâng é dang lé gyo byî ri-nhung!\" ga luî, rayuq eq rayuq myî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yhangmoq gi, nhông hé hpoq mâ é Gerase byu pê é mau má jé dap e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesuq lhaî mai htoq ló é hkûn, agè ashop é nat wang júng é byù rayuq gi, lupdùng mai htoq lé lô mù, Yhang lé lhom huî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Haú yuq gi, lupdùng má za nyi é sû nghut ri; yhang lé, ó yuq èq le, shamtoq-tuî èq lháng a wó tuî zing wú kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hkâsu mù gâ le, adàm dàm, yhâng é loq eq hkyî má shamtoq-tuî èq tuî tô wú kôlhang, yhang gi, loq mâ é shamtoq-tui pé lé lâng hpyit pyám pyám kut mù, hkyî mâ é shamtoq kyum lé lhoq hkyop pyám pyám kut ri. Yhang lé, ó yuq èq le a wó hkuq yù kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yhang gi, nyí myín aga lupdùng eq bùm pé má puk garu uchyang, yhumsing gùng lé luqgok èq dûn cheq wún ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yhang gi, Yesuq lé, we mai myang kat jáng, din e ló mù, Yhâng é hí má hkyihput htuq ngop luî, ");
INSERT INTO atbNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","htê mó èq, \"Myhang htâng é Garaî Yhangzo Yesuq ê! Nàng gi, ngò eq haî sêng lhê lhú? Nàng gi, ngo lé a zing-ri râ matú, Garai Gasâng hí má danggidiq byi laq.\" ga taî garû ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Haî mù gâ le, Yesuq gi, yhang lé, \"Agè ashop é nat nàng ê, byù shí yuq chyáng mai htoq ló aq.\" ga taî kat é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hau htâng, Yesuq gi, \"Náng myîng haî gâ lhê?\" ga, yhang lé myi jáng, yhang gi, \"Ngamoq gi, myo myo nghut é yanmai, Legio gâ lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hau htâng, yhang gi, haú jowò mai yhangmoq lé a kôn pyám râ matú, Yesuq lé dum dung dung kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Haú u lé, waq rajùm mó gi, bùm yàm má dû but zô nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Haû mù luî, nat gâng pé gi, \"Ngamoq lé, waq pê chyáng nhang kat luî, yhangmoq chyáng wàng nhâng laq.\" ga luî, Yesuq lé dung akô. ");
INSERT INTO atbNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Haú hkûn, Yesuq gi, yhangmoq lé ahkáng byî kat jáng, haû agè ashop é nat pé gi, haú yuq chyáng mai htoq ló kôluî, waq pê chyáng wang ló byuq bekô nghut ri. Haû mù, haû í hkyîng kô bo é waq hpúng gi, gampyoq mai nhông hkaû shut rut din yán wang ló kôluî, myup shi byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Waq zúng bang gi, hpang din wang ló kômù, myuq hkaû mâ é bang eq awui ayàm mâ é bang lé, haú hkyô ló shit kyo kô é yanmai, byù haú bang gi, dut laî lò bê hkyô lé, ê htoq wú akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yhangmoq gi, Yesuq chyáng jé lé kô é hkûn, nat gang myo myo wang júng wú é sû, mebu wut luî, byù gè rayuq su zung to láng é lé myàng kômù, gyuq dan bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Haú hkyô lé myang é bang gi, nat gâng pé wang júng sû eq waq pê chyáng hkâsu dut é hkyô, góbang lé taî kyo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hau htâng, byu pé gi, Yesuq lé yhangmoq é mau mai htoq ló byuq râ matú, chôm dûng tôngbán akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuq lhaî hkaû má wang ló é u lé, haû nat gâng pé wang júng laî lò bê sû gi, Yesuq htâng cháng râ matú, Yesuq lé dung tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nghut kôlhang, Yesuq gi, yhang lé ahkáng a byi e za, \"Nàng, yhûm shut sheq ló mù, haû Yhumsîng, nang lé hkâ-í kut byi bê hkyô eq hkâsu kut shogyo nhikmyin yu é hkyô lé, náng é yhumbyù buinùm ji-myi wuì lé ló taî kyo aq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Haû mù, byù haú yuq gi, ló luî, yhang lé Yesuq hkâ-í kut byi bê hkyô lé, Dekapoli mau bang lé ló taî kyô ri. Haú hkûn, wó gyô é bang banshoq gi, mauhong bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuq gi, lhaî ji mù, nhông he hpoq shut dum dap jé ló mù, Yhang, nhông yàm má nyi tô é u lé, byù ajùm ayò gi, Yhâng é lhînghkyuq má lé zîng bum akô nghut ri; ");
INSERT INTO atbNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","haú hkûn, Ya-iruq gâ é, tarajong má up bang mâ é rayuq gi, haú má lé luî, Yesuq lé myang kat jáng, Yhâng é hkyî wang má paî gop to mù, ");
INSERT INTO atbNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","\"Ngá zo byizo gi, kâng byit ló nyi ri; yhang ge lò mù asak dum duì shi sháng gaq, nàng lé mù, yhâng é ahtoq má loq lé ke byi laq.\" ga, wum kat dûng tôngbán nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Haû mù, Yesuq gi, haú yuq htâng châng e ló ri; byù ajùm ayò le, Yhâng é awui ayàm má châng chyîn chyap wún bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Haú hkûn, raxe í zân suí yui nyi é myiwe myhí rayuq le haú hpúng má bo tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yhang gi, chi sará myo myô pê chyáng yhang wó é ngunzè banshoq lhoq pán mù, nò hkâm luî yâ wú kôlhang, ge é hkyô a joq é htoq agó, je lháng wuîhke lò ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yhang gi, Yesuq é hkyô lé wó gyo jáng, byù hpûng mai Yesuq é nunghtáng má huî lé mù, Yhâng é bu má ê záng kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Haî mù luî gâ le, yhang gi, \"Ngò, Yhang é bu má za lháng ê wó záng é nghut le gi, ge byuq râ nghut lhê.\" ga wó myit é yanmai, haû su kut é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Haú hkûn jáng, yhâng chyáng suí yui é kân byuq luî, yhang gi, hpuzô nyi é mai wó lut bê hkyô lé, yhânggùng má sê gyô kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuq gi, Yhâng é gùng mai hpungwup a-tsam htoq ló é lé, radá dâm châng sê kat luî, byù moq mó shut lhing wú mù, \"Ngá é bu má ó yuq záng bê lhú?\" ga myi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Haú hkûn, Yhâng é chángzô pé gi, \"Náng é lhînghkyuq má byù ajùm ayò chyîn chyap nyi é lé, myang to luî nhîng, 'Ngo lé, ó yuq záng bê lhú?' nghû myi lhê lhú?\" ga tû taî kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nghut kôlhang, Yesuq gi, Yhang lé lé záng sû lé myàng râ matú, ho lhing wú nyi ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Haú hkûn, myiwe myhí haû gi, yhâng chyáng hkâsu dut laî lò bê hkyô lé sê é yanmai, Yesuq é hí má lé mù, gyuq nán é èq Yhang é hkyî wang má ngóm gop to luî, yhâng chyáng dut laî lò bê hkyô banshoq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Haû mù, Yesuq gi, myiwe myhí haû lé, \"Byizo ê, náng é lumjíng myit gi, nàng lé lhoq gê byi bê nghut ri; náng é nòhpyo ge byuq bê nghut ri; ngón za ló aq hkoi!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuq gi, dang ru taî nyi ashî hkûn, tarajong má up sû Ya-iruq é yhûm mai byù ra-am jé lé mù, \"Nang é byizo gi, shi byuq bê; haî mù luî, haû sará lé lhoq hkyik nyi lhê lhú?\" ga luî, lé taî kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesuq gi, haú bang taî é dang lé gyô lhaî pyám mù, \"Hkâgyuq, za lumjíng aq.\" ga, haû tarajong má up sû lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hau htâng, Yhang gi, Petruq, Yakuq eq Yakuq é yhanggu Yohan pé mai lai luî, ó yuq lé le, Yhang htâng a cháng nhâng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yhangmoq, haû tarajong má up sû é yhûm má jé lé kô é hkûn, Yesuq gi, byu pé garu garín ga yón ngau gabyông nyi bum é lé, myàng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yhang gi, yhúmhkaû shut wang ló mù, haú bang lé, \"Haî mù, yón ngau gabyông nyi bum akô lhú? Haû zoshâng gi, shi byuq é a nghut, yhup myhî tô é sheq ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nghut kôlhang, yhangmoq gi, Yhang lé wuìzuì kut pyám byî akô. Yhang kúm gi, haú bang banshoq lé hkat htoq pyám mù, zoshâng é yhângnu yhângwa nhik eq Yhâng é chángzô pé lé za shui luî, zoshâng lé lheq tô é gok má wang e akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuq gi, myiwe zo hau é loq má zuî to mù, \"Talihta ku-mi\" (haû é lichyúm gi, \"Myiwe zo ê, ngò, nang lé taí bá, toq aq.\" gâ é nghut lhê.) ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Myiwe zo haû gi, haú hkûn jáng, toq luî, sô wún ri (yhang gi, asak raxe í zân bò bê sû nghut ri.). Yhangmoq gi, haû sû dut é hkyô lé gyai yhang maú byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yhang gi, haû hkyô ó lé le a sé nhâng râ matú, yhangmoq lé taî hkúm kat luî, myiwe zo haû lé, zô jung byi tso râ matú le, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuq gi, haú jowò mai htoq e ló mù, Yhâng é yhum mau shut taû ló ri; Yhâng é chángzô pé le, Yhang eq rahá bo châng ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bánno buinyì jé jáng, Yhang gi, tarajong má mhoqshit hi ló ri; wó gyô é bang myo myo gi, gyô maú byuq kôluî, \"Byù shí yuq gi, haú pé lé hkâmá mhoq yu é lhà? Yhang wó yu é hpaqchyî byéng-yá gi, hkasû é wá nghut mù luî, laklaí kumlhá lé lháng kut lhê laq? ");
INSERT INTO atbNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Shí yuq gi, Mariq é yhangzo, laksîma hpó nghut lhê, a nghut lhú? Yhang gi, Yakuq, Yose, Yudaq, Simun pê é yhangmang nghut lhê, a nghut lhú? Yhâng nhammó pé le, nga-nhúng eq rahá nghut nyi lhê, a nghut kó lhú?\" ga luî, Yhang lé myit a ngón dut bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesuq, yhangmoq lé taî é gi, \"Myiqhtoi rayuq gi, yhumsing é yhum mau, yhâng é buinùm ji-myi wuì eq yhumsing é yhûm má za, myoqdong a lhaq wó wú é nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yhang gi, nò byù ra-am lé loq ke byi mù, lhoq gê byî é mai lai luî, gotû laklaí kumlhá haî le, haú má a wó kut shit nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Haû mù, Yesuq gi, yhangmoq lumjíng myit a bò kô é hkyô lé, maú nyi ri. Hau htâng, Yhang gi, Nazaret wà mai htoq ló mù, rawà htâng rawà má châng mhoqshit wún ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuq gi, haû lagyo raxe í yuq lé wut yù mù, agè ashop é nat pé lé ûng râ a-tsam byi luî, í yuq yuq kut nhang htoq kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yhang, yhangmoq lé châng pying kat é dang gi, \"Hkyowui é matú má, dumbáng mai lai luî, zoshuq le, etap le, ngùn le, gotû haî le, hkâyu chûng kó; ");
INSERT INTO atbNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","hkyî-tsung kúm gi, tsûng chûng keq; nghut kôlhang, bu í dung hkâwut chûng kó. ");
INSERT INTO atbNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hká má nghut kôlhang, rayhûm yhûm má nungmoq wang bíng kô é nghut le gi, haú wâ mai dum htoq ló é buinyì jé shoq, haú yhûm má za nyi nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jowò rawò wò mâ é bang, nungmoq lé a lhom hap yù, a lhom gyo byi kô é nghut jáng, nungmoq lé yhangmoq a lhom hap yu é saksé dut sháng gaq, nungmoq é hkyiwa má dap é hpuilhau lé ko hkyô pyâm to mù, haú jowò mai htoq ló keq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Haû mù, yhangmoq gi, htoq e ló luî, myit lhîng râ é hkyô, byu pé lé hkô kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hau htoq agó, yhangmoq gi, nat gâng pé myo myo lé hkat htoq pyám byi mù, no é bang myo myo lé le xû but byi luî, lhoq ge byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuq é myìng hû lo é yanmai, Herut hkohkâm gi, Yesuq é hkyô lé wó gyo bê nghut ri. Byù ra-am gi, \"Shí yuq gi, haû shi byuq bê Wui-myhup Sará Yohan dum dui toq lo é nghut lhê abe, hau é yanmai, yhang gi, hpungwup a-tsam haú pé lé wó kut é nghut ri.\" ga luî, taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ra-am gi, \"Yhang gi, Eliyaq nghut ri.\" ga taî akô nghut ri. Dum, ra-am taí kô é gi, \"Yhang gi, hí hpyang lhê é myiqhtoî pé su, myiqhtoi rayuq nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herut kúm gi, haú lé wó gyo jáng, \"Ngò, ulhum hpyit pyám byî é Yohan gi, shi é mai dum dui toq bu-nhung!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herut gi, yhanggu Hpilip é yhangmyi Herudiaq lé hâng yu pyâm é hkyô é yanmai, Yohan lé chyup tuî yù nhâng mù, htóng hkyô pyám nhang wú é sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hkâsu mù gâ le, Yohan gi, Herut lé, \"Nàng, nunggu é yhangmyi lé hâng yu é gi, tarâ a wang é nghut lhê.\" ga luî, taí byî nyi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Haû mù, Herudiaq gi, Yohan lé gyai a jú dut byuq luî, sat pyám naû kôlhang, a wó sat dut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Haî mù gâ le, Herut gi, Yohan, dingmán chyoiyúng é sû nghut é lé sé mù luî, yhang lé gyuq hkungga mù, yhang lé búng nyi é yanmai nghut ri. Yhang gi, Yohan é dang pé lé wó gyo jáng, gyô nhúng nhâng byuq kôlhang, yhang taî é dang pé lé ru gyô nau nyi ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nghut kôlhang, Herut gi, yhâng é hkû ladu hkyúm buinyì má, byù mó pé, gyezau pé, Galile mau suwún wui pé lé, ji yù mù zoshuq poî mó kut é yanmai, haú nyí gi, Herudiaq é matú, buinyì gè dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herudiaq é yhangzo byizo gi, wang lé lô mù, gó shit é hkûn, Herut eq yhâng é bíng pé gi, myit ngón bum akô nghut ri. Haû mù, hkohkâm gi, myiwe zo haû lé, \"Nàng ô nau é haî nghut kôle, dung aq, ngò nàng lé byi râ nghut lhê.\" ga, dakam é danggidiq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hau htoq agó, yhang gi, myiwe zo haû lé, \"Nàng dung é haî nghut kôle, ngò byi râ; ngá é mingdán rawuí gû lháng, byi râ nghut lhê.\" ga, dakam é danggidiq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Haú hkûn, myiwe zo haû gi, htoq ló mù, yhâng nu lé, \"Haî dûng le gè râ laq?\" ga myi jáng, yhângnu gi, \"Wui-myhup Sará Yohan é ulhum dung aq.\" ga tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Myiwe zo haû gi, radá dâm hân hân wang ló mù, hkohkâm lé, \"Ahkuî yhang, Wui-myhup Sará Yohan é ulhum lé, bó má kat mù byi laq.\" ga, dûng tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Haû su ga jáng, hkohkâm gi, myit gyai yhang a ngón dut byuq kôlhang, yhang dakam tô é danggidiq é yanmai le, bíng pê é myoqdong lé tê nau é yanmai le, myiwe zo haû taî é dang lé a kâm he pyám lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Haû mù, hkohkâm gi, zúng é gyezo rayuq lé, Yohan é ulhum ê hpyit lô râ matú, radá dâm hkunmó hkyó mù nhang kat ri. Haû mù, haú yuq gi, htóng hkaû má ê luî, Yohan é ulhum lé, ê hpyit mù, ");
INSERT INTO atbNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","bó má kat luî, myiwe zo haú lé lo byî ri; myiwe zo haû gi, ulhum haû lé, yhângnû chyáng yu ló byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohan é chángzô pé gi, haú hkyô lé wó gyo kôjáng, yhâng é màng lé lé yû luî, lup má ló myhup pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lagyo pé gi, Yesuq chyáng dum jé zîng lò kômù, yhangmoq kut laî lo é hkyô pé eq mhoqshit bê hkyô pé banshoq, Yhang lé taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hau htâng, byù myo myo gi, yhangmoq chyáng htoq htoq wàng wàng kut nyî kô é yanmai, yhangmoq gi, zang zo ahkyíng lháng a wó kó nghut ri. Haû mù, Yesuq gi, chángzô pé lé, \"Nga-nhúng, tsím tsâm é jowò ralhum má ê mù, ê nô yù sháng.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Haû mù, yhangmoq gi, yhangmoq baú lhaî racham má ji mù, tsím tsâm é jowò shut e ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nghut kôlhang, yhangmoq e ló é lé châng myang é bang myo myo gi, yhangmoq lé wú sé kôluî, wà hkangmó mai hkyî hkyô châng din ê kômù, yhangmoq é hí má jé to láng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuq gi, lhaî mai gyó dap ló é hkûn, byù moq mó nyi to láng lé myàng jáng, yhangmoq gi, zúng sû a nyi é sau pé su dut kô é yanmai, yhangmoq lé wú shogyo luî, myo myo mhoqshit byî hi ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Buì gyum ló yâm jé jáng, Yhang é chángzô pé gi, lé lô kômù, Yhang lé, \"Shí má gi, tsím tsâm é jowò nghut é htoq agó, buì le gyum ló bê; ");
INSERT INTO atbNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","yhangmoq gi, awui ayàm mâ é yhûm pé eq wà pé má, zoshuq ló ho wuì zo kó sháng gaq, yhangmoq lé ló nhâng aq hkoi.\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Haú hkûn, Yhang gi, \"Nungmoq, yhangmoq lé rajung jung byi tso keq.\" ga tû taí jáng, yhangmoq gi, \"Shî myhô é bang zo râ matú, ngamoq gi, ê luî, denari í sho èq muk ê wuî byi ra râ luq?\" ga dum taû myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nghut kôlhang, Yhang gi, \"Nungmoq chyáng muk hkâ-myhó wó akô? Ê wú wú keq.\" ga myî ri. Haû mù, yhangmoq gi, myang hô jáng, \"Muk ngo long eq ngozo í du wó lhê.\" ga, dum tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hau htâng, Yesuq gi, banshoq bang lé ahpúng hpúng kut wàhu yò má zùng nhâng râ matú, Yhâng é chángzô pé lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Haû mù, shiwa byu pé gi, rashô shô kut le, ngo xê xê kut le, ahpúng hpúng zung tô bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesuq gi, haû muk ngo long eq ngozo í du lé yù mù, mauhkûng shut tu wú to luî, jeju ban hkya-on jáng, muk lé hpê gam ri. Hau htâng, Yhang gi, byu pê hí má châng hkat to byi râ matú, Yhâng é chángzô pé lé byî ri. Ngozo í du lé le, Yhang yù mù, banshoq bang lé gàm byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yhangmoq banshoq bang gi, zô gyî bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hau htâng, haû chángzô pé gi, zô myhit tô é muk eq ngozo lé, raxe í mung byíng shoq wó guq tsîng yu ashî kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Haú hkûn, zô é bang gi, yuqgè wuì baú lháng, byù du ngo hkyîng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesuq gi, haû shiwa byu pé lé byo ló nhang nyi é hkûn jáng, Yhâng é chángzô pé lé lhaî má wang ji nhâng mù, tû tap mâ é Bet-saida wà mó shut dap ló láng nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yhangmoq lé shi-kyâm kat é htâng, Yhang gi, kyûdung râ ga, Yhang baú bùm shut doq e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Buigyum htâng, lhaî gi, nhông gùng má jé tô é u lé, Yesuq gi, Yhang baú za myì htoq má nyi tô ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Laì tau mut é yanmai, haû chángzô pé gi, lhaî lhu wuîhkê nyì kô é lé, Yesuq myang ri. Napsûn maubó zó sum hkyíng eq hkyuq hkyíng gyoro má, Yesuq gi, nhông htoq má so mù, yhangmoq shut e ló luî, yhangmoq é nàm mai laî ló râ dâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nghut kôlhang, yhangmoq gi, Yhang, nhông htoq má sô nyi é lé myang kôjáng, sobyô su ngàm kômù, kyek garû bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hkâsu mù gâ le, yhangmoq banshoq bang gi, Yhang lé myàng kôluî, gyuq dàn kô é yanmai nghut ri. Nghut kôlhang, Yhang, radá dâm yhangmoq lé dáng nyo kat é gi, \"Hkâgyuq kó. Ngò ru nghut lhê; zim za nyì keq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hau htâng, Yhang gi, lhaî htoq má yhangmoq eq rahá ê doq ji jáng, laì gi, zîm byuq bê nghut ri; haû mù, yhangmoq gi, gyai yhang mauhong byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hkâsu mù gâ lé, yhangmoq gi, muk gam é laklaí kumlhá eq séng luî a sê gyo kô é htoq agó, myitbun a bóng kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yhangmoq gi, gû dap ló kômù, Genesarat mau má jé wang lò jáng, lhaî lé haú má ló shap tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yhangmoq lhaî mai gyó é hkûn jáng, byu pé gi, Yesuq lé lhom wú sê akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Haû mù, yhangmoq gi, haú mau ramau gón má din jón mù, nò bang lé taphkang mai waq luî, Yesuq nyi rí gâ é jowò hkangmó má, shuî lé lo bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesuq jé é wà hkangmó, myuq hkangmó, awui ayàm mâ é wà hkangmó pé má, yhangmoq gi, nò byù lé gaì pé má lé lheq to kôluî, Yhâng é bushi htâng má za lháng, haú bang lé byi záng nhâng râ matú, Yhang lé dûng tôngbán akô. Yhang lé záng é lhunglhâng bang gi, lhoq gê byî é huî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Haû Hparishe pé eq tarâ sará pé ra-am gi, Yerusalem wà mó mai jé lé lô kômù, Yesuq é nàm má lé zup zîng bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Haú hkûn, Yhâng é chángzô pé ra-am gi, htûngli dông a chî pyâm é, a sansêng é loq èq zo shuq nyî kô é lé, yhangmoq myang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Hparishe pé eq Yudaq byù banshoq bang gi, yhangmoq é îchyí îwâ pê é htûngli lé châng é bang nghut lhê mù luî, loq hí a chî é gi, haî le a zô wú kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yhangmoq gi, gaì pé mai taû lò jáng le, gùng hí a chî pyâm é, zojung a zo kó nghut é htoq agó, góm pé, hkoq pé, gyi chôkon pé lé chî é htûngli gotû pé lé le, châng akô nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Haû mù, Hparishe pé eq tarâ sará pé gi, Yesuq lé, \"Náng é chángzô pé gi, haî mù luî, îchyí îwa pê é htûngli lé a châng e za, a sansêng é loq èq zo shuq nyi akô lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Haú hkûn, Yesuq gi, yhangmoq lé, \"Gegùn labyoq kut bang ê, nungmoq eq séng luî myiqhtoi Esai-aq htoî tô é dang má, 'Byù shí bang gi, nhut htoq mai za Ngo lé hkunggâ akô; yhangmoq é myit nhiklhum gi, Ngò eq wê gâng nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yhangmoq gi, akôm má za, Ngo lé noqkuq nyi akô; hkâsu mù gâ le, yhangmoq é mhoqshit hkyô pé gi, byù dông mai mhoqshit é hkyô pé za nghut nyi ri.' ga kâ tô é gi, têng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nungmoq gi, Garai Gasang tô tô é hkunmó lé tô pyám luî, byu é htûngli lé za, myhik zing tô akô nghut ri.\" ga luî tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hau htâng, Yhang xoq taî é gi, \"Nungmoq gi, yhumsing é htûngli lé za cháng râ matú, Garai Gasâng é hkunmó lé he-ngik pyâm é má, hpaqchyî gyaí bo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hkâsu mù gâ le, Mosheq gi, 'Nungmoq é înu îwa lé, hkungga keq.' ga le, 'Înu îwa lé, nhîng é sû ó yuq nghut kôle, sat pyâm é hui râ lhê.' ga le, kâ tô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nghut kôlhang, nungmoq taî é gi, byù rayuq yuq, yhumsing é yhângnu yhângwa lé byi âng é zè lé, Korban za (Garai Gasang lé byi râ chyunghuq) nghut lhê gá nhang akô. ");
INSERT INTO atbNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Haû mù, haú yuq lé, yhângnu yhângwâ é matú, haî a kut byi nhâng lô é dông dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Haú dông mai, nungmoq gi, nungmoq chung gyó lo é htûngli é yanmai, Garai Gasâng é mungdang lé he-ngik pyâm akô; haû sû é hkyô myo myo lé le, nungmoq kut akô nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuq gi, shiwa byu pé lé Yhâng chyáng dum wut yù mù, taî é gi, \"Nungmoq banshoq bang, ngò taî é lé gyô yù mù, sé lo keq; ");
INSERT INTO atbNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Shinggan mai wang lo é haí jung le, byù lé a sanséng dut nhang é a nghut, nghut kôlhang, byu é unghkaû mai htoq ló é zè kúm gi, byù lé a sanséng dut nhang lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Gyo râ nohkyap dap é sû gi, gyô yù sháng gaq.)\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yhang gi, byù moq mó mai htoq ló mù, yhúmhkaû má jé wang ló é hkûn, Yhâng é chángzô pé gi, dangtú haû eq séng luî, Yhang lé lhom myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Haû mù, Yhang gi, yhangmoq lé, \"Nungmoq gi, haû-í yhang go akô luq? Shinggan mai wang lo é haí jung le, byù lé a sanséng nhâng wó dut râ a nghut é hkyô lé, a sé kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hkâsu mù gâ lé, haû gi, byu é myit nhiklhum hkaû má wang ló é a nghut e za, wamdau hkaû má sheq wang ló é nghut mù, shinggan shut dum lhoq htoq pyâm é nghut lhê.\" ga taî ri. (Yhang isu ga taî é gi, zoshuq lhunglháng sansêng lhê gá nau é dông nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hau htoq agó, Yhang xoq taî é gi, \"Byù mai htoq ló é haí jung le, byù lé a sanséng nhâng wó dut é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Hkâsu mù gâ lé, ahkaû mai htoq lo é gi, byu pê é myit mai htoq ló é nghut mù, agè ashop é dông myit é hkyô pé, ashop é dông gungsho zùm yap é hkyô, hkaû é hkyô, byù sat é hkyô, su-myi sulàng lú hkyô, ");
INSERT INTO atbNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","myoqnoq é hkyô, agè ashop é hkyô, mhaú zô é hkyô, achaq achyut zùm yap lhûm é hkyô, manon é hkyô, lumù gansang é hkyô, gumrong é hkyô eq ngha é hkyô pé htoq lò é nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Agè ashop é hkyô shí pé banshoq gi, byu é unghkaû mai htoq lo é nghut mù, byù lé a sanséng dut nhang ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuq gi, haú jowò mai htoq ló mù, Turuq eq Sidun maukyo shut e ló luî, yhûm ralhum má wang ê ri; Yhang nyi é hkyô lé, ó yuq lé lé a sé nhâng naù kôlhang, a wó zaú to nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Haû mù, agè ashop é nat wang júng tô é myiwe zo rayuq é yhângnu gi, Yhang nyi tô é hkyô lé wó gyô é hkûn jáng, Yhâng chyáng jé lé mù, Yhâng é hkyî wang má lé paî gop to luî, ");
INSERT INTO atbNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","yhang zô chyáng mai nat gang lé hkat htoq pyám byi râ matú, Yhang lé dûng tôngbán ri. Myiwe haû gi, Suru-Hpiniki mau mâ é Grik byuhú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesuq gi, \"Zo wuî hí zô gyi kó sháng gaq; haî mù gâ le, zô wui chyáng mâ é zoshuq lé yù mù, hkuî pé lé byi tsô é jung a nghut.\" ga yhang lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Haú hkûn, yhang gi, \"Yhumsîng ê! Haû kúm nghut ri; nghut kôlhang, siboî ô mâ é hkui lháng, zô wui é zô myhit shuq htâng lé, ge zo lhê a nghut lhú?\" ga dum tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Haû mù, Yesuq gi, yhang lé, \"Nàng tû taî é dang hau é yanmai, ló lo aq hkoi; haû nat gang gi, nung zô chyáng mai htoq ló byuq bê nghut ri.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Myiwe myhí haû gi, yhûm má dum taû jé lo é hkûn, yhang zo chong htoq má leq to láng é lé le, nat gang htoq byuq bê nghut é lé le, lo myang ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuq gi, Turuq mau mai dum htoq ló mù, Sidun mai sô laî ló luî, Dekapoli mau hkaû dông laî byit mù, Galile nhông shut gyó jé ló ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Haú hkûn, byù ra-am gi, nojit é eq dang a hkyang é byù rayuq lé, Yhâng chyáng shuî lé lô kômù, haú yuq é ahtoq má loq ke byi râ matú, Yhang lé dûng tôngbán akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuq gi, haú yuq lé baú za byù hpúng mai shuî htoq yû mù, yhâng é nohkyûng má loqnyhui htaû háng byi luî, sôkan byé tik yû mù, haú yuq é shô má htau byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hau htâng, Yhang gi, mauhkûng shut tu wú mù, soq mó shê luî, \"Ehpahta!\" (Lichyúm gi, \"Bóng aq hkoi!\") ga luî, haú yuq lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Haú hkûn, haú yuq é nohkyap le bóng byuq luî, shô le nyhôm byuq mù, balang hkyâng hkyâng dang wó nyô bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuq gi, haú hkyô ó lé le a taî kyo râ matú, yhangmoq lé hkúm kôlhang, yhangmoq gi, je hkúm le, je taî pyo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Byu pé gi, gyai yhang mauhong byuq bùm kôluî, \"Yhang gi, haî lé le, ge é dông chyat kut ri; nojit sû lé, wó gyo shoq, dang a hkyâng sû lé, wó nyô shoq, kut byi bê nghut ri.\" ga luî, taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Haú yoq má, gotû byù moq mó gi, lé zîng bum akô; haú bang zoshuq langhpyut to kô é yanmai, Yesuq gi, Yhâng é chángzô pé lé wut yù mù, ");
INSERT INTO atbNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"Ngò, shí bang lé wú shogyo ri; yhangmoq gi, Ngò eq rahá nghut nyi é sum nyí bò bê, haî le a myàng zo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yhangmoq chyáng mâ é ra-am gi, mau we mai lé é bang nghut é yanmai, yhangmoq lé, zòmut gû yhûm shut nhang kat é nghut le gi, hkyolat má mutyut yut é ló hui kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Haú hkûn, Yhâng é chángzô pé gi, Yhang lé, \"Îsu é yoso má nhîng, shî myhô bang lé luq shoq byi tso râ zoshuq gi, hkâmá ê yû râ lhú?\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuq gi, \"Nungmoq, muk hkâ-myhó long wó akô lhú?\" ga taû myi jáng, yhangmoq gi, \"Nyhit long.\" ga, dum tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Haû mù, Yhang gi, byù hpûng lé myigùng htoq má zùng nhang to luî, muk haû nyhit long lé yù mù, jeju ban hkya-on jáng, myhik hpé luî, haú bang lé gàm byi râ matú, Yhâng é chángzô pé lé byî kat ri; haû mù, yhangmoq gi, haú bang lé gàm byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yhangmoq gi, ngo-nú zo ratsuí le wó akô nghut ri; haû mù, Yhang gi, ngozo haú pê é matú jeju hkya-on luî, chángzô pé lé dum gàm byí nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yuq hkangmó zô gyî bùm kô é htâng má, haû chángzô pé gi, amyit ahtâng lé nyhit mung byíng shoq wó guq tsîng yu ashî kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Zô é bang gi, byù myi hkyîng kô nghut ri; Yesuq gi, haú bang lé, nhang kat luî, ");
INSERT INTO atbNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yhâng é chángzô pé eq rahá, lhaî má wang ji mù, Dalamanuhta mau má ê jé akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hparishe pé gi, lé mù, Yesuq eq dang htíng htîng lhûm akô; hau htoq agó, yhangmoq gi, mauhkûng mâ é kumlhá lé dûng é dông, Yhang lé chyam wú akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuq gi, myit nò-kying kying luî, yhangmoq lé taî é gi, \"Haî mù luî, shí ipyat lhê é byu pé gi, limik kumlhá dûng akô lhú? Ngò teng za taí kôlé, shí ipyat mâ é bang lé, hai kumlhá le tûn shit râ a nghut.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hau htâng, Yhang gi, yhangmoq lé pyâm to mù, lhaî má dum taû wang ló luî, tû tap shut gû dap e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Haû chángzô pé gi, muk yu chûng râ lé tô-myhî pyám kôluî, lhaî hkaû má muk ralong za ru wó akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuq gi, yhangmoq lé, \"Nungmoq gi, Hparishe pé eq Herut é múnchi lé, sidiq luî, koi pyâm nyì keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Haú hkûn, yhangmoq gi, \"Nga-nhûng chyáng muk a bo é yanmai, haû su ga taî é nghut ri.\" ga luî, rayuq eq rayuq taî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Haû su ga taî lhûm nyì kô é lé Yesuq sé jáng, yhangmoq lé, \"Nungmoq gi, muk a bo é hkyô lé, haî mù taî lhûm nyi akô lhú? Ahkuî jé shoq, nungmoq gi, a byu-myàng, a sê gyo shi kó lhú? Nungmoq é myit nhiklhum gi, ru htan nyi ashî kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Myoq dap to kôluî nhîng, a myàng kó lhú? Nohkyap dap to kôluî nhîng, a wó gyo kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngò, muk ngo long lé myhik hpé mù, byù ngo hkyîng lé byi tsô é hkûn, zô myhit shuq htâng lé, nungmoq hkâ-myhó mung wó guq tsîng yu é lé, bun ashî kó lhú?\" ga myi jáng, yhangmoq gi, \"Raxe í mung.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dum, Yesuq gi, \"Ngò, muk nyhit long lé myhik hpé mù, byù myi hkyîng lé byi tsô é hkûn, zô myhit tô é ajap azo lé, nungmoq hkâ-myhó mung wó guq tsîng yù kô é lhú?\" ga myi jáng, yhangmoq gi, \"Nyhit mung.\" ga dum tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Haú hkûn, Yesuq gi, \"Haû nghut le nhîng, ahkuî le, a sê gyo shi kó lhú?\" ga, yhangmoq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yhangmoq gi, Bet-saida wà mó má jé lò kô é hkûn, byù ra-am gi, myoqjit é byù rayuq lé, Yesuq chyáng shuî lé lô mù, haú yuq lé záng byi râ matú, dûng tôngbán akô. ");
INSERT INTO atbNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuq gi, myoqjit sû haú yuq é loq lé zui mù, wà shinggan shut shuî htoq ló luî, yhâng é myoq má sôkan byé tik byi mù, loq ke byi luî, \"Nàng, rajung jung lé myang ri lhú?\" ga myî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Haû jáng, yhang gi, tu wú kat luî, \"Byu pé gi, sikgâm su dut luî, hkyô sô wún é lé, ngò myang ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hau htâng, Yesuq gi, haú yuq é myoq má Yhâng é loq dum ke byî ri; haú hkûn, haú yuq é myoq gi, bóng lô mù, ge byuq luî, haî lé le san za myàng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuq gi, haú yuq lé, \"Wà hkaû má hkâwang ló lo.\" ga taí luî, yhâng é yhûm shut ló nhang kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuq eq Yhâng é chángzô pé gi, Kesare-Hpilipi wà mó awui ayàm mâ é wà pé shut e ló é hkûn, hkyô má, Yesuq gi, chángzô pé lé, \"Byu pé gi, ngo lé ó yuq nghut lhê ga, taî akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Haú hkûn, yhangmoq gi, \"Ra-am gi, Wui-myhup Sará Yohan ga, góbang gi, Eliyaq ga, dum ra-am gi, myiqhtoi rayuq yuq nghut ri ga taî akô.\" ga, Yhang lé tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesuq gi, \"Nungmoq gi, ngo lé ó yuq nghut lhê nghu akô lhú?\" ga, yhangmoq lé xoq myi jáng, Petruq gi, \"Nàng gi, Hkrisduq nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuq gi, haú hkyô ó lé le a taî kyo râ matú, yhangmoq lé taî hkúm ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hau htâng, Yhang gi, yhangmoq lé mhoqshit é má, \"Haû Byu Yhangzo gi, zing-rî é myo myo hui zo luî, suwún wuî, hkyangjong agyi pé, tarâ sará pê èq he-ngik pyâm é hui mù, sat pyâm é hui ra râ nghut lhê; nghut kôlhang, sum nyí nghû râ buinyì má, dum dui toq râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesuq gi, haú hkyô lé san za dut shoq taî nyi é yanmai, Petruq gi, Yhang lé rahkyam shut shuî htoq yû mù, Yhang lé tân ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nghut kôlhang, Yesuq gi, Yhâng é chángzô pé lé lhing wú kat mù, Petruq lé, \"Tsadán nàng, Ngá chyáng mai hpâng aq! Nàng gi, Garai Gasang eq sêng é hkyô lé a myit e za, byù eq sêng é hkyô lé za myit é sû nghut ri.\" ga tân kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hau htâng, Yhang gi, byù moq mó eq Yhâng é chángzô pé lé wut yù mù, taî é gi, \"Ngá htâng cháng naû sû ó yuq nghut kôle, yhumsing gùng yhumsîng he-ngik pyám mù, yhumsing é tapzîng lé waq chûng luî, cháng ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Hkâsu mù gâ le, yhumsing é asak lé hkyi yù naù sû ó yuq nghut kôle, asak sum râ nghut lhê; nghut kôlhang, Ngá é yanmai le, haû gabú danglù é yanmai le, yhumsing é asak sûm pyâm é sû kúm gi, asak hkyi yu é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Byù gi, mingkan gón lé wó sing to kôlhang, yhumsing é asak woi-nyí sûm byuq é nghut le gi, yhâng é matú, hai akyû bò râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Byù gi, yhumsing é asak woi-nyí lé, hai èq wó htaî yù râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yubak mara myô é eq su-myi sulàng shut é ipyat shî má, Ngò eq Ngá é dang lé hoq pyâm é sû ó yuq lé le, haû Byu Yhangzo gi, Yhâng Wâ é hpungwup shingkang bo é èq, haû chyoiyúng maumang lagyô pé eq rahá jé lé é hkûn, hoq pyám râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hau htâng, Yesuq gi, yhangmoq lé, \"Ngò, nungmoq lé teng za taí kôlé, shí má yap tô é bang ra-am gi, Garai Gasâng é mingdán, hpungwup a-tsâm èq jé lé lo é lé, a myang é za shî kó râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hkyuq nyí laî htâng má, Yesuq gi, Petruq lé le, Yakuq eq Yohan lé le, shuî chûng mù, yhangmoq baú myhang é bùm ralhum má doq ló akô; haú hkûn, yhangmoq é myoq hí tê má, Yesuq é ihpyô isâm htaî lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hau htoq agó, Yhâng é mebu gi, wik wik duq hpyu zan lo ri; myidàm htoq má, ó yuq le haû-í hpyû shoq a wó xaû hpyu wú é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliyaq eq Mosheq gi, yhangmoq é hí má htoq shit mù, Yesuq eq dáng nyo lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Haû mù, Petruq gi, Yesuq lé, \"Rabai ê, shí jowò má nga-nhúng nyi le ge ri; haû mù, Náng é matú ralhum, Mosheq é matú ralhum, Eliyaq é matú ralhum kut, ngamoq lé, zúm sûm lhum saí nhâng laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hkâsu mù gâ le, yhangmoq gi, gyai yhang gyuq dan bùm kô é yanmai, Petruq gi, haî taí râ le a sé mù, haû su gâ é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hau htâng, mhut htoq lô luî, yhangmoq lé htup zíng lô mù, mhut hkaû mai htoq lo é htê gi, \"Shí yuq gi, Ngò chyitdap é Ngá Zo nghut lhê; Yhâng é dang gyo keq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Haú hkûn jáng, chángzô pé gi, lhînghkyuq má wú kat le, Yesuq za yhangmoq eq rahá nghut nyi é mai lai luî, ó lé le, a myàng lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yhangmoq, bùm mai taû gyó lô kô é hkûn, Yesuq gi, haû Byu Yhangzo shi é mai a dum dui toq toq gi, yhangmoq myang é hkyô lé, ó lé le a taî kyo râ matú taî hkûm tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chángzô pé gi, dang haú lé myit má kat to kôluî, \"Shi é mai dum dui toq râ.\" gâ é lichyúm lé, rayuq eq rayuq myî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hau htâng, yhangmoq gi, \"Eliyaq hí lé ra râ nghut lhê ga, tarâ sará pé haî mù taí kô é lhú?\" ga, Yesuq lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Haú hkûn, Yesuq gi, \"Eliyaq hí jé lé é gi, teng bê nghut luî, lhunglháng lé dum lajâng tô é nghut ri. Nghut kôlhang, haû Byu Yhangzo gi, myo myo hpuzo luî, he-ngik pyâm é hui ra nghut lhê ga le, Chyúmdang má kâ to ashî, a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngò, nungmoq lé taí kôlé, Eliyaq gi, jé lé bê nghut mù, yhang eq séng luî Chyúmdang má kâ tô é eq rajung za, yhangmoq gi, ô nau é dông banshoq kut bekô nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yhangmoq gi, chángzô pê chyáng dum taû jé lô kô é hkûn, haú bâng é lhînghkyuq má byù moq mó zîng lé é lé le, tarâ sará pé, haú bang eq dang htíng htîng lhûm nyì kô é lé le, myang akô. ");
INSERT INTO atbNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Haú má nyi tô é lhunglhâng bang gi, Yesuq lé myang kat é eq, maú byuq kôluî, din ê mù, ê shi-kyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Haú hkûn, Yesuq gi, yhangmoq lé, \"Nungmoq gi, yhangmoq eq haî lé dang htíng htîng lhûm nyi akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Byù hpúng hkaû mâ é rayuq tû taî kat é gi, \"Sará ê! Nhut jit nhang é nat wang júng tô é ngâ é yuqzo lé, Náng chyáng shuî lé lo lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nat haû gi, yhâng chyáng wàng hkangmó, yhang lé myì htoq má lhoq leqbat nhang ri; haû mù, yhang gi, nhut mai guttsû htoq lhê, zuì kyik kyik lhê, langhtan lo lhê, dut ri; hau é yanmai, nat haú lé hkat htoq pyám byi râ matú, Náng é chángzô pé lé dûng wú kôlhang, yhangmoq a wó dut kó nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Haú hkûn, Yesuq gi, \"Lumjíng myit a bo é amyû pé ê, Ngò gi, hkâ-myháng jé shoq nungmoq eq rahá nyì mù, wó jân nyì râ lhú? Yuqgè zo haû lé, Ngá chyáng shuî lé lô keq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Haû mù, yhangmoq gi, yuqgè zo haû lé shuî lé lo akô; nat haû gi, Yesuq lé myang kat é eq yhang, yuqgè zo haû lé langhtân nhang ri; yuqgè zo haû gi, myigùng má lêng leq luî goleng leng mù, nhut mai tsû-myup htoq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Haú hkûn, Yesuq gi, yhângwa lé, \"Yhang, isu dut é hkâ-myháng myáng bê lhú?\" ga myi jáng, yhâng wa gi, \"Zoshâng hkûn mai nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nat haû gi, yhang lé lhoq sat pyám naû mù, myi má le, wuì má le, anum num lêng wàng nhang wú bê nghut lhê; nghut kôlhang, Nàng, rajung jung wó kut byî é nghut le gi, ngá hpe lé shogyo yù laq, garúm yû laq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuq gi, \"'Nàng, wó kut byî é nghut le gi,' nghû, haî mù taî lhê lhú? Lumjíng myit bò su é matú gi, haî le wó dut lhê.\" ga, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Haû zôshang é yhângwa gi, radá dâm, \"Ngò lumjíng lhê; nghut kôlhang, ngá é lumjíng myit gi, shaû ashî nghut é yanmai garúm yû laq.\" ga taî garû ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuq gi, byù hpúng din zîng lé lô kô é lé, myàng jáng, haû agè ashop é nat lé, \"Nojit, nhutjit nhang é nat ê! Ngò, nang lé hkunmó hkyô lhê, yhâng chyáng mai htoq ló aq; hkâ-nhám le, yhâng chyáng hkâdum wàng lo.\" ga tân kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Haú hkûn, nat haû gi, garu mù, zoshâng haû lé wum kat langhtân nhâng luî, htoq ló byuq bê. Zoshâng haû gi, shî màng gùng su dut byuq é yanmai, byù myo myo gi, \"Yhang shî bê nghut ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nghut kôlhang, Yesuq gi, zôshang é loq má zui luî, tu toq kat ri; haû mù, zoshâng gi, yap to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuq, yhúmhkaû má wang ló é htâng, Yhâng é chángzô pé gi, \"Ngamoq gi, haî mù, nat haû lé a wó hkat htoq é lhú?\" ga, tsik za Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesuq gi, \"Haú jung nat lé gi, kyûdûng é dông za a nghut jáng, wó hkat htoq râ a nghut.\" ga, yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yhangmoq gi, haú jowò mai htoq ló mù, Galile mau mai laî ló akô; nghut kôlhang, Yesuq gi, ó lé le a sé nhâng naù nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Haî mù gâ le, Yhang gi, \"Haû Byu Yhangzo gi, byu pê é loq má ap pyâm é hui râ nghut lhê; haú bang gi, Yhang lé sat pyám kó râ nghut lhê; nghut kôlhang, Yhang gi, shi é htâng sum nyí nghû râ nyí má, dum dui toq râ nghut lhê.\" ga, Yhâng é chángzô pé lé mhoqshit byî nyi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yhâng é chángzô pé gi, dang haú lé a sê gyo kôlhang, Yhâng chyáng a wám myi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yhangmoq gi, Kaperna-um wà má jé e akô nghut ri. Yesuq gi, yhúmhkaû má nyi tô é hkûn, chángzô pé lé, \"Hkyô má, nungmoq, hai hkyô lé dang chyin chyîn lhum kô é lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nghut kôlhang, yhangmoq gi, zim za nyi tô akô; hkâsu mù gâ le, ko dik sû gi, ó yuq nghut lhê nghû é hkyô lé, hkyolat má, yhangmoq dang chyin chyîn lhum kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesuq gi, zùng mù, haû chángzo raxe í yuq lé, wut yù luî, \"Kô dik naû sû ó yuq nghut kôle, tiq dik sû eq banshoq bâng é dui-nhâng zoshâng dut ra râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hau htâng, Yhang gi, zoshâng rayuq lé shuî yù mù, yhangmoq é gung gûng má shap to luî, dum bún yù mù, yhangmoq lé taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"Shî sû é zoshâng lé, Ngá é myìng mai hap yu é sû ó yuq nghut kôle, Ngo lé hap yu é sû nghut bê; Ngo lé hap yu é sû ó yuq nghut kôle, Ngo lé za hap yu é a nghut, Ngo lé nhang kat é Sû lé hap yu é le nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Haú hkûn, Yohan gi, \"Sará ê! Náng é myìng lang luî, nat gâng pé lé hkat pyám byî wún é byù rayuq lé, ngamoq myang ri. Yhang gi, nga-nhûng chyáng a lòm sû nghut é yanmai, yhang lé ngamoq hkûm pyâm é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesuq kúm gi, \"Yhang lé hkâhkúm kó; Ngá myîng lé lang luî, laklaí kumlhá kut é sû gi, razup za má, Ngò eq séng luî, a ge é hkyô pé lé taí râ a nghut; ");
INSERT INTO atbNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hkâsu mù gâ le, nga-nhúng lé gyè a kut é sû gi, nga-nhûng é hkyam shut nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngò, nungmoq lé teng za taí kôlé, nungmoq gi, Hkrisduq eq sêng é bang nghut lhê gâ é yanmai, ngá é myìng lé lang luî, nungmoq lé, uchyam ragóm byi huq é sû ó yuq nghut kôle, zuihpau lé hkyak myang hkam yù râ za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ngo lé lumjíng é zoshâng wuì mâ é rayuq lé, mara kut shut nhang é sû gi, yhâng é lingzing má luqluí long mó tuî hut byi luî, wuimau má ê dú hkyó pyâm é huî é nghut lé gi, yhang é matú je gè râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Náng é loq èq, nang lé mara kut shut nhang é nghut le gi, haú lé hpyit dú pyám aq; loq í loq dap luî, hkâ-nhám le, myiduq a dat shum é ngaraî ming wàng râ htoq má, loq raloq eq za ahtum abyuq é asak wó râ shut wàng le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Haû ngaraî ming gi, 'yhangmoq lé hkê nyi é luq le a shî, myiduq le a shûm' é jowò nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Náng é hkyi èq, nang lé mara kut shut nhang é nghut le gi, haû lé hpyit dú pyám aq; hkyî í hkyî dap luî, hkâ-nhám le, myiduq a dat shum é ngaraî ming má dú hkyô pyâm é hui râ htoq má, hkyî rahkyî za dap luî, ahtum abyuq é asak wó râ shut wang le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Haû ngaraî ming gi, 'yhangmoq lé hkê nyi é luq le a shî, myiduq le a shûm' é jowò nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Náng é myoqjí èq, nang lé mara kut shut nhang é nghut le gi, haû lé lap choq pyám aq; myoqjí í jí dap gû, ngaraî ming má dú hkyó pyâm é hui râ htoq má, myoq rají eq za, Garai Gasâng é mingdán má wang le gi, náng é matú je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","(Haû ngaraî ming gi, 'yhangmoq lé hkê nyi é luq le a shî, myiduq lé a shûm' é jowò nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hkâsu mù gâ le, hkungga sho lé xo kat luî lhoq sansêng é su, myi gi, yuq hkangmó lé lhoq sanséng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Xo gi, ge lhê. Nghut kôlhang, xomân kân byuq jáng gi, hkâsu kut dum wó lhoq ngam yù râ lhú? Nungmoq gi, xo su ngam nyì mù, rayuq eq rayuq nguingón nyî keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hau htâng má, Yesuq gi, Kaperna-um mai htoq ló mù, Yuda mau mâ é maukyo má ê jé luî, Yodan làng tû tap má dap ló bê nghut ri; byù myo myo gi, Yhâng chyáng dum zîng lé lô kôluî, Yesuq gi, Yhang lhaq kut nyi é eq rajung za, haú bang lé mhoqshit byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hparishe pé ra-am gi, lé jé kômù, \"Byù rayuq, yhumsing é yhangmyi lé lhoq kâng pyâm le, tarâ wang lhê lhú?\" ga myî é dong, Yhang lé chyam wú akô. ");
INSERT INTO atbNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesuq gi, \"Mosheq gi, nungmoq lé, hkâsu ga hkunmó hkyó tô é lhú?\" ga taû myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Haú hkûn, yhangmoq gi, \"Yuqgè rayuq gi, lhoq kang laiká ká mù, yhangmyi lé wó nhang pyâm lhê ga, Mosheq, ahkáng byî tô ri.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuq dum tû taî é gi, \"Nungmoq é myit nhiklhum htân kô é yanmai, Mosheq gi, tarâ haú lé kâ tô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nghut kôlhang, mau htoq xâng hkun lé, Garai Gasang gi, 'yuqgè eq myiwe lé hpan é nghut lhê'. ");
INSERT INTO atbNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Hau é yanmai, yuqgè gi, yhumsing înu îwâ chyáng mai htoq luî, yhangmyi eq rahá rading ralhum za kut nyî mù, ");
INSERT INTO atbNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yhangnhik gi, gungsho ralhum za dut byuq kó râ nghut lhê.' Haû mù luî, yhangnhik gi, í yuq a nghut lo é za, rayuq za dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Haû mù luî, Garai Gasang lhoq tsûm tô é lé, byù gi, a lhoq kang sháng gaq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yhumhkaû má, yhangmoq nyi tô é hkûn lé, chángzô pé gi, haú hkyô eq séng luî, Yhang lé dum saî myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Haú hkûn, Yhang gi, \"Yhumsing é yhangmyi lé kâng pyám mù, myiwe gotû dum hâng yu é sû ó yuq nghut kôle, su-myi lú é sû dut bê nghut mù, yhangmyi lé shut é sû nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Myiwe rayuq le, yhumsing é yhanglâng lé kâng pyám mù, yuqgè góyuq eq dum hâng é nghut le gi, sulàng lú é hkyô lé kut bê nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Byu pé gi, zoshâng wuì lé Yesuq záng byi sháng gaq ga, Yesuq chyáng shuî lé lo akô; nghut kôlhang, chángzô pé gi, yhangmoq lé lhom tân hkûm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Haû lé Yesuq myàng jáng, Yhang gi, wú nhik-yo naû luî, \"Haû zoshâng wuì lé, Ngá chyáng lé nhâng keq; yhangmoq lé hkâhkûm zing to kó; hkâsu mù gâ le, Garai Gasâng é mingdán gi, haû su é bâng é mingdán ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngò, nungmoq lé teng za taí kôlé, ó yuq nghut kôle, Garai Gasâng é mingdán lé, zoshâng su kut a lhom hap yu é nghut le gi, mingdán haú má wó wâng râ a nghut.\" ga yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hau htâng, Yesuq gi, zoshâng wuì lé bún yû mù, yhangmoq ahtoq má loq ke luî, shimân byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuq gi, hkyô dum so xoq e ló é hkûn, byù rayuq gi, din lé lô mù, Yhâng é hí má hkyihput htuq luî, \"Ge é Sará ê, ahtum abyuq é asak wó yû râ matú, ngò haî kut ra râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Haû mù, Yesuq gi, \"Haî mù, Ngo lé ge é Sará nghu lhê lhú? Garai Gasang mai lai luî, ge é ó yuq le a nyì. ");
INSERT INTO atbNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jep e tarâ má, 'Byù hkâsat, su-myi sulàng hkâlú, hkâhkau, a teng a mán é saksé hkâhkám, hkâmô zo, nángnu nángwa lé hkungga aq!' ga bo tô é lé, nàng sê lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Haú hkûn, haú yuq gi, \"Sará ê, haú pé banshoq lé, ngò, zoshâng hkûn mai cháng bê nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuq gi, haú yuq lé wú tsuq to mù, yhang lé chyitdap luî, taî é gi, \"Nàng kut râ rajung râ tô ashî; ló mù, nàng wó miwó lé ûng pyám luî, myùng bang lé byî pyám aq; haû jáng, nàng, mauhkûng htoq má sutzè wó râ nghut lhê; haû mù, Ngá htâng lé cháng aq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Haú yuq gi, dang haú lé wó gyo jáng, sutzè gyai wó sû nghut é yanmai, myoqdong shum byuq mù, gyai yhang myit a ngón é èq ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuq gi, lhînghkyuq byu wú mù, Yhâng é chángzô pé lé, \"Sutzè wó bang gi, Garai Gasâng é mingdán má wàng râ matú, haû-í yhang wuî ri-nhung!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chángzô pé gi, Yhang taî é dâng é yanmai, mauhong bum akô nghut ri. Nghut kôlhang, Yesuq dum xoq taî é gi, \"Zo wuî ê, Garai Gasâng é mingdán má wàng râ matú, haû-í yhang wuî ri-nhung! ");
INSERT INTO atbNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sutzè wó sû rayuq, Garai Gasâng é mingdán má wó wâng râ htoq, gola-uq radu âpno mai wó wang lai râ gi, je luì râ nghut lhê.\" gâ taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Haú hkûn, chángzô pé gi, je riyhang maú byuq kômù, rayuq eq rayuq, \"Haû su ru nghut le gi, ó yuq za hkyi yu é hui râ nghut lhê lhú?\" ga, taî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Haú hkûn, Yesuq gi, yhangmoq lé wú kat mù, \"Haú hkyô lé, byù mai gi, wó kut râ a nghut; nghut kôlhang, Garai Gasang gi, wó dut lhê; hkâsu mù gâ le, Garai Gasang gi, lhunglháng lé wó kut é Sû nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Haú hkûn, Petruq gi, Yhang lé, \"Ngamoq gi, wó é gû lhunglháng lé tô pyâm to luî, Náng htâng cháng bê nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Haû mù, Yesuq tû taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, Ngá é yanmai le, gabú danglu é yanmai le, yhumsing é yhûm, gumang gu-nhá, înu îwa, zo dù wuì eq yò pé lé tô pyâm tô é sû ó yuq nghut kôle, ");
INSERT INTO atbNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","shí pyat lhê é yhûm pé, gumang gu-nhá wuî, înu pé, zo dù wuì eq yò pé lé, rashô tú wó hkam yù luî, zing-rî é hkyô pé lé le hui kó râ nghut é htoq agó, htang pyat má le, ahtum abyuq é asak wó yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nghut kôlhang, hí nghut nyi é bang myo myo gi, htâng gyó byuq kó râ nghut mù, htâng gyó nyì bang yuq gi, hí bekô râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yhangmoq gi, Yerusalem wà mó shut doq ló nyî kô é u lé, Yesuq gi, yhangmoq é hí má sô tô ri; haú hkûn, htâng má sô é bang gi, gyuq nyi bùm kô é u lé, haû chángzô pé gi, maú byuq bum akô nghut ri; Yesuq gi, haû chángzo raxe í yuq lé gotû kut dum wut yù mù, Yhâng chyáng dut lò râ hkyô, yhangmoq lé taî kyô é gi, ");
INSERT INTO atbNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","\"Wú keq, nga-nhúng gi, Yerusalem wà mó shut doq ló nyi lhê; haû Byu Yhangzo gi, hkyangjong agyi pé eq tarâ sará pê é loq má ap byî pyâm é hui râ nghut lhê; haú bang gi, Yhang lé, shî râ mara byi luî, tûngbaù pê é loq má ap byî pyám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Haú bang gi, Yhang lé, wuìzuì kut pyâm é, sôkan byé gyûn é, nhuq bat é kut yû mù, sat pyám kó râ nghut lhê. Hau htâng sum nyí má, Yhang dum dui toq lô râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hau htâng má, Zebedi é yhangzo Yakuq eq Yohan nhik gi, Yesuq chyáng lé kômù, \"Sará ê, ngá-nhik dûng é gû banshoq, Nàng kut byi râ lé, ngá-nhik ô nau ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Haú hkûn, Yhang gi, \"Ngò, nungnhik lé haî kut byi râ ô naû akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yhangnhik gi, \"Náng é hpungwup shingkang hkaû má, ngá-nhik tâng lé, Náng é loqyò hkyam má rayuq, loqpaî hkyam má rayuq kut, zùng nhâng laq.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nghut kôlhang, Yesuq gi, \"Nungnhik haî dûng nyi é lé, nungnhik a sé kó nghut ri. Ngò shuq râ góm lé, nungnhik wó shuq kó râ lhú? Ngò hkam yù râ baptisma lé, nungnhik wó hkam yù kó râ lhú?\" ga yhangnhik lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Haú hkûn, yhangnhik gi, \"Nga-nhik wó dut lhê.\" ga tû taí kôjáng, Yesuq gi, \"Ngò shuq râ góm lé, nungnhik shuq kó râ nghut lhê; ngò hkam yù râ baptisma lé le, nungnhik hkam yù kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nghut kôlhang, Ngá é loqyò, loqpaî hkyam má zùng râ ahkáng lé gi, Ngò byî jung a nghut. Jowò haú pé gi, hen to byî é hui bâng matú za nghut lhê.\" ga yhangnhik lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Haû su gâ é hkyô lé, haû gotû chángzo raxê yuq wó gyo kôjáng, yhangmoq gi, Yakuq eq Yohan nhik lé nhik-yô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesuq gi, yhangmoq banshoq bang lé wut tsîng yù luî, \"Tûngbaù pé lé uphkang é ga bang gi, tûngbaù pé lé up zô nyì kô é hkyô lé le, haû eq rajung za, yhangmoq é ming up suwún wuî le, yhumsing é ahkáng ayá lé chûng mù, up zô nyì kô é hkyô lé le, nungmoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nghut kôlhang, nungmoq chyáng gi, haû su a dut kó sháng gaq, nungmoq má, byù mó dut naù sû ó yuq nghut kôle, nungmoq é dui-nhâng zoshâng dut ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hau htoq agó, nungmoq má ushuq dut naù sû ó yuq nghut kôle, banshoq bâng é jùn dut ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hkâsu mù gâ le, haû Byu Yhangzo lháng gi, dojaú é lé hkam yù râ matú jé lé é a nghut e za, dojaú râ matú eq byù myo myô é matú, shîhtaí gunglik hkungga dông, Yhâng é asak lé byi pyám râ matú sheq, jé lé é ru nghut lhê.\" ga, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hau htâng, yhangmoq gi, Yerihko wà má jé ló akô nghut ri. Yesuq eq Yhâng é chángzô pé gi, byù moq mó eq rahá, wà mai htoq ló nyî kô é hkûn, Barateme (Teme é yhangzo) gâ é myoqjit sû rayuq gi, hkyô yàm má dung zô zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yhang gi, Nazaret wà byù Yesuq laî ló é lé wó gyo jáng, \"Dawiq é Yhangzo Yesuq ê, ngo lé shogyo yù laq ô!\" ga garû kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Haû mù, byù myo myo gi, zim za nyì râ matú yhang lé tân hkûm akô; nghut kôlhang, yhang gi, \"Dawiq é Yhangzo ê, ngo lé shogyo yù laq ô!\" ga, je riyhang garû kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Haû mù luî, Yesuq gi, yap nô kat mù, \"Yhang lé ji kat keq.\" ga taí jáng, yhangmoq gi, \"Myit ngón aq hkoi; Yhang, nàng lé ji nyi ri; toq aq.\" ga myoqjit sû haû lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Haú hkûn, haú yuq gi, yhâng é buhîng lé hkyut pyám mù, byam chyu luî, Yesuq chyáng lé jé ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuq gi, yhang lé, \"Ngò, nang lé haî kut byi râ ô nau ri lhú?\" ga myi jáng, yhang gi, \"Sará ê, ngò myoq myàng nau ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuq gi, \"Ló aq hkoi, náng é lumjíng myit gi, nàng lé lhoq gê byi bê nghut ri.\" ga taí kat é hkûn jáng, yhang gi, myoq wó myâng mù, Yesuq e ló é hkyô shut cháng e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesuq eq Yhâng é chángzô pé gi, Yerusalem wà mó eq chyâng lo nyì kô é hkûn, Tsanlun Bùm mâ é Bethpage wà eq Behtani wà má jé ló kôjáng, Yesuq gi, Yhâng é chángzo í yuq lé, ");
INSERT INTO atbNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","\"Nungnhik, hí mâ é wà má ê keq; wà haú má wang é hkûn jáng, ó le a jî wú shî é logúng zo tuî to láng é lé, ê myâng kó râ nghut lhê; haú lé hpyi yù mù, Ngá chyáng she lò keq. ");
INSERT INTO atbNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Byù rayuq yuq mai, 'Haî mù, haû su kut nyi akô lhú?' ga nungnhik lé lhom myi jáng, 'Shí du lé, haû Yhumsîng râ ri ga, razup má dum taû dé byi râ nghut lhê.' nghû tû taí keq.\" ga pyîng luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Haú nhik gi, e ló mù, hkyô mó yâm mâ é hkumdong nàm má tuî tô é logúng zo radu lé, ê myâng kôluî, haú lé tuí hpyi nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Haú hkûn, haú má yap tô é bang ra-am gi, \"Haî mù, logúng tuí hpyi nyi akô lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Haû jáng, yhangnhik gi, Yesuq pying kat é eq rajung za taî kyo kôjáng, yhangmoq gi, she ló râ ahkáng byî kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yhangnhik, logúng zo haû lé Yesuq chyáng she jé lo é hkûn, logúng hau é gùng htoq má, yhangmoq é buhîng pé buí jáng, hau é ahtoq má, Yesuq doq jî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Byù myo myo gi, yhangmoq é buhîng pé lé, hkyô má hkyut hkang byî akô; ra-am gi, yò pé má zân yu é mhandíng lé hkang byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hí má so bang eq htâng má châng é bang gi, \"Hosana! Haû Yhumsîng é myìng mai jé lé lô Sû gi, hkungsô wó nyî sháng gaq ô! ");
INSERT INTO atbNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jé lé lô râ nghut é, nga-nhûng é îwa Dawiq é mingdán gi, hkungsô wó nyî sháng gaq ô! Htoq tsáng myhâng má hosana nghut sháng gaq ô!\" ga luî, taî garû bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuq gi, Yerusalem wà mó má jé mù, noqkuq yhûm má wang ê luî, lhînghkyuq mâ é jung hkangmó lé wú ri; nghut kôlhang, buì gyum ló bê nghut é yanmai, Yhâng é chángzo raxe í yuq eq rahá, Behtani wà shut htoq e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hau htang nyí, yhangmoq, Behtani wà mai htoq ló kô é hkûn, Yesuq gi, zo mut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yhang gi, ahaq wúm é maihpáng gâm ragàm lé, we we mai byu-myang kat jáng, agàm haú má ashi zuî lhê laq ga ê jé wú le, ahaq mai lai luî, haî le a myàng nghut ri. Haî mù gâ le, maihpáng-shi zui yâm a nghut é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Haû mù, Yesuq gi, shigâm haû lé, \"Ahkuî mai gi, náng chyáng mâ é ashi, ó yuq le a myàng zo lo kó sháng gaq.\" ga taî ri. Yhâng é chángzô pé gi, haû su ga taî é dang lé wó gyô yu akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yhangmoq, Yerusalem wà mó má jé é hkûn, Yesuq gi, noqkuq yhûm má wang ê mù, haú mâ é zè ung zè wuì kut nyi é bang lé, hkat htoq pyám luî, ngùn htaí zo bâng é siboî pé eq hpûngkyui ung zo bâng é tanghkuq pé lé tu mhuq pyám byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hau htoq agó, Yhang gi, ó yuq lé nghut kôle, ung zê lé noqkuq yhûm mai a waq lai nhâng kut pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesuq, yhangmoq lé mhoqshit é gi, \"'Ngá yhûm gi, byù myû lhunglhâng bâng é matú, kyûdung yhûm ga râ nghut lhê.' ga kâ tô é a nghut kó lhú? Nghut kôlhang, nungmoq gi, 'damyaq hkyûng' kut pyám bekô nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hkyangjong agyi pé eq tarâ sará pé gi, haú lé wó gyo kômù, Yhang lé hkâsu kut wó sat pyám râ hkyô ho nyi akô; nghut kôlhang, shiwa byu pé gi, Yhang mhoqshit é hkyô má, myit zìng zuq bùm kô é yanmai, yhangmoq gi, Yhang lé gyuq bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Myinhtâng jé jáng, Yesuq eq Yhâng é chángzô pé gi, wà hkaû mai htoq ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Htang napkyó, yhangmoq sô laî ló le, maihpáng gâm gi, amyit mai yhang nyhuî kyuq shi byuq é lé myang akô. ");
INSERT INTO atbNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petruq gi, myit bûn kat luî, \"Rabai ê, wú aq! Nàng nhîng pyâm é maihpáng gâm gi, nyhuî shi byuq bê nghut ri.\" ga luî, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Haú hkûn, Yesuq gi, \"Garai Gasang lé lumjíng keq. ");
INSERT INTO atbNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngò, nungmoq lé teng za taí kôlé, ó yuq nghut kôle, i-myit má úng-âng é hkyô a bo é za, yhumsîng taî é hkyô gi, dut lò râ nghut lhê ga lumjíng kô é nghut le gi, bùm shî lé, 'Htot mù, wuimau má ló gyó wâng aq.' ga taî le lháng, haú hkyô dut byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Haû mù luî, Ngò, nungmoq lé taí kôlé, nungmoq haî dûng le le wó yû râ nghut lhê nghû lumjíng kô é nghut le gi, wó yû kó râ za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mauhkûng htoq mâ é nungmoq é Îwa gi, nungmoq é mara lé hkyut pyám byi sháng gaq, nungmoq gi, kyûdûng yap tô é hkûn lé, rayuq yuq, nungmoq lé shut é mara bo é nghut jáng, mara hkyut pyám byi keq; ");
INSERT INTO atbNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Nghut kôlhang, nungmoq mai mara a hkyut pyám byî é nghut le gi, mauhkûng htoq mâ é nungmoq é Îwa le, nungmoq é mara lé hkyut pyám byi râ a nghut.)\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yhangmoq, Yerusalem wà mó má dum jé mù, Yesuq gi, noqkuq yhûm wàng hkaû má sô yông wún é u lé, hkyangjong agyi pé, tarâ sará pé eq suwún wuî gi, Yhâng chyáng lé jé kômù, ");
INSERT INTO atbNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","\"Hai ahko ahkâng èq, Nàng, shí pé lé kut nyi lhê lhú? Haû su kut râ ahko ahkáng, Nang lé ó yuq byî é lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Haû jáng, Yesuq gi, \"Ngò le, nungmoq lé rajung myî wú kôlé, tû taî wú keq; haú hkûn, hai ahko ahkâng èq, Ngò, shí pé kut é hkyô lé taî kyo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohan byî é baptisma gi, mauhkûng mai lhú? A nghut jáng, byu chyáng mai lhú? Taî wú keq!\" ga taû myî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Haú hkûn, yhangmoq chôm hpyê lhum kô é gi, \"'Mauhkûng mai nghut lhê' nghû nga-nhúng taí jáng le, 'Haû nghut le nhîng, haî mù, yhang lé a lumjíng kô é lhú?' ga râ nghut; ");
INSERT INTO atbNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Byu chyáng mai nghut lhê.' nghû jáng le…\" gâ ri. (Yohan gi, myiqhtoi rayuq gè gè nghut lhê ga, lhunglhâng bang lumjíng bûm kô é yanmai, yhangmoq gi, haû byu pé lé gyuq bum akô nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Haû mù, yhangmoq gi, Yesuq lé, \"Ngamoq a sé.\" ga tû taî akô. Haú hkûn, Yesuq gi, \"Haû jáng, Ngò le, hai ahko ahkâng èq shí pé kut é hkyô lé, nungmoq lé a taî kyo.\" ga, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hau htâng, Yesuq, dangtú dông yhangmoq lé taî é gi, \"Byù rayuq gi, tsibyiq hkyâm rahkyam saî to mù, lhînghkyuq kyâm to luî, tsibyiq wing pyik htoq râ donghkong dû to mù, machya ralhum saî tô ri. Hau htâng, yhang gi, hkyâm haú lé, hkyâm saí zo bâng chyáng ngho byî to mù, gó ming shut e ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kyôshu yoq jé jáng, yhang gi, yhang yù âng é tsibyiq shi ê yû râ matú, dui-nhâng zoshâng rayuq lé, hkyâm saí zo bâng chyáng nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nghut kôlhang, haú bang gi, haú yuq lé lhom chyup bat luî, loq kôm taû nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Haû mù, yhang gi, gotû dui-nhâng zoshâng rayuq lé, yhangmoq chyáng dum nhang kat ri; yhangmoq gi, haú yuq lé le, ulhum má lhom bat cheq byi kôluî, hoq lhoq hpû kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hau htâng, rayuq lé dum nhang kat jáng, haú yuq lé gi, lhom sat pyâm akô; Yhang gi, góbang myo myo lé le, yhangmoq chyáng nhang kat ashî nghut ri; yhangmoq kúm gi, ra-am lé lhom bat, ra-am lé lhom sat pyám, kut akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ló htáng má, yhang gi, yhang chyitdap é zo lé nhang kat râ za ru nghut alô; haû mù, yhang gi, 'Ngá zo lé gi, yhangmoq lhom hkungga kó râ nghut lhê.' ga, yhangzo lé nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nghut kôlhang, haú bang gi, 'Shí yuq gi, silí wunlí sing yù râ sû nghut lhê; lé keq, yhang lé sat pyám sháng, haû jáng sheq, silí wunlí pé lé nga-nhúng wó yû râ nghut lhê.' ga rayuq eq rayuq taî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Haû mù, yhang lé chyup yû luî, sat pyám mù, hkyâm shinggan shut dú htoq pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Haû jáng, tsibyiq hkyâm yhumsîng gi, yhangmoq lé hkâsu kut râ lhú? Yhang gi, ê mù, haû hkyâm saí zo bang lé sat pyám luî, hkyâm haú lé, góbang lé htot ngho byî pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Chyúmdang má, 'Yhûm saí bâng èq hkyin htoq pyâm é luqgok gi, htungchyûn mâ é ahkyak dik é luqgok dut bê. ");
INSERT INTO atbNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Shí hkyô gi, haû Yhumsîng kut é nghut luî, nga-nhûng é myoq hí má mauhpo dut bê nghut ri.' ga bò tô é lé, nungmoq a nghap wú kó lhú?\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hau htâng, yhangmoq gi, dangtú haû, yhangmoq lé lhoq ang luî taî é hkyô lé, sé kô é yanmai, Yhang lé chyup yû râ matú hkyô ho nyi akô. Nghut kôlhang, yhangmoq gi, byù moq mó lé gyuq kô é yanmai, Yhang lé nyhi pyâm to luî, htoq ló byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hau htâng má, yhangmoq gi, Yesuq é dang má mara hô luî Yhang lé chyup yû râ matú, Hparishe pé ra-am eq Herut é byu pé ra-am lé, Yesuq chyáng nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Haú bang gi, Yhâng chyáng lé jé kômù, \"Sará ê, Nàng gi, tengmán sû nghut é lé, ngamoq sê lhê. Nàng gi, ó haî ga râ lé le haî su a ngàm sû nghut é yanmai, ó yuq é myoqdong lé le a tê byî é za, Garai Gasâng é hkyô lé, tengmán é dông mhoqshit é sû nghut ri. Haû mù, Kehtaq lé kang kat byî le gi, ge lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngamoq kat ra râ lhú? A kat ra râ lhú?\" ga Yhang lé taî akô. Yesuq kúm gi, yhangmoq, gegùn labyoq kut nyî kô é lé sé mù, \"Nungmoq gi, haî mù, Ngo lé lé chyam wú akô lhú? Denari ngùn rachap yu lé keq, ngò wú wú bá.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Haú hkûn, yhangmoq yu jé lô jáng, Yhang gi, \"Shí má, ó yuq é alhô eq masat laiká dap tô ri lhú?\" ga myî ri. Yhangmoq gi, \"Kehtaq é nghut ri.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Haû mù, Yesuq gi, yhangmoq lé, \"Kehtaq é lé gi, Kehtaq lé byi keq; Garai Gasâng é lé gi, Garai Gasang lé byi keq.\" ga taí jáng, yhangmoq gi, maú byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Haû dum dui toq hkyô a joq gâ é Saduke pé gi, Yesuq chyáng lé jé kômù, dangmyi lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yhangmoq myi kô é gi, \"Sará ê, myiwe wó é byù rayuq gi, zo dù a dap é za shi byuq é nghut jáng, yhanggu gi, yhangmang é awut ashín xoq byi râ matú, yhâng rhat lé chui gon ra râ nghut lhê ga, nga-nhúng lé, Mosheq kâ to byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hí hpyang lé, gumang nhiktâng wuì nyhit yuq nyi akô. Lagám yuq gi, myiwe yù luî, zo dù a dap é za shi ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lanong yuq gi, yhangmang mó é chui lé gon mù, zo dù a dap é za shi ló byuq bê. Lalaq yuq le, haû eq rajung za dut byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Haú nhiktâng wuì nyhit yuq gi, zo dù a dap é chyat shi ló byuq bùm bekô nghut ri. Htâng má, myiwe myhí haû le châng shi ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haû mù luî, haû dum dui toq é buinyì má, myiwe myhí haû gi, hká yuq é yhangmyi nghut râ lhú? Hkâsu mù gâ le, yhang gi, haú nyhit yuq é yhangmyi dut wú bê sû nghut ri.\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuq gi, yhangmoq lé, \"Nungmoq hkyô nghoq é gi, Chyúmdang eq Garai Gasâng é wum-o a-tsam lé, a sé kô é yanmai nghut lhê, a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Haû shi byuq bê bang dum dui toq é hkûn gi, myi byi myi yû hkyô joq lo râ a nghut; yhangmoq gi, mauhkûng htoq mâ é maumang lagyô pé su dut byuq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Shi é mai dum lhoq dui toq é hkyô eq séng luî, Mosheq kâ tô é laiká má lháng, haû nyé duq nyi é mhanpúng mai, Garai Gasang gi, yhang lé, 'Ngò gi, Abraham é Garai Gasang, Isak é Garai Gasang, Yakup é Garai Gasang nghut lhê.' ga kâ tô é lé, nungmoq a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Garai Gasang gi, shi bê bâng é Garai Gasang a nghut, dui nyì bâng é Garai Gasang sheq ru nghut lhê. Nungmoq gi, shut dik bekô nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tarâ sará rayuq gi, lé lô mù, yhangmoq taî htîng lhum nyì kô é lé, lé wó gyô ri. Yhang gi, haú bang lé, Yesuq rago tû taî nyi é lé myàng jáng, Yesuq lé, \"Jep é tarâ banshoq má, hká lhum gi, ahkyak dik lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Haû jáng, Yesuq gi, \"Ahkyak dik é jep é tarâ gi, 'Israelaq byu pé ê, gyo wú keq! Nga-nhûng é Yhumsîng Garai Gasang za, Garai Gasang nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Haû Yhumsîng náng é Garai Gasang lé, náng é myit nhiklhum banshoq, náng é asak woi-nyí lhum gón, nàng myit é hkyô banshoq, náng é wum-o banshoq èq, chyitdap râ lhê.' gâ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hau htang lhum gi, 'Náng gûng lé nàng chyitdap é su, náng é chyangnâm mâ é bang lé le chyitdap aq.' gâ é nghut lhê. Shî í lhûm htoq kô é tarâ gotû a joq lo.\" ga yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Haú hkûn, tarâ sará haú yuq gi, \"Gyo naû bê, Sará ê! Garai Gasang rayuq za nghut lhê, gotû a nyì lo ga nàng taî é gi, têng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Garai Gasang lé, náng é myit nhiklhum banshoq èq le, náng é sê gyo é nyan banshoq èq le, náng é wum-o banshoq èq le, chyitdap râ lhê gâ é eq, náng gùng lé nàng chyitdap é su, náng é chyangnâm mâ é bang lé le chyitdap râ lhê gâ é gi, myi nyhé hkungga eq gotû hkungga pé banshoq htoq má, je ahkyak lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuq gi, yhang hpaqchyî bo é dông tû taî nyi é lé myàng jáng, \"Nàng gi, Garai Gasâng é mingdán eq a we lo nghut ri.\" ga yhang lé taî kat ri. Haú hkûn mai gi, ó yuq le, Yhang lé dangmyi a wám myi lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuq, noqkuq yhûm má mhoqshit nyi é hkûn lé taî é dang gi, \"Haî mù, haû tarâ sará pé gi, Hkrisduq lé, Dawiq é yhangzo za nghut lhê gâ akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawiq gi, Chyoiyúng Woi-nyí èq taí nhang é má, 'Haû Yhumsîng Garai gi, ngá é Yhumsîng lé, \"Ngò, náng é gumlau gye pé lé, náng é hkyiwa ô má tô pyâm é hkyíng jé shoq, Ngá é loqyo hkyam shut zung nyì shi aq.\" ga taî ri.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Haû mù, Dawiq yhang lháng, Hkrisduq lé, Yhumsîng gâ é nghut le gi, yhangzo za hkâsu ge nghut râ lhú?\" gâ ri. Byù hpûng mó gi, Yhâng é dang lé, gabú myit èq gyô nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuq gi, mhoqshit uchyang taî é má, \"Tarâ sará pé lé sidiq nyì keq. Yhangmoq gi, réng é buhîng wut chûng mù, sô yông wún luî, gaì pé má lhom shi-kyâm yù râ lé le, ");
INSERT INTO atbNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tarajong pé mâ é ahkyak dik é zùng jang pé eq poî pé mâ é réng é zùng jowò pé má myang zùng râ lé le, ô nau nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yhangmoq gi, chuimó pê é yhûm-yò pé lé hpyoq zo hpyoq shuq kôluî, kyû hîng hîng dûng shit mhaú é bang nghut akô. Haû su é bang gi, dam byî é je riyhang hui zo kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuq gi, alu sidek nàm má zung to mù, noqkuq yhûm mâ é alu sidek haú má, byù moq mó ngùn kat nyi é lé wú nyi ri. Sùt wó bang myo myo gi, ngùn ga-myhó myhó kat bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Haú hkûn, myung é chuimó myhí rayuq gi, lé mù, gyi htingchap ngùn zo í chap lé kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuq gi, Yhâng é chángzô pé lé wut yù mù, \"Ngò, nungmoq lé teng za taí kôlé, shî myung é chuimó myhí gi, góbang banshoq htoq má je myo kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Haû góbang banshoq gi, yhumsîng agùn agó wó é mâ é lé, lé kat akô; yhang kúm gi, myùng sû nghut kôle, yhâng é asak lé baú râ ngùn banshoq lé, kat bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuq, noqkuq yhûm mai htoq ló é hkûn, Yhâng é chángzo rayuq gi, \"Sará ê, wú aq; hkâ-í ko é luqgok pé! Hkâ-í hkik é yhûm pé!\" ga Yhang lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Haú hkûn, Yesuq gi, \"Nàng, yhûm mó shí pé lé myàng lhê a nghut lhú? Luqgok shí pé gi, rachâm htoq racham lháng a kê lhum loshoq, hpyoq hpyi pyâm é hui râ nghut lhê.\" gâ tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuq gi, Tsanlun Bùm má, noqkuq yhûm shut hû mù zung tô é hkûn, Petruq, Yakuq, Yohan eq Andre pé gi, Yhâng chyáng lé jé kômù, ");
INSERT INTO atbNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"Haú hkyô pé gi, hkâ-nhám dut lò râ lhú? Haû dut lò râ hkûn, hkasû é kumlhá htoq lô râ nghut lhê lhú? Ngamoq lé taî kyô wú laq.\" ga Yhang lé baú myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Haû mù, Yesuq gi, yhangmoq lé, \"Nungmoq lé, ó yuq èq le a wó shuî nghoq sháng gaq, sidiq nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hkâsu mù gâ le, 'Ngò gi, haú yuq nghut lhê.' ga, Ngá myîng lé lâng é byù myo myo pô htoq lô mù, byù myo myo lé shuî nghoq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nungmoq gi, majan dut nyi é hkyô eq majan eq sêng é danglám pé lé, wó gyo kôjáng, hkâgyuq dàn kó. Haú hkyô pé gi, dut lò râ za nghut lhê; nghut kôlhang, ló htâng é buinyì gi, a nghut shi. ");
INSERT INTO atbNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Byù ra-myû eq ra-myû, mingdán ralhum eq ralhum majan zân lhûm lò kó râ nghut lhê. Jowò myo myo má, layàng nún é, mutmó gyó é pé dut lò râ nghut lhê. Haú pé gi, wuîhke jamjau hkyo é apûn awang za ru nghut ashî. ");
INSERT INTO atbNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nungmoq gùng nungmoq sidiq nyì keq. Hkâsu mù gâ le, yhangmoq gi, nungmoq lé, tarâ rûng pé má ê ap pyám kó râ nghut é htoq agó, tarajong pé má nungmoq lé nhuq bat kó râ nghut lhê. Hau htoq agó, nungmoq gi, Ngá mying é yanmai, mauzau wuì eq hkohkam pê é hí má, saksé dông yap ra kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Haû gabú danglù gi, amyû banshoq lé hí hko kyo ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nungmoq gi, chyup yu é hui luî, jep huî é hkûn, haî taí râ lé, hkâ-myit chiq kó. Ahkyíng jé jáng, nang lé myit htoq lô nhang é dong za taí aq; hkâsu mù gâ le, dang haú pé gi, nungmoq taî é a nghut, haû Chyoiyúng Woi-nyí èq taí nhang é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nhiktâng gi, nhiktâng yhangchang, îwa gi, yhangzo lé, shî shoq ap pyâm lhum kó râ nghut lhê; zo wuî gi, mó wuî lé gumlau toq mù, sat pyám nhâng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Byù lhunglhâng bang gi, Ngá é yanmai, nungmoq lé a nguì kut kó râ nghut lhê; nghut kôlhang, jihtûm jé shoq wó hkam jân nyi é sû gi, hkyi yu é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","'Haû lhoq hten lhoq hpyoq é achaq achyut hkyô' gi, yhang a nyi âng é jowò má yap tô é lé, nungmoq myàng kôjáng (laiká nghap é sû gi, sê gyo sháng gaq), Yuda mau má nyi é bang gi, bùm pé shut hpang doq ló kó sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yhumhkûng htoq má nyi tô é sû gi, yhúmhkaû mâ é zè haî lé le, a ló gyó wang yù lo sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yò má nyi tô é sû gi, yhâng é buhîng lé a ló taû yu nyì lo sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Haú buinyì pé má, zogùng dut é myiwe wuì eq naú huq ashî nghut é înu wuì gi, hkâ-í yhang wuîhke bekó nghut ri myhi-nhung. ");
INSERT INTO atbNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Haú hkyô gi, gyoqmyò má a dut sháng gaq, kyûdûng nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Hkâsu mù gâ le, Garai Gasang, mingkan lé hpan tô é hkûn mai ahkuî jé shoq, hkâ-nhám le a dut wú shî é wuîhke jamjau mó gi, haú buinyì pé má dut lò râ nghut lhê; haû su é hkyô gi, htângnùng má hkâ-nhám le dum dut lo râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Buinyì haú pé lé, haû Yhumsîng Garai mai a lhoq shaû é nghut le gi, ó yuq le asak wó lut râ a nghut. Nghut kôlhang, Yhang hkyin yù bê nghut é, hkyin yù hui bâng é matú gi, buinyì haú pé lé, Yhang lhoq shaû pyám byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Haú ahkyíng má, byù rayuq yuq mai, nungmoq lé, 'Wú keq, shî má Hkrisduq nyi ri.' ga le, 'Wú keq, Yhang hê má nyi ri.' ga le, taí jáng, nungmoq hkâjíng kó. ");
INSERT INTO atbNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hkâsu mù gâ le, Hkrisduq apyoq pé eq myiqhtoi pyoq pé pô htoq lô mù, wó dut é nghut jáng, hkyin yù hui bang lé lháng, wó lhoq nghoq shoq ga, kumlhá pé eq laklaí kumlhá pé lé kut shit kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Haû mù, nungmoq sidiq nyì keq; ahkyíng a jé shi mai, ngò, nungmoq lé, jung hkangmó taî kyô nyì gù nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Buinyì haú pé má, wuîhke jamjau haú pé laî é htâng, 'Buì gi, noq byuq mù, lhamó gi, a tsô dut byuq râ nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kyî pé gi, mauhkûng mai byit gyó lo bùm mù, mauhkûng mâ é wum-o a-tsam pé gi, lhoq nhûn é huî bùm kó râ nghut lhê.' ");
INSERT INTO atbNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Haú hkûn, haû Byu Yhangzo gi, mhut ji mù, hpungwup a-tsam mó eq le, hpungwup shingkang eq le, gyó lé lo é lé, byu pé byu-myàng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hau htâng má, Yhang gi, Yhâng é maumang lagyô pé lé nhang kat mù, maumyî chyûn hkangmó eq myigùng htum shoq, mauhkûng htáng shoq mai, Yhang hkyin yu tô é bang lé shuî tsîng yù nhâng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Maihpáng gâm lé wú mù, mhoq yû keq; agàm mai a-nyuq nyún lô mù, ahaq htut lô jáng, buì nyé nám chyâng lò bê lé, nungmoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Haû eq rajung za, shí hkyô pé dut nyi é lé, nungmoq myàng kôjáng, Yhang gi, chyáng bê nghut mù, hkúmdong má lháng nghut nyî bê hkyô lé, nungmoq sé lo keq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ngò, nungmoq lé teng za taí kôlé, shí pyat mâ é byu pé a ban shi byuq shimá, haú hkyô pé banshoq dut byuq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mauhkûng eq myigùng gi, a joq lo dut byuq râ nghut lhê; nghut kôlhang, Ngá é dang gi, ru joq nyî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Buinyì eq ahkyíng haú lé gi, ó yuq le a sé; mauhkûng htoq mâ é maumang lagyô pé lháng a sé; haû Zo le a sé; haû Îwa za ru sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Haû mù, nungmoq gi, ahkyíng haû hkâ-nhám jé râ lé, a sé kô é yanmai, sidiq nyì keq! Machya nyî keq! ");
INSERT INTO atbNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Haû gi, byù rayuq, yhâng é dui-nhâng zoshâng wuì lé, ó le ó eq sêng é mû lé gàm byî to mù, hkum zúng sû lé le, machya nyì râ matú pying to luî, yhâng yhûm lé, haû dui-nhâng zoshâng wui chyáng ap pyâm to mù, byìn we shut htoq ló byuq é sû eq pung ri. ");
INSERT INTO atbNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Haû mù, haû Yhumsîng hpó gi, myinhtâng laq, myín gunggàm laq, woqtûn hkun laq, maubó zó laq, hkâ-nhám jé lô râ lé nungmoq a sê kô é yanmai, sidiq machya nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Haû a nghut jáng, Yhang, dàn loq tung tau jé lo é hkûn, nungmoq yhup myhî tô é lé, lo myang pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngò, nungmoq lé, 'sidiq machya nyì keq,' nghû taî é eq rajung za, yuq hkangmó lé le, taî é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ahkuî, haû Lhoqlhai Poî eq múnchi a kat é Muk Zo Poî jé râ í nyí za ru ra alô hkûn, hkyangjong agyi pé eq tarâ sará pé gi, Yesuq lé hkâsu kut wó haq chyup yû mù, sat pyám râ matú, hkyô ho nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nghut kôlhang, yhangmoq gi, \"Byu pé gabyông lô kó abe, poî gyoro má gi, a kut shi sháng.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuq gi, Behtani wà má nyi é manggâm dap wú sû Simûn é yhûm, siboî má nghe zung tô é hkûn, myiwe myhí rayuq gi, nardu amyit mai za saî yu é, gyai hpaû é namngón xû bo é alabasta (luq hpyû) bòng yu lé lô mù, bòng haú lé lâng hkyui luî, namngón xû haú lé Yesuq é ulhum má hut gyun byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Haú má nyi tô é bang ra-am gi, wú nhik-yô é myit èq, rayuq eq rayuq taî lhum kô é gi, \"Haî mù, namngón xû lé aha agó kut pyâm lhê laq? ");
INSERT INTO atbNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Haû namngón xû lé, denari súm sho èq ung luî, myùng bang lé byî le ge lhê mhaî!\" gâ akô. Yhangmoq gi, myiwe myhí hau lé le, gyai chôm tân akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nghut kôlhang, Yesuq gi, yhangmoq lé, \"Myiwe zo haú lé, hkâtân nyì kó; haî mù, yhang lé i-myit lhoq myo nhang nyi akô lhú? Yhang gi, Ngá é ahtoq má ge é hkyô kut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Haû myùng bang gi, nungmoq eq rahá hkâ-nhám le nyì râ nghut lhê mù, nungmoq garúm nau é hkûn, yhangmoq lé wó garúm lhê. Nghut kôlhang, ngò gi, shî má nungmoq eq rahá ayang nyi nyì râ sû a nghut. ");
INSERT INTO atbNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yhang gi, yhang wó dut é í kut bê nghut ri. Yhang, Ngá gûng má, namngón xû hut gyûn é gi, Ngá gûng lé yhum râ matú, hí hen lajâng tô é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngò, nungmoq lé teng za taí kôlé, haû gabú danglù lé mingkan gón hko kyô é jowò hkangmó má, yhang lé myit bûn é dông, yhang kut é hkyô shî lé, taî kyo bekô râ nghut lhê.\" ga taî kyo ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hau htâng, haû chángzo raxe í yuq má bo é Yudaq Iskarut gi, Yesuq lé ap pyám râ ga, hkyangjong agyi pê chyáng e ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Haú bang gi, haú hkyô lé lhom wó gyo kôjáng, gyô gabú luî, yhang lé ngùn byi râ ga, danggidiq byî akô. Haû mù, yhang gi, Yesuq lé ap pyám râ hkyô ho nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Haû htûngli joq é eq rajung za, Lhoqlhai Poî hkungga sauzo jaú byî é, múnchi a kat é Muk Zo Poî sâng-hi nyí má, Yesuq é chángzô pé gi, Yesuq lé, \"Nàng zo râ Lhoqlhai Poî lé, ngamoq hkâmá ê món to râ lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Haû mù, Yhang gi, chángzo í yuq lé, \"Nungnhik, myuq hkaû shut wang ló keq, wuì yambú waq é byù rayuq lhom hui râ nghut lhê; haú hkûn, nungnhik gi, yhâng htâng cháng keq. ");
INSERT INTO atbNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Haú yuq, wang ló é yhûm mâ é yhumsîng lé, 'Ngò, Ngá é chángzô pé eq rahá, Lhoqlhai Poî lé zo râ bíng wap hkâmá nghut lhê lhú ga, Sará myí nhang kat ri.' nghû taí keq. ");
INSERT INTO atbNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Haú hkûn, hen to gû nghut é, ahtoq mâ é wap mó lé lhom tûn shit râ nghut lhê. Wap haú má, nga-nhûng é matú ê hen to keq.\" ga taí luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chángzo haú nhik gi, htoq e ló mù, myuq hkaû má wang e ló le, Yesuq taî kat é eq roq za ê myâng kômù luî, Lhoqlhai Poî lé, món to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Myinhtâng jé lô jáng, Yesuq gi, haû chángzo raxe í yuq eq rahá, haú má lé jé bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yhangmoq gi, siboî má nghê mù, zô nyi bùm kô é u lé, Yesuq gi, \"Ngò, nungmoq lé teng za taí kôlé, Ngò eq rahá zô nyi é bang nungmoq mâ é rayuq sû gi, Ngo lé ap pyám râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Haú hkûn, yhangmoq gi, gyô yón kômù, rayuq htâng rayuq, \"Ngò, a nghut hkaî?\" ga Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Haú hkûn, Yhang gi, \"Haú yuq gi, haû raxe í yuq mâ é rayuq nghut lhê. Ngò eq rahá, hkoq shí má muk jùmzo sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Haû Byu Yhangzo gi, Yhang eq séng luî kâ tô é eq rajung za, shî râ za nghut lhê. Nghut kôlhang, haû Byu Yhangzo lé ap pyâm é sû gi, dingnyé wó ri; haú yuq gi, a hku lé le lháng, je ge ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yhangmoq zo nyi kô é u lé, Yesuq gi, muk lé yù mù, jeju hkya-on luî, muk lé myhik hpé mù, \"Shî gi, Ngá é gungsho nghut lhê; yù mù zo keq.\" ga taí uchyang, Yhâng é chángzô pé lé gàm byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hau htâng, Yhang gi, góm lé le, yù mù, jeju hkya-on luî, yhangmoq lé byî ri; yhangmoq banshoq bang gi, haú lé yù shuq akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesuq gi, yhangmoq lé, \"Shî gi, byù myo myô é matú htoq pyâm é, dangshikaq eq sêng é Ngá sui nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngò, nungmoq lé teng za taí kôlé, Ngò, Garai Gasâng é mingdán má, tsibyiq wing asik lé shuq é buinyì a jé jé, tsibyiq wing lé dum shuq râ a nghut lo.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yhangmoq gi, hkya-on mahkôn ralhum ban hkôn jáng, Tsanlun Bùm shut htoq e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuq gi, yhangmoq lé, \"Nungmoq lhunglhâng bang gi, myit lingbat kó râ nghut lhê; hkâsu mù gâ le, 'Haû sau zúng sû lé, Ngò bat sat pyám mù, sau pé gi, lhoq pyo pyâm é hui kó râ nghut lhê.' ga kâ tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nghut kôlhang, Ngò gi, lhoq dui toq é huî htâng má, Galile mau shut, nungmoq é hí má e ló láng râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Haú hkûn, Petruq gi, \"Góbang banshoq myit lingbat kôlhang, ngò gi, myit lingbat râ a nghut.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Haû mù, Yesuq gi, \"Ngò, nàng lé teng za taí lé, hkû-nyí, hkû-myîn yhang jáng, woq í dâm a tûn shimá, nàng, Ngo lé sum dâm he-ngik pyám râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nghut kôlhang, Petruq gi, \"Ngò, Nàng eq rahá shî râ dut kôlhang, Nang lé ngò he-ngik pyám râ a nghut.\" ga zuq zuq taî ri. Góbang banshoq le, haû su ga châng taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yhangmoq gi, Get-samane gâ é jowò má jé ló kômù, Yesuq gi, Yhâng é chángzô pé lé, \"Ngò, kyû ê dûng nyi é u lé, shî má zùng láng keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesuq gi, Yhang eq rahá Petruq, Yakuq, Yohan pé lé, shuî chûng ri. Haú hkûn, Yhang gi, myit gyai a ngón é eq myit wuîhke é hui mù, ");
INSERT INTO atbNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","yhangmoq lé, \"Ngò gi, shî râ í yhang myit yón nyi ri; nungmoq gi, machyâ luî, shí má láng nyî keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesuq gi, haû mai ratsuí zo sô ê mù, myigùng má gop byên to luî, ahkyíng haú lé ge lhoq lhaî pyám byî le gi, Yhâng chyáng mai lhoq lhaî pyám byi râ matú, ");
INSERT INTO atbNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","\"Aba, Âwa ê, Nàng gi, haî le wó dut é Sû nghut lhê. Góm shí lé, Ngá chyáng mai yu pyám byi laq. Nghut kôlhang, Ngò ô nau é dông a nghut, Nàng ô nau é dông sheq nghut sháng gaq.\" ga kyûdûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hau htâng, Yhang gi, Yhâng é chángzô pê chyáng dum taû lo le, yhangmoq yhup myhî to kô é lé lo myang ri. Haû mù, Yhang gi, Petruq lé, \"Simun, nàng yhup ngón nyi lhê lhú? Razup za lháng a wó machya nyì lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gunglaú é a hui sháng gaq, machyâ luî, kyûdûng nyì keq. Haû woi-nyí gi, kâm nyì kôlhang, gungsho gi, wum nyhôm nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesuq gi, radàm dum ê mù, hí lé dûng é dang lé za, ê dung ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yhang dum taû lo le, yhangmoq gi, myoqkuq lai kô é yanmai, yhup myhî to láng kô é lé, lo dum myang ri. Yhangmoq gi, Yhang lé haî taí râ a sé dut byuq akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesuq gi, sum dâm nghû râ lhîng má, yhangmoq chyáng dum taû jé lô mù, yhangmoq lé, \"Nungmoq gi, ahkuî jé shoq yhup ngón nyi ashî kó lhú? Gé bê! Haû ahkyíng gi, jé bê nghut luî, haû Byu Yhangzo gi, yubak dap bâng é loq má ap pyâm é hui râ nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Toq keq! Ló losháng hkoi! Ngo lé ap pyám râ sû gi, jé lé lô bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuq, dáng nyo nyi ashî u lé, haû chángzo raxe í yuq má bo é Yudaq gi, haû hkyangjong agyi pé, tarâ sará pé eq suwún wui chyáng mai nhang kat é bang nghut é, shâm eq dumbáng pé chung tô é byù moq mó eq rahá jé lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesuq lé ap pyâm râ sû gi, yhangmoq lé, \"Ngò bopuq puq é sû gi, haú yuq nghut bê; Yhang lé chyup yû mù, zúng shuî ló keq.\" ga kumlhá byî to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudaq gi, Yesuq chyáng hkyê za ê mù, \"Rabai ê.\" ga taí luî, Yhang lé bopuq puq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Haú hkûn, yhangmoq gi, Yesuq lé chôm zuî zìng mù, chyup yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Haû mù, nàm má yap tô é byù rayuq gi, yhâng é shâm lé she htoq yû mù, hkyangjong mó é dui-nhâng zôshang é nohkyap lé pyoq hkyô kat byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuq gi, yhangmoq lé, \"Nungmoq gi, damyaq rayuq lé chyup é su, Ngo lé chyup râ matú, shâm eq dumbáng pé chûng mù, lé lo akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngò gi, nyí wuî, nungmoq eq rahá nyì luî, noqkuq yhûm má mhoqshit byî nyì kôlhang, nungmoq, Ngo lé a chyup yû kô é nghut lhê. Nghut kôlhang, Chyúmdang pé gi, dik ra râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Haú hkûn, haû chángzô pé gi, Yesuq lé tô pyâm to kôluî, hpang byo byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Buhîng za wut é zorâm rayuq gi, Yesuq htâng cháng wún ri. Yhangmoq gi, haú yuq lé, wó kyaq zui kô é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yhang gi, buhîng lé hkyut hkyô pyâm to mù, gùngchîn hpang ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yhangmoq gi, Yesuq lé, hkyangjong mó chyáng shuî e akô; haû hkyangjong agyi pé lhunglhâng bang, suwún wuî eq tarâ sará pé le, lé zup zîng bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petruq gi, hkyangjong mó é yhumwàng hkaû má châng jé wâng shoq, we we mai Yesuq htâng châng tô ri. Yhang gi, haú má, zúng bang eq rahá, myihkyóm yâm má gyoq gang zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Haû hkyangjong agyi pé eq Yudaq byìn tú wapdoq gón gi, Yesuq lé sat râ saksé hô kôlhang, haî le a myàng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Byù myo myo gi, a têng é saksé hkám kôlhang, yhangmoq é dang gi, a tsûng lhum kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hau htâng, ra-am gi, toq yap mù, a têng é saksé hkám kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"Yhang gi, 'Byu loq èq saî é noqkuq yhûm shî lé, Ngò hpyoq hpyi pyám mù, sum nyí gyoro má, byu loq èq a saî é, gotû ralhum dum saí râ nghut lhê.' ga taî é lé, ngamoq wó gyô ri.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nghut kôlhang, yhangmoq é saksé gi, a tsûng lhum kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hau htâng má, hkyangjong mó gi, yhangmoq é hí má toq yap mù, \"Nàng, haî le a tû taí luq? Shí bang, Nang lé mara hun nyi é saksé gi, hká dông nghut lhê lhú?\" ga luî, Yesuq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nghut kôlhang, Yesuq gi, jit le a ga nyi tô ri. Haû mù, hkyangjong mó gi, Yesuq lé, \"Nàng gi, hkungsô wó Su é yhangzo, Hkrisduq nghut lhê lhú?\" ga dum myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Haú hkûn, Yesuq gi, \"Nghut lhê; haû ngò Byu Yhangzo gi, a-tsam bo dik Su é loqyo hkyam má zung tô é lé le, mhuthtui ji mù, mauhkûng mai lé lo é lé le, nungmoq myàng kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Haú hkûn, hkyangjong mó gi, yhâng é bu lé lâng cheq pyám mù, \"Nga-nhúng, hai saksé râ ashî lhú? ");
INSERT INTO atbNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yhang, Garai Gasang lé rhoî dang taî é lé nungmoq wó gyo bê nghut lhê. Nungmoq hkâsu wó myit akô lhú?\" ga myî ri; yhangmoq banshoq bang gi, shî gíng sû nghut ri ga, chôm myit huî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Haû mù, ra-am gi, Yhang lé sôkan byé gyun é eq, myoq má nghop pyám byi luî, loqtsup èq htui byî lhê kut mù, \"Nang lé ó yuq htuî é, myiqhtoi htoî wú aq.\" ga taî akô. Haû zúng bang gi, Yhang lé shuî yù mù, nhuq bat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petruq gi, wàng hkaû má nyi tô é u lé, haû hkyangjong mó é dui-nhâng zoshâng myhí rayuq jé lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Haú yuq gi, Petruq gyoq gang nyi é lé myàng jáng, yhang lé rago wú mù, \"Nàng le, Nazaret wà byù Yesuq eq rahá nyì sû nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nghut kôlhang, yhang gi, \"Nàng taî é hkyô lé, ngò, sé le a sé, gyo le a sê gyo.\" ga he pyám luî, wâng hkúmdong shut htoq e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dui-nhâng zoshâng myhí haû gi, Petruq lé, haú má dum myàng jáng, awui ayàm má yap tô é bang lé, \"Shí yuq le, haû hpúng má lom é sû rayuq nghut ri.\" ga dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petruq gi, radàm dum he pyâm ri; hau htâng razup zo má, haû nàm má yap tô é bang gi, Petruq lé, \"Nàng gi, Galile byù rayuq nghut é yanmai, haú hpúng mâ é byù rayuq hkyak nghut lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Haú hkûn, yhang gi, yhânggùng yhang nhing luî, \"Haû nungmoq taî é byù lé, ngò a sé.\" ga dakam ri. ");
INSERT INTO atbNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Haú u yhang, woq radàm dum tun kat bê nghut ri. Haû mù, Petruq gi, \"Woq í dâm a tûn shimá, nàng, Ngo lé sum dâm he-ngik pyám râ nghut lhê.\" ga, Yesuq, yhang lé taî é dang lé, myit bûn kat mù, wum kat ngau ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Haû napkyó noq za má, hkyangjong agyi pé gi, suwún wuî, tarâ sará pé, Yudaq byìn tú wapdoq gón bang eq rahá kut, chôm bóng yû kômù, Yesuq lé tuî yû luî, shuî htoq ê kômù, mauzau Pilat chyáng ê ap byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat gi, Yesuq lé, \"Nàng gi, Yudaq byu pê é hkohkâm nghut lhê lhú?\" ga myi jáng, Yesuq gi, \"Nàng taî é eq rajung za nghut lhê.\" ga, tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Haû hkyangjong agyi pé gi, Yhang lé mara gyai myo shoq chôm hun akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Haû mù, Pilat gi, Yesuq lé, \"Wú aq, yhangmoq, nàng lé mara haû myhó hun nyi le, nàng, haî le a tû taí lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nghut kôlhang, Yesuq gi, haî le a tû taí kut jáng, Pilat gi, maú byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Haû Lhoqlhai Poî u lé, mingbyû wuì dûng é htóng byû rayuq yuq lé, mauzau mai lhaq lhoq htoq byi byi kut é htûng joq ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Haú hkûn, Barabaq gâ é byù rayuq gi, gumlau gabyông é hkûn, byù sat é gumlau bang eq rahá, htóng gyó tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Byù hpûng mó gi, doq lé lô mù, mauzau Pilat lé, yhang lhaq kut é eq rajung za, yhangmoq lé kut byi râ matú, dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Haû mù, yhang gi, \"Yudaq byu pê é hkohkâm lé nhang htoq kat byi râ lé, nungmoq ô nau akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilat, haû su ga myî é gi, haû hkyangjong agyi pé, Yesuq lé manôn kôluî, yhâng chyáng lé ap byi kô é hkyô lé sê é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nghut kôlhang, haû hkyangjong agyi pé gi, Barabaq lé sheq nhâng byi râ matú, Pilat chyáng dung kó sháng gaq ga, haû byù moq mó lé i-myit lhoq toq byî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat gi, \"Haû jáng, nungmoq mai Yudaq byu pê é hkohkâm ga sû yuq lé, ngò hkâsu kut râ lhú?\" ga yhangmoq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Haú hkûn, yhangmoq gi, \"Yhang lé tapzîng má jén sat pyám aq.\" ga chôm garu akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Haû jáng, Pilat gi, \"Haî mù luî lhú? Yhang haî kut shut bê lhú?\" ga dum myi jáng, yhangmoq gi, htê mó èq, \"Yhang lé tapzîng má jén sat pyám aq.\" ga je riyhang garû lo bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat gi, haû byù moq mó lé nhik dik nhâng nau é yanmai, Barabaq lé gi, nhang kat byi mù, Yesuq lé gi, nhuq bat nhâng mù, tapzîng má jén sat pyám râ matú, ap byî kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gyezô pé gi, Yesuq lé, Pretori yhumwàng (mauzau hpô é yhumwàng) mó hkaû má shuî wang ló kômù, gyedap gón lé ji tsîng yu akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hau htâng, yhangmoq gi, Yesuq lé buhîng nè radung hut byi mù, zujanmaú saî yù kôluî, Yhâng é ulhum má tsung byî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hau htâng, yhangmoq gi, \"Yudaq byu pê é hkohkâm hpó ê! Chyung hîng xê hing nyì sháng gaq ô!\" ga wut garû akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hau htoq agó, yhangmoq gi, Yhâng é ulhum má dumbáng èq adàm dàm bat kômù, sôkan byé gyun luî, Yhâng hí má hkyihput htuq mù, paî mhaû akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yhangmoq gi, Yhang lé rhoî jihkyoî ban kut yû kôjáng, Yhang wut tô é buhîng nè lé hkyut yû kômù, Yhâng é mebu lé dum hut byi luî, tapzîng má jén sat pyám râ matú, Yhang lé shuî htoq e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Alesander eq Ruhpu nhiktang é yhângwa, Kuruni myuq byû nghut é Simun ga sû gi, yosô wà mai lò mù, haú jowò mai laî ló ri. Haû hkûn, gyezô pé gi, yhang lé, tapzîng waq nhang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yhangmoq gi, Yesuq lé, Golgahta gâ é jowò má shuî e akô (Golgahta gâ é gi, ugyap joq é jowò lé gâ é nghut ri). ");
INSERT INTO atbNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hau htâng, yhangmoq gi, Yhang lé, mura eq nyhô tô é tsibyiq wing huq akô; nghut kôlhang, Yhang gi, a lhom shuq byi nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hau htâng má, yhangmoq gi, Yhang lé tapzîng má jén tap to kôluî, Yhâng é mebu pé lé, hkyîn shosé shê mù, âng é dông gam yu pyám byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yhangmoq, Yesuq lé tapzîng má jén tap pyâm é hkûn gi, napkyó gau hkyíng nghut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hau htoq agó, Yhang lé mara hun é dông kâ tap to kô é gi, \"YUDAQ BYU PÊ É HKOHKÂM\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yhangmoq gi, damyaq í yuq lé le, Yhâng é loqyo hkyam shut rayuq, loqpaî hkyam shut rayuq kut, tapzîng htoq má jén tap tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Haû gi, \"Yhang gi, yubak dap bâng chyáng nghap lhôm é hui bê nghut ri.\" gâ é Chyúmdang lé lhoq dik é nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hkyô sô laî ló é bang gi, nyhap é dông u-ngut ngut mù, taí kô é gi, \"Noqkuq yhûm lé hpyoq pyám luî, sum nyí gyoro má dum wó saî lhê ga Sû ê! ");
INSERT INTO atbNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Náng gùng nàng hkyi yù luî, tapzîng mai gyó lò wú aq mhaî!\" ga akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Haû eq rajung za, hkyangjong agyi pé eq tarâ sará pé le, yhangmoq hkaû má, \"Shí yuq gi, góbang lé hkyi yù sû nghut kôlhang, Yhânggùng yhang gi, a wó hkyi yù nghut ri myhi-nhung! ");
INSERT INTO atbNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nga-nhúng wó myâng mù, lumjíng râ matú, shî, Israelaq byu pê é hkohkâm, Hkrisduq gi, tapzîng mai gyó lo wú sháng gaq.\" ga, Yhang lé rhoî dang taî akô. Yhang eq rahá tapzîng má jén tap to huî é su nhik le, Yhang lé rhoî dang taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nyí-káng raxe í hkyíng mai myinhtâng sum hkyíng jé shoq, ramau gón mauchut tuq dut byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Myinhtâng sum hkyíng jé é hkûn, Yesuq gi, \"Eloi, Eloi, lama sabakhtani.\" ga, htê mó èq garû kat ri. Haú é lichyúm gi, \"Ngá Garai ê, Ngá Garai ê, Nàng, haî mù, Ngo lé tô pyâm tô lhê lhú?\" gâ é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Haú nâm má yap tô é bang ra-am gi, haú lé wó gyo kôjáng, \"Gyô wú keq. Yhang gi, myiqhtoi Eliyaq lé wut nyi ri.\" ga, taî akô. ");
INSERT INTO atbNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Haú hkûn, byù rayuq gi, din e ló mù, wuìmaù lé tsibyiq wing chyîn má jum yù luî, jàm-yang má tuî tap mù, Yesuq shuq sháng ga yhun byi luî, \"Eliyaq gi, lé lô mù, Yhang lé lé lhoq hkyô yù abe, nga-nhúng chôm láng wú sháng.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesuq gi, htê mó èq garû kat luî, kâng byit byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Noqkuq yhûm mâ é pán-gyang gi, ahtoq mai a-ô í hkyam byáng dut byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesuq é hí má yap tô é shô up gyezau hpó gi, Yesuq é garu htê lé wó gyo mù, Yhang hkâsu kut shi é lé myàng jáng, \"Shí yuq gi, gè gè yhang, Garai Gasâng é Yhangzo nghut ri-nhung!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Myiwe wuì ra-am gi, we we mai wú nyi bum akô. Haú bang má, Magadalaq wà mâ é Mariq, Yakuq tiq sû yuq eq Yose nhiktang é yhângnu Mariq eq Salome pé le bo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Haú bang sum yuq gi, Galile mau má, Yesuq htâng cháng mù, Yhâng râ é hkyô pé lé châng kut byî é bang nghut akô. Yesuq eq rahá, Yerusalem wà mó má doq lé lo é myiwe wuì, góbang myo myo le haú má nyi tô bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Haú nyí gi, Hên Lajang Buinyì (Bánno buinyi é hí nyí) nghut ri. Haû mù, myinhtâng jé lô jáng, ");
INSERT INTO atbNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yudaq uphkâng hpúng má bo é, aróng wó é, Garai Gasâng é mingdán lé láng nyi é sû, Aramahti wà byù Yosep gi, myit wum lhoq kîng yù mù, Pilat chyáng wàng luî, Yesuq é gungsôm lé ê dûng ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat gi, Yesuq shî bê gâ é hkyô lé wó gyo jáng, maú byuq ri; haû mù, yhang gi, shô up gyezau lé wut yù mù, Yesuq shî teng bê lhú ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Shî teng bê hkyô lé, shô up gyezaû chyáng mai wó sê yù jáng, Pilat gi, Yesuq é gungsôm lé yù râ ahkáng, Yosep lé byi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Haû mù, Yosep gi, pán yúng lé wui yù luî, gungsôm lé yu hkyó mù, htup yup luî, luqgok lé kyûng tô é lup hkaû má ê kat tô ri. Hau htâng, yhang gi, luphkum má, luqlông èq lhêng chî pyâm tô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magadalaq wà mâ é Mariq eq Yose é yhângnu Mariq gi, Yesuq lé, hkâmá lheq tô é lé, ê myang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bánno buinyì lai jáng, Magadalaq wà mâ é Mariq, Yakuq é yhângnu Mariq eq Salome pé gi, Yesuq é gùng má, ê but byi râ matú namngón jung ê wui akô. ");
INSERT INTO atbNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bánno buinyì htang napkyó buì htoq lo é hkûn yhang, yhangmoq gi, lup shut e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yhangmoq gi, \"Luphkum mâ é luqgok lé, ó yuq chyûn lhêng pyám byi râ lhú?\" ga, rayuq eq rayuq taî lhum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nghut kôlhang, yhangmoq tu wú kat kô é hkûn, luqlong haû gi, lhoq lhêng to láng é lé, myàng akô nghut ri; luqlong haû gi, gyai kô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yhangmoq gi, lup hkaû má wang ê kô é hkûn, hpyu é buhîng wut é zorâm rayuq, loqyo hkyam má zung tô é lé, myàng kôjáng, gyuq dan bum akô. ");
INSERT INTO atbNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Haú hkûn, haú yuq gi, \"Hkâgyuq dàn kó! Nungmoq gi, haû tapzîng má jén sat huî é, Nazaret wà byù Yesuq lé ho akô, a nghut lhú? Yhang dui toq ló bê! Yhang gi, shí má a nyì lo. Yhang lé, lheq tô é jowò lé wú wú keq. ");
INSERT INTO atbNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ahkuî, nungmoq gi, ló mù, 'Yesuq gi, nungmoq hí má, Galile mau shut so láng râ nghut lhê. Nungmoq lé, Yhang taî tô é eq rajung za, nungmoq gi, Yhang lé haú má ló myâng kó râ nghut lhê.' nghû, Yhâng é chángzô pé eq Petruq lé ló taî kyo keq.\" ga lhom taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Haû mù, myiwe myhí haú bang gi, byòdàn gyuq nán é eq, lup mai hpang htoq ló akô; yhangmoq gi, lûm gyuq byuq kô é yanmai, ó yuq lé lé, haî le a taí kó nghut ri. (Bun zo 9 mai 20 jé shoq gi, chyúmding axau ra-am pé má a bo é nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuq gi, Bánno buinyì htang napsûn lé, Yhang dui toq é htâng, Yhang mai nat gang nyhit du hkat htoq pyám byi bê sû, Magadalaq wà mâ é Mariq lé hí htoq shit ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariq haû gi, ló mù, haû Yesuq eq nyi laî lò bê bang, yón ngau nyì kô é hkûn, haú hkyô lé ló taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yhangmoq gi, Yesuq dum duì bê gâ é hkyô lé le, Yhang lé, Mariq myang é gâ é hkyô lé le, wó gyo kôlhang, a jíng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hau htâng má, Yesuq gi, yosô wà shut htoq e ló nyi é chángzo í yuq lé, gotû gunghkyâng dong htoq shit ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Haú nhik gi, taû lò mù, gotû chángzô pé lé haú hkyô lò shit kyo akô; nghut kôlhang, yhangmoq gi, haû lé le a jíng byi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hau htâng má, Yesuq gi, haû chángzo raxe rayuq baú za zang zô nyì kô é hkûn, yhangmoq chyáng lé htoq shit ri. Yhangmoq chyáng lumjíng myit a bò kô é yanmai le, Yhang dui toq é htâng má, Yhang lé myang é bang taî kyo kô é dang lé, a jíng é za myit htan to kô é yanmai le, Yhang gi, yhangmoq lé tân ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hau htoq agó, Yesuq gi, yhangmoq lé, \"Mingkan jàm shoq htoq ê mù, waxâng zo wuî lhunglháng lé, haû gabú danglù hko kyo keq. ");
INSERT INTO atbNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lumjíng mù, wui-myhup hkâm yu é sû ó yuq nghut kôle, hkyi yu é hui râ nghut lhê. Nghut kôlhang, a lumjíng é sû ó yuq nghut kôle, mara byî é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lumjíng é bang wó kut shit râ kumlhá pé gi, Ngá é myìng lé lang luî, nat gâng pé lé wó hkat htoq kó râ eq laklaí é myíng pé lé dat nyò kó râ nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yhangmoq gi, lhangmuì pé lé le, wó kui zui kó râ nghut lhê; muî shi jung duq lé, shuq kôlhang, haî dut kó râ a nghut. Nò bâng é htoq má, yhangmoq é loq ke byi jáng, nò bang ge byuq kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Haû Yhumsîng Yesuq gi, yhangmoq lé dang ban taî é htâng má, mauhkûng shut shuî toq yu é hui luî, Garai Gasâng é loqyo hkyam má zung to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hau htâng, haû chángzô pé gi, htoq ê mù, jowò hkangmó má mungdang ê hko kyô akô nghut ri; haû Yhumsîng gi, yhangmoq eq rahá nghut nyî mù luî, Yhâng é mungdang têng é hkyô lé tûn shit râ matú, yhangmoq lé, kumlhá pé wó kut é a-tsam byî é nghut ri. Amen.");
INSERT INTO atbNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aróng wó dik é sû Htohpiluq ê, ngamoq chyáng dut laî lò bê hkyô pé lé, sâng-hi mai yhumsing myoq èq yhang, myang é bang eq, mungdang wùn waq é bang mai shap kyô gyó lô mù luî, ");
INSERT INTO atbNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","byù myo myo gi, shikut luî kâ to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Ngò le haú pé banshoq lé awang mai ahpyo hpyot jihkúm nuqguq ho myî yù luî, nàng wó sê yu to bê hkyô pé gi, je lhoq gîng é dut sháng gaq nghû, náng é matú banshoq tok za kâ kat byi râ lé, ngò wó myit ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yuda mau má Herut hkohkâm up é u lé, Abiyaq hkyangjong hpúng má Zahkariq ga sû hkyangjong rayuq nyi ri. Yhang myi gi, Arun amyû mâ é, Elizabet ga sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Haú nhik gi, Yhumsîng Garaî é jep é tarâ eq htûngtarâ banshoq lé, rago za cháng mù, Garai Gasâng é hí má dingmán é su nhik nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nghut kôlhang, Elizabet gi, baùdung dung sû nghut é yanmai, yháng nhâm gi, zo dù a dap kó. Yhangnhik gi, asak ipyat le ko bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ahkuî, Zahkariq gi, dum lhing hkyuq lo é hkyangjong mû lé, yhâng é hpúng eq rahá, Garai Gasâng é hí má lé zui le, ");
INSERT INTO atbNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","haû Yhumsing é noqkuq yhûm ahkaû má namngón hkungga ê wang nyhé râ matú, hká yuq nghut râ lé hkyangjông pê é htûngli eq rajung za byù hkyîn shosé she wú é hkûn, yhâng chyáng âng ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Haû mù yhang namngón hkungga lé nyhê é u lé, shiwa byù banshoq gi, yhumpán má, kyûdûng nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Haú hkûn, Yhumsîng Garaî é maumang lagyo gi, namngón jung nyhê é hkungga gyap é loqyo hkyam má, Zahkariq lé, lé yap shit ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zahkariq gi, maumang lagyo haú lé myàng jáng, dan gyuq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nghut kôlhang, maumang lagyo gi, \"Zahkariq ê, hkâgyuq, náng é kyûdung dang lé Garai Gasang gyo byi bê. Haû mù luî, náng é yhumsîng myhí Elizabet gi, náng é matú yuqzo rayuq bau byi berâ nghut lhê; nàng gi, yhang lé Yohan nghû myhíng byi ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yhang gi, náng é matú gabú hpo eq nguingón é hkyô dut berâ nghut lhê. Yhang lé baû lo é yanmai, byù myo myo le gabú lo bùm berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hkâsu mù gâ le, yhang gi, haû Yhumsîng Garaî é hí má ahko ahkáng wó mù luî, byù mó dut râ sû nghut lhê. Yhang gi, tsibyiq wing eq îhpe lé ge shuq râ sû a nghut; yhâng nû é unghkaû mai yhang, Chyoiyúng Woi-nyí èq byíng nyî râ sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yhang gi, Israelaq yhangzo yhangshû pé myo myo lé, Yhumsîng yhangmoq é Garai Gasâng chyáng lhing lò nhâng râ sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Îwâ pê é myit nhiklhum lé gi, zô wui shut, nyo é a gyo bang lé gi, dingmán bâng é hpaqchyî hkyô shut lhing lò nhâng luî, haû Yhumsîng jé lé râ matú hen tô é byù myû dut nhâng râ matú, Yohan gi, Eliyaq é woi-nyí wum-o wó é eq, Yhumsing é hí má e ló râ nghut lhê.\" ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Haú hkûn, Zahkariq gi, \"Haú hkyô lé ngò hkâsu kut wó sé râ lhú? Ngò le mang byuq bê, ngâ é yhumsîng myhí le asak ipyat ko bê.\" ga luî, maumang lagyo lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maumang lagyo haû gi, \"Ngò gi, Garai Gasang eq rahá nyi é sû Gabrielaq nghut lhê. Nang lé gabú danglù shî taî kyo aq ga luî, Yhang, ngo lé nhang kat é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ahkyíng jé jáng, ngá dang gi, gè gè dut lò râ nghut lhê. Dang shí pé lé nàng a lumjíng é yanmai, mû haû dut lo é buinyì jé shoq, nàng gi, nhut jit byuq râ nghut lhê.\" ga luî, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Haû u, shiwa byu pé gi, Zahkariq noqkuq yhûm ahkaû má haû-í myáng shoq lúng byuq é hkyô lé láng maú nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zahkariq dum htoq lo le, dang a wó nyo byuq mù shiwa byu pé lé loq lik za lik shit nyi ri. Haû mù luî, yhangmoq gi, noqkuq yhûm ahkaû má yhang myoqwup shing-rán rajung jung myàng ang bê lé, wú sê yu akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ahkuî, Zahkariq gi, hkyangjong jong âng é buinyì ngap jáng, yhûm shut dum taû ló byuq bê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hau htâng má, yhâng é yhumsîng myhí Elizabet gi, zogûng dut lò mù luî, hká le a htoq e za lhamó ngo hkyap yhúmhkaû má lúng byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Haú hkûn, yhang gi, \"Byu pê hí má ngò hui zô é hoq hpu hkyô lé, Garai Gasang gi, myàng byi luî, shî su dut nhang é dông mai huî sêng pyám byî é buinyì má, Yhang ge é hkyô lé, ngo lé tûn shit bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ahkuî, Elizabet zogûng dut é lhamó hkyuq hkyap jé jáng, Garai Gasang gi, maumang lagyo Gabrielaq lé Galile mau, Nazaret wà má nyi é, zomyi gyíng rayuq chyáng nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Zomyi hau é myìng gi, Mariq gâ ri; yhang gi, Dawiq amyû mâ é Yosep gá su èq dûng tô é zomyi nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maumang haû gi, Mariq chyáng jé jáng, \"Mariq ê, nguingón nyî sháng gaq; Nàng, hkungsô wó nyi ri; Haû Yhumsîng Garai gi, nàng eq rahá nyi nyi ri ò!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariq gi, dang haû lé gyo sing nán mù, shî su gâ é dang gi, haí jung gá naû é nghut lhê lhú ga luî, myit maú nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Haú hkûn, haû maumang lagyo gi, \"Mariq ê, hkâgyuq, nàng gi, Garai Gasâng é hí má myoqdong wó bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wú aq, nàng zogûng dut lò mù luî, yuqzo rayuq bau râ nghut lhê. Yhâng é myìng lé gi, 'Yesuq' nghû luî, nàng myhíng byi ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yhang gi, hpung bô sû dut râ nghut mù, Myhang htáng htúm Su é Yhangzo gâ é hui râ nghut lhê. Yhumsîng Garai Gasang gi, yhang lé, yhâng é îchyí îwa Dawiq é hkohkâm tanghkuq lé, byi râ nghut mù luî, ");
INSERT INTO atbNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yhang gi, Yakup yhûm lé hkâ-nhám le ru-up nyì râ nghut lhê. Yhâng é mingdán le htum nghu é joq râ a nghut.\" ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Haú hkûn, Mariq gi, \"Ngò gi, zomyi gyíng ru nghut ashî, haû gi, hkâsu wó dut râ lhú?\" ga luî, maumang lagyo lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Haû maumang lagyo gi, \"Chyoiyúng Woi-nyí náng é ahtoq má jé lé mù, Myhang htáng htúm Su é wum-o a-tsam gi, nàng lé shum gum to byi luî, haû baû lò râ Chyoiyúng sû le gi, Garai Gasâng é Yhangzo ga kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hau htoq agó, wú aq, náng é amyû suisho baùdung myhí Elizabet lháng, mang bê le yuqgè zo wun to bê. Ahkuî, zogûng dut é lhamó hkyuq hkyap wàng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hkâsu mù gâ le, Garai Gasang a wó kut é haî le a joq.\" ga luî, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Haú hkûn, Mariq gi, \"Yhumsing é jùnmyhí ngò nghut nyi lhê; náng é dang eq rajung za ngá chyáng dut lò sháng gaq.\" ga tû taî ri. Hau htâng, maumang lagyo gi, yhâng chyáng mai ló byuq bê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hau htâng hkâ-í a myáng má, Mariq gi, Yuda mau bum mau mâ é wà rawà shut hân hân e ló luî, ");
INSERT INTO atbNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zahkariq é yhûm má wàng mù, Elizabet eq huî nyo lhûm ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariq é danghtê lé Elizabet wó gyo jáng, yhâng é unghkaû mâ é zoshâng gi, byam chyû lo ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabet le, Chyoiyúng Woi-nyí byíng to mù luî, Mariq lé htê mó èq taî é gi, \"Myiwe banshoq má, nàng gi, hkungsô wó dik sû nghut ri. Náng é unghkaû mâ é zoshâng le hkungsô wó nyi ri ô! ");
INSERT INTO atbNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ngá Yhumsing é yhângnu ngá chyáng jé lé é jeju gi, hai é yanmai nghut bê lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wú aq, náng danghtê lé wó gyo kat jáng, ngá unghkaû mâ é zoshâng gi, gabú luî byam chyû nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Haû Yhumsîng taî é dang gi, gè gè dik lò râ nghut lhê ga luî, lumjíng é myiwe gi, hkungsô wó nyì ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Haú hkûn, Mariq gi, \"Ngá é i-myit mai haû Yhumsîng lé hkya-on nyi lhê, ");
INSERT INTO atbNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ngá é woi-nyí le, Garai Gasang ngá é hkyi yù Sû má gabú nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngò Yhâng é jùnmyhí myit nyhum nyi é lé, Yhang myàng byi bê nghut ri. Wú aq, ahkuî mai ipyat dedu má, ngo lé gi, hkungsô wó nyî sû, gâ nyì bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","hkâsu mù gâ le, Wum-o Bo Dik é Garai Gasang gi, ngo lé mauhpo mû mó kut byi bê nghut ri, Yhâng é myìng gi, chyoiyúng nyi ri ô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yhang lé gyuq hoq nyî bâng é ahtoq má, Yhang shogyo nhikmyîn é hkyô gi, pyat bán hkangmó jé shoq hkâ-nhám le joq nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yhâng é wum-o bo é loq èq mauhpo mû mó pé lé tûn shit bê. Yhumsîng myit é hkyô má nghutbûn nyi é bang lé, Yhang lhoq pyo pyám bê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Zaugun suwún wuî lé gi, zau zûng tanghkuq mai lhoq hkyô pyám mù, i-myit nyhûm bang lé gi, lhoq myhâng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Zòmut hui bang lé gi, ge é zoshuq gyi shoq byi tso mù, sutzè wó bang lé gi, akôm nhang kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nga-nhûng é îchyí îwâ pé lé taî tô é dang eq rajung za, Abraham eq yhangzo yhangshu pé lé, hkâ-nhám le shogyo nhikmyîn nyì râ gâ e lé myit bûn nyi é yanmai, Yhâng é dui-nhâng zoshâng Israelaq byu pé lé hku baú nyi ri.\" ga luî, taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariq gi, Elizabet chyáng lhamó sum hkyap kô nyì mù luî, yhûm shut dum taû lò byuq bê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hau htâng, Elizabet gi, zoshâng bau râ buinyì jé mù, yuqgè zo bau bê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yhang lé haû-í kô é jeju Yhumsîng tûn shit é hkyô lé, yhâng é yhumkyo buinùm wuì eq mung moq gumang wuì wó gyo kojáng, yhang eq rahá gabú nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ahkuî shit nyí jé jáng, yhangmoq gi, zoshâng haû lé ahpyo-kuq hpyit byi râ matú lé kôluî, yhâng wâ é myìng eq rajung za, Zahkariq ga myhíng byi râ dâ akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nghut kôlhang, yhâng nu gi, \"A nghut, Yohan nghû sheq myhíng râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yhangmoq gi, \"Náng é amyû suisho má le, haû su gâ é myìng rayuq le a bo wú shi.\" ga luî, yhang lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Haú hkûn, zoshâng haû lé hkâsu nghû myhíng nau lhê laq ga, yhâng wa lé loq lik lik shit mù myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zahkariq gi, kâ jung longpá dûng yù mù, \"Yhâng é myìng gi, Yohan nghut lhê.\" ga kâ shit ri. Haû mù, lhunglhâng bang gi, maú byuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Haú hkûn jáng, Zahkariq gi, nhut hkum bóng lô mù, dang wó nyô lui, Garai Gasang lé hkya-ôn nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Haû su dut é hkyô lé, wó gyô é awui ayàm lhînghkyuq mâ é lhunglhâng bang gi, gyuq maú byuq bùm kômù, Yuda mau bum mau ramau gón taî pyo ló bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wó gyô é lhunglhâng bang gi, haú hkyô lé yhumsing é i-myit unghkaû má kat to mù, \"Zoshâng shî gi, hkâsu dut lò râ sû nghut lhê lhú?\" ga myit wú nyi akô. Haî mù gâ le, haû Yhumsing é loq gi, yhang eq rahá nghut nyi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Haú hkûn, zôshang é yhângwa Zahkariq gi, Chyoiyúng Woi-nyí byíng lô mù, myiqhtoi dang dong taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Haû Yhumsîng, Israelaq é Garai Gasang lé hkya-on sháng ô! Haî mù gâ le, Yhang gi, Yhâng é amyû lé, lé kûm wú mù luî, lé hkyi yù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Garai Gasang gi, Yhâng é dui-nhâng zoshâng, Dawiq é amyû mai nga-nhûng é matú wum-o bo é hkyi yu é hkyuî lé, yuq htoq lô nhâng bê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Shí hkyô gi, a-nham pyat mai yhâng é chyoiyúng myiqhtoî pê é nhut mai taî tô é eq rajung za nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Haû hkyuî gi, nga-nhúng lé nga-nhûng é gye pê chyáng mai le, a nguì a naù bang banshoq é loq mai le, hkyi yù râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Îwa Garai gi, nga-nhûng é îchyí îwa pé lé shogyo nhikmyin hkyô lé tûn shit râ matú, Yhang byî tô é chyoiyúng dangshikaq lé a tô-myhí nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Haû gi, nga-nhûng é chyiké Abraham lé byi tô é danggidiq nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Nga-nhúng lé gye pê loq mai hkyi yù râ eq, nga-nhúng asak dui tô é buinyì banshoq má, Yhâng é hí má a gyuq a kyum é za, chyoiyúng é eq dingmán é hkyô mai, Yhang lé wó dojaú nyî nhâng râ matú, Yhang jé lé é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngá zo ê, nàng gi, Yhumsing é hí má, e ló mù luî, Yhâng é hkyô lé hen lajang byi râ sû nghut é yanmai, nang lé Myhang htáng htúm Su é myiqhtoi ga kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nàng gi, Garai Gasâng é byu pé lé, yhangmoq é yubak mara hkyut pyám byî é dong, hkyi yu é hui râ hkyô lé taî kyo râ sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Haî mù gâ le, Garai Gasâng é shogyo nhikmyin é yanmai, napsûn buì gi, mauhkûng mai nga-nhûng chyáng htoq lé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yhang gi, mauchut hkaû eq shî wup hkaû má lúng to bang lé builoq su duqbó byi râ eq, nga-nhúng lé nguingón simsaq é hkyô shut shuî e ló râ sû nghut lhê.\" ga ri. ");
INSERT INTO atbNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zoshâng haû gi, kô lò mù, woi-nyí wum-o bo lò luî, Israelaq byu pê chyáng htoq shit lo é buinyì jé shoq, yoso pé má nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Buinyì haú pé má, Romaq hkoséng ming banshoq mâ é byù lhunglhâng bang gi, myìng jihpán kat râ matú, hkoséng Kehtaq Augustuq chyáng mai mungdang htoq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jihpán haû lé sâng-hi dàm guq hi é gi, Kuireni ga sû Suriq mau má mauzau kut nyi é hkûn nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Haú hkûn, byù du jup gi, myìng jihpán kat râ matú, ó le ô é wà shut ló bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Haû mù, Yosep le Dawiq é awut ashín nghut é yanmai, Galile mau Nazaret wà mai, Yuda mau mâ é Betlehem gâ é Dawiq é wà shut, ");
INSERT INTO atbNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yhang dûng tô é myiwe Mariq eq rahá myìng kat lhóm râ matú jé doq ló akô; Mariq kúm gi, gungloq laî to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Haû Betlehem má nyi tô ashî le, Mariq gi, zo hkû râ buinyì jé mù, zomún yuqzo lé bau bê. ");
INSERT INTO atbNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yhang gi, zoshâng haû lé panchoq èq htup mù no tso langhkang má lheq tô ri; haî mù gâ le, bíng yhûm má yhangmoq nyì râ jowò a joq lo é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ahkuî, haú ginwáng mâ é sau zúng zo bang gi, sau zúng jang má yhangmoq é sau hpúng lé, myín lé zúng nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Haú hkûn, Yhumsîng é maumang lagyo gi, yhangmoq é hí má lé htoq yap shit to mù, Yhumsing é hpungwup shingkang gi, awui ayàm má duqbang lò luî, yhangmoq gyai gyuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Maumang lagyo gi, \"Hkâgyuq kó, byù lhunglhâng bâng é matú, gyai yhang gabú é danglù, ngò nungmoq chyáng wun lé lo lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hkû-nyí lhê buinyì má, Hkrisduq nghu é Yhumsîng nghut é hkyi yù Sû gi, Dawiq é wà má nungmoq é matú hku to bê. ");
INSERT INTO atbNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nungmoq é matú kumlhá gi, zoshâng nyheqnú rayuq panchoq èq htup mù, no tso langhkang má lheq to láng ra nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Haú hkûn jáng yhang, mauhkûng bang rajùm rayò htoq lô mù, maumang lagyo haû eq rahá Garai Gasang lé hkya-ôn é dang gi, ");
INSERT INTO atbNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"Htoq tsáng myhâng má, Garai Gasang gi, hpungwup shingkang bo nyì sháng gaq ô! Myigùng htoq má le, Yhang ô nau é byu pé má, nguingón é gi, hkâ-nhám le joq nyì sháng gaq ô!\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Maumang lagyô pé, yhangmoq chyáng mai, mauhkûng shut dum ló byuq jáng, sau zúng bang gi, \"Sà! Betlehem wà mó má jé shoq yhang, nga-nhúng ê mù, ahkuî za Yhumsîng nga-nhúng lé lé shit kyô laî ló bê hkyô lé ê gôn wú sháng.\" ga luî, rayuq eq rayuq taí lhûm akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hau htâng, yhangmoq gi, hân hân ê luî, Mariq eq Yosep lé le, no tso langhkang má lheq tô é zoshâng nyheqnú lé le, ê myàng akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Zoshâng haû lé, yhangmoq myàng kôjáng, zoshâng haû eq séng luî yhangmoq lé, lé taî kyô é dang lé, taî pyô kat bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wó gyô é bang banshoq gi, haû sau zúng bang taî kyô é dang lé, maú byuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariq kúm gi, dut lo é hkyô pé eq wó gyô é dang banshoq lé unghkaû má matsîng yù mù luî, nik nik myit wú nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sau zúng bang gi, yhangmoq lé maumang lagyo taî kyô kat é dang eq rajung za, wó gyô yù, wó myang yu é hkyô pé banshoq é yanmai, Garai Gasang lé hkya-on kungtôn uchyang dum taû ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Zoshâng haû, shit nyí jé mù ahpyo-kuq hpyit byi râ buinyí má, yhang unghkaû má a lúng shi mai maumang lagyo myhîng tô é myìng eq rajung za, yhang lé, \"Yesuq\" ga luî, myhíng byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosheq é tarâ eq rajung za, yhangmoq é lhoq san lhoq sêng é buinyì byíng jáng, Yhumsing é tarâ má, \"Zomún yuqzo hkangmó gi, haû Yhumsing é hí má chyoiyúng sû wó nghû râ matú, Yhumsing chyáng ê ap byi râ lhê.\" gâ é eq, ");
INSERT INTO atbNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"Hpûngkyui razúm, haû a nghut jáng, nghoqmyhû zo í du,\" hkungga byi râ lhê ga kâ tô é eq rajung za, ");
INSERT INTO atbNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mariq eq Yosep gi, zoshâng haû lé shui mù Yerusalem wà mó shut ê akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Haú hkûn, Simeon gâ é mangzo rayuq, Yerusalem wà mó má nyi ri. Haú yuq gi, dingmán é eq tarâ cháng sû nghut mù, Israelaq lé nhik lhoq tíng râ ahkyíng lé láng nyî sû nghut ri; haû Chyoiyúng Woi-nyí le, yhâng é ahtoq má nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yhang gi, haû Yhumsîng Hkrisduq lé a myang é za, shî râ a nghut, ga Chyoiyúng Woi-nyí èq tûn shit tô é hui sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yhang gi, Chyoiyúng Woi-nyí èq shui mù, noqkuq yhúmhkaû má ê jé nyi tô é hkûn lé, Mariq eq Yosep gi, zoshâng Yesuq lé htûng tarâ eq rajung za kut byi râ matú, noqkuq yhúmhkaû má shuî wang ló kôjáng, ");
INSERT INTO atbNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon gi, zoshâng lé loq èq lhom bún yû mù, Garai Gasang lé hkya-ôn é dang gi, ");
INSERT INTO atbNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"Yhumsîng ê, náng é danggidiq gi, dik bê nghut ri; hkû-nyí náng é jùn ngò gi, nguingón é èq wó shi ló berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Haî mù gâ le, byù lhunglhâng bâng é matú, nàng lajang tô é hkyi yù hkyô lé, ngá myoq èq yhang wó myâng bê. ");
INSERT INTO atbNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Haû gi, byù myû chângjup wó myâng râ matú, nàng lajang to byî é nghut mù, ");
INSERT INTO atbNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","tûngbaù pé lé, tengmán hkyô má buì su duqbó mù hpông shit râ matú le, náng é amyû Israelaq é hpungwup shingkâng matú le nghut nyi ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yhângnu eq yhângwâ nhik gi, zoshâng Yesuq é hkyô lé Simeon taî é yanmai, maú byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon gi, yhangmoq lé shimân byi mù, Yhâng nu Mariq lé, \"Wú aq, zoshâng shî gi, Israelaq ming mâ é byù myo myô é matú lingbat jowò eq myo myô é matú kô lò myhang lò râ hkyô le, byù myo myo taî he pyám râ kumlhá matú le, hkyin tô é hui sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Haû mù, byù myo myô é unghkaû má, myit mi-myit lé lhoq htoq shit râ nghut lhê. Náng é myit nhiklhum má, shâm chûn èq htaû kyâng kat é su gâ é lé, nàng hui zo râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ashe amyû mâ é Hpanuelaq é yhangzo, Annaq gâ é myiqhtoi myhí rayuq nyi ri; yhang gi, ipyat gyai ko bê. Yhang gi, zomyî pyat mai, yhanglâng eq nyhit zân za nyì luî, shit xe myi zân jé shoq chuimó mó nyi to sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Myiwe haû gi, noqkuq yhûm mai a htoq ê za, nyí myín a ga noqkuq dojaú nyî mù, zoshuq gám luî kyûdûng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon dang ban taí jáng, Annaq gi, hui lé lô mù, Garai Gasâng jeju lé hkya-on luî, Yerusalem wà mó lé Garai Gasang hkyi yù râ gâ é lé, myit lum to bang lhunglháng lé, zoshâng hau é hkyô taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep eq Mariq gi, kut râ pé lé haû Yhumsing é tarâ joq é dông ban kut jáng, Galile mau mâ é yhangmoq wà Nazaret shut dum taû ló bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Zoshâng haû gi, kô lò mù, wum-o bò lo é eq, hpaqchyî byéng-yá le byíng nyi ri. Garai Gasâng jeju le, Yhâng é ahtoq má joq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yhângnu yhângwâ nhik gi, Lhoqlhai Poî jé hkangmó, zàn wuì Yerusalem wà mó má ê ê kut akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuq raxe í zân jé jáng, poî haû, ê bo lòm ra htûngli joq é eq rajung za, yhangme wuî yhanghpe wuî doq ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Haû poî buinyì lai luî, dum taû lo é hkûn, zoshâng Yesuq gi, Yerusalem wà mó má nyi gyó tô ri; nghut kôlhang, yhângnu yhângwâ nhik gi, a sé kó. ");
INSERT INTO atbNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yesuq lé rahá lo é luzúm wui chyáng bò râ su ngàm kômù luî, Yosep eq Mariq gi, ra-nyí buigyùm chap sô ló bê htâng má, mung moq wuì eq, sê lhûm é buinùm ji-myi wui chyáng Yhang lé châng ho akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yhangnhik gi, Yesuq lé a myàng kôjáng, Yhang lé châng hô uchyang, Yerusalem wà mó má dum taû jé e ló bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ahkuî, sum nyí nghû râ nyí sheq, noqkuq yhúmhkaû má, tarâ sará pê é gung gûng má zùng to mù, yhangmoq é dang lé gyo yù luî, dum taû myi myi kut nyi é lé, yhangnhik ê myàng akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yhâng é dang wó gyô é bang banshoq gi, Yhâng é u-nuq nyau é hkyô lé le, Yhang tû taî é dang lé le, maú nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yhang lé myàng jáng, yhangnhik maú byuq kômù luî, yhângnu gi, \"Ngá zo ê, haî mù luî ngá-nhik lé isu kut lhê lhú? Wú aq, náng wa eq ngá-nhik gi, myit myo myit chiq é èq, nàng lé jaq châng ho pyám bê.\" ga luî, Yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yhang gi, \"Haî mù luî, ngo lé châng ho akô lhú? mauhkûng mâ é ngá Wâ é yhûm má ngò nyì râ lhê le gi, nungnhik a sé kó lhú?\" ga luî, yhangnhik lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nghut kôlhang, yhangnhik gi, Yesuq taî é dang lichyúm lé, a sê gyo kó. ");
INSERT INTO atbNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesuq kúm gi, yhangnhik eq rahá Nazaret wà shut taû jé gyó ló luî, yhangnhik nyo é dang lé gyo mù nyì tô ri. Yhângnu Mariq gi, dut laî lò bê hkyô pé banshoq lé, yhâng é myit nhiklhum má matsîng tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuq gi, hpaqchyî byéng-yá kûng zet lo é eq, gunghkyâng kô myhang lò mù, Garai Gasâng é hí má le, byu hí má le, myoqdong wó lo nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Romaq hkoséng Kehtaq Tiberuq gi, hkó zung é raxe ngo zân nghut é hkûn, Yuda mau má Pontu Pilat gi, mauzau ayá má; Galile mau má, Herut gi, mauzau ayá má; Ituri eq Trakuni mau má, Herut yhanggu Hpilip gi, mauzau ayá má; Abili mau má, Lusanu gi, mauzau ayá má; ");
INSERT INTO atbNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anna eq Kayahpaq gi, hkyangjong mó mû má, kut nyi akô. Haú hkûn, Garai Gasâng é mungdang gi, yoso má nyi tô é, Zahkariq é yhangzo Yohan chyáng jé lé ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Haû mù, yhang gi, Yodan làng yàm jowò hkangmó má, sô jón wún luî, yubak mara hkyut pyám byî é hui râ matú myit lhîng mù, wui-myhup hkâm yù râ hkyô lé, hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Haû gi, myiqhtoi Esai-aq laiká má, \"Haû yoso má, byù rayuq garû taî é htê gi, 'Haû Yhumsing é matú, hkyô hen to keq, Yhâng é matú hkyô lhoq nyhang to keq; ");
INSERT INTO atbNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","wuìhkung langhkop hkangmó lé lhoq pyíng ra râ nghut lhê; bùm eq wingkáng hkangmó lé hpyit pyám ra râ nghut lhê; agoí aguq é hkyô hkat hkangmó lé lhoq nyhâng ra râ nghut lhê; ahkung ahkop dut é hkyô hkat hkangmó lé lhoq rhá ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Haú hkûn, byù banshoq gi, Garai Gasâng é hkyi yù hkyô lé myàng râ nghut lhê.'\" ga luî, kâ tô é eq rajung za nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Shiwa byù rajùm rayò gi, Yohan é loq má wui-myhup hkâm yù râ ga luî htoq lé lô kôjáng, Yohan taî é gi, \"Duq htan é lhangmuì amyû pé ê, jé lô râ yubak dam mai wó hpang lut kó sháng gaq ga, nungmoq lé ó yuq taî pûn é lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Myit lhîng hkyô eq gingdán é ashi zui keq. 'Nga-nhúng gi, Abraham é yhangzo yhangshû pé nghut lhê.' nghû luî, yhumsing é i-myit unghkaû má hkâtaí kó. Hkâsu mù gâ le, ngò, nungmoq lé taî kyo kôlé, Garai Gasang gi, luqgok shí pé mai, Abraham é matú yhangzô pé wó hpan htoq kat lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ahkuî lháng, Garai Gasang gi, Yhâng é wazung lé haû sikgâm wang pé má tô to bê nghut ri; haû mù, ge é ashi a zui é agàm hkangmó lé gi, htuq lhêng pyám mù, myi má dú kat pyám râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Haú hkûn, shiwa byu pé gi, \"Haû nghut le gi, ngamoq hkâsu kut le gè râ lhú?\" ga luî, yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yhang gi, \"Bu í dung wó sû gi, bu a wó sû lé, gàm byi sháng gaq; zo shuq wó sû le, a wó sû lé, gàm byi sháng gaq.\" ga luî, yhangmoq lé tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kang guq bang le, wui-myhup hkâm yù râ ga lé lô mù, \"Sará ê, ngamoq gi, hkâsu kut le ge râ lhú?\" ga luî, yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yhang gi, \"Nungmoq hkyui yù râ masat tô é htoq lai shoq hkâyû kó.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gyezô pé ra-am le, \"Ngamoq gi, hkâsu kut le gè râ lhú?\" ga luî, yhang lé lé myî akô. Yohan gi, \"Ó lé le hkâkyuq zo ko; a tara é dông mara le hkâhûn kó; nungmoq wó e ahpaû èq gé bûn nyì keq.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Shiwa byu pé kúm gi, Hkrisduq lé myit láng nyi tô é bang nghut é yanmai, Yohan lé haú yuq nghut lhê laq ga yhumsing é i-myit unghkaû má myit wú nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Haú hkûn, banshoq bang lé Yohan taî é gi, \"Ngò gi, nungmoq lé, wui èq za wui-myhup hkám byî lhê; nghut kôlhang, ngá htoq má wum-o a-tsam je bo é sû rayuq jé lé lô râ nghut lhê. Ngò gi, yhâng é hkyî-tsung tui lé hpyî râ lháng a gingdán; Yhang gi, Chyoiyúng Woi-nyí má le, myi má le, nungmoq lé wui-myhup hkám byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yhang gi, loq má byò chung to mû, guq chyarâng mâ é guq bùm lé hik sân pyám luî, já é guq cham lé gi, guqchyî má tsing kat to mù, guqsôm lé kúm gi, hkâ-nhám le shi byuq a sê é myî èq nyhê hkyô pyám râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Haû mù, Yohan gi, byù haú bang lé gotû dang myo myo èq lhoq pun lhoq kying mù, gabú danglù lé hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nghut kôlhang, hkâ-myháng a myáng má mauzau Herut gi, yhanggû é yhangmyi Herudiaq lé lú yu é hkyô eq, yhang kut shut é gotû a ge é mû banshoq é yanmai, Yohan gi, yhang lé tân mhoqshit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mara haú pê htoq agó, Herut dum kut jat yu é mara gi, Yohan lé htóng má lhûng kat é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yohan lé htóng má a lhûng kat shimá, byù myo myo gi, wui-myhup hkâm yu nyì kô é hkûn, Yesuq le Yohan chyáng wui-myhup hkâm yù mù, kyûdûng nyi le, mauhkûng bóng lô mù, ");
INSERT INTO atbNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","haû Chyoiyúng Woi-nyí gi, hpûngkyui gunghkyâng sû é dông mai Yhâng ahtoq má lé gyó nô ri. Haú hkûn, \"Nàng gi, Ngò chyitdap é Ngá zo nghut lhê; Náng é ahtoq má Ngò gabú myit ngón nyi lhê.\" ga mauhkûng mai danghtê htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuq gi, Yhang mû zuî hi é hkûn, asak sum xê zàn kô nghut bê; Yhang lé byù hkyam dông gôn wú jáng, Yhang gi, Yosep é yhangzo nghut ri; Yosep gi, Heli é yhangzo, Heli gi, Mahtat é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mahtat gi, Lewiq é yhangzo, Lewiq gi, Melahki é yhangzo, Melahki gi, Yannai é yhangzo, Yannai gi, Yosep é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep gi, Matahtiaq é yhangzo, Matahtiaq gi, Amo é yhangzo, Amo gi, Nahum é yhangzo, Nahum gi, Esali é yhangzo, Esali gi, Nagai é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai gi, Maat é yhangzo, Maat gi, Matahtiaq é yhangzo, Matahtiaq gi, Semai é yhangzo, Semai gi, Yosek é yhangzo, Yosek gi, Yodaq é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yodaq gi, Yohan é yhangzo, Yoanan gi, Resa é yhangzo, Resa gi, Zerubabelaq é yhangzo, Zerubabelaq gi, Shalahtila é yhangzo, Shalahtila gi, Neri é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri gi, Melahki é yhangzo, Melahki gi, Adi é yhangzo, Adi gi, Kusam é yhangzo, Kusam gi, Elamadam é yhangzo, Elamadam gi, Era é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era gi, Yoshuq é yhangzo, Yoshuq gi, Elieze é yhangzo, Elieze gi, Yorim é yhangzo, Yorim gi, Mahtat é yhangzo, Mahtat gi, Lewiq é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewiq gi, Simeon é yhangzo, Simeon gi, Yudaq é yhangzo, Yudaq gi, Yosep é yhangzo, Yosep gi, Yonam é yhangzo, Yonam gi, Eliakim é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim gi, Mela é yhangzo, Mela gi, Menaq é yhangzo, Menaq gi, Matahta é yhangzo, Matahta gi, Nahtan é yhangzo, Nahtan gi, Dawiq é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawiq gi, Yese é yhangzo, Yese gi, Obet é yhangzo, Obet gi, Bua é yhangzo, Bua gi, Salamun é yhangzo, Salamun gi, Nashon é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon gi, Aminada é yhangzo, Aminada gi, Arni é yhangzo, Arni gi, Hesrun é yhangzo, Hesrun gi, Hparet é yhangzo, Hparet gi, Yudaq é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudaq gi, Yakup é yhangzo, Yakup gi, Isak é yhangzo, Isak gi, Abraham é yhangzo, Abraham gi, Htara é yhangzo, Htara gi, Nahura é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahura gi, Seruk é yhangzo, Seruk gi, Re-u é yhangzo, Re-u gi, Hpelek é yhangzo, Hpelek gi, Ebera é yhangzo, Ebera gi, Shela é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela gi, Kainan é yhangzo, Kainan gi, Arhpaza é yhangzo, Arhpaza gi, Shem é yhangzo, Shem gi, Noaq é yhangzo, Noaq gi, Lamek é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek gi, Mehtusela é yhangzo, Mehtusela gi, Enuk é yhangzo, Enuk gi, Yaret é yhangzo, Yaret gi, Mahelela é yhangzo, Mahelela gi, Kainan é yhangzo, ");
INSERT INTO atbNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan gi, Enu é yhangzo, Enu gi, Shet é yhangzo, Shet gi, Adam é yhangzo, Adam gi, Garai Gasâng é yhangzo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuq gi, Chyoiyúng Woi-nyí èq byíng mù, Yodan làng mai dum taû lo é hkûn, Chyoiyúng Woi-nyí gi, Yhang lé yoso shut shuî e ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Haú má, Yesuq gi, buinyì myi xê nyí jé shoq, nat Tsadán èq gunglaú é huî ri. Buinyì haú gyoro má, Yesuq gi, haî le a zô é yanmai, zòmut hui bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Haû mù luî, nat Tsadán gi, \"Nàng, Garai Gasâng é Yhangzo nghut le gi, luqgok shî lé muk dut nhâng aq.\" ga luî, Yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Haú hkûn, Yesuq gi, \"'Byù gi, muk èq za asak duì râ a nghut.' ga luî, Chyúmdang má kâ tô ri.\" ga yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hau htâng, nat Tsadán gi, Yesuq lé, gyai yhang myhang é bùm htoq má shuî doq ló mù, mingkan má joq é mingdán pé banshoq lé razup má za tûn shit luî, ");
INSERT INTO atbNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","\"Shî ahkáng ayá banshoq eq haû mingdán é hkikhkâm hkyô banshoq, ngò nang lé wó byî lhê; hkâsu mù gâ le, haú pé banshoq gi, ngo lé ap byî to bê nghut mù, ngò byí nau é sû ó yuq lé nghut kôlhang, byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Haû mù, Nàng, ngo lé noq é nghut jáng, shí pé banshoq Náng é dut râ nghut lhê.\" ga, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Haú hkûn, Yesuq gi, \"'Haû Yhumsîng náng é Garai Gasang lé za, nàng noqkuq dojaú ra râ nghut lhê.' ga luî, Chyúmdang má kâ tô ri.\" ga luî, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nat Tsadán gi, Yesuq lé Yerusalem wà mó má shuî ê mù, noqkuq yhum je myhang é shûhtâng htoq má yap nhang to luî, \"Nàng, Garai Gasâng é Yhangzo nghut le gi, shî mai byam gyó kat wú aq. ");
INSERT INTO atbNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hkâsu mù gâ le, 'Nang lé upzúng byî nyì râ matú, Garai Gasang gi, Yhâng é maumang lagyô pé lé taî to râ nghut mù, ");
INSERT INTO atbNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","luqgok má náng é hkyî a ló htung shoq, yhangmoq é loq èq Nang lé lhom bún yû kó râ nghut lhê.' ga luî, Chyúmdang má kâ tô ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nghut kôlhang, Yesuq gi, \"'Haû Yhumsîng, nungmoq é Garai Gasang lé, wó chyam wú râ a nghut.' ga luî, Chyúmdang má bo tô ri.\" ga, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nat Tsadán gi, gunglaú é hkyô pé banshoq ban kut jáng, ahko ahkáng láng wú uchyang yhâng chyáng mai byam gâng nyi byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuq kúm gi, Chyoiyúng Woi-nyí wum-o byíng é èq Galile mau shut dum taû lo ri. Haú mau jowò hkangmó má, Yhâng é hkyô lé taî pyo ló bùm bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yhangmoq é tarajong pé má, Yesuq mhoqshit byi mù, lhunglhâng bang gi, Yhang lé taî hkya-ôn nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hau htâng má, Yhang nyi kô lo é Nazaret wà má dum taû jé ló bê; Yhang gi, hkâ-nhám le kut nyi é eq rajung za, Bánno buinyì lé tarajong má wang ê mù, laiká nghap râ ga toq yap é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yhang lé myiqhtoi Esai-aq chyúmding byi kôjáng, Yhang chyúmding haû lé hpông kat le, ");
INSERT INTO atbNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"Yhumsîng é Woi-nyí gi, ngá é ahtoq má nyi nyi ri; hkâsu mù gâ le, asho awuî é bang lé gabú danglù hkô kyo râ matú, Yhang ngo lé hkyin yù bê. Htóng lúng bang lé lhoq htoq râ hkyô eq, myoqjit bang lé myoq dum myàng nhâng râ hkyô hkô kyo râ matú le, zik zo huî é bang lé nhang kat nhâng râ eq, ");
INSERT INTO atbNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yhumsîng, Yhâng é byu pé lé hkyi yù râ ahkyíng zanwut lé hkô kyo râ matú le, Yhang, ngo lé nhang kat bê nghut ri.\" ga luî, kâ tô é jowò lé myang záng mù nghap ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hau htâng, Yesuq gi, chyúmding haú lé ding mù, shuî-u sû lé tau byî pyám luî, dum zung tô ri; tarajong mâ é byù lhunglhâng bang gi, Yesuq lé chôm wú tô é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesuq gi, \"Nungmoq é nohkyap má, ahkuî wó gyô é Chyúmdang shî gi, hkû-nyí yhang lo dik bê.\" ga luî, yhangmoq lé taî hi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lhunglhâng bang gi, Yhang ge é hkyô lé saksé hkám byi kômù, Yhâng é nhut mai htoq é jeju bo é dang lé le, maú kôluî, \"Shí yuq gi, Yosep é yhangzo a nghut lhú?\" ga taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Haû mù luî, Yesuq gi, \"Nungmoq gè gè yhang, 'Chi sará ê, yhumsing gùng lé lhoq ge yù aq.' gâ é sanghkyang èq le, 'Nàng, Kaperna-um wà má kut shit wú é hkyô ngamoq wó gyo bê, haû eq rajung za, nàng, náng é yhum mau má le, kut shit wú aq.' ga luî le, ngo lé taí kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yhang dum xoq taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, myiqhtoi ó yuq le yhumsing é yhum mau má myoqdong wó wú é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ngò, nungmoq lé teng za taí kôlé, Eliyaq é pyat lé, Israelaq ming má chuimó myo myo nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nghut kôlhang, haú ming má súm zan eq lhamó hkyuq hkyap yhang, mau a wò dut byuq mù, mutmó gyó tô é hkûn, Garai Gasang gi, yhangmoq mâ é rayuq chyáng le, Eliyaq lé a nhang kat é za, Sidun mau Zarephta wà mâ é, chuimó myhí rayuq chyáng sheq nhang kat byî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Myiqhtoi Elisha é pyat má le, Israelaq ming má, manggâm dap é byù myo myo nyì kôlhang, yhangmoq chyáng mâ é rayuq le wó sân-yúng yù kô é a nghut; Suriq byù Naman ga sû tûngbaù hpó za sheq wó sân-yúng é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tarajong hkaû mâ é lhunglhâng bang gi, haú hkyô lé wó gyo kôjáng, gyai yhang nhik-yo nau bùm kômù, ");
INSERT INTO atbNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","toq yap luî, Yhang lé wà mai hkat htoq mù, yhangmoq é wà xuq tô é bùm gùng htoq mâ é gampyoq má, ê chyûn hpyit hkyô pyám râ ga shuî e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nghut kôlhang, Yesuq kúm gi, byù hpûng haû mai so hkoq htoq ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hau htâng, Yesuq gi, Galile mau mâ é Kaperna-um wà má jé ê mù, Bánno buinyì má byu pé lé mhoqshit hi ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yhangmoq gi, Yhang mhoqshit é hkyô lé mauhong nyi akô; hkâsu mù gâ le, Yhang gi, ahko ahkáng bo é dang dông taî nyi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yesuq, tarajong hkaû má mhoqshit byî nyi é hkûn, nat gang wang júng é byù rayuq htê mó o mó èq taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"Ê, Nazaret wà byù Yesuq ê, ngamoq gi, Nàng eq haî sêng lhê lhú? Ngamoq lé lhoq hten râ matú, Nàng jé lé é nghut lhê lhú? Nàng gi, Garai Gasâng é Chyoiyúng Sû nghut é lé, ngò sê lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Haú hkûn, Yesuq gi, \"Hkâjop, yhâng chyáng mai htoq ló aq.\" ga yhang lé tân kat jáng, nat gi, haú yuq le yhangmoq é gung gûng má lhoq lheq to mù, a nò nhang é za, yhâng chyáng mai htoq ló byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Haû mù luî, shiwa byù banshoq bang gi, gyai yhang maú byuq kômù, rayuq eq rayuq, \"Shí yuq é dang gi, hkasû é dang wá nghut lhê lhú? Yhang gi, ahkáng ayá èq le, wum-o bo é èq le, agè ashop é nat pé lé hkunmó hkyó jáng, haú bang htoq ló byuq akô.\" ga taî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Haú hkûn, haú mau mâ é awui ayàm jowò hkangmó má jàm shoq, Yhâng é hkyô lé taî pyo hû ló bûm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesuq gi, haû tarajong mai toq ló mù, Simun é yhûm má wang ló ri. Simun é yhâng-aumó gi, alì gyai nyé no nyi é nghut mù luî, lhoq gê byí râ matú, Yesuq lé garúm dung byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesuq gi, Simun é yhâng-aumó nàm má yap to mù, nòhpyo haû lé tân kat jáng, Simun é yhâng-aumó gi, ge ló byuq bê; haú hkûn jáng, yhang gi, toq mù, yhangmoq lé gaí tso gaí huq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Buì wang ló jáng, nòhpyo hui bang eq awáng nòhpyo ajung jung dap é bang lhunglháng lé, Yesuq chyáng shuî lé lô kômù, yhangmoq rayuq htâng rayuq é ahtoq má Yesuq gi, loq ke byi luî, lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nat gâng pé gi, Yesuq lé, \"Nàng gi, Garai Gasâng é Yhangzo nghut ri.\" ga luî, wut taí mù byù myo myô chyáng mai htoq ló byuq akô; Yesuq gi, Hkrisduq nghut é hkyô lé, yhangmoq sé kô é yanmai, yhangmoq lé dang a wó taí loshoq, Yesuq tân pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Maubó lô jáng, Yesuq gi, htoq ló mù, gaû é jowò yoso hkaû má ê nyi tô ri; shiwa byu pé kúm gi, Yhang lé hkat hô kômù, myang hô kôjáng, yhangmoq chyáng mai a ló byuq râ matú châng hkûm wú akô. ");
INSERT INTO atbNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nghut kôlhang, Yesuq gi, \"Garai Gasâng é mingdán é gabú danglù lé, gó wâ pé má le ngò hko kyo râ râ ashî, haû é matú, Garai Gasang gi, ngo lé nhang kat bê nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Haû mù, Yesuq gi, Yuda mau mâ é tarajong pé má, hko kyô wún nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Radàm má lé, Yesuq gi, Genesarat nhông yàm má yap tô le, Garai Gasâng é mungdang gyo râ ga, shiwa byu pé, Yhâng chyáng chyîn chyap wang lé lô kô é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","nhông gin-gau yàm má lhaî razúm joq tô é lé, Yhang myang kat ri. Ngogûn dú bang kúm gi, lhaî mai htoq mù, yhangmoq é gùn pé lé chî nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesuq gi, Simûn é lhaî má wàng mù gin-gau mai rachyit lhoq kang nhâng luî, haû lhaî htoq má zung to mù, shiwa byu pé lé mhoqshit taî kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dang ban taí jáng, Yesuq gi, Simun lé, \"Wuì nik é shut hui luî, ngozo wó kông yù râ matú, nungmoq é gùn pé lé dú hkyô kat keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simun gi, \"Yhumsîng ê, ngamoq amàn ra-myin mau shikut wú kôlhang, haî le a wó; nghut kôlhang, náng dang é yanmai, ngò gùn dú hkyô kat râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gùn pé lé hkyô kat kôjáng, yhangmoq gi, ngozo gyai myo shoq lé wó kông yù kômù, gùn lháng jeq ló râ su dut é yanmai, ");
INSERT INTO atbNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","lhaî gó lhum mâ é luzúm wuî lé, lé garúm yû râ matú loq lik lik kat kôjáng, haú bang lé lô mù, haû lhaî í lhum aluq myup ló shoq ngozo lé kat pyíng bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simun Petruq gi, haú lé myàng jáng, Yesuq é hkyî wang má hkyihput htuq mù, \"Yhumsîng ê, ngá chyáng mai ló byuq aq, haî mù gâ le, ngò gi, yubak dap é byù nghut nyi lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Haî mù luî gâ le, Simun le, yhang eq nyi tô é lhunglhâng bang le, haû su ngozo wó yu é yanmai, maú nyi bùm kômù nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simûn é luzúm nhik, Zebedi é yhangzo Yakuq eq Yohan le, haû su chôm maú byuq akô. Hau htâng, Yesuq gi, \"Hkâgyuq, ahkuî mai nàng gi, byù lé châng kóng sû dut râ nghut lhê.\" ga luî, Simun lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yhangmoq gi, wuiyàm má jé jáng, lhaî pé eq yhangmoq é zè banshoq lé tô pyâm to luî, Yesuq htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Radàm lé, Yesuq gi, wà rawà má nyi tô lé, ragùngdû é manggâm dap é byù rayuq lé lo ri; haú yuq gi, Yesuq lé myàng jáng, hkyihput htuq luî, \"Yhumsîng ê, Nàng dóng é nghut le gi, ngo lé Nàng wó lhoq sân-yúng byi râ nghut lhê.\" ga dûng wut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuq gi, loq lhâm kat mù, haú yuq lé ê záng luî, \"Ngò dóng lhê, sân-yúng aq hkoi.\" ga taî ri; haú hkûn jáng, haú yuq é manggâm gi, ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuq gi, \"Nàng, shí hkyô ó lé le hkâtaî kyo. Nghut kôlhang, náng é gungdu lé, hkyangjong hpô chyáng ló tûn shit mù, nàng sân-yúng bê hkyô lé yhangmoq é matú saksé dut sháng gaq, Mosheq tarâ tô tô é eq rajung za, hkungga ló nhông byi aq.\" ga, yhang lé taí hkûm kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nghut kôlhang, Yesuq é hkyô gi, je riyhang taî pyo hû jam ló mù luî, shiwa byù rajùm rayò gi, Yhâng é dang gyo râ matú le, yhangmoq é nòhpyo lhoq gê byí nhâng râ matú le, lé zup míng tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesuq kúm gi, Yhang baú tsik za yoso shut htoq ê mù, kyû ê dung dung kut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ra-nyí lé, Yesuq mhoqshit nyi é hkûn, Hparishe pé eq tarâ sará pé le, Yesuq nâm má zung tô akô; haú bang gi, Galile mau wà hkyap hkangmó mâ é bang eq Yuda mau, Yerusalem wà mó mâ é bang nghut akô. Yhumsîng Garaî é wum-o a-tsam le nòhpyo lhoq gê râ matú Yesuq eq rahá nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Haú hkûn, byù ra-am gi, gùngjum shî sû rayuq lé taphkang mai waq lé lô kômù, haú yuq lé, yhúmhkaû má nyi tô é Yesuq é hí má, wó lheq byi shoq ga hkyô ho nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Byù lûm myô chyîn chyap to mû, haû nò sû lé hká dông le a wó shuî wàng kôluî, haû yhumhkûng htoq shut waq doq ló mù, haú yuq lé taphkang eq roq, shiwa hpong gung gûng, Yesuq é hí ang ang má hkyô hang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuq gi, yhangmoq é lumjíng myit lé byu myàng jáng, \"Byù nàng ê! Náng é yubak mara lé hkyut pyám byi bê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Haú hkûn, Hparishe pé eq tarâ sará pé gi, \"Shî su ga luî, Garai Gasang lé rhoî dang taî é sû gi, ó yuq wá nghut lhê lhú? Garai Gasang za a nghut jáng, yubak mara wó hkyut pyám byi sû gi, ó yuq wá nghut lhê lhú?\" ga luî, myit són wuî nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuq gi, yhangmoq myit són wuî nyi é hkyô lé sé mù, \"Nungmoq é i-myit hkaû má, haî mù shí pé lé myit són wuî nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Náng é yubak mara lé hkyut pyám byi bê.' nghû taí râ eq, 'Toq luî, hkyô so aq.' nghû taí râ má, hká hkun je taí lui lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nghut kôlhang, haû Byu Yhangzo gi, mingkan htoq má, mara hkyut byi râ ahkáng wó Sû nghut é lé, nungmoq lé sé nhâng nau lhê.\" ga mù, haû gùngjum shî sû lé, \"Ngò, nàng lé taí bá, toq aq, náng é taphkang yu chûng luî, yhûm taû ló aq hkoi.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Haú hkûn jáng, yhang gi, yhangmoq é hí má toq yap mù, yhâng é taphkang waq chûng luî, yhâng é yhûm shut Garai Gasang lé hkya-on kungtôn uchyang ló byuq bê. ");
INSERT INTO atbNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Byù banshoq bang gi, gyai maú byuq kômù luî, Garai Gasang lé hkya-on kungton akô nghut ri. Yhangmoq gyai gyuq maú dik é èq le, \"Hkû-nyí, nga-nhúng, mauhpo amû pé lé myàng bê.\" ga taí nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hau htâng má, Yesuq sô e ló le, Lewiq gâ é kang guq sû rayuq yhâng é kang guq zúm má zung tô é lé ê myàng mù, haú yuq lé, \"Ngá htâng cháng aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewiq gi, haú mâ é zè banshoq lé tô pyâm to mù, toq luî, Yhâng htâng cháng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hau htâng, Lewiq gi, yhâng é yhûm má Yesuq é matú zoshuq poî mó kut byî ri; poî haú má kang guq bang myo myo eq byù góbang le, yhangmoq eq rahá za zô zung nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Haû mù luî, Hparishe pé eq yhangmoq hpúng mâ é tarâ sará pé kúm gi, \"Nungmoq gi, haî mù luî kang guq bang eq yubak dap bang eq rahá zo shuq nyi akô lhú?\" ga, Yhâng é chángzô pé lé mara hûn dang taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuq gi, yhangmoq lé, \"Wángzán bang chi sará a ra kó, nòhpyo hui bang za sheq ru râ lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngò gi, dingmán bang lé wut yù râ matú jé lé é a nghut, yubak dap bang myit lhîng râ matú sheq jé lé é ru nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dum, yhangmoq gi, \"Yohan é chángzô pé gi, zoshuq gám mù kyûdung dung kut akô; Hparishe pê é chángzô pé le, haû su kut akô; nghut kôlhang, náng é chángzô pé gi, haî mù zô nyì shuq nyi akô lhú?\" ga Yesuq lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuq, yhangmoq lé tû taî é gi, \"Bíng pé gi, lusik eq rahá nghut nyi to ashî hkûn, yhangmoq lé zo shuq wó gám nhâng râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nghut kôlhang, lusik lé yhangmoq chyáng mai shuî yu pyâm é hkyíng jé râ nghut lhê; haú buinyì pé má kúm gi, yhangmoq, zoshuq gám kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dangtú dông mai le, Yesuq, yhangmoq lé taî é gi, \"Mebu sik mâ é lâng cheq yû mù, mebu xau má hpo é gi, ó a kut wú kó; haû su kut é nghut jáng, mebu sik lé le lâng cheq pyâm é dut mù, pán jap sik le mebu xau eq du lhum râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tsibyiq wing asik lé le, shokuq htûng axau má ó a kat wú kó. Kat é nghut jáng, tsibyiq wing asik gi, htûng lé lhoq buq goq nhâng mù, tsibyiq wing le yui shun byuq, htûng le htên byuq, dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Haû su a dut shoq gi, tsibyiq wing asik lé, shokuq htûng asik má kat ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tsibyiq wing axau shuq nyî bê sû gi, asik lé a shuq naû nghut râ; hkâsu mù gâ le, 'Axau sheq je nghâm ri.' ga taí râ.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bánno buinyì ra-nyí má, Yesuq gi, Yhâng é chángzô pé eq yò hkaû mai sô laî ló é hkûn, Yhâng é chángzô pé gi, kyôshi ratsuí langshap yû mù, loq èq nè hpuq zô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Haû mù luî, Hparishe pé ra-am gi, \"Bánno buinyì má a ge kut jung lé, nungmoq gi, haî mù luî haû su kut akô lhú?\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuq gi, yhangmoq lé, \"Dawiq lháng gi, yhâng htâng châng é bang eq rahá zòmut huî é hkûn, hkâsu kut é hkyô lé, nungmoq a nghap wú kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawiq gi, Garai Gasâng é yhûm hkaû má wang ê mù, hkyangjông pé mai lai luî, ó le a ge zô é, kyâng tô é muk lé yù zo mù, yhâng htâng châng é bang lé le, byi tsô é a nghut kó lhú?\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hau htâng, Yhang gi, \"Haû Byu Yhangzo gi, haû Bánno buinyi é Yhumsîng nghut lhê.\" ga yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gotû Bánno buinyì má le, Yesuq gi, tarajong má wàng mù mhoqshit nyi é hkûn, loqyo loq ajum shi byuq é byù rayuq haú má nyi tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Haú hkûn, tarâ sará pé eq Hparishe pé gi, Bánno buinyì má nòhpyo lhoq gê byi râ lhú ga luî, Yhang lé mara wó hûn shoq ga gyám wú nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesuq kúm gi, yhangmoq é i-myit lé sé sû nghut luî, loq jum shî sû lé, \"Toq mù, banshoq bâng é hí má, yap shit aq.\" ga taî kat ri. Haú yuq le, toq mù yap tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Haú hkûn, Yesuq gi, \"Ngò nungmoq lé myî wú kôlé, Bánno buinyì má, ge é muzó kut râ, a ge é muzó kut râ, byù asak hkyî râ eq lhoq hten râ pé má hká lhum kut le sheq tarâ wang lhê lhú?\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hau htâng má, yhangmoq banshoq lé lhing wú mù, haû loq jum shî sû lé \"Náng é loq nyhang kat aq.\" ga taî kat é hkûn lé, yhang le loq nyhang kat luî, yhâng é loq gi, shoq za ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nghut kôlhang, yhangmoq gi, myoq chum nhô chik yhang nhik-yo naû kômù luî, \"Yesuq lé hkâsu wá kut pyám râ lhú?\" ga luî, rayuq eq rayuq taî lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Haû yoq ra-nyí má, Yesuq gi, kyûdung râ ga bùm shut htoq e ló luî, ra-myin mau Garai Gasang lé kyûdûng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Maubó jáng Yhâng é chángzô pé lé wut yù mù, yhangmoq chyáng mâ é raxe í yuq lé hkyin yù luî, lagyô pé ga myhîng to byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Haú bang gi, Yesuq èq Petruq ga myìng myhíng byî é Simun eq, yhanggu Andre, Yakuq eq Yohan, Hpilip eq Barhtolume, ");
INSERT INTO atbNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mahte eq Htomaq, Alhpe é yhangzo Yakuq eq Zelutuq dut é Simun, ");
INSERT INTO atbNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakuq é yhangzo Yudaq eq, Yesuq lé ap pyám râ sû Yudaq Iskarut pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuq gi, yhangmoq eq rahá gyó ló mù, janggyú má yap tô é hkûn; Yhâng é chángzo moq mó le mù, Yuda mau banshoq mâ é bang, Yerusalem wà mó mâ é bang, wuìshuq lung-aû ayàm mâ é Turuq myuq eq Sidun myuq mâ é bang, rajùm rayò gi, ");
INSERT INTO atbNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yhâng é dang gyô yù râ eq yhangmoq é nòhpyo lhoq gê nhâng râ matú, rahá za zup míng tô akô. Agè ashop é nat èq zing-ri huî é bang le ge byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yhâng é gùng mai htoq é wum-ô èq byù banshoq lé lhoq gê byî nyi é yanmai shiwa byu pé le Yhang lé wó záng shoq ga, ho nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Haú hkûn, Yesuq gi, Yhâng é chángzô pé lé wú kat luî taî é gi, \"Myùng bang nungmoq gi, hkungsô wó nyi ri, hkâsu mù gâ le, Garai Gasâng é mingdán gi, nungmoq é mingdán nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ahkuî, zòmut wuìshit huî nyi é bang nungmoq gi, hkungsô wó nyi ri, hkâsu mù gâ le, nungmoq nhik dik shoq myàng zo kó râ nghut lhê. Ahkuî, ngau nyì bang nungmoq gi, hkungsô wó nyi ri, hkâsu mù gâ le, nungmoq myang wuì kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Haû Byu Yhangzô é yanmai nungmoq lé su èq a nguì é, lhoq hpyoq lhoq kâng é, hoq hpu nhang é, agè ashop nghut é dong jihpoi gamhkui huî é hkûn, nungmoq gi, hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Haú hkûn lé, gabú byam chyû nyì keq, hkâsu mù gâ le, wú keq, nungmoq é matú kô é chyunghuq gi, mauhkûng mingdán má joq tô ri. Ngò, nungmoq lé taî lhê, hkâsu mù gâ le, yhangmoq é îchyí îwa pé le myiqhtoî pé lé haû su kut wú bekô.\" ");
INSERT INTO atbNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nghut kôlhang, sùt wó bang nungmoq gi, dingnyé wó râ, hkâsu mù gâ le, nungmoq gi, yhumsing gùng má nhik shî nhik dik é hkyô lé huî yù bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ahkuî, gyi gyi dau dau myàng zo myàng shuq nyi é bang nungmoq gi, dingnyé wó râ, hkâsu mù gâ le, nungmoq zòmut wuìshit é hui kó râ nghut lhê. Ahkuî, wui nyi é bang nungmoq gi, dingnyé wó râ, hkâsu mù gâ le, iyon yôn é eq ngaubyi ngau-nhap htoq é hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Byù banshoq bang, nungmoq lé ge é byù ga kôjáng, nungmoq gi, dingnyé wó râ, hkâsu mù gâ le, yhangmoq é îchyí îwâ pé le, myiqhtoi pyoq pé lé, haû su ga taî wú bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hau htoq agó, ngá dang gyô nyì bang nungmoq lé ngò taí kôlé, nungmoq é gye pé lé chyitdap nyì keq; nungmoq lé a naù a wôm é bang lé ge é hkyô kut keq; ");
INSERT INTO atbNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","nungmoq lé nhîng é bang lé, shimân byi keq; nungmoq lé rhoi é bang lé kyûdung byi keq. ");
INSERT INTO atbNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nang lé bo-pyuq rahkyam shut pyuq byi sû lé, rahkyam dum hkâm byi shi aq; náng bumó hkyut yu é sû lé, buzo le dum hkyut byi shi aq; ");
INSERT INTO atbNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","nang lé rajung jung dûng é sû lé le, byî pyám aq; náng zè yu pyám byî é su chyáng mai le, hkâdûng yù lo. ");
INSERT INTO atbNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nungmoq ô nau é dông supé lé kut nhâng nau é su, yhangmoq lé le kut byi keq. ");
INSERT INTO atbNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nungmoq lé chyitdap é bang lé za chyitdap kô le gi, nungmoq é matú hai akyû bò kó râ lhú? Yubak dap bang le, yhumsîng lé chyitdap é bang lé gi, chyitdap nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nungmoq lé ge é dông kut nyi é bang lé za, ge é dông kut nyî kô le gi, nungmoq é matú hai akyû bò kó râ lhú? Yubak dap bang le haû su kut nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Supé lé zè chyi byî le, dum wó tau byi râ su dut é bang lé za, chyi byî le gi, nungmoq é matú hai akyû bò kó râ lhú? Yubak dap bang lháng chyi byî é myhó dum wó yû shoq, yubak dap é bang lé chyi byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nghut kôlhang, nungmoq gi, nungmoq é gye pé lé chyitdap mù, ge é dông kut byî nyì keq. Dum wó taû yù râ lé myoq a byu é za, chyi ngho byi keq; haû su kut jáng, nungmoq wó é chyunghuq ko râ eq, Myhang htáng htúm Su é yhangzô pé dut râ nghut lhê; hkâsu mù gâ le, Yhang gi, jeju a dat bun bang eq agè ashop é bang lé ge é kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nungmoq é Îwa Garai Gasang shogyo nhikmyin sê é su, nungmoq le shogyo nhikmyîn nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A jéyáng é za nyì keq; haû jáng, nungmoq le jéyáng é a hui kó râ nghut lhê. A doqdân é za nyì keq; haû jáng, nungmoq le doqdân é a hui kó râ nghut lhê. Mara hkyut byi keq; haû jáng, nungmoq le mara hkyut byî é hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Byi keq, haû jáng, nungmoq le dum byî é hui kó râ nghut lhê. Mán é bùng mai byíng mui shûn shoq nhûn chyîng, dûn chying kat mù, nungmoq é tanghkoí hkaû má lik kat byî é hui kó râ. Hkâsu mù gâ le, nungmoq lik byî é bung èq, nungmoq lé dum lik byi râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hau htoq agó, Yhang dangtú ralhum dông yhangmoq lé dum taî é gi, \"Myoqjit sû gi, myoqjit sû lé hkyô wó tûn shit lhê lhú? Yhangnhik í yuq é donghkong má byit gyó kó râ nghut lhê, a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jongzo gi, sará htoq gyaú râ a nghut; nghut kôlhang, gúm shoq mhoq yû bê sû ó nghut kôlhang, yhumsing é sará su dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Yhumsing myoq hkaû má lúng tô é siktúm lé lháng a myit wú é nhîng, haî mù luî, nunggu nungmâng é myoqwàng lé myang lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Yhumsîng é myoq má lúng tô é siktúm lé lháng a myàng sû nhîng, 'Gumang hpó ê, náng myoq má lúng tô é myoqwàng lé, ngò choq pyám byi lé.' nghû luî, náng é gumang hpó lé hkâsu wó taí râ lhú? Gegùn labyoq kut sû ê, náng é myoq má lúng tô é siktúm lé hí choq pyám aq. Haû jáng sheq, nunggu nungmang é myoq má wang tô é myoqwàng lé choq pyám byi râ matú, nàng san za myàng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A ge é ashi zuî é, ge é shigâm hkâmá le a joq. Ge é ashi zuî é, a ge é shigâm le a joq. ");
INSERT INTO atbNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Haû mù luî, shigâm hkangmó lé, zuî é ashi lé wú mù wó sê hkyin yu lhê. Dangké, zubyap mai maihpáng-shi ó le a myang hpyoq yù wú, zugyóm mai le tsibyiq shi a wó hpyoq yu wú. ");
INSERT INTO atbNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ge é sû gi, yhumsing é i-myit unghkaû mâ é sutdò mai ge é zè pé lé lhoq htoq shit lhê. Agè ashop é sû gi, yhumsing é i-myit unghkaû mâ é agè ashop é sutdò mai, agè ashop é zè pé lé lhoq htoq shit lhê. Haî mù gâ le, yhâng é i-myit unghkaû má byíng mui tô é lé za, yhâng é nhut mai taî htoq lo é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ngò taî é eq rajung za lháng a wó châng kut kô é nhîng, haî mù luî, nungmoq Ngo lé 'Yhumsîng ê, Yhumsîng ê.' nghu nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ngá chyáng lé mù, ngá dang gyô yù luî, châng kut é sû ó nghut kôle, hkasû é sû eq wuí é lé ngò nungmoq lé shit kyo kôle. ");
INSERT INTO atbNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Haú yuq gi, wahpang yhûm saî le, nik nik du luî a dui é lunghtân htoq má apûn awang hi é sû eq wuí lhê. Wuì jê lò luî wuibaù pê èq yhûm haû lé lo gùn kôlhang, ging ging tíng tíng saî to bê nghut luî, haû lé a wó gun nhún. ");
INSERT INTO atbNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngá dang gyô yù mù, a cháng sû gi, apûn awang a saî é za myì chîn dum má wahpang yhûm saí sû eq wuí nyi ri. Wuìbaù pê èq yhûm haû lé lo gun kat é eq, haú hkûn jáng, lêng gyop byuq ri. Yhûm haû byoq hten byuq é gi, yù whuî a bò loshoq dut byuq râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuq gi, shiwa byu pé lé ban mhoqshit é htâng má, Kaperna-um wà shut wang ló ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Haú hkûn, Romaq gyezau rayuq é chyitdap dui-nhâng zoshâng gi, shî-nò no nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Haú u lé, gyezau hpó gi, Yesuq é hkyô lé wó gyo jáng, yhâng é dui-nhâng zoshâng lé lhoq gê byi râ matú, Yesuq lé ê ji lò keq ga, Yudaq suwún wuî lé nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Haú bang gi, Yesuq chyáng jé ê kô é hkûn, \"Yhang gi, nàng shí hkyô kut byi râ matú gingdán é sû, yhang nghut nyi ri; ");
INSERT INTO atbNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","hkâsu mù gâ le, yhang gi, nga-nhûng amyû lé chyitdap é eq, ngamoq matú tarajong le kut byi sû nghut ri.\" ga luî, Yhang lé zuq zuq dûng wut nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Haû mù luî, Yesuq gi, yhangmoq eq rahá za e ló ri. Haú yhûm eq hká hé a wê é má jé jáng, Romaq gyezau hpó, yhâng é luzúm wuî lé taí nhang kat é gi, \"Yhumsîng Yesuq ê, náng gûng lé hkâlhoq hkyik lo. Nàng, ngá é laishîn-htâng má, lé nang râ lháng ngò má a gingdán. ");
INSERT INTO atbNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Haû mù, ngò, náng chyáng jé lé râ matú gingdán é sû a nghut; Nàng, dang rahkun za taî kat laq, haú hkûn, ngá é dui-nhâng zoshâng ge ló râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hkâsu mù gâ le, ngò le ahkáng ayá wó é zau rayuq é a-ô mâ é zau nghut lhê; ngá é a-ô má le gyezô pé nyi lhê, rayuq lé 'Ê aq!' nghu le, yhang e ló lhê; góyuq lé, 'Lò aq!' nghu le, yhang lò lhê; ngá jûn lé le, 'Shî kut aq!' nghu le, yhang kut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuq gi, dang haú lé wó gyo jáng, haú yuq é hkyô lé maú byuq luî, Yhang htâng châng é shiwa byu pé lé lhing wú mù, \"Ngò, nungmoq lé taí kôlé, Israelaq amyû má lháng, shî í lumjíng é sû lé, Ngò a myang wú.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nhang kat é bang yhûm má dum taû jé jáng, no nyi é dui-nhâng zoshâng gi, ge to láng é lé ló myang akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hau htâng hkâ-myháng a myáng má, Yesuq gi, Yhâng é chángzô pé eq, shiwa byù moq mó le mù rahá za Na-in gâ é wà shut e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Haû wà wàng hkum má jé lo é hkûn lé, chuimó myhî é yuqzo te gi, shî mù, yhâng é màng lé waq htoq lé lo akô. Wà byù myo myo le, chuimó myhí haû eq rahá châng lé lo akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yhumsîng gi, haû chuimó myhí lé myàng jáng, yhang lé wú shogyo luî, \"Hkâ-ngaû.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesuq gi, gung shut huî ê mù, loq èq ê záng kat ri. Haú hkûn, waq tô é bang le jâng yap to byî akô. Yhang gi, \"Zorâm ê, ngò, nang lé taî lhê, toq aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Haú hkûn, shî bê sû gi, toq zûng mù dang taî lo ri. Yesuq gi, zorâm haû lé yhângnû chyáng dum ap byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Byù lhunglhâng bang gyuq maú bùm kôluî, Garai Gasang lé hkya-ôn é dang gi, \"Myiqhtoi mó, nga-nhûng chyáng lé pô htoq bê nghut ri. Garai Gasang gi, Yhâng é amyû lé garúm râ ga lé kûm wú nyi ri.\" ga taí nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Haû Yesuq é hkyô eq sêng é ludang lé, Yuda mau eq haú mau awui ayàm jowò hkangmó má taî pyo myhîn ló bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Haú hkûn, wui-myhup sará Yohan é chángzô pé gi, haú hkyô banshoq yhang lé lo taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Haû mù luî, Yohan gi, yhâng é chángzo í yuq lé ji yù mù, haû Yhumsing chyáng nhang kat luî, \"Nàng gi, haû jé lé lô râ Sû nghut lhê lhú? Haû a nghut jáng, ngamoq, góyuq lé láng ra shirâ lhú?\" ga, myí nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Haú nhik gi, Yesuq chyáng jé jáng, \"'Nàng gi, haû jé lé lô râ sû nghut lhê lhú? Haû a nghut jáng, ngamoq góyuq lé myoqbyu láng nyî ra shirâ lhú?' ga luî, Wui-myhup Sará Yohan gi, ngá-nhik lé náng chyáng myí nhang kat ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Haú u yhang, Yesuq gi, nò zo hpyo zo, nolì nojàng huî é bang eq agè ashop é nat dap jun dap é byù myo myo lé, lhoq gê byî ri. Myoqjit bang myo myo lé le, myoq dum myàng nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Haú hkûn, Yesuq gi, yhangnhik lé, \"Myàng mi-myàng, wó gyo má wó gyo, Yohan lé ló taî kyo keq; myoqjit bang, myoq wó myâng bekô; hkyî hten bang le, wó so bekô; manggâm dap bang le, lhoq gê byî é hui bekô; nojit bang le, wó gyo bekô; shî bê bang le, lhoq dui toq é hui bekô; myùng bâng é matú, gabú danglù hko kyô nyì bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ngá é yanmai, Ngo lé lum shut é hkyô a bò sû gi, hkungsô wó nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohan é chángzô nhik ló byuq é htâng má, Yesuq gi, Yohan eq séng luî, byù moq mó lé taî é gi, \"Nungmoq gi, haî lé hpuq wú râ matú, haû yoso shut e akô lhú? Lai èq hik nhûn é jamgàm lé wú râ matú nghut akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Haû a nghut jáng, haî lé wú râ matú e akô lhú? Nú-nhâm é mebu wut sû lé wú râ matú e akô lhú? A nghut! Wú keq, gyai hpaû é mebu wut luî agùn agó wó bang gi, hkohkâm-wâng pé má sheq ru nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Haû nghut le gi, haî lé wú râ matú ê kô é lhú? Myiqhtoi rayuq lé lhú? Haû kúm nghut ri. Ngò, nungmoq lé taí kôlé, Yohan gi, myiqhtoî htoq lháng gyaú sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Haú yuq é hkyô lé, Chyúmdang má kâ tô é gi, 'Wú aq, Náng é hkyô lajang láng râ matú, Ngá é lagyo lé, Náng é hí má Ngò nhang kat râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngò, nungmoq lé taí kôlé, myiwe wuì mai hku kat é bang má, Yohan htoq je kô é rayuq lháng a nyì, nghut kôlhang, Garai Gasâng é mingdán má je tiq dik sû gi, Yohan htoq je kô lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mingbyû lhunglhâng bang eq kang guq bang gi, dang haú pé lé wó gyo kôjáng, Yohan byî é baptisma lé hkâm yù kô é nghut mù luî, Garai Gasâng é dingmán é hkyô lé sê gyô yu akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hparishe pé eq tarâ sará pé kúm gi, Yohan byî é baptisma a hkam yù kômù luî, Garai Gasang hen lajang é hkyô lé yhumsing gung é matú he-ngik pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuq dum taî é gi, \"Haû mù luî, byù myû shî lé, Ngò, hai èq taî kê wú râ lhú? Yhangmoq hai eq wuí akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yhangmoq gi, 'Nungmoq é matú, ngamoq sampyí mut byi kôlhang, nungmoq gi, a gó kó, ngamoq ngaù hkyangsâng kôlhang, nungmoq gi, a ngaù kó.' ga luî, gaì pé má zùng uchyang rayuq eq rayuq wut taî lhûm nyi é zoshâng wuì eq wuí akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hkâsu mù gâ le, Wui-myhup Sará Yohan jé lé luî, muk a zo, tsibyiq a shuq é nyi le le, 'Yhang gi, nat gang dap sû nghut ri.' ga luî, nungmoq taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Haû Byu Yhangzo jé lé luî, zo mù shuq mù kut jáng le, 'Shí yuq gi, zo myoq shuq myoq noq sû eq, kang guq bang eq yubak dap bâng é buinùm hpó nghut ri.' ga dum taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nghut kôlhang, hpaqchyî byéng-yá é yhangzô pé gi, hpaqchyî byéng-yá tengmán é hkyô lé saksé hkám byî nyi akô.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hparishe rayuq gi, Yesuq lé yhâng chyáng zang zo râ matú ji kat ri. Haû mù, Yesuq gi, haû Hparishe é yhûm má wàng luî zo râ matú zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Haú hkûn, wú keq, haú wâ mâ é yubak dap é myiwe rayuq gi, Yesuq haû Hparishe é yhûm má zô zung tô é lé sé jáng, gyai hpau dap é namngón xû bo é luq hpyû bòng yu lé luî, ");
INSERT INTO atbNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesuq é nunghtáng hkyî wàng má ngau yap to mù, Yhâng é hkyî má ngaubyî èq záng lhoq teq byi jáng, ûxam èq but sut pyám byî ri. Dum nghut jáng, nhut èq puq luî mura lé but byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yesuq lé ji é Hparishe wá gi, haú lé myàng jáng, \"Shí yuq myiqhtoi nghut le gi, Yhang lé záng htûng é sû, ó yuq nghut é eq hkâsû é yubak dap é myiwe nghut é lé, Yhang sé râ nghut lhê.\" ga luî, yhâng é unghkaû má myit nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuq gi, \"Simun ê, Ngò, nang lé taí râ rajung joq ri.\" ga taî ri. Simun le, \"Sará ê, taí aq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Haú hkûn, Yesuq gi, \"Ngùn chyi zo sû rayuq chyáng, chyîn dap é byù í yuq nyi ri. Rayuq gi, denari ngo shô chap, rayuq gi, ngo xê chap dap ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Haú nhik gi, chyîn xap râ ngùn a wó kôluî, chyîn yhumsîng gi, yhangnhik lé xap a ra lò gâ pyâm ri. Haû mù luî, haú nhik mâ é hká yuq gi, yhang lé je chyitdap râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simun gi, \"Je myo lhoq lhut hui sû, nghut râ su ngam ri.\" ga tû taî ri. Yesuq gi, \"Nàng myit e dông jô ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Haú hkûn, Yesuq, myiwe zo haû lé lhing wú luî, Simun lé, \"Nàng myiwe zo shî lé myang lhê lhú? Ngò, nàng é yhûm má wang le, hkyî chi râ uchyam, nàng a byi, yhang kúm gi, ngaubyî èq ngá hkyî lé tik byi luî, yhâng é xam èq sut pyám byi bê. ");
INSERT INTO atbNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nàng gi, ngo lé nhut èq a puq nghut ri; yhang kúm gi, ngò yhúmhkaû má wang é mai ngá hkyî má a no loshoq puq nyi râ. ");
INSERT INTO atbNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nàng gi, ngá ulhum má xû a but byî wú, yhang kúm gi, ngá é hkyî má nàm ngón é mura but byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Haû su mù, ngò, nàng lé taí lé, haû myiwe gi, je chyitdap luî, yhang wó é yubak myo myo lé hkyut pyám byî é hui bê. Shau za mara hkyut pyám byî é hui sû gi, shau za chyitdap sû nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesuq gi, myiwe haú lé le, \"Ngò, náng é yubak mara hkyut pyám byi bê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Rahá zung tô é bang gi, \"Yubak mara lháng wó hkyut pyám byi sû, shí yuq gi, ó wá nghut lhê lhú?\" ga luî, myit nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuq gi, \"Náng é lumjíng myit èq nang lé hkyi yù bê, ngón za ló aq hkoi.\" ga luî, myiwe haû lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hau htâng hkâ-myháng a myáng má, Yesuq gi, Garai Gasâng é mingdán hkyô eq sêng é gabú danglù lé taî kyo uchyang, Yhâng é lagyo raxe í yuq eq rahá za, rawa htâng rawà jé e ló ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hau htoq agó, nat gang dap é mai le, nòhpyo mai le Yesuq èq lhoq ge yu é myiwe wuì, nat nyhit nat lhoq htoq pyám byi huî é, Magadalaq wà mâ é Mariq le, ");
INSERT INTO atbNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herut é ikun zum sû Kuza é yhumsîng myhí Yoanaq le, Susannaq le, gotû myiwe wuì myo myo le, Yesuq eq rahá nghut akô. Haú bang gi, yhumsîng wó du é í Yesuq eq lagyô pé lé byi zo byi huq nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wà hkang wà mó mâ é bang gi, Yesuq chyáng zup zîng lé lo bùm kômù shiwa byù moq mó zup míng tô é hkûn, Yesuq dangtú dông taî kyô é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"Kyô hkyó sû rayuq gi, kyôshi san râ ga htoq e ló ri. Yhang, kyôshi sân kat é hkûn, ra-am gi, hkyô má gyó ang mù, byu èq záng nâng pyeq pyâm lhê, maulat nghoq pê èq hte zo pyâm lhê dut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ra-am gi, luqgok yò má gyó ang mù, yuq htoq lo é hkûn, myigùng a teq é yanmai nyhuî shi byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ra-am gi, zugyóm hkaû má gyó ang luî, zubyap eq rahá yuq htoq lô mù, wup pyâm é hui bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nghut kôlhang, ra-am gi, myìhpún bo é jang má gyó ang mù, yuq kô lò jáng, rashô tú myô jat lo ri.\" ga taî ri. Yhang haû su ga taî nyi é hkûn, \"Gyô yù râ nohkyap dap sû gi, gyô yù sháng gaq!\" ga le, htê mó èq taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Haú hkûn, Yhâng é chángzô pé gi, dangtú shî hai lichyúm nghut lhê lhú ga, Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yhang gi, \"Garai Gasâng é mingdán eq sêng é sê gyo wuî é hkyô pé lé sê gyo râ ahko ahkáng, nungmoq lé byî to bê. Nghut kôlhang, góbâng matú gi, 'Wú to kôlhang, a myàng kó sháng, gyô nyì kôlhang, a sê gyo kó sháng.' nghû, ngò dangtú dông taî lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ahkui lhê é dangtú shi é lichyúm gi, îsu nghut ri: kyôshi gi, Garai Gasâng é mungdang nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hkyô má gyó âng é kyôshi gi, haî eq wuí lhê lhú gâ le, haû mungdang lé byu pé wó gyô é htâng má, lumjíng é má le, hkyi yu é má le, a jé kó sháng gaq ga luî, yhangmoq é i-myit hkaû mai nat Tsadán èq mungdang haû lé, lé yu pyâm é hui bang eq wuí lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Luqgok yò pé má gyó âng é kyôshi gi, haî eq wuí lhê lhú gâ le, haû mungdang lé wó gyo jáng, gabú myit èq hap yù kôlhang, amyit a wó chín mù, rayoq rabun za lumjíng luî, gunglaú huî é nyí má, dum htak ló byuq é bang eq wuí lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zugyóm má gyó âng é kyôshi gi, haî eq wuí lhê lhú gâ le, haû mungdang lé gyô yù luî, yhumsing é asak dui e ló é hkyô má, shí ipyat lhê é myit wui myit hke hkyô, ngùn zè sutgan eq mingkan ngón hkyô má myup byuq luî, mo é ashi a zuî é bang eq wuí lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hpún bo é myigùng má gyó é kyôshi kúm gi, haî eq wuí lhê lhú gâ le, haû mungdang lé lhumzui luî ge é i-myit èq ban gyô yù mù, ging tíng shoq zuî zìng luî, wó jân é i-myit èq ashi zuî é bang eq wuí lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Myibung lé tap mù, aû èq nghop tô é le, yhupchong ô má tô tô é le, ó a kut wú kó. Nghut kôlhang, wang lé lô bang myoq wó myâng râ matú kúm gi, tsungjang má tsung to to chyat kut akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hkâsu mù gâ le, a htoqzê loshoq haq tô é zè haî le a joq, a sé a byông htoq loshoq wó zaú tô é zè le haî a joq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Haû mù luî, nungmoq hkâsu wó gyô yu é hkyô lé sidiq nyì keq, haî mù gâ le, wó to sû lé gi, jat byi shirâ, a wó su chyáng mai kúm gi, yhang wó to bûn é mâ é lé lháng, yu pyám byi shirâ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Haú hkûn, Yesuq é yhângnu eq yhanggu pé gi, Yhâng chyáng lé lô kô le, shiwa byu pé lûm chyûn chyap to kômù, Yhâng chyáng a wó wang ê kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Haú hkûn, Yhang lé, \"Náng nu eq nunggu pé gi, nang lé hui naû luî, shinggan má láng yap bum akô.\" ga taî kyo akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesuq gi, yhangmoq lé, \"Garai Gasâng é mungdang lé gyô yù luî, châng é bang gi, Ngá nu eq Ngá gû pé nghut akô.\" ga luî, yhangmoq lé tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ra-nyí lé, Yesuq gi, Yhâng é chángzô pé lé, \"Nga-nhúng nhông he hpoq shut dap e ló sháng.\" ga taí luî, lhaî má wàng mù gû dap e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yhangmoq gû dap e ló é hkûn lé, Yesuq gi, yhup myhî tô ri. Haú u lé, nhông haú má laidun mó lò luî, lhaî má wuì byíng lô mù, yhangmoq myup shî râ su dut lò nyì bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Haû mù, yhangmoq gi, Yesuq chyáng huî ê luî, Yhang lé nhaû pun mù, \"Yhumsîng ê, Yhumsîng ê, nga-nhúng myup ló nyi ri.\" ga taî akô. Haú hkûn, Yhang toq luî, laidun eq wuìlhêng pé lé tân kat jáng, haú pé gi, zim za dut ló byuq bê. ");
INSERT INTO atbNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Haû mù, Yesuq gi, \"Nungmoq é lumjíng myit gi, hkâmá nghut akô lhú?\" ga luî, yhangmoq lé myî ri. Yhangmoq kúm gi, gyuq maú byuq bùm kôluî, \"Shí yuq gi, hkasû é byù nghut lhê lhà? Yhang hkunmó hkyó jáng, laì eq wuìlhêng pé lháng gyo byi ri-nhung!\" ga luî, rayuq eq rayuq myî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hau htâng, yhangmoq gi, Galile mau tû tap mâ é Gerase byu pê é mau má jé dap e ló bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesuq kong shut doq ló le, haú wâ mâ é nat gang dap é sû rayuq gi, Yhang lé hui ri. Haú yuq gi, yhûm má le a nyi é za, mebu a dap é, lupdùng má myáng myáng nyi nyì sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Haú yuq gi, Yesuq lé myàng jáng, wut garu luî, yhâng é hkyî wang má paî gop to mù, \"Myhang htâng é Garaî Yhangzo Yesuq ê, Nàng gi, ngò eq haî séng lhê lhú? Ngo lé a zing-ri râ matú, ngò nang lé dûng nyi lhê.\" ga luî, htê mó èq taî garû nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hkâsu mù gâ le, Yesuq gi, agè ashop é nat lé haú yuq gùng mai htoq ló râ matú, tân pyâm é yanmai nghut ri. Byù haú yuq lé nat gâng èq adàm dàm wang júng hkangmó, loq eq hkyî má toqjâng tuî èq tuî shung, kyum xâng tô é eq, zúng tô é nghut kôlhang, lâng hpyit pyám pyám kut é htoq ago, nat gâng èq yhang lé yoso hkaû shut lângmhap yù yù kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuq gi, yhang lé, \"Náng myîng haî gâ lhê?\" ga myî kat é hkûn, yhang gi, \"Legio gâ lhê.\" ga tû taî ri. Haî mù gâ le, yhâng chyáng nat gang myo myo wang lúng tô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nat jùm gi, yhangmoq lé nik dik htûm é Lasang-dong shut a kôn kat râ matú, Yesuq lé chôm dûng nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Haú u lé, waq rajùm mó gi, bùm yàm má dû but zô nyi bum akô nghut ri. Haû mù, yhangmoq gi, waq pê chyáng wàng nhâng laq ga, Yesuq lé ahkáng dum dung dung kut kojáng, Yesuq gi, yhangmoq lé ahkáng byi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Haû mù luî, nat gang jùm gi, byù haú yuq chyáng mai htoq ló kôluî, waq pê chyáng wàng byuq bekô nghut ri. Haú hkûn, waq haú jûm gi, gampyoq mai nhông hkaû shut rut din yán wang ló kôluî, myup shi byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Waq zúng bang gi, haû su dut é lé myàng jáng, hpang din ló kômù, myuq hkaû mâ é bang eq awui ayàm mâ é bang lé ló taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Haû mù, wó gyô é bang gi, haú hkyô lé wú râ matú htoq lé lo akô. Yhangmoq gi, Yesuq chyáng jé lé kô é hkûn, nat gang htoq byuq hui sû, Yesuq é hkyî wang má mebu wut to luî, byù gè rayuq su zùng to láng é lé myàng kômù, gyuq dan bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nat dap sû lé hkâsu kut luî lhoq ge yu é hkyô lé myang é bang gi, góbang lé taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Haú hkûn, Gerase byu pê é mau mâ é lhunglhâng bang gi, gyuq dan dik kôluî, Yesuq lé yhangmoq é mau mai htoq ló byuq râ matú, chôm dûng tôngbán akô. Haû mù luî, Yesuq gi, taû ló byuq râ matú lhaî má wàng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nat htoq byuq huî é sû gi, Yesuq htâng cháng râ matú, Yesuq lé dûng tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nghut kôlhang, Yesuq gi, \"Nàng, yhûm shut sheq ló mù, Garai Gasang, nang lé hkâ-í kut byi bê hkyô lé, ló taî kyo aq.\" ga luî, yhang lé ló nhâng bê nghut ri. Haú hkûn, yhang htoq ló mù, Yesuq yhang lé hkâ-í kut byi bê hkyô lé, haú wà rawà bang lé ló taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ahkuî, Galile byu pé gi, Yesuq dum taû lò râ lé láng nyî kô é nghut mù, Yhang dum taû gû dap lo é hkûn gabú myit eq lhom te yu akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Haú hkûn, Ya-iruq gâ é tarajong má up sû rayuq gi, jé lé lô mù, Yesuq é hkyî wang má hkyihput htuq luî, yhâng yhûm má lé râ matú ji nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hkâsu mù gâ le, raxe í zân bò bê é, yhangzo byizo te gi, shi ló nyi é yanmai nghut ri. Haû mù, Yesuq cháng e ló le, shiwa byu pé gi, Yhang lé záng htûng lo bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Haú u lé, raxe í zân sui yuî luî ngunzè lhunglháng ban pyám shoq chi sará pê chyáng yâ wú kôlhang, hká yuq le a wó yâ gè byi é myiwe myhí rayuq le haú hkaû má bo tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Myiwe haû gi, Yesuq é nunghtáng má huî lé mù, Yhâng é bushi htâng má ê záng kat eq, suí yui é ana gi, ge byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Haú hkûn, Yesuq gi, \"Ngo lé, ó yuq záng bê lhú?\" ga luî myi jáng, lhunglhâng bang gi, a sé ga he nyi bùm kô é hkûn lé, Petruq gi, \"Yhumsîng ê, shiwa byu pé gi, náng é lhînghkyuq mai náng chyáng chyîn chyap wang lo bùm kô é yanmai, nang lé záng bekô râ nghut lhê?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesuq gi, \"Byù rayuq ngo lé lé záng mù, ngá chyáng mâ é hpungwup a-tsam htoq ló é lé, ngò châng sé kat ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Haû jáng, myiwe myhí haû gi, yhang a wó haq zaú to lô é hkyô lé sé jáng, req req nán lé lô mù, Yesuq é hkyî wang má ngóm gop kat luî, haî mù Yhang lé záng é hkyô eq, hká dông ge ló byuq é hkyô pé lé, shiwa byù banshoq bâng é hí má Yesuq lé taî kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesuq gi, \"Ngá zo ê, náng é lumjíng myit gi, nang lé lhoq gê byi bê nghut ri, ngón za ló aq hkoi!\" ga luî, myiwe haû lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuq gi, dang ru taî nyi ashî hkûn, tarajong má up sû Ya-iruq é yhûm mai byù rayuq jé lé lô luî, \"Nung zo gi, shi byuq bê, haû sará lé hkâlhoq hkyik nyî lo.\" ga luî, Ya-iruq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuq gi, dang haû lé wó gyo jáng, \"Hkâgyuq, za lumjíng aq, haû jáng, yhang ge byuq râ nghut lhê.\" ga luî, Ya-iruq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesuq gi, Ya-iruq é yhûm má jé é hkûn lé, Petruq, Yohan, Yakuq, eq haû myiwe zô é yhângnu eq yhângwa mai lai luî, yhûm haú má, ó lé le a wàng nhâng kut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Haú u lé, lhunglhâng bang zoshâng hau é yanmai, ngaubyi ngau-nhap èq yón nyi akô. Yesuq kúm gi, \"Hkâ-ngaû kó, yhang shi byuq é a nghut, yhup myhî tô é sheq ru nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Zoshâng gi, shi byuq bê lé yhangmoq sé kôluî, yhangmoq gi, Yesuq lé wuìzuì kut pyám byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yhang kúm gi, myiwe zo hau é loq má zuî to mù, \"Zoshâng ê, toq aq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Haû mù luî, yhâng woi-nyí dum taû wàng mù, haú hkûn jáng toq yap ri. Haû jáng, Yesuq gi, zoshâng haû lé zôjung byi keq, ga yhangmoq lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Haû myiwe zô é yhângnu eq yhângwa nhik gi, gyai maú byuq akô. Nghut kôlhang, Yesuq gi, haû dut é hkyô ó lé le a taî kyo râ matú, yhangnhik lé taí hkûm tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuq gi, haû lagyo raxe í yuq lé wut yù mù, nat gang banshoq lé wó hkat htoq pyám râ matú eq, nolì nojàng wó lhoq gê râ matú, yhangmoq lé wum-o a-tsam eq ahko ahkáng byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hau htâng má, Garai Gasâng é mingdán hkyô hko kyo râ eq, nòhpyo lhoq gê byi râ matú nhang htoq kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesuq gi, yhangmoq lé, \"Hkyowui é matú, dumbáng, etap, zoshuq, ngùn eq, bu htaí lháng hkâwûn hkâchûng kó. ");
INSERT INTO atbNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nungmoq hká yhûm má wàng kôlhang, haú wâ mai dum htoq ló é buinyì jé shoq, haú yhûm má za nyi nyi keq. ");
INSERT INTO atbNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nungmoq lé a lhom hap yu é bang lé gi, yhangmoq é wà mai htoq ló é hkûn, nungmoq lé a lhom hap yu é saksé dut sháng gaq, nungmoq é hkyiwa má dap é hpuilhaû lé yhangmoq é myoq hí má ko hkyô pyâm to keq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Haû mù, yhangmoq gi, htoq e ló luî, wà hkang wà mó má haû gabú danglù hko kyo uchyang, hká jé hkâmá nòhpyo lhoq gê byî wún akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Haû su dut é hkyô banshoq lé, mauzau Herut wó gyô yù luî myit wuî nyi ri. Hkâsu mù gâ le, ra-am gi, Yohan shi é mai dum dui toq lô bê ga, ");
INSERT INTO atbNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ra-am gi, Eliyaq dum pô htoq lo ri ga, haû mai, ra-am gi, hí hpyang lhê é myiqhtoi rayuq yuq dum dui toq lô bê ga luî, taî bùm kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herut gi, \"Yohan é ulhum lé, ngò hpyit pyám nhâng bê, nghut kôlhang, shî í wá taî byông bùm kô é gi, ó wá nghut lhê lhú?\" ga luî, Yesuq lé myàng shoq ga ho nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lagyô pé dum taû lo é hkûn, yhangmoq kut laî lo é hkyô pé, Yesuq lé taî kyô akô. Haú hkûn, Yesuq gi, yhangmoq lé shuî chûng mù, Bet-saida gâ é wà mó shut tsik za e ló byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Shiwa byu pé gi, haú hkyô lé châng sé kômù, Yhâng htâng châng e ló akô. Yesuq le yhangmoq lé lhom hap yù mù, Garai Gasâng é mingdán hkyô lé taî kyo luî, nòhpyo gè naù bang lé, lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Buigyùm zó má, lagyo raxe í yuq gi, Yhâng chyáng huî ê mù, \"Haû shiwa byu pé lé, awui ayàm mâ é yhûm pé eq wà pé má ló mù, zoshuq hô zo luî ló yhup kó sháng gaq, ló nhâng aq. Hkâsu mù gâ le, ahkuî nga-nhúng gi, yoso má nghut nyi ri.\" ga luî, Yhang lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Haú hkûn, Yesuq gi, \"Nungmoq, yhangmoq lé rajung jung byi tso keq.\" ga tû taî ri. Yhangmoq gi, \"Shî myhô bang lé tso râ zoshuq a ê wui le gi, ngamoq chyáng muk-yo muk ngo long eq ngozo í du mai lai luî, haî le a wó nghut ri.\" ga taî akô. (Hkâsu mù gâ le, yuqgè wuì baú lháng ngo hkyîng kô nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nghut kôlhang, Yesuq gi, \"Shí bang lé rahpúng má ngo xê xê kô kut luî, zùng nhang to keq.\" ga luî, Yhâng e chángzô pé lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yhangmoq lé Yesuq taî é eq rajung za, banshoq bang lé zùng nhang to bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Haú hkûn, Yesuq gi, haû muk ngo long eq ngozo í du lé yù mù, mauhkûng shut tu wú to luî, jeju ban hkya-on jáng, haú lé ajap jap hpé luî, shiwa byu pé lé, châng to byi râ matú, Yhâng é chángzô pé lé byi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Haú hkûn, yhangmoq banshoq bang zô gyî bùm kô é htâng má, haû chángzô pé gi, zô myhit tô é pé lé, raxe í mung byíng shoq wó guq tsîng yu ashî kô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Radàm lé, Yesuq gi, Yhang baú kyûdûng nyi é hkûn, chángzô pé le, Yhang eq rahá nghut akô. Hau htâng, Yhang gi, yhangmoq lé, \"Shiwa byu pé gi, ngo lé ó yuq nghut lhê ga, taî akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","\"Ra-am gi, Wui-myhup Sará Yohan ga; góbang gi, Eliyaq ga; dum ra-am gi, hí hpyang lhê é myiqhtoi rayuq yuq dum dui toq lo é nghut ri ga, taî akô.\" ga luî, yhangmoq tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dum, Yhang gi, yhangmoq lé, \"Nghut kôlhang, nungmoq gi, ngo lé ó yuq nghut lhê nghu akô lhú?\" ga myî ri. Haú hkûn, Petruq gi, \"Nàng gi, Garai Gasang nhâng byî é Hkrisduq nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Shí hkyô ó lé le a taî kyo sháng gaq ga, Yesuq, yhangmoq lé taî hkûm pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Haû mù, Yhang gi, \"Haû Byu Yhangzo gi, zing-rî é myo myo hui zo luî, suwún wuî, hkyangjong agyi pé, tarâ sará pê èq he-ngik pyâm é hui mù, sat pyâm é hui ra râ nghut lhê, hau htâng sum nyí nghû râ buinyì má, lhoq toq yu é hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hau htâng, banshoq bang lé Yhang dum xoq taî é gi, \"Ngá htâng cháng naû sû ó yuq nghut kôle, yhumsing gùng yhumsîng he-ngik pyám mù, nyí wuî yhumsing é tapzîng lé waq chûng luî, cháng ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hkâsu mù gâ le, yhumsing é asak lé hkyi yù naù sû ó yuq nghut kôle, asak sum râ nghut lhê; nghut kôlhang, Ngá é yanmai, yhumsing é asak sum pyâm é sû kúm gi, asak hkyi yu é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Byù gi, mingkan gón lé wó sing to kôlhang, yhumsing é asak woi-nyí sûm byuq é nghut le gi, yhang é matú, haî akyû bò râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ngò eq Ngá é dang lé, lhom hap yù râ lé hoq é sû ó yuq lé le, haû Byu Yhangzo gi, yhumsing é hpungwup shingkang eq, Yhâng Wâ é hpungwup shingkang, haû chyoiyúng maumang lagyô pê é hpungwup shingkâng èq jé lé é hkûn, hoq pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngò, nungmoq lé teng za taí kôlé, shi má yap tô é bang ra-am gi, Garai Gasâng é mingdán lé a myang é za shî kó râ a nghut.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dang haû taî é htâng, shit nyí kô nghut jáng, Yhang gi, kyûdung râ ga Petruq, Yohan, Yakuq pé lé shuî chûng mù, bùm shut doq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kyû dûng nyì le, Yesuq é myoqdong gi, ihpyô isâm htaî lò mù, Yhâng é mebu gi, lhap su duq bang lo ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Haú hkûn, wú keq, Mosheq eq Eliyaq gi, hpungwup shingkang eq htoq lé lô luî, Yesuq eq dáng nyo lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yhangmoq gi, Garai Gasang myit tô é hkyô Yerusalem wà mó má Yesuq shî hkâm é dông mai dik lò râ nghut é hkyô lé taî lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petruq eq yhâng luzúm nhik gi, yhup mui nyi akô; nghut kôlhang, yhangmoq bûn lo é hkûn lé, Yesuq é hpungwup shingkang lé le, Yhang eq rahá yap to su nhik lé le, myang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Haû nhik Yesuq chyáng mai gâng ló nyi é hkûn, Petruq gi, Yesuq lé, \"Yhumsîng ê, shí jowò má nga-nhúng nyi le ge ri, haû mù, Nàng é matú ralhum, Mosheq é matú ralhum, Eliyaq é matú ralhum kut, ngamoq lé, zúm sûm lhum saí nhâng laq.\" ga taî kat kôlhang, yhang haî taî nyi é lé, yhang a sé. ");
INSERT INTO atbNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petruq dang taî nyi ashî hkûn lé, mhut jé mù, yhangmoq lé htup zíng lo nyi ri. Mhut haû htup lo nyi é yanmai, yhangmoq gi, gyuq byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Haû mhut hkaû mai htoq lo é htê gi, \"Shí yuq gi, Ngá zo nghut lhê; Ngò hkyin yu é Sû le nghut lhê; Yhâng é dang gyo keq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dang htê haû zim jáng, Yesuq yhang baú nyi tô é lé, yhangmoq myang akô. Yhangmoq myang é hkyô lé, buinyì haú bun haú yoq má, ó lé le a taî kyô é zim za nyi byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hau htâng nyí, yhangmoq bùm haû mai gyó ló kô le, byù moq mó gi, Yesuq lé lhom te yu akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Haú hkûn, byù hpúng haú mâ é byù rayuq wut garû htoq ló é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","\"Sará ê, wú aq, ngá é zo te yuqzo gi, nat wang júng mù dàn so dàn loq garû lo lhê, guttsû gi, agut gut dut shoq langhtân nhang lo lhê kut mù, nat gi, yhang lé gyai myáng shoq zing-rî yù yù kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nat haû lé hkat pyám byi kó laq nghû luî, Náng é chángzô pé lé ngò dûng wú kôlhang, yhangmoq a wó hkat pyám byi kó. Haû mù, ngá zo lé lhoq gê byi râ matú, ngò gi, nang lé gyai myit lum é eq dûng kat lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Haû mù luî, Yesuq gi, \"Lumjíng myit a bo é eq agè ashop é amyû pé ê, Ngò gi, hkâ-myháng jé shoq nungmoq eq rahá nyì mù, wó jân nyì râ lhú? Nung zo lé, shí shut shuî lé lô aq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Zoshâng haû, lé lo nyi le lháng, nat gang gi, yhang lé lhoq lhêng to mù langhtân nhang ashî. Yesuq kúm gi, haû agè ashop é nat lé tân kat luî, zoshâng haú lé lhoq gê byi mù, yhâng wa lé dum ap byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nyì mi-nyì gi, Garai Gasâng é kô dik é hpungwup a-tsam lé maú hong nyi bum akô. Lhunglhâng bang gi, Yesuq kut é muzó haû lé maú nyi bùm kô le, Yesuq gi, ");
INSERT INTO atbNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"Haû Byu Yhangzo gi, byu pê é loq má ap pyâm é hui zo râ nghut lhê. Dang shí hkun lé nungmoq é no má rago gyô wun to keq.\" ga luî, chángzô pé lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yhangmoq kúm gi, dang haú lé a sê gyo kó, hkâsu mù ga le, haû gi, yhangmoq é matú a sê gyo sháng gaq ga luî, nghop tô ashî yanmai nghut ri. Dang hau é lichyúm lé, Yesuq chyáng yhangmoq a wám myi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hau htâng, lagyô pé gi, hká yuq sheq, kô dik sû nghut lhê lhú ga, rayuq eq rayuq taî myíng myô lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuq kúm gi, yhangmoq é unghkaû má myit nyi é hkyô lé sé byi luî, zoshâng rayuq lé shuî yù mù, Yhâng nàm má shap to luî, ");
INSERT INTO atbNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","\"Shî zoshâng lé Ngá é myìng mai hap sû ó yuq nghut kôle, Ngo lé hap yu é sû nghut bê; Ngo lé hap yù sû ó yuq nghut kôle, haû Ngo lé nhang kat é Sû lé hap yu é le nghut lhê. Haû mù luî, nungmoq banshoq má, je tiq sû gi, je ko sû nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Haú hkûn, Yohan gi, \"Yhumsîng ê, Náng é myìng láng luî, nat gâng pé lé hkat pyám byî wún é byù rayuq lé, ngamoq myang ri. Yhang gi, ngamoq chyáng a lòm sû nghut é yanmai, yhang lé ngamoq hkûm pyâm é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesuq kúm gi, \"Yhang lé hkâhkúm kó, nungmoq é gyè hkyam shut a nyì sû gi, nungmoq é hkyam shut nyì sû nghut lhê.\" ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ahkuî, Yesuq gi, Yhang lé mauhkûng shut shuî toq yû râ buinyì chyâng lò bê nghut mù, Yerusalem wà mó shut ê râ lé myit hpyit to luî, Yhâng é hí má lagyo nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lagyo haú bang gi, Yhâng matú râ é hkyô lajang láng râ ga, Samariq wà rawà má wang ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nghut kôlhang, Yesuq gi, Yerusalem wà mó shut laî e ló é sû nghut é yanmai, haú wâ bang gi, Yhang lé a lhom hap yù kó. ");
INSERT INTO atbNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Haú hkûn, lagyo Yakuq eq Yohan nhik gi, haû lé myàng jáng, \"Yhumsîng ê, yhangmoq lé lhoq htên pyám râ matú, ngá-nhik mauhkûng mai myi wut hkyó le, a gè lhú?\" ga luî, Yesuq lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yhang kúm gi, lhing wú luî yhangnhik lé, tân pyâm ri, ");
INSERT INTO atbNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","haû mù luî, yhangmoq gi, gó wâ shut e ló byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yhangmoq haú hkyô má e ló kô le, byù rayuq gi, \"Nàng hká e le hká ngò cháng râ.\" ga luî, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuq gi, haú yuq lé, \"Wamhkuî pé gi, hkyûng wó akô, nghoq pé le, nghoqsut wó akô. Nghut kôlhang, haû Byu Yhangzo gi, ulhum to jang lháng a wó é nghut ri.\" ga taî pyám ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dum rayuq lé, \"Ngá htâng cháng aq.\" ga taí jáng, haú yuq gi, \"Yhumsîng ê, ngá wa lé, ló yhûm pyám râ ahkáng hí byi shi laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuq gi, yhang lé, \"Shî bê bang gi, shî bê bang yhangchang yhûm lhum kó sháng gaq; nghut kôlhang, nàng gi, Garai Gasâng é mingdán hkyô lé, ê hko kyo aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Byù rayuq dum, Yhang lé, \"Yhumsîng ê, ngò le náng htâng cháng râ, nghut kôlhang, ngá yhumbyù lé hí hkyang ló shit to râ ahkáng byi shi laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuq gi, \"Yò hpuq li zui mù htâng shut lhing wú sû ó yuq nghut kôlhang, Garai Gasâng é mingdán eq a gingdán.\" ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hau htâng má, Yhumsîng gi, gotû chángzô pé nyhit xê yuq lé hkyin yù mù, Yhang e ló râ wà eq jowò hkangmó shut í yuq razúm zúm kut luî, Yhâng é hí má ê nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesuq gi, yhangmoq lé, \"Kyô shû yù râ myo shoq joq kôlhang, mû zui râ byù gi, shaû nyi ri. Haû mù, haû kyô Yhumsîng lé, Yhâng é kyô yò má, kyô shu byù myo myo nhâng byi râ matú, dung keq. ");
INSERT INTO atbNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nungmoq e ló keq! Wamhkui hpúng má nhang hâng kat é sau zô pé lé su, Ngò, nungmoq lé nhang kat é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngùn htûng eq, etap, hkyî-tsung pé hkâyu chûng kó, hkyô má ó lé le hkâshichyên kûn nyì kó. ");
INSERT INTO atbNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nungmoq gi, hká yhûm má wàng e ló kô le, 'Shi yhûm nguingón nyî sháng gaq.' nghû luî, hí taí keq. ");
INSERT INTO atbNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Haú yhûm má nguingón hkyô eq gingdán sû nyi é nghut le gi, nguingón hkyô haû gi, haú yuq é ahtoq má joq to râ nghut lhê. Haû a nghut jáng, nguingón hkyô haû gi, nungmoq chyáng dum taû lo byuq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Haú yhûm má nyi to mù, yhangmoq haî byî le haî zo haî shuq keq; hkâsu mù gâ le, mû zui sû gi, zuihpau wó yû gíng lhê; haû mù, nungmoq rayhum htâng rayhûm hkâhtot nyi wún kó. ");
INSERT INTO atbNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nungmoq hká wà má wang ló kôlhang, yhangmoq lhom hap yù kô é nghut le gi, nungmoq é hí má yhangmoq htung to byî é zoshuq lé, zo keq, shuq keq. ");
INSERT INTO atbNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Haú mâ é nò bang lé lhoq gê byi mù, 'Garai Gasâng é mingdán gi, nungmoq eq chyâng lò bê nghut ri.' nghû luî, yhangmoq lé taî kyo keq. ");
INSERT INTO atbNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nghut kôlhang, nungmoq hká wà má wang ló kô le, yhangmoq a lhom hap yu é nghut le gi, haú wâ mâ é hkyô mó má htoq ê mù, ");
INSERT INTO atbNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Ngamoq é hkyî má dap tô é nungmoq wà mâ é hpuilhaû lháng, nungmoq lé hkyang pû tsô nyì râ matú ngamoq ko hkyô pyâm to byi bê. Nghut kôlhang, Garai Gasâng é mingdán gi, chyâng lò bê hkyô lé, sé to keq.' nghû luî taí keq. ");
INSERT INTO atbNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngò, nungmoq lé taí kôlé, haú buinyì lé, haú wâ gi, Sodom wà htoq má je hpuzo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kurazin wà mó ê! Nàng dingnyé wó ri! Bet-saida wà mó ê! Nàng dingnyé wó ri! Nungmoq chyáng lé kut shit é laklaí kumlhá pé lé, Turuq myuq eq Sidun myuq má kut shit é ru nghut le gi, yhangmoq, noq noq mai myit lhîng mù, jimê tû wut lhê, myiwap kyaq gyûn lhê kut zung ngûng to bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Haû mù, tarâ jéyáng é nyí jé jáng, nungnhik gi, Turuq myuq eq Sidun myuq htoq má je hpuzo kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dum mù, Kaperna-um wà nàng ê, nàng gi, mauhkûng jé shoq waq toq é hui râ lhú? A nghut, mosumhkung má sheq gyó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hau htâng má, chángzô pé lé dum xoq taî é gi, \"Nungmoq é dang gyo sû gi, ngá é dang gyo sû le nghut bê; nungmoq lé he-ngik é sû gi, ngo lé le he-ngik é sû nghut bê; ngo lé he-ngik é sû gi, ngo lé nhang kat sû lé le, he-ngik é sû nghut bê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hau htâng, haû chángzo nyhit xê yuq gi, gabú myit èq dum taû lò mù, \"Yhumsîng ê, náng é myìng lé lang jáng, nat gâng pé lháng ngamoq é dang lé gyô bum akô.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Haû su ga taí kôjáng, Yesuq tû taî é gi, \"Tsadán gi, mauhkûng htoq mai lhap hpyat é su byit gyó lo é lé ngò myang kat bê. ");
INSERT INTO atbNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wú keq! Ngò gi, nungmoq lé, lhangmuì eq gogok pé lé wó nang râ eq gumlau gyè pê é wum-o a-tsam banshoq lé wó ûng râ ahko ahkáng lé byi bê nghut mù luî, hai èq le nungmoq lé wó lhoq hten râ a nghut lo. ");
INSERT INTO atbNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nghut kôlhang, nat pé nungmoq é dang gyô é lé za hkâgabú nyî kó, mauhkûng htoq mâ é asak jihpán laiká buk má nungmoq é myìng bo to bê lé sheq gabú nyî keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Haú u lé, Yesuq gi, Chyoiyúng Woi-nyí má gabú é myit byíng lô mù, \"Mauhkûng eq myigung é Yhumsîng, Âwa ê, Nàng gi, haú pé lé, hpaqchyî byéng-yá bò bang eq myit hpaqchyî sé bâng é hí mai haq nghop to luî, zoshâng wuì lé tûn shit bê nghut é yanmai, Ngò, Nang lé hkya-ôn lhê ô. Nghut bê, Âwa ê, haû gi, Nàng ô nau é hkyô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ngá Wa gi, lhunglháng lé Ngá é loq má ap byi to bê. Garai Gasang Yhangzo ó nghut é gi, Âwa Garai Gasang mai lai luî ó le a sé; Âwa ó nghut é lé le, haû Zo eq haû Zo mai sé nhâng râ matú hkyin yu é bang mai lai luî, ó a sé.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hau htâng má, Yhâng é chángzô pê shut lhing wú luî, yhangmoq lé baú za haq taí kat é gi, \"Nungmoq byu-myàng é hkyô pé lé, myang é myoq pé gi, hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hkâsu mù gâ le, Ngò, nungmoq lé taí kôlé, nungmoq wó myâng, wó gyô é pé lé, myiqhtoî pé eq hkohkam pé myo myo gi, myàng naù gyo naù kôlhang, a wó myâng, a wó gyo kó nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Haú hkûn, wú keq, tarâ sará rayuq gi, toq luî, Yesuq lé, \"Sará ê, ahtum abyuq é asak lé wó yû shoq, ngò hkâsu kut râ râ lhê lhú?\" ga luî, Yhang lé myî chyam wú ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuq gi, \"Mosheq é tarâ má hkâsu ga kâ tô ri lhú? Nàng haû lé hkâsu nghap yu nyi lhê lhú?\" ga luî, yhang lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Haú yuq gi, \"'Haû Yhumsîng náng é Garai Gasang lé, náng é myit nhiklhum banshoq, náng é asak woi-nyí lhum gón, náng é wum-o banshoq, náng myit é hkyô banshoq èq, chyitdap râ lhê;' 'náng gûng lé nàng chyitdap é su, náng é chyangnâm mâ é bang lé le chyitdap aq.'\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuq gi, \"Nàng tû taî é dang jô ri; haû su yhang kut aq, haû jáng nàng gi, asak duì râ nghut lhê.\" ga yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nghut kôlhang, haú yuq gi, yhâng gungdu dingmán é lé, tûn shit naû luî, \"Ngá é chyangnâm mâ é sû gi, ó yuq nghut lhê lhú?\" ga luî, Yesuq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesuq tû taî é gi, \"Byù rayuq gi, Yerusalem wà mó mai Yerihko wà shut gyó ló le, damyaq eq htûng huî ri. Damyaq haú bang gi, yhâng é mebu pé lé hkyut shang pyám byi kôluî, rayúm gyut shoq bat nha mù, aluq shoî shî jáng sheq tô pyâm to kôluî ló byuq bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Haú u lé, hkyangjong rayuq gi, haú hkyô mai laî âng ló le, haû damyaq hui sû lé myàng jáng, koi laî ló byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Haû eq rajung za, Lewiq rayuq le, haû mai laî ló é hkûn, haú yuq lé myàng jáng, koi laî ló byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nghut kôlhang, Samariq byù rayuq le, haû mai laî ló é hkûn, haú yuq leq tô é lé myàng jáng, wú shogyo luî yhâng chyáng huî ê mù, ");
INSERT INTO atbNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","yhâng é dàm má, xû eq tsibyiq wing shoq gyun luî, rago za htup byi mù, yhâng é logúng má, haú yuq lé bún ke luî, bing-yhûm ralhum má jé shoq shuî ló mù, gôn lajang byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Htang nyí lé, yhang gi, haû bing-yhûm yhumsîng lé ngùn Denari í chap shê byi mù, taî é gi, 'Shí yuq lé wú lajang byi laq, yhâng gùng má nàng myo chung záng é banshoq lé ngò dum taû lò jáng, lo xap râ.' gâ ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hau htâng, tarâ sará lé, \"Nàng gi, byù haú bang sum yuq má damyaq huí sû é chyangnâm mâ é dông nghut sû gi, hká yuq nghut râ su ngam ri lhú?\" ga luî, Yesuq myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Haû tarâ sará gi, \"Haú yuq lé shogyo sû nghut ri.\" ga taî ri. Yesuq gi, \"Nàng le haú dông ló kut aq.\" ga luî, yhang lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ahkuî, Yesuq eq Yhâng é chángzô pé hkyô xoq sô e ló kô le, wà rawà má jé wang ló é hkûn, Mahtaq gâ é myiwe rayuq gi, Yesuq lé yhâng yhûm má lhom te yu ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mahtaq gi, Mariq gâ é yhanggu myiwe zo rayuq wó ri. Mariq haû gi, Yhumsîng Yesuq é hkyî wang má zung to mù, Yhang mhoqshit é dang lé gyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mahtaq kúm gi, saí tso saí huq é amû myo luî, gyin bûn nyi ri. Haû mù luî, yhang huî ê mù, \"Yhumsîng ê, ngá gu gi, saí tso saí huq é amû má, ngo lé baú za rap kut tô é lé, nàng a bo myàng byi lhú? Ngo lé, lé garúm sháng gaq, yhang lé taí byi laq.\" ga luî, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Haú hkûn, Yhumsîng gi, \"Mahtaq, Mahtaq, nàng gi, muzó lé za ma nyì mù, myit myo myit chiq é huî nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nghut kôlhang, je ahkyak é hkyô gi, rahkat za nghut lhê. Mariq kúm gi, haû je ge é hkyô lé hkyin yù bê nghut ri. Haû lé yhâng chyáng mai wó yu pyám byi râ a nghut.\" ga luî, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ra-nyí lé, Yesuq gi, jowò rawò má kyûdûng nyi ri. Yhang kyû ban dung jáng, Yhâng é chángzo rayuq gi, \"Yhumsîng ê, Yohan gi, yhâng é chángzô pé lé kyûdung râ hkyô mhoq byî é su, ngamoq lé le mhoq byi laq.\" ga Yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Haú hkûn, Yhang gi, \"Nungmoq kyûdûng le, 'Mauhkûng htoq tsáng myhâng mâ é ngamoq é Âwa ê, Náng é myìng gi, chyoiyúng nyî sháng gaq. Náng é mingdán jé lô sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ngamoq nyí wuî râ é zoshuq lé, ngamoq lé nyí wuî byi laq. ");
INSERT INTO atbNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ngamoq lé shut é byù banshoq bâng é mara lé, ngamoq hkyut pyám byî é yanmai, ngamoq é mara lé le hkyut pyám byi laq. Ngamoq lé, agúng alaú hkyô má hkâwâng nhâng.' nghû keq.\" ga luî, yhangmoq lé mhoqshit ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesuq yhangmoq lé dum taî é gi, \"Dangké, nungmoq chyáng mâ é rayuq sû gi, buinùm wó é nghû sháng, yhang gi, gunggàm yoq má haú yuq chyáng ê luî, 'Buinùm hpó ê, ngo lé muk sûm long byam chyi byî kat laq, ");
INSERT INTO atbNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","haî mù gâ le, ngá buinùm rayuq byìn we mai ngá chyáng jé nyi tô ri. Ngò gi, yhang lé byi tso râ haî le a joq byam dut tô ri.' ga taî é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yhúmhkaû shut mâ é sû gi, 'Ngo lé, hkâlé lhoq hkyik lo, hkum le myhî pyám bê, ngá zoshâng wuì le ngò eq rahá yhupjang má yhup to bekô. Ngò, nang lé haî le a wó toq yû byi lo.' ga tu kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngò, nungmoq lé taí kôlé, buinùm nghut é yanmai za gi, muk a kâm toq byi lo kôlhang, zuq zuq dûng nyi é yanmai, haú yuq lé, yhang ra châ é banshoq toq yû byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Haû mù, ngò, nungmoq lé dum taí kôlé, dung keq, haû jáng, nungmoq lé byi râ nghut lhê; hô keq, haû jáng, nungmoq myàng kó râ nghut lhê; hkum má kok keq, haû jáng, nungmoq lé hpóng byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hkâsu mù gâ le, ó yuq nghut kôle, dung sû wó râ; hô sû myàng râ; hkum kok sû lé gi, hpóng byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nungmoq îwâ pé má, ó yuq wá, yhumsing yhangzo muk dûng le, luqgok byi kó râ lhú? Ngozo dûng le, lhangmuì byi kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woq-ú dûng le, gogok byi kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Agè ashop é bang nungmoq lháng gi, nungmoq é zo wuî lé, ge é chyunghuq dat byi kô le nhîng, mauhkûng htoq tsáng myhâng mâ é nungmoq é Îwa gi, Yhang lé dûng é bang lé, je riyhang haû Chyoiyúng Woi-nyí byi râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Radàm lé, Yesuq gi, byù rayuq lé dang a wó nyô shoq kut tô é nat gang lé, haú yuq chyáng mai hkat htoq pyâm ri. Nat haû htoq ló byuq é htâng má, dang a wó nyô sû gi, dang wó nyo nyi é yanmai, byù moq mó gi, chôm maú byuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nghut kôlhang, yhangmoq chyáng mâ é ra-am gi, \"Yhang gi, nat gâng pê é zau Bezebulaq é wum-o a-tsam èq za, nat gâng pé lé wó hkat pyâm é nghut ri.\" ga taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ra-am le, Yhang lé, mauhkûng mâ é kumlhá tûn shit wú laq ga dûng chyam wú akô. ");
INSERT INTO atbNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesuq kúm yhangmoq myit nyi é hkyô lé sé mù taî é gi, \"Ikun byoq é mingdán hká lhum nghut kôle, hten byuq râ za nghut lhê; haû eq rajung za, ikun byù yhangchang rayuq eq rayuq byoq lhûm é yhûm htu gi, byoq gâng lhum râ za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nat pé le yhangmoq yhangchang byoq gâng lhûm nyì kô é nghut le gi, Tsadán é mingdán gi, hkâsu kut wó gîng to râ lhú? Ngò isu nghu taî é gi, nungmoq ngo lé Bezebulaq é wum-o a-tsâm èq za, nat gâng pé lé hkat pyâm ri ga kô é yanmai nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngò gi, Bezebulaq é wum-ô èq za, nat gâng pé lé hkat htoq é nghut jáng, nungmoq é chángzô pé gi, ó yuq é wum-o a-tsâm èq za, nat gâng pé lé hkat pyám kô é nghut lhê lhú? Haû mù luî, yhangmoq gi, nungmoq lé jéyáng é bang dut bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nghut kôlhang, Ngò gi, Garai Gasâng é wum-ô èq nat gâng pé lé hkat htoq pyâm é nghut jáng, Garai Gasâng é mingdán gi, nungmoq chyáng jé bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Wum-o bo é sû rayuq gi, yhâng é yhûm lé, shâm, lhâm chûng luî zúng tô é nghut jáng, yhâng é sutzè pé gi, rago za wó joq to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nghut kôlhang, yhâng htoq wum je bo é sû lé luî, haú yuq lé, lé zân ung pyâm é nghut le gi, yhang lum tô é shâm, lhâm lé, hkyom yu pyám byi luî, yhâng é sutzè pé lé, gam yu pyám byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ngá hkyam shut a dap sû gi, Ngo lé gyè kut sû nghut lhê. Ngò eq rahá a shuî tsing sû gi, lhoq pyo pyâm é sû nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Haû agè ashop é nat gi, byù rayuq chyáng mai htoq ló mù, kyuq huî é jowò pé má sô yông e ló luî, no râ jowò hkat ho wú le, a myang hô nghut ri. Haú hkûn, yhang gi, 'Ngò nyi laî lo é yhûm má dum taû ló wú râ.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yhang dum taû jé ló wú le, yhûm haû gi, shum pyám mù san za rago dut to láng é lé ló myang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Haû jáng, yhang gi, dum taû ê mù, yhâng htoq je wuî é nat nyhit nat lé shuî lò luî, haú má lo wàng nyi to bekô. Haû mù, haú yuq é nyì yap sâmlai gi, hí lhê htoq má je wuî lò bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Haû su ga, Yesuq taî nyi é hkûn, haû shiwa hpong mâ é, myiwe zo rayuq htê mó o mó èq Yhang lé taî é gi, \"Nang lé wun é ûng wam eq nàng shuq é nauwang gi, hkungsô wó nyi ri ô!\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesuq gi, \"Garai Gasâng é mungdang gyô yù luî châng kut é bang gi, je riyhang hkungsô wó kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Shiwa byu pé jat myô zup zîng lo é hkûn lé, Yesuq taî é gi, \"Shí ipyat lhê é byu pé gi, agè ashop é bang nghut akô. Yhangmoq gi, limik kumlhá dûng nyi bùm kôlhang, Yonaq é kumlhá mai lai luî, gotû haî le tûn shit râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonaq gi, Ninewe wà byù pê hí má kumlhá dut é su, haû Byu Yhangzo gi, shí pyat lhê é byu pê hí má, kumlhá dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Maupyî mâ é hkohkâm myhí gi, maumyî ló htâng é mai lé lô mù, Sholumon é hpaqchyî dang lé, lé gyô yù bê nghut mù, haû tarâ jéyáng é buinyì má, shí ipyat mâ é byu pé eq rahá toq lô luî, yhangmoq lé mara hûn râ nghut lhê. Wú keq, Sholumon htoq ko sû gi, ahkuî shî má jé nyi to bê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninewe wà byu pé gi, Yonaq, mungdang hko kyô é hkûn myit lhîng kô é nghut mù, tarâ jéyáng é buinyì má, shí ipyat eq rahá toq lô luî, yhangmoq lé mara hûn kó râ nghut lhê. Wú keq, Yonaq htoq ko sû gi, ahkuî shí má jé nyi to bê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Myibung lé tuq mù go pyâm é jowò má tô tô é le, mûng eq nghop tô é le, ó a kut wú kó. Nghut kôlhang, wang lé lô bang myoq wó myâng râ matú kúm gi, tsungjang má tsung to to chyat kut akô. ");
INSERT INTO atbNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Náng é myoq gi, náng gungdû é myibung nghut nyi ri. Náng é myoqjí ge é nghut le gi, náng é gungdu gón má maubó byíng mui to râ nghut lhê. Nghut kôlhang, náng myoq a ge é nghut le gi, náng é gungdu gón gi, mauchut tuq dut nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Haû mù, náng chyáng bo é maubó gi, mauchut byuq é, a chut byuq é lé wú nyî aq. Nàng lumjíng é hkyô eq nàng myit é hkyô gi, mauchut tuq a dut sháng gaq, sidiq nyì aq. ");
INSERT INTO atbNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Náng é ragùngdu gón má duqbó é nghut le gi, rawò má le mauchut é jowò a joq é za, myibung nang lé duqbó byî nyi é su, náng gungdu gón má duqbó nyî râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuq haû su ga ban taî é htâng má, Hparishe rayuq gi, yhang eq zang rahá zo râ matú, Yesuq lé ji ri. Haû mù, Yesuq gi, haú yhûm má wang ê mù zang zo râ ga siboî nàm má zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nghut kôlhang, Hparishe wá gi, zang zo râ hí má Yesuq loq a chî é lé, myàng luî maú nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Haû mù luî, Yhumsîng Yesuq yhang lé taî é gi, \"Nungmoq Hparishe pé gi, góm eq zanghkoq lé ahtoq shut za chî yúng nyî kômù, nungmoq é unghkaû má gi, lú zo lú shuq é eq agè ashop é hkyô pé byíng zan tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Byù bâm pé ê, ahte lé le, ahtoq lé le, saí sû gi, Garai Gasang rayuq za nghut é lé, a sé kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nghut kôlhang, ahte má bo é zè pé lé, ra châ é bang lé byî pyám keq; haú hkûn, nungmoq é matú banshoq gi, sân-yúng lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hparishe pé ê, nungmoq gi, dingnyé wó ri, hkâsu mù gâ le, nungmoq gi, gau-tsáng, shingtón pé eq zangxun mhan-haq ajù jù mâ é, xê gambùm ragambùm lé gi, Garai Gasang lé byi nyì kômù, tarâ dingmán é hkyô eq Garai Gasang chyitdap é hkyô lé gi, lhaî pyâm tô akô. Xê gambùm ragambùm byî é lé le cháng luî, tarâ dingmán é hkyô eq Garai Gasang lé chyitdap é hkyô lé le, kut nyî râ lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hparishe pé ê, nungmoq gi, dingnyé wó ri, hkâsu mù gâ le, tarajong pé mâ é ahkyak dik é zùng jang pé lé le, gaì pé má hkunggâ é èq shichyên é dang lé le, nungmoq ô nau nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nungmoq gi, dingnyé wó ri, hkâsu mù gâ le, nungmoq gi, ahkô a dong lo mù, byu pé a sé luî, ahtoq mai sô laî é lupdùng eq du akô.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Haú hkûn, tarâ sará rayuq gi, \"Sará ê, nàng haû su gâ é gi, ngamoq lé le rhoi lhôm nyi é nghut bê.\" ga Yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Haû su ga jáng, Yesuq gi, \"Nungmoq tarâ sará pé le, dingnyé wó ri. Hkâsu mù gâ le, nungmoq gi, byu pé lé, wùn waq râ wuî é noqkuq htûng tarâ wòlai lé wùn nhâng luî, yhumsîng yhang gi, wò haú lé loqnyhuî èq lháng, a bo záng wú kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nungmoq gi, dingnyé wó ri, hkâsu mù gâ le, nungmoq gi, nungmoq é îchyí îwâ pé sat pyâm é myiqhtoî pê é lup lé luptsuq tsuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Haû mù luî, nungmoq gi, nungmoq é îchyí îwa pê é muzó lé, myit bo huî é bang nghut nyi akô. Hkâsu mù gâ le, yhangmoq gi, myiqhtoî pé lé sat pyám mù, nungmoq gi, lup haú pé lé luptsuq tsuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Haû mù luî, Garai Gasang, Yhâng é hpaqchyî byéng-yá mai taî é gi, 'Myiqhtoî pé eq lagyô pé lé, ngò yhangmoq chyáng nhang kat râ nghut lhê; haú bang mâ é ra-am lé gi, yhangmoq lhom sat pyám mù, ra-am lé gi, zing-ri kó râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Haû su mù luî, mau htoq xâng hkûn lhê é, Abelaq é sui mai, hkungga gyap eq noqkuq yhûm gyoro má sat pyám huî é Zahkariq é sui jé shoq, shun pyâm é myiqhtoî pê é sui banshoq bâng é manglat gi, shí pyat mâ é byu pé lé hûn râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ngò, nungmoq lé taí kôlé, manglat haú pé lé gi, shí pyat mâ é byu pé lé, gè gè yhang hûn râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Tarâ sará pé ê, nungmoq gi, dingnyé wó ri, hkâsu mù gâ le, nungmoq gi, byu pé Garai Gasang lé sé ra zoqshi lé yu pyám byi kômù, yhumsîng yhang le a sé, sé naû bang lé le, hkûm zing tô akô nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesuq haû mai htoq ló é hkûn, tarâ sará pé eq Hparishe pé gi, Yhang lé gyè kut mù, Yhâng é dang má mara wó myâng shoq ga, wuî é dangmyi myo myo myi luî, gyám wú nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Haû u, byù hkyîng mun zup zîng lò mù, rayuq eq rayuq lháng záng nâng lhum shoq dut nyi é hkûn, Yesuq, Yhâng é chángzô pé lé taî hi é gi, \"Gegùn labyoq kut é Hparishe pê é múnchi lé koi sidiq pyám keq. ");
INSERT INTO atbNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A byông htoq loshoq wó zaú nghop tô é, haî le a joq râ nghut lhê; a sé loshoq wó haq tô é le, haî a joq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Haû mù luî, nungmoq, mauchut hkaû má haq taî é dang banshoq lé, myoq myàng maubó má wó gyô bùm kó râ nghut lhê. Gok hkaû má, dangsoq soq é lé le, yhumhkûng htoq mai taî pyo bùm bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngá buinùm wuì ê, Ngò, nungmoq lé taí kôlé, gungdu lé za wó sat pyám mù, woi-nyí lé haî le a wó kut é bang lé, hkâgyuq kó. ");
INSERT INTO atbNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nghut kôlhang, nungmoq ó lé za gyuq râ é lé gi, Ngò, nungmoq lé taî kyo kôlé, gungdu lé sat pyâm é htâng má, woi-nyí lé ngaraî ming shut wó hkyô kat pyâm é a-tsam wó sû lé kúm gi, gyuq keq. Nghut bê, Ngò, nungmoq lé taí kôlé, haú yuq lé za, gyuq nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Johkyáng ngo du lé, gyi htingchap í chap èq wó ûng pyâm lhê a nghut kó lhú? Haû johkyáng radu lé lháng, Garai Gasang gi, tô-myhî pyâm é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Garai Gasang gi, nungmoq é ulhum mâ é xâm banshoq lé lháng, nghap to gù nghut lhê. Haû mù, hkâgyuq kó; nungmoq gi, haû johkyáng myo myô htoq má lháng gù je bo é bang nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngò, nungmoq lé taí kôlé, byu pê hí má Ngo lé lhom yín yu é sû ó yuq nghut kôle, Garai Gasâng é maumang lagyô pê é hí má, haû Byu Yhangzo gi, haú yuq lé lhom yín yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nghut kôlhang, byu pê é hí má Ngo lé he-ngik pyâm é sû lé chyaú gi, Garai Gasâng é maumang lagyô pê é hí má, he-ngik pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Haû Byu Yhangzo lé dang dông shut é sû gi, mara hkyut byî é wó hui ra nghut lhê; nghut kôlhang, haû Chyoiyúng Woi-nyí lé rhoî dang taí pyâm é sû gi, mara hkyut byî é hui râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Byu pé nungmoq lé jéyáng râ matú tarajong pé má le, agyì suwún wuî eq ahkáng ayá wó bâng é hí má le, shuî e ló kô é hkûn, hkâsu kut râ lé le, hkâsu nghû tû taí râ lé le, hkâ-myit chiq kó. ");
INSERT INTO atbNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hkâsu mù gâ le, haú u lé yhang, Chyoiyúng Woi-nyí gi, nungmoq hkâsu taí râ hkyô lé mhoqshit byi râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Haú hkûn, shiwa hpúng hkaû mai, byù rayuq gi, \"Sará ê, ngá-nhik tâng wó é muizè pé lé chôm gam lhum râ matú, ngá mang lé bo taí byi laq.\" ga luî, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuq gi, \"Byù nàng ê, nungnhik tang ahtoq má tarâ agyì kut luî, ikun zè gàm byi râ gi, ngo lé ó hkyin tô é lhú?\" ga luî, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesuq yhangmoq lé taî é gi, \"Myoqnoq é hkyô banshoq mai, nungmoq é i-myit lé hkûm zìng luî, koi sidiq nyì keq. Hkâsu mù gâ le, byu é asak gi, agùn agó é sutzè má bo é a nghut.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dangtú ralhum dông mai le, yhangmoq lé Yesuq taî é gi, \"Sahtê rayuq gi, yhâng é yò pé má guqzo muilhum gyaí já ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Haû mù luî, yhâng é unghkaû má myit é gi, 'Ngò hkâsu kut wú râ lhi? Ngá é guqzo muilhum pé lé kat to râ jowò a wó lo dut to bê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dum nghut jáng, yhang gi, 'Ngò îsu kut wú râ abe, ngá é chyî xau pé lé hpyoq pyám luî, je kô é chyî pé lé saí râ nghut lhê. Chyî haú pé má ngá é guqzo muilhum pé eq sutzè banshoq lé, tsîng kat to luî, ");
INSERT INTO atbNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ngá é i-myit lé îsu nghû taí râ, \"I-myit ê, zanwut myáng myáng é matú, zè gè myo myo ngò tsîng to bê. I-myit nàng zim za kut nyì aq hkoi. Zo mù, shuq mù, ngón ngón nyì aq.\" ga' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nghut kôlhang, Garai Gasang gi, 'Byù gò ê, náng é asak lé, hkû-myîn yhang, wup yu pyám byî é nghut jáng, nàng tsing hkong tô é zè pé gi, ó yuq é matú dut râ lhú?' ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Haû eq rajung za, yhumsing é matú sutzè hkong to mù luî, Garai Gasâng é hí má myung nyì sû gi, haú yuq su nghut râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuq, Yhâng é chángzô pé lé dum taî é gi, \"Haû mù luî, Ngò, nungmoq lé taí kôlé, nungmoq é asak matú haî zo haî shuq râ eq nungmoq é gungdû matú haî wut haî tsang râ lé, hkâ-myit chiq kó. ");
INSERT INTO atbNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Asak gi, zoshuq htoq má, gungdu gi, mebû htoq má, je ahkyak lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nghonoq pê é hkyô lé myit wú keq; yhangmoq gi, kyô hkyó kyô shu a kut kó; guqchyî eq sutdek lé a wó kó, nghut kôlhang, Garai Gasang gi, yhangmoq lé, byi tso byi huq nyi lhê. Nungmoq gi, nghoq haú pê htoq má je riyhang hpaudap nyi lhê a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nungmoq má, ó yuq wá, myit chiq é èq, yhumsing é asak lé radúng kô wó jat yù kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Haû su mù luî, tiq dik é hkyô lé lháng, nungmoq a wó kut kô é nhîng, haî mù luî gotû hkyô pé lé, myit myô nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Htutbó ban pé hkâsu kut kô lo é lé, myit wú keq. Haú pé gi, mû le a zui, hkyîng le a duì kó nghut ri. Nghut kôlhang, Ngò, nungmoq lé taî kyo kôlé, Hkohkâm Sholumon hpúng kô dik u lé wut é mebu lháng, ban haû rabó lé a hkyit nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lumjíng myit tiq é bang ê, hkû-nyí joq mù, napmá myihkyóm má dú kat pyám hui râ nghut é yosô mhan pé lé za lháng, Garai Gasang haû su kut hut é nghut le gi, nungmoq lé, je riyhang hut râ a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nungmoq gi, haî zo haî shuq râ lé hkâho nyì kó; haû eq séng luî lé hkâ-myit chiq nyî kó. ");
INSERT INTO atbNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hkâsu mù gâ le, Garai Gasang lé a sé bang gi, haú hkyô banshoq lé châng hkat ho nyi akô; nghut kôlhang, nungmoq é Îwa Garai Gasang gi, haú pé lé nungmoq râ é hkyô, sé byî nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nungmoq kúm gi, Yhâng é mingdán lé ho nyì keq, haû jáng, haú pé, nungmoq lé puq byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sau hpúng zô pé ê, hkâgyuq ko, hkâsu mù gâ le, nungmoq é Îwa Garai Gasang gi, Yhâng é mingdán nungmoq lé byí nau nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nungmoq wó é zè pé lé ûng pyám luî, myùng bang lé byi keq, yhumsing é matú a dat xau a dat wôm é ngunhtûng saí luî, hkau sû lé a jé, manot èq le a wó zô é sutzè lé mauhkûng htoq má hkong to keq. ");
INSERT INTO atbNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hkâsu mù gâ le, náng é sutzè joq jang má, náng é i-myit le jé nyî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nungmoq gi, hpyihit hit luî, (mû zui râ matú rì rì kut to keq); nungmoq é myibung lé tuq to mù, ");
INSERT INTO atbNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","myiháng poî mai dum taû lò luî, hkúm lo kok é, yhumsîng hpó lé radá dâm hkum lhom wó hpông hâng yù shoq, láng tô é dui-nhâng zoshâng wuì su kut nyî keq. ");
INSERT INTO atbNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Haû yhumsîng jé lo le, machya nyì láng é dui-nhâng zoshâng wuì gi, hkungsô wó nyi râ. Hkâsu mù gâ le, ngò, nungmoq lé teng za taí kôlé, haû yhumsîng hpó gi, yhangmoq lé yuq zung to nhâng luî, yhang gi, dui-nhâng zoshâng su hpyihit hit mù, saí tso saí huq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gunggàm yoq lé nghut kôlhang, woq tûn hkûn lé nghut kôlhang, haû su kut machya nyi é lé, yhumsîng hpó lo myang é nghut le gi, dui-nhâng zoshâng haú bang hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yhumsîng hpó rayuq, hká u má hkau sû lé lô râ lé, sê tô é ru nghut le gi, yhang machya nyì luî, yhâng yhûm lé a wó hput htong nhâng râ nghut é lé, bûn sê nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Haû mù, nungmoq le rì rì nghut nyî keq; hkâsu mù gâ le, haû Byu Yhangzo gi, a bûn nùng má jé lé lô râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Haú hkûn, Petruq gi, \"Yhumsîng ê, dangtú shî gi, ngamoq lé za, taî é nghut lhê lhú? Haû a nghut jáng, lhunglhâng bang lé taî é dông nghut lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Haû jáng, Yesuq gi, \"Lumgíng é eq hpaqchyî bo é sùt zum sû gi, hká yuq nghut lhê lhú? Haú yuq gi, yhâng yhumsing é dui-nhâng zoshâng wuì lé ahkyíng jé jáng zoshuq gàm byi râ matú, yhumsîng hpô èq hkyin to sû dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yhumsîng hpó dum taû lo é hkûn, haû su kut nyî láng é dui-nhâng zoshâng gi, hkungsô wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ngò, nungmoq lé teng za taí kôlé, yhumsîng hpó haû gi, yhâng é sutzè banshoq, dui-nhâng zoshâng haú lé ap to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nghut kôlhang, dui-nhâng zoshâng haû gi, yhâng é i-myit unghkaû má, 'Ngá é yhumsîng hpó jé lô râ gyai myáng ashî.' ga myit pyám mù, dui-nhâng zoshâng luzúm wuî myiwe, yuqgè lé nhuq bat é eq, zo yê shuq yê î shuq wut nyi é nghut jáng, ");
INSERT INTO atbNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dui-nhâng zoshâng hau é yhumsîng hpó gi, yhang a myitbyu tô é buinyì eq yhang a sé tô é ahkyíng má jé lô mù, yhang lé jap pyám luî a lumjíng bang eq rahá nyhi pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yhumsîng hpô é i-myit lé sê to kôlhang, yhang ô nau é dông a cháng, rì rì le a hen tô é dui-nhâng zoshâng gi, yhâng yhumsing èq nhuq bat é lé, myo myo hui zo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nghut kôlhang, a sé mù kut shut sû kúm gi, shau za bat é hui râ nghut lhê. Haû eq rajung za, Garai Gasang gi, myo shoq wó yû su chyáng mai, myo shoq dûng yù râ nghut lhê. Myo myo ap byî tô é hui su chyáng mai, je myo shoq dum dûng yù râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ngò jé lé é gi, myigùng htoq má, myi nyé nhâng râ matú nghut lhê. Myi haû dap to láng é nghut le gi, ngò ô nau é hkyô jup byíng bê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nghut kôlhang, ngò hkam yù râ é baptisma rajung joq ashî, haû a hkam yù yù gi, ngò gyai yhang hkâm zo wuî nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ngò jé lé é gi, myidàm htoq má simsaq hkyô byi râ matú nghut nhô ngam akô lhú? Haú dông a nghut, Ngò, nungmoq lé taí kôlé, byu pé lé lhoq pyô lhoq kang râ matú sheq ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Haû su mù, ahkuî mai rayhûm za mâ é byù ngo yuq gi, rayuq eq rayuq yhangmoq yhangchang byoq gâng lhum mù, sum yuq rahú, í yuq rahú, í yuq rahú, sum yuq rahú dut lo bùm bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yhângwa gi, yhâng é yuqzo eq, yuqzo gi, yhângwa eq, yhângnu gi, yhâng é byizo eq, byizo gi, yhângnu eq, yhangmhoí gi, yhâng dumó eq, yhâng dumó gi, yhangmhoí eq kut, ngá é yanmai, rayuq eq rayuq byoq gâng lhûm bùm bekô râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hau htâng shiwa byu pé lé, Yhang taî é gi, \"Nungmoq gi, buiwàng hkyam shut mhut htup é lé myàng jáng, 'Maú wo lò berâ.' ga radá dâm lhaq taí taí mu akô, haû eq rajung za le, dut lò lò mu ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dum nghut jáng, maupyî shut mâ é laì lo le, 'Buì htân berâ.' ga lhaq taí taí mu akô, haû eq rajung za le dut lò lò mu ri. ");
INSERT INTO atbNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gegùn labyoq kut bang ê, nungmoq gi, myigùng eq mauhkung é kumlhá lé, sê gam hkoq yu nyi akô. Haû su nghut kô le nhîng, haî mù luî, shí ipyat mâ é kumlhá lé gi, a sê gam hkoq dut tô akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Haû eq rajung za, haî mù haû dingmán é hkyô lé yhumsîng yhang yhang a wó doqdân yù kô é lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dangké, nang lé yui tsuq sû eq rahá, tarâ agyì wá chyáng e ló le, hkyô má yhang eq ngón shoq byìn hpyé huî yù aq. Haû a nghut jáng, yui yhumsîng gi, nang lé tarâ agyi chyáng ê dé pyám luî, tarâ agyì gi, htóng hkyó su chyáng, nang lé ap pyám luî, yhang gi, nang lé htóng má lhûng pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngò, nang lé taí lé, yuichyîn haû a ban xap xap gi, htóng haû mai nàng wó htoq ló râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Haú hkûn, haú má nyi é byù ra-am gi, mauzau Pilat èq Galile byù ra-am lé sat mù yhangmoq é sui eq yhangmoq nóng jaú é hkungga lé nyhô pyâm é hkyô, Yesuq lé lé taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesuq gi, \"Galile byù haú bang haû su kut hui zo kô é yanmai, yhangmoq gi, gotû Galile byu pé banshoq htoq má, yubak je myô akô nghû, nungmoq myit ngam akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Haû su a nghut! Ngò, nungmoq lé taí kôlé, nungmoq le, myit a lhîng kô é nghut le gi, banshoq bang haû eq rajung za shi hten byuq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Haû htoq agó, Siloam wà mâ é machya gyop gyó luî, nhê sat huî é byù raxe shit yuq gi, Yerusalem wà mó mâ é byù banshoq bang htoq má mara je kô akô nghû, nungmoq myit ngam nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Haû su a nghut! Ngò, nungmoq lé taí kôlé, nungmoq le, myit a lhîng kô é nghut le gi, banshoq bang haû eq rajung za shi hten byuq kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesuq dangtú dông dum taî é gi, \"Byù rayuq gi, yhâng é tsibyiq hkyâm má, maihpáng gâm ragàm hô tô ri. Yhang agàm haú má, ashi ê ho wú le, zui tô é a myàng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Haú hkûn, yhang gi, 'Wú aq, ngò sum zân tup maihpáng gâm haú má ashi ê ho wú le, a myàng nghut ri; haû lé htuq pyám aq. Haî mù, maumyî aha agó kut yuq nhang tô lhê lhú?' ga luî, tsibyiq hkyâm zúng sû lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hkyâm zúng sû gi, 'Yhumsîng ê, hkûzân za gi, yuq tô wú shi sháng gaq, shigâm hau é lhînghkyuq má ngò du lhîng to mù, myìhpún kat luî bóm byi wú shirâ. ");
INSERT INTO atbNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Htang zàn má ashi zuî é nghut le gi, yuq to sháng gaq, ashi a zui é nghut le kúm gi, htuq pyám râ nghut lhê.' ga luî, hkyâm yhumsîng lé tû taî ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bánno buinyì lé, Yesuq gi, tarajong ralhum má, mhoqshit nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Haú hkûn, haú má raxe shit zân tup nat dap luî, gùng loq lhoq hten huî é myiwe rayuq le nyi tô ri. Yhang gi, dàngngóm luî, gungdu ratsuí lháng a wó lhoq nyhâng lô é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuq gi, myiwe haû lé myàng jáng, yhâng chyáng wut yù mù, \"Myiwe myhí ê, nàng, nòhpyo mai gè berâ.\" ga luî, ");
INSERT INTO atbNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","yhâng é ahtoq má loq ke byî ri. Haú hkûn jáng, myiwe haû gi, nyàng za dum wó yap luî, Garai Gasang lé hkya-ôn nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Haû mù, Bánno buinyì lé, Yesuq nòhpyo lhoq gê byî é yanmai, tarajong má up sû gi, wú nhik-yo luî, \"Mû wó zuî é buinyì hkyuq nyí joq tô le, buinyì haú pé má, lé wó lhoq ge yù lhê. Haû mù, Bánno buinyì má gi, hkâkut kó.\" ga luî, shiwa byu pé lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Haú hkûn, Yhumsîng Yesuq gi, \"Gegùn labyoq kut bang ê, nungmoq yuq hkangmó gi, Bánno buinyì lé, yhumsing é no, logúng pé lé, hkup mai hpông htoq yû mù uchyam byi huq huq kut akô a nghut lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haû nghut le gi, raxe shit zân gón Tsadán èq tuî to huî é, Abraham é yhangzo yhangshu myiwe zo shî lé, Bánno buinyì má Tsadán loq mai, hkyut byi a gíng râ lhú?\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Haû su ga taí jáng, Yhang eq i-myit shai lhum é bang banshoq gi, hoq hpû byuq bum akô. Shiwa byù banshoq bang kúm gi, Yhang kut é mauhpo amû banshoq é yanmai, gabú nyi bum bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Haú hkûn, Yesuq taî é gi, \"Garai Gasâng é mingdán gi, haî eq wuí lhê lhú? Ngò hai eq taî kê wú râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Haû gi, byù rayuq mai, yhâng é hkyâm má hô tô é angshi cham eq wuí ri. Angshi cham haû gi, yuq kô lò mù agàm mó dut lò jáng, hau é akoq pé má, maulat nghoq zô pé wó zung nô yu akô.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yhang dum xoq taî é gi, \"Garai Gasâng é mingdán lé, ngò hai eq taî kê wú râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Haû gi, myiwe zo rayuq èq sungsô mún sum bûng má yu nyhó luî, haú pé banshoq lé wó lhoq daú nhang é múnchi eq wuí ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hau htâng, Yesuq gi, Yerusalem wà mó shut laî e ló uchyang, rawà bàn rawà má wàng mù, mhoqshit byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Haú hkûn, byù rayuq gi, \"Yhumsîng ê, hkyi yu é hui râ bang gi, shau za nghut râ lhú?\" ga luî, Yesuq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesuq gi, \"Chyap é hkúmdong mai, Garai Gasâng é mingdán má wó wâng shoq shikut keq. Hkâsu mù gâ le, ngò, nungmoq lé taí kôlé, byù myo myo gi, wó wâng shoq ga shikut wú kó râ. Nghut kôlhang, a wó wâng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yhumsîng hpó, hkum toq myhî pyâm é htâng má sheq, nungmoq gi, hkúmdong hí má yap to mù, hkum lé kok uchyang, 'Yhumsîng ê, ngamoq lé hkum hpóng byi laq ô!' ga luî, wut dung jáng, haú yuq gi, 'Nungmoq ó nghut é lé le, hkarâ é bang nghut é lé le, ngò a sé.' ga tû taî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Haû jáng, nungmoq gi, 'Ngamoq gi, nàng eq rahá zo wú shuq wú bê bang nghut lhê; ngamoq é wà hkyô pé má le, nàng mhoqshit byî wú bê nghut lhê.' ga taí bekô râ. ");
INSERT INTO atbNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nghut kôlhang, yhumsîng hpó kúm gi, 'Nungmoq ó nghut é lé le, hkarâ é bang nghut é lé le, ngò a sé. Age ashop dông kut é bang banshoq ê, ngá chyáng mai gâng ló byuq keq.' ga tû taí kat râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Garai Gasâng é mingdán má, Abraham, Isak, Yakup pé eq myiqhtoî pé banshoq bang nyi to kô é lé, nungmoq wó myâng kôlhang, nungmoq gi, shinggan shut hkat pyâm é hui luî, haú jowò má ngaubyi ngaù nhap eq zuì kyik kyik shoq hpuzô nyi bùm bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hau hkûn, buihtoq, buiwàng, maupyî, mautsûng mâ é mingdán myo myo mai byu pé lé luî, Garai Gasâng é mingdán zoshuq poî má myang zùng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Haú hkûn, ahkuî htâng gyó nyî bang gi, hí bekô râ; ahkuî hî to bang gi, htâng gyó bekô râ.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Haú u lé, Hparishe pé ra-am gi, Yesuq chyáng lé luî, \"Shí jowò mai htoq ló byuq aq. Hkâsu mù gâ le, Herut gi, nang lé sat râ hen nyi ri.\" ga luî, Yhang lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Haû jáng, Yesuq gi, \"'Hkû-nyí, napmá, ngò nat gang hkat pyám luî, nò zo hpyo zo lhoq gê byi râ nghut lhê; sum nyí nghû râ buinyì má sheq, ngá mû bàn râ nghut lhê.' nghû luî, agè ashop é wamhkui haû lé ló taî kyo keq. ");
INSERT INTO atbNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Haî wá dut kôlhang, hkû-nyí, napmá, sânghpe nyí, ngò gi, e ló râ dut ashî. Hkâsu mù gâ le, myiqhtoî pé gi, Yerusalem wà mó mai lai luî gotû jowò má a shi wú kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalem ê, Yerusalem ê, myiqhtoî pé lé sat pyám pyám kut mù, náng chyáng nhang kat é bang lé, luqgok èq dú sat sat kut é myuq nàng ê, woqzìng gi, yhangzô pé lé, yhâng é dùng hkaû má tsîng lhûng yu é su, nungzô pé lé, Ngò hkâ-myhó dâm shuî tsîng yù naù kôlhang, nàng a dóng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wú keq, nungmoq é yhûm gi, nungmoq é matú chamchyuiyuì dut pyâm to berâ nghut lhê; Ngò, nungmoq lé taí kôlé; 'Yhumsîng é myìng mai jé lé lo é Sû gi, hkungsô wó nyì sháng gaq.' nghû, nungmoq a taí taí gi, Ngo lé wó myâng kó râ a nghut lo.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bánno buinyì ra-nyí má, Yesuq gi, zang zo râ ga Hparishe suwún rayuq é yhûm má, ê wang nyi tô le, haú mâ é bang gi, Yhang lé gyui gyui chôm wú nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Haú u lé, wuì wam ana dut sû rayuq gi, Yesuq é hí má jé nyi tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Haû mù, Yesuq gi, \"Bánno buinyì má nòhpyo lé lhoq gê byî é gi, tarâ wang lhê lhú, a wang é lhú?\" ga luî, tarâ sará pé eq Hparishe pé lé myî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nghut kôlhang, yhangmoq gi, zim za dut byuq akô. Haú hkûn, Yesuq gi, nòhpyo hui sû lé, zuî to mù, lhoq gê byi luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hau htâng, Yesuq gi, yhangmoq lé, \"Nungmoq chyáng mâ é rayuq yuq gi, yhumsing é yhangzo rayuq yuq, haû a nghut jáng, no myang radu du, Bánno buinyì má, wuìhtung má byit gyó le, haú hkûn jáng, a xe htoq yu é za, wó nyî kó râ nghut lhê lhú?\" ga myî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yhangmoq kúm gi, dang haú hkun lé, haî le a wó tû taí kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Haú hkûn, Yesuq gi, ji tô é bang jé réng é zùng jowò pé hkyin yu nyì kô é lé myàng jáng, yhangmoq lé dangtú dông taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"Byù rayuq yuq nang lé, myiháng poî má ji é nghut jáng, je réng é jowò má hkâ-ê zùng. Hkâsu mù gâ le, náng htoq je aróng wó sû lé le, ji to shirâ abe. ");
INSERT INTO atbNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ji tô é nghut jáng gi, nungnhik lé ji tô é yhumsîng hpó lé lô mù, 'Shí yuq lé jowò hui byi aq.' ga luî, náng lé lé taí jáng, nàng hoq hpu luî, hkyî htâng shut huî zùng ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Haû mù luî, supé nang lé ji le, hkyî htâng má ê zûng aq; haú hkûn, nang lé jì sû lé mù luî, 'Buinùm hpó ê, shî je réng é jowò má huî doq zùng aq.' ga luî, nang lé taí jáng, nàng eq rahá zung tô é bíng lhunglhâng bâng é hí má, nàng gi, myoqdong wó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hkâsu mù gâ le, yhumsing gùng lé waq toq é sû ó yuq nghut kôle, lhoq nyhum pyâm é hui râ nghut lhê; yhumsing gùng lé, lhoq nyhum é sû kúm gi, waq toq é hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hau htâng, Yesuq yhang lé ji é yhumsîng hpó lé taî é gi, \"Napzang, a nghut jáng, myinxûn lé nàng byi tso nau le gi, náng é buinùm wuì, âgu âmâng pé, mungmoq wuì, sùt wó é yhumkyo chang pé lé hkâjî tso. Haú bang lé jì tsô é nghut jáng gi, yhangmoq nang lé dum jì tsô é èq, jeju dum tau kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nghut kôlhang, nàng poî kut mù, byi tso byi huq nau é nghut le gi, myùng bang, hkyî gyui loq hten bang eq myoqjit é bang lé, jì tso aq. ");
INSERT INTO atbNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Haû su kut jáng, nàng hkungsô wó nyî râ nghut lhê. Yhangmoq nang lé jeju a wó tau kôlhang, dingmán bang dum dui toq lo é buinyì má, hau é akyû lé, nàng wó hkam yù râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuq eq rahá zô zung tô é byù rayuq gi, dang haû wó gyo jáng, \"Garai Gasâng é mingdán mâ é zoshuq poî má wó zo râ sû gi, hkungsô wó nyî sû nghut râ.\" ga luî, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuq haú yuq lé tû taî é gi, \"Byù rayuq gi, myinzang byi tso râ ga, zoshuq poî mó ralhum hen to mù, byù myo myo lé ji tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Zang byi tso râ yàm jé jáng, yhâng é dui-nhâng zoshâng lé, ji tô é bâng chyáng 'Lé keq hkoi, zoshuq jin to bê.' ga ê châng wut nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nghut kôlhang, haú bang banshoq gi, zoshuq poî má a ê râ dông chyat he pyâm akô. Rayuq sû gi, 'Ngò yohtung rahkyang wui tô lhê; haû lé ê wú râ dut ri. Haû mù, ngo lé ahkáng byi shi laq.' ga yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dum rayuq le, 'Ngò, nohtó ngo zúm wui tô lhê; haú pé lé duì nhang chyam wú râ dut ri; ngo lé ahkáng byi shi laq.' ga taí wô ho ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dum rayuq le, 'Ngò myiwe hâng tô é a myáng shi mù, a wó lé.' ga taí wô ho ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Haû jáng, dui-nhâng zoshâng taû lò mù, yhâng é yhumsîng lé haú hkyô banshoq lò taî kyô ri. Haú hkûn, yhumsîng hpó gi, nhikmó gyô yo mù, 'Wà mâ é hkyô mó hkyô zo hkat hkangmó má hân hân ê mù luî, myùng bang, hkyî gyui loq hten bang eq myoqjit bang lé, ê ji lò aq.' ga luî, yhâng é dui-nhâng zoshâng lé nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hau htâng má, dui-nhâng zoshâng gi, 'Yhumsîng ê, nàng nhang é eq rajung za ban kut bê; nghut kôlhang, zùng râ jowò gi, mân tô ashî.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Haû su ga jáng, yhumsîng hpó gi, 'Ngá yhûm byíng râ matú, wà yàm hkyô pé eq hkyâm yàm hkyô pé má htoq ê mù, myang é bang lé a wó le wó shoq ê tsing shuî lò aq. ");
INSERT INTO atbNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nang lé ngò taí lé, hí lé ji to huî é bang rayuq lháng, ngá é zoshuq poî lé wó chyim wú râ a nghut.' ga luî, yhâng é dui-nhâng zoshâng lé taî ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Byù hpûng mó Yesuq eq rahá e ló kô é hkûn, Yesuq gi, haú bang lé lhing wú luî, ");
INSERT INTO atbNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"Ngá chyáng lé sû ó yuq nghut kôle, yhumsing é înu, îwa, yhangmyi, yhangzo eq, yhanggu, yhangmang, yhâng nhammó pé lé le, haû htoq agó, yhumsing é asak lé le, ngo lé chyitdap é htoq má je chyitdap sû gi, ngá é chángzo a wó dut. ");
INSERT INTO atbNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yhumsing é tapzîng lé a waq é za, Ngá htâng châng é sû ó yuq nghut kôle, Ngá é chángzo a wó dut. ");
INSERT INTO atbNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dangké, nungmoq chyáng mâ é byù rayuq yuq, tsehtung yhûm ralhum saí nau le, yhang gi, yhûm haû ban saí râ matú, ngùn hkâ-myhó bàn râ eq yhang wó tô é ngùn luq a luq é lé, zùng mù luî, hí a sôn wú é byù nyì kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Laqmá mù, apûn awang gi, saî hi to mù luî, a wó lhoq pân é nghut jáng, ");
INSERT INTO atbNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","myàng é bang banshoq èq, 'Shí yuq gi, apûn awang gi, saî hi to mù luî, banshoq a wó saî pán lo nghut ri.' ga luî, yhang lé jóng pyám bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Dangké, hkohkâm rayuq gi, gyè zan râ hen le, gyezo í mun eq lé sû hkohkâm lé, gyezo ramûn eq za lhom wó zân ûng râ, a wó zân ûng râ lé, zùng mù luî, hí a myit wú é nyì râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A ûng râ dut le gi, gyè pé we we má nyi tô ashî hkûn lé, lagyo suwún pé lé nhang kat luî, simsaq râ matú htingrám pyám ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Haû eq rajung za, nungmoq chyáng mâ é ó yuq nghut kôlhang, yhumsîng wó é zè banshoq lé, a pyâm to sû gi, ngá é chángzo wó dut râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Xo gi, gè lhê. Nghut kôlhang, xomân kân byuq jáng gi, haû lé hai èq dum wó lhoq ngam yù râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haû gi, myigung matú le, myìhpún kut râ matú le, akyû a bò lo. Haû mù luî, shinggan shut kúm gi, dú pyám sê akô. Gyo râ nohkyap dap sû gi, gyô yù sháng gaq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ra-nyí lé, Yesuq é dang gyo kó râ ga, kang guq bang eq yubak dap bang gi, Yhâng chyáng lé zîng bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Haú hkûn, Hparishe pé eq tarâ sará pé gi, \"Shí yuq gi, yubak dap bang lé lhom hap yù mù, yhangmoq eq rahá za, zo shuq nyi ri.\" ga taî put nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Haû mù, Yesuq yhangmoq lé dangtú dông taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"Nungmoq má, sau rashô du wó luî radu byuq byuq é nghut le, gaú xe gaû du lé yoso mhan yô má nyhi pyâm to mù, byuq byuq é sau haû lé, myàng shoq a châng ho yu é, ó yuq wá nyì kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Byuq byuq é sau haú lé myang hô jáng, gyaí gau é i-myit èq goqsân htoq má bún kê chûng mù, ");
INSERT INTO atbNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yhûm má jé jáng, yhâng é buinùm ji-myi wuì eq, yhumkyo chang pé lé ji yù mù, 'Ngá é byuq byuq é sau lé, ngò dum myang ho yù bê, ngò eq rahá chôm gabú sháng.' ga taí râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Haû eq rajung za, Ngò, nungmoq lé taí kôlé, myit lhîng a râ é dingmán bang gaú xe gau yuq lé gabú é htoq, myit lhîng é yubak dap sû rayuq é yanmai, mauhkûng htoq má, je riyhang gabú jowò dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Dum nghut jáng, dangtú ralhum gi, myiwe rayuq, ngùn raxê chap wó é má, rachap byuq byuq é nghut le, yhang gi, myibung tap mù rayhum ê shum luî, myang yù shoq rago za, ho wú râ a nghut lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Haû lé ho myàng jáng le, yhâng é buinùm ji-myi wuì eq yhumkyo chang pé lé ji yù mù, 'Byuq byuq é ngá ngûn chap lé dum myang ho yù bê, ngò eq rahá chôm gabú sháng.' ga taí râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Haû eq rajung za, Ngò, nungmoq lé taí kôlé, myit lhîng é yubak dap sû rayuq é yanmai, Garai Gasâng é maumang lagyô pé hí má, gabú jowò dut râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuq xoq taî é gi, \"Byù rayuq gi, yuqzo í yuq wó ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Haû nhik mâ é tiq sû yuq gi, yhâng wa lé, 'Âwa ê, ngò wó gíng é sutzè, ngo lé gàm byi laq.' ga dung jáng, yhâng wa le yhangnhik tâng lé sutzè gàm byî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hau htâng hkâ-myháng a myáng má, yhangzo tiq sû yuq gi, sutzè banshoq hkyom yu chûng mù, mau we shut ê luî, haú jowò má, mingkan ngón hkyô châng é má yhang wó é ngunzè banshoq lé langsâ pyám bê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Haû su kut ngunzè wó mi-wó lé ban langsâ pyâm é htâng má, haú mau má mutmó gyo é yanmai, yhang gi, asho awui dut lo nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Haû mù, haú mau mâ é byù rayuq chyáng, langchyáng ê kut le, haú yuq gi, yhang lé waq rém jang shut nhang kat mù, waq lé lhom zúng nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Haú hkûn, yhang gi, waq jùm zô é shigyang cham pé lé lháng, zo naû shoq dut kôlhang, ó yuq le a byi zo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Haû mù, yhang myit bûn lo é gi, 'Ngá wâ chyáng nyi é langchyâng pé gi, agùn agó myàng zô nyì kó râ nghut lhê. Nghut kôlhang, ngò gi, shí jowò má, zo mut wuìshit é eq shi ló râ dut bê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ahkuî, ngò toq mù, ngá wâ chyáng taû ló luî, \"Âwa ê, ngò gi, Garai Gasang lé le, nang lé le, shut bê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ahkuî mai ngò gi, nung zo nghû râ a gíng lo, hau é yanmai, náng é langchyáng rayuq dông za ngo lé nyì nhâng laq.\" nghû luî, ló taí râ.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hau htâng, yhang toq luî, yhâng wâ chyáng ló le, yhang we we má ru nghut ashî hkûn mai, yhâng wa gi, yhang lé lhom myàng jáng, wú shogyo luî, din ê mù, yhangzô é lingzing má ê po pyik dap to luî, bopuq puq byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Haú hkûn, yhangzo gi, 'Âwa ê, ngò gi, Garai Gasang lé le, nang lé le, shut bê. Ahkuî mai, ngò gi, nung zo nghû râ a gíng lo.' ga luî, yhâng wa lé dûng tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yhângwa kúm gi, yhâng é langchyâng pé lé, 'Réng dik é mebu hân hân yu lé mù, yhang lé hut byi keq; yhâng é loq má, loqchyop chyop byi keq; hkyî má le hkyî-tsung tsung byi keq. ");
INSERT INTO atbNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tsô myum tô é nojûng zo le yu sat keq. Haû mù, nga-nhúng gi, zoshuq poî kut mù chôm ngón sháng. ");
INSERT INTO atbNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Haî mù gâ le, ngá zo shí yuq gi, shi byuq é mai, ahkuî dum duì bê; byuq byuq é mai le, ahkuî dum myàng bê.' ga taî ri. Haû mù, yhangmoq gi, ngón ngón zo shuq ló bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Haú u lé, yhangzo ko sû yuq kúm gi, yò má nyi tô ri. Yhang gi, yò mai yhûm shut jé lo nyi é hkûn, zìng ût bat luî gó nyi é htê lé lò wó gyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Haû mù, langchyáng rayuq lé wut yù luî, haú hkyô lé yhang myî wú le, ");
INSERT INTO atbNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","langchyáng haû gi, 'Nung gu dum taû jé lô bê. Haû mù, náng wa gi, nung gu wáng wáng zán zán dum taû jé lo é lé lhom myàng luî, tsô myum tô é nojûng zo lé sat bê nghut ri.' ga taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dang haû lé wó gyo jáng, yhang gi, gyô nhik-yo luî, yhúmhkaû shut a wàng lo kut ri. Haû mù, yhâng wa htoq ê luî, yhang lé ê chyuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yhangzo kúm gi, 'Wú aq, ngò, shî-myháng shîlo náng é jùn dông kut luî, hkâ-nhám le náng dang lé a lu laî wú. Nghut kôlhang, ngò ngá é luzúm wuî eq ngón kún râ matú, bainám zo radu lháng radàm le nàng a byi wú shi. ");
INSERT INTO atbNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Shiwa myhî pé eq zum yap wún luî, náng é sutzè lé lhoq pân pyâm é sû nung zo haû dum taû jé lô jáng kúm gi, tsô myum tô é nojûng zo lé, yhâng é matú nàng sat byi bu-nhung!' ga luî, yhâng wa lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yhângwa gi, 'Ngá zo ê, nàng gi, hkâ-nhám le ngò eq rahá yhang nyi nyi lhê mù, ngá é sutzè joq mijoq banshoq gi, náng é chyat nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nghut kôlhang, shî nung gu gi, shi byuq é mai ahkuî dum duì bê; byuq byuq é mai le, dum myàng bê. Haû mù, gabú hpo nghut bê.' ga luî, yhang lé taî ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuq, Yhâng é chángzô pé lé taî é gi, \"Sahtê rayuq chyáng sùt zum sû rayuq nyi ri. Haú yuq gi, yhâng yhumsing é sutzè pé lé jai hpyuq pyám ri ga, yhâng yhumsing é hí má, yhang lé mara lé hun akô. ");
INSERT INTO atbNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Haú hkûn, sahtê hpó gi, yhang lé wut yù mù, 'Nàng é hkyô lé ngò wó gyo bê. Haû gi, hkâsu lhú? Nàng sùt zûm é eq séng luî kut tô é jihpán laiká lé lò shit wú aq. Hkâsu mù gâ le, ahkuî mai nàng gi, sùt zum sû wó kut lo râ a nghut lo.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Haû jáng, sùt zum sû gi, 'Ahkuî, ngò hkâsu kut lo râ lhú? Ngá é yhumsîng gi, ngo lé sùt zum ayá mai lhoq hkyô pyám bê. Myì du myì hkop zo râ le ngò wum a bò; dung zo dung shuq râ le ngò hoq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ngo lé sùt zûm é ayá mai hkyô pyâm htâng má, supé ngo lé yhangmoq é yhûm má lhom hap yù râ matú, hkâsu kut râ hkyô lé ngò sé bê.' ga wó myit rot jáng, ");
INSERT INTO atbNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","yhang gi, yhâng yhumsîng hpó lé chyîn dap tô é bang rayuq htâng rayuq lé wut yù mù, sâng-hî yuq lé, 'Ngá yhumsîng hpô chyáng nàng chyîn hkâ-myhó dap tô lhê lhú?' ga myi jáng, ");
INSERT INTO atbNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","haú yuq gi, 'Xû rashô pûng dap lhê.' ga tû taî ri. Haû jáng, sùt zum sû gi, 'Náng é jihpán yù luî, hân zùng mù, ngo xê pûng kut kâ to aq.' ga yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dum rayuq lé, 'Nàng hkâ-myhó dap tô lhê lhú?' ga myi jáng, haú yuq gi, 'Sungsô rashô bùng dap lhê.' ga tû taî ri. Sutzum sû gi, haú yuq lé, 'Náng é jihpán má shit xê bùng kut kâ to aq.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Haû a dingmán é sùt zum sû lé, yhumsîng hpó gi, hpaqchyî ge da sû nghut ri ga hkya-ôn ri. Ngò shî lé taî é gi, mingkan zo wuî gi, yhangmoq é mingkan eq sêng é hkyô pé má, maubó gung é yhangzo pê htoq hpaqchyî je bò kô é yanmai nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Haû mù luî, Ngò nungmoq lé taî kyo kôle, a tara é sutzè pê èq buinùm ho nyì keq, haû mù, sutzè haû htûm byuq jáng, nungmoq lé, ahtum abyuq joq tô é yhûm má, lhom hap yu é hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tiq é mû má wó lum é sû ó yuq nghut kôlhang, mû mó má le wó lûm râ nghut lhê. Tiq é mû má lhum a zuî é sû ó yuq nghut kôlhang, mû mó má le lhumzui râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Haû mù, mingkan sutzè má lháng nungmoq lé a wó lûm kô é nghut le gi, haû tengmán é sutzè lé, nungmoq chyáng ó yuq wá kâm ap byi râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Supé é sutzè má, nungmoq lé a wó lûm kô é nghut le gi, nungmoq sîng âng é sutzè lé, nungmoq chyáng ó yuq wá kâm ap byi râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Dui-nhâng zoshâng ó yuq nghut kôlhang, yhumsîng í yuq lé wó dojaú râ a nghut. Hkâsu mù gâ le, yhang gi, rayuq lé a jú kut mù, rayuq lé, chyitdap râ nghut lhê; haû a nghut jáng, rayuq lé gi, lhumzui mù, rayuq lé gi, hpau a tap kut râ nghut lhê. Nungmoq gi, Garai Gasang lé le, ngunzè lé le, radá dâm wó dojaú kó râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ngùn myoqnoq é Hparishe pé gi, dang haû banshoq lé wó gyo kôjáng, Yesuq lé wuìzuì kut pyám byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Haû mù luî, Yesuq gi, yhangmoq lé, \"Nungmoq gi, byu pê hí má yhumsing gùng lé yhumsîng dingmán bang su kut shit mhaû é bang nghut akô; nghut kôlhang, Garai Gasang gi, nungmoq é i-myit unghkaû lé sé sû nghut lhê. Byù é hí má hpaudap é pé gi, Garai Gasâng é hí má achaq achyut é nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jep é tarâ eq myiqhtoî pê é dang, ahko ahkáng wó tô é ahkyíng gi, wui-myhup sará Yohan jé lé é buinyì jé shoq nghut bê. Haú hkyíng mai gi, Garai Gasâng é mingdán hkyô gabú danglù lé, hko kyô nyì mù, yuq du jup gi, haú hkyô má htûng chying wang ló bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jep é tarâ mâ é tiq dik é dangjí eq myihkyet zo ralhum lé wó lhoq hten râ htoq, mauhkûng eq myigùng hten râ gi, je luì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dangké, yhumsing é yhangmyi lé kâng pyám mù, myiwe gotû dum hâng yu é sû ó yuq nghut kôle, su-myi lú é sû nghut bê; yhumsing é yhanglâng eq gang bê myiwe lé hâng yu é sû le, su-myi lú é sû dut bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuq dum xoq taî é gi, \"Radàm lé, sahtê rayuq gi, nè é eq nú-nhâm é mebu wut mù luî, nyí nyí buì buì zo ngón shuq ngón nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yhâng é hkúmdong má gi, ragùngdû é jeq byi tô é Lazaruq gâ é dung zo sû rayuq lé, lé nyhi tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Haú yuq gi, sahtê wá é siboî mai gyó é agyó ahtâng lé, wú zô nau nyi ri. Hkui pé le yhâng é dàm pé má, lé yoq byî nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Htâng má, haû dung zo sû shi byuq jáng, maumang lagyô pé gi, mauhkûng má nyi é Abraham é tanghkoí má yhang lé shuî ló byî akô. Sahtê wá le shi byuq luî, yhûm pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sahtê wá gi, ngaraî ming má dik shoq hpuzô nyì mù luî, tu wú kat le, we we má Abraham lé le, yhâng é tanghkoí mâ é Lazaruq lé le, myàng kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Haû mù, yhang gi, 'Âwa Abraham ê, ngo lé shogyo yù laq ô. Ngò gi, shî myi htum má achyí aku nyé é hui zô nyi ri. Haû mù, Lazaruq gi, yhâng é loqnyhui û èq wuì má tik yû mù, ngá é shô má wuì ra-poq zo hkâlháng lé tik cham byi sháng gaq, yhang lé ngá chyáng nhang kat byi laq ô!' ga luî, dûng wut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Haú hkûn, Abraham gi, 'Ngá zo ê, asak dui tô é u lé, nàng nyì ngón yuqyo tô é hkûn, Lazaruq gi, asho awui dut é lé, bûn nyì aq. Ahkuî, yhang kúm gi, shî má lo nyi byán to bê; nàng chyaú gi, jamjau hui zô nyì bê. ");
INSERT INTO atbNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Haû mai gotû gi, shî mai nungmoq chyáng dap lé naû bang a wó dap shoq le, haû mai ngamoq chyáng ó a wó dap lé râ matú le, ngamoq eq nungmoq é gyoro má, nik dik é langhkung mó èq kyo pyâm to bê nghut ri.' ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sahtê wá gi, 'Âwa ê, haû nghut le gi, ngò, nang lé dúng nau ri. Ngá gû pé ngo yuq nyi ashî; yhangmoq le îsu hpuzô é jowò má a jé sháng gaq, ");
INSERT INTO atbNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","yhangmoq myit lhîng shoq ló taî pun râ matú, Lazaruq lé ngá wâ yhûm shut nhang kat byi laq ô!' ga luî, dûng wut ngau nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham gi, 'Yhangmoq chyáng, Mosheq eq myiqhtoî pé nyi lhê; haú bâng dang lé gyô yù kó sháng gaq.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sahtê wá gi, 'Âwa Abraham ê, haû su a nghut. Shi byuq é bang mâ é rayuq yuq yhangmoq chyáng dum taû lo é nghut le kúm gi, yhangmoq myit lhîng kó râ nghut lhê.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham gi, 'Mosheq eq myiqhtoî pê é dang lé yhangmoq a gyo kô é nghut le gi, shi byuq é bang mâ é rayuq yuq dum dui toq ló mù, ló taî kyo kôlhang, kâm gyo kó râ a nghut.' ga luî, yhang lé tû taî ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuq, Yhâng chángzô pé lé taî é gi, \"Byu pé lé mara kut shut nhang é hkyô gi, joq htoq lô râ za nghut lhê. Nghut kôlhang, mara kut shut nhang é hkyô lé lhoq htoq é sû gi, dingnyé wó râ. ");
INSERT INTO atbNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Zoshâng shí bang mâ é rayuq lé, mara kut shut nhang é sû gi, yhâng é lingzing má luqluí long mó tuî hut byi luî, wuimau má ê dú hkyô pyâm é huî é nghut le gi, yhang é matú je gè râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nungmoq gi, yhumsîng gùng yhumsîng sidiq keq. Nunggu nungmang nàng lé mara kut shut é nghut le gi, yhang lé tan luî, mhoqshit aq; yhang myit lhîng é nghut le gi, yhang lé mara hkyut pyám byi aq. ");
INSERT INTO atbNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ra-nyí má za, yhang nang lé nyhit dàm shut mù, 'Ngò myit lhîng bê.' ga luî, nang lé nyhit dàm dum tôngbán le, tôngbán hkangmó, nàng, yhâng é mara lé hkyut pyám byi aq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Haú hkûn, lagyô pé gi, \"Ngamoq é lumjíng myit lé lhoq ko byi laq.\" ga Yhumsîng lé dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Haû jáng, Yhumsîng gi, \"Nungmoq é lumjíng myit angshi cham í za hkâlháng bò kô é nghut le gi, shî hangwâ gàm lé, 'Sikgâm ê, amyit eq roq bún luî, wuìshuq lung-aû má, ê yuq to aq ô.' gâ le, nungmoq é dang lé sikgâm haû gyo byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dangké, nungmoq mâ é rayuq yuq chyáng, yò hpuq é, a nghut jáng, sau zúng é dui-nhâng zoshâng rayuq nyi é nghut le, dui-nhâng zoshâng haû yohtung pá mai jé lo é hkûn, yhang lé, 'Hân zùng mù zang zo aq.' ga luî, ó yuq wá taí kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Haû dui-nhâng zoshâng lé sheq, 'Ngò zo râ myinzang lajang aq. Ngò bàn zo shoq hpyidum má hpyihit hit mù, xun zang wú nyî aq. Ngò bàn zo jáng sheq nàng wó zo râ nghut lhê.' ga luî, taí râ a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Taí mitaí banshoq lé, dui-nhâng zoshâng ban zui saí byî é nghut kôlhang, yhang lé jeju bûn é dang ó yuq wá taî wú akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Haû eq rajung za, nungmoq gi, taí mitaí ban kut jáng sheq, 'Nga-nhúng gi, jeju bun a gíng é dui-nhâng zoshâng pé nghut nyi lhê; kut râ é mû lé za lhoq pân é bang nghut lhê.' nghû taí keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ahkuî, Yesuq gi, Yerusalem wà mó shut e ló nyi le, Samariq mau eq Galile mau gyoro mai laî e ló ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yhang, wà rawà shut wang ló é hkûn, manggâm dap é byù raxê yuq eq huî ri. Haú bang gi, we mai yap to mù, Yesuq lé, ");
INSERT INTO atbNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","\"Yesuq, Zau ê, ngamoq lé shogyô yù laq ô.\" ga luî, wut garû bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesuq gi, yhangmoq lé myàng jáng, \"Nungmoq é gungdu lé, hkyangjông pê chyáng ló tûn shit keq.\" ga yhangmoq lé taî ri. Yhangmoq gi, hkyô má ru sô nyi ashî le lháng, sân-yúng ló byuq bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yhangmoq chyáng mâ é rayuq gi, yhumsing gungdu ge byuq é lé myàng jáng, Yesuq chyáng dum taû ê mù, htê mó èq Garai Gasang lé hkya-ôn é eq, ");
INSERT INTO atbNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesuq é hkyî wang má paî gop to luî, Yhang lé jeju hkya-ôn nyi ri. Haú yuq gi, Samariq byù nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Haû mù, Yesuq gi, \"Sân-yúng byuq é gi, raxê yuq a nghut lhú? Gau yuq gi, hká ló byuq bekô? ");
INSERT INTO atbNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Shî tûngbaù rayuq mai lai luî, dum taû lé mù Garai Gasang lé hkya-ôn é byù, rayuq le a nyì lo kó lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hau htâng, Yesuq gi, haú yuq lé, \"Toq mù ló aq, náng é lumjíng myit gi, nang lé lhoq sân-yúng byi bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Radàm lé, Hparishe pé gi, Garai Gasâng é mingdán hkâ-nhám jé râ hkyô, Yesuq lé myî akô. Haû jáng, Yesuq gi, \"Garai Gasâng é mingdán jé lé râ gi, myoq èq wú luî myàng râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Garai Gasâng é mingdán gi, nungmoq yuq jup é ahkaû má nghut nyi é yanmai, 'Wú keq, shí má joq ri, mhó má joq ri.' ga luî le, byu pé gi, wó taí kó râ a nghut.\" ga luî, yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chángzô pé lé le Yesuq taî é gi, \"Haû Byu Yhangzô é buinyì ra-nyí lé, nungmoq myàng nau dik é ahkyíng jé râ. Nghut kôlhang, nungmoq gi, Byu Yhangzo lé wó myâng kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Haú buinyì má, byu pé gi, nungmoq lé, 'Yhang shí má nyi ri.' haû a nghut jáng, 'Yhang hê má nyi ri.' ga taí kó râ nghut lhê. Nghut kôlhang, hkâ-ê; hkâcháng kó. ");
INSERT INTO atbNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hkâsu mù gâ le, maumyî rahkyam má hpyat é maulhap gi, maumyî gó hkyam jé shoq duqbó é su, haû Byu Yhangzo dum jé lé é buinyì má le dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nghut kôlhang, haû su a dut htoq shimá, Yhang gi, zing-rî é myo myo lé le, ipyat shi mâ é byu pê èq he-ngik pyâm é lé le, hui shirâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noaq é tsîn pyat má dut é su, haû Byu Yhangzo jé lé é buinyì má le dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Byu pé gi, Noaq, wuì-sanghpo mó hkaû má wang é hkûn jé shoq, zo zo shuq shuq, myi byi myi yû, myiháng kut luî, nyi nyi bum akô. Haú hkûn, dowuî díng lô mù, yhangmoq banshoq lé lo lhoq htên pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Haû eq rajung za, Lot é pyat má le, byu pé gi, zo mù, shuq mù, ung zo wuì zo, ho zo ho shuq, yhûm kut luî nyi nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nghut kôlhang, Sodom wà mai Lot htoq ló é buinyì má, mauhkûng mai, myi eq hang gi, mau su wò gyó lô luî, lhunglháng lé lhoq htên pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Haû Byu Yhangzo, lé htoq shit é buinyì má le, haû eq rajung za dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Haú buinyì má, yhumhkûng htoq má nyi tô é sû gi, yhúmhkaû mâ é zè lé, a ló gyó wang yù lo sháng gaq. Yò má nyi tô é sû gi, haû eq rajung za, yhûm shut a taû ló lo sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot é yhangmyi lé bûn nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yhumsing é asak duì hkyô hô sû ó yuq nghut kôle, asak sum râ nghut lhê; asak sum pyâm é sû kúm gi, asak wó duî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngò, nungmoq lé taî kyo kôlé, haú myîn lé, yhupjang ralhum má byù í yuq nyi to kô le, rayuq gi, shuî yu é hui mù, rayuq gi, myit gyó to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Myiwe í yuq luí má rahá za chôm luí nyi tô le; rayuq gi, shuî yu é hui mù, rayuq gi, myit gyó pyâm to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yohtung má byù í yuq nyi to le, rayuq gi, shuî yu é hui luî, rayuq gi, myit gyó pyâm to berâ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Haú hkûn, chángzô pé gi, \"Yhumsîng Yesuq ê, haû gi, hká gyo má dut râ lhú?\" ga luî, Yesuq lé myi kôjáng, Yhang gi, \"Màng leq é jang má, langdâ pé, lé zîng bùm râ nghut lhê.\" ga luî, yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuq, Yhâng é chángzô pé lé, myit wum a gyuî é za, hkâ-nhám le kyûdûng nyì râ hkyô lé, dangtú dông mhoqshit é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","\"Wà rawà má, Garai Gasang lé le a gyuq hoq, byù lé le haî su a ngàm é tarâ agyì rayuq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Haú wâ má chuimó myhí rayuq le nyi ri. Yhang gi, haû tarâ agyì wá chyáng ê luî, 'Ngò eq amû htoq sû lé, yhâng é mara eq rajung za, jéyáng byi laq.' ga luî, ê dum taí taí kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nghut kôlhang, tarâ agyì wá gi, ahkyíng rayoq zo jé shoq tarâ a jéyáng byî é tô tô ri. Hau htâng má, yhang gi, 'Ngò, Garai Gasang lé le a gyuq a hoq, byù lé le haî su a ngàm, ");
INSERT INTO atbNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nghut kôlhang, chuimó myhí shí yuq é amû lé, ngò a jéyáng a doqdan byî é nghut le gi, yhang dum lé lé kut mù, ngo lé myit hpêbù nhâng râ dut ri. Haû mù, ngò yhâng é amû lé jéyáng byi râ.' ga, yhâng é unghkaû má myit yu ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Haû mù luî, Yhumsîng Yesuq gi, \"A ding a mán é tarâ agyì wá taî é dang mai mhoq yû keq. ");
INSERT INTO atbNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Garai Gasang gi, Yhang lé nyí myín wut dûng nyi é, Yhang hkyin yu to bê bang lé, tarâ é dông a kut byî é gi, myáng myáng nyi to râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngò, nungmoq lé taí kôlé, Garai Gasang gi, yhangmoq lé hân yhang tengmán é dông jéyáng byi berâ nghut lhê. Nghut kôlhang, haû Byu Yhangzo jé lé é buinyì má, lumjíng hkyô lé gi, mingkan htoq má myang wú shirâ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yhumsing gùng lé dingmán bun luî, byù góbang lé wú tiq é bang ra-am lé, Yesuq dangtú dông taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","\"Byù í yuq kyûdung kó râ ga, noqkuq yhûm má doq e akô. Rayuq gi, Hparishe, rayuq gi, kang guq sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Hparishe hpó gi, yap to luî, 'Garai Gasang ê, ngò gi, byù góbang su lú zo lú shuq é hkyô le a kut, agè ashop é hkyô le a cháng, su-myi le a lú é htoq agó, shî kang guq sû su le, a nghut é yanmai, ngò nàng lé jeju bûn lhê ô! ");
INSERT INTO atbNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngò gi, rabat má zoshuq í dâm gám nyi lhê; ngò wó yu é gû mâ é xê gambùm ragambùm le kat nyi lhê.' ga luî, yhang baú yhang gotû kut dûng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kang guq sû kúm gi, we we má yap to mù, mauhkûng shut lháng a wám tu wú é za, wànggàng bat luî, 'Garai Gasang ê, shî yubak dap sû ngo lé, shogyô yù laq ò!' ga dûng ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngò, nungmoq lé taí kôlé, kang guq sû kúm gi, Garai Gasâng é hí má mara hkyut san byî é lé wó yû luî, yhûm shut dum taû ló bê; nghut kôlhang, Hparishe wá gi, a wó nghut ri. Hkâsu mù gâ le, yhumsing gùng lé waq toq sû ó yuq nghut kôle, lhoq nyhum pyâm é hui râ nghut lhê; yhumsing gùng lé lhoq nyhum é sû kúm gi, waq toq é hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Byu pé gi, zonú wuî lé Yesuq záng htung byi sháng gaq ga, Yhâng chyáng shuî lé lo bum akô. Chángzô pé gi, haû lé myàng jáng, lhom tân hkûm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nghut kôlhang, Yesuq gi, zoshâng wuì lé, wut yù luî, \"Haû zoshâng wuì lé, Ngá chyáng lé nhâng keq; yhangmoq lé hkâhkûm zing to kó; hkâsu mù gâ le, Garai Gasâng é mingdán gi, haû sû é bâng é mingdán ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ngò, nungmoq lé teng za taí kôlé, Garai Gasâng é mingdán lé, zoshâng su kut a lhom hap yu é nghut le gi, mingdán haú má gè gè yhang wó wâng râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayá wó é byù rayuq le, Yesuq lé, \"Ge é Sará ê, ahtum abyuq é asak wó yû râ matú, ngò haî kut ra râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesuq gi, \"Haî mù, Ngo lé ge é Sará nghu lhê lhú? Garai Gasang mai lai luî, ge é ó yuq le a nyì. ");
INSERT INTO atbNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jep é tarâ má, 'Su-myi sulàng hkâlú, byù hkâsat, hkâhkau, a teng a mán é saksé hkâhkám, nángnu nángwa lé hkungga aq.' gâ é dang pé lé, nàng sé gû bê.\" ga luî, yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Haú yuq gi, \"Haú pé banshoq lé, ngò, zoshâng hkûn mai cháng bê nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuq gi, dang haú lé wó gyo jáng, \"Nàng kut râ rajung râ tô ashî; nàng wó miwó lé ûng pyám luî, myùng bang lé byî pyám aq; haû jáng, nàng, mauhkûng htoq má sutzè wó râ nghut lhê; haû mù, Ngá htâng lé cháng aq.\" ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Haú yuq gi, dang haú lé wó gyo jáng, sutzè gyai wó sû nghut é yanmai, gyai yhang myit a ngón dut byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuq gi, haú yuq lé wú luî, \"Sutzè wó bang gi, Garai Gasâng é mingdán má wàng râ matú, haû-í yhang wuî ri-nhung! ");
INSERT INTO atbNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sutzè wó sû rayuq, Garai Gasâng é mingdán má wó wâng râ htoq, gola-uq radu âpno mai wó wang lai râ gi, je luì râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dang haú lé wó gyô é bang gi, \"Haû su ru nghut le gi, ó yuq za hkyi yu é hui râ nghut lhê lhú?\" ga myî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Haú hkûn, Yesuq gi, \"Byù a wó kut é hkyô lé, Garai Gasang gi, wó kut lhê.\" ga taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Haú hkûn, Petruq gi, Yesuq lé, \"Wú aq, ngamoq gi, wó miwó tô pyâm to luî, Náng htâng cháng bê nghut lhê.\" ga taí jáng, ");
INSERT INTO atbNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesuq gi, \"Ngò, nungmoq lé teng za taí kôlé, Garai Gasâng é mingdán é yanmai, yhumsing é yhûm, yhumsing é yhangmyi, yhumsing é âgu âmang, yhumsing é înu îwa, yhumsing é yhangzô pé lé, pyâm to sû ó yuq nghut kôle, ");
INSERT INTO atbNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","shí pyat má, akyû myo myo wó hkam yù râ htoq agó, htang pyat má le, ahtum abyuq é asak a wó yu é gi, a nyì râ nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuq gi, Yhâng é lagyô pé raxe í yuq lé gotû kut wut yù mù, \"Gyô wú keq, nga-nhúng gi, Yerusalem wà mó shut doq ló nyi é nghut lhê. Haú má jé jáng, haû Byu Yhangzo eq séng luî, myiqhtoî pé kâ tô é banshoq gi, dik lò berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hkâsu mù gâ le, Byu Yhangzo gi, tûngbaù pê é loq má ap pyâm é hui luî, haú bâng èq Yhang lé, wuìzuì kut pyâm é, rhoî rip e, sôkan byé gyûn é, nhuq bat é kut yû mù, sat pyám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hau htâng sum nyí nghû râ buinyì má, Yhang gi, dum dui toq lô râ nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lagyo pé gi, dang haú pé rahkun lé lháng a sê gyo kó; dang hau é lichyúm gi, yhangmoq é hí má zaú nghop tô é nghut é yanmai, Yhang haî taí nyi é hkyô pé lé yhangmoq a sé kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ahkuî, Yesuq Yerihko wà nàm má jé lo nyi le, myoqjit é byù rayuq gi, hkyô yàm má zùng mù, dung zô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yhang gi, byù rajùm rayò sô laî ló é htê lé wó gyo jáng, haû haî dut nyi é hkyô lé, myi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Haú hkûn, yhangmoq gi, \"Nazaret wà byù Yesuq laî ló ri.\" ga luî, yhang lé taî kyo akô. ");
INSERT INTO atbNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Haû su gâ é lé wó gyo jáng, yhang gi, \"Dawiq é Yhangzo Yesuq ê, ngo lé shogyo yù laq ô!\" ga wut dûng kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hí má laî ló é bang gi, zim za nyì râ matú yhang lé tân hkûm akô; nghut kôlhang, yhang gi, \"Dawiq é Yhangzo ê, ngo lé shogyo yù laq ô!\" ga, je riyhang htê mó o mó èq wut dûng kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Haû mù, Yesuq gi, yap kat mù, byù haú yuq lé Yhâng chyáng shuî lé lô nhang kat ri. Myoqjit sû Yhâng nàm má jé lé jáng, Yesuq gi, ");
INSERT INTO atbNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"Ngò, nàng lé haî kut byi râ ô nau ri lhú?\" ga, yhang lé myi kat ri. Haú yuq gi, \"Yhumsîng ê, ngò myoq myàng nau ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hau hkûn, Yesuq gi, \"Náng myoq myàng sháng gaq! Náng é lumjíng myit gi, nang lé lhoq gê byi bê nghut ri.\" ga, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Haú yuq gi, haú hkûn jáng, yhang myoq wó myâng mù, Garai Gasang lé hkya-on uchyang Yesuq htâng cháng bê. Lhunglhâng bang haû lé myàng kôjáng, Garai Gasang lé hkya-ôn nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuq gi, Yerihko wà má wàng mù, sô laî ló nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Haú hkûn, haú wâ má, Zake gâ é kang guq agyì rayuq nyi ri; haú yuq gi, sutzè wó sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yhang gi, Yesuq hká yuq nghut é lé myàng naù kôlhang, nyhûm sû nghut é htoq agó, byù rajùm rayò chyîn chyap tô é yanmai, a wó myâng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Haû mù, yhang gi, Yesuq lé wó myâng shoq ga, Yesuq laî ló râ hkyô hí shut din ê mù, hkohúm gâm htoq má ê doq zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuq gi, haú jowò má jé jáng, tu wú kat luî, \"Zake ê, hân gyó lô aq; hkû-nyí ngò náng yhûm má bíng râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Haû jáng, Zake gi, hân hân gyó ló mù, gabú dik é èq Yesuq lé lhom hkulum yu ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Haû má nyì bang banshoq gi, haû lé myàng jáng, \"Yhang gi, yubak dap sû rayuq chyáng bíng kut râ ga wang e ló bê.\" ga luî, mara hûn dang taî nyì bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zake kúm gi, toq yap mù, \"Yhumsîng Yesuq ê, ngò wó é sutzè rawuí gû myùng bang lé gàm byî pyám râ; ngò záng mop zô pyâm é byù rayuq yuq nyi le gi, myi tú dum tau byi râ.\" ga Yhumsîng Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Haú hkûn, Yesuq gi, \"Shí yuq le, Abraham é yhangzo rayuq nghut é yanmai, hkû-nyí shí yhûm má hkyi yù hkyô jé bê, ");
INSERT INTO atbNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","hkâsu mù gâ le, haû Byu Yhangzo gi, byuq byuq bê bang lé, hkat hô mù hkyi yù râ matú, jé lé sû nghut lhê.\" ga luî, Zake lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Haú hkyô lé, yhangmoq gyô nyi bùm kô é hkûn, Yesuq gi, Yerusalem wà mó má jé râ chyâng lò bê nghut é yanmai le, Garai Gasâng é mingdán gi, radá dâm htoq shit lô berâ ga, byu pé myit ngam tô bùm kô é yanmai le, dangtú ralhum dông dum taî jat é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","\"Aróng wó sû byù rayuq gi, hkohkâm ayá ê hkam yù luî, dum taû lò râ ga, wê é ming shut ê râ matú hen nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Haû mù, yhang gi, Yhâng é dui-nhâng zoshâng raxê yuq lé wut yù mù, rayuq lé ngùn rajoí joí ap byi luî, 'Ngò dum taû jé lô shoq, shi èq hpugá gá nyî láng keq.' ga luî, yhangmoq lé pying tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yhâng é mingbyû wuì kúm gi, yhang lé a ngui bum é nghut mù luî, yhang e ló é htâng má, 'Shí yuq ngamoq ahtoq má up nyì râ lé, ngamoq a ô naù.' ga luî, ê taí râ matú lagyo châng nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nghut kôlhang, yhang kúm gi, hkohkâm ayá wó hkam yù luî, dum taû jé lô jáng, yhang ngùn ap byî tô é dui-nhâng zoshâng wuì lé, hpugá gá luî, amyat hkâ-myhó wó ho jat bê hkyô lé sé naû luî, yhangmoq lé wut nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Haú hkûn, sâng-hî yuq gi, lé mù luî, 'Yhumsîng ê, ngò, náng é ngùn rajoí mai, amyat raxê joí wó ho jat yù bê.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Haú hkûn, yhumsîng hpó gi, 'Arâ! Nghut bê, kyet é dui-nhâng zoshâng ê, nàng gi, je tiq é mû má lháng wó lum é sû nghut é yanmai, wà raxê lé upzo lo aq hkoi.' ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Htang yuq le, lé mù luî, 'Yhumsîng ê, ngò, náng é ngùn rajoí mai, amyat ngo joí wó ho jat yù bê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yhumsîng gi, haú yuq lé, 'Nàng gi, wà ngo wâ lé up lo aq hkoi.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dum rayuq le, lé mù luî, 'Yhumsîng ê, náng é ngùn rajoí lé a byuq shoq, ngò panchoq èq htup tô lhê; wú aq, shî nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nàng gi, yhumsîng yhang a tô tô é zè pé lé yù nau é eq, yhumsîng yhang a hô tô é yò mai yâm yù nau é sû, byù wui nghut é yanmai, nang lé ngò gyuq ri.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Haú hkûn, yhumsîng gi, 'Agè ashop é dui-nhâng zoshâng ê, náng nhut mâ é dang eq rajung za, ngò, nang lé jéyáng râ nghut lhê. Ngò gi, yhumsîng yhang a tô tô é zè pé lé yù nau é eq, yhumsîng yhang a hô tô é yò mai yâm yù nau é sû, byù wuì nghut é hkyô lé, nàng sê to gù nghut le nhîng, ");
INSERT INTO atbNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ngá ngûn lé, ngò dum taû jé lô jáng, aráng eq amyat wó yû shoq, ngùn hpún kat jang má, haî mù a kat tô é lhú?' ga yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hau htâng, yhumsîng hpó gi, ayàm má yap tô é bang lé, 'Haû ngùn rajoí lé yhâng chyáng mai taû yù luî, raxê joí wó sû lé jat byi keq.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Haú bang gi, 'Yhumsîng ê, yhang gi, raxê joí wó to bê lé nhîng.' ga akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Haû jáng, yhang gi, 'Ngò, nungmoq lé taí kôlé, wó sû ó yuq le, jat byî é hui shirâ nghut lhê; a wó su chyáng mai kúm gi, yhang wó tô é lé lháng, yu pyám byi shirâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ahkuî, yhangmoq ahtoq má ngò hkohkâm kut râ lé a ô nau é, ngá é gyè pé lé, shí má shuî lé mù, ngá hí má sat pyám keq.' ga hkûnmó hkyô kat ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuq gi, shí hkyô pé lé ban taí jáng, hí má so luî, Yerusalem wà mó shut doq ló nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesuq gi, Yhâng é chángzô pé eq Tsanlun Bùm mâ é Bethpage wà eq Behtani wà má jé ló kojáng, Yhâng é chángzo í yuq lé, ");
INSERT INTO atbNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","\"Nungnhik, hí mâ é wà má ê keq; wà haú má wang é hkûn jáng, ó le a jî wú shî é logúng zo tuî tô láng é lé, ê myâng kó râ nghut lhê; haû lé hpyi yù mù, Ngá chyáng she lò keq. ");
INSERT INTO atbNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Byù rayuq yuq mai, 'Haû haî mù hpyi nyi akô?' ga nungnhik lé myi kôjáng, 'Shí du lé, haû Yhumsîng râ ri gâ.' nghû tû taí keq.\" ga pyîng luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nhang kat é sû nhik ê jé lé, Yesuq taî kat é dông yhang, dut to láng é lé ê myang akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yhangnhik logúng zo haú lé hpyi nyì kô é hkûn, yhumsîng wuì gi, \"Haû logúng zo lé, haî mù hpyi nyi akô lhú?\" ga luî, yhangnhik lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Haû jáng, yhangnhik gi, \"Shí du lé haû Yhumsîng râ ri gâ.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yhangnhik gi, haû logúng zo lé Yesuq chyáng she lò mù, yhangmoq é buhîng pé lé logúng ahtoq má buí luî, Yesuq lé doq ji nhang akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Haû su kut, Yhang ji e ló nyi le, byu pé gi, yhangmoq é buhîng pé lé hkyô má hkang byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ahkuî, Tsanlun Bùm hkêgyó gyó ló é jowò eq chyáng lo é mai gi, chángzô pé banshoq bang, yhangmoq myang é laklaí kumlhá pê é yanmai, gabú myit mai htê mó o mó èq Garai Gasang lé hkya-on kô é dang gi, ");
INSERT INTO atbNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","\"Haû Yhumsing é myìng mai jé lé lo é hkohkâm gi, hkungsô wó nyî sháng gaq ô! Mauhkûng htoq má, nguingón nyî sháng gaq ô! Htoq tsáng myhâng má, Garai Gasang gi, hpungwup shingkang bo nyì sháng gaq ô!\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Haû mù luî, haû byù hpûng hkaû má bo é Hparishe pé ra-am gi, \"Sará ê, náng é chángzô pé lé tân pyám aq.\" ga luî, Yesuq lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Haú hkûn, Yesuq gi, \"Ngò, nungmoq lé taí kôlé, shí bang zim za nyì kó é nghut le gi, luqgok pé garû lô râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ahkuî, Yesuq, Yerusalem wà mó eq chyâng lò luî, wà mó haû lé myàng jáng, haû wà mó é matú ngaù mù, taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","\"Wà nàng ê! Hkû-nyí lhê é buinyì má, nguingón é hkyô lé nàng bûn sé tô é nghut le gi, gè râ wá! Ahkuî kúm gi, haú hkyô lé nghop to bê nghut mù luî, nàng a sé lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hkâsu mù gâ le, náng chyáng Garai Gasang lé kûm jé é hkûn, nàng a bun a sé wú kat é yanmai, náng é gyè pé gi, awui ayàm má gyewap xuq mù, náng é lhîng hkyuq mai nang lé lom tô é buinyì jé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Haú hkûn, nang lé lhoq htên pyám luî, nung zo pé lé le, haú ahkaû má yhang dûn nhê pyet sat pyám bekô râ; nàng gi, luqgok racham htoq má racham lháng a kê lhum loshoq, dut byuq râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ahkuî, Yesuq gi, Yerusalem noqkuq yhûm má wàng mù, ung zo ung shuq é bang lé, \"'Ngá yhûm gi, kyûdung yhûm dut râ nghut lhê.' ga kâ to kôlhang, ");
INSERT INTO atbNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nungmoq gi, jowò shî lé 'damyaq hkyûng' kut akô.\" ga taí uchyang, hkat htoq pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yhang gi, nyí wuî noqkuq yhûm má mhoqshit nyi ri. Hkyangjong agyì pé, tarâ sará pé eq, byu pê é suwún wuî kúm gi, Yhang lé wó sat pyám râ hkyô ho nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nghut kôlhang, byù banshoq bang gi, Yhâng mhoqshit é dang lé gyo nau nyì kô é yanmai, wó sat râ hkyô lé, a myang hô kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ra-nyí lé, Yesuq gi, noqkuq yhûm wàng hkaû má, byu pé lé mhoqshit nyi é eq, gabú danglù hko kyô nyi é hkûn, hkyangjong agyi pé gi, tarâ sará pé, suwún wuî eq rahá kut, Yhâng chyáng lé jé kômù, ");
INSERT INTO atbNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","\"Hai ahko ahkâng èq Nàng shí pé lé kut nyi lhê lhú? Ahko ahkáng shî, Nang lé ó yuq byî é lhú? Ngamoq lé taî kyô wú aq.\" ga Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Haú hkûn, Yhang gi, \"Ngò le, nungmoq lé rajung myî wú kôlé; ");
INSERT INTO atbNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohan byî é baptisma gi, mauhkûng mai lhú? A nghut jáng, byu chyáng mai lhú? Ngo lé taî kyô wú keq?\" ga yhangmoq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Haú hkûn, yhangmoq chôm hpyê lhum kô é gi, \"'Mauhkûng mai nghut lhê.', nghû nga-nhúng taí jáng le, 'Haî mù, yhang lé a lumjíng kô é lhú?' ga râ nghut; ");
INSERT INTO atbNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Byu chyáng mai nghut lhê.' nghû jáng le, shiwa byù banshoq gi, Yohan lé, myiqhtoi rayuq ga lumjíng to kô é yanmai, yhangmoq, nga-nhúng lé luqgok èq dú sat kó râ nghut.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Haû mù, yhangmoq gi, \"Hkâmai nghut é lé, ngamoq a sé.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesuq gi, \"Haû jáng, Ngò le, hai ahko ahkâng èq shí pé kut é hkyô lé, nungmoq lé a taî kyo.\" ga, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Byu pé lé, Yesuq dangtú dông xoq taî kyô é gi, \"Byù rayuq gi, tsibyiq hkyâm ralhum saî to mù, hkyâm saí zo bâng chyáng ngho byî to luî, gó ming shut myáng myáng ê nyi byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kyôshu yoq jé jáng, yhang gi, hkyâm saí zo bâng èq, hkyâm mâ é tsibyiq shi pé lé lhom byî kat sháng gaq ga, dui-nhâng zoshâng rayuq lé yhangmoq chyáng nhang kat ri. Nghut kôlhang, hkyâm saí zo bang gi, haú yuq lé lhom bat mù, loq kôm taû nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Gotû dui-nhâng zoshâng rayuq lé, yhangmoq chyáng dum nhang kat ri. Nghut kôlhang, yhangmoq gi, haú yuq lé le, lhom bat mù, hoq lhoq hpu luî, loq kôm dum taû nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sum yuq nghû râ dui-nhâng zoshâng lé dum nhang kat ri. Yhangmoq gi, haú yuq lé le bat cheq luî, hkyâm mai hkat htoq kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Haú hkûn, tsibyiq hkyâm yhumsîng gi, 'Ngò hkâsu kut wú râ lhú? Ngò chyitdap é ngá zo lé, nhang kat wú râ nghut ri. Yhang lé kúm gi, yhangmoq lhom hkungga kó abe.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hkyâm saí zo bang gi, yhumsîng hpô é yhangzo lé myàng kôjáng, 'Shí yuq gi, silí wunlí sing yù râ sû nghut lhê; nga-nhúng, silí wunlí haú pé wó yû shoq, yhang lé sat pyám sháng.' ga rayuq eq rayuq taî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Haû mù, yhang lé hkyâm shinggan shut dú htoq kômù, sat pyâm akô. Haû su kut kôjáng, tsibyiq hkyâm yhumsîng gi, yhangmoq lé hkâsu kut râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yhang gi, ê mù, haû hkyâm saí zo bang lé sat pyám luî, hkyâm haû lé góbang lé htot ngho byî pyám râ nghut lhê.\" gâ ri. Dang haú lé wó gyo bang gi, \"Haû su gi, hkâ-nhám le a dut sháng gaq ô!\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hau htâng, Yesuq gi, yhangmoq lé byu wú luî, \"Haû jáng gi, 'Yhûm saí bâng èq hkyin htoq pyâm é luqgok gi, htungchyûn mâ é ahkyak dik é luqgok dut bê.' ga Chyúmdang má kâ tô é gi, haî gá nau é nghut lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Luqgok haú má gyó záng é sû ó yuq nghut kôle, gyuî gyop byuq râ nghut lhê. Luqgok hau èq gyó nhê záng é sû le, nhê pyeq pyâm é hui râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tarâ sará pé eq hkyangjong agyi pé gi, dangtú shí gi, yhangmoq lé lhoq ang luî taî é hkyô lé, sé kô é yanmai, haú hkûn jáng lháng Yhang lé chyup yû râ matú hkyô ho nyi akô. Nghut kôlhang, byu pé lé gyuq mù a chyup shi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Haû mù, yhangmoq gi, Yesuq é dang má mara wó chyup yû shoq ga, gegùn labyoq kut bang lé jowú nhang nyi akô. Haû gi, ahkáng ayá wó é mauzaû chyáng Yhang lé wó ap pyám râ matú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Haû jowú bang gi, \"Sará ê, nàng gi, díng díng mán mán taî mhoqshit é eq, byu é myoqdong lé a tê byî é za, Garai Gasâng é hkyô lé, tengmán é dông mhoqshit é sû nghut é lé, ngamoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hkoséng Kehtaq lé, ngamoq kang kat râ gi, tarâ wang lhê lhú? A wang é lhú?\" ga luî, Yhang lé myî wú akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nghut kôlhang, Yesuq gi, haú bâng é myit goí é hkyô lé sé mù luî, yhangmoq lé, ");
INSERT INTO atbNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","\"Ngo lé, ngùn rachap tûn shit wú keq. Ó yuq é alhô eq masat laiká dap tô ri lhú?\" ga myi jáng, ");
INSERT INTO atbNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","yhangmoq gi, \"Kehtaq é nghut ri.\" ga akô. Haú hkûn, Yesuq gi, \"Haû nghut jang, Kehtaq é lé gi, Kehtaq lé byi keq; Garai Gasâng é lé gi, Garai Gasang lé byi keq.\" ga yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yhangmoq gi, byu pê hí má, Yhâng é dang má mara a wó ho myang é eq, Yhang tû taî é dâng é yanmai, maú hong byuq kôluî, zim byuq akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Haú hkûn, haû dum dui toq hkyô a joq gâ é Saduke pé ra-am gi, Yesuq chyáng lé jé kômù, ");
INSERT INTO atbNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","\"Sará ê, myiwe wó é byù rayuq gi, zo dù a dap é za shi byuq é nghut jáng, yhanggu gi, yhangmâng é awut ashín xoq byi râ matú, yhâng rhat lé chui gon ra râ nghut lhê ga, nga-nhúng lé, Mosheq kâ to byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hí hpyang lé, gumang nhiktâng wuì nyhit yuq nyi akô. Lagám yuq gi, myiwe yù luî, zo dù a dap é za shi ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lanong yuq le, yhangmang mó é chui lé gon mù, zo dù a dap é za shi ló byuq bê. ");
INSERT INTO atbNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hau htâng, Lalaq yuq mai Lahkâ yuq jé shoq, chuimó haú lé rayuq htâng rayuq dum gon gon kut kôlhang, zo dù a dap é chyat shi ló byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ló htáng má, myiwe myhí haû le châng shi ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Haû mù luî, haû dum dui toq é buinyì má, myiwe myhí haû gi, haú nhiktâng wuì mâ é hká yuq é yhangmyi nghut râ lhú? Hkâsu mù gâ le, yhang gi, haû nyhit yuq é yhangmyi dut wú bê sû nghut ri.\" ga luî, Yhang lé myî wú akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Haú hkûn, Yesuq gi, \"Shî mingkan htoq mâ é byu pé gi, ikun kut é eq myi byi myi yû kut nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Shi é mai dum dui toq râ eq, haú pyat má nyì râ gíng bâng é matú gi, ikun kut é eq myi byi myi yû hkyô joq lo râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Haú bang gi, maumang lagyô pé su dut byuq luî, a dat shî lo kô râ nghut lhê. Yhangmoq gi, dum dui toq lô su é yhangzô pé nghut é yanmai, Garai Gasâng é yhangzô pé nghut bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Haû nyé duq nyi é mhanpúng eq séng luî, Mosheq èq kâ tô é má lháng, Yhumsîng gi, 'Ngò gi, Abraham é Garai Gasang, Isak é Garai Gasang, Yakup é Garai Gasang nghut lhê.' ga bo tô é yanmai, shi é bang dum dui toq lô râ hkyô lé tûn shit to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Garai Gasang gi, shi bê bâng é Garai Gasang a nghut, dui nyì bâng é Garai Gasang ru nghut nyi lhê; hkâsu mù gâ le, lhunglhâng bang gi, Garai Gasâng é hí má dui nyi é bang chyat nghut akô.\" ga yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Haú hkûn, tarâ sará pé ra-am gi, \"Sará ê, nàng taî é jô ri.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Haû mù, yhangmoq gi, Yhang lé haî le a wám myî jat lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hau htâng, Yesuq gi, yhangmoq lé, \"Byu pé gi, Hkrisduq lé, Dawiq é yhangzo nghut lhê, ga hkâsu mù taî akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Dawiq yhang yhang lháng gi, Hkya-on Kungtôn Laiká má, 'Haû Yhumsîng Garai gi, ngá é Yhumsîng lé, \"Ngò, náng é gyè pé lé, náng é hkyî nang tanghkuq kut pyám byî é hkyíng jé shoq, Ngá é loqyo hkyam shut zung nyì shi aq.\" gâ ri.' ga kâ tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Haû mù, Dawiq yhang lháng, Hkrisduq lé, Yhumsîng gâ é nghut le gi, Hkrisduq gi, yhangzo za hkâsu ge nghut râ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Byù banshoq gyô nyi é u lé, Yesuq, Yhâng é chángzô pé lé taî é gi, ");
INSERT INTO atbNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"Tarâ sará pé lé sidiq nyì keq. Yhangmoq gi, réng é buhîng wut chûng mù, sô yông wún luî, gaì pé má hkunggâ é èq shichyen râ lé le, tarajong pé mâ é ahkyak dik é zùng jang pé eq poî pé mâ é je réng é zùng jowò pé má myang zùng râ lé le, ô nau nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yhangmoq gi, chuimó pê é yhûm-yò pé lé hpyoq zo hpyoq shuq kôluî, kyû hîng hîng dûng shit mhaû é bang nghut akô. Haû sû é bang gi, je riyhang htan é dông dam byî é hui zo kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesuq tu wú kat é hkûn lé, noqkuq yhûm mâ é alu sidek má, wó bang alu kat nyi bùm kô é lé myang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dum nghut jáng, gyi htingchap ngùn zo í chap za kat é, myung é chuimó myhí rayuq lé le myang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Haû mù, Yhang gi, \"Ngò, nungmoq lé teng za taí kôlé, shî myung é chuimó myhí gi, góbang banshoq htoq má je myo kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hkâsu mù gâ le, haû góbang banshoq gi, yhumsîng agùn agó wó é mâ é lé, lé kat akô; yhang kúm gi, myùng sû nghut kôle, yhâng asak lé baú ra ngùn lhunglháng lé kat bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Noqkuq yhûm lé, yúng é luqgok pê èq le, alu chyunghuq pê èq le, mhôn tô ri ga, chángzô pé ra-am hkya-ôn bùm kôjáng, Yesuq gi, ");
INSERT INTO atbNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","\"Nungmoq myang nyi é shí pé gi, luqgok rachâm htoq racham lháng a kê lhum loshoq, hpyoq hpyi pyâm é buinyì jé râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Haû su ga jáng, yhangmoq gi, \"Sará ê, haû nghut le gi, haú hkyô pé gi, hkâ-nhám dut lô râ lhú? Haû dut râ chyâng lò jáng, hkasû é kumlhá htoq lô râ nghut lhê lhú?\" ga, Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Haú hkûn, Yhang gi, \"Nungmoq gi, hkyô shuî nghoq é a hui kó sháng gaq, sidiq nyì keq. Hkâsu mù gâ le, 'Ngò gi, Mesaia nghut lhê.' ga le, 'Ahkyíng chyâng lò bê.' ga le, Ngá myîng lé lâng é byù myo myo pô htoq lô kó râ nghut lhê. Nghut kôlhang, nungmoq gi, yhangmoq htâng hkâcháng kó. ");
INSERT INTO atbNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Majan htoq é eq, gumlau toq é hkyô lé, wó gyo kôjáng, hkâgyuq hkâ-kyûm kó, haú hkyô pé hí dut lò râ nghut lhê. Nghut kôlhang, ló htâng é buinyì gi, haú hkûn jáng dut râ a nghut shi.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hau htâng, Yhang, yhangmoq lé dum taî é gi, \"Ra-myû eq ra-myû, mingdán ralhum eq ralhum majan zân lhûm lò kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jowò myo myo má, layàng mó nún lo é, nolì nojàng myô lo é eq mutmó gyó lo é pé, dut lò râ nghut lhê; gyuq chiq jung pé eq kumlhá mó le, mauhkûng htoq mai htoq shit lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nghut kôlhang, haû hkyô banshoq a dut shimá, Ngá mying é yanmai, byu pé gi, nungmoq lé chyup yû luî, zing-rî yù mù, tarajong pé eq htóng pé má ap pyám kó râ nghut lhê, hau htoq agó, nungmoq gi, hkohkam pé eq zau pê chyáng ê ap byî é le, hui kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Haû su é pé mai, nungmoq gi, ngò eq séng luî, saksé wó hkám râ hkyô htoq lô berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nghut kôlhang, hkâsu nghû lhom tû taí râ hkyô lé, hí mai a myit wuî nyì râ lé, nungmoq myit hpyit to keq. ");
INSERT INTO atbNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Hkâsu mù gâ le, nungmoq é gye pé lhunglhâng bang, haî le a wó lhom tû taí loshoq, ngò, nungmoq lé dang eq hpaqchyî byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nghut kôlhang, nungmoq gi, înu îwâ pé, âgu âmâng pé, mungmoq eq buinùm ji-myi wui èq lháng, ap pyâm é hui kó râ nghut lhê. Yhangmoq gi, nungmoq chyáng mâ é ra-am lé lháng, sat pyám kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Byù lhunglhâng bang gi, Ngá é yanmai, nungmoq lé a nguì kut kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nghut kôlhang, nungmoq é xâm rahkat lháng wó htên byuq râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nungmoq gi, wó jân é hkyô mai, asak lé wó yû kô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yerusalem wà mó lé gyè hpúng mó èq lóm tô é lé, nungmoq myàng jáng, wà mó haû htên byuq râ ahkyíng chyâng lò bê lé, bûn sê nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Haú hkûn lé, Yuda mau má nyi é bang gi, bùm pé shut hpang doq ló kó sháng gaq; haû wà hkaû má nyi é bang le, hpang htoq kó sháng gaq; wà tiq wà zo pé má nyi é bang le, wà hkaû shut a wàng kó sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Hkâsu mù gâ le, Chyúmdang má kâ to má kâ to banshoq dik lò râ matú, buinyì haú pé gi, mara dam byî é buinyì pé dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Haû buinyì pé má, zogûng dut é myiwe wuì eq naú huq ashî nghut é înu wuì gi, gyai yhang wuîhke kô râ nghut lhê; hkâsu mù gâ le, shí mîng ahtoq má wuîhke mó eq, shí amyu ahtoq má Garai Gasang nhikmó-yô é jé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yhangmoq gi, shâm lhâm èq sat pyám hui lhê eq, ming hkang ming mó má chyup shuî ló é le hui kó râ nghut lhê. Tûngbaù pé lé byî tô é buinyì ahkyíng htáng shoq, Yerusalem wà mó gi, tûngbaù pê èq nâng zik tô é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Haú hkûn, buì, kyî, lhamó pé má, kumlhá htoq shit râ nghut lhê. Wuishuq lung-aû mâ é wuìlhêng pê é mying é htê mó é yanmai, myigùng htoq má, byù myû chângjup gi, hkâsu kut râ a sé loshoq maú é eq myit wui myit hkê é hui bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Byu pé gi, mingkan htoq má dut lò râ é hkyô pé lé, a jé shi mai myit gyuq kô é yanmai, moq byuq ló bûm kó râ nghut lhê; hkâsu mù gâ le, mauhkûng mâ é wum-o a-tsam pé gi, lhoq nhûn é huî bùm kô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Haú hkûn, haû Byu Yhangzo gi, mhut ji mù, hpungwup a-tsam mó eq le, hpungwup shingkang mó eq le, gyó lé lo é lé, yhangmoq byu-myàng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Haú hkyô pé dut hi lò jáng, ulhum tû mù wú kat keq, hkâsu mù gâ le, nungmoq lé hkyi yù râ buinyì gi, chyâng lò bê nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yhang, yhangmoq lé dangtú dông xoq taî é gi, \"Maihpáng gâm eq sikgâm banshoq lé wú wú keq. ");
INSERT INTO atbNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sikbu nyún lo é lé myàng jáng, buì nyé nám chyâng lò bê ga luî, nungmoq yhang dat wú sê akô. ");
INSERT INTO atbNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Haû eq rajung za, haú hkyô pé dut nyi é lé, nungmoq myàng kôjáng, Garai Gasâng é mingdán gi, chyáng bê nghut é hkyô lé, nungmoq sé lo keq. ");
INSERT INTO atbNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ngò, nungmoq lé teng za taí kôlé, shí pyat mâ é byu pé a ban shi byuq shimá, haú hkyô pé banshoq dut byuq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mauhkûng eq myigùng gi, a joq lo dut byuq râ nghut lhê; nghut kôlhang, Ngá é dang gi, ru joq nyî râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","\"Nghut kôlhang, zo myo shuq myô é, î shuq wut é, mingkan htoq mâ é myit wui myit hkê é pê èq, nungmoq é i-myit wò laî nyì luî, haû ngò jé lé é buinyì gi, lhaí bik lo é su, nungmoq ahtoq má byodàn tung a jé lò sháng gaq, sidiq nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hkâsu mù gâ le, buinyì haû gi, mingkan htoq má nyi é byù banshoq bâng é ahtoq má, haû su jé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Haû mù luî, haû dut lò râ hkyô banshoq mai, nungmoq wó lut lai mù, haû Byu Yhangzô é hí má, wó yap gîng é bang dut sháng gaq, hkâ-nhám le kyûdung luî, ahkyíng hkangmó má machya nyì keq.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesuq gi, nyí wuî noqkuq yhûm má mhoqshit nyî luî, myìn wuî Tsanlun Bùm gâ é bùm shut htoq ê mù, ê nyi to to kut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Byù banshoq bang gi, Yhang mhoqshit é dang gyo râ ga, napsûn noq noq mai noqkuq yhûm má jé lé bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ahkuî, Lhoqlhai Poî gâ é Azuma (múnchi a kat é Muk Zo Poî) jé râ chyâng lò bê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Haû mù, hkyangjong agyi pé eq tarâ sará pé gi, Yesuq lé hkâsu kut wó sat pyám râ hkyô, ho nyi akô; hkâsu mù gâ le, yhangmoq gi, mingbyû wuì lé gyuq bùm kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Haú hkûn, lagyo raxe í yuq má bo é Iskarut gâ é Yudaq chyáng Tsadán wàng mù luî, ");
INSERT INTO atbNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","yhang gi, htoq ê mù Yesuq lé hkâsu kut ap pyám râ hkyô lé hkyangjong agyi pé, noqkuq yhûm zúng é gyezau pé eq, ê hpyê ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Haû mù, yhangmoq gi, gyô nguì luî, Yudaq lé ngùn byi râ hkyô myit hui bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudaq le hap yù luî, byù hpúng má a nghut é hkûn, Yesuq lé ap pyám râ hkyô ho nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ahkuî, haû Lhoqlhai Poî mâ é sauzo shigu hkungga sat nhông byi râ é Azuma buinyì jé bê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Haú hkûn, Yesuq gi, Petruq eq Yohan lé, \"Nga-nhúng zo râ matú Lhoqlhai Poî ê món láng keq.\" ga luî, nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Haú nhik gi, \"Hkâmá ê món to nhâng nau ri lhú?\" ga luî, Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Haú hkûn, Yesuq gi, \"Nungnhik, myuq hkaû shut wang e ló le wuì yambú waq é byù rayuq lhom hui râ nghut lhê; haú yuq chyáng châng ló luî, yhang wang ló é yhûm má châng wàng mù, ");
INSERT INTO atbNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yhumsîng lé, 'Ngò Ngá é chángzô pé eq rahá, Lhoqlhai Poî zo râ bíng wap hkâmá nghut lhê lhú ga, Sará myí nhang kat ri.' nghû taí keq. ");
INSERT INTO atbNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Haú hkûn, hen tô é ahtoq mâ é wap mó lé, nungnhik lé lhom tûn shit râ nghut lhê; wap haú má ê món to keq.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Haû chángzo nhik htoq e ló le, Yesuq taí kat é eq roq za ê myâng kômù, Lhoqlhai Poî lé món to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ahkuî, ahkyíng jé jáng, Yesuq eq Yhâng é chángzô pé rahá za zohpoq má zung tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Haú hkûn, Yesuq gi, \"Ngò wuîhke jamjau hpuzô é a hui shi má, Lhoqlhai Poî shî lé nungmoq eq rahá zo râ lé, Ngò gyai ô nau nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hkâsu mù gâ le, ngò, nungmoq lé taí kôlé, Garai Gasâng é mingdán má poî shî a ló dik dik gi, ngò haû lé dum zo râ a nghut ló.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hau htâng, Yesuq gi, góm lé yù mù jeju ban hkya-on jáng, \"Góm shî lé yù luî, nungmoq yhangchang gàm shuq lhum keq. ");
INSERT INTO atbNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngò, nungmoq lé taí kôlé, ahkuî mai gi, Ngò, Garai Gasâng é mingdán a jé jé tsibyiq wing lé dum shuq râ a nghut lo.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hau htâng, Yhang gi, muk lé yù mù, jeju hkya-on luî, muk lé myhik hpé mù, yhangmoq lé byi uchyang, \"Shî gi, nungmoq é matú byî pyâm é, Ngá é gungdu nghut lhê; Ngo lé bûn nyì râ matú, shî su kut nyî keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Haû eq rajung za, myinzang ban zo jáng, góm lé le yù mù, \"Góm shî gi, nungmoq é matú htoq pyâm é, Ngá é sui má xuq tô é dangshikaq asik nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nghut kôlhang, wú keq, Ngo lé ap pyám râ sû gi, zang bó shî má ngò eq rahá nyi tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Haû Byu Yhangzo gi, hkyin to huî é eq rajung za shî râ nghut lhê; nghut kôlhang, Yhang lé ap pyâm é sû gi, dingnyé wó ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Haû su ga jáng, lagyô pé gi, yhangmoq má shí hkyô kut râ sû gi, hká yuq nghut râ lhú ga, rayuq eq rayuq myî lhum bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Haû htoq agó, yhangmoq mâ é hká yuq sheq je kô lhê lhú ga le, rayuq eq rayuq taî htîng lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Haû mù luî, Yesuq gi, \"Tûngbaù pê é hkohkam pé gi, yhangmoq byù myû pê é ahtoq má up zô nyì kô é nghut luî, byu pé gi, ahkáng ayá wó é bang lé jeju yhumsing pé ga luî, taî hkungga nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nungmoq kúm gi, haû su hkâkut kó. Nungmoq má je ko sû gi, asak je tiq é sû su, up é sû le, dui-nhâng zoshâng su nghut nyì sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hká yuq sheq je kô lhê lhú? Zô zung nyì sû lhú? Haû a nghut jáng, saí tsô é sû lhú? Zô zung nyi é sû sheq nghut ri. Nghut kôlhang, ngò gi, nungmoq mâ é saí tso sû su za nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nungmoq kúm gi, Ngò jamjau huî nyi le, Ngò eq rahá nyi nyi é bang nghut nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Haû su mù, Ngá wa gi, Ngo lé, mingdán ap byî é su, Ngò le, nungmoq lé mingdán ap byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Haû mù, Ngá é mingdán mâ é, Ngá é zangbó má, nungmoq wó zo kó râ nghut lhê; nungmoq le hkohkâm-tanghkuq má zung to mù, Israelaq amyû raxe í hú lé jéyáng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simun, Simun ê, wú aq, sungsô cham lé shaî é su, nungmoq lé wó shaí shoq ga, Tsadán wá gi, ahkáng dung bê. ");
INSERT INTO atbNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nghut kôlhang, náng é lumjíng myit a hten sháng gaq nghû, Ngò, náng é matú kyûdung byi bê; nàng dum lhing bûn lò jáng, nung gu nung mâng pé lé wum-o lhoq ging byi aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Haú hkûn, Simun gi, \"Yhumsîng ê, htóng wâng kôlhang, shî kôlhang, ngò gi, nàng eq rahá cháng râ matú myit hpyit to bê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuq gi, \"Petruq ê, nang lé Ngò taí lé, hkû-nyí lháng woq a tûn shi má, nàng, Ngo lé a sé ga luî sum dâm he-ngik pyám râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hau htâng, Yesuq, yhangmoq lé taî é gi, \"Ngò, nungmoq lé ngunhtûng, jihtûng, hkyî-tsung a wùn a chûng nhang é za, nhang kat é nghut hkûn, nungmoq chyáng haî ra akô lhú?\" ga myi jáng, yhangmoq gi, \"Haî le a ra lo.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Haú hkûn, Yhang gi, \"Ahkuî kúm gi, ngunhtûng wó sû gi, yù wun sháng gaq, jihtûng wó sû le, yù wùn sháng gaq, shâm a wó sû gi, bumó ung luî wuì sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hkâsu mù gâ le, Ngò, nungmoq lé taí kôlé, Ngò eq séng luî Chyúmdang má kâ tô é gi, dut lò berâ nghut lhê; 'Haú yuq gi, yubak mara wó bang má nghap lhôm to bê.' ga kâ tô é dang gi, Ngá chyáng dik lò râ nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Haû mù, lagyô pé gi, \"Yhumsîng ê, wú aq, shí má shâm í hkyam joq tô ri.\" ga taí kôjáng, Yesuq gi, \"Gé bê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ahkuî, Yesuq gi, htoq luî, gó hkun é eq rajung za, Tsanlun Bùm shut htoq e ló bê nghut ri; Yhâng é chángzô pé le Yhang htâng châng e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Haú jowò má jé jáng, Yhang gi, \"Nungmoq, gunglaú é a hui sháng gaq, kyûdûng nyì keq.\" ga luî, yhangmoq lé taî to mù, ");
INSERT INTO atbNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","chángzô pé nyi é mai luqgok radú we kô gâng e ló luî, hkyihput htuq mù, ");
INSERT INTO atbNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","\"Âwa ê, Náng ô nau é nghut le gi, góm shî lé Ngá chyáng mai lhaî pyám byi laq. Nghut kôlhang, Ngò ô nau é dông a nghut, Nàng ô é dông sheq nghut sháng gaq.\" ga kyûdûng ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Haú hkûn, mauhkûng mai maumang lagyo rayuq htoq lé luî, Yhang lé i-myit nhik lé taî tîng ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","I-myit hkaû má dik shoq hkâm zo wuî é yanmai, Yhang je riyhang kyûdung wum kat nyi ri; Yhâng é buibù le, sui hkyí sui pat su myigùng má yui gyó ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Haû mù, kyû ban dung jáng, Yhang toq luî, chángzô pê chyáng ló wú le, yhangmoq gi, myit yón mù luî, yhup myhî to kô é lé ló myâng mù, ");
INSERT INTO atbNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","\"Haî mù yhup nyi akô lhú? Toq keq! Gunglaú é a hui sháng gaq, kyûdûng nyì keq.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Haû su ga, ru taî nyi ashî le, wú keq, haû chángzo raxe í yuq má bo é Yudaq gi, hkyô hí mù byù rajùm rayò lé shuî lé lô luî, yhang gi, Yesuq lé bopuq puq râ ga huî lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Haû mù luî, Yesuq gi, \"Yudaq ê, nàng gi, haû Byu Yhangzo lé bopuq puq é èq gyè pê chyáng ap pyâm lhê lhú?\" ga luî, yhang lé lhom myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Haú hkûn, Yesuq htâng cháng bang gi, haî dut lò râ lé bûn sé kô é yanmai, \"Yhumsîng ê, ngamoq gi, sham èq zân le, gè râ lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yhangmoq chyáng mâ é rayuq gi, hkyangjong mó é dui-nhâng zoshâng lé zân kat luî, yhâng é loqyo nohkyap byit byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesuq kúm gi, \"Gé bê. Yhangmoq ô nau é su nghut kó sháng gaq.\" ga tû taí mù, haú yuq é nohkyap lé ê záng luî lhoq gê byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesuq gi, Yhang lé chyup râ ga jé lé é hkyangjong agyi pé, noqkuq yhûm zúng é zau pé eq agyì suwún wuî lé, \"Nungmoq gi, damyaq rayuq lé chyup é su, shâm, dumbáng eq kut luî, lé lo akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngò gi, nyí wuî, noqkuq yhûm má nungmoq eq rahá nyì kôlhang, nungmoq Ngo lé chyup yû râ ga a hen wú kó; ahkuî gi, mauchut èq up nyi bê yanmai, nungmoq é ahkyíng nghut nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Haú hkûn, yhangmoq gi, Yhang lé chyup yû mù she ló luî, hkyangjong mó é yhûm shut shuî wang ló akô. Petruq le we we mai châng tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ahkuî, yhangmoq gi, wàng hkaû má myi mut yû luî zung tô bum é hkûn, Petruq le yhangmoq é ahkaû má bo tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Langchyáng myhí rayuq gi, myihkyom yâm má Petruq zung tô é lé, myang kat mù, yhang lé rago wú tsuq to luî, \"Shí yuq le Yesuq eq rahá nyì sû nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Haú hkûn, Petruq gi, \"Myiwe myhí ê, nàng taî é sû lé, ngò a sé.\" ga he pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hau htâng hkâ-myháng a myáng má, byù rayuq gi, yhang lé dum myàng luî, \"Nàng le yhangmoq chyáng bo nyì sû nghut ri.\" ga taí kat jáng, Petruq gi, \"Byù hpó ê, ngò a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hkyíng hkum rahkum kô myáng jáng, rayuq le, \"Gè gè yhang, shí yuq gi, Yhang eq rahá nyi wún sû nghut ri; haî mù gâ le, yhang gi, Galile byù le nghut ri.\" ga zuq zuq taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petruq gi, \"Byù hpó ê, nàng taî nyi é hkyô lé, ngò a sé.\" ga tû taî ri. Haû su ga ru taî nyi ashî le, woq tûn bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Haú hkûn, Yesuq gi, lhîng luî, Petruq lé wú kat ri. Haû mù, Petruq gi, \"Hkû-nyí lháng, woq a tûn shi má, nàng Ngo lé sum dâm he pyám râ nghut lhê.\" ga luî, Yhumsîng yhang lé taî é dang lé bûn kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Haû mù, yhang gi, shinggan shut htoq ê luî, gyai yhang ê ngau nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuq lé zúng nyi é bang gi, Yhang lé rhoî luî nghap myíng nghap htê mu nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yhangmoq gi, Yhâng é myoqdong nghop pyám byi luî, \"Nang lé bat sû gi, ó yuq nghut ri lhú? Myiqhtoi htoî wú aq.\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yhangmoq gi, Yhang lé nyhap é dang ajung jung dông taî rhoi nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Napkyó myoqmyàng jáng, mingbyû wui é suwún hpúng bang eq rahá, hkyangjong agyi pé, tarâ sará pé, zup hpong kut nyi é má, Yesuq lé shuî ê mù, ");
INSERT INTO atbNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","\"Nàng Hkrisduq nghut é têng le gi, ngamoq lé taî kyo laq.\" gâ akô. Yesuq gi, \"Ngò gi, Hkrisduq nghut lhê nghû taí kôlhang, nungmoq jíng kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngò, nungmoq lé myi kôlhang, nungmoq gi, tû taí kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nghut kôlhang, ahkuî mai haû Byu Yhangzo gi, a-tsam bo dik é Garai Gasâng é loqyò hkyam má wó zung nyì berâ nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Haú hkûn, yhangmoq banshoq bang gi, \"Haû nghut le gi, Nàng, Garai Gasâng é Yhangzo nghut lhê lhú?\" ga myî akô. Yesuq gi, \"Nungmoq taî é eq rajung za Ngò nghut lhê.\" ga luî, yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Haú hkûn, yhangmoq gi, \"Nga-nhúng haí jung saksé wá râ nyi ashî lhú? Yhâng é nhut mai yhang, taî htoq kat é dang lé, nga-nhúng wó gyo bê nghut lhê.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Haú hkûn, zup zîng tô é bang banshoq gi, htoq mù, Yesuq lé mauzau Pilat chyáng shuî wang ê luî, ");
INSERT INTO atbNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","\"Shí yuq gi, mingbyû wuì lé hkyô shuî nghoq é eq, hkoséng Kehtaq chyáng kang kat râ hkyô lé le hkûm to luî, Yhânggùng yhang gi, haû Hkrisduq nghû é hkohkâm nghut lhê ga luî, taî nyi é lé ngamoq myang ri.\" ga luî, Yhang lé mara hun akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Haú hkûn, Pilat gi, Yesuq lé, \"Nàng gi, Yudaq byu pê é hkohkâm nghut lhê lhú?\" ga myi jáng, Yesuq gi, \"Nàng taî é eq rajung za nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat gi, \"Shí yuq lé hûn râ mara ngò a myàng.\" ga luî, hkyangjong agyi pé eq shiwa byu pé lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nghut kôlhang, haú bang gi, \"Shí yuq gi, Yuda mau gón má yhang mhoqshit é dông mai, mingbyû wui é i-myit lé shuî gabyông ri. Haû gi, Galile mau mai ahkuî shî má jé shoq nghut bê nghut ri.\" ga zuq zuq taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat gi, haû su ga kô é lé wó gyo jáng, Yesuq Galile byù nghut é, a nghut é hkyô lé myî wú ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesuq gi, Herut up é mau mâ é byù nghut é lé Pilat sé jáng, haú u lé Yerusalem wà mó má nyi tô é Herut chyáng, ê dé kat nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herut gi, Yesuq lé myàng jáng, gyai yhang gabú pyâm ri. Hkâsu mù gâ le, Yhâng é hkyô lé wó gyô wú mù, Yhang laklaí kumlhá ralhum lhum kut shit râ lé, wó myâng shoq ga, myit myoqbyu nyi é nghut luî, Yhang lé myàng nau é gyai yhang myáng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Haû mù, yhang gi, Yesuq lé dangmyi myo myô èq myî wú kôlhang, Yesuq gi, dang rahkun lháng a tû taí byi nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hkyangjong agyì pé eq tarâ sará pé gi, yap to mù, Yhang lé mara gyai yhang chôm hun akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herut eq yhâng é gyezô pé gi, Yesuq lé rhoî jihkyoî kut mù, atam é dông taî hpoî kô luî, réng é mebu hut byi mù, Pilat chyáng dum taû dé nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Haû nyí jáng, hí hpyang gyè dut lhûm é Herut eq Pilat gi, buinùm dut byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Haú hkûn, Pilat gi, hkyangjong agyi pé eq zau suwún wuî, mingbyû wuì lé wut tsîng to mù, ");
INSERT INTO atbNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","\"Shí yuq gi, mingbyû wuì lé hkyô shuî nghoq ri ga, Yhang lé nungmoq ngá chyáng shuî lé lô bekô. Ahkuî, wú keq, nungmoq é hí má, Yhang lé ngò myî wú le, Yhang má nungmoq hun é mara lé ngò a myàng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hau htoq agó, Herut le, hai mara le a myàng mû, shí yuq lé nga-nhûng chyáng dum dé kat byi bê nghut ri; haû mù luî, wú keq, shí yuq gi, shî gíng é mara haî le a kut shut nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Haû mù, ngò, Yhang lé dam byi luî, nhang pyám râ.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nghut kôlhang, Lhoqlhai Poî hkangmó má, Pilat gi, mingbyû wuì lé htongbyû rayuq yuq nhang kat byi byi kut é yanmai, ");
INSERT INTO atbNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","yhangmoq banshoq bang gi, \"Shí yuq lé gi, yu pyám aq; Barabaq lé kúm gi, nhang kat byi laq.\" ga luî, chôm wut garu bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabaq gi, wà htum má gumlau kut é eq byù sat é yanmai, htóng gyó nyî sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat gi, Yesuq lé nhang pyám nau é nghut mù luî, yhangmoq lé dum puq taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nghut kôlhang, yhangmoq gi, \"Yhang lé tapzîng má jén tap pyám aq, jén tap pyám aq!\" ga luî, wut taî garû nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Haû mù luî, sum dâm nghû râ hkûn, Pilat dum taî é gi, \"Haî mù luî lhú? Yhang gi, hai mara kut shut bê lhú? Yhang má shî gíng é mara lé ngò a myàng, haû mù, ngò, Yhang lé bat, nhuq, mhoqshit luî, nhang pyám râ.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yhangmoq gi, Yesuq lé tapzîng má wó jén sat pyám shoq ga, zuq zuq htê mó o mó èq dûng wut nyi akô nghut é yanmai, wó taî ung yù bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Haû mù luî, Pilat gi, yhangmoq dûng é eq rajung za myit hpyit doqdan byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Haû su mù, yhang gi, yhangmoq dûng é eq rajung za, wà htum má gumlau kut é eq byù sat é mai, htóng gyó nyî sû lé nhang kat byi luî; Yesuq lé gi, yhangmoq ô nau é dông ap byi kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yhangmoq gi, Yesuq lé shuî htoq ló kô é hkûn, yosô wà mai lo é, Kuruni myuq byû nghut é Simun ga sû lé, chyup yû mù, tapzîng waq nhâng luî, Yesuq htâng má cháng nhang akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Byù rajùm rayò gi, Yhang htâng má châng e ló bum akô. Yhang é yanmai ngaubyi ngaù nhap eq iyon yôn é myiwe zo wuì le haú má bo tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesuq gi, yhangmoq shut lhîng wú luî, \"Yerusalem byizo wuì ê, Ngá é yanmai hkâ-ngau nyì kó, nungmoq gi, yhumsing gùng eq yhumsing é zo dù wui é matú sheq ngau nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hkâsu mù gâ le, 'Zogûng a dut wú é eq naú a huq wú é baùdung myhí pé gi, hkungsô wó nyi ri.' ga luî, taî é buinyì gi, jé lô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Haú buinyì má, byu pé gi, bùm pé lé, 'Ngamoq ahtoq má byoq nhé aq!' ga luî le, kong pé lé, 'Ngamoq ahtoq má nghop aq!' ga luî le, wut taî bùm bekô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Byu pé gi, sikgâm jûm tô ashî le isu kut kô é nghut le gi, màn jáng gi, hkâsu wá dut lò râ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Haú hkûn, damyaq í yuq lé le, sat pyám râ ga, Yesuq eq rahá shuî htoq ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ahkuî, Ugyap nghu é kong má jé jáng, Yesuq lé tapzîng htoq má jén tap tô é hkûn, damyaq í yuq lé le, loqpai loqyò shut kut luî tapzîng má jén tap tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Haú hkûn, Yesuq gi, \"Âwa ê, yhangmoq lé mara hkyut pyám byi laq; hkâsu mù gâ le, yhangmoq kut é hkyô lé yhangmoq a sé kó nghut ri.\" ga taî ri. Gyezô pé gi, Yhâng é mebu pé lé lháng, hkyîn shosé she é dông gam yu pyám byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mingbyû wuì gi, yap to mù tu wú nyi akô. Zau suwún wuî Yhang lé nyhap é gi, \"Yhang gi, byù góbang lé hkyi yu é sû nghut ri. Yhang gi, Garai Gasang hkyin yu é sû Hkrisduq nghut le gi; Yhânggùng yhang le hkyi yu wú sháng gaq.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Gyezô pé le, huî ê mù, rhoî nyaú nyaú akô. Yhangmoq gi, chyîn wing lé yhun byi kôluî, ");
INSERT INTO atbNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","\"Nàng gi, Yudaq byu pê é hkohkâm nghut é nghut le gi, Náng gûng yhang nàng, hkyi yu wú aq.\" ga Yhang lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yhâng é ulhum ahtoq má le, (Grik dông le, Latin dông le, Hebre dông le) \"SHÍ YUQ GI, YUDAQ BYU PÊ É HKOHKÂM.\" gâ é laiká kâ tap tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tapzîng htoq má bat tap lhâng to huî é damyaq rayuq gi, \"Nàng gi, Hkrisduq nghut lhê, a nghut lhú? Haû Náng gûng nàng le, ngá-nhik lé le, hkyi yù aq.\" ga luî, Yhang lé rhoî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Damyaq góyuq sû kúm gi, \"Nàng le shî yuq eq rajung za jén tô é hui luî nhîng, Garai Gasang lé a gyuq lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nga-nhik gi, yhumsîng kut shut é mara eq rajung za, jéyáng hui zo gíng é sû nhik nghut lhê; shí yuq kúm gi, hai mara lé kut shut wú sû a nghut.\" ga luî, haú yuq lé tân kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hau htâng, yhang Yesuq lé taî é gi, \"Yesuq ê, Nàng, Náng é mingdán má jé ló jáng, ngo lé myit bun laq ô.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Haú hkûn, Yesuq gi, \"Ngò, nang lé teng za taí lé, hkû-nyí yhang nàng Ngò eq rahá hparadisu má nyì râ nghut lhê.\" ga luî, yhang lé tû taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Haú ahkyíng gi, nyí káng raxe í hkyíng nghut luî, myinhtâng sum hkyíng jé shoq ramau gón mauchut tuq dut byuq bê nghut ri; ");
INSERT INTO atbNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","hkâsu mù gâ le, builoq shum byuq é yanmai nghut ri. Noqkuq yhûm mâ é pán-gyang le, í hkyam byáng dut byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Haú hkûn, Yesuq gi, \"Âwa ê, Ngò, Ngá é woi-nyí náng é loq má ap byî lhê.\" ga htê mó èq garû kat ri. Haû su ga ban taí eq, Yhang kâng byit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Shô up gyezau hpó gi, haû su dut é lé myàng jáng, \"Shí yuq gi, gè gè yhang, dingmán sû nghut ri.\" ga luî, Garai Gasang lé hkya-on kungton ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Haû hkyô lé wú râ ga, lé zîng tô é byù lhunglhâng bang le, haû su dut é hkyô pé lé myàng kôjáng, myit yón kôluî, wànggàng bat mù, dum taû ló byuq bekô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nghut kôlhang, Yhang lé sê é bang eq Galile mau mai Yhang htâng châng é myiwe wuì gi, we we má yap to mù, haú hkyô pé lé byu wú nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Haú hkûn, Yuda mau Aramahti gâ é myuq má, Yosep gâ é sû rayuq nyi ri. Haú yuq gi, nhik bo é sû eq dingmán é sû nghut é htoq agó, Garai Gasâng é mingdán jé râ hkyô lé myit myoqbyu to sû le, nghut mù luî, ");
INSERT INTO atbNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yhang gi, Yudaq uphkâng hpúng mâ é rayuq nghut kôlhang, hpyé lhûm é hkyô má le, zui saí é hkyô má le, myit a bo huî lom é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yhang gi, Pilat chyáng wàng luî, Yesuq é gungsôm lé dûng yu ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Haû mù, gungsôm haú lé tapzîng mai hkyut hkyô yù luî, pán yúng èq htup yup mù, ó lé lháng a kat wú shî é, luqgok lé kyûng tô é luqgok lup hkaû má kat tô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Haú nyí gi, Hên Lajang Buinyì nghut luî, Bánno buinyì jé râ za nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galile mau mai Yesuq eq rahá htoq lé lo é myiwe zo wuî le, Yosep htâng má châng ê luî, lup haú lé le, Yesuq é gungsôm lé le, hkâsu kut tô tô é lé, ê myang akô. ");
INSERT INTO atbNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hau htâng, yhangmoq gi, yhûm shut taû lò mù, Yesuq é gùng sôm lé but byi râ matú, namngón é jung eq mura xû lé hen tô akô. Bánno buinyì má kúm gi, tarâ joq é eq rajung za, yhangmoq yuban bân nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bánno buinyì htang napsûn noq le, myiwe wuì gi, yhangmoq hen tô é namngón jung pé lé yu chûng mù, lup shut e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yhangmoq gi, lup mâ é luqhkum lêng bóng to láng é lé, ê myâng kômù, ");
INSERT INTO atbNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","wang e wú kô le, haû Yhumsîng Yesuq é gungsôm lé, a myàng lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yhangmoq maú úng-âng nyi bùm kô é hkûn, radá dâm maulhap su duqbó é mebu wut é byù í yuq, yhangmoq é nàm má yap tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Haû mù, myiwe haú bang gi, gyuq dan bum kôluî, myigùng shut myoqdong ngóm gop tô bum é u lé, haú nhik gi, \"Nungmoq gi, duì sû lé, shi to bâng chyáng haî mù ho nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesuq gi, shí má a nyì lo; Yhang dui toq lo bê! Yhang gi, nungmoq eq rahá Galile mau má nyi tô ashî hkûn lé, ");
INSERT INTO atbNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","'Haû Byu Yhangzo gi, yubak dap bâng é loq má ap pyâm é hui luî, tapzîng má jén sat to huî é htâng, sum nyí nghû é buinyì má lhoq dui toq yu é hui râ nghut lhê.' ga nungmoq lé taî tô é dang lé myit bun keq.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Haú hkûn, yhangmoq gi, Yesuq é dang lé bûn kat bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Yhangmoq gi, lup mai dum taû lò mù, lagyo raxe rayuq eq gotû lhunglhâng bang lé, haú hkyô banshoq lo taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lagyo pé lé lo taî kyo bang gi, Magadalaq wà mâ é Mariq, Yoanaq, Yakuq é yhângnu Mariq eq, yhangmoq eq rahá nyi é myiwe góbang le nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lagyô pé kúm gi, yhangmoq é dang lé dangsôm su ngam pyám kôluî, a jíng byi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nghut kôlhang, Petruq gi, toq luî lup má din jé ê mù ngóm wú kat le, màng htup é pán leq tô é lé za myàng mù luî, haû su dut é hkyô lé maú é èq, yhûm shut dum taû ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Haû ra-nyí má za, Yesuq é chángzô pé mâ é í yuq gi, Yerusalem wà mó mai nyhit déng kô wê é Ema-u gâ é wà shut e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yhangnhik gi, dut laî ló é hkyô pé banshoq lé, rayuq eq rayuq taî lhûm nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yhangnhik gi, haú hkyô pé lé rayuq eq rayuq taî hpyê lhûm e ló kô le, Yesuq gi, yhangnhik chyáng jé lé lô mù, yhangnhik eq rahá sô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nghut kôlhang, yhangnhik gi, myoq hpuq hpuq pyám byî é hui kômù, Yhang lé a sê wú byuq kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hau hkûn, Yesuq gi, yhangnhik lé, \"Nungnhik hkyô so uchyang taî lhûm lé lo é gi, haí jung wá nghut akô lhú?\" ga myi kat jáng, yhangnhik gi, myoqdong shûm kut luî, hkyîng yap tô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yhangnhik mâ é Hklupa gâ é sû gi, \"Nàng gi, Yerusalem wà mó má lé bíng nyî luî nhîng, shí gyoro lé haû wà má dut lo é hkyô pé lé, a sê é bíng gi, Nàng baú za wá nghut lhê lhú?\" ga myi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yhang gi, \"Haî jung lhú?\" ga dum myî é hkûn lé, yhangnhik gi, \"Nazaret wà byù Yesuq é hkyô nghut lhê; haú yuq gi, Garai Gasâng é hí má le, byù lhunglhâng bâng é hí má le, nhut shô hpaqchyî a-tsam eq hkyî loq a-tsam má wum-o bo é sû myiqhtoi nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nghut kôlhang, hkyangjong agyi pé eq ngamoq é zau suwún wui èq haú yuq lé sat pyám râ matú ap byî pyám kômù, yhangmoq gi, Yhang lé tapzîng má jén sat pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngamoq kúm gi, haú yuq lé, Israelaq byù myû lé hkyi yù râ sû nghut lhê nghû luî, myit myoqbyu nyi bum lhê. Nghut kôlhang, haû su dut laî ló é gi, hkû-nyí sum nyí lháng bò bê. ");
INSERT INTO atbNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hau htoq agó, hkû-nap noq le, lup má ê wú é, ngamoq hpúng mâ é myiwe wuì ra-am gi, ngamoq lé, lo lhoq maú akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yhangmoq gi, Yesuq é gungsôm lé a myàng jáng dum taû lò mù, 'Haû Yhumsîng dui nyi ri.' ga luî, taî kyô é maumang lagyo htoq shit é shing-rán lé, myang é hkyô lé lo taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Haû mù, ngamoq é luzúm wuî ra-am gi, lup má ê wú kô le, myiwe wuì taî é eq rajung za, dut to láng é lé ê myàng akô. Nghut kôlhang, haú yuq lé gi, yhangmoq a myàng kó gâ.\" ga luî, Yhang lé taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Haú hkûn, Yhang gi, \"Myiqhtoî pé taî é dang banshoq lé lumjíng râ matú, hpaqchyî a bo é eq ngha é sû nhik ê, ");
INSERT INTO atbNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hkrisduq gi, haû su é wuîhke jamjau hkâm zô yu é htâng má sheq, Yhâng é hpungwup shingkang má wó wang nyi to râ, a nghut kó lhú?\" ga luî, yhangnhik lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yhang gi, yhangnhik lé, Mosheq kâ tô é eq myiqhtoî pé banshoq bang kâ tô é Chyúmdang pé mai, Yhang má âng é dang banshoq é lichyúm lé, taî hpông kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ahkuî, yhangmoq, haú nhik e ló é wà má chyâng lò kôjáng, Yesuq gi, laî ló râ su kut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Haú hkûn, yhangnhik gi, \"Nga-nhik eq rahá wang bíng sháng; hkâsu mù gâ le, buigyùm bê mù, mau le chut lô bê nghut ri.\" ga luî, Yhang lé wum kat chôm lung nyi akô. Haû mù luî, Yesuq gi, yhangnhik eq rahá wang bíng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yesuq gi, zang zo râ ga, yhangnhik eq rahá zung tô é hkûn, muk lé yù luî, jeju hkya-on mù, myhik hpé luî, yhangnhik lé gàm byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Haú hkûn, yhangnhik é myoq bóng lô luî, Yesuq nghut é lé bûn sé kat bekô. Yesuq kúm gi, yhangnhik chyáng mai byuq byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Haû mù, yhangnhik gi, \"Yhang gi, hkyô má ngá-nhik eq dang nyo lhûm é eq Chyúmdang é lichyúm taî hpóng shit é hkûn, ngá-nhik gi, i-myit unghkaû má, achyí aku dut bê a nghut lhú?\" ga luî, yhangnhik yhangchang taî lhûm akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yhangnhik gi, toq mù, radá dâm Yerusalem wà mó shut dum taû ló kô le, lagyo raxe rayuq eq, yhangmoq eq rahá nyi é bang zup míng to kô é lé ló myang akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Haú bang gi, \"Haû Yhumsîng gi, teng za yhang dum dui toq ló bê; Simun lé lháng htoq shit bê nghut ri.\" ga taî lhûm nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Haú hkûn, yhangnhik gi, hkyô má dut laî ló é hkyô pé eq, muk hpê é hkûn má Yesuq lé bûn sé kat é hkyô lé, taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yhangmoq haú hkyô lé chôm taî nyi tô bum ashî le, Yesuq gi, Yhang gûng yhang, yhangmoq é agùng má yap to luî, \"Nungmoq nguingón yuqyo nyì sháng gaq.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yhangmoq kúm gi, gyuq dan byuq bùm kômù, sobyô lé myàng bê ga myit yu pyâm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Haû mù luî, Yhang gi, \"Nungmoq gi, haî mù dan nyi bum akô lhú? Haî mù nungmoq é i-myit unghkaû má úng-âng nyi bum akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngá é loq eq Ngá é hkyî lé wú wú keq. Ngò yhang nghut nyi lhê. Ngo lé sop wú keq. Sobyô nghû é gi, ngo lé nungmoq myang é su, sho eq showui showang bo é a nghut.\" ga luî, yhangmoq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yhang gi, haû su ga taí mù, Yhâng é hkyî loq lé tûn shit ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yhangmoq gi, gabú é eq maú nyi bùm kômù, a wó jíng shi dut tô é hkûn lé, Yesuq gi, \"Nungmoq shí má zôhpo rajung jung wó akô lhú?\" ga luî, yhangmoq lé myi kat ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Haú hkûn, yhangmoq gi, nyhîn nyhoq tô é ngozo rahtung lé, byî akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yhang gi, haû lé yù mù, yhangmoq é hí má zô shit ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hau htâng, Yhang, yhangmoq lé taî é gi, \"Mosheq é tarâ eq, myiqhtoi laiká pé má le, Hkya-on Kungtôn Laiká pé má le, Ngò èq séng luî kâ to má kâ to banshoq gi, dik râ chyat nghut lhê nghû luî, nungmoq eq rahá nyi to ashî hkûn lé, Ngò, nungmoq lé taî kyô tô é pé gi, shî nghut bê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hau htâng, Yhang gi, Chyúmdang pé lé sê gyo shoq ga, yhangmoq é i-myit hkum hpóng byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Haû mù, Yhang gi, \"Hkrisduq gi, wuîhke jamjau hui zo mù, sum nyí nghû râ buinyì má, shi é mai dum dui toq lô râ hkyô lé le, ");
INSERT INTO atbNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yerusalem wà mó mai hî luî, byù myû chângjup lé, Yhâng é myìng lé lang luî yubak mara hkyut pyám byi râ hkyô eq myit lhîng râ hkyô lé le, hko kyo râ hkyô lé, kâ to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nungmoq gi, shí pê é saksé pé nghut nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngá Wa byî tô é danggidiq lé, Ngò, nungmoq é ahtoq má nhang kat râ nghut lhê; nungmoq kúm gi, htoq tsáng myhâng mâ é wum-o a-tsam wó yu é buinyì jé shoq, Yerusalem wà mó má láng nyî keq.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hau htâng, Yhang gi, yhangmoq lé Behtani wà yàm shut shuî htoq ê mù, Yhâng é loq tu toq luî, shimân byî ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Haû su kut shimân byî nyi ashî le, Yhang gi, yhangmoq chyáng mai gâng ló byuq luî, mauhkûng shut shuî toq yu é hui bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yhangmoq kúm gi, Yhang lé noqkuq kômù luî, gyai gabú é myit èq Yerusalem wà mó shut dum taû ló akô. ");
INSERT INTO atbNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yhangmoq gi, noqkuq yhûm má nyi to mù, Garai Gasang lé hkya-on kungton nyi bum akô nghut ri.");
INSERT INTO atbNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A-nham sâng-hi má, Mungdang joq ri; Mungdang haû gi, Garai Gasang eq rahá nghut luî, haû Mungdang yhang Garai Gasang nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yhang gi, a-nham sâng-hi má, Garai Gasang eq rahá nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nyì mi-nyì, joq mijoq gi, Yhang dông mai hpan tô é chyat nghut lhê; Yhang dông mai a hpan é gi, haî lháng a joq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Asak chyungxe gi, Yhang má nghut lhê mù, asak haû gi, byu pê é matú maubó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Haû maubó gi, mauchut má duqbó byî nyì kôlhang, mauchut gi, haû lé a hap yù nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Garai Gasang mai nhang kat é, Yohan gâ é byù rayuq jé lé ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yhang gi, maubó haû eq sêng é hkyô lé, saksé hkám byi luî, yhang é yanmai byù lhunglhâng bang wó lumjíng kó sháng gaq ga, saksé rayuq dông jé lé é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yhang gi, haû maubó a nghut; maubó haû lé saksé hkám byi râ matú za sheq jé lé é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Byù yuq jup lé duqbó byi é, maubó akying haû gi, mingkan htoq má jé nyi to bê. ");
INSERT INTO atbNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yhang gi, mingkan htoq má nyi to bê nghut ri; mingkan lé gi, Yhang dông mai hpan tô é nghut kôlhang, mingkan haû gi, Yhang lé a wú sé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yhang gi, yhumsîng mau má jé lé kôlhang, Yhâng é amyû pé gi, Yhang lé a lhom hap yù kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nghut kôlhang, Yhang gi, Yhang lé lhom hap yù luî, Yhâng é myìng lé lumjíng é bang lhunglháng lé, Garai Gasâng é yhangzô pé dut râ ahkáng byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Haú bang gi, sui sho dông hku kat é le a nghut, byù ô nau é dông hku kat é le a nghut, gungsho ô nau é dông hku kat é le a nghut e za, Garai Gasang chyáng mai hku kat é bang ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Haû Mungdang gi, xângzo byù gùng lé dut luî, ngamoq chyáng nyi wú bê nghut lhê. Ngamoq gi, haû jeju eq tengmán hkyô byíng tô é, Yhang é hpungwup shingkang lé myang wú bê nghut lhê; haû gi, haû Îwâ é zote rayuq dông, Yhang wó yu é hpungwup shingkang nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wui-myhup Sará Yohan gi, Yhang eq sêng é hkyô lé saksé hkâm é hkûn, garû taî é gi, \"'Ngá é htâng má jé lé é Sû gi, ngá é hí mai nyi to bê sû nghut é yanmai, ngá htoq je gyaú sû nghut ri.' nghû, ngò taî é sû gi, shí yuq nghut bê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yhâng é gumjup é jeju ahkaû mai, nga-nhúng banshoq bang gi, shimân jeju lé ralhûm htoq ralhum myang yu nyì bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hkâsu mù gâ lé, haû jep é tarâ gi, Mosheq é loq dông mai byî é nghut lhê; jeju eq tengmán hkyô kúm gi, Yesuq Hkrisduq é yanmai lé joq é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Garai Gasang lé, ó yuq èq le a myang wú wú é nghut lhê; nghut kôlhang, haû Îwâ é tanghkoí má lúng tô é, Yhang Zo zote gi, Garai Gasâng é gùng lé lhoq htoq shit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yerusalem wà mó mâ é Yudaq byu pé gi, hkyangjông pé eq Lewiq byu pé lé, Yohan ó yuq nghut é hkyô myí nhang kat kô é hkûn, Yohan saksé hkâm é gi, a-ô mâ é hkyô pé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yhang gi, a hê a zaú tô e za, \"Ngò gi, Hkrisduq a nghut.\" ga lhom taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Haú hkûn, yhangmoq gi, \"Haû nghut jáng, nàng gi, ó yuq nghut lhê lhú? Nàng gi, Eliyaq lhú?\" ga myi kôjáng, yhang gi, \"A nghut.\" ga taî ri; \"Nàng gi, haû Myiqhtoi nghut lhê lhú?\" ga dum myi kôjáng, yhang gi, \"A nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Haû mù, yhangmoq gi, \"Ngamoq lé nhang kat bâng chyáng ló wó taî kyo râ matú, nàng gi, ó yuq nghut lhê lhú? Náng gûng lé nàng hkâsu nghû lhê lhú? Taî kyô wú laq.\" ga dum myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Haú hkûn, Yohan gi, myiqhtoi Esai-aq é dang eq rajung za, \"Ngò gi, haû yoso má, 'Yhumsing é matú hkyô lhoq nyhang to keq.' gâ é htê lé, garû taî é sû nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hparishe pé mai nhang kat é bang ra-am gi, yhang lé, ");
INSERT INTO atbNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","\"Nàng gi, haû Hkrisduq le a nghut, Eliyaq le a nghut, Myiqhtoi le a nghut é nhîng, haî mù luî, wui-myhup hkám byi nyi lhê lhú?\" ga dangmyi myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Haú hkûn, Yohan tû taî é gi, \"Ngò gi, wui èq za wui-myhup hkám byi lhê; nghut kôlhang, nungmoq a sê é sû rayuq nungmoq chyáng yap tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yhang gi, ngá htâng má lé é sû yuq nghut bê; ngò gi, Yhâng é hkyî-tsung tui lé hpyî râ lháng a gingdán é nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Shí pé banshoq gi, Yohan wui-myhup hkám byî nyi é, Yodan làng hé hpoq mâ é Behtani wà má dut é hkyô pé chyat nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hau htang nyí, Yohan gi, yhâng chyáng Yesuq lé lo nyi é lé myàng luî, taî é gi, \"Mingkan byu pê é yubak mara lé yu pyám byî é Garai Gasâng é Sauzo lé, wú keq! ");
INSERT INTO atbNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Shí yuq gi, 'Ngá é htâng má jé lé é Sû gi, ngá é hí má nyì bê sû nghut é yanmai, ngá htoq je gyaú Sû nghut ri.' nghû, ngò taî é sû yhang nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngò gi, Yhang ó yuq nghut é lé a sê é nghut lhê, nghut kôlhang, Yhang lé, Israelaq byu pé wó sé kó sháng gaq nghû, ngò lé jé mù, wui èq wui-myhup hkám byî nyi é nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hau htâng, Yohan saksé hkâm é gi, \"Haû Woi-nyí gi, mauhkûng mai hpûngkyui gunghkyâng sû é dông mai gyó lé mù, Yhâng chyáng lé nô tô é lé, ngò myàng ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ngò gi, Yhang ó yuq nghut é lé a sê é nghut kôlhang, wui èq wui-myhup hkám byi râ matú, ngo lé nhang kat é Sû, ngo lé taî kyô é gi, 'Haû Woi-nyí gyó lé lô mù, ó yuq chyáng lé nô tô é lé, nàng myàng jáng, haú yuq gi, haû Chyoiyúng Woi-nyí má wui-myhup hkám byi râ sû nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Haû eq rajung za ngò myàng bê nghut luî, shí yuq gi, Garai Gasâng é Yhangzo nghut lhê nghû, ngò saksé hkâm lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hau htang nyí, Yohan gi, yhâng é chángzo í yuq eq rahá, haú má dum nyi tô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Haú hkûn, yhang gi, Yesuq laî ló nyi é lé myang kat jáng, \"Hê, Garai Gasâng é sauzo lé, wú keq!\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chángzo haû í yuq gi, yhang haû su gâ é lé wó gyo kôjáng, Yesuq é htâng cháng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuq gi, lhing wú kat le, yhangnhik châng tô é lé myàng luî, \"Nungnhik haî o akô lhú?\" ga myi jáng, yhangnhik gi, \"Rabai ê, Nàng hkâmá nyi lhê lhú?\" ga taû myî kat akô nghut ri. (Rabai gâ é gi, Sará gâ é lichyúm nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Haú hkûn, Yhang gi, \"Lé keq, haû jáng, nungnhik myàng kó râ nghut lhê.\" ga tû taî ri. (Haú-u gi, raxê hkyíng kô nghut ri.) Haû mù luî, yhangnhik gi, châng ê mù, Yhang hkâmá nyi é lé, ê myàng kôluî, haú nyí buigyùm shoq, Yhang eq rahá ê nyi nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohan taî é dang lé wó gyo luî, Yesuq htâng châng é su nhik mâ é rayuq gi, Simun Petruq é yhanggu Andre nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andre gi, yhangmang Simun lé hí myàng luî, \"Nga-nhik gi, Mesaia lé myàng bê.\" ga yhang lé taî kyô ri. (Mesaia gâ é lichyúm gi, Hkrisduq gâ é nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hau htâng, yhang gi, yhangmang lé Yesuq chyáng shuî e ri. Yesuq gi, Simun lé lhom myàng jáng, \"Nàng gi, Yohan é yhangzo Simun nghut ri; Kehpa gâ é myìng lé, nàng wó yû râ nghut lhê.\" ga taî ri. (Kehpa gâ é lichyúm gi, Petruq gâ é nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hau htang nyí, Yesuq gi, Galile mau shut ê râ matú, myit hpyit yû bê nghut ri. Yhang gi, Hpilip lé myàng jáng, \"Ngá htâng cháng aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hpilip gi, Andre eq Petruq nhik nyi é Bet-saida wà mó mâ é byù nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yhang gi, Nahtanelaq lé myàng jáng, \"Mosheq mai tarâ laiká má kâ tô é eq myiqhtoî pé mai le lhoq ang luî kâ tô é sû, Yosep é yhangzo, Nazaret wà byù Yesuq lé, ngamoq myàng bê.\" ga yhang lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Haú hkûn, Nahtanelaq gi, \"Nazaret wà ô! Haû mai, ge é jung haî wa wó htoq lhê lhú?\" ga myi jáng, Hpilip gi, \"Ru lé wú aq.\" ga yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesuq gi, Yhâng chyáng Nahtanelaq lé lo nyi é lé myàng jáng, yhang lé lhoq ang luî, \"Wú keq, shí yuq gi, mhaû é myit a bo é sû, Israelaq byù akying rayuq nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Haú hkûn, Nahtanelaq gi, \"Nàng, ngo lé hkâsu kut sê é lhú?\" ga myi jáng, Yesuq gi, \"Nang lé, Hpilip èq a wut yù shimá, nàng, maihpáng gâm ô má ru nyi tô ashî hkûn, Ngò, nang lé myàng bê nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Haû mù, Nahtanelaq gi, \"Rabai ê, Nàng gi, Garai Gasâng é Yhangzo nghut ri; Nàng gi, Israelaq byu pê é Hkohkâm le nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Haú hkûn, Yesuq gi, \"Ngò, nang lé, maihpáng gâm ô má myang é nghû taî kyô é yanmai, nàng lumjíng lhê a nghut lhú? Hau htoq je kô é muzó pé lé, nàng myàng râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hau htâng, Yesuq xoq taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, mauhkûng bóng lô luî, haû Byu Yhangzô ahtoq má, Garai Gasâng é maumang lagyô pé doq ló gyó lô kut nyî kô é lé, nungmoq myàng kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hau htâng, í nyí nghû râ nyí má, Galile mau mâ é Hkanaq wà mó má, myiháng poî ralhum joq ri. Haû má Yesuq é yhângnu le, bo lom ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuq eq Yhâng é chángzô pé lé le, myiháng poî haû má ji akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tsibyiq wing jaú tûm to kô é hkûn, Yesuq é yhângnu gi, \"Yhangmoq, tsibyiq wing a wó lo kó nghut ri.\" ga, Yesuq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Haú hkûn, Yesuq gi, \"Ânu ê, haû, nàng gi, Ngò eq haî sêng lhê lhú? Ngá é ahkyíng a jé shi é nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nghut kôlhang, Yhâng nu gi, haû dui-nhâng zoshâng wuì lé, \"Yhang haî taî le, haî kut keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Haû nàm má, í sum xê galan kô wang é luqgok wúng hkyuq cham joq tô ri; haû gi, Yudaq byu pé mai, lhoq san lhoq yúng hkîng é matú, chung é jung wúng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuq gi, haû dui-nhâng zoshâng wuì lé, \"Wúng haú pé má wuì lhoq pyíng keq.\" ga taî ri; haû mù, yhangmoq gi, wúng haú pé má byíng shoq shoq lhoq pyíng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hau htâng, Yhang gi, yhangmoq lé, \"Ahkuî, ratsuí hkû yù mù, poî-up lé yu ló byi keq.\" ga taí jáng, yhangmoq gi, yu ló byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Poî-up hpó gi, wuì mai dut é tsibyiq wing haû lé, shuq chyam wú ri; wuì hkam é dui-nhâng zoshâng wuì gi, tsibyiq wing haû hkâmai lo é hkyô lé sê to kôlhang, yhang gi, a sé nghut ri. Haû mù, yhang gi, lusik lé, ji yù luî, ");
INSERT INTO atbNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","\"Yuq hkangmó gi, tsibyiq wing mún lé hí jaú mù, bíng pé shuq gyî bùm jáng sheq, tsibyiq wing apyâng lé ru yu htoq lhê; nghut kôlhang, nàng gi, nghâm é tsibyiq wing lé, ahkuî jé shoq wó hkong tô ri-nhung!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galile mau mâ é Hkanaq wà mó má, Yesuq tûn shit é limik kumlhá gi, Yhang kut é limik kumlhá pé mâ é sâng-hî dàm nghut ri. Yhang gi, Yhâng é hpungwup shingkang lé, haú dông lhoq htoq shit é nghut mù luî, Yhâng é chángzô pé gi, Yhang lé lumjíng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hau htâng má, Yesuq gi, Yhâng nu, Yhâng gu yuqzo pé eq Yhâng é chángzô pé le mù, Kaperna-um wà má gyó ló ri; yhangmoq gi, haú má buinyì myi ngò nyí nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yudaq byu pê é Lhoqlhai Poî jé râ nghut é hkûn, Yesuq gi, Yerusalem wà mó má doq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Haú hkûn, noqkuq yhûm wàng má, nojûng, sau, hpûngkyui pé lé ûng nyi é bang lé le, siboî má ngùn htaí zô zung nyi é bang lé le, Yhang ló myàng ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Haû mù, Yhang gi, tui lé, nhuq râ wase saî yù mù, banshoq bang lé le, sau eq nojûng lé le, haû noqkuq yhûm wàng mai hkat htoq luî, ngùn htaí zo bâng é ngùn htingchap lé gi, tû hut pyám byi mù, yhangmoq é siboî lé gi, tu mhuq pyám byî ri; ");
INSERT INTO atbNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","haû hpûngkyui ung zô é bang lé le, \"Zè shi pé lé yu htoq ló keq! Ngá Wâ é yhûm lé, hpugá jowò hkâkut kó!\" ga luî nhik-yô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Haû mù, Yhâng é chángzô pé gi, \"Ngò, Náng é yhûm lé chyitdap kâng tuî é hkyô gi, Ngo lé myi su nyhê jôm pyám râ nghut lhê.\" ga kâ tô é lé, myit bûn kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yudaq byu pé gi, Yhang lé, \"Nàng, shí pé kut râ ahko ahkáng wó é hkyô lé saksé tûn shit râ matú, ngamoq lé, haí jung limik kumlhá wó tûn shit râ lhú?\" ga chôm myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Haú hkûn, Yesuq gi, \"Noqkuq yhûm shî lé nungmoq hpyoq pyám keq, sum nyí gyoro má, Ngò, haû lé dum tu shap râ nghut lhê.\" ga, yhangmoq lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Haû Yudaq byu pé gi, \"Noqkuq yhûm shî lé, myi xe hkyuq zân tup saî é ru nghut lhê; sum nyí gyoro má za, Nàng wó tu shap râ lhú?\" ga tu myî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nghut kôlhang, Yesuq taî é noqkuq yhûm gi, Yhâng é gùng lé lhoq ang luî taî é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Haû mù, Yhang, shi é mai lhoq dui toq huî é hkûn sheq, Yhâng é chángzô pé gi, Yhang haû su ga taî é dang lé myit bun kômù, Chyúmdang lé le, Yesuq taî é dang pé lé le, lumjíng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Haû Lhoqlhai Poî nghut é u lé, Yerusalem wà mó má Yesuq nyi nyi é hkûn, byù myo myo gi, Yhang kut shit é limik kumlhá pé lé myàng kômù, Yhang lé lumjíng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nghut kôlhang, Yesuq gi, byù lhunglhâng bâng é myit lé sê é yanmai, yhangmoq chyáng, Yhânggùng lé a ap to nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yhang gi, byu é i-myit unghkaû má haî lúng tô é lé sê é yanmai, byù yhangchang saksé hkám byî é a ra nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nikodimu gâ é Hparishe rayuq nyi ri; yhang gi, Yudaq byu pê é byìn tú wapdoq má bo é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yhang gi, myín lé, Yesuq chyáng lé mù, \"Rabai ê, Nàng gi, Garai Gasâng chyáng mai lé é sará rayuq nghut é lé, ngamoq sê lhê. Hkâsu mù gâ le, Nàng kut shit é limik kumlhá pé gi, Garai Gasang a lom é nghut jáng, ó yuq le wó kut râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Haú hkûn, Yesuq gi, yhang lé, \"Ngò, nàng lé teng za taî kyo lé, ó yuq nghut kôle, dum hku é hui sû za a nghut le gi, Garai Gasâng é mingdán lé wó myâng râ a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Haû jáng, Nikodimu gi, \"Ipyat kó bê é byù gi, dum hkû é hkâsu kut wó hui râ lhú? Înû é unghkaû má dum wàng mù, dum hku é hui râ gi, gè gè yhang wó dut râ a nghut!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Haú hkûn, Yesuq gi, \"Ngò, nàng lé teng za taî kyo lé, ó yuq nghut kôle, wuì eq Woi-nyí mai hku kat é hui sû za a nghut le gi, Garai Gasâng é mingdán má wó wâng râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Gungsho mai hku kat é gi, gungsho nghut ri; Woi-nyí mai hku kat é kúm gi, woi-nyí nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Nungmoq gi, dum hku é hui râ lhê' nghû Ngò taî é dang lé, nàng hkâmaú nyî. ");
INSERT INTO atbNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Haû, laì gi, yhang nau é shut ló lhê. Laì lò htê lé nàng wó gyo kôlhang, laì hkâmai lo é eq, hká shut ló é lé, nàng sé râ a nghut; haû Woi-nyí mai hku kat huî é sû, ó yuq nghut kôle, haû eq rajung za nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Haú hkûn, Nikodimu gi, \"Haû gi, hkâsu wó dut râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuq tû taî é gi, \"Nàng gi, Israelaq byu pê é sará rayuq nghut to luî nhîng, haú hkyô pé lé a sê gyo lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngò, nang lé teng za taî kyo lé, ngamoq gi, ngamoq sê é hkyô lé taí mù, ngamoq myang wú bê lé saksé hkâm lhê; nghut kôlhang, nungmoq gi, ngamoq é saksé lé a hap yù kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngò gi, nungmoq lé, mingkan eq sêng é hkyô lé taî kyô le lháng, a lumjíng kô é nghut le gi, mauhkûng mingdán eq sêng é hkyô lé taî kyô é nghut le gi, hkâsu kut wó lumjíng kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mauhkûng mingdán mai gyó lo é sû, haû Byu Yhangzo mai lai luî, mauhkûng mingdán má ó yuq lháng wó doq ló wú é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosheq gi, yoso má lhangmuì lé tu shap tô é su, haû Byu Yhangzo le tu shap tô é hui ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Haû mù, haû Byu Yhangzo lé lumjíng é yuq hkangmó gi, ahtum abyuq é asak wó yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Hkâsu mù gâ le, Garai Gasang gi, mingkan lé gyai yhang chyitdap é yanmai, Yhang Zo lé lumjíng é sû ó yuq nghut kôle, htên byoq é a huî e za, ahtum abyuq é asak wó yû sháng gaq ga, rayuq za é Yhâng é Zote lé byî pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hkâsu mù gâ le, Garai Gasang gi, mingkan lé mara byi râ matú, Yhang Zo lé mingkan htoq má nhang kat é a nghut é za, Yhang é yanmai mingkan hkyi yu é hui râ matú sheq nhang kat é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yhang lé lumjíng é sû gi, mara byî é hui râ a nghut; nghut kôlhang, Yhang lé a lumjíng é sû kúm gi, Garai Gasâng é Yhangzo zote lé a lumjíng é sû nghut é yanmai, mara byî é huî to gù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Maubó gi, mingkan htoq má lé jé to bê; nghut kôlhang, byu pé kut é hkyô gi, agè ashop hkyô nghut é yanmai, yhangmoq gi, maubó lé chyit râ malaî, mauchut lé chyit akô nghut ri; haû gi, mara byî é hui râ hkyô yhang nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Agè ashop hkyô kut é sû ó yuq nghut kôle, maubó lé a nguì nghut ri; haú yuq gi, yhang kut é hkyô lhoq byông htoq kat râ lé gyuq é yanmai, haû maubó shut lé lô râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nghut kôlhang, haû tengmán hkyô dông asak dui é sû ó yuq le, yhumsîng kut é hkyô gi, Garai Gasang lom é hkyô lé, san za byu-myàng sháng gaq ga, haû maubó shut lé lo ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hau htâng má, Yesuq gi, Yhâng é chángzô pé eq rahá, Yuda mau shut wang ló mù, haú má rayoq zo nyì luî, wui-myhup hkâm byî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Haú u lé, Yohan gi, Salim nàm mâ é E-nun gâ é jowò má, wuì gyai myo joq é yanmai, wui-myhup hkám byî nyi ri; byu pé gi, abyit alan lé lò kômù, wui-myhup lé hkâm yu nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Haû gi, Yohan lé htóng a lhoq hkyó shî é hkun lhê é hkyô nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Haú hkûn, Yohan é chángzô pé ra-am eq Yudaq byù rayuq gi, lhoq san lhoq yúng hking eq séng luî, dang htíng htîng lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hau htâng, yhangmoq gi, Yohan chyáng lé luî, \"Rabai ê, Yodan làng hé hpoq shut nàng eq rahá nyì luî, nàng èq saksé hkám byî é Sû gi, ahkuî, wui-myhup hkám byî nyi é nghut mù, yuq hkangmó gi, Yhâng chyáng e bum akô nghut ri mhaî.\" ga, yhang lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Haû eq séng luî, Yohan tû taî é gi, \"Byù rayuq gi, mauhkûng mai byî é za a nghut jáng, haî le wó hap yù râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Ngò gi, Hkrisduq a nghut, Yhang é hí má nhang kat huî é sû za nghut lhê.' nghû, ngò taî é lé, nungmoq yhang saksé nghut bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Myisik wó é sû gi, lusik nghut ri. Lusik lé, láng yap tô é luzúm hpó gi, lusik é htê lé wó gyô é yanmai, gyai yhang gabú nyi ri. Haû sû é gabú hkyô gi, ngá é gabú hkyô nghut mù, ngò má byíng jup nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yhang gi, kô jat lò ra râ nghut lhê; ngò gi, yom ló ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ahtoq mai lé é Sû gi, lhunglhâng é ahtoq má nghut ri; myigùng htoq mâ é sû kúm gi, myigùng htoq eq sêng é nghut luî, myigùng htoq eq sêng é dông za taî ri; mauhkûng mai lé é Sû gi, lhunglháng é ahtoq má nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yhang gi, wó myâng wó gyô é hkyô lé, saksé hkám kôlhang, Yhang hkâm é saksé lé, ó yuq le a hap yù kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yhâng é saksé lé hap yu é sû kúm gi, haû Garai Gasang gi, tengmán sû nghut ri ga, saksé shit é sû nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Garai Gasâng èq nhang kat é hui Sû gi, Garai Gasâng é mungdang lé taî ri; hkâsu mù gâ le, Garai Gasang gi, haû Woi-nyí lé, laké a kat e za byî é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Haû Îwa gi, Zo lé chyitdap luî, jung hkangmó lé Yhâng é loq má ap byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Haû Zo lé lumjíng é sû ó yuq nghut kôle, ahtum abyuq é asak wó lhê; nghut kôlhang, haû Zo lé he-ngik pyâm é sû ó yuq nghut kôle, asak haû lé myàng râ a nghut; hkâsu mù gâ le, Garai Gasâng é nhikmo-yo hkyô gi, yhâng chyáng ru joq nyi ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuq gi, Yohan htoq má, chángzo je lhoq myô é eq wui-myhup hkám byî nyi ri gâ é hkyô lé, haû Hparishe pé wó gyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Nghut kôlhang, gè gè ga jáng, Yesuq gi, Yhang wui-myhup hkám byî é a nghut, Yhâng é chángzô pé sheq ru nghut akô.) ");
INSERT INTO atbNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Haú hkyô lé, Yesuq sé jáng, Yhang gi, Yuda mau mai htoq mù, Galile mau shut dum taû ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ahkuî, Yesuq gi, Samariq mau mai sô laî ló râ dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Haû mù, Yhang gi, Yakup mai yhang zo Yosep lé byî é maumyî rajap eq chyâng lhûm é, Suhka ga myhîng é, Samariq mau mâ é wà mó ralhum má lo jé ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Haû má, Yakup é wuìhtung le joq to luî, Yesuq gi, hkyô sô ngú é yanmai, wuìhtung hau é nàm má zung gyó tô ri. Haú u gi, nyí-káng raxe í hkyíng nghut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Haú hkûn, Samariq myiwe myhí rayuq wuì lé hkam ri; Yesuq gi, yhang lé, \"Ngo lé wuì byi shuq laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Haú u gi, Yhâng é chángzô pé, zoshuq wuì râ matú wà hkaû shut e byuq kô é ahkyíng nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Haû Samariq myiwe myhí gi, Yhang lé, \"Nàng gi, Yudaq byù rayuq nghut to luî nhîng, ngò Samariq myiwe myhî chyáng, haî mù shuq wuî dûng lhê lhú?\" ga taî ri. (Hkâsu mù gâ le, Yudaq byu pé gi, Samariq byu pé eq a zùm yap kó nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Haú hkûn, Yesuq gi, yhang lé, \"Nàng gi, haû Garai Gasâng é chyunghuq lé le, nang lé wuì dung sû ó yuq nghut é lé le, sê é nghut le gi, noq mai Yhang lé dûng tôngbán luî, Yhang gi, nang lé asak-wuì byi berâ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Myiwe myhí haû gi, \"Yhumsîng ê, Nàng gi, wuì hkâm râ zè haî le a wó, wuìhtung le nik ri; haû asak-wuì lé, Nàng hkâmâ é wó yû râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ngamoq é îwa Yakup gi, ngamoq lé wuìhtung shî byî to bê nghut lhê; yhang yhang le, yhang zo pé le, yhang rém é dusak pé le, wuìhtung shî mâ é wuì shuq bekô nghut ri; Nàng gi, Yakup htoq je kô lhê lhú?\" ga Yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuq gi, \"Wuì shî lé shuq é sû ó yuq le, wuìshit é dum hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nghut kôlhang, Ngò byî é wuì lé shuq é sû ó yuq nghut kôle, wuìshit é hkâ-nhám a hui lo râ nghut lhê. Ngò byî é wuì haû gi, haú yuq má, ahtum abyuq é asak matú wuìbúm dut râ nghut lhê.\" ga yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Myiwe myhí haû gi, Yhang lé, \"Yhumsîng ê, ngò gi, wuì le a shit lo, shî má wuì hkâm le a lé ra lo sháng gaq, wuì haû ngo lé byi laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Haú hkûn, Yesuq gi, \"Ló mù, nung làng lé ló wut lò aq.\" ga, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yhang gi, \"Ngò, làng a wó.\" ga taí jáng, Yesuq gi, yhang lé, \"Nàng, làng a wó gâ é gi, têng ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hkâsu mù gâ le, nàng gi, yuqgè ngo yuq wó wú bê sû nghut ri; nàng, ahkuî wó tô é yuqgè le nung lâng a nghut. Nàng gi, têng é dang taí bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Haú hkûn, myiwe myhí haû gi, \"Yhumsîng ê, Nàng gi, myiqhtoi rayuq nghut é hkyô lé, ngò wú sé bê. ");
INSERT INTO atbNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ngamoq é îchyí îwâ pé gi, bùm shî má noqkuq kô é nghut lhê; nghut kôlhang, nungmoq Yudaq byu pé gi, Yerusalem wà mó za noqkuq jowò nghut lhê ga taî akô nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Haú hkûn, Yesuq taî é gi, \"Myiwe myhí ê, Ngo lé jíng aq; bùm shî má le a nghut, Yerusalem wà mó má le a nghut e za, haû Îwa lé noqkuq râ ahkyíng, jé lò nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nungmoq Samariq byu pé gi, yhumsîng lháng a sê é lé, noqkuq akô; ngamoq kúm gi, ngamoq sê é lé noqkuq lhê; hkâsu mù gâ le, hkyi yù hkyô gi, Yudaq amyû mai lo é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nghut kôlhang, haû têng é dông noqkuq é bang gi, woi-nyí mai le, tengmán hkyô mai le, haû Îwa lé noqkuq râ ahkyíng gi, jé lo nyì bê nghut luî, ahkuî lháng jé to bê nghut ri; hkâsu mù gâ le, haû Îwa gi, haû su kut noqkuq é bang lé ô nau ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Garai Gasang gi, woi-nyí nghut lhê; haû mù, Yhang lé noqkuq é bang gi, woi-nyí mai le, tengmán hkyô mai le, noqkuq ra râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Myiwe myhí haû gi, \"Hkrisduq gâ é Mesaia jé lé râ nghut é lé gi, ngò sê lhê. Yhang jé lé jáng, nga-nhúng lé banshoq taî sân kyo râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hau htâng, Yesuq gi, \"Nàng eq dang nyo nyi é sû ngò gi, haú yuq nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Haú u lé, Yhâng é chángzô pé gi, dum taû jé lo bum akô; yhangmoq gi, Yesuq, myiwe rayuq eq dáng nyo nyi é lé lo myàng luî, maú byuq bum akô. Nghut kôlhang, \"Nàng, haî ô ri lhú?\" ga le, \"Haî mù Yhang eq dáng nyo nyi lhê lhú?\" ga le, Yhang lé ó yuq a myi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hau htâng, myiwe myhí haû gi, yhâng é wuì yambú lé tô pyâm to luî, wà shut taû wang ló mù, wà byù wuì lé ló taî kyô é gi, ");
INSERT INTO atbNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","\"Ngò kut laî lò bê hkyô pé lhunglháng lé, taî kyô é byù rayuq lé, lé wú keq! Yhang gi, Hkrisduq nghut lhê abe?\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Haû mù, yhangmoq gi, wà mai htoq lé luî, Yesuq chyáng lé lo bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Haú u lé, Yhâng é chángzô pé gi, Yhang lé, \"Rabai ê, zoshuq zo aq.\" ga chôm taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Haú hkûn, Yhang gi, yhangmoq lé, \"Nungmoq a sê é jung zoshuq zo râ Ngò wó lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Haû mù, Yhâng é chángzô pé gi, \"Yhang lé, rayuq yuq èq zoshuq lé dé byî é abe?\" ga, rayuq eq rayuq taî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Haú hkûn, Yesuq taî é gi, \"Ngo lé nhang kat Sû ô nau é hkyô lé kut râ eq Yhâng é muzó jizó lé lhoq pán râ hkyô gi, Ngá é zoshuq nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Kyôshu yoq jé râ gi, lhamó myi hkyap râ ashî.' ga, nungmoq lhaq taí lhê a nghut kó lhú? Ngò, nungmoq lé taí kôlé, nungmoq é myoq hpóng luî, haû yò pé má wú kat wú keq! Kyôshi gi, myhíng luî, kyô shu yoq gi, jé to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Haû kyô hkyó sû eq kyô shu sû gi, rahá wó gabú kó sháng gaq ga, ahkuî lháng, haû kyô shu sû gi, yhâng é zuihpau lé myang yù luî, ahtum abyuq é asak é matú, kyôshi shû tsîng to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Haû su mù, 'Rayuq gi, sân hkyó, góyuq gi, shû yù.' gâ é sanghkyang gi, têng ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nungmoq a zui saî tô é jang mâ é shû yù râ matú, nungmoq lé Ngò nhang kat bê nghut lhê. Góbang gi, haú má wum kat zui saî to bê nghut mù, nungmoq gi, haú bang zui saí é akyû lé shu yù bekô nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","\"Yhang gi, ngò kut laî lò bê hkyô lhunglháng lé, taî kyô ri.\" ga luî, myiwe myhí haû saksé hkâm é yanmai, haú wâ mâ é Samariq byù myo myo gi, Yesuq lé lumjíng bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Haû mù, Samariq byu pé gi, Yesuq chyáng lé jé kômù, yhangmoq eq nyì râ matú, Yhang lé lung kô é yanmai, Yhang gi, í nyí bo nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yhâng é dang pê é yanmai, byù myo myo gi, lumjíng bang dut jat lò bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yhangmoq gi, myiwe myhí haû lé, \"Ahkuî, ngamoq lumjíng é gi, nàng taî é dang yanmai za a nghut lo; ngamoq yhang wó gyo bê nghut é htoq agó, shí yuq gi, gè gè yhang, mingkan é hkyi yù Sû nghut é lé, ngamoq sé bê nghut é yanmai nghut lhê.\" ga chôm taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Í nyí lai jáng, Yesuq gi, haû mai Galile mau shut htoq e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","\"Myiqhtoi gi, yhumsing é mau má myoqdong a wó wú é nghut lhê.\" ga, Yesuq yhang saksé hkâm é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuq gi, Galile mau má jé é hkûn, Galile byu pé gi, Yhang lé lhom hkulum yu akô; yhangmoq gi, Yerusalem wà mó má, Lhoqlhai Poî ê lòm kô é nghut é yanmai, poî u lé, Yesuq kut é hkyô lhunglháng lé, myàng kô é bang nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesuq gi, Yhang mai haû wuì lé tsibyiq wing dut nhang é, Galile mau mâ é Hkanaq wà mó má, ê dum kûm ri. Haû ming suwún rayuq é yhangzo yuqzo gi, Kaperna-um wà má no nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesuq gi, Yuda mau mai Galile mau má jé lé bê gâ é hkyô lé, ming suwún haû wó gyo jáng, yhang gi, Yesuq chyáng ê mù, shî-nò no nyi é yhangzo lé, lé lhoq gê byi râ matú, Yhang lé dûng tôngbán ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Haú hkûn, Yesuq gi, yhang lé, \"Byù nungmoq gi, limik kumlhá pé eq mauhpo muzó pé lé za a myàng kô é nghut le gi, hkâ-nhám lé lumjíng kó râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mingsuwún haû gi, \"Yhumsîng ê, ngá zo a shî shimá gyó lé laq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Haú hkûn, Yesuq gi, \"Nàng wó ló bê; nung zo byùn râ nghut lhê.\" ga tû taî ri. Suwún haû gi, Yesuq taî é dang haû lé gyô jíng luî, tau ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yhang gi, hkyô má ru nghut nyi ashî hkûn, yhâng é dui-nhâng zoshâng wuì gi, yhang lé lé hui luî, zoshâng haû gè byuq é hkyô, lé taî kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yhang gi, yhang zo hkâ-nhám gè byuq é ahkyíng lé myi wú é hkûn, yhangmoq gi, \"A-nyí nap nyí hkyuí rahkyíng má, gùng nyé é châm ló byuq bê nghut ri.\" ga taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Haú hkûn, ahkyíng haû gi, \"Nung zo byùn râ nghut lhê.\" ga, yhang lé, Yesuq taî é ahkyíng nghut é lé, haû yhângwa bûn sé bê nghut ri. Haû mù, yhang eq yhâng yhumbyù banshoq bang gi, lumjíng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Haû gi, Yesuq, Yuda mau mai Galile mau má lé jé é htâng, í dâm nghû râ dá kut shit é limik kumlhá nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hau htâng a myáng má, Yudaq byu pê é poî ralhum joq é yanmai, Yesuq gi, Yerusalem wà mó má doq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ahkuî, haû Yerusalem wà mó é Sau Hkúmdong nàm má, Hebre myíng dông gi, Betzahta ga myhîng é wuìhtum ralhum joq ri; hau é lhînghkyuq má, jirop ngo lhum joq tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jirop haú pé má, myoqjit bang, hkyî hten bang, gùngjum shî bang ajùm ayò leq tô bum akô. (Haú bang gi, wuì dui nún râ lé láng tô é bang nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hkâsu mù gâ le, haû Yhumsing é maumang lagyo gyó lé lé kut mù, wuì lé, lé lhu nhún jáng, wuìhtum haú má hí wó wang é sû gi, haí jung ana wa dap to kôlhang, ge byuq é huî é yanmai nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Súm xe shit zân tup no nyi é byù rayuq le, haú má bo tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuq gi, haú yuq no leq tô é lé myàng mù, haû su no nyi é gyai myáng bê nghut é hkyô lé sé jáng, yhang lé, \"Nàng, gè nau ri lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nò sû haú yuq gi, \"Yhumsîng ê, wuì dui nún lo é hkûn, wuìhtum má wàng râ matú, ngo lé garúm râ byù ó a nyì; ngò wàng râ nghû jáng, góyuq hí, ngá hí má wàng wàng dut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hau htâng, Yesuq gi, yhang lé, \"Toq aq! Náng é taphkang yu chûng luî, sô ló aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Haú yuq gi, radá dâm nò ge byuq bê nghut luî, yhâng é taphkang yù mù, sô ló bê nghut ri. Haú nyí gi, Bánno buinyì nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Haû mù, Yudaq byu pé gi, haû nò ge byuq é hui sû lé, \"Hkû-nyí gi, Bánno buinyì nyí nghut é yanmai, nàng, taphkang waq é gi, tarâ lu lai bê nghut ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nghut kôlhang, yhang tû taî é gi, \"Haû ngo lé lhoq gê byi sû gi, ngo lé, 'Náng é taphkang yu chûng mù, sô ló aq.' ga taî é nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Haû mù, yhangmoq gi, \"'Náng é taphkang yu chûng mù sô ló aq.' ga, nang lé taî é sû gi, ó yuq wá nghut ri lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nghut kôlhang, haû ó yuq nghut é lé, nò ge byuq é hui sû gi, a châng sê kat nghut ri; hkâsu mù gâ le, Yesuq gi, haú mâ é byù moq mó má wang nyó ló byuq é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Htâng má, Yesuq gi, haú yuq lé noqkuq yhûm má myàng jáng, \"Wú aq, nàng wángzán bê nghut ri; hí lhê htoq má je wuîhke é hkyô a hui zo sháng gaq, mara hkâkut shut lo.\" ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Haú yuq gi, htoq ló mù, yhang lé lhoq gê byî é sû gi, Yesuq nghut ri ga, Yudaq byu pé lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Haû mù, Yudaq byu pé gi, Bánno buinyì nyí má, Yesuq, haú hkyô kut é yanmai, Yhang lé gunjang lo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Haú hkûn, Yesuq gi, yhangmoq lé, \"Ngá Wa gi, hkû-nyí jé shoq, hkâ-nhám le mû zuî nyi é nghut mù, Ngò le mû zuî nyi lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Haû mù luî, Yesuq gi, Bánno buinyì lé lhoq htên é htoq agó, Garai Gasang lé lháng, Yhâng Wa ga wut é dông, yhumsing gùng lé, Garai Gasang eq lhoq whuí é yanmai, Yudaq byu pé gi, Yhang lé sat pyám râ matú, je riyhang shikut lo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuq, yhangmoq lé tû taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, haû Zo gi, yhumsing é myit dông haî le a wó kut; Yhâng Wa kut é hkyô lé myang é gù za wó kut é nghut lhê; hkâsu mù gâ le, haû Îwa kut é hkyô lé za, haû Zo châng kut é yanmai nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Hkâsu mù gâ le, haû Îwa gi, Zo lé chyitdap é nghut luî, Yhang kut é hkyô lhunglháng, haû Zo lé tûn shit ri; nungmoq maú hông shoq, shí pé htoq je ko é hkyô pé lé lháng, haû Zo lé tûn shit shirâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Haû Îwa gi, shî bê bang lé lhoq dui toq mù, yhangmoq lé asak byî é eq rajung za, haû Zo le, Yhang byí nau é bang lé, asak byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Hau htoq agó, haû Îwa lé hkunggâ é eq rajung za, haû Zo lé le, lhunglhâng bang hkungga kó sháng gaq ga, haû Îwa gi, ó yuq lé le a jéyáng e za, jéyáng é hkyô lhunglháng, haû Zo lé lum to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Haû Zo lé a hkunggâ é sû gi, haû Yhang lé nhang kat é sû Îwa lé le, a hkunggâ é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ngò, nungmoq lé teng za taí kôlé, Ngá dang lé gyo luî, Ngo lé nhang kat é Sû lé lumjíng é sû, ó yuq nghut kôle, mara byî é a hui e za, ahtum abyuq é asak wó é nghut lhê; haú yuq gi, shi é mai lut luî, asak duì bê sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngò, nungmoq lé teng za taí kôlé, haû Garai Gasâng é Yhangzô é htê lé, shi byuq bê bang wó gyo râ ahkyíng gi, jé lo nyì bê nghut ri; ahkuî lháng jé to bê nghut ri. Htê haú lé gyô é bang gi, asak duì kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hkâsu mù gâ le, Garai Gasang gi, Yhânggùng má yhang, asak bo é eq rajung za, Yhang Zo lé le, Yhânggùng má yhang, asak bò nhang é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hau htoq agó, Yhang gi, haû Byu Yhangzo nghut é yanmai, Garai Gasang gi, tarâ jéyáng râ ahko ahkáng, Yhang lé byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Shí hkyô lé hkâ-maú hong nyì kó: lup pé má lúng tô é bang banshoq gi, Yhâng é htê lé wó gyo kôluî, htoq ló râ ahkyíng jé lò râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ge é hkyô kut é bang gi, asak duì râ matú, dui toq kó râ nghut lhê; agè ashop hkyô kut é bang gi, mara byî é hui zo râ matú, dui toq kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngò gi, Ngá myit dông mai haî le a wó kut é nghut lhê; Ngò wó gyô yu é eq rajung za sheq, jéyáng é nghut luî, Ngò jéyáng é hkyô gi, tengmán lhê; hkâsu mù gâ le, Ngò gi, Ngò ô nau é dông châng é a nghut e za, Ngo lé nhang kat é Sû ô nau é dông châng é sheq ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ngá gûng lé ngò saksé hkâm é nghut jáng, ngò za saksé hkâm é hkyô gi, teng râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngá é hkyô lé saksé hkám byî é Sû (Ngá Wa) góyuq nyi lhê; Ngò eq séng luî, haú yuq hkâm é saksé gi, têng é hkyô lé, Ngò sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nungmoq gi, Yohan chyáng byù nhang kat wú bekô nghut ri; yhang gi, haû tengmán hkyô lé saksé hkám byi bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngò gi, xângzo byu pé mai saksé hkám byi râ lé, ra luî a nghut, nghut kôlhang, nungmoq hkyi yu é wó hui râ matú sheq, haû su nghû taî é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohan gi, duq nyi é myibung su duqbó byî é nghut mù luî, nungmoq gi, haû duqbó é hkaû má, rayoq zo ngón nau nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nghut kôlhang, Ngò wó é saksé gi, Yohan byî é saksé htoq je kô lhê; hkâsu mù gâ le, ahkuî Ngò zui saî nyi é muzó gi, Ngò lhoq pán râ matú, haû Îwa, Ngo lé ap byî tô é nghut luî, haû Îwa, Ngo lé nhang kat é hkyô lé, saksé hkám byî nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hau htoq agó, haû Ngo lé nhang kat é sû Îwa le, Ngò eq séng luî saksé hkám byî ri; nungmoq gi, Yhâng é htê lé le, a wó gyô wú kó; Yhâng é gunghkyâng lé le, a myang wú kó; ");
INSERT INTO atbNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","haû Yhâng é mungdang le, nungmoq chyáng a bò kó nghut ri; hkâsu mù gâ le, nungmoq gi, Yhang nhang kat é Sû lé a lumjíng kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nungmoq gi, haû Chyúmdang mai ahtum abyuq é asak wó yû râ nghut lhê ga myit yù kô é yanmai, haû Chyúmdang má ho wú akô nghut ri; nghut kôlhang, Chyúmdang haû gi, Ngò eq séng luî saksé hkám byî ri; ");
INSERT INTO atbNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nghut kôlhang, asak wó yû râ matú, nungmoq gi, Ngá chyáng a kâm lé kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ngò gi, byu èq hkya-ôn é lé a lhom yu é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nghut kôlhang, nungmoq lé gi, Ngò sê lhê; nungmoq é i-myit hkaû má, Garai Gasang lé chyitdap é myit a bò kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngò gi, Ngá Wâ é myìng mai jé lé é sû nghut kôlhang, nungmoq gi, Ngo lé a lhom hap yù kó; yhâng myìng yhang lang é byù, gotû rayuq jé lé é ru nghut le gi, haú yuq lé, nungmoq lhom hap yù kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nungmoq gi, rayuq eq rayuq hkya-ôn lhûm é lé za hap yù luî, rayuq za nghut é Garai Gasâng chyáng mai lo é hkya-ôn hkyô lé gi, a hô kô é bang nhîng, hkâsu kut wó lumjíng kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nghut kôlhang, haû Îwâ é hí má, Ngò, nungmoq lé mara hûn nhô hkâ-ngâm kó; nungmoq lé mara hun é sû gi, haû nungmoq mai myit myoqbyu tô é Mosheq ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosheq lé nungmoq gè gè yhang lumjíng kô é ru nghut le gi, Ngo lé le lumjíng kó râ nghut lhê; hkâsu mù gâ le, Mosheq gi, Ngá é hkyô lé kâ tô é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nghut kôlhang, nungmoq gi, yhang kâ tô é pé lé lháng a lumjíng kô é nhîng, Ngá dang lé, hkâsu kut wó lumjíng kó râ lhú?\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hau htâng a myáng má, Yesuq gi, Tiberi nhông le gâ é, Galile nhông he hpoq shut gû dap ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Haú hkûn, byù ajùm ayò gi, haû nò bâng htoq má, Yhang kut shit é limik kumlhá pé lé myàng kô é yanmai, Yhang htâng châng e ló bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuq gi, bùm shut doq ló mù, Yhâng é chángzô pé eq rahá zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yudaq byu pê é Lhoqlhai Poî gi, chyâng lo nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuq gi, tu wú kat le, byù ajùm ayò Yhâng shut lé lo bùm kô é lé byu-myang kat luî, Hpilip lé, \"Shí bang zo râ muk, nga-nhúng, hkâmá ê wó wuî râ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesuq, haû su ga taî é gi, yhang lé chyam wú râ matú za nghut ri; hkâsu mù gâ le, hkâsu kut râ hkyô gi, Yhâng é myit má bo to gù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hpilip gi, Yhang lé, \"Denari í sho èq muk wui le lháng, rayuq ratsuí tsuí ngap râ a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Haú hkûn, Yhâng é chángzo nghut é, Simun Petruq é yhanggu Andre gi, Yhang lé, ");
INSERT INTO atbNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"Muk-yo muk ngo long eq ngozo í du wó é yuqgè zo rayuq, shî má nyi ri; nghut kôlhang, byù shî myhô bang lé luq shoq, hkâsu kut wó gâm byi râ lhú?\" ga taî htoq kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuq gi, \"Haû shiwa byu pé lé, zùng nhâng keq.\" ga taî ri. Jowò haû gi, mhán htu é jang nghut mù, yuqgè wuì baú lháng, ngo hkyîng kô zung tô bùm bekô nghut ri; ");
INSERT INTO atbNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","hau htâng, Yesuq gi, muk long pé lé yù mù, jeju hkya-on luî, zung tô é bang lé, yhangmoq o é myhó tsing gàm byî ri. Haû eq rajung za, ngozo lé le haû su kut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yhangmoq banshoq bang zô gyî bùm kô é htâng má Yhang gi, Yhâng é chángzô pé lé, \"Myit gyó tô é ajap azo pé lé châng guq tsîng yù keq. Haî le a langsâ pyám sháng gaq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Haû mù, yhangmoq gi, zô myhit tô é muk-yo muk ngo long mâ é ajap azo pé lé châng guq tsîng le, raxe í mung byíng shoq wó guq tsîng yu akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Haû shiwa byu pé gi, Yesuq kut é limik kumlhá lé myàng kô é hkûn, \"Shí yuq gi, mingkan htoq má jé lé lô râ gâ é, Myiqhtoi yhang nghut ri-nhung!\" ga taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuq gi, yhangmoq lé mù, Yhang lé hkohkâm zik kut nhâng kó râ dâ é hkyô lé, sê é yanmai, Yhang baú tsik za bùm shut dum haq doq ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Buigyum htâng, Yhâng é chángzô pé gi, haû nhông shut gyó ló mù, ");
INSERT INTO atbNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","lhaî má wang ji luî, nhông hé hpoq mâ é Kaperna-um wà shut gû e ló akô; haú hkûn, mauchut bê nghut kôlhang, Yesuq gi, yhangmoq chyáng a jé gyó lo shi nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Haú u lé, laidun htan lo é yanmai, wuìlhêng toq lô bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yhangmoq gi, sum myi déng kô lhaî kôn e ló kô é hkûn, Yesuq gi, nhông htoq má so luî, haû lhaî shut chyâng lé lo nyi é lé myàng kômù, gyuq dan bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nghut kôlhang, Yesuq gi, \"Hkâgyuq kó, Ngò ru nghut lhê.\" ga yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Haû mù, yhangmoq gi, Yesuq lé gabú myit èq lhaî hkaû má shuî hâng yù nau akô. Haú hkûn, lhaî haû gi, radá dâm yhangmoq jé nau é jang wuiyàm má jé bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nhông hé hpoq má nyi tô é byù moq mó gi, haú má lhaî racham za joq laî lo é hkyô eq, lhaî haú má Yesuq a bo doq jî e za, chángzô pé baú ji htoq ló kô é hkyô lé, hau htang nyí, bûn sê kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Haú hkûn, haû Yhumsîng, jeju hkya-ôn é htâng, byu pé muk zô é jowò nàm má, Tiberi myuq mâ é lhaî pé jé lé bum ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Haû byù moq mó gi, Yesuq eq Yhâng é chángzô pé, haú má a nyì lo kô é hkyô lé sé kô é yanmai, Yesuq lé châng hô râ matú lhaî haú pé má wang ji mù, Kaperna-um wà shut e ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yhangmoq gi, nhông hé hpoq má Yesuq lé myàng kôjáng, \"Rabai ê, Nàng gi, shî má hkâ-nhám jé lé é lhú?\" ga, Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Haú hkûn, Yesuq gi, \"Ngò, nungmoq lé teng za taí kôlé, nungmoq gi, limik kumlhá pé lé myàng kô é yanmai, Ngo lé hô kô é a nghut, muk gyi shoq myàng zo kô é yanmai sheq, hô kô é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Htên byuq sê é zoshuq é matú, hkâshikut kó; haû Byu Yhangzo byi râ nghut é ahtum abyuq é asak é matú, ru gîng nyi é zoshuq wó yû râ lé sheq shikut nyì keq. Yhâng chyáng gi, haû Îwa Garai Gasang mai Yhâng é saksé dizik tap to bê nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Haû mù, yhangmoq gi, \"Garai Gasang ô nau é muzó pé zui saí râ matú, ngamoq haî kut ra râ lhú?\" ga Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Haú hkûn, Yesuq gi, \"Garai Gasang nhang kat é Sû lé, lumjíng é gi, Garai Gasang ô nau é muzó nghut bê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Haû mù luî, yhangmoq gi, Yhang lé, \"Ngamoq myoq èq wó myâng luî, Nàng lé lumjíng râ matú, Nàng, haí jung limik kumlhá kut shit râ lhú? Nàng, haí jung kut shit râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Haû Chyúmdang má, 'Yhang gi, yhangmoq zo râ matú, mauhkûng mai muk byî ri.' ga kâ tô é eq rajung za, ngamoq é îchyí îwa pé gi, haû yoso hkaû má mannaq muk zo bekô nghut lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Haú hkûn, Yesuq gi, yhangmoq lé, \"Ngò, nungmoq lé teng za taí kôlé, nungmoq lé mauhkûng mai muk byî é Sû gi, Mosheq a nghut, haû Ngá Wa sheq, nungmoq lé mauhkûng mai tengmán é muk byî é Sû ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hkâsu mù gâ le, Garai Gasang byî é muk gi, mauhkûng mai gyó lé luî, haû mingkan lé asak byî é Sû nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yhangmoq gi, \"Yhumsîng ê, ahkuî mai, ngamoq lé muk haû hkâ-nhám le byî nyì laq.\" ga chôm taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Haû mù, Yesuq taî kyô é gi, \"Ngò gi, asak muk nghut lhê. Ngá chyáng lé é sû gi, hkâ-nhám le zòmut é hui râ a nghut; Ngo lé lumjíng é sû le, hkâ-nhám le wuìshit é hui râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nghut kôlhang, Ngò, nungmoq lé taî wú bê eq rajung za, nungmoq gi, Ngo lé myang wú é nghut kôlhang, a lumjíng shi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Haû Îwa mai Ngo lé ap byî tô é byù lhunglhâng bang gi, Ngá chyáng lé kó râ nghut luî, Ngá chyáng lé é sû ó yuq lé le, Ngò gi, hkâ-nhám lé hkat htoq pyám râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hkâsu mù gâ le, Ngò, mauhkûng mai gyó lé é gi, Ngò ô nau é hkyô lé kut râ matú a nghut e za, Ngo lé nhang kat Sû ô nau é hkyô lé kut râ matú ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Haû Ngo lé nhang kat Sû ô nau é hkyô gi, Yhang mai Ngo lé ap byî tô é bang mâ é rayuq lé lháng, Ngò, a lhoq hpyuq pyâm e za, jihtûm buinyì má yhangmoq lé dum lhoq dui toq yû râ matú ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hkâsu mù gâ le, Ngá Wa ô nau é hkyô gi, haû Zo lé wú mù, Yhang lé lumjíng é sû yuq hkangmó, ahtum abyuq é asak lé wó yû râ matú nghut lhê; Ngò le, jihtûm buinyì má haú bang lé lhoq dui toq râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Haû mù, \"Ngò gi, mauhkûng mai gyó lé é muk nghut lhê.\" ga, Yesuq taî é yanmai, Yhang eq séng luî, Yudaq byu pé taî put kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","\"Shí yuq gi, Yosep é yhangzo Yesuq a nghut lhi? Yhâng nu Yhâng wa lé, nga-nhúng sê lhê a nghut kó lhú? Haû sû é nhîng, ahkuî, 'Ngò gi, mauhkûng mai gyó lé é nghut lhê.' ga, Yhang hkâsu kut wó taî lhê lhú?\" gâ bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Haú hkûn, Yesuq gi, \"Nungmoq ahkaû má hkâtaî put nyì kó. ");
INSERT INTO atbNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Haû Ngo lé nhang kat é sû Îwa mai shuî jé é sû za a nghut jáng, ó yuq le Ngá chyáng wó jé lé râ a nghut; jé lé é sû lé gi, jihtûm buinyì má, Ngò lhoq dui toq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Myiqhtoi laiká pé má, 'Yhangmoq lhunglhâng bang gi, Garai Gasâng èq mhoq byî é hui kó râ nghut lhê.' ga kâ tô é eq rajung za, haû Îwâ chyáng mai gyo yù, mhoq yu é bang yuq hkangmó gi, Ngá chyáng lé kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Haû gi, rayuq yuq mai, haû Îwa lé myang wú bê nghû nau é a nghut; Garai Gasâng chyáng mâ é Sû za sheq, haû Îwa lé myang wú é Sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngò, nungmoq lé teng za taí kôlé, lumjíng é sû gi, ahtum abyuq é asak wó lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngò gi, asak muk nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nungmoq é îchyí îwâ pé gi, haû yoso hkaû má mannaq muk zo bekô nghut lhê; nghut kôle, shi byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nghut kôlhang, shî gi, mauhkûng mai gyó lé lo é muk nghut lhê; haû lé zô é sû gi, a shî lo râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngò gi, mauhkûng mai gyó lé lo é, haû asak dui é muk nghut lhê; rayuq yuq, muk shî lé zô é nghut le gi, ahtum abyuq dui nyì râ nghut lhê; muk shî gi, mingkan zô wui é asak matú, Ngò byi râ nghut é Ngá gungsho nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Haû mù, haû Yudaq byu pé gi, \"Byù shí yuq gi, nga-nhúng lé, Yhâng é gungsho hkâsu kut wó byi tso râ lhú?\" ga, yhangmoq yhangchang dang htíng htîng lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Haú hkûn, Yesuq gi, yhangmoq lé, \"Ngò, nungmoq lé teng za taí kôlé, haû Byu Yhangzô é gungsho lé zô é eq Yhâng é sui lé shuq e za a nghut le gi, nungmoq asak wó kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngá é gungsho lé zô é eq Ngá é sui lé shuq é sû, ó yuq nghut kôle, ahtum abyuq é asak wó é nghut lhê; Ngò gi, jihtûm buinyì má, haú yuq lé lhoq dui toq yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Hkâsu mù gâ le, Ngá é gungsho gi, zojung yhang nghut lhê; Ngá é sui gi, shuqjung yhang nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ngá é gungsho lé zô é eq Ngá é sui shuq é sû, ó yuq nghut kôle, Ngò má nghut nyî luî, Ngò le haú yuq má nghut nyî bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Haû rû dui nyi é Îwa gi, Ngo lé nhang kat luî, Ngò gi, haû Îwâ é yanmai, dui nyi é eq rajung za, Ngá é gungsho lé zô é sû gi, Ngá é yanmai, dui nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Shî gi, mauhkûng mai gyó lé lo é muk nghut lhê. Nungmoq é îchyí îwâ pé gi, mannaq muk zo kôle, shi byuq bekô nghut ri; nghut kôlhang, muk shî lé zô é sû gi, ahtum abyuq dui nyì râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dang haú pé gi, Yesuq, Kaperna-um wà mâ é tarajong má mhoqshit nyi é u lé, taî é dang nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yhâng é chángzô pé myo myo gi, haû lé wó gyo kôjáng, \"Dang shî gi, gyai wuî ri. Ó yuq wá wó cháng râ lhú?\" ga taí bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuq gi, haû eq séng luî, Yhâng é chángzô pé taî put nyi bùm kô é lé Yhâng é myit má sé luî, yhangmoq lé, \"Dang shi é yanmai, nungmoq myit htên bum akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Haû Byu Yhangzo gi, Yhang nyi laî lò bê jowò shut taû doq ló é lé, nungmoq myàng kô é nghut le gi, hkâsu nghû kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Haû Woi-nyí gi, asak byî lhê; gungsho kúm gi, haî le a wó dut nghut ri. Nungmoq lé, Ngò taî é dang pé gi, Woi-nyí le nghut lhê, asak le nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nghut kôle, nungmoq chyáng mâ é ra-am gi, a lumjíng kó nghut ri.\" ga taî ri. Hkâsu mù gâ le, ô pé gi, a lumjíng kó râ eq, ó yuq gi, Yhang lé ap pyám râ nghut é hkyô lé, Yesuq gi, sâng-hi mai sê to gù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yhang xoq taî é gi, \"Haû su mù, haû Îwâ èq ahkáng byî é sû za a nghut le gi, ó yuq le Ngá chyáng wó lé râ a nghut nghû, Ngò, nungmoq lé taî kyo wú bê nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Haú dàm mai, Yhâng é chángzô pé myo myo gi, Yhâng htâng a cháng lo kô e za, taû ló byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Haû su mù, Yesuq gi, haû chángzo raxe í yuq lé, \"Nungmoq le, ló byuq nau akô, a nghut lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Haú hkûn, Simun Petruq gi, \"Yhumsîng ê, Nàng gi, ahtum abyuq é asak mungdang wó Sû nghut to bê lé nhîng, ngamoq gi, ó yuq chyáng ê shirâ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nàng gi, Garai Gasâng é Chyoiyúng Sû nghut é lé, ngamoq, lumjíng lhê, sê nyi lhê.\" ga, Yhang lé tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Haú hkûn, Yesuq gi, \"Nungmoq raxe í yuq lé, Ngò hkyin yù bê a nghut kó lhú? Nghut kôle, nungmoq mâ é rayuq gi, nat nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Yhang gi, haû Simun Iskarut é yhangzo, Yudaq lé taí nau é nghut ri; haú yuq gi, chángzo raxe í yuq má bò sû nghut kôle, htâng má, Yhang lé ap pyám râ sû nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hau htâng má, Yesuq gi, Yhang lé sat râ matú, Yudaq byu pé ho nyi bùm kô é yanmai, Yuda mau má a kâm sô wún mù, Galile mau má sô lhing wún ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nghut kôlhang, haû Yudaq byu pê é Saksé Zúm Poî chyâng lo nyi é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesuq é yhanggu yuqzô pé gi, Yhang lé, \"Náng é chángzô pé gi, Nàng kut é laklaí kumlhá pé lé myàng kó sháng gaq, Nàng, shî mai htoq ló luî, Yuda mau shut e ló aq. ");
INSERT INTO atbNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Myìng hu nau é sû gi, hkaû zaú luî haî le a kut wú é nghut lhê. Nàng gi, haú pé lé kut nyî bê nghut é yanmai, mingkan lé, Náng gûng tûn shit aq.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hkâsu mù gâ le, yhanggu sîng yuqzô pé lháng, Yhang lé a lumjíng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Haû mù luî, Yesuq gi, yhangmoq lé, \"Ngá é ahkyíng gi, a jé shi nghut ri; nungmoq é ahkyíng kúm gi, hká hkûn le joq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Haû mingkan gi, nungmoq lé a jú a wó kut kó nghut ri; nghut kôlhang, Ngo lé gi, a jú kó; haî mù gâ le, yhang kut é hkyô gi, agè ashop é nghut é lé, Ngò, saksé tûn shit é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nungmoq gi, poî haú shut doq ló keq. Ngò kúm gi, Ngá é ahkyíng a jé shi nghut é yanmai, poî haú shut a doq ló shirâ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Haû su ga taí luî, Yhang gi, Galile mau má nyi gyó to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nghut kôlhang, Yhang gu pé, haû poî shut doq ló byuq é htâng má, Yhang gi, de de a nghut é dông, tsik za châng doq ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yudaq byu pé gi, haû poî má, Yhang lé châng hô kômù, \"Haú yuq gi, hkâmá nghut lhê lhú?\" ga, myi wún akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Haû byù hpûng hkaû má, Yhang eq séng luî taî lhûm bùm kô é má, ra-am gi, \"Yhang gi, byù gè nghut ri.\" ga taí kôjáng, ra-am gi, \"A nghut, Yhang gi, byu pé lé hkyô shuî nghoq sû nghut ri.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nghut kôlhang, haû Yudaq suwún wuî lé gyuq kô é yanmai, ó yuq le, Yhang eq sêng é hkyô lé de de a wám taí kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Haû poî rawuí nghut ló é hkûn, Yesuq gi, noqkuq yhûm má doq ê luî, mhoqshit hi ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Haú hkûn, Yudaq byu pé gi, gyô maú byuq kômù, \"Shí yuq gi, mhoq yu é hkyô le a joq wú é wá, haû-í hkâsu mù sê lhê laq?\" ga myi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Haû mù, Yesuq tû taî é gi, \"Ngò mhoqshit é dang gi, Ngá é dang a nghut; Ngo lé nhang kat Su é dang ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Rayuq yuq, Garai Gasang ô nau é hkyô lé châng kut nau é nghut jáng, Ngò mhoqshit é dang gi, Garai Gasâng chyáng mâ é nghut a nghut é eq, Ngá é myit dông taî é dang nghut a nghut é lé, yhang sê gàm hkoq yû râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yhumsing é myit dông taî é sû gi, yhumsing é matú aróng hô sû nghut ri; nghut kôlhang, yhumsîng lé nhang kat su é matú, aróng ho é sû gi, tengmán é byû nghut ri; yhang má, a tengmán é hkyô haî le a bò nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosheq gi, nungmoq lé jep é tarâ byî to bê, a nghut kó lhú? Nghut kôlhang, nungmoq ó yuq le, jep é tarâ haû lé a cháng kó nghut ri. Haî mù luî, Ngo lé sat nau nyi akô lhú?\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Haú hkûn, haû byù hpûng gi, \"Nàng gi, nat gang wang to sû nghut ri-nhung! Nang lé, ó yuq wá sat nau nyi ri lhú?\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuq gi, yhangmoq lé, \"Ngò, laklaí kumlhá ralhum kut jáng, nungmoq banshoq bang gi, maú byuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nghut kôlhang, nungmoq gi, ahpyo-kuq hpyit byî é hkyô lé, Mosheq byî é nghut lhê ga luî, Bánno buinyì má, zoshâng lé ahpyo-kuq hpyit byî akô (gè gè ga jáng, ahpyo-kuq hpyit é hkyô gi, Mosheq chyáng mai lo é a nghut e za, îchyí îwâ pê chyáng mai lo é ru nghut lhê.). ");
INSERT INTO atbNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Haû, Mosheq é jep é tarâ lé a lhoq htên pyám sháng gaq nghû, Bánno buinyì má, zoshâng lé ahpyo-kuq hpyit byî é nghut le gi, haî mù luî, Bánno buinyì má, byù rayuq é gùng gón lé, Ngò lhoq gê byî é yanmai, Ngo lé nhikjum yô akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Byù du lé wú luî hkâjéyáng kó; tengmán é dông sheq jéyáng keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Haû mù luî, Yerusalem wà mó mâ é byu pé ra-am gi, \"Haû yhangmoq sat pyám nau nyi é sû gi, shí yuq a nghut lhi? ");
INSERT INTO atbNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yhang gi, shî má de de dáng nyo nyi le, yhangmoq gi, Yhang lé, haî le a ga kó myhi-nhung! Yhang gi, Hkrisduq nghut lhê ga, haû ahkáng ayá wó bang gi, gè gè yhang, sê akô abe? ");
INSERT INTO atbNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Haû Hkrisduq jé lé é hkûn gi, Yhang hkâmai lé lo é lé, ó yuq lháng sé râ a nghut.\" ga taî bum akô. Nghut kôlhang, shí yuq gi, hkâmâ é sû nghut é lé, nga-nhúng sê lhê; ");
INSERT INTO atbNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Haû mù, Yesuq gi, noqkuq yhûm wàng má mhoqshit uchyang, htê mó èq taî kat é gi, \"Nungmoq gi, Ngo lé sê é htoq agó, Ngò, hkâmai lé é sû nghut é lé le, sê akô nghut ri. Ngò gi, Ngá myit dông shî má lé nyi tô é sû a nghut kôlhang, Ngo lé nhang kat é Sû gi, tengmán lhê; nungmoq gi, Yhang lé a sé kôlhang, ");
INSERT INTO atbNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngò gi, Yhang lé sê lhê; hkâsu mù gâ le, Ngò gi, Yhâng chyáng mai lé é sû eq Yhang mai nhang kat é sû nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Haû mù, yhangmoq gi, Yhang lé chyup râ dâ akô; nghut kôlhang, Yhâng é ahkyíng a jé shi é yanmai, Yhang lé chyup râ matú, ó yuq le loq a jé kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nghut kôlhang, byù hpûng hkaû mâ é bang myo myo gi, Yhang lé lumjíng bûm kôluî, \"Haû Hkrisduq jé lé é hkûn, Yhang gi, shí yuq htoq má, limik kumlhá pé je wó kut shit râ lhú?\" ga taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Haû Hparishe pé gi, haû byù hpûng hkaû má, Yesuq eq sêng é hkyô lé, haû su ga dangsoq soq lhûm nyì kô é hkyô lé wó gyô yu akô. Haû mù, haû hkyangjong agyi pé eq Hparishe pé gi, Yhang lé ê chyup râ matú, noqkuq yhûm zúng é bang lé nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Haú hkûn, Yesuq gi, \"Ngò gi, nungmoq eq rahá rayoq zo za nyì râ nghut lhê; hau htâng, Ngo lé nhang kat Su chyáng taû ló râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Haú hkûn, nungmoq gi, Ngo lé hô kôlhang, myang hô kó râ a nghut; Ngò nyi é jang má, nungmoq wó jé kó râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hau é yanmai, Yudaq byu pé, rayuq eq rayuq taî lhum kô é gi, \"Shí yuq gi, Yhang lé nga-nhúng a myang hô loshoq, hká shut e byuq râ dâ lhê lhú? Yhang gi, Grik byu pé má nyi byo myín tô é nga-nhûng é byu pé nyi é jowò má ê mù, Grik byu pé lé, ê mhoqshit râ dâ lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","'Nungmoq gi, Ngo lé hô kôlhang, myang hô kó râ a nghut.' gâ é eq, 'Ngò nyi é jang má, nungmoq wó jé kó râ a nghut.' gâ é, Yhang taî é dang gi, haí jung wá gá naû é nghut lhê lhú?\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Haû lô htâng é eq je ahkyak é Poî buinyì má, Yesuq toq yap luî, htê mó èq taî é gi, \"Wuì shit sû gi, Ngá chyáng lé mù, shuq sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngo lé lumjíng é sû ó yuq nghut kôle, haû Chyúmdang má taî tô é eq rajung za, 'Yhâng chyáng mai asak uchyâm é wuìlàng yui htoq lô râ nghut lhê.'\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yhang haû su gâ é gi, Yhang lé lumjíng é bang myang hap yù râ nghut é, haû Woi-nyí lé taî é nghut ri. Haú hkûn jé shoq, haû Woi-nyí lé a byi kat shi nghut ri. Hkâsu mù gâ le, Yesuq gi, hpungwup shingkang dan hû é a hui nhâng shi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yhâng é dang pé lé wó gyo kôjáng, ra-am gi, \"Shí yuq gi, gè gè yhang, Myiqhtoi haû nghut ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ra-am gi, \"Shí yuq gi, Hkrisduq nghut ri.\" ga taî akô. Góbang nghut jáng, \"Hkrisduq wá Galile mau mai htoq lé râ nghut lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Haû Chyúmdang má, Hkrisduq gi, Dawiq é awut ashín mâ é nghut luî, Dawiq nyi laî lo é Betlehem wà mai htoq ló râ nghut lhê gâ é, a nghut lhú?\" ga myî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Haû mù luî, Yesuq é yanmai, shiwa byu pé gi, gàm hkoq lò byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ra-am gi, Yhang lé chyup yù nau bùm kôlhang, Yhang lé loq a záng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hau htâng má, haû noqkuq yhûm zúng bang gi, haû hkyangjong agyi pé eq Hparishe pê chyáng taû ló kô é hkûn, haú bang gi, yhangmoq lé, \"Nungmoq, haî mù luî, Yhang lé a shuî lo kô é lhú?\" ga lhom myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Haú hkûn, haû noqkuq yhûm zúng bang gi, \"Shí yuq su ga taî é byù gi, ó le a nyì wú é nghut lhê.\" ga taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Haû mù, haû Hparishe pé gi, \"Nungmoq lé le, Yhang èq mhoq hpyoq yù bekô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Haû zaú wui chyáng le, Hparishe pê chyáng le, Yhang lé lumjíng é byù bò akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A bò! Nghut kôlhang, haû jep é tarâ lé a sê é byù moq mó shî gi, nhîng pyâm é hui bekô nghut ri.\" ga nhik-yô é dông tû taî kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nghut kôlhang, yhangmoq hpúng má bo é, hí hkûn Yesuq chyáng e wú bê sû nghut é, Nikodimu gi, ");
INSERT INTO atbNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","\"Nga-nhúng é tarâ gi, byù rayuq lé, yhâng é dang hí a gyô wú é eq, yhang haî kut é lé a sê e za, mara byi lhê lhú?\" ga, yhangmoq lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Haú hkûn, yhangmoq gi, \"Nàng le, Galile mau byù nghut lhê lhú? Galile mau mai myiqhtoi rayuq lháng a htoq é hkyô lé, nàng gon wú aq, haû jáng sé râ nghut lhê.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hau htâng, yuq hkangmó gi, ó le ô yhûm shut taû ló byuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesuq kúm gi, Tsanlun Bùm shut e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Htang napkyó napsûn noq le, Yesuq gi, noqkuq yhûm wàng hkaû má dum ê luî, byu pé lhunglháng gi, Yhâng é lhînghkyuq má lé zîng bum akô; haû mù, Yhang gi, zung to luî, yhangmoq lé mhoqshit ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Haú hkûn, haû tarâ sará pé eq Hparishe pé gi, sulàng shut nyi é má myang chyup yu é su-myi rayuq lé shuî lé lô kômù, gung gûng má shap to kôluî, ");
INSERT INTO atbNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesuq lé, \"Sará ê, myiwe myhí shî lé, sulàng shut nyi é má myang chyup yu é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Haû Mosheq é tarâ má gi, shî su é myiwe lé, luqgok èq dú sat pyám keq ga, nga-nhúng lé hkunmó hkyô tô ri. Ahkuî, Nàng gi, hkâsu nghû râ lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yhangmoq haû su ga myî é hkyô gi, Yhang lé mara wó hûn shoq ga, chyam wú râ matú nghut ri. Nghut kôlhang, Yesuq gi, ngóm mù, myigùng má loqnyhuî èq htaû kâ nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yhang lé, yhangmoq ru jang myî nyì kô é hkûn, Yhang gi, yap nyhang kat mù, yhangmoq lé, \"Nungmoq mâ é mara a wó é sû hí, myiwe myhí shí yuq lé luqgok èq dú sháng gaq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hau htâng, Yhang gi, dum ngóm luî, myigùng má kâ nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yhangmoq gi, haû su gâ é lé wó gyo kôjáng, je mang bang mai hî luî, rayuq htâng rayuq ló byuq bekô nghut luî, Yesuq baú za myit gyó tô é eq, myiwe myhí haû jâng yap nân tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesuq gi, yap nyhang kat luî, yhang lé, \"Myiwe myhí ê, yhangmoq hká ló bekô lhú? Ó yuq èq le, nàng lé mara a byi kó lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yhang gi, \"Yhumsîng ê, ó yuq le mara a byi kó nghut ri.\" ga tû taî ri. Haú hkûn, Yesuq gi, \"Ngò le, nàng lé mara a byi, ló aq hkoi, ahkuî mai mara hkâdum kut shut lo.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesuq gi, shiwa byu pé lé dum nyo é hkûn, \"Ngò gi, mingkân é maubó nghut lhê; Ngá htâng châng é sû ó yuq nghut kôle, mauchut hkaû má hkâ-nhám le so râ a nghut, asak maubó lé wó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Haû mù, haû Hparishe pé gi, \"Wú aq, Náng gûng Nàng saksé hkâm yu é nghut ri; Náng é saksé gi, teng râ a nghut.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Haú hkûn, Yesuq gi, \"Ngá gûng Ngò saksé hkám kôlhang, Ngá é saksé gi, têng lhê; hkâsu mù gâ le, Ngò gi, Ngò hkâmai lé lo é eq Ngò hká shut e ló é lé, sê lhê. Nghut kôlhang, nungmoq gi, Ngò hkâmai lé lo é lé le, Ngò hká shut e ló é lé le, a sé kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nungmoq gi, byù hkyam dông za jéyáng akô; Ngò gi, ó yuq lé le a jéyáng é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nghut kôlhang, Ngò jéyáng é nghut jáng, Ngò jéyáng é hkyô gi, jô lhê; hkâsu mù gâ le, Ngò gi, Ngò baú a nghut, haû Ngo lé nhang kat é sû Îwa eq rahá nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Haû nungmoq é tarâ má yhang le, í yuq mai hkâm é saksé gi, têng lhê ga kâ tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngò gi, Ngá é matú saksé hkâm yù sû nghut lhê; hau htoq agó, haû Ngo lé nhang kat é sû Îwa le, Ngá é matú saksé hkám byî é nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Haû mù, yhangmoq gi, Yhang lé, \"Náng Wa gi, hkâmá lhú?\" ga myi kôjáng, Yhang gi, \"Nungmoq gi, Ngo lé le, Ngá Wa lé le, a sé kó nghut ri; nungmoq, Ngo lé sé kô é nghut le gi, Ngá Wa lé le, sé kó râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dang haú pé gi, haû noqkuq yhûm wàng hkaû mâ é alu kat jang nàm má, Yhang mhoqshit nyi é u lé taî é dang nghut ri. Nghut kôlhang, Yhang lé, ó yuq le a chyup kó; hkâsu mù gâ le, Yhâng é ahkyíng a jé shi é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Haû mù luî, Yesuq gi, yhangmoq lé, \"Ngò gi, ló byuq râ nghut lhê, haú hkûn, nungmoq Ngo lé hô kó râ, yhumsing é mara má le shî kó râ nghut lhê. Ngò ló é jang má, nungmoq wó jé kó râ a nghut.\" ga, radàm dum puq taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hau é yanmai, haû Yudaq byu pé gi, \"'Ngò ló é jang má, nungmoq wó jé kó râ a nghut.' gâ é gi, Yhânggùng yhang sat shî râ gâ é nghut lhê lhú?\" ga myi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nghut kôlhang, Yesuq xoq taî é gi, \"Nungmoq gi, a-ô mai lo é bang nghut akô; Ngò gi, ahtoq mai lé é sû nghut lhê. Nungmoq gi, mingkan shî eq sêng é bang nghut akô; Ngò kúm gi, mingkan shî eq sêng é sû a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Haû mù, nungmoq gi, yhumsing é mara má shî kó râ nghut lhê nghû, Ngò taî é nghut lhê. Ngò gi, haú Yuq nghut lhê nghû taî é lé, nungmoq a lumjíng kô é nghut jáng, nungmoq gi, gè gè yhang, yhumsing é mara má shî kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Haú hkûn, yhangmoq gi, \"Nàng, ó yuq nghut lhê?\" ga myi kôjáng, Yesuq gi, \"Ngò ó yuq nghut é lé, Ngò, hkâ-nhám le taî nyì bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngò gi, nungmoq eq séng luî, taí râ hkyô eq jéyáng râ hkyô, myo myo joq lhê. Nghut kôlhang, Ngo lé nhang kat é Sû gi, tengmán é Sû nghut lhê mù, Yhâng chyáng mai wó gyô yu é gû lé, Ngò, mingkan lé taî kyô lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesuq gi, yhangmoq lé, Yhâng Wa eq sêng é hkyô taî kyô nyi é lé, yhangmoq gi, a sê gyo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Haû mù luî, Yesuq gi, \"Haû Byu Yhangzo lé nungmoq tu shap kat é hkûn sheq, Ngò gi, haû Yuq nghut é hkyô lé le, yhumsing myit dông haî le a kut e za, haû Îwa mhoq byî é dông za taî é hkyô lé le, nungmoq sé kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Haû Ngo lé nhang kat é Sû gi, Ngò eq rahá nghut nyi lhê; Ngò gi, hkâ-nhám le, Yhang lé myit ngón nhang é hkyô chyat kut é yanmai, Yhang gi, Ngo lé baú za a tô pyâm to nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yhang, haû su taî nyi é u lé lháng, byù myo myo gi, Yhang lé lumjíng bûm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Haû mù, Yesuq gi, Yhang lé lumjíng é Yudaq byu pé lé, \"Ngò mhoqshit é hkyô lé châng kut nyî bekô nghut jáng, nungmoq gi, gè gè yhang, Ngá é chángzô pé nghut bekô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nungmoq gi, haû tengmán hkyô lé sé kó râ nghut luî, haû tengmán hkyô gi, nungmoq lé lhoq lhut kat râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Haú hkûn, yhangmoq gi, \"Ngamoq gi, Abraham é awut ashîn pé nghut luî, ó yuq é jùn le hkâ-nhám a dut wú é nghut lhê. Haû mù, 'nungmoq lé lhoq lhut kat râ' nghû Nàng hkâsu kut wó taî lhê lhú?\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuq dum tû taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, mara kut shut é sû gi, marâ é jùn nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jùn gi, yhûm ikun eq hkâ-nhám le sêng nyì râ a nghut; zo kúm gi, ikun eq ahtum abyuq sêng lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Haû mù luî, haû Zo gi, nungmoq lé lhoq lhut kat é nghut jáng, nungmoq gi, gè gè yhang, lut berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nungmoq gi, Abraham é awut ashín pé nghut é lé, Ngò sê lhê. Nghut kôlhang, nungmoq gi, Ngá é dang lé a lhom yù kô é yanmai, Ngo lé sat râ dâ akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngò gi, Ngá Wâ chyáng mai myang yu é eq rajung za, nungmoq lé taî kyô nyi lhê; nungmoq le, nungmoq é îwa chyáng mai wó gyô yu é eq rajung za kut nyi akô nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Haú hkûn, yhangmoq gi, \"Ngamoq é îwa gi, Abraham nghut lhê.\" ga tû taí kôjáng, Yesuq gi, \"Nungmoq, Abraham é yhangzô pé nghut é nghut le gi, Abraham kut é su kut kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nghut kôlhang, nungmoq gi, haû Garai Gasâng chyáng mai wó gyô yu é tengmán hkyô lé taî kyo sû nghut é Ngo lé, sat pyám nau akô nghut ri. Haû sû é hkyô gi, Abraham a kut é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nungmoq gi, nungmoq é îwa kut é muzó lé yhang, kut nyi akô.\" ga taî ri. Haú hkûn, yhangmoq gi, \"Ngamoq gi, dezo amyû a nghut; ngamoq gi, Îwa rayuq za wó lhê; haû gi, Garai Gasang nghut lhê.\" ga taî he akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuq gi, yhangmoq lé, \"Garai Gasang gi, nungmoq é Îwa nghut é nghut jáng, nungmoq gi, Ngo lé chyitdap kó râ nghut lhê; hkâsu mù gâ le, Ngò gi, Garai Gasâng chyáng mai lé jé luî, ahkuî, shî má nyi tô é nghut lhê. Ngò gi, Ngá myit dông lé lo é a nghut, Yhang sheq Ngo lé nhang kat é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nungmoq gi, haî mù Ngá é dang lé a sê gyo kô é lhú gâ le, Ngò taî é dang lé, nungmoq a wó lhom yù kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nungmoq gi, haû nungmoq é îwa nghut é nat Tsadán eq sêng é bang nghut luî, nungmoq é îwa ô nau é hkyô lé kut nau bum akô. Yhang gi, a-nham sâng-hi mai byù sat sû nghut ri. Yhang má tengmán hkyô a bo é yanmai, yhang gi, haû tengmán hkyô má a yap gîng nyì nghut ri. Yhang gi, mhaû é hkûn, yhâng é myit má bo é dông taî ri; hkâsu mù gâ le, Yhang gi, byù mhaú nghut luî, mhaú hkyô pê é îwa nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Haû su mù, Ngò, nungmoq lé, haû tengmán hkyô taî kyô é yanmai, nungmoq gi, Ngo lé a lumjíng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nungmoq mâ é ó yuq wá, Ngo lé mara bo lhê nghû saksé wó tûn shit akô lhú? Ngò gi, haû tengmán hkyô lé taî nyi é nghut le nhîng, nungmoq, Ngo lé haî mù a lumjíng kô é lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Garai Gasang eq sêng é sû gi, Garai Gasang taî é dang lé gyô lhê. Nungmoq a gyo kô é gi, nungmoq, Garai Gasang eq a séng kô é yanmai nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Haú hkûn, haû Yudaq byu pé gi, Yhang lé, \"Nàng gi, Samariq byù nghut é htoq agó, nat gang wang júng to sû nghut lhê nghû, ngamoq taî é dang gi, jô lhê a nghut lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuq gi, \"Ngò gi, nat gang wang júng é hui sû a nghut; Ngò gi, Ngá Wa lé sheq hkunggâ é ru nghut lhê; nungmoq kúm gi, Ngo lé taî hpoî nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngò gi, Ngá é matú aróng ho nyi é a nghut; nghut kôlhang, hô byi Sû rayuq nyi lhê, haú yuq jéyáng sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngò, nungmoq lé teng za taí kôlé, Ngá dang lé châng é sû gi, hkâ-nhám le, shî râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hau é yanmai, haû Yudaq byu pé gi, \"Nàng gi, nat gang wang júng to sû nghut é lé, ahkuî, ngamoq sé bê! Abraham gi, shi byuq bê; haû myiqhtoî pé le, shi byuq bekô nghut ri; nghut kôlhang, Nàng gi, 'Ngá dang lé châng é sû gi, hkâ-nhám le, shî râ a nghut.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nàng gi, ngamoq é îwa Abraham htoq hkik lhê lhú? Yhang gi, shi byuq bê; haû myiqhtoî pé le, shi byuq bekô nghut ri. Náng gûng nàng ó yuq su ngàm lhê lhú?\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuq gi, \"Ngá gûng Ngò lhoq gyaú yu é nghut jáng, Ngá é aróng gi, hai hpaudap é a nghut; nghut kôlhang, haû nungmoq é Garai Gasang nghut lhê ga nungmoq taî é sû, Ngá Wa gi, Ngo lé lhoq gyaú é sû ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nungmoq gi, Yhang lé a sé kó nghut ri; nghut kôlhang, Ngò gi, sê lhê. Yhang lé a sé nghû Ngò taî é ru nghut le gi, Ngò le nungmoq su byù mhaú dut râ nghut lhê; nghut kôlhang, Ngò gi, Yhang lé sé luî, Yhâng é dang gyo sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nungmoq é îwa Abraham gi, Ngo lé râ buinyì lé myoqbyu gabú nyi é nghut luî, myàng mù, gabú bê nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Haú hkûn, haû Yudaq byu pé gi, Yhang lé, \"Nàng gi, asak ngo xê zàn lháng a nghut shî é nhîng, Abraham lé myàng wú é nghut lhê lhú?\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuq gi, \"Ngò, nungmoq lé teng za taí kôlé, Abraham lháng a hkû shi má, Ngò nyì gù bê nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Haû mù luî, yhangmoq gi, Yesuq lé, dú râ ga luqgok kui yu akô; nghut kôlhang, Yesuq gi, haû noqkuq yhûm mai haq htoq ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuq gi, sô yông ló nyi é u lé, hku lé é mai myoqjit to gû nghut é byù rayuq lé myang ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Haú hkûn, Yhâng é chángzô pé gi, Yhang lé, \"Rabai ê, shí yuq, myoqjit gû hku lé é gi, ó yuq kut shut é yubak é yanmai nghut lhê lhú? Yhang kut shut é lhú? A nghut jáng, yhâng nu yhâng wa kut shut é lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuq tû taî é gi, \"Haû gi, yhang kut shut é yanmai le a nghut, yhâng nu yhâng wa kut shut é yanmai le a nghut; haû Garai Gasâng é muzó lé, yhang má wó lhoq htoq shit râ matú, haû dut é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nga-nhúng gi, haû Ngo lé nhang kat Su é muzó lé, nyí nghut tô ashî hkûn, zui saî nyì ra râ dut lhê; myín jé jáng gi, ó yuq le, mû wó zui saí râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngò gi, mingkan htoq má nyi tô é u lé, mingkân é maubó nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yhang gi, haû su ga taí luî, myigùng má sôkan byé hkyó mù, tse-nyhaq saî yù luî, haú yuq é myoqjí má but byî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Hau htâng, haú yuq lé, \"Haû Siloam wuìhtum má ê chî pyám aq.\" ga taî ri. (Siloam gâ é gi, nhang é gâ é lichyúm nghut lhê.). Haû mù, haú yuq gi, ê chi mù, myoq myàng luî, yhûm shut ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Haû yhâng é yhumkyo bang eq yhang dung zô wún é lé myang wú é bang gi, \"Shí yuq gi, haû zung to mù, dung zo zo lhaq kut é sû, a nghut kó lhú?\" ga myî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ra-am gi, \"Haú yuq nghut lhê.\" gâ bum akô. Góbang gi, \"A nghut, haú yuq su dut e za ru nghut lhê.\" ga taî akô. Nghut kôlhang, yhang gi, \"Ngò, haú yuq yhang nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Haú hkûn, yhangmoq gi, \"Haû nghut le gi, náng myoq hkâsu kut wó myang é lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yhang gi, \"Haû Yesuq gâ é byù rayuq, tse-nyhaq ratsuí saî yù luî, ngá é myoqjí má but byi mù, 'Siloam wuìhtum má ê chî pyám aq.' ga ngo lé taî ri; haû mù, ngò ê chî pyâm é htâng má, ngá myoq wó myang é nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Haú hkûn, yhangmoq gi, \"Byù haú yuq gi, hkâmá nyi ri lhú?\" ga, yhang lé myî akô. Yhang gi, \"Ngò a sé.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yhangmoq gi, haû myoqjit wú bê sû lé, Hparishe pê chyáng shuî lé akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuq, tse-nyhaq saî yù mù, haú yuq é myoq lé lhoq myâng byî é buinyì gi, Bánno buinyì nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Haû mù, yhang, myoq hkâsu kut wó myang é hkyô lé, haû Hparishe pé le dum myî akô. Haû jáng, yhang gi, \"Haú yuq gi, ngá é myoqjí má tse-nyhaq but byi mù, ngò gi, ê chî pyám jáng, ngá myoq myàng bê nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Haû Hparishe pé ra-am gi, \"Shí yuq gi, Bánno buinyi é tarâ lé a châng é sû nghut é yanmai, Garai Gasâng chyáng mai lé é sû a nghut.\" ga taî akô. Nghut kôlhang, ra-am gi, \"Yubak dap sû rayuq gi, haû su é limik kumlhá pé lé, hkâsu wó kut htoq râ lhú?\" ga myî akô. Haû mù, yhangmoq gi, myit a huî lhûm bùm lò kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Haû mù, yhangmoq gi, haû myoqjit wú sû shut lhîng mù, \"Nang lé myoq lhoq myâng byî é sû gi, hkasû é byù nghut lhê nghû, nàng taí râ lhú?\" ga dum myi kôjáng, \"Yhang gi, myiqhtoi rayuq nghut ri.\" ga, yhang tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Haû Yudaq byu pé gi, haú yuq myoqjit wú é hkyô lé le, ahkuî myoq dum myàng bê nghut é hkyô lé le, haû yhâng nu eq yhâng wa lé, ê ji lò nhang é hkûn jé shoq, a lumjíng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Haû mù, Yhangmoq gi, haû yhâng nu eq yhâng wa lé, \"Shí yuq gi, nungnhik é yhangzo nghut lhê lhú? Hku lé é hkûn mai, myoqjit gù nghut lhê lhú? Yhang, ahkuî, hkâsu kut wó myang é lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Haú hkûn, yhâng nu eq yhâng wâ nhik gi, \"Yhang gi, ngá-nhik é yhangzo nghut é lé le, hku lé é hkûn mai myoqjit gù nghut é lé le, ngá-nhik sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nghut kôlhang, yhang, ahkuî hkâsu kut wó myang é hkyô lé le, yhâng é myoq lé ó yuq èq lhoq myâng byî é hkyô lé le, ngá-nhik a sé. Yhang, asak wáng bê, yhang lé myî wú keq, yhânggùng yhang dat taî kyo râ nghut lhê.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Haû yhâng nu eq yhâng wâ nhik gi, Yudaq byu pé lé gyuq kô é yanmai, haû su ga taí kô é nghut ri; hkâsu mù gâ le, Yesuq gi, haû Hkrisduq nghut lhê ga yín yu é sû, ó yuq lé nghut kôle, haû tarajong mai lhoq htoq pyám râ nghut lhê ga, haû Yudaq suwún wuî chôm myit hpyit to bekô nghut é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hau é yanmai, yhâng nu eq yhâng wâ nhik gi, \"Yhang, asak wáng bê, yhang lé myî wú keq.\" ga taí kô é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Haû Hparishe pé gi, myoqjit wú bê sû haú yuq lé dum ji yù mù, \"Garai Gasang lé za hkya-on waq toq aq! Haú yuq gi, yubak dap sû rayuq nghut é lé ngamoq sê lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Haú hkûn, yhang tû taî é gi, \"Yhang gi, yubak dap sû rayuq nghut lhê luq, a nghut é luq, ngò a sé. Ngò gi, hí lé myoqjit sû nghut kôle, ahkuî wó myâng bê nghut é lé za, ngò ru sê lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hau htâng, yhangmoq gi, \"Yhang, nang lé haî kut byî ri lhú? Náng é myoq lé, yhang, hkâsu kut lhoq myâng byî ri lhú?\" ga, yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Haú hkûn, yhang gi, \"Ahkuî za, ngò, nungmoq lé taî kyo bê le, nungmoq sheq a gyo kôluî nhîng! Nungmoq gi, haî mù dum gyô nau akô lhú? Nungmoq le, Yhâng é chángzô pé dut nau akô lhú?\" ga taû myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Haû mù, yhangmoq gi, yhang lé gyaí rhoî é dông mai, \"Nàng gi, haú yuq é chángzo nghut ri-nhung! Ngamoq kúm gi, Mosheq é chángzô pé ru nghut lhê! ");
INSERT INTO atbNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Garai Gasang gi, Mosheq lé dáng nyo é hkyô lé, ngamoq sê lhê; nghut kôlhang, haú yuq eq séng luî, Yhang gi, hkâmai lé é sû nghut é lé lháng, ngamoq a sé.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Haú hkûn, haú yuq gi, \"Yhang, ngo lé myoq wó lhoq myang byi kôlhang, Yhang gi, hkâmai lé é sû nghut é lé, nungmoq a sé kô é gi, mauhpo yhang nghut bê! ");
INSERT INTO atbNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Garai Gasang gi, yubak dap bâng é dang lé a gyo byî é hkyô lé, nga-nhúng sê lhê. Garai Gasang gi, Yhang lé noqkuq luî, Yhâng ô nau é hkyô lé, kut é sû é dang lé kúm gyo byî lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hku lé é hkûn mai myoqjit gù nghut é byù lé, ó yuq èq myoq lhoq myâng byî é gâ é hkyô lé, mingkan lé joq é hkûn mai, ó yuq le a wó gyô wú é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Haú yuq gi, Garai Gasâng chyáng mai lé é sû za a nghut le gi, haî le wó kut râ a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Haû su ga jáng, yhangmoq gi, \"Nàng gi, yubak htui má hku lé é sû nghut to luî nhîng, ngamoq lé wám mhoqshit lhê lhú?\" ga tû taí kôluî, yhang lé hkat htoq pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuq gi, haú yuq lé yhangmoq hkat htoq pyâm é hkyô lé wó gyo luî, yhang lé myàng hui jáng, \"Nàng gi, haû Byu Yhangzo lé lumjíng lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Haú hkûn, haú yuq gi, \"Yhumsîng ê, haû gi, ó yuq nghut lhê lhú? Yhang lé, ngò wó lumjíng sháng gaq, taî kyo laq.\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuq gi, \"Nàng, haú yuq lé myàng wú bê nghut lhê; ahkuî, nàng eq dáng nyo nyi é sû gi, haú yuq yhang nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Haû mù, haú yuq gi, \"Yhumsîng ê, ngò lumjíng lhê!\" ga taí luî, Yhang lé noqkuq ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Haú hkûn, Yesuq gi, \"Haû myoqjit bang myoq myàng kó râ hkyô eq myoq myàng bang myoqjit kó râ hkyô lé, tarâ jéyáng râ matú, mingkan shî má Ngò jé lé é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yhang eq rahá nghut nyi é Hparishe pé ra-am gi, Yhang haû su ga taî é lé wó gyo kôjáng, \"Hkâsu htà? Ngamoq gi, myoqjit bang dut bê lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Haú hkûn, Yesuq gi, \"Nungmoq, myoqjit é bang ru nghut le gi, yubak mara a bò kó râ nghut lhê; nghut kôlhang, ahkuî, nungmoq gi, myoq myàng bang nghut lhê ga kô é yanmai, nungmoq má yubak mara bo ashî kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ngò, nungmoq lé teng za taí kôlé, haû sau hkup má, hkúmdong mai a wang e za, gó hkyô dông doq lut wang é sû gi, hkau sû eq damyaq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Haû hkúmdong mai wang é sû kúm gi, sau zúng sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Haû hkum zúng sû gi, yhang lé hkum hpóng byî é htoq agó, haû sau pé gi, yhâng é htê lé gyo byî akô. Yhang gi, yhâng é sau pé lé, myìng lang luî wut yù mù, yhangmoq lé shuî htoq htoq kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yhâng é sau pé banshoq lé hpông htoq yû mù, yhang gi, hí má sô ri; sau pé gi, yhâng é htê lé sê gyo kô é yanmai, yhâng é htâng má châng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nghut kôlhang, yhangmoq gi, byù bíng é htâng má, hkâ-nhám lháng cháng kó râ a nghut e za, yhâng chyáng mai kúm hpang byuq kó râ nghut lhê; hkâsu mù gâ le, haû byù bíng é htê lé, yhangmoq a sê gyo kô é yanmai nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuq gi, dangtú haû lé yù mù, yhangmoq lé taî kyô ri; nghut kôlhang, yhangmoq gi, Yhang haî taî kyô nyi é lé, a sê gyo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Haû mù, Yesuq dum taî é gi, \"Ngò, nungmoq lé teng za taí kôlé, Ngò gi, haû sau pé wang é hkúmdong nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngá é hí má lé é lhunglhâng bang gi, hkau bang eq damyaq pé nghut akô; haû sau pé kúm gi, yhangmoq é dang lé a lhom gyo byi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngò gi, hkúmdong nghut lhê; Ngò mai wang é sû ó yuq nghut kôle, hkyi yu é hui râ nghut lhê. Haú yuq gi, htoq htoq wàng wàng wó kut râ eq mhan-yô myang hô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Haû hkau sû gi, hkau râ, sat râ eq lhoq htên pyám râ matú, lé e za nghut lhê. Ngo lé é gi, yhangmoq, asak wó yû râ eq byíngjup é asak lé wó yû râ matú sheq nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ngò gi, ge é sau zúng sû nghut lhê; haû ge é sau zúng sû gi, sau pê é matú, yhumsing é asak lé ap byi pyâm é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Haû langchyáng kut sû gi, sau pé lé sing é sau zúng sû a nghut; haû mù, yhang gi, haû wamhkui lé lo é lé myàng jáng, saû pé lé pyâm to mù hpang ló byuq râ nghut lhê; haú hkûn, wamhkui gi, sau hpúng lé ê htim luî, lhoq pyo pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yhang gi, langchyáng hpó nghut luî, haû sau pê é matú haî le a myit chiq byî é yanmai, hpang é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ngò gi, haû ge é sau zúng sû nghut lhê; haû Îwa gi, Ngo lé sê é nghut luî, Ngò le, haû Îwa lé sê é eq rajung za, ");
INSERT INTO atbNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ngá é sau pé lé, Ngò sê lhê; Ngá é sau pé le, Ngo lé sê akô nghut ri; Ngò gi, haû sau pê é matú, yhumsing é asak lé ap byî pyâm é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ngò gi, sau hkup shî mâ é a nghut é gotû sau pé wó ashî; sau haú pé lé le, Ngò, shuî yù ra râ nghut lhê; sau haú pé le, Ngá é htê lé gyo kó râ nghut lhê; haú hkûn, sau hpúng rahpúng za dut luî, sau zúng sû le rayuq za, nghut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ngò gi, Ngá é asak lé dum wó taû yù sháng gaq nghû, yhumsing é asak lé ap byî pyâm é yanmai, Ngá Wa gi, Ngo lé chyitdap é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ngá é asak lé, ó yuq èq le wó yu pyâm é a nghut, Ngá é myit dông byi pyâm é ru nghut lhê. Ngò gi, yhumsing asak lé ap byi pyám râ ahko ahkáng eq haû lé dum taû yù râ ahko ahkáng wó sû nghut lhê. Haû gi, Ngá Wâ chyáng mai Ngò wó yu é hkunmó nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Dang haú pê é yanmai, haû Yudaq byu pé gi, myit a huî lhum dum dut byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Haú mâ é bang myo myo gi, \"Yhang gi, nat gang wang júng to luî, nâ byuq bê nghut ri. Yhâng é dang lé, haî mù gyô nyi akô lhú?\" ga taí bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nghut kôlhang, góbang gi, \"Dang shi pé gi, nat gang wang júng tô é byù taî é dang a nghut. Nat gang gi, myoqjit sû lé, myoq wó lhoq myâng nhâng râ lhú?\" ga taí bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalem wà mó má, Ap Nóng Poî jé bê nghut ri. Haû gi, gyoqmyò nám nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Haú hkûn, Yesuq gi, haû noqkuq yhûm wàng mâ é, Sholumon é Jirop má sô yông wún ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Haú u lé, haû Yudaq byu pé gi, Yhâng é lhînghkyuq má lé zîng bùm kômù, \"Nàng gi, ngamoq lé hkâ-myháng jé shoq úng-áng nhang nyì râ lhú? Nàng, Hkrisduq nghut le gi, ngamoq lé san za taî kyô pyám laq.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuq gi, \"Ngò, nungmoq lé taî kyo bê nghut lhê; nghut kôlhang, nungmoq a lumjíng kó nghut ri. Ngá Wâ é myìng mai, Ngò kut é laklaí kumlhá haú pé gi, Ngá é matú saksé hkám byî nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nghut kôlhang, nungmoq gi, Ngá é sau a nghut kô é yanmai, a lumjíng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngá é sau pé gi, Ngá é htê lé dat gyô akô; Ngò gi, yhangmoq lé sê lhê; yhangmoq le, Ngá htâng châng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngò gi, yhangmoq lé, ahtum abyuq é asak byî é nghut mù, yhangmoq gi, hkâ-nhám le htên byoq kó râ a nghut; ó yuq èq le, yhangmoq lé, Ngá é loq mai wó lú yû râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yhangmoq lé, Ngá é loq má ap byi tô é sû, haû Ngá Wa gi, lhunglhâng htoq má je gyaú Sû nghut lhê; ó yuq èq le, yhangmoq lé, Ngá Wâ é loq mai wó lú yû râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngò eq haû Îwa gi, rayuq za nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Haú hkûn, haû Yudaq byu pé gi, Yesuq lé, dú râ matú luqgok dum kui akô. ");
INSERT INTO atbNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nghut kôlhang, Yesuq gi, yhangmoq lé, \"Haû Îwâ chyáng mâ é laklaí kumlhá mó pé myo myo, Ngò, nungmoq lé tûn shit bê nghut lhê. Nungmoq, Ngo lé dú râ gi, hká lhûm é yanmai nghut akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Haû Yudaq byu pé gi, \"Ngamoq, Nang lé dú râ gi, haú pé hká lhûm é yanmai le a nghut; Nàng gi, byù rayuq nghut to luî, Garai Gasang nghut é dông taí whuí luî, Yhang lé rhoî dang taî é yanmai, dú râ nghû lhê.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Haú hkûn, Yesuq gi, yhangmoq lé, \"'Nungmoq gi, garaî pé nghut akô nghû, Ngò taí bê nghut lhê.' ga nungmoq é tarâ má kâ to lhê a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chyúmdang haû lé gi, a ge lhoq hpyoq pyâm é nghut luî, haû Garai Gasâng é mungdang lé wó yu é bang lé, 'garaî pé' gâ é nghut le gi, ");
INSERT INTO atbNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","haû Îwa mai, Yhang é matú hkyin htoq yû luî, mingkan má nhang é Sû eq séng luî gi, hká dông nghû kó râ lhú? 'Ngò gi, Garai Gasâng é Yhangzo nghut lhê.' nghû taî é yanmai, Ngò gi, Garai Gasang lé taî hpoî ri nghû, nungmoq, haî mù Ngo lé mara hûn akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngá Wâ é muzó pé lé, Ngò kut é a nghut jáng, Ngo lé hkâlumjíng kó. ");
INSERT INTO atbNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nghut kôlhang, Ngò, haú pé lé kut é nghut le gi, nungmoq, Ngo lé a lumjíng kôlhang, haû muzó pé lé lumjíng keq; haú hkûn, haû Îwa gi, Ngò má nghut nyi é hkyô lé le, Ngò gi, haû Îwa má nghut nyi é hkyô lé le, nungmoq wó sé luî, sê gyo kó râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yhangmoq gi, Yhang lé chyup râ dum hen akô; nghut kôlhang, Yhang gi, yhangmoq é loq mai wó lut ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hau htâng, Yesuq gi, haû Yodan làng he hpoq mâ é, Yohan, wui-myhup hkám byî hi é jowò má ló jé ri. Haû má, Yhang nyi nyi é nghut luî, ");
INSERT INTO atbNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","byù myo myo gi, Yhâng chyáng lé jé bum akô. Yhangmoq gi, \"Yohan gi, limik kumlhá a kut wú é nghut kôlhang, shí yuq eq séng luî, Yohan taî é hkyô lhunglháng gi, têng ri.\" ga taí bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Haú jowò má, byù myo myo gi, Yesuq lé lumjíng bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ahkuî, Lazaruq gâ é byù rayuq gi, no nyi ri. Yhang gi, haû Mariq eq yhângnhá Mahtaq nhik nyi é Behtani wà mâ é sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariq haû gi, Yhumsîng lé namngón-xû hut gyun luî, hkyî má yhâng xam èq sùt byî é sû nghut ri; yhang gi, haû no nyi é Lazaruq é yhângnhá nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Haû mù, haû yhângnhâ nhik gi, \"Yhumsîng ê, Nàng chyitdap é sû gi, no nyi ri.\" ga, Yesuq chyáng ê taí nhang akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuq gi, dang haû lé wó gyo jáng, \"Nòhpyo haû gi, shî-nò a nghut. Haû Garai Gasâng é Yhangzo gi, hau é yanmai, hpungwup shingkang wó dan hû é hui sháng gaq ga, Garai Gasâng é hpungwup shingkâng é matú dut é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuq gi, Mahtaq eq yhanggu Mariq lé le, Lazaruq lé le, chyitdap ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Haû su mù, Yhang gi, haû Lazaruq no nyi ri gâ é lé, wó gyô é hkûn, haû Yhang nyi é jowò má, í nyí nyi tô ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hau htâng, Yhang gi, Yhâng é chángzô pé lé, \"Nga-nhúng gi, Yuda mau shut dum taû ló sháng.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Haú hkûn, yhangmoq gi, \"Rabai ê, hkû-yoq za, haû Yudaq byu pé, Nang lé luqgok èq dú sat râ da kô é nghut le nhîng, ahkuî, haú shut dum taû ló râ lhú?\" ga Yhang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuq gi, \"Nyí gi, hkyíng hkum raxe í hkum bo lhê a nghut kó lhú? Nyí má hkyô sô é sû gi, mingkan shi é maubó é yanmai myoq myàng luî, lengbat râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Myín lé hkyô sô é sû kúm gi, maubó lé a wó é yanmai, lengbat lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Haû su ga taî é htâng má, Yhang, yhangmoq lé xoq taî kyô é gi, \"Nga-nhûng é luzúm Lazaruq yhup myhî byuq bê nghut ri; nghut kôlhang, Ngò gi, yhang lé ê nhaû toq râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Haú hkûn, Yhâng é chángzô pé gi, \"Yhumsîng ê, yhang yhup myhî tô é nghut le gi, ge lò râ nghut lhê.\" gâ taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuq gi, Lazaruq shi byuq bê hkyô lé taî é nghut ri; nghut kôlhang, Yhâng é chángzô pé gi, gè gè yhup myhî tô é lé taî é su ngam pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Haû mù luî, Yesuq, yhangmoq lé san za jáng taî kyô é gi, \"Lazaruq gi, shi byuq bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ngò haú má a nyi záng é gi, nungmoq wó lumjíng râ matú nghut luî, nungmoq é matú Ngò gabú byî ri; yhâng chyáng e ló sháng hkoi.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Haû mù, haû Zozûm le gâ é Htomaq gi, gotû chángzô pé lé, \"Nga-nhúng le, Yhang eq rahá shî sháng gaq, châng e ló sháng.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuq gi, jé e é hkûn, haû Lazaruq lé lup má kat pyâm é myi nyí nghut bê hkyô lé, lhom taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Behtani wà gi, Yerusalem wà mó eq í déng kô za wê lhûm ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Haû mù, Yudaq byu pé myo myo gi, Mahtaq eq Mariq nhik é yhanggu shi byuq é yanmai, nhik tíng byi kó râ ga lé jé nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mahtaq gi, Yesuq jé lé lo é hkyô lé wó gyo jáng, htoq ê mù, Yhang lé ê huî ri; nghut kôlhang, Mariq gi, yhûm má nyi tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mahtaq gi, Yesuq lé, \"Yhumsîng ê, Nàng, shî má nyi tô é ru nghut le gi, ngá gu shi byuq râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nghut kôlhang, ahkuî le, Garai Gasâng chyáng Nàng haî dung kôlhang, Yhang byi râ nghut é lé, ngò sê lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuq gi, yhang lé, \"Nung gu, dum dui toq râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Haú hkûn, Mahtaq gi, \"Haû jihtûm buinyì má dum dui toq é hkûn, yhang le dum dui toq râ nghut é lé, ngò sê lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Haú hkûn, Yesuq gi, yhang lé, \"Ngò gi, dum dui toq hkyô eq asak nghut lhê. Ngo lé lumjíng é sû gi, shi byuq kôlhang, dum duì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Asak dui nyì luî, Ngo lé lumjíng é sû ó yuq nghut kôle, hkâ-nhám le shi é hui râ a nghut. Nàng gi, dang shî lé lumjíng lhê lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Haú hkûn, yhang gi, \"Yhumsîng ê, ngò lumjíng lhê. Nàng gi, haû mingkan má jé lé lô râ nghut é, Garai Gasâng é Yhangzo, Hkrisduq nghut é lé, ngò lumjíng lhê.\" ga, Yhang lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yhang gi, haû su ga taî é htâng má, taû ló mù, yhanggu Mariq lé, tsik za wut yù luî, \"Haû Sará jé tô ri; Yhang gi, nang lé myî nyi ri.\" ga taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariq gi, haû lé wó gyo jáng, hân za toq mù, Yesuq chyáng ê bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Haú u lé, Yesuq gi, haú wâ hkaû má a wang ló shî e za, Mahtaq eq huî é jowò má ru nyi tô ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Haû yhúmhkaû má, Mariq lé nhik tîng nyi é Yudaq byu pé gi, yhang hân za toq luî, htoq ló é lé myàng kôjáng, yhang, lup má ê ngaû râ dâ lhê abe ga, myit yù kômù, yhang htâng châng e ló bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariq gi, Yesuq nyi tô é jang má jé mù, Yhang lé myàng jáng, Yhâng é hkyî wang má ngóm gop to luî, \"Yhumsîng ê, Nàng, shî má nyi tô é ru nghut le gi, ngá gu shi byuq râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuq gi, Mariq ngaù nyi é lé le, haû yhang eq rahá lé lo é Yudaq byu pé ngau nyì kô é lé le, myàng jáng, Yhâng é myit má gyai yhang hkâm zo wuî é eq myit wui myit hke dut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Haû mù, Yhang gi, \"Yhang lé, hkâmá tô tô akô lhú?\" ga myi jáng, yhangmoq gi, \"Yhumsîng ê, lé wú wú aq.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuq gi, ngaù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Haû mù, haû Yudaq byu pé gi, \"Wú keq, Yhang gi, Lazaruq lé, haû-í yhang chyit ri-nhung!\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nghut kôlhang, ra-am gi, \"Haû myoqjit sû lé, myoq wó lhoq myâng byî é Sû gi, shí yuq lé le, a shî lo shoq a wó kut é lhú?\" ga taí bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesuq gi, Yhâng é myit má radàm dum gyai yhang hkâm zo wuî é èq, lup má lé jé ri. Lup haû gi, luqhkyûng dong nghut luî, luqgok rachâm èq chî tô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Haû mù, Yhang gi, \"Luqgok haû lé yu pyám keq.\" ga taî ri. Haú hkûn, haû shi byuq su é yhângnhá Mahtaq gi, \"Yhumsîng ê, yhang lé, haú má tô tô é myi nyí lháng nghut bê yanmai, ahkuî gi, bup nàm berâ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Haû mù, Yesuq gi, \"Nàng, lumjíng é nghut le gi, haû Garai Gasâng é hpungwup shingkang lé, wó myâng râ nghut lhê nghû, Ngò, nang lé taî kyô wú bê a nghut lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Haû mù luî, yhangmoq gi, luqgok haû lé yu pyâm akô. Hau htâng, Yesuq gi, mauhkûng shut tu wú luî, \"Âwa ê, Nàng, Ngá é dang lé gyo byî é yanmai, Ngò, Nang lé jeju hkya-ôn lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nàng gi, hkâ-nhám le, Ngá é dang lé gyo byî nyi é lé, Ngò sê lhê; nghut kôlhang, Nàng, Ngo lé nhang kat é hkyô lé, shî má yap tô é bang lumjíng kó sháng gaq nghû, yhangmoq é matú, Ngò, isu nghû taî é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yhang gi, haû su ga taí luî, \"Lazaruq ê, htoq lô aq.\" ga htê mó èq wut kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Haú hkûn, haû shi byuq bê sû gi, yhâng é loq hkyî pé má pân èq htup yup to gû eq, yhâng é myoqdong má hpajet èq htup to gù htoq lo ri. Haû mù, Yesuq gi, yhangmoq lé, \"Yhang lé hpyi pyám byi mù, nhang kat keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Haû mù luî, Mariq chyáng lé kûn é Yudaq byu pé myo myo gi, Yesuq kut é hkyô lé myàng jáng, Yesuq lé lumjíng bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nghut kôlhang, yhangmoq chyáng mâ é ra-am gi, haû Hparishe pê chyáng ló mù, Yesuq kut é hkyô lé, ló taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Haû mù, haû hkyangjong agyi pé eq Hparishe pé gi, Yudaq byìn tú wapdoq zuphpong lé ji tsîng to mù, \"Byù shí yuq gi, limik kumlhá myo myo kut shit nyi ri. Nga-nhúng, hkâsu kut le gè râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nga-nhúng, Yhang lé haû su ru kut nyî nhang é nghut jáng, yuq hkangmó gi, Yhang lé lumjíng kó râ nghut lhê; haú hkûn, Romaq byu pé gi, jé lé mù, nga-nhûng é jowò eq nga-nhûng é byuhú lé, lé lhoq htên pyám kó râ nghut lhê.\" ga taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Haú hkûn, yhangmoq chyáng mâ é, haú zân má hkyangjong mó nghut nyi é sû, Kayahpaq gi, yhangmoq lé, \"Nungmoq gi, haî lháng a sé kó nghut ri-nhung! ");
INSERT INTO atbNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Haû byuhú gón htên byoq byuq râ htoq má, byuhú hau é matú, byù rayuq shî hkâm byi le gi, nungmoq é matú je gè râ hkyô lé, nungmoq, a myit jé kó nghut ri.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yhang haû su ga taî é gi, yhumsing myit dông a nghut e za, haú zân má, yhang gi, hkyangjong mó nghut é eq rajung za, haû Yudaq byuhû é matú, Yesuq shî hkám byi râ nghut é hkyô lé le, ");
INSERT INTO atbNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","byuhú hau é matú baú a nghut e za, haû byo myín tô é, Garai Gasâng é yhangzô pé lé, shuî tsîng yù mù, rading ralhum za dut nhâng râ matú, shî hkám byi râ nghut é hkyô lé le, myiqhtoi dang taî é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Haú nyí mai, yhangmoq gi, Yesuq lé sat râ matú chôm da bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hau é yanmai, Yesuq gi, Yudaq byu pê gyoro má, de de a sô shit wún e za, haû mai htoq luî, haû yoso eq chyâng lhûm é mau mâ é, Ehprim gâ é wà má ê mù, Yhâng é chángzô pé eq rahá nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Haû Yudaq byu pê é Lhoqlhai Poî jé râ za nghut é hkûn, byù myo myo gi, Lhoqlhai Poî a jé shi má, lhoq san lhoq yúng hking dông yhumsing gùng lé lhoq sân-yúng yû râ matú, yosô wà pé mai, Yerusalem wà mó shut doq ló bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Haû mù, yhangmoq gi, Yesuq lé ho nyì kô é nghut luî, haû noqkuq yhûm wàng má yap to uchyang, rayuq eq rayuq, \"Nungmoq, hkâsu wó myit akô lhú? Yhang gi, Poî má a lé lô râ gâ lhê lhà?\" ga myî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nghut kôlhang, haû hkyangjong agyi pé eq Hparishe pé gi, Yesuq lé wó chyup yû râ matú, Yesuq hkâmá nyi é lé, sê é sû ó yuq nghut kôle, yhangmoq lé lo shit kyo râ lhê ga dangmó hkyó tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Haû Lhoqlhai Poî jé râ hkyuq nyí râ ashî hkûn, Yesuq gi, Yhâng èq shi é mai lhoq dui toq yu é sû, Lazaruq nyi é Behtani wà má ló jé ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Haû má, Yesuq lé hkunggâ é dông myinzang byi tsô akô; Mahtaq gi, zoshuq jaú ri; Lazaruq gi, haû Yesuq eq rahá siboî má zô zung nyì bang mâ é rayuq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Haú hkûn, Mariq gi, haû nardu amyit mai za saî yu é, gyai hpaû é namngón-xû raxe í rûng kô yu lé mù, Yesuq é hkyî má hut gyun byi luî, yhâng é uxam èq sùt byî ri. Haû mù, yhûm haû gi, namngón-xû shôm byíng to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nghut kôlhang, Yesuq lé ap pyám râ nghut é, Yhâng é chángzo rayuq nghut sû, Yudaq Iskarut gi, ");
INSERT INTO atbNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","\"Haû myùng bang lé byî pyám râ matú, haû namngón-xû lé denari sum sho èq haî mù a ûng pyâm é lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yhang haû su ga taî é gi, myùng bang lé chiq byî é yanmai taî é a nghut, yhang gi, ngùn htûng chûng sû nghut luî, haú má kat tô é ngùn lé, yhumsing é matú lhaq yu chûng chûng kut é, hkau sû nghut é yanmai taî é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesuq gi, \"Nghut shang gaq; yhang gi, Ngo lé myhup yhum râ buinyi é matú, namngón-xû shî lé hkong to byî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Haû myùng bang gi, nungmoq eq rahá hkâ-nhám le nyì râ nghut lhê; nghut kôlhang, Ngò gi, nungmoq eq rahá ayang nyi nyì râ sû a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Haú u lé, Yudaq byu pé ajùm ayò gi, haú má Yesuq nyi é lé sé kôluî, lé lo akô; haú bang gi, Yesuq é yanmai za lé kô é a nghut, haû Yhâng èq shî bê mai lhoq dui toq yu é Lazaruq lé, lé myâng naù kô é yanmai le nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Haû mù, haû hkyangjong agyi pé gi, Lazaruq lé le, sat pyám râ matú chôm hpyê lhûm akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Hkâsu mù gâ le, yhâng é yanmai, haû Yudaq byu pé myo myo gi, Yesuq chyáng lhing ló kômù, Yhang lé lumjíng bûm kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hau htang nyí, haû Poî má lé jé é byù moq mó gi, Yerusalem wà mó shut Yesuq jé doq ló é hkyô lé, wó gyô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Haû mù, yhangmoq gi, byùm-haq pé yu chûng mù, Yhang lé ê tê uchyang, \"Hosana! Haû Yhumsing é myìng mai jé lé lô Sû gi, hkungsô wó nyî sháng gaq ô! Haû Israelaq byu pê é Hkohkâm gi, hkungsô wó nyî sháng gaq!\" ga, taî garû bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Haú hkûn, Yesuq gi, logúng zo radu lé myàng luî, doq jî ri; ");
INSERT INTO atbNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","haû gi, \"Zi-un byizo ê, hkâgyuq; wú keq, nungmoq é hkohkâm gi, logúng zo má ji mù lé lo nyi ri.\" ga, kâ tô é eq rajung za nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Haú pé banshoq lé, Yhâng é chángzô pé gi, sâng-hi lé a sê gyo kó; nghut kôlhang, Yesuq gi, hpungwup shingkang dan hu huî é htâng má za sheq, haú pé gi, Yhang eq séng luî kâ tô é hkyô lé le, haû eq rajung za, Yhang lé, yhangmoq mai kut bê hkyô lé le, bûn sê kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Haû Yesuq gi, lup hkaû mâ é Lazaruq lé wut luî, shi é mai lhoq dui toq yu é hkûn, Yhang eq rahá nghut é shiwa hpúng gi, haú hkyô lé, saksé hkám byî nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Haû mù, byù myo myo gi, Yesuq tûn shit é limik kumlhá hau é hkyô lé, wó gyo kô é yanmai, Yhang lé hui râ matú htoq e akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hau é yanmai, haû Hparishe pé gi, \"Wú keq, nga-nhúng, hkâsu yhang a ge kut lo nhung! Haû mingkan gón gi, Yhâng htâng châng bùm bekô.\" ga, rayuq eq rayuq taî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Haú hkûn, noqkuq râ matú Poî má doq ló é bang má, Grik pé ra-am le bo tô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yhangmoq gi, Galile mau, Bet-saida wà mó mâ é Hpilip chyáng lé jé kômù, \"Âhkaú ê, ngamoq gi, Yesuq lé myàng nau ri.\" ga, dung tôngbán akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Haû mù, Hpilip gi, Andre lé, ê taî kyô ri; Andre eq yháng nhik gi, Yesuq lé, ê taî kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Haû mù, Yesuq gi, \"Haû Byu Yhangzo gi, hpungwup shingkang dan hû é hui râ matú, ahkyíng jé bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ngò, nungmoq lé teng za taí kôlé, sungsô racham gi, myigùng má gyó luî, shi byuq e za a nghut jáng, acham roq za dut nyì râ nghut lhê. Nghut kôlhang, shi byuq é nghut le gi, ashi myo myo lhoq htoq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Haû yhumsing é asak lé chyitdap é sû gi, asak sûm byuq râ nghut lhê. Mingkan shî má, haû yhumsing é asak lé a jú é sû kúm gi, ahtum abyuq é asak matú, yhumsing é asak lé wó sing to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ngo lé dojaú é sû ó yuq nghut kôle, Ngá htâng cháng râ lhê; Ngò, hkâmá nyi le, Ngá é dui-nhâng zoshâng le nyì râ nghut lhê. Ngá Wa gi, haû Ngo lé dojaú é sû lé, shigyaú râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ahkuî, Ngò, myit wuîhke nyi ri; Ngò hkâsu nghû taí râ lhi? 'Âwa ê, ahkyíng shî mai Ngo lé lhoq lhut yù laq.' nghû taí râ lhú? Nghut kôle, Ngò gi, ahkyíng shi é matú za sheq jé lé é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Âwa ê, Náng é myìng lé hpungwup shingkang dan hu nhâng aq hkoi!\" ga taî ri. Haú hkûn, \"Ngò gi, Ngá é myìng lé hpungwup shingkang dan hu nhâng bê nghut luî, dum dan hu nhâng shirâ nghut lhê.\" gâ é htê, mauhkûng mai htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Haû má nyi tô é byù moq mó gi, haû lé wó gyo kôjáng, \"Maugum gum ri.\" gâ bum akô; ra-am gi, \"Yhang lé, maumang lagyo rayuq nyo ri.\" ga taí bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Haú hkûn, Yesuq gi, \"Danghtê shî gi, Ngá é matú a nghut, nungmoq é matú ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ahkuî gi, mingkan shî lé jéyáng râ ahkyíng nghut bê; mingkan shi é zau gi, ahkuî hkat htoq pyâm é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nghut kôlhang, Ngò gi, myigùng mai tu shap kat é huî é hkûn, byù lhunglhâng bang lé, Ngá chyáng shê yù râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yhang haû su ga taî é gi, Yhang hkâsu kut shî râ nghut é hkyô lé shit é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Haú hkûn, haû byù moq mó gi, \"Haû tarâ laiká má, Hkrisduq gi, ahtum abyuq dui nyì râ nghut lhê gâ é lé sheq, ngamoq wó gyô wú é ru nghut le nhîng, 'Haû Byu Yhangzo gi, tu shap é hui ra râ nghut lhê.' nghû, Nàng hkâsu kut wó taî lhê lhú? Haû Byu Yhangzo gi, ó yuq nghut lhê lhú?\" ga, myî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Haû mù, Yesuq gi, yhangmoq lé, \"Nungmoq chyáng, haû maubó joq nyì râ ahkyíng gi, a lûm myáng lo nghut ri. Mauchut gi, nungmoq chyáng a hkyit jé sháng gaq, nungmoq chyáng, haû maubó joq nyi ashî hkûn sô nyì keq; hkâsu mù gâ le, haû mauchut má sô nyi é sû gi, yhang hká shut e ló nyi é lé, a sé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nungmoq gi, maubó é yhangzô pé wó dut kó sháng gaq, haû maubó joq nyi ashî hkûn, haû lé lumjíng keq.\" ga taî ri. Yesuq gi, dang haû ban taí jáng, yhangmoq chyáng mai htoq ló luî, haq byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuq gi, yhangmoq é hí má, limik kumlhá haú pé banshoq kut shit kôlhang, yhangmoq gi, Yhang lé a lumjíng shi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Haû gi, \"Yhumsîng ê, nga-nhûng é danglù lé, ó yuq wá lumjíng byî wú é lhú? Haû Yhumsing é loq gi, ó yuq lé htoq shit wú é lhú?\" ga, myiqhtoi Esai-aq taî tô é dang lo dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yhangmoq a wó lumjíng kô é hkyô gi, Esai-aq taî é dang má, ");
INSERT INTO atbNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"Yhang gi, yhangmoq é myoqjí lé lhoq chit byi luî, yhangmoq é i-myit lé lhoq htan to byi bê nghut ri; haû mù, yhangmoq gi, myoqjí èq a wó myâng, i-myit èq a wó sê gyo, Ngò, yhangmoq lé yâ ge byi râ matú, a wó lhing taû lò kó dut râ nghut lhê.\" ga le bo tô é yanmai nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esai-aq gi, Yesuq é hpungwup shingkang lé myang é yanmai, Yhang eq sêng é hkyô lé, haû su ga taî é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nghut kôlhang, haû uphkâng bang myo myo lháng gi, haû u má, Yesuq lé lumjíng bum akô. Nghut kôle, yhangmoq gi, Hparishe pé èq tarajong mai lhoq htoq pyâm é hui râ lé, gyuq kô é yanmai, yhangmoq lumjíng bê hkyô lé a yín yu bùm kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hkâsu mù gâ le, yhangmoq gi, Garai Gasâng chyáng mâ é aróng lé, ô nau é htoq má, byu pê chyáng mâ é aróng lé, je ô naù kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Haû mù, Yesuq, htê mó èq taî é gi, \"Ngo lé lumjíng é sû gi, Ngo lé baú lumjíng é a nghut; haû Ngo lé nhang kat é Sû lé le, lumjíng é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ngo lé myang é sû gi, haû Ngo lé nhang kat é Sû lé le myang é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngò gi, Ngo lé lumjíng é sû ó yuq le, mauchut hkaû má a nyì sháng gaq nghû, maubó dông mingkan má lé jé é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ngò gi, Ngá é dang lé wó gyo luî, a châng é sû ó yuq lé le, jéyáng râ a nghut; hkâsu mù gâ le, Ngò gi, mingkan lé jéyáng râ matú jé lé é a nghut; haû mingkan lé hkyi yù râ matú sheq, jé lé é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ngo lé he-ngik luî Ngá é dang lé a hap yu é sû lé, jéyáng râ Sû rayuq nyi lhê; Ngò taî é danghkun haû gi, haû jihtûm buinyì má, haú yuq lé mara byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hkâsu mù gâ le, Ngò gi, Ngá é myit dông taî é a nghut; nghut kôlhang, Ngò haî taí râ eq hkâsu nghû taí râ lé gi, haû Ngo lé nhang kat é sû Îwa mai, Ngo lé hkunmó hkyô to bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Haû Yhâng é hkunmó gi, ahtum abyuq é asak nghut é lé, Ngò sê lhê. Haû mù luî, Ngò, haî taí kôlé, haû Îwa mai Ngo lé taî kyô é lé za, taî é nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Haû Lhoqlhai Poî jé râ hí má za, Yesuq gi, Yhang, mingkan shî mai Yhâng Wâ chyáng htot ló râ ahkyíng jé bê hkyô lé, sê ri. Yhang gi, mingkan má nyi é, Yhâng é byu pé lé chyitdap nyi é nghut luî, jihtûm jé shoq Yhâng é chyitdap myit lé shit râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Myinzang zô nyi bùm kô é u lé, nat Tsadán gi, Simun é yhangzo Yudaq Iskarut chyáng, Yesuq lé ap pyám râ myit kat byî to gû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuq gi, haû lhunglháng lé Îwa mai Yhâng é loq má ap byi to bê nghut é lé le, Yhang gi, Garai Gasâng chyáng mai lé é sû nghut luî, Garai Gasâng chyáng dum taû ló râ sû nghut é lé le, sê ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Haû mù, Yhang gi, zohpoq mai toq luî, Yhâng é bumó lé hkyut pyám mù, hpyidum má hpajet ralhûm èq hpyihit hit tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hau htâng, Yhang gi, jirung má uchyam hut kat mù, Yhâng é chángzô pê é hkyî chi byi luî, haû Yhâng é hpyidum má hit tô é hpajet èq sut huí byî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yhang gi, Simun Petruq chyáng jé jáng, Simun Petruq gi, \"Yhumsîng ê, Nàng gi, ngá hkyî lé chi byi râ nghut lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Haú hkûn, Yesuq gi, \"Ngò, haî kut nyi é hkyô lé, ahkuî, nàng sê gyo râ a nghut; nghut kôlhang, htâng má sê gyo râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petruq gi, \"Ngá hkyî lé, Nàng, hkâ-nhám le wó chi byi râ a nghut.\" ga taí jáng, Yesuq gi, \"Nang lé, Ngò a chi byî é nghut jáng, nàng gi, Ngò eq séng râ a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Haú hkûn, Simun Petruq gi, \"Yhumsîng ê, haû su nghut jáng gi, ngá é hkyî lé baú za a nghut, ngá é loq eq ulhum lé le chi byi laq!\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuq gi, \"Gùng chi bê sû gi, hkyî za chi jáng, ragùngdû é sanséng bê nghut ri. Nungmoq gi, sanséng bekô; nghut kôlhang, yuq hkangmó gi, sansêng é a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hkâsu mù gâ le, Yhang gi, Yhang lé ap pyám râ sû ó yuq nghut é lé, sê é yanmai, \"Nungmoq gi, sansêng é bang chyat a nghut.\" ga taî é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesuq gi, yhangmoq é hkyî lé ban chi byi jáng, Yhâng é bumó lé wut mù, Yhâng é jowò má ló dum zùng luî, yhangmoq lé myi é gi, \"Nungmoq gi, ahkuî, ngò kut byî é hkyô lé, sê gyo akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nungmoq, Ngo lé, 'Sará' ga le, 'Yhumsîng' ga le, wut kô é gi, a shut; hkâsu mù gâ le, Ngò gi, haú yuq yhang nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngò, nungmoq é Sará eq Yhumsîng nghut sû lháng, nungmoq é hkyî lé chi byî é nghut le gi, nungmoq le, rayuq eq rayuq é hkyî lé chi byî lhum râ dut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nungmoq gi, Ngò, nungmoq lé kut byî é su kut kó sháng gaq nghû, Ngò, nungmoq lé alik kut shit tô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ngò, nungmoq lé teng za taí kôlé, dui-nhâng zoshâng gi, yhumsîng htoq je kô é a nghut; lagyo gi, nhang kat é sû htoq je kô é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ahkuî, nungmoq gi, haú pé lé sé bekô nghut luî, châng kut kô é nghut jáng, hkungsô wó kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ngò gi, nungmoq banshoq bang lé lhoq ang luî taî é a nghut; Ngò hkyin yu é bang lé gi, Ngò sê lhê. Nghut kôlhang, 'Haû ngá é muk lé bo zô é sû gi, ngo lé, yhâng é hkyihtáng la-nhik èq nâng htíng râ nghut lhê.' gâ é Chyúmdang lé, lhoq dik râ matú ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Haû a dut htoq shimá, Ngò, nungmoq lé taî kyô nyi é gi, haû dut é hkûn, Ngò gi, haú Yuq nghut é lé, nungmoq wó lumjíng kó râ matú nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngò, nungmoq lé teng za taí kôlé, Ngò nhang kat é sû lé, lhom hap yu é sû ó yuq nghut kôle, Ngo lé hap yu é nghut bê; Ngo lé hap yu é sû ó yuq nghut kôle, haû Ngo lé nhang kat é Sû lé hap yu é nghut bê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuq gi, haû su ga taî é htâng má, myit wuîhke nyì mù, saksé hkâm é gi, \"Ngò, nungmoq lé teng za taí kôlé, nungmoq mâ é rayuq sû gi, Ngo lé ap pyám râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Haû mù, Yhâng é chángzô pé gi, ó yuq lé taî záng nyi é hkyô lé, rago a sé kô é yanmai, rayuq eq rayuq wú tsuq lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Haû Yesuq chyitdap é chángzo rayuq gi, Yesuq é tanghkoí nâm má leq nge zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Haû mù, Simun Petruq gi, chángzo haú yuq lé, loq lik kat mù, \"Yhang, ó yuq lé lhoq ang luî, taî nyi é hkyô lé, myi wú aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Haû mù, chángzo haû gi, Yesuq é tanghkoí má saî leq nge zung mù, \"Yhumsîng ê, haû gi, ó yuq nghut lhê lhú?\" ga, Yhang lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuq gi, \"Ngò, muk jap zo shî lé jum yù mù, byî é sû gi, haú yuq nghut lhê.\" ga tû taí luî, muk jap zo haú lé jum yù mù, Simun é yhangzo Yudaq Iskarut lé byî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudaq gi, muk haû lé yù zo kat é eq, Tsadán gi, yhâng chyáng wàng bê nghut ri. Haû mù, Yesuq gi, \"Nàng kut râ é hkyô lé, hân kut aq hkoi.\" ga yhang lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nghut kôlhang, yhang lé, Yesuq haû su ga haî mù taî é hkyô lé, zohpoq haú má nyi tô é bang gi, rayuq lháng a sê gyo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Haû Yudaq gi, ngùn zum sû nghut é yanmai, ra-am gi, haû Poî má râ é hkyô lé, ê wuî râ matú, Yesuq taî ri ga luî le, myùng bang lé rajung jung byí nhang ri ga luî le, myit yu bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudaq gi, muk haû lé lhom yù eq, htoq ló byuq bê nghut ri. Haû u gi, mauchut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Haú yuq htoq ló byuq jáng, Yesuq taî é gi, \"Ahkuî, haû Byu Yhangzo gi, hpungwup shingkang dan hû é nghut luî, Garai Gasang gi, haû Byu Yhangzô é yanmai, hpungwup shingkang dan hu bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Garai Gasang gi, haû Byu Yhangzô é yanmai, hpungwup shingkang dan hû é nghut jáng, Yhang le, Yhang má haû Zo lé hpungwup shingkang dan hu nhâng râ nghut lhê; radá dâm dan hu nhâng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ngá zo pé ê, Ngò, nungmoq eq rahá nyì râ gi, razup za ru nghut alô. Nungmoq gi, Ngo lé hô kó râ nghut lhê; nghut kôlhang, 'Ngò ló é jang má, nungmoq wó jé kó râ a nghut.' nghû, haû Yudaq byu pé lé, Ngò taî é eq rajung za, ahkuî, nungmoq lé le, Ngò taí lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ngò, nungmoq lé, hkunmó asik byi to kô lé, nungmoq yhangchang chyitdap lhum keq. Ngò, nungmoq lé chyitdap é su, nungmoq yhangchang chyitdap lhum râ dut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nungmoq yhangchang chyitdap lhum kô é nghut jáng, nungmoq gi, Ngá é chángzô pé nghut é hkyô lé, byù lhunglhâng bang sé kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Haú hkûn, Simun Petruq gi, \"Yhumsîng ê, Nàng, hká shut ló râ lhú?\" ga, Yhang lé myi jáng, Yhang gi, \"Ngò ló é jang má, nungmoq, ahkuî a wó châng kó râ nghut lhê. Nghut kôlhang, htâng má gi, nungmoq cháng ra kó râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petruq gi, \"Yhumsîng ê, haî mù luî, ahkuî ngò Náng htâng a wó châng é lhú? Ngò gi, Náng é matú, shî hkám râ rì rì nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Haû mù, Yesuq taî é gi, \"Nàng gi, gè gè yhang, Ngá é matú shî hkám râ lhú? Ngò, nàng lé teng za taí lé, woq a tûn shimá, nàng, Ngo lé sum dâm he-ngik pyám râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nungmoq é i-myit nhiklhum lé, myit wui myit hkê hkâdut nhâng kó. Garai Gasang lé lùm keq; Ngo lé le lùm keq. ");
INSERT INTO atbNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngá Wâ é yhûm má, nyì jowò myo myo joq lhê; a joq é ru nghut le gi, noq mai, Ngò, nungmoq lé taî kyo râ nghut lhê. Ngò, haú má ló é gi, nungmoq é nyì jowò ló hên láng râ matú ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ngò gi, ló mù, nungmoq é matú nyì jowò ló hen é nghut jáng, Ngò nyi é jang má nungmoq le wó nyì shoq, Ngò eq rahá nyì râ matú, Ngò dum taû lé mù, nungmoq lé, lé shuî yù râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngò ló é jang má jé é hkyô lé, nungmoq sê lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Haú hkûn, Htomaq gi, Yhang lé, \"Yhumsîng ê, Nàng hká shut ló é lé lháng, ngamoq a sê le nhîng, hkyô haû lé, ngamoq hkâsu kut wó sé râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuq gi, \"Ngò gi, hkyô nghut lhê; haû tengmán hkyô eq asak le nghut lhê. Ngò mai za a nghut jáng, ó yuq le, Îwâ chyáng wó jé é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nungmoq, gè gè yhang, Ngo lé sé kô é nghut le gi, Ngá Wa lé le, nungmoq sé kó râ nghut lhê. Ahkuî mai, nungmoq gi, Yhang lé sé kô é htoq agó, myàng le myang wú bekô nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Haú hkûn, Hpilip gi, \"Yhumsîng ê, ngamoq lé, haû Îwa tûn shit laq, haú hkûn, ngamoq nhik shî râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuq tû taî é gi, \"Hpilip ê, Ngò, nungmoq eq shî myáng lháng nyi lò bê le nhîng, nàng, Ngo lé a sé lhú? Ngo lé myang é sû gi, haû Îwa lé myàng bê nghut ri; haû nghut le nhîng, 'Ngamoq lé, haû Îwa tûn shit laq.' nghû, nàng hkâsu wó taî lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngò gi, haû Îwa má nghut nyî luî, haû Îwa gi, Ngò má nghut nyi é hkyô lé, nàng a lumjíng lhú? Ngò, nungmoq lé taî é dang haú pé gi, Ngá é myit mai taî é a nghut; haû Ngò má lúng nyi é Îwa sheq, Yhâng é mû zuî nyi é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngò gi, haû Îwa má nghut nyî luî, haû Îwa gi, Ngò má nghut nyi lhê nghû é lé lumjíng keq; haû a nghut jáng, kut shit é limik kumlhá pé dông za lháng, lumjíng keq. ");
INSERT INTO atbNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngò, nungmoq lé teng za taí kôlé, Ngo lé lumjíng é sû gi, Ngò kut é muzó lé kut râ nghut lhê. Ngò gi, haû Îwâ chyáng ló râ nghut é yanmai, haú yuq gi, hau htoq je kô é muzó pé lé lháng kut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Haû Yhangzô é yanmai, Îwâ é hpungwup shingkang wó hû ló shoq, Ngá é myìng lé lang luî, nungmoq haí jung dung kôlhang, Ngò gyo byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nungmoq gi, Ngá é myìng lé lang luî, haî dung kôlhang, Ngò gyo byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nungmoq gi, Ngo lé chyitdap kô é nghut jáng, Ngò hkyô tô é hkunmó pé lé, cháng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Haû Îwa gi, nungmoq eq ahtum abyuq nyi nyì râ nghut é, hpaqchyî byi Sû gotû rayuq, nungmoq lé byi râ matú, Ngò gi, haû Îwa lé dung râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Haú yuq gi, tengmán é Woi-nyí nghut lhê. Haû mingkan gi, Woi-nyí haû lé a myàng a sê é yanmai, Yhang lé a wó hap yu é nghut lhê. Nghut kôlhang, Yhang gi, nungmoq eq rahá nyi nyi é nghut luî, nungmoq má nyi to râ Sû nghut é yanmai, nungmoq gi, Yhang lé sê akô. ");
INSERT INTO atbNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ngò gi, nungmoq lé, chuizô pé dông pyâm to râ a nghut; nungmoq chyáng Ngò dum jé lé râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Adê myáng má, haû mingkan gi, Ngo lé a myàng lo râ nghut lhê; nghut kôlhang, nungmoq gi, Ngo lé myàng kó râ nghut lhê. Hkâsu mù gâ le, Ngò gi, asak dui nyi é nghut mù, nungmoq le duì kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ngò gi, Ngá Wâ chyáng nghut nyi é lé le, nungmoq gi, Ngò má nghut nyi é lé le, Ngò gi, nungmoq má nghut nyi é lé le, haú buinyì má, nungmoq sé kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ngá é hkunmó pé lé wó mù, châng kut é sû ó yuq nghut kôle, Ngo lé chyitdap é sû nghut ri. Ngo lé chyitdap é sû lé gi, Ngá Wa chyitdap râ nghut lhê; Ngò le, haú yuq lé chyitdap luî, Ngá gûng lé yhang, yhang lé shit râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hau htâng, (Yudaq Iskarut a nghut sû) Yudaq gi, \"Yhumsîng ê, Nàng gi, haû mingkan lé Náng gûng a shit e za, ngamoq lé shit râ nghut é gi, haî mù nghut lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Haú hkûn, Yesuq tû taí gi, \"Rayuq yuq, Ngo lé chyitdap é nghut le gi, Ngá dang lé gyo râ nghut lhê. Ngá Wa le, haú yuq lé chyitdap râ nghut luî, Ngá hpe gi, haú yuq chyáng lé mù, yhang eq rahá nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngo lé a chyitdap é sû gi, Ngá dang lé gyo râ a nghut. Nàng wó gyô é dang shí pé gi, Ngá myit mai taî é a nghut; dang haú pé gi, Ngo lé nhang kat é Sû, haû Îwâ é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ngò gi, shî pé banshoq lé, nungmoq eq rahá nyi tô ashî u lé taí bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nghut kôlhang, Ngá é myìng dông, haû Îwa nhang kat râ nghut é, hpaqchyî byi Sû nghû é, haû Chyoiyúng Woi-nyí gi, nungmoq lé, jung hkangmó mhoq byi râ eq, Ngò, nungmoq lé taî kyo bê hkyô lhunglháng, nungmoq lé lhoq pun râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ngò gi, nungmoq chyáng, nguingón hkyô tô to byi bê; Ngá é nguingón hkyô, Ngò, nungmoq lé byî é nghut lhê. Ngò gi, mingkan byî é dông, nungmoq lé byî é a nghut. Nungmoq é i-myit nhiklhum lé, myit wui myit hke é eq gyuq kyûm é hkâdut nhâng kó. ");
INSERT INTO atbNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Ngò gi, ló byuq luî, nungmoq chyáng dum taû lé râ nghut lhê.' nghû, Ngò taî é lé, nungmoq wó gyô yù bê nghut lhê. Nungmoq, Ngo lé chyitdap kô é nghut le gi, haû Îwâ chyáng Ngò ló râ nghut é hkyô lé, nungmoq gabú kó râ nghut lhê; hkâsu mù gâ le, haû Îwa gi, Ngá htoq je ko Sû nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Haû dut é hkûn, nungmoq lumjíng kó sháng gaq nghû, ahkuî, haû a dut shimá, Ngò, nungmoq lé taî kyô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ahkuî mai, Ngò gi, nungmoq lé, dang myo myo wó nyô râ a nghut lo; hkâsu mù gâ le, mingkan shi é zau gi, jé lé lo nyì bê nghut ri. Haú yuq gi, Ngo lé up râ ahkáng haî a wó é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nghut kôlhang, haû Îwa lé Ngò chyitdap é hkyô, mingkan sé sháng gaq nghû, Ngò gi, Ngá Wa hkyô tô é hkunmó eq roq za kut nyi lhê. Toq keq, e ló sháng hkoi. ");
INSERT INTO atbNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ngò gi, haû tsibyiq nuî akyîng nghut lhê; Ngá Wa gi, tsibyiq hkyâm yhumsîng nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yhang gi, ashi a zuî é akoq hkangmó lé, Ngá chyáng mai kyik pyám luî, ashi zuî é akoq hkangmó lé kúm gi, ashi je myo zui sháng gaq ga, shang pyám byî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nungmoq gi, Ngò, nungmoq lé taî é mungdang hau é yanmai, sanséng gû nghut bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngò má nyi nyì keq; Ngò le, nungmoq má nyi nyì râ nghut lhê. Akoq hkangmó gi, tsibyiq nuî má nui nyi é za a nghut jáng, yhang baú ashi wó zuî é a nghut. Haû eq rajung za, nungmoq le, Ngò má nyi nyi e za a nghut jang, ashi wó zui kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ngò gi, tsibyiq nuî nghut lhê; nungmoq gi, akoq pé nghut akô. Byù rayuq yuq, Ngò má nyi nyi é nghut luî, Ngò gi, yhang má nyi nyi é nghut jáng, haú yuq gi, ashi myo myo zui râ nghut lhê; hkâsu mù gâ le, Ngò mai gang jáng, nungmoq gi, haî le a wó kut kô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ngò má a nyi nyi é sû gi, haû dú pyâm é hui luî, kyuq shi byuq é akoq eq wuí ri; haû sû é akoq pé gi, byu pê èq guq yù mù, myihkyóm má dú kat pyâm é hui luî, nyé gyó byuq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nungmoq gi, Ngò má nyì nyì luî, Ngá é dang pé gi, nungmoq má bo nyi é nghut le gi, nungmoq ô nau é haî nghut kôlhang, dung keq; haú hkûn, nungmoq lé byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nungmoq gi, haû ashi ga-myhó zuî é dông, Ngá Wâ é hpungwup shingkang lé lhoq htoq shit é nghut luî, Ngá é chángzô pé nghut é hkyô lé tûn shit nyî bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Haû Îwa gi, Ngo lé chyitdap é su, Ngò gi, nungmoq lé chyitdap é nghut lhê. Ahkuî, Ngá é chyitdap myit má gîng nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ngò gi, Ngá Wâ é hkunmó lé châng é nghut luî, Yhâng é chyitdap myit má gîng nyi é su, Ngá é hkunmó lé, nungmoq châng nyì kô é nghut jáng, nungmoq gi, Ngá é chyitdap myit má gîng nyì kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nungmoq má Ngá é gabú hkyô joq nyì râ eq, nungmoq é gabú hkyô wó byíng jup râ matú, Ngò, nungmoq lé, dang shí pé taî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngò, nungmoq lé chyitdap é su, nungmoq yhangchang chyitdap lhum keq; haû gi, Ngá é hkunmó nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Haû yhumsing é luzúm wui é matú, yhumsing é asak ap byî pyâm é chyitdap myit htoq kô é, chyitdap myit gi, ó yuq chyáng le a bò nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ngò hkyô tô é hkunmó pé lé, nungmoq châng kut é nghut jáng, nungmoq gi, Ngá é luzúm wuî nghut bekô. ");
INSERT INTO atbNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngò gi, Ngá Wâ chyáng mai Ngò wó gyô yu é hkyô lhunglháng, nungmoq lé sé nhâng bê nghut é yanmai, nungmoq lé, dui-nhâng zoshâng wuì nghû, a wut lô e za, luzúm wuî nghû wut é nghut lhê; hkâsu mù gâ le, dui-nhâng zoshâng gi, yhâng yhumsîng hpô é muzó lé a châng sé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nungmoq, Ngo lé hkyin yu é a nghut, Ngò sheq, nungmoq lé, htoq e ló mù, gîng nyi é ashi zui râ matú hkyin masat tô é ru nghut lhê. Hau hkûn sheq, Ngá é myìng lé lang mù, haû Îwâ chyáng nungmoq haí jung dung kôle, Yhang byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nungmoq yhangchang chyitdap lhum keq; haû gi, Ngá é hkunmó nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Haû mingkan, nungmoq lé a jú é nghut jáng, Ngo lé hí a jú kut bê nghut é lé, sé nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nungmoq gi, haû mingkan eq sêng é bang nghut é nghut jáng, haû mingkan gi, yhang eq sêng é bang nungmoq lé chyitdap râ nghut lhê. Nghut kôlhang, nungmoq lé gi, Ngò, haû mingkan mai hkyin htoq yû bê nghut luî, nungmoq gi, haû mingkan eq a séng lo kô é yanmai, mingkan gi, nungmoq lé a jú é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Dui-nhâng zoshâng gi, yhâng é yhumsing htoq je kô é a nghut.' nghû, Ngò, nungmoq lé taî é dang pé lé bûn nyì keq. Ngo lé lháng, yhangmoq zing-rî yù bekô nghut le gi, nungmoq lé le, zing-ri kó râ nghut lhê. Ngò mhoqshit é hkyô lé, yhangmoq cháng kô é nghut le gi, nungmoq mhoqshit é lé le, cháng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nghut kôlhang, yhangmoq gi, Ngá é mying é yanmai, nungmoq lé haû su kut kó râ nghut lhê; hkâsu mù gâ le, haû Ngo lé nhang kat é Sû lé, yhangmoq a sé kôluî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yhangmoq lé, Ngò a lé nyo wú é nghut le gi, yhangmoq mara bò kó râ a nghut; nghut kôlhang, ahkuî gi, yhangmoq mara wó taî hkyut râ a nghut lo. ");
INSERT INTO atbNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ngo lé a jú é sû gi, Ngá Wa lé le a jú é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Haû ó yuq lháng a wó kut é muzó lé, Ngò, yhangmoq chyáng a kut é nghut le gi, yhangmoq mara bò kó râ a nghut; ahkuî kúm gi, laklaí kumlhá haú pé lé yhangmoq myang nyì kôlhang, Ngò eq Ngá Wa lé a jú kô é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Haû gi, 'Yhangmoq gi, jumgúyô má Ngo lé a jú kut akô nghut ri.' ga, yhangmoq é tarâ má kâ tô é dang lé lhoq dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Haû Îwâ chyáng mâ é, Ngò nhang kat râ nghut é, Îwa mai htoq lé lo é tengmán é Woi-nyí nghut é, haû hpaqchyî byi Sû jé lé é hkûn, Ngá é hkyô lé saksé hkám byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nungmoq le, Ngò eq rahá sâng-hi mai nyì bekô nghut é yanmai, saksé hkám byi ra kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nungmoq gi, myit lingbat jowò a joq kó sháng gaq nghû, haú pé banshoq lé, Ngò, nungmoq lé taî kyo bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yhangmoq gi, nungmoq lé, tarajong mai hkat htoq pyám kó râ nghut lhê; ó yuq nghut kôle, yhang mai nungmoq lé sat pyâm é hkûn, yhang gi, haú dông mai Garai Gasang lé dojaú nyi lhê ga myit yu é ahkyíng, gè gè yhang, jé râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yhangmoq gi, haû Îwa lé le, Ngo lé le, a sé kô é yanmai, haû su kut kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nghut kôlhang, nungmoq lé, Ngò sidiq byî é hkyô lé, ahkyíng jé jáng nungmoq bûn nyì kó sháng gaq nghû, Ngò haú hkyô taî kyô é nghut lhê. Ngò gi, nungmoq eq rahá nghut nyi é yanmai, haú hkyô lé, hí hkûn nungmoq lé a taî kyô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nghut kôlhang, ahkuî, Ngò gi, Ngo lé nhang kat Su chyáng ló râ nghut lhê. Nghut kôlhang, nungmoq ó yuq le, 'Nàng, hká shut ló râ lhú?' ga, Ngo lé a myi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ngò, nungmoq lé, haú hkyô pé taî kyô é yanmai, nungmoq é i-myit unghkaû má iyon hkyô byíng to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nghut kôlhang, Ngò, nungmoq lé teng za taí kôlé, Ngò ló byuq é gi, nungmoq é matú je gè râ hkyô ru nghut lhê. Ngò ló byuq e za a nghut jáng, haû hpaqchyî byi Sû gi, nungmoq chyáng lé râ a nghut; Ngò ló jáng sheq, Yhang lé, Ngò, nungmoq chyáng nhang kat byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yhang jé lé é hkûn, Yhang gi, haû mara wó é eq séng luî le, dingmán hkyô eq séng luî le, tarâ jéyáng hkyô eq séng luî le, haû mingkan lé tûn shit râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Haû yubak mara wó é eq séng luî ga jang, byu pé gi, Ngo lé a lumjíng kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Haû dingmán hkyô eq séng luî ga jang, Ngò gi, haû Îwâ chyáng ló râ nghut luî, nungmoq, Ngo lé a myàng lo kó râ nghut é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Haû tarâ jéyáng hkyô eq séng luî ga jang, mingkan shi é zau gi, mara byî é huî é nghut é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ngò gi, nungmoq lé taí râ hkyô myo myo wó ashî; nghut kôlhang, ahkuî, nungmoq wó hkâm kó râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nghut kôlhang, haû tengmán é Woi-nyí jé lé é hkûn, Yhang gi, tengmán hkyô lhunglháng lé shuî sé râ nghut lhê. Yhang gi, Yhâng myit dông taí râ a nghut; Yhang, wó gyô yu é hkyô lé za taí luî, dut lò râ hkyô pé lé le, nungmoq chyáng taî pyô râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yhang gi, Ngò wó é lé, yù mù, nungmoq lé taî kyô é eq sé nhang é dông, Ngá é hpungwup shingkang lé hû ló nhâng râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Haû Îwa wó é lhunglháng gi, Ngá é chyat nghut lhê. Hau é yanmai, haû Woi-nyí gi, Ngò wó é lé yù mù, nungmoq lé sé nhâng râ nghut lhê nghû, Ngò taî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Adê myáng má, nungmoq gi, Ngo lé a myàng lo kó râ nghut lhê; hau htâng, dum adê myáng má, nungmoq gi, Ngo lé myàng kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yhâng é chángzô pé ra-am gi, \"'Adê myáng má, nungmoq gi, Ngo lé a myàng lo kó râ nghut lhê; hau htâng, dum adê myáng má, nungmoq gi, Ngo lé myàng kó râ nghut lhê.' gâ é eq 'Ngò gi, Îwâ chyáng ló râ nghut é yanmai nghut lhê.' ga, Yhang taî é gi, haí jung gá nau é nghut lhê lhú?\" ga, rayuq eq rayuq myî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hau htoq agó, yhangmoq gi, \"'Adê myáng má,' gâ é gi, Yhang haí jung gá nau lhê lhú? Nga-nhúng gi, Yhang haî taí nau é lé a sê gyo.\" ga, taî lhûm bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesuq gi, yhangmoq myi naû kô é hkyô lé sê ri; haû mù, Yhang, yhangmoq lé taî é gi, \"'Adê myáng má, nungmoq gi, Ngo lé a myàng lo kó râ nghut lhê; hau htâng, dum adê myáng má, nungmoq gi, Ngo lé myàng kó râ nghut lhê.' nghû, Ngò taî é lé, haí jung gá nau lhê laq nghû, rayuq eq rayuq myi lhum nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ngò, nungmoq lé teng za taí kôlé, haû mingkan gi, gabú nyi é u lé, nungmoq gi, ngaù é eq iyon yón é hui kó râ nghut lhê. Nungmoq gi, iyon yón é hui kó râ nghut lhê; nghut kôlhang, nungmoq é iyon hkyô gi, gabú hkyô taû dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Myiwe gi, zoshâng hkû râ nghut jáng, zohkû-nò nò râ ahkyíng jé bê nghut é yanmai, myit chiq nyi ri; nghut kôlhang, zoshâng lé wó hku htoq kat é hkûn gi, mingkan htoq má zoshâng rayuq wó hku to bê nghut luî, yhang gabú é yanmai, haû no hpu é hkyô lé a bun byuq lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Haû eq rajung za, ahkuî gi, nungmoq iyon yôn é ahkyíng nghut ri; nghut kôlhang, Ngò, nungmoq lé dum huî é hkûn, nungmoq gi, gabú kó râ nghut lhê; nungmoq é gabú hkyô haû lé, nungmoq chyáng mai ó yuq èq le wó yu pyám byi râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Haú buinyì má, nungmoq gi, Ngo lé, haî le a dung lo kó râ nghut lhê. Ngò, nungmoq lé teng za taí kôlé, nungmoq gi, Ngá myîng lang luî, Ngá Wâ chyáng haî dung kôle, Yhang byi râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ahkuî jé shoq, nungmoq gi, Ngá myîng lé lang luî, haî le a dûng wú shi kó nghut ri. Dung keq, haú hkûn, nungmoq myang hap yù kó râ nghut luî, nungmoq é gabú hkyô gi, byíng jup lò râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ngò gi, nungmoq lé, dangtú dông haú pé taî kyo bê nghut lhê; nghut kôlhang, Ngò gi, dangtú a chûng lô e za, haû Îwa eq sêng é hkyô, nungmoq lé san za taî kyô é ahkyíng jé râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Haú buinyì má, nungmoq gi, Ngá é myìng lé lang luî dung kó râ nghut lhê. Ngò gi, nungmoq é matú, haû Îwâ chyáng dung byi râ nghû taî nyi é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Hkâsu mù gâ le, nungmoq gi, Ngo lé chyitdap kô é eq, Ngò gi, Îwa Garai Gasâng chyáng mai jé lé é Sû nghut é lé, nungmoq lumjíng kô é yanmai, haû Îwa yhang, nungmoq lé chyitdap é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngò gi, haû Îwâ chyáng mai htoq lé mù, mingkan má lé jé wang é nghut lhê; ahkuî, Ngò gi, mingkan mai htoq mù, haû Îwâ chyáng dum taû ló râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Haú hkûn, Yesuq é chángzô pé gi, \"Ahkuî, Nàng gi, dangtú a chûng é dông, san za taî kyô nyi é nghut bê! ");
INSERT INTO atbNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nàng gi, lhunglháng lé sê é sû nghut é lé le, Nàng lé, ó yuq èq le dangmyi myi nó a râ é hkyô lé le, ahkuî, ngamoq wó sé bê. Hau é yanmai, Nàng gi, Garai Gasâng chyáng mai lé é sû nghut é lé, ngamoq lumjíng lhê.\" ga taí bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Haú hkûn, Yesuq tû taî é gi, \"Nungmoq, ahkuî lumjíng bekô lhú? ");
INSERT INTO atbNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nghut kôlhang, nungmoq gi, lhoq pyo pyâm é hui luî, Ngo lé baú za tô pyâm to kômù, ó le ô yhûm shut ló byuq râ ahkyíng jé lo nyì bê nghut ri; ahkuî lháng jé to bê. Nghut kôlhang, Ngò gi, Ngò baú za a nghut; hkâsu mù gâ le, Ngá Wa gi, Ngò eq rahá nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nungmoq gi, Ngò má nguingón hkyô wó kó sháng gaq nghû, Ngò gi, haú hkyô pé lé taî kyô é nghut lhê. Nungmoq gi, mingkan shí má, wuîhke hkyô hui kó râ nghut lhê; nghut kôlhang, myit wum lhoq kíng keq. Ngò gi, mingkan lé ung pyám bê nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuq gi, haû su ga taî é htâng má, mauhkûng shut tu wú luî, kyûdûng é gi, \"Âwa ê, ahkyíng jé bê nghut ri; haû Nung Zo gi, Nang lé hpungwup shingkang wó hu nhâng sháng gaq, Nung Zo lé hpungwup shingkang hû ló nhâng laq ô! ");
INSERT INTO atbNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hkâsu mù gâ le, Nàng mai Yhang lé ap byi tô é bang banshoq lé, Yhang, ahtum abyuq é asak wó byi sháng gaq ga, Nàng gi, byù lhunglhâng bang lé up râ ahkáng, Yhang lé byî tô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nàng za tengmán é Garai Gasang nghut é eq Nàng nhang kat é sû Yesuq Hkrisduq lé, sê é gi, ahtum abyuq é asak nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ngò gi, Nàng, Ngo lé wùn waq nhang é muzó lé lhoq pán é dông, myidàm htoq má, Náng é hpungwup shingkang lé lhoq htoq shit bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Âwa ê, haû mingkan lháng a joq shî mai, Ngò, Nàng eq rahá chôm wó é hpungwup shingkâng èq, ahkuî, Náng é myoq hí má, Ngo lé hpungwup shingkang dan hu nhâng laq. ");
INSERT INTO atbNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mingkan mai, Nàng, Ngo lé hkyin htoq yû byî é bang lé, Ngò gi, Náng é myìng lhoq htoq shit bê nghut lhê. Yhangmoq gi, Náng é byu pé nghut bekô; Nàng gi, yhangmoq lé, Ngá é loq má ap byi bê nghut luî, yhangmoq gi, Náng é dang lé châng kut bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nàng, Ngo lé byî é lhunglháng gi, Náng chyáng mâ é nghut é lé, ahkuî, yhangmoq sé bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Hkâsu mù gâ le, Nàng, Ngo lé byi kat é mungdang pé lé, Ngò, yhangmoq lé byi bê nghut luî, yhangmoq gi, haú pé lé hap yù bekô nghut ri; Ngò gi, Náng chyáng mai lé é sû nghut é lé le, yhangmoq hkyak sê akô; Nàng, Ngo lé nhang kat é hkyô lé le, yhangmoq lumjíng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ngò gi, yhangmoq é matú kyûdung byî lhê. Ngò gi, haû mingkan byu pê é matú dung byi nyi é a nghut; Nàng, Ngo lé ap byi tô é bâng é matú sheq dung byî nyi é ru nghut lhê; hkâsu mù gâ le, yhangmoq gi, Náng é byu pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngò wó é lhunglháng gi, Náng é chyat nghut mù, Nàng wó é lhunglháng le, Ngá é chyat nghut lhê. Haû mù, Ngò gi, yhangmoq má hpungwup shingkang hû é hui bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ngò gi, Nàng chyáng lò râ nghut lhê mù, mingkan htoq má nyi nyì râ a nghut lo; nghut kôlhang, yhangmoq gi, mingkan htoq má nyi nyì shirâ nghut lhê; chyoiyúng é Âwa ê! Ngá hpe gi, ragùng za nghut é su, yhangmoq le ragùng za wó dut nyì kó sháng gaq, Nàng, Ngo lé byi é, haû Náng myìng é a-tsam èq yhangmoq lé upzúng nyì aq. ");
INSERT INTO atbNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ngò gi, yhangmoq eq rahá nghut nyi é u lé, yhangmoq lé upzúng bê nghut luî, Nàng, Ngo lé byî é myìng hau èq, yhangmoq lé rago zúng bê nghut lhê. Haû Chyúmdang lhoq dik sháng gaq ga, haú bang mâ é htên byoq hui râ sû mai lai luî, ó yuq le a byuq byuq é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ngò gi, ahkuî, Náng chyáng lò râ nghut bê; nghut kôlhang, Ngá é gabú hkyô gi, yhangmoq chyáng byíng jup sháng gaq nghû, Ngò gi, haú pé lé mingkan má taî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngò gi, yhangmoq lé, Náng é mungdang byi bê nghut lhê; haû mingkan gi, yhangmoq lé a jú nghut ri; hkâsu mù gâ le, Ngò gi, mingkan mâ é a nghut é su, yhangmoq le, mingkan mâ é a nghut kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ngò kyûdûng é gi, Nàng, yhangmoq lé mingkan mai shuî htoq yû râ matú dûng é a nghut, haû agè ashop su chyáng mai, yhangmoq lé upzúng yû râ matú sheq dûng é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ngò gi, mingkan mâ é a nghut é su, yhangmoq le, mingkan mâ é a nghut kó. ");
INSERT INTO atbNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yhangmoq lé, haû tengmán hkyo èq lhoq sân-yúng yû laq; Náng é mungdang gi, tengmán hkyô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nàng, Ngo lé, mingkan má nhang hâng kat é su, Ngò le, yhangmoq lé, mingkan má nhang hâng kat é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yhangmoq lé, tengmán hkyô má wó lhoq sân-yúng yû kó sháng gaq nghû, Ngò gi, yhangmoq é matú, yhumsing gùng lé lhoq sân-yúng yu é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ngò gi, yhangmoq é matú baú za kyûdung byî é a nghut; Yhangmoq é danglu é yanmai, Ngo lé lumjíng kó râ bâng é matú le, Ngò kyûdung byî é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Haû mù, yhangmoq banshoq bang gi, rading ralhum za dut nyì kó sháng gaq. Haû mingkan gi, Nàng, Ngo lé nhang kat é hkyô lé wó lumjíng sháng gaq; Âwa, Nàng gi, Ngò má nyi nyi mù, Ngò gi, Nàng má nyi nyi é su, yhangmoq le, ngá hpe má nyi nyi kó sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngá hpe gi, ragùng za nghut é su, yhangmoq le, rading ralhum za dut nyì kó sháng gaq nghû, Ngò gi, Nàng, Ngo lé byî é hpungwup shingkang lé, yhangmoq lé byi bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nàng, Ngo lé nhang kat bê hkyô eq Nàng, Ngo lé chyitdap é su, yhangmoq lé chyitdap é hkyô lé, haû mingkan wó sé râ matú, yhangmoq gi, gumjup shoq rading ralhum za wó dut kó sháng gaq nghû, Ngò gi, yhangmoq má nyi nyì luî, Nàng gi, Ngò má nyi nyi é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Âwa ê, haû mingkan lháng a joq shi mai, Nàng, Ngo lé chyitdap luî byi tô é hpungwup shingkang haû lé, Nàng, Ngo lé byi tô é bang, wó myàng kó râ matú le, Ngò nyi é jang má, Ngò eq rahá wó nyî kó râ matú le, Ngò ô nau ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dingmán é Âwa ê, haû mingkan gi, Nang lé a sé kôlhang, Ngò gi, Nang lé sê lhê; Nàng, Ngo lé nhang kat é hkyô lé gi, yhangmoq sé akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nàng, Ngo lé chyitdap é chyitdap myit gi, yhangmoq má wó joq nyì râ matú le, Ngò gi, yhangmoq má wó nyi nyì râ matú le, yhangmoq lé, Ngò, Nang é hkyô sé nhâng bê nghut luî, xoq mù sé nhang nyì shirâ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuq gi, haû su ga kyûdûng é htâng má, Yhâng é chángzô pé eq rahá, Kedron wuìhkung mai laî byit dap ló luî, haú hpoq má joq é hkyâm ralhum má wang e akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hkyâm haû gi, Yesuq eq Yhâng é chángzô pé lhaq hui hui kut é jowò nghut é yanmai, haû Yesuq lé ap pyám râ sû Yudaq le sê ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Haû mù, Yudaq gi, haû hkyangjong agyi pé eq Hparishe pê chyáng mai nhang kat é noqkuq yhûm zúng bang ra-am eq gyezo rajùm lé, haú jowò shut shuî wang lé lo ri. Haú bang gi, myihu, myibung eq shâm lhâm pé chung lé lo akô. ");
INSERT INTO atbNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuq gi, Yhang má dut lò râ hkyô lhunglháng lé sé gû nghut mù, htoq ê luî, yhangmoq lé, \"Nungmoq, ó yuq lé ho akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Haú hkûn, yhangmoq gi, \"Nazaret wà byù Yesuq lé ho lhê.\" ga tû taí kôjáng, Yesuq gi, \"Ngò gi, haú yuq nghut lhê.\" ga taî ri. (Yesuq lé ap pyám sû Yudaq le, yhangmoq eq rahá yap tô ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","\"Ngò gi, haú yuq nghut lhê.\" ga Yesuq taî kat é hkûn jáng, yhangmoq gi, nungzut zut mù, myigùng má lêng leq ló bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yhang gi, \"Nungmoq, ó yuq lé ho akô lhú?\" ga, yhangmoq lé dum myî kat jáng, yhangmoq gi, \"Nazaret wà byù Yesuq lé ho lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Haú hkûn, Yesuq gi, \"Ngò gi, haú yuq nghut lhê nghû, nungmoq lé taî kyo bê nghut lhê; nungmoq, Ngo lé hô kô é nghut le gi, shí bang lé ló nhang pyám keq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Haû gi, \"Nàng, Ngo lé byî tô é bang rayuq le lháng, Ngò, a lhoq hpyuq pyám.\" ga, Yhang taî tô é dang dik râ matú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Haú hkûn, Simun Petruq gi, shâm wun tô é nghut luî, shâm shê mù, haû hkyangjong mó é dui-nhâng zôshang é loqyo nohkyap lé zân hpyit kat byî ri. (Dui-nhâng zoshâng haú yuq é myìng gi, Malhku gâ ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Haû mù, Yesuq gi, Petruq lé, \"Náng é shâm lé, shambyâng má xâng pyám aq! Haû Îwa, Ngo lé byî é góm lé, Ngò a shuq é wó nyî râ lhú?\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hau htâng, gyezo haú jûm eq yhangmoq é gyezau hpó, Yudaq byu pê é mingsuwún wuî gi, Yesuq lé chyup yû mù, tuî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yhangmoq gi, haú zân má é hkyangjong mó Kayahpaq é yhâng-tsa Anna chyáng hí, Yhang lé shuî ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayahpaq gi, byu pê é matú rayuq shî hkám byî le je gè râ nghut lhê ga, haû Yudaq byu pé lé hpaqchyî byî é sû yuq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simun Petruq eq gotû chángzo rayuq gi, Yesuq htâng châng e ló akô nghut ri. Gotû chángzo haú yuq gi, hkyangjong mó lé rago sê lhê nghut mù luî, hkyangjong mó é yhumwàng hkaû shut, Yesuq é htâng má châng wang ló ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petruq kúm gi, hkúmdong shinggan má láng yap tô ri. Haû hkyangjong mó lé rago sê é sû, gotû chángzo haú yuq gi, taû htoq ló mù, hkum zúng é myiwe myhí lé taí luî, Petruq lé shuî hâng yu ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Haú hkûn, haû hkum zúng é myiwe myhí gi, Petruq lé, \"Nàng gi, haú yuq é chángzô pé mâ é rayuq a nghut lhú?\" ga myi jáng, yhang gi, \"Ngò a nghut.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Haú u lé, gyoq é yanmai, dui-nhâng zoshâng wuì eq noqkuq yhûm zúng bang gi, yhangmoq gyoq gâng râ matú myigyê èq mut tô é myihkyóm má, gyoq gang yap nyi bum akô. Petruq le, yhangmoq eq rahá gyoq gang yap tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Haú u lé, haû hkyangjong mó gi, Yesuq lé, Yhâng é chángzô pê hkyô eq Yhâng mhoqshit é hkyô eq séng luî myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Haú hkûn, Yesuq gi, \"Haû mingkan htoq má, Ngò, de de taí bê nghut lhê. Ngò gi, haû Yudaq byu pé banshoq bang chôm zîng é, tarajong pé má le, noqkuq yhûm má le, ayang mhoqshit é nghut lhê. Ngò gi, haq zaú luî taî é hkyô haî le a joq. ");
INSERT INTO atbNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nàng, haî mù Ngo lé myi lhê lhú? Haû, Ngò taî é lé wó gyô é bang lé myi aq; Ngò haî taî é hkyô lé, yhangmoq gè gè sê akô nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuq haû su ga taí jáng, haû nàm má nyi tô é noqkuq yhûm zúng sû rayuq gi, Yhang lé pyuq kat luî, \"Hkyangjong mó lé wá, Nàng, haû su nghû dang tû lhê lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Haú hkûn, Yesuq gi, \"Ngò taî shut é nghut le gi, shut é hkyô lé saksé tûn shit aq. Nghut kôlhang, Ngò gi, têng é dông ru taî le nhîng, nàng, haî mù Ngo lé pyuq lhê lhú?\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hau htâng, Anna gi, Yhang lé tuî to gù, haû hkyangjong mó Kayahpaq chyáng dé kat nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Haû Simun Petruq gyoq gang yap tô é hkûn, \"Nàng gi, Yhâng é chángzô pé mâ é rayuq a nghut lhú?\" ga, yhang lé myi kôjáng, yhang gi, \"Ngò a nghut.\" ga, dum he pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Haû Petruq èq nohkyap zân hpyit pyám byî é huí su é buinùm nghut é sû, haû hkyangjong mó é dui-nhâng zoshâng rayuq gi, yhang lé, \"Haû hkyâm má, nàng, Yhang eq rahá nghut nyi é lé, ngò a myang é su ngam lhê lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Haú hkûn, Petruq gi, xoq he pyám ri; haú u yhang, woq tûn bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hau htâng, yhangmoq gi, Yesuq lé, Kayahpaq chyáng mai, haû mauzau hpô é yhûmwàng shut shuî e ló akô. Haú u gi, napsûn noq ashî nghut ri. Yhangmoq gi, agot a-û a dut e za, htûngli dông Lhoqlhai Poî lé wó zo râ matú, yhúmhkaû má a wàng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Haû mù luî, mauzau Pilat gi, yhangmoq chyáng htoq ê mù, \"Shí yuq lé, nungmoq hai mara hûn nau akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Haú hkûn, yhangmoq gi, \"Shí yuq, a ge é muzó kut é a nghut le gi, Yhang lé, náng é loq má ngamoq lé ap byi râ a nghut.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat gi, \"Yhang lé, nungmoq yhang shuî ló mù, nungmoq é tarâ dông ló jéyáng keq.\" ga taí jáng, haû Yudaq byu pé gi, \"Nghut kôlhang, ngamoq gi, ó yuq lé sat râ ahkáng le a wó é nghut lhê.\" ga tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Haû su dut é hkyô gi, Yesuq, Yhang hká dông shî râ ga taî é dang lé lhoq dik râ matú nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Haû mù, Pilat gi, yhúmhkaû má taû wang ló mù, Yesuq lé wut yù luî, \"Nàng gi, Yudaq byu pê é hkohkâm nghut lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Haú hkûn, Yesuq gi, \"Haû gi, náng é myit dông taî é nghut lhê lhú? A nghut jáng, góbang mai, nang lé, Ngá é hkyô taî kyo luî nghut lhê lhú?\" ga taû myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat gi, \"Ngò gi, Yudaq byù nghut lhê lhú? Haû Náng é byù myû eq Náng é hkyangjong agyi pé sheq, Nang lé, ngá loq má ap byî é ru nghut lhê. Nàng gi, haî kut é nghut lhê lhú?\" ga dum myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Haú hkûn, Yesuq gi, \"Ngá é mingdán gi, mingkan shî eq a séng. Mingkan shî eq sêng é ru nghut le gi, haû Yudaq byu pé, Ngo lé a wó chyup yu lo shoq, Ngá é dui-nhâng zoshâng wuì, Ngo lé chôm hung yù kó râ nghut lhê. Nghut kôlhang, Ngá é mingdán gi, mingkan shî eq a sêng é ru nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Haû mù, Pilat gi, \"Haû jáng, Nàng gi, hkohkâm nghut bê lhú?\" ga myi jáng, Yesuq gi, \"Ngo lé, hkohkâm nghut lhê ga, nàng taî nyi é jô ri. Gè gè ga jáng, Ngò gi, hau é yanmai hku lé lo é sû nghut lhê; haû tengmán hkyô lé saksé hkám râ matú, Ngò, mingkan htoq má jé lé é nghut lhê. Haû tengmán hkyô eq sêng é sû ó yuq le, Ngá é dang lé gyô ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Haú hkûn, Pilat gi, \"Tengmán hkyô gâ é gi, haí jung lhú?\" ga myî ri. Yhang gi, haû su ga myi luî, haû Yudaq byu pê chyáng dum htoq ê mù, \"Shí yuq chyáng mara hûn râ hkyô, ngò a myàng nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nghut kôlhang, haû Lhoqlhai Poî u lé, nungmoq é matú, ngò, htóng byû rayuq nhang htoq kat byi byi kut é htûng, nungmoq wó akô. Haû mù, 'Yudaq byu pê é hkohkâm' lé, nhang htoq kat byi râ lé, nungmoq ô nau akô lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Haú hkûn, yhangmoq gi, \"Haú yuq lé a nghut! Barabaq lé sheq nhâng byi aq.\" ga, garû kat akô. Barabaq gi, damyaq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Haû mù luî, Yesuq lé lâng she yù mù, nhuq bat râ matú, Pilat hkunmó hkyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Haû gyezô pé gi, zujanmaú saî yù kôluî, Yesuq é ulhum má tsung byi kômù, Yhang lé, buhîng nè hut byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hau htâng, yhangmoq gi, Yhâng chyáng dum huî ê ê kut luî, \"Yudaq byu pê é hkohkâm ê! Chyung hîng xê hing nyì sháng gaq ô!\" ga taí kômù, Yhâng é myoqdong má pyuq byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat gi, haû Yudaq byu pê chyáng radàm dum htoq ê mù, \"Wú keq, shí yuq chyáng mara hûn râ hkyô, ngò a myang é lé nungmoq sé sháng nghû, Yhang lé, ngò nungmoq chyáng shuî htoq lé byî lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesuq gi, haû zumuq tsûng tô é eq bu nè hîng wut to mù htoq lé jáng, Pilat gi, yhangmoq lé, \"Wú keq, Yhang, shí yuq nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Haû hkyangjong agyi pé eq yhangmoq é noqkuq yhûm zúng bang gi, Yhang lé myang kat kôjáng, \"Yhang lé tapzîng má jén sat pyám aq! Yhang lé tapzîng má jén sat pyám aq!\" ga garû bum akô. Nghut kôlhang, Pilat gi, \"Nungmoq shuî yù mù, tapzîng má jén sat keq. Ngò gi, Yhâng chyáng mara hûn râ hkyô a myàng.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Haú hkûn, haû Yudaq byu pé gi, \"Ngamoq chyáng tarâ rahkat joq lhê; tarâ haú dông ga jang, Yhang gi, shî gíng bê nghut ri; hkâsu mù gâ le, Yhang gi, Garai Gasâng é Yhangzo haû nghut lhê gâ ri.\" ga xoq taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilat gi, dang haû lé wó gyo jáng, je gyô gyuq luî, ");
INSERT INTO atbNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","yhúmhkaû shut dum wang ló mù, Yesuq lé, \"Nàng, hkâmâ é sû nghut lhê lhú?\" ga myî ri. Nghut kôlhang, Yesuq gi, dang rahkun lháng a tû taí byi nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Haú hkûn, Pilat gi, \"Nàng, ngo lé a tû taí kut lhê lhú? Ngò gi, Nàng lé, wó lhoq lhut kat é eq tapzîng má wó jén sat pyâm é ahkáng wó sû nghut é lé, Nàng a sé lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuq gi, \"Nàng lé, haû ahtoq mai ahkáng byî e za a nghut le gi, nàng, Ngo lé haî kut râ a-tsam le wó râ a nghut. Haû mù luî, Ngo lé, náng é loq má ap byî é sû gi, mara je bo é nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Haú hkûn mai, Pilat gi, Yesuq lé lhoq lhut kat byi nau nyì bê nghut ri. Nghut kôlhang, haû Yudaq byu pé gi, \"Nàng, haú yuq lé nhang pyâm é nghut jáng, nàng gi, hkoséng Kehtaq é luzúm a nghut lo; yhumsing gùng lé, hkohkâm gâ é sû gi, hkoséng Kehtaq eq shai lhûm é sû nghut lhê.\" ga, ru jâng garû nyì bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Haû lé wó gyo jáng, Pilat gi, Yesuq lé shuî htoq ê mù, Hebre myíng dông Gabahta gâ é Luqgok hkâng myhang to jang nghu é jowò mâ é tarâ jéyáng tanghkuq má zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Haú u gi, Lhoqlhai Poî é matú, Hên Lajâng é Buinyì nyí-káng raxe í hkyíng nghut ri. Pilat gi, haû Yudaq byu pé lé, \"Nungmoq é hkohkâm lé wú keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nghut kôlhang, yhangmoq gi, \"Yhang lé yu pyám aq! Yhang lé yu pyám aq! Yhang lé tapzîng má jén sat pyám aq!\" ga garû bum akô. Haú hkûn, Pilat gi, \"Nungmoq é hkohkâm lé wá, ngò, tapzîng má jén sat pyám râ lhú?\" ga myi jáng, haû hkyangjong agyi pé gi, \"Haû hkoséng Kehtaq mai lai luî, gotû hkohkâm ngamoq a wó.\" ga, tû taî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hau htâng má, Pilat gi, Yesuq lé tapzîng má jén sat pyám râ matú, yhangmoq é loq má ap byî kat bê nghut ri. Haû mù luî, yhangmoq gi, Yesuq lé shuî ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuq gi, yhumsing é tapzîng lé waq mù, Hebre myíng dông Golgahta gâ é, Ugyap joq é Jowò gâ é jang má htoq jé e ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yhangmoq gi, haú má, Yesuq lé tapzîng htoq má jén tap pyám akô; Yhang eq rahá, gotû í yuq lé le, rahkyam shut rayuq kut jén to kô é nghut luî, Yesuq gi, gyoro má nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat le, masat laiká kâ yù luî, haû tapzîng htoq má tap tô ri. Haú má gi, \"YUDAQ BYU PÊ É HKOHKÂM, NAZARET WÀ BYÙ YESUQ\" gâ tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesuq lé jén tô é jowò gi, myuq eq chyâng lhûm é htoq agó, haû masat laiká gi, Hebre dông le, Latin dông le, Grik dông le, kâ tô é yanmai, haû Yudaq byu pé myo myo gi, masat laiká haû lé nghap bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Haû Yudaq byu pê é hkyangjong agyi pé gi, Pilat lé, \"'Yudaq byu pê é hkohkâm' nghû hkâká, 'Ngò gi, Yudaq byu pê é hkohkâm nghut lhê ga, Yhang taî ri.' nghû luî sheq ká aq.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Haú hkûn, Pilat gi, \"Ngò kâ é dông, ngò kâ to bê nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Haû gyezô pé gi, Yesuq lé tapzîng má jén tap pyâm é htâng má, Yhâng é mebu pé lé yù mù, myî hkyam gàm luî, rayuq rahkyam yu akô; haû ahte bu lé le, gàm râ dâ akô; nghut kôlhang, haû gi, hkyupshi a bo e za, awang mai ahpyo hpyot kut woq tô é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Haû mù, yhangmoq gi, \"Bu shî lé gi, a lâng cheq e za, ó yuq myang yù ang râ laq, hkyîn shosé she wú sháng.\" ga, rayuq eq rayuq taí lhum akô. Haû gi, \"Yhangmoq, Ngá é mebu lé chôm gam yù kó râ; Ngá é ahtê bû é matú, hkyîn shosé shê kó râ nghut lhê.\" gâ é Chyúmdang lé lhoq dik râ matú dut é nghut lhê. Haû mù, gyezô pé gi, haû su kut bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Haû Yesuq é tapzîng nàm má gi, Yhângnu, Yhângnû é yhanggu byizo eq, Klopa é yhangmyi Mariq eq Magadalaq wà mâ é Mariq pé, yap tô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuq gi, Yhang nàm má, Yhang chyitdap é chángzo eq Yhâng nu yap tô é lé myang kat jáng, Yhâng nu lé, \"Ânu ê nung zo lé wú aq.\" ga taí mù, ");
INSERT INTO atbNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","chángzo haû lé le, \"Náng nu lé wú aq.\" ga taî ri. Haú hkûn mai, chángzo haú yuq gi, Yesuq é yhângnu lé, yhâng é yhûm shut shuî ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hau htâng, Yesuq gi, ahkuî, muzó bàn bê nghut é lé sé luî, haû Chyúmdang lhoq dik râ matú, \"Ngò, wuì shit ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Haú má, tsibyiq wing chyîn rayambú joq tô ri; haû mù, yhangmoq gi, wuìmaù lé tsibyiq wing chyîn haú má jum yù luî, jàm-yang ahpyo má tuî tap mù, Yhâng é nhutwuî jé shoq yhun byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesuq gi, tsibyiq wing chyîn haú lé shuq yû mù, \"Mû bàn bê.\" ga taî ri. Yhang, haû su ga taí eq yhang, ulhum nghuq ló mù, kâng byit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Htang nyí gi, ahkyak é Bánno buinyì nghut luî, haú nyí gi, Hên Lajang Buinyì nghut ri. Haû mù, Yudaq byu pé gi, Bánno buinyì má, màng pé lé tapzîng htoq má a joq to nhâng naù kô é yanmai, hkyî pé lé bat hkyuî pyám mù, màng pé lé yù hkyô pyám nhâng râ matú, Pilat chyáng dûng tôngbán akô. ");
INSERT INTO atbNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Haû mù luî, gyezô pé gi, lé mù, Yesuq eq jén hui su nhik mâ é, rayuq é hkyî lé hí bat hkyuî pyám mù, rayuq é hkyî lé dum bat hkyuî pyám akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nghut kôlhang, yhangmoq gi, Yesuq chyáng jé é hkûn, Yhang shi to láng bê nghut é lé myàng kômù, Yhâng é hkyî lé a bat hkyui byi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nghut kôlhang, gyezo rayuq gi, Yesuq é namcham má lham èq htaû kat byi jáng, radá dâm sui eq wuì yui htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Haû lé myàng é sû gi, saksé hkám byî ri; yhâng saksé hkâm é hkyô gi, tengmán ri. Haû yhang taî kyô é hkyô gi, têng é lé, yhang sé mù, nungmoq le wó lumjíng kó sháng gaq ga, saksé hkám byî é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Haú hkyô pé dut é gi, \"Yhâng é showui rahkat lháng a lhoq hkyui râ nghut lhê.\" gâ é Chyúmdang haû lhoq dik râ matú nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chyúmdang gotû ralhum má le, \"Yhangmoq èq htau htông é sû lé, yhangmoq tu wú kó râ nghut lhê.\" gâ é bo tô ashî nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hau htâng, Yesuq é chángzo dut nyi é Aramahti myuq byû Yosep gi, haû Yudaq byu pé lé gyuq é yanmai, tsik za Pilat chyáng Yesuq é gungsôm lé, lé dûng ri. Pilat èq ahkáng byî kat jáng, yhang gi, gungsôm haû lé, lé yu ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yhang gi, hí hkûn, myín lé, Yesuq lé ê huî é sû, Nikodema eq rahá lé é nghut ri; Nikodema gi, mura eq achyo nyhô tô é namngón jung sum xê joí kô yu lé ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yhangnhik gi, Yesuq é gungsôm lé yù mù, Yudaq byu pê é màng yhum htûng eq rajung za, namngón jung eq rahá, pán yúng èq htup yup to byî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Haû Yesuq lé tapzîng má jén sat pyâm é jowò nàm má, hkyâm ralhum joq ri; ó yuq lé le a lheq wú shî é, lup sik ralhum hkyâm hkaû má joq tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Haú nyí gi, Yudaq byu pê é Hên Lajang Buinyì nghut é yanmai le, lup haû le chyâng é yanmai le, yhangnhik gi, Yesuq lé, haú má ê lheq tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bánno buinyì htâng, napsûn noq le mau a bó shimá, Magadalaq wà mâ é Mariq gi, haû lup má ê jé le, lup hkum mâ é luqlong huî hpyuq to láng é lé myang ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Haû mù, yhang gi, Simun Petruq eq Yesuq chyitdap é chángzo góyuq chyáng din jé ló mù, \"Haû Yhumsîng lé, lup mai yu htoq ló byuq bekô; hkâmá ê kat to kô é lé, ngamoq a sé.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Haû mù, Petruq eq chángzo haû gi, lup shut e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yhangnhik í yuq é din akô; nghut kôlhang, chángzo haû gi, Petruq htoq má wó dîn luî, lup má hí din jé e ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Haû mù, yhang gi, ahkaû shut ngóm wú kat é hkûn, haû pán yúng htui leq tô é lé myang ri; nghut kôlhang, yhang gi, a wang ê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hau htâng, Simun Petruq gi, châng jé luî, lup hkaû shut wang e ri; haú hkûn, yhang gi, haú má pán yúng htui joq tô é lé le, ");
INSERT INTO atbNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","haû Yesuq é ulhum má htup é panchoq lé le, myang ri. Panchoq haû gi, pán yúng htui eq rahá a nghut e za htuî jup leq tô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Haû lup má hí jé é chángzo le, ahkaû má wang ê luî, myàng jáng, lumjíng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Yesuq gi, shi é mai dum dui toq lô râ nghut lhê ga bo tô é Chyúmdang lé, yhangnhik gi, a sê gyo shi kó nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hau htâng, haû chángzô nhik gi, yhûm taû ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nghut kôlhang, Mariq gi, lup shinggan má ngau yap tô ri. Yhang gi, ngaù uchyang lup hkaû má ngóm wú kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Haú hkûn, yhang gi, Yesuq é gungsôm lheq tô é jang má, hpyu é mebu wut é maumang lagyo í yuq hkyî htâng shut rayuq, umhtúng shut rayuq, zung to kô é lé, myang ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yhangnhik gi, \"Myiwe myhí ê, nàng, haî mù ngau nyi lhê lhú?\" ga myi kôjáng, yhang gi, \"Ngá é Yhumsîng lé yù ló hpyuq kôluî, Yhang lé hkâmá ló lheq to kô é lé, ngò a sê é yanmai nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Haû su ga luî, yhang, lhing wú kat é hkûn, Yesuq yap tô é lé myàng kôlhang, Yesuq nghut é lé yhang a wú sé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuq gi, \"Myiwe myhí ê, nàng, haî mù ngau nyi lhê lhú? Nàng gi, ó yuq lé ho wún lhê lhú?\" ga myi jáng, yhang gi, hkyâm saí zo sû su ngam pyám mù, \"Sará ê, nàng, Yhang lé waq htot pyâm é nghut le gi, hkâmá ê lheq tô é, ngo lé taî kyo laq, ngò, Yhang lé yu ló râ.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Haú hkûn, Yesuq gi, yhang lé, \"Mariq ê\" ga wut kat ri. Mariq gi, Yhâng shut lhîng mù, Hebre myíng dông, \"Raboni!\" ga wut kat ri. (Haû gi, \"Sará ê\" gâ é lichyúm nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuq gi, \"Ngo lé hkâzáng shi; hkâsu mù gâ le, Ngò gi, haû Îwâ chyáng a taû doq ló shî é nghut lhê. Nàng gi, Ngá é gumang wui chyáng ló mù, yhangmoq lé, 'Ngò gi, Ngá Wa eq nungmoq é Yhângwa, Ngá é Garai Gasang eq nungmoq é Garai Gasang nghut su chyáng doq ló zó nghut lhê.' gâ ri nghû, ló taî kyo aq.\" ga, yhang lé taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magadalaq wà mâ é Mariq gi, chángzô pê chyáng ló mù, \"Yhumsîng lé, ngò myàng bê!\" ga taí luî, yhang lé shit kat é pé lé, taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Haú nyí, Bánno buinyì htang myìn lé, haû chángzô pé gi, Yudaq byu pé lé gyuq kô é yanmai, hkum tsing myhî pyám mù, zîng tô bum kô é u lé, Yesuq gi, lé jé mù, yhangmoq é agùng má yap to luî, \"Nungmoq nguingón yuqyo nyì sháng gaq!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yhang gi, haû su ga taî é htâng má, yhangmoq lé, Yhâng é loq pé eq namcham lé tûn shit ri. Chángzô pé gi, haû Yhumsîng lé myàng kôjáng, gyai gabú bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuq gi, \"Nungmoq nguingón yuqyo nyì sháng gaq! Haû Îwa gi, Ngo lé nhang kat é su, Ngò gi, ahkuî, nungmoq lé nhang kat é nghut lhê.\" ga dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Haû su ga taí mù, Yhang gi, yhangmoq é ahtoq má soq mut luî, \"Haû Chyoiyúng Woi-nyí lé hap yù keq. ");
INSERT INTO atbNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ó yuq é mara pé lé nghut kôle, nungmoq hkyut byî é nghut jáng, mara haú pé gi, hkyut pyám byî é hui râ nghut lhê; nungmoq a hkyut byî é nghut jáng, mara haú pé gi, hkyut pyâm é hui râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Haû chángzo raxe í yuq má bo é, Zozûm le gâ é Htomaq gi, Yesuq lé jé é hkûn, haû chángzô pé eq rahá a nyi to nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Haû mù luî, gotû chángzô pé gi, yhang lé, \"Haû Yhumsîng lé, ngamoq myàng bê.\" ga taî kyô akô. Nghut kôlhang, yhang gi, yhangmoq lé, \"Ngò gi, Yhâng é loq pé mâ é shamtoq zuhkô lé myàng mù, ngá é loqnyhuî èq joí wú é eq, Yhâng é namcham má, ngá é loq èq myang lap wú é za a nghut jáng, haû lé ngò lumjíng râ a nghut.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Rabat myáng jáng, chángzô pé gi, haû yhúmhkaû má dum nyi tô akô; Htomaq le, yhangmoq eq rahá nghut nyi ri. Haû hkum pé myhî to kôlhang, Yesuq gi, lé jé mù, yhangmoq é agùng má yap to luî, \"Nungmoq nguingón yuqyo nyì sháng gaq!\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hau htâng, Yhang gi, Htomaq lé, \"Náng é loqnyhui, shî má lé joí mù, Ngá é loq pé lé wú aq. Náng é loq lhâm kat mù, Ngá é namcham má lé lap wú aq. A lùm hkâkut, lumjíng nyì aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Haú hkûn, Htomaq gi, \"Ngá é Yhumsîng, ngá é Garai Gasang ê!\" ga Yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesuq gi, yhang lé, \"Nàng gi, Ngo lé myang é yanmai, lumjíng é a nghut lhú? A myàng kôlhang, lumjíng é bang gi, hkungsô wó nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Laiká buk shî má a kâ tô é limik kumlhá pé gotû myo myo lé le, Yesuq gi, Yhâng é chángzô pê hí má kut shit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nghut kôlhang, Yesuq gi, Garai Gasâng é Yhangzo Hkrisduq nghut é lé, nungmoq wó lumjíng râ matú eq, lumjíng é yanmai, nungmoq Yhâng é myìng má asak wó kó râ matú, shí hkyô pé lé kâ tô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hau htâng má, Yesuq gi, Tiberi nhông yàm má, Yhâng é chángzô pé lé dum htoq shit ri. Yhang htoq shit é hkyô gi, a-ô mâ é dông nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simun Petruq, Zozûm le gâ é Htomaq, Galile mau Hkanaq wà mó mâ é Nahtanelaq, Zebedi é yhangzo nhik eq gotû chángzo í yuq pé gi, rahá nyì to bum akô. ");
INSERT INTO atbNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Haú hkûn, Simun Petruq gi, yhangmoq lé, \"Ngò gi, ngozo kóng ê râ.\" ga taí jáng, yhangmoq gi, \"Ngamoq le châng lé râ.\" ga taî akô. Haû mù luî, yhangmoq gi, htoq ê mù, haû lhaî má wàng bekô nghut ri; nghut kôlhang, haú myîn, radu lháng a wó kóng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Htang napkyó maubó lo é hkûn, Yesuq gi, wuiyàm má yap tô ri; nghut kôlhang, haû chángzô pé gi, Yesuq nghut é lé a wú sé kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuq gi, yhangmoq lé, \"Luzúm wuì ê, nungmoq, ngozo wó akô lhú?\" ga, wut myi kat jáng, yhangmoq gi, \"A wó.\" ga tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Haú hkûn, Yhang gi, \"Nungmoq é gùn lé, haû lhai é loqyo hkyam shut dú hkyô kat keq; haû jáng, nungmoq wó kông yù kó râ nghut lhê.\" ga taî ri. Haû mù, yhangmoq gi, gùn dú hkyô kat é hkûn, ngozo lûm myô é yanmai, haû gùn lé lháng a wó lâng yù lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Haû mù luî, haû Yesuq chyitdap é chángzo gi, Petruq lé, \"Yhumsîng ru nghut ri.\" ga taî ri. Simun Petruq gi, \"Yhumsîng ru nghut ri.\" gâ é lé wó gyo eq yhang, yhang gi, mebu hkyut pyâm tô é yanmai, buhîng mó lé, yhâng é gùng má baíyup yù mù, wuì hkaû má byam wang ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Haû chángzo góbang gi, wuiyàm eq ngo xê làm kô za wê é yanmai, ngozo byíng tô é gùn lé, wuiyàm shut lhaî mai she jé lo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yhangmoq gi, wuiyàm má jé dap ló kô é hkûn, myigye gyúng é myihkyóm htoq má ngozo nyhîn tô é lé le, muk ratsuí joq tô é lé le, myang akô. ");
INSERT INTO atbNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuq gi, yhangmoq lé, \"Haû, ahkuî za nungmoq wó kông yu é ngozo, ra-am yù lé keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Haû mù, Simun Petruq gi, lhaî má doq ji luî, kô é ngozo rasho ngó xe sûm du yhang bo é gùn lé, dùng yàm má she htoq tô ri. Ngozo haû myhó myo kôlhang, gùn gi, a jeq nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuq gi, yhangmoq lé, \"Napzang lé zo keq.\" ga taî ri. Chángzô pé gi, Yhang, haû Yhumsîng nghut é lé sé kô é yanmai, ó yuq lháng, \"Nàng, ó yuq nghut lhê?\" ga, a wám myi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuq gi, lé mù, muk lé ê yù luî, yhangmoq lé byî ri; ngozo lé le, haû su kut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuq gi, shi é mai lhoq dui toq yû huî é htâng, Yhâng é chángzô pé lé htoq shit é má, shî gi, sum dâm nghû râ dàm nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yhangmoq bàn zô bùm kô é htâng má, Yesuq gi, Simun Petruq lé, \"Yohan é yhangzo Simun ê, nàng gi, shí bang htoq má, Ngo lé teng za je chyitdap lhê lhú?\" ga myi jáng, yhang gi, \"Nghut lhê; Yhumsîng ê, ngò, Nàng lé chyitdap é hkyô lé, Nàng sê lhê.\" ga tû taî ri. Haú hkûn, Yesuq gi, \"Ngá é sau zô pé lé, baú aq.\" ga, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hau htâng, Yesuq gi, \"Yohan é yhangzo Simun ê, nàng gi, Ngo lé teng za chyitdap lhê lhú?\" ga dum myi jáng, yhang gi, \"Nghut lhê; Yhumsîng ê, ngò, Nàng lé chyitdap é hkyô lé, Nàng sê lhê.\" ga tû taî ri. Haú hkûn, Yesuq gi, \"Ngá é sau pé lé, rém aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dum radàm, Yesuq gi, yhang lé, \"Yohan é yhangzo Simun ê, nàng gi, Ngo lé chyit lhê lhú?\" ga myî ri. Haú hkûn, Petruq gi, \"Nàng gi, ngo lé chyitdap lhê lhú?\" ga, yhang lé Yesuq èq súm dam dàm taî é yanmai, yhâng myit nò luî, \"Yhumsîng ê, Nàng gi, lhunglháng lé sê lhê; ngò, Nàng lé chyitdap é hkyô lé, Nàng sê lhê.\" ga taî ri. Haú hkûn, Yesuq gi, \"Ngá é sau pé lé, baú aq. ");
INSERT INTO atbNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ngò, nàng lé teng za taí lé, nàng, zorâm nghut é hkûn gi, yhumsing gùng yhumsîng hpyihit baíyup yù mù, ê nau é jowò hkangmó má wó ê é nghut lhê; nghut kôlhang, nàng mang jáng gi, loq í loq lham luî, nang lé góyuq èq hpyihit baíyup byi mù, nàng a ê nau é jowò shut shuî ê râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesuq haû su ga taî é gi, haû Petruq, hkâsu kut shi é dông mai, Garai Gasâng é hpungwup shingkang lé dan hu nhâng râ nghut é lé, taí nau é nghut ri.) Hau htâng, Yesuq gi, yhang lé, \"Ngá htâng cháng aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Haú hkûn, Petruq gi, lhîng wú kat le, haû Yesuq chyitdap é chángzo, yhangmoq htâng châng wún é lé myàng ri. Chángzo haû gi, hí hkûn, myinzang zô é u lé, Yesuq chyáng leq ngè mù, \"Yhumsîng ê, Nang lé ap pyám râ sû gi, ó yuq lhú?\" ga, myi wú é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petruq gi, haú yuq lé myàng jáng, Yesuq lé, \"Yhumsîng ê, shí yuq gi, hkâsu dut râ lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuq gi, \"Ngò jé lé é hkûn jé shoq, Ngò, yhang lé dui nyì nhâng nau é nghut le gi, nàng eq haî sêng lhê lhú? Nàng gi, Ngá htâng cháng aq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dang hau é yanmai, chángzo haú yuq a shî râ nghut lhê gâ é danglám gi, haû gumang wui chyáng byo myín to bê nghut ri. Nghut kôlhang, Yesuq gi, haú yuq a shî râ hkyô lé taî é a nghut, \"Ngò jé lé é hkûn jé shoq, Ngò, yhang lé dui nyì nhâng nau é nghut le gi, nàng eq haî sêng lhê lhú?\" ga, taî é ru nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Shí pé lé saksé hkám mù, shí pé lé kâ tô é sû gi, chángzo haú yuq nghut lhê. Yhâng é saksé gi, têng é lé, ngamoq sê lhê. ");
INSERT INTO atbNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuq gi, gotû muzó myo myo le kut ashî nghut ri. Muzó haú pé lhum jup lé, kâ htoq yu é ru nghut le gi, kâ tô é laiká buk haú pé gi, mingkan gón má lháng ngo râ a nghut nghû, ngò wó myit ri.");
INSERT INTO atbNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Htohpiluq ê, Yesuq yhang hkyin yu tô é lagyô pé lé, Chyoiyúng Woi-nyí wum-o èq dang ban pying tô é htâng má, Garai Gasang yhang lé mauhkûng shut shuî yu é buinyì jé shoq, ");
INSERT INTO atbNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yhang kut shit é hkyô pé eq, mhoqshit é hkyô pé banshoq lé, hí lhê é laiká buk má ngò kâ kat bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesuq gi, shî hkâm é htâng má, Yhang dui toq bê hkyô lé, lumgíng é saksé myo myô èq yhangmoq lé tûn shit mù, buinyì myi xê nyí gyoro má yhangmoq chyáng lé htoq shit shit kut luî, Garai Gasâng é mingdán hkyô lé hko kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yhang, yhangmoq eq rahá zup tô é hkûn, hkunmó hkyô é gi, \"Nungmoq gi, Yerusalem wà mó mai a htoq é za, ngá chyáng mai wó gyô yu é, ngá wâ ê danggidiq byî tô é chyunghuq lé láng nyî keq. ");
INSERT INTO atbNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Hkâsu mù gâ le, Yohan gi, wui èq wui-myhup hkám byî é nghut lhê; nghut kôlhang, nungmoq kúm gi, buinyì hkâ-myháng a myáng má, Chyoiyúng Woi-nyí mai baptisma wó hkam yù kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lagyô pé gi, Yhang eq rahá chôm zup míng tô é hkûn, Yhang lé, \"Yhumsîng ê, nàng, haû Israelaq byu pé lé mingdán dum xuq byi râ gi, ahkuî yhang nghut bê lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesuq gi, \"Âwa gi, Yhâng é ahkáng ayá èq kut to bê é ahkyíng yam-yoq pé lé, nungmoq sé nó a ra. ");
INSERT INTO atbNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nghut kôlhang, Chyoiyúng Woi-nyí nungmoq chyáng jé jáng, nungmoq gi, wum-o a-tsam wó yû mù luî, Yerusalem wà mó eq Yuda mau banshoq, Samariq mau eq maumyî htáng shoq, ngá é saksê pé dut kó râ nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Dang haû ban taî é htâng má, yhangmoq wú nyi le, Yhang gi, mauhkûng shut shuî yu é hui mù, yhangmoq hí mai Yhang lé a myàng loshoq, mhut èq htup ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesuq doq ló nyi é u lé, yhangmoq mauhkûng shut ru wú tsuq nyi bum ashî le, hpyu é mebu wut é byù í yuq gi, radá dâm yhangmoq nàm má htoq yap lò mù, ");
INSERT INTO atbNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","\"Galile byu pé ê, haî mù luî mauhkûng shut wú tsuq nyi akô lhú? Nungmoq é hí mai mauhkûng shut shuî yù huî é, haû Yesuq mauhkûng shut doq ló é u lé, nungmoq myang kat é su, Yhang dum jé lé râ nghut lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hau htâng má, yhangmoq gi, Tsanlun Bùm mai, Yerusalem wà mó shut taû ló bekô. Haú gyoro gi, Bánno buinyì má ge sô é í za wê ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yhangmoq jé ló kôjáng, yhangmoq nyi nyì kô é yhûm ahtoq pyâm mâ é wap shut doq ló akô; haú bang gi, Petruq, Yohan, Yakuq, Andre, Hpilip eq Htomaq, Barhtolume eq Mahte, Alhpe é yhangzo Yakuq, Zelutuq dut é Simun, góyuq Yakuq é yhangzo Yudaq pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yhangmoq lhunglhâng bang gi, myiwe wuì le, Yesuq é yhângnu Mariq le, yhanggu pé le kut mù, i-myit rahkat za kyû chôm dung dung kut nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Buinyì haú yoq má, Petruq gi, lumjíng é gumang gu-nhá wuì rasho í xê yuq kô zup zîng tô é gung gûng má, toq yap mù, ");
INSERT INTO atbNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"Gumang gu-nhá wuì ê, Yesuq lé chyup é bang lé hkyô shuî hî é sû Yudaq eq séng luî, hí hpyang Dawiq é nhut mai Chyoiyúng Woi-nyí taî tô é Chyúmdang gi, dik byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yhang gi, nga-nhúng má nghap lhôm é hui mù, hpúng sará ayá wó bê sû nghut kôlhang shí hkyô dut bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudaq gi, yhang kut é agè ashop é muzó mai wó é ahpaû èq myigùng ratóng wui yu é htâng, haú má yhang, a-nghop dông byit gyó mù wam buq goq luî, û banshoq buq myín byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Haú hkyô lé Yerusalem wà mó má nyi é lhunglhâng bang wó gyo kôjáng, myigùng haû lé yhangmoq é myíng dông, 'Akeladama' ga myhîng akô; haû gi, 'Sui myigùng', gâ é nghut ri.) ");
INSERT INTO atbNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petruq xoq taî é gi, \"Hkâsu mù gâ le, Hkya-on Kungtôn Laiká má, 'Yhâng é jowò chamchyuiyuì dut byuq sháng gaq; haú má ó le a nyì kó sháng gaq.' ga luî le, dum 'Yhang wó é ayá lé byù góyuq wó yu pyám byi sháng gaq.' ga luî le, bo tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Haû mù luî, Yohan baptisma byî hi é hkûn mai, Yesuq lé nga-nhûng chyáng mai shuî yu é buinyì jé shoq, Yhumsîng Yesuq nga-nhúng eq rahá htoq htoq wàng wàng kut nyi é buinyì banshoq pé má, nga-nhúng eq yhang zum nyì sû rayuq lé, hkyin kat râ dut ri. Haú yuq gi, Yesuq dum dui toq é hkyô lé nga-nhúng eq rahá saksé dut râ sû nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Haú hkûn, yhangmoq gi, Yustu ga le myhîng é, Barsabaq gâ é Yosep eq Mahtiaq nhik lé hkyin tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Haû mù, yhangmoq kyûdung kô é gi, \"Byù banshoq é i-myit lé sê é Yhumsîng ê, Yudaq Iskarut gi, yhang ló gíng é jowò shut ló râ ga, tô pyâm tô é yhâng é lagyo ayá é matú shí nhik mâ é nàng hkyin tô é sû lé tûn shit laq ò.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hau htâng, yhangmoq, byù hkyîn shosé she le, Mahtiaq chyáng ang bê. Haû mai, Mahtiaq lé gi, haû lagyo raxe rayuq má jat kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Penteko-ti buinyì jé jáng, lumjíng bang banshoq gi, jowò ralhum má za, chôm zup míng nyi tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Haú hkûn, laidun mó lo é su gâ é htê gi, byodàn ratung, mauhkûng mai mying htoq lô mù luî, yhangmoq zing tô é yhûm byíng shoq dut to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Myishâm su dut é le byò myín htoq lô mù, yhangmoq yuq jup é ahtoq má jé to bùm bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yhangmoq lhunglhâng bang gi, Chyoiyúng Woi-nyí byíng lo bùm kômù, Woi-nyí èq taí nhang é eq rajung za, laklaí dang dông nyo lo bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Haú u lé, mauhkûng ô má joq é mingdán hkangmó mâ é, tarâ hkunggâ é Yudaq byu pé gi, Yerusalem wà mó má bíng nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Haû mying é htê lé wó gyo kôjáng, byù rajùm rayò zîng lé lô kômù, ó le ô é myíng dông sê gyô yù kô é yanmai, maú úng-âng byuq bùm kôluî, ");
INSERT INTO atbNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","maú bûm uchyang taí kô é gi, \"Wú keq, ahkuî dang taî nyi é byù shí bang lhunglháng gi, Galile byu pé chyat a nghut kó lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Haû nghut é wa, hkâsu mù nga-nhúng ó le ô é yhumsing mau mâ é myíng dông sê gyô yu lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parhti, Medi, Elam mau mâ é bang eq Mesopotamiaq mau, Yuda eq Kapadokia mau, Pontuq eq Asia, ");
INSERT INTO atbNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Hprugi eq Pamhpuli, Egutuq ming má nyi é bang eq Kuruni myuq nâm má nyi é Libya ming mâ é bang, Romaq myuq mai lé bíng nyi é Yudaq byu pé eq Yudaq noqkuq htûng má lhing wang lò bang, ");
INSERT INTO atbNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kreti zinlóng eq Arabiq mau mâ é bang, nga-nhúng gi, yhangmoq hko kyô é Garai Gasâng é mauhpo muzó hkyô lé, yhumsing mau mâ é myíng dông yhang wó sê gyô yu ri-nhung.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yhangmoq banshoq bang gi, maú úng-âng byuq kômù, \"Shî gi, haî wá nghut lhê lhú?\" ga le, rayuq eq rayuq myî lhûm bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nghut kôlhang, byù ra-am gi, \"Shí bang gi, î shuq wut é bang nghut akô.\" ga luî, taî jihpoi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Haú hkûn, Petruq gi, lagyo góbang raxe rayuq eq toq yap mù, htê mó èq byù haú bang lé taî é gi, \"Yudaq byu pé eq Yerusalem wà mó má nyì nyi é lhunglhâng bang ê, rago gyô wú keq! Ngò, nungmoq lé, shí hkyô taî kyo kôlé. ");
INSERT INTO atbNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Shí bang gi, nungmoq sû-ngam é dông, shuq wut é bang a nghut; hkâsu mù gâ le, ahkuî gi, napkyó gau hkyíng za ru nghut ashî. ");
INSERT INTO atbNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Shí hkyô kúm gi, myiqhtoi Yoelaq taî tô é eq rajung za dut é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yhang taî tô é gi, 'Garai Gasang îsu gâ ri: Ló htâng é buinyì pé má, Ngò Ngá é Woi-nyí lé byù lhunglhâng bâng é ahtoq má hut gyun râ nghut lhê. Haû mù, nungmoq é yuqzo byizô pé gi, myiqhtoi htoi kó râ; nungmoq é zorâm wuì gi, myoqwup shing-rán myàng kó râ; nungmoq é hpaû mâng pé gi, yhupmoq myàng kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Buinyì haú pé má, Ngá é dui-nhâng zoshâng hpô pé eq dui-nhâng zoshâng myhî pê é ahtoq má lháng, Ngò Ngá é Woi-nyí lé hut gyun mù luî, yhangmoq gi, myiqhtoi htoi kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ngò gi, ahtoq mauhkûng htoq má mauhpo muzó pé lé, a-ô myigùng htoq má, kumlhá pé lé, sui eq, myi eq, myihkau dùm pê èq kut mù tûn shit râ. ");
INSERT INTO atbNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Haû Yhumsing é kô hkikhkam é buinyì a jé shimá, buì gi, mauchut byuq, lhamó gi, sui dut byuq é hí dut râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Haú hkûn, Yhumsing é myìng lé lâng é bang yuq hkangmó gi, hkyi yu é hui kó râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israelaq byu pé ê, dang shî lé gyô yù keq, nungmoq sê é eq rajung za, Nazaret wà byù Yesuq nungmoq é hí má tûn shit é, laklaí kumlhá, mauhpo muzó eq kumlhá pé gi, Yhang lé Garai Gasang nhang kat é saksé dut bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Shí yuq gi, Garai Gasang myit hpyit tô é hkyô eq, hí te sê é hpaqchyî dông, nungmoq chyáng ap pyâm é hui mù, nungmoq gi, agè ashop byu pê é loq èq, Yhang lé tapzîng htoq má jén sat pyám nhâng bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nghut kôlhang, haû shî-nò hkyô gi, Yhang lé wó hkûm zing jung a nghut é yanmai, Garai Gasang gi, Yhang lé shî-nò jamjau mó mai, lhut pyám byi luî lhoq dui toq yû bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawiq gi, shî yuq eq séng luî taî é má, 'Haû Yhumsîng gi, ngá é myoq hí má hkâ-nhám le nyi nyi é lé ngò myàng bê. Yhang ngá é loqyo hkyam má nyi nyi é yanmai, ngo lé wó lhoq nhún râ a nghut lo. ");
INSERT INTO atbNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Haû mù, ngá i-myit gi, nguingón nyî luî, ngá nhut shô gabú hkya-ôn nyi ri; ngá é gungdu le myit myoqbyù jowò má nyi nyì râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Hkâsu mù gâ le, nàng, ngá é woi-nyí lé mosumhkung má tô pyâm to râ a nghut. Nàng, náng é Chyoiyúng Sû lé bup byuq é hui nhâng râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nàng, ngo lé asak dui é hkyô sé nhâng bê. Náng é myoq hí má, nàng, ngo lé gabú hkyô lhoq pyíng byi râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Gumang wuì ê, nga-nhûng é îchyí îké Dawiq kâng byit mù, myhup pyám hui bê hkyô lé le, yhâng é lup gi, hkû-nyí jé shoq nga-nhûng chyáng joq tô é lé le, ngò, nungmoq lé a gyuq a kyum wám taî lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawiq gi, myiqhtoi rayuq nghut é yanmai, yhâng é awut ashín mâ é rayuq lé, yhâng é hkohkâm tanghkuq má zùng nhâng râ ga Garai Gasang byi tô é danggidiq lé sê to mù, ");
INSERT INTO atbNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","'Hkrisduq gi, mosumhkung má pyâm to a hui râ eq, Yhâng é gungsho a bup byuq é za, dum dui toq ló râ nghut lhê.', gâ é hkyô lé te sê to luî taí tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Garai Gasang gi, haû Yesuq lé lhoq dui toq yù bê. Ngamoq banshoq bang gi, haú hkyo é saksê pé nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Haû mù, Garai Gasang gi, Yesuq lé Yhâng é loqyo hkyam má lhoq toq to bê. Yesuq gi, Garai Gasang byi tô é danggidiq Chyoiyúng Woi-nyí lé hkam yù mù, hut hkyô kat bê nghut é yanmai, ahkuî nungmoq shî su wó myâng, wó gyo bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Hkâsu mù gâ le, Dawiq gi, mauhkûng htoq tsáng myhâng má a doq ló wú kôlhang, yhang gi, 'Haû Yhumsîng Garai gi, ngá é Yhumsîng lé, \"Ngò, náng é gye pé lé, náng é hkyî nang tanghkuq kut pyám byî é hkyíng jé shoq, Ngá é loqyo hkyam shut zung nyì shi aq.\" gâ ri.' ga luî, taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Hau é yanmai, Garai Gasang gi, nungmoq èq tapzîng má jén sat pyâm é haû Yesuq lé, Yhumsîng eq Hkrisduq dut nhang é hkyô, Israelaq byu pé lhunglhâng bang hkyak sê nyì kó sháng gaq ô.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Yhangmoq gi, haû lé wó gyô bùm kôjáng, yhangmoq é i-myit má záng kô é nghut mù luî, \"Gumang wuì ê, ngamoq hkâsu kut lo râ lhú?\" ga luî, Petruq eq lagyo góbang lé myî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petruq gi, \"Nungmoq yuq hkangmó myit lhîng mù, Yesuq Hkrisduq é myìng mai wui-myhup hkâm yù keq; Haû jáng, nungmoq é yubak hkyut pyám byî é hui kó râ nghut lhê. Haú hkûn, Chyoiyúng Woi-nyí gâ é chyunghuq lé, nungmoq wó yû kó râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Hkâsu mù gâ le, danggidiq haû gi, nga-nhûng é Yhumsîng Garai Gasang ji yù râ bang banshoq nghut é, nungmoq eq nungmoq é yhangzo yhangshû pé eq le, mau we má nyi é lhunglhâng bang eq le, sêng lhê.\" ga luî, yhangmoq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yhang gi, dang gotû myo myô èq le saksé hkám mù, \"Shî agè ashop é amyû mai wó lut htoq lo keq ô!\" ga luî, yhangmoq lé lhoq pun lhoq kyîng ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dang haû lé guq yu é bang gi, wui-myhup hkâm yu bùm kôluî, haû nyí má byù sum hkyîng kô jat wàng lo bum bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Haú bang gi, lagyô pé mhoqshit é hkyô, zùm yap é hkyô, muk hpê gam é hkyô eq akyû dûng é hkyô má, i-myit rahkat za chôm châng nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Lagyo pé kut shit é mauhpo muzó eq limik kumlhá pé myo myô é yanmai, lhunglhâng bang gi, gyuq maú nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Lumjíng é lhunglhâng bang gi, rawò má za zup zîng to mù, azíng zè banshoq lé chôm chung nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yhangmoq gi, yhumsing é sutzè pé lé, ûng pyám mù, yuq hkangmó lé, yhang râ tô é eq rajung za gàm byî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yhangmoq gi, nyí wuî myit rahkat zâ èq noqkuq yhûm wàng má nyi nyi akô. Yhumsing é yhûm pé má le muk hpê gam é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Garai Gasang lé hkya-on kungtôn uchyang, gabú é eq myit huî é èq chôm zo chôm shuq nyi bum akô; byù banshoq bâng é hí má le myoqdong wó bum akô. Haû Yhumsîng gi, nyí wuî yhangmoq chyáng hkyi yù hui bang jat lò nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ahkuî, Petruq eq Yohan gi, myinhtâng zó sum hkyíng lhê é kyûdung nám má, noqkuq yhûm shut doq e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Haú hkûn, înû unghkaû mai hkyî hten lugù dut é byù rayuq lé, noqkuq yhûm má wang lé lô bâng chyáng mai dung zo sháng gaq ga, Yúnglhó hkum ga myhîng é hkúmdong má nyí hkang nyí mó waq lé lô mù, lé nyhi to to kut akô. ");
INSERT INTO atbNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yhang gi, Petruq eq Yohan, noqkuq yhûm haú má wang e ló é lé, myàng luî, lhom dûng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petruq eq Yohan kúm gi, yhang lé chôm wú tsuq to mù, \"Nga-nhik lé tu wú aq.\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Haû mù, yhang, yhangnhik chyáng mai rajung jung wó yû râ lé myit myoqbyù luî, yhangnhik lé rago za saî wú tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petruq kúm gi, \"Ngùn, hîng gi, ngò a wó; nghut kôlhang, ngò wó é nang lé byi lé: Nazaret wà byù Yesuq Hkrisduq é myìng mai toq sô ló aq.\" ga taí uchyang, ");
INSERT INTO atbNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","yhâng é loqyo loq má zui mù lâng toq kat ri; haú hkûn jáng, yhâng é hkyî kochang-chap pé wúm bo lò bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Haû mù, yhang gi, radá dâm toq yap mù sô kat luî, so uchyang, byàm uchyang Garai Gasang lé hkya-on mù, yhangnhik eq rahá noqkuq yhûm má wang ló ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yhang sô e ló nyi é eq Garai Gasang lé hkya-on kungton nyi é lé, lhunglhâng bang chôm myang akô. ");
INSERT INTO atbNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Haú yuq gi, noqkuq yhum é Yúnglhó hkum gâ é hkúmdong má zung to mù, dung zo sû nghut é lé yhangmoq matsîng kô é nghut mù luî, yhâng chyáng dut lò bê hkyo é yanmai, maú hong byuq bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Petruq eq Yohan chyáng haû dung zo sû byìn châng tô é hkûn, shiwa byu pé gi, wú maú uchyang, Sholumon jirop shut, yhangmoq chyáng din yán wang lé lo bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petruq haû lé myàng jáng, shiwa byu pé lé taî é gi, \"Israelaq byu pé ê, shí yuq é hkyô lé haî mù luî maú nyi akô lhú? Nga-nhik é dingmán hkyô eq wum-o a-tsâm èq, shí yuq lé wó so nhang é su ngâm luî, ngá-nhik lé wú tsuq bum akô lhú? Haú dông a nghut. ");
INSERT INTO atbNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isak eq Yakup pê é Garai Gasang, nga-nhûng é îchyí îwa pê é Garai Gasang gi, Yhâng é dui-nhâng zoshâng Yesuq lé hpungwup shingkang lhoq htoq byî é nghut ri; nungmoq kúm gi, Yhang lé sat hui shoq ga ap pyám kômù luî, Pilat zau hpó mai Yhang lé nhang pyám râ ga myit to bê lé, nungmoq gi, Yhâng é hí má yhang, Yhang lé he-ngik pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Haû chyoiyúng dingmán é Sû lé nungmoq he-ngik pyám kômù, byù sat sû lé sheq dûng htoq yû kôluî, ");
INSERT INTO atbNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Asak Yhumsîng lé gi, sat pyám bekô. Garai Gasang kúm gi, haú yuq lé shi é mai lhoq dui toq yû bê nghut ri; ngá-nhik gi, haú hkyo é saksé nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesuq é myìng lé lumjíng é yanmai, haû lumjíng myit mai za, shî nungmoq myang é sê é sû lé wum-o lhoq pyíng byi bê nghut ri; nghut bê, Yesuq lé lumjíng é yanmai, shí yuq lé, nungmoq banshoq bâng é hí má, gumjup shoq lhoq ge to byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ahkuî, gumang wuì ê, nungmoq é uphkâng bang kut é su, nungmoq le haú hkyô lé a sé mù kut pyâm é hkyô lé ngò sê nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nghut kôlhang, haú hkyô gi, Garaî é Hkrisduq shî-nò jamjau hui râ nghut lhê ga luî, myiqhtoi banshoq bang lé hí hí mai taí nhang tô é Garai Gasang yhang, lhoq dik é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hau é yanmai, haû Yhumsing chyáng mâ é nguingón é ahkyíng yàm yoq jé lô râ matú le, ");
INSERT INTO atbNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nungmoq é matú hkyin tô é Hkrisduq nghut é Yesuq lé, Yhang nhang kat byi râ matú le, nungmoq é yubak mara hkyut pyám byî é hui râ matú le, nungmoq gi, myit lhîng mù Garai Gasâng chyáng lhing lò keq. ");
INSERT INTO atbNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Garai Gasang gi, a-nham pyat mai, Yhâng é chyoiyúng myiqhtoî pê é nhut mai, taí nhang to bê eq rajung za, nyì mi-nyì, joq mijoq lé asik dum saî é pyat jé shoq, Yesuq lé mauhkûng htoq má nyì nhang to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hkâsu mù gâ le, Mosheq taî tô é le, 'Haû Yhumsîng Garai Gasang gi, nungmoq é yhanggu yhangmâng pê chyáng mai, nungmoq é matú ngò sû é myiqhtoi rayuq pô htoq lô nhâng râ nghut lhê; haú yuq taí mitaí nungmoq gyo ra râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Myiqhtoi hau é dang lé a gyo sû ó yuq nghut kôlhang, yhumsing é byù myû mai chyung hpyit pyâm é hui râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gè gè yhang, Samuelaq mai, yhâng é htâng má châng pô htoq lo é myiqhtoî pé banshoq bang hko kyô lo é má le, buinyì shí pé eq séng mù taî to bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nungmoq gi, haû myiqhtoî pê é dang silí wunlí eq, Garai Gasang mai, Abraham lé, 'Náng é awut ashîn é yanmai, mingkan htoq mâ é byù myû chângjup hkungsô wó kó râ nghut lhê!' gâ é eq rajung za, nungmoq é îchyí îwâ pé eq tô tô é danggidiq lé wó hkam yù râ bang nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Garai Gasang gi, nungmoq yuq hkangmó lé yhumsîng agè ashop é hkyô mai wó lhing taû lò nhang é dông, shimân byi râ matú, Yhâng é dui-nhâng zoshâng lé pô htoq lô nhâng luî, nungmoq chyáng hí nhang kat byi bê nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hkyangjông pé, noqkuq yhûm zúng é suwún hpó eq Saduke pé gi, Petruq eq Yohan shiwa byu pé lé dáng nyo nyi é hkûn, htoq lé lô kômù, ");
INSERT INTO atbNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","yhangnhik, shiwa byu pé lé mhoqshit é eq, Yesuq é yanmai shi byuq bê bang Yesuq má dum dui toq lô râ gâ é hkyô lé taî nyì kô é yanmai, yhangmoq gyai yhang myit myô nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Haû mù, yhangmoq gi, yhangnhik lé chyup yû luî, myinhtâng mauchut lô bê nghut é yanmai, htang napkyó jé shoq htóng má lhûng tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nghut kôlhang, mungdang lé wó gyô yu é bang myo myo gi, lumjíng kômù luî, yuqgè ngo hkyîng kô jé shoq myô jat lò bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Htang nyí, yhangmoq é zau wuî, suwún wuî eq tarâ sará pé gi, Yerusalem wà mó má chôm huî zup akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hkyangjong mó Anna, Kayahpaq, Yohan, Alesander pé eq hkyangjong mó é amyû pé banshoq le, haú má bo tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Haû mù, yhangmoq gi, Petruq eq Yohan lé gung gûng má nyhi to luî, \"Nungnhik gi, haî a-tsam, ó yuq é myìng mai mû shî lé kut akô lhú?\" ga myî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Haú hkûn, Petruq gi, Chyoiyúng Woi-nyí byíng tô é nghut mù luî, yhangmoq lé taî é gi, \"Mingbyû wuì é zaugun suwún wuî ê, ");
INSERT INTO atbNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","hkyî hten sû shí yuq lé lhoq gê byî é jeju yanmai, yhang hkâsu kut lhoq ge yù huî é hkyô lé, hkû-nyí nungmoq ngá-nhik lé myî gôn wú naû kô é nghut le gi, ");
INSERT INTO atbNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nungmoq lhunglhâng bang eq Israelaq byu pé banshoq lé sé nhâng kôlé, nungmoq èq tapzîng má jén sat pyám mù, Garai Gasâng èq shi é mai lhoq dui toq yu é, Nazaret wà byù Yesuq Hkrisduq é myìng mai, shî yuq gi, nungmoq é hí má îsu wáng wáng zán zán yap tô é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","'Yhûm saí bang nungmoq hkyin htoq pyâm é luqgok gi, htungchyûn mâ é ahkyak dik é luqgok dut bê.' gâ é gi, Yesuq lé taî é dông nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hkyi yù hkyô gi, Yhang mai lai luî gotû a nyì lo, hkâsu mù gâ le, nga-nhúng hkyi yu é hui râ matú, mauhkûng a-ô má, Yhâng é myìng mai lai luî, xângzo byu pé lé byî tô é myìng gotû a joq lo é yanmai nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yhangmoq kúm gi, Petruq eq Yohan nhik a gyuq a kyum taî é lé myàng kôjáng, yhangnhik, jong a doq wú é, mayû byù za nghut é hkyô lé sé to kô é yanmai, maú nyi bum akô; nghut kôlhang, hí hpyang Yesuq eq zum wún wú sû nhik nghut é lé, yhangmoq bûn kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hau htoq agó, lhoq gê byî é hui sû le, yhangnhik eq rahá yap tô é lé, yhangmoq myàng kô é nghut mù luî, taí râ hkyô haî le a joq lo kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Haû mù, yhangnhik lé, haû Yudaq byìn tú wapdoq mai lhoq htoq to mù, yhangmoq rayuq eq rayuq hpyê lhum kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","\"Shî nhik lé hkâsu kut lé gè râ lhú? Yhangnhik kut shit e laklaí kumlhá gi, Yerusalem wà mó má nyi é lhunglhâng bâng é hí má de za dut bê nghut é yanmai, nga-nhúng haû lé a wó hê lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nghut kôlhang, mingbyû wuì má shí hkyô je riyhang a byo myín ló sháng gaq, ahkuî mai myìng haû lé lang mù ó lé le a taî kyo lo râ matú, yhangnhik lé kyuq hkúm pyám sháng.\" gâ bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Haû mù, yhangnhik lé dum wut hâng yù luî, Yesuq é myìng lé lang mù, haî le hkâtaí, hkâ-mhoqshit kó ga chôm hkûm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Petruq eq Yohan kúm gi, \"Garai Gasâng é mungdang lé gyo râ htoq má, nungmoq é dang gyo le gi, Garai Gasâng é hí má gè râ, a gè râ lé, nungmoq yhang doqdân yù keq. ");
INSERT INTO atbNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nga-nhik kúm gi, myàng yù, wó gyô yù bê é hkyô pé lé, a taî é, a wó nyî nghut lhê.\" ga luî, yhangmoq lé dum tû taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Haú hkûn, yhangmoq gi, dut laî lò bê hkyo é yanmai, shiwa byu pé Garai Gasang lé hkya-on kungton nyi bùm kôluî, yhangnhik lé dàm byi râ hkyô a myàng kó ê nghut mù luî, yhangnhik lé dum tân kyuq luî nhang pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hkâsu mù gâ le, haû laklaí kumlhá dông lhoq gê byi huî é sû gi, asak myi xê zàn chyân bê sû nghut é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yhangnhik gi, nhang kat pyâm é hui kôjáng, yhangnhik é luzúm wui chyáng taû ló kômù, hkyangjong agyi pé eq suwún wui èq yhangnhik lé hkyîm é dang banshoq lé, ló taî kyo akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Haû hkyô lé wó gyo kôjáng, yhangmoq gi, myit rahkat zâ èq yhumsing é htê lhoq ko mù, Garai Gasang lé kyûdung kô é gi, \"Mauhkûng eq myigùng, wuìshuq lung-aû eq, haú pé má, nyì mi-nyì lé hpan tô é, ahko ahkáng lhunglháng wó é Yhumsîng ê, ");
INSERT INTO atbNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nàng, náng é dui-nhâng zoshâng, ngamoq é îchyí îké Dawiq é nhut mai, Chyoiyúng Woi-nyí èq taî tô é gi, 'Haî mù luî, tûngbaù amyû pé gi, nhikjum yô akô? haî mù luî, byu pé gi, akôm dâ pyám akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Haû Yhumsîng eq Yhâng é Hkrisduq lé gumlau toq râ matú, mingkan hkohkâm pé gi, toq mù, zau suwún wuî eq rahá zup zîng bum akô.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gè gè yhang, Herut eq Pontu Pilat nhik gi, tûngbaù pé eq Israelaq byu pé le mù, wà mó shî má chôm zîng to kôluî, nàng xû but byi é sû, náng é Chyoiyúng dui-nhâng zoshâng Yesuq lé gumlau toq râ dâ nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Náng é wum-o a-tsam eq nàng ô nau é dông dut râ matú, hí hkûn mai nàng myit hpyit doqdân tô é hkyô lé, yhangmoq gi, kut pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yhumsîng ê, ahkuî yhangmoq taî kyuq nyi é dang lé myàng byi laq ô! Náng é dui-nhâng zoshâng wuì, a gyuq a kyum é myit èq náng é dang lé taí râ matú wum-o byi laq! ");
INSERT INTO atbNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Náng é wum-o bo é loq lhâm kat luî, nolì nojàng lé lhoq gê byi mù, náng é Chyoiyúng dui-nhâng zoshâng Yesuq é myìng mai, limik kumlhá eq mauhpo muzó pé lé kut shit laq ô!\" gâ akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Haû su, kyû ban dung kôjáng, yhangmoq zîng tô é jowò gi, dui nún lô mù, yhangmoq lhunglhâng bang gi, Chyoiyúng Woi-nyí byíng lô luî, Garai Gasâng é mungdang lé a gyuq a kyum é za taî bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Haû lumjíng é lhunglhâng bang gi, i-myit rahkat za nghut nyi akô; ó yuq le, yhumsîng wó é zè lé ngá é a gâ é za, banshoq eq chôm gam chung nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Lagyô pé le, haû Yhumsîng Yesuq dum dui toq é hkyô lé a-tsam mó èq saksé hkâm nyì kô é nghut mù luî, yhangmoq banshoq bâng é ahtoq má jeju myo myo joq nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yhangmoq chyáng a wó a lom é byù rayuq le a nyì kó. Hkâsu mù gâ le, maumyî ratóng wó é, a nghut jáng, yhûm wó é bang ó yuq nghut kôlhang, haú pé lé adàm dàm ûng pyám luî wó yu é ngùn le gi, ");
INSERT INTO atbNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","lagyô pê é hkyî wang má lé to byî akô. Haû mù luî, a wó a lòm sû ó yuq lé le ra tô é eq rajung za gàm byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Haú hkûn, Barnaba ga luî lagyô pê èq myhíng byi é, Kupru ming mâ é Lewiq byù Yosep le, yhang wó é maumyî ratóng lé ung luî, wó yu é ngùn lé lagyô pê é hkyî wang má, lé to byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnaba gâ é dang lichyúm gi, myit wum byí su é yhangzo gâ é lichyúm nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nghut kôlhang, Anani ga sû gi, yhangmyi Sahpira eq rahá, yháng nhâm wó é maumyî ratóng lé ûng pyám luî, ");
INSERT INTO atbNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","yhangmyi le bo sê é dông, ngùn haû ra-am lé gi, haq myhit yu to mù, ra-am lé za lagyô pê é hkyî wang má lé to byî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Haû mù luî, Petruq gi, \"Anani ê, Chyoiyúng Woi-nyí lé mhaû pyám râ matú eq, maumyî hpau mâ é ra-am lé haq yu to râ matú, haî mù luî, náng é myit má Tsadán le byíng nhang tô lhê lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Maumyî haû joq tô le, náng é zè nghut lhê a nghut lhú? Wó ung é ngùn le náng é zè nghut ashî, a nghut lhú? Haî mù luî, nàng haú dông dâ lhê lhú? Byù lé mhaû é a nghut, Garai Gasang lé mhaû pyám bê nghut ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anani gi, dang haû lé wó gyo jáng, lêng mù, shi byuq bê nghut ri. Haú hkyô lé wó gyô é bang banshoq le, gyai yhang gyuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Haú hkûn, zorâm wuì gi, toq mù, yhâng é màng lé htup luî, ê waq myhup pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hau htâng, sum hkyíng kô myáng jáng, yhangmyi le, wang lé lo ri. Haû su dut é hkyô lé gi, yhang a sé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Haú hkûn, Petruq gi, \"Ngo lé taî kyô wú aq. Nungnhik ûng é maumyî hpau gi, shí gû za nghut lhê lhú?\" ga myi jáng, yhang gi, \"Nghut lhê, haú gû za nghut bê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petruq gi, \"Nungnhik gi, haû Yhumsing é Woi-nyí lé îsu kut chyam wú râ matú, hkâsu mù chôm myit huî akô lhú? Wú aq, náng é yhumsîng hpó lé ê myhup pyám bang gi, haû hkúmdong má jé bê; yhangmoq gi, nang lé le waq htoq pyám kó râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Radá dâm, yhang le lagyo hpô é hkyî wang má lêng shi byuq bê. Zorâm wuì le wang lo wú le, myiwe haû shi to láng é lé myàng kôluî, waq ê mù, yhanglang é nàm má, ê myhup pyám bekô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hau é yanmai, haú hkun lhê é hpúng byù banshoq bang eq, haû su dut ê hkyô lé wó gyo má wó gyô é bang gi, gyai yhang gyuq bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ahkuî, lagyô pé gi, mingbyû wui é hí má limik kumlhá eq mauhpo muzó myo myo lé, kut shit nyi akô. Haû lumjíng bang gi, i-myit rahkat zâ èq, Sholumon jirop má chôm hui hui kut bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Shiwa byu pé gi, yhangmoq lé hkunggâ nyi bùm kôlhang, yhangmoq lé a wám ê zum bùm kó. ");
INSERT INTO atbNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nghut kôlhang, haû Yhumsîng lé lumjíng é myiwe yuqgè wuì gi, myo sheq myô jat lò kômù, yhangmoq chyáng je myô jat lò bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Haû mù luî, byu pé gi, Petruq laî lo é hkûn, yhâng é wupzo za lháng rayuq yuq é ahtoq má zang sháng gaq ga, nòhpyo huî é bang lé, wà mâ é hkyô yàm má waq htoq ê mù, yhuphpú pé eq taphkang pé má lheq tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hau htoq agó, Yerusalem awui ayàm mâ é wà pé mai le, byù ajùm ayò gi, no é bang eq agè ashop é nat wang zing-ri huî é bang lé shuî jé lé bum akô; haú bang lhunglháng gi, lhoq gê lhoq yô byî é huî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hkyangjong mó eq yhâng é luzúm wuî, Saduke hpúng mâ é byu pé kúm gi, gyai yhang wú manon bùm kôluî, toq mù, ");
INSERT INTO atbNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","lagyô pé lé chyup yû luî, wà mâ é htóng má lhûng tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nghut kôlhang, haû myín lé, Yhumsîng é maumang lagyo rayuq gi, htóng hkum pé lé hpông pyám mù, yhangmoq lé shuî htoq yû uchyang, ");
INSERT INTO atbNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"Nungmoq htoq ló mù, noqkuq yhûm má ê yap to luî, dui é asak hkyô sik eq sêng é danglù banshoq, shiwa byu pé lé taî kyo keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Napsûn myoqmyàng zó lé, yhangmoq gi, noqkuq yhûm má wàng mù yhangmoq wó gyô yu é eq rajung za, shiwa byu pé lé, mhoqshit hi ló akô. Haú u lé, hkyangjong mó eq yhâng é luzúm wuî gi, Israelaq byu pê é suwún wuî lhunglhâng bang lé ji yù mù, Yudaq byìn tú wapdoq chôm zung yù luî, lagyô pé lé ê shuî yù râ matú htóng shut byù nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Haú bang kúm gi, htong má jé é hkûn, lagyô pé lé a myàng kôjáng, dum taû lò mù lo taî kyo kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","\"Htóng hkum le ging ging myhî to láng ri, htóng zúng bang le hkum yâm má yap tô akô. Nghut kôlhang, hpông wú le, ahkaû má ó le a nyi to lo nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Noqkuq yhûm zúng é zau hpó eq hkyangjong agyì wuì gi, dang haû lé wó gyo kôjáng, \"Shí hkyô haî dut lô râ lhú?\" ga, gyai gyuq maú bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Haú hkûn, byù rayuq wang lé lô mù, \"Wú keq, nungmoq èq htóng má lhûng tô é bang gi, noqkuq yhûm má yap to mù byu pé lé mhoqshit nyi bum akô.\" ga luî, yhangmoq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Haû mù luî, zau hpó haû gi, yhâng é a-ô mâ é bang eq ê mù, lagyô pé lé ê shuî yu akô. Nghut kôlhang, shiwa byu pé luqgok èq dú lô kó râ lé gyuq kô é yanmai, htân htân a wám kut kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Lagyô pé lé shuî jé lô kôjáng, Yudaq byìn tú wapdoq hí má yhangmoq lé nyhi tô akô. Haú hkûn, hkyangjong mó gi, ");
INSERT INTO atbNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","\"Yesuq é myìng lé lang luî a mhoqshit râ matú, nungmoq lé, htan é hkunmó hkyô to bê nghut lhê. Nghut kôle, nungmoq mhoqshit é hkyô gi, Yerusalem wà mó jàm shoq, nungmoq kut bekô nghut luî, Yesuq é sui lé, ngamoq é ahtoq má ke byi râ dâ nyi akô.\" ga luî, yhangmoq lé taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Haú hkûn, Petruq eq gotû lagyô pé tû taí kô é gi, \"Ngamoq gi, byù dang lé gyo ra htoq má Garai Gasâng é mungdang lé je luî gyo râ dut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nga-nhûng é îchyí îwâ pê é Garai Gasang gi, nungmoq èq tapzîng má lhâng sat pyâm é Yesuq lé, shi e mai lhoq dui toq kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israelaq amyû lé, myit lhîng hkyô eq mara hkyut byi hkyô hpóng byi râ matú, up é ahkáng wó Sû eq hkyi yù Sû kut nhâng râ ga, Garai Gasang gi, Yhang lé, Yhâng é loqyo loq má waq toq to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ngamoq le shí hkyo é saksé pé nghut nyi lhê; mungdang lé gyô yù luî châng é bang lé Garai Gasang byî tô é Chyoiyúng Woi-nyí le, shí pê é saksé nghut lhê.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yhangmoq gi, dang haû lé wó gyo kôjáng, lûm gyo nhik-yo naû kômù, lagyô pé lé sat pyám râ lháng myit akô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nghut kôlhang, mingbyû banshoq bâng é hí má aróng wó é tarâ sará Gamalelaq gâ é Hparishe rayuq, haû Yudaq byìn tú wapdoq má toq yap mù, lagyô pé lé razup zo lhoq htoq to nhâng luî, ");
INSERT INTO atbNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","yhang taî é gi, \"Israelaq byu pé ê, shí bang lé hkâsu kut râ hkyô, rago za hí myit wú keq. ");
INSERT INTO atbNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hkâsu mù gâ le, hí hpyang Htudaq gâ é byù rayuq pô htoq lô mù, yhânggùng yhang byù mó rayuq yuq nghut lhê ga taí jáng, byù myi shô kô yhâng chyáng châng wú bekô. Yhang sat pyâm é hui luî, yhang htâng châng é lhunglhâng bang le byo myín byuq kômù, haî le a wó kut dut byuq akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hau htâng, myìng jihpán guq yu é buinyì má, Yudaq gâ é Galile byù rayuq pô htoq mù, mingbyû wuì lé yhâng hkyam shut mhoq hpyoq yu ri. Yhang le sat pyâm é hui mù, yhang htâng châng é lhunglhâng bang le, byo myín byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ahkuî le, shí bang lé haî le hkâgon ko, yhangmoq kâm é dông nghut nyî kó sháng gaq; yhangmoq kut nyi é hkyô eq dâ nyi é hkyô pé gi, byù myit dông kut é nghut jáng, htên byoq byuq râ za nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nghut kôlhang, Garai Gasâng chyáng mâ é nghut le gi, nungmoq wó lhoq hkyîng pyám kó râ a nghut. Garai Gasâng é gyè sheq dut lò kó râ nghut lhê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dang haû lé yhangmoq gyô htuk bum akô. Haû mù, lagyô pé lé wut yù mù luî, nhuq bat yù kômù, Yesuq é myìng lé lang luî mhoqshit é hkyô a ge kut râ nghut lhê ga taí kômù, nhang pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lagyô pé kúm gi, Yesuq é mying é yanmai ru hpuzô é hkyô gi, gingdán nyi ri, ga myit yù kômù, Yudaq byìn tú wapdoq haû mai gabú myit èq htoq ló bekô. ");
INSERT INTO atbNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hau htâng, yhangmoq gi, nyí wuî làng noqkuq yhûm má le, rayhûm htâng rayhûm má le, Yesuq gi, Hkrisduq nghut é hkyô gabú danglù lé mhoqshit hkô kyô nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ahkuî, chángzô pé myô jat lo nyi é buinyì pé má, Grik dang nyo é Yudaq byu pé gi, yhangmoq é chuimó myhî pé lé, nyí wui lhê é gàm tso gàm huq é hkyô má rago a wó kut kô é yanmai, Hebre myíng mu é Yudaq byu pé lé mara hûn dang taî bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Haú hkûn, lagyo raxe í yuq gi, chángzô pé lhunglhâng bang lé wut yù mù, \"Ngamoq, Îwa Garai Gasâng é mungdang hko kyô é muzó lé rap pyâm to mù, zangbó amû lé za lajang nyi é nghut le gi, a htuk râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Haû mù luî, gumang wuì ê, Chyoiyúng Woi-nyí byíng é eq hpaqchyî byéng-yá bo é nhik bo byù nyhit yuq lé nungmoq chyáng mâ é hkyin to keq. Haú bang lé muzó shí lhum hun to râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ngamoq kúm gi, kyûdûng é hkyô eq mungdang hkô é hkyô lé za, noqzuq tung kut nyî râ nghut lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dang haû lé shiwa byù lhunglhâng bang gyô htuk kômù luî, lumjíng myit kô é, Chyoiyúng Woi-nyí byíng é Stehpan ga sû eq, Hpilip, Prokoru, Nikanora, Timun, Parmena, Yudaq noqkuq htûng má lhing wang lò bê sû Antioku wà mó mâ é Nikolaq pé lé hkyin yù mù, ");
INSERT INTO atbNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","lagyô pê chyáng shuî ló akô; lagyô pé gi, kyûdung byi kômù, yhangmoq lé loq ke byî akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Garai Gasâng é mungdang gi, je myô jam lò luî, Yerusalem wà mó má chángzô pé gyai myô jat lawán lo é htoq agó, hkyangjông pé myo myo le, haû lumjíng hkyô má châng nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ahkuî, Stehpan gi, Garai Gasâng é jeju chyunghuq eq wum-o a-tsam byíng nyi é nghut mù, byu pê é hí má mauhpo muzó pé eq limik kumlhá mó pé tûn shit ri. ");
INSERT INTO atbNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Haú hkûn, luthkyô ga bâng é tarajong eq sêng é Kuruni, Alesander eq Kiliki, Asia mau mâ é bang ra-am gi, toq mù, Stehpan eq dang chyin chyin lhûm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nghut kôlhang, Stehpân é dang gi, Chyoiyúng Woi-nyí lom é hpaqchyî dang nghut é yanmai, yhangmoq a ûng kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Haû mù, yhangmoq gi, \"Shí yuq, Mosheq eq Garai Gasang lé rhoî dang taî nyi é lé, ngamoq wó gyô ri.\" ga luî, mhaû taí nhâng râ byù haq lung tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Haû mù, yhangmoq gi, mingbyû wuì eq nhik bô suwún wuî, tarâ sará pé lé, chun htau mù, Stehpan lé chyup yû nhâng luî, Yudaq byìn tú wapdoq má shuî nyhi tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mhaû é saksé byu pé lé le lhoq hâng kat luî, haú bang gi, \"Shí yuq, shî chyoiyúng jowò eq jep é tarâ lé shut shai é dang ru taî nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nazaret wà byù Yesuq ga sû gi, jowò shî lé hpyoq pyám mù, nga-nhúng lé Mosheq èq byî tô é htunghking lé htaî pyám râ nghut lhê ga luî, yhang taî é dang lé ngamoq wó gyô é nghut lhê.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Haû Yudaq byìn tú wapdoq má zung to bang banshoq, yhang lé chôm wú tsuq nyî kô é hkûn, yhâng é myoqdong gi, maumang lagyô é myoqdong su dut é lé, yhangmoq myang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Haú hkûn, hkyangjong mó gi, \"Dang haú pé têng lhê lhú?\" ga luî, yhang lé myi jáng, ");
INSERT INTO atbNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stehpan tû taî é gi, \"Gumang wuì eq îwa wuì ê, gyô wú keq, nga-nhúng lhunglhâng bâng é îchyí Abraham gi, Haran wà má a ló nyî shi lé, Mesopotamiaq mau má nyi tô ashî hkûn, hpungwup shingkang bo é Garai Gasang gi, yhâng chyáng lé htoq shit mù, ");
INSERT INTO atbNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Náng é ming eq náng é amyû mai htoq ló luî, ngò tûn shit râ ming shut e ló aq.' ga luî, yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Haû mù, yhang gi, Hkaldea byu pê é mau mai htoq ló luî, Haran wà má ló nyi nyi ri. Yhâng wa shi byuq é htâng má, Garai Gasang gi, ahkuî, nungmoq nyi nyi é ming shî má yhang lé htot lô nhâng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Garai Gasang gi, shí ming má yhang lé silí wunlí nghû râ, hkyî rahkô nang î é myigùng lháng a byî é nghut kôlhang, yhang, zodù lháng a wò shi mai, yhang lé le, yhâng é awut ashín pé lé le, maumyî shî byi râ ga danggidiq byî to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Hau htoq agó, shí hkyô lé Garai Gasang xoq taî é gi, 'Náng é awut ashín pé, tûngbaù ming má bíng nyî mù, haú ming bâng èq myi shô zàn jùn zô é eq zing-rî é lé hui kó râ. ");
INSERT INTO atbNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nghut kôlhang, yhangmoq lé jùn zô é amyû lé le, ngò jéyáng râ nghut lhê.' gâ ri. 'Haú hkûn, yhangmoq gi, haú ming mai htoq lô mù, jowò shî má ngo lé noqkuq kó râ nghut lhê.' ga le, Garai Gasang taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Hau htâng, yhang lé ahpyo-kuq hpyit byi râ hkyô eq sêng é dangshikaq le, byî ri. Haû mù, Abraham gi, Isak lé hku é htâng shit nyí buinyì má ahpyo-kuq hpyit byî ri; Isak gi, Yakup lé hkû mù, Yakup gi, îchyí îwa achyûng raxe í yuq lé hku kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Haû îchyí îwâ pé gi, Yosep lé manôn kôluî, Egutuq ming shut jùn dông ûng kat akô. Nghut kôlhang, Garai Gasang gi, yhang eq rahá nghut nyì mù luî, ");
INSERT INTO atbNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","wuîhke jamjau banshoq mai yhang lé lhoq lhut yû mù, Egutuq hkohkâm Hpara-uq é hí má le myoqdong wó, hpaqchyî byéng-yá le bò nhang é yanmai, hkohkâm haû gi, Egutuq ming eq, yhâng é hkohkâm-wâng banshoq lé up nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Haú u lé, Egutuq ming eq Hkanan ming banshoq má mutmó gyó lô mù, wuîhke jamjau mó hui bekô. Nga-nhûng é îchyí îwâ pé le zoshuq a myang hô zo lo dut byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ahkuî, Yakup gi, Egutuq ming má guqzo joq é hkyô lé wó gyo jáng, nga-nhûng é îchyí îwâ pé lé sâng-hî dàm ê nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Htang dàm dum ê é hkûn, Yosep gi, yhanggu yhangmâng pé lé yhang ó nghut é hkyô taî kyô ri. Hpara-uq le Yosep é yhumbyù ikun hkyô lé sê yù byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hau htâng, Yosep gi, yhâng wa Yakup eq yhumbyù banshoq nyhit xe ngo yuq lé, yhâng chyáng pying yù bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakup le Egutuq ming má jé gyó ló luî, yhang eq nga-nhûng é îchyí îwâ pé gi, banshoq haú ming má shî ló byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yhangmoq é màng lé gi, Shehkem wà má yu taû ló mù, Shehkem wà mâ é Hamora é yhangzo yhangshu pê chyáng mai, Abraham èq ngùn byi mù wui hpyit tô é lupdùng má ló myhup tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Abraham lé Garai Gasang byî tô é danggidiq dik râ ahkyíng jé lo nyi é u lé, ");
INSERT INTO atbNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","nga-nhûng é amyû gi, Egutuq ming má Yosep lé a sê é hkohkâm pô htoq é pyat jé shoq, myoluq jebe lò bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hkohkâm hpó haû gi, nga-nhûng é amyû htoq má a ge é hpaqchyî da luî, nyheqnú pé lé shi byuq sháng gaq ga, dú pyám nhang é dông mai nga-nhûng é îchyí îwâ pé lé zing-ri bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Haû u má, Mosheq lé hkû to bê. Yhang gi, Garai Gasâng é hí má gyai yúnglhô é sû nghut ri; yhang gi, yhângwâ é yhûm má lhamó sum hkyap baú tô é hui mù, ");
INSERT INTO atbNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","htot tô tô é hui jáng, yhang lé Hpara-uq é byizô èq xe yù mù, zosîng kut yû luî, hku kô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mosheq gi, Egutuq ming mâ é hpaqchyî byéng-yá banshoq lé mhoq yû luî, nhut shô a-tsam eq hkyî loq a-tsam gyai bò sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Yhang asak myi xê zàn jé lò jáng, yhâng é gumang Israelaq byu pê chyáng ê kûm wú râ matú wó myit htoq kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ê jé jáng, zing-ri hui nyi é sû rayuq lé ê myâng luî, haú yuq lé búng mù, zing-rî nyi é Egutuq byù lé, loqchoq hpuq é dông sat pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosheq gi, yhâng é byu pé lé yhâng é loq dông Garai Gasang hkyi yù hkyô byi nyi é lé, yhâng é amyû pé sê gyo byi nhô ngàm kôlhang, yhangmoq a sê gyo byi kó nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Htang nyí lé, Israelaq byù yhangchang mabyoq htoq nyi é má, e ang mù, yhangnhik lé pyîn naù luî, 'Ahkaû nhik ê, gumang yhangchang sheq ru nghut lhê nhîng, haî mù rayuq eq rayuq byoq lhum nyi akô lhú?' ga taî ngón wú ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Luzúm hpó lé zing-rî nyì sû yuq gi, 'Ngamoq é ahtoq má zau eq tarâ agyì kut râ matú, nàng lé ó yuq hkyin tô é lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A-nyí nap Egutuq byù lé sat pyâm é su, ngo lé le sat pyám nau ri lhú?' ga luî, tû taí uchyang yhang lé dûn chyûn pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosheq gi, dang hau é yanmai, hpâng luî Midian ming má ê nyì byuq ri. Haû má yuqzo í yuq ê wó ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Haû ming má myi xê zàn lai jáng, Sinaq Bùm yàm, yoso hkaû mâ é myi gyúng tô é mhanpúng mai, maumang lagyo rayuq gi, Mosheq lé htoq shit ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosheq gi, haû lé myàng jáng, hau é yanmai maú luî, wú wú râ ga huî e ló le, Yhumsîng é htê htoq lo é gi, ");
INSERT INTO atbNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Ngò gi, náng îchyí îwâ pê é Garai Gasang, Abraham, Isak, Yakup é Garai Gasang nghut nyi lhê.' gâ ri. Mosheq kúm gi, gyuq nán luî, a wám tu wú nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Haû Yhumsîng gi, 'Náng é hkyî-tsung hkyut pyám aq, nàng yap tô é jowò gi, chyoiyúng é myigùng nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egutuq ming má ngá é amyû pé zik zo huî nyi é hkyô lé, ngò gè gè yhang myàng bê; yhangmoq é ngaù nhik ngaù htê lé ngò wó gyo bê; yhangmoq lé hkyi yù râ matú ngò gyó lé é nghut lhê; ahkuî, lé aq, ngò, nang lé Egutuq ming shut nhang taû kat râ.' ga luî, yhang lé dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yhangmoq èq, 'Nang lé zau eq tarâ agyì kut râ matú, ó yuq hkyin tô é lhú?' ga luî he-ngik pyâm é Mosheq lé yhang, mhanpúng má htoq shit é maumang lagyo dông mai, Garai Gasang gi, yhangmoq é zau eq hkyi yù sû kut nhâng luî, taû nhang kat é nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Haû Mosheq yhang, Egutuq ming má le, Nhông Nè má le, yoso hkaû pé má le, myi xê zàn gyoro má mauhpo muzó pé eq limik kumlhá pé tûn shit uchyang, yhâng é byù myû pé lé Egutuq ming mai shuî htoq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Israelaq byu pé lé, 'Nung gu nung mâng pé mai, nungmoq é matú ngò eq du é myiqhtoi rayuq lé, Garai Gasang gi, pô htoq lô nhâng râ nghut lhê.' ga luî, taî tô é sû le Mosheq yhang nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yoso hkaû má nghut nyi ashî hkûn lé, shiwa byù hpúng má, Sinaq Bùm má yhang lé dang taî é maumang lagyô eq le, nga-nhûng é îchyí îwâ pé eq le rahá nghut sû gi, yhang yhang nghut nyi ri; nga-nhúng lé ap byi râ asak dui é mungdang lé lom yu é sû le, yhang nghut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nghut kôlhang, nga-nhûng é îchyí îwâ pé kúm gi, yhâng é dang lé a kâm gyo kômù, yhang lé he pyám luî, Egutuq ming shut taú nau é myit bo bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Haû mù, Arun lé, 'Egutuq ming mai nga-nhúng lé shuî htoq lo é Mosheq gi, haî dut byuq bê hkyô lé, ngamoq a sé lo; haû mù, nga-nhûng hí má so byi râ hparà lhô pé saí byi aq.' ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Haú buinyì pé má, yhangmoq gi, nojûng zo lhô saí mù, alhô haû lé hkungga nhông byi uchyang, yhangmoq é loq èq saî tô é muzó jizó má gabú nhik dik nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Haû mù luî, myiqhtoî pê é laiká má kâ tô é gi, 'Israelaq byu pé ê, myi xê zàn tup yoso má chung é shigu eq hkungga gi, ngo lé nhông byî é nghut akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nungmoq gi, nungmoq noq râ matú saî yu é alhô, Molak é zúm eq Rehpan hpara é kyî lé sheq, waq lhing wún ko é yanmai, Babelon lai shoq ngò nungmoq lé lhoq lhâm pyám râ nghut lhê.' ga luî, bo tô é eq rajung za, Garai Gasang gi, yhangmoq chyáng mai myoqdong lhing pyám mù, mauhkûng htoq mâ é buì, kyî, lhamó pé lé noqkuq râ matú ap pyám bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mosheq lé, nàng myang é azòng eq rajung za saí aq ga, Garai Gasang taî é dông saî tô é saksé zúm lé, haû yoso má nga-nhûng é îchyí îwâ pé wó yû bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Haû mù, nga-nhûng é îchyí îwâ pé gi, yhangmoq é myoq hí mai Garai Gasang èq hkat htoq pyám byî é byù myû pê é mau má, Yoshuq eq rahá wang nyi ló kô é hkûn, saksé zúm haû lé yu wang ló akô. Haû gi, Dawiq é pyat jé shoq joq to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawiq kúm gi, Garai Gasâng hí má myoqdong wó sû nghut mù luî, Yakup é Garai Gasâng matú nyì jowò saí râ ahkáng dung kôlhang, ");
INSERT INTO atbNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sholumon èq sheq saí bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nghut kôlhang, Myhang htáng htum Sû gi, byu é loq èq za saî é yhûm má nyi é a nghut, haú hkyô eq séng luî myiqhtoi wá taî tô é gi, ");
INSERT INTO atbNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","'Mauhkûng gi, ngá é zùng tanghkuq, myigùng gi, ngá é hkyî nang jang nghut nyi lhê; ngá é matú hkasû é yhûm saí byi shi kó râ lhú? Ngò nô yù râ jang gi, hkâmá nghut kó râ lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Haû banshoq lé ngá é loq èq baú saî tô é a nghut kó lhú? ga luî, haû Yhumsîng taî ri.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","I-myit htân mù, i-myit eq nohkyap má ahpyo-kuq a hpyit é bang ê, nungmoq gi, nungmoq é îchyí îwâ pé su, Chyoiyúng Woi-nyí lé hkâ-nhám le lhom he-ngik pyâm nyi akô; ");
INSERT INTO atbNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nungmoq é îchyí îwa pê èq a zing-rî wú é myiqhtoi, ó yuq wá nyi lhê lhú? Haû Dingmán Sû pô htoq râ hkyô lé hko kyô é bang lé, yhangmoq sat pyâm é chyat nghut akô; ahkuî, nungmoq le, haû Dingmán Sû lé ap pyâm é bang eq sat pyâm é bang nghut nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Maumang lagyô èq shit kyo byî é tarâ lé nungmoq wó yû kôlhang, haû lé a cháng kó nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Haú hkyô lé yhangmoq wó gyo kôjáng, yhangmoq é nhiklhum má lûm htaû záng kô é yanmai, Stehpan lé, zuì wang ngat kyáng shoq wú nhik-yô nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stehpan kúm gi, Chyoiyúng Woi-nyí byíng mù, mauhkûng shut tu wú kat le, Garai Gasâng é hpungwup shingkang lé le, Garai Gasâng é loqyo hkyam shut Yesuq yap tô é lé le, myang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Haû mù, yhang gi, \"Wú keq, mauhkûng hpông tô é lé le, Garai Gasâng é loqyo hkyam shut haû Byu Yhangzo yap tô é lé le, ngò myàng ri.\" ga taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Haú hkûn, yhangmoq gi, htê mó o mó garu uchyang, yhumsing é nohkyap xaû pyám mù, radá dâm yhang lé chôm htim kômù, ");
INSERT INTO atbNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","yhang lé wà mai she htoq ló kôluî, luqgok èq chôm dú ló bekô nghut ri; saksé kut é bang gi, Sholuq gâ é zoram é hkyî wang má yhangmoq é buhîng pé lé hkyut bum tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Luqgok èq dú nyi bùm kô é u lé, Stehpan gi, \"Yhumsîng Yesuq ê, ngá é woi-nyí lé hap yù laq.\" ga kyûdûng ri. ");
INSERT INTO atbNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hau htâng, yhang gi, hkyihput htuq mù, \"Yhumsîng ê, yhangmoq kut é mara haû lé hkyut pyám byi laq.\" ga luî, htê mó èq wut dûng ri; haû ban taí jáng, yhang kâng byit byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sholuq gi, haû má nyi to mù, Stehpan lé sat pyâm é muzó má myit bo huî ri. Haú nyí mai, Yerusalem wà mó mâ é noqkuq hpúng gi, zing-ri mó huî lo é nghut mù luî, lagyô pé mai lai luî, lumjíng bang lhunglháng gi, Yuda mau eq Samariq mau jowò hkangmó má byo myín ló bekô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nghut kôlhang, tarâ hkunggâ é bang gi, Stehpan lé yhum pyâm é htâng má, yhang é yanmai iyon mó huî nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sholuq kúm gi, rayhum htâng rayhûm wàng mù, myiwe yuqgè lé she hkyut htoq yû luî, htóng má lhûng tô é dông mai, noqkuq hpúng haû lé lhoq hpyoq ló nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Byo htoq ló é bang kúm gi, jé é jowò hkangmó má mungdang lé hkô kyô ló akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Haú hkûn, Hpilip gi, Samariq mau mâ é myuq ra-myuq shut e ló mù, Hkrisduq é hkyô lé hkô kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Byù ajùm ayò gi, Hpilip taî kyô é hkyô lé wó gyô é eq, yhang tûn shit é limik kumlhá lé myàng kôjáng, i-myit rahkat za eq yhâng é dang chôm gyô nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nat wang júng é byù myo myô pê chyáng mai, agè ashop é nat pé wut garu uchyang htoq ló byuq bum akô; gùngjum shi é bang eq hkyî htên é bang myo myo le, ge ló byuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Haû mù luî, haû myuq má gabú hkyô gyai yhang wó bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Simun gâ é byù rayuq gi, hí lé haú myuq má myoqheq hpaqchyî kut shit mù, Samariq byu pé lé lhoq maú luî, yhâng gùng lé yhang, laklaí sû nghut lhê gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Byù tiq ko banshoq le, \"Byù shí yuq gi, 'haû a-tsam mó' gâ é, Garaî chyáng mai hpungwup a-tsam wó yû sû nghut ri.\" ga luî, yhâng é dang lé gyô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Haú yuq gi, myáng myáng yhâng é myoqheq hpaqchyi èq yhangmoq lé lhoq maú lo é yanmai, yhâng dang lé chôm lum bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nghut kôlhang, Hpilip hko kyô é Garai Gasâng é mingdán hkyô eq, Yesuq Hkrisduq é myìng eq sêng é gabú danglù hkyô lé, lumjíng kôjáng, myiwe yuqgè wui-myhup hkâm yu bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simun yhang yhang le lumjíng mù luî, wui-myhup hkâm yù mù, Hpilip htâng châng wún ri. Hpilip é kumlhá mó eq laklaí kumlhá pé lé myàng jáng, yhang gi, gyai maú byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Garai Gasâng é mungdang lé Samariq byu pé, lhom hap yù bê hkyô lé, Yerusalem wà mó má nyi é lagyô pé wó gyô bùm kôjáng, yhangmoq gi, Petruq eq Yohan nhik lé haú má nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yhangnhik gi, lé jé jáng, byù haú bang Chyoiyúng Woi-nyí wó yû râ matú kyûdung byî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Hkâsu mù gâ le, Chyoiyúng Woi-nyí gi, yhangmoq chyáng ó yuq é ahtoq má lé, a gyó lô shi; Yhumsîng Yesuq é myìng mai wui-myhup hkâm yu é za ru nghut bùm ashî. ");
INSERT INTO atbNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Haû mù luî, lagyô nhik yhangmoq é ahtoq má loq ke byi jáng, yhangmoq gi, haû Chyoiyúng Woi-nyí lé wó hkâm yù bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lagyô nhik é loq ke kat jáng Chyoiyúng Woi-nyí wó hkâm yu é lé, Simun myàng jáng, yhang gi, yhangnhik lé ngùn ê byi wú mù, ");
INSERT INTO atbNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","\"Hká yuq é ahtoq má nghut kôlhang, ngò loq ke byi jáng, haú yuq gi, Chyoiyúng Woi-nyí wó yû râ matú, haû su é a-tsam ngo lé le byi kó laq.\" ga dung ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petruq kúm gi, \"Garai Gasâng é chyunghuq lé ngun èq wó wui yù râ nghut lhê ga luî, myit é yanmai, náng é ngùn gi, nàng eq rahá htên byoq byuq sháng gaq. ");
INSERT INTO atbNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nàng gi, Garai Gasâng é hí má myit a díng sû nghut é yanmai, shí hkyô má nàng wó bo lhóm râ a nghut. ");
INSERT INTO atbNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Haû mù luî, shî agè ashop é hkyô mai myit lhîng mù, Yhumsîng Garaî chyáng dûng tôngbán aq. Haú hkûn, náng é unghkaû má myit pyâm é hkyô lé, mara hkyut pyám byi abe. ");
INSERT INTO atbNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nàng gi, ladu lai shoq nhikhko zo mù, yubak marâ èq tuî zing to huî é lé, ngò myàng ri.\" ga yhang lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Haú hkûn, Simun gi, \"Nungnhik taî é hkyô haî le ngá chyáng a jé sháng gaq, ngá é matú haû Yhumsing chyáng kyûdung byi kó laq.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yhangnhik kúm gi, haû Yhumsing é mungdang lé saksé hkám mù ban hko kyo jáng, Samariq byu pê é wà myo myo má, haû gabú danglù lé hko kyo uchyang, Yerusalem wà mó shut dum taû lò bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ahkuî, Yhumsîng é maumang lagyo gi, Hpilip lé, \"Toq aq, Yerusalem wà mó mai Gaza shut ló é hkyô jé shoq, maupyî shut nyâng za e ló aq. Hkyô haû gi, yoso hkyô nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Haú hkûn, yhang toq mù e ló ri. Haú u lé, Ehtiopi ming lé up é hkohkâm myhí Kandake é hí má ahko ahkáng mó wó mù, yhâng é sutzè banshoq lé zûm é, Ehtiopi byù u-nuk rayuq gi, noqkuq râ ga Yerusalem wà mó má ê mù, ");
INSERT INTO atbNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","dum taû lo é hkûn, yhâng é myanglhêng má zùng luî, myiqhtoi Esai-aq laiká lé nghap nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Woi-nyí gi, Hpilip lé, \"Myanglhêng shut chyâng e ló aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Haû mù, Hpilip gi, din ê mù, myiqhtoi Esai-aq laiká nghap nyi é lé wó gyo jáng, \"Nàng nghap nyi é hkyô lé sê gyo ri lhú?\" ga luî, yhang lé myî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Haú yuq gi, \"Mhoqshit sû yuq a nyi le, ngò hkâsu kut sê gyo râ lhú?\" ga tû taí mù, yhang eq rahá lo doq zùng aq ga Hpilip lé lung ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yhang nghap é Chyúmdang gi, \"Sat râ sau lé su, Yhang lé she e ló bê nghut ri; sau zo gi, sau maú nyhám su é hí má zim za nyi tô é su, Yhang le nhut a hpông é za nyi tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yhânggùng lé lhoq shôm pyâm to huî é hkûn, Yhang lé a tara é dông doqdân pyám bekô; Yhâng é asak lé myigùng htoq mai yù pyám bekô nghut mù luî, Yhâng é awut ashín lé ó yuq wó gôn kyo râ lhú?\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Haú hkûn, haû u-nuk wa gi, Hpilip lé, \"Haû nghut le gi, ngo lé taî kyo laq! Myiqhtoi shí yuq gi, ó lé lhoq ang luî, taî é nghut lhê lhú? Yhânggùng lé taî é nghut lhê lhú? Haû a nghut jáng, góyuq é hkyô lé taî é nghut lhê lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Haú hkûn, Hpilip gi, Chyúmdang haû lé yù mù, Yesuq eq sêng é gabú danglù lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Haû su e ló kô le, wuì joq é má jé jáng, haû u-nuk hpó gi, \"Wú aq, shî má wuì joq tô ri, wui-myhup hkâm yù râ matú ngo lé hkúm râ jang haî joq ashî lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Hpilip gi, \"Náng i-myit banshoq èq, nàng lumjíng bê nghut le gi, hkâm yu le ge lhê.\" ga taî ri; yhang le, \"Yesuq Hkrisduq gi, Garai Gasâng é Yhangzo nghut é lé, ngò lumjíng bê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Haú hkûn, yhâng é myanglhêng hkying nhâng mù, yhangnhik wuì má gyó wâng luî, Hpilip gi, u-nuk hpó lé wui-myhup hkám byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wuì hkaû mai htoq ló kô é hkûn, haû Yhumsing é Woi-nyí gi, Hpilip lé myhik za shuî ló byuq mù, u-nuk hpó le Hpilip lé dum a myàng lo; nghut kôlhang, yhang gi, e ló é hkyô shut gabú myit èq xoq sô e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hpilip kúm gi, Azutu wà má lo htoq jé kat mù luî, Kesare wà mó jé shoq haú mau mâ é myuq pé wà pé hkangmó má gabú danglù hkô kyô wún ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Haú u lé, Sholuq kúm gi, Yhumsing é chángzô pé lé hkat kyuq nha râ eq sat pyám râ ga, nhikmó-yô nyi é nghut mù luî, hkyangjong mó chyáng ê mù, ");
INSERT INTO atbNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yhumsing é Hkyô lé lumjíng é myiwe yuqgè myàng mi-myàng lé chyup yû luî, Yerusalem wà mó shut wó she ló râ matú, Damaskuq myuq mâ é tarajong pé má byi râ laiká pé lé dûng chûng ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yhang e ló le, Damaskuq myuq eq chyáng ló nyi é hkûn, yhâng é lhînghkyuq má mauhkûng mai dàn loq tung duqbó htoq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yhang myigùng má lêng ngop tô é u lé, \"Sholuq, Sholuq, nàng ngo lé haî mù zing-rî nyi lhê lhú?\" ga luî, yhang lé taî é htê wó gyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Haú hkûn, yhang gi, \"Yhumsîng ê, nàng gi, ó yuq nghut lhê lhú?\" ga myi jáng, haû Yhumsîng gi, \"Nàng zing-rî nyi é Yesuq nghut lhê, ");
INSERT INTO atbNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","toq aq, myuq shut wang ló aq. Nàng zui saí râ hkyô lé lhom taî kyo râ nghut lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yhang eq rahá e ló é luzúm wuî gi, htê haû wó gyo kôlhang, ó yuq lé le a myàng kô é yanmai, maú hong yap tô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sholuq toq mù, myoq hpông kat wú le, haî lé le a myàng dut byuq mù luî, yhangmoq gi, yhang lé loq mai shê mù Damaskuq myuq shut shuî wang ló akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sholuq gi, sum nyí tup myoqjit byuq mù luî, a zo a shuq é nyi byuq ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskuq myuq má Anani gâ é chángzo rayuq nyi ri. Yhumsîng gi, yhang lé, \"Anani ê.\" ga shing-rán dông wut ri. Yhang gi, \"Yhumsîng ê, shî má nyi lhê.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Haû Yhumsing dum taî é gi, \"Toq aq, Hkyô-Nyàng gâ é wà hkyô shut ê mù, Yudaq é yhûm má, Tarshu byù Sholuq lé ê hô aq, yhang gi, kyûdûng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yhang gi, Anani ga sû wang lé lô mù, yhâng é myoq dum myàng sháng gaq ga, yhâng é ahtoq má loq ke byî é lé, shing-rán dông myàng bê nghut ri.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anani kúm gi, \"Yhumsîng ê, shí yuq gi, Yerusalem wà mó má, náng é sân-yúng bang lé a ge é dông hkâ-myhó kut laî lo é hkyanglù lé ngò myo myo wó gyô wú bê; ");
INSERT INTO atbNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Shí pé má le, náng é myìng lé lâng é bang banshoq lé chyup râ ga, hkyangjong agyi pê chyáng mâ é ahko ahkáng wó yu to sû nghut ri.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nghut kôlhang, Yhumsîng gi, \"Ru ê aq, shí yuq gi, tûngbaù pé eq yhangmoq é hkohkam pê é hí má le, Israelaq byu pê é hí má le, ngá é myìng lé wùn waq râ matú, ngò chûng râ nghû luî hkyin to sû nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ngá mying é yanmai hkâ-í hpuzo ra hkyô lé, Ngò, yhang lé tûn shit râ nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hau htâng, Anani gi, jé ê mù, yhûm haú má wàng luî, Sholuq é ahtoq má loq kê to mù, \"Gumang Sholuq ê, náng myoq dum wó myàng mù, Chyoiyúng Woi-nyí byíng sháng gaq ga, nàng lé lo é hkyô má, nàng lé htoq shit é Yhumsing Yesuq èq ngo lé nhang kat é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Haú hkûn jáng, Sholuq é myoq mai akyap sû é wuí gyó byuq mù, yhang myoq dum wó myâng bê. Haú hkûn, yhang gi, toq mù wui-myhup hkâm yù luî, ");
INSERT INTO atbNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","zoshuq lé zo mù, wum-o dum lhoq pyîng yù bê nghut ri. Hau htâng, yhang gi, Damaskuq myuq mâ é chángzô pé eq rahá rayoq zo zùm yap nyì uchyang, ");
INSERT INTO atbNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yesuq gi, Garai Gasâng é Yhangzo nghut é hkyô, haú hkûn jáng tarajong pé má hko kyô nyì bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sholuq é dang lé wó gyô é lhunglhâng bang gi, maú byuq bùm kômù, \"Shí yuq gi, Yerusalem wà mó má myìng haû lâng é bang lé lhoq hten lhoq hpyoq sû nghut lhê, a nghut kó lhú? Ahkuî, shî má le, haû su é bang lé chyup yû mù, hkyangjong agyi pê chyáng ló ap râ da luî jé lé é sû a nghut kó lhú?\" ga myi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sholuq kúm gi, a-tsam je bo lò mù, Damaskuq myuq má nyi é Yudaq byu pé lé taî hpyi kyo luî, Yesuq gi, Hkrisduq yhang nghut nyi é hkyô lé saksé tûn shit ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Buinyí tsómra myáng é htâng má, Yudaq byu pé gi, yhang lé sat pyám râ matú haq dâ akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nghut kôlhang, yhangmoq dâ é hkyô lé Sholuq sê pyâm ri. Yhangmoq gi, yhang lé wó sat pyám shoq ga, nyí lé myín lé myuq hkum pé má lhom nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sholuq é chángzô pé kúm gi, myín má yhang lé shuî yù mù, manghkoq má lúng nhâng luî, wà kyám xewâm mai lhoq nyhum hkyô kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hau htâng, yhang gi, Yerusalem wà mó má jé lo é hkûn, chángzô pé eq zùm yap râ matú shikut wú kôlhang, yhang gi, chángzo dut bê hkyô lé a jíng kô é yanmai, lhunglhâng bang gi, yhang lé gyuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnaba kúm gi, Sholuq lé lagyô pê chyáng shuî lò mù, Sholuq, hkyô má Yesuq eq hkâsu kut huî é hkyô lé le, Yesuq èq yhang lé taî é dang wó gyô é hkyô lé le, Damaskuq myuq má Yesuq é myìng mai gyuq myit a bo é za hkâsu kut hko kyô é hkyô lé le, yhangmoq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Haû mù, Sholuq gi, yhangmoq eq rahá Yerusalem wà mó má htoq htoq wàng wàng kut nyî uchyang, Yhumsîng é myìng mai a gyuq a kyum é za hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Grik dang nyo é Yudaq byu pé eq le, taî he lhûm nyi akô; nghut kôlhang, yhangmoq gi, yhang lé sat pyám râ dâ akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Haú hkyô lé, gumang wuì sé kôjáng, yhang lé Kesare wà mó má jé shoq dé mù, Tarshu myuq shut nhang kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yuda mau, Galile mau eq Samariq mau jowò hkangmó mâ é noqkuq hpúng gi, haú yoq pé má, lhoq ging lhoq tîng é hkyô wó yû mù, nguingón nyi akô; haû Yhumsîng lé gyuq hkunggâ é hkyô má le, Chyoiyúng Woi-nyí èq lhoq pun lhoq kyîng é hkyô pé má le châng nyì mù, myô jat lo bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Haú hkûn, Petruq gi, haú mau pé má hkat kûm wún uchyang, Ludaq wà mó má nyi é sân-yúng bâng chyáng ê jé ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Haú wà má, gùngjum shî luî shit zân tup yhupjang mai a wó toq é Ainea gâ é byù rayuq lé ê myang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Haû mù, Petruq gi, \"Ainea ê, Yesuq Hkrisduq, nang lé lhoq gê byi bê nghut ri, toq mù, náng é yhuphpú hen yù aq.\" ga luî, yhang lé taî ri. Haú hkûn jáng, Ainea wó toq yap bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ludaq eq Sharon pá má nyi é lhunglhâng bang gi, haú yuq lé myàng mù luî, Yhumsîng Yesuq chyáng lhing wang lo bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ahkuî, Yopa myuq má Tabihta gâ é chángzo myiwe rayuq nyi ri; myìng haû lé Grik dang dông gi, Dorka gâ é nghut lhê. Myiwe haû gi, ge é muzó kut nyi é sû eq, asho awuî bang lé alu byî nyi é sû nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Haú u lé, yhang gi, nòhpyo hui mù shi ló bê nghut ri. Yhâng màng lé gi, chi mù luî ahtoq gok má jang tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ludaq wà mó gi, Yopa myuq eq chyáng é yanmai, haú myuq má Petruq nyi é lé chángzô pé wó gyo kôjáng, yhangmoq gi, byù í yuq lé nhang kat mù, \"Ngamoq chyáng myap lé lô aq.\" ga jì nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Haú hkûn, Petruq gi, toq mù, haú nhik htâng châng e ló ri. Yhang jé jáng, ahtoq pyâm gok má shuî hâng yu akô. Chuimó myhî pé lhunglhâng bang gi, yhâng nàm má yap mù ngaù uchyang, yhangmoq eq rahá nyi tô ashî hkûn Dorka hkyup é buhîng eq gotû mebu pé lé tûn shit nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petruq kúm gi, lhunglhâng bang lé htoq ló nhâng mù, hkyihput htuq luî, kyûdung mù, màng shut lhing wú luî, \"Tabihta ê, toq aq!\" ga taî ri, haú hkûn myiwe haû myoq hpóng lô mù, Petruq lé myàng jáng, toq zung lo ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petruq gi, loq lhâm kat mù yhang lé lâng toq yù luî, lumjíng bang eq chuimó myhî pé lé wut yù mù, duì gû ap byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Haú hkyô lé, Yopa myuq mâ é bang banshoq wó gyô ló kômù luî, byù myo myo gi, haû Yhumsîng Yesuq lé lumjíng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Haû mù, Petruq gi, shokuq loqmú saî é Simun ga sû eq rahá, Yopa myuq má rayoq zo nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ahkuî, Kesare wà mó má gyezo rashô up é Koneli gâ é gyezau rayuq nyi ri. Yhang gi, Itali gyedap mâ é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yhang gi, tarâ hkungga myit bò luî, yhâng é yhumbyù banshoq bang eq rahá Garai Gasang lé gyuq hkunggâ nyi lhê eq, myùng bang lé alu myo myo byi uchyang, Garai Gasang lé hkâ-nhám le kyûdûng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ra-nyí lé, myinhtâng sum hkyíng kô má, Garai Gasâng é maumang lagyo rayuq gi, yhâng chyáng jé mù, \"Koneli ê.\" ga luî, yhang lé wut é lé, shing-rán mai de de myang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Haû mù, haú yuq lé wú tsuq to mù, \"Yhumsîng ê, hai hkyô nghut lhê lhú?\" ga gyuq myit eq myî ri. Maumang kúm gi, \"Náng é kyûdung dang eq alu byî é hkyô gi, Garai Gasâng é hí má, hkungga masat dông hkyâng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ahkuî, Yopa myuq shut byù nhang kat mù, Petruq gâ é sû Simun lé ê shuî lò nhâng aq. ");
INSERT INTO atbNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yhang gi, wuimau yàm mâ é, shokuq hkyup zô é Simun yhûm má bíng nyi ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Koneli gi, yhang eq dang taî é maumang lagyo ló byuq jáng, dui-nhâng zoshâng í yuq eq, yhâng chyáng hkâ-nhám le châng nyi bang mâ é, tarâ hkunggâ é gyezo rayuq lé ji yù mù, ");
INSERT INTO atbNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","dut laî lo é hkyô banshoq, yhangmoq lé taî kyo luî, Yopa myuq shut nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Htang nyí nyí-káng u lé, yhangmoq, Yopa myuq jé ló yâm má, Petruq gi, kyûdung râ ga, yhumhkûng shut doq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Haú hkûn, yhang gi, zòmut luî rajung jung zô nau nyi ri; nghut kôlhang, zoshuq ru gaí nyi ashî le, yhang moq byuq ló mù myoqwup shing-rán myang é gi, ");
INSERT INTO atbNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","mauhkûng bóng lô mù, hpajóng mó sû é lé, myi chyûn má zui luî myigùng shut lhoq hkyô kat é azíng lé myang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Haú hkaû má, myigùng htoq mâ é hkyî myi hkyî dap é jung dusak ahú hú eq dô yê é jung ahú hú, mau má dang é nghoq ahú hú, lúng tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","\"Petruq ê, toq mù, sat zo aq.\" gâ é danghtê le mying htoq lo ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petruq kúm gi, \"Yhumsîng ê, haû gi, a wó dut, achaq achyut é eq a sansêng é zè lé, ngò hkâ-nhám le a zô wú.\" ga tû taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Haú hkûn, \"Garai Gasang lhoq san lhoq séng bê zè lé, a sanséng hkâ-nghû.\" ga luî, yhang lé dum taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Haû su ga sum dâm taî é htâng má, zè haû lé radá dâm mauhkûng shut wup yu ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ahkuî, Petruq gi, yhang myang é shing-rán lé haî wá nghut lhê lhú ga luî, myit maú nyi é hkûn, haû Koneli nhang kat é bang gi, Simun é yhûm lé myang hô kômù, hkumtot má yap to luî, ");
INSERT INTO atbNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Petruq gâ é sû Simun, yhûm haú má nyì a nyi é lé, wut myî wú akô. ");
INSERT INTO atbNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petruq gi, shing-rán haû lé ru myit wú nyi ashî le, Woi-nyí gi, \"Wú aq, byù sum yuq nang lé ho nyi akô, toq mù gyó ló aq; ");
INSERT INTO atbNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","yhangmoq gi, ngò nhang kat é bang nghut é yanmai, myit haî a úng-âng é za, yhangmoq eq rahá bo ló aq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Haû mù, Petruq gi, haú bâng chyáng gyó ló luî, \"Nungmoq hô nyi é sû gi, ngò nghut lhê, haî ra luî lé kô é lhú?\" ga myî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yhangmoq taî é gi, \"Dingmán é, Garai Gasang lé gyuq hkunggâ é, Yudaq amyû lhunglhâng bâng é hí má myoqdong wó é, shô up gyezau Koneli gi, nang lé yhâng é yhûm má ji hâng yù mù, nàng taî é dang gyo yù râ matú, yhang lé chyoiyúng maumang lagyô èq taî shit kyô é hkyô lé wó yû luî, ngamoq lé nhang kat é nghut lhê.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Haû mù luî, Petruq gi, yhangmoq lé wut hâng yù mù, bíng nhang ri. Hau htang nyi, yhang gi, toq mù, yhangmoq eq rahá bo ló ri; Yopa myuq mâ é gumang wuì ra-am le châng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Hau htang nyí, yhangmoq gi, Kesare wà mó shut wang ló akô. Koneli gi, yhâng é gumang wuì eq buinùm ji-myi wuì lé ji tsîng to mù, yhangmoq lé láng nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petruq wang ló jáng, Koneli gi, te yù mù, yhâng é hkyî wang má paî gop noqkuq ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petruq kúm gi, \"Toq aq, ngò le byù ru nghut lhê.\" ga luî, taí uchyang yhang lé tu toq ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Haû mù, Petruq gi, yhang eq dang nyô uchyang wang ló wú le, byù myo myo zup zîng tô bum é lé myang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Haú hkûn, yhang gi, yhangmoq lé, \"Yudaq byù rayuq gi, noqkuq htûng dông tûngbaù rayuq eq a wó zùm yap é, htoq htoq wàng wàng a wó kut é hkyô lé, nungmoq sé lugù nghut akô. Nghut kôlhang, ó yuq lé le achaq achyut dut ri, a sanséng dut ri nghû a ge taî é hkyô lé gi, Garai Gasang, ngo lé tûn shit bê. ");
INSERT INTO atbNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hau é yanmai, nungmoq ngo lé ji kat é hkûn, ngò a he pyâm é za châng lé lo é nghut lhê. Haû mù luî, haî ra kô é yanmai, ngo lé ji akô nghû ngò myí nau ri.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Haú hkûn, Koneli gi, \"Laî lò bê myi nyí nyí, myinhtâng sum hkyíng má, ngá é yhûm má, ngò kyûdûng nyi le, danso loq, duqbó é mebu wut é byù rayuq ngá é hí má yap htoq shit mù, ");
INSERT INTO atbNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","'Koneli ê, Garai Gasang gi, náng é kyûdung danghtê lé le gyo byi bê; nàng alu byî é hkyô lé le, bun byi bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hau é yanmai, Yopa myuq shut byù nhang kat mù, Petruq gâ é Simun lé ji nhâng aq. Haú yuq gi, wuimau yàm mâ é shokuq hkyup zô é Simun yhûm má bíng nyi ri.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Haû mù luî, haú hkûn jáng ngò náng chyáng byù nhang kat bê nghut lhê. Ahkuî, nàng jé é gi, gyai gê bê nghut ri. Yhumsîng yhang nang lé taí nhang é gû banshoq gyô yù râ matú, ahkuî ngamoq lhunglhâng bang Garai Gasâng é hí má nghut nyi lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Haú hkûn, Petruq dang-hi hpông é gi, \"Garai Gasang, myoqdong a hkyin é hkyô lé, ahkuî ngò gè gè yhang sé bê. ");
INSERT INTO atbNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Byù myû chângjup má, Yhang lé gyuq hkunggâ é eq tengmán é muzó jizó saî é sû gi, Yhang é hí má myoqdong wó nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nyì mi-nyì, joq mijoq é Yhumsîng, Yesuq Hkrisduq é yanmai, nguingón hkyô eq sêng é gabú danglù lé hko kyo sháng gaq ga, Israelaq byu pê chyáng Garai Gasang hun kat é mungdang eq rajung za, ");
INSERT INTO atbNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","baptisma hkyô lé, Yohan hko é htâng, Galile mau mai Yuda mau banshoq má taî pyo ló é hkyô lé, nungmoq sé gû nghut nyi lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Haû gi, Garai Gasâng èq Chyoiyúng Woi-nyí eq wum-o a-tsam byî to bê sû, Nazaret wà byù Yesuq é hkyô nghut nyi ri. Garai Gasang yhang eq rahá nghut nyi é yanmai, yhang gi, ge é muzó lé kut wún é eq, nat èq zing-ri huî é bang banshoq lé lhoq gê byî wún ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Haû mù, Yudaq byu pê é ming má le, Yerusalem wà mó má le, yhang zui saí bê muzó banshoq é saksê pé gi, ngamoq nghut nyi lhê. Haú yuq lé yhang, yhangmoq sik zîng má jén sat pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Garai Gasang kúm gi, sum nyí nghû râ buinyì má, haú yuq lé lhoq dui toq kat é nghut mù luî, byù banshoq é hí má a nghut e za, saksé kut râ matú Garai Gasang hkyin to gù nghut é bang ngamoq é hí má za htoq shit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Yhang shi é mai dum dui toq ló é htâng má, ngamoq yhang, Yhang eq rahá razo rashuq wó kut yu é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yhang gi, asak dui é bang eq shî bê bâng é tarâ agyì kut râ matú, Garai Gasâng èq Yhang lé hkyin tô é sû nghut é hkyô lé, byu pé lé hko kyo râ eq, saksé hkám râ matú, ngamoq lé hkunmó hkyô to bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","'Yhang lé lumjíng é bang yuq hkangmó gi, Yhâng é mying é yanmai, yubak hkyut pyám byî é hui kó râ nghut lhê.' ga luî, taî é myiqhtoi banshoq gi, Yhâng é hkyô lé saksé hkam byî é bang nghut nyi akô.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petruq gi, haú hkyô lé ru taî nyi ashî le, dang haû wó gyô é banshoq bâng ahtoq má Chyoiyúng Woi-nyí gyó jé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tûngbaù pê é htoq má lháng Chyoiyúng Woi-nyí gâ é chyunghuq lé hut hkyô kat é yanmai, Petruq eq rahá lé é, ahpyo-kuq hpyit bê é lumjíng bang Yudaq byu pé gi, maú bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hkâsu mù gâ le, yhangmoq gi, laklaí dang nyo é lé le, Garai Gasang lé hkya-on kô é lé le, wó gyô bùm kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Haû mù, Petruq gi, \"Ngamoq su Chyoiyúng Woi-nyí hkâm yù bê bang lé, baptisma a byi nhâng râ gi, wuì lé ó yuq wó hkûm to râ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hau htâng, yhang gi, yhangmoq lé Yesuq Hkrisduq é myìng lang luî wui-myhup hkâm yù râ matú pyîng tô ri. Haú hkûn, yhangmoq gi, Petruq lé buinyì ra-í nyí, nyi gyó shi aq ga chôm hkûm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tûngbaù pé le, Garai Gasâng é mungdang lhom yù bê gâ é hkyô lé, lagyô pé eq Yuda mau pé mâ é gumang wuì wó gyô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Haû mù, Petruq, Yerusalem wà mó má doq ló é hkûn, ahpyo-kuq hpyit hkyô lé myit zuq é lumjíng bang gi, ");
INSERT INTO atbNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","\"Nàng gi, ahpyo-kuq a hpyit é bâng é yhûm má wàng mù, yhangmoq eq razo rashuq kut ri.\" ga luî, yhang lé mara lhom taî hun bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Haú hkûn, Petruq gi, haû dut lò bê hkyô lé awang mai ahpyo hpyot, yhangmoq lé taî sân kyô hi kat é má, ");
INSERT INTO atbNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","\"Ngò gi, Yopa myuq má kyûdûng nyi le, moq byuq ló mù shing-rán myang é gi, mauhkûng mai hpajóng mó sû é myi chyûn shut zui luî, ngá shut lhoq hkyô kat é zè gyó jé lo é lé, myang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Haû lé rago za saî wú le, myigùng htoq má hkyî myi hkyî dap é jung dusak, yosô zè, dô yê é jung eq, maulat nghoqzô pé bo tô é lé, ngò myàng luî, myit wú nyi é hkûn, ");
INSERT INTO atbNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","'Petruq ê, toq mù, sat zo aq.' gâ é danghtê lé, ngò wó gyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ngò kúm gi, 'Yhumsîng ê, haû gi, a wó dut, achaq achyut é eq a sansêng é zè, ngá é nhut má hkâ-nhám le a wang wú.' nghû taî kat é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Haú hkûn, 'Garai Gasang lhoq san lhoq yúng bê zè lé, a sanséng hkâ-nghû.' ga luî, mauhkûng mai dum taî kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Haû su ga sum dâm taî é htâng má, haú pé banshoq lé mauhkûng shut dum wup yu ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Haú hkûn jáng, Kesare wà mó mai, ngá chyáng nhang kat é byù sum yuq gi, ngò nyi é yhûm hkumtot má jé nyi tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chyoiyúng Woi-nyí gi, ngo lé myit a úng-âng é za, yhangmoq htâng châng ê aq ga taî ri; shî gumang hkyuq yuq le ngò eq rahá ê mù, Koneli é yhûm má ngamoq wang é. ");
INSERT INTO atbNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Haú hkûn, haú yuq gi, yhâng é yhûm má maumang lagyo lé htoq shit é hkûn, yhang hkâsu myang é hkyô lé le; maumang lagyô èq yhang lé, 'Yopa myuq shut byù nhang kat mù, Petruq gâ é sû Simun lé ê jî nhâng aq; ");
INSERT INTO atbNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","nàng eq náng yhumbyù lhunglhâng bang hkyi yù hui râ danglù, yhang, náng chyáng wun lé lô byi râ nghut lhê.' ga taî é hkyô lé le, ngamoq lé taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ngò dang taî hi ló nyi é u lé, Chyoiyúng Woi-nyí gi, sâng-hi lé ngamoq é ahtoq má gyó lé é su, yhangmoq ahtoq má le gyó lé bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Haú hkûn sheq, ngò gi, 'Yohan gi, wuì èq wui-myhup hkám byî ri; nungmoq kúm gi, Chyoiyúng Woi-nyí èq wui-myhup hkám byî é hui kó râ nghut lhê.' ga luî, Yhumsîng taî é dang lé bûn kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Haû mù luî, Yhumsîng Yesuq Hkrisduq lé lumjíng é hkûn, ngamoq lé Garai Gasâng jeju chyunghuq byî é su, Yhang, yhangmoq lé le byî é nghut le gi, ngò gi, hkasû é byù nghut luî, Garai Gasang lé wó lhom hkûm pyám râ lhú?\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yhangmoq gi, haú hkyô lé wó gyo kôjáng, taí jang a joq lo kômù, \"Ó! Nghut bê, Garai Gasang gi, tûngbaù pé lé le, asak duì râ matú myit lhîng hkyô byi bu-nhung!\" ga luî, Garai Gasang lé chôm hkya-ôn akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ahkuî, Stehpan lé sat pyám kô é htâng má, zing-ri hui kô é yanmai, byo myín ló é bang gi, Hpinisi mau, Kupru zinlóng eq Antioku wà mó jé shoq byo ló kômù, Yudaq byu pé lé baú za, mungdang haû hko kyô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nghut kôlhang, yhangmoq mâ é Kupru byù eq Kuruni byù ra-am gi, Antioku wà mó má châng jé ló kômù, Yhumsîng Yesuq é gabú danglù lé, Grik pé lé le taî kyô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Haû Yhumsing é loq gi, yhangmoq eq rahá nghut nyî mù luî, byù myo myo gi, lumjíng mù, Yhumsing chyáng lhing wang lo bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Haú bâng é hkyô lé, Yerusalem noqkuq hpûng é no má hkyang jé ló é nghut mù luî, yhangmoq gi, Barnaba lé Antioku wà mó jé shoq nhang kat akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yhang jé é hkûn, Garai Gasâng jeju bo nyi é lé myàng jáng, yhang gi, gabú luî, yhangmoq é myit nhiklhum banshoq èq haû Yhumsîng má lhumzuî nyì râ matú, lhunglhâng bang lé myit wum byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Hkâsu mù gâ le, Barnaba gi, byù gè nghut mù, Chyoiyúng Woi-nyí le, lumjíng myit le byíng tô é sû nghut nyi ri. Haû mù, byù myo myo gi, haû Yhumsing chyáng jat wang lo bùm bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hau htâng, Barnaba gi, Sholuq lé ê hô râ ga Tarshu myuq shut ê mù, yhang lé myàng jáng, Antioku wà mó má shuî lo ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Haû mù, yhangnhik gi, razàn gón noqkuq hpúng haû eq rahá zum nyì kô é nghut mù luî, byù myo myo lé wó mhoqshit akô. Chángzô pé gi, Hkristan gâ é myìng lé, Antioku wà mó má sâng-hi wó yù bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Haú u lé, myiqhtoî pé ra-am gi, Yerusalem wà mó mai, Antioku wà mó má lé jé bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Haú bang mâ é Agabu gâ é sû gi, toq yap mù, Romaq mingkan tîng má mutmó gyó lô râ nghut é hkyô lé, Woi-nyí èq tûn shit é dông taî kyô ri; (Haû gi, hkohkâm Klodi é pyat má dut bê nghut lhê.) ");
INSERT INTO atbNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Haû mù luî, chángzô pé gi, Yuda mau mâ é gumang wuì lé, ó le ó wó dut é myhó garum kat râ ga, myit hpyit yu bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Haû eq rajung za kut kômù, yhangmoq gi, chyunghuq haú pé lé Barnaba eq Sholuq nhik é loq mai suwún wui pê chyáng hun kat bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Haú u lé, Herut hkohkâm gi, hpúng byû ra-am lé chyup yû mù, zing-ri râ ga ngantsâ nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Haû mù, Yohan é yhangmang Yakuq lé sham èq sat pyám nhang ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Haú hkyô lé Yudaq byu pé wú gabú é lé myàng jáng, yhang gi, Petruq lé le, jâng chyup yu ri. Haû dut é gi, mún a kat é muk zo poî u lé nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herut gi, Lhoqlhai Poî lai jáng sheq, mingbyû wui hí má jéyáng râ ga myit tô é yanmai, yhang lé chyup yu é htâng má, htóng má lhûng to mù, yhang lé zúng râ matú, gyè myi yuq yuq kut myi hpúng lé ap tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Haû mù, Petruq gi, htóng má lúng tô ri; hpúng byû wuì kúm gi, yhang é matú Garai Gasâng chyáng kyû gyai chôm dung byî nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Petruq gi, Herut èq yhang lé jéyáng râ matú she htoq yû râ hî myìn lé, shamtoq-tui í hkat èq tuî é hui luî, gyezo í yuq é gyoro má yhup myhî tô ri; zúng é bang le htóng hkum má zúng nyi bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Haú hkûn, Yhumsing é maumang lagyo rayuq lé htoq shit mù, gok haû má duqbó lo ri. Maumang lagyo haû gi, Petruq é namcham má ê hpuk kat mù, \"Myap toq wú aq.\" ga nhaû ri; haú hkûn, Petruq é loq mâ é toqjâng tui pé le gyut gyó ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Maumang dum taî é gi, \"Hpyihit hit mù, hkyî-tsung tsung aq.\" gâ ri; Petruq le taî é eq rajung za kut ri. \"Náng é bumó wut mù ngá htâng cháng aq.\" ga yhang lé maumang lagyo dum taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Haú hkûn, yhang gi, htóng mai yhâng htâng châng htoq ló ri; nghut kôlhang, maumang lagyo kut é muzó haû gi, gè gè nghut é lé, yhang a sé mù, shing-rán myang é nghut ri ga myit yu ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ahkuî, yhangnhik gi, zúng tô é jowò í wô lai mù, wà má htoq é shamtoq hkum má jé jáng, hkum haû le yhang baú bóng lô mù, yhangnhik htoq luî, wà hkyô rahkat má sô ló le, maumang lagyo gi, haú hkûn jáng, yhâng chyáng mai gâng ló byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ahkuî, Petruq gi, dum bûn gyîng lò jáng, \"Yhumsîng gi, Yhâng é maumang lagyo lé nhang kat mù, Herut é loq eq Yudaq byu pé myit myoqbyù tô é hkyô banshoq mai, ngo lé hkyi yù bê nghut é lé, ahkuî ngò gè gè sé bê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Haú hkyô lé myit sê kat jáng, yhang gi, byù myo myo zing mù, kyûdûng nyi é jowò, Markuq gâ é Yohan é yhângnu Mariq é yhûm má jé ló ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Haû mù, yhang gi, yhûm wàng hkum lé ló bat é hkûn, Roda gâ é dui-nhâng zoshâng myiwe zo rayuq gi, gyô wú râ ga htoq lé lo ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Yhang gi, Petruq é htê nghut é lé sê gyô kat jáng, lûm gabú luî hkum a hpóng byi shî é za, yhúmhkaû shut din wang ló mù, \"Petruq gi, hkum mhó lut má lo yap tô ri.\" ga ló taî kyô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yhangmoq kúm gi, \"Nàng na bê nghut ri.\" ga yhang lé taî akô. Yhang gi, gè gè nghut ri ga ru taî nyi ri. Dum, yhangmoq gi, \"Yhâng é maumang lagyo nghut âng ri.\" ga taî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nghut kôlhang, Petruq gi, hkum ru bat nyî mù, yhangmoq hpông kat é hkûn, yhang lé myàng kôjáng, chôm maú byuq bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yhang gi, yhangmoq lé zim za nyì keq ga loq lik shit mù, yhang lé Yhumsing èq htóng mai hkâsu kut shuî htoq yu é hkyô lé taî kyo luî, \"Shí hkyô lé Yakuq eq gumang wuì lé taî kyô kat keq.\" ga taî ri. Hau htâng, yhang htoq ló luî, jowò gó shut e ló bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ahkuî, maubó jáng, gyezô pé gi, Petruq haî dut byuq é hkyô lé a sé kô é yanmai, gyai maú gabyông bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herut kúm gi, Petruq lé ho wú le a myàng jáng, zúng é bang lé myî gôn wú mù, yhangmoq lé sat pyám râ matú hkunmó hkyô ri. Hau htâng, yhang gi, Yuda mau mai Kesare wà mó má gyó ló mù ló nyi nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Haú gyoro má, Herut hkohkâm gi, Turuq eq Sidun byu pé lé gyai nhik-yô nyi ri. Haû mù luî, yhangmoq gi, myit rahkat zâ èq yhâng chyáng ê mù, Blastu gâ é, hkohkâm wa lum tô é suwún hpó lé ê lûm hkaû mù, simsaq hkyô ê dûng akô. Hkâsu mù gâ le, yhangmoq é zoshuq wó râ matú gi, Herut é ming lé lùm hkaû nyì kô é yanmai nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Haú hkûn, ding lhûm tô é buinyì má, Herut gi, hkohkâm hking wut chûng mù, hkohkâm tanghkuq má zùng luî, yhangmoq lé hkohkâm mungdang byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Haû jáng, mingbyû wuì gi, \"Htê shî gi, waxâng byu é htê a nghut, garai wá é htê sheq nghut ri.\" ga garû bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Radá dâm, Herut gi, Garai Gasâng é hpungwup shingkang lé a tê byî é yanmai, Yhumsing é maumang lagyo gi, yhang lé dàm byi luî, yhang gi, luq èq hkê é hui mù, shi byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Haû Garai Gasâng é mungdang gi, sê é bang myô jat lò mù, je riyhang byo myín lô bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba eq Sholuq nhik gi, Yerusalem wà mó má yhangnhik saî tûm nyi é muzó ban saí jáng, Markuq gâ é Yohan lé shuî chûng mù, Antioku wà mó shut taû ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ahkuî, Antioku wà mó mâ é noqkuq hpúng má, myiqhtoî pé eq sará pé le lom nyi akô. Haú bang gi, Barnaba, Niger gâ é Simeon, Kuruni byù Luki, (Herut zau hpó eq zum kô lò sû) Manaen eq Sholuq pé nghut akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yhangmoq gi, zoshuq gám luî Yhumsîng lé noqkuq dojaú nyi é hkûn, Chyoiyúng Woi-nyí gi, \"Ngá é mû wùn waq râ matú ji tô é Barnaba eq Sholuq nhik lé, hkyin to keq.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Haû mù luî, yhangmoq gi, zoshuq gám luî kyûdung mù, yhangnhik ahtoq má loq ke byi kô é htâng, yhangnhik lé nhang htoq kat akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Haû mù, yhangnhik gi, Chyoiyúng Woi-nyí èq nhang kat é eq rajung za, Seluki wà shut gyó ló mù, haû mâ é lhaî ji luî, Kupru zinlóng má jé ló luî, ");
INSERT INTO atbNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salami wà mó má nyi nyi é hkûn, Yudaq byu pê é tarajong pé má, Garai Gasâng é mungdang hko kyô akô. Markuq gâ é Yohan le yhangnhik lé htuqluq htuqbang kut nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yhangmoq gi, haû zinlóng mai laî byit e ló mù Pahpu wà mó jé ló kô é hkûn, myiqhtoi pyoq nghut sû Bara-Yesuq gâ é Yudaq byù myoqheq sará rayuq eq htûng hui akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Haú yuq gi, Sergi Poluq gâ é, myit hpaqchyî kûng é ginwáng zau hpó é byù rayuq nghut lhê. Minggyì hpó haû gi, Garai Gasâng é mungdang gyô yù naù mù, Barnaba eq Sholuq nhik lé ji yu ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Haú hkûn, myoqheq sará gâ é lichyúm dông myhîng é Eluma le gâ é Bara-Yesuq kúm gi, ginwáng zau hpó lé haû lumjíng hkyô má a jau ló nhâng nau é nghut mù luî, yhangnhik lé lhom he tang pyâm ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Haú hkûn, Poluq le gâ é Sholuq gi, Chyoiyúng Woi-nyí byíng mù, yhang lé wú tsuq to luî, ");
INSERT INTO atbNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","\"Myit goí é hkyô eq hpuq lô lhik é hkyô banshoq byíng tô é, nat é yhangzo nghut sû, tengmán hkyô hkangmó é gyè hpó ê, Yhumsing é tengmán hkyô lé a lhoq hpyoq é a wó nyî lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ahkuî, wú aq, Yhumsing é loq gi, náng chyáng jé mù, nàng gi, rayoq zo builoq a wó myang é za, myoqjit byuq râ nghut lhê.\" ga taî ri. Haú hkûn jáng, yhâng é myoq gi, myhì-myhà ga luî mauchut tuq dut lò byuq ri; haû mù, yhang lé shê râ byù ho sop lhîng wún ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Haú hkyô lé ginwáng zau hpó myàng jáng, Yhumsîng eq sêng é mhoqshit é hkyô lé wú maú luî lumjíng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Hau htâng, Poluq eq yhâng luzúm wuî gi, Pahpu wà mó mai lhaî ji mù, Pamhpuli mau mâ é Perga wà má jé ló akô. Markuq gâ é Yohan kúm gi, yhangmoq eq gang luî, Yerusalem wà mó shut taû lú byuq bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dum, yhangmoq gi, Perga mai toq e ló le, Pesidi ginwáng mâ é Antioku wà mó má jé ló akô. Bánno buinyì má, yhangmoq gi, tarajong má wang zung tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Haú hkûn, Mosheq é tarâ laiká eq myiqhtoi laiká pé lé ban nghap jáng, tarajong má up bang gi, \"Gumang wuì ê, mingbyû wuì lé myit wum byi dang joq kô é nghut le gi, ahkuî taí lo keq.\" ga luî, yhangmoq chyáng taí nhang kat ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Haú hkûn, Poluq gi, toq yap mù, zîm byuq kó sháng gaq ga loq tû luî, \"Israelaq byu pé eq Garai Gasang lé gyuq hkunggâ é byu pé ê, chôm gyô yù keq. ");
INSERT INTO atbNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelaq byu pê é Garai Gasang gi, ngamoq é îchyí îkê pé lé hkyin yù bê nghut mù luî, Egutuq ming má byùbíng dut nyi to ashî hkûn, yhangmoq lé kô myhâng nhâng mù, hpungwup a-tsam bo é loq èq haú mau mai shuî htoq ló ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dum, myi xê zàn kô, yoso pé má yhangmoq é a‑kyang lé jân pyám byi mù, ");
INSERT INTO atbNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Hkanan ming mâ é byuhú nyhit hú lé lhoq htên pyám luî, haú bâng é mingdán mâ é silí wunlí yhangmoq lé gàm byî ri. Haû gi, myi shô ngo xê zàn kô myáng ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hau htâng má, Garai Gasang gi, myiqhtoi Samuelaq é pyat jé shoq tarâ agyì pé lé to byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hau htâng má, yhangmoq mai hkohkâm dung kômù, Garai Gasang gi, yhangmoq lé, Ben-yamyin amyû mâ é, Kisha é yhangzo Sholuq lé byi luî, yhang gi, myi xê zàn up bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hau htâng, Sholuq lé lhoq hkyô pyám mù, Dawiq lé, yhangmoq é hkohkâm kut nhang ri. Dawiq é hkyô lé Yhang saksé hkâm é gi, 'Ngò nhik dik é Yese é yhangzo Dawiq lé myàng bê; yhang gi, ngò kut nhang é hkyô banshoq lé kut râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Garai Gasang gi, Yhâng é danggidiq joq é eq rajung za, Israelaq byu pê é matú, haú yuq é awut ashín mai, hkyi yù Sû Yesuq lé, pô htoq nhâng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuq a jé lé shimá, Yohan gi, Israelaq byu pé banshoq lé myit lhîng hkyô eq sêng é baptisma hkyô lé hko kyo bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Dum Yohan gi, yhang zuî é muzó ban ló é u lé, 'Ngo lé ó nghut é su ngâm tô akô lhú? Ngò gi, haú yuq a nghut, wú keq, ngá é htâng má rayuq jé râ nghut lhê, haú yuq é hkyî-tsung tui hpyî râ lháng ngò a gíng.' ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abraham é yhangzo yhangshû pé eq Garai Gasang lé gyuq hkunggâ é tûngbaù, gumang wuì ê, shî hkyi yù hkyô mungdang lé, nga-nhûng chyáng byi kat bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem wà mó mâ é bang eq, yhangmoq é zau suwún wuî gi, Yhang hkyi yù sû nghut é lé le, Bánno buinyì hkangmó nghap é myiqhtoî pê é dang lé le, a sê gyo kô é yanmai, Yesuq lé sat râ doqdân é hkûn, myiqhtoî pê é dang lé lhoq dik pyám bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yhâng chyáng shî gíng é mara a myàng kôlhang, Yhang lé sat pyám nhâng râ matú, Pilat chyáng dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yhangmoq gi, yhang eq séng luî, kâ to má kâ to ban lhoq dik kôjáng, Yhang lé tapzîng mai yu hkyó mù, lup má kat tô akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Garai Gasang kúm gi, Yhang lé shi é mai lhoq dui toq yû bê nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yhang gi, Galile mau mai Yerusalem wà mó jé shoq, hí lé Yhâng htâng châng é bâng chyáng buinyì tsómra myáng shoq htoq shit shit kut ri. Haú bang gi, ahkuî, nga-nhúng Israelaq byu pê é hí má, Yhâng é saksé dut bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Haû mù, í dam lhê é Hkya-on Kungtôn Laiká má, 'Nàng gi, Ngá Zo nghut ri. Hkû-nyí, Ngò gi, Náng Wa dut bê nghut lhê.' ga luî, kâ tô é eq rajung za, ");
INSERT INTO atbNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Garai Gasang gi, îchyí îwâ pé lé byi tô é danggidiq lé, Yesuq lé lhoq dui toq byî é dông, yhangmoq é yhangzo yhangshu ngamoq é matú, lhoq dik byî é gabú danglù lé, nungmoq chyáng ngamoq wun lé byi bê. ");
INSERT INTO atbNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Hau htoq agó, Yhang htên byoq é hkâ-nhám a hui shoq, shi é mai lhoq dui toq yû râ hkyô eq séng luî, Garai Gasang taî é gi, 'Dawiq lé byî tô é danggidiq eq rajung za, chyoiyúng é eq lumgíng é jeju lé, ngò nungmoq lé byi râ nghut lhê.' gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hkya-on Kungtôn Laiká gó wô má le, 'Náng é Chyoiyúng Sû lé, Nàng htên byoq nhâng naù râ a nghut.' ga taí tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ahkuî, Dawiq gi, yhâng é pyat banshoq má Garai Gasang ô nau é dông ban wùn waq jáng, shi byuq luî, îchyí îwâ pé eq rahá myhup pyám hui mù, htên byoq byuq é hui bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Garai Gasang lhoq dui toq yu é sû kúm gi, htên byoq huî é a nghut. ");
INSERT INTO atbNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Haû nghut é yanmai, gumang wuì ê, haú yuq mai yubak wó hkyut pyám byî é hkyô lé, nungmoq lé hko kyô nyi é nghut é le, sê nyì keq. ");
INSERT INTO atbNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Hau htoq agó, Mosheq é tarâ èq mara hkyut san byî é a hui kôlhang, haú yuq lé lumjíng é bang gi, hkyô lhumjup má mara hkyut san byî é hui râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hau é yanmai, 'Wú keq, jihpoî é bang ê, maú mù luî htum byuq keq; nungmoq é buinyì pé má ngò rajung jung kut htoq râ nghut lhê; ");
INSERT INTO atbNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","haú hkyô lé, rayuq yuq, nungmoq lé hkaî kyo kôlhang, jíng kó râ a nghut.' ga luî, myiqhtoî pé taî é dang, nungmoq má a ang sháng gaq, sidiq nyì keq.\" ga hko kyô nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ahkuî, Poluq eq Barnaba nhik tarajong mai htoq ló le, htâng lhê é Bánno buinyì má le, haú pé lé dum hkaî kyo râ matú yhangmoq chôm dûng akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chôm byo htoq ló kô é hkûn, Yudaq byu pé eq Yudaq noqkuq htûng má lhing wang lo é tarâ hkunggâ é byù myo myo gi, yhangnhik é htâng má châng bùm kô é nghut mù luî, Garai Gasâng jeju má gîng nyì râ matú, yhangnhik gi, yhangmoq lé lhoq pun lhoq kyîng akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hau htang lhê é Bánno buinyì má, Garai Gasâng é mungdang gyô yù râ matú, rawa bang aluq shoî banshoq, lé zup zîng to bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yudaq byu pé kúm gi, byù moq mó haû lé myàng jáng, manon myit baú byíng bûm kômù luî, Poluq taî é dang lé taî htîng é eq nhîng pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Poluq eq Barnaba le gyuq myit a bo é dông taî é gi, \"Garai Gasâng é mungdang lé, nungmoq lé hí taî kyo râ dut é yanmai, ngá-nhik taí bê nghut lhê. Nghut kôlhang, nungmoq gi, haû lé lhom he-ngik pyám kômù, ahtum abyuq é asak eq gingdán é dông yhumsing gùng lé a myit yù kô é yanmai, wú keq, ahkuî, ngá-nhik gi, tûngbaù pê shut lhing ló berâ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Hkâsu mù gâ le, haû Yhumsîng gi, 'Hkyi yù hkyô lé maumyî htum shoq wó chûng jé râ matú, Ngò, nàng lé tûngbaù pê é maubó dut nhâng bê.' ga luî, ngamoq lé hkunmó hkyó kat bê.\" gâ ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tûngbaù pé gi, dang haû lé wó gyo kôjáng, gabú é eq Yhumsing é mungdang lé hkya-on kungtôn nyi bum akô. Ahtum abyuq é asak lé wó râ matú hkyin to huî é lhunglhâng bang le, lumjíng bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yhumsîng é mungdang gi, haú ming gón jam lò bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yudaq byu pé kúm gi, Poluq eq Barnaba nhik lé zing-ri râ matú, aróng wó é myiwe wuì mâ é tarâ hkungga bang eq, haú wà mâ é suwún wuî lé, nhik lhoq yo kôluî, yhangnhik lé maukyo mai chôm hkat htoq pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Yhangnhik gi, yhangmoq lé a nau é hkyô tûn shit é dông, yhumsing é hkyî mâ é hpuilhaû lé yhangmoq chyáng ko hkyô pyâm to kômù, Ikoni wà mó shut ló byuq bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Chángzô pé kúm gi, gabú é htoq agó, Chyoiyúng Woi-nyí byíng nyi bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ahkuî, Ikoni wà mó má nghut nyi é hkûn, Poluq eq Barnaba nhik gi, Yudaq byu pê é tarajong má rahá wàng mù, Yudaq byù eq tûngbaù pé ajùm ayò lumjíng bùm kó shoq, wum kat hko kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nghut kôlhang, a lumjíng é Yudaq byu pé gi, lumjíng é gumang wuì lé a ngui râ dông tûngbaù pé lé mhoq hpyoq yû mù, shuî gumlaû akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Haû mù luî, yhangnhik gi, tsómra myang shoq haú má nyì mù, haû Yhumsing é matú gyuq myit a bo é za hko kyô akô; Yhang Yhumsîng le yhangnhik é loq mai limik kumlhá eq mauhpo muzó dut nhang é dông, Yhâng é jeju mungdang lé saksé hkám byî nyi ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Haú wâ mâ é bang kúm gi, myit byo ló bûm kô é nghut mù luî, Yudaq byu pê chyáng ra-am, lagyô pê chyáng ra-am, lom byuq ló akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ahkuî, tûngbaù pé le, Yudaq byù eq yhangmoq é uphkâng bang le, yhangnhik lé rhoî mù luqgok èq dú sat râ ga htîm lo bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nghut kôlhang, yhangnhik gi, haú hkyô lé bûn sê kat kôjáng, Lukaoni ginwáng mâ é Lustra eq Derbe wà mó eq, hau é awui ayàm wà tiq wà zo pé shut hpang e ló akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Haú pé má le, gabú danglù xoq hko kyô wún akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ahkuî, Lustra wà mó má, înu unghkaû mai hkyî hten mù luî, hkâ-nhám le hkyô a wó sô wú é sû rayuq zung tô ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yhang le Poluq taî é dang lé gyô nyi ri. Poluq gi, haú yuq lé wú tsuq kat é hkûn, wó lhoq gê byi hui râ nghut lhê gâ é lumjíng myit yhâng chyáng bo tô é lé, myàng byî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Haû mù, Poluq gi, \"Toq yap aq!\" ga luî, htê mó èq yhang lé taî kat jáng, yhang gi, byam toq kat mù, wó so bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Haû mù, Poluq kut é muzó lé shiwa byu pé myàng kôjáng, yhangmoq gi, Lukaoni dang dông, \"Nat hparà pé gi, byù gùng dông kut luî ngamoq chyáng gyó lô bekô nghut ri.\" ga luî, wut garu bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Hau htâng, Poluq gi, dang myô taí sû nghut é yanmai, yhang lé Herme ga, Barnaba lé gi, Zeu ga myhíng byî akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Haû wà yàm mâ é Zeu hparà noqkuq yhûm hkyangjong hpó gi, wà hkum má nohtó pé eq ban hkóng pé yu lé mû, shiwa byu pé eq rahá yhangnhik lé hkungga nhông byi râ hen akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nghut kôlhang, lagyo nhik Barnaba eq Poluq gi, haû lé wó gyo kôjáng, yhumsing é mebu lâng cheq pyám kôluî, shiwa hpong gung gûng shut din wang ê kômù, garû taí kô é gi, ");
INSERT INTO atbNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","\"Hkaû pé ê, haî mù haû su kut lo akô lhú? Nga-nhik le nungmoq eq rajung za, xângzo byù za nghut lhê, akyû a bo é hkyô shí pé lé tô pyâm to mù, mauhkûng eq myigùng, wuìshuq lung-aû eq haú pé má nyì mi-nyì, joq mijoq lé hpan to sû, rû dui nyi é Garai Gasâng chyáng lhing wang lò kó sháng gaq nghû luî sheq, nungmoq lé gabú danglù hko kyô é nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Garai Gasang gi, byù myû chângjup lé hí hpyang lhê é pyat bán má ó le ó kâm é dông kut nhâng bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nghut kôlhang, Yhang gi, mauhkûng mai mau wô nhâng luî, kyôshi zuí nhang é ahkyíng yam-yoq byi mù, nungmoq lé zoshuq agùn agó byî é eq, nungmoq lé i-myit ngón nhang nyi é dông, Yhang ge é hkyô lé tûn shit mù, Yhang nyi é hkyô lé saksé hkâm nyi ri.\" ga akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Haû su ga taí kô le lháng, yhangnhik lé shiwa byu pé mai hkungga nhông byi râ hkyô lé, yhangnhik gi, gyai wuihke luî sheq wó hkûm pyâm akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Hau htâng, Antioku wà mó eq Ikoni wà mó pé mâ é Yudaq byu pé ra-am lé jé kômù, shiwa byu pé lé shuî-u luî, Poluq lé luqgok èq chôm dú kômù, yhang lé shi byuq bê su ngàm kô é yanmai, wà shinggan shut shê hkyut htoq pyâm akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nghut kôlhang, Poluq gi, yhâng é lhînghkyuq má chángzô pé yap tô kô é hkûn, toq mù wà shut tau wang ló ri. Hau htang nyí, yhang gi, Barnaba eq rahá Derbe wà mó shut e ló bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Haú wâ má yhangnhik èq gabú danglù hkô kyo kô é yanmai, byù myo myo gi, chángzô pé dut lo akô. Hau htâng, yhangnhik gi, Lustra, Ikoni, Antioku wà mó hkyô dum taû ló kômù, ");
INSERT INTO atbNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","chángzô pé lé myit lhoq ging byi uchyang, haû lumjíng hkyô má ru gîng nyì râ matú myit wum byî akô. \"Nga-nhúng gi, Garai Gasâng é mingdán má wàng râ matú, wuîhke jamjau myo myo hui ra râ nghut lhê.\" ga le, mhoqshit akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yhangnhik gi, noqkuq hpúng hkangmó má, hpúng suwún kut râ bang lé hkyin yù mù, zoshuq gám luî kyûdung mù, yhangmoq lumjíng nyi é Yhumsîng Garaî chyáng ap byi tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Hau htâng, yhangnhik gi, Pesidi ginwáng mai laî byit ló mù, Pamhpuli ginwáng má jé ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Haú ginwáng mâ é Perga wà mó má mungdang hko kyo luî, Atali wà mó shut laî gyó ló akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Haû mai, lhaî ji mù, ahkuî yhangnhik wùn waq laî ló bê muzó é matú, Garai Gasâng jeju má ap luî yhangnhik lé nhang kat é Antioku wà mó má dum jé lò bekô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jé lo é hkûn, yhangnhik gi, hpúng byû wuì lé wut tsîng yù mù, yhangnhik dông mai Garai Gasang kut é hkyô banshoq lé le, tûngbaù pé lé haû lumjíng hkyô hkum hpóng byî é hkyô lé le, shit kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Haû mù, yhangnhik gi, haú wâ má chángzô pé eq tsómra myang shoq nyi nyi akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ahkuî, Yuda mau mâ é byù ra-am gi, Antioku wà mó má lé jé mù, gumang wuì lé, \"Nungmoq gi, Mosheq é htûngtarâ eq rajung za, ahpyo-kuq a hpyit é nghut jáng, hkyi yu é hui râ a nghut.\" ga luî, mhoqshit bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Hau é yanmai, myit a huî lhûm é hkyô htoq lô mù, Poluq eq Barnaba nhik gi, haú bang eq gyai yhang myíng myô lhûm akô; haû mù luî, gumang wuì gi, Yerusalem wà mó má nyi é lagyô pé eq suwún wui chyáng, haú hkyô lé ló hpyê lhum râ matú, Poluq, Barnaba nhik eq rahá, yhangmoq chyáng mâ é ra-am lé, nhang kat râ ga hkyin tô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Haû mù, hpúng byû wuì yhangmoq lé dé kat kôjáng, yhangmoq gi, Hpinisi mau eq Samariq mau gyoro mai sô laî ló uchyang, tûngbaù pé lhing wang lò bê hkyô lé taî kyô akô. Haú mâ é gumang wuì lé gyai yhang gabú nhang akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yhangmoq, Yerusalem wà mó má jé kô é hkûn, hpúng byû wuì, lagyô pé eq suwún wuî gi, yhangmoq lé lhom hkûlum yù kô é nghut mù luî, yhangmoq gi, yhangmoq dông mai Garai Gasang kut é hkyô lhunglháng lé, haú bang lé shit kyô akô. ");
INSERT INTO atbNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Haú hkûn, Hparishe hpúng mâ é lumjíng bang ra-am gi, toq mù luî, \"Tûngbaù pé lé, ahpyo-kuq hpyit nhâng râ eq, Mosheq é tarâ dông cháng nhâng râ gi, ra yhang râ lhê.\" ga taî bum akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ahkuî, lagyô pé eq hpúng suwún wuî gi, shí hkyô lé chôm myit wú râ ga, zup tô bum akô. ");
INSERT INTO atbNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Shí hkyô lé gyai yhang dang rhâng lhûm bùm kô é htâng má, Petruq gi, toq mù luî, \"Gumang wuì ê, Garai Gasang gi, ngá nhut mai taî é, haû gabú danglù lé, tûngbaù pé gyô yù mù lumjíng kó sháng gaq ga, hí hkûn nungmoq chyáng mai ngo lé hkyin yù bê hkyô lé, nungmoq sé lugù nghut bê. ");
INSERT INTO atbNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Haû mù, myit nhiklhum lé sé byi sû Garai Gasang gi, nga-nhúng lé byî é eq rajung za, yhangmoq lé le Chyoiyúng Woi-nyí byî é dông, yhangmoq lé hap yù bê hkyô lé saksé tûn shit bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Garai Gasang gi, yhangmoq lumjíng luî, yhangmoq é myit nhiklhum lé lhoq san lhoq yúng byi bê nghut é yanmai, nga-nhúng eq yhangmoq é gyoro má gamhkuî é hkyô a joq nhâng lo nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Haû nghut le gi, îchyí îwâ pê èq le, nga-nhûng èq le a ung é wòlai lé, haû chángzô pê é lingzing má ke byî é dông mai, haî mù, ahkuî Garai Gasang lé chyam wú nyi akô lhú? ");
INSERT INTO atbNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nghut kôlhang, ngamoq gi, yhangmoq eq rajung za, Yhumsîng Yesuq é jeju mai za hkyi yu é huî é hkyô lé lumjíng é bang nghut lhê.\" ga luî, yhangmoq lé taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Haú hkûn, zup míng tô é bang lhunglháng gi, zim za kut luî, Barnaba eq Poluq nhik mai, tûngbaù pê chyáng, Garai Gasâng èq yhangnhik é loq dông limik kumlhá pé eq mauhpo muzó pé kut shit é hkyô, taî kyô nyi é lé chôm gyô nyi akô. ");
INSERT INTO atbNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yhangnhik dang ban taí kôjáng, Yakuq gi, \"Gumang wuì ê, ngá dang lé gyô wú keq. ");
INSERT INTO atbNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Garai Gasang gi, tûngbaù pê chyáng mai Yhâng mying é matú byù ra-myû hkyin yù râ ga, yhangmoq lé sâng-hi mai hkâsu kut lé kûm nyi é hkyô lé, Simun taî kyo bê nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","16","Shí hkyô gi, 'Hau é htâng má gi, ngò dum taû lò mù luî, lêng gyop byuq bê Dawiq é yhûm lé dum saí râ nghut lhê. Haû byoq htên tô é pé lé saî saí mù, haû lé dum lhoq toq râ nghut lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Haú hkûn sheq, ngá myîng mai ji yu é tûngbaù pé eq, myit gyo tô é byù lhunglhâng bang gi, Yhumsîng Garai lé hô kó râ nghut lhê ga, ");
INSERT INTO atbNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","a-nham mau htoq xâng hkun mai, shí hkyô pé lé sé nhang é Yhumsîng Garai taî ri.' ga myiqhtoî pé kâ tô é dang eq rajung za nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Haû mù luî, ngò taí nau é gi, tûngbaù pê chyáng mai Garai Gasâng shut lhing lo é bang lé, gotû haî le a lhoq wuî é za, ");
INSERT INTO atbNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","hparà lhô pé lé kyáng byî é a sansêng é zoshuq pé lé le, ashop é dông gungsho zùm yap é hkyô lé le, lingzing mai myhik sat é dusak sho lé le, sui lé zô é hkyô lé le, koi pyám râ matú za, yhangmoq lé, nga-nhúng laiká mai wó shit kat lhê. ");
INSERT INTO atbNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Hkâsu mù gâ le, gó hkûn mai yhang, Mosheq é tarâ lé wà hkangmó má hko kyô ló kômù, Bánno buinyì hkangmó tarajong pé má nghap kyo kyo kut bûm kô é nghut lhê.\" ga taî ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Haú hkûn, lagyô pé, suwún wuî eq, hpúng byû wuì lhunglhâng bang gi, Poluq, Barnaba nhik eq rahá Antioku wà mó shut nhang kat râ byù lé, yhangmoq chyáng mai hkyin yù râ matú chôm myit hpyit akô. Haû eq rajung za, yhangmoq gi, gumang wui chyáng mâ é nhik bô suwún nhik Barsabaq gâ é Yudaq eq Sila lé hkyin yu akô nghut ri. ");
INSERT INTO atbNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yhangnhik é loq má, hun kat kô é laiká gi, \"Antioku