﻿USE sofia;
DROP TABLE IF EXISTS sofia.ata_vpl;
CREATE TABLE ata_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ata_vpl WRITE;
INSERT INTO ata_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tatei manina no voxo ane Lataua musokou sou mukoinu mimii latala loxo loxotolo ilou lia ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","la lia ꞌo ne, loxo tamaisou vaimomo ꞌo uasi. Muxolu muxovulaulau vitanisi mo xalusousi. Isivoxo musuꞌasou lexa toxoxaꞌa ia Lataua Uleenusi muxixaoxao no loxou lexa ne. ");
INSERT INTO ata_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ioxe, Lataua muavuti la muvikala aloxo ꞌo, “Lamana upaa!”, la lamana muxali. ");
INSERT INTO ata_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Anu mumaisou la muxali laixe misevile. Xe muavuti la mukalipalaꞌaneꞌi lamana ilou isivoxo. ");
INSERT INTO ata_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Lamana mumoxoꞌu lexe “Aso” xe isivoxo lexe “ꞌOlovoxo”. ꞌOlovoxo xe kakau la anu voxo vile a mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Xe iliꞌi la, la Lataua muvikala aloxo ꞌo, “Vimelu vile upaa no lexa lixinu mo ukalipalaꞌanu lexa ulai no xalee tamei.” ");
INSERT INTO ata_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","La anu vimelu ane ne, muxali vitanisi. Lataua muꞌoxonu vimelu ane ne sou utaluxu lexa teitexi xe lexa no lia. ");
INSERT INTO ata_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Anu mumoxoꞌu vimelu ne lexe, “Loxotolo”. ꞌOlovoxo xe kakau la anu voxo tamei a mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Xe iliꞌi, la Lataua muvikala aloxo ꞌo, “Lexa no laaxu loxotolo ulai upita no xalee vile mo sou tani ꞌesiꞌesi upaa.” La anu tani ꞌesiꞌesi mupaa muxali vitanisi. ");
INSERT INTO ata_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tani ꞌesiꞌesi ne, anu Lataua mumoxoꞌu lexe “Lia” xe lexa ane mulai mutavo no xalee vile ꞌole ne, mumoxoꞌu lexe “Luaki”. Xe Lataua mumaisou la muxali laixe. ");
INSERT INTO ata_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Xe Lataua muavuti, la muvikala aloxo ꞌo la, “Lia uxalixu iaꞌeiaꞌe ilou kamakala xe ovuovu iouiou ane uneneꞌa la uxalixu ngiangiaxu xe tematemanu.” La mimii ane ne, lia muxalixu mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Xe anu mumaisou la muxali laixe. ");
INSERT INTO ata_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ꞌOlovoxo xe kakau la anu voxo tatalu a mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Xe iliꞌi la, la Lataua muvikala aloxo ꞌo, “Ta mimii sou ikaakaa ipaa teitexi no loxotolo sou ikalipalaꞌa aso ilou ꞌolovoxo xe sou ivikalanengexu voxo iouiou mo voxovoxo mo tauutauu ie. ");
INSERT INTO ata_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ta mimii ane ne ipaa no loxotolo sou ikaa uluꞌe no lia.” La ta mimii ane ne aneꞌi mixali. ");
INSERT INTO ata_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lataua muxalixaꞌa ta mii tamei sou iiei. Vile uiei no aso xe vile sou uiei no ꞌolovoxo. Anu muxalixaꞌa ta oto kalumo. ");
INSERT INTO ata_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Anu mumulaxaꞌa ta mii ane ne teitexi no loxotolo sou ikaa uluꞌe no lia ");
INSERT INTO ata_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","xe sou isaxilaꞌa aso ilou ꞌolovoxo xe sou ikalipalaꞌaneꞌi lamana ilou isivoxo. Xe Lataua mumaisiꞌa la mixali laixe. ");
INSERT INTO ata_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ꞌOlovoxo xe kakau la anu voxo tamiꞌa a mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Xe iliꞌi la, la Lataua muvikala aloxo ꞌo, la “Ta mimii iouiou ane sou lexa tanu no nano, ipaa no lexa sou imauli ukalusi mo ta ngiala iouiou ixali sou ivavava teitexi.” ");
INSERT INTO ata_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","La sou Lataua mukoineꞌi ta mimii ta toxotoxoxaꞌa sou luaki xe mukoineꞌi ta mimii seꞌi la ane mauli uxolu noxiꞌa kalumo sou lexa. Mo ta ngiala iouiou. Xe mumaisiꞌa la mixali laixe. ");
INSERT INTO ata_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Xe anu Lataua muavuti la mualusiꞌa ta mimii ane ne la muvikala aloxo ꞌo, “Ta mimii iouiou ꞌo ipaa tavuꞌalo sou iꞌanaꞌana no luaki. Mo ta ngiangiala ipaa tavuꞌalo kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ꞌOlovoxo mulai mukalu xe kakau la anu voxo taꞌuve a mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Xe iliꞌi la, la Lataua muvikala aloxo ꞌo, “Ta mimii iouiou ane mauli uxoo noxiꞌa ipaa no lia ꞌo. Aneꞌi ane ta temene mo aneꞌi ane ta vova ta tatila mo ta kitukituꞌa mo aneꞌi ane ixalaxala.” La aneꞌi ta mimii ane ne mixali. ");
INSERT INTO ata_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Xe mumaisiꞌa la mixali laixe. ");
INSERT INTO ata_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Xe iliꞌi, la Lataua muvikala aloxo ꞌo la, “Ioxe, nenge takoineꞌi ta mitema mo ixali loxo nenge. Tamuxaxaꞌa sou isaxilaꞌa ta sinana iloꞌa ta ngiala mo ta mimii iouiou latala ane ta temene mo ta vova mo ta mimii iouiou ane ixaxalaxala no lia.” ");
INSERT INTO ata_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Mukoineꞌi la mixali loxo anu, Lataua. Mukoineꞌi ta mulu xe ta sema aloxo anu nesi. ");
INSERT INTO ata_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Lataua mualusiꞌa la muvikala aloxo ꞌo, “Ngapalaaneꞌi ta ꞌilinge tavuꞌalo mo iꞌanaꞌana no xalexalee lia mo ngasaxisaxilaꞌa ta sinana iloꞌa ta ngiala mo ta mimii iouiou ane imauli no lia ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Xe Lataua muavuti la muvikala aloxo ꞌo la, “Eni aitingenge kamakamakala iouiou mo ovuovu iouiou ane uneneꞌa la ngiangiaxu xe tematemanu ne lexe ngingi laꞌilalingenge ane. ");
INSERT INTO ata_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mo eni aitixaꞌa ta mimii iouiou ane imauli no voxosila iloꞌa aneꞌi ane ixaxalaxala no lia mo ta ngiala iaꞌeiaꞌe iouiou mo ovuovu iouiou volovoloxu mo seseseenu.” La ta mimii ane ne mixali aloxo Lataua muvikala ne. ");
INSERT INTO ata_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Lataua mumaisiꞌa ta mimii ane anu molusi mukoineꞌi la mixali laixe. ꞌOlovoxo mulai mukalu xe kakau la voxo muxatele vile a mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Lataua mukoinu loxotolo ilou lia mo ta mimii latala aloxo ne mukalu. ");
INSERT INTO ata_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Xe no voxo muxatele tamei la anu mumaꞌila xo anu mukalusou xaixai noxou. ");
INSERT INTO ata_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Musosovosou voxo muxatele tamei ne lexe anu voxo tavuna noxou xo anu mukalusou xaixai noxou xe no voxo ane ne la sou anu mumaꞌila. ");
INSERT INTO ata_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nana sou Lataua mukoinu loxotolo ilou lia ne aloxo ꞌo. No voxo ane Lataua IAUE mukoinu loxotolo ilou lia, la ");
INSERT INTO ata_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","mimii iouiou ane uleleme no lia loxo iaꞌeiaꞌe xe kamakala ne, uleme uao. Xo anu ukalanu laꞌiua uluꞌe no lia mo itema vile sou uxaxai no lia kalumo uao. ");
INSERT INTO ata_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tani pitapitaꞌusi xo lexa a uxalixali utetelo no lia latanusi o. ");
INSERT INTO ata_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Io iliꞌi la sou Lataua IAUE mukoinu itema vile no anu lia. Xe mutauu tauuxu sou mauli muꞌunalai no kusinou, la sou itema ne anu mutulu. ");
INSERT INTO ata_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Xe iliꞌi la sou Lataua IAUE muxalixu ovuovu lailaixe no xale lia ne Eden no xalee mulai loxo no xalee ane aso uxaxali utelo no anu. Itema e anu mukoinu ne, anu mulai muꞌitalonu no xalee lia ane ne. ");
INSERT INTO ata_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Anu muxalixu ovuovu iouiou lailaixe muleme no nano no lia xalee ane ne la muneneꞌa la muxalixu tematemanu lailaixe misevile sou taꞌoꞌou. Ovu ane ulosinge mauli xe ane sou ulosinge lavulavu sou talavu no anu mimii maꞌia ane laixe xe mii maꞌia ane masua. ");
INSERT INTO ata_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Lexa luuxu vile mupaa ne Eden sou uꞌoxonu mimii no xale lia ane ne uleme laixe. Lexa ne musiali mulai vaꞌaxu la sou mukalipalaꞌa la muxalixu lexa aiinu tamiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Vile ilemele lexe Pisoni, ane misiali mixixaoxao tuala vile tila ilemolu lexe Avila. ");
INSERT INTO ata_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Lavoꞌo ilemolu lexe “xoulu” mo vile ne laulauoinu, ilemo lexe “onikisi”, mixalisou no lia xalee ane ne. Ta mii tamei ne lamolisiꞌa tatila misevile. Ovu vile kalumo muleme lai ne. Luuxu ne tumaꞌu lailaixe misevile. ");
INSERT INTO ata_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Lexa tamei sou ne ilemele lexe Xioni, ane misiali mixixao tuala vile tila ilemolu lexe Kusu. ");
INSERT INTO ata_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Lexa tatalusiꞌa ne ilemele lexe Taixilisi. Ane misiali milai loxo no xalee ane aso uxaxali utelo no anu ne Asiria. Xe tamiꞌasiꞌa ne ilemele lexe Iupileitisi. ");
INSERT INTO ata_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Xe iliꞌi la sou Lataua IAUE mulai muꞌitalonu itema ne no xalee lia ne Eden sou uxoxoo uxaxai ane xe usaxisaxilaꞌu xalee lia ane ne. ");
INSERT INTO ata_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Lataua muavuti la muvikalanu aloxo ꞌo, “Ovuovu ane muleme no xalee lia ꞌo ne, nini naꞌou ngiangiaxu ukalusi, ");
INSERT INTO ata_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ia ovu ane sou ulosou itema vile lavulavu no anu mimii maꞌia laixe xe mimii maꞌia ane masua ne, naꞌou uasi. Xo maasi xe nini naꞌou la nini nasoli manina.” ");
INSERT INTO ata_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Xe iliꞌi la, la Lataua IAUE muvikala aloxo ꞌo, “Itema anusisi uxoxoo loxo la laixe uasi. Eni akoinu menexu vile sou ilou ixoxolu sou usuꞌusuꞌulinu.” ");
INSERT INTO ata_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","La sou anu munoꞌu lia ꞌo sou mukoineꞌi ta mimii iouiou ane imauli no voxosila mo ta ngiangiala no anu. Mukoineꞌi mukalu la sou munoꞌa milai noxou itema ne sou anu molu mumoxoꞌu ualaualasiꞌa vilevilesi. Ta mimii iouiou ane ne iloꞌa ta ngiangiala vilevilesi ualaualasiꞌa ne anu itema molusi mumoxoꞌa no anu. ");
INSERT INTO ata_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Anu itema mumoxoꞌu ualaualasiꞌa ta mimii iouiou ne iloꞌa ta ngiangiala mukalu, ia vile noxiꞌa ne uxali menexu sou usuꞌusuꞌulinu uasi. ");
INSERT INTO ata_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ioxe, IAUE Lataua muavuti la muꞌoxonu itema ne la muai ne muvaꞌavaꞌamimi avile. Muai muvaꞌavaꞌamimi aloxo ne, io ulavu ua. Lataua muneꞌe mulaanu alamanu vile no vainu. Mulaanu mukalu, la musovolou xiasinu ilou alamanu tanixu no vainu itema ne, ");
INSERT INTO ata_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","io munoꞌu alamanu ne mulai sou mukoine sema vile no anu. Mukoine mukalu la munoꞌe milai noxou mulu ne. ");
INSERT INTO ata_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Xe anu iou muvaxa loxo ꞌo la sema eie mineꞌe mixali noxou ꞌo. Xe anu muavuti la muvikala aloxo ꞌo, “Anu! Mukalu soxu! Eni tangaxo maninasou ane. Xine ilou xiasine ne molu ane noxilo ꞌosi. Lataua munoꞌu ane noxilo ꞌo la sou ane Anu mukoine no anu. Eni amoxoe lexe ‘sema’, xo ane mipaa ne no anu xilelisi.” ");
INSERT INTO ata_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tavaꞌu aloxo ne la sou ane, itema uꞌumesiꞌa momu ilee nenu sou ulai ilee semau ixolu ipita sou ixali vilesisi. ");
INSERT INTO ata_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Aneꞌi ilou itoxu uasi ilou mixoo vitanisi, ia ilou imaela uasi. ");
INSERT INTO ata_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","IAUE Lataua mukoineꞌi ta mimii iouiou ane imauli no voxosila mo aneꞌi ane ixaxalaxala mo aneꞌi ane ivavava ꞌo ukalusi, ia vile noxiꞌa ne umomomo noxou sinana veveeni uasi, xo anu mulavu misevile. No voxo vile la anu sinana veveeni ne mulai muxali noxie sema la mutaliꞌisie aloxo ꞌo, “Manina lexe Lataua mupelaꞌinge ngongou lexe ngongou ngaxoxoolu la mamu ngongou ngaoꞌu ovu seꞌi muleme no nano no xalee lia ꞌo ngiangiaxu uasi?” ");
INSERT INTO ata_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ane miavuti la mikolinu aloxo ꞌo, “Ovuovu ane muleme no nano no xalee lia ano ꞌo ne, nexi taꞌaniꞌani ngiangiaxu ukalusi, ");
INSERT INTO ata_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ia vilesisi e ututulu no nixi ꞌole ne anu mupelaꞌixe lexe nexi taꞌou ngiaxu uasi. Xo maasi xe nexi tanoꞌu sou taꞌou, la nexi tasoli. Anu Lataua muvikalanexi aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Xe sinana veveeni muavuti la mukolinu vaikalaie aloxo ꞌo, “Vaikala ane ne manina uasi. Ngongou ngasoli manina uasi. ");
INSERT INTO ata_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Lataua mulavusou lexe maasi xe ngingi ngongou ngaꞌou, la iengi ngongou lamana la ngaxali loxo anu Lataua. La ngalavu no anu mimii maꞌia ane laixe xe maꞌia ane masua. Tavaꞌu aloxo ne la sou ane Anu muꞌapingengexu ne.” ");
INSERT INTO ata_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Xe aliku ꞌo iei mulai mutukumusou ovu ne nigangiaxu, la lailaixe misevile. Lailaixe loxo taꞌoꞌousi. La sou xavutalaie muvikala lexe, “Manina, lexe eni aꞌou ovu ne ngiaxu, la eni anoꞌu lavulavu no anu mimii piena misevile.” La aliku ꞌo minanavaa ꞌo, milutu ꞌo la milai miꞌelexu ovu ne ngiaxu sou miꞌou. Xe miitixu mulue sou anu muꞌou kalumo. ");
INSERT INTO ata_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Xe alaxu vilesisi ꞌo la ilou ieꞌi lamana xe mixamuli loxo ꞌo, la aneꞌi ilou iꞌa mii loxo ꞌo sou utaluxu vasimeꞌa uasi. La sou ilou milai mixatelexu ovu vile volovoloxu loxo xalupe sou ilou mitoxuꞌu. ");
INSERT INTO ata_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Xe no ꞌoloꞌolovoxo mine tani lelemesou, la aneꞌi ilou mixamulinu IAUE Lataua mine mumuamuaꞌi no nano no xalee lia ane ne, la ilou milai mitalume no ovu tavatavaꞌu. ");
INSERT INTO ata_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Xe IAUE Lataua muneꞌe la mukamulineꞌi ilou la sou muꞌavalou itema “Nini a neꞌei?” ");
INSERT INTO ata_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Xe anu muavuti la mukolinu aloxo ꞌo, “Elomusine ia eꞌume mo eni ane atatalume ꞌo, xo eni xeni mii vile sou ataluxu vasimelo no anu uasi, mo eni ane axoxoolu vitanisi ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Xe IAUE Lataua muavuti la mutaliꞌisou aloxo ꞌo, “ꞌEnaꞌei muvikalaneni lexe nini meni mii vile sou nataluxu vasimene no anu uasi? Loxovaa, neꞌou ovu ngiaxu e epelaꞌinexu lexe naꞌou uasi ꞌole?” ");
INSERT INTO ata_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Anu muavuti la mukolinu aloxo ꞌo, “Sema e nini nekoine ka neneꞌene noxilo lexe menexilo ane, ane mele minoꞌu ovu ne ngiaxu la milosilo la ane eni eꞌeu ne.” ");
INSERT INTO ata_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Xe IAUE Lataua muxiu vaxa la mutaliꞌisie sema ne aloxo ꞌo, “Tavaꞌu loxovaa ane nini neꞌoxo mii ano ꞌo?” Ane mikolinu aloxo ꞌo, “Sinana veveeni muꞌoxo loloxo la mukalavoileli, la sou ane eni enoꞌu la eꞌeu.” ");
INSERT INTO ata_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Xe IAUE Lataua muavuti la muvikalanu sinana veveeni aloxo ꞌo, “Tavaꞌu xo nini neolexaꞌa ta tamei ꞌo, la nini nanoꞌu navunavu tatila loxo ꞌo. Navunavu ane eni alosine ne, anu toxoxaꞌa no anu navunavu noxiꞌa ta mimii iouiou ane imauli no voxosila mo aneꞌi ane ixaxalaxala mo ta ngiangiala kalumo. Usoko ane vaimomo ꞌo mo ulai utalo avile iliꞌi ne, nini nalalaave no oponenisi, mo ꞌaniꞌanixene ane lialia. ");
INSERT INTO ata_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Sema uluaie ane nini xe nini uluameni ane ane. Mo aneꞌi ane ipaa iliꞌi noxine xe noxie sema ne aloxo ne kalumo. Xe aneꞌi imaloxoꞌu kisine la nini nakikatu sou navalinu anaxene uneꞌe sou nangaasou tavaꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ioxe, IAUE Lataua muxiu vaxa la muvikalane sema aloxo ꞌo, “Ulai xe nini oponeni la nini naxamulinu navunavu tatila. Xe navoꞌo ꞌiline la nanoꞌu navunavu mine tatila loxo. Navunavu ane ne molu noxilosi. Nini namasaxa lexe nasaxilaꞌu mulumeni, ia uasi. Anu molu usaxilaꞌine xo nini kisine ane anu.” ");
INSERT INTO ata_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","Xe muxiu vaxa la muvikalanu Adamu aloxo ꞌo, “Tavaꞌu xo nini nelomuxe semameni, la neꞌeu ovu ngiaxu ane eni eꞌapixenexu lexe naꞌou uasi ne, la eni aꞌoxo masua lia ꞌo. Nini mene xavineni sou naxaxai no voxovoxo ane nini namamaulixu mo natotouxene laꞌilali. Ovuovu ngiangiaxu mo iaꞌeiaꞌe ane auauexu mo ane upalapalasinge mo mimii ane anaanaxu la ukalukalusinge ne ileme no lia no xaixene kalumo. Naxoxoolu xe nasolixene la namolo ovuovu ngiangiaxu ilou ovuovu seꞌi volovoloxu la naꞌou. Naxaxai xavineni mo sou sasaieni upaapaa la sou lia e natotou mimii no anu ꞌo ne, uxalixu laꞌilali sou naꞌou xo mole nini nalivu ulai no lia e nini nepaa no anu ꞌo. Xo eni ekoineni no anu lia. Anu aloxo ne la sou ane nini nalivu nalai naxali loxo lia la.” ");
INSERT INTO ata_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu mumoxoe semau ualasie lexe Iva. Xo ane ta mitema ukalusi neniꞌa ane ane. ");
INSERT INTO ata_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ioxe, iliꞌi la sou IAUE Lataua molu muvau vile noxiꞌa ta mimii sou musulukinu sosou ka mulailixu noxiꞌa ilou sou misakiinu. ");
INSERT INTO ata_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ioxe, iliꞌi la, la IAUE Lataua muvikala aloxo ꞌo, “Vaimomo ꞌo, itema anu muxali loxo nenge, mo anu mulavu no anu mii maꞌia ane laixe xe mii maꞌia ane masua. La sou nenge tamasaxa lexe anu unoꞌu ovu ane sou ulosinge mauli ne ngiaxu mo uꞌou sou uxolu mo umauli kaluxu uasi, uasi.” ");
INSERT INTO ata_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","La sou IAUE Lataua mukusau muatulai muxexesou xalee lia ne Eden, la muvikalanu sou uxaxai no lia ane anu Lataua muxalixu no anu. ");
INSERT INTO ata_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Xe no xalee mulai loxo aso uxali utelo no anu ne, IAUE Lataua mumuxaxaꞌa ta angelo xe viso vile ukakaakaa ia uxixaoxao uxalixaliliou paꞌupaꞌumolu xalee lia ne sou iloꞌa ta angelo isaxilaꞌu xo loxo ꞌo io, evile uneꞌe ꞌalai no anu ovu sou mauli kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Xe iliꞌi la sou Adamu mulai noxie semau la opoone. Xe iliꞌi la ane mivoꞌonu ꞌilie e oposou la mivikala aloxo ꞌo, “IAUE musuꞌulileli mole ane eni enoꞌu ꞌalixe mulu ꞌo.” La sou mimoxoꞌu ualasou lexe Kaini. ");
INSERT INTO ata_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Xe iliꞌi la mivoꞌonu ꞌilie mulu vile la. Mimoxoꞌu ualasou lexe Aveli anu itema sou usaxisaxilaꞌa ta sipsip. Xe Kaini anu itema sou xai. ");
INSERT INTO ata_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mixoxoolu mo mixaxai xoo xe, iliꞌi la Kaini mulai mumolo laꞌilali no xaixu, ka mutavulenu mulai sou muꞌelaxu mulai noxou IAUE Lataua. ");
INSERT INTO ata_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Xe Aveli kalumo ne mulai munoꞌa ta sipsip ta ꞌiliꞌa seꞌi ta laixe misevile ta laposalaxu, ka mupalepeineꞌi sou muꞌelaxaꞌa milai noxou IAUE Lataua. IAUE Lataua mumaisou la mumasaxau mo muꞌosasou Aveli ne ilou lolovolo noxou misevile. ");
INSERT INTO ata_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ia Kaini ne uasi. Xe Kaini mulavu aloxo ne la, iou ne masua loxo. Laꞌiaxu misevile. ");
INSERT INTO ata_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","IAUE Lataua muavuti la muvikalanu Kaini aloxo ꞌo, “Nini laꞌiaxene mamu. Mo ieni ututuma loxo ne mamu. ");
INSERT INTO ata_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Alexe nini namulinu mo naꞌoxonu ꞌilixo ane mulapu, la ano ꞌo ne nini naꞌosaꞌosasi. Ia tavaꞌu xo nini neꞌoxo ꞌilixo masua, la sou anu ꞌilixo masua ne ane anu ungiuleleine mo a ulolooxene ne. Anu umasaxa lexe utaloxolixene mo uatasine uluꞌelai. Ia nini xavineni mo nataloxolixu uluꞌelai.” ");
INSERT INTO ata_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ia Kaini ne opoonu lelemesou uasi manina. No voxo vile la muꞌavalou vimou Aveli la muvikalanu aloxo ꞌo, “Naneꞌe mo nengei talai taxixaoxao.” Ilou milalai xoo xe, Kaini muavuti vaxa la muvau vimou Aveli musoli ne. ");
INSERT INTO ata_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Xe iliꞌi la IAUE Lataua mutaliꞌisou Kaini aloxo ꞌo, “Vivine Aveli ꞌava?” Kaini mukolinu aloxo ꞌo, “Eni alavusou uasi. Xo maꞌi, eni amitema sou saxisaxilaꞌu sou vivilo ne?” ");
INSERT INTO ata_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Xe IAUE Lataua muxiu vaxa la mutaliꞌisou, “Loxovaa ane nini neꞌoxonu ꞌilixo masua ane ne? Eni elavu lexe nini vivine sialuxu munixi muluꞌe no lia ꞌo mo sialuxu ne loxo itema mukatuleli sou lexe nini nanoꞌu navunavu tatila sou lakoli ꞌilixo masua ane nini neꞌoxonu ne. ");
INSERT INTO ata_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ioxe, eni vaimomo ꞌo eni alosine tuꞌumaxu vile aloxo ꞌo, umomomo sou nini naxaxai mo natotou mimii uluꞌe no lia ꞌo la uasi, xo lia ne muaa mo muiexu vivine sialuxu no voxo ane nini nevau no anu. ");
INSERT INTO ata_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ulai xe nini natovo mo lexe natotou mimii toxotoxosou ne la ulemeieni uasi. Xe nini ne sine tuala mo tani sou naxolu talo no anu uasi. Naxixaoxao no lia ꞌo vitavitanisi, ia naxoo talo uasi.” ");
INSERT INTO ata_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Xe Kaini muavuti vaxa la mukoli vaikalau IAUE Lataua aloxo ꞌo, “Tuꞌumaxu ane nini nelosilo ꞌo ne tatila misevile. Eni amomomo no anu uasi. ");
INSERT INTO ata_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mo nini a nakusailo ꞌo sou eni alai axolu vaꞌaxu, ia axolu no lia no paꞌumene ꞌo la uasi. Mo silo tuala mo tani sou axolu no anu la ua, axixaoxao mo avavaxa aneneꞌe aloxo nesi, ia axoo talo no lia ꞌo la uasi. Itema vile uxalisilo ne la uvelosi mole asoli.” ");
INSERT INTO ata_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ioxe, IAUE Lataua muavuti la muvikalanu lamana aloxo ꞌo, “Evile umomomo sou uvene uasisi manina. Ia lexe evile uvene xe nasoli la eni alosou navunavu tatila lakolineni.” La sou IAUE mumuxaxu sosovo vile noxou Kaini sou lexe ta mitema imaisou la ivau uasi. ");
INSERT INTO ata_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ioxe, Kaini muavuti la muꞌumesou IAUE sou mulai muxolu no lia xalee vile ilemo lexe “Nod”. Lia xalee ane ne muxolu no xale lia ne Eden loxo aso uxaxali utetelo no anu. ");
INSERT INTO ata_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Xe iliꞌi la Kaini mutaulaꞌi, la sou ilee semau mipalaa ꞌiliꞌa vile mulu la mimoxoꞌu ualasou lexe Enoko. Xe iliꞌi la, la Kaini muꞌilii tuala vile tatila la mumoxoꞌu tuala ne ualasou noxou ꞌolu ualasou. ");
INSERT INTO ata_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoko mupalaa ꞌolu vile la mumoxoꞌu ualasou lexe Ielati. Ielati mupalaanu Meusaleli. Meusaleli mupalaanu Metusaeli. Metusaeli mupalaa Lameki. ");
INSERT INTO ata_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Xe Lameki muavuti la muꞌuluxaꞌa ta sema tamei, eiae Ada ilee Sila. ");
INSERT INTO ata_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Lameki mulai noxie Ada xe opoone, la sou mivoꞌonu ꞌilie vile la mimoxoꞌu ualasou lexe Iavala. Iavala anu ꞌilusuneꞌi ta mitema ane ilavusou isaxilaꞌa ta kau xe ixoxoo no tani alelaxu. ");
INSERT INTO ata_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Xe vimou Iuvalu ane anu ꞌilusuneꞌi ta mitema ane ilalaꞌati xe itatau iuxoxo. ");
INSERT INTO ata_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila opoone la mipalaꞌalixu Tuvala-Kaini. Anu mukoinu mimii iouiou ane sou taxaxai no anu. Muꞌoxonu no anu kopa ilou aen. Anu Tuvala-Kaini ne vimou sema ane Naama. ");
INSERT INTO ata_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Xe Lameki muavuti la muvikalaneꞌi ta semasemau tamei ne aloxo ꞌo, “Ada, ngongie Sila ngalomu uneꞌe noxilo. Eni evau maulu vile mo musoli xo anu muvelo. ");
INSERT INTO ata_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ia lexe evile uxalisou Kaini xe uvau usoli la IAUE Lataua ulosou navunavu tatila. Mo eni kalumo ne lexe evile uvelo asoli la IAUE Lataua ulosou navunavu toxoxaꞌa misevile.” ");
INSERT INTO ata_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu ilee semau mipalaa ꞌiliꞌa mulu vile la, la Iva mivikala aloxo ꞌo, “Lataua mulosilo ꞌo sou lakolisou Aveli e Kaini muvau musoli.” Ane mimoxoꞌu ualasou lexe Seti. ");
INSERT INTO ata_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti mutaulaꞌi la ilee semau mipalaa ꞌiliꞌa vile mulu, la mumoxoꞌu ualasou lexe Enosi. No tauu ie ane ne, la ta mitema misokou sou miꞌava no anu ualasou IAUE anu uala tavuna no nano no anu xoluxolu noxiꞌa no anu lalotu. ");
INSERT INTO ata_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nanasiꞌa Adamu ta xasoxasou iloꞌa ta ꞌiliꞌilisunu a ano. No voxo ane Lataua mukoineꞌi ta mitema la mixali aloxo anu Lataua. ");
INSERT INTO ata_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mukoineꞌi ta mulu xe ta sema ka mualusiꞌa. Ka mumoxoꞌa lexe “ta mitema”. ");
INSERT INTO ata_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu mumaulixu tauu ie itemaxu taꞌuve mo mavulovexa tatalu (130) mukalu, la mupalaa ꞌolu mulu vile la. La ꞌolu ne, maulixu loxo momu manina. La mumoxoꞌu ualasou lexe Seti. ");
INSERT INTO ata_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adamu mumaulixu tauu ie loxo itemaxu mavulovexa tamiꞌa (800) la. No nano no anu tauutauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo mavulovexa tatalu (930), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Xe ꞌolu Seti ne mumaulixu tauu ie loxo itemaxu taꞌuve mo taꞌuve (105) mukalu, la mupalaa ꞌolu mulu, ualasou lexe Enosi. ");
INSERT INTO ata_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seti muxolu mumaulixu tauu ie loxo itemaxu mavulovexa tamiꞌa mo muxatele tamei (807) la. No nano no tauutauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo mavulovexa vile mo mulelia tamei (912), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi mumaulixu tauu ie loxo mavulovexa muxatele tamiꞌa (90) mukalu, la mupalaa ꞌolu mulu. Mumoxou ualasou lexe Kenan. ");
INSERT INTO ata_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Io, anu muxolu mumaulixu tauu ie loxo itemaxu mavulovexa tamiꞌa mo mavulovexa vile mo mulelia taꞌuve (815) la. No nano no tauutauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo taꞌuve (905), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan mumaulixu tauu ie loxo mavulovexa muxatele tamei (70) mukalu la mupalaa ꞌolu vile mulu. Mumoxou ualasou lexe Maalaleli. ");
INSERT INTO ata_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan muxolu mumaulixu tauu ie loxo itemaxu mavulovexa tamiꞌa mo mavulovexa tamiꞌa (840) la. No nano no tauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo mavulovexa vile (910), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maalaleli mumaulixu tauu ie loxo mavulovexa muxatele vile mo taꞌuve (65) mukalu la mupalaanu ꞌolu vile mulu, la mumoxoꞌu ualasou lexe Ielati. ");
INSERT INTO ata_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Io, anu muxolu mumaulixu tauu ie loxo itemaxu mavulovexa tamiꞌa mo mavulovexa tatalu (830) la. No nano no tauutauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo mavulovexa muxatele tamiꞌa mo taꞌuve (895), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Xe Ielati tauu iexu mulai muxali loxo itemaxu taꞌuve mo mavulovexa muxatele vile mo tamei (162), la mupalaanu ꞌolu vile ualasou lexe Enoko. ");
INSERT INTO ata_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Io, anu muxolu mumaulixu tauu ie loxo itemaxu mavulovexa tamiꞌa (800) la. No nano no tauutauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo mavulovexa muxatele vile mo tamei (962), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ꞌOlu Enoko ne, tauu iexu mulai muxali loxo mavulovexa muxatele vile mo taꞌuve (65), la sou mupalaa ꞌolu Metusela. ");
INSERT INTO ata_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Xoluxolu ilou toxotoxo noxou mulai noxou Lataua pumuxu no nano no tauutauu ie aloxo itemaxu mavulovexa vile mo itemaxu taꞌuve (300). No nano no tauutauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","La sou anu mumaulixu tauu ie loxo itemaxu mavulovexa vile mo itemaxu taꞌuve mo mavulovexa muxatele vile mo taꞌuve (365). ");
INSERT INTO ata_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Xoluxoluxu mo muamuaꞌixu ne, ilou Latauasi. Aloxo ne la sou ane Lataua mupasikinoxu mole tasiauxusi, io usoli mo imaisou uasi. ");
INSERT INTO ata_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela mumaulixu tauu ie loxo itemaxu taꞌuve mo mavulovexa muxatele tatalu mo muxatele tamei (187) mukalu, la sou anu mupalaa ꞌolu vile ualasou lexe Lameki. ");
INSERT INTO ata_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ka muxolu mumaulixu tauu ie loxo itemaxu mavulovexa tatalu mo itemaxu taꞌuve mo mavulovexa muxatele tatalu mo tamei (782) la. No nano no tauu ie ane ne, anu mupalaaneꞌi ta ꞌolu seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo mavulovexa muxatele vile mo muxatele tamiꞌa (969), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ioxe, xe Lameki tauu iexu mulai muxali loxo itemaxu taꞌuve mo mavulovexa muxatele tatalu mo tamei (182), la sou mupalaa ꞌolu vile la, ");
INSERT INTO ata_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","muvikala aloxo ꞌo, “No anu lia ane IAUE muꞌoxo masuanu ꞌo, la molomolo ano ꞌo sou ukalusou ꞌauꞌau toxoxaꞌa noxinge,” la sou mumoxoꞌu ꞌolu ne ualasou lexe Noa. ");
INSERT INTO ata_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameki mumaulixu tauutauu ie seꞌi la loxo itemaxu mavulovexa tamei mo itemaxu taꞌuve mo mavulovexa muxatele tamiꞌa mo taꞌuve (595). No nano no tauu ie ane ne, la anu mupalaaneꞌi ta ꞌolu seꞌi la, ");
INSERT INTO ata_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","xe tauu iexu mulai muxali loxo itemaxu mavulovexa tatalu mo itemaxu taꞌuve mo mavulovexa muxatele tamei mo muxatele tamei (777), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa muxolu mo tauu iexu mulai muxali loxo itemaxu mavulovexa tamei mo itemaxu taꞌuve (500), xe iliꞌi la sou mupalaaneꞌi ta ꞌolu ta mulu tatalu ualaualasiꞌa lexe Semu ilou Amu mo Iapeti. ");
INSERT INTO ata_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Xe iliꞌi noxiꞌa aneꞌi nenge tenanasiꞌa mukalu ꞌo, la ta mitema mitautaulaꞌi la, la mipalaaneꞌi ta ꞌiliꞌa tapiena mole itiitisiꞌa muꞌokiꞌoki tani mo mitaasou xalexalee tuatuala mukalu. Mipalaaneꞌi ta ꞌiliꞌa ta sema xe ta mulu. ");
INSERT INTO ata_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Lataua ta ꞌolu ta mulu mimaisiꞌa ta sema ne, la ta mitema ta ꞌiliꞌa ta sema ne ta lailaixe misevile, la sou milutu vaxa sou minoꞌa ane aneꞌi mimasaxaiꞌa sou miꞌuluxaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Anu aloxo ne la sou IAUE muavuti la muvikala aloxo ꞌo, “Eni umomomo sou amasaxaiꞌa ta mitema ꞌo ixolu mo imauli maulixaꞌa veveeni la uasi, xo aneꞌi ta mitemasi, ta mitema sou isoisolisi. Usoko ane vaimomo ꞌo mo ulai avile iliꞌi, aneꞌi imaulixu tauu ie loxo itemaxu taꞌuve mo mavulovexa tameisi (120).” ");
INSERT INTO ata_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","No nano no voxovoxo ane tatei mo iliꞌi, ta mitema mipalaaneꞌi ta ꞌiliꞌa, la ta toxotoxoxaꞌasi. Ta mitema ane ne, aneꞌi ta ꞌilusulusuneꞌi ta sema ane miꞌuluxaꞌa Lataua ta ꞌolu ta mulu. Aneꞌi ta mitema sou xavi. Ta mitema no xalexalee tuatuala milavusiꞌa manina. ");
INSERT INTO ata_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Xe IAUE mumaisou lexe no voxovoxo utotomu ne, ta mitema ane mitaasou xalexalee tuatuala mukalu ne, misusu misevile no anu ꞌiliꞌilixo masumasua ane aneꞌi miꞌoxoꞌoxonu mo xavutalaiꞌa umasaxau ꞌiliꞌilixo masumasuasi. ");
INSERT INTO ata_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","La tanuxaꞌa misevile mo tanu uꞌelaiꞌa, xo Anu molusi mupaalixaꞌa sou mimauli no lia ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","la sou muvikala aloxo ꞌo, “Eni akalusiꞌa ta mitema ane eni melo ekoineꞌi ꞌo mo ta mimii iouiou ane ta vova mo ane ta temene iloꞌa ta mimii ane ixaxalaxala, aneꞌi ane ilalave, mo aneꞌi ane ivavava mo ta ngiangiala. Eni talelixaꞌa xo eni melosi ekoineꞌi.” ");
INSERT INTO ata_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ia, itema vilesisi no taineꞌi nesi ane, anu IAUE opoonu laixeu misevile. Itema ane ne, ualasou lexe Noa. ");
INSERT INTO ata_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nana ano ꞌo sou Noa. Noa mutaulaꞌi la mupalaaneꞌi ta ꞌolu tatalu, ualaualasiꞌa lexe Semu ilou Amu mo Iapeti. Noa ne, anu itema vile mulapu. Mo mii vile ususu no anu xoluxoluxu uasi. Mo muamuaꞌi noxou ne, ane ilou Latauasi. ");
INSERT INTO ata_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ia ta mitema tavuꞌalo ne, ꞌiliꞌilixo masumasua loxo, ꞌotoꞌoto mo ialivula tuala, mo ivau itema usoli ne, muꞌokiꞌoki tani mo muꞌanaꞌana no xalexalee tuatuala mukalu. Lataua mumaisou mo mulavusou ꞌiliꞌilixo masumasua noxiꞌa ne mukalu. ");
INSERT INTO ata_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Iou muluꞌe no xalexalee tuatuala ꞌo, la masua misevile. Ta mitema miꞌoxo masuanu mukalu no anu ꞌiliꞌilixo masumasua noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","La sou anu muvikalanu Noa aloxo ꞌo, “Eni emaisou mo elavusou ꞌiliꞌilixo masumasua noxiꞌa ta mitema loxo ꞌotoꞌoto mo ialivula tuala mo ivau itema usoli mukalu, mo eni amasaxa lexe akalusiꞌa ukalusi, xo ꞌiliꞌilixo masumasua noxiꞌa muꞌanaꞌana no xalexalee tuatuala mukalu. ");
INSERT INTO ata_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Eni emasaxaine lexe natulusou lasipi vile tatila. Naxexeta ovu xopa, ka navalavala alealelaxu la sou natulusou no anu. Natulusou ukalu, la nakaviutunu no nano ka naluluu koluta no nano xe no ale no vasimolu. ");
INSERT INTO ata_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nalovaxu nasokou no taꞌu ulai uxali no kusinou limaxu itemaxu mavulovexa vile mo itemaxu taꞌuve (300). Xe no anaxu paꞌumolu vile ulai uxali xalee vile limaxu mavulovexa taꞌuve (50). Xe no lia no taꞌu ulai teitexi, limaxu mavulovexa tatalu (30). ");
INSERT INTO ata_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Natulusou lasipi ne laxaꞌu loxo tani ꞌo, ia laxaꞌu ne uneꞌe utalo vaxa no lasipi paꞌupaꞌumolu uasi. Namuxaxu taiinu ilimaxu vile no nixi no laaxu xe no paꞌupaꞌumolu. No nano no tanu, la nasiaꞌu lavalataxu no nano loxo tani lavalata tatalu. Vile no lia, vile no nixi xe vile teitexi. Ukalu, la sou namuxaxu aitenga vilesisi no xalee vile. ");
INSERT INTO ata_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Xo eni asou aꞌoxo laꞌiua toxoxaꞌa usili sou uxalixu kupa tatila loxo luaki ꞌo sou unononu xalexalee tuatuala mo uꞌunaneꞌi ta mitema latala iloꞌa ta mimii iouiou latala ane mimauli no xalexalee tuatuala ꞌo mo isoisoli ukalusi, ");
INSERT INTO ata_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ia eni emasaxa lexe asakiinu vaikala sou opo vilesisi, ia apalaꞌalixu noxine iliꞌi o. Ngongiꞌa ta ꞌiline iloꞌa neniꞌa mo ta uaꞌauaꞌaneni ngaꞌunalai no nano no lasipi ne. ");
INSERT INTO ata_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ta mimii iouiou ta temene mo ta vova, aneꞌi ane ixaxalaxala mo aneꞌi ane ivavava mo ta ngiangiala iouiou ꞌo ne, ");
INSERT INTO ata_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","nanoꞌu mulu vile xe sema vile noxiꞌa vilevilesi sou napamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mo nanoꞌu ngenge ngongiꞌa laꞌilali iouiou kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa mulomuxu vaikala noxou IAUE la mimii piena e muvikalanuxu lexe uꞌoxo ne, muꞌoxonu mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Xe iliꞌi la, la IAUE muvikalanu Noa aloxo ꞌo, “Ngongiꞌa ta ꞌiline iloꞌa neniꞌa mo ta uaꞌauaꞌaneni ngaꞌunalai no nano no lasipi ne, xo eni elavusou lexe ninisisi itema vile mulapu no taineꞌi ta mitema ane mimauli no xalexalee tuatuala ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nanoꞌa ta mimii iouiou latala ane ta temene mo ta vova ane ngingi ngalavusou ngaꞌiꞌa, tangatangaxaꞌa muxatele tamei noxiꞌa vilevilesi, sema xe mulu. Xe aneꞌi ane ngingi ngalavusou ngaꞌiꞌa uasi ne, la nanoꞌa tangatangaxaꞌa vilevilesi, sema xe mulu ikalusi. ");
INSERT INTO ata_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Xe ta ngiangiala latala iouiou ꞌo ne, nanoꞌa tangatanga muxatele tamei noxiꞌa vilevilesi kalumo. Naꞌoxo aloxo eni elemolu ne, xo ta mimii ane ne imauli sou ulai iliꞌi, la ipalaa la sou ixali tapiena, la iꞌanaꞌana no xalexalee tuatuala ukalusi la. ");
INSERT INTO ata_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Voxo muxatele tameisi a uxolu sou eni apalusou laꞌiua toxoxaꞌa sou usili aso xe ꞌolovoxo mavulovexa tamiꞌa sou uꞌunaneꞌi ta mitema latala ane eni ekoineꞌi iloꞌa ta mimii iouiou latala ane ta temene mo ta vova mo aneꞌi ane ixaxalaxala, mo aneꞌi ane ivavava mo ta ngiangiala iouiou ne ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa mulomuxu vaikala noxou IAUE mo mimii piena ane anu muvikalanuxu lexe uꞌoxonu ne, mumulinu mo muꞌoxonu mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","No tauu ie ane Noa tauu iexu muxali loxo itemaxu mavulovexa tatalu (600) mukalu, la sou laꞌiua toxoxaꞌa musokou sou musili. ");
INSERT INTO ata_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Anu ilee semau mo ta ꞌolu iloꞌa ta semasemaiꞌa miꞌunalai no lasipi mo sou mamu iulua. ");
INSERT INTO ata_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ta mimii iouiou latala ane anu IAUE muvikalanu Noa lexe unoꞌa sou itelo no lasipi ne, aneꞌi mitelotelo kalumo. ");
INSERT INTO ata_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Miꞌunalai mo mixoo no nano voxo muxatele tamei mukalu xe iliꞌi la sou voxo sou laꞌiua ne muxali. ");
INSERT INTO ata_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","No tauu ie ane Noa tauu iexu muxali loxo itemaxu mavulovexa tatalu (600), no voxo mavulovexa mo mulelia taꞌuve mo muvaxa simi tamei no anu soꞌio tamei, la lexa luuluuxu no lia no xalexalee tuatuala muopuopu mutelo mukulukulupei lialia ilou lavolavoꞌo sou musiali loxo lexa uꞌani, xe lexa ane no loxotolo ꞌole taxataxasou kalumo muaꞌa sou laꞌiua tatila muxauxaumu muluꞌe no lia. ");
INSERT INTO ata_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Laꞌiua ane ne musisili aloxo ne aso xe ꞌolovoxo mavulovexa tamiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","No voxo ane ne, la Noa ilee semau mo ta ꞌolu tatalu, Semu, Amu mo Iapeti iloꞌa ta semasemaiꞌa miꞌunalai no lasipi. ");
INSERT INTO ata_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ta mimii iouiou latala ane ta temene mo aneꞌi ane ta vova ta toxotoxoxaꞌa mo ta kitukitu, aneꞌi ane ixaxalaxala mo aneꞌi ane ivavava, mo ta ngiangiala iouiou latala ne miꞌunalai kalumo no lasipi tanu. ");
INSERT INTO ata_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ta mimii iouiou latala e IAUE muvikalanu Noa lexe unoꞌa ne, vile paꞌusou uasi, munoꞌu sema vile xe mulu vile noxiꞌa vilevilesi mukalusi. Iloꞌa miꞌunalai mukalu, la sou Lataua molu mutatusou lasipi aitengaxu. ");
INSERT INTO ata_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","No nano no anu aso mo ꞌolovoxo mavulovexa tamiꞌa ne, lexa mupaapaa mutetelo ne mole mutetelo ne. Mo laꞌiua kalumo muxauxaumu mululuꞌe ne mo mululuꞌe ne, ia uxoxoto uasisi manina. ");
INSERT INTO ata_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Lautu tatila mole lasipi asou upuati no kupa loxoꞌu. Kupa lautuxu munononu xalexalee tuatuala mole lasipi ne mupuati no loxoꞌu lexa. ");
INSERT INTO ata_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Lexa lautuxu mutelai mutelai xoo mole muaꞌulixu mo mutaasou laxalaxaꞌilu no xalexalee tuatuala mukalu. ");
INSERT INTO ata_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ia musoxo mususuku mutetelai mo mutetelai la loxo lima mavulovexa vile mo mulelia taꞌuve. ");
INSERT INTO ata_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Ta mimii iouiou latala ane mauli muxolu noxiꞌa mimauli no lia no xalexalee tuatuala ꞌo ne, misoisoli mukalu. Ta ngiangiala iouiou iloꞌa ta mimii iouiou latala ane ta temene mo ta vova mo aneꞌi ane ixaxalaxala mo ta mitema latala ne misoisoli mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ta mimii iouiou latala ane mauli muxolu noxiꞌa mimauli no lia no xalexalee tuatuala ꞌo mo ta ngiangiala latala iouiou iloꞌa ta mimii iouiou ane latala ta temene mo ta vova mo aneꞌi ane ixaxalaxala mo ta mitema latala ne misoisoli mukalusi. Anu IAUE molusi mukalusiꞌa avile. ");
INSERT INTO ata_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Lexa lautuxu ne usii uluꞌelai palea uasi, mutavo muxoxoo aloxo ne voxo itemaxu taꞌuve mo mavulovexa taꞌuve (150). ");
INSERT INTO ata_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Noa iloꞌa ta ꞌolu mo semau iloꞌa ta uaꞌauaꞌaneꞌi ilou, mo ta mimii iouiou ane munoꞌa sou mitelo no lasipi kalumo ne, Lataua iou siꞌisiꞌa uasi, anu mupalusou atume sou muiili, la sou lexa lautuxu loxo luaki ne, musokou sou musii seꞌisisi muluꞌelai. ");
INSERT INTO ata_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Lexa luuluuxu no lia no xalexalee tuatuala mo lexa ane no loxotolo taxataxasou ne musovosovo mukalusi, la sou laꞌiua muxoto. ");
INSERT INTO ata_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","No nano no anu voxo aloxo itemaxu taꞌuve mo mavulovexa taꞌuve (150), la lexa mine lautuxu loxo luaki ne musii seꞌisisi mululuꞌelai. ");
INSERT INTO ata_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Xe no voxo mavulovexa vile mo mulelia taꞌuve mo tamei no anu soꞌio muxatele tamei, la lasipi mulai muꞌoso no laxaꞌilu vile kisou no laxalaxaꞌilu ne Alalati mole mutulu avile ane. ");
INSERT INTO ata_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Lexa musii mululuꞌelai ne mo mululuꞌelai ne. Xe no voxo vile voxosou soꞌio mavulovexa, la laxalaxaꞌilu kisokisou mupaapaa mukalu ");
INSERT INTO ata_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","xe voxo mavulovexa tamiꞌa mukalu la, la Noa mukisiinu aitengasou no lasipi ");
INSERT INTO ata_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","sou mupalusou ꞌola mulai sou ukili lexe lexa musii mukalu, la ua. Anu muvavava muvavaxa mulai muxixaoxao xoo mole lexa musii mo lia ne mutala. ");
INSERT INTO ata_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noa uutiti lexe ꞌola ulivu uneꞌe la uasi, la sou mupalusou utu sou mulai mukili lexe lexa a musii muluꞌelai. La uasi. ");
INSERT INTO ata_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lexa a mutaasou xalexalee tuatuala sio mole anu mii vile sou uxolu no anu uasi, la muvava mulivu muneꞌe no lasipi. Noa mukalanu avolu muatulai sou muxolu no anu, la sou muꞌunalaixu no nano. ");
INSERT INTO ata_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa muxolu no nano no lasipi sou muxoomaiou lexa sou usii uluꞌelai voxo muxatele tamei, xe iliꞌi la sou mupalusou utu ne mulai la. ");
INSERT INTO ata_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","No ꞌoloꞌolovoxo no voxo ane ne, la utu mulivu muneꞌe noxou Noa muꞌalavevenu lovo voloxu vile alavua no anaxu. Noa mumaisou la mulavu lexe lexa a usisii uluꞌelai sio. ");
INSERT INTO ata_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ioxe, anu mulavusou lexe lexa usii manina mo tani utala manina uao, la aneꞌi iloꞌa mixolu no nano ne, voxo muxatele tamei la. Ia utusi ane anu mupalusou mulai sou mukili la. No voxo ane ne, la ulivu uneꞌe la ua, mulai muxolu avile. ");
INSERT INTO ata_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","No voxo vile sou soꞌio vile no anu tauu ie ane, Noa tauu iexu muxali loxo itemaxu mavulovexa tatalu mo vile (601), la lexa musii mukalu avile. Xe muavuti la mulokenu lasipi laxaꞌu sou anu mulai mutulu teitexi sou musuꞌanu iou muluꞌe no xalexalee tuatuala. Iou muluꞌe la mumaisou lexe lexa a musii mukalu, ia tanisi a utala laixe uao. ");
INSERT INTO ata_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Iloꞌa mixoxoo no nano ne la, xe no voxo itemaxu vile mo taꞌuve mo muxatele tamei (27) sou soꞌio tamei, la tani mutala mukalu. ");
INSERT INTO ata_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","La sou Lataua muvikalanu Noa aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ngongie semameni mo ta ꞌilinge ngongou iloꞌa ta semasemaiꞌa ngauatulai no ale. ");
INSERT INTO ata_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nganoꞌa ta ngiangiala iloꞌa ta mimii iouiou ane ngongiꞌa ngexoo no nano ne mo ngongiꞌa ngalai no ale, mo sou aneꞌi ilai ixolu no tuala alavua sou ipalaa mo ixalixaꞌa ta ꞌiliꞌiliꞌa tapiena mo itaasou xalexalee tuatuala ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ioxe, aneꞌi miavuti la milutu sou milalaa miuatulai. ");
INSERT INTO ata_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ta ngiangiala iouiou iloꞌa ta mimii iouiou ne aneꞌi mikalikalineꞌi sou milalaa milai no ale kalumo. ");
INSERT INTO ata_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Milalaa mukalu, la Noa mutaxu lavoꞌo sou mutaꞌolunu mupita sou muxali loxo valovalo xe mukalu la munoꞌa ta mimii iouiou iloꞌa ta ngiangiala aneꞌi ane ilavusou iꞌiꞌa vilevilesi noxiꞌa sou ilee semau iloꞌa ta ꞌiliꞌiliꞌa mo ta uaꞌauaꞌaneꞌi miꞌelaxaꞌa mulai noxou Lataua mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Anu IAUE mumaisou mo mutumaꞌu ne, la mumasaxau la muꞌosasou misevile. La sou tanu muvikala aloxo ꞌo, “Eni ulai iliꞌi la aꞌoxo masuanu xalexalee tuatuala aloxo eni eꞌoxonu ꞌo, tavaꞌu no anu ꞌiliꞌilixo masumasua noxiꞌa ta mitema la ua, xo eni elavusou lexe no mine aneꞌi uao ta maumaulu mo ta vuavuanga ꞌo, la aneꞌi imasaxa lexe iꞌoxo ꞌiliꞌilixo masumasua ulalai ne. Mo eni akalusiꞌa ta mimii iouiou ane mimauli no lia, iloꞌa ta ngiangiala iouiou mo ta mitema la ua. Mukalu ano ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ia vaimomo ꞌo, mo ulai utalo iliꞌi manina no anu voxo ane xalexalee tuatuala ukalu no anu ne, voxo uxolu sou ixaxai mo itotou mimii mo ikookooli. Voxo seꞌi, la ixamuli tani lelemesou xe tani ialuxu. Voxo seꞌi, la aso xe laꞌiua xe aso xe ꞌolovoxo, ia ukalu uasi, xo xalexalee tuatuala ꞌo ne, uxolu aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Xe Lataua muavuti, la mualusiꞌa Noa iloꞌa ta ꞌolu, la muvikalaneꞌi aloxo ꞌo, “Ngapalaa mo ta ꞌilinge ixali tapiena mo sou ta xasixasinge iloꞌa ta ꞌiluꞌilusungengi ixali tavuꞌalo sou iꞌanaꞌana no xalexalee tuatuala ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ta mimii iouiou ane ta temene mo ta vova mo aneꞌi ane ixalaxala mo ta ngiangiala iouiou iloꞌa ta sinana ne, iꞌumenge. Ia aneꞌi ixolu no avonge. ");
INSERT INTO ata_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ngingi ngamasaxaiꞌa lexe ngaꞌiꞌa, la sou ngaveꞌa sou ngaꞌiꞌa. Mo kamakamakala iouiou ne, ngainixu sou ngaꞌou kalumo xo eni emuxaxaꞌa lexe ngingi laꞌilalingenge ane. ");
INSERT INTO ata_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ia, mii vilesisi lexe mamu ngaꞌou ane, mii xiasi siasialuxu o. Eni emasaxainge lexe mamu ngaꞌou, xo sialuxu ne mauli a uxoo no anu sio. ");
INSERT INTO ata_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Io, ta mii ane ta temene mo ta vova ivau itema vile usoli, la eni aveꞌa isoli kalumo. Xe itema ane uvau itema vile usoli, la akalusou maulixu mitema ane ne kalumo. ");
INSERT INTO ata_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ta mitema ne, Lataua mukoineꞌi, la mixali loxo anu Lataua. La sou lexe itema vile uvau menexu vile, la vile uneꞌe ukolinu ane musoli ne sou uvau. ");
INSERT INTO ata_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Emasaxa lexe ngapalaaneꞌi ta ꞌilinge tapiena, mo sou ta xasixasinge iloꞌa ta ꞌiluꞌilusungengi ixali tavuꞌalo sou iꞌanaꞌanalixu xalexalee tuatuala ꞌo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Xe Lataua muavuti la muvikalaneꞌi Noa iloꞌa ta ꞌolu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Vaimomo ꞌo eni apalaꞌalixu vaikala sou opo vilesisi eni asakiinu noxinge. Mii ane eni alemolu ꞌo, uxolu mo umauli noxinge mo noxiꞌa ta xasixasinge iloꞌa ta ꞌiluꞌilusungengi ane ipaa iliꞌi ");
INSERT INTO ata_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","mo ta mii iouiou latala ane ngongiꞌa ngelalaa muatu no lasipi ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Vaikala sou opo vilesisi eni asakiinu noxinge aloxo ꞌo, eni umomomo sou aꞌoxo masuaneꞌi mo aꞌunaneꞌi ta mitema iloꞌa ta mimii iouiou ꞌo mo xalexalee tuatuala la ua. ");
INSERT INTO ata_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Sosovo ane eni amuxaxu ꞌo sou uꞌoxo tuꞌumaxu sou opo vilesisi ane eni esakiinu noxinge ngongiꞌa ta mimii iouiou e ngongiꞌa ngaxoxolu vaimomo ꞌo xe noxiꞌa aneꞌi ane ixali iliꞌi. ");
INSERT INTO ata_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Muloxu leleꞌe eni eꞌoxonu muxolu no tamuxala ne anu sosovo sou opo vilesisi eni esakiinu ulai noxiꞌa ta mitema no xalexalee tuatuala no lialia ukalusi ane. ");
INSERT INTO ata_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Lexe eni asuꞌasou loxotolo no anu tamuxala xe leleꞌe muloxu upalaꞌa, ");
INSERT INTO ata_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","la eni axavutalanu vaikala sou opo vilesisi eni esakiinu noxinge, lexe mamu la eni aꞌoxo masuanu mo aꞌunanu xalexalee tuatuala mo ta mitema iloꞌa ta mimii iouiou ane ixoo sou imauli no anu tauu ano ꞌo, mo ulai avile iliꞌi. ");
INSERT INTO ata_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Lexe eni amaisou muloxu leleꞌe uxali no anu tamuxala, la eni axavutalanu vaikala sou opo vilesisi e eni esakiinu noxinge. Vaikala sou opo vilesisi e eni esakiinu ane ne, uxolu aloxo nesi mo kaluxu uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Muloxu leleꞌe ne, anu sosovo sou vaikala sou opo vilesisi ane eni esakiinu mulai noxinge ngongiꞌa ta mimii mukalusi e ixoxolu imaumauli no lia ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa ta ꞌolu tatalu e iloꞌa milalaa muatu no lasipi ano, eiae Semu ilou Amu mo Iapeti (Amu ne, anu Kanani momu). ");
INSERT INTO ata_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ta mitema ane mimauli no xalexalee tuatuala ꞌo ne, ta mutuꞌu ovuxaꞌa ane Noa ta ꞌolu tatalu ne. ");
INSERT INTO ata_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa ne, anu itema sou xai. Anu itema ane musokou sou mutou ovu uaini tei ane. ");
INSERT INTO ata_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Voxo vile, la anu muiexu uaini seꞌi la xavutalau ne muxovulaulau, mole ulavu ua. Muavuti la muxexenu lavalavau ia, muai vitanisi no nano no taasou. ");
INSERT INTO ata_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ꞌOlu Amu muꞌunalai la mumaisou momu muai loxo nesi, xe muatu la muaꞌaloiꞌa ta vimovimou ta tamei ꞌole. ");
INSERT INTO ata_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","La sou Semu ilou Iapeti minoꞌu lavalava vile sou mixavulalanu ia mitetelisou iliꞌi no laxasiꞌa, io sou aneꞌi ilou mimuamuaꞌi tumaliꞌa mulai loxo noxou mamiꞌa uai ꞌole sou milai misuꞌasou. Ia ilou ieꞌi uxiu ulai no tumaliꞌa sou imaisou mamiꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Iliꞌi xe Noa mutulu, la sou tanu tema la mulavu no anu mii e anu ꞌolu Amu muꞌoxonu noxou. ");
INSERT INTO ata_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Xe anu mamiꞌa muavuti la muvikala aloxo ꞌo, “Eni elavu lexe Latauasi ulosou Kanani navunavu. Iliꞌi la anu uxali itema vile vitanisi no laaxaꞌa ta vimovimou sou ipalupalusousi. ");
INSERT INTO ata_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ia nenge taꞌiti ualasou IAUE, Lataua noxou Semu. Kanani ne uxolu no laaxu Semu sou upalupalusou. ");
INSERT INTO ata_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Lataua molu ualusou Iapeti sou ta ꞌolu ixali tavuꞌalo sou iloꞌa ta mitema noxou Semu ixolu xoluxoluxaꞌa vilesisi. Kanani ne, uxolu no laaxu Iapeti sou upalupalusou.” ");
INSERT INTO ata_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Xe iliꞌi no anu laꞌiua toxoxaꞌa te muꞌunaneꞌi ta mitema iloꞌa ta mimii iouiou ꞌo mukalu, la Noa muxolu sou mumaulixu tauu ie itemaxu mavulovexa vile mo itemaxu taꞌuve mo mavulovexa taꞌuve (350) la. ");
INSERT INTO ata_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamiꞌa mo itemaxu taꞌuve mo mavulovexa taꞌuve (950) la sou musoli. ");
INSERT INTO ata_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Xe iliꞌi no anu laꞌiua toxoxaꞌa ne, la anu Noa ta ꞌolu ne mipalaa la mixalixaꞌa ta ꞌiliꞌiliꞌa. Nanasiꞌa mulai aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iapeti mupalaa, la muxalixaꞌa ta ꞌolu ta mulu la ualaualasiꞌa aloxo ꞌo, Xomeli, Maxoxu, Matai, Iavani, Tuvalu, Meseki mo Tilasi. ");
INSERT INTO ata_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Xomeli ta ꞌolu mo ta xasoxasou mo ta ꞌiluꞌilusunu ane mixalixaꞌa ta tema tuala ne Asikena, mo ne Lipata mo ne Toxama. ");
INSERT INTO ata_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Xe Iavani noxou ane mixalixaꞌa ta tema tuala ne Elisa mo ne Tasisi, ne Saipasi xe ne Lotan. ");
INSERT INTO ata_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Aneꞌi ta mitema ane ne, ta xasixasiꞌa ta mitema ane mixolu mimauli no laꞌolaꞌolu xe no luaki paꞌumolu. Aneꞌi ta mitema ane ne, aneꞌi Iapeti ta xasoxasou mo ta ꞌiluꞌilusunu. Aneꞌi mikalikalineꞌi no anu matamata noxiꞌa sou milai mixolu no tuatualasiꞌa vilevilesi. Mo ivivikala no anu vaivaikalaiꞌa vilevilesi. ");
INSERT INTO ata_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Xe Amu mupalaa, la ta ꞌolu ualaualasiꞌa ano ꞌo, Kusu, Aixiputo, Livia xe Kanani. ");
INSERT INTO ata_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusu mupalaaneꞌi ta ꞌolu ta mulu, la ta ꞌolu mixalixaꞌa ta mitema sou tuala ne Siva, ne Avila, ne Savata, ne Lama xe ne Savateka. Lama mupalaaneꞌi ta ꞌolu, la ta ꞌolu mixalixaꞌa ta mitema sou tuala ne Seva xe ne Tetan. ");
INSERT INTO ata_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusu mupalaa ꞌolu vile la mumoxoꞌu ualasou lexe Nimuloti. Nimuloti muxali tei loxo anu itema sou xavi manina no lia no xalexalee tuatuala. ");
INSERT INTO ata_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","No anu xavi mo suꞌuli noxou IAUE, anu muxali loxo itema sou paipaa. Anu aloxo ne la sou ane ta mitema ivikala lexe, “IAUE molu ualusine mo sou naxali namitema sou paipaa loxo Nimuloti.” ");
INSERT INTO ata_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Anu musaxilaꞌu tuala tamiꞌa tei, Vaviloni, Eliki, Akati xe Kalune. Anu tuala tamiꞌa mixolu no nano no tuala tila ne Vaviloni. ");
INSERT INTO ata_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mulutu lai ne la sou mulai ne Asiria sou muꞌilii tuala tila ne Ninive, xe ne Leovotia ne Kala xe ");
INSERT INTO ata_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ne Leseni. Leseni ne mixoo no nixi ne Ninive xe tuala tila ne Kala. ");
INSERT INTO ata_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Aixiputo ta ꞌolu, mo ta xasoxasou mo ta ꞌilusulusu mixalixaꞌa ta mitema ane ta tema tuala sou tuala ne Litia mo ne Anama, ne Leavu mo ne Naputu. ");
INSERT INTO ata_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Ne Patulusi, ne Kasulu xe ne Kilite. Ta mitema ne Pilisutain ne, ta ꞌilusulusuneꞌi mitulu ane ne Kilite. ");
INSERT INTO ata_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanani ta ꞌolu ualaualasiꞌa aloxo ꞌo, Saidoni laposalaxu xe Keti. ");
INSERT INTO ata_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanani ta ꞌiluꞌilusunu ane mixalixaꞌa ta mitema sou tuala ne Ievusi, ne Amolu, ne Xilixasi, ");
INSERT INTO ata_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ne Ivi, ne Alikete, ne Sini, ");
INSERT INTO ata_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ne Aluvati, ne Semari xe ne Amati. Ta Kanani mixali tavuꞌalo la mikalikalipalaꞌa sou milai mixolu no xalexalee tuatuala tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Pilixaxaꞌa musokou ane ne Saidoni la sou mulai mutalo ane ne Xasa no xalee ne Xelalu. Xe no xalee mulai loxo aso uxali utelo no anu mulai mutalo ne Sodomu, xe ne Xomola, ne Atama xe ne Sevoimu ulai ne Lasa. ");
INSERT INTO ata_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aneꞌi ane ne, aneꞌi mixali noxou itema vilesisi ane, Amu. Aneꞌi mikalikalineꞌi no anu matamata noxiꞌa sou milai mixolu no tuatualasiꞌa vilevilesi mo ivivikala no anu vaivaikalaiꞌa vilevilesi. ");
INSERT INTO ata_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semu, anu Iapeti vimou tila, anu muxalixaꞌa Eve ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌilusulusunu. ");
INSERT INTO ata_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semu ta ꞌolu ane, Elamu, Asulu, Apasata, Litia xe Alamu. ");
INSERT INTO ata_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alamu ta ꞌolu mixalixaꞌa ta mitema sou tuala ne Usu, ne Ulu, ne Xelete mo ne Meseki. ");
INSERT INTO ata_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apasata ꞌolu ane Sela. Xe Sela ꞌolu ane Eve. ");
INSERT INTO ata_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Xe Eve mupalaa la sou muxalixaꞌa ta ꞌolu tamei, vile ualasou lexe Pelexi, xo no anu imamanu ane ne la ta mitema no xalexalee tuautala ꞌo mikalipalaꞌa, xe ꞌolu vile ualasou lexe Iokutani. ");
INSERT INTO ata_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Iokutani ta ꞌolu mixalixaꞌa ta mitema sou tuala ane, ne Alamota, ne Selepi, ne Asamaveti, ne Iela, ");
INSERT INTO ata_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ne Atolamu, ne Usala, ne Tikala, ");
INSERT INTO ata_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ne Ovala, ne Avimaele, ne Seva, ");
INSERT INTO ata_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ne Opili, ne Avila xe ne Iovavu. Ta mitema no tuatuala ane ne, mixali noxou itema vilesisi ane, Iokutani. ");
INSERT INTO ata_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Lia xalee ane aneꞌi mixolu no anu ne, molu ane ne Mesa la mulai mutalo ane ne Sepa no laxalaxaꞌilu no xalee mulai loxo aso utelo no anu. ");
INSERT INTO ata_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aneꞌi ta mitema ane ne, mipaa noxou itema vilesisi ane Semu. Aneꞌi mikalikalineꞌi no anu matamata noxiꞌa sou mixolu no tuatualasiꞌa vilevilesi mo mivivikala no anu vaivaikalaiꞌa vilevilesi. ");
INSERT INTO ata_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aneꞌi ta mitema ane aneꞌi ta matamata noxiꞌa Noa ta ꞌolu tatalu ne. Xe iliꞌi no anu laꞌiua toxotoxoxaꞌa, la Noa ta ꞌolu mixalixaꞌa ta mitema no xalexalee tuatuala ukalusi. Aneꞌi ta mitema ane ne, aneꞌi ta matamata noxiꞌa manina. ");
INSERT INTO ata_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tei, la ta mitema ane mimauli no lia no xalexalee tuatuala ꞌo ne, vaikalaiꞌa vilesisi. Vaivaikala maumautunu ane aneꞌi ivivikala no anu ne vilesisi kalumo. ");
INSERT INTO ata_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mixixaoxao no xalexalee lia mulai loxo no xalee ane aso uxali utelo no anu, la sou milai mixali no latia vile ne Vaviloni sou mixolu ane. ");
INSERT INTO ata_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Xe miavuti la mivikalaneꞌi ngatoꞌo aloxo ꞌo, “Laixe nenge taulaluumenge pilika maumautunu ka taꞌelaxu mo sou uxali pekiaꞌu loxo lavoꞌo.” La sou aneꞌi minoꞌu pilika maumautunu loxo ulaluu ia pekiaꞌu sou mitulusou tani no anu. Miteitei koluta sou mutetelisou pekiaꞌu. ");
INSERT INTO ata_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ioxe, aneꞌi miavuti la mivikala aloxo ꞌo, “Vaimomo, ꞌo nenge ta ꞌiliisinge tuala vile tatila mo tatulusou tani vile veveeni utelai utalo teiteixi no loxotolo mo sou nenge ualasinge utelai. Mo nenge taxolu tapita vilesisi ano ꞌosi, ia tapaxele mo talai taxolu vaꞌaxu no xalexalee tuatuala seꞌi la uasi.” ");
INSERT INTO ata_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Xe iliꞌi, la IAUE Lataua muluꞌe sou mumaisou tuala ilou tani e ta mitema mitulusou ne, ");
INSERT INTO ata_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","la muvikala aloxo ꞌo, “Ta mitema ano ꞌo ne, aneꞌi ta mitema vilesisi mo vaikalaiꞌa vilesisi. Aneꞌi a misokou ꞌo sou imasaxa lexe imulinu masaxa noxiꞌa sou lexe ixotataoneꞌi. Iliꞌi xe aneꞌi ieꞌisou la, xe imasaxa lexe iꞌoxonu mii vile la, la aneꞌi iꞌoxonusi. ");
INSERT INTO ata_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Laixe nenge taluꞌelai mo taꞌinanu vaikalaiꞌa no anu vaivaikala piena mo sou mamu aneꞌi ivivikala no anu vaikala vilesisi.” ");
INSERT INTO ata_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","IAUE Lataua muavuti la mukalipalaꞌaneꞌi sou milai mixolu vaꞌavaꞌaxu no xalexalee tuatuala mole tuala ilou tani e mitutulusou ne musuꞌa. ");
INSERT INTO ata_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tuala ne milemolu ualasou lexe Vavelu xo IAUE Lataua muꞌinanu vaikalaiꞌa xe mukalipalaꞌaneꞌi sou milai mixolu vaꞌavaꞌaxu ane. ");
INSERT INTO ata_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ioxe, nanasiꞌa ta mitema ane Semu muxalixaꞌa aloxo ꞌo. Tauu ie tamei mukalu iliꞌi no anu, lexa muꞌunanu xalexalee tuatuala, la Semu tauu iexu mulai muxali loxo itemaxu taꞌuve (100), la anu mupalaanu ꞌolu vile ualasou lexe Apasata. ");
INSERT INTO ata_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Xe iliꞌi la anu mumaulixu tauu ie loxo itemaxu mavulovexa tamei mo itemaxu taꞌuve (500) la. No nano no tauutauu ie ane ne, la anu mupalaaneꞌi ta ꞌolu seꞌi la, ka musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Xe Apasata tauu iexu mulai muxali loxo mavulovexa tatalu mo taꞌuve, la mupalaanu ꞌolu vile ualasou lexe Sela. ");
INSERT INTO ata_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Anu muxolu mumaulixu tauutauu seꞌi la. Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamei mo tatalu (403), la anu mupalaaneꞌi ta ꞌolu seꞌi la, ka musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Xe Sela tauu iexu mulai muxali loxo mavulovexa tatalu, la mupalaanu ꞌolu vile ualasou lexe Eve. ");
INSERT INTO ata_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Xe iliꞌi, la mupalaaneꞌi ta ꞌolu seꞌi la. Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamei mo tatalu (403), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Xe Eve tauu iexu mulai muxali loxo mavulovexa tatalu mo tamiꞌa, la mupalaanu ꞌolu vile ualasou lexe Pelexi. ");
INSERT INTO ata_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Xe iliꞌi la, la mupalaaneꞌi ta ꞌolu seꞌi la. Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamei mo mavulovexa tatalu (430), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Xe Pelexi tauutauu iexu mulai muxali loxo mavulovexa tatalu, la sou anu mupalaanu ꞌolu laposalaxu ualasou lexe Leu. ");
INSERT INTO ata_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Xe iliꞌi, la mupalaaneꞌi ta ꞌolu seꞌi la. Xe tauu iexu mulai muxali loxo itemaxu mavulovexa tamei mo muxatele tamiꞌa (209), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Xe Leu tauu iexu mulai muxali loxo mavulovexa tatalu mo tamei, la sou mupalaanu ꞌolu laposalaxu ualasou lexe Seluxu. ");
INSERT INTO ata_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Xe iliꞌi, la mupalaaneꞌi ta ꞌolu seꞌi la, xe tauu iexu mulai muxali loxo itemaxu mavulovexa vile mo muxatele tamei (207), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Xe Seluxu tauu iexu mulai muxali loxo mavulovexa tatalu, la mupalaanu ꞌolu laposalaxu ualasou lexe Naola. ");
INSERT INTO ata_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Xe iliꞌi, la mupalaaneꞌi ta ꞌolu seꞌi la. Xe tauu iexu mulai muxali loxo itemaxu mavulovexa vile (200), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Xe Naola tauu iexu mulai muxali loxo itemaxu vile mo muxatele tamiꞌa, la sou mupalaanu ꞌolu laposalaxu ualasou lexe Tela. ");
INSERT INTO ata_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Xe iliꞌi, la mupalaaneꞌi ta ꞌolu seꞌi la. Xe tauu iexu mulai muxali loxo itemaxu taꞌuve mo muvaxa simi tamiꞌa (119), la sou anu musoli. ");
INSERT INTO ata_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Xe Tela tauu iexu mulai muxali loxo mavulovexa muxatele tamei (70), la sou anu mupalaaneꞌi Avalamu ilou Naola mo Alani. ");
INSERT INTO ata_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ioxe, nanasiꞌa aneꞌi ta mitema ane Tela muxalixaꞌa ano ꞌo. Tela mupalaaneꞌi Avalamu ilou Naola mo Alani. Xe Alani, la mupalaanu eiae Loto. ");
INSERT INTO ata_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Xe iliꞌi, la sou musoli no tualasou ne Ulu no nano no xalee lia tila ne Vaviloni. Alani musoli, ia momu Tela ne usoli palea uasi, anu muxoxoolu ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Xe iliꞌi, la sou Avalamu muꞌuluxe Salai, xe Naola muꞌuluxe Milika, Alani ꞌolu sema mo ꞌolu mulu vile kalumo ualasou lexe Isika. ");
INSERT INTO ata_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ia Avalamu semau Salai ne ipalaa uasi. ");
INSERT INTO ata_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela mukasi noxou ꞌolu Avalamu xe xasou Loto eiae Alani ꞌolu, xe uaꞌanu Salai, Avalamu semau, la iloꞌa mivulasou tualasiꞌa ne Ulu no nano no xalee tila ne Vaviloni sou ilai ixolu ne Kanani. Milai mixali no tuala ne Alani la mixolu ane, ");
INSERT INTO ata_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","la sou Tela, Avalamu momu tauu iexu mulai muxali loxo itemaxu mavulovexa vile mo taꞌuve (205), la sou musoli. ");
INSERT INTO ata_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ioxe, IAUE muavuti la muvikalanu Avalamu aloxo ꞌo, “Mamine ta minuminu ixoo no tualasinge ngongiꞌa mo lialiangenge ngongiꞌa ne, ia nini nalutu mo nalai no lia xalee ane eni melo alosienixu sou nalai no anu. ");
INSERT INTO ata_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Lexe nini nalomuxo mo naꞌoxo aloxo ne, la nini naxalixaꞌa ta mitema tapiena aso vile mo eni aalusine sou nini naxali itema vile toxoxaꞌa mo itema sou lavuluti. Ualasine kalumo ne, uxali tatila sou ta mitema tapiena ilavusine. La sou ualasine upalaꞌa no anaxaꞌa aneꞌi ane ialusiꞌa aso vile iliꞌi. Ivikala aloxo ꞌo, ‘Lataua ualusinge loxo mualusou Avalamu.’ ");
INSERT INTO ata_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Eni aalusiꞌa aneꞌi ane ialusine. Ta mitema ane iꞌoxo masuaneni ne, eni akolineni la aꞌoxo mausaneꞌi kalumo. Eni aalusiꞌa ta mitema no xalexalee tuatuala ukalusi no anu voteꞌi vilesisi. Voteꞌi ane ne, anu nini Avalamu.” ");
INSERT INTO ata_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","La sou anu mulutu muxexesie Alani loxo IAUE muvikalanu sou mulai. No anu voxo ane ne, anu Avalamu tauu iexu mulai muxali loxo mavulovexa muxatele tamei mo taꞌuve (75). Loto kalumo ne, mumulinu sou ilou milai. ");
INSERT INTO ata_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Mulutu la munoꞌe Semau Salai xe vimou ꞌolu, ualasou lexe Loto. Ta mitemau mo ta miumiu ane usasaxilaꞌa loxo ta kau iloꞌa ta sipsip, mo ta mee mo lavulavuluti iouiou ne, mukaolineꞌi mukalusi sou iloꞌa milai no xalee lia ne Kanani. ");
INSERT INTO ata_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Avalamu mumuamuaꞌi muꞌunalai no nano no lia xalee ane IAUE mupalusou lexe ulai no anu xoo la, mulai muxali no tuala vile sou la lotu noxiꞌa ta mitema ne Kanani. Tuala ane ne, ilemolu lexe Sikemu. Ovu tavuna vile a muleme no tuala ane ne ilemo lexe More. No voxo ane ne, la ta mitema sou tuala ne Kanani, aneꞌi mixoxoolu no tuala ane ne sio. ");
INSERT INTO ata_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","IAUE mupalaꞌa noxou Avalamu, la muvikalanu aloxo ꞌo, “Tuala e lexe eni alosiꞌa ta xasixasine iloꞌa ta ꞌiluꞌilusuneni ane.” La sou Avalamu muavuti la mutaꞌolunu lavolavoꞌo sou muxali loxo valovalo sou muꞌelaxaꞌa ta sipsip mulai noxou IAUE. ");
INSERT INTO ata_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Xe iliꞌi la anu musuku mulai iliꞌi no laxalaxaꞌilu no xalee mulai loxo aso uxaxali utelo no anu no tuala tila ne Veteli. Veteli ne mixolu no xalee mulai loxo aso ulololo no anu. Xe ne Ai no xalee mulai loxo aso uxaxali utelo no anu. Mulai muxolu ane no nixi no tuala tamei ne. Xe muavuti la muvalovalo no lavoꞌo alaxu vile la sou muꞌelaxaꞌa ta sipsip seꞌi mulai noxou, xe mulotu mulai noxou IAUE. ");
INSERT INTO ata_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Xe muavuti la musukusukululu no tuatuala mulalai loxo ne Nexevu. ");
INSERT INTO ata_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Xe iliꞌi, la soli muxali ne Nexevu, mole ta mitema ne xaꞌa laꞌilali uasi manina. Soli mupakipakikineꞌi manina. La sou Avalamu muluꞌe ꞌalai ne Aixiputo sou muxolu ane, ia uxolu maxuveni lai ne uasi, xo anu uꞌunalai ne Aixiputo ne uao. ");
INSERT INTO ata_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ioxe, anu alalai sou lexe uaalasou pilixa sou uꞌunalai ne Aixiputo, la mupelaꞌe semau aloxo ꞌo, “Eiseo, nini ne nini sema laixe misevile, ieni ne lailaixe misevile. ");
INSERT INTO ata_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Maasi xe ta Aixiputo imaisine la aneꞌi ilavusi lexe eni semaxe ane nini, la aneꞌi ivelo asoli, ia ninisi naxolu, ia ivene uasi. ");
INSERT INTO ata_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Maasi xe nenge nengei taꞌunalai no tuala ne Aixiputo ne, xe italiꞌisine la navikalaneꞌi lexe eni vivilo sema ane nini ne. Mo sou aneꞌi ieꞌi uvaxailosi mo iꞌoxo laixe noxilosi.” ");
INSERT INTO ata_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Xe ilee semau mimuamuaꞌi miꞌunalai ne Aixiputo, la ta Aixiputo mimaisie Salai la miisuxe. ");
INSERT INTO ata_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ta mitema seꞌi ta tatila noxou tatananu tuala vile ne Aixiputo ne mimaisie kalumo la milai mivikalanu tatananu tuala ne Aixiputo lexe sema vile iei lailaixe misevile a ilou mulu vile mixali. Anu muavuti la mupalusiꞌa sou milai mineꞌene milai noxou. ");
INSERT INTO ata_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Xe mumaisie la mumasaxaie misevile. Mulue Avalamu ne, iou muvaxausi mo muꞌoxo laixe noxousi. Xe muavuti la muitiu ta sipsip mo ta mee mo ta kau mo ta donki mo ta kameli mo ta mitema sou upalupalusiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ia iliꞌi, la IAUE muxalixu pipiena ilou navunavu iouiou noxiꞌa tatananu tuala ne Aixiputo iloꞌa ta mitema noxou xo tatananu tuala ne, munoꞌe Salai mo mulai sou muꞌuluxe. ");
INSERT INTO ata_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Aloxo ne la sou anu muꞌavalou Avalamu sou mulai noxou sou mutaliꞌisou aloxo ꞌo, “Loxovaa ane nini neꞌoxo ꞌilixo ano ꞌo noxilo loxo ꞌo? Navikalaleli lamana lexe Salai ane semameni ua, ");
INSERT INTO ata_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","nevikala lexe vivine ane ane, la sou ane eni enoꞌe lexe semaxeni ꞌo. Eꞌe, semameni ane nalivulixe ilai noxine mo ngongou ngauatulai ane alalae ꞌosi.” ");
INSERT INTO ata_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tatananu tuala ne muvikalanu aloxo ne xe mukalu, la sou mupalusiꞌa ta tatila noxou sou minoꞌa Avalamu ilee semau mo miꞌamiꞌa sou miuatulailixaꞌa sou milaa mixexeesou tualasou. ");
INSERT INTO ata_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ioxe, Avalamu mulaa molu ne Aixiputo muatu la mulai no xalee ne Nexevu, ilee semau. Miꞌamiꞌa latala ne minoꞌu mukalusi. Loto kalumo ne iloꞌa milai. ");
INSERT INTO ata_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Avalamu anu itema sou lavuluti. Ta sipsipou mo ta meeou mo ta kauou ne tavuꞌalo misevile. Lamoliou kalumo tavuꞌalo misevile. ");
INSERT INTO ata_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Xe iliꞌi la anu musukusou tuala ane ne sou mulai loxo ne Veteli. Mulai xoo la mulai muxali no tuala vile no nixi no tuala tila tamei ne Veteli xe ne Ai. ");
INSERT INTO ata_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Anu muneꞌe muxali no valovalo ane anu mutulusou sou muxolu tei ane, sou mulotu mulai noxou. ");
INSERT INTO ata_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loto kalumo ne miumiu piena misevile aloxo Avalamu mo ta mitemau kalumo tapiena misevile. ");
INSERT INTO ata_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Iloꞌa ikekei sou isukusuku ilalai aloxo ne la sou ta meeiꞌa iloꞌa ta sipsipiꞌa mo ta kauiꞌa ne tapiena misevile la iaꞌeiaꞌe latilatiasou mine tatatila ne, ia iꞌou la ukalasiꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","La sou anu, ꞌotoꞌoto muxali no nixi noxiꞌa ta mitema sou isaxisaxilaꞌa ta meeiꞌa iloꞌa ta sipsip mo ta donki mo ta kau. No tauu ie ane ne, ta Kanani iloꞌa ta Peresi mixoxoolu no xalee lia ane ne ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ioxe, Avalamu muavuti la muvikalanu Loto aloxo ꞌo, “Nenge nengei ꞌo ne, nenge nengei vilesisi, mamu ta mitema noxinge nengei iꞌotoꞌoto loxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Natulu mo namaisou lia xalee toxoxaꞌa e no talanenge ꞌo. Laixe nenge nengei takalipalaꞌa. Lexe masaxa noxine aloxo ne, la sou nini mene nalemolu xalee ane nini namasaxa lexe nini nalai no anu. Lexe nini nalai no xalee ano ꞌole, la eni alai no xalee ano ꞌole.” ");
INSERT INTO ata_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Xe Loto muavuti la mutulu sou musuꞌasuꞌa iou xoo la mumaisou vanunuxe Ioridani mulai muxali ne Soalu lexe anu lia xale ane ne, lexalexasou piena loxo xalee lia noxou IAUE xe loxo lialia ne Aixiputo. ");
INSERT INTO ata_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Aloxo ne, la sou Loto muilou sou mumasaxau Ioridani vanunuxe lexe anu ulai no anu. La sou anu mulutu sou mulai no anu no xalee mulai loxo no xalee ane aso uxaxali utelo no anu. Anu aꞌalosou kalipalaꞌa noxiꞌa ilou aloxo ne. ");
INSERT INTO ata_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Io, anu Avalamu ne muxolu ane ne Kanani ne, ia Loto ne mulai muxolu no nixi no tuatuala seꞌi no vanunu ne sou muꞌilii tualasou ꞌalai ne Sodomu. ");
INSERT INTO ata_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ta mitema sou tuala ane ne, aneꞌi ta mitema masumasua misevile. Aneꞌi ilavusou iꞌoxoꞌoxo ꞌiliꞌilixo iouiou masumasua misevile no iou IAUE utotomu. ");
INSERT INTO ata_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ioxe, Loto mulai io, IAUE muvikalanu Avalamu aloxo ꞌo, “Natulu ane naxoxoo no anu ne, mo nasuꞌasuꞌa ieni ulai no xalexalee lialia ꞌo ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Lialia no xalexalee tuatuala ane ne, eni alosine ngongiꞌa ta ꞌiliꞌiline mo ta xasixasine mo ta ꞌilusulusuneni mo kaluxu uasi. Lialia ane ne ngingi ngaꞌangingi ukalusi avile. ");
INSERT INTO ata_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Eni axalixaꞌa ta ꞌilusulusuneni tavuꞌalo misevile mo ixali tapiena loxo ioꞌiioꞌi no tasiꞌi la evile umomomo sou uitisiꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ioxe, nalutu mo nalai nakilolou lia xalexalee ane ne ukalusi, xo eni aitixene ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","La sou Avalamu musukunu taasou sou mulai mutulusou ꞌalai no ovu tavuna ne Mamule no tuala ne Ebulon, la sou muvalovalo no lavoꞌo sou muꞌelaxaꞌa ta sipsip seꞌi mulai noxou IAUE. ");
INSERT INTO ata_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Ioxe, no tauu ie ane Bera, anu tatananu tuala ne Sodomu xe Bilusa anu tatananu tuala ne Xomola, xe Sinap anu tatananu tuala ne Atama, xe Semevelu anu tatananu tuala ne Sevoimu, xe tatananu tuala ne Bela, tuala ane ne ilemolu kalumo lexe Soalu. Kedolulaome anu tatananu tuala ne Elamu. Anu musaxilaꞌa ta tatananu tuala no xalee ne Sodomu mo ne Xomola mo ne Atama mo ne Sevoimu mo ne Bela. Anu musaxilaꞌa tauu ie mavulovexa mo mulelia tamei. Xe no anu tauu ie mavulovexa mo mulelia tatalu la aneꞌi ilomuxu vaikalau Kedolulaome uasi. Ioxe, no anu tauu iexu mavulovexa vile mo mulelia tamiꞌasou, la sou anu muꞌavaliꞌa ta menexu tatalu, eiae Amulapelu anu tatananu tuala ne Vaviloni, Alioku anu tatananu tuala ne Elasa mo Taitalu anu tatananu tuala ne Xoimu. Aneꞌi ta tatananu tuala tamiꞌa ne, iloꞌa ta mitema sou ꞌotoꞌoto noxiꞌa milai sou iloꞌa ta mitema sou ꞌotoꞌoto noxou Lepaimu ne Asutelo-kananimu sou iloꞌa miꞌoto, la aneꞌi tamiꞌa ne mitaloxolixaꞌa Lepaimu iloꞌa ta mitema sou ꞌotoꞌoto noxou. La mitaloxolixaꞌa ta Sus ne Amu mo ta Emu iloꞌa ta mitema sou ꞌotoꞌoto noxiꞌa no latia ne Kiliataimu. Xe mitaloxolixaꞌa ta Xori no laxaꞌilu ne Seiru ka milelemulineꞌi milai mitalo no tuala ne Elu-paran ꞌalai no xalee lia vitanisi. Ka sou mixiu sou mixixao milivu mineꞌe ne Kadesi. Mitaloxolixaꞌa ta mitema sou miveꞌaveꞌa no xalee lia ne Ameleki mukalusi. Ka iloꞌa ta Amolu ne Asason-tama miꞌoto la aneꞌi mitaloxolixaꞌa mukalusi. Xe iliꞌi, la ta tatananu tuala taꞌuve ne Sodomu ilee Xomola mo ne Atama mo ne Sevoimu mo ne Bela minoꞌa ta mitema sou ꞌotoꞌoto noxiꞌa sou milai no vanunu ne Sitimu sou iloꞌa ta tatananu tuala ne Elamu mo ne Xoimu, mo ne Vaviloni mo ne Elasa miꞌoto. Aneꞌi ta mitema sou ꞌotoꞌoto noxiꞌa ta tatananu tuala taꞌuve ne, iloꞌa ta mitema sou ꞌotoꞌoto noxiꞌa ta tatananu tuala tamiꞌa ualasiꞌa lexe, Amulapelu ilou Alioku mo Kedolulaome xe Taidalu, iloꞌa miꞌoto. ");
INSERT INTO ata_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Vanunu ne Sitimu ne, koluta taxataxasou muꞌanaꞌana no anu. Ioxe, ta tatananu tuala ne Sodomu ilee Xomola iexe lexe iꞌume loxo ꞌo la ua, iloꞌa ta mitema sou ꞌotoꞌoto noxiꞌa seꞌi mitalotaloxo miluꞌe no taxataxa, ia tavuꞌalo noxiꞌa ne miꞌume milai no laxalaxaꞌilu. ");
INSERT INTO ata_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kedolulaome iloꞌa ta menexu tatalu ne, mitaloxolixaꞌa aneꞌi taꞌuve ne mole miꞌunalai ne Sodomu ilee Xomola. Miꞌunalai xe miuatu sou milai, la mitavule mimii no nano ne mukalusi, mo mitavule laꞌilali kalumo. ");
INSERT INTO ata_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loto ne, anu muxolu ne Sodomu, mole aneꞌi miꞌuna la minoꞌu kalumo mo mixumixu. ");
INSERT INTO ata_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ia itema vile noxiꞌa ane ne, aneꞌi miꞌoto la anu muꞌume mulai noxou Avalamu anu itemasie Evalaio la muaꞌalou sou eiae Loto, xo anu Avalamu ne mulai muxolu ꞌalai no ovu tavuna noxou Mamule itemasie Amolu. Mamule iloꞌa ta vimovimou eiae Esikolu ilou Anelu. Aneꞌi tatalu ne Avalamu ta menexu. ");
INSERT INTO ata_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ioxe, anu Avalamu mulomu lexe vimou ꞌolu, Loto ane ta mitema minoꞌu ne, la sou muꞌavaliꞌa ta mitema sou ꞌotoꞌoto noxou itiitisiꞌa muxali loxo itemaxu mavulovexa vile mo itemaxu taꞌuve mo mavulovexa vile mo taꞌuve mo muxatele tatalu (318) sou milelemulineꞌi Kedolulaome iloꞌa ta menexu tatalu mole milai mixali ne Den. ");
INSERT INTO ata_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Milai xe milai mixali ne Den, la Avalamu mukalipalaꞌaneꞌi ta mitema noxou laꞌoluxaꞌa tamei. Xe no ꞌolovoxo la mialivulaneꞌi la mitaloxolixaꞌa moso mukalusi. Milelemulineꞌi xoo mole milai mixali ne Ova ne Temasukasi. Tuala ane ne muxolu no paxa sevile ne Temasukasi. ");
INSERT INTO ata_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Miꞌume mimii e aneꞌi minoꞌu mo milivunoxu Loto iloꞌa ta sema mo ta mitema noxou mo miꞌamiꞌa kalumo. ");
INSERT INTO ata_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Milivu mixali, io iliꞌi no anu ꞌotoꞌoto ane ne, la tatananu tuala ne Sodomu mulai sou mualaxu Avalamu no vanunu vile ilemolu lexe Save. Ilemolu vanunu ane ne kalumo lexe “Vanunu Noxou Tatananu Tuala”. ");
INSERT INTO ata_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Xe Melikisateki tatananu tuala ne Salemu, anu itema sou uꞌelaxaꞌa ta sipsip ulai noxou Lataua Manina Teitexi. Munoꞌu laꞌilali xe uaini sou mulai noxou Avalamu. ");
INSERT INTO ata_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mulai muxali noxou, la mualusou, muvikala aloxo ꞌo, “Lataua Manina Teitexi anu ane mukoinu mimii latala loxo loxotolo ilou lia ualusine! ");
INSERT INTO ata_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Anu molu mulosine xavi sou netaloxolixaꞌa ta mitema sou ꞌotoꞌoto ane ngongiꞌa ngeꞌoto ne. Laixe nenge taꞌitinu Lataua ualasou.” Xe Avalamu muavuti la mutaꞌolunu mimii ane anu mulai muꞌumenu mulivunoxu ne, laꞌoluxu mavulovexa vile. Xe muavuti la mulosou Melikisateki laꞌoluxu vile. ");
INSERT INTO ata_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Xe tatananu tuala ne Sodomu muavuti la muvikalanu Avalamu aloxo ꞌo, “Mimii piena e neꞌumenu mulivu ne, natetelisou mo uai noxine ne, ia ta mitema noxilo ne, nalivulixaꞌa ineꞌe noxilo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Xe Avalamu muavuti la mukolinu aloxo ꞌo, “Eni atulu no iou IAUE Lataua Manina Teitexi, Anu molu mukoinu loxotolo mo lia, mo eni avikala manina aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Eni umomomo sou atetelisou mo anoꞌu mii vile uai noxine uasi, loxo ꞌo io nini navikala lexe ninisi ane, nini neitixeni mimii la ane eni exali itema sou lavuluti ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mo eni umomomo sou eni anoꞌu mii vile uasi. Mimii ane ta mitema noxilo minoꞌu, ane eni opoleli musexelaxusi. Ia ta vivilo tatalu e Anelu ilou Esikolu mo Mamulesi ane lexe nini nalosiꞌa naꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Xe iliꞌi la sou IAUE muxali noxou Avalamu no anu loxo aipiepiena, la mulomusou IAUE muvikalanu aloxo ꞌo, “Avalamu, naꞌume mamu, xo eni xaliausine sou asaxilaꞌine no anu tuꞌutuꞌumaxu ane lexe uxali noxine, mo nini naxali itema tila manina.” ");
INSERT INTO ata_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ioxe, Avalamu muavuti la mukolinu aloxo ꞌo, “IAUE Lataua noxilo, mii maꞌia ane nini nalosilo loxo alu e nelosilo no anu. Eni ulai la asoli io, apalaa ꞌalixe vile sou eni ualasilo ulai iliꞌi la ilemolemo ua. Eliaselu sie Temasukasi ane anu sou ulai xe eni asoli, la anu ualasou utelo no anu mimii noxilo. ");
INSERT INTO ata_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nini naxalixaꞌa ta ꞌaliꞌalixeni mo ta xasixasilo uasi, mo ꞌalixe vile eni apalaanu sou lexe eni asoli la anu ualasou utelo no anu mimii noxilo uasi.” ");
INSERT INTO ata_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","IAUE mukolinu Avalamu la muvikalanu aloxo ꞌo, “Eliaselu e uxoxoolu noxine sou napalupalusou ne, ulai iliꞌi la anu ualasou utelo no anu mimii noxine uasi, ꞌiline vile manina ualasou utelo no anu.” ");
INSERT INTO ata_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Xe iliꞌi la sou IAUE munoꞌu anu Avalamu ne sou mulailixu no ale sou muvikalanu aloxo ꞌo, “Ieni utelai no loxotolo mo natovo lexe naitisiꞌa ta oto ꞌo ukalusi, xo ulai iliꞌi la ta ꞌiline mo ta xasixasine mo ta ꞌilusulusuneni ixali tavuꞌalo aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Avalamu mumuxamuxaxu tanu noxou IAUE, la IAUE mumoxoꞌu lexe anu itema mulapu. ");
INSERT INTO ata_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","La sou IAUE muvikalanu aloxo ꞌo, “Eni IAUE ane elaalixene ne Ulu no xalee lia ne Vaviloni mo elosine lia ano ꞌo lexe naꞌa nini.” ");
INSERT INTO ata_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Xe Avalamu muavuti la mutaliꞌisou Lataua aloxo ꞌo, “Lataua IAUE noxilo, eni alavu a loxovaa lexe lia ano ꞌo ulai la eni naꞌa xeni?” ");
INSERT INTO ata_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Anu mukolinu aloxo ꞌo, “Nanoꞌe kau sema vile mo mee sema vile mo sipsip mulu vile tauu iexaꞌa tatalusi. Nanoꞌa ineꞌe noxilo. Nanoꞌu utu vile mo kuau vile kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Avalamu muavuti la munoꞌa ta mimii ane ne milai noxou IAUE, ka anu molu muxotoneꞌi tamomoneꞌi tamei ka sou mutaꞌoluneꞌi tangatanga tametamei, ia ta ngiala ne uvalaneꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ta nenusuluvi seꞌi mivava muluꞌe sou lexe itokixaꞌa mo ilai iꞌou la ua. Avalamu mukusaiꞌa milai. ");
INSERT INTO ata_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Xe no ꞌoloꞌolovoxo mine aso ululuꞌelai ꞌo la, Avalamu iou muvuvuvu la muai. Anu muai ne la muaipiepiena lexe isivoxo toxoxaꞌa mutaasou mukalu. La muꞌoloꞌolo la muꞌume. ");
INSERT INTO ata_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Xe IAUE muavuti la muvikalanu aloxo ꞌo, “Ulai aso vile la ta ꞌiluꞌilusuneni ne ixolu no tuala vile mo. Mo ilai ixolu no tuala vile vaꞌaxu mo. Mo ta mitema imuxaxaꞌa sou ipalupalusiꞌasi no tuala ane ne. Xoluxoluxaꞌa kalumo ne masuasi no nano no anu tauu ie loxo itemaxu mavulovexa tamei (400). ");
INSERT INTO ata_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ia ta mitema ane iꞌoxo ꞌilixo aloxo ne ulai noxiꞌa ne, eni alosiꞌa navunavu, ia ta ꞌilusulusuneni ne no voxo ane aneꞌi iꞌumesou tuala ane ne, la itavuleiꞌa lavuluti piena misevile sou ilailixu. ");
INSERT INTO ata_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Xe nini ne, naxoxoo namauli laixe xoo mole nalai naaululu manina mole namuamuaꞌi la ua. Naxoxoo laixe loxo ne ia, oponeni uavuti sou laꞌiaxeneu mii vile uasi manina xoo mole nasoli la iꞌasixene. ");
INSERT INTO ata_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ta ꞌiluꞌilusuneni ne ilivu ilai palea uasi xo ta mitema ne Amolu ne, eni umomomo sou eni akusaiꞌa ilai palea uasi. Ixoxoo ane ꞌo mo lexe ꞌiliꞌilixo masumasua noxiꞌa ne lexe uꞌokiꞌoki tani, la sou eni alosiꞌa navunavu, xe la sou akusaiꞌa ilai. Ia aneꞌi ta ꞌiluꞌilusuneni ne ilivu ineꞌe lexe tauu ie itemaxu mavulovexa tamei ukalu.” ");
INSERT INTO ata_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","IAUE muvikala aloxo ne mukalu, la aso muluꞌelai mole tani isivoxo. Lasopeni vile sou navu xe telu vile ne mukaa muꞌokinu, ilou mipaa vitanisi ka ilou miiave vaxa no taiinu laꞌolaꞌoluxu mimii ane anu Avalamu musuꞌa laꞌoluxu ne. ");
INSERT INTO ata_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","No voxo ane ne, la IAUE ilou Avalamu misakiinu vaikala sou opo vilesisi la IAUE muvikalanu Avalamu aloxo ꞌo, “Eni aitixaꞌa ta ꞌiliꞌiline iloꞌa ta xasixasine mo ta ꞌilusulusuneni lialia e pilixasou musokou no lexa ne Aixiputo la mulai mutalo ne lexa tila ne Iupileitisi. ");
INSERT INTO ata_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Lialiaxaꞌa ta Kenan iloꞌa ta Kenisi mo ta Kademon ");
INSERT INTO ata_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","mo ta Keti iloꞌa ta Peresi mo ta Lepaimu ");
INSERT INTO ata_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","iloꞌa ta Amolu mo ta Kanani iloꞌa ta Xilixasi mo ta Ievusi ne, eni alosiꞌa ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Avalamu semau e Salai ne ipapaala uasi. Aneꞌi ilou muluesi xe semasie Aixiputo vile ualasie lexe Axali ane aneꞌi iloꞌa mixoxoolu ne. Salai minoꞌe Axali ne sou ixoo noxie sou ipalupalusie sou iꞌoxoꞌoxo mimii. ");
INSERT INTO ata_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","No voxo vile, la Salai miavuti la mivikalanu mulue Avalamu aloxo ꞌo, “Tila noxilo, IAUE molu mumasikalaleli mole umomomo sou eni avoꞌo uasi. Nini nalai mo ngongie Axali ngaai. Male nini naꞌoxo aloxo ne la sou ane ivoꞌonuxeni keakea vile.” Avalamu mulomu aloxo ne, la xavutalau mumasaxau xavutalaie semau ne. ");
INSERT INTO ata_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","La sou ane minoꞌe Axali sou milailixe noxou Avalamu. Avalamu muxolu ne Kanani tauu ie mavulovexa mukalu, ");
INSERT INTO ata_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","la Axali milai mixolu noxou Avalamu la sou anu mulai noxie la sou ane opoone. Ioxe, iliꞌi xe ane Axali milavu lexe ane a opoone, la ane miꞌosa misevile la milevetesie tila noxie. ");
INSERT INTO ata_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","La sou Salai miavuti la mivikalanu mulue Avalamu aloxo ꞌo, “Nini namoosou e neꞌoxo la sou Axali milevetesilo ane. Eni elavu lexe eni melo eꞌitalone milai noxine, ia no voxo ane, ane milavu lexe ane a opoone, la ane mixamaile misevile la milevetesilo. Ia eni avikalaneni, anu mii noxou IAUE. Anu molu uvikalanenge lamana lexe ꞌenaꞌei noxinge nengei ane anu mususu xe ꞌenaꞌei uasi.” ");
INSERT INTO ata_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Avalamu muavuti la mukolinu vaikalaie aloxo ꞌo, “Anu laixesi, Axali ne ane mixoxoo ane noxinge nengei ꞌo sou nini napalupalusie. Ane mixoo no anu saxisaxilaꞌu noxingesi. Namasaxa lexe naꞌoxone a loxovaa, la anu mii noxinesi.” No voxo ane ne, la xoluxolu noxie Axali ne laixe la ua. Salai imolomolosilane sou ilalavixe utotomusi la sou ane miꞌume. ");
INSERT INTO ata_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Xe iliꞌi la sou angelo noxou IAUE mulai muxalisie Axali ne no lexa luuxu vile no lexa uxaxali utetelo no anu no xalee lia vitanisi no voteꞌi ulai loxo ne Suru la mutaliꞌisie aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Axali, sema noxie Salai, mene neꞌei? Ia, nalalai loxo neꞌei?” Ane mikolinu angelo ne aloxo ꞌo, “Eni eꞌumele Salai sema tatila noxilo, la sou ane eneꞌe ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Xe angelo muavuti la muvikalane aloxo ꞌo, “Nalivu ulai noxie mo ipalupalusinexu mimii sou naꞌoxoꞌoxo loxo nexoo noxie tei la neꞌoxoꞌoxonu.” ");
INSERT INTO ata_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ka muvikalane aloxo ꞌo la, “Ulai iliꞌi la eni axalixaꞌa ta xasixasine iloꞌa ta ꞌiluꞌilusuneni ixali tapiena, la evile umomomo sou uitisiꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Keakea e uxoxoo no nano no oponeni ne, nini navoꞌonu la mulu. La namoxoꞌu ualasou lexe Isimaeli, xo IAUE mulomusou tamaxene sou tuꞌumaxu ane muxali noxine ne. ");
INSERT INTO ata_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ia ꞌiline ne uxali itema vile sou laꞌia loxo donki vova. Anu uluaiꞌa ta mitema ukalusi mo aneꞌi ta mitema ukalusi ne, uluaiꞌa ane anu. Mo ta vimovimou kalumo ne, iloꞌa ixoo ipita uasi.” ");
INSERT INTO ata_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Xe Axali miavuti la mivikala aloxo ꞌo, “Vaimomo ꞌo, eni emaisou Lataua anu ulavusou umaisilo.” La sou ane miavuti la mimoxoꞌu IAUE lexe, “Lataua anu Lataua sou umamaisilo.” ");
INSERT INTO ata_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","La sou ane ta mitema vaimomo ꞌo ilemolu lexa iou miꞌasou no nixi ne Kadesi xe ne Bereti lexe, “Lexa noxou anu ane mauli muxolu noxou mo umamaisilo.” ");
INSERT INTO ata_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Xe iliꞌi la sou Axali mivoꞌonu ꞌilie mulu la sou momu mumoxoꞌu ualasou lexe Isimaeli, aloxo angelo mulemolu noxie. ");
INSERT INTO ata_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","No tauu ie ane ne, la Avalamu tauu iexu muxali loxo itemaxu tamiꞌa mo muxatele vile (86). ");
INSERT INTO ata_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Xe no tauu ie ane Avalamu tauu iexu mulai muxali loxo mavulovexa muxatele tamiꞌa mo muxatele tamiꞌa (99), la IAUE muxali mupalaꞌa noxou la muvikalanu aloxo ꞌo, “Eni Lataua ane xaviinu misevile. Nini nalomuxo mo namulinu masaxa noxilo mo naꞌoxonu ꞌiliꞌilixo ane lailaixesi no ieli utotomu. ");
INSERT INTO ata_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nenge nengei tasakiinu vaikala sou opo vilesisi. La eni axalixaꞌa ta ꞌiline mo ta xasixasine mo ta ꞌiluꞌilusuneni ixali tavuꞌalo aso vile.” ");
INSERT INTO ata_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Xe Avalamu muavuti la mutangatulu muluꞌelai iou mulai no lia, la sou Lataua muvikalanu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nenge nengei tasakiinu vaikala sou opo vilesisi ꞌo, la sou avikalaneni lexe ulai aso vile, la nini mutuꞌuovuxaꞌa ta mitema tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Maasi la ualasine lexe Avalamu la ua, amoxoine lexe Avalaamu, xo eni aalusine sou nini naxali mutuꞌu ovuxaꞌa ta mitema no xalexalee tuatuala ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Eni axalixaꞌa ta xasixasine mo ta ꞌiluꞌilusuneni tapiena misevile, mo sou seꞌi noxiꞌa ixali loxo ta tatananu tuala. ");
INSERT INTO ata_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Eni apalaꞌalixu vaikala sou opo vilesisi ne aloxo ꞌo. Ta ꞌiluꞌilusuneni ne ixali tavuꞌalo misevile la ixalixaꞌa ta mitema iouiou sou xalexalee tuatuala ukalusi. Vaikala sou opo vilesisi eni esakiinu noxine ne, uxolu mo umauli no nixi noxinge nengei, mo no nixi noxiꞌa ta xasixasine iloꞌa ta ꞌiluꞌilusuneni ane ipaa iliꞌi mo kaluxu uasi. Eni Lataua noxine mo noxiꞌa ta ꞌiluꞌilusuneni kalumo. ");
INSERT INTO ata_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Lia ane nini neneꞌe nexolu no anu ꞌo ngaꞌa ngingi ngongiꞌa uasi, xo ngingi ngeneꞌe ngexolu no anu ꞌo loxo ta aasilasi, ia eni aitingenge ngongiꞌa ta ꞌiluꞌilusuneni lialia ne Kanani ne ukalusi. Ta xasixasine iloꞌa ta ꞌiluꞌilisuneni liaxaꞌa manina ane, mo eni axali Lataua noxinge ngongiꞌa manina.” ");
INSERT INTO ata_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Xe Lataua muavuti la muvikalanu Avalaamu aloxo ꞌo la, “Vaikala sou opo vilesisi ane nenge nengei tasakiinu ne, nini mo ta ꞌiliꞌiline iloꞌa ta xasixasine mo ta ꞌiluꞌilusuneni ane ipaa aso vile iliꞌi imulinusi. ");
INSERT INTO ata_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Vaikala sou opo vilesisi nengei tasakiinu aloxo ꞌo. Ta mulu noxinge ukalusi ne xooxoo ungasiꞌa ukalusi. Vaikala sou opo vilesisi ane nenge nengei tesakiinu ꞌo ne ngaꞌoxonu xe ngamulinu. ");
INSERT INTO ata_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Usoko ane vaimomo ꞌo mo ulai iliꞌi ngatetelisou ꞌilixo sou xooxoo ungasiꞌa ta mulu, xo anu sosovo sou vaikala sou opo vilesisi ane nengei tesakiinu. Xooxoo ungaasiꞌa ta keakea ta mulu ane ta neniꞌa mivoꞌoneꞌi mo voxosiꞌa uao taꞌuvesi mo muxatele tatalu. Ta mitema ane ngenoꞌa sou mineꞌe mixolu noxinge sou ngapalupalusiꞌa ne ta ꞌiliꞌiliꞌa iloꞌa aneꞌi ane ngelotoneꞌi no xalexalee tuala seꞌi vaꞌaxu ne ta ꞌiliꞌiliꞌa kalumo. ");
INSERT INTO ata_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ta mulusinge ne, xooxoo ungasiꞌa ukalusi. Mo sou sosovo ane ne upalaꞌalixu vaikala sou opo vilesisi nenge tesakiinu. Vaikala sou opo vilesisi ane nenge tesakiinu ne uxoo aloxo ne mo umomomo sou ukalu uasi. ");
INSERT INTO ata_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ia lexe vile no nixi noxinge ne xooxoo ungasou uasi, la anu ane ne anu noxilo uasi, xo anu umulinu mo utetelisou vaikala sou opo vilesisi ane eni esakiinu uasi.” ");
INSERT INTO ata_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Xe iliꞌi la, la Lataua muvikalanu Avalaamu aloxo ꞌo, “Maasi la nini namoxoe semameni lexe Salai la ua, vaimomo ꞌo mo ulai avile iliꞌi ne namoxoe lexe Sala. ");
INSERT INTO ata_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Eni aalusie la sou ane ivoꞌonumeni keakea mulu vile xe ane ixali ta mitema no xalexalee tuatuala neniꞌa. Ta xasixasie iloꞌa ta ꞌiluꞌilusune ne ulai iliꞌi la seꞌi noxiꞌa ixali ta tatananu tuala no xalexalee tuatuala aso vile.” ");
INSERT INTO ata_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Xe Avalaamu mulomu noxou Lataua aloxo ne mukalu, la muxolaꞌu tavaꞌu tamei sou mutulu no tavaꞌu voꞌuvoꞌuxu ka sou mutangatulu muluꞌelai no lia sou motoxonu ia mukeke xo tanu muvikala lexe, itema vile tauu iexu uxali loxo itemaxu taꞌuve (100), ia upalaa loxovaa ꞌo? Xe Sala ne, ane tauu iexe muxali loxo mavulovexa muxatele tamiꞌa (90), ia ane ipalaa loxovaa? ");
INSERT INTO ata_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Xe Avalaamu muavuti la muvikalanu Lataua aloxo ꞌo, “Eni emasaxa lexe Isimaeli ne uxolu no anu saxisaxilaꞌu noxine.” ");
INSERT INTO ata_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Xe Lataua muavuti la mukolinu vaikalau aloxo ꞌo, “Uasi. Semameni Sala ne, ivoꞌonumeni keakea mulu la sou nini namoxoꞌu ualasou lexe Aisaki. Eni apalaꞌalixu vaikala sou opo vilesisi eni esakiinu noxine ꞌo uxolu noxou xe noxiꞌa ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu, mo kaluxu uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Eni elomusou xavutala noxine sou eiae Isimaeli ne. La eni aalusou mo sou anu upalaaneꞌi ta ꞌolu tavuꞌalo la sou aneꞌi ixalixaꞌa ta xasoxasou iloꞌa ta ꞌiluꞌilusunu tavuꞌalo aso vile. Anu uxali ta mitema ta tatila sou isaxilaꞌa ta mitema noxiꞌa vilevilesi, mavulovexa vile mo tamei mamiꞌa. Anu upalaaneꞌi la sou ixalixaꞌa ta mitema tavuꞌalo ane evile umomomo sou utaloxolixaꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ia, lexe Sala ivoꞌonu Aisaki no anu tauu ie alavua, la nexi noxousi tasakiinu vaikala sou opo vilesisi ne.” ");
INSERT INTO ata_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lataua muvikala aloxo ne noxou Avalaamu mukalu, la mulai. ");
INSERT INTO ata_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Xe no voxo ane ne, Avalaamu mulomuxu vaivaikala noxou Lataua la munoꞌu ꞌolu Isimaeli sou xooxoo mungaasou iloꞌa ta mitemau mo ta mitemau sou upalupalusiꞌa ta mulu ane anu mulotoneꞌi iloꞌa ta mitemau ta ꞌiliꞌiliꞌa ta mulu kalumo. ");
INSERT INTO ata_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Xe no voxo ane Avalaamu tauu iexu mulai muxali loxo mavulovexa muxatele tamiꞌa mo muxatele tamiꞌa (99), la sou xooxoo mungaasiꞌa ilou ꞌolu Isimaeli. ");
INSERT INTO ata_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","No voxo ane ne la Isimaeli tauu iexu muxali loxo mavulovexa vile mo tatalu. ");
INSERT INTO ata_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Mo ta mitemau no taasou kalumo. Aneꞌi ane mixoxoo noxou tatei mo aneꞌi ane mulotoneꞌi ne, xooxoo mungaasiꞌa kalumo no voxo vilesisi ane. ");
INSERT INTO ata_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Xe iliꞌi la, no voxo vile la IAUE muxali mupalaꞌa noxou Avalaamu no ovu tavuna ilemolu lexe Mamule. No voxo ane ne la, aso ialuxu misevile la sou Avalaamu muatu muxolu no aitenga sou taasou. ");
INSERT INTO ata_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Xe mumalei mutelo loxo ꞌo la mumaisiꞌa ta mitema tatalu a itutulu, xe muavuti la muiave mulai noxiꞌa sou mualaxaꞌa. Muxali noxiꞌa la mutangatulu muluꞌelai sou mutoxoneꞌi ");
INSERT INTO ata_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","la sou muvikalaneꞌi aloxo ꞌo, “Ta tatila, lexe ngingi opongengi usexelaxo la mamu ngingi ngapolopepee tualasilo. ");
INSERT INTO ata_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Eni apalusou itema vile sou utau lexa mo uneꞌe mo ngaꞌuinu tavainge no anu mo nganeꞌe ngamaꞌila no maimaixu ovu ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Eni anoꞌungenge laꞌilali sevile uneꞌe sou ulosinge xavi sou ngingi ngasolo muamuaꞌi noxinge. Laixe musuku xo ngingi ngeneꞌe noxilo.” Aneꞌi iloꞌa mikolinu vaikalau aloxo ꞌo, “Laixe musuku noxine, nexi oponexi muꞌosasou ꞌilixo laixe ane ne.” ");
INSERT INTO ata_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Muvikalaneꞌi iloꞌa aloxo ne mukalu la muiave mulai no taasou la muvikalane Sala aloxo ꞌo, “Napalea nanoꞌu palaua tivasou sene mo napuinu veleti seꞌi mo napalea naxaumusou ane alalae ꞌosi.” ");
INSERT INTO ata_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Xe muavuti la muiave mulai no taasiꞌa ta kau sou munoꞌu kau ꞌolu vile lailaixe ka munoꞌu mulai noxou itema sou xaixai noxou sou mupalepeinu ka muxutulalau. ");
INSERT INTO ata_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Muxutulalau mukalu la muꞌeleꞌelexu sou muxutuxu. Muxutuxu mukalu la anu Avalaamu munoꞌu ilou susu lovoxu mo susu sou molu mulai mulosiꞌa no ovu tavaꞌu e ixoxoo no anu sou miꞌou. Aneꞌi miꞌaniꞌani, ia Avalaamu ne mututulu sou muxoxoomaieꞌi no ovu tavaꞌu ꞌalai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Miꞌani mukalu la mitaliꞌisou aloxo ꞌo, “Semameni Sala ane ꞌava?” Anu muvikalaneꞌi lexe, “Ane a ixoxoo no tani.” ");
INSERT INTO ata_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Xe vile noxiꞌa muavuti la muvikala aloxo ꞌo, “Usoko vaimomo mo ulai utalo no anu soꞌio ano ꞌo no tauu ie alavua xe eni alivu aluꞌe manina la ane ivoꞌo ꞌilie vile mulu manina.” Sala ne a itutulu iliꞌi no tumalou no aitengaxu taasiꞌa mo ane a ilolomu kalumo. ");
INSERT INTO ata_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Anu Avalaamu ilee semau ne aneꞌi ta aululu, mole semau ne ikukulukemele la ua. ");
INSERT INTO ata_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Mole ane milomu aloxo ne la ane mikeke la mivikala aloxo ꞌo, “Vaimomo ꞌo ne, eni a aululu mo xavileli la ua, taleli uꞌosa mo umasaxau muluxeni loxovaa la? Xo anu kalumo ne anu aululu.” ");
INSERT INTO ata_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Xe iliꞌi la IAUE mutaliꞌisou Avalaamu, “Tavaꞌu loxovaa la Sala mikeke ka mivikala lexe umomomo sou ane ivoꞌonu keakea vile mine ane a aululu ꞌo? ");
INSERT INTO ata_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mii maꞌia ane pekiaꞌu noxou IAUE? Anu aloxo eni elemolu ne, soꞌio ano ꞌo tauu ie alavua la eni alivu uneꞌe, la Sala ivoꞌonu ꞌilie vile mulu.” ");
INSERT INTO ata_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tavaꞌu xo Sala miꞌume, la ane misingi lexe ane ikeke uasi. Ia anu muvikala lexe, “Manina, nini nekekeiou vaikala ane ne.” ");
INSERT INTO ata_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Xe iliꞌi la aneꞌi ta mitema tatalu ne milai no xalee vile sou ilai itulu teitexi sou ieꞌi uluꞌelai sou imaisou tuala ne Sodomu. Avalaamu mumulineꞌi sou musaxaneꞌi milai. ");
INSERT INTO ata_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Xe IAUE muavuti la tanu muvikalanu aloxo ꞌo, “Mamu eni atalumeu mii e eni emasaxa lexe eni aꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ta xasoxasou mo ta ꞌiluꞌilusunu ixali tavuꞌalo mo aneꞌi ta mitema sou xavi sou tuala. Voteꞌi ane noxou ꞌosi, la sou eni aalusiꞌa ta mitema iouiou no xalexalee tuatuala ꞌo ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Eni melosi esosovosou mo sou anu uulaxuneꞌi ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu mo sou ta mitema imuli masaxa noxou Lataua mo imuli ꞌiliꞌilixo ane lailaixe mo ane manina. Lexe aneꞌi imulinu aloxo eni emasaxau ne, la eni mimii e epalaꞌalixu noxou lexe eni aꞌoxonu ulai noxou ne, eni aꞌoxo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ioxe, xe iliꞌi la, la IAUE muvikalanu Avalaamu aloxo ꞌo, “Aꞌalo piena musuku eni elomusou lexe tuala tamei e Sodomu ilee Xomola ne mixali masua. Ta mitema sou tuala tamei ne, ꞌiliꞌilixo masumasua noxiꞌa ne muꞌokiꞌoki tani misevile. ");
INSERT INTO ata_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Eni alai mo ataxuu aꞌalo sou xoluxolu noxiꞌa ne mo alomu laixe lexe anu vaivaikala ane ne manina.” ");
INSERT INTO ata_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","IAUE muvikala aloxo ꞌo ne mulai noxou Avalaamu mukalu, la sou ta mitema tamei e iloꞌa mikei ne, ilou milutu sou milai loxo ne Sodomu, ia IAUE nesi, anu muxolu noxou Avalaamu. ");
INSERT INTO ata_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Xe Avalaamu muavuti la musuku mulai ꞌalai noxou IAUE la mutaliꞌisou, “Loxovaa, maasi la nini nakalusiꞌa ta mitema ane milapu iloꞌa aneꞌi ane ta masua ukalusi? ");
INSERT INTO ata_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Loxovaa, lexe ta mitema mavulovexa taꞌuve ane milapu ixoo no nano no tuala tila ane ne, nini nakalusiꞌa kalumo mo iloꞌa tualasiꞌa iulua ukalusi? Tanenixu tuala tila ne mo, uxolusi mo sou ta mitema mavulovexa taꞌuve ne iulua uasi? ");
INSERT INTO ata_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Manina, eni elavu lexe nini umomomo sou nakalusou maulixaꞌa aneꞌi ane milapu iloꞌa aneꞌi ane ta masumasua uasi. Anu ane ne, umomomo no anu xavutala uasi. Umomomo sou nini naꞌoxo loxo ne uasi. Anu ane ne masua. Laixe nini namulinu xavutala ane mulapusi, ka sou nini naꞌoxo aloxo nini nemasaxa lexe naꞌoxonu noxiꞌa ta mitema ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Xe IAUE muavuti la mukolinu Avalaamu vaikalau aloxo ꞌo, “Lexe eni axalisiꞌa ta mitema mavulovexa taꞌuve ane milapu no nano ne Sodomu ne, la eni akalusou tuala uasi, xo aneꞌi ta mitema milapu ane ne, ixoo no nano no tuala ne, ia iulua uasi.” ");
INSERT INTO ata_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ioxe, Avalaamu muavuti la muvikala aloxo ꞌo la, “IAUE, mamu nini laꞌiaxeneilo sou vaikala ilou taliꞌi piepiena noxilo ꞌo. Xo eni itema vile vitanisi, eni amomomo sou avikalanenixu mii vile sou nini naꞌoxonu uasi. ");
INSERT INTO ata_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ia lexe ta mitema mavulovexa taꞌuve ane milapu uasi ixoo no tuala ne uasi, ia mavulovexa tamiꞌa mo taꞌuvesi a ixoo, la loxovaa nini nakalusou tuala ane nesi?” Xe IAUE muavuti la mukolinu taliꞌiiou Avalaamu aloxo ꞌo, “Lexe eni amaisiꞌa ta mitema mavulovexa tamiꞌa mo taꞌuve ane milapu, la eni akalusou tuala ne uasi.” ");
INSERT INTO ata_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Xe Avalaamu muavuti la mutaliꞌi aloxo ꞌo la, “Lexe nini namaisiꞌa ta mitema mavulovexa tamiꞌa ane milapu ixolu, la loxovaa noxiꞌa aneꞌi ane ne?” Anu IAUE mukolinu aloxo ꞌo, “Lexe eni amaisiꞌa aloxo nini nelemolu ne, la eni amomomo sou akalusou tuala ne uasi.” ");
INSERT INTO ata_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Xe Avalaamu muavuti la muvikalanu IAUE aloxo ꞌo la, “Mamu laꞌiaxenenilo, xo eni amasaxa lexe avivikala ulai noxine la. Ioxe, lexe itiitisiꞌa uluꞌe loxo mavulovexa tatalusi la ane ne loxovaa?” La Lataua mukolinu lexe, “A lexe eni amaisiꞌa xe itiitisiꞌa muxali aloxo ne, la eni amomomo sou akalusiꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Xe Avalaamu muavuti la muvikala aloxo ꞌo la, “IAUE, mamu laꞌiaxeneilo sou talitaliꞌi ilou vaivaikala piepiena te aꞌoxoꞌoxonu uneꞌe noxine ꞌo, xo eni amasaxa lexe ataliꞌisine la. Ia lexe itiitisiꞌa uluꞌe loxo itemaxu vile, la ane ne loxovaa noxine?” Anu muavuti la mukolinu taliꞌi noxou Avalaamu aloxo ꞌo, “A lexe itiitisiꞌa loxo itemaxu vile, la ane ne eni amomomo sou akalusou tuala tile ne uasi.” ");
INSERT INTO ata_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Xe Avalaamu muavuti la muvikala aloxo ꞌo la, “IAUE, mamu laꞌiaxene. Eni amasaxa lexe ataliꞌi kaluxusou la. Lexe itiitisiꞌa uluꞌelai loxo mavulovexa vile, la loxovaa no anu ane ne?” Anu mukolinu aloxo ꞌo, “Lexe eni amaisou lexe ta mitema mavulovexasi milapu a ixolu, la eni amomomo sou akalusou tuala tila ne uasi.” ");
INSERT INTO ata_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ilou mivivikala aloxo ne mukalu la, IAUE mulai xe Avalaamu mulivu mulai no taasou. ");
INSERT INTO ata_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","No voxo ane ta angelo tamei e iloꞌa IAUE milai mixali noxou Avalaamu mineꞌe mixali ne Sodomu, la anu ꞌoloꞌolovoxo. Loto mulai mo a uxoxoo no aitengaxu vimelusou tuala tila ne Sodomu, mole anu mumaisiꞌa mine mitelo, la anu mutulu sou mulai noxiꞌa ilou sou muxali noxiꞌa ilou la muxolaꞌu tavaꞌu sou mutulu no tavaꞌu voꞌuxu sou mutangatulu muluꞌelai no talaxaꞌa ilou sou mutoxoneꞌi, ");
INSERT INTO ata_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","la muvikalaneꞌi ilou aloxo ꞌo, “Ae, ta menexilo, eni sou asuꞌulingengi ngongou. Ngongou nganeꞌe mo nengeꞌa talai no tani noxilo mo ngongou ngaꞌuinu tavainge mo nengeꞌa taai, xe neꞌiela no kakau la sou ngongou ngasolonu laingenge ngongou ulai no xalee ane lexe ngongou ngalai no anu.” Ia, aneꞌi ilou miavuti la mikolinu vaikalau aloxo ꞌo, “Uasi, nexi talai taai no tilovolovo.” ");
INSERT INTO ata_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ia uasi, Loto pekiaꞌu mole, aneꞌi ilou mamalaxaꞌasi la ilou mimulinu sou iloꞌa milai no tani noxou. Xe muavuti la mupalusiꞌa ta mitema sou xaixai noxou sou mixutuxu veleti seꞌi vitanisi, ia iisi sou uasi. Xe mukalu la, miꞌoxoxaꞌa laꞌilali mine lailaixe loxo ꞌo. Milalaxi laꞌilali ne mukalu la miꞌavaliꞌa sou mineꞌe miꞌou. ");
INSERT INTO ata_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ꞌOlovoxo, ia ta aasilaxu Loto ne iloꞌa iaai uao. Ta mulusie Sodomu mineꞌe mixaliliu tani e aneꞌi mixoxoo no anu ne. Ta mulusie Sodomu ne mineꞌe mukalusi, ta maumaulu mo ta tatila mo ta auaululu ne mineꞌe mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mineꞌe mitulutulu no ale, io sou miꞌava muꞌunalai sou mitaliꞌisou Loto aloxo ꞌo, “Ta mitema tamei e mineꞌe miꞌuna no tani noxine no ꞌoloꞌolovoxo sou ngongiꞌa ngaai maasi no ꞌolovoxo ꞌo ꞌava? Nanoꞌa iuatu noxixe!” Aneꞌi mineꞌe mitalitaliꞌisiꞌa loxo ne, xo imasaxa lexe iꞌoxo ꞌilixo masua sou ilai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Xe Loto muavuti la mukisiinu aitenga sou muatulai. Muatulai mukalu la mutatusiꞌa pekiaꞌu. ");
INSERT INTO ata_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Io sou muvikalaneꞌi ta mulusie Sodomu ne aloxo ꞌo, “Ta menexilo, eni alingainge aloxo ꞌo, ngaꞌoxo ꞌilixo ane ne mamu! ");
INSERT INTO ata_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ngalomu, eni ta ꞌalixe ta sema ta vuanga tamei a ixoxoo no nano no tani. Evile ulai noxiꞌa uao. Eni alai anoꞌa iuatu mo ngingi ngakalusou masaxa noxinge noxiꞌa ilou. Ia mamu ngaꞌoxo masua noxiꞌa ta mitema tamei ꞌo, xo eni ta aasilaxeni ane, eni atatusiꞌasi mo ixoxoo a no nano ne.” ");
INSERT INTO ata_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ia, uasi. Aneꞌi laꞌiaxaꞌa la mikaikaitolonu Loto, “Vavalau sou tani, naxexesixe. Nini neneꞌe ꞌo loxo aasila vile, ia nini navivikala loxo itema tila lai ꞌo. Naxexesixe, loxo ꞌo io nexi taꞌoxonu masuaneni tila, ia aneꞌi ne taꞌoxo masuaneꞌi xolosi.” Xe miavuti, la misounu Loto mulai iliꞌi no tumaliꞌa, io sou aneꞌi misuku mulai no aitenga sou lexe imamulonu tatusou aitenga. La ua. ");
INSERT INTO ata_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ta mitema tamei no nano ne mipasipaa la mikisiinu aitenga sou milapunu palea muꞌuna no nano, io sou ilou mitatu. ");
INSERT INTO ata_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Xe ilou miavuti la ilou miꞌoxonu ta mitema latala ne ieꞌi seleveenu mukalasi mole umomomo sou imaisou aitenga la ua. ");
INSERT INTO ata_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Xe ilou miavuti la mivikalanu Loto aloxo ꞌo, “Lexe nini ta minemineni seꞌi loxo ta ꞌiliꞌiline ta mulu mo ta sema, ta leualeuaneni mo ta tulatulaneni seꞌi kalumo a ixoo no nano no tuala ano ꞌo, la nalailixaꞌa ilai no ale. ");
INSERT INTO ata_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Xo nexi asou takalusou tuala ano ꞌo. IAUE mulomusou vaivaikala sou ꞌiliꞌilixo masumasua noxiꞌa mukalu ne, la sou ane anu mupalusixe teneꞌe sou lexe takalusou tualasiꞌa ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Xe Loto muavuti la mulutu mulai noxiꞌa ta mitema tamei e lexe iꞌuluxaꞌa ta ꞌolu ta sema tamei la muvikalaneꞌi aloxo ꞌo, “Ngapalea mo ngaxexesou tuala ano ꞌo mo ngaꞌume ulai vaꞌaxu, xo IAUE anu asou ukalusou tuala ano ꞌo!” Ia aneꞌi milomu aloxo nesi ka mixolu xo aneꞌi miexe lexe anu umomolo vilaꞌi. ");
INSERT INTO ata_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Xe no maxasesela, la ta angelo mitulusou Loto sou mipalusou mo upalea uꞌumesou tuala ne Sodomu. Mivikalanu aloxo ꞌo, “Nanoꞌe semameni mo ta ꞌiline ta sema tamei ne, mo ngapalea mo ngalaa ane alalae ꞌosi mo sou mamu ngaulua!” ");
INSERT INTO ata_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loto mulomu aloxo ne la muꞌume, ia ulutu mo ilee semau iloꞌa ta ꞌolu iꞌume palea uasi. Ia, IAUE tanuxu la sou ta angelo mikasi vaxa no avoꞌa ilee semau mo ta ꞌolu sou mitilaꞌa milaalixaꞌa milai no ale no tuala ne. ");
INSERT INTO ata_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Xe angelo vile muavuti la muvikalaneꞌi aloxo, “Tangengixu maulingenge mo ngaiave avilesi. Ia iengi uxiuxiu mo ngatulu sou ngamaꞌila no vanunu vile uasi. Ngaiave utelai no laxalaxaꞌilusi mo sou mamu ngaulua.” ");
INSERT INTO ata_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Xe Loto muavuti la mukatunu aloxo ꞌo, “Ae, mamu naꞌoxonexi tamulinu aloxo nelemolu ne. ");
INSERT INTO ata_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Xo nini tanenixo mo a nelaalixo ꞌo mo sou eni aulua uasi, ia nalomu, laxalaxaꞌilu e nelemolu lexe nexi tatelai no anu ꞌole ne, no paxa misevile. Nexi tapalea loxovaa la talai taxali ne. Loxo ꞌo io nexi taulua ane no lia ꞌosi, io talai taxali ne ua. ");
INSERT INTO ata_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Namaisou tuala kituꞌa se ꞌole. Anu ꞌalaisi lexe nexi talai mo lexe taxali ane, la nexi taulua uasi.” ");
INSERT INTO ata_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Anu mukolinu vaikalau Loto aloxo ꞌo, “Ioxe, anu laixesi, eni amulinu masaxa noxine. Eni akalusou tuala se ne uasi. ");
INSERT INTO ata_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ia napalea! Naiave! Eni umomomo sou aꞌoxo mii vile palea uasi mo lexe nini nalai mo lexe naxali ane.” Tavaꞌu xo Loto mulemele tuala se ne lexe kituꞌa, la sou aneꞌi milemele lexe Soalu. ");
INSERT INTO ata_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Xe aso muxali mutelo la Loto mulai muxali ne Soalu. ");
INSERT INTO ata_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Xe alaxu vilesisi ꞌo la, IAUE muꞌitalo navu muluꞌe loxo laꞌiua sou muꞌelaxu tuala tamei, eiae Sodomu ilee Xomola. ");
INSERT INTO ata_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Navu muꞌelaxu tuala tamei mo vanunu ne mukalu. Ta mitema mo mimii latala loxo kamakamakala ne muꞌela mukalu avilesi. ");
INSERT INTO ata_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ia Loto semau ne, ivaxasi mo imuli mulue ilaisi ua. Iei muxiu sou lexe imaisou tuala tamei nesi, la mixali loxo lavoꞌo au, mole mitulu ane. ");
INSERT INTO ata_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","No kakau la Avalaamu mulutu mulai no tanixaꞌa ilou IAUE e ilou mitutulu no anu, ");
INSERT INTO ata_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","sou iou muluꞌelai ne Sodomu ilee Xomola. Iou muluꞌelai, la vanunu ne navu iauxuxu mutomu mo a uiaiauxu utetelo. ");
INSERT INTO ata_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","No voxo ane Lataua muꞌelaxu tuala tamei no vanunu e Loto muxoo ne la, xavutalau a muxoo noxou Avalaamu, la sou ane anu tanuxu Loto sou muꞌoxonu voteꞌisou sou mupamaulinu. ");
INSERT INTO ata_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Xe iliꞌi la, Loto umasaxa lexe anu uxolu ne Soalu uasi, xo anu uꞌume. La sou iloꞌa ta ꞌolu ta vuanga tamei ne miꞌume mitelai no laxalaxaꞌilu sou milai mixolu mitalume no taxa vile no tavaꞌu maea. ");
INSERT INTO ata_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","No voxo vile, la ꞌolu laposalaxu mivikalane vimoe aloxo ꞌo, “Maminge nengei soxu a sou aululu, ia ta mulu sou iꞌulunenge sou nengeꞌa taxalixaꞌa ta ꞌilinge uasi, xo ta mulu seꞌi ixoo no xalexalee tuatuala ꞌo uasi. ");
INSERT INTO ata_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ia maasi la nenge nengei taꞌoxo voteꞌi vile aloxo ꞌo. Nengei taienu la sou nengeꞌa taai la sou anu upalaaneꞌi ta ꞌolu noxinge nengei mo sou ta xasoxasou iloꞌa ta ꞌiluꞌilusunu ne ipaa iliꞌi.” ");
INSERT INTO ata_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ilou mivikala aloxo ne, xe no ꞌolovoxo la ilou milosou uaini sou muiexu. La sou ꞌolu laposalaxu milai noxou sou anu mulai noxie, ia mamie ne muie muꞌoki mole ulavu ua. ");
INSERT INTO ata_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Xe loxo neꞌiela no kakau, la ꞌolu laposalaxu ne mivikalane vimoe aloxo ꞌo, “Mei no ꞌolovoxo ne elai noxou mo noxou teai, ia maasi no ꞌolovoxo, la nenge nengei taienu la mo sou nini nalai ngongou ngaai, la sou nenge nengei tapalaa ta ꞌilinge. Maminge nengei molu uxalixaꞌa noxinge nengei.” ");
INSERT INTO ata_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Xe no ꞌolovoxo la aneꞌi ilou miienu mamiꞌa la. Anu muie muꞌoki mole ulavu ua. ꞌOlu mipasipaa la mineꞌe sou ilou miai sou anu mulai noxie. ");
INSERT INTO ata_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Voteꞌi ane aneꞌi ilou minoꞌu opo noxou mamiꞌa aꞌalosou aloxo ne. ");
INSERT INTO ata_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ꞌOlu laposalaxu ne mivoꞌo, la ꞌilie mulu. La mimoxoꞌu ualasou lexe Moabu. Anu Moabu ne, mutuꞌu ovuxaꞌa ta mitema ta Moabu ane mipaa iliꞌi mo mimauli vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Xe vimoe ne mivoꞌo, la ꞌilie mulu kalumo, la mimoxoꞌu ualasou lexe Veni-ami. Anu mutuꞌu ovuxaꞌa ta mitema ne Amoni ane mipaa iliꞌi mo mimauli vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Avalaamu muavuti la muvulasou tuala ne Mamule sou mulai iliꞌi no xalee ne Kanani. Mulai muxolu no nixi ne Kadesi xe ne Suru. Xe iliꞌi, la sou ilou misuku milai mixolu ne Xelalu. ");
INSERT INTO ata_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","La anu muvikalaneꞌi lexe Sala ne anu vimou sema. La sou tatananu tuala ne Xelalu ualasou lexe Avimeleki munoꞌe Sala milai noxou. ");
INSERT INTO ata_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Xe no ꞌolovoxo la anu muaipiepiena lexe Lataua muxali noxou la muvikalanu aloxo ꞌo, “Maasi la nini nasoli, xo nini nenoꞌe sema ane ne, ane mitaulaꞌi.” ");
INSERT INTO ata_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Xe Avimeleki muavuti la muvikalanu Lataua aloxo ꞌo, “IAUE, eni asusu uasi, ia loxovaa ane nakalusixe noxiꞌa ta mitema noxilo ane aneꞌi isusu uasi? ");
INSERT INTO ata_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Anu Avalaamu molu muvikala lexe anu vimou ane, mo ane kalumo mivikala aloxo ne. Eni xavutalaxeni muvikala lexe anu mii vile masua no anu uasi, la sou eni enoꞌe semau, ia eni aꞌoxo ꞌilixo vile masua noxie uasi.” ");
INSERT INTO ata_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Xe Lataua muavuti la mukolinu vaikalau aloxo ꞌo, “Ani, manina. Eni elavusou xavutalameni la sou ane eni eꞌoxo xavutalameni ne mutulu pekiaꞌu mo sou mamu nini nasusu no ieli. Mole ane nini nalai ꞌalai noxie sou naꞌoxonu ꞌilixo vile masua noxie ua. ");
INSERT INTO ata_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ia maasi ꞌo, nanoꞌe sema ne mo nalivulixe ilai noxou mulue. Mulue ne, anu itema sou usova vaikala noxou Lataua. Anu umaisine lexe nini nalivulixe semau ne, la sou anu ulingaine mo sou mamu nini nasoli. Ia lexe nini nalivulixe uasi, la eni avikalaneni lamana aloxo ꞌo, nini mo ta mitema noxine ne, ngongiꞌa ngasoisoli manina.” ");
INSERT INTO ata_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Xe no kakau no mine loxo taai tatutulu ꞌo la anu Avimeleki mupasipaa la muꞌavaliꞌa ta mitema sou xaixai noxou sou muvikalaneꞌixu vaivaikala e Lataua muvikalanuxu no anu aipiepiena noxou no ꞌolovoxo. Aneꞌi milomusou la mimamaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Xe muavuti la muꞌavalou Avalaamu sou mutaliꞌisou, “ꞌIlixo mii maꞌia ane nini neꞌoxo muneꞌe noxixe loxo ꞌo? Susu maꞌia ane eni eꞌoxo mulai noxine la sou ane nini neꞌoxo tuꞌumaxu ano ꞌo muxali noxixe noxiꞌa ta mitema noxilo ꞌo? Evile ulavusou uꞌoxo ꞌilixo vile aloxo ꞌo uneꞌe noxilo uasi. ");
INSERT INTO ata_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ia loxovaa la nini neꞌoxo loxo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Xe Avalaamu muavuti la mukolinu taliꞌi noxou Avimeleki aloxo ꞌo, “Eni eloxomale lexe ta mitema lai ꞌo ne itoxonu Lataua uasisi manina, la loxo io ivelo asoli io sou aneꞌi iꞌumene semaxeni. ");
INSERT INTO ata_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Xe, Sala ne ane vivilo sema manina, mamixe noxie vilesisi. Ia ane nenie vile mo, la sou ane eni eꞌuluxe ne. ");
INSERT INTO ata_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","No voxo ane Lataua mupalusilo sou eꞌumesou mamilo taasou sou elai no tuala vaꞌaxu, la eni eꞌunaa noxie Sala aloxo ꞌo, ‘Lexe nini namasaxailo manina, la nini namaxaꞌu taneni noxilo aloxo ꞌo, lexe nenge nengei ta muamuaꞌi xe ta mitema italiꞌisine, la nini navikalaneꞌi lexe nini vivine ane eni.’” ");
INSERT INTO ata_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Xe Avimeleki muavuti la mulivulixe Sala milai noxou Avalaamu. Xe mukalu la muitiu ta sipsip, ta kau xe ta mitema sou upalupalusiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Xe muavuti la muvikalanu Avalaamu aloxo ꞌo, “Namaisou, lialia ano ꞌo ne noxilo mukalusi, namasaxa lexe nalai naꞌiliisine tuala sou naxolu no anu a neꞌei ne la, mii noxinesi.” ");
INSERT INTO ata_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Xe muavuti la muvikalane Sala, “Vaimomo ꞌo, eni alosou vivine Avalaamu lamoli siliva itemaxu mavulovexa taꞌuve (1,000). Anu umomomo no anu tuꞌumaxu ane muxali noxine. Ta mitema imaisou la ilavu lexe uasi manina, nini nasusu uasi. Aneꞌi latala ne, ilavu aloxo ne lexe nini naꞌoxo ꞌilixo vile masua uasi.” ");
INSERT INTO ata_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ioxe, tavaꞌu xo anu Avimeleki munoꞌe Sala milai noxou, la sou IAUE mumasikalane Avimeleki semau iloꞌa ta sema sou upalupalusiꞌa noxou no tuala ne mole vile noxiꞌa ne umomomo sou upalaa uasi. Ioxe, Avalaamu muavuti, la mulinga sou Avimeleki, la sou Lataua mupamaulinu. Lataua mupamauline semau mo ta sema sou upalupalusiꞌa noxiꞌa ilee semau, sou ipalaa ta ꞌiliꞌa. ");
INSERT INTO ata_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Xe iliꞌi la IAUE muneꞌe sou musuꞌuline Sala aloxo anu mulemolu tei, ");
INSERT INTO ata_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","la sou ane opoone. Xe iliꞌi la sou ane mivoꞌonu ꞌilie mulu no mine momu Avalaamu ne anu itema tila maninanu. Mivoꞌonu ne no voxo ane anu Lataua molu musosovosou lexe nenu ivoꞌonu no anu. ");
INSERT INTO ata_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Xe momu muavuti la mumoxoꞌu ualasou lexe Aisaki, ");
INSERT INTO ata_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","xe voxo sou muxatele tatalu mukalu, la sou xooxoo mungaasou aloxo Lataua mulemolu lamana tei. ");
INSERT INTO ata_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","No voxo ane Avalaamu tauu iexu loxo itemaxu taꞌuve, la Aisaki nenu mivoꞌonu. ");
INSERT INTO ata_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Xe nenu miavuti la mivikala aloxo ꞌo, “Lataua molu mulosilo ꞌosaꞌila mo keke. Ta mitema ane ilomusou aꞌalosou mii ane muxali noxilo ꞌo, la aneꞌi kalumo iꞌosa mo ikeke.” ");
INSERT INTO ata_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Xe miavuti la mivikala aloxo ꞌo, “Evile uvikalanu Avalaamu lexe ulai iliꞌi la semau ne ipalaa ta ꞌilie uasi. Ia Avalaamu anu soxu ane, itema tila mukalu ꞌo, eni evoꞌonu iu keakea mulu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisaki muleme tatila mupasipaa loxo. Xe no voxo ane anu muꞌitalonu susu, la momu muꞌoxonu laꞌilali toxoxaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","No voxo vile, la Isimaeli e Axali semasie Aixiputo, Avalaamu mulai noxie la mivoꞌonu, muvikala masua mulai noxou Aisaki, Sala ꞌilie. ");
INSERT INTO ata_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Xe Sala milomusou la mivikalanu Avalaamu aloxo ꞌo, “Napalusiꞌa Axali ilou ꞌilie ne mo ilai. ꞌIlie ne umomomo sou ualasou utelo no anu mimii seꞌi noxine uasi. Mimii ne eni ꞌalixe Aisaki miumiu ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Avalaamu mulomusou vaikala ane ne, la uai laixe no opo uasi, xo Isimaeli ne anu ꞌolu kalumo. ");
INSERT INTO ata_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ia Lataua muavuti la muvikalanu Avalaamu, “Taneni utamasiꞌa ꞌiline ilee nenu ne mamu. Namuli vaikalaie Salasi, xo ulai iliꞌi, la ta xasixasine mo ta ꞌilusulusuneni ixali tavuꞌalo ane noxou Aisaki ꞌosi, aloxo eni epalaꞌalixu noxine ne. ");
INSERT INTO ata_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Isimaeli kalumo ne eni axalixaꞌa ta ꞌolu mo ta xasoxasou mo ta ꞌilusulusunu tavuꞌalo aso vile, mo sou aneꞌi mata ane ne ixali tavuꞌalo. Anu Isimaeli ne nini ꞌiline kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Miai xe mitulu no kakau ne la, Avalaamu munoꞌu laꞌilali seꞌi sou mulai mulosie Axali ilou lexa mutavulenu no anu mee sosou. Xe mulutu vaxa la muvoꞌonu ꞌolu Isimaeli sou muꞌitalonu vaxa noxie nenu tumalie, io sou mupalusiꞌa ilou milai. Aneꞌi ilou ꞌilie soxu milutu mole milai. Milai mixixaoxao mivaxa mineꞌe ne Beru-seva. Xalee lia ane ne, xalee vitanisi. Ovuovu ilou iaꞌeiaꞌe ne uleme uꞌoki uasi, vilevilesi. Xalee seꞌi la tani taxulunusi. Lavolavoꞌo mo ioꞌiioꞌisi. Lexa kalumo uasi. ");
INSERT INTO ata_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Xe no voxo ane lexaxaꞌa ilou mukalu la, ane milai miꞌitalonu ꞌilie ne no ovu soxo vile maimaixu, ");
INSERT INTO ata_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ia ane milai mixolu no paxa sevile, io ane mixavuxavutala, la mivikala aloxo ꞌo, “Eni elavu lexe umomomo sou eni amaisou ꞌalixeni usoli uasi.” Ane mixolu sou mixavuxavutala aloxo ne la mitatama. ");
INSERT INTO ata_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ꞌIlie kalumo ne mutatama xe Lataua mulomusou mine ane itatama, la sou angelo noxou Lataua teitexi no opoonu loxotolo mutaliꞌisie Axali aloxo ꞌo, “Maꞌia ane nini oponeni uai no anu laixe uasi ne, Axali? Naꞌume mamu, xo Lataua mulomusou molomolo e utatama ne. ");
INSERT INTO ata_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Natulu mo nalai mo navoꞌonu, mo naxolixolinu. Xo ulai iliꞌi la eni axalixaꞌa ta ꞌolu mo ta xasoxasou mo ta ꞌilusulusunu ixali tavuꞌalo sou ixali ta mitema sou mata vile toxoxaꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Xe Lataua musuꞌuline la sou ane iei mukaa lamana laixe, la sou ane mimaisou lexa iou uopuopu utetelo no taxasou. Ane milutu milai sou mitau no anu tavulu e Avalaamu mulosiꞌa ilou sou miienu Isimaeli. ");
INSERT INTO ata_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Lataua muxolu noxou Isimaeli la sou anu muleme toxoxaꞌa. Ilee nenu mixolu no xalee lia vitanisi ne Paran mole anu muxali itema vile sou uvau mii manina no anu pasiko ilou tavi. ");
INSERT INTO ata_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Xe nenu miavuti la milai minoꞌe semasie Aixiputo vile sou mineꞌe muꞌuluxe. ");
INSERT INTO ata_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","No tauu ie ane ne, la Avimeleki ilou Pikolu itema tila sou uulaxuneꞌi ta mitema sou ꞌotoꞌoto noxou anu Avimeleki milai mixali noxou Avalaamu, la mivikalanu aloxo ꞌo, “Lataua a uxoo noxine mo no anu xaixai noxine ukalusi, ");
INSERT INTO ata_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","anu aloxo ne la sou alalae ꞌo, eni amasaxa lexe nini napalaꞌalixu taneni no iou Lataua mo navikala lamana lexe nini ulai la nini namomomo sou nakalavoinexi noxiꞌa ta ꞌaliꞌalixeni mo ta xasixasilo mo ta ꞌiluꞌilusuleli uasi. Xo eni esuꞌulineni mo asusu no anu ꞌilixo vile masua no ieni uasi. Ia lexe nini kalumo napalaꞌalixu taneni lexe nini kalumo nini tanenixo mo nasuꞌulileli no xalee tuala ane nini neneꞌe naxoxoo no anu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Xe Avalaamu muavuti la muvikala aloxo ꞌo, “Eni aꞌoxo aloxo nini nelemolu ne.” ");
INSERT INTO ata_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Xe muavuti la, la musolo vaivaikalau mulai noxou Avimeleki sou mukalapuusou lexa iou anu muꞌasou lexe anu iloꞌa ta minuminu naꞌa, ia ta mitema sou xaixai noxou anu Avimeleki mivukosou lexe aneꞌi lexaxaꞌa iou ane. ");
INSERT INTO ata_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Xe Avimeleki muavuti la muvikalanu aloxo ꞌo, “Eni alavu no anu mii ane nini nalemolu ꞌo uasi. Mo alavusiꞌa ta mitema ane miꞌoxo ꞌilixo ane ne uasi. Nini navikalalelixu lamana uasi, ia uao eni alomusou ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Xe Avalaamu muavuti la muitiu Avimeleki ta sipsip iloꞌa ta kau seꞌi xe mukalu la sou aneꞌi ilou misakiinu xavutalaiꞌa ilou lexe, aneꞌi ilou maasi, la xoluxoluxaꞌa ilou ne vilesisi, ia mii vile loxo ꞌotoꞌoto la uasi. ");
INSERT INTO ata_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Xe Avalaamu mulutu la mulai no taasiꞌa ta sipsip noxou sou mukalipalaꞌaneꞌi ta sipsip ta ꞌiliꞌiliꞌa ane ta sema sou munoꞌa muxatele tamei no nano no laꞌoluxaꞌa sou mulai mutaꞌoluneꞌi vaꞌaxu. ");
INSERT INTO ata_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Avimeleki muavuti la mutaliꞌisou, “Loxovaa ane nini neꞌoxo loxo ne?” ");
INSERT INTO ata_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Xe Avalaamu muavuti la mukolinu aloxo ꞌo, “Maasi ꞌo la oponeni uꞌosasi, mo nanoꞌa ta sipsip ta ꞌiliꞌiliꞌa muxatele tamei ꞌo. Nini nanoꞌa mo sou nini napalaꞌalixu lexe eni amoosou lexa iou eꞌasou ano.” ");
INSERT INTO ata_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","La sou lia xalee se ne aneꞌi mipotongalelee lexe Beru-seva. Xo aneꞌi ilou misakiinu xavuxavutalaiꞌa ane. ");
INSERT INTO ata_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mukalu la sou anu Avimeleki ilou Pikolu milivu milai no tualasiꞌa ne Pilistia. ");
INSERT INTO ata_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Xe iliꞌi la sou Avalaamu mutounu ovu vile ne Beru-seva ne sou mulotu mulai noxou IAUE anu Lataua kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Avalaamu muxolu no xalesiꞌa ta Pilistia ne, maxuvee misevile. ");
INSERT INTO ata_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mixoxoo ne, xe alaxu vile la Lataua mutovonu Avalaamu, la muꞌavalou, “Avalaamu!” La Avalaamu mukolinu, “Maꞌia, eni ꞌa!” ");
INSERT INTO ata_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Nanoꞌu ꞌiline soxu vilesisi e Aisaki, nini tanetanenixu mo namasaxau misevile, mo ngongou ngalai no xalee lia e ilemolu lexe Moria. Ngalai ne la sou eni alosiengixu laxaꞌilu vile lai ne, sou nini navau mo naꞌelaxu Aisaki ukalusi uneꞌe noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ioxe, no kakau no mine uao sivosivo se ꞌo, la Avalaamu mutulu sou muvalavala ovu sou ulai uꞌelaxu ꞌolu Aisaki loxo Lataua muvikalanuxu. Muvotunu ovu e musiasiaꞌu ne, ka muiti mutelo noxou donki, xe mukalu la sou munoꞌa Aisaki iloꞌa ta mitema sou xaixai noxou tamei sou iloꞌa milai ne Moria loxo Lataua mupelaꞌuxu. ");
INSERT INTO ata_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Iloꞌa mimuamuaꞌi voxo vile mo tamei xe tatalusou, la Avalaamu iou mulai mutukumusou laxaꞌilu e Lataua muvikalanuxu ꞌole. ");
INSERT INTO ata_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Xe muavuti la muvikalaneꞌi ta mitema sou xaixai noxou aloxo ꞌo, “Donki a, mo ngongiꞌa ngaxoxoolu ꞌo, ia nexi noxou soxu ꞌo talai ꞌole mo, ka sou nexi noxou talivu uneꞌe noxinge.” ");
INSERT INTO ata_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Avalaamu muvikalanu Aisaki sou mutavule ovu tavalanu, xe anu sou munoꞌu viso ilou navu muꞌaniꞌani no totou sou anu umuxaxu navu iou sou utauxu no anu. ");
INSERT INTO ata_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ilou mimuamuaꞌi mikei milai xoo, xe Aisaki muavuti la muvikala momu, “Mamilo,” la momu mukolinu, “Maꞌia, ꞌalixeni?” Aisaki muavuti la mutaliꞌisou momu aloxo ꞌo, “Eni emaisou lexe nini ovu tavalanu mo navu mo momoiou ano ꞌo, ia sipsip ꞌilie sou taꞌelaxu ukalusi uali noxou Lataua ꞌava?” ");
INSERT INTO ata_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Momu muavuti la mukolinu aloxo ꞌo, “Lataua molu ukamuli vile la sou ulosinge.” Ilou mivivikala aloxo ne la, aneꞌi ilou mimuamuaꞌi mikei milalai. ");
INSERT INTO ata_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ilou mimuamuaꞌi xe mixali no laxaꞌilu e Lataua mupelaꞌuxu Avalaamu, la sou anu Avalaamu mutaꞌolunu lavoꞌo musokou no lia mulai muxali teitexi sou muxali loxo valovalo. Xe mukalu la mutaꞌolunu ovu vaxa. Xe muavuti la mukasi vaxa noxou ꞌolu ka musakisakii. Mukalu la muꞌitinu sou mumuxaxu vaxa no ovu latanu e mutaꞌolunu vaxa. ");
INSERT INTO ata_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Xe mukasi vaxa no viso sou lexe uvau usoli, la ua. ");
INSERT INTO ata_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Angelo noxou IAUE muꞌava teitexi molu no opo loxotolo muluꞌe noxou sou muvikalanu aloxo ꞌo, “Avalaamu, Avalaamu!” Avalaamu mukolinu, “Maꞌia, eni ꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Navilaꞌisou ꞌiline sou navau usoli mamu. Vaimomo ꞌo, eni elavusou lexe lolomu a muxoo noxine maninanu mo nini netaxaa Lataua manina, la sou ane nini tanenixu ꞌiline soxu e vilesisi ꞌo mo naꞌapisou noxou uasi.” ");
INSERT INTO ata_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Xe Avalaamu muavuti la iou muxixao laxaꞌilu kulutitinoxu se anu ututulu no anu ne la iou mulai mutukumusou sipsip ꞌilie mulu vile ne sikiliu muꞌoso no ovu soxo vile avoavolu. Aliku ꞌo mupasipaa ꞌo la mulai munoꞌu sou muvau musoli, ka sou muꞌelaxu mukalusi. Ia ꞌolu ne, Avalaamu uvau usoli uasi, xo anu muvau sipsip ꞌilie mulu vile. ");
INSERT INTO ata_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Xe Avalaamu muavuti la mumoxoꞌu laxaꞌilu kulutitinoxu se ne lexe, “IAUE Ulosinge”. Vaimomo ꞌo ne, ta mitema ilemolu lia xalee se ne lexe, “No laxaꞌilu noxou Lataua e anu ulosinge.” ");
INSERT INTO ata_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Xe angelo noxou IAUE muavuti la muvikala molu no opo loxotolo alaxu tameisou mulai noxou Avalaamu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“No ualasilo, eni avikalaneni manina lexe, eni IAUE ane avivikala ꞌo, tavaꞌu xo nini naꞌapisou ꞌiline soxu vilesisi ne uasi. ");
INSERT INTO ata_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Nelomuxosi, la eni aalusine. Eni evikala lamana noxine mo epalaꞌalixu masaxa noxilo lexe eni axalixaꞌa ta xasixasine mo ta ꞌilusulusuneni tavuꞌalo mo ixali iꞌokiꞌoki loxo ta oto no loxotolo ꞌo mo loxo ioꞌiioꞌi no tasiꞌi. Mo ulai iliꞌi la ta mitema sou ꞌotoꞌoto imomomo sou italoxolixaꞌa uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Eni aalusiꞌa ta mitema no xalexalee tuatuala ukalusi no anu voteꞌi vilesisi. Voteꞌi ane ne, nini ta xasixasine iloꞌa ta ꞌiluꞌilusuneni ane. Xo nini nelomuxu vaikala noxilo manina misevile.” ");
INSERT INTO ata_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ilou mivikala mukalu, la Avalaamu ilou ꞌolu Aisaki milivu milai noxiꞌa ta mitema sou xaixai noxou e iloꞌa mineꞌe sou iloꞌa milivu milai ne Beru-seva xe muxolu no anu. ");
INSERT INTO ata_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Avalaamu muxoxoo xe iliꞌi la mulomu lexe, “Milika a mipalaa mo ta ꞌilie seꞌi. Milika ne eiae Naola semau. Anu Naola ne nini vivine. ");
INSERT INTO ata_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Naola ilee Milika ta ꞌiliꞌa ualaualasiꞌa ano ꞌo, Usu, anu laposalaxu. Vusu mo Kemueli eiae Alamu momu. ");
INSERT INTO ata_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Mo Keseti mo Kaso mo Piludasi mo Itilapu mo eiae Betueli.” ");
INSERT INTO ata_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli ne Liveka mamie. Milika ilou Naola mipalaaneꞌi ta ꞌiliꞌa ta mulu ane muxatele tatalu ne. ");
INSERT INTO ata_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Xe Leuma mipalaaneꞌi ane eiae Teva ilou Xaamu mo Taasi mo Maaka. Leuma ne eiae Naola semau ane iliꞌi ane. ");
INSERT INTO ata_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala mixoo mo mimaulixu tauu ie loxo itemaxu taꞌuve mo mavulovexa tamei mo muxatele tamei (127), la sou misoli. ");
INSERT INTO ata_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Misoli ne Ebulon no xalee ne Kanani, la mulue Avalaamu muxolu sou mutamasie. ");
INSERT INTO ata_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Xe muavuti la semau xalusie muai ne, ia anu mulutu mulai noxiꞌa ta Keti sou muvikalaneꞌi aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Eni ꞌo sou tuala vile vaꞌaxu mo a, ia eni eneꞌe exoo no nixi no taingengi ꞌo. Emasaxa lexe aloto lia xalee sevile noxinge mo aꞌasixe semaxe no anu.” ");
INSERT INTO ata_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Xe aneꞌi miavuti la mikolinu vaikalau aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nalomu uneꞌe noxixe, nexi telavu lexe nini toxo tila vile maninanu, la anu mii vile uasi, naꞌasixe semameni no anu taxa no maea tavaꞌu lai ꞌo. Nini nasosovosou vile ane nini namasaxau. Vile noxixe ꞌo opo uꞌosa mo lexe uiꞌtalonu taxa vile sou nini naꞌasixe no anu, la anu mii vile uasi.” ");
INSERT INTO ata_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Xe Avalaamu muavuti la, muxolaꞌu tavaꞌu sou mutulu no tavaꞌu voꞌuxu ka mutangatulu muluꞌelai no laxuneꞌi sou mutoxoneꞌi sou ");
INSERT INTO ata_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","muvikala aloxo ꞌo, “Lexe ngingi opongengi muꞌosasi mo ngemasaxa lexe eni aꞌasixe Sala lai ꞌo, la eni emasaxa lexe ngingi ngataliꞌisou Epulon, eiae Sokaru ꞌolu, ");
INSERT INTO ata_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","lexe umasaxa la eni alotonu taxa Makapela noxou. Taxa ne miꞌasou muxoo ane no liaxu paꞌumolu. Ngataliꞌisou mo sou lexe anu umasaxa la eni alotonu noxou no anu lapee toxoxaꞌa umomomo no anu ane alalae no iengi ꞌosi, mo sou anu lia xalee ane ne eni naꞌaxeni sou aꞌasixaꞌa ta mitema no anu.” ");
INSERT INTO ata_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Epulon to a uxoxoolu ulolomu no taineꞌi ta menexu no anu pita ane ne no aitengaxu vimelusou tualasiꞌa ne. Xe muavuti soxu la muvikala no ieꞌi aneꞌi ta tatila iloꞌa ta menexu sou mukolinu taliꞌi noxou Avalaamu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ae, nalomu. Eni alosine lia xalee ane ne ukalusi mo taxa e miꞌasou muxolu no nano no anu ne, kalumo. Eni avivikala ꞌo, la ta mitema noxilo ane itaꞌotaꞌolu ilolomusilo eni avikala no iengi ngongiꞌa ꞌo. Eni alosine vitanisi sou nini naꞌasixe Sala no anu.” ");
INSERT INTO ata_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Xe Avalaamu muavuti la mutangatulu sou mutoxoneꞌi no ieꞌi ta Keti ane mineꞌe mipita ne sou ");
INSERT INTO ata_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","mukolinu vaikalau Epulon mo sou aneꞌi latala ne ilomusou, “Epulon, eni alingaine lexe nini nalomu uneꞌe noxilo. Eni masaxa noxilo tila lexe alotonu lia xalee ane ne ukalusi. Xavutalameni uꞌosasou masaxa noxilosi mo sou eni aꞌasixe semaxeni ane.” ");
INSERT INTO ata_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Xe Epulon muavuti la muvikalanu Avalaamu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ae, lia ne mumomomo no anu lamoli siliva alelaxu loxo itemaxu mavulovexa tamei (400). Ia anu mii vitanisi no nixi noxinge nengei. Nalai naasixe semameni no anusi.” ");
INSERT INTO ata_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Avalaamu mulomu aloxo ne, la mulavu lexe lapee ane ne, anu mumomomo aloxo Epulon mulemolu la sou mulosou lamoli no ieꞌi ta Keti ane mineꞌe mipita no voxo ane ne. ");
INSERT INTO ata_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","La sou anu lia xalee ane ne ilou taxa ne, anu Epulon naꞌu, ia Avalaamu mulotonu noxou mole anu naꞌu. Lia xalee ane ne, muxolu ne Makapela no xalee ane aso uxaxali utelo no anu ne Mamule. Lia ane Avalaamu mulotonu noxou Epulon ne aꞌalosou aloxo ne. Mulotonu taxa mo ovuovu maꞌimaꞌi a ane muleme no lia ane ne mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ta mitema ta Keti ane mineꞌe mixolu no anu pita ane ne, aneꞌi milavu lexe lia xalee ane ne, anu Avalaamu naꞌu. ");
INSERT INTO ata_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Xe vaivaikalasou lia mukalu, la sou Avalaamu mulai muluvone semau sou muneꞌe muꞌasixe no taxa ne Makapela alai ne Mamule. Lia xalee ane ne muxolu no nano no lia tila ne Kanani. ");
INSERT INTO ata_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","La sou lia xalee ane anu Avalaamu mulotonu ne, ta Keti naꞌa la ua, anu naꞌu. Mo lia xalee ane sou iꞌasixaꞌa ta mitema no anu ne, anu Avalaamu naꞌu. ");
INSERT INTO ata_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Avalaamu mumaulixu tauu ie piena xoo mole, anu aululu mukalu. Mimii piepiena ane anu muꞌoxonu ne, IAUE mualusouxu no anu mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Xe muavuti la muꞌavalou itema sou xaixai noxou vile. Anu itema ane ne anu itema tila kena. Anu sou usaxisaxilaꞌu mimii noxou Avalaamu mukalusi. Muvikalanu aloxo ꞌo, “Namuxaxu avone vaxa no laaxu poxoꞌilo mo navikalaleli manina. ");
INSERT INTO ata_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Eni emasaxaine lexe navikala manina no ualasou IAUE anu Lataua sou loxotolo mo lia, lexe mamu nini nasosovosie sema vile iu ꞌalixeni noxiꞌa ta mitema lai ne Kanani ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Laixe nini nalivu ulai no tuala noxilo mo nanoꞌe sema vile iu ꞌalixeni Aisaki noxiꞌa ta milemileli lai ne.” ");
INSERT INTO ata_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Xe anu itema ne muavuti la mutaliꞌisou Avalaamu, “Lexe eni alai xe axalisie sema vile iu ꞌiline xe eni avikalane, xe imulileli ineꞌe ꞌo uasi la ane ne loxovaa? Eni apalusou Aisaki ulivu ulai no tuala nini neꞌumesou?” ");
INSERT INTO ata_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Avalaamu muavuti la mukolinu aloxo ꞌo, “Mamu nini napalusou ꞌalixeni ulivu ulai ne, naxavutalanu ane ne laixe. ");
INSERT INTO ata_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","IAUE Lataua sou opo loxotolo munoꞌilo no tualasou mamilo mo no lia liaxaꞌa ta milemileli mo anu muvikala manina lexe lialia ano ꞌo ne anu ulosiꞌa ta ꞌaliꞌalixe iloꞌa ta xasixasilo mo ta ꞌiluꞌilusuleli. Anu molu upalusou angelo noxou sou uulaxuneni sou nini naxalisie sema vile iu ꞌalixeni. ");
INSERT INTO ata_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Lexe nini naxalisie sema vile, xe imulineni sou ngongou nganeꞌe uasi, la vaikala eni evikalanenixu ne umomomo sou utaluxene uasi. Ia nalailixu ꞌalixeni ulivu ulai no tuala noxilo ne uasi.” ");
INSERT INTO ata_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ioxe, anu itema sou xaixai noxou ne muavuti la mumuxaxu avolu vile ne no laaxu Avalaamu poxoꞌu sou muvikala manina lexe anu umulinu aloxo anu Avalaamu mulemolu ne. ");
INSERT INTO ata_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Xe itema sou xaixai noxou anu Avalaamu muavuti la munoꞌa ta kameli mavulovexa noxou anu Avalaamu ne, xe munoꞌu mimii piena lailaixe kalumo. Munoꞌu mimii ane ne mukalu, la sou anu mulutu sou mulai noxou Naola ne Mesopotamia. ");
INSERT INTO ata_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mulai xe muxali, la mutaꞌoluneꞌi ta kameli ꞌalai no lexa iou no ale no tuala ne sou mitaꞌolu no lia. Anu asou ꞌoloꞌolovoxo mole ta sema aneꞌi sou ineꞌe itau lexa. ");
INSERT INTO ata_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Xe mutaꞌoluneꞌi ta kameli mukalu, la sou anu mulinga, “IAUE, nini Lataua noxou tatila noxilo Avalaamu. Nini menesi naꞌoxo mii ano ꞌo manina noxilo vaimomo ꞌosi. Mo namaxaꞌu alauna noxine noxou itema tila noxilo Avalaamu. ");
INSERT INTO ata_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Namalei, eni ane atutulu no paꞌumolu lexa iou ꞌo, mo ta mitema no tuala ꞌo, ta ꞌiliꞌiliꞌa ta vuanga ane ineneꞌe sou itau lexa. ");
INSERT INTO ata_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ia lexe eni avikalane vile aloxo ꞌo, ‘Eiseo, namuxaxu lexaxene netau ne no lia mo eni aie.’ Xe ane ivikala lexe, ‘Ioxe, amula ꞌo, ka sou naie. Xe naie ukalu, la sou eni aieneꞌi ta kameli kalumo.’ Eni emasaxa lexe ane sema ane nesi ane nini mene nesosovosie lexe itema sou xaixai noxine Aisaki semau. Lexe anu masaxa ane ne uxali manina, la eni alavusi lexe nini nemaxau alauna noxine noxou itema tila noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Anu a ulilinga mo ukalu uao, ia Liveka mitavulenu lexaxe vexasou no laxasie mineꞌe mixali. Liveka ne Betueli ꞌolu sema. Betueli ne momu ane Naola, eiae Avalaamu vimou. Xe semau ne Milika. ");
INSERT INTO ata_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Liveka ne vuanga ꞌo, iei ne lailaixe misevile mo ilou mulu vile iai uao. Mineꞌe la milai avile no lexa iou sou mitau lexa, xe mukalu la milivu mitelo. ");
INSERT INTO ata_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Xe itema sou xaixai noxou Avalaamu ne mupasipaa ꞌo la muiave mulai noxie la muvikalane aloxo ꞌo, “Naiele no anu lexaxene mo aie sevile.” ");
INSERT INTO ata_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Xe ane miavuti la mivikalanu aloxo ꞌo, “Ioxe, Naie.” La sou ane mitaloxolixu lexa vexasou mititilonu ne muluꞌe mitetelisou sou mitelixu sou muie. ");
INSERT INTO ata_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Xe muie mukalu la ane mivikalanu aloxo ꞌo, “Neie mukalu, ia eni alai mo aieneꞌi ta kamelimeni mo aneꞌi iie kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Xe ane miavuti la milai minixiꞌu lexa paꞌusou no lupexaꞌa ta kameli io milai sou mitauxaꞌa lexa la. Miieneꞌi xoo mole, ta kameli tavuꞌalo ne mikalusiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ia itema ne anu iou a ulalai noxie sou uutiei, ia uvivikala uasi. Anu umasaxa lexe umaisou Lataua IAUE uxaxai no anu mii ane ne mo lexe uxali maninasou loxo mulingau mulai noxou. ");
INSERT INTO ata_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Xe ane miieneꞌi mukalu, la anu munoꞌu suva xoulu vile ne tuꞌumaxu muxali loxo gramu taꞌuve sou mulilixu no kusinei xe mukalanu lasa xoulu tamei tuꞌumaxu muxali loxo gramu itemaxu taꞌuve (100) no avole. ");
INSERT INTO ata_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Xe mukalu la mutaliꞌisie aloxo ꞌo, “Maula se, navikalaleli, mamine ꞌenaꞌei? Mo lovoxaa tani noxou ne tila sevile sou nexi noxiꞌa ta mitema noxilo noxiꞌa taai no anu maasi?” ");
INSERT INTO ata_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Xe ane miavuti la mikolinu aloxo ꞌo, “Mamilo ne ualasou lexe Betueli, eiae Naola ilee Milika ꞌiliꞌa. ");
INSERT INTO ata_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Mo nexi ta kameli taasiꞌa lailaixe a uxolu mo laꞌilalixaꞌa kalumo piena misevile a uai sou iꞌou mo tani a uxolu sou ngaxolu no anu.” ");
INSERT INTO ata_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Xe itema ne muavuti la muxolaꞌu tavaꞌu voꞌuxu sou mutulu no anu sou mutangatulu muluꞌelai sou mulotu mulai noxou IAUE. ");
INSERT INTO ata_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Muvikala aloxo ꞌo, “Eni aꞌiti ualasine IAUE, nini Lataua noxou tila noxilo Avalaamu. Nini nemaxau alauna noxine noxou itema tila noxilo mo nini neꞌoxo maninasou vaikala noxine ane nini nevikalanu no anu. Vaimomo ꞌo, nini menesi neoleleli mole ane eni emuamuaꞌi elapu eneꞌe noxiꞌa ta minuminu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Xe sema miavuti la miiave alaxu vilesisi milai noxie nenie taasie sou miaꞌaloiꞌa ta minemine. ");
INSERT INTO ata_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Liveka vimoe vile mulu ualasou lexe Lavani, anu mulomu la muiave muatulai no ale sou mulai avile no lexa iou e itema sou xaixai noxou Avalaamu muneꞌe muxalisie vimou no anu. ");
INSERT INTO ata_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lavani mumaisou suva noxie vimou kusinei xe lasa no avole, xe mulomusou vaivaikala e itema sou xaixai noxou Avalaamu muvikalanexu, la anu mulai noxou. Anu itema ne a iloꞌa ta kameli itutulu no lexa iou paꞌumolu. ");
INSERT INTO ata_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lavani mulai xe muxali noxou, la muvikalanu aloxo ꞌo, “Naneꞌe mo nengei talai no tani. Lataua IAUE tanuxene mo mualusine. Ia loxovaa ane nini natutulu loxo ꞌo? Eni epaipou taasine no taasilo mukalu, mo ta kameli ne taasiꞌa kalumo a muxolu.” ");
INSERT INTO ata_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Xe itema sou xaixai noxou Avalaamu mulomu aloxo ne xe mukalu la mumulinu Lavani mulai no tani. Ilou milai xe mixali no tani, la Lavani muvikalaneꞌi ta mitema sou xaixai noxou sou misuꞌulineꞌi sou miluꞌenu mimii ne no lataneꞌi ta kameli, xe mukalu la miitixaꞌa iaꞌeiaꞌe mo laꞌilali sou miꞌou. Xe mukalu la minoꞌu lexa mulai noxou itema sou xaixai noxou Avalaamu iloꞌa ta mitemau sou iꞌuinu tavaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Minoꞌu laꞌilali mineꞌenu sou iꞌou, la anu itema sou xaixai noxou Avalaamu ne muvikala aloxo ꞌo, “Eni umomomo sou aꞌani palea uasi, lexe eni avikala lamana no anu mii ane eni eneꞌe lexe alemolu lamana noxinge, la sou eni aꞌani.” Xe Lavani muavuti la mukolinu vaikalau aloxo ꞌo, “Ioxe, navivikala.” ");
INSERT INTO ata_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Xe anu muavuti la muvikala musokou aloxo ꞌo, “Eni itema sou xaixai noxou Avalaamu, ");
INSERT INTO ata_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","IAUE Lataua mualusou tatila noxilo Avalaamu misevile, mo muꞌoxonu muxali itema sou lavuluti. Muitiu ta sipsip mo ta mee mo ta kau, siliva mo xoulu. Ta mitema ane sou upalulapusiꞌa, aneꞌi ane ta sema xe ta mulu. Muitiu ta kameli mo ta donki kalumo. ");
INSERT INTO ata_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sala e tatila noxilo semau, ane aululu, ia ane mivoꞌonu ꞌilie vile mulu. Tatila noxilo Avalaamu muitiu mimii noxou latala ne mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Anu muvikala pekiaꞌu noxilo aloxo ꞌo, ‘Eni axoxoo lai ꞌo ne Kanani, ia mamu nini nasosovosie sema vile noxiꞌa ta Kanani lexe ꞌalixe semau, uasi. ");
INSERT INTO ata_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nini nalai noxiꞌa mamilo ta temanu tuala sou mo nakamuli iu ꞌalixeni sema ane.’ Anu muvikala aloxo ne la sou eni evikala lamana manina lexe eni amulinu vaikala anu muvikalalelixu ne. ");
INSERT INTO ata_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","La sou eni evikalanu tatila noxilo aloxo ꞌo, ‘Lexe sema ane ne, imasaxa lexe imulileli ineꞌe uasi, la ane ne loxovaa?’ ");
INSERT INTO ata_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","La anu muvikala aloxo ꞌo la, ‘Eni amitema sou alolomu mo amulinu vaikala noxou IAUE. Anu molu upalusou angelo noxou sou umulineni sou mii e nini nalai naꞌoxo ne, anu uxali laixesi. La sou nini namomomo sou nanoꞌe iu ꞌalixe sema vile noxiꞌa ta mitema noxou mamilo. ");
INSERT INTO ata_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Lexe nini naꞌoxo aloxo, ne la vaikala ano ꞌo umomomo sou utaluxene la uasi. Mo lexe nini nalai noxiꞌa ta milemileli xe, ilomuxu vaikalameni uasi, la anu aloxo nesi, vaikala eni evikalanenixu ne umomomo sou utaluxene uasi.’ ");
INSERT INTO ata_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Vaimomo ꞌo eni eneꞌe exali no lexa iou la elinga aloxo ꞌo, ‘IAUE, Lataua noxou tatila noxilo Avalaamu, nini mene naꞌoxo xaixai ane eni eneꞌe lexe aꞌoxonu ꞌo mo uxali manina. ");
INSERT INTO ata_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Eni a axoxoo ꞌalai no lexa iou, ia lexe sema vuanga vile ineꞌe itau lexa, la eni avikalane aloxo ꞌo, “Eiseo, natauxenixo lexa uneꞌe mo aie.” ");
INSERT INTO ata_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Xe ane imasaxa, xe imasaxa sou iieneꞌi ta kameli xe kalumo, la ane sema e nini nesosovosie lexe tatila noxilo ꞌolu semau ane.’ ");
INSERT INTO ata_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Eni akalusou lingalinga noxilo uao, ia Liveka mineꞌe mixali. Mitavulenu lexa vexasou no laxasie miluꞌelai no lexa iou sou itau lexa. Xe eni eavuti la evikala aloxo ꞌo, ‘Eiseo, natauxenixo lexa sevile uneꞌe mo aie.’ ");
INSERT INTO ata_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Xe ane mipasipaa ꞌo la miluꞌenu lexa vexasou no laxasie la mivikala lexe naie. La sou mitelixu sou eie. Xe miavuti la mivikala lexe eni alai mo aieneꞌi ta kamelimeni kalumo. ");
INSERT INTO ata_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Xe eni elutu vaxa la etaliꞌisie, ‘Mamine ꞌenaꞌei?’ Ane miavuti la mikolinu taliꞌixeni lexe, ‘Eni mamilo ualasou lexe Betueli, eiae Naola ilee Milika ꞌiliꞌa.’ Eni elomu aloxo ne, xe eavuti la enoꞌu suva vile ka ekelelixu no kusinei xe lasa no avole tamei. ");
INSERT INTO ata_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Xe eavuti la exolaꞌu tavaꞌilo voꞌuxu sou etulu no anu sou elotu mulai noxou IAUE. Evikala laixe mo eꞌiti ualasou Lataua IAUE, anu Lataua noxou tatila noxilo Avalaamu. Anu molu mupaamuxale muneꞌe noxou tatila noxilo vimou mole ane eni eneꞌe exalisie sema vuanga ꞌo sou iꞌuluxu tatila noxilo ꞌolu. ");
INSERT INTO ata_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ia ngingi alalae ꞌosi ne lexe ngingi ngamaxaꞌu alauna ulai noxou tatila noxilo mo ngaꞌoxo ꞌilixo laixe ulai noxousi, la ngavikala lamana noxilo, xe uasi la ngavikala lamana kalumo, mo sou eni atovo xavutala vile la.” ");
INSERT INTO ata_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Xe Lavani ilou Betueli miavuti la mikolinu vaikalau itema ne aloxo ꞌo, “Nexi telavusou lexe mii ano ꞌo molu noxou IAUE Lataua, la anu umomomo sou nexi tamuli xavutala vile la uasi. ");
INSERT INTO ata_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ia Liveka ano, nanoꞌe mo nalailixe sou tatila noxine ꞌolu uꞌuluxe aloxo masaxa noxou IAUE.” ");
INSERT INTO ata_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Xe itema sou xaixai noxou Avalaamu mulomu aloxo ne la mutangatulu muluꞌelai sou mulotu mulai noxou IAUE. ");
INSERT INTO ata_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Xe muavuti la mulaasou lavuluti ane anu mutaataa no tivaxu sou mulosie Liveka. Munoꞌu mimii seꞌi loxo siliva ilou xoulu mo lavalava sou mulosie Liveka xe mulosou vimoe ilee nenu lavuluti seꞌi ane lailaixe kalumo. ");
INSERT INTO ata_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Iloꞌa mivikala mo mulosiꞌa mimii ne mukalu, la sou anu iloꞌa ta mitemau miꞌani mo miie. Xe mukalu la milai miai. Xe mitulu no kakau, la anu muvikala lamana noxiꞌa aloxo ꞌo, “Eni emasaxa lexe alivu ulai noxou tatila noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Xe Liveka vimoe ilee nenu miavuti la mivikala aloxo ꞌo, “Ngingi ngongiꞌa ta mitema noxine ngalai, ia Liveka ne lexe ixolu voxo mavulovexa vile, ka sou ilai.” ");
INSERT INTO ata_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ia anu muavuti la muvikala aloxo ꞌo, “Mamu ngaꞌoxonexi sou taxolu la. IAUE molu musuꞌulileli mo xaixai noxilo ane muneneꞌa ꞌo. Ia ngaꞌapixo mamu, ngaꞌitaloleli mo alivu ulai noxou tatila noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Xe aneꞌi miavuti la mivikala lexe, “Taꞌavalie ineꞌe mo tataliꞌisie ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","La sou miꞌava Liveka milai sou mitaliꞌisie lexe, “Loxovaa, nemasaxa lexe namulinu itema ꞌo?” La ane mikolinu lexe, “Ani, eni emasaxa lexe alai.” ");
INSERT INTO ata_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","La sou nenie ilou vimoe mipalusie ilee sema tila milai sou mimulinu itema sou xaixai noxou Avalaamu iloꞌa ta mitema noxou. ");
INSERT INTO ata_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Xe miavuti la mialusie no anu vaivaikala ano ꞌo, “Vivixe sema, ulai iliꞌi la tavuꞌalo misevile neniꞌa ane nini. Ulai aso vile la ta xasixasine iloꞌa ta ꞌiluꞌilusuneni italoxolixaꞌa ta uluaiꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","La sou Liveka iloꞌa ta sema sou xaixai noxie mitaxusou miꞌamiꞌa sou mimulinu itema sou xaixai noxou Avalaamu iloꞌa ta mitema noxou sou milai. ");
INSERT INTO ata_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","No voxo ane ne, Aisaki muꞌumesou xalee lia vile, ia no nano no xalee lia ane ne lexa iou vile a uxolu. Ilemo lexe, “Lexa Noxou Lataua Ane Mauli Muxolu Noxou Mo Umamaisilo”. Xe anu muxoxoolu ne Nexevu. ");
INSERT INTO ata_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","No ꞌoloꞌolovoxo no voxo ane ne, la anu mulutu sou mukilaka no tani tatatexa xe iou mulai la iou mutukumusiꞌa ta kameli ineneꞌe loxo noxou. ");
INSERT INTO ata_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Xe Liveka mimaisou la mitaloxo noxou kamelie miluꞌe no lia, ");
INSERT INTO ata_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","xe miavuti la mitaliꞌisou itema sou xaixai noxou Avalaamu, “Itema ꞌenaꞌei e uaalanenge umumuamuaꞌi uneneꞌe ne?” Anu muxiu vaxa la muvikalane lexe, “Ua, tatila noxilo ane.” Xe ane milomu aloxo ne, la ane mipasipaa misuꞌasou iei no anu lavalava sou kisie. ");
INSERT INTO ata_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Aisaki muneꞌe muxali noxiꞌa la sou itema sou xaixai noxou muaꞌaloxu muamuaꞌi noxou mo mimii ane muxali no anu muamuaꞌi noxou. ");
INSERT INTO ata_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Aisaki muavuti sou munoꞌe miꞌunalai no taasie nenu Sala, la sou anu muꞌuluxe semau ne. Anu umasaxaie misevile mole tanutanuxe nenu la ua. ");
INSERT INTO ata_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Sala misoli la Avalaamu muꞌuluxe sema vile la, ualasie lexe Ketula. ");
INSERT INTO ata_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","La sou ilou mipalaaneꞌi ta ꞌiliꞌa la ualaualasiꞌa ano ꞌo, Simulani, Iokusani, Medani, Midiani, Isivaki xe Sua. ");
INSERT INTO ata_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iokusani mupalaaneꞌi ta ꞌolu ane Seva ilou Tetan. Tetan ta ꞌolu ane mixalixaꞌa ta mitema sou tuala ne Asulu mo ta mitema ne Letusi mo ne Leumi. ");
INSERT INTO ata_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Xe Midiani ta ꞌolu ta mulu ane Epa ilou Epe mo Kanoko mo Avita mo Eluda. Aneꞌi ane ne Ketula ta ꞌiliꞌilie iloꞌa ta xasixasie. ");
INSERT INTO ata_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Avalaamu muꞌitalonu lavuluti noxou mukalusi mulai noxou ꞌolu Aisaki. ");
INSERT INTO ata_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Xe no mine anu uao uxoxoolu o, la lavulavuluti seꞌi ne muitiꞌa ta ꞌolu ane noxiꞌa ta semasemau ane iliꞌi. Mulosiꞌa mukalu la mupalusiꞌa sou milai mixolu vaꞌaxu noxou Aisaki no lia xalee ane aso uxaxali utelo no anu. ");
INSERT INTO ata_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Avalaamu muxolu mumaulixu tauu ie loxo itemaxu taꞌuve mo mavulovexa muxatele tamei mo taꞌuve (175), ");
INSERT INTO ata_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","mole anu aululu soxu manina. Muxoxolusi xe mulapuu tauuxu kaluxu alaxu vilesisi loxo ꞌosi la musivita soxu. Anu aululu manina vile xo mumaulixu tauu ie piena misevile. Xe no voxo ane anu musoli no anu ne, la uleenu muluꞌelai no tualasiꞌa ta mitema sou soli. ");
INSERT INTO ata_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ta ꞌolu tamei eiae Aisaki ilou Isimaeli mitavule sou milai miꞌasixu ne Makapela. Makapela ne muxoo no xalee mulai loxo aso uxaxali utelo no anu ne Mamule. Tei la lia xalee ane ne, Epulon liaxu. Epulon ne itemasie tuala ne Keti, momu ualasou lexe Sokaru. ");
INSERT INTO ata_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Avalaamu molu mulotonu lia ane ne noxiꞌa ta mitema ne Keti. Milai miꞌasixu anu Avalaamu no paꞌumele semau Sala ane. ");
INSERT INTO ata_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Avalaamu musoli io Lataua muavuti la mualusou ꞌolu Aisaki. Aisaki mulai muxolu ꞌalai no lexa iou vile ilemolu lexe, “Lexa Noxou Lataua Ane Mauli Muxolu Noxou Mo Umamaisilo”. ");
INSERT INTO ata_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ioxe nanasou Isimaeli ano ꞌo. Isimaeli ne, Avalaamu mupalaanu noxie Axali semasie Aixiputo e Sala minoꞌe sou mixoo noxie sou ipalupalusie ne. ");
INSERT INTO ata_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mupalaaneꞌi la ta ꞌolu ualaualasiꞌa ano ꞌo. Musokou noxou ane laposalaxu la mulai muxali noxou soxu ane kaluxusiꞌa. Laposalaxu ane Nevaiote ka Kedaru, Atibelu, Mipusamu, ");
INSERT INTO ata_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Tuma, Masa, ");
INSERT INTO ata_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Kadati, Tema, Ieturu, Napisi xe Kedema. ");
INSERT INTO ata_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Aneꞌi, ta mitema e mavulovexa mo mulelia tamei ne, Isimaeli ta ꞌolu ta mulu ane. Ualaualasiꞌa ne, mimoxoꞌu tuatualasiꞌa ilou tanitanixu maulixaꞌa no anu. Aneꞌi Isimaeli ta ꞌolu mixalixaꞌa ta mitema sou mata noxiꞌa vilevilesi. ");
INSERT INTO ata_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Xe Isimaeli tauu iexu mulai muxali loxo itemaxu taꞌuve mo mavulovexa tatalu mo muxatele tamei (137) la sou anu musoli. Xe no voxo ane anu musoli no anu ne, la uleenu muluꞌelai no tualasiꞌa ta mitema sou soli. ");
INSERT INTO ata_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ta xasoxasou iloꞌa ta ꞌilusulusunu ne milai mixolu no lia xalee no nixi ne Avila xe ne Suru no voteꞌi mulai ne Asulu ꞌalai ne Aixiputo. Aneꞌi milai mixolu vaꞌaxu noxiꞌa Avalaamu ta xasoxasou iloꞌa ta ꞌilusulusunu ane noxou ꞌolu Aisaki. ");
INSERT INTO ata_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Avalaamu ꞌolu e ualasou lexe Aisaki, nanasou aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaki tauu iexu mulai loxo itemaxu tamei (40) la sou anu muꞌuluxe Liveka eiae Betueli ꞌolu. Betueli anu sou tuala ne Alamu no xalee ne Mesopotamia. Vimoe mulu ualasou lexe Lavani. ");
INSERT INTO ata_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisaki muꞌuluxe semau Liveka ne, ia ipalaa uasi, la sou mulinga mulai noxou IAUE la sou ane opoone. ");
INSERT INTO ata_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Opone ne la ta ꞌilie tamei a mixolu no nano, la ilou iꞌotoꞌoto. La sou ane miavuti la mitaliꞌi aloxo ꞌo, “Loxovaa ane mii ano ꞌo muxali noxilo loxo ꞌo?” Xe miavuti imasaxa lexe ilavu no anu tavaꞌu ꞌotoꞌoto noxiꞌa ta keakea tamei ne. La sou mele mitaliꞌi no anu linga noxie mulai noxou IAUE. ");
INSERT INTO ata_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","La sou IAUE mukolinu taliꞌi noxie aloxo ꞌo, “Ta mutuꞌu ovuxaꞌa ta mitemta tamei ane ixoxoo no nano no oponeni ne, ulai iliꞌi, la sou nini navoꞌoneꞌi, ia ulai iliꞌi la ixolu ipita uasi, ikalipalaꞌa. Vile xaviinu xe vile ne xaviinu uasi. Ane kituꞌa e uxali la uluꞌe iliꞌi ne, ulai la anu usaxilaꞌu anu ane nini navoꞌonu tei.” ");
INSERT INTO ata_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Xe no voxo ane sou Liveka mivoꞌo, la mivoꞌoneꞌi ta ꞌilie ta vunaxaꞌa ta sema ta mulu tamei. ");
INSERT INTO ata_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ane muluꞌe tei ne, vasimolu lauolauoinu xe laxulaxusou. La sou mimoxoꞌu ualasou lexe Esau. ");
INSERT INTO ata_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Xe ane muluꞌe iliꞌi ne muluꞌe la avolu muteteli noxou ane muuli ne tavaꞌu uluꞌu. La sou mimoxoꞌu ualasou lexe Iakovo. No tauu ie ane, ane Liveka mivoꞌoneꞌi ta ꞌilie tamei ne la Aisaki anu tauu iexu mulai muxali loxo mavulovexa muxatele vile (60). ");
INSERT INTO ata_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ta ꞌolu ta tamei ne mileme mipalea loxo ꞌo. Esau ne muxali itema vile sou paipaa manina. Mulavu laixe misevile sou uvau mii. Ia Iakovo ne anu itema vile sou uxoxoo seꞌisisi sou uꞌoleꞌole no tualasi. ");
INSERT INTO ata_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisaki umasaxau Esau misevile xo anu uꞌosasou taataa e unonoꞌu anu uꞌoꞌou utotomu. Xe Liveka ne ane imasaxau Iakovo misevile. ");
INSERT INTO ata_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","No voxo vile la Iakovo uxuxutuxu laꞌilali seꞌi ne seꞌisisi. Xe Esau mulai mupaipaa xe muxali, la musolixu. ");
INSERT INTO ata_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Xe muavuti la muvikalanu vimou Iakovo aloxo ꞌo, “Eni esolixo misevile, naitixo laꞌilali lauoinu e naxuxutuxu ne seꞌi.” La sou ane aneꞌi mimoxoꞌu Esau ualasou vile lexe Edomu. ");
INSERT INTO ata_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ioxe, anu Iakovo muavuti la mukolinu vaikalau Esau aloxo ꞌo, “Lexe nini nalosilo ualasine lexe nini laposalaxu ne, la sou eni aitixene laꞌilali ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Xe Esau muavuti la muvikala aloxo ꞌo, “Anu mii vile uasi. Eni a ꞌalalai sou asoli. Uala ane ne, anu mii vitanisi, umomomo sou uxalixu mii vile noxilo uasi.” ");
INSERT INTO ata_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Xe Iakovo muavuti la muvikalanu vimou ne lexe, “Ia lexe nini navikala maninasou lexe nini nemasaxa manina lexe naꞌitalo uala ane ne uneꞌe noxilo.” Esau muavuti la muvikala maninasou, la sou mulosou uala ne lexe anu Iakovo anu laposalaxu. ");
INSERT INTO ata_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Xe Iakovo muavuti la sou muitixu vimou Esau ne, veleti ilou laꞌilali seꞌi ane anu muxuxutuxu ne. Muꞌani mo muie mukalu, la sou mulutu sou mulai. No anu xavutala ane Esau mumulinu sou muxexeenu ualasou lexe anu laposalaxu mulai noxou vimou ne, anu lamana lexe anu uala ane ne, anu mii vitanisi noxou anu Esau. ");
INSERT INTO ata_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tauu vile sou soli muxali ne Kanani la loxo ane muxali no tauu ane Avalaamu muxoxoolu ꞌo, la sou Aisaki mulai noxou Avimeleki, anu tatananu tuala noxiꞌa ta Pilistia no tuala tila ne Xelalu. ");
INSERT INTO ata_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","IAUE mupalaꞌa noxou no voxo ane ne la muvikalanu aloxo ꞌo, “Naluꞌelai ne Aixiputo uasi, naxolu no xalee lia ane eni melo avikalaneni sou naxolu no anu. ");
INSERT INTO ata_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Naxolu no lia xalee ane ne la eni kalumo axolu noxine mo aalusine. Lia xalexalee ano ꞌo eni alosinge ngongiꞌa ta ꞌiline mo ta xasixasine iloꞌa ta ꞌiluꞌilusuneni ukalusi, aloxo ꞌo eni elemolu lamana noxou mamine Avalaamu. ");
INSERT INTO ata_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Eni axalixaꞌa ta ꞌiliꞌiline mo ta xaisxasine iloꞌa ta ꞌiluꞌilusuneni ixali tavuꞌalo loxo ta oto teitexi no loxotolo. Mo sou aꞌitalonu lia xalexalee no anu lia lololinu ano ꞌo noxiꞌa. Xe ulai iliꞌi, la eni aalusiꞌa ta mitema no xalexalee tuatuala ukalusi no anu voteꞌi vilesisi. Voteꞌi ane ne, nini ta xasixasine iloꞌa ta ꞌilusulusuneni, ");
INSERT INTO ata_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","xo Avalaamu anu mulomuxo mo mumulinu masaxa noxilo mo vaivaikala noxilo laixe mukalusi. Tavaꞌu aloxo ne, la sou ane eni aꞌoxonu ꞌilixo laixesi ulai noxine.” ");
INSERT INTO ata_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aisaki mulomusou vaivaikala lamana noxou IAUE mukalu, la sou anu muxolu ane ne Xelalu. ");
INSERT INTO ata_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Xe no voxo ane ta mitema sou tuala tila ne Xelalu mitaliꞌisou sie semau Liveka ne, la anu muvikalaneꞌi lexe, Liveka ne, anu semau uasi, vimou ane. Muxavutala lexe utalumeieꞌi ilou aloxo ne xo loxo io anu upalaꞌalixe lexe anu semau ane, la aneꞌi ivau. Xo ane Liveka ne iei lailaixe misevile. ");
INSERT INTO ata_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisaki muxoxoolu no xalee tuala ane ne maxuveeni misevile, xe no voxo vile la Avimeleki tatananu tuala noxiꞌa ta Pilistia mutulu no aitenga sou atume no taasou la iou mulaiiou Aisaki mine usaꞌasaꞌavunoxe Liveka. ");
INSERT INTO ata_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Avimeleki mumaisou Aisaki aloxo ne mukalu, la muꞌavalou mulai noxou la muvikalanu aloxo ꞌo, “Aisaki, vaimomo ꞌo eni elavu, sema e ngongou ngaxoxoolu ne, nini semameni ane, ia loxovaa la nini nevikala lexe nini vivine sema ane?” Xe Aisaki muavuti la mukolinu taliꞌi noxou Avimeleki aloxo ꞌo, “Eni xavutalaxeni muꞌume xo loxo ꞌo io maasi xe eni apalaꞌalixe lexe ane semaxe ane, la ta mitema ineꞌe ivelo asoli io sou ineꞌe inoꞌe la ilai iꞌuluxe.” ");
INSERT INTO ata_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Xe Avimeleki muavuti, la muvikalanu aloxo ꞌo la, “Nini nesusu toxoxaꞌa. Lexe itema vile noxixe ꞌo ilee semameni miai, la anu susu ane vaikalasou utelo noxixe. Ia ano ꞌo ne uasi, anu susu ane muxali no nano ꞌo ne, vaikalasou utelo ane noxinesi.” ");
INSERT INTO ata_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Xe iliꞌi la sou anu Avimeleki ne molu muavuti sou muvikala pekiaꞌu sou mupeletotosiꞌa ta mitema noxou mukalusi. Muvikalaneꞌi aloxo ꞌo, “Lexe itema vile uꞌoxo susu vile noxou itema ano ꞌo ilee semau, la tavaꞌu itema ane ne mo usoli.” ");
INSERT INTO ata_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisaki muxoxoo ne xe iliꞌi la sou muxaxai sou mutounu laꞌilali seꞌi muluꞌe no lia no xai ane anu muxaisou ne. No tauu ie ane ne, laꞌilali no xai ane ne, temanu piena misevile, xo IAUE mualusou anu Aisaki. ");
INSERT INTO ata_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Aisaki muxali loxo itema tila vile maninasou lavuluti tavuꞌalo mo lavulutiu muꞌokiꞌoki tani manina. ");
INSERT INTO ata_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Anu itema vile toxoxaꞌa manina. Ta sipsipou iloꞌa ta kau mo ta mitemau sou ixaxaixu ne tavuꞌalo misevile, la sou ta Pilistia oponeꞌi masuau. ");
INSERT INTO ata_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Xe miavuti la lexa taxataxasou e ta mitema sou xaixai noxou momu Avalaamu miꞌasou mine anu Avalaamu uxoxoolu ne, misovosovolou mukalusi no anu lialia. ");
INSERT INTO ata_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Xe Avimeleki muavuti la muvikalanu Aisaki aloxo ꞌo, “Eni emasaxa lexe nini naxoo no lia ꞌo la uasi. Naxexesou tualasixe ꞌo mo nalai naxoo vaꞌaxu, xo nexi tamomomo noxine la uasi. Nini xavineni misevile.” ");
INSERT INTO ata_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Aisaki mulomu aloxo ne mukalu, la mulutu sou mulai. Mulai xoo la muꞌilii tualasou alavua no vanunu ne Xelalu ne sou mutulusou taasou ane. ");
INSERT INTO ata_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tatei la Avalaamu muxoxoolu ane, mo muꞌasou lexa iou sou miie no anu, ia iliꞌi no anu soli noxou la ta Pilistia misovolou lexa taxataxasou ne mukalusi. Ia Aisaki mulutu xe mulai muxolu ane, la anu muꞌasou lexa taxataxasou ne la. Muꞌasou mukalu la mumoxoꞌu ualaualasiꞌa aloxo momu mumoxoꞌu no anu tei. ");
INSERT INTO ata_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Alaxu vile la ta mitema sou xaixai noxou Aisaki miꞌasou lexa iou vile no vanunu e aneꞌi milai mixolu no anu ne. ");
INSERT INTO ata_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Xe ta mitema sou isaxisaxilaꞌa ta kau ne Xelalu ne miavuti la iloꞌa ta mitema sou isaxisaxilaꞌa ta kau noxou Aisaki miꞌotosou lexa iou ane ne. Ta mitema sou isaxisaxilaꞌa ta kau ne Xelalu miavuti la mivikala lexe, “Lexa iou ane ne, nexi naꞌanexi.” Xe iliꞌi la sou Aisaki mumoxoꞌu lexa iou ane ne lexe, “ꞌOtosou”. ");
INSERT INTO ata_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ioxe, ta mitema sou xaixai noxou Aisaki miavuti la miꞌasou xaꞌa lexa iou vile la. Xe iliꞌi la ꞌotoꞌoto muxali no anu la. La sou Aisaki mumoxoꞌu lexa iou ane ne lexe, “Ulua”. ");
INSERT INTO ata_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Xe Aisaki muavuti la musukusou xalee lia ane ta mitema sou xaixai noxou miꞌasou lexa iou no anu ne, ia musuku mulai no xalee vile sou muꞌasou lexa iou vile alavua la. Xe mumalei la ta mitema iꞌotosou uasi, la mumoxoꞌu lexa iou ane ne lexe, “Xoluxolu laixesi”, xo anu muvikala aloxo ꞌo, “Vaimomo ꞌo IAUE mulosinge tuala laixe sou taxolu laixesi no anu, mo ulai iliꞌi la nenge mimii tavuꞌalo ne anu molu ulosinge no anu xoluxolu noxinge no anu lia xalee ano ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Xe iliꞌi la anu Aisaki mutelai ne Beru-seva. ");
INSERT INTO ata_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Xe no ꞌolovoxo la IAUE mupalaꞌa noxou la muvikalanu aloxo ꞌo, “Eni Lataua noxou mamine Avalaamu. Naꞌume mamu, xo eni axoo noxine, mo aalusine mo sou ta ꞌiliꞌiline mo ta xasixasine iloꞌa ta ꞌiluꞌilusuneni ixali tavuꞌalo xo eni emasaxau itema sou xaixai noxilo Avalaamu misevile.” ");
INSERT INTO ata_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisaki muavuti la muvalovalo no anu lavoꞌo sou mutauuxu navu sou muꞌelaxaꞌa ta sipsip sou mulinga no anu IAUE ualasou noxou IAUE. Xe muavuti la muꞌilii tuala sou mutulusou taasou no xalee lia ane ne. Xe ta mitema sou xaixai noxou miavuti la miꞌasou lexa iou vile kalumo a no xalee lia ane ne. ");
INSERT INTO ata_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","No voxo vile la Avimeleki molu no tuala ne Xelalu sou mulai mumaisou Aisaki, la eiae Ausate e anu itema vile sou ulolosou Avimeleki xavuxavutala mo Pikolu anu itema vile toxoxaꞌa sou uuli noxiꞌa ta mitema sou ꞌotoꞌoto noxou Avimeleki ne ilou mimulinu sou milai noxou Aisaki. ");
INSERT INTO ata_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Iloꞌa mimuamuaꞌi xe milai mixali noxou Aisaki la mutaliꞌisiꞌa aloxo ꞌo, “Tatei la ngelavixo la ngekusailo la exexeesou liangenge, ia loxovaa la ngingi ane a nganeꞌe ngaxali noxilo ꞌo la?” ");
INSERT INTO ata_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Xe aneꞌi tatalu ne miavuti la mikolinu taliꞌiiou aloxo ꞌo, “Vaimomo ꞌo nexi telavu lexe IAUE anu a uxoo noxine. La sou nexi temasaxa lexe nenge nengeꞌa tasakii xavutala vile no nixi noxinge nengeꞌa. ");
INSERT INTO ata_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Xavutala ane nenge nengeꞌa tasakiinu ꞌo aloxo ꞌo, Mamu nini naꞌoxo masua uneꞌe noxixe xo nexi taꞌoxo masua noxinge uasi. Nexi teꞌoxo laixesi mulai noxingesi. Mo no voxo ane nini neꞌumesou lianexe, la nexi iexi muvaxainesi mole nelai opoone lelemesousi, ia laꞌiaxene uasi. La sou nexi temaisou lexe IAUE musuꞌulineni laixe misevile.” ");
INSERT INTO ata_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Xe Aisaki muavuti la muꞌoxoxaꞌa laꞌilali toxoxaꞌa sou miꞌou xe miie. ");
INSERT INTO ata_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Iloꞌa miai xe miꞌemo la iloꞌa mixalixu masaxa vile toxoxaꞌa lexe usoko ane vaimomo mo ulai utalo iliꞌi ne aneꞌi iloꞌa xoluxoluxaꞌa vilesisi. Misakii xavutala ane ne mukalu, la Aisaki musaxaneꞌi sou milai, ia oponeꞌi muai seꞌisisi. ");
INSERT INTO ata_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","No anu voxo ane nesi la ta mitema sou xaixai noxou anu Aisaki ne mineꞌe mixali noxou la mivikalanu aloxo ꞌo, “Nexi teꞌasou lexa iou vile la lexa muxali mutelo no anu.” ");
INSERT INTO ata_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Xe Aisaki muavuti la mumoxoꞌu lexa iou ane ne lexe, “Seva (tavuꞌalo)”. La sou musoko no voxo ane ne mole muneꞌe vaimomo ꞌo ne, aneꞌi mimoxoꞌu tuala ane ne lexe Beru-seva. ");
INSERT INTO ata_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ioxe, Esau tauu iexu mulai muxali loxo itemaxu tamei (40), la muꞌuluxe eiae Iudi, Beri ꞌolu sema. Beri anu itemasie Keti. Xe muavuti la muꞌuluxe Basemati, eiae Eloni ꞌolu. Eloni kalumo anu itemasie Keti. ");
INSERT INTO ata_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aisaki ilee Liveka ixoxolu xe ieꞌi uvavaxaiꞌa ta sema tamei ne la, taneꞌi navuxuiꞌa misevile. ");
INSERT INTO ata_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisaki mumaulixu tauu ie piena misevile mole anu aululu manina. Iou ne isivoxo mole umamalei la ua. No voxo vile, la anu muꞌavalou ꞌolu laposalaxu Esau muneꞌe noxou la muvikalanu aloxo ꞌo, “Esau, ꞌalixeni. Nini ꞌava?” La Esau mukolinu la muvikala lexe, “O! Eni a axoxoolu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Xe momu muavuti la muvikala aloxo ꞌo, “ꞌAlixeni, eni a amitema tila mukalu, mole eni alavusou voxo ane sou eni asoli no anu uasi. ");
INSERT INTO ata_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","La sou eni emasaxaine lexe nanoꞌu pasikomeni ilou tavimeni mo nalai napaipaa mo navau xenixo miposi. ");
INSERT INTO ata_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Xe naxali la naxutulalaꞌu ukalu la naxutuxu xenixo laꞌilali tuꞌaxu lailaixe loxo nexutuxu eꞌou. Laꞌilalixo ne uxutu ukalu la nanoꞌu uneꞌe noxilo. Eni aꞌou ukalu xe iliꞌi la sou eni aalusine kaluxusou ka sou eni asoli.” ");
INSERT INTO ata_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","No voxo ane Aisaki upepelaꞌu ꞌolu Esau aloxo ne la Liveka a ilolomu. Xe Esau mulutu la mulai mupaipaa. ");
INSERT INTO ata_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Xe ane Liveka milomu aloxo ne xe milutu la milai mivikalanu ꞌilie Iakovo aloxo ꞌo, “ꞌAlixeni, nalomu. Alalae se ꞌo elomusou mamine upepelaꞌu ꞌolu Esau aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Nalai napaipaa mo navau xenixo miposi mo naxutuxu xenixo laꞌilali tuꞌaxu lailaixe loxo nexutuxu eꞌou. Xe aꞌou ukalu la sou eni aalusine kaluxu no talaxu IAUE ka sou eni asoli.’ ");
INSERT INTO ata_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ꞌAlixeni, nalomu noxilo. Mii maꞌia ane avikalanenixu lexe naꞌoxo alalae ꞌo, la namulinu vaikalaxenisi mo naꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nalai no kalesiꞌa ta mee ꞌole mo nanoꞌa tamei ta lailaixe ane uao ileleme utetelo o mo ineꞌe axaumusiꞌa, xe axutuxuxou mamine laꞌilalixu e umasaxau utotomu, ");
INSERT INTO ata_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","la sou nanoꞌu ilou ulai noxou sou uꞌou, la sou anu ualusine xe iliꞌi la sou anu usoli.” ");
INSERT INTO ata_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ia Iakovo soxu ne muavuti la muvikalane nenu aloxo ꞌo, “Atie, nini nelavu lexe Esau ne anu vasimolu laxulaxusou, ia eni ꞌo ne, vasimelo muvelisi. ");
INSERT INTO ata_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Loxo ꞌo io anu uvavaꞌou vasimelo xe ukasilo, la anu ulavusi lexe enisi ane aꞌoxo loloxu ne, la uꞌoxo masualeli io ualusilo ua.” ");
INSERT INTO ata_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Xe nenu miavuti la mikolinu vaikala aloxo ꞌo, “Mii masua maꞌia ne uneꞌe utelo ane noxilo eni anenine ꞌo, ia nalaisi mo naꞌoxo mii e elemolu noxine.” ");
INSERT INTO ata_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Anu mulomuxu vaikalaie nenusi mole mulai munoꞌa ta mee loxo nenu mimasaxaiꞌa la muneꞌeneꞌi noxie sou miꞌoxo xou momu laꞌilali tuꞌaxu lailaixe loxo anu mumasaxau. ");
INSERT INTO ata_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Liveka mixutuxu laꞌilali ne mukalu, la milai minoꞌu Esau tokolomou lailaixe e muai no taasiꞌa ne sou mitoxuꞌu ꞌilie Iakovo no anu. ");
INSERT INTO ata_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Xe minoꞌu mee sosou, ia laxulaxusou ka misakisakii muvaxa no avolu xe no xolanu xo tokolomou vimou e mutaa ne, utaluxu xolanu uasi. ");
INSERT INTO ata_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Xe miavuti la misulu veleti muvaxa noxou sou munoꞌu ilou laꞌilali tuꞌaxu lailaixe mulai noxou momu. ");
INSERT INTO ata_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mumuamuaꞌi xe mulai muxali noxou momu la muvikala aloxo ꞌo, “Mamilo o!” “Maꞌia?” Momu mutaliꞌi mulivu mulai noxou aloxo ne. Xe momu muavuti la muvikala aloxo ꞌo, “Ngingi ta ꞌaliꞌalixe ne tamei, ia ꞌenaꞌei noxinge ngongou ane uneꞌe uꞌavalilo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Xe anu Iakovo muavuti la mukolinu momu aloxo ꞌo, “Eni Esau, ꞌiline laposalaxu. Natulu mo natalupexa mo naꞌou laꞌilalixene enoꞌu muneꞌe noxine ꞌo. Xe ukalu la sou naalusilo.” ");
INSERT INTO ata_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Xe Aisaki muavuti la mutaliꞌisou, “ꞌAlixeni, nepalea loxovaa?” Iakovo mukolinu la muvikalanu momu lexe, “Lataua IAUE noxine musuꞌulileli la sou eni exalisou palea.” ");
INSERT INTO ata_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Xe Aisaki muavuti la muvikala lexe, “ꞌAlixeni, nasuku uneꞌe ꞌalai mo sou eni akasine mo axamulinu vasimene. Loxovaa nini Esau manina?” ");
INSERT INTO ata_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Iakovo muavuti la musuku mulai ꞌalai noxou momu sou mukasou sou muxamulinu vasimolu. Xe muavuti la muvikalanu ꞌolu aloxo ꞌo, “Xolineni loxo Iakovo xolinu, ia avone maumautunu ꞌo examulinu la laxulaxusou loxo noxou Esau.” ");
INSERT INTO ata_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Muvikala aloxo ne, ia utongonu uasi xo vasimolu ne laxulaxusou loxo Esau. Xe muavuti, la lexe ualusou la ua, ");
INSERT INTO ata_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","muavuti la mutaliꞌisou la, “Loxovaa, nini Esau manina?” La anu mukolinu lexe, “Ani, eni manina.” ");
INSERT INTO ata_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Xe Aisaki muavuti la muvikalanu ꞌolu aloxo ꞌo, “Ioxe, nanoꞌu laꞌilali seꞌi e nexutuxu ne uneꞌe mo aꞌou. Xe ukalu la sou aalusine.” Iakovo muavuti la munoꞌu laꞌilali ne mulai noxou momu sou muꞌou. Munoꞌu xou uaini lumamo sou muiemolu kalumo. ");
INSERT INTO ata_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Xe iliꞌi la sou Aisaki muvikalanu ꞌolu aloxo ꞌo, “ꞌAlixeni, nasuku uneꞌe ꞌalai noxilo mo naꞌaulaxo mo natimunu xaleleli.” ");
INSERT INTO ata_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Iakovo muavuti la musuku mulai ꞌalai manina noxou momu paꞌumolu sou muꞌaulaxu xe mutimunu momu xalenu, la momu mutumaꞌu tokolomou la tumaꞌu lailaixe misevile, la sou mualusou. Muvikala aloxo ꞌo, “ꞌAlixeni tokolomou ilou vasimolu ꞌo tumatumaꞌu lailaixe loxo xai vile IAUE mualusou. ");
INSERT INTO ata_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Laixe Lataua molu ulosine ta oto kuiꞌa sou usilisou liaxene mo sou liaxene ne utuxu piena la laꞌilalixene uleme laixe. Anu molusi uitixene laꞌilali ilou uaini piena. ");
INSERT INTO ata_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ta mitema no xalexalee tuatuala ukalusi ne ixali loxo ta mitema sou xaixai noxinesi. Mo ta mitema sou xalexalee tuatuala neꞌeineꞌei ne ixolu no lia no laaxenesi. Ta viivine ne ixolu no laaxenesi. Nini menesi nasaxilaꞌa. Aneꞌi kisiꞌa ane nini. Mo nenine ta xasixasie iloꞌa ta ꞌilusulusune aneꞌi kalumo ne aloxo ne. Ulai xe ta mitema imasaxa lexe ilingau Lataua sou ulosine tuꞌumaxu sou uꞌoxo masuaneni, la anu mii ane ne ulivuiꞌa la. Xe aneꞌi ane imasaxa lexe Lataua uꞌoxo laixe noxinesi mo ualusine, la anu Lataua kalumo uꞌoxo laixe noxiꞌasi mo ualusiꞌa kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Xe Aisaki mualusou Iakovo mukalu mo mulaa mulai, io iliꞌi se la, la Esau e mulai mupaipaa xou momu ꞌole mulivu muxali. ");
INSERT INTO ata_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Anu kalumo muxutuxu xou momu laꞌilali tuꞌaxu lailaixe mo anu a uneneꞌe noxou. Muꞌunalai noxou momu la muvikalanu aloxo ꞌo, “Mamilo, natulu mo natalupexa mo naꞌou laꞌilalixene o seꞌi. Enoꞌu muneꞌe sou lexe naꞌou ukalu la sou naalusilo.” ");
INSERT INTO ata_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Xe momu muavuti la mutaliꞌi, “Nini ꞌenaꞌei ne?” “Ua, eni Esau e ꞌiline laposalaxu o.”, anu Esau mukolinu taliꞌiiou momu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Xe Aisaki mulomu aloxo ne la mukuluke, la vasimolu muꞌoloꞌolo. Xe muavuti la mutaliꞌi, “Ia ꞌenaꞌei e muvau miposi mo munoꞌu laꞌilali muneꞌe enoꞌu ꞌo? Nini naxali uao ia eni eꞌou laꞌilali ne, mo alu kaluxusou ane elosou ne. Alu ane ne, uxolu noxou aloxo ne xo anu naꞌu mukalu.” ");
INSERT INTO ata_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Xe Esau mulomu aloxo ne la laꞌiaxu misevile. La sou mutaloxu iii mii e toxoxaꞌa loxo ꞌo, sou mutama. Xe muavuti la muvikala tamatama mulai noxou momu aloxo ꞌo, “Naalusilo kalumo, eni kalumo naalusilo, mamilo soxu!” ");
INSERT INTO ata_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Momu muavuti la muvikalanu aloxo ꞌo, “Vivine ane muneꞌe mukalavoileli o. Mo alu lexe eni aalusine no anu ane munoꞌu ne.” ");
INSERT INTO ata_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Xe Esau muavuti la muvikala aloxo ꞌo, “Mukalavoileli alaxu vile ka tameisou ano ꞌo la. Uala ane Iakovo ne, laaxu mumomomo noxou manina. Eni ꞌo ne, eni laposalaxu, ia anu muneꞌe mukalavoileli la munoꞌu uala laposalaxu ne mulai noxou. Ka uneꞌe uꞌumenu alusilo ꞌo la. Ia loxovaa, alu sevile la sou naalusilo no anu la uasi?” ");
INSERT INTO ata_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Xe momu muavuti la muvikalanu aloxo ꞌo, “Eni emuxaxu lexe anu uxali loxo tila noxine ne, mo ta minuminu ne ulai iliꞌi la ixolu loxo ta mitema sou upalupalusiꞌa noxou. Mo evikalanu lexe ulai iliꞌi la laꞌilalixu tavuꞌalo misevile, mo uaini kalumo. Ia ꞌalixeni, eni mii vile la sou alosine la uasi.” ");
INSERT INTO ata_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Xe Esau muavuti la mulingau momu la, “Mamilo, lexe alu noxine vile a uxoo noxine o, la naalusilo no anu. Naalusilo kalumo.” Aliko soxu ꞌo mutaloxu iii sou mutama alaxu vile la noxou momu. ");
INSERT INTO ata_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Xe momu muavuti la muvikalanu aloxo ꞌo, “Ulai iliꞌi la liaxene ne, lia laixe uasi. Natounu laꞌilalixene la uleme laixe uasi. Mo ta oto kuiꞌa umomomo sou usilisou xaixene uasi. ");
INSERT INTO ata_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Visomeni uulaxuneni no anu voxo ane lexe nini naꞌoto sou nakamulinuxene laꞌilali. Vivine ne anu tila noxine. Nini naxoo no laaxu sou anu upalupalusine sou naꞌoxoꞌoxo mixumixu. Ia ulai iliꞌi la nini laꞌiaxene, la anu umomomo sou usaxilaꞌine la ua.” ");
INSERT INTO ata_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ia Esau ne laꞌiaxu mo tanu masuau Iakovo misevile, xo momu mualusou laixe, ia anu uasi. Xe muxoxoolu la xavutalau ukakamuli voteꞌi sou uvau vimou. Xe muavuti la muvikala aloxo ꞌo, “ꞌAlaꞌalai sou mamilo asou usoli. Usoli ukalu mo taꞌasixu xe iliꞌi la sou eni avau vivilo Iakovo ne.” ");
INSERT INTO ata_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Xe Liveka neniꞌa ilou milomu aloxo ne la mikalaa anaxeu ꞌilie Iakovo sou muneꞌe noxie. Muneꞌe muxali la ane mivikalanu aloxo ꞌo, “Nalomu, vivine Esau laꞌiaxu mo umasaxa lexe uvene nasoli. ");
INSERT INTO ata_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nalomu mo naꞌoxo aloxo eni alemolu noxine o. Nalutu ane alalae ꞌosi mo naꞌume ulai noxou iameni Lavani, eni vivilo, anu a uxoxoolu ne Alani. ");
INSERT INTO ata_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nalai naxoo noxou ne mo lexe vivine tanu lelemesou ");
INSERT INTO ata_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","mo lexe iou siꞌisou mii e neꞌoxo noxou, la sou eni apalusou vile sou ulai unoꞌine uneꞌeneni. Xo eni amasaxa lexe ngingi ta ꞌalixe tamei ꞌo mamu ngakalu no voxo vilesisi.” ");
INSERT INTO ata_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Alaxu vile la Liveka mivikalanu mulue Aisaki aloxo ꞌo, “Eni amamaisiꞌa Esau ta semasemau tamei ꞌo la opoleli laixuiꞌa uasi, mo etotosa noxiꞌa. Male lexe Iakovo kalumo uꞌuluxe sema vile noxiꞌa ta Keti la, la male eni ne asolisi.” ");
INSERT INTO ata_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Xe Aisaki muavuti la muꞌavalou ꞌolu Iakovo mulai noxou sou mualusou la muvikalanu pekiaꞌu aloxo ꞌo, “Mamu naꞌuluxe semasie Kanani vile. ");
INSERT INTO ata_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nalai ne Mesopotamia no tuala noxou xasine mo sou naꞌuluxe sema vile lai ne, iameni Lavani ꞌolu. ");
INSERT INTO ata_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Lataua anu xaviinu misevile, molu uxolu noxine mo molu ualusou taulaꞌixene mo molu ulosine ta ꞌiline tavuꞌalo mo sou ulai iliꞌi la ta mitema tavuꞌalo no xalexalee tuautala neꞌeineꞌei ne mamiꞌa ane nini. ");
INSERT INTO ata_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anu molusi ualusinge ngongiꞌa ta ꞌiliꞌiline mo ta xasixasine iloꞌa ta ꞌiluꞌilusuneni aloxo anu mualusou Avalaamu. La sou ulai iliꞌi la nini natatananu lia ane nini nexoo no anu ꞌo. Lia ano ꞌo Lataua muꞌitalonu noxou Avalaamu.” ");
INSERT INTO ata_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisaki muvikalanu ꞌolu Iakovo aloxo ne mukalu la mupalusou sou mulai ne Mesopotamia noxou Lavani. Lavani momu ane Betueli. Anu itemasie Alamu. ꞌOlu sema ane Liveka, eiae Iakovo ilou Esau neniꞌa. ");
INSERT INTO ata_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","No voxo ane Esau mulomu lexe momu Aisaki mualusou vimou Iakovo mo mupalusou mulai ne Mesopotamia sou ulai uꞌuluxe sema vile lai ne, la anu mulavu kalumo lexe no voxo ane anu Aisaki mulingau Lataua sou uxoo noxou Iakovo, la anu mupelaꞌu lexe mamu ulai iliꞌi la uꞌuluxe sema vile ne Kanani. ");
INSERT INTO ata_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","La mulavu kalumo lexe vimou Iakovo mulomuxu vaikala noxiꞌa momu ilee nenu la sou ane anu mulai ne Mesopotamia ne. ");
INSERT INTO ata_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tavaꞌu aloxo ne la sou anu Esau mulavu lexe momu Aisaki umasaxaiꞌa ta semasie Kanani uasi. ");
INSERT INTO ata_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ioxe, anu soxu muavuti la mulutu mulai noxou Isimaeli e Avalaamu ꞌolu iloꞌa ta ꞌolu. Mulai muxolu ane la sou muꞌuluxe sema vile la. Ualasie lexe Makaleti, Isimaeli ꞌolu. Vimoe mulu ualasou lexe Nevaiote. ");
INSERT INTO ata_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iakovo mulutu ne Beru-seva sou mulai ne Alani, ");
INSERT INTO ata_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","la mumuamuaꞌi xoo mole anu asou ꞌoloꞌolovoxo. Mumuamuaꞌi mulai xe aso mulolo, la muxali no lia xalee vile, la mutalupexa sou muai ane. Muavuti la munoꞌu lavoꞌo vile sou mutixalaxu. ");
INSERT INTO ata_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","No ꞌolovoxo, la muaipiepiena lexe mumaisou teetelo vile mutulu no lia la mulai muxali avile teitexi no loxotolo, mo ta angelo noxou Lataua iluluꞌe itetelo no anu. ");
INSERT INTO ata_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Xe iou muvaxa la mumaisou Lataua muneꞌe mutulu no paꞌumolu. Xe muavuti la muvikala aloxo ꞌo, “Eni IAUE, Lataua noxou Avalaamu ilou Aisaki. Ulai iliꞌi la eni alosinge ngongiꞌa ta ꞌiliꞌiline mo ta xasixasine iloꞌa ta ꞌiluꞌilusuneni lia ane nini naai no latanu ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ta ꞌiliꞌiline iloꞌa ta xaisxasine mo ta ꞌiluꞌilusuneni ne itiitisiꞌa uxali tavuꞌalo loxo lialia no lia ꞌo. Xe ulai iliꞌi, la sou aneꞌi isukusukunu pilipilixasou lialiaxaꞌa ꞌo ulai umomoxu atume iou tamiꞌa o sou ilai ixolu no anu. Eni aalusiꞌa ta mitema no xalexalee tuatuala ukalusi no anu voteꞌi vilesisi. Voteꞌi ane ne, nini ta ꞌiliꞌiline mo ta xasixasine iloꞌa ta ꞌiluꞌilusuneni. ");
INSERT INTO ata_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mo nalomu la, eni axolu noxine mo asaxilaꞌine no anu muamuaꞌixene no xalexalee tuatuala ane nini nalai no anu. Xe iliꞌi, la alivulixene uneꞌe no lia ꞌo. Umomomo sou eni aꞌumesine uasi, axoo noxine mo sou mimii e eni elemolu lexe eni aꞌoxo noxine ne uxali maninasou.” ");
INSERT INTO ata_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Aliku ꞌo mukuluke xe mutulu la mutalupexa xe tanu tema, la sou muvikala aloxo ꞌo, “Manina, IAUE a uxoo no lia xalee se ane eni eai mo ane axoxoo no anu ꞌo, ia eni alavusou uasi.” ");
INSERT INTO ata_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Mumamaꞌu misevile, la sou muavuti la muvikala aloxo ꞌo, “Eni emamaꞌu misevile xo tuala ano ꞌo, iou vilemo. Anu Lataua taasou ano ꞌo, mo aitengasou ane mukisi mulai teitexi no opo loxotolo e emaisou ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Muai ne xe mutulu no kakau no sivo, la munoꞌu lavoꞌo e mutixalaxu no ꞌolovoxo sou mulaanu muluꞌelai no lia, loxo atola sou sosovo. Mutulusou mukalu la munixiꞌu ovu vile lexaxu no latanu sou musosovosou tani ano ꞌo lexe Lataua naꞌu. ");
INSERT INTO ata_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Xe iliꞌi, la sou mumoxoꞌu lia xalee ane lavoꞌo kisou mutulu no anu ne lexe Veteli. Tei la ilemolu tuala xalee ane ne lexe Lusu. ");
INSERT INTO ata_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Xe Iakovo muavuti la mupalaꞌalixu tanu mulai noxou Lataua, la muvikala aloxo ꞌo, “Lexe nini naxoo noxilo mo nasaxilaꞌilo no anu muamuaꞌi noxilo ano ꞌo, mo naitixo laꞌilali ilou tokolomo ");
INSERT INTO ata_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","mo lexe eni alivu mo alai axali noxou mamilo taasou, la sou nini Lataua noxilo manina. ");
INSERT INTO ata_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Lavoꞌo kisou e eꞌasixu ne, anu sosovo lexe nini taasine ane. Xe ulai iliꞌi la mimii maꞌimaꞌi ane nini nalosilo mo naitixo ne, eni akalipalaꞌanu la nini naꞌa nini paꞌusou sevile loxo vile no anu mavulovexa ane eni alosine ulivu ulai noxine.” ");
INSERT INTO ata_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iakovo muvikala aloxo ne sou mupalaꞌalixu tanu mulai noxou Lataua mukalu, la sou anu muavuti sou musokou muamuaꞌi noxou sou ulai. Mumuamuaꞌi ne, la mulalai aloxo no xalee lia ane aso uxaxali utetelo no anu. ");
INSERT INTO ata_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mumuamuaꞌi mulalaisi xe musuꞌa iou loxo ꞌosi la mumaisiꞌa ta sipsip laꞌoluxaꞌa tatalu ane misuꞌa laꞌoluxaꞌa miai mixaliliiou iou lexa vile. Ta sipsip ne, mineꞌeneꞌi sou iieneꞌi ane, ia mineꞌeneꞌi la iieneꞌi palea uasi xo lavoꞌo toxoxaꞌa te ipipalopaloꞌu sou uxexesou taxa e lexa uxaxali utelo no anu ne uao. ");
INSERT INTO ata_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ta mitema sou isaxisaxilaꞌa kalumo a ixoxoomaieꞌi. No voxo ane sou ta mitema sou isaxisaxilaꞌa ta sipsipiꞌa ineꞌe sou iieneꞌi, la aneꞌi ipipaloꞌu lavoꞌo to ne uxexesou lexa iou sou ta sipsipiꞌa iie. Xe ukalu la sou aneꞌi ipipaloꞌu ulivu no tanixu la. ");
INSERT INTO ata_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iakovo mumuamuaꞌi musuku mulai ꞌalai manina noxiꞌa sou mutaliꞌisiꞌa aloxo ꞌo, “Ta vivilo, ngingi sou tuala neꞌei?” Aneꞌi mikolinu la mivikala lexe, “Nexi sou tuala ne Alani.” ");
INSERT INTO ata_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Xe anu muxiu vaxa la mutaliꞌisiꞌa la, “Ia ngingi ngelavusou itema e ualasou lexe Lavani o? Eiae Naola ꞌolu.” “Ani, nexi telavusou.” Aneꞌi mikolinu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Xe muavuti la mutaliꞌisiꞌa la aloxo ꞌo, “Ia loxovaa, anu laixenusi?” “Ani, anu laixenusi. Namalei, ꞌolu sema Lakeli ane ineneꞌeneꞌi ta sipsip noxou ꞌole.” Aneꞌi mikolinu aloxo ne la. ");
INSERT INTO ata_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Xe anu muavuti la muvikalaneꞌi aloxo ꞌo, “Aso a uao teitexi ꞌo mo umomomo sou ngingi ngalivulixaꞌa ta sipsip ilai no nano no taasiꞌa palea uasi, ia nganavaa e ngaieneꞌi palea mo sou ukalu la ngalailixaꞌa sou iꞌani iaꞌeiaꞌe ua o?” ");
INSERT INTO ata_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Xe aneꞌi miavuti la mivikalanu lamana aloxo ꞌo, “Nexi talavusou taꞌoxo loxo ne uasi. Nexi taxoomaieꞌi ta menexixe mo lexe aneꞌi ixalixaꞌa ta sipsipiꞌa no lexa iou ꞌo ukalusi, la sou nexi tapipaloꞌu lavoꞌo uxexesou lexa ꞌo taxanu, la sou ta sipsipmexi ꞌo ne, iluꞌe sou iie alaxu vilesisi.” ");
INSERT INTO ata_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Anu Iakovo iloꞌa aneꞌi ane miuli mineꞌe no lexa iou ne, ivivikala ia Lakeli ane mipasipaa mo mineꞌe mixalixaꞌa mamie ta naꞌu ta sipsip no lexa iou ne. Xo ane ilavusou isaxisaxilaꞌa ta sipsip noxou mamie. ");
INSERT INTO ata_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Xe aliku ꞌo iou muvaxa loxo ꞌo la iau ꞌolu ane mineꞌeneꞌi ta sipsipou ꞌo, xe muavuti la molu mulai sou mupipaloꞌu lavoꞌo muxexesou lexa iou sou muieneꞌi. ");
INSERT INTO ata_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Xe muavuti la mutimunu xalene tei ꞌo sou muvikala “aso laixe” mulai noxie mo mutaloxu tama xo anu muꞌosasie. ");
INSERT INTO ata_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Xe iliꞌi la sou muvikalane lamana, “Eni vivilo tavuna ane nini ꞌo, iaxe ane mamine Lavani ne, xo mamine vimou sema e ualasie lexe Liveka, ane eni atie.” Xe sema ꞌo miavuti no lia ꞌo la ane miiave milai noxou mamie sou miaꞌalou. ");
INSERT INTO ata_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lavani mulomu lexe iau ane muneꞌe muxali ꞌo xe, muavuti la muiave mulai mualaxu sou muꞌosasou. Muavuti vaxa la muꞌaulaxu ka mutimunu xale. Xe mukasi vaxa no avolu la munoꞌu muꞌunalailixu no taasou. Xe iliꞌi, la sou anu muvikalanu iau lamana noxiꞌa momu ilee nenu mo vimou, xe muaꞌalouxu mimii ane muxali noxou no anu muamuaꞌi noxou. ");
INSERT INTO ata_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Xe Lavani mulomu noxou iau aloxo ne xe mukalu, la muvikala aloxo ꞌo, “Manina musuku, nini ne noxilo manina. Nenge nengei ienge lavoꞌo vilesisi.” La sou Iakovo muxoo noxou iau ne, soꞌio vile. ");
INSERT INTO ata_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Xe no voxo vile, la Lavani muvikalanu Iakovo, “Nini naxoxoo noxilo ꞌo sou nasuꞌusuꞌulilelixu mixomixo vitanisi loxo ꞌo uasi. Loxo ꞌo io nini xavutalameni uexe lexe, eni alotoneni uasi o xo, nini noxilosi. Uasi, eni emasaxa lexe alotonenixu xaixai e nini nasuꞌusuꞌulilelixu ꞌo. Nemasaxa lexe alotoneni no anu taꞌei?” ");
INSERT INTO ata_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","No tauu ie ane Iakovo mulai muxoo noxou iau ne la iau ta ꞌolu ta sema tamei ne, aneꞌi ta vuanga. Ane laposalaxu ne, ualasie lexe Lea, xe ane no talie Lea ne ualasie lexe Lakeli. ");
INSERT INTO ata_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea ne, iei laixe malaxo uasi, ia Lakeli nesi, iei laixe misevile. ");
INSERT INTO ata_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Xe Iakovo muavuti la mukolinu taliꞌi noxou iau Lavani aloxo ꞌo, “Eni emasaxa lexe axoo noxine ꞌo tauu ie muxatele tamei mo axaxaixene, lexe nini nemasaxa lexe eni aꞌuluxe Lakeli.” ");
INSERT INTO ata_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Iau Lavani muavuti la muvikalanu aloxo ꞌo, “Anu mii vile uasi, eni aꞌitalone noxine sou naꞌuluxe, xo ꞌenaꞌei ane uxoxoo noxilo ꞌo sou uxaxaixo la sou eni aꞌitalone noxou sou uꞌuluxe?” ");
INSERT INTO ata_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Anu muxolu xe muxaxaixu iau tauu ie muxatele tamei sou uꞌuluxe Lakeli ne. Tanu muꞌoxoxe la tauu ie muxatele tamei ne loxo, voxo moso tatalusi no xavutalau. ");
INSERT INTO ata_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Muxolu sou muxaxaixu iau ne, xe tauu ie muxatele tamei mulai mukalu, xe mulutu la mulai muxali noxou iau, la muvikala aloxo ꞌo, “Nanoꞌe ꞌiline ineꞌe mo aꞌuluxe, xo tauu ie eni elemolu lexe eni axoo sou axaxaixene no anu ane mukalu ne.” ");
INSERT INTO ata_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Xe Lavani muavuti la muꞌoxonu laꞌilali sou iau ilee ꞌolu Lakeli taulaꞌixaꞌa. Mukala anaxu mulai noxiꞌa ta mitema no nano no tuala ne, sou mineꞌe no anu laꞌilali ane ne mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Xe no ꞌolovoxo la Lavani unoꞌe Lakeli ilai noxou iau loxo mulemolu tei ꞌole ua, mukasivaxa noxie vimoe tila Lea mole mulailixe noxou sou ilou miai no ꞌolovoxo ne. ");
INSERT INTO ata_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lavani munoꞌe sema vile noxiꞌa ta sema e ixoxoo noxou sou upalupalusiꞌa sou iꞌoxoꞌoxo mixumixu ne sou ie ꞌolu Lea. Sema ne ualasie lexe Silipa. ");
INSERT INTO ata_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Miai xe mitulu no kakalu xe, Iakovo iou muvaxa loxo ꞌo, la ano ꞌo Lea mo ane ilou miai ꞌo. Xe aliku ꞌo muavuti la mulai muxali noxou iau la muvikalanu aloxo ꞌo, “Loxovaa ane nini neꞌoxo ꞌilixo ano ꞌo muneꞌe noxilo loxo ꞌo? Eni exaxaixene ꞌo sou lexe eni anoꞌe Lakeli, ia loxovaa la, nini neꞌoxo loloxo loxo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Xe iau muavuti la muvikalanu lamana aloxo ꞌo, “Lai noxixe ꞌo, nexi talavusou tavaitaulaꞌineꞌi ta ꞌilixe ta sema ane mipaa no taliꞌa ta laposalaxu tei uasi. Ta laposalaxu ane nexi tavaitaulaꞌineꞌi tei. ");
INSERT INTO ata_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ia naxolu ꞌo mo voxo sou taulaꞌi ano ulai usivita no anu voxo muxatele tameisou ꞌo ka sou eni anoꞌe Lakeli ilai noxine, lexe nini namasaxa lexe naxolu tauu ie muxatele tamei la sou naxaxaixo. Xo eni masaxa noxilo aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Xe Iakovo muavuti la muvikalanu iau lexe, “Anu mii vile uasi.” Xe voxo sou taulaꞌi ane miꞌoxo tei ꞌole mulai musivita, la sou Lavani munoꞌe ꞌolu Lakeli sou mulailixe noxou iau Iakovo sou muꞌuluxe. ");
INSERT INTO ata_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ka munoꞌe Vila mulailixe noxie ꞌolu Lakeli ne sou ipalupalusie sou iꞌoxoꞌoxo mixemixe. ");
INSERT INTO ata_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iakovo munoꞌe Lakeli kalumo sou milai ilou miai. Anu mumasaxaie Lakeli misevile noxie Lea. Xe muavuti la mumulinu masaxa noxou iau sou muxolu tauu ie muxatele tamei la sou muxaxaixu. ");
INSERT INTO ata_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Iakovo iloꞌa ta semasemau tamei ne ixoxoolu, la anu ulai ilee Lea ixoxoo malamalaxo uasi, ia Lakelisi ane ilou itautinaneꞌi misevile. Xe IAUE mumalei la mumaisou aloxo ne, la tanuxe Lea la sou musuꞌuline la ane opoone. Ia Lakeli ne uasi. ");
INSERT INTO ata_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Iloꞌa mixoxoo xe iliꞌi la sou Lea mivoꞌo ꞌilie vile mulu. Xe miavuti la mivikala aloxo ꞌo, “IAUE mulavusou tuꞌumaxu ane muxoo noxilo. Anu manina lexe muluxeni umasaxailo manina.” La sou mimoxoꞌu ualasou lexe Luven. ");
INSERT INTO ata_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Xe iliꞌi la, la Lea opoone la mivoꞌonu ꞌilie mulu vile la. Xe miavuti la mivikala aloxo ꞌo, “IAUE muitixeni keakea mulu ꞌo xo anu mulavusou lexe Iakovo ne umasaxailo malaxo uasi.” La sou mimoxoꞌu ualasou lexe Simeoni. ");
INSERT INTO ata_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Xe iliꞌi la, ane opoone la. La mivoꞌonu ꞌilie vile mulu la. Xe miavuti la mivikala aloxo ꞌo la, “Vaimomo ꞌo eni elavu lexe eni muluxeni maasi la anu masaxa noxou utila uneꞌe noxilo mo uneneꞌe noxilo sou noxiꞌa iloꞌa ta ꞌolu taxoo tapita utotomu, xo eni ane evoꞌoneꞌi ta ꞌolu tatalu ta mulu ꞌo.” La sou ꞌilie ane ne, ane mimoxoꞌu ualasou lexe Levi. ");
INSERT INTO ata_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Xe iliꞌi la, ane opoone la. La mivoꞌonu ꞌilie vile mulu la. Xe miavuti la mivikala aloxo ꞌo, “Vaimomo ꞌo eni aꞌiti IAUE ualasou sou molomolo ano ꞌo la.” La sou ane mimoxoꞌu ualasou lexe Iuda. Io, iliꞌi la ane ivoꞌo la ua. ");
INSERT INTO ata_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Leasi ane ipapalaa loxo ne, ia Lakeli uasi, la opoone masuaie vimoe Lea ne misevile. La sou milutu milai noxou Iakovo la mivikalanu aloxo ꞌo, “Eni emasaxa lexe apalaa ta ꞌalixe kalumo. Xe uasi, la eni emasaxa lexe asolisi.” ");
INSERT INTO ata_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Xe mulue laꞌiaxu la muvikala toxoxaꞌa noxie aloxo ꞌo, “Nalavusou lexe Lataua molusi ane mumasikalaneni uasi? Eni Lataua sou axalixu keakea no oponeni uasi. Anu molusi mumomomo sou uꞌoxonu ane ne.” ");
INSERT INTO ata_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Xe Lakeli miavuti la mivikalanu mulue aloxo ꞌo, “Ioxe, nanoꞌe Vila, sema sou xaixai noxilo ꞌo mo, ilai ngongou ngai la sou ane ivoꞌonuxeni keakea. Keakea e ane ivoꞌonu ne, nenu ane eni ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Mivikalanu mulue aloxo ne, xe iliꞌi la sou milai mivikalane Vila lamana no anu masaxa noxie ane, ane mipalaꞌalixu noxou mulue ne. Xe iliꞌi la sou minoꞌe Vila ne milai noxou Iakovo sou ilou miai loxo semau. Mulai noxie ");
INSERT INTO ata_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","la sou opoone xe iliꞌi la sou mivoꞌonu keakea mulu noxou Iakovo. ");
INSERT INTO ata_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Xe Lakeli miavuti la mivikala aloxo ꞌo, “Lataua mumaisou mo mulavu no anu tuꞌumaxu ane Lea miꞌoxoꞌoxonu muneꞌe noxilo la sou mulomuxu linga noxilo la ane muitixeni keakea mulu ꞌo.” La sou ane mimoxoꞌu ualasou lexe Den. ");
INSERT INTO ata_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Xe iliꞌi la Vila opoone la, la mivoꞌonu keakea vile la. ");
INSERT INTO ata_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Xe Lakeli miavuti la mivikala aloxo ꞌo, “Nexi noxie Lea teꞌotoꞌoto xoo mole, vaimomo ꞌo eni euli.” La sou ane mimoxoꞌu keakea ne ualasou lexe Napitali. ");
INSERT INTO ata_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea mixoxoolu xe milavu lexe ane imomomo sou ipalaa la ua la sou ane miavuti kalumo sou minoꞌe sema sou xaixai noxie ualasie lexe Silipa sou milailixe noxou Iakovo. Silipa milai mixolu noxou Iakovo loxo semau. ");
INSERT INTO ata_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ilou mixoxoolu ne, xe ane mulai noxie xe opoone, la sou mivoꞌonu keakea vile mulu. ");
INSERT INTO ata_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Xe Lea miavuti la mivikala aloxo ꞌo, “Voxo laixe muxali.” La sou ane mimoxoꞌu keakea ne ualasou lexe Xati. ");
INSERT INTO ata_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Iloꞌa mixoxoolu xe iliꞌi la, la Silipa mivoꞌonu ꞌilie tameisou mulu. ");
INSERT INTO ata_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Xe Lea miavuti la miꞌosa misevile la mivikala aloxo ꞌo, “Vaimomo ꞌo, eni ꞌosaꞌila toxoxaꞌa manina uxoo noxilo. Ulai iliꞌi, la ta sema tavuꞌalo ivikala lexe eni asema sou ꞌosaꞌila.” La sou mimoxoꞌu keakea ne ualasou lexe Aselu. ");
INSERT INTO ata_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","No tauu ie ane ne la, uiti muneneꞌa mole Luven, Lea ꞌilie laposalaxu ne, mulai no xai, la iou mulai mutukumusou ovu vile seseenu. Ngiaxu ne sou iꞌoxoxaꞌa ta sema mii no anu. Muavuti la mulai muꞌelesou ngiangiaxu ne sou mulailixu noxie nenu no tuala. Munoꞌu xe muxalixu noxie la nenu kokope Lakeli ne mimaisou, la milai noxie vimoe Lea la mivikalane aloxo ꞌo, “Loxovaa umomomo sou naitixeni seꞌi?” ");
INSERT INTO ata_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Xe Lea miavuti la mivikalane aloxo ꞌo, “Nenoꞌu muluxeni mo a ulai uxoxoo noxine ne ia, nini a neneꞌe ꞌo sou lexe nanoꞌu ꞌalixe miu ꞌo la, ne?” Xe Lakeli miavuti la mikolinu vimoe vaikalaie aloxo ꞌo, “Lexe nini nalosilo mii ne, la eni avikala Iakovo la ngongou ngaai maasi no ꞌolovoxo.” ");
INSERT INTO ata_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mixoxoo xe ꞌoloꞌolovoxo, la Lea mialaxu Iakovo. Milai xe mixalisou mine ulilivu uneꞌe no tuala, la mivikalanu aloxo ꞌo, “Maasi no ꞌolovoxo la naneꞌe sou nengei taai, xo eni elotoneni noxie Lakeli no anu ovuxaꞌa ta sema ngiaxu e Luven ꞌalixe miu ne molu munoꞌu no xai.” Iakovo mulomuxesi mole no ꞌolovoxo la mulai noxie sou ilou miai. ");
INSERT INTO ata_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Xe iliꞌi, la Lea milinga noxou Lataua la anu tanuxe la sou ane opoone. Mixoxoo xe voxo sou ivoꞌo ꞌilie ne muxali, la sou mivoꞌonu ꞌilie mulu taꞌuvesou. ");
INSERT INTO ata_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Xe miavuti la mivikala aloxo ꞌo, “Eni eꞌitalone Silipa sema sou xaixai noxilo milai noxou muluxeni la sou ane Lataua tanuxo la mulosilo keakea soxu e lailaixe ꞌo.” La sou mimoxoꞌu ualasou lexe Isikali. ");
INSERT INTO ata_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Isikali muxoxoo xe tila, la sou nenu ne opoone la, la mivoꞌonu ꞌilie mulu muxatele vile sou la. ");
INSERT INTO ata_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Xe miavuti la mivikala aloxo ꞌo, “Lataua mulosilo mii vile toxoxaꞌa ꞌo la. Iakovo vaimomo ꞌo ne anu uꞌosa misevile mo uꞌiti ualasilo mo utoxoleli xo eni evoꞌoneꞌi ta ꞌolu muxatele vile.” La sou mimoxoꞌu ualasou keakea ne lexe Sevulon. ");
INSERT INTO ata_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Xe Sevulon mulai muxali tila, la Lea opoone la. Mixoxoo xe voxo muxali sou mivoꞌo, la mivoꞌone ꞌilie sema vile. La sou mimoxoꞌu ualasie lexe Tina. ");
INSERT INTO ata_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tauu ie piena mulai mukalu, ia Lakeli ne ipalaa uasi manina. Ia vaimomo ꞌo, Lataua tanuxe la sou mulomuxu linga noxie la sou molu mululusie. Mululusie ne, la anu maxuveni la ua, ane opoone. ");
INSERT INTO ata_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mixoxoo xe voxo muxali sou ivoꞌo no anu, la sou mivoꞌonu ꞌilie vile mulu. Xe aliku ꞌo miavuti la ꞌosaꞌila misevile, la mivikala aloxo ꞌo, “Vaimomo ꞌo, eni aꞌosa xo Lataua tanuxo mo molu mukalusou tuꞌumaxu noxilo, mole eni umomomo sou amaela no anu mii vile la uasi. ");
INSERT INTO ata_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mo eni emasaxa lexe anu molu uitixeni keakea mulu vile la.” Xe miavuti la sou mimoxoꞌu keakea ane, ane mivoꞌonu ne lexe Iosepu. ");
INSERT INTO ata_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Lakeli mivoꞌo Iosepu mukalu, xe iliꞌi la momu Iakovo mulai muxali noxou iau Lavani la muvikalanu aloxo ꞌo, “Eni eneꞌe exoo noxine ꞌo mo exaxaixene piena misevile sou lailotosiꞌa ta sema tamei ꞌo mo ta ꞌiliꞌiliꞌa. Mo nelavusou lexe exaxaixene laixe misevile. Ia vaimomo ꞌo eni emasaxa lexe naꞌitalonexi noxiꞌa ta semasemaxeni iloꞌa ta ꞌiliꞌilixe noxiꞌa mo talivu uali no tualasilo.” ");
INSERT INTO ata_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lavani muavuti la mukolinu vaikalau iau Iakovo aloxo ꞌo, “Laixe no anu vaikalameni, ia loxo nalomu ꞌo mo eni alemolu mii ꞌo. Eni exoxoo la emaisou aloxo ꞌo, IAUE tanuxo la musuꞌulileli xo nini ane neneꞌe nexoo noxilo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ia navikalaleli laixe no anu mii ane nini namasaxau, la sou eni alosine sou nini naxolu la, sou naxaxaixo.” ");
INSERT INTO ata_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Xe Iakovo muavuti la mukolinu aloxo ꞌo, “Nini nelavu no anu xaixai ane eni eneꞌe exolu ꞌo la eꞌoxoꞌoxonu. Mo nini nelavusou kalumo lexe eni esaxilaꞌa ta sipsipmeni lailaixe misevile, mole ane vaimomo aneꞌi mixali tapiena misevile. ");
INSERT INTO ata_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tatei la ta sipsipmeni ne tavuꞌalo uasi, ta taꞌei mososi. Ia musoko no tauu ie ane eni eneꞌe exoo noxine mo muneꞌe mutalo vaimomo ꞌo ne, ta sipsipmeni mipaa tavuꞌalo misevile. Xo IAUE muxolu noxilo sou musuꞌulileli no anu xaixai noxilo la sou anu musuꞌulineni. Ia vaimomo ꞌo eni emasaxa lexe nexi mexi mii seꞌi sou nexi mexe tasaxilaꞌu vaꞌaxu mo.” ");
INSERT INTO ata_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Xe iau muavuti la mutaliꞌisou aloxo ꞌo, “Ia mii maꞌia ane eni alosine?” Xe Iakovo muavuti la mukolinu aloxo ꞌo, “Nalosilo mii vile mamu. Ia lexe naꞌoxo aloxo eni alemolu ꞌo, eni axolu la mo alai aoleneꞌi ta sipsipmeni mo asaxilaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Alai maasi, la ieli uiloiꞌa laixe mo sou asosovosiꞌa laixe. Asosovosiꞌa ta sipsip ta ꞌiliꞌiliꞌa ane ta muximuxi mo ane matomatovineꞌi iloꞌa ta mee ane matomatovineꞌi kalumo. Aneꞌi ane ne eni anoꞌa ukalusi loxo lailotosou xaixai tapiena e eni eneꞌe exoo noxine la eꞌoxoꞌoxonu ane. ");
INSERT INTO ata_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ulai iliꞌi xe nini naneꞌe sou nataxuneꞌi laixe xe namaisiꞌa lexe eni enoꞌa aloxo elemeꞌa noxine ne, la lexe eni evikala manina. Xe naneꞌe xe namaisiꞌa seꞌi vasimeꞌa loxo eni elemeꞌa noxine uasi, la lexe aneꞌi ane ne epakalineꞌi ane.” ");
INSERT INTO ata_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Anu laixesi. Tamulinu aloxo nelemolu ne.” Lavani mukolinu iau Iakovo vaikalau aloxo ne. ");
INSERT INTO ata_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Xe muavuti la no voxo ane nesi ne, mulai munoꞌa ta mee ta mulu xe ta sema latala e ta kea ia matomatovineꞌi iloꞌa ta sipsip ta muximuxi ne sou ta ꞌolu misaxilaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Xe iliꞌi la sou mumulineꞌi ta ꞌolu sou iloꞌa milailixaꞌa ta meeiꞌa iloꞌa ta sipsipiꞌa ne. Mimuamuaꞌilixaꞌa voxo tamei xe tatalu sou la sou mixalixaꞌa no xalee lia ane lexe aneꞌi ilailixaꞌa no anu ne. Ia Iakovo muxolixaꞌa paꞌusiꞌa ne sou musaxilaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iakovo muxoxoolu ne, xe iliꞌi la sou mulai muxoxola ovu iouiou seꞌi avoavolu ka muviliꞌisou ovu avoavo ne sou kalaxaꞌa keakea no nano ꞌole mupalaꞌa, ia usuluki uasi. ");
INSERT INTO ata_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Xe muavuti la mutavulenu ovu avoavolu ne mulai sou mulaalaa no paꞌumolu lexaxaꞌa ne sou lexe aneꞌi ineꞌe sou iie la lexe ovu avoavolu ne a ututulu no talaxaꞌa sou imamaisou. Xe ineꞌe sou iie ");
INSERT INTO ata_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","la ivavailo no paꞌumolu ovu avoavolu e mulaalaa ne, la sou isuluneꞌi ta ꞌiliꞌa la xooxoolaxaꞌa aloxo ne. ");
INSERT INTO ata_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Xe Iakovo muavuti, la munoꞌa ta sipsip iloꞌa ta ꞌiliꞌiliꞌa ane ngolangolaꞌa sou milai mixolu vaꞌaxu, ia ta sipsip iloꞌa ta mee ane ngolangolaꞌa mo ane ta muximuxi ta mulu iloꞌa ta sema noxou Lavani ne mixolu ne sou ane ta mulu ivavaialoneꞌi ane ta sema. Muꞌoxo voteꞌi ane ne, la ta sipsip iloꞌa ta mee ane misuluneꞌi alavua ne anu ta naꞌusi, ia upitaneꞌi iloꞌa ta mee ane noxou Lavani uasi. ");
INSERT INTO ata_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Uxoxoo xe umalei lexe ta sipsip iloꞌa ta mee ane xavineꞌi mo ta lailaixe ialuxaꞌa xe ineꞌe sou iie xe umalei lexe aneꞌi a sou ivaialo, la anu upasipaa ulai unoꞌu ovuovu avoavolu ꞌole sou uneꞌe ulaa no talaxaꞌa sou aneꞌi ivavaialo la imamaisou, ");
INSERT INTO ata_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ia aneꞌi ane ta lailaixe mo xavixavineꞌi uasi ne, anu iou uvaxaꞌiasi. La sou mulai iliꞌi la ta sipsip iloꞌa ta mee ane ta laixe mo xavineꞌi musuku ane anu ta naꞌu. Xe aneꞌi ane xavineꞌi uasi, ane Lavani ta naꞌu. ");
INSERT INTO ata_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Anu muꞌoxo aloxo ne la sou ane, anu muxali itema vile toxoxaꞌa manina. Miumiu piena misevile. Ta sipsipou iloꞌa ta mee mixali tavuꞌalo misevile. Ta mulu iloꞌa ta sema sou upalupalusiꞌa sou iꞌoxoꞌoxo mixumixu ne tavuꞌalo misevile, mo ta kameli iloꞌa ta donki kalumo. ");
INSERT INTO ata_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Iloꞌa mixoxoo ne xe alaxu vile, la Iakovo mulomu lexe iau, Lavani ta ꞌolu ta mulu misuꞌanu vaikala vile. Mivikala aloxo ꞌo, “Iakovo to ne muneꞌe la, iu mimii uasi ia, muneꞌe muxolu noxinge nengeꞌa maminge mole ane mutaxusou maminge miumiu mukalu ꞌo. Mole ane anu muxali itema sou lavuluti vile manina.” ");
INSERT INTO ata_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Mamiꞌa kalumo ne, iau Iakovo umamaisou, la iou laꞌilaꞌiaxu mo uvivikalanu lailaixe loxo tei uasi, muxiu mo loxo iou ututumasi. ");
INSERT INTO ata_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Xe IAUE muavuti la muvikalanu Iakovo aloxo ꞌo, “Naxoxoo ꞌo uasi, nalutu mo nalivu ulai no lialiaxaꞌa mamine iloꞌa ta minemineni xo eni kalumo alai axoo ane sou axoo noxine sou asaxilaꞌine.” ");
INSERT INTO ata_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Xe Iakovo muavuti la mukalanu anaxuiꞌa Lakeli ilee Lea sou milai noxou e uxoxoolu sou usaxisaxilaꞌa ta sipsip iloꞌa ta mee no anu. ");
INSERT INTO ata_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ilou milutu xe milai mixali noxou, la muvikalaneꞌi ilou, “Emaisou maminge ngongou, la maulixu muxiu. Tei, la nengeꞌa taꞌosaꞌosasinge ngatoꞌo mo uvivikalanenge nengeꞌa ne lailaixe loxo ꞌo, ia vaimomo ꞌo ne uasi manina, emaisou iou ne, la iou masuailosi. Ia Lataua noxou mamilo Aisaki ane uxoxoo noxilo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ngingi ngongou ngelavu lexe, eni exaxai misevile xou maminge ngongou, ");
INSERT INTO ata_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ia anu mukalavoileli alaxu mavulovexa la ulotoleli uasi. Muꞌoxo ꞌilixo ane ne noxilo ia umomomo sou uꞌoxo ꞌilixo vile masua uneꞌe noxilo uasi xo Lataua a uxolu noxilo. ");
INSERT INTO ata_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Muvikalaleli lexe ta sipsip iloꞌa ta mee ane tolotoloneꞌi ne eni ta naꞌaxeni. Ioxe, aneꞌi isulu xe tolotoloneꞌi ukalusi, la anu uxiunu la lexe eni ta naꞌaxeni ane misaꞌesaꞌeutu. ");
INSERT INTO ata_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","La sou ane Lataua munoꞌa maminge ngongou ta sipsipou iloꞌa ta meeu la ane muneꞌe muitixeni ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","No tauu ane ta mee ta mulu aneꞌi sou ivaialoneꞌi ta mee ta sema, la eni eaipiepiena lexe emaisiꞌa ta mee ta mulu ane tolotoloneꞌi mo aneꞌi ane misaꞌesaꞌeutusi ane mivaialoneꞌi ta mee ta sema ne. ");
INSERT INTO ata_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Xe angelo noxou Lataua muavuti la muꞌavalilo, ‘Iakovo,’ la eni ekolinu ‘O! Maꞌia?’ ");
INSERT INTO ata_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","La anu musolonu vaikala la, ‘Natulu mo namalei ta mee ta mulu ane tolotoloneꞌi mo ane ngolangolaꞌa mo aneꞌi ane misaꞌesaꞌeutusi ane ivavaialoneꞌi aneꞌi ane ta sema. Eni emaisou ꞌiliꞌilixo e Lavani muꞌoxoꞌoxo noxine ne mukalu, la sou ane eni eꞌoxo voteꞌi ano ꞌo sou usuꞌulineni. ");
INSERT INTO ata_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Eni e avivikalaneni ꞌo, eni Lataua e epalaꞌa noxine ne Veteli, anu lia xalee ane nini nelaa lavoꞌo e netixalaxu ka nenixiu ovu vile lexaxu no latanu sou nepalaꞌalixu taneni muneꞌe noxilo. Ia, alalae ꞌosi ne, nataxusou mimemimeni mo nalivu ulai no liaxene.’” ");
INSERT INTO ata_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Lakeli ilee Lea milolomu noxou muluiꞌa ilou aloxo ne mukalu, la ilou mikolinu, “Nexi umomomo sou tanoꞌumexi mimii seꞌi noxou mamixe miumiu ꞌo uasi. ");
INSERT INTO ata_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Xo anu muꞌoxonexi loxo nexi ta ꞌolu uasi, nexi ta sema sou tuala vaꞌaxu mo a. Munoꞌu ꞌulusixe ne ia musuꞌa mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mimii tavuꞌalo e Lataua muxexe noxou mamixe avolu ne, uneꞌe nexi noxiꞌa ta ꞌiliꞌilixe mii mexi ukalusi. La sou nexi umomomo sou tamulesine uasi. Namuli aloxo Lataua muvikalaneni ne.” ");
INSERT INTO ata_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Xe iliꞌi la sou anu muteloneꞌi ta semasemau iloꞌa ta ꞌiliꞌiliꞌa noxiꞌa ta kameli. ");
INSERT INTO ata_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Anu muteloneꞌi mukalu la muoleneꞌi ta sipsip iloꞌa ta mee sou muulaxuneꞌi sou milai. Lavulavulutiꞌa e munoꞌu ne Mesopotamia ne, mutavulenu kalumo sou mulailixu ne Kanani noxou Aisaki. ");
INSERT INTO ata_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lavani ne ulavu uasi, xo mulai no paxa mo a uxoxotosou ta sipsip laxusiꞌa. Lakeli miavuti la milai mipakalineꞌi ta miiu e mupuineꞌi sou isaxilaꞌu taasou sou minoꞌa milailixaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Itemasie Alamu kena Lavani ne, ꞌei muvikala lamana no anu lailutu ane ne. Iakovo xavutalau lexe, aneꞌi ipasikisi mo ilai. ");
INSERT INTO ata_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Mitaxusou miꞌamiꞌa tavuꞌalo ne mukalu, la mipasikisi mole milai. Mimuamuaꞌi xoo xe, milai la mixisaꞌisou lexa toxoxaꞌa Iupileitisi. Mixisaꞌisou mukalu la sou mimuamuaꞌi milai loxo no laxalaxaꞌilu ne Xileati. ");
INSERT INTO ata_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Iakovo ena milai mo voxo tatalu mupolo, ia iliꞌi la sou ta mitema seꞌi milai mivikalanu Lavani lexe Iakovo ane mupasiki mo muꞌume mulai ne. ");
INSERT INTO ata_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Xe Lavani mulomu aloxo ne, la mutaxusiꞌa ta minuminu seꞌi sou iloꞌa mimulineꞌi. Mimulineꞌi milalai xoo xe, voxoxaꞌa muxatele vile mukalu xe muxatele tamei sou, la sou mixalisiꞌa no laxalaxaꞌilusie Xileati. ");
INSERT INTO ata_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mixali xe ꞌolovoxo la iloꞌa miai. Lavani muai la muaipiepiena lexe Lataua muxali noxou la muvikalanu aloxo ꞌo, “Nelelemulinu Iakovo mo a neneꞌe nexalisou ꞌo, ia mamu nini navikala vile loxo ꞌo noxou uasi!” ");
INSERT INTO ata_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Iakovo ena miuli la milai mixolu ane no laxalaxaꞌilu ne Xileati sou mitulusiꞌa tani, la sou ane Lavani iloꞌa ta minuminu mineꞌe mixalisiꞌa ne. Lavani kalumo muavuti la mutulusou tani vile ane no laxalaxaꞌilu ne, no paꞌumolu Iakovo. ");
INSERT INTO ata_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Xe iliꞌi, la sou Lavani mulai noxou Iakovo la muvikalanu aloxo ꞌo, “Loxovaa ane nini neꞌoxo loloxo la nelaveneꞌi ta ꞌalixe tamei ꞌo iloꞌa ta xasixasilo loxo ta motu ilulutu sou ilai ialivula no tuala vile ꞌo? ");
INSERT INTO ata_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Loxovaa ane nini neꞌoxo loloxo mo nepasikisi ia navikalaleli lamana ua ꞌo? Lexe nini navikala lamana tei noxilo la nenge nengeꞌa taxolu tapita mo taꞌani sevile ka tavalivali kulumiso mo talalaꞌati sou talelexe mo talelei, ka sou nexi tasaxangengi la sou taꞌitalongengi ngalai. ");
INSERT INTO ata_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ano ꞌo ne ua, nini netalumeieꞌi ta xasixasilo iloꞌa ta neeniꞌasi mole neꞌumeneꞌi ꞌo ia, eni asaxaneꞌi laixe mo atimu no xalexaleneꞌi mo aiooneꞌi ka sou iꞌumesilo ilai uasi. Nexovulaulau misevile. ");
INSERT INTO ata_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Eni umomomo sou akalusine ane alalae ꞌo ia, umomomo la uasi xo no ꞌolovoxo la Lataua noxou mamine mumulesilo la muvikalaleli lexe, ‘Neneꞌe nexalisou Iakovo ne ia mamu nini navikala vile loxo ꞌo noxou uasi!’ ");
INSERT INTO ata_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Eni elavu lexe nini taneni mutulu pekiaꞌu lexe naꞌumesilo mo nalivu ulai no tualasine, ia loxovaa la nalutusi mo nalaisi ua ia, nelutu la nepakalineꞌi ta mimii e epuineꞌi sou isaxilaꞌu taasilo?” ");
INSERT INTO ata_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Xe Iakovo muavuti la muvikalanu iau Lavani aloxo ꞌo, “Ua, lexe avikalaneni lamana ia, emamaꞌu xo loxo io maasi xe eni avikalaneni lamana, la nini naꞌapixaꞌa ta ꞌiline ꞌo pekiaꞌu la naꞌumeneꞌi ilivu ilai noxine. ");
INSERT INTO ata_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ia avikalaneni aloxo ꞌo, nakamulineꞌi ta mimii noxine alalae ꞌo, xe naxalisiꞌa no tivaxu vile noxixe ꞌo la anu ane ne usoli ane alalae ꞌosi. Nexi noxiꞌa ta molomolo noxilo iloꞌa ta neeniꞌa mo ta mitema sou xaixai noxilo mo, aneꞌi ane ngongiꞌa ngeneꞌe ꞌo ane, nexi noxiꞌa tatutulu ꞌo ia nini mene naꞌuna no taataasixe ne mo nalulusou tivativanexe ne mo namalei lexe naxalisiꞌa. Lexe naxalisiꞌa la nalaasiꞌa mo nanoꞌa, ia nexi latala ꞌo tatulu mo tautiieni.” Iakovo uvivikala Lavani loxo ne ia, ulavu uasi. Mii ne, semau Lakeli mipakali noxou mamie taasou mo a itatalumeiou ne. ");
INSERT INTO ata_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lavani muavuti la mulai muꞌunalai noxou Iakovo taasou tei sou mukamuli. Mukamuli xe uasi, la musuku mulai noxie Lea no tani. Muꞌunalai mukamuli xe uxalisou mii vile uasi, la mulaa muatu. Xe muavuti la musuku mulai no tani noxiꞌa Silipa ilee Vila, la uasi. Xe musuku la mulai noxie ꞌolu Lakeli no tani. ");
INSERT INTO ata_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","35","Ane moosou e mipakalineꞌi ta miiu mamie ane. Ane miavuti la mitaaneꞌi muꞌuna no anu tixalasou ixolu no anu kameli la ixolusou mo milai mixolusou. Mamie muneꞌe xe muꞌuna no taasie, la ane mipasipaa mivikalanu lamana aloxo ꞌo, “Tila, naꞌuna mo nakamuli, ia nalavixo uasi, xo eni ekulukemelo mo umomomo sou eni atulu sou asukusine uasi.” Mamie muꞌuna la ukakamuli no nano no tivativaxe xoo mole ua, la mulaa. ");
INSERT INTO ata_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iakovo ne laꞌiaxu misevile. Xe muavuti la muasaxau iau Lavani ne sou mutaliꞌi xatixati vaxa noxou. “Ae! Susu maꞌia ane eni eꞌoxonu la sou ane nini nelelemulileli, neneꞌe avone muxaixai mimemimexi mukalu ꞌo? ");
INSERT INTO ata_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ioxe, lexe nexalisou mii vile, la namuxaxu uluꞌe no talanexe nexi latala e tatutulu ꞌo, mo sou ta mitema noxilo ꞌo iloꞌa aneꞌi ane noxine imaisou kalumo, la sou aneꞌi imomosou vaikalasou no nixi noxinge nengei. ");
INSERT INTO ata_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Xo nalomu, eni elai exolu noxine tauu ie mavulovexa tamei, la ta sipsipmeni iloꞌa ta meemeni ne isusulu utotomu lailaixesi ia ixotoxoto uasi. Mo avau sipsipmeni mulu vile mo aꞌou uasi. ");
INSERT INTO ata_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mo no ꞌolovoxo ane, ta mii seꞌi ineꞌe ipakalineꞌi ta sipsipmeni sou iveꞌa iꞌiꞌa, mo ane iveꞌa mo iꞌiꞌa pausiꞌa uai ne, eni anoꞌu mo aneꞌe amaxaꞌu noxine uasi. Eni melo axiu vaxa la, akoli mii e tasiauxu ne la. Xe naavuti la, navikala pekiaꞌu uneꞌe noxilo misevile sou melo akolinu mii ane ta mitema ipakali no aso xe no ꞌolovoxo kalumo. ");
INSERT INTO ata_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Voxo piena musuku aso ulakaisilo xo mole kisilo ne lexe uvala. Xe no ꞌolovoxo la sivo ukasilo mole aolopipi loxo ꞌo. Mo aai laixe uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nengei texolu tepita tauu ie mavulovexa tamei, la eꞌausou ane sou exaxaixene nesi. Exaxaixeni tauu ie mavulovexa vile mo mulelia tamiꞌa xo eni eꞌuluxaꞌa ta ꞌiline ta sema tamei ꞌo. Xe iliꞌi la exolu sou exaxaixene tauu ie muxatele vile sou lexe anoꞌaxeni ta sipsip seꞌi noxine sou lailoto sou xaixai latala ne la ua. Nini nekalakalavoilelisi alaxu mavulovexa vile. ");
INSERT INTO ata_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ia, lexe Lataua noxou mamilo, mo Lataua noxou Avalaamu uxoo noxilo uasi, la male eni alivu vitanisi, ia mii vile sou anoꞌu no avolo uasi. Ia tavaꞌu xo Lataua mumaisou mo mulavusou xaixai tapiena e eni eꞌoxoxene, mo tuꞌutuꞌumaxu ane muxoo noxilo ꞌo, la sou ane anu muxali noxine no ꞌolovoxo sou muvikala pekiaꞌu noxine ne.” ");
INSERT INTO ata_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Xe Lavani muavuti la mukolinu vaikala noxou Iakovo aloxo ꞌo, “Lea ilee Lakeli ne, eni ta ꞌaliꞌalixe ta sema ane. Mo ta ꞌiliꞌiliꞌa ilou ne, eni ta xasixasilo ane, mo ta sipsip iloꞌa ta mee kalumo ne, eni ta miixe ane. Mo namalei, mimii tavuꞌalo ꞌo ne, molu ane noxilosi, ia aꞌoxo mii vile noxiꞌa Lea ilee Lakeli mo ta ꞌiliꞌiliꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Xe anu Lavani molu muavuti la muvikalanu Iakovo la, “Eni emasaxa lexe ane alalae ꞌosi ꞌo, naneꞌe mo nengei tasakiinu vaikala sou opo vilesisi pumuxu sou usakinenge nengeꞌa no anu. Xe iliꞌi la sou nengeꞌa tasuꞌa laꞌoluxu lavoꞌo no lia ꞌo sou loxo sosovomenge. Iliꞌi xe nenge taneꞌe tamaisou, la nenge taxavutalanu vaikala e nenge taxalixu alalae ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Xe Iakovo muavuti no lia ꞌo, la mulai mutavulenu lavoꞌo to vile veveeni ka muneꞌe mulaa loxo atola pumuxu muluꞌelai no lia, ");
INSERT INTO ata_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ka muvikalaneꞌi ta ꞌolu iloꞌa ta mitema noxou sou milai mitavule lavoꞌo seꞌi la, sou mineꞌe mitaꞌolunu vaxa muxaliliou ane anu mulaa tei. Xe mukalu, la sou aneꞌi iloꞌa miꞌani ane no lavoꞌo laꞌoluxu paꞌumolu ne. ");
INSERT INTO ata_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Xe miꞌani mukalu, la Lavani mulemolu lavoꞌo laꞌoluxu ane ne lexe, “Iaxaru Saꞌaduta” no anu vaikala noxou, xe Iakovo kalumo mulemolu lexe Xaleti no anu vaikala noxou. ");
INSERT INTO ata_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Xe Lavani muavuti la muvikalanu Iakovo aloxo ꞌo, “Lavoꞌo laꞌoluxu ano ꞌo, anu uxolu loxo sosovo sou nenge nengei taxavutalanu vaikala ane nenge nengei tasakiinu iliꞌi.” La sou ane aneꞌi mimoxoꞌu lavoꞌo laꞌoluxu ne lexe Xaleti. ");
INSERT INTO ata_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Xe Lavani muavuti la muvikala aloxo ꞌo la, “IAUE molusi umaisinge nengei mine nenge nengei takalipalaꞌa.” La sou lavoꞌo laꞌoluxu ane ne, milemolu kalumo lexe Misipa. ");
INSERT INTO ata_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Xe Lavani muavuti la muvikalanu Iakovo la, “Ia, lexe nini nasaxilaꞌa mo naꞌoxo laixe noxiꞌa ta ꞌalixeni ta sema tamei ꞌo uasi, mo male nalai naꞌuluxaꞌa ta sema seꞌi vaꞌaxu, ia eni alavu uasi ne, ia anu laixe nini naxavutalanu lexe Lataua a umamaisinge nengei. ");
INSERT INTO ata_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lavoꞌo ane eni elaanu mo ane eni esuꞌa laꞌoluxu no tavaꞌu ane, eni elaanu no nixi noxinge nengei ne, ane uxolu ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Uxolu sou nenge tamaisou aso vile, la taxavutalanu vaikala ane nenge nengei tasakiinu. Eni amomomo sou aalasou pilixa ano ꞌo sou avenge mo ngingi umomomo sou ngaalasou sou ngavelo uasi. ");
INSERT INTO ata_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Lataua noxou Avalaamu mo Naolu molusi umaisinge, la sou ulavu no anu ꞌiliꞌilixo noxinge nengei.” Xe no ualasou Lataua anu Lataua noxou Iakovo momu Aisaki, anu Iakovo muavuti la mupalaꞌalixu tanu lexe anu utetelisou mo umulinu vaikala ane ne. ");
INSERT INTO ata_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Xe muavuti la muveꞌa ta sipsip seꞌi sou muꞌelaxaꞌa mulai noxou Lataua teitexi no laxaꞌilu ne. Xe iliꞌi la sou muꞌavaliꞌa ta mitema noxou mineꞌe iloꞌa miꞌani. Miꞌani mukalu, la miai ꞌolovoxo vile la, teitexi no laxaꞌilu ne. ");
INSERT INTO ata_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Xe no kakau manina, la sou Lavani mulai noxiꞌa ta ꞌolu tamei ne iloꞌa ta ꞌiliꞌiliꞌa sou mutimutimunu xalexaleneꞌi ka mualusiꞌa io sou muꞌitaloneꞌi ia anu mulivu mulai no tualasou. ");
INSERT INTO ata_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Lavani mulutu sou mulivu mulai, la Iakovo kalumo mulutu sou mulai e lexe anu ulilivu ulai no anu. Mumuamuaꞌi xe mulai la ta angelo noxou Lataua mixalisou. ");
INSERT INTO ata_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Xe Iakovo mumaisiꞌa la muvikala aloxo ꞌo, “Tuala ano ꞌo noxou Lataua.” La sou anu mumoxoꞌu lia xalee ane ne, lexe Maanaimu. ");
INSERT INTO ata_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Xe Iakovo muavuti la mupalusiꞌa ta mitema seꞌi sou milai noxou vimou Esau no tuala vile ilemolu lexe ne Seiru no xalee lia ne Edomu. ");
INSERT INTO ata_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Milutu sou milai, la anu mulosiꞌa vaivaikala aloxo ꞌo, “Ngalai xe ngaxali noxou Esau itema tila noxilo la ngavikalanu lexe eni Iakovo, elai exolu maxuvee misevile noxou Lavani, mo ane muneꞌe mutalo vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ngavikalanu kalumo lexe eni alivu uneneꞌe ꞌo eni aneneꞌe vitanisi uasi, eni ta mitema mo ta sema sou xaixai noxilo a noxiꞌa taneneꞌe ꞌo. Mo ta kauxeni iloꞌa ta mee mo ta donki mo ta sipsip kalumo. Eni ekalanu anaxo uneꞌe noxine nini tatila noxilo lexe eni aneꞌe axali noxine la nini opoone laixeilosi.” ");
INSERT INTO ata_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Xe ta mitema ane anu Iakovo mupalusiꞌa ne milai xe milivu mixali, la mivikalanu aloxo ꞌo, “Nexi telailixu vaikalameni noxou vivine Esau, la muvikalanexi lexe anu uneꞌe sou ualaxene no voteꞌi. Iloꞌa ta mitema itemaxu mavulovexa tamei (400).” ");
INSERT INTO ata_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Iakovo mulomu aloxo ne la mumamaꞌu misevile la tanu kalaua mo xavutalau ne laixe uasi. Xe muavuti la mukalipalaꞌaneꞌi ta mitema noxou sou xaixai iloꞌa ta sipsip mo ta mee mo ta kau mo ta kameli iloꞌa ta donki laꞌoluxaꞌa tamei. ");
INSERT INTO ata_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ka muvikala aloxo ꞌo, “Lexe Esau uneꞌe xe umasaxa lexe uxalixu ꞌotoꞌoto vile, la anu iloꞌa ta mitema noxilo laꞌoluxaꞌa ano ꞌo iꞌoto ia, aneꞌi laꞌoluxaꞌa ano ꞌo iꞌume.” ");
INSERT INTO ata_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Xe muavuti la mukilaka aloxo ꞌo, “Lataua noxou Avalaamu, eni xasilo mo nini Lataua noxou Aisaki, eni mamilo, nalomusou linga noxilo. IAUE, nini nevikalaleli lexe eni alivu ulai noxiꞌa ta milemileli no tualasilo ne, la nini naalusilo sou eni axali itema sou lavuluti. ");
INSERT INTO ata_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Lataua eni amitema sou xaixai noxine. Ia eni amitema vile laixe uasi. Ia nini tanenixo la neꞌoxo laixe noxilosi. No voxo ane eni exisaꞌisie lexa Ioridani sou elai exoo noxou Lavani ne, la anoꞌu mii vile no avolo sou elai ne uasi. Vilaxoxosi ꞌa ane eni enonoꞌu sou evilaxoxu. Ia ane ꞌo ne, eni ane alivu uneꞌe ꞌo noxiꞌa ta mitema xuxulusiꞌa tamei ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Eni alingaine lexe nini nasuꞌulileli mo sou mamu vivilo Esau uneꞌe ualivulanexi. Eni amamaꞌu misevile xo loxo io anu uneꞌe usokou ꞌotoꞌoto vile, la uvexevexe ukalusi, la uveꞌa ta sema iloꞌa ta ꞌiliꞌiliꞌa ꞌo kalumo. ");
INSERT INTO ata_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nexavutalanu vaikala e nini mene nevikalalelixu. Nevikala lexe nini naxoo noxilo mo naalusilo sou eni ta xasixasilo iloꞌa ta ꞌilusulusuleli ixali tavuꞌalo iliꞌi loxo ioꞌiioꞌi no tasiꞌi, ia evile umomomo sou uitisiꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ꞌOlovoxo la Iakovo ena miai xe loxo neꞌiela, la anu Iakovo musosovosiꞌa ta kau iloꞌa ta mee mo ta sipsip mo ta kameli mo ta donki seꞌi sou iu vimou Esau. ");
INSERT INTO ata_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Itiitisiꞌa ta mimii ne aloxo ꞌo ta mee ta sema ne munoꞌa itemaxu mavulovexa vile (200). Xe ta mulu, la munoꞌa itemaxu vile. Ta sipsip ta sema la munoꞌa itemaxu mavulovexa vile (200) xe ta mulu la munoꞌa itemaxu vile (20). ");
INSERT INTO ata_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Xe ta kameli ane misulu mo ta ꞌiliꞌiliꞌa a no tavaꞌa ne, munoꞌa mavulovexa tatalu (30). Xe ta kau la munoꞌa mavulovexa tamiꞌa (40) ane sema, xe ta mulu mavulovexa. Ta donki la munoꞌa ta sema itemaxu vile (20) xe ta mulu mavulovexa (10). ");
INSERT INTO ata_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Xe muavuti la musosovosiꞌa ta mitema sou xaixai noxou sou vilevilesi isaxilaꞌa ta mee iloꞌa ta sipsip mo ta kameli mo ta kau iloꞌa ta donki e anu Iakovo musosovosiꞌa sou lexe uitiu vimou Esau. Muꞌitaloneꞌi ta mitema vilevile sou isaxilaꞌa ta mimii laꞌoluxaꞌa vilevilesi ne mukalu la muvikalaneꞌi aloxo ꞌo, “Maasi xe nengeꞌa talutu sou talai, la ngingi ngauli, ia ngasaxilaꞌa Esau ta miu ne mo sou mamu imuaꞌi ipita. Ngamuxaxu taitaiinu. Nini ane nasaxilaꞌu laꞌoluxaꞌa vile, la nauli, ioxe anu ane unoꞌa noxou sou umulineni, la umuxaxu taiinu o ka sou uiliꞌi no tumaline. Ngaꞌoxo aloxo ne, la ulai utalo noxou ane sou uiliꞌi.” ");
INSERT INTO ata_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Xe muavuti la mulosiꞌa vaikala tamei sou. Muvikalanu itema sou xaixai noxou ane sou uulaxuneꞌi aloxo ꞌo, “Nauli xe eni vivilo Esau uala xe uneꞌe uxalisine xe utaliꞌi lexe, ‘Nini namitema sou xaixai noxou eneꞌei? Ia nalalai neꞌei ꞌo? Ta mimii te naooleneꞌi ne ꞌenaꞌei ta miu?’ ");
INSERT INTO ata_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ioxe nini naavuti la navikalanu lexe, ‘Ta mii ꞌo, itema sou xaixai noxine Iakovo anu musovaneꞌi mineꞌe noxine nini tila noxou lexe nini ta miimeni. Anu muitimeni vitanisi. Ia anu Iakovo a uiliꞌi sio.’” ");
INSERT INTO ata_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Musuku muneꞌe noxou itema sou xaixai noxou tamei sou mo tatalu sou la mulosiꞌa vaikala vilesisi aloxo ne. Mo aneꞌi ane tavuꞌalo mo mulai upee noxou ane iliꞌi ne, vaikala vilesisi anesi, ane anu muvikalaneꞌixu sou ikolinu taliꞌi noxou vimou Esau. ");
INSERT INTO ata_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Xe muavuti la muvikalaneꞌi la, “Vaikala vilesi anesi, lexe uxalisine xe utaliꞌi aloxo ne la, ngakoli vilesisi aloxo ne. Ngaxavutalanu sou ngavikalanu lexe, ‘Ani, itema sou xaixai noxine a uiliꞌi sio.’” Xe muavuti la muvikala lexe, “Male no anu xavutala ano ꞌosi la sou eni axolixoli no anu, la sou anu uxiunu tumalouxu ꞌilixo masua e eni eꞌoxo noxou la sou anu laꞌiaxuilo no anu.” ");
INSERT INTO ata_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Xe muavuti la musova iu vimou mimii muuli mulai noxou ia anu muxolu sou muai ꞌolovoxo vile la. ");
INSERT INTO ata_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","No ꞌolovoxo la Iakovo muavuti la munoꞌa ta semasemau tamei ne iloꞌa ta sema sou xaixai noxou tamei mo ta ꞌolu mulelia vile (11) milai mixisaꞌisou lexa Iavoku. ");
INSERT INTO ata_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mulailixaꞌa no lexa no xalee vile xe mukalu, la mulivu muneꞌe sou uvikalaneꞌi ta mitema sou xaixai noxou sou itavulenu miumiu ulai no xalee lexa noxiꞌa aneꞌi ane miuli ꞌole, ");
INSERT INTO ata_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ia anusisi muxoxoo ne, xe no ꞌolovoxo la itema vile muneꞌe muxali noxou sou ilou miꞌoto. Ilou miꞌoto xoo mole lamana mukea. ");
INSERT INTO ata_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Xe itema ne muxamuli loxo ꞌo la anu a xavixavinu ua, xe muavuti la muꞌotunu Iakovo tangaꞌu no avolu la tangaꞌu muxatele. ");
INSERT INTO ata_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Xe itema ne muavuti la muvikalanu Iakovo aloxo ꞌo, “Naxexeenu avone mo eni alai xo anu asou lamana ukea.” Iakovo muavuti la muvikalanu aloxo ꞌo, “Eni umomomo sou eni axexeenu avolo uasi. Lexe nini naalusilo ꞌo, la sou eni axexee avolo.” ");
INSERT INTO ata_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Xe anu itema ne, muavuti la mutaliꞌisou Iakovo aloxo ꞌo, “Ualasine loxovaa?” Xe Iakovo muavuti la mukolinu lexe, “Eni ualasilo lexe Iakovo.” ");
INSERT INTO ata_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Xe anu itema ne muavuti la muvikalanu Iakovo, “Tavaꞌu xo ngingi ngongou Lataua ngeꞌoto mo ngongiꞌa ta mitema kalumo la nini netaloxolixaꞌa, la ualasine lexe Iakovo ne usuꞌa, ia ualasine lexe Isilaeli.” ");
INSERT INTO ata_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iakovo muxiu vaxa la mutaliꞌisou itema ne lexe, “Nini ualasine ꞌenaꞌei? Nalemolu noxilo.” La anu itema ne, mukolinu lexe, “Tavaꞌu loxovaa la nini nemasaxa lexe nalavusou ualasilo?” Xe muavuti la mualusou Iakovo. ");
INSERT INTO ata_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Xe Iakovo muavuti la muvikala lexe, “Vaimomo ꞌo eni emaisou Lataua iou, ia eni asoli uasi.” La sou mumoxoꞌu lia xalee se ane ne, lexe Penuelu. ");
INSERT INTO ata_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Aso muxali mutelo, la Iakovo mulutu sou musukusou lia xalee ne sou mulukeluke mulai xo tangaꞌu mupee. ");
INSERT INTO ata_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","La sou musoko ane tatei ne mole ane muneꞌe mutalo vaimomo ꞌo ne, Iakovo ta ꞌoluꞌolu iloꞌa ta xasoxasou mo ta ꞌilusulusunu ne iꞌou mii xiasinu no texesou ꞌo uasi xo itema e aneꞌi ilou miꞌoto, la muꞌotunu ane no tangaꞌu ne. ");
INSERT INTO ata_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Xe Iakovo muavuti la mulutu sou mulai muxisaꞌisou lexa Iavoku sou mumulineꞌi ta semasemau iloꞌa ta ꞌoluꞌolu mo ta mitema sou xaixai noxou sou iloꞌa misolonu muamuaꞌi noxiꞌa ulai ne Kanani. Iloꞌa mimuamuaꞌi xoo xe, anu Iakovo musuꞌa iou loxo ꞌo, la vimou Esau ane iloꞌa ta mitema sou ꞌotoꞌoto noxou itemaxu mavulovexa tamei (400) imumuamuaꞌi ineneꞌe. Ia uao no paxa sio. Xe aliku ꞌo muavuti la mupalusiꞌa ta ꞌoluꞌolu milailai noxiꞌa ta neneniꞌa sou mitulu no tavatavaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Lea ta naꞌe milai noxie, xe Lakeli noxie milai xe ta sema sou xaixai noxou tamei ne, ta noxiꞌa milai noxiꞌa ilou kalumo. Xe muavuti la muvikalaneꞌi ta sema sou xaixai noxou iloꞌa ta ꞌiliꞌiliꞌa sou miulaxuneꞌi. Ka Lea iloꞌa ta ꞌiliꞌilie. Ka Lakeli ilou ꞌilie Iosepu sou miiliꞌi no tumaliꞌa. ");
INSERT INTO ata_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ioxe, anu Iakovo mumomomo sou muamuaꞌixaꞌa aloxo ne, mukalu io sou anu mulai sou muulaxuneꞌi sou iloꞌa milai. Iloꞌa milalai xoo xe, aneꞌi asou iloꞌa ixali alaalai, la Iakovo muxolaꞌu tavaꞌu sou mutulu no tavaꞌu voꞌuxu sou mutangatulu muluꞌelai sou mutaxanu vimou. Anu muꞌoxonu aloxo ne alaxu muxatele tamei xoo mole mulai muxali ꞌalai noxou vimou. ");
INSERT INTO ata_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Xe vimou muiave muneꞌe la muaꞌulaxu ka mutimunu xalenu, la sou ilou mitama. ");
INSERT INTO ata_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Xe Esau musuꞌanu iou la mumaisiꞌa ta sema iloꞌa ta ꞌiliꞌiliꞌa, la mutaliꞌisou Iakovo aloxo ꞌo, “Ia taꞌei ngongiꞌa ngakekei ꞌo?” Xe Iakovo muavuti la mukolinu vimou lexe, “Ta molomolo ane ne Lataua tanuxo musuku la sou muitixeni eni amitema sou xaixai noxine.” ");
INSERT INTO ata_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Xe ta sema sou xaixai noxou tamei ne iloꞌa ta ꞌiliꞌiliꞌa miavuti la mimuamuaꞌi mulai no talaxu Esau sou mitangatulu muluꞌelai sou mitaxanu. ");
INSERT INTO ata_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ka Lea iloꞌa ta ꞌilie, ka Lakeli ilou ꞌilie Iosepu. ");
INSERT INTO ata_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Xe Esau muavuti la muvikalanu vimou lexe, “Eni exalisiꞌa aneꞌi e nepalusiꞌa sou miuli no voteꞌi. Ia nepalusiꞌa sou miulilixaꞌa ta mimii ne mineꞌe noxilo sou maꞌia?” Xe anu Iakovo muavuti la mukolinu vimou lexe, “Tatila, a eni eꞌoxo loxo ne sou lexe nini opoone laixeilosi.” ");
INSERT INTO ata_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Xe Esau muavuti la mukolinu vaikalau vimou aloxo ꞌo, “Vivilo, eni mixemixe tavuꞌalo misevile. Ta miimeni ne, anu laixe lexe nalivulixaꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ia Iakovo ne pekiaꞌu misevile. Muavuti la mukolinu vimou vaikalau lexe, “Lexe nini oponeni laixeilo mo lexe nemasaxailo manina, la nini oponeni usexelasi mo nanoꞌa ta mimii e eni eitimeni ne. Xo eni emaisine la loxo eni emaisou Lataua iou, tavaꞌu xo nini opoone laixeilosi mo nemasaxailo manina. ");
INSERT INTO ata_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","La sou ane vaimomo ꞌo eni emasaxa lexe ta mimii e eni eitimeni ne namulesiꞌa mamu nanoꞌasi, xo eni Lataua tanuxo misevile la muitixeni mii piena misevile.” Anu Iakovo kapiaꞌu aloxo ne, la sou vimou Esau ne, opoonu musexela sou munoꞌasi. ");
INSERT INTO ata_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Xe iliꞌi la, la Esau muvikalanu vimou aloxo ꞌo, “Alalae ꞌo eni emasaxa lexe nenge taꞌiti mo tatavuevule mimii mo nengeꞌa talai, eni aulaxunenge nengeꞌa.” ");
INSERT INTO ata_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ia Iakovo muavuti la muvikala lexe, “Tatila, nini nelavu lexe ta molomolo ꞌo ne xavineꞌi sou ipalepalea uasi. Mo ta sipsip iloꞌa ta kau mo ta mee ta ꞌiliꞌiliꞌa e uao iꞌoꞌou susu ꞌosi. Xo Maasi xe nenge taiavelixaꞌa no voxo vilesisi ꞌo sou talai taxali no tuala ane alalae oosi ꞌo, la aneꞌi isoisoli ukalusi xo xavineꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","La sou tatila noxilo, eni emasaxa lexe nini naulaxuleli mo nauli, ia eni ailiꞌi seꞌisisi sou apalalaxaꞌa. Xe iliꞌi la sou eni alai axalisine ne Edomu.” ");
INSERT INTO ata_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Xe Esau muavuti la muvikalanu vimou Iakovo ne aloxo ꞌo la, “Ioxe, la eni asosovosiꞌa ta mitema noxilo ꞌo seꞌi sou ngongiꞌa ngaxolu ꞌo sou inoꞌinge ineꞌengengi.” Ia Iakovo muavuti la mukolinu vimou vaikalau lexe, “Itema tila, nini oponeni laixeilo misevile, ia mii vile uasi, ta mitema sou xaixai noxilo meꞌa ipalalanexe la sou ixalinexe.” ");
INSERT INTO ata_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Xe Esau muavuti la no voxo ane anu muneꞌe muxalisou vimou sou ilou mivikala ne la mulivu sou mulai ne Edomu. ");
INSERT INTO ata_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Xe Iakovo muavuti la mulai loxo ne Sukoti. Mulai xe muxali la mutulusou taasou xe taasiꞌa ta mee iloꞌa ta sipsip mo ta kau mo ta kameli mo ta donki. La sou aneꞌi milemolu tuala se ne lexe Sukoti. ");
INSERT INTO ata_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","No tauu ie ane anu Iakovo muꞌumesou tuala ne Mesopotamia sou mulivu mulai no liaxu ne Kanani, la mii vile masua uxalisou uasi. Anu mulai ne Sikemu sou muꞌilii tualasou ane. ");
INSERT INTO ata_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Xe iliꞌi la sou, ulotonu lia xalee ane ne noxiꞌa Sikemu iloꞌa ta vimovimou aneꞌi ta mitemasie Amolu. Lia ne, mulotonu no anu lamoli siliva alelaxu itemaxu taꞌuve (100). ");
INSERT INTO ata_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Xe iliꞌi la, la sou mutulusou valovalo sou uꞌelaxu ta mii no anu ulai noxou Lataua kalumo lai ne no tualasou alavua ne. La mumoxoꞌu tani ne lexe “Elu, Lataua noxiꞌa ta Isilaeli.” ");
INSERT INTO ata_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","No voxo vile la eiae Tina e, Iakovo ilee semau Lea ꞌiliꞌa, milai mixixaoxao sou mimaisiꞌa ta sema no tuala tila ne Sikemu. ");
INSERT INTO ata_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Amolu anu itema vile tila no anu mata Ivi, anu tatananu tani no xalee lia ne Kanani ne, ꞌolu mulu ualasou lexe Sikemu. Mumaisie Tina la mulapune sou mulai noxie. ");
INSERT INTO ata_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mulai noxie mukalu la muꞌunanu tanu noxie mo sou lexe ane imasaxau. ");
INSERT INTO ata_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Xe iliꞌi la sou mulai muvikalanu momu lexe, “Mamilo, eni emasaxa lexe nanoꞌe sema ꞌo ineꞌe mo aꞌuluxe!” ");
INSERT INTO ata_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Xe Iakovo mulomu lexe ꞌolu Tina ane Sikemu muꞌoxonu ꞌilixo masua noxie ne, la uvikala vile uasi xo ta ꞌolu ta mulu ane mikei milai sou milailixaꞌa ta sipsip sou iieneꞌi xe iꞌani iaꞌeiaꞌe. Muxoomaieꞌi mo lexe ixali la sou uvikalaneꞌi. ");
INSERT INTO ata_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Amolu, Sikemu momu muavuti la mulutu mulai noxou Iakovo sou ilou mivivikalasou masaxa noxou ꞌolu. ");
INSERT INTO ata_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","No voxo ane Amolu muneꞌe sou ilou Iakovo mivivikala ne, la anu Iakovo ta ꞌolu milivu mixali. Mixali xe milomusou aꞌalosie vimoꞌa Tina lexe Sikemu mulapune sou mulai noxie, la mitamasie xe laꞌiaxaꞌa misevile, xo ꞌilixo masua ane Sikemu muꞌoxonu noxie Tina ne, anu masua misevile no ieꞌi aneꞌi ta Isilaeli. Itema vile ulai noxie sema aloxo ne, aneꞌi imamaꞌu no anu misevile xo anu susu taxoxaꞌa ane. ");
INSERT INTO ata_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Xe Amolu muavuti la muvikalaneꞌi Iakovo iloꞌa ta ꞌolu aloxo ꞌo, “Eni ꞌalixeni Sikemu ne, tanu mutulu pekiaꞌu noxie Tina ne misevile, la sou ane eni ataliꞌisinge lexe ngamasaxa la iengi uvaxaieisi mo uꞌuluxe. ");
INSERT INTO ata_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Anu laixe lexe nenge nengeꞌa tataulaꞌinenge nengeꞌa ngatoꞌo mo sou xoluxolunenge nengeꞌa laixesi. Ta ꞌilinge ta sema ineꞌe iꞌulunexe, xe nexi ta ꞌilixe ta sema ilai iꞌulungenge. ");
INSERT INTO ata_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ngemasaxa lexe ngaxoo no lia xalee anevaa ne la mii noxingesi. Ngamasaxa lexe ngaꞌoxomengi voteꞌi seꞌi sou mimii seꞌi uxali no anu, sou usuꞌulingengi no anu xoluxolungenge mo ngingi mengesi ngasaxilaꞌu, la anu mii vile uasi.” ");
INSERT INTO ata_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Xe Sikemu muavuti la muvikalaneꞌi Tina mamie iloꞌa ta ꞌolu aloxo ꞌo, “Lexe ngingi opongengi uꞌosasou masaxa noxilo sie Tina, la mii maꞌia ane ngingi ngamasaxau ne, eni alosingesi. ");
INSERT INTO ata_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ia ngasosovosou ꞌulusie mo ngavikalaleli lamana no anu mimii lailaixe ane ngemasaxau lexe eni alosinge. Mimii maꞌi ane ngemasaxau ne, eni alosingesi, ia lexe nganoꞌe Tina ne ineꞌe mo aꞌuluxe.” ");
INSERT INTO ata_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ioxe, tavaꞌu xo Sikemu muꞌoxonu ꞌilixo masua noxie Tina sou mulapune sou mulai noxie, la ta vimovimoe mixalixu xavutala vile sou ikalavoineꞌi Sikemu ilou momu Amolu. ");
INSERT INTO ata_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ta motu miavuti la mivikalaneꞌi Sikemu ilou momu aloxo ꞌo, “Nexi umomomo sou taꞌitalone vivixe sou iꞌuluxu itema vile ane xooxoo ungaasou uao uasi. Xo maasi xe nexi taꞌoxo aloxo ne la, anu mii sou maela toxoxaꞌa noxixe. ");
INSERT INTO ata_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","La sou lexe ngingi ngaꞌoxo mii toxoxaꞌa ꞌo tei, ta mulu sou tualasinge ne lexe xooxoo ungasiꞌa ukalusi aloxo nexi ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Lexe ngingi ngaꞌoxo aloxo nexi telemolu ne, la sou nexi iexi uvaxainge sou ngaꞌuluxaꞌa ta ꞌiliꞌilixe ta sema xe nexi taꞌuluxaꞌa noxinge. La sou nenge nengeꞌa taxolu tapita sou taxali loxo ta mitema sou tuala vilesisi. ");
INSERT INTO ata_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ia lexe ngingi ngamulinu masaxa noxixe aloxo telemolu lamana ꞌo uasi, la nexi tanoꞌe vivixe sema ꞌo mo noxiꞌa talivu.” ");
INSERT INTO ata_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Xe Amolu ilou ꞌolu Sikemu milomusou vaikalaiꞌa Iakovo ta ꞌolu ne la tuꞌumaxu xe mutama laixe misevile no sangaliꞌa ilou, la mimasaxa lexe ilai iꞌoxo aloxo milomusou noxiꞌa Iakovo ta ꞌolu ne. ");
INSERT INTO ata_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikemu ne anu maulu vile e ta maulu ilavusou imasaxau mo itoxonu misevile. Anu momu ta minuminu. Anu mulomusou vaikala ane ne, la umasaxa lexe uvoovoxo la uasi, xo anu tanu uꞌelaie Tina lexe uꞌuluxesi. ");
INSERT INTO ata_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Xe ilou momu milomu aloxo ne, xe miavuti la ilou milai no tilovolovo ꞌalai no aitengaxu vimelu sou tualasiꞌa tila ne sou mivikalaneꞌi ta mulu sou tuala ne. ");
INSERT INTO ata_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Vaikala e mivikalaneꞌixu aloxo ꞌo, “Ta mitema e nexi telai sou noxiꞌa tevivikala ne, ta laixe misevile. Mo mimasaxa lexe ineꞌe nengeꞌa taxolu tapita. Nenge lia nenge toxoxaꞌa misevile. Lexe nenge tamasaxaiꞌa, la aneꞌi ineꞌe mo nengeꞌa taxolu tapita ano ꞌo, mo mii maꞌia ane aneꞌi imasaxa lexe iꞌoxonu ne, aneꞌi iꞌoxonusi, xo nenge lianenge toxoxaꞌa misevile. Lexe aneꞌi ineꞌe nengeꞌa taxolu tapita maninasou ane lai ꞌo, la sou nenge taꞌuluxaꞌa ta ꞌiliꞌa ta sema xe aneꞌi iꞌuluxaꞌa ta noxinge. ");
INSERT INTO ata_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ia masaxa noxiꞌa vilesisi e aneꞌi mitulu pekiaꞌu no anu ane lexe, ta mulu sou tuala tila noxinge ꞌo lexe xooxoo ungaasiꞌa ukalusi aloxo aneꞌi. Lexe nenge taꞌoxo aloxo aneꞌi milemolu ne, la sou aneꞌi oponeꞌi uꞌosa sou nengeꞌa taxolu, ");
INSERT INTO ata_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","la sou male ta sipsipiꞌa iloꞌa ta kau mo miꞌamiꞌa tavuꞌalo ne nenge miimenge kalumo. Ia tamulinu masaxa noxiꞌasi mo sou ineꞌe nengeꞌa taxolu.” ");
INSERT INTO ata_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ta mulu tavuꞌalo mukalusi e milai mipita no aitengaxu vimelu sou tuala paꞌumolu ne, milomu noxiꞌa Amolu ilou ꞌolu Sikemu aloxo ne, la aneꞌi latala ne, mimasaxa lexe iꞌoxo aloxo aneꞌi ilou milemolu noxiꞌa ne. Mole ta mulu sou tuala tila ne xooxoo mungaasiꞌa mukalusi, ia vile paꞌusou uasi. ");
INSERT INTO ata_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ta motu ixoxolixu xalexalevineꞌi voxo vile, mo tamei sou mo tatalu, mo navunavuxaꞌa ꞌole ukalu uao, ia Iakovo ta ꞌolu tamei e, eiae Simeoni ilou Levi, Tina ta vimovimoe, ilou minoꞌu viso ka mitoke mimuamuaꞌi miali no nano no tuala tila ne Sikemu ne, sou mixaliꞌa. Ilou miveꞌaveꞌa ta mulu e ixoxolixu xooxoo anaxu tanixu ne mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Miavuti vaxa la miveꞌa Amolu ilou ꞌolu Sikemu ne kalumo. Xe mitokine vimoꞌa Tina e ixoxoo no tani noxou Sikemu ne sou iloꞌa milai. ");
INSERT INTO ata_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Simeoni ilou Levi miveꞌa ta mulu sou tuala ne Sikemu ne mukalu, xe ta vimovimoꞌa ane iloꞌa mamiꞌa mixolu ꞌole, milutu sou milai miꞌunalai no tuala tila ne sou mipakali mimii. Mimii piena lailaixe ne, mitavule mulai mukalusi. Aneꞌi miꞌoxo loxo ne sou lexe ikolinu ꞌilixo masua e Sikemu muꞌoxo noxie vimoꞌa Tina. ");
INSERT INTO ata_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Xe miavuti vaxa la minoꞌa ta sipsip iloꞌa ta kau mo ta donkiiꞌa ne mukalusi. Mimii iouiou no nano mo no ale no tuala ne minoꞌu mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Mimii iouiou e ꞌulusou toxotoxoxaꞌa ne minoꞌu mukalusi. Ta sema sou tuala tila iloꞌa ta ꞌiliꞌiliꞌa ne minoꞌa mukalusi kalumo. Mo miꞌamiꞌa no taataasiꞌa ne mitaxusou mukalusi sou mitavule mulai. ");
INSERT INTO ata_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Xe Iakovo muavuti la muvikalaneꞌi Simeoni ilou Levi aloxo ꞌo, “Ngingi ngongou ngeꞌoxo ꞌilixo ano ꞌo, la mulosilo tuꞌumaxu toxoxaꞌa misevile. Ta mitema latala e ixoxolu no lia xalee ano ꞌo, loxo ta Kanani mo ta Peresi. Maasi xe ipita sou imasaxa lexe ialivulaleli, la umomomo sou ikalusixe noxiꞌa ta ꞌalixenisi, xo nexi tapiena uasi.” ");
INSERT INTO ata_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Xe aneꞌi ilou miavuti la mikolinu vaikalau mamiꞌa aloxo ꞌo, “Xo maꞌi, nexi noxou iexi uvaxaie vivixe loxo nesi, mole aneꞌi iꞌoxone loxo sema sou voteꞌi loxo ne mole loxovaa?” ");
INSERT INTO ata_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Xe Lataua muavuti la muvikalanu Iakovo aloxo ꞌo, “Nalutu mo navulasou tuala ano ꞌo, ia nalai mo naxolu ne Veteli mo natulusou valovalo sou naꞌelaxaꞌa ta sipsip utelo noxilo. Eni Lataua e epalaꞌa noxine no voxo ane nini neꞌumolu vivine Esau la neneꞌe netatalume.” ");
INSERT INTO ata_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Iakovo mulomu noxou Lataua aloxo ne xe mukalu, la muvikalaneꞌi ta ꞌolu iloꞌa ta semasemaiꞌa mo ta ꞌiliꞌiliꞌa mo aneꞌi ta mitema latala e iloꞌa ikekei ne aloxo ꞌo, “Ngingi latala ꞌo ne maasi la ngaxexeneꞌi ta maliava sou kalavoi noxinge latala ne ukalusi, mo ngaxali malemalenga ukalusi mo ngatokolomo no anu tokolomo alavua ukalusi, ");
INSERT INTO ata_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","xo nenge asou tasuku sou tuala ano ꞌo ia talai ne Veteli sou eni atulusou valovalo sou aꞌelaxaꞌa ta sipsip ilai noxou Lataua no anu. Lataua e musuꞌulileli no anu tuꞌumaxu ane muxali noxilo xe muxolu noxilo sou musaxilaꞌilo no xalexalee tuatuala ane eni emumuamuaꞌi no anu.” ");
INSERT INTO ata_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Xe ta motu miavuti la milai mitavuleneꞌi ta maliavaiꞌa sou milailixaꞌa noxou Iakovo. Mo paxoxo sou sangasangaliꞌa kalumo ne milaxalaxalixu sou milosou sou miꞌasixaꞌa no ovu tavuna tavaꞌu ꞌalai ne Sikemu. ");
INSERT INTO ata_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Xe mukalu la sou aneꞌi Iakovo iloꞌa ta ꞌolu milutu sou milai. Milutu sou milai, la Lataua muxalixu ꞌume toxoxaꞌa noxiꞌa ta mitema ane mixolu no nano no tuala tatatila ꞌalai ne Sikemu, oponeꞌi mole ilelemulineꞌi ua. ");
INSERT INTO ata_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Mimuamuaꞌi xoo, la milai mixali ne Lusu. Vaimomo ꞌo aneꞌi ilemolu tuala ane ne lexe Veteli. Anu tuala ane ne muxolu no xalee lia ne Kanani. ");
INSERT INTO ata_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Milai mixolu ane sou anu mutulusou valovalo sou uꞌelaxaꞌa ta sipsip ane. La sou mulemolu lia xalee ane Veteli ne lexe, “Lataua sou Veteli” Xo Lataua mupalaꞌa noxou no voxo ane anu muꞌumolu vimou Esau la mulai mutalume no anu. ");
INSERT INTO ata_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Milai mixolu ane, la sou Debora sema tila e misusune Liveka no molomoloxe misoli ane. La sou miꞌasixe no ovu tavuna tavaꞌu no xalee mulai iliꞌi ne Veteli. La sou mimoxoꞌu ovu ne lexe, “Ovu Tavuna Sou Tama”. ");
INSERT INTO ata_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","No tauu ie ane Iakovo molu ne Mesopotamia sou mulivu muneꞌe ne Kanani, la Lataua mupalaꞌa noxou la. Xe muavuti la mualusou aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“Ualasine lexe Iakovo, ia usokou ane vaimomo ꞌo mo ulai avile iliꞌi ne, imoxoine lexe Isilaeli.” La sou mumoxoꞌu lexe Isilaeli. ");
INSERT INTO ata_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Xe Lataua muavuti la muvikalanu aloxo ꞌo la, “Eni Lataua, eni xavileli misevile. Eni emasaxa lexe napalaaneꞌi ta ꞌiline tapiena, mo sou nini naxali loxo ta mitema tapiena ꞌilusuneꞌi mo ta tatila sou xalexalee tuatuala kalumo. ");
INSERT INTO ata_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Lia ano ꞌo eni elosiꞌa Avalaamu ilou Aisaki tei, ia vaimomo ꞌo eni aꞌitalonu ulai noxine. Mo ta ꞌiline iloꞌa ta xasixasine mo ta ꞌilusulusuneni ane ipaa iliꞌi ne, eni aitixaꞌa lia ano ꞌo kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Lataua muvivikalanu aloxo ne, xe mukalu la sou mulai. ");
INSERT INTO ata_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Xe Iakovo muavuti la mutulusou lavoꞌo vile veveeni ane ilou Lataua mitutulu mivivikala ne. Xe mukalu la munixiꞌu uaini ilou ovu vile lexaxu teitexi no latanu lavoꞌo ne, sou Lataua miu. ");
INSERT INTO ata_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","La sou xalee lia se ane aneꞌi Lataua ilou Iakovo mitutulu sou mivivikala no anu ne, anu Iakovo mumoxoꞌu lexe Veteli. ");
INSERT INTO ata_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Xe iliꞌi la sou anu Iakovo iloꞌa ta minuminu mivulasou tuala ne Veteli ne sou lexe isuku ulai no tuala tila ne Epurata. Milutu mo a imumuamuaꞌi sou ilalai ne Epurata mo ixali uao, ia voxo sou lavuloꞌo noxie Lakeli sou ivoꞌo muxalisie. No voxo ane ne, ane mixamuli navunavu toxoxaꞌa misevile. ");
INSERT INTO ata_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Xe sema e mineꞌe sou mipaipixone ne, mivikalane aloxo ꞌo, “Taneni kalaua mo naꞌume mamu xo ꞌiline mulu vile la ꞌa.” Sema ne imasaxa lexe ixolixoline Lakeli aloxo ne la ua, ane misuxulaꞌe sou soli. ");
INSERT INTO ata_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Xe misuxulaꞌe kaluxusou ne la, ane mimoxoꞌu ꞌilie keakea ne ualasou. Mimoxoꞌu lexe Beni-Oni. Xe iliꞌi la, la momu mumoxoꞌu ualasou lexe Beniamini. ");
INSERT INTO ata_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Minoꞌe Lakeli milai sou miꞌasixe no voteꞌi paꞌumolu ulai ne Epurata ne. Vaimomo ꞌo ne ilemolu tuala ne Epurata ne lexe Vetiliemu. ");
INSERT INTO ata_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Xe iliꞌi la sou mulue mutulusou lavoꞌo vile veveeni no lousie ne. Mo lavoꞌo ne a uai sio, mo mutalo vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Miꞌasixe Lakeli mo mitulusou lavoꞌo vile veveeni no lousie loxo ne xe mukalu, la misolo muamuaꞌi noxiꞌa mulai sou milai mixali ne Migudalu Ederu. Xe misuku mulai sevile la, la sou milai miꞌilii tuala sou mitulu tani sou mixolu no anu. ");
INSERT INTO ata_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","No tauu ie ane Iakovo muxolu no lia xalee ane ne, la Luven anu Iakovo ꞌolu vile mulai noxie Vila anu Iakovo semau vile. Xe iliꞌi la sou aneꞌi miaꞌalou momu. Ioxe, anu Iakovo ta ꞌolu mavulovexa mulelia tamei. ");
INSERT INTO ata_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ta ꞌolu ane noxie Lea ualaualasiꞌa ano, laposalaxu ane Luven ka Simeoni, ka Levi, ka Iuda, ka Isikali, ka Sevulon. ");
INSERT INTO ata_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Xe ta ꞌolu ane noxie Lakeli ualaualasiꞌa ane, Iosepu ilou Beniamini. ");
INSERT INTO ata_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Xe ta ꞌolu ane noxie Vila, sema sou xaixai noxie Lakeli, ualaualasiꞌa ane Den ilou Napitali. ");
INSERT INTO ata_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Xe ta ꞌolu ane noxie Silipa, sema sou xaixai noxie Lea, ualaualasiꞌa ane Xati ilou Aselu. Aneꞌi Iakovo ta ꞌolu ꞌo ne ta neniꞌa mivoꞌoneꞌi ane ne Mesopotamia. ");
INSERT INTO ata_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Mixoxoolu ne xe Iakovo muavuti la mulai noxou momu Aisaki ne Mamule. Tuala ne Mamule ne ꞌalai ne Ebulon tualasiꞌa Avalaamu ilou ꞌolu Aisaki mixolu no anu tei. ");
INSERT INTO ata_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisaki mumaulixu tauu ie loxo itemaxu taꞌuve mo mavulovexa muxatele tatalu (180). ");
INSERT INTO ata_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Xe no voxo anu sou usoli la sou mulapunu tauuxu alaxu vilesisi loxo ꞌosi, la musivita. La uleenu muluꞌelai no tualasiꞌa ta mitema sou soli. Xo anu aululu mine manina. La sou ta ꞌolu Esau ilou Iakovo miꞌasixu. ");
INSERT INTO ata_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nanasiꞌa ta mitema ane Esau muxalixaꞌa aloxo ꞌo. Anu Esau ne ilemolu ualasou vile kalumo lexe Edomu. ");
INSERT INTO ata_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Anu muꞌuluxaꞌa ta sema ne Kanani. Vile ualasie lexe Ada, eiae Eloni ꞌolu. Eloni anu itemasie Keti. Vile ualasie lexe Oꞌolivama, eiae Ana ꞌilie. Ana mamie ualasou lexe Sibeoni, anu itemasie Ivi. ");
INSERT INTO ata_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Xe vile ualasie lexe Basemati, Isimaeli ꞌolu. Vimoe mulu ualasou lexe Navaiote. ");
INSERT INTO ata_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada opoone la sou mivoꞌonu Elipasi. Xe Basemati mivoꞌonu Leuelu ");
INSERT INTO ata_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","xe Oꞌolivama mivoꞌonu Ieusu ilou Ialamu mo Kola. Esau ta ꞌolu ane ne anu mupalaaneꞌi mine aneꞌi mixoxoolu ne Kanani. ");
INSERT INTO ata_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Xe Esau muavuti la munoꞌa ta semasemau iloꞌa ta ꞌiliꞌiliꞌa mo ta mitema noxou mo ta mee mo ta kau mo ta donki mo ta kameli mo ta mimii iouiou ne munoꞌa mukalusi sou iloꞌa misuku milai no xalee lia vile vaꞌaxu no paxa. ");
INSERT INTO ata_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Milai mixolu vaꞌaxu noxou vimou Iakovo, xo iloꞌa mixolu mipita la ilou vimou miꞌamiꞌa ilou mixamixaꞌa piena misevile la umomomo sou ilou ixolu ipita uasi xo tanixaꞌa uasi. Lia xalee se ane iloꞌa mixolu no anu ne umomomo sou iloꞌa ixolu ipita la uasi, xo ta sipsip iloꞌa ta mee mo ta kau mo ta donki noxiꞌa ilou tapiena misevile mole lia xalee vile paꞌusou la uasi. ");
INSERT INTO ata_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","La sou Esau musuku sou mulai muxolu no laxalaxaꞌilu ne Seiru. Esau anu mutuꞌu ovuxaꞌa ta mitema ne Edomu ane mixolu no laxalaxaꞌilu ne Seiru. ");
INSERT INTO ata_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ta ꞌolu ualaualasiꞌa aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Elipasi, nenu ualasie lexe Ada, Leuelu nenu ualasie lexe Basemati. ");
INSERT INTO ata_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Xe Elipasi mupalaa la ta ꞌolu ualaualasiꞌa aloxo ꞌo, eiae Teman ilou Omaru mo Sepo mo Xatamu ilou Kenisi. ");
INSERT INTO ata_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Xe Timuna, Elipasi semau ane vile mipalaa eiae Amaleki. Aneꞌi ta mitema ane ne, Esau ta xasoxasou. ");
INSERT INTO ata_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Xe Leuelu ta ꞌolu ta mulu ualaualasiꞌa aloxo ꞌo, Nakati ilou Sela mo Sama mo Misa. Aneꞌi ta molomolo ane ne, Esau ilee semau Basemati ta xasixasiꞌa ane. ");
INSERT INTO ata_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Xe Oꞌolivama e Esau semau, nenie ualasie lexe Ana. Ana mamie ualasou lexe Sibeoni, Oꞌolivama xasie. Ane Oꞌolivama mipalaaneꞌi ta ꞌilie ane eiae Ieusu ilou Ialamu mo Kola. ");
INSERT INTO ata_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Ta mitema ano ꞌo, aneꞌi ta tatila ane, Esau ꞌolu laposalaxu Elipasi muxalixaꞌa ualaualasiꞌa ano ꞌo, eiae Teman, Omaru, Sepo, Kenisi, Kola, Xatamu mo Amaleki. Aneꞌi e teitiitisou ualaualasiꞌa ne Elipasi ta ꞌolu. Aneꞌi ta tatila sou tuala tila ne Edomu, aneꞌi Ada ta xasixasie. ");
INSERT INTO ata_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Aneꞌi ta tatila ano Esau ꞌolu e ualasou lexe Leuelu muxalixaꞌa. Ualaualasiꞌa ano ꞌo, eiae Nakati, Selau, Sama mo Misa. Aneꞌi ta tatila ane teitisou ualasiꞌa ꞌo la ne Leuelu muxalixaꞌa. Basemati, Esau semau ane tatalusiꞌa ta xasixasie. ");
INSERT INTO ata_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Aneꞌi ta tatila sou tuala tila ne Edomu kalumo. Xe aneꞌi ane noxie Oꞌolivama ane Ieusu ilou Ialamu mo Kola. Aneꞌi ta tatila ane ne Oꞌolivama e Esau semau ane tameisiꞌa mixalixaꞌa. Oꞌolivama nenie ane Ana. ");
INSERT INTO ata_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aneꞌi ta mitema ane nenge teitisou ualaualasiꞌa mukalu ne Esau e ualasou vile lexe Edomu muxalixaꞌa. Aneꞌi mixali ta tatila sou tuala tila noxiꞌa la. ");
INSERT INTO ata_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Xe Seiru ta ꞌolu ta mulu ualaualasiꞌa aloxo ꞌo. Seiru anu itemasie Xoli, ia anu muxolu no tuala tila ne Edomu. Ta ꞌolu ualaualasiꞌa ano ꞌo, vile ualasou lexe Lotan mo Sobalu mo Sibeoni mo Ana ");
INSERT INTO ata_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","mo Disoni mo Eseru mo Disan. Aneꞌi ane ualaualasiꞌa mupalaꞌa ꞌo ne, anu Seiru ta ꞌolu. Aneꞌi ta tatilasiꞌa ta mitema ne Xori no nano no tuala tila ne Edomu. ");
INSERT INTO ata_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Seiru ꞌolu vile e ualasou lexe Lotan muxalixaꞌa ta ꞌolu ta mulu ane, eiae Xori ilou Koman. Lotan vimou sema ualasie lexe Timuna. ");
INSERT INTO ata_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalu ta ꞌolu ta mulu ualaualasiꞌa ane Aluvani ilou Manakati mo Ebalu mo Sepo mo Onamu. ");
INSERT INTO ata_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Xe Sibeoni ta ꞌolu ta mulu ualaualasiꞌa ane Aia ilou Ana. Ana e miaꞌaloxu lexe mulai musaxilaꞌa momu Sibeoni ta donkiiu la mumaisou tivula taxataxasou. La tivula uopuopu utetelo no taxataxa ne. ");
INSERT INTO ata_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Xe Ana mulai xe mupalaa, la mupalaaneꞌi ta ꞌolu ane, Disoni ilee Oꞌolivama. ");
INSERT INTO ata_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Xe Disioni la muxalixaꞌa ta ꞌolu ane, Emudan ilou Esuban mo Itiran mo Keran. Aneꞌi ta mulu mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Xe Eseru ta ꞌolu ta mulu ualaualasiꞌa aloxo ꞌo, eiae Bila ilou Savani mo Akan. ");
INSERT INTO ata_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Xe Disan ta noxou ane, Usu ilou Aran. Aneꞌi ta mitema ano ꞌo aneꞌi ta tatilasiꞌa ta mitema ne Xori. ");
INSERT INTO ata_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ualaualasiꞌa ano ꞌo, Lotan ilou Sobalu mo Sibeoni mo Ana mo Disoni mo Eseru mo Disan. ");
INSERT INTO ata_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Xe no tauutauu ie ane ta Isilaeliꞌa tila vile sou usaxilaꞌa uasi, la aneꞌi ta mitema ano ꞌo, aneꞌi mixali ta tatila sou tuala xalee ne Edomu. ");
INSERT INTO ata_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Itema ane musaxilaꞌu tuala xalee ne Edomu tei ane Bela. Momu ualasou lexe Beori. Anu muxolu sou musaxilaꞌu tuala tila ne Dinava. ");
INSERT INTO ata_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Xe Bela musoli, la Iovavu munoꞌu tanixu. Iovavu momu ualasou lexe Selau. Selau anu sou tuala tila ne Bosura. ");
INSERT INTO ata_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Xe Iovavu musoli, la Usamu anu sou xalee lia ne Teman munoꞌu tanixu. ");
INSERT INTO ata_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xe Usamu musoli, la Kadati munoꞌu tanixu. Kadati momu ualasou lexe Bedati. Xe Kadati mulutu sou mulai ne Moabu sou muꞌoto ne Midiani, la mutaloxolixaꞌa. La sou mulai muxolu ne Aviti sou musaxilaꞌa ta mitema ne Aviti. ");
INSERT INTO ata_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Xe Kadati musoli, la Samula anu sou tuala ne Masureka munoꞌu tanixu. ");
INSERT INTO ata_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Xe Samula musoli, la Saulo itemasie Leovotia munoꞌu tanixu. Tuala ne Leovotia ne, muxolu ꞌalai no lexa tila ne Iupileitisi. ");
INSERT INTO ata_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Xe Saulo musoli, la Balukanan munoꞌu tanixu sou muxali tila noxiꞌa. Balukanan momu ualasou lexe Akuboru. ");
INSERT INTO ata_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Xe Balukanan musoli, la Kadati munoꞌu tanixu. La sou anu muxolu sou musaxilaꞌu tuala tila ne Pau. Semau ualasie lexe Meꞌetavelu. Momu ualasou lexe Matele, xe Matele mamie ualasou lexe Mesaapu. ");
INSERT INTO ata_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","La sou ta mitema ta tatila ane noxou Esau ualaualasiꞌa aloxo ꞌo, Timuna ilou Aluva mo Ieteti mo Oꞌolivama mo Ela mo Pinon mo Kenisi mo Taman mo Mipusalu mo Makadielu mo Iramu. Aneꞌi ta mitema ane ne aneꞌi ta mitema ta tatila noxiꞌa ta mitema noxou Edomu. Edomu ne Esau ualasou vile aloxo ne. Anu Esau ne ta mitema ne Edomu xasiꞌa. Aneꞌi ta tatila vilevilesi no tualasiꞌa mo ta mitema sou isaxilaꞌa a ixolu. ");
INSERT INTO ata_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ia Iakovo ne uꞌumesou tuala ne Kanani e momu Aisaki muxoxoo no anu ne uasi. ");
INSERT INTO ata_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Muxoxoo ane, la sou nanasiꞌa iloꞌa ta ꞌolu mikaukavunu muxolu aloxo ꞌo. Iosepu anu Iakovo ꞌolu maulu tauu iexu mumomomo loxo mavulovexa vile mo mulelia taꞌuve mo muvaxa simi tamei (17). Anu ulavusou sou usaxilaꞌa ta sipsip iloꞌa ta mee noxou momu iloꞌa ta vimovimou noxiꞌa Vila ilee Silipa. Aneꞌi ta sema tamei ne, momu ta semasemau. Ia anu mulai noxou momu la muaꞌalouxu ꞌiliꞌilixoneꞌi ta vimovimou e iꞌoxoꞌoxonu masumasua. ");
INSERT INTO ata_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iosepu ne, momu Iakovo ualasou vile lexe Isilaeli, anu umasaxaiꞌa ta ꞌolu ia umasaxau Iosepu misevile muꞌoki noxiꞌa. Xo nenu mivoꞌonu no mine anu Isilaeli ne aululu manina. Tavaꞌu aloxo ne la sou momu muꞌoxonu iu tokolomo vile lailaixe, utaa la ulai uxali no lia no tavaꞌu, xe avolu veveeni. ");
INSERT INTO ata_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Xe ta vimovimou milavu lexe mamiꞌa anu umasaxau ꞌolu Iosepu misevile muꞌoki noxiꞌa Iosepu ta vimovimou, la aneꞌi oponeꞌi masuau vimoꞌa ne misevile mo ivivikala lailaixe ulai noxou uasi. ");
INSERT INTO ata_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","No ꞌolovoxo vile, la Iosepu muaipiepiena la mulai muaꞌaloiꞌa ta vimovimou aloxo ꞌo, “Ngalomu uneꞌe noxilo mo aaꞌalomengixu aipiepiena noxilo ꞌo. Nengeꞌa telai no xai sou nengeꞌa tevovotu uiti tavatavalanu. Xe noxilo tavalanu muavuti la mutulu mulapu. Ia ta noxinge miavuti la mitulu mixaliliu noxilo ka mitangatuluou.” Xe aneꞌi milomu aloxo ne la laꞌiaxaꞌa misevile. ");
INSERT INTO ata_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Xe miavuti la mitaliꞌisou aloxo ꞌo, “Loxovaa, nini xavutalameni lexe nini sou naxali tila sou nasaxilaꞌixe?” Aneꞌi laꞌiaxaꞌa muꞌokiꞌoki xo milomusou aipiepiena noxou xe vaivaikala ane anu mulemolusiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Xe iliꞌi la Iosepu muaipiepiena alaxu vile la. Xe muavuti la muvikalaneꞌi ta vimovimou aloxo ꞌo, “Eni eaipiepiena la, la emaisou aso xe soꞌio iloꞌa ta oto mavulovexa mo mulelia vile mitulutulu no talaxo ka mitangatulu muluꞌe noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Xe muavuti la mulai noxou momu kalumo sou muaꞌaloxu aipiepiena noxou ne. Xe momu muavuti la mukaitolonu la muvikalanu lexe, “Aipiepiena maꞌi to axoo ne? Loxovaa, nini nemasaxa lexe nexi noxie nenine mo ta viivine taneꞌe taxolaꞌu tavaꞌixe mo tatangatulu sou tatoxoneni?” ");
INSERT INTO ata_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ta vimovimou ne, oponeꞌi masua misevile ia mamiꞌasi ne iou siꞌisou aipiepiena ne uasi, uxoxoolu la uxavuxavutalanu. ");
INSERT INTO ata_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","No voxo vile, la Iosepu ta vimovimou milailixaꞌa mamiꞌa ta sipsipu iloꞌa ta meeou ne Sikemu sou miꞌani iaꞌeiaꞌe xe miie lexa. ");
INSERT INTO ata_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Xe Iakovo muavuti la muvikalanu ꞌolu Iosepu aloxo ꞌo, “ꞌAlixeni, eni emasaxaine lexe nalutu mo namulineꞌi ta viivine ulai ne Sikemu.” Xe Iosepu muavuti la muvikalanu momu lexe, “Ani, eni asou alutu alai.” ");
INSERT INTO ata_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","15","Xe momu muavuti la muvikalanu aloxo ꞌo la, “Nalai mo namaisiꞌa ta viivine lexe aneꞌi a laixeneꞌisi. Mo namaisiꞌa ta sipsipxeni kalumo lexe laixeneꞌisi. Nalai mo nakilisiꞌa lexe laixeneꞌisi la sou nalivu uneꞌe sou naaꞌaloxeni.” La sou momu mupalusou sou mulai mukilisiꞌa ta vimovimou. Ia momu ne, anu muxoxoo no vanunu ne Ebulon. Iosepu mumuamuaꞌi xe mulai muxali ne Sikemu, la mulai muxixaoxao no lia xalee ane ne, la sou mumaisou itema vile la itema ne mutaliꞌisou aloxo ꞌo, “Nakakamuli maꞌia?” ");
INSERT INTO ata_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Xe Iosepu muavuti la muvikalanu lexe, “Eni akakamulineꞌi ta viivilo e mineꞌeneꞌi mamilo ta sipsipou sou ikamulixaꞌa lexa sou iiexu xe iaꞌeiaꞌe sou iꞌou. Nemaisiꞌa a neꞌei la napelaꞌilo mo amulineꞌi.” ");
INSERT INTO ata_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Xe itema ne, muavuti la muvikalanu Iosepu lexe, “Aneꞌi a milutu mo milai. Elomusiꞌa mivivikala lexe ilai loxo ne Dotani.” La sou anu mumulineꞌi la mulai muxalisiꞌa ne Dotani. ");
INSERT INTO ata_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Xe anu a uao no paxa, ia aneꞌi mimaisou mine anu umuamuaꞌi ulai noxiꞌa, la aneꞌi mipotoxu sou lexe ivau usoli. ");
INSERT INTO ata_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ta motu miavuti la mivikalaneꞌi ngatoꞌo lexe, “Anu, itema sou aipiepiena a uxali ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tapalea mo tavaꞌu soxu mo tasuꞌanu uluꞌelai no lexa taxasou vile musii ꞌo. Ia talai la taaꞌalo lexe mii vile loxo laeoni muvau. La sou nenge tamalei lexe mii maꞌia ane uxali no anu aipiepiena noxou ne.” ");
INSERT INTO ata_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Xe Luven mulomusiꞌa mivikala aloxo ne, la mukamuli voteꞌi sou upamaulinu Iosepu no anu. Muavuti la muvikalaneꞌi aloxo ꞌo, “Nengeꞌa tavaꞌu mamu. ");
INSERT INTO ata_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tatetelisousi ka talea uluꞌelai no taxa sou lexa ꞌo no xalee lia vitanisi, ia taꞌoxo masua loxo ꞌo uasi.” Anu mulosiꞌa voteꞌi ane ne xo anu mumasaxa lexe anu molu ulivu uneꞌe sou ulivunoxu vimou utelo sou upalusou ulivu ulai noxou momu. ");
INSERT INTO ata_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Iosepu mumuamuaꞌi xe muneꞌe muxali noxiꞌa ta vimovimou ne, xe aneꞌi miavuti vaxa la mitetelisou ka milulusou tokolomo lailaixe e mutaanu, ");
INSERT INTO ata_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ka sou miavuti la miꞌitinu ka mileanu muluꞌelai no lexa taxasou vile musii. ");
INSERT INTO ata_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mileanu maulamenge soxu loxo ne mukalu, ia aneꞌi milai mitaꞌolu sou miꞌani. Miꞌaniꞌani ia mimalei la ta Isimaeli seꞌi iloꞌa ta kameliiꞌa meꞌa loxo ne Xileati ia ilalai loxo ne Aixiputo. Ta kameliiꞌa mitavule mimii lailaixe loxo mii ane tumaꞌu laixe sou laꞌilali mo lamalasile mo ovu vile lexaxu ane tumaꞌu laixe. ");
INSERT INTO ata_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Xe Iuda muavuti la muvikalaneꞌi ta vimovimou aloxo ꞌo, “Taemoso, lexe nenge tavaꞌu vivinge usoli ka tatalumeiou, la mii maꞌia laixe ane nenge nengeꞌa taxalisou no anu xavutala ane ne? ");
INSERT INTO ata_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nengeꞌa tanoꞌu mo talosiꞌa ta mitema e ineneꞌe ꞌo mo ilotonu. Mo sou mamu nenge taꞌoxo masuanu. Xo nenge vivinge maninasou ane. Nenge xiasinenge ilou sialunenge ane.” Xe ta vimovimou miavuti la mivikala lexe, “Ioxe, nenge tamulinu aloxo nelemolu ne.” ");
INSERT INTO ata_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Xe ta mitema sou ivaivalo sou inoꞌu lamoli e mimaisiꞌa mineneꞌe ꞌole mineꞌe mixali ꞌalai noxiꞌa manina, la sou Iosepu ta vimovimou ne milai milaanu sou milosiꞌa. Ta Midiani milotonu Iosepu mulai noxiꞌa ta vimovimou no anu lamoli siliva alelaxu mavulovexa tamei. Milotonu mukalu, la sou minoꞌu milailixu ne Aixiputo. ");
INSERT INTO ata_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Xe iliꞌi, la Luven mulivu no taxa e aneꞌi misuꞌanu vimoꞌa Iosepu no anu ne la umaisou vimou uasi. Xe muavuti la musinasinanu tokolomou no vasimolu ne xo tanuxu vimou misevile. ");
INSERT INTO ata_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Xe mulivu mulai noxiꞌa ta vimovimou, la muvikalaneꞌi lexe, “Ae, molomolo soxu ꞌole a tasiauxu! Ka eni anavaa maasi?” ");
INSERT INTO ata_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Xe ta motu miavuti la mivau mee vile ka minoꞌu sialuxu sou miꞌunanu Iosepu tokolomou muluꞌe no anu. ");
INSERT INTO ata_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Xe iliꞌi la sou minoꞌu tokolomou ne mulai sou mimaxaꞌu noxou mamiꞌa. Mixali la mivikalanu mamiꞌa aloxo ꞌo, “Namaisou mii ꞌo. Nexi texalisou. Male ꞌiline miiu.” ");
INSERT INTO ata_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Xe Iakovo iou muvaxa no anu tokolomou ꞌolu ne la mutongonu la muvikalaneꞌi lexe, “Ani, ꞌalixe Iosepu tokolomou ane! Ta mii seꞌi loxo ta laeoni mivau ꞌalixeni ne mo miꞌou.” ");
INSERT INTO ata_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Xe muavuti la musinasinanu tokolomou no vasimolu ne, io mutelonu tokolomo suꞌi sou tama xo tanuxu ꞌolu ne misevile. Muxoxoolu tanutanuxu ꞌolu mo mutatamasou ne maxuvee misevile. ");
INSERT INTO ata_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ta ꞌolu ta mulu mo ane ta sema mineꞌe noxou sou lexe ixolixolinu, la anu umasaxa lexe aneꞌi ineꞌe ixolixoli mamu. La sou muvikalaneꞌi lexe, “Taletalelixu ꞌalixeni ꞌo mo atatamasou mole eni amulinu ꞌalixeni ulai no tualasiꞌa ta mitema sou soli ne ia ukalu uasi.” La sou anu muxolu sou mutamasou ꞌolu ne voxo seꞌi la. ");
INSERT INTO ata_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ioxe, ta Midiani e milotonu Iosepu noxiꞌa ta vimovimou ne, milailixu ne Aixiputo, la itema vile ualasou lexe Potipaa mulotonu, anu itema sou xaixai noxou tatananu tuala ne Aixiputo. Anu tila noxiꞌa aneꞌi ane sou isaxilaꞌu taasou tatananu tuala. ");
INSERT INTO ata_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","No tauu ie ane ne, la Iuda mulutu muꞌumesiꞌa ta vimovimou ia mulai muxolu noxou itema vile ualasou lexe Ira. Ira anu itemasie tuala tila ne Adulamu. ");
INSERT INTO ata_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Iuda mulai muxolu ne la muꞌuluxe semasie Kanani vile. Mamie ualasou lexe Sua. ");
INSERT INTO ata_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ilou mixoxoolu xe opoone, la mivoꞌonu ꞌilie laposalaxu, la mulu. Mimoxoꞌu ualaosu lexe Eri. ");
INSERT INTO ata_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Xe iliꞌi la, la ane opoone la. Xe mivoꞌo, la ꞌilie ne mulu la. La mimoxoꞌu ualaosu lexe Onani. ");
INSERT INTO ata_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Xe iliꞌi la, la ane opoone la. La sou ane mivoꞌonu ꞌilie mulu vile la. La mimoxoꞌu ualasou lexe Sela. No voxo ane Iuda semau mivoꞌonu ꞌilie Sela ne la, anu Iuda mulai mo a uxoxoolu no tuala ne Kesipu. ");
INSERT INTO ata_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mixoxoolu xoo xe, Iuda ꞌolu e laposalaxu, ualasou lexe Eri muxali itema tila, la sou momu munoꞌe iu sema vile ualasie lexe Tamari. ");
INSERT INTO ata_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ia Eri ne, ꞌilixonu laixe noxou IAUE iou uasi. La sou IAUE muvau musoli. ");
INSERT INTO ata_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Xe Iuda muavuti la muvikalanu ꞌolu Onani, “Nalai mo ngongie omeni Tamari ngaai xo vivine musoli la ta ꞌolu uasi. Xoluxolu naꞌa nenge aloxo ꞌo, nini nanoꞌe vivine semau sou napalaaneꞌi vivine ta ꞌolu mo sou vivine ualasou ne ukalu uasi. La sou ulai iliꞌi la ta ꞌilie ane ane ivoꞌoneꞌi ne, vivine Eri ta ꞌolu.” ");
INSERT INTO ata_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ia Onani ne, mulavu lexe ta molomolo ane anu uxalixaꞌa ne ta ꞌolu uasi. La sou no voxovoxo ane aneꞌi ilee Tamari iai sou anu ulai noxie xe ꞌuveꞌuveꞌu sou unixi, la anu uxexee sou unixi ulai vaꞌaxu no lia. Anu muꞌoxo aloxo ne xo anu umasaxa lexe upalaaneꞌi ta ꞌolu iu vimou uasi. ");
INSERT INTO ata_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ꞌIlixo ane ne, IAUE mumaisou la laixe no iou uasisi manina, la muvau musoli aloxo vimou Eri. ");
INSERT INTO ata_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Xe Iuda muavuti la muvikalane uaꞌanu Tamari aloxo ꞌo, “Nalutu mo nalivu ulai noxou mamine mo naxolu aloxo nesi ia nataulaꞌi uasi mole ꞌalixe Sela uxali itema tila o.” Anu muvikalane aloxo ne xo anu umamaꞌu xo loxo ꞌo io Sela usoli kalumo loxo ta vimovimou tamei. La sou Tamari milivu milai noxou mamie. ");
INSERT INTO ata_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tauu ie tavuꞌalo mulai mukalu xe iliꞌi, la Iuda semau ane Sua ꞌolu sema misoli. Muxolu sou tamasie semau xo tanuxe misevile. Xe mukalu, la sou aneꞌi ilou menexu vile ualasou lexe Ira sou tuala ne Adulamu milai ne Timuna sou ilou imaisiꞌa ta mitema noxou ixoxotosou ta sipsip noxou laxusiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Xe Tamari milomu lexe uaꞌane Iuda a muneꞌe ne Timuna sou uxotosou ta sipsip laxusiꞌa ne. ");
INSERT INTO ata_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","La ane mipasipaa sou mixexeenu tokolomoxe ane ane mitokolomoxu sou mipoulilosou mulue, ia misakii mii vile loxo taunamo o sou mutaluxu iei ia milai mitalupexa no voteꞌi no iou xalengaxu tuala tila ne Enaimu. Tuala ane ne muxolu no voteꞌi ane mulai loxo ne Timuna. Xo ane milavu lexe Iuda ꞌolu e ualasou lexe Sela ne, anu itema tila, ia aneꞌi inoꞌu ulai noxie sou iꞌuluxu uasi. ");
INSERT INTO ata_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Iuda mumuamuaꞌi muneꞌe xe mumaisie, la muloxomale lexe ane sema sou voteꞌi vile ane xo ane misuꞌasou iei. ");
INSERT INTO ata_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ia utongone lexe ane uaꞌanu Tamari uasi manina. Ioxe, anu muavuti la mumuamuaꞌi mulai loxo noxie no voteꞌi paꞌumolu, la muvikalane, “Ioxe, nengei taai.” Xe ane miavuti la mikolinu lexe, “Nalosilo maꞌia?” ");
INSERT INTO ata_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Xe anu muavuti la muvikala lexe, “Alivu la sou asovanumeni mee ꞌilie soxo vile uneꞌe noxine.” Xe ane miavuti la mivikalanu aloxo ꞌo, “Anu laixe, ia lexe nini nalosilo mii vile sou eni amuxaxu loxo sosovo ulai utalo no voxo ane nini nasovanu mee ne uneꞌe. La sou alivunoxu sosovo ne ulai noxine.” ");
INSERT INTO ata_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Xe anu muavuti vaxa la mutaliꞌisie, “Mii maꞌia ane nemasaxa lexe eni alosine?” Xe ane miavuti la mivikalanu lexe, “Nalosilo miimeni e nasosovosou mimii no anu lexe naꞌa nini ilou lamotasou ulili no xolaneni mo vilaxoxene e natatavulenu ne.” Xe anu muavuti la mulosie mii tamei ne xe mukalu, la sou mulai noxie. ");
INSERT INTO ata_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Xe Tamari miavuti la milivu milai no tuala sou mixexeenu mii e misakii sou mitaluxu iei no anu, io sou ane mitelonu tokolomo sou poulilosou mulue ꞌole mutelo la. Ane milai mixoxoo ne xe iliꞌi la sou opoone mupalaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ioxe, Iuda muavuti la mupalusou menexu vile ne Adulamu sou ulailixu mee noxie sema ꞌole, xe unoꞌu mimii e ane milingau sou mimuxaxu muai noxie sou umaxaꞌu vaikala noxou Iuda lexe anu muvikala manina, sou ulivunoxu ulai noxou. Itema ane ne mulutu xe mulai la uxalisie uasi. ");
INSERT INTO ata_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Xe muavuti la mutaliꞌisiꞌa ta mitema seꞌi ne Enaimu, “Sema sou voteꞌi e ilavusou ixoxolu no voteꞌi ꞌo ꞌava?” Xe aneꞌi miavuti la mivikalanu lexe, “Nexi sema sou voteꞌi vile ixolu lai ꞌo uasi.” ");
INSERT INTO ata_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Xe itema ne mulomu aloxo ne la, mulutu sou mulivu mulai noxou Iuda la muvikalanu lexe, “Axalisie sema ne uasi. Ta mitemasie Enaimu ne mivikalaleli lexe aneꞌi sema sou voteꞌi vile ixolu noxiꞌa no tuala ne uasi manina.” ");
INSERT INTO ata_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","La sou Iuda muavuti la muvikalanu lexe, “Mii vile uasi, mimii e sema ne minoꞌu ne, uai noxie ne, xo loxo ꞌo io ta mitema ikekeienge. Eni esova mee vile ꞌilie ulai noxie, ia naxalisie uasi ne la, mii vile uasi.” ");
INSERT INTO ata_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Xe male loxo soꞌio tatalu mukalu xe iliꞌi la sou vaikala muneꞌe muxali noxou Iuda lexe uaꞌanu Tamari ane miꞌoxo loxo sema vile sou voteꞌi mo ane a opoone. Xe anu Iuda muavuti la mupalusiꞌa lexe inoꞌe iuatulailixe mo iꞌelaxe mo isoli. ");
INSERT INTO ata_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Minoꞌe miuatulailixe la ane mivikala lexe, “Ngavikalanu uaꞌaleli lexe, opo ano ꞌo itema e miumiu ane uai noxilo ꞌo, opou. Nganoꞌu mii ꞌo ulai noxou mo utongonu.” ");
INSERT INTO ata_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Mii ne minoꞌu xe milailixu noxou Iuda, la anu mutongonusi. La sou muvikala lexe, “Susu noxie ne tatila malaxo uasi, ia noxilo ne tatila misevile. Xo anoꞌe sou iꞌuluxu ꞌalixeni Sela la ua.” Xe iliꞌi, la Iuda ulai noxie la uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Xe no voxo ane sou ane ivoꞌo no anu, la milavu lexe ane ivoꞌoneꞌi ta ꞌilie tamei. ");
INSERT INTO ata_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Xe no mine sema vile mineꞌe sou ipapaipixone, la ꞌilie vile avolu muxali muuatu, la sema e ipapaipixone nenu ne mitetelisou avolu sou misakii no anu lamota lauoinu. Xe miavuti la mivikala lexe, “Ane uluꞌe tei a.” ");
INSERT INTO ata_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","La ua. Anu muꞌumenu avolu mulivunoxu mulai no nano, ia vimou muluꞌe tei. La sou sema e mineꞌe sou mipaipixone nenu ne mivikala lexe, “Ee, xavineni sou neloꞌe la sou ane neluꞌe tei ꞌo!” La sou mimoxoꞌu ualasou lexe Peresi. ");
INSERT INTO ata_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Xe iliꞌi la sou ane misakii avolu no anu lamota lauoinu ne muluꞌe. La sou mimoxoꞌu ualasou lexe Sela. ");
INSERT INTO ata_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ioxe, Iosepu e ta Isimaeli minoꞌu mulai ne Aixiputo ne, minoꞌu mulai noxou Potipaa sou mulotonu. Potipaa ne, anu itema tila vile. Anu itema sou xaixai noxou tatananu tuala ne Aixiputo. Anu tila noxiꞌa aneꞌi ane sou isaxilaꞌu taasou tatananu tuala ne Aixiputo. ");
INSERT INTO ata_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","IAUE uxoo noxou Iosepu, la sou mii maꞌia ane anu uꞌoxonu ne, uxali laixe misevile. Io, anu Iosepu mulai muxolu noxou Potipaa. ");
INSERT INTO ata_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Anu uxoxoolu noxou tilasou Potipaa ne la, tilasou mutongonu lexe IAUE a uxoo noxou mole ane xaixai piepiena ne anu muꞌoxonu laixe mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potipaa opoonu usexelaxu Iosepu misevile la sou molu musosovosou lexe anu uxali loxo itema vile sou uxoo ꞌalai noxou. La sou mumuxaxu sou usaxilaꞌu taasou mo mixumixu mo miumiu no nano no taasou ne ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tavaꞌu xo Iosepu ane Potipaa munoꞌu sou muneꞌe sou usaxisaxilaꞌu mixumixu ilou miumiu, la sou ane IAUE mualusou tila noxou mo aneꞌi ane iloꞌa ixoxoo no tani noxou ne mo miumiu ilou mixumixu no taasou mo no xaixu kalumo. ");
INSERT INTO ata_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","La sou Potipaa muꞌitalonu mimii tavuꞌalo ne no avolu Iosepu sou anu molu usaxilaꞌu ukalusi. Ia anu uxavutalanu mii vile la uasi. Anu uxavutalasou laꞌilalisi. Iosepu ne muleme maulu vile xaviinu misevile. Mo iou ne lailaixe misevile. ");
INSERT INTO ata_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","La sou maxuvee uasi manina, Potipaa semau miisuxu xe miavuti la ixoloxixiiou. La sou mivikalanu lexe, “Naneꞌe mo nengei talai taai no luu noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ia Iosepu mulomu ua la muvikalane lexe, “Tila noxilo musosovosilo mo mumuxaxo lexe eni sou asaxisaxilaꞌu mimii no nano no tani ꞌo ukalusi. Miumiu mo mixumixu tavuꞌalo ne anu mumuxaxo lexe enisi melo asaxilaꞌu. ");
INSERT INTO ata_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tani ꞌo mo, mimii no nano ꞌo ne muxolu no anu saxisaxilaꞌu noxilosi aloxo anu, ia mii vile no nano ꞌo anu uvikalalelixu lexe eni amomomo sou asaxilaꞌu uasi, uasi. Ia nini ne, anu uvikalalelisine uasi, xo anu semau ane nini. Anu umomomo sou eni amulinu masaxa noxine uasi. Xo maasi xe eni amuli masaxa noxine, la loxo eni aꞌoxo ꞌilixo masua manina no iou Lataua.” ");
INSERT INTO ata_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ia ane ilomu uasi manina. No voxovoxo utotomu ne, ane ilai noxou sou ixoloxixiioi sou lexe anu ulai noxie, ia anu ne xaviinu misevile la ulomuxe uasi manina, mo anu muxolu vaꞌaxu noxie. ");
INSERT INTO ata_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Io, no voxo vile la anu Iosepu mulai no nano no taasou tila noxou mo a uꞌoxoꞌoxonu xaixai noxou seꞌi. Ta mitema sou xaixai noxou tila noxou vile noxiꞌa ne uxolu no nano uasi. ");
INSERT INTO ata_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Xe aliku ꞌo miavuti xe mineꞌe la miteteli pekiaꞌu vaxa no anu tokolomou veveeni e utataanu ka mivikalanu lexe, “Naneꞌe mo nengei talai taai.” Xe anu muavuti la muloꞌene sou muꞌume mulai no ale. Miisou e mutataanu ne, muluvu no vasimolu mole ane mitetelisou no avole ne. ");
INSERT INTO ata_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Xe ane mimalei loxo ꞌo la anu ane uꞌume ulai no ale, ia tokolomou ane ane itetelisou ꞌo xe, ");
INSERT INTO ata_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","miavuti la miꞌava mulai noxiꞌa ta mitema sou xaixai noxie lexe, “Ngamaisou mii ꞌo! Itemasie Evalaio e muluxeni munoꞌu sou muneꞌenu muxolu no tani noxixe ꞌo, utoxonenge uasi. Mulutusi ka muneꞌe no ano no taasilo e aai no anu sou uexe utetelisilo mo ulai noxilo no anu masaxa noxousi. ");
INSERT INTO ata_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ia eni eunga toxoxaꞌa sila anu muiave mulai no ale io mutautalonu tokolomou e mutaanu muai no paꞌumelo.” ");
INSERT INTO ata_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ane mimuxaxu muai ne xe mulue muxali, ");
INSERT INTO ata_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","la sou ane miaꞌalou, “Itemasie Evalaio e nenoꞌu muneꞌe muxolu ꞌo sou napalupalusou, utoxole uasi manina, muneꞌe muꞌuna no taasilo e aai no anu sou lexe ulai noxilo, sila ua. ");
INSERT INTO ata_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Eni eungaunga sila anu muꞌume muiave mulai no ale ia mutautalonu tokolomo e mutataa no vasimolu no paꞌumelo.” ");
INSERT INTO ata_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Xe Potipaa mulomu aloxo ne, la laꞌiaxu misevile. Tanu no nano ne navu ukaakaa. ");
INSERT INTO ata_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","La sou muvikalaneꞌi ta mitema sou ꞌotoꞌoto noxou tatananu tuala sou mineꞌe mitetelisou Iosepu sou milailixu no taasou navunavu noxou tatananu tuala sou unoꞌu navunavu sou ꞌilixo ane anu muꞌoxonu ne. Mulai muxolu no taasou navunavu ne ");
INSERT INTO ata_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ia IAUE muxolu noxou mo mualusou mole mimii e anu uꞌoxoꞌoxonu no nano ne uꞌoxonu laixe ukalusi. La sou itema sou usaxilaꞌu tani ane ne, opoonu usexelaxu Iosepu misevile. ");
INSERT INTO ata_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Itema ane ne muavuti la mumuxaxu Iosepu sou usaxilaꞌa ta menexu e iloꞌa ixoxoo no nano no taasou navunavu ne mo xaixai piepiena no nano ne anu molu usaxilaꞌu ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mole anu itema ne, umomomo sou usaxilaꞌu xaixai vile la uasi xo xaixai tavuꞌalo ne uxoo no avolu Iosepusi. Anu molusi uꞌoxo mimii ne la laixe ukalusi xo IAUE muxoo noxou. ");
INSERT INTO ata_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Iosepu mulai muxolu no ano ne maxuvee malaxo uasi, ia mumalei la minoꞌa ta mitema sou xaixai tamei noxou tatananu tuala ne Aixiputo mineꞌe miꞌunaneꞌi no tani noxou itema sou xaixai uuli noxiꞌa ta mitema sou ꞌotoꞌoto. Anu itema tila ne iloꞌa ta mitemau ixoxoo ane sou isaxisaxilaꞌu taasou tatananu tuala ne Aixiputo. Ta mitema sou xaixai noxou tatananu tuala tamei ne, vile anu tila noxiꞌa ta mitema sou isaxisaxilaꞌu uaini noxou tatananu tuala xe vile ne anu tila noxiꞌa ta mitema sou isaxisaxilaꞌu laꞌilalixu tatananu tuala. Aneꞌi ilou misusu no anu ꞌilixo vile masua la tatananu tuala laꞌiaxuiꞌa ilou misevile la sou mulai muꞌunalailixaꞌa no taasou e Iosepu mulai muꞌunalai no anu. ");
INSERT INTO ata_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Miꞌunalai mixoo no ano ne maxuvee misevile mole tila noxiꞌa ta mitema sou ꞌotoꞌoto ne musosovosou Iosepu sou usaxisaxilaꞌa ilou. ");
INSERT INTO ata_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Xe no ꞌolovoxo vile, la aneꞌi ta mitema tamei ne ilou miaipiepiena. Aipiepiena noxiꞌa ilou ne laaxu vilesisi uasi. Vile noxou aipiepiena ne vile mo xe vile noxou ne vile mo. ");
INSERT INTO ata_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Iosepu mulutu no kakau xe muneꞌe muxali noxiꞌa ilou, la mumaisou ieꞌi ne la, ilou ieꞌi kalauasi. ");
INSERT INTO ata_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Xe muavuti la mutaliꞌisiꞌa ilou, “Loxovaa ane iengi kalaua loxo ꞌo? Tuꞌumaxu vile muxali noxinge ngongou vaimomo ꞌosi?” ");
INSERT INTO ata_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Aneꞌi ilou miavuti la mivivkalanu aloxo ꞌo, “Nexi noxou teaipiepiena, la evile sou usuꞌulinexi noxou sou ululusou laaxu uasi.” Xe Iosepu muavuti la muvikalaneꞌi ilou aloxo ꞌo, “Lataua anusisi ane anu molu ulosou itema lavulavu sou ululusou aipiepiena. Ioxe, ngongou ngavikalalelixu aipiepiena noxinge ngongou vilevilesi.” ");
INSERT INTO ata_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","La sou anu ane sou usaxisaxilaꞌu uaini noxou tatananu tuala ne muaꞌaloxu noxou tei. Muvikala aloxo ꞌo, “No anu aipiepiena noxilo, eni eai la emaisou uaini aiinu vile mutulu no talaxo, ");
INSERT INTO ata_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ia avolu tatalusi. Xe alaxu vilesisi ꞌo la, volovoloxu mupaa vitanisi vaxa no avoavolu ne mo seseseenu kalumo. Xe alaxu vilesisi ꞌo la, tematemanu mupaa la mumomoxo alaxu vilesisi. ");
INSERT INTO ata_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Eni a etutulu eteteli sou kapuxu tatananu tuala tila ne Aixiputo no avolo. Xe eavuti la enoꞌu uaini ngiangiaxu mumomoxo ne ka ekapinu muluꞌelai no kapuxu ne ka elosou.” ");
INSERT INTO ata_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Xe Iosepu muavuti la muvikalanu, “Aipiepiena noxine ne laaxu aloxo ꞌo. Uaini avolu tatalu ne voxo tatalu. ");
INSERT INTO ata_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Voxo tatalusi a uxolu sou tatananu tuala ulaalixene sou ulivulixene ulai no anu xaixai noxine la. La sou nini nalosou kapuxu aloxo nini neꞌoxoꞌoxo tei. ");
INSERT INTO ata_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ia ulai xe nini nalivu ulai no ale sou naxoo laixe, la ieni siꞌisilo uasi, naxavutalaleli lexe xoluxoluxene ne lailaixe ukalusi. Mo lexe tanenixo la naaꞌaloxo noxou tatananu tuala ne Aixiputo mo nasuꞌulileli sou eni kalumo alaa axexesou tani ano ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Xo eni ꞌo ne minoꞌilosi ka misululeli vaxa noxiꞌa ta mitema no liaxaꞌa ta Evalaio no voxo ane aneꞌi ta mitema ane ne mimuamuaꞌi mineneꞌe loxo ne Aixiputo la sou aneꞌi milotoleli. Xe eneꞌe exoo ne lai ꞌo la, asusu no anu ꞌilixo vile uasi, ia minoꞌilo vitanisi ka ane mineꞌe miꞌunaleli no taasou navunavu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Iosepu ululusou aipiepiena noxou itema sou usaxilaꞌu uaini ne, la itema sou usaxisaxilaꞌu laꞌilalixu tatananu tuala ne mulolomu vaxa noxou Iosepu, la aipiepiena laaxu e anu ululusou ne, anu tamaxu laixe no anu xavutala noxou. La sou anu muavuti vaxa la muvikalanu Iosepu, “Eni kalumo eaipiepiena lexe, eni evoꞌutulolixu tiꞌa sou veleti tatalu no kisilo ia eꞌuluꞌu. ");
INSERT INTO ata_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","No nano no tiꞌa ane muai teitexi ne, laꞌilali iouiou ane muxutu a muꞌanaꞌana no anu. Anu tatananu tuala ne Aixiputo laꞌilalixu, ia ta ngiala mineꞌe mo a iꞌoꞌou.” ");
INSERT INTO ata_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Xe Iosepu muavuti la mululusou laaxu aipiepienau ne aloxo ꞌo. “Tiꞌa tatalu ne voxo tatalu. ");
INSERT INTO ata_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Voxo tatalusi a uxolu sou tatananu tuala ulaalixene. Nalaa ulai no ale la ixotonu xolaneni. Xe ukalu la sou ilaa ovu vile ka ililixene no anu. Io sou ta ngiala ineꞌe iꞌou xiasineni.” ");
INSERT INTO ata_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Iloꞌa mixoxoo no nano ne xe voxo tatalu mukalu la sou tatananu tuala ne Aixiputo ne muꞌoxonu laꞌilali vile toxoxaꞌa xaꞌa ta mitema sou xaixai noxou. Anu muꞌoxonu laꞌilali ane ne sou uxavutalanu voxo ane nenu mivoꞌonu no anu. La sou muvikala, la milaalixaꞌa itema sou xaixai noxou sou usaxisaxilaꞌu uaini xe itema sou usaxisaxilaꞌu laꞌilali. ");
INSERT INTO ata_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Xe ilou milaa mukalu, la sou tatananu tuala muvikalanu itema sou usaxisaxilaꞌu uaini ne sou mulivu mulai no anu xaixai noxou. ");
INSERT INTO ata_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Xe muavuti la muvikalaneꞌi ta mitema sou ꞌotoꞌoto noxou sou mililixu itema sou usaxisaxilaꞌu laꞌilali ne no ovu e milaanu. Mimii ane ne muxali ne aloxo Iosepu mulemolu ne. ");
INSERT INTO ata_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ia itema sou usaxisaxilaꞌu uaini ne iou siꞌisou Iosepu ne mole uxavutalanu la ua. ");
INSERT INTO ata_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Xe iliꞌi no anu tauu ie tamei mukalu, la tatananu tuala ne Aixiputo ne muaipiepiena lexe anu mulai mo a mututulu no lexa Nailu paꞌumele, ");
INSERT INTO ata_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","la mumaisiꞌa ta kau muxatele tamei ta toxotoxoxaꞌa. Vasimeꞌa ne muveli loxo ꞌo. Mo lovoxaꞌa misevile. Meꞌa no lexa mitelo mo a iꞌaniꞌani iaꞌeiaꞌe no lexa paꞌumolu. ");
INSERT INTO ata_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Xe iliꞌi la ta kau muxatele tamei la mitelo. Aneꞌi ta kau ane ne, alaalamaneꞌisi, mo vasimeꞌa ne muꞌitaꞌitasi. Meꞌa no lexa xe mixali mutelo, la mitulu no paꞌumeꞌa aneꞌi ane mixali mitelo tei. ");
INSERT INTO ata_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Xe miavuti vaxa la miꞌiꞌa aneꞌi ane mixali mitelo tei ne mukalusi. Tatananu tuala mumaisou aipiepiena ane ne xe mukuluke la mutulu. ");
INSERT INTO ata_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Xe iliꞌi, la mulivu sou muai, la muaipiepiena la. No anu aipiepiena ane tameisou ne, la mumaisou uiti ngiangiaxu palepanu toxotoxoxaꞌa muxatele tamei no aiinu vilesisi. Uiti ngiangiaxu ne lingamo sou ivalitusou. ");
INSERT INTO ata_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Xe iliꞌi la, la mumaisou uiti ne ngiangiaxu palepanu muxatele tamei no aiinu vilesisi muxali mutelo la, ia kisou ngialanusi. Palepalepanu ne kitukitusi xo atume ialuxu muili molu loxo no xalee lia ane aso utetelo no anu la muxutuxu. ");
INSERT INTO ata_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Xe aneꞌi ta uiti ane ne, miavuti la mimalukusiꞌa aneꞌi ane ta toxotoxoxaꞌa e mixali mutelo tei ne. Xe tatananu tuala mukuluke la, la mutulu avile la sou tanu tema. La sou mulavu lexe anu muaipiepiena. ");
INSERT INTO ata_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Xe mutulu no kakau la tanu laixe uasi. La sou mukala anaxu mulai noxiꞌa ta mitema sou lavulavu no tuala tila ne Aixiputo ne mo ta mitema ane milavu no anu alualu iouiou ne sou mineꞌe noxou mukalusi. Ta motu mineꞌe mixali noxou mukalu, la sou anu muvikalaneꞌixu aipiepiena noxou ne. Ia vile noxiꞌa ne umomomo sou ululusou aipiepiena tamei ne laaxu ulai noxou uasi. ");
INSERT INTO ata_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Xe itema e sou usaxisaxilaꞌu uaini ne muxavutala, la muvikalanu tatananu tuala ne aloxo ꞌo, “Vaimomo ꞌo eni apalaꞌalixu lexe eni eꞌoxo susu vile. ");
INSERT INTO ata_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","No voxo ane nini laꞌiaxeneiꞌa ta mitema sou xaixai noxine la minoꞌixe noxou itema sou usaxisaxilaꞌu laꞌilalixene sou milai miꞌunalailinexe no tani noxou itema sou xaixai uuli noxiꞌa ta mitema sou ꞌotoꞌoto. ");
INSERT INTO ata_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","La nexi noxou teai la teaipiepiena mukei. Ia aipiepiena noxixe noxou ne laaxu vilesisi uasi. ");
INSERT INTO ata_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","No nano no tani sou navunavu ne, maulusie Evalaio vile a nexi noxiꞌa texoo no nano ne. Anu uxoxoo noxou tila noxiꞌa ta mitema sou ꞌotoꞌoto sou isaxisaxilaꞌu taasine. Maulu ne a uxoxoo noxou sou anu upalupalusou. Nexi noxou tevikalanuxu aipiepiena noxixe noxou, la anu mululusou laaxu aipiepiena noxixe vilevilesi ne muneꞌe noxixe. ");
INSERT INTO ata_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Xe iliꞌi, la mimii ne muxali maninasou aloxo anu mulemolu lamana noxixe ne. Nini nelaalinexe noxou, la nelivunixo sou elivu elai no anu xaixai noxilo la, ia nelilixu itema sou usaxilaꞌu laꞌilalixene.” ");
INSERT INTO ata_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Xe tatananu tuala ne Aixiputo mulomu aloxo ne, la mukalanu anaxuou Iosepu sou uneꞌe noxou. Alaxu vilesisi ꞌo la milai milaanu Iosepu no nano no tani sou navunavu. Iosepu mulaa mukalu, la mulai sou musala saexu laxusou muxexe xe mutokolomo laixe. Xe iliꞌi la sou minoꞌu mulai noxou tatananu tuala. ");
INSERT INTO ata_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Mulai muxali noxou, la sou anu muvikalanuxu aipiepiena noxou aloxo ꞌo, “Eai la eaipiepiena, ia evile sou ululusou noxilo uasi. Eni elavu xo mivikalaleli lexe nini nalavusou nalulusou aipiepiena laaxu.” ");
INSERT INTO ata_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Xe Iosepu muavuti la muvikalanu tatananu tuala aloxo ꞌo, “Toxo tila, eni amomomo uasi, ia Lataua molusi ululusou aipiepiena noxine laaxu.” ");
INSERT INTO ata_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tatananu tuala muavuti la muvikalanuxu Iosepu sou aipiepienau aloxo ꞌo, “Eni eaipiepiena lexe, eni elai mo a atutulu no lexa Nailu paꞌumele, ");
INSERT INTO ata_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","xe emalei la ta kau muxatele tamei ta toxotoxoxaꞌa, vasimeꞌa ne muveli mo lovoxaꞌa misevile. Meꞌa no lexa mitelo mo a iꞌaniꞌani iaꞌeiaꞌe. ");
INSERT INTO ata_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Xe iliꞌi la, la ta kau muxatele tamei la mixali mutelo. Ia ta kau ane ne vasimeꞌa ne muꞌitaꞌitasi mo alaalamaneꞌisi. Eni alavusou amaisiꞌa ta kau seꞌi loxo ne lai ꞌo ne Aixiputo uasisi manina. ");
INSERT INTO ata_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Aneꞌi ta kau ane ne miavuti vaxa la miꞌiꞌa aneꞌi ane ta toxotoxoxaꞌa e emaisiꞌa tei. ");
INSERT INTO ata_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ia talavusou laixe uasi xo, miꞌiꞌa loxo ne ia vasimeꞌa uxali laixe uasi. Vasimeꞌa muꞌitaꞌita mo alaalamaneꞌi ne a uxoo nesi. Eaipiepiena aloxo ne xe ekuluke, la etulu. ");
INSERT INTO ata_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Xe eai muluꞌelai la, la eaipiepiena la. No anu aipiepiena ane ne, la emaisou uiti ngiangiaxu palepanu toxotoxoxaꞌa muxatele tamei no aiinu vilesisi. Uiti ngiangiaxu ne lingamo sou ivalitusou. ");
INSERT INTO ata_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Xe iliꞌi la, la emaisou uiti ngiangiaxu palepanu muxatele tamei la, ia atume ialuxu muili molu no lia xalee ane aso utetelo no anu muxutuxu mole uleme laixe uasi, palepalepanu ne kitukitusi. ");
INSERT INTO ata_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Xe aneꞌi ta uiti ane ne miavuti vaxa la mimalukusiꞌa ane ta toxotoxoxaꞌa e mixali mutelo tei ne. Ioxe, no kakau xe etulu, la ekalaa anaxoiꞌa ta mitema ane milavu no anu alualu iouiou ne Aixiputo sou mineꞌe sou eaꞌaloiꞌaxu aipiepiena noxilo ꞌo, ia vile noxiꞌa umomomo sou ululusou laaxu noxilo uasi manina.” ");
INSERT INTO ata_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Xe Iosepu muavuti la muvikalanu tatananu tuala ne Aixiputo ne aloxo ꞌo, “Aipiepiena tamei ne laaxu vilesisi. Lataua mulosienixu mimii ane anu uꞌoxonu uxali iliꞌi ane nemaisou. ");
INSERT INTO ata_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ta kau muxatele tamei ta toxotoxoxaꞌa mo vasimeꞌa muvelisi mo lovoxaꞌa misevile ne mo uiti ngiangiaxu palepanu toxotoxoxaꞌa muxatele tamei nemaisou no aiinu vilesisi ne laaxu vilesisi lexe tauu ie muxatele tamei. ");
INSERT INTO ata_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Xe ta kau muxatele tamei ane vasimeꞌa muꞌitaꞌita mo alaalamaneꞌisi ne mo uiti ngiangiaxu palepanu muxatele tamei ia kisou ngialanusi ne laaxu vilesisi lexe nenge ulai la taxolixu soli toxoxaꞌa tauu ie muxatele tamei. ");
INSERT INTO ata_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nalomu, aloxo elemolu noxine tei, Lataua mulosienixu mimii ane anu uꞌoxonu uxali iliꞌi ane nemaisou ne. ");
INSERT INTO ata_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ulai, la nenge nenge laꞌilali piena misevile sou taꞌou no anu, no anu tauu ie muxatele tamei. Tuala xalee vile no ano no tuala tila ne Aixiputo ꞌo paꞌusou uasi. ");
INSERT INTO ata_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Xe iliꞌi no anu tauu ie muxatele tamei ne lexe ukalu, la nenge taxolu no anu tauu ie muxatele tamei sou soli toxoxaꞌa manina. Umomomo sou evile uxavutalanu tauutauu ie ane xoluxolu lailaixe ta mitema mixolu sou ꞌosaꞌila no anu uasi, xo soli toxoxaꞌa ano ꞌo ne utaasinge mo uꞌoxo masuanenge ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Umomomo sou ta mitema ixavutalanu tauutauu ie ane aneꞌi mixoxoolu la miꞌoꞌou laꞌilali iouiou piepiena no anu la ua, xo soli toxoxaꞌa ane uxali noxinge ꞌo ne, utila manina misevile. ");
INSERT INTO ata_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Lataua mulosienixu mii vile tatila no anu aipiepiena tamei xo anu umasaxa lexe nini nalavu no anu mii ane sou anu uꞌoxonu uxali manina. Mii ane ne a ꞌalaꞌalai sou uxali. ");
INSERT INTO ata_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ioxe, maasi la nini napasipaa mo nasosovosou itema vile ane xavutalau lailaixe mo mulavu laixe manina sou usaxilaꞌu muamuaꞌixu xaixai no nano ne Aixiputo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Mo nasosovosiꞌa ta mitema seꞌi sou xaixai kalumo la sou isuꞌuli sou iiavelixu xoluxoluxaꞌa ta mitema laixe. Navikalaneꞌi pekiaꞌu lexe inoꞌu laꞌilali noxiꞌa ta mitema no nano no anu tauu ie muxatele tamei ane asou nenge taxoo no anu tei ꞌo la, ikalipalaꞌanu laꞌoluxu vile no anu laꞌoluxu taꞌuve ne sou ilai iꞌunanu no taasou laꞌilali no xalexalee tuala tila ꞌo ukalusi. Ka isaxilaꞌu laixe. ");
INSERT INTO ata_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Laꞌilali ane ne uai sou ta mitema iꞌou no nano no tauu ie muxatele tamei sou soli toxoxaꞌa ane uxali noxinge lexe tauu ie muxatele tamei sou xoluxolu lailaixe mo laꞌilali piepiena ukalu. Lexe nenge tamulinu xavutala ano ꞌo, la umomomo sou ta mitema isolixaꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Xe tatananu tuala ne Aixiputo ne, mulomusou xavutala ane ne la mutama pumuxu laixe no anu xavutalau, la sou iloꞌa ta mitema ta tatila sou xaixai noxou mimasaxa lexe imulinu aloxo Iosepu mulemolu ne. ");
INSERT INTO ata_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Xe anu muavuti la muvikalaneꞌi ta tatila sou xaixai noxou aloxo ꞌo, “Nenge umomomo sou taxalisou itema vile laixe loxo Iosepu ꞌo uasi. Itema e Lataua uleenu muxoo noxou.” ");
INSERT INTO ata_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Xe tatananu tuala muavuti la muvikalanu Iosepu aloxo ꞌo, “Eni elavu lexe Latauasi ane molu mulosienixu mimii ane nini nelemolu lexe uxali noxinge ꞌo, la sou anu lamanasi lexe ninisi ane nini namitema vile sou xavutala lailaixe mo nelavu laixe manina. Evile umomomo loxo nini uasi. ");
INSERT INTO ata_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Eni emasaxa lexe eni asosovosine sou nini naxali loxo itema tila sou nasaxilaꞌu taasilo. Mo ta mitema noxilo sou xalexalee tuatuala sou tuala tila ꞌo ne ilomuxenesi. No anu ualasi, eni tila noxine, ia nini nasaxilaꞌu tuala tila noxilo lai ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","La sou tatananu tuala ne Aixiputo muavuti la muvikalanu Iosepu aloxo ꞌo la, “Nalomu, vaimomo ꞌo eni amuxaxene sou nini naxali itema sou nasaxilaꞌu xalexalee tuatuala no nano no tuala tila ne Aixiputo ꞌo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Xe muavuti la mulaa ring no avolu simisou sou mulai mukelelixu noxou Iosepu avolu simisou. Ia ring ane ne, sosovo vile noxou tatananu tuala ne a muxolu no anu. Xe muavuti la mutokolomonu no anu tokolomo noxou laixe ka mutaa xapo xoulu vile vaxa no xolanu Iosepu. ");
INSERT INTO ata_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Xe muavuti la mulosou karisi sou ꞌotoꞌoto noxou ane tameisou sou utavulenu. Ta mitema iꞌava lexe, “Ngaxexesou voteꞌi! Ngaxexesou voteꞌi!” La sou musosovosou Iosepu sou muxali loxo itema sou usaxilaꞌu xalexalee tuatuala no xalee lia tila ne Aixiputo ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Xe tatananu tuala ne Aixiputo ne, muavuti la muvikalanu Iosepu aloxo ꞌo la, “Enisi eni tatananu tuala. Ia eni avikalaneni aloxo ꞌo, itema vile lai ꞌo umomomo sou uꞌoxonu mii vile no anu masaxa noxou vitanisi uasi manina. Lexe itema vile umasaxa uꞌoxonu mii vile, la anu utaliꞌisinexu tei o.” ");
INSERT INTO ata_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Xe tatananu tuala muavuti la mumoxoꞌu Iosepu no anu uala vile noxiꞌa ta Aixiputo. Mumoxoꞌu lexe Sapenati-Panea. Xe muavuti la, la muvaitaulaꞌinu Iosepu noxie sema vile ualasie lexe Asenata, eiae Potipera ꞌolu. Potipera ne anu itema sou uvala suluvixaꞌa ta maliava no tuala vile ilemolu lexe Eliopolisi. Xe Iosepu ne muavuti la muxixaoxao sou umaisou xalexalee tuatuala ukalusi no nano ne Aixiputo. ");
INSERT INTO ata_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iosepu ne tauu iexu muxali loxo mavulovexa tatalu, la sou anu musokou sou muxaxai noxou tatananu tuala ne Aixiputo. Xe muavuti la mulaa no taasou sou mulai mumuamuaꞌi no xalexalee tuatuala no nano no tuala tila ne Aixiputo mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","No nano no anu tauu ie muxatele tamei, la laꞌilali muxali tavuꞌalo mo muꞌokiꞌoki tani manina. ");
INSERT INTO ata_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","La sou Iosepu mumolo laꞌilali sou muꞌunanu no taataasou laꞌilali no tuatuala tila vilevilesi no nano no tuala tila ne Aixiputo. No anu tuala tila vilevilesi ne, muꞌunanu laꞌilali molu no xaixai no paꞌupaꞌumolu tuatuala vilevilesi ne. ");
INSERT INTO ata_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Iosepu mumolo laꞌilali tavuꞌalo misevile loxo ioꞌiioꞌi no tasiꞌi. Tavuꞌalo tavuꞌalo misevile, la sou anu umomomo sou uitisou uasi. ");
INSERT INTO ata_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Iliꞌi no anu tauu ie muxatele tamei sou soli toxoxaꞌa uxalisiꞌa uao, ia Iosepu ilee Asenata mipalaaneꞌi ta ꞌiliꞌa tamei ta mulu. Asenata ane eiae Potipera ꞌolu. ");
INSERT INTO ata_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","La sou muvikala lexe, “Lataua musuꞌulileli mole eni ieli siꞌisou tuꞌutuꞌumaxu ane muxali noxilo mo ieli siꞌisiꞌa mamilo iloꞌa ta viivilo mo ta minuminu no tualasixe noxiꞌa.” La sou mumoxoꞌu ꞌolu laposalaxu ne lexe Manase. ");
INSERT INTO ata_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Xe muavuti la muvikala la aloxo ꞌo, “Tavaꞌu xo Lataua molu muxalixaꞌa ta ꞌalixeni tamei no tuala ane eni eneꞌe exalisou tuꞌutuꞌumaxu no anu ꞌo, la eni amoxoꞌu ꞌalixeni ane tameisou ꞌo lexe Epalaimu.” ");
INSERT INTO ata_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tauu ie muxatele tamei sou laꞌilali mo xoluxolu lailaixe ne Aixiputo a muneꞌe muxali no telexu, ");
INSERT INTO ata_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","mo tauu ie muxatele tamei ane sou aneꞌi ixolixu soli toxoxaꞌa a musoko aloxo Iosepu mulemolu. Soli toxoxaꞌa mutaasou xalexalee tuatuala mukalusi, ia no nano no tuala ne Aixiputo muꞌisalili no tuatuala no xalee lia ne Aixiputo ukalusi ne laꞌilali a uxolu. ");
INSERT INTO ata_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ta mitema ne Aixiputo ixoxolu xe isolixaꞌa, la ilai ikatu noxou tatananu tuala ne Aixiputo, la sou anu molu upalusiꞌa ilai noxou Iosepu sou anu uvikalaneꞌixu mii ane aneꞌi iꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mixoxoolu xe, soli toxoxaꞌa ne muꞌokiꞌoki tani mo mutaasou xalexalee tuatuala ne Aixiputo ne mukalu, la sou Iosepu mukisiinu aiaitengaxu taataasou laꞌilali ne mukalusi sou ta mitema mineꞌe milotoxaꞌa laꞌilali. ");
INSERT INTO ata_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ta mitema meꞌa no xalexalee tuatuala mukalusi no paxapaxa ne, mineꞌe mixali noxou Iosepu ne Aixiputo ne sou ilotoxaꞌa laꞌilali noxou xo soli toxoxaꞌa ne muꞌokiꞌoki mo mutaasou xalexalee tuatuala neꞌei neꞌei ne mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ioxe, Iakovo iloꞌa ta ꞌolu ixoxolu no tualasiꞌa ne Kanani xe anu mamiꞌa mulavu lexe laꞌilali tavuꞌalo a uai ne Aixiputo, la anu muavuti la muvikalaneꞌi ta ꞌolu aloxo ꞌo, “Ngananavaa e ngataꞌotaꞌolu vitani ꞌo, ngaavuti mo ngaꞌoxo mii vile uasi? ");
INSERT INTO ata_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ngalomu! Eni elomu lexe ta mitema a ilalai ne Aixiputo sou ilolotoxaꞌa laꞌilali. Ngalai ane mo ngalotonenge, ua tasoisoli sou soli maasi.” ");
INSERT INTO ata_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Xe aneꞌi milomu vaxa noxou mamiꞌa aloxo ne, la sou aneꞌi Iosepu ta vimovimou mavulovexa vile milutu sou milai ne Aixiputo sou ilotoxaꞌa laꞌilali, ");
INSERT INTO ata_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ia mamiꞌa upalusou vimoꞌa soxu e kituꞌa, Iosepu vimou maninasou sou iloꞌa ilai uasi. Vimou soxu ne ualasou lexe Beniamini. Mamiꞌa umasaxa lexe umulineꞌi uasi xo loxo ꞌo io, male mii vile uꞌoxo masuanu no voteꞌi. ");
INSERT INTO ata_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ta mitema seꞌi ne Kanani ne milutu sou milai milotoxaꞌa laꞌilali, la aneꞌi Isilaeli ta ꞌolu mavulovexa ne milutu sou mimulineꞌi, xo soli tila ne mulai mutaasou xalee lia ne Kanani mukalu. ");
INSERT INTO ata_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Iosepu ne, anu muxali itema sou usaxilaꞌu tuala tila ne Aixiputo, mo ta mitema no xalee xalee tuatuala neꞌei neꞌei ne a ilalai noxou sou ilolotoxaꞌa laꞌilali. Xe anu ta vimovimou mineꞌe mixali noxou, la mixolaꞌu tavaꞌa sou mitulu no tavaꞌa voꞌuvoꞌuxu ka sou mitangatulu muluꞌelai no talaxu sou mitoxonu. ");
INSERT INTO ata_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Anu Iosepu ne, mumaisiꞌa ta vimovimou ne ka mutongoneꞌi, ia anu muavuti la muvivikalaneꞌi loxo anu ulavusiꞌa uasi. Muavuti la mutaliꞌi xatixati vaxa noxiꞌa aloxo ꞌo, “Ngingi menge neꞌei e ngeneꞌe ꞌo?” Xe aneꞌi miavuti la mivikalanu lexe, “Nexi mexe no xalee lia ne Kanani ane teneꞌe ꞌo, xo temasaxa lexe talotonexe laꞌilali.” ");
INSERT INTO ata_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Anu mulavusiꞌa xo mutongoneꞌi, ia aneꞌi ne itongonu uasi. ");
INSERT INTO ata_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Mumaisiꞌa mine aneꞌi mineꞌe sou mixolaꞌu tavaꞌa sou mitulutulu no tavaꞌa voꞌuxu sou mitangatulu muluꞌelai no talaxu, la anu muxavutalanu aipiepiena noxou e muai la mumaisou, ia anu muavuti la muvikalaneꞌi lexe, “Ngingi ta mitema ano ꞌo, ngingi ngeneꞌe ꞌo sou ngatulunexe sou ngalavu lexe tualasixe xalee anevaa ane pekiaꞌu uasi.” ");
INSERT INTO ata_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Xe aneꞌi miavuti la mikolinu vaikalau aloxo ꞌo, “Tila, uasi! Nexi teneꞌe ꞌo loxo nexi ta mitema vitanisi sou lexe talotonexe laꞌilali. ");
INSERT INTO ata_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nexi latala ꞌo ne, itema vilesisi ta ꞌolu, ia nexi teneꞌe sou tatulungenge uasi, xo nexi ta mitema ano ne, nexi ta mitema sou vaikala manina. Takalavoi uasi.” ");
INSERT INTO ata_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ia anu Iosepu muavuti la muvikala kiipali vaxa noxiꞌa, “Uasisi manina! Ngingi ngeneꞌe ꞌo sou ngatulunexe sou ngalavu lexe tualasixe xalee anevaa pekiaꞌu uasi.” ");
INSERT INTO ata_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Xe aneꞌi miavuti la, la mivikalanu la aloxo ꞌo, “Tila. Nexi ꞌo ne nexi itema vilesisi ta ꞌolu. Nexi itiitisixe muxali loxo mavulovexa mo mulelia tamei. Mo nexi sou xalee lia ne Kanani. Vivixe vile ne musoli, xe soxu e kaluxusixe a ilou mamixe mixolu.” ");
INSERT INTO ata_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Uasisi! Ngingi ngeneꞌe sou ngatulunexesi!” Anu Iosepu muavuti la muvikalaneꞌi aloxo ne la. ");
INSERT INTO ata_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","“Ia eni amasaxa lexe alavusinge manina no anu voteꞌi vile aloxo ꞌo. Eni atulu no xavi noxou tatananu tuala lai ne Aixiputo, la sou eni avikala manina aloxo ꞌo, umomomo sou ngingi ngalivu ulai no tualasinge uasi manina. Mole vivinge soxu e kaluxusinge ne lexe uneꞌe ꞌo mo eni amaisou no ieli maninasou. ");
INSERT INTO ata_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","La sou emasaxa lexe vile noxinge ne ulivu mo ulai unoꞌu uneꞌe, ia ngingi tavuꞌalo ne nganeꞌe ngaxoo no anu taasou navunavu ꞌo mo nexi takamuli mo talavu manina lexe ngingi ngevikala maninasou. Xe uasi, la eni atulu no xavi noxou tatananu tuala ne Aixiputo, la sou eni avikala manina lexe, ngingi ngeneꞌe ꞌo sou ngatulunexe manina.” ");
INSERT INTO ata_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Muvivikalaneꞌi aloxo ne xe mukalu, la munoꞌa sou mulai mitatuxaꞌa sou mixolu no nano no taasou navunavu voxo tatalu. ");
INSERT INTO ata_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Xe no voxo tatalusou, la anu Iosepu mulai sou muvikalaneꞌi aloxo ꞌo, “Ngalomu, eni ꞌo ne, eni alavusou ataxaanu Lataua misevile. La sou eni emasaxa lexe apamaulingengi no anu voteꞌi vile aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Lexe ngingi ta mitema sou ngavikala manina, la eni emasaxa lexe vile noxingesi ane maasi la ulivu mo ulai uxolu no nano no taasou navunavu e ngingi ngongiꞌa ngelai ngexoo no anu, ia ngingi muxatele tamiꞌasi ne, nganoꞌu laꞌilali e ngelotonu ne mo ngalivu ulai noxiꞌa maminge ilou ꞌolu mo ta mingemingengi e ixolu sou soli no tuala. ");
INSERT INTO ata_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ngalailixu laꞌilali ꞌo no tuala ukalu, la sou ngatilo vivinge soxu e kaluxusinge ne uneꞌe noxilo. Xo lexe eni amaisou no ieli maninasou, la sou eni alavu manina lexe ngingi ngevikala manina. La sou umomomo sou ngingi ngaulua uasi.” Aneꞌi milomu noxou aloxo ne xe mukalu la sou mimasaxa lexe imulinu aloxo anu mulemolu noxiꞌa ne. ");
INSERT INTO ata_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Xe aneꞌi miavuti la mivikalaneꞌi ngatoꞌo lexe, “Ngamaisou, nenge teꞌoxo masuanu vivinge la sou ane vaimomo ꞌo nenge texalisou tuꞌumaxu ano ꞌo lakoli ꞌilixo ne. Nenge nengeꞌa temaisou tuꞌumaxu toxoxaꞌa ane muxali noxou ne mo, anu soxu mutama muneꞌe noxinge sou tasuꞌulinu ne, ia nenge texiunu tumalingeusi. La sou ane nenge nengeꞌa talu tuꞌumaxu ano ane muneꞌe musuꞌasinge ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Xe Luven muavuti la mukolineꞌi ta vimovimou aloxo ꞌo, “Eni evikalangengi laixe lexe mamu ngaꞌoxo masuanu maulamenge soxu, ia ngingi ngalomuxo uasi, la sou ane nenge taxalisou tuꞌumaxu ano ꞌo lakolisou soli noxou ne.” ");
INSERT INTO ata_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ia Iosepu ta vimovimou ne ilavu lexe Iosepu mulavu no anu vaivaikala noxiꞌa e iꞌoxoꞌoxonu uasi, xo anu uvivikalaneꞌi no anu vaikala noxiꞌa ta Aixiputo ia, itema vile a sou uxiuxiunu ulai noxiꞌa no anu vaikalaiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Muvivikalaneꞌi aloxo ne xe tamaxu mulokolaxu, la mulai mutalume no nano mo mutama o. Xe mutama mukalu, la sou anu muuatulai noxiꞌa sou muvivikalaneꞌi la. Xe iliꞌi la sou mupalusiꞌa ta mitema sou xaixai noxou sou mitilaꞌu Simeoni mulai loxo noxiꞌa sou misakisakiinu no ieꞌi ta vimovimou ne. ");
INSERT INTO ata_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Xe muavuti la muvikalaneꞌi ta mitema sou xaixai noxou sou mitataa laꞌilali muꞌunalai no tivativaxaꞌa ta vimovimou ne, xe muvikalaneꞌi sou itataa lamoliꞌa ulivu no tivativaxaꞌa vilevilesi kalumo. Mo minoꞌuxaꞌa laꞌilali ane muxutu kalumo sou iꞌou tuxaneꞌi no voteꞌi. La aneꞌi miꞌoxonu aloxo anu mulemolu noxiꞌa ne. Xe ta mitema sou xaixai noxou miꞌoxonu aloxo anu mulemolu ne mukalu, ");
INSERT INTO ata_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","la sou aneꞌi Iosepu ta vimovimou ne mitelotelo tivativa sou laꞌilalixaꞌa e milotonu ne mutelo noxiꞌa ta donkiiꞌa vilevilesi sou milutu milai. ");
INSERT INTO ata_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Milutu milai xoo xe, ꞌolovoxo la mitaꞌolu sou miai. Xe vile noxiꞌa muavuti la mululusou tivaxu sou lexe ulaanu laꞌilali seꞌi sou uaꞌanu donki noxou sila, mumaisou lamoliu e mulotonu laꞌilali no anu ane uai no latanu laꞌilali no tiva anaxu ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Xe aliku ꞌo muavuti la muvikalaneꞌi ta vimovimou, “Ae, taemoso! Lamoli noxilo e elotonu laꞌilali ꞌo no anu ane mulivu muneꞌe noxilo ꞌo. Ngamalei, ane uai no laꞌilali ꞌo latanu no nano no tiva ꞌo.” Xe ta motu mimalei loxo ꞌo, la manina. Ka inavaa. ꞌEꞌeneꞌi ne mutelo mulokolaxaꞌa manina. Taneꞌi kalaua sou uꞌumesi. Xe miavuti la mitalitaliꞌisiꞌa ngatongatoꞌo, “Lataua muꞌoxonu ꞌilixo maꞌia ane loxo ꞌo noxinge ꞌo?” ");
INSERT INTO ata_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Milutu sou mimuamuaꞌi ilalai xoo xe, milai mixali noxou mamiꞌa Iakovo ne Kanani, la miaꞌaloxu mimii e muxali noxiꞌa ne Aixiputo ne aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Telutu e nepalusixe sou telai, xe texali ne Aixiputo, la itema tila ane usaxilaꞌu tuala ne Aixiputo ne, muvikala pekiaꞌu noxixe mo mukalavoisixe lexe nexi telai ne sou tatuluxaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Xe nexi teavuti la tevikalanu lamana lexe, ‘Nexi ta mitema sou tatulungenge uasi, nexi ꞌo, nexi ta mitema sou vaikala manina. ");
INSERT INTO ata_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Mo nexi ꞌo, nexi itema vilesisi ta ꞌolu. Nexi itiitisixe mulai muxali loxo mavulovexa mo mulelia tamei. Ioxe, iliꞌi, la vile musoli, xe soxu anu kaluxusixe a ilou mamixe mixolu no tualasixe.’ ");
INSERT INTO ata_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Xe itema tila ane usaxilaꞌu tuala ane ne muavuti la muvikalanexi aloxo ꞌo la, ‘Ngalomu, eni emasaxa lexe alavu manina lexe ngingi vaikalamengi ꞌo manina, la vile noxinge ne uneꞌe mo noxou taxolu, ia ngingi ane muxatele tamiꞌa ne ngatavule laꞌilalixaꞌa maminge ilou ꞌolu, mo ta mingemingengi no tuala mo ngalai. ");
INSERT INTO ata_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Xe ngalivu uneꞌe la, ngatilo vivinge soxu ane kaluxusinge sou nganeꞌe noxilo. Lexe eni amaisou soxu ne, la sou eni alavu manina lexe ngingi nganeꞌe sou ngatulunexe uasi mo lexe ngingi ngamitema sou kalavoi uasi. La sou eni alivunoxu vivinge ane uxoo noxilo ꞌo sou ulivu ulai noxinge. La sou ngingi nganeꞌe ngaxoo lai ꞌo sou ngavaivaoli sou nganoꞌu lamoli.’” ");
INSERT INTO ata_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mixali miaꞌalou mamiꞌa aloxo ne xe mukalu la sou aneꞌi vilevilesi ne milulusou tivativaxaꞌa sou milaasou laꞌilali e milai miloto ne, xe ieꞌi muvaxa loxo ꞌo la, lamoliꞌa soxisoxisou kalumo ane muai no nano no tivativaxaꞌa ꞌo, la mimamaꞌu misevile. Mamiꞌa kalumo ne mumamaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Xe muavuti la muvikalaneꞌi ta ꞌolu ne lexe, “Ngaꞌoxole mole eni ta ꞌalixeni tasitasiauxaꞌa noxilo ukalu io? Iosepu tasiauxu tei mo musuꞌa ne. Ka Simeoni ane kalumo tasiauxu ne. Ia ngingi a ngevikala lexe nganoꞌu Beniamini kalumo sou ngalailixu la. Ia talu la axoo laixe.” ");
INSERT INTO ata_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Xe ꞌolu Luven muavuti la muvikalanu momu aloxo ꞌo, “Anoꞌu mo alailixu, xe namalei lexe eni alivu uxali noxine ia, anu uasi, la sou eni melo anoꞌa ta ꞌalixeni ta mulu tamei ineꞌe noxine sou naveꞌa isoli. Naꞌitalonu Beniamini no avolo mo eni melo asaxilaꞌu sou alailixu ka alivunoxu uneꞌe noxine.” ");
INSERT INTO ata_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ia momu ne, pekiaꞌu misevile. Muavuti la muvikalaneꞌi ta ꞌolu, “ꞌAlixeni ꞌo umomomo sou umulingengi uasi manina, xo vimou ane musoli ne, ia anusisi soxusi ane noxou taxolu ꞌo. Ngalailixu uasi xo loxo ꞌo io, mii vile uvau no voteꞌi. Ngamalei, eni soxu ane a aululu manina mukalu, lexe mii vile masua uxali noxou la eni talelixu misevile mole eni asoli mo aluꞌelai no tualasiꞌa ta mitema sou soli.” ");
INSERT INTO ata_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ioxe, soli toxoxaꞌa muxali ne mulai mutaasou xalexalee tuatuala no lia ne Kanani mukalusi mole muꞌokiꞌoki tani manina. ");
INSERT INTO ata_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Iakovo iloꞌa ta ꞌolu miꞌou laꞌilali e ta ꞌolu milai milotonu ne Aixiputo ne mole mukalu. La sou mamiꞌa muavuti la muvikalaneꞌi, “Ta molomolo, ngalutu mo ngalai ngalotonenge laꞌilali seꞌi la.” ");
INSERT INTO ata_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Xe ꞌolu Iuda muavuti la muvikalanu aloxo ꞌo, “Ani, nexi talai. Ia aloxo nexi tevikalanenixu ne. Itema ne muvikala pekiaꞌu noxixe lexe anu umomomo sou umaisixe lexe nexi tanoꞌu Beniamini ulai sou umaisou, xe uasi, la anu umomomo sou nexi talai taxali noxou uasi. ");
INSERT INTO ata_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ia, lexe nini oponeni uꞌosasi mo naꞌitalonu Beniamini ne uneꞌesi mo noxiꞌa talai, la sou nexi talai sou talotonuxene laꞌilali. ");
INSERT INTO ata_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Xe uasi, la nexi umomomo sou talai uasi. Xo aloxo nexi tevikalaneni ne. Itema ne muvikala pekiaꞌu noxixe misevile lexe anu umomomo sou umaisixe lexe nexi tanoꞌu Beniamini ulai sou umaisou, xe uasi la anu umomomo sou nexi talai taxali noxou uasi.” ");
INSERT INTO ata_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Xe Isilaeli muavuti la muvikalaneꞌi aloxo ꞌo, “Ngingi ngeꞌoxonu tuꞌumaxu ano ꞌo musuꞌasilo manina. ꞌEi muvikalangengi lexe ngavikalanu itema ne lexe ngingi vivinge a muxolu no tuala?” ");
INSERT INTO ata_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Xe aneꞌi miavuti la mikolinu aloxo ꞌo, “Ua anu umolo taliꞌi misevile. Mutaliꞌisiꞌa ta mineminexi, xe mutaliꞌi lexe, ‘Maminge a uxoxoolusi ꞌo? Mo vivinge vile la uasi?’ La sou nalomu, anu molusi mutaliꞌisixe aloxo ne, la sou ane nexi tekolinu taliꞌi iou ne mukalusi. Nexi talavusou lexe anu uvikalanexi sou tanoꞌu vivixe soxu ꞌo ulai sou noxiꞌa talai noxou uasi.” ");
INSERT INTO ata_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Iuda muavuti la muvikalanu momu la, “Naꞌapixu mamu! Naꞌitalonusi uneꞌe noxilo mo noxiꞌa talai ane alalae ꞌosi xo loxo ꞌo io, nini mo nexi mo, ta ꞌiliꞌilixe mo ta semasemamexi kalumo ne massi la nenge nengeꞌa tasoisoli ukalusi no ꞌa soli ane ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Uneꞌesi mo noxiꞌa talai. Naxavutala piena uasi, eni melo asaxilaꞌu. Ia ulai xe namalei lexe eni alivunoxu uneꞌe noxine uasi, la susu ane ne anu susu noxilo. Ulai la vaikalasou utelo noxilosi mole maulixo ukalu. ");
INSERT INTO ata_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Lexe nini opoone uꞌosasi sou naꞌitalonu Beniaminisi mo noxiꞌa talai palea, la male ano ꞌo ne nexi telai mo telivu muneꞌe alaxu tamei mukalu.” ");
INSERT INTO ata_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Xe mamiꞌa Isilaeli muavuti la muvikalaneꞌi aloxo ꞌo, “Ioxe, nenge voteꞌi vile la sou tamulinu uasi, ia lexe nenge tamulinu aloxo ngelelemolu ne, la anu laixe musuku lexe ngingi ngalai, la ngatavule mimii seꞌi ane lailaixe musuku molu no lialia nenge ꞌo loxo lamalasile mo unuxu lexaxu mo mii ane tumaꞌu laixe sou laꞌilali mo ovu vile lexaxu tumaꞌu lailaixe mo laꞌuele lailaixe mo ngataataa no tivativangenge ulai xou itema tila ne loxo lolovolo noxinge ulai noxou. ");
INSERT INTO ata_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mo nganoꞌu lamoli ane sou ngaloto no anu xe ane mulivu muai no nano no tivativangenge. Xo loxo ꞌo io male, aneꞌi ieꞌi siꞌisou la mitaataa mulivu la. ");
INSERT INTO ata_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ngatilaꞌu vivinge soxu ꞌo mo ngapasipaa ngalivu ulai. ");
INSERT INTO ata_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Lataua anu xaviinu musuku, molu uꞌoxonu itema sou anu tanungenge la, ulivunoxu Beniamini ilou Simeoni ineꞌe noxinge. Ia lexe Lataua umasaxa lexe eni axovulauneꞌi ta ꞌalixeni, la eni axovulauneꞌisi.” ");
INSERT INTO ata_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Xe aneꞌi miavuti ꞌo la, mimolo mimii e mamiꞌa muvikalaneꞌixu lexe inoꞌu ne mo minoꞌu lamoli ane sou iloto laꞌilali no anu xe ane mulivu ꞌole. Xe mikasi vaxa noxou Beniamini ꞌo la, milai ne Aixiputo. Milai xe mixali, la milai mipalaꞌa avile noxou Iosepu iou. ");
INSERT INTO ata_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Xe anu Iosepu mumaisou Beniamini no taineꞌi, la muvikalanu itema vile sou xaixai noxou e sou usaxisaxilaꞌu taasou ne aloxo ꞌo, “Nanoꞌa ta mitema ꞌo mo nalailixaꞌa no tani noxilo, xo noxiꞌa taꞌani no aso lixinu. Ka nalai nasaꞌavunoxu kau vile mo navau. Navau ukalu, la sou ulai uxutu. Xe nalalaxii laꞌilali seꞌi sou noxiꞌa taꞌou ilou.” ");
INSERT INTO ata_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Itema sou xaixai mulomu aloxo ne xe mukalu, la sou anu munoꞌa Iosepu ta vimovimou ne sou mulailixaꞌa no tani noxou vimoꞌa ne. ");
INSERT INTO ata_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Munoꞌa sou mulailixaꞌa no tani, ka aneꞌi ne taneꞌi kalaua sou ꞌume, taneꞌi mukuni lexe, “Anu a uneꞌenenge ꞌo, xo tavaꞌu no anu lamoli e mulivu muneꞌe no tivativanenge loxo teneꞌe tei. Xe, la sou itetelisinge ka inoꞌa ta donkimenge ilaiiꞌa. Io sou aneꞌi inoꞌinge sou iꞌoxonenge taxali loxo ta mitema sou upalupalusinge sou taꞌoxoꞌoxo mixumixu.” ");
INSERT INTO ata_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Xe mimalei loxo ꞌo la itema sou xaixai noxou Iosepu e uxoxoolu no taasou sou usaxisaxilaꞌu ane muneꞌe mutulu no aitenga, la sou aneꞌi miavuti vaxa la mivikalanu lexe, ");
INSERT INTO ata_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ae, tila. Nexi teneꞌe alaxu vile tei sou telotonexe laꞌilali lai ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ia telivu, la telai temaꞌila no voteꞌi. Xe telulusou tivativanexe vilevilesi sou lexe tamaisou laꞌilali e, mitaataanexe ne, la tekuluke xo lamoli e nexi vilevilesi telosiꞌa lapee sou laꞌilali nexi tenoꞌu ꞌo, ane mulivu muneꞌe muai no tivativanexe ne. La sou nexi teneꞌe ꞌo sou talivunoxu lamoli ane ne, ");
INSERT INTO ata_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","xe tenoꞌu ane sou nexi talotonexe laꞌilali seꞌi la no anu. Nexi tanexi liliu lamoli ane mulivu ꞌo xo, nexi talavusou itema ane mulivunoxu uasi manina.” ");
INSERT INTO ata_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Xe anu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngaxavutala piena uasi. Mo ngaꞌume uasi. Male Lataua noxinge, anu Lataua noxou mamingesi ane mulivunoxu lamolimengi ne. Ia mii vile uasi, xo lamoli ne a enoꞌu.” Xe iliꞌi la sou mulai munoꞌu Simeoni sou muneꞌenu noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Munoꞌu Simeoni muneꞌe noxiꞌa mukalu, la sou muoleneꞌi sou muꞌunalailixaꞌa no nano no tani noxou vimoꞌa ne. Xe muavuti la mulai mutau lexa mulailixu noxiꞌa sou miꞌuinu tavatavaꞌa no anu, xe mukalu la mulai muꞌaꞌaneꞌi ta donkiiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mixoxoo no nano ne sou mixoxoomaiou Iosepu sou uneꞌe sou iloꞌa iꞌani, la aneꞌi mipitanu mimii seꞌi lailaixe ane aneꞌi minoꞌu no tualasiꞌa muneꞌe sou ilolovoloxu no anu. ");
INSERT INTO ata_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mixoxoo xe aso lixinu la anu Iosepu muneꞌe muxali noxiꞌa ꞌo. Xe aneꞌi mipasipaa ꞌo la, milai noxou sou milolovoloxu no anu mimii seꞌi e minoꞌu no tualasiꞌa muneꞌe. Xe miavuti la mitulutulu no tavaꞌa voꞌuvoꞌuxu no talaxu sou mitangatulu muluꞌelai noxou sou mitoxonu. ");
INSERT INTO ata_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Xe anu muavuti la mutaliꞌisiꞌaxu maulixaꞌa, lexe aneꞌi laixeneꞌisi. Xe muavuti la muvikala lexe, “Ngeneꞌe tei, la ngeaꞌaloxenixu aululu maminge soxu lexe anu a uxoxoolu no tuala, la loxovaa noxou? Anu a uxoxoolu laixenusi?” ");
INSERT INTO ata_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Xe aneꞌi miavuti mivikalanu vimoꞌa ne lexe, “Tilasixe, mamixe ne anu soxu a uxoxoolu mo laixenusi.” Xe miavuti la mitulutulu no tavaꞌa voꞌuvoꞌuxu muluꞌe no talaxu la, sou mitangatulu muluꞌelai noxou sou mitoxonu la. ");
INSERT INTO ata_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Xe Iosepu iou muvaxa la mumaisou vimou soxu e ualasou lexe Beniamini anu vimou manina ilou neniꞌa vilesisi la sou mutaliꞌisiꞌa lexe, “Vivinge sou ane kaluxusinge e, ngevikalalelixu ano ꞌo?” La sou iou mulai noxou Beniamini sou muvikalanu lexe, “ꞌEi soxu, Lataua uxoo noxine mo ualusine.” ");
INSERT INTO ata_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Xe muavuti no lia noxiꞌa ta vimovimou ne la mulai avile no nano no taasou xo mumaisou vimou Beniamini la tanuxu misevile. La ꞌalaꞌalai sou utama no ieꞌi. La sou ane anu mulai mutalumeiou tamaxu no anu sou mutama. ");
INSERT INTO ata_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mutama mukalu, la mulai muꞌuinu iou. Ka sou muuatulai no ale ne la tamaxu mulokolaxu ne ia pekiaꞌusi sou muvikalaneꞌi ta mitema noxou sou inoꞌu laꞌilali uneꞌe sou ulosiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Aneꞌi minoꞌu laꞌilali ne mukalu la sou Iosepu ne, milai mimuxaxu naꞌu no luu vile vaꞌaxu sou anusisi mulai muxolu sou munoꞌu. Xe ta vimovimou ne, milai mikalineꞌi sou miꞌani no luu vile vaꞌaxu mo. Xe ta mitema seꞌi ne Aixiputo e iloꞌa Iosepu ixoxolu no tani noxou ne, miꞌani vaꞌaxu mo, xo ta Aixiputo ne, ilavusou iloꞌa ta Evalaio ixolu ipipita sou iꞌaniꞌani uasi. ");
INSERT INTO ata_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Aneꞌi iloꞌa ta Evalaio ixolu ipita la, ane ne masua misevile noxiꞌa ta Aixiputo. Xe aneꞌi ta vimovimou mimaisou mine aneꞌi mixoluxolu loxo no talaxaꞌa mulai noxou, la mikuluke, la ieꞌi mukaaiꞌa ngatongatoꞌo. Xo aneꞌi mitaꞌolu sou miꞌani ne la, vimoꞌa ane laposalaxu muxolu tei, ka sou vimoꞌa ane tameisiꞌa ka tatalusiꞌa xoo la sou mulai mutalo noxou Beniamini. ");
INSERT INTO ata_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Xe ta mitema sou xaixai noxou anu Iosepu miavuti la, ivavauxaꞌa ta vimovimou laꞌilali ne molu loxo no luu sou naꞌu laꞌilali ne, ulalai loxo noxiꞌa. Vimoꞌa soxu e Beniamini ne, mivau xou laꞌilali piena misevile loxo umomomo noxiꞌa ta mitema taꞌuve sou iꞌou. Aneꞌi iloꞌa Iosepu miꞌani mo miie. ");
INSERT INTO ata_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Xe iloꞌa miꞌani mukalu, la sou Iosepu muvikalanu itema e sou usaxilaꞌu taasou ne aloxo ꞌo, “Nalai mo namoloxaꞌa ta mitema ꞌo laꞌilali mo nataataa uꞌuna no tivativaxaꞌa vilevilesi mo uꞌanaꞌana manina. Nataataa e piena. Xe ukalu la, nataataa lamoliꞌa vilevilesi ne ulivu ulai no nano no tivativaxaꞌa vilevilesi. Namuxaxu teiteixi no tivativaxaꞌa anaanaxu. ");
INSERT INTO ata_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ia vimoꞌa soxu e kaluxusiꞌa ne, nanoꞌu kapuxo siliva ꞌo, ka nataanu ilou lamoli ulai no nano no tivaxu.” Xe anu itema ne muavuti la, alaxu vilesisi. Muꞌoxonu mimii ne mukalusi aloxo tatilasou mupelaꞌuxu ne. ");
INSERT INTO ata_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Iloꞌa miai xe mitulu no kakau manina, la ta mitema sou xaixai noxou Iosepu ne misaxaneꞌi iloꞌa ta donkiiꞌa sou milai. ");
INSERT INTO ata_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Milutu mo miꞌumesou tuala tila ne mo ilai no paxa uao ia, Iosepu muavuti la muvikalanu itema sou xaixai noxou e usaxisaxilaꞌu taasou ne aloxo ꞌo, “Nalutu mo namulineꞌi ta aliku e milivu alalae ꞌo mo lexe naxalisiꞌa la nataliꞌisiꞌa aloxo ꞌo, ‘Loxovaa ane nexi teꞌoxo laixe noxinge ia, ngingi ngekoli no anu masua ꞌo la ngepakalinu tila noxilo siliva kaluxu o?’ ");
INSERT INTO ata_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kapu ane ne anu uie no anu xe sou ulavu no anu sou umaisou mii ane utalume kalumo. Susu ane ngingi ngeꞌoxonu ꞌo anu mutila misevile!” ");
INSERT INTO ata_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Xe anu itema sou usaxisaxilaꞌu taasou Iosepu ne muavuti ꞌo la mumulineꞌi anu Iosepu ta vimovimou ne xoo la, mulai muxalisiꞌa. Xe muavuti la, muvikalaneꞌi aloxo tila noxou mupelaꞌu ne. ");
INSERT INTO ata_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Xe aneꞌi miavuti la mikolinu, “Ae, tila. Taliꞌimeni ne laaxu loxovaa? Nexi tanexi lili. Nexi telavu lexe nexi taꞌoxo ꞌilixo vile loxo ne uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Namaisou, nini nelavu lexe nexi mexe no lia xalee ane ne Kanani sou telivu teneꞌe ꞌo la nexi tenoꞌu lamoli e texalisou no tivativanexe anaanaxu vilevilesi sou telivunoxu muneꞌe. Ia nexi tapakalinu xoulu ilou siliva no taasou tila noxine loxo ne mole loxovaa o?” ");
INSERT INTO ata_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Xe miavuti moso la misolonu vaikalaiꞌa mulai noxou itema ne aloxo ꞌo la, “Ae, tila. Lexe nini naxalisou vile noxixe ꞌo munoꞌu kapu ne, la uulua avilesi. Ia nexi latala ꞌo, nexi taxolu noxine sou napalupalusixe sou taꞌoxoꞌoxo mixemixene.” ");
INSERT INTO ata_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Xe anu muavuti la muvikalaneꞌi lexe, “Ua maꞌi, eni emasaxa aloxo ne. Anu ane lexe eni axalisou kapu noxousi, ane eni anoꞌu sou ulai uxolu noxilo sou eni apalupalusou sou uꞌoxoꞌoxonu mixomixo, ia ngingi latala nesi ngalivulivu ulai no tualasinge.” ");
INSERT INTO ata_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Xe aneꞌi milomu aloxo ne, la mitaꞌolunu tivativaxaꞌa no lia alaxu vilevilesi. Ka meꞌa milulusou tivativaxaꞌa ne anaxu vilevilesi. ");
INSERT INTO ata_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Xe milulusou mukalu, la sou anu itema ne molu muneꞌe sou mukamuli kapu ne no nano no tivativaxaꞌa. Uxilexilenu tivativa ne laixe loxo ꞌo. Musoko noxou vimoꞌa ane laposalaxu xoo la sou, mulai musivitanoxu noxou soxu e kaluxusiꞌa. La sou muxalisou siliva kapu tila noxou ane noxou Beniamini no tiva. ");
INSERT INTO ata_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ta vimovimou mimalei loxo ꞌo la manina. Xe miavuti la misinasinanu tokolomoiꞌa no vasimeꞌa vilevilesi ne mukalu. Xo taneꞌixu misevile. Xe miavuti no lia ꞌo la, mitelo mixamixaꞌa no lataneꞌi ta donkiiꞌa alaxu vilesisi, xe miavuti la milivu mulai ne Aixiputo. ");
INSERT INTO ata_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Milivu xe milai mixali no tani noxou Iosepu ne, la anu Iosepu a uxoxoolu no taasou nesi o. Iuda iloꞌa ta vimovimou miꞌunalai no taasou la mitulutulu no tavaꞌa voꞌuvoꞌuxu sou mitangatulu muluꞌelai no talaxu vimoꞌa sou mitoxonu ne. ");
INSERT INTO ata_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Xe anu muavauti la mutaliꞌisiꞌa, “Ngingi ngeꞌoxonu ꞌilixo maꞌi ane loxo ꞌo? Ngalavu lexe itema vile loxo eni umomomo sou ulavu mii ane utalume uasi?” ");
INSERT INTO ata_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Vimou Iuda muavuti la mukolinu aloxo ꞌo, “Tila, nexi talemolu mii maꞌia la ulai noxine? Mo nexi tavikala piepiena sou taxilili lexe nexi taꞌoxonu mii ano ꞌo uasi, loxovaa e Lataua molusi mupalaꞌalixu susu noxixe ꞌo io. Maasi la nexi latala ukalusi ꞌo ne, nini nanoꞌixe sou nexi taxolu noxine sou napalupalusixexu mixemixene sou nexi taꞌoxoꞌoxonu. Ia anu ane munoꞌu kapuxenesi uasi. Nexi noxiꞌa ukalusi.” ");
INSERT INTO ata_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Xe Iosepu muavuti la muvikala aloxo ꞌo, “Uasi manina! Umomomo sou eni aꞌoxonu loxo ne uasi! Anu ane munoꞌu kapusi ane anu uxolu noxilo sou apalupalusou sou uꞌoxoꞌoxo mixomixo. Ia, ngingi latala nesi mii vile noxinge uasi. Tangengi uai laixesi mo ngalivu ulai noxou maminge.” ");
INSERT INTO ata_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Xe Iuda muavuti la musuku mulai ꞌalai noxou Iosepu ka muvikalanu aloxo ꞌo, “Tatila noxilo. Eni emaisine la nini aloxo tatananu tuala ne Aixiputo manina. Ia naꞌapixo mamu, ieni uvaxailosi mo avivikalaneni ꞌo. Ia laꞌiaxeneꞌilo mamu. ");
INSERT INTO ata_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nalomu, no voxo ane loxo nexi teneꞌe tei, la nini netaliꞌisixe lexe, ‘Maminge a uxoxoolu mo vivinge vile la uasi?’ ");
INSERT INTO ata_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","La sou nexi tevikalaneni lexe, ‘Ua maꞌi, mamixe soxu ne aululu. Anu a uxoxoolu. Ilou vivixe soxu ane kalusixe. Anu mamixe soxu ne, aululu ia, anu mupalaa vivixe soxu ne. Mo vimou vile kalumo, ia vimou ne musoli. Aneꞌi ilou neniꞌa vilesisi, ia anu vimou soxu nesi ane umauli uxolu ne. Momu tanuxu mo usaxilaꞌu laixe misevile.’ ");
INSERT INTO ata_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ia tatila, nini nevikalanexi lexe nexi talai tanoꞌu mo taneꞌenu noxine mo namaisou. ");
INSERT INTO ata_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Xe nexi teavuti la tevikalaneni lexe anu umomomo sou uꞌumesou momu uasi, xo maasi xe anu uꞌumesou la momu soxu ne anu ukalu. ");
INSERT INTO ata_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Xe nini neavuti la nevikala toxoxaꞌa noxixe lexe nexi umomomo sou namaisixe lexe nexi tanoꞌu vivixe ane kaluxusou uneꞌe noxine. Xe uasi, la umomomo sou nexi taneꞌe taxali noxine uasi. ");
INSERT INTO ata_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nexi telomu noxine aloxo ne xe mukalu, la sou nexi telutu sou telivu mulai noxou mamixe la teaꞌaloxu vaivaikalameni e nevikalanexixu. ");
INSERT INTO ata_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Xe anu muavuti la mupalusixe sou talivu uneꞌe ꞌo la sou taloto laꞌilali sevile la. ");
INSERT INTO ata_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Xe nexi teavuti la tevikalanu lamana aloxo ꞌo, ‘Nexi umomomo sou talai uasi. Xo maasi xe nexi talai, la umomomo sou tila opoonu usexelaixe sou nexi talai noxou uasi manina. Ia lexe nexi tanoꞌu vivixe ane kaluxusou ꞌo ulai, la sou anu opoonu usexelanexe sou nexi talai taxali noxou aloxo anu molu mulemolu noxixe ne.’ ");
INSERT INTO ata_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Anu mamixe soxu muavuti la mukolinu vaikalamexi ne aloxo ꞌo, ‘Ngingi ngelavu lexe semaxeni mivoꞌoneꞌi ta ꞌalixeni ta mulu tamei. ");
INSERT INTO ata_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Vile ane muꞌumesilo tatei mo ne. Male ta mii seꞌi mivau ne, xo amaisou uasi xoo mole ane muneꞌe mutalo vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ia maasi xe ngingi nganoꞌu soxu ꞌo sou ngalailixu xe mii vile uvau no voteꞌi, ka eni asolisi mo aluꞌelai no tualasiꞌa ta mitema sou soli. Xo eni soxu ane aaululu ukalu ꞌo. La tuꞌumaxu ane ne umomomo sou ukalusou maulixosi.’ ");
INSERT INTO ata_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Ia vaimomo ꞌo, tatila nalomu lexe eni alivu ulai noxou mamilo xe anu umaisou maulu ꞌo no tavaꞌilo uasi, la anu ukalu soxu. Xo ꞌolu nesi ane anu ꞌeꞌenu manina ane. Mamixe soxu ne anu aululu maninanu. Ia lexe nexi talivunoxu ꞌolu ne uasi, la nexi mexe taolexu soxusi la, anu usoli mo uluꞌelai no tualasiꞌa ta mitema sou soli. ");
INSERT INTO ata_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Anu mamilo ne muꞌapixu ꞌolu ne pekiaꞌu misevile. Ia eni melo eavuti la epalaꞌalixu masaxa noxilo maninasou mulai noxou aloxo ꞌo, ‘Naxavutala piena uasi, uneꞌe la sou eni melo asaxilaꞌu. Ia ulai xe namalei lexe eni alivunoxu uneꞌe noxine uasi, la tuꞌumaxu ano ꞌo ne, vaikalasou utelo ane noxilo ꞌosi mo ulai utalo lexe eni akalu.’ ");
INSERT INTO ata_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","La sou nalomu, eni emasaxa aloxo ꞌo, eni anoꞌu tanixu maulu ꞌo mo axoo noxine ꞌo sou napalupalusilo sou aꞌoxoꞌoxonu mixemixene, ia naꞌitalonu soxu mo ulai noxiꞌa ta vimovimou mo iloꞌa ilivu. ");
INSERT INTO ata_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Lexe maulu ꞌo nexi noxou talivu ulai noxou mamixe uasi, la enisisi alai axali noxou loxovaa o? Xo eni amasaxa lexe amaisou tuꞌumaxu ano ꞌo uvilaꞌisou mamilo uasi.” ");
INSERT INTO ata_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iuda uvivikalanu aloxo ne la Iosepu ne tamaxu mulokolaxu mukalu sou lexe utama. La sou muvikalaneꞌi ta mitema sou xaixai noxou sou milaalaa mulai no ale ia anusisi iloꞌa ta vimovimousi mixolu no nano ne sou anu mupalaꞌalixu mulai noxiꞌa lexe anu Iosepu, vimoꞌa. ");
INSERT INTO ata_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Xe mutaloxu iii mie ꞌoluꞌolu uasi manina la ta mitema ne Aixiputo iloꞌa ta mitema sou ixoxolu no taasou tatananu tuala ne milomusou. ");
INSERT INTO ata_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Iosepu muavuti la muvikalaneꞌi ta vimovimou aloxo ꞌo, “Eni Iosepu a, loxovaa, mamilo a uxoxoolu laixesi?” Xe ta vimovimou milomu vaxa noxou aloxo ne, xe miꞌume misevile la milemolu maꞌia. ");
INSERT INTO ata_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Anu muavuti la muvikalaneꞌi, “Ngasuku uneꞌe ꞌalai noxilo.” La aneꞌi misuku mulai noxou. Xe anu muavuti la muvikalaneꞌi la, “Eni vivinge Iosepu a, ngingi menge ngenoꞌilo ka ngeꞌitaloleli no avoꞌa ta mitema ne Midiani sou milotoleli, la sou minoꞌilo mineꞌeleli ne Aixiputo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ia mamu ngaxavutala piena mo mamu ngamaela no anu ꞌilixo ane ngeꞌoxo noxilo ne uasi, xo eni elavusou lexe Latauasi ane Anu molu mupalusilo sou eni euli muneꞌe ꞌo sou apamaulineꞌi ta mitema. ");
INSERT INTO ata_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Soli toxoxaꞌa te muxali ꞌo, uao tauu ie sou tamei ano ꞌo. Ia tauu ie tauꞌve a uao uxolu ꞌo. Umomomo sou evile uxaxai mo ukookooli la uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Lataua molusi mupalusilo sou euli eneꞌe ꞌo sou apamaulingengi ngongiꞌa ta xasixasinge iloꞌa ta ꞌilusulusungengi mo sou mamu ngasoisoli. Voteꞌi ane Lataua muꞌoxonu ꞌo iou vile mo. ");
INSERT INTO ata_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","La sou eni emasaxa lexe ngingi ngalavu lexe ngingi ngapalusilo uneꞌe ꞌo uasi. Lataua ane anu molu mupalusilo eneꞌe ꞌo. Anu muꞌoxole exali loxo tatananu tuala ne Aixiputo momu loxo molomolo vile momu usaxilaꞌu mo asaxilaꞌa ta mitema no taasou ne ukalusi mo amitema sou saxisaxilaꞌu siꞌa ta mitema no xalexalee tuatuala no nano ne Aixiputo ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ia alalae ꞌosi ꞌo, ngapalea mo ngalivu ulai noxou mamilo mo ngavikalanu aloxo ꞌo, ‘Vaikala ano ꞌo molu noxou ꞌiline Iosepu, muvikala aloxo ꞌo. Lataua munoꞌilo muneꞌeleli ne Aixiputo ꞌo mole muꞌoxole exali loxo itema sou saxisaxilaꞌusiꞌa ta mitema no xalexalee tuatuala lai ꞌo. Ia naxoxoolu la uasi, napalea uneꞌe noxilo. ");
INSERT INTO ata_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Naneꞌe la sou naxolu ne Xosen ꞌalai noxilo. Ngongiꞌa ta ꞌiliꞌiline mo ta xasixasine mo ta sipsipmengi iloꞌa ta mee, mo ta kau mo lavulavulutimengi tavuꞌalo ukalusi ne. ");
INSERT INTO ata_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Naneꞌe naxolu ne Xosen ꞌo mo sou eni asaxilaꞌine, xo soli tila e muxali ꞌo ne, tauu iexu taꞌuve a uao. Eni emasaxa aloxo ne, xo emasaxa lexe ngingi ngongiꞌa ta ꞌiliꞌiline mo ta xasixasine mo ta minemine latala iloꞌa ta sipsipmeni, mo ta mee iloꞌa ta kau ne mamu ngaxolu sou soli lai ne.’” ");
INSERT INTO ata_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Xe muavuti la muvikalaneꞌi ta vimovimou aloxo ꞌo la, “Emasaxa lexe ngingi mo vivilo Beniamini ꞌo, ngamaisilo mo ngalavusilo. Evile uasi, eni Iosepusi ane avivikalangengi ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ngalai mo ngavikalanu mamilo lexe eni eneꞌe exolu ne Aixiputo ꞌo la, miꞌoxole exali itema tila vile manina. Mo ngavikalanuxu mimii tavuꞌalo e ngemaisou lai ꞌo. Ioxe ngapalea ulai mo nganoꞌu mamilo uneꞌe ꞌo.” ");
INSERT INTO ata_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Muvivikalaneꞌi aloxo ne xe mukalu, la sou muavuti sou mulai muꞌaulaxu vimou Beniamini la mutama. Xe anu Beniamini kalumo muꞌaulaxu vimou la mutama. ");
INSERT INTO ata_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Xe muavuti la musuku mulai noxiꞌa ta vimovimou ꞌole sou mutimunu xalexaleneꞌi. La tama ꞌa ululuꞌe noxiꞌa. Iloꞌa mitama mukalu, la sou ta vimovimou taneꞌi laixe sou iloꞌa mivivikala. ");
INSERT INTO ata_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Xe iliꞌi xe aꞌalosiꞌa anu Iosepu ne iloꞌa ta vimovimou mulai muxali noxou tatananu tuala ne Aixiputo iloꞌa ta tatila sou xaixai noxou, la oponeꞌi muꞌosa misevile. ");
INSERT INTO ata_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Xe anu tatananu tuala ne Aixiputo ne muavuti la muvikalanu Iosepu aloxo ꞌo, “Navikalaneꞌi ta viivine mo itelo tivativasou laꞌilalixaꞌa noxiꞌa ta donkiiꞌa mo ilivu ulai no xalee lia ne Kanani, ");
INSERT INTO ata_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","mo inoꞌu maminge iloꞌa ta mingemingengi ane mixoluxolu ꞌole mo ilivu ineꞌe noxilo. La sou eni aꞌitalonu lia xalee vile ane laixe mo lovoxu misevile lai ꞌo sou ngaꞌani laixe. ");
INSERT INTO ata_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Navikalaneꞌi mo inoꞌu karisi seꞌi ne Aixiputo ꞌo kalumo sou iteloneꞌi ta ꞌiliꞌiliꞌa iloꞌa ta semasemaiꞌa mo maminge ngongiꞌa mo inoꞌa ineꞌeneꞌi ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ixavutala no anu mimii e iꞌumesou ne Kanani ne uasi, xo mimii ane lailaixe lai ꞌo ne, aneꞌi naꞌasi.” ");
INSERT INTO ata_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ioxe, aneꞌi Isilaeli ta ꞌolu miavuti la miꞌoxo aloxo tatananu tuala mulemolu noxiꞌa ne. Iosepu mulosiꞌa karisi aloxo tatananu tuala mulemolu ne mo laꞌilali kalumo sou iꞌou tuxaneꞌi no voteꞌi. ");
INSERT INTO ata_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Mulosiꞌa ta vimovimou ne tokolomo vilevilesi, ia vimou Beniamini ne, mulosou taꞌuve xe lamoli siliva alelaxu itemaxu mavulovexa vile mo itemaxu taꞌuve (300). ");
INSERT INTO ata_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Xe muavuti la musovaneꞌi iu momu ta donki ta mulu mavulovexa vile la mutelonu mimii lailaixe ne Aixiputo noxiꞌa, xe ta donki ta sema mavulovexa vile kalumo la mutelonu momu laꞌilalixu mo laꞌilali seꞌi kalumo sou voteꞌi. ");
INSERT INTO ata_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Mulosiꞌa mimii ne mukalu, la sou mupalusiꞌa sou milivu milai, la muvikalaneꞌi aloxo ꞌo, “Ngalai ia ngaꞌotoꞌoto no voteꞌi uasi.” ");
INSERT INTO ata_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","La sou aneꞌi milutu ne Aixiputo ne sou mitelai ne Kanani sou milai noxou mamiꞌa Iakovo. ");
INSERT INTO ata_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Milai mixali la miaꞌalou mamiꞌa aloxo ꞌo, “Iosepu usoli uasi! Anu a uxoxoolu! Anu muxali loxo itema sou saxisaxilaꞌu sou xalexalee tuatuala no nano ne Aixiputo mukalusi!” Xe mamiꞌa mulomu aloxo la mukuluke la ulee muvava avile, ia anu muloxomale lexe aneꞌi ikakalavoinusi. ");
INSERT INTO ata_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ia aneꞌi mivikalanuxu vaivaikala e anu Iosepu muvikalaneꞌixu, xe mumaisou karisi e anu musova muneꞌe sou unoꞌu ulai ne Aixiputo, la tanu ne muai seꞌisisi loxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Xe Isilaeli muavuti la muvikala aloxo ꞌo, “Manina musuku! Eni elavu lexe ꞌalixeni Iosepu usoli uasi. Anu laixe lexe eni alutu mo alai amaisou tei ꞌo, ka sou asoli.” ");
INSERT INTO ata_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isilaeli mulomu aloxo ne xe mukalu, la mutaxusou miumiu sou iloꞌa ta ꞌolu iloꞌa ta semasemaiꞌa mo ta ꞌiliꞌiliꞌa mo ta minemineꞌi latala ne mivula sou milai ne Aixiputo. Milutu xe milai mixali ne Beru-seva, la anu muꞌelaxaꞌa ta sipsip seꞌi lai ne mulai noxou Lataua. Anu Lataua noxou momu Aisaki. ");
INSERT INTO ata_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Xe no ꞌolovoxo, la Lataua muxali noxou la mumaisou loxo ta mitema imaisou mii no anu aipiepiena. La muꞌavalou, “Iakovo! Iakovo!” Xe Iakovo muavuti la mukolinu aloxo ꞌo, “Maꞌia ne! Eni ꞌa!” ");
INSERT INTO ata_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Xe Lataua muavuti la muvikalanu aloxo ꞌo, “Eni Lataua, Lataua noxou mamine. Nalutu mo nalai ne Aixiputo, ia naꞌume mamu, xo eni axalixaꞌa ta ꞌiline mo ta xasixasine mo ta ꞌiluꞌilusuneni sou ixali ta mitema tavuꞌalo sou tuala vile toxaxaꞌa manina lai ne. ");
INSERT INTO ata_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Eni amulineni sou nengei talai taxolu ne Aixiputo ne. Xe iliꞌi, la eni anoꞌa ta xasixasine iloꞌa ta ꞌiluꞌilusuneni sou alivulixaꞌa ineꞌe no liangenge ngongiꞌa ne la. Nalai naxoo ne xe, no voxo ane sou nasoli, la Iosepu uxoo alai noxine.” ");
INSERT INTO ata_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ioxe, Iakovo mulutu sou muꞌumesou tuala ne Beru-seva la, Iakovo ta ꞌolu mitelonu anu mamiꞌa ne iloꞌa ta xasoxasou iloꞌa ta neeniꞌa no anu karisi e tatananu tuala ne Aixiputo musova mulai sou milailixaꞌa. ");
INSERT INTO ata_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Minoꞌa ta kauiꞌa iloꞌa ta sipsipiꞌa mo ta meeiꞌa mo lavulavulutiꞌa tavuꞌalo ne Kanani ne sou milai ne Aixiputo. Ta minuminu latala ne munoꞌa sou iloꞌa milailai. ");
INSERT INTO ata_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Munoꞌa ta ꞌolu ta mulu mo ta xasoxasou ta mulu mo ta ꞌolu ta sema iloꞌa ta xasoxasou ta sema sou iloꞌa milai. ");
INSERT INTO ata_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aneꞌi anu Isilaeli munoꞌa sou milai ne Aixiputo ne, ia ta ꞌolu ta mulu ualaualasiꞌa aloxo ꞌo. Luven, anu ꞌolu laposalaxu, ");
INSERT INTO ata_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","iloꞌa ta ꞌolu. Ta ꞌolu ualaualasiꞌa ane, Kanoko ilou Palu mo Esuloni ilou Kami. ");
INSERT INTO ata_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeoni xe ta ꞌolu. Ta ꞌolu ualaualasiꞌa ane, Iemuelu ilou Iamin mo Oꞌadi ilou Iakin mo Sokaru mo Saulo. Saulo ne, sema vile ne Kanani ꞌilie. ");
INSERT INTO ata_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi kalumo iloꞌa ta ꞌolu. Ta ꞌolu ualaualasiꞌa ane, Xeson ilou Koati mo Merari. ");
INSERT INTO ata_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Iuda iloꞌa ta ꞌolu kalumo. Ta ꞌolu ualaualasiꞌa ane, Peresi ilou Selau. Ta ꞌolu tamei la ane, Eru ilou Onani. Ia ilou misoisoli ne Kanani. Iuda ꞌolu vile e ualasou lexe Peresi mupalaaneꞌi ta ꞌolu la ualaualasiꞌa ane, Esuloni ilou Amulu. ");
INSERT INTO ata_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isikali iloꞌa ta ꞌolu. Ta ꞌolu ualaualasiꞌa ane, Tola ilou Pua mo Iasupu mo Simuron. ");
INSERT INTO ata_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sevulon iloꞌa ta ꞌolu. Ta ꞌolu ualaualasiꞌa ane, Sereti ilou Eloni mo Ialelu. ");
INSERT INTO ata_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Aneꞌi ane ne, anu Iakovo ta ꞌolu e semau ualasie lexe Lea, ilou anu Iakovo mixalixaꞌa ne Mesopotamia. Lea mivoꞌone ꞌilie sema vile kalumo, ualasie lexe Tina. La sou anu Iakovo ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu ane Lea mixalixaꞌa itiitisiꞌa muxali loxo mavulovexa tatalu mo tatalu (33). ");
INSERT INTO ata_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ioxe, Iakovo ta ꞌolu seꞌi la ano ꞌo. Vile ualasou lexe Xati. Xati ta ꞌolu ualaualasiꞌa ane, Seponi ilou Axi mo Suni mo Esubon mo Eri mo Arodi mo Areli. ");
INSERT INTO ata_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ꞌOlu vile la ane, Aselu. Aselu ta ꞌolu ta mulu ane, Imuna ilou Isiva mo Isivi mo Beria. Xe vimoꞌa sema ane Sela. Aselu ꞌolu vile e ualasou lexe Beria, mupalaaneꞌi ta ꞌolu ane, Eberu ilou Malakieli. ");
INSERT INTO ata_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Aneꞌi ane ne anu Iakovo ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiliꞌilusunu ane anu ilee Silipa mipalaaneꞌi ane. Silipa ne ane sema e Lavani munoꞌe sou milai mixoo noxie ꞌolu Lea sou ipalupalusie sou iꞌoxoꞌoxo mixemixe ane. Itiitisiꞌa muxali loxo, mavulovexa vile mo mulelia taꞌuve mo muvaxa simi vile. ");
INSERT INTO ata_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ioxe, Iakovo semau ane ualasie lexe Lakeli, ane mivoꞌoneꞌi ta ꞌilie noxou mulue ne ane, Iosepu ilou Beniamini. ");
INSERT INTO ata_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Xe Iosepu muꞌuluxe Potipera ꞌolu ualasie lexe Asenata ne Aixiputo ne, la sou ilou mupalaaneꞌi ta ꞌiliꞌa ta mulu tamei. Vile ualasou lexe Manase, xe vile ualasou lexe Epalaimu. Potipera ne anu ailiꞌi ne Eliopolisi. ");
INSERT INTO ata_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Xe Beniamini la mupalaaneꞌi naꞌu ta ꞌolu ane, Bela ilou Beke mo Asibelu mo Xera mo Naamani mo Eki ilou Rosi mo Mupimu mo Upimu mo Ati. ");
INSERT INTO ata_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Aneꞌi ane ne anu Iakovo ilee Lakeli ta ꞌiliꞌiliꞌa iloꞌa ta xasixasiꞌa. Itiitisiꞌa muxali loxo, mavulovexa vile mo mulelia tamiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Iakovo ꞌolu vile la ane Den. Den mupalaanu ꞌolu vilesisi ane ualasou lexe Usimu. ");
INSERT INTO ata_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Xe ꞌolu ane ualasou lexe Napitali, mupalaaneꞌi ta ꞌolu ane Iakusielu ilou Xuni mo Ieseru ilou Silemu. ");
INSERT INTO ata_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Aneꞌi ane muxatele tamei ne, Iakovo ilee Vila e Lavani munoꞌe sou mulosie ꞌolu Lakeli sou ixolu noxie sou ipalupalusie sou iꞌoxoꞌoxo mixemixe mipalaaneꞌi. ");
INSERT INTO ata_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Itiitisiꞌa Iakovo ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu e milai sou mixolu ne Aixiputo ne ane, mupita la muxali loxo mavulovexa muxatele vile mo muxatele vile. Ia ta ꞌolu ta semasemaiꞌa ne iitisiꞌa ipitaneꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Iosepu mupalaaneꞌi ta ꞌolu tamei lai ne Aixiputo ne, la sou itiitisiꞌa mutelai muxali loxo mavulovexa muxatele tamei. ");
INSERT INTO ata_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iloꞌa mimuamuaꞌi xoo xe milai, la Iakovo mupalusou ꞌolu Iuda muuli sou ulai uvikalanu Iosepu uneꞌe ualaxaꞌa ne Xosen. Xe aneꞌi mineꞌe mixali ne Xosen, ");
INSERT INTO ata_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","la Iosepu mutelo no anu karisi sou ꞌotoꞌoto noxou sou muneꞌe muxali noxou momu Isilaeli. Muneꞌe xe muxali noxou momu ka muꞌaulaxu la utatama xoo mole, maxuveeni loxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Xe momu muavuti la muvikala aloxo ꞌo, “Eni aꞌosa sou soli, xo eni a eneꞌe mo emaisine ꞌo mo elavu lexe nini a naxoxoolu.” ");
INSERT INTO ata_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Xe Iosepu muavuti la muvikalaneꞌi ta vimovimou iloꞌa momu ta minuminu ane iloꞌa mineꞌe ne lexe, “Eni alai mo avikalanu tatananu tuala ne Aixiputo lexe eni ta vivilo mo mamilo ta minuminu e iloꞌa mixoo ne Kanani ane mineꞌe mixali noxilo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Avikalanu lexe ngingi ne ngingi ta mitema sou saxisaxilaꞌa ta sipsip. Mo avikalanu kalumo lexe ngingi ngeneꞌe ꞌo la, ngenoꞌa mineꞌe kalumo. Mo ngetavuevule lavulavulutimengi piena misevile kalumo muneꞌe. ");
INSERT INTO ata_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Lexe uꞌavalinge sou utaliꞌisinge mo lexe ulavu no anu xaixai noxinge, ");
INSERT INTO ata_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","la ngavikalanu lexe ngingi ne ngingi ta mitema sou saxisaxilaꞌa ta sipsip ne tatei mo, loxo ta xasixasixe tatei. Lexe ngapalomatananu aloxo ne, la anu upelemasaxainge sou ngaxolu no xalee lia ne Xosen.” Iosepu muvikalaneꞌixu voteꞌi ane ne xo ta Aixiputo ne imasaxaiꞌa ta mitema sou isaxilaꞌa ta sipsip ne uasi. ");
INSERT INTO ata_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Xe Iosepu muavuti la muuoloiꞌa ta vimovimou taꞌuve sou iloꞌa milai mixali noxou tatananu tuala ne Aixiputo. Iloꞌa milai xe mixali noxou la Iosepu muvikalanu aloxo ꞌo, “Mamilo iloꞌa ta viivilo mo ta sipsipiꞌa iloꞌa ta kauiꞌa mo ta kameliiꞌa mo ta donkiiꞌa mo ta meeiꞌa meꞌa ne Kanani mo a mineꞌe mo a ixoo ne Xosen. Mitavule lavulavulutiiꞌa piena misevile kalumo muneꞌe.” ");
INSERT INTO ata_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Xe munoꞌa ta vimovimou taꞌuve e muiloiꞌa ne sou milai noxou tatananu tuala. ");
INSERT INTO ata_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Xe anu tatananu tuala muavuti la mutaliꞌisiꞌa, “Xaixai maꞌi ane ngingi ngaxoxoo la ngaꞌauꞌausou sou ngaꞌoxoꞌoxonu?” Xe aneꞌi miavuti la mikolinu aloxo ꞌo, “Tatila, nexi ta mitema vitanisi ꞌo, nexi ta mitema sou tasaxisaxilaꞌa ta sipsip aloxo ta xasixasixe tatei.” ");
INSERT INTO ata_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Xe miavuti la mivikalanu aloxo ꞌo la, “Nexi teneꞌe ꞌo xo soli tila ꞌo mulai mutaasixe mo muꞌokiꞌoki tani no xalee noxixe ne Kanani mo nexi iaꞌeiaꞌe sou ta sipsipmexi iloꞌa ta kaumexi uasisi manina. La sou ane nexi teneꞌe ꞌo sou taxolu lai ꞌo, ia taxolu maxuveeni uasi. Ia tatila, vaimomo ꞌo, nexi temasaxa lexe nini opoone usexelaixesi mo nexi taxoo ane ne Xosen ne.” ");
INSERT INTO ata_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Xe anu tatananu tuala ne muavuti la muvikalanu Iosepu aloxo ꞌo, “Mamine iloꞌa ta viivine ane mineꞌe mo mixali noxine ꞌo sou ngongiꞌa ngaxolu lai ne Aixiputo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Naꞌitaloneꞌi mo ixolu no xalee lia vile ane lailaixe misevile. Ieni uvaxaiꞌasi mo ilai ixolu ne Xosen, xo anu lia xalee ane ne anu laixe musuku. Xe lexe nelavu lexe, seꞌi no nixi noxiꞌa ne milavu lailaixe musuku no anu xaixai ane sou isaxisaxilaꞌa ta sipsip iloꞌa ta kau lailaixe misevile, la mene nasosovosiꞌa ka nalai naꞌitaloneꞌi sou isaxisaxilaꞌa eni ta naꞌaxeni ta sipsip iloꞌa ta kau.” ");
INSERT INTO ata_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Xe iliꞌi la, la sou Iosepu munoꞌu momu Iakovo sou muneꞌenu noxou tatananu tuala ne. Xe Iakovo muavuti la mualusou lexe, “Lataua uxoo noxine mo ualusine.” ");
INSERT INTO ata_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Xe tatananu tuala muavuti la mutaliꞌisou Iakovo aloxo ꞌo, “Tauu iexene taꞌei?” ");
INSERT INTO ata_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Xe Iakovo muavuti la muvikalanu lexe, “Maulixo sou xoluxolu mo xixaoxao no lia ꞌo muxali loxo tauu ie itemaxu taꞌuve mo mavulovexa tatalusi. Tauu ie piena uasi, ia tuꞌutuꞌumaxu piena misevile muxalisilo. Ta xasixasilosi ne mixolu mo mimauli maxuveeni misevile mo tauu iexaꞌa ne veveeni misevile no anu ane noxilo.” ");
INSERT INTO ata_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ilou muvivikala aloxo ne xe mukalu, la sou Iakovo mualusou ka muioonu io sou mulivu mulai. ");
INSERT INTO ata_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iloꞌa tatananu tuala mivivikala aloxo xe mukalu, xe iliꞌi la sou Iosepu mulai sou muꞌoxo loxo tatananu tuala muvikalanuxu sou musuꞌulineꞌi momu iloꞌa ta vimovimou sou muꞌitaloneꞌi no lia xalee vile ne Aixiputo ne. Mulai muꞌitaloneꞌi no anu lia no tuala ne Lamesesu. Lia sou tuala xalee ane ne laixe misevile. Muuli no anu lialia ne Aixiputo mukalusi. ");
INSERT INTO ata_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","No voxo sou soli toxoxaꞌa ane aneꞌi ixoxolixu ne, la Iosepu iou siꞌisiꞌa momu ena uasi, laꞌilali a ulalai noxiꞌa sou iꞌoꞌou. Momu mo ta vimovimou mo, momu ta minuminu mo moso ane ta molomolo ne ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Soli toxoxaꞌa e muxali ne, muxoo maxuveeni mole muꞌoki tani mole laꞌilali sevile uxolu no xalee lia sevile loxo uasi manina. Ta mitema sou tuala ne Aixiputo mo ne Kanani ne misoisolixaꞌa mole xavineꞌi la uasi manina. ");
INSERT INTO ata_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ta mitema ineꞌe sou iloto laꞌilali, la Iosepu utaxusou lamoli ne sou ulai umuxaxu noxou tatananu tuala ne Aixiputo taasou. ");
INSERT INTO ata_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Xe ta mitema ne Aixiputo mo ne Kanani ilai ilotoloto laꞌilai xe lamoliꞌa ukalu manina, la aneꞌi ilai noxou Iosepu la ivikalanu aloxo ꞌo, “Naitinexe laꞌilali, xe uasi la nexi tasoisoli sou soli avile. Nasuꞌulinexi no anu voteꞌi vile mo nexi tamauli xo nexi lamolimexi ane mukalukalu ne.” ");
INSERT INTO ata_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Xe Iosepu muavuti la muvikalaneꞌi aloxo ꞌo, “Lexe ngingi lamoli sou ngalotongenge laꞌilali no anu uasi, la nganoꞌa ta sipsipmengi iloꞌa ta kaumengi ineꞌe noxilo la sou eni aitingenge laꞌilali.” ");
INSERT INTO ata_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","La sou aneꞌi minoꞌa ta mii loxo ta oosiiꞌa iloꞌa ta sipsipiꞌa mo ta meeiꞌa mo ta kauiꞌa mo ta donkiiꞌa ne sou milosou Iosepu, la sou anu muitixaꞌa laꞌilali. Aneꞌi miꞌoxoꞌoxonu aloxo ne mole tauu ie ano ꞌo ukalu. ");
INSERT INTO ata_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Xe no tauu ie iliꞌi, la ta motu mineꞌe noxou Iosepu la, la mivikalanu aloxo ꞌo, “Tila, nexi tamomomo sou tatalumeiou tuꞌumaxu noxixe noxine uasi, nexi teneꞌe ꞌo sou tavikalaneni manina lexe, nexi lamolimexi ane mukalu ne, mo ta sipsipmexi iloꞌa ta kaumexi, mo ta donkimexi mo ta meemexi mo ta kamelimexi ane milaimeni mukalu ne. Mii vile la sou nexi talosine la uasi. Nexi vasimexe ilou lialianexesi a uxolu. ");
INSERT INTO ata_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ia ieni uvaxaixesi mamu, xo maasi la nexi tasoisoli uluꞌe no ieni ꞌo mo lialianexe uxali masua ukalusi. Nalotonexi mo lialianexe no anu laꞌilali mo sou taxali loxo ta mitema sou palupalusou noxou. Ia tila, anu laixe lexe nini naitinexe laꞌilali toxosou sou tatounu mo sou temanu la taꞌou, xe uasi, la nexi tasoisolisi. Nexi tamasaxa lexe nexi taxolu laixe mo lialianexe uxali masua uasi.” ");
INSERT INTO ata_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Anu aloxo ne la sou Iosepu mulotonu lialia ne Aixiputo ne mukalusi xou tatananu tuala to ne. Ta mitema ne Aixiputo vilevilesi ne mulotonu lialiaxaꞌa mukalu, xo soli uꞌokiꞌoki tani manina avile. Lialiaxaꞌa ne mulai tatananu tuala tila naꞌu mukalu ne. ");
INSERT INTO ata_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Iosepu muvikalaneꞌi lexe ta mitema ne Aixiputo no xalexalee tuatuala ukalusi ne, miꞌumesou liaxaꞌa mo misuku milai mixolu no tuala tila seꞌi. ");
INSERT INTO ata_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ia Iosepu ulotonu lia xalexalee noxiꞌa ta ailiꞌi uasi, xo tatananu tuala ulolosiꞌa lamoli la sou ane aneꞌi ilotoloto laꞌilali no anu ne. La sou ane lialiaxaꞌa muxolusi ne. ");
INSERT INTO ata_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Xe Iosepu muavuti la muvikalaneꞌi ta mitema aloxo ꞌo, “Ngalomu, vaimomo ꞌo eni elotongengi iu tatananu tuala, mo elotonu lialiangenge kalumo ne lexe xou, ia laꞌilali ngiangiaxu, nganoꞌu mo ngatootou uluꞌe no lia ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ia ulai iliꞌi xe uneneꞌa xe tematemanu, la nganoꞌu laꞌoluxu vile no anu laꞌoluxu taꞌuve ulai noxou tatananu tuala. Xe laꞌoluxu tamiꞌa ne ngamuxaxu, seꞌi sou ngatounu xe seꞌi sou ngongiꞌa ta ꞌiliꞌilinge mo aneꞌi ane ngongiꞌa ngaxoxoo ne ngaꞌou.” ");
INSERT INTO ata_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Xe ta mitema ne miavuti la mivikalanu Iosepu, “Laixe musuku xo nini nepamaulinexi mole ane nexi latala ꞌo temauli laixe ꞌo. Mo ane nexi taxolu loxo ta mitema noxou tatananu tuala sou upalupalusixexu mixumixu sou taꞌoxoꞌoxonu.” ");
INSERT INTO ata_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","La sou Iosepu muxalixu voteꞌi vile no nano ne Aixiputo ne lexe, ta mitema itootou laꞌilali xe ulai iliꞌi xe temanu xe lingamo, xe imolou la laꞌoluxu vile no anu laꞌoluxu taꞌuve ne inoꞌu ulai noxou tatananu tuala. Voteꞌi ane ne, a uxoxoolu sio mo a imumulinu mo mutalo vaimomo ꞌo. Ia ta aliliꞌi ne, lialiaxaꞌasi ꞌa Iosepu ulotonu ulai xou tatananu tuala uasi. ");
INSERT INTO ata_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Io, ta Isilaeli e mineꞌe mixolu ne Aixiputo no xalee lia ne Xosen ne, mipalaa ta ꞌiliꞌa mole mixali tavuꞌalo misevile, mo miꞌamiꞌa ilou mixamixaꞌa kalumo ne tavuꞌalo misevile. ");
INSERT INTO ata_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakovo e muneꞌe kalumo sou iloꞌa mixolu ne, muneꞌe muxolu mole tauu iexu mulai muxali loxo mavulovexa mo mulelia taꞌuve mo muvaxasimi tamei. La sou tauu iexu maulixu mutelai loxo itemaxu taꞌuve mo mavulovexa tamiꞌa mo muxatele tamei (147). ");
INSERT INTO ata_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Xe voxo a ꞌalaꞌalai sou Isilaeli usoli, la muꞌavalou ꞌolu Iosepu sou muvikalanu aloxo ꞌo, “Lexe nemasaxailo manina, la namuxaxu avone no laaxu poxoꞌilo mo napalaꞌalixu taneni lexe nini namaxaꞌu alauna noxine noxilo mo lexe eni asoli, la naꞌasixo lai ne Aixiputo ꞌo uasi, ");
INSERT INTO ata_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ia lexe eni ieli uvuvu sou alai noxiꞌa ta xasixasilo aneꞌi ane misoisoli la natavulenu xalusilo uuatulai no ale ne Aixiputo sou nalai naꞌasixo ane no paꞌumeꞌa ne.” Xe Iosepu muavuti la mukolinu momu lexe, “Eni amuli masaxa noxine mo aꞌoxo aloxo nini mene nelemolu ne.” ");
INSERT INTO ata_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Xe Iakovo muavuti la muvikala la lexe, “Eni amasaxa lexe nini navikala maninasou lexe nini naꞌoxo aloxo nelemolu ne.” Xe Iosepu muavuti la, la mupalaꞌalixu tanu maninasou noxou momu, la sou momu Iakovo mutangatulu no luusou sou mulotu noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Iloꞌa mixoxoo xe iliꞌi, la vaikala lamana muneꞌe muxali noxou Iosepu lexe momu a pipiena muꞌoxonu. La sou anu munoꞌa ta ꞌolu tamei, eiae Masase ilou Epalaimu sou iloꞌa milai mikilisou. ");
INSERT INTO ata_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Xe anu Iakovo mulomu lexe ꞌolu Iosepu a muneꞌe la anu mupulili sou molu muavuti sou mutulu mutalupexa no luusou ne. ");
INSERT INTO ata_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Xe muavuti la muvikalanu ꞌolu Iosepu, “Lataua ane xaviinu misevile mupalaꞌa noxilo ne Lusu no xalee lia ne Kanani, la mualusilo ane. ");
INSERT INTO ata_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Muvikalaleli aloxo ꞌo, ‘Eni axalixaꞌa ta ꞌiline tavuꞌalo misevile mo sou itiitisinge utelai, la sou ngingi ngaxali ta mitema tavuꞌalo manina iliꞌi. Mo eni aꞌitalonu lia ano ꞌo lexe ta ꞌiline iloꞌa ta xasixasine mo ta ꞌiluꞌilusuneni liaxaꞌa ulai avile iliꞌi mo kaluxu uasi.’” ");
INSERT INTO ata_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Xe musolonu vaikalau la muvikalanu ꞌolu aloxo ꞌo la, “Ta ꞌiline ta tamei e nepalaneꞌi ne Aixiputo ꞌo ka sou eni eneꞌe ne, eni ta ꞌalixeni. Emasaxa lexe Manase ilou Epalaimu ne, eni ta naꞌaxeni ta ꞌalixeni, aloxo ꞌo Luven ilou Simeoni. ");
INSERT INTO ata_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ia ulai iliꞌi xe male nini napalaaneꞌi ta ꞌiline seꞌi la, la nini ta naꞌa nini ane. Xe ulai iliꞌi xe ikalaa pilipilixasou lialiaxaꞌa sou iꞌitaꞌitalonu noxiꞌa vilevilesi, la aneꞌi ta ꞌiline ane nini napalaaneꞌi no tumaliꞌa Manase ilou Epalaimu ne aneꞌi imoxoꞌu liaxaꞌa no anu ualasiꞌa tamei. ");
INSERT INTO ata_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Eni eꞌoxo xavutala ano ꞌo xo taleli utamasie nenine Lakeli misevile. Ane misoli no xalee lia ne Kanani no voxo ane nexi tevulasou tuala ne Mesopotamia sou tasuku ulai ne Epurata. Misoli, la eꞌasixe no voteꞌi paꞌumolu ulai ne Epurata. (Vaimomo ꞌo ne ilemolu tuala ne Epurata ne lexe Vetiliemu.)” ");
INSERT INTO ata_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Xe Isilaeli mumaisiꞌa Iosepu ta ꞌolu tamei e iloꞌa mineꞌe ne la mutaliꞌisou aloxo ꞌo, “Ta molomolo ta ꞌei moso ne?” ");
INSERT INTO ata_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","La anu muvikalanu momu lexe, “Eni ta ꞌalixene e Lataua mulosilo lai ne Aixiputo ꞌo ane.” La sou momu muvikala lexe, “Nanoꞌa ineꞌe noxilo mo aalusiꞌa ilou.” ");
INSERT INTO ata_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Isilaeli ne iou isiisivoxo mo umalei laixe la uasi, xo anu itema tila manina. La sou ꞌolu Iosepu munoꞌa ta ꞌolu tamei ne milai ꞌalai manina noxou momu sou momu muꞌaulaxaꞌa ilou ka mutimunu xaleneꞌi ilou. ");
INSERT INTO ata_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Xe Isilaeli muavuti la muvikalanu ꞌolu Iosepu, “Eloxomale lexe umomomo sou amaisou ieni la ua, ia vaimomo ꞌo Lataua molu mumasaxa la sou emaisou ieni xe emaisiꞌa ta ꞌiline kalumo.” ");
INSERT INTO ata_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Xe momu muvikala aloxo ne xe mukalu, la sou anu mutilaꞌa ta ꞌolu sou muxexeneꞌi noxou momu tavaꞌu, ia anu mutangatulu muluꞌelai no talaxu momu. ");
INSERT INTO ata_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Xe muavuti la munoꞌa ta ꞌolu tamei ne ka mutulusiꞌa no paꞌumolu. Epalaimu no avolu tema sou musaxi mulai loxo noxou Isilaeli avolu ae, xe Manase ne mutulusou no paꞌumolu no avolu ae sou musaxi mulai loxo noxou Isilaeli avolu tema. Io sou musukuneꞌi ilou milai sou mitulu ꞌalai manina noxou momu talaxu. ");
INSERT INTO ata_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ia Isilaeli muxiunu la munoꞌu avolu tema, ka mutelo sou mumuxaxu noxou ane kituꞌa Epalaimu kisou, xe munoꞌu avolu ae, la mutelo mumuxaxu noxou ane laposalaxu, Manase kisou. ");
INSERT INTO ata_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Io sou mualusou Iosepu la muvikala aloxo ꞌo, “Nini Lataua e xasilo Avalaamu ilou mamilo Aisaki mimuamuaꞌi noxine maninanu mo nini Lataua sou saxisaxilaꞌu noxilo tatei mo muneꞌe mutalo vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mo nini Lataua e neneꞌe nexali noxilo loxo angelo sou nesaxilaꞌilo mo nepamaulileli no anu tuꞌutuꞌumaxu ane lexe ukalusou maulixo. Amasaxa lexe nini naalusiꞌa ta molomolo tamei ꞌo. Ipalaaneꞌi ta ꞌiliꞌa tavuꞌalo mo sou ta ꞌiliꞌiliꞌa iloꞌa ta xasixasiꞌa ixali tavuꞌalo manina sou iꞌanaꞌana no xalexalee tuatuala ukalusi iliꞌi. La sou eni ualasilo mo xasilo Avalaamu ilou mamilo Aisaki ualasiꞌa kalumo ne uxexee no anaxaꞌa ta mitema uasi.” ");
INSERT INTO ata_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Xe Iosepu iou muvaxa la mumaisou momu mine mumuxaxu avolu tema no latanu Epalaimu kisou, la opoonu uꞌosa uasi manina. Xe muavuti la mukasi vaxa noxou momu avolu sou muxexeenu noxou Epalaimu kisou sou mumuxaxu noxou Manase kisou, ");
INSERT INTO ata_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ia muvikalanu lexe, “Ane nemuxaxu avone no kisou ne uasi, anu ane laposalaxu ano ꞌo. Namuxaxu avone tema no kisou.” ");
INSERT INTO ata_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ia momu umasaxa uasi, la muvikalanu lexe, “ꞌAlixeni, eni elavusou. Manase ne ulai la ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu ne ixali tavuꞌalo misevile sou tuala vile. Ia kituꞌa ꞌo anu ulai la utila musuku noxou. Ta ꞌolu iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu ne ixali ta mitema sou xavi, mo ixali tavuꞌalo loxo ta mitema sou xalexalee tuatuala piena.” ");
INSERT INTO ata_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","La sou no voxo ane ne, Isilaeli mualusiꞌa la muvikala aloxo ꞌo, “Ulai iliꞌi, la ta Isilaeli imoxoꞌu ualasinge ngongou no voxo ane lexe aneꞌi ilingau Lataua sou ualusiꞌa seꞌi. Ivikala aloxo ꞌo, ‘Lataua molu ualusinge loxo mualusiꞌa Epalaimu ilou Manase.’” Anu aloxo ne la sou ane anu Isilaeli muxiuneꞌi ilou sou mumuxaxu Epalaimu muuli noxou Manase. ");
INSERT INTO ata_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Xe muavuti la muvikala vaxa noxou ꞌolu Iosepu, “Eni asou asoli, ia Lataua uxolu noxinge. Mo anu molu unoꞌinge sou ulivulingenge ulai no liaxu xasine ilou ꞌilusuneni. ");
INSERT INTO ata_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Lia e no tuala ne Sikemu ne, anu lia xalee ane ne laixe misevile. Tatei la eni enoꞌu viso ilou pasiko sou noxiꞌa ta Amolu teꞌotosou la eni enoꞌu eꞌumenu noxiꞌa. La sou, tavaꞌu xo ninisi ane nini tila noxiꞌa ta viivine, la ane eni aꞌitalonu lia ane ne noxine.” ");
INSERT INTO ata_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Xe Iakovo muavuti, la muꞌavaliꞌa ta ꞌolu sou mineꞌe noxou mukalusi sou muvikalaneꞌi, “Ngataꞌolu ngaxalili no paꞌumelo mo eni avikalangengixu mii ane sou uxali noxinge mo noxiꞌa ta ꞌiliꞌilinge mo ta xasixasinge iloꞌa ta ꞌiluꞌilusungengi no voxovoxo ane uneneꞌe iliꞌi. ");
INSERT INTO ata_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ta ꞌalixeni, ngingi nganeꞌe ngapita mo ngalomu. Ngalomu noxilo maminge Isilaeli.” ");
INSERT INTO ata_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Xe mitaꞌolu mukalu, la anu musokou sou muvikalanu Luven tei, “Luven, nini ꞌalixeni laposalaxu ane, eni xavileli ane nini. Eni no mine xavileli ia epalaaneni. Nini itema vile tatila misevile mo xavineni misevile kalumo. ");
INSERT INTO ata_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nini loxo lexa uꞌani la evile umomomo sou utalutaluxene uasi. Ia umomomo sou nini naxali itema vile tila la ua, xo nelai ngongie sema noxilo vile ualasie lexe Vila ngeai, la nexomaulaleli la nepamaelaleli sou neꞌoxo ꞌilixo masua no luusilo.” ");
INSERT INTO ata_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Xe mukalu la musuku mulai noxiꞌa Simeoni ilou Levi. “Simeoni ilou Levi ne ngingi ta taumetali. Ngingi ngalavusou ngaꞌoxo masuaneꞌi ta mitema sou ngaveꞌa no anu mimii sou ꞌotoꞌoto noxinge. ");
INSERT INTO ata_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Umomomo sou eni alai axolu no taingengi, mo alai nengeꞌa taxolu no anu xolu pita noxinge sou vaivaikalasou mimii uasi, xo ngingi laꞌiangenge la ngalavusou ngaveꞌa ta mitema, xe loxo ngingi laꞌiangenge uasi ia ngaxoxoo lailaixesi, la ngingi ngamulinu masaxa noxinge sou ngaxoxolasou ta kau tavatavaꞌa vitavitanisi. ");
INSERT INTO ata_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tavaꞌu xo ngingi ngongou ta mitema sou laꞌia, la tuꞌumaxu uxolu noxinge ngongou, xo opongengi e ututulu palepalea sou laꞌia ne masua manina misevile. Eni aveluneꞌi ta xasixasinge mo ta ꞌiluꞌilusungengi sou ilai ixolu vaꞌavaꞌaxu no xalexalee lia ne Isilaeli mo ilai ixolu no nixi noxiꞌa ta minemineꞌi mo sou xavineꞌi uasi.” ");
INSERT INTO ata_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Muvikalaneꞌi ta tamei ne mukalu, la musuku mulai noxou Iuda. “Iuda, nini ne ta vivine iꞌiti ualasine. Ta uluameni ne ulai la nakapilaxaꞌa. Ta viivine ꞌo ulai la ixolaꞌu tavaꞌa ka itulu no tavaꞌa voꞌuxu sou itangatulu uluꞌe no talaxene sou itoxoneni. ");
INSERT INTO ata_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda, nini ne, loxo laeoni ꞌolu. Nini xavineni misevile. O! Iuda, ꞌalixeni. Nini loxo laeoni anu uvau xou mii sou uꞌou ka ulivu uneꞌe sou uai no taasou seꞌisisi. Umeximexi tavaꞌu ilou avolu ka ulivu sou uai no lia la. Evile umomomo sou utulusou uasi xo iꞌume noxou. ");
INSERT INTO ata_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Iuda ne, anu uxolu aloxo tatananu tuala vile, mo utetelisou vilaxoxu ane sosovosou lexe anu tatananu tuala. Ia tatananu tuala noxou manina uxali, la anu usaxilaꞌa ta mitema no xalexalee tuatuala ukalusi. ");
INSERT INTO ata_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ovu uaini uleme tavuꞌalo la sou utaliꞌisou donkiiu, la ulai usakii no ovu uaini aiinu mo utaliꞌisou oosiiu la ulai usakii no anu uaini avolu laixe. Xe uaini lexaxu tavuꞌalo misevile la sou unoꞌu uaini lexaxu ane sou uꞌuinu tokolomou, xe unoꞌu uaini lexaxu lauoinu sou uꞌuinu tolomuou laixe no anu. ");
INSERT INTO ata_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iou lavoꞌnu ne lauoinu uꞌokinu, xo uiexu uaini lexaxu tavuꞌalo. Anaxu ilanu ne ukea uꞌokinu, xo uiexu kau susu tavuꞌalo.” ");
INSERT INTO ata_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Xe muavuti la muvikalanu Sevulon. “Sevulon ne ulai la uxolu no luaki paꞌumolu. Xalee tuala ane anu ulai uxolu no anu ne, luaki laluꞌuxu mo lautuxu lailaixe sou lasilasipi uꞌuna utulu no anu. Pilixasou liaxu ulai utalo ane ne Saidoni.” ");
INSERT INTO ata_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Muvivikalanu Sevulon aloxo ne mukalu la musuku mulai sou muvikalanu Isikali. “Isikali ne anu xaviinu loxo donki, utavule tavuevule ia utalupexa sou umaꞌila. ");
INSERT INTO ata_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ia lexe umaisou tilovolovo sou lexe lailaixe mo lexe lialiaxu kalumo ne lailaixe, la utangatulu uluꞌelai sou ususunu laxasou sou utavulenu tavuevule. Xe ipalupalusou sou uxaxai uꞌokinu. ");
INSERT INTO ata_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Xe Den ne, anu ulai la anu itema vile tila sou usaxilaꞌa ta mitema noxou sou ulosieixu ꞌilixo ane mulapu sou imulinu. Ta mitema noxou ne, ulai la aneꞌi aloxo aneꞌi ta mata ne Isilaeli ane seꞌi. ");
INSERT INTO ata_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Den ulai la, anu loxo sinana veveeni uai no voteꞌi paꞌumolu. Sinana veveenu vile masua manina no paꞌumolu voteꞌi. Oosi uiave umulinu voteꞌi la, ungaasou tavaꞌu uluꞌu la sou uleanu tatananu e mutelo noxou ne ulai iliꞌi. ");
INSERT INTO ata_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","‘IAUE, eni axoomaieni sou napamaulileli.’” ");
INSERT INTO ata_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Xe muavuti la muvikalanu Xado. “Xado ne ulai iliꞌi la ta mitema sou pakali ilooxu sou ivau. Ia anu uxiu ulai noxiꞌa sou umulineꞌi mo uveꞌaveꞌa. ");
INSERT INTO ata_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aselu ne, ulai la liaxu uxalixu laꞌilai lovolovoxu lailaixe misevile. Anu uxutuxu laꞌilaili tumaꞌu mo tuꞌaxu lailaixe loxo tatananu tuala laꞌilalixu. ");
INSERT INTO ata_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napitali ne ulai la anu loxo mee. Iꞌitalonu la uxixaoxao no anu masaxa noxousi. Xe uxalixaꞌa ta ꞌolu la ta lailaixe misevile.” ");
INSERT INTO ata_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Xe musuku mulai noxou ꞌolu Iosepu la muvikala aloxo ꞌo, “Iosepu nini ovu uaini vile ne neneꞌaxu lailaixe misevile. Ovu uaini ane ne, uleme no paꞌumolu lexa luuxu uopuopu utetelo no anu. Ukalakala avoavolu utelo umulinu tani kakapisou. ");
INSERT INTO ata_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ta uluameni ixaline la ivene no anu tavi. ꞌOtoꞌoto ane ne ꞌoluꞌolu uasi. ");
INSERT INTO ata_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ia nini Iosepu pasikomeni ne utalivimi uxolu aloxo ne xo Lataua noxilo, eni Iakovo anu ulosine xavi. Avone ne pekiaꞌu misevile. Lataua ane ne, anu usaxisaxilaꞌa ta Isilaeli, mo kulu noxiꞌa sou italume no anu. ");
INSERT INTO ata_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Anu Lataua noxilo, eni mamine Iakovo mo anu Lataua xaviinu misevile. Anusi ualusine no anu laꞌiua molu teitexi no loxotolo, mo lexa molu no lia tanu, mo ualusine sou napalaaneꞌi ta ꞌiline tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ualusine sou nini mii piena. Alualu noxilo, eni mamine ne, anu mutila musuku mo uvaꞌusou xii laxalaxaꞌilu ne ukalusi, mo mutila no anu mimii lailaixe e ta xasixasilo minoꞌu sou mimuxaxu no taataasiꞌa tatei. Alualu latala ne ulai iliꞌi la uxali noxine nini Iosepu manina no ieni nini tila no taineꞌi ta viivine. ");
INSERT INTO ata_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamini ne anu aꞌaa vova toxoxaꞌa. No kakau xe no ꞌoloꞌolovoxo, anu uꞌiꞌa ta mii anu muveꞌa mo ukalipalaꞌaneꞌi.” ");
INSERT INTO ata_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Aneꞌi ta mitema ane ne, aneꞌi mata mavulovexa mo mulelia tamei noxiꞌa ta Isilaeli ane. Mamiꞌa vaivaikalau sou mualusiꞌa no anu ane telomusou mo muneꞌe mutalo noxou Beniamini. Alualu ane anu mualusiꞌa no anu ne, mumomomo manina no anu maulixaꞌa vilevilesi. ");
INSERT INTO ata_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Xe muavuti la mupelaꞌa aloxo ꞌo, “Eni asou alai noxiꞌa ta milemileli tapita no tuala sou soli. La sou emasaxa lexe ngaꞌasixo ane ta xasixasilo miai no anu. Miꞌasixaꞌa no taxa no lia noxou Epulon anu itemasie Keti. ");
INSERT INTO ata_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Taxa ane ne, muxolu no xalee lia ne Makapela ꞌalai ne Mamure, no xalee lia tila ne Kanani. Avalaamu mulotonu taxa ane ne noxou Epulon itemasie Keti no lia xalee ane ne kalumo. ");
INSERT INTO ata_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Miꞌasixu Avalaamu ilee semau Sala mo Aisaki ilee semau Liveka mo eni eꞌasixe Lea kalumo ane ꞌolele. ");
INSERT INTO ata_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Lia xalee ane ne, mo taxa sou taꞌasixaꞌa ta mitema no anu ne, Avalaamu muloto noxiꞌa ta Keti.” ");
INSERT INTO ata_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Xe Iakovo mupelaꞌa ta ꞌolu aloxo ne xe mukalu, la sou mutelailixu tavaꞌu no luusou sou muai muluꞌelai, xe musuxulaꞌe alaxu vilesisi ne la, musoli. La mulai sou iloꞌa ta minuminu ane misoli tei mipita no tuala noxiꞌa ta mitema sou soli. ");
INSERT INTO ata_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Xe Iosepu mumalei loxo ꞌo la, momu ane musivita ne. Xe muavuti la muai mutelo noxou momu latanu sou utamasou xe utitimunu momu xaleenu. ");
INSERT INTO ata_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Xe muavuti la muvikalaneꞌi ta mitema sou lavulavu sou ipamaulinenge no anu pipiena iouiou sou mineꞌe miꞌuinu vasimolu no anu lamalasile seꞌi iouiou sou mamu uꞌui palea. ");
INSERT INTO ata_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ta mitema ne mineꞌe miꞌuinu vasimolu voxo mavulovexa tamiꞌa. Xo anu xaixai ane ne, voxosou umomomo aloxo ne. Xe ta Aixiputo mineꞌe la itatamasou itatamasou xoo mole, voxo mavulovexa muxatele tamei. ");
INSERT INTO ata_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Xe voxo sou mixoxolixu sou mitatamasou mukalu, la Iosepu mulai muvikalaneꞌi ta tatila sou xaixai noxou tatananu tuala aloxo ꞌo, “Lexe eni amitema vile laixe no iengi, la emasaxa lexe nganoꞌu anaxo ulai noxou tatananu tuala mo ngavikalanu lexe, ");
INSERT INTO ata_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","mamilo a alalali sou usoli la muvikalaleli lexe eni apalaꞌalixu taleli manina noxou lexe anu usoli, la eni amulinu masaxa noxou maninasou sou alai aꞌasixu no taxa e anu muꞌasou no xalee ne Kanani. Alalae ꞌosi lexe eni atelaixu mamilo mo aꞌasixu ane, ka sou alivu uneꞌe.” ");
INSERT INTO ata_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Xe vaikalau Iosepu mulai muxali, la tatananu tuala muvikala lexe, “Nalai mo naꞌasixu mamine ane, aloxo anu mupalaꞌalixu tanu lexe nini naꞌoxonu.” ");
INSERT INTO ata_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","La sou Iosepu mutelai sou muꞌasixu momu. Ta tatila sou xaixai noxou tatananu tuala iloꞌa ta tatila sou xaixai no anu taasou lolomu sou vaivaikala sou tuꞌutuꞌumaxu mo ta tatilasiꞌa ta Aixiputo ");
INSERT INTO ata_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","mo anu Iosepu iloꞌa ta mitemau mo ta vimovimou mo momu ta tamitemau ne mimulinu, ia ta ꞌiliꞌiliꞌasi iloꞌa ta sipsipiꞌa iloꞌa ta kauiꞌa mo ta meeiꞌa mo ta kameliiꞌa mo ta donkiiꞌasi mixoluxolu ne Xosen. ");
INSERT INTO ata_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ta mitema sou mitelotelo no anu karisi sou ꞌotoꞌoto mo aneꞌi ane sou mitelotelo noxiꞌa ta oosi kalumo ne milailai mukalusi sou mimulinu Iosepu. Ta mitema tavuꞌalo misevile ane milailai ne. ");
INSERT INTO ata_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Iloꞌa milalai xoo xe, milai mixali ne Atade no xalee mulai loxo aso uxaxali utetelo no anu, anu xalee lia ane ne latia sou aneꞌi ipaupaunoxou uiti palepalepanu no anu. Atade ne muxolu ꞌalai no lexa Ioridani. Milai xe mixali ane la mixolu sou mimatengaleisou Iakovo ane. Iosepu mumuli loxo aneꞌi maulixaꞌa sou taneꞌixu itema usoli, la muxoo mutatama voxo muxatele tamei ane. ");
INSERT INTO ata_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Xe ta Kanani e mixoxoo ne, mimaisiꞌa aneꞌi e mineꞌe mixoo ne Atade sou mimatengaleisou Iakovo ne, la mivikala lexe, “Ta Aixiputo ane mineꞌe imamatengalei sou soli ꞌosi.” La sou ane aneꞌi mimoxoꞌu lia xalee se ne lexe, Aveli Misiraimu. ");
INSERT INTO ata_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Iakovo ta ꞌolu mimulinu aloxo ꞌo anu muvikalaneꞌixu lexe iꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","La sou mitavulenu mamiꞌa vasimolu ne mitelailixu no lia tila ne Kanani sou miꞌasixu no taxa no xalee lia ne Makapela. Makapela ne mixolu ꞌalai ne Mamule. Taxa ane ne Avalaamu mulotonu lexe sou iꞌasixaꞌa ta mitema no anu. Mulotonu noxou Epulon anu itemasie Keti. Avalaamu mulotonu lia xalee ane taxa muxolu no anu kalumo. ");
INSERT INTO ata_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Iloꞌa miꞌasixu mukalu, la Iosepu iloꞌa ta vimovimou mo aneꞌi ta mitema latala e iloꞌa milailai sou miꞌasixu momu ne, milivulivu milai ne Aixiputo. ");
INSERT INTO ata_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Iosepu momu musoli, ia ta vimovimou miavuti la mivikala aloxo ꞌo, “Maminge nengeꞌa musoli, ia male vivinge Iosepu xavutalau a uxoxoolu no anu ꞌilixo masua e nenge teꞌoxo noxou la ukolinu.” ");
INSERT INTO ata_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","La sou mikalaa anaxaꞌa mulai noxou Iosepu sou mivikala aloxo ꞌo, “Maminge muꞌitalonu peletoto noxou mine usoli uao aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Lexe ulai iliꞌi la nexi tavikalaneni lexe anu muvikala lexe anu mumasaxa lexe laixe nini naxiunu tumalineu ꞌilixo masua ane nexi teꞌoxo masuaneni no anu.’ La sou vaimomo ꞌo, nexi ta mitema vitanisi Lataua noxou maminge nengeꞌa Iakovo talingaine lexe laixe nini naxiunu tumalineu ꞌiliꞌilixo masumasua noxixe ne.” Xe anaxaꞌa mulai muxali noxou vimoꞌa Iosepu la mutama. ");
INSERT INTO ata_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Xe aneꞌi milutu xe mineꞌe mixali noxou la mitangatulu muluꞌe no talaxu, xe miavuti la mivikalanu lexe, “Nexi vaimomo ꞌo nexi teneꞌe noxine sou tavikalaneni lexe, nexi taxoo no laaxene sou napalupalusixe sou taꞌoxoꞌoxo mixemixene.” ");
INSERT INTO ata_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ia anu Iosepu mukolinu vaikalaiꞌa aloxo ꞌo, “Opongengi kalaua mo ngaꞌume vitanisi mamu. Loxovaa, eni loxo Lataua sou akolinu ꞌilixo masua noxinge ne? ");
INSERT INTO ata_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Anu manina lexe ngingi ngetovo mo lexe ngaꞌoxo masualeli sou ngakalusou maulixo, ia Lataua iou muvaxainge sou ngeꞌoxonu ꞌilixo ane ne, xo muxavutala lexe anu umasaxa lexe upamaulineꞌi ta mitema tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ia mii vile sou ngingi ngaꞌumolu uasi. Eni ano ꞌo sou asaxilaꞌinge ngongiꞌa ta ꞌilinge.” La sou vaikalau muxavulala mo muxolixoli taneꞌi xe muvikala lailaixe mulai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iosepu iloꞌa ta vimovimou mo momu ta minuminu mixoo ane ne Aixiputo ne, mole anu tauu iexu mulai muxali loxo itemaxu taꞌuve mo mavulovexa (110). ");
INSERT INTO ata_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Mo mumaisiꞌa ꞌolu Epalaimu ta ꞌolu mo ta xasoxasou ta ꞌiliꞌiliꞌa ꞌo. Mo xasou Makiru e Manase ꞌolu ne, semau mivoꞌoneꞌi ta ꞌilie la milailixaꞌa noxou mo muvoꞌoneꞌi ka mumuxaxaꞌa muluꞌe no tavaꞌu. ");
INSERT INTO ata_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Xe muavuti la muvikalaneꞌi ta vimovimou lexe, “Eni asou asoli. Ia ngaxavutala piena uasi, xo Lataua molusi usaxilaꞌinge. Xe iliꞌi la sou Anu uuatulailingenge no ale sou ngaxexesou tuala ane nengeꞌa taxoxoo no anu ꞌo, sou ulailingenge no lia ane, Anu molusi muvikalaneꞌi Avalaamu ilou Aisaki mo Iakovo tatei lexe ulosiꞌa maninasou.” ");
INSERT INTO ata_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Xe muavuti la muvikalaneꞌi ta vimovimou iloꞌa ta xasoxasou mo ta ꞌiluꞌilusunu aloxo ꞌo la, “Eni emasaxa lexe ngingi ngapalaꞌalixu tangengi noxilo mo ngavikalaleli maninasou lexe, Lataua molu usuꞌulingengi mo sou lexe ngingi ngavulasou tuala ano ꞌo la ngatavulenu xileli ulai no tuala ane Lataua molu ulailingenge sou ngalai ngaxolu no anu.” ");
INSERT INTO ata_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Iosepu tauu iexu muxali loxo itemaxu taꞌuve mo mavulovexa vile (110), la sou anu musoli ne Aixiputo. Musoli la miꞌuinu vasimolu no anu lamalasile iouiou sou mamu vasimolu uꞌui palea. Miꞌoxo aloxo ne xe mukalu la, miluvonu ka miaisou no nano no anu luvo. ");
INSERT INTO ata_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","No voxo vile, la IAUE muvikalanu Iona e Amitai ꞌolu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Nalutu mo nalai no tuala tila e ne Ninive mo navikala lamana pekiaꞌu ulai noxiꞌa lexe aneꞌi ixiunu oponeꞌi xo ꞌiliꞌilixo masumasua ane aneꞌi miꞌoxoꞌoxonu ne, mupalaa no ieli mukalu, xe uasi la eni akalusiꞌa.” ");
INSERT INTO ata_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ia Iona mulomuanu IAUE, la umasaxa lexe uꞌume ulai ne Tasisi. Mulutu, la mulai no tuala vile ilemo lexe Iopa tei, sou lexe uxalisou lasipi vile ulai loxo ne Tasisi. Mulai xoo xe muxali, la lasipi vile asou ulutu sou ulai. Mumomomosou voteꞌisou mukalu, la mutelai no anu sou iloꞌa milai. Xo umasaxa lexe ulomuxu IAUE vaikalau uasi. ");
INSERT INTO ata_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Xe iliꞌi, la IAUE muxalixu laꞌave tatila no luaki, la xaviinu misevile, mole lasipi ne ꞌalaꞌalai sou uvalavala. ");
INSERT INTO ata_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ta mitema sou xaixai no lasipi miꞌume misevile. Xe miavuti la mikakava mulai noxiꞌa ta maliavaiꞌa vilevilesi sou isuꞌulineꞌi. Xe miavuti, la mipeinu mimii seꞌi mulai no luaki mo lexe lasipi papaxexusi. Ia Iona ne, muluꞌelai no lia no lasipi tanu mo muai muvaꞌavaꞌamiminu avile. ");
INSERT INTO ata_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Tatila sou lasipi molu muxalisou, la mutaliꞌisou aloxo ꞌo, “Loxovaa ane nini naai loxo ꞌo? Natulu mo naꞌava ulai noxou maliava noxine mo lexe anu tanunenge, la usuꞌulinenge mo mamu nenge taulua.” ");
INSERT INTO ata_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Xe aneꞌi miavuti, la mivikala lexe, “Nenge takaukavu ualaualasinge vilevilesi no anu ovu alelaxu mo tataanu no tiva sou talaanu vile sou lexe taxalisou tavaꞌu laꞌave toxoxaꞌa ane muxalisinge ꞌo.” Miꞌoxo aloxo ne, la sou mixalisou Iona ualasou. ");
INSERT INTO ata_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ioxe miavuti, la mitaliꞌi vaxa noxou aloxo ꞌo, “Navikalanexi no anu tavaꞌu laꞌave toxoxaꞌa ane muxalisinge nengeꞌa ꞌo. Netetelisou xaixai maꞌia? Tualasine neꞌei? Nini sou xalee tuala anevaa? Mo vaikala noxine maꞌi?” ");
INSERT INTO ata_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Iona mukolineꞌi aloxo ꞌo, “Eni amitemasie Evalaio. Eni alavusou aꞌumolu mo ataxaanu IAUE anu Lataua sou tuala teitexi no opo loxotolo. Anu mukoinu mimii latala loxo luaki ilou lia. Ia eni amasaxa lexe alomuxu vaikalau uasi, la sou ane eni eꞌume eneꞌe ꞌo.” ");
INSERT INTO ata_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Aneꞌi milomu noxou aloxo ne, la mimamaꞌu manina. Xe miavuti vaxa, la mivikalanu aloxo ꞌo, “ꞌEi soxu ꞌo, nini nesusu manina.” ");
INSERT INTO ata_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Xe ieꞌi uvaxa, la laꞌave uꞌokiꞌoki tani ukalu, miavuti la mitaliꞌisou, “Nexi taꞌoxone loxovaa mo sou laꞌave ꞌo tasiau?” ");
INSERT INTO ata_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Anu mukolineꞌi aloxo ꞌo, “Ngasuꞌaleli uluꞌelai no luaki la sou anu utalo xo enisi ane, eni tavaꞌu laꞌave tatila ane muxalisinge ꞌo.” ");
INSERT INTO ata_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Aneꞌi xavineꞌiu lasipi mo lexe ilapunu ulai no tasiꞌi. Ia imomomo uasi xo xasi muꞌokiꞌokinu tani manina. ");
INSERT INTO ata_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ioxe aneꞌi miavuti, la miꞌava mulai noxou IAUE. “Mamu nini nalosixe navunavu no anu soli lakolisou itema ꞌo maulixu e nexi taꞌoxo masua ꞌo, aloxo nini nalavusou nalosou itema ane uvaꞌu menexu usoli navunavu. Nini mene namulinu masaxa noxine mo naꞌoxo mii ano.” ");
INSERT INTO ata_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Xe miavuti, la sou mileanu muluꞌelai no luaki. Alaxu vilesisi ꞌo, la laꞌave tasiau. ");
INSERT INTO ata_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Aneꞌi mimalei aloxo ne, la mimamaꞌu noxou IAUE. La sou miꞌelaxu sipsip mulai noxou, xe mipalaꞌalixu taneꞌi sou lexe aneꞌi imasaxa itaxaanu mo imulinu anusisi. ");
INSERT INTO ata_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ioxe, iliꞌi, la sou IAUE mupalusou sinana vile toxoxaꞌa sou muneꞌe mumalukusou Iona. Anu muxolu no nano noxou sinana opoonu aso xe ꞌolovoxo tatalu. ");
INSERT INTO ata_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","No nano noxou sinana opoonu, la anu muvikala lamana noxou Lataua IAUE noxou aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Auo! IAUE o, eni eꞌava noxine sou mii tuꞌumaxu ane muxalisilo ꞌo. La nini nelomusou ꞌava noxilo. Eni elai exolu ꞌalai no tuala masua noxiꞌa ta mitema sou soli. Eni elinga sou suꞌuli, la nini nelomusou linga noxilo. ");
INSERT INTO ata_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Nini nesuꞌaleli, la eni eluꞌelai no lia no luaki tanu. Luaki mutaasilo mukalusi mo xaviinu mukikatukatusilo mo nini neꞌoxonu xasi tatatila kisou uluxu mukavukavulasi no lataleli. ");
INSERT INTO ata_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Eni evikala aloxo ꞌo, ‘Nini nekusailo. Ia, eni emuxamuxaxu taleli lexe amaisou tani tavuna noxine la.’ ");
INSERT INTO ata_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Xasi tatila kisou uluxu mukavukavulasi no lataleli, la muꞌotusou muaxo, xo luaki mutaasilo mukalusi. Iaꞌeiaꞌe sou luaki muausou kisilo kalumo. ");
INSERT INTO ata_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Eni eluꞌelai manina no tavatavaꞌu laxalaxaꞌilu no lia no luaki tanu. Tuala noxiꞌa ta mitema sou soli ne mutatuxo pekiaꞌu avile. Ia IAUE, nini Lataua noxilo, nini nepamaulileli, la sou eni eꞌumesou tuala ane masua mole ane eni enoꞌu mauli laixe ꞌo. ");
INSERT INTO ata_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Auo! IAUE, eni examuli lexe eni xavileli la ua, aloxo ne la sou eni exavutalaneni la ꞌava noxilo mulai muxali noxine no tani tavuna. ");
INSERT INTO ata_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ta mitema ilavusou imuxamuxaxu taneꞌi noxiꞌa ta maliavaiꞌa sou kalavoi mole mixovulaunu. Muamuaꞌi laixe ane noxine mo mixiunu tumaliꞌa, ia imulineni la ua. ");
INSERT INTO ata_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ia eni amasaxa lexe alexe lexe sou aꞌiti ualasine, mo aꞌelaxu sipsip ulai noxine mo amulinu aloxo eni epalaꞌalixu ne. IAUE, ninisi namitema sou pamauli la sou nexi temauli laixe.” ");
INSERT INTO ata_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ioxe iliꞌi, la sou IAUE muvikalanu sinana sou mulai muexinu Iona no tasiꞌi. ");
INSERT INTO ata_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","IAUE muvikalanu Iona la, ");
INSERT INTO ata_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Nalutu mo nalai no tuala tila ne Ninive mo napalaꞌalixu taleli ulai noxiꞌa.” ");
INSERT INTO ata_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Iona mulomuxu vaikalau, la mulai. Ninive ne, anu tuala tatila manina. Itema vile umasaxa lexe ulutu no iou xalenga vile mo ulai uxali xalee vile la umuamuaꞌi voxo tatalu. ");
INSERT INTO ata_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ioxe, Iona mulutu la mulai no nano la mumuamuaꞌi voxo vile. Anu muꞌava noxiꞌa aloxo ꞌo, “Iliꞌi lexe voxo itemaxu tamei ukalu, la sou IAUE ukalusinge ngingi ta mitema ne Ninive.” ");
INSERT INTO ata_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Xe aneꞌi milomusou vaikala noxou Lataua ne, la mimuxamuxaxu taneꞌi no anu, la sou mivikala aloxo ꞌo, “Nenge taꞌani mamu. Taxolu loxo nesi. Nenge latala ꞌo, nenge tatelo tokolomo suꞌinu sou tama ukalusi. Usoko noxiꞌa ta tatila mo ulai utalo noxiꞌa ta mitema vitanisi sou tamaxainge lexe nenge a texiunu oponenge.” ");
INSERT INTO ata_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Tatananu tuala ne Ninive mulomusou aꞌalo ane ne, la muꞌumesou puloulou noxou. Muꞌumesou mukalu, la muxexeenu tokolomou laixe ia mutelo tokolomo suꞌinu sou tama sou mulai muxolu no lia no lomulo. ");
INSERT INTO ata_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Anu mukalaa anaxu mulai noxiꞌa ta mitema ne Ninive, la muvikala aloxo ꞌo, “Nexi noxiꞌa ta tatila sou xaixai noxilo temasaxa lexe evile umomomo sou uꞌani uasi. Ngingi ta mitema ngongiꞌa ta kau mo ta sipsip mengi ngaꞌani mo ngaie mamu. Ngingi latala ne ngaxolu loxo nesi. ");
INSERT INTO ata_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ngatelo tokolomo suꞌinu sou tama noxinge mo noxiꞌa ta kau iloꞌa ta sipsip ukalusi mo ngingi ngatama pekiaꞌu ulai noxou Lataua. Ngalulusou ꞌiliꞌilixo masumasua noxinge mo ngaveꞌa ta mitema isoli uasi. ");
INSERT INTO ata_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Lexe nenge taꞌoxo aloxo ne, la male anu uxiunu xavutalau la nenge taulua uasi.” ");
INSERT INTO ata_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Lataua mumaisou lexe aneꞌi milulusou ꞌiliꞌilixo masumasua ane aneꞌi miꞌoxoꞌoxonu. La sou anu muxiunu xavutalau, la ukalusiꞌa ta mitema loxo mulemolu tei ua. ");
INSERT INTO ata_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Iona opoonu masua, la laꞌiaxu misevile xo Lataua muxiunu xavutalau, la ukalusiꞌa ta mitema ne Ninive uasi. ");
INSERT INTO ata_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Xe muavuti la mulinga mulai noxou IAUE aloxo ꞌo, “IAUE, nini nalomusou vaikala noxilo. Eni exolu no tualasilo, la elavusou lexe nini ulai la naxiu xavutalameni, la nakalusiꞌa ta Ninive uasi. La sou eni eꞌume mo emasaxa lexe alai ne Tasisi. Eni elavusou lexe nini Lataua sou alauna. Nalavusou laꞌiaxene palepalea uasi. Nini nalavusou naꞌoxo lailaixe noxixe utotomu mo nalavusou naxiunu xavutalameni sou nalosou itema vile navunavu uasi. ");
INSERT INTO ata_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ioxe, IAUE nini nakalusou maulixo alalae ꞌosi. Laixe lexe eni asoli ia lexe eni asoli uasi, la anu laixe uasi.” ");
INSERT INTO ata_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","IAUE mukolinu vaikalau aloxo ꞌo, “Nini laꞌiaxeneu xo maꞌi?” ");
INSERT INTO ata_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Iona muꞌumesou tuala tila ne Ninive, la mulai no ale no xalee tuala ane aso uxali utelo no anu. Anu mutulusou tani alelaxu, la muxolu no anu xo umasaxa lexe umaisou mii maꞌia ane uxali ne Ninive. ");
INSERT INTO ata_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Iliꞌi, la sou Lataua IAUE muxalixu ovu vile sou Iona mutalume no maimaixu, la sou aso uieisou uasi. Anu muxolu laixesi. Iona muꞌosasou ovu ane ne misevile. ");
INSERT INTO ata_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ia loxo neꞌiela no kakau, la Lataua mupalusou tavaluli vile mulai muꞌotunu ovu ne mole muxalo. ");
INSERT INTO ata_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Iliꞌi xe aso muxali tatila, la Lataua muxalixu atume ialuxu muneꞌe no xalee ane aso uxali utelo no anu. Xe aso muieisou Iona kisou, la iou muxalixalili la alaalai sou ulapau. La sou Iona muxavutala, la muvikala aloxo ꞌo, “Laixe lexe eni asoli ia lexe eni asoli uasi, la anu laixe uasi.” ");
INSERT INTO ata_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ia Lataua muvikalanu aloxo ꞌo, “Nini laꞌiaxeneu ovu ane muxalo ꞌo?” Iona mukolinu aloxo ꞌo, “Ani, eni laꞌiaxo misevile. Opoleli masua. Eni asolisi.” ");
INSERT INTO ata_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","IAUE muvikala aloxo ꞌo, “Ovu ane muxali no ꞌolovoxo vilesisi ka musoli no ꞌolovoxo vile la ne, nini naꞌoxo mii vile no anu uasi. Nini nasaxilaꞌu uasi. Ia nini tanenixu mii ane kituꞌa vitanisi ꞌo. ");
INSERT INTO ata_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ia eni talelixu tuala ne Ninive misevile. Xo anu tuala tatila mo ta mitema sou tavuꞌalo misevile. Aneꞌi ilavusou ꞌiliꞌilixo mulapu uasi. Itiitisiꞌa muxali loxo, itemaxu mavulovexa mavulovexa mavulovexa muxatele vile (120,000) xe ta miꞌamiꞌa loxo ta kau iloꞌa ta sipsip kalumo tavuꞌalo misevile.” ");
INSERT INTO ata_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Vaikala ane ne anu siꞌa Iesu Kalisito tamutuꞌovuxu. Iesu ne Anu noxou Deviti ꞌilusunu, xe Deviti ne anu Avalaamu ꞌilusunu. ");
INSERT INTO ata_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Xe Avalaamu ꞌolu ane Aisaki, xe Aisaki ꞌolu ane Iakovo, xe Iakovo ꞌolu ane Iuta iloꞌa ta vimovimou, ");
INSERT INTO ata_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","xe Iuta ta ꞌolu ane Peresi ilou Sela, neniꞌa ne Tamari, xe Peresi ꞌolu ane Esuloni xe Esuloni ꞌolu ane Ramu, ");
INSERT INTO ata_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","xe Ramu ꞌolu ane Aminadavu, xe Aminadavu ꞌolu ane Nasoni, xe Nasoni ꞌolu ane Solomoni, ");
INSERT INTO ata_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","xe Solomoni ꞌolu ane Boasi xe nenu ane Reebu xe Boasi ꞌolu ane Oveti, xe nenu ane Rutu, xe Oveti ꞌolu ane Iesi xe Iesi ne momu ane Tatananu tuala Deviti. ");
INSERT INTO ata_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Xe Tatananu tuala Deviti ne ꞌolu ane Solomoni, Solomoni nenu ne tei la Ulia semau, ");
INSERT INTO ata_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","xe Solomoni ꞌolu ane Rovoamu la Rovoamu ꞌolu ane Avia, Avia ꞌolu ane Asa. ");
INSERT INTO ata_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Xe Asa ꞌolu ane Iosaveti, xe Iosaveti ne ꞌolu Iolamu, xe Iolamu ꞌolu ane Usia, ");
INSERT INTO ata_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","xe Usia ne ꞌolu ane Iotamu, xe Iotamu ꞌolu ane Axasi, xe Axasi ꞌolu ane Esekia. ");
INSERT INTO ata_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Xe Esekia ꞌolu ane Manase, xe Manase ꞌolu ane Amoni, xe Amoni ꞌolu ane Iosia, ");
INSERT INTO ata_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Xe Iosia ꞌolu ane Ekonia, xe Ekonia iloꞌa ta vimovimou. No voxo ane ne aneꞌi milai mixolu no paxa no tani sou navunavu no tuala tila ne Vaviloni. ");
INSERT INTO ata_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iliꞌi no voxo ane ta Isilaeli milai mixolu no tani sou navunavu ne Vaviloni, la Ekonia ꞌolu ane Salatieli xe Salatieli ꞌolu ane Seluvaveli. ");
INSERT INTO ata_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Xe Seluvaveli ꞌolu ane Aviuti, xe Aviuti ne ꞌolu ane Eliakimu, xe Eliakimu ꞌolu ane Asolu, ");
INSERT INTO ata_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","xe Asolu ꞌolu ane Sadoku, xe Sadoku ne ꞌolu ane Akimu la Akimu ꞌolu ane Eliutu, ");
INSERT INTO ata_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","xe Eliutu ꞌolu ane Eliasa xe Eliasa ꞌolu ane Matani, ia Matani ne ꞌolu ane Iakovo, ");
INSERT INTO ata_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Xe Iakovo ne ꞌolu ane Iosepu, xe Iosepu anu Malia mulue, la sou Malia mivoꞌonu Iesu la aneꞌi mimoxoꞌu lexe anu Kalisito. ");
INSERT INTO ata_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","La sou Avalaamu ta ꞌilusulusunu musoko noxou anu Avalaamu muneꞌe muxali noxou Deviti la aneꞌi mixali loxo mavulovexa mo mulelia tamiꞌa, mo musoko noxou Deviti mune muxali no voxo aneꞌi milai mixolu no paxa no tani sou navunavu no tuala tila ne Vaviloni anu mavulovexa mo mulelia tamiꞌa. Xe musoko no voxo ane aneꞌi milai mixolu no tanisou navunavu ne Vaviloni muneꞌe muxali no voxo e Kalisito muxali ne la muxali loxo mavulovexa mo mulelia tamiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aꞌalosou Iesu kalisito muxali aloxo. Nenu Malia aneꞌi misosovosie mukalu sou iuluxu Iosepu ia ilou ixolu ipita uao, ia aneꞌi mimaisie lexe ane opoone. Keakea ane ne no anu xavi noxou Uleenu Tavuna la mumulaxu no nano no opoone. ");
INSERT INTO ata_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mulue Iosepu anu itema mulapu, anu mulomu lexe Malia opoone la anu lexe usuane ia anu umasaxa lexe upamaela ne Malia no ieꞌi ta mitema uasi, la sou anu umasaxa lexe usuꞌane seꞌisisi. ");
INSERT INTO ata_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iosepu uxoo uxavuxavutala la muai pipiena lexe angelo noxou tila muxali noxou la sou muvikalanu aloxo ꞌo. “Iosepu, nini Deviti ꞌilusunu, naꞌume mamu nanoꞌe Malia loxo semameni. Nalomu! Molomolo ane muxolu no opoone ne muxali no anu xavi noxou Ulee Tavunasi. ");
INSERT INTO ata_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ane ivoꞌonu ꞌilie mulu, la nalemolu ualasou lexe Iesu xo Anu sou uxexeenu ꞌiliꞌilixo masua noxiꞌa ta mitema mo ulivunoxaꞌa.” ");
INSERT INTO ata_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mimii tavuꞌalo ꞌo, muxali sou umomosou vaikala vile tila muꞌoxonu no anaxaꞌa ta mitemasou palomatana. ");
INSERT INTO ata_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Muvikala aloxo ꞌo. “Nalomu, sema vile ilou mulu iai ipita uao, ia ane opoone la ivoꞌonu molomolo mulu vile la ngingi ngamoxoꞌu ualasou lexe Enmanueli.” (Uala ne laaxu lexe Lataua uxolu nonginge.) ");
INSERT INTO ata_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","No voxo ane Iosepu mutulu la anu mulai muꞌoxonu aloxo angelo noxou Tila muvikala nuxu lexe anu unoꞌe semau. ");
INSERT INTO ata_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ia ilou iai uasi, mulai muxali no voxo e Malia mivoꞌonu ꞌilie no anu, la sou mumoxoꞌu ualasou lexe Iesu. ");
INSERT INTO ata_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Malia mivoꞌonu Iesu no tuala ne Vetiliemu, no xalee lia tila ne Iutaia, no voxo ane Elodesi muxolu tatananu tuala. Ane mivoꞌonu Iesu mukalu xe iliꞌi la ta mitema sou lavulavu meꞌa no aso uxali utelo mineꞌe ne Ielusalemu. ");
INSERT INTO ata_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","La aneꞌi mitalitaliꞌi aloxo ꞌo. “Molomolo e muxali lexe anu tatananu tuala ne Iutaia ne Anu muxolu ꞌava? Xo nengi temaisou oto sou no xalee mutelo no anu aso uxali utelo, la sou nexi teneꞌe sou talotu ulai noxou.” ");
INSERT INTO ata_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Xe Elodesi tatananu tuala mulomu aloxo ne la anu muxavutala piena no anu, mo ta mitema ne Ielusalemu kalumo. ");
INSERT INTO ata_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","La sou Elodesi muavuti la muꞌavaliꞌa ta kisiꞌa ta ailiꞌi xe ta mitema sou lavulavu no ꞌa lapuloto ne Isilaeli mineꞌe mipita sou mutaliꞌisiꞌa lexe mivoꞌonu Kalisito a neꞌei? ");
INSERT INTO ata_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aneꞌi mikolinu lexe, “Ne Vetiliemu no xalee lia tila ne Iutaia. Xo ta mitema sou palomatana mikaukavu aloxo. ");
INSERT INTO ata_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nini ta mitema ne Vetiliemu no xalee lia tila ne Iutaia, nini naxavutala lexe nini mii vitanisi no iei tatananu tuala ne Iutaia uasi. Xo tila uxali noxine, sou usaxilaꞌa ta mitema noxilo ne Isilaeli.’” ");
INSERT INTO ata_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Xe Elodesi musova anaxu mulai noxiꞌa ta mitema sou lavulvavu ne la mitalumesi, la milai noxou sou ulavusou laixe noxiꞌa lexe oto ne muxali a talu. ");
INSERT INTO ata_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","La sou anu mupalusiꞌa milai ne Vetiliemu, la muvikalaneꞌi aloxo ꞌo. “Ngingi ngalai la ngakamuli molomolo ne laixe. Lexe ngingi naxali sou ukalu la sou ngasovanu vaikala ulivu uneꞌe noxilo. Mo eni kalumo alai alotu noxou.” ");
INSERT INTO ata_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Xe aneꞌi milomusou vaikala noxou tatananu tuala ne mukalu, la sou aneꞌi milai. Aneꞌi mimaisou oto loxo aneꞌi mimaisou teꞌi no aso uxali utelo, oto ne muulaxuneꞌi mulai mutulu muisalili teitexi no tani e molomolo ne muai no anu. ");
INSERT INTO ata_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Xe aneꞌi mimaisou oto aloxo ne la miꞌosa manina. ");
INSERT INTO ata_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","La aneꞌi miꞌunalai no tani, la mimaisiꞌa keakea ilee nenu Malia, la mixolaꞌu tavaꞌa voꞌuxu mo mitangatulu muluꞌelai no lia sou milotu mulai noxou keakea. Aneꞌi minoꞌu mimii e loxo xoulu, xe ueli, xe avuavu e tumaꞌu laixe sou milolovolo mulai noxou. ");
INSERT INTO ata_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Xe miai no ꞌolovoxo la miai pipiena lexe Lataua muvikalaneꞌi lexe mamu sou ngingi ngalivu ngalai noxou Elodesi, la sou aneꞌi mimulinu voteꞌi vileli sou milivu milai no tualasiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aneꞌi milivu mukalu, la sou Iosepu muai pipiena lexe angelo noxou Tila muxali noxou la muvikalanu aloxo ꞌo. “Natulu mo nanoꞌa keakea ilee nenu mo ngavula ngalai ne Aixiputo. Ngaxolu ne ulai uxali no anu voxo ane lexe eni avikala neni. Xo Elodesi anu ukamulinu keakea ne sou lexe uvau usoli.” ");
INSERT INTO ata_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Anu muavuti la muvulaneꞌi keakea ilee nenu no ꞌolovoxo la iloꞌa milai ne Aixipto, ");
INSERT INTO ata_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","La iloꞌa milai mixolu ne mutalo no voxo ane Elodesi musoli, la mimii ane ne anu mumomosou vaikala vile Tila muxalixu teꞌi no anaxu itema sou palomatana vile ne muvikala aloxo ꞌo, “Eni aꞌavalou alixeni uatu ne Aixipto.” ");
INSERT INTO ata_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Xe Elodesi mulavu lexe ta mitema sou lavulavu no aso uxali utelo ꞌole ne mikalavoinu, la anu laꞌiaxu misevile la anu mupalusiꞌa ta mitema sou ꞌotoꞌoto noxou milai no tuala tila ne Vetiliemu. La muvikalaneꞌi aloxo ꞌo. “Ngalai no tuala tila mo ngaveꞌaveꞌa ta molomolo ta mulu e tauu iexaꞌa muxali loxo tamei mo uluꞌe isoisoli.” Xo anu xavutalau lexe uꞌvea ta molomolo ta kitukitu e ta neniꞌa miꞌvoꞌoneꞌi no voxo ane ne. Umomomo loxo anu mutaliꞌisiꞌa ta mitema sou lavulavu lexe voxo ane vaa ne oto muxali no anu. ");
INSERT INTO ata_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","La sou mimii ane ne umomosou vaikala noxou Ieremaia itema sou palomatana mulemolu aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tama tila mo imatengalei ilomu sou uxali no tuala tila ne Lama. Ia Lakeli itatamasiꞌa ta ꞌiliꞌe misoisoli. La ane imasaxa lexe ta mitema ixolixoline uasi. Xo ta ꞌiliꞌe tavuꞌalo ne ixolu uasi.” ");
INSERT INTO ata_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Iliꞌi no voxo e Elodesi musoli mukalu, la Iosepu muxolu ne Aixiputo. Anu muai pipiena lexe angelo noxou Tila muxali noxou la muvikalanu aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Nini natulu, mo nanoꞌa molomolo ilee nenu ꞌo mo nalivu ulai ne Isilaeli. Xo ta mitema imasaxa lexe ivaꞌu keakea ne a misoisoli mukalu.” ");
INSERT INTO ata_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iosepu muavuti la munoꞌa keakea ilee nenu milivu milai no tuala tila ne Isilaeli. ");
INSERT INTO ata_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anu mulomu lexe Akelao munoꞌu tanixu momu Elodesi sou usaxilaꞌa ta Iutaia. Iosepu mumamaꞌu sou lexe ulai no xalee ane ne. La Lataua muvikalanu no anu aipiepiena lexe nalai no tuala tila ne Xalilaia. ");
INSERT INTO ata_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","La sou anu mulai muxolu no tuala tila ne ilemolu lexe Nasaleti. ꞌIlixo ane ne mumomosou vaikala noxiꞌa ta mitema sou palomatana lexe, “Aneꞌi ilemolu lexe itema siꞌe Nasaleti.” ");
INSERT INTO ata_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","No voxo ane no mine Iesu muxoxolu ne Naseleti ne Ioanesi itema sou uꞌulosiꞌa ta mitema anu muxali. Anu muneꞌe muꞌavaꞌava no xalee lia vitanisi ne Iutaia, la muvikala aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ngingi ngaxiu opongengi. Xo saxisaxilaꞌu teitexi no opo loxotolo anu a ꞌalaꞌalai mukalu.” ");
INSERT INTO ata_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ioanesi anu itema e Lataua muvikalanu no anaxu itemasou palomatana Aisaia, anu muvikala aloxo ꞌo, “Ngalomu sou itema vile uꞌavaꞌava no xalee lia vitanisi lexe ngalalaxiinu voteꞌi mo ngamomosou voteꞌi sou Tila.” ");
INSERT INTO ata_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioanesi ne musakii kameli laxusou sou mutaluxu vasimolu, xe muutupokoxu bulumakau sosou. ꞌAniꞌanixu ane musiaꞌe taula ilou unuxu. ");
INSERT INTO ata_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ta mitema mutelo ne Ielusalemu mo ne Iutaia mo tuatuala e ꞌalai no lexa Ioridani aneꞌi mineꞌe noxou Ioanesi, ");
INSERT INTO ata_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","la aneꞌi mipaꞌalixu lamana ꞌiliꞌilixo masumasua noxiꞌa, la sou anu muꞌulosiꞌa no lexa ne Ioridani. ");
INSERT INTO ata_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ia mumaisiꞌa ta Palisaio iloꞌa ta Sadokaio mineꞌe sou lexe uꞌulosiꞌa la anu muvikalaneꞌi aloxo ꞌo. “Ngingi loxo lasile molosila ta ꞌolu, Lataua laꞌiaxuinge ia ꞌei muvikalangengi lexe ngaꞌume sou ngapolopepeenu laiꞌa noxou.” ");
INSERT INTO ata_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lexe ngingi ngaxiu opongengi manina, la ꞌiliꞌilixomengi ne umaxaꞌinge, lexe ngingi ngexiu opongengi. ");
INSERT INTO ata_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ia mamu sou tangengi uvikalangengi, “lexe ngingi Avalaamu ta ꞌiluꞌilusunu.” Eni avikalangengi aloxo. Lataua umomomo sou uꞌoxonu lavoꞌo la uxali Avalaamu ta ꞌiluꞌilusunu. ");
INSERT INTO ata_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lapemu a mulalaxii muai no ovu tavaꞌu. Lexe ovu ane uneneꞌa laixe uasi la ixetau loxo itema vile uxetau ovu sou uleanu no navu. ");
INSERT INTO ata_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","La sou eni avikalangengi lexe eni aꞌulosinge no anu lexa vitanisi loxo sosovo, sou ngingi ngexiunu opongengi, la iliꞌi la itema vile xaviinu uneꞌe la uꞌulosinge no anu Uleenu Tavuna mo navu, la xavi noxou ne uaulixu xavi noxilo. Mo eni amomomosou alulusou lamotasou siove sou tavaꞌu uasi. ");
INSERT INTO ata_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anu uneꞌe loxo itema vile, utetelisou silapa no avolu sou ukalipalanu uiti sosou sou uꞌelaxu no anu navu e ukalu uasi. Ia temanu la uai no taasou laꞌilali. ");
INSERT INTO ata_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","No voxo vile la Iesu molu ne Xalilaia muneꞌe no lexa ne Ioridani, sou umasaxa lexe Ioanesi uꞌulosou. ");
INSERT INTO ata_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ia Ioanesi mumulesou la muvikalanu aloxo ꞌo, “umomomo lexe nini naꞌulosilo ia loxovaa ane nini neneꞌe noxilo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","La sou Iesu mukolinu vaikalau aloxo, “Naꞌoxo loxo ne uasi. Nenge taꞌoxonu mimii tavuꞌalo ne umomomo ukalusi ulai noxou Lataua aloxo ne.” La sou Ioanesi mumulinu vaikala noxou. ");
INSERT INTO ata_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","No mine Iesu muꞌulo mukalu, la sou mulaa no lexa sou mulai no ale. La sou opo loxotolo mukisi la Iesu mumaisou Uleenu Tavuna muluꞌe loxo ngiala kuau muvava muluꞌe muxolu no kisou. ");
INSERT INTO ata_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","La sou vaikala vile molu teitexi no opo loxotolo muꞌava aloxo. “Eni ꞌalixeni ane, eni amasaxau mo opoleli uꞌosasou misevile.” ");
INSERT INTO ata_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iesu muꞌulo mukalu la Uleenu Tavuna mulutulixu sou mulailixu no xalee lia vitanisi, sou Satani utovonu. ");
INSERT INTO ata_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu mupelemu la unoꞌu ꞌani uasi aso mavulovexa tamiꞌa xe ꞌolovoxo mavulovexa tamiꞌa la Anu musolixu. ");
INSERT INTO ata_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Itemasou tovotovo muneꞌe sou utovonu la muvikalanu aloxo ꞌo. “Lexe nini Lataua ꞌolu manina la navikalanu lavoꞌo mo uxali veleti.” ");
INSERT INTO ata_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","La Iesu mukolinu vaikalau aloxo ꞌo. “Vaikala muai no nano no Lavuku Tavuna teinu noxou Lataua muvikala aloxo, ‘Ta mitema imauli no anu veletisi uasi ia aneꞌi imauli no anu vaivaikala ane ulaa no anaxu Latauasi.’” ");
INSERT INTO ata_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Anu muvikala loxo ne mukalu, la sou Satani munoꞌu mulai no tuala tila ne Ielusalemu, sou mutelailixu no tani tila noxou Lataua kisou teitexi manina. ");
INSERT INTO ata_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","La muvikalanu lexe. “Nini Lataua ꞌOlu manina la nailiꞌe uluꞌelai. Xo lavuku noxou Lataua muvikala lexe anu uvikalaneꞌi ta angelo noxou la ilooxene mo iamoneni teitexi no avoꞌa si, mo sou naꞌotunu tavaꞌine no ꞌa lavoꞌo uasi.” ");
INSERT INTO ata_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu muavuti la mukolinu aloxo ꞌo. “Vaikala noxou Lataua muvikala lexe, mamu sou natovonu Lataua Tila noxine.” ");
INSERT INTO ata_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mukalu la Satani mulutulixu Iesu mutelailixu teitexi no laxaꞌilu kisou, mukalu la mulosioxu mimii iouiou no xalexalee lia ꞌo ilou tokolomosou. ");
INSERT INTO ata_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","La anu muvikalanu Iesu aloxo ꞌo. “Lexe nini naxolaꞌu tavaꞌine voꞌoxu no lia sou nalotu uneꞌe noxilo la sou eni alosine mimii tavuꞌalo ꞌo ne ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu muavuti la mukaitolonu lexe, “Satani nalai vaꞌaxu vaikala noxou Lataua muvikala aloxo ꞌo. ‘Nini naluꞌelailixene noxou Lataua Tila noxine mo nini nalotu ulai noxou Anusisi.’” ");
INSERT INTO ata_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Xe Satani muꞌume la mulai, la ta angelo mineꞌe mixali noxou Iesu sou misuꞌulinu. ");
INSERT INTO ata_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Xe iliꞌi la Iesu mulomu lexe aneꞌi miteteli sou Ioanesi sou milailixu no taasou navunavu, la sou Anu mulivu mulai no tuala no xalee lia tila ne Xalilaia. ");
INSERT INTO ata_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ia Anu musuku no tuala tila ne Naseleti sou muluꞌelai ne Kapenaumu ne muxolu no paꞌumolu kupa ne no lialiaxaꞌa mata noxiꞌa ta Sevuloni iloꞌa ta Napitali. ");
INSERT INTO ata_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ꞌIlixo ane ne, Iesu mumomosou vaikala muxali noxou Lataua muxali no anaxu Aisaia itema sou palomatana aloxo. ");
INSERT INTO ata_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lialia noxiꞌa mata ta Sevuloni mo Napitali lia ne muxolu ꞌalai no voteꞌi tila ulai no luaki, xe lia e muxolu no xalee lexa ne Ioridani anu lia ne muxolu no nano no xalee lia tila ne Xalilaia, tuala xalee ane ne noxiꞌa ta mitema ane aneꞌi ta Iutaia uasi. ");
INSERT INTO ata_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mo ta mitema tavuꞌalo noxou Lataua ane mixolu no ꞌa isivoxo tatila ne aneꞌi mimaisou teelu kaaxu, mo lamanaxu ne muxali noxiꞌa ta mitema e ilavusou Lataua uasi la loxo misoisoli ne lamana muxali noxiꞌa kalumo.” ");
INSERT INTO ata_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","No voxo ane Iesu musoko sou muaꞌaloiꞌa ta mitema la muvikalaneꞌi aloxo ꞌo. “Ngingi ngaxiunu opongengi xo saxisaxilaꞌu no opo loxotolo anu a ꞌalai mukalu.” ");
INSERT INTO ata_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","No voxo vile, la Iesu muamuaꞌi no paꞌumolu kupa ne Xalilaia, la mumaisou itema vile ualasou lexe Saimoni ilemo lexe Pita ilou vimou Andeleasi ikakae. Xo aneꞌi ilou ta mitema sou ikaeneꞌi ta sinana. ");
INSERT INTO ata_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Xe muavuti la muvikalaneꞌi ilou aloxo ꞌo. “Nganeꞌe mo ngamulileli mo sou eni alosinge lavulavu sou ngalapuneꞌi ta mitema.” ");
INSERT INTO ata_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Xe alaxu vilesisi ꞌo, la ilou mitautalonu kaexaꞌa muai ne, ia milutu sou mimulinu Iesu. ");
INSERT INTO ata_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ia milutu sou mimuamuaꞌi misuku milai, sevile la mumaisiꞌa Iakovo ilou vimou Ioanesi Sevedi ta ꞌolu. Aneꞌi iloꞌa mamiꞌa ixoxolu teitexi no anu uaxa mo isimesimenu kaexaꞌa. Iesu muavuti la muꞌavaliꞌa ilou. ");
INSERT INTO ata_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Xe ilou miavuti la miꞌumesou mamiꞌa no ꞌa xaixai noxou no anu uaxa ne, ia aneꞌi ilou milutusou mimulinu Iesu. ");
INSERT INTO ata_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Xe iliꞌi, la Iesu muxixao no xalee tuala tila ne Xalilaia la muꞌunalai no tani sou lalotu noxiꞌa ta Iutaia sou mulosiꞌa lavulavu, xe Anu muaꞌaloxu aꞌalo laixe sou saxisaxilaꞌu noxou Lataua, mo Anu mupamaulineꞌi ta mitema ane pipiena muꞌoxo masuanu vasimeꞌa kalumo. ");
INSERT INTO ata_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","La sou aneꞌi miaꞌalo mulai no tuala xalee tila ne Silia. La ta mitema milailixaꞌa aneꞌi ane pipiena iouiou muꞌoxo masuaneꞌi. Aneꞌi ane navunavu tatila muꞌoxoneꞌi, mo aneꞌi ane ta uleenu ta masmasua mixolu noxiꞌa, mo aneꞌi ane pipiena masua e uꞌoxonu vasimeꞌa uoloolo la ilapau, xe aneꞌi ane vasimeꞌa musoisoli, la sou Iesu mupamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Anu muꞌoxonu aloxo ne xe ta mitema tavuꞌalo ne Xalilaia mo no xalee lia tila ne Dekapolisi mo ne Ielusalemu mo ne Iutaia mo xalee lia e mixolu ꞌalai no lexa paꞌumolu ne Ioridani ne aneꞌi mimaisou la sou mimulinu. ");
INSERT INTO ata_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu mumaisiꞌa ta mitema tavuꞌalo mineꞌe la Anu mutelai muxolu teitexi no laxaꞌilu vainu la sou ta molomolo noxou mineꞌe noxou. ");
INSERT INTO ata_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","La sou Anu musokosou muaꞌaloiꞌa aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aneꞌi ane uleneꞌi iu lavuluti uasi la aneꞌi iꞌosa iliꞌi la Anu ualusiꞌa xo iliꞌi la aneꞌi ixolu no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aneꞌi ane itatama la aneꞌi iꞌosa xo iliꞌi la Anu ualusiꞌa mo uxolixolineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aneꞌi ane italoxolixaꞌa iluꞌelai la aneꞌi iꞌosa xo iliꞌi la Anu ualusiꞌa la lia ane ꞌo ne aneꞌi naꞌa. ");
INSERT INTO ata_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aneꞌi ane isoisolixaꞌa sou imulinu ꞌiliꞌilixo mulapu la aneꞌi iꞌosa xo Anu ualusiꞌa iliꞌi la aneꞌi iꞌanaꞌana, no anu ꞌilixo sou imulinu masaxa noxou Lataua utotomu. ");
INSERT INTO ata_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aneꞌi ane iꞌoxo alauna la aneꞌi iꞌosa xo Anu ualusiꞌa mo uꞌoxo alauna noxiꞌa iliꞌi. ");
INSERT INTO ata_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aneꞌi ane oponeꞌi malemalenga la aneꞌi iꞌosa xo Anu ualusiꞌa mo iliꞌi la aneꞌi imaisou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aneꞌi ane ixolixolineꞌi ta mitema no anu ꞌotoꞌoto sou ukalu la aneꞌi iꞌosa xo Lataua ualusiꞌa la nenge tamoxoꞌa lexe aneꞌi Lataua ta ꞌolu. ");
INSERT INTO ata_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aneꞌi ane miꞌoxo masuaneꞌi xo miꞌoxonu ꞌiliꞌilixo mulapu la aneꞌi iꞌosa xo iliꞌi la Anu ualusiꞌa mo aneꞌi ixolu no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ngingi ane ta mitema ilevetesinge mo iꞌoxomasuangengi mo ivikalasinge masumasua mo ikalavoisinge xo ngemulinu Itema ꞌOlu ne, la ngingi ngaꞌosa. ");
INSERT INTO ata_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ia ngingi naꞌosa mo ngalei xo ulumengi ne tatila a uai teitexi no opo loxotolo xo ꞌilixo ane aneꞌi miꞌoxonu noxine ne anu iou vilesisi aloxo aneꞌi miꞌoxo masuaneꞌi ta mitema sou palomatana tei. ");
INSERT INTO ata_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ngingi loxo au siꞌa ta mitema iouiou no tuala xalexalee ukalusi ia lexe au ne tuꞌaxu ukalu la nenge talivu noxu tuꞌaxu a loxovaa, xo au ane loxo ne la xaixai vile no anu uasi ta mitema isuꞌanusi ka imalamalaxoꞌu no tavaꞌa. ");
INSERT INTO ata_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ngingi loxo teelu siꞌa ta mitema iouiou no tuala xalexalee ukalusi tuala vile uxolu teitexi no laxaꞌilu la anu utalume uasi. ");
INSERT INTO ata_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta mitema ilavusou itoisou lalamo ka itaa uꞌunalai no nano no tiꞌa uasi, ia aneꞌi imulaxu teitexi no valovalosi sou ukaa siꞌa ta mitema tavuꞌalo e ixolu no nano no tani. ");
INSERT INTO ata_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","La sou anu iou vilesisi aloxo nini ne loxo teelu sou ukaa la lamanaxu ne uieisiꞌa ta mitema mo aneꞌi imaisou ꞌiliꞌilixo laixe ngingi ngeꞌoxonu la sou aneꞌi iꞌitinu ualasou Maminge e muxolu teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mamu ngingi ngaxavutala lexe eni exali sou axexeenu lapuloto mo vaikala noxiꞌa ta mitema sou palomatana, uasi. Eni eneꞌe ꞌo sou axexeenu uasi eni eneꞌe ꞌo sou aꞌoxo pekiaꞌu sou. ");
INSERT INTO ata_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eni avikalanengi manina lexe umomomo no voxo ane loxotolo ilou lialia ukalu la vaikala mautunu vile mo kaukavu vile aneꞌi mikaukavunu no nano no lapuloto tasiauxu uasi uxolu aloxo ne ulai utalo lexe mimii tavuꞌalo ne uxali ukalusi. ");
INSERT INTO ata_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lexe itema vile umaisou lapuloto xalenu vile aloxo mii vile vitanisi, ia anu ulapuneꞌi ta mitema sou iꞌoxonu aloxo ne la ualasou itema ne uxali kituꞌa manina teitexi no opo loxotolo. Ia itema ne umulinu lapuloto ne sou ulosieꞌi ta mitema sou imulinu la sou anu ualasou tila no a saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Eni avikalangengi manina lexe ngamulinu masaxa noxou Lataua mo ꞌiliꞌilixo mengi ulapu laixe uasi loxo ꞌiliꞌilixo mulapu noxiꞌa ta mitema sou lavulavu no ꞌa lapuloto iloꞌa ta Palisaio la ngingi ngamomomosou ngaꞌu nalai no a saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo uasi. ");
INSERT INTO ata_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ngingi ngalomusou vaikala noxiꞌa ta ꞌilusungengi minoꞌu mukalu lexe, ‘Ngingi ngaveꞌa ta mitema isoli uasi, itema vile uvaꞌu itema vile usoli la anu utulu no ꞌa vaivaikala.’ ");
INSERT INTO ata_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ia eni avikalangengi aloxo ꞌo, lexe itema vile laꞌiaxuu vimou la anu utulu no anu vaivaikala. Mo ꞌenaꞌei ane uvikalanu vimou lexe ‘Kisine muxovulaulau ꞌo.’ la anu uxali noxou tatananu lapuloto teꞌi, ia itema vile uvikalanu itema vaꞌaxu aloxo ‘nini itema ne nexovulaulau manina.’ la anu ulai no taxa e navu uꞌaniꞌani no anu kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","La sou lexe nini naneꞌenu lolovolo noxine sou naelaxu no valovalo ia naxavutalanu mii vile ngamomosou noxou vivine uao la, ");
INSERT INTO ata_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","namulaxu lolovolo noxine ne uai ꞌalai no valovalo ne ia nalai mo namomosou tei ꞌo. Lexe ngingi ngongou ngexali no anu opo vilesisi ukalu la sou nini nalai naelaxu lolovolo noxine ne. ");
INSERT INTO ata_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ia itema vile umasaxa sou utulusine no anu vaivaikala, la ngingi ngongou ngamuamuaꞌi no voteꞌi sou ngalai no tanixu vaivaikala la nini napalea mo ngongou ngamomosou vaivaikala tei. Xo masua sou itema ne ulailixene no avolu itema sou ulomu sou vaivaikala la ulailixene no avolu polisi, la sou polisi umuxaxene no tani sou navunavu. ");
INSERT INTO ata_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eni avikalaneni manina lexe nini naxolu no nano no tani sou navunavu ulai utalo lexe nini nalotonu ulu ane aneꞌi misosovosou noxine.” ");
INSERT INTO ata_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iesu muvikala la aloxo ꞌo, “Ngingi ngelomusou tei lexe, ‘Mamu sou ngingi ngaꞌoxonu ꞌiliꞌilixo sou voteꞌi.’ ");
INSERT INTO ata_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ia eni avikalangengi aloxo, lexe itema vile umaisie sema vile ia iou uisuxe xe tanu umulimuline la loxo anu muꞌoxonu ꞌilixo sou voteꞌi mukalu ne. ");
INSERT INTO ata_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","La sou lexe ieni tema ususulixene sou naꞌoxonu ꞌilixo masua la laixe lexe nini naluvunu mo nasuanu. Anu laixe lexe vasimene xalee vilesisi ne usua loxo io iliꞌi la vasimenge ukalusi ulai no navu ane kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mo lexe avonge tema ususulixene sou naꞌoxonu ꞌilixo masua no anu, la laixe lexe nini naxotonu mo nasuanu. Anu laixe lexe vasimene xalee vilesisi ne usuꞌa loxo io iliꞌi la vasimene ukalusi ulai no navu ane kaluxu uasi.” ");
INSERT INTO ata_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iesu muvikala la aloxo ꞌo, “Ngingi ngelomusou tei lexe, ‘itema vile umasaxa lexe usuꞌane semau la ulosie la pepasou ixotonu taulaꞌixaꞌa.’” ");
INSERT INTO ata_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ia Iesu musolonu vaikala noxou la, la muvikala aloxo ꞌo, “Lexe itema vile uxalisie semau iꞌoxonu ꞌilixosou voteꞌi la anu usuꞌane. Ia lexe anu usuane vitanisi xe ilai iuluxu mulu vile la, la aneꞌi ilou miꞌoxonu ꞌiliꞌilixo sou voteꞌi. ");
INSERT INTO ata_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mo ngingi ngelomu sou kalumo lexe aneꞌi mivikalaneꞌi ta mitema tatei aloxo, ‘Mamu sou ngingi ngasakiinu vaikala vitanisi, ia ngingi ngaꞌoxo manina sou uasi. Lexe ngingi ngesakiinu vaikala la ngaꞌoxonu manina sou ulai noxou Tila.’ ");
INSERT INTO ata_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ia lexe ngingi ngasakiinu vaikala sou mivile, la mamu sou ngavikala lexe manina teitexi. Xo anu Lataua puloulousou sou uxoxolu no anu. ");
INSERT INTO ata_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mo mamu sou ngavikala lexe manina no lia ꞌo, xo lialia ꞌo ne Lataua tavaꞌu tanixu sou ututulu no anu ane. Xe mamu sou ngavikala lexe manina ne Ielusalemu, xo Ielusalemu ne anu tuala tila noxou tatananu tuala e tatila manina ane. ");
INSERT INTO ata_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mo mamu sou ngavikala lexe manina teitexi no kisilo, xo nini namomomo sou nakoinu laxusine vile uxali kea xe muximuxi uasi. ");
INSERT INTO ata_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","La sou laixe lexe vaikala mengi ne manina, la nini navikalasi lexe manina xe uasi la nini navikalasi lexe uasi. Xo vaikala seꞌi la utelo no latanu ne molu noxou itema masua. ");
INSERT INTO ata_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mo ngingi ngalomu sou aneꞌi mivikala aloxo ꞌo, ‘Lexe itema vile uvene no ieni la nini nakolinu mo navau no iou xe uvene no anaxene la nini nakolinu mo navau no anaxu.’ ");
INSERT INTO ata_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ia eni avikalangengi aloxo ꞌo. Lexe itema vile uꞌoxo masuaneni la nini nakolinu uasi. Mo lexe usavaline no xaleneni tema la natolosou xaleneni ae la ulai mo anu usavaline la. ");
INSERT INTO ata_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mo lexe itema vile utulusinge no anu vaivaikala sou lexe nini nalosou tokolomo la nalosou tokolomo ane veveeni noxine kalumo. ");
INSERT INTO ata_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mo itema vile xaviinu sou lexe nini natavulenu laꞌilalixu ulai uxali loxo lova (1,500m) la nini natavulenu ulai utalo loxo lova tamei (3,000m). ");
INSERT INTO ata_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mo lexe itema vile umasaxau mivile noxine la nini nalosousi, mo lexe itema vile ulingau mivile noxine lexe unoꞌu ꞌo xe iliꞌi la ukolinu la nini nalosousi. ");
INSERT INTO ata_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mo ngingi ngelomusou vaikala tei lexe, ‘Ngamasaxaiꞌa ta menexinge ia ngaꞌoxonu masua noxiꞌa ta uluamengi.’ ");
INSERT INTO ata_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ia eni avikalangengi aloxo ꞌo, ngamasaxaiꞌa ta uluamengi mo ngakilakasiꞌa aneꞌi ane iꞌoxonu masuangengi. ");
INSERT INTO ata_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aloxo ne la sou ngingi ngaxali loxo Maminge ta ꞌolu teitexi no opo loxotolo. Anu uꞌoxonu aso uiei teitexi noxiꞌa ta mitema ta masua xe ta mitema ta laixe kalumo. Mo Anu ulavusou uꞌoxonu laꞌiua usili noxiꞌa ta mitema milapu mo aneꞌi ane ilapu uasi kalumo. ");
INSERT INTO ata_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ia lexe ngingi ngamasaxaiꞌa ta mitema e imasaxaingesi la ngingi nganoꞌu ulu ane loxovaa? Male uasi. Ta mitema e itaxusou lamoli noxixe ne aneꞌi kalumo ilavusou iꞌoxonu ꞌilixo aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngingi ngaꞌoxonu aso laixe siꞌa ta vivinge, la ngingi ngauualixaꞌa ta mitema vaꞌaxu no ꞌa mii maꞌia? Male uasi. Tamitema ane aneꞌi ta Iutaia uasi ne aneꞌi iꞌoxonu aloxo ne kalumo. ");
INSERT INTO ata_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ngingi ta mitema ngaxolu ngalapu manina loxo Maminge muxolu no loxotolo ne Anu mulapu manina.” ");
INSERT INTO ata_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mo Iesu musolonu vaivaikala noxou la muvikala aloxo ꞌo. “Ngasaxilainge laixe mamu sou ngingi ngaꞌoxonu ꞌiliꞌilixo mulapu no ieꞌi ta mitemasi sou imaisinge. Xo lexe ngingi ngaꞌoxonu aloxo ne la umomomo sou Maminge teitexi no opo loxotolo ulosinge ulusou vile uasi. ");
INSERT INTO ata_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","La sou ngingi ngamasaxa lexe ngasuꞌulineꞌi ta mitema ane pausiꞌa no anu mimii moseꞌi, la mamu sou ngapalusou itema vile uꞌuli mo utautaunu xoolau sou uvikala lamana aloxo ta mitema sou kalakalavoi iꞌoxoꞌoxonu no taasou lalotu noxiꞌa, xe no voteꞌi sou ta mitema imaisiꞌasi. Eni avikalangengi manina aloxo ta mitema ane iꞌoxonu ꞌilixo aloxo ne aneꞌi minoꞌu ulusou mukalu. ");
INSERT INTO ata_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lexe ngingi ngalosiꞌa ta mitema ane pausiꞌa no anu mimii no avonge tema. La mamu sou avonge ae ulavusou mii maꞌia ane avonge tema uꞌoxoꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mo sou suꞌuli noxinge ne utalumesi. Ngingi ngaꞌoxonu aloxo ne la Maminge umaisou mii maꞌia ane nini neꞌoxonu mutalume ne la Anu ulosinge ulusou. ");
INSERT INTO ata_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Voxo ane lexe ngingi ngakilaka la mamu sou ngingi naꞌoxonu loxo ta mitema sou ikalavoi iꞌoxoꞌoxonu. Aneꞌi imasaxau sou itulu la ikilaka no nano no taasou lalotu noxiꞌa ta Iutaia mo no voteꞌi mupita sou ta mitema imaisiꞌa. Eni avikalangengi manina. Lexe aneꞌi minoꞌu uluiꞌa mukalu. ");
INSERT INTO ata_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ia voxo e lexe nini namasaxa sou nakilaka la nini naꞌunalai no kaveutu noxine mo natatu ukalu la sou nakilaka ulai noxou Mamine muxolu mutalume. La sou Mamine umaisou mimii e ngingi ngeꞌoxonu mutalume ne, la sou Anu ulosinge ulumengi. ");
INSERT INTO ata_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","La sou lexe ngingi ngakilaka la mamu sou ngaꞌoxonu vaikala piena vitavitanisi loxo ta mitema ane aneꞌi ta Iutaia uasi iꞌoxoꞌoxonu. Aneꞌi ixavutala lexe ivivikala tavuꞌalo la Lataua ulomusiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ia mamu sou ngingi ngamulinu ꞌiliꞌilixo noxiꞌa, xo tei no mine ngingi ngakilaka uao la Maminge mulavu sou mii maꞌia ane ngingi ngemasaxau. ");
INSERT INTO ata_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ngingi ngakilaka aloxo ꞌo, “Mamixe nini nexoo teitexi no opo loxotolo, laixe nexi tatoxonu ualasine. ");
INSERT INTO ata_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Laixe nini naluꞌe nasaxilaꞌu tuala ane no lia ꞌo. Mo laixe talomuxene no lia ꞌo loxo aneꞌi ilolomuxene teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vaimomo ꞌo nalosixe laꞌilali sou nexi taꞌou voxovoxo. ");
INSERT INTO ata_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Naxiunu tumalineu ꞌiliꞌilixo masumasua noxixe aloxo nexi taxiunu tumalixeu ꞌiliꞌilixo masumasua noxiꞌa aneꞌi ane miꞌoxo masua muneꞌe noxixe. ");
INSERT INTO ata_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mamu sou naolenexi ulai no anu mimii sou tovotovo. Ia naolenexi ulai vaꞌaxu no anu ꞌiliꞌilixo ane masumasua. (Xo saxisaxilaꞌu ne noxinesi mo xavi mo lamana anu kaluxu uasi. Manina.) ");
INSERT INTO ata_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mo lexe ngingi ngaxiunu tumalingeu ꞌiliꞌilixo masumasua ane ta mitema miꞌoxonu uneꞌe noxinge la Maminge uxolu teitexi no opo loxotolo kalumo uxiunu tumalou ꞌiliꞌilixo masumasua noxinge. ");
INSERT INTO ata_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ia lexe ngingi ngaxiunu tumalingeu ꞌiliꞌilixo masumasua ane ta mitema miꞌoxonu muneꞌe noxinge uasi la Maminge kalumo umomomo sou uxiunu tumalou ꞌiliꞌilixo masumasua noxinge uasi. ");
INSERT INTO ata_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","La sou no mine ngingi ngapelemu la ngakasangi loxo ta mitema sou kalakalavoi iꞌoxoꞌoxonu mamu. Aneꞌi iꞌoxonu ieꞌi uolevolo sou lexe ta mitema imaisiꞌa lexe aneꞌi mipelemu. La sou eni avikalangengi aloxo ꞌo, aneꞌi minoꞌu ulusou mukalu. ");
INSERT INTO ata_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ia no mine ngingi ngamasaxa lexe ngapelemu la ngaꞌulo mo ngamulaxu mii tumaꞌu lailaixe no vasimenge mo iengi. ");
INSERT INTO ata_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mo sou ta mitema ilavusou lexe ngingi ngapelemu uasi. La Maminge anusisi e talavusou tamaisou uasi, Anu molusi umaisou mii maꞌia ane ngingi ngeꞌoxonu mutalume ne la sou Anu ulosinge ulusou. ");
INSERT INTO ata_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mo mamu ngingi xavutalamengi utulu no anu lamoli mo lavuluti e ngamulaxu no lia ꞌo. Xo lamoli mo lavuluti ne ngamulaxu la tatotoxae ixotosou mo uai la ukukakuka la usuꞌa, xe ta mitema sou pakali iꞌuna no tani la ipakalinu. ");
INSERT INTO ata_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ia anu laixe lexe ngingi xavingengiu lamoli mo lavuluti sou teitexi mo ngamulaxu. Xo lamoli mo lavuluti ane teitexi ne tatotoxae ixotosou mo uai la ukukakuka xe ta mitema sou pakali imomomo sou iꞌunalai la ipakalinu uasi. ");
INSERT INTO ata_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Xo no tuala ane ne mimii lailaixe noxinge a uai no anu ne ia tanenge mo xavutala menge a uxolu lai ne kalumo. ");
INSERT INTO ata_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ngingi iengi ne, anu teelu sou vasimenge. Xo lexe iengi ne laixe, la anu ulosinge lamana. ");
INSERT INTO ata_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ia lexe iengi ne masua, la anu ulosinge isivoxosi, ia lexe teelu ne uxolu no nano noxinge ne uasi la isivoxo ne uxali tila misevile. ");
INSERT INTO ata_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Itema sou xaixai vile umomomo sou uxaxai noxiꞌa ta tatila noxou tamei uasi. Xo maasi xe xavutala noxou ukalipala, la anu umasaxau vile uasi, ia tanu vulusiu ane vile aloxo ne la sou ngingi ngamomomo sou ngaxaxai no iou Lataua xe ngaxaxai sou lamoli kalumo uasi.” ");
INSERT INTO ata_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mo Iesu muavuti la muvikalaneꞌi ta mitema la aloxo ꞌo, “Mamu sou ngaxavutala piena no anu maulingenge mo ngavikala lexe nenge taꞌou mii maꞌia mo taiexu mii maꞌia xe tasakiinu mii maꞌia sou vasimenge? Xo laꞌilali anu utila no anu maulingenge mo tokolomo kalumo utila no anu maulingenge? Uasi. ");
INSERT INTO ata_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Loxo naxavutalaneꞌi ta ngiala, aneꞌi ilavusou itotounu xai mo imolo laꞌilali uasi mo, aneꞌi siꞌa tani sou ipitanu laꞌilalixaꞌa no anu uasi. Ia Maminge anu muxolu no opo loxotolo molu ulosiꞌa laꞌilali. Io ngingi ne loxo ta ngiala uasi ngingi ne tatila musuku noxiꞌa mo ngeuaulixaꞌa. ");
INSERT INTO ata_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ia lexe vile nonixi noxinge ne uxavutala piena no anu maulixu lexe uxolu maxuveeni sevile, la anu umomomo sou molu usukunu maulixu ulai sevile? Uasisi manina. ");
INSERT INTO ata_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Loxovaa la ngingi ngaxavutala piena no anu mimii ane loxo tokolomo ꞌo? Ngaxavutalanu kungalo seseenu ne a loxovaa? Anu uxaxaisou uꞌoxonu tokolomo uasi. ");
INSERT INTO ata_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ia avikalangengi lexe Solomoni tatananu tuala ne munoꞌu mimii lailaixe no lia ꞌo mukalusi, ia kungalo seseenu muuaulixu tokolomoxu ne. ");
INSERT INTO ata_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ia lexe Lataua utokolomonu iaiae no anu seseenu ane uleme vaimomo ꞌo xe neꞌiela la ta mitema ixotosou sou iꞌelaxu, la anu utokolomongengi laixe manina musuku uuaulixu sesee ne. Ae, ngingi ta mitema ane ne ngemulaxu tangengi noxou Lataua kituꞌasi ne. ");
INSERT INTO ata_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aloxo ne, la sou mamu sou ngingi ngaxavutala piena no anu mii maꞌia sou ngaꞌou mo ngaiexu mo ngatokolomoxu. ");
INSERT INTO ata_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Xo ta mitema ane ilavusou Lataua uasi no lia ꞌo ne, aneꞌi ixavutala piena sou ikakamulinu mimii ane ne. Ia Maminge muxolu no opo loxotolo ne mulavusou lexe mimii ane ne, anu laixe sou ngingi nganoꞌu. ");
INSERT INTO ata_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ia mii vile lexe ngingi ngaꞌoxonu tei aloxo, ngingi ngaxolu ngataloxolingenge no laaxu Lataua mo ngalomuxu la sou Anu ulosinge mimii latala kalumo. ");
INSERT INTO ata_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aloxo ne la sou ngaxavutala sou neꞌiela mamu, Xo neꞌiela ne anu voxo vilemo, xe tuꞌumaxu sou voxo vilevilesi ne anu iou vilesisi uasi. ");
INSERT INTO ata_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mamu sou ngatilovosou ꞌilixoiꞌa ta menexinge, mo sou Lataua utilovosou ꞌiliꞌilixomengi uasi. ");
INSERT INTO ata_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Xo Lataua utilovosou ꞌiliꞌilixomengi iou vilesisi aloxo ngingi ngetilovosou ꞌiliꞌilixoiꞌa ta menenginge ne. Mo utilovosou ꞌiliꞌilixomengi iou vilesisi aloxo ngingi ngetilovosou ꞌiliꞌilixoiꞌa ta menexinge. ");
INSERT INTO ata_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ia tavaꞌu loxovaa la sou namaisou ꞌiliꞌili seꞌi no iou itema vile noxou Lataua e anu loxo vivine, ia nini namaisou ovu alelaxu e muxolu no ieni ne ua. ");
INSERT INTO ata_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nini namaisou ovu alelaxu uxolu no ieni uasi io loxovaa la sou navikalanu vivine lexe, ‘Vivilo ieni uvaxailosi mo axexeenu, ꞌiliꞌili no ieni.’ ");
INSERT INTO ata_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","La nini loxo itema sou kalavoi manina, tei la nini naxexeenu ovu alelaxu no ieni ꞌo, ka sou namalei lamana laixe la sou naxexeenu ꞌiliꞌili seꞌi noxou vivine iou ne. ");
INSERT INTO ata_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mamu sou naaꞌaaneꞌi ta aꞌaa no ꞌa mimii ane malemalenga, mo mamu sou ngingi ngasuꞌanu tualemengi ulai noxiꞌa ta memee. Lexe ngingi ngaꞌoxonu aloxo ne la aneꞌi imalamalaxoꞌu no tavaꞌa, xe ukalu la ixiu uneꞌe noxinge la ingangasinge mo iteateangengi. ");
INSERT INTO ata_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lexe ngalinga utotomu noxou Lataua la Anu ulosinge mo ngakamulinu utotomu la ngaxalisou xe ngapolopolo noxou utotomu la ukisiinu aitenga noxinge. ");
INSERT INTO ata_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","La sou aneꞌi ane ilinga noxou utotomu la Anu ulosiꞌa mo aneꞌi ane ikakamulinu utotomu la ixalisou, xe aneꞌi ane ipolopolo utotomu la Lataua ukisiinu aitenga noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ꞌEnaꞌei noxinge ꞌolu ulingau veleti la anu ulosou lavoꞌo? Male uasi. ");
INSERT INTO ata_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mo lexe ulingau sinana la anu ulosou sinanaveveeni? Male uasi. ");
INSERT INTO ata_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aloxo ngingi ta mitema ta masua, ia ngelavusou ngalosiꞌa ta ꞌilinge mimii lailaixesi. La sou loxovaa noxou Maminge ane muxolu teitexi no opo loxotolo ulavusou ulosiꞌa aneꞌi ane ilinga mimii lailaixe. ");
INSERT INTO ata_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","La ngaꞌoxonu mii ulai noxiꞌa ta mitema aloxo ngingi ngemasaxa lexe aneꞌi iꞌoxo uneꞌe noxinge ne. Xo mimii ane ne mikaukavunu muai no nano no anu lavukusou lapuloto noxiꞌa ta mitema sou palomatana. ");
INSERT INTO ata_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mo ngingi xavingengi sou ngaꞌunalai no anu aitenga kituꞌa. Xo aitenga mo voteꞌi ane ulai no anu taxasou navunavu ne toxoxaꞌa, la anu seꞌisisi noxiꞌa ta mitema tavuꞌalo sou imulinu. ");
INSERT INTO ata_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ia aitenga mo voteꞌi ane ulai no tualasou mauli ne kituꞌasi, la ta mitema ta taꞌeisi iꞌunalai no anu. ");
INSERT INTO ata_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ngingi ngasaxi laixe noxiꞌa ta mitema sou palomatana kalakalavoi, xo aneꞌi itokolomoxu sipsip laxusou no ale no vasimeꞌa, ia oponeꞌi ne loxo ta aꞌaa ta vova. ");
INSERT INTO ata_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","La sou nenge tatongoneꞌi ta mitema sou palomatana kalakalavoi aloxo, nenge tatongonu ovuovu no anu ngiangiaxu. La sou ta mitema imomomosou ielexu ovu ngiaxu no anu xuxua uasi mo uaini ngiaxu no anu lamota anaanaxu uasi. ");
INSERT INTO ata_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aloxo ne la ovuovu laixe ne uneneꞌa la uxalixu temanu laixe ia ovuovu ane masua uneneꞌa la tematemanu ne anu masua. ");
INSERT INTO ata_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ovu laixe umomomo sou uneneꞌa la temanu masua uasi, mo ovu masua anu umomomo sou uneneꞌa la temanu laixe uasi. ");
INSERT INTO ata_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ovuovu tavuꞌalo ane ne ulavusou uneneꞌa laixe uasi, la ixetaꞌu ka ileanu uluꞌelai no navu. ");
INSERT INTO ata_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aloxo ne la sou ngingi ngatoxonu itemasou palomatana kalakalavoi xe itemasou palomatana manina no anu ꞌilixo noxiꞌa aloxo ngatoxonu ovuovu ne no anu ngiangiaxu. ");
INSERT INTO ata_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ia ngingi ngaxavutala lexe ta mitema e ilavusou imoxoꞌilo lexe tila tila iꞌunalai no anu saxisaxilaꞌu no opo loxotolo. Uasi. Ia ꞌei ane umulinu masaxa noxou Mamilo muxolu teitexi no opo loxotolo anu si a uꞌunalai no anu saxisaxilaꞌu noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","No ꞌa voxo sou vaivaikala tila noxou Lataua la ta mitema tavuꞌalo ivikalaleli aloxo ꞌo, ‘Tila Tila nexi e texaxai loxo ta mitema sou palomatana no ualasine ano, mo nexi tekusaiꞌa ta uleenu ta masumasua no ualasine xe nexi teꞌoxonu sosovo tavuꞌalo ano.’ ");
INSERT INTO ata_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","La eni avikala lamana noxiꞌa aloxo ꞌo, ‘Eni alavusinge sevile uasisi manina, ngingi ngamitema sou ngaꞌoxoꞌoxonu ꞌiliꞌilixo masumasua ane, ngalai vaꞌaxu.’ ");
INSERT INTO ata_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Aloxo ne la sou lexe aneꞌi ane ilomusou mo imulinu vaivaikala noxilo ꞌo, mo imuxaxu no taneꞌi, la aneꞌi aloxo itema e xavutalau laixe la mutulusou taasou teitexi no kulukisou. ");
INSERT INTO ata_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Laꞌiua usili la uluꞌe mo lexa uanianipaa mo atume uili uneꞌe utuvu vaxa no anu tani ne, la tani ne umomomosou ulapau uasi. Xo anu mutulu teitexi no anu kulukisou. ");
INSERT INTO ata_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ia aneꞌi ane ulomusou vaivaikala noxilo ꞌo, ia imuxaxu no taneꞌi mo imulinu uasi, la aneꞌi aloxo itema e xavutalau laixe uasi, la mutulusou taasou teitexi no iꞌoiiꞌoi. ");
INSERT INTO ata_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Laꞌiua musili muluꞌe mo lexa muanianipaa mo atume muili muneꞌe musuꞌa vaxa no anu tani ne la mulapau. Anu mulapau ne la masua avile.” ");
INSERT INTO ata_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu muxalilixu vaikala ne mukalu, la ta mitema tavuꞌalo mikuluke manina no anu vaikala noxou. ");
INSERT INTO ata_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Xo Anu mulosiꞌa lavulavu ne loxo ta mitema sou lapuloto ilavusou iꞌoxoꞌoxonu uasi, ia Anu mulosieꞌi loxo itema e anu munoꞌu xavi sou uꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu molu no laxaꞌilu sou muluꞌe, la ta mitema tavuꞌalo mimulinu. ");
INSERT INTO ata_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xe iliꞌi la itema vile vulukali muꞌoxonu ne muneꞌe noxou Iesu. La muxolaꞌu tavaꞌu voꞌoxu mo mutangatulu no talaxu la muvikalanu sou lexe upamaulinu. La sou muvikalanu aloxo ꞌo, “Lexe nini namasaxa la napamaulileli mo eni axali malemalenga.” ");
INSERT INTO ata_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","La Iesu mukasivaxa no vasimolu la muvikalanu aloxo ꞌo, “Eni emasaxa lexe nini naxali malemalenga.” Xe alaxu vilesisi o la vulukali ne muxexee avile mole anu mumalemalenga. ");
INSERT INTO ata_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Xe Iesu muavuti la mupalusou mulai. La mulosou vaikala pekiaꞌu aloxo ꞌo, “Nalai ia umomomo sou naaꞌalou evile no anu mii ane eni eꞌoxonu noxine o uasi manina. Ia nalai namaxainesi noxiꞌa ta ailiꞌi mo nalosiꞌa mii ane iꞌelaxu ulai noxou Lataua loxo Mosesi mulemolu sou napalaꞌalixu lexe nini nexali malemalenga no iou Lataua mukalu mo sou ta mitema imaisou la ilavu lexe nini vasimene laixe mukalu.” ");
INSERT INTO ata_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu muꞌunalai no tuala tila ne Kapenaumu, la itemasou usaxilaꞌa ta mitema itemaxu taꞌuve sou ꞌotoꞌoto ne Romu muneꞌe la mutaliꞌisou Iesu sou usuꞌulinu, ");
INSERT INTO ata_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tila, itemasou xaixai noxilo mupipiena mo anu vasimolu usoisoli xe navunavu muꞌoxonu mo a uai no tani.” ");
INSERT INTO ata_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","La sou Iesu muvikalanu aloxo ꞌo, “Eni alai mo apamaulinu.” ");
INSERT INTO ata_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ia itema sou usaxilaꞌa ta mitema itemaxu taꞌuve sou ꞌotoꞌoto mukolinu vaikalau aloxo ꞌo, “Tila eni amitema a laixe sou nini naꞌuna no taasilo uasi, nini navikalasi la sou itema sou xaixai noxilo ne anu umauli la.” ");
INSERT INTO ata_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eni evikala loxo ne, xo eni exolu no laxaꞌa ta mitema e aneꞌi minoꞌu sosovo sou isaxilailo, mo ta mitema sou ꞌotoꞌoto ane eni esaxilaꞌa mixolu no laaxo kalumo. La sou lexe eni apalusou vile lexe nalai la anu ulai, mo avikalanu vile lexe naneꞌe la anu uneꞌe. Xe avikalanu itema sou xaixai noxilo lexe naꞌoxonu mii ꞌo la anu uꞌoxonusi. ");
INSERT INTO ata_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Xe Iesu mulomu vaxa noxou la mukuluke. La sou Anu muvikalaneꞌi ta mitema e mimulinu ne aloxo ꞌo, “Eni avikalangengi manina lexe eni amaisou itema vile nonixi noxinge ta Isilaeli ne umuxaxu taanu, loxo itema o uasi. ");
INSERT INTO ata_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","La sou eni avikalangengi aloxo ꞌo. Ta mitema ane aneꞌi ta Iutaia uasi tavuꞌalo meꞌa no aso uxali xe no aso uꞌuna ilai inoꞌu tanixaꞌa sou iloꞌa Avalaamu mo Aisaki xe Iakovo ixolu ipita la iꞌani no anu laꞌilali tatila teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ia ta Iutaia e Lataua musosovosiꞌa tei sou lexe ixolu no anu saxisaxilaꞌu noxou ne Anu ukusaiꞌa ilai no tuala sou isivoxo no ꞌa xalee a ne itatama mo anaxaꞌa ukalakikiki no anu.” ");
INSERT INTO ata_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","La Iesu muvikalanu itema sou uulaxuneꞌi ta mitema sou ꞌotoꞌoto lexe “Nini nalai, la sou mimii uxali noxine aloxo nini nemulaxu taneni no anu mukalu.” La muisalili no voxo ane ne la itema sou xaixai noxou ne anu mumauli. ");
INSERT INTO ata_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Xe Iesu mulai muxali no tani noxou Pita, la mumaisie Pita leuanu ne iai no luu, xo pipiena muꞌoxone mo vasimele ialuxu. ");
INSERT INTO ata_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xe Anu muavuti la mulai noxie la mukasi vaxa no avole la pipiena ne muxexesie la sou ane mitulu sou mixutuxuxaꞌa laꞌilali. ");
INSERT INTO ata_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Xe no ꞌolovoxo la ta mitema minoꞌa aneꞌi ane ta uleenu ta masumasua mixoo noxiꞌa sou mineꞌe noxou, la Anu mukusaiꞌa ta uleenu ta masumasua sou mixexesiꞌa ta mitema ne. Xe mupamaulineꞌi aneꞌi ane mipipiena. ");
INSERT INTO ata_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anu muꞌoxonu aloxo ne sou umomosou vaikala noxou Lataua mulaa no anaxu itemasou palomatana noxou Aisaia muvikala aloxo ꞌo, “Anusisi uxexeenu vovolea iouiou noxinge mo utavulenu tuꞌumaxu noxinge.” ");
INSERT INTO ata_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ioxe Iesu mumaisiꞌa ta mitema tavuꞌalo mitulu mixaliliu, la muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Nenge talai no kupa xalee vile.” ");
INSERT INTO ata_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ia itema vile sou lavulavu no ꞌa lapuloto muneꞌe la muvikala Iesu aloxo ꞌo, “Tila eni emasaxa lexe amulineni mo nini nalai neꞌei ne la eni amulinenisi.” ");
INSERT INTO ata_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","La sou Iesu mukolinu aloxo ꞌo, “Ta aꞌaa ta vova ne siꞌa taxa no ꞌa lialia sou iai no anu, mo ta ngiala kalumo ne siꞌa iomu sou iai no anu, ia Itema ꞌOlu ne sou tani sou uai no anu uasi.” ");
INSERT INTO ata_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Itema vile sou xaixai noxou muvikalanu Iesu aloxo ꞌo. “Tila eni amasaxa lexe amulineni ia eni alai aꞌasixu mamilo tei o.” ");
INSERT INTO ata_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","La Iesu muvikalanu lexe, “Nini naneꞌe mo namulileli, ia ta mitema ane misoisoli ne aneꞌi meꞌa iꞌasixaꞌa la.” ");
INSERT INTO ata_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Xe Iesu mutelo no ꞌa uaxa la ta molomolo noxou mimulinu, ");
INSERT INTO ata_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","iloꞌa milai nonixi no kupa la sivo tatila xe xasi tatila muavuti la muxiuxiunu uaxa la luaki mupei muꞌuna no uaxa, ia Iesu ne Anu muai. ");
INSERT INTO ata_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ia aneꞌi milai sou mitulusou la mivikalanu lexe, “Tila nasuꞌulinenge, xo nenge ꞌalaꞌalai sou taꞌuoꞌuo.” ");
INSERT INTO ata_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","La sou Anu muvikalaneꞌi aloxo ꞌo, “Muxamuxaxu tangengi noxinge ne anu kituꞌa manina, loxovaa la sou ngingi ngeꞌume ꞌo?” Xe Anu muavuti la mukaitolonu atume ilou xasi ne la atume mukalu la lexa kalumo ne muai seꞌisisi manina. ");
INSERT INTO ata_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","La sou aneꞌi mikuluke no anu, la mivikala lexe “Itema maꞌia ꞌo, e mukaitolonu atume ilou lexa la milomuxu ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesu muxali no xalee lia tila ne Xadala, la muxalisiꞌa ta mitema ta tamei ta uleenu ta masumasua mixolu noxiꞌa. Aneꞌi mimaisou Iesu la meꞌa no lousiꞌa ta mitema misoisoli mineꞌe noxou. Ta mitema ta tamei ne ta uleenu ta masumasua miꞌoxoneꞌi ilou la ilou mivova manina la ta mitema imuamuaꞌi no voteꞌi mautunu ane ne uasi. ");
INSERT INTO ata_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aneꞌi mimaisou Iesu, la ilou miꞌava mulai noxou aloxo ꞌo “Nini Lataua ꞌOlu, loxovaa, voxo a uao, ia nini neneꞌe sou naꞌoxo masuanexi io?” ");
INSERT INTO ata_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Mo miavuti la mivikalanu aloxo ꞌo, “Lexe nini namasaxa sou nakusaixe la napalusixe talai taꞌunalai noxiꞌa ta memee e laoluxaꞌa iuveuve ꞌalai no laxaꞌilu ꞌolele.” ");
INSERT INTO ata_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","La sou Anu muvikalaneꞌi lexe, “Ioxe ta uleenu ta masua ngalai mo ngaꞌunalai noxiꞌa ta memee.” La sou aneꞌi milai miꞌunalai noxiꞌa ta memee la miiave milai no kisou maea la mitalotaloxo miluꞌelai no kupaxu la miꞌuoꞌuo la misoisoli. ");
INSERT INTO ata_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Xe ta mitema sou isaxilaꞌa ta memee ne mimaisou mii ane ne la miꞌume la milai miaꞌalo no anu mii ane muxali noxiꞌa ta mitema ta tamei e ta uleenu ta masumasua mixolu noxiꞌa ilou ne no tuala. ");
INSERT INTO ata_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","La sou ta mitema tavuꞌalo no tuala tila ne mineꞌe noxou Iesu, mimaisou la aneꞌi mivikala pekiaꞌu noxou lexe usukusou lia xalee tila ne mo ulai. ");
INSERT INTO ata_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu mutelo no uaxa la mulai no kupa xalee levi la mulai muxali no tualasou ne Kapenaumu. ");
INSERT INTO ata_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","La ta mitema mitavulenu itema vile vasimolu musoisoli muai no moꞌesou la mineꞌe noxou Iesu. No mine Iesu mumaisou lexe ta mitema ne mimuxaxu taneꞌi manina la muvikalanu itema e vasimolu musoisoli ne aloxo ꞌo, “ꞌAlixeni taneni utulu vilesisi. Eni exiunu tumalilou ꞌiliꞌilixo masumasua noxine.” ");
INSERT INTO ata_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","No mine Anu muvikalanu itema ne aloxo ne, la ta mitema sou lapuloto milomusou la xavutala muxali noxiꞌa lexe, “Itema ne muvikala masua noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ia Iesu mulavusou xavutalaiꞌa ne xe muavuti la muvikalaneꞌi aloxo ꞌo. “Loxovaa la sou ngingi ngaꞌoxonu xavutala masua uꞌoxoo masuanu tangengi ꞌo? ");
INSERT INTO ata_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Vaikala anevaa seꞌisisi sou eni alemolu, lexe eni avikala lexe eni exiunu tumalilou ꞌiliꞌilixo masumasua noxine ne, uasi, avikala lexe natulu mo namuamuaꞌi. ");
INSERT INTO ata_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eni emasaxa lexe ngingi ngalavu sou lexe Itema ꞌOlu munoꞌu xavi sou uxiunu tumalou no anu ꞌiliꞌilixo masumasua noxiꞌa ta mitema.” Xe muavuti la muvikalanu itema e vasimolu musoisoli ne lexe, “Natulu mo nanoꞌu moꞌesine mo nalai no taasine.” ");
INSERT INTO ata_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","La itema ne mutulu la mulivu mulai no taasou. ");
INSERT INTO ata_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta mitema tavuꞌalo mimaisou la mikuluke manina la miꞌitinu Lataua ualasou no anu xavi ane Anu mulosou itema ne. ");
INSERT INTO ata_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xe Iesu mumuamuaꞌi mulai la, la mumaisou itema vile ualasou lexe Mataio uxaxai no anu tanisiꞌa ta mitema sou inonoꞌu lamoli. Iesu muavuti la muvikalanu lexe, “Naneꞌe mo namulileli.” Xe Mataio muavuti ꞌo la mumulinu. ");
INSERT INTO ata_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Xe iliꞌi no mine Iesu mulai sou uꞌani no tani noxou Mataio, la ta mitema sou inoꞌu lamoli tavuꞌalo mo ta mitema sou ꞌiliꞌilixo masumasua mineꞌe la Iesu iloꞌa ta molomolou miꞌani mipita. ");
INSERT INTO ata_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","No mine ta Palisaio mimaisou aloxo ne, la mitaliꞌisiꞌa ta molomolo noxou Iesu lexe, “Loxovaa la sou itema sou ulosinge lavulavu iloꞌa ta mitema sou inoꞌu lamoli xe ta mitema sou ꞌiliꞌilixo masumasua iꞌaniꞌani ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ia Iesu mulomusou vaikala noxiꞌa ne la sou muvikalaneꞌi aloxo ꞌo, “Aneꞌi ane mipipienasi ilavusou ilai noxou itema sou pamauli, ia aneꞌi ane ipipiena uasi, ilavusou ilai noxou itema sou pamauli uasi.” ");
INSERT INTO ata_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ia ngalai mo ngakamulinu vaikala ane ꞌo laaxu laixe, vaikala ne muai no nano no anu Lavuku Tavuna teinu noxou Lataua muvikala lexe, “Eni masaxa tatila noxilo lexe ngingi ngaalaunasinge ngatongatoꞌo ia amasaxau mii e ngaꞌelaxu uasi. Xo eni xaixai noxilo aloxo ꞌo, eni eneꞌe sou aꞌavaliꞌa aneꞌi ane milapu uasi, ia eni eneꞌe sou aꞌavaliꞌa aneꞌi ane iꞌoxoꞌoxonu ꞌiliꞌilixo masumasua.” ");
INSERT INTO ata_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Alaxu vile la ta molomolo noxou Ioanesi mineꞌe noxou Iesu la mitaliꞌisou aloxo ꞌo, “Loxovaa la nexi noxiꞌa ta Palisaio ta pelemu ia ta molomolo noxine ilavusou ipelemu uasi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","La sou Iesu muvikalaneꞌi aloxo ꞌo, “Lexe maulu vile sou utaulaꞌi alavua, la male ta menexu oponeꞌi tuꞌumaxu uasi, xo no voxo ane anu iloꞌa ixolu ꞌo uasi, ia iliꞌi aneꞌi inou itema ne ulai ukalu la anu iloꞌa ta menexu ixolu la ua, la sou aneꞌi ipelemu sou no anu laꞌilali. ");
INSERT INTO ata_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Lexe tokolomo veveeni vile teinu ukakaa la itema vile umomomo sou unoꞌu lavalava xasixu alavua ia ulai usimenu vaxa no anu uasi. Xo lavalava xasixu alavua ne ulapunu tokolomo veveeni ne la uꞌoxonu ukakaa tatila la. ");
INSERT INTO ata_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mo itema vile umomomo sou usixolonu uaini alavua uꞌunalai no anu uaini vexasou teinu uasi, xo maasi la ukakaa la uaini unixi uatu la uꞌoxonu uaini xalusou ne ukakaa la masua avile. La sou inixiꞌu uaini alavua uꞌuna no anu uaini alavua vexasou la anu uxali laixe.” ");
INSERT INTO ata_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","No mine Iesu uvivikalaneꞌi ta molomolo noxou Ioanesi, la itema sou usaxilaꞌu taasou lalotu muneꞌe muxolaꞌu tavaꞌu voꞌuxu muluꞌelai no talaxu Iesu la muvikalanu lexe, “ꞌAlixeni sema misoli ꞌalalaese ꞌo la sou naneꞌe mo namulaxu avone no vasimele mo sou ane imauli la.” ");
INSERT INTO ata_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xe Iesu muavuti la mumulinu la ta molomolou kalumo mimulinu. ");
INSERT INTO ata_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Aneꞌi mimuamuaꞌi milai la sema vile ne sialu uluꞌe noxie tauu ie mavulovexa mo muluꞌe lia tamei mimuamuaꞌi mineꞌe no talou Iesu la mivikala no tane lexe, “Lexe eni akasou tokolomousi la eni laixeleli.” La sou ane milutu milai mikasou tokolomou. ");
INSERT INTO ata_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ia Iesu iou muxiu la mumaisie sema ne la muvikalane lexe, “ꞌAlixeni, taneni utulu vilesisi xo muxamuxaxu taneni noxine siꞌa mupamaulineni.” La sema ne laixene ane ꞌalalaenesi. ");
INSERT INTO ata_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Xe no mine Iesu mulai muꞌunalai no tani noxou itema sou usaxilaꞌu lalotu, la mumaisiꞌa ta mitema itautaunu vei xe ta mitema e mineꞌe mipita sou soli ne itatama, la nalolomu uasisi manina. ");
INSERT INTO ata_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Anu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngalailai. Molomolo ne isoli uasi ane miai ane.” Ia aneꞌi milomusou aloxo ne la mikekeiou. ");
INSERT INTO ata_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Xe iliꞌi no mine ta mitema milailai no ale mukalu, la Anu mulai mukasi vaxa no avole molomolo ne, la mutulusie la ane mitulu. ");
INSERT INTO ata_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","La aꞌalosou mii maꞌia ane Iesu muꞌoxonu ne mulai no xalee tuatuala mukalusi. ");
INSERT INTO ata_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu musuku no tuala ane ne sou mumuamuaꞌi mulai ia ta mitema tamei ieꞌi seleveenu mimulinu la miꞌava aloxo ꞌo, “Nini Deviti ꞌilusunu, nini taneninexe noxou.” ");
INSERT INTO ata_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anu muꞌunalai no tani la sou ta mitema tamei e ieꞌi seleveenu ne mineꞌe noxou, la Iesu mutaliꞌisiꞌa ilou aloxo ꞌo, “Loxovaa ngingi ngongoꞌu ngemuxamuxaxu tangengi lexe eni amomomo sou aꞌoxo mii ane ꞌo?” La aneꞌi ilou mikolinu vaikala lexe, “Aani Tila.” ");
INSERT INTO ata_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","La sou Iesu mukasivaxa no ieꞌi ilou la muvikalaneꞌi aloxo ꞌo, “Ngingi ngongoꞌu ngemuxamuxaxu tangengi noxilo aloxo ne la sou mii ane ne anu uxali noxinge ngongoꞌu.” ");
INSERT INTO ata_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","La ieꞌi ilou mukaa mo lamana laixe. La Iesu muvikalaneꞌi ilou pekiaꞌu aloxo ꞌo “Ngongou ngaaꞌalo mo evile ulavu no anu mii ane ꞌo uasisi manina.” ");
INSERT INTO ata_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ia aneꞌi ilou milai la miaꞌaloxu mii maꞌia Iesu muꞌoxonu noxiꞌa ilou la aꞌalo ne mulai no xalee lia tila mukalusi. ");
INSERT INTO ata_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","No mine aneꞌi ilou miuatulai la itema vile uleenu masua muaꞌaisou mo ulavusou uvivikala uasi minoꞌu miꞌunanu noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","La Iesu mukusau uleenu masua ne la itema e uvivikala uasi ne muvikala. Xe ta mitema mimaisou la mikuluke manina, la mivikala lexe, “Mii vile aloxo ꞌo uxali mo tamaisou tatei ne Isilaeli uasi.” ");
INSERT INTO ata_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ia ta Palisaio mivikala lexe, “Anu ukusaiꞌa ta uleenu ta masumasua no anu xaviinu Velusavelu ane.” ");
INSERT INTO ata_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu mulai muxixaoxao no tuala ta tatila xe no tuala kitukitu la muꞌunalai no taasou lalotu la mulosiꞌa lavulavu, xe muaꞌaloxu aꞌalo lailaixe sou saxisaxilaꞌu noxou Lataua. Mo mupamaulineꞌi ta mitema pipiena iouiou muꞌoxoneꞌi. ");
INSERT INTO ata_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ia no mine Anu umaisiꞌa ta mitema tavuꞌalo la tanuxaꞌa xo aneꞌi mixolu ne mixovulaulausi, xe mixolu masua loxo ta sipsip tatananeꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","La muvikalaneꞌi ta molomolo noxou aloxo, “Xai lingamo mukalu ia ta mitema sou ikokoli tapiena uasi. ");
INSERT INTO ata_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","La sou laixe lexe ngingi ngalinga noxou Tila sou xai ne mo upalusiꞌa ta mitema sou xaixai la sou ineꞌe ikokoli no xai ne.” ");
INSERT INTO ata_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu muꞌavaliꞌa ta molomolo noxou mavulovexa mo muluꞌelia tamei mineꞌe noxou, la mulosiꞌa xavi sou ikusaiꞌa ta uleenu ta masumasua iuatu noxiꞌa ta mitema xe ipamaulineꞌi aneꞌi ane pipiena iouiou muꞌoxoneꞌi. ");
INSERT INTO ata_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aneꞌi ta molomolo mavulovexa mo muluꞌelia tamei ne ualaualasiꞌa aloxo ꞌo. Vile Saimoni, ualasou vile lexe Pita ilou vimou Andeleasi mo Sevetaio ta ꞌolu ta tamei Iakovo ilou Ioanesi. ");
INSERT INTO ata_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mo Pilipi mo Vatolomaio mo Tomasi mo Mataio itema sou unoꞌu lamoli mo Iakovo, Alipaio ꞌolu mo Tadiasi, ");
INSERT INTO ata_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mo Saimoni anu itema vile noxiꞌa aneꞌi ane ixavutala lexe aneꞌi meꞌa isaxilaꞌu tualasiꞌa xe Iudasi e anu muitalonu Iesu no avoꞌa ta mitema sou mivau. ");
INSERT INTO ata_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aneꞌi ta molomolo mavulovexa mo muluꞌelia tamei ne Iesu mupalusiꞌa milai la mupelaꞌa aloxo ꞌo. “Mamu sou ngalai noxiꞌa ta mitema ane aneꞌi ta Iutaia uasi, mo ngaꞌunalai no tuala ta tatila ne Samalia uasi.” ");
INSERT INTO ata_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ia ngalai noxiꞌa ta sipsip ne Isilaeli e mixovulauneꞌi. ");
INSERT INTO ata_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mo lexe ngalai la ngaꞌalo lexe saxisaxilaꞌu noxou Lataua a muneꞌe ꞌalai mukalu. ");
INSERT INTO ata_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ngapamaulineꞌi aneꞌi ane mipipiena, mo ngatulusiꞌa aneꞌi ane misoisoli mo aneꞌi ane vulukali muꞌoxoneꞌi la ixali malemalenga xe ngakusaiꞌa ta uleenu ta masumasua e mixolu noxiꞌa ta mitema. Mii maꞌia ngingi ngenoꞌu ne ngenoꞌu vitanisi la sou ngingi ngalosiꞌa ta mitema vitanisi. ");
INSERT INTO ata_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mo mamu sou nganoꞌu lamoli xoulu mo siliva xe kopa ngataanu no vasimenge. ");
INSERT INTO ata_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mo ngamuamuaꞌi la nganoꞌu tiva aoao mo nganoꞌu tokolomo veveeni ta tamei mo siove sou tavaꞌinge xe vilaxo sou ngavilaxo no anu uasi. Xo itema sou xaixai umuamuaꞌi la aneꞌi ilosou mimii. ");
INSERT INTO ata_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Xe ngingi ngaꞌunalai no tuala tila mo no tuala vile la ngingi ngakamulinu laixe ꞌo lexe itema ꞌei no tuala ane ne anu laixe mo itema mulapu, la sou ngingi ngongiꞌa itema ne ngaxolu ulai uxali no voxo ane lexe ngingi ngasuku no tuala ane ne. ");
INSERT INTO ata_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lexe ngingi ngaꞌunalai no tani vile la ngavikalaneꞌi aneꞌi ane ixolu no nano no tani ne lexe, “Lataua uxolu noxinge.” ");
INSERT INTO ata_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mo lexe ngaꞌunalai no tani vile xe aneꞌi iꞌosasinge, la ngingi ngavikalaneꞌi lexe opo seꞌisisi ne uxo noxinge xe iꞌosasinge uasi, la opo seꞌisisi ne ulivu uneꞌe noxinge. ");
INSERT INTO ata_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ia lexe ngalai ngaxali no tuala tila vile xe no tuala vile ia ta mitema sou tuala ne iꞌavalinge mo inoꞌinge ngaꞌunalai no tani uasi mo ilomungenge uasi, xe no mine ngalaa la ngavutasou lomulo no tavaꞌinge ia ngasuku ngalai no tuala vile la. ");
INSERT INTO ata_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eni avikalangengi manina lexe, no anu voxo sou ta mitema itulu no anu vaivaikala la tuala tatila ne inoꞌu tuꞌutuꞌumaxu tatila manina uaꞌulixu tuꞌutuꞌumaxu noxiꞌa ta Sodomu xe ta Xomola. ");
INSERT INTO ata_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Eni apalusinge ngalai loxo ta sipsip ilai no taineꞌi ta aꞌaa ta vova. Aloxo ne la sou ngingi ngamulinu ꞌilixo noxiꞌa ta sinana ta veveeni mo ngaxavutalanu mii maꞌia sou lexe ngingi ngaꞌoxonu mo ngamulinu ꞌilixo laixe noxiꞌa ta ngiala ta kuau. ");
INSERT INTO ata_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mo ngasaxilaꞌinge laixe noxiꞌa ta mitema. Xo inoꞌinge la ilai itulusinge no anu vaivaikala no ieꞌi ta tatila no anu pita noxiꞌa la ipuapuasinge no nano no taasou lalotu noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tavaꞌu xo ngingi noxilo, la sou aneꞌi itulusinge no ieꞌi tamitema sou xaixai noxiꞌa ta tamutuxu tuatuala mo tatananu tuatuala, la sou ngingi ngaavuti sou ngaꞌaloxu aꞌalo laixe ulai noxiꞌa xe ulai noxiꞌa ta mitema ane aneꞌi ta Iutaia uasi. ");
INSERT INTO ata_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Xe lexe itetelisinge ngalai ngatulu no anu vaivaikala, la ngaxavutala piena no ꞌa vaikala sou ngalemolu uasi, mo ngaxavutala lexe ngavikala a loxovaa uasi. Xo no voxo ane ne vaikala uxali no anangenge vitanisi. ");
INSERT INTO ata_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","La sou ngingi ngalavusou lexe ngingi ane ngavivikala ne uasi. Uleenu noxou Maminge ane uxolu noxinge la uvivikala ne. ");
INSERT INTO ata_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Itema vile uavuti la ukalanu vimou sou ivau usoli, mo ta molomolo kalumo ne ta mamiꞌa iꞌoxoo aloxo ne noxiꞌa. Xe ta ꞌiliꞌiliꞌa ne, iavuti xe iasaxaiꞌa ta mamiꞌa iloꞌa ta neniꞌa la ikalaneꞌi ulai sou iveꞌa isoisoli. ");
INSERT INTO ata_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ulai la ta mitema imasaxainge uasi xo ngingi noxilo, ia ꞌenaꞌei ane utulu pekiaꞌu ulai utalo no anu soli la Lataua upamaulinu. ");
INSERT INTO ata_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mo lexe iꞌoxoo masuangengi no tuala vile, la ngaꞌume ngalai no tuala vile. Mo avikalangengi manina aloxo ꞌo, ngingi ngalai ngakalusou tuatuala ta tatila no nano no tuala tila ne Isilaeli uao ia Itema ꞌOlu uneꞌe. ");
INSERT INTO ata_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Molomolo anu utila noxou tilasou e ulosiou lavulavu uasi xe itema sou xaixai anu tila noxou tilasou uasi. ");
INSERT INTO ata_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Anu laixe lexe molomolo ne uxali umomomo loxo tilasou sou ulosiou lavulavu la anu mumomomo. Xe itema sou xaixai kalumo uxali umomomo loxo tilasou. Ia lexe tatananu tani ilemolu lexe Velusavelu ne uxolu no nano no tani ne, la aneꞌi ane mixolu no nano no tani ne ilemeꞌa lexe aneꞌi ta masua manina. ");
INSERT INTO ata_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","La sou ngaꞌume noxiꞌa ta mitema uasi xo mii maꞌia ane misuꞌasou mo mitalumeiou ne ulai iliꞌi la upalaꞌa xo mii maꞌia ane mutalume ne iliꞌi la utalume uasi. ");
INSERT INTO ata_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mo vaikala maꞌia eni evikalangengixu no isivoxo ꞌo ne ngingi ngaaꞌaloxu no lamana. Mo mii maꞌia emunusou no sangalinge ne iliꞌi la ngalai ngatulu teitexi no tani kisou la ngaaꞌaloxu noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mo mamu sou ngaꞌume noxiꞌa aneꞌi ane ivau vasimengesi usoli, ia imomomosou ivau uleengengi uasi. Ia laixe lexe ngaꞌume noxou Anu ane umomomo sou ukalusou vasimenge xe uleengengi no anu navu e kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ia ngingi ngelavu lexe ta mitema ilotoneꞌi ta ngiala kitukitu tamei no anu kesi vile. Ia Lataua usaxilaꞌu mimii iouiou mukalusi mo lexe mii vile uꞌoxonu ngiala kituꞌa vile ne usoli, la Lataua mulavusou. ");
INSERT INTO ata_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mo laxusinge no kisinge ne Lataua muitisou mukalu. ");
INSERT INTO ata_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","La sou ngaꞌume mamu xo ngingi ngeuaulixaꞌa ta ngiala ta kitukitu moso ne. ");
INSERT INTO ata_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","La sou ꞌei ane uvikala lexe anu ulavusilo no ieꞌi ta mitema, la eni kalumo avikala lexe eni elavusou no iou Mamilo teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ia ꞌei ane uvikala lexe anu ulavusilo uasi no ieꞌi ta mitema, la eni kalumo avikala lexe eni alavusou uasi no iou Mamilo teitexi no opo loxotolo kalumo. ");
INSERT INTO ata_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Loxo io ngingi ngaxavutala lexe eni eneꞌe sou akalusou ꞌotoꞌoto no lia ꞌo uasi, eni eneꞌe ꞌo sou axalixu ꞌotoꞌoto no taingengi. ");
INSERT INTO ata_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mo eni eneꞌe sou axalilixu kalipala la, itema ꞌolu mulu uxiu uꞌoxo masua noxou momu xe ꞌolu sema iꞌoxo masua noxie nenie xe uaꞌane iꞌoxo masua noxie nenie. ");
INSERT INTO ata_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","La aneꞌi ane iloꞌa itema ne ixolu no tani ne ixiu imolosila neꞌi ngatongatoꞌo. ");
INSERT INTO ata_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mo ꞌenaꞌei ane umasaxaiꞌa momu ilee nenusi manina ia umasaxailo manina uasi, la anu noxilo uasi. Mo ꞌenaꞌei ane umasaxau ꞌolu mulu ilee ꞌolu semasi manina ia umasaxailo manina uasi la anu noxilo uasi. ");
INSERT INTO ata_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo ꞌenaꞌei ane utavulenu ovu valautu noxou ia umulileli uasi la anu noxilo uasi. ");
INSERT INTO ata_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mo ꞌenaꞌei ane tanuxu maulixu ne iliꞌi la uxovulaunu, xe ꞌenaꞌei ane ulosou maulixu sou uaꞌaloxu aꞌalo laixe noxilo ne iliꞌi la anu uxalisou mauli. ");
INSERT INTO ata_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mo ꞌei ane uꞌosasou unoꞌu itema ane eni epalusou, la anu uꞌosasou unoꞌilo kalumo. Xe ꞌei ane uꞌosasou unoꞌilo, la anu uꞌosasou unoꞌu anu ane mupalusilo. ");
INSERT INTO ata_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mo ꞌei ane uꞌosasou unoꞌu itemasou palomatana xo anu itemasou palomatana ne iliꞌi la anu unoꞌu ulu loxo aneꞌi ta mitema sou palomatana minoꞌu. Mo ꞌei ane uꞌosasou unoꞌu itema mulapu la anu unoꞌu ulu iou vilesisi aloxo itema mulapu unoꞌu ne. ");
INSERT INTO ata_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Xe ꞌei ane ulosiꞌa aneꞌi ane ualasiꞌa uasi lexa sou iiexu xo aneꞌi ta molomolo noxilo, la eni avikalangengi manina lexe itema ne umomomo sou unoꞌu naꞌu ulusou kalumo. ");
INSERT INTO ata_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ioxe iliꞌi no mine Iesu muvivikalaneꞌi ta molomolo noxou mavulovexa mo mulelia tamei mukalu, la aneꞌi misuku milai no xalee lia tila ne Xalilaia. La miꞌunalai no tuala tatatila sou Anu mulosieꞌi xe muaꞌaloxu vaikala noxou Lataua noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioxe, no mine Ioanesi muxolu no taasou navunavu, la mulomusou aꞌalosou xaixai noxou Kalisito, la mupalusiꞌa ta molomolo noxou milai noxou. ");
INSERT INTO ata_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Aneꞌi milai la mitaliꞌisou aloxo ꞌo, “Nini itema e lexe naneꞌe ano ꞌo? Uasi, nexi texomaiou itema vile ꞌa uao.” ");
INSERT INTO ata_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu muavuti la mukolineꞌi lexe, “Ngalivu ngalai noxou Ioanesi la ngaꞌaloxu mii maꞌia ane ngemaisou xe ngelomusou. ");
INSERT INTO ata_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ngalai ngaꞌalo lexe, ta mitema ieꞌi seleveenu mimalei, mo aneꞌi ane tavaꞌa musoisoli ne mimuamuaꞌi, mo aneꞌi ane vulukali muꞌoxonu vasimeꞌa ne laixeneꞌi, mo aneꞌi ane ilolomu uasi ne milomu mo aneꞌi ane misoisoli ne mimauli. Xe aneꞌi ane lavulutiꞌa uasi ne, milomusou aꞌalo laixe noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mo ꞌei ane umaisou xaixai ane eni eꞌoxonu xe xavutalau ukalipala uasi, ia xavutalau vilesisi noxilo, la anu uꞌosa.” ");
INSERT INTO ata_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioxe no mine ta molomolo noxou Ioanesi milivu mukalu la Iesu muavuti sou muaꞌaloiꞌa ta mitema lamana noxou Ioanesi aloxo ꞌo, “Ngingi ngelai no xalee lia vitanisi sou ngemaisou mii maꞌia? Ngelai sou ngemaisou atume muilisou visoviso volovoloxu? ");
INSERT INTO ata_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lexe uasi, la ngingi ngelai ne sou ngemaisou mii maꞌia manina? Itema vile mutokolomo no anu tokolomo lailaixe? Uasi, aneꞌi ane tokolomo no anu tokolomo lailaixe ne ixoxolu no tani noxiꞌa ta tatananu tualasi. ");
INSERT INTO ata_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aloxo ne la sou ngingi ngelai sou ngemaisou mii maꞌia manina ne? Itema sou palomatana vile? Ani, ia eni avikalangengi lexe itema sou palomatana ane ne muuliuli noxiꞌa ta mitema sou palomatana tatei. ");
INSERT INTO ata_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Itema ane nesi aneꞌi mikaukavusou muxolu no nano no anu Lavuku Tavuna teinu muvikala lexe, ‘Eni apalusou itema vile sou aꞌalo uuli noxine, mo upaipounu voteꞌisine tei.’ ");
INSERT INTO ata_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eni avikalangengi manina aloxo ꞌo. No taineꞌi ta mitema e ta neniꞌa mivoꞌoneꞌi no lia ꞌo ne, vile uxali tatila manina loxo Ioanesi itema sou uꞌulosiꞌa ta mitema uasi. Ia lexe itema ane uxali kituꞌa manina no nano no anu saxisaxilaꞌu noxou Lataua la anu utila noxou Ioanesi. ");
INSERT INTO ata_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Musoko no voxo ane Ioanesi itema sou uꞌulosiꞌa ta mitema muaꞌalo muneꞌe muxali vaimomo ꞌo ne, la ta mitema e xavineꞌi ne iꞌotoꞌoto xavineꞌi sou lexe inoꞌu tualasou saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. La aneꞌi xavineꞌi sou iꞌoxonu ꞌilixo iouiou mo iꞌotoꞌoto xe itetelisou mii ane ne. ");
INSERT INTO ata_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta mitema sou palomatana mo Lapuloto noxou Mosesi miaꞌaloxu vaikala noxou Lataua muneꞌe mutalo no voxo ane Ioanesi muxali no anu. ");
INSERT INTO ata_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ia lexe ngingi opongengi uꞌosa mo ngalomuxu la anu Eliasi e lexe uneꞌe ane. ");
INSERT INTO ata_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ia lexe ꞌenaꞌei ane mulavusou lexe sangalou a uxoxolu sou ulomu no anu la laixe lexe ulomu sou vaikala ane ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ia ta mitema mipaa vaimomo ꞌo, eni avikalasiꞌa a loxovaa? Aneꞌi loxo ta molomolo ixoxolu no tanixu pitapita, la miꞌava mulai noxiꞌa ta menexiꞌa lexe, ");
INSERT INTO ata_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nexi tevau xita lexe ngalei la ngingi ngamasaxa ngalei uasi, mo nexi telexe lexe sou soli la ngingi ngatama uasi.’ ");
INSERT INTO ata_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","La sou ngingi ne aloxo ta molomolo ne, xo Ioanesi itema sou uꞌulosiꞌa ta mitema muxali la uꞌani xe uie uasi, la ngingi ngevikala lexe uleenu masua muxolu noxou. ");
INSERT INTO ata_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ia Itema ꞌOlu muxali xe muꞌani xe muiexu uaini la ngingi ngevikala lexe, ‘Itema ꞌo ne uvunekaina mo uie uꞌokinu manina. Mo anu vaitamiꞌa ta mitema sou itaxusou lamoli iloꞌa ta mitema sou ꞌiliꞌilixo masumasua.’ Ia aneꞌi ixaxai noxou Lataua sou imaxaꞌu lexe lavulavu noxou Lataua ne anu lavulavu maninasou.” ");
INSERT INTO ata_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ioxe, Iesu muavuti la muꞌunalai no tuala ta tatila, la muꞌoxonu sosovo tavuꞌalo ia aneꞌi ixiu oponeꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","La sou Anu muavuti la mulavixaꞌa la muvikala lexe, “Eni talelixaꞌa ta Korasini iloꞌa ta Vetesaida! Lexe sosovo ane eni eꞌoxonu noxinge ꞌo, aꞌoxonu ne ta Taia xe ne ta Saidoni, la aneꞌi ipalea sou itokolomoxu tokolomo sou tama xe iꞌuloxu no lomulo sou umaxaꞌu lexe aneꞌi mixiunu oponeꞌi. ");
INSERT INTO ata_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ia eni avikalangengi aloxo ꞌo, no voxo ane Lataua utulusiꞌa ta mitema no anu vaivaikala la tuꞌutuꞌumaxu uxali noxinge ne uaꞌulixu tuꞌutuꞌumaxu noxiꞌa ta Taia iloꞌa ta Saidoni. ");
INSERT INTO ata_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mo ngingi ta Kapenaumu loxovaa ngingi ngalai teitexi no loxotolo kalumo? Uasi, Lataua uleangengi ngaluꞌelai no lia no taxa kaluxu uasi. Ia lexe sosovo ane eni eꞌoxonu noxinge ꞌo, uxali noxiꞌa ta Sodomu la vaimomo ꞌo ta Sodomu a ixoxolu sio. ");
INSERT INTO ata_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ia eni avikalangengi aloxo ꞌo, tuꞌutuꞌumaxu noxiꞌa ta Sodomu ne kituꞌa sesi uaꞌulixu tuꞌutuꞌumaxu noxinge no anu voxo ane Lataua utulusiꞌa ta mitema no anu vaivaikala.” ");
INSERT INTO ata_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ioxe Iesu muavuti la musolonu vaivaikala noxou la muvikala lexe, “Eni aꞌitinu Mamilo Lataua ualasou anu Tila teitexi no opo loxotolo mo no lia ꞌo kalumo. Xo Anu mutalumeu noxiꞌa ta mitema sou lavulavu xe itema mulavusou mimii latala ia mupalaꞌalixu vaikala manina lamana noxiꞌa aneꞌi ane italoxolixaꞌa loxo ta molomolo. ");
INSERT INTO ata_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ani, Mamilo nini masaxa noxine aloxo ne la sou nini neꞌoxonu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mamilo anu mulosilo mimii tavuꞌalo mukalusi. Evile ulavusou Lataua ꞌOlu uasi, ia Momusi mulavusou mo evile ulavusou Momu uasi anu ꞌOlu anusisi mulavusou. La sou ꞌOlu mupalaꞌalixu momu lamana noxiꞌa, aneꞌi ane Anu musosovosiꞌa lexe Anu ta naꞌu. ");
INSERT INTO ata_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La sou ngingi ane tavuevulengenge tuꞌumaxu la nganeꞌe noxilo mo eni alosinge maꞌila. ");
INSERT INTO ata_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngatavulenu tavule noxilo loxo isakiinu no anu ta kau xolaneꞌi mo sou eni alosiengi no anu lavulavusilo. Xo eni opo seꞌisisi mo ꞌilixo sou ataloxolixo no taleli. La sou uleengengi umaꞌila. ");
INSERT INTO ata_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Xo tavule noxilo ne papaxexu mo tavuevule noxilo ne tuꞌumaxu uasi papaxexusi.” ");
INSERT INTO ata_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","No voxo Tavuna vile la Iesu iloꞌa ta molomolou mimuamuaꞌi no nano no xai sou uiti. Iloꞌa mimuamuaꞌi milai la ta molomolou misolingaꞌa. Xe miavuti la miꞌelexu uiti temanu seꞌi la miꞌou. ");
INSERT INTO ata_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Xe ta Palisaio mimaisiꞌa la mitaliꞌisou Iesu aloxo ꞌo, “Ae, loxovaa la sou ta molomolomeni miꞌoxonu ꞌilixo ane umomomo sou taꞌoxonu no voxo Tavuna uasi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Xe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Xo loxovaa ngingi ngaitisou aꞌalo sou Deviti iloꞌa ta mitema noxou e misolixaꞌa la miꞌoxonu uasi? ");
INSERT INTO ata_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Anu muꞌunalai no tani noxou Lataua la munoꞌu veleti e umomomo sou ta mitema vitanisi ioꞌou uasi ta ailiꞌisi ioꞌou ne la iloꞌa ta mitema noxou miꞌou. ");
INSERT INTO ata_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mo male ngingi ngaitisou vaivaikala muai no nano no anu lapuloto lexe ta ailiꞌi ipupunu voxo Tavuna sou ixaxai no nano no tani sou lalotu uasi? Aneꞌi miꞌoxonu aloxo ne la anu masua uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","La sou eni avikalangengi manina lexe vile anu tila no anu taasou lalotu ne anu a uxoxolu ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ia lexe ngingi ngelavusou vaikala ꞌo laaxu e muai no nano no anu Lavuku Tavuna teinu muvikala lexe, ‘Eni amasaxaiꞌa ta mimii ngaꞌelaxu sou uxexeenu susu noxinge uasi eni emasaxau alauna.’ Lexe ngalavusou vaikala ne laaxu la ngingi ngamomomo sou ngaꞌoxo masuaneꞌi ta mitema vaꞌaxu e xoluxoluxaꞌa laixe ne uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Xo Itema ꞌOlu ne Anu Tila sou voxo Tavuna.” ");
INSERT INTO ata_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu muvivikalaneꞌi ta Palisaio ne mukalu la musuku mulai no tuala vile la muꞌunalai no taasou lalotu noxiꞌa ta Iutaia. ");
INSERT INTO ata_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Anu muꞌunalai la mumaisou itema vile avolu musoli a uxoxolu no nano ne. Ioxe, ta mitema e mixoxolu no nano no taasou lalotu ne ikamuli voteꞌi sou lexe iꞌoxonu Iesu ususu, la mitaliꞌisou lexe, “Loxovaa lapuloto noxinge muvikala lexe umomomo sou tapamaulinu itema vile no voxo Tavuna?” ");
INSERT INTO ata_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu muavuti la mukolineꞌi aloxo ꞌo, “Lexe vile no taingengi ne sipsipu vile ulapau uꞌunalai no taxa no voxo Tavuna, la loxovaa, anu iou uvaxau uxoxolu ne, uasi ulapunu utelo? ");
INSERT INTO ata_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Xo itema maulixu anu mii mutila muaꞌulixu sipsip. La sou lapuloto muvikala lexe nenge ta momomo sou taꞌoxonu ꞌilixo laixe no voxo Tavuna sou tasuꞌulineꞌi ta menexinge.” ");
INSERT INTO ata_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Xe Iesu muavuti la muvikalanu itema e avolu musoli ne lexe, “Namexiinu avone.” Xe anu mumexiinu avolu ne muatu la avolu ne laixe alaxu vilesisi loxo ane vile ꞌole. ");
INSERT INTO ata_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Xe ta Palisaio mimaisou aloxo ne la milaa vilevilesi, la milai mipita sou ikamuli voteꞌi sou lexe ivau Iesu usoli. ");
INSERT INTO ata_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ia Iesu mulavusou aloxo ne la Anu musuku mulai no tuala vile la. Anu mulai la ta mitema tavuꞌalo mimulinu la Anu mupamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","La mutalosiꞌa lexe aneꞌi iaꞌaloxu mii maꞌia e aneꞌi mimaisou ne mamu xe ipalaꞌalixu mamu. ");
INSERT INTO ata_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Anu muvikala aloxo ne sou umomomo sou vaikala mulaa no anaxu Aisaia itema sou palomatana muvikala aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Itema sou xaixai noxilo e eni esosovosou ane, mo emasaxau misevile xo opoleli uꞌosasou manina. Eni aꞌanaꞌanalixu no anu Uleenu Tavuna noxilo la uaꞌaloiꞌa ta mitema no lia ꞌo ukalusi no anu ꞌiliꞌilixo mulapu. ");
INSERT INTO ata_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Anu umomomo sou ukaitolo mo uunga uasi, mo umomomo sou ilomusou xolinu no voteꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Visoviso anu mamalaxu sou uxola la uxola ia umomomo sou anu uxolau uasi mo lalamo e uikisou masua la ukaa laixe uasi ne utausou mo usitanoxu uasi. Anu uꞌoxonu aloxo ne ulai uxali no mine anu uꞌoxonu ꞌilixo lailaixe ane muuliuli manina. ");
INSERT INTO ata_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","La sou no anu ualasou la ta mitema no lia ukalusi ꞌo imuxaxu taneꞌi noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aneꞌi milailixu itema vile uleenu masua vile muxolu noxou la muꞌoxonu iou seleveenu xe anaxu mutomu muneꞌe noxou Iesu, sou lexe Anu upamaulinu mo sou anu uvikala xe umalei. ");
INSERT INTO ata_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Anu mupamaulinu itema ne la ta mitema tavuꞌalo mikuluke la mivikalaneꞌi ngatongatoꞌo lexe, “Loxovaa itema ꞌo anu Deviti ꞌolu?” ");
INSERT INTO ata_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ia ta Palisaio milomusiꞌa ilelemolu la mivikalaneꞌi aloxo ꞌo, “Anu itema anu ꞌo ukusaiꞌa ta uleenu ta masumasua no anu xavi noxou Velusavelu anu tila noxiꞌa ta molosila.” ");
INSERT INTO ata_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ia Iesu mulavusou xavutalaiꞌa la muvikalaneꞌi no anu vaikala latilovo aloxo ꞌo, “Lexe tuala xalee tila vile ta mitemasou ikalipalaneꞌi sou iꞌotoꞌoto ngatongatoꞌo noxiꞌa, la tuala ne umomomo sou utulu pekiaꞌu uasi. Mo tuala tila vile xe ta mitemasou tani vile ikalipala xe iꞌoto ngatongatoꞌo la aneꞌi imomomo sou ixolu laixe uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","La sou loxovaa Satani umomomo sou ukusau Satani la? Lexe Satani iloꞌa ta mitema noxou ikalipala xe iꞌotoꞌoto ngatongatoꞌo la anu xaviinu uasisi. ");
INSERT INTO ata_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mo lexe eni akusaiꞌa ta uleenu ta masumasua no anu xavi noxou Velusavelu, la sou no anu xavi noxou ꞌei ane ta mitema noxinge ikusaiꞌa ta uleenu ta masumasua no anu ne? La sou ta mitema noxinge ivikalangengi lexe vaikala noxinge ne temanu uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ia lexe eni akusaiꞌa ta uleenu ta masumasua no anu xavi Uleenu Lataua, la sou ngingi ngalavusou lexe saxisaxilaꞌu noxou Lataua ne a muneꞌe noxinge ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mo lexe itema vile umasaxa lexe uꞌunalai no taasou itema laꞌia vile ne mo utaxusou mimii noxou la anu laixe lexe usakisakiinu itema ne tei ꞌo. Xe ukalu la sou anu uꞌunalai no tani sou upakalinu miumiu. ");
INSERT INTO ata_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ꞌEnaꞌei ane noxilo uasi la anu uꞌapixo mo ꞌei ane usuꞌulileli sou upitaneꞌi ta mitema uasi ne la anu sou ukusaiꞌasi.” ");
INSERT INTO ata_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mo Iesu muavuti la muvikalaneꞌi la aloxo ꞌo, Eni avikalangengi manina lexe Lataua umomomo sou uxiu tumalou ꞌiliꞌilixo masumasua mo vaikala masumasua noxiꞌa ta mitema ane iꞌoxonu ulai noxou. Ia anu ane uvikala masua ulai noxou Uleenu Tavuna ne, la Lataua umomomo sou uxiu tumalou uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mo ꞌenaꞌei ane uvikala masua noxou Itema ꞌOlu la Lataua umomomo sou uxiu tumalou. Ia lexe ꞌei ane uvikala masua ulai noxou Uleenu Tavuna ne, la Lataua umomomo sou uxiu tumalou uasisi manina. Vaimomo ꞌo xe iliꞌi la susu noxou ne uxolu avile. ");
INSERT INTO ata_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Lexe ngingi natounu ovu laixe la ngingi ngaꞌelexu ngiaxu laixe. Ia lexe ngingi ngatounu ovu masua la ngingi ngaꞌelexu ngiaxu ne masua kalumo. Xo ovu ne nenge tatongonu no anu ngiaxu kalumo. ");
INSERT INTO ata_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ngingi lasile molosila ta ꞌolu, la sou ngingi ngamomomo sou ngaꞌoxonu vaikala laixe a loxovaa e ngingi ꞌilixo masumasua muꞌanaꞌana noxingesi ꞌo? Xo mii maꞌia ulaa no anangenge ne upalaꞌalixu mii maꞌia ane muꞌanaꞌana no nano no opongengi la sou anu mulaa muatu ne. ");
INSERT INTO ata_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","No anaxu itema laixe la ulaanu mii maꞌia lailaixe ane mukopinu muai no nano no tanu. Xe no anaxu itema masua la ulaanu mii maꞌia masumasua e mukopinu muai no nano no tanu. ");
INSERT INTO ata_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","La sou eni avikalangengi manina aloxo ꞌo, ulai iliꞌi no anu voxo sou tatulu no anu vaivaikala la aneꞌi inoꞌu ulusou vaikala masumasua e mulaa no anaxaꞌa ne. ");
INSERT INTO ata_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Xo no anu vaivaikala noxine molu upalalixene lamana no mine tatulu no anu vaivaikala. La sou no anu vaivaikala noxinesi ne molu upalaꞌalixene lexe nini itema laixe xe itema masua.” ");
INSERT INTO ata_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","La sou ta Palisaio iloꞌa ta tisa sou lapuloto miavuti la mivikalanu Iesu aloxo ꞌo, “Tisa, nexi temasaxa lexe nini naꞌoxonu sosovo vile mo nexi tamaisou.” ");
INSERT INTO ata_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ia Anu muavuti la mukolineꞌi aloxo ꞌo, “Ta mitema sou susu mo ta mitema ilavusou iꞌoxoꞌoxonu ꞌiliꞌilixo sou voteꞌi vaimomo ꞌo, ne imasaxa lexe imaisou sosovo vile. Ia umomomo sou imaisou sosovo vile uasi. Ia anu sosovo vilesisi ane noxou itema sou palomatana Iona nesi. ");
INSERT INTO ata_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","La sou anu iou vilesisi a loxo Iona muxolu voxo tatalu xe ꞌolovoxo tatalu no nano no opoonu sinana tatila ne, la Itema ꞌOlu kalumo uai voxo tatalu xe ꞌolovoxo tatalu no nano no lia tanu. ");
INSERT INTO ata_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","No anu voxo sou Lataua utulusiꞌa ta mitema no anu vaivaikala la ta mitema ne Ninive iavuti la ilea anaxaꞌa ulai noxiꞌa ta mitema e mipaa vaimomo ꞌo. Xo aneꞌi no voxo ane Iona mulai xe muaꞌaloxu vaikala noxou Lataua mulai noxiꞌa la aneꞌi mixiunu oponeꞌi. Xo vaimomo ꞌo itema vile anu ualasou uaulixu Iona. ");
INSERT INTO ata_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mo no anu voxo ane ne kalumo la tatananu tuala ne Seva (ane sema) iloꞌa ta mitema e mipaa vaimomo ꞌo itulu no anu vaivaikala. La aneꞌi iteloo vaikala noxiꞌa ta mitema e mipaa vaimomo ꞌo. Xo aneꞌi meꞌa no paxa no lia paꞌumolu no xalee mutoꞌo ꞌole, aneꞌi milutu mineꞌe sou milomu no anu vaikala sou lavulavu noxou Solomoni. Ia vaimomo ꞌo ne Itema vile anu mutila noxou Solomoni ꞌa uxoxolu ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ioxe Iesu muavuti la musolonu vaivaikala la aloxo ꞌo, Lexe uleenu masua vile ulaa uatu noxou itema, la anu ulai uxixaoxao no tani ꞌesiꞌesi sou ukakamuli tanixu sou lexe uxolu mo umaꞌila no anu la uxalisou uasi, ");
INSERT INTO ata_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","la anu molu uvikalanu lexe, ‘Alivu mo alai no tani e eꞌumesou ꞌole.’ Ia anu uneꞌe xe umalei lexe tani no nano ne misilapanu malemalenge mo mimii ne mutaꞌolu laixe, ia evile uxolu no nano no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ia ulai ukasi noxiꞌa ta uleenu ta masumasua muxatele tamei e ꞌilixoneꞌi masumasua manina muaꞌulixu ꞌilixo noxou ne. La iloꞌa ilai ixolu no nano no tani ne. La sou xoluxoluxu itema ne uxali masua no anu xoluxoluxu tei. Anu iou vilesisi aloxo ne uxali noxiꞌa ta mitema sou iꞌoxoꞌoxonu ꞌiliꞌilixo masumasua e mipaa vaimomo ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","No mine Iesu uao uvivikalaneꞌi ta mitema o la nenu iloꞌa ta vimovimou mineꞌe mitulu no ale sou imasaxa lexe ivikala noxou. ");
INSERT INTO ata_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","La sou itema vile muvikalanu lexe, “Nenine iloꞌa ta vivine ꞌa itutulu no ale sou imasaxa lexe ivikala noxine.” ");
INSERT INTO ata_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Xe Anu muavuti la mutaliꞌisiꞌa lexe, “Nenilo ꞌei ne, mo ta vivilo ta ꞌei ne?” ");
INSERT INTO ata_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Xe muavuti la mutolosou avolu mulai noxiꞌa ta molomolo noxou la muvikala lexe, “Ngamaisiꞌa nenilo iloꞌa ta vivilo aneꞌi ane? ");
INSERT INTO ata_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Xo ꞌenaꞌei ane umulinu masaxa noxou mamilo teitexi no opo loxotolo la anu vivilo xe vivilo sema xe nenilo ane.” ");
INSERT INTO ata_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","No anu voxo vilesisi ne la Iesu mulaa muatu no tani ne la mulai muxolu no luaki paꞌumolu. ");
INSERT INTO ata_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","La ta mitema tavuꞌalo misevile mineꞌe mixali noxou mole mitataasou, la sou Anu muiliꞌe mutelai no uaxa la mutalupexa no anu, ia ta mitema mitaꞌo no tasiꞌi ne. ");
INSERT INTO ata_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Anu muaꞌaloiꞌa no anu mimii tavuꞌalo. Ia aꞌalo latala ne Anu mulailixu no anu vaikala latilovosi, la musokou aloxo ꞌo. “Ngalomu itema vile mulai no xaixu sou usuꞌanu ovu ngiaxu. ");
INSERT INTO ata_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","La seꞌi mulapalapau no voteꞌi, la ta ngiala mineꞌe miꞌou mukalusi. ");
INSERT INTO ata_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Xe seꞌi mulapalapau no lia ane lavolavoꞌo, la mupau palea xo lia ne muxolu seꞌi teitexisi. ");
INSERT INTO ata_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ia aso muiei, la muxalo alaxu vilesisi xo uliuliꞌu ne ulai no lia manina uasi. ");
INSERT INTO ata_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Xe seꞌi mulapalapau muluꞌe no xuxua tanutanu, xe muleme la xuxua mukupokuponu mole uneneꞌa ua. ");
INSERT INTO ata_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ia seꞌi ne, mulapalapau muluꞌe no lia laixe, la muleme muxali tila mole muneneꞌa. Seꞌi muxalilixu itemaxu taꞌuve, xe seꞌi itemaxu tatalu, xe seꞌi la mavulovexa tatalu. ");
INSERT INTO ata_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","La sou Anu muvikalaneꞌi aloxo ꞌo, Itema ane sangalou la anu ulomusou vaikala.” ");
INSERT INTO ata_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ioxe ta molomolo noxou miavuti la milai ꞌalai noxou no uaxa ne, la mitaliꞌisou aloxo ꞌo, “Tavaꞌu a loxovaa la sou nini navivikalaneꞌi ta mitema, la navikalaneꞌi no anu vaikala latilovosi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","La sou Anu muvikalaneꞌi aloxo ꞌo, “Ngingi ne Lataua mulosiengixu laaxu vaikala mutalume sou saxisaxilaꞌu noxou. Ia aneꞌi ne uasi. ");
INSERT INTO ata_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","La sou lexe itema ane anu munoꞌu mimii moseꞌi ꞌo, la Lataua ulosou mimii seꞌi la. La anu umomomo sou paꞌusou no anu mii vile uasi. Ia lexe itema ane unoꞌu mii vile uasi, la Lataua uxexeenu mii maꞌia kituꞌa se anu munoꞌu ne. ");
INSERT INTO ata_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Anu tavaꞌu aloxo ne, la sou eni avivikala la, aꞌoxonu vaikala latilovosi. La sou aneꞌi imamalei mo imamalei ne ia imaisou mii vile uasi. Mo ilolomu mo ilolomu ne ia ilomusou mii vile uasi. Xe ilavusou mii vile uasi. ");
INSERT INTO ata_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Noxiꞌa ta mitema ne la sou anu umomomo sou vaikala noxou Aisaia itema sou palomatana muvikala aloxo ꞌo, ‘Ngingi ngalolomu mo ngalolomu ne ia umomomo sou ngalavusou laaxu uasi. Mo ngingi ngamamalei mo ngamamalei ne ia umomomo sou ngatongonu uasi. ");
INSERT INTO ata_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Xo ta mitema ne mitatusou oponeꞌi mo sangaliꞌa kalumo ne mutomutomu xe ieꞌi ne seleveenu mukalu la imalei uasi. Loxo ꞌo io ieꞌi laixe xe imalei mo sangaliꞌa laixe sou ilomusou vaikala xe ilavusou vaikala laaxu la ixiunu oponeꞌi la sou eni apamaulineꞌi.’ ");
INSERT INTO ata_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Eni avikalangengi manina lexe tatei la ta mitema sou palomatana tapiena, mo ta mitema ꞌilixoneꞌi mulapu tapiena, mo masaxa noxiꞌa mutila lexe imaisou mii maꞌia ane ngingi ngemaisou xe ilomusou mii maꞌia ane ngingi ngelomusou ne, la uasi. Ia ngingisi ngaꞌosa xo ngingi ngemaisou xe ngelomusou. ");
INSERT INTO ata_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ioxe ngalomusou vaikala latilovo sou itema usuꞌanu ovu ngiaxu laaxu. ");
INSERT INTO ata_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ovu ngiaxu e mulapau no voteꞌi ne anu aloxo itema e ulomusou vaikala noxou Lataua sou saxisaxilaꞌu noxou ia ulamana no anu uasi, la itema masua uneꞌe uxexeenu no anu xavutalau. ");
INSERT INTO ata_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Xe ovu ngiaxu e mulapau no lavolavoꞌo ne, anu aloxo itema e ulomusou vaikala noxou Lataua la uꞌosa sou ulomusousi. ");
INSERT INTO ata_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ia umulaxu no tanu uasi loxo uliꞌu uluꞌelai uasi. Xe no mine tuꞌutuꞌumaxu xe vaikala sevile utoꞌomolu la anu ulapau alaxu vilesisi. Tavaꞌu xo uliꞌuliꞌa uasi, la vaikala ne uxoo maxuveeni uasi. ");
INSERT INTO ata_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xe ovu ngiaxu ane mulapau no xuxua ne, loxo itema e ulomusou vaikala noxou Lataua ia uxavutala piena no anu mauli ilou xoluxolu no lia ꞌo, mo umasaxa lexe xavutalau utulu pekiaꞌu no lamoli xe mauli no lialia ꞌo. La sou mimii ne usuꞌasou vaikala noxou Lataua la uneneꞌa no anu maulixu uasi. ");
INSERT INTO ata_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Xe ovu ngiaxu ane mulapau no anu lia laixe ne aloxo itema e ulomusou vaikala noxou Lataua la umulaxu no tanu mo mulavusou laaxu. La neneꞌaxu uxali loxo seꞌi muxalilixu itemaxu taꞌuve mutelo no latanu la, xe seꞌi itemaxu tatalu mutelo no latanu la, seꞌi la mavulovexa tatalu mutelo no latanu la.” ");
INSERT INTO ata_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ioxe Iesu muavuti la musolonu vaikala latilovo vile aloxo ꞌo, “Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo anu aloxo itema vile mulai mutotou uiti ngiaxu laixe no xai noxou. ");
INSERT INTO ata_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ia no ꞌolovoxo vile aneꞌi miaiai mukalu la, uluau itema ne muneꞌe mutotou uiti masua ngiaxu no taitaiinu uiti ꞌole la mulivu mulai. ");
INSERT INTO ata_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Xe no mine uiti mupau mutelo tatatila xe muneneꞌa la uiti masua ꞌole muleme kalumo. ");
INSERT INTO ata_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ia ta mitema sou xaixai noxou tatananu xai ne mineꞌe la mitaliꞌisou lexe, ‘Tila, loxovaa nini netotou uitu laixesi no xai? Ia ꞌenaꞌei mutounu uiti masua e muleme kalumo ne?’ ");
INSERT INTO ata_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Anu muavuti la mukolineꞌi aloxo ꞌo, ‘Uluaxeni muꞌoxonu ane.’ Ioxe ta mitema sou xaixai noxou itema ne miavuti la mitaliꞌisou lexe, ‘Loxovaa nini nemasaxa lexe nexi talai mo takakalau uxexee?’ ");
INSERT INTO ata_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Anu muavuti la muvikalaneꞌi lexe, ‘Mamu xo maasi xe ngingi ngalai ngakakalaꞌu la ngaluvusou uiti kalumo.’ ");
INSERT INTO ata_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Iengi uvaxau uleleme ilou uiti ne mo uiti lingamo. Xe no anu voxo sou kokoli la sou avikalaneꞌi ta mitema e ikokoli ne lexe iluvusou uiti masua ne tei mo ivotunu tavatavalanu mo ilai ipitanu sou uꞌela. Xe ukalu, la sou ipitanu uiti la ilai imuxaxu no tani sou laꞌilali noxilo.” ");
INSERT INTO ata_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu musolonu vaivaikala latilovo vile la aloxo ꞌo, “Saxisaxilaꞌu noxou Lataua ne, aloxo mii e ilemolu lexe masitati ngiaxu. E itema vile munoꞌu la mutotou no xaixu. ");
INSERT INTO ata_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masitati ne ngiaxu kituꞌa manina no anu mimii iouiou e itotou no xai. Ia itounu xe uleme la uleme toxoxaꞌa manina, la uaꞌulixu laꞌilali iouiou e mitounu no xai ne. Avolu ne toxotoxoxaꞌa mo uialaiala ulai no ale la ta ngiala ineꞌe mo iꞌoxonu iomusiꞌa no avoavolu ne.” ");
INSERT INTO ata_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mo musolonu vaivaikala noxou no anu vaikala latilovo vile la aloxo ꞌo. “Saxisaxilaꞌu noxou Lataua ne aloxo isi sevile e sema vile minoꞌu sou mipitanu mixiunu ilou palaua, la usoxolixu veleti ne uxali toxoxaꞌa.” ");
INSERT INTO ata_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","No anu vaivaikala noxou Iesu ne, la muvivikalaneꞌi ta mitema tavuꞌalo ne no anu vaikala latilovosi. ");
INSERT INTO ata_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sou umomomo sou vaikala noxou itema sou palomatana mulemolu tatei aloxo ꞌo. “Eni avivikala, la avivikalangengi no anu vaikala latilovo si, eni avivikalangengi no anu mimii maꞌia ane mutalume tatei no mine ikoinu tuala xalexalee uao, muneꞌe muxali vaimomo ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ioxe Iesu muavuti, la ta mitema tavuꞌalo ne mixoxolu ne, ia Anu musuku mulai no nano no tani. Xe ta molomolou miavuti la milutu milai noxou, la mivikalanu, “Nalulusou laaxu vaikala latilovo sou uiti masua e muleme no nano no xai noxixe.” ");
INSERT INTO ata_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Anu muavuti la muvikalaneꞌi aloxo ꞌo, “Itema e mutotou uiti ngiaxu ne Itema ꞌOlu. ");
INSERT INTO ata_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Xe xai ne xalexalee tuatuala no lia ꞌo. Mo uiti ngiaxu ne ane ta mitema e mixolu no nano no anu saxisaxilaꞌu noxou Lataua. Xe uiti masua ne ane Satani ta ꞌolu. ");
INSERT INTO ata_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Uluau e muneꞌe mutotou uiti ngiaxu masua ne ane Satani. Mo voxo sou kokoli ne ane voxo kaluxusou. Xe ta mitema sou ikokoli no xai ne ane ta angelo. ");
INSERT INTO ata_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mo uiti masua e ipitanu sou uꞌela no navu ne, anu ꞌilixo ane ne uxali no anu voxo kaluxusou aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Itema ꞌOlu upalusiꞌa ta angelo noxou la ixexenu mimii masumasua e uꞌoxoo masuaneꞌi ta mitema, mo aneꞌi ane miꞌoxonu ꞌilixo masumasua ne ixexe no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aneꞌi ileaneꞌi ulai no navu toxoxaꞌa. No anu navu ne la aneꞌi itama xe anaxaꞌa ukalakiki. ");
INSERT INTO ata_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ia aneꞌi ta mitema ane ꞌilixoneꞌi mulapu la ixali loxo aso no nano no anu saxisaxilaꞌu noxou Lataua Mamilo. La sou ꞌenaꞌei ane mulavusou lexe sangalou laixe sou ulolomu no anu la anu laixe lexe anu ulomusou vaikala ane ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iesu mululusou vaikala latilovo ne laaxu mukalu, la musolonu vaivaikala noxou no anu vaikala latilovo vile la aloxo ꞌo. ‘Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne aloxo poxolusou mimii lailaixe e miꞌasixu mutalumeiou no lia. Ia itema vile mulai xe muxalisou la musukunu mulai mutalumeiou la. La anu muꞌosa misevile xe muavuti la musovanu mimii noxou ne mukalusi. Xe mukalu la mulai sou mulotonu lia xalenu anene. ");
INSERT INTO ata_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mo Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne anu aloxo lasala laixe e itema vile usosovanu mimii ukakamulinu sou lexe ulotonu. ");
INSERT INTO ata_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ia mulai xe muxalisou vile lailaixe manina la mulai musovanu mimii noxou mukalusi. La sou anu mulai mulotonu lasala ne. ");
INSERT INTO ata_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Iesu muavuti la musolonu vaivaikala noxou no anu vaikala latilovo vile la aloxo ꞌo. Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne aloxo vuꞌo vile ta mitema ivuꞌovuꞌo no anu no luaki. Vuꞌo ne ileanu uluꞌelai no luaki la ta sinana iouiou ineꞌe iꞌuna no anu. ");
INSERT INTO ata_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Xe vuꞌo ne uꞌanaꞌana ukalu, la sou ta mitema ne ilapunu uatu no tasiꞌi, la sou ixolu sou ilevineꞌi ta sinana. La itaataaneꞌi ta sinana ane ta lailaixe no lakela xe ane ta masumasua la ipeineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Anu iou vilesisi aloxo ne uxali iliꞌi no mine tuala xalexaleenu ukalu. La ta angelo ineꞌe ikalipakaneꞌi ta mitema ta masumasua noxiꞌa ta mitema ane milapu. ");
INSERT INTO ata_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","La ileaneꞌi ulai no navu ane toxoxaꞌa la itatama xe anaxaꞌa ukalakikiki.’” ");
INSERT INTO ata_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Xe Iesu muavuti la mutaliꞌisiꞌa lexe, “Loxovaa ngingi ngelavusou vaivaikala latilovo ne laaxu?” La aneꞌi mikolinu lexe “Ani.” ");
INSERT INTO ata_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Anu muavuti la muvikalaneꞌi lexe, “Aloxo ne la sou ta tisa sou lapuloto ne aneꞌi milavusou laaxu vaivaikala sou saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. Aneꞌi aloxo ta mitema sou isaxilaꞌu tani tatila vile. Aneꞌi iꞌuna no tani ne la ilaasou mimii lailaixe e mikuponu muai ne uatu. La ilaanu alaalavua, xe teiteinu kalumo.” ");
INSERT INTO ata_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","No mine Iesu mukalusou vaikala latilovo mukalu la Anu musuku mulai no tualasou ne Nasaleti. ");
INSERT INTO ata_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Anu mulai muxali no tualasou mukalu la muꞌunalai no taasou lalotu noxiꞌa. Xe aneꞌi milomusou vaivaikala noxou la mikuluke manina. La mitaliꞌi lexe, “Itema ꞌo munoꞌu lavulavu neꞌi ꞌo? Mo tavaꞌu a loxovaa la sou Anu munoꞌu xavi sou uꞌoxonu sosovo iouiou ꞌo? ");
INSERT INTO ata_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nenge telavusou lexe itema ne Anu itemasou utulusou tani vile ꞌolu ane, mo nenu ualasie lexe Malia xe ta vimovimou ane Iakovo ilou Iosepu mo Saimoni xe Iudasi. ");
INSERT INTO ata_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mo ta vimovimou ta sema kalumo ane nenge nengeꞌa taxoxolu ꞌo. Ia loxovaa la Anu munoꞌu xavi sou uꞌoxonu sosovo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","La aneꞌi ilomuxu uasi. Ia Anu muavuti la muvikalaneꞌi lexe, “Itema sou palomatana ne ta tema tualasou iloꞌa ta minuminu no nano no taasou ne ilavusou itoxonu uasisi manina. Ia no tuala vaꞌavaꞌaxusi ne la ta mitema itoxonu misevile.” ");
INSERT INTO ata_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","La sou Anu uꞌoxonu sosovo tavuꞌalo uasi xo aneꞌi imuxaxu taneꞌi noxou uasi. ");
INSERT INTO ata_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","No voxo ane Elodesi muxolu tatananu tuala ne Xalilaia, la mulomusou aꞌalosou xaixai noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","La sou muvikalaneꞌi ta mitema sou xaixai noxou lexe, “Itema ane ne anu Ioanesi itema sou uꞌulosiꞌa ta mitema ane. Anu musoli mo miꞌasixu ia mumauli a mutulu ne. La sou anu xaviinu sou uꞌoxonu sosovo iouiou ne.” ");
INSERT INTO ata_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Xo Elodesi munoꞌe ou e Pilipi semau sou muꞌuluxe, la sou Ioanesi muvikalanu lexe, “Nini neꞌoxonu ꞌilixo ane ne, umomomo no anu lapuloto noxou Mosesi uasi, sou nenoꞌe Elodia vivine semau la neꞌuluxe ne.” ");
INSERT INTO ata_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ioanesi muvikalanu Elodesi aloxo ne, la anu laꞌiaxu, la anu umasaxa lexe uvau mo usoli. Ia uꞌume noxiꞌa ta mitema xo aneꞌi miꞌoxo lexe anu itema sou palomatana vile ane. ");
INSERT INTO ata_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xe voxo sou isosovo sou voxo ane Elodesi nenu mivoꞌonu no anu muxali la anu muꞌoxonu laꞌilali toxoxaꞌa. Ia no mine aneꞌi iꞌaniꞌani la Elodia ꞌilie sema miꞌunalai no nano no tani la milei no ieꞌi. La Elodesi muisuxu leie ne. ");
INSERT INTO ata_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","La sou anu muavuti la musakii vaikala mo muvikala lexe, “Manina teitexi, nini nemasaxau mii maꞌia xe navikalaleli, la eni alosinesi.” ");
INSERT INTO ata_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Xe nenie miavuti la miꞌunanu tane noxie lexe imasaxau Ioanesi kisou. La sou aneꞌi milai mivikalanu mamie lexe, “Eni emasaxau Ioanesi kisou uai no anu la kupapa vile uneꞌe.” ");
INSERT INTO ata_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","La tatananu tuala ne opo tuꞌumaxu manina, ia umomomo sou uxiunu xavutalau uasi. Xo uxavutala no anu vaikala musakiinu noxie ꞌolu mo muvikala lexe manina teitexi, xe uxavutala noxiꞌa ta tatila e mineꞌe no anu laꞌilali ne kalumo xo ipupuiou. La sou anu mupalusiꞌa ta mitema sou ꞌotoꞌoto lexe ilai no taasou navunavu mo ixotonu Ioanesi xolanu mo inoꞌu kisou uneꞌe noxie loxo ane mimasaxau ne. ");
INSERT INTO ata_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aneꞌi milai mixotonu xolanu mukalu la mimulaxu kisou no anu lakupapa la sou minoꞌu muneꞌe sou milosie vuanga ne. La sou ane minoꞌu mulai noxie nenie. ");
INSERT INTO ata_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xe ta molomolo noxou Ioanesi mineꞌe la sou minoꞌu vasimolu mulai sou miꞌasixu. Aneꞌi miꞌasixu mukalu la milai miaꞌalou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu mulomusou aꞌalo sou Ioanesi mukalu, la Anu mutelo kokovu no anu uaxa sou mulai no xalee tani e ta mitema seꞌi ixoxolu no anu uasi. Ia ta mitema no xalexalee tuala ta tatila milomusou la mimulinu mimuamuaꞌi no tavaꞌa la milai mixali. ");
INSERT INTO ata_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Xe no mine Iesu muneꞌe muxali no tasiꞌi la mumaisiꞌa ta mitema tavuꞌalo itaꞌotaꞌolu. La Anu tanuxaꞌa misevile, la sou anu mupamaulineꞌi aneꞌi ane pipiena muꞌoxoneꞌi. ");
INSERT INTO ata_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Xe no ꞌoloꞌolovoxo manina la ta molomolo noxou mineꞌe mivikalanu lexe, “Anu aꞌalaꞌalai sou aso uꞌuna, la sou anu laixe lexe nini napalusiꞌa mo ilai no tuatuala seꞌi ꞌalaꞌalai ꞌo mo ilotonuxaꞌa laꞌilali sou iꞌou. Xo nenge texolu no xalee lia ane ꞌo ne ta mitema seꞌi ixolu no anu uasi.” ");
INSERT INTO ata_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu muavuti la muvikalaneꞌi lexe, “Uasi, ngapalusiꞌa ilai mamu, ngingi menge ngakamulixaꞌa laꞌilali mo ngalosiꞌa iꞌou.” ");
INSERT INTO ata_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aneꞌi miavuti la mivikalanu lexe, “Nexi veleti taꞌuvesi xe sinana ta tameisi ane ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Xe Anu muavuti la muvikalaneꞌi lexe, “Nganoꞌu uneꞌe.” ");
INSERT INTO ata_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","La sou Iesu mupalusiꞌa ta mitema ne sou mixolu no lia no iaꞌeiaꞌe ne. Xe aneꞌi mitaꞌolu no lia mukalu la sou anu munoꞌu veleti taꞌuve ne ilou sinana ta tamei ne la iou mulai teitexi no opo loxotolo sou mulemolu laixe musuku mulai noxou Lataua no anu. La sou Anu museꞌiseꞌinu veleti ne la mulosiꞌa ta molomolo noxou sou mimilaꞌanu noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aneꞌi latala ne miꞌaniꞌani xo mole miꞌanaꞌana manina, la sou ta molomolo noxou Iesu mineꞌe mitaxusou laꞌilali matomatovinu paꞌupaꞌusou. Aneꞌi mitaxusou xe mipitanu, la mitataanu no lakela mavulovexa mo muluꞌe lia tamei. ");
INSERT INTO ata_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Itiitisiꞌa ta mitema e miꞌani ne mumomomo loxo 5,000. Ane itiitisiꞌa ta mulusi ia ta sema xe ta molomolo inoꞌu itiitisiꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Xe alaxu vilesisi ꞌo la Iesu mupalusiꞌa ta molomolo noxou sou mitelo no uaxa la miuli milai no xalee vile. No mine Anu mupalusiꞌa ta mitema milailai. ");
INSERT INTO ata_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Xe iliꞌi no mine Anu mupalusiꞌa ta mitema milailai mukalu, la Anu mutelai teitexi no laxaꞌilu vile sou mukilaka. Xe no ꞌolovoxo la Anusisi muxoxolu no laxaꞌilu ne. ");
INSERT INTO ata_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ia no mine uaxa mulai nopaxa, la xasi mo atume toxoxaꞌa molu no talaxaꞌa muneꞌe ututeletelenu uaxa ne la ulivulivusiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","No mine ꞌalaꞌalai sou lamana ukekea la Iesu mumuamuaꞌi no lexa loxoꞌu mulai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Xe ta molomolo noxou mimaisou Iesu mine umuamuaꞌi no lexa loxoꞌu ia uneneꞌe noxiꞌa la aneꞌi taneꞌi kalaua xo mixavutala lexe male ulee xaleꞌa vile ane, la aneꞌi miungaunga. ");
INSERT INTO ata_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Xe Anu muavuti la mupasipaa muvikalaneꞌi alaxu vilesisi lexe, “Ngaꞌume mamu! Pekiꞌainge xo enisiꞌa!” ");
INSERT INTO ata_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Xe Pita muavuti la muvikalanu lexe, “Tatila lexe nini manina, la navikalaleli mo amuamuaꞌi no lexa loxoꞌu, alai noxine.” ");
INSERT INTO ata_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu muavuti la muvikalanu lexe, “Naneꞌe.” La sou Pita mutaloxo teitexi no uaxa muluꞌe la mumuamuaꞌi no lexa loxoꞌu mulai noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ia no mine anu mumaisou atume ilou xasi toxoxaꞌa xe muꞌume, la musoko sou uꞌuoꞌuo uluꞌelai. La sou muꞌava noxou Iesu lexe, “Tila! nasuꞌulileli.” ");
INSERT INTO ata_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Alaxu vilesisi la Iesu mutolosou avolu mulai la mulapunu mutelo. La muvikalanu lexe, “Nini loopala noxine kituꞌasi, mo xavutalameni ta tamei sou maꞌi?” ");
INSERT INTO ata_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Xe aneꞌi ilou mitelo no uaxa la atume ne tasiau. ");
INSERT INTO ata_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","La sou aneꞌi teitexi no uaxa ne mimaisou aloxo ne la mixolaꞌu tavaꞌa sou milotu noxou la mivikala lexe, “Manina misevile, nini Lataua ꞌOlu.” ");
INSERT INTO ata_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xe aneꞌi milai la mixali no kupa xalee vile ne Xenesaleti. ");
INSERT INTO ata_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Xe ta mitema no tuala ne mitongonu Iesu la misova anaxaꞌa mulai no tuatuala ta tatila ꞌalaꞌalai no paꞌupaꞌumeꞌa. La ta mitema mitavutavuleneꞌi ta mitema ane vovolea iouiou muꞌoxoneꞌi no luusiꞌa sou mineꞌeneꞌi noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","La mivikalanu pekiaꞌu lexe ta mitema ane vovolea iouiou muꞌoxoneꞌi ne ikasou tokolomou veveeni telexusi. La sou aneꞌi latala ane mikasou ne mimauli. ");
INSERT INTO ata_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Alaxu vile la ta Palisaio iloꞌa ta tisa sou lapuloto meꞌa ne Ielusalemu mineꞌe noxou Iesu, la mitaliꞌisou aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tavaꞌu loxovaa, la sou ta molomolo noxine imulinu lapuloto noxiꞌa ta xaixaisinge ua, mo iꞌuinu avoꞌa ka sou iꞌani ua?” ");
INSERT INTO ata_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Tavaꞌu loxovaa la sou ngingi ngamulinu lapuloto noxou Lataua ua, ia ngemulinu noxinge ꞌo? ");
INSERT INTO ata_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Xo Lataua muvikala lexe, ‘Ngatoxoneꞌi mamine ilee nenine.’ Mo ‘Anu ane uleanu vaikala seꞌi masumasua ulai noxiꞌa momu ilee nenu, la itema ne ivau usoli.’ ");
INSERT INTO ata_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ia ngingi ngavikala lexe, itema vile uvikalaneꞌi momu ilee nenu lexe, ‘Suꞌuli maꞌia ane lexe ngingi ngongou nganoꞌu noxilo ne anu ulai noxou Lataua.’ ");
INSERT INTO ata_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Anu uꞌoxonu aloxo ne la utoxoneꞌi momu ilee nenu uasi. Ngingi ngepolovilenu vaivaikala noxou Lataua laaxu la ngelai ngeꞌunanu no anu lapuloto noxiꞌa ta xaixasinge. ");
INSERT INTO ata_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","La sou Aisaia itema sou palomatana muvikalasinge ne manina. Iesu muvikala lexe, ‘Ngingi ta mitema sou kalakalavoi!’ Anu mukaukavunu singe aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ta mitema ano ꞌo ne iꞌitinu ualasilo no anaxaꞌasi, ia oponeꞌi ne muxolu vaꞌaxu noxilo manina. ");
INSERT INTO ata_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mo ilotu noxilo ne, ia lalotuiꞌa ne maninasou uasi. Xo ilosieꞌixu ta mitema no anu lapuloto molu noxou Lataua uasi, lapuloto ane molu noxiꞌasi.’” ");
INSERT INTO ata_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Xe Iesu muavuti la muꞌavaliꞌa ta mitema tavuꞌalo ne mineꞌe noxou mukalusi la muvikalaneꞌi aloxo ꞌo, “Ngingi latala ne ngalomu laixe noxilo mo ngalavusou laixe no anu mii ano ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mii maꞌia ane uꞌuna noxou itema anaxu ne ulavusou uꞌoxo masuanu uasi, ia mii maꞌia ane ulaa uatu no anaxusi ane uꞌoxoo masuanu.” ");
INSERT INTO ata_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","La sou ta molomolo noxou mineꞌe mitaliꞌisou lexe, “Nini nelavusou lexe ta Palisaio milomusou vaikala noxine la oponeꞌi tuꞌumaxu uasi?” ");
INSERT INTO ata_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Anu mukolineꞌi aloxo ꞌo, “Lexe ovuovu ane Mamilo teitexi no opo loxotolo utounu uasi, la anu uluvusou ilou uliuliꞌu. ");
INSERT INTO ata_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ngaxavutala noxiꞌa ta mitema aloxo ne uasi, aneꞌi loxo ta mitema ieꞌi seleveenu iulaxuneꞌi ta menexiꞌa. Ia lexe itema e iou seleveenu ulaxunu itema iou seleveenu kalumo, la aneꞌi ilou ilapau uluꞌelai no taxa ukei.” ");
INSERT INTO ata_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Xe Pita muavuti la muvikala lexe, “Nalulusou vaikala latilovo ne noxixe.” ");
INSERT INTO ata_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Xe Iesu muavuti la mutaliꞌisiꞌa lexe, “Loxovaa ngingi kalumo ngalamana uasi? ");
INSERT INTO ata_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ngingi ngelavusou lexe mii maꞌia e uꞌuna noxou itema anaxu ne ulai uai no nano no opoonusi ka ulaa uatu la ulai no ale. ");
INSERT INTO ata_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ia mii maꞌia muxolu no nano noxou itema tanu, ia ulaa uatusi ane uꞌoxoo masuanu itema ne. ");
INSERT INTO ata_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Xo no nano no tanu itema ne ꞌiliꞌilixo loxo xavutala masumasua, mo ꞌilixo sou voteꞌi, mo pakali, mo uvau itema usoli, mo ꞌilixo ane mulu ulai noxie sema mitaulaꞌi, xe sema ilai noxou mulu mutaulaꞌi, xe ꞌilixo sou ikalavoisiꞌa ta mitema la itulusiꞌa no anu vaivaikala, mo uvikalasiꞌa ta mitema masumasua. ");
INSERT INTO ata_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","La sou mimii e uꞌoxo masuanu itema ane. Ia ane itema uꞌuinu avolu uasi ia uꞌani ne uꞌoxonu masuanu itema ne uasi.” ");
INSERT INTO ata_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Xe Iesu muavuti la musuku no tuala e muneꞌe muxolu no anu ne, sou mulai no xalee lia tila ne Taia xe Saidoni. ");
INSERT INTO ata_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","La sema Kenani vile e mixoxolu no xalenu lia ne mineꞌe la miꞌava noxou lexe, “Tila Deviti ꞌOlu, tanenixo! Xo ꞌalixeni sema ne uleenu masua vile muxolu noxie la muꞌoxoo masuane manina.” ");
INSERT INTO ata_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","La Iesu ukolinu vaikalaie vile uasi. La sou ta molomolo noxou mineꞌe la mivikalanu lexe, “Sema ꞌo ane a iꞌavaꞌava xe imulimulinengesi ꞌo, la sou nakusaie mo ilai.” ");
INSERT INTO ata_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","La sou Anu mukolineꞌi lexe, “Lataua mupalusilo eneꞌe sou akamulineꞌi ta Isilaeli e loxo ta sipsip ane milai mixolu mixovulaulau. Ia eni eneꞌe sou akamulineꞌi aneꞌi ane ta Isilaeli uasi. Uasi.” ");
INSERT INTO ata_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ia sema ne mineꞌe la mixolaꞌu tavaꞌe voꞌuxu muluꞌelai no talaxu Iesu la mivikalanu lexe, “Tila, nasuꞌulileli.” ");
INSERT INTO ata_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Anu muavuti la muvikalane aloxo ꞌo, “Anu laixe sou talosiꞌa ta aꞌaa ta molomolo laꞌilalixaꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Xe ane miavuti la mikolinu vaikalau lexe, “Tila, vaikala noxine ne manina, ia ta aꞌaa ne laꞌilali utuꞌutuxu ulapalapau noxou tatananeꞌi no luu la aneꞌi inoꞌu sou iꞌou.” ");
INSERT INTO ata_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","La sou Iesu muvikalane lexe, “Nini sema ꞌo ne muxamuxaxu taneni mutila musuku. La sou mii maꞌia nini nemasaxau ne anu uxali aloxo nini nemasaxau ne.” La sou no anu aso iou anesi la ꞌilie mimauli. ");
INSERT INTO ata_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ioxe Iesu muvula la mulutu mulai no luaki ne Xalilaia paꞌumolu la mutelai muxolu no laxaꞌilu vile. ");
INSERT INTO ata_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ia ta mitema tavuꞌalo mineꞌe noxou. Aneꞌi mineꞌe la mitavuleneꞌi ta mitema tavaꞌa ilou avoꞌa musoisoli, mo aneꞌi ane ieꞌi seleveenu, mo tavaꞌa mukilikalu, mo aneꞌi ane ivivikala uasi xe aneꞌi ane vovolea iouiou muꞌoxoneꞌi la mineꞌe misuꞌa laꞌoluxaꞌa no tavaꞌu la Anu mupamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Xe ta mitema mimaisou la mikuluke manina. Xo mimaisiꞌa aneꞌi ane ivivikala uasi mivikala mo aneꞌi ane imuamuaꞌi uasi, mimuamuaꞌi xe aneꞌi ane ieꞌi seleveenu mimalei, la miꞌitinu Lataua noxiꞌa ta Isilaeli. ");
INSERT INTO ata_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Xe Iesu muꞌavaliꞌa ta molomolo noxou mineꞌe noxou la muvikalaneꞌi aloxo ꞌo, “Eni talelixaꞌa ta mitema ꞌo misevile xo mineꞌe mixolu noxilo ꞌo voxo tatalu mukalu, ia xaꞌa mii loxo ꞌo sou iꞌou uasi. La eni amasaxa lexe apalusiꞌa ilivu ilai no tuatualasiꞌa uasi xo loxo ꞌo io ilai la ilapalapau no voteꞌi.” ");
INSERT INTO ata_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ta molomolo noxou miavuti la mikolinu aloxo ꞌo, “La sou nenge taxalisou veleti neꞌei sou umomomosiꞌa ta mitema latala ꞌo? Nenge texolu ꞌo ne no xalee tani vitanisi ano ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Xe Anu muavuti la mutaliꞌisiꞌa lexe, “Xo ngingi veleti taꞌei e ngenonoꞌu ne?” Aneꞌi mikolinu lexe, “Muxatele tameisi xe ta sinana ta kitukituꞌa tavuꞌalo uasi.” ");
INSERT INTO ata_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Anu muavuti la muvikalaneꞌi ta mitema tavuꞌalo sou mixolu no lia. ");
INSERT INTO ata_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aneꞌi mixolu no lia mukalu la Anu munoꞌu veleti muxatele tamei xe ta sinana moso ne, sou muvikala laixe noxou Momu. Xe mukalu la museꞌiseꞌinu la mulosiꞌa ta molomolo noxou sou mimilaꞌanu noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ta mitema miꞌaniꞌani xo mole miꞌanaꞌana manina. Xe iliꞌi, la sou ta molomolo noxou minoꞌu lakela muxatele tamei la mitaataa laꞌilali paꞌupaꞌusou no anu. ");
INSERT INTO ata_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ta mitema e miꞌani ne itiitisiꞌa muxali loxo 4,000. Ane ne itiitisiꞌa ta mulusi ia ta sema iloꞌa ta molomolo uasi. ");
INSERT INTO ata_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Xe iliꞌi no mine Iesu mupalusiꞌa ta mitema milailai mukalu la sou Anu mutelo no anu uaxa sou mulai no xalee lia ne Maxatani. ");
INSERT INTO ata_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xe ta Palisaio iloꞌa ta Sadokaio mineꞌe noxou Iesu la iꞌoxo lexe itovo lexe italiꞌisou, la mivikalanu lexe uꞌoxonu sosovo vile mo aneꞌi imaisou lexe Anu molu noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Anu muavuti la mukolineꞌi aloxo ꞌo, “‘No mine aso uꞌuna xe ngingi ngamaisou loxotolo lauolaouinu,’ la ngingi ngaꞌoxo lexe, ‘Neꞌiela la voxo vile laixe la.’ ");
INSERT INTO ata_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Xe no kakao la ngamaisou loxotolo lauolauoinu ia tamuxala utomu la ngingi ngavikala lexe, ‘Maasi la nenge laꞌiua usili.’ Ngingi ngelavusou sosovo seꞌi teitexi no loxotolo, musosovosou mii maꞌia. Ia ngingi ngalavusou mii maꞌia ane uxali vaimomo ꞌo uasi. ");
INSERT INTO ata_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ngingi ta mitema ta masumasua mo ta mitemasou ngaꞌoxoꞌoxonu ꞌiliꞌilixo sou voteꞌi. Ngingi ngamasaxa lexe ngamaisou sosovo vile ia umomomo sou ngamaisou vile uasisi manina, sosovo vilesisi ane noxou Iona nesi.” Xe Iesu muꞌumesiꞌa la mixoxolu ne ia Anu mulai. ");
INSERT INTO ata_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Xe no mine Iesu iloꞌa ta molomolou mixisaꞌi milai no kupa xalee vile, la ta molomolo noxou Iesu taneꞌi vulusi la inoꞌu xaꞌa veleti uasi. ");
INSERT INTO ata_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","La Iesu muvikalaneꞌi lexe, “Ngasaxilaꞌinge laixe no anu isi (ꞌilixo) noxiꞌa ta Palisaio mo ta Sadokaio.” ");
INSERT INTO ata_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aneꞌi milomu sou aloxo ne la mivikalaneꞌi ngatongatoꞌo lexe, “Anu muvikalanenge aloxo ne xo nenge tanoꞌu nenge veleti uasi.” ");
INSERT INTO ata_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aneꞌi milai la ialimolosou vaikala ne, la Anu mulavu. La sou mutaliꞌisiꞌa aloxo ꞌo, “Tavaꞌu loxovaa la ngingi ngevikala ngatongatoꞌo lexe ngingi nganoꞌu nenge veleti uasi? Ngingi ngamuxaxu tangengi uasi? ");
INSERT INTO ata_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Loxovaa, ngingi ngalavusou uao? Mo ngaxavutalanu uasi? No voxo ane eni eseꞌiseꞌinu veleti taꞌuve ilou sinana ta tamei xaꞌa ta mitema (5,000) itemaxu mavulovexa mavulovexa tamei mo itemaxu mavulovexa taꞌuve, la ngetaanu paꞌupaꞌusou lakela sou taꞌei? ");
INSERT INTO ata_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mo no voxo ane eni eseꞌiseꞌinu veleti muxatele tamei xaꞌa ta mitema (4,000) itemaxu mavulovexa mavulovexa tamei, la ngetaanu paꞌupaꞌusou lakela taꞌei? ");
INSERT INTO ata_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","La sou ngingi nganava e ngalavu sou uao ꞌo? Eni alelemolu veleti uasi, ia eni avivikala ngengi lexe ngasaxilaꞌinge laixe no anu isi noxiꞌa ta Palisaio iloꞌa ta Sadokaio.” ");
INSERT INTO ata_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aneꞌi milomu sou la sou milamana lexe anu ulelemolu isi e imulaxu no anu veleti sou uꞌoxoo usoxo uasi. Ia Anu mupeletotosiꞌa, so lexe isaxilaꞌa laixe no anu ꞌilixo noxiꞌa ta Palisaio iloꞌa ta Sadokaio. Xo ilosoieꞌi no anu ꞌilixo noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Xe iliꞌi no mine Iesu iloꞌa ta molomolo mixali no xalee ne Kaisalia Pilipai, la Anu mutaliꞌisiꞌa ta molomolo noxou aloxo ꞌo. “Ta mitema mimaisou Itema ꞌOlu la miꞌoxo lexe ꞌenaꞌei.” ");
INSERT INTO ata_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aneꞌi miavuti la mikolinu lexe, “Seꞌi mivikala lexe nini Ioanesi itema sou uꞌulosiꞌa ta mitema moseꞌi ivikala lexe nini Eliasi, moseꞌi la ivikala lexe nini Elemia, xe seꞌi ivikala lexe nini vile noxiꞌa ta mitema sou palomatana.” ");
INSERT INTO ata_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Xe Anu muavuti la mutaliꞌi vaxa noxiꞌa lexe, “Ia ngingi la ngingi ngavikala lexe eni ꞌenaꞌei?” ");
INSERT INTO ata_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xe Saimoni Pita muavuti la mukolinu aloxo ꞌo, “Nini Kalisito, Lataua umauli utotomu ꞌOlu.” ");
INSERT INTO ata_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Xe Iesu muavuti la muvikalanu aloxo ꞌo, “Saimoni, Ioanesi ꞌolu nini naꞌosa. Xo itema vile upalaꞌalixu noxine uasi, Mamilo anu uxolu teitexi no opo loxotolo, Anusisi ane mupalaꞌalixu noxine ne. ");
INSERT INTO ata_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mo eni avikalaneni manina aloxo. Nini Pita, mo teitexi no anu lavoꞌo ne la eni atulusou taasou lalotu noxilo. La umomomo sou xavi no anu soli uꞌuna no nano no anu aitengaxu lalotu ne uasi. ");
INSERT INTO ata_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mo eni alosine lakii sou aitenga sou saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. Mii maꞌia nini nasakiinu no lia ꞌo la Lataua usakiinu teitexi kalumo. Xe mii maꞌia nini nalulusou no lia ꞌo la Lataua ululusou teitexi kalumo.” ");
INSERT INTO ata_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Xe muavuti la mupelaꞌa ta molomolo noxou lexe umomomo sou iaꞌaloxu noxou evile lexe anu Kalisito uasi. ");
INSERT INTO ata_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ioxe, no voxo ane ne la Iesu musolonu vaivaikala noxou sou mupelaꞌa ta molomolo noxou lexe, anu laixe lexe Anu ulai ne Ielusalemu. Mo utavulenu tuꞌutuꞌumaxu tavuꞌalo no avoꞌa ta tatila sou lalotu iloꞌa ta ailiꞌi, xe ta tisa sou lapuloto. Mo ivau usoli la iꞌasixu uai voxo tamei, xe no anu voxo tatalusou la Anu utulu. ");
INSERT INTO ata_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Xe Pita muavuti la mutilaꞌu Iesu la mulailixu vaꞌaxu sou mulavixu. La muvikalanu lexe, “Tila umomomo sou mimii ane ne uxali noxine mamu.” ");
INSERT INTO ata_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu muxiu la muvikalanu Pita aloxo ꞌo, “Satani naxexesilo! Natalutaluxu voteꞌi silo uasi. Xavutala e muxolu noxine ne, nini namulinu masaxa noxou Lataua uasi, nemulinu xavutala noxiꞌa ta mitemasi.” ");
INSERT INTO ata_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Xe Iesu muavuti la muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Lexe ꞌei ane umasaxa lexe umulileli la anu umulinu masaxa noxou uasi, ia uneꞌe mo utavulenu ovu valautu loxo eni etavulenu ꞌo mo umulileli, mo usoli loxo eni asoli no ovu valautu. ");
INSERT INTO ata_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Xo itema ane tanuxu maulixu ne, iliꞌi la uxovulaunu. Ia itema ane tanuxu maulixu uasi, ia uitalonu maulixu silo ne iliꞌi la uxali sou mauli. ");
INSERT INTO ata_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ia lexe itema vile unoꞌu mimii latala sou lia ꞌo ukalusi, xe uxovulaunu uleenu, la sou mimii sou lialia ane anu munoꞌu ne usuꞌulinu a loxovaa? Male uasi. Mo mii maꞌia ane sou anu ulotonu uleenu no anu sou ulivulixu. ");
INSERT INTO ata_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Xo Itema ꞌOlu ulivu uneꞌe la uneꞌe no anu xavi noxou Momu, iloꞌa ta angelo noxou. Mo ulosiꞌa ta mitema ulusou ꞌiliꞌilixo maꞌia ane aneꞌi miꞌoxoꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","La sou eni avikalangengi manina musuku lexe, seꞌi noxinge e itulutulu no taingengi ꞌo isoli uasi ixoxolu mo imaisou Itema ꞌOlu ulivu uneꞌe no anu xavi mo saxisaxilaꞌu noxou.” ");
INSERT INTO ata_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ioxe iloꞌa mixoxolu xe voxo muxatele vile mukalu, la sou anu Iesu munoꞌa Pita ilou Iakovo xe Ioanesi e Iakovo vimou la muulaxuneꞌi sou iloꞌa milai mitelai no laxaꞌilu vile teitexi manina mole aneꞌisisi milai mixoxolu ne. ");
INSERT INTO ata_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iloꞌa mixoxolusi xe mimalei loxo ꞌo la Iesu vasimolu ne muxiu mo muxali iou vilemo manina. Iou ne muxali loxo aso, mo tokolomou ne muxali iou vilemo mo muxali lamanaxu xe mulamilami loxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Xe mimalei loxo ꞌo la Eliasi ilou Mosesi mipaa mixali mitulu no paꞌumolu Iesu la iloꞌa mivivikala. ");
INSERT INTO ata_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita muavuti la muvikala vaxa noxou Iesu aloxo ꞌo, “Tila anu laixe xo nexi kalumo a taxoxolu ꞌo. La sou lexe nini namasaxa la nexi taꞌalaxu tani alelaxu tatalu. Nini sine vile, Mosesi sou vile xe Eliasi sou vile.” ");
INSERT INTO ata_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","No mine Pita uao uvivikala ꞌo, ia tamuxala vile lamanaxu misevile muneꞌe la mukuponeꞌi mukalusi. La vaikala vile mupaa no nano no anu tamuxala ne la muvikala aloxo ꞌo, “Eni ꞌalixeni ano, amasaxau misevile. Ngalomuxu vaivaikalau.” ");
INSERT INTO ata_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Xe no mine aneꞌi milomusou vaivaikala aloxo ne la miꞌume la misusunu ieꞌi muluꞌelai no lia. ");
INSERT INTO ata_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ia Iesu muneꞌe la mukasi vaxa noxiꞌa la muvikalaneꞌi lexe, “Ngaꞌume mamu, ngatulu.” ");
INSERT INTO ata_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Xe alaxu vilesisi ꞌo, la aneꞌi mimamalei, la imaisou evile uasi, Iesu anusisi a ututulu. ");
INSERT INTO ata_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ioxe iloꞌa miavuti sou misuku teitexi no laxaꞌilu ne sou ilivu iluꞌe, la Iesu mutalosiꞌa lexe, “Mimii e ngemaisou ꞌo, umomomo sou ngaꞌaloxu noxou evile uasi ulai uxali no voxo ane Itema ꞌOlu utulu no lulusou.” ");
INSERT INTO ata_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Xe aneꞌi miavuti la mitaliꞌisou lexe, “Ia loxovaa, la sou ta tisa sou lapuloto mivikala lexe Eliasi anu uxali tei?” ");
INSERT INTO ata_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Xe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Vaikala ne anu manina, Eliasi ne anu uxali tei sou ulalaxineꞌi ta mitema ukalusi. ");
INSERT INTO ata_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ia eni avikalangengi aloxo ꞌo, Eliasi ne muneꞌe ia ta mitema ne itoxonu uasi, la mikalusou masaxa noxiꞌa sou miꞌoxonu ꞌiliꞌilixo seꞌi mulai noxou. Anu iou vilesisi aloxo ne la Itema ꞌOlu unoꞌu tuꞌumaxu no avoꞌa ta mitema.” ");
INSERT INTO ata_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","La sou aneꞌi ta molomolo noxou milavusou lexe Anu mulelemolu Ioanesi itema sou uꞌulosiꞌa ta mitema ane. ");
INSERT INTO ata_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iloꞌa miluꞌe xe mixali no lia noxiꞌa aneꞌi latala la itema vile muneꞌe la mixolaꞌu tavaꞌu voꞌuxu muluꞌe no tavaꞌu Iesu la muvikala aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tila, tanenixu ꞌalixe mulu, xo uleenu masua muxolu noxou la muꞌoxo masuanu manina. No mine uꞌoxonu la voxo moseꞌi ne uleanu uꞌuna no navu xe uleanu uluꞌe no lexa. ");
INSERT INTO ata_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eni enoꞌu muneꞌe noxiꞌa ta molomolo noxine lexe ipamaulinu la aneꞌi imomomo uasi.” ");
INSERT INTO ata_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngingi ta mitema sou ngamuxaxu tangengi noxou Lataua uasi! Tauu ie taꞌei exolu noxinge ꞌo? Mo alaxu taꞌei ane sou eni atavulenu tuꞌutuꞌumaxu noxinge? Nganoꞌu molomolo ne uneꞌe noxilo.” ");
INSERT INTO ata_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Xe Iesu muavuti la mulavixu uleenu masua la muxexesou molomolo ne, la anu laixenu alaxu vilasisi. ");
INSERT INTO ata_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Xe ta molomolo milutu milai noxou Iesu la mitaliꞌisou seꞌisisi aloxo ꞌo, “Tavaꞌu loxovaa la sou nexi tamomomo sou takusau uleenu masua ne ua?” ");
INSERT INTO ata_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu mukolineꞌi aloxo ꞌo, “Xo loopala noxine ne kituasi, eni avikalangengi manina aloxo, lexe loopala noxine ne kituꞌa loxo ovu masitati ngiaxu la ngingi ngamomomo sou ngavikalanu laxaꞌilu vile lexe, nasuku mo nalai, la laxaꞌilu ne ulomuxenesi.” Mii vile pekiaꞌu noxinge uasi. ");
INSERT INTO ata_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Ia mimii uxali no anu mii vile uasi, no anu ꞌilixo sou pelemu xe lakilakasi.) ");
INSERT INTO ata_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Xe no voxo ane aneꞌi mipita ne Xalilaia la Iesu muvikalaneꞌi aloxo ꞌo, “Ulai iliꞌi la ta mitema iꞌitalonu Itema ꞌOlu no avoꞌa ta mitema sou ivau usoli. ");
INSERT INTO ata_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aneꞌi ivau usoli la uai no nano no lulu xe voxo tatalusou la Anu utulu umauli la.” Xe ta molomolo noxou milomusou aloxo ne, la aneꞌi taneꞌi kalaua xe taneꞌi mutama. ");
INSERT INTO ata_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu iloꞌa ta molomolo noxou mixali ne Kapenaumu xe iliꞌi la ta mitema sou itaxusou lamoli sou lalotu muneꞌe mitaliꞌisou Pita lexe, “Loxovaa, Tisa noxinge uleanu lamoli no anu tani sou lalotu kalumo?” ");
INSERT INTO ata_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Xe Pita muavuti la mukolineꞌi aloxo ꞌo, “Ani Anu uleanu kalumo.” Ia no mine Pita muꞌunalai no nano no tani la Iesu mutaliꞌisou aloxo ꞌo, “Saimoni nini nexavutala a loxovaa? Ta tatananu lialia ꞌo, no mine itaxusou lamoli la inoꞌu noxiꞌa ta ꞌiliꞌiliꞌa kalumo, uasi, inoꞌu noxiꞌa aneꞌi vaꞌaxusi?” ");
INSERT INTO ata_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Xe Pita muavuti la mukolinu lexe “Ani aneꞌi inoꞌu noxiꞌa vaꞌaxusi.” Iesu muvikala Pita lexe, “Ta ꞌiliꞌiliꞌa ne aneꞌi itaxusou lamoli noxiꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","La sou Iesu muvikalanu aloxo ꞌo, “Xo loxo ꞌo io nenge taꞌoxonu oponeꞌi masuainge. La sou nalai no luaki mo naleanu xalolo xe sinana ane uꞌala tei xe nalapu utelo la namalei no nano no anaxu. La sou namaisou lamoli itiitisou mumomomo noxinge nengei, la sou nalai nalosiꞌa.” ");
INSERT INTO ata_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","No anu voxo ane ne la ta molomolo noxou Iesu mineꞌe noxou la mitaliꞌisou lexe, “ꞌEi anu mutila no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo?” ");
INSERT INTO ata_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Xe Iesu muavuti la muꞌavalou molomolo kituꞌa vile muneꞌe la mitulusou no taineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","La muvikalaneꞌi aloxo ꞌo, “Eni avikalangengi manina aloxo ꞌo, lexe ngingi ngaxiu mo ngaxali loxo ta molomolo ta kitukituꞌa uasi la umomomo sou ngaꞌunalai no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo uasisi manina. ");
INSERT INTO ata_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","La sou lexe ꞌei ane utaloxolixu loxo molomolo kituꞌa ꞌo la anu utila no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mo ꞌei ane uꞌosa sou usuꞌulinu molomolo kituꞌa vile no ualasilo aloxo ꞌo xo anu muxavutalaleli, la anu muꞌoxonu noxilo. ");
INSERT INTO ata_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ia lexe itema vile uolexu vile noxiꞌa ta molomolo e mimuxaxu taneꞌi noxilo ne isusu no anu ꞌilixo masua vile, la anu laixe lexe isakii lavoꞌo kulu vile toxoxaꞌa no xolanu mo ileanu uluꞌelai no lautu no luaki lixinu mo uꞌuoꞌuo. ");
INSERT INTO ata_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","La sou ngingi ta mitema no lialia ꞌo ngasaxilainge laixe no anu tuꞌutuꞌumaxu ane sou uxali noxinge, xo mimii tavuꞌalo sou lialia ꞌo uꞌoxoneꞌi la ilapau la iꞌuna no anu susu. Anu susu ne uxali aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ia lexe avone vile ilou tavaꞌine vile ususulixene, la naxotosou uxexee mo nasuꞌanu. Anu laixe lexe naꞌunalai no nano no anu tuala sou mauli no ꞌa tavaꞌine vilesisi xe avone vilesisi. Loxo ꞌo io avone ta tamei xe tavaꞌine ta tamei uxolu la ileaneni uluꞌelai no anu navu e ukakaa utotomu mo kaluxu uasisi manina. ");
INSERT INTO ata_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mo lexe ieni vile ususulixene la naluvunu uxexee mo nasuꞌanu. Anu laixe lexe nini naꞌunalai no tuala sou mauli no ieni vilesisi. Loxo ꞌo io ieni ta tamei uxolu la ileaneni uluꞌelai no anu navu e ukakaa utotomu mo kaluxu uasisi manina.” ");
INSERT INTO ata_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Iesu musolonu vaivaikala noxou la muvikala la aloxo ꞌo, “Ngasaxilainge laixe, loxo ꞌo io ngamaisiꞌa ta molomolo loxo ꞌo, loxo ta mii vitanisi. Uasi. Eni avikalangengi lexe teitexi no opo loxotolo ne ta angelo noxiꞌa ilavusou imaisou Mamilo iou utotomu teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","‘La sou Itema ꞌOlu mulivunoxaꞌa aneꞌi ane mixovulauneꞌi mineꞌe sou mupamaulineꞌi.’ ");
INSERT INTO ata_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mo lexe itema vile usaxilaꞌa ta sipsip itemaxu taꞌuve ia uxovulaunu vile la, ngingi ngexavutala a loxovaa? Umomomo sou anu uitaloneꞌi ta sipsip mavulovexa muxatele tamiꞌa mo muxatele tamiꞌa ne ixoxolu no laxaꞌilu ne ia anu ulai sou ukamulinu ane muxovulaunu ne o? Ani. ");
INSERT INTO ata_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","La sou eni avikalangengi manina aloxo ꞌo, no mine anu uxalisou sipsip vilesisi e muxovulaunu ne la anu uꞌosa manina. ꞌOsa sou sipsip vilesisi ne utila noxiꞌa ta sipsip mavulovexa muxatele tamiꞌa mo muxatele tamiꞌa ꞌole. ");
INSERT INTO ata_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anu iou vilesisi aloxo Maminge uxolu teitexi no opo loxotolo umasaxa lexe vile noxiꞌa ta molomolo ta kitukituꞌa ne isusu ilai vaꞌaxu uasi.” ");
INSERT INTO ata_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesu muavuti la musolonu vaivaikala noxou la aloxo ꞌo, “Lexe vivine vile uꞌoxo masuaneni, la nini nalai noxou mo ngingisisi ngongou ngamomosou. Lexe anu ulomuxene la nini nelivunoxu. ");
INSERT INTO ata_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ia lexe anu ulomuxene uasi, la nalai nanoꞌu itema vile xe uasi la ta tamei la ineꞌe sou imomosou. Aloxo ne mo sou no anaxaꞌa ta mitema ta tamei xe tatalu la imomomo sou ivalaxu vaikala. ");
INSERT INTO ata_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ia lexe anu ulomuxaꞌa ta mitema ne uasi, la nalai nanoꞌa aneꞌi no anu lalotu ineꞌe imomo sou. Ia lexe anu ulomuxaꞌa ta mitema sou lalotu la ne uasi, la aneꞌi ta mitema ane aneꞌi ta Iutaia uasi mo loxo itemasou unoꞌu lamoli noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Eni avikalangengi manina lexe, mii maꞌia ane ngingi ngasakiinu no lia ꞌo, la anu usakii teitexi no opo loxotolo. Xe mii maꞌia ane ngingi ngalulusou no lia ꞌo, la Anu ululusou teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mo eni avikalangengi la aloxo ꞌo, lexe ta mitema ta tamei noxinge no lia ꞌo imasaxau mii vile mo oponeꞌi vilesisi no anu xe ilingau la Mamilo uxolu teitexi no opo loxotolo Anu ulosiꞌasi. ");
INSERT INTO ata_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Xo ta mitema ta tamei xe tatalu ipita no anu ualasilo la eni kalumo a axolu no taineꞌi.” ");
INSERT INTO ata_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Xe no voxo ane ne la Pita muneꞌe noxou Iesu, la mutaliꞌisou aloxo ꞌo, “Tila, alaxu taꞌei eni alulusou susu noxou vivilo vile muꞌoxonu muneꞌe noxilo? Alaxu muxatele tamei?” ");
INSERT INTO ata_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu muavuti la mukolinu aloxo ꞌo, “Eni avikalaneni aloxo ꞌo, lexe nini namasaxa nalulusou susu noxou vivine, la nalulusou alaxu muxatele tamei uasi. Nini nalulusou alaxu mavulovexa muxatele tamei alaxu muxatele tamei (70 x 7). ");
INSERT INTO ata_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","La sou saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne anu aloxo tatananu tuala vile muneꞌe sou unoꞌu lakolisou mii maꞌia ane anu mulosiꞌa ta mitema sou xaixai noxou. ");
INSERT INTO ata_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No mine anu musokou sou mumomomo sou la itema e munoꞌu (10,000 taranito) ia ukolinu uasi muneꞌe noxou. ");
INSERT INTO ata_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ia anu itema ne umomomo sou ukolinu lamoli ne uasi. La sou tila noxou itema ne muavuti la muvikala lexe, nganoꞌa ilee semau mo ta ꞌolu xe ta miumiu ukalusi ne mo ngasovaneꞌi, la sou lamolisiꞌa uneꞌe ukolinu lamoli noxilo. ");
INSERT INTO ata_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ioxe itemasou xaixai ne mulomu sou vaikala ne la mulapau muluꞌelai muxolaꞌu tavaꞌu voꞌuxu no tavaꞌu tatananu tuala ne la mukatunu lexe, ‘Nini tanenixo mo nalosilo voxo seꞌi la, la sou eni akolinu lamoli ne ukalusi.’ ");
INSERT INTO ata_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tila noxou itemasou xaixai ne mumaisou aloxo ne la anu tanuxu. La sou anu muavuti la muvikalanu lexe, umomomo sou nakolinu uasi la mupalusou mulai. ");
INSERT INTO ata_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ioxe itema ne mulai no ale la mumaisou menexu vile e munoꞌu lamoli seꞌi (100 Denalia) noxou ia ukolinu uasi la mukasi noxou la mukapilaxu pekiaꞌu la muvikalanu lexe, ‘Nini napalea nakolinu lamoli noxilo.’ ");
INSERT INTO ata_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","La sou itema ne menexu muavuti la mulapau muluꞌelai la muxolaꞌu tavaꞌu voꞌuxu no lia la mukatunu la muvikalanu lexe, ‘Nini tanenixo mo nalosilo voxo seꞌi la, la sou eni akolinu.’ ");
INSERT INTO ata_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ia itema ne ulomuxu menexu ne uasi, la mulai mumuxaxu menexu ne no taasou navunavu umomomo anu ukolinu lamoli noxou. ");
INSERT INTO ata_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","No mine ta menexu mimaisou ꞌilixo e menexiꞌa muꞌoxonu ne la oponeꞌi tuꞌumaxu manina. Xe miavuti la milai miaꞌaloxu noxou tilasiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tatila noxou itema ne mulomusou aloxo ne la muꞌavalou itema ne muꞌuna la muvikalanu lexe, ‘Nini itema sou xaixai masua. Tei la nini netama noxilo la eni eꞌoxonu ꞌilixo laixe noxine la nakolinu lamoli toxoxaꞌa noxilo uasi. ");
INSERT INTO ata_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Loxovaa la nini tanenixu menexine ne loxo eni eꞌoxonu noxine ne ua.’ ");
INSERT INTO ata_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","La sou tila noxou ne laiꞌaxu la sou mulai mumulaxu no taasou navunavu ulai uxali no mine anu ukolinu lamoli ne ukalusi. ");
INSERT INTO ata_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","La sou mamilo uxolu teitexi no opo loxotolo uꞌoxonu ꞌilixo iou vilesisi aloxo ne noxinge. Lexe ngingi ngaxiunu tumalingeu susu noxiꞌa tavivinge no nano no opongengi manina.” ");
INSERT INTO ata_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu muvivikalaneꞌi aloxo ne xe mukalu, la Anu musuku no xalee lia tila ne Xalilaia la muxisaꞌisou lexa ne Ioridani mulaia xalee vile no xalee lia tila ne Iutaia. ");
INSERT INTO ata_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","La ta mitema tavuꞌalo mimulinu mine la Anu mupamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ioxe ta Palisaio seꞌi mineꞌe noxou sou lexe itovonu. Mineꞌe mixali noxou la mitaliꞌisou lexe, “Itema vile umasaxa lexe usuꞌane semau no anu masaxa noxou, la loxovaa, ꞌilixo ane ne mumomomo no anu lapuloto noxinge?” ");
INSERT INTO ata_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu muavuti la mukolineꞌi aloxo ꞌo, “Loxovaa ngingi ngamaisou uai no nano no anu vaikala noxou Lataua uasi? Lexe tatei manina no voxo ane Lataua musokou mukoinu mimii latala, la Anu mukoineꞌi ta mitema kalumo. La mukoineꞌi ta mulu xe ta sema. ");
INSERT INTO ata_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mo muvikala lexe, tavaꞌu aloxo ne la sou mulu uꞌumesiꞌa momu ilee nenu la ulai ilee semau ipita la ixali vasimeꞌa vilesisi. ");
INSERT INTO ata_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","La aneꞌi ixali ta tamei la ua ꞌa, ia ixali vilesisi. Aloxo ne la sou mii maꞌia Lataua mupitanu muxali vilesisi ne umomomo sou itema vile ukalipalanu uasi.” ");
INSERT INTO ata_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aneꞌi milomusou aloxo ne la mivikala lexe, “Ia Mosesi muvikala lexe itema vile umasaxa lexe uxotonu taulaꞌi noxiꞌa ilee semau la anu molu ukaukavu ulai noxie la sou upalusie ilai.” ");
INSERT INTO ata_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","La Iesu mukolineꞌi aloxo ꞌo, “Xo ngingi opongengi pekiaꞌu la sou Mosesi mupelemasaxangengi sou ngaxotonu taulaꞌingenge ngongiꞌa ta semasemamengi. Ia tatei manina no mine Lataua musokou mukoinu mimii latala uasi. ");
INSERT INTO ata_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","La sou eni avikalangengi aloxo ꞌo, lexe mulu vile ukusaie semau no anu masaxa noxou ia iꞌoxonu susu vile uasi, ia ulai uꞌuluxe sama vile la, la anu muꞌoxonu ꞌilixo sou voteꞌi.” ");
INSERT INTO ata_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ta molomolo noxou Iesu milomusou aloxo ne la mivikalanu Iesu aloxo ꞌo, “Xo ꞌiliꞌilixo aloxo ne uxali noxiꞌa mulu ilee semau, la sou anu laixe lexe ta mulu itaulaꞌi uasi.” ");
INSERT INTO ata_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ioxe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Umomomo sou ta mitema tavuꞌalo imulinu vaikala ane ne uasi. Ia aneꞌi ane Lataua mulosiꞌa xavi sou itaulaꞌi uasisi imulinu. ");
INSERT INTO ata_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta mulu moseꞌi ilavusou itaulaꞌi uasi. Xo seꞌi ne no mine ta neniꞌa mivoꞌoneꞌi la vasimeꞌa uxolu uasi xe seꞌi ne ta mitema mipalaneꞌi. Xe seꞌi ne, aneꞌi meꞌa imasaxa lexe itaulaꞌi uasi, ia ixolu aloxo ne sou iꞌoxonu xaixai no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. La sou ꞌei ane umasaxa lexe unoꞌu vaikala ane ꞌo la anu unoꞌu.” ");
INSERT INTO ata_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","No voxo ane ne la ta mitema minoꞌa ta molomolo mineꞌe noxou Iesu sou lexe Anu umulaxu avolu no kisiꞌa xe ukilakasiꞌa. Ia ta molomolo noxou miavuti la mikusaiꞌa ta mitema ne. ");
INSERT INTO ata_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Xe Iesu muavuti la muvikalaneꞌi lexe, “Iengi uvaxaiꞌa ta molomolo ne si mo ineꞌe noxilo. Xo saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo anu noxiꞌa ta molomolo aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anu mumulaxu avolu no kisiꞌa sou mukilakasiꞌa mukalu la Anu musuku sou mulai. ");
INSERT INTO ata_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Xe Iesu mulai la itema vile muneꞌe noxou la mutaliꞌisou lexe, “Tisa, eni aꞌoxonu ꞌilixo maꞌia ulapu la sou anoꞌu mauli ane kaluxu uasi no anu?” ");
INSERT INTO ata_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Xe Iesu muavuti la mukolinu aloxo ꞌo, “Tavaꞌu loxovaa la sou nini netaliꞌisilo no anu ꞌilixo mulapu ꞌo? Lataua anusisi Anu mulapu, ia lexe nini namasaxa sou nanoꞌu mauli ane kaluxu uasi, la namulinu lapuloto noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Xe itema ne muavuti la mutaliꞌi mulivu noxou Iesu lexe, “Lapuloto maꞌia?” La sou Iesu muvikalanu lexe, “Lapuloto ne aloxo ꞌo, ‘Navau itema vile usoli mamu mo naꞌoxonu ꞌiliꞌilixo sou voteꞌi mamu mo napakali mamu xe nakalavoi sou itema vile vitanisi mamu.’ ");
INSERT INTO ata_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mo natoxoneꞌi mamine ilee nenine xe tanenixaꞌa ta mitema vaꞌaxu loxo nini tanenixene.” ");
INSERT INTO ata_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Xe anu maulu ne muavuti la mukolinu Iesu aloxo ꞌo, “Lapuloto ne eni emulinu mukalusi, ia mii maꞌia ane eni paꞌusilo no anu?” ");
INSERT INTO ata_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Xe Iesu muavuti la mukolinu aloxo ꞌo, “Lexe nini namasaxa naxali itema mulapu manina la nalai mo nasovanu mimemimeni mo ta mitema ilotonu. Xe lamolisou la nalai nalosiꞌa ta mitema ane iꞌa mimii uasi. Nini naꞌoxonu aloxo ne la sou mimii lailaixe ane uai teitexi no opo loxotolo ne nini naꞌanini. Mo naneꞌe namulileli.” ");
INSERT INTO ata_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","No mine maulu ne, mulomusou aloxo ne la iou ne mupalulu, la mumuamuaꞌisi mole mulai avile. Opoonu uꞌosa uasi xo anu muxavutala no anu miumiu tavuꞌalo ꞌole. ");
INSERT INTO ata_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Xe Iesu muavuti la muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Eni avikalangengi manina lexe itema sou lavuluti ne pekiaꞌu noxou sou uꞌunalai no nano no anu saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mo avikalangengi lexe kameli umasaxa uꞌunalai no anu ꞌumo taxanu ne la anu seꞌisisi. Ia itema sou lavuluti anu pekiaꞌu noxou sou uꞌunalai no anu saxisaxilaꞌu noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","No mine ta molomolo noxou milomusou aloxo ne la mikuluke manina la mivikala lexe, “La sou ꞌei manina ane anu unoꞌu mauli ane kaluxu uasi?” ");
INSERT INTO ata_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu iou mulai noxiꞌa la mumatakisiꞌa, la muvikalaneꞌi aloxo ꞌo, “Mimii tavuꞌalo ne seꞌisisi noxou Lataua ia noxiꞌa ta mitema la anu pekiaꞌu.” ");
INSERT INTO ata_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Xe Pita muavuti la muvikalanu lexe, “Nexi tavuꞌalo ne texiu tumalixeu mimii ne ia teneꞌe sou temulineni ne. La sou nini nalosixe mii maꞌia?” ");
INSERT INTO ata_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","La Iesu muvikalaneꞌi lexe, “Eni avikalangengi manina aloxo ꞌo, no voxo ane mimii uxali alavua xe Itema ꞌOlu unoꞌu uala tila la uxolu no anu puloulou noxou. No voxo ane ne la ngingi ane ngemulileli ne, ngingi kalumo ngaxolu no anu puloulou ane laixe mavulovexa mo mulelia tamei, la ngaxolu sou ngatilovosiꞌa ta mata mavulovexa mo mulelia tamei ne Isilaeli. ");
INSERT INTO ata_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mo aneꞌi ane mixavutala no anu ualasilo la miꞌumesou taataasiꞌa mo miꞌumesiꞌa ta vimovimoꞌa ta mulu mo ta vimovimoꞌa ta sema iloꞌa ta mamiꞌa mo ta neniꞌa xe ta ꞌiliꞌiliꞌa ilou xaixaixaꞌa ne inoꞌu lakolisou alaxu itemaxu taꞌuve. Xe inoꞌu mauli ane kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ia ta mitema tavuꞌalo e miuliuli, ulai la aneꞌi ilai iliꞌi, ia aneꞌi ane itoxoneꞌi vaimomo uasi ꞌo ne ilai la iuli.” ");
INSERT INTO ata_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu musolonu vaivaikala noxou lexe, “Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne aloxo, itema vile musaxilaꞌu xaisou uaini vile. No kakau manina la anu mulai muꞌavaliꞌa ta mitema moseꞌi sou ilai ixaxai no anu xaisou uaini ne. ");
INSERT INTO ata_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta mitema ne misosovosou Denalia vile lexe anu ulotoneꞌi no anu voxo vile la sou anu mupalusiꞌa milai sou mixaxai no anu xaisou uaini noxou ne. ");
INSERT INTO ata_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Xe no anu aso iou muxatele tamiꞌa la anu mulai la, la mumaisiꞌa ta mitema seꞌi la a itulutulu no anu tanixu pitapita ꞌole la ixoxolu vitanisi. ");
INSERT INTO ata_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","La sou anu muavuti la muvikalaneꞌi lexe, ‘Ngingi kalumo ngalai mo ngaxaxai no anu xaisou uaini noxilo. La sou eni alotongengi umomomo no anu xaixai maꞌia ngingi ngeꞌoxonu.’ ");
INSERT INTO ata_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","La sou aneꞌi milai. Xe no aso mukulupa mo no aso iou tatalu, la anu mulai no tanixu pitapita la muꞌoxonu xaixai iou vilesisi aloxo muꞌoxonu tei ne la. ");
INSERT INTO ata_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xe no a aso iou taꞌuve no ꞌoloꞌolovoxo la anu mulivu mulai la, la mumaisiꞌa seꞌi la a itutulu. La sou anu muavuti la mutaliꞌisiꞌa lexe, ‘Tavaꞌu loxovaa la sou ngingi ngatutulu vitanisi aso veveeni ia ngaꞌoxonu mii vile uasi ꞌo?’ ");
INSERT INTO ata_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Aneꞌi muavuti la mikolinu lexe, ‘Xo itema vile ulosixe xaixai uasi.’ La sou anu muvikalaneꞌi lexe, ‘Ngingi kalumo ngalai mo ngaxaxai no anu xaixai sou uaini noxilo.’ ");
INSERT INTO ata_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Xe no ꞌoloꞌolovoxo, la tatananu xaisou uaini ne muvikalanu itema sou xaixai noxou e musaxilaꞌu xai sou uaini ne lexe, ‘Naꞌavaliꞌa ta mitema e mixaixai ne mo nalosiꞌa uluiꞌa. Nasoko noxiꞌa aneꞌi ane miiliꞌi la sou ulai uxali noxiꞌa aneꞌi ane miuli.’ ");
INSERT INTO ata_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","La sou aneꞌi ane misoko mixaxai no aso iou taꞌuve ne mineꞌe la minoꞌu Denalia vilevilesi momoxaꞌa. ");
INSERT INTO ata_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Xe aneꞌi ane misoko mixaixai tei mineꞌe la miloopala lexe inoꞌu lamoli tatila. Ia uasi aneꞌi kalumo minoꞌu Denalia vilevilesi. ");
INSERT INTO ata_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","No mine ane minoꞌu lamoli xe mimaisou aloxo ne, la laꞌiaxaꞌau tatananu xai ne. ");
INSERT INTO ata_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","La mivikala lexe, ‘Ta mitema ane mixali iliꞌi manina ꞌo mixaxai aso iou vilesisi, la nini nelosiꞌa lamoli vilesisi aloxo nexi ꞌo. Ia nexi teꞌoxonu xaixai toxoxaꞌa mo tetuluxu aso ialuxu voxo vile lololi.’ ");
INSERT INTO ata_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ia anu muavuti la muvikalanu vile noxiꞌa ne aloxo ꞌo, ‘Menexilo, eni aꞌoxo masuaneni uasi, nenge nengei tesakii vaikala lexe nini naxaxai no anu voxo vile la nanoꞌu Denalia vile. ");
INSERT INTO ata_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nanoꞌu naꞌanini mo nalai, xo eni e masaxa lexe alosiꞌa aneꞌi ane mixali iliꞌi ulu iou vilesisi aloxo nini nenoꞌu nesi. ");
INSERT INTO ata_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nini oponeni masuailo xo maꞌi? Anu mii noxilo. Mo eni amasaxa lexe avelunu lamoli a loxovaa no anu masaxa noxilo, la anu mii noxilo. Uasi, loxovaa oponeni masuailo xo eni eꞌoxonu ꞌilixo laixe noxiꞌa ta mitema ne?’ ");
INSERT INTO ata_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aloxo ne la sou aneꞌi tapiena e miuli ne ulai la ilai iliꞌi ia aneꞌi ane miiliꞌi ne ilai iuli.” ");
INSERT INTO ata_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ioxe no mine Iesu mulutu sou mutelai ne Ielusalemu la munoꞌa ta molomolo noxou mavulovexa mo mulelia tamei ne la iloꞌa aneꞌisisi milai. La muvikalaneꞌi aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ngalomu nenge nengeꞌa tatelai ne Ielusalemu la aneꞌi iꞌitalonu Itema ꞌOlu no avoꞌa ta tatila noxiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto. La itulusou no anu vaivaikala la ivau usoli. ");
INSERT INTO ata_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mo inoꞌu ulai noxiꞌa ta mitema ane aneꞌi ta Iutaia uasi sou imolovilaꞌisou mo ipuapuasou xe ililixu no ovu valautu. Xe usoli, la inoꞌu ulai uai no lulu voxo tatamei xe voxo tatalusou la anu utulu umauli la.” ");
INSERT INTO ata_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Xe iliꞌi la Zevetaio ta ꞌolu ta tamei neniꞌa mineꞌe la minoꞌa ta ꞌilie mineꞌe noxou Iesu la mixolaꞌu tavaꞌe voꞌuxu no lia la mivikalanu lexe uꞌoxonu mii vile no anu masaxa noxie. ");
INSERT INTO ata_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Xe Iesu muavuti la mutaliꞌisie lexe, “Nemasaxau mii maꞌia?” La sema ne mivikalanu Iesu lexe, “Eni emasaxa lexe nini navikala lexe ulai iliꞌi no mine nini naxali tatananu tuala, la ta ꞌalixeni ta tamei ꞌo ixolu no paꞌumene. Vile uxolu no tema xe vile no ꞌae.” ");
INSERT INTO ata_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngingi ngalavusou mii maꞌia ane ngingi ngalingau ꞌo uasi. Loxovaa ngingi ngongou ngemomomo sou nganoꞌu tuꞌutuꞌumaxu aloxo eni anoꞌu ꞌo, ngaie no anu paku e eni aie no anu ꞌo?” La aneꞌi ilou mikolinu lexe, “Ani, nexi temomomo.” ");
INSERT INTO ata_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","La Iesu muvikalaneꞌi ilou la aloxo ꞌo, “Manina, ngingi ngongou ngemomomo sou nganoꞌu tuꞌutuꞌumaxu no anu paku ne. Ia no anu masaxa noxinge ngongou lexe vile uxolu no tema xe vile no ꞌae ne anu mii noxilo sou alosinge vitanisi uasi. Xo luu ane ne Mamilo mulalaxisiꞌa ta mitema ane Anu molu musosovosiꞌa sou ilai ixolu no anu.” ");
INSERT INTO ata_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Xe no mine aneꞌi mavulovexa ne milomusou la laꞌiaxaꞌaiꞌa ilou vimou misevile. ");
INSERT INTO ata_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Xe Iesu muavuti la muꞌavaliꞌa la mineꞌe mipita mukalu la muvikalaneꞌi aloxo ꞌo. “Ngingi ngelavusou lexe ta tatananu tuatuala noxiꞌa ta mitema ane aneꞌi ta Iutaia uasi ne, iulaxuneꞌi ta mitema noxiꞌa utotomu. Mo ta tatilasiꞌa ne itovo lexe ta mitema ilomuxu vaikalaiꞌasi. ");
INSERT INTO ata_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ia ngingi aloxo ne uasi. Lexe anu ane umasaxa lexe uxali utila noxinge la anu laixe lexe anu uxali itema sou xaixai noxinge. ");
INSERT INTO ata_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mo ꞌei ane umasaxa lexe uuliuli noxinge, la anu laixe lexe anu uxali itema sou xaixai vitanisi noxinge. ");
INSERT INTO ata_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Anu iou vilesisi aloxo Itema ꞌOlu muneꞌe ꞌo sou ta mitema ixaxai noxou uasi ia anu uxaxai noxiꞌa ta mitema. Mo muꞌitalonu maulixu sou ulivulixaꞌa ta mitema tavuꞌalo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","No mine Iesu iloꞌa ta molomolo noxou sou ilaa ne Ieriko la ta mitema tavuꞌalo mimulinu. ");
INSERT INTO ata_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aneꞌi milai la ta mitema ta tamei ieꞌi seleveenu a ixoxolu no voteꞌi paumolu, xe no mine aneꞌi ilou milomusou lexe Iesu a umuamuaꞌi uneneꞌe, la ilou miꞌava toxoxaꞌa mulai noxou lexe, “Tila, Deviti ꞌOlu, taneninexe!” ");
INSERT INTO ata_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Xe ta mitema e iloꞌa Iesu mimuamuaꞌi ne milomusiꞌa ilou, la milavixaꞌa ilou lexe ilou ixolu tasiau. Ia aneꞌi ilou miavuti la miꞌava toxoxaꞌa manina lexe, “Tila, Deviti ꞌOlu, taneninexe.” ");
INSERT INTO ata_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xe alaxu vilesisi ꞌo la Iesu mutulu la muꞌavaliꞌa ilou la mutaliꞌisiꞌa ilou lexe, “Ngingi ngongou ngemasaxa lexe eni aꞌoxonu mii maꞌia noxinge ngongou?” ");
INSERT INTO ata_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","La aneꞌi ilou muavuti la mikolinu lexe, “Tila nexi noxou temasaxa lexe tamalei.” ");
INSERT INTO ata_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu tanuxaꞌa ilou la mukasi vaxa no ieꞌi ilou, xe alaxu vilesisi ꞌo la aneꞌi ilou mimalei, la ilou mimulinu Iesu. ");
INSERT INTO ata_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ioxe iloꞌa mimuamuaꞌi xe mixali ꞌalai ne Ielusalemu, la mixali no tuala ne Vetepaxe no laxaꞌilu ne Olivu, la Iesu mupalusiꞌa ta molomolo noxou ta tamei. ");
INSERT INTO ata_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","La muvikalaneꞌi ilou lexe, “Ngongou ngalai no tuala vile a no laxungengi ne, la ngamaisie donki neniꞌa vile a misakii ne itutulu ia ꞌilie a ututulu no paꞌumele. La sou ngalulusiꞌa ilou la nganoꞌa ineꞌe noxilo. ");
INSERT INTO ata_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ia lexe ngalulusiꞌa ia evile utaliꞌisingexaꞌa la, ngavikalanu lexe Tila mumasaxaiꞌa. La anu upalusinge ngalivu uneꞌe alaxu vilesisi.” ");
INSERT INTO ata_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mii ane uxali aloxo ne sou umomomo sou vaikala e ta mitema sou palomatana milemolu tei. ");
INSERT INTO ata_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Vaivaikala ne muvikala aloxo ꞌo, “Ngavikalaneꞌi ta mitema ne Ielusalemu lexe, ‘Ngamaisou tatananu tuala noxinge anu a uneneꞌe noxinge. Mo ngamaisou anu mutaloxolixu ualasou xe mutalupexa no anu donki ꞌilie latasou mo anu a uxali ꞌo.’” ");
INSERT INTO ata_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ioxe ta molomolo noxou ne milai la miꞌoxonu aloxo anu mupelaꞌa ilou ne. ");
INSERT INTO ata_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ilou minoꞌa donki ilee ꞌilie milai mixalixaꞌa noxou Iesu mukalu la sou minoꞌu ꞌalaꞌalasou vasimeꞌa ilou sou milalanu no latanu donki ane maulu ne sou Iesu mutelo mutalupexa no anu. ");
INSERT INTO ata_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Xe ta mitema tavuꞌalo kalumo mixexeenu ꞌalaꞌalasou vasimeꞌa no ale ka misiaꞌu no voteꞌi, xe seꞌi milai mixolaꞌu ovu avoavolu la mitaꞌolunu no voteꞌi kalumo. ");
INSERT INTO ata_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta mitema ane miulaxu Iesu xe aneꞌi ane mimulimulinu iliꞌi no tumalou ne miꞌava aloxo ꞌo. “Ta ꞌosasou, Deviti ꞌOlu.” “Lataua ualusou anu ane muneꞌe no anu xavi noxou IAUE.” “Ta itinu Lataua ualasou mo aneꞌi iꞌitinu ualasine teitexi no opo loxotolo.” ");
INSERT INTO ata_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu muneꞌe xe muꞌunalai ne Ielusalemu la, ta mitema tavuꞌalo no tuala tila ne mikuluke manina, la mitaliꞌisiꞌa ngatongatoꞌo lexe, “Itema ꞌenaꞌei manina ne?” ");
INSERT INTO ata_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","La sou aneꞌi ta mitema tavuꞌalo ne mivikalaneꞌi lexe, “Iesu anu itema sou palomatana sie Naseleti no xalee lia tila ne Xalilaia.” ");
INSERT INTO ata_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu muꞌunalai no nano no taasou lalotu tatila noxou Lataua, la mukusaiꞌa ta mitema e mitaꞌotaꞌolunu mimii sou ta mitema ilotonu mo aneꞌi ane mineꞌe sou ilotoloto no nano ne milailai no ale. Muvuluvexanu valovaloxaꞌa ta mitema ane ilavusou ivalavala lamoli no anu. Xe muvuluvexanu luuluusiꞌa aneꞌi ane mitaꞌoluneꞌi ta kuau sou ilotoneꞌi. ");
INSERT INTO ata_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xe muavuti la muvikalaneꞌi aloxo ꞌo, “Vaikala mikaukavunu muxolu no anu Lavuku Tavuna teinu muvikala aloxo ꞌo. ‘Taasilo ne ilemolu lexe taasou lakilaka,’ ia ngingi ngexiunu mole muxali loxo taasiꞌa ta mitema sou pakali sou italume no anu.” ");
INSERT INTO ata_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Xe ta mitema e ieꞌi seleveenu mo aneꞌi ane imuamuaꞌi uasi mineꞌe noxou Iesu sou Anu mupamaulineꞌi no nano no vimeluxu tani tila noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ia ta tatila noxiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto mimaisou sosovo ane anu muꞌoxonu ne anu iou vilemo. Xe milomusiꞌa ta molomolo no nano no ꞌa taasou lalotu tatila noxou Lataua ne miꞌava lexe, “Taꞌosasou Deviti ꞌOlu.” La aneꞌi laꞌiaxaꞌa. ");
INSERT INTO ata_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xe miavuti la mitaliꞌisou Iesu lexe, “Male nini nelomusou mii maꞌia e ta molomolo ꞌo milemolu ꞌo?” La Iesu mukolineꞌi aloxo ꞌo, “Ani eni elomusou. Ia loxovaa male ngingi ngaitisou vaikala ane ne muai no anu Lavuku Tavuna uasi?” Muvikala aloxo ꞌo, “Male nini nelomusou mii maꞌia e, ‘Lataua mulalaxiinu mulaa no anaxaꞌa ta molomolo xe ta keakea ꞌo iꞌitinu ualasou.’” ");
INSERT INTO ata_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iesu muvikalaneꞌi aloxo ne mukalu la muꞌitaloneꞌi mixoxolu ne la mulaa no tuala tila ne sou mulai muxolu ne Vetania no ꞌolovoxo ne. ");
INSERT INTO ata_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iloꞌa milai miai xe no kakau la milivu milai ne Ielusalemu la, Iesu musolixu. ");
INSERT INTO ata_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xe iou mulai la mutukumusou ovu lovo vile ne mutulu no voteꞌi paumolu. La sou mulutu mulai no anu sou ukamuli lexe temanu seꞌi ꞌa no anu, la mumaisou lexe ovu ne volovoloxusi ia uneneꞌa uasi. La sou muvikalanu ovu ne aloxo ꞌo, “Usoko vaimomo ꞌo, umomomo sou naneneꞌa la uasi.” Xe alaxu vilesisi la ovu ne muxalo. ");
INSERT INTO ata_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Xe ta molomolo noxou mimaisou aloxo ne la taneꞌilili. La mitaliꞌisou Iesu lexe, “Loxovaa la sou ovu muxalo alaxu vilesisi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","La Iesu mukolineꞌi aloxo ꞌo, “Eni avikalangengi manina aloxo ꞌo, lexe ngingi ngamuxamuxaxu tangengi ia xavutalamengi tatamei uasi, la ngingi ngaꞌoxonu mii maꞌia aloxo eni eꞌoxonu no anu ovu lovo ꞌo. Ia ane nesi uasi, anu umomomo sou ngavikalanu laxaꞌilu vile lexe, ‘Naavuti mo nailiꞌe ulai no luaki, la anu uꞌoxonu aloxo ne.’ ");
INSERT INTO ata_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lexe ngingi ngamuxamuxaxu tangengi xe ngakilaka sou mii vile ngemasaxau, la ngingi nganoꞌusi.” ");
INSERT INTO ata_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ioxe Iesu muꞌunalai no nano no anu taasou lalotu tatila noxou Lataua, la mulosieꞌi ta mitema lavulavu. Xe no mine Anu ulolosieꞌi ta mitema lavulavu, la ta tatilasiꞌa ta ꞌailiꞌi iloꞌa ta tatilasiꞌa ta Isilaeli mineꞌe noxou la mitaliꞌisou aloxo ꞌo, “Nini nenoꞌu xavi ane ne neꞌi la sou naꞌoxoꞌoxonu mimii ane ne no anu ꞌo? Xe ꞌei molu sou mulosine mo mupelemasaxaneni sou lexe nini naꞌoxonu xaixai ne?” ");
INSERT INTO ata_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Eni kalumo ataliꞌisingexu taliꞌi vile, lexe ngingi ngakolinu taliꞌi ne uneꞌe noxilo, la sou eni avikalangengi no anu. Lexe no anu xavi maꞌia ane eni aꞌoxonu mimii ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xavi ane Ioanesi muxaxai no anu sou muꞌulosiꞌa ta mitema ꞌo ne, anu molu neꞌi? Anu molu teitexi no opo loxotolo, uasi molu noxiꞌa ta mitema?” Xe aneꞌi miavuti la mivikalasou taliꞌi ne. La mivikalaneꞌi ngatongatoꞌo lexe, “Maasi xe nenge tavikala lexe Anu molu no opo loxotolo la Anu utaliꞌisinge ulivu la lexe, ia loxovaa la sou ngingi ngamuxaxu tangengi noxou ua? ");
INSERT INTO ata_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Xe nenge tavikala lexe molu noxiꞌa ta mitema, la ane ne umomomo uasi. Nenge taꞌume noxiꞌa ta mitema, xo ta mitema latala ne milavusi lexe Ioanesi ne anu itema sou palomatana manina vile ane.” ");
INSERT INTO ata_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","La aneꞌi miavuti la mikolinu Iesu aloxo ꞌo, “Nexi talavusou uasi.” Xe Iesu muavuti la muvikalaneꞌi lexe, “Eni kalumo umomomo sou apalaꞌalixu lexe ꞌei ane mupelemasaxaleli sou aꞌoxo mii ano ꞌo uasi.” ");
INSERT INTO ata_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu musolonu vaivaikala noxou la muvikalaneꞌi la aloxo ꞌo, “Ia ngingi ngexavutala a loxovaa? Lexe itema vile ta ꞌolu ta tamei, ia anu mulai la muvikalanu ꞌolu ane laposalaxu lexe, ‘ꞌAlixeni maasi la nalai mo naxaxai no ꞌa xaisou uaini.’ ");
INSERT INTO ata_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","La anu ukolinu lexe, ‘Eni amasaxa uasi.’ Ia iliꞌi la anu muxiunu xavutalau la, mulai sou muxaxai. ");
INSERT INTO ata_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Xe momu mulai la muvikalanu ꞌolu ane kokope no anu vaikala vilesisi aloxo ne. La anu muvikalanu momu lexe, ‘Ani mamilo eni alai.’ Ia iliꞌi la anu ulai ua. ");
INSERT INTO ata_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","La sou ꞌei noxiꞌa ilou mumulinu masaxa noxou momu?” Aneꞌi miavuti la mikolinu lexe, ‘Ane laposalaxu.’ Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Eni avikalangengi manina aloxo ꞌo, ta mitema sou itaxusou lamoli mo ta sema sou voteꞌi ne aneꞌi iulaxungengi sou iꞌunalai no anu saxisaxilaꞌu noxou Lataua tei ia ngingi ngailiꞌi. ");
INSERT INTO ata_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aloxo ne, la sou Ioanesi itema sou uꞌulosiꞌa ta mitema muneꞌe sou mulosiengixu voteꞌi sou ꞌiliꞌilixo mulapu la ngingi ngamuxaxu tangengi noxou uasi. Ia ta mitema sou itaxusou lamoli iloꞌa ta sema sou voteꞌisi mimuxaxu taneꞌi noxou. Mo iliꞌi no mine ngingi ngamaisou mimii ne la ngingi ngaxiunu opongengi mo ngamuxaxu tangengi noxou uasi.” ");
INSERT INTO ata_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mo Iesu muvikalaneꞌi la lexe, “Ngalomusou vaikala latilovo vile la aloxo ꞌo. Itema vile mutounu xaisou uaini vile, xe mukalu la muvimelu sou. Xe mukalu la mutulusou lavalolo sou imuxaxu uaini ngiangiaxu la ikapikapinu no anu. Mo mumuxaxu latotope sou uaini lexaxu uluꞌelai la utavo no anu. Mo mutulusou tani vile teitexi sou ta mitema ixolu no anu sou isaxilaꞌu xai ne. Muꞌoxonu aloxo ne, xe mukalu la, muitalonu xai ne no avoꞌa ta mitema seꞌi sou aneꞌi ixaxai no anu sou ulai la anu unoꞌu temanu seꞌi no anu ia anu mulutu sou mulai no tuala vile no paxa. ");
INSERT INTO ata_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ioxe, no voxo ane xaisou ovu uaini ne temanu xe momoxosou iꞌelexu, la mupalusiꞌa ta mitema sou xaixai noxou milai noxiꞌa ta mitema e misaxilaꞌu xai ne sou lexe inoꞌu naꞌu temanu seꞌi. ");
INSERT INTO ata_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aneꞌi milutu xe milai mixali, la ta mitema e misaxilaꞌu xai ne mitetelisiꞌa la mitoꞌotoꞌomolu vile xe vile la mivau musoli avile xe mivau vile no lavoꞌo. ");
INSERT INTO ata_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","La anu mupalusiꞌa ta mitema sou xaixai noxou seꞌi aneꞌi itiitisiꞌa tila noxiꞌa ane tei ꞌole milai la. La ta mitema sou isaxilaꞌu xai sou uaini ne miꞌoxoneꞌi aloxo ane tei ne la. ");
INSERT INTO ata_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Miꞌoxoneꞌi aloxo ne, la sou anu mupalusou ꞌolu mulai sou kaluxu sou. La muvikala lexe, ‘Male ꞌalixeni ulai la aneꞌi itoxonu.’ ");
INSERT INTO ata_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mulutu xe mulai muxali, xe ta mitema e ixaxai no xai ne mimaisou la mivikalaneꞌi ngatongatoꞌo lexe, ‘Itema ano ꞌo ne, anu ulai iliꞌi la ualasou utelo no anu momu mixumixu ꞌo ane. Nganeꞌe mo nengeꞌa tatetelisou mo tavaꞌu usoli, mo sou ulai iliꞌi la nenge ualasinge utelo no anu.’ ");
INSERT INTO ata_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Xe milutu vaxa la mivau musoli, ka mikasi vaxa noxou la mileanu muuatulai no anu vimeluxu xai ne. ");
INSERT INTO ata_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ioxe tatananu xai ne mulavu lexe ꞌolu ane ta mitema ne mivau musoli ne, xe uneꞌe la sou ngingi ngexavutala a loxovaa, mo uꞌoxonu mii maꞌia noxiꞌa ta mitema e misaxilaꞌu xai ne?” ");
INSERT INTO ata_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","La sou aneꞌi mikolinu lexe, “Anu uveꞌaveꞌa ta mitema ta masua ne isoisoli ukalusi, io sou anu uꞌitalonu xai ne ulai noxiꞌa ta mitema sou xaixai seꞌi vaꞌaxu.” ");
INSERT INTO ata_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xe Iesu muavuti la mutaliꞌisiꞌa lexe, “Loxovaa, ngingi ngeitisou vaivaikala seꞌi no anu Lavuku Tavuna teinu muvikala aloxo ꞌo? ‘Lavoꞌo e ta mitema sou itutulu tani misuꞌanu ne, anu muxali lavoꞌo vile laixe manina sou utetelisou tani. IAUE molusi muꞌoxonu mii ane ne. Nexi temaisou la laixe manina.’ ");
INSERT INTO ata_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Vaikala latilovo ne laaxu aloxo ꞌo, Lataua uxexeenu saxisaxilaꞌu noxou no avonge la ulosiꞌa ta mitema laꞌoluxaꞌa ane vaꞌaxu mo ixaxaisou la ixalixu temanu. ");
INSERT INTO ata_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mo itema ane ulapau no latanu lavoꞌo ane ne la anu utuxusi xe ꞌei ane lavoꞌo ne ulapau utelo no latanu la upelese avile.” ");
INSERT INTO ata_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","No mine ta tatilasiꞌa ta ailiꞌi iloꞌa ta Palisaio milomusou vaikala Iesu muꞌoxonu ne, la aneꞌi milavusousi lexe vaikala latilovo ne mumomomo noxiꞌa manina. ");
INSERT INTO ata_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xe aneꞌi miavuti la sou mikamuli voteꞌi sou lexe itetelisou Iesu, ia imamaꞌu noxiꞌa ta mitema xo ta mitema mixavutala lexe Anu itemasou palomatana ane. ");
INSERT INTO ata_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu musolonu vaivaikala noxou, la muvikalaneꞌi no anu vaikala latilovo la aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne, aloxo tatananu tuala vile ulalaxi sou uꞌoxonu laꞌilali sou ꞌolu utaulaꞌi. ");
INSERT INTO ata_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Anu mupalusiꞌa ta mitema sou xaixai noxou milai noxiꞌa aneꞌi ane anu muꞌavaliꞌa sou lexe ineꞌe no anu laꞌilali ne, la aneꞌi imasaxa sou ineꞌe uasi. ");
INSERT INTO ata_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","La anu mupalusiꞌa ta mitema sou xaixai seꞌi la milai la muvikalaneꞌi lexe, ilai ivikalaneꞌi ta mitema e muꞌavaliꞌa sou ineꞌe no anu laꞌilali lexe, ‘Nganeꞌe xo laꞌilali sou taulaꞌi a eni elalaxiinu mukalu. Kau tongolixu mo ta mimii ta tongotongolixaꞌa miꞌeleꞌelexaꞌa mukalu, xe laꞌilali iouiou ne muxutu mukalu. La sou ngingi nganeꞌe mo ngaꞌani.’ ");
INSERT INTO ata_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ia aneꞌi milomu uasi la milai no anu xaixaiiꞌa vilevilesi. Vile mulai no xaixu, xe vile mulai no taasou la iloto noxou. ");
INSERT INTO ata_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ia aneꞌi seꞌi ne miavuti la mitetelisiꞌa ta mitema sou xaixai ne ka miveꞌaveꞌa misoisoli. ");
INSERT INTO ata_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","La tatananu tuala laꞌiaxu misevile la mupalusiꞌa ta mitema sou ꞌotoꞌoto noxou milai miveꞌaveꞌa ta mitema ne misoisoli mukalusi xe mielaxu tualasiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Xe muavuti la muvikalaneꞌi ta mitema sou xaixai noxou lexe, ‘laꞌilali sou taulaꞌi mulalaxii mukalu, la ta mitema e eni eꞌavaliꞌa lexe ineꞌe no anu laꞌilali ꞌo ne ta mitema ta laixe sou ineꞌe uasi. ");
INSERT INTO ata_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","La sou ngalai no ioxuioxu votevoteꞌi xe ngaxalisou ꞌenaꞌei ne, la ngaꞌavalou uneꞌe.’ ");
INSERT INTO ata_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Xe ta mitema sou xaixai ne milai la miꞌavaliꞌa ta mitema taꞌei e aneꞌi mixalisiꞌa no voteꞌi ne mineꞌe, seꞌi ta mitema ta lailaixe xe seꞌi ta mitema ta masumasua. Xe mineꞌe mipita no anu tani sou taulaꞌi ne la muꞌanaꞌana manina. ");
INSERT INTO ata_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ia no mine tatananu tuala muꞌuna sou iou mumaisiꞌa la mumaisou vile no taineꞌi ne utaanu tokolomo sou taulaꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xe tatananu tuala muavuti la mutaliꞌisou lexe, ‘Ae menexilo, nini nenava la nataanu tokolomo sou taulaꞌi laixe ka sou naꞌuna ꞌo ua?’ La anu ukolinu uasi. ");
INSERT INTO ata_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","La sou tatananu tuala muvikalaneꞌi ta mitema sou xaixai noxou lexe, ‘Ngatetelisou mo ngasakisakiinu avolu ilou tavaꞌu mo ngalea ulai no ale no isivoxo no tuala sou itatama xe anaxaꞌa ukalakikiki.’ ");
INSERT INTO ata_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","La Iesu mukalusou vaivaikala noxou aloxo ꞌo, ta mitema tavuꞌalo Lataua muꞌavaliꞌa, ia anu musosovosiꞌa ta taꞌeisi sou iꞌunalai.” ");
INSERT INTO ata_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xe ta Palisaio milai la mikamuli voteꞌi sou lexe iuauoixu Iesu no anu vaivaikalau. ");
INSERT INTO ata_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","La mipalusiꞌa ta molomolo noxiꞌa iloꞌa ta mitema noxou Elodesi milai noxou Iesu, la mivikalanu aloxo ꞌo, “Tisa, nexi telavu lexe nini itema vile sou nalemo mii, la navikala maninasou. Mo nini nalavusou naꞌumeꞌa ta mitema uasi, xo aneꞌi ane ualasiꞌa mo aneꞌi ane ualasiꞌa uasi ne, mimomomo vilesisi no ieni. Ia nini nalosieꞌixu voteꞌi laixe noxou Lataua no anu vaikala manina. ");
INSERT INTO ata_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","La sou navikalanexi lexe, loxovaa anu lapuloto vile umomomo sou nenge taleanu lamoli ulai noxou Kaisari? Uasi, loxovaa taleanu?” ");
INSERT INTO ata_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aneꞌi mitaliꞌisou Iesu aloxo ne la Anu mulavu no anu kalakalavoi noxiꞌa ne. La muvikalaneꞌi lexe, “Ngingi ngamitema sou kalakalavoi. Tavaꞌu loxovaa ane ngingi ngaꞌoxo lexe ngatovoleli sou ngatetelisilo ꞌo? ");
INSERT INTO ata_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ioxe nganoꞌu Denalia vile uneꞌe mo amaisou.” La aneꞌi minoꞌu mulai noxou sou mumaisou. ");
INSERT INTO ata_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Xe muavuti la mutaliꞌisiꞌa lexe, “ꞌEi kisou mo ualasou e uxolu no anu lamoli ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","La aneꞌi mikolinu lexe, “Anu noxou Kaisari.” La sou Anu muvikalaneꞌi lexe, “Mii maꞌia ane noxou Kaisari, la ngalosou Kaisari. Xe mii maꞌia ane noxou Lataua la ngalosou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","No mine aneꞌi milomusou aloxo ne la aneꞌi mikuluke manina, la miꞌitalonu Iesu la milai. ");
INSERT INTO ata_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Xe iliꞌi no voxo ane ne la ta Sadokaio mineꞌe noxou. Aneꞌi ta mitema ane ne, ixavutala lexe ta mitema isoli, io ulai iliꞌi la imauli la uasi. Mineꞌe mixali noxou Iesu la mitaliꞌisou aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisa, vaikala muai no anu kaukavu noxou Mosesi muneꞌe noxinge aloxo ꞌo. Itema vile mutaulaꞌi ia upalaneꞌi ta ꞌolu uasi xe usoli, la anu laixe lexe vimou uꞌuluxe sema ne, mo sou upalaneꞌi iu vimou ta ꞌolu noxie. ");
INSERT INTO ata_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ioxe, no voxo vile la ta mitema muxatele tamei ixoxolu. Aneꞌi muxatele tamei ne aneꞌi ta taumetali. Iloꞌa ixoxolu la ane laposalaxu ne mutaulaꞌi, xe iliꞌi la musoli. Ia upalaneꞌi ta ꞌolu seꞌi noxie sema ne uasi, la muꞌitalone noxou vimou sou uꞌuluxe. ");
INSERT INTO ata_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Xe vimoꞌa ane ta tameisiꞌa ne muavuti la muꞌuluxe sema ne, la anu kalumo musoli la, ia upalaneꞌi ta ꞌolu seꞌi noxie uasi. Mo vimoꞌa tatalusiꞌa ne anu kalumo aloxo ne si. Anu aloxo ne mole, aneꞌi muxatele tamei mo ne, miꞌuluxe sema vilesisi ne, la vile noxiꞌa upalaa ꞌolu vile noxie uasi. ");
INSERT INTO ata_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mole iliꞌi la ane sema kalumo misoli. ");
INSERT INTO ata_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ioxe, ulai iliꞌi no anu voxo ane sou ta mitema ane misoisoli itulu sou imauli, la ꞌei noxiꞌa aneꞌi muxatele tamei ne semau maninasou xo loxo aneꞌi muxatele tamei mo ne aneꞌi miꞌuluxe sema vilesisi ne?” ");
INSERT INTO ata_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngingi ngexovulaulau no anu vaikalamengi, xo ngingi ngalavusou vaikala muxolu no anu Lavuku Tavuna mo xavi noxou Lataua uasi. ");
INSERT INTO ata_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta mitema ane misoisoli ne lexe imauli la umomomo sou itaulaꞌi la uasi. Aneꞌi ixali loxo ta angelo teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ioxe no anu vaivaikalasiꞌa ta mitema ane misoisoli ka itulu ne, loxovaa ngingi ngaitisou vaikala maꞌia Lataua muvikalangengixu uasi? ");
INSERT INTO ata_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Anu muvikala lexe, ‘Eni Lataua noxou Avalaamu mo Lataua noxou Aisaki mo Lataua noxou Iakovo.’ Anu Lataua ne noxiꞌa ta mitema misoisoli uasi, anu Lataua noxiꞌa ta mitema ane imauli vaimomo.” ");
INSERT INTO ata_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Xe no mine aneꞌi milomusou vaivaikala noxou Iesu ne, la mikuluke manina no anu aꞌalo noxou ne. ");
INSERT INTO ata_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ta Palisaio mixolu mipita ia milomusou Iesu mine mukolinu taliꞌi noxiꞌa ta Sadokaio la vaivaikalau ne mulapusi. ");
INSERT INTO ata_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","La sou vile noxiꞌa ne anu mulavu laixe no anu lapuloto ne uꞌoxo lexe utovonu Iesu no anu taliꞌi ne. ");
INSERT INTO ata_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Xe muavuti la mutaliꞌisou aloxo ꞌo, “Tisa, eni elavu lexe lapuloto noxinge tavuꞌalo, ia lapuloto anevaa ane muuli manina no anu lapuloto latala ne?” ");
INSERT INTO ata_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","La Iesu mukolinu aloxo ꞌo, “‘Ngamasaxau IAUE Lataua noxinge no anu tangengi, mo no anu uleengengi, mo no anu xavutalamengi ukalusi.’ ");
INSERT INTO ata_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lapuloto ane ne anu muuliuli xe mutila manina no anu lapuloto latala mukalusi. ");
INSERT INTO ata_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Xe ta tameisou ne anu mutila iou vilesisi aloxo ane tei ne aloxo ꞌo, ‘Ngamasaxau menexinge vile aloxo ngingi ngemasaxainge la!’ ");
INSERT INTO ata_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lapuloto noxou Mosesi mo vaivaikala noxiꞌa ta mitema sou palomatana ne anu tavaꞌu vilesisi ane no anu lapuloto tamei nesi.” ");
INSERT INTO ata_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ioxe no mine ta Palisaio mixolu mipita la Iesu mutaliꞌisiꞌa aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngingi ngexavutala noxou Kalisito a loxovaa? Mo ꞌei ꞌolu ne?” Xe aneꞌi miavuti la mikolinu lexe, “Deviti ꞌolu.” ");
INSERT INTO ata_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","La sou Anu muvikalaneꞌi aloxo ꞌo, “Tavaꞌu loxovaa la sou Uleenu Tavuna mulosou Deviti lavulavu la molu mumoxoꞌu lexe Tila noxilo? Deviti muvikala aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘IAUE muvikalanu Tila noxilo aloxo ꞌo, Navaꞌisaꞌileli no avolo tema ulai utalo no anu voxo ane sou eni amuxaxaꞌa ta uluameni no tavaꞌine laaxu.’ ");
INSERT INTO ata_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","La sou lexe Deviti molu mumoxoꞌu lexe anu Tila noxou. Ia loxovaa la sou anu Tila ne anu Deviti ꞌolu la?” ");
INSERT INTO ata_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aneꞌi milomu sou aloxo ne la vile ukolinu vaikala noxou uasi. Mo musoko no anu voxo ane ne la itema vile ulai noxou sou utaliꞌisou no anu taliꞌi vile la uasi. ");
INSERT INTO ata_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Xe iliꞌi la Iesu muvikalaneꞌi ta mitema iloꞌa ta molomolo noxou la aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ta Palisaio iloꞌa ta mitema sou lapuloto ilavusou ilosiengi no anu lapuloto loxo Mosesi muꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","La sou, anu laixe lexe ngingi ngalomu sou mo ngamulinu aloxo aneꞌi milosiengixu ne. Ia ngamulinu ꞌiliꞌilixo noxiꞌa mamu, xo aneꞌi ilosiengi ne ia ilavusou imulinu uasi. ");
INSERT INTO ata_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Anu aloxo aneꞌi isakiinu tavuevule tuꞌumaxu la imuxaxu no laxasinge, ia aneꞌi imuxaxu avoꞌa sevile no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mimii tavuꞌalo aneꞌi iꞌoxonu ne sou lexe ta mitema imaisiꞌasi. Aneꞌi ikaukavunu vaikala noxou Lataua la isakii no alaieꞌi xe itaanu tokolomo veveeni la lamota sou veveeni uvuvu ulili uluꞌe no anu la ixixaoxao. ");
INSERT INTO ata_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mo aneꞌi ilavu sou imasaxa lexe ixolu uuli no anu puloulou laixesi no anu voxo sou laꞌilali toxotoxoxaꞌa. Mo imasaxa lexe ixolu no anu puloulou uulisi no anu taasou lalotu noxiꞌa ta Iutaia. ");
INSERT INTO ata_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mo aneꞌi imasaxa sou ta mitema ixalisiꞌa no anu taasou pitapita la iꞌoxonu aso laixe noxiꞌa xe imoxoꞌa lexe, ‘Tisa.’ ");
INSERT INTO ata_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ia ngingi ta mitema imoxoꞌinge lexe tisa uasi, xo itema vilesisi anu ‘tisa’ noxinge ia ngingi tavuꞌalo ne ngamoxoꞌinge lexe ta vivixesi. ");
INSERT INTO ata_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mo namoxoꞌu itema vile no lia ꞌo lexe maminge uasi xo nenge Maminge vilesisi Anu ꞌa uxoxolu teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mo ngamoxoꞌu vile lexe tisa, uasi, xo tisa noxinge vilesisi ane Kalisito. ");
INSERT INTO ata_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mo tilasinge ne anu uxali loxo itema sou xaixai noxinge. ");
INSERT INTO ata_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Xo ꞌei ane uꞌitinu ualasou la Lataua utaloxolixu xe ꞌei ane utaloxolixu la Lataua uꞌitinu ualasou. ");
INSERT INTO ata_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Mo eni avikalangengi ta mitema sou lapuloto mo ta Palisaio lexe, ngasaxilaixe laixe no anu tuꞌutuꞌumaxu ane sou uxalinoxinge, xo ngingi ta mitemasou kalakalavoi. Xo ngingi ngetatusou aitenga sou saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo no ieꞌi ta mitema. Ia ngingi ngalavu sou ngaꞌunalai uasi, io no mine ta mitema itovo lexe iꞌunalai la ngingi ngaꞌapixaꞌa. ");
INSERT INTO ata_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Eni talelingenge ta mitema sou lapuloto mo ta Palisaio no anu tuꞌutuꞌumaxu ane sou uxali noxinge xo ngingi ngaxixaoxao no xalexaleenu lia mo no luaki xalexaleenu sou ngaꞌoxonu itema vilesisi sou uxali molomolo noxinge. Mo no mine ngingi ngaꞌoxonu uxali loxo molomolo vile noxinge ukalu, la ngaꞌoxonu uaꞌulingenge no anu ꞌiliꞌilixo masumasua manina, la sou uxali molomolo sou navu e uꞌaniꞌani no taxa la kaluxu uasi ꞌole. ");
INSERT INTO ata_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mo eni talelingenge no anu tuꞌutuꞌumaxu ane sou uxali noxinge. Xo ngingi iengi seleveenu ia ngaꞌoxo lexe ngalosieꞌixaꞌa ta mitema voteꞌi. Ngingi ngavikala aloxo ꞌo, ‘Lexe itema vile uvikala lexe manina teitexi no taasou lalotu la anu mii vile uasi. Ia lexe itema vile uvikala lexe manina teitexi no anu xoulu uai no taasou lalotu la anu uꞌoxonu aloxo anu mulemolu ne.’ ");
INSERT INTO ata_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ngingi iengi seleveenu mo ngexovulaulau manina. Mii maꞌia mutila manina no iou Lataua, male xoulu uasi taasou lalotu. Ngingi ngelavusou lexe xoulu uai no nano no taasou lalotu, la sou anu uxali loxo mii noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mo ngingi ngavikala kalumo aloxo ꞌo. ‘Lexe itema vile uvikala manina teitexi no anu tani alelaxu sou lalotu, la anu mii vile uasi. Ia anu uvikala lexe manina teitexi no anu mimii iꞌelaxu ꞌa uaai ꞌo, no nano no anu valovalo sou iꞌelaxu mimii no anu la anu uꞌoxonu aloxo anu mulemolu ne.’ ");
INSERT INTO ata_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ngingi iengi seleveenu mo ngexovulaulau manina. Mii maꞌia anu mutila no iou Lataua mii sou iꞌelaxu, uasi valovalo sou iꞌelaxu mimii no anu? Ngingi nganoꞌu mimii nganeꞌe ngaꞌelaxu no tani alelaxu ne la sou ngingi ngaꞌoxo lexe anu mii noxou Lataua. Ia uasi valovalo anu mii tatila no anu mii e ngaꞌelaxu ne. ");
INSERT INTO ata_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aloxo ne la sou ꞌei ane uvikala lexe manina teitexi no anu tani alelaxu sou lalotu ne la muvikala aloxo ne no anu tani alelaxu sou lalotu mo no mimii tavuꞌalo e muai no nano no anu. ");
INSERT INTO ata_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mo ꞌei ane uvikala lexe manina teitexi no anu taasou lalotu, la anu uꞌoxonu aloxo ne no anu taasou lalotusi uasi, anu muꞌoxonu aloxo ne noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mo ꞌei ane uvikala lexe manina teitexi no opo loxotolo, la anu uvikala aloxo ne ulai teitexi no opo loxotolosi uasi, anu muꞌoxonu aloxo ne no anu puloulou noxou Lataua mo noxou anu ane uxolu no anu puloulou ne. ");
INSERT INTO ata_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Eni talelingenge ta tisa sou lapuloto mo ta Palisaio no anu tuꞌutuꞌumaxu ane sou uxali noxinge xo ngingi ta mitema sou kalakalavoi. Ngingi ngalavusou nganoꞌu mimii tumaꞌu lailaixe ngatounu no xai loxo, mint mo dilu xe kumini la ngakalipalanu sou ngalosou Lataua naꞌu mavulovexasou. Mimii kitukitu no anu Lapuloto noxou Mosesi ngingi ngemulinu laixe. Ia ngingi ngalavusou ngamulinu mii ta tatila lapuloto mulemolu uasi, loxo ꞌiliꞌilixo ane mulapu mo ꞌiliꞌilixo sou alauna xe ꞌilixo sou ngamuxamuxaxu tangengi no anu vaikala noxou Lataua. Anu laixe lexe ngingi xavingengi sou ngamulinu vaivaikala sou lapuloto ane ta tatila muai tei aloxo xavingengi sou ngamulinu ane sou vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ngingi e iengi seleveenu ia ngaꞌoxo lexe ngalosieꞌi ta mitema voteꞌi. Ngingi aloxo itema e mumaisou vuvuu muxolu no anu laꞌilalixu la muxexeenu, io umaisou kameli uxolu no anu laꞌilalixu uasi la mumalukusou. ");
INSERT INTO ata_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Eni talelingenge ta mitema sou lapuloto mo ta Palisaio no anu tuꞌumaxu ane sou uxali noxinge xo ngingi ta mitema sou kalakalavoi. Ngingi ngalavu sou ngaꞌuinu paku mo lakupapa, la ngaꞌuinu no ale no vasimolusi malemalenga. Ia no nano ne nuniꞌu mo ngetaanu laꞌilali ne ngenoꞌu no anu ꞌiliꞌilixo sou pakali xo ngingi ngexavutalangengisi. ");
INSERT INTO ata_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ngingi ta Palisaio ne iengi seleveenu. Lexe ngingi ngamasaxa lexe ngaꞌuinu paku xe lakupapa la ngaꞌuinu tanu no nano mo malemalenga tei xe ukalu la sou ngingi ngaꞌuinu vasimolu no ale. ");
INSERT INTO ata_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Eni talelingenge ta mitema sou lapuloto mo ta Palisaio no anu tuꞌumaxu ane sou uxali noxinge, xo ngingi ta mitema sou kalakalavoi. Ngingi aloxo lulu e mimulaxu lasimeni sou xe mukalu la milulunu kuvo sou no ale no vasimolu la mukea loxo ꞌo, mo laixe sou tamaisousi. Ia no nano no tanu ne muꞌanaꞌana no anu ta mitema misoisoli xinexineꞌi xe mimii nuninuniꞌu. ");
INSERT INTO ata_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","La sou anu iou vilesisi aloxo ngingi ngamulinu ꞌiliꞌilixo mulapu sou ta mitema imaisou no ale no vasimengesi. Ia no nano no tangengi ne, muꞌanaꞌana no anu ꞌiliꞌilixo masumasua xe no anu ꞌilixo sou kalavoi. ");
INSERT INTO ata_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mo eni talelingenge ta tisa sou lapuloto mo ta Palisaio no anu tuꞌumaxu anu sou uxali noxinge xo ngingi ta mitema sou kalakalavoi. Xo ngingi ngaꞌasou lulusiꞌa ta mitema sou palomatana xe ngatokolomonu lulusiꞌa aneꞌi ane miꞌoxonu ꞌilixo mulapu ne laixe. ");
INSERT INTO ata_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mo ngingi ngavikala aloxo ꞌo, male lexe ngingi ngaxolu tatei la umomomo sou ngasuꞌulineꞌi ta ꞌilusulusungengi, sou ngaveꞌaveꞌa ta mitema sou palomatana isoisoli uasi. ");
INSERT INTO ata_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","La sou ngingi mulaa no anangenge lexe ngingi ta ꞌilusulusungengi ane miveꞌaveꞌa ta mitema sou palomatana misoisoli tatei ne. ");
INSERT INTO ata_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ioxe, aloxo ne la ngingi ngalai ngaꞌoxo mo ngasolonu ꞌiliꞌilixo masua noxiꞌa ta ꞌilusulusungengi ne. ");
INSERT INTO ata_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ngingi loxo lasile molosila mo lasile molosila ta ꞌolu. Ngingi ngamomomo sou ngapolopepeenu taxa sou navu a loxovaa? ");
INSERT INTO ata_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aloxo ne la sou eni apalusiꞌa ta mitema sou palomatana xe ta mitema sou lavulavu iloꞌa ta tisa sou lapuloto ineꞌe noxinge. Ia ngingi ngalutu vaxa la ngaveꞌaveꞌa seꞌi isoisoli xe ngailixaꞌa no ovu valautu. Xe seꞌi la ngingi ngapuapuasiꞌa no nano no taasou lalotu noxinge, xe seꞌi la ngingi ngakusaiꞌa no tuala ta tatila noxinge la iꞌume ilai no tuala ta tatila seꞌi vaꞌaxu. ");
INSERT INTO ata_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aloxo ne la sou tuꞌumaxu sou sialuxaꞌa ta mitema mulapu e munixi no lia ꞌo ne utelo noxinge. Usoko noxou Aveli sialuxu ulai uxali noxou Sekalia e Velekia ꞌolu, e ngingi ngevau la musoli muai no taiinu valovalo sou iꞌelaxu mimii, no nano no anu taasou lalotu tatila noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eni avikalangengi manina lexe ulu sou sialuxaꞌa ta mitema mulapu ne, ngingi ta mitema e ngepaa vaimomo ꞌo ngatavulenu. ");
INSERT INTO ata_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iauo, ta mitema ne Ielusalemu ꞌo, ngingi ngeveꞌaveꞌa ta mitema sou palomatana misoisoli mo ta mitema e Lataua mupalusiꞌa mineꞌe la ngeveꞌaveꞌa no anu kulu la misoisoli. Ia alaxu tavuꞌalo misevile eni atovonu sou lexe apitangengi loxo kokoꞌa neniꞌa ipitaneꞌi ta ꞌilie no vivisie laaxu la ngingi ngamasaxa uasi. ");
INSERT INTO ata_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngalomu, iliꞌi la Lataua iou uvaxainge la taasinge mo tualasinge ne uxolu vitanisi. ");
INSERT INTO ata_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eni avikalangengi aloxo ꞌo, usoko vaimomo ꞌo la umomomo sou ngamaisilo la uasi. Ia ulai iliꞌi la ngingi ngavikala lexe, Lataua ualusou anu ane Tila mupalusou muneꞌe ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Xe Iesu muavuti la musuku sou taasou lalotu tatila noxou Lataua, la ta molomolo noxou mineꞌe noxou la mivikalanu sou umaisou taasou lalotu tatila noxou Lataua ilou tanitani. ");
INSERT INTO ata_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngingi ngemaisou tanitani e toxotoxoxaꞌa lailaixe manina ꞌo ne? Eni avikalangengi manina aloxo ꞌo, umomomo sou ieꞌi uvaxau lavoꞌo vile ꞌo ne uvoꞌuvoꞌutulo no lataanu menexu vile uasi, lavolavoꞌo latala ne imamumamulonu ka ipeinu uleꞌelai no lia ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","No mine Iesu mulai mo a uxoxolu no laxaꞌilu ne Olivu, la ta molomolo noxou aneꞌisisi milai noxou, la mitaliꞌisou seꞌisisi vaꞌaxu aloxo ꞌo, “Ioxe navikalanexi. Talu la mimii ane lexe uxali ꞌo, uxali manina sou? Sosovo maꞌia ane uxali tei sou uvikala lamana noxixe no anu voxo ane sou nini naneꞌe xe voxo kaluxusou?” ");
INSERT INTO ata_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Xe Iesu muavuti la mupeletotosiꞌa aloxo ꞌo, “Ngasaxilaꞌinge laixe. Loxo ꞌo io itema vile uneꞌe ukalavoingengi. ");
INSERT INTO ata_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta mitema tavuꞌalo ixali la imoxoꞌu ualasilo, la ivikala lexe, ‘Eni kalisito ano.’ La ikalavoineꞌi tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","No voxo ane ngingi ngalomusiꞌa ta mitema iꞌotoꞌoto ne, la ngaavuavuti mo tangengi kalaua mo ngaꞌume uasi. Anu mimii ane loxo ne anu uxali, ia voxo kaluxusou ne a uao uneneꞌe ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta mitema sou tuala vile iavuti, la ilai ialivulaneꞌi ta mitema sou tuala vile ane vaꞌaxu. Mo ta mitema noxou tatananu tuala vile iavuti, la iloꞌa ta mitema noxou tatananu tuala vile ane vaꞌaxu iꞌoto. Xe no xalexalee tuatuala seꞌi, la laliua ukunikuni mo soli toxoxaꞌa uxali. ");
INSERT INTO ata_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Anu tuꞌutuꞌumaxu ane ne anu soko no anusi, uxali tei loxo sema ixamuli navunavu tei ka sou ivoꞌo ꞌilie. ");
INSERT INTO ata_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mo no voxo ane ne inoꞌinge la ilai ilosinge navunavu mo ivenge ngasoli. Mo ta mitema ukalusi ne imolosilangengi, xo ualasilo a uxolu noxinge. ");
INSERT INTO ata_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","No voxo ane ne la ta mitema tavuꞌalo e mimuxaxu taneꞌi noxilo ne imomomo sou imuxaxu taneꞌi noxilo la uasi. Mo ixiu la ikala tomoxaꞌa ta menexiꞌa ngatongatoꞌo xe imolosilaneꞌi ngatongatoꞌo. ");
INSERT INTO ata_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mo ta mitema sou palomatana kalakalavoi tavuꞌalo ixali la ikalavoineꞌi ta mitema tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mo ꞌiliꞌilixo masumasua ne utila manina mo ꞌilixo sou imasaxaiꞌa ta menexiꞌa ngatongatoꞌo ne usuꞌa. ");
INSERT INTO ata_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ia anu ane utulu pekiaꞌu ulai uxali no anu voxo kaluxu sou la Lataua umomomo sou upamaulinu. ");
INSERT INTO ata_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mo lexe ta mitema latala no lia ukalusi ꞌo ne ilomusou aꞌalo laixe sou saxisaxilaꞌu noxou Lataua ia iaꞌaloxu noxiꞌa ukalu, xe iliꞌi no anu la sou voxo kaluxusou uxali. ");
INSERT INTO ata_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Xe Iesu muavuti la muvikalaneꞌi la aloxo ꞌo. ‘Ngingi ngamaisou mii vile masua manina e itemasou palomatana Danieli muaꞌaloxu taatei lexe, (mii ane ne masua manina anu utulu teitexi no anu tani tila noxou Lataua. Itema ane uitisou vaikala ane ꞌo la uxavutalanu laixe.)’ ");
INSERT INTO ata_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","No voxo ane ne la ta mitema e ixoxolu no xalee lia tila ne Iutaia ne iꞌumeꞌume ilai no laxaꞌilu. ");
INSERT INTO ata_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Itema ane mulai mo ꞌa uxoxolu no taasou kisou ne, umomomo sou uluꞌelai mo uꞌunalai no tani la sou utaxusou mimii seꞌi uuatunu uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mo itema ane mulai no xaixu mo ꞌa uxaxai ne, umomomo sou ulivu ulai no tani mo unoꞌu tokolomou la uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ia ta sema ane opooponeꞌi xe aneꞌi ane isusuneꞌi ta ꞌiliꞌiliꞌa ta keakea ne la anu voxo masua noxiꞌa manina. ");
INSERT INTO ata_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","La sou anu laixe lexe ngingi ngakilaka, mo sou voxo sou ngingi ngaꞌume ne uxali no anu voxo sou laꞌiua xe no voxo tavuna uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Xo no voxo ane ne, anu voxovoxo sou tuꞌutuꞌumaxu manina, umomomo no anu voxo ane tatei Lataua mukoinu xalexalee tuatuala mo utalo vaimomo ꞌo mo iliꞌi la uasi manina. ");
INSERT INTO ata_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ia lexe tila uxoto voxo ane ne ulivu uneꞌe ataxu, la evile umomomo sou umauli uasi. Ia tavaꞌu xo aneꞌi ta mitema ane anu musovosiꞌa lexe anu ta mitema noxou maninasou, la sou anu uxotonu voxo ne uneꞌe ataxu. ");
INSERT INTO ata_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","No voxo ane ne, la evile uvikalangengi aloxo ꞌo. ‘Ngamaisou, Kalisito ano ꞌo! Uasi, uvikala lexe, Ngamaisou anu ꞌa ꞌole!’ Ia mamu sou ngamuxaxutangengi no anu vaikala noxou. ");
INSERT INTO ata_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Xo ta mitema seꞌi ixali, la ikalavoi lexe aneꞌi Kalisito xo aneꞌi ta mitema sou palomatana kalakalavoi. Lexe ixali, la iꞌoxonu sosovo seꞌi toxotoxoxaꞌa uxali mo mimii seꞌi sou ta mitema imaisou la ikuluke no anu kalumo, lexe anu umomomo sou ikalavoineꞌi ta mitema ane Lataua musosovosiꞌa lexe anu ta naꞌu ꞌole. ");
INSERT INTO ata_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lexe ngingi ngamaisou mimii aloxo ne uxali noxinge iliꞌi, la eni evikalangengixu tei. ");
INSERT INTO ata_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","La sou lexe evile uvikalangengi lexe, ‘Kalisito anu a uxolu no ale la nalai no ale uasi, xe uꞌoxo lexe ne anu ꞌa no nano no tani, la ngamuxaxu tangengi no anu vaikala noxou ne uasi.’ ");
INSERT INTO ata_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","La sou Itema ꞌOlu uneꞌe, la anu aloxo leleꞌe ulami no aso uxali la lamixu ulai uxali no aso uluꞌelai la aneꞌi tavuꞌalo imaisou. ");
INSERT INTO ata_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","No anu xalee ane ta mimii misoisoli miai no anu, la ta nenu suluvi ipita sou iꞌou xiasineꞌi. ");
INSERT INTO ata_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ia no voxo ane iliꞌi no anu voxo sou tuꞌutuꞌumaxu ukalu la aso ne uxali isivoxo mo soꞌio ne uiei la uasi, mo ta oto ne ilapalapau teitexi no loxotolo iluꞌe mo ta mimii loxo taꞌumali iloꞌa koiuxaxai mo tavaivolo no opo loxotolo ne ikunikuni. ");
INSERT INTO ata_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","No anu voxo ane ne la ta mitema imaisou sosovo sou Itema ꞌOlu mine ulaa no opo loxotolo la uluꞌe no anu umuumu no anu xavi mo lamana toxoxaꞌa noxou. La ta mitema latala no xalexalee tuatuala ukalusi no lia ꞌo imaisou mine Anu uneꞌe, la aneꞌi itama. ");
INSERT INTO ata_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xe xoolau utama tatila la Anu upalusiꞌa ta angelo noxou sou inoꞌa aneꞌi ane noxou e Anu molu musosovosiꞌa meꞌa no anu atume iou tamiꞌa, xe no xalexalee lia teletelexu ꞌo, ulai utelo no teletelexu loxotolo ukalusi ne ineꞌe ipitaneꞌi. ");
INSERT INTO ata_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Xe Iesu muavuti la muvikalaneꞌi la aloxo ꞌo. Anu laixe lexe ngingi nganoꞌu lavulavu no anu ovu lovo. No voxo ane ovu xolanu uxata xe uxali tatila, la ngingi ngelavu lexe anu voxo laixe sou aso a uxali ꞌalai. ");
INSERT INTO ata_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lexe ngingi ngamaisou mimii ane ne uxali, la anu aloxo nesi. Ngingi ngalavusi lexe voxo sou Itema ꞌOlu ꞌa uneꞌe ne. Anu ꞌa muxali ꞌalai manina ne. ");
INSERT INTO ata_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eni avikalangengi manina aloxo ꞌo, ta mitema sou voxo ano ꞌo ilai uao, ia mimii ane eni elemolu lamana noxinge ne, anu uxali. ");
INSERT INTO ata_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mimii latala teitexi no opo loxotolo mo no lia ꞌo ne, ulai la ukalu. Ia vaivaikala noxilo ne ukalu uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Evile ulavu no anu voxo mo aso iou ne uasi. Ta angelo teitexi no opo loxotolo mo ꞌOlu kalumo ne ilavusou uasi, ia Momu anusisi mulavusou. ");
INSERT INTO ata_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Muamuaꞌi noxou Itema ꞌOlu sou ulivu uneꞌe ne aloxo no anu voxo noxou Noa. ");
INSERT INTO ata_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","No voxo ane alipaa toxoxaꞌa uxali uao la ta mitema mivevelu mo miie xe mitataulaꞌi mulai muneꞌe mulai mutalo no anu voxou e Noa muꞌunalai no lasipi. ");
INSERT INTO ata_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","La aneꞌi ilavusou mii maꞌia ane sou uxali ne uasi, mixolu mixovulaulausi mulai muxali no voxo e alipaa toxoxaꞌa muxali mukulukeneꞌi la mukalusiꞌa. No voxo sou Itema ꞌOlu ulivu uneꞌe la ta mitema iꞌoxoꞌoxonu ꞌiliꞌilixo iou vilesisi aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","No anu voxo ane ne la ta mitema ta tamei iꞌoxoꞌoxo no xai la vile unoꞌu ulai io vile uxolu. ");
INSERT INTO ata_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mo ta sema ta tamei iꞌotuꞌotunu lauele sou lexe iꞌulalu no anu la vile unoꞌe ilai io vile ixolu. ");
INSERT INTO ata_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aloxo ne la sou ngasaxilaꞌinge laixe mo ngautiti laixe, xo ngingi ngalavusou voxo maꞌia ane tila noxinge uneꞌe ne uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mo ngaxavutalanu mimii ne laixe. Lexe moosou tani ulavusou tei lexe ta mitema sou pakali ineꞌe no anu ꞌolovoxo mautunu anevaa, la anu uxolu uloo la sou ta mitema sou pakali ne imomomo sou imamulonu tani la iꞌunalai uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","La sou ngingi kalumo ngalalaxii xo Itema ꞌOlu uneꞌe, la uneꞌe no anu voxo mautunu e ngingi ngexavutala lexe Anu uneꞌe no anu ne, uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mo Iesu musolonu vaivaikala noxou la aloxo ꞌo. Itema sou xaixai anevaa xavutala laixe, la uꞌoxonu xaixai noxou laixe? La tila sou uꞌitalonu sou usaxilaꞌa ta mitema sou xaixai no tani noxou xe ulosiꞌa laꞌilali no anu aso iou e tila sou musosovo sou. ");
INSERT INTO ata_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Itema sou xaixai aloxo ne, anu uꞌosa manina no mine tila sou ulivu uneꞌe xe umaisou lexe anu ꞌa uꞌoxoꞌoxonu xaixai noxou. ");
INSERT INTO ata_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eni avikalangengi manina aloxo ꞌo, tila sou ne usosovosou itema sou xaixai ne la usaxilaꞌu mimii latala noxou ukalusi. ");
INSERT INTO ata_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ia lexe anu itema sou xaixai ne masua la anu tanu uvikala lexe, ‘Tila noxilo ne umomomo sou ulivu uneꞌe palea uasi.’ ");
INSERT INTO ata_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mo uavuti la uveꞌa ta menexu e iloꞌa ixaxai ne xe ulai iloꞌa ta menexu e ilolutu sou iiexu lexa pekiaꞌu la ixovulaulau piena ꞌole iꞌaniꞌani xe iie. ");
INSERT INTO ata_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ioxe tila sou itema sou xaixai ne ulivu uneꞌe la uneꞌe no anu voxo ane anu itema sou xaixai ne uxavutala lexe anu tila sou ne uneꞌe no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ia anu ukuluke noxou tila sou mine uneꞌe xe uxalisou mine uꞌoxoꞌoxonu ꞌiliꞌilixo ne, la anu tila sou ne uꞌoxoo masuanu manina, la ulailixu iloꞌa ta mitema sou kalakalavoi ixolu ipita no anu tuala e itatama xe anaxaꞌa ukalakikiki no anu.” ");
INSERT INTO ata_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Xe Iesu musolonu vaivaikala noxou la, la muvikala aloxo ꞌo, “Saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne aloxo aꞌalosiꞌa ta sema ta vuanga mavulovexa e minoꞌu lalamosiꞌa la milai sou lexe imaisou maulu sou taulaꞌi alavua uxali. ");
INSERT INTO ata_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aneꞌi milai la taꞌuve xavutalaiꞌa laixe, ia taꞌuve ne xavutalaiꞌa laixe uasi. ");
INSERT INTO ata_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aneꞌi ane xavutalaiꞌa laixe uasi ne milutu, la minoꞌu lalamosiꞌasi io inoꞌu lexa sou uasi. ");
INSERT INTO ata_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ia aneꞌi ane xavutalaiꞌa laixe ne milutu la minoꞌu lalamosiꞌa xe minoꞌu lexa sou kalumo. ");
INSERT INTO ata_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Itema e maulu sou taulaꞌi alavua ne uxali palea uasi la ta sema mavulovexa ne ixoxolu xoo mole ieꞌi muvuvu la miaiai. ");
INSERT INTO ata_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ia no ꞌolovoxo lixinu manina, la milomu sou itema vile muꞌava aloxo ꞌo, ‘Itema e maulu sou taulaꞌi alavua anu ꞌa uxali ꞌo! Ngingi nganeꞌe mo nenge taalaxu no voteꞌi, la sou tanoꞌu uneꞌe.’ ");
INSERT INTO ata_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","La sou ta sema ta vuanga ne mitulu la mitoꞌisou lalamosiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","La aneꞌi taꞌuve e xavutalaiꞌa laixe uasi ꞌole miavuti la mivikalaneꞌi aneꞌi ane xavutalaiꞌa laixe lexe, ‘Ngaitisixe lexa sevile mo tanixiꞌu uꞌuna no anu lalamo noxixe xo anu ꞌa ꞌalaꞌalai sou usita.’ ");
INSERT INTO ata_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aneꞌi ane xavutala laixe mikolineꞌi lexe, ‘Uasi, anu umomomo noxinge nengeꞌa uasi, ngalai mo ngalotosinge noxiꞌa ta mitema ane isosovanu lexasou lalamo.’ ");
INSERT INTO ata_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ia no mine aneꞌi milutu sou milai milotosiꞌa lexa la itema e maulu sou taulaꞌi alavua ne muxali. Anu muxali la ta vuanga taꞌuve e milalaxi ne, iloꞌa miꞌunalai no nano no tani sou laꞌilali toxoxaꞌa sou taulaꞌi alavua ne. Aneꞌi miꞌunalai mukalu la aitenga mutatu. ");
INSERT INTO ata_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Iliꞌi la ta sema ta vuanga taꞌuve ꞌole mixalixali. Aneꞌi mineꞌe mixali la miꞌava muꞌunalai lexe, ‘Tila, tila nakisiinu aitenga mo nexi taꞌuna.’ ");
INSERT INTO ata_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Xe anu muavuti la mukolineꞌi aloxo ꞌo, ‘Eni avikalangengi manina lexe eni alavusinge uasi.’ ");
INSERT INTO ata_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aloxo ne la sou ngasaxilaꞌinge mo ngaloo laixe xo ngingi ngalavusou voxo ngiou ilou aso iou uasi. ");
INSERT INTO ata_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mo saxisaxilaꞌu noxou Lataua teitexi no opo loxotolo ne aloxo ꞌo, itema vile mulutu sou mulai lexe ulai no tuala vile no paxa. La muꞌavaliꞌa ta mitema sou xaixai noxou mineꞌe la muitalonu mimii noxou noxiꞌa sou isaxilaꞌu. ");
INSERT INTO ata_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anu mulosou vile tiva sou xoulu taꞌuve, xe vile mulosou tiva sou xoulu ta tamei xe vile la mulosou tiva sou xoulu vile. Anu mulosiꞌa aloxo ne mumomomo no anu xavineꞌi vilevilesi. Ia anu mulutu la mulai. ");
INSERT INTO ata_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Xe ane mulosou tiva sou xoulu taꞌuve ne, mulutu alaxu vilesisi ꞌo la mulai sou muxaxai sou lamoli ne la munoꞌu tiva sou xoulu ne taꞌuve la. ");
INSERT INTO ata_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mo ane munoꞌu tiva sou xoulu ta tamei ne mulai la muꞌoxonu aloxo ne kalumo la munoꞌu tiva sou xoulu ta tamei la. ");
INSERT INTO ata_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ia ane munoꞌu tiva sou xoulu vilesisi ne mulai la muꞌasou taxa xe mukalu la muꞌasixu lamoli noxou tilasou ne mutalumeiou la muaai ne. ");
INSERT INTO ata_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tilasiꞌa ne mulai muxoxolu ne maxuveeni xe mukalu la anu mulivu muneꞌe. Anu muneꞌe sou lexe iloꞌa ta mitema sou xaixai noxou ne imomomo sou vaikala sou lamoli e anu mulosiꞌa lexe ixaxaisou ne. ");
INSERT INTO ata_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","La sou itema e munoꞌu tiva sou xoulu taꞌuve ne mulai la munoꞌu tiva sou xoulu taꞌuve la muneꞌenu noxou tilasou. La muvikalanu aloxo ꞌo, ‘Tila nini nelosilo tiva sou xoulu taꞌuve, ia namaisou eni exaxaisou la enoꞌu tiva taꞌuve la ano.’ ");
INSERT INTO ata_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Xe tilasou muavuti la muvikalanu lexe, ‘Nini itemasou xaixai laixe mo neꞌoxonu xaixai noxine laixe manina. Xe nini neꞌoxonu xaixai laixe xe nesaxilaꞌu mii kituꞌa laixe la sou eni aꞌoxoneni nasaxilaꞌu mimii tavuꞌalo ꞌo xe naneꞌe mo nengei taꞌosa.’ ");
INSERT INTO ata_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mo itema ane munoꞌu tiva sou xoulu ta tamei ne muneꞌe kalumo, la muvikalanu tilasou lexe, ‘Tila namaisou, nini nelosilo tiva sou xoulu ta tamei ia eni exaxaisou, la enoꞌu tiva ta tamei la ano.’ ");
INSERT INTO ata_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","La tila noxou muvikalanu lexe, ‘Nini itemasou xaixai laixe mo neꞌoxonu xaixai noxine laixe manina. Xo nini neꞌoxonu xaixai laixe mo nesaxilaꞌu mii kituꞌa eni elosine, la sou eni aꞌoxoneni nasaxilaꞌu mimii tavuꞌalo ꞌo. Xe naneꞌe mo nengei taꞌosa.’ ");
INSERT INTO ata_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Xe itema ane munoꞌu tiva sou xoulu vile ne muneꞌe kalumo la muvikalanu tilasou lexe, ‘Eni elavusine lexe nini itema laꞌia, mo nalavusou nalai la nakokoli laꞌilali no anu xai e nini netounu uasi, nalai nakokoli no anu xai e ta mitema vaꞌaxu mitounu, xe nataxusou laꞌilali ane ta mitema vaꞌaxu misuꞌanu la muleme. ");
INSERT INTO ata_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aloxo ne la sou eni eꞌume noxine la elai eꞌasixu tiva sou xoulu noxine e nelosilo. La sou namaisou lamolimeni e nelosilo ano ꞌo.’ ");
INSERT INTO ata_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Xe tilasou muavuti la muvikalanu aloxo ꞌo, ‘Nini itema sou xaixai ne pauxesine manina xe namitema sou xaixai masua. Lexe nini nelavusou lexe eni alavusou akokoli no anu xai e eni atounu uasi xe ataxusou laꞌilali e ta mitema vaꞌaxu misuꞌanu la muleme. ");
INSERT INTO ata_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","La sou anu laixe lexe nini namulaxu lamolixeni no taasou lamoli mo sou eni alivu aneꞌe la anoꞌu ilou xolanu.’ ");
INSERT INTO ata_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mukalu la sou anu muvikalaneꞌi aneꞌi ane itulutulu no paꞌumolu aloxo ꞌo, ‘Ngaꞌumenu tiva sou xoulu vilesisi ane noxou ne, mo ngalosou itema ane muxalixu tiva sou xoulu mavulovexa.’ ");
INSERT INTO ata_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","La sou anu muvikalaneꞌi aloxo, eni avikalangengi aloxo ꞌo, ta mitema ane minoꞌu mimii seꞌi xe ixaxaisou laixe, la Lataua ulosiꞌa moseꞌi la, xe aneꞌi ane inoꞌu mii sevile kutuꞌasi ia ixaxaisou laixe uasi la Lataua a uxexeenu avile. ");
INSERT INTO ata_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ia ngingi nganoꞌu itemasou xaixai masua ne mo ngaleanu ulai no ale no usivoxo, noxiꞌa aneꞌi ane itatama mo anaxaꞌa ukalakiki. ");
INSERT INTO ata_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","No voxo ane Itema ꞌOlu ulivu uneꞌe loxo tatananu tuala, xe iloꞌa ta angelo noxou ineꞌe, la anu uxolu no anu puloulou noxou loxo anu tatananu tuala ane teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","La ta mitema latala no xalee tuatuala ukalusi ineꞌe ipita no talaxu, la sou Anu ukalipalaneꞌi xulumuxaꞌa tamei loxo itema sou usaxilaꞌa ta sipsip ukalipalaneꞌi ta sipsip ilai xalee vile xe ta mee ilai ipita no xalee vile. ");
INSERT INTO ata_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Anu ukalipalaneꞌi ta sipsip ilai no avolu tema, xe ta mee ilai no avolu ae. ");
INSERT INTO ata_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Xe tatananu tuala uavuti la uvikalaneꞌi aneꞌi ane mixolu no avolu tema aloxo ꞌo, ‘Ngingi nganeꞌe, xo Mamilo mualusinge, mo musosovosinge sou ngaunalai no anu saxisaxilaꞌu noxou tei no mine Anu usokou sou ukoinu xalexalee tuatuala no lia ꞌo uao. ");
INSERT INTO ata_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Xo eni esolixo la ngingi ngelosilo laꞌilali sou eꞌou mo esoliu lexa, la ngelosilo lexa sou eiexu, xe exali loxo aasila la ngingi ngeꞌavalilo elai no tani noxinge. ");
INSERT INTO ata_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mo eni xeni tokolomo uasi, la ngingi ngelosilo mo no voxo eni epipiena la ngingi ngeneꞌe sou ngesaxilailo xe exolu no tani sou navunavu la ngingi ngeneꞌe ngemaisilo.’ ");
INSERT INTO ata_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Xe aneꞌi ta mitema ane milapu ne miavuti la mitaliꞌisou lexe, ‘Ia tila, nexi tamaisine ne solixene la telosine laꞌilali xe nesoliu lexa la telosine neiexu ne ꞌa taalu? ");
INSERT INTO ata_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mo nexali loxo aasila la teꞌavaline neneꞌe no tani noxixe xe meni tokolomo uasi la nexi telosine ne ꞌa taalu? ");
INSERT INTO ata_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mo nexolu no tani sou pipiena la nexi tesaxilaꞌine xe nexolu no tani sou navunavu la nexi telai temaisine ne ꞌa taalu?’ ");
INSERT INTO ata_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","La anu tatananu tuala ne mukolineꞌi aloxo ꞌo, ‘Eni avikalangengi manina aloxo ꞌo, lexe ngingi ngaꞌoxonu aloxo ne ulai noxou vivilo vile e ualasou uasi, la ngingi ngeꞌoxonu noxilo ane.’ ");
INSERT INTO ata_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Xe anu muavuti la muvikalaneꞌi aneꞌi ane mixolu no avolu ae lexe, ‘Ngingi ane ꞌo sou ngaulua. Ngaꞌume mo ngaxexesilo, mo ngalai no anu navu e uaniani la kaluxu uasi. Navu ne milalaxiinusiꞌa Satani iloꞌa ta angelo noxou. ");
INSERT INTO ata_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Xo eni esolixo la ngingi ngalosilo mii vile sou aꞌou uasi. Xe esoliu lexa la ngingi ngalosilo mo aiexu uasi. ");
INSERT INTO ata_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mo eni exali loxo aasila la ngingi ngaꞌavalilo ulai no tani noxinge uasi xe enixeni tokolomo uasi la ngingi ngalosilo uasi. Mo eni exolu no tani sou pipiena la ngingi nganeꞌe ngasaxilaꞌilo uasi xe exolu no tani sou navunavu la ngingi nganeꞌe ngamaisilo uasi.’ ");
INSERT INTO ata_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","La aneꞌi kalumo mitaliꞌisou lexe, ‘Ia tila nexi temaisine, nesolixene mo nesoliu lexa mo nexolu loxo aasila, xe meni tokolomo uasi mo nepipiena xe nexolu no tani sou navunavu la nexi tasuꞌulineꞌi uasi ꞌa talu?’ ");
INSERT INTO ata_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","La Anu mukolineꞌi aloxo ꞌo, ‘Lexe ngingi ngaꞌoxonu aloxo ne uasi noxou vile noxiꞌa aneꞌi ane ualasiꞌa uasi la ngingi ngeꞌoxonu noxilo.’ ");
INSERT INTO ata_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aloxo ne la sou aneꞌi ane ne ilai ixolu no anu tuala sou navunavu e navu uꞌaniꞌani la kaluxu uasi ꞌole. Ia aneꞌi ane milapu ilai ixolu no tuala e mauli kaluxu uasi manina ꞌole.” ");
INSERT INTO ata_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","No mine Iesu muvikala mukalu la muvikalaneꞌi ta molomolo noxou aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ngingi ngelavusou lexe voxo tamei siꞌa uxolu sou nenge tasosovosou voxo e Lataua mupolopepeneꞌi ta Isilaeli, la inoꞌu Itema ꞌOlu ilailixu no avoꞌa ta mitema sou ivau usoli.” ");
INSERT INTO ata_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","La ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatilasiꞌa ta Isilaeli mipita no tani tatila noxou kisiꞌa ta ailiꞌi ualasou lexe Kaiapasi, ");
INSERT INTO ata_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sou ikamuli voteꞌi sou lexe itetelisou lesu mo ivau usoli a loxo vaa. ");
INSERT INTO ata_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aneꞌi miavuti la mivikala lexe, “Maasi la nenge taꞌoxonu mii e nenge tevivikalasou ꞌo no nixi no anu voxo tila ꞌo uasi. Xo loxo ꞌo io ta mitema imaisinge, la iavutinoxu ꞌotoꞌoto toxoxaꞌa.” ");
INSERT INTO ata_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","No mine Iesu muxolu ne Vetania la mulai muꞌunalai no tani noxou itema vile ualasou lexe Saimoni. Anu Saimoni ne vulukali muꞌoxonu tei. ");
INSERT INTO ata_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iesu muꞌunalai mo mutalupexa sou lexe uꞌani. Ia sema vile minoꞌu lavotoli sou ueli e tumaꞌu lailaixe vile ne lamoli sou tila misevile. Ane minoꞌu xe milai mixali noxou Iesu, la mixolaꞌu anaxu ka minixiꞌu no kisou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ia no mine ta molomolo noxou mimaisie aloxo ne, la aneꞌi laꞌiaxaꞌa, la mivikalaneꞌi ngatongatoꞌo lexe “Tavaꞌu loxovaa ane sema ꞌo ivilaꞌisou ueli e tumaꞌu lailaixe loxo ꞌo? ");
INSERT INTO ata_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Lexe uaisi mo sou tasovanu, la ilotonu no anu lamoli tatila manina, la sou tanoꞌu la taitiꞌa ta mitema ane iꞌa mimii uasi.” ");
INSERT INTO ata_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aneꞌi mivivikalaneꞌi ngatongatoꞌo aloxo ne, la Iesu mulavusou la muvikalaneꞌi aloxo ꞌo, “Iengi uvaxaiesi, loxovaa ane ngingi ngalosie tuꞌumaxu ane loxo ne? Mii e ane miꞌoxonu muneꞌe noxilo ne, ane miꞌoxonu laixe misevile. ");
INSERT INTO ata_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ta mitema ane iꞌa mimii uasi ne, anu voxovoxo piepiena ꞌa uxoxolu sou ngingi ngaitiꞌa mimii loxo ngemasaxau, xo ngingi ngongiꞌa ngaxoxolu. Ia eni ne nenge nengeꞌa taxoxolu utotomu uasi. ");
INSERT INTO ata_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ane minixiꞌu ueli e tumaꞌu lailaixe no vasimelo tei loxo ne, sou ulalaxiinu vasimelo sou ulai no lulu. ");
INSERT INTO ata_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eni avikalangengi manina aloxo ꞌo. No xalexalee tuatuala neꞌi ne, lexe ilai iaꞌaloxu aꞌalo laixe, la mii e ane miꞌoxonu ꞌo ne, aneꞌi iaꞌaloxu kalumo sou ixavutalane.” ");
INSERT INTO ata_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Xe Iudasi Isikarioti, anu vile noxiꞌa ta molomolou mavulovexa mo mulelia tamei ne, muavuti la mulai muxali noxiꞌa ta tatilasiꞌa ta ailiꞌi, la mutaliꞌisiꞌa aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Lexe eni aꞌitalonu Iesu ulai no avonge, la ngingi ngalosilo maꞌia?” Xe aneꞌi miavuti la miitisou lamoli siliva muxali loxo mavulovexa tatalu la milosou. ");
INSERT INTO ata_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","La sou Iudasi muavuti sou ukamuli voteꞌi sou uꞌitalonu Iesu no avoꞌa. ");
INSERT INTO ata_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Voxo vile sou veleti imulaxu isi sou uasi ꞌa muxali, la ta molomolo noxou Iesu mineꞌe noxou la mitaliꞌisou lexe, “Nini nemasaxa lexe nexi talalaxii laꞌilalixene sou voxo sou Lataua Mupolopepeneꞌi ta Isilaeli ꞌava?” ");
INSERT INTO ata_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","La Iesu muvikalaneꞌixu itema vile, la sou mupalusiꞌa lexe, “Ngalai no nano no tuala tila ne Ielusalemu xe ngamaisou itema e epelaꞌingexu ne la ngavikalanu lexe, ‘Tisa muꞌoxo lexe voxo noxilo ꞌa muxali ꞌalai. La sou nexi noxiꞌa ta molomolo noxilo taꞌani laꞌilali sou ta sosovosou voxo sou Lataua Mupolopepeneꞌi ta Isilaeli no tani noxine.’” ");
INSERT INTO ata_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","La sou ta molomolo noxou Iesu miꞌoxonu aloxo Anu mupelaꞌaxu ne sou milalaxiinu laꞌilali sou ixavutalanu voxo sou Lataua Mupolopepeneꞌi ta Isilaeli. ");
INSERT INTO ata_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Xe no ꞌoloꞌolovoxo la Iesu iloꞌa ta molomolo noxou mavulovexa mo mulelia tamei ne milai mixolu mipita sou iꞌani. ");
INSERT INTO ata_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","No mine aneꞌi iꞌaniꞌani, la Iesu muvikalaneꞌi aloxo ꞌo, “Eni avikalangengi aloxo ꞌo, vile no nixi noxinge ne, ulai la anu uꞌitaloleli ulai no avoꞌa ta mitema sou ꞌotoꞌoto.” ");
INSERT INTO ata_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xe aneꞌi milomu aloxo ne, la oponeꞌi tuꞌumaxu la sou aneꞌi vilevilesi miavuti la mitaliꞌisou aloxo ꞌo, “Tila male eni uasi ne?” ");
INSERT INTO ata_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Xe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Anu ane loxo nexi noxou taꞌuinu laꞌilali no anu lisi vilesisi, la anu moosou e sou uꞌitaloleli no avoꞌa ta mitema ane. ");
INSERT INTO ata_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Itema ꞌOlu ne, ulaisi mo uulua aloxo vaivaikalasou mikaukavunu no anu Lavuku Tavuna teinu. Ia itema e uitalonu itema ꞌolu ulai noxiꞌa ta mitema avoꞌa ne usaxilaꞌu no anu tuꞌutuꞌumaxu. Anu laixe lexe nenu ivoꞌonu uasi, la anu laixesi.” ");
INSERT INTO ata_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Xe Iudasi itema e sou uꞌitalonu Iesu no avoꞌa ta mitema ne muavuti, la muvikalanu Iesu aloxo ꞌo. “Tila male eni ne?” La Iesu mukolinu lexe, “Ani, ninisi.” ");
INSERT INTO ata_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","No mine aneꞌi iloꞌa iꞌaniꞌani la Iesu mukasi muluꞌe no anu veleti la munoꞌu sou muvikala laixe musuku noxou Lataua, xe mukalu, la museꞌiseꞌinu sou mulosiꞌa ta molomolo noxou vilevilesi la muvikalaneꞌi aloxo ꞌo, “Nganoꞌu mo ngaꞌou, anu vasimelo ane.” ");
INSERT INTO ata_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Xe muavuti la mukasi vaxa no anu lisi sou uaini, la muvikala laixe musuku noxou Lataua. Xe mukalu la mulosiꞌa la muvikalaneꞌi aloxo ꞌo, “Ngingi latala ne ngaiexu.” ");
INSERT INTO ata_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mo muvikalaneꞌi la aloxo ꞌo, “Sialuxo ano ꞌo. Eni asoli xe sialuxo unixi, la anu uꞌoxonu vaikala e nenge nengeꞌa Lataua tesakii ꞌo, uxali manina. Sialuxo ꞌo ne, sou unixisiꞌa ta mitema tavuꞌalo sou upamaulineꞌi xe uxexeenu ꞌiliꞌilixo masumasua noxiꞌa.” ");
INSERT INTO ata_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","La muvikalaneꞌi la aloxo ꞌo, “Eni avikalangengi manina. Umomomo sou eni aie la no anu uaini temanu la uasi, ulai utalo no voxo ane sou nenge nengeꞌa taiexu ane alavua no tuala teitexi noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Xe iloꞌa miꞌani mukalu la milexe lexe vile sou milaa milai no laxaꞌilu ne Olivu. ");
INSERT INTO ata_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iloꞌa milai xoo la Iesu muvikalaneꞌi aloxo ꞌo la, “Maasi no ꞌolovoxo ꞌo, la ngingi latala ꞌo ne, ngaꞌumesilo ukalusi. Xo mikaukavunu vaikala vile muxolu no anu Lavuku Tavuna teinu aloxo ꞌo, ‘Ulai la eni avau itema sou usaxilaꞌa ta sipsip la aneꞌi ta sipsip ne iꞌume ipeilaꞌu tani.’ ");
INSERT INTO ata_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ia iliꞌi, eni atulu sou amauli, la eni auli alai ne Xalilaia.” ");
INSERT INTO ata_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Xe Pita muavuti la muvikalanu lexe, “Ulai la aneꞌi latala ꞌo ne iꞌumeꞌume ukalusi, ia eni ne uasi.” ");
INSERT INTO ata_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Xe Iesu muavuti la mukolinu vaikala noxou lexe, “Eni avikalaneni manina aloxo ꞌo, maasi no ꞌolovoxo ꞌo la kokoꞌa uꞌava uao, ia nini nasingisilo alaxu tatalu lexe nalavusilo uasi.” ");
INSERT INTO ata_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","La Pita ne mutotoiti manina. Xe muavuti la muvikala pekiaꞌu lexe, “Eni umomomo sou asingisine lexe eni alavusine uasi, uasi xo nenge nengei tasoli takei.” Mo Pita ta menexu ne mivikala kalumo aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iloꞌa mimuamuaꞌi xe mixali no lia xalee ilemolu lexe Xetesemane, la Iesu muvikalaneꞌi ta molomolo noxou lexe, “Ngaxoxolu ꞌo ia eni alai mo akilaka.” ");
INSERT INTO ata_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xe Anu muavuti la munoꞌa Pita iloꞌa Sevetaio ta ꞌolu tamei sou iloꞌa milai. Iloꞌa milutu xe milai la Anu tanulili xe opo tuꞌumaxu manina. ");
INSERT INTO ata_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","La muvikalaneꞌi aneꞌi tatalu ne aloxo ꞌo, “Ngaxoxolu ano mo ngautiti laixe. Xo eni opoleli tuꞌumaxu manina mo eni ꞌa ꞌalaꞌalai sou asoli.” ");
INSERT INTO ata_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Musuku mulai vaꞌaxu sevile mukalu, la sou mutangatulu muluꞌelai no lia sou mukilaka. Mukilaka la muvikala lexe, “Mamilo mimii latala ne, pekiaꞌu noxine sou naꞌoxonu uasi. La sou eni emasaxa lexe naxexeenu soli noxilo ꞌo uxexesilo. Mo namulinu masaxa noxilo uasi, ia namulinu masaxa noxinesi.” ");
INSERT INTO ata_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Anu mukilaka mukalu xe mulivu mulai noxiꞌa ta molomolo noxou tatalu ne, la aneꞌi a iaai. Xe muavuti la muvikalanu Pita aloxo ꞌo, “Loxovaa ngingi ngongiꞌa ta menexine umomomo sou ngaxolu mo ngautiti utalo loxo aso iou taiinu vile uasi? ");
INSERT INTO ata_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ngingi ngaxoxolu mo ngautiti mo ngakilaka, mo sou tovotovo uxali noxinge la utaloxolingenge uasi. Manina musuku, itema uleenu umasaxa lexe uxaxai ia vasimolu ne pekiaꞌu uasi, mamalaxusi.” ");
INSERT INTO ata_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesu muvikalaneꞌi aloxo ne xe mukalu, la mulivu mulai la sou mukilaka alaxu tameisou. Mulai la mukilaka aloxo ꞌo, “Mamilo mimii latala ne, pekiaꞌu noxine sou naꞌoxonu uasi. La sou eni emasaxa lexe naxexeenu soli noxilo ꞌo uxexesilo. Lexe nini nemasaxa lexe eni alai asoli la anu mivile uasi, eni amulinu masaxa noxinesi.” ");
INSERT INTO ata_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Xe mulivu muneꞌe, la mumaisiꞌa ta molomolo noxou tatalu ne aneꞌi a iaai sio, xo ieꞌi uvuvusio. ");
INSERT INTO ata_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","La sou Anu muꞌumesiꞌa miai ne ia Anu mulivu mulai la, sou mukilaka alaxu tatalusou. La mukilaka aloxo tei ne la. ");
INSERT INTO ata_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Anu mukilaka alaxu tatalusou mukalu xe mulivu muneꞌe la mumaisiꞌa aneꞌi a iaai sio. Xe muavuti la mutaliꞌisiꞌa lexe, “Ngingi a ngamaꞌila mo ngaai sio? Mumomomo aloxo ne! Xo voxo a muxali. Ngamaisou! Aneꞌi ta mitema sou iꞌitalonu Itema ꞌOlu no avoꞌa ta mitema sou susu a ꞌalaꞌalai sou ixali ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","La sou ngatulu mo nengeꞌa talai. Ngamaisou! Itema e uꞌitaloleli no avoꞌa ta mitema ne, anu a uxali ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu uvivikala ꞌo, ia alaxu vilesisi ꞌo, la Iudasi muneꞌe noxou. Anu vile noxiꞌa ta molomolou noxou mavulovexa mulelia tamei. Anu iloꞌa ta mitema tavuꞌalo mixali, ia ta mitema ne mitetelisou viso ilou kuluvololou. Ta mitema e mineꞌe ne, ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatilasiꞌa ta mitema mipalusiꞌa mineꞌe. ");
INSERT INTO ata_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Itema e muꞌitalonu Iesu no avoꞌa ta mitema ne, muvikalaneꞌixu sosovo vile tei aloxo ꞌo, “Lexe eni alai atimu no xaleenu, la Anu ane, ngatetelisou.” ");
INSERT INTO ata_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ioxe, Iudasi muxali la mulai alaxu vilesisi noxou. La muvikalanu lexe, “Tila! laixenenisi.” La sou mutimu no xaleenu. ");
INSERT INTO ata_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xe Iesu muavuti la muvikalanu aloxo ꞌo, “Menexilo, mii maꞌia ane nini namasaxa lexe naꞌoxonu.” Xe ta mitema ne mimaisou Iudasi mine mutimu no xaleenu, la sou aneꞌi mikasi vaxa no avolu sou mitetelisou. ");
INSERT INTO ata_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","La itema vile mututulu ꞌalai noxou Iesu ne muavuti la mulavee viso ka muvali vaxa no sangalou itema sou xaixai noxou kisiꞌa ta ailiꞌi. La sangalou ne muxoto la mulapau mulai no lia. ");
INSERT INTO ata_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Xe Iesu muavuti la muvikalanu aloxo ꞌo, “Nanoꞌu lavisomeni mo namulaxu no tanixu. Xo aneꞌi e iꞌoto no anu viso la isoli no anu viso. ");
INSERT INTO ata_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Male nini nalavusou uasi ne? Eni emomomo sou aꞌava ulai noxou Mamilo, la Anu upalusiꞌa ta angelo noxou ne ineꞌe alaxu vilesisi. Ta angelo ne itiitisiꞌa uaꞌulixaꞌa ta mitema sou ꞌotoꞌoto xulumuxaꞌa mavulovexa mulelia tamei. ");
INSERT INTO ata_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ia lexe eni aꞌoxonu aloxo ne, la vaikala e muxolu no anu Lavuku Tavuna teinu ne umomomo sou uxali manina uasi. Xo lavuku noxou Lataua ne muvikala lexe, mimii ane ne anu uxali la uxali manina.” ");
INSERT INTO ata_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Xe Iesu muxiu la muvikalaneꞌi ta mitema e mineꞌe sou itetelisou ne aloxo ꞌo, “Ngingi ngenoꞌu viso ilou kuluvololou sou ngeneꞌe sou ngatetelisilo xo eni amitema sou aavutilixu ꞌotoꞌoto? No voxovoxo nengeꞌa texoxolu no taasou lalotu tatila noxou Lataua sou elosiꞌa ta mitema lavulavu la ngingi nganava la ngatetelisilo no voxo ane ne ua? ");
INSERT INTO ata_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ia anu mii vile uasi. Mimii ne anu uxali sou umomosou vaikala noxiꞌa ta mitema sou palomatana mikaukavunu.” La ta molomolo noxou Iesu miꞌume la milailai. ");
INSERT INTO ata_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Xe iliꞌi la aneꞌi ane mitetelisou Iesu ne, milailixu noxou Kaiapasi anu kisiꞌa ta ailiꞌi. La ta tisa sou lapuloto iloꞌa ta tatila latala a ipita ixoxolu ne. ");
INSERT INTO ata_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ia Pita mumulinu Iesu muiliꞌi no paxa. Xe mulai muxali, la muꞌunalai avile no nano no vimelu sou tani noxou kisiꞌa ta ailiꞌi ne. Anu muꞌunalai, la iloꞌa ta mitema sou isaxilaꞌu tani mixolu sou lexe umaisou mii maꞌia iꞌoxonu noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","La ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatila sou imomomosou tuꞌutuꞌumaxu noxiꞌa ta mitema latala ne, ikalavoi sou Iesu no anu vaikala moseꞌi mo ikamuli susu noxou Iesu sou lexe ivau usoli. ");
INSERT INTO ata_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ta mitema tavuꞌalo mitelo vaikala noxou, ia vaikalaiꞌa ne manina uasi. Mo ixalisou susu vile noxou mumomomo sou ivau usoli uasi. Ia iliꞌi manina la ta mitema tamei mineꞌe la mitulu iliꞌi no tumaliꞌa sou mivikala. ");
INSERT INTO ata_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ia mivikala lexe, “Nexi telomusou itema ꞌo muvikala lexe, ‘Eni amomomo sou akisilalanu tani tila noxou Lataua, ia voxo tatalusou la eni atulusou ulivu la.’” ");
INSERT INTO ata_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ioxe, kisiꞌa ta ailiꞌi muavuti mutulu, la mutaliꞌisou Iesu aloxo ꞌo, “Nini namasaxa nakolinu vaikala ane aneꞌi mitelonu noxine ne uasi? Nini nexavutala a loxovaa no anu vaikala ane aneꞌi mitelonu noxine ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","La Iesu mutaloxaꞌasi. Ia ukolinu vaikalaiꞌa vile uasi. Xe kisiꞌa ta ailiꞌi muavuti la muvikalanu aloxo ꞌo, “Eni alingaine no ualasou Lataua anu mauli no anu aloxo ꞌo. Lexe nini Kalisito, Lataua ꞌOlu, la nini navikalanexi.” ");
INSERT INTO ata_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","La Iesu mukolinu lexe, “Ani, anu aloxo nini nelemolu ne. Ia eni avikalangengi latala ꞌo aloxo ꞌo, iliꞌi la ngingi ngamaisou Itema ꞌOlu mine uxolu uvaꞌisaꞌinu Lataua xavinu musuku. Ngingi ngamaisou mine Anu uxolu no paꞌumolu no avolu tema la uneꞌe no anu umuumu molu teitexi no opo loxotolo uluꞌe.” ");
INSERT INTO ata_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Anu mulomusou Iesu muvikala aloxo ne la mukakanu tokolomou xo anu laꞌiaxu. Xe muavuti la muvikala lexe, “Ngamaisou, ngingi ngelomusou ne. Itema ꞌo anu muvikala masua mulai noxou Lataua, la sou nenge tataliꞌisiꞌa ta mitema seꞌi la sou ipalaꞌalixu susu noxou la uasi. ");
INSERT INTO ata_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","La sou ngingi ngexavutala a loxovaa? Nenge taꞌoxonu mii maꞌia noxou?” Xe aneꞌi miavuti la mikolinu lexe, “Anu mususu ane, mo Anu mumomomo sou usolisi.” ");
INSERT INTO ata_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Xe miavuti la mituve vaxa no iou xe mivau, xe seꞌi misavasavalou. ");
INSERT INTO ata_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","La mivikalanu lexe, “Ioxe nini Kalisito, la nalemolu ꞌei ane muvene ne?” ");
INSERT INTO ata_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ta mitema miꞌoxoꞌoxonu Iesu aloxo ne, la Pita ne anu a muxolu no nano no vimelu sou tani ne, la sema sou xaixai vile noxou kisiꞌa ta ailiꞌi ne mineꞌe noxou la mivikalanu lexe. “Nini kalumo ngingi ngongou Iesu sie Xalilaia ngexolu ane.” ");
INSERT INTO ata_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ia anu musingisou no ieꞌi latala ne lexe, “Eni alavusou mii maꞌia e nini nalelemolu ne uasi.” ");
INSERT INTO ata_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Anu muvikala aloxo ne mukalu, la mulaa no aitengaxu tani sou mulai no ale. Xe sema sou xaixai vile la mimaisou, la mivikalaneꞌi aneꞌi ane itutulu ꞌalai noxou ne lexe, “Itema ane ꞌo, anu ilou Iesu sie Naseleti ane.” ");
INSERT INTO ata_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","La anu musingisou la lexe, “Manina teitexi, eni alavusou itema ne uasi.” ");
INSERT INTO ata_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mixolu sevile kituꞌa, la ta mitema e ane mitulutulu ꞌalai noxou ne, mineꞌe noxou la mivikalanu lexe, “Manina, nini vile noxiꞌa ane, xo xolineni molu mupalalixene.” ");
INSERT INTO ata_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ioxe, Pita muavuti la muvikala pekiaꞌu aloxo ꞌo, “Manina teitexi, eni alavusou itema e ngingi ngelelemolu ne uasisi manina. Lexe eni akalavoingengi la laixe lexe Lataua ukalusilo.” Anu muvikala aloxo ne xe mukalu la alaxu vilesisi ꞌo la kokoꞌa muꞌava. ");
INSERT INTO ata_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","La Pita muxavutalanu vaikala noxou Iesu e muvikalanu lexe, “Maasi no ꞌolovoxo ꞌo, la kokoꞌa uꞌava uao, ia nini nasingisilo alaxu tatalu lexe nini nalavusilo uasi.” La Pita mutaloxu iii sou mutama mulai no ale. ");
INSERT INTO ata_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Xe iliꞌi no kakau manina, la ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatilasiꞌa ta mitema mipita sou mipotoxu Iesu. Xe mukalu la sou misakiinu vaikala lexe ivau usoli. ");
INSERT INTO ata_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","La sou aneꞌi misakisakiinu la milailixu no avolu Pilato anu tila noxiꞌa ta Romu. ");
INSERT INTO ata_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Xe no mine Iudasi anu itema e muꞌitalonu Iesu no avoꞌa ta mitema sou ivau mumaisou Iesu mine aneꞌi mitulusou no anu vaivaikala sou iꞌoxo masuanu, la anu muxiunu xavutalau. La munoꞌu lamoli siliva mavulovexa tatalu sou mulivunoxu mulai noxiꞌa ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatilasiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mulai muxali la muvikalaneꞌi lexe, “Manina eni eꞌoxonu masua noxou itema mulapu ꞌo la elailixu sou sialuxu unixi, la Anu uꞌoxonu susu vile uasi.” Xe aneꞌi miavuti la mikolinu lexe, “La sou anu mii maꞌia noxixe? Aneꞌi mikolinu lexe, anu mii noxine.” ");
INSERT INTO ata_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","La sou Iudasi muavuti la mupeinu lamoli ne muꞌunalai no nano no taasou lalotu tatila noxou Lataua, ia muꞌume mulai sou muꞌalili ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Xe iliꞌi la ta kisiꞌa ta ailiꞌi mitaxusou lamoli ne la mivikala lexe, “Lamoli ano ꞌo ne tamuxaxu ilou lamolisou tani tila noxou Lataua uasi xo anu lamoli ane ꞌo ne nenge tenoꞌu sou ꞌulusou ivau itema usoli.” ");
INSERT INTO ata_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La sou aneꞌi misakiinu vaikala lexe lamoli ne, aneꞌi ilotonu lia xalee vile noxiꞌa ta mitema e ilavusou iꞌoxonu lasopeni no anu. Xo aneꞌi imasaxa lexe lia ne uxolu sou iasixaꞌa taasila no anu. ");
INSERT INTO ata_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tavaꞌu aloxo ne la sou lia xalee ane ne aneꞌi ilemolu lexe, “Lia sou sialu no voxo vaimomo.” ");
INSERT INTO ata_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aloxo ne sou anu umomomo sou mii maꞌia ane itema sou palomatana Elemia mulemolu tei, muvikala lexe, “La sou aneꞌi inoꞌu lamoli miꞌoxonu no anu siliva mavulovexa tatalu loxo ta mitema ne Isilaeli misosovo sou lexe inoꞌu ꞌulu sou itema no anu. ");
INSERT INTO ata_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mo no anu lamoli ne la aneꞌi ilotonu lia xalee vile noxiꞌa ta mitema sou iꞌoxonu lasopeni, loxo tatila muvikalalelixu.” ");
INSERT INTO ata_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ioxe, ta kisiꞌa ta ailiꞌi iloꞌa ta tatilasiꞌa ta mitema minoꞌu Iesu xe milailixu noxou Pilato la mulai mutulu no talaxu. Xe tila noxiꞌa ta Romu muavuti la mutaliꞌisou Iesu lexe, “Nini tatananu tuala noxiꞌa ta Iutaia?” La Iesu mukolinu vaikala noxou lexe, “Ani, aloxo nini nelemolu ne.” ");
INSERT INTO ata_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","No mine ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatilasiꞌa ta mitema milomu aloxo ne la mileanu vaikala tuꞌutuꞌumaxu tavuꞌalo mulai noxou, la Iesu ukolinu uasi. ");
INSERT INTO ata_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","La Pilato mutaliꞌisou aloxo ꞌo, “Loxovaa, nini nelomusou vaikala tavuꞌalo e aneꞌi mileanu muneꞌe noxine ne uasi?” ");
INSERT INTO ata_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","La Iesu ukolinu vaikala vile e aneꞌi mileanu muneꞌe noxou ne uasisi manina. Aloxo ne la muꞌoxonu Pilato mukuluke manina. ");
INSERT INTO ata_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Io, no voxo tila aloxo ne, la Pilato ulavusou sou ululusou itema vile uxolu no nano no taasou navunavu ne, uatu. Ta mitema meꞌasi ilavusou isosovosou itema la sou anu ululusou. ");
INSERT INTO ata_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","No voxo ane ne la itema vile ualasou lexe Valavasi, anu a uxoxolu no nano no taasou navunavu ne. Anu itema e ta mitema latala milavusou lexe anu itema masua vile. ");
INSERT INTO ata_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta mitema mixali mipita mukalu, la sou Pilato mutaliꞌisiꞌa aloxo ꞌo, “Ioxe ngingi ngemasaxa lexe eni alulusou ꞌenaꞌei uuatu noxinge Valavasi, uasi, Iesu e ilemolu lexe anu Kalisito ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Anu muvikala aloxo ne, xo anu mulavusou lexe aneꞌi ta tatilasiꞌa ta tatila noxiꞌa ta ailiꞌi ne taneꞌi masuau Iesu misevile. ");
INSERT INTO ata_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Xe no mine Pilato uxoxolu no anu puloulou sou ulomusou vaivaikala noxiꞌa ta mitema sou itulu no anu vaivaikala, la semau misovanu vaikala muneꞌe noxou, la mimulesou aloxo ꞌo. “Mamu sou naꞌoxonu mii vile noxou itema e mulapu ne, xo eni eai pipiena no ꞌolovoxo la emaisou itema ne la examuli tuꞌumaxu tatila.” ");
INSERT INTO ata_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Xe ta kisia ta ailiꞌi iloꞌa ta tatilasiꞌa ta mitema ne miavutinoxu oponeꞌi ta mitema latala ne, sou lexe iꞌava ulai noxou Pilato lexe nalulusou Valavasi, ia navau Iesu mo usoli. ");
INSERT INTO ata_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","La sou tila ne Romu mutaliꞌisiꞌa lexe “Ngingi ngemasaxa lexe, eni alulusou ꞌenaꞌei noxiꞌa ta tamei ꞌo ulai noxinge?” La aneꞌi mikolinu lexe “Valavasi.” ");
INSERT INTO ata_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","La anu mutaliꞌisiꞌa la lexe, “Ia eni aꞌoxonu mii maꞌia noxou Iesu e aneꞌi ilemolu lexe Kalisito ꞌo?” La aneꞌi latala ne mikolinu lexe, “Ngalilixu teitexi no ovu valautu.” ");
INSERT INTO ata_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xe Pilato muavuti la mutaliꞌisiꞌa la aloxo ꞌo, “Tavaꞌu loxovaa, anu uꞌoxonu susu vile uasi?” Xe aneꞌi miavuti la miꞌava tatila manina lexe, “Ngalilixu teitexi no ovu valautu.” ");
INSERT INTO ata_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ia Pilato mumaisou lexe anu voteꞌi vile la sou anu uꞌoxonu la uasi xo maasi la ꞌotoꞌoto toxoxaꞌa uxali. La sou anu mukasi vaxa no lexa ka muꞌuinu avolu no ieꞌi ta mitema xo mulavu lexe maasi la ꞌotoꞌoto toxoxaꞌa uxali la sou muvikalaneꞌi lexe, “Eni susu noxilo uasi, ia lexe itema ꞌo usoli la anu mii noxingesi.” ");
INSERT INTO ata_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xe aneꞌi miavuti la mikolinu lexe, “Sialuxu ne uneꞌe utelo noxixe xe noxiꞌa ta ꞌiliꞌilixe iliꞌi.” ");
INSERT INTO ata_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","La sou anu mululusou Valavasi mulai noxiꞌa. Ia anu muvikalaneꞌi ta mitema sou ꞌotoꞌoto la mipuapuasou Iesu. Mipuapuasou mukalu la sou anu muꞌitalonu mulai no avoꞌa ta mitema sou lexe ililixu no ovu valautu. ");
INSERT INTO ata_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Xe iliꞌi la aneꞌi ta mitema sou ꞌotoꞌoto noxou tila noxiꞌa ta Romu milailixu Iesu muꞌunalai no nano no vimelusou taasou itema tila noxiꞌa ta Romu. La aneꞌi miꞌavaliꞌa ta mitema sou ꞌotoꞌoto latala ne mineꞌe mipita. ");
INSERT INTO ata_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aneꞌi mineꞌe mipita mukalu, la miluvusou tokolomou la mitaanu tokolomo vile lauoinu vaxa noxou. ");
INSERT INTO ata_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xe mipalipaxoxonu savovolu ka mimuxaxu vaxa no kisou loxo kisivalu sou sosovo lexe Anu tatananu tuala vile ane. Mo minoꞌu puate vile la mimuxaxu no avolu tema xe mukalu, la mitangatulu muluꞌelai no talaxu la mimolovilaꞌisou lexe, “Anu ane tatananu tuala noxiꞌa ta Iutaia.” ");
INSERT INTO ata_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aneꞌi mituvetuvesou xe minoꞌu puate la mivau no kisou ka mivau la. ");
INSERT INTO ata_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Xe iliꞌi no mine mimolovilaꞌisou mukalu la miluvunu tokolomo lauolauoinu e mitaanu noxou ne ia aneꞌi mitaanu tokolomo noxou mulivu vaxa noxou la. La sou minoꞌu milailixu sou lexe ililixu no ovu valautu. ");
INSERT INTO ata_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","No mine aneꞌi minoꞌu Iesu miuatulailixu no ale, la mixalisou itema vile ualasou lexe Saimoni, tualasou ne Sairini, la mivikala pekiaꞌu noxou sou lexe anu utavulenu ovu valautu noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aneꞌi minoꞌu Iesu la milailixu no tuala ilemolu lexe Xoluxata. Uala ane ne, laaxu lexe tuala sou ta mitema xavananeꞌi. ");
INSERT INTO ata_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Xe milai mixali ne, la milosou Iesu uaini ane aneꞌi mixiunu ilou lamalasile sixula, la Anu mutovonu muiexu sevile kituꞌasi ka mulomuanu. ");
INSERT INTO ata_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Xe iliꞌi la aneꞌi mililixu Iesu no ovu valautu. No mine mililixu mukalu la sou aneꞌi miꞌoxonu vilaꞌi vile sou misosovosou lexe ꞌei ane unoꞌu mii maꞌia maꞌia. La sou aneꞌi mivelunu tokolomou Iesu noxiꞌa vilevilesi. ");
INSERT INTO ata_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Xe mukalu la aneꞌi mixoxolu ne sou miloosou. ");
INSERT INTO ata_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aneꞌi mikaukavunu vaikala e anu mususu no anu ne, la miteinu teitexi no kisou. Aneꞌi mikaukavunu aloxo ꞌo, “Anu ano ꞌo Iesu tatananu tuala noxiꞌa ta Iutaia ane.” ");
INSERT INTO ata_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mo aneꞌi mililixaꞌa ta mitema sou pakali ta tamei no paꞌumolu. Mililixu vile no avolu tema xe vile mililixu no avolu ae. ");
INSERT INTO ata_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta mitema mimuamuaꞌi xe mineꞌe mipolopepeenu, la milulu kisiꞌa sou mimolovilaꞌisou. ");
INSERT INTO ata_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","La mivikala mulai noxou lexe, “Ae, nini namitema e neꞌoxo lexe namamulonu tani tila noxou Lataua ka natulusou ulivu voxo tatalusi ane! Mo lexe nini Lataua ꞌOlu la mene nasuꞌulineni mo naluꞌe no ovu valautu ne.” ");
INSERT INTO ata_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tisa sou lapuloto xe ta tatilasiꞌa ta mitema kalumo mimolovilaꞌisou. ");
INSERT INTO ata_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","La mivikala lexe, “Anu musuꞌulineꞌi aneꞌi ane vaꞌaxu, ia Anu molu umomomosou upamaulinu uasi. Lexe Anu tatananu tuala noxiꞌa ta Isilaeli, la ane alalae ꞌosi la Anu uxexee no anu ovu valautu ne mo uluꞌe la sou nexi tamuxaxu tanexi noxou. ");
INSERT INTO ata_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anu mumuxaxu tanu noxou Lataua mo Anu muvikala lexe, ‘Eni Lataua ꞌOlu.’ Ioxe, lexe Lataua mumasaxau, la Anu Lataua molu usuꞌulinu.” ");
INSERT INTO ata_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mo ta mitema ta tamei e mililixaꞌa no paꞌumolu ne, aneꞌi ilou mimolovilaꞌisou kalumo. ");
INSERT INTO ata_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aso mukulupa mo mulai muxali no aso iou tatalu no ꞌoloꞌolovoxo la isivoxo mutaasou xalexalee tuatuala mukalusi. ");
INSERT INTO ata_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ia alaalai sou aso iou tatalu no ꞌoloꞌolovoxo la Iesu muꞌava tatila lexe, “Eloi, eloi lama savakatani?” Laaxu lexe, Lataua noxilo, Lataua noxilo, loxovaa la sou nini nesuꞌaleli ꞌo? ");
INSERT INTO ata_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anu muꞌava aloxo ne, la ta mitema seꞌi mitulutulu ꞌalai noxou ne milomusou, la mivikala lexe, “Ngalomu anu a uꞌavalou Eliasi.” ");
INSERT INTO ata_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Xe itema vile muiave alaxu vilesisi ꞌo la mulai munoꞌu kateni la mutaa muluꞌelai no uaini e sixula. Xe mukalu la mutolosou mutelai no anaxu Iesu sou muie no anu. ");
INSERT INTO ata_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Xe aneꞌi latala miavuti la mivikala lexe, “Ioxe, naxexesou, mo tamaisou lexe Eliasi uneꞌe sou usuꞌulinu.” ");
INSERT INTO ata_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Xe no mine Iesu muunga tatila alaxu vile la mukalu la Anu musoli. ");
INSERT INTO ata_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","No mine Anu musoli ne, la lavalava e mulili no nano no tani tila noxou Lataua ne, mukakaa tamomolu teitexi la mulai mupee no lia. Mo laliua mukunikuni la kulu muvalavala. ");
INSERT INTO ata_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Xe lulusiꞌa ta mitema e misoisoli ne mumamulo xe mukisi la ta mitema tavuꞌalo noxou Lataua e misoisoli ne mitulu mimauli. ");
INSERT INTO ata_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aneꞌi milaa no anu lousiꞌa xe Iesu mutulu mumauli, la aneꞌi milai miꞌunalai ne Ielusalemu mo ta mitema tavuꞌalo mimaisiꞌa. ");
INSERT INTO ata_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mo itema tila sou uulaxuneꞌi ta mitema itemaxu taꞌuve sou ꞌotoꞌoto iloꞌa ta mitema sou ꞌotoꞌoto e mitulutulu sou iloosou Iesu ne mimaisou laliua mukunikuni, xe mimii latala e muxali ne la miꞌume. La mivikala lexe, “Manina misevile, itema ane ꞌo ne, anu Lataua ꞌOlu ane.” ");
INSERT INTO ata_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mo ta sema tavuꞌalo seꞌi a itulutulu vaꞌaxu sevile sou imamalei. Aneꞌi mimulinu Iesu ne Xalilaia mitoꞌo sou isuꞌulinu. ");
INSERT INTO ata_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Xe no taneꞌi ne la Malia sie Maxadala mo Malia ane Iakovo ilou Iosepu neniꞌa xe Sevetaio ta ꞌolu neniꞌa ne aneꞌi kalumo mitutulu ne. ");
INSERT INTO ata_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Xe no ꞌolovoxo la itema sou lavuluti vile sie Alimatia, ualasou lexe Iosepu anu muxali molomolo vile noxou Iesu muneꞌe muxali. ");
INSERT INTO ata_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Anu muneꞌe la mulai muxali noxou Pilato la mutaliꞌisou sou lexe unoꞌu Iesu vasimolu, la sou Pilato mupalusou sou unoꞌu. ");
INSERT INTO ata_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","La sou Iosepu mulai munoꞌu lavalava kea vile alavua sou muneꞌe mukupoonu Iesu vasimolu no anu. ");
INSERT INTO ata_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Xe mukalu la munoꞌu mulai mumulaxu no anu lulu noxou alavua e muꞌasou no tavaꞌu maea ne. Xe mupipaloꞌu lavoꞌo vile toxoxaꞌa la muneꞌe mutaluxu lulu anaxu ne, io anu mulivu. ");
INSERT INTO ata_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","La Malia sie Maxadala ilee Malia ane vile, aneꞌi ilou a ixoxolu xalee vile ia ieꞌi ulalai. ");
INSERT INTO ata_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xe voxo sou lalaxii sou voxo Tavuna mukalu ia no anu voxo ane iliꞌi, la ta tatila noxiꞌa ta ailiꞌi iloꞌa ta Palisaio milai mixali noxou Pilato. ");
INSERT INTO ata_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","La mivikalanu lexe, “Tila, nexi texavutalanu vaikala noxou itema sou kalakalavoi ne no mine uao uxoxolu ꞌo la muvikala lexe, voxo tatalusou la anu utulu. ");
INSERT INTO ata_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","La sou laixe lexe nini navikala mo sou iloosou lulu anaxu ne ulai uxali no anu voxo tatalusou. Xo loxo ꞌo io ta molomolo noxou ineꞌe ipakalinu vasimolu, ia ilai ikalavoineꞌi ta mitema lexe Anu mutulu. La sou kalavoi noxiꞌa ne uaꞌulixu kalavoi noxou e anu muꞌoxonu tei ne.” ");
INSERT INTO ata_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Xe Pilato muavuti la muvikalaneꞌi lexe “Ioxe, nganoꞌa ta mitema sou ꞌotoꞌoto, mo ilai iloosou lulu ne, mo ngapaipounu xo ipakalinu.” ");
INSERT INTO ata_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","La sou aneꞌi milai mipaipounu lulu anaxu ne la mimuxaxu sosovo vile no anu lavoꞌo no lulu anaxu ne xe mimuxaxaꞌa ta mitema sou iloosou lulu ne. ");
INSERT INTO ata_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Voxo Tavuna mukalu, xe no kakau manina no anu voxo vile, la Malia sie Maxadala iloꞌa Malia ane vile milai no lulu ne. ");
INSERT INTO ata_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xe alaxu vilesisi ꞌo la laliua mukunikuni toxoxaꞌa manina, Xo angelo vile noxou Lataua molu teitexi no opo loxotolo muluꞌe mulai no anu lulu ne sou mupipaloꞌu kulu e mutaluxu lulu anaxu ne muxexenu. Xe mukalu la anu muxolu no anu ne. ");
INSERT INTO ata_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ia alaiou ne mulamilami loxo leleꞌe lamixu xe tokolomou veveeni ne mukea loxo tamuxala ne. ");
INSERT INTO ata_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Xe ta mitema sou ꞌotoꞌoto e mixolu sou miloosou lulu ne miꞌumolu, la miꞌoloꞌolo, la misoisoli vitanisi loxo itema musoli. ");
INSERT INTO ata_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Xe angelo muavuti la muvikalaneꞌi ta sema tamei ne lexe, “Ngingi ngaꞌume mamu, xo eni elavusou lexe ngingi ngeneꞌe sou lexe ngamaisou Iesu e ta mitema mivau musoli. La mililixu no ovu valautu. ");
INSERT INTO ata_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia Anu uxolu ꞌo uasi, Anu mutulu loxo Anu mulemolu. Ngamaisou tanixu e aneꞌi mimulaxu muai no anu a. ");
INSERT INTO ata_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","La sou ngalivu ngapasipaa ulai mo ngavikalaneꞌi ta molomolo noxou. Ngavikalaneꞌi lexe Anu mutulu mo mumauli mo muuli mulai ne Xalilaia. La sou aneꞌi ilai imaisou ane. Eni eneꞌe sou avikalangengi aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Xe ta sema ne milaa no lulu ne sou milai no ale, la miꞌume manina, ia ꞌosaꞌila muꞌanaꞌana noxiꞌa kalumo, la sou miiave sou lexe ivikalaneꞌi ta molomolo noxou. ");
INSERT INTO ata_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ia no mine aneꞌi miave sou lexe ilai ivikalaneꞌi ta molomolo noxou loxo ꞌo la uaꞌa, Iesu alaxu vilesisi ꞌo la muneꞌe muxali vaxa noxiꞌa, la muvikalaneꞌi lexe, “Opongengi uxolu seꞌisisi.” Xe aneꞌi miiavuti la milai miteteli no tavaꞌu sou milotu noxou. ");
INSERT INTO ata_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","La sou Iesu muvikalaneꞌi aloxo ꞌo, “Ngaume mamu. Ngalai mo ngavikalaneꞌi ta vivilo lexe ilai ne Xalilaia, la sou imaisilo ane.” ");
INSERT INTO ata_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","No mine ta sema ꞌa uao ilalai o, la ta mitema e miloosou lulu ne miꞌunalai no nano no tuala tila (Ielusalemu) la miaꞌaloxu mimii latala e muxali ne noxiꞌa ta kisiꞌa ta ailiꞌi. ");
INSERT INTO ata_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xe ta kisiꞌa ta ailiꞌi milomu aloxo ne, la iloꞌa ta tatilasiꞌa ta mitema mipita la mixali no anu xavutala vile, la milosiꞌa ta mitema sou ꞌotoꞌoto ne lamoli tatila. ");
INSERT INTO ata_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","La mivikalaneꞌi aloxo ꞌo, “Maasi la ngingi ngavikala aloxo ꞌo, ‘Ta molomolo noxou mineꞌe no ꞌolovoxo no mine nexi teai tevaꞌamiminu, la aneꞌi mineꞌe mipakalinu Iesu vasimolu.’ ");
INSERT INTO ata_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mo sou lexe tila noxiꞌa ta Romu ulomusou, la nexi mexe tamomosou noxou, la ngingi tuꞌumaxu vile uxali noxinge uasi.” ");
INSERT INTO ata_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","La sou ta mitema sou ꞌotoꞌoto ne minoꞌu lamoli mukalu, la milai miꞌoxonu aloxo aneꞌi mivikalaneꞌixu ne. La sou aꞌalo ane ne mulaa mulai munoꞌa ta Iutaia mukalusi, la muxolu noxiꞌa muneꞌe muxali vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Xe iliꞌi la ta molomolo noxou mavulovexa mulelia vile milai no alaele ne Xalilaia e anu Iesu muvikalaneꞌixu lexe aneꞌi ilai no anu. ");
INSERT INTO ata_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","No mine aneꞌi mimaisou, la aneꞌi milotu noxou, ia seꞌi noxiꞌa ne xavutalaiꞌa tamei. ");
INSERT INTO ata_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu muneꞌe ꞌalai noxiꞌa la muvikalaneꞌi aloxo ꞌo, “Lataua mulosilo xavi sou asaxilaꞌu mimii latala teitexi no opo loxotolo xe no lia ꞌo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aloxo ne la sou ngingi ngalai no xalexalee tuatuala ukalusi mo ngaꞌoxoneꞌi ta mitema ixali ta molomolo noxilo, mo ngaꞌulosiꞌa no ualasou Mamilo mo no ualasou ꞌOlu xe no ualasou Uleenu Tavuna. ");
INSERT INTO ata_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mo ngalosieꞌi sou imulinu mimii latala e eni evikalangengi sou ngaꞌoxonu ne. Mo ngalavu laixe lexe eni axolu noxinge utotomu ulai utalo no ꞌa voxo sou tuala xalexalee ukalu. ");
INSERT INTO ata_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tavaꞌu aꞌalo laixe sou Iesu Kalisito, Lataua ꞌOlu ne, Anu muxali tatei aloxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aisaia, itema sou palomatana ne, anu mukaukavu aloxo ꞌo, “Ngalomu, eni apalusou itema vile sou upalaꞌalixu vaikala noxilo mo uuli noxine sou upaipounu voteꞌisine.” ");
INSERT INTO ata_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Itema vile uꞌavaꞌava no xalee lia vitanisi aloxo ꞌo, ‘Ngalalaxiinu voteꞌisou IAUE, mo ngamomosou kalumo.’” ");
INSERT INTO ata_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","La sou itema e ualasou lexe Ioanesi ne, anu muxali no xalee lia vitanisi. Anu muvikala pekiaꞌu mulai noxiꞌa ta mitema lexe ixiu oponeꞌi, mo sou anu uꞌulosiꞌa. La sou Lataua uxiu tumalouu ꞌiliꞌilixo masumasua noxiꞌa ne. ");
INSERT INTO ata_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ta mitema sou xalee lia tila ne Iutaia mo tuala tila ne Ielusalemu ne, mineꞌe noxou mukalusi, sou mivikala lamana no anu ꞌiliꞌilixoneꞌi vilevilesi, la sou anu Ioanesi muꞌulosiꞌa no lexa ne Ioridani. ");
INSERT INTO ata_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioanesi ne, musakii kameli laxusou sou mutaluxu vasimolu xe muutupokoxu no anu bulumakau sosou. ꞌAniꞌanixu ane musiaꞌe taula ilou unuxu lexaxu. ");
INSERT INTO ata_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anu muvikala aloxo ꞌo, “Eni euli ꞌo, ia Anu ane uiliꞌi noxilo ne, Anu xaviinu muuli noxilo mo eni amomomo sou alulusou lamotasou siovexu tavaꞌu uasi. Xo eni amitema vitanisi. ");
INSERT INTO ata_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eni aꞌulosinge no anu lexasi, ia Anu uꞌulosinge no anu Uleenu Tavuna.” ");
INSERT INTO ata_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","No anu imamaa ane ne, la Iesu muꞌumesou tualasou ne Naseleti no xalee lia tila ne Xalilaia sou mununa muxali no lexa ne Ioridani. La sou Ioanesi muꞌulosou. ");
INSERT INTO ata_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Xe muꞌulo mukalu ia muxali mutelo no lexa loxoꞌu, la alaxu vilesisi, mumaisou opo loxotolo mukisi la Uleenu muvava muluꞌe loxo ngiala kuau sou muxolu noxou. ");
INSERT INTO ata_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","La mulomusou ꞌava molu no opo loxotolo, muvikala aloxo ꞌo, “Eni ꞌalixeni ane nini, amasaxaine misevile mo opoleli muꞌosasine misevile.” ");
INSERT INTO ata_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Xe alaxu vilesisi ꞌo, la Uleenu Tavuna mulutulixu sou mulailixu no xalee lia vitanisi. ");
INSERT INTO ata_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mulai muxolu ane voxo mavulovexa tamiꞌa, la Satani mutovonu. Mulai iloꞌa ta mimii iouiou ane ta vova mixolu ane, ia ta angelo mineꞌe sou misaxilaꞌu. ");
INSERT INTO ata_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Xe iliꞌi no voxo ane aneꞌi mitetelisou Ioanesi sou milai miꞌunalailixu mo mitatuxu no taasou navunavu, la Iesu mulivu mutoꞌo ne Xalilaia sou muaꞌaloxu aꞌalo laixe noxou Lataua, ");
INSERT INTO ata_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","la muvikala aloxo ꞌo, “Voxo ane ne a muxali ꞌo, mo saxisaxilaꞌu noxou Lataua a muneꞌe ꞌalai mukalu. Ngaxiu opongengi mo ngamuxamuxaxu tangengi no anu aꞌalo laixe noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","No voxo vile, la Iesu mumuamuaꞌi no paꞌumolu kupa ne Xalilaia, la mumaisou itema vile ualasou lexe Saimoni ilou vimou Andeleasi ikakae, xo aneꞌi ilou ta mitema sou ikaeneꞌi ta sinana. ");
INSERT INTO ata_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Xe muavuti la muvikalaneꞌi ilou aloxo ꞌo, “Nganeꞌe mo ngamulileli, mo sou eni alosinge lavulavu sou ngalapuneꞌi ta mitema.” ");
INSERT INTO ata_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Xe alaxu vilesisi ꞌo, la ilou miꞌumesou kaexaꞌa mukalusi muai ne, ia ilou milutu sou mimulinu. ");
INSERT INTO ata_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xe mulutu sou mumuamuaꞌi musuku mulai sevile la, la mumaisiꞌa Iakovo ilou vimou Ioanesi ioloonu kaexaꞌa ilou. ");
INSERT INTO ata_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","La uvoovoxo la uasi. Muavuti sou muꞌavaliꞌa ilou la. Xe ilou miavuti la miꞌumesou mamiꞌa Sevetaio iloꞌa ta mitema sou xaixai noxou no uaxa ne, ia aneꞌi ilou milutu sou mimulinu Iesu. ");
INSERT INTO ata_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aneꞌi milutu sou milai no tuala ne Kapenaumu. Mixali mixolu, la anu voxo Tavuna muxalisiꞌa. La sou Iesu muꞌunalai no taasou lalotu noxiꞌa ta Iutaia sou musoko mulosiꞌa ta mitema lavulavu. ");
INSERT INTO ata_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Xe ta mitema milomusou vaivaikala noxou, la mikuluke misevile. Xo Anu mulosiꞌa lavulavu ne loxo itema vile tatila vaikalau, ia loxo vaikala noxiꞌa ta mitema sou lapuloto uasi. ");
INSERT INTO ata_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Alaxu vilesisi ꞌo, la itema vile no nixi no taiineꞌi ne, uleenu vile masua muxoo noxou, la muavuti sou muꞌava aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu, nini itema sie Nasaleti. Neneꞌe ꞌo sou naꞌoxonu maꞌia noxixe? Neneꞌe ꞌo sou lexe nakalusixe? Eni elavu lexe nini itema e Lataua musosovosine lexe nini Anu naꞌu ꞌole ane.” ");
INSERT INTO ata_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Xe Iesu mulomu aloxo ne, la muavuti sou mukaitolonu aloxo ꞌo, “Naxolu tasiau! Mo naxexesou itema ne!” ");
INSERT INTO ata_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Xe uleenu masua ne, muavuti la muꞌumuꞌumunu itema ne xe muungaunga, la sou muxexesou. ");
INSERT INTO ata_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Xe ta mitema mimalei aloxo ne, la mikuluke la mitalitaliꞌisiꞌa ngatongatoꞌo aloxo ꞌo, “Nenge mii maꞌia ane muxali loxo ꞌo? Nenge telavu lexe lavulavu noxou ne, mii alavua mo Anu xaviinu misevile. Xo Anu mupalusiꞌa ta uleenu masua ꞌo la milomuxusi.” ");
INSERT INTO ata_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Alaxu vilesisi ꞌo, la aꞌalo sou Iesu ne milai miaꞌaloxu no xalee lia tila ne Xalilaia mukalusi. ");
INSERT INTO ata_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Xe milaa miuatu no taasou lalotu noxiꞌa ta Iutaia ne, la milai avilesi no tani noxou Saimoni ilou Andeleasi. Iakovo ilou Ioanesi kalumo ne mimulinu sou iloꞌa milai. ");
INSERT INTO ata_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Milai mixali, la Saimoni leuanu ne a iai no luu, xo pipiena muꞌoxone la vasimele ialuxu. Alaxu vilesisi, la mivikalanu Iesu lexe ane mipipiena. ");
INSERT INTO ata_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Xe Anu muavuti la mulai noxie sou mukasi vaxa no avole, io sou mutulusie. Xe pipiena ne muxexesie, la sou ane mitulu sou mixutuxuxaꞌa laꞌilali. ");
INSERT INTO ata_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Xe no ꞌoloꞌolovoxo no mine aso uluꞌelai, la ta mitema minoꞌa aneꞌi ane vovolea iouiou muꞌoxoneꞌi mo aneꞌi ane ta uleenu masumasua mixoo noxiꞌa sou mineꞌeneꞌi noxou. ");
INSERT INTO ata_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta mitema no tuala ane ne, mineꞌe mukalusi mole no ale no aitengaxu tani ne aneꞌisi. ");
INSERT INTO ata_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","La sou Anu mupamaulineꞌi aneꞌi tavuꞌalo e vovolea iouiou muꞌoxoneꞌi ne, xe mukusaiꞌa ta uleenu masua noxiꞌa xalee seꞌi. Ia ta uleenu masua ne milavusou Iesu, la sou Iesu iou muvaxa noxiꞌa la muvikalaneꞌi lexe mamu sou ivivikala lexe Anu ꞌei. ");
INSERT INTO ata_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Xe no kakau no mine lamana upau lailaixe uao, la Iesu mulaa sou mulai mulinga no xalee tani vile e ta mitema seꞌi ixolu no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","La sou Saimoni iloꞌa ta menexu, milutu sou milai mikamulinu. ");
INSERT INTO ata_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Xe mixalisou la mivikalanu aloxo ꞌo, “Ta mitema te tavuꞌalo ꞌa ikakamulineni!” ");
INSERT INTO ata_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xe Anu muavuti la muvikalaneꞌi aloxo ꞌo, “Ioxe, nengeꞌa talai no xalee tuala seꞌi ane uxolu se ꞌalaꞌalai. Xo eni emasaxa lexe aaꞌaloxu aꞌalo noxou Lataua noxiꞌa kalumo. Xo xaixai e eni eneꞌe sou lexe aꞌoxonu ane.” ");
INSERT INTO ata_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","La sou Anu muxixaoxao no xalexalee tuatuala no nano no xalee lia tila ne Xalilaia sou muaꞌalo no taasou lalotu noxiꞌa ta Iutaia xe mukusaiꞌa ta uleenu ta masumasua e mixolu noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xe iliꞌi, la itema vile vulukali muꞌoxonu ne, muneꞌe noxou Iesu la muxolaꞌu tavaꞌu voꞌuxu mo mutangatulu no talaxu ka mulinga xaviinu sou lexe upamaulinu. La sou muvikalanu aloxo ꞌo, “Lexe nini nemasaxa, la napamaulileli mo eni axali malemalenga no iou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","La sou Iesu tanuxu misevile la mukasi vaxa no vasimolu la muvikalanu aloxo ꞌo, “Eni emasaxa lexe nini naxali malemalenga.” ");
INSERT INTO ata_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xe alaxu vilesisi ꞌo, la vulukali ne muxexesou avile, mole anu malemalenga. ");
INSERT INTO ata_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Xe Iesu muavuti la mupalusou mupasipaa mulai, la mulosou vaikala pekiaꞌu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nalai, ia umomomo sou naaꞌalou evile no anu mii ane eni eꞌoxonu noxine ꞌo uasi manina. Ia nalai namaxainesi noxiꞌa ta ailiꞌi mo nalosiꞌa mii ane ulai noxou Lataua loxo Mosesi mulemolu sou napalaꞌalixu lexe nini nexali malemalenga no iou Lataua mukalu. Mo sou ta mitema imaisou, la ilavu lexe nini ane vasimene laixe mukalu.” ");
INSERT INTO ata_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ia, itema ne ulomu ua. Mulai ne la muaꞌaloiꞌaxu ta mitema mii maꞌia ane muxali noxou. Mole aꞌalo ne, ta mitema no xalexalee tuatuala milomusou mukalu. Tavaꞌu xo ta mitema milomusou aꞌalo ka mineꞌe noxou Iesu, la sou ane Iesu uꞌunalai no tuala vile mo iou upalaꞌa noxiꞌa ta mitema la ua. Uxoxolu no ale no xalexalee tani ane evile uxolu no anu uasi. Ia ta mitemasi ne, ilutu no xalexalee tuatuala vaꞌavaꞌaxu sou ineneꞌe noxou ukalusi. ");
INSERT INTO ata_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ioxe, voxo seꞌi mukalu, la Iesu mulivu muneꞌe ne Kapenaumu la, sou mulai muxolu no tani vile. Xe ta mitema milavu aloxo ne, ");
INSERT INTO ata_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","la mixali mipita no nano no tani ne, mole tani ne muꞌanaꞌana mo no ale no aitenga ne, tani mutomu manina. Mineꞌe sou Anu muaꞌaꞌaloiꞌa no anu vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mineꞌe la ta mitema tamiꞌa noxiꞌa mitavulenu itema vile ne vasimolu musoisoli mukalu mo umomomo sou umuamuaꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tavaꞌu xo ta mitema te tavuꞌalo e mineꞌe mixali ne, la tani mutomu mukalu. La aneꞌi imomomo sou imuamuaꞌilixu ulai noxou Iesu uasi. La sou mitelailixu no tani e Iesu muxolu no anu ne laxaꞌu ka miꞌelixu taxa mumomomo noxou itema ne io, sou mitaloxolixu ilou luusou e muai no anu muluꞌe noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Xe Iesu mumaisou mii ane ta mitema tamiꞌa ne miꞌoxo noxou menexiꞌa ne, la Anu mulavu lexe aneꞌi mimuxamuxaxu taneꞌi maninasou. La sou muavuti la muvikalanu itema e vasimolu musoisoli ne aloxo ꞌo, “Vivilo, eni exiu tumalilou ꞌiliꞌilixo masumasua noxine ne.” ");
INSERT INTO ata_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","No voxo ane ne, la ta mitema sou lapuloto seꞌi a italupexa ne, la milomusou Iesu muvikalanu itema ne, la xavutalaiꞌa muvikala lexe, ");
INSERT INTO ata_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Loxovaa ane itema ꞌo muꞌoxonu vaikala ane loxo ꞌo? Anu muvikala masua mulai noxou Lataua ne. ꞌEi ane umomomo sou uxiu tumalouu ꞌiliꞌilixo masumasua o? E, Lataua anusisi!” ");
INSERT INTO ata_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Alaxu vilesisi ꞌo, la Iesu uleenu mulavusou xavutalaiꞌa. La sou Anu mutaliꞌisiꞌa aloxo ꞌo, “Loxovaa ane ngingi ngexavutala piena no anu mimii ane ꞌo? ");
INSERT INTO ata_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vaikala anevaa ane laixe sou eni alemolu ulai noxou itema e vasimolu musoisoli, sou lexe eni amaxaꞌu xavi noxilo? Eni avikalanu lexe ꞌiliꞌilixo masumasua noxou a exiu tumalilou ne, uasi? Eni avikalanu lexe utavulenu moꞌesou mo ulai? ");
INSERT INTO ata_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mo sou ngingi ngalavu lexe Itema ꞌOlu ne, Anu munoꞌu xavi kalumo sou uxaxai no lia ꞌo sou uxiunu tumalouu ꞌiliꞌilixo ane masumasua.” Xe muavuti la muvikalanu itema e muai no moꞌesou ne aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Avikalaneni, natulu mo nanoꞌu moꞌesine mo nalai no taasine.” ");
INSERT INTO ata_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Xe itema muavauti no lia ꞌo, la mutulu sou munoꞌu moꞌesou alaxu vilesisi, la mulaa muuatu no ieꞌi aneꞌi latala ne, sou mulai. Aneꞌi latala ne, mimaisou la mikuluke manina la miꞌitinu Lataua ualasou. Mivikala aloxo ꞌo, “Nexi talavusou tamaisou mii vile loxo ꞌo tatei uasi!” ");
INSERT INTO ata_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Xe iliꞌi, la Iesu mulivu sou mulai no kupa paꞌumolu ne Xalilaia la. La ta mitema tavuꞌalo mineꞌe mixali noxou, la Anu muavuti sou muaꞌaloiꞌa no anu vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Xe mumuamuaꞌi musuku mulai, la mumaisou itema vile ualasou lexe Levi, e Alipaio ꞌolu uxoxolu no nano no tani ane ta mitema iꞌuna xe iuatu no xalee lia tila ne Xalilaia, la ilea lamoli no anu, la muꞌavalou aloxo ꞌo, “Naneꞌe mo namulileli.” La sou Levi muavuti sou mumulinu. ");
INSERT INTO ata_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ilou milai mixali no taasou Levi, la sou aneꞌi iloꞌa Iesu mixolu sou miꞌani. Seꞌi noxiꞌa ne, aneꞌi ta mitema sou itaxusou lamoli moseꞌi aneꞌi ta mitema sou ilavusou iꞌoxonu ꞌilixo masumasua misevile xe ta molomolou Iesu kalumo. Aneꞌi ta mitema ane aloxo ne, tavuꞌalo noxiꞌa ilavusou imulinu Iesu utotomu. ");
INSERT INTO ata_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Xe ta mitema sou lapuloto, aneꞌi ta Palisaio mimaisou Iesu iloꞌa ta mitema ane ilavusou iꞌoxonu ꞌilixo ane masumasua mo ta mitema sou itaxusou lamoli iꞌani ipita loxo ne, la mitaliꞌisiꞌa ta molomolou Iesu aloxo ꞌo, “Loxovaa ane Anu iloꞌa ta mitema sou itaxusou lamoli mo ta mitema ane ilavusou iꞌoxonu ꞌilixo masumasua iꞌani ipita loxo ne?” ");
INSERT INTO ata_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Xe anu Iesu mulomu aloxo ne, la muvikalaneꞌi aloxo ꞌo, “Itema e pipiena uꞌoxonu uasi ne, umomomo sou ulai umaisou itema sou pamauli uasi. Ia itema ane pipiena uꞌoxonusi, anu ulai umaisou itema sou pamauli. Anu aloxo ne, la sou eni eneꞌe ꞌo sou aꞌavaliꞌa ta mitema mulapu uasi, eni eneꞌe ꞌo sou aꞌavaliꞌa ta mitema ane ilavusou iꞌoxonu ꞌilixo masumasua.” ");
INSERT INTO ata_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Alaxu vile, la ta molomolou Ioanesi xe noxiꞌa ta Palisaio ipepelemu. La sou ta mitema seꞌi mineꞌe noxou Iesu, la mitaliꞌisou aloxo ꞌo, “Loxovaa la ta molomolou Ioanesi mo noxiꞌa ta Palisaio a ipepelemu, ia ta noxine uasi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Xe Anu muavuti la mukolinu taliꞌiiꞌa aloxo ꞌo, “Ia xo lexe, itema vile utaulaꞌi alavua loxo vaimomo ꞌo, la ta minuminu e mineꞌe sou mimaisouxu taulaꞌixu ne, umomomo sou ipelemu? Uasi, aneꞌi iꞌani. Voxo ane anu itema e utaulaꞌi a iloꞌa ixoxolu ne ꞌo, la aneꞌi umomomo sou ipelemu sou laꞌilali uasi. ");
INSERT INTO ata_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ia lexe no voxo ane aneꞌi inoꞌu itema e mutaulaꞌi alavua ulai, ia iloꞌa ixolu la uasi, la sou no voxo ane ne, aneꞌi ipelemu sou iꞌou laꞌilali ua. ");
INSERT INTO ata_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Itema vile umomomo sou unoꞌu lavalava xasixu sevile alavua, ka ulai usimenu vaxa no anu ane mamuxanu mukakaa ne uasi. Xo lexe anu uꞌoxo aloxo ne, xe lavalava xasixu alavua ne utaxulapu la ukakaa lavalava ane mamuxanu ne uꞌokinu la. ");
INSERT INTO ata_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mo itema vile umomomo sou utau uaini alavua uꞌuna no anu uaini vexasou ane mamuxanu uasi. Xo lexe anu uꞌoxo aloxo ne, la uaini ne upaunoxu vexasou mamuxanu, la uaini ilou vexasou ne masua avile. Uasi, anu utau uaini alavua ne, uꞌuna no anu vexasou alavuasi.” ");
INSERT INTO ata_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","No voxo Tavuna vile, la Iesu iloꞌa ta molomolou milai mimuamuaꞌi no nano no xai sou ame. Iloꞌa mimuamuaꞌi milalai, la ta molomolou misoko sou miꞌelexu ame temanu seꞌi. ");
INSERT INTO ata_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Xe ta Palisaio mimaisiꞌa la mitaliꞌisou Iesu aloxo ꞌo, “Ae, loxovaa ane ta molomolomeni ꞌo miꞌoxonu ꞌilixo ane umomomo sou taꞌoxonu uasi no voxo Tavuna loxo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Xe Anu muavuti la mukolinu taliꞌiiꞌa aloxo ꞌo, “Xo loxovaa, ngaitisou aꞌalo sou Deviti iloꞌa ta mitema noxou uasi? Aneꞌi xaꞌa laꞌilali sou inoꞌu uasi xe misolixaꞌa, la miꞌoxo maꞌi? ");
INSERT INTO ata_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","No tauu ie ane itema vile ualasou lexe Aviata muxolu loxo kisiꞌa ta ailiꞌi, la anu Deviti ne mulai muꞌunalai no taasou Lataua ne, sou munoꞌu laꞌilali noxou Lataua sou iloꞌa ta mitemau minoꞌu. Laꞌilali ane ne, umomomo sou ta mitema vitanisi iꞌou uasi. Ta ailiꞌi aloxo Aviata ne, imomomo sou iꞌou.” ");
INSERT INTO ata_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Xe muavuti la muvikalaneꞌi la aloxo ꞌo, “Voxo Tavuna ne, Lataua musosovosou sou usuꞌulineꞌi ta mitema, ia sou ta mitema isuꞌulinu voxo Tavuna uasi. ");
INSERT INTO ata_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","La sou Itema ꞌOlusi ne, Anu mutila manina misevile no anu voxo Tavuna ne.” ");
INSERT INTO ata_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Xe alaxu vile la, la Iesu mulai muꞌunalai no taasou lalotu noxiꞌa ta Iutaia. La itema vile avolu musoli ne ꞌa, iloꞌa ixoxolu no nano. ");
INSERT INTO ata_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta mitema seꞌi noxiꞌa ne, ikakamuli voteꞌi sou itulusou Iesu no anu vaivaikala. Aneꞌi mineꞌe sou iutiou sou imalei lexe anu upamaulinu itema ne no voxo Tavuna ne. ");
INSERT INTO ata_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xe Iesu muavuti la muvikala itema e avolu musoisoli ne aloxo ꞌo, “Naneꞌe mo natulu no talaxaꞌa ta mitema latala ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Xe itema ne, muneꞌe mutulu mukalu la Iesu mutaliꞌisiꞌa ta mitema ne aloxo ꞌo, “Voteꞌi anevaa ane laixe sou tamulinu lapuloto sou voxo Tavuna ꞌo? Anu laixe sou taꞌoxonu ꞌilixo laixe, uasi? Laixe sou taꞌoxonu ꞌilixo masua? Anu laixe sou tapamauli itema, uasi? Laixe sou tavaꞌu itema usoli?” Anu mutaliꞌisiꞌa aloxo ne, ia aneꞌi ivikala vile uasi, mixolu tasiausi. ");
INSERT INTO ata_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xe Anu laꞌiaxu, la iou muitisiꞌa mukalusi. Io tanu liliꞌa misevile xo aneꞌi oponeꞌi pekiaꞌu, la sou muvikalanu itema ne aloxo ꞌo, “Namexiinu avone uuatu!” Xe anu mumexii avolu muuatu la avolu ne muxali laixe la. ");
INSERT INTO ata_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xe alaxu vilesisi ꞌo, la ta Palisaio miavuti milaalaa sou milai iloꞌa ta mitema noxou Elodesi mipita sou mivivikala sou ikamuli voteꞌi sou itetelisou Iesu sou ivau. ");
INSERT INTO ata_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Xe Iesu muavuti la iloꞌa ta molomolo noxou ne, misuku no tuala ane ne, sou milai loxo no kupa ne Xalilaia. La ta mitema sie Xalilaia tavuꞌalo misevile mimulinu. ");
INSERT INTO ata_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ta mitema milomusou aꞌalosou xaixai e Anu muꞌoxonu, la tavuꞌalo misevile mineꞌe mixali noxou. Meꞌa loxo ne Iutaia mo ne Ielusalemu mo ne Idumaia mo no xalee lia mulai loxo taxisaꞌisie lexa ne Ioridani ia xalee vile ne. Xe ta mitema tavuꞌalo mixolu ꞌalaꞌalai no tuala ne Taia ilee Saidoni ne mineꞌe mukalusi. ");
INSERT INTO ata_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tavaꞌu xo ta mitema tavuꞌalo misevile mineneꞌe, la Anu muvikalaneꞌi ta molomolou lexe inoꞌu uaxa vile sou uneꞌe uai lumamo sou Anu utelai uxolu no anu. Xo mamu lexe aneꞌi ineꞌe ipita la isounu. ");
INSERT INTO ata_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Xo Anu mupamaulineꞌi ta mitema tavuꞌalo, la sou aneꞌi ane pipiena iouiou muꞌoxoneꞌi ne, isousouneꞌi ta menexiꞌa sou ikasou. ");
INSERT INTO ata_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Xe aneꞌi ane ta uleenu masua ixoo noxiꞌa imaisou Iesu, la itangatulu uluꞌelai no tavaꞌu, io sou iꞌava aloxo ꞌo, “Nini ꞌo ne, nini Lataua ꞌOlu manina.” ");
INSERT INTO ata_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ia Anu Iesu muvikala pekiaꞌu mulai noxiꞌa lexe mamu sou ilai ivikala lamana lexe Anu ꞌei manina. ");
INSERT INTO ata_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Xe iliꞌi, la Iesu mutelai no laxaꞌilu vile sou muꞌavaliꞌa aneꞌi ta mitema ane anu mumasaxaiꞌa, la sou aneꞌi mineꞌe mixali noxou. ");
INSERT INTO ata_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Anu muꞌavaliꞌa mavulovexa vile mo mulelia tamei, la sou mumoxoꞌa lexe aneꞌi ta mitema sou xaixai noxou, sou lexe ixoo ꞌalai noxou mo Anu upalupalusiꞌa ilai no tuatuala sou iaꞌaloxu vaikala noxou Lataua, ");
INSERT INTO ata_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","mo ulosiꞌa xavi kalumo sou ikusaiꞌa ta uleenu masua. ");
INSERT INTO ata_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aneꞌi e mavulovexa vile mo mulelia tamei Anu musosovosiꞌa ne, ualaualasiꞌa aloxo ꞌo. Vile noxiꞌa ane Saimoni e Iesu mumoxoꞌu ualasou vile lexe Pita. ");
INSERT INTO ata_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Xe tameisiꞌa ilou tatalusiꞌa ane Iakovo, ilou vimou Ioanesi e Sevetaio ta ꞌolu. Iesu mumoxoꞌa ilou kalumo lexe Voanelexesi. Uala ane ne, laaxu lexe Leleꞌe ta ꞌolu. ");
INSERT INTO ata_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xe seꞌi noxiꞌa ane Andeleasi mo Pilipi mo Vatolomaio mo Mataio ilou Tomasi mo Iakovo e Alipaio ꞌolu mo Tataio mo Saimoni anu itema vile noxiꞌa ta mitema ane ixavutala lexe aneꞌi meꞌa isaxilaꞌu tualasiꞌa, ");
INSERT INTO ata_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mo Iudasi Isikarioti, anu e muꞌitalonu Iesu no avoꞌa ta mitema sou mivau. ");
INSERT INTO ata_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Xe Iesu mulivu muneꞌe sou muꞌunalai no tani la, la ta mitema tapiena misevile mineꞌe mipita noxou, la mole anu iloꞌa ta molomolo noxou ne, umomomo sou iꞌani la ua. ");
INSERT INTO ata_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Xe ta minuminu milomusou aꞌalosou xaixai e Anu muꞌoxoꞌoxonu ne, la milutu mineꞌe mixali noxou sou lexe ilivulixu. Xo ta mitema mivikala lexe Anu muxovulaulau. ");
INSERT INTO ata_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Xe ta mitema sou lapuloto meꞌa loxo ne Ielusalemu mitoꞌo mixali, la mivikala lexe, “Velesevulu ane uxolu noxou ne, la sou ane anu ukukusaiꞌa ta uleenu masua no anu xavi noxou ne. Xo anu Velesevulu ne, anu tila noxiꞌa ta uleenu masua ane.” ");
INSERT INTO ata_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Xe Iesu muavuti la muꞌavaliꞌa mineꞌe noxou sou muvikalaneꞌi no anu vaikala latilovo seꞌi aloxo ꞌo, “Loxovaa, Satani umomomo sou ukusau Satani? ");
INSERT INTO ata_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Xe lexe tuala vile ta mitema sou ikalikalipalaneꞌi sou iꞌotoꞌoto ngatongatoꞌo noxiꞌa, la tuala ne umomomo sou utulu pekiaꞌu uasi. ");
INSERT INTO ata_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mo lexe tani vile ta mitemasou kalumo ne ikalikalipalaneꞌi sou iꞌotoꞌoto ngatongatoꞌo noxiꞌa, la ta mitema sou tani ane ne, xoluxoluxaꞌa ne laixe uasi. ");
INSERT INTO ata_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ia lexe Satani ne, iloꞌa ta mitemau iꞌotoꞌoto mo ikalipala la anu xaviinu uasisi. ");
INSERT INTO ata_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mo anu manina lexe itema vile umasaxa sou uꞌunalai no taasou itema sou xavi vile sou unoꞌu miumiu, la anu laixe lexe anu usakisakiinu itema sou xavi ne tei o, ka sou anu uꞌunalai sou upakali itema ne miumiu.” ");
INSERT INTO ata_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Xe Iesu muvikala aloxo ne mukalu, la muavuti sou muvikalaneꞌi aloxo ꞌo la, “Eni avikalangengi manina musuku aloxo ꞌo, Lataua umomomo sou uxiu tumalouu ꞌiliꞌilixo masumasua mo vaivaikala masumasua noxiꞌa ta mitema ulai noxou. ");
INSERT INTO ata_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ia, anu ane uvikala masua ulai noxou Uleenu Tavuna ne, la Lataua umomomo sou uxiu tumalou vaimomo ꞌo mo iliꞌi uasisi manina. Susu noxou ne, uxolu avilesi.” ");
INSERT INTO ata_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu muvivikala mulai noxiꞌa aloxo ne, xo aneꞌi mivikala lexe uleenu masua vile ane uxolu noxou. ");
INSERT INTO ata_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesu uvivikalaneꞌi ta mitema aloxo ne, ia nenu iloꞌa ta vimovimou mineꞌe mo a itutulu no ale no tani e Anu uxoxolu no anu ne. Mineꞌe mitulu ane no ale nesi, ia mipalusou itema vile sou uꞌavalou lexe uneꞌe noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta mitema tavuꞌalo te mineꞌe mitaꞌolu mixaliliiou ne a ixoxolu no lia, ia mivikalanu lexe, “Nenine iloꞌa ta vivine a ikakamulineni, mo a itutulu no ale.” ");
INSERT INTO ata_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Xe Anu muavuti la mutaliꞌisiꞌa aloxo ꞌo, “ꞌEi ane nenilo iloꞌa ta vivilo ne?” ");
INSERT INTO ata_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","La muavuti sou iou muitisiꞌa ta mitema e itataꞌolu ixaliliiou ne ka muvikalaneꞌi aloxo ꞌo, “Ngamaisou, nenilo iloꞌa ta vivilo aneꞌi ꞌa. ");
INSERT INTO ata_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aneꞌi ane lexe imulinu masaxa noxou Lataua, la eni nenilo mo vivilo mulu ilee vivilo sema ane.” ");
INSERT INTO ata_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Xe iliꞌi, la Iesu musukusou tuala mo tani e Anu muxoxolu no anu ne, io Anu musuku mulai no kupa ne Xalilaia sou musoko sou ulosieixu ta mitema lavulavu la. La ta mitema tavuꞌalo misevile mineꞌe mixali noxou mole mitaataasou, la sou Anu muiliꞌe mutelai no uaxa sou mutalupexa no anu, ia ta mitema mitaꞌolu no nano no kupa paꞌumolu. ");
INSERT INTO ata_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mulosiꞌa lavulavu no anu mii piena misevile. Lavulavu ane Anu mulosiꞌa ne, anu mulailixu no anu vaikala latilovo mukalusi. No nano no anu vaikala noxou ne, Anu muvikala aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngalomu! Itema vile mulai no xaixu sou usuꞌanu ovu ngiaxu, ");
INSERT INTO ata_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","la seꞌi mulapalapau no voteꞌi, la ta ngiala mineꞌe miꞌou mukalusi. ");
INSERT INTO ata_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xe seꞌi mulapalapau no lia lavolavoꞌo, la mupau palea xo lia ne muxolu se teitexisi. ");
INSERT INTO ata_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ia aso muiei, la muxalo alaxu vilesisi xo uliꞌuliꞌu ulai no lia manina uasi. ");
INSERT INTO ata_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Seꞌi mulapalapau muluꞌe no xuxua tanutanu, xe muleme la xuxua ne mukupokuponu mole uneneꞌa ua. ");
INSERT INTO ata_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Xe seꞌi ne, mulapalapau muluꞌe no lia ane laixe, la muleme muxali tila sou muneneꞌa. Seꞌi muxalixu ngiaxu mavulovexa tatalu, xe seꞌi itemaxu tatalu xe seꞌi la itemaxu taꞌuve.” ");
INSERT INTO ata_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesu muvivikala latilovo mulai noxiꞌa ta mitema aloxo ne xe mukalu, la sou Anu muvikalaneꞌi aloxo ꞌo la, “Itema ane anu mulavu lexe anu sangalou a uxoxolu sou ulolomu no anu, la laixe lexe anu ulomusou vaikala ane ne no anu.” ");
INSERT INTO ata_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ta mitema milailai mukalu, ia Iesusi iloꞌa aneꞌi e mavulovexa vile mo mulelia tamei xe ta mitema seꞌi e iloꞌa ixoxolu ne, mineꞌe noxou sou mitaliꞌisou lexe tavaꞌu loxovaa la sou anu uvikala no anu vaikala latilovosi. ");
INSERT INTO ata_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","La sou Anu muvikalaneꞌi aloxo ꞌo, “Ngingi ne, Lataua mulosiengixu laaxu vaikala mutalume sou saxisaxilaꞌu noxou. Ia ta mitema vaꞌaxu ilomusou vaivaikala latala ne no anu vaikala latilovosi. ");
INSERT INTO ata_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mo sou, ‘aneꞌi imamalei ia imaisou mii vile uasi, mo ilolomu ia ilavusou mii vile uasi, mo ixiunu oponeꞌi sou Lataua uxiu tumalouu ꞌiliꞌilixo masua noxiꞌa uasi!’” ");
INSERT INTO ata_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Xe Anu muavuti la muvikalaneꞌi aloxo ꞌo la, “Vaikala latilovo e eni elemolu ꞌo, ulamana no xavutalamengi uasi? Ngingi ngaꞌoxo aloxo ne, la ngalavu no anu vaikala latilovo seꞌi laaxu a loxovaa? ");
INSERT INTO ata_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vaikala latilovo e eni elemolu ꞌo, anu laaxu aloxo ꞌo. Itema sou xai e musuꞌanu ovu ngiaxu ne, anu musuꞌanu vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vaikala ane anu musuꞌanu xe mulapau no voteꞌi ne, anu aloxo ta mitema ane milomusou vaikala noxou Lataua, ia Satani muneꞌe muxexenu vaikala ane Lataua mutounu no oponeꞌi alaxu vilesisi. ");
INSERT INTO ata_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Xe vaikala ane anu musuꞌanu xe mulapau no lia ane lavolavoꞌo ne, anu aloxo ta mitema ane ilomusou vaikala noxou Lataua la ipasipaa sou inoꞌu xe iꞌosasou. ");
INSERT INTO ata_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ia tavaꞌu xo uliꞌuliꞌa uasi, la vaikala ne uxoo maxuveni uasi. Xe no voxo ane loxo tuꞌutuꞌumaxu seꞌi uxali noxiꞌa xo aneꞌi minoꞌu Lataua vaikalau no oponeꞌi, la aneꞌi ilapau alaxu vilesisi. ");
INSERT INTO ata_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Xe vaikala ane anu musuꞌanu xe mulapau no xuxua tanu ne, anu loxo ta mitema ane ilomusou vaikala noxou Lataua ne, ");
INSERT INTO ata_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ia aneꞌi ixavutala piena no anu mauli ilou xoluxolu no lia ꞌo, mo imasaxa lexe iꞌa lavuluti piena mo oponeꞌi uisuisuxu mimii iouiou, la sou anu mimii ane ne uvaꞌusou vaikalau Lataua la uneneꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ia vaikala ane musuꞌanu xe mulapau no lia ane laixe ne, anu loxo ta mitema ane ilomusou vaikala noxou Lataua, la inoꞌu mo itetelisou la ineneꞌa. Seꞌi muxalixu ngiaxu mavulovexa tatalu, xe seꞌi itemaxu tatalu, xe seꞌi la itemaxu taꞌuve.” ");
INSERT INTO ata_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Xe Anu muavuti la muvikalaneꞌi aloxo ꞌo la, “Loxovaa, ngingi nganeꞌenu telu sou ngatalumeiou no anu pupuni? Mo ngamulaxu no luu laaxu? Uasi, ngatulusou teitexi no valovalosou sou ukaa. ");
INSERT INTO ata_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Xo mii maꞌia ane mutalume ne, ulai iliꞌi la upalaꞌa. Xe mii maꞌia ane misuꞌasou mo mitalumeiou ne, ulai iliꞌi la upalaꞌa. ");
INSERT INTO ata_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lexe itema ane mulavu lexe anu sangalou a uxolu sou anu ulolomu no anu, la laixe lexe anu ulomusou vaikala ane ne no anu.” ");
INSERT INTO ata_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Anu musolonu sou muvikalaneꞌi aloxo ꞌo la, “Vaikala maꞌia ane ngalomusou ne, ngalomusou laixe mo ngaxavutala no anu laixe. Mo mii maꞌia ane ngingi ngalosiꞌa ta mitema ne, ulai iliꞌi la ikolinu sou ilosinge, mo ilosinge seꞌi uai utelo no latanu la. ");
INSERT INTO ata_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Xe ꞌei ane iu mimii tavuꞌalo uai, la ilosou seꞌi uai utelo no latanu la. Ia ꞌei ane iu mimii se kituꞌasi, la ixexeenu noxou. ");
INSERT INTO ata_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xe muavuti la muvikalaneꞌi aloxo ꞌo la, “Saxisaxilaꞌu noxou Lataua ne, anu aloxo itema vile utapunu ame ngiaxu no lia. ");
INSERT INTO ata_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","No ꞌolovoxo, la anu uai xe no kakau la anu utulu sou uꞌoxonu xaixai seꞌi no aso, ia ame ngiaxu e anu mutapunu ne, mupau mo muleme. Ia anu itema ne ulavusou lexe ame ngiaxu ne mupau mo muleme a loxovaa uasi. ");
INSERT INTO ata_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lia molusi muꞌoxonu ame ngiaxu ne muleme, la sou muneneꞌa. Ame ngiaxu ne muleme, la sou mumuxaxu aiinu xe ngiangiaxu, xe iliꞌi la sou temanu. ");
INSERT INTO ata_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ia iliꞌi xe anu lingamo, la sou anu itema ne ulai uꞌelexu sou upitanu xo voxosou a muxali ne.” ");
INSERT INTO ata_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xe Iesu muavuti la muvikala aloxo ꞌo la, “Nenge talemolu saxisaxilaꞌu noxou Lataua lexe anu a loxo maꞌia mo tatilovosou no anu vaikala maꞌia?” ");
INSERT INTO ata_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","La sou muvikalaneꞌi aloxo ꞌo, “Saxisaxilaꞌu noxou Lataua ne, aloxo mii e ilemolu lexe masitati ngiaxu. Masitati ne, ngiaxu kituꞌa manina, itotou uluꞌelai no lia tanu. ");
INSERT INTO ata_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ia loxo itounu xe uavuti utelo la uleme toxoxaꞌa misevile, la uuaulixu laꞌilali iouiou ane mitounu no xai ne. Avoavolu ne toxotoxoxaꞌa mo uialaiala ulai no ale mole ta ngiala ineꞌe sou itaꞌotaꞌolu no maimaixu.” ");
INSERT INTO ata_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu muvikalaneꞌixu vaikala noxou Lataua no anu vaikala latilovo tavuꞌalo aloxo ꞌo ane mumomomo no ꞌa xavutalaiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Uvikalaneꞌixu vaikala vile vitanisi uasi, uvivikalaneꞌi ne uvikalaneꞌi no anu vaikala latilovosi. Ia loxo anu iloꞌa ta molomolo noxousi, la sou Anu ululusou vaivaikala laaxu noxou ne laixe ukalusi ulai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Xe no ꞌoloꞌolovoxo no voxo ane ne, la Anu muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Nengeꞌa talai loxo no kupa xalee ane vile.” ");
INSERT INTO ata_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Xe ta molomolo noxou ne, miavuti la miꞌumesiꞌa ta mitema te mineꞌe mipita sou milolomu vaivaikala noxou ne mixolu. Ia aneꞌi milai mitelo noxou Iesu no uaxa ane Anu uxoo no anu. Uaxauaxa seꞌi kalumo a iloꞌa milai no voxo ane ne. ");
INSERT INTO ata_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iloꞌa milalai xoo xe iliꞌi, la atume toxoxaꞌa muxalisiꞌa, la xasi muꞌokiꞌoki tani mole lexa muꞌunalai no uaxa tanu la ꞌalaꞌalai sou uꞌanaꞌana. ");
INSERT INTO ata_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ia Iesu ne, mulai mutixala no anu tixalasou mo muai no uaxa taꞌu. Xe ta molomolo noxou miavuti, la mitulusou la mivikalanu aloxo ꞌo, “Itema sou ulosixe lavulavu, nenge asou taꞌuoꞌuo, loxovaa taneninenge uasi?” ");
INSERT INTO ata_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Xe Anu muavuti la mutulu sou mukaitolonu atume ne, xe muvikalanu xasi lexe, “Naxoo tasiau! Mo naai seꞌisisi!” La atume ne, tasiau xe xasi ne, muai seꞌisisi. ");
INSERT INTO ata_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Xe muavuti la muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Loxovaa ane ngingi ngeꞌume malaxo loxo ꞌo? Loxovaa ngingi ngamuxamuxaxu tangengi noxilo uasi?” ");
INSERT INTO ata_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ia aneꞌi ne, miꞌume misevile mole italiꞌisiꞌa ngatongatoꞌo lexe, “Itema ano ꞌo ne, itema maꞌi loxo ꞌo? La sou atume ilou xasi milomuxusi ꞌo!” ");
INSERT INTO ata_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iloꞌa milalai xoo, xe milai mixali no kupa paꞌumolu xalee vile, la milai mixali no tuala ne Xelasene. ");
INSERT INTO ata_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Xe Iesu muiliꞌe muuatu no uaxa sou mulai no ale, la alaxu vilesisi sou itema vile uleenu vile masua muxolu noxou muneꞌe sou mualaxu Iesu molu loxo no lousiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Itema ne, ulavusou uxoxolu ane no lousiꞌa ta mitema, ia evile umomomo sou usakisakiinu no anu lalae mixaloxu uasi manina. ");
INSERT INTO ata_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Xo voxo seꞌi aneꞌi mitetelisou mo misakisakii avolu ilou tavaꞌu no anu ne, ia anu muloꞌe ne la lalae mixaloxu ne muxotoxoto vitanisi no avolu ilou tavaꞌu. Evile xaviinu umomomo noxou sou utetelisou la uasi. ");
INSERT INTO ata_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","No ꞌolovoxo mo no aso ne, anu ulai uxoxolu ane no lousiꞌa ta mitema mo no laxalaxaꞌilu sou uꞌavaꞌava, xe uxotoxotosou vasivasimolu no anu lavoꞌo anaanaxu. ");
INSERT INTO ata_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Xe anu iou mulaiiou Iesu e uao no paxa o, la muiave mulai noxou. Mulai muxali noxou sou mutangatulu muluꞌelai no talaxu. ");
INSERT INTO ata_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ia Iesu muvikalanu lexe, “Nini uleenu masua ane nexolu noxou itema ꞌo ne, naxexee noxou!” Xe anu itema ne muavuti, la muꞌava toxoxaꞌa mulai noxou Iesu aloxo ꞌo, “Iesu, nini Lataua e muxolu teitexi manina ꞌOlu, nemasaxa lexe naꞌoxonu maꞌia noxilo? Eni alingaine mo avikalaneni manina no iou Lataua lexe mamu sou naꞌoxole masua loxo ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Xe Iesu muavuti la mutaliꞌisou aloxo ꞌo, “Ualasine loxovaa?” La sou anu mukolinu lexe, “Eni ualasilo lexe Lexioni, xo nexi tavuꞌalo misevile.” ");
INSERT INTO ata_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Xe muavuti la mulinga pekiaꞌu mulai noxou Iesu alaxu piena sou lexe mamu sou upalusiꞌa ta uleenu masua ixexeesou tuala ane ne. ");
INSERT INTO ata_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ia ta memee laꞌoluxaꞌa vile toxoxaꞌa a iꞌaniꞌani no laxaꞌilu vile ꞌalai ne. ");
INSERT INTO ata_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","La sou ta uleenu masua ne, milinga pekiaꞌu noxou Iesu aloxo ꞌo, “Napalusixe talai noxiꞌa ta memee, ieni uvaxaixesi mo talai taꞌaisiꞌa.” ");
INSERT INTO ata_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","La sou mupelemasaxaneꞌi ta uleenu masua ne sou mixexeesou itema ne. Ia milai miꞌaisiꞌa ta memee ne. Ta memee laꞌoluxaꞌa ne, itiitisiꞌa muxali loxo itemaxu mavulovexa mavulovexa vile (2,000). Miiaꞌuxu muluꞌe no tavaꞌu maea e no kupa paꞌumolu ne, la miluꞌe miꞌuoꞌuo mole misoisoli mukalusi. ");
INSERT INTO ata_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ta mitema sou isaxisaxilaꞌa ta memee ne, mimaisou mii ane ne la miꞌumeꞌume sou milai miaꞌalo no tuala xe tuatuala ane muxoluxolu no paꞌupaꞌumolu tuala ne. La sou ta mitema sou tuatuala ne, mineꞌe sou mimaisou mii maꞌia ane muxali ne. ");
INSERT INTO ata_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mineꞌe xe mixali noxou Iesu, la mimaisou itema e Lexioni, ta uleenu masua tavuꞌalo miꞌaisou ne a mutokolomo mo a uxoxolu. Xavutalau ne, lamana ia uxovulaulau la uasi. Ta motu mimaisou aloxo ne, la mimamaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta mitema ane aneꞌi misaxilaꞌa ta memee ne, miaꞌaloiꞌa ta mitema ane ne no anu mii maꞌia ane muxali noxou itema e ta uleenu masua mixolu noxou ne, xe mii maꞌia ane muxali noxiꞌa ta memee kalumo. ");
INSERT INTO ata_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Xe ta mitema miavuti la mivikalanu Iesu pekiaꞌu lexe Anu ulutu mo uxexesou tualasiꞌa xalee ane ne. ");
INSERT INTO ata_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ioxe, Iesu asou utelai no uaxa, la itema e ta uleenu masua tavuꞌalo mixolu noxou ne, mutaliꞌisou pekiaꞌu lexe anu umulinu mo ilou ilai. ");
INSERT INTO ata_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ia Iesu umasaxa uasi, la muvikalanu lexe, “Nalai no tualasine mo nalai noxiꞌa ta minemineni mo naaꞌaloiꞌaxu mimii latala ane Tila tanuxene la muꞌoxonu noxine.” ");
INSERT INTO ata_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","La sou anu itema ne, mulai la musoko sou muaꞌalo ane no tuatuala e no xalee lia tila ne Dekapolisi. Muaꞌaloxu mimii tavuꞌalo e Iesu muꞌoxonu noxou ne. Xe ta mitema latala lai ne, milomu aloxo ne la mikuluke. ");
INSERT INTO ata_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Xe Iesu mulutu mutelo no uaxa sou mulivu mulai no kupa xalee vile. Mulai muxali, la Anu a uao uxoxolu no kupa paꞌumolu ne o, ia ta mitema tavuꞌalo misevile mineꞌe mixali noxou. ");
INSERT INTO ata_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","La sou itema vile ualasou lexe Iairo, anu itema sou usaxisaxilaꞌu taasou lalotu noxiꞌa ta Iutaia ne, muneꞌe muxali. Xe mumaisou Iesu, la mutangatulu muluꞌelai no talaxu sou ");
INSERT INTO ata_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mukatu pekiaꞌu mulai noxou, la muvikala aloxo ꞌo, “ꞌAlixeni sema kituꞌa ane asou isoli. Naneꞌe mo namuxaxu avone noxie mo sou ane imauli mo ixolu laixesi.” ");
INSERT INTO ata_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","La sou Iesu mulutu sou ilou milai. Ilou milai ne, la ta mitema tavuꞌalo ne mimulinu la mitomu loxo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mo sema vile a mineꞌe kalumo. Ane sema ne, mikulukemele la sialu ne ukalu noxie uasi. Muxolu tauu ie mavulovexa mo mulelia tamei. ");
INSERT INTO ata_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sema ne, milai mimaisiꞌa ta mitema sou pamauli tavuꞌalo, ia aneꞌi milosie tuꞌutuꞌumaxu tavuꞌalo. Mo ane mikalusou miemie sou milotoneꞌi no anu sou lexe ane laixene. Ia uasi. Pipiena noxie ne ukalu uasi, muxali muꞌoki masua manina. ");
INSERT INTO ata_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Xe ane milomusou aꞌalosou Iesu, la mineꞌe la mimuamuaꞌi iliꞌi no tumalou no taiineꞌi ta mitema tavuꞌalo te mineꞌe noxou Iesu ne, la mikasou tokolomou vevee. ");
INSERT INTO ata_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Xo ane tane muvikala lexe, “Lexe eni akasou tokolomousi, la eni laixeleli.” ");
INSERT INTO ata_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Xe alaxu vilesisi ꞌo, la sialu ne mutalo mole ane mixamuli no nano no vasimele lexe pipiena ane ne mukalu noxie. ");
INSERT INTO ata_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Xe alaxu vilesisi ꞌo, la Iesu muxamuli lexe xavi noxou seꞌi a muxexe noxou. La sou iou muxiu mulai iliꞌi noxiꞌa ta mitema tavuꞌalo te imulimulinu ne, la mutaliꞌisiꞌa aloxo ꞌo, “ꞌEi ane mukasou tokolomoxo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Xe ta molomolo noxou miavuti la mikolinu aloxo ꞌo, “Xo namaisiꞌa ta mitema e mitomu no tumaline ꞌo uasi? Ia loxovaa ane nini netaliꞌi lexe, ‘ꞌEi ane mukasilo ꞌo?’” ");
INSERT INTO ata_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ia Iesu a iou uxixaoxao ukakamuli sou lexe umaisou ꞌei ane mukasou tokolomoxu ne. ");
INSERT INTO ata_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Xe sema ne, milavu no anu mii ane muxali noxie ne, la mineꞌe mitangatulu muluꞌelai no talaxu Iesu, la ꞌume ilou ꞌoloꞌolo misevile. Xe miavuti la mivikalanu lamana manina no anu mii latala ane muxali noxie. ");
INSERT INTO ata_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Xe Anu muavuti la muvikalane aloxo ꞌo, “Vivilo, nini nemuxaxu taneni noxilo, la sou nemauli mukalu. Nalai la oponeni uai seꞌisisi. Pipiena ane muxolu noxine ne, anu ukalu.” ");
INSERT INTO ata_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu a uao uvivikala o, ia ta mitema seꞌi meꞌa no taasou Iairo, anu itema sou usaxisaxilaꞌu taasou lalotu noxiꞌa ta Iutaia, mineꞌe mivikalanu aloxo ꞌo, “ꞌIline sema ne a misoli ne, ia naꞌausou itema sou ulosiꞌa ta mitema lavulavu mamu.” ");
INSERT INTO ata_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ia Iesu mulomusou vaikalaiꞌa ne, la muvikalanu itema sou usaxisaxilaꞌu taasou lalotu noxiꞌa ta Iutaia aloxo ꞌo, “Nalomuxaꞌa mo naꞌoloꞌolo mamu. Namuxaxu taneni noxilosi.” ");
INSERT INTO ata_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Xe muavuti la munoꞌa Pita ilou Iakovo mo Ioanesi e Iakovo vimou sou iloꞌa milai. Xo Iesu umasaxa lexe evile umulineꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Milai xe mixali no taasou itema e usaxisaxilaꞌu taasou lalotu noxiꞌa ta Iutaia ne, la Iesu mumaisiꞌa ta mitema itatamasie Iairo ꞌolu la iungaunga xo mole xavutalaiꞌa muxovulaulau. ");
INSERT INTO ata_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu muꞌunalai no nano no tani xe muavuti la muvikalaneꞌi aloxo ꞌo, “Tavaꞌu loxovaa ane ngingi ngaungaunga xoo mole ngaxovulaulau loxo ꞌo? Molomolo ꞌo ne, isoli uasi. Ane iai ane.” ");
INSERT INTO ata_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iesu muvikala aloxo ne, la aneꞌi mikekeiou. Xe Anu muavuti la mukusaiꞌa milaalaa mukalusi, ia Anu munoꞌa mamie ilee nenie mo ta molomolo noxou tatalu sou iloꞌa miꞌunalai no nano no kapiutu ane ane molomolo iai no anu. ");
INSERT INTO ata_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Xe muavuti la mukasi vaxa no avole, ka sou muvikalane aloxo ꞌo, “Talita kumi!” Laaxu lexe, “Sema kituꞌa, avikalaneni lexe nini natulu!” ");
INSERT INTO ata_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Xe alaxu vilesisi ꞌo, la ane mitulu sou mimuamuaꞌi mixixaoxao. Tauu iexe loxo mavulovexa vile mo mulelia tamei. Xe ta mitema mimaisou mii ane ne, la mikuluke manina. ");
INSERT INTO ata_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ia Anu muvikala pekiaꞌu noxiꞌa lexe mamu sou ilai iaꞌaloiꞌa seꞌi no anu mii ane muxali noxie. Xe muxiu vaxa, la muvikalaneꞌi lexe ilosie laꞌilali sevile mo iꞌou. ");
INSERT INTO ata_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu muꞌumesou tuala ane ne, sou mulai no tuala noxou ne Nasaleti. La sou ta molomolo noxou mimulinu kalumo sou iloꞌa milai. ");
INSERT INTO ata_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aneꞌi mixali mixolu xe voxo Tavuna muxali, la Anu muꞌunalai no taasou lalotu noxiꞌa ta Iutaia lai ne, sou musoko sou mulosiꞌa ta mitema lavulavu. Ia aneꞌi tavuꞌalo e milomusou vaikala noxou ne, mikuluke manina la mitaliꞌi aloxo ꞌo, “Itema ane ꞌo, munoꞌu vaivaikala ne neꞌei? Mo lavulavu ane muxolu noxou ne, Anu lavulavu iou anevaa, mo loxovaa la Anu uꞌoxonu xaixai no anu xaviinu kalumo? ");
INSERT INTO ata_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nenge telavusou lexe Anu itema vile sou utulusou tani. Mo Anu Malia ꞌilie ane. Ta vimovimou ane Iakovo ilou Iosepu mo Iudasi ilou Saimoni. Mo ta vimovimou ta sema kalumo ane nengeꞌa taxoxolu ꞌo.” Mivivikala aloxo ne, la mixiu tumaliꞌa noxou mo imuxamuxaxu taneꞌi noxou uasi. ");
INSERT INTO ata_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Xe anu Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Itema sou palomatana ne, ta tema tualasou mo ta tulatulanu mo ta minuminu no nano no taasou ne, ilavusou itoxonu uasisi manina. Ia no tuatuala vaꞌavaꞌaxusi, ta mitema itoxonu misevile.” ");
INSERT INTO ata_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","La sou umomomo sou uꞌoxonu sosovo vile no tualasou ne uasi, ia mumuxaxu avolu noxiꞌa seꞌi ane pipiena muꞌoxoneꞌi sou mupamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","La Anu mukuluke noxiꞌa xo aneꞌi imuxaxu taneꞌi noxou uasi. Xe muavuti la mulai mumomoxu tuatuala no xalee lai ne, sou mulosiꞌa lavulavu no anu vaivaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Xe iliꞌi, la sou muꞌavaliꞌa ta molomolo mavulovexa vile mo mulelia tamei mineꞌe noxou sou mupalusiꞌa tametamei. Mulosiꞌa xavi sou ikusaiꞌa ta uleenu masumasua mixoo noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Xe muavuti la mupotoneꞌi aloxo ꞌo, “Ngalai, io nganoꞌu mii vile no anu muamuaꞌingenge ne uasi, ia nganoꞌu vilaxongengesi. Nganoꞌu laꞌilali mo tiva mo lamoli ngataanu no anu utupokongenge uasi. ");
INSERT INTO ata_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ngamulaxu siovesou tavaꞌingesi, xe ngataa tokolomo tamei uasi.” ");
INSERT INTO ata_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xe muavuti la muvikalaneꞌi la aloxo ꞌo, “Ngalai no tuala vile xe ngaꞌunalai no tani vile, la ngaxoxolu anesi, xoo mole umomomo no voxo ane sou ngingi ngaꞌumesou tuala ane ne. ");
INSERT INTO ata_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ia lexe ngalai xe ngaxali no tuala vile xe ta mitema sou tuala ane ne, iꞌavalinge mo inoꞌinge sou iꞌunalailingenge no tani uasi mo ilomungenge uasi, la ngavutasou lomulo no tavaꞌinge uxexee, io sou ngingi ngasukusou tuala ane ne. Ngaꞌoxo aloxo ne, mo sou aneꞌi ilavu lexe Lataua ulosiꞌa navunavu no anu ꞌilixo ane aneꞌi miꞌoxo noxinge ne.” ");
INSERT INTO ata_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ioxe, aneꞌi milomu noxou aloxo ne xe mukalu, la milutulutu sou milai miaꞌaloxu vaikala noxou Lataua sou lexe aneꞌi ilomusou la ixiunu oponeꞌi. ");
INSERT INTO ata_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aneꞌi milai, la mikusaiꞌa ta uleenu ta masumasua e mixolu noxiꞌa ta mitema, xe miluluunu lamalasile no vasimeꞌa aneꞌi ane vovolea iouiou muꞌoxoneꞌi kalumo sou mipamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ioxe, ta mitema mimaisou xaixai e Iesu muꞌoxonu ne, la sou milai miaꞌaloxu noxou tatanaanu tuala e Elodesi. Xo ta mitema tavuꞌalo milavusou Iesu ualasou. Ta mitema seꞌi mivikala lexe, “Ioanesi e ulavusou uꞌulosiꞌa ta mitema ne, musoli mo miꞌasixu ia mumauli mo a mutulu ne. La sou ane anu uꞌoxonu xaixai no anu xaviinu.” ");
INSERT INTO ata_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Seꞌi noxiꞌa mivikala lexe, “Anu Eliasi.” Xe seꞌi noxiꞌa la mivikala lexe, “Anu vile noxiꞌa ta mitema sou palomatana tatei ane.” ");
INSERT INTO ata_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ia anu Elodesi mulomusou vaikala ane ne, la muvikala aloxo ꞌo, “Ioanesi ne, eni exotonu xolanu ne, ia vaimomo ꞌo anu a mumauli mo ꞌa mutulu ne.” ");
INSERT INTO ata_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Xo tei, la anu Elodesi munoꞌe ou e Pilipi semau sou muꞌuluxe la sou Ioanesi muvikalanu lexe, “Nini neꞌoxonu ꞌilixo ane ne umomomo no anu lapuloto noxou Mosesi uasi, xo nini nenoꞌe vivine semau ane neꞌuluxene.” La sou Elodesi laꞌiaxu la mupalusiꞌa ta mitema sou milai mitetelisou ka misakisakiinu sou miꞌunalailixu mo mitatuxu no nano no taasou navunavu. ");
INSERT INTO ata_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","La sou ane Elodia opoone masuau Ioanesi ne misevile mo lexe ivau usoli, ia imomomo uasi. ");
INSERT INTO ata_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Xo Elodesi ne, umamaꞌu noxou Ioanesi mo ulavusou usaxilaꞌu xo anu mulavu lexe anu Ioanesi ne, anu itema mulapu mo anu noxou Lataua. Xe Elodesi mulomusou vaikala noxou, la anu muxavutala piena misevile mo opoo uai laixe uasi. Ia anu umasaxa lexe ulomusou vaikala noxou. ");
INSERT INTO ata_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ia Elodia ne, ane mixalisou voteꞌi sou ivau Ioanesi aloxo ꞌo. Voxo sou isosovosou voxo ane Elodesi nenu mivoꞌonu no anu muxali, la anu muꞌoxo laꞌilalixaꞌa ta mitema sou xaixai noxou, iloꞌa ta tatila noxiꞌa ta mitema sou ꞌotoꞌoto noxou mo ta tatila sie xalee lia tila ne Xalilaia. ");
INSERT INTO ata_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aneꞌi ta mitema ne ꞌa itataꞌolu mo iꞌaniꞌani, ia Elodia ꞌilie sema milutu sou miꞌunalai no nano no tani la milei no ieꞌi. Xe aneꞌi mimaisou leie la miisuxu misevile. La sou tatanaanu tuala ne, muavuti la muvikalane vuanga ne aloxo ꞌo, “Nemasaxau mii maꞌia la nalemo. La eni alosinesi.” ");
INSERT INTO ata_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","La sou musakii vaikala manina teitexi mulai noxie lexe, “Manina teitexi lexe nini namasaxau mii maꞌia noxilo xe nataliꞌisiloxu, la eni alosinesi. Mo lexe nini namasaxa lexe eni akalipalanu tuala noxilo sou uxali tamei mo alosine ngiou vile, la eni aꞌoxonusi.” ");
INSERT INTO ata_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Xe ane miavuti la milai no ale sou mitaliꞌisie nenie aloxo ꞌo, “Navikalalelixu mii maꞌia ane eni alemolu noxou sou ulosilo.” Xe nenie miavuti la mivikalane lexe, “Navikalanu lexe unoꞌu Ioanesi e itema sou uꞌulosiꞌa ta mitema, kisou mo ulosine.” ");
INSERT INTO ata_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ane milomu noxie nenie aloxo ne xe mukalu, la sou mipasipaa milivu miꞌunalai noxou tatanaanu tuala, la mivikalanu aloxo ꞌo, “Ane ꞌalalae ꞌosi, la eni emasaxa lexe nalosilo Ioanesi e itema sou uꞌulosiꞌa ta mitema, kisou uneꞌe noxilo. Namuxaxu no anu lakupapa ka nalosilo.” ");
INSERT INTO ata_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Xe tatananu tuala mulomu aloxo ne, la opoonu tuꞌumaxu misevile, ia umomomo sou uxiunu xavutalau uasi, xo anu uxavutala no anu vaikala e anu musakii manina teitexi mulai noxie sema ne, mo ta mitema e mineꞌeneꞌe sou laꞌilali ne milomusou. Mole pekiaꞌu noxou misevile sou uxiunu masaxa noxie. ");
INSERT INTO ata_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Xe alaxu vilesisi ꞌo, la anu mupalusou itema sou ꞌotoꞌoto noxou sou mulai munoꞌu Ioanesi kisou muneꞌe. Itema ne, mulai la muꞌunalai no taasou navunavu sou muxotonu Ioanesi xolanu, ");
INSERT INTO ata_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","la sou mumulaxu no anu lakupapa sou munoꞌu muneꞌe mulosie vuanga ne. La sou ane milai milosie nenie. ");
INSERT INTO ata_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Xe ta molomolo noxou Ioanesi, milomusou aꞌalosou mii ane Elodesi muꞌoxonu noxou ne, la sou aneꞌi mineꞌe sou minoꞌu vasimolu sou milai miꞌasixu no lousiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ioxe, ta mitema sou xaixai noxou Iesu milivu mineꞌe mitaꞌolu mixaliliiou Iesu. La sou miaꞌalouxu mimii ane aneꞌi miꞌoxonu mo milosiꞌa ta mitema lavulavu no anu vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Xe tavaꞌu xo ta mitema tapiena misevile ivaxa ineꞌe, la anu taii sevile sou aneꞌi iꞌani no anu uasi. La sou Iesu muvikalaneꞌi lexe, “Ioxe, nenge nengeꞌa talai no xalee tani vile e ta mitema seꞌi ixolu uasi mo tamaꞌila sevile o.” ");
INSERT INTO ata_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","La sou aneꞌisisi mitelai no uaxa sou milai no xalee tani vile e ta mitema seꞌi ixolu no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Xe iloꞌa milai xoo, ia ta mitema tapiena ne mimaisiꞌa la mitongoneꞌi. La sou meꞌa no xalexalee tuatuala mukalusi, miiaveiave sou milai mixali tei no xalee tani ane lexe aneꞌi Iesu iloꞌa ta molomolo ilai no anu. ");
INSERT INTO ata_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Xe aneꞌi mineꞌe mixali no kupa paꞌumolu no anu uaxa, la Iesu mumaisiꞌa ta mitema la tanuxaꞌa misevile, xo itaꞌotaꞌolu vitanisi loxo ta sipsip tatananeꞌi vile sou usaxisaxilaꞌa uasi. La sou Anu muavuti sou mulosiꞌa lavulavu piena no anu vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iloꞌa mixoxolu ane mole aso muluꞌelai, la sou ta molomolo noxou mineꞌe mixali noxou la mivikalanu aloxo ꞌo, “Nengeꞌa texolu ꞌo no xalee tani ane ꞌo e ta mitema seꞌi ixolu no anu uasi mo aso a uluꞌelai ukalu. ");
INSERT INTO ata_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","La anu laixe lexe nini napalusiꞌa ta mitema ꞌo mo ilai no tuatuala seꞌi ꞌalaꞌalai ꞌo mo, ilotoxaꞌa laꞌilali sou iꞌou.” ");
INSERT INTO ata_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ia Anu muavuti la mukolinu vaikalaiꞌa aloxo ꞌo, “Ngingi menge ngaitixaꞌa mii sou iꞌou.” Xe aneꞌi miavuti la mivikalanu aloxo ꞌo, “Nexi talai sou talotoxaꞌa laꞌilali no anu Denalia itemaxu mavulovexa vile (200) mo talosiꞌa? ");
INSERT INTO ata_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ia Anu muavuti la mutaliꞌisiꞌa aloxo ꞌo, “Veleti ta ꞌei a ngenoꞌu ne? Ngalai mo ngamaisou.” Milai xe mixalisou veleti taꞌuve xe ta sinana tamei, la sou milivu mineꞌe noxou Iesu, la mivikalanu lexe, “Nexi tenoꞌu veleti taꞌuve xe ta sinana tamei ano.” ");
INSERT INTO ata_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","La sou Iesu mupalusiꞌa sou mivikalaneꞌi ta mitema ne, sou mixoluxolu no lia laꞌolaꞌoluxaꞌa no iaꞌeiaꞌe vevesinu lailaixe ne. ");
INSERT INTO ata_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","La sou ta mitema ne mitaꞌolu no lia laꞌolaꞌoluxaꞌa itemaxu taꞌutaꞌuve xe mavulovexa taꞌutaꞌuve. ");
INSERT INTO ata_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mixoluxolu no lia mukalu, la sou anu Iesu munoꞌu veleti taꞌuve xe ta sinana tamei ne sou mutala mutelai no opo loxotolo sou muvikala laixe musuku mulai noxou Momu. Xe mukalu, la sou museꞌiseꞌi veleti ka mulosiꞌa ta molomolou sou mimilaꞌa noxiꞌa ta mitema ne, xe museꞌiseꞌi sinana ka mulosiꞌa ta molomolou sou miꞌoxo aloxo ne la. ");
INSERT INTO ata_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aneꞌi latala ne, miꞌaniꞌani xoo mole miꞌanaꞌana manina, ");
INSERT INTO ata_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","mole ikalusou uasi. La sou ta molomolo noxou minoꞌu lakela mavulovexa vile mo mulelia tamei sou mineꞌe mitaataa veleti ilou sinana paꞌupaꞌusou ane ikalusou uasi. ");
INSERT INTO ata_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Itiitisiꞌa ta mulusi ane, muxali loxo itemaxu mavulovexa mavulovexa tamei (4,000) mo itemaxu mavulovexa taꞌuve (1,000). ");
INSERT INTO ata_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Xe alaxu vilesisi ꞌo, la Iesu mupalusiꞌa ta molomolo noxou lexe itelai no uaxa sou iulaxunu ilai ne Vetesaida no kupa paꞌumolu xalee levi, ia Anu muxolu sou mupalusiꞌa ta mitema sou milivulivu. ");
INSERT INTO ata_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Xe mupalusiꞌa ta mitema sou milailai mukalu, la sou Anu mutelai no laxaꞌilu vile sou mulinga. ");
INSERT INTO ata_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Xe no ꞌoloꞌolovoxo manina, la uaxa e ta molomolo noxou mitelo no anu ne, mulalai xoo mole mulai muxali no kupa lixinu manina. Ia Iesu anusisi muxoo no lia. ");
INSERT INTO ata_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anu iou mulai la mumaisiꞌa mine aneꞌi kikipalineꞌi sou ivovole uaxa ilalai, xo atume xaviinu molu no talaxaꞌa sou ulivulivusiꞌa. Xe ꞌalaꞌalai sou lamana ukekea, la anu Iesu mumuamuaꞌi teitexi no lexa loxoꞌu sou mulai noxiꞌa. Mumuamuaꞌi mulai, la sou lexe upolopepeeneꞌi, ");
INSERT INTO ata_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","xe aneꞌi mimaisou mine Anu mumuamuaꞌi no lexa loxoꞌu loxo ne, la miꞌume la taneꞌi kalaua xo mixavutala lexe male ulee xaleꞌa vile ane, la miungaunga. ");
INSERT INTO ata_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Xe Anu muavuti la mupasipaa muvikalaneꞌi alaxu vilesisi lexe, “Ngaꞌume mamu! Pekiꞌainge! Xo enisi ꞌa!” ");
INSERT INTO ata_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Muvikalaneꞌi aloxo ne xe mukalu, la sou mutelai noxiꞌa no uaxa sila atume ne tasiau. Xe aneꞌi mimaisou atume mine tasiauxu loxo ne, la mikuluke manina, ");
INSERT INTO ata_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","xo mimaisou veleti e mulosiꞌa ta mitema tapiena musuku miꞌou, ia aneꞌi ilamana laixe no anu mo taneꞌi utaxunu uasi. Xo xavutalaiꞌa mutomu sio. ");
INSERT INTO ata_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iloꞌa mixisaꞌisou kupa ne, xe milai mixali xalee vile ne Xenesaleti, la milea lavoꞌosou muluꞌelai mole uaxa mupuapuatisi. ");
INSERT INTO ata_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Xe miavuti la miuatuuatulai no ale, la alaxu vilesisi ta mitema mimaisou Iesu la mitongonu. ");
INSERT INTO ata_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","La sou aneꞌi ta mitema miiaveiave no tuatuala no xalee lia ne Xenesaleti ne sou mitavuleneꞌi ta mitema ane vovolea iouiou muꞌoxoneꞌi no luusiꞌa sou mineꞌeneꞌi noxou Iesu. Xo aneꞌi ilavu lexe Iesu a uxolu no tuala neꞌei, la aneꞌi imulunu sou ilai. ");
INSERT INTO ata_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","No nano no tuatuala kitukitu mo ane ta tatila mo no ale no xalexalee lia ane Iesu umuamuaꞌi no anu ne, ta mitema itavuleneꞌi aneꞌi ane vovolea iouiou muꞌoxoꞌoxoneꞌi ne sou ilai iaisiꞌa no tani e ilotoloto laꞌilali no anu. Xe Anu muneꞌe, la aneꞌi milingau sou lexe iou uvaxaiꞌasi mo aneꞌi imulaxu avoꞌa no anu tokolomoxu telexusi. Aneꞌi latala e mikasou ne, aneꞌi mimauli mukalusi. ");
INSERT INTO ata_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Alaxu vile, la ta Palisaio iloꞌa ta mitema sou lapuloto seꞌi meꞌa loxo ne Ielusalemu mineꞌe mitaꞌolu mixaliliiou Iesu. ");
INSERT INTO ata_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","La mimaisiꞌa ta molomolo noxou seꞌi iꞌaniꞌani, ia imulinu lapuloto noxiꞌa ta Iutaia sou iꞌuinu avoꞌa tei o ka iꞌaniꞌani uasi. ");
INSERT INTO ata_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Xo ta Palisaio iloꞌa ta Iutaia ne, ilavusou iꞌani vitanisi uasi, iꞌuinu avoꞌa tei o ka sou iꞌani. Aneꞌi imulinu lapuloto noxiꞌa ta xaixasiꞌa tatei. Ia lexe iꞌuinu avoꞌa uasi, la umomomo sou iꞌani uasi. ");
INSERT INTO ata_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mo ilai no tani sou ilotoloto laꞌilali no anu ne, xe ilivu ixali ia iꞌulo uasi, la umomomo sou iꞌani uasi. ꞌIliꞌilixo seꞌi piena kalumo a imumulinu loxo, iꞌuinu pakuxaꞌa ilou lexa vexasou mo latotope. ");
INSERT INTO ata_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","La sou ta Palisaio iloꞌa ta mitema sou lapuloto ne, miavuti la mitaliꞌisou Iesu aloxo ꞌo, “Tavaꞌu loxovaa, la ta molomolo noxine imulinu lapuloto noxiꞌa ta xaixasinge mo iꞌuinu avoꞌa o ka iꞌani ua, io iꞌani no anu avoꞌa nuniꞌu loxo ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Xe Anu muavuti la mukolineꞌi aloxo ꞌo, “Itema sou palomatana, Aisaia muvikalangengi ngingi ta mitema sou kalavoi, la vaikala noxou ne manina. Anu mukaukavunu aloxo ꞌo, ‘Ta mitema ano ꞌo ne, iꞌitinu ualasilo no anaxaꞌa vitanisi, ia taneꞌi ne muxoo no paxa noxilo manina. ");
INSERT INTO ata_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ilotu noxilo ne, ia lalotuiꞌa ne maninasou uasi, kalavoisi. Xo ilosieixu ta mitema lapuloto, ia lapuloto ane ne molu noxou Lataua uasi, molu noxiꞌa ta mitemasi.’ ");
INSERT INTO ata_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mo ngexovulaunu lapuloto noxou Lataua ne, ia lapuloto noxiꞌa ta mitemasi ane ngetetelisou pekiaꞌu ne.” ");
INSERT INTO ata_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Xe muavuti la muvikalaneꞌi la aloxo ꞌo, “Ngingi ngexiu tumalingeu lapuloto noxou Lataua, ia ngemulinu lapuloto noxiꞌa ta xaixasinge. ");
INSERT INTO ata_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesi muvikala tatei aloxo ꞌo, ‘Natoxoneꞌi mamine ilee nenine.’ Mo ‘Anu ane uleanu vaikala seꞌi masua ulai noxiꞌa momu ilee nenu, la anu uulua.’ ");
INSERT INTO ata_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ia ngingi ngevikala lexe, itema vile uvikalaneꞌi momu ilee nenu lexe, ‘Suꞌuli maꞌi ane lexe ngingi ngongou nganoꞌu noxilo ne anu ulai noxou Lataua.’ ");
INSERT INTO ata_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","io ngingi iengi uvaxausi mo anu uꞌoxonu mii vile loxo ꞌo xaꞌa momu ilee nenu ua, ");
INSERT INTO ata_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ngingi ngepolovilenu vaivaikala noxou Lataua laaxu sou ngelai ngeꞌunanu no anu lapuloto noxiꞌa ta xaixasinge ilou lavulavuiꞌa ane ngenoꞌu muxolu noxinge mo ngemulinu mutalo vaimomo ꞌo. Mo mimii piena ne ngeꞌoxo aloxo ne mukalusi.” ");
INSERT INTO ata_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Xe muavuti la, la muꞌavaliꞌa ta mitema tavuꞌalo ne mineꞌe noxou mukalusi, sou muvikalaneꞌi aloxo ꞌo, “Ngingi latala ne, ngalomu laixe uneꞌe noxilo, mo sou ngalavu laixe no anu mii ano ꞌo. ");
INSERT INTO ata_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mii ane molu vaꞌaxu, ia uꞌunalai noxou itema vile, la mii ane ne umomomo sou uꞌoxonu itema ne masua uasi manina. Ia lexe mii ulaa noxou itema tanu ulai no ale, la sou anu mii ane ne, anu uꞌoxo masuanu itema ne.” ");
INSERT INTO ata_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu mulosiꞌa ta mitema latala ne lavulavu ane ne xe mukalu, la sou muꞌumesiꞌa sou muꞌunalai no tani. Xe ta molomolo noxou miavuti la mitaliꞌisouxu laaxu vaikala latilovo ane ne. ");
INSERT INTO ata_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Xe Anu muavuti la mutaliꞌisiꞌa aloxo ꞌo, “Loxovaa, kisinge mutomu? Ngalavu lexe mii molu vaꞌaxu ia uꞌunalai noxou itema vile, la anu umomomo sou uꞌoxonu itema ne masua uasi? ");
INSERT INTO ata_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Xo mii ane ne, uꞌunalai noxou itema tanu uasi, uꞌunalai no opoonu mole ulai la ulaa uuatu no ale la.” Vaikala ane Iesu mulemolu ꞌo, anu laaxu lexe laꞌilali tavuꞌalo ne lailaixe mukalusi. ");
INSERT INTO ata_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xe Iesu muavuti la musolo vaikala aloxo ꞌo la, “Mii ane molu noxou itema tanu, ia ulaa uuatu, ane uꞌoxo masuanu itema ane ne. ");
INSERT INTO ata_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Xo no nano no tanu itema ne, ꞌiliꞌilixo loxo, xavutala masumasua, mo ꞌilixo sou voteꞌi mo pakali mo uvau itema usoli mo ꞌilixo ane loxo mulu ulai noxie sema mitaulaꞌi xe sema ilai noxou mulu mutaulaꞌi ");
INSERT INTO ata_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mo umasaxau mimii tavuꞌalo mo opoo masua mo kalavoi mo uisuxu mimii iouiou mo usaꞌisaꞌisou itema mo uꞌiti ualasou mo uxovulaulau. ");
INSERT INTO ata_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ꞌIliꞌilixo masumasua ane ne, uxolu no nano noxou itema, ia ulaa uuatu la uꞌoxonu anu itema ne uxali masua.” ");
INSERT INTO ata_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xe Iesu muavuti, la musukusou tuala e muneꞌe muxolu no anu ne, sou mulai loxo ꞌalai no tuala ne Taia. Mulai xe muxali, la muꞌunalai no tani vile. Ia Anu umasaxa lexe evile ulavusou lexe Anu a uxolu no nano no tani uasi. Ia, umomomo sou Anu uxolu utalume uasi. ");
INSERT INTO ata_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ioxe, sema vile lai ne, milomu lexe Iesu a muneꞌe muxolu no tani ne, la alaxu vilesisi, milai noxou ka mitangatulu muluꞌelai no talaxu, xo ꞌilie sema vile kituꞌa ne uleenu vile masua muxolu noxie. ");
INSERT INTO ata_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","La milingau pekiaꞌu sou lexe Anu ukusau uleenu masua e uxoxolu noxie ꞌilie ne. Ane sema ne, sema Xiliki. Mivoꞌone no xalee lia tila ne Ponisia no tuala tila ne Silia. ");
INSERT INTO ata_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Xe anu Iesu muavuti la muvikalane sema ne aloxo ꞌo, “Ieni uvaxaiꞌa ta molomolo mo iꞌou laꞌilali e mimasaxa lexe iꞌou ne ukalusi. Xo anu umomomo sou tanoꞌu laꞌilalixaꞌa ta molomolo ne ka taleanu uluꞌelai noxiꞌa ta aꞌaa uasi.” ");
INSERT INTO ata_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Xe ane sema miavuti la mikolinu vaikala noxou aloxo ꞌo, “Ani, Tila, ia ta aꞌaa ane ixolu no laaxu luu sou laꞌilali ne, iꞌoꞌou ta molomolo laꞌilalixaꞌa utuutuxu.” ");
INSERT INTO ata_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Xe Iesu muavuti la muvikalane aloxo ꞌo la, “Tavaꞌu xo nini nevikala aloxo ne sou nekolinu vaikala noxilo, la anu laixe nini nalai, uleenu masua e muxolu noxie ꞌiline ne, muxexe noxie.” ");
INSERT INTO ata_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ane milutu la milai no taasie xe miꞌunalai, la ꞌilie ne, ꞌa iai no luusie, ia uleenu masua ne muxexesie. ");
INSERT INTO ata_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Xe iliꞌi, la sou anu Iesu musuku sou mutoꞌo loxo ne Saidoni ka mulivu mununalai loxo no kupa ne Xalilaia, la sou mulai loxo no xalee lia tila ne Dekapolisi. ");
INSERT INTO ata_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mulai xe muxali, la ta mitema seꞌi minoꞌu itema vile, sangalou ilou anaxu mutomu sou mineꞌenu noxou. Mineꞌenu la milingau sou lexe umuxaxu avolu uvaxa no vasimolu. ");
INSERT INTO ata_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu muavuti la munoꞌu itema ne mulailixu vaꞌaxu noxiꞌa ta mitema ane mineꞌe mipita ne. Xe muavuti la mutaloxu avolu simisou vaxa no sangalou taxataxanu. Xe muꞌoxonu aloxo ne mukalu, la sou mutuve vaxa no avolu simisou ka mumuxaxu avolu simisou ne vaxa no levexu. ");
INSERT INTO ata_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ka sou Anu iou mulai teitexi no opo loxotolo xe muee muaxu tila, la sou muvikalanu lexe, “Epata!” Vaikala ne, laaxu lexe, “Nakisi!” ");
INSERT INTO ata_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Xe alaxu vilesisi ꞌo, la itema ne, sangalou mukisi sou mulomu, xe levexu ne papaxe sou muvikala laixe. ");
INSERT INTO ata_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu muavuti la muvikalaneꞌi pekiaꞌu lexe mamu sou ivikalanu itema vile no anu mii ane aneꞌi mimaisou. Ia ilomuxu uasi. Iesu muvikalaneꞌi aloxo ne alaxu tavuꞌalo, ia aneꞌi iaꞌaloiꞌa mo iaꞌaloiꞌa ta mitema alaxu tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ta mitema milomusou aꞌalo sou xaixai noxou Iesu ne, la mikuluke no anu, la mivikala lexe, “Mimii tavuꞌalo e muꞌoxonu ne, muꞌoxonu la muxali laixesi. Aneꞌi ane ilolomu mo ivivikala uasi ne, mupamaulineꞌi mukalusi.” ");
INSERT INTO ata_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","No nano no voxovoxo ane Iesu muxaxai no anu ne, la ta mitema seꞌi tavuꞌalo la mixali mipita noxou Iesu, mole xaꞌa laꞌilali sou iꞌou uasi. La sou Anu muꞌavaliꞌa ta molomolo noxou la muvikalaneꞌi aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Eni talelixaꞌa ta mitema ꞌo misevile xo mineꞌe mixolu noxilo voxo tatalu mukalu, ia xaꞌa mii loxo ꞌo sou iꞌou uasi. ");
INSERT INTO ata_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ia lexe eni apalusiꞌa sou ilivu ilai no tuatualasiꞌa vitanisi, la ilapalapau no voteꞌi xo seꞌi ne, milutu no paxapaxa ane mineꞌe mixali ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xe aneꞌi miavuti la mikolinu vaikalau aloxo ꞌo, “Mole nenge ꞌei ane sou unoꞌu laꞌilali lai no xalee lia vitanisi e nenge teneꞌe texolu no anu ꞌo mo talosiꞌa sou iꞌou?” ");
INSERT INTO ata_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xe Anu muavuti la mutaliꞌisiꞌa aloxo ꞌo, “Xo veleti ta ꞌei ane ngingi ngenonoꞌu ne?” Aneꞌi mikolinu lexe, “Muxatele tameisi.” ");
INSERT INTO ata_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Anu muavuti la muvikalaneꞌi ta mitema tavuꞌalo ne sou mixoluxolu no lia. Mixoluxolu no lia mukalu, la sou Anu munoꞌu veleti muxatele tamei ne sou muvikala laixe musuku mulai noxou Momu xe mukalu, la sou museꞌiseꞌi sou mulosiꞌa ta molomolo noxou sou mimilaꞌa noxiꞌa ta mitema ne. La aneꞌi miꞌoxonu loxo Anu mupalusiꞌaxu ne. ");
INSERT INTO ata_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xe muavuti la munoꞌu sinana moso e minonoꞌu ilou veleti ne sou muvikala laixe musuku mulai noxou Momu xe mukalu, la sou muvikalaneꞌi ta molomolo noxou lexe imilaꞌanu noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ta mitema miꞌaniꞌani xoo mole miꞌanaꞌana. Xe iliꞌi, la sou ta molomolo noxou minoꞌu lakela muxatele tamei sou mineꞌe mitaataa laꞌilali paꞌupaꞌusou ne no anu. ");
INSERT INTO ata_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ta mitema ane mineꞌe mixali noxou Iesu no voxo ane ne, itiitisiꞌa muxali loxo itemaxu mavulovexa mavulovexa tamei (4,000). Miꞌani mukalu, la sou Iesu mupalusiꞌa sou milivulivu, ");
INSERT INTO ata_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ia alaxu vilesisi ꞌo, la iloꞌa ta molomolo noxou mitelo no uaxa sou milai no xalee lia ne Dalumanuta. ");
INSERT INTO ata_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xe aneꞌi mixali, la ta Palisaio mineꞌe mixali noxou. La misoko sou mitaliꞌisou Iesu sou lexe itovonu. Aneꞌi miavuti la mitaliꞌisou sou lexe Anu uꞌoxonu sosovo vile molu no opo loxotolo mo imaisou. ");
INSERT INTO ata_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Xe Anu mulomusiꞌa aloxo ne, la muee tanu la muvikala aloxo ꞌo, “Tavaꞌu loxovaa ane ta mitema vaimomo ꞌo imasaxa lexe imaisou sosovo vile molu teitexi no opo loxotolo o? Eni avikalangengi manina aloxo ꞌo. Umomomo sou aneꞌi imaisou sosovo vile uasi manina.” ");
INSERT INTO ata_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Xe muavuti ꞌo, la muꞌitaloneꞌi ta mitema, ia Anu iloꞌa ta molomolou mitelai no uaxa sou mixisaꞌi milai no kupa paꞌumolu xalee levi. ");
INSERT INTO ata_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta molomolo noxou ne, ieꞌi siꞌisou veleti mole inoꞌu tavuꞌalo uasi, minoꞌu vilesisi a uai no nano no uaxa. ");
INSERT INTO ata_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu muavuti la mupelaꞌa aloxo ꞌo, “Ngasaxilaꞌinge laixe no anu ꞌilixo noxiꞌa ta Palisaio mo ane noxou Elodesi, xo upoloinge la uꞌoxo masuangengi loxo uꞌoxo masuanu veleti.” ");
INSERT INTO ata_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aneꞌi milomu noxou aloxo ne, la mivikalaneꞌi ngatongatoꞌo lexe, “Male Anu muvikalanenge aloxo ne, xo nenge tanoꞌu veleti tavuꞌalo uasi.” ");
INSERT INTO ata_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aneꞌi milai la miꞌotosou anaxaꞌau vaikala noxou ne, la Anu mulavu. La sou Anu mutaliꞌisiꞌa aloxo ꞌo, “Tavaꞌu loxovaa ane ngingi ngevikala lexe ngingi nganoꞌu veleti tavuꞌalo uasi? Loxovaa, ngingi ngalavusou uao? Mo loxovaa xavutalamengi mutomu? ");
INSERT INTO ata_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mo iengi a uxolu, ia male ngamalei uasi? Mo sangalinge a uxolu ia ngalomu no anu uasi? Mo ngaxavutala uasi? ");
INSERT INTO ata_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","No voxo ane eni eseꞌiseꞌi veleti taꞌuve xaꞌa ta mulu itemaxu mavulovexa mavulovexa tamei mo itemaxu mavulovexa taꞌuve (5,000), la paꞌupaꞌusou ngetaanu ne, lakela sou ta ꞌei?” La aneꞌi mikolinu lexe, “Mavulovexa vile mo mulelia tamei.” ");
INSERT INTO ata_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xe muavuti la mutaliꞌisiꞌa aloxo ꞌo la, “Xe no voxo ane eni eseꞌiseꞌi veleti muxatele tamei xaꞌa ta mitema itemaxu mavulovexa mavulovexa tamei (4,000), la paꞌupaꞌusou ne, ngetaanu lakela sou ta ꞌei?” La aneꞌi mikolinu lexe, “Muxatele tamei.” ");
INSERT INTO ata_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Xe Anu muavuti la muvikalaneꞌi lexe, “Loxovaa, ngingi ngalavu uao?” ");
INSERT INTO ata_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Xe iloꞌa milutu la milai mixali ne Vetesaida, la ta mitema seꞌi minoꞌu itema vile ne iou seleveenu sou mineꞌenu noxou. Mineꞌenu xe mixalixu noxou, la milinga pekiaꞌu sou lexe umuxaxu avolu vaxa noxou mo upamaulinu. ");
INSERT INTO ata_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xe Iesu muavuti la mukasi vaxa no avolu itema ne, ka mutilaꞌu sou ilou milai no ale no tuala. Ilou milai xe mutuve vaxa no iou mukalu, la mumuxaxu avolu vaxa noxou, io sou mutaliꞌisou aloxo ꞌo, “Loxovaa, nemaisou mii vile?” ");
INSERT INTO ata_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Xe itema ꞌo musuꞌa iou loxo ꞌo xe muavuti la muvikala lexe, “Emaisiꞌa ta mitema, aneꞌi loxo ovuovu ivavaxa ineneꞌe.” ");
INSERT INTO ata_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Xe Iesu muavuti la, la mumuxaxu avolu vaxa noxou itema iou la, la sou iou mukaa avile mole saxisaxi noxou ne, muxali laixe. Mimii ne, mumaisou la lamana ukalusi. ");
INSERT INTO ata_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu muavuti la mupalusou sou mulivu no tani noxou xe muvikalanu lexe umomomo sou ulivu uꞌunalai no tuala la uasi. ");
INSERT INTO ata_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Xe iliꞌi, la sou Anu iloꞌa ta molomolo noxou milai no tuatuala ane muxoluxolu ꞌalaꞌalai no tuala ne Kaisalia Pilipi. Iloꞌa milai xe no voteꞌi, la mutaliꞌisiꞌa aloxo ꞌo, “Ta mitema ilavusou ivikala lexe eni ꞌei?” ");
INSERT INTO ata_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xe aneꞌi miavuti la mikolinu lexe, “Seꞌi ivikala lexe nini Ioanesi, itema sou uꞌulosiꞌa ta mitema, xe seꞌi ivikala lexe nini Eliasi, xe seꞌi la ivikala lexe nini vile noxiꞌa ta mitema sou palomatana.” ");
INSERT INTO ata_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Xe Anu muavuti, la mutaliꞌi vaxa noxiꞌa aloxo ꞌo, “Ia, ngingi la ngingi ngavikala lexe eni ꞌei?” Xe Pita muavuti la mukolinu aloxo ꞌo, “Nini ne, nini Kalisito ane.” ");
INSERT INTO ata_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Xe anu Iesu muavuti la mupelaꞌa lexe mamu sou ipalaꞌalixu noxou evile. ");
INSERT INTO ata_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ioxe, Iesu musoko sou mulosiꞌa lavulavu lexe ulai iliꞌi, la Itema ꞌOlu ne, utavule navunavu piena misevile. Ta tatila iloꞌa ta tatila noxiꞌa ta ailiꞌi mo ta mitema sou lapuloto ne, ixiunu tumaliꞌau la ivau usoli. Uai no lulu voxo vile mo tamei xe tatalusou, la sou Anu utulu. ");
INSERT INTO ata_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Anu molu muvikala lamana laixe noxiꞌa aloxo ne, la sou Pita munoꞌu mulailixu vaꞌaxu sou mukaitolonu. ");
INSERT INTO ata_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Xe Anu muavuti, la iou mulai noxiꞌa ta molomolo noxou, sou muvikala teitexi noxou Pita aloxo ꞌo, “Satani! Nalai iliꞌi no tumalilo. Nini naxavutala mii noxou Lataua uasi, nini nexavutala mii noxiꞌa ta mitemasi.” ");
INSERT INTO ata_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Xe muavuti la muꞌavaliꞌa ta mitema e mineꞌe mipita ne iloꞌa ta molomolo noxou sou muvikalaneꞌi aloxo ꞌo, “Lexe evile umasaxa lexe umulileli, la anu uxiunu tumalouu masaxa noxou, ia uneꞌe mo utavulenu tuꞌutuꞌumaxu loxo eni etavulenu mo umulileli, mo usoli loxo eni asoli. ");
INSERT INTO ata_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Xo itema ane tanuxu maulixu ne, ulai iliꞌi la uxovulaunu maulixu. Ia itema ane tanuxu maulixu uasi, uꞌitalonu maulixu uneꞌe noxilo mo aꞌalo laixe noxilo, la anu umauli. ");
INSERT INTO ata_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ia lexe itema vile unoꞌu mimii latala sou lia ꞌo ukalusi, xe uxovulaunu uleenu, la mimii sou lia ane anu unoꞌu ne, usuꞌulinu a loxovaa? ");
INSERT INTO ata_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mii maꞌia ane sou anu ulotonu uleenu no anu sou ulivulixu? ");
INSERT INTO ata_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ta mitema vaimomo ꞌo, mixiu tumaliꞌa noxou Lataua mo iꞌoxoꞌoxonu ꞌiliꞌilixo masumasua. Xe itema ane umaela noxilo mo no anu vaikala noxilo, la no voxo ane sou Itema ꞌOlu ulivu uneꞌe no anu lamana noxou Momu mo iloꞌa ta angelo noxou Momu, la anu umaela noxou itema ne kalumo.” ");
INSERT INTO ata_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Xe muavuti la muvikalaneꞌi aloxo ꞌo la, “Eni avikalangengi manina aloxo ꞌo, ta mitema seꞌi ane itutulu ꞌo, ulai iliꞌi la umomomo sou isoli uao, ixoxolu sio mo imaisou saxisaxilaꞌu noxou Lataua uxali ilou xaviinu.” ");
INSERT INTO ata_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ioxe iloꞌa mixolu xe voxo muxatele vile mukalu, la sou anu Iesu munoꞌa Pita ilou Iakovo mo Ioanesi sou muulaxuneꞌi sou iloꞌa milai no laxaꞌilu vile teitexi manina mole aneꞌisisi milai mixolu ane. Iloꞌa mixoxolusi xe mimalei loxo ꞌo, la Iesu vasivasimolu ne muxiu mo muxali iou vilemo manina. ");
INSERT INTO ata_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tokolomoxu ne, muxali iou vilemo mo muxali lamanaxu. Evile sou tuala no lia ꞌo umomomo sou uꞌuinu tokolomo ane ne, la uxali maenaxu laixe manina aloxo ne uasi. ");
INSERT INTO ata_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Xe mimalei loxo ꞌo, la mimaisiꞌa Eliasi ilou Mosesi mipaa mixali mitulu no paꞌumolu Iesu sou iloꞌa mivivikala. ");
INSERT INTO ata_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita muavuti la muvikala vaxa noxou Iesu aloxo ꞌo, “Rabi, anu laixe noxixe lexe nexi taxolu ano ꞌo mo taꞌalaxu tani alelexu tatalu. Nini sine vile, Mosesi sou vile xe Eliasi sou vile.” ");
INSERT INTO ata_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita muvikala aloxo ne, xo anu iloꞌa tamei ne mimamaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Xe tamuxala vile muneꞌe la mukuponeꞌi mukalusi, la aneꞌi milomusou vaikala mupaa no nano no anu tamuxala tanu la muvikala aloxo ꞌo, “Eni ꞌalixeni ano, amasaxau misevile. Ngalomuxu vaikalau.” ");
INSERT INTO ata_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Alaxu vilesisi ꞌo, la aneꞌi mimamalei ia imaisou evile la uasi, Iesusi ꞌa ututulu. ");
INSERT INTO ata_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ioxe, iloꞌa miavuti, la sou iloꞌa misuku sou laxaꞌilu ne sou miluꞌe. Xe no mine iloꞌa miluluꞌe, la Anu mupelaꞌa lexe mamu sou iaꞌalou evile no anu mii ane aneꞌi mimaisou ne, mole ulai utalo no voxo ane Itema ꞌOlu utulu molu no anu lousou. ");
INSERT INTO ata_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aneꞌi milomu noxou aloxo ne, la ivikalanu vile uasi, mii sou taneꞌi vilevilesi. Ia aneꞌi mivivikalasou vaikala mautunu e lexe, “Utulu molu no anu lousou.” lexe laaxu a loxovaa. ");
INSERT INTO ata_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Xe miavuti la mitaliꞌisou aloxo ꞌo, “Tavaꞌu loxovaa, la ta mitema sou lapuloto ivikala lexe Eliasi anu uxali tei?” ");
INSERT INTO ata_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Xe Iesu muavuti la mukoli taliꞌi noxiꞌa aloxo ꞌo, “Vaikala ane ne manina. Eliasi ne, uxali tei sou umomosou mimii latala ne ukalusi. Ia tavaꞌu loxovaa la mikaukavunu no anu Lavuku Tavuna teinu lexe, Itema ꞌOlu ne utavulenu navunavu tatila mo ta mitema ixiu tumaliꞌau? ");
INSERT INTO ata_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ia avikalangengi aloxo ꞌo. Eliasi ne, muneꞌe muxali mo ta mitema mikalusou masaxa noxiꞌa sou miꞌoxonu ꞌiliꞌilixo seꞌi mulai noxou aloxo Lavuku Tavuna teinu muaꞌaloxusou.” ");
INSERT INTO ata_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iloꞌa miluꞌe xe mixali noxiꞌa ta molomolou ane paꞌusiꞌa, la mimaisiꞌa ta mitema tapiena misevile mineꞌe mitulu mixaliliieꞌi, ia mitomu loxo. Xe milomusiꞌa aneꞌi ta molomolo noxou ne iloꞌa ta mitema sou lapuloto ne iꞌotoꞌotosou anaxaꞌa. ");
INSERT INTO ata_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Xe ta mitema mimalei loxo ꞌo, la mimaisou Iesu la mikuluke, la alaxu vilesisi miiave milai noxou sou misexelaxu. ");
INSERT INTO ata_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Xe Anu muavuti la mutaliꞌisiꞌa ta mitema ne aloxo ꞌo, “Maꞌia ane ngingi ngongiꞌa ngaꞌotoꞌotosou anangenge sou loxo ne?” ");
INSERT INTO ata_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Itema vile no nano no taiineꞌi ne, muavuti la mukolinu Iesu taliꞌiu aloxo ꞌo, “Itema sou ulosixe lavulavu, eni eneꞌenu ꞌalixeni mulu ꞌo, xo uleenu vile masua uxoxolu noxou la uꞌoxo uvivikala uasi. ");
INSERT INTO ata_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Voxovoxo piena musuku ne, utelosou la xavi misevile, la uleanu uluꞌe no lia mole livilivixu upaipasinga mo anaxu ukalakikiki mole utotoꞌeke loxo ꞌo. Elingaiꞌa ta molomolo noxine lexe ikusau uleenu ane muxolu noxou ꞌalixeni ꞌo, ia imomomo uasi.” ");
INSERT INTO ata_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngingi ta mitema sou ngamuxaxu tangengi noxou Lataua uasi! Tauu ie ta ꞌei ane sou eni axolu noxinge? Mo alaxu ta ꞌei ane sou eni atavulenu tuꞌutuꞌumaxu noxinge? Nganoꞌu molomolo ne uneꞌe noxilo.” ");
INSERT INTO ata_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","La sou aneꞌi minoꞌu mulai noxou. Xe uleenu masua ne mumaisou Iesu, la alaxu vilesisi ꞌo, la muꞌoxonu molomolo ne muꞌoloꞌolo mole muleanu muluꞌelai no lia. La mupipaopao la livilivixu muxalixali no anaxu. ");
INSERT INTO ata_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Xe Iesu muavuti la mutaliꞌisou momu aloxo ꞌo, “Mii e uxolu noxou ꞌo musoko a talu?” La momu mukolinu lexe, “No molomoloxu mo. ");
INSERT INTO ata_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Uꞌoxonu no voxo tavuꞌalo, la uleanu ulai no navu xe no lexa sou lexe uvau usoli. Ia lexe nini namomomo sou naꞌoxonu mii vile noxou, la taneninexe mo nasuꞌulinexi.” ");
INSERT INTO ata_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Xe Iesu muavuti la muvikala aloxo ꞌo, “Tavaꞌu loxovaa la nini nevikalaleli, lexe eni amomomo sou aꞌoxonu? Lexe nini namuxaxu taneni, la nini namomomo sou naꞌoxonu mimii latala ne ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Xe muavuti la alaxu vilesisi, muꞌava aloxo ꞌo, “Eni emuxaxu taleli noxine manina, ia nasuꞌulileli xo muxaxu taleli noxilo ulai noxine ne, kituꞌasi.” ");
INSERT INTO ata_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Xe Iesu mumalei loxo ꞌo, la ta mitema tavuꞌalo a iiaveiave ineneꞌe loxo noxou, la sou Anu mukaitolonu uleenu masua la muvikalanu aloxo ꞌo, “Nini uleenu ane saxavou mo ane uvivikala uasi e naxoxolu noxou molomolo ꞌo ne, eni avikalaneni pekiaꞌu lexe naxexesou, ia nalivu naneꞌe natelo noxou la uasi.” ");
INSERT INTO ata_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","La sou uleenu ne, muungaunga xe muvaxa muxaluxalu molomolo la muꞌokiꞌoki tani manina, sila muxexesou. Uleenu ne muxexesou io, aneꞌi ieꞌi muvaxa la loxo musoli, sila aneꞌi tavuꞌalo mivikala lexe, “Anu musoli.” ");
INSERT INTO ata_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sixe Iesu mukasi vaxa no avolu xe mutulusou, sila anu mutulu. ");
INSERT INTO ata_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesu mupamaulinu mukalu, io sou Anu mulai no tani. Xe no tani, la aneꞌi ta molomolo noxou ne milutu vaxa la mitaliꞌisou seꞌisisi aloxo ꞌo, “Tavaꞌu loxovaa, la nexi tamomomo sou takusau uleenu masua ne uasi o?” ");
INSERT INTO ata_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu mukolineꞌi aloxo ꞌo, “Linga anusisi ane umomomo sou ukusau uleenu ane loxo ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Xe iloꞌa miavuti la misukusou tuala ane iloꞌa mixolu no anu ne, sou minuna mimuamuaꞌi no nano no xalee lia tila ne Xalilaia. Iesu umasaxa lexe evile ulavu no anu xalee ane aneꞌi ixolu no anu uasi, ");
INSERT INTO ata_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","xo Anu ulosiꞌa ta molomolou lavulavu. Muvikalaneꞌi aloxo ꞌo, “Ulai iliꞌi, la ta mitema iꞌitalonu Itema ꞌOlu no avoꞌa ta mitema sou ivau usoli. Uai no nano no lulu voxo vile mo tamei, xe no voxo tatalusou, la sou Anu utulu.” ");
INSERT INTO ata_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ia aneꞌi ilamana no anu vaikala laaxu ane anu mulemolu noxiꞌa uasi. Mimamaꞌu la italiꞌisouxu uasi. ");
INSERT INTO ata_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iloꞌa mimuamuaꞌi xe milai mixali ne Kapenaumu, la miꞌunalai no tani. Xe Iesu muavuti la mutaliꞌisiꞌa aloxo ꞌo, “Mii maꞌia ane ngingi ngeꞌotoꞌotosou anangenge no voteꞌi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Anu mutaliꞌisiꞌa aloxo ne, la aneꞌi mitaꞌolu tasiaꞌusi xo aneꞌi milavu lexe no voteꞌi, la aneꞌi miꞌotoꞌotosou anaxaꞌa lexe ꞌei ane tila noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Xe Anu muavuti la muxolu no lia, io sou Anu muꞌavaliꞌa ta molomolo noxou aneꞌi mulelia tamei ne, mineꞌe noxou la sou muvikalaneꞌi aloxo ꞌo, “Lexe itema vile umasaxa lexe uuli, la laixe lexe anu uiliꞌi mo uxali loxo itema vile vitanisi sou ipalupalusou.” ");
INSERT INTO ata_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mutilaꞌu molomolo vile kituꞌa ka mulai mutulusou no taiineꞌi, xe muavuti la muvoꞌonu io sou muvikalaneꞌi aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ꞌEi ane lexe uxavutalaleli mo uꞌosa sou unoꞌu molomolo vile kituꞌa loxo ꞌo, la anu ane uꞌosa sou unoꞌilo. Xe ꞌei ane lexe uꞌosasilo sou unoꞌilo, la anu ane uꞌosasou unoꞌu ane mupalusilo eneꞌe ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Xe Ioanesi muavuti la muvikalanu Iesu aloxo ꞌo, “Itema sou ulosixe lavulavu, nexi temaisou itema vile ukukusaiꞌa ta uleenu masua no anu xavi noxine, la nexi teꞌapixu, xo anu vile noxinge nengeꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Ngaꞌapixu mamu, xo lexe itema vile uꞌoxonu mii vile xaviinu no anu xavi noxilo, la umomomo sou upasipaa uleanu vaikala vile masua uneꞌe noxilo uasi, ");
INSERT INTO ata_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","xo anu ane uꞌapinenge uasi ne, anu noxinge ane. ");
INSERT INTO ata_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eni avikalangengi manina aloxo ꞌo, ‘Anu ane uiengengi no anu lexa xo ngingi noxou Kalisito, la anu unoꞌu lakolisou manina.’” ");
INSERT INTO ata_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Xe muavuti la muvikalaneꞌi aloxo ꞌo la, “Lexe itema vile uolexu vile noxiꞌa aneꞌi ta mitema vitanisi ane imuxamuxaxu taneꞌi noxilo, sou ususu no anu ꞌilixo masua, la anu laixe lexe isakii lavoꞌo kulu vile no xolanu ka ilea uluꞌelai no luaki, ia laixe uasi lexe Lataua ulosou navunavu. ");
INSERT INTO ata_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mo lexe avone vile ususulixene, la nalixinu mo uxexee. Laixe lexe nini naꞌunalai no tuala sou mauli no anu avone vilesisi, ia laixe uasi lexe nini avone tamei ne uxolusi, la nini naꞌunalai no tuala sou navunavu e navu uꞌaniꞌani ia usisita uasi. ");
INSERT INTO ata_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mo lexe tavaꞌine vile ususulixene, la nalixinu mo uxexee. Laixe lexe naꞌunalai no tuala sou mauli no anu tavaꞌine vilesisi, ia laixe uasi lexe nini tavaꞌine tamei ne uxolusi, la nini naꞌunalai no tuala sou navunavu. ");
INSERT INTO ata_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mo lexe ieni vile ususulixene, la naluvu uxexee. Laixe lexe nini naꞌunalai no tuala noxou Lataua no anu ieni vilesisi, ia laixe uasi lexe nini ieni tamei ne uxolusi, la nini naꞌunalai no tuala sou navunavu e, ");
INSERT INTO ata_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘ta polikokasiꞌa imomomo sou isoisoli uasi mo navu umomomo sou usisita uasi.’ ");
INSERT INTO ata_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Laixe lexe anu Lataua uꞌuisiꞌa ta mitema vilevilesi no anu navu, loxo ta mitema iꞌuisou laꞌilali no anu au. ");
INSERT INTO ata_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Au ne laixe, ia lexe tuꞌaxu ne tasiau la ngingi ngalivulixu tuꞌaxu ne loxovaa la? Laixe lexe ngingi latala ne, ngatetelisou au tuꞌaxu lailaixe no anu maulingenge mo xoluxolu noxinge ngongiꞌa aneꞌi ane vaꞌavaꞌaxu ne laixesi.” ");
INSERT INTO ata_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu muvikalaneꞌi aloxo ne xe mukalu, la sou musukusou tuala ane ne, sou mununa no xalee lia tila ne Iutaia, la mualasou lexa ne Ioridani. Mulai, la ta mitema tavuꞌalo misevile mineꞌe noxou la, la Anu mulosiꞌa lavulavu no anu vaikala noxou Lataua, aloxo Anu mulavusou muꞌoxoꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ta Palisaio seꞌi mineꞌe mixali noxou sou lexe itovonu. Mineꞌe mixali la mitaliꞌisou aloxo ꞌo, “Itema vile mutaulaꞌi, ia anu umasaxa lexe usuꞌane semau la anu laixe no anu lapuloto noxou Mosesi?” ");
INSERT INTO ata_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Xe anu Iesu muavuti la mukolinu aloxo ꞌo, “Ia xo Mosesi muvikalangengi a loxovaa?” ");
INSERT INTO ata_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aneꞌi miavuti la mivikalanu lexe, “Mosesi muvikala lexe itema vile umasaxa lexe uꞌoxonu aloxo ne, la anu molu ukaukavu ulai noxie sou uxotonu taulaꞌixaꞌa ilou, io sou upalusie sou ilivu ilai.” ");
INSERT INTO ata_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ioxe, Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Mosesi mukaukavu lapuloto aloxo ne, xo ngingi opongengi pekiaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ia ngalomu, tatei manina no voxo ane Lataua musoko sou mukoinu mimii latala ꞌo, la mukoineꞌi ta mitema. Mukoineꞌi ta mulu xe ta sema. ");
INSERT INTO ata_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","La sou ane mulu uꞌumesiꞌa momu ilee nenu sou ulai noxie semau sou ");
INSERT INTO ata_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ilou ixali vilesisi. Mole aneꞌi tamei la ua, aneꞌi ilou vilesisi. ");
INSERT INTO ata_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","La sou mii maꞌia ane Lataua musakii mupitanu ne, itema vile umomomo sou ukalipalaneꞌi uasi.” ");
INSERT INTO ata_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iesu iloꞌa ta molomolo noxou milivu milai no tani, la aneꞌi mitaliꞌisouxu la. ");
INSERT INTO ata_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Xe Anu muavuti la muvikalaneꞌi lamana aloxo ꞌo, “Lexe itema vile usuꞌane semau, ia ulai uꞌuluxe sema vileli, la anu itema ane ne anu mususu noxie semau. ");
INSERT INTO ata_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Anu aloxo ne kalumo noxie sema. Lexe ane isuꞌanu mulue, ia ilai iꞌuluxu mulu vileli, la ane misusu noxou mulue.” ");
INSERT INTO ata_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anu uvivikalaneꞌi aloxo ne, la ta mitema a ixaxalixaꞌa ta molomolo ta kitukitu sou ineꞌeneꞌi noxou Iesu sou lexe Anu ukasiꞌa, ia ta molomolo noxou ne mikaitoloneꞌi ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Xe Iesu mumaisiꞌa mine aneꞌi mikaitoloneꞌi aloxo ne, la laꞌiaxu misevile. La sou muvikalaneꞌi lexe, “Iengi uvaxaiꞌa ta molomolo ta kitukitu nesi mo ineꞌe noxilo, ia ngaꞌapixaꞌa mamu, xo aneꞌi ane maulixaꞌa loxo ta molomolo ane ne, la saxisaxilaꞌu noxou Lataua uxolu noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mo eni avikalangengi manina aloxo ꞌo. Lexe itema vile unoꞌu saxisaxilaꞌu noxou Lataua loxo ta molomolo ꞌo uasi, la anu umomomo sou uꞌunalai no anu uasi manina.” ");
INSERT INTO ata_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Xe muavuti la sou muꞌaulaxaꞌa ta molomolo ne, xe mukalu la sou mumuxaxu avolu noxiꞌa io sou mualusiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mualusiꞌa ta molomolo aloxo ne xe mukalu, la sou Anu mulutu sou mumuamuaꞌi mulai. Ia itema vile muiave mulai noxou, la muxolaꞌu tavaꞌu voꞌuxu no talaxu io sou mutaliꞌisou aloxo ꞌo, “Itema laixe sou ulosixe lavulavu, mii maꞌia ane lexe eni aꞌoxonu sou eni anoꞌu mauli ane kaluxu uasi no anu?” ");
INSERT INTO ata_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Xe Iesu muavuti la muvikalanu aloxo ꞌo, “Tavaꞌu loxovaa ane nini nemoxoꞌilo lexe eni laixe? Itema vile laixe uasi, ia Lataua anusisi. ");
INSERT INTO ata_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nini nelavu no anu lapuloto e muvikala lexe, ‘Mamu sou navau itema vile usoli. Nini namulu, la mamu sou nalai noxie sema mitaulaꞌi xe nini nasema, la mamu sou nalai noxou itema mutaulaꞌi. Mamu sou napakali, mamu sou nakalavoisou itema vile vitanisi, la nalemolu manina teitexi, mamu sou nakalavoinu itema vile sou nanoꞌu miumiu vile vitanisi, mo natoxoneꞌi mamine ilee nenine.’” ");
INSERT INTO ata_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xe anu muavuti la muvikalanu Iesu aloxo ꞌo, “Itema sou ulosixe lavulavu, lapuloto ane ne, eni emulinu no mine eni molomoloxo mo mutalo vaimomo.” ");
INSERT INTO ata_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu mulomu noxou aloxo ne xe iou mulai noxou sou mumatakisou, la tanuxu. La sou muvikalanu lexe, “Mii vilesisi a naꞌoxonu uao, nalai mo nanoꞌu lavulavulutimeni ukalusi mo ta mitema ilotonu, xe nanoꞌu lamolisou la sou naitiꞌa aneꞌi ane iꞌa mimii uasi. Lexe nini naꞌoxonu aloxo ne, la sou mimii ane lailaixe uai teitexi no opo loxotolo ne, nini naꞌa nini. Ia naneꞌe mo namulileli.” ");
INSERT INTO ata_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Xe anu itema ne, mulomu aloxo ne, la iou mupalulu. Ia mumuamuaꞌisi mole mulai ne, opoonu uꞌosa uasi xo anu mulavu lexe anu lavulavulutiu tavuꞌalo misevile. ");
INSERT INTO ata_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu musuꞌanu iou sou muitisiꞌa ta molomolo noxou, la sou muvikala aloxo ꞌo, “Ta mitema ane lavulutiꞌa piena musuku ne, anu pekiaꞌu musuku noxiꞌa sou iꞌunalai no anu saxisaxilaꞌu noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Xe aneꞌi milomusou vaikala noxou ne, la mikuluke no anu. Ia Anu musolonu vaikalau mulai la muvikala aloxo ꞌo la, “Ta molomolo, lexe itema vile umasaxa lexe uꞌunalai no anu saxisaxilaꞌu noxou Lataua, la anu pekiaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Anu pekiaꞌu sou kameli vile uꞌunalai no anu umo vile taxanu uasi, ia itema ane lavulutiu piena musuku ne, anu pekiaꞌu misevile noxou sou uꞌunalai no anu saxisaxilaꞌu noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Xe ta molomolo noxou milomu aloxo ne, la mikuluke misevile la. Xe miavuti la mitalitaliꞌisiꞌa ngatongatoꞌo lexe, “Ia ꞌei ane sou unoꞌu mauli ane kaluxu uasi ne?” ");
INSERT INTO ata_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu iou mulai noxiꞌa, la mumatakisiꞌa la muvikalaneꞌi aloxo ꞌo, “Ta mitemasi la imomomo uasi. Ia Lataua la Anu mumomomo. Xo Lataua ne, Anu umomomo sou uꞌoxonu mimii latala ne ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Xe Pita muavuti la muvikalanu aloxo ꞌo, “Nexi texiu tumalixeu mimii latala ne mukalu, ia teneꞌe ꞌo sou tamulineni.” ");
INSERT INTO ata_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Xe Iesu muavuti la mukolinu aloxo ꞌo, “Avikalangengi manina musuku. Lexe itema vile uꞌumesou taasou, uasi ta vimovimou ta mulu iloꞌa ta sema, uasi momu ilee nenu, uasi ta ꞌolu, uasi xaixaixu, xo anu umasaxailo lexe uaꞌaloxu aꞌalo laixe ulai noxiꞌa ta mitema, ");
INSERT INTO ata_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","la umomomo sou anu unoꞌu taasou itemaxu taꞌuve, mo ta vimovimou ta mulu itemaxu taꞌuve, mo ta sema itemaxu taꞌuve, mo ta nenenu itemaxu taꞌuve, mo ta ꞌolu itemaxu taꞌuve, mo xaixaixu itemaxu taꞌuve ilou tuꞌutuꞌumaxu ta mitema iꞌoxonu ulai noxou. Xe ulai iliꞌi xe anu usoli, la anu unoꞌu mauli ane kaluxu uasi manina. ");
INSERT INTO ata_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ia aneꞌi tapiena e miuliuli ne, ulai la aneꞌi ilai iliꞌi, ia aneꞌi ane miiliꞌi ne ilai, la iuli.” ");
INSERT INTO ata_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ioxe, Iesu muvivikalaneꞌi aloxo ne xe mukalu, la muulaxuneꞌi sou iloꞌa miluꞌe ne Ielusalemu. Ta molomolo noxou ne, mikuluke xe ta mitema ane mimumulineꞌi ne vasimeꞌa muꞌume misevile. Iesu muavuti la munoꞌa ta molomolo noxou mavulovexa mulelia tamei sou mineꞌe ꞌalai noxou, la sou muvikalaneꞌixu mii ane sou uxali noxou. ");
INSERT INTO ata_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Muvikala aloxo ꞌo, “Nenge nengeꞌa asou taluꞌelai ne Ielusalemu o, la Itema ꞌOlu ne, ta mitema inoꞌu sou iꞌitalonu ulai no avoꞌa ta tatila noxiꞌa ta ailiꞌi, iloꞌa ta mitema sou lapuloto. Itulusou no anu vaivaikala sou lexe ivau mo usoli. La sou inoꞌu ulai noxiꞌa ta asila avoꞌa ");
INSERT INTO ata_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","sou aneꞌi imolovilaꞌisou mo ilikesou mo ipuapuasou mo ivau usoli. Uai no lulu voxo vile, tamei xe tatalusou la sou Anu utulu.” ");
INSERT INTO ata_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sevetaio ta ꞌolu tamei Iakovo ilou Ioanesi ne, ilou milai mixali noxou Iesu ne, la milinga aloxo ꞌo, “Itema sou ulosixe lavulavu, nexi noxou temasaxa lexe nini naꞌoxonu mii vile noxixe noxou.” ");
INSERT INTO ata_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Xe Iesu muavuti la mutaliꞌisiꞌa lexe, “Maꞌia ane ngingi ngongou ngemasaxailo lexe eni aꞌoxonu noxinge ngongou?” ");
INSERT INTO ata_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ilou mikolinu lexe, “Ulai iliꞌi xe nini naxali tatananu tuala, la nexi temasaxa lexe vile noxixe ꞌo ulai uvaꞌisaꞌineni no paꞌumene no tema xe vile no ae.” ");
INSERT INTO ata_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Xe Anu muavuti la muvikalaneꞌi ilou aloxo ꞌo, “Ngingi ngongou ngelinga aloxo ne, ia ngingi ngongou ngalavusou lexe mii maꞌia ngingi ngelingau ne uasi. Loxovaa, umomomo sou ngingi ngongou ngamasaxa lexe ngasoli loxo eni asoli?” ");
INSERT INTO ata_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aneꞌi miavuti la mikolinu Iesu lexe, “Nexi temasaxau.” Xe Anu muavuti la muvikalaneꞌi ilou aloxo ꞌo, “Anu umomomo sou ngingi ngongou ngasoli loxo eni asoli, ");
INSERT INTO ata_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ia no anu masaxa noxinge ngongou lexe vile sou uvaꞌisaꞌileli no paꞌumelo no tema xe vile no ae ne, umomomo sou alosinge vitanisi uasi, xo luu ane ne, Lataua mulalaxisiꞌa ta mitema ane anu musosovosiꞌasi, ane lexe aneꞌi ilai ixolu no anu.” ");
INSERT INTO ata_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ioxe, aneꞌi ta molomolo noxou ane mavulovexa vile ne, milomusiꞌa Iakovo ilou Ioanesi, la laꞌiaxaꞌaiꞌa ilou misevile. ");
INSERT INTO ata_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Xe Iesu muavuti la muꞌavaliꞌa sou mupitaneꞌi. La sou muvikalaneꞌi aloxo ꞌo, “Ngingi ngelavu lexe ta tatananu tuatuala noxiꞌa ta asila ne, aneꞌi isaxilaꞌa ta mitemaiꞌa pekiaꞌu, xe ta tatilasiꞌa ne, ivikala la aneꞌi ta mitemaiꞌa ne ilomuxu vaikalaiꞌasi. ");
INSERT INTO ata_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ia noxinge ne, anu aloxo ne uasi. Xo anu ane umasaxa lexe utila no nixi noxinge ne, la laixe lexe anu uxolu itema vile sou xaixai noxingesi. ");
INSERT INTO ata_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xe itema ane umasaxa lexe anu uxali tila sou uuli noxinge, la laixe lexe anu uxali loxo itema vile vitanisi noxiꞌa ta mitema ukalusi sou ipalupalusou. ");
INSERT INTO ata_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Xo Itema ꞌOlu ꞌo ne, muneꞌe sou lexe ta mitema iꞌoxoꞌoxonu xaixai noxou uasi. Anu muneꞌe sou lexe Anu uꞌoxonu xaixai sou uꞌitalonu maulixu sou uꞌoleneꞌi ta mitema tavuꞌalo.” ");
INSERT INTO ata_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ioxe, anu Iesu iloꞌa ta molomolo noxou mimuamuaꞌi xoo, la milai mixali ne Ieriko. Xe Iesu iloꞌa ta molomolou mo ta mitema tavuꞌalo misukusou tuala ne Ieriko sou milai. La itema vile ualasou lexe Vatimaio, e Timaio ꞌolu, a muxoxolu no voteꞌi paꞌumolu. Ia anu iou seleveenu. Anu muxoxolu ne sou ulingalinga mimii noxiꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","No voxo ane ne, anu mulomu lexe Iesu, itema sie Naseleti a uneneꞌe ne, la anu mutaloxu ꞌava mulai noxou, “Iesu, nini Deviti ꞌilusunu, tanenixo!” ");
INSERT INTO ata_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ta mitema tavuꞌalo milomusou aloxo ne, la mikaitolonu. Mivikala lexe uxolu tasiau. Ia anu ulomuxaꞌa uasi, anu muꞌava muꞌokinu mulai noxou Iesusi. “Deviti ꞌilusunu, tanenixo!” ");
INSERT INTO ata_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Xe Iesu mutulu, la sou muvikalaneꞌi lexe, “Ngaꞌavalou uneꞌe.” Aneꞌi miꞌava mulai noxou aloxo ꞌo, “Naꞌosa. Mo natulu! Xo anu a muꞌavaline.” ");
INSERT INTO ata_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Xe anu muavuti la musuꞌanu ꞌalaꞌalasou muai, io anu muiliꞌe mutulu sou mulai noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mulai muxali noxou Iesu, la sou Iesu mutaliꞌisou lexe, “Mii maꞌia ane nemasaxau lexe eni aꞌoxonu noxine?” La sou anu muvikalanu Iesu lexe, “Rabi, eni emasaxa lexe amamalei.” ");
INSERT INTO ata_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","La sou Iesu muvikalanu lexe, “Nalai, nini nemauli xo nemuxaxu taneni noxilo.” Xe alaxu vilesisi ꞌo, la anu iou mukaa sou mumalei avile. La sou muavuti sou mumulinu Iesu no voteꞌi e Anu mumuamuaꞌi no anu ne. ");
INSERT INTO ata_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ioxe, iloꞌa mimuamuaꞌi xe milai mixali ꞌalai ne Ielusalemu, la mixali no tuala ne Vetepaxe ilee Vetania, ꞌalai no laxaꞌilu ne Olivu. Xe Iesu muavuti la mupalusiꞌa ta molomolo noxou tamei, ");
INSERT INTO ata_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","la muvikalaneꞌi ilou aloxo ꞌo, “Ngongou ngalai no tuala e no laxungengi ne, xe ngaꞌunalaisi, ka ngamaisou donki ꞌilie mulu a mitalisou mo misakiinu mo a ututulu. Dongki ne, evile utelo mo uxolu no anu uao. Ngongou ngalulusou ukalu, la sou nganoꞌu uneꞌe noxilo ꞌo. ");
INSERT INTO ata_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ngongou ngalulusou, xe lexe evile utaliꞌisinge lexe, ‘Loxovaa ane ngingi ngongou ngalulusou donki ne?’ La ngongou ngakolinu lexe, ‘Tila mumasaxau lexe uꞌoxonu xaixai no anu. Io xaixai ukalu, la sou upalea ulivulixu uneꞌe la.’” ");
INSERT INTO ata_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ilou milutu xe milai, la mimaisou donki vile ne a ututulu no voteꞌi. Mitalisou ka misakiinu no ale ꞌalai no tani vile aitengaxu. Aneꞌi ilou miavuti la milulusou. ");
INSERT INTO ata_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Xe ta mitema seꞌi mitutulu ne, mimaisiꞌa ilou la mitaliꞌisiꞌa aloxo ꞌo, “Ngongou ngananavaa loxo ngalulusou donki ꞌilie ne?” ");
INSERT INTO ata_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aneꞌi ilou miavuti la mivikalaneꞌi aloxo Iesu mupelaꞌaxu ne, la sou aneꞌi ieꞌi muvaxaiꞌa ilousi sou ilou minoꞌu milailixu noxou. ");
INSERT INTO ata_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ilou minoꞌu xe milai mixalixu noxou Iesu, la sou minoꞌu ꞌalaꞌalasou vasimeꞌa ilou sou milalanu vaxa no lataanu donki ne, sou anu Iesu mutelo mutalupexa no anu. ");
INSERT INTO ata_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta mitema tavuꞌalo kalumo mixavulalanu ꞌalaꞌalasou vasimeꞌa ka misiaꞌu no voteꞌi, xe seꞌi ne milai no xai sou mivalivalitusou ovu avoavolu sou mitaꞌolunu no voteꞌi kalumo. ");
INSERT INTO ata_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta mitema ane miulaxu Iesu xe aneꞌi ane miiliꞌi no tumalou sou mimumulinu ne, miꞌava aloxo ꞌo, “Napamaulinexi! Lataua ualusou anu ane IAUE mupalusou mo a uneneꞌe ꞌo! ");
INSERT INTO ata_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lataua ualusou saxisaxilaꞌu noxou ꞌilusunu Deviti, Anu ꞌilusunenge anu a uneneꞌe ꞌo. Napamaulinexi, mo sou aneꞌi iꞌitinu ualasine teitexi no opo loxotolo!” ");
INSERT INTO ata_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu muxali ne Ielusalemu mukalu, la sou Anu muꞌunalai no nano no taasou lalotu tatila noxou Lataua. Mulai muxixaou no nano ne mo mumaisou mimii latala ne mukalu. Ia tavaꞌu xo aso a muluꞌelai, la sou Anu iloꞌa ta molomolou mavulovexa tamei ne, milaa sou milivu ne Vetania. ");
INSERT INTO ata_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Miai xe kakau, la aneꞌi milutu ne Vetania sou milivu milai loxo ne Ielusalemu la, la Iesu musolixu. ");
INSERT INTO ata_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xe iou mulai mutukumusou ovu lovo vile ne mutulu no paxa. Volovoloxu piena misevile, la sou mulutu mulai no anu sou ukamuli lexe temanu seꞌi ꞌa no anu. Mulai xe muxali no anu, la mumaisou lexe ovu ne, volovoloxusi, ia uneneꞌa mo temanu uasi, xo anu ovu ne, voxo sou uneneꞌa uao. ");
INSERT INTO ata_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","La sou muvikalanu ovu ne aloxo ꞌo, “Usoko ane vaimomo ꞌo, la nini naneneꞌa mo evile uꞌou ngiaxene la uasi manina.” Muvikala aloxo ne, la ta molomolo noxou ne milomusou. ");
INSERT INTO ata_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iloꞌa mimuamuaꞌi xe milivu mixali ne Ielusalemu, la Iesu muꞌunalai no nano no taasou lalotu tatila noxou Lataua, sou musoko sou mukusaiꞌa ta mitema e mitataꞌolu mimii sou ta mitema ilotonu mo aneꞌi ane mineꞌe sou iloto no nano ne, miuatuuatu. Mavulovexa valovaloxaꞌa ta mitema ane ilavusou ivalavala lamoli no anu. Xe luuluusiꞌa aneꞌi ane mitaꞌoluneꞌi ta kuau sou ilotoneꞌi. ");
INSERT INTO ata_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Xe muvikala pekiaꞌu noxiꞌa sou mamu evile loxo ꞌo utavule mimii seꞌi sou ta mitema ilotonu ka uvaxa uneꞌe no nano no taasou lalotu tatila noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xe muavuti la mulosieꞌixu ta mitema lavulavu seꞌi la aloxo ꞌo, “Ngalavusou lexe vaikala ane ꞌo muxolu no anu Lavuku Tavuna teinu uasi? Mikaukavu aloxo ꞌo, ‘Taasilo ne, ilemolu lexe anu taasou lingaligna noxiꞌa ta mitema no xalexalee tuatuala no lia ꞌo ukalusi.’ Ia ngingi ngexiunu mole muxali loxo taasiꞌa ta mitema sou pakali sou italume no anu.” ");
INSERT INTO ata_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ta tatila noxiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto, milomusou vaivaikala ane Iesu muvikalaneꞌi ta mitema no anu ne, la aneꞌi misoko sou mikamuli voteꞌi sou lexe ivau usoli, xo aneꞌi miꞌumolu. Xo ta mitema latala ne, milomusou vaivaikala la mikuluke no anu. ");
INSERT INTO ata_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Xe no ꞌoloꞌolovoxo, la aneꞌi milaa ne Ielusalemu ne sou milivu milai. ");
INSERT INTO ata_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iloꞌa milai miai xe no kakau, la iloꞌa milivu milai ne Ielusalemu la. Mimuamuaꞌi xe mineꞌe no voteꞌi, la mimaisou lovo e Iesu muvavaaxu ne muxalo. Muxalo musoko no uliuliꞌu mulai muxali teitexi avile. ");
INSERT INTO ata_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Xe Pita muxavutalanu vaikala e Iesu muvikalanu mei, la muvikalanu Iesu aloxo ꞌo, “Rabi, namalei ovu e laꞌiaxene la nevavaaxu ane muxalo mukalu!” ");
INSERT INTO ata_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu muavuti la muvikalanu aloxo ꞌo, “Ngamuxamuxaxu tangengi noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Avikalangengi manina musuku lexe itema vile uvikalanu laxaꞌilu ꞌo lexe, ‘Naavuti mo nailiꞌe ulai no luaki.’ ia xavutalau tamei uasi, umuxaxu tanu no anu vaikalau ne, la mii ane anu mumasaxau ne, uxali manina aloxo anu muvikalanu. ");
INSERT INTO ata_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","La sou ane lexe eni avikalangengi aloxo ꞌo, mii maꞌia ane ngingi ngalingau ne, ngamuxaxu tangengi lexe mii ne ane ngenoꞌu ne. La anu mii ne, uxali noxinge aloxo masaxa noxinge. ");
INSERT INTO ata_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Xe lexe ngatulu sou ngalinga, ia lexe evile uxomasuangengi no anu ꞌilixo vile masua mo mii ne a mumauli no xavutalamengisi ꞌo, la anu laixe lexe ngaxiunu tumalingeusi, mo sou Maminge teitexi no opo loxotolo, Anu uxiunu tumalouu ꞌiliꞌilixo masumasua noxinge kalumo.” ");
INSERT INTO ata_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iloꞌa mimuamuaꞌi xe mixali ne Ielusalemu la, la Iesu muꞌunalai no nano no taasou lalotu tatila noxou Lataua. Muꞌunalai, la ta tatilasiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto mo ta tatila seꞌi kalumo no nano ne, mineꞌe mixali noxou, ");
INSERT INTO ata_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","la mitaliꞌisou aloxo ꞌo, “Xavi maꞌia ane muxolu noxine ne, la sou nini naꞌoxoꞌoxo mimii ane ne no anu ꞌo? ꞌEi molu ane mulosine xavi mo mupelemasaxaneni sou lexe naꞌoxonu xaixai ne?” ");
INSERT INTO ata_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Eni kalumo ataliꞌisingexu taliꞌi vile, lexe ngingi ngakolinu uneꞌe noxilo, la sou eni avikalangengi no anu xavi ane eni axaxai no anu ꞌo. ");
INSERT INTO ata_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioanesi, anu itema sou uꞌulosiꞌa ta mitema ꞌo ne, anu molu no opo loxotolo, uasi? Anu molu noxiꞌa ta mitema? Ngakoli uneꞌe noxilo!” ");
INSERT INTO ata_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aneꞌi miavuti la milutu vaxa sou mivivikalasou taliꞌi ane ne, sou mivikalaneꞌi ngatongatoꞌo xe miavuti la mivikala aloxo ꞌo, “Maasi xe nenge tavikala lexe, ‘anu molu no opo loxotolo,’ la Anu utaliꞌisinge lexe, ‘La loxovaa la ngingi ngamuxamuxaxu tangengi noxou ua?’ ");
INSERT INTO ata_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Xe nenge tavikala lexe ‘anu molu noxiꞌa ta mitema,’ la ane ne kalumo umomomo uasi.” (Aneꞌi mivikala aloxo ne, ia aneꞌi mimamaꞌu noxiꞌa ta mitema. Xo ta mitema latala ne, milavusi lexe Ioanesi ne, anu itema vile manina sou palomatana.) ");
INSERT INTO ata_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","La sou miavuti la mikolinu Iesu aloxo ꞌo, “Nexi talavusou uasi.” Xe Iesu muavauti la muvikalaneꞌi lexe, “Eni kalumo umomomo sou apalaꞌalixu lexe ꞌei ane mupelemasaxaleli ꞌo uasi.” ");
INSERT INTO ata_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Muvikalaneꞌi aloxo ne xe mukalu, la Anu musoko sou muꞌoxonu vaikala latilovo seꞌi mulai noxiꞌa. Muvikalaneꞌi aloxo ꞌo, “Itema vile mutou xaisou uaini vile, xe mukalu la muvimelusou ka mutulusou lavalolo sou ikapinu uaini ngiangiaxu la lexaxu uluꞌelai utavo no latotope, ka mutulusou tani vile teitexi sou ta mitema ixolu no anu sou isaxilaꞌu xai ne. Muꞌoxonu aloxo ne, xe mukalu la muꞌitalonu xai ane ne no avoꞌa ta mitema seꞌi sou aneꞌi ixaxai sou ulai la unoꞌu temanu seꞌi no anu, ia anu mulutu sou mulai no tuala vile no paxa. ");
INSERT INTO ata_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ioxe, no voxo ane sou xaisou ovu uaini ne temanu xe momoxo sou iꞌelexu, la anu mupalusou itema sou xaixai vile noxou mulai noxiꞌa ta mitema e misaxilaꞌu xai ne sou lexe unoꞌu temanu seꞌi noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mulutu xe mulai, la ta motu mitetelisou ka mivau. Mivau mukalu la mimulesou sou mulivu vitanisi. ");
INSERT INTO ata_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Xe muavuti la, la mupalusou itema sou xaixai noxou vile la mulai la. Mulutu xe mulai, la mipaunoxu kisou. Ka mipamaelanu manina. ");
INSERT INTO ata_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xe anu muavuti la mupalusou vile la, sou mulai. Mulai la mivau musoli. Xe muavuti la mupalusiꞌa tavuꞌalo, la sou milailai. Milai xe mixali noxiꞌa, la miꞌotuꞌotuneꞌi seꞌi xe seꞌi ne miveꞌaveꞌa misoisoli. ");
INSERT INTO ata_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Miꞌoxoneꞌi aloxo ne, io itema vilesisi ꞌa ilou mixolu. Itema ane ne, anu ꞌolu manina. Anu umasaxau misevile ia tanusou uasi. Muavuti la mupalusou mulai noxiꞌa la muvikalanu aloxo ꞌo, ‘Eni ꞌalixeni ane apalusou ulai uxali noxiꞌa, la aneꞌi itoxonusi.’ ");
INSERT INTO ata_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mulutu xe mulai muxali, la ta mitema e ixaxai no xai ne, mivikalaneꞌi ngatongatoꞌo aloxo ꞌo, ‘Itema ano ꞌo ne, anu ulai iliꞌi, la ualasou utelo no anu momu mixumixu ꞌo ane. Nganeꞌe mo nengeꞌa tatetelisou mo tavaꞌu usoli, mo sou ulai iliꞌi la nenge ualasinge utelo no anu.’ ");
INSERT INTO ata_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Xe milutu vaxa la mitetelisou sou mivau. Mivau mukalu la mikasi vaxa noxou ka mileanu muuatulai no ale no vimelusou xai. ");
INSERT INTO ata_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ioxe, tatananu xai ne mulavu lexe ꞌolu ane ta mitema ne mivau musoli ne, la anu uꞌoxonu mii maꞌi? Anu molu ulutu uneꞌe ka uveꞌaveꞌa ta mitema ne mo isoisoli ukalusi, io sou anu uꞌitalonu xai ne ulai noxiꞌa ta mitema seꞌi vaꞌaxu.” ");
INSERT INTO ata_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Xe Iesu muavuti la mutaliꞌisiꞌa lexe, “Loxovaa, ngingi ngeitisou vaivaikala seꞌi no anu Lavuku Tavuna teinu aloxo ꞌo? ‘Lavoꞌo e ta mitema sou itutulu tani misuꞌanu ne, anu muxali lavoꞌo vile laixe manina sou utetelisou tani. ");
INSERT INTO ata_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","IAUE molusi muꞌoxonu mii ane ne. Nexi temaisou, la laixe manina.’” ");
INSERT INTO ata_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Xe aneꞌi ane anu muvivikalaneꞌi ne, miavuti la mikamuli voteꞌi sou lexe itetelisou, xo milavu lexe vaikala latilovo ane anu muꞌoxonu ne, laaxu mumomomo noxiꞌa manina. Ia mimamaꞌu noxiꞌa ta mitema tavuꞌalo, la ieꞌi muvaxausi, ia milutusi mole milailai. ");
INSERT INTO ata_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xe iliꞌi, la mipalusiꞌa ta Palisaio seꞌi iloꞌa ta mitema seꞌi noxou Elodesi mineꞌe noxou Iesu sou ikalavoinu lexe Anu ususu no anu vaivaikala seꞌi la itetelisou. ");
INSERT INTO ata_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Milutu xe mineꞌe mixali noxou la mivikala aloxo ꞌo, “Itema sou ulosixe lavulavu, nexi telavu lexe nini itema vile sou nalemo mii, la navikala maninasou. Nini nalavusou naꞌumeꞌa ta mitema uasi, xo aneꞌi ane ualasiꞌa mo aneꞌi ane ualasiꞌa uasi ne, mimomomo vilesisi no ieni. Ia nini nalosieixu voteꞌi laixe noxou Lataua no anu vaikala manina. Ia lovoxaa, anu mumomomo sou nenge talea lamoli ulai noxou Kaisari uasi? Uasi, taleanu?” ");
INSERT INTO ata_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aneꞌi italitaliꞌi aloxo ne, ia anu Iesu mulavu no anu kalavoi noxiꞌa ne. La sou mutaliꞌisiꞌa lexe, “Tavaꞌu loxovaa ane ngingi ngatovoleli loxo ꞌo sou ngatetelisilo ꞌo? Ioxe, nganoꞌu Denalia vile uneꞌe mo amaisou.” ");
INSERT INTO ata_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aneꞌi miavuti la minoꞌu mulai noxou sou mumaisou. La sou mutaliꞌisiꞌa aloxo ꞌo, “ꞌEi kisou mo ualasou ane uxolu no anu lamoli ꞌo?” Aneꞌi mikolinu lexe anu noxou Kaisari. ");
INSERT INTO ata_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","La sou anu muvikalaneꞌi lexe, “Mii ane noxou Kaisari, la ngalosou Kaisari. Xe mii ane noxou Lataua, la ngalosou Lataua.” Aneꞌi milomu noxou aloxo ne, la mikuluke manina. ");
INSERT INTO ata_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xe iliꞌi, la ta Sadokaio mineꞌe mixali noxou. Aneꞌi ta mitema ane ne, ixavutala lexe ta mitema isoli, io ulai iliꞌi la umomomo sou imauli la uasi. Mineꞌe mixali, la mitaliꞌisou aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Itema sou ulosixe lavulavu, vaikala muai no anu kaukavu noxou Mosesi muneꞌe noxinge aloxo ꞌo. Itema vile mutaulaꞌi, ia anu musoli. Ia upalaneꞌi ta ꞌolu uasi. La anu laixe lexe vimou ne uꞌuluxe sema ne, mo sou upalaneꞌi iu vimou ta ꞌolu noxie. ");
INSERT INTO ata_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ioxe, no voxo vile, la ta mitema muxatele tamei ixoxolu. Aneꞌi muxatele tamei ne, aneꞌi ta taumetali. Iloꞌa mixoxolu, la ane laposalaxu noxiꞌa ne mutaulaꞌi, xe iliꞌi la musoli. Ia upalaneꞌi ta ꞌolu noxie sema ne uasi. ");
INSERT INTO ata_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xe vimoꞌa ane tameisiꞌa ne, muavuti la muꞌuluxe sema vaalu ne, ia anu kalumo musoli. Ia upalaa ta ꞌolu noxie uasi. Mo vimoꞌa tatalusiꞌa kalumo ne aloxo nesi. ");
INSERT INTO ata_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Anu aloxo ne mole, aneꞌi muxatele tamei ne, miꞌuluxe sema vilesisi ne, ia vile noxiꞌa upalaa ꞌolu vile noxie uasi, mole iliꞌi la ane kalumo misoli. ");
INSERT INTO ata_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ioxe, ulai iliꞌi no anu voxo ane sou ta mitema ane misoisoli itulu sou imauli, la ꞌei noxiꞌa aneꞌi muxatele tamei ne, semau maninasou xo loxo aneꞌi muxatele tamei ane miꞌuluxe sema vilesisi ne?” ");
INSERT INTO ata_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Xe Iesu muavuti la mukolineꞌi aloxo ꞌo, “Loxovaa ngingi ngexovulaulau no anu vaikalamengi, xo ngingi ngalavusou vaikala muxolu no anu Lavuku Tavuna mo xavi noxou Lataua uasi? ");
INSERT INTO ata_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta mitema ane misoisoli ne, lexe imauli la umomomo sou itaulaꞌi la uasi. Aneꞌi ixali loxo ta angelo teitexi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ioxe, no anu vaivaikalasiꞌa ta mitema ane misoisoli ka itulu ne, loxovaa ngingi ngaitisou aꞌalosou ovu e ukaakaa no nano no kaukavu noxou Mosesi uasi? No anu aꞌalo ane ne, Lataua muvikala noxou Mosesi lexe, ‘Eni Lataua noxou Avalaamu mo Lataua noxou Aisaki mo Lataua noxou Iakovo.’ ");
INSERT INTO ata_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anu Lataua ne, noxiꞌa ta mitema ane misoisoli uasi, anu Lataua noxiꞌa ta mitema ane ixolu imauli vaimomo. La sou eni avikalangengi lexe ngingi ngexovulaulau manina.” ");
INSERT INTO ata_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iesu Iloꞌa ta Sadokaio miꞌotosou anaxaꞌa aloxo ne, la itema vile sou lapuloto mulomusiꞌa. Muxoxolu sou mulolomu aloxo ne, la mulomusou Iesu mine mukokolinu vaikalaiꞌa, la vaikalau ne mulapusi. La sou anu mutaliꞌisou Iesu aloxo ꞌo, “Eni elavu lexe lapuloto noxinge tavuꞌalo, ia lapuloto anevaa ane muuli no anu lapuloto latala ne mukalusi?” ");
INSERT INTO ata_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu mukolinu aloxo ꞌo, “Lapuloto ane muuli no anu lapuloto latala mukalusi ne aloxo ꞌo, ‘Ngingi ta Isilaeli. Ngalomu, IAUE anusisi Lataua, anu Lataua noxinge. ");
INSERT INTO ata_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","La sou lexe ngingi ngamasaxau IAUE Lataua noxinge, la ngamasaxau no anu tangengi, mo no anu uleengengi, mo no anu xavutalamengi, mo no anu xavingengi ukalusi.’ ");
INSERT INTO ata_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Xe tamei sou aloxo ꞌo, ‘Ngamasaxau menexinge vile aloxo ngingi ngemasaxainge la.’ Lapuloto vile la uuli no anu ane tamei ne uasi.” ");
INSERT INTO ata_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Xe itema ne, muavuti la muvikalanu Iesu aloxo ꞌo, “Itema sou ulosixe lavulavu, vaikala noxine ne, mulapu manina musuku. Nevikala lexe Lataua ne Anu anusisi, ia vile la uasi. ");
INSERT INTO ata_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mo lexe tamasaxau no anu tanenge, mo no anu xavutalamenge, mo no anu xavinenge ukalusi, mo sou lexe tamasaxau menexinge vile aloxo nenge tamasaxainge la. Mii tamei ne, anu mutila no anu ta mimii ane iꞌelaxaꞌa ukalusi ulai noxou Lataua xe mimii seꞌi sou ulai noxou.” ");
INSERT INTO ata_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Xe Iesu mulomu vaxa no anu vaivaikala noxou sou mukolinu vaikalau, la mukolinu mulapu loxo itema vile lavulavu muxolu noxou, la muvikalanu aloxo ꞌo, “Nini ne no paxa no anu saxisaxilaꞌu noxou Lataua la uasi.” La sou ta mitema milomu aloxo ne, la vile noxiꞌa ne, umomomo sou utaliꞌisou Iesu no anu mii vile la uasi. ");
INSERT INTO ata_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Xe no mine Iesu anu a uxolu no nano no taasou lalotu tatila noxou Lataua sou ulosiꞌa ta mitema lavulavu, la mutaliꞌisiꞌa aloxo ꞌo, “Tavaꞌu a loxovaa, la ta mitema sou lapuloto ivikala lexe Kalisito ne, Deviti ꞌilusunusi? ");
INSERT INTO ata_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ia Deviti molu muvikala no anu Uleenu Tavuna mulosou lavulavu la mupalaꞌalixu aloxo ꞌo, ‘IAUE muvikalanu Tila noxilo aloxo ꞌo, “Navaꞌisaꞌile no avolo tema ulai utalo no anu voxo ane sou eni amuxaxaꞌa ta uluameni no tavaꞌine laaxu.” ’ ");
INSERT INTO ata_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deviti molu mumoxoꞌu lexe anu Tila noxou. Ia loxovaa la anu Tila ne, Deviti ꞌilusunusi la?” Ta mitema tavuꞌalo te mixoxolu ne milolomusou vaikala noxou, la miꞌosasou misevile. ");
INSERT INTO ata_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mulosiꞌa lavulavu ne, la muvikalaneꞌi aloxo ꞌo, “Ngasaxilaꞌinge laixe noxiꞌa ta mitema sou lapuloto. Imasaxa lexe itaa tokolomoiꞌa veveeni, io sou ixixaoxao. Mo imasaxa lexe ta mitema ixalisiꞌa no tilovolovo, la isexelaxaꞌa. ");
INSERT INTO ata_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Xe no taasou lalotu noxiꞌa ta Iutaia, la imasaxa lexe ixoxolu no puloulou ane uulisi. Xe ixali sou laꞌilali toxotoxoxaꞌa, la imasaxa lexe ixolu no puloulou ane uulisi ne kalumo aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xe iavuti la ikalavoineꞌi ta sema ta vaalu sou ikalusou miꞌamiꞌa. Xe ikalavoi sou ilinga veveeni misevile. Ta mitema ane loxo ne, ulai iliꞌi la inoꞌu navunavu ꞌoluꞌolu uasi manina.” ");
INSERT INTO ata_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu muvikalaneꞌi sou mulosiꞌa lavulavu aloxo ne xe mukalu, la muxolu ꞌalai no taasou lamoli sou umamaisiꞌa ta mitema mine ineneꞌe sou iꞌitalonu lamoliꞌa uluꞌelai no taasou lamoli ne. Ta mitema tavuꞌalo ane lamoliꞌa tavuꞌalo misevile mineꞌe miꞌitalonu lamoli toxotoxoxaꞌa loxo ꞌo no voxo ane ne. ");
INSERT INTO ata_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ia sema vaalu vile ne, ie lamoli se kituꞌasi, mineꞌe la miꞌitalonu Leputa tamei, mumomomo Koduranto vile. ");
INSERT INTO ata_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Xe Iesu mumaisie aloxo ne, la sou muꞌavaliꞌa ta molomolo noxou sou muvikalaneꞌi aloxo ꞌo, “Avikalangengi manina musuku. Sema vaalu ꞌo ne, ie lamoli se kituꞌa ia lamoli soxu e ane miꞌitalonu ne, mutila musuku noxiꞌa aneꞌi ane miꞌitalonu. ");
INSERT INTO ata_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aneꞌi ane latala e miꞌitalonu lamoli toxotoxoxaꞌa ne, aneꞌi miꞌitalonu aloxo ne ia lamoliꞌa piepienanu ꞌa muai. Ia ane sema vaalu ne, ie mii vile sou uai la uasi, soxu e minoꞌu ne ane miꞌitalonu mulai mukalusi. Ia vile la uai sou iloto laꞌilali no anu la uasi.” ");
INSERT INTO ata_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Xe Iesu muavuti, la musukusou taasou lalotu tatila noxou Lataua, la vile noxiꞌa ta molomolo noxou ne, muvikalanu aloxo ꞌo, “Itema sou ulosixe lavulavu! Namalei. Lavolavoꞌo ꞌo ne, lailaixe misevile. Mo tanitani ꞌo ne, lailaixe kalumo misevile.” ");
INSERT INTO ata_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu muavuti la mukolinu aloxo ꞌo, “Nini nemaisou tanitani e toxotoxoxaꞌa ꞌo? Ia umomomo sou ieꞌi uvaxau lavoꞌo vile ꞌo ne, uvoꞌuvoꞌutulo no lataanu menexu vile uasi, lavolavoꞌo latala ne, imamamulo ka ipeinu uluꞌelai no lia.” ");
INSERT INTO ata_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu mulai mo a uxoxolu no laxaꞌilu ne Olivu, la iou muvaxau tani tila noxou Lataua no talaxu. Pita ilou Iakovo mo Ioanesi ilou Andeleasi milutu vaxa, la mitaliꞌisou seꞌisisi vaꞌaxu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Navikalanexi. Talu la mimii ane lexe uxali ꞌo, uxali maninasou? Sosovo maꞌia ane uxali tei sou uvikala lamana noxixe lexe anu mimii ane ne, asou uxali maninasou?” ");
INSERT INTO ata_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Xe Iesu muavuti la mupeletotosiꞌa aloxo ꞌo, “Ngasaxilaꞌinge laixe. Loxo ꞌo io itema vile uxali ukalavoingengi. ");
INSERT INTO ata_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta mitema tavuꞌalo ixali, la imoxou ualasilo. Ivikala lexe, ‘Eni anu,’ la ikalavoineꞌi tavuꞌalo. ");
INSERT INTO ata_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","No voxo ane ngingi ngalomusiꞌa ta mitema iꞌotoꞌoto mo vaikala sivosivo sou ꞌotoꞌoto ne, la ngaavuavuti mo tangengi kalaua mo ngaꞌume uasi. Anu mimii ane loxo ne anu uxali, ia voxo kaluxusou ne a uao uneneꞌe o. ");
INSERT INTO ata_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta mitema sou tuala vile iavuti, la ialivulaneꞌi ta mitema sou tuala vile ane vaꞌaxu. Mo ta mitema noxou tatananu tuala vile iavuti, la iloꞌa ta mitema noxou tatananu tuala vile ane vaꞌaxu iꞌoto. Xe no xalexalee tuatuala seꞌi, la laliua ukunikuni, mo soli toxoxaꞌa uxali. Anu tuꞌutuꞌumaxu ane ne, uxali tei loxo sema ixamuli navunavu tei ka sou ivoꞌo ꞌilie. ");
INSERT INTO ata_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Anu laixe lexe ngingi ngasaxilaꞌinge laixe. Xo inoꞌinge ka ilai itulusinge no anu vaivaikala no ieꞌi ta tatila no anu pita noxiꞌa ka ivenge no nano no taasou lalotu noxiꞌa ta Iutaia. Tavaꞌu xo ngingi noxilo, la sou aneꞌi itulusinge no ieꞌi ta mitema sou xaixai noxiꞌa ta tatananu tuatuala iloꞌa ta tatananu tuatuala, la sou ngingi ngaavuti sou ngaꞌaloxu aꞌalo laixe noxilo ulai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","La sou voxo kaluxusou uxali uao, la aꞌalo laixe ne, iaꞌaloxu no xalexalee tuatuala ukalusi tei. ");
INSERT INTO ata_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Xe lexe itetelisinge mo ilailingenge sou itovongengi, la ngaxavutala piena no anu vaikala sou ngalemolu uasi. Vaikala maꞌi ane uxali no anu xavutalamengi alalae ne, la ngalemolu ulai noxiꞌa. Xo ngingi ane ngavivikala ne uasi, Uleenu Tavuna ane uvivikala ne. ");
INSERT INTO ata_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Itema vile uavuti la ukalanu vimou sou ivau usoli, mo ta molomolo kalumo ne ta mamiꞌa iꞌoxo aloxo ne noxiꞌa. Xe ta ꞌiliꞌiliꞌa ne, iavuti la iasaxaiꞌa ta neniꞌa iloꞌa ta mamiꞌa sou iveꞌa isoli. ");
INSERT INTO ata_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ulai la ta mitema tavuꞌalo oponeꞌi masuainge xo ngingi noxilo, ia aneꞌi ane itulu pekiaꞌa ulai utalo no voxo ane aneꞌi maulixaꞌa ukalu no anu, la Lataua upamaulineꞌi.” ");
INSERT INTO ata_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Xe Iesu muavuti la muvikalaneꞌi la aloxo ꞌo, “Lexe ngamaisou mii vile e Lataua umasaxa uasisi manina xe umamulonu mimii a ututulu no xalee lia vile ne anu noxou uasi, la laixe lexe ꞌei ane uitisou vaivaikala ano ꞌo, la ulavu laixe no anu. Mo ta mitema ane ixolu ne Iutaia ne, iꞌumeꞌume ilai no laxalaxaꞌilu. ");
INSERT INTO ata_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Itema ane mulai mo ꞌa uxoxolu no taasou kisou ne, umomomo sou uluꞌelai mo uꞌunalai sou unoꞌu mimii seꞌi uuatunu uasi. ");
INSERT INTO ata_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mo itema ane mulai no xaixu mo ꞌa uxaxai ne, umomomo sou ulivu ulai no tani sou unoꞌu tokolomou uasi. ");
INSERT INTO ata_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ia ta sema ane opooponeꞌi xe aneꞌi ane isusuneꞌi ta ꞌiliꞌiliꞌa ta keakea, anu voxo masua noxiꞌa manina. ");
INSERT INTO ata_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ia anu laixe lexe ngingi ngalinga, mo sou anu mii ane ne uxali no voxo sou laꞌiua uasi. ");
INSERT INTO ata_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Xo no voxo ane ne, anu voxovoxo sou tuꞌutuꞌumaxu manina, umomomo no anu voxo ane tatei Lataua mukoinu xalexalee tuatuala mo utalo vaimomo mo iliꞌi la uasi manina. ");
INSERT INTO ata_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ia lexe Tila uxoto voxo ane ne uxali kulunu uasi, la evile umomomo sou umauli uasi. Ia tavaꞌu xo aneꞌi ta mitema ane anu musovosiꞌa lexe anu ta mitema noxou maninasou, la sou ane anu uxotonu voxo ne uxali kulunu. ");
INSERT INTO ata_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","No voxo ane ne, la evile uvikalangengi aloxo ꞌo, ‘Ngamaisou, Kalisito ano ꞌo!’ Uasi, uvikala lexe, ‘Ngamaisou, anu ꞌole!’, la mamu sou ngamuxamuxaxu tangengi no anu vaikalau. ");
INSERT INTO ata_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Xo ta mitema seꞌi ixali, la ikalavoi lexe aneꞌi Kalisito xe aneꞌi ta mitema sou palomatana. Lexe ixali, la iꞌoxonu sosovo seꞌi uxali mo mimii seꞌi sou ta mitema imaisou la ikuluke no anu kalumo, lexe anu umomomo sou ikalavoineꞌi ta mitema ane Lataua musosovosiꞌa lexe ta naꞌu ꞌole. ");
INSERT INTO ata_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","La sou ane eni avikalangengi lexe ngasaxilaꞌinge laixe, xo mimii latala ane uxali noxinge iliꞌi, ane evikalangengixu mukalu ne. ");
INSERT INTO ata_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ia no voxo ane iliꞌi no anu voxo sou tuꞌutuꞌumaxu ukalu, la, ‘aso ne uxali isivoxo mo soꞌio ne uiei la uasi, ");
INSERT INTO ata_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ta oto ne, ilapalapau no opo loxotolo iluꞌe, mo ta mimii loxo taꞌumali iloꞌa koiuxaxai mo tavaivolo no opo loxotolo ne ikunikuni.’ ");
INSERT INTO ata_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","No voxo ane ne, la ta mitema imaisou Itema ꞌOlu mine uluꞌe no umuumu no anu xavi mo lamana toxoxaꞌa noxou. ");
INSERT INTO ata_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","La sou Anu upalusiꞌa ta angelo noxou sou inoꞌa aneꞌi ane noxou e Anu molu musovosiꞌa meꞌa no atume iou tamiꞌa, xe no xalexalee lia teletelexu ꞌo, ulai utalo no teletelexu loxotolo ukalusi.” ");
INSERT INTO ata_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Xe Iesu muavuti la muvikala aloxo ꞌo la, “Anu laixe lexe ngingi nganoꞌu lavulavu no anu ovu lovo. No voxo ane ovu xolanu uxali xe uxalixu xataxataxu, la ngingi ngelavu lexe anu voxo laixe sou aso a uxali ꞌalai. ");
INSERT INTO ata_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lexe ngingi ngamaisou sosovo iouiou uxali, la anu aloxo nesi. Ngingi ngalavusi lexe voxo sou Itema ꞌOlu ꞌa uneꞌe ne. Muxali ꞌalai manina. ");
INSERT INTO ata_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eni avikalangengi manina aloxo ꞌo, ta mitema sou voxo ano ꞌo isoisoli uao, ia mimii ane eni elemolu lamana noxinge ne, anu uxali. ");
INSERT INTO ata_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mii latala teitexi no opo loxotolo mo no lia ꞌo ne, ulai la ukalu. Ia vaivaikala noxilo ne ukalu uasi. ");
INSERT INTO ata_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Evile ulavu no anu voxo ane ne uasi. Ta angelo teitexi no opo loxotolo mo ꞌOlu ne ilavusou uasi, ia Momusi Anu mulavusou. ");
INSERT INTO ata_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngasaxilaꞌinge laixe. Mo ngautiti laixe. Xo ngingi ngalavusou lexe voxo ane ne uxali talu uasi. ");
INSERT INTO ata_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Anu aloxo itema vile ulai no tuala vile vaꞌaxu. Ulutu la uꞌumesou taasou sou ulai, io umuxaxaꞌa ta mitema sou xaixai noxou sou isaxilaꞌu. Anu muvelu xaixai noxiꞌa vilevilesi, ia ane sou usaxilaꞌu aitenga ne, muvikalanu sou lexe uutiti uxoxolu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Anu aloxo ne, la sou ngingi ngautiti laixe, xo ngingi ngalavusou voxo ane tatananu tani ulivu uneꞌe no anu uasi. Male uxali no ꞌoloꞌolovoxo. Uasi la, no ꞌolovoxo lixinu. Uasi la, no kakau mine ta kokoꞌa iꞌavaꞌava. Uasi la, no aso uxali utetelo. ");
INSERT INTO ata_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Lexe anu uxali upasipaangengi, la mamu sou ngingi ꞌa ngaai. ");
INSERT INTO ata_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Vaivaikala ane eni elemolu noxinge ꞌo ne, eni elemolu noxiꞌa ta mitema latala ne mukalusi. Ngaxoxolu ia ngautiti laixe.” ");
INSERT INTO ata_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Voxo tamei a uao no anu voxo ane isosovosou voxo e Lataua Mupolopepeeneꞌi Ta Isilaeli xe voxo e Ixutuxu Laꞌilaliaxaꞌa Vitanisi, la ta tatila noxiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto mikamuli voteꞌi sou lexe itetelisou Iesu mo ivau usoli. ");
INSERT INTO ata_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Miavuti la mivikala aloxo ꞌo, “Nenge taꞌoxo mii ane nenge tevivikalasou ꞌo no nixi no anu voxo tila ꞌo uasi, xo loxo ꞌo io ta itema imaisinge la iavutinoxu ꞌotoꞌoto.” ");
INSERT INTO ata_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Anu Iesu a mulai mo ꞌa muꞌunalai no tani noxou itema vile ualasou lexe Saimoni. Saimoni ne, vulukali muꞌoxonu. Iesu muꞌunalai mo mulai mutalupexa sou lexe uꞌani. Ia sema vile minoꞌu lavotoli vile ne sou ueli e tumaꞌu lailaixe. Lexa ane ne, lamoli sou tila misevile. Minoꞌu xe milai mixali noxou Iesu, la mixolaꞌu anaxu ka minixiꞌu noxou Iesu kisou. ");
INSERT INTO ata_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ta mitema seꞌi ane iloꞌa Iesu mixoxolu ne, mimaisie la laꞌiaxaꞌa, la mivikalaneꞌi ngatoꞌo lexe, “Tavaꞌu loxovaa ane, sema ꞌo ivilaꞌisou ueli e tumaꞌu lailaixe loxo ꞌo? ");
INSERT INTO ata_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lexe uaisi mo sou lexe ilotonu no anu Denalia itemaxu mavulovexa vile mo itemaxu taꞌuve (300), la sou nenge taitiꞌa ta mitema ane iꞌa mimii uasi.” Taneꞌi laꞌiaxaꞌaie misevile la sou mivikala aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Xe Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Iengi uvaxaiesi. Loxovaa ane ngingi ngalosie tuꞌumaxu ane loxo ne? Mii ane ane miꞌoxonu muneꞌe noxilo ne, anu laixe misevile. ");
INSERT INTO ata_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ta mitema ane iꞌa mimii uasi ne, anu voxovoxo piepiena ꞌa uxoxolu sou ngingi ngaitiꞌa mimii loxo ngemasaxau, xo ngingi ngongiꞌa ngaxoxolu. Ia eni ne, nenge nengeꞌa taxoxolu utotomu uasi. ");
INSERT INTO ata_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ane miꞌoxonu mii ane ne, ane mumomomo noxie sou lexe iꞌoxonu. Ane minixiꞌu ueli e tumaꞌu lailaixe no vasimelo tei loxo ne, sou ulalaxi vasimelo sou mine ilai iꞌasixo. ");
INSERT INTO ata_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eni avikalangengi manina aloxo ꞌo. No xalexalee tuatuala neꞌei neꞌei ne, lexe ilai iaꞌaloxu aꞌalo laixe, la mii e ane miꞌoxonu ne, aneꞌi iaꞌaloxu kalumo la ixavutalane.” ");
INSERT INTO ata_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Xe Iudasi Isikarioti, anu vile noxiꞌa ta molomolou mavulovexa mo mulelia tamei ne, muavuti la mulai muxali noxiꞌa ta ailiꞌi sou lexe anu uꞌitalonu Iesu ulai no avoꞌa. ");
INSERT INTO ata_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aneꞌi milomu noxou aloxo ne, la oponeꞌi muꞌosa manina, la sou aneꞌi misakii vaikala lexe ilosou lamoli. La sou Iudasi muavuti sou ukamuli voteꞌi sou uꞌitalonu Iesu no avoꞌa. ");
INSERT INTO ata_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Voxo vilesou Ixutuxu Laꞌilalixaꞌa Vitanisi ꞌa muxali, la no voxo ane ne, aneꞌi ilavusou iveꞌa ta sipsip ta ꞌiliꞌa sou iꞌoxonu laꞌilali sou ixavutalanu voxo ane sou Lataua Mupolopepeeneꞌi Ta Isilaeli no anu. Xe ta molomolo noxou Iesu miavuti la mitaliꞌisou aloxo ꞌo, “Nini nemasaxa lexe nexi talalaxii laꞌilalixene sou voxo sou Lataua Mupolopepeeneꞌi Ta Isilaeli ꞌava?” ");
INSERT INTO ata_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","La sou Iesu mupalusiꞌa ta molomolo noxou tamei, la muvikalaneꞌi aloxo ꞌo, “Ngalai no nano no tuala tila xe ngaxalisou itema vile utatavulenu lexa vexasou mutau lexa no anu, la ngamulinu. ");
INSERT INTO ata_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ngongou ngalai xe ngaxali no tani e anu uꞌunalai no anu ne, la ngavikalanu tatananu tani ne aloxo ꞌo, ‘Itema sou ulosixe lavulavu mutaliꞌi aloxo ꞌo. Tani kapiutuxu noxou ane sou nexi noxiꞌa taꞌani laꞌilali sou tasosovosou voxo sou Lataua Mupolopepeeneꞌi Ta Isilaeli no anu ꞌava?’ ");
INSERT INTO ata_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","La sou anu ulosiengixu kapiutu vile tatila muxolu teitexi. Valovalo mo luuluusou mo mimii seꞌi kalumo ne a mulalaxii mukalu. Ngongou ngalai, la sou ngalalaxiinu laꞌilalinenge ane.” ");
INSERT INTO ata_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aneꞌi ilou milai xe miꞌunalai no tuala tila, la ilou mimaisou mimii ne aloxo Iesu mulemolu noxiꞌa ilou. La sou ilou milalaxi laꞌilalixaꞌa iloꞌa. ");
INSERT INTO ata_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Xe no ꞌoloꞌolovoxo, la sou anu Iesu iloꞌa ta molomolo noxou mulelia tamei ne mixali. ");
INSERT INTO ata_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iloꞌa mitaꞌolu sou iꞌaniꞌani, ia Iesu muavuti la muvikalaneꞌi aloxo ꞌo, “Eni avikalangengi manina aloxo ꞌo, vile nonixi noxinge ne, ulai la anu uꞌitaloleli alai no avoꞌa ta mitema. Anu ꞌa nexi noxou taꞌaniꞌani ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xe aneꞌi milomu aloxo ne, la oponeꞌi tuꞌumaxu, la sou aneꞌi vilevilesi miavuti la mitaliꞌisou aloxo ꞌo, “Male, eni uasi, ne?” ");
INSERT INTO ata_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Itema ne anu vile noxinge ngingi mulelia tamei ne.” Anu mukolineꞌi aloxo ne. “Anu e loxo nexi noxou taꞌuinu laꞌilali no anu paku vilesisi. ");
INSERT INTO ata_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Itema ꞌOlu ne, ulaisi mo uulua aloxo vaivaikalasou mikaukavunu no anu Lavuku Tavuna teinu. Ia laixe lexe Lataua uvavaaxu itema e uꞌitalonu Itema ꞌOlu ulai no avoꞌa ta mitema. Lexe ane nenu ivoꞌonu uasi, la anu laixesi.” ");
INSERT INTO ata_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iloꞌa iꞌaniꞌani, ia Iesu mukasi muluꞌe no anu veleti sou munoꞌu sou muvikala laixe musuku noxou Lataua xe mukalu, la museꞌiseꞌinu sou mulosilosiꞌa vilevilesi la muvikalaneꞌi aloxo ꞌo, “Nganoꞌu. Vasimelo ane.” ");
INSERT INTO ata_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xe muavuti la mukasi vaxa no anu paku sou uaini, la muvikala laixe musuku noxou Lataua. Xe mukalu la mulosiꞌa sou aneꞌi latala ne miiexu. ");
INSERT INTO ata_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","La sou muvikalaneꞌi aloxo ꞌo, “Sialuxo ano ꞌo. Eni asoli xe sialuxo unixi, la anu uꞌoxonu vaikala e nenge nengeꞌa Lataua tesakiinu ꞌo, uxali manina. Sialuxo ne, sou unixisiꞌa ta mitema tavuꞌalo sou upamaulineꞌi.” ");
INSERT INTO ata_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Xe muavuti la muvikalaneꞌi aloxo ꞌo la, “Avikalangengi manina. Umomomo sou eni aie la no anu uaini temanu uasi, ulai utalo no voxo ane sou eni aiexu ane alavua no tuala teitexi noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iloꞌa miꞌani mukalu la milexe lexe vile sou iloꞌa milaa milai no laxaꞌilu ne Olivu. ");
INSERT INTO ata_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iloꞌa milai xoo la Iesu muvikalaneꞌi aloxo ꞌo la, “Ngingi latala ꞌo ne ulai, la ngaꞌumesilo ukalusi. Xo vaikala vile mikaukavunu muxolu no anu Lavuku Tavuna teinu aloxo ꞌo, ‘Ulai, la eni avau itema sou usaxilaꞌa ta sipsip, la aneꞌi ta sipsip ne iꞌume ipaxele.’ ");
INSERT INTO ata_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ia iliꞌi, eni atulu sou amauli, la eni auli alai ne Xalilaia.” ");
INSERT INTO ata_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Xe Pita muavuti la muvikalanu lexe, “Ulai, la latala ꞌo ne, iꞌumeꞌume ukalusi, ia eni ne uasi.” ");
INSERT INTO ata_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Xe Iesu muavuti la mukolinu Pita vaikalau aloxo ꞌo, “Eni avikalaneni manina aloxo ꞌo, maasi no ꞌolovoxo ꞌo, la kokoꞌa uꞌava alaxu tamei uao, ia nini nasingisilo alaxu tatalu lexe nalavusilo uasi.” ");
INSERT INTO ata_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ia Pita ne, mutotoiti misevile. Xe muavuti la muvikala pekiaꞌu aloxo ꞌo, “Eni umomomo sou asingisine lexe eni alavusine uasi, xo nenge nengei tasoli takei.” Aneꞌi Pita ta menexu ne, mivikala kalumo aloxo ne. ");
INSERT INTO ata_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iloꞌa mimuamuaꞌi xe milai mixali no lia xalee ilemolu lexe Xetesemane, la Iesu muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Ngataꞌolu ano, ia eni alai alinga.” ");
INSERT INTO ata_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Munoꞌa Pita ilou Iakovo mo Ioanesi sou iloꞌa milai, la Anu tanu lili xe opo tuꞌumaxu. ");
INSERT INTO ata_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Iloꞌa tatalu ne, milai la sou muvikalaneꞌi aloxo ꞌo, “Ngaxolu ano mo ngautiti laixe. Xo eni opoleli tuꞌumaxu mo eni ꞌa ꞌalaꞌalai sou asoli.” ");
INSERT INTO ata_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Musuku mulai sevile vaꞌaxu noxiꞌa mukalu, la sou mutangatulu muluꞌelai no lia sou mulinga. Mulinga lexe voxo sou tuꞌumaxu ane ne uxexesou. ");
INSERT INTO ata_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mulinga la, la muvikala aloxo ꞌo, “Aba, Mamilo. Mimii latala ne, pekiaꞌu noxine sou naꞌoxonu uasi. La sou eni emasaxa lexe naxexeenu soli noxilo uxexesilo. Ia namulinu masaxa noxilo uasi, namulinu masaxa noxinesi.” ");
INSERT INTO ata_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mulivu mulai noxiꞌa ta molomolo noxou tatalu ne, la aneꞌi ꞌa iai, xe muavuti la muvikalanu Pita aloxo ꞌo, “Saimoni, nini ꞌa naai? Loxovaa, nautiti naxolu no aso iou taiinu vile uasi? ");
INSERT INTO ata_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nautiti mo nalinga, mo sou tovotovo uxali noxine la utaloxolixene uasi. Manina musuku, itema uleenu umasaxa lexe uxaxai, ia vasimolu ne pekiaꞌu uasi, mamalaxusi.” ");
INSERT INTO ata_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iesu muneꞌe muvivikalaneꞌi aloxo ne xe mukalu, la mulivu sou mulai mulinga la. Anu mulinga aloxo tei ne. ");
INSERT INTO ata_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mulivu muneꞌe, la aneꞌi ꞌa iai sio, xo ieꞌi uvuvu sio. Xo taneꞌi tema uao, la sou ivikalanu no anu vaikala vile uasi. ");
INSERT INTO ata_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xe mulivu mulai sou mulinga xe mulivu muneꞌe noxiꞌa alaxu tatalusou, la aneꞌi ꞌa iai sio, la mutaliꞌisiꞌa aloxo ꞌo, “Ngingi ꞌa ngaaisi sou ngamaꞌila? Mumomomo aloxo ne! Voxo ꞌa muxali. Ngamaisou! Aneꞌi ta mitema iꞌitalonu Itema ꞌOlu no avoꞌa ta mitema ane ilavusou iꞌoxonu ꞌilixo ane masumasua. ");
INSERT INTO ata_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ngatulu mo nengeꞌa talai. Ngamaisou! Itema e uꞌitaloleli no avoꞌa ta mitema ne, anu a uxali ꞌo.” ");
INSERT INTO ata_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu uvivikala ꞌo, ia alaxu vilesisi ꞌo, la Iudasi muneꞌe noxou. Anu vile noxiꞌa ta molomolou mulelia tamei. Anu iloꞌa ta mitema tavuꞌalo mixali, ia ta mitema mitetelisou viso ilou kuluvololou. Ioxe, ta mitema ane ne, aneꞌi ta tatila noxiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto mo ta tatila mipalusiꞌa mineꞌe. ");
INSERT INTO ata_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Itema e muꞌitalonu Iesu no avoꞌa ta mitema ne, muvikalaneꞌixu sosovo vile tei aloxo ꞌo, “Lexe eni atimu no xaleenu, la Anu ane. Ngatetelisou mo ngalailixu, ia ngasaxilaꞌu laixe.” ");
INSERT INTO ata_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ioxe, Iudasi muxali, la alaxu vilesisi anu mulai noxou. Muvikalanu aloxo ꞌo, “Rabi”, la sou mutimu no xaleenu. ");
INSERT INTO ata_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aneꞌi mimaisou Iudasi mutimu no xaleenu, la sou aneꞌi mikasi vaxa no avolu sou mitetelisou. ");
INSERT INTO ata_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Itema vile mutulu ꞌalai noxou Iesu mulavee viso ka muvali vaxa no sangalou itema sou xaixai noxou kisiꞌa ta ailiꞌi. Sangalou ne, muxoto la mulapau. ");
INSERT INTO ata_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu muvikalaneꞌi aloxo ꞌo, “Ngingi ngenoꞌu viso xe kuluvololou sou ngeneꞌe sou ngatetelisilo xo eni amitema sou aavutilixu ꞌotoꞌoto? ");
INSERT INTO ata_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","No voxovoxo ꞌo, nengeꞌa texoxolu no nano no taasou lalotu tatila noxou Lataua sou elosiꞌa ta mitema lavulavu, ia loxovaa la ngatetelisilo ua? Mii vile uasi. Xo vaikala muxolu no nano no Lavuku Tavuna teinu ne, muxali manina.” ");
INSERT INTO ata_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aneꞌi ta molomolo noxou latala milomu aloxo ne, la miꞌume sou milailai. ");
INSERT INTO ata_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Maulu vile e mumulinu Iesu ne, mutaa tokolomo maenaxu vilesisi. Ia aneꞌi ta mitema mitovo lexe itetelisou, ");
INSERT INTO ata_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","la anu muꞌume mulai pangapangaꞌusi. Tokolomou ne, muluvu muai. ");
INSERT INTO ata_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xe iliꞌi, la aneꞌi ane mitetelisou Iesu ne, milailixu noxou kisiꞌa ta ailiꞌi. Io, ta tatila noxiꞌa ta ailiꞌi latala iloꞌa ta tatila mo ta mitema sou lapuloto ꞌa ipita ixolu. ");
INSERT INTO ata_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ne, anu mumulinu Iesu muiliꞌi no paxa. Anu muxali no vimelusou tani noxou kisiꞌa ta ailiꞌi, la muꞌunalai sou iloꞌa ta mitema sou isaxilaꞌu tani mixolu sou mutuꞌe navu. ");
INSERT INTO ata_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ia, ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatila sou ipotosou tuꞌutuꞌumaxu noxiꞌa ta mitema latala ne, ikamuli susu noxou Iesu sou ivau usoli, ia ixalisou vile uasi. ");
INSERT INTO ata_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ta mitema tavuꞌalo mitelo vaikala noxou, ia vaikalaiꞌa ne vilesisi uasi. ");
INSERT INTO ata_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Seꞌi mitulu sou mikalavoisou Iesu aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nexi telomusou muvikala aloxo ꞌo, ‘Eni akisilalanu tani tila noxou Lataua aneꞌi ta mitema mitulusou no avoꞌa, ia iliꞌi no anu voxo tatalusou la atulusou ulivu la, ia atulusou no avolo loxo ta mitema itulusou uasi.’” ");
INSERT INTO ata_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ia vaikala noxiꞌa ne kalumo vilesisi uasi. ");
INSERT INTO ata_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ioxe, kisiꞌa ta ailiꞌi mutulu no talaxaꞌa ta mitema, la mutaliꞌisou Iesu aloxo ꞌo, “Nini namasaxa nakoli vaikalaiꞌa ane mutelo noxine ne uasi? Nini naxavutala a loxovaa no anu vaikala ane mutelo noxine ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ia Iesu mutaloxaꞌasi. Anu ukolinu vaikalaiꞌa vile uasi. La kisiꞌa ta ailiꞌi mutaliꞌisou la aloxo ꞌo, “Nini Kalisito ane? Itema ane ualusinge, ꞌOlu ane nini ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu mukolinu aloxo ꞌo, “Eni ano. Ngingi ngamaisou Itema ꞌOlu uvaꞌisaꞌinu no avo tema Itema sou xavi mo uneꞌe uluꞌe no anu umuumu molu no opo loxotolo.” ");
INSERT INTO ata_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Anu mulomusou Iesu muvikala aloxo ne, la mukakanu tokolomou, xo anu laꞌiaxu. Xe muvikala aloxo ꞌo, “Nenge tataliꞌisiꞌa ta mitema seꞌi sou ipalaꞌalixu ꞌilixonu la uasi. ");
INSERT INTO ata_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ngingi ngelomu lexe Anu muvikala masua mulai noxou Lataua. Ngingi ngaxavutala loxovaa? Nenge taꞌoxo maꞌia ane noxou?” Aneꞌi latala mikolinu aloxo ꞌo, “Anu mususu ane ne. Anu usoli.” ");
INSERT INTO ata_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aneꞌi mivikala aloxo ne xe mukalu, la seꞌi misoko sou mituvesou. Misuꞌasou iou xe mivau. La mivikalanu aloxo ꞌo, “Nalemo lexe ꞌei ane muvene?” Ia, ta mitema sou isaxilaꞌu tani minoꞌu sou misavasavalou. ");
INSERT INTO ata_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ta mitema miꞌoxoꞌoxonu Iesu aloxo ne, ia Pita ne, anu muxolu no nano no vimelusou tani, la sema sou xaixai vile noxou kisiꞌa ta ailiꞌi, mineꞌe noxou. ");
INSERT INTO ata_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","La mimaisou Pita uxoxolu utuꞌe navu, la sema ne mimatakisou la mivikalanu aloxo ꞌo, “Nini kalumo, ngingi ngongou Iesu sie Naseleti ngexolu ane.” ");
INSERT INTO ata_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ia anu musingisou lexe, “Eni alavusou vaikala ane nini nelemolu ne, uasi.” Anu muvikala aloxo ne xe mukalu, la sou anu mulaa muuatulai no aitengaxu tani. ");
INSERT INTO ata_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sema ne, mimaisou, la mivikalaneꞌi aneꞌi ane itulutulu ꞌalai noxou aloxo ꞌo, “Anu ne, vile noxiꞌa ane.” ");
INSERT INTO ata_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ia anu musingisou lexe uasi la. Mixolu sevile kituꞌa, la ta mitema ane mitulutulu ꞌalai noxou ne, mivikalanu aloxo ꞌo, “Manina, nini vile noxiꞌa ane, xo nini itema sie Xalilaia ane.” ");
INSERT INTO ata_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ia Pita muvikala pekiaꞌu aloxo ꞌo, “Manina teitexi, eni alavusou itema e ngingi ngalelemolu ne uasi. Lexe eni akalavoingengi, la laixe lexe Lataua ukalusilosi.” ");
INSERT INTO ata_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Anu muvikala aloxo ne, xe mukalu la alaxu vilesisi ꞌo, la kokoꞌa muꞌava alaxu tameisou. La Pita muxavutalanu vaikalau Iesu lexe kokoꞌa uꞌava alaxu tameisou uao, ia anu usingisou alaxu tatalu lexe ulavusou uasi. La Pita ne, mutaloxu iii sou mutama. ");
INSERT INTO ata_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Xe iliꞌi no kakau manina, la ta tatila noxiꞌa ta ailiꞌi iloꞌa ta tatila mo ta mitema sou lapuloto mo ta tatila sou ipotosou tuꞌutuꞌumaxu noxiꞌa ta mitema latala, mipita sou mipotoxu Iesu. Xe mukalu, la sou misakiinu sou milailixu noxou Pilato avolu. ");
INSERT INTO ata_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Anu Pilato mutaliꞌisou Iesu aloxo ꞌo, “Nini tatananu tuala noxiꞌa ta Iutaia ne?” La anu mukolinu vaikalau aloxo ꞌo, “Ani, anu aloxo nini nelemolu ne.” ");
INSERT INTO ata_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta tatila noxiꞌa ta ailiꞌi milomu aloxo ne, la mileanu vaikala tavuꞌalo mulai noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","La Pilato mutaliꞌisou la aloxo ꞌo, “Loxovaa, la nini nakoli vaikala vile ua ꞌo? Nini nelomusou lexe aneꞌi mileanu vaikala tavuꞌalo muneꞌe noxine.” ");
INSERT INTO ata_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ia Iesu ukolinu vaikala vile la uasi. Anu aloxo ne, la sou Pilato mukuluke no anu. ");
INSERT INTO ata_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Io, no voxo tila ane ne, la Pilato ulavusou sou ululusou itema vile uxolu no nano no taasou navunavu. Ta mitema meꞌasi ilavusou isosovosou itema vile. ");
INSERT INTO ata_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","No voxo ane ne, la itema vile ualasou lexe Valavasi iloꞌa ta mitema seꞌi mixolu no taasou navunavu. Xo aneꞌi miavutinoxu ꞌotoꞌoto noxiꞌa aneꞌi ane isaxilaꞌu tuala ne, la miveꞌa ta mitema seꞌi misoisoli. ");
INSERT INTO ata_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ioxe, ta mitema tavuꞌalo mixali noxou Pilato, la mitaliꞌisouxu mii ane anu ulavusou uꞌoxoꞌoxonu tatei noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Anu mukolineꞌi la muvikala aloxo ꞌo, “Ngingi ngemasaxa lexe eni alulusou tatananu tuala noxiꞌa ta Iutaia ulai noxinge?” ");
INSERT INTO ata_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Muvikala aloxo ne, xo mulavu lexe aneꞌi ta tatila noxiꞌa ta ailiꞌi, taneꞌi masuau Iesu misevile, la sou milailixu sou mitulusou no anu vaivaikala. ");
INSERT INTO ata_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ia aneꞌi miavutinoxu oponeꞌi ta mitema sou lexe ululusou Iesu uasi, ululusou Valavasisi ulai noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","La sou Pilato mutaliꞌisiꞌa la aloxo ꞌo, “Ngingi ngemasaxa lexe eni aꞌoxonu mii maꞌia noxou itema ane ngingi ngalemolu lexe tatananu tuala noxiꞌa ta Iutaia?” ");
INSERT INTO ata_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aneꞌi mikoli la miꞌava aloxo ꞌo, “Talilixu no ovu valautu!” ");
INSERT INTO ata_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Anu mutaliꞌisiꞌa aloxo ꞌo la, “Loxovaa? Anu muꞌoxo susu maꞌia?” Ia aneꞌi miꞌava tatila aloxo ꞌo, “Talilixu no ovu valautusi!” ");
INSERT INTO ata_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Anu mululusou Valavasi mulai noxiꞌa, xo anu umasaxa lexe uꞌoxo aloxo ne sou aneꞌi iꞌosasou. Anu muvikalaneꞌi ta mitema sou ꞌotoꞌoto lexe aneꞌi ipuapuasou. Mipuapuasou mukalu, la sou muꞌitalonu mulai no avoꞌa ta mitema sou ꞌotoꞌoto sou lexe ililixu no ovu valautu. ");
INSERT INTO ata_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xe iliꞌi, la aneꞌi ta mitema sou ꞌotoꞌoto milailixu Iesu muꞌunalai no nano no vimelusou taasou itema sou xaixai noxou tatananu tuala ne Romu. La aneꞌi miꞌavaliꞌa ta mitema sou ꞌotoꞌoto latala mineꞌe mipita. ");
INSERT INTO ata_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aneꞌi mineꞌe mipita mukalu, la mitaanu tokolomo lauoinu noxou xe mipalipaxoxonu savovolu ka mimuxaxu no kisou loxo kisivalu sou sosovo lexe Anu tatananu tuala vile ane. ");
INSERT INTO ata_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aneꞌi miꞌoxonu aloxo ne xe mukalu, la sou mivikalanu aloxo ꞌo, “Anu ane, tatananu tuala noxiꞌa ta Iutaia!” ");
INSERT INTO ata_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xe mivavau kisou no anu lukae xe mituvetuvesou xe mitangatangatulu muluꞌelai no lia sou miꞌitinu ualasou. ");
INSERT INTO ata_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aneꞌi mimolovilaꞌisou aloxo ne xe mukalu, la sou aneꞌi mixexeenu tokolomo lauolauoinu noxou. Ia mimulaxu tokolomoxu vaxa la. La sou milailixu sou lexe ililixu no ovu valautu. ");
INSERT INTO ata_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Itema vile ualasou lexe Saimoni, tualasou ne Kilene, anu Alekisanda ilou Rupusi mamiꞌa. Anu molu no tuala vile ꞌalai ne Ielusalemu, ia muneꞌe mupolopepeeneꞌi sou lexe uꞌunalai no tuala tila. Aneꞌi ta mitema sou ꞌotoꞌoto mimaisou, la mivikala pekiaꞌu noxou lexe anu utavulenu ovu valautu noxou Iesu. ");
INSERT INTO ata_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aneꞌi minoꞌu Iesu sou milailixu no tuala ilemo lexe Xoluxata. Uala ane ne, laaxu lexe tuala sou ta mitema xavananeꞌi. ");
INSERT INTO ata_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aneꞌi milosou Iesu uaini ane mixiunu ilou lamalasile sou uxamuli navunavu uasi. Ia Anu uiexu uasi. ");
INSERT INTO ata_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Xe iliꞌi, la sou mililixu Iesu no ovu valautu. Aneꞌi mimilaꞌanu tokolomou Iesu noxiꞌa vilevilesi. Ia aneꞌi miꞌoxonu vilaꞌi vile sou misosovosou lexe ꞌei ane unoꞌu mii maꞌia maꞌia. ");
INSERT INTO ata_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aneꞌi mililixu Iesu no ovu valautu, la anu aso iou muxatele tamiꞌa no kakau. ");
INSERT INTO ata_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Vaikala e anu mususu no anu ne, aneꞌi mikaukavunu no paꞌumolu aloxo ꞌo, “Tatananu Tuala Noxiꞌa Ta Iutaia Ane.” ");
INSERT INTO ata_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Aneꞌi mililixaꞌa ta mitema tamei sou pakali no paꞌumolu kalumo. Mililixu vile no avo tema xe vile mililixu no avo ae. ");
INSERT INTO ata_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ta mitema mimuamuaꞌi xe mipolopepeenu la milulu kisiꞌa sou mimolovilaꞌisou la mivikala aloxo ꞌo, “Ae, nini namitema sou namamulonu tani tila noxou Lataua ka natulusou ulivu no voxo tatalusi ane. ");
INSERT INTO ata_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ioxe nini naluꞌe no ovu valautu mo nini mene napamaulineni la.” ");
INSERT INTO ata_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta tatila noxiꞌa ta ailiꞌi iloꞌa ta mitema sou lapuloto kalumo mimolovilaꞌisou mo mivikala ngatongatoꞌo noxiꞌa aloxo ꞌo, “Anu mupamaulineꞌi ta mitema vaꞌaxaꞌa, ia Anu umomomo sou upamaulinu uasi. ");
INSERT INTO ata_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lexe nini Kalisito, tatananu tuala ne Isilaeli, la ane ꞌalalae ꞌosi naxexee no anu ovu valautu mo naluꞌe, mo sou nexi tamaisine, la sou tamuxamuxaxu tanexi ulai noxine.” Ta mitema tamei aneꞌi mililixaꞌa no paꞌumolu ne, ilou mimolovilaꞌisou kalumo. ");
INSERT INTO ata_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aso mukulupa, la isivoxo mutaasou xalexalee tuatuala mukalusi, mole aso iou tatalu no ꞌoloꞌolovoxo. ");
INSERT INTO ata_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Io, aso iou tatalu mukalu, la sou Iesu muꞌava tatila aloxo ꞌo, “Eloi, Eloi, lama savakatani?” Laaxu lexe, “Lataua noxilo, Lataua noxilo, loxovaa la nini nesuꞌaleli ꞌo?” ");
INSERT INTO ata_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta mitema seꞌi mitulutulu ꞌalai noxou ne, la milomusou vaikala ane ne, la mivikala aloxo ꞌo, “Ngalomu, Anu a uꞌavalou Eliasi.” ");
INSERT INTO ata_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ioxe, itema vile muiave mulai la munoꞌu kateni sou mutaa muluꞌelai no uaini sixula. Xe mukalu, la mutotole vaxa no lukae telexu sou muienu no anu. Ia anu muvikala aloxo ꞌo, “Taxolu o, mo tamaisou. Eliasi uneꞌe sou unoꞌu uluꞌenu no lia male.” ");
INSERT INTO ata_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ia Iesu muunga tatila mukalu, la sou Anu musoli. ");
INSERT INTO ata_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iesu musoli, la lavalava e mulili no nano no tani tila noxou Lataua ne, mukakaa tamomolu teitexi mulai mupee no lia. ");
INSERT INTO ata_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Itema tila sou uulaxuneꞌi ta mitema itemaxu taꞌuve sou ꞌotoꞌoto ne, mutulu no talaxu Iesu. Anu mulolomusou Iesu mine muunga mo mumaisou mine musoli. La sou anu muvikala lexe, “Manina musuku, itema ane ne Anu Lataua ꞌOlu ane.” ");
INSERT INTO ata_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ia ta sema seꞌi a itutulu vaꞌaxu sevile sou imamalei. Vile noxiꞌa ane Malia sie Maxatale, xe Malia ane Iakovo kituꞌa ilou Iosesi neniꞌa mo Salome kalumo. ");
INSERT INTO ata_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iesu muxoxolu ne Xalilaia, la aneꞌi mimulimulinu sou misuꞌulinu. Ta sema tavuꞌalo iloꞌa Iesu minuna ne Ielusalemu ne, aneꞌi a itutulu kalumo. ");
INSERT INTO ata_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Voxo ane ne, anu voxo sou lalaxi sou Voxo Tavuna. Mo anu a ꞌalai sou ꞌolovoxo. ");
INSERT INTO ata_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","La sou Iosepu sie Alimatia, anu uꞌume uasi, mulai noxou Pilato sou mulingau Iesu vasimolu. Anu ne, ta mitema itoxonu xo itema vile noxiꞌa ta tatila sou ipotosou tuꞌutuꞌumaxu noxiꞌa ta mitema xe anu itema vile sou uxomaiou saxisaxilaꞌu noxou Lataua sou uneꞌe kalumo. ");
INSERT INTO ata_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato mukuluke xo mulomusou lexe Iesu ꞌa musoli palea ne. La sou anu muꞌavalou itema tila sou uulaxuneꞌi ta mitema itemaxu taꞌuve sou ꞌotoꞌoto sou mutaliꞌisou aloxo ꞌo, “Iesu ꞌa musoli io, uasi uao?” ");
INSERT INTO ata_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Itema ne muvikalanu mukalu, la sou Pilato muꞌitalonu Iesu vasimolu mulai noxou Iosepu. ");
INSERT INTO ata_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","La sou Iosepu mulai muloto lavalava vile maenaxu sou muneꞌe munoꞌu Iesu vasimolu muluꞌe sou mukupoonu no anu. Mukupoonu mukalu, la sou munoꞌu vasimolu mulailixu no lulu vile. Lulu ne, miꞌasou no tavaꞌu maea. Xe mukalu, la sou mupipaloꞌu lavoꞌo tatila muneꞌe mutaloxu lulu anaxu no anu. ");
INSERT INTO ata_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia sie Maxatale ilee Malia ane Iosesi nenu a itutulu imamalei mo mimaisou tuala e mumulaxu Iesu vasimolu no anu. ");
INSERT INTO ata_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Voxo Tavuna mukalu, xe iliꞌi la Malia sie Maxatale ilee Malia, Iakovo nenu mo Salome, aneꞌi milotonu ueli e tumaꞌu lailaixe sou milai lexe iꞌulosou Iesu vasimolu no anu. ");
INSERT INTO ata_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","No kakau manina no voxo vilesou lalotu vaꞌa vile no mine aso upolosile, la aneꞌi milutusou milai no lulu. ");
INSERT INTO ata_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","No voteꞌi, la aneꞌi mivikalaneꞌi ngatongatoꞌo aloxo ꞌo, “ꞌEi ane sou usuꞌulinenge mo upipaloꞌu lavoꞌo e mimulaxu no lulu anaxu?” ");
INSERT INTO ata_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ia, aneꞌi ieꞌi mutelo la mimaisou lavoꞌo toxoxaꞌa ne, uai la uasi. Mipipalou muxexe ne. ");
INSERT INTO ata_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ioxe, aneꞌi miꞌunalai la mimaisou maulu vile a uxoxolu no avoꞌa tema. Ia anu mutaa tokolomo maenaxu veveeni. Aneꞌi mimaisou la mikuluke. ");
INSERT INTO ata_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ia anu muvikalaneꞌi aloxo ꞌo, “Ngakuluke mamu. Eni elavu lexe ngingi ngakakamuli Iesu sie Naseleti aneꞌi mililixu no ovu valautu. Anu a mutulu mo mumauli ne, anu uai ꞌo uasi. Ngamaisou tanixu ane aneꞌi mimulaxu no anu ꞌa. ");
INSERT INTO ata_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ia, ngalai mo ngavikalaneꞌi ta molomolou Iesu mo Pita lexe Anu ꞌa muulaxungengi mulai ne Xalilaia sou lexe ngamaisou ane, aloxo Anu mulemolu noxinge tei.” ");
INSERT INTO ata_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","La miꞌoloꞌolo xe mikuluke, la sou aneꞌi ta sema milaa miuatu no lulu la miiave. Ia iaꞌalou itema vile uasi, xo aneꞌi miꞌume. ");
INSERT INTO ata_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu mutulu mo mumauli no kakau manina no voxo vile ꞌiliꞌi no anu voxo Tavuna noxiꞌa ta Isilaeli. La sou muxali noxie Malia sie Maxatale tei. Ane sema e Iesu muxexeneꞌi ta uleenu masua taꞌuve mo muxatele tamei noxie. ");
INSERT INTO ata_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aneꞌi ta mitema e iloꞌa Iesu imuamuaꞌi ikekei a ixolu itatamasou. Ia ane mixali la mivikalaneꞌi, ");
INSERT INTO ata_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","aloxo ꞌo, “Iesu ꞌa mumauli mo eni emaisou ne.” Aneꞌi milomusou vaikala noxie, ia imuxaxu taneꞌi no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Xe iliꞌi, la ta molomolo noxou Iesu tamei miꞌumesou tuala tila sou mimuamuaꞌi milai. Aneꞌi milai xoo, la Iesu mupalaꞌa noxiꞌa. Aneꞌi mimaisou la vasimolu ne iou vilemo. ");
INSERT INTO ata_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","La sou aneꞌi ilou milivu sou miaꞌaloiꞌa ta menexiꞌa paꞌusiꞌa e aneꞌi mixolu ꞌole. Aneꞌi milomusou aꞌalo noxiꞌa ilou, ia imuxaxu taneꞌi no anu uasi. ");
INSERT INTO ata_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Xe iliꞌi, la ta molomolo noxou Iesu mavulovexa vile mo mulelia vile mixolu sou iꞌaniꞌani. La Iesu muxali noxiꞌa. Anu mulavixaꞌa xo aneꞌi imuxaxu taneꞌi no anu vaikalaiꞌa ta mitema e mimaisou lexe Anu mutulu uasi. ");
INSERT INTO ata_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Anu muvikalaneꞌi aloxo ꞌo, “Ngalutu mo ngalai no xalexalee tuatuala ukalusi mo ngaaꞌaloxu aꞌalo laixe ulai noxiꞌa ta mitema e eni ekoineꞌi ukalusi. ");
INSERT INTO ata_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ꞌEi ane umuxaxu tanu noxilo mo iꞌulosou, la sou Lataua upamaulinu. Ia ꞌei ane umuxaxu tanu noxilo uasi, la anu utulu no anu vaivaikala. ");
INSERT INTO ata_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lataua uꞌoxonu sosovo seꞌi no avoꞌa ta mitema aneꞌi ane imuxaxu taneꞌi noxilo. Iꞌoxonu sosovo loxo. No anu xavi noxilo, la ixexeneꞌi ta uleenu masua. Mo ivikala no anu vaivaikala seꞌi ane aneꞌi ilavusou uasi. ");
INSERT INTO ata_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mo aneꞌi itetelisou sinana veveeni xe iiexu lexa masua loxo peupeu ꞌo, ia umomomo sou uꞌoxoneꞌi vile loxo ꞌo uasi. Xe imuxaxu avoꞌa noxiꞌa ta amitema e pipiena uꞌoxoneꞌi, la aneꞌi imauli.” ");
INSERT INTO ata_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Xe Tila Iesu muvikala aloxo ne mukalu, la Lataua munoꞌu mulailixu teitexi no opo loxotolo. Mulai la muxolu muvaꞌisaꞌinu Lataua no avolu tema. ");
INSERT INTO ata_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Xe iliꞌi, la sou ta molomolo noxou milai no xalexalee tuatuala ukalusi sou miaꞌaloxu. Tila iloꞌa mixaxai mipita xe muꞌoxonu sosovo seꞌi muxali sou muꞌoxonu pekiaꞌu sou vaikala noxou. ");
INSERT INTO ata_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eni akaukavu vaivaikala ano ꞌo ulai noxine, nini tila Teopilo. Tei, la ta mitema tapiena mitovo avoꞌa sou mikaukavunu aꞌalo sou mimii ane Lataua mumomomosou muxali no nixi noxixe. ");
INSERT INTO ata_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aneꞌi mimulinu vaikala noxiꞌa ta mitema aneꞌi e mimaisou mimii ane ne no ieꞌi no voxo ane mimii ne musoko muxali. Aneꞌi ta mitema ane ne, mixolu lexe aneꞌi ta mitema sou xaixai sou vaikala noxou Iesu. La sou aneꞌi milosixe aꞌalo sou mimii ane ne. ");
INSERT INTO ata_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Loxo ne, la sou eni kalumo emasaxa lexe akaukavunu aꞌalo sou mimii ane ne mo asovanu ulai noxine. Eni exaxai maxuveeni musuku sou ekakamulinu mimii mukalusi ne tavaꞌu laixe. Mo vaimomo ꞌo, eni ekaukavu laixe aloxo nesi, aloxo mimii ane ne muxali. ");
INSERT INTO ata_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nini naitisou, la sou nalavu laixe lexe vaivaikala ane aneꞌi milosienixu ne, anu maninasi. ");
INSERT INTO ata_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","No voxo ane Elodesi muxolu loxo tatananu tuala no xalee lia tila ne Iutaia, la ailiꞌi vile muxoxolu lai ne, ualasou lexe Sakalia. Anu itema vile no anu laꞌoluxaꞌa ta Avia. Semau ne, ane Aloni mutuꞌu ovuxu e ualasie lexe Elisaveti. ");
INSERT INTO ata_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ilou mixolu milapu no iou Lataua mo milavusou mimulinu vaivaikala noxou Lataua mo lapuloto noxou mukalusi, la isusu no iou uasi. ");
INSERT INTO ata_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ia, ilou ta ꞌiliꞌa uasi, xo Elisaveti imomomosou ipalaa la uasi, mole ilou ta aululu mukalu ne. ");
INSERT INTO ata_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Alaxu vile, la laꞌoluxaꞌa noxou Sakalia milai miꞌoxonu xaixai noxiꞌa sou iꞌelaxaꞌa ta sipsip no iou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","La aneꞌi miꞌoxonu vilaꞌi vile mimulinu ꞌilixo noxiꞌa sou misosovosou vile noxiꞌa sou lexe uꞌunalai no taasou lalotu tatila noxou Lataua sou uꞌelaxu mimii ane tumaꞌu lailaixe. Xe miꞌoxo aloxo ne, la misosovosou Sakalia. ");
INSERT INTO ata_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Voxo sou anu uꞌelaxu mimii ane tumaꞌu lailaixe muxali, la ta mitema tapiena mipita no ale sou milinga mulai noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","La sou angelo vile noxou Tila muxali mupalaꞌa noxou Sakalia. Muxali la mutulu no xalee tema no anu valovalo e iꞌelaxu mimii tumaꞌu lailaixe no anu. ");
INSERT INTO ata_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anu mumaisou angelo ne, la mukuluke xe mumamaꞌu. ");
INSERT INTO ata_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ia angelo muvikalanu aloxo ꞌo, “Sakalia, naꞌume mamu! Lataua mulomusou linga noxine ne. Iliꞌi, la semameni Elisaveti ivoꞌonu keakea mulu vile. La nini namoxoꞌu ualasou lexe Ioanesi. ");
INSERT INTO ata_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ulai iliꞌi, la oponeni uꞌosaꞌosasou mo ta mitema tapiena kalumo iꞌosasou no voxo mine ivoꞌonu. ");
INSERT INTO ata_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Xo anu uxali itema tila vile no iou Lataua. Anu umomomosou uiexu uaini mo lexa pekiaꞌu uasi. Xo no mine anu uxolu noxie nenu opoone sio mo no anu maulixu ukalusi ne, la Uleenu Tavuna uꞌanaꞌana noxou. ");
INSERT INTO ata_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anu ulivulixaꞌa ta mitema tavuꞌalo ne Isilaeli ilivu ilai noxou Tila, anu Lataua noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anu unoꞌu uleenu mo xavi noxou Eliasi sou uuli noxou Tila. Anu upitaneꞌi ta mamiꞌa iloꞌa ta ꞌiliꞌa sou oponeꞌi upita vilesisi mo uxiuneꞌi aneꞌi ane ilomuxu vaikala noxou Lataua uasi mo ixali ta mitema sou ilavu no anu voteꞌi ane mulapusi. Anu ulalaaxineꞌi ta mitema sou ixomaiou Tila.” ");
INSERT INTO ata_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakalia mulomusou vaikala ane ne, la mutaliꞌisou angelo aloxo ꞌo, “Loxovaa, la sou eni alavu manina lexe nini nevikala ne manina? Xo nexi noxie semaxeni ne, ta aululu manina.” ");
INSERT INTO ata_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","La angelo mukolinu vaikalau aloxo ꞌo, “Eni ualasilo lexe Xavulieli. Eni atutulu no talaxu Lataua. La sou Anu mupalusilo eneꞌe noxine sou avikala no anu aꞌalo laixe ane ne. ");
INSERT INTO ata_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ioxe, nini nalomu. Usoko vaimomo ꞌo mo ulai utalo no voxo ane mii ane eni evikalanenixu ꞌo uxali manina, la nini anaxene utomu mo navikala uasi. Xo nini namuxaxu taneni no anu vaikala noxilo ane uxali manina no voxo ane Lataua musosovosou ne uasi.” ");
INSERT INTO ata_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta mitema mixomaiou Sakalia maxuveeni, la sou aneꞌi taneꞌi lili lexe tavaꞌu loxovaa la sou anu muxolu maxuveeni no nano no tani tila noxou Lataua ne. ");
INSERT INTO ata_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Xe iliꞌi, la anu muuatu no ale, ia umomomo sou uvikalaneꞌi uasi. La sou aneꞌi milavu lexe anu mumaisou mii vile loxo aipiepiena no nano no taasou lalotu tatila noxou Lataua. Anu mutovotovolaꞌi no avolusi, ia uvikala uasi. ");
INSERT INTO ata_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Xe iliꞌi no mine voxo sou xaixai noxou mukalu, la mulivu mulai no tani. ");
INSERT INTO ata_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ioxe, iliꞌi la semau Elisaveti opoone. La ane mixolixu no nano no tani mumomomo loxo soꞌio taꞌuve. ");
INSERT INTO ata_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","La mivikala lexe, “Tila tanuxo, la sou muꞌoxonu mii ano ꞌo muxali noxilo sou ukalusou maela noxilo no ieꞌi ta mitema.” ");
INSERT INTO ata_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Soꞌio taꞌuve mukalu xe muxatele vile sou muxali, la Lataua mupalusou angelo vile ualasou lexe Xavulieli muxali muneꞌe no tuala vile ne Naseleti no xalee lia tila ne Xalilaia. ");
INSERT INTO ata_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anu muxali noxie sema vile vuanga misosovosie lexe iꞌuluxu itema vile ualasou lexe Iosepu, anu Deviti ꞌilusunu vile. Sema ne, ualasie lexe Malia. ");
INSERT INTO ata_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ioxe, angelo muxali noxie, la muvikala aloxo ꞌo, “Opoo seꞌisisi uxolu noxine. Lataua uxolu noxine mo ualusine.” ");
INSERT INTO ata_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ia Malia milomusou vaikala ane ne, la tane lili no anu, la mixavutala lexe vaikala ano ꞌo laaxu a loxovaa? ");
INSERT INTO ata_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","31","La anu muvikalane aloxo ꞌo, “Naꞌume uasi. Lataua tanuxene nini Malia. Nalomu, ulai iliꞌi la nini oponeni la navoꞌonu ꞌiline vile mulu. La namoxoꞌu ualasou lexe Iesu. ");
INSERT INTO ata_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ulai, la anu uxali tila mo aneꞌi ilemolu lexe Lataua teitexi manina ꞌOlu. La Lataua Tila usosovosou Iesu sou unoꞌu tanixu ꞌilusunu Deviti. ");
INSERT INTO ata_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Anu sou usaxilaꞌa Iakovo ta xaixasou iloꞌa ta ꞌiluꞌilusunu utotomu mo saxisaxilaꞌu noxou ne umomomo sou ukalu uasi.” ");
INSERT INTO ata_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ia Malia mivikalanu angelo aloxo ꞌo, “Mii ane ꞌo uxali a loxovaa? Xo eni vuanga sio.” ");
INSERT INTO ata_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelo mukoline aloxo ꞌo, “Ulai, la Uleenu Tavuna uxolu noxine, la sou Lataua teitexi manina xaviinu uvausine. Aloxo ne, la sou nini navoꞌonu ꞌiline ne. La imoxoꞌu lexe itema vile malemalenge noxou Lataua mo Anu Lataua ꞌOlu. ");
INSERT INTO ata_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Namaisie tulaneni Elisaveti. Ane aululu mukalu, ia ane ꞌa opoone sou ivoꞌonu ꞌilie mulu. Tei, la ane sema sou ipalaa uasi, ia soꞌioxe sou opoone a muxatele vile sou. ");
INSERT INTO ata_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mii vile pekiaꞌu sou Lataua uꞌoxonu uasi.” ");
INSERT INTO ata_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia mivikalanu aloxo ꞌo, “Mii ane nini nelemolu ne, uxali noxilosi aloxo ne. Xo eni asema sou xaixai noxou Tilasi.” Angelo muvikalane aloxo ne mukalu, la muꞌumesie sou mulai. ");
INSERT INTO ata_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","No voxo ane ne, la Malia miavuti sou mipalea minuna no xalee lia tila ne Iutaia, la sou mitelo no tuala vile muxolu no laxaꞌilu vile. ");
INSERT INTO ata_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mixali la miꞌunalai no tani noxou Sakalia sou misexelaxe Elisaveti. ");
INSERT INTO ata_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","No mine Elisaveti milomusou vaikala sou sexela noxie Malia, la keakea no nano no opoone ne, musuxulae. Xe Uleenu Tavuna muꞌanaꞌana noxie Elisaveti. ");
INSERT INTO ata_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","La ane miꞌava tatila aloxo ꞌo, “Lataua mualusine laixe manina no taiineꞌi ta sema tavuꞌalo, mo mualusou ꞌiline e muxolu no oponeni ne kalumo. ");
INSERT INTO ata_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eni asema maꞌi, la sou Tila noxilo nenu mineꞌe noxilo ꞌo? ");
INSERT INTO ata_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Eni elomusou sexela noxine, la alaxu vilesisi ꞌo, la keakea muxolu no opoleli ꞌo, musuxulae sou muꞌosa. ");
INSERT INTO ata_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lataua ualusie ane ane mimulaxu tane no anu vaikala noxou lexe mimii e mulemolu ne, anu uꞌoxonu maninasou.” ");
INSERT INTO ata_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Xe Malia miavuti, la milexe aloxo ꞌo, “Eni taleli uꞌitinu Tila ualasou, ");
INSERT INTO ata_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mo eni uleeleli kalumo uꞌosasou Lataua, Anu itema sou pamauli noxilo. ");
INSERT INTO ata_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xo Anu muxavutalaleli eni asema sou xaixai noxou vitanisi, la sou ulai iliꞌi, la ta mitema tavuꞌalo ilemelo lexe Lataua mualusilo. ");
INSERT INTO ata_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Xo itema sou xavi muꞌoxonu mimii tatila manina muneꞌe noxilo. Anusi anu Lataua malemalenga manina mo anu loxo itema uasi. ");
INSERT INTO ata_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anu ualaunaxaꞌa aneꞌi ane itoxonu utotomu mo kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anu muꞌoxonu xaixai xaviinu no avolu, mo mukusaiꞌa aneꞌi ane meꞌa iꞌitinu ualasiꞌa no anu xavutalaiꞌasi. ");
INSERT INTO ata_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anu muluꞌelainixiꞌa ta motu sou isaxilaꞌa ta mitema mo muxexeneꞌi no puloulousiꞌa, ia mutelailixaꞌa aneꞌi ta mitema vitanisi la mitelai minoꞌu tanixaꞌa. ");
INSERT INTO ata_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anu muꞌanaꞌanalixaꞌa aneꞌi ane misolixaꞌa no anu laꞌilali laixe, ia mukusaiꞌa aneꞌi ane lavulutiiꞌa tavuꞌalo ne, milai viatanisi. ");
INSERT INTO ata_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Anu musuꞌulineꞌi ta mitema sou xaixai noxou, ta Isilaeli. Anu muxavutalaneꞌi mo tanuxaꞌa. ");
INSERT INTO ata_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aloxo Anu muxavutalanu vaikala e Anu mulemolu noxou Avalaamu iloꞌa ta xaixasou mo ta ꞌiluꞌilusunu xe ta xaixasiꞌa ta maminge iloꞌa ta ꞌiluꞌilusuneꞌi ta maminge.” ");
INSERT INTO ata_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia ilee Elisaveti mixoxolu mumomomo loxo soꞌio tatalu, xe iliꞌi la ane milivu milai no tualasie. ");
INSERT INTO ata_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Voxo sou Elisaveti ivoꞌo muxali, la mivoꞌo ꞌilie mulu vile. ");
INSERT INTO ata_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Xe ta tema tualasie iloꞌa ta minemine milomusie xo mimaisie lexe Tila tanuxe musuku, la aneꞌi iloꞌa miꞌosa. ");
INSERT INTO ata_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Xe mivoꞌo mo voxo muxatele tatalu sou, la aneꞌi mineꞌe mipita sou xooxoo mungaasou xe sou lexe imoxou ualasou sou momu Sakalia. ");
INSERT INTO ata_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ia nenu mivikala aloxo ꞌo, “Uasi! Tamoxou ualasou lexe Ioanesi.” ");
INSERT INTO ata_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ia aneꞌi mivikalane aloxo ꞌo, “Ta minemineni vile ualasou loxo ne uasi.” ");
INSERT INTO ata_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","La sou aneꞌi milosi no avoꞌa mulai noxou momu lexe umoxoꞌu ꞌolu ualasou a loxovaa? ");
INSERT INTO ata_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Anu mutovolaꞌi sou lexe inoꞌu ovu alelaxu sou ukaukavu no anu. Xe milosou mukalu, la anu mukaukavu no anu aloxo ꞌo, “Ngamoxoꞌu ualasou lexe Ioanesi.” Aneꞌi mimaisou uala ane ne, la mikuluke manina. ");
INSERT INTO ata_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Alaxu vilesisi ꞌo, la Sakalia anaxu e mutomu ne, utomu la ua. Anu umomomo sou uvikala la. La sou muvikala sou muꞌitinu Lataua ualasou. ");
INSERT INTO ata_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Xe ta tema tualasou mimaisou aloxo ne, la mimamaꞌu misevile. La sou aꞌalosou mimii latala e muxali ne, mulutu la mulai no tuatuala e no anu laxalaxaꞌilu sie Iutaia. ");
INSERT INTO ata_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta mitema latala milomusou aꞌalo ane ne, la aneꞌi taneꞌi lili no anu. La sou mivikala lexe iliꞌi, la anu keakea ne uxali itema a loxovaa? Xo milavu lexe xavi noxou Tila a muxolu noxou ne. ");
INSERT INTO ata_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ioxe, Uleenu Tavuna muꞌanaꞌana noxou Ioanesi momu e Sakalia ne, la sou anu muvikala mupalomatana aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nenge taꞌitinu Tila ualasou, anu Lataua noxinge nenge ta Isilaeli, xo Anu muneꞌe sou mulivulixaꞌa ta mitema noxou. ");
INSERT INTO ata_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","No nano no taiineꞌi ta xaixasou iloꞌa ta ꞌiluꞌilusunu, Deviti e itema sou xaixai noxou. la Anu muxalixu itema vile xaviinu sou upamaulinenge. ");
INSERT INTO ata_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aloxo, tatei la Anu mulemo noxiꞌa ta mitema sou palomatana noxou e Anu musosovosiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Anu upamaulinenge no avoꞌa ta uluamenge mo no avoꞌa ta mitema ukalusi ane imasaxainge uasi. ");
INSERT INTO ata_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anu tanuxaꞌa ta xaixasinge iloꞌa ta ꞌiluꞌilusunenge, mo muxavutalanu vaikala noxou e Anu musakiinu tatei, ");
INSERT INTO ata_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","noxou Avalaamu, Anu ꞌilusunenge. ");
INSERT INTO ata_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Sou lexe Anu upamaulinenge no avoꞌa ta uluamenge mo sou lexe nenge tamamaꞌu mo taꞌume uasi, ");
INSERT INTO ata_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ia nenge taxaxai noxou, la nenge taxolu vaꞌaxu no anu ꞌiliꞌilixo masumasua mo tamulinu ꞌilixo ane mulapu no voxovoxo utotomu. ");
INSERT INTO ata_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mo nini ꞌalixeni ꞌo, ulai iliꞌi la imoxoine lexe nini itema sou palomatana noxou Lataua teitexi manina. Xo nini naulaxunu Tila sou namomosou voteꞌisou, ");
INSERT INTO ata_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","mo sou ta mitema noxou ilavusou lexe Anu uxiu tumalou ꞌiliꞌilixo masumasua noxiꞌa mo upamaulineꞌi ");
INSERT INTO ata_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","xo Anu tanuxaꞌa musuku. Mo no anu alauna noxou, la Anu usovanu lamana sou tuala teitexi uneꞌe noxinge, ");
INSERT INTO ata_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","sou ukaasiꞌa ta mitema aneꞌi e mixolu no isivoxo mo mimuamuaꞌi no voteꞌi ane masua sou soli uxalisiꞌa no anu, mo sou upamuxanenge no anu voteꞌi sou opo seꞌisisi.” ");
INSERT INTO ata_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iliꞌi, xe molomolo ne muxali tila, la uleenu tavuna muꞌanaꞌana noxou. La mulai muxolu no xalee lia vitanisi, mutalo no voxo sou anu mupalaꞌa no ieꞌi ta Isilaeli. ");
INSERT INTO ata_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ioxe, no voxo ane ne, la tila noxiꞌa ta Romu ualasou lexe Kaisari Auxusuto mumulaxu vaikala vile pekiaꞌu. La muvikala aloxo ꞌo, “Ngingi ta mitema ne Romu ukalusi ne, ngalai no nunisinge sou ikaukavu ualasinge no lavuku noxilo.” ");
INSERT INTO ata_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ano ꞌo ne, anu usoko sou ikaukavu ualasiꞌa tei manina no voxo ane Kirinito musaxilaꞌu xalee lia tila ne Silia. ");
INSERT INTO ata_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","La sou ta mitema mukalusi milai no nunisiꞌa sou lexe ikaukavu ualasiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ioxe, itema vile ualasou lexe Iosepu kalumo mulutu no tuala ne Naseleti no xalee lia tila ne Xalilaia, sou mununa no tuala ne Vetiliemu no xalee lia tila ne Iutaia. Xo anu Deviti ꞌilusunu vile. ");
INSERT INTO ata_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Anu ilee Malia e misosovosie lexe anu semau, milai sou ikaukavu ualasiꞌa. Ia Malia ne, ane opoone. ");
INSERT INTO ata_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Xe no voxo ane ilou mixolu ne Vetiliemu, la voxo sou lavuloꞌo noxie muxali. ");
INSERT INTO ata_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","La mivoꞌonu ꞌilie mulu laposalaxu. Mivoꞌonu mukalu, la mikupokuponu no anu lavalavasiꞌa ta keakea sou miaisou no nano no taasou laꞌilalixaꞌa ta bulumakau. Xo tani vile sou aneꞌi iai no anu uasi. ");
INSERT INTO ata_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Io, no xalee lia vile no ale ne Vetiliemu, la ta mitema moseꞌi ꞌa mixaxai sou misaxilaꞌa ta sipsip no ꞌolovoxo ane ne. ");
INSERT INTO ata_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","La angelo noxou Tila muxali noxiꞌa xe lamanaxu Tila mukaasiꞌa, la aneꞌi miꞌume. ");
INSERT INTO ata_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ia, angelo muvikalaneꞌi aloxo ꞌo, “Ngaꞌume uasi. Xo eni eneꞌenu aꞌalo laixe sou uꞌoxongengi ta mitema ukalusi no lia ꞌo, ngaꞌosa no anu. ");
INSERT INTO ata_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aꞌalo laixe ne aloxo ꞌo. Vaimomo ꞌo, itema sou pamauli mupaa no tuala noxou Deviti. Anu Tila Kalisito. ");
INSERT INTO ata_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Anu sosovo noxinge sou ngalavusou aloxo ꞌo. Ngalai la ngamaisou keakea vile mikupokuponu no anu lavalava ka miaisou no taasou laꞌilalixaꞌa ta bulumakau.” ");
INSERT INTO ata_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angelo muvikala mukalu, la alaxu vilesisi, la ta angelo tavuꞌalo sou ꞌotoꞌoto no opo loxotolo ne mixali mipita noxou sou miꞌitinu Lataua ualasou. ");
INSERT INTO ata_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","La mivikala aloxo ꞌo, “Taꞌitinu ualasou Lataua uxolu teitexi manina. Nexi telinga lexe opo seꞌisisi noxou Lataua uxolu noxiꞌa ta mitema no lia ane Lataua uꞌosasiꞌa.” ");
INSERT INTO ata_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ta angelo mivikala aloxo ne mukalu, xe mixexesiꞌa sou milivu no opo loxotolo, la ta mitema sou isaxilaꞌa ta sipsip mivikalaneꞌi ngatongatoꞌo lexe, “Ioxe, nengeꞌa talai ne Vetiliemu mo tamaisou mii ane muxali e Tila muvikalanengexu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","La sou aneꞌi mipalea milai, la mixalisiꞌa Malia ilou Iosepu xe mimaisou keakea uai no taasou laꞌilalixaꞌa ta bulumakau. ");
INSERT INTO ata_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mimaisou mukalu, la milai miaꞌaloiꞌa ta mitema no anu aꞌalosou keakea e ta angelo miaꞌaloxu. ");
INSERT INTO ata_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","La ta mitema latala e milomusou aꞌalo e ta mitemasou isaxilaꞌa ta sipsip miaꞌaloiꞌaxu ne, mikuluke. ");
INSERT INTO ata_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ia Malia ne, mimolo taneu mimii latala e muxali noxie sou ꞌilie ne mo tane umulimulinu. ");
INSERT INTO ata_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Io, aneꞌi ta mitema sou isaxilaꞌa ta sipsip ne, milivu la miꞌitiꞌitinu Lataua ualasou sou mimii mukalusi ane milomu sou mo mimaisou muxali manina loxo ta angelo mivikalaneꞌixu. ");
INSERT INTO ata_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Malia mivoꞌonu keakea xe voxo taꞌuve mo muxatele tatalu mukalu, la xooxoo ungaasou xe mimoxoꞌu ualasou lexe Iesu. Xo uala ane ne, nenu opoone uao, ia angelo vile mulemolu tei. ");
INSERT INTO ata_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Iliꞌi, xe voxo sou aneꞌi ixali malemalenga no iou Lataua loxo Mosesi muvikala muxali, la milaixu keakea ne Ielusalemu sou milosou Tila. ");
INSERT INTO ata_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Aneꞌi miꞌoxonu aloxo ne, xo lapuloto noxou Tila muvikala aloxo ꞌo, “Ta keakea ta mulu laposalaxaꞌa ukalusi ne, ikalineꞌi sou ixolu vaꞌaxu loxo Tila ta naꞌu.” ");
INSERT INTO ata_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mo milai ne lexe sou miiamaneꞌi ta kuau tameiiꞌa, lexe uasi la ta utu tamei loxo lapuloto noxou Tila muvikala. ");
INSERT INTO ata_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","No voxo ane ne, la itema vile muxolu ne Ielusalemu, ualasou lexe Simeoni. Anu itema sou uꞌoxonu ꞌilixo laixe mo anu itema sou utoxonu Lataua mo anu uxomaiou voxo sou pamauli noxiꞌa ta Isilaeli. Mo Uleenu Tavuna muxolu noxou, la muvikalanu lexe anu usoli uao, ia umaisou Kalisito noxou Tila. ");
INSERT INTO ata_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Uleenu Tavuna muavutinoxu Simeoni, la muꞌunalai no nano no taasou lalotu tatila noxou Lataua. La Iosepu ilee Malia mineꞌenu ꞌiliꞌa Iesu mo miꞌunalai kalumo sou imulinu ꞌiliꞌilixosou e loxo lapuloto noxou Mosesi mulemolu. ");
INSERT INTO ata_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni mumaisiꞌa, la mulai noxiꞌa sou muvoꞌonu keakea. Io muꞌiti Lataua, la muvikala aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tila, eni amitema sou xaixai noxinesi. La eni emasaxa lexe asoli seꞌisisi loxo nini nelemolu. ");
INSERT INTO ata_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xo eni ieli mumaisou itema e nesovanu muneꞌe sou upamaulinexi. ");
INSERT INTO ata_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nini nemomomosou itema ane ꞌo mo ta mitema latala ukalusi imaisou. ");
INSERT INTO ata_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anu lamana sou ukaasiꞌa ta mitema ane ilavusou Lataua uasi. Ia lamana ane ne, ukaasiꞌa la aneꞌi iꞌitinu ta Isilaeli ualasiꞌa.” ");
INSERT INTO ata_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Momu ilee nenu mikuluke no anu mimii ane Simeoni mulemolusou. ");
INSERT INTO ata_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Xe Simeoni mualusiꞌa, la muvikalane Malia aloxo ꞌo, “Nalomu. Lataua musosovosou ꞌiline ꞌo sou uꞌoxoneꞌi ta mitema tavuꞌalo ne Isilaeli ilapau xe tavuꞌalo itulu. Mo anu Lataua musosovosou lexe ta mitema tavuꞌalo ivikala tumalou noxou. ");
INSERT INTO ata_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","La sou xavutalaiꞌa ne uxali upalaꞌa lamana lexe imasaxau ꞌiline uasi. La nini taneni uxoto sou ꞌiline ne loxo laviso uxotonu taneni.” ");
INSERT INTO ata_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","No anu voxo e Simeoni muvikalane Malia ne, la sema vile sou palomatana mixoxolu ne kalumo. Ualasie lexe Ana, ane Panueli ꞌolu sema, ia ane vile noxiꞌa ta Aseli. Ane aululu manina mukalu. Tatei no mine ane vuanga, la ane mitaulaꞌi mo ilou mulue mixolu tauu ie taꞌuve mo muxatele tamei. ");
INSERT INTO ata_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ia iliꞌi, la mulue musoli, io ane mixolu vaalu mole tauu iexe muxali loxo itemaxu tamiꞌa mo tamiꞌa. Ia ane Ana ne, iꞌumesou taasou lalotu tatila noxou Lataua uasi, ane ixolu sou ilolotu noxou Lataua no aso mo ꞌolovoxo. Mo ane ipelemu sou ikilaka ulai noxou Lataua no voxovoxo. ");
INSERT INTO ata_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ia ane mineꞌe ꞌalai noxou keakea kalumo, la mivikala laixe musuku mulai noxou Lataua. Ane miaꞌaloxu keakea mulai noxiꞌa ta Ielusalemu mukalusi e mixomaiou voxo ane sou Lataua upamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosepu ilee Malia miꞌoxonu mimii latala mukalusi loxo lapuloto noxou Tila mulemolu. Mukalu, la milivu milai no tualasiꞌa ne Naseleti no xalee lia tila ne Xalilaia. ");
INSERT INTO ata_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mixolu xe, iliꞌi la ꞌiliꞌa muleme tatila mo muxali pekiaꞌu. La Anu muꞌanaꞌana no anu xavutala lailaixe mo alauna noxou Lataua muxolu noxou kalumo. ");
INSERT INTO ata_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","No anu tauutauu ie utotomu, la Iesu momu ilee nenu ilavusou ilalai ne Ielusalemu no voxo sou isosovosou voxo ane Lataua Mupolopepeeneꞌi Ta Isilaeli. ");
INSERT INTO ata_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Xe no tauu ie ane Iesu tauu iexu muxali loxo mavulovexa vile mo tamei, la aneꞌi iloꞌa minuna ne Ielusalemu loxo aneꞌi imumulinu ꞌilixo sou voxo tila ane ne. ");
INSERT INTO ata_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iliꞌi no mine voxo sou Lataua Mupolopepeeneꞌi Ta Isilaeli ne mukalu, ia aneꞌi ililivu o no tualasiꞌa, la molomolo Iesu ne muxolu ne Ielusalemu. Muxolu, io momu ilee nenu ilavusou lexe Anu a uxolu ne uasi. ");
INSERT INTO ata_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aneꞌi mixavutala lexe Anu iloꞌa aneꞌi ane mimuamuaꞌi sou ilivulivu ne, la sou aneꞌi ilou mimuamuaꞌi voxo vile mukalu. Xe iliꞌi, la sou aneꞌi ilou misoko sou mikamulinu no taiineꞌi ta tema tualasiꞌa mo ta minemineꞌi. ");
INSERT INTO ata_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ia ixalisou uasi. La sou aneꞌi ilou milivu milai ne Ielusalemu sou ikakamulinu. ");
INSERT INTO ata_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikakamuli xoo xe voxo tatalusou, la mixalisou no nano no taasou lalotu tatila noxou Lataua. No mine mixalisou, la Anu uxoxolu no taiineꞌi ta mitema sou ilosiꞌa ta mitema lavulavu sou ulolomusou vaikala noxiꞌa xe utalitaliꞌisiꞌa kalumo. ");
INSERT INTO ata_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","La aneꞌi ane ilolomusou vaikalau Iesu ne, aneꞌi latala mikuluke no anu lavulavu noxou sou mukolinu taliꞌi noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aneꞌi ilou mimaisou aloxo ne, la mikuluke manina. La nenu mivikalanu aloxo ꞌo, “Ae, ꞌalixeni, tavaꞌu loxovaa, la sou nini neꞌoxonexi noxou mamine loxo ne? Namaisou, nexi noxou tekakamulineni xoo mole tanexi lili ne.” ");
INSERT INTO ata_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ane mivikalanu aloxo ne, la Iesu muvikalaneꞌi ilou aloxo ꞌo, “Loxovaa, la sou ngingi nongou ngakakamulileli o? Ngalavusilo lexe eni axoxolu no tani noxou mamilo uasi?” ");
INSERT INTO ata_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ia aneꞌi ilou ilamana no anu vaikala noxou ne laaxu uasi. ");
INSERT INTO ata_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iloꞌa mivikala mukalu, la milivu mitoꞌo no tualasiꞌa ne Naseleti sou mixolu. Mixolu, la Iesu ne ulolomuxaꞌa momu ilee nenusi. La ane nenu mimolo taneu mimii latala e Iesu muꞌoxonu. ");
INSERT INTO ata_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Xe iliꞌi, la Iesu muleme tatila xe xavutala laixe noxou kalumo muxali tatila. La Lataua mo ta mitema kalumo mimasaxau misevile. ");
INSERT INTO ata_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","No mine Kaisari Tiverio muxolu loxo tila ne Romu, xe tauu ie mavulovexa mo muluꞌe no lia taꞌuve mukalu, la vaikala noxou Lataua muxali noxou Ioanesi, e Sakalia ꞌolu no xalee lia vitanisi. No ꞌa tauu ie ane ne, la Pontio Pilato musaxilaꞌu xalee lia tila ne Iutaia, xe Elodesi muxolu loxo tatananu tuala no xalee lia tila ne Xalilaia, xe vimou Pilipi kalumo muxolu loxo tatananu tuala no xalee lia ne Ituria xe Tarakoniti. Xe Lisanio kalumo muxolu loxo tatananu tuala no xalee lia ne Avilene, ia Anasi ilou Kaiapasi mixolu loxo ta kisiꞌa ta ailiꞌi. ");
INSERT INTO ata_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Vaikala noxou Lataua muxali noxou Ioanesi, la sou anu mumuamuaꞌinoxu mulai noxiꞌa ta mitema no tuatuala mukalusi e muxolu ꞌalai no lexa ne Ioridani. La muꞌava aloxo ꞌo, “Ngingi ngaxiu opongengi mo ngaxiu tumalingeu ꞌiliꞌilixo masumasua noxinge, mo ngaꞌulo sou sosovo lexe Lataua uxiu tumalouou ꞌiliꞌilixo masumasua noxinge.” ");
INSERT INTO ata_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anu muvikala aloxo ne, xo itema sou palomatana, Aisaia mukaukavu tatei aloxo ꞌo, “Itema vile uꞌavaꞌava no xalee lia vitanisi aloxo ꞌo, ‘Ngalalaxiinu voteꞌisou IAUE mo ngalapunoxu voteꞌisou. ");
INSERT INTO ata_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ngasovolou vanuvanunu ukalusi mo ngamomomosou, xe ngaꞌasou tani laꞌolaꞌoluxu ilou laxalaxaꞌiluxu ukalusi mo uxali latia laixe. Ngingi ngalapunoxu voteꞌi ane mukilikalukalu mo ulapu, xe voteꞌi ane laixe uasi, la ngaꞌoxonu laixe mo uxali uvilimi laixe. ");
INSERT INTO ata_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","La sou ta mitema no tuatuala ukalusi ne, imaisou itema e Lataua usovanu uneꞌe sou upamaulineꞌi ta mitema.’” ");
INSERT INTO ata_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","La sou ta mitema tavuꞌalo mineꞌe noxou Ioanesi sou lexe anu uꞌulosiꞌa. Ia anu mumaisiꞌa, la muvikala laꞌiaxuiꞌa aloxo ꞌo, “Ngingi loxo sinana veveeni masua ta ꞌolu! Lataua laꞌiaxuinge, ia ꞌei muvikalangengi lexe ngaꞌume sou ngapoloxalonu laiꞌa noxou? ");
INSERT INTO ata_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lexe ngingi ngexiu opongengi manina, la ꞌiliꞌilixomengi ne umaxaꞌinge lexe ngingi ngexiu opongengi mo neneꞌaxu ne uxali no anu maulingenge. Io mamu sou ngavikalangengi ngatongatoꞌo vitavitanisi lexe ngingi Avalaamu ta ꞌiluꞌilusunu. Eni avikalangengi aloxo ne, xo Lataua umomomo sou uxalixaꞌa Avalaamu ta ꞌiluꞌilusunu no anu lavoꞌo vile vitanisi ꞌolele. ");
INSERT INTO ata_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","La Lataua uxexengengi loxo itema vile uxetau ovu no anu lapemu sou uxexee mo uꞌelaxu, xo uneneꞌa laixe uasi.” ");
INSERT INTO ata_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Io, aneꞌi milolomusou vaikalau Ioanesi aloxo ne, la mitaliꞌisou aloxo ꞌo, “La sou nexi taꞌoxo maꞌia ꞌo?” ");
INSERT INTO ata_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","La Ioanesi mukolinu vaikalaiꞌa aloxo ꞌo, “ꞌEi ane tokolomou tamei uai, la avikalanu pekiaꞌu lexe anu ulosou menexu vile ane anu iu tokolomou uasi ne vile. Xe ꞌei ane laꞌilalixu uai tavuꞌalo, la anu kalumo uꞌoxonu aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta mitema sou itaxusou lamoli kalumo mineꞌe noxou sou lexe uꞌulosiꞌa, la aneꞌi kalumo mitaliꞌisou aloxo ꞌo, “Itema sou ulosinge lavulavu, nexi taꞌoxo maꞌia?” ");
INSERT INTO ata_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","La anu mukolineꞌi aloxo ꞌo, “Ngataxusou lamoli, la nganoꞌu uꞌisalili no anu sosovosousi, ia nganoꞌu usukusuku mamu.” ");
INSERT INTO ata_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Io, ta mitema sou ꞌotoꞌoto kalumo mineꞌe noxou sou lexe uꞌulosiꞌa, la aneꞌi kalumo mitaliꞌisou aloxo ꞌo, “Nexi taꞌoxo a loxovaa?” La anu mukolineꞌi aloxo ꞌo, “Ngingi ngakaitoloneꞌi ta mitema mo ngaviou lamoliiꞌa vitanisi mamu. Ia eni avikalangengi pekiaꞌu lexe ngingi ngaꞌosasou lamoli e nganonoꞌu sou xaixaimengi uꞌisalili.” ");
INSERT INTO ata_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta mitema e ixomaiou itema sou pamauli uluꞌe no lia ꞌo, mimaisou Ioanesi, la taneꞌi lili. La mixavutala lexe mane anu Kalisito ane. ");
INSERT INTO ata_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","La sou anu muvikalaneꞌi aloxo ꞌo, “Eni aꞌulosinge no anu lexa viatanisi loxo sosovo lexe ngingi ngexiunu opongengi. Ia iliꞌi, la itema vile xaviinu uneꞌe sou uꞌulosinge no anu Uleenu Tavuna mo navu. Ia xavi noxou ne, uaulixu xavi noxilo. La sou eni amomomosou alulusou lamotasou siovexu tavaꞌu uasi. ");
INSERT INTO ata_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Anu uneꞌe loxo itema vile utetelisou silapa no avolu sou usilapanu uiti sosou sou uꞌelaxu no anu navu e ukalu uasi. Io, temanu, la ulai uai no taasou laꞌilali.” ");
INSERT INTO ata_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ioanesi musolo vaikala tavuꞌalo la, xe muaꞌaloxu aꞌalo laixe noxou Lataua mulai noxiꞌa kalumo. ");
INSERT INTO ata_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ioxe, no voxo vile iliꞌi, la Ioanesi mukaitolonu Elodesi, anu tatananu tuala ne Xalilaia. Xo anu munoꞌe vimou semau ualasie lexe Elodia mo muꞌoxonu ꞌiliꞌilixo masumasua seꞌi la. ");
INSERT INTO ata_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","La sou Elodesi musukunu ꞌilixo vile masua sou mutatuxu Ioanesi no taasou navunavu. ");
INSERT INTO ata_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","No mine Elodesi utatuxu Ioanesi no anu taasou navunavu uao, la Ioanesi muꞌulosiꞌa ta mitema tavuꞌalo. Mo Iesu kalumo muneꞌe noxou, la anu muꞌulosou. Xe muꞌulosou mukalu, la Iesu mulinga. La opo loxotolo mukisi, ");
INSERT INTO ata_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","la sou Uleenu Tavuna muluꞌe loxo ngiala kuau muvava muluꞌe muxolu no kisou. La itema vile no opo loxotolo muvikala muluꞌe aloxo ꞌo, “Nini eni ꞌalixeni. Eni emasaxaine musuku mo opoleli muꞌosasine misevile.” ");
INSERT INTO ata_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu muꞌulo xe musokou xaixai noxou sou ulosiꞌa ta mitema lavulavu, la tauu iexu muxali loxo mavulovexa tatalu. La ta mitema tavuꞌalo mixavutala lexe anu Iosepu ꞌolu. Ia Iosepu ne, anu Eli ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ne, Matati ꞌolu. Xe Matati ne, Levi ꞌolu. Xe Levi ne, Meleki ꞌolu. Xe Meleki ne, Iana ꞌolu. Xe Iana ne, Iosepu ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Xe Iosepu ne, Matatio ꞌolu. Xe Matatio ne, Amosi ꞌolu. Xe Amosi ne, Naumu ꞌolu. Xe Naumu ne, Esili ꞌolu. Xe Esili ne, Naxai ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Xe Naxai ne, Mati ꞌolu. Xe Mati ne, Matatio ꞌolu. Xe Matatio ne, Semei ꞌolu. Xe Semei ne, Ioseki ꞌolu. Xe Ioseki ne, Ioda ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Xe Ioda ne, Ioanani ꞌolu. Xe Ioanani ne, Resa ꞌolu. Xe Resa ne, Seruvaveli ꞌolu. Xe Seruvaveli ne, Salatieli ꞌolu. Xe Salatieli ne, Neri ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Xe Neri ne, Meleki ꞌolu. Xe Meleki ne, Adi ꞌolu. Xe Adi ne, Kosamu ꞌolu. Xe Kosamu ne, Elimada ꞌolu. Xe Elimada ne, Ela ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Xe Ela ne, Iosua ꞌolu. Xe Iosua ne, Eliaselu ꞌolu. Xe Eliaselu ne, Iorimu ꞌolu. Xe Iorimu ne, Matati ꞌolu. Xe Matati ne, Levi ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Xe Levi ne, Simeoni ꞌolu. Xe Simeoni ne, Iuda ꞌolu. Xe Iuda ne, Iosepu ꞌolu. Xe Iosepu ne, Ionamu ꞌolu. Xe Ionamu ne, Eliakimu ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Xe Eliakimu ne, Melea ꞌolu. Xe Melea ne, Mena ꞌolu. Xe Mena ne, Matata ꞌolu. Xe Matata ne, Natani ꞌolu. Xe Natani ne, Deviti ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Xe Deviti ne, Iesi ꞌolu. Xe Iesi ne, Oveti ꞌolu. Xe Oveti ne, Voasi ꞌolu. Xe Voasi ne, Solomoni ꞌolu. Xe Solomoni ne, Nasoni ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Xe Nasoni ne, Aminadavu ꞌolu. Xe Aminadavu ne Ademini ꞌolu. Xe Ademini ne Ramu ꞌolu. Xe Ramu ne, Esuloni ꞌolu. Xe Esuloni ne, Peresi ꞌolu. Xe Peresi ne, Iuda ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Xe Iuda ne, Iakovo ꞌolu. Xe Iakovo ne, Aisaki ꞌolu. Xe Aisaki ne, Avalaamu ꞌolu. Xe Avalaamu ne, Tela ꞌolu. Xe Tela ne, Naolu ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Xe Naolu ne, Seluxu ꞌolu. Xe Seluxu ne, Leu ꞌolu. Xe Leu ne, Pelexi ꞌolu. Xe Pelexi ne, Eve ꞌolu. Xe Eve ne, Sela ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Xe Sela ne, Kainani ꞌolu. Xe Kainani ne, Apasata ꞌolu. Xe Apasata ne, Semu ꞌolu. Xe Semu ne, Noa ꞌolu. Xe Noa ne, Lameki ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Xe Lameki ne, Metusela ꞌolu. Xe Metusela ne, Enoko ꞌolu. Xe Enoko ne, Ielati ꞌolu. Xe Ielati ne, Maalaleli ꞌolu. Xe Maalaleli ne, Kenani ꞌolu. ");
INSERT INTO ata_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Xe Kenani ne, Enosi ꞌolu. Xe Enosi ne, Seti ꞌolu. Xe Seti ne, Adamu ꞌolu. Xe Adamu ne, Lataua mukoinu. ");
INSERT INTO ata_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Ioxe, Iesu muꞌulo ne Ioridani mukalu xe xaviinu Uleenu Tavuna muꞌanaꞌana noxou, la mulivu no tualasou. Xe iliꞌi, la Uleenu Tavuna mulaixu no xalee lia vitanisi sou lexe Satani utovonu. Anu muxolu lai ne, la uꞌani uasi mumomomo loxo voxo mavulovexa tamiꞌa. Xe voxo mavolovexa tamiꞌa mukalu, la muxamuli lexe Anu musolixu. ");
INSERT INTO ata_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Anu musolixu, la sou Satani muvikalanu aloxo ꞌo, “Lexe nini Lataua ꞌOlu, la navikalanu lavoꞌo vile ꞌo mo uxiu uxali veleti.” ");
INSERT INTO ata_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ia Iesu mukolinu aloxo ꞌo, “Vaikalau Lataua muvikala lexe ta mitema imauli no anu veletisi uasi, ia imauli no anu vaivaikala noxou Lataua kalumo.” ");
INSERT INTO ata_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mukalu, la Satani mulutunoxu Iesu mutelonu no laꞌolu vile teitexi. Xe alaxu vilesisi ꞌo, la mulosiouxu tuatuala mukalusi no lia ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","La muvikalanu aloxo ꞌo, “Eni alosine xavi sou nasaxilaꞌu tuatuala ukalusi mo alosine mimii ukalusi no anu sou naꞌanini. Xo eni esaxilaꞌu mimii ane ne, la sou eni alosou mitema ꞌenaꞌei ane eni emasaxa sou alosou. ");
INSERT INTO ata_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","La sou lexe nini napalaꞌalixo lexe eni Lataua, la mimii ukalusi ꞌo ne, nini naꞌanini.” ");
INSERT INTO ata_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ia Iesu mukolinu aloxo ꞌo, “Vaikalau Lataua muvikala lexe ngingi ngaluꞌelailingenge sou ngaꞌitinu Tila Lataua noxinge ualasou mo ngaxaxai noxousi.” ");
INSERT INTO ata_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Xe mukalu, la Satani mulaixu mulai ne Ielusalemu sou muꞌitalonu muxolu teitexi no tani tila noxou Lataua kisou. Ia muvikalanu Iesu aloxo ꞌo, “Lexe nini Lataua ꞌOlu, la nailiꞌe lai ꞌo nalai no lia. ");
INSERT INTO ata_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Xo vaikalau Lataua muvikala lexe Lataua upalusiꞌa ta angelo noxou sou ilooxene no avoꞌa lailaixe. ");
INSERT INTO ata_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mo itetelisine no avoꞌa teitexi, mo sou mamu sou lavoꞌo vile utoꞌomolu tavaꞌine.” ");
INSERT INTO ata_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ia Iesu mukolinu aloxo ꞌo, “Vaikalau Lataua muvikala lexe mamu sou nenge tatovonu xavi noxou Tila, anu Lataua noxinge.” ");
INSERT INTO ata_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satani mutovonu Iesu no anu tovotovo iouiou ne mukalu, ia Iesu ulapau uasi. La sou Satani muꞌumesou sou ulai uxomaiou no anu voxo vile iliꞌi la. ");
INSERT INTO ata_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iliꞌi no anu tovotovo, la xaviinu Uleenu Tavuna muꞌanaꞌana noxou Iesu sou mulivu no xalee lia tila ne Xalilaia. Anu mulivu, la ta mitema no xalee lia mukalusi ne minoꞌu aꞌalosou la, milavusou lexe Iesu Anu a mulivu muneꞌe ne Xalilaia. ");
INSERT INTO ata_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xe Anu mulosiꞌa ta mitema lavulavu no taasou la lotu noxiꞌa ta Iutaia, la ta mitema mukalusi miꞌitinu ualasou. ");
INSERT INTO ata_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xe iliꞌi, la Iesu mulai ne Nasaleti. No mine anu kituꞌaxu sio, la muxolu no tuala ane ne mo muxali tila no anu. No voxo Tavuna vile, la Anu muꞌunalai no taasou lalotu noxiꞌa ta Iutaia loxo Anu ulavusou uꞌunalai no anu. Xe Anu muꞌunalai mukalu, la mutulu sou lexe uitisou vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","La aneꞌi milosou lavuku e Aisaia anu itema sou palomatana mukaukavunu mipipinu muai. Anu munoꞌu ka muxavulalanu sou mukamuli vaikala vile muvikala aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uleenu Tavuna noxou IAUE, anu a uxolu noxilo ꞌo. Xo anu IAUE musosovosilo sou lexe eni aaꞌaloxu aꞌalo laixe noxou Lataua noxiꞌa ta mitema e iꞌa lavuluti uasi. Anu mupalusilo sou lexe eni alulusiꞌa ta mitema ane mixolu no anu taasou navunavu, mo avikalaneꞌi aneꞌi e ieꞌi seleselevenu lexe ieꞌi ukaa la. Mo Anu mupalusilo kalumo sou lexe eni akalusou tuꞌutuꞌumaxu noxiꞌa ta mitema aneꞌi ane ta tatilasiꞌa miꞌoxo masuaneꞌi, ");
INSERT INTO ata_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mo avikalaneꞌi no anu voxo sou IAUE ualaunasiꞌa ta mitema.” ");
INSERT INTO ata_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu muitisou aloxo ne mukalu, la mupipinu mukalu la mulosou itema sou usaxilaꞌu kaukavu ne. Io, Anu muxolu no lia, la ta mitema mukalusi mixolu no nano ne, mimatakisou. ");
INSERT INTO ata_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ia Anu muavuti la muvikalaneꞌi aloxo ꞌo, “Kaukavu ane eni eitisou ꞌo, anu a muxali manina vaimomo ꞌo loxo ngingi ngelomusou ne.” ");
INSERT INTO ata_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aneꞌi milomusou, la miitinu ualasou xe mikuluke no anu vaivaikalau lailaixe ne. Ia aneꞌi mixavutala piena, la mivikalaneꞌi ngatongatoꞌo aloxo ꞌo, “Anu ne, nenge telavusou lexe Anu Iosepu ꞌolu, ia loxovaa la sou Anu muvikala aloxo ne.” ");
INSERT INTO ata_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","La Iesu musolonu vaikala sou muvikalaneꞌi aloxo ꞌo la, “Eni elavu manina lexe ulai iliꞌi, la ngingi ngalemolu vaikala vile tatei mikaukavunu lexe, ‘Itema sou pamauli, nini mene napamaulineni.’ Mo ngavikalaleli lexe mimii e eni eꞌoxonu lai ne Kapenaumu ne, eni aꞌoxonu lai no tualasilo ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eni avikalangengi manina musuku. Ta tema tualasou itema sou palomatana vile ne imomomo sou iꞌosasou uasi. ");
INSERT INTO ata_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eni avikalangengi manina musuku. No anu voxo e Eliasi muxaxai loxo itema sou palomatana, xe tauu aso toxoxaꞌa mo tausoli kalumo muxolu ne no tuatuala mukalusi mumomomo loxo tauu ie tatalu mo soꞌio muxatele vile. La ta sema ta vaalu tavuꞌalo mixolu ne Isilaeli, ");
INSERT INTO ata_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ia Lataua upalusou Eliasi ulai noxie vile noxiꞌa ne uasi. Mupalusou mulai noxie vaalu vile ne Sareputa no xalee lia ne Saidoni. ");
INSERT INTO ata_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Xe no anu voxo e Elisa muxaxai loxo itema sou palomatana sie Isilaeli, la pipiena vulukali muꞌoxoneꞌi ta mitema tavuꞌalo ne Isilaeli. Ia vile noxiꞌa uneꞌe noxou Elisa sou umauli uasi. Naamani e ne Siliasi a mulai noxou Elisa sou mumauli.” ");
INSERT INTO ata_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ioxe, ta mitema mukalusi no nano no taasou lalotu noxiꞌa ta Iutaia ne, milomu aloxo ne, la laꞌiaxaꞌa manina. ");
INSERT INTO ata_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xe aneꞌi miavuti la mikusau Iesu mulai no ale sou milaixu no maea kisou e tuala tila muxolu no anu sou lexe ivau usoli. ");
INSERT INTO ata_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ia, uasi. Anu musixa no taiineꞌi ta mitema, la mulai avile. ");
INSERT INTO ata_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ioxe, iliꞌi la Iesu muluꞌelai no tuala ne Kapenaumu e ne Xalilaia. Muxolu ne sou musoko sou ulosieixaꞌa ta mitema lavulavu no voxo Tavuna. ");
INSERT INTO ata_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Xe ta mitema milomusou vaivaikala noxou, la aneꞌi mikuluke, xo vaikalau ne xaviinu. ");
INSERT INTO ata_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Io, no voxo vile la itema vile muxolu no taasou lalotu noxiꞌa ta Iutaia ne, ulee vile masua muxolu noxou. La anu muꞌavaꞌava tatila misevile. ");
INSERT INTO ata_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","La muvikalanu Iesu aloxo ꞌo, “Ae, nini Iesu sie Nasaleti! Neneꞌe ꞌo sou naꞌoxonu maꞌi noxixe? Nini neneꞌe ꞌo sou naꞌoxonu masuanexi? Nini ne, eni elavusine. Nini itema mulapu noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ia Iesu mulomu sou aloxo ne, la mukaitolonu ulee masua ne aloxo ꞌo, “Naxoo tasiau! Mo naxexesou itema ne!” La ulee masua ne, mulovelixu itema ne muluꞌe no talaxaꞌa mukalu, la sou muxexesou mulai. Ia uꞌoxonu masuanu itema ne uasi. ");
INSERT INTO ata_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ta mitema mimaisou aloxo ne, la mikuluke la mivikalaneꞌi ngatongatoꞌo aloxo ꞌo, “Iu, nenge vaikala mii maꞌia ane loxo! Itema ꞌo mukaitoloneꞌi ta ulee ta masumasua no anu xavi noxou, la aneꞌi milomuxu mo milaalaa.” ");
INSERT INTO ata_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Loxo ne, la sou aꞌalosou mimii e Iesu muꞌoxonu ne, mulai no tuatuala tavuꞌalo e muxolu ꞌalaꞌalai ne Kapenaumu. ");
INSERT INTO ata_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu mulutu no taasou lalotu noxiꞌa ta Iutaia sou mulai no tani noxou Saimoni. Ia Saimoni leuanu ne mipipiena, mo vasimele ialuxu misevile. La aneꞌi mitaliꞌisou Iesu lexe upamauline. ");
INSERT INTO ata_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","La sou Anu mutulu ꞌalai noxie sou muvikala pekiaꞌu lexe pipiena ne uxexesie. La ialuialuxe ne mukalu. Io, alaxu vilesisi la ane mitulu sou mixuxutuxaꞌa laꞌilali. ");
INSERT INTO ata_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iliꞌi no ꞌoloꞌolovoxo, la ta mitema mineꞌeneꞌi ta minemineꞌi e pipiena iouiou muꞌoxoneꞌi ne noxou Iesu sou Anu mumulaxu avolu noxiꞌa vilevilesi, la aneꞌi mimauli. ");
INSERT INTO ata_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Xe ta ulee masumasua kalumo milaalaa noxiꞌa ta mitema tapiena. La iꞌavaꞌava aloxo ꞌo, “Nini ne, Lataua ꞌOlu.” Ia Anu mukaitoloneꞌi lexe mamu sou ivikala. La aneꞌi milomuxu Iesu, xo milavu lexe Anu Kalisito. ");
INSERT INTO ata_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ꞌOlovoxo mukalu xe kakau, la Iesu mulutu sou mulai no xalee lia vile ane ta mitema ixolu no anu uasi. Ia ta mitema mikakamulinu xe mixalisou, la miapixu lexe iloꞌa ixolu ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ia Anu muvikalaneꞌi aloxo ꞌo, “Eni eneꞌe ꞌo sou aaꞌaloxu aꞌalo laixe sou saxisaxilaꞌu noxou Lataua no tuatuala seꞌi vaꞌaxu kalumo. Xo Lataua mupalusilo sou xaixai aloxo nesi.” ");
INSERT INTO ata_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","La sou Anu muxixaoxao no tuatuala ne Iutaia sou muaꞌalo no taasou lalotu noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iliꞌi no voxo vile, la Iesu mulai no kupa ne Xenesaleti. La ta mitema tavuꞌalo mipita noxou sou ilomusou vaikala noxou Lataua, la sou Iesu mutulu no kupa paꞌumolu. ");
INSERT INTO ata_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Anu mumaisou uaxa tamei muai no tasiꞌi, io ta moosou miluꞌe sou miꞌuinu kaexaꞌa. ");
INSERT INTO ata_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Xe Anu mumaisiꞌa aloxo ne, la muvikalanu Saimoni iloꞌa ta menexu ne sou misulunu no anu uaxa vile noxou Saimoni ne mulai no ale sevile. Io Iesu muxolu teitexi no uaxa ne sou mulosiꞌa ta mitema tavuꞌalo ne lavulavu. ");
INSERT INTO ata_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mulosiꞌa lavulavu mukalu, xe iliꞌi la muvikalanu Saimoni aloxo ꞌo, “Navole nalai no kupa lixinu mo ngongiꞌa ta menexine ngasuꞌanu kaengenge sou nganoꞌa ta sinana moseꞌi.” ");
INSERT INTO ata_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ia Saimoni muvikalanu Iesu aloxo ꞌo, “Tila, no ꞌolovoxo lololi ano ꞌo, nexi texaxai ialuxu mo mutalo no anu lamana, ia tanoꞌu sinana soxu vile uasi. Ia, mii vile uasi, nexi tamulinu vaikalameni mo tasuꞌanu kaenexe.” ");
INSERT INTO ata_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aneꞌi miꞌoxo aloxo ne, la minoꞌa ta sinana tavuꞌalo misevile, la kae ne lexe sou ukakaa. ");
INSERT INTO ata_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","La sou mitaveneꞌi ta menexiꞌa ane no anu uaxa vile ꞌolele lexe ineꞌe mo isuꞌulineꞌi. Aneꞌi mixali xe mitaaneꞌi ta sinana no anu uaxa tamei ne, la uaxa ne muꞌanaꞌana mo sexasisi sou uꞌuoꞌuo. ");
INSERT INTO ata_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni mumaisou aloxo ne, la mutangatulu no talaxu Iesu sou muvikalanu aloxo ꞌo, “Tila, nalai vaꞌaxu noxilo, xo eni amitema sou ꞌilixo masua.” ");
INSERT INTO ata_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Muvikalanu aloxo ne, xo anu iloꞌa ta menexu mimamaꞌu noxiꞌa ta sinana tavuꞌalo e mikaeneꞌi ne. ");
INSERT INTO ata_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ta menexu tamei e Iakovo ilou Ioanesi, e Sevetaio ta ꞌolu ne, ilou mimamaꞌu kalumo. La sou Iesu muvikalanu Saimoni lexe, “Nini namamaꞌu uasi. Vaimomo ꞌo ne, nini nenoꞌa ta sinanasi, ia iliꞌi la nini nakaeneꞌi ta mitema ineꞌe noxilo.” ");
INSERT INTO ata_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","La sou aneꞌi mivole sou milai no nano no tasiꞌi. Mixali no tasiꞌi, la miꞌitalonu mimiiꞌa mukalusi, io mimulinu Iesu. ");
INSERT INTO ata_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ioxe, no voxo vile, la Iesu muxolu no tuala vile. La itema vile vulukali muꞌoxonu mo mutaasou vasimolu mukalusi ne muxolu no tuala ane ne kalumo. Anu mumaisou Iesu, la mutangatulu no talaxu Iesu sou mulinga noxou, la muvikalanu aloxo ꞌo, “Tila, lexe nini nemasaxa, la nini napaipouleli no a vulukali ꞌo sou uxexesou vasimelo mo axali malemalenga noxou Lataua iou.” ");
INSERT INTO ata_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Xe Iesu mumexinu avolu sou mukasou, la muvikalanu aloxo ꞌo, “Eni emasaxa lexe nini naxali malemalenga.” La alaxu vilesisi ꞌo, la vulukali ne tasiauxu avile. ");
INSERT INTO ata_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mukalu, la Iesu muvikala pekiaꞌu noxou aloxo ꞌo, “Mamu sou navikalanu itema vile sou mii e muxali noxine ꞌo, ia nalai nalapu noxou ailiꞌi vile mo namaxaꞌu vasimene noxou. Ukalu, la sou naiama mimii ulai noxou Lataua loxo Mosesi muvikala pekiaꞌu lexe nini namulinu sou napalaꞌalixene noxiꞌa ta mitema lexe nini nexali malemalenga noxou Lataua iou.” ");
INSERT INTO ata_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ia uasi. Aꞌalo sou mimii e Iesu muꞌoxonu ne, ta mitema tavuꞌalo milavusou mukalu. La sou tavuꞌalo noxiꞌa mineꞌe sou milomu noxou, xe tavuꞌalo noxiꞌa e pipiena muꞌoxoneꞌi ne mineꞌe noxou sou lexe Anu upamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ia voxo seꞌi, la Anu uꞌumesiꞌa mo ulai no xalee lia e ta mitema ixolu no anu uasi sou mulinga noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iliꞌi no voxo vile la, no mine Iesu mulosiꞌa ta mitema lavulavu, la ta Palisaio moseꞌi iloꞌa ta mitema sou ilosinge lavulavu sou lapuloto moseꞌi kalumo a mixolu ne, moseꞌi noxiꞌa meꞌa no tuatuala mukalusi loxo ne Xalilaia xe ne Iutaia xe ne Ielusalemu a mineꞌe mipita ne. La xavi noxou Tila muxolu noxou Iesu sou upamaulineꞌi ta mitema e pipiena muꞌoxoneꞌi. ");
INSERT INTO ata_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","La sou ta mulu seꞌi mitavulenu itema vile e vasimolu musoisoli no anu luusou mineꞌenu. La mitovo lexe iꞌunalainixu mo imulaxu no talaxu Iesu. ");
INSERT INTO ata_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ia imomomo sou iꞌunalainixu uasi, xo ta mitema tavuꞌalo mitomu manina. La sou aneꞌi mitavulenu mitelaixu no tani laxaꞌu. Mukalu, la miꞌelixu tani laxaꞌu sou mikalaanu ilou luusou ne muluꞌe no nixineꞌi ta mitema no talaxu Iesu. ");
INSERT INTO ata_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Xe Iesu mumaisiꞌa aloxo ne, la mulavu lexe aneꞌi mimulaxu taneꞌi noxou manina, la sou muvikalanu itema ne aloxo ꞌo, “Menexilo, Lataua muxiu tumalouou ꞌiliꞌilixo masumasua noxine mukalu.” ");
INSERT INTO ata_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ia ta mitema sou lapuloto iloꞌa ta Palisaio milomusou Iesu muvikala aloxo ne, la mivikala piena no anu xavutala noxiꞌa aloxo ꞌo, “Anu itema maꞌia, la sou muvikala masua mulai noxou Lataua ꞌo? Lataua anusisi Anu umomomo sou uxiu tumalouu ꞌiliꞌilixo masumasua.” ");
INSERT INTO ata_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ia Iesu mulavusou xavuxavutala noxiꞌa, la sou muvikalaneꞌi aloxo ꞌo, “Loxovaa, la sou ngingi ngemolo tangengi loxo ne? ");
INSERT INTO ata_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Vaikala maꞌia ane, eni alemolu, la seꞌisisi noxinge sou ngalavusou lexe Lataua mulosou Itema ꞌOlu xavi sou uxiu tumalouu ꞌiliꞌilixo masumasua noxiꞌa ta mitema no lia ꞌo? Avikala lexe Lataua muxiu tumalouu ꞌiliꞌilixo masumasua noxou, uasi? Avikala lexe utulu mo ulai.” La sou Iesu iou mulai noxou itema e vasimolu musoisoli mukalu ne, io muvikalanu aloxo ꞌo, “Avikalaneni lexe natulu mo nanoꞌu moꞌesine mo nalai no taasine.” ");
INSERT INTO ata_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Xe alaxu vilesisi ꞌo, la itema ne mutulu no talaxaꞌa ta mitema sou munoꞌu moꞌesou e muai no anu ne. Xe muavuti sou mulai no tani, la muꞌitiꞌitinu Lataua ualasou no voteꞌi. ");
INSERT INTO ata_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ia, ta mitema mimaisou aloxo ne, la mikuluke manina mo mimamaꞌu misevile. Ia miꞌitinu Lataua ualasou, la mivikala aloxo ꞌo, “Vaimomo ꞌo, nenge temaisou mii vile e nenge talavusou tamaisou tatei uasi.” ");
INSERT INTO ata_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iliꞌi no anu ne, la Iesu mulaa mulai no ale. Mulai la mumaisou itema vile ualasou lexe Levi, anu itema sou utaxusou lamoli, ia uxoxolu no tani e ta mitema iꞌuna xe iuatu la ilea lamoli no anu. La Iesu muvikalanu aloxo ꞌo, “Nini naneꞌe mo namulileli.” ");
INSERT INTO ata_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Xe Levi muavuti la muꞌitalonu miomiou, ia mumulinu avile. ");
INSERT INTO ata_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Xe Levi muxali no taasou, la muꞌoxonu laꞌilali vile toxoxaꞌa xou Iesu. Ta mitema sou itaxusou lamoli iloꞌa ta mitema tavuꞌalo kalumo mixolu sou iloꞌa miꞌani. ");
INSERT INTO ata_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","La ta Palisaio moseꞌi xe ta mitema sou lapuloto moseꞌi e aneꞌi kalumo e mixolu ne mivikala tapiena noxiꞌa ta molomolou Iesu aloxo ꞌo, “Loxovaa, la sou ngingi ngongiꞌa ta mitema sou itaxusou lamoli xe ta mitema sou ꞌiliꞌilixo masumasua, ngaꞌani xe ngaie ngapita ꞌo?” ");
INSERT INTO ata_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","La sou Iesu mukolineꞌi aloxo ꞌo, “Ta mitema e ipipiena uasi ne, ilavusou ilai noxou itema sou pamauli sou pipiena uasi. Ia ta mitema e ipipienasi la ilai noxou. ");
INSERT INTO ata_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anu aloxo nesi, la sou eni eneꞌe ꞌo sou aꞌavaliꞌa ta mitema e milavusiꞌa lexe aneꞌi milaixe uasi. Eni eneꞌe ꞌo sou aꞌavaliꞌa ta mitema e milavusiꞌa lexe aneꞌi mimasua sou aneꞌi ixiu tumaliꞌau ꞌilixo masua noxiꞌa.” ");
INSERT INTO ata_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iesu mukolinu taliꞌi noxiꞌa aloxo ne mukalu, la sou aneꞌi mitaliꞌisou Iesu la aloxo ꞌo, “Voxo tapiena, la ta molomolou Ioanesi ilavusou ipelemu sou ikilaka, mo ta molomolo noxiꞌa ta Palisaio kalumo iꞌoxo aloxo ne. Ia tavaꞌu loxovaa, la sou ta molomolo noxine ꞌo ipelemu uasi ne? Aneꞌi iꞌaniꞌanisi xe iiesi.” ");
INSERT INTO ata_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","La Iesu mukolineꞌi la aloxo ꞌo, “No voxo mine itema sou utaulaꞌi iloꞌa ta minuminu ixoxolu o, la ngingi ngamomomo sou ngavikalaneꞌi sou lexe ipelemu no anu laꞌilali sou taulaꞌi ne? Uasi anesi. ");
INSERT INTO ata_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ia ulai iliꞌi no anu voxo ane sou anu uꞌumesiꞌa, la sou aneꞌi ipelemu.” ");
INSERT INTO ata_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mukalu, la sou Iesu mulemolu vaikala tovolaꞌi vile noxiꞌa aloxo ꞌo, “Itema vile umomomo sou uxotonu lavalava vile alavua xasixu sou usimenu vaxa no anu ane teinu ne uasi. Xo lexe anu uꞌoxonu aloxo ne, la anu uvilaꞌisou lavalava alavua ne sou ukakanu, xe lavalava xasixu alavua ne anu utoxo laixe uasi. ");
INSERT INTO ata_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Xe itema vile umomomo sou utaanu uaini lexaxu alavua uluꞌe no anu xalusou ane teinu uasi. Xo lexe anu uꞌoxonu aloxo ne, la uaini lexaxu alavua ne upaunoxu xalusou ne la unixi ulai no lia, xe vexasou ne umamulo mo usuꞌa. ");
INSERT INTO ata_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tavaꞌu aloxo ne, la sou tataanu uaini lexaxu alavua no anu xalusou e alavuasi. ");
INSERT INTO ata_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Xe ta mitema ane miiexu uaini lexaxu teinu mukalu, la aneꞌi imasaxa sou iiexu ane alavua ne uasi. Xo aneꞌi ivikala lexe ane teinusi ne anu laixe.” ");
INSERT INTO ata_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iliꞌi no voxo Tavuna vile, la Iesu iloꞌa ta molomolo noxou mimuamuaꞌi no nano no xai sou uiti, la ta molomolo noxou miꞌelexu uiti temanu ka miteasou sou mioꞌu. ");
INSERT INTO ata_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ia ta Palisaio moseꞌi mimaisiꞌa la mitaliꞌisiꞌa aloxo ꞌo, “Loxovaa, la sou ngingi ngeꞌoxonu mii ane nenge talavusou taꞌoxonu no voxo Tavuna uasi ꞌo?” ");
INSERT INTO ata_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","La Iesu mukolineꞌi aloxo ꞌo, “Ngingi ngaitisou aꞌalo sou mii ane Deviti muꞌoxonu no voxo ane anu iloꞌa ta menexu misolixaꞌa uasi? ");
INSERT INTO ata_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","No voxo ane ne, la Deviti muꞌuna no tani noxou Lataua ka munoꞌu laꞌilali ane aneꞌi milosou Lataua. Laꞌilali ane ne, anu noxou Lataua, la sou ta ailiꞌisi iꞌou. Ia Deviti munoꞌu ka muꞌou mo muitixaꞌa ta menexu kalumo.” ");
INSERT INTO ata_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","La Iesu muvikalaneꞌi la aloxo ꞌo, “Itema ꞌOlu ne, Anu Tila no anu voxo Tavuna sou usaxilaꞌu.” ");
INSERT INTO ata_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Xe iliꞌi no voxo vile Tavuna la, la Iesu muꞌunalai no taasou lalotu noxiꞌa ta Iutaia sou mulosiꞌa lavulavu. La mitema vile a muxolu ne kalumo, avolu tema musoli. ");
INSERT INTO ata_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","La ta mitema sou lapuloto iloꞌa ta Palisaio moseꞌi no nano ne, ieꞌi umulimulinu Iesu lexe Anu upamaulinu mitema e avolu musoli ne no voxo Tavuna. Xo aneꞌi ikakamuli voteꞌi vile sou itulusou no anu vaivaikala. ");
INSERT INTO ata_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ia Iesu mulavusou xavutala noxiꞌa ne mukalu, la sou Anu muvikalanu itema e avolu musoli ne aloxo ꞌo, “Naavuti mo natulu no ieꞌi ta mitema ꞌo.” La sou mitema ne muavuti sou mutulu. ");
INSERT INTO ata_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mutulu mukalu, la Iesu muvikalaneꞌi aloxo ꞌo, “Eni ataliꞌisinge. Lapuloto noxinge nengeꞌa muvikalanenge a loxovaa? Nenge taꞌoxonu ꞌilixo laixe no voxo Tavuna, uasi? Taꞌoxonu ꞌilixo masua? Lapuloto muvikalanenge sou tasuꞌulinu itema, uasi? Taꞌoxo masuanu?” ");
INSERT INTO ata_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu muvikala mukalu, la iou muitisiꞌa ta mitema ne mukalusi. La muvikalanu itema ne aloxo ꞌo, “Namexiinu avone uuatu.” La mitema ne muꞌoxonu aloxo ne, la sou avolu ne muxali laixe la. ");
INSERT INTO ata_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ia ta mitema sou lapuloto iloꞌa ta Palisaio ne laꞌiaxaꞌa masua manina, la mivikalaneꞌi ngatongatoꞌo lexe, “Nenge taꞌoxonu mii maꞌia noxou Iesu ꞌo?” ");
INSERT INTO ata_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","No voxo ane Iesu mutelai no laxaꞌilu sou mukilaka noxou Lataua, la mukilaka no ꞌolovoxo lololinu ne. ");
INSERT INTO ata_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Xe no kakau, la Anu muꞌavaliꞌa ta molomolo noxou ne mineꞌe sou musosovosiꞌa mavulovexa mo muluꞌe no lia tamei noxiꞌa ane Anu mumoxoꞌa lexe ta aposeli noxou. ");
INSERT INTO ata_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Itiitisiꞌa ne aloxo ꞌo. Saimoni e Iesu mumoxoꞌu lexe Pita, xe vimou Andeleasi, xe Iakovo ilou Ioanesi, xe Pilipi ilou Vatolomaio, ");
INSERT INTO ata_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","xe Mataio ilou Tomasi, xe Iakovo e Alipaio ꞌolu, xe Saimoni vile la, anu vile noxiꞌa ta mitema ane imasaxa lexe meꞌa isaxilaꞌu tualasiꞌa tatila. ");
INSERT INTO ata_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xe Iudasi e Iakovo ꞌolu xe Iudasi Isikarioti ane muꞌitalonu Iesu no avoꞌa ta mitema. ");
INSERT INTO ata_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iliꞌi, la Iesu iloꞌa ta molomolo noxou meꞌa no laxaꞌilu ne, miluꞌe. La Anu mulai mutulu no anu lialia latia vile. Io, ta molomolo noxou tapiena mineꞌe mipita noxou. Xe ta mitema tavuꞌalo manina sou tuatuala no xalee lia tila ne Iutaia mo no tuala tila ne Ielusalemu mo ꞌalai no luaki paꞌupaꞌumolu no tuala ne Taia xe ne Saidoni, aneꞌi kalumo mineꞌe mipita ne. ");
INSERT INTO ata_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Seꞌi noxiꞌa ne mineꞌe mipita sou lexe ilomusou vaikala noxou, xe seꞌi ne mineꞌe sou Iesu upamaulineꞌi. La ta mitema e ta ulee masumasua miꞌoxo masuaneꞌi ne mixali laixe. ");
INSERT INTO ata_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mo ta mitema mukalusi e mitovo sou mikasou Iesu ne, aneꞌi mixali laixe. Xo xavi muxolu noxou ne, mulaa sou mupamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu iou mulai noxiꞌa ta molomolo noxou, io muvikalaneꞌi aloxo ꞌo, “Ngingi ane mengi lavuluti uasi, la ngingi ngaꞌosa, xo Lataua usaxilaꞌinge. ");
INSERT INTO ata_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Xe ngingi ane laꞌilalingenge uasi, la ngingi ngaꞌosa, xo iliꞌi, la Lataua ulosinge laꞌilali mo ngaꞌanaꞌana. Mo ngingi ane ngaxolu sou ngatatama, la ngingi ngaꞌosa, xo iliꞌi, la ngingi ngakeke. ");
INSERT INTO ata_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Xe iliꞌi, la ta mitema imasaxainge uasisi manina mo ikusainge mo ikalipalangengi mo ivikala lexe ngingi ta mitema ta masua xo ngingi ngemulinu Itema ꞌOlu ne. Ia mii vile uasi, ngingi ngaꞌosa. ");
INSERT INTO ata_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","No voxo ane ta mitema iꞌoxo aloxo ne noxinge loxo ta ꞌiluꞌilusuneꞌi miꞌoxo masuaneꞌi ta mitema sou palomatana tatei, la opongengi uai laixesi mo ngalei sou ꞌosaꞌila. Xo lakolisou sou ngemulileli ne tatila musuku a uai sou nganoꞌu iliꞌi no opo loxotolo. ");
INSERT INTO ata_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ia, ngingi ane ngeꞌosa xo lavulutimengi tapiena ꞌo, iliꞌi la ngaxolu no anu tuꞌumaxu ");
INSERT INTO ata_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Xe ngingi ane ngeꞌani mo ngeꞌanaꞌana vaimomo ꞌo, iliꞌi la ngaxolu no anu tuꞌumaxu sou ngasolingenge. Mo tuꞌumaxu uxali noxinge ane ngakeke vaimomo ꞌo, xo iliꞌi la ngaxolu sou tama. ");
INSERT INTO ata_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mo lexe ta mitema iꞌitiꞌitinu ualasinge loxo ta ꞌiluꞌilusuneꞌi miꞌoxo noxiꞌa ta mitema sou palomatana kalakalavoi tatei, la ngingi ngaxolu no anu tuꞌumaxu, xo ngingi ngeꞌoxonu xaixai loxo aneꞌi ta mitema sou palomatana kalakalavoi miꞌoxonu tei.” ");
INSERT INTO ata_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Iesu musolonu vaivaikalau, la muvikalaneꞌi ta molomolo noxou la aloxo ꞌo, “Ioxe, eni avikalangengi ngingi e ngalolomusilo lexe ngingi ngamasaxaiꞌa ta uluamengi. Mo ngaꞌoxo ꞌilixo laixe noxiꞌa aneꞌi ane imasaxainge uasisi manina. ");
INSERT INTO ata_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mo ngaalusiꞌa aneꞌi ane ivavaangenge. Mo ngakilakasiꞌa aneꞌi ane iꞌoxo masuangengi. ");
INSERT INTO ata_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mo loxo evile usavalou xaleeneni vile, la naxiu xaleeneni vile la mo usavalou la. Mo loxo evile uꞌumenu tokolomomeni vile sou vasimene no ale, la nini namalanixu unoꞌu vile ane sou no nano ne la kalumo. ");
INSERT INTO ata_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mo aneꞌi ane ilingaiꞌa mimii noxine, la nalosiꞌasi. Mo lexe itema vile unoꞌu mii vile noxine, la nalingau la mamu. ");
INSERT INTO ata_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngaꞌoxonu mii ulai noxiꞌa ta mitema aloxo ngingi ngemasaxa lexe aneꞌi iꞌoxo uneꞌe noxinge nesi. ");
INSERT INTO ata_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Xo lexe ngingi ngamasaxaiꞌa ta mitema ane aneꞌi mimasaxaingesi, la Lataua ulosinge lakolisou ꞌilixomengi ne? Uasi. Xo ta mitema sou ꞌiliꞌilixo masumasua kalumo ne, ilavusou iꞌoxonu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mo lexe ngingi ngaꞌoxonu ꞌilixo laixe noxiꞌa aneꞌi ane iꞌoxonu laixe noxinge, la Lataua ulosinge lakolisou ꞌilixomenge ne? Uasi. Xo ta mitema sou ꞌiliꞌilixo masumasua kalumo ne, ilavusou iꞌoxonu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mo lexe ngingi ngalosiꞌa ta mitema mimii vitanisi uasi, ia ngaxavutala lexe ikolinu ulivu ulai noxinge, la Lataua ulosinge lakolisou ꞌilixomengi ne? Uasi. Xo ta mitema sou ꞌiliꞌilixo masumasua kalumo ne, ilavusou iꞌoxonu aloxo ne. ");
INSERT INTO ata_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ia ngingi ngaꞌoxonu loxo ta mitema sou ꞌiliꞌilixo masumasua ilavusou iꞌoxonu uasi. Eni avikalangengi pekiaꞌu lexe ngamasaxaiꞌa ta uluamengi mo ngaꞌoxonu laixe ulai noxiꞌa mo ngalosiꞌa mimii vitanisi, ia mamu sou ngaxavutala lexe ikolinu noxinge. Lexe ngingi ngaꞌoxonu aloxo ne, la ngingi nganoꞌu lakolisou toxoxu mo ngingi ngaxolu loxo Lataua Teitexi Manina ta ꞌolu. Xo anu tanuxaꞌa ta mitema ta masua e ilavusou ilemolu laixe noxou uasi. ");
INSERT INTO ata_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","La sou ngingi kalumo tangengixaꞌa ta mitema aloxo Maminge tanuxaꞌa ne. ");
INSERT INTO ata_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mukalu, la Iesu muvikalaneꞌi aloxo ꞌo la, “Mamu sou ngatilovosou ꞌilixoiꞌa ta menexinge, mo sou Lataua utilovosou ꞌiliꞌilixomengi uasi. Mo mamu sou ngavikala lexe aneꞌi ta mitema sou ꞌilixo masua, mo sou Lataua uvikalasinge lexe ngingi ta mitema sou ꞌilixo masua mamu. Ia ngaxiu tumalingeu ꞌilixo masumasua noxiꞌa ta menexinge, mo sou Lataua uxiu tumalouu ꞌilixo masumasua noxinge kalumo. ");
INSERT INTO ata_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Io, ngalosiꞌa ta menexingesi, mo sou Lataua ulosinge kalumo. La uvelu laixe mo utaanu uꞌanaꞌana manina no anu kupomengi, ia utaanu sio mo upaxepaxelesinge sou nganoꞌu. ꞌIlixo sou ngaiti mi ane ngingi ngaꞌoxo ulai noxiꞌa ta menexinge ne, anusi ane Lataua uꞌoxo uneꞌe noxinge.” ");
INSERT INTO ata_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu muvikalaneꞌi la no anu vaikala tovolaꞌi vile aloxo ꞌo, “Itema vile iou seleveenu, la umomomo sou utilau menexu vile iou seleveenu la uasi. Lexe aloxo ne, la ilou ikei italoxo no anu taxa. ");
INSERT INTO ata_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xe molomolo vile sou umulimulinu tila noxou ne, umomomo sou uuaulixu tilasou ne uasi. Ia lexe anu unoꞌu lavulavu ukalusi noxou tilasou ne, la sou anu uxali loxo tilasou ne. ");
INSERT INTO ata_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ia tavaꞌu loxovaa, la sou namaisou ꞌiliꞌili se no iou itema vile noxou Lataua e anu loxo vivine, ia namaisou ovu visoxu e muxolu no ieni ne uasi? ");
INSERT INTO ata_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nini namaisou ovu visoxu no ieni uasi, io loxovaa la sou navikalanu vivine lexe, ‘Vivilo, ieni uvaxailosi mo axexeenu ꞌiliꞌili no ieni.’ La nini loxo itema sou kalavoi manina. Tei, la nini naxexeenu ovu visoxu no ieni o, ka sou namalei lamana laixe sou naxexee ꞌiliꞌili se noxou vivine iou ne.” ");
INSERT INTO ata_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mukalu, la Iesu muvikalaneꞌi aloxo ꞌo la, “Ovu laixe ne, ulavusou uneneꞌa masua uasi. Xe ovu masua ne, ulavusou uneneꞌa laixe uasi. ");
INSERT INTO ata_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ovuovu ne, ta mitema itongonu no anu ngiaxu. Umomomo sou ta mitema iꞌelexu lovo temanu no anu lamota anaanaxu uasi, xe umomomo sou iꞌelexu uaini ngiaxu no anu xuxua uasi. ");
INSERT INTO ata_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Anu aloxo nesi, itema laixe ulaalixu ꞌiliꞌilixo laixe ane muxolu no tanu. Xe itema masua ulaalixu ꞌiliꞌilixo masumasua ane muxolu no tanu. Xo ta mitema ilavusou ipalaꞌalixu no anaxaꞌa mii maꞌia ane muxolu no nano no taneꞌi.” ");
INSERT INTO ata_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mukalu, la Iesu muvikalaneꞌi aloxo ꞌo la, “Ngingi ngamoxoꞌilo lexe, ‘Tila noxixe, Tila noxixe.’ Ia loxovaa, la sou ngalomuxo sou ngamulinu vaikala noxilo uasi ꞌo? ");
INSERT INTO ata_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Itema ane uneꞌe noxilo mo ulomusou vaikalaxeni xe umulinu, la avikalangengi lexe anu itema ne a loxovaa? ");
INSERT INTO ata_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Anu ne, aloxo itema e muꞌasou taxa mulai no lia muxalisou lavoꞌo, la mutulusou tani teiteixi no anu. Iliꞌi xe uali musili xe lexa muꞌani, la tani ne ukuni uasisi xo anu mutulu musiatoto pekiaꞌu no lavoꞌo kisou. ");
INSERT INTO ata_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ia itema vile ulomusou vaikalaxeni, ia umulinu uasi ne, anu aloxo itema e mutulusou tani no lia vitavitanisi. Iliꞌi xe uali musili, xe lexa muꞌani, la tani ne mulapau alaxu vilesisi la mumamulo avile.” ");
INSERT INTO ata_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu muvikalaneꞌi ta molomolo noxou e mipita sou milomusou ne mukalu, la Anu muꞌunalai no tuala ne Kapenaumu. ");
INSERT INTO ata_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","La itema sou xaixai noxou tila noxiꞌa ta mitema itemaxu taꞌuve sou ꞌotoꞌoto, mupipiena mo anu sou usoli. Ia tilasou ne, mumasaxau misevile. ");
INSERT INTO ata_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ia no voxo ane ne, la mulomusou lexe Iesu muxali ne Kapenaumu. La sou anu mupalusiꞌa ta tatila noxiꞌa ta Iutaia milai milinga noxou Iesu lexe uneꞌe mo upamaulinu itema sou xaixai noxou. ");
INSERT INTO ata_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aneꞌi mixali noxou Iesu, la miuoloteteu mo mivikalanu aloxo ꞌo, “Itema e mupalusixe teneꞌe ne, anu itema laixe manina. La sou laixe sou nini nasuꞌulinu. ");
INSERT INTO ata_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Xo anu mulavusou umasaxaixe nexi ta Iutaia mo anu molu mutulusou taasou lalotu noxixe.” ");
INSERT INTO ata_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","La sou anu iloꞌa milai. Milai xe mixali ꞌalaꞌalai no tani noxou tila noxiꞌa ta mitema itemaxu taꞌuve sou ꞌotoꞌoto ne, la anu mupalusiꞌa ta menexu seꞌi milai noxou Iesu sou mivikalanu aloxo ꞌo, “Tila, napuuneni sou nalai no tani noxou menexixe mamu. Xo anu muvikala lexe anu itema laixe sou uꞌavaline nalai no tani noxou uasi. ");
INSERT INTO ata_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","La sou anu molu uneꞌe uxali noxine uasi. Ia mumasaxa lexe nini navikalasi, la sou itema sou xaixai noxou ne umauli laixe. ");
INSERT INTO ata_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anu muvikala aloxo ne, xo anu kalumo muxolu no laaxu tila noxou, mo anu kalumo musaxilaꞌa ta mitema sou ꞌotoꞌoto noxou, la aneꞌi mixolu no laaxu la. Uvikalanu vile noxiꞌa lexe ulai, la anu ulai. Xe uvikalanu vile noxiꞌa lexe uneꞌe, la anu uneꞌesi. Mo uvikala itema sou xaixai noxou vile lexe uꞌoxonu mii ꞌo, la anu uꞌoxonusi.” ");
INSERT INTO ata_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu mulomusou vaikala noxiꞌa aloxo ne, la mukuluke ka muxiu mulai noxiꞌa ta mitema e mimulimulinu, io muvikalaneꞌi aloxo ꞌo, “Avikalangengi, eni axalisou itema vile sou muxamuxaxu tanu noxilo loxo ꞌo no taiingengi ngingi ta Isilaeli uasi.” ");
INSERT INTO ata_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta mitema e tila noxiꞌa ta mitema sou ꞌotoꞌoto mupalusiꞌa ne, milivu milai no taasou, la mimaisou itema sou xaixai noxou ne mumauli laixe mukalu. ");
INSERT INTO ata_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iliꞌi sevile la, la Iesu iloꞌa ta molomolou mo ta mitema tavuꞌalo mikei mivaxa no tuala vile ilemolu lexe Naini. ");
INSERT INTO ata_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anu iloꞌa mixali ꞌalai no iou xalengaxu tuala ne Naini ne, la mixalisiꞌa ta mitema mitavulenu itema e musoli ne miuatunu. Itema e musoli ne, anu sema vaalu vile ꞌilie vilesisi anesi, mo ta mitema tavuꞌalo no tuala ne mivaitaone sou miuatunu ꞌilie ne. ");
INSERT INTO ata_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Xe Tila mumaisie vaalu ne, la tanuxe manina la sou muvikalane lexe, “Natama uasi.” ");
INSERT INTO ata_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Muvikalane mukalu, la mulai ꞌalai no luvo sou muꞌitalonu avolu no anu. La ta mitema e mitavulenu luvo ne, mitulu. Ia Iesu muvikalanu itema e musoli ne aloxo ꞌo, “Nini maulu ne, eni avikalaneni lexe natulu.” ");
INSERT INTO ata_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","La itema e musoli ne, muavuti mutalupexa mo musoko sou muvivikala avile. La Iesu muꞌitalonu mulivu noxie nenu. ");
INSERT INTO ata_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Xe ta mitema tavuꞌalo mimaisou aloxo ne, la mimamaꞌu misevile mo miꞌitinu Lataua ualasou. La seꞌi noxiꞌa mivikala aloxo ꞌo, “Itema sou palomatana vile tila a muxali noxinge ꞌo.” Xe seꞌi mivikala aloxo ꞌo, “Lataua anu a muneꞌe ꞌo sou usuꞌulineꞌi ta mitema noxou.” ");
INSERT INTO ata_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","La sou ta mitema milutunoxu aꞌalo sou mimii e Iesu muꞌoxonu ne, mulai no xalexalee tuatuala mukalusi no xalee lia tila ne Iutaia mo tuatuala seꞌi ꞌalaꞌalai ne Iutaia. ");
INSERT INTO ata_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioxe, ta molomolo noxou Ioanesi milomusou aꞌalo sou mimii ane Iesu muꞌoxonu ne, la milai miaꞌaloxu mukalusi noxou Ioanesi. ");
INSERT INTO ata_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","La sou Ioanesi muꞌavaliꞌa ta molomolou tamei sou mupalusiꞌa milai noxou Tila sou lexe italiꞌisou aloxo ꞌo, “Nini itema e Lataua muvikala lamana tei sine lexe usovaneni naneꞌe ano ꞌo? Uasi? Nexi taxomaiou itema vile anu a uao?” ");
INSERT INTO ata_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tamei ne, mixali noxou Iesu mukalu, la mivikalanu aloxo ꞌo, “Tila noxixe Ioanesi mupalusixe sou tataliꞌisine lexe, ‘Nini mitema e Lataua muvikala lamana tei lexe usovaneni naneꞌe ano ꞌo? Uasi? Nexi taxomaiou itema vile anu a uao?’” ");
INSERT INTO ata_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","No voxo ngiou ane ne, la Iesu mupamaulineꞌi ta mitema tavuꞌalo ane pipiena iouiou muꞌoxoneꞌi mo aneꞌi ane ta ulee ta masumasua mixolu noxiꞌa xe mupamaulineꞌi ta mitema tavuꞌalo aneꞌi ane ieꞌi seleveenu kalumo. ");
INSERT INTO ata_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","La sou Iesu mukolinu taliꞌi noxou Ioanesi, la muvikalaneꞌi ilou aloxo ꞌo, “Ngingi nongou ngalivu mo ngavikalanu Ioanesi sou mii maꞌia ane ngingi nongou ngemaisou mo ngelomusou ꞌo. Mimii e ngemaisou mo ngelomusou ne aloxo ꞌo. Aneꞌi ane ieꞌi seleveenu ne, aneꞌi mimalei laixe mo aneꞌi ane tavaꞌa musoisoli ne, aneꞌi a mimuamuaꞌi mo aneꞌi ane vulukali muꞌou vasimeꞌa ne, aneꞌi a vasimeꞌa laixe mo aneꞌi ane sangaliꞌa mutomutomu ne, aneꞌi a milomu laixe mo aneꞌi ane misoisoli ne, aneꞌi a mimauli. Xe aneꞌi ane lavulutiiꞌa uasi ne, aneꞌi milomusou aꞌalo laixe noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aloxo ne, la sou Lataua ualusou ꞌenaꞌei ane xavutalau mutulu vilesisi noxilo, ia ukalipala mo ulapau uasi.” ");
INSERT INTO ata_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioxe, ta mitema tamei e Ioanesi mupalusiꞌa mineꞌe ne, milivu mukalu, la sou Iesu muavuti sou muvikalaneꞌi ta mitema lamana sou Ioanesi aloxo ꞌo, “No voxo ane ngingi ngelai no xalee lia vitanisi ne sou lexe ngamaisou mii maꞌia? Ngelai ne sou lexe ngamaisou visoviso voloxu no mine atume uiliilisou? ");
INSERT INTO ata_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lexe uasi, la ngelai sou lexe ngamaisou mii maꞌia ne? Ngelai ne sou lexe ngamaisou itema vile mutokolomo lailaixe? Uasi. Ta mitema ane lavulutiiꞌa tapiena xe itokolomo lailaixe mo iꞌaniꞌani lailaixe ne, ixolu no taasiꞌa ta tatananu tualasi. ");
INSERT INTO ata_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lexe uasi, la ngingi ngelai sou lexe ngamaisou mii maꞌia ne? Ngelai sou lexe ngamaisou itema sou palomatana vile ne? Ani, eni avikalangengi lexe ngingi ngelai sou lexe ngemasiou itema vile ne anu tila noxiꞌa ta mitema sou palomatana ane tei. ");
INSERT INTO ata_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Itema ane nesi, aneꞌi mikaukavusou muxolu no nano no Lavuku Tavuna teinu lexe, ‘Lataua upalusou itema vile sou aꞌalo noxou, sou uulaxuneni Tila mo upaipounu voteꞌisine tei.’ ");
INSERT INTO ata_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eni avikalangengi aloxo ꞌo. Ioanesi ne, anu tatila manina noxiꞌa ta mitema mukalusi no lia ꞌo. Ia itema ane uxali kituꞌa manina no nano no anu saxisaxilaꞌu noxou Lataua, la anu utila noxou Ioanesi.” ");
INSERT INTO ata_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ta mitema tavuꞌalo mukalusi mo ta mitema sou itaxusou lamoli kalumo, milomusou vaikala noxou Iesu aloxo ne, la milavu lexe ꞌiliꞌilixo noxou Lataua ne mulapu manina. Xo aneꞌi milai noxou Ioanesi sou anu muꞌulosiꞌa tei. ");
INSERT INTO ata_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ia ta Palisaio iloꞌa ta mitema sou lapuloto ne imasaxa sou imulinu masaxa noxou Lataua siꞌa ne uasi. Xo aneꞌi ilai noxou Ioanesi sou anu uꞌulosiꞌa tei uasi. ");
INSERT INTO ata_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mukalu, la sou Iesu muvikalaneꞌi la aloxo ꞌo, “Lexe eni amasaxa sou avikala tovolaꞌisiꞌa ta mitema vaimomo ꞌo, la atovolaꞌineꞌi a loxovaa? Aneꞌi a loxo maꞌi? ");
INSERT INTO ata_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Aneꞌi a loxo ta molomolo e ixoxolu laꞌoluxaꞌa vilesisi no loxomala, io iꞌava noxiꞌa ngatoꞌo aloxo ꞌo, ‘Nexi tetau vei lexe sou ngingi ngalei, ia ngingi ngamasaxa sou ngalei uasi. Mo nexi tematengalei kalumo, ia ngingi ngamasaxa sou ngatama uasi.’ ");
INSERT INTO ata_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","La sou ngingi ne aloxo ta molomolo ne, xo Ioanesi sou uꞌulosiꞌa ta mitema muxali xe uꞌani veleti uasi mo uiexu uaini lexaxu uasi, la ngingi ngevikala lexe, ‘Ulee masua a uxolu noxou ne.’ ");
INSERT INTO ata_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Io, Itema ꞌOlu muxali xe muꞌaniꞌani mo muie, la ngingi ngevikalasou lexe, ‘Ngamaisou. Anu itema sou vunekaina mo uie uꞌoki manina. Mo Anu uvaitami noxiꞌa ta mitema sou itaxusou lamoli iloꞌa ta mitema sou ꞌiliꞌilixo masumasua.’ ");
INSERT INTO ata_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngingi ngevikalasilo aloxo ne, ia aneꞌi ane milavusou Lataua la milavusou lexe lavulavu noxou Lataua ne, anu maninasou.” ");
INSERT INTO ata_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iesu muvikalaneꞌi mukalu, la Palisaio vile muꞌavalou Iesu sou lexe ulai uꞌani no tani noxou. La sou Iesu mulai muxolu no tani noxou sou lexe uꞌani. ");
INSERT INTO ata_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","La sema sou ꞌiliꞌilixo masumasua vile e ixoxolu no tuala ane ne, milavusou lexe Iesu anu a uꞌaniꞌani no taasou Palisaio ane ne. La sou ane minoꞌu ueli e tumaꞌu lailaixe vexasou vile mineꞌenu no tani. ");
INSERT INTO ata_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mixali no tani, la milai mitulu no tumalou Iesu ꞌalai no tavaꞌu, ia itatama. Xe iei lexaxu munixi muluꞌe sou miuinu Iesu tavaꞌu mukalu, la milutunu no anu kisie laxusou. Mukalu, la ane mitimu tavaꞌu sou miꞌosasou xe minixiꞌu ueli e tumaꞌu lailaixe no anu. ");
INSERT INTO ata_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Xe Palisaio ualasou lexe Saimoni e muꞌavalou Iesu muneꞌe ne, mumaisie sema ne no mine miꞌoxonu Iesu aloxo ne, la tanu muvikala aloxo ꞌo, “Lexe mitema ano ꞌo ne Anu itema sou palomatana manina, la Anu ulavusie lexe ꞌenaꞌei ane ikakasou ꞌo mo ulavusou ꞌiliꞌilixoie kalumo. Xo ane sema sou ꞌiliꞌilixo masumasua.” ");
INSERT INTO ata_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Saimoni muxavutala aloxo ne, la Iesu mulavusou. La sou muvikalanu aloxo ꞌo, “Saimoni, Nalomu. Eni vaikala vile sou avikalanenixu aloxo ꞌo.” La sou Saimoni muvikalanu lexe, “Itema sou ulosixe lavulavu, nalemolu vaikalameni ne.” ");
INSERT INTO ata_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","La Iesu muvikalanu aloxo ꞌo, “Ta mitema tamei minoꞌu itema vile lamoliu, io lexe iliꞌi la ikolinu. Vile noxiꞌa munoꞌu Denalia itemaxu mavulovexa tamei mo itemaxu taꞌuve (500) xe vile munoꞌu Denalia mavulovexa taꞌuve (50). ");
INSERT INTO ata_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ia aneꞌi ilou imomomo sou ikolinu uasi. Loxo ne, la sou moosou lamoli ne muvikalaneꞌi ilou lexe mamu sou ikolinu. Ioxe, nini naxavutala lexe ꞌenaꞌei noxiꞌa ilou ane umasaxau mitema ne musuku?” ");
INSERT INTO ata_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","La Saimoni mukolinu aloxo ꞌo, “Eni exavutala lexe mitema ane munoꞌu lamoli tatila, io moosou muvikalanu lexe mamu sou ukolinu.” Iesu mulomusou aloxo ne, la muvikalanu lexe, “Xavutalameni ne, mulapu manina.” ");
INSERT INTO ata_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mukalu, la Iesu muxiu sou iou mulai noxie sema ne, io muvikalanu Saimoni aloxo ꞌo, “Nini nemaisie sema ꞌo? Eni eꞌuna no taasine ꞌo, la nini natau lexa sou nauinu tavaꞌilo uasi. Ia sema ano ꞌo ne, ane miuinu tavaꞌilo no ꞌa iei lexaxu mo miasou no anu kisie laxusou. ");
INSERT INTO ata_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mo nini natimu xaleeleli sou naꞌosasilo uasi. Ia sema ano ꞌo ne, ane mitimunu tavaꞌilo ne no mine eni eꞌuna mo. ");
INSERT INTO ata_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mo nini nanixiꞌu ueli e tumaꞌu lailaixe no kisilo uasi. Ia sema ꞌo nesi, ane minixiu no tavaꞌilo. ");
INSERT INTO ata_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aloxo ne, la sou eni avikalaneni lexe ane sema ꞌo mimaxaꞌu masaxasilo tila musuku, xo Lataua muxiu tumalouou ꞌilꞌilixo masumasua noxie. Ia mitema e muꞌoxonu ꞌiliꞌilixo masumasua tavuꞌalo, ia Lataua muxiu tumalouu ꞌiliꞌilixo masumasua noxou taꞌeisi, la anu umaxaꞌu masaxasou Lataua ne sevile kituꞌasi.” ");
INSERT INTO ata_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iesu muvikalanu aloxo ne mukalu, la muvikalane sema ne aloxo, “Eni exiunu tumalilou ꞌiliꞌilxo masumasua noxine mukalu ne.” ");
INSERT INTO ata_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ta mitema e mixolu mipita sou ꞌaniꞌani ne, milomusou muvikala aloxo ne, la aneꞌi miavuti sou mivikalaneꞌi ngatongatoꞌo aloxo ꞌo, “Itema ano ꞌo ne, anu itema maꞌi, la sou uxiunu tumalouu ꞌiliꞌilixo masumasua ꞌo?” ");
INSERT INTO ata_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","La Iesu muvikalane sema ne aloxo ꞌo, “Nini nemulaxu taneni noxilo, la sou Lataua mupamaulineni. Nini nalai, no ꞌa opo seꞌisisi.” ");
INSERT INTO ata_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Xe iliꞌi, la Iesu muxixaoxao no tuatuala seꞌi tatatila xe seꞌi kitukituꞌa sou muaꞌaloiꞌa ta mitema sou aꞌalo laixe sou saxisaxilaꞌu noxou Lataua. La ta molomolo noxou mavulovexa mo muluꞌe no lia tamei kalumo a mimulinu ne. ");
INSERT INTO ata_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mo ta sema moseꞌi e tei la Iesu mukusaiꞌa ta ulee ta masumasua noxiꞌa mo mupamaulineꞌi no anu pipienaxaꞌa ne, aneꞌi a imumulinu kalumo. Vile ualasie lexe Malia sie Maxatale e Iesu mukusaiꞌa ta ulee ta masumasua muxatele tamei noxie. ");
INSERT INTO ata_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Xe vile ualasie lexe Ioana e Kusa semau. Io, Kusa ne, anu itema tila noxiꞌa aneꞌi ane isaxilaꞌu tani noxou Elodesi. Xe Susana iloꞌa ta sema tapiena moseꞌi la mimulineꞌi Iesu iloꞌa ta molomolo noxou. Aneꞌi ta sema ane ne, mimolo mimii noxiꞌa sou isuꞌusuꞌulineꞌi Iesu iloꞌa ta molomolo noxou no anu. ");
INSERT INTO ata_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ta mitema tavuꞌalo mixali mipita noxou Iesu, ia ta mitema meꞌa no tuatuala kalumo mixaxali sio sou mipita noxou, la Iesu muvikala tovolaꞌi vile mulai noxiꞌa aloxo ꞌo, ");
INSERT INTO ata_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“No voxo vile, la itema vile mulai no xai sou usuꞌanu ovu ngiaxu. No mine anu ususuꞌanu ovu ngiaxu ne, la seꞌi mulapalapau no voteꞌi. La ta mitema mimalomaloxou xe ta ngiala miꞌou. ");
INSERT INTO ata_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xe moseꞌi mulapalapau no lavolavoꞌo. La mupau, ia muxalo la. Xo lia siliu uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xe moseꞌi mulapalapau no xuxua tanutanu, xe muleme la xuxua ne muisiisinu mole uleme laixe sou uneneꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ia moseꞌi mulapalapau no lia laixe mole muleme muxali tila sou muneneꞌa. Moseꞌi muxalixu ngiaxu itemaxu taꞌuve (100).” Iesu muvikala tavolaꞌi mulai noxiꞌa mukalu, la muꞌava noxiꞌa aloxo ꞌo, “Itema ane anu mulavu lexe anu sangalou a uxoxolu sou ulolomu no anu, la laixe lexe anu ulomusou vaikala ane ne no anu.” ");
INSERT INTO ata_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ioxe, ta molomolo noxou Iesu milomusou vaikala tovolaꞌi noxou ne, ia ilamana no anu uasi. La sou aneꞌi mitaliꞌisou Iesu lexe ulamanalixaꞌa no anu vaikala tovolaꞌi ne laaxu. ");
INSERT INTO ata_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","La sou Iesu mulamanalixaꞌa no anu aloxo ꞌo, “Lataua mulosiengixu laaxu vaikala mutalume sou saxisaxilaꞌu noxou. Ia ta mitema vaꞌaxu ilomusou vaivaikala latala ne no anu vaikala tovolaꞌisi. Mo sou, ‘aneꞌi imalei, ia imaisou mii vile uasi, mo ilolomu, ia ilavusou mii vile uasi.’ ");
INSERT INTO ata_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ioxe, vaikala tovolaꞌi ane ne, laaxu aloxo ꞌo. Ovu ngiaxu ne, anu musosovosou vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Vaikala ane anu musuꞌanu xe mulapau no voteꞌi ne, anu loxo ta mitema ane ilomusou vaikala noxou Lataua, ia Satani uneꞌe la uxexeenu vaikala ane Lataua mutounu no oponeꞌi ne alaxu vilesisi. Xo Satani uxavutala lexe loxo ꞌo io aneꞌi imulaxu taneꞌi noxou Lataua, la Lataua upamaulineꞌi. ");
INSERT INTO ata_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Xe vaikala ane anu musuꞌanu, io mulapau no lavolavoꞌo ne, anu loxo ta mitema ane ilomusou vaikala noxou Lataua la inoꞌu palea mo iꞌosasou. Ia tavaꞌu xo uliuliꞌa uasi, la vaikala ne uxolu maxuveeni uasi. Xe no anu voxo ane loxo tovotovo uxali noxiꞌa, la aneꞌi ilapau alaxu vilesisi. ");
INSERT INTO ata_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Xe Vaikala ane anu musuꞌanu xe mulapau no xuxua tanu ne, anu loxo ta mitema ane ilomusou vaikala noxou Lataua ne. Ia aneꞌi imulinu masaxa noxiꞌa sou ixavutala piena no anu mauli ilou xoluxolu no lia ꞌo mo imasaxa lexe iꞌa lavuluti piena mo oponeꞌi uisuisuxu mimii iouiou, la sou anu mimii ane ne uvausou vaikalau Lataua la uneneꞌa uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ia vaikala ane musuꞌanu xe mulapau no lia laixe ne, anu loxo ta mitema ane ilomusou vaikala noxou Lataua no anu oponeꞌi lailaixe manina, la inoꞌu mo itetelisou pekiaꞌu la ineneꞌa.” ");
INSERT INTO ata_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu muavuti, la muvikala aloxo ꞌo la, “Itema vile umomomo sou uꞌelaxu telu ka utulu pupunisou xe utalumeu no lia no laaxu luu uasi. Ia anu utulusou teitexi no valovalo, mo sou ta mitema e iꞌuna no tani ne, la imaisou lamana ane ne. ");
INSERT INTO ata_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Xo mimii ukalusi ane mutalume ne, iliꞌi la anu upalaꞌa. Mo mimii ukalusi ane ta mitema mivauvausou mo a uai ne, iliꞌi la upalaꞌa no taatexa. ");
INSERT INTO ata_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aloxo ne, la sou ngingi ngalaxaꞌingengi sou ngalomusou vaikala. Xo lexe itema vile mimiu tavuꞌalo sevile, la Lataua ulosou moseꞌi la. Ia lexe itema ane miumiu uasi, ia uxavutala lexe anu miu sevile ne, la Lataua uxexee noxou.” ");
INSERT INTO ata_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xe iliꞌi, la Iesu nenu iloꞌa ta vimovimou mineꞌe sou lexe imaisou, ia aneꞌi imomomo sou ixali noxou uasi. Xo ta mitema tapiena musuku, la mitaluxaꞌa. ");
INSERT INTO ata_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","La sou itema vile muvikalanu Iesu aloxo ꞌo, “Nenine iloꞌa ta vivine aneꞌi a itutulu no ale sou imasaxa lexe imaisine.” ");
INSERT INTO ata_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","La Anu mukolinu vaikala noxou mitema ne aloxo ꞌo, “Aneꞌi ane ilomusou vaikala noxou Lataua mo imulinu, la aneꞌi ne eni nenilo mo ta vivilo.” ");
INSERT INTO ata_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","No voxo vile iliꞌi, la Iesu muvikalaneꞌi ta molomolo noxou lexe, “Nengeꞌa talai no kupa xalee vile.” La sou aneꞌi iloꞌa mitelo no anu uaxa sou milai. ");
INSERT INTO ata_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aneꞌi mivole uaxa ne lexe sou ilai xalee vile, la Iesu mupasipaa la muai. Ia atume vile tatila muilisou kupa, la muavutinoxu xasi tatila mole lexa muꞌuna no anu uaxa mo ꞌalai sou iꞌuoꞌuo. ");
INSERT INTO ata_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","La sou aneꞌi milai mitulusou Iesu sou mivikalanu lexe, “Tilasixe, tilasixe. Natulu mo nasuꞌulinenge, xo nenge asou taꞌuoꞌuo!” Xe Iesu muavuti mutulu, la mukaitoloneꞌi atume ilou xasi tila ne. La atume ilou xasi tila ne, tasiauxaꞌa avile mo lexa loxoꞌu muai seꞌisisi. ");
INSERT INTO ata_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mukalu, la sou Iesu muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Loxovaa, la sou ngingi ngamuxaxu tangengi noxilo uasi ꞌo?” Iesu muꞌoxo aloxo ne xe aneꞌi mimaisou, la aneꞌi mikuluke mo mimamaꞌu. La sou mivikalaneꞌi ngatongatoꞌo aloxo, “Itema ano ꞌo ne, Anu itema maꞌi ꞌo? La sou atume ilou xasi milomuxu vaikalau ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aneꞌi mivole uaxa no anu kupa ne Xalilaia, la milai mixali no xalee vile no xalee lia tila ne Xelasene. ");
INSERT INTO ata_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Xe Iesu muiliꞌe muuatu no uaxa sou lexe ulai no ale. La mitema vile e ulee masua muxolu noxou ne, molu no tuala ane ne muneꞌe muxalisou Iesu. Itema ane ne, anu ulavusou usakii malo uasi mo ulavusou uxoxolu no tani vile uasi maxuveeni manina. Ia ulavusou uxoxolu no loulousiꞌa ta mitemasi. ");
INSERT INTO ata_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Io, no mine anu mumaisou Iesu, la anu muꞌava tatila ka mulapau noxou Iesu tavaꞌu. Io anu muunga toxoxaꞌa mulai noxou Iesu sou muvikala aloxo ꞌo, “Iesu, nini Lataua e muxolu teitexi manina ꞌOlu. Nini nemasaxa lexe naꞌoxonu maꞌia noxilo? Eni alingaine lexe mamu sou naꞌoxo masua noxilo!” ");
INSERT INTO ata_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Anu muꞌava tatila aloxo ne, xo Iesu muvikala pekiaꞌu mulai noxou lexe uxexesou mitema ne. Xo ta mitema e isaxilaꞌu itema ne, misakisakiinu avolu ilou tavaꞌu no anu xalolo. Ia alaxu tavuꞌalo, xe ulee masua ne uꞌaisou, la anu uxotosou xalolo ane ne. Io, ulee masua ne ulaixu no xalee lia ane ta mitema ixolu no anu uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","La Iesu mutaliꞌisou aloxo ꞌo, “Ualasine a loxovaa?” La anu mukolinu aloxo ꞌo, “Ualasilo lexe Lexioni.” Xo ta ulee ta masumasua tavuꞌalo mixolu mipita noxou. ");
INSERT INTO ata_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aneꞌi milinga noxou Iesu alaxu tavuꞌalo lexe mamu sou Anu ukusaiꞌa ilai no taxa e kaluxusou uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ia, ta memee laꞌoluxaꞌa vile toxoxaꞌa a iꞌaniꞌani no laxaꞌilu vile ꞌalai ne. La sou ta ulee ta masua ne, milinga pekiaꞌu noxou Iesu lexe upalusiꞌa ilai iꞌuna noxiꞌa ta memee ne. La Iesu muvikala lexe ilai iꞌuna noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","La sou aneꞌi mixexesou mitema ane ne, io milai miꞌuna noxiꞌa ta memee. Miꞌuna noxiꞌa, la ta memee laꞌoluxaꞌa ne miiaꞌuxu miluꞌe no tavaꞌu maea e no kupa ne, la miꞌuoꞌuo mole misoisoli mukalu. ");
INSERT INTO ata_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Xe ta mitema sou isaxilaꞌa ta memee ne, mimaisou mii ane ne, la miꞌumeꞌume sou milai miaꞌalo no tuala xe tuatuala ane muxoluxolu no paꞌupaꞌumolu tuala ne. ");
INSERT INTO ata_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","La sou ta mitema sou tuatuala ne mineꞌe sou mimaisou mii maꞌia ane muxali ne. Mineꞌe xe mixali noxou Iesu, la mimaisou itema e ta ulee ta masumasua miꞌaisou ne a mutokolomo mo a uxoxolu noxou Iesu tavaꞌu. Xavutalau ne, mulamana ia uxovulaulau la uasi. Ta motu mimaisou aloxo ne, la mimamaꞌu misevile. ");
INSERT INTO ata_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Xe ta mitema ane aneꞌi mimaisou mii ane ne, miaꞌaloiꞌa ta mitema ane mixali ne sou imaisou itema ane ta ulee ta masumasua mixolu noxou ne, muxali laixe. ");
INSERT INTO ata_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Xe ta mitema latala no xalee lia tila ne Xelasene miavuti, la mivikalanu Iesu pekiaꞌu lexe Anu uxexesiꞌa. Xo aneꞌi mimamaꞌu manina. La sou Iesu mutelo no anu uaxa sou mulai. ");
INSERT INTO ata_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ioxe, Iesu asou lexe utelai no anu uaxa, la itema e ta ulee ta masumasua mixolu noxou ne, mutaliꞌisou pekiaꞌu lexe anu umulinu mo ilou ilai. Ia Iesu mulivusou, la muvikalanu lexe, “Nalai no tualasine mo nalai noxiꞌa ta minemineni la naaꞌaloxu mimii latala ane Lataua muꞌoxonu noxine.” La sou, anu itema ne mulai la musoko sou muaꞌaloiꞌa ta mitema mukalusi no tualasou no anu mimii latala e Iesu muꞌoxonu noxou ne. ");
INSERT INTO ata_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ioxe, Iesu mulivu muneꞌe no kupa paꞌumolu xalee vile, la ta mitema tavuꞌalo misevile milooxu sou misexelaxu. Xo aneꞌi mixolu ne imulaxu taneꞌi sousi. ");
INSERT INTO ata_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","La itema vile sou usaxilaꞌu taasou lalotu noxiꞌa ta Iutaia ne, ualasou lexe Iairo ne muneꞌe muxali. Muneꞌe muxali noxou Iesu, la mulapau muluꞌe noxou Iesu tavaꞌu, sou mukatu pekiaꞌu lexe Iesu ulai no taasou. ");
INSERT INTO ata_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Xo anu ꞌolu sema se vilesisi kituꞌa ne, ane asou isoli. Ane tauu iexe loxo mavulovexa mo muluꞌe no lia tamei. La sou Iesu mulutu sou ilou milai. Ilou milai ne, la ta mitema tavuꞌalo ne mimulinu, la mitomu manina. ");
INSERT INTO ata_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mo sema vile mineꞌe kalumo. Ane sema ne, sialu ululuꞌe noxie, la ukalu noxie uasi. Muxolu tauu ie mavulovexa mo muluꞌe no lia tamei. Ia itema vile umomomo sou upamauline uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ane mineꞌe mimulinu Iesu ꞌalai no tumalou, ka mikasou tokolomoxu e veveeni ne telexu. La sialu ne, mutalo mo mukalu avile. ");
INSERT INTO ata_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","La Iesu muavuti la mutaliꞌisiꞌa ta mitema aloxo ꞌo, “Ngingi ꞌenaꞌei ane mukasilo ꞌo?” La aneꞌi mikolinu lexe, “Nexi takasine uasi.” Ia Pita muavuti la muvikalanu Iesu aloxo ꞌo, “Tila, nini nalavusou lexe ta mitema tavuꞌalo musuku ane mipita ꞌo la sou misousouneni ne uasi?” ");
INSERT INTO ata_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Xe Iesu muvikala aloxo ꞌo, “Eni elavu lexe ngingi vile a mukasilo ꞌo, xo eni examuli xavi noxilo a muxexesilo.” ");
INSERT INTO ata_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Anu muvikala aloxo ne, la sema ne milavu lexe ane imomomo sou italume uasi. La sou ane miꞌoloꞌolo mineꞌe sou milapau noxou Iesu tavaꞌu. Xe no ieꞌi ta mitema tavuꞌalo ne, la ane mivikala lamana lexe tavaꞌu loxovaa la sou ane mikasou Iesu ne mo mivikala lamana kalumo lexe pipienaxe ne a muxexesie mo ane laixene avile. ");
INSERT INTO ata_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","La Iesu muvikalane aloxo ꞌo, “ꞌAlixeni, nini nemulaxu taneni noxilo, la sou pipiena noxine ne a mukalu. Nalai, ia oponeni uai seꞌisisi.” ");
INSERT INTO ata_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","No mine Iesu uao uvivikala sio, ia ta mitema seꞌi meꞌa no taasou Iairo, anu itema sou usaxisaxilaꞌu taasou lalotu noxiꞌa ta Iutaia, mineꞌe mivikalanu aloxo ꞌo, “ꞌIline sema ne a misoli ne. Ia naꞌausou itema sou ulosinge lavulavu ne malaxo mamu.” ");
INSERT INTO ata_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu mulomusou vaikala ane ne, la muvikalanu Iairo aloxo ꞌo, “Naꞌoloꞌolo mamu. Ia namuxaxu taneni noxilosi, la ꞌiline ne imauli.” ");
INSERT INTO ata_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ioxe, Iesu mulai muxali no tani noxou Iairo, la Iesu munoꞌa Pita iloꞌa Ioanesi ilou Iakovo mo molomolo sema ne mamie ilee neniesi sou iloꞌa miꞌunalai no tani. Xo Iesu umasaxa lexe evile la umulineꞌi uasi. ");
INSERT INTO ata_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iesu muꞌunalai no tani, la mumaisiꞌa ta mitema taneꞌixe molomolo ne mo itatamasie. Xe Iesu muavuti, la muvikalaneꞌi aloxo ꞌo, “Ngatama mamu. Xo ane isoli uasi, ane miaisi ane.” ");
INSERT INTO ata_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iesu muvikala aloxo ne, la aneꞌi mikekeiou xo milavusou lexe ane misoli. ");
INSERT INTO ata_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ia Anu muavuti la mukasi vaxa no avole, ka sou muvikalane aloxo ꞌo, “ꞌAlixeni seo, nini natulu!” ");
INSERT INTO ata_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iesu muvikalane aloxo ne, la uleenu mulivu muneꞌe muꞌuna noxie. La ane mitulu alaxu vilesisi. Mukalu, la Iesu muvikalaneꞌi lexe ilosie ꞌani sou iꞌou. ");
INSERT INTO ata_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Molomolo ne mamie ilee nenie mimaisou aloxo ne, la mikuluke manina. Ia Iesu muvikala pekiaꞌu noxiꞌa ilou aloxo ꞌo, “Masi la, ngingi ngongou ngavikalanu itema vile sou mimii ane muxali ꞌo, mamu.” ");
INSERT INTO ata_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Xe iliꞌi, la sou Iesu muꞌavaliꞌa ta molomolo noxou mavulovexa mo muluꞌe no lia tamei ne mineꞌe noxou. Mineꞌe mukalu, la muvikalaneꞌi xe mulosiꞌa xavi sou ikusaiꞌa ta ulee ta masumasua ukalausi e mixolu noxiꞌa ta mitema mo ipamaulineꞌi ta mitema no anu pipienaxaꞌa. ");
INSERT INTO ata_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xe muavuti, la mupalusiꞌa milai sou iaꞌaloxu aꞌalo sou saxisaxilaꞌu noxou Lataua xe ipamaulineꞌi ta mitema e mipipiena. ");
INSERT INTO ata_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mupalusiꞌa, la muvikalaneꞌi aloxo ꞌo, “Ngingi ngalai, io nganoꞌu mii vile no anu muamuaꞌingenge ne uasi. Nganoꞌu vilaxongenge mo tivamengi mo laꞌilalingenge mo lamolimengi xe tokolomomengi tamei mamu. ");
INSERT INTO ata_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xe ngalai no tuala vile xe ngaꞌunalai no tani vile, la ngaxolu anesi, ulai utalo no voxo ane sou ngingi ngaꞌumesou tuala ane ne. ");
INSERT INTO ata_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ia lexe ta mitema sou tuala ane ne, iꞌavalinge mo inoꞌinge iꞌunangengi no taasiꞌa uasi, la ngavutasou lomulo no tavaꞌinge ne uxexee, ia ngingi ngasukusou tuala ane ne. Ngaꞌoxo aloxo ne, mo sou aneꞌi ilavu lexe Lataua ulosiꞌa navunavu no anu ꞌilixo ane aneꞌi miꞌoxonu noxinge ne.” ");
INSERT INTO ata_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ioxe, aneꞌi milomu noxou aloxo ne mukalu, la milutusou milai no tuatuala sou miaꞌaloxu aꞌalo laixe noxou Lataua mo mipamaulineꞌi ta mitema mukalusi no anu pipienaxaꞌa. ");
INSERT INTO ata_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ioxe, ta mitema mimaisou xaixai e Iesu muꞌoxonu ne, la sou aneꞌi milai miaꞌaloxu noxou tatananu tuala e ualasou lexe Elodesi. La anu tanu lili, xo ta mitema seꞌi mivikala lexe Ioanesi e musoli ne a mumauli ne la. ");
INSERT INTO ata_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xe moseꞌi mivikala lexe Eliasi anu a muxali ne, xe moseꞌi la mivikala lexe anu vile noxiꞌa ta mitema sou palomatana tatei a mumauli la ne. ");
INSERT INTO ata_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ia Elodesi mulomusou vaikala ane ne, la muvikala aloxo ꞌo, “Ioanesi ne, eni epalusiꞌa la mixotonu xolanu ne. Io mitema ane ne, Anu itema maꞌi, la sou eni alomusou aꞌalo sou mimii ane anu uꞌoxoꞌoxonu ne?” La sou anu utovo sou lexe umaisou Iesu. ");
INSERT INTO ata_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ioxe, ta mitema sou xaixai noxou Iesu milivu mineꞌe mukalu, la aneꞌi miaꞌaloxu mimii ane aneꞌi miꞌoxonu. Xe mukalu, la Iesu munoꞌa sou iloꞌa mitalumexaꞌa ta mitema ne, sou milai no tuala vile ilemo lexe Vetesaida sou lexe imaꞌila. ");
INSERT INTO ata_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iloꞌa milai ne, io ta mitema tavuꞌalo milavusiꞌa. La sou aneꞌi milutu sou mimulineꞌi milai. Ia Iesu mumaisiꞌa aloxo ne, la musexelaxaꞌasi mo muaꞌaloiꞌa no anu saxisaxilaꞌu noxou Lataua xe mupamaulineꞌi aneꞌi ane mipipiena kalumo. ");
INSERT INTO ata_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iloꞌa mixoxolu ane xoo mole aso muluꞌelai, la sou ta molomolo noxou mavulovexa mo muluꞌe no lia tamei ne mineꞌe mixali noxou, la mivikalanu aloxo ꞌo, “Laixe lexe nini napalusiꞌa ta mitema ukalusi ꞌo mo ilai no tuatuala ane ꞌalaꞌalai ꞌo xe paꞌupaꞌumolu tuatuala ne sou ilotoxaꞌa laꞌilali mo ikamulisiꞌa tani sou iai no anu. Xo nenge texoxolu ꞌo no xalee tani ane ta mitema ixolu no anu uasi.” ");
INSERT INTO ata_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ia Anu muavuti la mukolinu vaikalaiꞌa aloxo ꞌo, “Ngingi menge ngalosiꞌa ꞌaniꞌani.” Xe aneꞌi miavuti la mikolinu Iesu aloxo ꞌo, “Ia lexe nenge tamomomosou talotonu laꞌilalixaꞌa ta mitema latala ꞌo uasi, la nexi tenoꞌu veleti taꞌuve xe sinana tameisi ꞌa uai ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ta mulusi ne, itititisiꞌa umomomo loxo itemaxu mavulovexa mavulovexa tamei mo itemaxu mavulovexa taꞌuve 5,000.) Ia Iesu muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Ngingi ngavikalaneꞌi ta mitema ne lexe ixoluxolu no lia laꞌolaꞌoluxaꞌa mavulovexa taꞌutaꞌuve.” ");
INSERT INTO ata_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","La sou ta molomolo noxou miꞌoxonu aloxo ne noxiꞌa ta mitema ne sou mixoluxolu no lia. ");
INSERT INTO ata_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Xe mukalu, la sou Iesu munoꞌu veleti taꞌuve xe sinana tamei ne. Io iou mutelo no opo loxotolo sou muvikala laixe musuku mulai noxou Lataua. Xe mukalu, la sou Anu museꞌiseꞌi veleti ilou sinana ne ka mulosiꞌa ta molomolo noxou ne sou mivelunu noxiꞌa ta mitema ne. ");
INSERT INTO ata_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","La aneꞌi ta mitema mukalusi ne, miꞌaniꞌani xoo mole miꞌanaꞌana manina. Io ikalusou uasi. La sou ta molomolo noxou minoꞌu lakela mavulovexa mo muluꞌe no lia tamei sou mineꞌe mitaataanu veleti ilou sinana paꞌupaꞌusou ane aneꞌi ikalusou uasi ne. ");
INSERT INTO ata_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","No voxo vile mine Iesu anusisi mulai sou mulinga mulai noxou Lataua, la ta molomolo noxou mimulinu. La Anu mutaliꞌisiꞌa aloxo ꞌo, “Ta mitema tavuꞌalo ꞌo ilemelo lexe eni ꞌenaꞌei?” ");
INSERT INTO ata_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xe aneꞌi miavuti, la mikolinu aloxo ꞌo, “Moseꞌi ivikala lexe nini Ioanesi e itema sou uꞌulosiꞌa ta mitema, xe moseꞌi ivikala lexe nini Eliasi, xe moseꞌi la ivikala lexe nini vile noxiꞌa ta mitema sou palomatana e tatei anu a mumauli la ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Xe Anu muavuti la mutaliꞌi vaxa noxiꞌa aloxo ꞌo, “Ia ngingi, la ngavikala lexe eni ꞌenaꞌei?” Xe Pita muavuti, la mukolinu aloxo ꞌo, “Nini ne, nini Kalisito ane Lataua mupalusine neneꞌe no lia ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Xe Iesu muavuti, la muvikalaneꞌi pekiaꞌu sou iaꞌaloiꞌa ta mitema no anu mamu. ");
INSERT INTO ata_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mukalu, la Iesu muvikalaneꞌi la aloxo, “Ulai iliꞌi, la Itema ꞌOlu ne utavule navunavu piena misevile mo ta tatila iloꞌa ta tatila noxiꞌa ta ailiꞌi mo ta mitema sou lapuloto ixiu tumaliꞌau, la ivau usoli. Ia voxo tatalu ukalu, la Anu utulu.” ");
INSERT INTO ata_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xe muvikalaneꞌi aloxo ꞌo la, “Lexe evile umasaxa sou umulileli, la anu uxiunu tumalouu masaxa noxou, ia uneꞌe mo utavulenu tuꞌutuꞌumaxu no voxovoxo loxo eni atatavulenu ꞌo mo umulileli, mo usoli loxo eni asoli ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Xo itema ane tanuxu maulixu sou vasimolu, la uꞌoxovaunu mauli ane kaluxu uasi. Ia itema ane tanuxu maulixu sou vasimolu uasi, io uꞌitalonu uneꞌe noxilo, la anu unoꞌu mauli ane kaluxu uasi. ");
INSERT INTO ata_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mo lexe itema vile unoꞌu mimii latala sou lialia ꞌo ukalusi, ia uxovulaunu uleenu, la mimii sou lialia e anu unoꞌu ne, usuꞌulinu sou ulivunoxu maulixu a loxovaa? ");
INSERT INTO ata_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Xe itema ane umaela noxilo mo umaela sou uaꞌaloxu vaikala noxilo, la Itema ꞌOlu kalumo umaela noxou no anu voxo ane Anu ulivu uneꞌe no anu lamana noxou mo lamana noxou Momu iloꞌa ta angelo noxou. ");
INSERT INTO ata_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eni avikalangengi manina musuku aloxo ꞌo. Ta mitema seꞌi aneꞌi itutulu ꞌo ne, umomomo sou isoli uao, ia imaisou saxisaxilaꞌu noxou Lataua ne uxali.” ");
INSERT INTO ata_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ioxe, Iesu muvikalaneꞌi aloxo ne mukalu, io loxo voxo taꞌuve mo muxatele tatalu mukalu, la Anu munoꞌa Pita ilou Ioanesi mo Iakovo. La iloꞌa mitelai no laxaꞌilu vile teitexi sou ilinga ulai noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Anu Iesu ulilinga noxou Lataua sio, la vasimolu ne muxiu. Tokolomoxu kalumo ne, muxiu mo muxali mukea loxo leleꞌe lamixu. ");
INSERT INTO ata_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Xe ta molomolo noxou tatalu ne mimalei loxo ꞌo, la mimaisiꞌa Mosesi ilou Eliasi ");
INSERT INTO ata_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","mipalaꞌa mixali no anu lamana toxoxaꞌa mo mitulu no paꞌumolu Iesu sou iloꞌa mivivikala. Aneꞌi iloꞌa mivivikalasou soli noxou Iesu e asou lexe uxali noxou ne Ielusalemu loxo Lataua mumasaxa. ");
INSERT INTO ata_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita iloꞌa ta menexu ne, ieꞌi uvuvu manina. Ia no mine ieꞌi mukala, la mimaisiꞌa ta mitema tamei iloꞌa Iesu itutulu. ");
INSERT INTO ata_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","No mine ta tamei ne sou iꞌumesou Iesu, la Pita muavuti sou muvikala vaxa noxou Iesu aloxo ꞌo, “Tila, anu laixe noxinge lexe nenge taxolu ano ꞌo mo taꞌalaxu tani alelaxu tatalu. Nini sine vile xe Mosesi sou vile xe Eliasi sou vile.” (Pita muvikala aloxo ne, ia anu ulavusou lexe anu mulemolu mii maꞌia ne uasi.) ");
INSERT INTO ata_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Xe anu uvivikala sio, la tamuxala vile muneꞌe la muvausiꞌa iloꞌa mukalusi. La aneꞌi miꞌume. ");
INSERT INTO ata_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","La aneꞌi milomusou vaikala vile molu no nano no anu tamuxala muneꞌe aloxo ꞌo, “Eni ꞌalixeni mulu Anu ano ꞌo ne eni esosovosou. Ngingi ngalomu noxou.” ");
INSERT INTO ata_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Milomusou vaikala aloxo ne mukalu xe aneꞌi mimalei loxo ꞌo, la imaisou evile la uasi, ia Iesu anusisi ꞌa mututulu ne. Ta molomolo noxou tatalu ne, mimolo taneꞌiiou mii ane aneꞌi mimaisou ne. Mo no voxo ane ne, la iaꞌalou evile no anu uasi. ");
INSERT INTO ata_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Voxo vile mukalu, la aneꞌi iloꞌa meꞌa no laxaꞌilu ne miluꞌe. Miluꞌe, la ta mitema tavuꞌalo mixalisou Iesu. ");
INSERT INTO ata_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","La itema vile no nano no taiineꞌi ne, muꞌava mulai noxou Iesu aloxo ꞌo, “Itema sou ulosixe lavulavu, eni alinga pekiaꞌu ulai noxine lexe nini namaisou ꞌalixeni mulu ꞌo, xo anu ꞌalixeni soxu vilesisi anesi. ");
INSERT INTO ata_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ia ulee vile uꞌaisou, la uiauiauukaka avile mo vasimolu utotoꞌeke, la sou livilivixu uxali no anaxu. Mo ulee ane ne uvilaꞌisou vasimolu manina, ia uxexesou palea uasi. ");
INSERT INTO ata_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eni elingaiꞌa ta molomolo noxine lexe ikusau ulee ane ne, la aneꞌi imomomo uasi.” ");
INSERT INTO ata_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Xe Iesu muavuti la muvikalanu aloxo ꞌo, “Ngingi ta mitema sou ngamuxaxu tangengi noxou Lataua uasi! Tauu ie taꞌei ane sou eni axolu noxinge? Mo alaxu taꞌei ane sou eni atavulenu tuꞌutuꞌumaxu noxinge? Nganoꞌu molomolo ne uneꞌe noxilo.” ");
INSERT INTO ata_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Xe no mine molomolo ne umuamuaꞌi uneneꞌe noxou Iesu, la ulee masua ne mulovelixu muluꞌe no lialia mo vasimolu mutotoeke. Xe Iesu mumaisou aloxo ne, la Anu mukaitolonu ulee masua ne. La ulee masua muxexesou, io Anu mupamaulinu molomolo ne. Mukalu, la muitalonu mulivu noxou momu. ");
INSERT INTO ata_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","La ta mitema latala ne, mikuluke no anu xavi noxou Lataua. Aneꞌi latala mixavuxavutala piena no anu mimii latala e Iesu muꞌoxonu ne, la Anu muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Ngalomu laixe sou mii ane eni avikalangengixu ꞌo. Itema ꞌOlu ne, ta mitema iꞌitalonu no avoꞌa ta mitema.” ");
INSERT INTO ata_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ia aneꞌi ilavu lexe vaikala ane ne, laaxu a loxovaa uasi. Vaikala laaxu ne, mutalume noxiꞌa, la sou aneꞌi ilamana no anu uasi. Xe aneꞌi kalumo mimamaꞌu sou italiꞌisou sou ulamananixu vaikala ne laaxu noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iliꞌi, la ta molomolo noxou Iesu miavuti sou miꞌotosou anaxaꞌa sou lexe ꞌenaꞌei ane uxali tila noxiꞌa. ");
INSERT INTO ata_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu mulavusou xavutala noxiꞌa aloxo ne, la sou munoꞌu molomolo soxu vile kituꞌa muneꞌe mutulusou no paꞌumolu. ");
INSERT INTO ata_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mukalu, io muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “ꞌEnaꞌei ane lexe uxavutalaleli mo uꞌosasou unoꞌu molomolo vile kituꞌa loxo ꞌo no ualasilo, la anu ane ne uꞌosasou unoꞌilo. Xe ꞌenaꞌei ane lexe uꞌosasilo sou unoꞌilo, la anu ane ne uꞌosasou unoꞌu ane mupalusilo eneꞌe ꞌo. Xo ꞌenaꞌei ane uluꞌelaixu mo uxali kituꞌa no taiingengi ne, la anu uxali tila manina noxinge.” ");
INSERT INTO ata_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Xe Ioanesi muavuti, la muvikalanu Iesu aloxo ꞌo, “Tilasixe, nexi temaisou itema vile ukukusaiꞌa ta ulee ta masumasua no anu ualasine, la nexi tetovo sou temulesou. Xo anu vile noxinge nengeꞌa uasi.” ");
INSERT INTO ata_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Xe Iesu muavuti, la muvikalaneꞌi aloxo ꞌo, “Ngamulesou mamu, xo anu ane uapingenge uasi ne, anu noxinge ane.” ");
INSERT INTO ata_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ioxe, voxo sou Lataua unoꞌu Iesu utelailixu no opo loxotolo, a muxali ꞌalai mukalu, la Iesu xavutalau pekiaꞌusi lexe ulai ne Ielusalemu. ");
INSERT INTO ata_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","La sou Anu mupalusiꞌa ta mitema seꞌi miuli milai no tuala vile no xalee lia tila ne Samalia sou lexe imomosou mii seꞌi sou Iesu. ");
INSERT INTO ata_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ia ta tema tuala ne, iꞌosasou inoꞌu Iesu uasi. Xo Anu mumuamuaꞌi ne sou lexe ulai ne Ielusalemu mo. ");
INSERT INTO ata_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Xe ta molomolo tamei noxou e ualasiꞌa lexe Iakovo ilou Ioanesi mimaisou aloxo ne, la ilou mitaliꞌisou Iesu lexe, “Tilasixe, nemasaxa lexe nexi talinga noxou Lataua sou usuꞌanu navu uluꞌe mo uꞌelaxaꞌa ta mitema no tuala ano ꞌo?” ");
INSERT INTO ata_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ia Iesu muxiu vaxa noxiꞌa sou mukaitoloneꞌi ilou lexe uasi. ");
INSERT INTO ata_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mukalu, la sou aneꞌi mimuamuaꞌi milai no tuala vileli. ");
INSERT INTO ata_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aneꞌi iloꞌa mimuamuaꞌi no voteꞌi sio, la mitema vile muneꞌe muvikalanu Iesu lexe, “Lexe nini nalai no tuala neꞌei neꞌei ne, la eni amulinenisi.” ");
INSERT INTO ata_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","La Iesu muvikalanu aloxo ꞌo, “Ta aꞌaa ta vova ne, siꞌa taxa no ꞌa lialia sou iai no anu, mo ta ngiala kalumo ne, siꞌa iomu sou iai no anu. Ia Itema ꞌOlu ne, sou tani sou uai no anu uasi.” ");
INSERT INTO ata_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mukalu, la sou muvikalanu itema vile la aloxo ꞌo, “Naneꞌe mo namulileli.” Ia mitema ane ne, muvikalanu Iesu aloxo ꞌo, “Tila, tei sou amulineni la alai mo aꞌasixu mamilo o.” ");
INSERT INTO ata_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","La Iesu muvikalanu aloxo ꞌo, “Mamu. Laixe lexe ta tulanu e loxo misoisoli meꞌa iꞌasixu. Ia nini nalai mo naaꞌaloxu vaikala sou saxisaxilaꞌu noxou Lataua.” ");
INSERT INTO ata_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mukalu, la itema vile la muvikalanu Iesu aloxo ꞌo, “Tila, eni emasaxa lexe amulineni. Ia tei la alai mo aiooneꞌi ta milemileli o.” ");
INSERT INTO ata_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","La Iesu muvikalanu aloxo ꞌo, “Mitema vile utotou, io iou ulai iliꞌi, la mitema ane aloxo ne, umomomo sou uꞌoxonu xaixai sou saxisaxilaꞌu noxou Lataua uasi manina.” ");
INSERT INTO ata_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tila muvikalaneꞌi aloxo ne mukalu, xe iliꞌi la Anu musosovosiꞌa ta mitemau itemaxu tatalu mo mavulovexa vile mo tamei (72) la sou mupalusiꞌa tametamei sou lexe iulaxunu ilai no tuatuala ane lexe iliꞌi la Iesu ulai no anu. ");
INSERT INTO ata_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","La Anu muvikalaneꞌi aloxo ꞌo, “Xai ne lingamo mukalu, ia ta mitema sou iluvunu xai temanu ne, tavuꞌalo uasi. La sou ngalinga ulai noxou Tila e moosou xai ne, sou upalusiꞌa ta mitema sou ineꞌe iluvunu xaixu ne temanu. ");
INSERT INTO ata_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngalai! Eni apalusinge loxo ta sipsip ta ꞌiliꞌa e xavineꞌi uasi, ilai noxiꞌa ta aꞌaa ta vova e xavineꞌi musuku ne. ");
INSERT INTO ata_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngalai, la nganoꞌu tiva sou lamoli mo lakela xe ngataa siovesou tavaꞌinge mamu. Mo ngaxalisiꞌa ta mitema no voteꞌi, la ngasexelaxaꞌa mamu. ");
INSERT INTO ata_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Xe ngalai xe ngaꞌunalai no tani vile, la ngavikalaneꞌi ta moosou tani ne tei lexe, ‘Opoo seꞌisisi noxou Lataua uxolu noxinge.’ ");
INSERT INTO ata_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ia lexe itema vile sou opo seꞌisisi a uxolu no tani ne, la vaikala noxinge sou opo seꞌisisi ne uluꞌe noxou. Ia lexe uasi, la anu ulivu uneꞌe noxinge. ");
INSERT INTO ata_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Xe ngaꞌunalai no tani ne, la ngaxolu anesi mo ngaꞌani mo ngaie mimii ane aneꞌi iitingenge ne. Xo ta mitema sou xaixai ne, aneꞌi inoꞌu lakoli sou xaixai e aneꞌi iꞌoxonu ne. Ia mamu sou ngavaxa nganeꞌe no tatani. ");
INSERT INTO ata_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Xe no mine ngingi ngalai ngaꞌunalai no tuala vile xe aneꞌi ta mitema no tuala ane ne iꞌosa sou inoꞌinge, la ngaꞌou mii maꞌia ane aneꞌi ilosinge ne. ");
INSERT INTO ata_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mo ngapamaulineꞌi aneꞌi ane mipipiena no tuala ne mo ngavikalaneꞌi lexe, ‘Saxisaxilaꞌu noxou Lataua a muxali ꞌalai mukalu.’ ");
INSERT INTO ata_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ia lexe ngingi ngalai ngaꞌunalai no tuala vile, io ta mitema no tuala ane ne iꞌosa sou inoꞌinge uasi, la ngaꞌunalai ngatulu no voteꞌi, io ngavikala lexe, ");
INSERT INTO ata_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Lialia sou tualasinge e mutei sou tavaꞌixe loxoꞌu ꞌo ꞌa, tapaxelenu uvaxasinge ne, mo sou ngingi ngalavu lexe Lataua ulosinge navunavu sou ꞌilixo ane ngingi ngeꞌoxonu ne. Ia ngingi ngalavu laixe lexe saxisaxilaꞌu noxou Lataua a muxali ꞌalai mukalu.’ ");
INSERT INTO ata_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Io eni avikalangengi lexe tuꞌutuꞌumaxu ane uxali noxiꞌa no tuala ane ne, anu uaꞌulixu tuꞌutuꞌumaxu ane muxali noxiꞌa ta Sodomu. ");
INSERT INTO ata_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Eni talelixaꞌa ta Korasini mo ta Vetesaida! Xo lexe eni aꞌoxonu sosovo noxilo e eni eꞌoxonu noxinge ꞌo noxiꞌa ta Taia iloꞌa ta Saidoni, la aneꞌi mitaa tokolomo sou tama mo miꞌuloxu kaso sou mimaxaꞌa lexe aneꞌi mixiu oponeꞌi mukalu. ");
INSERT INTO ata_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ia no voxo ane Lataua utulusiꞌa ta mitema no anu vaivaikala, la tuꞌutuꞌumaxu ane uxali noxiꞌa ta Korasini iloꞌa ta Vetesaida ne, anu uaꞌulixu tuꞌutuꞌumaxu noxiꞌa ta Taia iloꞌa ta Saidoni. ");
INSERT INTO ata_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Xe ta Kapenaumu ne, Lataua utelailixaꞌa teitexi no loxotolo? Uasi, aneꞌi iluꞌelai no tualasiꞌa ta mitema aneꞌi ane misoisoli. ");
INSERT INTO ata_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ia ꞌenaꞌei ane ulomusou vaikala noxinge, la anu ulomusou vaikala noxilo kalumo. Xe ꞌenaꞌei ane uxiu tumalouinge, la anu uxiu tumalouilo kalumo. Xe ꞌenaꞌei ane uxiu tumalouilo, la anu uxiu tumalouu anu ane mupalusilo eneꞌe ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aneꞌi itemaxu tatalu mo mavulovexa vile mo tamei (72) ne, milai mixaxai loxo Iesu mupalusiꞌa ne. Xe milivu mineꞌe, la miꞌosa manina. La mivikalanu Iesu aloxo ꞌo, “Tilasixe, telai xe tekusaiꞌa ta ulee masumasua no anu ualasine, la aneꞌi milomunexesi mo miꞌumeꞌume.” ");
INSERT INTO ata_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","La Iesu muvikala mulai noxiꞌa aloxo ꞌo, “Eni emaisou Satani mulapau molu no opo loxotolo muluꞌe loxo leleꞌe mulami. ");
INSERT INTO ata_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ia eni elosinge xavi ne mumomomo sou ngingi ngamaloxoꞌa ta sinana veveeni mo ta tanga mo ngauaulixu xavi noxou uluamengi. Ia mii vile umomomo sou uꞌoxo masuangengi uasi. ");
INSERT INTO ata_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ia ngingi ngaꞌoxo aloxo ne, io ngaꞌosa lexe ta ulee ta masumasua ilomungenge uasi, ia ngaꞌosasi lexe ualasinge a mikaukavunu muai no anu lavuku noxou Lataua no opo loxotolo.” ");
INSERT INTO ata_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","No anu voxo ngiou ane ne, la Uleenu Tavuna muꞌoxonu Iesu muꞌosa la muvikala aloxo ꞌo, “Eni aꞌitinu nini Mamilo ualasine, nini Tila sou nasaxilaꞌu mimii latala mukalusi no opo loxotolo mo lialia kalumo. Xo nini netalumeu xavi noxine noxiꞌa ta mitema sou xavutala laixe mo ta mitema sou lavulavu, ia nepalaꞌanixu noxiꞌa ta molomolo ta kitukituꞌa e iꞌa lavulavu uasi. Xo Mamilo, nini nemasaxa lexe naꞌoxonu aloxo nesi. ");
INSERT INTO ata_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mamilo muꞌitalonu mimii latala mukalusi muneꞌe noxilo mo evile ulavusou lexe ꞌOlu ne Anu ꞌenaꞌei ane uasi, Momusi a mulavusou. Xe evile ulavusou lexe Momu ne Anu ꞌenaꞌei ane uasi, ia ꞌOlusi a mulavusou. Mo aneꞌi ane ꞌOlu musosovosiꞌasi ne, ꞌOlu mupalaꞌalixu Momu noxiꞌa.” ");
INSERT INTO ata_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iesu muvikalaneꞌi aloxo ne mukalu, la sou muxiu mulai noxiꞌa ta molomolo noxou sou muvikalaneꞌi aneꞌisisi aloxo ꞌo, “Lataua ualusiꞌa aneꞌi ane imaisou mii ane ngingi ngamaisou ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Xo Eni avikalangengi lexe ta mitema sou palomatana tavuꞌalo iloꞌa ta tatananu tuatuala mimasaxa lexe imaisou mo ilomusou mii ane ngingi ngemaisou mo ngelomusou ꞌo, ia aneꞌi imaisou mo ilomusou uasi.” ");
INSERT INTO ata_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","No voxo vile, la itema vile ane mulavusou lapuloto noxou Mosesi muavuti mutulu sou mutovo Iesu la mutaliꞌisou aloxo ꞌo, “Itema sou ulosixe lavulavu, eni aꞌoxonu mii maꞌia manina, la sou eni anoꞌu mauli ane kaluxu uasi?” ");
INSERT INTO ata_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","La Iesu mukolinu taliꞌi noxou ne aloxo ꞌo, “Mii maꞌia ane aneꞌi mikaukavunu no anu lapuloto noxou Mosesi? Nini neitisou, la nelamana no anu a loxovaa?” ");
INSERT INTO ata_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","La sou anu mukolinu aloxo ꞌo, “‘Ngingi ngamasaxau IAUE Lataua noxinge no anu tangengi mo no anu uleengengi mo no anu xavingengi mo no anu xavutalamengi ukalusi.’ Mo ‘Ngamasaxaiꞌa ta menexinge aloxo ngingi ngemasaxainge la.’” ");
INSERT INTO ata_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Itema ne mukolinu aloxo ne, la Iesu muvikalanu lexe, “Nekolinu ne mulapu. Naꞌoxo aloxo ne, la sou nini nanoꞌu mauli ane kaluxu uasi ne.” ");
INSERT INTO ata_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ia anu mumasaxa sou umaxaꞌu lexe taliꞌi noxou ne mulapu manina, la sou mutaliꞌisou Iesu aloxo ꞌo la, “Ta menexilo ne, aneꞌi ta ꞌei manina?” ");
INSERT INTO ata_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","La Iesu mukolinu no anu vaikala tovolaꞌi vile aloxo ꞌo, “No voxo vile, la itema vile molu ne Ielusalemu mutelo ne Ieriko. La muxalisiꞌa ta mitema sou pakali no voteꞌi. La mitaxusou miumiu, io mivau xoo mole anu musolilulu muai. Ia aneꞌi miꞌume milai. ");
INSERT INTO ata_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iliꞌi no anu voxo ngiou ane ne, la ailiꞌi vile mumulinu voteꞌi ane ne mutelo. Xe mumaisou mitema ne muai no voteꞌi ne, la mupolopepeenu no voteꞌi paꞌumolu xalee vile mo mulai. ");
INSERT INTO ata_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aloxo ne la, la Levi vile kalumo muneꞌe muxali no voteꞌi ngiou ane ne, la anu mumaisou mitema ane ne. Ia anu kalumo mupolopepeenu no voteꞌi paꞌumolu xalee vile mo mulai. ");
INSERT INTO ata_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ioxe, itema vile sie Samalia mumuamuaꞌi muneꞌe muxali noxou mitema ne xe mumaisou, la tanuxu manina. ");
INSERT INTO ata_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","La sou anu mulai noxou sou muꞌoxo lamalasile sou xalexalevinu ka muisinu. Mukalu, la anu mutelonu no anu donki noxou ka musaxa mulai no tani sou aiai sou itema sou usaxilaꞌu tani ne lexe usaxilaꞌu. ");
INSERT INTO ata_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Xe no voxo ane loxo neꞌiela, la anu mulosou itema e usaxilaꞌu tani sou aiai ne Denalia tamei, io muvikalanu aloxo ꞌo, ‘Nasaxilaꞌu mitema ano ꞌo, xe lexe napaipalunu lamolimeni moseꞌi la, sou nasaxilaꞌu no anu, la no voxo ane eni alivu aneꞌe, la eni akolinu ulivu noxine.’” ");
INSERT INTO ata_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu mutovolaꞌi no anu aꞌalo aloxo ne mukalu, la sou mutaliꞌisou mitema ane mulavu manina no anu lapuloto noxou Mosesi ne aloxo ꞌo, “Nini nexavutala lexe ꞌenaꞌei noxiꞌa aneꞌi tatalu ne, muxali loxo menexu mitema ane ta mitema sou pakali mivau ne?” ");
INSERT INTO ata_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","La anu mukolinu aloxo ꞌo, “Mitema ane anu tanuxu mo musuꞌulinu.” Xe, la sou Iesu muvikalanu lexe, “Nalai mo naꞌoxonu aloxo mitema ne muꞌoxonu ne.” ");
INSERT INTO ata_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu iloꞌa ta molomolo noxou mimuamuaꞌi milai, la mixali no tuala vile ane sema vile ualasie lexe Mata ixoxolu no anu. La ane miꞌavalou Iesu sou mulai muꞌunalai no taasie. ");
INSERT INTO ata_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iesu muꞌunalai, la Mata vimoe sema vile ualasie lexe Malia ne, mineꞌe mixolu no lia no tavaꞌu sou milomusou vaivaikala noxou. ");
INSERT INTO ata_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ia, Mata ne tane uxoo no anu xaixai tavuꞌalo sou ilalaxi laꞌilali. La sou ane mineꞌe mivikalanu Iesu aloxo ꞌo, “Tila, nelavu lexe enisisi axaxai sou alalaxi laꞌilali uasi? Io, vivilo miꞌumesilo mo ane a ixoxolu sou ilolomu noxine, ia isuꞌulileli uasi. La sou navikalane lexe ane ineꞌe mo isuꞌulileli!” ");
INSERT INTO ata_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ia Tila mukoli vaikalaie aloxo ꞌo, “Mata, Mata, nini taneni uoxoxu mo nexavutala piena no anu mimii tapiena musuku. ");
INSERT INTO ata_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ia laixe lexe nini naxavutalanu mii vilesisi ane sou nini naꞌoxonu. Malia ane misosovosou mii ane tila no anu xaixai ane nini naxavutala piena no anu ne. Mo umomomo sou nenge taxexeenu mii ane ne noxie uasi.” ");
INSERT INTO ata_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","No voxo vile, la Iesu mulai no tuala vile sou mulinga mulai noxou Lataua. Mulinga mukalu, la vile noxiꞌa ta molomolo noxou muvikalanu aloxo ꞌo, “Tilasixe, nexi temasaxa lexe nini nalosiexixu ꞌilixo sou talinga ulai noxou Lataua loxo Ioanesi mulosieixaꞌa ta molomolo noxou.” ");
INSERT INTO ata_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","La sou Iesu muvikalaneꞌi aloxo ꞌo, “No mine ngingi ngalinga ulai noxou Lataua, la ngingi ngavikala aloxo ꞌo, ‘Mamixe, nexi taꞌitinu ualasine mo talinga lexe saxisaxilaꞌu noxine uneꞌe. ");
INSERT INTO ata_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Naitinexe laꞌilali sou voxovoxo ukalusi. ");
INSERT INTO ata_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mo naxiu tumalineu ꞌiliꞌilixo masumasua noxixe, xo nexi kalumo taxiu tumalixeu ꞌiliꞌilixo masumasua noxiꞌa aneꞌi ane latala e iꞌoxonu ꞌiliꞌilixo masumasua uneꞌe noxixe. Mo mamu sou nini naolenexi no anu tovotovo.’” ");
INSERT INTO ata_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iesu muvikalaneꞌi la aloxo ꞌo, “Lexe itema vile no taiingengei ne, menexu vile a uxoxolu. Ia no ꞌolovoxo lixinu manina, la mulai noxou menexu sou mulinga aloxo ꞌo, ‘Menexilo, eni emasaxau veleti tatalu. ");
INSERT INTO ata_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xo tulaleli vile mumuamuaꞌi xoo mole anu a muneꞌe muxali noxilo, ia eni xenixo laꞌilali sou alosou uasi.’ ");
INSERT INTO ata_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ia lexe menexu ane uxoxolu no nano no tani ne, ukolinu vaikalau aloxo ꞌo, ‘Namoloꞌinasilo uasi. Xo nexi tetatu mo tesilikoo aitenga mukalu, mo nexi noxiꞌa ta ꞌalixe teai no luu mukalu. La sou eni amomomo sou atulu mo alosine mii vile uasi.’ ");
INSERT INTO ata_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Anu mulavusi lexe anu menexu vile, ia utulu mo ulosou mii vile uasi. Ia eni avikalangengi lexe anu ulinga pekiaꞌu sio ulai noxou, la anu uavuti ka ulosou mii maꞌia ane anu ulingau. ");
INSERT INTO ata_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","La sou eni avikalangengi aloxo ꞌo. Ngalinga ulai noxou Lataua, la Anu ulosinge. Mo ngakakamuli mii, la sou ngaxalisou. Xe ngapolopolo no aitenga, la Lataua ukisiinu aitenga. ");
INSERT INTO ata_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Xo itema ane ulingau mii vile, la anu unoꞌu. Mo itema ane ukakamuli mii vile, la anu uxalisou. Xe itema ane upolopolo no aitenga, la aitenga ukisi noxou. ");
INSERT INTO ata_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Loxovaa? Ngingi e ta ꞌilinge, io ilingau sinana vile noxinge ngingi ta mamiꞌa, la ngingi ngalosiꞌa sinana veveeni? Uasi. ");
INSERT INTO ata_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mo lexe ta ꞌilinge ilingau atolu vile noxinge, la ngalosiꞌa tanga vile? Uasi. ");
INSERT INTO ata_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Xo ngingi ne ta masua, ia ngelavusou ngalosiꞌa ta ꞌilinge mimii lailaixesi. Ia Maminge lailaixe e uxolu no opo loxotolo ne, uꞌoxo aloxo ne, ia Anu muliuli manina sou ulosiꞌa ta mitema e ilingau Uleenu Tavuna noxou!” ");
INSERT INTO ata_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iliꞌi, la Iesu ukukusau uleenu vile masua sou uꞌoxo ta mitema anaxaꞌa utomu ne muxolu noxou itema vile. Xe Anu mukusau mukalu, la itema ane anaxu mutomu ne, anaxu papaxe sou uvivikala. La ta mitema mimaisou aloxo ne, la mikuluke. ");
INSERT INTO ata_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ia moseꞌi noxiꞌa ta mitema ne, mivikala aloxo ꞌo Anu ukukusaiꞌa ta ulee ta masumasua ne no anu xavi noxou Velesevulu e anu tila noxiꞌa ta ulee ta masumasua. ");
INSERT INTO ata_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Xe moseꞌi mitovonu sou lexe uꞌoxonu sosovo vile no opo loxotolo sou umaxaꞌu lexe Anu uxaxai no anu xavi noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iesu mulavusou xavutalaiꞌa aloxo ne, la sou muvikalaneꞌi aloxo ꞌo, “Tuala vile ta mitema sou ikalikalipalaneꞌi sou iꞌotoꞌoto ngatongatoꞌo noxiꞌa, la tuala ane ne, ta moosou ipaxele mo tuala ne usivu. Mo lexe ta temanu tani vile kalumo ne, ikalipalaneꞌi ngatongatoꞌo sou iꞌotoꞌoto noxiꞌa, la ta temanu tani ane ne ipaxele sou tani ne. ");
INSERT INTO ata_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mo lexe Satani iloꞌa ta mitemau ikalipalaneꞌi ngatongatoꞌo sou iꞌotoꞌoto noxiꞌa, la aneꞌi xavineꞌi sou itulu uasi. Eni avikalangengi aloxo ne, xo ngingi ngevikala lexe eni akukusaiꞌa ta ulee ta masumasua no anu xavi noxou Velesevulu. ");
INSERT INTO ata_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ioxe, lexe eni akukusaiꞌa ta ulee ta masumasua no anu xavi noxou Velesevulu, la sou no anu xavi noxou ꞌenaꞌei ane ta mitemamengi ikukusaiꞌa no anu ne? Xavi ane ta mitemamengi ixaxai no anu ne, uvikalangengi lexe vaikalamengi ne ulapu uasi. ");
INSERT INTO ata_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ia lexe eni akukusaiꞌa ta ulee ta masumasua no anu xavi no avolu Lataua, la ngingi ngelavusou lexe saxisaxilaꞌu noxou Lataua ne a muneꞌe noxinge ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","La sou lexe itema vile xaviinu munoꞌu miumiu latala sou ꞌotoꞌoto, sou usaxilaꞌu taasou, la evile unoꞌu miumiu uasi, uai laixesi. ");
INSERT INTO ata_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ia lexe itema vile anu xaviinu muuaulixu xavi noxou itema ane ne, uneꞌe uꞌalivulanu mo uaꞌulixu, la uꞌumenu misomisou ꞌotoꞌoto noxou e anu usosoa no anu xe mimii sou uvelunu noxiꞌa ta menexu. ");
INSERT INTO ata_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Io, itema ane uxolu noxilo uasi, la anu uꞌapixo, xe itema ane nexi noxou tapita uasi, la anu umolo vilaꞌisilo. ");
INSERT INTO ata_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Xe no mine ulee vile masua muxolu noxou itema vile, ia ulaa la anu uxixaoxao no tani e lexa no anu uasi sou ukakamulinu tani e anu umaꞌila no anu. Xe uxalisou uasi, la uvikala lexe, ‘Eni alivu no tani eni exolu no anu tei.’ ");
INSERT INTO ata_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Anu mulivu muneꞌe no tani ane ne, la mumaisou lexe aneꞌi misilapa tani laixe mo mitaꞌolunu mimii sou tani no tanitanixu laixe. ");
INSERT INTO ata_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ioxe, mumaisou aloxo ne, la mulai sou muꞌavaliꞌa ta ulee ta masumasua muxatele tamei e aneꞌi mimasua manina noxou. Mukalu, la sou aneꞌi iloꞌa ilai iꞌunalai no tani ne mo ixolu avile ane. La sou xoluxoluxu itema ane ne, uxali masua no ꞌa xoluxoluxu ane tei.” ");
INSERT INTO ata_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu uao Anu uvivikala sio, io sema vile no taiineꞌi ne miꞌava mulai noxou aloxo ꞌo, “Lataua ualusie nenine e mivoꞌoneni mo misusuneni.” ");
INSERT INTO ata_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","La Anu muvikalane aloxo ꞌo, “Uasi, ia Lataua ualusiꞌa aneꞌi ane ilomusou vaikala noxou mo imulinu.” ");
INSERT INTO ata_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ta mitema laoluxaꞌa musuku ixali ipita noxou Iesu sio, la Anu muvikalaneꞌi aloxo ꞌo, “Ta mitema vaimomo ꞌo, aneꞌi ta mitema ta masumasua. Xo aneꞌi imasaxa lexe imaisou sosovo vile silo lexe Lataua mupalusilo a eneꞌe ꞌo. Ia umomomo sou aneꞌi imaisou sosovo vile uasi. Sosovo vilesisi anu a noxou Iona nesi. ");
INSERT INTO ata_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Xo aloxo Iona ne, anu sosovo noxiꞌa ta Ninive, la Itema ꞌOlu kalumo ne Anu sosovo noxiꞌa ta mitema vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No voxo ane sou Lataua utulusiꞌa ta mitema no anu vaivaikala, la sema vile ane tatananu tuala ne Seva iloꞌa ta mitema ane vaimomo ꞌo, itulu. La ane itelo vaikala noxiꞌa ta mitema sou vaimomo ꞌo. Xo ane mele no lia paꞌumolu nopaxa, ia milutu mineꞌe sou milomu no anu vaikala sou xavutala laixe noxou Solomoni. Ia vaimomo ꞌo ne, itema vile Anu mutila noxou Solomoni a ututulu ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Xe no voxo ane ne, la ta mitema sie Ninive kalumo iavuti itulu sou itelo vaikala noxiꞌa ta mitema sou vaimomo ꞌo. Xo aneꞌi milomusou Iona muaꞌalo mulai noxiꞌa, la aneꞌi mixiu oponeꞌi. Ia vaimomo ꞌo ne, itema vile Anu mutila noxou Iona a ututulu ꞌo.” ");
INSERT INTO ata_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iesu musolonu vaikala noxou aloxo ꞌo la, “Itema vile uꞌelaxu telu, ka utalumeu no nano no kaveutu kituꞌa uasi, mo utulu pupunisou uasi. Ia utulusou teitexi no valovalo, mo sou ta mitema ane iꞌuna no tani ne, la imaisou lamana ane ne. ");
INSERT INTO ata_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngingi iengi ne, anu telu sou vasimenge. Xo lexe iengi ne laixe, la anu ulosinge lamana. Ia lexe iengi ne masua, la anu ulosinge isivoxosi. ");
INSERT INTO ata_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","La sou ngasaxilaꞌinge laixe, mo sou lamana no nano no tangengi ne, uxali isivoxo mamu. ");
INSERT INTO ata_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aloxo ne, la sou lexe iengi laixe xe ulosinge lamana, io paꞌusou isivoxo uasi, la anu lamana usavelesi loxo telu ukaasinge.” ");
INSERT INTO ata_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu muvikalaneꞌi ta mitema ne aloxo ne mukalu, la Palisaio vile muꞌavalou sou lexe ilou ilai no taasou sou iꞌani. La sou Iesu mulai muꞌunalai no taasou, la muxolu no luusou laꞌilali sou lexe uꞌani. ");
INSERT INTO ata_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ia Palisaio ne, mumaisou Iesu mine uꞌuinu avolu tei ka uꞌani uasi, la mukuluke. ");
INSERT INTO ata_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tila mumaisou aloxo ne, la sou muvikalanu aloxo ꞌo, “Manina lexe ngingi ta Palisaio ngaꞌuinu paku ilou latotope, la ngaꞌuinu no alesi. Ia no nano no anu paku ilou latotope ne, ꞌiliꞌilixo sou isuisu mo ꞌiliꞌilixo sou xavutala masumasua a muꞌanaꞌana no nano no anu ne. ");
INSERT INTO ata_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngingi ta mitema sou xovulaulau! Anu manina lexe itema ane uꞌoxonu mimii vasimolu no ale, la anu uꞌoxonu no nano kalumo. ");
INSERT INTO ata_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ia ngalosiꞌa mimii ane uai no nano no paku ilou latotope ne ulai noxiꞌa ta mitema ane xaꞌa laꞌilali uasi. Ngaꞌoxo aloxo ne, la sou mingemingenge latala ne, uxali malemalenga. ");
INSERT INTO ata_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ngingi ta Palisaio ne, iliꞌi la Lataua ulosinge navunavu. Xo kamakamakala latala e tumaꞌu lailaixe ukalusi no xaingenge ne, ngingi ngelavusou sou ngakalipalanu la ngalivunoxu mavulovexasou ulai noxou Lataua. Ia ngingi ngexolu vaꞌaxu no anu ꞌiliꞌilixo lailaixe ane Lataua mumasaxau ulai noxiꞌa ta menexinge mo ngexolu vaꞌaxu no anu ꞌilixo sou ngamasaxau Lataua. Ia emasaxa manina lexe ngingi ngaꞌoxonu ꞌiliꞌilixo ane ne, mo sou tangengi vulusiou lapuloto sou ngalosou mavulovexasou mimii ulai noxou Lataua uasi. ");
INSERT INTO ata_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mo ngingi ta Palisaio ne, iliꞌi la Lataua ulosinge navunavu. Xo ngingi ngamasaxa lexe ngaxolu no puloulou ane lailaixesi uuli no nano no taasou lalotu noxiꞌa ta Iutaia, mo ngamasaxa lexe ta mitema ixalisinge no tilovolovo la itoxongengi xe isexelangenge. ");
INSERT INTO ata_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mo ngingi ta Palisaio ne, iliꞌi la Lataua ulosinge navunavu. Xo ngingi loxo lousiꞌa ta mitema e mutalume, la ta mitema imaisou uasi la imuamuaꞌi teitexi no anu.” ");
INSERT INTO ata_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ioxe, itema vile noxiꞌa ta mitema ane milavusou lapuloto noxou Mosesi manina mulomu aloxo ne, la mukolinu Iesu aloxo ꞌo, “Itema sou ulosixe lavulavu, nini nevikalasiꞌa ta Palisaio aloxo ne, la nini netaloxolinexe kalumo.” ");
INSERT INTO ata_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","La Iesu muvikalanu aloxo ꞌo, “Ngingi ta mitema ane ngelavusou lapuloto noxou Mosesi manina kalumo ne, iliꞌi la Lataua ulosinge navunavu. Xo ngingi ngalosiꞌa ta mitema tavala ane aneꞌi imomomo sou itavule ilutunoxu uasi. Ia ngingi ngamasaxa sou ngasuꞌulineꞌi mo ngakasi vaxa no anu tavala ne sevile uasi. ");
INSERT INTO ata_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mo ngingi ne, iliꞌi la Lataua ulosinge navunavu. Xo ngingi ngapaipounu lousiꞌa ta mitema sou palomatana e ta xaixasinge iloꞌa ta ꞌiluꞌilusungengi miveꞌa tatei. ");
INSERT INTO ata_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","No anu ꞌilixo ane ne, la ngingi ngevikala manina xe ngemaxaꞌinge kalumo lexe ta xaixasinge iloꞌa ta ꞌiluꞌilusungengi miveꞌa ta mitema sou palomatana ane ngingi ngapapaipounu lousiꞌa ne. ");
INSERT INTO ata_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","La sou Lataua mulemolu no anu xavutala laixe noxou aloxo ꞌo, ‘Eni apalusiꞌa ta mitema sou palomatana iloꞌa ta mitema sou xaixaixeni ilai noxiꞌa ta mitema, la moseꞌi noxiꞌa ne aneꞌi iveꞌa xe moseꞌi noxiꞌa ne aneꞌi iꞌoxo masuaneꞌi.’ ");
INSERT INTO ata_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","La sou Lataua ulosiꞌa ta mitema aneꞌi ane vaimomo ꞌo navunavu, xo aneꞌi miveꞌa ta mitema sou palomatana mukalusi musoko no anu voxo ane Lataua mukoinu loxotolo ilou lia mo muneꞌe mutalo vaimomo ꞌo. ");
INSERT INTO ata_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Musoko sou miveꞌa ta mitema sou palomatana ne, musoko noxou Aveli muneꞌe muxali noxou Sakalia. Aneꞌi mivau Sakalia no nixi no anu valovalo sou iꞌelaxaꞌa ta sipsip no anu xe tani tila noxou Lataua. Ani manina, Lataua ulosiꞌa ta mitema sou vaimomo ꞌo navunavu. ");
INSERT INTO ata_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ngingi ta mitema ane ngelavu manina no anu lapuloto noxou Mosesi, iliꞌi la Lataua ulosinge navunavu. Xo ngingi ngalavusou sou ngataluxu voteꞌi sou lavulavu noxou Lataua, la ta mitema ilavusou uasi. Mo ngingi kalumo ne, ngalavu no anu uasi, mo ngingi ngeꞌapixaꞌa ta mitema ane imasaxa lexe inoꞌu lavulavu ane ne.” ");
INSERT INTO ata_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu muvikala mukalu, xe mulaa muuatu. La ta mitema sou lapuloto iloꞌa ta Palisaio laꞌiaxaꞌau manina, la sou misoko sou mitalitaliꞌisou, ");
INSERT INTO ata_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sou lexe Anu ususu no anu taliꞌi noxiꞌa vile, la sou aneꞌi itetelisou. ");
INSERT INTO ata_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","No mine Iesu uvivikalaneꞌi aloxo ne, la ta mitema tavuꞌalo mineꞌe mipita noxou la tani mutomu manina mo tanixaꞌa uasi. La sou aneꞌi mimalomaloxou tavaꞌa ngatongatoꞌo. La Iesu muavuti sou mupelaꞌa ta molomolo noxou aloxo ꞌo, “Ngingi ngasaxilaꞌinge laixe no anu ꞌilixo sou kalavoi noxiꞌa ta Palisaio, xo ꞌilixo noxiꞌa ne uvasainge. ");
INSERT INTO ata_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mii maꞌia ane mivausou ne, ulai iliꞌi la upalaꞌa no taatexa. Xe mii maꞌia ane mutalume ne, ulai iliꞌi la aneꞌi ilavusou. ");
INSERT INTO ata_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","La sou mii maꞌia ane ngingi ngalemolu no isivoxo ne, ulai la ta mitema ilomusou no aso. Xe mii maꞌia ane ngingi ngamunumunusou no nano no tani tanu ne, ulai la ta mitema itulu teitexi no tani laxaꞌu sou iaꞌaloxu. ");
INSERT INTO ata_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ta menexilo, eni avikalangengi aloxo ꞌo. Mamu sou ngaꞌumeꞌa aneꞌi ane ivau vasimenge mo usoli, ia iliꞌi la imomomo sou iꞌoxonu mii vile la noxinge uasisi. ");
INSERT INTO ata_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ia eni alosiengixu ꞌenaꞌei ane ngingi ngaꞌumolu. Ngaꞌumolu itema ane Anu xaviinu sou uvau vasimenge usoli mo uleanu uleengengi ulai no taxa sou navunavu. Eni avikalangengi lexe ngaꞌumolu itema ane ne. ");
INSERT INTO ata_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ngingi ngelavusou lexe ta mitema ilavusou ilotoneꞌi ta ngiala ta kitukituꞌa taꞌuve no anu Asarioni tamei. Ia Lataua iou siꞌisiꞌa ta ngiala ta kitukituꞌa ane ne uasi. ");
INSERT INTO ata_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xe kalumo Lataua mulavusou sou uitisou kisinge laxusou. La sou ngingi ngaꞌume mamu. Xo ngingi ne, ngatiatila noxiꞌa ta ngiala ta kitukituꞌa moso ne. ");
INSERT INTO ata_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","La sou eni avikalangengi aloxo ꞌo. ꞌEnaꞌei ane uvikala lexe anu ulavusilo no ieꞌi ta mitema, la Itema ꞌOlu kalumo uvikala lexe Anu ulavusou no ieꞌi ta angelo noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ia, ꞌenaꞌei ane uvikala lexe anu ulavusilo uasi no ieꞌi ta mitema, la Itema ꞌOlu kalumo uvikala lexe Anu ulavusou no ieꞌi ta angelo noxou Lataua uasi. ");
INSERT INTO ata_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Xe ꞌenaꞌei ane uvikala masua ulai noxou Itema ꞌOlu, la Lataua uxiu tumalouu vaikala masua noxou ne. Ia ꞌenaꞌei ane uvikala masua ulai noxou Uleenu Tavuna, la umomomo sou Lataua uxiu tumalouu vaikala masua noxou ne uasi. ");
INSERT INTO ata_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Xe lexe ta mitema ilailingenge no taasou lalotu noxiꞌa ta Iutaia, xe itulusinge no ieꞌi ta mitema sou isaxilaꞌu tuatuala, la ngaxavutala piena sou ngaꞌoxo latolosinge a loxovaa mo mii maꞌia ane ngingi ngalemo ulai noxiꞌa mamu. ");
INSERT INTO ata_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Xo no mine ngingi ngatulu sou ngavikala ulai noxiꞌa, la Uleenu Tavuna molu ulosiengixu vaikala maꞌia ane ngingi ngalemolu noxiꞌa ne.” ");
INSERT INTO ata_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xe vile noxiꞌa ta mitema tavuꞌalo ne, muavuti la muvikalanu Iesu aloxo ꞌo, “Itema sou ulosixe lavulavu. Mamixe a musoli ne, ia eni emasaxa lexe navikala vivilo mo uvelu mimii e mamixe musolisou ne mo ulosilo moseꞌi.” ");
INSERT INTO ata_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ia Iesu mukolinu aloxo ꞌo, “Ae, ꞌenaꞌei musosovosilo sou axali itema vile sou atulu no ꞌa vaikala sou no nixi noxinge nongou vivine ne?” ");
INSERT INTO ata_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","La Anu Iesu muvikalaneꞌi aloxo ꞌo, “Ngasaxilaꞌinge laixe! Xo loxo ꞌo io, iengi uisuisuxu mimii iouiou. Xo maulinenge a uxolu no anu mimemimengi ne uasi.” ");
INSERT INTO ata_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","La Anu muvikala tovolaꞌi vile noxiꞌa aloxo ꞌo, “Itema vile sou lavuluti ne, xaixu muneneꞌa muꞌoki. ");
INSERT INTO ata_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","La anu muxavutala aloxo ꞌo, ‘Eni aꞌoxo a loxovaa? Xo eni silo tani vile umomomo sou apitanu laꞌilalixo no anu uasi.’ ");
INSERT INTO ata_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","La muvikala aloxo ꞌo, ‘Mane, eni aꞌoxo aloxo ꞌo. Eni amamulonu tani kitukituꞌa sou laꞌilalixo mo atulusou apitanu tani ta tatilasi sou laꞌilalixo xe lavulutixeni. ");
INSERT INTO ata_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mo sou eni melo taleli uvikalaleli aloxo ꞌo, “Eni ne, mixomixo tavuꞌalo misevile manina. Umomomo sou uai no anu tauu ie tavuꞌalo. La sou eni amaꞌila laixe mo aꞌani mo aie mo axolu aꞌosaꞌosasi.” ’ ");
INSERT INTO ata_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ia Lataua muvikalanu aloxo ꞌo, ‘Kisine muxovulaulau manina! Vaimomo no ꞌolovoxo ꞌo si, la nini nasoli avile. La mixemixene ane nelalaxii muai no tani ne, ꞌenaꞌei unoꞌu ne?’ ");
INSERT INTO ata_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ꞌIlixo ane loxo ne, uxali noxiꞌa ta mitema ane ipitanu mimii sou no lia ꞌo. Ia no iou Lataua, la aneꞌi ta mitema vitanisi mo iꞌa lavuluti uasi.” ");
INSERT INTO ata_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iesu muvikalaneꞌi ta mitema mukalu, la sou muvikalaneꞌi ta molomolo noxou aloxo ꞌo, “Aloxo ne, la sou ngaxavutala piena no anu maulingenge mamu. Mo mamu sou ngavikala lexe, ‘Nenge taꞌou mii maꞌia xe tasakii mii maꞌia sou vasimenge?’ ");
INSERT INTO ata_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Xo maulinenge ne, anu mutila no anu laꞌilali xe vasimenge ne anu mutila no anu tokolomo. ");
INSERT INTO ata_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Loxo ngaxavutalaneꞌi ta ꞌola. Aneꞌi ilavusou itotou no xai mo imolo laꞌilali uasi. Kalumo aneꞌi siꞌa tani sou ipitanu laꞌilalixaꞌa no anu uasi. Ia Lataua molu ulosiꞌa laꞌilali. Io, ngingi ne, loxo ta ngiala uasi. Ngingi ngatatila manina musuku noxiꞌa mo ngauaulixaꞌa! ");
INSERT INTO ata_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ia lexe vile no nixi noxinge ne uxavutala piena sou maulixu uxolu maxuvee sevile, la anu umomomo sou molu usukunu maulixu ulai sevile la? Uasi manina. ");
INSERT INTO ata_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Lexe ngingi ngamomomo sou ngaꞌoxonu mii se ane kituꞌa ne uasi, la tavaꞌu loxovaa la sou ngaxavutala piena no anu mimii ukalusi la? ");
INSERT INTO ata_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngaxavutala lexe kungalo seseenu ne uleme a loxovaa? Anu uxaxaisou uꞌoxonu tokolomou uasi. Ia avikalangengi lexe Solomoni ne munoꞌu mimii lailaixe no lia ꞌo mukalusi, ia kungalo seseenu muuaulixu tokolomoxu ne. ");
INSERT INTO ata_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ia lexe Lataua utokolomo sese seseenu ane uleme vaimomo ꞌo xe neꞌiela la ta mitema ixotosou sou iꞌelaxu, la anu utokolomongengi laixe manina musuku uuaulixu sese seseenu ne. Ae, ngingi ta mitema ane ngeuaulixu ne, ngemulaxu tangengi noxou Lataua ne kituꞌasi. ");
INSERT INTO ata_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aloxo ne, la sou mamu sou ngingi ngaxavutala piena no anu mii maꞌia sou ngaꞌou mo ngaiexu. ");
INSERT INTO ata_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Xo ta mitema ane ilavusou Lataua uasi no lia ꞌo ne, aneꞌi ixavutala piena sou ikakamulinu mimii ane ne. Ia Maminge mulavusou lexe mimii ane ne, anu laixe sou ngingi nganoꞌu. ");
INSERT INTO ata_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","La sou laixe lexe ngingi ngakamulinu saxisaxilaꞌu noxou Lataua tei, la sou Anu ulosinge mimii ane ne. ");
INSERT INTO ata_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ngingi moosou e loxo ta sipsip laꞌoluxaꞌa sevile kituꞌa ne, ngaꞌume mamu. Xo Maminge muꞌosa lexe Anu ulosinge sou ngasaxilaꞌu tuala ane anu usaxilaꞌu. ");
INSERT INTO ata_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","La sou ngingi ngalosiꞌa ta mitema lavulutimengi sou ilotonu. Xe nganoꞌu lamolisou, la ngalosiꞌa ta mitema aneꞌi iꞌa lamoli uasi. Io nganoꞌu tiva sou lamoli ane ulavusou ukakaa uasi sou ngataa mimii lailaixe no anu, mo ngamulaxu teitexi no opo loxotolo e mimii ukukasou uasi. Xo no tuala ane ne, la ta mitema sou pakali ilai ꞌalai no anu uasi mo ta totoxae ixotosou uasi. ");
INSERT INTO ata_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Xo no tuala ane mimii lalaixe noxinge uai no anu ne, la tangengi a uxolu lai ne kalumo.” ");
INSERT INTO ata_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Iesu muvikalanu la aloxo ꞌo, “Ngasakiinu malomengi ataxu mo ngautupokoxu sou ngalalaxii sou xaixai mo ngaꞌelaxu telusinge ukaakaa loxo ta mitema ane ixomaiou tila noxiꞌa molu no anu laꞌilali tila sou taulaꞌi mine ulivu uneꞌe. No voxo ane anu uneꞌe xe upolopolo no aitenga, la aneꞌi ikisiinu aitenga noxou alaxu vilesisi. ");
INSERT INTO ata_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Anu laixe lexe tila noxiꞌa uneꞌe la uxalisiꞌa ta mitema sou xaixai noxou mine aneꞌi ixoxomaiou. Eni avikalangengi manina musuku. Anu molu usakiinu maloxu ataxu mo utupokoxu ka uvikalaneꞌi lexe ixolu no anu luu sou laꞌilali mo Anu molu ulosiꞌa laꞌilali. ");
INSERT INTO ata_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mo anu laixe lexe tila noxiꞌa uneꞌe, la uxalisiꞌa ta mitema sou xaixai noxou no ꞌolovoxo lixinu, uasi la no maxasesela mine aneꞌi ixoxomaiou. ");
INSERT INTO ata_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ia ngalavusou aloxo ꞌo. Lexe moosou tani ulavusou voxo ngiou ane itema sou pakali uneꞌe no anu, la anu umomomo sou upelemasaxanu itema sou pakali ne uꞌuna no taasou uasi. ");
INSERT INTO ata_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aloxo ne, la sou ngingi kalumo ngaxolu sou ngautitisi, xo Itema ꞌOlu uneꞌe no anu voxo ngiou ane ngingi ngaxavutala lexe Anu uneꞌe uasi.” ");
INSERT INTO ata_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita mulomu aloxo ne, la mutaliꞌisou Iesu aloxo ꞌo, “Tilasixe, nini nevikala tovolaꞌi uneꞌe noxixesi, uasi ulai noxiꞌa ta mitema ukalusi kalumo?” ");
INSERT INTO ata_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tila mukolinu aloxo ꞌo, “Ioxe, moosou tani muꞌitaloneꞌi ta mitema sou xaixai noxou no avolu itema vile noxou sou usaxilaꞌa. Ia anu itema ne, anu uvikala lexe uꞌoxonu mii vile, la anu uꞌoxonu manina mo uꞌoxonu laixe ukalusi. Anu ulosiꞌa ta mitema sou xaixai laꞌilalixaꞌa no aso iou e moosou tani musosovosou, la ꞌenaꞌei ane itema laixe sou uꞌoxonu xaxai ane loxo ne? ");
INSERT INTO ata_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Anu laixe lexe moosou tani ulivu uneꞌe, la uxalisou itema sou xaixai noxou ne uꞌoxo xaixai aloxo ne. ");
INSERT INTO ata_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eni avikalangengi manina musuku lexe moosou tani ne, anu uꞌitalonu mimii noxou ukalusi no avolu sou anu usaxilaꞌu. ");
INSERT INTO ata_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ia lexe itema sou xaixai noxou moosou tani ne, uxavutala lexe, ‘Tila noxilo ne ulivu palea uasi.’ La sou anu uavuti sou uveꞌa ta mulu mo ta sema sou xaixai noxou moosou tani xe uꞌaniꞌani mo uie xoo mole uꞌoxovulaulau. ");
INSERT INTO ata_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Xe tila noxou itema sou xaixai ne, ulivu uneꞌe no anu voxo e anu uxavutala lexe anu uneꞌe no anu uasi mo no voxo ngiou ane ulavusou uasi, la anu ulosou navunavu tatila misevile mo uxexee ulai upita noxiꞌa ta mitema ane ilavusou Lataua uasi. ");
INSERT INTO ata_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Itema sou xaixai noxou tila vile ane anu mulavusou masaxa noxou tila noxou, ia ulalaxi mo uꞌoxonu mii ane tila noxou mumasaxau ne uasi, la upuapuasou alaxu tavuꞌalo manina. ");
INSERT INTO ata_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ia ꞌenaꞌei ane ulavusou masaxa noxou tila uasi, ia ususunoxu xaixai e umomomo sou tila noxou upuapuasouxu, la anu upuapuasou alaxu taꞌeisi. Xo aneꞌi ane ta mitema milosiꞌa mimii tapiena ne, la ta mitema ilinga lexe ikolinu tapiena sio. Xe aneꞌi ane ta mitema milosiꞌa mimii tavuꞌalo noxiꞌa ne, la ta mitema ivikala lexe ikolinu tavuꞌalo la.” ");
INSERT INTO ata_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesu muvikalaneꞌi la aloxo ꞌo, “Eni eneꞌe ꞌo sou alea navu uluꞌe no lialia ꞌo. Mo eni emasaxa lexe navu ane ne, uꞌani paleasi la eni aꞌosa. ");
INSERT INTO ata_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ia, ulai iliꞌi, la eni aꞌulo no anu ꞌulo sou soli. Mo vaimomo ꞌo, eni opoole tuꞌumaxu sio xo xaixai ane ne, eni akalusou uao. ");
INSERT INTO ata_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Loxo ꞌo io, ngingi ngaxavutala lexe eni eneꞌe ꞌo sou akalusou ꞌotoꞌoto no lia ꞌo. Uasi, eni avikalangengi lexe eni eneꞌe ꞌo sou akalikalipalaneꞌi ta mitema. ");
INSERT INTO ata_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Vaimomo ꞌo mo ulai iliꞌi, la ta mitema taꞌuve no tani vile ne, ikalipala mo ixali tamei. Tatalu iꞌoto noxiꞌa tamei xe tamei iꞌoto noxiꞌa tatalu. ");
INSERT INTO ata_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ikalipala, la mamiꞌa uꞌoto noxou ꞌolu xe ꞌolu uꞌoto noxou momu, xe neniꞌa iꞌoto noxie ꞌilie sema xe ꞌilie sema iꞌoto noxie nenie, xe nenie iꞌoto noxie uaꞌaꞌne xe uaꞌaꞌne iꞌoto noxie.” ");
INSERT INTO ata_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu muvikalaneꞌi ta molomolo noxou mukalu, la Anu muvikalaneꞌi ta mitema laoluxaꞌa aloxo ꞌo, “Lexe ngingi ngamaisou tamuxala utulu utelo no xalee ane aso uꞌuna no anu, la ngingi ngapalea ngavikala lexe, ‘Uali asou usili.’ La anu usili manina. ");
INSERT INTO ata_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Xe no voxo ane atume uili molu luꞌe no luaki utelo, la ngavikala lexe, ‘Vaimomo ꞌo, la tani ialuxu.’ La anu uxali manina. ");
INSERT INTO ata_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngingi ta mitema sou kalakalavoi! Ngingi ngelavusou voxo sou mimii ane uxali no lia ꞌo mo teitexi no loxotolo. Ia loxovaa, la sou ngingi ngalavusou mii maꞌia ane uxaxali no anu voxo ano ꞌo uasi ꞌo? ");
INSERT INTO ata_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ia tavaꞌu loxovaa, la sou ngingi menge ngatilovosou mii ane laixe xe mii ane masua uasi ꞌo? ");
INSERT INTO ata_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","No anu voxo ane ngingi nongou itema ane utelo vaikala noxine ngamuamuaꞌi ngalai noxou itema sou utilovosou vaikalamengi, la natovonu pekiꞌaine sou namomosou vaivaikala no mine ngingi nongou uao no voteꞌi io. Nini naꞌoxo aloxo ne uasi, la anu usuꞌaneni nalai noxou itema sou uvelunu vaikalamengi. La itema sou utilovosou vaikala uꞌitaloneni nalai noxou itema sou xaixai noxou, la anu usuꞌaneni naꞌuna no taasou navunavu. ");
INSERT INTO ata_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","La eni avikalaneni aloxo ꞌo. Nini naxolu no anu taasou navunavu ne, utalo no anu voxo ane nini naleanu Leputa vile kaluxusou.” ");
INSERT INTO ata_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ioxe, no mine Iesu muvika-laneꞌi mukalu, la sou ta mitema moseꞌi miaꞌalou siꞌa ta mitema ne Xalilaia e Pilato mupalusiꞌa sou muveꞌaveꞌa la sialuxaꞌa ilou musiali mukei ilou sialuxaꞌa ta sipsip e aneꞌi iꞌoxe iꞌelaxaꞌa ulai noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","La Iesu muvikalaneꞌi aloxo ꞌo, “Ngingi ngexavutala lexe ꞌiliꞌilixo masumasua noxiꞌa ta mitema ane ne, muuaulixu ꞌiliꞌilixo masumasua noxiꞌa ta mitema ane moseꞌi sie Xalilaia ne, la sou anu muveꞌaveꞌa ne? ");
INSERT INTO ata_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eni avikalangengi lexe uasi manina. Ia lexe ngingi ngaxiu opongengi uasi, la ngingi latala ukalusi kalumo ne ngaulua aloxo ne. ");
INSERT INTO ata_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xe ta mitema mavulovexa mo muluꞌe no lia taꞌuve mo muxatele tatalu e tani veveeni ne Siloamu mulapau la muatasiꞌa mo misoisoli ne, la ngingi ngexavutala lexe ꞌiliꞌilixo masumasua noxiꞌa ne muuaulixu ꞌiliꞌilixo masumasua noxiꞌa ta mitema ane ixoxolu ne Ielusalemu ne? ");
INSERT INTO ata_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eni avikalangengi lexe uasisi manina. Ia lexe ngingi ngaxiu opongengi uasi, la ngingi kalumo ngaulua aloxo nesi.” ");
INSERT INTO ata_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mukalu, la sou Anu muvikalaneꞌi no anu vaikala tovolaꞌi vile aloxo ꞌo, “Itema vile mutounu lovo vile no anu xai sou ovu uaini noxou, ia iliꞌi la anu muneꞌe sou mumaisou lexe muneneꞌa. Ia uxalisou temanu uasi. ");
INSERT INTO ata_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","La sou anu muvikalanu itema ane usaxilaꞌu xai sou ovu uaini noxou ne aloxo ꞌo, ‘No ꞌa tauu ie tatalu mukalu, la eni eneꞌe ekakamuli ovu ano ꞌo temanu. Ia axalisou vile uasi. La sou naxetaꞌu mo uxexee! Xo loxovaa, la sou anu upaipalunu lialia lovoxu vitanisi ꞌo.’ ");
INSERT INTO ata_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","La sou itema sou usaxilaꞌu xai ne, mukolinu aloxo ꞌo, ‘Tila, namalanixu uxolu no anu tauu ie vile ꞌo la, mo amamulonu lialia no tavaꞌu xe asuanu mosomoso no tavaꞌu sou uleme laixe. ");
INSERT INTO ata_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ia lexe uneneꞌa no tauu ie ane uuli o, la anu laixe musuku. Ia lexe uneneꞌa uasi, la sou naxetaꞌu mo uxexee.’” ");
INSERT INTO ata_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","No anu voxo Tavuna vile, la Iesu ulolosiꞌa ta mitema lavulavu no anu vaikala noxou Lataua no nano no taasou lalotu noxiꞌa ta Iutaia. ");
INSERT INTO ata_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","La sema vile ane mixoxolu ne, ulee masua vile muxolu noxie, la sou muꞌoxonu xine tavulenu mukilikalu maxuveeni umomomo loxo tauu ie mavulovexa mo muluꞌe no lia taꞌuve mo muxatele tatalu. Milanga aloxo nesi, ia umomomo sou imexi itelo uasi. ");
INSERT INTO ata_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Xe Iesu mumaisie, la muꞌavalie mineꞌe noxou sou muvikalane aloxo ꞌo, “Eiseo, eni exexeenu pipiena noxine mukalu ne.” ");
INSERT INTO ata_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mukalu, la Anu muꞌitalonu avolu noxie, xe alaxu vilesisi ꞌo, la ane mimexi mutelo mo miꞌitinu Lataua ualasou. ");
INSERT INTO ata_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ia itema sou usaxilaꞌu taasou lalotu noxiꞌa ta Iutaia mumaisou Iesu mupamauline no anu voxo Tavuna, la laꞌiaxu misevile. La sou muvikalaneꞌi ta mitema aloxo ꞌo, “Nenge voxo sou xaixai noxinge muxatele vilesi. La ngingi nganeꞌe noxou Iesu sou upamaulingengi no anu voxovoxo ane ne, io no anu voxo Tavuna uasi.” ");
INSERT INTO ata_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ioxe, Tila mulomu aloxo ne, la muvikalanu itema ne aloxo ꞌo, “Ngingi ta mitema sou kalakalavoi! Xo ngingi vilevilesi ngalavusou ngalulusiꞌa ta mimiimengi loxo ta bulumakaumengi iloꞌa ta donkimengi no taasiꞌa sou ngalaixaꞌa sou iie no voxo Tavuna ne. ");
INSERT INTO ata_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ia sema ane ꞌo ne, ane Avalaamu ꞌilusunu vile, ia Satani musakisakiine mumomomo loxo tauu ie mavulovexa mo muluꞌe no lia taꞌuve mo muxatele tatalu. La sou umomomo sou eni axexeenu tuꞌumaxu noxie ꞌo no anu voxo Tavuna ꞌo uasi?” ");
INSERT INTO ata_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Anu muvikala aloxo ne, la ta ulua noxou ne mimaela masua. Ia ta mitema ne miꞌosa manina no anu xaixai lailaixe mukalusi ane Anu uꞌoxoꞌoxonu ne. ");
INSERT INTO ata_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu muavuti la mutaliꞌisiꞌa aloxo ꞌo, “Saxisaxilaꞌu noxou Lataua ne, anu aloxo mii maꞌia? Eni atovolaꞌinu a loxovaa? ");
INSERT INTO ata_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anu aloxo masitati ngiaxu kituꞌa e itema vile mutounu no xaixu. Ia iliꞌi xe muleme muxali tatila loxo ovu vile, la ta ngiangiala iꞌoxonu iomusiꞌa no anu avoavolu.” ");
INSERT INTO ata_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Anu mutaliꞌi la aloxo ꞌo, “Mii maꞌia ane sou, eni atovolaꞌinu saxisaxilaꞌu noxou Lataua no anu? ");
INSERT INTO ata_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Anu aloxo iisi sevile kituꞌa e sema vile minoꞌu sou mipitanu mixiunu ilou veleti ane tatila, la musoxolixu veleti ane ne.” ");
INSERT INTO ata_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ioxe, Iesu mumuamuaꞌi sou ulai ne Ielusalemu, la muꞌuna no tuatuala sou mulosiꞌa ta mitema lavulavu no anu vaikala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","La mitema vile mutaliꞌisou Iesu aloxo ꞌo, “Tila, ta mitema ta ꞌeisi mane inoꞌu mauli ane kaluxu uasi, ne?” La Iesu muvikalaneꞌi ta mitema aloxo ꞌo, “Ngapita xavingengi sou ngaꞌuna no anu aitenga ane kituꞌa ne. Xo avikalangengi lexe ta mitema tavuꞌalo itovonu sou iꞌunalai, ia imomomo uasi. ");
INSERT INTO ata_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Xo loxo moosou tani uavuti xe utatusou aitengaxu tani, la ngingi nganeꞌe ka ngatulu no ale sou ngapolopolo, io ngalinga aloxo ꞌo, ‘Tila, nakisi aitengasixe.’ Ia, anu ukolinu vaikalamengi aloxo ꞌo, ‘Eni alavusinge lexe ngingi menge neꞌei uasi.’ ");
INSERT INTO ata_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","La ngingi ngavikalanu aloxo ꞌo, ‘Nenge nengeꞌa tepita sou teꞌani mo teie ano. Mo nini netulu no voteꞌisixe sou nelosiexixu lavulavu no anu vaikala noxou Lataua.’ ");
INSERT INTO ata_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ia anu ukolinengi la aloxo ꞌo, ‘Eni alavusinge lexe ngingi menge neꞌei uasi. Ngingi ta mitema sou ꞌiliꞌilixo masumasua, ngaxexee mo ngalai vaꞌaxu.’ ");
INSERT INTO ata_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Io, ngingi ngamaisiꞌa Avalaamu ilou Aisaki mo Iakovo iloꞌa ta mitema sou palomatana ixoxolu no tuala noxou Lataua, la ngingi ngatama mo anangenge ukalakiki. Xo ngingi ngaxolu no ale. ");
INSERT INTO ata_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ia ta mitema ilutu meꞌa no tuatuala no xalee lia tamiꞌa ineꞌe ixolu no luusiꞌa sou laꞌilali no tuala noxou Lataua. ");
INSERT INTO ata_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Manina musuku lexe ta mitema ane ixavutala lexe iliꞌi, la aneꞌi ixali iuli, xe an