﻿USE sofia;
DROP TABLE IF EXISTS sofia.aso_vpl;
CREATE TABLE aso_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aso_vpl WRITE;
INSERT INTO aso_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Izesuꞌ Kilisitoꞌ avolomote mini di aniꞌ neti guliveꞌine nene neꞌmino neive: Guvelesi ve Davidiꞌ aza Abalahamuꞌ aꞌvo minineꞌ. Idoꞌ Izesuꞌ Kilisitoꞌ aza Abalahamungi Davidingi ngaꞌvo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahamuꞌ nene Isakaꞌni gidineꞌ. Idoꞌ Isakaꞌ minosa Zakoboꞌni gidineꞌ. Idoꞌ Zakoboꞌ minosa Zudaꞌnisi uvolomotine nakunolomotine nesi gidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Idoꞌ Zudaꞌ nene Tamalaꞌni do Pelezangi Zelangi gidineꞌ. Idoꞌ Pelezaꞌ nene Hezeloniꞌni gidineꞌ. Idoꞌ Hezeloniꞌ minosa Lamuꞌni gidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Idoꞌ Lamuꞌ minosa Aminadabuꞌni gidineꞌ. Idoꞌ Aminadabuꞌ minosa Nasoniꞌni gidineꞌ. Idoꞌ Nasoniꞌ minosa Salemoneꞌni gidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Idoꞌ Salemoneꞌ minosa Lahabaꞌni do Boaziꞌni gidineꞌ. Idoꞌ Boaziꞌ aza Lutiꞌni do Obediꞌni gidineꞌ. Idoꞌ Obediꞌ aza Zesaiꞌ meleho minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Idoꞌ Zesaiꞌ minosa guvelesi ve naba Davidiꞌni gidineꞌ. Idoꞌ Davidiꞌ nene veneꞌ gonoꞌ ma Uliaꞌ elenahine do Solomoniꞌni gidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Idoꞌ Solomoniꞌ nene Lehoboamuꞌ meleho minineꞌ. Idoꞌ Lehoboamuꞌ minosa Abiaꞌni gidineꞌ. Idoꞌ Abiaꞌ nene Asaꞌ meleho minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Idoꞌ Asaꞌ nene Zehosohatiꞌni gidineꞌ. Idoꞌ Zehosohatiꞌ nene Zolamuꞌ meleho minineꞌ. Idoꞌ Zolamuꞌ nene Uziaꞌ avoloho minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Idoꞌ Uziaꞌ nene Zotamuꞌ meleho minineꞌ. Idoꞌ Zotamuꞌ minosa Ahaziꞌni gidineꞌ. Idoꞌ Ahaziꞌ nene Hezekiaꞌ meleho minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Idoꞌ Hezekiaꞌ minosa Manaseꞌni gidineꞌ. Idoꞌ Manaseꞌ nene Amoniꞌ meleho minineꞌ. Idoꞌ Amoniꞌ minosa Zosiaꞌni gidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Idoꞌ Babelonia ve nete igi lovo hizi ngimi Zuda ve ngivileꞌ igi ngeleꞌmizi Babelonia misubouko vaniꞌ gameneuꞌ nene Zekoniaꞌ ve uvele mele nene Zosiadatiꞌ sotoꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Idoꞌ Babelonia misubouko vi mini adotiꞌ Zekoniaꞌ nene Sealetieleꞌni gidineꞌ. Idoꞌ Sealetieleꞌ nene Zelubabeliꞌ meleho minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Idoꞌ Zelubabeliꞌ sotoꞌ ogo minavo ezelatiꞌ nene Abiudiꞌ sotoꞌ ineꞌ. Idoꞌ Abiudiꞌ sotoꞌ ogo minavo ezelatiꞌ nene Eliakimiꞌ sotoꞌ ineꞌ. Idoꞌ Eliakimiꞌ sotoꞌ ogo minavo ezelatiꞌ nene Azoloꞌ sotoꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Idoꞌ Azoloꞌ sotoꞌ ogo minavo ezelatiꞌ nene Zadokuꞌ sotoꞌ ogo minineꞌ. Idoꞌ Zadokuꞌ sotoꞌ ogo minavo ezelatiꞌ nene Akimiꞌ sotoꞌ ineꞌ. Idoꞌ Akimidotiꞌ nene Eliudiꞌ sotoꞌ ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Idoꞌ Eliudiꞌ sotoꞌ ogo minavo ezelatiꞌ nene Eleazaleꞌ sotoꞌ ineꞌ. Idoꞌ Eleazaleꞌ sotoꞌ ogo minidotiꞌ nene Mataniꞌ sotoꞌ ineꞌ. Idoꞌ Mataniꞌ sotoꞌ ogo minavo ezelatiꞌ nene Zakoboꞌ sotoꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Idoꞌ Zakoboꞌ nene Zoseheꞌ meleho minineꞌ. Idoꞌ Zoseheꞌ nene Izesuꞌ izeleho Maliaꞌ neꞌmi vanaho minineꞌ. Aꞌmine ve Izesuꞌnimuꞌ nene Oꞌmosoꞌmo leliꞌ do luꞌ izelive lo imiselelesa live ve lo laaꞌ noune. ");
INSERT INTO aso_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eveneꞌ guliveꞌine neꞌmino gizuneꞌ nene Abalahamuꞌ gulivelotiꞌ vo Davidiꞌ guliveloꞌ ivo nene guliveꞌine fotini (14) neꞌmine gizune. Idoꞌ Davidiꞌ gulivelotiꞌ Babelonia ve nete Zuda ve ngeleꞌmizi Babelonia misubouko vaniꞌ gizunida nene eveneꞌ guliveꞌine gohi fotini (14) neꞌmine nene gizune. Idoꞌ Babelonia misubouko vi mini tineꞌ mili aniꞌ gizunidotiꞌ vo Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live neꞌmi guliveloꞌ ivo nene guliveꞌine gohi fotini (14) neꞌmine nene gizune. ");
INSERT INTO aso_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Oꞌmosoꞌmo do luꞌ izelive lo Imiselelesa live Izesuꞌ sotoꞌ ineꞌ monovo nene neꞌmino neive: Izesuꞌ izeleho Maliaꞌ nene Zoseheꞌ izeni elenaho minineꞌza olihe bizi minamasivo Oꞌmosoꞌmi Sikalahuꞌ neꞌmo Maliaꞌ mulunouꞌ lemo mino izipe molo imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Neꞌmine ogavo vanaho Zoseheꞌ aza aꞌminemuꞌ ningo gelo ve lisiheꞌ minineꞌ nenako nemuꞌ Maliaꞌni nene eveneꞌ mukilite nigilavo hulo-deloniꞌ nene ovozo helalive lo gelo zegeno haleko hulo-delove lo gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Idoꞌ neꞌmino gala geleꞌmo nomonivo Guvelesi veꞌmi angeloꞌ maliꞌmo vamutoꞌ sotoꞌ o emo tiꞌ lo lo-imineꞌ: Zoseheꞌ gaza guvelesi ve Davidiꞌ aꞌvo make, veneka Maliaꞌni nene dalohe hulo-delohe lo gaka gopo nogelaineꞌ nene gelamozo. Izipahala nominineꞌ nene Oꞌmosoꞌmi Sikalahuliꞌmidatiꞌ nenako ne ha dalosane. ");
INSERT INTO aso_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Neꞌmine oganivo gipe ma gedeleseive. Neꞌmine ogavo gulive Izesuꞌ ve lo molalosane. Aꞌmine gulive neꞌmi monovo nene do luꞌ izelive ve. Idoꞌ eze evenele zuho neti lihimeꞌine hulo-ngedo do nguꞌ izelineꞌ nenako nemuꞌ guliveꞌve nene Izesuꞌ ve lo molalosane. ");
INSERT INTO aso_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Initeꞌ mukiꞌ neꞌmino sotoꞌ ineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete maliꞌmo Guvelesi veꞌmo lineꞌ gamazi ma lo-ngimineꞌ nene gihile izelive losa sotoꞌ ineꞌ. Idoꞌ aꞌmine Guvelesi veꞌmo lineꞌ gamazi nene neꞌmino neive: ");
INSERT INTO aso_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Zaha ningamineꞌ alu maliꞌmo izipahala mino gipele gedelineꞌ nene guliveꞌve Emanueliꞌ ve li milalisave. Aꞌmine gulive Emanueliꞌ neꞌmi monovo di velepeꞌ izaniꞌ nene neꞌmino neive: Oꞌmoso lelikisi neive. ");
INSERT INTO aso_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Idoꞌ neꞌmine ogavo Zoseheꞌ aza okisetiꞌ otosa angeloꞌ lidoꞌ nene gele do elenahine Maliaꞌni nene eleꞌmize numuꞌveuꞌ molaniꞌza ");
INSERT INTO aso_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","okoꞌnoloꞌ damivo gipele ma gedavo gulive Izesuꞌ ve lo molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helodeꞌ aza Zuda veti misubouꞌ guvelesi ve naba loloꞌ ogo minineꞌ gamene neuꞌ nene Izesuꞌ aza Zudaia misubouꞌ numuno ebeꞌ ma gulive Betelehemi neuꞌ sotoꞌ ogavo sonohiꞌ monovo gilaaꞌ ave ma engiꞌ misuboꞌine hotaa hoꞌ dizaaꞌ ida minineꞌ nene huli igi Zelusalemi numuno ebeta heteli tiꞌ li longoꞌ igi laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Zuda ve lengiꞌ guvetinesi ve loloꞌ ilive gosohoꞌ sotoꞌ ineꞌ nene zala nolive. Laza nene eiꞌ sotoꞌ ilingumuꞌ sotoꞌ ilineꞌ sonohiꞌ nene sotoꞌ ogavo ningo nemuꞌ Guvelesi ve mo sotoꞌ ogave lo gelo gubuꞌ ize emelesa noune. ");
INSERT INTO aso_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Neꞌmine likevo guvelesi ve Helodeꞌ aza laniꞌ gamazi nene gelo gopo gala gelavo Zelusalemi aleve inginesi aꞌmineꞌmine igi gopo gaꞌine gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Neꞌmine ogo Helodeꞌ nene Zuda veloꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ monoꞌ apizi ngimaaꞌ avesi nene asi lo do nubo o-ngedo Oꞌmosoꞌmo imiselelesa live Guvelesi ve naba aza nene zala sotoꞌ ilive li nizaniꞌ neve lo longoꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Longoꞌ o-ngedavo ingine tiꞌ li laniꞌ: Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete gozopoꞌ ma minidiꞌmo Oꞌmosoꞌmo lineꞌ gamazi ma tiꞌ lo gize neive: Idoꞌ Zudaia misubouko Betelehemi aleve naneꞌ gaza Zuda veti misubouꞌ eveneꞌ dizi minanguꞌ nene gaza lemo minanive nomane. Geitatiꞌ guvelesi ve ma neze eveneꞌne zuho Isilaeleꞌ aleve gizebo o-ngedelive ma sotoꞌ ilineꞌ nenako nemuꞌ nene gaza lemosi ma minamane. Poloheteliꞌmo tiꞌ lo gizineꞌ nemuꞌ aꞌmine Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live nene Zudaia misubouꞌ Betelehemi numuda sotoꞌ oloseive li li nizaniꞌ ve li li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tiꞌ li li-imikevo sonohiꞌ monovo gilaaꞌ ave nene Helodeꞌ zegeno sunoꞌ asi lo-ngedavo ikevo sonohiꞌ apiꞌ ogo sotoꞌ ineꞌ gamene gehepevemuꞌ longoꞌ o-ngedavo nemuꞌ li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Li-imikevo aza Betelehemi numuda ngimiselo tiꞌ lo lo-ngimineꞌ: Lingine vi aꞌmine izipe nene viseꞌ di lamini ilo. Viseꞌ di lamineꞌ igi ningi ma tineꞌ mili igi li-nimilo. Nazasi vo gubuꞌ ize emeloze. ");
INSERT INTO aso_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Neꞌmine lo lavo ingine gili limi vaniꞌ. Idoꞌ nivavo, ee, aꞌmine gomuꞌ sotoꞌ neivo ninganiꞌ sonohiꞌ nene gohi sotoꞌ ogo gomuꞌ molo ngemo vo izipe minineꞌ ebeꞌ veleta nene utuꞌvize minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Idoꞌ sonohiꞌ nene ningi ngolize nabaꞌmine goloso izi ");
INSERT INTO aso_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","numunguꞌ dizi ninganiꞌ nene izipe ngomo nene izeleho Maliakisi nizasivo ninganiꞌ. Ningi obuvoꞌine hizi izipe ngomo nene gubuꞌ izi imii goꞌningutiꞌ initeꞌ ma imaniꞌ nene ngolimonisi idoꞌ atoꞌ atoꞌ za sitalitisi novozo di lumo lumo aniꞌ unuvo lamineꞌ ogaꞌ ineꞌ nesi lehizi-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lehizi-daniꞌza Oꞌmoso neꞌmo vamutoꞌ nene Helodeꞌ neida mo tineꞌ mili vamilizave lo lo-ngedavo ingine aniꞌ akala vami atoꞌ akala vi numuꞌine ebeꞌnida vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Idoꞌ sonohiꞌ monovo ningaaꞌ ave ingine mo vikevo Guvelesi veꞌmi angeloꞌ maliꞌmo Zoseheꞌni vamutoꞌ sotoꞌ o emo tiꞌ lo lo-imineꞌ: Helodeꞌ aza aꞌmine izipe nene belelove lo gelo ezemuꞌ viseꞌ olosa neize. Gaza oto izipesi izelehingisi ngeleꞌmizo vo Aigita misubouko vi minilo. Nizavo alingeꞌ tineꞌ mili alizave loloniꞌ gameneuꞌ nene tineꞌ mili alizaze. ");
INSERT INTO aso_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Neꞌmine lavo Zoseheꞌ aza oto izelehingi gipelengi nene holukaꞌ naba ngeleꞌmizo Aigita misubouko vavo aꞌminguꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aꞌminguꞌ nizavo Helodeꞌ nene hilineꞌ. Oꞌmosoꞌmo Aigita misubouko ngimiselineꞌ nene Guvelesi veꞌmo lineꞌ gamazi polohete maliꞌmo lo sotoꞌ ineꞌ ma nene gihile izelive lo ngimiselineꞌ. Aꞌmine lo sotoꞌ ineꞌ gamazi nene neꞌmino neive: Aigita misubouko neivo neniꞌ gipeꞌnemuꞌ ano lo asi lo-dekuve. ");
INSERT INTO aso_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helodeꞌ ha neivo sonohiꞌ monovo gilaaꞌ ave ingine Helodeꞌ neida tineꞌ mili vami golo izaniꞌ nene ningo gelo izeboloꞌ goloso molavo nemuꞌ sonohiꞌ monovo gilaaꞌ avete li-imaniꞌ gamene nene ha gele mino gipe ngomo kilisimasiꞌine sitaꞌ ivileꞌ amineꞌ gipe mukiꞌ nene ngibililo lo ami ma ngimiselavo ingine vi Betelehemi ebekuꞌ idoꞌ numuno ebeꞌ gohi ma avitoꞌ miniꞌmi monanguꞌ nene moni neꞌmine gameneꞌinesi minaniꞌ gipe nene ngibili geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Neꞌmine ikevo Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete Zelemiaꞌ gizineꞌ gamazi neꞌmino ma nene gihile izineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lama misubouꞌ ive namaliꞌmo nolo molo minineꞌ. Veneꞌ mukiꞌ Laheliꞌ aꞌvo ingine gekeꞌ gekeꞌ li Izipahaꞌinemuꞌ ive nama goloso igi minaniꞌ. Izipahaꞌine vaiꞌ osuꞌ laniꞌ neꞌmo di nguꞌ izilizaniꞌ nesi ngeli matamilizaniꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helodeꞌ mo helavo alingeꞌ Guvelesi veꞌmi angeloꞌ maliꞌmo Aigita misubouko vo Zoseheꞌni vamutoꞌ sotoꞌ o emo ");
INSERT INTO aso_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tiꞌ lo lo-imineꞌ: Izipe belelove live ma nene mo helaze. Nemuꞌ nene gaza oto izelehingi gipelengi ngeleꞌmizo Isilaeleꞌ misubouko vozo. ");
INSERT INTO aso_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lavo Zoseheꞌ aza oto izelehingi gipelengi ngeleꞌmizo Isilaeleꞌ misubouko vineꞌza ");
INSERT INTO aso_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Akelaoꞌ aza meleho Helodeꞌ gonoloꞌ medelo Zuda veti guveꞌinesi ve naba loloꞌ ineꞌ nene gelo eiꞌ gizebo ineꞌ misubouꞌ nene vo minelesa ehelele izineꞌ. Ehelele izavo Oꞌmosoꞌmo vamutoꞌ lo-imidiꞌmine ogo izipesi izelehingisi ngeleꞌmizo nGalilaia misubouꞌ vavo ");
INSERT INTO aso_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","numuno ebeꞌ ma gulive Nasalete neuꞌ vi minaniꞌ. Neꞌmine ikevo nemuꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ avelite Oꞌmosoꞌmo imiselelesa livemuꞌ nene Nasalete ve ve lilisave laniꞌ nene gihile izineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Idoꞌ aꞌmine gameneuꞌ nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ nene apiꞌ ogo Zudaia misubouꞌ ebeꞌ hadivela sotoꞌ ogo ");
INSERT INTO aso_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","gamazi tiꞌ lo lo ngeme ngemeꞌ oꞌmo aniꞌ: Oꞌmosoꞌmi gizebouꞌ vo holosoꞌ gamene mo alitaze. Lutine di velepeꞌ izilo lo lo-ngemeꞌmo aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Idoꞌ gozopoꞌ ma mino Oꞌmosoꞌmo lineꞌ gamazi lo sotoꞌ ogaꞌ ive polohete Isaiaꞌ aza Oꞌmosoꞌmo lineꞌ gamazi ma tiꞌ lo gizineꞌ: Ebeꞌ hadivelatiꞌ eveneꞌ maliꞌmo asi naba ma tiꞌ lo nolive: Guvelesi ve alingumuꞌ ve li akaꞌve di vaꞌvaꞌ igi lutine di lisiheꞌ i-dilo. Neꞌmine lo lineꞌ nene Zohaneꞌnimuꞌ lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Idoꞌ aꞌmine Zohaneꞌ okoꞌnoloꞌ initeꞌ nene kamelaꞌ ize zopovodunuꞌ amuzo molo vineꞌ liliꞌ aniꞌ nene ngolo idoꞌ ize losuvodunuꞌ liliꞌ aniꞌ leti nesi gopololoꞌ izo maꞌnabusosi himoni neti novozo nesi naaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Idoꞌ eveneꞌ mukiꞌ nene Zudaia misubouꞌ Zelusalemi numuno ebekutikisi idoꞌ aꞌmine misubouꞌ numuno ebeꞌ mukiꞌ netikisi idoꞌ Zodani noso gahevela minaniꞌ numuno ebeꞌ mukikutikisi nene Zohaneꞌ neida vi ");
INSERT INTO aso_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","lihimeꞌine li sotoꞌ ikevo Zodani nosouꞌ noso holo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Holo-ngidineꞌza Zuda veti monoꞌ mulise ato atoꞌ minangutiꞌ eveneꞌ linge ma Halisaioꞌ monoꞌ gilaaꞌ ave idoꞌ linge ma Sadukaioꞌ monoꞌ gilaaꞌ ave mukiꞌ noso hilalisa navo ningo tiꞌ lo lo-ngidineꞌ: Lingine Sataliꞌmi izipahala goloso mene Oꞌmosoꞌmo lihime lengemelingutiꞌ ha olovoꞌ ilisave lo ve maliꞌmo lo-lengemavosa olovoꞌ ilisa nahe. ");
INSERT INTO aso_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nemuꞌ nene lingine aꞌmingutiꞌ olovoꞌ olone lii ma lingine luꞌine di velepeꞌ lamineꞌ izaveti monovo nene di mini initeꞌ lamineꞌ gihilevoꞌ nene igi mili minilo. ");
INSERT INTO aso_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Idoꞌ gililo. Lingine laza Abalahamuꞌ aꞌvopilemoꞌ Oꞌmosoꞌmo noꞌnohoꞌ ize-ledelesuve live nounako Oꞌmosoꞌmo lihime lemo do goloso o-ledamivo laminekovoꞌ ha minelesune li lutinguꞌ gilamilo. Naza ma lo-lengemeloze. Lengiꞌ nene do hulosa Oꞌmosoꞌmo Abalahamuꞌni lo huko-dineꞌ gamazi do gihile izelesa Abalahamuꞌ aꞌvopilemoꞌ gohi ma do sotoꞌ o-delove lo gilidiniko geheni nevote Abalahamuꞌ aꞌvopilemoꞌ liliꞌ adine. Nemuꞌ nene lingine laza Abalahamuꞌ aꞌvopilemoꞌ nounako lihime lemamoloseive li gilamilo. ");
INSERT INTO aso_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Oꞌmosoꞌmo idise lihime lemo mo lebelelesa do nene ogo mino eveneꞌ za belelesa za monovola luno bai gamunoꞌ ogaꞌ neineꞌ neꞌmine o neive. Za mukiꞌ gihile lamineꞌ izamaniꞌ nene monoꞌ gilamaniꞌ aleve neꞌminosa nenako huko olokuꞌ gizeleseive. ");
INSERT INTO aso_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naza nene monoꞌ noso holo-ngedeꞌmo vo nouvoniꞌ nene lutine di velepeꞌ izangumuꞌ nene haza nosodunuꞌ holo-lengedeꞌmo vo nouvoniꞌza alingeꞌ neꞌmeto nave nene dizo mino nezesi nivileꞌ goloso o-nedosa neive nenako naza aꞌneꞌmineꞌmine limi minavelite daaꞌ aniꞌ gono nesi do-do suuꞌve nesi ngelo do-do vamolosuve. Idoꞌ aꞌmine ve neꞌmo noso holo-lengedelineꞌ nene Oꞌmosoꞌmi Sikalahukisi olokisi ne neive. ");
INSERT INTO aso_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ee, aꞌmine ve nene eveneꞌ laminekisi golososi do gizekaꞌ olosa do nene ogo mino ve ma viti gihilesi losuvosi gopo igi minaniꞌ nene do kegeselesa gono daaꞌ initeꞌve do anauꞌ ogo do nene ogo minaaꞌ neineꞌ neꞌmine o neive. Aza viti gihile losuvosi minangutiꞌ aꞌmine vaiꞌ nene do lamino izeꞌ molo naaꞌ initeꞌ nene do nubo ogo numuꞌveuko molo losuvo nene lovoꞌ lovoꞌ ogo minaaꞌ neineꞌ olokuꞌ nene gizeleseive. ");
INSERT INTO aso_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Idoꞌ Izesuꞌ aza Zohaneꞌ monoꞌ noso holo-nedelive lo nGalilaia misubo hulo Zohaneꞌ neida Zodani nosola vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vo hetelo noso holo-delingumuꞌ lavo Zohaneꞌ aza naza aꞌneꞌmine veꞌmine holo-deloniꞌ nene edamoloseive lo gelo oꞌve lo-delesa tiꞌ lo lineꞌ: Geiꞌ neke, neniꞌ noso holo-nedelinidoꞌ o neineꞌ nenako neniꞌ holo-nedelive lo nenita nanimuꞌ nane. ");
INSERT INTO aso_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lavo Izesuꞌ aꞌmidoꞌ lo-imineꞌ: Lamineꞌ laineꞌza neꞌmine olosivetise Oꞌmosoꞌmo lidoꞌ olosineꞌ nenako nemuꞌ oꞌve lamozo. Neꞌmine lavo gele emo monoꞌ noso holo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Monoꞌ noso holo-davo Izesuꞌ aza geto nosoutiꞌ dizo ningineꞌ nene, ee, Okulumoꞌ ngoloꞌ lavo Oꞌmosoꞌmi Sikalahuꞌ neꞌmo nama viluso neꞌmino ezela lemo navo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ningavo Okulumokutiꞌ gamazi ma tiꞌ lo limineꞌ: Aza mene voꞌneloꞌ gipeꞌne hamoꞌ nene neive. Ezemuꞌ nene mo muluꞌneuꞌ lamineꞌ nogiluve. ");
INSERT INTO aso_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Neꞌmine ogavo Sataniꞌmo emenguꞌ molalingumuꞌ ve lo Sikalahuꞌ neꞌmo eleꞌmizo ebeꞌ hadivela dizineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eleꞌmizo dizavo aꞌmida nosoꞌ niteꞌ malise ogo ongo oto ineꞌ nene gamene foti (40) nominivo alingeꞌ gaꞌna goloso helo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gaꞌna helo neivo ngemenguꞌ molaaꞌ ive aza Izesuda ogo tiꞌ lo lo-imineꞌ: Gaza Oꞌmosoꞌmi gipele noo ma geheni mevomuꞌ lanivo nalineꞌ initeꞌ beleti liliꞌ ilo lovo. ");
INSERT INTO aso_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Oꞌove, monoꞌ godolouꞌ gamazi ma tiꞌ li gizi nizaniꞌ ma neive: Eveneꞌ minevoꞌ alevote nene nosoꞌ nitekukovoꞌ nomive. Oꞌmosoꞌmi veletiꞌ gamazi mukitoꞌ nesi ha minevoꞌ alevoꞌ olosune. Neꞌmine li gizi nizaniꞌ nenako nemuꞌ nene geiꞌ laineꞌ neꞌmine nene mo amolosuve. ");
INSERT INTO aso_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Neꞌmine lavo Satani aza Izesuꞌni eleꞌmizo Zelusalemi ebekuꞌ vo monoꞌ numuno naba haꞌna haꞌna minineꞌ neꞌmi gololoꞌ eleꞌmizo dize mino ");
INSERT INTO aso_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tiꞌ lo lo-imineꞌ: Monoꞌ godolouꞌ tiꞌ li gizi nizaniꞌ ma neive: Oꞌmosoꞌmo geikumuꞌ angeloꞌve gono gamazi lo-ngedeleseive. Idoꞌ ma nene: Gizenga gehedoꞌ gebele gulutilingutiꞌ angeloꞌ nete alete mili di hozi li-gidilisave li gizi nizaniꞌ ve. Idoꞌ aꞌmine gamazi lidoꞌ igi neꞌmine i-gidilisaze. Gaza lamineꞌ Oꞌmosoꞌmi gipele noo ma melotiꞌ oluto akaꞌmeloꞌ izevo. ");
INSERT INTO aso_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Ne neiha monoꞌ godolouꞌ gamazi gohi ma tiꞌ li gizi nizaniꞌ ma neive: Lingine Guvetinesi ve Oꞌmoso golo izamilo. Neꞌmine lo-leme neineꞌ nenako geze nolaineꞌ nene Oꞌmoso golo izaaꞌ noloseinako neꞌmine amolosuve. ");
INSERT INTO aso_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Neꞌmine lavo Satani aza gohi eleꞌmizo golo haꞌna haꞌna maloꞌ dize mino eveneꞌ zuho ato atoꞌ misuboꞌninguꞌ misuboꞌninguꞌ amuzoꞌinesi minaniꞌ idoꞌ gonoliseꞌine lamineꞌ tamineꞌ ato atokisi minaniꞌ nene elebizo ");
INSERT INTO aso_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","tiꞌ lo lo-imineꞌ: Gaza neniꞌ gubuꞌ ize nemo nopoꞌni lilineꞌ nene initeꞌ noningaineꞌ akaꞌme nene gemelesuve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Monoꞌ godolouꞌ tiꞌ li gizi nizaniꞌ ma neive: Laza Guvetesi ve Oꞌmoso eiꞌ hamoꞌ nene opoꞌni lo gubiꞌ ize emo minelesune. Ee, eiꞌ hamokovoꞌ nene gelekeleꞌ o-do minelesune. Neꞌmine li gizi nizaniꞌ nenako nemuꞌ nene gaza laineꞌ neꞌmine amolosuze. Satani gaza hulo-nedo vo haha ozo. ");
INSERT INTO aso_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lavo nelotiꞌ Satani aza hulo-do vavo Izesuꞌ neida angeloꞌ sotoꞌ igi nasahiliꞌ igi hize eleꞌ i-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Idoꞌ Zohaneꞌni nene nalaꞌ numunguꞌ huli-daniꞌ nemuꞌ gelo Izesuꞌ aza nGalilaia misubouko vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Vo Nasalete ebeꞌ hulo Kahanaumi ebeta vo minineꞌ. Kahanaumi ebeꞌ nene nGalilaia noso ohuno gahevela Zakoboꞌ gipele Zebuloniki Nahataliki ngaꞌvopilemoꞌ zuho engiꞌ misuboꞌninguꞌ ongo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Neꞌmine ineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete Isaiaꞌni Oꞌmosoꞌmo lo-imineꞌ gamazi ma neꞌmine lo lineꞌ ma nene ogo gihile izineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Litiꞌmusouꞌ gopo Zebuloniꞌ misuboukisi Nahataliꞌ misuboukisi idoꞌ noso ohuno nabaꞌmi gahevela idoꞌ Zodani noso liginela Zuda ve minamaniꞌ aleveti misubo nGalilaia neuꞌ minave ingine labanaꞌ naba mo ningikeve. Ee, aꞌmine aleve liꞌnimuso luꞌninguꞌ ize minivo minave ingine mudise hilaaꞌ akaloꞌ mini mili minave engita labanaꞌ nene mo sotoꞌ o ngemave. ");
INSERT INTO aso_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aꞌmine gamenelotiꞌ Izesuꞌ nene monoꞌ tiꞌ lo lo-ngemekaꞌ ngemekaꞌ oꞌmo monineꞌ: Oꞌmosoꞌmi gizebouꞌ vo holosoꞌ gamene mo alitaze. Lutine gatine di velepeꞌ izilo. ");
INSERT INTO aso_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Izesuꞌ aza tiꞌ oꞌmo nGalilaia noso ohuno nabaꞌmi gahevela nomono uvolohoi akunoloi ma guliveꞌine Simoniꞌ ve gulive gohi ma Petoloꞌ aza nakunolo Adeleakisi alahaꞌ daaꞌ asive minasinako alahaꞌ daaꞌ asineꞌ golalezeꞌine nene alahaꞌ dalisa nosouꞌ nihulasivo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ningo tiꞌ lo lo-ngimineꞌ: Lingine igi neꞌmetilizo. Alahaꞌ daaꞌ nasineꞌ neꞌmini eveneꞌ di nenita igaꞌ ilisive loloꞌ o-lengedelesuze. ");
INSERT INTO aso_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Neꞌmine lavo ingine liteꞌ li alahaꞌ daaꞌ asineꞌ golalezeꞌine nene hitiki eꞌmeti vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ve sitaꞌ nene do giꞌmizo ngomo ma novo uvolohoi akunoloi gohi ma Zebedaioꞌ gipele sitaꞌ guliveꞌine Zakobokisi idoꞌ akunolo Zohanekisi ingine meꞌnibo Zebedaioꞌ nesi sipiuꞌ mini alahaꞌ daaꞌ aniꞌ golalezeꞌine nene ongoti di lamineꞌ igi nizavo ningo neꞌmetilisive lo asi lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Neꞌmine lavo liteꞌ li oti meꞌnibinesi sipi nesi huli-ngidi eꞌmeti vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Idoꞌ nGalilaia misubo mukikuꞌ mone mone ogo monoꞌ numunoꞌine mininguꞌ mininguꞌ monoꞌ apize ngemo Oꞌmosoꞌmo eveneꞌ do giꞌmizo gizebo o-ledelineꞌ gamazi lamineꞌ nene lo-ngemekaꞌ ngemekaꞌ ogo eveneꞌ initeꞌ gizi davesi gilizevo alevesi mukiꞌ nene do lamineꞌ o-ngedeꞌmo monineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Neꞌmine ogavo guvele nene Silia misubo mukikuꞌ nene mono osuꞌ lavo initeꞌ ato atoꞌ gizi di mulumo gilave mukiꞌ nesi idoꞌ sikalahuꞌ goloso luꞌninguꞌ minive idoꞌ lemo lise-ngedaaꞌ ive idoꞌ gizeꞌine aꞌnine gulupese ive mukiꞌ nene Izesuda ngeleꞌmizi ikevo do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Idoꞌ eveneꞌ mukiꞌ vaiꞌ goloso nGalilaia misuboukotikisi idoꞌ Dekapoli misuboukotikisi Zelusalemi ebekutikisi idoꞌ Zudaia misubouꞌ minaniꞌ ebeꞌ linge malatikisi Zodani noso helala minineꞌ misuboukotikisi igi di geseꞌ igi eꞌmetaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Izesuꞌ aza eveneꞌ mukiꞌ goloso aniꞌ nene ningo gololoꞌ dizo aꞌmida mitoꞌ neivo izipahala zuho ingine ezela igi minikevo ");
INSERT INTO aso_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","gamazi apiꞌ ogo neꞌmine lo apize ngemo minineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Lute hize eleꞌ ilineꞌ initeꞌ mataꞌ lezela nomive li viseꞌ igaꞌ ave ingine Oꞌmosoꞌmo gizebo o-ngedelinguꞌ vi hilalizaniꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Idoꞌ lihime initeliꞌmi lulouꞌ mini agae agae li ive igi minaaꞌ nave ingine nene Oꞌmosoꞌmo do nguꞌ izelineꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Idoꞌ eveneꞌ hongu li limi minaaꞌ nave ingine nene Oꞌmosoꞌmo misubo meꞌningine loloꞌ o-ngedo aꞌminguꞌ initeꞌ mataꞌ nesi ngemelineꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Idoꞌ eveneꞌ govi ve noso ve li gaꞌna hili minaaꞌ nave neꞌmini Oꞌmosoꞌmi monovo lisihekumuꞌ ma dunivoo li gaꞌna hili minaaꞌ nave ingine aꞌmine dalisa laniꞌ initeꞌ nene Oꞌmosoꞌmo ngemavo laniteꞌ gili minilizaniꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Idoꞌ eveneꞌ mamuꞌ mulumoꞌine gili nasahiliꞌ i-ngidaaꞌ nave engiꞌ nene Oꞌmosoꞌmo mulumoꞌine gelo nasahiliꞌ o-ngedelineꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Idoꞌ luꞌninguꞌ golososi nomivo lamineꞌ minaaꞌ nave ingine Oꞌmoso ningilisave. Ningilizaniꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Idoꞌ eveneꞌ hongu li miniliza monovo di sotoꞌ igaꞌ nave ingine Oꞌmosoꞌmo eiꞌ izipahala zuho ve lo-ngedelineꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Idoꞌ Oꞌmosoꞌmi monovo lisiheꞌ nene di tiꞌ igisa igi mili nizavo nemuꞌ goboni nimili-ngidavo goboni malaꞌ malaliꞌmi lulouꞌ minaaꞌ nave ingine Oꞌmosoꞌmo gizebo o-ngedelinguꞌ vi hilalizaniꞌ nenako nemuꞌ lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ ngolize izilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ve ma ingine neniꞌ neꞌmetangumuꞌ ve li lengelemi goboni mili-lingidi soza li gamazi goloso palasa li-lingidilizaniꞌ nene lamineꞌ iliza akaloꞌ mini mili nizave. ");
INSERT INTO aso_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Idoꞌ gomuꞌ minaniꞌ Polohete aꞌmineꞌmine igi goboni mili-ngidaaꞌ aniꞌ nenako lingine engiꞌ gonoꞌnidoꞌ medeli minaniꞌ nemukisi idoꞌ Oꞌmosoꞌmo aza menitine naba Okulumokuko molo-lengedelingumukisi muludinguꞌ lamineꞌ gili longolize izi minilo. ");
INSERT INTO aso_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Guvo nene nosoꞌ nitekuꞌ tileꞌ okunivo neꞌmo do lamineꞌ ogaꞌ neive. Lingine eveneꞌ mukiliti vovoꞌninguꞌ guvo neꞌmine mini ngeleꞌmize lamineꞌ igi minilisave. Ee, lingine guvo neꞌmini nizaniꞌza aꞌmine guvo nene goloso ogavo laniteꞌve osuꞌ lavo ma ngelo gohi lamineꞌ amoloseive. Mo goloso o vineꞌ nenako nemuꞌ di huli akaloꞌ ikevo eveneꞌ aꞌmidoꞌ lisi monilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lingine nene misubouꞌ veliti liviꞌ labanaꞌine nene nizave. Idoꞌ nemuꞌ nene gololoꞌ gehepeve minineꞌ numuno ebeꞌ neꞌminisasi minilisave. Gololoꞌ gehepeve minineꞌ neꞌmo ngelo haleko minamoloseive. Lingine aꞌmineꞌmine igi sotoꞌ igivoꞌ minikevo eveneꞌ mukiꞌ nene ningi osuꞌ li minilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Idoꞌ oloꞌ liviꞌ nene viteꞌ igisa aꞌmidoꞌ somo naba ma di hiti di halekami aꞌmine liviꞌ nene numunguꞌ nizave mukiꞌ nene hize labanaꞌ ele-ngedelive li holomoꞌveloꞌ sotoꞌ ogo minelidokovoꞌ di milalisave. ");
INSERT INTO aso_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lingine aꞌmineꞌmine igi labanatine neꞌmo eveneꞌ nene hize labanaꞌ ele-ngedelive li di sotoꞌ igisa igi mili minilizaniꞌ monovo nene lamineꞌ ogavo nemuꞌ nene eveneꞌ nete ningi Okulumokuꞌ Metibine nene opoꞌni lilisave. Nemuꞌ labanatine nedunuꞌ hize labanaꞌ ili minilo. ");
INSERT INTO aso_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Lingine nenikumuꞌ Oꞌmosoꞌmi louꞌ gamazi Moseꞌ lo huko lineꞌ nesi Oꞌmosoꞌmi veletiꞌ gamazi polohete nete li sotoꞌ aniꞌ nesi gili damilo lo aꞌmine gamazi ize hukolosa ahe li gilamilo. Nene ize hukolosa amuve. Monovoꞌve lo sotoꞌ ogo do gihile izelesa ogo nouvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gamazi mene mo laminetoꞌ nolo-lingimuve: Oꞌmosoꞌmo lo huko lineꞌ gamaziutiꞌ nene gamazi ngomo ha nitekisi mo vo tolovo amivo okulumokisi misubosi osuꞌ lilisineꞌ gameneukisi aꞌmine louꞌ gamazi nene ha mineleseive. Lamineꞌ ha mino aꞌmine gamazi mukiꞌ nene gihile izosavoꞌ nene osuꞌ loloseive. ");
INSERT INTO aso_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ve ma ingine Oꞌmosoꞌmo gili dalizave lo louꞌ gamazi lo huko-lidineꞌ mukikutiꞌ ngomo gidini ma minineꞌ nemukisi haza niteꞌ ve li avutoꞌ igi mini eveneꞌ mamuꞌ linginesi aꞌmineꞌmine igi avutoꞌ igi minilizaniꞌ nesi lamineꞌ oloseive li apizi ngimilizaniꞌ nene Oꞌmosoꞌmo engikumuꞌ eiꞌ gizebouꞌ vi hilaveti muliseuꞌ limi minave ve lo lo-ngedeleseive. Neꞌmine lo-ngedelineꞌza ve ma ingine aꞌmine louꞌ gamazi mukiꞌ nene gili di mini eveneꞌ mamuꞌ linginesi aꞌmineꞌmine igi gili di minilizave li apizi ngimilizave ingine Oꞌmosoꞌmi gizebouꞌ vi hilaveti muliseuꞌ dizi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Idoꞌ nemuꞌ nene naza nolo-lingimuve. Lingine Oꞌmosoꞌmi louꞌ gamazi apizi lingimaaꞌ avesi idoꞌ Halisaioꞌ monoꞌ laaꞌ avesi ingine eveneꞌ mukiꞌ ngivileꞌ igi ve lisiheꞌ lamineꞌ nizave ve li gilaaꞌ nahe. Gililo. Lingine lisiheꞌ goloso igi mini aꞌmine monoꞌ li-lingimaaꞌ aniꞌ aleve nene ngivileꞌ igi minamilizaniꞌ nene Oꞌmosoꞌmi gizebouꞌ mo kekeꞌ vi hilamilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Idoꞌ louꞌ gamazi gozopoꞌ avotinginemuꞌ neꞌmine lo Moseꞌ lo huko gizineꞌ ma nene mo gili nizave: Gaza eveneꞌ ma bele helamozo. Nemuꞌ nene eveneꞌ ma bele helelive nene gonitoꞌ eleꞌmize mili lihimeꞌve imilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ne neineꞌza ma lo-lengemeloze. Ve ma aza ve mamuꞌ izeboloꞌ dalineꞌ nene gonitoꞌ oteleseive. Idoꞌ ve ma aza ve mamuꞌ dingani negi goloso ve lo-delive nene goniꞌ nabaloꞌ oteleseive. Idoꞌ ve mamuꞌ gaza gamazi gelesaꞌmane dingani goloso mene lo lo-delive nene olokuꞌ vaaꞌ akaloꞌ mine molaloseive. ");
INSERT INTO aso_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nemuꞌ nene gaza initeꞌ ma Oꞌmoso emelesa monoꞌ numunguꞌ dizo aꞌmine initeꞌ milaaꞌ holomoꞌveloꞌ olihe nomolo ve ma nenikumuꞌ mulunouꞌ goloso gelo lihimeꞌne do neive lo aꞌmidoꞌ gaka liteꞌ lo gelo ma ");
INSERT INTO aso_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Oꞌmoso emelineꞌ initeꞌ nene holomoꞌveloꞌ molamo aꞌmidoꞌ huloko vo aꞌmine lihimeka do neiveꞌmi mulunouꞌ nene do lamineꞌ o-dezo. Do lamineꞌ o-dosa nene ogo Oꞌmoso emelineꞌ initeꞌ nene holomoꞌveloꞌ molo-delesane. ");
INSERT INTO aso_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ve maliꞌmo goniꞌ o-gedelesa geleꞌmize do zasila novivo ma nene zasiꞌmo minosa hulo pilisi veti aꞌninguꞌ ogavo huli galapusoloꞌ i-gidikelizaze. Akala olihe nivi ma gaza liteꞌ lo gonitoꞌ geleꞌmize molaliveꞌmi mulunouꞌ do hongu lo-do zogo molo-dezo. ");
INSERT INTO aso_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Naza lamineꞌ lo-gemeloze. Gaza zogo emo mulunouꞌ do hongu lo-damanivo galapusoloꞌ huli-gidilizaniꞌ nene gaza aꞌminguꞌ mino lihimeka apasekaꞌ apasekaꞌ ogo mino meni hize osuꞌ gehepeve losavoꞌ nene osuꞌ losa volosane. ");
INSERT INTO aso_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Moseꞌ lo huko lineꞌ gamazi neꞌmo gaza veneꞌ ma longoꞌ amozo lo neineꞌ ma mo gili nizave. ");
INSERT INTO aso_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gili nizaniꞌza idise naza ma lo-lengemelove: Ve ma aza Veneꞌ alu mamuꞌ ningo ma duvo lo gelelineꞌ nene eiꞌ luloliꞌmo aꞌmine veneꞌ nene longoꞌ ineꞌ geleleseive. ");
INSERT INTO aso_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nemuꞌ nene veka zamelatiꞌ ningaineꞌ neꞌmo goloso initekumuꞌ luka otavo ma aꞌmine veka neꞌmo geleꞌmize goloso ogavo Oꞌmosoꞌmo olokuꞌ hulo-gedalize. Aꞌmine monovo goloso nene hulilineꞌ neꞌmo veka mene kuluhize hulaineꞌ gilivo minelineꞌ nene lamineꞌ oloseive. Okonga mukiꞌ lamineꞌ ha do minaaꞌ nene mo neineꞌza okonga mukiꞌ lamineꞌ ha do minaineꞌ neꞌmo mudise vo olokuꞌ minaaꞌ akaloꞌ geleꞌmize molalineꞌ nene geikumuꞌ lamineꞌ amoloseive. Nemuꞌ nene veka goloso nene kuluhize hulaineꞌ gilivosa monovo goloso nene hulozo. ");
INSERT INTO aso_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Idoꞌ anga zamela neꞌmo lihime daaꞌ akaloꞌ geleꞌmize nomolavo ma aꞌmine anga neꞌmo geleꞌmize goloso ogavo Oꞌmosoꞌmo olokuꞌ hulo-gedalize. Aꞌmine monovo goloso hulilineꞌ neꞌmo anga mene huko hulaineꞌ gelavo minelineꞌ nene lamineꞌ oloseive. Idoꞌ okonga mukiꞌ lamineꞌ ha do minaaꞌ nene mo neineꞌza neꞌmo mudise olokuꞌ vaaꞌ akaloꞌ geleꞌmize molalineꞌ nene lisiheꞌ o-gedamoloseive. Nemuꞌ anga nene huko hulaineꞌ gilivo lihime daaꞌ akaloꞌ nene vamozo. ");
INSERT INTO aso_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Moseꞌ lo huko lineꞌ gamazi ma neꞌmino neive: Ve maliꞌmo aza elenahine hulo-delove lo ma veneꞌ mene mo hulo-dekuve lo luhuvo gizo emosa hulo-delive. ");
INSERT INTO aso_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ne neineꞌza neniꞌ ma lo-lengemeloze: Ve ma elenaho gopo monamo nolineꞌ initeꞌ mamuꞌ haza hulo-delineꞌ neꞌmo louꞌ gamazi ma veneꞌ vadingine huli ve maloꞌ vamilo lo minineꞌ ma nene avutoꞌ ogo ve gohiloꞌ vilineꞌ nene lihime daloseive. Dalineꞌ nene gomuꞌ vanahi monovo neꞌmo lihime mineleseive. Idoꞌ ve gohi maliꞌmo aꞌmine veneꞌ dalineꞌ nene louꞌ gamazi ve maliti eleꞌningine damilo lo minineꞌ ma nene avutoꞌ ogo lihime daloseive. ");
INSERT INTO aso_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Idoꞌ louꞌ gamazi gozopoꞌ avotingine tiꞌ li li-ngimaniꞌ nesi mo gilikeniꞌ ma neive: Initeꞌ neꞌmine olosuve lo anga dizo lo hukolo ma soza lamozo. Oꞌmosomuꞌ initeꞌ olosuve lo anga dizo lo huko lo-emanidoꞌ nene ha olosane. ");
INSERT INTO aso_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ne neineꞌza neniꞌ ma lo-lengemeloze. Lingine initeꞌ mamuꞌ adine dizi lamineꞌ nolune li kekeꞌ mo li hukamilo. Okulumoꞌ nene Oꞌmosoꞌmo gizebo o-ledo minaaꞌ neineꞌ moꞌmosiꞌve neinako nemuꞌ okulumokuꞌ li izi adine dizi lamineꞌ nolune li li hukilizaniꞌ nene Oꞌmosomuꞌ li adine dizaniꞌ geleleseinako nemuꞌ neꞌmine amilo. ");
INSERT INTO aso_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Idoꞌ misubo nene Oꞌmosoꞌmo gizene lise minaaꞌ neineꞌ initeꞌve nenako nemuꞌ misubouꞌ li izi adine dizi lamineꞌ nolune li li hukamilo. Idoꞌ Zelusalemi ebeꞌ nene Guvelesi ve nabaꞌmi numuno ebeꞌve nenako nemuꞌ Zelusalemi ebekuꞌ li izi adine dizi lamineꞌ nolune li li hukamilo. ");
INSERT INTO aso_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Idoꞌ lamineꞌ nolune li lengiꞌ godotingukisi li izi lamilo. Lamineꞌ nolune lo godoteuꞌ lo izo loloneꞌ nene geni amivo ha lolosune li gili nizahe. Lingine godotine zopovo hamokisi mokonope gonobupe minineꞌ nene gonobupe mokonope loloꞌ ilive likevo neꞌmine amoloseive. Langisetine godotine zopovo nene ngeli di atoꞌ amilisave. Oꞌmoso hamoꞌ neꞌmo ha oloseive. Nemuꞌ nene godotinguꞌ li izi lamineꞌ nolune lilizaniꞌ nene Oꞌmosola li izi laniꞌ geleleseinako nemuꞌ godotinguꞌ li izi adine dizi gamazi mamuꞌ lamineꞌ nolune li li hukamilo. ");
INSERT INTO aso_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Initeꞌ mamuꞌ oꞌve noluve lo ma mo oꞌve laminetoꞌ lozo. Idoꞌ oo noluve lo ma nene mo oo laminetoꞌ lozo. Idoꞌ initeꞌ masi masi lo molo lo huko lilineꞌ nene Satanilatiꞌ sotoꞌ ineꞌ lolosane. ");
INSERT INTO aso_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Moseꞌ lo huko lineꞌ gamaziuꞌ tiꞌ lo neineꞌ gili nizaniꞌ ma neive. Idoꞌ ve maliꞌmo ve maliꞌmi vele hizo likavo ma eze vele hizi likilo. Idoꞌ vele gavulo bele ledavo ma eze vele gavulo bili ledilo. ");
INSERT INTO aso_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Neꞌmine lo neineꞌ ma neineꞌza naza idise ma lo-lengemelove: Lingine ma nilingibilavo ma ingine di tiꞌni ngibilamilo. Idoꞌ gatine zamela niizavo ma hela adavalasi izilizaze. Mine velepeꞌ izilo. ");
INSERT INTO aso_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Idoꞌ sioti ngomo lulouꞌ izikaniꞌ nene dalone li gonitoꞌ lengeleꞌmize nimilavo ma saketitine izikaniꞌ nesi di ngimilo. ");
INSERT INTO aso_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Idoꞌ ve malite heneniꞌine gihi-ngidi aka liꞌnibe gidiniloꞌ di vilo nilavo ma aka haꞌna gidini nesi ha gihi-ngidi vilo. ");
INSERT INTO aso_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Idoꞌ ve malite lengitatiꞌ initeꞌ ma dalone li longoꞌ navo ma ha ngimilo. Idoꞌ lengitatiꞌ initeꞌ ma do vo do-lengede mino alingeꞌ do lengemelone nilavo ma aꞌmanapa igi mehedine ngimamilo. ");
INSERT INTO aso_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Idoꞌ tiꞌ li laaꞌ naniꞌ ma mo gili nizaniꞌ ma neive: Lengiꞌ zuho avita minaniꞌ nene lutine ngimilizaniꞌza biluvatine nene lutine ngimamilo. ");
INSERT INTO aso_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Neꞌmine li laaꞌ naniꞌ ma nene neineꞌza neniꞌ ma lo-lengemelove: Biluvatine nene lutine ngimi goboni mili-lingidilizavemuꞌ nene Oꞌmosoꞌmo engita minelive li Oꞌmosola lilo. ");
INSERT INTO aso_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Neꞌmine ilizaniꞌ nene Okulumokuꞌ metibi izipahala zuho gihile minilisave. Ee, Okulumokuꞌ metibo Oꞌmoso aza eveneꞌ do kegeso ve laminekovoꞌ do lamineꞌ o-ngedo eveneꞌ goloso lovo imaaꞌ ave nene do lamineꞌ o-ngedamo hulo-ngedesaꞌmineꞌza eiꞌ lavo hoꞌve neꞌmo silingengeꞌneꞌve hulo eveneꞌ golososi laminekisi nene do lamineꞌ o-ngedaaꞌ neive. Idoꞌ lavo goline nene izo eveneꞌ lisiheꞌ lamineꞌ minanikisi minamanikisi nene do lamineꞌ o-ngedaaꞌ neive. Nemuꞌ nene lingine aꞌmineꞌmine igi lovo vetine nene lutine ngimi goboni mili-lingidaaꞌ navemuꞌ Oꞌmosola li neꞌmine igi di lamineꞌ i-ngidilizaniꞌ nene eze emeni damenisi mini Okulumokuꞌ metibi izipahala gehepeve minilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Idoꞌ lingine luꞌine lingimaaꞌ navevoꞌ nene lute ngemesoꞌ Oꞌmosoꞌmo meni lemeleseive li gilaaꞌ nahe. Lingine takisi daaꞌ navemuꞌ eveneꞌ goloso nizave li-ngidaaꞌ nave idoꞌ inginesi aꞌmineꞌmine igi luꞌine ngimavevoꞌ ngimaaꞌ naniꞌza lingine nene ma ngivileꞌ igi monovo lamineꞌ ma damanako Oꞌmosolatiꞌ meni ma damilisave. ");
INSERT INTO aso_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Idoꞌ lingine lengiꞌ zuhovoꞌ zogo mili-ngidi gekeꞌ vokeꞌ li-ngidaaꞌ naniꞌ nene lingine eveneꞌ gohi mukiꞌ minaniꞌ ngivileꞌ ogo monovo lamineꞌ ma daaꞌ none li gilaaꞌ nahe. Eꞌe, heta atoꞌ ve Oꞌmosomuꞌ gilamave inginesi aꞌmineꞌmine igi engiꞌ zuho zogo mili-ngidi gekeꞌ vokeꞌ li-ngidaaꞌ nanako nemuꞌ lingine atoliꞌmine igi monovo lamineꞌ nene ma damave. ");
INSERT INTO aso_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nemuꞌ nene Okulumokuꞌ metibo lisiheꞌ lamineꞌ goloso neineꞌ neꞌmini linginesi lisiheꞌ lamineꞌ goloso minilo. ");
INSERT INTO aso_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lingine monoꞌ lamineꞌ di minaaꞌ naniꞌ nene evenelite di naba i-lingidilizave lisavoꞌ di minamilo. Evenelite ma ningilizahe ningamilizahe li minilizaniꞌ nene Okulumokuꞌ metibo neꞌmo meni ma nene mo molo-lengedamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nemuꞌ nene gaza eveneꞌ ma nasahiliꞌ noo-ngedo ma eveneꞌ luꞌine sitakisi velite monoꞌ numunguꞌ nehe maketiloꞌ nehe eveneꞌ nasahiliꞌ i-ngidilisa eveneꞌ ningi lopoꞌni lilizave li hosoꞌ izaaꞌ naniꞌ neꞌmine nene amilo. Naza lamineꞌ ma lo-lengemeloze: Eveneꞌ ningilizahe li eveneꞌ sotoꞌ nasahiliꞌ i-ngidikevo evenelite ningi di naba i-ngidaniꞌ neꞌmo alingeꞌ daliza meniꞌine gidini ma nene mo loloꞌ ogavo mo dikeve. ");
INSERT INTO aso_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mo dikeniꞌza nene neꞌmine ami eveneꞌ ma nasahiliꞌ i-ngidili ma nene lengiꞌ zuho laminelitesi gilikelizaze li minisa ");
INSERT INTO aso_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","sunoꞌ nasahiliꞌ i-ngidilo. Neꞌmo nasahiliꞌ i-ngidilizaniꞌ nene sunoꞌ initekisi ningo gelaaꞌ ive metibo Oꞌmoso neꞌmo meni lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Idoꞌ lingine Oꞌmosola lili ma eveneꞌ luꞌine sitakisi minadite oꞌmotoꞌ nehe monoꞌ numunguꞌ nehe eveneꞌ mukiꞌ di geseꞌ igaꞌ aniꞌ ebetoꞌ mini ma ningilizahe li Oꞌmosola laaꞌ naniꞌ neꞌmine igi lamilo. Naza lamineꞌ ma lo-lengemelove: Ingine eveneꞌ mukiliti veꞌnidoꞌ neꞌmine aniꞌ neꞌmo alingeꞌ daliza meniꞌine mo dikeve. ");
INSERT INTO aso_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nemuꞌ nene gaza Oꞌmosola lolo ma gasivoꞌ numungauꞌ sunoꞌ vo akahe gizo mino aꞌmine sunoꞌ numuno lulouꞌ naninguꞌ minive mahine Oꞌmoso nene opoꞌni lozo. Neꞌmine oganivo sunoꞌ initeꞌ ningaaꞌ ive maho Oꞌmoso aza meni gemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Idoꞌ lingine Oꞌmosola nilii ma soza Oꞌmosomuꞌ gilavete Oꞌmosotela gohi lo gohi lo univo gele lemelive li gamazi vaiꞌ mukiꞌ likaꞌ likaꞌ igi laaꞌ naniꞌ neꞌmine igi lamilo. ");
INSERT INTO aso_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nanitekumuꞌ lilisa nahe nemuꞌ metibo nene gomuꞌ gelavosa alingeꞌ nene eita lilisanako nemuꞌ nene gamazi mukiꞌ hazamuꞌ lami aꞌmine Oꞌmoso gihilemuꞌ gilamavete igaꞌ naniꞌ neꞌmine amilo. ");
INSERT INTO aso_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lingine Oꞌmosola neꞌminisa lilisave: Okulumokuꞌ meteho, Okulumokuko igaꞌ nadiꞌmine ogo laza misubolasi mene aꞌmineꞌmine olobo. Adoꞌ geiꞌ guliveka nene eveneꞌ vaiꞌ gelekunivo dizosa miniliho. ");
INSERT INTO aso_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Idoꞌ eveneka gizebo o-ledelineꞌ nene lelita mudise sotoꞌ iliho. Idoꞌ geiꞌ lukalokovoꞌ ogo molo minelobo. ");
INSERT INTO aso_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Idoꞌ idise naloneꞌ nosoꞌ nitete lemezo. ");
INSERT INTO aso_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Idoꞌ laꞌlise lihime di li-daveti lihimeꞌine mo hulo-ngedekuneꞌ nenako aꞌmineꞌmine ogo gaza leliꞌ lihimete hulo-ledezo. ");
INSERT INTO aso_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Idoꞌ lemenguꞌ nene leleꞌmize molamo goloso melehi anauꞌ voloningutiꞌ nene leleꞌmize tiꞌno do luꞌ izezo lilisave. ");
INSERT INTO aso_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Idoꞌ lingine eveneꞌ lihime di-lingidaveti lihimeꞌine huli-ngidilizaniꞌ nene Okulumokuꞌ metibo aza lengiꞌ lihimetinesi hulo-lengedeleseiha ");
INSERT INTO aso_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","eveneliti lihimeꞌine huli-ngidamilizaniꞌ nene metibo aꞌmineꞌmine ogo lengiꞌ lihimetinesi hulo-lengedamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Idoꞌ monokumuꞌ ve lii nosoꞌ niteꞌ malise ili ma luꞌine sitakisi evenelite igaꞌ naniꞌ neꞌmine igi muheleꞌ i minamilo. Aꞌmine ve monokumuꞌ ve li nosoꞌ niteꞌ malise igi ma ingine initeꞌ malise ogo noneꞌ nene eveneꞌ ningi gililizave li veꞌine goꞌine di lamineꞌ ami muheleꞌ aheleꞌ igivoꞌ minaaꞌ nave. Naza lamineꞌ ma lo-lengemelove. Ingine eveneꞌ mukiliti veꞌnidoꞌ neꞌmine aniꞌ neꞌmo meniꞌine nene mo dikeve. ");
INSERT INTO aso_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Idoꞌ gaza monokumuꞌ ve lo nosoꞌ niteꞌ malise o no ma eveneꞌ mukiliti veꞌnidoꞌ muheleꞌ ogo monamo goka veka nosoꞌ izo madungauꞌ uveli holo do lamineꞌ ogo monezo. ");
INSERT INTO aso_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Neꞌmine oganivo eveneꞌ nete nosoꞌ niteꞌ malise o nane li ningi gilamavo sunoꞌ neꞌmine olosaba sunoꞌ mino sunoꞌ minineꞌ initeꞌ ningaaꞌ ive maho neꞌmo ningo meni gemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Lingine misubouko mene heneni nganeni mo milamilo. Giꞌningonite hukikevo idoꞌ gaba hitavo idoꞌ gumine ve nete numuno izi veꞌvizi dizi daaꞌ naze. ");
INSERT INTO aso_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nemuꞌ nene heneni nganenitine nene giꞌningonite hukamavo gaba hitamivo gumine vete damilizaniꞌ o minineꞌ ebeꞌ Okulumokuko nene milalo. ");
INSERT INTO aso_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lutine nene henenitine minelida minelineꞌ nenako nemuꞌ nene henenitine Okulumokuko milalo. ");
INSERT INTO aso_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Eveneꞌ voloneꞌ akate nene vete neꞌmo oloꞌ liviꞌ neꞌmino mino do sotoꞌ o-ledaaꞌ neive. Idoꞌ lukaliꞌmi vele lamineꞌ ha minelineꞌ nene Oꞌmosoꞌmo okonga luka mukiꞌ nene hize labanaꞌ ele-gedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Idoꞌ lukaliꞌmi veleꞌve goloso o nolineꞌ neꞌmo nene okonga lukauꞌ nene litiꞌmusovoꞌ ize vaiꞌ lo mineleseive. Ee, labanaꞌ ele-gedelineꞌ initeꞌ nene goloso ogavo lukauꞌ litiꞌmuso izelineꞌ nene, agae, mo litiꞌmuso gehepeve golosouꞌ minelesane. ");
INSERT INTO aso_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Idoꞌ ve maliꞌmo gono eveneꞌ sitatoꞌ ngelo ma damoloseive. Aꞌmine ve sitatoꞌ gono dalosa ilineꞌ nene ve hamota ma lulo emeleseiha sitaꞌ nene lulo ngelo ngemamoloseive. Mala lulo emelineꞌ nene mala lulo emamoloseive. Idoꞌ ma veloꞌ giꞌmizo eze gono amuzo molo dalineꞌ nene ma vemuꞌ goseleꞌ belavo gono gamazi lo-delineꞌ nene ngelo damoloseive. Aꞌmineꞌmine ogo gaza moniloꞌ gono do luka aꞌmine moniuꞌ molo lamineꞌ ilineꞌ nene luka Oꞌmoso emo gamazi lidoꞌ gele do eze gelekeleꞌ o-daaꞌ anive ngelo minamolosane. ");
INSERT INTO aso_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nemuꞌ naza tiꞌ lo nolo-lingimuve: Gaꞌnaliꞌmo helamo vetesi ha mineloningumuꞌ nosoꞌ niteꞌ nene nani nalonivo lii gopo gatine gilaaꞌ naniꞌ nene alamilo. Idoꞌ okodidokumuꞌ nene naniteꞌ ngolalonivo li gopo gatine gilaaꞌ naniꞌ nesi nene mo alamilo. Vetesi minevoꞌ alevoꞌ ogo minaaꞌ neꞌmo nosoꞌ niteꞌ nene ivileꞌ ogosa initeꞌ naba neivo idoꞌ okode neꞌmosi nene okodeloꞌ initeꞌ nene ivileꞌ ogo initeꞌ naba nenaze. Nemuꞌ nene gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Idoꞌ lingine veleta pateli monaaꞌ naniꞌ nama neti monovo nemuꞌ nene ma gatine giliꞌ nalo. Ingine naliza nosoꞌ niteꞌine nene zuhoꞌ isaꞌmaniꞌ nenako nemuꞌ nene nosoꞌ niteꞌ dolizi di milaaꞌ numunguꞌ nene milisaꞌmaniꞌza Okulumokuꞌ metibo neꞌmo nene nosoꞌ niteꞌ ngemaaꞌ neive. Neꞌmine o-ngedaaꞌ neineꞌza lengiꞌ nete ngivileꞌ igi initeꞌ naba nizanako Oꞌmosoꞌmo lengikumuꞌ nene ha gele minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Lengikutiꞌ ve zaholiꞌmo initeꞌ matakumuꞌ gopo gala ma gele do vo minelidiꞌmo eze mino molo ilineꞌve nene do haꞌna ilive. Mo ngelo ngomosi ma do haꞌna amoloseize. Nemuꞌ nene gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Idoꞌ okodidoꞌ initekumuꞌ nene nanimuꞌ gopo gatine gilaaꞌ nave. Guviseuꞌ guvovo initeꞌ nene dizi guvovo igaꞌ naniꞌ nemuꞌ nene ningi gililo. Ingine gono di okoꞌnidoꞌ initeꞌ nene ma ongoti ngilisaꞌmaniꞌza Oꞌmosoꞌmo do lamineꞌ o-ngedaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gozopoꞌ guvelesi ve Solomoniꞌ nene okoꞌnoloꞌ initeꞌ lamineꞌ goloso ngolaaꞌ ineꞌza naza ma lo-lengemelove. Aza ngolaaꞌ ineꞌ initeꞌ nene lamineꞌ minaniꞌza guvovo igaꞌ naniꞌ initeꞌ nene mo ngivileꞌ isaꞌmaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Idoꞌ aꞌmine guvovo initeꞌ nene initeꞌ lamineꞌ neꞌmine minamo gamene haꞌna minesaꞌmive. Idise ha minelineꞌza aizeꞌ nene gokoꞌ lavo evenelite olokuꞌ di gizilisave. Neꞌmino neineꞌza Oꞌmoso neꞌmo aꞌmine guvovo initeꞌ nene do lamineꞌ goloso ogaꞌ neive. Oꞌmoso neꞌmo haza initeꞌ aꞌneꞌmine nene ha do lamineꞌ o-ngedaaꞌ neineꞌ nenako lengiꞌ nene guvovo initeꞌ ngivileꞌ igi initeꞌ naba nizaniꞌ nenako okodidoꞌ initeꞌ nene ma lengemamilidoꞌ o neihe. Ha lengemelidoꞌ o neive. Nemuꞌ nene lingine amuzo mili Oꞌmosomuꞌ gili eleꞌvoleꞌ ilizanako gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nemuꞌ nene lingine nosoꞌ niteꞌ zatiꞌ nalone idoꞌ okodeloꞌ initeꞌ zatiꞌ dalone li gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nevoꞌmine manaꞌmine gaꞌine nene Oꞌmosoꞌmi zuho minamave nete gili aꞌneꞌmine initeꞌ visetoꞌ minaaꞌ nave. Okulumokuꞌ metibo neꞌmo nene aꞌmine dalisa gilaniꞌ initeꞌ ne dami haza ma minamilisave lo gele neive. ");
INSERT INTO aso_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ne neineꞌza initeꞌ maloꞌ maloꞌ olihe lutine milami Oꞌmosoꞌmo gizebo o-ledeli monovolokisi monovo lisiheꞌvelokisi nene gomuꞌ lutine mili giliꞌ li milalo. Neꞌmine igi Oꞌmosoꞌmo gizebo o-ledeli monovolokisi monovo lisiheꞌvelokisi lutine mili visetoꞌ minilizaniꞌ nene aꞌmine initeꞌ nesi lehize-lengedo aꞌmine okodine losuvoꞌmi initeꞌ mataꞌ nesi nene ha lehize-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aizeꞌ sotoꞌ ilineꞌ initeꞌ nene aizekumuꞌ gizebo ha o neinako lingine idise nene aꞌmine aizeꞌ initekumuꞌ gopo gatine gilamilo. Idise sotoꞌ ilineꞌ initekutiꞌ geni ma sotoꞌ ilineꞌ nene idise gihiliza votigileloꞌ o neivo aizeꞌ nesi initeꞌ ma sotoꞌ ilineꞌ nene asiꞌve gamene aizeꞌ neꞌmo gihiliza votigileloꞌ lengemelidoꞌ o neinaze. Aizeꞌ nadolone li gopo gatine gili minavo lingivizalive. Oꞌmosoꞌmo initeꞌ matatine lehize-lengedeleseize. Neꞌmine manaꞌmine initekumuꞌ nene gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Oꞌmosoꞌmo lengiꞌ monovomuꞌ izeꞌ molo dovo ledevoꞌ ogo lamilingisi lingine eveneꞌ maliti monovo divi lediviꞌ igi ingine monovomuꞌ izeꞌ mili lamilo. ");
INSERT INTO aso_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Eveneliti monovomuꞌ izeꞌ mili lilizaniꞌ nene aꞌmineꞌmine ogo Oꞌmosoꞌmo lengiꞌ monovomuꞌ izeꞌ molo loloseive. Idoꞌ lingine eveneꞌ i-ngidilizaniꞌ votigilelokovoꞌ aza aꞌmineꞌmine o-lengedeleseive. Nemuꞌ nene monovoꞌinemuꞌ izeꞌ mili lamilo. ");
INSERT INTO aso_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Idoꞌ gaza veka gihileuꞌ za lana naba vo neineꞌ mamuꞌ nene ningo gelamo ve maliꞌmi veleuꞌ initeꞌ ngomo lasolo vo neineꞌ nene nanimuꞌ ningaaꞌ nane. ");
INSERT INTO aso_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Idoꞌ geꞌmo veka gihileuꞌ za lana naba vo neivosa gaza ve mamuꞌ veka gihileuꞌ initeꞌ ngomo vo neineꞌ nene do hulo-gedelove lo lo-delinidoꞌ o neihe. Ne nomive. ");
INSERT INTO aso_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gaza soza sunolavoꞌ monaineꞌ mene veka gihileuꞌ za lana vo neineꞌ nene gomuꞌ do hulokosavoꞌ nene maliꞌmi vele gihileutiꞌ initeꞌ lasolo vo neineꞌ nene ninge guno ogo do hulo-delineꞌ o neive. Ee, monovo goloso naba daaꞌ naineꞌ nene gomuꞌ hulosavoꞌ maliꞌmo monovo goloso ngomo ma do nolineꞌ nene do lisiheꞌ o-delesane. ");
INSERT INTO aso_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lingine monoꞌ nene eveneꞌ goloso gulo neꞌmine minaniꞌ engiꞌ nene ngimamilo. nGimilizaniꞌ ingine dami velepeꞌ izi lingibililisave. Idoꞌ aꞌmine gonoliseꞌvesi initeꞌ meniꞌve dize neineꞌ nene ize ngimamilo. Ingine aꞌmidoꞌ lisi lana igi di goloso ikelizaze. ");
INSERT INTO aso_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Idoꞌ initeꞌ ma dalone li Oꞌmosola lilizave mukiꞌ nete nene initeꞌ ha dalisave. Idoꞌ Oꞌmosolatiꞌ nene initeꞌ ma viseꞌ ilizave nete nene ha ningilisave. Idoꞌ akaheloꞌ okohoꞌ izilizave nene Oꞌmosoꞌmo ha siꞌze-ngedeleseive. Nemuꞌ linginesi Oꞌmosola initeꞌ mamuꞌ longoꞌ ilizaniꞌ nene ha lengemeleseive. Idoꞌ viseꞌ ilizaniꞌ nene Oꞌmosoꞌmo ha lengelebizeleseive. Idoꞌ akaheloꞌ okohoꞌ izilizaniꞌ nene Oꞌmosoꞌmo ha siꞌze-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ve ma lengikutiꞌ gipeleꞌmo sikonimuꞌ lilineꞌ nene geheni mene do nozo lo emelihe. Ne nomive. ");
INSERT INTO aso_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Idoꞌ aꞌmine gipele neꞌmo alahaꞌ ma nalove lo lilineꞌ nene sataꞌ ha do emelihe. Ne nomive. ");
INSERT INTO aso_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lingine nevo ha eveneꞌ golososi nilizaha izipahatine zuho nene ha gizebo lamineꞌ i-ngidi initeꞌ lamineꞌ nene ha ngimaaꞌ nave. Nemuꞌ nene linginesi lingivileꞌ ogo lamineꞌ minive Okulumokuꞌ metibo neꞌmo nene eveneꞌ ingine vokuꞌ li ezela laaꞌ nave nene initeꞌ lamineꞌ ma ngemamilihe. Oꞌve. Mo atoliꞌmine ogo ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lingine eveneꞌ malite neꞌmine manaꞌmine i-lidilizave li gili ma nene engikisi aꞌmineꞌmine i-ngidilo. Neꞌmine ilizaniꞌ nene Moseꞌ gizineꞌ louꞌ gamazi mukiꞌ nesi idoꞌ gili dalizangumuꞌ ve li polohetelite gizaniꞌ gamazi mukiꞌ maꞌmi mehene ne neive. ");
INSERT INTO aso_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Simeꞌ naaꞌ ebeliꞌmi gateni nene naba neive. Idoꞌ akaꞌve nesi naba goloso neive. Neꞌmino minavo aꞌmine akaliꞌmi gatenguꞌ nene eveneꞌ mukiꞌ vi hilaaꞌ nave. Neꞌmine igaꞌ naniꞌza vi minevoꞌ minevoꞌ ngemeni dameni daliza akaꞌmi gateniꞌve nene ngomo lasolo neive. Idoꞌ akaꞌve nesi ngomo lasolo goloso minavo eveneꞌ hamo hamoꞌ nete aꞌmine aka nene viseꞌ igi ningi vaaꞌ nave. Nemuꞌ nene lingine gateni ngomouꞌ nene dizilo. ");
INSERT INTO aso_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Soza saza li Oꞌmosoꞌmi gamazi lo sotoꞌ ogaꞌ unive polohete none laaꞌ avemuꞌ lingine ningisa minilo. Ingine loposo gulo eveneꞌ ngibilaaꞌ aniꞌ gulo neꞌmine luꞌine golososi mini linginela alizaniꞌ nene engiꞌ monovo di haleki ngibilamaaꞌ ave sipisipi ize gidini alisanako nemuꞌ engikumuꞌ eheꞌ igi gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Igi mili ilizaniꞌ nene gihile lamineꞌ izelihe izamilihe nene ningisa engiꞌ monovo nene ningi gililisave. Za lamineliꞌmi gihileꞌve nene za golosoloꞌ izavo nelotiꞌ ha dalizahe. ");
INSERT INTO aso_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Oꞌve. Za lamineliꞌmovoꞌ gihile lamineꞌ izaaꞌ neivo za goloso neꞌmo gihile goloso izaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Za ma lamineꞌ nolineꞌ nene gihileꞌve goloso ngelo izamoloseive. Idoꞌ za ma goloso nolineꞌ nene gihileꞌve lamineꞌ ngelo ma izamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Neꞌmino neineꞌ nenako za gihile lamineꞌ izisaꞌmaniꞌ za nene huki olokuꞌ gizaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Idoꞌ za neꞌmine nizanako ingine soza monoꞌ laaꞌ ave igi mili ilizaniꞌ gihile izelineꞌ nene lingine ningi engiꞌ monovo nene ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Idoꞌ eveneꞌ ma nete nenikumuꞌ Guvekasi ve, Guvekasi ve, laaꞌ nahe. Engiꞌ netiꞌ linge ma nene Oꞌmosoꞌmo gizebo o-ngedelinguꞌ vi hilamavo Okulumokuꞌ meꞌnehine gelekeleꞌ i-di eiꞌ luloloꞌ igi mili minaaꞌ niilizavevoꞌ eiꞌ gizebouꞌ vi hilalisave. ");
INSERT INTO aso_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ee, gamene nabala eveneꞌ mukiꞌ nete tiꞌ li li-nimilisave: Guvekasi ve make, geiꞌ vekamuꞌ ogo monoꞌ lo-ngemaaꞌ uneꞌ ma ve. Idoꞌ geiꞌ vekamuꞌ ogo sikalahuꞌ goloso eveneꞌ luꞌninguꞌ minaniꞌ nene ngimiselo hulaaꞌ uneꞌ ma ve. Idoꞌ geiꞌ vekamuꞌ ogo ato atoꞌ suno mukiꞌ nene do sotoꞌ ogaꞌ uneꞌ ma ve. ");
INSERT INTO aso_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Neꞌmine li-nimilizaniꞌza neꞌmine lo laminetoꞌ lo-ngemelesuve: Lingine goloso niteꞌ diꞌmi monaaꞌ ave lingine neze zuho ningaaꞌ uve ma nizamaze. Vilo. ");
INSERT INTO aso_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","Ve maliꞌmo numuno ma gizineꞌ nene otohato ogaꞌ iveꞌmo numuno geheni nabaloꞌ giliꞌ lo minelidoꞌ gizavo goline naba izo noso velo hepeꞌ naba elo ogo numuno bilineꞌza numuno nene geheni neꞌmo do giliꞌ lavo lemo ongamo amuzo molo ote minineꞌ. Idoꞌ eveneꞌ ingine neze gamaziꞌne gili di luvodoꞌ luvodoꞌ igi mili eꞌmetilizaniꞌ nete aꞌmine numuno gizive neꞌmine mini otohato igaꞌ ave minilisave. Minilisanako neniꞌ gamaziꞌne luvodoꞌ luvodoꞌ igi mili ilizaniꞌ neꞌmo igi mili ilizaniꞌ nene lemo ongamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Idoꞌ ve gohi maliꞌmo numuno ma gizineꞌ nene aza ve negi otohato amiveꞌmo numuno amuzo molo minamilidoꞌ gepeloꞌ gizavo goline izo noso velo hepeꞌ naba elo ogo numuno nene belavo numuno nene, agae, do goloso ogo lemo pouꞌ lo izevo nguꞌvosovoꞌ ogo onganiꞌ. Idoꞌ eveneꞌ ingine neze gamaziꞌne gilii gili huli luvodoꞌ luvodoꞌ eꞌmetamilizaniꞌ nete aꞌmine numuno gizive neꞌmini negivoꞌ minilisave. Ee, luvodoꞌ luvodoꞌ igi eꞌmetamilizaniꞌ nene negivoꞌ minilisave. ");
INSERT INTO aso_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Idoꞌ Izesuꞌ aza gamazi mene lo osuꞌ lavo nemuꞌ eveneꞌ mukiꞌ ingine gili voꞌine vavo upuhoꞌ aniꞌ. Ee, aza monoꞌ apize ngimineꞌ mene engiꞌ avoꞌningeliti monoꞌ gamazi apizi ngimaaꞌ avete apizi ngimaaꞌ aniꞌ neꞌmino apize ngemamo asi gamazi meleho neꞌmineꞌmo apize ngimineꞌ gelavo nemuꞌ voꞌine vavo upuhoꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Izesuꞌ aza gololotiꞌ oto lemo ogavo eveneꞌ mukiꞌ goloso nene eꞌmeti vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eꞌmeti nivavo ganadise gize dave maliꞌmo Izesuda ogo obuvolo hize emo tiꞌ lo lo-imineꞌ: Guvekasi ve, gaza do lamineꞌ o-nedelineꞌ amuzokasi naineꞌ nene naza mo gele mino do lamineꞌ o-nedeline lo gele nouve. Gaza do lamineꞌ o-nedelesa gele nabe. ");
INSERT INTO aso_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Neꞌmine lavo Izesuꞌ aza ana hulo molo okoꞌnoloꞌ nohito tiꞌ lo lo-imineꞌ: Naza do lamineꞌ o-gedelesa gele nouve. Nemuꞌ gaza lamineꞌ ozo. Neꞌmine lavo ganadise neꞌmo liteꞌ lo hulo-do vavo lamineꞌ gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lamineꞌ gelavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gele nabe. Gaza lamineꞌ aineꞌ monovo nene eveneꞌ hamokisi mo lo-ngemamozo. Evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive neꞌmo ganadise okongalotiꞌ hulo-gedo vineꞌ nene ningo lo sotoꞌ ogavo gaza lamineꞌ aineꞌ nemuꞌ nene evenelite ningi gililizangumuꞌ ve lo neꞌmine ozo: Ganadise gizi dave ingine lamineꞌ igi ma ize initeꞌ neꞌmine neꞌmine Oꞌmoso imilisave lo Moseꞌ lo huko lidoꞌ nene eꞌmeto evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nene initeꞌ ma Oꞌmoso olokuꞌ gize emelingumuꞌ nene do vo emezo. ");
INSERT INTO aso_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Izesuꞌ aza Kahanaumi numuno ebekuꞌ novivo Loma amiliti gizebo ve ma aza Izesuda ogo longoꞌ ogo ");
INSERT INTO aso_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","tiꞌ lo lineꞌ: Guvekasi ve, neniꞌ gelekeleꞌ izipeꞌne aza nene amuzolo helavo numuda amuzolosi nomivo ongo mino mulumo gono goloso do neineꞌ lae. ");
INSERT INTO aso_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Naza ha vo do lamineꞌ o-delesuve. ");
INSERT INTO aso_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lavo amiliti gizebo ve aza tiꞌ lo Izesuꞌni lo-imineꞌ: Naza eveneꞌ goloso nouvonako aꞌneꞌmineꞌmi numuꞌneuꞌ alinidoꞌ lisiheꞌ amane. Nemuꞌ nene vamo ha gamazivoꞌ lo lamineꞌ ozo lanivo gelekeleꞌ izipeꞌne nene lamineꞌ ilive lo gele nouve. ");
INSERT INTO aso_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Idoꞌ lamineꞌ ilive lo gele nouvoniꞌ nene naza nene eveneꞌ maliti gizeboloꞌ nouve. Idoꞌ neze gizeboloꞌ nesi ami ma nizave. Nemuꞌ nene engikutiꞌ ve mamuꞌ vozo lokuvo ha voloseive. Idoꞌ mamuꞌ ano loloniꞌ nene ha aloseive. Idoꞌ gelekeleꞌ izipeꞌne nene neꞌmine ozo loloniꞌ ha oloseive. Idoꞌ aꞌmineꞌmine ogo gaza lanivo siki initeꞌ neꞌmo geiꞌ gamazi ha gele do gelekeleꞌ izipeꞌne nene ha hulo-do voloseive losa gele nosa noluve. ");
INSERT INTO aso_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lavo Izesuꞌ aza gamazi nene gelo aizo, lo gelo eveneꞌ eꞌmeti vave mukiꞌ nene tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ nolo-lingimuve. Oꞌmosomuꞌ gili eleꞌvoleꞌ igaꞌ ave gehepeve ve lave Isilaeleꞌ aleve lengikutikisi nene heta atoꞌ ve meneꞌmo gele eleꞌvoleꞌ ineꞌ neꞌmini ve hamolitesi ma gili eleꞌvoleꞌ avo ma ningamuvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nemuꞌ nene nolo-lingimuve. Isilaeleꞌ aleve minamave hotatiꞌ ve hoꞌ dizaaꞌ idatiꞌ ve idoꞌ hoꞌ lemaaꞌ idatiꞌ ve mukiꞌ ingine Oꞌmosoꞌmi gizebouꞌ imi hili mini Abalahamule Zakobole Isakalesi nosoꞌ niteꞌ nii ngolize izi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Minilisaniꞌza Oꞌmosoꞌmo eiꞌ gizebouꞌ vi hili eze zuho minilizave lo lengeleꞌmize molaniꞌ Isilaeleꞌ aleve lingine nene hulo heta ogavo litiꞌmuso gehepeveuꞌ vi mini ive nama igi mulumo gili vetine ingihi langoloꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Neꞌmine lo Izesuꞌ aza amiliti gizebo ve tiꞌ lo lo-imineꞌ: Gaza numungala vozo. Gele eleꞌvoleꞌ aineka ma nene sotoꞌ o-gemeleseive. Lavo gelekeleꞌ izipe nene lineꞌ gamene gehepeveloꞌ nene lamineꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Neꞌmine ogo Izesuꞌ aza Petoloꞌ numuꞌveuꞌ dizo Petoloꞌ elenahi izeleho nene okoꞌnoloꞌ oloꞌ lavo ongo neivo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ningo Izesuꞌ aza analoꞌ davo okoꞌnouꞌ oloꞌ lineꞌ nene osuꞌ lo-dineꞌ. Osuꞌ lo-davo oto Izesuꞌni nasahiliꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Idoꞌ nivengaꞌ molavo luꞌninguꞌ sikalahuꞌ goloso minive ma Izesuda ngeleꞌmizi ikevo gamazi lo-ngedo aꞌmine sikalahuꞌ goloso nene ngimiselo do hulo idoꞌ initeꞌ gizi dave mukikisi do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Neꞌmine ineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete Isaiaꞌ luhuvo tiꞌ lo gizineꞌ ma nene omo gihile izelive losa nene neꞌmine ineꞌ ve: Di gilizevo i-lidaaꞌ aniꞌ initeꞌ nene asiꞌve do hulo-ledo initeꞌ lisaaꞌ ineꞌ initeꞌ nesi do hulo-lidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Idoꞌ eveneꞌ mukiꞌ ikaꞌ ikaꞌ igi di vodo vodo i-di minaniꞌ nene ningo Izesuꞌ aza sipiuꞌ nGalilaia noso ohuno helala eleꞌmizi vilizave lo izipahala zuho lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lo-ngemavo Zuda vete laaꞌ aniꞌ monoꞌ gamazi apize ngemaaꞌ ive maliꞌmo Izesuda ogo tiꞌ lo lineꞌ: Tisazo, naza nene geiꞌ vilinida alinida ha geꞌmeto volosuve. ");
INSERT INTO aso_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Initeꞌ mukiꞌ loposo gulosi idoꞌ namasi nene ingalizaniꞌ numuꞌinesi minaaꞌ naniꞌza Oꞌmosolatiꞌ ve gihile neniꞌ ongalo numuꞌne nomineꞌ nenako ha neꞌmetelibe. ");
INSERT INTO aso_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Idoꞌ eze gonoloꞌ eꞌmeti monave engikutiꞌ ve gohi maliꞌmo Izesuꞌni tiꞌ lo lo-imineꞌ: Guvekasi ve, gaza gele nemanivo meꞌnehine vo do galese ize-dosa ogo geꞌmetelohe. ");
INSERT INTO aso_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Neꞌmine lo lineꞌza Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza gelezo. Luꞌine hele vive angise nete hililiza okoꞌine di galese izi minilisaze. Ogo neꞌmetezo. ");
INSERT INTO aso_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Neꞌmine ogo Izesuꞌ aza sipiuꞌ vo dizavo Izipahala zuhosi igi dizikevo nosoloꞌ apiꞌ igi ledi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ledi nivavo hepeꞌ naba elavo neꞌmo noso nene golo gidini dizevoꞌ dizevoꞌ ogo sipi nene hito lulouꞌ velo lemeꞌ lemeꞌ idiꞌmo sipiuꞌ nene vaiꞌ lolosa ineꞌza Izesuꞌ nene okise ongo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ongo neivo izipahala zuho ingine ezela vi uꞌmukoꞌ igi tiꞌ li laniꞌ: Guvekasi ve, gaza oto do luꞌ izevo. Noso neꞌmo lebele geseꞌ o leize. ");
INSERT INTO aso_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Likevo aza lo-ngimineꞌ: Lingine lengehelele nanimuꞌ noizive. Lingine amuzo mili Oꞌmosomuꞌ gili eleꞌvoleꞌ ilizanako gili eleꞌvoleꞌ amave. Neꞌmine lo aza oto hepekisi nososi ngelemavo ingine nene mati zou li minasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Neꞌmine ikesivo sipiuꞌ minave ingine ngehelele goloso izavo gaꞌine vaiꞌ gili tiꞌ li laniꞌ: Ve meꞌmi gamazi nene hepeꞌ matesi noso matesi gili dikeko atoliꞌmine ve goloso noloseive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ingine noso helala Gadala vetida vi heteli nivavo sikalahuꞌ goloso luꞌninguꞌ minive sitaꞌ nene gonoso mili-ngidaaꞌ aniꞌ geheni mulikutiꞌ igi Izesuꞌni voteneꞌ asineꞌ. Ingine aꞌmine ve nene goꞌine gasava goloso hize vivo eveneꞌ ingine engikumuꞌ ngehelele goloso izavo minasineꞌ akala nene eveneꞌ hamokisi ngeli igi vigi monamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aꞌmine ve sitaꞌ ingine gekeꞌ li Izesuꞌnimuꞌ tiꞌ li lasineꞌ: Oꞌmosoꞌmi gipele gaza nosida mene nanitekumuꞌ nane. Gaza mulumo gono lemaaꞌ gamene olihe alitaminguꞌ mulumo gono lemelove losa nabe. ");
INSERT INTO aso_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aꞌmidotiꞌ hotoꞌ ile nene ize mulise naba galese ni nizavo ");
INSERT INTO aso_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","sikalahuꞌ goloso luꞌninguꞌ minive ingine amuzonga li Izesuꞌni tiꞌ li li-imasineꞌ: Gaza limisele hulolo ma nene ize mulise naba voleti luꞌninguꞌ nene limisele hulozo. ");
INSERT INTO aso_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Likesivo aza tiꞌ lo lo-ngimineꞌ: Neꞌmine li ma aloꞌ vilo lo lo-ngedavo sikalahuꞌ goloso ingine velisi luꞌningutiꞌ limi igi vi izeliti luꞌninguꞌ dizaniꞌ. Dizikevo ize mulise naba ingine galese ni minaniꞌ golo aveseloꞌ nene mangilise hizi limi vi noso ohunguꞌ hili geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hili geseꞌ ikevo ize gizebo ve ingine golise numuno ebeta vi sotoꞌ ineꞌ initeliꞌmi gamaziꞌve nene mukiꞌ veteteꞌ igi ngimi ve sitaꞌ luꞌninguꞌ sikalahuꞌ goloso minive netisi gamazi nesi li sotoꞌ igi li-ngimi osuꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Li-ngimi osuꞌ likevo aꞌmine numuno ebekuꞌ eveneꞌ minaniꞌ mukiꞌ ingine Izesuꞌ neida aniꞌ. Igi ningi engiꞌ misubo nene hulo vilive li ezela amuzonga laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Neꞌmine likevo Izesuꞌ aza sipiuꞌ dizo izipahala zuhosi noso ohunoloꞌ tineꞌ mili ledi vi eze numuno ebeꞌve Kahanaumila vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aꞌmida nene ve malite ve ma amuzolo hele geseꞌ ogavo minive gebili ma ngakakuꞌ ongo neivo zaloꞌ mili di neida aniꞌ. Idoꞌ vekise ingine gebili ma ha do lamineꞌ o-deleseive li gili eleꞌvoleꞌ aniꞌ nene Izesuꞌ aza mo ningo gelo aꞌmine gebili mamuꞌ tiꞌ lo lineꞌ: Gipeꞌneho, geiꞌ lihimeka nene mo apase-gedekuve. Nemuꞌ nene luka gaka ngi lo minivo. ");
INSERT INTO aso_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Neꞌmine lavo Zuda vete laaꞌ aniꞌ monoꞌ apizi ngimaaꞌ ave malite luꞌninguꞌ tiꞌ li gili minaniꞌ: Ve mene veꞌmo gamazi nolineꞌ neꞌmo nene Oꞌmoso ivileꞌ o-daaꞌ gamazi nolive. ");
INSERT INTO aso_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Neꞌmine li nigilavo Izesuꞌ aza luꞌninguꞌ gilaniꞌ gamazi nene ningo gelo tiꞌ lo lo-ngimineꞌ: Lingine lutinguꞌ gatine goloso nanimuꞌ nigilave. ");
INSERT INTO aso_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lingine nenikumuꞌ nene sozavoꞌ laaꞌ neive li gilaaꞌ nahe. Naza ve gebili nemuꞌ lihimeka mo hulo-gedekuve luvoniꞌ nene soza lolohe lamineꞌ lolohe ma gilamilisave lo lapa nomivo noluvoniꞌza sozaloꞌ ve minuvodini ve gebili mamuꞌ nene oto vozo nolo-duvo oto vamivo soza luvoniꞌ nene sotoꞌ ogavo novozo helalove lo gelo ve gebili mamuꞌ oto vozo loo ma lamuvodine. ");
INSERT INTO aso_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Idoꞌ naza Oꞌmosolatiꞌ ve gihile misubouko lengiꞌ lihimetine apase-lengedaaꞌ amuzo do nouve luvoniꞌ nene soza lamo laminetoꞌ noluvoniꞌ nene ningi gililizave lo idise ogo molo oloniꞌ nene lingine gililo lo ve gebilimuꞌ tiꞌ lo lineꞌ: Gaza oto ngakaka do geho numungala vozo. ");
INSERT INTO aso_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lavo ve gebili aza oto numuꞌvela vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eveneꞌ mukiꞌ ingine nene ningi ngehelele izavo leliꞌ gidini ve neꞌmine amuzo imingumuꞌ ve li Oꞌmoso opoꞌni laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Izesuꞌ aza aꞌmine minineꞌ numungutiꞌ lemo akala novo ve ma gulive Mataioꞌ nene takisi moni daaꞌ ineꞌ numuꞌveuꞌ gono do neivo ningo tiꞌ lo lo-imineꞌ: Gaza oto neꞌmeto ano. Neꞌmine lavo aza oto eꞌmeto vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Idoꞌ Mataioꞌ numuꞌveuꞌ Izesulesi nosoꞌ niteꞌ ni nizavo takisi moni daaꞌ avesi idoꞌ Zuda veti louꞌ gamaziloꞌ eꞌmete lamineꞌ isaꞌmave gohi ma nesi mukiꞌ numunguꞌ dizi ikevo izipahala zuhosi makatoꞌ nosoꞌ niteꞌ nii minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ni nizavo Halisaioꞌ monoꞌ laaꞌ ave ingine ningi izipahala zuho longoꞌ i-ngidi tiꞌ li laniꞌ: Lingine tisatine nene takisi moni daaꞌ ave golososi idoꞌ lihime daaꞌ ave lingesi nosoꞌ niteꞌ makatoꞌ nene nanimuꞌ ninave. ");
INSERT INTO aso_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Li laniꞌ nene Izesuꞌ gelo tiꞌ lo lo-ngimineꞌ: Luso ve aza lamineꞌ haza minave do lamineꞌ o-ngedelesa osaꞌmiha initeꞌ gizi davemukovoꞌ nene ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Naza aꞌmineꞌmine ogo eveneꞌ lisiheꞌ i minavemuꞌ amuvoniꞌza eveneꞌ lihimeꞌinesi vemuꞌ uvoniꞌ ve. Nemuꞌ lingine vi Oꞌmosoꞌmo lineꞌ gamazi ma monoꞌ godolouꞌ tiꞌ lo minineꞌ maꞌmi monovomuꞌ viseꞌ igi gililo: Initeꞌ neniꞌ nimi olokuꞌ gizaaꞌ nene lamineꞌ neiha Neniꞌ giluvoniꞌ nene evenekumuꞌ mulumoꞌine gili nasahiliꞌ o-ngedaaꞌ neꞌmo ivileꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nelotiꞌ nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ izipahala zuholite Izesuda igi tiꞌ li longoꞌ i-daniꞌ: Lazasi idoꞌ Halisaioꞌ monoꞌ laaꞌ avesi monokumuꞌ ve lo nosoꞌ niteꞌ nene malise okaꞌ okaꞌ ogo minaaꞌ nouneꞌza geze izipaha zuho nene malise isaꞌmako nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Neꞌmine li likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo veneꞌ di imiliza gameneuꞌ olize izo nosoꞌ niteꞌ gize vataꞌ ogo eze zuho molo-ngedavo ingine aza aꞌminguꞌ ha neivo mulumo gili-di nosoꞌ niteꞌ malise ilizadoꞌ nehe. Ne nomive. Aꞌmineꞌmine igi naza nouvosa nene lamineꞌ gili nizanako nosoꞌ niteꞌ malise amilisaha engiꞌ vovoꞌningutiꞌ biluvalite neze neleꞌmizi di vilizaniꞌ gamene nene mo aliteleseive. Aꞌmine gamene alitavo mulumo gili-nidisa nosoꞌ niteꞌ malise ilisave. ");
INSERT INTO aso_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Idoꞌ lavolavo gosohototiꞌ ngomo ma huki saketi litehe hukidoꞌ mili ongotilizaniꞌ nene ngingili lo geleleheꞌ ogavo neꞌmo naba hukaaꞌ neinako nemuꞌ lavolavo olihe ngingili lamineꞌ netiꞌ ngomo ma huki saketi liteheloꞌ mili ongotisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Idoꞌ aꞌmineꞌmine igi lingine vaini noso gosohoꞌ neꞌmo memeꞌ ize losuvodunuꞌ liliꞌ aniꞌ gomise nene izo pouꞌ loo vaini noso lepo vo gomiseꞌvesi nene goloso ogalive li vaini noso gosohoꞌ gituhoꞌ galakalaꞌ neidiꞌmo nene lulu izavo gomise liteheliꞌmo ngipu lo hukilineꞌ o mininguꞌ nene ma ohizi milisaꞌmave. Vaini noso gosohoꞌ gituhoꞌ galakalaꞌ neivo nene memeꞌ ize losuvo gosohotunuꞌ liliꞌ aniꞌ gomise gosohokuꞌ nene ohizaaꞌ nave. Neꞌmine ikevo gomisesi vaini nososi nene lamineꞌ ha minaaꞌ nasive. Neꞌmine lineꞌ nene aza monoꞌ lo-ngemaaꞌ ineꞌ nene gosohoꞌ nenako izipahala zuho igi mili ilizaniꞌ monovo neꞌmo aꞌmine Zuda veti monovo litehe maloꞌ vo damingumuꞌ nene lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Izesuꞌ nene gamazi lo-ngemo neivo monoꞌ gizebo ve maliꞌmo eze neida ogo gubiꞌ noize emo tiꞌ lo lineꞌ: Alune ma nene idise aꞌmene nohilineꞌzo gaza ogo anga okoꞌnoloꞌ hitanivo gohi vele gizo otelive losa noluve. ");
INSERT INTO aso_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lavo Izesuꞌ aza oto monoꞌ gizebo ve nene eꞌmeto izipahala zuhosi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nivavo veneꞌ ma venelite ikeꞌniloꞌ ikeꞌniloꞌ ningaaꞌ aniꞌ siki nene mate-desaꞌmivo mino gamene haꞌnaloꞌ ninge do vo mino kilisimasi tuvelu (12) minineꞌ veneꞌ neꞌmo naza okoꞌnoloꞌ damo ha Izesuꞌ geneganaꞌvelokovoꞌ do gelelodiꞌmo nene lamineꞌ olosuve lo gelo Izesuꞌ mehenelatiꞌ ogo geneganaꞌve gahevela do gilineꞌza ");
INSERT INTO aso_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Izesuꞌ aza mine velepeꞌ izo aꞌmine veneꞌ nene vonuꞌ belo tiꞌ lo lo-imineꞌ: Aluneve, gele eleꞌvoleꞌ anidiꞌmo nene lamineꞌ ogange. Gaka mukiꞌ gelaaꞌ aineꞌ ma nene gohi gelamozo. Neꞌmine lo-davo liteꞌ lo aꞌmidoꞌ lamineꞌ gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tiꞌ ogavo Izesuꞌ aza vo monoꞌ gizebo ve maꞌmi numuꞌveuꞌ dizo ningineꞌ nene alungo mulumo gili polopeꞌ mili eveneꞌ mukiꞌ ive nama igi nizavo ningo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Alungo nene ma helamineꞌ. Haza okise ongo neize. Heta igi vilo lo lo-ngedavo gizeꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tiꞌ igi eveneꞌ mukiꞌ ingine heta vi osuꞌ likevo Izesuꞌ aza numunguꞌ dizo vo alungo neꞌmi analoꞌ nodavo otineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Neꞌmine ogavo guvele nene hutileꞌ ogo mone osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Idoꞌ Izesuꞌ aza numuno nene hulo novivo veꞌine likive sitaꞌ ma eꞌmeti nivi asi naba li tiꞌ li lasineꞌ: Guvelesi ve naba Davidiꞌ aꞌvo ezeloꞌ medelo minanive make, gaza mulumote ningevo. ");
INSERT INTO aso_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Likesivo Izesuꞌ aza numunguꞌ dizo neivo ve sitaꞌ ingine dizi minida minikesivo Izesuꞌ tiꞌ lo longoꞌ o-ngidineꞌ: Lingine gilasineꞌ initeꞌ nene neniꞌ ha oloseive li mo gili eleꞌvoleꞌ i nizasihe. Neꞌmine lo longoꞌ o-ngedavo tiꞌ li li-imasineꞌ: Guvekasi ve, laza mo gele eleꞌvoleꞌ o nosive li li-imasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Li-imikesivo veꞌnidoꞌ nodo gelo tiꞌ lo lineꞌ: Lingine gili eleꞌvoleꞌ asineꞌ neꞌmino lengita gihile sotoꞌ ivo. ");
INSERT INTO aso_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Neꞌmine lo nolivo veꞌine nene lamineꞌ ogavo veꞌine niningasivo amuzonga lo-ngedo tiꞌ lo lineꞌ: Lingine initeꞌ o-lingiduvoniꞌ memuꞌ eveneꞌ hamokisi gilikelizaze. Li-ngimamilizo. ");
INSERT INTO aso_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lineꞌza ingine vi Izesuꞌ guvele nene li hutileꞌ ikesivo guvele nene buu lo aꞌmine ebeꞌ nabauꞌ nene mone pilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Idoꞌ nelotiꞌ Izesuꞌve ezesi monave nesi limi heta navo eveneꞌ malite ve ma sikalahuꞌ goloso lulouꞌ minidiꞌmo gamazi lamilidoꞌ o vive ma nene eleꞌmizi Izesuda aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eleꞌmizi ikevo Izesuꞌ aza sikalahuꞌ goloso eveneꞌ luloutiꞌ imisele hulavo aꞌmine ve nene gamazi apiꞌ ogo lineꞌ. Lavo eveneꞌ mukiꞌ ingine ningi voꞌine goloso vavo tiꞌ li laniꞌ: Isilaeleꞌ misubouꞌ mene neꞌmine ma sotoꞌ ivo ningamuneꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Neꞌmine li laniꞌza Halisaioꞌ monoꞌ laaꞌ ave nete tiꞌ li laniꞌ: Sikalahuꞌ goloso ngimiselo do nohulineꞌ amuzo nene sikalahuꞌ golosoliti guveꞌinesi velatiꞌ dosa nene nongimiselive laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Idoꞌ Izesuꞌ aza numuno ebeꞌ nabaꞌ naba idoꞌ ngomo ngomo mukikuꞌ nene mone mone ogo eveneꞌ monoꞌ numunguꞌ monoꞌ apize ngeme ngemeꞌ ogo idoꞌ Oꞌmosoꞌmi gizebomuꞌ gamazi lamineꞌ nene lo-ngeme ngemeꞌ ogo idoꞌ initeꞌ ato atoꞌ gizi davesi gilizevo alevesi nene do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Idoꞌ eveneꞌ mukiꞌ goloso ezela aniꞌ nene ningo ingine sipisipi izeloꞌ gizebo veꞌine ma nomivo minaniꞌ maꞌmine igi muheleꞌ aheleꞌ igi gopo minaniꞌ nenako nemuꞌ nene mulumoꞌine ningo muluno hukineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Neꞌmine ogavo izipahala zuho aneza gamazi ma evenekumuꞌ lo molo neꞌmine lo lo-ngimineꞌ: Eveneꞌ mene gopo ikelizaze. Minguꞌ nene nosoꞌ niteꞌ mukiꞌ goloso o molaniꞌza aꞌminguꞌ gono dalonive nene ngomosiꞌ minekunge. ");
INSERT INTO aso_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nemuꞌ nene lingine mine melehida likevo gonoloꞌ ve ma ngimiselavo vi minamuno dolizilizave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Izesuꞌ aza izipahala zuho tuvelu (12) asi lo-ngemavo ikevo eveneliti luꞌningutiꞌ sikalahuꞌ goloso ngimisele hulaaꞌ idoꞌ ato atoꞌ initeꞌ gizi davesi gilizevosi mukiꞌ do lamineꞌ o-ngedaaꞌ amuzo nene ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aꞌmine aposolo tuvelu (12) neti guliveꞌine nene neꞌmino neive: Ganaꞌ nene Simoniꞌ gulive gohi ma Petoloꞌ idoꞌ Adeleaꞌ nene akunolo minineꞌ. Idoꞌ Zebedaioꞌ gipele Zakoboꞌ ve, akunolo Zohaneꞌ ve, ");
INSERT INTO aso_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Hilipoki Batolomaioki idoꞌ Tomasiꞌ ve, takisi moni daaꞌ ive Mataioꞌ nesi idoꞌ Zakoboꞌ gohi ma minineꞌ nene Alahaioꞌ gipele minineꞌ. Idoꞌ Tadaioꞌ ve, ");
INSERT INTO aso_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","idoꞌ Loma ve ngimisele hulolone li amuzo milaaꞌ aveutiꞌ ve ma Simoniꞌ ve, idoꞌ alingeꞌ Izesuꞌni do sotoꞌ o-dive adoꞌ Kelioto numudotiꞌ ve Zudaꞌ nesi nene minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Idoꞌ aꞌmine ve tuvelu (12) nene gonoloꞌ nongimiselo gamazi tiꞌ lo lo-ngidineꞌ: Lingine Zuda ve minamaniꞌ eveneliti misubouꞌ vami idoꞌ Samalia eveneliti numuno ebeꞌningukisi nene vami ");
INSERT INTO aso_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","sipisipi ize vi halekaaꞌ naniꞌ neꞌmini Isilaeleꞌ aleve vi tolovo igi nizaniꞌ engita nene vilo. ");
INSERT INTO aso_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vi ma nene Oꞌmosoꞌmi gizebo nene lengita mo ogave li li sotoꞌ igi li-ngimilo. ");
INSERT INTO aso_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Idoꞌ initeꞌ gizi dave nene di lamineꞌ i-ngidilo. Idoꞌ hili nilizangutiꞌ nesi di oti-ngidilo. Idoꞌ ganadise gizi dave nesi di lamineꞌ i-ngidilo. Idoꞌ sikalahuꞌ goloso eveneꞌ luꞌningutiꞌ nesi ngimiseli hulilo. Neꞌmine manaꞌmine o-ngedaaꞌ amuzo nene meni hizi ma damaze. Lingine haza neꞌmine manaꞌmine i-ngidilo. ");
INSERT INTO aso_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Idoꞌ lingine gotinguꞌ moni ngomosi ma goꞌziki vamilo. ");
INSERT INTO aso_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Idoꞌ aka vilizangumuꞌ ve li goꞌ neꞌminesi dami idoꞌ sioti sitaꞌ izi vami hamokovoꞌ izi vi suuꞌ nesi izi vami idoꞌ hatuso nesi di vami okodidoꞌ neineꞌ nevoꞌ nene minivo vilo. Gono dave nene gonoꞌnidoꞌ initeꞌ ma ngimikevo menite ve li haza dalizaniꞌ nene lisiheꞌ o neinako linginesi nene aꞌmineꞌmine igi lingimikevo haza dalisanaze. Nemuꞌ nene hazavoꞌ vilo. ");
INSERT INTO aso_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Idoꞌ lingine numuno ebeꞌ nabaupe ngomoupe ma vi heteli ma eveneꞌ lamineꞌ ma nolingumuꞌ nene viseꞌ igi ningisa aꞌmine veꞌmi numuꞌveuꞌ nene dizi limi nizavo numuno ebeꞌ mala viliza gamene nene alitavo ma nene vilo. ");
INSERT INTO aso_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lingine numuno mauꞌ dizi ma aꞌmine numunguꞌ miniliza aleve nene lengita hongu minivo li meseꞌ aseka li-ngidilo. ");
INSERT INTO aso_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Idoꞌ aꞌminguꞌ minave ingine eveneꞌ lamineꞌ nilizaniꞌ nene lengitatiꞌ hongu nene engita mineleseive. Idoꞌ eveneꞌ lamineꞌ minami nilizaniꞌ nene aꞌmine hongu nene engita minamo gohi tineꞌ molo lengita aloseive. ");
INSERT INTO aso_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Idoꞌ eveneꞌ malite gamazitine gilami lengeleꞌmize lamineꞌ amavo ma lingine aꞌmine numungutipe ebekutipe vili ma ingine engiꞌ monovoꞌine ningilizangumuꞌ ve li avazaha igi gizedidotiꞌ uꞌmusupo nene okohoꞌ izi di huli vilo. ");
INSERT INTO aso_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Laminetoꞌ nolo-lingimuve. Gamene nabauꞌ aꞌmine aleve Oꞌmosoꞌmo lihimeꞌine ngemelineꞌ nene Sodomu aleve idoꞌ nGomola aleve mulumo initeꞌ naba ngemelineꞌ nesi ivileꞌ ogosa naba goloso ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Idoꞌ gilahe. Lingine nene neniꞌ gonoꞌne vi dalizave lo nolingimiseluve. Lingine nene sipisipi ize neꞌminisa minilisave. Sipisipi ize ingine lovo veꞌinete ngibililisa ikevo ingine aꞌmidoꞌ alete mili ngibililiza gavosoꞌine nomivo minaaꞌ naniꞌ neꞌminisa nene minilisave. Idoꞌ lingine vovoꞌninguꞌ vi miniliza aleve neve nene sipisipi ize ngibilaaꞌ aniꞌ loposo gulo neꞌminisa nene minilisanaze. Lingibilikelizaze. Nemuꞌ lingine nene gosiheꞌ igaꞌ naniꞌ neꞌmine igi gatine lamineꞌ gili gizebo ilo. Idoꞌ nama viluso igaꞌ naniꞌ neꞌmine igi honguvoꞌ li minilo. ");
INSERT INTO aso_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lingine nene evenekumuꞌ ningisa minilo. Ingine nene kanisoleꞌnidoꞌ di gonitoꞌ mili-lingidi monoꞌ numuꞌninguꞌ nalatunuꞌ liliꞌ aniꞌ gavosodunuꞌ lingibililisave. ");
INSERT INTO aso_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Idoꞌ nenita giꞌmizi minangumuꞌ ve li gonitoꞌ lengeleꞌmizi mili guveꞌinesi ve nabaliti veꞌnidokisi ngamani nabaliti veꞌnidokisi lengeleꞌmize milikevo engikisi idoꞌ Zuda ve minamaniꞌ alevesi nene neniꞌ monovoꞌne li sotoꞌ igi li-ngimilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nemuꞌ nene lengeleꞌmize gonitoꞌ nimilavo ma gamazi nado lolove idoꞌ nadive lolove li gopo gatine gilamilo. Gonitoꞌ lengeleꞌmizi milikevo gamazi liliza gamene alitelineꞌ nene lilizaniꞌ gamazi nene ha omo gatinguꞌ ogavo lilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gamazi lilizaniꞌ nene langisetine lamilisave. Metibi Sikalahuꞌ neꞌmo nene lengikuꞌ omo holo mino gamazi lilizaniꞌ nene eiꞌ loloseive. ");
INSERT INTO aso_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Idoꞌ eveneꞌ nenikumuꞌ gili eleꞌvoleꞌ amaniꞌ nete nene nenikumuꞌ gili eleꞌvoleꞌ ave nene ngibili hililizave li gonitoꞌ ngeleꞌmizi milalisave. Ee, mo uvoꞌninge akuꞌninge nilizaniꞌ netesi idoꞌ izeꞌninge meꞌninge izipahaꞌine zuho nilizaniꞌ netesi nene ha neꞌmine ilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Neniꞌ guliveꞌne di minilizangumuꞌ eveneꞌ mukiꞌ nete nene lengikumuꞌ goloso gililisave. Neꞌmine ilizaniꞌza ve malite nenikumuꞌ gili eleꞌvoleꞌ igi amuzo mili mini di vi nizavo gameneꞌine ma osuꞌ lilive nene Oꞌmosoꞌmo do nguꞌ izeleseive. ");
INSERT INTO aso_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Idoꞌ numuno ebeꞌ mautiꞌ alevelite ma lengeleꞌmize goloso navo ma golise ebeꞌ maloꞌ maloꞌ vikaꞌ vikaꞌ igisa nene monilo. Naza laminetoꞌ nolo-lingimuve. Isilaeleꞌ aleveti numuno ebeꞌninguꞌ nene olihe moni pilamavo Oꞌmosolatiꞌ ve gihile naza nene tineꞌ molo alosuve. ");
INSERT INTO aso_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tisaꞌ maliꞌmi izipahala zuho ingine nete nene tisaꞌine nene ivileꞌ igi ma minisaꞌmave. Idoꞌ agove izipe nete ingine gizebo i-ngidave nene ngivileꞌ igi ma minisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Izipahala zuho ingine tisaliꞌmo gehaaꞌ ineꞌ gono gihi minilizaniꞌ nene lamineꞌ oloseive. Idoꞌ agove izipe ingine nene gizebo o-ngedaaꞌ iveꞌmo gehaaꞌ ineꞌ gono inginesi gihilizaniꞌ nene lamineꞌ oloseive. Ve goloso nete metibine nenikumuꞌ sikalahuꞌ golosoliti guveꞌinesi ve Belezebuloꞌ ve li-nidaniꞌ nenako izipahaꞌne zuho lengikumuꞌ nene nabisa divi ledivika li-lingidilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nemuꞌ nene engikumuꞌ golise gilamilo. Idise mene hito neineꞌ initeꞌ mukiꞌ nene alingeꞌ sotoꞌ oloseive. Idoꞌ idise mene haleko neineꞌ initeꞌ nene sotoꞌ ogavo gililisave. ");
INSERT INTO aso_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Idoꞌ naza litiꞌmusouꞌ haleko sunoꞌ lengikovoꞌ lo-lengemaaꞌ uvo gamazi nene eveneꞌ mukiꞌ ningi gililizada nene li sotoꞌ igi li-ngimilo. Idoꞌ zegeno nununga lo lo-lengemaaꞌ uvoniꞌ gamazi nene numuno heta eveneꞌ mukiꞌ gililizada nene li hutileꞌ igi li-ngimilo. ");
INSERT INTO aso_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Eveneꞌ ingine okodinevoꞌ nene ha lingibili hililizaniꞌza lutine nene ngeli di gopo amilisave. Engikumuꞌ golise gilamilo. Mudise lutinesi okodinesi olokuꞌ hulo lengebele heleli amuzoꞌvesi minive Oꞌmosomukovoꞌ nene golise gili minilo. ");
INSERT INTO aso_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gilahe. Nama ngomo ngomo osoꞌmohoꞌ neꞌmine nama nene haza niteꞌve li gili guleheꞌ moni hamokovoꞌ nene huli nama sitaꞌ meni hizaaꞌ aniꞌ ve. Idoꞌ aꞌmine neꞌmine nama nene haza niteꞌ neiha metibo engitoꞌ gizebo lamineꞌ ogaꞌ neive. Aza gelamivo engikutiꞌ hamoꞌ neꞌminesi nene ma ngelo helo misubouꞌ lemamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Idoꞌ lingine neve nama ngomo ngomo mukiꞌ nene ngivileꞌ igi initeꞌ naba nizanako nemuꞌ nene golise gilamilo. Lengita initeꞌ ngomo lasolo nesi goloso ogalive lo godotine zopovo mukiꞌ nene gate osuꞌ lo nelokisi gizebo ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ve maliꞌmo neze guliveꞌne eveneꞌ mukiliti veꞌnidoꞌ lo sotoꞌ ilineꞌ nene eze gulivesi meꞌnehi veleloꞌ Okulumokuꞌ lo sotoꞌ olosuve. ");
INSERT INTO aso_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Idoꞌ ve maliꞌmo nenikumuꞌ eveneꞌ mukiliti veꞌnidoꞌ ningamuve ve lo ataize lo-nedelineꞌ nene ezemukisi ningamuve ve lo meꞌnehi veleloꞌ Okulumokuko lo-delesuve. ");
INSERT INTO aso_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Naza lemo uvoniꞌ nemuꞌ nene misubo mukikuꞌ lovo mukiꞌ nene osuꞌ lavo eveneꞌ mukiꞌ nene honguvoꞌ li minilisave li gilamilo. Naza lemo uvoniꞌ neꞌmo eveneꞌ mukiꞌ nene hongu li minami lovo hizi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naza lemo uvoniꞌ neꞌmo eveneꞌ hoꞌ li eza ema minikevo ve malite engiꞌ meꞌninge lovo i ngimi minilisave. Idoꞌ aluvoꞌine malite izeꞌningine lovo i ngimi minilisave. Idoꞌ ngonohulo malite veneꞌ avoꞌningine lovo i ngimi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Idoꞌ engiꞌ zuho gehepeve nete nene engiꞌ zuholiti lovo ve liliꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Idoꞌ lingine izetingine metingine lutine ngimilizaniꞌ ivileꞌ igi lutine nimamilizaniꞌ nene neze zuho gihile minilizaniꞌ votigileloꞌ minamilisave. Idoꞌ izipahatine lutine ngimilizaniꞌ nene ivileꞌ igi lutine nimamilizaniꞌ nene neze zuho gihile minamilisave. ");
INSERT INTO aso_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Idoꞌ ve ma mulumo initeꞌ i-lidi lohotoꞌ zaloꞌ libilikelizave li geli aꞌmanapa igi neꞌmetamilizaniꞌ nene neze zuho gehepeve minilizaniꞌ votigileloꞌ minamilisaave. ");
INSERT INTO aso_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Idoꞌ ve ma aza helelohe helelohe lo okoꞌnomuꞌ golise golise gelo minelive nene alingeꞌ helosa minevoꞌ minevoꞌ emeni dameni damoloseive. Idoꞌ ve ma aza neniꞌ neꞌmeto novilinguꞌ bili hililizaniꞌ nene alingeꞌ minevoꞌ minevoꞌ emeni dameni nene mo daloseive. ");
INSERT INTO aso_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Idoꞌ eveneꞌ ma ingine lengiꞌ gamazitine gili lengeleꞌmize lamineꞌ ilizaniꞌ nene neniꞌ gamaziꞌne gili neleꞌmize lamineꞌ aniꞌ geleleseive. Idoꞌ neze neꞌmine i-nidilizaniꞌ nene nimiselive eiꞌ gamaziꞌve gili eleꞌmize lamineꞌ aniꞌ geleleseive. ");
INSERT INTO aso_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Idoꞌ aza Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete ma ne neive lo ve maliꞌmo aꞌmine ve eleꞌmize lamineꞌ ilineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ iveꞌmo meni daaꞌ ineꞌ votigileloꞌ meni daloseive. Idoꞌ ve lisiheꞌ ma ne neive lo ve maliꞌmo aꞌmine ve lisiheꞌ nene eleꞌmize lamineꞌ ilineꞌ nene aꞌmine ve lisiheliꞌmo meni dalineꞌ votigileloꞌ ogo meni daloseive. ");
INSERT INTO aso_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Idoꞌ ve maliꞌmo izipahaꞌne zuho limi minangutiꞌ nene ma ningo mene ve nene Izesuꞌ izipahala zuhoutiꞌ neive lo gelo hepeꞌ noso ngomosi ma ohizo emelineꞌ nene alingeꞌ meniꞌve nene damilivoba daloseive. ");
INSERT INTO aso_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Izesuꞌ aza izipahala zuho tuvelu (12) nene gono gamazi lo-ngedo osuꞌ lo aza nene hulo-ngedo aꞌmine gahevela numuno ebeꞌ mukikuꞌ veneꞌ vemohoꞌ nene monoꞌ apize ngeme ngemeꞌ ogo idoꞌ lo soto sotoꞌ ogo lo-ngemeꞌmo monineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Neꞌmine ogavo monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ aza nalaꞌ numunguꞌ huli-mikavo mininguꞌ nene Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa liveꞌmo ogo molo monineꞌ gamaziꞌve nene gelo Izipahala zuho ma ngimiselavo ingine Izesuꞌ neida vi tiꞌ li longoꞌ i-dasineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gaza nene aloseive li-limi lave ma ne nabe idoꞌ ve gohi mamuꞌ gizebo oloneꞌ o neihe. ");
INSERT INTO aso_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Neꞌmine li longoꞌ i-dikesivo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Lingine tineꞌ mili vi Zohaneꞌni nene neniꞌ gono noduvo nigilasineꞌ idoꞌ ningasineꞌ initeꞌ nemuꞌ nene vi tiꞌ li li-imilizo: ");
INSERT INTO aso_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Veꞌine likive ingine veꞌine gohi niningave. Idoꞌ gizeꞌine goloso ive nene gohi aka nimonavo ganadise gizi dave nene gohi kululuꞌ niizave. Idoꞌ gaꞌine molave nene gohi nigilavo hilave nene gohi do noote-ngidive. Idoꞌ gohoꞌ aleve nene monoꞌ gamazi lamineꞌ nigilave. ");
INSERT INTO aso_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lingine neꞌmine li li-imi tiꞌ li li-imilizo: Gaza neniꞌ monovomuꞌ gaka sitaꞌ sataꞌ nogelaineꞌ nene hulo nenikumuꞌ gele eleꞌvoleꞌ ilineꞌ nene mine lamineꞌ ogo mcnelineꞌ akaloꞌ eꞌmeto volosane. Idoꞌ eveneꞌ mukiꞌ inginesi gaꞌine sitaꞌ sataꞌ gilami nenikumuꞌ gili eleꞌvoleꞌ ilizave nete mine lamineꞌ igi miniliza akaloꞌ eꞌmeti vilisave. ");
INSERT INTO aso_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Neꞌmine lo lavo Zohaneꞌ ngimiselive ingine tineꞌ mili nivasivo Izesuꞌ aza eveneꞌ vaiꞌ li minaniꞌ nene Zohaneꞌnimuꞌ apiꞌ ogo tiꞌ lo lo-ngimineꞌ: Lingine eveneꞌ mukiꞌ Zohaneꞌni ningilisa ebeꞌ hadivela vaniꞌ ma nene naniteꞌ ningilisa vaniꞌ neve. Aꞌmida nene hepeliꞌmo do gabe kabeꞌ ogaꞌ neineꞌ initeꞌ gepeꞌ neꞌmino gamazi do tiꞌne vatiꞌne ogo laaꞌ ive ma ningilisa vaniꞌ nehe. ");
INSERT INTO aso_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Idoꞌ lingine vaniꞌ ma nene ve maliꞌmo genegana lamineꞌ goloso ngolo minineꞌ ningilisa vaniꞌ neve. Eꞌe, aꞌmine neꞌmine genegana nene guveꞌinesi vevoꞌ minanguꞌ minavetevoꞌ nene ngili minaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nemuꞌ nene naniteꞌ ningilisa ebeꞌ hadivela vaniꞌ neve. Polohete ningilisa vaniꞌ noloseive. Olo. Ee, aꞌmine vi ningave nene polohete ma ve. Aꞌmine ve nene polohete gomuꞌ minaniꞌ neꞌmine minamo ngivileꞌ ogosa neive. ");
INSERT INTO aso_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Idoꞌ aꞌmine vemuꞌ nene monoꞌ godolouꞌ Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live lo-emo lineꞌ gamazi ma tiꞌ li gizi nizaniꞌ ma neive: Gelezo. Naza neze gamazi lo-ngeme ngemeꞌ ilive ma imiselekuvo aza do gomuꞌ molo akaka vele-gedeleseive. Aꞌmine gamazi nene aꞌmine ve Zohaneꞌnimuꞌ nene gizaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Neꞌmine aniꞌ nene naza lamineꞌ ma lo-lengemelove. Eveneꞌ misubouko sotoꞌ igi mini di aveutiꞌ nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌni nene ivileꞌ igi minave ma minamaniꞌ ve. Ne neiha Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ilineꞌ gameneꞌve sotoꞌ ogavo aꞌmine gizebo o-ngedelinguꞌ vi hilalizave engikutiꞌ ma lemo mineliveꞌmosi nene Zohaneꞌ minineꞌ monovo nene ivileꞌ ivo minilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Zohaneꞌ monoꞌ noso holo-ngedo minidotiꞌ mine do dizo Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ilineꞌ neꞌmo amuzo molo sotoꞌ olosa minineꞌ ve. Idoꞌ eveneꞌ ma amuzoꞌinesi minaniꞌ nete aꞌminguꞌ vi hilalisa amuzo miliꞌmi miliꞌmi vi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Idoꞌ Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ avete laniꞌ gamazisi idoꞌ Oꞌmosoꞌmo lo huko-lidineꞌ gamazisi gizikaniꞌ neuꞌ nene initeꞌ sotoꞌ oꞌmo vo mine do dizelineꞌ initekumukisi li Zohaneꞌ sotoꞌ ogo minelineꞌ gameneuꞌ sotoꞌ ilineꞌ initekumukisi nene li osuꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Idoꞌ aꞌmine gamazi gizaniꞌ mauꞌ nene tiꞌ li gizaniꞌ: Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live sotoꞌ olosa neivo nene gozopoꞌ minive polohete Eliaꞌ emeni damenisi minelive ma sotoꞌ oloseive. Neꞌmine li lave ma nene Zohaneꞌ nene neiha lingine nemuꞌ gilii lamineꞌ mo Eliaꞌ ve li gililizahe. ");
INSERT INTO aso_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ve ma lingine gili nge li gilaaꞌ ave nii ma nene gamazi mene gili vevesi gililo. ");
INSERT INTO aso_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Idise mene nizaniꞌ alevemuꞌ nene nanitetoꞌ lo molo lokuvo vo dalive. Lingine izipe goseleꞌ ngebelaaꞌ ineꞌ izipe neꞌminisa nene nizave. Izipe ingine di geseꞌ igaꞌ ebetoꞌ zohiꞌ igi mini gonoꞌninginemuꞌ ");
INSERT INTO aso_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","neꞌmine li laaꞌ nave: Laza lengikumuꞌ huhunaleꞌ mulunidoꞌ nene longolize izi gizedine adine izisaꞌmave. Idoꞌ nama muheleꞌ aheleꞌ ogo lunidoꞌ nene nanimuꞌ muheleꞌ aheleꞌ isaꞌmave. ");
INSERT INTO aso_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Naza neꞌmini nizave luvoniꞌ nene neꞌmini minangumuꞌ luvoniꞌ ve. Zohaneꞌ aza gonoꞌve do do vinguꞌ nene nosoꞌ niteꞌ lamineꞌ namo idoꞌ vaini noso namo mine atoꞌ ogo minivo ningi goseleꞌ lengebelavo tiꞌ li laniꞌ ve: Ve mene sikalahuꞌ goloso maliꞌmo lulo do gopo ogavo neꞌmine neihe li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Idoꞌ Oꞌmosolatiꞌ ve gihile naza lemo nosoꞌ niteꞌ di geseꞌ igi ni nizanguꞌ vo naaꞌ idoꞌ vaini noso naaꞌ nouvo lingine ningi goseleꞌ lengebelavo soza gamazisi li tiꞌ li laaꞌ nave: Ve mene ningilo. Aza nene vele gohi nave mino idoꞌ noso geli gelo naaꞌ ive mino takisi moni daaꞌ avesi idoꞌ monoꞌ gilamave gohi masi nene zogo molo ngemaaꞌ ive ne neive. Lingine neꞌmine li gilaaꞌ naha ve ma laza Oꞌmosoꞌmi monovolo do tiꞌ ogo otohato o minunive leliꞌ ogo molo oloneꞌ initeꞌ neꞌmo nene leliꞌ monovote lamineꞌ neineꞌ nene do sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Izesuꞌ aza numuno ebeꞌ mauꞌ vo gono do do novo ato atoꞌ suno mukiꞌ nene eiꞌ gono dadiꞌmi amuzo nene do sotoꞌ ineꞌ. Do sotoꞌ ogavo ninganiꞌza ningahe ningamahe igi luꞌine di velepeꞌ izamavo ngelemo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Agae, Kolazini aleve idoꞌ Betesaida aleve lengikumuꞌ nene mulumo nogele-lingiduve. Lengita mulumo initeꞌ goloso alingeꞌ sotoꞌ o-lengedeleseive. Lengita ato atoꞌ suno do sotoꞌ uvoniꞌ ma nene Tilo alevetingukisi Sidoni alevetingukisi do sotoꞌ uvodiniko ingine Oꞌmosomuꞌ gilamaniꞌ aleve minikeniꞌza aꞌmine ebekuꞌ aleve ingine nene mo geti luꞌine do velepeꞌ izekune li lani gisi hili initeꞌ huko pako ineꞌ nene di ngili minadine. ");
INSERT INTO aso_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nemuꞌ nene naza ma lo-lengemeloze. Gililo. Lingine Tilo alevemukisi idoꞌ Sidoni alevemukisi nene Oꞌmosoꞌmo gamene nabala lihime ngemelineꞌ nene nabaꞌ naba ngemeleseive li gilaaꞌ nahe. Oꞌmosoꞌmo engiꞌ lihime ngemelineꞌ nene ivileꞌ ogosa lengiꞌ lihimetine nene nabaꞌ naba lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Idoꞌ Kahanaumi alevekizo, lengiꞌ gulivetine nene Okulumokuꞌ dizelive li di hozi laaꞌ nahe. Lingine nene Oꞌmosoꞌmo oloꞌ galeseuꞌ lengehusoꞌ o huloloseive. Idoꞌ Sodomi misubouꞌ nene eveneꞌ ma mino idise atoꞌ atoꞌ suno do sotoꞌ nouvoniꞌ neꞌmino ma do sotoꞌ idiniko Sodomi numuno ebekuꞌ aleve nene luꞌine di velepeꞌ izikevo numuno ebeꞌine nene Oꞌmosoꞌmo do goloso amivo idisesi ha neivo evenekisi nene ha minadine. ");
INSERT INTO aso_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nemuꞌ nene laminetoꞌ ma lo-lengemeloze. Gililo. Gamene nabala Oꞌmosoꞌmo lihime ngemelineꞌ gameneloꞌ nene Sodomi aleve mulumo initeꞌ naba gehe-ngedelineꞌ nene ivileꞌ ogosa lengiꞌ nene geniꞌvesi naba gehe-lengedeleseive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aꞌmine gameneloꞌ nene Izesuꞌ tiꞌ lo Oꞌmosola lineꞌ: Meꞌneho ve, gaza Okulumoꞌ misuboloꞌ gizebo o mino Guveꞌinesi ve minanivelike, naza lo sotoꞌ ogo noluvoniꞌ gamazi mene evenelite gilikevo eveneꞌ ma gili nge li gamazi monovo gilaaꞌ ave minaniꞌ nete aꞌmineꞌmi monovo nene ningi gilikelizave lo gaza do halekosa aꞌmine monovo nene eveneꞌ ma izipe ngomo neꞌmine mini initeꞌ mukiliti monovomuꞌ olihe gilamavemuꞌ nene do sotoꞌ o-ngedaineꞌ nemuꞌ nene isaaꞌ neve nolo-giduve. ");
INSERT INTO aso_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Meꞌneho ve, gaza neꞌmine olosa lamineꞌ gelo neꞌmine aineꞌ nemuꞌ nene isaaꞌ neve nolo-giduve. ");
INSERT INTO aso_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Neꞌmine lo gohi tiꞌ lo lineꞌ: Meꞌneho aza initeꞌ mataꞌ mukiꞌ nene aꞌneuꞌ molave. Idoꞌ Oꞌmosoꞌmi gipele neniꞌ nene Oꞌmosoꞌmi gipele ve li ningi ma gilamave. Meꞌneho eiꞌ neꞌmovoꞌ nene ningo gele neive. Idoꞌ meꞌnehinemukisi nene ma zaho nehe ningi gilamavo gipele nenikovoꞌ nene ningo gele nouvonako ezemuꞌ nene eveneꞌ masi gililizave lo eze monovo lo sotoꞌ o ngemeloniꞌ alevesi lelikovoꞌ nene meꞌnehinemuꞌ ningo gele minelesune. ");
INSERT INTO aso_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Lingine minevoꞌ alevotine geni ogavo di lamineꞌ ilisa geꞌnebe igi agae li minaaꞌ nave, lingine nenita alizaniꞌ nene neniꞌ do lunguꞌ izelesuze. Mukitoꞌ nenita alo. ");
INSERT INTO aso_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lingine igi gihilizave lo lengemeloniꞌ gono nene di mini nenitoꞌ gelekeleꞌ ikevo naza neniꞌ monovoꞌne nene apize lengemekaꞌ lengemekaꞌ nouvo di tiꞌ igi di minilizave. Idoꞌ naza nene luꞌneuꞌ hongu lo zou lo minive nouvonako lingine nene neꞌmine igi neniꞌ monovoꞌne di tiꞌ ilizaniꞌ nene lengiꞌ lutinguꞌ nesi hongu lo lamineꞌ mineleseinako nemuꞌ nene nenita igi gelekeleꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Naza lengemeloniꞌ gono nene geni amivo lamineꞌ gili ha gihilizadoꞌ lengemelosuvonako nemuꞌ nene lutinguꞌ nene hongu lo lamineꞌ mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aꞌmine gameneuꞌ nene holiseꞌ gamene mauꞌ Izesuꞌ izipahala zuhosi viti minguꞌ nivavo izipahala zuho ingine gaꞌnamuꞌ ngisavo viti godololatiꞌ gihile nene ili niꞌmi nivavo ");
INSERT INTO aso_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Halisaioꞌ monoꞌ laaꞌ ave malite ningi gili Izesuꞌni tiꞌ li li-imaniꞌ: Ningezo geze izipaha zuho ingine neꞌmine aniꞌ neꞌmo holiseꞌ gameneꞌmi louꞌ gamazi ma nene avutoꞌ ikeve. ");
INSERT INTO aso_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Neꞌmine li likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Davidikisi idoꞌ ezesi monave nesi gaꞌna hili minaniꞌ gamenela nene avotemoti guveꞌinesi ve naba Davidiꞌ ineꞌ initekumuꞌ nene gati gilahe gilamave. ");
INSERT INTO aso_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Adoꞌ Oꞌmosoꞌmi numunguꞌ dizo Oꞌmosoꞌmi veleloꞌ milaaꞌ aniꞌ beleti nene naniꞌ. Adoꞌ louliꞌmo lidoꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehize-daaꞌ avelitevoꞌ nalizadoꞌ o minineꞌ beleti nene Davidikisi ezesi monavesi nalizadoꞌ lisiheꞌ amineꞌ nene naniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehize-daaꞌ ave ingine holisekuꞌ nene monoꞌ numuno nabauꞌ nene holisekuꞌ gono damaaꞌ ve li li huki nizanako ningi lamavo gono ha daaꞌ naniꞌ ma nene gati gilamaniꞌ nehe. ");
INSERT INTO aso_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naza ma lo-lengemeloze. Gililo. Idise mene gameneloꞌ lengiꞌ vovotinguꞌ mene gono noduvoniꞌ neꞌmo nene monoꞌ numuno naba nene ivileꞌ ogosa initeꞌ naba neive. Nemuꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehize-daaꞌ ave holisekuꞌ gono dangumuꞌ lihime dikeve li-ngidisaꞌmaniꞌ neꞌminisa neniꞌ izipahaꞌne zuho nene lihime dikeve li-ngidamilo. ");
INSERT INTO aso_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Monoꞌ godolouꞌ Oꞌmosoꞌmo lineꞌ gamazi ma tiꞌ lo neive: Initeꞌ ma nimi olokuꞌ gizaaꞌ nene lamineꞌ neiha neniꞌ giluvoniꞌ nene evenekumuꞌ mulumoꞌine gelo nasahiliꞌ o-ngedaaꞌ neꞌmo ivileꞌ o neive. Mene gamaziꞌmi monovo nene gili lamineꞌ adiniko lihimeꞌine nomivo minaniꞌ nemuꞌ nene lingine lihime dikeve li-ngidamadine. ");
INSERT INTO aso_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lingine neniꞌ izipahaꞌne zuho nene holiseꞌmi louꞌ nene avutoꞌ ikeve li-ngidamilizadoꞌ o neive. Nanitekumuꞌ ve. Oꞌmosolatiꞌ ve gihile naza nene holiseliꞌmi meleho mino aꞌmine holisekuꞌ iliza initekumuꞌ idoꞌ amiliza initekumuꞌ laaꞌ uve nene nenikovoꞌ nouvoniꞌ nenako nemuꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Izesuꞌ aza minineꞌ ebeꞌ nene hulo vo monoꞌ numunguꞌ dizineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Vo dizo ningo gilineꞌ nene eveneꞌ ma ana hela goloso ogo gilizevo o vive ma minineꞌ nene ningineꞌza eveneꞌ malite Izesuꞌni goniꞌ i-diliza akamuꞌ viseꞌ igi tiꞌ li longoꞌ i-daniꞌ: Eveneꞌ holisekuꞌ do lamineꞌ o-ngedaaꞌ nene gelaineꞌ leliꞌ louliꞌmo lidoꞌ nene vo do neihe. ");
INSERT INTO aso_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Lengikutiꞌ ve maliꞌmo sipisipi ize hamoꞌ ma gedekelineꞌ aꞌmine nene holisekuꞌ galeseuꞌ lemelineꞌ nene aꞌmingutiꞌ nene do hazala o-damilidoꞌ o neihe. Eveneꞌ neꞌmo sipisipi ize nene ivileꞌ ogo initeꞌ gihile neinako ");
INSERT INTO aso_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","holisekuꞌ do lamineꞌ o-ngedaaꞌ nene ha neive. ");
INSERT INTO aso_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Neꞌmine lo ana helala goloso o vive nene tiꞌ lo lo-dineꞌ: Anga do pehe lozo. Lo-davo ana do pehe lavo helala minineꞌ ana neꞌmino lamineꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lamineꞌ ogavo Halisaioꞌ monoꞌ laaꞌ ave ingine ningi heta limi vi Izesuꞌni bililizaniꞌ aka di sotoꞌ ilisa mulise mili gamazi di hamoꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Neꞌmine aniꞌza Izesuꞌ aza monoꞌ numungutiꞌ lemo bililiza akamuꞌ viseꞌ igi gamazi di hamoꞌ aniꞌ nemuꞌ gelo aꞌmine ebeꞌ nene hulo vineꞌ. Hulo novivo eveneꞌ mukiꞌ nene eꞌmeti nivavo engikutiꞌ linge ma initeꞌ gizi dave minaniꞌ nene mukiꞌ do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Neꞌmine ineꞌza eze monovomuꞌ nene li hutileꞌ amilizave lo gaꞌine daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Neꞌmine ineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive Isaiaꞌ gozopoꞌ Oꞌmosoꞌmo lineꞌ gamazi gizineꞌ ma gihile izelingumuꞌ ve losa ineꞌ. Aꞌmine gamazi nene tiꞌ lo neive: ");
INSERT INTO aso_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Naza gonoloꞌ gipeꞌne ma do kegeso eleꞌmize muluve nene ningilo. Aza nene voꞌneloꞌ gipeꞌne neivo ezemuꞌ numo helavo laniteꞌ goloso gelaaꞌ nouve. Idoꞌ neniꞌ Sikalahuꞌne nene eitoꞌ molokuvo eveneꞌ ato atoꞌ mukiꞌ nene lihimeꞌinemuꞌ izeꞌ molo-ngedeli gamazi nene lo sotoꞌ ogo lo-ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aza nene lovo gamaziutiꞌ gekeꞌ lo lamo akaloꞌ nevo gamazi nabautiꞌ lamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Idoꞌ aza eveneꞌ ma monovoꞌine goloso ogavo gepeꞌ ma mange mange siꞌzo lemo ongalosa minineꞌ neꞌmine igi limi ingalisa minaniꞌ nene do lemo ongo-ngedo do goloso ma o-ngedamoloseive. Idoꞌ eveneꞌ ma monoꞌine mo osuꞌ lolosa neivo lamu viki ma lihizelesa vevezeꞌ ogo minineꞌ neꞌmine igi minaniꞌ nene monoꞌine do osuꞌ lo-ngedo do goloso ma o-ngedamoloseive. Akaꞌve hizi tili-dilizaniꞌ initeꞌ mukiꞌ nene ngivileꞌ ogo gono do do vo eveneꞌ izeꞌ molo-ngedo initeꞌ goloso o vineꞌ mukiꞌ nene do lisiheꞌ ogo do peleleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Neꞌmine ogo neivo eveneꞌ ato atoꞌ neze eveneꞌne zuho olihe loloꞌ amave ingine eze emeni damenimuꞌ gili leleꞌmize lamineꞌ oloseive li gili eleꞌvoleꞌ igi gizebo minilisave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ne gamenela nene eveneꞌ ma sikalahuꞌ golosoliꞌmo lulouꞌ mino vele do like-do vele hize langoloꞌ o-davo gamazi lamive ma Izesuda eleꞌmizi ikevo do lamineꞌ o-davo aꞌmine ve nene gamazi laaꞌ idoꞌ vele ningaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Neꞌmine ogavo eveneꞌ mukiꞌ aꞌmidoꞌ minave ingine nene ningi gopo gaꞌine gili tiꞌ li laniꞌ: Zuda ve leliꞌ avotemoti guveꞌinesi ve naba Davidiꞌ aꞌvopilemoꞌ ezeloꞌ medelo guvelesi ve naba loloꞌ ilive laniꞌ ma nene nolihee. ");
INSERT INTO aso_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Neꞌmine laniꞌza Halisaioꞌ monoꞌ laaꞌ ave ingine gili tiꞌ li laniꞌ: Oꞌve. Ve mene sikalahuꞌ goloso do nohulineꞌ nene aꞌmine sikalahuꞌ golosoliti guveꞌinesi ve naba Belezebuloꞌ neꞌmo amuzo imidotikovoꞌ do nohulineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Neꞌmine likevo Izesuꞌ aza luꞌninguꞌ gamazi gili minaniꞌ nene ningo gelo tiꞌ lo lo-ngimineꞌ: Misubo mauꞌ aleve ingine nene hizi hoꞌli mini lovo hizilizaniꞌ nene mo eveneꞌ simeꞌ nikevo ebeꞌ nene gaꞌme pizeleseive. Idoꞌ ebeꞌ naba mautiꞌ nehe numuno ngomo mautiꞌ nehe eveneꞌ hamoꞌ zuho ingine hoꞌli vi eza ema vilizaniꞌ ingine nene eleꞌvoleꞌ igi minami gopoꞌnapa ilisave. ");
INSERT INTO aso_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Idoꞌ Satani neꞌmo eze zuho ngimiselo do huli-diniko azasi eze zuhosi hoꞌli mini ngelami diꞌmozi vi gopoꞌ napa adine. ");
INSERT INTO aso_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Idoꞌ nenikumuꞌ nene Belezebulodatiꞌ amuzo dosa sikalahuꞌ goloso nene ngimiselo do nohulive nilahe. Idoꞌ lengiꞌ zuholite sikalahuꞌ goloso ngimiseli hulaaꞌ aniꞌ ma nene amuzo zahidatiꞌ disa neve. Lingine engikumuꞌ nene Belezebulodatiꞌ amuzo disa sikalahuꞌ goloso nene ngimiseli nihulave li ma li-ngidadiniko lengiꞌ nene di gonitoꞌ i-lingidadine. Oꞌove. Ingine Belezebulodatiꞌ amuzo damaaꞌ aniꞌ neꞌmino nazasi ezelatiꞌ damo Oꞌmosolatikovoꞌ amuzo daaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Idoꞌ neꞌmine ogaꞌ nouvoniꞌ nene Oꞌmosoꞌmi Sikalahuꞌ neꞌmo neleꞌmize aka ivo sikalahuꞌ goloso ngimisele hulaaꞌ nooloniꞌ nene Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ogo amuzoꞌve nene do sotoꞌ ogo nolengelebizive. ");
INSERT INTO aso_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Eveneꞌ maliꞌmo ve ma gasava daaꞌ ive mineliveliꞌmi numuꞌveuꞌ dizo aꞌmine gasava daaꞌ iveꞌmo gizebo ogo minineꞌ initeꞌve ipeꞌ ogo dalineꞌ nene haza dizo ipeꞌ ogo damoloseive. Asi aꞌmine gasava daaꞌ ive nene gomuꞌ ivileꞌ ogo nalaꞌ do-mikosavoꞌ nene dizo initeꞌve ipeꞌ ogo daloseive. Aꞌmineꞌmine ogo naza nene Satani ivileꞌ ogosa eveneꞌ eitatiꞌ nene do nenita ogaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Idoꞌ ve ma ingine nenita giꞌmizi minamave nene neniꞌ lovo i nimaaꞌ ave nene nizave. Idoꞌ ve ma ingine nenikisi makaꞌ mino eveneꞌ do nenita amunive nene eveneꞌ ngimiseli di hutileꞌ i huli-ngidaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nemuꞌ nene lo-lengemeloze. Gililo. Eveneꞌ ingine goloso initeꞌ ato atoꞌ igaꞌ aniꞌ neꞌmi lihime idoꞌ Oꞌmosomuꞌ idoꞌ evenekumuꞌ divi lediviꞌ igaꞌ aniꞌ neꞌmi lihime nene Oꞌmosoꞌmo ha hulo-ngedeleseiha Oꞌmosoꞌmi Sikalahuꞌ divi ledivika ma i-dilizaniꞌ nene lihimetine mo kekeꞌ hulo-lengedamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ee, ve ma ingine gamazi goloso li Oꞌmosolatiꞌ ve gihile neniꞌ divi ledivika li-nidilizaniꞌ lihime nene Oꞌmosoꞌmo ha hulo-ngedeleseiha gamazi goloso li Oꞌmosoꞌmi Sikalahuꞌ divi ledivika li-dilizaniꞌ lihime nene apase-ngedamivo alingeꞌ gamene nabauꞌ lihimeꞌine apase-ngedo goniꞌ o-ngedeli gameneuꞌ nesi ha minivo mine do vo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Eveneꞌ ingine za nene lamineꞌ nolihe goloso nolihe nene zaliꞌmi gihileꞌvelotiꞌ nene lubamu ningi gililisave. Nemuꞌ nene za maliꞌmo goloso nolineꞌ nene gihileꞌvesi goloso mineleseive. Idoꞌ za maliꞌmo lamineꞌ nolineꞌ nene gihileꞌvesi lamineꞌ mineleseive. Idoꞌ eveneliti monovo nene aꞌmineꞌmine ogo ningo gelelesane. ");
INSERT INTO aso_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lingine Sataliꞌmi izipahala zuho nene nizave. Eveneꞌ luꞌninguꞌ goꞌzikaniꞌ initeꞌ nene veꞌningutiꞌ li hulaaꞌ nanako lingine lutinguꞌ golososi minivo nizaniꞌ nete gamazi lamineꞌ nene ngeli mo lamilisave. ");
INSERT INTO aso_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Eveneꞌ lamineꞌ neꞌmi lulouꞌ nene gamazi lamineliꞌmo vaiꞌ lo neinako neꞌmo nene monovo lamineꞌ do sotoꞌ ogaꞌ neive. Idoꞌ eveneꞌ goloso neꞌmi lulouꞌ nene gamazi goloso neꞌmo vaiꞌ lo neinako neꞌmo nene monovo goloso do sotoꞌ ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Idoꞌ ma lo-lengemeloze. Gililo. Gamazi goloso gidini mukiꞌ nene haza gamazi nehe li gopo ma li nilizaniꞌ nene aꞌminemuꞌ Oꞌmosoꞌmo gamene nabaloꞌ goniꞌ o-ngedo longoꞌ o-ngedavo eveneꞌ mukiꞌ aꞌmine laniꞌ gamazi nene li sotoꞌ ikevo neꞌmi lihime ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Geiꞌ gamazika lilineꞌ neꞌmo ogo molo ilineꞌ monovoka nene do sotoꞌ ogavo lamineꞌ o nolineꞌ nene ve lisiheꞌ ve lo Oꞌmosoꞌmo lo-gedeleseive. Idoꞌ goloso o nolineꞌ nene ve goloso ve lo-gedo lihime gemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Neꞌmine lo lo-ngemavo monoꞌ monovo apizi ngimaaꞌ ave idoꞌ Halisaioꞌ monoꞌ laaꞌ ave linge ingine gamazi tiꞌ li li-imaniꞌ: Tisazo, gaza Oꞌmosoꞌmo amuzo gimineꞌ nene lelebizo atoliꞌmine suno ma do sotoꞌ oganivo ningelone. ");
INSERT INTO aso_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Mene gameneloꞌ nizave lingine eveneꞌ golosovoꞌ mini veneꞌ ma vaꞌningine huli ve gohi maloꞌ vi lihime daaꞌ naniꞌ neꞌmine igi Oꞌmosotine huli lihime daaꞌ nave. Lingine nenikumuꞌ atoliꞌmine suno do sotoꞌ ogo Oꞌmosoꞌmo amuzo nimineꞌ nene lengelebizelongumuꞌ nilaniꞌza ma lengelebizamolosuve. Oꞌmosoꞌmo gozopoꞌ eze veletiꞌ gamazi lo sotoꞌ ogaꞌ ive Zonada initeꞌ do sotoꞌ ogo amuzoꞌve ngelebizineꞌ neꞌmine initeꞌ ma nenita sotoꞌ ogavo nevoꞌ ningilisave. ");
INSERT INTO aso_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Aꞌmine ningilizaniꞌ initeꞌ nene neꞌmino neive: Zonaꞌni nene alahaꞌ nabaliꞌmo do mikileꞌ ogavo neꞌmi gatunouꞌ gamene sitohamo minineꞌ neꞌmino Oꞌmosolatiꞌ ve gihile naza nene misuboꞌmi lulouꞌ gamene sitohamo minelesuve. ");
INSERT INTO aso_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Idoꞌ Nineve aleve ingine Zonaꞌ monoꞌ gamazi lo-ngimineꞌ nene gilii luꞌine di velepeꞌ izaniꞌza lingine giliꞌ nalo. Naza Zonaꞌni ivileꞌ ogo minuve mene ogo lengiꞌ vovotinguꞌ mela sotoꞌ ogo mino gamazi lo-lingimuvodoꞌ nene gili lutine di velepeꞌ izamanako gamene nabala nene Nineve aleve nete oti lengiꞌ lihimetine li sotoꞌ i-lingidi gonitoꞌ lengeleꞌmize milalisave. ");
INSERT INTO aso_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Idoꞌ guvelesi veneꞌ naba aza emala misubo monovo liginela gizebo o minineꞌ misubo Seba nene hulo avotemoti guveꞌinesi ve naba Solomoniꞌ laaꞌ ineꞌ gamazi lamineꞌ nene gelelesa aka haꞌna haꞌna goloso aniꞌza neniꞌ nene Solomoniꞌni ivileꞌ ogo mino mela lengiꞌ vovotinguꞌ sotoꞌ ogo mino gamazi lamineꞌ noluvoniꞌ nene lingine gilisaꞌmave. Nemuꞌ nene gamene nabala aꞌmine guvelesi veneꞌ naba neꞌmo nene oto lihimetine lo sotoꞌ ogo goniꞌ o-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sikalahuꞌ goloso maliꞌmo ve maliꞌmi lulouꞌ miningutiꞌ hulo-do vilineꞌ nene mine gelo minelineꞌ ebekumuꞌ nene ebeꞌ gokota visetoꞌ voloseive. Viseꞌ ilineꞌza ma ningamilineꞌ nene ");
INSERT INTO aso_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tiꞌ lo loloseive: Naza ganaꞌ hulo uvoniꞌ numuꞌnela tineꞌ molo volove. Neꞌmine lo tineꞌ molo ogo ningelineꞌ nene pipiaꞌ gisi di lisiheꞌ ikeniꞌ neiha aꞌminguꞌ eveneꞌ ma ingamaniꞌ neivo ningeleseive. ");
INSERT INTO aso_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ningo gohi vo sikalahuꞌ goloso seveni eze ivileꞌ igi goloso naba gehepeve minaniꞌ nene ngeleꞌmizo ogavo aꞌminguꞌ dizi aꞌmine veꞌmi lulo nene ingine numuꞌine loloꞌ ogavo minilizaniꞌ nene gomuꞌ aꞌmine ve minaaꞌ ineꞌ nesi ivileꞌ ogosa goloso nabaloꞌ mine molo mineleseive. Idoꞌ neꞌmine monovo nene lingine ve goloso idise nizaniꞌ aleve lengita sotoꞌ oloseive losa noluve. ");
INSERT INTO aso_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Izesuꞌ aza di geseꞌ ave mukiꞌ nene gamazi ha lo-ngemo neivo izeleho idoꞌ akunolo zuho ingine gamazi li-imilisa igi heta oti minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Igi oti nizavo ve maliꞌmo tiꞌ lo lo-imineꞌ: Gelezo. Izaho idoꞌ nakuna zuho ingine gamazi lo-gemelone li heta home igi oti nizave. ");
INSERT INTO aso_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Izeꞌnehinemukisi idoꞌ nakuꞌnemotinemukisi nolabe. Nemuꞌ naza lolove. ");
INSERT INTO aso_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Neꞌmine lo eꞌmeti monaniꞌ alevela nene ana hisuꞌ noogo tiꞌ lo lineꞌ: Izeꞌnemote nakuꞌnemote nene mene nizaniꞌ ve. Nene nanitekumuꞌ noluve. Okulumokuꞌ meꞌnehi luloloꞌ igi mili igaꞌ nave engiꞌ nene izeꞌnemote nakuꞌnemote ne nizaniꞌ nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nelotiꞌ aꞌmine gameneuꞌ nene Izesuꞌ aza numuno nene hulo nGalilaia noso ohuno gahevela nene lemo vo mitoꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aꞌmida nene eveneꞌ vaiꞌ goloso di nubo adiꞌmo sipiuꞌ dizo mitoꞌ minavo eveneꞌ mukiꞌ ingine noso gahevela oti minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nizavo Izesuꞌ aza initeꞌ mukikumuꞌ nene aneza gamaziutiꞌ lo-ngemo minineꞌ. Lo-ngemo mino aneza gamazi ma tiꞌ lo lineꞌ: Lingine giliꞌnalo. Ve ma zuho initeꞌ tileꞌ ogaꞌ iveliꞌmo zuho initeꞌ tileꞌ olosa vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Vo tileꞌ oꞌmo novivo zuho initeꞌ linge ma nene akaloꞌ diꞌmozikevo nama nete igi di naniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Idoꞌ linge ma nene gehedoꞌ misubo naba minamidoꞌ diꞌmozi misubo nene naba nomineꞌ neꞌmo zuho initeꞌ nene liteꞌ li gala hoꞌli dizaniꞌza ");
INSERT INTO aso_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","hoꞌ nene dizo amuzo molo lavo luhive vaiꞌ damaniꞌ nenako neꞌmo gulugulu izaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Idoꞌ ma nene gasava guvise huki hulikevo luhive ha minidoꞌ diꞌmozi gala hoꞌli dizaniꞌza gasava guvise neꞌmo dizo molo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Neꞌmine aniꞌza linge ma misubo laminekuꞌ diꞌmozaniꞌ nete nene gala hoꞌli dizi gihile izaniꞌ nene hamo hamolite vanu hadeti (100) idoꞌ sigisiti (60) idoꞌ teoti (30) neꞌmine iziꞌmi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gatine ngoloꞌ live ma nii ma nene gili lamineꞌ ilo. ");
INSERT INTO aso_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Neꞌmine ogavo alingeꞌ izipahala zuho ingine ezela vi tiꞌ li longoꞌ i-daniꞌ: Eveneꞌ initekumuꞌ lo-ngemelesa aneza gamaziutiꞌ lo-ngemaaꞌ naineꞌ nene nanitekumuꞌ lo-ngemaaꞌ nane. ");
INSERT INTO aso_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Okulumokuꞌ minive Oꞌmoso neꞌmo gizebo o-ledelingumuꞌ sunoꞌ gamazi nene lengiꞌ ha gililisave lavo lo sotoꞌ o-lengemaaꞌ nouvoniꞌza eveneꞌ linge mala nene gililizave lamive. ");
INSERT INTO aso_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Idoꞌ nanimuꞌ ve. Ve ma ingine monoꞌ ma di nilizaniꞌ nene Oꞌmosoꞌmo gohi ma ngemavo di vaiꞌ li di minilisave. Idoꞌ monoꞌ ma di minamilizave nene engita monoꞌ ngomo ma nolineꞌ nene aꞌminesi gohi ipeꞌ ogo do voloseive. ");
INSERT INTO aso_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nemuꞌ nene ingine ningii ningi guni isaꞌmanako idoꞌ gilii gili guni isaꞌmanako nemuꞌ nene naza aneza gamazivoꞌ nene lo-ngemaaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Idoꞌ neꞌmo nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete Isaiaꞌni Oꞌmosoꞌmo tiꞌ lo lo-imineꞌ gamazi lineꞌ ma nene engitoꞌ vo gihile izave: Gatinedunuꞌ nene ha gililisaniꞌza gili vevesamilizadoꞌ o neive. Idoꞌ vetinedunuꞌ nene ningaaꞌni ha ningilisaha initeꞌ ma ningamilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Neꞌmine losa imineꞌ molo Isaiaꞌni tiꞌ lo lo-imineꞌ: Idoꞌ mene aleve nene veꞌine liko gaꞌine ngi lo luꞌine hize tile vineꞌ nizave. Neꞌmo nene veꞌinedunuꞌ initeꞌ ma ningisaꞌmave. Idoꞌ gaꞌinedunuꞌ gamazi ma gilisaꞌmave. Idoꞌ luꞌinedunuꞌ gamazi gili hehe lisaꞌmave. Ingine nene neꞌmine amadiniko luꞌine di velepeꞌ izikevo ha do lamineꞌ o-ngiduvodine. ");
INSERT INTO aso_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Gomuꞌ polohete mukiꞌ minaniꞌ netesi idoꞌ monoꞌve lisiheꞌ lamineꞌ mukiꞌ netesi ingine neniꞌ ogo molo nouvoniꞌ initeꞌ idise lingine nininganiꞌ memuꞌ nene ningelobo li gilaniꞌza ma ningamaniꞌ ve. Idoꞌ laaꞌ nouvoniꞌ gamazi idise lingine gatinedunuꞌ nigilaniꞌ nene gelelobo li minaaꞌ aniꞌza gilamaniꞌ ve. Nemuꞌ nene aꞌmine ningi gili nizaniꞌ initeꞌ nene Oꞌmosoꞌmo initeꞌ gihile nene lengeme neize. Longolize izi minilo. ");
INSERT INTO aso_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nemuꞌ nene aneza gamazi zuho initeꞌ tileꞌ ineꞌ neꞌmi monovo ma nene mene gililo. ");
INSERT INTO aso_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ve ma zuho initeꞌ tileꞌ ogavo linge ma akaloꞌ diꞌmozave luvoniꞌ maꞌmi monovo nene neꞌmino neive: Oꞌmosoꞌmo gizebo o-ledeli gamazi lamineꞌ nene gilii gili lamineꞌ amave engitatiꞌ nene goloso meleho aza ogo Oꞌmosoꞌmo eveneꞌ luꞌninguꞌ zuhoꞌ ineꞌ gamazi nene do vaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Idoꞌ zuho initeꞌ linge ma gehedoꞌ diꞌmozave luvoniꞌ maꞌmi monovo nene neꞌmino neive: Eveneꞌ ma ingine Oꞌmosoꞌmo gamaziꞌve tileꞌ ineꞌ nene gilii liteꞌ li gili laniteꞌ igi di goꞌzaaꞌ naha ");
INSERT INTO aso_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","aꞌmine gamazi neꞌmo luꞌninguꞌ luhise do minelidoꞌ mini mili minamavo gamene haꞌnamuꞌ gili di minisaꞌmave. Idoꞌ gamene haꞌnamuꞌ gili di minisaꞌmaniꞌ nene ingine aꞌmine gamazi nene gili-nidavo neꞌmo engita geni sotoꞌ o ngemelihe goboni malaꞌ malaꞌ ngemelihe. Ineꞌ nene geti hulaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Idoꞌ zuho initeꞌ linge ma nene gasava guviseuꞌ diꞌmozi gala hoꞌli dizaniꞌza gasava guvise goloso neꞌmo molo hite-ngidineꞌ nene eveneꞌ ma ingine Oꞌmosoꞌmi gamazi nene mo gili di goꞌzaniꞌza okoꞌineꞌmi initekumuꞌ gaꞌine aꞌmidokovoꞌ gili minaaꞌ idoꞌ monimuꞌ ngumo hilivo minaaꞌ aniꞌ neꞌmo dizo Oꞌmosoꞌmi gamazi inginela lemo minineꞌ nene molo hite-davo inginela dizo gihile izamaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Idoꞌ zuho initeꞌ linge ma misubo laminekuꞌ diꞌmozave luvoniꞌ ma nene eveneꞌ malite Oꞌmosoꞌmo gamazi tileꞌ ineꞌ nene gilii gili vevesi di minave engita nene gihile izaaꞌ neive. Ee, gihile hamototiꞌ gihile vanu hadeti (100) izaaꞌ neineꞌ neꞌmino ve malitida nene vauve goloso elosa izaaꞌ neive. Idoꞌ zuho niteꞌ hamototiꞌ gihile sigisiti (60) izaaꞌ neineꞌ neꞌmino ve mala nene vaiꞌ goloso izaaꞌ neive. Idoꞌ zuho niteꞌ hamototiꞌ gihile teoti (30) izaaꞌ neineꞌ neꞌmino ve mala nene mukiꞌ izaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Neꞌmine lo Izesuꞌ aza aneza gamazi gohi ma lo-ngimineꞌ nene neꞌmine lo lo-ngimineꞌ: Okulumokuꞌ miniveꞌmo evenetoꞌ gizebo ogaꞌ ineꞌ neꞌmi monovo nene ve maliꞌmo miꞌveuꞌ viti gihile lamineꞌ nene zuhoꞌ ogo neloꞌ gizebo ogaꞌ neineꞌ neꞌminosa nene neive. ");
INSERT INTO aso_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gamene ma holukaꞌ mine melehosi idoꞌ eze zuhosi ingine ingi hilikevo lovo o emaaꞌ iveliꞌmo ogo viti gele vineꞌ guvise goloso nene viti zuhoꞌ inguꞌ nene tileꞌ oꞌmo voloseive. ");
INSERT INTO aso_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Neꞌmine ogavosa alingeꞌ viti nene dizo gihile izelesa neivosa viti gele vineꞌ guvise masi nene aꞌminguꞌ golo dizo sotoꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Neꞌmine ogavo agove izipe ingine mine melehine vi tiꞌ li li-imaniꞌ: Guvekasi ve gaza mingauꞌ nene viti laminekovoꞌ ma zuhoꞌ aineꞌ ma nene aꞌminguꞌ viti gele vineꞌ guvise goloso masi nene dizako nadosa dizive. ");
INSERT INTO aso_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Likevo mine meleho tiꞌ lo lo-ngimineꞌ: Lovo vete maliꞌmo nene zuhoꞌ o noloseive. Neꞌmine lavo agove izipe ingine tiꞌ li li-imaniꞌ: Nemuꞌ nene gaza aꞌmine guvise goloso nene leliꞌ kiselilizave losa gele nabe. ");
INSERT INTO aso_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Lingine viti gele vineꞌ guvise nene nokiselube li vitisi kiselikelizanako nemuꞌ oꞌve noluve. ");
INSERT INTO aso_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nemuꞌ nene aꞌmine guvise goloso nesi makaꞌ dizi nizavo viti hukiliza gamene nene alitelive. Viti hukaaꞌ gamene alitelineꞌ nene viti hukaaꞌ ave tiꞌ lo lo-ngedelesuve: Gomuꞌ nene guvise goloso nene olokuꞌ gizeloningumuꞌ huki di goꞌno izi atoꞌ di nubo i-ngidi alingeꞌ vitila nene huki di vi neniꞌ mino molo ogaꞌ uvoda milalizave lolosuve. ");
INSERT INTO aso_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Idoꞌ Izesuꞌ aza aneza gamazi gohi ma tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo miꞌveuꞌ nabaꞌmine sakaveꞌ zuho hamoꞌ ma do zuhoꞌ ogavo gala hoꞌlo dizo naba ilineꞌ neꞌmino Oꞌmosoꞌmi gizebouꞌ vi hilaliza aleve engiꞌ neti muliseꞌine nene vo naba oloseive. ");
INSERT INTO aso_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aꞌmine zuho initeꞌ nene ngomo lasolo mino zuho initeꞌ ato atoꞌ mukiꞌ nene ngivileꞌ ogo ngomo minineꞌza zuhoꞌ ogavo gala hoꞌlo dizo minguꞌ zuhoꞌ igaꞌ naniꞌ initeꞌ mukiꞌ nene ngivileꞌ ogo initeꞌ naba loloꞌ ogo za neꞌmine mineleseive. Neꞌmine ogavo namalite igi aꞌmine initeliꞌmi aꞌnavauꞌ nene numuno gizi ingaaꞌ nave. Aꞌmineꞌmine igi Oꞌmosoꞌmi evenele zuho nene vi naba ilisave. ");
INSERT INTO aso_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Idoꞌ Oꞌmosoꞌmo gizebo o-ngedeli alevetinguꞌ nene monoꞌ vo naba ilingumuꞌ aneza gamazi gohi ma tiꞌ lo lo-ngimineꞌ: Gizebo o-ngedelineꞌ alevetinguꞌ Okulumokuꞌ minive Oꞌmosoꞌmo gono daaꞌ neineꞌ nene beleti do lulu izaaꞌ ineꞌ initeꞌ zisiti neꞌmine neive. Veneꞌ maliꞌmo beleti loloꞌ olosa palauvaꞌ beki ngomo sitohamo nene do nososi do gopo ogo aꞌminguꞌ zisiti ngomosi do gopo ogavo neꞌmo beleti nene lulu izo naba ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Eveneꞌ mukiꞌ di geseꞌ aniꞌ gameneuꞌ Izesuꞌ aza initeꞌ mukiꞌ lo-ngemelesa ineꞌ nene aneza gamaziutikovoꞌ lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Neꞌmino lo-ngimineꞌ neꞌmo nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive maliꞌmo gamazi ma tiꞌ lo lineꞌ ma nene gihile izineꞌ: Veꞌneutiꞌ nene aneza gamaziutikovoꞌ nolo-ngemo gozopoꞌ akaꞌmila misubo olihe sotoꞌ amivo haleko minineꞌ gamazi nene lo soto sotoꞌ olosuve. ");
INSERT INTO aso_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nelotiꞌ nene Izesuꞌ aza di geseꞌ ave mukiꞌ nene hulo-ngedo numunguꞌ dizo minineꞌ. Neivo izipahala zuho ezela igi viti minguꞌ guvise goloso dizive lo aneza gamazi laineꞌ maꞌmi monovo ma lo ngoloꞌ lo lo-lemanivo gelelone li Izesuꞌni li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Li-imikevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Eveneꞌ viti gihile zuhoꞌ ive nene Oꞌmosolatiꞌ ve gihile naza nene nouve. ");
INSERT INTO aso_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Idoꞌ mine neve nene misubo mukikumuꞌ nene neive. Idoꞌ viti gihile lamineꞌ neve nene Oꞌmosoꞌmo gizebo inguꞌ mini mili minaniꞌ alevemuꞌ nene neive. Idoꞌ viti gele vineꞌ guvise goloso ve luvoniꞌ nene ve goloso Satanila mini mili minaniꞌ aleve nemuꞌ nene neive. ");
INSERT INTO aso_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Idoꞌ lovo ve guvise goloso zuhoꞌ ive nene Satani nemuꞌ luve. Idoꞌ viti hukaaꞌ gamene alitelinguꞌ ve luvoniꞌ nene eveneꞌ misubouꞌ mini mili miniliza gamene osuꞌ lavo gamene naba alitelingumuꞌ nene luvoniꞌ ve. Idoꞌ viti hukilizave ve luvoniꞌ nene angelokumuꞌ luvoniꞌve. ");
INSERT INTO aso_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Idoꞌ guvise goloso nene huki di nubo igi olokuꞌ gizilisave luvodiꞌmine ogo eveneꞌ misubouꞌ mini mili minilizaniꞌ gamene nene osuꞌ lavo gamene naba alitelinguꞌ nene neꞌmine ilisave. ");
INSERT INTO aso_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Oꞌmosolatiꞌ ve gihile naza angeloꞌne zuho nene ngimiselekuvo ingine vi eveneꞌ neze gizeboloꞌ mini mili minanguꞌ nene eveneꞌ ngeleꞌmize goloso igaꞌ naniꞌ initeꞌ mukiꞌ nesi idoꞌ Oꞌmosoꞌmo lo hukineꞌ gamazi gili huli goloso initeꞌ daaꞌ ave mukiꞌ nesi nene ngeleꞌmizi vi di nubo i-ngidi ");
INSERT INTO aso_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","oloꞌ nabauꞌ huli-ngidilisave. Huli-ngidikevo aꞌminguꞌ nene mini agae agae li ive nama igi mulumo alumo gili veꞌine ingihi langoloꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Idoꞌ eveneꞌ lisiheꞌ lamineꞌ ingine nene meꞌnibo Oꞌmosoꞌmo gizebo o-ngidinguꞌ nene hoꞌ neꞌminisa labanaꞌ ili minilisave. Nemuꞌ nene eveneꞌ ma lingine gili nge li gilaaꞌ ave ma nii ma nene gililo. ");
INSERT INTO aso_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Oꞌmosoꞌmi gizebouꞌ minaaꞌ nene lamineꞌ goloso neineꞌ nenako eveneꞌ ingine initeꞌ mataꞌine aꞌminemuꞌ huli aꞌminguꞌ vi hilalizaniꞌ monovo nene neꞌmino neive: Ve maliꞌmo meniꞌve dizo minineꞌ initeꞌ haleko misubo mauꞌ minineꞌ nene ningo do sotoꞌ ogo huloko olize izeꞌmo numuꞌvela tineꞌ molo vo initeꞌ mataꞌve nene meni do osuꞌ lo gohi tineꞌ molo ogo meniꞌve dizo minineꞌ initeꞌ haleko minineꞌ misubo maꞌmi melehine nene meni emo misubo do eita ogaꞌ neineꞌ neꞌminosa ne neive. ");
INSERT INTO aso_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Idoꞌ ma nene Okulumokuꞌ miniveꞌmi gizebouꞌ minaaꞌ nene lamineꞌ goloso neineꞌ nenako initeꞌ mataꞌ mukiꞌ nene hulo osuꞌ lo aꞌminguꞌ vo holaaꞌ neꞌmi monovo nene neꞌmino neive: Ve ma situvaꞌ molaaꞌ ive maliꞌmo gonolise initeꞌ laminekumuꞌ viseꞌ oꞌmo moninguꞌ nene ");
INSERT INTO aso_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","viseꞌ oꞌmo monineꞌ initeꞌ mukiꞌ ngivileꞌ ogo lamineꞌ goloso mino meniꞌve nabaloꞌ goloso minineꞌ ma ningosa tineꞌ molo vo initeꞌ mataꞌve mukiꞌ nene meni do osuꞌ lo gohi tineꞌ molo ogo gonolise initeliꞌmi melehine nene meni emo aꞌmine initeꞌ do eita ineꞌ neꞌminosa ne neive. ");
INSERT INTO aso_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Idoꞌ ma nene Okulumokuꞌ gizebo o miniveꞌmo aꞌmine gizebo o mininguꞌ vo holaloningumuꞌ eveneꞌ izeꞌ molo-ngedeli monovo nene neꞌmino neive: Ve ma alahaꞌ daaꞌ iveꞌmo alahaꞌ daaꞌ golalezeꞌ nene hulo nosouꞌ ogavo ato atoꞌ alahaꞌ nene aꞌminguꞌ dizi minaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dizi mini vaiꞌ likevo alahaꞌ daaꞌ ive neꞌmo geleleheꞌ ogo hulo gahevela ogo mitoꞌ mino lamineta nene gizekaꞌ ogo gokuꞌ goꞌzo golosola do hulaaꞌ neineꞌ neꞌminosa ne neive. ");
INSERT INTO aso_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nemuꞌ nene eveneꞌ misubouko mini mili iliza gamene nene osuꞌ lavo gamene nabala sotoꞌ ilineꞌ initeꞌ nene neꞌminosa sotoꞌ oloseive: Angeloꞌ ingine igi eveneꞌ lisiheꞌ lamineliti vovoꞌninguꞌ eveneꞌ goloso miniꞌmi monaniꞌ nene izeꞌ mili huli atoꞌ i-ngidi ");
INSERT INTO aso_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","di vi oloꞌ nabauꞌ huli-ngidikevo aꞌminguꞌ nene veꞌine ingihi langoloꞌ igi agae agae li ive nama igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nemuꞌ nene lingine initeꞌ mukiꞌ mene luvoniꞌ nemuꞌ mo gilikehe lo Izesuꞌ lavo izipahala zuho ingine tiꞌ li li-imaniꞌ: Ee, mo gelekune. ");
INSERT INTO aso_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Nemuꞌ nene numuno meꞌninge ma initeꞌ milikangutiꞌ initeꞌ gosohokisi litehesi di sotoꞌ igi engiꞌ numuꞌninguꞌ minave ngimaaꞌ naniꞌ neꞌminisa linginesi monoꞌ monovo apizi ngimaaꞌ nave mukiꞌ nesi Okulumokuꞌ miniveꞌmo evenetoꞌ gizebo o-ngedeli monovomuꞌ gili vevesave mukiꞌ nene monoꞌ gosohokisi litehesi di sotoꞌ igi eveneꞌ apizi ngimilisave. ");
INSERT INTO aso_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Izesuꞌ aza neꞌmino aneza gamazi mukiꞌ nene lo-ngemo osuꞌ lo aꞌmine ebeꞌ nene hulo ");
INSERT INTO aso_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","eiꞌ numuno ebeꞌve gihile Nasaletela vo hetelineꞌ. Vo hetelo aꞌmida veneꞌ vemohoꞌ nene monoꞌ numuꞌninguꞌ Oꞌmosoꞌmi gamazi nene lo-ngimineꞌ. Neꞌmine ogavo eveneꞌ mukiꞌ ingine voꞌine goloso vavo tiꞌ li laniꞌ: Neꞌmine manaꞌmine suno nesi idoꞌ gamazi nesi zaukotiꞌ do ave. ");
INSERT INTO aso_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aza ha kamuda maꞌmi gipele neive. Izeleho nene Maliaꞌ ve li-daaꞌ naniꞌ veneꞌ ne neive. Olo. Nakunolomote nene Zakobole Zosehele Simonile idoꞌ Zudale nene nizave. ");
INSERT INTO aso_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Idoꞌ alunolo zuho nesi makaꞌ lelikisi mene none. Aza ha aꞌneꞌmine ve neineꞌ nenako nemuꞌ nene monoꞌ laaꞌ idoꞌ atoꞌ suno do sotoꞌ ogaꞌ neineꞌ monovo nene zalatiꞌ do ave. Do aniꞌ aka nene ma ningamuniko. ");
INSERT INTO aso_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Neꞌmine li Izesuꞌnimuꞌ nene muluꞌninguꞌ goloso gilaniꞌza aza tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ ave polohete engikumuꞌ nene eveneꞌ mukiꞌ gilavo dizisa minaaꞌ naha engiꞌ zuho gihile lamineꞌ netesi idoꞌ misuboꞌninguꞌ aleve netesi nene engikumuꞌ gilavo dizesaꞌmineꞌ neꞌminosa nazasi nouve lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Idoꞌ Izesuꞌ numuꞌve ebeꞌvelotiꞌ aleve ingine ezemuꞌ gili eleꞌvoleꞌ isaꞌmaniꞌ nenako nemuꞌ nene engita Oꞌmosoꞌmi amuzo do sotoꞌ ogo ato atoꞌ suno nene mukiꞌ do sotoꞌ osaꞌmineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aꞌmine gameneuꞌ nene Izesuꞌ guvele monivo guvelesi ve Helodeꞌ nene gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gelo gelekeleꞌ izipahala nene tiꞌ lo lo-ngimineꞌ: Mene ve nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ noloseive. Bele helekuvoniꞌ mautiꞌ otineꞌ neꞌmo ato atoꞌ suno daaꞌ amuzo nene ezela neivosa ato atoꞌ suno nene nodaloseive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Neꞌmine lineꞌ nene hazamuꞌ lamive. Gomuꞌ galaꞌmuda vomine Helodeꞌ aza akunolo Hilipoꞌ elenaho Helodiaꞌni gumine daniꞌ. Gumine davo monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ neꞌmo akunaꞌmi elenahine daineꞌ nene lisiheꞌ amive lo Helodeꞌni lo-emeꞌmo vo minineꞌ. Neꞌmine lo lo-emeꞌmo vo minivo nemuꞌ Helodeꞌ aza Helodiaꞌnimuꞌ ogo aꞌmine Zohaneꞌni nene vi dalizave lo eveneꞌ ma ngimiselavo vi analoꞌ di nalava imi eleꞌmizi di vi nalaꞌ numunguꞌ huli-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helodeꞌ aza Zohaneꞌni bele helelesa gilineꞌza eveneꞌ nete Zohaneꞌnimuꞌ nene polohete neive li gili nizanako lo ehelele izavo hulo-mikineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Neꞌmine ogavo neivo Helodeꞌ sotoꞌ ineꞌ gamene ogavo eiꞌ numunguꞌ di geseꞌ igi nosoꞌ niteꞌ ni nizavo eveneꞌ mukiꞌ neti veꞌnidoꞌ Helodiaꞌ aluvo neꞌmo denisi ineꞌ nene Helodeꞌ ningineꞌ umo goloso hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Umo helavo aꞌmine alu neꞌmo initeꞌ ma gelelineꞌ initeꞌ nene ha emelesuve lo Oꞌmosoꞌmi veleloꞌ nolo hukuve lo lo hukineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Neꞌmine lo lo hukavo alungo nene izeleho gala do lidoꞌ lidoꞌ ogo Helodeꞌni tiꞌ lo lo-imineꞌ: Monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ godolo nene giti lapeseuꞌ mili di nimilo. ");
INSERT INTO aso_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Lavo guvelesi ve Helodeꞌ aza eii lo gelo agae lo gilineꞌza aza mo Oꞌmosoꞌmi velelokisi ezesi makaꞌ minaveti veꞌnidokisi gamazi lo huko lo neineꞌ ma nenako Zohaneꞌ godolo nene di di alo lo ");
INSERT INTO aso_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","eveneꞌ ngimiselavo vi nalaꞌ numunguꞌ luvono giti ");
INSERT INTO aso_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","godolo nene di igi alungo nene imikevo do vo izelehine imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Neꞌmine ikevo Zohaneꞌ izipahala zuho ingine okoꞌnoꞌve nene di vi galese izi-di Izesuꞌni vi li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Li-imikevo gelo Helodeꞌ ezemuꞌ lineꞌ gamazi nesi mo gelo aꞌmine minineꞌ ebeꞌ nene hulo sipiuꞌ dizavo izipahala zuho aꞌminguꞌ eleꞌmizi vi angiseꞌinevoꞌ minilizada ebeꞌ gaꞌmeta vaniꞌ. Idoꞌ nivavo eveneꞌ mukiꞌ nemuꞌ gili taunitiꞌ taunitiꞌ misubouꞌ eꞌmeti vilida vi vi hukaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Neꞌmine ikevo Izesuꞌ aza aꞌmine ebeꞌ gaꞌmeta nene vo hetelo sipiutiꞌ lemo aꞌmida eveneꞌ vaiꞌ di geseꞌ igi nizavo ningo mulumoꞌine gelo engikutiꞌ initeꞌ ngisive nene do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Neꞌmine ogo neivo nivengaꞌ molavo izipahala zuho ingine Izesuꞌ neida igi tiꞌ li laniꞌ: Mene ebeꞌ nene eveneꞌ nizamaniꞌ hadiveloꞌ nonivo nivengaꞌ mo molaze. Eveneꞌ mukiꞌ mene vi avita minaniꞌ numuno ebekutiꞌ angiseꞌine naliza nosoꞌ niteꞌ meni hizilizangisi ngimisele hulozo. ");
INSERT INTO aso_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Nanimuꞌ vilizave. Lengiꞌ nene nosoꞌ niteꞌ di ngimilevo. ");
INSERT INTO aso_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Neꞌmine lo lo-ngemavo izipahala zuho ingine laniꞌ: Nosoꞌ niteꞌ lelita nene sikoni faefusi alahaꞌ sitakisi moda aꞌnevoꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Likevo aza lineꞌ: Nene di nouvoda alo. ");
INSERT INTO aso_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Neꞌmine lo eveneꞌ nene guviseloꞌ mitoꞌ minilizave lo Izesuꞌ lavo li-ngidikevo minaniꞌ. Nizavo Izesuꞌ aza sikoni faef nesi alahaꞌ sitaꞌ nesi nene do Okulumotoꞌ vonuꞌ noogo Oꞌmoso opoꞌni lo aꞌmine nosoꞌ niteꞌ nene gito apilo izipahala zuho izeꞌ molo ngemavo eveneꞌ nene di moni ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","nGimikevo eveneꞌ mukitoꞌ ni gatuꞌine aniꞌ. Gatuꞌine ogavo izipahala zuho ingine lumo sama hulaniꞌ nene gosuvahaꞌ tuvelu (12) neꞌmine goꞌzi vaiꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nosoꞌ niteꞌ naniꞌ nene vemohoꞌ faef tauseni (5,000) neꞌminelite naniꞌza veneꞌ izipe nene gatamune. ");
INSERT INTO aso_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Idoꞌ eveneꞌ nene nosoꞌ niteꞌ ni osuꞌ likevo nelotiꞌ Izesuꞌ aza izipahala zuho nene sipiuꞌ dizi noso helala gomuꞌ nivilizave lo ngimiselo aza nene eveneꞌ mukiꞌ numuꞌnida ngimisele hulo huloꞌ ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","nGimisele hulo osuꞌ lo golola eikovoꞌ Oꞌmosola lolosa dizo vineꞌ. Eikovoꞌ dizo vo aꞌmida mino Oꞌmosola lo neivo litiꞌmuso izineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Litiꞌmuso izavo izipahala zuho nene misubo huli hotoꞌ igi noso olusotoꞌ nivavo hepeꞌ naba neꞌmo veꞌnidatiꞌ ogo noso nene sipiloꞌ belekaꞌ belekaꞌ ivo viviꞌ viviꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Neꞌmine iꞌmi nivavo goꞌ loꞌmo lomo nedengaꞌ fo kiloku he faef kiloku he nela nene Izesuꞌ aza noso avileloꞌ lise lise nizada aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nizada noso avileloꞌ navo ningi golise goloso gili mene holoso neive li ngehelele izavo gekeꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gekeꞌ laniꞌza aꞌmidoꞌ geto Izesuꞌ gamazi lo-ngemo tiꞌ lo lo-ngimineꞌ: Neniꞌ ma ne nouze. Lengehelele izamivo mini ngi li minilo. ");
INSERT INTO aso_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Neꞌmine lavo Petoloꞌ tiꞌ lo lineꞌ: Guvekasi ve gaza nene mo geiꞌ lamineꞌ noo ma nene lanivo nosoloꞌ nene ogo geiꞌ nanida alove. ");
INSERT INTO aso_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Neꞌmine lo lavo anevo lo Izesuꞌ lavo Petoloꞌ aza sipiutiꞌ lemo apiꞌ ogo noso avileloꞌ lise lise Izesuꞌ neida volosa ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Volosa ineꞌza novo hepeliꞌmo noso bilineꞌ nene ningo vono vavo golise gilineꞌ neꞌmo nosoliꞌmo do suꞌmize-delesa ineꞌ. Neꞌmine ogavo Petoloꞌ asi lo tiꞌ lo lineꞌ: Guvekasi ve do nuꞌ izevo. ");
INSERT INTO aso_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lavo Izesuꞌ geto ogo ana hulo do hozi nolo-do tiꞌ lo lo-imineꞌ: Gaza nenikumuꞌ gele eleꞌvoleꞌ amo nosoꞌmo nebelelihe nebelamilihe lo nanimuꞌ gaka sitaꞌ gelane. ");
INSERT INTO aso_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Neꞌmine igi sipiuꞌ dizikesivo hepeꞌ nene zou lo matineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hepeꞌ nene matavo sipiuꞌ minave ingine opoꞌni li gubiꞌ izi imi laminetoꞌ geiꞌ nene mo Oꞌmosoꞌmi gipele nane li li-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Neꞌmine igi noso helala vii nGenesalete misubouko heteli sipiutiꞌ limaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aꞌmida nene evenelite Izesuꞌni nene ningi guni aniꞌ. Neꞌmine igi aꞌmidotiꞌ numudoꞌ numudoꞌ gamazi hulikevo eveneꞌ initeꞌ gizi dave nene do lamineꞌ o-ngedelive li ngeleꞌmizi ezela igi ");
INSERT INTO aso_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","amuzo mili tiꞌ li li-imaniꞌ: Okongaloꞌ initeꞌ lolovolokovoꞌ nevone di gililizadotikisi nene lamineꞌ ilizaniꞌ nenako nemuꞌ nene gele ngemanivo di gililizave li laniꞌ. Idoꞌ okoꞌnoloꞌ initeꞌ lolovoloꞌ di gilave mukiꞌ nene mo lamineꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nelotiꞌ nene Halisaioꞌ monoꞌ laaꞌ ave linge masi avoꞌningelite laniꞌ monoꞌ apizi ngimaaꞌ ave linge masi Zelusalemi numudatiꞌ Izesuꞌ neida aniꞌ. Igi tiꞌ li longoꞌ i-daniꞌ: ");
INSERT INTO aso_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Geiꞌ izipaha zuho ingine nosoꞌ niteꞌ nalisa aꞌine noso izamaaꞌ naniꞌ nene avotemote eꞌmetilo li li-limaaꞌ aniꞌ gamazi nene avutoꞌ igaꞌ naniꞌ nene neꞌmine amilizanako nanimuꞌ avutoꞌ igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Idoꞌ langisetine avotemotidatiꞌ monovote nene do minelone li Oꞌmosoꞌmo louꞌ gamazi lo huko-lidineꞌ nene avutoꞌ igaꞌ naniꞌ nene nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Neꞌmine noluvoniꞌ mene lingine tiꞌ igaꞌ nangumuꞌ noluve: Oꞌmosoꞌmo lingine izetingine metinginemuꞌ gilavo dizavo gelekeleꞌ lamineꞌ i-ngidivoꞌ minilo. Idoꞌ ma nene ve maliꞌmo izelehingi melehingi gamazi goloso lo-ngedelineꞌ nene bilikevo helelive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Lineꞌza lingine tiꞌ li laaꞌ nave: Ve maliꞌmo izelehinemupe melehinemupe initeꞌ molo nouvongutiꞌ nene ma gimuvodiba aꞌmine initeꞌ nene mo Oꞌmosomuꞌ ogo molo nouvonako geiꞌ gemamolosuve lo lo-emelineꞌ nene aꞌmine lineꞌ initeꞌ nene izele mele ngemamilineꞌ nene lamineꞌ ve. Neꞌmine laaꞌ naniꞌ nene izelehine melehinemuꞌ gelekeleꞌ lamineꞌ amilineꞌ aka nene siꞌzi-daaꞌ nave. Aꞌneꞌmine aniꞌ nene avotingidatiꞌ di minaniꞌ gamazi neꞌmo Oꞌmosoꞌmo lineꞌ gamazi neve haza niteꞌ loloꞌ ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lingine lutine goloso o vineꞌ nene di halekisa eveneꞌ lamineꞌ gili monaaꞌ nave, polohete Isaiaꞌ Oꞌmosoꞌmi veletiꞌ gamazi tiꞌ lo lineꞌ ma nene lengikumuꞌ lamineꞌ laniꞌ neive: ");
INSERT INTO aso_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mene aleve ingine veꞌine avilelotiꞌ nopoꞌni li neniꞌ gulive di hozi laaꞌ naniꞌ nene luꞌine nezela milamavo luꞌineꞌve nene hotoꞌ minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Haza eveneliti gamazi nene neze gamazi gidini loloꞌ ogavo li-ngimi ngimiꞌ igi minaaꞌ naniꞌ nenako nenikumuꞌ nopoꞌni laaꞌ naniꞌ nene gopo hazamuꞌ laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Neꞌmine lo Izesuꞌ aza eveneꞌ mukiꞌ nene asi lo-ngemo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Lingine initeꞌ ma nikevo neꞌmo eveneꞌ luꞌine do goloso o-ngedaaꞌ neive li gilaaꞌ nahe. Gamazi mene gilii gili nge li gililo. Eveneꞌ luꞌine do goloso o-ngedaaꞌ neineꞌ initeꞌ nene veꞌninguꞌ mili naaꞌ naniꞌ initeꞌ nene nevoba luꞌningutiꞌ dizo veꞌningutiꞌ sotoꞌ ogo leme heta ogaꞌ neineꞌ initeꞌ neꞌmo nene luꞌine do goloso o-ngedaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Neꞌmine lavo alingeꞌ nene izipahala zuho ingine Izesuꞌ neida igi tiꞌ li longoꞌ i-daniꞌ: Halisaioꞌ monoꞌ laaꞌ ave ingine geiꞌ gamazi laningumuꞌ muluꞌninguꞌ goloso ogavo upuhoꞌ aniꞌ nene ningabe. ");
INSERT INTO aso_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Neꞌmine likevo Izesuꞌ aza gamazi tiꞌ lo lo-ngimineꞌ: Okulumokuꞌ meꞌnehi evenele nene eiꞌ miꞌve neꞌmine nizanako aza meꞌneho zuhoꞌ amivo aꞌmine miꞌveuꞌ gopo dizaniꞌ initeꞌ mukiꞌ nene kiselo do huloloseive. ");
INSERT INTO aso_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aꞌmine Halisaioꞌ monoꞌ laaꞌ ave nene ningi mati-ngimikilo. Minilizaze. Ingine eveneꞌ monoꞌ akaloꞌ ngeleꞌmizi vaaꞌ ave nizaniꞌza angiseꞌine aka ningi guni isaꞌmanako veꞌine likivete veꞌine likive ma nene aka ngelebizi vaniꞌ gelave. Nemuꞌ nene vele likive maliꞌmo vele likive ma eleꞌmizo vilineꞌ nene sitatoꞌ galeseuꞌ veleheꞌ limilisasive. ");
INSERT INTO aso_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Neꞌmine lavo Petoloꞌ tiꞌ lo lo-imineꞌ: Gaza gamazi monovoꞌve haleko minineꞌ gepeꞌ gamazi neꞌmine laineꞌ ma nene lo ngoloꞌ lo lo-lemevo. ");
INSERT INTO aso_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ: Izipahaꞌne zuho lingine gili nilisave lo giluvoniꞌza linginesi olihe gili guni amahe. ");
INSERT INTO aso_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Initeꞌ mukiꞌ nene veꞌninguꞌ nikevo gatuꞌninguꞌ lemo ise galeseuꞌ vaaꞌ neineꞌ nene lingine ningi gilamahe. ");
INSERT INTO aso_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ne neineꞌza veꞌningutiꞌ leme heta ogaꞌ neineꞌ initeꞌ nene luꞌningutiꞌ dizo ogaꞌ neinako neꞌmo nene eveneꞌ luꞌine do goloso o-ngedaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Initeꞌ luꞌningutiꞌ dizaaꞌ neineꞌ initeꞌ nene neꞌmino neive: Gaꞌine goloso gilaaꞌ, eveneꞌ ngebele helaaꞌ, veneꞌ vemohoꞌ alungo umungive gopo ingi monaaꞌ, gumine damine ogaꞌ, soza sakupo gamazi laaꞌ idoꞌ eveneꞌ dovo ledevoꞌ ogo ngemenga laaꞌ monovo ne neive. ");
INSERT INTO aso_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mene initeꞌ mukiꞌ neꞌmo nene eveneꞌ luꞌine do goloso o-ngedaaꞌ neive. Eveneꞌ aꞌine noso izami nosoꞌ niteꞌ gopo naniꞌ neꞌmo nene luꞌine do goloso o-ngedesaꞌmive. ");
INSERT INTO aso_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Neꞌmine ogo Izesuꞌ aza aꞌmine minineꞌ misubo nene hulo vo Tilo numuno ebeꞌ idoꞌ Sidoni numuno ebeꞌ neti gahevela minineꞌ misubouꞌ volosa vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aꞌmine numuno ebeꞌ gahevelatiꞌ Zuda veneꞌ minamineꞌ Kanaha veneꞌ maliꞌmo ogo gamazi nabatiꞌ tiꞌ lo lo-imineꞌ: Guvekasi ve, gozopoꞌ guvelesi ve naba Davidiꞌ aꞌvopilemoꞌ ezeloꞌ medelo minanive make, gaza mulumoꞌne ningevo. Alune nene sikalahuꞌ goloso lulouko neivo mo goloso ogo neive. ");
INSERT INTO aso_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Neꞌmine lineꞌza aꞌmine gamaziꞌveloꞌ nene Izesuꞌ gamazi hamokisi mo lo-emamineꞌ. Neꞌmine ogavo izipahala zuho ingine ezela igi tiꞌ li laniꞌ: Veneꞌ mene gamazi loꞌmo loꞌmo leꞌmeto ogo minineꞌ nenako nemuꞌ imiselo huliline lo nogilune. ");
INSERT INTO aso_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Likevo Izesuꞌ tiꞌ lo lineꞌ: Naza nene nimiselive nene Isilaeleꞌ aleve sipisipi neꞌmine mini vi tolovo igi moni minaniꞌ engita vo gono daline lo nimiselavo uvoniꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Neꞌmine lineꞌza veneꞌ aza ogo gizeneuꞌ golo hizo ongo tiꞌ lo lineꞌ: Guvekasi ve, ogo gamaziꞌne gelo hize apase-nedelibo. ");
INSERT INTO aso_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lineꞌ: Izipeliti nosoꞌ niteꞌ ipeꞌ ogo gulo hulo-ngemaaꞌ nene edamive. Oꞌmosoꞌmi izipahala zuho Isilaeleꞌ aleve do lamineꞌ o-ngedaaꞌ nouvoniꞌ nene heta atoꞌ ve geita oloniꞌ nene aꞌmineꞌmine ogo edamilihe lo gele nouve. ");
INSERT INTO aso_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lavo veneꞌ aza tiꞌ lo lo-imineꞌ: Guvekasi ve, izipeliti nosoꞌ niteꞌine ipeꞌ ogo gulo hulo ngemaaꞌ nene edamive lo lamineꞌ laineꞌza meꞌninge nosoꞌ niteꞌ naaꞌ aniꞌ holomolotiꞌ lana doꞌmozineꞌ nene gulo nete ha naaꞌ nave. Nemuꞌ nene heta atoꞌ veneꞌ nenikisi nene gele nemelineꞌ nene ha lamineꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Neꞌmine lavo gelo Izesuꞌ tiꞌ lo lo-imineꞌ: Aizo, veneꞌ mene gaza gele eleꞌvoleꞌ aineka nene mo gele eleꞌvoleꞌ ogo gelane. Nemuꞌ nene gele eleꞌvoleꞌ aineꞌ initeka nene ha sotoꞌ o gemeleseive. Lavo nolineꞌ velesi aluvo nene lamineꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Izesuꞌ aza aꞌmine minineꞌ ebeꞌ nene hulo tineꞌ molo nGalilaia noso ohuno gahevela nene lemo vo gololoꞌ dizo vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Neꞌmine ogavo eveneꞌ mukiꞌ ingine gebili mini gizeꞌine aꞌine goloso o vineꞌ idoꞌ veꞌine like vineꞌ idoꞌ gamazi lamilizaniꞌ o vive idoꞌ initeꞌ gizi dave masi masi mukiꞌ nene ngeleꞌmizi Izesuda vi gizenela ingi-ngidikevo aza do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Neꞌmine ogavo veneꞌ vemohoꞌ mukiꞌ ingine ningi negi nete gamazi apiꞌ igi laniꞌ, okoꞌnidoꞌ goloso ineꞌ aleve lamineꞌ aniꞌ, gizeꞌine goloso o vineꞌ aka monaniꞌ, idoꞌ veꞌine likive gohi veꞌine ninganiꞌ nene ningi voꞌine goloso vavo mini engiꞌ Isilaeleꞌ aleveti Oꞌmosoꞌine nene opoꞌni li guliveꞌve di hozi laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Neꞌmine ogo Izesuꞌ aza izipahala zuho asi lo-ngemavo ikevo tiꞌ lo lo-ngimineꞌ: Mene aleve nene nazasi gamene sito hamo makaꞌ minunidiꞌmo nosoꞌ niteꞌinesi nomivo engikumuꞌ muluꞌne hukave. Akaloꞌ gaꞌnaꞌmo veꞌine gaꞌine monavo diꞌmozikelizave lo nosoꞌ niteꞌ namavo haza ngimiselamolove lo gele nouve. ");
INSERT INTO aso_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Neꞌmine lavo izipahala zuho ingine tiꞌ li laniꞌ: Ebeꞌ hadiveloꞌ nouneꞌ nenako nemuꞌ nene nosoꞌ niteꞌ vaiꞌ adoꞌ eveneꞌ vaiꞌ meꞌminelite nalizaniꞌ votigileloꞌ nene zalatiꞌ dalone. Daloneꞌ akate nene ma nomive. ");
INSERT INTO aso_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Lengita sikoni nanikeꞌ neve. Lavo ingine laniꞌ: Seveni ve idoꞌ alahaꞌ ngomosikisi ma neive. ");
INSERT INTO aso_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Likevo eveneꞌ mukiꞌ nene mitoꞌ minilizave li li-ngidilizave lo Izesuꞌ lavo li-ngidikevo mitoꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Minikevo sikoni seveni nesi alahaꞌ nesi do Oꞌmoso opoꞌni lo nosoꞌ niteꞌ nene gito apilo izipahala zuho izeꞌ molo ngemavo eveneꞌ nene di moni ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","nGimikevo mukitoꞌ ni gatuꞌine aniꞌ. Gatuꞌine ogavo lumo sama hulaniꞌ nene izipahala zuholite gosuvahaꞌ naba seveni neꞌmine goꞌzi vaiꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nosoꞌ niteꞌ naniꞌ nene vemohoꞌ fo (4) tausenilite naniꞌza veneꞌ izipe nene gatamune. ");
INSERT INTO aso_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Neꞌmine ikevo Izesuꞌ eveneꞌ mukiꞌ nene ngimisele huloko sipiuꞌ dizo izipahala zuhosi Magadani misubola vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Halisaioꞌ monoꞌ laaꞌ ave linge masi Sadukaioꞌ monoꞌ laaꞌ ave linge masi Izesuꞌ neida igi emenguꞌ mili tiꞌ li laniꞌ: Gaza Oꞌmosoꞌmo geikisi neive laaꞌ naineꞌ nene lamineꞌ labe gosohoꞌ labe neꞌmi monovo nene ningelonge. Okulumokuꞌ minive Oꞌmoso aza amuzo gemavo gaza atoliꞌmine suno do sotoꞌ ogo lelebizanivo ningelone li li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tiꞌ li li-imikevo aza tiꞌ lo lo-ngimineꞌ: Nivengaꞌ molavo guhizangiꞌ ilineꞌ nene lingine ningi aizeꞌ nene hoꞌ lo gamene lamineꞌ oloseive li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Idoꞌ nedengaꞌ goꞌ lalosa guhizangiꞌ elo limuso gonobuꞌ hitineꞌ nene lingine ningi goline izo hepeꞌ eleleseive li laaꞌ nave. Neꞌmine igi Okulumota ningisa neꞌmine initeꞌ sotoꞌ oloseive li ningi gilaaꞌ naniꞌza sotoꞌ ilineꞌ initeꞌ ato atokumuꞌ Oꞌmosoꞌmo molaniꞌ gamene alitelineꞌ monovo nene ningi gili minisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mene gameneloꞌ nizave lingine eveneꞌ golosovoꞌ mini veneꞌ ma vaꞌningine huli ve gohi maloꞌ vi lihime daaꞌ naniꞌ neꞌmine igi Oꞌmosotine huli lihime daaꞌ nave. Lingine nenikumuꞌ atoliꞌmine suno do sotoꞌ ogo Oꞌmosoꞌmo amuzo nimineꞌ nene lengelebizelongumuꞌ nilaniꞌza ma lengelebizamolosuve. Oꞌmosoꞌmo gozopoꞌ eze veletiꞌ gamazi lo sotoꞌ ogaꞌ ive Zonada atoꞌ suno do sotoꞌ ogo amuzoꞌve ngelebizineꞌ maꞌminevoꞌ ma nenita sotoꞌ ogavo nevoꞌ ningilisave. Neꞌmine lo hulo-ngedo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Idoꞌ izipahala zuho ingine Izesukisi sipiuꞌ dizi noso ohuno helala vaniꞌ nene beletimuꞌ gaꞌine molavo ma di vamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Neꞌmine ikevo Izesuꞌ aza eveneꞌ maliti ngemeni damenimuꞌ beleti do lulu izaaꞌ ineꞌ initeꞌ zisitiloꞌ lo molo tiꞌ lo lo-ngimineꞌ: Halisaioꞌ monoꞌ laaꞌ ave idoꞌ Sadukaioꞌ monoꞌ laaꞌ ave engitatiꞌ zisiti nene dikelizaze. Nemuꞌ ningisa minilo. ");
INSERT INTO aso_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Neꞌmine lavo ingine li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Laza beleti ma do amuneꞌ nenako nemuꞌ lave. ");
INSERT INTO aso_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Izesuꞌ aza gamazi li voleloꞌ meloꞌ aniꞌ nemuꞌ nene mo ningo gelo tiꞌ lo lineꞌ: Lingine gili eleꞌvoleꞌ amave mene beleti di amaniꞌ nemuꞌ nene nanitekumuꞌ gamazi li voleloꞌ meloꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Naza beleti faef (5) do gito izeꞌ molo eveneꞌ faef (5) tauseni ngemekuvo nisa lumo sama hulaniꞌ nedunuꞌ nene lingine gosuvahaꞌ tuvelu goꞌzi vaiꞌ laniꞌ mamuꞌ gatine molahe. ");
INSERT INTO aso_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Idoꞌ beleti seveni do gito izeꞌ molo eveneꞌ fo (4) tauseni ngemekuvo nisa lumo sama hulaniꞌ nene lingine gosuvahaꞌ naba gidini seveni goꞌzi vaiꞌ laniꞌ mamuꞌ gatine molahe. ");
INSERT INTO aso_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Beleti nene neꞌmine ogo ha do sotoꞌ olosuvonako beletimuꞌ lamuvoniꞌ nene lingine gili nilisave lo giluvoniꞌza gilamaniꞌ neive. Halisaioꞌ monoꞌ laaꞌ ave idoꞌ Sadukaioꞌ monoꞌ laaꞌ ave engitatiꞌ zisiti nene dikelizaze. Nemuꞌ ningisa minilo. ");
INSERT INTO aso_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Neꞌmine lavo nelotiꞌ alingeꞌ nene beleti do lulu izaaꞌ initekumuꞌ lamo zisitimuꞌ lo molo lineꞌ ma nene Halisaioꞌ monoꞌ laaꞌ avelite idoꞌ Sadukaioꞌ monoꞌ laaꞌ avelite gamazi ladeni igi eveneꞌ apizi ngimaaꞌ aniꞌ monovo nene do minalone li ningi minilizangumuꞌ lineꞌ ma nene alingeꞌ mo gili ngoloꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Izesuꞌ aza Kaesalea Hilipi misubola vo hetelo izipahala zuho tiꞌ lo longoꞌ o-ngidineꞌ: Oꞌmosolatiꞌ ve gihile nenikumuꞌ nene zaho ve li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Neꞌmine lo longoꞌ o-ngedavo ingine tiꞌ li laniꞌ: Eveneꞌ linge ma nete monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ hilingutiꞌ otosa noloseive li laaꞌ nave. Idoꞌ linge ma nete gozopoꞌ polohete Eliaꞌ aza gohi sotoꞌ oloseive ma nene tineꞌ molo abe li laaꞌ nave. Idoꞌ ma nete polohete Zelemiaꞌ ma helaningutiꞌ otosa nolibe polohete atoꞌ ma minaineꞌ helanive nolibe li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Neꞌmine likevo Izesuꞌ gohi tiꞌ lo longoꞌ o-ngidineꞌ: Idoꞌ ingine nene mo neꞌmine laaꞌ naniꞌza lingine nenikumuꞌ nene zaho neve li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Neꞌmine lo longoꞌ o-ngedavo Simoniꞌ Petoloꞌ aza aꞌmidoꞌ tiꞌ lo lineꞌ: Minevoꞌ minevoꞌ Oꞌmosoꞌmo do luꞌ izelove lo gipele do kegeso gimiselive ma ne nane. ");
INSERT INTO aso_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Zonaꞌ gipele Simonizo, haza evenelite aꞌmine monovoꞌne nene li-gimikevo lamane. Okulumokuꞌ meꞌneho veka do lapa nomineꞌ o-gedavo lange. Nemuꞌ nene lamineꞌ ilineꞌ akaloꞌ mine molo nange. Golizesi minezo. ");
INSERT INTO aso_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Idoꞌ tiꞌ lo nolo-gimuze. Gelezo. Gaza guliveka Petoloꞌ nane. Idoꞌ Petoloꞌ neꞌmi monovo nene eleꞌvoleꞌ geheni ve lo nenako nemuꞌ eveneꞌne zuho do sotoꞌ o-ngedo eleꞌvoleꞌ igi minilizave lo aꞌmine eleꞌvoleꞌ gehedoꞌ do giꞌmize-ngedekuvo ve golosoꞌmi amuzoꞌve neꞌmo ngelo ngivileꞌ amivo helaaꞌ neꞌmo mudise hele osuꞌ laaꞌ akaloꞌ ma ngeleꞌmize molamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Naza Okulumokuꞌ miniveꞌmi gizebouꞌ vi hilalizaniꞌ amuzo gemekuvo eveneꞌ ngeleꞌmizo Oꞌmosoꞌmo gizebo inguꞌ vo holalosane. Idoꞌ misubouko gaza eveneꞌne zuho gamazi initeꞌ mamuꞌ lo huko lo-ngemo neꞌmine amilo lo oꞌve lo-ngedelineꞌ nene Okulumokuko Oꞌmoso neꞌmosi aꞌmine initekumuꞌ oꞌve lo lo huko-ngedeleseive. Idoꞌ misubouko gaza initeꞌ mamuꞌ nene neꞌmine ogaꞌ ve lo lo-ngedelineꞌ nene Okulumokuko Oꞌmoso neꞌmosi aꞌmine initekumuꞌ mo neꞌmine ogaꞌ ve lo lo-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Neꞌmine lo Petoloꞌni lo-emosa Izesuꞌ aza eikumuꞌ nene Oꞌmosoꞌmo do kegeso imiselelesa live neive li eze monovo mo kekeꞌ eveneꞌ masi li-ngimamilo lo amuzo molo lo izipahala zuho nene gaꞌine daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Idoꞌ aꞌmine gamene nelotiꞌ Izesuꞌ aza apiꞌ ogo tiꞌ lo lo-ngemeꞌmo vo minineꞌ: Neniꞌ gono neꞌmo gihileꞌve do sotoꞌ ilingumuꞌ naza Zelusalemi numuda vokuvo aꞌmida monoꞌ gizebo vesi idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ Zuda vete gozopotatiꞌ laaꞌ naniꞌ monoꞌ apizi ngimaaꞌ avesi ingine goboni mili-nidi mulumo gono nimi nibili hililisave. ");
INSERT INTO aso_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Neꞌmine ikevo helo gamene sitohamo minekuvo Oꞌmosoꞌmo do ote-nedeleseive. Neꞌmine lavo Petoloꞌ aza do gahevela o-miko elemo tiꞌ lo lineꞌ: Guvekasi ve, neꞌmine lamozo. Oꞌmosoꞌmo do guꞌ izavo laineꞌ initeꞌ mo kekeꞌ geiꞌ okongaloꞌ sotoꞌ amoloseive. ");
INSERT INTO aso_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Neꞌmine lo lineꞌza Izesuꞌ aza velepeꞌ izo Petoloꞌni tiꞌ lo lo-imineꞌ: Satani gaza akaloꞌ nene golise ozo. Gaza gaka gele naineꞌ nene Oꞌmosoꞌmo gilidiꞌmino gelamo me misubouꞌ evenelite gilaaꞌ adiꞌmino gele naineꞌ nenako volodoꞌ o neineꞌ akaꞌnela ogo hizo notilange. Satani gaza olovoꞌ ozo. ");
INSERT INTO aso_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Neꞌmine lo Izesuꞌ aza eze eꞌmetaaꞌ ave gamazi tiꞌ lo lo-ngimineꞌ: Ve ma ingine neꞌmeto alone li gilii ma gomuꞌ nene minevoꞌ alevoꞌine gizebo igaꞌ naniꞌ monovoꞌine nene huli alami neniꞌ neꞌmetilizangumuꞌ ve goloso nizave li lohotoꞌ zaloꞌ ngibili hililizangumuꞌ nene gili hulisa neꞌmeti alizave. ");
INSERT INTO aso_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Idoꞌ neꞌmine igisa neꞌmeti alizave lo noluvoniꞌ nene nanitekumuꞌ luhe. Lingine mene gililo. Ve ma ingine neniꞌ neꞌmeteloneꞌ nene geni initeliꞌmi lulouꞌ vo minevoꞌ alevote hulalone li neꞌmetamilizave nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ma damilisave. Damilisaha ve ma ingine neꞌmeti vilizanguꞌ ngibili hilikevo minevoꞌ alevoꞌine hulilizaniꞌ nene alingeꞌ minevoꞌ minevoꞌ ngemeni dameni dalisave. ");
INSERT INTO aso_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ee, misubouko mene minevoꞌ alevoꞌ igi mini misubouꞌ initeꞌ vaiꞌ di engita igi minilizanguꞌ nene minevoꞌ minevoꞌ minaaꞌ ngemeniꞌine hulilizaniꞌ nene aꞌmine initeꞌ vaiꞌ nete nene ma hize eleꞌ i-ngidamilisave. Ee, eveneꞌ ma ingine minevoꞌ minevoꞌ minaaꞌ ngemeni dameni ma hulilizaniꞌ nene aꞌmine ngemeni dameni di engita olone li aꞌmidoꞌ golo hizilizaniꞌ initeꞌ hamokisi ma minamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Idoꞌ Oꞌmosolatiꞌ ve gihile naza meꞌnehi emeni dameni lamineꞌ nene do tiꞌ ogo mino angeloꞌne zuhosi ngeleꞌmizo alosuve. Idoꞌ aloniꞌ nene naza evenelite hamoꞌ hamoꞌ initeꞌ golososi idoꞌ laminekisi igi mili minaniꞌ votigileloꞌ nene meni ngemelesuve. ");
INSERT INTO aso_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lamineꞌ lo-lengemelesuve. Meloꞌ nizave lengikutiꞌ linge ma hilami ha nizavo naza Oꞌmosolatiꞌ ve gihile Guveꞌnesi ve loloꞌ ogo eveneꞌne zuho gizebo o-ngedelesa sotoꞌ ogo lemo nouvo ingine ningilisave. ");
INSERT INTO aso_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gamene sigisi ogo vavo Izesuꞌ aza Petoloꞌni ve Zakoboꞌni ve idoꞌ nakunolo Zohaneꞌni nesi ngeleꞌmizo golo haꞌnaloꞌ dizo vavo aꞌmida nene engikovoꞌ mini ");
INSERT INTO aso_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ningi nizavo Izesuꞌ nene okoꞌno do atoliꞌmine ogavo golo velelotiꞌ nene hoꞌ neꞌmine hulo mino okoꞌnoloꞌ initetoꞌ nene labanaꞌ elo mokonoꞌ goloso elo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Neꞌmine neivo neloꞌ nene Moseki Eliakisi sotoꞌ i ngimi Izesuꞌ nesi gamazi li voleloꞌ meloꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Neꞌmine igi nizavo Petoloꞌ Izesuꞌni tiꞌ lo lo-imineꞌ: Guvekasi ve, makaꞌ meloꞌ minuneꞌ nene lamineꞌ ogave. Nemuꞌ gaza gele nemanivo azibe sitohamo gizelove. Ma nene geikumuꞌ ve. Ma nene Moseꞌni ve idoꞌ ma nene Eliaꞌni ve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tiꞌ lo gamazi nolivo silingengeꞌne hulo minineꞌ limusoꞌmo ogo molo hite-ngidineꞌ. Molo hite-ngedavo aꞌmingutiꞌ gamazi ma tiꞌ lo sotoꞌ ineꞌ: Me ve nene neniꞌ gipeꞌne luꞌne eme nouvoniꞌ ne neive. Eikumuꞌ laniteꞌ goloso nogiluve. Lingine eze gamaziꞌve gili dalo. ");
INSERT INTO aso_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Izipahala zuho sitohamo aꞌmine gamazi gili ngehelele izavo goꞌine hizi ingi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Neꞌmine igi nizavo Izesuꞌ aza ogo okoꞌnidoꞌ do nogelo tiꞌ lo lineꞌ: Lingine lengehelele izamivo otilo. ");
INSERT INTO aso_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Neꞌmine lavo ingine oti ninganiꞌ nene eveneꞌ ma ningami Izesukovoꞌ neivo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Neꞌmine igi gololotiꞌ makaꞌ limi niigi Izesuꞌ tiꞌ lo gaꞌine daniꞌ: Lingine aꞌmine ninganiꞌ initeꞌ nemuꞌ eveneꞌ hamokisi li-ngimamavo Oꞌmosolatiꞌ ve gihile naza nene helekuvo meꞌneho do ote-nedavo ma nene ha li sotoꞌ ilizave lo gaꞌine daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Neꞌmine lavo izipahala zuho tiꞌ li longoꞌ i-daniꞌ: Idoꞌ do luꞌ izelive lo Oꞌmosoꞌmo do kegeso imiselelesa live nene aꞌmine gozopoꞌ minineꞌ polohete Eliaꞌ neꞌmo gomuꞌ molo-do tineꞌ molo aloseive li avotemoti monoꞌ gamazi apizi limaaꞌ avete laaꞌ naniꞌ ma nene nanimuꞌ laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Neꞌmine li longoꞌ i-dikevo aza tiꞌ lo lineꞌ: Eliaꞌ initeꞌ mukiꞌ do veveselesa Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live gomuꞌ molo-do aloseive laniꞌ nene mo laminetoꞌ nilave. ");
INSERT INTO aso_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Idoꞌ naza laminetoꞌ noluve. Eliaꞌ nene mo gomuꞌ aniꞌ ma nene ingine Eliaꞌ ve li ningi guni ami angise gaꞌine gilaniꞌ initeꞌ i-di bili hilaniꞌ. Idoꞌ Oꞌmosolatiꞌ ve gihile nenikisi nene aꞌmineꞌmine ogo engiꞌ aꞌninguꞌ okuvo ingine mulumo gono nimi eze i-dadiꞌmine i-nidilisave. ");
INSERT INTO aso_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Neꞌmine lavo izipahala zuho ingine nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌnimuꞌ nene nolo-limive li gili nge li gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Idoꞌ Izesule golo gizeneuꞌ limi eveneꞌ mukiꞌ di geseꞌ adoꞌ navo ve maliꞌmo ogo Izesuꞌni obuvolo hize emo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Guvekasi ve, neze gipeꞌne nene lemo lise-davo goloso ogo mino olokuꞌ lemo pouꞌ laaꞌ idoꞌ nosouꞌ lemo pouꞌ laaꞌ ogaꞌ neive. Nemuꞌ nene muheleꞌve ninge-devo. ");
INSERT INTO aso_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Geze geꞌmetaaꞌ avela eleꞌmizo uvoniꞌza ma ngeli di lamineꞌ i-damave. ");
INSERT INTO aso_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ: Eii, lingine ngeli imiseli hulisaꞌmaniꞌ nehe. Oꞌmosomuꞌ gili eleꞌvoleꞌ amaniꞌ zuho lutine zovoꞌ ize vineꞌ mene lengikumuꞌ goseleꞌ nebeleꞌmo novivo lengiꞌ vovotinguꞌ gamene gohi ma imineꞌ molo mino langamuzo hizeꞌmo vo mineloniꞌ nemuꞌ nene agae lo noluve. Aꞌmine gipe eleꞌmizi alo lo lavo ");
INSERT INTO aso_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","eleꞌmizi ikevo izipe do goloso o-do minineꞌ sikalahuꞌ goloso nene Izesuꞌ ganuꞌ elemavo izipe nene hulo-do lemo vavo izipe nene aꞌmidotiꞌ lamineꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Neꞌmine ogavo alingeꞌ angisevoꞌ mini izipahala zuho Izesuda igi tiꞌ li longoꞌ i-daniꞌ: Sikalahuꞌ goloso nene laza naniteliꞌmo imisele hulamolonidoꞌ ineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Likevo Izesuꞌ tiꞌ lo lineꞌ: Naniteliꞌmo ve. Lengiꞌ Oꞌmosomuꞌ gili eleꞌvoleꞌ aniꞌ nene naba minamidiꞌmo ve. Sakaveꞌ zuho nene initeꞌ ngomo lasolo neineꞌza lingine Oꞌmosomuꞌ gili eleꞌvoleꞌ anitine ngomo nene aꞌmine zuho niteꞌ ngomo neꞌmine votigileloꞌ vo lisiheꞌ otiꞌ otiꞌ ilineꞌ nene alingeꞌ initeꞌ lamineꞌ ma ilisa navo initeꞌ ma aka hize tile-lengedo golo neꞌmine minelineꞌ nene aꞌmine Oꞌmosomuꞌ gili eleꞌvoleꞌ anitine ngomo nedunukisi aꞌmine golomuꞌ olovoꞌ ogo ebeꞌ mala vozo lilizaniꞌ nene ha olovoꞌ ogo voloseive. Idoꞌ initeꞌ mamuꞌ neꞌmine olone li lilizaniꞌ nene amilizavoba ha ilisave. ");
INSERT INTO aso_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gamene ma izipahala zuhosi nGalilaia misubouꞌ miniꞌmi nivavo Izesuꞌ aza izipahala zuho tiꞌ lo lo-ngimineꞌ: Oꞌmosolatiꞌ ve gihile neniꞌ nene eveneꞌ maliti aꞌninguꞌ neleꞌmizi milikevo ");
INSERT INTO aso_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nibili hilikevo helo gamene sitohamo minekuvo Oꞌmosoꞌmo gohi neleꞌmize oteleseive. Neꞌmine lavo izipahala zuho ingine muluꞌine gitihineꞌ ogavo mulumo goloso gili-di minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Idoꞌ Izesuꞌ ve izipahala zuho ve ingine Kahanaumi numuda igi hetelikevo Oꞌmosoꞌmi gono monoꞌ numuno nabala daaꞌ naniꞌ nene hize eleꞌ ilive li takisi moni daaꞌ ave ingine Petoloꞌ neida igi tiꞌ li longoꞌ i-daniꞌ: Lengiꞌ tisatine nene takisi moni hulaaꞌ nooloseive. Olo. ");
INSERT INTO aso_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Neꞌmine li longoꞌ i-dikevo oo, hulaaꞌ neineꞌ ve lineꞌ: Neꞌmine lo numunguko dizo olihe gamazi lamivo Izesuꞌ tiꞌ lo lineꞌ: Simonizo, misubouꞌ misubouꞌ guveꞌinesi vete takisi moni daaꞌ naniꞌ nene zamotidatiꞌ daaꞌ nave. Engiꞌ zuholatiꞌ daaꞌ nahe atoꞌ vetidatiꞌ daaꞌ nave. Nemuꞌ gaza nadive lo gele nane. ");
INSERT INTO aso_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Lavo Petoloꞌ tiꞌ lo lineꞌ: Atoꞌ vetidatiꞌ daaꞌ nave. Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Atoꞌ vetidatiꞌ takisi moni daaꞌ ve nene lamineꞌ lainako nemuꞌ nene guvelesi veti zuho nene takisi moni meni hizisaꞌmave. Nemuꞌ nene meꞌnehi gonomuꞌ hulaaꞌ naniꞌ takisi moni nene gipele naza hulamoloniꞌ o neineꞌza ");
INSERT INTO aso_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","eveneꞌ ingine goloso gilikelizave losa ha hulolove. Gaza vo noso ohungutiꞌ alahaꞌ belaaꞌ nalaꞌ nene hulo nosouꞌ ogo alahaꞌ ganaꞌ ma belelineꞌ nene vele do aaꞌ o-do ningelineꞌ nene moni nevo ma neivo ningelesange. Aꞌmine nene do vo nenitokisi geitokisi takisi moni ngemezo. ");
INSERT INTO aso_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aꞌmine gameneloꞌ izipahala zuho ingine neida igi tiꞌ li longoꞌ i-daniꞌ: Okulumokuꞌ miniveꞌmo gizebo o-lidinguꞌ mene zaho livileꞌ ogo dizosa neive. ");
INSERT INTO aso_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Neꞌmine likevo Izesuꞌ aza izipe ma asi lo vovoꞌninguꞌ do ote-miko ");
INSERT INTO aso_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tiꞌ lo lineꞌ: Naza lamineꞌ nolo-lingimuve. Lutine di velepeꞌ izi lutine di limi izipe ngomo meꞌmine minamilizaniꞌ nene Okulumokuꞌ miniveꞌmo gizebo inguꞌ nene vamilisave. Oꞌve. Vi hilamilisave. ");
INSERT INTO aso_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Idoꞌ ve ma ingine izipe ngomo meꞌmine igi engiꞌ okoꞌinemuꞌ gilikevo lemo mine do vaaꞌ neineꞌ neꞌmini minilizave nete nene Okulumokuꞌ veliꞌmo gizebo inguꞌ minave linge ngivileꞌ igi dizisa minilisave. ");
INSERT INTO aso_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Idoꞌ ve ma ingine nenikumuꞌ ve li izipe ngomo meꞌmine ma ngeleꞌmize lamineꞌ ilizaniꞌ nene neniꞌ neleꞌmize lamineꞌ aniꞌ geleleseive. ");
INSERT INTO aso_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Idoꞌ nenikumuꞌ gili eleꞌvoleꞌ igi minaaꞌ naniꞌ izipahaꞌne zuho limi minaniꞌ engikutiꞌ hamoꞌ ma eveneꞌ maliꞌmo goloso niteꞌ dalineꞌ akauꞌ eleꞌmize molalosa neivo ma aꞌmine ve nene Oꞌmosoꞌmo mulumo gono nabaꞌ naba emalinako nemuꞌ nene goloso niteꞌ dalineꞌ akauꞌ nene olihe eleꞌmize molamivo gomuꞌ nene luvonouꞌ geniꞌvesi geheni naba nene nalava izi-di noso ohuno nabauꞌ ehusoꞌ i hulikevo aꞌminguꞌ lemo helelineꞌ nene lamineꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Me misubouꞌ nene eveneꞌ ngimimiseꞌ igi aka golosoloꞌ ngeleꞌmizi milaliza initeꞌ nene sotoꞌ amilizavoba mo vaiꞌ sotoꞌ ilisanako nemuꞌ nene me misubouꞌ alevemuꞌ mulumo nogele-lingiduve. Idoꞌ aꞌmine eveneꞌ ngimimiseꞌ igi aka golosoloꞌ ngeleꞌmizi milaliza initeꞌ di sotoꞌ ilizave nene Oꞌmosoꞌmo lihime naba ngemeleseinako engikumuꞌ agae lo mulumo nogele-ngiduve. ");
INSERT INTO aso_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Idoꞌ anga sitakisi gizenga sitakisi nanivo Oꞌmosoꞌmo lihime gemo lihizami olokuꞌ hulo-gedavo lemo minalinge. Anga nehe gizenga nehe netise lihime daaꞌ akaloꞌ geleꞌmize nimilasivo ma neꞌmine amilizo lo angasi gizengasi nene huko hulaineꞌ gilivosa minezo. Neꞌmine ogo gizenga anga gebili do minaineꞌ gilivo minevoꞌ minevoꞌ ebekuko vilineꞌ nene ede voloseive. ");
INSERT INTO aso_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Idoꞌ vega sitakisi nanivo Oꞌmosoꞌmo lihime gemo lihizami olokuꞌ hulo-gedavo lemo minalinge. Vega neꞌmo lihime daaꞌ aka ma nogelebizivo ma nene neꞌmine amozo lo vega nene kuluhize hulaineꞌ gilivosa minezo. Neꞌmine ogo vega hela gebili do minaineꞌ gilivo minevoꞌ minevoꞌ ebekuꞌ vilineꞌ nene ede voloseive. ");
INSERT INTO aso_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Lingine izipahaꞌne zuho ngomo ngomo engiꞌ neti angeloꞌine nene gamene gamene meꞌnehi veleloꞌ minaaꞌ nanaze. Lingine aꞌmine izipemuꞌ gilavo haza niteꞌ ogalive. Nemuꞌ nene ehee noluve. ");
INSERT INTO aso_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Idoꞌ lingine nadive li nigilave. Ve maliꞌmi sipisipi ize vanu hadeti (100) minilizangutiꞌ hamoꞌ ma vo halekelineꞌ nene aꞌminemuꞌ viseꞌ amilihe. Neꞌmino nomive. Sipisipi ize naedi naeni (99) nene aꞌmida golola hulo-ngimiko hamoꞌ vo halekineꞌ nemuꞌ nene viseꞌ oꞌmo voloseive. Olo. ");
INSERT INTO aso_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ee, aza viseꞌ ogo do sotoꞌ ilineꞌ nene naza laminetoꞌ nolo-lingimuve. Olize goloso izeleseive. Olize izelineꞌ nene sipisipi vi halekami mela naedi naeni (99) minaniꞌ mamuꞌ olize izineꞌ ma nene ivileꞌ ivosa olize izeleseive. ");
INSERT INTO aso_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aꞌmineꞌmine ogo izipahaꞌne zuho ngomo ngomo nizangutiꞌ mene Okulumokuꞌ Metibo neꞌmo hamokisi vo halekilive lo luꞌveuꞌ gelesaꞌmive. ");
INSERT INTO aso_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Idoꞌ eveneꞌ maliꞌmo geiꞌ mulunga do goloso o-gedo lihime davo ma gaza aꞌmine ve neida vanivo lengiꞌ sitakovoꞌ mini aꞌmine lihime daniꞌ monovo nene elebizanivo ningelive. Ningo gele gemelineꞌ nene aꞌmine ve nene gohi aka lamineta nene mo eleꞌmizo ogane. ");
INSERT INTO aso_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Idoꞌ gele gemamivo ma nene eveneꞌ gohi sitape sitohamo he do giꞌmizo makaꞌ vi lihime daniꞌ monovo nene elebizilo. Neꞌmine ilizaniꞌ nene monoꞌ godolouꞌ minineꞌ gamazi mauꞌ nene vo daloseive. Aꞌmine gamazi nene tiꞌ lo neive: Gamazi gono nidavo lihime daveꞌmi monovo nene eveneꞌ sitape sitohamo he neꞌminete likevo gamazi lilizaniꞌ vo hamoꞌ ilineꞌ nene lisiheꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Idoꞌ ngeleꞌmizo vaniveti gamaziꞌine nesi gele hulavo ma eiꞌ lihime daniꞌ monovo nene monoꞌ aleveti muliseuꞌ lo sotoꞌ oganivo ingine liliza gamazi nesi gele hulavo ma gaza gelanivo eveneꞌ atoꞌ nene monoꞌ gilamavetingutipe takisi moni daaꞌ ave goloso engikutipe minineꞌ gelavo ezesi bizamanivo atokovoꞌ monaaꞌ ilive. ");
INSERT INTO aso_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Idoꞌ naza lamineꞌ nolo-lingimuve. Misubouko lingine eveneꞌne zuho gamazi initeꞌ mamuꞌ li huki li-ngimi neꞌmine amilo li oꞌve li-ngidilizaniꞌ nene Okulumokuko Oꞌmoso neꞌmosi aꞌmine initekumuꞌ nene oꞌve lo lo huko-ngedeleseive. Idoꞌ misubouko lingine initeꞌ mamuꞌ nene neꞌmine ogaꞌ ve li li-ngidilizaniꞌ nene Okulumokuko Oꞌmoso neꞌmosi aꞌmine initekumuꞌ mo neꞌmine ogaꞌ ve lo lo-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Idoꞌ gohi ma imineꞌ molo lo-lengemeloze: Eveneꞌ setape setohamohe neꞌminete neniꞌ aleve minaniꞌ di geseꞌ igi nopoꞌni nilavo ma naza engiꞌ vovoꞌninguꞌ hize eleꞌ o-ngedo mineloniꞌ nenako lengikutiꞌ sitalitise initeꞌ mamuꞌ luꞌine mili hamoꞌ igi mini Oꞌmosola lilisineꞌ nene Okulumokuꞌ neive Meꞌneho neꞌmo ha gele ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Neꞌmine ogo Petoloꞌ aza Izesuꞌ neida ogo tiꞌ lo longoꞌ o-dineꞌ: Guvekasi ve, eveneꞌ maliꞌmo lihime nemeꞌmo vo minelineꞌ nene lihime hulo-deloniꞌ nene gamene nanikeꞌ hulo-delove. Gamene seveni (7) avoꞌ lihimeꞌve hulo-miko ha minelohe. Olo. ");
INSERT INTO aso_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Gamene seveni (7) avoꞌ lihimeꞌve hulo-deline noluvoba lihimeꞌve hulo-deꞌmo vo minelineꞌ nene gamene sevedi seveni (77) nesi ivileꞌ ogo mo lihime dokaꞌ dokaꞌ neivo ma hulo-dakovoꞌ olosane. ");
INSERT INTO aso_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nemuꞌ nene Okulumokuꞌ miniveꞌmo evenetoꞌ gizebo ogo lihimeꞌine hulo-ngedelineꞌ monovomuꞌ nene neꞌmino lo molo lo-lengemelove: Guvelesi ve maliꞌmo gelekeleꞌ izipahaꞌne zuho dinaꞌ o-ngiduvoniꞌ nene do lisiheꞌ olove lo gelo ");
INSERT INTO aso_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","apiꞌ ogo do lisiheꞌ neivo gelekeleꞌ izipe ma nene eleꞌmizi guvelesi ve neida aniꞌ. Gozopoꞌ aꞌmine gelekeleꞌ izipe nene teni (10) milioni kina dinaꞌ ogo guvelesi velatiꞌ daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Neꞌmine ineꞌza aza nene aꞌmine moniloꞌ golo hizo emelineꞌ moni nene ma molamineꞌ nenako nemuꞌ guvelesi ve aza tiꞌ lo lineꞌ: Aꞌmine ganalaloꞌ apaselingumuꞌ nene ezesi venele izipahalasi initeꞌ mataꞌvesi maketi ebeta ngeleꞌmizi di vikevo meni hizi-ngidi osuꞌ likevo moni dalove lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lavo aꞌmine gelekeleꞌ ve lo-imineꞌ: Agae, gaza iseꞌne izeꞌmo novanivo dinaꞌ o-nidanidoꞌ golo hizeꞌmo vo osuꞌ loloho. ");
INSERT INTO aso_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Neꞌmine lavo guvelesi ve aza mulumoꞌve ningo alingeꞌ dinaꞌ o-giduvoniꞌ moniloꞌ nene golo hizo nemamolosane lo lo-do imisele hulineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Imisele hulavo heta lemo vineꞌ nene gelekeleꞌ izipe ezesi gono makatoꞌ daaꞌ asive nene ningineꞌ. Aꞌmine ve nene guvelesi veꞌmo moni naba imive neꞌmo dinaꞌ o-do vanu hadeti (100) kina imive minineꞌ nene ningo luvono do nohoto tiꞌ lo lineꞌ: Gaza nenitatiꞌ moni dinaꞌ aineꞌ maloꞌ nene aloꞌ golo hizezo. ");
INSERT INTO aso_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Neꞌmine lavo gono makatoꞌ daaꞌ asive neꞌmo lemo gizeneuꞌ obuvolo hize emo tiꞌ lo lineꞌ: Gaza iseꞌne izeꞌmo novanivo alingeꞌ aꞌmidoꞌ golo hize-gedeloho. ");
INSERT INTO aso_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Neꞌmine lineꞌza gele hulo oꞌove lo gonitoꞌ eleꞌmize molo tiꞌ lo lineꞌ: Nalaꞌ numunguꞌ huli-dikevo mino dinaꞌ nene apaso moni neme osuꞌ lavosa kuluhizi-dikevo vilive. Lavo nalaꞌ numunguꞌ huli-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Neꞌmine ogavo ezesi makatoꞌ gono daaꞌ ave ingine neꞌmine ineꞌ nene ningi muluꞌninguꞌ goloso gili vi guveꞌinesi ve nene aꞌmine gelekeleꞌ ve nene ogo molo ineꞌ initekumuꞌ nene li-imi osuꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Li-imikevo guvelesi veꞌmo gelekeleꞌ izipe nene asi lavo dizineꞌ. Dizavo tiꞌ lo lo-dineꞌ: Gelekeleꞌ izipe goloso mene gaza muheleꞌ gamazi lo-nemanivo dinaꞌ o-giduvoniꞌ ma apase-gedekuve. ");
INSERT INTO aso_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Neꞌmine o-giduvoniꞌ neꞌmino gazasi makatoꞌ gono daaꞌ asive nene mulumolo ningo dinaꞌ o-daineꞌ nene apase-delinako apase-damane. ");
INSERT INTO aso_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Neꞌmine lo izeboloꞌ molavo guvelesi ve tiꞌ lo lineꞌ: Nalaꞌ numunguꞌ mino mulumo gono imiꞌmi vi nizavo dinaꞌ o-duvoniꞌ nene golo hizeꞌmo vo minevoꞌ minevoꞌ ilive. Idoꞌ neꞌmine lo nalaꞌ numunguꞌ gizebo igaꞌ aveti aꞌninguꞌ molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Neꞌmine lo Izesuꞌ tiꞌ lo lineꞌ: Lingine hamoꞌ hamoꞌ eveneꞌ lihime lutingutiꞌ gehepeve huli-ngidamilizaniꞌ nene guvelesi veꞌmo gelekeleꞌ izipahala o-didiꞌmino Okulumokuꞌ Meꞌneho aza aꞌmineꞌmine o-lengedo lihimetine nene hulo-lengedamo mulumo gono lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Idoꞌ Izesuꞌ aza gamazi mukiꞌ mene lo-ngemo osuꞌ lo nGalilaia misubo hulo vo Zudaia misubouko Zodani noso helala vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aꞌminguꞌ novivo eveneꞌ mukiꞌ eꞌmeti nivavo engikutiꞌ initeꞌ gizi dave nene do lamineꞌ o-ngedeꞌmo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Halisaioꞌ monoꞌ laaꞌ ave linge ma ingine Izesuda igi emenguꞌ mili tiꞌ li longoꞌ i-daniꞌ: Gaza Zuda veti louꞌ gamazitemuꞌ gelanivo eleꞌningine initeꞌ ngomoꞌ nabakumuꞌ ngimisele hulaaꞌ nene lisiheꞌ o neihe lisiheꞌ amive. ");
INSERT INTO aso_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tiꞌ li longoꞌ i-dikevo tiꞌ lo lo-ngimineꞌ: Monoꞌ godolouꞌ gamazi ma tiꞌ lo minineꞌ nene lingine mo gati gili nizaniꞌ ma nene gilamaniꞌ nehe: Gomuꞌ initeꞌ mukiꞌ do sotoꞌ molaaꞌ iveꞌmo vegi veneki loloꞌ o-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Neꞌmine ogo tiꞌ lo lineꞌ: Nemuꞌ nene ve nene izelehingi melehingi hulo elenahida bizo minavo ingine hamoꞌ loloꞌ asineꞌ gelavo minilisasive. Nemuꞌ nene ingine nene sitaꞌ nizasive ma lo-ngedamolosune. Mo hamoꞌ nene nizasive. ");
INSERT INTO aso_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nemuꞌ nene Oꞌmosoꞌmo initeꞌ do hamoꞌ ogo molo neingutiꞌ ve malike do izeꞌ molaaꞌ nene nomive. ");
INSERT INTO aso_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lavo ingine tiꞌ li laniꞌ: Idoꞌ neꞌmine lo ma Moseꞌ aza gamazi neꞌmine lo lineꞌ nene nanitekumuꞌ lineꞌ neve: Ve maliꞌmo elenahine hulo-delove lo ma veneꞌ mene mo hulo-dekuve lo luhuvo gize emosa hulo-davo vilive. ");
INSERT INTO aso_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Neꞌmine likevo aza tiꞌ lo lineꞌ: Lingine gamazi gilami peleseveꞌ izaaꞌ angumuꞌ nene Moseꞌ veneꞌ ngimisele hulaakumuꞌ gele lengemave. Neꞌmine ineꞌza Oꞌmosoꞌmo veneꞌ vemohoꞌ do sotoꞌ ogo do bize-ngidineꞌ gamenelatiꞌ nene eleꞌningine hulo-ngedaaꞌ monovo nomineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Idoꞌ naza neꞌmine lo nolo-lingimuve: Ve ma elenaho aza ve gohi masi monamivo initeꞌ atokumuꞌ hulo-do veneꞌ gohi ma dalineꞌ nene Oꞌmosoꞌmi louꞌ gamazi avutoꞌ ogo lihime naba daloseive. ");
INSERT INTO aso_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Neꞌmine lavo izipahala zuho ingine tiꞌ li li-imaniꞌ: Vesi venekisi bizo nonivo initeꞌ neꞌmine manaꞌmine ilizangumuꞌ huli-ngidamilizave lainako veneꞌ damo ha minaaꞌ nene lamineꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Neꞌmine likevo Izesuꞌ tiꞌ lo lineꞌ: Mene gamazi nene eveneꞌ mukilite gili dalizadoꞌ nomive. Eveneꞌ linge ma Oꞌmosoꞌmo luꞌine gaꞌine hize eleꞌ o-ngedavo engikovoꞌ dalisave. ");
INSERT INTO aso_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Idoꞌ linge ma aꞌmine gamazi gili dalizave noluvoniꞌ nene nemuꞌ nene noluve: Eveneꞌ linge ma izeꞌningi muluꞌningutiꞌ gizehoꞌine nevoꞌmine nomineꞌ sotoꞌ aniꞌ neꞌmo veneꞌ damaaꞌ aniꞌ ve. Idoꞌ ve ma nene evenelite gizehoꞌine ili huli-ngidikevo veneꞌ dami minaaꞌ nave. Idoꞌ linge ma nene Oꞌmosoꞌmo gizebo inguꞌ gono neineꞌ nemuꞌ luꞌine milalisa veneꞌ daaꞌ nene angiseꞌine oꞌove li haza minaaꞌ nave. Ve ma ingine veneꞌ damaaꞌ amuzo engita minelineꞌ nete nene gamazi mene gili dalisave. ");
INSERT INTO aso_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nelotiꞌ nene eveneꞌ ingine izipe ngomo ngomo nene Izesuꞌ ana godoꞌnidoꞌ hito Oꞌmosola lo noꞌnohoꞌ ize-ngedelive li ngeleꞌmizi neida navo izipahala zuho ingine ngelemi oꞌve li-ngidaniꞌza ");
INSERT INTO aso_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Izesuꞌ aza tiꞌ lo lineꞌ: Izipe ngomo ngomo meꞌmine minave nene Oꞌmosoꞌmo gizebo o neinguꞌ ngeleꞌmize molaaꞌ neinako huli-ngimikavo nenita ha alizaze. Oꞌove li-ngidamilo. ");
INSERT INTO aso_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Neꞌmine lo ana godoꞌnidoꞌ hito mino noꞌnohoꞌ ize-ngedosa vo mala vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Idoꞌ novivo ve ma aza Izesuꞌ neida ogo tiꞌ lo longoꞌ o-do lineꞌ: Tisazo, naza initeꞌ lamineꞌ naniꞌmine olodiꞌmo nene minevoꞌ minevoꞌ nemeni dameni daloniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Neꞌmine lo longoꞌ o-do lineꞌza Izesuꞌ aza tiꞌ lo lo-imineꞌ: Monovo lamineliꞌmi Meleho nene hamokovoꞌ neineꞌ nenako neniꞌ nene monovo lamineꞌ ogakumuꞌ nene nanitekumuꞌ longoꞌ o-nedane. Minevoꞌ minevoꞌ gemeni dameni nene dalove lo ma aka gamazi eꞌmetaaꞌ olosane. ");
INSERT INTO aso_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Neꞌmine lavo aza tiꞌ lo lineꞌ: Aka gamaziutiꞌ nene adoꞌ zaꞌ ma eꞌmetelongumuꞌ nolane. Neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ: Lingine eveneꞌ ngibili hilamilo. Idoꞌ veneꞌ vemohoꞌ liliꞌ ikeniꞌ nete lingine bizivoꞌ mini veneꞌ nehe vemohoꞌ nehe gohi masi gopo ingamilo. Idoꞌ gumine amilo. Idoꞌ eveneꞌ mamuꞌ gopoꞌ napa gamazi li-ngidi sakupo gamazi li-ngidamilo. ");
INSERT INTO aso_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Idoꞌ izetingine metinginemuꞌ gilikevo dizavo gelekeleꞌ i-ngidi minilo. Idoꞌ lingine lengikumuꞌ gilaaꞌ naniꞌ neꞌmini avitoꞌ gidini ingi monavemukisi nene aꞌmineꞌmine igi gilii lutine ngimilo. ");
INSERT INTO aso_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Neꞌmine lavo ve gosoꞌve aza tiꞌ lo lo-imineꞌ: Aꞌmine gamazi mukiꞌ nene mo eꞌmetaaꞌ nouvoniꞌza olihe vo damivosa naniteꞌ gohi ma eꞌmeteloniꞌ neve. ");
INSERT INTO aso_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza mo eveneꞌ lisiheꞌ lamineꞌ gehepeve minelo ma nene vo henenika initeꞌ mataka maketi molo moni dalineꞌ nene izeꞌ molo gohoꞌ gahaliꞌ izeꞌ molo ngemezo. Neꞌmine ilineꞌ neꞌmo Okulumokuko henenika ma mineleseive. Idoꞌ neꞌmine ogo ogo neꞌmetezo. ");
INSERT INTO aso_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Neꞌmine lavo gosoꞌve aza heneniꞌve vaiꞌ goloso mininako aꞌminemuꞌ gilivo geni belavo muheleꞌ ogo vo ha ha ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Neꞌmine ogavo Izesuꞌ aza izipahala zuho tiꞌ lo lo-ngimineꞌ: Heneni ve minangutiꞌ linge ma Okulumokuꞌ miniveꞌmo gizebo inguꞌ vi hilalizaniꞌ nene geꞌnebe igisavoꞌ aꞌminguꞌ vi hilalisave. ");
INSERT INTO aso_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Idoꞌ gohi nolo-lingimuve: Kamelaꞌ ize nene naba neineꞌ nenako nemuꞌ nene initeꞌ ongotilisa nakeseuꞌ nalaꞌ lolosoꞌ igaꞌ aniꞌ veleuꞌ nene ma volosa ilineꞌ nene geꞌnebe goloso oloseineꞌza heneni ve nete aꞌmine nene ivileꞌ ivosa Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ vilisa geꞌnebe goloso ilisave. ");
INSERT INTO aso_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Neꞌmine lavo izipahala zuho ingine upuhoꞌ goloso igi voꞌine gohi vavo tiꞌ li laniꞌ: Laza nene Oꞌmosoꞌmo umo hilive nene heneni ve loloꞌ o-ngedaaꞌ neihe lo giluneꞌza gaza heneni ve netesi Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ mo vi hilamilisave lo lainako nemuꞌ nene Oꞌmosoꞌmo eveneꞌ hamokisi mo ma do luꞌ izamivo eze gizebo inguꞌ vo holamolobe lo nogilune. ");
INSERT INTO aso_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Neꞌmine likevo Izesuꞌ aza vonuꞌ ngebelo tiꞌ lo lo-ngimineꞌ: Eveneꞌ angiseꞌnidatiꞌ lukuvo ngeli ma namilisaha Oꞌmoso nene initeꞌ mukiꞌ ogaꞌ amuzo do neineꞌ nenako nemuꞌ eveneꞌ do nguꞌ izelidoꞌ lisiheꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Neꞌmine lavo Petoloꞌ tiꞌ lo lineꞌ: Gaza gelezo. Laza neve initeꞌ matate mukiꞌ nene hulo osuꞌ lo nogeꞌmetuniko neꞌmine nounidoꞌ nene naniteꞌ dalone. ");
INSERT INTO aso_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lamineꞌ ma lo-lengemelove: Alingeꞌ Oꞌmosoꞌmo initeꞌ mataꞌ mukiꞌ do gosohoꞌ ogavo Oꞌmosolatiꞌ ve gihile naza labanaꞌne do sotoꞌ ogo Guveꞌnesi ve naba mineloniꞌ moꞌmosiꞌneloꞌ mino eveneꞌne zuho gizebo o-ngedo nouvo neze neꞌmetaaꞌ ave linginesi guvetinesi ve loloꞌ igi guveꞌinesi ve minaaꞌ aniꞌ moꞌmosiꞌ tuvelu neloꞌ mini Isilaeleꞌ aleveti mulise tuvelu nene gizebo i-ngidi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Idoꞌ eveneꞌ ma ingine neniꞌ neꞌmetilisa numuꞌine ebeꞌine nehe uvoꞌningine nakuꞌningine nehe ateꞌningine alunoꞌningine nehe izeꞌningine meꞌningine he izipahaꞌine nehe idoꞌ misuboꞌine nehe mukiꞌ huli neꞌmetave nene Oꞌmosoꞌmo gohi aꞌmidoꞌ imineꞌ molo ngemavo mukiꞌ goloso dalisave. Idoꞌ Oꞌmosoꞌmo gohi minevoꞌ minevoꞌ ngemeni dameni nesi ngemavo dalisave. ");
INSERT INTO aso_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Neꞌmino neineꞌza dizi nilizaniꞌ aleveutiꞌ linge mukiꞌ nene limi minilisave. Idoꞌ limi nilizaniꞌ aleve nene dizi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Idoꞌ Okulumokuꞌ miniveꞌmo gelekeleꞌ i-daaꞌ aveloꞌ gizebo ogo gono dadoꞌ meni ngemelineꞌ monovomuꞌ nene neꞌmino lo molo lo-lengemelove: Gamene ma nedengaꞌ goꞌ lavo ve ma misuboꞌve naba miniveꞌmo oto vaini miꞌveuꞌ gono dalizavemuꞌ visetoꞌ monineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mono eveneꞌ ma ningo miꞌneuꞌ gono dalizangumuꞌ nene gamene hamo hamotoꞌ tu (2) kina tu (2) kina lengemelove lavo lamineꞌve likevo miꞌvela ngimiselavo vi gono di minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Idoꞌ gono di nizavo hoꞌ dizo naeni (9) kiloku neꞌmine ogavo mine meleho vo eveneꞌ gohi ma maketi ebekuꞌ haza nizavo ningo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Linginesi vi miꞌneuꞌ gono dalo. Vi dikevo meni aꞌmidoꞌ lisiheꞌ ilineꞌ nene lengemelesuve. ");
INSERT INTO aso_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Neꞌmine lavo vi gono di minaniꞌ. Idoꞌ ingine gono di nizavo mine meleho holiseꞌ gamene tuvelu (12) kiloku neꞌminelokisi idoꞌ tili (3) kiloku neꞌminelokisi gohi vo eveneꞌ gohi ma ningo aꞌmineꞌmine ogo gonoꞌveloꞌ ngimiselavo vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Vi gono di nizavo nivengaꞌ molalosa faef (5) kiloku neꞌmine ogavo iheꞌ vo eveneꞌ gohi ma minaniꞌ nene ningo tiꞌ lo lo-ngimineꞌ: Lingine nedengatiꞌ gono dami haza miniꞌmi vi idise nivengaꞌ molalosa neidokisi haza nizaniꞌ nene nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Eveneꞌ ma gono ma limamanako neꞌmo haza none. Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Linginesi miꞌneuꞌ vi gono dalo. ");
INSERT INTO aso_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lavo vi gono dikevo nivengaꞌ molo sigisi (6) kiloku ogavo mine meleho gusikusiꞌve tiꞌ lo lo-imineꞌ: Gonoloꞌ ve asi lo-ngemezo. Gono huli ikevo meni ngemelinge. Gono alingeꞌ dave nene gomuꞌ ngemo aꞌmidotiꞌ aꞌmidotiꞌ dave ngemekaꞌ ngemekaꞌ ogo gomuꞌ dave alingeꞌ ngemelesane. ");
INSERT INTO aso_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Neꞌmine lavo neꞌmine ogo neivo faef (5) kiloku neꞌmineloꞌ apiꞌ igi gono dave ikevo tu (2) kina tu (2) kina ngemavo daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Idoꞌ nelotiꞌ gono gomuꞌ dave igi ingine aza tu (2) kina tu (2) kina lemosa aꞌmidoꞌ gohi ma imineꞌ molo lemelihe li gilaniꞌza neꞌmine amo tu (2) kina tu (2) kina nene ngemavo aꞌminevoꞌ daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aꞌminevoꞌ di mine melehine elemi tiꞌ li laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Holiꞌmo amuzo molo nolivo gohise helo gono naba dovoꞌ dovoꞌ ogo minunive meni lemo gono ngomovoꞌ dave ngivileꞌ ogosa meni naba lemelinako gaza engikisi lelikisi do lisiheꞌ ogo hamoꞌ votigileloꞌ meni lemane. ");
INSERT INTO aso_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Neꞌmine li elemaniꞌza aza mine meleho engikutiꞌ ve mamuꞌ tiꞌ lo lo-imineꞌ: Zogone ve, naza monovo goloso o-gedamuve. Gono dalinidoꞌ tu (2) kina gemelove lokuvo gaza lamineꞌ ve lanivo gamazite do hamoꞌ ogo lusidoꞌ mo gimuvoniꞌ nenako ");
INSERT INTO aso_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","aꞌmine menika nene dosa vozo. Geiꞌ gimuvoniꞌ neꞌmine alingeꞌ igi gono davesi hamoꞌ meni ngemelesuve lo gele nouve. ");
INSERT INTO aso_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Idoꞌ neniꞌ moniꞌnedunuꞌ olosa giluvoniꞌ initeꞌ nene neniꞌ luꞌneloꞌ ogaꞌ nene ha neive. Naza eveneꞌ ma do lamineꞌ o-ngiduvoniꞌ nemuꞌ nene geiꞌ lukehe nebelelinidoꞌ o neihe lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Neꞌmine lo Izesuꞌ tiꞌ lo lineꞌ: Idoꞌ aꞌmineꞌmine igi gomuꞌ milaaꞌ nave ingine nene mine alingeꞌ ilisave idoꞌ alingeꞌ milaaꞌ nave ingine nene gomuꞌ milalisave. ");
INSERT INTO aso_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Idoꞌ Izesuꞌ aza Zelusalemi numuno ebeta dizelesa izipahala zuho tuvelu nene ngeleꞌmizo novo ngeleꞌmize abazaꞌ ogo akaloꞌ nivanguꞌ tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Gililo. Laza nene Zelusalemi numuno ebeta dizo novune. Aꞌmida nene Oꞌmosolatiꞌ ve gihile neniꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ avotemote monoꞌ laniꞌ apizi ngimaaꞌ avesi engiꞌ aꞌninguꞌ milikevo ingine goniꞌ i-nidi lihimeka apaso helelinidoꞌ o neive li ");
INSERT INTO aso_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zuda ve minamaniꞌ heta atoꞌ aleveti aꞌninguꞌ mili-nidikevo ingine gize zohiꞌ i-nidi gasavasi nalatunuꞌ nene meheꞌne iziviꞌ lediviꞌ igi lohotoꞌ zaloꞌ nibili hililisave. Neꞌmine ikevo helo galeseuꞌ lemo gamene sitohamo minekuvo Oꞌmosoꞌmo do ote-nedeleseive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nelotiꞌ nene Zebedaioꞌ gipele sitalitisi izeꞌnibo neꞌmo aꞌmine gipele sitaꞌ nene ngeleꞌmizo Izesuda ogo gubiꞌ ize emo opoꞌni lo initeꞌ ma ilive lo lo-imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Neꞌmine ogavo Izesuꞌ tiꞌ lo longoꞌ o-do lineꞌ: Gaza nadiꞌ olongumuꞌ nolane. Lavo tiꞌ lo lo-imineꞌ: Gaza alingeꞌ Guvekasi ve loloꞌ ogo eveneꞌ gizebo o-ngedo minelineꞌ gameneuꞌ nene neiꞌ gipeꞌne sitaꞌ mene gezelotiꞌ limi eveneꞌ lingesi ma ngivileꞌ igi guveꞌinesi ve liliꞌ igi mini anga zamelasi adavalasi minilisive lo gele nemeline losa gele nouve. ");
INSERT INTO aso_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Lingine longoꞌ i-nidasineꞌ initeliꞌmi monovo nene gilami gopo likeve. Initeꞌ goloso i-nidilizaniꞌ nene ekeseꞌ noso neꞌmino nenako aꞌmine i-nidilizaniꞌ initeꞌ nene ha gehelesa nouve. Idoꞌ linginesi neniꞌ geheloniꞌ initeꞌ ekeseꞌ noso neꞌmino minineꞌ nene ha gihilisidoꞌ i nizasihe. Neꞌmine lavo tiꞌ li lasineꞌ: Ee, laza neꞌmine ha olosidoꞌ o nosive. ");
INSERT INTO aso_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Likesivo aza lo-ngimineꞌ: Lamineꞌ lingine neniꞌ geheloniꞌ mulumo geni nene gihilisineꞌza zamelasi adavalasi minaaꞌ moꞌmosiꞌ nene neniꞌ initeꞌ neivosa lengemelohe. Meꞌneho dalisive lo do vaꞌvaꞌ o-ngidive nene engikovoꞌ nene dalisasive. ");
INSERT INTO aso_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Idoꞌ uvolohoi akunoloi neꞌmine asineꞌ nemuꞌ izipahala zuho linge teni nene gilii engikumuꞌ nene muluꞌninguꞌ goloso ineꞌza ");
INSERT INTO aso_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Izesuꞌ aza aꞌmine zuho asi lo-ngemavo ezela ikevo tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmi zuho minamaniꞌ heta atoꞌ ve engiꞌ gizebo veꞌine eveneꞌine nene gelekeleꞌ i-ngidilizave li amuzo mili li-ngidaaꞌ nave. Aꞌmine eveneꞌ engita eveneꞌ naba minave nete nene aꞌmine eveneꞌine zuho nene ngivileꞌ igi amuzo ve goloso minisa gizebo i-ngidaaꞌ nave. Neꞌmine igaꞌ naniꞌ nemuꞌ nene lingine mo gili nizaniꞌza ");
INSERT INTO aso_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","lengiꞌ muliseuꞌ nene ingine igaꞌ naniꞌ neꞌmine nene amilisave. Lengikutiꞌ ve maliꞌmo guveꞌnesi ve loloꞌ olove lo gelo ma aza nene lengiꞌ gelekeleꞌ vetine neꞌmine loloꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ee, ve ma aza gomuꞌ molo lengemo eveneꞌ naba minelove lo gelo ma lengiꞌ goboni izipetine neꞌmine loloꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ee, aꞌmine ve aza Oꞌmosolatiꞌ ve gihile ogaꞌ nouvoniꞌ neꞌmine oloseive. Naza eveneꞌ gelekeleꞌ i-nidi neleꞌmizi lamineꞌ ilizave losa lemamuve. Asi gelekeleꞌ o-ngedo ngeleꞌmize lamineꞌ olosa ogo eveneꞌ mukiꞌ nene meni hizo do nguꞌ izo do tineꞌ molo-ngedelove lo engikumuꞌ okoꞌne hulo helelesa limuvoniꞌ ve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Idoꞌ Izesuꞌ aza izipahala zuho ngeleꞌmizo vo Zeliko ebeꞌ hulo novivo eveneꞌ mukiꞌ goloso eꞌmeti vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Neꞌmine navo veꞌine likive sitaꞌ aka gahevela mini Izesuꞌ ogo volosa nave li-ngimikevo gili asi naba li tiꞌ li lasineꞌ: Guvelesi ve naba Davidiꞌ aꞌvo ezeloꞌ medelo minanive make, gaza leliꞌ mulumote ningevo. ");
INSERT INTO aso_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nilasivo eveneꞌ mukiꞌ nene gamazi hulilisive li ngelemaniꞌza ingine gohi amuzo mili asi lasineꞌ: Guvekasi ve, Davidiꞌ aꞌvo make, leliꞌ mulumote ningevo. ");
INSERT INTO aso_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Neꞌmine li nilasivo gelo Izesuꞌ aza akaloꞌ minidoꞌ ha mino asi lo-ngemavo ikesivo tiꞌ lo lo-ngimineꞌ: Lingine nadiꞌ o-lengedelove lisa nigilasive. ");
INSERT INTO aso_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Neꞌmine lavo ingine tiꞌ li lasineꞌ: Guvekasi ve, vete do lamineꞌ o-ledanivo vete gohi ningelosive losa nolusive. ");
INSERT INTO aso_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Likesivo Izesuꞌ aza muluno hukavo veꞌnidoꞌ do gelavo aꞌmidoꞌ liteꞌ lo veꞌine lamineꞌ ogavo veꞌine gohi ningi eꞌmeti vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Idoꞌ Zelusalemi numuno di avitoꞌ igi Oliva golola Betehage ebeta igi hetelaniꞌ nene Izesuꞌ aza izipahala zuhoutiꞌ ve sitaꞌ ma ngimiselo ");
INSERT INTO aso_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","tiꞌ lo lo-ngimineꞌ: Aꞌmine ningi nizasineꞌ numuno ebekuꞌ volene vi nidizi ningilisineꞌ nene dongi ize ma naꞌnava izikaniꞌ nene angaleꞌve naba nesi nizasivo ningilisasize. Aꞌmine dongi ize nene vakesi di nouvoda alizo. ");
INSERT INTO aso_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Idoꞌ neꞌmine nasivo eveneꞌ maliꞌmo aꞌminemuꞌ longoꞌ nolingidivo ma tiꞌ li li-imilizo: Guvelesi veꞌmo eze gono neivo dongi ize memuꞌ limiselavo nousive. Likesivo liteꞌ lo gele lengemo ize ne di vilizo loloseive. ");
INSERT INTO aso_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Idoꞌ Izesuꞌ aza dongi izemuꞌ ngimiselineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive polohete maliꞌmo Oꞌmosoꞌmi gamazi ma tiꞌ lo gizineꞌ ma nene gihile izelingumuꞌ lineꞌ ve: ");
INSERT INTO aso_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Zioni golola Zelusalemi ebekuꞌ alevemuꞌ nene tiꞌ li li-ngimilo: Ningilo. Guvetinesi ve naba aza lengita nave. Hongu emeni damenisi lemo mino dongi izeliꞌmi meheneloꞌ nave. Ee, gono daaꞌ ineꞌ izeꞌmi angale maꞌmo noohikivo lengita nave. ");
INSERT INTO aso_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Idoꞌ Izesuꞌ aza ngimiselavo izipahala sitaꞌ vi lo-ngimidiꞌmine igi ");
INSERT INTO aso_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","dongi izesi angaleꞌvesi di asineꞌ. Idoꞌ saketiꞌine apasi meheꞌnidoꞌ hitikevo Izesuꞌ aza dongi ize ngomoꞌmi meheneloꞌ dizo aꞌmidoꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Neivo eveneꞌ vailite geneganaꞌine kuluhizi apasi akaloꞌ mili-daniꞌ. Idoꞌ linge ma nete zavile davile ledi aviliseꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Neꞌmine ikevo eveneꞌ linge ma vi velela vave netesi idoꞌ alingeꞌ mili ave netesi asi naba li tiꞌ li laniꞌ: Agae, gozopoꞌ guvelesi ve naba Davidiꞌ aꞌvopilemoꞌ ezeloꞌ medelo moꞌmosiꞌve dalinive Guvetesi ve Oꞌmosoꞌmi velemuꞌ anive naineꞌ ma nene noꞌnohoꞌ geita minivo. Agae, Oꞌmoso Okulumokuꞌ veleta opoꞌni lolone li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Idoꞌ Izesuꞌ aza Zelusalemi numuda nodizivo numuno meꞌninge ingine upuhoꞌ igi laniꞌ: Me ve nene zaho neve. ");
INSERT INTO aso_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tiꞌ li likevo eveneꞌ eꞌmetave ingine laniꞌ: Me ve nene polohete Izesuꞌ nGalilaia misubouꞌ Nasalete numudatiꞌ ve ma ne neive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Idoꞌ Izesuꞌ aza monoꞌ numuno nabala dizineꞌ. Dizo aꞌminguꞌ initeꞌ maketi milaaꞌ meni hizaaꞌ igi minave nene ngeleto do hulo-ngedo monoꞌ numunguꞌ hulaaꞌ moni senisimi igaꞌ aveliti holomoꞌine nene do tululu lo do hulo-ngedo nama viluso Oꞌmoso lehizi-dilizangumuꞌ maketi mili minavete holomoꞌinesi do velepeꞌ izo hite-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Neꞌmine ogo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo lineꞌ gamazi ma Monoꞌ Godolouꞌ tiꞌ li gizi nizaniꞌ ve: Neniꞌ numuꞌne nene eveneꞌ nete dizi nopoꞌni li-nimaaꞌ numuno ve losa mineleseive. Neꞌmine li gizi nizaniꞌza lingine aꞌminguꞌ igi mili minaaꞌ naniꞌ initeꞌ neꞌmo nene gumineloꞌ vete igi mili minaaꞌ numuno loloꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Idoꞌ monoꞌ numunguꞌ neivo veꞌine likive idoꞌ gizeꞌine aꞌine goloso ive ingine ezela aniꞌ. Ikevo do guno o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Idoꞌ neꞌmine neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nesi idoꞌ Zuda ve gozopotatiꞌ laniꞌ monoꞌ apizi ngimaaꞌ avesi ingine Izesuꞌ ngehelele izaaꞌ initeꞌ atoꞌ atoꞌ ogo molo ineꞌ nene ningi idoꞌ aꞌminguꞌ izipe ngomo ngama nete gozopoꞌ guvelesi ve naba Davidiꞌ aꞌvopilemoꞌ ezeloꞌ medelo minanive make, lolize ize gemelone li gekeꞌ gekeꞌ li-di minaniꞌ nesi ningi gili muluꞌninguꞌ goloso gili ngizeboloꞌ molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","nGizeboloꞌ molavo tiꞌ li li-imaniꞌ: Neꞌmine lamilizaniꞌ gamazi nilaniꞌ nene gele nabe. Likevo Izesuꞌ tiꞌ lo lineꞌ: Naza gele nouvoniꞌza monoꞌ godolouꞌ gamazi ma Oꞌmosomuꞌ tiꞌ lo neineꞌ ma nene lingine gati gilahe gilamave: Gaza veꞌine do lapa nomineꞌ o-ngedanivo izipe angale ngomo olihe amine ninaniꞌ nete gopoꞌni li-gimilizanguꞌ nene ladanga ma lamilisave. ");
INSERT INTO aso_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Neꞌmine lo lo-ngemo hulo-ngedo Zelusalemi numuno ebeꞌ hulo Betani numuno ebeta vo onganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nedengaꞌ goꞌ lavo oteko numuno nabala novivo gaꞌna olaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Gaꞌna olavo novo akaloꞌ gohuno za ma ningineꞌ. Ningo gihile ize neihe lo aꞌmida vo ningineꞌza haza avilevoꞌ ningineꞌ. Ningo tiꞌ lo lineꞌ: Gohi ma gihile izamilidoꞌ o neive. Neꞌmine lo lavo aꞌmidoꞌ geto gohuno za ma apiꞌ ogo gulugulu izo gokoꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Neꞌmine ogavo Izesuꞌ izipahala zuho ingine ningi upuhoꞌ igi tiꞌ li laniꞌ: Za me ve ne nadiꞌmine ogosa liteꞌ lo gulugulu izive. ");
INSERT INTO aso_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Laminetoꞌ nolo-lingimuve. Lingine initeꞌ ma ilisa gili Oꞌmosola lunivo hize eleꞌ o-ledavo ha olosune li gili eleꞌvoleꞌ igi gatine sitakisi gilamilizaniꞌ nene aꞌmine initeꞌ ha ilisave. Idoꞌ neniꞌ gohuno zaloꞌ uvoniꞌ initeꞌ neꞌminesi ha igi aꞌmine neꞌmine initeꞌ ivileꞌ igisa eveneꞌ amiliza initeꞌ gehepeve ha ilisave. Adoꞌ mene golomuꞌ nene ngutoko guvo nosouꞌ lemelive lilizaniꞌ nesi nene gihile ha izeleseive. ");
INSERT INTO aso_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ee, Oꞌmosola loloneꞌ initeꞌ nene ha lemeleseive li ezemuꞌ gili eleꞌvoleꞌ igi mini ezela li naniteꞌ nanitekumuꞌ lilizahe aꞌmine initeꞌ nene ha lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Idoꞌ Izesuꞌ aza monoꞌ numuno nabauꞌ dizo eveneꞌ monoꞌ lo-ngemo neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ eveneliti gizebo veꞌinesi igi heteli tiꞌ li longoꞌ i-daniꞌ: Initeꞌ mene ogaꞌ naineꞌ nene zahi velemuꞌ ogaꞌ nane. Idoꞌ zaho lavosa ogaꞌ nane. ");
INSERT INTO aso_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Likevo Izesuꞌ aza lo-ngimineꞌ: Nazasi initeꞌ mamuꞌ longoꞌ o-lengedekuvo li-nimilizaniꞌ nene aꞌmineꞌmine ogo nazasi ha zahi velemuꞌ initeꞌ ogaꞌ nouhe nemuꞌ nene lo-lengemelesuve. ");
INSERT INTO aso_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Monoꞌ noso holo-ngedelive lo Zohaneꞌni zaho imiselive. Oꞌmosoꞌmo imiselihe idoꞌ haza misubouꞌ velite imiselave. Neꞌmine lavo ingine angiseꞌinemuꞌ li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Laza Oꞌmosoꞌmo imiselive losoꞌ nene nanitekumuꞌ gili imisaꞌmave loloseive. ");
INSERT INTO aso_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Idoꞌ evenelite ve losoꞌ nene eveneliti golise gelelesune. Evenelite Zohaneꞌ nene polohete ve li gili nizanako nemuꞌ ngehelele izineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Neꞌmine li gili ngehelele izavo Izesuꞌni tiꞌ li li-imaniꞌ: Ma gelamune. Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine li-nimamaniꞌ nemuꞌ nene nazasi ogo molo ogaꞌ nouvoniꞌ initeꞌ mene iline lo nimiselivemuꞌ nene ma lo-lengemamolosuve. ");
INSERT INTO aso_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Neꞌmine lo imineꞌ molo lineꞌ: Lingine gililo. Ve maliꞌmo gipele sitaꞌ gedekineꞌ. Aꞌmine ve aza gipele ganaꞌve neidoꞌ vo tiꞌ lo lineꞌ: Gipeꞌne make, idise nene vaini minguꞌ vo gono dozo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lavo gipele aza vamolosuve lineꞌ. Neꞌmine lineꞌza alingeꞌ luꞌve do velepeꞌ izo gele do vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Meꞌnibo aza iheꞌ vo alingeni gipele neida vo aꞌmineꞌmine lineꞌ. Lavo gipele aza Ahono, volosuve lo lineꞌza vamineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Neꞌmine lo Izesuꞌ tiꞌ lo longoꞌ o-ngidineꞌ: Aꞌmine gipele sitakutiꞌ nene meꞌnibine gelekeleꞌ lamineꞌ zaho o-dive. Neꞌmine lavo ingine ganaꞌveꞌmo ve laniꞌ. Likevo aza tiꞌ lo lo-ngimineꞌ: Idoꞌ aꞌmineꞌmine ogo Zohaneꞌ lengita ogo lamineꞌ igi mili minilizaniꞌ aka lengelebizineꞌza lingine gili imamaniꞌ. Ee, lingine gili imamaniꞌza initeꞌ goloso palasa igaꞌ ave, takisi moni daaꞌ ave idoꞌ pasidiatoꞌ monaaꞌ aniꞌ veneꞌ alu nevoꞌminete gili imaniꞌ. Neꞌmine aniꞌ nene lingine ningikeniꞌ neineꞌza ningisa alingeꞌ lutine di velepeꞌ izi gili imamaniꞌ neive. Lingine langisetinemuꞌ nene laza Okulumokuꞌ miniveꞌmo gizebo inguꞌ vo holalonive nene laꞌlisete adoꞌ nene none li gilaaꞌ nahe. Naza laminetoꞌ ma lo-lengemelove. Aꞌmine takisi moni daaꞌ ave golososi idoꞌ pasidiaꞌ veneꞌ nesi lengiꞌ lingivileꞌ igi aꞌminguꞌ vi hilalizave liliꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Aneza gamazi gohi me gililo. Ve maliꞌmo misuboꞌve naba minavo aꞌminguꞌ vaini mine ma zuhoꞌ ineꞌ. Zuhoꞌ ogo aꞌmidoꞌ gesi hize vodo vodo ogo vaini gihile hite miꞌ izo lipelineꞌ galese nesi elo aꞌminguꞌ mini miꞌveloꞌ gizebo iliza numuno haꞌna nesi do dizo gizo eveneꞌ ma mine gizebo i-dilizave lo hulo-ngedo misubo mala vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vo neivo za gihile elaaꞌ gamene alitavo aꞌmine za gihiletiꞌ ma vi di-nidi alo lo gelekeleꞌ izipe ngeletavo vi aꞌmine mineloꞌ gizebo i-davela vi laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Vi laniꞌza minguꞌ gono daaꞌ avete gelekeleꞌ izipe nene aꞌnidoꞌ di giliꞌ li ma ne gesebeꞌ izi bili ma nene bili hili ma nene geheni huli huliꞌ igi bilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Neꞌmine ikevo gelekeleꞌ ve gomuꞌ ngimiselineꞌ nene ngivileꞌ ogo gelekeleꞌ ve gohi ma mukiꞌ ngimiselineꞌ. Ngimiselavo vikevo gohi aꞌmineꞌmine sunovoꞌ di-ngidaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Neꞌmine ikevo alingeꞌ mine meleho aza neꞌmine ikeniꞌza neniꞌ gipeꞌne gihile mene imiselekuvo vavo eiꞌ gipele ogaze li ningi nene eleꞌmizi lamineꞌ ilizahe lo gelo aꞌmine gipele nene engita imiselavo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Novivo mineloꞌ gizebo ve ingine ningi eiꞌ gipele gehepeve navo ningi tiꞌ li laniꞌ: Me veꞌmo alingeꞌ melehidoꞌ medelo mine mene dalive neinako mo bele helo eiꞌ mineloꞌ nene leliꞌ molalone. ");
INSERT INTO aso_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Neꞌmine li mo geleleheꞌ igi eleꞌmizi vaini gesi heta vi bili hilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Neꞌmine aniꞌ nemuꞌ mine meleho ogo ningo mineloꞌ gizebo ve nadiꞌ o-ngedelive. ");
INSERT INTO aso_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Neꞌmine lo longoꞌ ogavo tiꞌ li Izesuꞌni li-imaniꞌ: Aꞌmine eveneꞌ goloso nene do goloso ogo ngebele geseꞌ oloseive. Idoꞌ vaini mine nene mine gizebo igaꞌ ave atoꞌ ngemavo gizebo igi nizavo mingutiꞌ za gihile daaꞌ gamene vilineꞌ nene aꞌmine gihile mine melehine di imikaꞌ imikaꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tiꞌ li likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine Monoꞌ Godolouꞌ gamazi neꞌmine lo neineꞌ ma gati gilisaꞌmahe: Numuno gizilizaniꞌ geheni mukikutiꞌ geheni ma nene numuno gizaaꞌ avete ningi goloso o vive li di kegesi hulaniꞌ geheni neꞌmo geheni mukiꞌ ngivileꞌ ogo numuno do amuzo molaaꞌ geheni loloꞌ ogave. Guvelesi veꞌmo aꞌmine initeꞌ do sotoꞌ ogaze. Evenelite ningekunivo lamineꞌ gehepeve ogave. ");
INSERT INTO aso_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nemuꞌ naza lo-lengemelove: Oꞌmosoꞌmo lengitoꞌ gizebo ogaꞌ neineꞌ nene ipeꞌ ogo eveneꞌ zuho gohi ma eiꞌ gizebouꞌ minaliꞌmi monovo gihile igi mili gelekeleꞌ i-di minilizave ma do ngemeleseive.  ");
INSERT INTO aso_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Idoꞌ eveneꞌ ma nete aꞌmine gehedoꞌ veleheꞌ limi ingalizaniꞌ nene izi iti hupiꞌ izilisave. Idoꞌ aꞌmine geheni neꞌmo lemo eveneꞌ ma ngebelelineꞌ nene izo lanahana o-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aneza gamazi lo okuꞌ lavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nesi idoꞌ Halisaioꞌ monoꞌ laaꞌ avesi aꞌmine aneza gamazi ne gili lelikumuꞌ nolive li gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Neꞌmine li gili analoꞌ di bililizaniꞌ akamuꞌ viseꞌ igi minaniꞌza eveneꞌ mukiꞌ Izesuꞌnimuꞌ nene Oꞌmosolatiꞌ polohete neive li gilanako neꞌmo engikumuꞌ golise gili huli-mikaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Izesuꞌ aza iheꞌ imineꞌ molo aneza gamazi nolo-ngemo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Okulumokuꞌ miniveꞌmo eiꞌ gizebo inguꞌ vi hilalizave lo elese molave ingine aꞌmanapa igi amavo atoꞌ aleve ngeleꞌmize molalineꞌ monovo neꞌmino neive: Guvelesi ve maliꞌmo gipeleloꞌ veneꞌ hukolosa nosoꞌ niteꞌ do vaꞌvaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Do vaꞌvaꞌ noogo gelekeleꞌ izipe ngimiselavo elese molaveloꞌ vi alo li li-ngidaniꞌza aꞌmine elese molave ingine gilii aꞌmanapa igi amaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Neꞌmine ikevo aza iheꞌ gelekeleꞌ izipe ngimiselo tiꞌ lo lineꞌ: Elese muluve maloꞌ gohi vi neꞌmine li-ngimilo: Nosoꞌ niteꞌ nene mo do vaꞌvaꞌ okuve. Bulumakaꞌ idoꞌ ize ato atoꞌ gehesi minaniꞌ mo ngebelo gize vataꞌ ogo nosoꞌ niteꞌ ato atokisi do vaꞌvaꞌ ogo molo nouve. Nemuꞌ nene aꞌmine lo vineꞌ nosoꞌ nitetoꞌ nene aloꞌ alo. ");
INSERT INTO aso_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tiꞌ lo lavo ingine iheꞌ vi li-ngidikevo goseleꞌ ngebelo vosoꞌ gaꞌine ngisamivo gili huli ve ma ne miꞌveuko vavo ve ma ne bisinisiꞌvela vo gonouꞌ vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Idoꞌ linge ma nete guvelesi veꞌmi gelekeleꞌ izipe nene aꞌnidoꞌ di linge ma goboni mili-ngidi linge ma nene ngibili hilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Neꞌmine ikevo guvelesi ve aza izeboloꞌ goloso molavo ami lovouꞌ monaaꞌ ave ngeletavo vi gelekeleꞌ izipe ngibili hilave vi ngebele geseꞌ igi numuꞌine ebeꞌine viteꞌ viteꞌ igi ngibilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Neꞌmine ikevo guvelesi ve aza iheꞌ gelekeleꞌ izipe tiꞌ lo lo-ngimineꞌ: Nosoꞌ niteꞌ nene mo do vaꞌvaꞌ o noneꞌza elese muluve nene ngemeni dameni golososi aꞌminguꞌ amosolovoꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nemuꞌ nene vi aka ngomoꞌ nabakuꞌ moni ningilizaniꞌ eveneꞌ mukiꞌ ngeleꞌmizi ikevo nosoꞌ niteꞌ mene nalizave. ");
INSERT INTO aso_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Neꞌmine lavo aꞌmine gelekeleꞌ izipe aka ngomo ngomouꞌ moni eveneꞌ golososi laminekisi ngeleꞌmizi ikevo nosoꞌ niteꞌ di vaꞌvaꞌ aniꞌ numunguꞌ nene gikiꞌ lamineꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Eveneꞌ vaiꞌ gikiꞌ ikevo guvelesi ve aza ningelesa dizineꞌ. Dizo ningineꞌ nene ve maliꞌmo nosoꞌ niteꞌ nalisa gonolise lamineꞌ igaꞌ adiꞌmine amo haza ogo minineꞌ nene ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ningo guvelesi veꞌmo tiꞌ lo longoꞌ o-dineꞌ: Zogone, gaza nosoꞌ niteꞌ nalisa genegana lamineꞌ ngilaaꞌ aniꞌ ma ngolamo meuꞌ nanitekumuꞌ dizane. Neꞌmine lavo aꞌmine ve gamazi lilineꞌ nomivo viseꞌ ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Neꞌmine ogavo guvelesi ve aza gelekeleꞌ izipe lo-ngimineꞌ: Gizene analoꞌ nalaꞌ di-miki huli hetoꞌ litiꞌmuso naba ize mininguꞌ nene huli-dilo. Neloꞌ mino mulumo alumo gelo ive nama ogo vele ongoho langoloꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tiꞌ lo lo-ngemo Izesuꞌ aza neꞌmine lineꞌ: Oꞌmosoꞌmo eveneꞌ mukiꞌ elese molo neineꞌza aꞌmingutiꞌ nene eveneꞌ hamo pamokovoꞌ nevo gizekaꞌ ogo do anauꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Neꞌmine lavo Halisaioꞌ monoꞌ laaꞌ ave vi tiꞌ li lovo gizi laniꞌ: Eveneꞌ ma ngimiselekunivo vi Izesuꞌni golo izikevo goniꞌ o-deloineꞌ gamazi lilingumuꞌ ve laniꞌ. Neꞌmine li engiꞌ izipahaꞌine zuhoutikisi guvelesi ve Helodeꞌni hize eleꞌ i-daaꞌ aveutikisi eveneꞌ linge ma ngimiselikevo ");
INSERT INTO aso_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","17","Izesuda igi heteli tiꞌ li li-imaniꞌ: Tisazo, gaza ve lisiheꞌ lamineꞌ naineꞌ nene mo gele none. Gamazi lo-ngemelineꞌ aleve nene naniꞌmine aleve nilizahe nemuꞌ gaza gaka mukiꞌ gelesaꞌmane. Eveneꞌ naba mini geiꞌ lilineꞌ gamazimuꞌ muluꞌninguꞌ goloso gili gelemilizadokisi nilizaniꞌ nemuꞌ gelamo Oꞌmosoꞌmi aka lelebizo gamazi gihilevoꞌ lo lemaaꞌ nane. Nemuꞌ nene geiꞌ gaka gele naineꞌ nene lo lemezo. Gelelonge. Neꞌmine li tiꞌ li longoꞌ i-daniꞌ: Loma veti guveꞌinesi ve naba Kaesaleꞌ aza takisi moni huli-nidilizave lo neidoꞌ nene eꞌmeto Zuda ve laza ma hulo-desoꞌ nene lisiheꞌ o neihe. Louꞌ gamazite avutoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tiꞌ li laniꞌza Izesuꞌ aza engiꞌ monovo goloso ningo gelo adoꞌ lingine Kaesaleꞌni takisi moni imilo lilineꞌ neꞌmo Zuda ve nene ngizeboloꞌ molavo ganala dalive. Idoꞌ imamilo lilineꞌ nene Loma ve ngizeboloꞌ molavo ganala dalive li gilaniꞌ nene gelo tiꞌ lo lo-ngimineꞌ: Lingine eveneꞌ vevesi minaniꞌ gili moni lutine goloso o vineꞌ nene di halekaniꞌ mene ");
INSERT INTO aso_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","nanimuꞌ nemenguꞌ nimilave. Takisi milaliza moni nene ningeloze. Di alo. Neꞌmine lavo aꞌmine geheni ne di igi elebizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Elebizikevo ningo tiꞌ lo longoꞌ o-ngedo lineꞌ: Me moniloꞌ eveneliꞌmi golo velesi gulivesi neineꞌ nene zahi golo velesi gulivesi neive. Longoꞌ o-ngedavo nene Kaesaleꞌ ma ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Tiꞌ li ma aꞌmine moni nene ngamani gizebo ve eiꞌ Kaesaleꞌ initeꞌve noloseinako aꞌminemuꞌ nolivo ma nene ha imilo. Idoꞌ aꞌmineꞌmine igi Oꞌmosoꞌmo lingimineꞌ initetoꞌ nene ha golo hizi imilo. ");
INSERT INTO aso_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Neꞌmine lavo engiꞌ gamaziꞌine neꞌmo ivileꞌ amivo ingine veꞌine gahava nomineꞌ mini huli-miki vi ha ha aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Idoꞌ aꞌmine gameneuꞌ nene Sadukaioꞌ monoꞌ laaꞌ ave ingine helaakutiꞌ otaaꞌ ne nomive laaꞌ ave engikutiꞌ linge ma Izesuda igi longoꞌ i-di laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tisazo, Moseꞌ aza luhuvo tiꞌ lo gizo lemave: Uvoꞌninge nakuꞌninge ma minilizangutiꞌ maliꞌmo veneꞌ do mino izipe gedamo helavo ma engikutiꞌ maliꞌmo aꞌmine veneꞌ gevonoꞌ nene do aꞌmine hilivemuꞌ nene izipe gedo molo-delive. ");
INSERT INTO aso_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Neꞌmine o neinako uvoꞌninge nakuꞌninge seveni ma minaniꞌ. Uvoꞌnibo ganaꞌve neꞌmo veneꞌ do mino izipahala sotoꞌ amavo hilineꞌ. Helavo nakunolo aꞌmidotiꞌ neꞌmo elenahine daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Idoꞌ aꞌmine nakunolo aꞌmine veneꞌ do aꞌmineꞌmine ogo izipe gedamo helavo nakunolo aꞌmidotiꞌ neꞌmosi aꞌmine veneꞌ do izipe gedamo hilineꞌ. Ee, aꞌmine uvoꞌninge nakuꞌninge seveni aꞌmine veneꞌ nene dikaꞌ dikaꞌ igi izipe gidami hili osuꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hili osuꞌ likevo alingeꞌ veneꞌ aza hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Neꞌmine ogavo aꞌmine uvoꞌninge nakuꞌninge seveni nete aꞌmine veneꞌ nene mukilite daniꞌ ma nenako eveneꞌ mukiꞌ hilangutiꞌ otiliza gameneuꞌ zahi elenaho loloꞌ ilive. ");
INSERT INTO aso_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine Oꞌmosoꞌmi gamazi Monoꞌ Godolouꞌ gizi nizaniꞌ nene gili vevesami Oꞌmosoꞌmi amuzomukisi gili lamineꞌ isaꞌmaniꞌ neꞌmo gili gopo ikeve. ");
INSERT INTO aso_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Hilangutiꞌ otaaꞌ gameneuꞌ nene veneꞌ daaꞌ idoꞌ veloꞌ vaaꞌ monovo nene ma minamoloseive. Eveneꞌ Oꞌmosoꞌmi angelole ha minaaꞌ naniꞌ neꞌmini inginesi ha minilisave. ");
INSERT INTO aso_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Neꞌmine o neineꞌza eveneꞌ hilangutiꞌ otaaꞌ nemuꞌ lo-lengemelove. Lingine Oꞌmosoꞌmo me gamazi lo-lingimineꞌ nene Monoꞌ Godolouꞌ gize neineꞌ ma gati gilahe gilamave. ");
INSERT INTO aso_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tiꞌ lo gize neive: Naza Abalahamule Isakale Zakobole engiꞌ Oꞌmosoꞌine ne nouve lineꞌ. Idoꞌ aꞌmine ve hili osuꞌ ladiniko engiꞌ Oꞌmosoꞌine nouve ngelo ma lamidine. Engiꞌ Oꞌmosoꞌine nouve lineꞌ neꞌmo mo hili osuꞌ lami ha nizave lo gelelesune. ");
INSERT INTO aso_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tiꞌ lo Izesuꞌ lineꞌ nemuꞌ eveneꞌ ingine upuhoꞌ igi voꞌine gaꞌine vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","IdoꞌIzesuꞌ lineꞌ gamazi nene ivileꞌ igi Sadukaioꞌ monoꞌ laaꞌ avete aꞌmidoꞌ gamazi ma li-imamilizaniꞌ o vivo gili Halisaioꞌ monoꞌ laaꞌ ave Izesuꞌ neida vi di geseꞌ ikevo ");
INSERT INTO aso_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","engikutiꞌ ve ma Zuda vete monoꞌ gozopotatiꞌ laaꞌ naniꞌ nene apize ngemaaꞌ ive ma minineꞌ neꞌmo emenguꞌ molo tiꞌ lo longoꞌ o-dineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisazo, Oꞌmosoꞌmo louꞌ gamazi lo huko-lidineꞌ neutiꞌ louꞌ gamazi mukiꞌ ngivileꞌ ogo nani gamaziꞌmo dizo neive. ");
INSERT INTO aso_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Dizo neineꞌ gamazi nene neꞌmine lo neive: Lutine gatine vodinesi Guvelesi ve Oꞌmosotida nene mili lutine imivoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Idoꞌ aꞌmidotiꞌ lemo minineꞌ gamazi ma aꞌmine gidini mino tiꞌ lo neive: Lingine lengiꞌ okodinemuꞌ gilaaꞌ naniꞌ neꞌmine igi eveneꞌ avita gidini nizavemukisi nene gili lutine ngimilo. ");
INSERT INTO aso_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moseꞌ louꞌ gamazi linge gizineꞌ nesi idoꞌ Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ ave polohetelite gizi nizaniꞌ gamazi mukiꞌ nesi aꞌmine louꞌ sitaꞌ gele daaꞌ monovo nene ha li ngoloꞌ lilisa imineꞌ mili gizi nizaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Idoꞌ Halisaioꞌ monoꞌ laaꞌ ave ingine di geseꞌ igi nizavo Izesuꞌ aza longoꞌ o-ngedo ");
INSERT INTO aso_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tiꞌ lineꞌ: Lingine Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa livemuꞌ gilikevo zahi aꞌvopilemoꞌ nolive. Lavo ingine avotemoti guveꞌinesi ve naba Davidiꞌ aꞌvopilemoꞌ ve li li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Li-imikevo tiꞌ lo lo-ngimineꞌ: Tiꞌ li ma Oꞌmosoꞌmi Sikalahuꞌ neꞌmo do ote-davo Davidiꞌ aza aꞌmine vemuꞌ Guveꞌnesi ve ve lineꞌ nene nanimuꞌ lave. Davidiꞌ aza tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Okulumokuꞌ ve aza Guveꞌnesi vemuꞌ tiꞌ lo lo-imineꞌ: Nezelotiꞌ geiꞌ ne nange. Aꞌne hulaaꞌ uvoda minezo. Nanivo biluvaka nene gizengala doꞌmo leme-ngedekuvo gelekeleꞌ i-gidi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Neꞌmino Davidiꞌ neꞌmo Guveꞌnesi ve ve lo lineꞌ nenako nemuꞌ aꞌmine do luꞌ izelive lo Oꞌmosoꞌmo imiselelesa live aza Davididatiꞌ leme mino ha aꞌvovoꞌ nado minelive. ");
INSERT INTO aso_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Neꞌmine lo longoꞌ o-ngedavo eveneꞌ aꞌminguꞌ mo ngeli li-imamilizaniꞌ ogavo aꞌmine gamenelotiꞌ nene ngehelele goloso izavo initeꞌ gohi mamuꞌ longoꞌ i-damaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Izesuꞌ aza eveneꞌ mulisesi idoꞌ izipahala zuhosi gamazi nolo-ngemo ");
INSERT INTO aso_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","tiꞌ lo lineꞌ: Ingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ naniꞌ apizi lingimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ avesi Moseꞌ ogo molo ineꞌ monovo di aꞌninguꞌ igi Oꞌmosoꞌmo louꞌ gamazi lo huko-limingumuꞌ nene li-lingimaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nemuꞌ nene gili ngimii ingine li-lingimilizaniꞌ gamazi mukiꞌ nene gili di minilo. Tiꞌ o neineꞌza li-lingimaaꞌ naniꞌ gamaziloꞌ nene angiseꞌinesi eꞌmetisaꞌmanaze. Nemuꞌ ingine igi mili igaꞌ naniꞌ ngemeni dameni neꞌmine nene lingine amilo. ");
INSERT INTO aso_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ingine louꞌ gamazi ngomoꞌ nabaꞌ di nubuho igi gili dalizave li aꞌmine geniꞌvesi louꞌ gamazi vaiꞌ nene eveneliti gataꞌnidoꞌ gihi-ngidaaꞌ nave. Gihi-ngidaaꞌ naniꞌza aꞌmine geniꞌvesi louꞌ gamaziutiꞌ louꞌ hamoꞌ ma ngomo lasolo neꞌminesi angiseꞌine ma gihisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Initeꞌ mukiꞌ igi mili igaꞌ naniꞌ nene evenelite ningi lopoꞌni lilizave lisa igaꞌ nave. Idoꞌ ngopoꞌni lilizangumuꞌ nene Monoꞌ Godolo avile di gangi bokisi ngomouꞌ miliki golihiꞌnidoꞌ nehe aꞌninguꞌ nehe nalaꞌ izikaꞌ aniꞌ nene eveneꞌ linge ngivileꞌ igi engiꞌ di naba igi izikaꞌ nave. Tiꞌ igi Moseꞌ louꞌ molaniꞌ nene gate molalive li gili goꞌ gala neꞌmine geneganaꞌine gahevela hela hela naꞌnava izikaniꞌ neꞌmo eveneꞌ ma ngivileꞌ igi di naba igi izikaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Neꞌmine iki nosoꞌ niteꞌ naba nada nehe idoꞌ monoꞌ numunguꞌ nehe nevoꞌminguꞌ vilizaniꞌ nene eveneꞌ nabalitevoꞌ minaaꞌ aniꞌ holomolokovoꞌ minilisa gili minaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Idoꞌ maketiloꞌ eveneꞌ muliseuꞌ siza li-lidilizave li idoꞌ tisazo li di hozi li-lidilizave li gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ingine neꞌmine igaꞌ naniꞌza Oꞌmosoꞌmo hamoꞌ lengiꞌ tisatine neivo lingine eze izipahala zuho mini linge ma dizi minikevo linge ma limi minamanako nemuꞌ eveneꞌ mamuꞌ Tisazo li-ngidamilizave. ");
INSERT INTO aso_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Idoꞌ me misubouko eveneꞌ ma di hozi li-di ezemuꞌ meteho ve lamilo. Okulumokuko neive Oꞌmoso eiꞌ hamoꞌ Metibo ne neive. ");
INSERT INTO aso_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Idoꞌ lengikumuꞌ gizebo ve ve likelizave. Oꞌmosoꞌmo do lunguꞌ izelive lo imiselelesa live eikovoꞌ hamoꞌ lengiꞌ gizebo vetine neive. ");
INSERT INTO aso_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Idoꞌ aꞌmineꞌmine ogo lengikutiꞌ ve ma dizo nolineꞌ nene gelekeleꞌ o-lengedo minelive. ");
INSERT INTO aso_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Idoꞌ ve ma engiꞌ guliveꞌine di dizi minilizaniꞌ nene engiꞌ guliveꞌine doꞌmo leme-ngedeleseive. Idoꞌ ingine engiꞌ diꞌmi limi minilizaniꞌ nene Oꞌmosoꞌmo doꞌmo dize-ngedo hize eleꞌ o-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Lingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ naniꞌ apizi ngimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ navesi nene ehetine ve. Lingine eveneꞌ vevesi minave gili monaaꞌ naha lutine goloso o vineꞌ nene di halekaaꞌ nave minaniꞌ neive. Neꞌmine igi mini Okulumokuko miniveꞌmo gizebo inguꞌ vi hilalisa naveti aka hizi tilaaꞌ nave. Langisetine nene aꞌminguꞌ ma dizisaꞌmave. Idoꞌ eveneꞌ ma dizilisa navo ha nevo dizilizave li ningi huli ngimikavo ma dizisaꞌmave. Neꞌmine igaꞌ nanako nemuꞌ agae, mulumotine gelekuve. Oꞌmosoꞌmo lihime lengemelesa neive. ");
INSERT INTO aso_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ee, Lingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ aniꞌ apizi ngimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ navesi ehetine ve. Lingine eveneꞌ vevesi minave gili monaaꞌ naha lutine goloso o vineꞌ nene di halekaaꞌ nave minaniꞌ neive. Neꞌmine igi mini lingine numudoꞌ namadoꞌ moni eveneꞌ hamoꞌ nevo ne lengita giꞌmizilizahe li lingine lelita leꞌmetilizave li li-ngimii eveneꞌ gaꞌine dalisa amuzo goloso milaaꞌ nave. Idoꞌ ma lengeꞌmeti izipahatine zuho liliꞌ igi ma lingine laniꞌ gamazitine gili dalizadiꞌmo lengiꞌ lingivileꞌ igi aka golosoloꞌ moni mulumo ebekuꞌ vi hilalizave liliꞌ ilisave. Neꞌmine igaꞌ nanako nemuꞌ agae, mulumotine gelekuve. Oꞌmosoꞌmo lihime lengemelesa neive. ");
INSERT INTO aso_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Idoꞌ lingine monoꞌ aka ngelebizaaꞌ ave nizaniꞌza vetine likineꞌ gelavo aꞌmine aka ningi vevesami eveneꞌ monoꞌ nili-ngimi gopo gamazi tiꞌ li li-ngimaaꞌ nave: Gamaziꞌine di amuzo milalisa gamazi lamineꞌ nolune li aꞌine di dizi monoꞌ numuno nabaloꞌ li mili lilizave nene ingine haza gamazivoꞌ lilisave. Soza lilizanikisi engita gamazi ma minamoloseive. Neꞌmine li lingine tiꞌ li li-ngimaaꞌ nave: Ne neiha lamineꞌ nolune li aꞌine di dizi monoꞌ numuno nabauꞌ minineꞌ ngolimoniloꞌ li mili lilizave ingine gamazi laminekovoꞌ lilizaniꞌ o neive. Soza lilizaniꞌ nene Oꞌmosoꞌmo lihime ngemeleseive. Lingine gopo gamazi neꞌmine li eveneꞌ ngeleꞌmizi gopo igaꞌ nanako nemuꞌ ehetine ve. ");
INSERT INTO aso_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aꞌmine ngolimoni nene monoꞌ numuno nabauꞌ minidiꞌmo kekeize lineꞌ nenako nemuꞌ nene monoꞌ numuno naba neꞌmo ngolimoni ivileꞌ ogo initeꞌ naba neive. Olo. Neineꞌ nenako nemuꞌ lingine aꞌmine monoꞌ numuno nabaloꞌ lo molaaꞌ nene haza niteꞌ neivo monoꞌ numuno nabauꞌ minineꞌ ngolimoni neloꞌ lo molaaꞌ nene initeꞌ gihile neive li laaꞌ nanako nemuꞌ nene vetine like vineꞌ gelavo eveneꞌ dingani goloso nizave. ");
INSERT INTO aso_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Idoꞌ lingine gopo gamazi neꞌminesi li-ngimaaꞌ nave: Gamaziꞌine di amuzo milalisa gamazi lamineꞌ nolune li aꞌine di dizi Oꞌmoso imaniꞌ initeꞌ molaaꞌ holomo neloꞌ li mili lilizave ingine haza gamazivoꞌ lilisave. Soza lilizanikisi engita gamazi ma minamoloseive. Neꞌmine li lingine tiꞌ li li-ngimaaꞌ nave: Ne neiha lamineꞌ nolune li aꞌine di dizi aꞌmine holomoloꞌ Oꞌmoso imaaꞌ naniꞌ initetoꞌ li mili lilizave ingine gamazi laminekovoꞌ lilizaniꞌ o neive. Soza lilizaniꞌ nene Oꞌmosoꞌmo lihime ngemeleseive li li-ngimaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Idoꞌ monoꞌ numuno nabauꞌ Oꞌmoso imaniꞌ initeꞌ molaaꞌ holomo neꞌmo aꞌmine Oꞌmoso imaniꞌ initeꞌ nene kekeize lo neineꞌ nenako nemuꞌ Oꞌmoso imaniꞌ initeꞌ nene holomo neꞌmo ivileꞌ ogo initeꞌ naba neive. Olo. Neineꞌ nenako nemuꞌ lingine aꞌmine holomoloꞌ lo molaaꞌ nene haza niteꞌ neivo aꞌmine holomoloꞌ mili Oꞌmoso imaniꞌ initetoꞌ lo molaaꞌ nene initeꞌ gihile neive li laaꞌ nanako nemuꞌ nene vetine likineꞌ gelave. ");
INSERT INTO aso_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gililo. Ingine lamineꞌ nolune li aꞌine di dizi Oꞌmoso imaniꞌ initeꞌ molaaꞌ holomoloꞌ li milalizaniꞌ nene aꞌmine holomolokisi idoꞌ Oꞌmoso imaaꞌ naniꞌ initeꞌ mukiꞌ aꞌmidoꞌ neineꞌ nemukisi li mili lilizaniꞌ geleleseive. ");
INSERT INTO aso_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Idoꞌ ingine aꞌine di dizi monoꞌ numuno nabaloꞌ li mili lilizaniꞌ nene aꞌmine monoꞌ numuno nabalokisi aꞌmine monoꞌ numuno melehinelokisi li mili laniꞌ geleleseive. ");
INSERT INTO aso_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Idoꞌ ingine aꞌine di dizi Okulumotoꞌ li mili lilizaniꞌ nene Oꞌmosoꞌmo aꞌmidoꞌ mino initeꞌ mukitoꞌ gizebo ogaꞌ neineꞌ moꞌmosiꞌve nelokisi li mili aꞌmidoꞌ minivelokisi li mili laniꞌ geleleseive. Nemuꞌ nene naniteꞌ nanitetoꞌ li mili adine di dizi lilizahe. Ha gamazi laminekovoꞌ lilisave. ");
INSERT INTO aso_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ naniꞌ apizi ngimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ navesi nene ehetine ve. Lingine eveneꞌ vevesi minave gili monaaꞌ naha lutine goloso o vineꞌ nene di halekaaꞌ nave minaniꞌ neive. Neꞌmine igi mini lingine Moseꞌ louꞌ gamaziutiꞌ gamazi ngomo maloꞌ eꞌmeti midinguꞌ minineꞌ initekutiꞌ linge ngomo ma ize mili Oꞌmoso imaaꞌ nanguꞌ nene initeꞌ ngomo ngomo adoꞌ noso niteꞌ do laniteꞌ ogaꞌ ineꞌ initeꞌ nevoꞌmingutikisi izeꞌ mili Oꞌmoso imaaꞌ naniꞌza Moseꞌ aza eveneꞌ monovo lisihekovoꞌ i-ngidilizangumukisi idoꞌ mulumoꞌine gili ngeleꞌmize lamineꞌ ilizangumukisi idoꞌ goꞌine izamilizangumukisi louꞌ gamazi lineꞌ nene dizo mino initeꞌ naba neineꞌ nene gili hulaaꞌ nave. Aꞌmine lemo minineꞌ louꞌ gamazi ngomo ngomo damilizavoba gili dalizadoꞌ o neineꞌza aꞌmine luvoniꞌ louꞌ gamazi naba nesi gili dalizanako mo gili disaꞌmave. Agae, mulumotine gelekuve. Oꞌmosoꞌmo lihime lengemelidoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lingine vetine like vineꞌ gelavo monoꞌ aka ngelebizilisa igi aꞌmine aka ningi vevesami lihime ngomo ngomo daaꞌ monovo hulaniꞌza lihime nabaꞌ naba daaꞌ monovo nene hulamanako eveneꞌ ma nalizaniꞌ initekutiꞌ initeꞌ ngomo lasolo neꞌmo do goloso alive li di huliki initeꞌ goloso naba nene mikileꞌ igaꞌ naniꞌ gili vaniꞌ nizave. ");
INSERT INTO aso_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Idoꞌ lingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ aniꞌ nene apizi ngimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ navesi ehetine ve. Lingine eveneꞌ vevesi minave gili monaaꞌ naha lutine goloso o vineꞌ nene di halekaaꞌ nave minaniꞌ neive. Neꞌmine igi mini lingine okodine losuvo di guni iki lamineꞌ noube li igaꞌ naha lutine neꞌmo gumineloꞌ ve gelo mo initeꞌ golosovoꞌ dalisa gili nizave. Lingine kapu idoꞌ lapese heta noso iziki lulouko ha hulikaꞌ naniꞌ neꞌmine nizanako nemuꞌ agae, mulumotine gelekuve. Oꞌmosoꞌmo lihime lengemelesa neive. ");
INSERT INTO aso_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Halisaioꞌ ve vetine like vineꞌ gilineꞌ mene okodine losuvo nene mo lamineꞌ ilive li ma gomuꞌ nene lutine di lamineꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Lingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ aniꞌ apizi ngimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ navesi ehetine ve. Lingine eveneꞌ vevesi minave gili monaaꞌ naha lutine goloso o vineꞌ nene di halekaaꞌ nave minaniꞌ neive. Neꞌmine igi mino lingine gonoso galese heta luhuvo izi di guni ikaniꞌ neꞌmine igi nimonaha lulouko nene gonoso amuzoꞌmo sihononi initeliꞌmo vaiꞌ lo ongo neive. Eveneꞌ okodine losuvoloꞌ ningikevo ve lisiheꞌ lamineꞌ nizahe li ningaaꞌ naha lutinguꞌ nene soza saza laaꞌ monovosi idoꞌ peleseveꞌ izaaꞌ monovosi di naba igi daaꞌ nave. Neꞌmine igaꞌ nanako nemuꞌ agae, mulumotine gelekuve. Oꞌmosoꞌmo lihime lengemelesa neive. ");
INSERT INTO aso_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Idoꞌ lingine Zuda vete monoꞌ gozopotatiꞌ laaꞌ naniꞌ apizi ngimaaꞌ navesi idoꞌ Halisaioꞌ monoꞌ laaꞌ navesi nene ehetine ve. Lingine eveneꞌ vevesi minave gili monaaꞌ naha lutine goloso o vineꞌ nene di halekaaꞌ nave minaniꞌ neive. Neꞌmine igi mini lingine tiꞌ li laaꞌ nave: Laza avotemote minaniꞌ gameneuꞌ makatoꞌ minunidini ingine Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ ave polohete nene ngibili nihilavo laza aꞌmine avotemotine hize eleꞌ o-ngedamunidine. Neꞌmine lii laaꞌ naha aꞌmine avotinge apiꞌ aniꞌ gono nene imineꞌ mili di aꞌmine ngibilaniꞌ polohete idoꞌ ve lisiheꞌ lamineliti gonoso amuzoꞌine mili-ngidaniꞌ numuno gizikaniꞌ nene imineꞌ mili di guni igi gonoso mili-ngidaniꞌ galeseꞌine nene di lamineꞌ igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Idoꞌ neꞌmine igi lingine polohete ngibili hilaveti zuho minikevo engiꞌ ngemeni dameni lengita minineꞌ nene di sotoꞌ igi lengiꞌ monovotine langisetine li sotoꞌ igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lingine avotinge aniꞌ monovo nene di di vamilizanako ha di di vilevo. Neꞌmine igaꞌ nanako nemuꞌ agae, mulumotine gelekuve. Oꞌmosoꞌmo lihime lengemelesa neive. ");
INSERT INTO aso_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sataliꞌmi izipahala zuho, Oꞌmosoꞌmo gonitoꞌ lengeleꞌmize molalidotiꞌ ha olovoꞌ ilizahe. Oꞌove. nGeli olovoꞌ amilisave. Nemuꞌ nene lihizamilineꞌ olokuꞌ vi hilalisave. ");
INSERT INTO aso_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Neꞌmine ilizangumuꞌ nene naza Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ i lingimilizavesi idoꞌ gamazi monovo ningi gili li sotoꞌ i lingimilizavesi idoꞌ monoꞌ apizi lingimilizavesi nene lengita ngimiselelesuve. Neꞌmine okuvo ikevo lingine engikutiꞌ linge ma lohotoꞌ zaloꞌ ngibili hili linge ma monoꞌ numudinguꞌ gavosotunuꞌ ngibiliki numudotiꞌ numudotiꞌ ngimiselekaꞌ ngimiselekaꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aꞌmine ve ngimiseleloniꞌ nene nemuꞌ ngimiselelesuve: Me misubouko nene ve lisiheꞌ lamineꞌ mukiꞌ nene eveneꞌ malite ngibili hilikaꞌ hilikaꞌ aniꞌ neꞌmi lihime nene lengita dizeleseive lo ngimiselelove. Ee, Adamuꞌ gipele ve lisiheꞌ Abeliꞌni uvolohoꞌmo bele hilidotiꞌ nene ve lisiheꞌ mukiꞌ ngibili hiliꞌmi dizi Balakiaꞌ gipele Zakaliaꞌ aza Oꞌmoso lehizi-daniꞌ initeꞌ olokuꞌ gizaaꞌ aniꞌ holomosi idoꞌ monoꞌ numuno naba nesi olusoꞌ neivo bili hiladoꞌ ivo aꞌmine ngibili hilaniꞌ neti lihimeꞌine nene lengita dizeleseive. ");
INSERT INTO aso_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Laminetoꞌ nolo-lingimuve: Eveneꞌ mukiꞌ ngibili hiladiꞌmi lihime mukiꞌ nene me misubouꞌ idise nizave lengita dizeleseive. ");
INSERT INTO aso_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Agae, Zelusalemi alevekizo, lingine polohete ngibili hilii idoꞌ Oꞌmosoꞌmo lengita gono dalizave lo ngeletivesi nene geheni gavoso ngibili hilaaꞌ ave lengiꞌ nene okoloholiꞌmo goduvoꞌ do holokeꞌneꞌveko do nubuho o-ngidineꞌ maꞌmine ogo gamene gamene lengeleꞌmize lamineꞌ olosa uvoniꞌza lingine goseleꞌ lengebelave. ");
INSERT INTO aso_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lingine gililo. Numuno nabatine minineꞌ ebetinguꞌ nene Oꞌmoso aza gohi minamo mo hulo-lengedavo gaꞌmetoꞌ neꞌmine ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Idoꞌ mene noluvoniꞌ gamazi neꞌmi monovo tiꞌ lo nolo-lingimuve. Idise melotiꞌ nene neze okoꞌneloꞌ ningami miniꞌmi dizi alingeta gohi sotoꞌ nouvo tiꞌ li li-nimilisave: Guvetesi ve Oꞌmosoꞌmi velemuꞌ anive naineꞌ ma nene noꞌnohoꞌ geita minivoo. Neꞌmine li li-nimilizaniꞌ gameneuꞌ nene neze ningilisave lo lo-ngimineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Izesuꞌ aza monoꞌ numuno naba nene hulo novivo izipahala zuho eita igi monoꞌ numunguꞌ numuno lamineꞌ tamineꞌ nene elebizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Elebizikevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Tiꞌ iha me ningilo. Agae, laminetoꞌ lo-lengemelesuve. Numuno naba me geheni nabaꞌ nabadunuꞌ gizi nizaniꞌ ningahe. Aꞌmine geheni nene bili ngululubizi hulikevo aꞌmingutiꞌ geheni sitaꞌ neꞌminesi ma bizi minamilisasive. ");
INSERT INTO aso_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Neꞌmine losa Oliva gololoꞌ vo mitoꞌ neivo izipahala zuho engikovoꞌ nene neida igi tiꞌ li longoꞌ i-daniꞌ: Idiꞌne lo-lemaineꞌ initeꞌ nene naniheꞌ sotoꞌ ilive. Idoꞌ geiꞌ tineꞌ molo alineꞌ gamene nesi idoꞌ misubouꞌ initeꞌ mataꞌ mukiꞌ osuꞌ lilineꞌ gamene nesi nene mo alitave lo ningesoꞌ nene naniteꞌ sotoꞌ ogavo ningelone. ");
INSERT INTO aso_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Eveneꞌ mukiꞌ nete nene igi neniꞌ guliveꞌne lii Oꞌmosoꞌmo do lunguꞌ izelive lo nimiselelesa live nene naꞌmo nouve li likaꞌ likaꞌ igi goꞌine izikevo eveneꞌ mukiꞌ nete gili ngimikevo di gopo i-ngidilisave. Neꞌmine ilisanako nemuꞌ nene engikutiꞌ maliꞌmo lengiꞌ gotine izavo linginesi gili imikelizave. Ehe, gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Idoꞌ lovo sotoꞌ neivo gili ebeꞌ mala mala lovo sotoꞌ neivo neꞌmi gamazi ma gililisave. Gili ma upuhoꞌ igi golise gilamilo. Aꞌmine nene sotoꞌ oloseiha initeꞌ vaiꞌ osuꞌ lilineꞌ gamene naba nene aꞌmidoꞌ olihe sotoꞌ amive. ");
INSERT INTO aso_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Idoꞌ misubo mauꞌ vete misubo mauꞌ vesi lovo hizilisave. Idoꞌ guvelesi ve naba maliꞌmi zuhote guvelesi ve naba maliꞌmi zuhosi lovo hizilisave. Misubo ato atota gaꞌna naba helaaꞌ gamene idoꞌ mimiꞌ naba sotoꞌ okaꞌ okaꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Venelite izipe gidilisa mulumo apiꞌ igi gilii gilikaꞌ gilikaꞌ iꞌmi iꞌmi navo alingeꞌ izipahaꞌine sotoꞌ ogaꞌ neive. Aꞌmineꞌmine ogo mulumo initeꞌ mukiꞌ mene sotoꞌ ilineꞌ nene ha apiꞌ ineꞌ nenako nemuꞌ nene gilikaꞌ gilikaꞌ iꞌmi iꞌmi navo alingeꞌ naza sotoꞌ olosuve. ");
INSERT INTO aso_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Aꞌmine mulumo niteꞌ apiꞌ ogo sotoꞌ ogavo evenelite gonitoꞌ lengeleꞌmizi mili goboni mili-lingidi linge ma lingibili hililisave. Lingine nenita giꞌmizi minilisanako nemuꞌ eveneꞌ zuho ato atoꞌ mukiꞌ ingine lukehe lingibililisave. ");
INSERT INTO aso_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Neꞌmine aningumuꞌ nene eveneꞌ mukiꞌ gili nimi nenita giꞌmizaniꞌ nene huli ge lo sotoꞌ o ne lo sotoꞌ o li ngibililizaniꞌ aleveti aꞌninguꞌ mili ingine lukehe ge nebele ne gebele li minilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Idoꞌ eveneꞌ ma nete engikumuꞌ soza li Oꞌmosoꞌmi gamazi lo sotoꞌ ogaꞌ nouve polohete ma ne nouve lii eveneꞌ mukiꞌ goꞌine izi ngeleꞌmize gopo ilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Idoꞌ monovo goloso daaꞌ suno nene hutileꞌ ogo naba ogavo neꞌmo eveneꞌ mukiꞌ ingine luꞌine ge neme ne geme li guni amavo aꞌmine monovo ngomo oloseive. ");
INSERT INTO aso_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tiꞌ iha eveneꞌ ma nenikumuꞌ ha gili eleꞌvoleꞌ igi mini huli-nidamavo gamene naba ilineꞌ nene Oꞌmosoꞌmo do nguꞌ izeleseive. ");
INSERT INTO aso_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Idoꞌ Oꞌmosoꞌmo eiꞌ gizebo inguꞌ vi hilaliza evenele do nguꞌ izo gizebo o-ngedelingumuꞌ gamazi lamineꞌ nene gililizave li di vi misubouꞌ misubouꞌ li-ngimikaꞌ li-ngimikaꞌ igi eveneꞌ zuho ato atoꞌ mukiꞌ nene li-ngimi osuꞌ lilisave. Idoꞌ idise mene noluvoniꞌ initeꞌ nene sotoꞌ iꞌmi nivavo aꞌmine gamazi li-ngimi osuꞌ nilavo gamene naba sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Gozopoꞌ minineꞌ polohete Danieliꞌ lineꞌ initeꞌ adoꞌ ebeꞌ do goloso ilineꞌ initeꞌ goseleꞌ initeꞌ goloso gehepeve nene kekeize lo neineꞌ numunguꞌ di sotoꞌ milikevo ningilisave. (Aꞌmene gizuvoniꞌ gamazi mene gato nogelo ma gatelinive gaza gele ngoloꞌ lo gelezo.) Aꞌmine initeꞌ nene di sotoꞌ milikevo lingine niningi ma Zudaiaꞌ misubouꞌ nilizave nene golise golola nivilo. ");
INSERT INTO aso_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ehe, aꞌmine gameneuꞌ nene silibe ogo minaaꞌ nene nominako ve ma ingine numuꞌine avitasi nilizadotiꞌ nene iheꞌ numuꞌninguko vi initeꞌ mataꞌine aꞌminguꞌ neineꞌ nene di vamilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Idoꞌ minguꞌ nilizadotiꞌ nene okoꞌnidoꞌ initeꞌine dalisa tineꞌ mili numunguko amilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Agae, aꞌmine gameneuꞌ nene Izipahaꞌine minineꞌ venekumukisi idoꞌ izipe amidoꞌ nizaniꞌ venekumukisi mulumo gele-ngedekuve. Geꞌnebe goloso ilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aꞌmine initeꞌ nene goline gameneuꞌ sotoꞌ ogo idoꞌ monokumuꞌ mini gililizangumuꞌ ve li aka monamilo li li huki lingimilizaniꞌ gameneuꞌ sotoꞌ ogalize li Oꞌmosolavoꞌ li minilo. ");
INSERT INTO aso_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nanitekumuꞌ ve. Oꞌmosoꞌmo initeꞌ mataꞌ do sotoꞌ idotiꞌ idise mene noneꞌ gameneloꞌ mulumo alumo niteꞌ naba neꞌmine gomuta sotoꞌ amineꞌ nenako apiꞌ ogo aꞌmine gameneloꞌ sotoꞌ oloseive. Idoꞌ sotoꞌ ilidotiꞌ nene alingeta gohi ma neꞌmine sotoꞌ amoloseive. ");
INSERT INTO aso_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Idoꞌ Guvelesi veꞌmo aꞌmine gamene nene mine haꞌna ogalive lo bele hukolove ma lamidiniko eveneꞌ hamokisi veꞌinesi ma minamadineꞌza Guvelesi ve aza do kegesineꞌ evenekumuꞌ gelo aꞌmine gamene nene mine haꞌna ogalive lo bele hukolosa neive. ");
INSERT INTO aso_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Idoꞌ aꞌmine gameneuꞌ nene ve maliꞌmo Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live aza mela neive lo idoꞌ ningilo. Holela neive lo nolo-lingimivo ma nene gili imamilo. ");
INSERT INTO aso_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eveneꞌ ma nete sotoꞌ ikaꞌ ikaꞌ igi soza saza li do lunguꞌ izelive lo Oꞌmosoꞌmo imiselelesa live ma nene nouve idoꞌ Oꞌmosoꞌmi gamazi lo sotoꞌ ogaꞌ nouve polohete ma ne nouve li Oꞌmosoꞌmo ngeleꞌmize kegesineꞌ eveneꞌve ingine leꞌmetilizahe li gotine izi atoꞌ niteꞌ golize laaꞌ niteꞌ masi masi di sotoꞌ mili lengelebizilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ehe, mene initeꞌ olihe sotoꞌ amivo initeꞌ mukikumuꞌ gomuꞌ lo-lengemekuve. Nemuꞌ gizebo lamineꞌ ilo. ");
INSERT INTO aso_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Idoꞌ tiꞌ li ningilo. Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live aza ebeꞌ hadivela vo neive nilavo ma aꞌmida vamilo. Idoꞌ numuno lulouko dize neive lii nilavo ma gili ngimamilo. ");
INSERT INTO aso_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ingine Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live zegeno omo neive lilizaniꞌza Oꞌmosolatiꞌ ve gihile naza aloniꞌ gameneuꞌ nene gopaꞌna ledo ogo vaaꞌ neineꞌ neꞌmine ogo numudoꞌ namadoꞌ ve mukiꞌ ningi nizavo alosuve. ");
INSERT INTO aso_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Idoꞌ eveneꞌ hilaniꞌ gonoso nolida nene gonoso naaꞌ aniꞌ namalite aꞌmida nene liteꞌ li igi di geseꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aꞌmine mulumo sotoꞌ ogo minelineꞌ gamene nene osuꞌ lavo liteꞌ lo holiꞌmi labanala nolihizivo ikeꞌniꞌmi labanaꞌvesi osuꞌ loloseive. Idoꞌ sonohiꞌ nene Okulumokutiꞌ suludiꞌmoziꞌ moziꞌ navo Okulumokuꞌ amuzoꞌinesi initeꞌ nene moꞌmongoꞌ i geseꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Neꞌmine ikevo nelotiꞌ nene Oꞌmosolatiꞌ ve gihile alongumuꞌ sotoꞌ ilineꞌ maki nene Okulumotoꞌ sotoꞌ ogavo misubouꞌ misubouꞌ minaniꞌ eveneꞌ zuho ato atoꞌ mukiꞌ ingine ningi agae agae lii ive nama igi minilisave. Ee, Oꞌmosolatiꞌ ve gihile naza amuzoꞌnesi idoꞌ labanaꞌne nabasi do sotoꞌ ogosa limuso avileloꞌ nolimuvo ningilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Idoꞌ pikuli nolo naba nomolavo naza angeloꞌne zuho ngimiselekuvo ingine limi ngeleꞌmize kegesuvoniꞌ eveneꞌne nene misubo atoꞌ atokuꞌ miniꞌmi monaniꞌ ebeꞌ mukikutiꞌ nene moni ngeleꞌmize nubuho ilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Idoꞌ gohuno zaloꞌ lo molaloniꞌ nene gili lamineꞌ igi gililo. Lingine Zuda veti misubotida mene gohuno zalotiꞌ sisive hoꞌ lavo mo hoꞌ gamene alitave li ningi gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Idoꞌ aꞌmineꞌmine ogo nolo-lingimuvoniꞌ niteꞌ nene sotoꞌ neivo ma aza avitoꞌ ogo mo nene hetelelesa neive li ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Laminetoꞌ ma lo-lengemeloze. Gililo. Aꞌmine gameneloꞌ aleve nene ha mini olihe hili osuꞌ lamavosi aꞌmine initeꞌ mukiꞌ nene sotoꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Okulumoki misubogi nene ha vi osuꞌ lilisasineꞌza aꞌmine gamaziꞌne nene mo osuꞌ lamo eleꞌvoleꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Neꞌmine o neineꞌza aꞌmine sotoꞌ ilineꞌ gamenemuꞌ nene ve hamolitesi ma gelamune. Idoꞌ Okulumokuko angeloꞌ nesi nene gilamave. Idoꞌ Oꞌmosoꞌmi gipele nazasi nene ma gelamuve. Meꞌneho eiꞌ hamoꞌ ne gele neive. ");
INSERT INTO aso_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noaꞌ minineꞌ gameneuꞌ nene eveneꞌ gopo minaniꞌ neꞌmini neniꞌ Oꞌmosolatiꞌ ve gihile aloniꞌ gameneukisi aꞌmineꞌmine igi minilisave. ");
INSERT INTO aso_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noaꞌ minineꞌ gameneuꞌ nene noso naba velamivo eveneꞌ ingine ngolize izi nosoꞌ niteꞌ ni noso ni idoꞌ veneꞌ veloꞌ vavo veneꞌ di huki mili nizavo Noaꞌ aza sipiuꞌ dizavo ");
INSERT INTO aso_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ingine noso velo lebeleleseive li gilami gopo nizavo noso naba velo ogo aꞌmine aleve nene giso gilito do vineꞌ. Idoꞌ eveneꞌ aꞌmineꞌmine igi aloseive li gilami gopo nizavo Oꞌmosolatiꞌ ve gihile naza aꞌmineꞌmine ogo ogo hetelelesuve. ");
INSERT INTO aso_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Idoꞌ aꞌmine gameneuꞌ eveneꞌ sitaꞌ ma minguꞌ gono di minilisineꞌ nene eveneꞌ ma nene Oꞌmosoꞌmo do vavo ma ne ha mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Idoꞌ veneꞌ sitaꞌ viti gihile sege daaꞌ initetunuꞌ sege di minilisingutiꞌ ma nene Oꞌmosoꞌmo do vavo ma ne ha mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Guvetinesi ve nani gameneloꞌ alohe. Lingine gilamanako nemuꞌ nene lingine gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Idoꞌ lingine mene giliꞌ nalo. Gumineloꞌ veꞌmo bedineꞌ numuno neꞌmi meleho aza gumineloꞌ ve olihe amivosa holukaꞌ alineꞌ gamenemuꞌ nene ma gele minidiniko numuꞌveloꞌ nene gizebo ogavo gumineloꞌ ve neꞌmo nene ma bedamidine. ");
INSERT INTO aso_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Oꞌmosolatiꞌ ve gihile naza aloseive li gilamilizaniꞌ gameneloꞌ alosuze. Nemuꞌ lingine nene aꞌmineꞌmine igi di nene igi gizebo lamineꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Idoꞌ Guvelesi veꞌmo gelekeleꞌ izipe ma eleꞌmize molo gelekeleꞌ izipahaꞌneloꞌ gizebo ogo nosoꞌ niteꞌ naliza gameneloꞌ gameneloꞌ nosoꞌ niteꞌ ngemekaꞌ ngemekaꞌ ogo minelive lo eleꞌmize molavo peleseveꞌ izamaaꞌ ive otohato o minive nolineꞌ nene nadiꞌ oꞌmo vo minelineꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aꞌmine eleꞌmize molaniꞌ gelekeleꞌ izipe neꞌmo aꞌmine meleho imineꞌ gono nene dovoꞌ dovoꞌ ogo neivo Guvelesi ve ogo hetelo ningelineꞌ neꞌmo gelekeleꞌ izipe nene lamineꞌ ilineꞌ akaloꞌ mine molo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Laminetoꞌ nolo-lingimuve. Guvelesi ve aza ogo aꞌmine gelekeleꞌ izipe nene monovolo ningo initeꞌne mukitoꞌ nene gizebo o-nedelive lo lo-emavo gizebo o-deleseive. ");
INSERT INTO aso_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ee, neꞌmine ilineꞌza gelekeleꞌ izipe aza lulo golososi mino lulouko neniꞌ gizebo veꞌne ma nene mo liteꞌ lo amiko mino gamene alingeta alihe lo gala gelo ");
INSERT INTO aso_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","apiꞌ ogo ezesi makaꞌ gono daaꞌ ave nene ngebeledoꞌ ngebeledoꞌ ogo mino noso ni sipaki igi monaaꞌ avela vo giꞌmizo engikisi makaꞌ nosoꞌ niteꞌ ni noso niꞌmi moni minaaꞌ navo ");
INSERT INTO aso_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","aꞌmine gelekeleꞌ izipe aza gizebo veꞌne nene ne gameneloꞌ aloseive lo gelamo ngelo amoloseive lo gelo minelineꞌ gameneloꞌ nene gizebo veꞌve ogo hetelo ");
INSERT INTO aso_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","okoꞌno belevoꞌ hukovoꞌ ogo monovoꞌine goloso di halekaaꞌ ave hulo-ngedaaꞌ ida hulo-davo aꞌmida mulumo alumo gili ive nama igi veꞌine ingihi langoloꞌ igi nilizada ezesi vo aꞌmineꞌmine ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Neꞌmine lo Izesuꞌ imineꞌ molo tiꞌ lo lineꞌ: Noluvoniꞌ gameneloꞌ nene eveneꞌ Oꞌmosoꞌmo gizebo inguꞌ vi hilalizaniꞌ monovomuꞌ lo molaloze. Gililo. Alungo teni (10) neꞌmine ingine veneꞌ dalive nene vi eleꞌmizi alisa gizebo i minilisa vaniꞌ neꞌmine gele voloseive. ");
INSERT INTO aso_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aꞌmine alungo teni (10) netiꞌ faef (5) nene gaꞌine ngoloꞌ lineꞌ idoꞌ linge faef (5) nene gaꞌine ngoloꞌ lamineꞌ negi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Idoꞌ ingi gaꞌine ngoloꞌ lamineꞌ negi alu faef (5) nene lamuꞌine di vaniꞌza aꞌminguꞌ noso lumo oloꞌ lihizelingumuꞌ ve li mo di vamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tiꞌ aha gaꞌine ngoloꞌ lineꞌ alu ingine oloꞌine lihizelingumuꞌ noso lumo gomiseuꞌ lepi lamuꞌinesi di vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Idoꞌ veneꞌ dalive geto amilineꞌ ogavo alungo teni (10) mukitoꞌ veꞌine hihiꞌ ogavo inganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ingi nizavo goꞌ loꞌmo lomo oloꞌmudise holukaꞌ nene veneꞌ dalive mo naze. Vi eleꞌmizi alo li asi likevo ");
INSERT INTO aso_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","alungo mukiꞌ okisetiꞌ oti lamuꞌine di guni igi enge viteꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Neꞌmine igi gaꞌine ngoloꞌ lamineꞌ negi alu nete gaꞌine ngoloꞌ lineꞌ alumuꞌ tiꞌ li laniꞌ: Lamuteuꞌ noso okuꞌ lo lihizelesa neize. Lengiꞌ nosotingutiꞌ ma leki limilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Neꞌmine likevo gaꞌine ngoloꞌ lineꞌ alu nete tiꞌ li li-ngimaniꞌ: Lengemesoꞌ o neiha linginesi lezesi dalonidoꞌ lisiheꞌ amize. Situvakuꞌ vi langisetine hizisa lamutinguꞌ lepi di alizaniꞌ ne lamineꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Neꞌmine likevo ingine meni hizilisa vikengumuꞌ nene veneꞌ dalive ogo hetelavo lamuꞌine di vaꞌvaꞌ i minaniꞌ alungo ezesi makaꞌ veneꞌ dalingumuꞌ nosoꞌ niteꞌ gizi vataꞌ anguꞌ nene vaniꞌ. Aꞌminguꞌ dizi vikevo akahe hizi tilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Akahe hizi tilikevo alingeꞌ alungo lingela igi heteli Guvekasi ve make, mo okunge. Akahe siꞌze-ledevo li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Likevo guvelesi ve tiꞌ lo lineꞌ: Laminetoꞌ nolo-lingimuve. Lingine ningamuvoniꞌ alevete nilave. ");
INSERT INTO aso_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Neꞌmine lo Izesuꞌ imineꞌ molo lineꞌ: Ehetine ve. Nani gameneloꞌ alohe. Lingine mo kekeꞌ gilamanaze. Nemuꞌ gizebo lekeseve igi minilo. ");
INSERT INTO aso_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Idoꞌ aloniꞌ gameneuꞌ gelekeleꞌ izipahaꞌne meni ngemeloniꞌ monovomuꞌ lo molaloze. Gililo. Ve maliꞌmo ebeꞌ mala volosa gelekeleꞌ i-daaꞌ aniꞌ izipahala zuho eita do nubuho o-ngedo gizebo i-nidilizave lo initeꞌve mukiꞌ nene ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Idoꞌ neꞌmine noogo gono daaꞌ adoꞌ gele mineꞌ mineꞌ ogo moni izeꞌ molo ngimineꞌ. Gelekeleꞌ izipe ma ne faef tauseni kina (K5,000) imineꞌ. Idoꞌ ma ne tu tauseni kina (K2,000) imineꞌ. Idoꞌ ma ne vanu tauseni kina (K1,000) imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Neꞌmine ogo guvelesi ve mo vavo gelekeleꞌ izipe faef tauseni kina (K5,000) daveꞌmo liteꞌ liteꞌ lo vo aꞌmine faef tauseni kina (K5,000) nedunuꞌ moni gono do gohi faef tauseni kina (K5,000) ma do sotoꞌ molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Idoꞌ gelekeleꞌ izipe aza tu tauseni kina (K2,000) dave aꞌmineꞌmine ogo moni gono do iheꞌ tu tauseni kina (K2,000) ma do sotoꞌ molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Idoꞌ vanu tauseni kina (K1,000) dave aza vo misubouꞌ galese elo aꞌmine vanu tauseni kina (K1,000) nene galese izekineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Neꞌmine ikevo guveꞌinesi ve aza gamene haꞌna goloso mino alingeꞌ monidatiꞌ ogo izipahala zuho moni ngemekidunuꞌ gono daniꞌ ningo do lisiheꞌ olosa aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Gelekeleꞌ izipe aza faef tauseni kina (K5,000) dave guvelesi veꞌmi velela ogo oto tiꞌ lo lineꞌ: Guvekasi ve, gaza faef tauseni kina (K5,000) nemeko vaineꞌ matunuꞌ moni gono do iheꞌ faef tauseni kina (K5,000) ma do sotoꞌ uvoniꞌ ne neive lo do ogo elebizineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Elebizavo guvelesi ve aza gelekeleꞌ izipe tiꞌ lo lo-imineꞌ: Gaza peleseveꞌ izamanive gelekeleꞌ izipe lamineꞌ goloso nane. Gonoloꞌ gizebo lamineꞌ goloso ogane. Gono ngomoloꞌ gizebo lamineꞌ goloso aineꞌ nemuꞌ initeꞌ naba mukitoꞌ gizebo ve hulo-gedelesuve. Guvekasi ve naza nolize izo nouvonguꞌ dizanivo makatoꞌ lolize izo minelesusize. Ano. ");
INSERT INTO aso_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Idoꞌ aza tu tauseni kina (K2,000) daveꞌmosi ogo tiꞌ lo lineꞌ: Guvekasi ve, gaza tu tauseni kina (K2,000) nemaineꞌ aꞌmine matunuꞌ gohi tu tauseni kina (K2,000) ne ma do sotoꞌ uvoniꞌ ne neive lo do ogo elebizineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Elebizavo guvelesi ve aza tiꞌ lo lo-imineꞌ: Gaza peleseveꞌ izamanive gelekeleꞌ izipe lamineꞌ goloso nane. Gonoloꞌ gizebo lamineꞌ goloso ogane. Idoꞌ gono ngomoloꞌ gizebo lamineꞌ goloso aineꞌ nemuꞌ initeꞌ naba mukitoꞌ gizebo ve hulo-gedelesuve. Guvekasi ve naza nolize izo nouvonguꞌ dizanivo makatoꞌ lolize izo minelesusize. Ano. ");
INSERT INTO aso_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Idoꞌ aza vanu tauseni kina (K1,000) dave nesi ogo guvelesi ve neida ogo tiꞌ lo lineꞌ: Guvekasi ve, geiꞌ monovoka nene gele nouvoniꞌ ma neive. Gaza ve amuzo malehe mino gasika zuhoꞌ amaningutiꞌ nosoꞌ niteꞌ nene ha dolize daaꞌ nanive mino gasika gono damaningutiꞌ eveneꞌ maliti gonoutiꞌ nesi gihile izavo ipeꞌ ogo ha daaꞌ nanive nane. ");
INSERT INTO aso_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gaza aꞌneꞌmine ve naneꞌ nenako nemuꞌ geiꞌ moni nemaningutiꞌ ma vo tolovo ilineꞌ nene nelemaline lo golise gelo vo misubouꞌ galese elo aꞌmine vanu tauseni kina (K1,000) nemaineꞌ nene aꞌminguꞌ do haleko molo hitekuvoniꞌ ve. Idoꞌ ningezo. Idise geiꞌ monika mene do-gedo nouve. ");
INSERT INTO aso_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Neꞌmine lavo guvelesi ve tiꞌ lo lo-emo lineꞌ: Gaza gelekeleꞌ izipe goloso, gonomuꞌ goseleꞌ gebele vineꞌ mene, nenikumuꞌ nene aza zuhoꞌ amidotiꞌ nene nosoꞌ niteꞌ dolizo daaꞌ ive ve idoꞌ gono damingutiꞌ nene gihile izavo ma nesi ipeꞌ ogo daaꞌ ive ve lo gelo nolabe. ");
INSERT INTO aso_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tiꞌ lo ma moniꞌne nene beni numunguꞌ molo-nedanidini naza tineꞌ molo ogo aꞌmine moniꞌnesi idoꞌ aꞌmidoꞌ imineꞌ mili-nidilizaniꞌ polopeti masi duvodineꞌ nemuꞌ aꞌmine moniꞌne nene beni numunguꞌ molo-nedelinako molo-nedamane. ");
INSERT INTO aso_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Neꞌmine lo gelekeleꞌ izipahala aꞌmida minaniꞌ nene tiꞌ lo lo-ngimineꞌ: Idoꞌ ve ma ingine initeꞌneloꞌ gizebo lamineꞌ igi ma di minilizave nene imineꞌ molo gohi ma ngemekuvo vaiꞌ livo di minilisave. Idoꞌ initeꞌneloꞌ gizebo lamineꞌ igi di minamilizave engita initeꞌ ngomo ma nolineꞌ nene aꞌminesi gohi ipeꞌ ogo dalosuve. Neꞌmino neineꞌ nenako nemuꞌ lingine aꞌmine vanu tauseni kina (K1,000) do neineꞌ nene ipeꞌ igi teni tauseni kina (K10,000) do minivela di imilevo. ");
INSERT INTO aso_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Neꞌmine igi gelekeleꞌ izipe gulupese mene huli heta i-dikevo litiꞌmuso gehepeveuꞌ vo mino ive nama ogo mulumo alumo gelo vele ongoho langoloꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Idoꞌ Oꞌmosolatiꞌ ve gihile naza labanaꞌne do sotoꞌ ogo angeloꞌ mukiꞌ ngeleꞌmizo aloniꞌ nene Guveꞌnesi ve naba mineloniꞌ moꞌmosiꞌneloꞌ minelesuve. ");
INSERT INTO aso_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Idoꞌ aꞌmidoꞌ nouvo eveneꞌ zuho ato atoꞌ mukiꞌ nene neniꞌ veꞌneloꞌ ngeleꞌmize nubuho ilisave. Neꞌmine ikevo izeloꞌ gizebo ve neꞌmo sipisipi izeꞌvesi memeꞌ izesi gopo igi minangutiꞌ nene do kegese-ngedo sipisipi ize mulise atoꞌ hulo-ngedo memeꞌ ize mulise atoꞌ hulo-ngedaaꞌ ineꞌ neꞌmine naza eveneꞌ do kegese-ngedo sipisipi ize neꞌmini minilizave nene aꞌne hulaaꞌ uvoda ngeleꞌmize molo memeꞌ ize neꞌmini minilizave nene aꞌne hulamaaꞌ uvoda hulo-ngedelesuve. ");
INSERT INTO aso_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Neꞌmine ogo Guveꞌnesi ve mino naza aꞌne hulaaꞌ uvoda minilizavemuꞌ tiꞌ lo lo-ngemelesuve: Meꞌneho noꞌnohoꞌ ize-lingidive mate, alo. Naza gaꞌna hele nouvo lingine nosoꞌ niteꞌ nimaaꞌ ikeniꞌ ve. Idoꞌ naza nosomuꞌ nisavo lingine hepeꞌ noso ohizi nimaaꞌ ikeniꞌ ve. Idoꞌ venenga ve mino naza lengita okuvo lingine igi neleꞌmizi lamineꞌ igaꞌ aniꞌ ve. Idoꞌ geneganaꞌne nomivo lingine ma di ngili-nidaaꞌ aniꞌ ve. Idoꞌ initeꞌ gize dokuvo lingine igi nasahiliꞌ lamineꞌ i-nidi minaaꞌ aniꞌ ve. Idoꞌ nalaꞌ numunguꞌ huli-nidikevo nouvo lingine igi hizi eleꞌ i-nidaaꞌ aniꞌ ve. Neꞌmini i-nidi minaniꞌ nenako nemuꞌ nene Oꞌmosoꞌmo Okulumoꞌ misubo do sotoꞌ idotiꞌ nene lengiꞌ ebetine eiꞌ gizebo inguꞌ salani molo-lengede neineꞌ nene igi di minilo. ");
INSERT INTO aso_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Neꞌmine lo lo-ngemekuvo ingine tiꞌ li lilisave: Guvekasi ve make, laineꞌ initeꞌ nene geiꞌ o-gedamuneꞌ ve lo gele none. Nemuꞌ nene geiꞌ gaꞌna helane lo ningo nosoꞌ niteꞌ naniheꞌ do gimuningumuꞌ nolane. Idoꞌ gaza nosomuꞌ nisave lanivo gelo noso naniheꞌ ohizo gimuningumuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Idoꞌ gaza venenga ve nane lo ningo laza naniheꞌ geleꞌmize lamineꞌ uningumuꞌ nolane. Idoꞌ geneganaka nomivo ningo naniheꞌ ma do ngolo-giduningumuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Idoꞌ gaza initeꞌ gize danivo laza naniheꞌ ogo nasahiliꞌ o-giduningumuꞌ nolane. Idoꞌ gaza nalaꞌ numunguꞌ huli-gidikevo nanivo laza naniheꞌ ogo hize eleꞌ o-giduningumuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tiꞌ li longoꞌ i-nidikevo naza guveꞌnesi ve mino tiꞌ lo lo-ngemelesuve: Lingine eveneꞌne zuho ma nene o-ngidube li gilaniꞌza neꞌmine initeꞌ i-ngidaniꞌ nene neniꞌ i-nidaniꞌ gelave. Ee, neze eveneꞌne zuho minangutiꞌ lemo minivesi neꞌmine i-dikevo neniꞌ i-nidaniꞌ gelave. ");
INSERT INTO aso_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Idoꞌ neꞌmine lo aꞌne hulamaaꞌ uvoda minilizavemukisi tiꞌ lo lo-ngemelesuve: Lingine meꞌneho usiꞌ ize-lingidivete nouvodatiꞌ vi haha igi lihizami oloꞌ lovoꞌ lovoꞌ ogo neineꞌ nene meꞌneho do sotoꞌ ogo Satanisi eze angelole zuhosi aꞌminguꞌ vi hilalizave lo engikumuꞌ salani molo-ngidinguꞌ vi hilalo. ");
INSERT INTO aso_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ne Nanitekumuꞌ ve. Naza gaꞌna helo nouvo lingine nosoꞌ niteꞌ nimamaniꞌ ve. Idoꞌ nosomuꞌ nonisivo lingine noso ohizi nimamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Idoꞌ venenga ve mino lengita okuvo lingine neleꞌmizi lamineꞌ amaniꞌ ve. Idoꞌ geneganaꞌne nomivo lingine ma di ngili-nidamaniꞌ ve. Idoꞌ naza initeꞌ gize dokuvo idoꞌ nalaꞌ numunguꞌ huli-nidikevo nouvo lingine igi nasahiliꞌ i-nidamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Neꞌmine lokuvo ingine tiꞌ li longoꞌ i-nidilisave: Guvekasi ve make, gaza gaꞌna hele nanivo he nosomuꞌ gise neivo he idoꞌ venenga ve minanivo he geneganaka nomivo he idoꞌ initeꞌ gize do nanivo he idoꞌ nalaꞌ numunguꞌ nanivo naniheꞌ ningo nasahiliꞌ o-gedo geleꞌmize lamineꞌ amune. ");
INSERT INTO aso_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Neꞌmine likevo naza tiꞌ lo lo-ngemelesuve: Laminetoꞌ lo-lengemeloze. Lingine eveneꞌ ma neꞌmine i-ngidamaniꞌ neꞌmo neniꞌ i-nidamaniꞌ gelave. Ee, neze eveneꞌne zuho minangutiꞌ lemo minivesi neꞌmine i-damavo neniꞌ i-nidamaniꞌ gelave. ");
INSERT INTO aso_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Idoꞌ neꞌmine lo lo-ngemekuvo ingine vi mulumo ebekuꞌ vi mulumo gono diviꞌ diviꞌ igi nizavo apasi-ngidamilisave. Ingine neꞌmine ilisaha eveneꞌ lisiheꞌ lamineꞌ ingine eleꞌvoleꞌ ngemeni dameni dii minevoꞌ minevoꞌ ebekuꞌ vi hilalisave. ");
INSERT INTO aso_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Izesuꞌ aza aꞌmine gamazi lo-ngeme osuꞌ lo aꞌmine gameneloꞌ izipahala zuho tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Lingine mo gili nizaniꞌ ma neive. Isilaeleꞌ aleveti avotemote Aigita misubouꞌ minaniꞌ gameneuꞌ Oꞌmosoꞌmo isiꞌine izingumuꞌ gelo holiseꞌ mino nosoꞌ niteꞌ naaꞌ nouneꞌ gamene ma ne okozoꞌ apiꞌ oloseive. Neꞌmine ogo Oꞌmosolatiꞌ ve gihile neze nene biluvaliti aꞌninguꞌ mili-nidikevo lohotoꞌ zaloꞌ nibili hililisave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Idoꞌ aꞌmine gameneuꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ eveneliti monoꞌ gizebo veꞌinesi igi evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba gulive Kaiahaꞌ neꞌmi numuꞌve nabauꞌ igi di geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Di geseꞌ igi gamazi li gele ha gele igi mini Izesuꞌni nene zegeno bele helelone li lovo gizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Neꞌmine li lovo gizaniꞌza holiseꞌ gameneuꞌ nene eveneꞌ vaiꞌ di geseꞌ igi ningi nizavo analoꞌ daloneꞌ nene lovo di sotoꞌ ikelizanako holisekuꞌ nene alamolone li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Idoꞌ Izesuꞌ aza Betania numuda mino ganadise gozopoꞌ ma gize dave Simoniꞌ neꞌmi numuꞌveuꞌ neivo ");
INSERT INTO aso_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","minida nene veneꞌ maliꞌmo luhuvo laminekisi gehenidunuꞌ liliꞌ aniꞌ botoloꞌ nene unuvo uveli lamineꞌ meniꞌve nabasi nene aꞌminguꞌ neivo do ogo Izesuꞌ nosoꞌ niteꞌ nonavo godololoꞌ leke-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Idoꞌ Izesuꞌ izipahala zuho ingine ningi muluꞌninguꞌ goloso ogo ngizeboloꞌ molavo tiꞌ li laniꞌ: Unuvo lamineꞌ ogaꞌ ineꞌ uveli nene nanitekumuꞌ do labuluvo neive. ");
INSERT INTO aso_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aꞌmine unuvo lamineꞌ ogaꞌ ineꞌ uveli nene do vo hizilizave ngemekunivo hizi moni naba limikevo aꞌmine moni nene gohoꞌ aleve ngimunidine. ");
INSERT INTO aso_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tiꞌ li nilavo Izesuꞌ aza gamazi laniꞌ nene mo gelo tiꞌ lo lineꞌ: Veneꞌ mene aza naniteꞌ do goloso ogavosa geniꞌvesi gamazi nili-imave. Aza nene initeꞌ lamineꞌ noo-nidivo ede vive. ");
INSERT INTO aso_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lingine nene gohoꞌ alevesi mini di vi minikelizaha nezesi nene mudive ma mini di vi minamilisave. ");
INSERT INTO aso_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Veneꞌ aza aꞌmine unuvo lamineꞌ ogaꞌ ineꞌ uveli nene holo-nididiꞌmo galese izi-nidilizangumuꞌ gomuꞌ okoꞌne nene do lamineꞌ o-nedo holo-nedave. ");
INSERT INTO aso_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Naza laminetoꞌ lo-lengemeloze. Gililo. Monoꞌ gamazi lamineꞌ mene di misubouꞌ misubouꞌ moni li-ngimilizadaa eze guvele nene ha gili minilizave li aza initeꞌ o-nidineꞌ nemukisi li sotoꞌ igi li-ngimilizave. ");
INSERT INTO aso_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Neꞌmine ogavo Izesuꞌ izipahala zuho tuvelu engikutiꞌ Kelioto numudotiꞌ ve ma gulive Zudaꞌ aza evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabala vo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Aꞌmine ve ma nene naza do vo hulo vetinguꞌ okuvo naniteꞌ ma nimilizave. Lavo ingine siluvaꞌ moni teoti (30) neꞌmine imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Imikevo aꞌmine gamenelotiꞌ nene aza Izesuꞌni ngelebizeli akamuꞌ viseꞌ o minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Zuda vete lulu izamineꞌ beleti naaꞌ nouneꞌ holiseꞌ nene apiꞌ neivo Izesuꞌ izipahala zuho ezela igi tiꞌ li longoꞌ i-daniꞌ: Oꞌmosoꞌmo avotemotine iseꞌine ize-ngidingumuꞌ gelo naaꞌ nouneꞌ nosoꞌ niteꞌ naliningumuꞌ nene zala vo do vaꞌvaꞌ o-gedelone lo nolane. ");
INSERT INTO aso_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Likevo Izesuꞌ aza nongimiselo tiꞌ lo lo-ngimineꞌ: Numuno nabala vi aꞌmida lo-lingimuve ma neida vi ningi tiꞌ li li-imilo: Tisaꞌ maꞌmo neniꞌ gamene mo alitave lo aꞌmine Oꞌmosoꞌmo avotemotine iseꞌine ize-ngidingumuꞌ gelo mino naaꞌ nouneꞌ nosoꞌ niteꞌ nene geiꞌ numungauꞌ neniꞌ izipahaꞌnesi nalone nolive. ");
INSERT INTO aso_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lo-ngemavo izipahala zuho ingine lo-ngimidiꞌmine igi aꞌmine nosoꞌ niteꞌ di vaꞌvaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Di vaꞌvaꞌ ikevo mo nivengaꞌ molavo Izesuꞌ izipahala zuho tuvelu nesi mini nosoꞌ niteꞌ naniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aꞌmine nosoꞌ niteꞌ ni nizavo Izesuꞌ aza tiꞌ lo lineꞌ: Laminetoꞌ ma lo-lengemeloze. Gililo. Lengikutiꞌ maliꞌmo nenikumuꞌ me neive lo biluvaliti aꞌninguꞌ molaloseive. ");
INSERT INTO aso_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aꞌmine gamazi nene lingumuꞌ izipahala zuho mulumo goloso gili-di apiꞌ igi hamoꞌ hamoꞌ oti laniꞌ: Guvekasi ve, nenikumuꞌ lamo nolosane. Olo. ");
INSERT INTO aso_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lapeseuꞌ ana nenikisi hulo molave neꞌmo biluvaliti aꞌninguꞌ do hulo-nedeleseive. ");
INSERT INTO aso_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ee, Oꞌmosolatiꞌ ve gihile nenikumuꞌ polohetelite gizi nizaniꞌ maꞌmino heleloniꞌ akaloꞌ novuvoniꞌza biluvalite neniꞌ dalizave lo do sotoꞌ o-nedelive nene agae, mulumo gono atoliꞌmine daloseinako nemuꞌ aꞌmine ve aza izeleho ma gedamidiniko aꞌmine mulumo gono goloso sotoꞌ o-delesa neineꞌ akaloꞌ mine molo ma minamivo lamineꞌ o minidine. ");
INSERT INTO aso_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Neꞌmine lavo Zudaꞌ aza alingeꞌ biluvaliti aꞌninguꞌ eleꞌmize molaveꞌmo tiꞌ lo lineꞌ: Tisazo, nenikumuꞌ nene ma lamane. Olo. Lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Oꞌove. Gasika mo ne nolane lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nosoꞌ niteꞌ ninavo Izesuꞌ aza beleti do Oꞌmosola opoꞌni lo gito izipahala zuho nongemo tiꞌ lo lineꞌ: Di nalo. Mene neniꞌ meꞌmeleꞌne ma ne neive. ");
INSERT INTO aso_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Neꞌmine lavo di nikevo vaini gomise do Oꞌmosola opoꞌni lo nongemo tiꞌ lo lineꞌ: Aꞌminguꞌ nene Oꞌmosoꞌmo lo huko-lidineꞌ gamazi nene do eleꞌvoleꞌ ilineꞌ vaniseꞌne mene eveneꞌ mukikumuꞌ lihimetine apase-lengedelove lo lekeloniꞌ mene neinako nemuꞌ aꞌmingutiꞌ lingine mukitoꞌ nalo. ");
INSERT INTO aso_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Idoꞌ tiꞌ lo nolo-lingimuve. Idise melotiꞌ naza vaini gihileꞌmi novozoutiꞌ mo namo mino alingeꞌ Meꞌneho gizebo o-lengedelineꞌ gameneuꞌ nene aꞌmine novozo atoliꞌmine nene lengikisi mino nalosune. ");
INSERT INTO aso_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Neꞌmine lavo monoꞌ nama lisa limi heta igi Oliva gololoꞌ dizi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oliva gololoꞌ dizi nizavo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Monoꞌ Godolouꞌ Oꞌmosoꞌmo lineꞌ gamazi ma tiꞌ li gizi nizaniꞌ ma neive: Gizebo veꞌine belekuvo sipisipi ize mulise nene hutileꞌ igi vilisave. Tiꞌ li gizi nizaniꞌ nenako nemuꞌ idise holukaꞌ lingine mukitoꞌ nenikumuꞌ goloso giladiꞌmo huli-nidi vilisaniꞌza ");
INSERT INTO aso_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","helekuvo Oꞌmosoꞌmo neleꞌmize otavo gomuꞌ molo lengemo nGalilaia misubouko vo minelesuve. ");
INSERT INTO aso_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lavo Petoloꞌ aza tiꞌ lo lo-imineꞌ: Ingine mukiꞌ geikumuꞌ goloso gili huli-gidi vilizanikisi naza nene mo kekeꞌ hulo-gedo vamolosuve. ");
INSERT INTO aso_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Laminetoꞌ nolo-gimuve. Idise holukakisi okoloho nolo olihe molamivo gaza gamene setohamo ataize lo-nedelesane. ");
INSERT INTO aso_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lavo Petoloꞌ tiꞌ lo lo-imineꞌ: Oꞌove. Ge gibili hili nesi nibili hililisa lilizanikisi nene ataize lo-gedamolosuve. Lavo Izesuꞌ izipahala zuho mukitoꞌ Petoloꞌ lidiꞌmine igi hamoꞌ gamazivoꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Neꞌmine ogavo Izesuꞌ aza izipahala zuhosi ebeꞌ ma gulive Gesemani neuꞌ vaniꞌ. Vo hetelo izipahala zuho tiꞌ lo lo-ngimineꞌ: Naza holeloꞌ vo Oꞌmosola nololongumuꞌ lingine meloꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Idoꞌ neꞌmine lo Petolokisi idoꞌ Zebedaioꞌ gipele sitakisi nene ngeleꞌmizo novo Izesuꞌ aza apiꞌ ogo muluno hukavo mulumo naba gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gelo neꞌmine lo lo-ngimineꞌ: Naza mo muluꞌneuꞌ mulumo goloso ogo geni naba idiꞌmo heleloniꞌ akaloꞌ mine molokuve. Lingine makatoꞌ neniꞌ olodiꞌmine igi meloꞌ gizebo igi ningi minilo. ");
INSERT INTO aso_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Izesuꞌ aza neꞌmine lo ngomo ma hotoꞌile novo misuboloꞌ golo hizo Oꞌmosola nolo tiꞌ lo lineꞌ: Meꞌneho make, ha ilinidoꞌ neivo ma aꞌmine di sotoꞌ i-nidilisa naniꞌ ekeseꞌ initeꞌ nene nenita amilive lo do hulo-nedelinibo. Neꞌmine ha olosaineꞌza neniꞌ luꞌneloꞌ do molamo asi geiꞌ lukaloꞌ do molozo. ");
INSERT INTO aso_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Neꞌmine lo Izesuꞌ aza tineꞌ molo ogo ningineꞌ nene izipahala zuho okise ingi minaniꞌ nene ningo Petoloꞌni tiꞌ lo lo-dineꞌ: Nadive. Lingine amuzo milami neniꞌ uvodiꞌmine igi makatoꞌ gamene liꞌnibe ngomo vanu aua neꞌmine vetine ningi minamahe. ");
INSERT INTO aso_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lengemenguꞌ milalizanguꞌ nene gopo ikelizaze. Gizebo igi Oꞌmosola li minilo. Ee, lutine neꞌmo gono dalosa neiha okodine neꞌmo nene geni o neive. ");
INSERT INTO aso_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Neꞌmine lo iheꞌ gohi vo Oꞌmosola nolo tiꞌ lo lineꞌ: Meꞌneho make, geiꞌ gelanivo aꞌmine di sotoꞌ i-nidilisa naniꞌ ekeseꞌ initeꞌ nene hulo-nedelidoꞌ amivo geheloniꞌ o neivo ma geiꞌ lukaloꞌ do molo gehelesuve. ");
INSERT INTO aso_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Neꞌmine lo Izesuꞌ aza tineꞌ molo ogo ningineꞌ nene veꞌine hihiꞌ ogavo okise ingi nizavo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ningo iheꞌ hulo-ngedo vo Oꞌmosola lo gomuꞌ lineꞌ maꞌmine ogo lineꞌ. Neꞌmine ogo vo Oꞌmosola lineꞌ nene gamene sitohamo ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Neꞌmine ogo iheꞌ izipahala nizada ogo tiꞌ lo lo-ngimineꞌ: Okise ingi mine gililisa gili nizahe. Ningilo. Oꞌmosolatiꞌ ve gihile neniꞌ nene di sotoꞌ igi ve golosoliti aꞌninguꞌ milalizaniꞌ gamene mo ogaze. ");
INSERT INTO aso_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Otilo. Mo volonge. Ningilo. Biluvalite dalizave lo neze do sotoꞌ ilive nene mo avitoꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tiꞌ lo nolo-ngimivo izipahala zuho tuvelu engikutiꞌ nene ve gonoꞌnibo Zudaꞌ aza ogo hetelineꞌ. Idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ gizebo vesi mini eveneꞌ mukiꞌ ngimiselikevo bainati mitekisi gavososi dii Zudalesi makaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Idoꞌ olihe igi hetelami Izesuꞌni do sotoꞌ o-ngidive neꞌmo gomuꞌ tiꞌ lo lovo gize ngimineꞌ: Golo elo nalove nene aꞌmine ve mineleseize. Dalo. ");
INSERT INTO aso_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ogo hetelo Zudaꞌ aza Izesuꞌ neida liteꞌ lo o-duvo Tisazo, ne nabe lo golo elo naniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Neꞌmine ogavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Zogone, gaza ogo olosa aineꞌ initeꞌ nene aloꞌ ozo. Tiꞌ lo nolivo biluvalite ingine Izesuꞌ neida igi analoꞌ di minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Neꞌmine navo Izesulesi monaveutiꞌ ve maliꞌmo ana do patelo bainati miteꞌ gokutiꞌ geleleheꞌ ogo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nabaꞌmi gelekeleꞌ izipe ma belo gala hela hasaꞌ o hulineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hasaꞌ o hulavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Bainati miteka nene iheꞌ daninguko do molozo. Eveneꞌ malike bainati miteꞌ do lovo olosa ilinive nene ve malite bainati mitedunuꞌ gibilikevo helelesane. ");
INSERT INTO aso_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gaza gelaineꞌ meꞌnehida lokuvo alete mili-nidilizave ma ngimiselamilive lo gele nabe. Oꞌve. Lokuvo angeloꞌ mulise naba ato atoꞌ tuvelu adoꞌ angeloꞌ sevedi tu tauseni (72,000) neꞌmine ivileꞌ ogo ma ngimiselavo igi ha alete mili-nidilisave. ");
INSERT INTO aso_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Neꞌmino neiha neꞌmine oloniꞌ nene monoꞌ godolouꞌ nene aꞌneloꞌ di goniꞌ i-nidi nibili hililizave li gizi nizaniꞌ gamazi nene ngelo gihile izamilineꞌ nenako nemuꞌ nene alete mili-nidilizavemuꞌ lamolosuve. ");
INSERT INTO aso_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Idoꞌ aꞌmine gameneloꞌ Izesuꞌ aza eveneꞌ mulise tiꞌ lo lo-ngimineꞌ: Gizengize ve ma dalisa igaꞌ adiꞌmine igi bainati mitekisi gavososi di neniꞌ dalisa ahe. Naza gamene gamene monoꞌ numuno nabauꞌ monoꞌ apize ngemaaꞌ uvoniꞌ maloꞌ nene aꞌneloꞌ damaniꞌ nehe. ");
INSERT INTO aso_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gomuꞌ neꞌmine ami idise neꞌmine navo sotoꞌ neineꞌ nene Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ ave polohete nete gizi nizaniꞌ gamazi ma gihile izelive losa nene sotoꞌ neive. Neꞌmine lavo izipahala zuho Izesuꞌni huli-di mukitoꞌ golise vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Idoꞌ Izesuꞌ analoꞌ di minave ingine eleꞌmizi evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba Kaiahaꞌ neida vaniꞌ. Aꞌmida Zuda vete monoꞌ gozopotatiꞌ laaꞌ aniꞌ apizi ngimaaꞌ avesi idoꞌ Zuda veti gizebo veꞌine nesi mulise mili nizavo aꞌminguꞌ eleꞌmizi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Neꞌmine navo Petoloꞌ aza hotoꞌile eꞌmete-do ogo aꞌmine evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba neꞌmi gesi minguꞌ ogo dizi minaniꞌ numuno nene vodo vodo ogo minavo olusoꞌ omoꞌ naba minidoꞌ nene dizo Izesuꞌni goniꞌ i-di nadiꞌ i-dilizahe lo ningelesa pilisi vesi makatoꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Neꞌmino neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi engiꞌ kanisoleꞌine mukikisi nani lihimemuꞌ Izesuꞌni belelone li soza saza li lihimeꞌve li sotoꞌ ilizavemuꞌ viseꞌ ikevo ");
INSERT INTO aso_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","eveneꞌ mukiꞌ eze lihime ma li sotoꞌ ilisa igi soza saza gamazi laniꞌza ingine giladoꞌ vo dalineꞌ gamazi ma lamavo eze lihime li sotoꞌ ilizave ma di sotoꞌ amaniꞌ. Di sotoꞌ ami viseꞌ iꞌmi vi nizavo alingeꞌ nene ve sitaꞌ ma igi tiꞌ li lasineꞌ: ");
INSERT INTO aso_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Me veꞌmo naꞌniseꞌne Oꞌmosoꞌmi monoꞌ numuno naba nene nguꞌvoso gamene sitohamo ogo novivo iheꞌ gizelesuve lo live lasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Neꞌmine likesivo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba aza oto tiꞌ lo lineꞌ: Gaza nilasineꞌ gamaziloꞌ mene do velepeꞌ izo lo-ngemelineꞌ gamazi ne nomihe. Mene ve netise geikumuꞌ nilasineꞌ gamazi mene gelanivo nadiꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Neꞌmine lineꞌza Izesuꞌ aza gamazi lamo minineꞌ. Neivo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba aza tiꞌ lo lineꞌ: Idiꞌnise minevoꞌ minevoꞌ ogo minaaꞌ ive Oꞌmosoꞌmi veleloꞌ lo sotoꞌ ogo liline lo noluve. Oꞌmosoꞌmi gipele Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live nabe lo lemezo. ");
INSERT INTO aso_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Mo ne laineꞌza lo-lengemeloze. Gililo. Oꞌmosolatiꞌ ve gihile naza amuzoꞌvesi minive Oꞌmosolotiꞌ lemo nouvoniꞌ nenako nemuꞌ ana hulaaꞌ ida mitoꞌ nouvo ningilisave. Idoꞌ Okulumotoꞌ limuso avileloꞌ nolimuvo ningilisave. ");
INSERT INTO aso_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Neꞌmine lavo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba neꞌmo Izesuꞌ aza Oꞌmoso ivileꞌ olosa gamazi goloso lihe lo gala gilineꞌ nene ngelebizelesa asiꞌve ngolokineꞌ geneganaꞌve nene do nohikelo tiꞌ lo lineꞌ: Asiꞌve Oꞌmoso ivileꞌ olosa gamazi goloso laanako nemuꞌ lihimeꞌve li sotoꞌ ilizavemuꞌ nene nanimuꞌ gohi viseꞌ olone. Oꞌmoso ivileꞌ o-do gamazi goloso lineꞌ nene langisetine mo gilikeve. ");
INSERT INTO aso_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nemuꞌ lingine gilikevo nadiꞌ o neive. Lavo ingine tiꞌ li li-imaniꞌ: Aza nene mo lihime naba danako mo helelidoꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Neꞌmine li golo veleuꞌ gituhoꞌ i-di aꞌinedunuꞌ bilii aꞌine gatapaꞌ gavoso bilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Neꞌmine igi nibili tiꞌ li laniꞌ: Geiꞌ neke Oꞌmosoꞌmo eveneꞌ do nguꞌ izeline lo gimiselelesa live nouve nolabe. Olo. Ne ma nigibilaze. Geze monovoka ningelone. Zaho gibilihe. Gaza polohetelite laaꞌ adiꞌmine ogo lo sotoꞌ ogo lo-lemevo. ");
INSERT INTO aso_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Neꞌmine igi nizavo Petoloꞌ aza numuno vodo vodo minavo olusoꞌ omoꞌ naba minidoꞌ neivo gelekeleꞌ alu maliꞌmo eita ogo tiꞌ lo lineꞌ: Gaza nene nGalilaia misubotiꞌ ve Izesukisi monaaꞌ asive ma ne nolosane. ");
INSERT INTO aso_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lavo aza eveneꞌ mukiliti veꞌnidoꞌ ataize lo nolaineꞌ gamazi ne ma gelamuvongumuꞌ nolane lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Neꞌmine lo gesi gateda lemo novivo gelekeleꞌ alu gohi maliꞌmo ningeko eveneꞌ aꞌmida minave lo-ngimineꞌ: Me ve nene Nasalete numudatiꞌ Izesulesi monaaꞌ ave ma ne neive. ");
INSERT INTO aso_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Lavo gohi ataize lo lineꞌ: Oꞌmosoꞌmi veleloꞌ aꞌne dizo noluve. Mo ningamuvemuꞌ nilave. ");
INSERT INTO aso_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","nGomo lasolo ma nimini aꞌmida minave nete Petoloꞌ neida igi tiꞌ li li-imaniꞌ: Engiꞌ gamazi laaꞌ adiꞌmino nolainako nemuꞌ mo laminetoꞌ aꞌmine zuhoutiꞌ nolosane. Gaza gamazi nolaineꞌ neꞌmo do sotoꞌ o-gedave. ");
INSERT INTO aso_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Likevo aza gosohoꞌ noluvo ma Oꞌmosoꞌmo usiꞌ ize-nidivo lo mo laminetoꞌ noluve lineꞌ. Oꞌmosoꞌmi veleloꞌ lo huko noluve lo tiꞌ lo lineꞌ: Ningamuvemuꞌ nilave. Petoloꞌ neꞌmine nolivo okoloho liteꞌ lo nolo molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Idoꞌ okoloho nolo molavo Petoloꞌ aza Izesuꞌ okolohoꞌmo olihe nolo gedamivo nenikumuꞌ gamene sitohamo ataize lo-nedelesane lineꞌ gamazi nene gohi gala gelo heta lemo vo ive nabaloꞌ goloso ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nedengaꞌ goꞌ nolivo evenetoꞌ medeli Oꞌmoso initeꞌ lehizi-daaꞌ ave naba mukiꞌ idoꞌ Zuda veti gizebo veꞌine nesi ingine mulise mili Izesuꞌni bili hililizangumuꞌ gamazi li li voleloꞌ meloꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Li mini analoꞌ nalaꞌ di eleꞌmizi vi Zuda veti misubola Loma vete di sotoꞌ milaniꞌ ngamaniloꞌ gizebo o minineꞌ guvelesi ve Pilatoꞌ neida eleꞌmizi vi eiꞌ anauꞌ milaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Vikevo Zudaꞌ aza Izesuꞌni hulo biluvaliti aꞌninguꞌ iveꞌmo Izesuꞌni goniꞌ i-di helelive laniꞌ nene ningo gelo muluno do velepeꞌ izo aꞌmine siluvaꞌ moni teoti (30) nene iheꞌ do vo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ Zuda veti gizebo veꞌinesi do tineꞌ molo nongemo ");
INSERT INTO aso_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","tiꞌ lo lineꞌ: Naza lihime do ve lamineꞌ lihimeꞌve nomineꞌ mene hulo biluvaliti adinguꞌ okuvo bili hililisa naze. Lavo ingine olo. Lihime dabe. Neve ne leliꞌ gono nomive. Geiꞌ gonoka ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Likevo Zudaꞌ aza aꞌmine siluvaꞌ moni nene monoꞌ numunguꞌ hulo molo monoꞌ numungutiꞌ lemo vineꞌ. Lemo vosa vo nalaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Neꞌmine ogavo ingine evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba aꞌmine moni di neꞌmine laniꞌ: Mene moni nene eveneꞌ ma bele helelone lo huluneꞌ nenako nemuꞌ neꞌmi lihime aꞌmidoꞌ neinako nemuꞌ Oꞌmosoꞌmi gonomuꞌ hulaniꞌ monisi do hamoꞌ ogo molalonidoꞌ nomive. ");
INSERT INTO aso_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Neꞌmine li aꞌmine monimuꞌ gamazi li voleloꞌ meloꞌ igisa misubo somo loloꞌ ogaꞌ iveꞌmi misuboꞌve ma hetatiꞌ ve ma aꞌmida hililiza aleve galese izilizaniꞌ ebeꞌ meni hizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Meni hizi aꞌmine misubo nene eveneꞌ ma bele helo vaniseꞌve leke-delone li hulaniꞌ monidunuꞌ meni hizanako nemuꞌ nene aꞌmine misubo nene vanise misubo ve li milaniꞌ. Neꞌmine li milikevo idisesi nene vanise misubo ve lo ha laaꞌ none. ");
INSERT INTO aso_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Neꞌmine ikevo Oꞌmosoꞌmi veletiꞌ gamazi lo sotoꞌ ogaꞌ ive gozopoꞌ ma minive Zelemiaꞌ aza gamazi monoꞌ godolouꞌ gizekineꞌ ma nene gihile izineꞌ. Tiꞌ lo gize neive: Aꞌmine siluvaꞌ moni teoti (30) nene Isilaeleꞌ aleve malite aꞌmine dize minivemuꞌ eiꞌ okoꞌnoloꞌ meni hizilizangumuꞌ eiꞌ meniꞌve ve laniꞌ moni nene di ");
INSERT INTO aso_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Guvelesi veꞌmo lo-nimidoꞌ aꞌmine monitunuꞌ nene misubo somo loloꞌ ogaꞌ iveꞌmi misubo ma meni hizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Idoꞌ Izesuꞌni eleꞌmizi vi ngamaniloꞌ gizebo ve nabaꞌmi veleloꞌ di vi oti-daniꞌ. Oti-dikevo ve naba neꞌmo longoꞌ o-do tiꞌ lineꞌ: Gaza nene Zuda veti guveꞌinesi ve naba nabe. Olo. Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Mo gasika nene nolaineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Idoꞌ ingine evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi evenelite gizebo veꞌinesi initeꞌ mukikumuꞌ goniꞌ i-daniꞌza aza gamazi hamokisi mo lo-ngemamineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Neꞌmine ogavo Pilatoꞌ aza tiꞌ lo lo-imineꞌ: Gamazi ma lo-ngemamaineꞌ nenako gamazi mukiꞌ geitoꞌ li mili nilaniꞌ nene mo gelabe gelamane ");
INSERT INTO aso_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Neꞌmine lineꞌza aza gamazi hamokisi aꞌmidoꞌ mo lo-emamineꞌ. Gamazi lo-emamivo ngamaniloꞌ gizebo ve Pilatoꞌ aza gala mukiꞌ goloso gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Idoꞌ kilisimasiloꞌ kilisimasiloꞌ Oꞌmosoꞌmo Zuda veti avotemotine iseꞌine izingumuꞌ geloo holiseꞌ minaaꞌ uneꞌ gameneloꞌ gameneloꞌ nene evenelite galapuso ve mukiꞌ minangutiꞌ nene hamoꞌ ma heta vilive li gulive ikevo ngamaniloꞌ gizebo ve naba neꞌmo aꞌmine ve nene nalaꞌ numungutiꞌ hulo heta o-ngedaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aꞌmine Izesuꞌni goniꞌ i-daniꞌ gameneloꞌ nene Izesuꞌ abalaho ma gizengize ve ma guvele buu lo monive gulive gohi ma Balabasiꞌ aza nalaꞌ numunguꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Neivo eveneꞌ mulise milikevo Pilatoꞌ aza tiꞌ lo longoꞌ o-ngidineꞌ: Lingine gilikevo zahine iseve izo hulo lengita olove. Izesuꞌ eveneꞌ do nguꞌ izelive alosa neive lave ma nehe abalaho Balabasiꞌ ma neve. ");
INSERT INTO aso_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Idoꞌ Pilatoꞌ neꞌmine lo longoꞌ o-ngidineꞌ nene nanitekumuꞌ ve. Eveneꞌ vaiꞌ Izesuꞌni eꞌmetaniꞌ nenako nemuꞌ nene ingine ezemuꞌ muluꞌninguꞌ goloso gilaniꞌ nemukovoꞌ nene nezela gonitoꞌ eleꞌmizi milikeve lo gilineꞌ nemuꞌ longoꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Idoꞌ Pilatoꞌ aza zasite minaaꞌ aniꞌ holomoloꞌ mino Izesuꞌ goniꞌve nogilivo elenaho gamazi eita hulo molo lineꞌ: Gaza ne mo aꞌmine ve lamineꞌ lisiheꞌ ogo neiveꞌmi okoꞌnola mo gamazi lo molamilineꞌ o neive. Holukaꞌ eikumuꞌ vamuꞌ ma ninge emo mulumo naba goloso nogele-duve lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pilatoꞌ aza zahine apase lengemelove lo longoꞌ o-ngedavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ gizebo veꞌinesi ingine muluꞌninguꞌ hizikevo evenelite Balabasiꞌni nene apase-ledo Izesuꞌni bele helelesane li li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Li-imikevo ve nabaꞌmo gohi longoꞌ o-ngedo lineꞌ: Aꞌmine ve sitakutiꞌ mene zahine apase hulo-lengedekuvo lengita vilive. Lavo ingine Balabasiꞌ ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Likevo Pilatoꞌ tiꞌ lo lo-ngimineꞌ: Idoꞌ eveneꞌ Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ve lave Izesuꞌni mene nadiꞌ o-delove. Lavo eveneꞌ mukilite tiꞌ li laniꞌ: Gaza lanivo lohotoꞌ zaloꞌ bili hililizave. ");
INSERT INTO aso_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Likevo aza lo-ngimineꞌ: Nanitekumuꞌ lohotoꞌ zaloꞌ bele helelone. Initeꞌ goloso ineꞌ nene naniteꞌ nolive. Tiꞌ lo lo-ngimineꞌza ingine amuzo mili lohotoꞌ zaloꞌ beleꞌ navo li gohi geligelinga laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Likevo Pilatoꞌ aza gamazi lineꞌ mo ana damivo aꞌminguꞌ lovo naba mo sotoꞌ ilineꞌ ogavo nene ningo lihime ezela minamilive lo ngelebizelesa noso ma do eveneliti veꞌnidoꞌ ana nosoꞌ noizo tiꞌ lo lo-ngimineꞌ: Mene lengiꞌ initetine ve. Lingine lihimeꞌve nomive lisiheꞌ lamineꞌ mene bililizaha nenita eiꞌ lihime minamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Neꞌmine lavo eveneꞌ mukitoꞌ laniꞌ: Bele heleloneꞌ nene aꞌmine lihime lelitasi mino leze zuho alingeꞌ sotoꞌ ilizavelasi havoꞌ mine do vo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Neꞌmine likevo Pilatoꞌ aza Balabasiꞌni hulo heta o-davo engita vineꞌ. Neꞌmine ogo Pilatoꞌ aza lavo ngibilaaꞌ aniꞌ gavosodunuꞌ Izesuꞌni mehene iziviꞌ lediviꞌ igi bilikevo di vi lohotoꞌ zaloꞌ bililizave lo Loma veti ami pilisi ve neti aꞌninguꞌ molaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aꞌninguꞌ molavo aꞌmine ngamaniloꞌ gizebo ve nabaꞌmi ami pilisi velite Izesuꞌni eleꞌmizi ngamani numuno nabaꞌmi lulouꞌ dizi vi aꞌminguꞌ minaniꞌ ami pilisi ve linge mamuꞌ vise likevo mukitoꞌ Izesuꞌ veleloꞌ di geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Neꞌmine igi aꞌmine ngolokineꞌ genegana ne di huli-di guveꞌinesi ve naba nete ngilaaꞌ aniꞌ neꞌmine gele minelive li lehokoꞌ neꞌmine guleheꞌ lavolavo di ngili-di ");
INSERT INTO aso_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","uhoni nalaꞌ di gangi guveꞌinesi ve nabalite maduꞌnidoꞌ gihaaꞌ aniꞌ initeꞌ neꞌmine apa niteꞌ igi liliꞌ igi madunoloꞌ gihi-di ana zamela angaba gavoso neꞌmine imaniꞌ. Imi velela obuvoꞌine hizi imi Zuda veti guveꞌinesi ve ma gopoꞌni nolo-gimune li golo izi gize zohiꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gize zohiꞌ i-di gituhoꞌ i-di aꞌmine angaba gavoso imikadunuꞌ godololoꞌ bili minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Neꞌmini golo izaniꞌ ne osuꞌ lavo genegana di ngili-daniꞌ nene apasi di huli-di eiꞌ okoꞌnoloꞌ initeꞌve nene gohi di izi-di lohotoꞌ zaloꞌ bililisa eleꞌmizi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eleꞌmizi vi numuno ebeꞌ nihuli Kilene ebekutiꞌ ve ma gulive Simoniꞌni nene ningi Izesuꞌ lohotoꞌ zaꞌveloꞌ gehe-delive li amuzonga li-imikevo gihineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gehavo vi ebeꞌ ma minineꞌ gulive Goligota nene leliꞌ gamazikotiꞌ godolo amuzo ebeꞌ nela vi hetelaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vi heteli vaini noso aꞌminguꞌ mulumo mate-ngedaaꞌ initeꞌ ekeseꞌ ineꞌ nene di gopo ikeniꞌ nene nalive li imaniꞌza ngomo no geleko namolosuve lo oꞌove lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Neꞌmine ogavo lohotoꞌ zaloꞌ bili giliꞌ li di oti badaniꞌ. Di oti badi geneganaꞌve izeꞌ mili dalisa zohiꞌ igi geheni mulo ngomo ma hulikaꞌ hulikaꞌ ikevo ngivileꞌ ogo huliveꞌmo dokaꞌ dokaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Neꞌmine igi aꞌmida mini gizebo i-di minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Idoꞌ lohotoꞌ zaloꞌ bilisa goniꞌ i-daniꞌ lihime ne li sotoꞌ igi me ve Izesuꞌ nene Zuda veti guveꞌinesi ve ve li luhuvo gizi godolo veletoꞌ nene di badaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Idoꞌ gizengize ve sitaꞌ ezesi makaꞌ lohotoꞌ zaloꞌ ngibili ma ne ana zamela di oti-di ma ne ana adavala di oti-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Neꞌmine ikevo eveneꞌ igi vigi ave nete ungumuꞌ izi diviꞌ ledevika li-di ");
INSERT INTO aso_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tiꞌ li laniꞌ: Monoꞌ numuno naba izo kuso hulo gamene sitohamo novivo gohi gizelove laaꞌ anive gaza Oꞌmosoꞌmi gipele noo ma geiꞌ okonga nene do guꞌ izo lohotoꞌ zalotiꞌ apaso lemevo. ");
INSERT INTO aso_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nilavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ apizi ngimaaꞌ avesi monoꞌ gizebo veꞌinesi ingine aꞌmine aꞌmine igi gizeꞌ i-di li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Aza eveneꞌ linge ma nene do nguꞌ izive laniꞌza eiꞌ okoꞌno nene ngelo do uꞌ izamilineꞌ ogave. Isilaeleꞌ aleveti guvetesi ve naba ma ne ngelo minelihe. Lohotoꞌ zalotiꞌ lemo ano lovo. Lemavo eitoꞌ gele eleꞌvoleꞌ olone. ");
INSERT INTO aso_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Oꞌmosoloꞌ gele medele mino Oꞌmosoꞌmi gipele nouve laaꞌ neineꞌ nenako nemuꞌ nene Oꞌmosoꞌmo ezemuꞌ umo helavo ma aloꞌ do uꞌ izezo lovo. ");
INSERT INTO aso_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Likevo gizengize ve sitaꞌ lohotoꞌ zaloꞌ makaꞌ ngibilavesi aꞌmine aꞌmine igi gamazi goloso li-dasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Idoꞌ holiseꞌ tuvelu (12) kilokulotiꞌ ebeꞌ mukikuꞌ nene litiꞌmuso ize geseꞌ ogo mine do vo tili (3) kiloku nivengaꞌ ogavo gohi labanaꞌ ilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Idoꞌ tili kiloku neꞌmidoꞌ nene Izesuꞌ aza amuzo molo asi naba lo tiꞌ lo lineꞌ: Eli, Eli lema sabahatani. Leliꞌ gamazikotiꞌ nene neꞌmi monovo neꞌmino neive: Oꞌmosoo Oꞌmosoꞌne make, nanitekumuꞌ hulo-nedane. ");
INSERT INTO aso_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lavo eze minineꞌ gahevela minave linge ma nete nene gili tiꞌ li laniꞌ: Polohete Eliaꞌnimuꞌ asi nolive. ");
INSERT INTO aso_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Likevo ve maliꞌmo aꞌmidoꞌ geto lotiꞌ izo vo nosouꞌ lupizisa lipi naaꞌ aniꞌ initeꞌ ma do ekeseꞌ ogaꞌ ineꞌ vaini noso mauꞌ lupizo vaiꞌ lavo vilikiꞌ vilikiꞌ lo nalive lo ngongoꞌnoloꞌ izo imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Emavo eveneꞌ malite tiꞌ li laniꞌ: Eliaꞌ lemo do uꞌ izelihe ninge minelone. ");
INSERT INTO aso_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Likevo Izesuꞌ aza gohi asi naba nolo Sikalahuꞌve nohulo hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nohilivo monoꞌ numuno nabauꞌ izi hukikaniꞌ lavolavo nene veletatiꞌ galaꞌmuda limivo izo hoꞌlo sitaꞌ neivo misubo mimiꞌ noogo meni naba lemo geheni naba nene iziviꞌ hoꞌliviꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Neꞌmine neivo gonoso galese ma nene ngoloꞌ laniꞌ nene Oꞌmosoꞌmi evenele zuho gozopoꞌ hili minangutiꞌ mukiꞌ ma oti geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Oti geseꞌ ikevo alingeꞌ Izesuꞌ hilingutiꞌ otavo aꞌmine gomuꞌ hilave gonoso galese huli Zelusalemi numuda vi eveneꞌ mukiꞌ sotoꞌ pizi ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Idoꞌ aꞌmine mimiꞌ ogavo ami pilisi veti gizebo veꞌinesi idoꞌ aꞌmida ami pilisi ve Izesuꞌnimuꞌ gizebo minavesi mimiꞌ ineꞌ nene niningi aꞌmida initeꞌ ineꞌ nene ningi ngehelele goloso izavo tiꞌ li laniꞌ: Laminetoꞌ me ve nene mo Oꞌmosoꞌmi gipele gihile minaniꞌ neive laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Idoꞌ veneꞌ mukiꞌ nGalilaia misubokotiꞌ Izesuꞌni eꞌmeti vi nasahiliꞌ idiꞌmi vaniꞌ nete hota gidini mini ningi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aꞌmine veneꞌ mukiꞌ minanguꞌ nene Mangadala numudotiꞌ Maliaꞌ nene minineꞌ idoꞌ Maliaꞌ abalaho Zakobongi Zosehengi izeꞌnibosi idoꞌ Zebedaioꞌ gipele zuhoti izeꞌnibosi nene minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nivengaꞌ molavo Alimataia ebetatiꞌ heneni ve ma gulive Zoseheꞌ nene aza Izesuꞌni eꞌmetaaꞌ ive nene aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aza Pilatoꞌ neida vo Izesuꞌ okoꞌnomuꞌ longoꞌ ineꞌ. Longoꞌ ogavo Pilatoꞌ aza Zoseheꞌni di imilizave lo ami pilisi ve lo-ngedavo ");
INSERT INTO aso_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","gonoso nene Zoseheꞌni mo imikevo aza do lavolavo mokonoꞌ laminekuꞌ do molo asese ize-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ize-do asiꞌve Zoseheꞌ lavo eiꞌ gonoso galeseꞌve gosohoꞌ gehenguꞌ ma goloꞌvati-mikanguꞌ nene do vo molo-do aꞌmine gonoso galese veleloꞌ nene geheni naba ma do veleheꞌ molo do tileko vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Neꞌmine neivo Maliaꞌ Mangadala numudotiꞌ nesi Maliaꞌ ma nesi aꞌmine gonoso galese gahevela nene mini ningi minasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Idoꞌ aizeꞌ holiseꞌ gamene ve li aꞌmine gamenemuꞌ nene nosoꞌ niteꞌ di vaꞌvaꞌ igaꞌ aniꞌ gamene vavo gamene maloꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ Halisaioꞌ monoꞌ laaꞌ avesi vi Pilatoꞌ neidaa di geseꞌ igi ");
INSERT INTO aso_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tiꞌ li laniꞌ: Guvekasi ve, velesi ha mino aꞌmine Oꞌmosoꞌmo eveneꞌ do nguꞌ izeline lo nimiselelesa live nouve lo gote izaaꞌ iveꞌmo helo gamene sitohamo mino gohi otelesuve lineꞌ nene ha gele none. ");
INSERT INTO aso_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nemuꞌ nene izipahala zuhote igi aꞌmine gonoso nene gumine di vi gonoso galesetiꞌ mo otave li eveneꞌ li-ngimikevo gomuꞌ gote izo Oꞌmosoꞌmo nimiselelesa live nouve lineꞌ gamazi nene ivileꞌ ogo ingine alingeꞌ soza lilizaniꞌ neꞌmo eveneꞌ ngeleꞌmize gopo ogalive. Nemuꞌ nene lo-ngemanivo ami pilisi vete vi aꞌmine gonoso galeseloꞌ gamene sitohamo mini gizebo lamineꞌ ilizave losa nolune. ");
INSERT INTO aso_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Neꞌmine likevo Pilatoꞌ aza tiꞌ lo lo-ngimineꞌ: Tiꞌ li ma aꞌmida gizebo ilizave ami pilisi ve neꞌmine ma di aꞌmida huli-ngidi lingine aꞌmine gonoso galesetiꞌ nene gonoso gumine di vikelizave li akaꞌine hizi tililizaniꞌ aka ma gili nii ma ha hizi tililisave. ");
INSERT INTO aso_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Idoꞌ neꞌmine lavo vi gonoso galese veleloꞌ hizi tilaniꞌ gehedoꞌ nalaꞌ di giliꞌ li humo izi aꞌmidoꞌ kekeize luhuvo bili giꞌmizi aꞌmidoꞌ gizebo minilizave li ami pilisi ve huli-ngidaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aꞌmine Zuda vete mine gelo minaaꞌ uneꞌ holisete Salele nene ogo vavo Sadeuꞌ goꞌ lolosa neivo Maliaꞌ Mangadala numudatiꞌ nesi idoꞌ Maliaꞌ ma nesi aꞌmine gonoso galese nene vi ningilisa vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Idoꞌ nivasivo aꞌmine gonoso galesela mimiꞌ naba goloso ineꞌ. Neivo Guvelesi veꞌmi angeloꞌ ma lemo ogo aꞌmine gonoso galeseloꞌ geheni naba nene ehusoꞌ ogo do hulo aꞌmidoꞌ mitoꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aꞌmida nene gopaꞌna gopaꞌna ogaꞌ ineꞌ neꞌmine labanalasi neivo geneganaꞌvelotiꞌ nene mokonoꞌ goloso elo silingengeꞌni hulo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aꞌmine angeloꞌ ningadiꞌmo ami pilisi ve ingine ngehelele goloso izo luvoluvo goloso izi amuzoꞌine guluꞌ gelavo hilave neꞌmine igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Neꞌmine ikevo angeloꞌ aza veneꞌ sitaꞌ tiꞌ lo lo-ngimineꞌ: Lengehelele izamivo. Lingine nene Izesuꞌ lohotoꞌ zaloꞌ bili hilavemuꞌ viseꞌ nasineꞌ nene gele nouvoniꞌza ");
INSERT INTO aso_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","aza nene meuꞌ nomive. Mili-danguꞌ me igi ningilizo. Gomuꞌ lo-lingimineꞌ maꞌmino aza mo oto vave. ");
INSERT INTO aso_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nemuꞌ nene liteꞌ li vi eiꞌ izipahala zuho nene tiꞌ li li-ngimilizo: Hilineꞌ matiꞌ mo oto lengiꞌ lingivileꞌ ogo nGalilaia misubola ganaꞌ vo hetelo neivo aꞌmida ningilisave li li-ngimilizo. Mo aꞌne lo-lengeme nouve. ");
INSERT INTO aso_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lavo ngehelele izineꞌza ngolize goloso izi aꞌmidatiꞌ liteꞌ mateꞌ li Izesuꞌ izipahala zuho li-ngimilisa lotiꞌ izi vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Idoꞌ Izesuꞌ aza veneꞌ sitaꞌ nene akaloꞌ nivasivo voteneꞌ ogo ne nasihe lavo ingine veneꞌ sitaꞌ igi osoꞌmolo izi-di opoꞌni lasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Neꞌmine ikesivo Izesuꞌ aza lo-ngimineꞌ: Lengehelele izamivo. Vi neze zuho nGalilaia misubola vi aꞌmida neze ningilisave li vi li-ngidilizo. ");
INSERT INTO aso_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Apiꞌ igi nivasivo ami pilisi ve gonoso galeseloꞌ gizebo minave ingine Zelusalemi numuda vi evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nene aꞌmine initeꞌ sotoꞌ ingumuꞌ nene li-ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Idoꞌ aꞌmine evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nesi idoꞌ monoꞌ gizebo ve nesi mulise mili gamazi li voleloꞌ meloꞌ igi ami pilisi ve moni ningimi tiꞌ li laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Evenelite hilingutiꞌ mo otave li gilikelizave. Neꞌmine li-ngimilo: Okise ongo noningumuꞌ izipahala zuhote igi gonoso ma gumine di vikeve li li-ngimilo. ");
INSERT INTO aso_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Idoꞌ guvetinesi ve ngamaniloꞌ gizebo ve naba neꞌmo aꞌmine gamazi gelelineꞌ nene gono dami okise ingangumuꞌ goniꞌ o-lengedo lihime lengemalive lo gamazitunuꞌ mulunouꞌ hizekunivo isetine izavo linginela gamazi ma minamoloseive. ");
INSERT INTO aso_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Likevo aꞌmine moni di li-ngimaniꞌ neꞌmine igi ami pilisi ve nete Izesuꞌ izipahala zuho igi gonoso gumine di vikeve likevo aꞌmine laniꞌ gamazi nene Zuda vetida buu lavo idisesi ha gili nizave. ");
INSERT INTO aso_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Idoꞌ Izesuꞌ izipahala zuho leveni (11) nene nGalilaia misubouko vi Izesuꞌ lo-ngimineꞌ golo ma minida vi ");
INSERT INTO aso_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Izesuꞌni ninganiꞌ. Idoꞌ eze ningave nete gubiꞌ izi imi opoꞌni laniꞌza linge ma nete hele neingutiꞌ ngelo alihe li gaꞌine sitaꞌ gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Neꞌmine ikevo Izesuꞌ aza izipahala zuho nizada ogo tiꞌ lo lo-ngimineꞌ: Okulumokuko minavesi idoꞌ misubouko minavesi ingine mukiꞌ neze nene gelekeleꞌ i-nidi minilizave lo Oꞌmosoꞌmo amuzo mo neme neineꞌ ma ne neive. ");
INSERT INTO aso_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nemuꞌ nene misubouꞌ misubouꞌ moni eveneꞌ zuho ato atoꞌ mukiꞌ nene neniꞌ eveneꞌne zuho liliꞌ igi neꞌmetilizave li muluꞌninguꞌ hizi Meꞌneho idoꞌ gipele neniꞌ idoꞌ Sikalahuꞌve lamineꞌ nesi leliꞌ guliveteloꞌ noso mili-ngidi monoꞌ noso hili-ngidilo. ");
INSERT INTO aso_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hili-ngidi naza neꞌmine igi, igi mili minilo lo lo-lingimuvoniꞌ initekumuꞌ li-ngimi inginesi aꞌmine sunovoꞌ igi mili minilizaniꞌ aka nene ngelebizi apizi ngimilo. Neꞌmine igi nizavo naza nene hize eleꞌ o-lengedo linginesi gamene gamene havoꞌ mine do vo me misubouꞌ minilizaniꞌ gamene osuꞌ lavo gamene naba alidoꞌ nesi nene lengikisi ha minelesune lo lo-ngimineꞌ. Moda ve ");
INSERT INTO aso_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Oꞌmosoꞌmi gipele Izesuꞌ Kilisitoꞌ ezemuꞌ gamazi lamineꞌ nene ganaꞌ apiꞌ ogo sotoꞌ ineꞌ ma tiꞌ lo neive: ");
INSERT INTO aso_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Oꞌmosoꞌmi gamazi lo sotoꞌ o-ngemaaꞌ ive polohete ma gulive Isaiaꞌ aza luhuvo ma gizinguꞌ Oꞌmosoꞌmo guvelesi vemuꞌ gamazi lo-imineꞌ nene tiꞌ lo gize neive: Gelezo. Naza neze gamazi lo-ngeme ngemeꞌ ilive imiselekuvo aza do gomuꞌ molo akaka vele-gedeleseive. ");
INSERT INTO aso_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ebeꞌ hadivelatiꞌ ve maliꞌmo asi naba ma tiꞌ lo nolive: Guvelesi ve alingumuꞌ ve li akaꞌve di vaꞌvaꞌ igi di lisiheꞌ i-dilo. ");
INSERT INTO aso_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aꞌmine neꞌmine lidoꞌ eꞌmeto eveneꞌ monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ aza misubo hadiveuꞌ vo sotoꞌ ogo eveneꞌ tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo lengiꞌ lihimetine hulo-lengedelingumuꞌ ve li lutine di velepeꞌ izi monoꞌ noso hilalo lo lo-ngeme ngemeꞌ ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Minavo Zudaia misubokotikisi Zelusalemi numungutikisi eveneꞌ mukiꞌ ezela vi heteli lihimeꞌine li sotoꞌ ikevo Zodani nosouꞌ noso holo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zohaneꞌ aza kamela ize zopovodunuꞌ liliꞌ aniꞌ geneganaꞌve izo ize losuvodunuꞌ liliꞌ aniꞌ leti ma gopololoꞌ izineꞌ. Idoꞌ nosoꞌ niteꞌve naaꞌ ineꞌ nene maꞌnabuso idoꞌ himoni novozo nesi no minaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","No mino eveneꞌ tiꞌ lo lo sotoꞌ ogo lo-ngeme ngemeꞌ ogo minineꞌ: Eveneꞌ meheꞌnela alingeꞌ ma nave nene nezesi nivileꞌ o-nedosa ve naba ve. Naza aꞌneꞌmineꞌmine goboni gono do-do eiꞌ suuꞌvelotiꞌ nalaꞌve nesi nene gubiꞌ izo apase hulo-delodoꞌ nene mo lisiheꞌ amuve. ");
INSERT INTO aso_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naza noso holo-lingiduvoniꞌ nene haza nosotunuꞌ holo-lingiduve. Ne neiha aꞌmine ve neꞌmo noso neꞌmine holo-lengedelineꞌ nene Oꞌmosoꞌmi Sikalahukisi ne neive. ");
INSERT INTO aso_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aꞌmine gamene neuꞌ Izesuꞌ aza nGalilaia misubouꞌ numuno ngomo ma Nasalete nene hulo vo hetelavo Zohaneꞌ aza Zodani nosouꞌ holo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Holo-davo nosoutiꞌ dizosa aꞌmidoꞌ ningineꞌ nene okulumoꞌ ne ngoloꞌ lavo Sikalahuꞌ neꞌmo nama viluso neꞌmino lulouꞌ dizelesa nolimivo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Neꞌmine ogavo Okulumokutiꞌ gamazi tiꞌ lo limineꞌ: Gaza nene voꞌneloꞌ gipeꞌne hamoꞌ nene nane. Gezemuꞌ nene mo muluꞌneuꞌ lamineꞌ nogiluve. ");
INSERT INTO aso_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Idoꞌ nelotiꞌ geto Sikalahuliꞌmo Izesuꞌni nene hadive misubouꞌ imiselavo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Vavo aꞌmida nene Sataniꞌmo emenguꞌ moloꞌmo novivo gamene foti (40) vineꞌ. Idoꞌ aꞌmida nene Izesuꞌ aza loposo nama gaha minaaꞌ ada neivo angeloꞌ nete nasahiliꞌ i-dii hize eleꞌ i-di minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Idoꞌ Zohaneꞌni nalatoꞌ huli-dikevo neivo Izesuꞌ aza nGalilaia misubouꞌ vo Oꞌmosoꞌmi gamazi lamineꞌ lo sotoꞌ ogo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Gamene nene mo ogave. Oꞌmosoꞌmo gizebo o-ledelineꞌ gamene alitave. Nemuꞌ nene lingine lutine di velepeꞌ izi gamazi lamineꞌ mene gili eleꞌvoleꞌ ilo lo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Idoꞌ Izesuꞌ aza nGalilaia noso ohuno nabaꞌmi gahevela nomono Simoniki nakunolo Adeleaki ingine alahaꞌ daaꞌ asive minasinako alahaꞌ daaꞌ asineꞌ golalezeꞌine nene alahaꞌ dalisa nosouꞌ nihulasivo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ningo tiꞌ lo lo-ngimineꞌ: Lingine igi neꞌmetilizo. Alahaꞌ daaꞌ nasineꞌ neꞌmini eveneꞌ di nenita igaꞌ ilisive lo lengeleꞌmize molaloze. ");
INSERT INTO aso_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Neꞌmine lavo ingine liteꞌ li alahaꞌ daaꞌ asineꞌ golalezeꞌine hitiki eꞌmeti vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ve sitaꞌ nene do giꞌmizo ngomo ma novo aza Zebedaioꞌ gipele sitaꞌ Zakoboki nakunolo Zohaneki sipiuꞌ mini alahaꞌ daaꞌ aniꞌ golalezeꞌine nene ongoti di lamineꞌ nasivo ningo ");
INSERT INTO aso_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","asi lo-ngemavo gili meꞌnibo Zebedaioꞌnisi agoveꞌvesi sipiuꞌ huli-ngimiki eꞌmeti vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ingine vi Kahanaumi numunguꞌ mini holiseꞌ gamene naba ogavo monoꞌ numunguꞌ dizi Izesuꞌ monoꞌ gamazi apize ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Idoꞌ apize ngimineꞌ gamazimuꞌ nene voꞌine vavo upuhoꞌ aniꞌ. Ee, aza monoꞌ apize ngimineꞌ nene avoꞌningeliti monoꞌ gamazi apizi ngimaaꞌ avete apizi ngimaaꞌ aniꞌ neꞌmino apize ngemamo asi gamazi meleho neꞌmineꞌmo apize ngimineꞌ gelavo nemuꞌ voꞌine vavo upuhoꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Neꞌmine nilavo aꞌmine monoꞌ numuꞌninguꞌ nene ve ma minineꞌ. Aꞌmine veꞌmi lulouꞌ nene eveneliti luteuꞌ do goloso ogaꞌ ive Satanilatiꞌ sikalahuꞌ nene minavo aza gekeꞌ lo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nasalete ve Izesuvo, leliꞌ nonida mene nanimuꞌ ane. Gaza do goloso o-ledelesa abe. Geze nene naza mo ningo gele nouve ma nene nane. Gaza nene Oꞌmosolatiꞌ kegeso lamineꞌ minanive ma nene nane. ");
INSERT INTO aso_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Neꞌmine lineꞌza Izesuꞌ aza elemo tiꞌ lo lo-imineꞌ: Gamazi lamo zegeneꞌ oko mino eveneꞌ hulo-do lemo ogo vozo. ");
INSERT INTO aso_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Neꞌmine lavo aꞌmine sikalahuꞌ goloso nene vauve elo eveneꞌ do upuhoꞌ ogo do gesevase ize-do gekeꞌ naba lo luloutiꞌ lemo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Neꞌmine ogo lemo vavo eveneꞌ ingine ningi upuhoꞌ igi angise okoꞌninguꞌ longoꞌ i huli voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Mene nani suno ve. Ve mene amuzo ve mino sikalahuꞌ goloso gamazi lo-ngemavo gamaziꞌve gili daaꞌ nave li li voleloꞌ meloꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Neꞌmine ikevo guvele nene hutileꞌ ogo nGalilaia misubouꞌ numudoꞌ namadoꞌ mone osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Neꞌmine ogavo monoꞌ numungutiꞌ limi Simoniki Adeleaki numuꞌninguꞌ Zakobole Zohanelesi dizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoniꞌ elenahi izeleho nene okoꞌnoloꞌ oloꞌ ahuꞌ lavo ongo neivo nemuꞌ Izesuꞌni geti li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Li-imikevo aza neida vo analoꞌ do do ote-davo okoꞌnoloꞌ oloꞌ ahuꞌ lineꞌ niteꞌ nene aꞌmidoꞌ geto hulo-davo lamineꞌ gelo nosoꞌ niteꞌ gize vataꞌ o-ngedo nasahiliꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Idoꞌ nivengaꞌ hoꞌ lemavo initeꞌ gizi davesi luꞌninguꞌ sikalahuꞌ goloso minivesi mukiꞌ ezela ngeleꞌmizi di ikaꞌ ikaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aꞌmine numudotiꞌ aleve mukiꞌ nene igi gatedoꞌ di geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Neꞌmine ikevo aza initeꞌ ato atoliꞌmine gizi dave mukiꞌ do lamineꞌ o-ngedo sikalahuꞌ goloso mukiꞌ eveneꞌ maliti luꞌningutiꞌ ngimiselo do hulineꞌ. Idoꞌ Sikalahuꞌ goloso ingine eze ningi lamineꞌ igi gili nizaniꞌ nenako gamazi lamilo lo lo-ngemo ngimiselo do hulineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nedengaꞌ goꞌ olihe lamivo Izesuꞌ aza oto guviseuꞌ eveneꞌ nizamanguꞌ vo Oꞌmosola lo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tiꞌ neivo Simoniꞌ nene gonolomotesi ingine viseꞌ iꞌmi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ningi tiꞌ li li-imaniꞌ: Eveneꞌ mukiꞌ gezemuꞌ viseꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Li-imikevo aza tiꞌ lo lo-ngimineꞌ: Naza monoꞌ lo sotoꞌ ogo lo-ngemelongisi numuno ebeꞌ avitoꞌ minaniꞌ nela vukeleꞌzo. Naza nene mo neꞌmine olove losa uvoniꞌ ve lo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Neꞌmine lo aza mono monoꞌ numuꞌninguꞌ monoꞌ lo sotoꞌ o-ngemeꞌmo vo idoꞌ sikalahuꞌ goloso eveneꞌ maliti luꞌninguꞌ dizi minaniꞌ nene ngimiselo huloꞌmo vo nGalilaia misubouꞌ minaniꞌ ebeꞌ mukikuꞌ nene mone osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Idoꞌ ganadise gize dave maliꞌmo ezela ogosa obuvolo hize emo amuzonga lo tiꞌ lo lo-imineꞌ: Gaza do lamineꞌ o-nedelineꞌ amuzokasi naineꞌ nene naza mo gele mino do lamineꞌ o-nedeline lo gele nouve. Gaza do lamineꞌ o-nedelesa gele nabe. ");
INSERT INTO aso_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Neꞌmine lavo Izesuꞌ muluno hukavo ganadise gizi dave i-ngidisaꞌmaniꞌ initeꞌ o-do ana hulo molo okoꞌnoloꞌ hito tiꞌ lo lo-imineꞌ: Naza do lamineꞌ o-gedelesa gele nouve. Nemuꞌ gaza lamineꞌ ozo. ");
INSERT INTO aso_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Neꞌmine lavo ganadise neꞌmo liteꞌ lo okoꞌnolotiꞌ hulo-do vavo lamineꞌ gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lamineꞌ gelavo Izesuꞌ aza geto gamazi amuzo molo lo-emo imiselo nohulo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Gele nabe. Gaza lamineꞌ aineꞌ monovo nene eveneꞌ hamokisi lo-ngemamozo. Evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive neꞌmo ganadise okongalotiꞌ hulo-gedo vineꞌ nene ningo lo sotoꞌ ogavo gaza lamineꞌ aineꞌ nemuꞌ nene evenelite ningi gililizangumuꞌ ve lo neꞌmine ozo: Ganadise gizi dave ingine lamineꞌ igi ma ize initeꞌ neꞌmine neꞌmine Oꞌmoso imilisave lo Moseꞌ lo huko lidoꞌ nene eꞌmeto evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nene initeꞌ ma Oꞌmoso olokuꞌ gize emelingumuꞌ nene do vo emezo lo lo-imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Neꞌmine lo lo-imineꞌza ve aza vo aꞌmine gamazi apiꞌ ogo veteteꞌ ogo do hutileꞌ ineꞌ. Neꞌmine ogavo nemuꞌ nene eveneꞌ gili Izesuꞌni lisilizaniꞌ o vivo aza nene numuno ebekuꞌ sotoꞌ vamilidoꞌ ogavo haza guvisela neivo numudoꞌ namadoꞌ ve nene ezela igivoꞌ minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gamene ma ogo vavo Izesuꞌ aza Kahanaumi numuda tibizo ogo aꞌmida numuꞌvela neivo nemuꞌ eveneꞌ ingine gili ");
INSERT INTO aso_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","igi di geseꞌ igi gikiꞌ goloso adiꞌmo gatedokisi vovosi ma minamineꞌ. Neꞌmine ikevo aza monoꞌ gamazi lo-ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tiꞌ neivo inginelatiꞌ ve sitaꞌve sitaꞌve nete gebili ma ngakatoꞌ mili di navo eveneꞌ malite ezela ngeleꞌmizi alisa aniꞌza ");
INSERT INTO aso_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","eveneꞌ mukiꞌ gikiꞌ ikevo neꞌmo neida di vamilizaniꞌ ogavo nubitoꞌ dizi Izesuꞌ minineꞌ lisiheleloꞌ numuno nubikuꞌ bili heteli gebili ongo minineꞌ ngakaꞌ nene nalatoꞌ hulikevo limineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aꞌmine hulave nete ha do lamineꞌ o-deleseive li gili eleꞌvoleꞌ aniꞌ nene ningo gelo Izesuꞌ aza gebili ve nemuꞌ tiꞌ lo lineꞌ: Gipeꞌneho geiꞌ lihimeka nene mo apase-gedekuve. ");
INSERT INTO aso_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lavo avoꞌningeliti monoꞌ apizi ngimaaꞌ ave ma aꞌmida minave nete gaꞌninguꞌ tiꞌ li gili minaniꞌ: ");
INSERT INTO aso_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Eveneꞌ me ve nene nanimuꞌ neꞌmine nolive. Oꞌmoso ivileꞌ o-daaꞌ gamazi lave. Oꞌmosoꞌmovoꞌ lihimete hulo-ledaaꞌ ive ne neive li gili minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tiꞌ li gilaniꞌ nene Izesuꞌ aza lulouko gelo tiꞌ lo lo-ngimineꞌ: Lingine nanimuꞌ gatinguꞌ neꞌmine li nigilave. ");
INSERT INTO aso_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lingine nenikumuꞌ nene sozavoꞌ laaꞌ neive li gilaaꞌ nahe. Gebili nemuꞌ lihimeka mo hulo-gedekuve luvoniꞌ nene soza lolohe lamineꞌ lolohe ma gilamilisave lo lapa nomivo noluvoniꞌza sozaloꞌ ve minuvodini ve gebili nemuꞌ naza oto vozo nolo-duvo oto vamivo soza luvoniꞌ nene sotoꞌ ogavo novozo helalove lo gelo oto vozo lo ma lamuvodine. ");
INSERT INTO aso_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne neiha Oꞌmosolatiꞌ ve gihile naza misubouko lengiꞌ lihimetine apase-lengedaaꞌ amuzo do nouve luvoniꞌ nene soza lamo mo laminetoꞌ noluvoniꞌ nene ningi gililizangumuꞌ naza idise ogo molo oloniꞌ initeꞌ nene ningilo. Neꞌmine lo gebili nemuꞌ tiꞌ lo lo-imineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tiꞌ lo nolo-gimuve. Gaza oto ngakaka do geho numungala vozo. ");
INSERT INTO aso_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lavo mukitoꞌ ningi nizavo geto oto ngakaꞌve do geho vineꞌ. Neꞌmine ineꞌ nemuꞌ eveneꞌ mukiꞌ ingine golize li Oꞌmoso opoꞌni li tiꞌ li laniꞌ: Laza gomuꞌ initeꞌ neꞌmine ma ningesaꞌmuneꞌ ve li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Neꞌmine ogavo Izesuꞌ aza noso ohuno gahevela tibizo vineꞌ. Vavo eveneꞌ mukiꞌ ezela ikaꞌ ikaꞌ navo aza monoꞌ apize ngemeꞌmo vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Neꞌmine oꞌmo novo Alahaioꞌ gipele Leviꞌ aza takisi moni daaꞌ ineꞌ opisiꞌveuꞌ gono do neivo ningo tiꞌ lo lo-imineꞌ: Gaza neꞌmeto ano. Neꞌmine lavo aza oto eꞌmeto vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Vi eze numuꞌveuꞌ Izesulesi nosoꞌ niteꞌ ni nizavo monovo goloso igi takisi moni daaꞌ avesi idoꞌ Zuda veti louꞌ gamaziloꞌ eꞌmete lamineꞌ isaꞌmave gohi ma nesi mukiꞌ eꞌmeti vaniꞌ nenako eze izipahala zuhosi mukitoꞌ makatoꞌ nosoꞌ niteꞌ ni minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Neꞌmine igi nizavo Halisaioꞌ eveneliti monoꞌ apizi ngimaaꞌ ave ingine Izesuꞌ nene takisi moni daaꞌ avesi idoꞌ Zuda veti louꞌ gamaziloꞌ eꞌmete lamineꞌ isaꞌmavesi nosoꞌ niteꞌ makaꞌ ninavo ningi izapahala zuho tiꞌ li longoꞌ i-ngidaniꞌ: Aza takisi moni daaꞌ ave golososi idoꞌ lihime daaꞌ ave lingesi makaꞌ mini nanimuꞌ nosoꞌ niteꞌ ninave. ");
INSERT INTO aso_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Likevo gelo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Luso ve aza lamineꞌ haza minave do lamineꞌ o-ngedelesa osaꞌmiha initeꞌ gizi davemukovoꞌ nene ogaꞌ neive. Naza aꞌmine aꞌmine ogo eveneꞌ lisiheꞌ i minavemuꞌ amuvoniꞌza eveneꞌ lihimeꞌinesi vemuꞌ uvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gamene ma Zohaneꞌ izipahala zuhosi Halisaioꞌ evenekisi monoꞌinemuꞌ gili nosoꞌ niteꞌ malise igi nizavo eveneꞌ linge ma Izesuda igi tiꞌ li longoꞌ i-daniꞌ: Zohaneꞌ izipahala zuhosi Halisaioꞌ eveneliti izipahaꞌine zuhosi ingine nosoꞌ niteꞌ malise igi nizaha geze izipaha zuho nosoꞌ niteꞌ malise amave. Ne nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Longoꞌ i-dikevo aza tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo veneꞌ di imiliza gameneuꞌ olize izo nosoꞌ niteꞌ gize vataꞌ ogo eze zuho molo-ngedavo ingine aza aꞌminguꞌ neivo mulumo gili-di nosoꞌ niteꞌ malise ilizadoꞌ nehe. Ne nomive. Veneꞌ dalosa ive aꞌminguꞌ ha neivo ma nosoꞌ niteꞌ ngeli malise amilisave. Aꞌmine aꞌmine igi naza nouvosa nene lamineꞌ gili nizanako nosoꞌ niteꞌ malise amilizaha ");
INSERT INTO aso_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","engiꞌ vovoꞌningutiꞌ biluvalite neze neleꞌmizi di vilizaniꞌ gamene nene mo aliteleseive. Aꞌmine gamene alitavo mulumo gilisa nosoꞌ niteꞌ malise ilisave. ");
INSERT INTO aso_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Idoꞌ lavolavo gosohototiꞌ ngomo ma huki saketi litehe hukidoꞌ mili ongotilizaniꞌ nene lavolavo gosohoꞌ neꞌmo geleleheꞌ ogavo saketi litehe nene naba hukalinako lavolavo ngomo ma olihe ngingili lamineꞌ nene saketi liteheloꞌ mili ongotisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Idoꞌ aꞌmineꞌmine igi lingine vaini noso gosohoꞌ neꞌmo memeꞌ ize losuvodunuꞌ liliꞌ aniꞌ gomise nene izo pouꞌ lavo vaini noso nene lepo vo gomiseꞌvesi nene goloso ogalive li vaini noso gosohoꞌ gituhoꞌ galakalaꞌ neidiꞌmo nene lulu izavo gomise liteheliꞌmo gipu lo hukilineꞌ o mininguꞌ nene ma ohizi milisaꞌmave. Vaini noso gosohoꞌ gituhoꞌ galakalaꞌ neivo nene memeꞌ ize losuvo gosohotunuꞌ liliꞌ aniꞌ gomise gosohokuꞌ nene ohizesoꞌ o neive. Neꞌmine lineꞌ nene aza monoꞌ lo-ngemaaꞌ ineꞌ nene gosohoꞌ nenako izipahala zuho igi mili ilizaniꞌ monovo neꞌmo aꞌmine Zuda veti monovo litehe maloꞌ vo damingumuꞌ nene lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Holiseꞌ gamene mauꞌ Izesuꞌ izipahala zuhosi viti minguꞌ nivavo izipahala zuhote viti godololatiꞌ gihile ili niꞌmi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Neꞌmine iꞌmi vaniꞌ nemuꞌ Halisaioꞌ eveneꞌ malite Izesuꞌni tiꞌ li li-imaniꞌ: Ningezo. Leze louꞌ gamaziteuꞌ nene holiseꞌ gameneuꞌ gono damilo li nizaniꞌ mako neꞌmine nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Likevo aza tiꞌ lo lo-ngimineꞌ: Davidiꞌ eze evenele zuhosi nosoꞌ niteꞌine nomivo gaꞌna hili nizadoꞌ aza initeꞌ ineꞌ nemuꞌ gati gilisaꞌmahe. ");
INSERT INTO aso_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Adoꞌ Abiatalaꞌ evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba minineꞌ gameneuꞌ Davidiꞌ aza Oꞌmosoꞌmi numunguꞌ dizo Oꞌmosoꞌmi veleloꞌ milaaꞌ aniꞌ beleti nene do azasi makaꞌ monavesi ngemavo naniꞌ. Aꞌmine beleti nene haza ve namilizave li evenetoꞌ medeli mini Oꞌmoso initeꞌ lehize-daaꞌ avetevoꞌ nalizave li li hukikaniꞌ beleti nene gopo naniꞌ ma ve. ");
INSERT INTO aso_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo eveneꞌ do sotoꞌ molaniꞌ nene holiseꞌ gamene hize eleꞌ ilizangumuꞌ ve lo do sotoꞌ molaniꞌ nomive. Asi holiseꞌ gamene neꞌmo nene eveneꞌ hize eleꞌ o-ngedaaꞌ ilive losa evenekumuꞌ do sotoꞌ molaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nemuꞌ nene naza Oꞌmosolatiꞌ ve gihile naza nene holiseliꞌmi melehosi mino aꞌmine holisekuꞌ iliza initekumuꞌ idoꞌ amiliza initekumuꞌ laaꞌ uve nene nenikovoꞌ nouve lo lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mino monoꞌ numunguꞌ gohi dizineꞌ. Aꞌmida ve ma ana hamoꞌ ma goloso ogo gilizevo o vineꞌ nene omo neivo ");
INSERT INTO aso_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","eveneꞌ ma nete holiseꞌ gamene neinako Izesuꞌ do lamineꞌ o-delineꞌ nene holisekumuꞌ laniꞌ louꞌ gamazi ma nene avutoꞌ oloseinako nemuꞌ goniꞌ o-delone li ningilisa gizebo igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tiꞌ igi nizavo Izesuꞌ aza ana goloso o vivemuꞌ tiꞌ lo lineꞌ: Vovoteuꞌ ote minezo. ");
INSERT INTO aso_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lo eveneꞌ longoꞌ o-ngidineꞌ: Leze louꞌ gamazite neꞌmo nadive lo neive. Holiseꞌ gameneuꞌ nene monovo lamineꞌ ilo lo neihe. Monovo goloso ilo lo neive. Adoꞌ eveneꞌ di lamineꞌ i-ngidilo lo neihe. Eveneꞌ ngibili hililo lo neive lo longoꞌ ogo lineꞌza gamazi di tibizi lamavo ");
INSERT INTO aso_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","izeboloꞌ molavo vele do eza ema ogo vonuꞌ goloso ngebelo luꞌine gaꞌine ngi lo tile vineꞌ minangumuꞌ mulumoꞌine ninge-ngidineꞌ. Neꞌmine ogo ana goloso o vive ma nene tiꞌ lo lo-imineꞌ: Anga do pehe lozo. Neꞌmine lavo ana do pehe lavo gohi lamineꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Neꞌmine ogavo Halisaioꞌ eveneꞌ ingine limi bililizaniꞌ aka di sotoꞌ ilisa aꞌmidoꞌ geti Helodeꞌ zuhosi mulise mili gamazi di hamoꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Neꞌmine ogavo Izesuꞌ aza aꞌmine ebeꞌ hulo izipahala zuho ngeleꞌmizo noso ohuda limineꞌ. Lemavo nGalilaia misubokotiꞌ nene eveneꞌ vaiꞌ goloso eꞌmeti aniꞌ. Idoꞌ eveneꞌ Zelusalemi numudotikisi Zudaia misubo lingelatikisi ma avo idoꞌ Idumaia misubokotikisi ma avo idoꞌ Zodani noso helalatikisi ma avo idoꞌ linge ma Tilo numudotikisi Sidoni numudotikisi aniꞌ. Aꞌmine eveneꞌ vaiꞌ goloso aniꞌ nete Izesuꞌ ogo molo minineꞌ initeꞌ nemuꞌ nene gilaniꞌ nenako nemuꞌ ezela aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Neꞌmini ikevo di geseꞌ ave ingine gikiꞌ gikiꞌ igi di langoloꞌ i-nidikelizave lo sipi ma di igi di mili-nidilo lo izipahala zuho lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Idoꞌ sipiuꞌ minelove lineꞌ nene nemuꞌ lineꞌ ve: Eveneꞌ mukiꞌ do lamineꞌ o-ngedo miningumuꞌ nene initeꞌ gizi dave vaiꞌ ingine okoꞌnoloꞌ do gelelone li ezela igi okoꞌnidoꞌ okoꞌnidoꞌ igi di langoloꞌ i-dilizaniꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Idoꞌ neꞌmine navo eveneꞌ luꞌninguꞌ minaniꞌ sikalahuꞌ goloso nete eze ningi gizenela limi ingi gekeꞌ naba li tiꞌ li likaꞌ likaꞌ igi minaniꞌ: Gaza Oꞌmosoꞌmi gipele ma ne nane. ");
INSERT INTO aso_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Likevo aza nene neꞌmo ma ve li neze monovo li sotoꞌ sotoꞌ igi li-ngimamilo lo amuzo molo lo huko lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Idoꞌ Izesuꞌ aza gololoꞌ dizo eiꞌ gala gilidoꞌ eveneꞌ ma vise lo-ngemavo ezela aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ikevo aza ve tuvelu do kegeso nenikisi monelone lo idoꞌ ngimiselekuvo monoꞌ li sotoꞌ igi li-ngimilizave. ");
INSERT INTO aso_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Idoꞌ amuzo ngemekuvo di mini eveneꞌ luꞌningutiꞌ sikalahuꞌ goloso ngimiselilizave lo do kegese-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Do kegese-ngidive ve tuvelu nete guliveꞌine nene neꞌmino neive: Simoniꞌ gulive gohi ma nene Petoloꞌ ve lo molo-dineꞌ ");
INSERT INTO aso_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","idoꞌ Zebedaioꞌ gipele Zakobolesi akunolo Zohanelesi guliveꞌine Boanelegesiꞌ ve lo molo-ngidineꞌ. Leze gamaziteutiꞌ nene goꞌ ngilili gili vasineꞌ ve losa ve. ");
INSERT INTO aso_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Idoꞌ Adeleaꞌ idoꞌ Hilipoꞌ idoꞌ Batolomaioꞌ idoꞌ Mataioꞌ idoꞌ Tomasiꞌ idoꞌ Alahaioꞌ gipele Zakoboꞌ abalaho idoꞌ Tadaioꞌ idoꞌ Simoniꞌ aza Loma ve ngimiselelone lo amuzonga laaꞌ ive nesi ");
INSERT INTO aso_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","idoꞌ alingeꞌ Izesuꞌni do sotoꞌ o-do biluvaliti aꞌninguꞌ molave Kelioto ebekutiꞌ ve Zudaꞌ nesi nene minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Izesuꞌ aza numunguko vineꞌ. Vo neivo eveneꞌ mukiꞌ gohi igi di geseꞌ adiꞌmo veꞌine initekisi namaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Neꞌmine igi nizavo eze zuho ingine gili eleꞌmizi alisa vaniꞌ ve. Idoꞌ eleꞌmizi alisa vaniꞌ nene aza mo negi hizave li laniꞌ nenako nemuꞌ eleꞌmizi alisa vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Idoꞌ avoꞌningeliti monoꞌ apizi ngimaaꞌ ave Zelusalemi numudatiꞌ ave ingine tiꞌ li li minaniꞌ: Ve mene sikalahuꞌ goloso ngimiselo do nohulineꞌ nene engiꞌ guveꞌinesi ve naba Belezebuloꞌ lulouꞌ mino aꞌmine sikalahuꞌ golosoliti guveꞌinesi ve naba neꞌmo amuzo emavo nedunuꞌ do nohulineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tiꞌ li nizavo Izesuꞌ vise lo-ngemo aneza gamazi tiꞌ lo lo-ngimineꞌ: Satani neꞌmo Satani nene nado imiselelive. ");
INSERT INTO aso_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Misubo mauꞌ eveneꞌ engikuꞌ lovo hizi vi eza ema ilizaniꞌ nene vi gopoꞌnapa ilisave. ");
INSERT INTO aso_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Idoꞌ eveneꞌ hamoꞌ zuho vi eza ema ilizaniꞌ nene vi gopoꞌnapa ilisave. ");
INSERT INTO aso_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aꞌmine aꞌmine igi Sataniꞌmi zuho ingine vi eza ema igi minadini nge lami diꞌmozi osuꞌ li ma minamadine. ");
INSERT INTO aso_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Eveneꞌ maliꞌmo ve ma gasava daaꞌ ive miniveliꞌmi numuꞌveuꞌ dizo aꞌmine gasava daaꞌ iveꞌmo gizebo ogo minineꞌ initeꞌve ipeꞌ ogo dalineꞌ nene haza dizo ipeꞌ ogo damoloseive. Asi aꞌmine gasava daaꞌ ive nene gomuꞌ ivileꞌ ogo nalaꞌ do-mikosavoꞌ nene dizo initeꞌve ipeꞌ ogo daloseive. Aꞌmineꞌmine ogo naza nene Satani ivileꞌ ogosa eveneꞌ eitatiꞌ nene do nenita ogaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Naza lamineꞌ ma lo-lengemelove: Eveneꞌ ingine goloso niteꞌ ato atoꞌ igaꞌ aniꞌ neꞌmi lihime idoꞌ Oꞌmoso divi lediviꞌ igaꞌ aniꞌ neꞌmi lihime nene Oꞌmosoꞌmo ha hulo-ngedeleseiha ");
INSERT INTO aso_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","eveneꞌ maliꞌmo Oꞌmosoꞌmi Sikalahuꞌve dovo ledevoꞌ ilineꞌ neꞌmi lihime nene Oꞌmosoꞌmo mo hulo-damoloseive. Aza nene imineꞌ molo mineꞌmo vo minevoꞌ minevoꞌ ilineꞌ lihime daloseive lo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Idoꞌ Oꞌmosoꞌmi Sikalahuꞌ dovo ledevoꞌ ogaliꞌmi lihime Oꞌmosoꞌmo hulo-lengedamoloseive lo lo-ngimineꞌ nene oꞌmosoꞌmi Sikalahuꞌ Izesuꞌ lulouꞌ neineꞌ nenako eveneꞌ ingine sikalahuꞌ goloso eiꞌ lulouꞌ neive li minaniꞌ nemuꞌ nene lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Idoꞌ izelehosi akunolomotesi igi heteli heta oti mini ezemuꞌ longoꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Neꞌmine ikevo eveneꞌ mukiꞌ eze vodo vodo i-di minave nete tiꞌ li li-imaniꞌ: Ningezo. Izahosi nakunamote nesi heta imi mini gezemuꞌ nilave. ");
INSERT INTO aso_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Neꞌmine likevo gamazi tiꞌ lo do tibizo lo-ngimineꞌ: Izeꞌnehinemukisi nakuꞌnemotinemukisi nilahe. ");
INSERT INTO aso_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Neꞌmine lo vele do eza ema ogo eveneꞌ vodo vodo i-di minave vonuꞌ ngebelo tiꞌ lo lo-ngimineꞌ: Izeꞌnemote nakuꞌnemote nene mene nizaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eveneꞌ Oꞌmosoꞌmi luloloꞌ igi mili igaꞌ nave engiꞌ nene izeꞌnemote nakuꞌnemote idoꞌ aluꞌnemote ne nizave. ");
INSERT INTO aso_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Izesuꞌ noso ohuno gahevela mino gohi monoꞌ apiꞌ ogo nolo-ngimivo eveneꞌ mukiꞌ goloso igi di geseꞌ adiꞌmo aza nene nosouꞌ minineꞌ sipi mauꞌ vo dizo minavo di geseꞌ ave mukiꞌ ingine noso gahevela gepeloꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nizavo aneza gamazi ato atoꞌ lo-ngemeꞌmo novo initeꞌ mukikumuꞌ apize ngimineꞌ. Noapize ngemo gamazi ma tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Gililo. Ve ma zuho initeꞌ tileꞌ ogaꞌ iveliꞌmo zuho niteꞌ tileꞌ olosa vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Vo tileꞌ oꞌmo novivo zuho niteꞌ linge ma nene akaloꞌ diꞌmozikevo namalite igi naniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Linge ma nene gehedoꞌ misubo naba minamidoꞌ diꞌmozi misubo naba nomineꞌ neꞌmo getiꞌ geti gala hoꞌli dizaniꞌza ");
INSERT INTO aso_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","hoꞌ nene amuzo molo lavo dizi luhive vaiꞌ damaniꞌ nenako neꞌmo gulugulu izaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Linge ma nene gasava guvise hukikevo luhive ma ha minidoꞌ diꞌmozi gala hoꞌli dizaniꞌza gasava guvise neꞌmo dizo molo-ngedavo gihile izamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Idoꞌ linge ma misubo laminekuꞌ diꞌmozi gala hoꞌli dizi gihile izaniꞌ. Ma neꞌmo gihile teoti (30) izineꞌ. Ma neꞌmo gihile sigisiti (60) izineꞌ. Ma neꞌmo gihile vanu hadeti (100) izineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Neꞌmine losa tiꞌ lo lineꞌ: Gatine ngoloꞌ live nii ma nene gili lamineꞌ ilo. ");
INSERT INTO aso_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Eveneꞌ mukiꞌ ingine hutileꞌ igi vikevo izipahala zuho tuvelu inginesi idoꞌ ezesi monaaꞌ ave linge masi engikovoꞌ mini aneza gamazi laaꞌ ineꞌ monovo mamuꞌ longoꞌ i-dikevo ");
INSERT INTO aso_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo gizebo o-ledelingumuꞌ sunoꞌ gamazi nene lengiꞌ ha gililisave lavo lo sotoꞌ o-lengemaaꞌ nouvoniꞌza lelikisi monamaaꞌ ave nene aneza gamazivoꞌ lo-ngemaaꞌ nouve. Neꞌmine nouvoniꞌ nene polohete maliꞌmo gizineꞌ gamazi ma nene inginela gihile izelive losa neꞌmine ogaꞌ nouve. Tiꞌ lo gize neive: ");
INSERT INTO aso_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ningi ningi ningilizaha ninge lamineꞌ amilisave. Idoꞌ gili gili gililizaha gili lamineꞌ amilisave. Nene nanitekumuꞌ ve. Ingine luꞌine di velepeꞌ izikevo Oꞌmosoꞌmo lihimeꞌine hulo-ngedalive losa ve. ");
INSERT INTO aso_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Aneza gamazi luvoniꞌ meꞌmi monovo gilamahe. Idoꞌ gilamilizaniꞌ nene aneza gamazi mukiꞌ nene nadiꞌ igi gililizave. ");
INSERT INTO aso_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zuho niteꞌ tileꞌ ogaꞌ ive aza Oꞌmosoꞌmi gamazi nene tileꞌ ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Idoꞌ gihile ma akaloꞌ doꞌmozive luvoniꞌ neꞌmi monovo nene neꞌmino neive: Oꞌmosoꞌmi gamazi nene eveneꞌ maliti luꞌninguꞌ tileꞌ ogavo nigilavo Sataniꞌmo geto ogo aꞌmine gamazi nene luꞌningutiꞌ ipeꞌ ogo do vaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aꞌmineꞌmine ogo gihile ma gehedoꞌ misubo naba minamidoꞌ diꞌmozave luvoniꞌ neꞌmi monovo nene neꞌmino neive: Eveneꞌ ma ingine Oꞌmosoꞌmo gamaziꞌve tileꞌ ineꞌ nene gilii liteꞌ li gili laniteꞌ igi di goꞌzaaꞌ naha ");
INSERT INTO aso_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","aꞌmine gamazi neꞌmo luꞌninguꞌ luhise do minelidoꞌ mini mili minamavo gamene haꞌnamuꞌ gili dii minisaꞌmave. Idoꞌ gamene haꞌna gili di minisaꞌmaniꞌ nene ingine aꞌmine gamazi gili nidavo neꞌmo engita geni sotoꞌ o-ngemelihe goboni malaꞌ malaꞌ sotoꞌ o-ngemelihe. Ineꞌ nene geti hulaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Idoꞌ gihile ma gasava guvise minidoꞌ diꞌmozave luvoniꞌ neꞌmi monovo nene neꞌmino neive: Eveneꞌ ma ingine Oꞌmosoꞌmo gamazi tileꞌ ineꞌ nene ha gilaniꞌza ");
INSERT INTO aso_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ingine okoꞌine losuvoꞌmi initekumuꞌ gilaaꞌ idoꞌ moni henenimuꞌ gahuꞌninguꞌ ogaꞌ idoꞌ ato atoꞌ niteꞌ mukiꞌ nene dalone li gilaaꞌ aniꞌ neꞌmo nene dizo Oꞌmosoꞌmi gamazi nene molo-davo gihile izesaꞌmive. ");
INSERT INTO aso_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Idoꞌ gihile ma misubo laminekuꞌ diꞌmozave luvoniꞌ neꞌmi monovo nene neꞌmino neive: Eveneꞌ ma ingine Oꞌmosoꞌmi gamazi gili luꞌninguꞌ di goꞌzi gili lamineꞌ igi nizavo gihile izaaꞌ neive. Ee, zuho niteꞌ hamototiꞌ gihile teoti (30) izaaꞌ neineꞌ neꞌmino ve mala nene mukiꞌ izaaꞌ neive. Idoꞌ zuho niteꞌ hamototiꞌ gihile sigisiti (60) izaaꞌ neineꞌ neꞌmino ve mala nene vaiꞌ goloso izaaꞌ neive. Idoꞌ zuho niteꞌ hamototiꞌ gihile vanu hadeti (100) izaaꞌ neineꞌ neꞌmino ve mala nene vauve goloso elosa izaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Lamu ma gizi misubo somodunuꞌ molo hitelone li idoꞌ holomoliꞌmi sebenguꞌ haleko molalone li di igi milaaꞌ nahe. Ne nomive. Lamu gizii labanaꞌ elo minelidoꞌ holomoꞌveloꞌ molalone li di igi milaaꞌ nave. Olo. ");
INSERT INTO aso_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aꞌmineꞌmine ogo initeꞌ ma sunoꞌ minelineꞌ nene mudise ningamavo ma minamoloseive. Mo sotoꞌ oloseive. Idoꞌ initeꞌ ma hito minelineꞌ nene ningilizada omo sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gatine ngoloꞌ live nii ma gili lamineꞌ ilo. ");
INSERT INTO aso_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Idoꞌ gamazi neꞌminosasi ma lo-ngimineꞌ: Gamazi ma li-lingimikevo nigili ma nene gatine mili mini aꞌmingutiꞌ hoꞌli gilisa minilo. Lingine igi mili minilizaniꞌ votigileloꞌ nene do molo Oꞌmosoꞌmo hize eleꞌ o-lengedo gohi masi imineꞌ molo-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ee, monoꞌ ma do nolive nene Oꞌmosoꞌmo gohi ma emeleseive. Idoꞌ monoꞌ ma damo nolive nene eita monoꞌ ngomosi ma nolineꞌ nene mo ipeꞌ ogo do voloseive. ");
INSERT INTO aso_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Idoꞌ gamazi gohi ma tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ilineꞌ nene neꞌmine oꞌmo vo nabauꞌ voloseive: Ve maliꞌmo zuho niteꞌ miꞌveuꞌ tileꞌ ogosa ");
INSERT INTO aso_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","litiꞌmuso izo goꞌ lo neivo aza ongo oto oꞌmo novivo zuho niteꞌ nene gala ngoloꞌ lo dizineꞌ. Dizineꞌza neꞌmi monovo nene aza ningo gelamineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Misubo neꞌmo asiꞌve do dize-daaꞌ neive. Apiꞌ ogo gala ngoloꞌ lo avile ogo gihile izaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Neꞌmine ogo gihile husavo ma aza huko daloneꞌ gamene alitave lo gelo goboni ve vi hukilizave lo ngimiselaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aꞌmine gamaziloꞌ gohi ma imineꞌ molo tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ilineꞌ vo naba ilineꞌ akaꞌve nene laza nado neive lolone. Idoꞌ initeꞌ nanitetoꞌ lo molo lokunivo vo miliseꞌ ilive. Idoꞌ initeꞌ nanitetoꞌ aneza gamazi lo molo lolone. ");
INSERT INTO aso_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aꞌmine Oꞌmosoꞌmi gizebo nene nabaꞌmine sakaveꞌ zuho neꞌminosa neive. Aꞌmine niteꞌ nene me misubouko minaniꞌ zuho niteꞌ vaikutiꞌ eiꞌ nene ngomo lasolo neineꞌza ");
INSERT INTO aso_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","zuhoꞌ ikevo gala hoꞌlo dizo minguꞌ niteꞌ mukiꞌ nene ngivileꞌ ogo naba ogo aꞌnavaꞌve nene naba ogo zamuꞌ gizavo nama nete igi aꞌminguꞌ numuno gizaaꞌ nave lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Idoꞌ neꞌmine aneza gamazi ato atoꞌ mukiꞌ nene monoꞌ ha gililizadokovoꞌ lo-ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eveneꞌ mukiꞌ nene aneza gamazivoꞌ lo-ngimineꞌza alingeꞌ azasi izipahala zuhosi angisevoꞌ minanguꞌ nene gamazi monovo mukiꞌ nesi nene lo sotoꞌ ogo lo-ngemaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aꞌmine gameneuꞌ nene nivengaꞌ molavo Izesuꞌ aza izipahala zuho tiꞌ lo lo-ngimineꞌ: Noso helala holene volone. ");
INSERT INTO aso_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lavo eveneꞌ mukiꞌ di geseꞌ igi minave nene huli-ngidi sipiuꞌ nene ha minidokovoꞌ ha neivo ingine eleꞌmizi vaniꞌ. Nivavo sipi gohi masi makaꞌ vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nivavo hepeꞌ naba goloso elavo neꞌmo noso nene golo gidini dizevoꞌ dizevoꞌ ogo sipi nene hito lulouko velo lemeꞌ lemeꞌ idiꞌmo sipiuꞌ nene nosoꞌmo vaiꞌ lolosa ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Neꞌmine ogo neivo Izesuꞌ aza nene sipi isevela godololoꞌ alese molo okise ongo minineꞌ. Minavo izipahala zuho ingine uꞌmukoꞌ igi tiꞌ li laniꞌ: Tisazo, laza nosouꞌ mene lemo heleloningumuꞌ nene ma gelamabe. Olo. ");
INSERT INTO aso_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Neꞌmine likevo aza oto hepeꞌ nene elemo noso mamuꞌ moda ve. Hongu lozo lineꞌ. Lavo hepeꞌ nene matavo noso nesi hongu lo zou lo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Neꞌmine ogavo tiꞌ lo lo-ngimineꞌ: Lingine golise nanimuꞌ nigilave. Oꞌmosomuꞌ gili eleꞌvoleꞌ amahe. ");
INSERT INTO aso_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tiꞌ lo lavo ingine ngehelele goloso izavo aꞌminemuꞌ li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Mene ve nene naniꞌmine ve neivo hepeki nosogi nene gamaziꞌve gili dikesive. ");
INSERT INTO aso_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Neꞌmine ogavo ingine noso ohuno helala Gelasa vetida vi hetelaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Vi hetelikevo Izesuꞌ sipiutiꞌ lemavo sikalahuꞌ golososi minive maliꞌmo gonoso mili-ngidaaꞌ aniꞌ geheni muliꞌ ebekutiꞌ ogo navo voteneꞌ asineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aꞌmine ve nene geheni mulikuꞌ ongo minaaꞌ neivo ve maliꞌmosi analoꞌ damilineꞌ ogavo seni nalatunukisi daniꞌ nene damineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gamene mukiꞌ gizene analoꞌ seni nalaꞌ izi-daniꞌza analoꞌ nalaꞌ nene do huko hulo gizeneloꞌ nalaꞌ nesi izo huko hulavo ve hamoliꞌmosi amuzo molo ivileꞌ ogo do hongu lo-damilidoꞌ o minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gamene gamene holukaꞌ holukaꞌ geheni mulikukisi gololokisi mino gekeꞌ gekeꞌ lo mino gehenitunuꞌ gesebeꞌ izo asiꞌve okoꞌno nene huko minaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Izesuꞌ aza hotoꞌ navo ningo lotiꞌ izo ogo gizeneuꞌ gubiꞌ ize emo ");
INSERT INTO aso_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","amuzo molo gekeꞌ naba lo tiꞌ lo lo-imineꞌ: Izesuvo, Oꞌmoso dizo miniveꞌmi gipele mene gaza nouvoda nanitekaꞌ nane. Oꞌmosoꞌmi guliveloꞌ agae lo nolo-gimuze. Mulumo gono nemamozo. ");
INSERT INTO aso_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mene gamazi lineꞌ nene Izesuꞌ aza sikalahuꞌ goloso gaza aꞌmine veꞌmi luloutiꞌ lemo vozo lo nolo-divosa lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lavo Izesuꞌ aza longoꞌ o-do tiꞌ lo lineꞌ: Guliveka zaho nane. Longoꞌ o-davo aza lineꞌ: Laza vaiꞌ nounako guliveꞌne nene Mangiliseꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Neꞌmine lo mene misuboukotiꞌ limiselo mala do hulo-ledamilive lo amuzo molo zegeꞌ zegeka lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Idoꞌ aꞌmida golola nene ize vaiꞌ goloso galese ni nizavo ");
INSERT INTO aso_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","sikalahuꞌ golosolite zegeꞌ zegeka li tiꞌ li li-imaniꞌ: Agae. Izeuꞌ volene do hulo-ledanivo luꞌninguꞌ dizelone. ");
INSERT INTO aso_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Neꞌmine likevo vi aꞌminguꞌ dizilizave lo Izesuꞌ gele ngimineꞌ. Neꞌmine ogavo sikalahuꞌ goloso ingine aꞌmine veꞌmi luloutiꞌ limi izeliti luꞌninguꞌ vi dizaniꞌ. Dizikevo ize tu tauseni (2,000) neꞌmine ingine mangilise hizi lotiꞌ izi golo aveseloꞌ nene limi noso ohunouꞌ vi noso ni hilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hilikevo ize gizebo ve nete golise vi tauni nabaukisi idoꞌ hazalasi veteteꞌ igi li-ngimikevo evenelite sotoꞌ ineꞌ initeꞌ nene ningelone li ");
INSERT INTO aso_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Izesuda igi sikalahuꞌ goloso mukikisi minive nene genegana do otuho gala gele nge losa neivo ningi ngehelele izineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Idoꞌ aꞌmine sikalahuꞌ goloso mukiꞌ minivelasi idoꞌ izelasi sotoꞌ ineꞌ initeꞌ ningave nete neꞌmi gamaziꞌve nene veteteꞌ igi li-ngimikevo ");
INSERT INTO aso_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","engiꞌ misuboꞌine nene hulo vilive li Izesuꞌni geligelinga li-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Neꞌmine li-dikevo Izesuꞌ sipi mauꞌ nodizivo sikalahuꞌ golososi minive aza ezela giꞌmizo monelove lo geligelinga lo lo-imineꞌza ");
INSERT INTO aso_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Izesuꞌ oꞌve lo-emo tiꞌ lo lo-imineꞌ: Gaza numungala vo Guvelesi ve gezemuꞌ muluno hukavo initeꞌ lamineꞌ goloso o-gidineꞌ neꞌmi gamazi nene veteteꞌ ogo geze eveneka zuho lo-ngemezo. ");
INSERT INTO aso_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lavo Dekapoli misubouko vo Izesuꞌ initeꞌ o-dingumuꞌ nene lo sotoꞌ ogo lo-ngemavo eveneꞌ mukiꞌ gili golize laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Neꞌmine ikevo Izesuꞌ aza sipiuꞌ dizo noso ohuno ema helala gohi ogo noso gaheve gepeloꞌ neivo eveneꞌ mukiꞌ goloso ezela igi di geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Neꞌmine ikevo Zuda veti monoꞌ numungutiꞌ guvelesi ve ma gulive Zailoꞌ aza ogo Izesuꞌni ningo gizeneuꞌ gubiꞌ ize emo ");
INSERT INTO aso_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","agae lo geligelinga lo tiꞌ lo lo-imineꞌ: Neniꞌ alune ngomo ma nene mo osuꞌ lolosa neize. Aza nene lamineꞌ ogo velesi lamineꞌ ha minelingumuꞌ ve lo gaza ogo angadunuꞌ do geleline lo nouve. ");
INSERT INTO aso_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Lo-emavo makaꞌ nivasivo eveneꞌ vaiꞌ li eꞌmeti nivii ezela gikiꞌ gikiꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Neꞌmine igi nivanguꞌ nene veneꞌ ma vineꞌ. Aꞌmine veneꞌ nene venelite ikeꞌniloꞌ ikeꞌniloꞌ ningaaꞌ naniꞌ siki nene mate-desaꞌmivo mino gamene haꞌnaloꞌ ninge do vo neivo ");
INSERT INTO aso_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","kilisimasi tuvelu ogo vineꞌ ve. Neꞌmino neivo luso ve mukiꞌ nete di lamineꞌ i-dilisa luso gizi-danguꞌ nene mulumo niteꞌ mukiꞌ imi luso gizi-dikevo aꞌmidoꞌ nene meni ngemo initeꞌve mukiꞌ hulo osuꞌ lineꞌza isineꞌ niteꞌ nene osuꞌ lo-damo gohi do naba ogo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Aꞌmine veneꞌ nene Izesuꞌ guvele gelosa naza okoꞌnoloꞌ damo ha geneganaꞌvelokovoꞌ do geleloniꞌ nene lamineꞌ olosuve lo gilineꞌ nenako nemuꞌ aza eveneꞌ gikiꞌ igi minanguꞌ nene Izesuꞌ mehenelatiꞌ ogo ");
INSERT INTO aso_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","anadunuꞌ geneganaꞌveloꞌ do gilineꞌ. Do nogilivo aꞌmidoꞌ geto siki initeꞌve minineꞌ nene okuꞌ lo-davo tiꞌ lo lulouꞌ gilineꞌ: Nisineꞌ niteꞌ nene mo osuꞌ lo-nedave. ");
INSERT INTO aso_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Neꞌmine ogavo Izesuꞌ aza ezelatiꞌ amuzo vineꞌ nene eiꞌ lulouko gelosa aꞌmine eveneꞌ muliseuꞌ nene liteꞌ lo mine velepeꞌ izo tiꞌ lo lineꞌ: Geneganaꞌneloꞌ eveneꞌ zaho do gelane. ");
INSERT INTO aso_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lavo izipahala zuho ingine tiꞌ li li-imaniꞌ: Eveneꞌ mukiꞌ nene geiꞌ di vodo vodo i-gidi okoꞌnidoꞌ okoꞌnidoꞌ igi nivanako nenitoꞌ zaho do gilive lo nolabe. ");
INSERT INTO aso_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Laniꞌza aza nene zaho do gilive lo ningelesa vele do eza ema ogo ningeꞌmo monineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ningeꞌmo nomonivo veneꞌ aza eita sotoꞌ o-dineꞌ initeꞌ mamuꞌ gelosa golise gelo luvoluvo izo ogo Izesuꞌ gizeneuꞌ lemo pouꞌ lo ongo gubiꞌ ize emosa eiꞌ ineꞌ initeꞌ nemuꞌ nene hitamo lo sotoꞌ ogo osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lo-emavo aza tiꞌ lo lo-imineꞌ: Alune ve, gaza gele eleꞌvoleꞌ anidiꞌmo nene lamineꞌ ogange. Mulungauꞌ hongu lo lamineꞌ o minivo vozo. Initeꞌ gisineꞌ nene osuꞌ lo-gedavo lamineꞌ minezo. ");
INSERT INTO aso_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tiꞌ nolivo aꞌmine monoꞌ numungutiꞌ guvelesi veꞌmi numuꞌvelatiꞌ ma igi tiꞌ li laniꞌ: Aluva ma mo helave. Nemuꞌ nene gaza tisaꞌni lihiteheka lo gohi eleꞌmizo amozo. ");
INSERT INTO aso_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Neꞌmine laniꞌza Izesuꞌ aꞌmine gamazi gele hulo monoꞌ numungutiꞌ guvelesi vemuꞌ tiꞌ lo lo-imineꞌ: Gaza gopo gaka gelamo nenikumuꞌ gele eleꞌvoleꞌ ogovoꞌ minezo. ");
INSERT INTO aso_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tiꞌ lo losa eꞌmetikelizave lo eveneꞌ mukikumuꞌ nene oꞌve lo lo huko-ngedo Petolole Zakobole Zakoboꞌ akunolo Zohanelesi engikovoꞌ oꞌve lo-ngedamivo eꞌmetaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Monoꞌ numungutiꞌ guvelesi veꞌmi numudoꞌ vi hetelikevo alungomuꞌ gulugulunga li ive nama igi zanamana izi nizavo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ningo numunguꞌ dizo tiꞌ lo lo-ngimineꞌ: Lingine nanimuꞌ ngeunga li ive nama igi nizave. Izipe nene helamineꞌ haza okise ongo neive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lavo gizeꞌ i-daniꞌza aza mukiꞌ ngimisele hulo hetoꞌ ogo izipeꞌmi melehingi izelehingi idoꞌ ezesi ave nesi ngeleꞌmizo izipe minineꞌ numunguꞌ dizineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dizo alungo neꞌmi analoꞌ do tiꞌ lo lo-imineꞌ: Talita kumi, neꞌmi monovo leliꞌ gamazitiꞌ nene tiꞌ lo neive: Alungo ngomo, neniꞌ nolo gimuze. Otezo. ");
INSERT INTO aso_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lavo aꞌmidoꞌ geto oto aka mono minineꞌ. Aꞌmine aluꞌmi kilisimasiꞌve nene tuvelu neꞌmine minineꞌ. Neꞌmine ogavo ningave ingine aꞌmidoꞌ geti golize goloso li minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tiꞌ igi nizavo Izesuꞌ aza aꞌmine ninganiꞌ initekumuꞌ nene eveneꞌ hamokisi li-ngimamilo lo lo huko lo-ngemo alungo nene nosoꞌ niteꞌ imilizave lo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Izesuꞌ aza aꞌmine ebeꞌ hulo izipahala zuhosi eꞌmeti minavo gotoꞌ numuꞌvela vo hetelineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Holiseꞌ gamene ogavo monoꞌ numunguꞌ monoꞌ apize ngemo neivo eveneꞌ mukiꞌ ingine gili golize li tiꞌ li laniꞌ: Mene ve nene gamazi zalatiꞌ dave. Idoꞌ eiꞌ gamazi galauꞌ neineꞌ lo-limineꞌ nene atoliꞌmine neinako neꞌmi monovo nene nado nolive. Ato atoꞌ niteꞌ do sotoꞌ neineꞌ nene nado do sotoꞌ nomolave. ");
INSERT INTO aso_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Me ve nene ha Maliaꞌ gipele kamuda minive ne neive. Olo. Idoꞌ Zakobole Zosele Zudale Simonile engiꞌ uvoꞌnibo neive. Alunolo nesi nene lezesi mela none. Neꞌmine li ingine muluꞌninguꞌ goloso gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Neꞌmine ikevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ i ngimaaꞌ ave polohete engikumuꞌ nene eveneꞌ mukiꞌ gilavo dizisa minaaꞌ naha engiꞌ misuboꞌninguꞌ aleve netesi engiꞌ zuho gihile lamineꞌ netesi idoꞌ engiꞌ numuꞌnine gihileuꞌ ingaaꞌ nave ingine netesi nene engikumuꞌ gilavo dizesaꞌmineꞌ neꞌminosa nazasi nouve lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Neꞌmine lo aꞌmida nene Oꞌmosoꞌmi amuzo do sotoꞌ ogo atoꞌ niteꞌ amilineꞌ ogavo initeꞌ gizi dave hamo hamokovoꞌ anadunuꞌ okoꞌnidoꞌ dokaꞌ dokaꞌ ogo do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aꞌmine numuda aleve ingine gili imamangumuꞌ nene gala mukiꞌ gilineꞌ. Neꞌmine ogavo aza numudoꞌ numudoꞌ mono monoꞌ lo-ngeme ngemeꞌ ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Neꞌmino mineꞌmo novo izipahala zuho tuvelu asi lo-ngemo sikalahuꞌ goloso ngimiseli hulilizave lo amuzo ngemo setaꞌ setaꞌ ngimiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nongimiselo tiꞌ lo lo-ngimineꞌ: Aka vilizada hatuso nene ha di vilizaha initeꞌ gohi mo di vamilo. Adoꞌ beleti nene di vami gokisi di vami monisi goꞌzi di vamilo. ");
INSERT INTO aso_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Suuꞌ nene ha izi vilisaha sioti nene setaꞌ izi vami hamokovoꞌ izi vilo. ");
INSERT INTO aso_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Idoꞌ neꞌminosasi ma lo-ngimineꞌ: Ebeꞌ mala igi ma nene numuno hamokukovoꞌ ingi mini aꞌmine ebeꞌ hulilizaniꞌ gamenelokovoꞌ gaꞌ li vilizave. ");
INSERT INTO aso_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Numuno maloꞌ nivavo lengeleꞌmize lamineꞌ ami gamazitine gilamavo ma nene lingine huli-ngidi vilisa niigi ma nene ingine engiꞌ monovoꞌine gililizangumuꞌ ve li avazaha igi gizedidotiꞌ uꞌmusupo nene okohoꞌ izi di huli vilo. ");
INSERT INTO aso_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Neꞌmine lavo ingine vi eveneꞌ mukiꞌ luꞌine di velepeꞌ izilizave li li sotoꞌ igi li-ngimiꞌmi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Neꞌmine iꞌmi nivi sikalahuꞌ goloso mukiꞌ eveneliti luꞌningutiꞌ ngimiseli huli initeꞌ ngisive mukiꞌ uveli noso hili-ngidi di lamineꞌ i-ngidaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Izesuꞌ guvele nene hutileꞌ ogo vavo guvelesi ve Helodeꞌ aza aꞌmine gamazi nesi gilineꞌ. Eveneꞌ linge malite Izesungumuꞌ tiꞌ li laniꞌ: Noso holo-ngedaaꞌ ive Zohaneꞌ ma nene hilingutiꞌ otave. Neꞌmo nene ato atoꞌ suno daaꞌ amuzo nene ezela neivosa ato atoꞌ suno nene nodaloseive. ");
INSERT INTO aso_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Neꞌmine laniꞌza ma nete gomuꞌ polohete Eliaꞌ ma ne neive likevo ma nete polohete gozopoꞌ minaniꞌ mautiꞌ neive laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Neꞌmine laniꞌza Helodeꞌ aza laniꞌ gamazi gelo tiꞌ lo lineꞌ: Neniꞌ luvono gituve Zohaneꞌ ma nene gohi ote noloseive. ");
INSERT INTO aso_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Idoꞌ Zohaneꞌnimuꞌ lineꞌ nene nemuꞌ lineꞌ ve: Gomuꞌ galaꞌmuda vomine Helodeꞌ aza akunolo Hilipoꞌ elenaho Helodiaꞌni gumine daniꞌ. Gumine davo monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ neꞌmo akunaꞌmi elenahine daineꞌ nene lisiheꞌ amive lo Helodeꞌni lo-emeꞌmo vo minineꞌ. Neꞌmine lo lo-emeꞌmo vo minivo nemuꞌ Helodeꞌ aza Helodiaꞌnimuꞌ ogo aꞌmine Zohaneꞌni nene vi dalizave lo eveneꞌ ma ngimiselavo vi analoꞌ di nalava imi eleꞌmizi di vi nalaꞌ numunguꞌ huli-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Idoꞌ Zohaneꞌ neꞌmine lo miningumuꞌ Helodiaꞌ aza Zohanengumuꞌ lukehe do mino bele helelesa gala gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Neꞌmine ineꞌza Zohaneꞌ aza ve lisiheꞌ mino goloso niteꞌ damaaꞌ ineꞌ monovoꞌvesi minineꞌ nemuꞌ gele mino ezemuꞌ ehelele izavo Helodeꞌ aza gizebo lamineꞌ o-dinako neꞌmo nene Helodiaꞌ Zohaneꞌni ngelo belamilineꞌ ineꞌ. Helodeꞌ aza Zohaneꞌ gamazi nene gamene gamene gelo gala setaꞌ gelaaꞌ ineꞌza ha gelo laniteꞌ gelaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Alingeꞌ Helodiaꞌ Zohaneꞌni belelineꞌ aka neꞌmino do sotoꞌ molaniꞌ: Helodeꞌ sotoꞌ ineꞌ gamene alitavo eveneꞌ naba guveꞌinesi ve ngamani gonoloꞌ hize eleꞌ i-daaꞌ avesi amiliti eveneꞌ nabaꞌ naba nesi nGalilaia misubokotiꞌ eveneꞌ nabaꞌ naba nesi elese molo ngemo nosoꞌ niteꞌ naba gize vataꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Neꞌmine igi ni nizavo Helodiaꞌ aluvo aza dizo eveneꞌ veꞌnidoꞌ nene aza ogaꞌ ineꞌ melengeni ogavo Helodekisi makaꞌ minavesi ngumo helavo guveꞌinesi ve Helodeꞌ aza aꞌmine alu nemuꞌ tiꞌ lo lineꞌ: Gaza initeꞌ mamuꞌ gelo lilineꞌ nene mo ha gemelesuve. ");
INSERT INTO aso_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Neꞌmine lo Oꞌmosoꞌmi veleloꞌ noluve lo lo huko tiꞌ lo lo-imineꞌ: Initeꞌ neꞌmine initekumuꞌ gele nouve lo lo-nemelineꞌ nene ha gemelesuve. Idoꞌ gizebo o nouvoniꞌ misubo nene hoꞌlo setaꞌ ogo lingela nemukisi lilineꞌ nene ha gemelesuve. ");
INSERT INTO aso_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lavo aza lemo izelehida tiꞌ lo longoꞌ ineꞌ: Nanitekumuꞌ lolove. Lavo izeleho aza tiꞌ lo lineꞌ: Monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ godolo mamuꞌ lozo. ");
INSERT INTO aso_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lavo liteꞌ lo guvelesi ve neida dizo tiꞌ lo lineꞌ: Monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ godolo nene gito lapeseuꞌ molo nemeline losa noluve. ");
INSERT INTO aso_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Neꞌmine lavo guvelesi ve nene geni bilineꞌza eveneꞌ veꞌnidoꞌ Oꞌmosoꞌmi veleloꞌ lo hukineꞌ nenako nemuꞌ nene aza gamaziꞌne lemalive lo gelo ");
INSERT INTO aso_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","liteꞌ lo pilisi ve hamoꞌ ma godolo gito do alive lo imiselavo vo galapuso numunguꞌ luvono gito ");
INSERT INTO aso_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","godolo nene lapeseuꞌ molo do ogo alungo nene emavo aza do izelehine imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Neꞌmine ogavo Zohaneꞌ izipahala zuho ingine gili igi okoꞌnola di vi geheni mulikuꞌ galese izi-daniꞌ ve. Helodeꞌ aza Zohaneꞌni nene neꞌmino bele helaniꞌ nenako Helodeꞌ aza Izesuꞌ guvele nene gelosa aꞌmine bele hiluve Zohaneꞌ nene gohi ote noloseive lo gelosa neꞌmine lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Izipahala zuhoutiꞌ ngimiselive aposolo ingine Izesuda tineꞌ mili igi initeꞌ aniꞌ idoꞌ monoꞌ li-ngimaniꞌ nemuꞌ nene veteteꞌ igi li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Neꞌmine ikevo eveneꞌ mukiꞌ ingine engita igi vigi igi nizavo nosoꞌ niteꞌ nalizaniꞌ gamenesi ivileꞌ ogavo nemuꞌ Izesuꞌ tiꞌ lo lo-ngimineꞌ: Laꞌlisetevoꞌ vo eveneꞌ nizamada haza guviseloꞌ mine gelo minelone. ");
INSERT INTO aso_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lavo sipiuꞌ angiseꞌinevoꞌ dizi eveneꞌ nizamada haza guvisela vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aꞌmida olihe nivavo eveneꞌ mukilite ningi engiꞌ nizave li ningi tauni mukikutiꞌ misubouꞌ lotiꞌ izi vi gomuꞌ hetelaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Vi hetelikevo Izesuꞌ sipiutiꞌ nolemo eveneꞌ vaiꞌ di geseꞌ igi nizavo ningo ingine nene sipisipi izeloꞌ gizebo ogaꞌ ive ma nomivo gopo monaaꞌ naniꞌ neꞌmine igi minikevo engikumuꞌ muluno hukavo apiꞌ ogo initeꞌ mukiꞌ apize ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Neꞌmine ogo neivo hoꞌ nene lemo vavo izipahala zuho ezela igi tiꞌ li laniꞌ: Mene ebeꞌ nene eveneꞌ nizamaniꞌ hadiveloꞌ nonivo litiꞌmuso gamene alitanaze. ");
INSERT INTO aso_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gaza eveneꞌ mene ngimiselanivo vi avitoꞌ luhuvo numudasi hazalatikisi moni naliza nosoꞌ niteꞌine meni hizilizaze. nGimiselezo. ");
INSERT INTO aso_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Likevo Izesuꞌ aza lo-ngimineꞌ: Lengiꞌ nene nosoꞌ niteꞌ di ngimilevo. Lavo ingine tiꞌ li li-imaniꞌ: Laza vo moni fo hadeti Kina (K400) neꞌminedunuꞌ beleti meni hizo mene aleve nalizave lo ngemekunivo ngelo vo dalihe. ");
INSERT INTO aso_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Likevo aza tiꞌ lo lineꞌ: Linginela sikoni nanikeꞌ neve. Vi ningilo. Lavo vi ningi tiꞌ li laniꞌ: Lezela sikoni faefusi (5) alahaꞌ setakisi neive. ");
INSERT INTO aso_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Likevo guvise laminetoꞌ ve hizi hizi minilizave lo lo-ngemavo ");
INSERT INTO aso_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ve hizi di duvaaꞌ lomaaꞌ aniꞌ nene linge ma eveneꞌ hadeti (100) neꞌmine minikaꞌ minikaꞌ ikevo linge ma nene eveneꞌ fifti (50) neꞌmine minikaꞌ minikaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tiꞌ igi nizavo sikoni faef nesi (5) alahaꞌ sitaꞌ nesi nene do Okulumota vonuꞌ noogo Oꞌmoso opoꞌni lo aꞌmine sikoni nene gito apilo izipahala zuho nete izeꞌ mili eveneꞌ ngimilizave lo ngemo alahaꞌ setakisi do gito izeꞌ molo mukitoꞌ ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","nGemavo eveneꞌ mukitoꞌ ni gatuꞌine aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Gatuꞌine ogavo sikonisi alahakisi lumo hulaniꞌ nene gizekaꞌ igi gosuvahaꞌ tuvelu (12) neꞌmine mili vaiꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nosoꞌ niteꞌ naniꞌ nene vemohoꞌ faif tauseni neꞌminelite naniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Idoꞌ eveneꞌ nene nosoꞌ niteꞌ ni osuꞌ likevo Izesuꞌ aza izipahala zuho nene sipiuꞌ dizi noso hela hole Betesaida numuda gomuꞌ nivilizave lo liteꞌ lo ngimisele hulosa aza nene eveneꞌ mukiꞌ numuꞌnida ngimisele hulolosa ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Neꞌmino mino gekeꞌvokeꞌ lo hulo-ngedo aza Oꞌmosola lolosa golola dizo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Neꞌmine ogavo litiꞌmuso izavo izipahala zuho vaniꞌ sipi nene noso olusoꞌ minavo Izesuꞌ aza asiꞌvevoꞌ misubola haza mino ");
INSERT INTO aso_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ningineꞌ nene hepeꞌ neꞌmo vilizaniꞌ akalatiꞌ adiꞌmo izipahala zuho ingine sipi di vaaꞌ aniꞌ gavosodunuꞌ nene sipi di vilisa geꞌnebe goloso igi minaniꞌ nene ningineꞌ. Nemuꞌ nene goꞌ loꞌmo lomo nedengaꞌ fo kiloku he faif kiloku he nela nene noso avileloꞌ lise lise vo nizada hetelo ngivileꞌ ogo volosa ineꞌza ");
INSERT INTO aso_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","noso avileloꞌ lise lise novivo ingine mukitoꞌ ningi golise goloso gilisa holoso ve li gili gekeꞌ gekeꞌ laniꞌ. Gekeꞌ laniꞌza aꞌmidoꞌ geto Izesuꞌ gamazi lo-ngemo tiꞌ lo lo-ngimineꞌ: Neniꞌ ma ne nouze. lengehelele izamivo mini ngi li minilo. ");
INSERT INTO aso_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Neꞌmine lo sipiuꞌ dizo nizada minineꞌ. Dizo nominivo hepeꞌ nene matineꞌ. Matavo nemuꞌ ingine gopo gaꞌine goloso gilaniꞌ. Gopo gaꞌine goloso gilaniꞌ nene Izesuꞌ nosoꞌ niteꞌ ngimineꞌ gameneuꞌ nene eze monovo ma ningadiniko hepeꞌ matineꞌ nemuꞌ nene gopo gaꞌine goloso ma gilamadineꞌza gaꞌine ngoloꞌ lamivo eze monovo olihe ningami minaniꞌ nenako neꞌmo nene gopo gaꞌine goloso gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Neꞌmine igi noso helala vii nGenesalete misubouko heteli sipi nene noso gahevela naꞌnava iziki ");
INSERT INTO aso_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","sipiutiꞌ limikevo eveneꞌ nete liteꞌ li eiꞌ ve li ningi gili ");
INSERT INTO aso_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","aꞌmine misubouꞌ numuno mineꞌmo monida nene lotiꞌ izi vi initeꞌ gizi dave holomoloꞌ ingi minaniꞌ nene zaloꞌ mili Izesuꞌ neive li laniꞌ ebeta ebeta nene ngeleꞌmizi di vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Idoꞌ Izesuꞌ taunila vihe luhuvo numuda vihe hazala vihe aꞌmida vida vida miniꞌmi monave nete initeꞌ gizi dave nene ngeleꞌmizi di igi maketi ebeꞌine minida minida huli-ngidikaꞌ huli-ngidikaꞌ igi amuzo mili tiꞌ li li-imaniꞌ: Okongala initeꞌ lolovolokovoꞌ nevosi di gililizadotikisi nene lamineꞌ ilizaniꞌ nenako nemuꞌ nene gele ngemanivo di gililizave li laniꞌ. Idoꞌ okoꞌnoloꞌ initeꞌ lolovoloꞌ di gilave mukiꞌ nene mo lamineꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Halisaioꞌ eveneꞌ masi Zelusalemi numudatiꞌ avoꞌningeliti monoꞌ gamazi apizi ngimaaꞌ ave linge masi Izesuda vi di geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Neꞌmine ikevo izipahala zuho linge nete aꞌine di lamineꞌ ami nosoꞌ niteꞌ ninavo ninganiꞌ. Aꞌine di lamineꞌ amave laniꞌ nene Halisaioꞌ eveneliti monovoꞌnidoꞌ eꞌmeti aꞌine noso izamaniꞌ nemuꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Halisaioꞌ evenekisi Zuda ve mukikisi nene avoꞌningeliti monovoꞌnidokovoꞌ gili di lute goloduvo elo minalive li aꞌine di atoꞌ igi noso izisavoꞌ nosoꞌ niteꞌ naaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Idoꞌ nosoꞌ niteꞌ maketilotiꞌ meni hizi di igi ma noso izisavoꞌ naaꞌ nave. Idoꞌ nevoꞌ nomive. Avoꞌningeliti monovoꞌine ato atoꞌ gohi masi masi neineꞌ nene gili daaꞌ nave. Aꞌmingutiꞌ ma nene kapusi somosi idoꞌ vapa lapesesi nene monoꞌinemuꞌ gili nosouꞌ izaaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Idoꞌ Halisaioꞌ evenekisi Zuda veti avoꞌningeliti monoꞌ gamazi apizi ngimaaꞌ avesi Izesuꞌni tiꞌ li longoꞌ i-di laniꞌ: Geiꞌ izipaha zuho nene avotemotidatiꞌ do noneꞌ monoꞌ gamaziloꞌ eꞌmetami mini aꞌmine gamaziliꞌmo lidoꞌ igi aꞌine nosoꞌ izami ha goloduvo ize minivo nosoꞌ niteꞌ di naaꞌ naniꞌ nene nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Neꞌmine likevo Izesuꞌ nene tiꞌ lo lo-ngimineꞌ: Lengemeni dameni goloso di haleki eveneꞌ lamineꞌ gili monaaꞌ nave lengikumuꞌ Isaiaꞌ lineꞌ ma nene lamineꞌ laaniꞌ neive. Aza tiꞌ lo gize neive: Me aleve nete veꞌine avilelotiꞌ neniꞌ guliveꞌne di hozi li minaaꞌ naniꞌza luꞌine nene nezela milamavo luꞌineꞌve nene hotoꞌ minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Haza eveneliti gamazi nene neze gamazi gidini loloꞌ ogavo li-ngimi ngimiꞌ igi minaaꞌ naniꞌ nenako neꞌmo nenikumuꞌ nopoꞌni laaꞌ naniꞌ nene gopo hazamuꞌ laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lingine Oꞌmosoꞌmo louꞌ gamazi lo huko-lingidineꞌ ma nene huli eveneliti monovoꞌine nene di giliꞌ li minaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Neꞌmine losa tiꞌ lo lo-ngimineꞌ: Lengiꞌ nene avotingidatiꞌ monovo do minelone li Oꞌmosoꞌmi louꞌ gamazi izi hulatoꞌ nene otohato ve gehepeve minikeve. ");
INSERT INTO aso_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Neꞌmine noluvoniꞌ mene lingine tiꞌ igaꞌ angumuꞌ noluve: Moseꞌ aza ma tiꞌ lo lave: Lingine izetingine metinginemuꞌ gilavo dizavo gelekeleꞌ lamineꞌ i-ngidivoꞌ minilo. Idoꞌ ma nene ve maliꞌmo izelehingi melehingi gamazi goloso lo-ngedelineꞌ nene mo bilikevo helelive. ");
INSERT INTO aso_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Neꞌmine lo lineꞌza lingine aꞌmine lineꞌ gamaziloꞌ eꞌmetilizaniꞌ aka nene tiꞌ igi hizi tilaaꞌ nave: Eveneꞌ malite engiꞌ izeꞌninginemuꞌ nehe meꞌninginemuꞌ nehe tiꞌ li li ngimaaꞌ nave: Lengiꞌ hize eleꞌ o-lengedo lengemeloneꞌ o minineꞌ initete nene kolobani initeꞌ loloꞌ oganiꞌ nenako ma lengemamolosune. Idoꞌ Kolobani initeꞌ loloꞌ ogave laniꞌ neꞌmi monovo nene neꞌmino neive: Oꞌmosoꞌmine molo-dekunivo mo eiꞌ initeꞌve loloꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Idoꞌ neꞌmine laniꞌ neꞌmo nene alingeꞌ izeꞌningine meꞌningine hizi eleꞌ ilisa ikevo ma lingine oꞌve li-ngidikevo izeꞌningine meꞌningine gelekeleꞌ lamineꞌ i-ngidivoꞌ minilo lo Moseꞌ lineꞌ gamaziloꞌ eꞌmetilizaniꞌ aka nene hize tilaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Neꞌmine ogavo lingine lengiꞌ monovotine nene Oꞌmosoꞌmi gamaziloꞌ di medeli apizi ngimaaꞌ naniꞌ neꞌmo nene Oꞌmosoꞌmi gamazi do haza niteꞌ loloꞌ o-daaꞌ neive. Idoꞌ nevoꞌ nene nomive. Linginela neꞌmine monovo nene mukiꞌ minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Neꞌmine lo Izesuꞌ eveneꞌ mukiꞌ gohi asi lo-ngemo tiꞌ lo lo-ngimineꞌ: Naza gamazi lo-lengemekuvo mukitoꞌ gili gili ngoloꞌ lilo. ");
INSERT INTO aso_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Initeꞌ naanivo mulungauko lemaaꞌ neineꞌ initeꞌ neꞌmo nene luka do goloso o-damoloseive. Lukatiꞌ dizaaꞌ neineꞌ neꞌmo nene luka do goloso o-daaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tiꞌ lo lo-ngemo eveneꞌ hulo-ngedo numunguꞌ dizavo izipahala zuho nete aneza gamazimuꞌ longoꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Longoꞌ i-dikevo tiꞌ lo lo-ngimineꞌ: Haza aleve aniꞌ neꞌmini linginesi olihe gili guni amahe. Initeꞌ ma nalineꞌ neꞌmo nene lukauꞌ vo holamo gatungauꞌ lemo ise galeseuꞌ vaaꞌ neinako luka ngelo do goloso amoloseive. Nemuꞌ nene gili lamineꞌ amahe. Neꞌmine lineꞌ nene nosoꞌ niteꞌ mukiꞌ nete lute di goloso amilisanako ha nalosune losa lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Neꞌmine lo gohi mesi lineꞌ ve: Lutingutiꞌ dizaaꞌ neineꞌ initeꞌ neꞌmovoꞌ nene lutine do goloso o-lengedaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Naza neꞌmine noluvoniꞌ nene lutingutiꞌ goloso niteꞌ neꞌminosa dizaaꞌ neingumuꞌ luvoniꞌ ve: Adoꞌ gatine goloso gilaaꞌ idoꞌ umungive alungo gopo ingi monaaꞌ idoꞌ gumine damine ogaꞌ idoꞌ eveneꞌ ngebele helaaꞌ ");
INSERT INTO aso_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","idoꞌ veneꞌ vemohoꞌ liliꞌ ikeniꞌ nene gopo ingi monaaꞌ idoꞌ initekumuꞌ lumo helepeleꞌ ogaꞌ idoꞌ monovo do goloso ogaꞌ idoꞌ goꞌine izo gosohoꞌ nasahaꞌ laaꞌ idoꞌ zogo zogo peleseveꞌ izaaꞌ idoꞌ ve maliti initekumuꞌ mumuzoꞌ ogo lukehe ngebelaaꞌ idoꞌ eveneꞌ dovo ledevoꞌ ogo ngemenga laaꞌ idoꞌ hokolizeꞌ igi okodine di dizaaꞌ idoꞌ dingani hizo minaaꞌ ");
INSERT INTO aso_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","neꞌmine initeꞌ goloso mukiꞌ neꞌmo nene lutingutiꞌ dizaaꞌ neineꞌ nenako neꞌmo nene lutine do goloso ogaꞌ neive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Neꞌmine ogo aza aꞌmine ebeꞌ hulo oto Tilo misubouꞌ ebeꞌ nabala vineꞌ. Vo numuno mauꞌ dizo eveneꞌ hamolitesi mela nouvongumuꞌ nene gilikelizave lo gilineꞌza aza ngelo halekilineꞌ amineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Neꞌmine neivo veneꞌ maliꞌmi aluvo neꞌmi lulouꞌ nene sikalahuꞌ golosoliꞌmo dizo minavo veneꞌ neꞌmo Izesuꞌ guvele nene gelo liteꞌ lo ogo gizeneuꞌ gubiꞌ ize imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aꞌmine veneꞌ nene Zuda veneꞌ nevoba Silia misuboꞌmi gahevela Hoinikia alevetingutiꞌ sotoꞌ ogo mino nGiliki aleveti monovoꞌnidoꞌ eꞌmeto minineꞌ veneꞌ neꞌmo nene eiꞌ aluvoꞌmi luloutiꞌ sikalahuꞌ goloso nene imisele hulilive lo amuzo molo lo-imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lo-emavo Izesuꞌ aza aneza gamazi ma tiꞌ lo lo-imineꞌ: Izipeliti nosoꞌ niteꞌ nene ipeꞌ ogo gulo ngemaaꞌ nene edamive. Oꞌmosoꞌmi izipahala Isilaeleꞌ aleve do lamineꞌ o-ngedaaꞌ nouvoniꞌ nenako geiꞌ heta atoꞌ veneꞌ do lamineꞌ o-gedeloniꞌ nene edamoloseive losa gele nouve. Nemuꞌ nene nosoꞌ niteꞌ nene aꞌmine izipe nete ganaꞌ nalisave. ");
INSERT INTO aso_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tiꞌ lo lavo aꞌmine veneliꞌmo Izesuꞌ gamaziꞌveloꞌ do velepeꞌ izo tiꞌ lo lo-imineꞌ: Guvekasi ve gaza lamineꞌ laineꞌza izipelite nosoꞌ niteꞌ nangutiꞌ lana ngomo tevolilotiꞌ doꞌmozineꞌ nene aꞌmine tevoliꞌmi sebenguꞌ minaaꞌ aniꞌ gulo nete ha naaꞌ nave. Nemuꞌ nene ha gele nemelesane. ");
INSERT INTO aso_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lavo Izesuꞌ lo-imineꞌ: Tiꞌ lo laningumuꞌ nene gele gemekuve. Numungala vozo. Sikalahuꞌ goloso nene mo aluva hulo-do vave. ");
INSERT INTO aso_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lavo numuꞌvela vo ningineꞌ nene sikalahuꞌ goloso aza hulo-do vavo izipe nene holomoloꞌ ongo neivo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Neꞌmine ogavo Tilo ebekutiꞌ tineꞌ molo vo Sidoni ebeꞌ hulo vo Dekapoli misubo ivileꞌ ogo nGalilaia noso ohuda vo hetelineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Vo hetelavo gala molave gamazi lo guno amive nene eleꞌmizi Izesuda igi anadunuꞌ okoꞌnoloꞌ do geleliho li agae li li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Li-imikevo vo eveneꞌ nizamanguko eleꞌmize molo ana nedunuꞌ gala lulouꞌ molo gituhoꞌ ogo vele nahunoloꞌ do gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Do gelo Okulumota vonuꞌ ogo leꞌ izo tiꞌ lo lo-imineꞌ: Ehata, leliꞌ gamaziutiꞌ nene ngoloꞌ lozo losa ve. ");
INSERT INTO aso_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lavo geto gala ngoloꞌ lavo vele nahuno nene do velepeꞌ izavo gamazi nene lo lamineꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Neꞌmine ogavo eveneꞌ mukikumuꞌ nene aꞌmine gamazi nene li sotoꞌ amilizave lo lo huko-ngidineꞌza li sotoꞌ ikevo aza gohi oꞌve lo-ngedekaꞌ lo-ngedekaꞌ neivo ingine di naba ikaꞌ ikaꞌ igi li sotoꞌ ikaꞌ ikaꞌ iꞌmi vi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Idoꞌ ingine amuzo mili siza li mini tiꞌ li laniꞌ: Aza initeꞌ mukiꞌ oꞌmo vineꞌ nene mo laminekovoꞌ oꞌmo vave. Aza lavo gaꞌine molave ingine gamazi gohi nigilavo gamazi lamilizadoꞌ i minave netesi nene gamazi ha nilave. ");
INSERT INTO aso_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aꞌmine gameneuꞌ nene eveneꞌ mukiꞌ gohi igi di geseꞌ igi nosoꞌ niteꞌ nomivo nizavo Izesuꞌ aza izipahala zuho asi lo-ngemo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Mene aleve nene nazasi gamene sitohamo makaꞌ minunidiꞌmo nosoꞌ niteꞌinesi nomivo engikumuꞌ muluꞌne hukave. ");
INSERT INTO aso_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nosoꞌ niteꞌ namavo numuꞌnida ngimiseleloniꞌ nene akala vilizada veꞌine gaꞌine monavo diꞌmozilisave. Linge ma nene aka hotatiꞌ nizave. ");
INSERT INTO aso_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lavo izipahala zuho ingine di velepeꞌ izi tiꞌ li li-imaniꞌ: Ebeꞌ hadiveloꞌ mene eveneꞌ mukiꞌ mene nosoꞌ niteꞌ nadiꞌ ogo ngemelone. Nosoꞌ niteꞌ daloneꞌ akate nene ma nomive. ");
INSERT INTO aso_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Likevo aza longoꞌ o-ngedo lineꞌ: Linginela sikoni nanikeꞌ neve. Longoꞌ ogavo seveni ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ingine likevo eveneꞌ mukiꞌ misuboloꞌ minilizave lo lo-ngedo sikoni seveni nene do Oꞌmoso opoꞌni lo apilo izeꞌ mili eveneꞌ ngimilizave lo izipahala zuho ngemavo ingine izeꞌ mili eveneꞌ mukiꞌ ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Alahaꞌ ngomo ngomo ngomosiꞌ minineꞌ nesi nene do oꞌmosola lo aꞌminesi eveneꞌ ngimilizave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Neꞌmine ogavo ni gatuꞌine aniꞌ. Neꞌmine igisa lumo hulaniꞌ nene gizekaꞌ igi gosuvahakuꞌ milikevo gosuvahaꞌ seveni vaiꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nosoꞌ niteꞌ nave nene fo tauseni (4,000) neꞌmine minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Idoꞌ eveneꞌ nene ngimisele hulo aza nene izipahala zuhosi geti sipiuꞌ dizi Dalamanuta misubouko vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vi nizavo Halisaioꞌ eveneꞌ ingine igi ezesi gamazi gono di mini eiꞌ nene nimiselive Oꞌmoso aza nenikisi neive lineꞌ nene lamineꞌ lihe gosohoꞌ lihe nemuꞌ Oꞌmosoꞌmo amuzo emavo atoliꞌmine suno do sotoꞌ ogavo ningelone li emenguꞌ mili laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Neꞌmine ikevo lulouko agae lo gelo tiꞌ lo lineꞌ: Laminetoꞌ Oꞌmosoꞌmi amuzo gezela neingumuꞌ nene gele eleꞌvoleꞌ oloningisi atoliꞌmine suno do sotoꞌ oganivo ningelone li idise mene gameneloꞌ nizave lingine laaꞌ naniꞌ nene nanimuꞌ laaꞌ nave. Naza mo laminetoꞌ lo-lengemeloze. Idise gameneloꞌ nizaniꞌ aleve mene atoliꞌmine suno neꞌmine nene mo kekeꞌ lengelebizamolosuve. ");
INSERT INTO aso_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Neꞌmine lo hulo-ngedo sipiuꞌ dizo noso ohuno helala volosa aka apiꞌ ogo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Idoꞌ izipahala zuho nene beletimuꞌ gaꞌine molavo ma di vamavo beleti inginela ma minamidineꞌza hamokovoꞌ nene sipiuꞌ ma minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Neꞌmini nivavo Izesuꞌ aza eveneꞌ maliti ngemeni dameni golosomuꞌ beleti do lulu izaaꞌ ineꞌ initeꞌ zisitiloꞌ nene aneza gamazi lo molo tiꞌ lo hungoꞌ molo lo-ngimineꞌ: Halisaioꞌ monoꞌ laaꞌ avelatikisi idoꞌ Helodedatikisi zisiti nene dikelizave. Nemuꞌ ningisa minilo. ");
INSERT INTO aso_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Neꞌmine lo lo-ngemavo ingine li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Laza beleti ma do amuneꞌ nenako nemuꞌ lave. ");
INSERT INTO aso_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Likevo gelo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Beleti di amaniꞌ nemuꞌ nene nanimuꞌ li voleloꞌ meloꞌ nave. Lingine olihe gili lamineꞌ amahe. Lutineꞌmi gala nene ngoloꞌ lamihe. ");
INSERT INTO aso_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Vetine neineꞌza ningamahe. Gatine neineꞌza gilamahe. Gomuꞌ nene eveneꞌ faef tauseni (5,000) engikumuꞌ sikoni faef do gito apilo ngemekuvo nikevo lingine sikoni lumosama nedunuꞌ nene gosuvahaꞌ nanikeꞌ goꞌzi vaiꞌ laniꞌ neve. Nee mamuꞌ gatine molahe. Neꞌmine lavo ingine tiꞌ li laniꞌ: Gosuvahaꞌ tuvelu (12) ve ");
INSERT INTO aso_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","likevo gohi tiꞌ lo lineꞌ: Idoꞌ eveneꞌ fo tauseni (4,000) engikumuꞌ sikoni seveni gito apilo ngemekuvo nikevo lingine sikoni lumosama hulaniꞌ nene gosuvahaꞌ nabaꞌ naba nanikeꞌ goꞌzi vaiꞌ laniꞌ neve. Lavo ingine gosuvahaꞌ nabaꞌ naba seveni ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Neꞌmine likevo aza tiꞌ lo lo-ngidineꞌ: Idoꞌ lingine aꞌmine nemuꞌ mo gili minaniꞌza monovoꞌvemuꞌ nene olihe gili lamineꞌ ami naza beletimuꞌ lokuvosa nilahe. ");
INSERT INTO aso_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nelotiꞌ nene vi Betesaida numuda hetelaniꞌ. Hetelikevo aꞌmida nene ve ma vele likive Izesuda eleꞌmizi igi okoꞌnoloꞌ do gelelive li muheleka li longoꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Longoꞌ i-dikevo aza vele likiveꞌmi analoꞌ do numuno ebeꞌ heta vo veleuꞌ gituhoꞌ ogo holo-do ana hitosa tiꞌ lo longoꞌ o-dineꞌ: Initeꞌ noningabe. ");
INSERT INTO aso_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Longoꞌ o-davo aza vokeneꞌ ogo ningo tiꞌ lo lineꞌ: Eveneꞌ za gili vaniꞌ nene nimonavo noninguve. ");
INSERT INTO aso_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lavo Izesuꞌ aza ana veleloꞌ gohi hitavo ve aza vele do guno ningavo vele nene lamineꞌ ogavo initeꞌ mukiꞌ ningo ninge ngoloꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Vele lamineꞌ ogavo numuꞌvela imiselo tiꞌ lo lo-dineꞌ: Luhuvo numuda nene vamo geiꞌ numungala vo minezo. ");
INSERT INTO aso_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Idoꞌ nelotiꞌ nene Izesuꞌ aza izipahala zuhosi Kaesalea Hilipi ebeta luhuvo numuno minekaꞌ minekaꞌ idoꞌ vaniꞌ. Akaloꞌ olihe nivi Izesuꞌ aza izipahala zuho tiꞌ lo longoꞌ o-ngidineꞌ: Eveneꞌ ingine nene nezemuꞌ zaho ve li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Longoꞌ o-ngedavo ingine tiꞌ li li-imaniꞌ: Eveneꞌ ma nete nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ nene hilingutiꞌ otosa noloseive li laaꞌ nave. Idoꞌ linge ma nete nene gozopoꞌ polohete Eliaꞌ aza gohi sotoꞌ oloseive lave ma nene tineꞌ molo abe li laaꞌ nave. Idoꞌ linge ma nete nene gomuꞌ minaniꞌ polohete hilaniꞌ linge engitatiꞌ otanive nolibe li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Neꞌmine likevo Izesuꞌ aza gohi tiꞌ lo longoꞌ o-ngidineꞌ: Idoꞌ ingine nene mo neꞌmine laaꞌ naniꞌza lingine nenikumuꞌ nene zaho neve li laaꞌ nave. Neꞌmine lavo Petoloꞌ aza tiꞌ lo lineꞌ: Gaza nene Oꞌmosoꞌmo do luꞌ izeline lo gimiselelesa lo huko-gidive ma nene nane. ");
INSERT INTO aso_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Neꞌmine lavo ingine eveneꞌ masi masi aꞌmine monovoꞌvemuꞌ li-ngimikelizave lo lo huko-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Neꞌmine ogo Izesuꞌ aza apiꞌ ogo gamazi tiꞌ lo apize ngemeꞌmo vineꞌ: Neniꞌ gono neꞌmo gihileꞌve do sotoꞌ ilingumuꞌ Oꞌmosolatiꞌ ve gihile neniꞌ nene mulumo gono naba geho helosa gohi otelodoꞌ o neineꞌ nenako monoꞌ gizebo vesi evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi daaꞌ ave nabasi idoꞌ Zuda vete gozopotatiꞌ laaꞌ aniꞌ monoꞌ apizi ngimaaꞌ ave nesi ingine meheꞌine nimi mulumo niteꞌ mukiꞌ nimii nibili hilikevo helosa gamene seto hamo mino otelesuve. ");
INSERT INTO aso_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Neꞌmine lo aꞌmine gamazi nene lo lamino lo sotoꞌ ogosa lo ngoloꞌ lo lo-ngimineꞌ. Neꞌmine lo lo-ngemavo Petoloꞌ aza eleꞌmize gahevela ogo helelineꞌ gamazi lingumuꞌ nene elemelesa ineꞌza ");
INSERT INTO aso_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Izesuꞌ mine velepeꞌ izo izipahala zuho vonuꞌ ngebelo Petoloꞌni elemo tiꞌ lo lineꞌ: Gaza gaka gele naineꞌ nene Oꞌmosoꞌmo gilidiꞌmino gelamo asi me misubouꞌ vete gilaaꞌ adiꞌmino gele nange. Satani gaza akaꞌne hize tilamo olovoꞌ ozo. ");
INSERT INTO aso_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tiꞌ lo eveneꞌ mukikisi izipahala zuhosi asi lo-ngedavo ezela igi di geseꞌ ikevo tiꞌ lo lo-ngimineꞌ: Ve ma ingine neniꞌ neꞌmeto alone li gilii ma gomuꞌ nene engiꞌ minevoꞌ alevoꞌine gizebo igaꞌ naniꞌ monovoꞌine nene huli alami neniꞌ neꞌmetilizangumuꞌ ve goloso nizave li lohotoꞌ zaloꞌ ngibili hililizangumuꞌ nene gili hulisa neꞌmeti alizave. ");
INSERT INTO aso_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Idoꞌ neꞌmine igisa neꞌmeti alizave lo noluvoniꞌ nene nanitekumuꞌ luhe. Lingine mene gililo: Ve ma ingine neniꞌ neꞌmeteloneꞌ nene geni initeliꞌmi lulouꞌ vo minevoꞌ alevote hulalone li neꞌmetamilizave nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ma damilisave. Damilisaha ve ma ingine neniꞌ gamaziꞌne lamineꞌ nene gili gili eleꞌvoleꞌ igi neꞌmetilizangumuꞌ ngibili hilikevo minevoꞌ alevoꞌine hulilizaniꞌ nene alingeꞌ minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ha dalisave. ");
INSERT INTO aso_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ee, eveneꞌ ma ingine minevoꞌ minevoꞌ minaaꞌ ngemeni dameni ma hulilizaniꞌ nene aꞌmine ngemeni dameni gohi do engita olone li aꞌmidoꞌ golo hizilizaniꞌ initeꞌ nene hamokisi ma minamoloseive. Nemuꞌ nene eveneꞌ ma ingine misubouko mene minevoꞌ alevoꞌ igi mini misubouꞌ initeꞌ vaiꞌ nene di engita igi minilizanguꞌ nene minevoꞌ minevoꞌ minaaꞌ ngemeniꞌine hulilizaniꞌ nene aꞌmine initeꞌ vaiꞌ nete nene ma hize eleꞌ i-ngidamilisave. ");
INSERT INTO aso_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Idoꞌ me misubouꞌ minevoꞌ alevoꞌinemuꞌ gili neniꞌ neꞌmetamilizave nene ingine minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ma damilisave noluvoniꞌ nene ve ma ingine libilikevo minevoꞌ alevote hulalone li aꞌmine Oꞌmoso huli lihime daaꞌ akaloꞌ vaaꞌ naniꞌ aleve engiꞌ vovoꞌninguꞌ nene neniꞌ gamaziꞌne hize eleꞌ ogaꞌ unive neniꞌ evenele none lilisa ngovozo hililizaniꞌ nene Oꞌmosolatiꞌ ve gihile naza meꞌnehi amuzo do tiꞌ ogo eiꞌ angeloꞌ vesi aloneꞌ gamenela aꞌmine alevemuꞌ nene neniꞌ eveneꞌne nizave lolosa ingine adiꞌmino novozo helo lamuvo minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ma damilisave. ");
INSERT INTO aso_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Neꞌmine lo imineꞌ molo tiꞌ lo lo-ngimineꞌ: Lamineꞌ ma lo-lengemeloze. Meloꞌ nizave lengikutiꞌ linge ma nene hilami ha nizavo Oꞌmosoꞌmo gizebo o-ledaaꞌ monovo nene amuzoꞌvesi sotoꞌ ogavo ningilisave. ");
INSERT INTO aso_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Idoꞌ gamene sigisi ogo vavo Izesuꞌ aza Petoloꞌni ve Zakoboꞌni ve Zohaneꞌni ve nene golo haꞌnaloꞌ ngeleꞌmizo dizavo aꞌmida engikovoꞌ mini ningi nizavo eiꞌ okoꞌno do atoliꞌmine ogavo ");
INSERT INTO aso_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","geneganaꞌve nene silingengeꞌniꞌve hulo mokonoꞌ goloso elo minineꞌ. Aꞌmine mokonoꞌ ilineꞌ neꞌmine nene me misubouko eveneꞌ hamoliꞌmosi ngelo ma do sotoꞌ amoloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Neꞌmine neivo Eliaki Moseki sotoꞌ igi Izesulesi gamazi li voleloꞌ meloꞌ igi nizavo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Neꞌmine igi nizavo Petoloꞌ aza Izesuꞌni tiꞌ lo lo-imineꞌ: Tisazo, makaꞌ meloꞌ minuneꞌ nene lamineꞌ ogave. Nemuꞌ nene azibe sitohamo ma gizelone. Ma nene geiꞌ ve idoꞌ ma nene Moseꞌni ve idoꞌ ma nene Eliaꞌni ve. ");
INSERT INTO aso_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Golise naba gili minaniꞌ nenako nemuꞌ Petoloꞌ aza nadive lolove lo gamazi gopo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lavo limusoliꞌmo ogo molo hite-ngedavo limuso luloutiꞌ Oꞌmosoꞌmi nolo ma tiꞌ lo sotoꞌ ineꞌ: Me ve nene neniꞌ gipeꞌne luꞌne eme nouvoniꞌ nenaze. Eze gamaziꞌve gili dalo. ");
INSERT INTO aso_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tiꞌ lavo aꞌmidoꞌ liteꞌ li velepeꞌ izi ninganiꞌ nene ve masi minamaniꞌza Izesukovoꞌ neivo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Neꞌmine igi gololotiꞌ limi ada nene Izesuꞌ tiꞌ lo lo huko lo-ngimineꞌ: Initeꞌ ninganiꞌ nene veteteꞌ igi li-ngimami nizavo Oꞌmosolatiꞌ ve gihile naza helo otekuvo ma nene ha li-ngimilizave. ");
INSERT INTO aso_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lavo lineꞌ gamazi gili di li sotoꞌ ami mini hilingutiꞌ otelineꞌ gamazi lineꞌ nemuꞌ nene monovo viseꞌ igi li voleloꞌ meloꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Idoꞌ tiꞌ li longoꞌ i-daniꞌ: Do luꞌ izelive lo Oꞌmosoꞌmo do kegeso imiselelesa live nene aꞌmine gozopoꞌ minineꞌ polohete Eliaꞌ neꞌmo gomuꞌ molo-do tineꞌ molo aloseive li avotemoti monoꞌ gamazi apizi limaaꞌ avete laaꞌ naniꞌ ma nene nanimuꞌ laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Neꞌmine li longoꞌ i-dikevo aza tiꞌ lo lo-ngimineꞌ: Initeꞌ mukiꞌ do veveselesa Eliaꞌ gomuꞌ aloseive laniꞌ nene mo laminetoꞌ laniꞌ ve. Neꞌmine aniꞌza ve gihile neniꞌ nene mulumo niteꞌ nimi goboni mili-nidilisave li polohetelite nenikumuꞌ ma nene nadive li gizi nizaniꞌ neve. ");
INSERT INTO aso_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Neꞌmine lo monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ nene Eliadoꞌ medelo minineꞌ nemuꞌ gililizave lo gelo tiꞌ lo lo-ngimineꞌ: Idoꞌ Eliangumuꞌ lo-lengemeloze. Polohetelite ezemuꞌ luhuvo gizi milaniꞌ nene mo gihile izave. Aza mo gomuꞌ molo-nedo ogavo ve lingelite engiꞌ luꞌnidoꞌ eꞌmeti bilaniꞌ ma ve. ");
INSERT INTO aso_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Neꞌmine igi izipahala zuho linge nizada vi hetelaniꞌ nene eveneꞌ mukilite di vodo vodo i-ngidi nizavo avoꞌningeliti monoꞌ gamazi apizi ngimaaꞌ ave linge ma nete lolize gani li-ngimi li voleloꞌ meloꞌ igi nizavo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Niningavo eveneꞌ mukiꞌ eze ningi upuhoꞌ goloso igi geti ezela lotiꞌ izi vi gekeꞌ vokeꞌ li-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Neꞌmine ikevo Izesuꞌ tiꞌ lo longoꞌ o-ngedo lineꞌ: Nanitekumuꞌ lolize gani li voleloꞌ meloꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Longoꞌ ogavo eveneꞌ mukikutiꞌ ve maliꞌmo tiꞌ lo lo-imineꞌ: Tisazo, gipeꞌneꞌmi lulouꞌ nene sikalahuꞌ golosoliꞌmo mino gamazi lilineꞌ aka hize tile-davo geita eleꞌmizo nouvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sikalahuꞌ golosoliꞌmo do ote-dineꞌ gameneloꞌ gameneloꞌ nene do hulo misuboloꞌ o-do izo gesebeꞌ ize-davo veletiꞌ gituhoꞌ galakalaꞌ dizo veletiꞌ kilikoꞌ kilikoꞌ lo mino gizene ana do ngipu ngapa lo minaaꞌ neive. Neꞌmine ogo minaaꞌ ingumuꞌ izipaha zuho nete sikalahuꞌ goloso nene imisele hulilizave lo ingine nizada eleꞌmizo uvoniꞌza ingine nene ngeli imiseli hulilizadoꞌ minamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Eii, ngeli imiseli hulisaꞌmaniꞌ nehe. Lingine Oꞌmosomuꞌ gili eleꞌvoleꞌ amaniꞌ zuho lengikumuꞌ nene goseleꞌ nebeleꞌmo novivo lengiꞌ vovotinguꞌ gamene gohi ma imineꞌ molo mino langamuzo hizeꞌmo vo mineloniꞌ nemuꞌ agae lo noluve. Gipe nene neniꞌ nouvoda eleꞌmizi alo. ");
INSERT INTO aso_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lavo eleꞌmizi ikevo sikalahuꞌ goloso neꞌmo Izesuꞌni ningo gipe nene ehusoꞌ ogo hulavo misubola lemo pouꞌ lo ongo velepeꞌ velepeꞌ izo minavo veletiꞌ gituhoꞌ galakalaꞌ vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Neꞌmino neivo Izesuꞌ aza gipe neꞌmi melehine longoꞌ o-do lineꞌ: Initeꞌ nanihekutiꞌ gize daniꞌ neve. Lavo aza lineꞌ: Izipe ngomolotiꞌ gize daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gamene mukiꞌ izipe nene belelesa olokuꞌ nehe nosouꞌ nehe ehusoꞌ ogo hulaaꞌ ineꞌ ve. Nemuꞌ nene do lamineꞌ o-ledelinidoꞌ o neivo ma nene muhelete ningo do lamineꞌ o-ledezo. ");
INSERT INTO aso_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Do lamineꞌ o-delinidoꞌ o neivo ma ve laineꞌ ma nene naza ma lokuvo gelezo. Gele eleꞌvoleꞌ o minelive neꞌmo nene amaaꞌ nitekisi ha oloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lavo izipeliꞌmi meleho geto gekeꞌ naba lo lineꞌ: Idise geikumuꞌ gele eleꞌvoleꞌ o nouve. Aꞌmine gele eleꞌvoleꞌ o nouvoniꞌ neꞌmo vo damida nene hize eleꞌ o-nedezo. ");
INSERT INTO aso_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lavo eveneꞌ mukiꞌ ingine lotiꞌ izi igi di geseꞌ navo ningo sikalahuꞌ goloso elemo tiꞌ lo lineꞌ: Sikalahuꞌ goloso gaza gipe meꞌmi gala do negi hize-do gamazi laaꞌ akaꞌve hize tile-danive gaza eiꞌ luloutiꞌ lemo vosa tibizo amozo lo nolo huko-giduve. ");
INSERT INTO aso_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lavo gekeꞌ lo do gabeꞌ kabeꞌ o-dosa lemo vineꞌ. Lemo vavo gipe aza hilave neꞌmino ongo miningumuꞌ eveneꞌ linge mukiꞌ nete nene aza mo helave laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Laniꞌza Izesuꞌ aza analoꞌ dosa do hozi lo-davo otineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Neꞌmine ogavo Izesuꞌ aza numunguꞌ dizavo izipahala zuhosi angisevoꞌ mini tiꞌ li longoꞌ i-daniꞌ: Sikalahuꞌ goloso nene laza naniteliꞌmo imisele hulamolonidoꞌ ineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Neꞌmine li longoꞌ i-dikevo tiꞌ lo lo-ngimineꞌ: Initeꞌ atotunuꞌ nene sikalahuꞌ goloso neꞌmine nene ngelo ngimiselamolosune. Asi Oꞌmosola laadunukovoꞌ nene ngimisele hulolosune. ");
INSERT INTO aso_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Aꞌmine ebeꞌ huli nGalilaia misubouꞌ vi heteli aꞌmine misubo nene ivileꞌ iki eleseꞌ igi vaniꞌ. Idoꞌ eleseꞌ igi vaniꞌ nene Izesuꞌ aza izipahala zuho gamazi apize ngemeꞌmo vo minineꞌ nenako nemuꞌ eveneꞌ nete aza mela neive li gilikelizave lo lavo eleseꞌ igi vaniꞌ. Neꞌmine igi nivadoꞌ nene izipahala zuho tiꞌ lo apize ngeme ngemeꞌ oꞌmo vineꞌ: Oꞌmosolatiꞌ ve gihile neniꞌ nene eveneꞌ maliti aꞌninguꞌ neleꞌmizi milikevo di vi nibili hililisave. Di vi nibili hilikevo helo mino gamene setohamo vavo otelesuve. ");
INSERT INTO aso_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Neꞌmine lo lineꞌza izipahala zuho ingine aꞌmine gamaziꞌmi monovomuꞌ nene gili lamineꞌ amaniꞌ. Gili lamineꞌ amaniꞌza eikumuꞌ golise gili nemuꞌ longoꞌ i-damaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Idoꞌ Kahanaumi numudoꞌ vi heteli numunguꞌ dizisa Izesuꞌ aza izipahala zuho longoꞌ o-ngedo tiꞌ lo lineꞌ: Akala ma nene lingine nanitekumuꞌ li voleloꞌ meloꞌ iꞌmi ave. ");
INSERT INTO aso_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Longoꞌ o-ngedavo ingine akaloꞌ niigi engiꞌ mukikutiꞌ nene ve zaho ngivileꞌ ogo naba neive li li voleloꞌ meloꞌ aniꞌ nenako nemuꞌ gamazi li-imami minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gamazi li-imamavo aza mitoꞌ mino izipahala zuho tuvelu asi lavo ezela ikevo tiꞌ lo lo-ngimineꞌ: Ve ma ingine eveneꞌ naba minelone li ma eveneꞌ mukiꞌ nene dizi minikevo engiꞌ nene limi mini eveneꞌ mukiliti gelekeleꞌ ve minilisave. ");
INSERT INTO aso_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Neꞌmine lo izipe ngomo ma eleꞌmizo vovoꞌninguꞌ do ote-do do mumunouko o-de mino tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ve ma ingine nenikumuꞌ ve li izipe ngomo meꞌmine ma ngeleꞌmize lamineꞌ ilizaniꞌ nene neniꞌ neleꞌmize lamineꞌ aniꞌ geleleseive. Idoꞌ neniꞌ neleꞌmize lamineꞌ ilizaniꞌ nene nenikovoꞌ neleꞌmize lamineꞌ ami nimiselive nesi nene eleꞌmize lamineꞌ aniꞌ geleleseive. ");
INSERT INTO aso_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Idoꞌ Zohaneꞌ aza tiꞌ lo lo-imineꞌ: Tisazo, ve maliꞌmo geiꞌ guliveka lo sotoꞌ ogo geiꞌ vekamuꞌ ve lo sikalahuꞌ goloso nongimiselivo laza ningo aꞌmine ve nene lezesi bizo geiꞌ geꞌmetesaꞌmineꞌ nenako nemuꞌ neꞌmine amozo lo oꞌve lo-dekune. ");
INSERT INTO aso_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lavo Izesuꞌ aza tiꞌ lo lineꞌ: Oꞌve li-damilo. Ve ma ingine neze guliveꞌne li sotoꞌ igi neze veꞌnemuꞌ ve li amuzo niteꞌ di sotoꞌ ilizave nete ingine liteꞌ li diviꞌ lediviꞌ ma i-nidamilisave. ");
INSERT INTO aso_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ve ma ingine biluvaꞌ i-lidamilizave nene lelita ve nene nizave. ");
INSERT INTO aso_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Naza lamineꞌ Ma lo-lengemelove. Ve ma aza nene lingine neniꞌ Kilisitoꞌ zuho nizangumuꞌ ve lo noso kapuuꞌ ohizo lengemelineꞌ neꞌmi meniꞌve nene damilivoba daloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Idoꞌ nenikumuꞌ gili eleꞌvoleꞌ igi minaaꞌ naniꞌ izipahaꞌne zuho limi minaniꞌ engikutiꞌ hamoꞌ ma eveneꞌ maliꞌmo goloso niteꞌ dalineꞌ akauꞌ eleꞌmize molalosa neivo ma aꞌmine ve nene Oꞌmosoꞌmo mulumo gono nabaꞌ naba emalinako nemuꞌ nene goloso niteꞌ dalineꞌ akauꞌ nene olihe eleꞌmize molamivo gomuꞌ nene luvonouꞌ genivesi geheni naba nene nalava izi-di noso ohuno nabauꞌ ehusoꞌ i hulikevo aꞌminguꞌ lemo helelineꞌ nene lamineꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Idoꞌ anga sitaꞌ ha do mino Oꞌmosoꞌmo lihime gemavo lihizami olokuꞌ vilineꞌ nene mo edamoloseineꞌ nenako nemuꞌ nene anga maliꞌmo lihime daaꞌ akaloꞌ geleꞌmize molalosa neivo ma oꞌve lo aꞌmine anga nene huko hulaineꞌ gilivosa minezo. Anga hamokovoꞌ minineꞌ gilivo mino minevoꞌ minevoꞌ ebekuko vilineꞌ nene ede voloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Idoꞌ gizenga sitaꞌ ha do minanivo Oꞌmosoꞌmo lihime gemo oloꞌ galeseuꞌ gehusoꞌ o hulilineꞌ nene mo edamoloseineꞌ nenako nemuꞌ nene gizenga maliꞌmo lihime daaꞌ akaloꞌ geleꞌmize molalosa neivo ma oꞌve lo aꞌmine gizenga nene huko hulaineꞌ gilivosa minezo. Gizenga hamokovoꞌ minineꞌ gilivo mino minevoꞌ minevoꞌ ebekuko vilineꞌ nene ede voloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Idoꞌ veka sitakisi ha nanivo Oꞌmosoꞌmo lihime gemo okoꞌnine naliza ginine osuꞌ lamavo oloꞌ lihizamilineꞌ galeseuꞌ gehusoꞌ o hulilineꞌ nene edamoloseineꞌ nenako nemuꞌ nene veka gulo maliꞌmo lihime daaꞌ akaloꞌ geleꞌmize molalosa neivo ma gaza oꞌve lo aꞌmine veka nene kuluhize hulaineꞌ gilivosa minezo. Veka hamokovoꞌ minineꞌ gilivo mino Oꞌmosoꞌmo gizebo o neinguꞌ vilineꞌ nene ede voloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nosoꞌ nitekuꞌ laniteꞌ ilive lo guvo hulaaꞌ none. Aꞌmineꞌmine ogo eveneꞌ mukitoꞌ oloꞌ neꞌmo guvo neꞌmine loloꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Guvo nene lamineꞌ neineꞌza guvo laniteꞌve ma osuꞌ lavo ma gohi nado do laniteꞌ o-delone. Nosoꞌ nitekuꞌ guvo hulokunivo laniteꞌ ogaꞌ neineꞌ neꞌmino lingine lutinguꞌ guvo neꞌminosa laniteꞌ o minivo mini aꞌmida aꞌmida hongu li minilo. ");
INSERT INTO aso_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Izesuꞌ aza aꞌmine ebeꞌ hulo Zudaia misubo nene vo hulo Zodani noso helala vineꞌ. Vo nela neivo ezela eveneꞌ mukiꞌ iheꞌ igi di geseꞌ ikevo aza ogaꞌ ineꞌ neꞌmino gohi monoꞌ apize ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Neꞌmino neivo Halisaioꞌ monoꞌ laaꞌ ave malite igi emenguꞌ mili tiꞌ li longoꞌ i-daniꞌ: Ve maliꞌmo elenahine imisele hulilineꞌ nene gaza gelanivo leze Zuda veti louꞌ gamazi avutoꞌ ilihe amilive. ");
INSERT INTO aso_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Longoꞌ i-dikevo velepeꞌ izo longoꞌ o-ngedo tiꞌ lo lineꞌ: Moseꞌ aza nadive lo lo huko-lengede neineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Neꞌmine lavo ingine tiꞌ li laniꞌ: Ve ma elenahine imiselelove lo gelo ma veneꞌ vemohoꞌ izi hukaaꞌ luhuvo gizo emosa imiseleleseive lo Moseꞌ aza gele leme neineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Likevo aza tiꞌ lo lineꞌ: Lingine gamazi gilami peleseveꞌ izaaꞌ angumuꞌ aꞌmine louꞌ gamazi nene gize-lingidineꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gize-lingidineꞌza Oꞌmosoꞌmo initeꞌ mataꞌ ganaꞌ apiꞌ ogo do sotoꞌ ineꞌ gamenela nene veneꞌ vemohoꞌ do sotoꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nemuꞌ tiꞌ lo lo neineꞌ ma neive: Vemohoꞌ nene izelehingi melehingi hulo elenahida bizo minavo ingine hamoꞌ liliꞌ asineꞌ gelavo minilisasive. ");
INSERT INTO aso_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nemuꞌ nene ingine sitaꞌ nizasive ma lo-ngedamolosune. Mo hamoꞌ nene nizasive. ");
INSERT INTO aso_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nemuꞌ nene Oꞌmosoꞌmo initeꞌ do hamoꞌ ogo molo neingutiꞌ ve malike do izeꞌ molaaꞌ nene nomive. ");
INSERT INTO aso_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Neꞌmine lavosa numunguꞌ dizi minanguꞌ nene izipahala zuho nete aꞌmine initekumuꞌ nene gohi longoꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Longoꞌ i-dikevo tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo elenahine imisele hulo veneꞌ gohi ma dalineꞌ nene aza elenahine do gopo o-do Oꞌmosoꞌmi louꞌ gamazi avutoꞌ oloseinako lihime naba daloseive. ");
INSERT INTO aso_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Idoꞌ veneꞌ ma vanahine hulo-do ve gohi maloꞌ vilineꞌ nene Oꞌmosoꞌmi louꞌ gamazi avutoꞌ oloseinako lihime naba daloseive. ");
INSERT INTO aso_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Eveneꞌ malite izipe ngomo nene okoꞌnidoꞌ do gelo noꞌnohoꞌ ize-ngedelive li Izesuda ngeleꞌmizi nivavo izipahala zuho nete oꞌve li-ngidi ngelemaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Neꞌmine ikevo ningo gelo Izesuꞌ aza izeboloꞌ molavo tiꞌ lo lo-ngidineꞌ: Izipe ngomo ngomo meꞌmine minave nene Oꞌmosoꞌmo gizebo o neinguꞌ ngeleꞌmize molaaꞌ neinako huli-ngimikavo nenita ha alizaze. Oꞌve li-ngidamilo. ");
INSERT INTO aso_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Naza laminetoꞌ nolo-lingimuve: Izipe ngomoliti ngemeni dameni neꞌminesi mini Oꞌmoso nene gizebo vete minelive li gelekeleꞌ lapa nomineꞌ i-damilizave nene eiꞌ Oꞌmosoꞌmo gizebo o neinguꞌ nene mo kekeꞌ vi hilamilisave. ");
INSERT INTO aso_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Neꞌmine lo izipe ngabutiꞌ izo ana okoꞌnidoꞌ nohito noꞌnohoꞌ ize-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Izesuꞌ aza aka volosa apiꞌ neivo ve maliꞌmo lotiꞌ izo ogo hetelo gizeneuꞌ gubiꞌ ize emo longoꞌ o-do tiꞌ lo lineꞌ: Tisaꞌ lamino, naza nene nadiꞌ okuvo Oꞌmosoꞌmo minevoꞌ minevoꞌ nemeni dameni nemelive. ");
INSERT INTO aso_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Nezemuꞌ nene ve lamino nanimuꞌ nolo-nedane. Lamineꞌ minave nene hamokisi mo nizamavo Oꞌmoso eiꞌ hamoꞌ nene lamineꞌ minive nenako neꞌmine laineꞌ nene neniꞌ monovoꞌne nadiꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gaza aka gamazi nene mo gele nane. Aꞌmine gamazi nene tiꞌ lo neive: Lingine eveneꞌ ngibili hilamilo. Idoꞌ veneꞌ vemohoꞌ liliꞌ ikeniꞌ nete lingine bizivoꞌ mini veneꞌ nehe vemohoꞌ nehe gohi masi gopo ingamilo. Idoꞌ gumine amilo. Idoꞌ eveneꞌ mamuꞌ gopoꞌ napa gamazi li-ngidii sakupo gamazi li-ngidamilo. Ve maliti initeꞌ nene tiliki igi damilo. Idoꞌ izetingine metinginemuꞌ gilikevo dizavo gelekeleꞌ i-ngidi minilo. ");
INSERT INTO aso_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Neꞌmine lo-emavo ve aza tiꞌ lo lo-imineꞌ: Tisazo. Aꞌmine laineꞌ mukiꞌ nene naza izipelotiꞌ gelo eꞌmeteꞌmo ogo minuvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Lavo Izesuꞌ aza ningo ninge lamineꞌ o-do tiꞌ lo lo-imineꞌ: Gaza initeꞌ hamoꞌ ma amanidiꞌmo nene lisiheꞌ amane. Vo initeꞌ mataka mukiꞌ nene izeꞌ molo meni do aꞌmidotiꞌ moni nene do gohoꞌ gahaliꞌ izeꞌ molo ngemezo. Neꞌmine ilineꞌ neꞌmo nene henenika Okulumokuko nene ma mineleseive Neꞌmine ogosa ogo neꞌmetezo. ");
INSERT INTO aso_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Neꞌmine lo lavo ve aza eiꞌ heneniꞌve vaiꞌ lo minineꞌ nemuꞌ agae lo geni belavo muheleꞌ ogo vo ha ha ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Novivo Izesuꞌ aza velepeꞌ izo vonuꞌ ngebelo hulo eza ema ogo izipahala zuho tiꞌ lo lo-ngimineꞌ: Heneni nganeni ve ingine Oꞌmosoꞌmo gizebo o neinguꞌ nene vi hilalisa geꞌnebe goloso ilisave. ");
INSERT INTO aso_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lavo izipahala zuho ingine Izesuꞌ gamazi neꞌmine lingumuꞌ gopo gaꞌine gilaniꞌza gohi tiꞌ lo lo-ngimineꞌ: Vekizo. Oꞌmosoꞌmo gizebo o neinguꞌ vo holaaꞌ nene geꞌnebe gono goloso neive. ");
INSERT INTO aso_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Idoꞌ kamela ize nene naba neineꞌ nenako nemuꞌ nene nalaꞌ lolosoꞌ igaꞌ naniꞌ nakese neꞌmi veleuꞌ nene ma volosa ilineꞌ nene geꞌnebe goloso oloseineꞌza heneni ve nete aꞌmine nene ivileꞌ ivosa Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ nene vilisa geꞌnebe ilisave. ");
INSERT INTO aso_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Neꞌmine lavo ingine upuhoꞌ goloso igi voꞌine vavo angiseꞌine tiꞌ li li voleloꞌ meloꞌ aniꞌ: Laza nene Oꞌmosoꞌmo umo hilive nene heneni ve loloꞌ o-ngedaaꞌ neihe lo giluneꞌza gaza heneni ve netesi Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ nene mo vi hilamilisave lo lainako nemuꞌ nene Oꞌmosoꞌmo eveneꞌ hamokisi mo ma do luꞌ izamivo eze gizebo inguꞌ nene vo holamolobe lo nogilune. ");
INSERT INTO aso_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Neꞌmine likevo Izesuꞌ aza vonuꞌ nongebelo tiꞌ lo lo-ngimineꞌ: Eveneꞌ angiseꞌnidatiꞌ lukuvo ngeli ma namilisaha Oꞌmoso nene engiꞌ neꞌmine nomive. Oꞌove. Eiꞌ nene initeꞌ mukiꞌ ogaꞌ amuzo do neineꞌ nenako eveneꞌ do nguꞌ izelidoꞌ lisiheꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lavo Petoloꞌ apiꞌ ogo tiꞌ lo lo-imineꞌ: Gaza gelezo. Laza neve initeꞌ matate mukiꞌ nene hulo osuꞌ lo geꞌmeto noune. ");
INSERT INTO aso_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Lavo Izesuꞌ tiꞌ lo lineꞌ: Laminetoꞌ ma lo-lengemelove. Ve ma ingine nenikumuꞌ idoꞌ monoꞌ gamazi laminekumuꞌ numuno ebeꞌine nehe uvoꞌningine nakuꞌningine nehe ateꞌningine alunoꞌningine nehe izeꞌningine meꞌningine nehe idoꞌ izipahaꞌine nehe misuboꞌine nehe neꞌmine initeꞌ ma huli nilizaniꞌ nene ");
INSERT INTO aso_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aꞌmine huli nilizaniꞌ initetoꞌ nene medeli ma damilizavoba mo dalizavevoꞌ nene nizave. Aꞌmine huli nilizaniꞌ initeꞌ mukiꞌ hamotoꞌ hamotoꞌ nene hadeti hadeti neꞌmine gohi ma dikaꞌ dikaꞌ ilisave. Aꞌmine numuꞌnidoꞌ nehe engiꞌ zuholoꞌ nehe minamunoꞌnidoꞌ nehe aꞌmidoꞌ aꞌmidoꞌ nene gohi gohi dalisave. Aꞌmine initeꞌ nene idise noneꞌ gameneuꞌ nene dikaꞌ dikaꞌ ilisaniꞌza goboni malaꞌ malaꞌ neꞌmi lulouꞌ nesi mini-di vilisave. Idoꞌ alingeꞌ gamene ma sotoꞌ ogo alinguꞌ nene minevoꞌ minevoꞌ ngemeni dameni nesi dalisave. ");
INSERT INTO aso_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Neꞌmine ilisaniꞌza dizi nilizaniꞌ aleveutiꞌ linge mukiꞌ nene limi minilisave. Idoꞌ limi nilizaniꞌ aleve nene dizi minilisave. ");
INSERT INTO aso_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zelusalemi numuda vilisa akaloꞌ nivavo Izesuꞌ aza gomuꞌ molo novivo izipahala zuho ingine nene ngehelele ize mineꞌ mineꞌ ivo nivavo ma ngeꞌmeti vave ingine nene golise gilaniꞌ. Tiꞌ navo Izesuꞌ aza izipahala zuho tuvelu nene ngeleꞌmize gaheve ogo ezela sotoꞌ o-delineꞌ initekumuꞌ nene gohi apiꞌ ogo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gililo. Laza nene Zelusalemi numuno ebeta dizo novune. Aꞌmida nene Oꞌmosolatiꞌ ve gihile neniꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi avotemote laniꞌ monoꞌ apizi ngimaaꞌ avesi engiꞌ aꞌninguꞌ milikevo ingine goniꞌ i-nidi lihimeka apaso helelinidoꞌ o neive li Zuda ve minamaniꞌ heta atoꞌ aleveliti aꞌninguꞌ mili-nidikevo ");
INSERT INTO aso_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ingine gize zohiꞌ i-nidi gituhoꞌ i-nidi gasavasi nalatunuꞌ nene meheꞌne iziviꞌ lediviꞌ igi nibili nibili hililisave. Neꞌmine igi nibili hilikevo gamene setohamo vavo gohi otelesuve lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedaioꞌ gipele setaꞌ Zakoboki Zohaneki ingi Izesuda vi tiꞌ li li-imasineꞌ: Tisazo. Laza initeꞌ nanitekumuꞌ lolosihe aꞌminemuꞌ lokusivo gaza aꞌmidoꞌ o-ledeline losa nolusive. ");
INSERT INTO aso_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Likesivo aza tiꞌ lo longoꞌ o-ngidineꞌ: Lingi nene naza nadiꞌ o-lengedelongumuꞌ nilasive. ");
INSERT INTO aso_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lavo tiꞌ li li-imasineꞌ: Gaza Guvekasi ve loloꞌ ogo minelineꞌ gamenela nene laza gezelotiꞌ lemo eveneꞌ lingesi ma ngivileꞌ ogo guvetesi ve loloꞌ ogo mino anga zamelasi adavalasi minilizo lo gele lemeline losa nolusive. ");
INSERT INTO aso_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Likesivo aza tiꞌ lo lo-ngimineꞌ: Lingine longoꞌ i-nidasineꞌ initeliꞌmi monovo nene gilami gopo likesive. Initeꞌ goloso i-nidilizaniꞌ nene ekeseꞌ noso neꞌmino nenako aꞌmine i-nidilizaniꞌ initeꞌ nene ha gehelesa nouve. Idoꞌ linginesi neniꞌ geheloniꞌ initeꞌ ekeseꞌ noso neꞌmine minineꞌ nene ha gihilisidoꞌ i nizasihe. Mulumo alumo niteꞌ noso neꞌmino holosa neꞌmi lulouꞌ minelonguꞌ nene linginesi neꞌmi lulouꞌ nene ha minilisidoꞌ i nizasihe. ");
INSERT INTO aso_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lavo ingine tiꞌ li li-imasineꞌ: Ee, laza neꞌmine ha olosidoꞌ o nosive. Likesivo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lamineꞌ lingine neniꞌ geheloniꞌ geni nene gihi mulumo alumoliꞌmi lulouꞌ minelonguꞌ nene linginesi aꞌmineꞌmi lulouꞌ nene minilisineꞌza ");
INSERT INTO aso_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","aꞌne zamelasi adavalasi minaaꞌ moꞌmosiꞌ nene neniꞌ initeꞌ neivosa lengemelohe. Oꞌmosoꞌmo dalisive lo do vaꞌvaꞌ o-ngidive engikovoꞌ nene dalisasive. ");
INSERT INTO aso_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Zakoboki Zohaneki neꞌmine asineꞌ nemuꞌ izipahala zuho linge teni ingine gilii engikumuꞌ nene muluꞌninguꞌ goloso ineꞌ ");
INSERT INTO aso_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Neꞌmine ogavo Izesuꞌ asi lo-ngedavo ezela ikevo tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmi zuho minamaniꞌ heta atoꞌ ve engiꞌ gizebo veꞌine ve lave ingine nete eveneꞌine nene gelekeleꞌ i-lidilizave li amuzo mili li-ngidaaꞌ nave. Aꞌmine eveneꞌ engita eveneꞌ naba minave nete nene aꞌmine eveneꞌine zuho nene ngivileꞌ igi amuzo ve goloso minisa gizebo i-ngidaaꞌ nave. Neꞌmine igaꞌ naniꞌ nemuꞌ nene lingine mo gili nizaniꞌza ");
INSERT INTO aso_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","lengiꞌ muliseuꞌ nene ingine igaꞌ naniꞌ neꞌmine nene ma amilisave. Lengikutiꞌ ve maliꞌmo guveꞌnesi ve loloꞌ olove lo gelo ma aza nene lengiꞌ gelekeleꞌ vetine neꞌmine loloꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ee, ve ma aza gomuꞌ molo lengemo eveneꞌ naba minelove lo gelo ma aza nene mukiliti goboni izipe neꞌmine loloꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Idoꞌ neꞌmine noluvoniꞌ nene naza Oꞌmosolatiꞌ ve gihile nouvoniꞌ nesi nene eveneꞌ gelekeleꞌ i-nidi neleꞌmize lamineꞌ ilizave losa lemamuve. Asi gelekeleꞌ o-ngedo ngeleꞌmize lamineꞌ olosa ogo eveneꞌ mukiꞌ nene meni hizo do nguꞌ izo do tineꞌ molo-ngedelove lo engikumuꞌ okoꞌne hulo helelesa limuvoniꞌ nenako nemuꞌ noluve. ");
INSERT INTO aso_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zeliko numuda vi hetelaniꞌ. Vi heteli Aꞌmine ebeꞌ nene huli izipahala zuhosi eveneꞌ mukiꞌ ezela di geseꞌ igi minavesi nivavo Timaioꞌ gipele Batimaioꞌ aza vele likavo mino monimuꞌ vokuꞌ vokuꞌ lo aka gahevela minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mino Nasalete ve Izesuꞌ nave likevo gelo apiꞌ ogo amuzo molo asi lo lineꞌ: Izesuvo, guvelesi ve naba Davidiꞌ aꞌvo ezeloꞌ medelo minanive make, nenikumuꞌ nene mulumoꞌne ningevo. ");
INSERT INTO aso_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lavo eveneꞌ mukiꞌ ingine legeno minelive li oꞌve li-di elemaniꞌza aza nene gohi amuzo molo vise naba lo tiꞌ lo lineꞌ: Davidiꞌ aꞌvo make, nenikumuꞌ nene mulumoꞌne ningevo. ");
INSERT INTO aso_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Neꞌmine loꞌmo loꞌmo angumuꞌ nene gelo Izesuꞌ aza akaloꞌ vo ote mino alize li-imilo lineꞌ. Lavo vele likivemuꞌ nene asi tiꞌ li li-imaniꞌ: Gezemuꞌ nolize. Mulungauꞌ lamineꞌ gelo oto ano. ");
INSERT INTO aso_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Neꞌmine likevo vele likive gelo saketiꞌve apase hulo upuhoꞌ ogo oto Izesuda vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vogavo Izesuꞌ aza tiꞌ lo longoꞌ o-do lineꞌ: Gaza nene nadiꞌ o-gedelove losa nogelane. Neꞌmine lo longoꞌ o-davo aza tiꞌ lo lineꞌ: Guveꞌnesi ve make, gaza veꞌne nene do lamineꞌ oganivo gohi veꞌne ningeloho. ");
INSERT INTO aso_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Gaza gele eleꞌvoleꞌ anidiꞌmo nene lamineꞌ ogange. Vozo. Neꞌmine nolivo aꞌmidoꞌ liteꞌ lo vele nene lamineꞌ ogavo vele ningo akaloꞌ nene Izesuꞌni eꞌmeto vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zelusalemi numuno di avitoꞌ igi Oliva golola ebeꞌ setaꞌ Betehagesi Betanisi minasida nene vi hetelaniꞌ. Vi hetelisa Izesuꞌ aza izipahala zuhoutiꞌ setaꞌ ma ngimiselo ");
INSERT INTO aso_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tiꞌ lo lo-ngidineꞌ: Aꞌmine ningi nizasineꞌ numuno ebekuꞌ volene vi nidizi ningilisineꞌ nene dongi ize evenelite aꞌmidoꞌ mitoꞌ mini olihe monamaniꞌ nene nalava izi nizavo ningilisasize. Aꞌmine nene vakesi daalizo. ");
INSERT INTO aso_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Neꞌmine nasivo ve maliꞌmo nanitekumuꞌ nasive lo nolivo ma lingine tiꞌ li li-imilizo: Guvelesi ve aza gonoꞌve ma neivo aꞌmine dongi izemuꞌ mene lavo nousinako gono davo liteꞌ lo gohi do tiꞌno imiseleleseive li lilizo. ");
INSERT INTO aso_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lavo vi numuno gatedoꞌ aka gahevela naꞌnava izikaniꞌ dongi ize angale naba nene ningi vakesasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Neꞌmine igi nizasivo aꞌmidoꞌ minave nete longoꞌ i-ngidi tiꞌ li laniꞌ: Ize nene nanitekumuꞌ nivakesasive. ");
INSERT INTO aso_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Likevo Izesuꞌ lo-ngimineꞌ gamazi ma nene li-ngimikesivo ha huli-ngimikavo vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Huli-ngimikavo vi aꞌmine dongi ize nene Izesuda di ikesivo saketiꞌine nene apasi ize neꞌmi meheneloꞌ milikevo Izesuꞌ aza aꞌmidoꞌ dizo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Neꞌmine ogavo Eveneꞌ linge mukiꞌ nete nene saketiꞌine apasi akaloꞌ aviliseꞌ iꞌmi nivavo linge ma nete nene za aꞌnava avilesi guvisetiꞌ huki di aniꞌ nene aviliseꞌ iꞌmi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Neꞌmine iꞌmi nivavo gomuꞌ milavesi alingeꞌ milavesi ingine gekeꞌ gekeꞌ li tiꞌ li laniꞌ: Geikumuꞌ nene gopoꞌni nolunize. Guvetesi ve oꞌmosoꞌmi velemuꞌ anive geiꞌ nene Oꞌmosoꞌmo noꞌnohoꞌ ize-gidivo. ");
INSERT INTO aso_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Avoteho Davidiꞌ moꞌmosiꞌve do geita ogo guvetesi ve loloꞌ ogo gizebo o-ledo minelineꞌ gamene nene alitaze. Aꞌmine gizebo ilineꞌ nene Oꞌmosoꞌmo noꞌnohoꞌ izelive. Agae, veleta Okulumokuꞌ Oꞌmoso geiꞌ nene gopoꞌni nolune. ");
INSERT INTO aso_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Neꞌmine iꞌmi navo Izesuꞌ aza Zelusalemi numuno ebekuꞌ dizosa monoꞌ numuno nabauꞌ dizo initeꞌ mataꞌ mono ninge osuꞌ lineꞌ. Neꞌmine ineꞌ nene nivengaꞌ mo molanguꞌ nenako azasi izipahala zuho tuvelu nesi nene Betani numuda limi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Litiꞌmuso izo goꞌ lavo Betani numudatiꞌ nilimi Izesuꞌ gaꞌna olavo ");
INSERT INTO aso_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","gohuno za avile mukikisi hotoꞌ neivo ningo aꞌmidoꞌ gihile ize neihe lo viseꞌ olosa vineꞌ. Vo ningo gihile izaaꞌ gamene amineꞌ nenako gihile izamivo avilevoꞌ ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ningo aꞌmine zamuꞌ tiꞌ lo lineꞌ: Geitoꞌ nene gihile gohi ma izamivo ve maliꞌmosi elo namilive. Neꞌmine lineꞌ nene izipahala zuho nete gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Idoꞌ Zelusalemi numuda gohi vi hetelaniꞌ. Aꞌmida Izesuꞌ aza monoꞌ numuno nabauꞌ vo dizo initeꞌ maketi milaaꞌ meni hizaaꞌ igi minave nene ngeleto do hulo monoꞌ numunguꞌ hulaaꞌ moni senisimi igaꞌ aveliti holomoꞌine nene do tululu lo do hulo-ngedo nama viluso Oꞌmoso lehizi-dilizangumuꞌ meni hizilizave li maketi mili minavete minaaꞌ holomoꞌinesi nene do velepeꞌ izo hite-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Idoꞌ monoꞌ numuno nabauꞌ nene maketi initeꞌ nevoꞌmine nene di dizi limi amilizave lo oꞌve lo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Neꞌmine lo-ngedo eveneꞌ apize ngemo tiꞌ lo lineꞌ: Oꞌmosoꞌmo tiꞌ lo lineꞌ gamazi ma nene luhuvo gizamaniꞌ nehe: Neniꞌ numuꞌne nene eveneꞌ ato atoꞌ zuho mukiꞌ nete dizi nopoꞌni li-nimaaꞌ numuno ve losa mineleseive. Neꞌmine li gizaniꞌza lingine aꞌminguꞌ igi mili minaaꞌ naniꞌ initeꞌ neꞌmo nene gumineloꞌ vete igi mili minaaꞌ numuno loloꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Neꞌmine lavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ apizi ngimaaꞌ avesi ingine gili bililizaniꞌ aka viseꞌ iꞌmi vi minaniꞌ. Idoꞌ bililizaniꞌ akamuꞌ viseꞌ aniꞌ nene nanitekumuꞌ ve. Eveneꞌ mukiꞌ nete eze apize ngemo minineꞌ gamazi nemuꞌ nene laniteꞌ gili golize laniꞌ nenako nemuꞌ ingine golise gili bililizaniꞌ akamuꞌ nene viseꞌ iꞌmi vi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Idoꞌ mo nivengaꞌ molavo izipahala zuhosi Zelusalemi numuno ebeꞌ nene huli vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ingi goꞌ lavo nedengaꞌ akaloꞌ gohi nivi gohuno za nene monovoukotiꞌ gulugulu ize pilineꞌ nene ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petoloꞌ aza aꞌmine za ningidotiꞌ Izesuꞌ gamazi lineꞌ ma nene galauꞌ ogavo gohi gelo tiꞌ lo lo-imineꞌ: Tisazo, ningezo. Geiꞌ usiꞌ ize-daineꞌ gohuno za nene mo gulugulu izave. ");
INSERT INTO aso_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Lavo Izesuꞌ do velepeꞌ izo tiꞌ lo lo-ngimineꞌ: Lingine nene Oꞌmosomuꞌ gili eleꞌvoleꞌ igisa minilo. Naza laminetoꞌ ma lo-lengemelove. ");
INSERT INTO aso_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ve maliꞌmo gala setaꞌ gelamo loloniꞌ gamazi nene gihile izeleseive lo gele eleꞌvoleꞌ o mino mene golomuꞌ ngutoko guvo nosouꞌ lemelive lo lo-delineꞌ nene lilidoꞌ gihile ha izeleseive. ");
INSERT INTO aso_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nemuꞌ nolo-lingimuve. Initeꞌ neꞌmine manaꞌmine initekumuꞌ Oꞌmosola li longoꞌ igi nili mo dalosune li gili eleꞌvoleꞌ ilizaniꞌ nene lilizadoꞌ ha gihile izeleseive. ");
INSERT INTO aso_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Idoꞌ gamene gamene oti mini Oꞌmoso opoꞌni nilii ma ve mamuꞌ lihime di minilizaniꞌ nene ha huli-ngidilo. Neꞌmine ikevo Okulumokuꞌ metibo aza aꞌmineꞌmine ogo lengiꞌ lihimetine nene ha hulo-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Idoꞌ Zelusalemi numuda gohi dizi ikevo Izesuꞌ aza monoꞌ numuno nabauꞌ dizo nomonivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ apizi ngimaaꞌ avesi monoꞌ gizebo vesi ezela igi ");
INSERT INTO aso_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","longoꞌ i-di tiꞌ li laniꞌ: Initeꞌ ogaꞌ naineꞌ nene zahi velemuꞌ ogaꞌ nane. Idoꞌ zaho lavosa ogaꞌ nane. ");
INSERT INTO aso_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Longoꞌ i-dikevo aza tiꞌ lo lo-ngimineꞌ: Nazasi initeꞌ mamuꞌ longoꞌ o-lengedekuvo li-nimilizaniꞌ nene naza zahi velemuꞌ initeꞌ ogaꞌ nouhe nemuꞌ nene lo-lengemelesuve. ");
INSERT INTO aso_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Monoꞌ noso holo-ngedelive lo Zohaneꞌni imiselive ma nene Oꞌmosoꞌmo imiselihe haza misubouꞌ velite imiselave. Lingine aꞌminemuꞌ likevo gelelove. ");
INSERT INTO aso_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Neꞌmine lavo ingine angiseꞌinemuꞌ li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Laza Oꞌmosoꞌmo imiselive losoꞌ nene Izesuꞌ aza lingine tiꞌ li ma eitoꞌ nene nanimuꞌ gili eleꞌvoleꞌ amave lo lalive. ");
INSERT INTO aso_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne neiha haza misubouꞌ velite imiselave ha lolobe. Neꞌmine laniꞌ nene eveneꞌ mukiꞌ nete Zohaneꞌ nene polohete gihile minineꞌ ve li gilaniꞌ nenako eveneliti goliseꞌine gili laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nemuꞌ nene Izesuꞌ longoꞌ ineꞌ gamaziloꞌ nene tiꞌ li li-imaniꞌ: Laza ma gelamune. Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine li-nimamaniꞌ nemuꞌ nene nazasi ogo molo ogaꞌ nouvoniꞌ initeꞌ nene iline lo nimiselivemuꞌ nene ma lo-lengamamolosuve. ");
INSERT INTO aso_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Idoꞌ aneza gamazi ma Izesuꞌ tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo vaini mine zuhoꞌ ogo aꞌmidoꞌ gesi hize vodo vodo ogo vaini gihile hite miꞌ izo lipelineꞌ galese nesi elosa aꞌminguꞌ mini miꞌveloꞌ gizebo iliza numuno haꞌna nesi do dizo gizo eveneꞌ ma mine gizebo i-dilizave lo hulo-ngedo misubo mala vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Aꞌmida neivo vaini nalaꞌ gihile elaaꞌ gamene ogavo mine meleho aza aꞌmine vaini nalaꞌ gihile nene ma do-nedo alive lo gelekeleꞌ izipe ma mine gizebo vela imiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Imiselavo vo hetelavo mine gizebo ve ingine analoꞌ di giliꞌ liki bili imiseli hulikevo initekisi ma damo haza tineꞌ molo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Neꞌmine ogavo gelekeleꞌ izipe gohi ma engita imiselavo vo hetelavo godolo izi okoti huli di goloso initeꞌ gehepeve i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Neꞌmine i-dikevo gohi ma imiselineꞌ nene bili hilaniꞌ. Aꞌmineꞌmine igi gohi eveneꞌ mukiꞌ ngimiselineꞌ nene linge ma ngibili di goloso i-ngidi linge ma nene mo ngibili hilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Neꞌmine ikevo imiselelive hamoꞌ ma minineꞌ nene lulo eme neineꞌ gipele minineꞌ nenako alingeꞌ noimiselo tiꞌ lo lineꞌ: Aza neniꞌ gipeꞌne nenako ha eleꞌmize lamineꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tiꞌ lo imiselineꞌza vo hetelavo mine gizebo ve nete tiꞌ li li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Me veꞌmo alingeꞌ melehidoꞌ medelo mino mine dalive nenaze. Aloꞌ bele hilukeꞌzo. ");
INSERT INTO aso_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Neꞌmine okunivo mine mene leliꞌ mide loloꞌ ilive. Tiꞌ li liteꞌ li analoꞌ diki bili hilisa mingutiꞌ geleleheꞌ igi di vi heta huli-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Neꞌmine aniꞌ nenako mine meleho aza nadiꞌ ilive. Aza nene ogo aꞌmine midoꞌ gizebo ve mukiꞌ nene ngebele geseꞌ ogo miꞌveloꞌ nene eveneꞌ atoꞌ gohi gizebo ve ma hulo-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Idoꞌ monoꞌ godolouꞌ gamazi ma tiꞌ lo neineꞌ ma nene lingine gati gilisaꞌmahe: Numuno gizilizaniꞌ geheni mukikutiꞌ geheni ma nene numuno gizaaꞌ avete ningi goloso o vive lii di kegesi di hulaniꞌ geheni neꞌmo nene geheni mukiꞌ ngivileꞌ ogosa numuno do amuzo molo minaaꞌ geheni loloꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aꞌmine initeꞌ do sotoꞌ ive nene guvelesi veꞌmo do sotoꞌ ineꞌ ve. Aꞌmine initeꞌ nene evenelite ninguneꞌ mo amebe izo do sotoꞌ oganiꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tiꞌ lo lo-ngemavo aꞌmine Zuda veliti monoꞌ ve naba ingine aneza gamazi nene lelikumuꞌ lave li gili galapuso emelone li gilaniꞌza eveneꞌ mukiꞌ aꞌmida minavemuꞌ nene golise ngemavo huli-di vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Neꞌmine igi Zuda veti gizebo ve ingine Halisaioꞌ monoꞌ laaꞌ aveutikisi guvelesi ve Helodeꞌni hize eleꞌ i-daaꞌ aveutikisi linge ma ingine vi Izesuꞌni golo izikevo goniꞌ o-deloneꞌ gamazi lilihe li ngimiselikevo ");
INSERT INTO aso_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ezela igi heteli tiꞌ li li-imaniꞌ: Tisazo, gaza ve lisiheꞌ lamineꞌ naineꞌ nene mo gele none. Gamazi lo-ngemelineꞌ aleve nene naniꞌmine aleve nilizahe nemuꞌ gaza gaka mukiꞌ gelesaꞌmane. Eveneꞌ naba mini geiꞌ lilineꞌ gamazimuꞌ muluꞌninguꞌ goloso gili gelemilizadokisi nilizaniꞌ nemuꞌ gelamo Oꞌmosoꞌmi aka lelebizo gamazi gihilevoꞌ lo-lemaaꞌ nane. Nemuꞌ nene gaza laanivo gelelone. Loma veti guveꞌinesi ve naba Kaesaleꞌ aza takisi moni huli-nidilizave lo neidoꞌ nene eꞌmeto Zuda ve laza ma hulo-desoꞌ nene lisiheꞌ o neihe louꞌ gamazite avutoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Gaza gelanivo takisi emelonidoꞌ o neihe emamolonidoꞌ o neive. Neꞌmine laniꞌza lingine Kaesaleꞌni takisi imilo lilineꞌ nene Zuda ve ngizeboloꞌ molavo ganala dalive. Idoꞌ imamilo lilineꞌ nene Loma ve ngizeboloꞌ molavo ganala dalive li gili longoꞌ aniꞌ initeliꞌmi monovo gililisa lami ha veꞌine avilelotiꞌ golo izisa longoꞌ i-daniꞌ nene Izesuꞌ aza mo ningo gelo tiꞌ lo lo-ngimineꞌ: Nanimuꞌ nemenguꞌ nimilave. Moni ma di igi nelebizikevo ningelove. ");
INSERT INTO aso_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lavo ma imikevo ningo tiꞌ lo longoꞌ o-ngedo lineꞌ: Me moniloꞌ eveneliꞌmi golo velesi gulivesi neineꞌ nene zahi golo velesi gulivesi neive. Longoꞌ o-ngedavo ingine Kaesaleꞌ ma ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Tiꞌ li ma aꞌmine moni nene ngamani gizebo ve eiꞌ Kaisaleꞌ initeꞌve noloseinako aꞌminemuꞌ nolivo ma nene ha imilo. Idoꞌ aꞌmineꞌmine igi Oꞌmosoꞌmo lingimineꞌ initetoꞌ nene ha golo hizi imilo. Neꞌmine lavo ingine golize naba li-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Idoꞌ Sadukaioꞌ monoꞌ laaꞌ ave helakutiꞌ otaaꞌ ne nomive laaꞌ ave engikutiꞌ linge ma Izesuda igi longoꞌ i-di tiꞌ li laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisazo, Moseꞌ aza luhuvo gize-lidineꞌ nene tiꞌ lo neive: Uvoꞌninge nakuꞌninge ma minilizangutiꞌ maliꞌmo veneꞌ do mino izipe gedamo helavo ma engikutiꞌ maliꞌmo aꞌmine gevonoꞌ veneꞌ nene dosa aꞌmine hilive nemuꞌ medelo izipe gedo molo-delive. ");
INSERT INTO aso_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Neꞌmino nenako uvoꞌninge nakuꞌninge seveni ma minaniꞌ. Aꞌmingutiꞌ uvoꞌnibo ganaꞌve neꞌmo veneꞌ do mino izipahala sotoꞌ amavo hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Helavo akunolo aꞌmidotiꞌ neꞌmo aꞌmine veneꞌ nene do mino izipe sotoꞌ amivo hilineꞌ. Idoꞌ helavo akunolo aꞌmidotiꞌ neꞌmo aꞌmine veneꞌ daniꞌza izipe gedamo hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Neꞌmine igi aꞌmine veneꞌ dikaꞌ dikaꞌ igi izipe gidami ve seveni ingine mukitoꞌ hilikaꞌ hilikaꞌ igi osuꞌ laniꞌ. Neꞌmine ikevo alingeꞌ aꞌmine venekisi nene hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Neꞌmine ogavo aꞌmine veneꞌ nene aꞌmine ve seveni mukiꞌ nete daniꞌ nenako eveneꞌ mukiꞌ hilangutiꞌ otiliza gameneuꞌ nene zahi elenaho loloꞌ ilive. ");
INSERT INTO aso_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Likevo aza tiꞌ lo lo-ngimineꞌ: Lingine gili gopo aniꞌ nene Oꞌmosoꞌmi gamazi monoꞌ godolouꞌ gizi nizaniꞌ ma nene gili vevesami Oꞌmosoꞌmi amuzomukisi ma gili lamineꞌ isaꞌmaniꞌ nenako nemuꞌ nene gili gopo aniꞌ ve. Olo. ");
INSERT INTO aso_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Neꞌmine noluvoniꞌ nene nemuꞌ noluve. Helaakutiꞌ otaaꞌ gameneuꞌ nene veneꞌ daaꞌ idoꞌ veloꞌ vaaꞌ monovo nene ma minamoloseive. Asi Oꞌmosoꞌmi angeloꞌve ha minaaꞌ naniꞌ neꞌmini eveneꞌ inginesi ha minilisave. ");
INSERT INTO aso_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Idoꞌ lingine helaakutiꞌ otaaꞌ nemuꞌ likeze. Aꞌminemuꞌ ma Lo-lengemelove. Moseꞌ aza zautiꞌ oloꞌ gulumo ogavo ninge neivo Oꞌmosoꞌmo gamazi tiꞌ lo lo-imineꞌ monoꞌ godolouꞌ gize neineꞌ ma nene gati gilahe gilamave: Naza nene Abalahamule Isakale Zakobole engiꞌ Oꞌmosoꞌine nouve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Idoꞌ aꞌmine ve hili osuꞌ ladiniko engiꞌ Oꞌmosoꞌine nouve ngelo ma lamidine. Engiꞌ Oꞌmosoꞌine nouve lineꞌ neꞌmo mo hili osuꞌ lami ha nizave lo gelelesune. Nemuꞌ nene lingine hilave nene mudise osuꞌ laaꞌ nave laaꞌ naniꞌ nene mo ladanga gehepeve nilave lo lo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Neꞌmine li gamazidunuꞌ ge hulo ne hulo li gamazi gono di nizavo monoꞌ apize ngemaaꞌ ive maliꞌmo ogo gele minineꞌ nene Izesuꞌni longoꞌ i-dikevo aꞌmidoꞌ nene do lamineꞌ ogo do velepeꞌ izo nolo-ngimivo gelo tiꞌ lo longoꞌ o-do lineꞌ: Oꞌmosoꞌmo louꞌ gamazi lo huko-lidineꞌ neutiꞌ nene gamazi mukiꞌ ngivileꞌ ogo nani gamaziꞌmo dizosa neive. ");
INSERT INTO aso_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Dizo neineꞌ gamazi nene neꞌmine lo neive: Lingine Isilaeleꞌ aleve gililo. Guvelesi ve Oꞌmosote neve nene eiꞌ hamoꞌ Guvelesi ve ne neive. ");
INSERT INTO aso_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nemuꞌ nene lutine gatine vodinesi amuzotine vaiꞌ nesi nene Guvelesi ve Oꞌmosotida nene mili osuꞌ li lutine imivoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Idoꞌ aꞌmidotiꞌ lemo nene tiꞌ lo neive: Lingine lengiꞌ okodinemuꞌ gilaaꞌ naniꞌ neꞌmine igi eveneꞌ avita gidini nizavemukisi nene gili lutine ngimilo. Aꞌmine gamazi setaꞌ ngivileꞌ ogo minineꞌ louꞌ gamazi nene gohi ma nomive. ");
INSERT INTO aso_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lavo monoꞌ apize ngemaaꞌ ive aza tiꞌ lo lo-imineꞌ: Tisazo, mo lamineꞌ gehepeve lane. Oꞌmoso nene hamoꞌ neivo Oꞌmoso gohi ma nomive lo laineꞌ nene mo lamineꞌ lane. ");
INSERT INTO aso_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Idoꞌ lute gatesi amuzote vaikisi nene mudise ezela molo mino lute emo minaaꞌ idoꞌ leliꞌ okodemuꞌ gelaaꞌ nouneꞌ neꞌminosa evenekumuꞌ gelo lute ngemaaꞌ neꞌmo nene initeꞌ olokuꞌ gizo Oꞌmoso lehize-daaꞌ idoꞌ ato atoꞌ niteꞌ lehize-daaꞌ monovo nene ivileꞌ goloso ogosa naba neive. Mo lamineꞌ lane. ");
INSERT INTO aso_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Neꞌmine lavo aza gele vevese mino neꞌmine lineꞌ nene gelo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Oꞌmosoꞌmo gizebo o neinguꞌ vo holalinidoꞌ avitoꞌ ogane. Neꞌmine lavo gili ngehelele izavo eveneꞌ hamolitesi initeꞌ mamuꞌ gohi longoꞌ i-damaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Izesuꞌ aza monoꞌ numuno nabauꞌ monoꞌ noapize ngemo tiꞌ lo longoꞌ o-ngidineꞌ: Monoꞌ apizi lingimaaꞌ ave nete Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live nene mo ha Davidiꞌ aꞌvopilemoꞌ neive laaꞌ naniꞌ nene nanimuꞌ laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Oꞌmosoꞌmi Sikalahuliꞌmo do ote-davo asiꞌve Davidiꞌ neꞌmo nene tiꞌ lo lineꞌ ma neive: Okulumukuꞌ ve aza Guveꞌnesi vemuꞌ tiꞌ lo lo-imineꞌ ve: Nezelotiꞌ geiꞌ nene nange. Aꞌne hulaaꞌ uvoda mene minezo. Nanivo biluvaꞌ i-gidaaꞌ nave nene gizengala doꞌmo leme-ngedekuvo gelekeleꞌ i-gidi minilisave. ");
INSERT INTO aso_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Neꞌmino asiꞌve Davidiꞌ neꞌmo nene aꞌmine do luꞌ izelive lo Oꞌmosoꞌmo imiselelesa livemuꞌ Guveꞌnesi ve ve lo lineꞌ nenako nemuꞌ nene aꞌmine ve aza ha Davidiꞌ aꞌvovoꞌ nene nado minelive. Olo. Neꞌmine lo monoꞌ nolivo di geseꞌ ave mukiꞌ ingine laniteꞌ gili minisa gapepeꞌ i minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Izesuꞌ aza monoꞌ noapize ngemo imineꞌ molo tiꞌ lo lineꞌ: Monoꞌ apizi lingimaaꞌ aveti monovo nene dikelizaze. Eheꞌ igi minilo. Ingine nene lavolavo haꞌna haꞌna liki monaakumukovoꞌ ngumo helaaꞌ neivo idoꞌ maketiloꞌ nimonavo evenelite ningi ngopoꞌni li-ngidilizangumukovoꞌ ngumo helaaꞌ neivo ");
INSERT INTO aso_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","idoꞌ monoꞌ numungukisi idoꞌ nosoꞌ niteꞌ naba nadasi ingine nene ve nabalitevoꞌ minaaꞌ aniꞌ holomoloꞌ minaakumukovoꞌ nene ngumo helaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Idoꞌ ingine veneꞌ gonoliti initeꞌ mataꞌine nene di gopo igi di engita igi idoꞌ apa niteꞌ igi gamazi haꞌna haꞌna li Oꞌmosola laaꞌ nave. Gamene nabauꞌ aꞌmine ve nene Oꞌmosoꞌmo lihime naba goloso ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Izesuꞌ aza monoꞌ numuno nabauꞌ moni milaaꞌ aniꞌ bokisi gahevela mino eveneꞌ mukiꞌ aꞌmine bokisiuꞌ moni nihulavo ninge minineꞌ. Moni heneni ve mukiꞌ nete nene moni vaiꞌ hulikaꞌ hulikaꞌ navo ");
INSERT INTO aso_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","veneꞌ gevonoꞌ gohoꞌ minineꞌ ma aza ogo guleheꞌ moni ngomo setaꞌ hulineꞌ. Aꞌmine moni ngomo setaꞌ nene do bizo tili (3) toea ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Neꞌmine ogavo Izesuꞌ izipahala zuho asi lo-ngemavo ezela ikevo tiꞌ lo lo-ngimineꞌ: Laminetoꞌ nolo-lingimuve. Veneꞌ gevonoꞌ gohoꞌ veneꞌ meꞌmo moni hulineꞌ neꞌmo nene eveneꞌ mukitoꞌ moni hulaniꞌ nene ngivileꞌ ivosa hulave. ");
INSERT INTO aso_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Neꞌmine ngivileꞌ ogo hulave luvoniꞌ nene eveneꞌ mukiꞌ ingine moniꞌine vaiꞌ lo miningutiꞌ hulaniꞌza aza nene nosoꞌ niteꞌve do sotoꞌ ilineꞌ initeꞌ gohi ma minamivo initeꞌ mataꞌ gohoꞌ neingutiꞌ nene hulave lo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Izesuꞌ monoꞌ numuno nabautiꞌ nolimivo izipahala zuhoutiꞌ maliꞌmo tiꞌ lo lo-imineꞌ: Tisazo, ningezo. Numuno mene geheni amebe gehenidunuꞌ numuno atoliꞌmine lamineꞌ goloso gizikeve. ");
INSERT INTO aso_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Numuno naba mene ninge nabe. Neꞌmi geheniꞌve nene bili ngululubizi hulikevo geheni sitaꞌ neꞌminesi ma bizi minamilisasive. ");
INSERT INTO aso_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Neꞌmine lo Oliva gololoꞌ dizo monoꞌ numuno nabala vele ize hulo neivo Petolole Zakobole Zohanele Adeleale angisevoꞌ mini Izesuꞌni longoꞌ i-daniꞌ: ");
INSERT INTO aso_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Idiꞌne laineꞌ initeꞌ nene naniheꞌ sotoꞌ ilive. Idoꞌ aꞌmine gamazi nene gihile izelesa neivo noso molo naniteꞌ naniteꞌ sotoꞌ ilihe. Nemuꞌ lo-lemezo. ");
INSERT INTO aso_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tiꞌ li longoꞌ i-dikevo aza apiꞌ ogo tiꞌ lo lo-ngimineꞌ: Ve malite gotine izi lengeleꞌmize gopo ikelizaze. Lingine eheꞌ igi ningisa minilo. ");
INSERT INTO aso_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eveneꞌ mukiꞌ nete nene neniꞌ guliveꞌne igi aꞌmine Oꞌmosoꞌmo do lunguꞌ izelive lo nimiselelesa live ma nene naꞌmo nouve li goꞌine izi eveneꞌ mukiꞌ ngeleꞌmize gopo ilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Idoꞌ lovo sotoꞌ neivo nigili ma idoꞌ ebeꞌ mala mala lovo sotoꞌ neivo neꞌmi gamazi nigili ma upuhoꞌ igi golise gilamilo. Aꞌmine initeꞌ nene sotoꞌ oloseiha initeꞌ vaiꞌ osuꞌ lilineꞌ gamene naba nene aꞌmidoꞌ olihe sotoꞌ amive. ");
INSERT INTO aso_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Idoꞌ misubo mauꞌ vete misubo mauꞌ vesi lovo hizilisave. Idoꞌ guvelesi ve naba maliꞌmi zuhote guvelesi ve naba maliꞌmi zuhosi lovo hizilisave. Misubo ato atota mimiꞌ okaꞌ okaꞌ oloseive. Idoꞌ gaꞌna naba helaaꞌ gamene nevosi nene sotoꞌ okaꞌ okaꞌ oloseive. Venelite izipe gidilisa mulumo apiꞌ igi gili gilikaꞌ gilikaꞌ iꞌmi iꞌmi navo alingeꞌ izipahaꞌine sotoꞌ ogaꞌ neive. Aꞌmineꞌmine ogo aꞌmine mulumo niteꞌ sotoꞌ ilineꞌ nene ha apiꞌ ilineꞌ nenako nemuꞌ nene gilikaꞌ gilikaꞌ iꞌmi navo alingeꞌ naza sotoꞌ olosuve. ");
INSERT INTO aso_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Idoꞌ lingine nene eheꞌ igi ningisa minilo. Kanisoleꞌnidoꞌ gonitoꞌ lengeleꞌmizi milalisave. Monoꞌ numuꞌninguꞌ lingibililisave. Nenita giꞌmizi minangumuꞌ ve li gonitoꞌ lengeleꞌmizi milikevo guveꞌinesi ve nabaliti veꞌnidokisi ngamani nabaliti veꞌnidokisi oti mini neze monovoꞌne li sotoꞌ igi li-ngimilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Neꞌmine ilizaniꞌza gamene naba olihe amivo gomuꞌ nene monoꞌ gamazi lamineꞌ di hutileꞌ igi li sotoꞌ i-ngimikevo eveneꞌ zuho ato atoꞌ mukita voloseive. ");
INSERT INTO aso_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Idoꞌ adidoꞌ di lengeleꞌmizi gonitoꞌ milalisa navo ma nani gamazi lolone li gatine mukiꞌ gilamilo. Lengiꞌ gamazi nomive. Oꞌmosoꞌmi Sikalahuꞌ eiꞌ gamazi lilisanaze. Asi Oꞌmosoꞌmo aꞌmine gameneloꞌ gatinguꞌ do sotoꞌ ilineꞌ gamazivoꞌ nene lilo. ");
INSERT INTO aso_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Idoꞌ eveneꞌ nenikumuꞌ gili eleꞌvoleꞌ amaniꞌ nete nene nenikumuꞌ gili eleꞌvoleꞌ ave nene ngibili hililizave li gonitoꞌ ngeleꞌmizi milalisave. Ee, mo uvoꞌninge nakuꞌninge nilizaniꞌ netesi idoꞌ izeꞌninge meꞌninge izipahaꞌine zuho nilizaniꞌ netesi nene ha neꞌmine ilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Neniꞌ guliveꞌne di minilizangumuꞌ eveneꞌ mukiꞌ nete nene lengikumuꞌ goloso gililisave. Neꞌmine ilizaha eveneꞌ ma nenikumuꞌ ha gili eleꞌvoleꞌ igi mini huli-nidamavo gamene naba ilineꞌ nene Oꞌmosoꞌmo do nguꞌ izeleseive. ");
INSERT INTO aso_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Alingeꞌ nene ebeꞌ do goloso ilineꞌ initeꞌ goseleꞌ niteꞌ goloso gehepeve ma aloseive laniꞌ ma nene aꞌmida minamilidoꞌ o neineꞌ ebeta sotoꞌ oloseive. (Aꞌmene gizuvoniꞌ gamazi mene gato nogelo ma gatelinive gaza gele ngoloꞌ lo gelezo.) Neꞌmino sotoꞌ neivo niningi ma Zudaia misubo meuꞌ nilizave lingine aꞌmidoꞌ geti golise golola vi halekilizave. ");
INSERT INTO aso_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ehe, aꞌmine gameneuꞌ nene silibe ogo minaaꞌ nene nominako ve ma ingine numuꞌine avitasi nilizadotiꞌ nene iheꞌ numuꞌninguko vi initeꞌ mataꞌine aꞌminguꞌ neineꞌ nene di vamilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Idoꞌ minguꞌ nilizadotiꞌ nene okoꞌnidoꞌ initeꞌine dalisa tineꞌ mili numunguꞌ amilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Agae, aꞌmine gameneuꞌ nene izipahaꞌine minineꞌ venekumukisi idoꞌ izipe amidoꞌ nizaniꞌ venekumukisi nene mo mulumo gele-ngedekuve. Geꞌnebe goloso ilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Luvoniꞌ initeꞌ nene goline gameneuꞌ sotoꞌ ogalive li Oꞌmosola li minilo. ");
INSERT INTO aso_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ne nanitekumuꞌ ve. Oꞌmosoꞌmo initeꞌ mataꞌ do sotoꞌ idotiꞌ idise noneꞌ gamenela mene mulumo alumo niteꞌ naba neꞌmine gomuta sotoꞌ amineꞌ nenako apiꞌ ogo aꞌmine gameneloꞌ sotoꞌ oloseive. Idoꞌ sotoꞌ ilidotiꞌ nene alingeꞌ gohi ma neꞌmino sotoꞌ amoloseive. ");
INSERT INTO aso_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Guvelesi veꞌmo aꞌmine gamene nene mine haꞌna ogalive lo bele hukolove ma lamidiniko eveneꞌ hamoꞌ veꞌinesi ma minamadineꞌza eiꞌ evenele ve lo ngeleꞌmize kegesineꞌ evenelemuꞌ nene gelosa aꞌmine gamene nene mine haꞌna alive lo bele hukolosa lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aꞌmine gameneuꞌ nene ve maliꞌmo ningilo. Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live aza mela neive lo idoꞌ ningilo. Holela neive lo nolo-lingimivo ma nene gili imamilo. ");
INSERT INTO aso_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Idoꞌ nanitekumuꞌ ve. Eveneꞌ ma nete soza li linge ma Oꞌmosoꞌmo do lunguꞌ izeline lo nimiselelesa live nouve li idoꞌ linge ma Oꞌmosoꞌmi gamazi lo sotoꞌ ogaꞌ nouve polohete nouve li sotoꞌ igisa Oꞌmosoꞌmo eiꞌ ve lo ngeleꞌmize kegesineꞌ eveneꞌve nene goꞌine izekunivo leꞌmetilizahe li ngeleꞌmize gopo ilisa atoꞌ nitekisi eveneꞌ golize laaꞌ nitekisi di sotoꞌ igi ngelebizilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mene initeꞌ nene olihe sotoꞌ amivosa initeꞌ mukikumuꞌ gomuꞌ nolo-lingimuze. Ehe, mo gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aꞌmine mulumo niteꞌ sotoꞌ ogo minelineꞌ gamene osuꞌ lavo alingeꞌ nene holiꞌmi labanala nolihizivo ikeꞌniꞌmi labanala osuꞌ lavo ");
INSERT INTO aso_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sonohiꞌ nene okulumokutiꞌ diꞌmoziꞌ moziꞌ navo okulumokuꞌ amuzoꞌinesi niteꞌ nene moꞌmongoꞌ i geseꞌ navo ");
INSERT INTO aso_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oꞌmosolatiꞌ ve gihile neniꞌ nene amuzo naba do mino labanaꞌnesi limuso avileloꞌ nolimuvo ningilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Neꞌmine ogo angeloꞌ ngimiselekuvo vi ngeleꞌmize kegesuvoniꞌ eveneꞌne nene misubo ato atokuꞌ miniꞌmi minaniꞌ ebeꞌ mukikutiꞌ nene moni ngeleꞌmizi di nubo i-ngidilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Idoꞌ gohuno zaloꞌ lo molaloniꞌ nene gili lamineꞌ igi gililo. Lingine Zuda veti misubotida mene gohuno zalotiꞌ sisive hoꞌlavo mo hoꞌ gamene alitave li ningi gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Idoꞌ aꞌmineꞌmine ogo aꞌmine nolo-lingimuvo niteꞌ nene sotoꞌ neivo ma aza avitoꞌ ogo mo nene hetelelesa neive li ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Laminetoꞌ ma lo-lengemeloze. Gililo. Aꞌmine gameneloꞌ aleve nene ha mini olihe hili osuꞌ lamavosi aꞌmine initeꞌ mukiꞌ nene sotoꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Okulumoki misubogi nene ha vi osuꞌ lilisasineꞌza aꞌmine gamaziꞌne nene mo osuꞌ lamo eleꞌvoleꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Neꞌmine o neineꞌza aꞌmine sotoꞌ ilineꞌ gamenemuꞌ nene ve hamolitesi ma gelamune. Idoꞌ Okulumokuko angelolesi nene gilamave. Idoꞌ Oꞌmosoꞌmi gipele nazasi nene ma gelamuve. Meꞌneho eiꞌ hamoꞌ nene gele neive. ");
INSERT INTO aso_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sotoꞌ ilineꞌ gamene nene naniheꞌ nolihe lingine ma gilamanaze. Eheꞌ igi gizebo igi minilo. ");
INSERT INTO aso_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Idoꞌ ma neꞌmino neive: Ve maliꞌmo venenga volosa numuꞌve ebeꞌve hulosa gelekeleꞌ izipahala initeꞌveloꞌ gizebo ve hulo-ngedo hamoꞌ hamoꞌ nene gono ngemo gatedoꞌ gizebo ilivemuꞌ nene gatedoꞌ gizebo lekeseve ilive lo lo-doosa vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Numuno meleho alineꞌ gamene nene nivengaꞌ alihe holukaꞌ oloꞌmudise alihe goꞌ nuvonuvo neivo nehe goꞌ lo labanaꞌ elelesa neivo nehe lingine gilamanaze. Liteꞌ lo ogo ingi nizavo ningalize. Nemuꞌ gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lengiꞌ nolo-lingimuvoniꞌ gamazi mene eveneꞌ mukikumukisi nene noluve. Gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Isilaeleꞌ aleveti avotemote Aigita misubouꞌ minaniꞌ gameneuꞌ Oꞌmosoꞌmo iseꞌine izingumuꞌ gelo holiseꞌ mino nosoꞌ niteꞌ naaꞌ nouneꞌ gamene adoꞌ lulu izamineꞌ beleti naaꞌ nouneꞌ holiseꞌ nene olosa gamene setaꞌ lumo ha neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ apizi ngimaaꞌ avesi Izesuꞌni analoꞌ di bililisa gilaniꞌza holiseꞌ gameneuꞌ nene eveneꞌ vaiꞌ di geseꞌ igi ningi nizavo analoꞌ daloneꞌ nene lovo di sotoꞌ ikelizanako holisekuꞌ nene alamolone li zegeni analoꞌ di bililiza akamuꞌ viseꞌ iꞌmi vi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Neꞌmine igi nizavo Izesuꞌ Betani numuda mino ganadise gozopoꞌ ma gize dave Simoniꞌ neꞌmi numuꞌveuꞌ dizo mino nosoꞌ niteꞌ no neivo veneꞌ maliꞌmo unuvo laminekisi uveli lamineꞌ gehepeve meniꞌve dizo minineꞌ gulive nalida nene luhuvo laminekisi gehenidunuꞌ liliꞌ aniꞌ botolokuꞌ minineꞌ nene do ogo botololiꞌmi velela ize siꞌze hulo aꞌmingutiꞌ uveli nene Izesuꞌ godolouꞌ leke-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Leke-davo eveneꞌ linge ma nete muluꞌninguꞌ goloso gili engikuꞌ tiꞌ li laniꞌ: Uveli nene nani monovomuꞌ do labuluvo neive. ");
INSERT INTO aso_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aꞌmine uveli nene maketi miladini sigisi hadeti Kina (K600) ivileꞌ ivosa moni naba dadinako maketi mili meni di gohoꞌ gahaliꞌ ngimilizanako ve li elemikevo ");
INSERT INTO aso_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Izesuꞌ aza gelo tiꞌ lo lineꞌ: Huli-dilo. Aza naniteꞌ do goloso ogavosa genivesi gamazi nili-dave. Veneꞌ neꞌmo initeꞌ lamineꞌ noo-nidivo ede vive. ");
INSERT INTO aso_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nene nanitekumuꞌ ve. Lingine nene gohoꞌ gahaliꞌ alevesi mini di vi minilizaniꞌ nenako lingine ngeleꞌmize lamineꞌ olone li gililizaniꞌ nene nani gamenela gililizahe aꞌmidoꞌ ha ngeleꞌmize lamineꞌ ilisaniꞌza nezesi nene mudive ma mini di vi minamilisave. ");
INSERT INTO aso_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aza ilidoꞌ o minineꞌ niteꞌ nene ogave. Galese izi-nidilizangumuꞌ nene gomuꞌ okoꞌne do lamineꞌ o-nedo holo-nedave. ");
INSERT INTO aso_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Naza laminetoꞌ lo-lengemeloze. Gililo. Monoꞌ gamazi lamineꞌ mene di misubouꞌ misubouꞌ moni li-ngimilizadaa nene eze guvele nene ha gili minilizave li aza initeꞌ o-nidineꞌ nemukisi li sotoꞌ igi li-ngimilizave. ");
INSERT INTO aso_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Neꞌmine ogavo Izesuꞌ izipahala zuho tuvelu engikutiꞌ Kelioto numudotiꞌ ve ma gulive Zudaꞌ aza Izesuꞌni ngelebizekuvo dalizave lo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabala vo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lo-ngemavo muluꞌninguꞌ lamineꞌ gili moni emelone lii li huki-dikevo aza vo Izesuꞌni nene ngelebizeli akamuꞌ viseꞌ ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Zuda vete lulu izamineꞌ beleti naaꞌ nouneꞌ holiseꞌ nene apiꞌ neivo Oꞌmosoꞌmo avotemotine iseꞌine ize-ngidingumuꞌ gele mino naaꞌ nouneꞌ nosoꞌ niteꞌ naloningumuꞌ sipisipi angale belaaꞌ nouneꞌ gameneloꞌ nene Izesuꞌ izipahala zuho nete tiꞌ li longoꞌ i-daniꞌ: Oꞌmosoꞌmo avotemotine iseꞌine ize-ngidingumuꞌ gelo naaꞌ nouneꞌ nosoꞌ niteꞌ nene zala vo do vaꞌvaꞌ o-gedelone lo nolane. ");
INSERT INTO aso_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Likevo izipahala zuhoutiꞌ ve setaꞌ ma nongimiselo tiꞌ lo lo-ngimineꞌ: Numuno nabala vi nihetelasivo ve maliꞌmo misubo somouꞌ noso ohizo geho navo voteneꞌ ilisaze. Lingine eꞌmeti vilizo. ");
INSERT INTO aso_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Numuno mauꞌ dizo vavo ma aꞌminguꞌ vi numuno neꞌmi melehine tiꞌ li li-imilizo: Tisate neꞌmo tiꞌ lo lave: Nazasi izipahaꞌnesi Oꞌmosoꞌmo avotemotine iseꞌine izingumuꞌ gelo naaꞌ nosoꞌ niteꞌ naloneꞌ numuno lulo nene zauꞌ nalone. ");
INSERT INTO aso_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Likesivo numuno meleho aza numuno veletoꞌ mino galaꞌmudoꞌ mino ingutiꞌ veletoꞌ nene lulo nabasi mininguꞌ initeꞌ mataꞌ aviliseꞌ i nizaniꞌ nene lengelebizeleseive. Aꞌminguꞌ nene nosoꞌ nitete di vaꞌvaꞌ ilizo. ");
INSERT INTO aso_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tiꞌ lo lo-ngemavo izipahala setaꞌ ingine oti numuno nabala vi heteli lo-ngimineꞌ maꞌmine ogavo Oꞌmosoꞌmo iseꞌine izingumuꞌ gelo naaꞌ nouneꞌ nosoꞌ niteꞌ nene di vaꞌvaꞌ asineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Neꞌmine ikesivo mo nivengaꞌ molavo Izesuꞌ aza izipahala zuho tuvelu nesi aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nosoꞌ niteꞌ ni nizavo Izesuꞌ aza tiꞌ lo lineꞌ: Laminetoꞌ ma lo-lengemeloze. Gililo. Nosoꞌ niteꞌ nonunive lengikutiꞌ maliꞌmo nenikumuꞌ me neive lo biluvaliti aꞌninguꞌ molaloseive. ");
INSERT INTO aso_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lavo ingine mulumo gili igi hamoꞌ hamoꞌ longoꞌ i-daniꞌ. Nenikumuꞌ lamo nolosane. Olo. ");
INSERT INTO aso_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Neꞌmine li longoꞌ i-dikevo aza tiꞌ lo lo-ngimineꞌ: Aꞌmine ve nene lapese hamokutiꞌ nonunive tuvelu lengikutiꞌ hamoliꞌmo neꞌmine oloseive losa noluve. ");
INSERT INTO aso_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ee, Oꞌmosolatiꞌ ve gihile nenikumuꞌ polohetelite gizi nizadoꞌ eꞌmeto heleloniꞌ akaloꞌ novuvoniꞌza biluvalite neniꞌ dalizave lo do sotoꞌ o-nedelive nene agae, mo mulumo gono goloso daloseinako nemuꞌ aꞌmine ve aza izeleho ma gedamidiniko aꞌmine mulumo gono sotoꞌ o-delesa neineꞌ akaloꞌ nene ma mine molo minamivo lamineꞌ o minidine. ");
INSERT INTO aso_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nosoꞌ niteꞌ ninavo Izesuꞌ aza beleti do Oꞌmoso opoꞌni lo gito nongemo tiꞌ lo lineꞌ: Dalo. Mene neniꞌ meꞌmeleꞌne ma ne neive. ");
INSERT INTO aso_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Neꞌmine lo vaini gomise do Oꞌmoso opoꞌni lo ngemavo aꞌmingutiꞌ vaini noso ninavo ");
INSERT INTO aso_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","tiꞌ lo lineꞌ: Oꞌmosoꞌmo lo huko-lidineꞌ gamazi nene do eleꞌvoleꞌ ilineꞌ vaniseꞌne nene eveneꞌ mukikumuꞌ ve lo lekeloniꞌ vanise mene neive. ");
INSERT INTO aso_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Laminetoꞌ lo-lengemelove. Naza vaini gihileꞌmi novozo nene gohi ma namo mino alingeꞌ Oꞌmosoꞌmo gizebo o-lengedelineꞌ gameneloꞌ nene aꞌmine novozo atoliꞌmine gosohoꞌ nalosuve. ");
INSERT INTO aso_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Neꞌmine lavo monoꞌ nama lisa limi heta igi Oliva golola dizi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dizi minikevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Monoꞌ Godolouꞌ nene Oꞌmosoꞌmo lineꞌ gamazi ma tiꞌ li gizi nizaniꞌ ve: Gizebo veꞌine belekuvo sipisipi ize hutileꞌ igi vilisave. Tiꞌ li gizi nizaniꞌ nenako lingine mukiꞌ huli-nidii vilisaniꞌza ");
INSERT INTO aso_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","helekuvo Oꞌmosoꞌmo neleꞌmize otavo gomuꞌ molo-lengemo nGalilaia misubouko volosuve. ");
INSERT INTO aso_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lavo Petoloꞌ aza tiꞌ lo lo-imineꞌ: Ingine mukitoꞌ huli-gidii vilizaniꞌza neniꞌ nene mo neꞌmine amolosuve. ");
INSERT INTO aso_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Laminetoꞌ nolo-gimuve: Idise holukaꞌ gehepeve nene okoloho nolo setaꞌ olihe molamivo gaza gamene setohamo ataize lo-nedelesane. ");
INSERT INTO aso_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lavo Petoloꞌ pigi izo tiꞌ lo lineꞌ: Oꞌove. Ge gibili hili nesi nibili hililisa lilizanikisi nene ataize lo-gedamolosuve. Lavo izapahala zuho linge nesi aꞌmineꞌmine li osuꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Idoꞌ ingine vi ebeꞌ ma gulive Gesemani nela vi hetelikevo izipahala zuho tiꞌ lo lo-ngimineꞌ: Naza Oꞌmosola nololongumuꞌ lingine meloꞌ mitoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Neꞌmine lo Petolole Zakobole Zohanenginevoꞌ ngeleꞌmizo novivo Izesuꞌ mulunouꞌ nene apiꞌ ogo hongiliꞌ hongiliꞌ ogo minivo gala mukiꞌ gilidiꞌmo mulumo naba gelo ");
INSERT INTO aso_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","tiꞌ lo lo-ngimineꞌ: Naza mo muluꞌneuꞌ mulumo goloso ogo geni naba idiꞌmo heleloniꞌ akaloꞌ mine molokuve. Lingine meloꞌ gizebo igi ningi minilo. ");
INSERT INTO aso_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Izesuꞌ aza neꞌmine lo ngomo ma hotoꞌile novo misuboloꞌ golo hizo ongo aꞌmine mulumo gamene nene ivileꞌ ogo vilidoꞌ o nolineꞌ nene ivileꞌ ogo viliho lo ivileꞌ ogo vilingumuꞌ Oꞌmosola lo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ahono meꞌneho make, osoꞌ amosoꞌ initekisi ha ilinidoꞌ o neineꞌ nenako mulumo ekeseꞌ naaniꞌ mene do olovoꞌ o-nedezo. Do olovoꞌ o-nedelineꞌza neniꞌ luꞌneloꞌ amozo. Asi geiꞌ lukaloꞌ ozo. ");
INSERT INTO aso_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Neꞌmine lo tineꞌ molo vo okise ingi nizavo ningo Petoloꞌni tiꞌ lo lo-imineꞌ: Simoni, gaza okise ongo nabe. Gamene ngomosi vanu aua neꞌminemuꞌ ha veka ma ninge minamilinidoꞌ o nehe. ");
INSERT INTO aso_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lengemenguꞌ milalizanguꞌ nene gopo ikelizaze. Gizebo igi Oꞌmosola li minilo. Ee, lutine neꞌmo gono dalosa neiha okodine neꞌmo nene geni o neive. ");
INSERT INTO aso_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tiꞌ lo lo-ngemo gohi vo gomuꞌ lidiꞌmino Oꞌmosola loo ");
INSERT INTO aso_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","gohi tineꞌ molo ogo ningineꞌ nene veꞌine hihiꞌ ogavo okise ingi nizavo ningineꞌ. Neꞌmine neivo nadive lo-emelone lii li-imiliza gamazimuꞌ viseꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gohi vosa iheꞌ ogo gamene setohamo ogavo tiꞌ lo lo-ngimineꞌ: Okise ingi mini gililisa gili nizahe. Mo aꞌnesiꞌ ve. Ningilo. Oꞌmosolatiꞌ ve gihile neniꞌ nene di sotoꞌ igi ve golosoliti aꞌninguꞌ milalizaniꞌ gamene nene mo ogaze. ");
INSERT INTO aso_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Otilo. Mo volonge. Ningilo. Biluvalite dalizave lo neze do sotoꞌ ilive nene mo avitoꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tiꞌ lo nolo-ngimivo aꞌmidoꞌ geto izipahala zuho tuvelu engikutiꞌ ve gonoꞌnibo Zudaꞌ aza ogo hetelineꞌ. Idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ apizi ngimaaꞌ avesi monoꞌ gizebo vesi mini eveneꞌ mukiꞌ ngimiselikevo bainati mitekisi gavososi davo Zudalesi makaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Idoꞌ olihe igi hetelami Izesuꞌni do sotoꞌ o-ngidive neꞌmo gomuꞌ tiꞌ lo lovo gize ngimineꞌ: Golo elo nalo ve nene mo aꞌmine ve mineleseize. Dalo. Golise valize. Gizebo lamineꞌ igi eleꞌmizi vilo. ");
INSERT INTO aso_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Neꞌmine losa Izesuꞌ neida geto vo Tisazo loo golo elo naniꞌ. Golo elo navo ");
INSERT INTO aso_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","makaꞌ ave ingine ningi analoꞌ daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Neꞌmine ikevo Izesulesi aꞌmida minaveutiꞌ maliꞌmo bainati miteꞌ gokutiꞌ geleleheꞌ ogo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nabaliꞌmi gelekeleꞌ izipeꞌmi gala belo hasaꞌ o hulineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Idoꞌ Izesuꞌ aza analoꞌ dave tiꞌ lo lo-ngimineꞌ: Gizengize ve ma dalisa igaꞌ adiꞌmine igi bainati mitekisi gavososi di neniꞌ dalisa ahe. ");
INSERT INTO aso_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naza gamene gamene monoꞌ numuno nabauꞌ linginesi makaꞌ mino monoꞌ apize ngemaaꞌ uvoniꞌ maloꞌ nene aꞌneloꞌ damaniꞌ nehe. Aꞌmine gamene maloꞌ aꞌneloꞌ dami mini idise mene daniꞌ nene monoꞌ godolouꞌ gizi nizaniꞌ gamazi ma nene gihile izelineꞌ nenaze. Ha neꞌmine ilo. ");
INSERT INTO aso_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Neꞌmine lavo izipahala zuho mukiꞌ huli-di golise vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Golise vikevo gosoꞌve ma lavolavo mokonokovoꞌ liko eꞌmeto novivo ezesi daniꞌza ");
INSERT INTO aso_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lavolavolokovoꞌ dikevo lavolavo apase hito bakaꞌ golise vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Idoꞌ Izesuꞌni eleꞌmizi evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba neida vaniꞌ. Neꞌmine ikevo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba mukikisi monoꞌ apizi ngimaaꞌ avesi monoꞌ gizebo vesi mukiꞌ di geseꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Izesuꞌni eleꞌmizi nivavo Petoloꞌ aza hotoꞌile eꞌmete-do ogo heta minamo aꞌmine dizi minaniꞌ numuno nene vodo vodo ogo minavo olusoꞌ misubo vovo haza minidoꞌ gelekeleꞌ izipe oloꞌ gizi lahizi minangukisi hozi dizo vovoꞌninguꞌ mino oloꞌ lahizo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Neꞌmino neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi Zuda veti kanisole vaikisi mini nani lihimemuꞌ Izesuꞌni belelone li lihimeꞌve li sotoꞌ ilizavemuꞌ viseꞌ aniꞌza ");
INSERT INTO aso_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","eveneꞌ mukiꞌ soza saza gamazi likevo gamaziꞌine vo hamoꞌ amivo bililizadoꞌ o minineꞌ gamazi ma di sotoꞌ amaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Neꞌmine ikevo malite oti soza saza gamazi ezemuꞌ tiꞌ li laniꞌ: ");
INSERT INTO aso_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Aza tiꞌ lo livo giluneꞌ ve: Monoꞌ numuno naba mene eveneꞌ aꞌinedunuꞌ gizaniꞌ nene izo kuso gamene setohamo ogavo gohi ma eveneꞌ aꞌinedunuꞌ gizamilizaniꞌza neniꞌ lokuvo sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tiꞌ lo live li laniꞌza engiꞌ gamazi nene vo hamoꞌ amivo ");
INSERT INTO aso_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nabaliꞌmo vovoꞌninguꞌ ote mino Izesuꞌni longoꞌ o-do tiꞌ lo lineꞌ: Gaza nilaniꞌ gamaziloꞌ mene do velepeꞌ izo lo-ngemelineꞌ gamazi ne nomihe. Mene ve nete geikumuꞌ nilaniꞌ gamazi nene gelanivo nadiꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tiꞌ lo longoꞌ o-dineꞌza aza vele bizo mino gamazi ma do velepeꞌ izo lo-emamineꞌ. Neꞌmine amivo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba aza gohi longoꞌ o-do tiꞌ lo lineꞌ: Gulive do hozi laaꞌ nounive Oꞌmoso neꞌmi gipele do luꞌ izelive lo imiselelesa live ma nene geiꞌ ne nabe. ");
INSERT INTO aso_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Neꞌmine lo longoꞌ o-davo Izesuꞌ aza tiꞌ lo lineꞌ: Aꞌmine ma nene nouve. Idoꞌ Oꞌmosolatiꞌ ve gihile naza nene amuzoꞌvesi minive Oꞌmosolotiꞌ lemo nouvoniꞌ nenako nemuꞌ ana hulaaꞌ ida mitoꞌ nouvo ningilisave. Idoꞌ Okulumotoꞌ limuso avileloꞌ nolimuvo ningilisave. ");
INSERT INTO aso_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lavo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive naba neꞌmo Izesuꞌ aza Oꞌmoso ivileꞌ olosa gamazi goloso lihe lo gala gilineꞌ nene ngelebizelesa asiꞌve ngolokineꞌ geneganaꞌve nene do nohikelo tiꞌ lo lineꞌ: Lihimeꞌve li sotoꞌ ilizavemuꞌ nene gohi nanimuꞌ viseꞌ olone. ");
INSERT INTO aso_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Oꞌmoso ivileꞌ o-do gamazi goloso lineꞌ nene langisetine mo gilikeve. Nemuꞌ lingine gilikevo nadiꞌ o neive. Lavo ingine mukitoꞌ tiꞌ li laniꞌ: Aza nene mo lihime naba daanako mo helelidoꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Neꞌmine likevo malite gituhoꞌ i-di veleloꞌ hiti mini aꞌine gavoso nibili tiꞌ li laniꞌ: Zaho nogibilihe. Gaza polohetelite laaꞌ adiꞌmine ogo lo sotoꞌ ogo lo-lemezo. Likevo gelekeleꞌ izipe nete Izesuꞌni di aꞌine gatapaꞌ gavoso bilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Neꞌmine igi nizavo Petoloꞌ aza numuno vodo vodo ogo minavo olusoꞌ omoꞌ naba minidoꞌ galaꞌmuda neivo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nabaliꞌmi gelekeleꞌ alu maliꞌmo ogo ");
INSERT INTO aso_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petoloꞌ nene oloꞌ lahizo neivo ningo ninge lamineꞌ ogo tiꞌ lo lineꞌ: Gazasi nene Nasalete ve Izesukisi minaaꞌ asive ma nene nane. ");
INSERT INTO aso_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tiꞌ lo lineꞌza aza oꞌve lo gaza laineꞌ gamazi nene gelamo aꞌmineꞌmi monovosi gele lamineꞌ amuve lineꞌ. Neꞌmine loo gateda lemo vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Minavo gelekeleꞌ alu neꞌmo gohi eze ningo aꞌmida minave gohi lo-ngimineꞌ: Mene ve nene aꞌmine zuhoutiꞌ ma ne neive. ");
INSERT INTO aso_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lavo gohi ataize gehepeve lineꞌ. nGomo lasolo ma nimini aꞌmida minave nete Petoloꞌni tiꞌ li li-imaniꞌ: nGalilaialatiꞌ nainako gaza nene mo lamineꞌ eze zuho nane. ");
INSERT INTO aso_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Neꞌmine likevo aza gosohoꞌ noluvo ma Oꞌmosoꞌmo usiꞌ ize-nidivo loo laminetoꞌ noluve. Oꞌmosoꞌmi veleloꞌ lo huko noluve lo tiꞌ lo lineꞌ: Lingine naza ma ningo gelamuvemuꞌ nilave. ");
INSERT INTO aso_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lavo okoloho neꞌmo aꞌmidoꞌ geto nolo gohi ma molavo gamene setaꞌ ineꞌ. Neꞌmine ogavo Petoloꞌ aza Izesuꞌ lo-imineꞌ gamazi nene okoloho nolo gamene setaꞌ olihe molamivo gaza gamene setohamo nenikumuꞌ ataize lo-nedelesane lo lineꞌ gamazi nene gohi gelo ive naba goloso ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nedengaꞌ goꞌ nolivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ gizebo vesi monoꞌ apizi ngimaaꞌ avesi kanisole mukiꞌ nesi ingine lovo gizi gamazi li huki Izesuꞌni analoꞌ nalaꞌ di-di eleꞌmizi vi Pilatoꞌ anauꞌ milaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Neꞌmine ikevo Pilatoꞌ aza longoꞌ o-do tiꞌ lo lineꞌ: Gaza nene Zuda veti guveꞌinesi ve naba nabe. Olo. Neꞌmine lo longoꞌ o-davo tiꞌ lo lo-imineꞌ: Mo gasika nene nolaineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nete initeꞌ mukikumuꞌ goniꞌ i-dikevo ");
INSERT INTO aso_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoꞌ tiꞌ lo gohi longoꞌ o-dineꞌ: Ingine neꞌmine manaꞌmine nitekumuꞌ goniꞌ nogidune li initeꞌ mukikumuꞌ nilaniꞌ nene gele nabe. Nemuꞌ do velepeꞌ izo gamazi gaza ma lo-ngemelineꞌ nomihe. ");
INSERT INTO aso_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Neꞌmine lo longoꞌ o-dineꞌza Izesuꞌ aza gamazi gohi ma do velepeꞌ izo lamivo Pilatoꞌ aza gala mukiꞌ gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kilisimasiloꞌ kilisimasiloꞌ Oꞌmosoꞌmo Zuda veti avotemotine iseꞌine izingumuꞌ gelo holiseꞌ minaaꞌ uneꞌ gameneloꞌ gameneloꞌ nene Zuda ve nete galapuso ve mukiꞌ minangutiꞌ nene hamoꞌ ma heta vilive li gulive ikevo Pilatoꞌ aza aꞌmine ve nene nalaꞌ numungutiꞌ hulo heta o-ngedaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Idoꞌ ve malite ngamani lovo ngimi eveneꞌ ngibilavo galapuso numunguꞌ huli-ngidikevo aꞌmine gameneloꞌ nene inginesi aꞌminguꞌ minaniꞌ. Aꞌmine veutiꞌ nene ve ma gulive Balabasiꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Minineꞌ nenako eveneꞌ mukiꞌ di geseꞌ igi Pilatoꞌ neida vi kilisimasiloꞌ kilisimasiloꞌ ogaꞌ ineꞌ maꞌmine ogo eveneꞌ ma hulo heta o-delive li longoꞌ i-di minikevo ");
INSERT INTO aso_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatoꞌ aza do velepeꞌ izo tiꞌ lo longoꞌ o-ngidineꞌ: Lengiꞌ Zuda veti guvetinesi ve iseve izo hulo-delongumuꞌ nilahe. ");
INSERT INTO aso_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Idoꞌ neꞌmine lo longoꞌ o-ngidineꞌ nene eveneꞌ vaiꞌ Izesuꞌni eꞌmetaniꞌ nenako nemuꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nete ezemuꞌ muluꞌninguꞌ goloso gilii nemuꞌ gonitoꞌ eleꞌmizi milikeniꞌ neivo nemuꞌ Pilatoꞌ aza ningo gelo longoꞌ o-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tiꞌ lo lineꞌza evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nete eveneꞌ mukiꞌ gaꞌine di aꞌmine vemuꞌ lami Balabasiꞌ ve lilo likevo aꞌmidoꞌ gili ngimi Balabasiꞌ ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Neꞌmine likevo Pilatoꞌ aza gohi longoꞌ o-ngedo tiꞌ lo lineꞌ: Zuda veti guvetinesi ve ve lave nene nadiꞌ o-delove. ");
INSERT INTO aso_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tiꞌ lo longoꞌ o-ngedavo di velepeꞌ izi gamazi nabautiꞌ tiꞌ li laniꞌ: Gaza lanivo lohotoꞌ zaloꞌ bili hililizave. ");
INSERT INTO aso_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Likevo Pilatoꞌ aza tiꞌ lo lo-ngimineꞌ: Nanitekumuꞌ lohotoꞌ zaloꞌ belelone. Initeꞌ goloso ineꞌ nene naniteꞌ nolive. Tiꞌ lo lo-ngimineꞌza ingine amuzo mili lohotoꞌ zaloꞌ beleꞌnavo li gohi geligelinga laniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Neꞌmine likevo Pilatoꞌ nene eveneliti muluꞌine do hongu lo Balabasiꞌni hulo heta o-davo engita vineꞌ. Neꞌmine ogo Pilatoꞌ aza lavo ngibilaaꞌ aniꞌ gavosodunuꞌ Izesuꞌni mehene iziviꞌ lediviꞌ igi bilikevo di vi lohotoꞌ zaloꞌ bililizave lo Loma veti ami pilisi ve neti aꞌninguꞌ molaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aꞌninguꞌ molavo eleꞌmizi ngamaniloꞌ gizebo ve nabaliꞌmi numuno olusoꞌ misubo vovo minidoꞌ vii ami lingela asi li-ngidikevo ikevo ");
INSERT INTO aso_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","guleheꞌ lavolavo guveꞌinesi vetevoꞌ ngilaaꞌ aniꞌ neꞌmine ma okoꞌnoloꞌ di ngili-di uhoni nalaꞌ nene di gangi guveꞌinesi ve nabalitevoꞌ maduꞌnidoꞌ gihaaꞌ aniꞌ niteꞌ neꞌmine ma apa niteꞌ igi liliꞌ igi gihi-di ");
INSERT INTO aso_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","apiꞌ igi gekeꞌ vokeꞌ li-dikaꞌ li-dikaꞌ igi mini Zuda veti guveꞌinesi ve naba ma nene gopoꞌni nolo-gidune lii ");
INSERT INTO aso_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","angabadunuꞌ godololoꞌ bilaaꞌ bilaaꞌ idoꞌ gituhoꞌ i-daaꞌ i-daaꞌ idoꞌ gubiꞌ izi imaaꞌ imaaꞌ igi golo izi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Neꞌmini golo izaniꞌ nene osuꞌ lavo lavolavo guleheꞌ nene apasi di huli-di eiꞌ okoꞌnoloꞌ initeꞌve nene gohi di izi-di lohotoꞌ zaloꞌ bililisa eleꞌmizi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Neꞌmine igi nivavo ve ma gulive Simoniꞌ aza Kilene ebetotiꞌ ve Alekisadeki Luhuki meꞌnibo aza Zelusalemi tauni hetatiꞌ aꞌminguꞌ dizo volosa navo voteneꞌ igi Izesuꞌ lohotoꞌ zaꞌveloꞌ nene gehe-delive li amuzonga li-dikevo geho vineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Neꞌmine ogavo Izesuꞌni eleꞌmizi vi ebeꞌ ma gulive Goligota nene leze gamaziutiꞌ nene godolo amuzo ebeꞌ ve ladoꞌ nene vi heteli ");
INSERT INTO aso_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","vaini nosouꞌ mulumo gilamaaꞌ initeꞌ gulive mula nene di gopo igi imaniꞌza namineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Namivo lohotoꞌ zaloꞌ nilidunuꞌ bilisa geneganaꞌve nene izeꞌ mili dalisa do nado izeꞌ molalone li zohiꞌ igi geheni mulo ngomo ma hulikaꞌ hulikaꞌ ikevo ngivileꞌ igi hulave nete dikaꞌ dikaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hoꞌ olihe amuzo nomolavo 9 kiloku neꞌmidoꞌ nene zaloꞌ bili di otaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Neꞌmine ikevo goniꞌ i-daniꞌ lihime li sotoꞌ igi luhuvo tiꞌ li gizikevo minineꞌ: Zuda veliti guveꞌinesi ve naba ve. ");
INSERT INTO aso_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Idoꞌ gizengize ve setaꞌ ezesi makaꞌ lohotoꞌ zaloꞌ ngibili ma ne ana zamela di oti-di ma ne ana adavala di oti-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Neꞌmine ikevo eveneꞌ igi vigi ave nete ungumuꞌ ungumuꞌ izi gizeꞌ i-di tiꞌ li laniꞌ: Oho, monoꞌ numuno naba izo kuso gamene setohamo novivo gohi gizelove laaꞌ anive gaza ");
INSERT INTO aso_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","geiꞌ okonga nene do guꞌ izo lohotoꞌ zalotiꞌ nene apaso lemevo. ");
INSERT INTO aso_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nilavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ apizi ngimaaꞌ avesi aꞌmineꞌmine igi gizeꞌ i-di li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Aza eveneꞌ linge ma nene do nguꞌ izive laniꞌza eiꞌ okoꞌno nene ngelo do uꞌ izamilineꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Oꞌmosoꞌmo Isilaeleꞌ ve do luꞌ izelive lo imiselelesa live leliꞌ guvetesi ve naba nolineꞌ nene lohotoꞌ zalotiꞌ lemelive. Neꞌmine ogavosa laza ningo ezemuꞌ gele eleꞌvoleꞌ oloneꞌ nenako ve li laniꞌ. Likevo lohotoꞌ zaloꞌ makaꞌ ngibilave sitaꞌ nesi aꞌmineꞌmine igi gamazi goloso li-dasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Idoꞌ tuvelu (12) kiloku ogavo nelotiꞌ nene ebeꞌ mukikuꞌ litiꞌmuso ize geseꞌ ogo mine do vo tili (3) kiloku nivengaꞌ ogavo gohi labanaꞌ ilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Idoꞌ tili kiloku ogavo Izesuꞌ aza amuzo molo asi naba lo tiꞌ lo lineꞌ: Eloi Eloi lama sabahatani. Leze gamaziutiꞌ neꞌmi monovo nene neꞌmino neive: Oꞌmosoo, Oꞌmosoꞌne make, nanitekumuꞌ hulo-nedane. ");
INSERT INTO aso_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lavo eze minineꞌ gahevela minave linge ma nete nene gili tiꞌ li laniꞌ: Gililo. Polohete Eliaꞌnimuꞌ asi nolive. ");
INSERT INTO aso_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Likevo ve maliꞌmo nosouꞌ lupizisa lipi naaꞌ aniꞌ initeꞌ ma do ekeseꞌ ogaꞌ ineꞌ vaini nosouꞌ lupizo vaiꞌ lavo vilikiꞌ vilikiꞌ lo nalive lo ngongoꞌnoloꞌ izo noemo tiꞌ lo lineꞌ: Eliaꞌ lemo apase-delihe ninge minelone. ");
INSERT INTO aso_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lavo Izesuꞌ asi naba lo ahuꞌ do dizo hulo hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nohilivo monoꞌ numuno nabauꞌ izi hukikaniꞌ lavolavo nene veletatiꞌ galaꞌmuda limivo izo hoꞌlo setaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Izesuꞌ ahuꞌ do dizo hulo nohilivo ami pilisi veliti gizebo veꞌine naba ma Izesuꞌ velela ote minive neꞌmo ningo tiꞌ lo lineꞌ: Ve mene laminetoꞌ mo Oꞌmosoꞌmi gipele minaniꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Idoꞌ veneꞌ linge ma nene hotoꞌ gidini mini ningi minaniꞌ. Aꞌmine veneꞌ mukiꞌ minanguꞌ nene Mangadala numudotiꞌ veneꞌ Maliaꞌ nesi idoꞌ eiꞌ abalaho adoꞌ Zoseki idoꞌ Zakoboꞌ ngomogi netise izeꞌnibo nesi idoꞌ Salomeꞌ nesi nene makaꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ingine nene Izesuꞌ nGalilaia misubola mono minidoꞌ eꞌmeti moni hize eleꞌ i-di makaꞌ minaniꞌ veneꞌ minaniꞌ. Idoꞌ veneꞌ linge mukiꞌ Izesulesi Zelusalemi numuda dizi aniꞌ veneꞌ nesi nene makaꞌ minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nivengaꞌ molavo holisekumuꞌ initeꞌ di vaꞌvaꞌ aniꞌ gamene nene aꞌmidoꞌ geto osuꞌ lo holiseꞌ minaaꞌ aniꞌ gamene nene olosa neivo nemuꞌ nene ");
INSERT INTO aso_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimataia numudotiꞌ ve Zoseheꞌ aza evenelite gilavo dizo minavo gili imaaꞌ aniꞌ kanisole mino idoꞌ Oꞌmosoꞌmo evenetoꞌ gizebo ilineꞌ gamene alingumukovoꞌ nene gizebo ogo minaaꞌ ive neꞌmo aza ehelele izineꞌ nene gele hulo Pilatoda vo Izesuꞌ okoꞌno nene nemelive lo longoꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Longoꞌ o-davo Pilatoꞌ aza mo Izesuꞌ hilihe lo gala setaꞌ gelo ami pilisi veliti gizebo ve naba asi lo-davo ogavo Izesuꞌ mo helahe lo longoꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Longoꞌ o-davo mo helave lavo gonoso nene Zoseheꞌni do vilive lo lo huko-davo ");
INSERT INTO aso_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","aza lavolavo mokonoꞌ lamineꞌ ma vo meni hizosa Izesuꞌni nene lohotoꞌ zalotiꞌ apaso do lemo aꞌmine lavolavodunuꞌ asabuꞌ ize-do gonoso milaaꞌ aniꞌ ebeꞌ liliꞌ igi gehenguꞌ goloꞌvatikanguꞌ nene do vo molo-do gonoso galese veleloꞌ nene geheni naba ma do veleheꞌ molo do tilekineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Galeseuꞌ nomolo-divo Mangadala numudotiꞌ veneꞌ Maliakisi idoꞌ abalaho Zoseꞌ izelehosi engiꞌ nene ningi minasineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gohi nivengaꞌ molo sigisi (6) kiloku ogavo holiseꞌ nene mo osuꞌ lave li Mangadala numudotiꞌ veneꞌ Maliakisi eiꞌ abalaho Zakoboꞌ izelehosi Salomekisi gonosoloꞌ holalone li unuvo lamineꞌ ogaꞌ ineꞌ uveli nene vi meni hizaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Meni hizi di vi ingi Sadeuꞌ goꞌ lolosa neivo gonoso ebeta vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nivi tiꞌ li li voleloꞌ meloꞌ iꞌmi vaniꞌ: Gonoso galese veleloꞌ geheni naba ma nene zaho do veleheꞌ molo hulo-ledelive. ");
INSERT INTO aso_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tiꞌ liꞌmi visa ningi huli gonoso galesela milaniꞌ nene aꞌmine geheni naba goloso ma nene veleheꞌ mili hulikeniꞌ neivo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Neꞌmine igi gonoso mili-daniꞌ geheni mulikuꞌ dizi ninganiꞌ nene gosoꞌve ma saketi mokonoꞌ haꞌna haꞌna izo aꞌine hulaaꞌ ada mitoꞌ neivo ningi ngehelele izineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Neꞌmine neivo nizavo tiꞌ lo lo-ngimineꞌ: Lengehelele izamivo. Nasalete ve Izesuꞌni lohotoꞌ zaloꞌ bilave ma nene ningilisa ahe. Aza nene meuꞌ nomive. Mo oto vaze. Mili-daniꞌ ebeꞌ mene ningilo. ");
INSERT INTO aso_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nemuꞌ lingine vi izipahala zuhosi idoꞌ Petoloꞌ eiꞌ nesi nene nGalilaia misubouko gomuꞌ molo lengemo volosuve lo lo-lingimineꞌ maꞌmine ogo vo neivo aꞌmida vi ningilisave li li-ngimilo. ");
INSERT INTO aso_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Neꞌmine lo lo-ngemavo luvoluvo izi gopo gaꞌine gili mini hetoꞌ limi gonoso ebetotiꞌ golise vaniꞌ. Idoꞌ ngehelele izineꞌ nemuꞌ nene ve masi veteteꞌ igi li-ngimamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zuda velite gono do do vaaꞌ uneꞌ gamene apiꞌ neivo Sadeuꞌ nedengaꞌ goꞌ nuvonuvo neivo Izesuꞌ nene hilingutiꞌ otosa sikalahuꞌ goloso seveni luloutiꞌ ngimiselo do hulineꞌ veneꞌ Mangadala numudotiꞌ veneꞌ Maliaꞌni nene ganaꞌ sotoꞌ pize imineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sotoꞌ pize emavo aza nene vo Izesulesi monaaꞌ ave nene mulumo alumo gili-di ive nama igi nizavo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hilingutiꞌ oto ha neivo ninguve lo lo-ngemavo ingine lineꞌ gamazi nene gili eleꞌvoleꞌ amaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Neꞌmine ogavo alingeꞌ nene engikutiꞌ ve setaꞌ nene numuno ebeꞌ naba nene huli ebeꞌ ngomola nivasivo Izesuꞌ aza eiꞌ emeni do atoliꞌmine ogosa sotoꞌ pize ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sotoꞌ pize ngemavo ingine tineꞌ mili vi ingi zuho linge nene li-ngimasineꞌza nesi gili eleꞌvoleꞌ amaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Alingeꞌ nene izipahala zuho leveni (11) di geseꞌ igi nosoꞌ niteꞌ ni nizavo engitasi sotoꞌ pize ngemo tiꞌ lo ngelemineꞌ: Hiluvongutiꞌ nene mo ote nouvo ningave nete aꞌminemuꞌ li-lingimaniꞌza lingine lutine hize tilavo aꞌmanapa igi engiꞌ gamazi nene gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Neꞌmine lo ngelemosa tiꞌ lo lo-ngimineꞌ: Lingine numudoꞌ namadoꞌ misubouꞌ misubouꞌ vi osuꞌ li eveneꞌ zuho ato atoꞌ mukiꞌ nizaniꞌ nene monoꞌ gamazi lamineꞌ nene li sotoꞌ igi li-ngimilo. ");
INSERT INTO aso_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Li-ngimikevo gili gamazi gihile ve li gili eleꞌvoleꞌ igi monoꞌ noso hilalizave nene Oꞌmosoꞌmo golosoutiꞌ do nguꞌ izeleseiha ve ma gili eleꞌvoleꞌ amilizave nene Oꞌmosoꞌmo goniꞌ o-ngedo lihime ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Idoꞌ ingine nezemuꞌ gili eleꞌvoleꞌ i minilizave nene neze amuzo neꞌminisa di sotoꞌ ilisave: Adoꞌ sikalahuꞌ goloso neniꞌ veꞌnemuꞌ ngimiseli hulilisave. Idoꞌ ato atoꞌ noꞌningutiꞌ gamazi lilisave. ");
INSERT INTO aso_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Idoꞌ gosiheꞌ nene ngibilamavo aꞌinedunuꞌ nene ha dalisave. Idoꞌ zahemede noso nalizaniꞌ nene ma do goloso o-ngedamoloseive. Initeꞌ gizi daveti okoꞌnidoꞌ aꞌinetunuꞌ hitikevo lamineꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Guvetesi ve Izesuꞌ aza neꞌmine lo mo lo-ngemavo Oꞌmosoꞌmo Okulumokuko eleꞌmizo do dizavo Oꞌmosolotiꞌ lemo minidiꞌmo Oꞌmosoꞌmo ana hulaaꞌ ida moꞌmosiꞌveloꞌ mitoꞌ neive. ");
INSERT INTO aso_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Neꞌmino neivo eze izipahala zuho ingine numudoꞌ namadoꞌ vi eze gamazi nene li sotoꞌ igi nili-ngimavo gamazi laaꞌ aniꞌ nene gihile izave li ningilizave lo Guvelesi ve aza inginesi mino hize eleꞌ o-ngidivo ingine amuzo niteꞌ ato atoꞌ igi mili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Eveneꞌ Naba Teohiloꞌ, Gaza Izesuꞌnimuꞌ li-gimaniꞌ gamazi nene mo laminetokovoꞌ li-nimikeve lo geleline lo luhuvo niteꞌ mene nogize-giduze. Ningezo. Ee, leliꞌ vovoteuꞌ sotoꞌ aniꞌ initeꞌ nene apiꞌ ogo sotoꞌ idotiꞌ ningave linge ma nene aꞌmine sotoꞌ ineꞌ monoꞌ gamaziꞌmi gonoloꞌ ve liliꞌ igi mini lelita li hulikevo eveneꞌ mukiꞌ nene aꞌmine li hulaniꞌ gamaziloꞌ nene eꞌmeti di lisiheꞌ igi luhuvo gizaniꞌ ve. Idoꞌ neꞌmine angumukisi idoꞌ aꞌmine Izesuꞌ gono do ogo molo minineꞌ initeꞌ mataꞌ apiꞌ ogo sotoꞌ oꞌmo oꞌmo vo miningumuꞌ nene naza aꞌmineꞌmi monovo danavaꞌve ngomoꞌ nabaꞌ nene viseꞌ ogo gelekaꞌ gelekaꞌ ogo gele osuꞌ luvoniꞌ nenako nemukisi nene nazasi aꞌmine sotoꞌ ineꞌ initeliꞌmi gamaziꞌve nene do lisiheꞌ ogo luhuvo gizeloniꞌ nene lamineꞌ oloseive losa geiꞌ nene nogize-giduve. ");
INSERT INTO aso_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naza tiꞌ lo nolo-gimuve: Helodeꞌ aza Zudaia misubouꞌ guvelesi ve naba loloꞌ ogo minineꞌ gameneuꞌ nene evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive ma minineꞌ nene gulive Zakaliaꞌ ve. Aza nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave Aloniꞌ aꞌvopilemoꞌ zuhoutiꞌ mino idoꞌ Oꞌmoso initeꞌ lehizi-daaꞌ gono senisi senisi igi daaꞌ aniꞌ mulise ma Abiaꞌ muliseutiꞌ minineꞌ ve. Idoꞌ veneꞌ ma do minineꞌ gulive Elisabeteꞌ nesi nene Aloniꞌ aꞌvopilemoꞌ zuhoutiꞌ minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ingine sitaꞌ nene Guvelesi veꞌmo louꞌ gamazi lo huko lineꞌ vaitoꞌ nene eꞌmeti mini gamaziꞌinesi nomineꞌ aleve mini Oꞌmosoꞌmi veleloꞌ nene eveneꞌ lisiheꞌ minasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eveneꞌ lisiheꞌ minasineꞌza Elisabeteꞌ nene gohuno lizo neivo ingine nene izipahaꞌinesi gidami mini setatoꞌ nene ozoho mili minasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Idoꞌ Zakaliaꞌ zuho muliselite Zelusalemi ebekuꞌ monoꞌ numuno nabauꞌ nene gono dalizadoꞌ vavo Zakaliaꞌ nene Oꞌmoso initeꞌ lehize-daaꞌ gono Oꞌmosoꞌmi veleloꞌ dokaꞌ dokaꞌ ogo neivo ");
INSERT INTO aso_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","aꞌmine Zakaliaꞌ muliseutiꞌ nene kekeize lo minineꞌ monoꞌ numuno lulouꞌ dizo unuvo lamineꞌ ogaꞌ ineꞌ initeꞌ nene olokuꞌ gizo Oꞌmoso emelive ma di kegesilisa evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveti monovoloꞌ eꞌmeti eveneꞌ maliꞌmi gulive di sotoꞌ igaꞌ zohikuꞌ zohiꞌ ikevo Zakaliaꞌ guliveꞌve sotoꞌ ogavo di kegesi-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Di kegesi-dikevo unuvo lamineꞌ ogaꞌ ineꞌ initeꞌ olokuꞌ gizi Oꞌmoso imilizaniꞌ gamene ogavo eveneꞌ mukiꞌ nene monoꞌ numuno naba heta nene mulise mili mini Oꞌmosola li nizavo engitoꞌ medelo Zakaliaꞌ aza monoꞌ numuno kekeize lo mininguꞌ nene dizo aꞌmine unuvo lamineꞌ ogaꞌ ineꞌ initeꞌ nene gizo Oꞌmoso noimivo ");
INSERT INTO aso_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Guvelesi veꞌmi angeloꞌ maliꞌmo sotoꞌ o emo unuvo lamineꞌ ogaꞌ ineꞌ initeꞌ gizaaꞌ aniꞌ holomo neꞌmi zamela ote minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ote neivo Zakaliaꞌ ningosa upuhoꞌ ogo golise gelo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Golise gilineꞌza angeloꞌ neꞌmo tiꞌ lo lo-imineꞌ: Zakaliazo, gaza golise gelamozo. Oꞌmosoꞌmo ezela lokaꞌ lokaꞌ naineꞌ initekumuꞌ nene mo gele gemave. Nemuꞌ elengaho Elisabeteꞌ nene gipa ma gedeleseize. Gulive nene Zohaneꞌ ve lo molalosane. ");
INSERT INTO aso_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Idoꞌ gaza nene mulungauꞌ lamineꞌ goloso gelo golize izelesane. Idoꞌ eveneꞌ linge mukiꞌ nesi nene eiꞌ sotoꞌ ilingumuꞌ lamineꞌ gililisave. ");
INSERT INTO aso_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aza nene Guvelesi veꞌmo gilivo eze veleloꞌ nene eveneꞌ naba neꞌmine mineleseive. Aza nene vaini nososi mo namo sipaki ogaꞌ noso ato atoꞌ nesi nene mo namoloseive. Idoꞌ aza nene izelehi mulunouꞌ neivo minilidokisi nene Oꞌmosoꞌmi Sikalahuꞌ neꞌmo lulouꞌ minevo dovoꞌ ogo minivo Oꞌmosoꞌmi gono dalive lo eleꞌmize molaloseive. ");
INSERT INTO aso_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Neꞌmine ogo aza neve Isilaeleꞌ aleve linge mukiꞌ nene aka golosoloꞌ nivangutiꞌ nene engiꞌ Guveꞌinesi ve Oꞌmosola do tineꞌ molo-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Idoꞌ aza nene gomuꞌ polohete Eliaꞌ eiꞌ amuzo idoꞌ emeni dameni neꞌmine do otuhosa Guvelesi ve nene gomuꞌ molo emo novo meꞌninge nete izipahaꞌine nene monovo do goloso goloso i-ngidamavo laminivoꞌ minilizave lo do hamoꞌ o-ngedo idoꞌ hokolizeꞌ igi bikiheti igaꞌ ave nene eveneꞌ lisiheꞌ laminelite gili daaꞌ naniꞌ monoꞌ nene lo-ngemavo gili dalisave. Neꞌmine ogo Guvelesi ve alingumuꞌ nene eveneꞌ ma ingine eze evenele zuho ma liliꞌ igi eꞌmetilizadoꞌ lisiheꞌ gehepeve i minilizave lo do lisiheꞌ o-ngedeleseive. Nemuꞌ aꞌmine gipa nene sotoꞌ ogavo gazasi eveneꞌ linge mukikisi longolize izilisave. ");
INSERT INTO aso_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angeloꞌ aza neꞌmine lavo Zakaliaꞌ tiꞌ lo longoꞌ o-dineꞌ: Nazasi eleꞌnahosi nene mo eleni vani molokusineꞌ nenako gipeꞌne ma gedelongumuꞌ nolo-nemaineꞌ nene mo laminetoꞌ lo-nemaneꞌ neive lo nado gelelove. ");
INSERT INTO aso_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Neꞌmine lavo angeloꞌ aza tiꞌ lo lo-imineꞌ: Naza nene Oꞌmosoꞌmi veleloꞌ minaaꞌ nouvoniꞌ angeloꞌ nGabilieleꞌ ma ne nouve. Oꞌmoso asiꞌve nene geiꞌ gamazi lo-gemo idoꞌ gamazi lamineꞌ lo-gimuvoniꞌ nemukisi lo-gemelongumuꞌ nene nimiselavo nouve. ");
INSERT INTO aso_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nemuꞌ nene gelezo. Gaza neniꞌ gamazi luvoniꞌ gele eleꞌvoleꞌ amaneꞌ nemuꞌ nene gamazi lamo tihine hizo nanivo aꞌmine luvoniꞌ initekumuꞌ nene gameneꞌveloꞌ lisiheꞌ ogosa ogo gihile izeleseive. Idoꞌ neꞌmine ogavo gaza gohi gamazi lolosane. ");
INSERT INTO aso_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Idoꞌ eveneꞌ nete monoꞌ numuno nabaꞌmi heta mini Zakaliaꞌ geto nonida lemo alihe li ezemuꞌ gizebo igi minaniꞌza angeloꞌ neꞌmo gamazi lo-emo minidiꞌmo nene gamene haꞌna mino lemo heta amivo nemuꞌ nene eveneꞌ ingine gaꞌine mukiꞌ gili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Neꞌmine igi nizavo Zakaliaꞌ aza heta lemo aniꞌza gamazi ngelo lamilineꞌ ogavo tihine hize mino eveneꞌ gamazi lo-ngemelesa nene anadunuꞌ avazahavoꞌ o-ngimineꞌ ve. Neꞌmine noo-ngimivo eveneꞌ nete aza nene monoꞌ numunguꞌ nene initeꞌ ma veleloꞌ o molo noloseive li gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Idoꞌ Zakaliaꞌ nene aꞌmine gonoꞌve nene do do vo neivo gono do do vilineꞌ gameneꞌve nene osuꞌ lavo Zelusalemi numuno ebeꞌ nene hulo numuꞌvela tineꞌ molo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Idoꞌ nelotiꞌ alingeꞌ nene elenaho Elisabeteꞌ neve izipahala minavo tiꞌ lo lineꞌ: Idise naza izipahaꞌne minineꞌ nene Guvelesi veꞌmo neze ninge lamineꞌ do gohuno lizo minuvongumuꞌ eveneliti veꞌnidoꞌ novozo helo minaaꞌ uvoniꞌ nene gohi nenita novozo minamilive lo gelavo izipahaꞌne minineꞌ ve. Neꞌmine lo mine haleko neivo ikeꞌni faef (5) nene ogo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeteꞌ nene izipahala minavo neivo ikeꞌni sigisi (6) neꞌmine ogo vavo Oꞌmoso neꞌmo angeloꞌ nGabilieleꞌni nene imiselavo nGalilaia misubouꞌ numuno ebeꞌ ma gulive Nasaletela lemo aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Aꞌmida nene alungo olihe veloꞌ vamineꞌ alu ma gulive Maliaꞌ nene Zuda veti guveꞌinesi ve naba Davidiꞌ aꞌvopilemoꞌ zuhoutiꞌ ve ma gulive Zoseheꞌni izeni imikaniꞌ alu neida lemo aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angeloꞌ aza ogo aꞌmine alu Maliaꞌni nene meseꞌ aseka lo-do tiꞌ lo lo-imineꞌ: Guvelesi veꞌmo ninge lamineꞌ do hize eleꞌ o-gidivo naneꞌ veneꞌ gaza nabe. Guvelesi ve nene geikisi neive. ");
INSERT INTO aso_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Neꞌmine lo lavo Maliaꞌ aza aꞌmine meseꞌ aseka lo-do lineꞌ gamazi nemuꞌ nene monovo nanitekumuꞌ lihe lo gopo gala gelo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Neꞌmino neivo angeloꞌ aza tiꞌ lo lo-imineꞌ: Maliazo, gaza gehelele izamivoo. Oꞌmosoꞌmo geiꞌ nene ninge lamineꞌ dave. ");
INSERT INTO aso_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gaza gelezo. Gaza nene mo izipaha minavo gipe ma gedelesange. Guliveꞌve Izesuꞌ ve lo molalosane. ");
INSERT INTO aso_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aza nene eveneꞌ naba loloꞌ ogo mineleseive. Neꞌmine ogo neivo eikumuꞌ nene Oꞌmoso hozila miniveꞌmi gipele ve lavo mineleseive. Idoꞌ Guvelesi ve Oꞌmoso neꞌmo avoloho Davidiꞌ guvelesi ve naba loloꞌ ogo minineꞌ moꞌmosiꞌve nene emavo ");
INSERT INTO aso_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Zakoboꞌ zuho Isilaeleꞌ aleveti Guveꞌinesi ve naba loloꞌ ogo engitoꞌ nene minevoꞌ minevoꞌ ogo gizebo o-ngedo neivo aꞌmine gizebo ogo mine do vilineꞌ nene osuꞌ lamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Angeloꞌ aza neꞌmine lavo Maliaꞌ aza tiꞌ lo longoꞌ o-dineꞌ: Naza nene olihe vemohokisi bizo ongamusineꞌ nenako gaza laineꞌ gamazi nene nenita nado sotoꞌ ilive. ");
INSERT INTO aso_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Neꞌmine lineꞌza angeloꞌ aza tiꞌ lo lo-imineꞌ: Oꞌmosoꞌmi Sikalahuꞌ nene geita ogo minavo Oꞌmoso hozila dizo minive neꞌmi amuzo neꞌmo asabuꞌ ize-gedavo neꞌmo nene izipaha mineleseive. Nemuꞌ nene aꞌmine izipahaka gedelineꞌ nene Oꞌmosoꞌmi gipele gehepeve ve lavo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Idoꞌ ma nene gelezo. Geze zuhoutiꞌ veneꞌ gohaho Elisabeteꞌ nene gohuno veneꞌ ve li-daaꞌ aniꞌza idise nene izipahala minavo gipe gatunosi neivo ikeꞌni sigisi (6) nene novive. ");
INSERT INTO aso_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Idoꞌ neꞌmine noluvoniꞌ nene Oꞌmoso aza neꞌmine manaꞌmine initeꞌ ilineꞌ amuzoꞌve nene nomineꞌ nevoba aza olove lo lilineꞌ initeꞌ mukiꞌ nene ha ogakovoꞌ ilineꞌ nenako ha oloseive losa nemuꞌ noluze. Gaza gaka mukiꞌ gelamozo. ");
INSERT INTO aso_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Neꞌmine lavo Maliaꞌ aza tiꞌ lo lineꞌ: Naza nene Guvelesi veꞌmi gelekeleꞌ alu nouvoniꞌ nenako nemuꞌ nene gaza laineꞌ neꞌmino sotoꞌ o-nidivoo. Neꞌmine lavo angeloꞌ aza Maliaꞌni hulo-do vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Idoꞌ angeloꞌ hulo-do vavo nelotiꞌ nene Maliaꞌ aza mine haꞌna amo Zudaia misubouꞌ golo mukiꞌ lo minida numuno ebeꞌ ma minida nene geto vo hetelineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aꞌmida nene Zakaliaꞌ numunguꞌ dizo elenaho Elisabeteꞌni nene meseꞌ aseka lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Neꞌmino meseꞌ aseka nolo-divo Elisabeteꞌ aza nogilivo izipe neꞌmo mulunouko gabe kabeꞌ neivo Oꞌmosoꞌmi Sikalahuꞌ neꞌmo Elisabeteda mino hize eleꞌ o-divo ");
INSERT INTO aso_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nolo nabautiꞌ gekeꞌ lo tiꞌ lo Maliaꞌni lo-dineꞌ: Oꞌmosoꞌmo geiꞌ nene veneꞌ mukiꞌ ngivileꞌ ogo ninge lamineꞌ do noꞌnohoꞌ ize-gedavo nane. Idoꞌ geiꞌ mulungauꞌ neineꞌ izipaha nesi nene noꞌnohoꞌ ize-davo neive. ");
INSERT INTO aso_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nemuꞌ nene Guveꞌnesi veꞌmi izeleho gaza nene neniꞌ haza veneꞌ nouvoda alinidoꞌ lisiheꞌ amaneꞌ nenako mo oganivo laniteꞌ nogiluve. ");
INSERT INTO aso_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gelezo. Gaza ogo hetelo meseꞌ aseka nolo-nedanivo nogiluvo gatuꞌneuꞌ izipe neꞌmo olize izo moiꞌ moiꞌ ogavosa nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gaza Guvelesi veꞌmo lo-gimineꞌ gamazi nene gihile izeleseive lo gele eleꞌvoleꞌ aineꞌ nenako nemuꞌ Guvelesi veꞌmo noꞌnohoꞌ ize-gedavo golize izo minelineꞌ akaloꞌ mine molo nane. ");
INSERT INTO aso_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Elisabeteꞌ aza neꞌmine lavo Maliaꞌ aza nama gosohoꞌ bele molo tiꞌ lo lineꞌ: Naza luꞌnedunuꞌ nene Guvelesi ve do naba noo-duve. ");
INSERT INTO aso_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Idoꞌ luꞌne neꞌmo nene nuꞌ izaaꞌ ive Oꞌmosomuꞌ nene olize noizive. ");
INSERT INTO aso_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Naza neꞌmine uvoniꞌ nene nanitekumuꞌ ve. Oꞌmoso aza neꞌmo naza nene haza gelekeleꞌ aluvo lemo minuvoniꞌ nemuꞌ nene ningo gelo doꞌmo dize-nedo do lamineꞌ o-nedave. ");
INSERT INTO aso_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ee, amuzo malehe minive Oꞌmoso aza nene initeꞌ lamineꞌ goloso nenita o-nidineꞌ nene eiꞌ emeni dameni atoliꞌmine goloso ogo lamineꞌ neivo opoꞌni noluve. ");
INSERT INTO aso_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Idoꞌ ezemuꞌ lehelele izivo mino eꞌmeto nonive leliꞌ nene mulumote ningo hize eleꞌ o-ledo neineꞌ monovoꞌve nene eveneꞌ sotoꞌ igi mini di vilizadasi nene ha mine do vo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Idoꞌ ve ma ingine amebe ve none li luꞌine gaꞌninguꞌ gili gavele ve gehesave nene aza amuzolo atoliꞌmine ogo minineꞌ do sotoꞌ ogo do gopo o-ngedavo hutileꞌ igi vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Idoꞌ guveꞌinesi naba minave nene eveneꞌ gizebo i-ngidi minaaꞌ aniꞌ moꞌmosiꞌnidotiꞌ nene ngehusoꞌ ogo do hulineꞌ gelavo guveꞌinesi ve nene gohi minamaaꞌ aniꞌ ve. Idoꞌ haza ve limi minave nene aza lavo eveneꞌ dizi minave ve naba neꞌmine liliꞌ igaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Idoꞌ gohoꞌ gahaliꞌ mini initekumuꞌ gaꞌna hili minave nene initeꞌ lamineꞌ vaiꞌ ngemavo di vaiꞌ li minaaꞌ aniꞌza heneni ve minave nene initeꞌ ma ngemamo do hulo-ngedavo haza minaaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Aza nene Abalahamukisi eiꞌ aꞌvopilemoꞌ zuho engiꞌ nesi mulumoꞌine ningo hize eleꞌ o-ngedeꞌmo vo mineloniꞌ nene mo huko vamo ha minevoꞌ minevoꞌ ogovoꞌ mineleseive lo lo huko avotemotine lo-ngimingumuꞌ nene gala molamivo ha gele mino eze gelekeleꞌ o-daaꞌ unive Isilaeleꞌ zuho nene hize eleꞌ o-ledave. Nemuꞌ nene naza ezemuꞌ nolize noizuve. ");
INSERT INTO aso_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliaꞌ aza mo neꞌmine lo osuꞌ lo Elisabetekisi makaꞌ mino ikeꞌni sito hamo do hulosa numuꞌvela tineꞌ molo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Idoꞌ Elisabeteꞌ aza izipahala gedelineꞌ gamene nene mo alitavo gipele gidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Neꞌmine ogavo nemuꞌ nene Guvelesi veꞌmo Elisabeteꞌni atoliꞌmine ogo mulumolo ningo nasahiliꞌ o-do hize eleꞌ o-dingumuꞌ nene eze zuho netesi idoꞌ oholomote zuho netesi nene gili ezesi inginesi ngolize makatoꞌ izaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Neꞌmine igi nizavo izipe nene sotoꞌ idotiꞌ gamene eiti (8) ogo vavo aꞌmine gameneuꞌ aꞌmine izipe nene Oꞌmosoꞌmi noso mili-di okoꞌno lolovo huki-dilisa igi guliveꞌve nene melehidoꞌ Zakaliaꞌ ve li milalisa aniꞌza ");
INSERT INTO aso_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","izeleho neꞌmo oꞌve lo-ngedo guliveꞌve nene Zohaneꞌ ve lo mineleseive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Eꞌe, geze zuho mukikutiꞌ nene neꞌmine guliveꞌinesi minave hamokisi ma minamave. ");
INSERT INTO aso_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Neꞌmine li aꞌinedunuꞌ avazaha igi melehine tiꞌ li longoꞌ i-daniꞌ: Gaza gulive nadive lo molo-delesa gele nane. ");
INSERT INTO aso_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Neꞌmine li longoꞌ i-dikevo meleho aza luhuvo gizo lo-ngemelesa luhuvo gizelineꞌ initekumuꞌ anadunuꞌ avazaha ogo longoꞌ o-ngedavo ma di imikevo tiꞌ lo gizineꞌ: Guliveꞌve nene Zohaneꞌ ve lo mineleseive. Neꞌmine lo gizavo eveneꞌ ingine voꞌine vavo gopo gaꞌine gili minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Neꞌmine igi nizavo Zakaliaꞌ aza gamazi lilineꞌ akaꞌve hize tile-davo minineꞌ initeꞌ nene osuꞌ lo-davo gohi tihine hizamo aꞌmidoꞌ liteꞌ lo gamazi apiꞌ ogo nolo Oꞌmoso opoꞌni lo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Idoꞌ initeꞌ neꞌmine sotoꞌ ingumuꞌ nene aꞌmine ebekuꞌ miniꞌmi monave mukiꞌ nene gili ngehelele izivo nizavo aꞌmine sotoꞌ ineꞌ initeꞌ neꞌmi gamaziꞌve nene Zudaia misubouꞌ golola numuno ebeꞌ mukikuꞌ minave ingine nene li voleloꞌ meloꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Neꞌmine igi mini aꞌmine gamazi gilave mukiꞌ ingine nene Guvelesi veꞌmi amuzo eita sotoꞌ ogo minineꞌ nemuꞌ nene gilaniꞌ nenako nemuꞌ aꞌmine gamazi nene di maduꞌninguꞌ mili mini tiꞌ li laniꞌ: Aꞌmine izipe nene sotoꞌ olosa neivosi idoꞌ sotoꞌ neivosi vote vineꞌ initeꞌ neꞌmine sotoꞌ ineꞌ nenako alingeꞌ naniꞌmine ve loloꞌ ogo mineꞌ nalivo. Mo eveneꞌ naba neꞌmine ma loloꞌ ilidoꞌ o noloseive li laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Idoꞌ Zohaneꞌ meleho Zakaliaꞌ aza nene Oꞌmosoꞌmi Sikalahuliꞌmo ogo hize eleꞌ o-divo Oꞌmosoꞌmi veletiꞌ gamazi tiꞌ lo lo sotoꞌ ogo nama lineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isilaeleꞌ aleveti Guvetesi ve Oꞌmoso nene do naba o-do opoꞌni lolone. Aza nene ogo evenele zuho leliꞌ nene mulumote ningo goloso ogo minuningutiꞌ nene kuluhize-ledave. ");
INSERT INTO aso_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Ee, Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ ave polohete gozopoꞌ akaꞌmila minaniꞌ nete Oꞌmosoꞌmo lo huko-lidineꞌ gamaziꞌve gozopoꞌ li sotoꞌ aniꞌ nene do gihile izo gomuꞌ Oꞌmoso gelekeleꞌ o-do minive guvetesi ve Davidiꞌ aꞌvopilemoꞌ zuhoutiꞌ nene amuzo malehe ve leliꞌ do luꞌ izelive nene mo do ote-dave. ");
INSERT INTO aso_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Idoꞌ do ote-dineꞌ nene eveneꞌ ma lelikumuꞌ muso gaꞌine dizavo biluvaꞌ i-lidaaꞌ aveti aꞌninguꞌ minuningutiꞌ nene kuluhize-ledo do luꞌ izelive losa do ote-dave. ");
INSERT INTO aso_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ee, neꞌmine ineꞌ nene gomuꞌ eiꞌ guliveꞌveloꞌ eleꞌvoleꞌ gamazi leliꞌ avotehine Abalahamuꞌni lo huko-dineꞌ mamuꞌ nene gala gele mino aꞌmine gamazi leliꞌ Isilaeleꞌ aleveti avotemotinemuꞌ nene lengiꞌ zuho mulumoꞌine ningo hize eleꞌ o-ngedeꞌmo vo minelesuve lo lo huko-ngidineꞌ nene do gihile izelesa neꞌmine ineꞌ ve. Idoꞌ aꞌmine gamazi lo huko linguꞌ nene neꞌmine olosa lineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Aza nene leze biluvateliti aꞌningutiꞌ do kuluhize-ledavo laza nene lehelele izamivo mino mene misubouko eze veleloꞌ vetesi mine do voloninguꞌ laza nene monovo lisiheꞌ laminekovoꞌ ogo molo mino ezemuꞌ gele lamineꞌ o mino opoꞌni lo mine do vo minelone. Idoꞌ neꞌmine ineꞌ nemuꞌ nene Isilaeleꞌ aleveti Guvetesi ve Oꞌmoso nene do naba o-do opoꞌni lolone. ");
INSERT INTO aso_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","79","Neꞌmine lo Zakaliaꞌ aza gipele ngomo Zohaneꞌnimuꞌ nene tiꞌ loo imineꞌ molo lineꞌ: Idoꞌ gipeꞌne gaza nene Guvelesi veꞌmi aka vele-delesa eze evenele tiꞌ lo lo sotoꞌ o ngemeꞌmo gomuꞌ molo-do volosane: Leliꞌ Oꞌmosote aza nene lelikumuꞌ mulunouꞌ mulumo naba gilineꞌ nenako nemuꞌ aza nene lihimete hulo-ledo do luꞌ izelineꞌ aka vele-ledelesa neive. Ee, Oꞌmoso aza leliꞌ mulumote ningo Guvelesi ve imiselavo aza Okulumokuko hozi minidotiꞌ nene lemo leliꞌ luteuꞌ litiꞌmuso ize minivo mino helo vo tolovo oloneꞌ akaloꞌ mine molo minuniveti vovoteuꞌ mino goꞌ lo labanaꞌ elaaꞌ neineꞌ neꞌmino luteuꞌ hize labanaꞌ ele-ledo hongu lo mineloneꞌ akaloꞌ leleꞌmize molaloseive. Idoꞌ gipeꞌne gaza eveneꞌ neꞌmine lo lo-ngemeꞌmo vo mino Guvelesi ve gomuꞌ molo-do akaꞌve vele-delineꞌ nenako nemuꞌ nene geikumuꞌ evenelite Okulumokuꞌ atoliꞌmine ogo dizo miniveꞌmi polohete ve li li-gidaaꞌ ilisave lo lo-imineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Idoꞌ nelotiꞌ aꞌmine izipe Zohaneꞌ nene naba oꞌmo vo mino gala gele ngenga lo minineꞌza eze gono dalineꞌ gamene Oꞌmosoꞌmo molo-dineꞌ nene olihe amivo Isilaeleꞌ aleveti veꞌnidoꞌ nene sotoꞌ amo ebeꞌ hadive gokoꞌ lo minaaꞌ idaavoꞌ nene ongo mono minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aꞌmine Izesuꞌ sotoꞌ olosa ineꞌ gameneloꞌ nene Loma veti guveꞌinesi ve ngamani naba Augusitoꞌ Kaesaleꞌ nene eiꞌ gizebo ineꞌ misubo ato atoꞌ mukikuꞌ numudoꞌ namadoꞌ nene eveneꞌ takisi hulaakumuꞌ guliveꞌine dalizave lo lo huko gamazi hulavo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aꞌmine guliveꞌine di lisiheꞌ igi luhuvo gizaaꞌ gono nene gomuꞌ Zuda veti misubouꞌ nene ma damaaꞌ aniꞌza Loma vete Silia misubo ve languꞌ nene Kilinioꞌ aza ngamani naba loloꞌ ogo minelive lo Kaesaleꞌ doote-davo neivo Zuda veti misubo nene aꞌmine Silia misubo neꞌmi lingelatiꞌ minineꞌ nenako aꞌmine gameneuꞌ nene ganaꞌ apiꞌ igi aꞌmidasi aꞌmine gono daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Neꞌmini nidavo eveneꞌ mukiꞌ nene guliveꞌine gizi di lisiheꞌ ilizangumuꞌ gotoꞌ numuꞌine ebeꞌine minida minida vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Idoꞌ nivavo Zoseheꞌ azasi nene gomuꞌ guvelesi ve Davidiꞌ aꞌvopilemoꞌ zuhoutiꞌ minineꞌ nenako nemuꞌ aꞌmine minineꞌ numuno ebeꞌ Nasalete nGalilaia misubouꞌ minineꞌ nene hulo izeni elenahine Maliaꞌni nesi nene gulivete vo gizo do lisiheꞌ olosive lo eleꞌmizo avoloho Davidiꞌ numuno ebeꞌ Betelehemi Zudaia misubouꞌ minida nene dizo vineꞌ. Idoꞌ aꞌmine gameneuꞌ nene Maliaꞌ aza izipe gatunosi neivo vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Neꞌmine o neivo vasineꞌ nenako ingine vi Betelehemi numunguꞌ nizasivo izipe gedeli gamene nene mo ogavo ");
INSERT INTO aso_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ganaꞌ gipele nene apiꞌ ogo gidineꞌ. Neꞌmine ineꞌ nene venenga vete meni hizi ingaaꞌ aniꞌ numunguꞌ nene eveneꞌ gikiꞌ igi minikevo ingine minilisineꞌ numuno nene ma nomivo aꞌmida nene ize ato atoliti numuno ma mininguꞌ nene vi nizasivo gidineꞌ nenako nemuꞌ aꞌmine gipele nene gedosa izipe ngomo asabuꞌ izi-ngidaaꞌ aniꞌ lavolavodunuꞌ asabuꞌ ize-do ize nosoꞌ niteꞌ mili-ngidaaꞌ aniꞌ bokisiuꞌ nene ongo-mikivo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Neꞌmino neivo aꞌmine holukakuꞌ nene aꞌmine Betelehemi numuno ebeꞌ gaheve guvisela sipisipi izeloꞌ gizebo ve linge ma ingine nene sipisipi izeꞌnidoꞌ gizebo igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Neꞌmine igi nizavo Guvelesi veꞌmi angeloꞌ maliꞌmo engita ogo hetelo sotoꞌ neivo Guvelesi veꞌmi labanala neꞌmo ogo hize labanaꞌ ele-ngedavo ingine golise goloso gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Neꞌmine navo angeloꞌ neꞌmo tiꞌ lo lo-ngimineꞌ: Lingine golise gilami mini gililo. Naza nene eveneꞌ mukitoꞌ ngolize izilizaniꞌ initekumuꞌ nene gamazi lamineꞌ ma do nouve. ");
INSERT INTO aso_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Naza gamazi lamineꞌ ma do nouve noluvoniꞌ nene eveneꞌ mukiꞌ lengikumuꞌ lengiꞌ do lunguꞌ izelive ma nene idise mene mo sotoꞌ o neive. Adoꞌ gomuꞌ guvelesi ve minive Davidiꞌ numuno ebeꞌ meuꞌ nene sotoꞌ o neive. Aꞌmine izipe nene Oꞌmosoꞌmo aꞌmine do lunguꞌ izaaꞌ gono nene dalive lo eleꞌmize molo imiselelesa live Guvelesi ve ma ne neive losa noluve. ");
INSERT INTO aso_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Idoꞌ lingine vi aꞌmine izipe neize li ningi gililizangumuꞌ nene tiꞌ lo nolo-lingimuve: Lingine vi ningilizaniꞌ aꞌmine izipe nene izipe asabuꞌ izaaꞌ aniꞌ lavolavodunuꞌ asabuꞌ izi-dikevo izelitine nosoꞌ niteꞌ mili-ngidaaꞌ aniꞌ bokisiuꞌ nene ongo neivo ningilisave. ");
INSERT INTO aso_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Neꞌmine nolo-ngimineꞌ velesi angeloꞌ mulise naba Okulumokuꞌ ami pilisi ve neꞌmine minaniꞌ nene limi igi gonoꞌnibo minida nene makaꞌ Oꞌmoso opoꞌni li nama tiꞌ li laniꞌ: ");
INSERT INTO aso_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Guvelesi ve mo sotoꞌ oganako nemuꞌ nene Okulumokuko hozi Oꞌmoso opoꞌni lolone. Idoꞌ misubouko nene aza ninge lamineꞌ daaꞌ neineꞌ alevela nene hongu monovo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Idoꞌ angeloꞌ nete sipisipi izeloꞌ gizebo ve nene huli-ngidi Okulumokuko tineꞌ mili dizi vikevo ingine li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Betelehemi numuda vukeꞌzo. Aꞌmine sotoꞌ ineꞌ initeꞌ Guvelesi veꞌmo lo-limineꞌ initekumuꞌ nene vo ningelone laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Neꞌmine li ingine aꞌmida nene geti vi Maliangi Zosehengi nene ningi izipe ngomo nene ize nosoꞌ niteꞌ mili-ngidaaꞌ aniꞌ bokisiuꞌ nene ongo neivo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mo ningi aꞌmine izipemuꞌ angeloliꞌmo lo-ngimineꞌ gamazi nene veteteꞌ igi li sotoꞌ sotoꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Idoꞌ aꞌmine sipisipi izeloꞌ gizebo velite li-ngimaniꞌ gamazimuꞌ gilave mukiꞌ nene aizo li voꞌine vavo minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Neꞌmine igi minaniꞌza Maliaꞌ aza sotoꞌ ineꞌ initeꞌ mukikumuꞌ laniꞌ gamazi nene do madunouꞌ molo aꞌminemuꞌ nene gala gelevoꞌ gelevoꞌ ogo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Idoꞌ sipisipi ize gizebo ve ingine nene initeꞌ mukiꞌ angeloliꞌmo lo-ngimidoꞌ gehepeve sotoꞌ ogavo aꞌmine gili ninganiꞌ initeꞌ nemuꞌ nene Oꞌmoso di naba i-di opoꞌni liꞌmi liꞌmi sipisipi ize gizebo igi minaaꞌ aniꞌ ebeta gohi vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Idoꞌ izipe sotoꞌ idotiꞌ nene gamene eiti (8) ogo vavo okoꞌno lolovo huki huli-di Oꞌmosoꞌmi noso nene mili-dilizaniꞌ gamene ogavo Oꞌmosoꞌmi noso nimili-di gulive mili-daniꞌ nene Izesuꞌ ve li milaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Idoꞌ Moseꞌ louꞌ gamaziꞌmo lidoꞌ eꞌmeti izipe gididotiꞌ nene izelehi okoꞌnoloꞌ di lamineꞌ i-di di hetoꞌ i-dilizaniꞌ gamene alitavo neꞌmine i-dilisa Izesuꞌ izelehoi melehoi ingine Zelusalemi numuda vasinguꞌ nene Izesukisi eleꞌmizi vasineꞌ ve. Idoꞌ vasineꞌ nene Guvelesi veꞌmi louꞌ gamaziꞌmo tiꞌ lo lidoꞌ nene eꞌmeti ilisa vasineꞌ: Izeꞌninge ingine izipahaꞌine gidikevo okoꞌnidoꞌ di lamineꞌ i-ngidilizaniꞌ nene lingine nama viluso he aꞌmine neꞌmine nama gohi ma he netiꞌ nama sitaꞌ di igi ngibili Oꞌmoso lehizi-dilisave lo minidoꞌ eꞌmeti ilisa vasineꞌ ve. Idoꞌ eleꞌmizi vasineꞌ nene Guvelesi veꞌmi louꞌ gamazi gohi maloꞌ nene eꞌmeti Izesuꞌni nene Guvelesi ve lehizi-dilisa vasineꞌ. Aꞌmine louꞌ gamazi nene tiꞌ li gizi nizave: Ganaꞌ sotoꞌ ilizaniꞌ gipe mukiꞌ nene Guvelesi veꞌmine ve li di kegesi-ngidaaꞌ ilisave li gizi nizaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Idoꞌ Zelusalemi numuno ebekuꞌ nene ve ma minineꞌ gulive Simeoniꞌ. Aza nene ve lisiheꞌ mino Oꞌmoso gelekeleꞌ o-do mino Oꞌmosoꞌmo Isilaeleꞌ aleve do nguꞌ izelineꞌ gamenemuꞌ nene gizebo ogo neivo Oꞌmosoꞌmi Sikalahuꞌ neꞌmo nene ezela mino lulouꞌ gono do minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Neꞌmine ogo neivo aꞌmine Oꞌmosoꞌmi Sikalahuꞌ neꞌmo nene tiꞌ lo lo sotoꞌ ogo lo-emavo gele minosa minineꞌ ve: Gaza nene Guvelesi veꞌmo do lunguꞌ izelive ma eleꞌmize molo imiselelesa live nene gaza ningamo helelinivoba mo ningosa helelesane. ");
INSERT INTO aso_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Idoꞌ Izesuꞌ izele mele ingine nene Moseꞌ louꞌ gamaziꞌmo ilizave lo lidoꞌ lidoꞌ nene i-dilisa monoꞌ numuno nabauꞌ eleꞌmize dizi nasivo Sikalahuꞌ neꞌmo do ote-davo aꞌmine ve Simeoniꞌ nesi nene aꞌminguꞌ dize minidotiꞌ ");
INSERT INTO aso_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","izipe nene do abasalauꞌ molo Oꞌmoso opoꞌni lo tiꞌ lo lineꞌ ve: ");
INSERT INTO aso_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Guvekasi ve make, gaza do luꞌ izelive do sotoꞌ o-daineꞌ nene naza neniꞌ veꞌnedunuꞌ gehepeve idise mo ningekuvoniꞌ nemuꞌ nene gaza gomuꞌ laineꞌ gamaziloꞌ eꞌmeto gelekeleꞌ veka neniꞌ nene mudise aka viline lo gele nemanivo muluꞌneuꞌ hongu lo minivo volosuve lo noluve. ");
INSERT INTO aso_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Idoꞌ gaza aꞌmine leliꞌ do luꞌ izelive mene eveneꞌ ato atoꞌ mukilite ningilizave lo do sotoꞌ o-do eleꞌmize molane. ");
INSERT INTO aso_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aꞌmine ve mene oloꞌ liviꞌ neꞌmino mino Zuda ve minamave heta atoꞌ ve nesi nene hize labanaꞌ ele-ngedeleseive. Idoꞌ eiꞌ sotoꞌ ogo minelineꞌ neꞌmo geze zuho Isilaeleꞌ aleveti guveꞌine nene moneleseive. ");
INSERT INTO aso_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Neꞌmine lavo Izesuꞌ izelehoi melehoi ingine nene Simeoniꞌ aꞌmine izipemuꞌ lineꞌ gamazi nemuꞌ nene voꞌine vavo gopo gaꞌine gili minasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Neꞌmine igi nizasivo Simeoniꞌ aza Oꞌmoso lengikisi mino hize eleꞌ o-lengedo minivo lo izipeliꞌmi izeleho Maliaꞌni tiꞌ lo lo-imineꞌ: Gelezo. Oꞌmosoꞌmo me izipe eleꞌmize molaniꞌ neꞌmo nene Isilaeleꞌ aleveutiꞌ eveneꞌ linge mukiꞌ nene ezemuꞌ goseleꞌ ngibilivo mini limi ingi goloso ilisave. Idoꞌ eveneꞌ linge ma nete nene ezela vi giꞌmizikevo do nguꞌ izo do ote-ngedelive losa eleꞌmize molaniꞌ ve. Ee, aza do nguꞌ izivo minilizaniꞌ aka do sotoꞌ ogo ngelebizeleseineꞌza eveneꞌ mukiꞌ ingine ezemuꞌ diviꞌ ledivika li-dilisave. ");
INSERT INTO aso_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Neꞌmine nili-davo geiꞌ mulunga hukilineꞌ nene bainati miteliꞌmo hizo sokuluꞌ lineꞌ geleleseive. Idoꞌ diviꞌ ledivika li-dilizaniꞌ neꞌmo eveneꞌ mukiꞌ luꞌninguꞌ gilaaꞌ naniꞌ gamazi nene mo sotoꞌ ogo mineleseive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Idoꞌ aꞌmida nene Oꞌmosoꞌmi veleutiꞌ gamazi lo sotoꞌ ogaꞌ ineꞌ veneꞌ ma minineꞌ gulive Hanaꞌ. Aza nene Zakoboꞌ gipele Aseliꞌ aꞌvopilemoꞌ zuhoutiꞌ ve Hanueliꞌ aluvo mino eleni gehepeve molo minineꞌ. Idoꞌ ganaꞌ apiꞌ ogo veloꞌ vidotiꞌ nene kilisimasi seveni (7) ogo vavo ");
INSERT INTO aso_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nelotiꞌ nene vanaho helavo veneꞌ gevonoꞌ mino kilisimasi eiti foꞌa (84) neꞌmine minineꞌ ve. Aza nene gamene gamene holukakisi holisekisi monoꞌ numuno naba nene hulo vamo Oꞌmosomuꞌ gelelesa nosoꞌ niteꞌ malise ogo mino Oꞌmosola lo Oꞌmoso opoꞌni lo minaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Neꞌmino minaaꞌ ineꞌ nenako Izesuꞌni eleꞌmizi monoꞌ numunguꞌ aniꞌ gameneloꞌ nene aꞌmine veneꞌ azasi nene aꞌmida ogo Izesuꞌ sotoꞌ ingumuꞌ nene Oꞌmoso isaaꞌ neve lo tangezoꞌ lo-do Oꞌmosoꞌmo Zelusalemi aleve goloso igi minangutiꞌ do nguꞌ izeli gamenemuꞌ gizebo igi minave nene aꞌmine izipe Izesuꞌnimuꞌ gamaziꞌve nene lo sotoꞌ o-ngemeꞌ ngemeꞌ oꞌmo ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Idoꞌ Zoseheki Maliaki ingine Guvelesi veꞌmi louꞌ gamaziloꞌ eꞌmeti ilisa asineꞌ initeꞌ mukiꞌ nene di pili engiꞌ numuꞌine ebeꞌine Nasalete nGalilaia misubouko nene tineꞌ mili vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Idoꞌ nelotiꞌ aꞌmine izipe Izesuꞌ nene naba oꞌmo vo ngenga lo otohato gala gelo neivo Oꞌmoso neꞌmo ninge lamineꞌ do hize eleꞌ o-daaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Idoꞌ kilisimasiloꞌ kilisimasiloꞌ Izesuꞌ izele mele ingine nene engiꞌ Zuda veti avoꞌningine Oꞌmosoꞌmo iseꞌine izingumuꞌ gohi gili mini nosoꞌ niteꞌ naaꞌ aniꞌ holiseꞌ nene alitavo aꞌmine nosoꞌ niteꞌ nalisa Zelusalemi numuda vaaꞌ asineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nemuꞌ nene Izesuꞌ aza kilisimasiꞌve tuvelu (12) neivo aꞌmine holiseꞌ mini nosoꞌ niteꞌ nalisa ingine mo vaaꞌ aniꞌ maꞌmine igi Zelusalemi numuda dizi vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Idoꞌ dizi mini aꞌmine nosoꞌ niteꞌ nene ni osuꞌ li numuꞌnida apiꞌ igi tineꞌ mili nivavo Izesuꞌ aza engikisi vamo ha minineꞌ. Idoꞌ aꞌmida ha miningumuꞌ nene izele mele ingine gilami ");
INSERT INTO aso_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","aza nene leze alevesi naahe li gili nivasivo litiꞌmuso izavo engiꞌ alevela nene ezemuꞌ apiꞌ igi viseꞌ asineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Viseꞌ igi mo ningami gohi ezemuꞌ visetoꞌ Zelusalemi numuda tineꞌ mili vasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tineꞌ mili vi viseꞌ igi nizasivo gamene sito hamo ogo vavo Izesuꞌ nene monoꞌ numuno nabauꞌ monoꞌ apizi ngimaaꞌ aveti vovoꞌninguꞌ mino gamazi ladoꞌ gapepeꞌ ogo gelo mino initeꞌ atoꞌ atokumuꞌ nene longoꞌ o-ngedo gelo neivo ningasineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Idoꞌ Izesuꞌ gamazi lineꞌ gilave mukiꞌ ingine nene aza gala gele nge lo mino gamazi lingumuꞌ nesi idoꞌ longoꞌ i-daniꞌ gamaziloꞌ do velepeꞌ izo laminetokovoꞌ lo-ngimineꞌ nemukisi nene voꞌine vavo aizo li gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Idoꞌ izelehoi melehoi ingine Izesuꞌ nene neꞌmine ogo neivo ningi voꞌine goloso vavo upuhoꞌ asineꞌ. Neꞌmine igi izeleho aza Izesuꞌni tiꞌ lo lo-imineꞌ: Gipeꞌne, gaza nene neꞌmino minanivo mahosi nezesi nene geikumuꞌ gopo gate gelo viseꞌ goloso okusiko nanimuꞌ neꞌmine ane. ");
INSERT INTO aso_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Neꞌmine lavo Izesuꞌ aza izelehingi melehingi nene tiꞌ lo lo-ngimineꞌ ve: Nenikumuꞌ nene nanimuꞌ viseꞌ asive. Naza nene meꞌnehi numunguꞌ nene minelodoꞌ o neineꞌ nene gili minilisinako gilamasihe. ");
INSERT INTO aso_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Neꞌmine lineꞌza ingine nene aꞌmine lineꞌ gamazi neꞌmi monovomuꞌ nene ma gili hehe lamasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Neꞌmine ikesivo aza nene izelehoi melehosi makaꞌ limi vi Nasaletela heteli minaniꞌ ve. Idoꞌ Izesuꞌ nene mo izelehi melehi gamaziꞌnidoꞌ nene gele do minaaꞌ ineꞌ. Neꞌmino neivo izeleho aza nene aꞌmine Zelusalemi numuda sotoꞌ ineꞌ initeꞌ mukiꞌ nemuꞌ nene gelo do madunouꞌ molaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Neꞌmine ogo neivo Izesuꞌ aza nene naba oꞌmo vo neivo ezela gala gele nge laaꞌ monovoꞌve nene vaiꞌ loꞌmo novivo eveneꞌ nete ningi lamineꞌ nidavo idoꞌ Oꞌmoso neꞌmosi nene ninge lamineꞌ daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Idoꞌ Tibelioꞌ Kaesaleꞌ aza kilisimasi fiftini (15) neꞌmine Loma veti guveꞌinesi ve loloꞌ ogo neivo Podioꞌ Pilatoꞌ nene Zudaia misubouꞌ ngamani naba loloꞌ o-davo evenetoꞌ gizebo ogo neivo idoꞌ Helodeꞌ aza meleho gomuꞌ gizebo ineꞌ misubo linge ma nGalilaia misubouꞌ nene guvelesi ve loloꞌ ogo neivo idoꞌ akunolo Hilipoꞌ nene misubo linge ma Itulia misuboukisi Talakonito misuboukisi nene guvelesi ve neivo idoꞌ Lisaniaꞌ nene misubo linge ma Abilene misubouꞌ nene guvelesi ve neivo ");
INSERT INTO aso_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","idoꞌ Anasiꞌ ve Kaiahaꞌ ve ingine nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ asive naba nizasivo neꞌmine igi minaniꞌ gameneloꞌ nene Zakaliaꞌ gipele Zohaneꞌ aza ebeꞌ hadivela mininguꞌ nene Oꞌmoso neꞌmo eze gamaziꞌve eveneꞌ lo-ngeme ngemeꞌ ilive lo aꞌmine Zohaneꞌ veleuꞌ molavo lo-ngeme ngemeꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Neꞌmine oꞌmo novo Zodani noso gahevela misubo mukiꞌ mineꞌmo moninguꞌ nene tiꞌ lo lo-ngeme ngemeꞌ oꞌmo vineꞌ: Oꞌmosoꞌmo lengiꞌ lihimetine nene hulo-lengedelingumuꞌ ve li lingine lutine di velepeꞌ izi monoꞌ noso hilalo. ");
INSERT INTO aso_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Neꞌmino lo-ngeme ngemeꞌ oꞌmo vo minineꞌ nene monoꞌ godolouꞌ polohete Isaiaꞌ tiꞌ lo lineꞌ gamazi gizaniꞌ minineꞌ maloꞌ nene vo gihile izineꞌ ve: Ebeꞌ hadivelatiꞌ eveneꞌ maliꞌmo asi naba ma tiꞌ lo nolive: Guvelesi ve alingumuꞌ ve li akaꞌve di vaꞌvaꞌ igi lutine di lisiheꞌ i-dilo. ");
INSERT INTO aso_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Giꞌmize gaꞌmize nene misubo mili di lisiheꞌ igi golo ngomoꞌ nabaꞌ dizaaꞌ lemaaꞌ o neineꞌ nene bili diꞌmi limi di lisiheꞌ igi aka zovoꞌ zavaꞌ izo minineꞌ nene di pehe li idoꞌ aka goloso o nolineꞌ nene hasaꞌ igi di lisiheꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Neꞌmine ikevo eveneꞌ mukiꞌ ingine Oꞌmosoꞌmo eze evenele do nguꞌ izelineꞌ aka nene ningilisave. ");
INSERT INTO aso_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Idoꞌ polohete Isaiaꞌ nene Zohaneꞌ neꞌmine gamazi lilingumuꞌ lineꞌ nenako nemuꞌ nene eveneꞌ vaiꞌ goloso neꞌminete Zohaneꞌ noso holo-ledelive li eiꞌ neida ikevo aza tiꞌ lo lo-ngeme ngemeꞌ ogo minineꞌ: Lingine sataliꞌmi izipahala goloso mene Oꞌmosoꞌmo lihime lengemelingutiꞌ ha olovoꞌ ilisave lo ve maliꞌmo lo-lengemavosa olovoꞌ ilisa nahe. ");
INSERT INTO aso_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nemuꞌ nene lingine aꞌmingutiꞌ olovoꞌ olone lii ma lingine luꞌine di velepeꞌ lamineꞌ izaveti monovo nene di mini initeꞌ lamineꞌ gihilevoꞌ nene igi mili minilo. Idoꞌ gililo. Lingine laza Abalahamuꞌ aꞌvopilemoꞌ Oꞌmosoꞌmo noꞌnohoꞌ ize-ledelesuve live nounako Oꞌmosoꞌmo lihime lemo do goloso o-ledamivo laminekovoꞌ ha minelesune li mo lamilo. Naza ma lo-lengemeloze. Lengiꞌ nene do hulosa Oꞌmosoꞌmo Abalahamuꞌni lo huko-dineꞌ gamazi do gihile izelesa Abalahamuꞌ aꞌvopilemoꞌ gohi ma do sotoꞌ o-delove lo gilidiniko geheni nevote Abalahamuꞌ aꞌvopilemoꞌ liliꞌ adine. Nemuꞌ nene lingine laza Abalahamuꞌ aꞌvopilemoꞌ nounako lihime lemamoloseive li gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Oꞌmosoꞌmo idise lihime lemo mo lebelelesa do nene ogo mino eveneꞌ za belelesa za monovola luno bai gamunoꞌ ogaꞌ neineꞌ neꞌmine o neive. Za mukiꞌ gihile lamineꞌ izamaniꞌ nene monoꞌ gilamaniꞌ aleve neꞌminosa nenako huko olokuꞌ gizeleseive. ");
INSERT INTO aso_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Neꞌmine lavo eveneꞌ nete tiꞌ li longoꞌ i-daniꞌ: Idoꞌ gaza neꞌmine laineꞌ nemuꞌ nene Oꞌmosoꞌmo neꞌmine o-ledamilingumuꞌ nene laza nadiꞌ olone. ");
INSERT INTO aso_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Neꞌmine likevo Zohaneꞌ tiꞌ lo lo-ngimineꞌ: Lingine nene okodidoꞌ izaaꞌ naniꞌ initeꞌ saketitine nene sitaꞌ neivo ma nene saketiꞌve ma nomivo nolive nesi nene izeꞌ mili dalisive. Idoꞌ aꞌmineꞌmine igi ve ma ingine nosoꞌ niteꞌine ma neivo minaaꞌ nave nete nene ma nomivo minaaꞌ nave nene izeꞌ mili ngimi ni minilizave. ");
INSERT INTO aso_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Idoꞌ takisi moni daaꞌ ave nesi nene monoꞌ noso holo-ledelive li Zohaneꞌ neida igi tiꞌ li longoꞌ i-daniꞌ: Idoꞌ Tisazo, leliꞌ nene nadiꞌ oloneꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Lingine nene eveneꞌ takisi moni di-ngidilizanguꞌ nene ngamaniꞌmo moni neꞌmine makiloꞌ dalizave lo-lengede nolineꞌ maki nene ivileꞌ igi di gopo igi vaiꞌ damilo. ");
INSERT INTO aso_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Neꞌmine lo-ngedavo ami pilisi ve netesi nene igi tiꞌ li longoꞌ i-daniꞌ: Idoꞌ leze nene nadiꞌ oloneꞌ o neive. Neꞌmine likevo Zohaneꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine eveneꞌ mamuꞌ nene lengebelalone idoꞌ gonikuꞌ lengeleꞌmize molalonge moni limilo li soza sakupo gamazi li-ngidi ngehelele izelineꞌ initeꞌ i-ngidi moni gumine damilo. Moni gohi gohi dalisa amuzo milami menitine lingimilizanikovoꞌ lisiheꞌ igi dalo. ");
INSERT INTO aso_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Idoꞌ Zohaneꞌ neꞌmine ogo miningumuꞌ gili eveneꞌ nete leze do luꞌ izelive lo Oꞌmosoꞌmo imiselelesa live nene mo sotoꞌ olosa neihe li laniteꞌ gilii aꞌminemuꞌ gizebo igi mini eveneꞌ mukilite aꞌmine ve nene aꞌmine Zohaneꞌ nolihe li luꞌninguꞌ nigilavo ");
INSERT INTO aso_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zohaneꞌ aza aꞌmine eveneꞌ mukiꞌ nene tiꞌ lo lo-ngimineꞌ: Naza nene monoꞌ noso holo-lengedeꞌmo vo nouvoniꞌ nene haza nosodunuꞌ holo-lengedeꞌmo vo nouvoniꞌza eveneꞌ ma neniꞌ amuzo nesi ivileꞌ o neineꞌ amuzoꞌvesi minive nene mo nave. Naza aꞌneꞌmine goboni gono do-do eiꞌ suuꞌvelotiꞌ nalaꞌve nesi nene apase hulo-delodoꞌ nene lisiheꞌ amuve. Aꞌmine ve neꞌmo noso neꞌmine holo-lengedelineꞌ nene Oꞌmosoꞌmi Sikalahukisi olokisi ne neive. ");
INSERT INTO aso_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ee, aꞌmine ve nene eveneꞌ laminekisi golososi do gizekaꞌ olosa do nene ogo mino ve ma viti gihilesi losuvosi gopo igi minaniꞌ nene do kegeselesa gono daaꞌ initeꞌve do anauꞌ ogo do nene ogo minaaꞌ neineꞌ neꞌmine o neive. Aza viti gihile losuvosi minangutiꞌ aꞌmine vaiꞌ nene do lamino izeꞌ moloo naaꞌ initeꞌ nene do nubo ogo numuꞌveuko molo losuvo nene lovoꞌ lovoꞌ ogo minaaꞌ neineꞌ olokuꞌ nene gizeleseive. ");
INSERT INTO aso_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Idoꞌ neꞌmine gamazi nene ato atoꞌ vaiꞌ lo-ngemo luꞌine do ngi lo-ngedo monoꞌ gamazi lamineꞌ nene eveneꞌ lo sotoꞌ o-ngemo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Neꞌmine ogo minineꞌza guvelesi ve Helodeꞌ aza akunoloꞌmi elenahine ipeꞌ ogo dangumukisi idoꞌ goloso niteꞌ vaiꞌ dangumukisi Zohaneꞌ aza elemavo ");
INSERT INTO aso_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Helodeꞌ aza aꞌmine goloso niteꞌ vaiꞌ dadoꞌ nene imineꞌ molo monovo goloso gohi ogo Zohaneꞌni nene galapuso numunguꞌ hulo-dineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Idoꞌ Helodeꞌ aza Zohaneꞌni galapuso numunguꞌ olihe hulo-damivo Zohaneꞌ aza eveneꞌ mukiꞌ nene monoꞌ noso holo-ngedo osuꞌ losa nelotiꞌ Izesuꞌni nesi nene noso holo-davo Oꞌmosola lo neivo Okulumoꞌ nene ngoloꞌ lavo ");
INSERT INTO aso_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Oꞌmosoꞌmi Sikalahuꞌ nene nama viluso neꞌmine okoꞌno do otuho Izesuda lemo aniꞌ ve. Lemo navo Okulumokutiꞌ gamazi ma tiꞌ lo limineꞌ ve: Gaza nene voꞌneloꞌ gipeꞌne hamoꞌ nene nane. Gezemuꞌ nene mo muluꞌneuꞌ lamineꞌ nogiluve. ");
INSERT INTO aso_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Neꞌmine ogo nelotiꞌ Izesuꞌ aza gonoꞌve gihile nene apiꞌ ogo do do vineꞌ nene kilisimasiꞌve teoti (30) neꞌmine minosa gonoꞌve gihile nene apiꞌ ineꞌ ve. Idoꞌ evenelite gilavo Izesuꞌ aza Zoseheꞌ gipele minineꞌ ve. Idoꞌ aꞌmine Zoseheꞌ nene Heliꞌ gipele minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Idoꞌ Heliꞌ nene Matatiꞌ gipele minineꞌ. Idoꞌ Matatiꞌ nene Leviꞌ gipele minineꞌ. Idoꞌ Leviꞌ nene Melekiꞌ gipele minineꞌ. Idoꞌ Melekiꞌ nene Zanaiꞌ gipele minineꞌ. Idoꞌ Zanaiꞌ nene Zoseheꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Idoꞌ Zoseheꞌ nene Matatiaꞌ gipele minineꞌ. Idoꞌ Matatiaꞌ nene Amosiꞌ gipele minineꞌ. Idoꞌ Amosiꞌ nene Nahumiꞌ gipele minineꞌ. Idoꞌ Nahumiꞌ nene Hesiliꞌ gipele minineꞌ. Idoꞌ Hesiliꞌ nene Nagaiꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Idoꞌ Nagaiꞌ nene Maatiꞌ gipele minineꞌ. Idoꞌ Maatiꞌ nene Matatiaꞌ gipele minineꞌ. Idoꞌ Matatiaꞌ nene Semeiniꞌ gipele minineꞌ. Idoꞌ Semeiniꞌ nene Zosekeꞌ gipele minineꞌ. Idoꞌ Zosekeꞌ nene Zodaꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Idoꞌ Zodaꞌ nene Zoanaꞌ gipele minineꞌ. Idoꞌ Zoanaꞌ nene Lesaꞌ gipele minineꞌ. Idoꞌ Lesaꞌ nene Zelubabeliꞌ gipele minineꞌ. Idoꞌ Zelubabeliꞌ nene Sealetieliꞌ gipele minineꞌ. Idoꞌ Sealetieliꞌ nene Neliꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Idoꞌ Neliꞌ nene Melekiꞌ gipele minineꞌ. Idoꞌ Melekiꞌ nene Adiꞌ gipele minineꞌ. Idoꞌ Adiꞌ nene Kosamuꞌ gipele minineꞌ. Idoꞌ Kosamuꞌ nene Elimadamuꞌ gipele minineꞌ. Idoꞌ Elimadamuꞌ nene Eliꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Idoꞌ Eliꞌ nene Zosuaꞌ gipele minineꞌ. Idoꞌ Zosuaꞌ nene Eliezeleꞌ gipele minineꞌ. Idoꞌ Eliezeleꞌ nene Zolimiꞌ gipele minineꞌ. Idoꞌ Zolimiꞌ nene Matatiꞌ gipele minineꞌ. Idoꞌ Matatiꞌ nene Leviꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Idoꞌ Leviꞌ nene Simeoniꞌ gipele minineꞌ. Idoꞌ Simeoniꞌ nene Zudaꞌ gipele minineꞌ. Idoꞌ Zudaꞌ nene Zoseheꞌ gipele minineꞌ. Idoꞌ Zoseheꞌ nene Zonamuꞌ gipele minineꞌ. Idoꞌ Zonamuꞌ nene Eliakimiꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Idoꞌ Eliakimiꞌ nene Meleaꞌ gipele minineꞌ. Idoꞌ Meleaꞌ nene Menaꞌ gipele minineꞌ. Idoꞌ Menaꞌ nene Matataꞌ gipele minineꞌ. Idoꞌ Matataꞌ nene Nataniꞌ gipele minineꞌ. Idoꞌ Nataniꞌ nene Zuda veti guveꞌinesi ve naba Davidiꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Idoꞌ Davidiꞌ nene Zesaiꞌ gipele minineꞌ. Idoꞌ Zesaiꞌ nene Obediꞌ gipele minineꞌ. Idoꞌ Obediꞌ nene Boaziꞌ gipele minineꞌ. Idoꞌ Boaziꞌ nene Salaꞌ gipele minineꞌ. Idoꞌ Salaꞌ nene Nasoniꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Idoꞌ Nasoniꞌ nene Aminadabuꞌ gipele minineꞌ. Idoꞌ Aminadabuꞌ nene Adiminiꞌ gipele minineꞌ. Idoꞌ Adiminiꞌ nene Alaniꞌ gipele minineꞌ. Idoꞌ Alaniꞌ nene Hezeloniꞌ gipele minineꞌ. Idoꞌ Hezeloniꞌ nene Pelezaꞌ gipele minineꞌ. Idoꞌ Pelezaꞌ nene Zudaꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Idoꞌ Zudaꞌ nene Zakoboꞌ gipele minineꞌ. Idoꞌ Zakoboꞌ nene Isakaꞌ gipele minineꞌ. Idoꞌ Isakaꞌ nene Abalahamuꞌ gipele minineꞌ. Idoꞌ Abalahamuꞌ nene Telaꞌ gipele minineꞌ. Idoꞌ Telaꞌ nene Naholiꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Idoꞌ Naholiꞌ nene Selugaꞌ gipele minineꞌ. Idoꞌ Selugaꞌ nene Leguꞌ gipele minineꞌ. Idoꞌ Leguꞌ nene Pelekoꞌ gipele minineꞌ. Idoꞌ Pelekoꞌ nene Ebeliꞌ gipele minineꞌ. Idoꞌ Ebeliꞌ nene Selaꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Idoꞌ Selaꞌ nene Kenaniꞌ gipele minineꞌ. Idoꞌ Kenaniꞌ nene Alahasadaꞌ gipele minineꞌ. Idoꞌ Alahasadaꞌ nene Semiꞌ gipele minineꞌ. Idoꞌ Semiꞌ nene Noaꞌ gipele minineꞌ. Idoꞌ Noaꞌ nene Lamekiꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Idoꞌ Lamekiꞌ nene Metuselaꞌ gipele minineꞌ. Idoꞌ Metuselaꞌ nene Enokuꞌ gipele minineꞌ. Idoꞌ Enokuꞌ nene Zalediꞌ gipele minineꞌ. Idoꞌ Zalediꞌ nene Mahalaleliꞌ gipele minineꞌ. Idoꞌ Mahalaleliꞌ nene Kenaniꞌ gipele minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Idoꞌ Kenaniꞌ nene Enosiꞌ gipele minineꞌ. Idoꞌ Enosiꞌ nene Setiꞌ gipele minineꞌ. Idoꞌ Setiꞌ nene Adamuꞌ gipele minineꞌ. Idoꞌ Adamuꞌ nene Oꞌmosoꞌmo loloꞌ o-davo gipele neꞌmine minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Idoꞌ Izesuꞌni nene Oꞌmosoꞌmi Sikalahuꞌ neꞌmo lulouꞌ lemo mino gono dadiꞌmo do zauꞌ o-davo Zodani nene hulo misubo gaꞌmeta vavo aꞌmida Oꞌmosoꞌmi Sikalahuꞌ aza gamene foti (40) neꞌmine eleꞌmizo nomonivo Satani neꞌmo emenguꞌ molokaꞌ molokaꞌ ogo minineꞌ. Aꞌmine gameneuꞌ nene Izesuꞌ aza velesi namo minineꞌ nenako aꞌmine gamene foti (40) nene ogo vo osuꞌ nolivo gaꞌna naba helo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Neꞌmine neivo Satani aza ogo Izesuꞌni tiꞌ lo lo-imineꞌ: Gaza nene Oꞌmosoꞌmi gipele noo ma nene gaza geheni mevoomuꞌ lanivo nalineꞌ initeꞌ beleti loloꞌ ozo lovo. ");
INSERT INTO aso_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Oꞌove. Monoꞌ godolouꞌ gamazi ma tiꞌ li gizi nizaniꞌ ma neive: Eveneꞌ minevoꞌ alevote nene nosoꞌ nitekukovoꞌ nomive. Neꞌmine li gizi nizaniꞌ nenako nemuꞌ nene geiꞌ laineꞌ neꞌmine nene mo amolosuve. ");
INSERT INTO aso_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Idoꞌ nelotiꞌ nene aza golo maloꞌ Izesuꞌni eleꞌmizo dize mino misubouꞌ misubouꞌ minaniꞌ eveneꞌ zuho ato atoꞌ mukiꞌ misuboꞌninguꞌ misuboꞌninguꞌ minaniꞌ nene liteꞌ lo elebizo osuꞌ lo ");
INSERT INTO aso_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","tiꞌ lo lo-imineꞌ: Aꞌmine eveneꞌ zuho ato atoꞌ mukitoꞌ gizebo ogaꞌ amuzo nesi idoꞌ engiꞌ guveꞌine vaaꞌ neineꞌ nesi nene neniꞌ initeꞌ loloꞌ ogo neineꞌ nenako eveneꞌ ma emelove lo geleloniꞌ nene zaho nolihe aꞌmine ve nene ha emelodoꞌ o nouve. ");
INSERT INTO aso_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Idoꞌ aꞌmine amuzo emelove lo giluve nene ha emelodoꞌ o nouvoniꞌ nenako gaza gubiꞌ ize nemo obuvoka hize nemelineꞌ aꞌmine initeꞌ nene gemekuvo mukiꞌ nene geiꞌ initeꞌ loloꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Monoꞌ godolouꞌ tiꞌ li gizi nizaniꞌ ma neive: Laza Guvetesi ve Oꞌmoso eiꞌ hamoꞌ nene opoꞌni lo gubiꞌ ize emo minelesune. Ee, eiꞌ hamokovoꞌ nene gelekeleꞌ o-do minelesune. Neꞌmine li gizi nizaniꞌ nenako nemuꞌ nene gaza laineꞌ neꞌmine amolosuve. ");
INSERT INTO aso_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Idoꞌ aza gohi eleꞌmizo Zelusalemi ebekuꞌ vo monoꞌ numuno naba haꞌna haꞌna minineꞌ neꞌmi gololoꞌ eleꞌmizo dize mino tiꞌ lo lo-imineꞌ: Monoꞌ godolouꞌ tiꞌ li gizi nizaniꞌ ma neive: Oꞌmosoꞌmo geiꞌ gizebo i-gidilizangumuꞌ angeloꞌve gono gamazi lo-ngedeleseive. Idoꞌ ma nene: Gizenga geheniloꞌ gebele gulutilingutiꞌ angeloꞌ nete alete mili di hozi li-gidilisave li gizi nizaniꞌ ve. Idoꞌ aꞌmine gamazi lidoꞌ igi neꞌmine i-gidilisaze. Gaza lamineꞌ Oꞌmosoꞌmi gipele noo ma nene melotiꞌ oluto akaꞌmeloꞌ izevo. ");
INSERT INTO aso_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Ne neiha monoꞌ godolouꞌ gamazi ma tiꞌ lo neive: Lingine Guvetinesi ve Oꞌmoso nene golo izamilo. Neꞌmine lo-leme neineꞌ ma nenako geze nolaineꞌ nene Oꞌmoso golo izaaꞌ noloseinako neꞌmine amolosuve. ");
INSERT INTO aso_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Neꞌmine lavo Satani aza emenguꞌ molo osuꞌ lo gamene ma emenguꞌ molalosa hulo-do vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Idoꞌ Izesuꞌ nene Oꞌmosoꞌmi Sikalahuliꞌmo amuzo emo hize eleꞌ o-davo nGalilaia misubouko do tineꞌ molo vineꞌ. Tineꞌ molo vavo aꞌmida nene eiꞌ guvele neꞌmo buu lo nGalilaia misubo gahevela ebeꞌ mukikuꞌ nene mone osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aꞌmine nGalilaia misubouꞌ nene monoꞌ numuno mininguꞌ mininguꞌ monoꞌ apize ngeme ngemeꞌ ivo eveneꞌ mukiꞌ di naba i-di gekeꞌ li-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Neꞌmine ikevo Izesuꞌ aza mino naba ineꞌ ebeꞌve Nasaletela vo hetelo aza ogaꞌ idiꞌmine ogo holiseꞌ gamene ogavo monoꞌ numunguꞌ monoꞌ gili nizanguꞌ nene dizineꞌ. Dizo mitoꞌ neivo monoꞌ godoloutiꞌ polohetelite gizaniꞌ gamazi linge ma gililizaniꞌ gamene ogavo Izesuꞌ aza aꞌmine monoꞌ gato ngemelesa ote neivo ");
INSERT INTO aso_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","monoꞌ numudoꞌ gizebo ve aza polohete Isaiaꞌ gizineꞌ monoꞌ buku nene do emavo buku nene do patelo gamazi ma tiꞌ lo gizineꞌ minineꞌ nene do sotoꞌ ineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Guvelesi veꞌmo neniꞌ nene eze gonoloꞌ neleꞌmize molaniꞌ nenako neꞌmo eiꞌ Sikalahuꞌve nene nenita omo neive. Ee, Guvelesi ve aza gono gamazi tiꞌ lo lo-nimineꞌ: Gaza eveneꞌ gohoꞌ gahaliꞌ neꞌmine minaniꞌ nene neniꞌ gamaziꞌne lamineꞌ nene lo sotoꞌ o-ngemeline lo neleꞌmize molaniꞌ ve. Idoꞌ biluvaliti aꞌninguꞌ galapuso ve neꞌmine gili minave nene kuluhizi vilizaniꞌ akatine nene mo idise ngoloꞌ lave lo lo sotoꞌ o-ngemeline lo neleꞌmize molaniꞌ ve. Idoꞌ veꞌine likive neꞌmine minavemuꞌ nene gohi veꞌine ningilizaniꞌ aka nene mo ngoloꞌ lave lo lo sotoꞌ sotoꞌ ogo lo-ngemeline lo nimiselineꞌ ve. Idoꞌ goboni malaꞌ malaꞌ i-ngidavo geni initeliꞌmi lulouꞌ minave nene gaza aꞌmingutiꞌ hulo heta o-ngedosa ");
INSERT INTO aso_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Guvelesi veꞌmo ninge lamineꞌ o-ngedelineꞌ gamene nene mo alitave lo lo sotoꞌ o-ngemeline lo nimiselineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Idoꞌ aꞌmine gamazi nene mo gato ngemo buku nene do gango monoꞌ numudoꞌ gizebo ve nene do emo mitoꞌ minavo aꞌmine monoꞌ numunguꞌ minave mukiꞌ nene monoꞌ lo-lemelihe li vonuꞌ bili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Neꞌmine igi nizavo aza gamazi apiꞌ ogo tiꞌ lo lo-ngimineꞌ: Aꞌmine monoꞌ godoloutiꞌ gamazi mene lingine nigilavo idise aꞌmene gihile noizive. ");
INSERT INTO aso_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Neꞌmine lavo ingine di naba i-di gamazi lamineꞌ eiꞌ veleutiꞌ lineꞌ nemuꞌ nene veꞌine gahava nomivo mini tiꞌ li laniꞌ: Aza nene ha Zoseheꞌ gipele nenako neꞌmine gamazi nene nadosa nolive. Olo. ");
INSERT INTO aso_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Neꞌmine likevo aza aneza gamaziutiꞌ tiꞌ lo lo-ngimineꞌ: Naza giluvoniꞌ lingine tiꞌ li li-nimilisa gilaniꞌ ve: Dotazo, gaza eveneꞌ atoꞌ do lamineꞌ o-ngedaaꞌ naineꞌ neꞌmino geiꞌ okongasi do lamineꞌ ovo. Nemuꞌ nene aꞌmine gamaziloꞌ eꞌmeto gaza Kahanaumi numuda do sotoꞌ ane lavo giluneꞌ initeꞌ nene gaza geiꞌ numunga ebeka melokisi do sotoꞌ ovo. ");
INSERT INTO aso_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Idoꞌ neꞌmine lo tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ tiꞌ lo lo-lengemeloze. Gililo. Oꞌmosoꞌmi veletiꞌ gamazi laaꞌ unive polohete mukiꞌ leliꞌ numudela leliꞌ zuho gihile nete leliꞌ polohetelite lunidoꞌ nene ma gili limisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nemuꞌ nene naza laminetoꞌ ma tiꞌ lo nolo-lingimuve: Isilaeleꞌ misubouꞌ mene gozopota polohete Eliaꞌ minineꞌ gameneuꞌ nene Oꞌmosoꞌmo goline izelineꞌ aka hize tilavo kilisimasi setohamosi hapusi ogo novivo goline izamivo aꞌmine misubo mukikuꞌ nene gaꞌna naba sotoꞌ ogavo minaniꞌ gamenela nene Isilaeleꞌ veneꞌ engikutiꞌ nene veneꞌ gevonoꞌ mukiꞌ minaniꞌza ");
INSERT INTO aso_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Oꞌmosoꞌmo Eliaꞌni nene hize eleꞌ o-ngedelingumuꞌ engiꞌ mukita imiselamo asi Sidoni misubouꞌ numuno ebeꞌ ma gulive Zalehati nela heta atoꞌ veneꞌ gevonoꞌ minida imiselavo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Idoꞌ Isilaeleꞌ misubouꞌ mene polohete Elisaꞌ minineꞌ gameneuꞌ nene ganadise gizi dave vaiꞌ minaniꞌza polohete Elisaꞌ aza aꞌmingutiꞌ hamokisi ma do lamineꞌ o-ngedamo asi heta atoꞌ ve Silia misuboutiꞌ ve Naamaniꞌni nene do lamineꞌ o-dineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Neꞌmine lavo aꞌmine monoꞌ numunguꞌ mini lineꞌ gamazi gilave mukiꞌ nene aza lelita gono dalidoꞌ lisiheꞌ amune nolive li gili ngizeboloꞌ goloso molaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Neꞌmine ogavo oti Izesuꞌni nene ehusoꞌ ahasaꞌ igi numuno ebeꞌine neꞌmi heta di vi aꞌmine numuꞌine ebeꞌine minineꞌ gololotiꞌ nene aveseuꞌ ehusoꞌ i hulilisa aniꞌza ");
INSERT INTO aso_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","aza vovoꞌningutiꞌ olovoꞌ ogo vo mala vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Idoꞌ Izesuꞌ aza nGalilaia misubouꞌ numuno ebeꞌ ma Kahanaumi nela lemo vineꞌ. Aꞌmida vo neivo holiseꞌ gamene ogavo monoꞌ apize ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Neꞌmino neivo monoꞌ gamazi lo-ngimivo gilave ingine Izesuꞌ aza nene gamazi eveneꞌ malite ladoꞌ do molo lamo asi gamazi neꞌmi meleho neꞌmine mino lo-ngimidiꞌmo voꞌine vavo upuhoꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Neꞌmine igi nizavo aꞌmine engiꞌ monoꞌ numunguꞌ nene Satanilatiꞌ sikalahuꞌ goloso lulouꞌ minive ma minidiꞌmo gekeꞌ gekeꞌ lo tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Agae, Nasalete ve Izesuvo, leliꞌ nonida mene nanimuꞌ ane. Gaza do goloso o-ledelesa abe. Geze nene naza mo ningo gele nouve ma nene nane. Gaza nene Oꞌmosolatiꞌ kegeso lamineꞌ minanive ma nene nane. ");
INSERT INTO aso_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Neꞌmine lineꞌza Izesuꞌ aza elemo tiꞌ lo lo-imineꞌ: Gamazi lamo zegeneꞌ oko mino eveneꞌ hulo-do lemo ogo vozo. Lavo sikalahuꞌ goloso neꞌmo eveneꞌ nene eveneꞌ mukiliti vovoꞌninguꞌ nene ehusoꞌ ogo do ongo-do luloutiꞌ lemo ogo vineꞌza eveneꞌ nene do goloso o-damineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Neꞌmine ogo lemo vavo eveneꞌ ingine ningi upuhoꞌ igi tiꞌ li li gele ha gele aniꞌ: Mene naniꞌmine gamazi live. Aza nene mo gavele ve mino atoliꞌmine amuzo do mino lavo sikalahuꞌ goloso netesi eze gamazi gili dii eveneꞌ neti luꞌningutiꞌ nesi limi vaaꞌ naanako eze gamaziꞌve nene amuzoꞌvesi minineꞌ atoliꞌmine gamazi neive. ");
INSERT INTO aso_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Li likevo Izesuꞌ guvele neꞌmo aꞌmine ebeꞌ neꞌmi gahevela numuno ebeꞌ miniꞌmi monaniꞌ mukikuꞌ nene buu lo mone osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Neꞌmine ogavo Izesuꞌ aza oto monoꞌ numuno hulo lemo voo Simoni Petoloꞌ numuꞌveuꞌ vo dizineꞌ. Aꞌminguꞌ nene Simoni elenahi izeleho nene okoꞌnouꞌ oloꞌ naba goloso lavo neivo aꞌmine veneꞌ nene do lamineꞌ o-delibo li Izesuda laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Neꞌmine likevo aza ogo veneꞌ neida ote mino aꞌmine okoꞌnouꞌ oloꞌ lo minineꞌ initeꞌ nene mate-delive lo amuzonga lo-davo okoꞌnouꞌ oloꞌ lineꞌ nene osuꞌ lo-dineꞌ. Neꞌmine ogavo veneꞌ aza liteꞌ lo oto ngeleꞌmize lamineꞌ ogo nasahiliꞌ o-ngedo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Idoꞌ nivengaꞌ hoꞌ nolimivo eveneꞌ mukiꞌ ingine engiꞌ zuhoutiꞌ initeꞌ ato atoꞌ gizi dave minaniꞌ nene Izesuꞌ neida ngeleꞌmizi ikevo Izesuꞌ aza aꞌmine initeꞌ gizi dave mukiꞌ nene okoꞌnidoꞌ do gelekaꞌ gelekaꞌ ogo do lamineꞌ o-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Neꞌmine noo-ngedo eveneꞌ mukiliti luꞌningutiꞌ sikalahuꞌ goloso minaniꞌ nesi ngimiselo do nohulo-ngidivo aꞌmine sikalahuꞌ goloso nete tiꞌ li laniꞌ: Gaza nene Oꞌmosoꞌmi gipele ma nene nane. Neꞌmine li eveneꞌ luꞌningutiꞌ huli-ngidi limi nivavo aꞌmine sikalahuꞌ goloso nete Izesuꞌ nene Oꞌmosoꞌmo do nguꞌ izelive lo do kegese-do imiselelesa live ma ne neive li gili nizaniꞌ nenako nemuꞌ nene Izesuꞌ aza sikalahuꞌ goloso ingine gamazi lami zegeni limi vilizave lo ngelemineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Idoꞌ goꞌ lavo nedengaꞌ Izesuꞌ aza numungutiꞌ lemo eveneꞌ nizamada guvisela vo minineꞌ. Vo neivo eveneꞌ mukiꞌ ingine ezemuꞌ viseꞌ iꞌ moni moni neida igi hulo-ngedo vamilive li laniꞌza ");
INSERT INTO aso_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","aza tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo eveneꞌ eze gizebouꞌ vi hilalizaniꞌ akaꞌmi gamazi lamineꞌ nene lo sotoꞌ sotoꞌ ogo eveneꞌ mukiꞌ lo-ngemeline lo nimiselineꞌ nenako naza nene numuno ebeꞌ mala malasi vo aꞌmine gono nene daloniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aza neꞌmine lo Zuda veti misubouꞌ monoꞌ numuno mininguꞌ mininguꞌ nene dizo monoꞌ lo-ngeme ngemeꞌ oꞌmo mono minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Idoꞌ gamene ma Izesuꞌ aza nGalilaia noso ohuno neꞌmi gulive gohi ma nGenesalete neꞌmi gahevela ote mino monoꞌ nolo-ngimivo aꞌmine Oꞌmosoꞌmi gamazi lineꞌ nene gililisa eveneꞌ vaiꞌ nubo nubo igi Izesuꞌnisi lisikelizaniꞌ o vivo ");
INSERT INTO aso_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","aza ningineꞌ nene noso gahevela sipi sitaꞌ ma nizasivo ningineꞌ. Ningineꞌ nene alahaꞌ daaꞌ ave nete aꞌmine sipiutiꞌ nene limisa alahaꞌ daaꞌ aniꞌ golalezeꞌine nene nosoꞌ izi nizavo aꞌmine sipi sitaꞌ gahevela haza minasineꞌ nene ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aꞌmine sipi sitakutiꞌ hamoꞌ ma Simoniꞌ sipi mininguꞌ nene dizo Simoniꞌni tiꞌ lo lo-imineꞌ: Sipi mene ngomo ma ehusoꞌ ogo hulo nosola ozo. Neꞌmine lavo Simoniꞌ aza sipi nene ngomo ma ehusoꞌ ogo hulo nosola ogavo Izesuꞌ aza aꞌminguꞌ mitoꞌ mino eveneꞌ mukiꞌ nene monoꞌ apize ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Idoꞌ neꞌmino gamazi lo-ngemo osuꞌ lo Simoniꞌni tiꞌ lo lo-imineꞌ: Sipi mene do vo noso ohuno naba moladaa hulozo. Hulanivo lingine alahaꞌ dalizangumuꞌ ve li alahaꞌ daaꞌ aniꞌ golalezetine nene di huli nosouꞌ ilo. ");
INSERT INTO aso_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Neꞌmine lavo Simoniꞌ tiꞌ lo lo-imineꞌ: Guvekasi ve, laza idise holukaꞌ nene alahaꞌ daaꞌ uneꞌ golalezeꞌ nene hulokaꞌ hulokaꞌ oꞌmo monevoꞌ monevoꞌ uneꞌza alahaꞌ hamokisi ma damuneꞌ nenako ha geiꞌ laningumuꞌ golalezeꞌ nene gohi hulolosuve. ");
INSERT INTO aso_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Neꞌmine lavo golalezeꞌine nene huli nosouꞌ ikevo alahaꞌ nene vaiꞌ goloso likevo golalezeꞌine nene hukotiꞌ hukotiꞌ ogo minivo ");
INSERT INTO aso_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","eveneꞌ masi geleleheꞌ ilizaniꞌ ogavo engikisi makaꞌ gono daaꞌ ave sipi mauꞌ minaniꞌ nene igi hize eleꞌ i-lidavo geleleheꞌ olone li aꞌine ngumungumuꞌ izaniꞌ. Neꞌmine ikevo ingine igi golalezeꞌine nene makatoꞌ geleleheꞌ igi alahaꞌ nene sipiuꞌ di tululu likevo sipi sitaꞌ nene vaiꞌ lo geni goloso ogavo sipi sitaꞌ nene nosouꞌ limilisa asineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Neꞌmine ogavo Simoni Petoloꞌ aza ningo Izesuꞌ gizenela obuvolo hizo gubiꞌ ize emo tiꞌ lo lineꞌ: Guvekasi ve, naza lihime daaꞌ uve goloso nouvoniꞌ nenako gaza neniꞌ hulo-nedo vozo. ");
INSERT INTO aso_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Idoꞌ Simoni Petoloꞌ neꞌmine ineꞌ nene ingine alahaꞌ vaiꞌ goloso dangumuꞌ nene vono vavo nemuꞌ nene neꞌmine ineꞌ ve. Ee, idoꞌ alahaꞌ vaiꞌ goloso dangumuꞌ nene Simonikisi minave mukiꞌ nene voꞌine vavo ");
INSERT INTO aso_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ezesi gono makaꞌ daaꞌ asive Zebedaioꞌ gipele Zakoboki Zohaneki nesi nene voꞌine vavo minasineꞌ ve. Neꞌmine igi nizavo Izesuꞌ aza Simoniꞌni nene tiꞌ lo lo-imineꞌ: Gaza gopo gaka gelo golise gelamozo. Idise melotiꞌ nene apiꞌ ogo alahaꞌ daaꞌ aineꞌ neꞌmino eveneꞌ do nenita olosane. ");
INSERT INTO aso_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Neꞌmine lavo ingine sipi di sevetoꞌ igisa initeꞌ mataꞌ mukiꞌ nene mudise mo hulisa Izesuꞌni eꞌmeti vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Idoꞌ Izesuꞌ aza numuno ebeꞌ ma minidoꞌ vo neivo aꞌmida ganadiseliꞌmo okoꞌno vovosi nomivo gize dave ma ogo Izesuꞌni ningo aza vo gizeneuꞌ lemo golo hizo ongo do lamineꞌ o-delingumuꞌ tiꞌ lo lineꞌ: Guvekasi ve, gaza do lamineꞌ o-nedelineꞌ amuzokasi naineꞌ nene naza mo gele mino do lamineꞌ o-nedeline lo gele nouve. Gaza do lamineꞌ o-nedelesa gele nabe. ");
INSERT INTO aso_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Neꞌmine lavo Izesuꞌ aza ganadise gizi dave i-ngidisaꞌmaniꞌ initeꞌ o-do ana hulo molo okoꞌnoloꞌ nohito tiꞌ lo lo-imineꞌ: Naza do lamineꞌ o-gedelesa gele nouve. Nemuꞌ gaza lamineꞌ ozo. Neꞌmine lavo ganadise neꞌmo liteꞌ lo okoꞌnolotiꞌ hulo-do vavo lamineꞌ gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Idoꞌ Izesuꞌ do lamineꞌ o-dingumuꞌ eveneꞌ hamokisi mo veteteꞌ ogo lo-ngemamilive lo lo huko-do tiꞌ lo lo-imineꞌ: Evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive neꞌmo ganadise okongalotiꞌ hulo-gedo vineꞌ nene ningo lo sotoꞌ ogavo gaza lamineꞌ aineꞌ nemuꞌ nene evenelite ningi gililizangumuꞌ ve lo neꞌmine ozo: Ganadise gizi dave ingine lamineꞌ igi ma ize initeꞌ neꞌmine neꞌmine Oꞌmoso imilisave lo Moseꞌ lo huko lidoꞌ nene eꞌmeto evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nene initeꞌ ma Oꞌmoso olokuꞌ gize emelingumuꞌ nene do vo emezo. ");
INSERT INTO aso_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Neꞌmine lo lineꞌza Izesuꞌnimuꞌ gamazi nene gohi buu naba lo mone osuꞌ lavo eveneꞌ vaiꞌ nene gili eiꞌ gamazi gelelone li eveneꞌ mukiꞌ nene initeꞌ gizi di minavesi nene do lamineꞌ o-ledelive li Izesuꞌ neida igi di geseꞌ igaꞌ aniꞌza ");
INSERT INTO aso_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","aza nene haza ebeꞌ eveneꞌ minamada vo Oꞌmosola lolosa vaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Neꞌmino minaaꞌ ineꞌ gameneuꞌ nene gamene ma Izesuꞌ aza gamazi lo-ngemo neivo Halisaioꞌ monoꞌ gilaaꞌ avesi Oꞌmosoꞌmi louꞌ gamazi apizi ngimaaꞌ avesi nGalilaia misubouꞌ numuno ebeꞌ ngomo ngomo mineꞌmo moningutikisi Zelusalemi numuno ebekutikisi Zudaia misubo lingelatikisi ave nene aꞌmida di nubo igi nizavo Izesuꞌ eveneꞌ ma do lamineꞌ o-ngedavo Izesuda nene Guvelesi veꞌmi amuzo neꞌmo nene eveneꞌ do lamineꞌ o-ngedelingumuꞌ amuzo molo minineꞌ nene mo ninganiꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Neꞌmine ogo neivo eveneꞌ amuzolo hele vivo gebili ma ngakakuꞌ zaloꞌ mili di igi Izesuꞌ neida di dizi huli-dilisa aniꞌza ");
INSERT INTO aso_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","eveneꞌ nete gikiꞌ igi aka hizi tilikevo ingine numuno nubitoꞌ di dizi mini nubikuꞌ ngoloꞌ li ngakakuꞌ neivo huli-dikevo eveneliti vovoꞌninguꞌ Izesuꞌ velela limineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lemavo za gohovo mili di ave ingine gebili ma ha do lamineꞌ o-deleseive li gili eleꞌvoleꞌ aniꞌ nene Izesuꞌ aza mo ningo gelo aꞌmine amuzolo hele geseꞌ o vive nene tiꞌ lo lo-imineꞌ: Ve melo, gaza lihimeka nene mo hulo-gedekuve. ");
INSERT INTO aso_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Neꞌmine lavo Halisaioꞌ monoꞌ gilaaꞌ avesi Oꞌmosoꞌmi louꞌ apizi ngimaaꞌ avesi ingine aꞌmine lineꞌ gamazimuꞌ luꞌninguꞌ tiꞌ li gilaniꞌ: Eveneꞌ hamolitesi lihimete huli-lidilizadoꞌ lisiheꞌ amavo asi Oꞌmoso eikovoꞌ nene lihimete hulaaꞌ ive neineꞌ nenako ve meve nene Oꞌmoso nevoba gamazi neꞌmine lo Oꞌmoso ivileꞌ ogaꞌ gamazi nolineꞌ nene edamive. ");
INSERT INTO aso_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Neꞌmine li luꞌninguꞌ nigilavo Izesuꞌ aza ningo gelo tiꞌ lo lo-ngimineꞌ: Lingine lutinguꞌ neꞌmine gatine nanimuꞌ nigilave. ");
INSERT INTO aso_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lingine nenikumuꞌ nene sozavoꞌ laaꞌ neive li gilaaꞌ nahe. Naza amuzolo hele vive nemuꞌ lihimeka mo hulo-gedekuve luvoniꞌ nene soza lolohe lamineꞌ lolohe ma gilamilisave lo lapa nomivo noluvoniꞌza sozaloꞌ ve minuvodini amuzolo hele vivemuꞌ mene naza oto vozo nolo-duvo oto vamivo soza luvoniꞌ nene sotoꞌ ogavo novozo helalove lo gelo oto vozo lo ma lamuvodine. Olo. ");
INSERT INTO aso_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne neiha Oꞌmosolatiꞌ ve gihile naza misubouko lengiꞌ lihimetine apase-lengedaaꞌ amuzo do nouve luvoniꞌ nene soza lamo mo laminetoꞌ noluvoniꞌ nene ningi gililizangumuꞌ naza idise ogo molo oloniꞌ initeꞌ nene ningilo. Neꞌmine lo amuzolo helavo minive nemuꞌ tiꞌ lo lineꞌ: Naza tiꞌ lo nolo-gimuve: Gaza oto ongo minaineꞌ initeka nene do geho numungala vozo. ");
INSERT INTO aso_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lavo amuzolo helavo minive aza nene eveneꞌ mukiliti veꞌnidoꞌ nene liteꞌ lo oto ongo minineꞌ initeꞌve nene do geho Oꞌmoso do naba o-do opoꞌni loꞌmo loꞌmo numuꞌvela vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Neꞌmine neivo eveneꞌ ingine ningi upuhoꞌ igi voꞌine vavo Oꞌmoso opoꞌni li di naba i-di ngehelele goloso izavo idise nene atoliꞌmine initeꞌ goloso ningekune li laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Idoꞌ nelotiꞌ nene Izesuꞌ aza heta lemo vo takisi moni daaꞌ ive gulive Leviꞌ nene takisi moni daaꞌ ineꞌ opisiꞌveuꞌ gono do neivo ningo tiꞌ lo lo-imineꞌ: Gaza neꞌmeto ano. ");
INSERT INTO aso_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Neꞌmine lavo aza initeꞌ mukiꞌ nene hulo oto eꞌmeto vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Makaꞌ Leviꞌ numuꞌveuꞌ vii Leviꞌ aza Izesuꞌni nosoꞌ niteꞌ naba gize vataꞌ o-divo eveneꞌ mukiꞌ takisiloꞌ vesi idoꞌ eveneꞌ atoꞌ masi nene makaꞌ mini nosoꞌ niteꞌ ni minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ni nizavo Halisaioꞌ monoꞌ gilaaꞌ avesi monoꞌ gamazi apizi ngimaaꞌ avesi ingine Izesuꞌ izipahala zuhomuꞌ nene ngemenga li tiꞌ li laniꞌ: Lingine takisi moni daaꞌ ave golososi idoꞌ lihime daaꞌ ave lingesi nene nosoꞌ niteꞌ makaꞌ namilizanako nanimuꞌ ninave. ");
INSERT INTO aso_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Luso ve aza haza lamineꞌ minave do lamineꞌ o-ngedelesa osaꞌmiha initeꞌ gizi davemukovoꞌ nene ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aꞌmineꞌmine ogo naza nene eveneꞌ lisiheꞌ i minavemuꞌ amuvoniꞌza eveneꞌ lihimeꞌinesi nizave nene luꞌine di velepeꞌ izilizave lo lo-ngemelesa uvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Idoꞌ Izesuꞌ neꞌmine lo lavo ingine tiꞌ li li-imaniꞌ: Zohaneꞌ izipahala zuho ingine monokumuꞌ ve li nosoꞌ niteꞌ malise ikaꞌ ikaꞌ igi mini Oꞌmosola likaꞌ likaꞌ navo Halisaioꞌ monoꞌ laaꞌ aveti izipahaꞌine zuho nesi nene aꞌmineꞌmine igaꞌ naniꞌza geiꞌ izipaha zuho ingine nene aꞌmineꞌmine igi nosoꞌ niteꞌ malise ilizadoꞌ o neineꞌ nenako neꞌmine ami nosoꞌ niteꞌ gopo naakovoꞌ igaꞌ nako nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Neꞌmine likevo Izesuꞌ aza aneza gamazi ma tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo eze veneꞌ huki imiliza gameneuꞌ olize izo eze zuho nosoꞌ niteꞌ gize vataꞌ ogo molo-ngedavo aza aꞌminguꞌ neivo eze zuhomuꞌ nene lingine nosoꞌ niteꞌ malise ilizave lilizadoꞌ nene ha gili lingimilizadoꞌ o neihe. Ne nomive. Aꞌmineꞌmine igi neze izipahaꞌne zuho nene naza nouvodoꞌ nene nosoꞌ niteꞌ malise amilisave. ");
INSERT INTO aso_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Idise neꞌmine amilisaniꞌza neꞌmine ilizaniꞌ gamene ma aloseive. Engiꞌ vovoꞌningutiꞌ biluvalite neze neleꞌmizi di vilizaniꞌ gamene alitavo aꞌmine gameneuꞌ nene ingine mulumo gili-nidisa nosoꞌ niteꞌ malise ilisave. ");
INSERT INTO aso_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Neꞌmine lo lo-ngemo imineꞌ molo aneza gamazi ma tiꞌ lo lo-ngimineꞌ: Eveneꞌ malite saketi gosohototiꞌ lavolavo ngomo ma huki saketi litehe hukidoꞌ nene ma mili ongotisaꞌmave. Neꞌmine igi ma ongotilizaniꞌ nene saketi gosohoꞌ nene huki di goloso ilisave. Idoꞌ lavolavo gosohoꞌ saketi liteheloꞌ minelineꞌ nene atokutiꞌ gelo edamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Idoꞌ aꞌmineꞌmine igi lingine vaini noso gosohoꞌ neꞌmo memeꞌ ize losuvodunuꞌ liliꞌ aniꞌ gomise nene izo pouꞌ lavo vaini noso lepo vo gomiseꞌvesi nene goloso ogalive li vaini noso gosohoꞌ gituhoꞌ galakalaꞌ neidiꞌmo nene lulu izavo gomise liteheliꞌmo ngipu lo hukilineꞌ o mininguꞌ nene ma ohizi milisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vaini noso gosohoꞌ gituhoꞌ galakalaꞌ neivo nene memeꞌ ize losuvo gosohotunuꞌ liliꞌ aniꞌ gomise gosohokuꞌ nene ohizesoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Idoꞌ gozopoꞌ vaini nosovoꞌ naaꞌ ave nete gozopoꞌ niteꞌ mene lamineꞌ ve li vaini noso gosohoꞌ ma nalisa gilamilisave. Neꞌmine lineꞌ nene aza monoꞌ lo-ngemaaꞌ ineꞌ nene gosohoꞌ nenako izipahala zuho igi mili ilizaniꞌ monovo neꞌmo aꞌmine Zuda veti monovo litehe maloꞌ vo damivo ingine gozopoꞌ monovoꞌine mamuꞌ laniteꞌ gili aꞌmine monovo gosohoꞌ nene di tiꞌ amilizaniꞌ o miningumuꞌ lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Holiseꞌ gameneuꞌ Izesuꞌ aza izipahala zuhosi viti minguꞌ nivavo izipahala zuho nete viti godololatiꞌ gihile nene ili aꞌninguꞌ hupuꞌ izi niꞌmi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Neꞌmine aniꞌza Halisaioꞌ monoꞌ gilaaꞌ ave malite tiꞌ li laniꞌ: Lingine louꞌ gamaziuꞌ nene holiseꞌ gameneuꞌ gono damilo li nizaniꞌ mako neꞌmine nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Idoꞌ Zuda ve leliꞌ avotemoti guveꞌinesi ve naba Davidiꞌ aza ezesi monave gaꞌna hili minangumuꞌ nene louꞌ gamaziꞌmo initeꞌ mamuꞌ namaaꞌ ve lo hize tilavo tile minineꞌ aka nene goloso amivo ha do ngoloꞌ loo Davidiꞌ ineꞌ initeꞌ nene monoꞌ godolouꞌ gati gilahe gilamahe. ");
INSERT INTO aso_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aza neꞌmine ineꞌ ve. Oꞌmosoꞌmi monoꞌ numunguꞌ dizavo evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive neꞌmo Oꞌmosoꞌmi veleloꞌ milaniꞌ beleti nene eveneꞌ gohi malitesi namilizave lo asi evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ avetevoꞌ ha nalisave lo louꞌ gamaziꞌmo lavo minineꞌ beleti nene Davidiꞌni do emavo idoꞌ ezesi makaꞌ monave ngemavo mukitoꞌ ezesi naniꞌ. Nemuꞌ nene goloso amivo neniꞌ izipahaꞌne zuho nene aꞌmineꞌmine igi viti gihile mene ha nalisave. ");
INSERT INTO aso_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Oꞌmosolatiꞌ ve gihile naza nene holiseliꞌmi meleho mino aꞌmine holisekuꞌ iliza initekumuꞌ idoꞌ amiliza initekumuꞌ laaꞌ uve nene nenikovoꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Idoꞌ holiseꞌ gamene mauꞌ Izesuꞌ aza monoꞌ numunguꞌ dizo monoꞌ apize ngemo neivo aꞌminguꞌ nene ve ma ana zamela goloso ogo gilizevo o vive ma minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Neivo louꞌ gamazi apizi ngimaaꞌ avesi Halisaioꞌ monoꞌ gilaaꞌ avesi ingine Izesuꞌ aza aꞌmine ve nene idise do lamineꞌ o-delineꞌ nene holisekumuꞌ laniꞌ louꞌ gamazi ma nene avutoꞌ oloseinako nemuꞌ goniꞌ o-deloneꞌ aka ma sotoꞌ ilihe li vonuꞌ bili ningi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Neꞌmine igi nizavo Izesuꞌ aza ingine gilaniꞌ initeꞌ nene mo ningo gelo ana goloso o vive nene tiꞌ lo lo-imineꞌ: Gaza olusoꞌ mene ogo otezo. Neꞌmine lavo aza oto ogo aꞌmidoꞌ ote minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ote neivo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Naza tiꞌ lo longoꞌ noo-lingiduve. Leze louꞌ gamazite neꞌmo nadive lo neive. Holiseꞌ gameneuꞌ nene monovo lamineꞌ ilo lo neihe goloso ilo lo neive. Adoꞌ eveneꞌ di lamineꞌ i-ngidilo lo neihe di goloso i-ngidilo lo neive. ");
INSERT INTO aso_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Lo lo-ngemo eveneꞌ mukiꞌ vonuꞌ ngebele osuꞌ lo ana goloso o vive ma nene tiꞌ lo lo-imineꞌ: Anga do pehe lozo. Lavo do pehe lavo ana nene gohi lamineꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Neꞌmine ineꞌza louꞌ gamazi apizi ngimaaꞌ avesi Halisaioꞌ monoꞌ gilaaꞌ avesi ingine Izesuꞌnimuꞌ ngizeboloꞌ goloso molavo nemuꞌ li voleloꞌ meloꞌ igi nadiꞌ o-delone li laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aꞌmine gameneuꞌ nene Izesuꞌ aza Oꞌmosola lolosa golola dizo vineꞌ. Dizo vo Oꞌmosola lovoꞌ lovoꞌ ogo neivo litiꞌmuso izo goꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Idoꞌ goꞌ lavo nedengaꞌ nene eze eꞌmeti monaaꞌ ave izipahala zuho mukiꞌ nene asi lo-ngedavo ikevo engikutiꞌ eveneꞌ tuvelu (12) ngeleꞌmize kegeso ezeloꞌ medeli mini gamazi lilizave aposolo ve lo ngeleꞌmize molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ingine guliveꞌine nene neꞌmino minineꞌ: Simoniꞌ nene guliveꞌve gohi Petoloꞌ ve lo molaniꞌ idoꞌ Petoloꞌ nakunolo Adeleaꞌ ve idoꞌ Zakoboꞌ ve Zohaneꞌ ve idoꞌ Hilipoꞌ ve Batolomaioꞌ ve ");
INSERT INTO aso_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataioꞌ ve Tomasiꞌ ve idoꞌ Alahaioꞌ gipele Zakoboꞌ abalaho ve idoꞌ Loma ve leliꞌ misuboutiꞌ ngimisele hulolone li amuzo milaaꞌ aveutiꞌ minive lave Simoniꞌ gohi ma neeve ");
INSERT INTO aso_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","idoꞌ Zakoboꞌ gohi maliꞌmi gipele Zudaꞌ ve idoꞌ alingeꞌ Izesuꞌni do sotoꞌ o-dive adoꞌ Keliotoꞌ numuno ebetotiꞌ ve Zudaꞌ engiꞌ neve nene minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Idoꞌ Izesuꞌ aza aꞌmine eveneꞌ tuvelu (12) inginesi gololatiꞌ limi ikevo izipahala zuho linge vaikisi idoꞌ eveneꞌ mukiꞌ goloso eze gamaziꞌve gililisa avesi idoꞌ initeꞌ gizi dave do lamineꞌ o-ledelive li avesi Zelusalemi numuno ebetatikisi idoꞌ Zudaia misubo linge mukitatikisi idoꞌ Tilo idoꞌ Sidoni numuno ebeꞌ minasineꞌ misubo guvo noso gahevelatikisi igi di geseꞌ ikevo Izesuꞌ aza aꞌmida nene misubo geledoꞌ lemo ogo ote minineꞌ ve. Neivo eveneꞌ luꞌninguꞌ sikalahuꞌ golososi minave ezela ikevo do lamineꞌ o-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Idoꞌ Izesudatiꞌ amuzo neꞌmo eveneꞌ do lamineꞌ o-ngidineꞌ nemuꞌ nene eveneꞌ mukiꞌ ingine eiꞌ okoꞌnoloꞌ do gelosa lamineꞌ olosune li okoꞌnoloꞌ di gililisa aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","26","Neꞌmine ikevo Izesuꞌ aza izipahala zuhola vonuꞌ nongebelo tiꞌ lo lineꞌ: Initetine nomivo gohoꞌ gahaliꞌ aleve lingine nene Oꞌmosoꞌmo gizebo o-ledelinguꞌ vi hilalizaniꞌ o neineꞌ nenako lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ longolize izilizaniꞌ o neive. Neꞌmine igi nizaniꞌza initetine vaiꞌ lo neivo heneni ve nizave lingine longolize izi initeꞌ mukiꞌ mo dikeve. Alingeꞌ gohi ma damilisaze. Nemuꞌ nene agae, ehetine ve. Idoꞌ idise gaꞌna hili minaaꞌ nave lingine nene alingeꞌ Oꞌmosoꞌmo nosoꞌ nitetine vaiꞌ lengemelineꞌ nenako lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ longolize izilizaniꞌ o neive. Neꞌmine igi nizaniꞌza idise gatudinevoꞌ o minivo minaaꞌ nave lingine alingeꞌ gaꞌna hilivoꞌ minilizaniꞌ o neineꞌ nenaze. Nemuꞌ nene agae, ehetine ve. Idoꞌ minevoꞌ alevotine goloso o vivo idise agae agae li ive namavoꞌ igi minaaꞌ nave lingine alingeꞌ Oꞌmosoꞌmo minevoꞌ alevotine do lamineꞌ ogavo lamineꞌ gili gize zohiꞌ igi minilizaniꞌ o neineꞌ nenako lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ longolize izilizaniꞌ o neive. Neꞌmine igi nizaniꞌza idise gize zohiꞌ igi minaaꞌ nave lingine alingeꞌ mulumo alumo gili ive nama igi minilizaniꞌ o neineꞌ nenaze. Nemuꞌ agae, ehetine ve. Idoꞌ Oꞌmosolatiꞌ ve gihile neniꞌ neꞌmeti minangumuꞌ ve li eveneꞌ lengikumuꞌ goseleꞌ goloso ngebelavo vasa izi-lingidi gamazi goloso li lengelemi gulivetine nesi goloso neineꞌ nenako mo gohi gelamolone li gulivetine di hulilizaniꞌ nene engiꞌ avoꞌninge nete gozopoꞌ polohete minave i-ngidaniꞌ initeꞌ goloso neꞌmine i-lingidilizaniꞌ nenako lingine poloheteliti gonoloꞌ nene medeli minikevo Oꞌmosoꞌmo menitine naba Okulumokuko molo-lengedeleseize. Nemuꞌ nene aꞌmine neꞌmine manaꞌmine i-lingidilizaniꞌ gameneuꞌ nene longolize goloso izi ganine hizi gizedine adine izisa minilo. Ee, neꞌmine i-lingidikevo ma lamineꞌ iliza akaloꞌ mini mili nizaze. Nemuꞌ longolize izilizaniꞌ o neive. Neꞌmine ilizaniꞌ o neineꞌza eveneꞌ mukiꞌ nete longopoꞌni li di naba nii-lingidavo ma avoꞌninge nete soza polohete goloso gomuꞌ minave di naba i-ngidaaꞌ aniꞌ neꞌmine i-lingidilizaniꞌ nenako lingine aꞌmine soza polohete minaveloꞌ medeli minilizaniꞌ o neineꞌ nenako agae, ehetine ve. ");
INSERT INTO aso_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Neꞌmino neineꞌza neze gamaziꞌne nigilave nene naza tiꞌ lo nolo-lingimuve: Biluvatine nene lutine ngimi lengikumuꞌ goseleꞌ ngebelaaꞌ neive nene nasahiliꞌ i-ngidi di lamineꞌ i-ngidilo. ");
INSERT INTO aso_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Idoꞌ initeliꞌmo ma lingibilivoo li usiꞌ izi-lingidaaꞌ naniꞌ aleve nene Oꞌmosoꞌmo noꞌnohoꞌ ize-lingidivoo li-lingimilo. Idoꞌ goboni mili-lingidilizavemuꞌ nene do lamineꞌ o-ngedelive li Oꞌmosola li minilo. ");
INSERT INTO aso_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Idoꞌ ve maliꞌmo gatidoꞌ noizivo ma nene helalasi izelize mine velepeꞌ izilo. Idoꞌ ve maliꞌmo saketika nene dalove nolivo ma nene siotika ngomo lulouꞌ nesi nene do aꞌmanapa amozo. ");
INSERT INTO aso_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Idoꞌ lengitatiꞌ initeꞌ ma dalone li longoꞌ navo ma nene ha ngimilo. Idoꞌ lengitatiꞌ initeꞌ ma ipeꞌ igi di vikevo ma nene gohi di tiꞌni limilo li lamilo. ");
INSERT INTO aso_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Idoꞌ lingine evenelite lelita neꞌmine manaꞌmine i-lidilizave li gili ma nene engitasi aꞌmineꞌmine i-ngidilo. ");
INSERT INTO aso_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Idoꞌ eveneꞌ ma luꞌine lengiꞌ lingimaaꞌ avevoꞌ lutine ngimilizaniꞌ nene monoꞌ gilamave lihime daaꞌ ave netesi nene eveneꞌ luꞌine engita ngimave nene luꞌine ngimaaꞌ naniꞌ nenako lingine nene eveneꞌ ma ngivileꞌ igi monovo lamineꞌ ma damave. Oꞌmosoꞌmo eveneꞌ linge ngopoꞌni lilineꞌ votigile ivileꞌ ivosa lengiꞌ longopoꞌni goloso lilidoꞌ minamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Idoꞌ eveneꞌ ma lengiꞌ lengeleꞌmize lamineꞌ avevoꞌ ngeleꞌmize lamineꞌ ilizaniꞌ nene monoꞌ gilamave lihime daaꞌ ave netesi nene aꞌmineꞌmine igi ingine ngeleꞌmize lamineꞌ ave nene ngeleꞌmize lamineꞌ igaꞌ naniꞌ nenako lingine eveneꞌ ma ngivileꞌ igi monovo lamineꞌ ma damaze. Oꞌmosoꞌmo ve mamuꞌ ngopoꞌni laaꞌ neineꞌ votigile ivileꞌ ivosa lengiꞌ longopoꞌni goloso lilidoꞌ minaniꞌ nehe. Oꞌove. ");
INSERT INTO aso_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Idoꞌ lingine nene eveneꞌ ma initeꞌ ngemekunivo ingine alingeꞌ aꞌmine initeꞌ gohi limilizadoꞌ ve li gili mini ngimilizaniꞌ nene monoꞌ gilamave lihime daaꞌ ave netesi nene aꞌmineꞌmine igi aꞌmine initeꞌ gohi dalosune li aꞌmine initeꞌ ngimaaꞌ naniꞌ nenako lingine nene eveneꞌ ma ngivileꞌ igi monovo lamineꞌ ma damaze. Oꞌmosoꞌmo eveneꞌ linge ngopoꞌni lilineꞌ votigile ivileꞌ ivosa lengiꞌ longopoꞌni goloso lilidoꞌ minaniꞌ nehe. Oꞌove. ");
INSERT INTO aso_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ne neiha lingine lengiꞌ biluvatine nene lutine ngimilo. Idoꞌ ngeleꞌmize lamineꞌ i-ngidilo. Idoꞌ eveneꞌ initeꞌ ngimilizaniꞌ nene alingeꞌ gohi dalone lami haza gidini ngimilo. Neꞌmine igi haza ngimilizaniꞌ nene Oꞌmosoꞌmo menitine naba molo-lengedeleseive. Atoliꞌmine ogo dize minive Oꞌmoso aza eveneꞌ goloso nene nasahiliꞌ o-ngedaaꞌ neineꞌ nemuꞌ gilavo haza niteꞌ loloꞌ ogavo ezemuꞌ opoꞌni lisaꞌmave nesi haza gopo nasahiliꞌ o-ngedaaꞌ neineꞌ nenako lingine nene eveneꞌ initeꞌ ma haza gidini ngimilizaniꞌ nene aꞌmine atoliꞌmine ogo dizo minive neꞌmine gili vaniꞌ mini eiꞌ izipahala gehepeve minilisave. ");
INSERT INTO aso_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nemuꞌ nene lingine metibo neꞌmo eveneꞌ mukiꞌ mulumotine ningo hize eleꞌ o-lengedaaꞌ neineꞌ neꞌmine igi linginesi eveneꞌ mulumoꞌine ningi hize eleꞌ i-ngidi minilo. ");
INSERT INTO aso_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Idoꞌ neꞌmine igi Oꞌmosoꞌmo lengiꞌ monovotinemuꞌ dovoꞌ ledevoꞌ ogo izeꞌ molo lamilingisi lingine eveneꞌ maliti monovomuꞌ diviꞌ lediviꞌ igi izeꞌ mili lamilo. Idoꞌ Oꞌmosoꞌmo lingine monovo goloso dikeve lo lengemenga lamilingisi lingine eveneꞌ mamuꞌ monovo goloso dikeve li ngemenga liꞌmi monamilo. Idoꞌ Oꞌmosoꞌmo lengiꞌ lihimetine nene hulo-lengedelingisi lingine eveneꞌ lihime di-lingidaveti lihimeꞌine nene huli-ngidilo. ");
INSERT INTO aso_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Idoꞌ Oꞌmoso neꞌmo initeꞌ mataꞌ lengemelingisi lingine nene eveneꞌ initeꞌ mataꞌ ngimilo. Aꞌmine Oꞌmosoꞌmo lengemelineꞌ initeꞌ nene vauve goloso elosa lengiꞌ di miniliza votigile nesi ivileꞌ ogosa lengemeleseive. Aꞌmine initeꞌ lengemelineꞌ nene lingine eveneꞌ ngimiliza votigilelokovoꞌ lengemeleseinako nemuꞌ lingine aꞌmineꞌmine igi initeꞌ vauve ili ngimi minilo. ");
INSERT INTO aso_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Neꞌmine lo Izesuꞌ aza aneza gamazi tiꞌ losasi ma imineꞌ molo lo-ngimineꞌ ve: Vele likive maliꞌmo vele likive atoꞌ ma aka elebizo analoꞌ do do ha vilihe. Ne nomive. Mo sitatoꞌ vi galeseuꞌ limilisasive. ");
INSERT INTO aso_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Idoꞌ sukulu izipe malite tisaꞌine nene ivileꞌ igi ma minamilisaniꞌza mukitoꞌ nene initeꞌ mukikumuꞌ apizi ngimi osuꞌ likevo initeꞌ mukikumuꞌ gili osuꞌ lavetevoꞌ nene tisaꞌine neꞌmine liliꞌ ilisave. (Nemuꞌ nene lingine eveneꞌ nene aka lamineꞌ ngelebizelone li ma veꞌine likive neꞌmine minami lo-lengemaaꞌ nouvoniꞌ gamazi mukiꞌ nene gili lamineꞌ igisavoꞌ apizi ngimilizadoꞌ minilisave.) ");
INSERT INTO aso_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Idoꞌ gaza veka gihileuꞌ za lana naba vo neineꞌ nemuꞌ nene ningo gelamo ve maliꞌmi vele gihileuꞌ initeꞌ ngomo lasolo vo neineꞌ nemuꞌ nene nanimuꞌ ningaaꞌ nane. ");
INSERT INTO aso_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Idoꞌ geꞌmo vekauꞌ nene za lana naba vo neivosa gaza ve mamuꞌ ve melo, vekauꞌ initeꞌ ngomo vo neineꞌ nene do hulo-gedelove lo-delinidoꞌ o neihe. Ne nomive. Soza sunolavoꞌ monanive gaza za lana vekauꞌ vo neineꞌ nene gomuꞌ do hulokosavoꞌ nene ve maliꞌmi veleuꞌ initeꞌ ngomo lasolo vo neineꞌ nene ninge guno o minosa do hulo-delineꞌ o neive. Ee, monovo goloso naba daaꞌ naineꞌ nene gomuꞌ hulosavoꞌ maliꞌmo monovo goloso ngomo ma do nolineꞌ nene do lisiheꞌ o-delesane. ");
INSERT INTO aso_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","Gohuno gihile nene uhoni zalotiꞌ ngelo ma elamolosane. Idoꞌ vaini gihile nene gasavasi nalaꞌ golosolotiꞌ nene ngelo ma elamolosune. Nemuꞌ za mukiliti monovo nene gihileꞌine izelineꞌ neꞌmo do sotoꞌ ogavo ningelonidoꞌ o neineꞌ nenako nemuꞌ nene za ma lamineꞌ nolineꞌ neꞌmo nene gihileꞌve goloso ma izamoloseive. Idoꞌ za ma goloso nolineꞌ neꞌmo nene gihileꞌve lamineꞌ ma izamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Idoꞌ eveneꞌ aꞌmineꞌmine igi nizave. Eveneꞌ luꞌninguꞌ goꞌzikaniꞌ initeꞌ nene veꞌningutiꞌ li hulaaꞌ nanako eveneꞌ lamineꞌ neꞌmi lulouꞌ nene gamazi lamineliꞌmo vaiꞌ lo neinako neꞌmo nene monovo lamineꞌ do sotoꞌ ogaꞌ neive. Idoꞌ eveneꞌ goloso neꞌmi lulouꞌ nene gamazi goloso neꞌmo nene vaiꞌ lo neinako neꞌmo nene monovo goloso do sotoꞌ ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Idoꞌ eveneꞌ nene guveꞌinesi veti gamazi gili dalizadokovoꞌ minaaꞌ naniꞌ nenako lingine nenikumuꞌ Guvetesi ve, Guvetesi ve, li-nidi minaaꞌ niigisa neze gamaziꞌne gili hulaaꞌ naniꞌ nene nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Idoꞌ eveneꞌ ma ingine nenita igi gamaziꞌne gili di luvodoꞌ luvodoꞌ igi mili eꞌmetilizaniꞌ nene ingine naniꞌmine ve nizahe nemuꞌ lo-lengemelove: ");
INSERT INTO aso_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ve maliꞌmo numuno gizelesa posi galese haꞌna elo homi gehedoꞌ ogo posi nene gehedoꞌ hize giliꞌ loo numuno gizavo goline izo noso naba velo numudoꞌ nene bilineꞌza numuno nene do lamineꞌ ogo gehedoꞌ gizineꞌ nenako neꞌmo numuno nene lemo ongamo amuzo molo haza minineꞌ ve. Idoꞌ ingine neniꞌ gamazi luvodoꞌ luvodoꞌ igi mili eꞌmetilizave nene aꞌmine numuno gizive neꞌmine minikevo initeꞌ igi mili minilizaniꞌ nene lemo ongamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ne neiha eveneꞌ ma ingine neze gamaziꞌne gili gili huli luvodoꞌ luvodoꞌ eꞌmetamilizaniꞌ nene numuno gizive gohi ma neꞌmine minilisave. Aꞌmine ve aza numuno gizelesa posi galese elo hulo homiuꞌ ogo posi nene gehedoꞌ hize giliꞌ lamo galese avileloꞌ eleko gizavo goline izo noso naba velo numudoꞌ ogo belavo numuno nene eii, do goloso ogosa izevo etevoꞌ ogo lemo onganiꞌ ve. Idoꞌ aꞌmineꞌmine ogo neniꞌ gamaziꞌne gili huli luvodoꞌ luvodoꞌ igi mili eꞌmetamilizavete igi mili minilizaniꞌ initeꞌ nene lemo ongaloseive. ");
INSERT INTO aso_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Izesuꞌ aza aꞌmine monoꞌ gamazi nene eveneꞌ aꞌmida minaniꞌ nene lo-ngemo osuꞌ lo Kahanaumi numuno ebekuꞌ vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aꞌmida nene Loma amiliti gizebo ve ma minineꞌ. Eze gelekeleꞌ izipeutiꞌ vonoloꞌ minive nene initeꞌ gize do helaaꞌ akaloꞌ vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Neꞌmine ogo neivo amiliti gizebo ve aza nene Izesuꞌ guvele gelo aza ogo gelekeleꞌ izipe do lamineꞌ o-delive li vi li-imilizave lo Zuda veti gizebo veꞌine linge ma ngimiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","nGimiselavo ingine Izesuda vi heteli aꞌmine gamazi li-imi amuzonga tiꞌ li li-imaniꞌ: Isaaꞌ neve. Loma amiloꞌ gizebo ve aza lulo nene leliꞌ Zuda ve lemaaꞌ neive. Idoꞌ monoꞌ numude nesi nene gizilizave lo moni huko hulavo gizune. Neꞌmine ogaꞌ neineꞌ nenako gaza eiꞌ lineꞌ initeꞌ nene ha o-delinidoꞌ lisiheꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Neꞌmine li li-imikevo Izesuꞌ aza inginesi makaꞌ vaniꞌ. Izesuꞌ aza olihe numudoꞌ vo hetelamo avita navo amiloꞌ gizebo ve aza gamazi tiꞌ lo loo eze zogo ve linge Izesuda ngimiselavo vaniꞌ: Guvekasi ve, naza eveneꞌ goloso nouvonako aꞌneꞌmineꞌmi numuꞌneuꞌ alinidoꞌ lisiheꞌ amaninako hotatiꞌ ogo mela alinidoꞌ gabusoka elalive. ");
INSERT INTO aso_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Idoꞌ naza geita vamuvoniꞌ nene naza heta atoꞌ ve goloso nouvonako nemuꞌ geita alodoꞌ lisiheꞌ amuve. Nemuꞌ nene gaza gamazivoꞌ lo lamineꞌ ozo lolosane. Lanivo neniꞌ gelekeleꞌ izipeꞌne nene lamineꞌ ilive lo gele nouve. ");
INSERT INTO aso_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Idoꞌ lamineꞌ ilive lo gele nouvoniꞌ nene naza eveneꞌ maliti gizeboloꞌ nouve. Idoꞌ neze gizeboloꞌ nesi nene ami ma nizave. Nemuꞌ nene engikutiꞌ ve mamuꞌ vozo lokuvo ha voloseive. Idoꞌ mamuꞌ ano loloniꞌ nene ha aloseive. Idoꞌ gelekeleꞌ izipeꞌne nene neꞌmine ozo loloniꞌ ha oloseive. Idoꞌ aꞌmineꞌmine ogo gaza lanivo siki initeꞌ neꞌmo geiꞌ gamazi nene ha gele do gelekeleꞌ izipeꞌne nene ha hulo-do voloseive losa gele nosa noluve. ");
INSERT INTO aso_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lavo Izesuꞌ aza gamazi lineꞌ nene gelo aizo lo gelo mine velepeꞌ izo eꞌmeti vave mukiꞌ nene tiꞌ lo lo-ngimineꞌ: Naza tiꞌ lo nolo-lingimuve. Oꞌmosomuꞌ gili eleꞌvoleꞌ igaꞌ ave gehepeve ve lave lengiꞌ Isilaeleꞌ aleve lengikutikisi nene heta atoꞌ ve meneꞌmo gele eleꞌvoleꞌ ineꞌ neꞌmini ve hamolitesi gili eleꞌvoleꞌ avo ma ningamuvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Neꞌmine lavo amiloꞌ gizebo veꞌmo ngimiselive ingine tineꞌ mili numuꞌvela vi ninganiꞌ nene gelekeleꞌ izipe aza lamineꞌ ogavo ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Neꞌmine ogavo nelotiꞌ gamene haꞌna vamivo Izesuꞌ aza numuno ebeꞌ ma gulive Nainila novivo izipahala zuhosi eveneꞌ mukikisi nene eꞌmetavo makatoꞌ vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Makaꞌ vo numuno ebeliꞌmi gateda nohetelivo veneꞌ getoꞌ ma minineꞌ neꞌmi gipele hamokovoꞌ minineꞌ nene helavo veneꞌ getoꞌ nene aꞌmine numuno ebekutiꞌ eveneꞌ vaiꞌ nene mulumo gili-di eꞌmeti minavo aꞌmine gonoso nene zaloꞌ mili numuno ebekutiꞌ galese izi-dilisa di heta aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Neꞌmine navo Guvelesi ve aza hiliveꞌmi izelehine nene ningo muluno hukavo aꞌmine veneꞌ nene tiꞌ lo lo-imineꞌ: Gaza ive nama amozo. ");
INSERT INTO aso_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Neꞌmine lo avitoꞌ vo aꞌmine hilive ongo minineꞌ initetoꞌ nene davo gonoso zaloꞌ milave nene aꞌmidoꞌ legeni oti minaniꞌ. Oti nizavo tiꞌ lo lineꞌ: Gosoꞌ ve, gaza gohi veka gizo oteline nolo-giduze. Otezo. ");
INSERT INTO aso_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lavo hilive aza oto mitoꞌ mino gamazi apiꞌ ogo nolivo aꞌmine hilive nene izelihida gohi do tiꞌno imineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Neꞌmine ogavo veneꞌ vemohoꞌ mukiꞌ nene ngehelele naba goloso izavo Oꞌmoso opoꞌni li tiꞌ li laniꞌ: Leliꞌ vovoteuꞌ nene polohete naba ma sotoꞌ ogave. Idoꞌ Oꞌmoso neꞌmo eze evenele mulumote ningo hize eleꞌ o-ledave. ");
INSERT INTO aso_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Likevo Izesuꞌ neꞌmine ineꞌ guvele neꞌmo Zudaia misubo mukikukisi idoꞌ Zudaia misubo gaheve gahevela misubo mukikuꞌ nesi nene buu lo mone osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Idoꞌ monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ izipahala zuho nete Izesuꞌ neꞌmine manaꞌmine monovo do sotoꞌ ogo minineꞌ nemuꞌ nene Zohaneꞌni li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Neꞌmine ikevo Zohaneꞌ aza izipahala zuho sitaꞌ vise lo-ngedo gamazi tiꞌ li longoꞌ i-dilisive lo Guvelesi vela ngeletineꞌ: Gaza nene Oꞌmosoꞌmo imiselavo aloseive li li-limave ma nene nabe idoꞌ ve gohi atoꞌ mamuꞌ gizebo oloneꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Neꞌmine lavo aꞌmine ve sitaꞌ ingine Izesuda vi heteli tiꞌ li li-imasineꞌ: Laza nene noso holo-ngedaaꞌ ive Zohaneꞌ tiꞌ lo losa leletavo nousive: Gaza nene Oꞌmosoꞌmo imiselavo aloseive li li-limave ma nene nabe idoꞌ ve gohi atoꞌ mamuꞌ gizebo oloneꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Neꞌmine likesivo aꞌmine minasineꞌ gameneuꞌ gehepeve nene aza initeꞌ ato atoꞌ gizi dave vaiꞌ do lamineꞌ o-ngedo eveneꞌ luꞌningutiꞌ sikalahuꞌ goloso ngelete hulo idoꞌ veꞌine likive mukiꞌ nene do lamineꞌ o-ngedavo gohi veꞌine ningi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Neꞌmine ogosa aza Zohaneꞌ izipahala tiꞌ lo lo-ngimineꞌ ve: Lingine tineꞌ mili vi Zohaneꞌni nene neniꞌ gono noduvo gilasineꞌ idoꞌ ningasineꞌ initekumuꞌ nene tiꞌ li li-imilizo: Veꞌine likive ingine veꞌine gohi niningave. Idoꞌ gizeꞌine goloso ive nene gohi aka nimonavo ganadise gizi dave nene gohi kululuꞌ niizave. Idoꞌ gaꞌine molave nene ingine gohi nigilavo hilave nene gohi do noote-ngidive. Idoꞌ gohoꞌ aleve nene monoꞌ gamazi lamineꞌ nigilave. ");
INSERT INTO aso_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lingine neꞌmine li li-imi tiꞌ li li-imilizo: Gaza neniꞌ monovomuꞌ gaka sita sataꞌ nogelaineꞌ ma nene hulo nenikumuꞌ gele eleꞌvoleꞌ ilineꞌ nene mine lamineꞌ ogo minelineꞌ akaloꞌ eꞌmeto volosane. Idoꞌ eveneꞌ mukiꞌ ingine gaꞌine sita sataꞌ gilami nenikumuꞌ gili eleꞌvoleꞌ ilizave nene mine lamineꞌ igi miniliza akaloꞌ eꞌmeti vilisave. ");
INSERT INTO aso_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Neꞌmine lo lavo Zohaneꞌ ngimiselive ingine tineꞌ mili nivasivo eveneꞌ vaiꞌ minaniꞌ nene Izesuꞌ aza Zohaneꞌnimuꞌ apiꞌ ogo tiꞌ lo lo-ngimineꞌ: Lingine eveneꞌ mukiꞌ Zohaneꞌni ningilisa ebeꞌ hadivela vaniꞌ ma nene naniteꞌ ningilisa vaniꞌ neve. Aꞌmida nene hepeliꞌmo do gabeꞌ kabeꞌ ogaꞌ neineꞌ initeꞌ gepeꞌ neꞌmino gamazi do tiꞌne vatiꞌne ogo laaꞌ ive ma ningilisa vaniꞌ nehe. ");
INSERT INTO aso_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Naniteꞌ ningilisa vaniꞌ neve. Ve maliꞌmo genegana lamineꞌ goloso ngolo minineꞌ ningilisa vaniꞌ neve. Eꞌe, aꞌmine neꞌmine genegana ngili minaaꞌ nave nene guveꞌinesi ve nabavoꞌ minanguꞌ mini initeꞌ lamineꞌ taminekovoꞌ di ngolize izi minaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nemuꞌ nene naniteꞌ ningilisa ebeꞌ hadivela vaniꞌ neve. Polohete ningilisa vaniꞌ noloseive. Olo. Ee, aꞌmine vi ningave nene polohete ma ve. Aꞌmine ve nene polohete gomuꞌ minaniꞌ neꞌmine minamo ngivileꞌ ogosa neive. ");
INSERT INTO aso_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Idoꞌ aꞌmine vemuꞌ nene monoꞌ godolouꞌ Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live lo-emo lineꞌ gamazi ma tiꞌ li gizi nizaniꞌ ma neive: Gelezo. Naza neze gamazi lo-ngeme ngemeꞌ ilive ma imiselekuvo aza do gomuꞌ molo akaka vele-gedeleseive. Aꞌmine gamazi nene aꞌmine ve Zohaneꞌnimuꞌ gizaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Neꞌmine aniꞌ nene naza ma lo-lengemelove. Eveneꞌ misubouko sotoꞌ igi mini di aveutiꞌ nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌni nene ivileꞌ igi minave ma minamaniꞌ ve. Ne neiha Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ilineꞌ gameneꞌve sotoꞌ ogavo aꞌmine gizebo o-ngedelinguꞌ vi hilalizave engikutiꞌ ma lemo miniliveꞌmosi nene Zohaneꞌ minineꞌ monovo nene ivileꞌ ivo minilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Idoꞌ eveneꞌ linge masi idoꞌ takisi moni daaꞌ avesi nene gomuꞌ Zohanedatiꞌ noso hili minaniꞌ neꞌmo Izesuꞌ Zohaneꞌnimuꞌ lineꞌ gamazi nene gili hize eleꞌ igi Oꞌmoso opoꞌni laniꞌza ");
INSERT INTO aso_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Halisaioꞌ monoꞌ laaꞌ avesi idoꞌ louꞌ gamazi apizi ngimaaꞌ avesi ingine Zohanedatiꞌ monoꞌ noso hilamaniꞌ neꞌmo nene Oꞌmosoꞌmo engikumuꞌ neꞌmine neꞌmine ilizave lo galauꞌ gelo ilizaniꞌ aka do sotoꞌ o-ngidineꞌ nene ningi hulikeve. ");
INSERT INTO aso_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Idoꞌ Izesuꞌ imineꞌ molo tiꞌ lo lineꞌ: Idise mene gamenela mine do vuvoniꞌ ningi nizaniꞌ alevemuꞌ nene naniꞌmine initeꞌ neꞌmine nizave lo lo molo lolove. Idoꞌ engikumuꞌ nene nanitetoꞌ lo molo lokuvo vo dalive. ");
INSERT INTO aso_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Engikumuꞌ nene izipe linge maloꞌ lo molo lolosuve. Aꞌmine izipe nene gili goseleꞌ aseleꞌ izipe mini do geseꞌ ogaꞌ ebetoꞌ zohiꞌ igi mini gonoꞌninginemuꞌ nene tiꞌ li laaꞌ nave: Laza lengikumuꞌ huhunaleꞌ mulunidoꞌ nene longolize izi gizedine adine izisaꞌmave. Idoꞌ nama muheleꞌ aheleꞌ ogo lunidoꞌ nene lingine aꞌmineꞌmine igi muheleꞌ aheleꞌ igi lisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Naza neꞌmini nizave luvoniꞌ nene neꞌmine minangumuꞌ luvoniꞌ ve: Monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ aza gonoꞌve do do vinguꞌ nene nosoꞌ niteꞌ lamineꞌ namo idoꞌ vaini nososi namo neivo lingine ningi goseleꞌ lengebelavo tiꞌ li laniꞌ ve: Ve mene sikalahuꞌ goloso maliꞌmo lulo do gopo o-davo neꞌmine neihe li laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Idoꞌ Oꞌmosolatiꞌ ve gihile naza ogo nosoꞌ niteꞌ di geseꞌ igi ni nizanguꞌ vo naaꞌ idoꞌ vaini nososi nene naaꞌ nouvo lingine ningi goseleꞌ lengebelavo soza gamazi li tiꞌ li laaꞌ nave: Ve mene ningilo. Aza nene vele gohi nave mino idoꞌ noso geligelo naaꞌ ive mino takisi moni daaꞌ avesi idoꞌ monoꞌ gilami lihime daaꞌ ave gohi masi nene zogo molo ngemaaꞌ ive ne neive. ");
INSERT INTO aso_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Neꞌmine laaꞌ naniꞌza Oꞌmosoꞌmo otohato monovoloꞌ ogo molo minaaꞌ neineꞌ emeni dameni do tiꞌ o nonive mukiꞌ nene aꞌmine emeni dameni lamineꞌ neineꞌ nene lengelebizaaꞌ noune. ");
INSERT INTO aso_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Idoꞌ Izesuꞌ nene Halisaioꞌ monoꞌ laaꞌ ive maliꞌmo numuꞌveuꞌ nosoꞌ niteꞌ makaꞌ naakumuꞌ elese molo-davo aꞌmine veꞌmi numuꞌveuꞌ dizo nosoꞌ niteꞌ no minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Neivo aꞌmine numuno ebekutiꞌ veneꞌ ma monovo golosoloꞌ monaaꞌ ineꞌ veneꞌ minidiꞌmo Izesuꞌ nene Halisaioꞌ veꞌmi numuꞌveuꞌ nosoꞌ niteꞌ no minineꞌ nene mo gelo luhuvo laminekisi gehenidunuꞌ liliꞌ aniꞌ botolokuꞌ unuvo laminekisi uveli minineꞌ nene do ogo ");
INSERT INTO aso_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","mehenela ogo gizenela mino ive neivo vele novozo neꞌmo Izesuꞌ gizeneloꞌ nene lemavo maduno zopovo nedunuꞌ gilite hulo-do gizene nene upaꞌ ele-do mino aꞌmine unuvo laminekisi uveli nene holo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Noholo-divo Halisaioꞌ ve Izesuꞌni nosoꞌ nitetoꞌ elese molo-dive aza nene ningo asiꞌve lulouꞌ tiꞌ lo lineꞌ: Aꞌmine ve nene polohete minidiniko aꞌmine okoꞌnoloꞌ nodo gilineꞌ veneꞌ nene monovo golosoloꞌ monaaꞌ ineꞌ veneꞌ neive lo gele mino okoꞌneloꞌ do gelamozo lo oꞌve lo-didine. ");
INSERT INTO aso_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Neꞌmine lo nogilivo Izesuꞌ aza aꞌmine Halisaioꞌ ve tiꞌ lo lo-imineꞌ: Simonizo, nenitatiꞌ nene geiꞌ lo-gemeloniꞌ gamazi ma neive. Lavo aza tiꞌ lo lineꞌ: Tisazo, aꞌmine gamazika nene lovo. ");
INSERT INTO aso_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ: Ve maliꞌmo alingeꞌ nimilisingumuꞌ ve lo moni dinaꞌ ogo faef hadeti kina (K500) ve ma emo ve ma nene fifti kina (K50) imineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Neꞌmine ineꞌza ingine alingeꞌ nene ngeli bekimi i-damilisineꞌ ogavo moni dinaꞌ ogo ngimive aza nene nevo alamilizo lo oꞌve lo-ngidineꞌ. Neꞌmine lavosa engikutiꞌ nene ezemuꞌ mulunouꞌ lamineꞌ nabaloꞌ zaho gele nolive. ");
INSERT INTO aso_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Neꞌmine lavo Simoni aza tiꞌ lo lineꞌ: Naza giluvoniꞌ nene moni nabaloꞌ goloso dinaꞌ ogavo lihime nabaloꞌ goloso hulo-dive nene noloseive lo lavo Izesuꞌ tiꞌ lo lineꞌ: Gaza mo gihile lane. ");
INSERT INTO aso_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Neꞌmine lo Izesuꞌ velepeꞌ ize veneta ogo Halisaioꞌ ve Simoniꞌni nene tiꞌ lo lo-imineꞌ: Gaza veneꞌ mene ninge nabe. Gaza nene Zuda ve leliꞌ monovoteloꞌ eꞌmeto neleꞌmize lamineꞌ olosa geiꞌ ilineꞌ initeꞌ nene amanivo veneꞌ meꞌmo noo-nidive. Gaza nene numungauꞌ okuvo gizeꞌne nosoꞌ izeloniꞌ noso ma lepe molo-nedamanivo veneꞌ meꞌmo nene vele novozodunuꞌ gizeꞌneloꞌ nene noso ize-nedo maduno zopovodunuꞌ nene nogilite-nidive. ");
INSERT INTO aso_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Idoꞌ goꞌne veꞌne elo namanivo veneꞌ meꞌmo naza ogo numungauꞌ dizuvodotiꞌ gizeꞌne nene upaꞌ lo-nedo neineꞌ nene osuꞌ lamive. ");
INSERT INTO aso_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Idoꞌ maduꞌneuꞌ nene gaza uveli ma lepo holo-nedamanivo veneꞌ meꞌmo nene unuvo lamineꞌ ogaꞌ ineꞌ uvelidunuꞌ gizeꞌneloꞌ holo-nedave. ");
INSERT INTO aso_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nemuꞌ nene naza ma lo-gemelove. Veneꞌ aza nene lulo nabaloꞌ goloso nimineꞌ neꞌmo lihimeꞌve nabaloꞌ goloso minineꞌ apase-dineꞌ nene sotoꞌ o neive. Neꞌmine oganiꞌza ve ma aza lihimeꞌve ngomo apase-delove neꞌmo nene lulo ngomo neꞌmine nemaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Neꞌmine lo veneꞌ nene tiꞌ lo lo-imineꞌ: Geiꞌ lihimeka nene mo apase-gedekuve. ");
INSERT INTO aso_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Neꞌmine lavo nosoꞌ niteꞌ makaꞌ ni minave ingine nene apiꞌ igi luꞌninguꞌ tiꞌ li laniꞌ: Ve mene ve naniꞌmine ve minidiꞌmo lihimeꞌine hulo-ngedaatokisi lisiheꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Neꞌmine li luꞌninguꞌ nilavo Izesuꞌ aza veneꞌ nene tiꞌ lo lo-imineꞌ: Nenikumuꞌ geiꞌ gele eleꞌvoleꞌ aineka neꞌmo lihime akalotiꞌ geleꞌmize lamineꞌ ogaze. Mulungauꞌ zou lo minivo numungala vozo lo lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nelotiꞌ ngomo ma nomino alingeꞌ nene Izesuꞌ aza nGalilaia numuno ebeꞌ ngomo nabakuꞌ nene mone mone ogo Oꞌmosoꞌmo gizebo o-ledaaꞌ neineꞌ neꞌmi gamazi lamineꞌ nesi nene do vo lo-ngeme ngemeꞌ oꞌmo monineꞌ. Neꞌmine oꞌmo vinguꞌ nene eze izipahala zuho tuvelu nesi nene makaꞌ monaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Idoꞌ veneꞌ ma Izesuꞌ gomuꞌ sikalahuꞌ goloso luꞌningutiꞌ ngimisele hulineꞌ venekisi idoꞌ initeꞌ gizi daniꞌ do guno o-ngidineꞌ venekisi nene makaꞌ monaniꞌ. Aꞌminguꞌ veneꞌ ma nene Maliaꞌ minineꞌ nene ezemuꞌ Mangadalatiꞌ veneꞌ ve li-daaꞌ aniꞌ veneꞌ minineꞌ eiꞌ luloutiꞌ nene sikalahuꞌ goloso seveni Izesuꞌ gomuꞌ ngimisele hulineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Idoꞌ veneꞌ ma nene Helodeꞌ numudoꞌ gizebo ve Kuzaꞌ elenaho Zoanaꞌ nesi idoꞌ Susanaꞌ nesi idoꞌ veneꞌ linge ma nesi nene makaꞌ Izesulesi vaniꞌ ve. Ingine aꞌmine veneꞌ nete nene Izesuꞌnisi izipahala zuho nesi nene engiꞌ initeꞌ mataꞌ idoꞌ nosoꞌ niteꞌine nedunuꞌ nene nasahiliꞌ i-ngidi hize eleꞌ i-ngidavo monaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Idoꞌ eveneꞌ mukiꞌ nene Izesuda ikaꞌ ikaꞌ navo numudotiꞌ numudotiꞌ nesi nene golovoꞌ izi igi nihitavo ningo aneza gamazi ma tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ve ma zuho initeꞌ tileꞌ ogaꞌ ive nene zuho initeꞌve tileꞌ olosa vineꞌ. Vo mo tileꞌ oꞌmo novivo linge ma nene aka gahevela diꞌmozi minikevo eveneꞌ nete aꞌmidoꞌ lisi di goloso ikevo nama nete igi di naniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Idoꞌ linge ma nene gehedoꞌ diꞌmozi gala hoꞌli dizaniꞌza gehedoꞌ mino misubo nene naba minamo gokoꞌ gidini minidiꞌmo nene gulugulu izaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Idoꞌ linge ma gasava guvise hukikevo luhive ma ha mininguꞌ diꞌmozi gala hoꞌli dizaniꞌza gasava guvise nene gohi dizi mili hiti-ngidaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Idoꞌ neꞌmine aniꞌza linge ma misubo laminetoꞌ diꞌmozaniꞌ nete nene gala hoꞌli dizi gihile izaniꞌ nene hamo hamolite vanu hadeti (100) neꞌmine iziꞌmi vaniꞌ ve lineꞌ. Neꞌmine lo tiꞌ lo lineꞌ: Gatine ngoloꞌ live nii ma nene gili lamineꞌ igi gililo. ");
INSERT INTO aso_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Neꞌmine lo lavo aꞌmine aneza gamazi neꞌmiꞌ monovomuꞌ izipahala zuho nete longoꞌ i-dikevo ");
INSERT INTO aso_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo gizebo o-ledelingumuꞌ sunoꞌ gamazi nene lengiꞌ ha gililisave lavo lo sotoꞌ o-lengemaaꞌ nouvoniꞌza eveneꞌ ma ato atoꞌ nene aneza gamazivoꞌ gililizave lo lo-ngemaaꞌ nouve. Neꞌmine nouvoniꞌ nene ingine ningi ningi ningilizaha ninge lamineꞌ amilisave. Idoꞌ gili gili gililizaha gili lamineꞌ amilisave losa nene aneza gamazivoꞌ lo-ngemaaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aꞌmine gepeꞌ gamazi luvoniꞌ ma nene neꞌmino neive: Zuho initeꞌ nene Oꞌmosoꞌmi gamazi neꞌminosa nene neive. ");
INSERT INTO aso_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Idoꞌ zuho initeꞌ ma akaloꞌ diꞌmozikevo evenelite lisi di goloso ikevo namalite nave luvoniꞌ ma nene eveneꞌ malite Oꞌmosoꞌmi gamazi nene gilaniꞌza gili di luꞌninguꞌ milalisa aniꞌ nene ve goloso neꞌmo gili eleꞌvoleꞌ ikevo Oꞌmosoꞌmo do nguꞌ izalive lo ogo aꞌmine gamazi nene do vaaꞌ neingumuꞌ luvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Idoꞌ gehedoꞌ diꞌmozave luvoniꞌ nene eveneꞌ ingine monoꞌ gamazi nene gili ngolize izi liteꞌ li luꞌninguꞌ di goꞌzi gili eleꞌvoleꞌ aniꞌza di giliꞌ li damavo luhiseꞌine damivo gamene haꞌna gili eleꞌvoleꞌ amavo ngemenguꞌ sotoꞌ o ngiminguꞌ nene mo mudise limi ingaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Idoꞌ ma nene gasava guviseuꞌ diꞌmozi gala hoꞌli dizaniꞌza gasava guvise goloso neꞌmo molo hite-ngidive luvoniꞌ nene eveneꞌ ma ingine Oꞌmosoꞌmi gamazi nene mo gili aꞌmidoꞌ eꞌmeti vaniꞌza okoꞌine losuvoꞌmi initeꞌ do sotoꞌ ogakumuꞌ gopo gaꞌine gilaaꞌ idoꞌ moni henenimuꞌ gilaaꞌ idoꞌ me misubouꞌ initekumuꞌ gopo gaꞌine gilaaꞌ aniꞌ neꞌmo Oꞌmosoꞌmi gamazi nene molo hitavo inginela nene gulupese ogo gihile izesaꞌmineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Idoꞌ misubo laminekuꞌ diꞌmozi gala hoꞌli dizi gihile izave luvoniꞌ ma nene eveneꞌ ma aꞌmine Oꞌmosoꞌmi gamazi nene li-ngimikevo liteꞌ li gili di monovoꞌine laminetotiꞌ idoꞌ luꞌine laminekisi minadotiꞌ monoꞌ nene di giliꞌ li daniꞌ nene ingine goseleꞌ ngebelamivo aꞌmine monoꞌ nene di giliꞌ li di mini mini di dizi minikevo neꞌmo nene engita gihile lamineꞌ izeꞌmo vo minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Eveneꞌ ingine liviꞌ lamu viteꞌ igisa somo naba aꞌmidoꞌ ma hitikisaꞌmave. Idoꞌ aꞌmine lamu nene viteꞌ igisa sebenguꞌ ma di milikisaꞌmave. Asi eveneꞌ numunguꞌ dizilizave nene hize labanaꞌ ele-ngedelingumuꞌ sotoꞌ lamu molaaꞌ holomoloꞌ milalisave. ");
INSERT INTO aso_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Idoꞌ aꞌmineꞌmine ogo idise mene hito neineꞌ initeꞌ mukiꞌ nene alingeꞌ sotoꞌ oloseive. Idoꞌ idise mene haleko sunoꞌ neineꞌ initeꞌ mukiꞌ nesi nene sotoꞌ ogavo ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ve ma ingine monoꞌ ma di minilizave nene Oꞌmosoꞌmo gohi ma ngemavo di vaiꞌ li minilisave. Idoꞌ monoꞌ ma di minamilizave nene ingine monoꞌ nene mo do none li gili ma di nilizaniꞌ nesi nene ipeꞌ ogo do voloseive. Lingine monoꞌ gilili ma nene gopo abeleni abeleni igi gilami di guni igi gili guni igisa gililo. ");
INSERT INTO aso_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Idoꞌ Izesuꞌ izelehosi idoꞌ nakunolomotesi nene Izesuꞌ neida aniꞌza numunguꞌ nene eveneꞌ gikiꞌ ikevo neidoꞌ ngeli vamilizadoꞌ ogavo heta ha minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oti nizavo eveneꞌ nete izahosi nakuna zuhosi heta geiꞌ ningi-gidilisa igi oti nizave li Izesuꞌni li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Li-imaniꞌza Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Neze izeꞌneho idoꞌ nakuꞌne zuho nene ve ma ingine Oꞌmosoꞌmi gamazi gili aꞌmidoꞌ eꞌmeti igi mili igaꞌ ave nene nizave lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Idoꞌ gamene ma izipahala zuhosi sipiuꞌ dizi izipahala zuho tiꞌ lo lo-ngimineꞌ: Laza noso ohuno mene hulo helala holene volone. Lavo mo vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mo nosoloꞌ ledi nivavo Izesuꞌ nene okise onganiꞌ. Ongo neivo hepeꞌ naba goloso elo noso nene golo gidini eleꞌ alaꞌ ogo noso nene sipiuꞌ velo nodizivo ingine nene ganala di helaaꞌ akaloꞌ mini mili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Neꞌmine neivo izipahala zuho ingine vi Izesuꞌni uꞌmukoꞌ igi tiꞌ li li-imaniꞌ: Ve naboo, ve naboo, laza nene mo osuꞌ losoꞌ o neineꞌ lae. Likevo aza oto hepeꞌ nesi noso monineꞌ nesi nene ngelemavo hepeꞌ nene matavo noso nesi mato ngi lo lamineꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Neꞌmine ogavo izipahala zuho nene tiꞌ lo lo-ngidineꞌ: Lingine nene Oꞌmosola gili eleꞌvoleꞌ ilizanako nanimuꞌ gili eleꞌvoleꞌ amave. Neꞌmine lavo izipahala zuho ingine ngehelele goloso izo voꞌine vavo tiꞌ li li voleloꞌ meloꞌ aniꞌ: Ve meꞌmo hepeꞌ masi noso masi matilisive lo-ngedavo gamaziꞌve gili dikesiko ve mene atoliꞌmine ve goloso noloseive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Neꞌmine igi ingine nene nGalilaia noso ohuno neꞌmi helala Gelegesa misubola vi hetelaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Vi heteli Izesuꞌ sipiutiꞌ lemo noso gahevela novivo aꞌmida minineꞌ numuno ebekutiꞌ ve sikalahuꞌ goloso lulouꞌ minive masi voteneꞌ asineꞌ. Aꞌmine ve nene mo gamene haꞌnaloꞌ okoꞌnoloꞌ initeꞌ ma izamo mino numungukisi ongosaꞌmo gonoso galese minida mono ongokaꞌ ogo monaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Neꞌmino neivo evenelite senidunuꞌ gizene analoꞌ nene nalaꞌ izi-di gizebo i-daaꞌ aniꞌza sikalahuꞌ goloso neꞌmo aꞌmine seni nalaꞌ nene izo huko eveneꞌ nene eleꞌmizo ebeꞌ hadivela vaaꞌ ineꞌ ve. Idoꞌ Izesukisi voteneꞌ igi aꞌmine ve neꞌmo Izesuꞌni nene ningo gekeꞌ lo Izesuꞌ velela vo lemo pouꞌ lo ongavo aꞌmine sikalahuꞌ goloso neꞌmo gamene gamene aꞌmine veꞌmi lulouꞌ nene minavo nemuꞌ nene Izesuꞌ aza sikalahuꞌ goloso nemuꞌ sikalahuꞌ goloso gaza ve neꞌmi luloutiꞌ nene hulo-do lemo ogo vozo lo-dineꞌ ve. Idoꞌ aꞌmine gamazi lo-dingumuꞌ aꞌmine ve neꞌmo gamazi naba lo tiꞌ lo lineꞌ: Izesuvo, Oꞌmoso dizo miniveꞌmi gipele mene gaza nouvoda nanitekaꞌ nane. Nenita mulumo gono nemamiline losa geita amuzonga nolo-giduve. ");
INSERT INTO aso_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Neꞌmine lavo Izesuꞌ aza aꞌmine sikalahuꞌ goloso lulouꞌ minive nene tiꞌ lo longoꞌ o-dineꞌ: Gaza guliveka nene zaho nane. Neꞌmine lavo sikalahuꞌ goloso lulouꞌ minive aza sikalahuꞌ goloso vaiꞌ minaniꞌ nenako nemuꞌ nene aza guliveꞌve nene Mangiliseꞌ nouve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lavo sikalahuꞌ goloso ingine limisele hulo galese lulouꞌ amilive li amuzonga li geligelinga laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Idoꞌ aꞌmida golola nene ize mukiꞌ goloso galese ni nizavo sikalahuꞌ goloso ingine aꞌmine izeliti luꞌninguꞌ nene limisele hulavo vo dizelone li Izesuda amuzonga goloso laniꞌ. Neꞌmine likevo vi aꞌminguꞌ dizilizave lo Izesuꞌ gele ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Neꞌmine ogavo ingine aꞌmine eveneliꞌmi luloutiꞌ limi vi ize neti luꞌninguꞌ dizikevo ize mulise ingine mangilise hizi lotiꞌ izi golo aveseloꞌ nene limi noso ohunouꞌ vi noso nii hilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Neꞌmine ikevo ize gizebo ve ingine golise vi aꞌmine ninganiꞌ initeꞌ nemuꞌ aꞌmida numuno ebeꞌ nabauꞌ nesi idoꞌ hazala nesi nene li-ngimi osuꞌ laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Neꞌmine ikevo eveneꞌ ingine aꞌmine sotoꞌ ineꞌ initeꞌ nene ningelone li Izesuꞌ neida igi ninganiꞌ nene aꞌmine luloutiꞌ sikalahuꞌ goloso limi igi vave nene gamazi gelaaꞌ initeꞌve maduno nesi nene mo lamineꞌ ogavo geneganaꞌve nesi do izo Izesuꞌ gizeneuꞌ mitoꞌ mino gapepeꞌ o neivo ningi ngehelele izineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Idoꞌ ve ma ingine aꞌmine sikalahuꞌ goloso lulouꞌ minave Izesuꞌ do lamineꞌ o-dineꞌ ningave nete aꞌmine monovo nemuꞌ eveneꞌ mukiꞌ li-ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Neꞌmine ikevo Gelegesa misubouꞌ aleve ingine nene ngehelele naba goloso izavo engiꞌ misubo nene hulo vilive li amuzo mili Izesuda laniꞌ. Neꞌmine likevo gohi sipiuꞌ dizo tineꞌ molo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Novivo sikalahuꞌ goloso luloutiꞌ do hulo-ngidive aza Izesuda giꞌmizo makaꞌ monelove lo amuzonga lineꞌza Izesuꞌ aza oꞌve lo imisele hulo tiꞌ lo lo-dineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Gaza nene numungala vo Oꞌmosoꞌmo amebe initeꞌ o-gidineꞌ nemuꞌ nene neꞌmine o-nidive lo lo sotoꞌ ogo lo-ngemezo. Neꞌmine lo-davo sikalahuꞌ goloso luloutiꞌ igi vave aza aꞌmida minineꞌ numuno ebekuꞌ nene vo Izesuꞌ amebe initeꞌ o-dineꞌ nemuꞌ lo-ngeme ngemeꞌ oꞌmo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Neꞌmine ogavo eveneꞌ ingine Izesungumuꞌ gizebo igi nizavo Izesuꞌ aza tineꞌ molo vo hetelavo gekeꞌ vokeꞌ li-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Neꞌmine nili-davo ve ma monoꞌ numudoꞌ gizebo ve gulive Zailoꞌ aza aluvo kilisimasiꞌve tuvelu (12) neꞌmidoꞌ minineꞌ aluvo hamoꞌ nene mo nohilivo lotiꞌ izo ogo Izesuꞌ gizeneuꞌ lemo golo hizo Izesuꞌ nene numuꞌveuko alive lo amuzonga lo-dineꞌ. Neꞌmine lo-davo Izesuꞌ aza aꞌmida novivo eveneꞌ mukiꞌ nene muloloꞌ muloloꞌ igi eꞌmeti vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Neꞌmine igi nivavo veneꞌ ma venelite ikeꞌniloꞌ ikeꞌniloꞌ ningaaꞌ naniꞌ siki nene mate-desaꞌmivo mino gamene haꞌnaloꞌ ninge do vo neivo kilisimasi tuvelu do hulo minineꞌza ve malitesi ma di lamineꞌ i-damavo ha minineꞌ nene ");
INSERT INTO aso_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Izesuꞌni eꞌmeto mehenela ogo geneganaꞌve neꞌmi lolovola do gelavo aꞌmidoꞌ liteꞌ lo siki initeꞌve minineꞌ nene okuꞌ lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Neꞌmine ogavo Izesuꞌ aza okoꞌneloꞌ zaho do gilive lineꞌza eveneꞌ mukiꞌ ingine nene laza ma do gelamune li oꞌove likevo Petoloꞌ aza tiꞌ lo lineꞌ: Eveneꞌ nabazo, eveneꞌ mukiꞌ goloso muloloꞌ muloloꞌ igi nizave nete geiꞌ okongaloꞌ nene hitikeve lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Neꞌmine lineꞌza Izesuꞌ aza tiꞌ lo lineꞌ: Eveneꞌ maliꞌmo okoꞌneloꞌ do gelavo nenitatiꞌ amuzo ezela vineꞌ nene mo gelekuve lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Neꞌmine lavo okoꞌnoloꞌ do gilineꞌ veneꞌ aza nene monovoꞌne mo sotoꞌ ogave lo gelo luvo luvo ize do ogo Izesuꞌ veleloꞌ lemo golo hizo ongo Izesuꞌ geneganaꞌveloꞌ do gilineꞌ nene nanitekumuꞌ do gilihe neꞌmi monovosi idoꞌ venelite ikeꞌniloꞌ ikeꞌniloꞌ ningaaꞌ naniꞌ siki initeꞌ ningo minineꞌ liteꞌ lo osuꞌ lo-dineꞌ monovo nemukisi nene eveneꞌ mukiꞌ neti veꞌnidoꞌ lo sotoꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Neꞌmine ogavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Aluneve, gele eleꞌvoleꞌ anidiꞌmo nene lamineꞌ ogange. Mulungauꞌ hongu lo lamineꞌ o minivo vozo. ");
INSERT INTO aso_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Neꞌmine lo nolivo monoꞌ numudoꞌ gizebo veꞌmi numungukotiꞌ eveneꞌ ma ogo tiꞌ lo lineꞌ: Gaza aluva ma nene mo helave. Nemuꞌ nene gaza tisaꞌni nene lihiteheka lo gohi eleꞌmizo amozo. ");
INSERT INTO aso_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Neꞌmine lineꞌza Izesuꞌ aza gelo monoꞌ numudoꞌ gizebo ve nene tiꞌ lo lo-imineꞌ: Gaza gopo gaka gelamo aluva ha do lamineꞌ o-delongumuꞌ nene gele eleꞌvolekovoꞌ nene ogo minezo. Neꞌmine oganivo aluva neve lamineꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Neꞌmine lo mo aluvo hiliveꞌmi numudoꞌ ogo hetelo eveneꞌ mukiꞌ nene aza numunguꞌ dizelonguꞌ nene ma dizamavo Petoloꞌ ve Zohaneꞌ ve Zakoboꞌ ve idoꞌ alungo neꞌmi izelehoi melehoi engiꞌ neevoꞌ nene dizilisave idoꞌ eveneꞌ mukiꞌ nene oꞌove lo lo huko-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Neꞌmine lavo numunguꞌ dizanguꞌ nene eveneꞌ mukiꞌ ive nama igi mulumo alumo gili minaniꞌza Izesuꞌ aza tiꞌ lo lineꞌ: Alungo nene helamineꞌ haza okise ongo neize. Lingine ive nama amilo. ");
INSERT INTO aso_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Neꞌmine lineꞌza eveneꞌ aꞌminguꞌ minave ingine alungo nene mo helavo ningi gili nizaniꞌ nenako nemuꞌ Izesuꞌni nene gizeꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gizeꞌ i-daniꞌza Izesuꞌ aza alungo nene analoꞌ nodo vise lo-do tiꞌ lo lineꞌ: Izipahaꞌne, otevo. ");
INSERT INTO aso_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Neꞌmine lavo vonahaza gohi omo izavo liteꞌ lo otineꞌ. Otavo Izesuꞌ aza aꞌmine alu nene nalineꞌ initeꞌ ma imilizave lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Neꞌmine lavo alungo neꞌmi izelehoi melehoi nene voꞌine goloso vavo minasineꞌza Izesuꞌ nene aꞌmine gamazi nemuꞌ eveneꞌ veteteꞌ igi li-ngimamilizave lo lo huko-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Izesuꞌ aza izipahala zuho tuvelu nene vise lo do nubo o-ngedo eveneꞌ luꞌningutiꞌ sikalahuꞌ goloso vaiꞌ nene ngimisele hulaaꞌ amuzo atoliꞌminesi idoꞌ initeꞌ gizi dave di lamineꞌ i-ngidiliza amuzo nesi nene ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Neꞌmine ogo Oꞌmosoꞌmo gizebo o-ledelingumuꞌ gamazi lamineꞌ nene li-ngimaaꞌ ilizave lo idoꞌ initeꞌ gizi dave nene di lamineꞌ i-ngidaaꞌ ilizave lo ngimiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nongimiselo tiꞌ lo lo-ngidineꞌ: Aka vilizada nene initeꞌ mo di vamilo. Hatuso nesi di vami idoꞌ gokisi nene di vami idoꞌ beleti nesi nene dami idoꞌ monisi nene goꞌzi di vami idoꞌ sioti nesi nene sitaꞌ izi vami hamokovoꞌ izikisa vilo. ");
INSERT INTO aso_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Idoꞌ lingine nene vi numuno mauꞌ nidizi ma nene aꞌmine numunguꞌ nene ingiꞌmi nivi viliza gameneuꞌ nene vilo. ");
INSERT INTO aso_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Idoꞌ numuno maloꞌ nivavo lengeleꞌmize lamineꞌ amavo ma nene lingine aꞌmine numuno ebeꞌ huli vilisa niigi ma nene ingine engiꞌ monovoꞌine gililizangumuꞌ ve li avazaha igi gizedidotiꞌ uꞌmusupo nene okohoꞌ izi di huli vilo. ");
INSERT INTO aso_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Neꞌmine lo-ngedavo ingine nene vi numuno ebeꞌ ngomo ngomouꞌ idoꞌ ebeꞌ mukikuꞌ nene monoꞌ gamazi li-ngimiꞌ ngimiꞌ igi initeꞌ gizi dave di lamineꞌ i-ngidiꞌmi vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Neꞌmine iꞌmi nivavo guvelesi ve naba Helodeꞌ aza Izesuꞌ gonoꞌve do ogo molo ineꞌ initekumuꞌ nene gelo gopo gala gilineꞌ. Gopo gala gilineꞌ nene ve malite monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ nene hilingutiꞌ gohi otosa neꞌmine neive nilavo ");
INSERT INTO aso_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","idoꞌ malite nene polohete Eliaꞌ ma nene gohi sotoꞌ ogave li nilavo idoꞌ ma nete nene gomuꞌ polohete linge minaniꞌ mautiꞌ ma vele gizo gohi oto neꞌmine gono nodave li nilavo ");
INSERT INTO aso_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helodeꞌ aza gelo tiꞌ lo lineꞌ: Zohaneꞌ nene luvono gitekuvoniꞌ ma neineꞌza idoꞌ gamaziꞌve nogiluve mene zaho nolive lineꞌ. Neꞌmine lo aꞌmine Izesuꞌni nene ningelesa gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Idoꞌ aposolo ingine monoꞌ gonoloꞌ ngimiselidotiꞌ nene tineꞌ mili igi initeꞌ igi mili monaniꞌ nemuꞌ nene Izesuꞌni veteteꞌ igi li-imaniꞌ. Neꞌmine ikevo eveneꞌ linge ma nene huli-ngidi Izesuꞌ nene izipahala zuho ngeleꞌmizo gililiheꞌ ivo vi numuno ebeꞌ ma gulive Betesaida nela vi hetelaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Eveneꞌ mukiꞌ ingine Izesuꞌ vineꞌ nemuꞌ gili eꞌmeti vaniꞌ. Eꞌmeti nivavo aza ngeleꞌmize lamineꞌ ogo Oꞌmosoꞌmo gizebo o-ledelingumuꞌ gamazi lamineꞌ nene lo-ngemaaꞌ idoꞌ initeꞌ gizi dave adoꞌ di lamineꞌ i-ngidiliza akaloꞌ mini mili minave nene do lamineꞌ o-ngedaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Neꞌmine neivo hoꞌ nene lemo voo nivengaꞌ nomolavo izipahala zuho tuvelu ingine Izesuꞌ neida igi tiꞌ li li-imaniꞌ: Laza ebeꞌ hadiveloꞌ mene noneꞌ nenako nemuꞌ eveneꞌ nene ngimisele hulovo. Ingine nene mevola miniꞌmi monaniꞌ luhuvo numunguꞌ nehe haza numuda nehe vi nosoꞌ niteꞌine meni hizi naaꞌ idoꞌ ingaaꞌ ilizangisi. ");
INSERT INTO aso_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Neꞌmine laniꞌza aza tiꞌ lo lo-ngimineꞌ: Lengiꞌ nene nosoꞌ niteꞌ di ngimilevo. Neꞌmine lavo ingine tiꞌ li laniꞌ: Laza nene sikoni faef (5) idoꞌ alahaꞌ sitaꞌ aꞌnevoꞌ molo noneꞌ nenako eveneꞌ mukiꞌ memuꞌ nene gohi ma vo hizelesune lo nolabe. ");
INSERT INTO aso_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Neꞌmine laniꞌ nene ve faef tauseni (5,000) neꞌmine minaniꞌ nenako nemuꞌ nene laniꞌ ve. Neꞌmine likevo Izesuꞌ izipahala zuhomuꞌ tiꞌ lo lineꞌ: Eveneꞌ nene fifti fifti (50) neꞌmine ve hizi guviseloꞌ nene mitoꞌ minilizave li li-ngidilizave lo lo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Neꞌmine lavo izipahala zuho ingine Izesuꞌ lidoꞌ lidoꞌ igi eveneꞌ nene di lisiheꞌ i-ngidikevo vaitoꞌ nene mitoꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nizavo sikoni faef nesi alahaꞌ sitaꞌ nesi nene do Okulumota vonuꞌ noogo Oꞌmoso opoꞌni lo aꞌmine nosoꞌ niteꞌ nene gito apilo izipahala zuho nete izeꞌ mili eveneꞌ ngimilizave lo ngemavo moni ngimaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","nGimikevo eveneꞌ mukitoꞌ ni gatuꞌine aniꞌ. Neꞌmine ikevo izipahala zuho ingine lumo sama minineꞌ nene gosuvahaꞌ tuvelu (12) neꞌmine goꞌzi vaiꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gamene ma Izesuꞌ aza eikovoꞌ Oꞌmosola lo neivo izipahala zuho nesi makaꞌ imi nizavo tiꞌ lo longoꞌ o-ngidineꞌ: Eveneꞌ nete nenikumuꞌ nene zaho ve li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Neꞌmine lavo izipahala zuho ingine tiꞌ li li-imaniꞌ: Eveneꞌ linge ma nete nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ nene hilingutiꞌ otosa oloseive li laaꞌ nave. Idoꞌ linge ma nete nene gozopoꞌ polohete Eliaꞌ aza gohi sotoꞌ oloseive lave ma nene tineꞌ molo abe li laaꞌ nave. Idoꞌ ma nete nene gomuꞌ minaniꞌ polohete hilaniꞌ linge engikutiꞌ otanive nolibe li laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Neꞌmine likevo Izesuꞌ gohi tiꞌ lo longoꞌ o-ngidineꞌ: Idoꞌ ingine nene mo neꞌmine laaꞌ naniꞌza lingine nenikumuꞌ nene zaho neve li laaꞌ nave. Neꞌmine lavo Petoloꞌ aza tiꞌ lo lo-imineꞌ: Oꞌmosoꞌmo do luꞌ izeline lo do kegese-gedo gimiselelesa live ma nene nane. ");
INSERT INTO aso_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Neꞌmine lo lineꞌza Izesuꞌ aza neꞌmine li eveneꞌ hamokisi li-ngimamilizave lo oꞌove lo lo huko-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Idoꞌ Izesuꞌ aza neniꞌ nene do lunguꞌ izelongumuꞌ do kegese-nedo Oꞌmosoꞌmo nimiselelesa live neive li eveneꞌ hamokisi li-ngimamilizave lo lo huko-ngedo tiꞌ lo lo-ngimineꞌ: Neniꞌ gono neꞌmo gihileꞌve do sotoꞌ ilingumuꞌ Oꞌmosolatiꞌ ve gihile neniꞌ nene mulumo gono naba geho helosa gohi otelodoꞌ o neineꞌ nenako monoꞌ gizebo vesi idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ Zuda vete monoꞌ gozopotatiꞌ laaꞌ aniꞌ apizi ngimaaꞌ avesi ingine meheꞌine nimi mulumo initeꞌ mukiꞌ nimi nibili hililisave. Neꞌmine ikevo galeseuꞌ lemo gamene sitohamo minekuvo Oꞌmosoꞌmo gohi do ote-nedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Neꞌmine lo eveneꞌ mukiꞌ nene tiꞌ lo lo-ngimineꞌ: Ve ma ingine neꞌmeto alone li gilii ma gomuꞌ nene engiꞌ minevoꞌ alevoꞌine gizebo igaꞌ naniꞌ monovoꞌine nene huli alami neniꞌ neꞌmetilizangumuꞌ ve goloso nizave li lohotoꞌ zaloꞌ ngibili hililizangumuꞌ nene gamene gamene gili hulisa neꞌmeti alizave. ");
INSERT INTO aso_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Idoꞌ neꞌmine igisa neꞌmeti alizave lo noluvoniꞌ nene nanitekumuꞌ luhe. Lingine mene gililo. Ve ma ingine neniꞌ neꞌmeteloneꞌ nene geni initeliꞌmi lulouꞌ vo minevoꞌ alevote hulalone li neꞌmetamilizave nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ma damilisave. Damilisaha ve ma ingine neꞌmeti vilizanguꞌ ngibili hilikevo minevoꞌ alevoꞌine hulilizaniꞌ nene alingeꞌ minevoꞌ minevoꞌ ngemeni dameni dalisave. ");
INSERT INTO aso_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ee, misubouko mene minevoꞌ alevoꞌ igi mini misubouꞌ initeꞌ vaiꞌ nene di engita igi minilizanguꞌ nene minevoꞌ minevoꞌ minaaꞌ ngemeniꞌine hulilizahe vo tolovo ilihe ilineꞌ nene aꞌmine initeꞌ vaiꞌ nete nene ma hize eleꞌ i-ngidamilisave. ");
INSERT INTO aso_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Idoꞌ me misubouꞌ minevoꞌ alevoꞌinemuꞌ gili neniꞌ neꞌmetamilizave ingine minevoꞌ minevoꞌ ngemeni ma damilisave noluvoniꞌ nene ve ma ingine libilikevo minevoꞌ alevote hulalone li neniꞌ evenele none lilisa ngovozo hililizaniꞌ nene Oꞌmosolatiꞌ ve gihile naza labanalasi amuzoꞌnesi idoꞌ meꞌnehi amuzosi idoꞌ eiꞌ angeloꞌveti amuzosi nene do mino aloniꞌ gamenela aꞌmine alevemuꞌ nene neniꞌ eveneꞌne nizave lolosa ingine adiꞌmino novozo helo lamuvo minevoꞌ minevoꞌ ngemeni dameni nene ma damilisave. ");
INSERT INTO aso_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Naza laminetoꞌ ma lo-lengemelove: Meloꞌ nizave lengikutiꞌ nene linge ma hilami ha nizavo Oꞌmosoꞌmo gizebo o-ledaaꞌ monovo nene sotoꞌ ogavo ningilisave. ");
INSERT INTO aso_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Izesuꞌ aza aꞌmine gamazi lo-ngimidotiꞌ gamene eiti (8) ogo vavo Oꞌmosola lolosa Petoloꞌni ve Zohaneꞌni ve Zakoboꞌni ve nene ngeleꞌmizo gololoꞌ dizo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","nGeleꞌmizo dizo Oꞌmosola lo neivo golo vele nene do atoliꞌmine loloꞌ noo-divo geneganaꞌvelotiꞌ nene mokonoꞌ hego hego lo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Neꞌmine neivo Okulumokutiꞌ limi asineꞌ nene ve sitaꞌ ma Izesulesi gamazi li voleloꞌ meloꞌ igi minaniꞌ nene Moseki Eliaki minasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ingine nene labanaꞌine atoliꞌminesi sotoꞌ igi mini Izesuꞌ Zelusalemi numuda helelineꞌ neꞌmo Oꞌmosoꞌmo imineꞌ gono nene do pelo me misubo hulo dizo vilineꞌ nemukisi nene li voleloꞌ meloꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Neꞌmine li nilavo Petoloꞌ ve Zohaneꞌ ve Zakoboꞌ ve ingine nene veꞌine hihiꞌ ogavo mo ingalisa gilaniꞌza ingami ha oti mini Izesuꞌ labanala nene ningisa idoꞌ ve sitaꞌ nesi makaꞌ oti minasineꞌ nene ninganiꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Idoꞌ ve sitaꞌ nene Izesuꞌni huli-di nivasivo Petoloꞌ tiꞌ lo lo-imineꞌ: Ve naboo, makaꞌ meloꞌ minuneꞌ nene lamineꞌ ogave. Nemuꞌ nene meloꞌ azibe sitohamo ma gizelone. Ma nene geiꞌ ve idoꞌ ma nene Moseꞌni ve idoꞌ ma nene Eliaꞌni ve. Neꞌmine lineꞌ nene nadive noluhe lo gelamo gopo gani lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petoloꞌ aza neꞌmine nolivo limusoliꞌmo ogo molo hite-ngidineꞌ. Molo nohite-ngidivo limuso lulouꞌ halekaniꞌ nemuꞌ ngehelele izineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Neꞌmine neivo limuso luloutiꞌ Oꞌmosoꞌmi gamazi ma tiꞌ lo sotoꞌ ineꞌ: Meve nene neniꞌ gipeꞌne do lunguꞌ izelive lo do kegese-de nouvoniꞌ nenaze. Lingine eze gamaziꞌve gili dalo. ");
INSERT INTO aso_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Neꞌmine lo limusoutiꞌ lavo izipahala zuho sitohamo ingine Izesuꞌ nene eikovoꞌ neivo ninganiꞌ. Idoꞌ ingine aꞌmine ninganiꞌ initeꞌ nene eveneꞌ hamokisi li-ngimami legeneꞌ iki ha nizavo gamene haꞌna gidini vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Neꞌmine igi mini goꞌ lavo gololatiꞌ limi navo eveneꞌ mukiꞌ nene Izesulesi voteneꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Voteneꞌ navo aꞌmine eveneꞌ muliseutiꞌ ve maliꞌmo gekeꞌ lo tiꞌ lo lineꞌ: Tisazoo, neniꞌ gipeꞌne hamoꞌ gehepeve mene ninge-deline lo geita noluve. ");
INSERT INTO aso_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Eze nene sikalahuꞌ goloso maliꞌmo do ote-davo upuhoꞌ ogo gekeꞌ naba lavo sikalahuꞌ goloso neꞌmo gohi do upuhoꞌ o-davo ahezeve izo neivo vele lavozo ogo gituhoꞌ galakalaꞌ ogo neivo sikalahuꞌ goloso nene aꞌmanapa ogo hulo-do vamolosa ingutiꞌ hulo-do vavo okoꞌno malalapa izo minavo amuzolo nomivo minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naza izipaha zuho nete sikalahuꞌ goloso nene imiseli hulilizave lo engita luvoniꞌza ingine nene ngeli imiseli hulilizadoꞌ minamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lavo Izesuꞌ aza aꞌmidoꞌ tiꞌ lo lineꞌ: Eii, ngeli imiseli hulisaꞌmaniꞌ nehe lingine Oꞌmosomuꞌ gili eleꞌvoleꞌ amaniꞌ zuho lutine zovoꞌ ize vineꞌ mene lengikumuꞌ goseleꞌ nebeleꞌmo novivo lengiꞌ vovotinguꞌ gamene gohi ma imineꞌ molo mino langamuzo hizeꞌmo vo mineloniꞌ nemuꞌ nene agae lo noluve. Neꞌmine lo gipa nene eleꞌmizo ano lavo ");
INSERT INTO aso_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","eleꞌmizi ikevo aꞌmine izipe olihe navo sikalahuꞌ goloso neꞌmo ehusoꞌ o hulavo lemo pouꞌ lo ongo neivo do gabeꞌ kabeꞌ o-divo ahezeve izo minineꞌ. Neꞌmine o-dineꞌza Izesuꞌ aza sikalahuꞌ goloso nene elemo izipe nene do lamineꞌ o-do melehine gohi do imineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Neꞌmine ogavo eveneꞌ mukiꞌ ingine Oꞌmosoꞌmi amuzo atoliꞌmine goloso nene ningi upuhoꞌ goloso aniꞌ ve. Idoꞌ Izesuꞌ ogo molo ineꞌ initeꞌ mukiꞌ nemuꞌ eveneꞌ nene voꞌine vavo gopo gaꞌine ha gili nizavo Izesuꞌ aza izipahala zuho tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Gamazi mene loloniꞌ nene lingine mili gatinguꞌ iki gili minilo. Adoꞌ Oꞌmosolatiꞌ ve gihile neniꞌ nene nibililizaniꞌ eveneliti aꞌninguꞌ neleꞌmizi milalisave. ");
INSERT INTO aso_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Neꞌmine lo lineꞌza aꞌmine gamaziꞌmi monovo geti gilikelizave lo Oꞌmosoꞌmo gaꞌine do ngoloꞌ lo-ngedamivo aꞌmine gamazi neꞌmi monovo nene gili lamineꞌ amaniꞌ nenako nemuꞌ nene aꞌmine gamazimuꞌ longoꞌ i-dilisa ngehelele izineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Neꞌmine igi izipahala zuho ingine lelikutiꞌ nene zaho livileꞌ ogo dizosa nolive li nemuꞌ gamazitunuꞌ lovo noꞌninguꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Neꞌmine igi lolize gamazi nilavo Izesuꞌ aza luꞌninguꞌ gilaniꞌ nene mo ningo gelo izipe ngomo ma eleꞌmize do ogo minida do ote-do ");
INSERT INTO aso_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tiꞌ lo lo-ngimineꞌ: Ve ma ingine nenikumuꞌ ve li izipe ngomo meꞌmine ma ngeleꞌmize lamineꞌ ilizaniꞌ nene neniꞌ neleꞌmize lamineꞌ aniꞌ geleleseive. Idoꞌ ve ma ingine neniꞌ ma neleꞌmize lamineꞌ ilizaniꞌ nene nimiselive Oꞌmoso nene eleꞌmize lamineꞌ aniꞌ geleleseive. Nemuꞌ nene Oꞌmosoꞌmo gilivo lengikutiꞌ maliꞌmo eikumuꞌ neniꞌ nene lemo nouve lo gele nolive neꞌmo lengiꞌ nene lingivileꞌ ogosa mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Neꞌmine lavo aꞌmidoꞌ Zohaneꞌ aza tiꞌ lo lo-imineꞌ: Ve nabazo, ve maliꞌmo geiꞌ guliveka lo sotoꞌ ogo geiꞌ vekamuꞌ ve lo sikalahuꞌ goloso nongimiselivo laza ningo aꞌmine ve nene lezesi bizo geiꞌ geꞌmetesaꞌmineꞌ nenako nemuꞌ neꞌmine amozo lo oꞌove lo-dekune. ");
INSERT INTO aso_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Neꞌmine lo lineꞌza Izesuꞌ aza tiꞌ lo lo-imineꞌ: Ve ma ingine biluvaꞌ i-lidamilizave nene lelita ve nene nizaze. Nemuꞌ lingine oꞌove li-damilo lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Izesuꞌ nene Oꞌmosoꞌmo mo Okulumokuko gohi eleꞌmizo dizelineꞌ gamene alitavo mo Zelusalemi numuno ebeta volosa amuzo molo gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Idoꞌ neꞌmine ogosa eiꞌ vilingumuꞌ gamazi di gomuꞌ vilizave ma ngimiselineꞌ. nGimiselavo ingine Samalia alevetinguꞌ numuno ebeꞌ mauꞌ vi numuno di lisiheꞌ i-dilisa aniꞌza ");
INSERT INTO aso_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","aꞌminguꞌ aleve nete Izesuꞌ aza engikisi bizisaꞌmaniꞌ aleveti numuno ebeꞌ Zelusalemi numuno ebeta volosa ingumuꞌ nene eze eleꞌmize lamineꞌ amolosune laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Neꞌmine likevo izipahala zuhoutiꞌ ve sitaꞌ ma Zohaneki Zakoboki ingine neꞌmine laniꞌ nemuꞌ ningi gili Izesuꞌni tiꞌ li li-imasineꞌ: Guvekasi ve, laza lokunivo okulumokutiꞌ ololiꞌmo lemo aꞌmine mene aleve ngebele geseꞌ ilive lo nogelabe. ");
INSERT INTO aso_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Neꞌmine lasineꞌza Izesuꞌ aza mine velepeꞌ izo ngelemineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Neꞌmine ogavo numuno ebeꞌ gohi mala vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Akaloꞌ nivavo ve maliꞌmo Izesuꞌni tiꞌ lo lo-imineꞌ: Naza nene geiꞌ vilinida alinida ha geꞌmeto volosuve. ");
INSERT INTO aso_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Initeꞌ mukiꞌ loposo gulosi idoꞌ namasi nene ingalizaniꞌ numuꞌinesi minaaꞌ naniꞌza Oꞌmosolatiꞌ ve gihile neniꞌ ongalo numuꞌne nene nomineꞌ nenako ha neꞌmetelibe. ");
INSERT INTO aso_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Idoꞌ neꞌmine lo ve mamuꞌ nene neꞌmeto ano lo-dineꞌza aza tiꞌ lo Izesuꞌni lo-imineꞌ: Guvekasi ve, gaza gele nemanivo meꞌnehine vo do galese ize-dosa ogo geꞌmetelove lo lineꞌza ");
INSERT INTO aso_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Izesuꞌ aza tiꞌ lo lo-imineꞌ: Gaza gelezo. Luꞌine hele vive angise nete hililiza okoꞌine nene di galese izi minilisaze. Gaza nene vo Oꞌmosoꞌmo gizebo o-ledelingumuꞌ gamazi nene lo sotoꞌ sotoꞌ ozo. ");
INSERT INTO aso_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Idoꞌ ve ma neꞌmo tiꞌ lo lo-imineꞌ: Guvekasi ve, nazasi nene geꞌmetelesuze. Gaza gele nemanivo neze aleve nene vo aꞌnidoꞌ do mo minilo lo alove. ");
INSERT INTO aso_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Eveneꞌ ma ingine gono di di nivilizangutiꞌ velepeꞌ izi meheꞌnida ningaaꞌ nave nete nene Oꞌmosoꞌmo gizebo o-ledelingumuꞌ ve li gono dalizadoꞌ nene lisiheꞌ isaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Neꞌmine ogo alingeꞌ nene Guvelesi veꞌmo eveneꞌ sevedi tuu (72) gohi ma do kegese-ngedo aza alingeꞌ aꞌmida vilineꞌ numuno ebeꞌ mukikuꞌ nene gomuꞌ mili nivilizave lo sitaꞌ sitaꞌ ngimiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nongimiselo tiꞌ lo lo-ngidineꞌ: Eveneꞌ mene gopo ikelizaze. Minguꞌ nene nosoꞌ niteꞌ mukiꞌ goloso o molaniꞌza aꞌminguꞌ gono dalonive nene ngomosiꞌ minekunge. Nemuꞌ nene lingine mine melehida likevo gonoloꞌ ve ma ngimiselavo vi minamuno dolizilizave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eii, lingine nene sipisipi ize angale neꞌminisa minilisave. Sipisipi ize ingine lovo veꞌinelite ngibililisa ikevo ingine aꞌmidoꞌ alete mili ngibililiza gavosoꞌine nomivo minaaꞌ naniꞌ neꞌminisa nene vi minilisave. Idoꞌ lingine vovoꞌninguꞌ vi miniliza aleve neve nene sipisipi ize ngibilaaꞌ aniꞌ loposo gulo neꞌminisa nene minilisaze. Mo vilo. ");
INSERT INTO aso_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nemuꞌ lingine vilizada nene moni goꞌzaaꞌ hanipausi nene di vami kisi di monaaꞌ goꞌ nesi di vami gizedidoꞌ suuꞌ nesi ma di vami idoꞌ akaloꞌ vilizadoꞌ nesi nene di tiꞌ militiꞌ igi evenekisi gamazi lamilo. ");
INSERT INTO aso_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Idoꞌ lingine vi numuno mauꞌ dizi ma nene aꞌmine numunguꞌ miniliza alevemuꞌ nene lengita hongu lo minaaꞌ monovo minelive li gomuꞌ li-ngidilo. ");
INSERT INTO aso_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Idoꞌ aꞌmine numunguꞌ hongu ve ma minelineꞌ nene aꞌmine hongu lo minaaꞌ monovo minelive laniꞌ ma nene aꞌmine veloꞌ mino gihile izeleseive. Idoꞌ engita hongu lo minaaꞌ monovo ma minamivo nilizaniꞌ nene aꞌmine hongu lo minaaꞌ monovo nene gohi tineꞌ molo lengita aloseive. ");
INSERT INTO aso_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Idoꞌ gonouꞌ ve nene meniꞌine dalizadoꞌ lisiheꞌ o neineꞌ nenako aꞌmine numunguꞌ nene ha mini nosoꞌ niteꞌ idoꞌ noso avoso lingimilizaniꞌ nene ni numuno neuꞌ ongoku meuꞌ ongoku li minami aꞌmine numuno hamokukovoꞌ nene ha minilo. ");
INSERT INTO aso_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Idoꞌ numuno ebeꞌ mala nivavo ingine di lamineꞌ i-lingidi lengeleꞌmize nimilavo ma nene nosoꞌ niteꞌ naniꞌmine di igi mili-lingidilizahe nene ha nalo. ");
INSERT INTO aso_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Idoꞌ initeꞌ gizi dave aꞌminguꞌ nilizaniꞌ nene di lamineꞌ i-ngidi tiꞌ li li-ngimilo: Oꞌmosoꞌmo gizebo o-lengedeli gamene nene mo avitoꞌ ogave li li sotoꞌ igi li-ngimilo. ");
INSERT INTO aso_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Idoꞌ neꞌmine ilisaniꞌza lingine numuno ebeꞌ mala nivavo gamazitine gilami di lamineꞌ i-lingidamavo ma aꞌmine numuno ebeliꞌmi aka ngomo ngomouꞌ nene nivi tiꞌ li lilo: ");
INSERT INTO aso_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Lengiꞌ monovotine goloso neineꞌ nene gililizave lo numuno ebetingutiꞌ uꞌmusupo gizedeloꞌ giꞌmize neineꞌ nene gohi lengita tileꞌ ogo do nohulune. Do nohuluneꞌza Oꞌmosoꞌmo gizebo o-ledelineꞌ gamene nene mo avitoꞌ o neive lo nolo-lingimuneꞌ nene gili minilo. ");
INSERT INTO aso_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Naza tiꞌ lo nolo-lingimuve: Gamene nabauꞌ nene aꞌmine aleve Oꞌmosoꞌmo lihime ngemelineꞌ nene eveneꞌ goloso gehepeve Sodomi aleve mulumo initeꞌ naba ngemelineꞌ nesi nene ivileꞌ ogosa naba goloso ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","Agae, Kolazini aleve idoꞌ Betesaida aleve lengikumuꞌ nene mulumo nogele-lingiduve. Lengita mulumo initeꞌ goloso alingeꞌ sotoꞌ o-lengedeleseive. Lengita ato atoꞌ suno do sotoꞌ uvoniꞌ ma nene Tilo alevetingukisi Sidoni alevetingukisi do sotoꞌ uvodiniko ingine Oꞌmosomuꞌ gilamaniꞌ aleve minikeniꞌza aꞌmingutiꞌ aleve ingine nene mo lute do velepeꞌ izekune li geti lani gisi hili initeꞌ huko pako ineꞌ nene di ngili minadine. Lingine Tilo alevemukisi Sidoni alevemukisi gilavo gamene nabala Oꞌmosoꞌmo lihime nabaꞌ naba ngemeleseive li gilaaꞌ nahe. Ne neiha engiꞌ lihime ngemelineꞌ nene ivileꞌ ivosa Oꞌmosoꞌmo lihime nabaꞌ naba goloso lengiꞌ lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Idoꞌ Kahanaumi alevekizo, lengiꞌ gulivetine nene Okulumokuꞌ dizelive li di hozi laaꞌ nahe. Lingine nene Oꞌmosoꞌmo oloꞌ galeseuꞌ lengehusoꞌ o huloloseive. ");
INSERT INTO aso_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Idoꞌ neꞌmine lo izipahala tiꞌ lo lo-ngimineꞌ: Ve ma ingine lengiꞌ gamazitine gililizave nene lengiꞌ gamazitine nogilube li gililizaniꞌ nene neniꞌ gamazi gililisave. Idoꞌ ve ma ningi goseleꞌ i-lingidi gamazitine gilamilizaniꞌ nene neniꞌ ninge goseleꞌ igi gamaziꞌne gilamilisave. Idoꞌ ve ma neniꞌ ninge goseleꞌ igi gamaziꞌne gilamilizaniꞌ nene nimiselive eiꞌ nene ningi goseleꞌ i-di gamaziꞌve gilamilisave. ");
INSERT INTO aso_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Neꞌmine lo ngimiselavo aꞌmine eveneꞌ sevedi tuu (72) nene visa gohi tineꞌ mili igi muluꞌninguꞌ laniteꞌ goloso gili ngolize iziꞌmi igi tiꞌ li laniꞌ: Guvetesi ve, geiꞌ guliveka ogo sikalahuꞌ golosomukisi gamazi luneꞌ nene inginesi ha gili di vaaꞌ ave. ");
INSERT INTO aso_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Neꞌmine li likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine neꞌmine navo Satani nene gopaꞌna neꞌmino Okulumokutiꞌ veleheꞌ limineꞌ gelavo ningekuve. ");
INSERT INTO aso_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gilahe. Naza nene amuzo mo lengemekuvoniꞌ nenako neꞌmo nene lingine satatoꞌ lisilizanikisi idoꞌ eveneꞌ ngibilaaꞌ aniꞌ initeꞌ netesi nene ngeli di goloso i-lingidamilisave. Ee, naza Sataniꞌmi amuzo ato atoꞌ vaiꞌ nene ivileꞌ ivosa amuzo mo lengeme nouvoniꞌ neꞌmo nene initeꞌ hamolitesi lengiꞌ nene ngeli di goloso i-lingidamilisave. ");
INSERT INTO aso_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Neꞌmine o neineꞌza sikalahuꞌ goloso nete lengiꞌ gamazitine gili di vaaꞌ naniꞌ nemuꞌ nene gilikevo dizavo longolize izami asi Oꞌmosoꞌmo do nguꞌ izeliveti guliveꞌine gizinguꞌ lengiꞌ gulivetinesi Okulumokuko gize neineꞌ nemukovoꞌ nene gilikevo dizavo longolize izi minilo. ");
INSERT INTO aso_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Idoꞌ Izesuꞌ neꞌmine lo nolo-ngidivo mo aꞌmidoꞌ Oꞌmosoꞌmi Sikalahuliꞌmo do ote-davo olize noizo tiꞌ lo lineꞌ: Meꞌneho ve, gaza Okulumoꞌ misubo gizebo o mino Guvekasi ve minanivelike, naza lo sotoꞌ ogo noluvoniꞌ gamazi mene evenelite gilikevo eveneꞌ ma gili nge li gamazi monovo gilaaꞌ ave minaniꞌ nete aꞌmineꞌmi monovo nene ningi gilikelizave lo gaza do halekosa aꞌmine monovo nene eveneꞌ izipe ngomo neꞌmine mini initeꞌ mukiliti monovomuꞌ olihe gilamavemuꞌ do sotoꞌ o-ngedaineꞌ nemuꞌ nene isaaꞌ neve nolo-giduve. Ee, Meꞌneho ve, gaza neꞌmine olosa lamineꞌ gelo neꞌmine aineꞌ nemuꞌ nene isaaꞌ neve nolo-giduve. ");
INSERT INTO aso_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Neꞌmine lo gohi tiꞌ lo lineꞌ: Meꞌneho aza initeꞌ mataꞌ mukiꞌ nene aꞌneuꞌ molave. Idoꞌ Oꞌmosoꞌmi gipele neniꞌ nene Oꞌmosoꞌmi gipele ve li ningi ma gilamave. Meꞌneho eiꞌ neꞌmovoꞌ nene ningo gele neive. Idoꞌ meꞌnehinemukisi nene zaho nehe ma ningi gilamavo gipele nenikovoꞌ nene ningo gele nouvonako ezemuꞌ nene eveneꞌ masi gililizave lo eze monovo lo sotoꞌ o ngemeloniꞌ alevesi lelikovoꞌ nene meꞌnehinemuꞌ ningo gele minelesune. ");
INSERT INTO aso_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Idoꞌ mine velepeꞌ izo izipahala zuho vonuꞌ nongebelo engikumukovoꞌ tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ ma lo-lengemelove. Gomuꞌ polohete minaniꞌ netesi idoꞌ guveꞌinesi ve linge ma netesi ingine neniꞌ ogo molo nouvoniꞌ initeꞌ idise lingine nininganiꞌ memuꞌ nene ningelobo li gilaniꞌza ma ningamaniꞌ ve. Idoꞌ laaꞌ nouvoniꞌ gamazi idise lingine gatinedunuꞌ nigilaniꞌ nene gelelobo li minaaꞌ aniꞌza gilamaniꞌ ve. Nemuꞌ nene aꞌmine ningi gili nizaniꞌ initeꞌ nene Oꞌmosoꞌmo initeꞌ gihile nene lengeme neize. Longolize izi minilo. ");
INSERT INTO aso_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Idoꞌ Zuda velite monoꞌ gozopotatiꞌ laaꞌ aniꞌ sukulu naba lo monekive maliꞌmo oto Izesuꞌni emenguꞌ nomolo tiꞌ lo lineꞌ: Tisazo, Oꞌmosoꞌmo minevoꞌ minevoꞌ nemeni dameni nemelineꞌ nene naza nadiꞌ okuvosa nemelive. ");
INSERT INTO aso_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Neꞌmine lo longoꞌ o-davo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza longoꞌ o-nidaineꞌ gamazimuꞌ nene Oꞌmosoꞌmi louꞌ gamazi neuꞌ nene nadive li gizi nizavo gataaꞌ nane lo longoꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Longoꞌ o-davo Gozopoꞌ laaꞌ aniꞌ monoꞌ apize ngemaaꞌ ive aza tiꞌ lo lo-imineꞌ: Oꞌmosoꞌmi louꞌ gamaziuꞌ nene tiꞌ li gizi nizave: Lutine gatine vodinesi amuzotine vaiꞌ nesi nene Guvelesi ve Oꞌmosotida nene mili osuꞌ li lutine imivoꞌ minilo. Idoꞌ lingine lengiꞌ okodinemuꞌ gilaaꞌ naniꞌ neꞌmine igi eveneꞌ avita gidini nizavemukisi nene gilii lutine ngimilo. ");
INSERT INTO aso_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza mo lamineꞌ gehepeve laange. Minevoꞌ minevoꞌ ogaꞌ gemeni dameni doo mineliningisi gaza laineꞌ neꞌmine ozo. ");
INSERT INTO aso_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Neꞌmine lo-davo aꞌmine ve aza ovozo helo ovozo hilineꞌ akaꞌve hize tilelove lo gelo Izesuꞌni tiꞌ lo longoꞌ o-dineꞌ: Idoꞌ aꞌmine Oꞌmosoꞌmi louꞌ gamazi nene eveneꞌ avita gidini nizave lutine ngimilo lineꞌ nene zamotine zamotine lute ngemeloningumuꞌ live. ");
INSERT INTO aso_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Leliꞌ Zuda veutiꞌ ve ma aza Zelusalemi numuno ebeꞌ hulo Zeliko numuno ebeta lemo novivo lasikoli nete akaloꞌ novidoꞌ ningi initeꞌ mataꞌve ipeꞌ igi di bili huli akaloꞌ iki vikevo helaatoꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Neꞌmino ongo neivo eze mulumolo ningo do lamineꞌ o-delidoꞌ o minive gehepeve leliꞌ Zuda veutiꞌ eveneꞌ gohi ma evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nene aꞌmine akaloꞌ nene lemo vilineꞌ ogavo lemo novo aꞌmine bili hulikave nene ningo ninge hulo-do aka do zovoꞌ izo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vavo aꞌmineꞌmine ogo monoꞌ numuno nabauꞌ gono daaꞌ ive Leviꞌ aꞌvopilemokutiꞌ ve ma nene aꞌmida lemo ogo aꞌmine bili hulikave nene ningo aka do zovoꞌ izo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vavo Zuda ve leliꞌ biluvaꞌ Samalia ve ma nene Zuda ve sitaꞌ vasidiꞌmine ogo vo bili hulikave nene ningo muluno goloso hukavo ");
INSERT INTO aso_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","neida vo biladoꞌ nene holo-ngedaaꞌ initeꞌ uvelisi vaini nososi nene holo-do banisi like-do eleꞌmizo do hozi lo dongi izeꞌveloꞌ nene molo-do makaꞌ eleꞌmizo do vo venenga ve meni hizi ingaaꞌ aniꞌ numunguꞌ nene do lamineꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Neꞌmine igi ingi goꞌ lavo Samalia ve aza mo volosa aꞌmine venenga ve ingaaꞌ aniꞌ numudoꞌ gizebo ve nene moni tu kina (K2) ma noemo tiꞌ lo lo-dineꞌ: Gaza ve mene gizebo lamineꞌ o-dezo. Neꞌmine o-do nanivo moni nene osuꞌ lavo eiꞌ okoꞌnoloꞌ initeꞌ naniteꞌ haza o-delibe naza tineꞌ molo alodoꞌ nene ogo bekimi ogo meni gemelesuve. ");
INSERT INTO aso_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Neꞌmine lo lineꞌ nemuꞌ nene gaza nadive lo gele nane. Eveneꞌ setihami aniꞌ neutiꞌ nene akaloꞌ bili hulikave neꞌmi evenele avita gidini minive nene zaho minive. ");
INSERT INTO aso_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Neꞌmine lavo gozopotatiꞌ laaꞌ aniꞌ monoꞌ apize ngemaaꞌ ive aza tiꞌ lo lo-imineꞌ: Muluno goloso hukive neve ne neive. Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza vo eiꞌ ineꞌ neꞌmine ogo minelesane. ");
INSERT INTO aso_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Neꞌmine lo nelotiꞌ akaloꞌ gohi vi numuno ebeꞌ ngomo ma mininguꞌ vi hetelaniꞌ. Vi hetelikevo aꞌmine numudoꞌ nene veneꞌ ma minineꞌ gulive Mataꞌ aza Izesuꞌni nene eiꞌ numuꞌveuꞌ eleꞌmize molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aꞌminguꞌ nene Mataꞌ alunolo ma minineꞌ gulive Maliaꞌ aza nene ogo Guvelesi veꞌmi gizenela mino gamaziꞌve gelo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Neꞌmino neivo Mataꞌ aza nosoꞌ nitekisi initeꞌ vaikisi do lisiheꞌ ogo mino gono mene mo nivizelineꞌ ogave lo gelo Izesuda vo tiꞌ lo lo-imineꞌ: Guvekasi ve, aluꞌne nene ninge lede-nimikivo gono naba mene nenikovoꞌ do nouvoniꞌ nemuꞌ nene ma gelamabe. Gaza lo-danivo ogo hize eleꞌ o-nidivo makatoꞌ gono dalosive. ");
INSERT INTO aso_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Neꞌmine lavo Guvelesi veꞌmo tiꞌ lo lo-imineꞌ: Eii, Matazo, gaza nene initeꞌ mukikumuꞌ gaka mukiꞌ gelo mulungauꞌ nene goloso nogelaineꞌza ");
INSERT INTO aso_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","initeꞌ hamokumukovoꞌ geleloneꞌ o neineꞌ nenako Maliaꞌ nene aꞌmine initeꞌ lamineꞌ nene dalosa gelave. Nemuꞌ nene laza dalineꞌ aka nene ma hize tile-damolosusive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gamene ma Izesuꞌ aza ebeꞌ maloꞌ Oꞌmosola lo minineꞌ nene osuꞌ lavo izipahala zuhoutiꞌ maliꞌmo Izesuꞌni tiꞌ lo lo-imineꞌ: Gaza nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ Oꞌmosola laakumuꞌ izipahala zuho apize ngimineꞌ maꞌmino leze apize lemevo. ");
INSERT INTO aso_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Oꞌmosola nili ma neꞌminisa lilo: Meteho ve, Geiꞌ guliveka nene eveneꞌ vaiꞌ gelekunivo dizosa miniliho. Idoꞌ eveneka gizebo o-ledelineꞌ nene lelita mudise sotoꞌ iliho. ");
INSERT INTO aso_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Idoꞌ naloneꞌ nosoꞌ nitete nene gamene gamene lemezo. ");
INSERT INTO aso_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Idoꞌ lihime di-lidave mukiliti lihimeꞌine nene mo hulo-ngedaaꞌ nouneꞌ nenaze. Aꞌmineꞌmine ogo leze lihimete nene hulo-ledezo. Idoꞌ lemenguꞌ molaaꞌ akaloꞌ nene leleꞌmizo vamozo. ");
INSERT INTO aso_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Neꞌmine lo lo-ngemo tiꞌ lo lo-ngimineꞌ: Lengikutiꞌ ve maliꞌmo okise ongo velepeꞌ izaaꞌ gameneloꞌ nene zogo veꞌmi numuda vo tiꞌ lo lo-emelihe: Zogone, neniꞌ zogone ma aza aka haꞌnatiꞌ ogo nohetelineꞌza nosoꞌ niteꞌ emeloniꞌ ma nomize. Beleti setohamo neꞌmine ma lehize-nedevo. ");
INSERT INTO aso_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Neꞌmine loloseineꞌza zogo ve ongo minelineꞌ neꞌmo nene numuno luloukotiꞌ nene tiꞌ lo ha lilidoꞌ o neihe: Idise akahe tile neivo veneꞌ izipahaꞌne zuhosi ongo noninguꞌ nene goseleka lo-ledamozo. Naza oto initeꞌ ma ngelo gemamolosuve lilihe. ");
INSERT INTO aso_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Oꞌove. Neꞌmine lamoloseive. Asi aꞌmine ongo minive nene zogo ve nolinekisi nene initeꞌ ma emelesa gelamo ongo minelineꞌza ongalosa nouninguꞌ mene lihiteheka lo minalive lo oto aꞌmine viseꞌ ineꞌ initeꞌ nene ha do emeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Neꞌmine oloseinako naza tiꞌ lo nolo-lingimuve: Initeꞌ ma dalone li Oꞌmosola lilizave mukiꞌ nene initeꞌ ha dalisave. Idoꞌ Oꞌmosolatiꞌ nene initeꞌ ma viseꞌ ilizave nene ha ningilisave. Idoꞌ akaheloꞌ okohoꞌ izilizave nene Oꞌmosoꞌmo ha siꞌze-ngedeleseive. Nemuꞌ linginesi Oꞌmosola initeꞌ mamuꞌ longoꞌ ilizaniꞌ nene ha lengemeleseive. Idoꞌ viseꞌ ilizaniꞌ nene Oꞌmosoꞌmo ha lengelebizeleseive. Idoꞌ akaheloꞌ okohoꞌ izilizaniꞌ nene Oꞌmosoꞌmo ha siꞌze-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Idoꞌ lengikutiꞌ gipeleꞌmo alahakumuꞌ ma lilineꞌ nene meleho zaholike alahaꞌ ma do emamo sataꞌ ma do emeline. ");
INSERT INTO aso_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Idoꞌ okoloho mulomuꞌ lilineꞌ nene gaza ongovusoꞌ belelineꞌ initeꞌ sataꞌ gazehe nevoꞌmine emelibe. ");
INSERT INTO aso_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Lingine nevo ha eveneꞌ golososi nilizaha izipahatine zuho nene ha gizebo lamineꞌ i-ngidi initeꞌ lamineꞌ nene ha ngimaaꞌ nave. Nemuꞌ nene linginesi lingivileꞌ ogo lamineꞌ minive Okulumokuꞌ metibo neꞌmo nene eveneꞌ ingine vokuꞌ li ezela laaꞌ nave nene Sikalahuꞌve lehize-lengedamilihe. Oꞌove. Mo atoliꞌmine ogo lehize-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sikalahuꞌ golosoliꞌmo ve maliꞌmi lulouꞌ mino vele hize langoloꞌ ogavo gamazi lamiveꞌmi luloutiꞌ nene gamene ma Izesuꞌ aza sikalahuꞌ goloso imisele hulavo aꞌmine ve aza gamazi apiꞌ ogo laaꞌ ineꞌ. Neꞌmine ogavo eveneꞌ nene voꞌine goloso vineꞌza ");
INSERT INTO aso_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","linge ma nete tiꞌ li laniꞌ: Ve mene sikalahuꞌ goloso ngimiselo do nohulineꞌ nene sikalahuꞌ golosoliti guveꞌinesi ve Belezebulodatiꞌ nene amuzo do minosa neꞌmine neive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Idoꞌ linge ma nete emenguꞌ mili tiꞌ li laniꞌ: Okulumokuꞌ minive aza geikisi nolineꞌ nene amuzo gemavo atoliꞌmine suno ma do sotoꞌ oganivo ningelone li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Neꞌmine laniꞌza Izesuꞌ aza luꞌninguꞌ gamazi gili minaniꞌ nene ningo nogelo tiꞌ lo lo-ngimineꞌ: Misubo mauꞌ minilizaniꞌ aleve ingine nene hizi hoꞌli mini lovo hizilizaniꞌ nene mo eveneꞌ simeꞌ nikevo ebeꞌ nene gaꞌmeꞌ pizeleseive. Idoꞌ vani hamoliꞌmi izipahalalite hizi hoꞌli mini lovo hizilizaniꞌ nene ingine mo hutileꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Idoꞌ aꞌmineꞌmine ogo neze nene Belezebulodatiꞌ amuzo do sikalahuꞌ goloso nene ngimiselo do nohulive laaꞌ naniꞌ nene Satani aza eze zuhosi hoꞌli ato atoꞌ minadiniko aꞌmine zuho nene ngeli eleꞌvoleꞌ igi minadibe. Oꞌove. Mo limi ingi vi gopoꞌ napaꞌ adine. ");
INSERT INTO aso_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Idoꞌ nenikumuꞌ nene Belezebulodatiꞌ amuzo dosa sikalahuꞌ goloso nene ngimiselo do nohulive nilahe. Idoꞌ lengiꞌ zuholite sikalahuꞌ goloso ngimiseli hulaaꞌ aniꞌ ma nene amuzo zahidatiꞌ disa neve. Lingine engikumuꞌ nene Belezebulodatiꞌ amuzo disa sikalahuꞌ goloso nene ngimiseli nihulave li ma li-ngidadiniko lengiꞌ nene mo di gonitoꞌ i-lingidadine. Oꞌove. Ingine Belezebulodatiꞌ amuzo damaaꞌ aniꞌ neꞌmino nazasi ezelatiꞌ damo Oꞌmosolatikovoꞌ amuzo daaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Idoꞌ sikalahuꞌ goloso ngimisele hulaaꞌ nouvoniꞌ nene Oꞌmosoꞌmi amuzodunuꞌ neꞌmine ogaꞌ nooloniꞌ nene Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ogaꞌ amuzoꞌve nene lengita mo do sotoꞌ ogo nolengelebizive. ");
INSERT INTO aso_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Idoꞌ amuzo malehe ve maliꞌmo gimise elese ogo mino numuꞌveloꞌ gizebo ogo minelineꞌ nene initeꞌ mataꞌve mukiꞌ nene lamineꞌ ha mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ha mineleseineꞌza eze nene ivileꞌ ogo amuzo ve ma minelineꞌ neꞌmo ogo lovo o emo ivileꞌ ilineꞌ nene aza gimise elese mene do nouvoniꞌ neꞌmo nene nivileꞌ amilisave lo gele eleꞌvoleꞌ ineꞌza ivileꞌ ogo aꞌmine gimise elese ipeꞌ ogo do hulo initeꞌve nene izeꞌ molo ngemeleseive. Aꞌmineꞌmine ogo naza Satani ivileꞌ okuve. ");
INSERT INTO aso_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Idoꞌ ve ma ingine nenita giꞌmizi minamave nene neniꞌ lovo i nimaaꞌ ave nene nizave. Idoꞌ ve ma ingine nenikisi makaꞌ mino eveneꞌ do nenita amunive nene eveneꞌ ngimiseli di hutileꞌ i huli-ngidaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sikalahuꞌ goloso maliꞌmo ve maliꞌmi lulouꞌ miningutiꞌ hulo-do vilineꞌ nene mine gelo minelineꞌ ebekumuꞌ nene ebeꞌ gokota visetoꞌ voloseive. Vo viseꞌ ilineꞌza ma ningamilineꞌ nene tiꞌ lo loloseive: Naza ganaꞌ hulo uvoniꞌ numuꞌne mala tineꞌ molo volove. ");
INSERT INTO aso_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Neꞌmine lo tineꞌ molo ogo ningelineꞌ nene pipiaꞌ gisi di lisiheꞌ ikeniꞌ neiha eveneꞌ nizamaniꞌ neivo ningeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ningo gohi vo sikalahuꞌ goloso seveni eze ivileꞌ igi goloso naba gehepeve minaniꞌ nene ngeleꞌmizo ogavo aꞌminguꞌ dizi aꞌmine veꞌmi lulouꞌ nene ingine numuꞌine loloꞌ ogavo minilizaniꞌ nene gomuꞌ aꞌmine ve minaaꞌ ineꞌ nesi ivileꞌ ogosa goloso nabaloꞌ mine molo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tiꞌ lo nolivo eveneꞌ di geseꞌ aniꞌ muliseutiꞌ veneꞌ ma minidiꞌmo vise lo Izesuꞌni tiꞌ lo lo-imineꞌ ve: Geiꞌ nene gedosa amineꞌve gimineꞌ veneꞌ nene Oꞌmosoꞌmo noꞌnohoꞌ ize-do do lamineꞌ o-de neineꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Neꞌmine lineꞌza Izesuꞌ tiꞌ lo lineꞌ: Ne neiha asi Oꞌmosoꞌmi gamazi gili aꞌmidoꞌ eꞌmetaaꞌ nave nene Oꞌmosoꞌmo noꞌnohoꞌ ize-ngedo do lamineꞌ o-ngede neineꞌ ma neive loloneꞌ nene lamineꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Neꞌmine lo-ngemo neivo eveneꞌ ikaꞌ ikaꞌ igi vaiꞌ nilavo Izesuꞌ aza apiꞌ ogo tiꞌ lo lo-ngemeꞌmo vineꞌ: Mene gameneloꞌ mine do nouvoda ningi nizave lingine nene eveneꞌ golosovoꞌ minii nenikumuꞌ atoliꞌmine initeꞌ do sotoꞌ ogo Oꞌmosoꞌmo amuzo nimineꞌ nene lengelebizelongumuꞌ nilaniꞌza ma lengelebizamuvo Oꞌmosoꞌmo gozopoꞌ eze veletiꞌ gamazi lo sotoꞌ ogaꞌ ive Zonada atoꞌ suno do sotoꞌ ogo amuzoꞌve ngelebizineꞌ maꞌminevoꞌ ma nenita sotoꞌ ogavo neve ningilisave. ");
INSERT INTO aso_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aꞌmine ningilizaniꞌ initeꞌ nene Zonada atoꞌ suno sotoꞌ ogavo Nineve alevete ninganiꞌ neꞌmino idise mene nizaniꞌ aleve lengitasi nene Oꞌmosolatiꞌ ve gihile nenita nene initeꞌ ma sotoꞌ ogavo ningilisave. ");
INSERT INTO aso_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Idoꞌ guvelesi veneꞌ naba aza emala misubo monovo liginela gizebo o minineꞌ misubo Seba nene hulo avotemoti guveꞌinesi ve naba Solomoniꞌ laaꞌ ineꞌ gamazi lamineꞌ nene gelelesa aka haꞌna haꞌna goloso aniꞌza neniꞌ nene Solomoniꞌni ivileꞌ ogo mino mela lengiꞌ vovotinguꞌ sotoꞌ ogo mino gamazi lamineꞌ noluvoniꞌ nene lingine gilisaꞌmave. Nemuꞌ nene gamene nabala aꞌmine guvelesi veneꞌ naba neꞌmo nene oto lihimetine lo sotoꞌ ogo goniꞌ o-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Idoꞌ Nineve aleve ingine Zonaꞌ monoꞌ gamazi lo-ngimineꞌ nene gilii luꞌine di velepeꞌ izaniꞌza lingine giliꞌnalo. Naza Zonaꞌni ivileꞌ ogo minuve mene ogo lengiꞌ vovotinguꞌ mino gamazi lo-lingimuvodoꞌ nene gilii lutine di velepeꞌ izamanako gamene nabala nene Nineve aleve nete oti lengiꞌ lihimetine li sotoꞌ i-lingidi gonitoꞌ lengeleꞌmizi milalisave. ");
INSERT INTO aso_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ve ma lamu viteꞌ igisa galese lulouꞌ nehe idoꞌ somo lulouꞌ nehe nene ma haleki milamilisave. Asi eveneꞌ numunguꞌ dizilizave hize labanaꞌ ele-ngedelingumuꞌ nene sotoꞌ lamu molaaꞌ holomoloꞌ milalisave. ");
INSERT INTO aso_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Eveneꞌ voloneꞌ akate nene vete neꞌmo oloꞌ liviꞌ neꞌmino mino do sotoꞌ o-ledaaꞌ neive. Idoꞌ lukaliꞌmi vele lamineꞌ ha minelineꞌ nene Oꞌmosoꞌmo okonga luka mukiꞌ nene hize labanaꞌ ele-gedeleseive. Idoꞌ lukaliꞌmi veleꞌve goloso o nolineꞌ neꞌmo nene okonga lukauꞌ litiꞌmusovoꞌ ize vaiꞌ lo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ve ma gaza lukauꞌ nene labanaꞌ neivo nouhe lo gelo nanivo lukauꞌ litiꞌmuso ize mininekisi minalinge. Eheꞌ ogo minezo. ");
INSERT INTO aso_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Idoꞌ geiꞌ okonga lukauꞌ nene litiꞌmuso ngomosiꞌ minamo labanaliꞌmo vaiꞌ lo minelineꞌ nene lamu hize labanaꞌ goloso ele neineꞌ gelavo luka okonga mukikuꞌ nene labanaꞌ goloso elo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Idoꞌ Izesuꞌ aza gamazi lo-ngemo minineꞌ nene osuꞌ nolivo Halisaioꞌ ve maliꞌmo nosoꞌ nitekumuꞌ elese molo imineꞌ. Neꞌmine ogavo Izesuꞌ aza numunguꞌ dizo nosoꞌ niteꞌ nalosa nosoꞌ niteꞌ naaꞌ holomoloꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Neꞌmine ogo nosoꞌ niteꞌ no neivo Halisaioꞌ ve aza ningineꞌ nene Izesuꞌ aza Zuda ve engiꞌ monovoloꞌ eꞌmeto ana gomuꞌ nosoꞌ ize hulamo nosoꞌ niteꞌ nonavo ningo gopo gala gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Neꞌmine neivo Guvelesi veꞌmo tiꞌ lo lo-imineꞌ: Gaza gelezo. Halisaioꞌ ve lingine nene kapu idoꞌ lapese naba heta eveneꞌ ningilizadavoꞌ nosoꞌ izaaꞌ naniꞌ neꞌminisa nene nizaniꞌza lutinguko nene gumine damineloꞌ monovo idoꞌ monovo goloso nene vaiꞌ lo neive. ");
INSERT INTO aso_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lingine mo negi nizave. Oꞌmoso neꞌmo initeꞌ okoꞌno heta loloꞌ ogosa lulouko nesi nene aꞌmineꞌmine ogosa loloꞌ o neineꞌ nemuꞌ nene gilamahe. ");
INSERT INTO aso_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Idoꞌ lutinemuꞌ nene lo-lengemelove. Lingine eveneꞌ ma ngeleꞌmizi lamineꞌ ilisa initeꞌ ma ngimaaꞌ ilizaniꞌ neꞌmo lutinguꞌ goloso minineꞌ ma nene do lamineꞌ ogavo lisiheꞌ lamineꞌ minilisave. ");
INSERT INTO aso_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Neꞌmine ilisaniꞌza lingine Halisaioꞌ ve nene ehetineꞌ neve. Lingine Moseꞌ louꞌ gamaziloꞌ ma gili dii minguꞌ initeꞌ ngomo ngomo nosoꞌ niteꞌ do laniteꞌ ogaꞌ ineꞌ initeꞌ nevoꞌmingutiꞌ linge ngomo nene izeꞌ mili Oꞌmoso imaaꞌ naha louꞌ gamazi ma adoꞌ eveneꞌ nene monovo lisihekovoꞌ i-ngidilo idoꞌ lutine Oꞌmoso imilo lo neineꞌ ma nene gili hulaaꞌ naniꞌ nene Moseꞌ louꞌ gamaziloꞌ eꞌmeti minguꞌ initeꞌ ngomo ngomo Oꞌmoso imaaꞌ naniꞌ neꞌmini ha gili dalizanako gili disaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Idoꞌ Halisaioꞌ ve lingine monoꞌ numunguꞌ numunguꞌ eveneꞌ nabalitevoꞌ minaaꞌ aniꞌ holomolokovoꞌ minilisa gilaaꞌ naniꞌ nemukisi idoꞌ maketiloꞌ eveneꞌ muliseuꞌ siza li-lidilizave lii gilaaꞌ naniꞌ nemukisi nene ehetineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Lingine gonoso galese sotoꞌ igi minami haleki nizavo eveneꞌ gopo aꞌmidoꞌ lisi moni goloso igaꞌ naniꞌ neꞌmine gonoso galese gili minaniꞌ nemuꞌ nene agae, ehetineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Izesuꞌ neꞌmine lavo louꞌ gamazi apize ngemaaꞌ ive maliꞌmo Izesuꞌni tiꞌ lo lo-imineꞌ: Tisazo, gaza neꞌmine nolaineꞌ nene lelikisi nolelemaineꞌ gelave. ");
INSERT INTO aso_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Louꞌ gamaziloꞌ sukulu naba li monikeve lingine louꞌ gamazi ngomoꞌ nabaꞌ di nubuho igi eveneꞌ gili dalizave li geniꞌvesi louꞌ gamazi vaiꞌ nene gataꞌnidoꞌ gihi-ngidaaꞌ nave. Gihi-ngidaaꞌ naniꞌza aꞌmine geniꞌvesi louꞌ gamaziutiꞌ louꞌ hamoꞌ ma ngomo lasolo neꞌminesi langisetine ma gihisaꞌmaniꞌ nenako nemuꞌ nene agae, ehetineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Idoꞌ gozopoꞌ polohete minave nene avotingelite ngibili hilaaꞌ aniꞌ ve. Neꞌmine adoꞌ nene lingine imineꞌ mili aꞌmine poloheteliti gonoso galeseloꞌ nene gono di di lamineꞌ igaꞌ naniꞌ nemuꞌ nene ehetineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ee, avotingelite polohete ngibilikevo hilaveti gonoso galeseꞌnidoꞌ nene lingine gono di di lamineꞌ igaꞌ naniꞌ neꞌmo avotingelite igi mili igaꞌ adoꞌ nene hize eleꞌ i-ngidaaꞌ naniꞌ monovo nene di sotoꞌ ikeve. ");
INSERT INTO aso_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nemuꞌ nene gele vevesaaꞌ ive Oꞌmoso neꞌmo tiꞌ lo lave: Polohetesi idoꞌ aposolokisi ngimiselekuvo engita vi gono nidavo linge ma nene ngibili hili idoꞌ ma nene goboni malaꞌ malaꞌ i-ngidilisave. ");
INSERT INTO aso_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Neꞌmine ilizaniꞌ neꞌmi lihime nene gamene galaꞌmuda vomine Oꞌmosoꞌmo misubo do sotoꞌ idatiꞌ polohete ngibiliꞌmi igi mini idisesi ngibiliꞌmi vi nizaniꞌ lihime nene lengiꞌ idise mene gameneloꞌ nizaniꞌ aleve neti okodida dizeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ee, naza laminetoꞌ nolo-lingimuve. Abeliꞌni uvolohoꞌmo bele hilidotiꞌ nene polohete neꞌmine ve mukiꞌ ngibili hiliꞌmi dizi Zakaliaꞌni Oꞌmoso lehizi-daniꞌ initeꞌ olokuꞌ gizaaꞌ aniꞌ holomosi idoꞌ monoꞌ numuno naba nesi olusoꞌ neivo bili hiladoꞌ ivo ngibili hilaniꞌ neti lihimeꞌine nene idise mene gameneloꞌ nizaniꞌ aleve neti okodida dizeleseive. ");
INSERT INTO aso_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Idoꞌ louꞌ gamaziloꞌ sukulu naba li monikeve lingine nene monoꞌ monovo gele ngoloꞌ laaꞌ amuzo nene di minilizanako mo hulikeve. Ee, langisetine nene monoꞌ monovo gili ngoloꞌ lami eveneꞌ ma monoꞌ gili ngoloꞌ lilisa ave nene akaꞌine hizi tili-ngidaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Neꞌmine loo numungutiꞌ lemo novivo louꞌ gamazi apizi ngimaaꞌ avesi Halisaioꞌ vesi ingine Izesuꞌ nene gamazi do gopo ogo ma lilineꞌ nene analoꞌ do goniꞌ o-delone li amuzo mili golo izi longoꞌ ato atoꞌ vaiꞌ goloso i-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Neꞌmine navo eveneꞌ vaiꞌ goloso tauseni neꞌmine igi di nubo igi gikiꞌ igi okoꞌnidoꞌ okoꞌnidoꞌ igi nizavo Izesuꞌ aza izipahala zuho nene do gomuꞌ molo-ngedo apiꞌ ogo tiꞌ lo lo-ngimineꞌ: Halisaioꞌ monoꞌ laaꞌ avetidatiꞌ zisiti bekini paula gele vineꞌ nene dikelizaze. Lingine ningisa minilo. Zisitimuꞌ noluvoniꞌ nene ingine luꞌninguꞌ monovo goloso di haleki mini goꞌine izi eveneꞌ lisiheꞌ gili monaaꞌ naniꞌ monovoꞌinemuꞌ nene zisitiloꞌ lo molo noluve. ");
INSERT INTO aso_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Idise mene hito neineꞌ initeꞌ mukiꞌ nene sotoꞌ ogavo ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nemuꞌ nene lingine sunoꞌ haleki litiꞌmusouꞌ neꞌmine lengikovoꞌ laaꞌ naniꞌ gamazi nene eveneꞌ mukilite sotoꞌ gililisave. Idoꞌ lengiꞌ numudinguꞌ lengikovoꞌ mini nununga li lilizaniꞌ gamazitine nene numuno oꞌmota mini asi naba li li sotoꞌ i-lingidilisave. ");
INSERT INTO aso_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Idoꞌ zogo zuhokizo, naza tiꞌ lo nolo-lingimuve: Eveneꞌ ingine lingibili hilisa aꞌmidotiꞌ nene gohi gohi ma di goloso i-lingidilizaniꞌ nomize. Nemuꞌ nene engikumuꞌ golise gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gilamilizaniꞌza goliseꞌve gili-dilizave nene lo-lengemelove. nGebele helosa voꞌine haza nesi mudise ngebelo hulo olokuꞌ ogaꞌ amuzoꞌvesi minive eiꞌ nemukovoꞌ nene goliseꞌve gililo. Ee, mo laminetoꞌ nolo-lingimuze. Goliseꞌve gililo. ");
INSERT INTO aso_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Gilahe. Nama ngomo ngomo osoꞌmohoꞌ neꞌmine nene haza initeꞌ ve li gili guleheꞌ moni ngomo sitaꞌ nene huli nama faef (5) meni hizaaꞌ nave. Neꞌmine igaꞌ naniꞌza Oꞌmosoꞌmo gizebo o-ngedo minidotiꞌ nene hamokisi ma gala molosaꞌmive. ");
INSERT INTO aso_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne neiha lengita initeꞌ ngomo lasolosi goloso ogalive lo godotine zopovo mukiꞌ nene gate osuꞌ lo nelokisi gizebo ogaꞌ neive. Idoꞌ nama ngomo ngomo mukiꞌ nesi nene ngivileꞌ igi lingine initeꞌ naba nizanaze. Nemuꞌ lingine nene golise gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Idoꞌ naza tiꞌ lo nolo-lingimuve: Ve ma ingine eveneliti veꞌnidoꞌ neniꞌ evenele none li li sotoꞌ ilizaniꞌ nene Oꞌmosolatiꞌ ve gihile naza aꞌmineꞌmine ogo Oꞌmosoꞌmi angeloliti veꞌnidoꞌ engikumuꞌ nene neniꞌ eveneꞌne nizave lo lo sotoꞌ o-ngedelesuve. ");
INSERT INTO aso_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Idoꞌ ve ma eveneliti veꞌnidoꞌ neniꞌ evenele nomune li lilizaniꞌ nene naza aꞌmineꞌmine ogo Oꞌmosoꞌmi angeloliti veꞌnidoꞌ ingine neniꞌ eveneꞌne nizamave lo lolosuve. ");
INSERT INTO aso_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Idoꞌ ve ma ingine Oꞌmosolatiꞌ ve gihile nenikumuꞌ gamazi goloso li-nidi divi lediviꞌ i-nidilizaniꞌ nene Oꞌmosoꞌmo aꞌmine lihime nene ha apase-ngedeleseineꞌza Oꞌmosoꞌmi Sikalahuꞌ nemuꞌ gamazi goloso li-di divi lediviꞌ i-dilizaniꞌ nene Oꞌmosoꞌmo aꞌmine lihime nene apase-ngedelidoꞌ nomive. ");
INSERT INTO aso_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Idoꞌ monoꞌ numunguꞌ nehe ngamani nabala nehe idoꞌ guveꞌinesi ve nabala nehe lengeleꞌmizi di vi neniꞌ neꞌmetaaꞌ nangumuꞌ goniꞌ nii-lingidavo ma nene engiꞌ liliza gamaziloꞌ nadive lolobe idoꞌ nani gamazi lolobe li gopo gatine nene gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lingine liliza gamazi nene aꞌmine gonitoꞌ lengeleꞌmize milaliza gameneloꞌ gehepeve nene Oꞌmosoꞌmi Sikalahuliꞌmo lo-lengemeꞌ lengemeꞌ ivo lilisave. Nemuꞌ nene lingine gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Neꞌmine lavo di geseꞌ igi minaniꞌ aleveutiꞌ ve maliꞌmo Izesuꞌni tiꞌ lo lo-imineꞌ: Tisazo, gaza uvoꞌnehine lo-danivo meꞌnehi initeꞌ mataꞌ nene izeꞌ molo lingela nemelive. ");
INSERT INTO aso_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Neꞌmine lo lineꞌza Izesuꞌ tiꞌ lo lo-imineꞌ: Nadiꞌ ive. Lengiꞌ goniꞌ gele-lengedaaꞌ idoꞌ initeꞌ mataꞌ izeꞌ molo-lengedaaꞌ olongumuꞌ nene zaho neleꞌmize molo neineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Minevoꞌ alevoꞌ gihile laminekisi minaaꞌ nene initeꞌ ato atoꞌ vaiꞌ minadotiꞌ nene ma sotoꞌ osaꞌmineꞌ nenako nemuꞌ nene initeꞌ gohi gohi daliza gatine nene mo kekeꞌ gilami eheꞌ igi ningisa minilo. ");
INSERT INTO aso_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Neꞌmine lo lo-ngemo gepeꞌ gamazi ma tiꞌ lo lo-ngimineꞌ: Moni heneni ve maliꞌmi miꞌveuꞌ nene nosoꞌ niteꞌ vaiꞌ goloso o molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Neꞌmine ogavo aza lulouꞌ tiꞌ lo gala gilineꞌ: Naza nosoꞌ niteꞌ dolizo do molaloniꞌ numuno nene naba nominako nadolove lo gala gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Neꞌmine ogo tiꞌ lo gilineꞌ: Naza nosoꞌ niteꞌ molaaꞌ numuno nene kuso do naba ogo gizelove. Neꞌmine ogosa aꞌminguꞌ nene initeꞌ mataꞌne lamineꞌ nesi nosoꞌ niteꞌne nesi nene molalove. ");
INSERT INTO aso_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Do molosa naza tiꞌ lo gelelove: Initeꞌ mataꞌne nene mukiꞌ goloso neinako aꞌmine nene osuꞌ lo-nidamivo kilisimasi vaiꞌ goloso ogo voloseive. Nemuꞌ nene naza mine gelo nolize izo noso avoso no nosoꞌ niteꞌ no minelove. ");
INSERT INTO aso_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Neꞌmine lo gelo lineꞌza Oꞌmosoꞌmo tiꞌ lo lo-imineꞌ: Gaza negi hize vaneꞌ mene naza geitatiꞌ vongahaza nene idise holukaꞌ dokuvo helelesainako gaza initeꞌ mataka do salani molaineꞌ ma nene zaho dalive. Gasika ha do minelibe. ");
INSERT INTO aso_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Idoꞌ eveneꞌ ma angiseꞌinemukovoꞌ ve li heneni vaiꞌ di milisa Oꞌmosoꞌmi veleloꞌ heneni neꞌmine monovo lamineꞌ engita vaiꞌ lo minamivo minavela nene aꞌmine heneni vela sotoꞌ ineꞌ suno nene sotoꞌ o-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Neꞌmine lo Izesuꞌ aza izipahala zuho tiꞌ lo lo-ngimineꞌ: Eveneꞌ okoꞌine losuvoꞌmi initekumukovoꞌ gili minaaꞌ avela nene luvoniꞌ neꞌmine initeꞌ nene sotoꞌ o-ngedaaꞌ neineꞌ nenako nemuꞌ nene naza ma tiꞌ lo nolo-lingimuve. Gaꞌnaliꞌmo helamo vetesi ha mineloningumuꞌ nosoꞌ niteꞌ nene nani nalonivo lii gopo gatine gilaaꞌ naniꞌ nene alamilo. Idoꞌ okodidokumuꞌ nene naniteꞌ ngolalonivo lii gopo gatine gilaaꞌ naniꞌ nesi nene mo alamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vetesi minevoꞌ alevoꞌ ogo minaaꞌ neꞌmo nosoꞌ niteꞌ nene ivileꞌ ogosa initeꞌ naba neivo idoꞌ okode neꞌmosi nene okodeloꞌ initeꞌ nene ivileꞌ ogo initeꞌ naba neineꞌ nenaze. Nemuꞌ nene gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Idoꞌ lingine namaliti monovo nemuꞌ nene gatine ma giliꞌnalo. Ingine naliza nosoꞌ niteꞌine nene ma zuhoꞌ igi dolizi di milaliza numuꞌine nesi nene ma nomivo ma dolizi milisaꞌmavo Oꞌmoso neꞌmo nene nosoꞌ niteꞌ ngemaaꞌ neive. Neꞌmine o-ngedaaꞌ neineꞌza lengiꞌ nete nama nene ngivileꞌ igi initeꞌ naba nizaniꞌ nenako Oꞌmosoꞌmo lengikumuꞌ nene ha gele minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Lengikutiꞌ ve zaholiꞌmo initeꞌ matakumuꞌ gopo gala ma gele do vo minelidiꞌmo eze mino molo ilineꞌve nene do haꞌna ilive. Mo ngelo ngomosi ma do haꞌna amoloseize. Nemuꞌ nene gopo gatine gilamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Idoꞌ lingine initeꞌ ngomo aꞌneꞌminesi nene ma amilizadoꞌ o neineꞌ nenako lingine initeꞌ linge ma nemuꞌ nene gopo gatine nanimuꞌ gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Guviseuꞌ guvovo initeꞌ nene dizi guvovo igaꞌ naniꞌ nemuꞌ nene ningi gililo. Ingine gono di okoꞌnidoꞌ initeꞌ nene ma ongoti ngilisaꞌmaniꞌza Oꞌmosoꞌmo do lamineꞌ o-ngedaaꞌ neive. Gozopoꞌ guvelesi ve Solomoniꞌ nene okoꞌnoloꞌ initeꞌ lamineꞌ goloso ngolaaꞌ ineꞌza naza ma lo-lengemelove. Aza ngolaaꞌ ineꞌ initeꞌ nene lamineꞌ minaniꞌza guvovo igaꞌ naaniꞌ initeꞌ nene mo ngivileꞌ isaꞌmaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Idoꞌ aꞌmine guvovo initeꞌ nene initeꞌ lamineꞌ neꞌmine minamo gamene haꞌna minesaꞌmive. Idise ha minelineꞌza aizeꞌ nene gokoꞌ lavo evenelite olokuꞌ di gizilisave. Neꞌmino neineꞌza Oꞌmoso neꞌmo aꞌmine guvovo initeꞌ nene do lamineꞌ goloso ogaꞌ neive. Oꞌmoso neꞌmo haza initeꞌ aꞌneꞌmine nene ha do lamineꞌ o-ngedaaꞌ neineꞌ nenako lengiꞌ nene guvovo initeꞌ ngivileꞌ igi initeꞌ naba nizaniꞌ nenako okodidoꞌ initeꞌ nene ma lengemamilidoꞌ o neihe. Ha lengemelidoꞌ o neive. Nemuꞌ nene lingine amuzo mili Oꞌmosomuꞌ gili eleꞌvoleꞌ ilizanako gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Idoꞌ lingine nani nalonivo li naliza initekumuꞌ viseꞌ igi gopo gatine gili minamilo. ");
INSERT INTO aso_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Misubo mukikuꞌ aleve mukiꞌ nete nene nevoꞌmine manaꞌmine gaꞌine nene gilii aꞌmine initeꞌ nene visetoꞌ minaaꞌ nave. Neꞌmine igi minaaꞌ naniꞌza Okulumokuꞌ metibo neꞌmo nene aꞌmine aꞌmine initeꞌ nene dami haza ma minamilisave lo gele neive. ");
INSERT INTO aso_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Okodine losuvoꞌmi initekumuꞌ nene gopo gatine gilami asi Oꞌmosoꞌmo gizebo o-lengedelingumuꞌ ve li eiꞌ gele neidokovoꞌ di mili aꞌmine gizebo o-lengedelingumuꞌ nene viseꞌ igi minilo. Neꞌmine ilizaniꞌ nene aꞌmine initeꞌ nesi lehize-lengedo idoꞌ okodine losuvoꞌmi initeꞌ nesi nene ha lehize-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lingine Oꞌmosoꞌmi zuho sipisipi ize mulise ngomo neꞌmine gili minave, lingine nene lengehelele izamivoo. Metibo neꞌmo eiꞌ gizebo o-lengedeli monovo lehize-lengedelesa gala gelaaꞌ neineꞌ nene laniteꞌ gele minosa gelaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lingine initeꞌ matatine nene eveneꞌ ma meni hizilisa ilizave nene ma ngimii aꞌmidotiꞌ moni dalizaniꞌ nene gohoꞌ aleve hize eleꞌ i-ngidi ngimilo. Neꞌmine ilizadiꞌmo henenitine nene Okulumokuko salani milalisave. Moni nehe initeꞌ ma nehe hanipausiuꞌ salani molaloneꞌ nene aꞌmine hanipausi nene hulupo elo hukavo doꞌmozeleseize. Okulumoꞌ nene hulupo elamilineꞌ hanipausitine neꞌmine minavosa henenitine aꞌminguꞌ salani milalizaniꞌ nene osuꞌ lamivo idoꞌ gumineloꞌ ve netesi aꞌmida vamavo idoꞌ nabaꞌ naba kolokolosi netesi nene di goloso amilisaze. Nemuꞌ henenitine nene Okulumokuko milalo. ");
INSERT INTO aso_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Idoꞌ henenitine Okulumokuko milalo noluvoniꞌ nene eveneliti lutine nene henenitine minida vo minaaꞌ neineꞌ nenako nemuꞌ ne noluve. ");
INSERT INTO aso_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Lingine nene oti lavolavotine di liki letitine nene gopodidoꞌ di izi giliꞌ li lamutine nene lo minivosa di nene igi minilo. ");
INSERT INTO aso_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Idoꞌ gizebo veꞌine veneꞌ huki mili-di nosoꞌ niteꞌ gize vataꞌ adoꞌ monosa ogo akaheloꞌ izelineꞌ liteꞌ lo siꞌze-deloningumuꞌ ve li ve ma ingine gizebo igi minaaꞌ naniꞌ neꞌmine igisa minilo. ");
INSERT INTO aso_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Idoꞌ gizebo veꞌine neꞌmo ogo ningivo okise ingami nizavo ningelive ingine nene ngolize iziliza akaloꞌ mini mili minilisave. Naza laminetoꞌ ma lo-lengemelove. Gizebo veꞌine neꞌmo ogo gonouꞌ lavolavo nene do liko lingine igi nosoꞌ niteꞌ nalo lo-ngedo asiꞌve nene nosoꞌ niteꞌ izeꞌ molo ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gizebo veꞌine holukaꞌ ongo velepetoꞌ nehe goꞌ lalosa neivo nehe ogo ningivo gelekeleꞌ izipahala ingine ha gizebo igi nizavo ningelineꞌ nene ingine mo ngolize iziliza akaloꞌ nene mini mili minilisave. ");
INSERT INTO aso_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Idoꞌ lingine mene giliꞌnalo. Gumineloꞌ veꞌmo bedineꞌ numuno neꞌmi meleho aza gumineloꞌ ve olihe amivosa alineꞌ gamenemuꞌ nene ma gele minidiniko numuꞌveloꞌ nene gizebo ogavo gumineloꞌ ve neꞌmo nene ma bedamidine. ");
INSERT INTO aso_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oꞌmosolatiꞌ ve gihile naza nene aloseive li gilamiliza gameneloꞌ alosuze. Nemuꞌ lingine nene aꞌmineꞌmine igi di nene igi minilo. ");
INSERT INTO aso_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Neꞌmine lo lavo Petoloꞌ aza tiꞌ lo lo-imineꞌ: Guvekasi ve, gaza gepeꞌ gamazi nolo-lemaneꞌ mene lelikumukovoꞌ nolo-lemabe idoꞌ eveneꞌ mukikumuꞌ nene nolane. ");
INSERT INTO aso_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Neꞌmine lavo Guvelesi veꞌmo tiꞌ lo lo-imineꞌ: Gelekeleꞌ izipe peleseveꞌ izamaaꞌ ave otohato i minave mukikumuꞌ noluve. Idoꞌ Guvelesi veꞌmo gelekeleꞌ izipe ma do kegeso eleꞌmize molo neniꞌ gelekeleꞌ izipeꞌne mukitoꞌ nene gizebo o-ngedo ingine nosoꞌ niteꞌ naliza gameneloꞌ gameneloꞌ nene nosoꞌ niteꞌ ngemekaꞌ ngemekaꞌ ogo minelive lo eleꞌmize molavo gelekeleꞌ izipe aza peleseveꞌ izamaaꞌ ive otohato o minive nolineꞌ nene aza nadiꞌ oꞌmo vo minelidoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aꞌmine do kegeso eleꞌmize molaniꞌ gelekeleꞌ izipe neꞌmo aꞌmine meleho imineꞌ gono nene dovo dovoꞌ ogo neivo Guvelesi ve ogo hetelo ningelineꞌ neꞌmo gelekeleꞌ izipe eze nene lamineꞌ ilineꞌ akaloꞌ mine molo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nemuꞌ nene naza laminetoꞌ ma lo-lengemeloze. Guvelesi ve aza ogo aꞌmine gelekeleꞌ izipe nene monovolo ningo initeꞌne mukitoꞌ nene gizebo o-nedelive lo lo-emavo gizebo o-deleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Neꞌmine ilineꞌza aꞌmine gono imive gelekeleꞌ izipe neꞌmo nene neniꞌ gizebo veꞌne ma nene mo liteꞌ lo amiko nomino gamene alingeta alihe lo gala gelo eze gizebo o-ngedo minineꞌ veneꞌ vemohoꞌ nene ngebeledoꞌ ngebeledoꞌ ogo mino nosoꞌ niteꞌ haza gidini no mino idoꞌ noso no sipaki ogo minaaꞌ noilinguꞌ nene ");
INSERT INTO aso_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","aꞌmine gelekeleꞌ izipe aza gizebo veꞌne nene ne gameneloꞌ aloseive lo gelamo ngelo amoloseive lo gelo minelineꞌ gameneuꞌ nene gizebo veꞌve ogo hetelo ezemuꞌ gili eleꞌvoleꞌ isaꞌmave o-ngedaaꞌ idiꞌmine ogo belo do goloso gehepeve o-deleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Idoꞌ gelekeleꞌ izipe maliꞌmo eiꞌ ilineꞌ initekumuꞌ guvelesi veꞌmo lulouꞌ gele minineꞌ nene ningo gele mino do vaꞌvaꞌ ogo aꞌmine luloloꞌ eꞌmetamilineꞌ nene guvelesi veꞌmo do goloso ogosa beleleseive. ");
INSERT INTO aso_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Neꞌmine oloseineꞌza gelekeleꞌ izipe gohi maliꞌmo eiꞌ ilineꞌ initekumuꞌ guvelesi veꞌmo lulouꞌ gele neineꞌ nemuꞌ ningo gelamo gavoso belelineꞌ votigileloꞌ ogo monovo goloso dalineꞌ nene guvelesi veꞌmo mo belelineꞌza nabosa belamoloseive. Oꞌmosoꞌmo vauve elo hize eleꞌ o-ngedaaꞌ neive mukiꞌ nene ingine o-ngiduvoniꞌ votigileloꞌ di mili vauve ili neniꞌ gono nene hize eleꞌ ilizave lo gelo mineleseive. Ee, Oꞌmosoꞌmo gizebo i-nidilizave lo initeꞌ vaiꞌ ngemaaꞌ neivemuꞌ nene aꞌmine ngimineꞌ initetoꞌ golo hizi initeꞌ vaiꞌ goloso di-nidilizave lo amuzo molo gele minosa aꞌminemuꞌ gizebo ogo minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Naza me misubouko lemo uvoniꞌ nene eveneꞌ engikuꞌ oloꞌ enge viteꞌ olosa uvoniꞌ ve. Agae, aꞌmine oloꞌ nene idisesi mene lo miniliko lo amuzo molo nogiluve. ");
INSERT INTO aso_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naza mulumo alumo niteꞌ gihi-nidikevo aꞌmineꞌmi lulouꞌ ma mineloniꞌ o neive. Nemuꞌ nene luꞌneuꞌ geni naba nonibilive. Aꞌmine luꞌneuꞌ geni nonibilineꞌ osuꞌ lo-nedelineꞌ nene aꞌmine mulumo alumo initeꞌ gihi-nidilizaniꞌ nene gehe pelekuvosa nene osuꞌ loloseive. ");
INSERT INTO aso_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lingine naza lemo uvoniꞌ nemuꞌ nene misubo mukikuꞌ lovo mukiꞌ nene osuꞌ lavo eveneꞌ mukiꞌ nene honguvoꞌ li minilisave li gili nizahe. Oꞌove. Naza lemo uvoniꞌ neꞌmo nene eveneꞌ hizi hoꞌli minilisave losa nolo-lingimuve. ");
INSERT INTO aso_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Neꞌmine noluvoniꞌ nene adoꞌ idise melotiꞌ nene eveneꞌ numuno hamokuꞌ ingaaꞌ aniꞌ aleve faef neꞌmine minilizangutiꞌ linge ma nenita giꞌmizikevo ma nene giꞌmizamavo hoꞌli mini setaꞌ netise setohamo nene biluvaꞌ i-ngidasivo setohamo nete setaꞌ nene biluvaꞌ i-ngidavo minilisave. ");
INSERT INTO aso_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hizi hoꞌli minilizaniꞌ nene meleholiꞌmo gipele biluvaꞌ o-divo gipeleꞌmo melehine biluvaꞌ o-divo idoꞌ izelehoꞌmo aluvo biluvaꞌ o-divo aluvoꞌmo izelehine biluvaꞌ o-divo idoꞌ avoloholiꞌmo onohulo biluvaꞌ o-divo onohuloꞌmo avolohine biluvaꞌ o-divo minilisave. ");
INSERT INTO aso_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Neꞌmine lo lo-ngemo di geseꞌ aniꞌ aleve nene gohi tiꞌ lo lo-ngimineꞌ: Lingine Isilaeleꞌ misubouꞌ mene hoꞌ lemaaꞌ idatiꞌ limuso nene ma navo ningi tiꞌ li laaꞌ nave: Goline mo izeleseive li laaꞌ nave. Neꞌmine likevo goline nene lingine ladoꞌ laminetoꞌ mo izaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Idoꞌ hepeꞌ emalatiꞌ naba elo oduvo aniꞌ nene lingine tiꞌ li laaꞌ nave: Hoꞌ naba goloso loloseive laaꞌ nave. Neꞌmine likevosa lingine mo ladoꞌ hoꞌ naba goloso laaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Soza sunolavoꞌ monave lingine mene Okulumotasi misubolasi ningisa neꞌmine initeꞌ sotoꞌ oloseive li izeꞌ mili ningi gilaaꞌ naniꞌza lingine idise mene ogo molo nouvoniꞌ nemuꞌ nene nanimuꞌ izeꞌ mili gilisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Idoꞌ lengiꞌ igi mili ilizadoꞌ lisiheꞌ o minelineꞌ monovo nene langisetine di kegesi ningaaꞌ ilizanako nanimuꞌ ningisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ve maliꞌmo goniꞌ o-gedelesa geleꞌmize do zasila novivo ma nene mo zasila geleꞌmizo vavo zasi neꞌmo pilisi veti aꞌninguꞌ molavo huli galapusoloꞌ i-gidikelizaze. Akaloꞌ olihe nivi ma nene aꞌmine goniꞌ o-gedelesa ive nene amuzo molo mulunouꞌ do hongu lo-dezo. ");
INSERT INTO aso_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Naza laminetoꞌ ma lo-gemeloze. Gaza zogo emo mulunouꞌ do hongu lo-damanivo galapusoloꞌ huli-gidilizaniꞌ nene gaza aꞌminguꞌ mino lihimeka apasekaꞌ apasekaꞌ ogo mino meni hize osuꞌ gehepeve losavoꞌ nene osuꞌ losa volosange. Zogo emezo. ");
INSERT INTO aso_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Idoꞌ Izesuꞌ aꞌmine gamazi lo osuꞌ lo nolo-ngimivo nGalilaia ve malite ize ngibili Oꞌmoso lehizi-di nizavo Pilatoꞌ lavo aꞌmine ve nene ngibili hilave li aꞌmine gameneloꞌ gehepeve nene eveneꞌ ma igi heteli Izesuꞌni veteteꞌ igi li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Neꞌmine li li-imikevo ingine ladoꞌ tiꞌ lo lo-ngimineꞌ: Idoꞌ nemuꞌ lingine gilaniꞌ aꞌmine nGalilaia ve ngebelavo hilave nene nGalilaia ve linge mukiꞌ nene ngivileꞌ igi lihime nabaloꞌ daaꞌ ave minadiꞌmo nene mulumo gili hilaniꞌ noloseive lisa nigilahe. ");
INSERT INTO aso_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oꞌove. Mo neꞌmino nomive losa tiꞌ lo laminetoꞌ nolo-lingimuve. Lingine lutine ma di velepeꞌ izamilizaniꞌ nene linginesi aꞌmineꞌmine igi vi tolovo ilisave. ");
INSERT INTO aso_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Idoꞌ Siloamu numuno ebekutiꞌ numuno haꞌna gizi di dizi vaniꞌ numunoliꞌmo ngutoko lemo eveneꞌ eitini (18) ngibilive nete Zelusalemi numuno ebekuꞌ minaniꞌ aleve nene ngivileꞌ igi monovo goloso naba daaꞌ aniꞌ noloseive li nigilahe. ");
INSERT INTO aso_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oꞌove. Mo neꞌmino nomive losa tiꞌ lo laminetoꞌ nolo-lingimuve: Lingine lutine ma di velepeꞌ izamilizaniꞌ nene linginesi aꞌmineꞌmine igi vi tolovo ilisave. ");
INSERT INTO aso_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Neꞌmine lo aneza gamazi ma tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo vaini nalaꞌ zuhoꞌ ogaꞌ ineꞌ miꞌveuꞌ gohuno za ma zuhoꞌ okinguꞌ nene aza alingeꞌ ogo gihile izihe izamihe lo elelesa viseꞌ ineꞌza ma izamivo ");
INSERT INTO aso_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","midoꞌ gizebo ve nene tiꞌ lo lo-imineꞌ: Ningezo. Gohuno za mene ningekaꞌ ningekaꞌ uvoniꞌ kilisimasi setohamo nene gihileꞌve izineꞌ ma ningamuze. Misubo ngilisi hazamuꞌ no minalize. Bele hulozo lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Neꞌmine lavo midoꞌ gizebo ve aza tiꞌ lo lo-imineꞌ: Ve nabo, idise kilisimasi nene ha minelive. Naza nene aꞌmine gohuno za neꞌmi monovouko nene omoꞌ do guno ogo gono dosa za nene lamineꞌ dizo gihile izelingumuꞌ bulumakaꞌ ise neꞌmine molalove. ");
INSERT INTO aso_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Neꞌmine okuvo ma kilisimasiuꞌ nene gihile lamineꞌ izelihe ningelone. Idoꞌ lamineꞌ ogo gihile ma izamilineꞌ nene belo huko do hulolosane lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Holiseꞌ gameneuꞌ nene Izesuꞌ aza monoꞌ numuno mauꞌ monoꞌ apize ngemo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lo-ngemo neivo aꞌminguꞌ veneꞌ ma minineꞌ nene sikalahuꞌ golosoliꞌmo kilisimasi eitini (18) neꞌmine veneꞌ neꞌmi lulouꞌ mino mehene do hilingize-divo mehene hili-ngize vineꞌ mino ote pehe lamilineꞌ o vineꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Neivo Izesuꞌ aza ningo asi lo-do tiꞌ lo lo-imineꞌ: Veneꞌ gaza gize do naneꞌ initeꞌ nene mo do mate-gedekuve. ");
INSERT INTO aso_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Neꞌmine nolo veneꞌ neꞌmi okoꞌnoloꞌ ana hitavo aꞌmidoꞌ liteꞌ lo mehene hilingize minineꞌ nene lisiheꞌ ineꞌ. Neꞌmine ogavo veneꞌ aza apiꞌ ogo Oꞌmoso opoꞌni loꞌmo vo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Neꞌmine neivo monoꞌ numudoꞌ gizebo ve naba neꞌmo holisekuꞌ veneꞌ do lamineꞌ o-dineꞌ nemuꞌ nene mulunouꞌ goloso gelo eveneꞌ tiꞌ lo lo-ngimineꞌ: Lingine initeꞌ gizi daniꞌ do lamineꞌ o-lengedelingumuꞌ ve li ma nene holiseꞌ gameneuꞌ nene ami asi gono gameneuꞌ gamene sigisi (6) neineꞌ neukovoꞌ nene alizave. ");
INSERT INTO aso_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Neꞌmine lo lavo aꞌmidoꞌ Guvelesi veꞌmo tiꞌ lo lo-imineꞌ: Lingine eveneꞌ lisiheꞌ lamineꞌ gili monii lutinguꞌ monovo goloso di haleki minaaꞌ ave mene lengiꞌ hamo hamoꞌ dongi izetine nehe bulumakaꞌ izetine nehe nene noso nalizangumuꞌ ve li ize numungutiꞌ nene holisekuꞌ vi kuluhizi di vamaaꞌ naniꞌ nehe. Neꞌmine igaꞌ naniꞌ nene aꞌminesi ne gono ve. ");
INSERT INTO aso_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nemuꞌ nene veneꞌ Abalahamuꞌ aꞌvopilemoꞌ mene Sataniꞌmo do goloso o-davo mino kilisimasi eitini (18) ivileꞌ ineꞌ nenako naza holiseꞌ gameneuꞌ aꞌmine gize daniꞌ initeꞌ do lamineꞌ o-deloniꞌ nene edamilihe. ");
INSERT INTO aso_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Neꞌmine lo lavo eze biluvaꞌ gidini i-di minave mukiꞌ nene ngovozo hilaniꞌ. Neꞌmine navo eveneꞌ mukiꞌ ingine nene atoliꞌmine suno lamineꞌ do sotoꞌ ineꞌ vaiꞌ nemuꞌ nene ngolize naba goloso izaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Idoꞌ nelotiꞌ gohi ma tiꞌ lo lineꞌ: Oꞌmosoꞌmo eveneꞌveloꞌ gizebo ilineꞌ akaꞌve nene nadiꞌ ogo neive lolove. Idoꞌ nanitetoꞌ lo molo lokuvo vo dalive. ");
INSERT INTO aso_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aꞌmine Oꞌmosoꞌmi gizebo nene nabaꞌmine sakaveꞌ zuho neꞌminosa ne neive. Aꞌmine nene ngomo ha niteꞌ gehepeve neiha ve maliꞌmo do vo miꞌveuꞌ zuhoꞌ ogavo dizo za neꞌmine loloꞌ ogavo nama nete aꞌmineꞌmi aꞌnavauꞌ nene numuno gizi ingaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Idoꞌ aneza gamazi gohi ma tiꞌ lo lineꞌ: Oꞌmosoꞌmo eiꞌ gizebo o-ngedelineꞌ alevetinguꞌ gono daaꞌ neineꞌ nene nanitetoꞌ lo molo lokuvo vo dalive. ");
INSERT INTO aso_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Beleti do lulu izaaꞌ neineꞌ initeꞌ zisiti neꞌmine nene neive. Veneꞌ maliꞌmo beleti loloꞌ olosa palauvaꞌ beki ngomo sitohamo nene do nososi do gopo ogo aꞌminguꞌ zisiti ngomosi do gopo ogavo neꞌmo beleti nene lulu izo naba ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Izesuꞌ aza Zelusalemila volosa aka vida numuno ebeꞌ ngomo nabakuꞌ nene gamazi apize ngeme ngemeꞌ oꞌmo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Neꞌmine oꞌmo novivo ve maliꞌmo tiꞌ lo longoꞌ o-do lineꞌ: Guvekasi ve, Oꞌmosoꞌmo eveneꞌ do nguꞌ izelive nene ngomosiꞌ nizahe. Lavo Izesuꞌ tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Lingine gateni ngomouꞌ nene dizili ma dizilisa eleꞌvoleꞌ goloso ilo. Nanitekumuꞌ ve. Naza tiꞌ lo nolo-lingimuve: Eveneꞌ mukiꞌ nete aꞌmine gateni ngomouꞌ nene dizelone li dizilisa ilizaniꞌza ngeli ma dizamilisave. ");
INSERT INTO aso_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Neꞌmine igi nizavo numuno meleho naza oto akahe nene gize giliꞌ lokuvo lingine heta oti mini vise li tiꞌ li lilisave: Gaza Guvekasi ve make, akahe siꞌze-ledevo. Likevo naza tiꞌ lo lolosuve: Lingine nene zaaꞌ ve nizahe. Ningo gele-lengedamuve. ");
INSERT INTO aso_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Neꞌmine lavo lingine tiꞌ li li-nimilisave: Gezesi makaꞌ mino nosoꞌ niteꞌ naaꞌ uneꞌ ma ve. Idoꞌ gaza numudela aka vida nene gamazi apize lemeꞌ lemeꞌ ogaꞌ aineꞌ ma ve. ");
INSERT INTO aso_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Neꞌmine li li-nimilizaniꞌza naza tiꞌ lo lo-lengemelesuve: Lingine zaaꞌ ve nizahe ma gelamuve. Lingine goloso initetokovoꞌ monaaꞌ ave lingine nene mo vi haha ilo lolosuve. ");
INSERT INTO aso_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Neꞌmine lo lingine hulo heta o-lengedekuvo mini ningilizaniꞌ nene Abalahamuꞌ ve Isakaꞌ ve Zakoboꞌ ve idoꞌ polohete mukiꞌ nesi nene Oꞌmosoꞌmi gizebouꞌ vi nizavo ningi nemuꞌ vetine ingihi langoloꞌ igi mini ive nama igi mulumo alumo gili minilisave. ");
INSERT INTO aso_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lingine neꞌmine navo Oꞌmosoꞌmo gizebo ineꞌ ebekuꞌ nene atoꞌ aleve hoꞌ dizaaꞌ idatiꞌ idoꞌ lemaaꞌ idatiꞌ idoꞌ eza gahevelatiꞌ idoꞌ ema gahevelatiꞌ nene igi moꞌmosiꞌine di ngolize izi nosoꞌ niteꞌ ni minilisave. ");
INSERT INTO aso_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lingine gililo. Idise mene limi nilizaniꞌ aleveutiꞌ linge ma alingeꞌ dizi minilisave. Idoꞌ idise mene dizi nilizaniꞌ aleveutiꞌ linge ma nene alingeꞌ limi minilisave. ");
INSERT INTO aso_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aꞌmine gameneloꞌ nene Halisaioꞌ eveneꞌ linge ma igi Izesuꞌni tiꞌ li li-imaniꞌ: Guvelesi ve Helodeꞌ aza nene gebele helelesa nolize. Me ebeꞌ nene hulo vozo. ");
INSERT INTO aso_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Lingine aꞌmine lovo gulo gele vive nene tiꞌ li li-imilo: Gaza gelezo. Naza nene geikumuꞌ golise gelamo idisesi aizekisi nene sikalahuꞌ goloso ngimiselo mino eveneꞌ initeꞌ gizi daniꞌ nene do lamineꞌ o-ngedo mino okozoꞌ nene gonoꞌne do pelelesuve. ");
INSERT INTO aso_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Neꞌmine o neineꞌza polohete ngibili hilaaꞌ naniꞌ ebeꞌ nene Zelusalemi ebeꞌ neevoꞌ neineꞌ nenako polohete ma ebeꞌ atota bili hililizaniꞌ nene mo edamilineꞌ nenako nemuꞌ nene aꞌmine Zelusalemi numuda nene idisesi aizekisi idoꞌ okozokisi nene voꞌmo voꞌmo voloniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Agae, Zelusalemi alevekizo, lingine polohete ngibili hilii idoꞌ Oꞌmosoꞌmo lengita gono dalizave lo ngeletivesi geheni gavoso ngibili hilaaꞌ ave lengiꞌ nete gamene gamene lengiꞌ nene okoloholiꞌmo goduvoꞌ do holokeꞌneꞌveko do nubuho o-ngidineꞌ maꞌmine ogo lengeleꞌmize lamineꞌ uvoniꞌza lingine goseleꞌ lengebelave. ");
INSERT INTO aso_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lingine gililo. Numuno nabatine minineꞌ ebetinguꞌ nene Oꞌmoso aza gohi minamo mo hulo-lengedelesa neive. Naza tiꞌ lo nolo-lingimuve: Idise melotiꞌ nene okoꞌneloꞌ ningami miniꞌmi dizi alingeta gohi sotoꞌ nouvo tiꞌ li li-nimilisave: Guvetesi ve Oꞌmosoꞌmi velemuꞌ anive naneꞌ ma nene noꞌnohoꞌ geita minivoo. Neꞌmine lii li-nimilizaniꞌ gameneuꞌ nene neze ningilisave lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Holiseꞌ gamene mauꞌ Izesuꞌ aza Halisaioꞌ veti ve nabaꞌine maliꞌmi nosoꞌ niteꞌ no neivo aza initeꞌ ma do gopo ilingumuꞌ ve li gizebo igi ningi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Neꞌmine igi nizavo aꞌminguꞌ nene ve ma okoꞌno lulu izive nene Izesuꞌ neida avita minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Neivo Izesuꞌ aza Halisaioꞌ vesi idoꞌ louꞌ gamaziloꞌ sukulu naba li monikevesi nene tiꞌ lo longoꞌ o-ngidineꞌ: Leze louꞌ gamazite neꞌmo nadive lo neive. Holisekuꞌ nene laza eveneꞌ do lamineꞌ o-ngedelobe ma do lamineꞌ o-ngedamolone. ");
INSERT INTO aso_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Neꞌmine lavo ingine gamaziꞌinesi nomivo minaniꞌ. Neꞌmine ikevo okoꞌno lulu izive nene do lamineꞌ o-do hulo-davo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Neꞌmine ogo tiꞌ lo lo-ngimineꞌ: Lengikutiꞌ ve maliꞌmi dongi izeꞌve nehe bulumakaꞌ izeꞌve nehe holiseꞌ gameneuꞌ galeseuꞌ leme neivo liteꞌ lo vo gono do geleleheꞌ ogo hulo hazala o-damilidoꞌ o neihe. ");
INSERT INTO aso_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Neꞌmine lavo ingine aꞌmine gamaziloꞌ nene ngeli di tiꞌni li-imamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Neꞌmine ikevo aꞌmine nosoꞌ niteꞌ nalisa ave ingine nene eveneꞌ naba gelo holomo laminetoꞌ minelone li minilisa navo Izesuꞌ aza ningo gamazi ma tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Lingine nene ve maliꞌmo nosoꞌ niteꞌ nabamuꞌ elese molo-lengemavo niigi ma nene holomo laminetoꞌ nene gomuꞌ igi minamilo. Lengikisi makatoꞌ elese molo-lengede nolive ma lengiꞌ lingivileꞌ igi dizi nilizaniꞌ nene ");
INSERT INTO aso_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","aza elese molo-lingidive neꞌmo ogo tiꞌ lo lo-lengemeleseive: Lingine minaniꞌ holomoloꞌ nene me vete minilizaze. Otilo. Neꞌmine lavo lingine longovozo hili holomo meheꞌnida nene minikelizaze. ");
INSERT INTO aso_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ve maliꞌmo nosoꞌ nitekumuꞌ elese molo-lengemavo niigi ma holomo meheꞌnida nene vi minilo. Neꞌmine igi nizavo elese molo-lingimive ogo ningo zogone, holomo lamineta dizi minilo lo lo-lengedeleseive. Neꞌmine ogavosa aꞌmine nosoꞌ niteta makaꞌ vi minaveti veꞌnidoꞌ nene mo dizi minave minilisave. ");
INSERT INTO aso_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Idoꞌ neꞌmine noluvoniꞌ nene nanitekumuꞌ ve. Ve ma okoꞌine di dizaaꞌ ave mukiꞌ engiꞌ nene Oꞌmosoꞌmo do leme-ngedeleseive. Idoꞌ ve ma okoꞌine di limi minaaꞌ nave engiꞌ nene Oꞌmosoꞌmo do dize-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Neꞌmine lo lo-ngemo nosoꞌ nitekumuꞌ elese molo-dive nene tiꞌ lo lo-imineꞌ: Nosoꞌ niteꞌ gize vataꞌ ogo molo eveneꞌ elese molalosa gelo ma geze alingeꞌ elese mili-gidikevo ge nosoꞌ nitekaloꞌ golo hizaniꞌ gelalize. Geze zuho gihile nilizahe idoꞌ zogo veka zuho nilizahe idoꞌ geze nanida heneni aleve minaaꞌ nilizahe neꞌmine aleve mukiꞌ nene elese molo-ngedamozo. ");
INSERT INTO aso_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Asi nosoꞌ niteꞌ gize vataꞌ ogo eveneꞌ elese molalosa gelo ma nene gohoꞌ gahaliꞌ nilizahe gebili siꞌzi miniliza aleve nilizahe idoꞌ veꞌine likive nilizahe neꞌmine alevevoꞌ nene elese molo-ngedezo. ");
INSERT INTO aso_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Neꞌmine ilineꞌ nene ingine aꞌmine nosoꞌ nitetoꞌ nene ngeli golo hizamavo Oꞌmosoꞌmo eveneꞌ lisiheꞌ hilangutiꞌ do ote-ngedelineꞌ gameneloꞌ nene meni gemelineꞌ nenako neꞌmine ilineꞌ neꞌmo gaza mine lamineꞌ ilineꞌ akaloꞌ minelesane. ");
INSERT INTO aso_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Neꞌmine lavo nosoꞌ niteꞌ makatoꞌ ni minave maliꞌmo gelo Izesuꞌni tiꞌ lo lo-imineꞌ: Oꞌmosoꞌmo gizebo inguꞌ vo holo mino nosoꞌ niteꞌ no minelonive leliꞌ nene mine lamineꞌ oloneꞌ akaloꞌ mine molo none. ");
INSERT INTO aso_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Neꞌmine lo lavo nemuꞌ aneza gamazi Izesuꞌ ma tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo nosoꞌ niteꞌ naba do vaꞌvaꞌ olosa eveneꞌ mukiꞌ nene elese molo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Elese molo-ngemavo nosoꞌ niteꞌ naliza gamene nene alitavo gonouꞌ ve nene aꞌmine elese molo-ngidive nene lo-ngemelive lo imiselavo vo tiꞌ lo lo-ngimineꞌ: Lingine nosoꞌ niteꞌ nene mo do vaꞌvaꞌ ogaze. Alo. ");
INSERT INTO aso_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Neꞌmine lo lo-ngimineꞌza ingine mukitoꞌ vamoloniko lii apiꞌ igi amiliza monovomuꞌ abelenga li-imikaꞌ li-imikaꞌ aniꞌ ve. Maliꞌmo nene apiꞌ ogo tiꞌ lo lo-imineꞌ: Agae, naza nene misubo ma meni hizuvoniꞌ nenako aꞌmida vo ningeloniꞌ o neive lo guvelesi ve nene lo-emezo. ");
INSERT INTO aso_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Neꞌmine lo lavo maliꞌmo tiꞌ lo lineꞌ: Agae, naza nene gono dalizaniꞌ bulumakaꞌ teni meni hizo hulo nouvoniꞌ nene gono lamineꞌ dalizahe damilizahe lo ningelesa volosa nouze. Nemuꞌ guvelesi ve lo-emezo. ");
INSERT INTO aso_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Lavo maliꞌmo tiꞌ lo lineꞌ: Naza nene mo idise aꞌne veneꞌ dosa nouvonako nemuꞌ nene vamoloniꞌ o neive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Neꞌmine likevo gonouꞌ ve aza laniꞌ gamazi nene vo nosoꞌ niteꞌ naba gize vataꞌ ive nene lo-emavo aza izeboloꞌ goloso molavo gonouꞌ ve nene tiꞌ lo lo-imineꞌ: Gaza nene numuno ebeꞌ nabala aka ngomoꞌ nabakuꞌ nene vo gohoꞌ gahaliꞌ aleve idoꞌ gizeꞌine aꞌine goloso ineꞌ idoꞌ veꞌine likineꞌ idoꞌ gebili aleve nene ngeleꞌmizo ano lo imiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Neꞌmine lo imiselavo gonouꞌ ve aza aꞌmine lidoꞌ ogosa ogo gizebo veꞌve nene tiꞌ lo lo-imineꞌ: Ve nabo, gaza lo-nedaineꞌ maꞌmine nene mo okuvoniꞌza minaaꞌ holomo linge nene lumo haza neive. ");
INSERT INTO aso_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Neꞌmine lavo nosoꞌ niteꞌ gize vataꞌ ive ve naba neꞌmo gonouꞌ ve tiꞌ lo lo-imineꞌ: Gaza aka nabaloꞌ vaaꞌ idoꞌ mine akauꞌ vaaꞌ ogo eveneꞌ nilizaniꞌ nene amuzo molo ngeleꞌmizo do oganivo numuꞌne nene vaiꞌ lilive. ");
INSERT INTO aso_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Naza tiꞌ lo nolo-gimuve: Naza gomuꞌ elese molo-ngiduvoniꞌ aleveutiꞌ nene hamolitesi neniꞌ nosoꞌ nitekutiꞌ nene mo namilisave lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Eveneꞌ mukiꞌ goloso nene Izesuꞌni eꞌmeti nivavo aza mine velepeꞌ izo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ve ma nenita igi giꞌmizi minilizave ingine nene izeꞌningine meꞌningine veneꞌ izipahaꞌine ingine zuhomuꞌ idoꞌ engiꞌ okoꞌinemukisi gilavo dizavo nenikumuꞌ gilavo ngomo ma lemo minelineꞌ nene neniꞌ izipahaꞌne liliꞌ igi minamilisave. ");
INSERT INTO aso_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Idoꞌ ve ma mulumo initeꞌ i-lidi lohotoꞌ zaloꞌ libilikelizave li gili aꞌmanapa igi neꞌmetamilizaniꞌ nene neniꞌ izipahaꞌne zuho loloꞌ igi minamilisave. ");
INSERT INTO aso_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Idoꞌ lengikutiꞌ ve malite numuno haꞌna dizo minelineꞌ numuno ma gizelone li gili ma ingine nene aꞌmine numuno gizeloneꞌ meniꞌve nene vo dahe damihe li gomuꞌ gati gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Neꞌmine igi gati ningi gilamilizaniꞌ nene alingeꞌ posi di hizisa numuno gizilizaniꞌ initeꞌine nene geto osuꞌ lavo ngeli gizi osuꞌ lamilizaniꞌ ogavo eveneꞌ ingine ningi gizeꞌ i-ngidi ");
INSERT INTO aso_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ve mene gosohoꞌ niteꞌ di numuno haꞌna di hizi tiꞌ aha hulikevo goꞌnupo o neive lilisave. Nemuꞌ nene neꞌmine ikelizaze. Numuno haꞌna gizili ma gomuꞌ nene moniꞌine nehe numuno giziliza initeꞌine nehe nene vo dahe damihe li gati ningi gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Idoꞌ guvelesi ve maliꞌmo neze zuhosi guvelesi ve maliꞌmi zuhosi lovo hizelone lo gelelineꞌ nene olihe lovoloꞌ vamo lovo di alizave engiꞌ nene tuvedi tauseni (20,000) ami nizavo eze nene teni tauseni (10,000) amivoꞌ do neineꞌ nemuꞌ engiꞌ nene ha ngivileꞌ olobe amolobe lo gomuꞌ nene lulouꞌ izeꞌ molo gala geleleseive. ");
INSERT INTO aso_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Idoꞌ gala gilivo ngeli ngivileꞌ amilizaniꞌ ineꞌ nene lovo ve ingine hotoꞌ olihe navo eveneꞌ ma lovo hizamoloningumuꞌ nene gamazi do lisiheꞌ olone lo ngimiselaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Idoꞌ aꞌmineꞌmine igi neniꞌ neꞌmetilisa ilizaniꞌ nene ingine naniteꞌ naniteliꞌmo kostim o-ngedelihe gomuꞌ nene ningi gili minisavoꞌ nene neꞌmetilisave lo noluve. Aꞌmineꞌmine ogo lengikutiꞌ ve maliꞌmo eiꞌ initeꞌ mataꞌve mukiꞌ mehene emamilineꞌ nene neniꞌ izipahaꞌne minamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Guvo nene lamineꞌ neineꞌza aꞌmine guvo nene goloso ogavo laniteꞌve osuꞌ lilineꞌ nene gohi ma lamineꞌ amoloseive. ");
INSERT INTO aso_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aꞌneꞌmine guvo nedunuꞌ neꞌmine manaꞌmine initeꞌ ma amolosunako mo do hulolosune. Nemuꞌ lingine gatine gili nge laaꞌ ave ma nii ma nene gili lamineꞌ igi gililo. ");
INSERT INTO aso_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Idoꞌ takisi moni daaꞌ avesi lihime daaꞌ ave linge ma nesi Izesuꞌ monoꞌ gamazi lineꞌ gililisa ezela ikaꞌ ikaꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Neꞌmine navo Halisaioꞌ vesi idoꞌ louꞌ gamazi apizi ngimaaꞌ ave ingine ningi goloso gili Izesuꞌnimuꞌ tiꞌ li laniꞌ: Ve mene lihime daaꞌ ave ma nene zogo ngemo engikisi nosoꞌ niteꞌ makaꞌ naaꞌ neineꞌ nene edamive. ");
INSERT INTO aso_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Neꞌmine likevo Izesuꞌ aza gelo aneza gamazi ma tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Lengitatiꞌ ve maliꞌmi sipisipi izeꞌve vanu hadeti (100) minilizangutiꞌ hamoꞌ ma vo halekelineꞌ nene aꞌminemuꞌ viseꞌ amilihe. Neꞌmino nomive. Sipisipi naedi naeni (99) nene guvisela hulo-ngimiko hamoꞌ vo halekineꞌ nemuꞌ nene viseꞌ ogo do sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mo viseꞌ ogo do sotoꞌ ogo mulunouꞌ lamineꞌ gelo olize izeꞌmo izeꞌmo abutiꞌ izo do geho numuda aloseive. ");
INSERT INTO aso_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Do ogo eze zuho elese molo-ngedo tiꞌ lo lo-ngemeleseive: Naza sipisipi izeꞌne vo halekineꞌ ma nene mo ningo do sotoꞌ okuze. Makaꞌ lolize izelone loloseive. ");
INSERT INTO aso_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nemuꞌ naza ma lo-lengemelove. Okulumokuꞌ nene aꞌmineꞌmine ogo eveneꞌ lisiheꞌ naedi naeni luꞌine di velepeꞌ izamilizadoꞌ i minilizavemuꞌ ngolize izaaꞌ naniꞌ nene ivileꞌ ivosa ve goloso hamoꞌ lulo do velepeꞌ izelineꞌ nemuꞌ nene ngolize naba goloso izilisave. ");
INSERT INTO aso_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Idoꞌ ma nene veneꞌ maliꞌmo moni siluvaꞌ teni kina (K10) goꞌzekelingutiꞌ vanu kina ma vo halekilineꞌ nene aza mo liviꞌ gizo viseꞌ ovoꞌ ovoꞌ ogo ningo do sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ningo do sotoꞌ ogo veneꞌ gonolomotine nene tiꞌ lo lo-ngemeleseive: Naza moniꞌne hamoꞌ vo halekineꞌ ma nene mo ningo do sotoꞌ okuze. Lolize makatoꞌ izelone. ");
INSERT INTO aso_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Idoꞌ naza ma lo-lengemelove. Aꞌmineꞌmine igi Oꞌmosoꞌmi angeloꞌ nete lihimeloꞌ ve hamoꞌ ma lulo do velepeꞌ izineꞌ nene ngolize naba goloso izaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Idoꞌ Izesuꞌ aza gamazi gohi ma tiꞌ lo lo-ngimineꞌ: Ve maliꞌmi gipele sitaꞌ ma minasineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Minasingutiꞌ alingeni neꞌmo melehine nene tiꞌ lo lo-imineꞌ: Ahono, gaza moni heneni initeꞌ uvoꞌnehingisi izeꞌ molo lemelesa molaineꞌ ma nene neze nemelida idise izeꞌ molo nemezo lineꞌ. Lavo meꞌnibo moni heneni initeꞌ mukiꞌ nene izeꞌ molo ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","nGemavo alingeni izipe aza initeꞌ izeꞌ molo ngimidotiꞌ nene mine haꞌna amo aꞌmine initeꞌ mataꞌvelotiꞌ nene moni do osuꞌ lo do ebeꞌ hota ma vo minineꞌ. Aꞌmidoꞌ nene vo mino moni heneniꞌve nene monovo danava golosoloꞌ nene hulo osuꞌ lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Neꞌmino hulo osuꞌ lavo aꞌmine minineꞌ misuboloꞌ nene gaꞌna nabaꞌ naba sotoꞌ neivo ezela nene initeꞌ hamokisi ma lumo minamivo gaꞌnaꞌmo helelidoꞌ mine molo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Neꞌmine ogo aꞌmine misubouꞌ ve ma minidoꞌ vo gonomuꞌ lavo Zuda ve leliꞌ Oꞌmosoꞌmo malise o-lede neineꞌ initeꞌ izeloꞌ nene vo gizebo ilive lo lo-davo agae lo gopo vo gizebo ogo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Neꞌmino neivo nosoꞌ nitekisi imamavo izeliti nosoꞌ nitekutiꞌ nene ha nalove lo gilineꞌza ma imamaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Neꞌmine ikevo aza gala gele veveso tiꞌ lo lineꞌ: Meꞌnehi gelekeleꞌ izipe mukiꞌ nene nosoꞌ niteꞌ lamineꞌ mukiꞌ ni nilisaniꞌza naza nene mela mino gaꞌnaꞌmo helelesuve. ");
INSERT INTO aso_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nemuꞌ nene naza numuꞌnela tineꞌ molo vo meꞌnehine tiꞌ lo lo-emelove: Ahono, naza do goloso ogo lihime Oꞌmosoꞌmi velelokisi geiꞌ vegalokisi dokuvo edamive. ");
INSERT INTO aso_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nemuꞌ nene geiꞌ gipa minuvoniꞌ ma nene gohi geiꞌ gipa minelodoꞌ lisiheꞌ amuvonako nemuꞌ nene gelekeleꞌ izipaha neꞌmine loloꞌ o-nedanivo minelove lo lo-emelove lo gala gelo ");
INSERT INTO aso_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","oto meleho neida vineꞌ. Vineꞌza meleho aza gipele olihe hotoꞌile navo ningo muluno gitihineꞌ ogavo aza lotiꞌ izo vo abutiꞌ izo golo elo naniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Neꞌmine ogavo gipele aza melehine tiꞌ lo lo-imineꞌ: Ahono, naza do goloso ogo lihime Oꞌmosoꞌmi velelokisi geiꞌ vekalokisi dokuvo edamive. Nemuꞌ nene geiꞌ gipa minuvoniꞌ ma nene gohi geiꞌ gipa minelodoꞌ lisiheꞌ amuve. ");
INSERT INTO aso_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Neꞌmine lo lineꞌza meleho aza eiꞌ gelekeleꞌ izipeꞌve nene tiꞌ lo lo-ngidineꞌ: Lingine liteꞌ li vi okoꞌnoloꞌ initeꞌ lamineꞌ ma vi di igi ngili-dilo. Idoꞌ analoꞌ nene lini ma di izi-di idoꞌ gizeneloꞌ suuꞌ nesi nene di igi izi-dilo. ");
INSERT INTO aso_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Neꞌmine igi vi bulumakaꞌ angale adoꞌ geheso ma minelineꞌ ma di igi bili gize vataꞌ i-dilo. Laza lolize izo mino no minelone. ");
INSERT INTO aso_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gipeꞌne mene mo vo haha ogavo hilihe luvonako helangutiꞌ gohi vele gizo ogave lavo nemuꞌ ngolize izi tiꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Neꞌmine igi nizavo gipele ganaꞌve nene mida ha minineꞌ. Aꞌmidatiꞌ ogo numuno avita aniꞌ nene beni bili huhunaleꞌ mili melengeni igi minaniꞌ nene gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gelo nanitekumuꞌ neꞌmine igi nizahe lo gelekeleꞌ izipe ma vise lo-do longoꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Longoꞌ o-davo aza tiꞌ lo lo-imineꞌ: Geiꞌ nakuna ma nene velesi lamineꞌ ha mino gohi tineꞌ molo numuda mene angumuꞌ nene maho ma bulumakaꞌ angale adoꞌ geheso ma minineꞌ nene ma belavo nosoꞌ niteꞌ gizi vataꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Neꞌmine lo lo-imineꞌza aza neve izeboloꞌ molavo aꞌminguꞌ dizelesa goseleꞌ bilineꞌ. Neꞌmine ogo numunguꞌ dizamivo meꞌnibo nene lemo eze mulunouꞌ do zou lo-dineꞌza ");
INSERT INTO aso_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","melehine tiꞌ lo lo-imineꞌ: Gaza gelezo. Kilisimasi vaiꞌ goloso mene geiꞌ gonoka do minuvoniꞌ nene haza gelekeleꞌ izipe neꞌmine loloꞌ ogo mino gono do minuvoniꞌ ve. Idoꞌ neꞌmine manaꞌmine ozo lo-nidaineꞌ nene ma gele hulosaꞌmuvoniꞌ ve. Neꞌmine ogaꞌ uvoniꞌza gaza memeꞌ angale neꞌminesi kekeꞌ mo ma nemanivo neze zogone zuhosi belo ma gize vataꞌ ogo nosaꞌmuneꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma nemesaꞌmaneꞌza gipa aza nene initeka mukiꞌ do vineꞌ ma nene pasidiaꞌ veneꞌ aluloꞌ hulo osuꞌ lineꞌ ma neineꞌza gaza nene bulumakaꞌ ize gehesineꞌ nene bele-dabe. Olo. ");
INSERT INTO aso_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Neꞌmine lavo meleho tiꞌ lo lo-imineꞌ: Gipeꞌne, gaza nenikisi makaꞌ minaaꞌ nosineꞌ nene initeꞌ mukiꞌ nenita neineꞌ nene geiꞌ initeka nene neive. ");
INSERT INTO aso_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Idoꞌ nakuna nene mo hilihe lunako helangutiꞌ gohi sotoꞌ ogave. Nemuꞌ nene muludeuꞌ lamineꞌ gelo lolize noizunivo lamineꞌ neive lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Izesuꞌ aza izipahala zuho gamazi gohi ma tiꞌ lo lo-ngimineꞌ: Heneni ve maliꞌmi heneniꞌveloꞌ gizebo veꞌve ma minineꞌ. Aꞌmine heneniloꞌ gizebo ve neꞌmi gamaziꞌve ma tiꞌ li likevo heneni ve maꞌmo gilineꞌ: Heneniloꞌ gizebo ve aza nene heneni do gopoꞌ napa ogaꞌ neive. Neꞌmine laniꞌ gelo ");
INSERT INTO aso_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","heneniloꞌ gizebo ve nene vise lo-do tiꞌ lo lo-imineꞌ: Gaza gamazika ma laniꞌ nene gelekuko nadiꞌ ive. Gaza gohi heneniloꞌ gizebo ve minamolosange. Nemuꞌ nene gaza gono doꞌmo vo minaineꞌ luhuvo ma nene do nelebizezo. ");
INSERT INTO aso_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Neꞌmine lo-davo heneniloꞌ gizebo ve aza gala gelo tiꞌ lo gilineꞌ: Naza heneniloꞌ gizebo ve minuvoniꞌ malotiꞌ nene do nohulo-nidiko nadiꞌ olove. Naza savoli hizo ledo daaꞌ amuzoꞌne nomivo idoꞌ evenetatiꞌ nosoꞌ niteꞌ vokuꞌ lo dalosa novozo helalove lo giluvoniꞌ nemuꞌ nene ");
INSERT INTO aso_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","neze gonoꞌneutiꞌ nimisele hulavo naza vo eveneꞌ ma ingine numuꞌninguꞌ neleꞌmize mili di lamineꞌ i-nidavo dizo lemo olongumuꞌ nene engita initeꞌ ma o-ngedelove. ");
INSERT INTO aso_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Neꞌmine lo gala gelo aꞌmine heneni velatiꞌ dinaꞌ ave nene hamo hamoꞌ vise lo-ngedavo neida aniꞌ. Ve maliꞌmo gomuꞌ ogavo heneniloꞌ gizebo ve aza tiꞌ lo longoꞌ o-dineꞌ: Gaza neniꞌ gizebo veꞌne nabalatiꞌ nene initeꞌ nanikeꞌ dinaꞌ ogo daineꞌ neve. ");
INSERT INTO aso_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lavo ve aza tiꞌ lo lo-imineꞌ: Nosoꞌ niteꞌ gize vataꞌ ogaꞌ uveli dalamu ngomo ngomo vanu hadeti (100) duvoniꞌ ve. Lavo heneniloꞌ gizebo ve aza tiꞌ lo lo-imineꞌ: Liteꞌ lo dinaꞌ aineꞌ luhuvouꞌ mene hadeti do hulo fifti (50) ve lo gizezo. ");
INSERT INTO aso_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Neꞌmine lo lo-do ve gohi ma nene tiꞌ lo longoꞌ o-dineꞌ: Idoꞌ gaza nene initeꞌ nanikeꞌ dinaꞌ o naneꞌ neve. Lavo ve aza tiꞌ lo lineꞌ: Viti beki vanu hadeti duvoniꞌ ve. Lavo heneniloꞌ gizebo ve aza tiꞌ lo lo-imineꞌ: Dinaꞌ aineꞌ pepaka mene do hadeti do hulo eiti (80) ve lo gizezo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Idoꞌ me misubouꞌ aleve Oꞌmosomuꞌ gilamaniꞌ nete engiꞌ initeꞌinemuꞌ initeꞌ igaꞌ naaniꞌ neꞌmo nene Oꞌmosoꞌmi evenele luꞌninguꞌ labanaꞌ ele neive nene ngivileꞌ ivosa otohato initeꞌ igaꞌ naaniꞌ nenako aꞌmine do goloso ogaꞌ ive heneniloꞌ gizebo ve nene otohato initeꞌ ogave lo eze gizebo veꞌve heneni ve neꞌmo nene opoꞌni lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Izesuꞌ neꞌmine losa imineꞌ molo gohi tiꞌ lo lineꞌ: Naza tiꞌ lo nolo-lingimuve: Me misubo golosouꞌ neineꞌ heneni nene lengiꞌ zogo vetine minilizangumuꞌ ve li eveneꞌ zogo mili-ngidi ngimilo. Neꞌmine ilizaniꞌ neꞌmo alingeꞌ heneni osuꞌ lilineꞌ gamenela nene minevoꞌ minevoꞌ ebekuꞌ nene lengeleꞌmize lamineꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ve ma aza initeꞌ ngomolokisi vomene do guno gizebo lamineꞌ ilineꞌ nene initeꞌ nabaloꞌ nesi aꞌmineꞌmine ogo gizebo lamineꞌ oloseive. Idoꞌ ve ma aza initeꞌ ngomo ngamaloꞌ nesi nene do gopoꞌ napa ogo minelineꞌ nene initeꞌ nabaꞌ nabaloꞌ nesi nene do gopoꞌ napa oloseive. ");
INSERT INTO aso_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Idoꞌ lingine me misubo golosouꞌ neineꞌ heneni nganeni nene ma di guni gizebo amilizaniꞌ nene lutineꞌmi heneni nganeni gihile lamineꞌ nene zaho lengemelivoba ma lingimamilisave. ");
INSERT INTO aso_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Idoꞌ ve maliti initetoꞌ gizebo lamineꞌ i-ngidamilizaniꞌ nene Oꞌmosoꞌmo salani molo-lingidineꞌ lengiꞌ initetine gehepeve nene zaho lengemelivoba ma lingimamilisave. ");
INSERT INTO aso_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Idoꞌ gonouꞌ ve maliꞌmo eveneꞌ sitatoꞌ nene mo gono ngelo damoloseive. Aꞌmine ve sitatoꞌ gono dalosa ilineꞌ nene ve hamota ma lulo emeleseiha sitaꞌ nene lulo ngelo ngemamoloseive. Mala lulo emelineꞌ nene mala lulo emamoloseive. Idoꞌ ma veloꞌ giꞌmizo eze gono amuzo molo dalineꞌ nene ma vemuꞌ goseleꞌ belavo gono gamazi lo-delineꞌ nene ngelo damoloseive. Aꞌmineꞌmine ogo gaza moniloꞌ gono do luka aꞌmine moniuꞌ molo lamineꞌ ilineꞌ nene luka Oꞌmoso emo gamazi lidoꞌ gele do eze gelekeleꞌ o-daaꞌ anive ngelo minamolosane. ");
INSERT INTO aso_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Neꞌmine lo lavo moni henenimuꞌ laniteꞌ gilaaꞌ ave Halisaioꞌ ve ingine gili gizeꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Neꞌmine aniꞌza aza tiꞌ lo lo-ngimineꞌ: Lingine nene eveneꞌ veꞌnidoꞌ veveso minunive ma nene none li amuzo mili initeꞌ igi mili igaꞌ naaniꞌza lengiꞌ lutineꞌmi monovoꞌve nene Oꞌmosoꞌmo ha ningo gelaaꞌ neive. Evenelite initeꞌ ma di igi di hozi lilizaniꞌ nene Oꞌmosoꞌmi veleloꞌ aꞌmine initeꞌ nene muso gala dizaaꞌ initeꞌ loloꞌ ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Louꞌ gamazi nesi idoꞌ poloheteliti gamazi nesi nene mine do ogo monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ sotoꞌ ogo minineꞌ gameneloꞌ nesi amuzo molo minineꞌ ve. Neꞌmine ogavo nelotiꞌ nene Oꞌmosoꞌmo gizebo o-ledelingumuꞌ gamazi lamineꞌ nene li sotoꞌ sotoꞌ igi nilavo eveneꞌ mukiꞌ nene aꞌminguꞌ vi hilalisa amuzo goloso mili vi hilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Idoꞌ okulumoꞌ misubo nene ha vi tolovo ilisidoꞌ i nizasineꞌza Oꞌmosoꞌmi louꞌ gamazi lingelatiꞌ ngomo nesi nene mo vo tolovo amo amuzo molo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ve maliꞌmo elenahine hulo-do veneꞌ gohi ma dalineꞌ nene Oꞌmosoꞌmi louꞌ gamazi avutoꞌ oloseinako lihime naba daloseive. Idoꞌ vanahine hulo-dosa nolineꞌ veneꞌ ve maliꞌmo ma dalineꞌ nesi nene louꞌ gamazi avutoꞌ oloseinako lihime naba daloseive. ");
INSERT INTO aso_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Moni heneni ve ma mino gamene gamene okoꞌnoloꞌ initeꞌ nene guleheꞌ kaleheꞌ initeꞌ lamineꞌ taminekovoꞌ ngolaaꞌ ineꞌ. Idoꞌ nosoꞌ niteꞌ neve lamineꞌ taminekovoꞌ no minaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Idoꞌ aꞌmine heneni ve neꞌmi numuno gatedoꞌ nene gohoꞌ gahaliꞌ ma minaaꞌ ineꞌ nene gulive Lasaloꞌ. Okoꞌnoloꞌ husoꞌmovoꞌ o vineꞌ mino ");
INSERT INTO aso_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","aꞌmine heneni ve neꞌmo nosoꞌ niteꞌ nalingutiꞌ lumo sama doꞌmozelineꞌ nalove lo vo minineꞌ. Neivo gulo nete igi husoloꞌ nene geꞌne geꞌne i-daaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nelotiꞌ alingeꞌ aꞌmine gohoꞌ gahaliꞌ nene helavo Oꞌmosoꞌmi angeloꞌ nete di vi Abalahamuꞌ neinguꞌ huli-dikevo makaꞌ minasineꞌ. Idoꞌ heneni ve masi nene helavo galese izi-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Neꞌmine i-dikevo aza nene lovoꞌ lovoꞌ ogo minaaꞌ ineꞌ olokuꞌ nene vo mino mulumo alumo naba goloso gelo minineꞌ. Mino ninge hulo veleta ineꞌ nene Abalahamuꞌ aza hotoꞌ goloso hozene neivo ningo gohoꞌ gahaliꞌ Lasaloꞌ nesi makaꞌ Abalahamukisi nizasivo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ningo moni heneni ve aza tiꞌ lo vise lineꞌ: Abalahamuvo meꞌneho make, olokuꞌ mene mulumo alumo gelo nouze. Neniꞌ nene mulumoꞌne gele-nido Lasaloꞌni nene imiselanivo lemo ogo nosouꞌ ana lolovoloꞌ lupizeko veꞌne nahunoloꞌ mene do gelavo hongu lo-nideliho lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Neꞌmine lineꞌza Abalahamuꞌ aza tiꞌ lo lo-imineꞌ: Gipeꞌneho, idise mene gaza gaka ma geleꞌnazo. Gaza misubouko gomuꞌ vekasi mino initeꞌ lamineꞌ tamineꞌ ningo do nanivo Lasaloꞌ nene mulumo alumo gelo mino gohoꞌ gahaliꞌ minineꞌ ma neineꞌza idise nene eleꞌmize lamineꞌ navo geze ma nene mulumo alumo goloso gelo nane. ");
INSERT INTO aso_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Neꞌmine ogo naneꞌ nenevoꞌ nevoba leze mela nonivo lingine minikevo olusoteuꞌ nene Oꞌmosoꞌmo avese naba molo neive. Neꞌmo nene mela nizave nete aꞌmine avese nene avutoꞌ igi vi helala vilisa ilizaniꞌ nene ngeli vamilisave. Idoꞌ nela nizave nete aꞌmine avese nene avutoꞌ igi mela alisa ilizaniꞌ nene ngeli amilisave. ");
INSERT INTO aso_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Neꞌmine lavo moni heneni ve aza tiꞌ lo lineꞌ: Neꞌmino neineꞌ neivo ma nene meꞌneho make, neze nakuꞌne zuho faef (5) neꞌmine nizaniꞌ nene mulumo alumo gelaaꞌ ebekuꞌ mene inginesi ikelizaze. Lasaloꞌ nene imiselanivo meꞌnehi numuda vo hungoꞌ ngemo gaꞌine dalive. ");
INSERT INTO aso_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Neꞌmine lo lineꞌza Abalahamuꞌ aza tiꞌ lo lo-imineꞌ: Inginela nene Moseꞌ gamazisi idoꞌ polohetelite laniꞌ gamazisi nene neineꞌ nenako aꞌmine gamazi nene gililizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Neꞌmine lavo heneni ve aza tiꞌ lo lineꞌ: Abalahamuvo meꞌneho ve, ne neiha oꞌove, eveneꞌ ma hilikedatiꞌ vi gamazi li-ngimilizaniꞌ nene luꞌine di velepeꞌ izilisave. ");
INSERT INTO aso_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Neꞌmine lavo Abalahamuꞌ aza tiꞌ lo lo-imineꞌ: Idoꞌ Moseꞌ gamazisi idoꞌ poloheteliti gamazisi gili damilizaniꞌ nene ve ma helosa tineꞌ molo ogo lo-ngemelineꞌ nesi nene ma gili eleꞌvoleꞌ igi gili damilisave. ");
INSERT INTO aso_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Izesuꞌ aza neꞌmine lo izipahala zuho gamazi gohi ma tiꞌ lo lo-ngimineꞌ: Eveneꞌ ngimimiseꞌ igi aka golosouꞌ ngeleꞌmizi milaliza niteꞌ nene sotoꞌ amilizavoba mo vaiꞌ sotoꞌ ilisaha aꞌmine initeꞌ di sotoꞌ ilizave nene Oꞌmosoꞌmo lihime naba ngemeleseinako engikumuꞌ agae lo mulumo nogele-ngiduve. ");
INSERT INTO aso_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Neniꞌ izipahaꞌne limi minangutiꞌ mene aka golosouꞌ ma ngeleꞌmizi milalizave nene Oꞌmosoꞌmo mulumo gono atoliꞌmine goloso ngemalive li aꞌmine izipahaꞌne olihe aka golosouꞌ ngeleꞌmizi milalisa naveti luvoꞌninguꞌ nene geheni nabaꞌ naba izi-ngidi noso nabauꞌ ngehusoꞌ i hulikevo noso ni hililizaniꞌ nene lamineꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nemuꞌ lingine nene lutidoꞌ gizebo lamineꞌ igi minilo. Idoꞌ geiꞌ zuho maliꞌmo monovo goloso do lihime nodavo ma gala do elemezo. Neꞌmine oganivo lulo do velepeꞌ izavo ma nene lihimeꞌve hulo-dezo. ");
INSERT INTO aso_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Idoꞌ gamene hamokukovoꞌ geita monovo goloso o-gedo lihime gamene seveni ogosa aza ogo do goloso okuve lo geita ogo lulo do velepeꞌ noizivo ma nene lihimeꞌve gamene seveni neꞌminesi nene ha hulo-dekaꞌ hulo-dekaꞌ olosane. ");
INSERT INTO aso_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Neꞌmine lavo aposolo ingine Guvelesi ve nene tiꞌ li li-imaniꞌ: Gaza gele eleꞌvoleꞌ ogate nene do naba o-ledezo. ");
INSERT INTO aso_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Neꞌmine likevo Guvelesi ve aza tiꞌ lo lineꞌ: Lingine Oꞌmosomuꞌ gili eleꞌvoleꞌ igatine nene sakaveꞌ zuho ngomo neꞌminesi ma minidiniko gihile izaaꞌ ineꞌ za menemuꞌ luhivekasi kiselo vo guvo nosouꞌ zuhoꞌ o minezo lilizadokisi nene ha gele lingimidine. ");
INSERT INTO aso_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lengikutiꞌ ve maliꞌmi gelekeleꞌ izipeꞌve ma minelidiꞌmo minguꞌ gono do minelihe idoꞌ sipisipi izeloꞌ gizebo ogo minelihe ilidotiꞌ nivengaꞌ gonouꞌ osuꞌ lo ogavo liteꞌ lo gaza ogo mitoꞌ mino nosoꞌ niteka nonozo lo gizebo veꞌve neꞌmo nene ha lo-delihe. ");
INSERT INTO aso_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mo ngelo lo-damoloseive. Asi tiꞌ lo lo-emeleseive: Nosoꞌ niteꞌne gize vataꞌ o-nedosa gono daliningumuꞌ do nene ogo gonouꞌ initeꞌ do ngolo nosoꞌ niteꞌ hizo do nemekaꞌ nemekaꞌ nanivo neniꞌ no osuꞌ lokuvosa gaza nene alingeꞌ nalosane. ");
INSERT INTO aso_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Idoꞌ gelekeleꞌ ve aza nene eiꞌ lidoꞌ eꞌmeto gamaziꞌve gele davo aza neꞌmine ingumuꞌ nene tangezoꞌ ve ha lo-delihe. Oꞌve, mo neꞌmine lamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lingine mo aꞌmineꞌmine igi neniꞌ gamaziꞌne gili di aꞌmidoꞌ eꞌmeti osuꞌ lii ma nene lingine tiꞌ li gililo: Laza nene gono atoliꞌmine lamineꞌ guvetesi ve lopoꞌni lilineꞌ votigileloꞌ ma damune. Asi eveneꞌ gono daaꞌ naniꞌ neꞌmine ha olonidoꞌ o minineꞌ initeꞌ ma nene okune li lilo. ");
INSERT INTO aso_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Izesuꞌ nene mo Zelusalemi numuno ebeta volosa nGalilaia misubosi Samalia misubosi olusota vo ");
INSERT INTO aso_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","numuno ebeꞌ ngomo ma minidoꞌ vo nohetelivo ganadise gizi dave teni (10) ingine nete ningi siki zuho ngemalone li aꞌmida hota ha mini ");
INSERT INTO aso_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","vise li-di tiꞌ li laniꞌ: Eveneꞌ naba Izesuvo, leliꞌ mulumote ningevo. ");
INSERT INTO aso_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Neꞌmine li likevo ningo tiꞌ lo lo-ngimineꞌ: Lingine lamineꞌ ilizaniꞌ okodine nene ningisa evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nete gili lingimikevo lingine eveneꞌ gomuꞌ golise i-lingidaaꞌ aniꞌ ma nene gohi bizi monilizangisi vi ngelebizilo. Neꞌmine lavo ganadise gizi dave teni (10) ingine nene ngimiselida nivavo okoꞌnidoꞌ ganadise nene osuꞌ lo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Osuꞌ lo-ngedavo engitatiꞌ maliꞌmo okoꞌnolotiꞌ ganadise osuꞌ lineꞌ nene ningo do tineꞌ molo ogo gekeꞌ gekeꞌ lo Oꞌmoso opoꞌni loꞌmo loꞌmo ");
INSERT INTO aso_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Izesuꞌ neida ogo lemo golo hizo ongo isaaꞌ neve lo-dineꞌ. Aꞌmine ve nene heta atoꞌ ve Samalia misuboutiꞌ ve minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Neꞌmine ogavo Izesuꞌ tiꞌ lo lineꞌ: Eveneꞌ teni (10) neꞌmine nene ganadise engiꞌ okoꞌnidotiꞌ nene osuꞌ lo-ngedaniꞌza ve naeni (9) nene zala vave. ");
INSERT INTO aso_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ingine nene igi Oꞌmoso opoꞌni lilizadoꞌ o neineꞌza ingine gopo nivavo atoꞌ ve Samalia ve hamoꞌ eikovoꞌ mene nahe. ");
INSERT INTO aso_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Neꞌmine lo tiꞌ lo lo-dineꞌ: Gaza geiꞌ gele eleꞌvoleꞌ aineꞌ neꞌmo lamineꞌ ogange. Oto vozo lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Halisaioꞌ ve ingine Izesuꞌni tiꞌ li longoꞌ i-daniꞌ: Oꞌmosoꞌmo gizebo o-ledeli gamene nene naniheꞌ sotoꞌ ilive. Neꞌmine li longoꞌ i-dikevo aza tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo gizebo o-ledelineꞌ gamene nene vetinedunuꞌ ningi nizavo ato atoꞌ suno sotoꞌ neivosa nene ma sotoꞌ amoloseive. ");
INSERT INTO aso_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Idoꞌ eveneꞌ malite mela neize. Ningilo ma lamilisave. Idoꞌ holela neize. Hole ningilo ma lamilisave. Oꞌmoso gizebo o-ledaaꞌ neineꞌ nene lengiꞌ vovotinguꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Neꞌmine lo izipahala zuho nene gohi tiꞌ lo lo-ngimineꞌ: Mine do vo alingeꞌ gamene ma sotoꞌ ilineꞌ gameneuꞌ nene Oꞌmosolatiꞌ ve gihile naza nene ogo sotoꞌ ivo ningelone li laniteꞌ goloso gililizaniꞌza ma ningamilisave. ");
INSERT INTO aso_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aꞌmine gameneloꞌ nene tiꞌ li li-lingimilisave: Ningilo. Hole neive. Idoꞌ ningilo. Me neive. Neꞌmine nili-lingimavo ma nene ingine gamaziloꞌ eꞌmeti aꞌmida vamilo. ");
INSERT INTO aso_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Lingine mo ningi gili nizaniꞌ ma neive. Gopaꞌna ineꞌ nene okulumotoꞌ vaiꞌ mone osuꞌ lavo sotoꞌ ogaꞌ neive. Aꞌmineꞌmine ogo aloniꞌ gamene sotoꞌ ilinguꞌ nene Oꞌmosolatiꞌ ve gihile neniꞌ nene eveneꞌ mukilite ningi osuꞌ lilisave. ");
INSERT INTO aso_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Neꞌmine o neineꞌza olihe neꞌmine amivo idise mene gamenela mine do nouvoda ningi nizaniꞌ aleve nete nene meheꞌine nimi mulumo initeꞌ mukiꞌ goloso gihi-nidilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noaꞌ minineꞌ gameneuꞌ igi mili minaaꞌ aniꞌ maꞌmine nene Oꞌmosolatiꞌ ve gihile neniꞌ aloniꞌ gameneuꞌ nesi nene ha igi mili minilisave. ");
INSERT INTO aso_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Aꞌmine Noaꞌ minineꞌ gameneuꞌ nene noso naba olihe velamivo eveneꞌ ingine nene Oꞌmosoꞌmo ilineꞌ initekumuꞌ gilami okoꞌine losuvoliꞌmi initekumukovoꞌ gili mini adoꞌ nosoꞌ niteꞌ naaꞌ idoꞌ noso naaꞌ idoꞌ veneꞌ alu hizaaꞌ idoꞌ veneꞌ huki milaaꞌ igi nizavo Noaꞌ nene sipiuꞌ dizavo noso naba nene velo ogo eveneꞌ vaiꞌ ngebele geseꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Idoꞌ Lotiꞌ gameneuꞌ nene aꞌmineꞌmine ogosa sotoꞌ ineꞌ ma neive. Aꞌmine gameneuꞌ nene eveneꞌ ingine nosoꞌ niteꞌ naaꞌ idoꞌ noso naaꞌ idoꞌ initeꞌ maketi milaaꞌ meni hizaaꞌ igi idoꞌ mine zuhoꞌ igaꞌ numuno gizaaꞌ igi minaniꞌza ");
INSERT INTO aso_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotiꞌ aꞌmine numuno ebeꞌ Sodomu nene hulo novivo Oꞌmosoꞌmo lavo oloꞌ gulumo ogo minineꞌ geheni nene okulumokutiꞌ goline izaaꞌ neineꞌ neꞌmino lemo ngebele geseꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Neꞌmine ineꞌ nenako Oꞌmosolatiꞌ ve gihile neniꞌ sotoꞌ oloniꞌ gamenela nene aꞌmineꞌmine igi gopo minilizangutiꞌ upuhoꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","32","Oꞌmosoꞌmo Sodomu aleve ngebele geseꞌ neivo Lotiꞌ elenaho aza golise vidoꞌ nene liteꞌ lo vamo aꞌmidoꞌ ha ninge miningumuꞌ ezesi bilineꞌ neꞌmino lengebelalize. Nemuꞌ lingine gatine gili nge li minilo. Aꞌmine gameneuꞌ nene silibe ogo minaaꞌ nene nominako ve ma ingine numuꞌine avitasi nilizadotiꞌ nene iheꞌ numuꞌninguko vi initeꞌ mataꞌine nene di vamilisave. Idoꞌ aꞌmineꞌmine igi mingukotiꞌ nene tineꞌ mili numunguko amilisave. ");
INSERT INTO aso_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Idoꞌ ve ma aza helelohe helelohe lo okoꞌnomuꞌ ehelele izivo minaaꞌ ilive nene alingeꞌ minevoꞌ minevoꞌ emeni dameni damoloseive. Idoꞌ ve ma aza neniꞌ neꞌmeto novilinguꞌ bili hililizaniꞌ nene alingeꞌ minevoꞌ minevoꞌ emeni dameni nene mo daloseive. ");
INSERT INTO aso_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nemuꞌ naza tiꞌ lo nolo-lingimuve: Aꞌmine gameneuꞌ eveneꞌ sitaꞌ ma holukoꞌ holomo hamotoꞌ ingi minilisingutiꞌ ve ma nene Oꞌmosoꞌmo do vavo ma ve nene ha mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Idoꞌ veneꞌ sitaꞌ nosoꞌ niteꞌ di vaꞌvaꞌ igi minilisingutiꞌ ma nene Oꞌmosoꞌmo do vavo ma nene ha mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Izesuꞌ aza neꞌmine lo lavo izipahala zuho ingine tiꞌ li longoꞌ i-daniꞌ: Guvekasi ve, aꞌmine laineꞌ initeꞌ nene zala sotoꞌ ilive. Neꞌmine li longoꞌ i-dikevo aza tiꞌ lo lineꞌ: Eveneꞌ hilaniꞌ gonoso nolida nene gonoso naaꞌ aniꞌ namalite aꞌmida nene liteꞌ li igi di geseꞌ igi minilisave. Aꞌmineꞌmine ogo eveneꞌ luꞌnine unuvo o vineꞌ minilizada nene Oꞌmosoꞌmo lihime ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Idoꞌ gamene ma nene Izesuꞌ aza goseleꞌ ngebelamivo gamene gamene Oꞌmosola laakovoꞌ igi mini hulami minilizave lo aneza gamazi neꞌmino ma lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Numuno ebeꞌ naba mauꞌ zasi ma minineꞌ neꞌmo nene aza Oꞌmosomuꞌ golise gelamaaꞌ idoꞌ evenekumuꞌ nene do haza niteꞌ loloꞌ o-ngedosa gelaaꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Idoꞌ aꞌminguꞌ nene gevonoꞌ ma minineꞌ neꞌmo nene gamene gamene aꞌmine zasi neida ogo tiꞌ lo lovoꞌ lovoꞌ ogo minineꞌ: Ve masi goniꞌ olosa nosize. Aꞌminguꞌ nene neniꞌ gamaziꞌne hize eleꞌ ogo do lisiheꞌ o-nedezo. ");
INSERT INTO aso_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Neꞌmine lokaꞌ lokaꞌ ogo neivo aꞌmine zasi neꞌmo gele hulosa ngomo ma minineꞌza alingeꞌ nene eiꞌ lulouko gala tiꞌ lo gelo lineꞌ: Oꞌmosomuꞌ golise gelamaaꞌ idoꞌ evenekumuꞌ ningo do haza niteꞌ loloꞌ o-ngedaaꞌ nouve nouvoniꞌza ");
INSERT INTO aso_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gevonoꞌ meꞌmo nene lihiteheka lo neineꞌ nenako nemuꞌ nene aza okaꞌ okaꞌ ogo ne do goseleꞌ gehepeve o-nedalive lo eze gamaziꞌve hize eleꞌ ogo do lisiheꞌ o-delove lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Neꞌmine lo Guvelesi ve imineꞌ molo tiꞌ lo lineꞌ: Monovolo goloso o vineꞌ zasi neꞌmo lineꞌ gamazi nene mo gilikeve. ");
INSERT INTO aso_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Idoꞌ Oꞌmoso neꞌmo aꞌmine zasi nene ivileꞌ ogo eze do kegesineꞌ evenele zuho goꞌ laneme goꞌ laneme ezela laaꞌ nave nene hize eleꞌ o-ngedamilihe. Ezela likevo hize eleꞌ o-ngedamo gamene haꞌna ha minelihe. Oꞌve. ");
INSERT INTO aso_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naza lo-lengemelove. Aza liteꞌ lo hize eleꞌ o-ngedeleseive. Neꞌmine oloseineꞌza Oꞌmosolatiꞌ ve gihile aloniꞌ gameneuꞌ nene Oꞌmosomuꞌ gili eleꞌvoleꞌ avemuꞌ nene viseꞌ ogo vaiꞌ ningelohe. Oꞌve. Mo vaiꞌ ningamolosuve. ");
INSERT INTO aso_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Izesuꞌ aza aneza gamazi gohi ma imineꞌ molo lineꞌ nene eveneꞌ malite engikumuꞌ gilavo eveneꞌ lisiheꞌ lamineꞌ dizi minisa eveneꞌ linge mamuꞌ nene gilavo leme minaaꞌ ingumuꞌ nene tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Halisaioꞌ monoꞌ laaꞌ ive maliꞌmo Oꞌmosola lolosa monoꞌ numuno nabauꞌ dize minineꞌ. Neivo ve gohi ma eveneꞌ gono goloso takisi moni daaꞌ ive azasi nene Oꞌmosola lolosa aꞌmine monoꞌ numuno nabauꞌ nene dizo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Halisaioꞌ ve aza nene ote mino Oꞌmosola lulouko tiꞌ lo lineꞌ: Oꞌmosoo, eveneꞌ linge mukiꞌ ingine eveneꞌ goꞌine izi initeꞌ gumine gidini daaꞌ ave nizahe veneꞌ longoꞌ igaꞌ ave nizahe monovo lisihetoꞌ eꞌmetamaaꞌ ave nizahe naza engiꞌ nevoꞌmine ve neꞌmine minamo takisi moni daaꞌ ive meneꞌminesi minamuvoniꞌ nemuꞌ nene mo lamineꞌ ve lo gopoꞌni noluve. ");
INSERT INTO aso_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naza nene salele hamoꞌ hamokuꞌ gamene sitaꞌ sitaꞌ monokumuꞌ ve lo nosoꞌ niteꞌ malise ogo minaaꞌ nouve. Idoꞌ initeꞌ mataꞌne teni teni daaꞌ nouvongutiꞌ hamoꞌ hamoꞌ nene geiꞌ gemaaꞌ nouve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Halisaioꞌ ve aza neꞌmine lineꞌza takisi moni daaꞌ ive nene hota gidini ote mino vokeneꞌ igi okulumokuko vonuꞌ igi Oꞌmosola laaꞌ aniꞌ neꞌminesi amo asi eita lihime monovomuꞌ agae lo gelo losonoloꞌ pouꞌ pouꞌ lo belo tiꞌ lo lineꞌ: Oꞌmosoo, lihimeloꞌ ve nouvoniꞌ nenaze. Mulumoꞌne ningo iseꞌne izezo lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nemuꞌ nene naza tiꞌ lo nolo-lingimuve. Ingine okoꞌine di dizaaꞌ nave nene Oꞌmosoꞌmo doꞌmo leme-ngedo okoꞌine di limaaꞌ nave nene doꞌmo dize-ngedaaꞌ neineꞌ nenako Halisaioꞌ ve nene Oꞌmosoꞌmo lihimeꞌve hulo-do do lisiheꞌ o-divosa vivoba asi takisi moni daaꞌ ive nene Oꞌmosoꞌmo lihimeꞌve hulo do lisiheꞌ o-divosa numuꞌvela vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nelotiꞌ nene eveneꞌ ingine izipe ngomo ngomo nene Izesuꞌ okoꞌnidoꞌ do gelo noꞌnohoꞌ ize-ngedelive li ngeleꞌmizi di Izesuꞌ neida aniꞌza Izesuꞌ izipahala zuho ingine ningi eveneꞌ nene ngelemi oꞌve li-ngidaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Neꞌmine aniꞌza Izesuꞌ aza izipe nene ngeleꞌmizi alizave lo vise nolo-ngedo tiꞌ lo lineꞌ: Izipe ngomo ngomo meꞌmine minave nene Oꞌmosoꞌmo gizebo o neinguꞌ ngeleꞌmize molaaꞌ neinako huli-ngimikavo nenita ha alizaze. Oꞌve li-ngidamilo. ");
INSERT INTO aso_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Naza laminetoꞌ nolo-lingimuve. Izipe ngomoliti ngemeni dameni neꞌminesi mini Oꞌmoso nene gizebo vete minelive li gelekeleꞌ lapa nomineꞌ i-damilizave nene eiꞌ Oꞌmosoꞌmo gizebo o neinguꞌ nene mo kekeꞌ vi hilamilisave. ");
INSERT INTO aso_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Idoꞌ eveneꞌ naba dizo minive maliꞌmo Izesuꞌni tiꞌ lo longoꞌ o-dineꞌ: Tisaꞌ lamino, naza nene nadiꞌ okuvo Oꞌmosoꞌmo minevoꞌ minevoꞌ nemeni dameni nemelive. ");
INSERT INTO aso_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Nezemuꞌ nene ve lamino nanimuꞌ nolo-nedane. Lamineꞌ minave nene hamokisi mo nizamavo Oꞌmoso eiꞌ hamoꞌ nene lamineꞌ minive nenako neꞌmine laineꞌ nene neniꞌ monovoꞌne nadiꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gaza aka gamazi nene mo gele naneꞌ. Aꞌmine gamazi nene tiꞌ lo neive: Lingine veneꞌ vemohoꞌ liliꞌ ikeniꞌ nete bizivoꞌ mini veneꞌ nehe vemohoꞌ nehe gohi masi gopo ingamilo. Idoꞌ lingine eveneꞌ ngibili hilamilo. Idoꞌ gumine amilo. Idoꞌ eveneꞌ mamuꞌ gopoꞌ napa gamazi li-ngidi sakupo gamazi li-ngidamilo. Idoꞌ izetingine metinginemuꞌ gilikevo dizavo gelekeleꞌ i-ngidi minilo. ");
INSERT INTO aso_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Neꞌmine lavo ve aza tiꞌ lo lo-imineꞌ: Aꞌmine laineꞌ mukiꞌ nene naza izipelotiꞌ gelo eꞌmeteꞌmo ogo minuvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Neꞌmine lavo Izesuꞌ aza nene gelo ve nene tiꞌ lo lo-imineꞌ: Gaza initeꞌ hamoꞌ ma amanidiꞌmo nene olihe lisiheꞌ gehepeve amane. Nemuꞌ nene gaza initeꞌ mataka vaiꞌ geita minineꞌ nene meni dosa aꞌmidotiꞌ moniꞌve nene izeꞌ molo gohoꞌ gahaliꞌ minaniꞌ nene ngeme osuꞌ lozo. Neꞌmine ilineꞌ neꞌmo nene henenika Okulumokuko nene ma mineleseive. Idoꞌ neꞌmine ogosa nene ogo neniꞌ neꞌmetezo. ");
INSERT INTO aso_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Neꞌmine lineꞌza ve aza nene moni heneni ve goloso minineꞌ nenako nemuꞌ Izesuꞌ lineꞌ gamazi nene aza gilivo geni belavo golo muheleꞌ ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Neꞌmine ogavo Izesuꞌ aza vonuꞌ bele mino tiꞌ lo lo-ngimineꞌ: Heneni nganeni vaiꞌ goloso di minaaꞌ nave nene Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ nene vilisa geꞌnebe goloso ilisave. ");
INSERT INTO aso_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Idoꞌ kamela ize nene naba neineꞌ nenako nemuꞌ nene nalaꞌ lolosoꞌ igaꞌ naniꞌ nakese neꞌmi veleuꞌ nene ma volosa ilineꞌ nene geꞌnebe goloso oloseineꞌza heneni ve nete aꞌmine nene ivileꞌ ivosa Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ nene vilisa geꞌnebe goloso ilisave. ");
INSERT INTO aso_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Neꞌmine lo lavo aꞌmine gamazi gilave nete tiꞌ li Izesuꞌni li-imaniꞌ: Laza nene Oꞌmosoꞌmo umo hilive nene heneni ve loloꞌ o-ngedaaꞌ neihe lo giluneꞌza gaza heneni ve netesi Oꞌmosoꞌmo gizebo o neineꞌ ebekuꞌ nene mo vi hilamilisave lainako nemuꞌ nene Oꞌmosoꞌmo eveneꞌ hamokisi mo ma do luꞌ izamivo eze gizebo inguꞌ nene vo holamolobe lo nogilune. ");
INSERT INTO aso_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Neꞌmine li laniꞌza Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Eveneꞌ ingine ngeli amilizaniꞌ initekisi Oꞌmosoꞌmo ogaꞌ neive. Nemuꞌ nene eveneꞌ do nguꞌ izelidoꞌ lisiheꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Neꞌmine lavo Petoloꞌ aza aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Gaza gelezo. Laza nene ebete initete mukiꞌ nene hulo osuꞌ lo nogeꞌmetuniko aꞌmidoꞌ meni nani dalone. ");
INSERT INTO aso_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ nolo-lingimuve. Ve ma ingine Oꞌmosoꞌmi gizebouꞌ vo holaloningumuꞌ ve li aꞌminguko neꞌmeti alisa numuꞌine ebeꞌine nehe eleꞌningine uvoꞌningine nakuꞌningine zuho nehe izeꞌningine meꞌningine nehe izipahaꞌine nehe nene huli osuꞌ li neꞌmeti alizaniꞌ nene ");
INSERT INTO aso_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","aꞌmine initeꞌ vaiꞌ hulilizadoꞌ nene golo hizo me misubouko mini mili ilizanguꞌ nene Oꞌmosoꞌmo vaiꞌ goloso imineꞌ molo ngemavo dalisave. Idoꞌ alingeꞌ gamene nabala nene minevoꞌ minevoꞌ ngemeni dameni nene dalisave. ");
INSERT INTO aso_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Idoꞌ Izesuꞌ aza izipahala zuho tuvelu nene ngeleꞌmize abazaꞌ ogo tiꞌ lo lo-ngimineꞌ: Gililo. Laza nene Zelusalemi numuda dizo novune. Aꞌmida vokunivo polohetelite Oꞌmosolatiꞌ ve gihile nenitoꞌ sotoꞌ ilineꞌ initekumuꞌ monoꞌ godolouꞌ li sotoꞌ igi gizaniꞌ maloꞌ nene sotoꞌ oꞌmo vo gihile ize osuꞌ loloseive. ");
INSERT INTO aso_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Idoꞌ neꞌmine noluvoniꞌ nene nemuꞌ noluve. Neniꞌ nene Zuda ve minamaniꞌ atoꞌ aleveti aꞌninguꞌ mili-nidikevo ingine gize zohiꞌ i-nidi novozo suno goloso di-nidi gituhoꞌ i-nidi ");
INSERT INTO aso_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","gasavasi nalaꞌ nedunuꞌ meheꞌne iziviꞌ lediviꞌ igi idoꞌ nibili hililisave. Neꞌmine ikevo helo gamene sitohamo mino gohi otelesuve. ");
INSERT INTO aso_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Neꞌmine lo lineꞌza ingine aꞌmine initekumuꞌ nene ma gili guni amave. Ee, aꞌmine gamaziꞌve nene hito minavo lineꞌ initeliꞌmi monovo nene gilamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Izesuꞌ aza mo Zeliko numuno ebetoꞌ nene ogo hetelelesa navo aka gahevela nene vele likive ma mino moni vokuꞌ vokuꞌ lo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Neꞌmino mino gilineꞌ nene eveneꞌ vaiꞌ goloso igi nivavo gelo nanitekumuꞌ nahe lo longoꞌ o-ngedavo ");
INSERT INTO aso_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","tiꞌ li li-imaniꞌ: Nasalete ve Izesuꞌ ma nene ogo novive. ");
INSERT INTO aso_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Neꞌmine likevo gelo vise naba lo tiꞌ lo lineꞌ: Izesuvo, guvelesi ve naba Davidiꞌ aꞌvo ezeloꞌ medelo minanive make, nenikumuꞌ nene mulumoꞌne ningevo. ");
INSERT INTO aso_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Neꞌmine lavo gomuꞌ ave nete nene legeno minelive li oꞌve li-di elemaniꞌza aza nene gohi amuzo molo vise naba lo gohi tiꞌ lo lineꞌ: Davidiꞌ aꞌvo make, nenikumuꞌ nene mulumoꞌne ningevo. ");
INSERT INTO aso_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Neꞌmine lo lavo Izesuꞌ aza gelo vo akaloꞌ ha ote mino aꞌmine vele likive nene neida eleꞌmizi alizave lo lo-ngidineꞌ. Neꞌmine lavo aꞌmine vele likive nene mo avita ogavo Izesuꞌ tiꞌ lo longoꞌ o-dineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Gaza nene nadiꞌ o-gedelove losa nogelane. Neꞌmine lavo vele likive aza tiꞌ lo lineꞌ: Guvekasi ve, gaza veꞌne nene do lamineꞌ oganivo gohi ningeloho. ");
INSERT INTO aso_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza nene gele eleꞌvoleꞌ anidiꞌmo lamineꞌ ogange. Veka nene gohi ningezo. ");
INSERT INTO aso_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tiꞌ lo nolivo aꞌmidoꞌ liteꞌ lo vele nene mo lamineꞌ ogavo vele ningo eꞌmeto novo Oꞌmoso opoꞌni loꞌmo vineꞌ. Eveneꞌ mukiꞌ ingine aꞌmine nene ningi Oꞌmoso opoꞌni li di naba i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Izesuꞌ aza ebeꞌ mala volosa Zeliko numuno ebekuꞌ dizo novivo ");
INSERT INTO aso_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","aꞌmida ve ma minineꞌ gulive Zakaioꞌ aza takisi moni daaꞌ ive naba mino mo heneni ve goloso minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Idoꞌ Izesuꞌ novivo zaho neve lo eze ningelesa ineꞌza eveneꞌ liꞌnibe ngomo minineꞌ nenako eveneꞌ vailiti meheꞌnida mino ngelo ningamilineꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nemuꞌ nene eze ningelongumuꞌ ve lo gomuꞌ molo lotiꞌ izo vo gohuno za gele vineꞌ ma Izesuꞌ vilineꞌ akala minineꞌ nenako aꞌminguꞌ nene vo dize minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Neꞌmino dize neivo Izesuꞌ aꞌmida vo hetelo aꞌmine zauko vonuꞌ ogo Zakaioꞌni tiꞌ lo lo-imineꞌ: Zakaioo, idise nene geiꞌ numungauꞌ mineloniꞌ nenaze. Liteꞌ lo lemezo. ");
INSERT INTO aso_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Neꞌmine lavo liteꞌ lo lemo Izesuꞌni nene olize numudoꞌ mino eleꞌmizo numuꞌvela vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Idoꞌ neꞌmine ineꞌ nene eveneꞌ mukiꞌ ningi aza nene lihimeloꞌ veꞌmi numunguꞌ minelesa dizo vaave li Izesuꞌni nene emenga laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Neꞌmine navo Zakaioꞌ aza ote mino Guvelesi ve nene tiꞌ lo lo-imineꞌ: Guvekasi ve, gaza gelezo. Initeꞌ mataꞌne nene olusotoꞌ molo mino izeꞌ molo lingela nene gohoꞌ aleve ngemelesuve. Idoꞌ naza eveneꞌ malitidatiꞌ initeꞌ ma goꞌine izo gumine gidini do noloniꞌ nene naza aꞌmidoꞌ golo hizo initeꞌ hamo hamotoꞌ nene initeꞌ sitaꞌve sitaꞌve molo ngemekaꞌ ngemekaꞌ olosuve. ");
INSERT INTO aso_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Oꞌmosolatiꞌ ve gihile naza uvoniꞌ nene eveneꞌ ma vi tolovo iliza akaloꞌ mini mili minave nene viseꞌ ogo do nguꞌ izelove losa uvoniꞌ nenako ve mene ve lulo do velepeꞌ izo leliꞌ ogaꞌ nounidiꞌmine ogo Oꞌmosoꞌmi louꞌ gamazi lidoꞌ eꞌmetelesa nolinako neꞌmo nene azasi Abalahamuꞌ aꞌvopilemoꞌ gihile minineꞌ nene mo sotoꞌ oganako idise mene numunguꞌ nizaniꞌ aleve menesi Oꞌmosoꞌmo mo do lunguꞌ noizive. ");
INSERT INTO aso_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Neꞌmino Izesuꞌ gamazi lo-ngimidoꞌ nene gapepeꞌ igi gili nizavo aneza gamazi gohi ma imineꞌ molo nemuꞌ lineꞌ ve. Aza nene mo Zelusalemi numuno ebekuꞌ vo hetelelesa do alite alite neineꞌ nemukisi idoꞌ makaꞌ minave nete nene Oꞌmosoꞌmo gizebo o-ledelineꞌ gamene nene mo aꞌne sotoꞌ oke leive li gili minaniꞌ nemukisi nene mo ladeni gaꞌine gilikeve losa nemuꞌ nene Oꞌmosoꞌmo gizebo o-ledelineꞌ gamene geto sotoꞌ amoloseinako lo aꞌminemuꞌ gizebo igi minilizanguꞌ igi mili ilizaniꞌ monovomuꞌ aneza gamazi lo-ngimineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aꞌmine aneza gamazi nene tiꞌ lo lineꞌ: Ve naba maliꞌmo nene misubo hotoꞌ misubola nene vokuvo Guveꞌnesi ve naba loloꞌ i-nidikevo tineꞌ molo numuꞌnela alove lo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Neꞌmino volosa gelekeleꞌ izipeꞌve teni neꞌmine vise lo-ngemo moni nene vanu hadeti kina (K100) neꞌmine ngemekaꞌ ngemekaꞌ ineꞌ. Neꞌmino nongemo tiꞌ lo lo-ngidineꞌ: Lingine nene aꞌmine monidunuꞌ nene gono gihiꞌmi vi nizavo tineꞌ molo alove. ");
INSERT INTO aso_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Neꞌmine lineꞌza eze gizebo o-ngede minineꞌ aleve linge ma nete nene goseleꞌ goloso ngebelavo aꞌmine ve vida nene eveneꞌ ma gamazi tiꞌ li lisa ngimiselaniꞌ: Ve meve nene guvetesi ve minamilive lo nolune. ");
INSERT INTO aso_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Neꞌmine laniꞌza mo guvelesi ve liliꞌ i-dikevo minidotiꞌ tineꞌ molo aniꞌ nene moni ngimuve nene gono do nanikeꞌ imineꞌ mili di sotoꞌ ahe ningeloniꞌ nenaze. Nemuꞌ nene nenita alizaze. Vise li-ngidilizave lavo vise li-ngidikevo ikaꞌ ikaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ganaꞌ ave neꞌmo nene tiꞌ lo lineꞌ: Guvekasi ve, gaza hadeti kina (K100) nemaineꞌ malotiꞌ nene vanu tauseni kina (K1000) gohi ma do sotoꞌ okuve. ");
INSERT INTO aso_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Neꞌmine lavo guvelesi veꞌmo tiꞌ lo lo-imineꞌ: Gelekeleꞌ izipe lamineꞌ goloso nane. Gonoloꞌ gizebo lamineꞌ goloso ogane. Gono ngomoloꞌ gizebo lamineꞌ aineꞌ nemuꞌ nene numuno ebeꞌ teni neloꞌ nene gizebo ve hulo-gedelesuve. ");
INSERT INTO aso_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Neꞌmine lavo aꞌmidotiꞌ ave neꞌmo nene tiꞌ lo lineꞌ: Guvekasi ve, gaza hadeti kina (K100) nemaineꞌ malotiꞌ nene faef hadeti kina (K500) gohi ma do sotoꞌ okuve. ");
INSERT INTO aso_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Neꞌmine lavo guvelesi veꞌmo tiꞌ lo lo-dineꞌ: Geiꞌ nene numuno ebeꞌ faef neꞌmidoꞌ nene gizebo ve hulo-gedelesuve. ");
INSERT INTO aso_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Neꞌmine lavo gelekeleꞌ izipe gohi maliꞌmo ogo tiꞌ lo lineꞌ: Guvekasi ve, gaza hadeti kina (K100) nemaineꞌ ma nene gohi do nogimuve. Gaza nene gasava ve mino eveneꞌ malite milikaniꞌ initeꞌ nene geiꞌ do tiꞌ ogaꞌ nane. Idoꞌ ve malite zuhoꞌ aniꞌ initeꞌ nene geiꞌ do tiꞌ o mino dolizo naaꞌ nane. Nemuꞌ nene naza geiꞌ goliseka gelo aꞌmine moni nemaineꞌ ma nene lavolavouꞌ asabuꞌ izo do haleko molokuvoniꞌ nene do nogimuve. ");
INSERT INTO aso_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Neꞌmine lavo guvelesi ve aza tiꞌ lo lo-imineꞌ: Gelekeleꞌ izipe goloso gaza mene geiꞌ vekatiꞌ laineꞌ gamazika maꞌmo goniꞌ o-gedeleseive. Gaza nenikumuꞌ tiꞌ lo labe: Gaza gasava ve mino eveneꞌ malite milikaniꞌ initeꞌ nene geiꞌ do tiꞌ ogaꞌ nane. Idoꞌ ve malite zuhoꞌ aniꞌ initeꞌ nene geiꞌ do tiꞌ o mino dolizo naaꞌ nane labe. ");
INSERT INTO aso_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Naza nene geiꞌ laineꞌ neꞌmine ogaꞌ uve noloniꞌ nene gaza moniꞌne nene do vo beni numunguꞌ molo-nedekelinako nanimuꞌ neꞌmine amane. Neꞌmine anidiniko naza idise mene uvodoꞌ nene polopetisi duvodine. ");
INSERT INTO aso_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Neꞌmine lo-emo guvelesi veꞌmo aꞌmida minavemuꞌ nene tiꞌ lo lo-ngimineꞌ: Aꞌmine hadeti kina (K100) do neineꞌ mene ipeꞌ igi vanu tauseni kina (K1,000) do minive nene imilo. ");
INSERT INTO aso_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Neꞌmine lavo ingine nene tiꞌ li laniꞌ: Guvekasi ve, tauseni kina (K1,000) nene mo do neineꞌ nenako emamoloinako gohi emelobe laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Neꞌmine likevo guvelesi ve aza tiꞌ lo lo-ngimineꞌ: Naza tiꞌ lo nolo-lingimuve: Initeꞌ ma di nilizave nene gohi ma ngimi aꞌminguꞌ ikevo dalisave. Neꞌmine ilisaniꞌza initeꞌ ma dami minilizave engita nene ngomo ma di nilizaniꞌ nesi nene engitatiꞌ ipeꞌ igi di vikevo haza minilisave. ");
INSERT INTO aso_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Idoꞌ neniꞌ biluvaꞌne nenikumuꞌ engiꞌ guveꞌinesi ve loloꞌ amiline lave ma nene ngeleꞌmizi di igi veꞌneloꞌ mene ngibili geseꞌ ilo. ");
INSERT INTO aso_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Izesuꞌ aza tiꞌ lo lo-ngemo Zelusalemi numuno akala nene do gomuꞌ molo dizo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mo vo numuno ebeꞌ sitaꞌ Betehagesi Betanisi Oliva Golo ve ladoꞌ minasida nene omo avitoꞌ ogo izipahala zuho sitaꞌ ma ngimiselo ");
INSERT INTO aso_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tiꞌ lo lineꞌ: Lingine aꞌmine ningi nizasineꞌ numuno ebekuꞌ volene vi dizi ningilisineꞌ nene dongi ize angale naba evenelitesi aꞌmidoꞌ olihe mitoꞌ mini monamaniꞌ nene ningilisasize. Aꞌmine nene vakesi di mela alizo. ");
INSERT INTO aso_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Idoꞌ aꞌmine nene vi nivakesasivo evenelite lingine nanimuꞌ nivakesasive nilavo ma lingine tiꞌ li lilizo: Gono neivosa Guvelesi veꞌmo aꞌmine ize memuꞌ limiselavo usineꞌ ve li lilizo. ");
INSERT INTO aso_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Neꞌmino ngimiselavo ngimiselive ingine vi aꞌmine dongi ize nene Izesuꞌ lineꞌ maloꞌ eꞌmeti ningasineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ningi nivakesasivo aꞌmine dongi ize neꞌmi meꞌninge nete tiꞌ li li-ngimaniꞌ: Dongi ize nene nanimuꞌ nivakesasive. ");
INSERT INTO aso_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Neꞌmine likevo ingine tiꞌ li lasineꞌ: Guvelesi veꞌmo gono neivo aꞌmine ize mamuꞌ limiselavo nousive. ");
INSERT INTO aso_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Neꞌmine li Izesuꞌ neida di ikesivo saketiꞌine nene apasi aꞌmine dongi ize neꞌmi meheneloꞌ nene Izesuꞌ minelive li hitikevo aꞌmidoꞌ mitoꞌ minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mo mitoꞌ mino novivo eveneꞌ ingine geneganaꞌine nene apasi kuluhizi akaloꞌ mili-dikaꞌ mili-dikaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Neꞌmine navo Izesuꞌ aza Zelusalemi numuno ebeꞌ nene mo do avitoꞌ noogo Oliva Gololatiꞌ lemo omo minineꞌ akaloꞌ nene vo nohetelivo eze eꞌmeti ave mukiꞌ goloso ingine nene apiꞌ igi ngolize niizi gono lamineꞌ ato atoꞌ amuzo molo davo ninganiꞌ nemuꞌ nene Oꞌmoso opoꞌni nili gekeꞌ gekeꞌ li ");
INSERT INTO aso_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","tiꞌ li laniꞌ: Guvetesi ve naba Oꞌmosoꞌmi velemuꞌ anive nene noꞌnohoꞌ geita minivoo. Okulumokuꞌ miniveꞌmo hongu lo mineloneꞌ monovo nene do sotoꞌ ogavosa aꞌmine veleta Okulumokuꞌ minivemuꞌ nene opoꞌni nolune. ");
INSERT INTO aso_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Idoꞌ eveneꞌ muliseutiꞌ Halisaioꞌ ve linge malite Izesuꞌni tiꞌ li li-imaniꞌ: Tisazo, izipaha zuho nene neꞌmine li gekeꞌ gekeꞌ lamilo lo oꞌve lo-ngedo ngelemevo. ");
INSERT INTO aso_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Neꞌmine likevo Izesuꞌ tiꞌ lo lineꞌ: Naza laminetoꞌ nolo-lingimuve. Idise mene gekeꞌ gekeꞌ li vise naba nilaniꞌ nene ma lamadiniko adoꞌ geheni mevotesi nene gekeꞌ gekeꞌ li neꞌmine ladine. ");
INSERT INTO aso_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Neꞌmine ogo Zelusalemi numuno ebeta nene omo avitoꞌ noogo aꞌmine Zelusalemi numuno ebeꞌ nene noningo aꞌminemuꞌ ive ineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ive noogo iveutiꞌ nene tiꞌ lo lineꞌ ve: Lingine hongu li minilizaniꞌ aka do sotoꞌ o-lengedelineꞌ monovo nene aloꞌ gozopotatiꞌ gililizanako idisesi nene mo apiꞌ igi gililizadoꞌ o neiha idisesi nene ha vetidoꞌ hite neinako gohi ngeli ma ningamilizaniꞌ oganako lengikumuꞌ nene agae lo nogiluve. ");
INSERT INTO aso_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Neꞌmine lo nogiluvoniꞌ nene nanitekumuꞌ ve. Oꞌmosoꞌmo lengiꞌ do lunguꞌ izelesa lengita aniꞌ gamene nene ma ningi gilamaniꞌ neꞌmo lengita nene gamene atoꞌ ma aloseive. Aꞌmine gameneuꞌ nene biluvalite igi numudine gesi heta nene misubo mili di dizi numuno nabaꞌ nabaliꞌmi laveloꞌ nene di lisiheꞌ igi vilizaniꞌ akatine hizi tili-lingidi aꞌmidatiꞌ aꞌmidatiꞌ biluvalite mo lili gesi neꞌmine hize-lingidi galapuso lingimilisave. Neꞌmine i-lingidikevo aꞌmine numuno ebetinesi linginesi nene ingi geseꞌ ilisave. Aꞌmine numudine gizaniꞌ geheni nesi nene mo bili tululu li hulikevo aꞌmingutiꞌ geheni sitaꞌ nesi nene lobeꞌ igi minamilisasive. ");
INSERT INTO aso_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nelotiꞌ nene monoꞌ numuno nabauꞌ vo dizo aꞌminguꞌ initeꞌ maketi mili minave nene ngeleto do nohulo-ngedo ");
INSERT INTO aso_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo lineꞌ gamazi monoꞌ godolouꞌ ma tiꞌ lo neineꞌ ma neive: Neniꞌ numuꞌne nene eveneꞌ dizi nopoꞌni li-nimaaꞌ numuno mineleseive. Neꞌmine li gizi nizaniꞌ ma neineꞌza lingine aꞌminguꞌ igi mili minaaꞌ naniꞌ initeꞌ neꞌmo nene gumineloꞌ vete igi mili minaaꞌ numuno loloꞌ ogave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Idoꞌ aꞌmine gamenelotiꞌ apiꞌ ogo monoꞌ numuno nabauꞌ nene gamene gamene eveneꞌ monoꞌ apize ngemo minineꞌ. Neꞌmino neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nesi louꞌ gamazi apizi ngimaaꞌ ave nesi idoꞌ eveneliti gizebo veꞌine nesi ingine aꞌmine Izesuꞌni nene bili hililizaniꞌ akamuꞌ viseꞌ aniꞌza ");
INSERT INTO aso_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","eveneꞌ nete eiꞌ gamaziꞌve gililisa amuzo mili minaniꞌ nenako neꞌmo nene Izesuꞌni bililizaniꞌ aka nene viseꞌ igi ma ningamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gamene ma Izesuꞌ aza monoꞌ numuno nabauꞌ nene eveneꞌ monoꞌ gamazi apize ngeme ngemeꞌ ogo eiꞌ gamaziꞌve lamineꞌ nene lo-ngemo neivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi monoꞌ gamazi apizi ngimaaꞌ avesi idoꞌ monoꞌ gizebo ve nesi nene Izesuꞌ neida igi ");
INSERT INTO aso_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tiꞌ li longoꞌ i-daniꞌ: Gaza initeꞌ mene mela ogaꞌ naineꞌ nene zahi velemuꞌ ogaꞌ nane. Idoꞌ zaho lavosa ogaꞌ nane. Nemuꞌ lo-lemezo. ");
INSERT INTO aso_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Likevo aza tiꞌ lo lo-ngimineꞌ: Nazasi initeꞌ mamuꞌ longoꞌ o-lengedelesuze. Lingine li-nimilo. ");
INSERT INTO aso_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Monoꞌ noso holo-ngedelive lo Zohaneꞌni imiselive ma nene Oꞌmosoꞌmo imiselihe haza misubouꞌ velite imiselave. ");
INSERT INTO aso_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Neꞌmine lavo angiseꞌine li voleloꞌ meloꞌ igi tiꞌ li laniꞌ: Laza Oꞌmosoꞌmo imiselive losoꞌ nene lingine eitoꞌ nene nanitekumuꞌ gili eleꞌvoleꞌ amave lo lalive. ");
INSERT INTO aso_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne neiha haza misubouꞌ velite imiselave losoꞌ nene eveneꞌ ingine Zohaneꞌ nene polohete ve li gili nizaniꞌ nenako nemuꞌ ingine geheni libililisave li ngehelele izavo golise gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Neꞌmine igi tiꞌ li li-imaniꞌ: Monoꞌ noso holo-ngedelive lo imiselive nene zaho nolihe ma gelamune laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine li-nimamaniꞌ nemuꞌ nene nazasi ogo molo ogaꞌ nouvoniꞌ initeꞌ mene iline lo nimiselivemuꞌ nene ma lo-lengemamolosuve. ");
INSERT INTO aso_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Idoꞌ apiꞌ ogo aneza gamaziutiꞌ eveneꞌ tiꞌ lo lo-ngimineꞌ: Ve maliꞌmo vaini mine ma zuhoꞌ ogo eveneꞌ ma mine gizebo i-dilizave lo hulo-ngedo misubo mala vo gamene haꞌna minineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aꞌmida neivo vaini nalaꞌ gihile elaaꞌ gamene ogavo mine meleho aza aꞌmine vaini nalaꞌ gihile nene ma ili nimikevo do-nedo alive lo gelekeleꞌ izipe ma imiselavo mine gizebo avela vo hetelineꞌza ingine bili imiseli hulikevo initekisi ma damo haza tineꞌ molo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Neꞌmine ogavo gohi gelekeleꞌ izipeꞌve ma imiselavo vineꞌza aꞌminesi bili di goloso initeꞌ gehepeve i-di imiseli hulikevo initekisi ma damo haza tineꞌ molo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Neꞌmine ogavo gohi setohamo ivo gelekeleꞌ izipe ma nene imiselavo vineꞌ. Vavo aꞌminesi nene mine gizebo ve ingine bili di goloso igi huli heta i-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Neꞌmine ikevo mine meleho aza tiꞌ lo lineꞌ: Naza nene nadiꞌ oꞌ nalove. Naza luꞌne eme nouvoniꞌ gipeꞌne mene eze gamaziꞌve gili di eleꞌmizi lamineꞌ ma ilizahe imiselekuvo vilive. ");
INSERT INTO aso_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Neꞌmine lo gelo imiselavo vo hetelavo mine gizebo ve ingine ningi angise tiꞌ li laniꞌ: Me veꞌmo melehidoꞌ medelo mino mine mene dalive neinako aꞌmine mine mene leliꞌ mide loloꞌ ilingisi mo bele helelone. ");
INSERT INTO aso_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Neꞌmine li vaini mingutiꞌ nene geleleheꞌ igi eleꞌmizi di vi gesi heta bilaniꞌ ve. Neꞌmine aniꞌ nenako nemuꞌ nene vaini nalaꞌ mine neꞌmi meleho aza nene nadiꞌ o-ngedelive. ");
INSERT INTO aso_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aza ogo hetelo aꞌmine gizebo ve nene ngebele helo miꞌveloꞌ nene eveneꞌ gizebo ilizave gohi ma hulo-ngedeleseive. Neꞌmine lo Izesuꞌ lavo eze gamazi gili minave ingine gili tiꞌ li laniꞌ: Eꞌe. Neꞌmino sotoꞌ amilihoo. ");
INSERT INTO aso_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Neꞌmine laniꞌza aza gelo vonuꞌ ngebelo tiꞌ lo lineꞌ: Idoꞌ lingine neꞌmine lii ma monoꞌ godolouꞌ gamazi ma tiꞌ li gizi nizaniꞌ ma nene neniꞌ luvodoꞌ nene mo vo damive lisa gili nizahe. Oꞌve. Mo vo do neive: Numuno gizilizaniꞌ geheni mukikutiꞌ geheni ma nene numuno gizaaꞌ avete ningi goloso o vive li di kegesi di hulaniꞌ geheni neꞌmo nene geheni mukiꞌ ngivileꞌ ogo numuno do amuzo molaaꞌ geheni loloꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ve ma ingine aꞌmine gehedoꞌ veleheꞌ limi ingalizaniꞌ nene izi iti hupuꞌ izilisave. Idoꞌ aꞌmine geheni neꞌmo lemo eveneꞌ ma ngebelelineꞌ nene izo lanahana o-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Neꞌmine lavo monoꞌ monovo apizi ngimaaꞌ avesi evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ avesi ingine aneza gamazi lineꞌ mene lelikumuꞌ lo molo logave li gili aꞌmidoꞌ nene analoꞌ di bililisa laniꞌza evenekumuꞌ golise gilaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Neꞌmine igi mini Izesuꞌni nene gamazi lo gopo ilidotiꞌ analoꞌ do do vo guvelesi ve naba neꞌmi anauꞌ molalone li lelitatiꞌ eveneꞌ ma ngimiselekunivo ingine vi Izesuꞌni gamazidunuꞌ longoꞌ i-di minavo gamazi gopo lilingumuꞌ ve li eveneꞌ ma ngimiselikevo ingine vi eveneꞌ lamineꞌ minave gili mini gamazi lo gopo ilingumuꞌ amamakaꞌ mili minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Neꞌmine igi mini Izesuꞌni longoꞌ i-dilisa tiꞌ li li-imaniꞌ: Tisazo, geiꞌ monovoka gele none. Gaza eveneꞌ gamazi apize ngemaaꞌ naineꞌ monovoka nene mo lisiheꞌ laminekovoꞌ o minaaꞌ neive. Gaza gamazi lo-ngemelineꞌ aleve nene naniꞌmine aleve nilizahe eveneꞌ dizi nizaniꞌ nilizahe limi minaniꞌ nilizahe gasava ve nilizahe hongu ve nilizahe nemuꞌ gaka mukiꞌ gelamo Oꞌmosoꞌmi aka lelebizo gamazi gihilevoꞌ lo lemaaꞌ anive nane. ");
INSERT INTO aso_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nemuꞌ nene gaza laanivo gelelone. Loma veti guveꞌinesi ve ngamani naba Kaesaleꞌ aza takisi moni huli-nidilizave lo neidoꞌ nene eꞌmeto Zuda ve laza ma hulo-desoꞌ nene lisiheꞌ o neihe louꞌ gamazite avutoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Neꞌmine laniꞌ nene Kaesaleꞌni takisi moni imilo lilineꞌ neꞌmo Zuda ve nene ngizeboloꞌ molavo ganala dalive. Idoꞌ imamilo lilineꞌ nene Loma ve ngizeboloꞌ molavo nesi ganala dalive li ingine gili mini eiꞌ golo izi laniꞌ nene Izesuꞌ aza mo ningo gelo tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Lingine moni ma di igi nelebizilo. Me moniloꞌ eveneliꞌmi golo velesi gulivesi neineꞌ nene zahi golo velesi gulivesi neive lo lo-ngedavo ingine tiꞌ li laniꞌ: Kaesaleꞌ ma ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Tiꞌ li ma aꞌmine moni nene ngamani gizebo ve eiꞌ Kaesaleꞌ initeꞌve noloseinako aꞌminemuꞌ nolivo ma nene ha imilo. Idoꞌ aꞌmineꞌmine igi Oꞌmosoꞌmo lingimineꞌ initetoꞌ nene ha golo hizi imilo. ");
INSERT INTO aso_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Neꞌmine lavo ingine eveneꞌ mukiliti veꞌnidoꞌ nene gamaziꞌve lidotiꞌ nene ngeli di goniꞌ i-damilizaniꞌ o vivo ingine longoꞌ i-dadoꞌ gamazi do tiꞌno lo-ngimineꞌ gamazi nemuꞌ nene voꞌine vavo gamazi lami minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nizavo Sadukaioꞌ monoꞌ laaꞌ ave engikutiꞌ helaakutiꞌ otaaꞌ nene nomive laaꞌ ave linge ma ingine Izesuda igi longoꞌ i-di ");
INSERT INTO aso_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","tiꞌ li laniꞌ: Tisazo, Moseꞌ aza luhuvo gize-lidineꞌ nene tiꞌ lo neive: Uvoꞌninge nakuꞌninge ma minilizangutiꞌ maliꞌmo veneꞌ do mino izipe gedamo helavo ma engikutiꞌ maliꞌmo aꞌmine gevonoꞌ veneꞌ nene dosa aꞌmine hilive nemuꞌ medelo izipe gedo molo-delive. ");
INSERT INTO aso_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Neꞌmine ilisanako nemuꞌ nene uvoꞌninge nakuꞌninge seveni ma minaniꞌ ve. Ganaꞌ ve neꞌmo veneꞌ do izipahala ma sotoꞌ amavo hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Idoꞌ hilive neꞌmi mehenelotiꞌ neꞌmo daniꞌza aꞌmineꞌmine ogavo ");
INSERT INTO aso_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ma neꞌmo do mino aꞌmineꞌmine ogo hilineꞌ. Mo mukitoꞌ aꞌmineꞌmine ikaꞌ ikaꞌ igi izipahaꞌine ma gidami hili osuꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Neꞌmine ikevo alingeꞌ nene veneꞌ nesi hilineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Neꞌmine ineꞌza eveneꞌ seveni aꞌmine veneꞌ daniꞌ nenako eveneꞌ mukiꞌ hilangutiꞌ otiliza gameneuꞌ nene veneꞌ nene zahi elenaho loloꞌ ogo minelive. ");
INSERT INTO aso_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aza aꞌmidoꞌ ngelo do velepeꞌ izo lamivo gize zohiꞌ o-delobe li neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Idise mene noneꞌ gameneloꞌ nizaniꞌ aleve lingine nene veneꞌ daaꞌ idoꞌ veloꞌ vaaꞌ igaꞌ naniꞌza ");
INSERT INTO aso_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","eveneꞌ ma alingeꞌ gamene vomila hili nilizangutiꞌ gohi oti minevoꞌ minevoꞌ ngemeni dameni di otuhiliza aleve nene veneꞌ daaꞌ idoꞌ veloꞌ vaaꞌ ami minilisave. ");
INSERT INTO aso_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aꞌmine aleve ingine nene angeloꞌ neꞌmine minilisanako mo hilamilisave. Idoꞌ hili nilizangutiꞌ otiliza aleve nene Oꞌmosoꞌmo do ote-ngidineꞌ nenako mo eiꞌ izipahala neꞌmine liliꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Idoꞌ helaakutiꞌ otaaꞌ nemuꞌ nene Moseꞌ neꞌmosi nene do sotoꞌ ogo lelebizave. Adoꞌ aza za ngomoutiꞌ oloꞌ gulumo ineꞌ gamazi gizida nene Oꞌmosoꞌmo lineꞌ gamazi tiꞌ lo gizidotiꞌ nene lelebizineꞌ ma neive: Naza Abalahamule Isakale idoꞌ Zakobole engiꞌ Oꞌmosoꞌine nouve lineꞌ. Idoꞌ aꞌmine ve hili osuꞌ ladiniko engiꞌ Oꞌmosoꞌine nouve ngelo ma lamidine. Engiꞌ Oꞌmosoꞌine nouve lineꞌ neꞌmo mo hili osuꞌ lami ha nizave lo gelelesune. ");
INSERT INTO aso_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Idoꞌ nanitekumuꞌ ve. Oꞌmosoꞌmo gelavo eveneꞌ mukiꞌ nene mo hili osuꞌ lami ha nizaniꞌ nenako nemuꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Neꞌmine lavo eveneꞌ monoꞌ apizi ngimaaꞌ ave linge malite Izesuꞌ gamaziꞌveloꞌ nene tiꞌ li li-imaniꞌ: Tisazo, gaza mo laminetoꞌ goloso laane laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Izesuꞌ neꞌmine lo lo-ngimineꞌ nemuꞌ nene ingine longoꞌ gohi i-dilisa voꞌine vavo alamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Neꞌmine igi nizavo Izesuꞌ aza tiꞌ lo longoꞌ o-ngedo lo-ngimineꞌ: Do luꞌ izelive lo Oꞌmosoꞌmo imiselelesa live nene gozopoꞌ guvelesi ve naba Davidiꞌ aꞌvopilemoꞌ ve laaꞌ naniꞌ nene nanimuꞌ laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Asiꞌve Davidiꞌ monoꞌ nama linguꞌ aꞌmine veꞌmi monovo lineꞌ nene monoꞌ godolouꞌ tiꞌ lo gize neineꞌ ma neive: Okulumokuꞌ ve aza Guveꞌnesi vemuꞌ tiꞌ lo lo-imineꞌ: Nezelotiꞌ geiꞌ nene nange. Aꞌne hulaaꞌ uvoda minezo. ");
INSERT INTO aso_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nanivo biluvaka nene gizengala doꞌmo leme-ngedekuvo gizenga lisaaꞌ ilineꞌ initeꞌ neꞌmine liliꞌ igi gelekeleꞌ i-gidi minilisave. ");
INSERT INTO aso_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aꞌmine ve nemuꞌ nene Davidiꞌ aza Guveꞌnesi ve ve lineꞌ nenako nemuꞌ aꞌmine do luꞌ izelive lo Oꞌmosoꞌmo imiselelesa live nene Davidiꞌ aꞌvopilemoꞌ lemo minive minelidoꞌ nomive. ");
INSERT INTO aso_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Izesuꞌ aza neꞌmine lo lo-ngemavo eveneꞌ mukiꞌ nete nigilavo izipahala zuho tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Monoꞌ apizi lingimaaꞌ aveti monovo nene dikelizaze. Eheꞌ igi golise gili minilo. Ingine nene lavolavo haꞌna haꞌna liki monaakumukovoꞌ ngumo helaaꞌ neivo idoꞌ maketiloꞌ nimonavo evenelite ningi ngopoꞌni li-ngidilizangumukovoꞌ ngumo helaaꞌ neivo idoꞌ monoꞌ numungukisi idoꞌ nosoꞌ niteꞌ naba nadaasi ingine nene ve nabalitevoꞌ minaaꞌ aniꞌ holomoloꞌ minaakumukovoꞌ nene ngumo helaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Idoꞌ veneꞌ gonoꞌ neti initeꞌ mataꞌine di osuꞌ li-ngidaaꞌ idoꞌ Oꞌmosola opoꞌni languꞌ nene evenelite ma ningilizahe li apa niteꞌ igi gamazi haꞌna haꞌna laaꞌ nave. Gamene nabauꞌ aꞌmine ve nene Oꞌmosoꞌmo lihime naba goloso ngemeleseive. ");
INSERT INTO aso_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Heneni nganeni aleve nete monoꞌ numuno nabauꞌ ofa moni milaaꞌ aniꞌ initekuꞌ nene Oꞌmoso initeꞌ lehizi-dikaꞌ lehizi-dikaꞌ navo Izesuꞌ aza vokeneꞌ ogo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ninge minineꞌ nene gevonoꞌ gohoꞌ veneꞌ maliꞌmo guleheꞌ moni sitaꞌ nomolavo ningo ");
INSERT INTO aso_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","eveneꞌ nene tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ nolo-lingimuve. Gohoꞌ veneꞌ gevonoꞌ minineꞌ meꞌmo moni hulineꞌ neꞌmo eveneꞌ mukiꞌ hulaniꞌ nene ngivileꞌ ogosa hulave. ");
INSERT INTO aso_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Neꞌmino ngivileꞌ ogo hulave luvoniꞌ nene eveneꞌ mukiꞌ ingine moniꞌine vaiꞌ lo miningutiꞌ hulaniꞌza aza nene nosoꞌ niteꞌve do sotoꞌ ilineꞌ initeꞌ gohi ma minamivo initeꞌ mataꞌ gohoꞌ neingutiꞌ nene hulave lo lo-ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Izipahala zuho linge ingine monoꞌ numuno naba ningi geheni laminedunuꞌ luhuvo lahava izi gizaniꞌ nemuꞌ nene siza nilavo Izesuꞌ tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Lingine aꞌmine monoꞌ numuno lamineꞌ nininganiꞌ mene alingeꞌ bili ngululubizikevo aꞌmingutiꞌ geheni setakisi bizi minamilisi gamene ma aloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Neꞌmine lavo eveneꞌ ingine tiꞌ li longoꞌ i-daniꞌ: Tisazo, idise aꞌmine nolaineꞌ initeꞌ nene naniheꞌ sotoꞌ ogo neꞌmine ilive. Idoꞌ aꞌmine laineꞌ initeꞌ nene sotoꞌ ogo vo gihile izelesa neivo nene naniteꞌ naniteꞌ sotoꞌ ivo ningelone. ");
INSERT INTO aso_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Eveneꞌ mukiꞌ nete nene igi neniꞌ guliveꞌne li aꞌmine Oꞌmosoꞌmo do lunguꞌ izelive lo nimiselelesa live ma nene naꞌmo nouve idoꞌ Oꞌmosoꞌmo molaniꞌ gamene ma nene mo ogave li lilisaze. Nete di gopo i-lingidikelizaze. nGeꞌmeti vami eheꞌ igi ningisa minilo. ");
INSERT INTO aso_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Idoꞌ lovo sotoꞌ neive lilizahe idoꞌ ngamanimuꞌ lovo nihizave lilizahe nemuꞌ gili ma golise gilami minilo. Neꞌmine initeꞌ nene ha sotoꞌ oloseineꞌza neꞌmine initeꞌ sotoꞌ oꞌmo vilineꞌ neꞌmo nene gamene naba olihe do alitamoloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Neꞌmine lo gohi tiꞌ lo lo-ngimineꞌ: Idoꞌ misubo mauꞌ ve nene misubo mauꞌ vesi lovo hizilisave. Idoꞌ guvelesi ve naba maliꞌmi zuhote guvelesi ve naba maliꞌmi zuhosi lovo hizilisave. ");
INSERT INTO aso_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Idoꞌ misubo ato atota nene mimiꞌ nabasi idoꞌ gaꞌna naba helaaꞌ gamenesi sotoꞌ okaꞌ okaꞌ neivo aꞌmidasi nene siki niteꞌ naba hutileꞌ okaꞌ okaꞌ oꞌmo vo mineleseive. Neꞌmine neivo okulumotoꞌ nene vodine vo lengehelele izelineꞌ initeꞌ mukiꞌ sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Neꞌmine oloseineꞌza aꞌmine initeꞌ mukiꞌ nene olihe sotoꞌ amivo eveneꞌ nete adidoꞌ di goboni mili-lingidi monoꞌ numungukisi galapuso numungukisi lengeleꞌmizi di vi goniꞌ i-lingidaaꞌ idoꞌ guveꞌinesi ve nabaliti veꞌnidoꞌ idoꞌ ngamani nabaliti veꞌnidoꞌ lengeleꞌmizi milaaꞌ ilizaniꞌ nene neniꞌ guliveꞌne lengita minavo di minangumuꞌ nene neꞌmine manaꞌmine i-lingidilisave. ");
INSERT INTO aso_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Neꞌmine i-lingidilizaniꞌ neꞌmo nene engiꞌ veꞌnidoꞌ neniꞌ monovoꞌne nene li sotoꞌ igi li-ngimilisave. ");
INSERT INTO aso_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Aꞌmine gameneuꞌ nene neniꞌ nene vetine do lapa nomineꞌ o-lengedo gamazi gili vevesi mini lilizaniꞌ gamazi nene lengemekuvo engiꞌ gamazi lilizaniꞌ nene belavo aꞌmine biluvatine mukiꞌ nete lengiꞌ gamazi nene bililisa ilizaha mo bilamilisave. Nemuꞌ nene lingine tiꞌ li gili nge likisa minilo. Olihe gonitoꞌ leleꞌmizi mili-lidilisa navo ma gomuꞌ nene nadive lolone lo gopo gate gelamolone li gili nge likisavoꞌ nene minilo. ");
INSERT INTO aso_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Idoꞌ izetinge metinge nilizahe uvotinge nilizahe lengiꞌ zuho nilizahe idoꞌ zogo vetine nilizahe netesi nene adidoꞌ di goniꞌ i-lingidikevo lengikutiꞌ linge nene lingibili hililisave. ");
INSERT INTO aso_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ee, neniꞌ guliveꞌne di minilizangumuꞌ eveneꞌ mukiꞌ nete lengikumuꞌ nene muso gaꞌine goloso dizeleseive. ");
INSERT INTO aso_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ne neiha neꞌmine i-lingidilizanguꞌ nene lengiꞌ godotingutiꞌ madudine zopovo hamoꞌ nesi nene ngelo vo tolovo amoloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Neꞌmine manaꞌmine i-lingidi nizavo lingine gili huli mudise nenita giꞌmizi minilizaniꞌ nelotiꞌ nene minevoꞌ minevoꞌ ogaꞌ lengemeni dameni dalisave. ");
INSERT INTO aso_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Idoꞌ Zelusalemi numuno ebeꞌ nene lovo vete igi di goloso ilisa mine vodo vodo igi gesi neꞌmini nihizavo ma nene lingine tiꞌ li gililo: Eii, numuno ebeꞌ mukiꞌ niteꞌ mene mo di goloso gehepeve ilizaniꞌ gamene nene mo alitave li gililo. ");
INSERT INTO aso_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Neꞌmine navo ma nene aꞌmine Zelusalemi ebekuꞌ nilizavesi idoꞌ aꞌmine ebeꞌ minineꞌ misubo Zudaia misubo neukisi nilizave nene gololavoꞌ nivilizave. Idoꞌ Zelusalemi ebeꞌ gahevela minaniꞌ aleve nene igi aꞌmine Zelusalemi numuno ebekuꞌ nene dizamilizave. ");
INSERT INTO aso_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Idoꞌ neꞌmine noluvoniꞌ nene nemuꞌ noluve: Aꞌmine gamene sotoꞌ ilineꞌ nene aꞌminemuꞌ monoꞌ godolouꞌ gizikaniꞌ gamazi mukiꞌ ma nene do gihile izelove losa Oꞌmosoꞌmo monovo goloso di sotoꞌ igaꞌ angumuꞌ lihime ngemelineꞌ gamene mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Agae, aꞌmine gameneuꞌ nene izipahaꞌine minineꞌ venekumukisi idoꞌ izipe amidoꞌ nizavo nizaniꞌ venekumukisi nene mo mulumo gele-ngedekuve. Geꞌnebe goloso ilisave. Aꞌmine gameneloꞌ nene me misubouko nene initeꞌ goloso gehepeve sotoꞌ ogavo Oꞌmosoꞌmi izeboloꞌve neꞌmo me misubouꞌ aleve nene do dingani hizo hite-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Idoꞌ eveneꞌ linge nene bainati mitedunuꞌ ngibili hililisave. Idoꞌ linge ma nene galapuso ngimi numudoꞌ namadoꞌ ebeꞌ mukikuꞌ ngeleꞌmizi di vilisave. Neꞌmine igi Zuda ve minamaniꞌ aleve heta atoꞌ ve nete igi Zelusalemi aleve nene di hupiꞌ izi-ngidi ngibili gizisa aꞌmine ebeꞌ nene di tiꞌ igi mini di dizi nizavo Oꞌmosoꞌmo molo-ngidineꞌ gameneloꞌ nene osuꞌ loloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Hoꞌ, ikeꞌni, sonohiꞌ engikuꞌ nene ato atoꞌ suno sotoꞌ noo-ngidivo guvo noso neꞌmo izo pouꞌ paaꞌ lo nolo nolo nomolavo nemuꞌ eveneꞌ zuho ato atoꞌ ingine aꞌmine nene nigili voꞌine vo muluꞌine pouꞌ loloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Idoꞌ Okulumotoꞌ amuzoꞌinesi minaniꞌ initeꞌ mukiꞌ nene moꞌmongoꞌ igi gabeꞌ i geseꞌ ilisanako neꞌmine ilineꞌ nemuꞌ eveneꞌ nete me misubouꞌ nene initeꞌ atoꞌ ma sotoꞌ olosa neiko naniteꞌ sotoꞌ ilivoo li gopo gaꞌine gili muluꞌningutiꞌ gohi dizo gohi dizo ivo minilisave. ");
INSERT INTO aso_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Neꞌmine navo Oꞌmosolatiꞌ ve gihile naza nene amuzoꞌnesi idoꞌ labanaꞌne nabasi do sotoꞌ ogo limuso avileloꞌ nolimuvo ningilisave. ");
INSERT INTO aso_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nemuꞌ nene alingeꞌ aꞌmine initeꞌ sotoꞌ olosa apiꞌ neivo ma nene lingine Oꞌmosoꞌmo mudise do luꞌ izelineꞌ gamene nene mo avitoꞌ ogave lisa lutine di upuhoꞌ i-di lutine otavo minilo. ");
INSERT INTO aso_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Idoꞌ Izesuꞌ aza neꞌmine lo aneza gamazi ma tiꞌ lo lo-ngimineꞌ: Lingine lengiꞌ Zuda veti misubotinguꞌ mene gohuno zaloꞌ nesi idoꞌ za mukitoꞌ nesi nene ma ningi giliꞌnalo. ");
INSERT INTO aso_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Avile gosohoꞌ sotoꞌ olosa apiꞌ ogo gulumo liselesa neivo ma lingine nene hoꞌ lilineꞌ gamene mo avitoꞌ ogave li langisetine ningi gilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Idoꞌ aꞌmineꞌmine ogo aꞌmine veleta gomuꞌ luvoniꞌ initeꞌ mukiꞌ nene sotoꞌ oꞌmo novivo ma lingine nene Oꞌmosoꞌmo evenetoꞌ gizebo ilineꞌ gamene nene mo alitave li gililo. ");
INSERT INTO aso_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Naza mo laminetoꞌ nolo-lingimuve. Aꞌmine initeꞌ mukiꞌ sotoꞌ oꞌmo vilineꞌ nene idise nizaniꞌ aleve nesi nene olihe hili osuꞌ lamavosi sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Idoꞌ Okulumoki misubogi nene ha vi osuꞌ lilisasineꞌza aꞌmine gamaziꞌne nene mo osuꞌ lamo eleꞌvoleꞌ ogo mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nemuꞌ nene lingine negi hizi gopo minaaꞌ idoꞌ noso vauve ili ni sipaki igi minaaꞌ idoꞌ me misubouꞌ miniviꞌ aliviꞌ ilizangumuꞌ nesi giliivoꞌ minaaꞌ ilizaniꞌ nene gaha nete gelevuso neive li gilamadoꞌ liteꞌ lo ngebelaaꞌ neineꞌ neꞌmino gamene naba nene sotoꞌ o-lengedavo upuhoꞌ goloso ikelizaze. Monovotidoꞌ gizebo lamineꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aꞌmine gamene nene eveneꞌ mukiꞌ misubo mukikuꞌ miniꞌmi monada nesi nene sotoꞌ o-ngedelineꞌ nenako nemuꞌ noluve. ");
INSERT INTO aso_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nemuꞌ nene lingine lutine ongamivo mini Oꞌmosoꞌmo hize eleꞌ o-ledavo aꞌmine sotoꞌ ilineꞌ initeꞌ nene sotoꞌ oꞌmo novo aꞌmineꞌmo do gopo o-ledamivo mino Oꞌmosolatiꞌ ve gihile alineꞌ nene veleloꞌ ha ote mineloningumuꞌ ve li Oꞌmosola gamene gamene liivoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Izesuꞌ aza gamene gamene goꞌ laneme goꞌ lanemeꞌ monoꞌ numuno nabauꞌ nene eveneꞌ monoꞌ apize ngemo minaaꞌ ineꞌ ve. Idoꞌ holukaꞌ holukaꞌ nene golo ma gulive Oliva nela ongalosa dizo vaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Idoꞌ nedengaꞌ holukatiꞌ aza ogo monoꞌ numuno nabauꞌ dize neivo eveneꞌ mukiꞌ ingine geti igi aꞌmine neida nene gamaziꞌve gililisa di nubo igaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Idoꞌ lulu izamineꞌ beleti naaꞌ aniꞌ holiseꞌ Oꞌmosoꞌmo Zuda veti avoꞌningine iseꞌine izingumuꞌ gili minaaꞌ holiseꞌ ve laniꞌ nene alitineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Noalitivo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ monoꞌ apizi ngimaaꞌ avesi ingine nene Izesuꞌni bililisa gilaniꞌza evenelite ningi lovo di sotoꞌ ilizahe li golise gili ingine evenelite aꞌminemuꞌ ningi lamavo zegeni bili hililizaniꞌ akamuꞌ viseꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Neꞌmine igi nizavo Izesuꞌ izipahala zuho tuvelu engikutiꞌ Kelioto ve ve lave Zudaꞌ eiꞌ lulouꞌ nene Satani neꞌmo lemo mino do ote-davo ");
INSERT INTO aso_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","aza nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ monoꞌ numuno nabauꞌ gizebo igaꞌ aniꞌ pilisi veti gizebo vesi nizada vo hetelavo Izesuꞌni bililizangumuꞌ Izesuꞌni do sotoꞌ ogo aꞌninguꞌ molalineꞌ akamuꞌ viseꞌ igi engikisi gamazi lo gele ha gele aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Neꞌmine ogavo nemuꞌ ingine laniteꞌ gili moni ma emelone li li hukaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Neꞌmine li li hukikevo aza lamineꞌ ve losa Izesuꞌ aza eveneꞌ vaikisi minami eikovoꞌ nolidoꞌ ngelebizekuvo dalizave lo amamakaꞌ moloꞌmo vo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nelotiꞌ nene Zuda ve lulu izamineꞌ beleti naaꞌ aniꞌ gamene Oꞌmosoꞌmo avoꞌningine iseꞌine izingumuꞌ gili sipisipi angale bilaaꞌ aniꞌ gamene nene ogavo ");
INSERT INTO aso_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","nemuꞌ Oꞌmosoꞌmo avotemotine iseꞌine izingumuꞌ gelo mino naaꞌ nosoꞌ niteꞌ naloningumuꞌ nene lingine vi di vaꞌvaꞌ ilizo lo Izesuꞌ aza Petolongi Zohanengi ngimiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","nGimiselavo ingine tiꞌ li li-imasineꞌ: Gaza nene zaala vo do vaꞌvaꞌ olosingumuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Neꞌmine likesivo aza tiꞌ lo lo-ngimineꞌ: Olopehe, numuno ebeta nene dizi vi nihetelasivo ve maliꞌmo misubo somouꞌ noso ohizo geho navo voteneꞌ ilisaze. Lingine eꞌmeti vilizo. Ve aza numuno mauꞌ dizo novivo ma aꞌminguꞌ eꞌmeti vi ");
INSERT INTO aso_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","numuno neꞌmi melehine nene tiꞌ li li-imilizo: Tisate maꞌmo tiꞌ lo lo-gedave: Nazasi izipahaꞌnesi Oꞌmosoꞌmo avotemotine iseꞌine izingumuꞌ gelo naaꞌ nouneꞌ nosoꞌ niteꞌ naloneꞌ numuno lulo nene zauꞌ nalone. ");
INSERT INTO aso_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Likesivo numuno meleho aza numuno veletoꞌ mino galaꞌmudoꞌ mino ingutiꞌ veletoꞌ nene lulo nabasi mininguꞌ initeꞌ mataꞌ aviliseꞌ i nizaniꞌ nene lengelebizeleseive. Aꞌminguꞌ nene nosoꞌ nitete di vaꞌvaꞌ ilizo. ");
INSERT INTO aso_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tiꞌ lo lo-ngemavo ingine aꞌmida vi heteli ningasineꞌ nene lo-ngimineꞌ maꞌmino neivo aꞌminguꞌ nene Oꞌmosoꞌmo iseꞌine izingumuꞌ gili naaꞌ aniꞌ nosoꞌ niteꞌ nene di vaꞌvaꞌ asineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mo di vaꞌvaꞌ ikesivo nosoꞌ niteꞌ nalizaniꞌ gamene nene ogavo aposoloꞌve zuhosi mini nosoꞌ niteꞌ ni minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Neꞌmine igi minanguꞌ nene Izesuꞌ tiꞌ lo lo-ngimineꞌ: Mulumo alumo niteꞌ gihi-nidilizaniꞌ gamene alitelesa olihe alitamivo holiseꞌ mino naaꞌ nosoꞌ niteꞌ mene lengikisi makatoꞌ mino nalone lo muluꞌneuꞌ huhu lo mulumo goloso ivosa gele minuvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nene nanitekumuꞌ ve. Naza lo-lengemelove. Oꞌmosoꞌmo iseꞌine izineꞌ nosoꞌ niteꞌ meꞌmine nene gohi ma namuvo aꞌmine nosoꞌ niteꞌ avazahaloꞌ minineꞌ initeꞌ gihile nene sotoꞌ ogosa Oꞌmosoꞌmi gizeboꞌve sotoꞌ ogavo nalosuve. ");
INSERT INTO aso_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Neꞌmine lo noso minineꞌ gomise ma do Oꞌmosola opoꞌni lo tiꞌ lo lineꞌ: Lingine mene di izeꞌ mili nalo. ");
INSERT INTO aso_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nemuꞌ naza tiꞌ lo nolo-lingimuve. Naza nene idise mene vaini noso nonunidotiꞌ nene gohi ma namo nouvo Oꞌmosoꞌmo eveneleloꞌ gizebo ilineꞌ gamene sotoꞌ ilinguꞌ nene gohi nalosuve. ");
INSERT INTO aso_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Neꞌmine lo beleti ma do Oꞌmosola opoꞌni lo gito apilo nongemo tiꞌ lo lo-ngimineꞌ: Mene neniꞌ meꞌmeleꞌne lengikumuꞌ ve losa nenaze. Nenikumuꞌ gili mini nikaꞌ nikaꞌ iꞌmi vi minilo. ");
INSERT INTO aso_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nosoꞌ niteꞌ nene mo nisa nelotiꞌ alingeꞌ nene aꞌmineꞌmine ogo vaini noso minineꞌ gomise do tiꞌ lo lineꞌ: Vaini noso gomiseuꞌ neineꞌ mene neniꞌ vaniseꞌne lengikumuꞌ hulokuvo Oꞌmosoꞌmo lo huko-lingidineꞌ gamazi gosohoꞌ ma nene do eleꞌvoleꞌ ilineꞌ vanise ma nene neive. ");
INSERT INTO aso_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Neꞌmine o neineꞌza lingine gililo. Biluvaliti aꞌninguꞌ neniꞌ molo-nedelive nene idise tevoliloꞌ mene makaꞌ mino nosoꞌ niteꞌ ade hulo do no nosive. ");
INSERT INTO aso_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ee, Oꞌmosolatiꞌ ve gihile nenikumuꞌ nene Oꞌmosoꞌmo mo neꞌmine olosane lo gele minidoꞌ do molo mo heleloniꞌ akaloꞌ novuvoniꞌza biluvalite neniꞌ dalizave lo do sotoꞌ o-nedelive nene agae, mo mulumo gono goloso daloseive. ");
INSERT INTO aso_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Neꞌmine lo lavo izipahala zuho ingine neve lelikutiꞌ neꞌmine zaho ilivoo lii engiꞌ okoꞌninguꞌ nene viseka li minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aꞌmine izipahala zuho engiꞌ muliseuꞌ nene lovo lolize sotoꞌ ineꞌ. Ingine nene engikutiꞌ maliꞌmo linge ma ngivileꞌ ogo dizo minive ve li gililizadoꞌ lisiheꞌ o minive nene zaho nolive li lolize hizi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Neꞌmine igi nizavo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmi zuho minamaniꞌ heta atoꞌ ve engiꞌ guveꞌinesi veꞌine naba nete nene amuzo goloso mili di gelekeleꞌ ve liliꞌ i-ngidaaꞌ nave. Idoꞌ neꞌmine igi mini engitoꞌ gizebo i-ngidiliza amuzo di minave ingine nene lelikumuꞌ di lamineꞌ i-lidaaꞌ ave ve li-lidilizadoꞌ lisiheꞌ o none laaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Neꞌmine igi minaaꞌ naniꞌza lengita neꞌminosa minamilineꞌ o neive. Asi lengikutiꞌ ma dizo minelive nene eveneꞌ limi minaaꞌ nave neꞌminosa lemo mineleseive. Idoꞌ lengiꞌ gizebo ve nete nene hize eleꞌ igaꞌ ave gelekeleꞌ izipe neꞌmine liliꞌ igi minilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nemuꞌ nene lingine ma liꞌnalo. Ve maliꞌmo nosoꞌ niteꞌ nokaꞌ nokaꞌ neivo maliꞌmo gelekeleꞌ o-do nosoꞌ niteꞌ do emekaꞌ emekaꞌ neivo minilisingutiꞌ guvelesi ve dizo minive nene zaho nolive. Nosoꞌ niteꞌ nokaꞌ nokaꞌ ogo minive nene noloseive. Olo. Ne neiha naza lengikuꞌ nouvoniꞌ nene gelekeleꞌ izipe neꞌmine loloꞌ ogo nouve. ");
INSERT INTO aso_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Idoꞌ naza mulumo gono geho minuvonguꞌ nene olovoꞌ ami nenikisi makaꞌ gihi minaaꞌ ave ma nene nizave. ");
INSERT INTO aso_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nemuꞌ nene nenikumuꞌ nene meꞌneho neniꞌ eveneꞌneloꞌ gizebo olosane lo do kegese-nedo neleꞌmize molo neineꞌ neꞌmino linginesi nene lengeleꞌmize molokuvo ");
INSERT INTO aso_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","neniꞌ eveneꞌneloꞌ gizebo o minelonguꞌ lingine holomoꞌneloꞌ nosoꞌ niteꞌ niꞌmi vi mini guveꞌinesi ve minaaꞌ aniꞌ moꞌmosiꞌ tuvelu (12) nene lengemekuvo mini Isilaeleꞌ aleveti mulise tuvelu nene gizebo i-ngidi minilisave. ");
INSERT INTO aso_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Neꞌmine lo Izesuꞌ tiꞌ lo lineꞌ: Agae Simonizo, gaza gelezo. Nosoꞌ niteꞌ losuvo ili mili atoꞌ igaꞌ naniꞌ neꞌmino Satani neꞌmo lengiꞌ nene lengemenguꞌ molo do gizekaꞌ o-lengedelesa lavo Oꞌmoso aza gele imineꞌza ");
INSERT INTO aso_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","geiꞌ nenikumuꞌ gele eleꞌvoleꞌ aineꞌ nene mudise hulamiline lo neniꞌ nene geikumuꞌ gelo Oꞌmosola lokuve. Nemuꞌ nene gaza gohi tineꞌ molo ogo nenita giꞌmizosa geze zuho nene hize eleꞌ o-ngedezo. ");
INSERT INTO aso_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Neꞌmine lo lo-emavo Petoloꞌ aza tiꞌ lo lo-imineꞌ: Guvekasi ve, neꞌmino nomive. Gaza nene galapuso numunguꞌ vilibe idoꞌ gibilikevo helaaꞌ akalokisi vilibe neꞌmine ilineꞌ nene nazasi makaꞌ aꞌminguꞌ ha volosusive. ");
INSERT INTO aso_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Petoloo, naza tiꞌ lo nolo-gimuze. Gelezo. Idise holukaꞌ nene okoloho nolo olihe molamivo gaza nenikumuꞌ nene ma ningamu ve ve lo ataize nolanivo gamene sitohamo oloseive. ");
INSERT INTO aso_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Gomuꞌ monoꞌ gonouꞌ nolingimiselo moni goꞌzaaꞌ pausi nehe idoꞌ hanibeki goꞌ nehe idoꞌ gizedidoꞌ suuꞌ nehe neꞌmine initekisi ma di vami haza vilo lo lingimiselekuvo vaniꞌ mauꞌ nene initeꞌ mamuꞌ viseꞌ igi minaniꞌ nehe. Neꞌmine lavo izipahala zuho ingine ma viseꞌ amuneꞌ ve laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Gomuꞌ nene eveneꞌ zogo nimili-lidavosa neꞌmine aniꞌza idise hize eleꞌ i-lingidami lovo i-lingimilizaniꞌ nenako nemuꞌ idise nene moni goꞌzaaꞌ pausi nehe idoꞌ hanibeki goꞌ nehe ma molo nolive neꞌmo nene ha do vilive. Idoꞌ bainati miteꞌ ma molamo nolive nene okoꞌnoloꞌ izaaꞌ ineꞌ initeꞌ saketi nene salimi ogo moni do bainati miteꞌ nene meni hizelive. ");
INSERT INTO aso_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Naza neꞌmine lo nolo-lingimuvoniꞌ nene monoꞌ godolouꞌ nenikumuꞌ gomuꞌ gizi nizaniꞌ gamazi vaiꞌ ma nene gihile izelidokovoꞌ neineꞌ nenako aꞌminguꞌ nenikumuꞌ tiꞌ li gizi nizaniꞌ gamazi nene mo aꞌnene gihile ize leive losa noluve: Adoꞌ eveneꞌ nete ezemuꞌ nene louꞌ gamazi avutoꞌ igi monovo goloso daaꞌ aveti muliseutiꞌ minive ve li li-dilisave. ");
INSERT INTO aso_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Neꞌmine lavo ingine tiꞌ li laniꞌ: Guvekasi ve, gaza ningezo. Bainati miteꞌ sitaꞌ mene ma neive. Neꞌmine li likevo Izesuꞌ aza moda aꞌnevo neive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Neꞌmine lo numungutiꞌ heta lemo vo Oliva golola gomuꞌ vaaꞌ ineꞌ maꞌmine ogo dizo novivo izipahala zuho nene eꞌmeti vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Neꞌmine ogo mo aꞌmine ebeta dizo voo izipahala zuho tiꞌ lo lo-ngimineꞌ: Lingine lengemenguꞌ sotoꞌ o-lengedelinguꞌ nene limi ingikelizaze. Oꞌmosola li minilo. ");
INSERT INTO aso_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Neꞌmine lo izipahala zuho nene hulo-ngedo ngomo ma vo hotoꞌile ogo lemo obuvolo hizo Oꞌmosola tiꞌ lo lineꞌ: ");
INSERT INTO aso_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Meꞌneho make, mulumo alumo ekeseꞌ nenita sotoꞌ olosa naniꞌ nene gaza geiꞌ lukaloꞌ neivo ma do olovoꞌ o-nedeline losa noluvoniꞌza geiꞌ lukauꞌ nene atoꞌ neivo ma neniꞌ luꞌneloꞌ do molamo geiꞌ lukalokovoꞌ do molo eꞌmeto iline losa noluve.  ");
INSERT INTO aso_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Neꞌmine lo nolivo Okulumokutiꞌ angeloꞌ maliꞌmo lemo sotoꞌ o emo hize eleꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Neꞌmine ogavo mulunouꞌ mulumo naba goloso gelo mino Oꞌmosola nene amuzo gohi ma molo nolivo gohise belavo gohise hilineꞌ nene vanise neꞌmine misubouko doꞌmozeꞌ mozeꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Neꞌmino neivo Oꞌmosola lo minidotiꞌ nene oto izipahala zuho minaniꞌ mala vineꞌ. Vo ningineꞌ nene ingine muluꞌninguꞌ mulumo naba gili minadiꞌmo ngabusoꞌine elavo okise ingi nizavo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ningo tiꞌ lo lo-ngimineꞌ: Lingine nene nanimuꞌ okise ingi nizave. Lingine nene lengemenguꞌ ma sotoꞌ ilineꞌ nene vi gopo ikelizaze. Oti Oꞌmosola li minilevo. ");
INSERT INTO aso_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Neꞌmine ogo Izesuꞌ nene gamazi nolivo eveneꞌ mukiꞌ aꞌmida aniꞌ nene ve ma Izesuꞌ izipahala zuho tuvelu engikutiꞌ minive Zudaꞌ nene do gomuꞌ molavo aꞌmida igisa Izesuꞌni nene golo elo nalosa Zudaꞌ nene Izesuꞌ neida aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aniꞌza Izesuꞌ aza tiꞌ lo lo-imineꞌ: Zudazo, gaza neniꞌ zogone minaineꞌ gelo soza suno do Oꞌmosolatiꞌ ve gihile neniꞌ nene goꞌne elo nosa lovo veti aꞌninguꞌ molo-nedelesa ogane. ");
INSERT INTO aso_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Neꞌmine lo lavo aꞌmine Izesuꞌ neida makaꞌ minave nete eveneꞌ aniꞌ nene mo Izesuꞌni dalisa nave li mo ningi gilii tiꞌ li laniꞌ: Guvetesi ve, Bainati mitedunuꞌ nene ha ngebelelobe. ");
INSERT INTO aso_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Neꞌmine li nilavo hamoliꞌmo oteko evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nabaliꞌmi gelekeleꞌ izipe ma belo gala zamela hasaꞌ o hulineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Neꞌmine ineꞌza Izesuꞌ aza tiꞌ lo lineꞌ: Neꞌmine monovo nene modaze. Gohi amilo. Neꞌmine lo galaloꞌ nene nodo gelo gala nene do lamineꞌ o-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Do lamineꞌ o-do eze analoꞌ dalisa ave evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ monoꞌ numuno nabauꞌ gizebo igaꞌ aniꞌ pilisi veti gizebo ve nabasi idoꞌ monoꞌ gizebo vesi nene tiꞌ lo lo-ngimineꞌ: Gizengize ve dalisa igaꞌ adiꞌmine igi bainati miteꞌ di gavososi di nahe. ");
INSERT INTO aso_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gamene gamene monoꞌ numuno nabauꞌ linginesi makaꞌ minaaꞌ uneꞌ ma nene lingine neniꞌ okoꞌneloꞌ adine huli ma di gonitoꞌ i-nidisaꞌmaniꞌ ma ve. Neꞌmine isaꞌmaniꞌ ma neineꞌza ee, mo hoꞌ dize dize laaꞌ initeꞌ ma nenako idise nene litiꞌmusoꞌmi meleho Satani neꞌmi amuzo sotoꞌ o neinguꞌ nene mo lengiꞌ hotine nodizize. Lengitokovoꞌ neive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Neꞌmine lavo nelotiꞌ nene Izesuꞌni analoꞌ disa evenetoꞌ medelo mino Oꞌmoso initeꞌ lehize-daaꞌ ive nabaꞌmi numunguko eleꞌmizi vaniꞌ. Eleꞌmizi nivavo Petoloꞌ aza eꞌmete-do hotoꞌile aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aꞌmine dizi minaniꞌ numuno nene vodo vodo ogo minavo olusoꞌ omoꞌ naba minidoꞌ nene eveneꞌ ingine igi oloꞌ gizi lahizi nizavo Petoloꞌ azasi nene ogo vovoꞌninguꞌ mitoꞌ makaꞌ minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aza nene oloꞌ labanatoꞌ neivo gelekeleꞌ alu maliꞌmo ningo vonuꞌ nobelo tiꞌ lo lineꞌ: Ve meesi nene Izesukisi makaꞌ minasive ma ne neive. ");
INSERT INTO aso_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Neꞌmine lavo Petoloꞌ aza ataize tiꞌ lo lineꞌ: Veneꞌ gaza nene neze ma ningo gelamu vemuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Neꞌmine loosa ngomo ma nominivo ve maliꞌmo Petoloꞌni ningo tiꞌ lo lineꞌ: Gazasi nene engiꞌ zuho ma nene nane. Neꞌmine lo lineꞌza Petoloꞌ tiꞌ lo lineꞌ: Ve melo, naza nene engiꞌ zuho minamuve. ");
INSERT INTO aso_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Neꞌmine lavo gohi ngomo ma aua hamoꞌ neꞌmine nomino ve gohi maliꞌmo amuzonga goloso lo tiꞌ lo lineꞌ: Aza nene nGalilaia nolosi ve neiko azasi nene mo makatoꞌ Izesukisi minasive ne neive. ");
INSERT INTO aso_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Neꞌmine lo lavo Petoloꞌ tiꞌ lo lineꞌ: Ve melo, gaza nolaineꞌ gamazi nene ma gelamuvoniꞌ gamazi nolane. Neꞌmine lo nolivo aꞌmidoꞌ liteꞌ lo okoloho nolo molaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Okoloho nolo molavo Guvelesi ve aza mine velepeꞌ izo Petoloꞌni vonuꞌ bilineꞌ. Vonuꞌ nobilivo Petoloꞌ aza Guvelesi veꞌmo gomuꞌ minada idise okoloho olihe nolo molamivo gamene sitohamo nenikumuꞌ nene ningamu ve ve lo ataize lo-nedelesane lo gomuꞌ lineꞌ gamazi nene gohi gelo ");
INSERT INTO aso_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","heta lemo vo ive nabaloꞌ goloso ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Neꞌmine ogavo nelotiꞌ nene Izesuꞌ analoꞌ di minave nete nene golo izi goboni mili-di bili minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Idoꞌ veleloꞌ nene lavolavodunuꞌ liki hiti-mikisasi tiꞌ li longoꞌ i-di laniꞌ: Nogibilive nene zaho nolihe. Gaza nene polohetelite laaꞌ adiꞌmine ogo lo sotoꞌ ogo lo-lemevo. ");
INSERT INTO aso_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Neꞌmine li-dii divi ledivika li-di gamazi goloso palasa vaiꞌ goloso li-di minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Neꞌmine li-di nizavo goꞌ lavo Zuda veti gizebo ve mukiꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ monoꞌ apizi ngimaaꞌ avesi nene kanisole ma minaniꞌ nenako Izesuꞌni nene engiꞌ kanisoleliti numuꞌninguꞌ eleꞌmizi di vi mini tiꞌ li longoꞌ i-daniꞌ: ");
INSERT INTO aso_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Gaza nene Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ma nene nabe. Gaza nemuꞌ lo-lemanivo gelelone. Neꞌmine li laniꞌza aza tiꞌ lo lo-ngimineꞌ: Naza ma lo-lengemeloniꞌ nene mo lamineꞌ laave li ma gili eleꞌvoleꞌ amilisave. ");
INSERT INTO aso_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Idoꞌ lengiꞌ longoꞌ ma o-lengedeloniꞌ nesi nene mo ngeli li-nimamilisave. ");
INSERT INTO aso_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Li-nimamilisaniꞌza alingeꞌ nela Oꞌmosolatiꞌ ve gihile neniꞌ nene Oꞌmoso amuzo velotiꞌ lemo gizebo ve naba mino ana hulaaꞌ ida minelesuve. ");
INSERT INTO aso_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Neꞌmine lavo ingine mukitoꞌ tiꞌ li laniꞌ: Gaza nene mo Oꞌmosoꞌmi gipele nouve nolabe. Olo. Likevo aza tiꞌ lo lo-ngimineꞌ: Langisetine nene mo nilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Neꞌmine lavo ingine tiꞌ li laniꞌ: Izesuꞌ monovo goloso do nolingumuꞌ gili nilizaniꞌ aleve gohi ma atoꞌ nene nanimuꞌ asi lo-ngedosa gamazi gohi gelelone. Asiꞌve veleutiꞌ nene mo Oꞌmoso avutoꞌ ineꞌ gamazi lavo laꞌlise mo gelekune. ");
INSERT INTO aso_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nelotiꞌ nene ingine mukitoꞌ oti eleꞌmizi Pilatoꞌ neida vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pilatoꞌ neida vii apiꞌ igi tiꞌ li goniꞌ i-daniꞌ: Me veꞌmo nene Zuda ve leliꞌ aleve ngeleꞌmizo gopo ogo mino takisi moni nesi nene guvelesi ve Kaesaleꞌni imamilo laaꞌ idoꞌ aza nene Oꞌmosoꞌmo leliꞌ Zuda vemuꞌ nimiselelesa live nouve nolineꞌ nene guvelesi ve naba mamuꞌ nolinako mo guvelesi ve naba nouve losa nolive. ");
INSERT INTO aso_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Neꞌmine likevo Pilatoꞌ aza tiꞌ lo longoꞌ o-dineꞌ: Gaza nene Zuda veti guveꞌinesi ve naba nabe. Olo. Neꞌmine lo longoꞌ o-davo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Mo gasika nene nolaineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Neꞌmine lavo Pilatoꞌ aza nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ eveneꞌ mukiꞌ nesi tiꞌ lo lo-ngimineꞌ: Naza me veꞌmi lihimemuꞌ viseꞌ uvoniꞌza ma ningamuve. ");
INSERT INTO aso_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Neꞌmine lavo ingine amuzo mili tiꞌ li laniꞌ: Eveneꞌ mukiꞌ nGalilaia misuboukotiꞌ ogo Zudaia misubouꞌ ogo mo melokisi omo pilivo nene gaꞌine hizo gamazi apize ngemo lovo do sotoꞌ noo-ngimive. ");
INSERT INTO aso_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Neꞌmine li likevo Pilatoꞌ aza aꞌmine gamazi nene gelo longoꞌ o-ngidineꞌ: Ve me ve nene nGalilaia misuboukotiꞌ ve nehe. ");
INSERT INTO aso_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Neꞌmine lo longoꞌ o-ngedavo ingine oo likevo Pilatoꞌ aza Helodeꞌ gizebo o minineꞌ misuboukotiꞌ ve neineꞌ neivo mo ningo gelo aꞌmine gameneuꞌ Helodeꞌ nesi nene aꞌmine Zelusalemi numuda omo minineꞌ nenako nemuꞌ Pilatoꞌ aza nene Izesuꞌni nene aꞌmine Helodeꞌ neida imiselavo eleꞌmizi vaniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Neꞌmine ikevo Helodeꞌ aza nene Izesuꞌnimuꞌ nene gozopotiꞌ gele mino atoliꞌmine suno ma do sotoꞌ ilineꞌ ningelonako lo gala gelo gamene haꞌna Izesuꞌni ma ninguvoo lo geleꞌmo vo minaaꞌ ineꞌ nenako Helodeꞌ aza Izesuꞌni ningo mulunouꞌ lamineꞌ gilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Laniteꞌ goloso gelo Helodeꞌ aza Izesuꞌ ogo molo oꞌmo monineꞌ initekumuꞌ nene longoꞌ o-dekaꞌ o-dekaꞌ oꞌmo vo minineꞌza Izesuꞌ nene gamazi hamokisi ma bekimi ogo lo-emamineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Neꞌmine ogavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ monoꞌ apizi ngimaaꞌ ave linge masi ingine igi velela oti amuzo goloso mili goniꞌ i-daniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Neꞌmine i-dikevo Helodeꞌ ve eze ami pilisi veꞌve nete divi lediviꞌ i-di golo izi goboni mili-daniꞌ. Neꞌmine niigi guvelesi ve ma nange. Me izevo li okoꞌnoloꞌ initeꞌ lamineꞌ goloso ma di ngili-dikevo Helodeꞌ neꞌmo gohi Pilatoꞌ neida imiselineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Idoꞌ gomuꞌ nene Pilatoki Helodeki ingine biluvaꞌ biluvaꞌ igi minasineꞌza aꞌmine Izesuꞌni goniꞌ i-dasineꞌ gamenelotiꞌ nene zogo milasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Idoꞌ Helodeꞌ aza gohi Pilatoꞌ neida imiselavo Pilatoꞌ aza evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi gizebo vesi idoꞌ eveneꞌ linge ma mukikisi do nubo o-ngedo ");
INSERT INTO aso_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tiꞌ lo lo-ngimineꞌ: Lingine ve mene nenita eleꞌmizi igisa ve mene eveneꞌ gaꞌine hizo lovo do aꞌninguꞌ izaaꞌ neive likevo naza nene lengiꞌ vetidoꞌ mo neꞌmine idoꞌ nilahe lo longoꞌ o-do viseꞌ uvoniꞌ nene lingine giliꞌ nalo. Lingine goniꞌ nii-danguꞌ nene monovo do goloso ineꞌ monovo nene ma ningamoloniꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Idoꞌ naza ve meꞌmo monovo goloso daniꞌ monovoloꞌvemuꞌ viseꞌ ogo ma ningamuvoniꞌ maꞌmine ogo Helodeꞌ ezesi ma ningamosa nene imisele hulave. Aza ma viseꞌ ogo ningidiniko mela imiselavo amidine. Nemuꞌ lingine giliꞌ nalo. Ve me ve nene bele heleloneꞌ votigileloꞌ ogo lihime ma damive. ");
INSERT INTO aso_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Nemuꞌ nene naza ami ma lo-ngedekuvo ngibilaaꞌ aniꞌ gavosodunuꞌ bilavo bilavo imiselekuvo vilive. ");
INSERT INTO aso_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Idoꞌ eveneꞌ mukiꞌ ingine mukitoꞌ gekeꞌ li gamazi tiꞌ li laniꞌ: Ve mene bele helo Balabasiꞌni nene hulo heta o-danivo lelita alive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aꞌmine Balabasiꞌ nene Zelusalemi numuno ebekuꞌ Loma ngamanila lovo do sotoꞌ ogo evenekisi ma bele helavo di huli galapusouꞌ imikavo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Neꞌmino minivemuꞌ nene neꞌmine likevo Pilatoꞌ nene Izesuꞌni haza hulo-dekuvo vilive lo gelo eveneꞌ nene gohi gamazi lo-ngimineꞌza ");
INSERT INTO aso_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","eveneꞌ ingine gama gama gizi tiꞌ li laniꞌ: Lohotoꞌ zaloꞌ belezo, belezo laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Neꞌmine li likevo Pilatoꞌ aza gomuꞌ gamene sitaꞌ lineꞌ nene gilamavo gohi tiꞌ lo lo-ngimineꞌ: Nanitekumuꞌ lohotoꞌ zaloꞌ belelone. Initeꞌ goloso ineꞌ nene naniteꞌ nolive. Monovo goloso davo bele heleloneꞌ monovoꞌve nene ma nolihe lo viseꞌ uvoniꞌza ma ningo do sotoꞌ amuve. Nemuꞌ nene naza ami ma lo-ngedekuvo ngibilaaꞌ aniꞌ gavosodunuꞌ bilavo bilavo imisele hulolove. ");
INSERT INTO aso_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Neꞌmine lo lineꞌza eveneꞌ ingine Pilatoꞌ lineꞌ gamazi nene gilahe gilamahe igi mini Izesuꞌ nene mo lohotoꞌ zaloꞌ helelive li mili hiti hitiꞌ igi gekeꞌ gekeꞌ goloso liviꞌ liviꞌ adiꞌmo Pilatoꞌ gamaziꞌve nene ivileꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Neꞌmine ogavo Pilatoꞌ aza engiꞌ laniꞌ gamaziloꞌ nene gele ngemo Izesuꞌni bililizave lo lo hukineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Neꞌmine ogo ve ma gomuꞌ Zelusalemi numuno ebekuꞌ lovo do sotoꞌ ogo evenekisi ma bele helavo galapusoloꞌ huli-dikevo minive nene mo galapusolotiꞌ osuꞌ lo lelita alive li lave nene galapusolotiꞌ osuꞌ lo-dosa Izesuꞌni nene engiꞌ luꞌnidoꞌ eꞌmeto ami pilisi veti aꞌninguꞌ molavo di vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Neꞌmine ogavo Izesuꞌni nene eleꞌmizi di nivavo ve ma Afilika misubo gaheve Kilene misuboukotiꞌ minive gulive Simoniꞌ aza nene Zelusalemi numuno ebeꞌ hetatiꞌ ogo tauniko dizo voloso adotiꞌ ogo akaloꞌ neivo ningisa Izesuꞌ gehe do vo minineꞌ lohotoꞌ za nene gehe do eꞌmeto alive li gihi-dikevo geho eꞌmeto vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Neꞌmine igi nivavo eveneꞌ mukiꞌ goloso nene ngeꞌmeti nivavo aꞌminguꞌ veneꞌ ma vaniꞌ nete Izesuꞌni nene mulumo gili-di aꞌnine gesebeꞌ izi ive nama i-diꞌmi eꞌmeti vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Neꞌmine iꞌmi nivavo Izesuꞌ nene mine velepeꞌ izo tiꞌ lo lo-ngimineꞌ: Zelusalemi venekizo, nenikumuꞌ nene ive nama ami asi langisetinemukisi idoꞌ lengiꞌ izipahatinemukisivoꞌ nene ive ilo. ");
INSERT INTO aso_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Idoꞌ lingine neꞌmine ilizaniꞌ nene mene giliꞌ nalo. Gamene ma sotoꞌ olosa neineꞌ sotoꞌ ilinguꞌ nene gohuno venekumukisi izipe gidamaniꞌ venekumukisi idoꞌ izipe amine ngimamaaꞌ naniꞌ venekumukisi nene evenelite tiꞌ li lilisave: Geni naba sotoꞌ o neinguꞌ mene Izipahaꞌine nomivo minaniꞌ neꞌmo nene mo lamineꞌ minikeve li lilisave. ");
INSERT INTO aso_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Idoꞌ aꞌmine gamene nene evenelite golo nabamuꞌ nene ngutoko lemo molo hite-ledevo idoꞌ golo ngomomuꞌ nene ogo do haleke-ledevo lilizaniꞌ gamene mineleseive. ");
INSERT INTO aso_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Neꞌmine lo tiꞌ lo lo-ngimineꞌ: Naza neꞌmine noluvoniꞌ nene neꞌmine ma i-nidilizaniꞌ nene naza eveneꞌ lamineꞌ oloꞌ gosohoꞌ neꞌmine minuve ma nene neꞌmine i-nidilisaniꞌza alingeꞌ gamene atoꞌ ma sotoꞌ ilinguꞌ lingine monovo goloso daaꞌ nave oloꞌ gokoꞌ neꞌmine gili minave nene agae, initeꞌ di nadiꞌ i-lingidiꞌ nalizavo. ");
INSERT INTO aso_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Idoꞌ gizengize ve sitaꞌ ma nesi nene Izesungisi makaꞌ lohotoꞌ zaloꞌ ngibili hililisa ngeleꞌmizi di vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mo ngeleꞌmizi vi ebeꞌ ma gulive Godoꞌine Amuzo ve laaꞌ adoꞌ nene heteli aꞌmidoꞌ nene Izesuꞌni lohotoꞌ zaloꞌ bili badisa idoꞌ gizengize ve sitaꞌ nesi nene ngibili hela hela ana hulaaꞌ idaasi hulamaaꞌ idasi badi-ngidaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Neꞌmine ikevo Izesuꞌ nene tiꞌ lo lineꞌ: Ahono, ingine mene igi mili naniꞌ initeꞌ nene gili guni amaze. Lihimeꞌine hulo-ngedezo. Neꞌmine lavo ingine Izesuꞌ okoꞌnoloꞌ initeꞌ nene zaho dalihe dalihe li geheni ngomo ngomo hulaaꞌ zohiꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Neꞌmine navo eveneꞌ ma nene aꞌmine ngibili badadoꞌ nene oti mini ningi minaniꞌ. Idoꞌ Zuda veti gizebo veꞌine nete nene divi lediviꞌ igi gizeꞌ zohika eikumuꞌ li mini tiꞌ li laniꞌ: Aza nene eveneꞌ do nguꞌ izo do lamineꞌ o-ngedaaꞌ ive ve laniꞌ nenako aza nene leliꞌ do luꞌ izelive lo Oꞌmosoꞌmo imiselelesa live nene eiꞌ neivo ma eiꞌ okoꞌno nene do uꞌ izezo lovo. ");
INSERT INTO aso_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Neꞌmine likevo ami pilisi ve netesi nene gizeꞌ zohika li golo izi vaini noso ekeseꞌ o vineꞌ nene nalihe li neida di igi imilisa igi ");
INSERT INTO aso_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tiꞌ li laniꞌ: Gaza nene Zuda veti guveꞌinesi ve naba noo ma nene gasika geiꞌ nene do guꞌ izevo. ");
INSERT INTO aso_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Idoꞌ lohotoꞌ za veleta nene luhuvo ma tiꞌ li gizikaniꞌ nene bili giꞌmizikaniꞌ: Me ve nene Zuda veti guveꞌinesi ve naba ve. ");
INSERT INTO aso_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Idoꞌ gizengize ve ngibili badaniꞌ sitakutiꞌ maliꞌmo nene Izesuꞌni dovo ledevoꞌ ogo tiꞌ lo lo-dineꞌ: Gaza nene do luꞌ izelive lo Oꞌmosoꞌmo gimiselelesa live ma nene nane. Olo. Nemuꞌ amuzokasi naneꞌ noloseinako nemuꞌ gasika geiꞌ nene do guꞌ izo idoꞌ lezesi do luꞌ izevo. ");
INSERT INTO aso_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Neꞌmine lo lineꞌza gizengize ve ma neꞌmo nene elemo tiꞌ lo lo-imineꞌ: Lezesi ezesi nene hamoꞌ oloꞌ nogizuneꞌ nenako gaza neꞌmine gamazi lo-deliningumuꞌ nene Oꞌmosoꞌmo lihime gemeleseinako Oꞌmosomuꞌ golisesi mo gelamabe. Olo. ");
INSERT INTO aso_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Leze mene libilaniꞌ nene gizengize ogaꞌ usineꞌ lihimete maloꞌ nene apasi nilibilaniꞌ nene mo lisiheꞌ o neive. Idoꞌ ve me ve nene initeꞌ ma do goloso amidoꞌ hazauꞌ nibilave. ");
INSERT INTO aso_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Neꞌmine losa Izesuꞌni tiꞌ lo lo-imineꞌ: Izesuvo, gaza evenetoꞌ gizebo ilineꞌ amuzo dosa alineꞌ gameneloꞌ nene nenikumuꞌ gelezo. ");
INSERT INTO aso_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Naza mo laminetoꞌ tiꞌ lo nolo-gimuve. Idise mene Okulumoꞌ ebeꞌ gulive Paladisi ebekuꞌ gesi nesi makatoꞌ bizo minelesusive. ");
INSERT INTO aso_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Neꞌmine lo nolivo holiseꞌ tuvelu (12) kiloku neꞌmine neivo hoꞌ lamivo ebeꞌ mukikuꞌ nene litiꞌmuso ize geseꞌ ogo mine do vo tili (3) kiloku nivengaꞌ ogavo gohi labanaꞌ ilineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Idoꞌ monoꞌ numuno nabauꞌ Oꞌmosoꞌmi kekeize numuno lulo ve li numuno lulo ma lavolavo nabaꞌ nabadunuꞌ izi huki Oꞌmosoꞌmo minaaꞌ inguꞌ dizaaꞌ aka hizi tilikaniꞌ nene belo hoꞌ lo sitaꞌ ogo ngoloꞌ lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Neꞌmine ogavo Izesuꞌ nene asi naba lo tiꞌ lo lineꞌ: Ahono, neniꞌ voꞌnehaza nene geiꞌ angauꞌ nomuluve. Neꞌmine losa ahuꞌ do dizo nohulo hilineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nohilivo ami pilisi veti gizebo ve aza nene sotoꞌ ineꞌ initeꞌ nene ningo Oꞌmosoꞌmi gulive do naba o-do tiꞌ lo lineꞌ: Mo laminetoꞌ me ve ma nene mo eveneꞌ lisiheꞌ minaniꞌ neive. ");
INSERT INTO aso_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Neꞌmine lo lavo aꞌmine Izesuꞌni bililizaniꞌ ningilisa aꞌmida igi di geseꞌ ave mukiꞌ ingine aꞌmine sotoꞌ ineꞌ initeꞌ nene ningi mulumo naba goloso gili aꞌine gesebeꞌ iziꞌmi iziꞌmi numuꞌnida tineꞌ mili vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Idoꞌ neꞌmine navo eiꞌ zogo ve zuho mukikisi nGalilaia misuboukotiꞌ makaꞌ aniꞌ venekisi nene hotoꞌ ile mini aꞌmine sotoꞌ ineꞌ initeꞌ nene ningi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Idoꞌ neꞌmine ikevo ve ma gulive Zoseheꞌ aza nene Zuda veti numuno ebeꞌ ma Alimataiatiꞌ ve minineꞌ. Aza nene eveneꞌ lamineꞌ hehe lo minive Zuda veti kanisoleti muliseutiꞌ ve minineꞌza kanisole linge nete Izesuꞌni belelone li lovo gizi li hukisa aꞌmine niteꞌ igi mili anguꞌ nesi nene gele ngemamineꞌ ve. Asi Oꞌmosoꞌmo evenetoꞌ gizebo ilineꞌ gamene alingumukovoꞌ nene gizebo ogo minaaꞌ ive minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aꞌmine ve neꞌmo nene Pilatoꞌ neida vo Izesuꞌ okoꞌnomuꞌ nene nemelive lo longoꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Neꞌmine ogavo ha do vo molo-delesane lavo Izesuꞌni nene lohotoꞌ zalotiꞌ apaso do lemo lavolavo laminekuꞌ asabuꞌ izo do vo gonoso galese gehenguꞌ ma goloꞌvati liliꞌ anguꞌ nene eveneꞌ hamokisi ma mili-ngidamanguꞌ apiꞌ ogo molo-dineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aꞌmine molo-dineꞌ gamene nene holiseꞌ gameneuꞌ nalizaniꞌ nosoꞌ niteꞌ di vaꞌvaꞌ igi mili minaaꞌ gamene Falade minineꞌ nenako engiꞌ holiseꞌ minaaꞌ aniꞌ gamene nene mo alitelesa neivo molo-dineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Neꞌmine neivo nGalilaia misuboukotiꞌ Izesuꞌni eꞌmeti aniꞌ veneꞌ nene Zoseheꞌ aza Izesuꞌni nene do zala molo-delihe li ningilisa eꞌmeti vi aꞌmine gonoso galese nene ningi gonoso molo-dineꞌ nesi nene ninganiꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mo ningisa tineꞌ mili numuꞌnida vi gonoso nene geleso unuvo ogalive li gonosoloꞌ hilaaꞌ aniꞌ uveli ato atoꞌ nene di vaꞌvaꞌ igi minisa holisekuꞌ nene engiꞌ louꞌ gamaziꞌmo lidoꞌ eꞌmeti haza mini gili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Neꞌmine igi mini gili minisa aꞌmine Zuda veti holiseꞌine Salele nene osuꞌ lavo Sadeuꞌ nedengaꞌ holukatiꞌ nene aꞌmine veneꞌ ingine aꞌmine gonosoloꞌ hilaaꞌ aniꞌ uveli di vaꞌvaꞌ igi milaniꞌ ma nene di gonoso galesela vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Vi heteli ninganiꞌ nene aꞌmine gonoso galeseliꞌmi veleloꞌ geheni naba di tilikaniꞌ ma nene veleheꞌ mili hulikeniꞌ neivo ningisa ");
INSERT INTO aso_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ingine aꞌminguꞌ dizi vi ninganiꞌ nene aꞌmine gonoso Izesuꞌ okoꞌnoꞌve nene nomivo ma ningamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma ningami aꞌminemuꞌ nene gopo gaꞌine gili nizavo aizo, eveneꞌ sitaꞌ ma liteꞌ li sotoꞌ igi veneꞌ minada nene oti minasineꞌ ve. Aꞌmine veti okoꞌnidoꞌ initeꞌ neꞌmo nene veꞌne veꞌne lo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Neꞌmine ivo nizasivo veneꞌ ingine golise gili ngehelele noizivo gubiꞌ izi misubouko goꞌine veꞌine nihulavo ve sitaꞌ ingine tiꞌ li li-ngimasineꞌ: Velesi neivemuꞌ nene hilavetinguꞌ mene nanimuꞌ viseꞌ nave. ");
INSERT INTO aso_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aza nene meuꞌ nomineꞌza asi mo kululuꞌ izo otave. Idoꞌ lingine nGalilaia misubouko velesi ha mino tiꞌ lo lo-lingimineꞌ mamuꞌ giliꞌ nalo: ");
INSERT INTO aso_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Oꞌmosolatiꞌ ve gihile naza nene monovo goloso daaꞌ aveti aꞌninguꞌ neleꞌmizi milikevo lohotoꞌ zaloꞌ nibili hilikevo gamene sito hamo minosa gohi otelesuve. ");
INSERT INTO aso_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Neꞌmine lo neineꞌ ma neive li likesivo veneꞌ ingine gomuꞌ aꞌmine neꞌmine lineꞌ mala gohi gaꞌine gilii ");
INSERT INTO aso_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","gonoso galese nene hulii gohi tineꞌ mili numuꞌnida vi eiꞌ Izesuꞌ izipahala zuho leveni engikisi idoꞌ minaniꞌ aleve linge mukiꞌ nesi nene aꞌmine ninganiꞌ initeꞌ mukiꞌ nemuꞌ nene veteteꞌ igi li-ngimi osuꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aꞌmine ninganiꞌ initekumuꞌ aposolo li-ngimaniꞌ veneꞌ nene Zoanaꞌ ve Zakoboꞌ izeleho Maliaꞌ ve idoꞌ Mangadala ebetotiꞌ veneꞌ Maliaꞌ atoꞌ gohi ma ve idoꞌ veneꞌ ma makaꞌ monaniꞌ veneꞌ nete nene li-ngimaniꞌza ");
INSERT INTO aso_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ingine aposolo nete nene aꞌmine venelite li-ngimaniꞌ gamazi nene abelenga gamazi nilave lii gili eleꞌvoleꞌ amaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Neꞌmine aniꞌza Petoloꞌ nene oteko lotiꞌ izo gonoso galesela vo hetelo aꞌminguꞌ gubiꞌ izo ningineꞌ nene initeꞌ ma nomivo Izesuꞌ okoꞌnoloꞌ asabuꞌ izaniꞌ lavolavo mavoꞌ nene ha neivo ningo aꞌmine sotoꞌ ineꞌ initekumuꞌ nene gala geleꞌmo geleꞌmo numuda tineꞌ molo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Idoꞌ aꞌmine Izesuꞌ galeseuꞌ nomivo ninganiꞌ gameneuꞌ nene Izesuꞌni eꞌmetaveutiꞌ ve sitaꞌ ma Emausi numuda vilisa vasineꞌ. Aꞌmine numuno ebeꞌ nene Zelusalemi numuno ebetotiꞌ leveni kilomita (seveni maili) neꞌmine minineꞌ nenako ");
INSERT INTO aso_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ingine aꞌmine Emausila vilisa akaloꞌ nivi nivi aꞌmine Izesuꞌni bilaniꞌ gamazi nemuꞌ veteteꞌ igi li voleloꞌ meloꞌ iꞌmi vasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Neꞌmini gamazi li voleloꞌ meloꞌ igi liꞌmi nivasivo asiꞌve Izesuꞌ nene ogo aꞌminguꞌ makaꞌ vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Makaꞌ engikisi vineꞌza ve sitaꞌ netisi veꞌnidoꞌ nene hitavo Izesuꞌ ve li ma ningi gilamasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ningi gilamasivo aza tiꞌ lo longoꞌ o-ngidineꞌ: Lingine gamazi li voleloꞌ meloꞌ igi li gili ha gele iꞌmi nivasineꞌ nene nani gamazi li voleloꞌ meloꞌ iꞌmi nivasive. Neꞌmine lavo ingine vi oti mini goꞌine veꞌine di muheleꞌ igi minasineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Neꞌmine igi mini engikutiꞌ gulive Keleopaꞌ ve lo minive neꞌmo Izesuꞌ lineꞌ gamaziloꞌ nene tiꞌ lo lo-imineꞌ: Ve melo, venenga ve Zelusalemi numuno ebekuꞌ imi nizaniꞌ netesi nene aizeꞌ okozoꞌ aꞌmene sotoꞌ ineꞌ initeꞌ nemuꞌ nene mo gili osuꞌ li nizaniꞌza geiꞌ hamoꞌ nene ma gelamabe. ");
INSERT INTO aso_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lineꞌ: Initeꞌ naniteꞌ sotoꞌ ive. Neꞌmine lavo ingine tiꞌ li li-imasineꞌ: Laza gamazi lo voleloꞌ meloꞌ ogo loꞌmo nousineꞌ initeꞌ nene Nasalete ve Izesuꞌni mamuꞌ nene nolusive. Aza nene Oꞌmosoꞌmo ningivo idoꞌ eveneꞌ mukilite ningavo polohete mino gamazi laaꞌ idoꞌ initeꞌ ogo molo ogaꞌ ineꞌ nene eleꞌvoleꞌ ogovoꞌ gamazi laaꞌ idoꞌ ogo molo ogaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Neꞌmine ogaꞌ ineꞌza evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabatelitesi idoꞌ leliꞌ gizebo vete netesi nene Izesuꞌni bili hililizave li goniꞌ i-dikevo lohotoꞌ zaloꞌ bili hilaniꞌ ve. Laza nemuꞌ nene loꞌmo nousive. ");
INSERT INTO aso_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Neꞌmine igi bili hilaniꞌza laza eikumuꞌ nene gomuꞌ tiꞌ lo gele minuneꞌ ve: Eveneꞌ golosolite leliꞌ Isilaeleꞌ aleve gizebo i-lidi minavo gelekeleꞌ o-ngedo minuningutiꞌ aza nene do kuluhize-ledelive ma nene eiꞌ ne neive lo giluneꞌ ve. Idoꞌ gamazi gohi ma nene aꞌmine initeꞌ sotoꞌ idotiꞌ nene gamene sito hamo ogo novineꞌ nenako mo mudise initeꞌ noloseive. ");
INSERT INTO aso_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Neꞌmine o neineꞌza idise leliꞌ zuhoutiꞌ veneꞌ linge malite igi gamazi ma likevo upuhoꞌ okune. Ingine nene gonoso galesela nedengaꞌ holukatiꞌ vaniꞌ nene ");
INSERT INTO aso_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","aꞌmine gonoso ningami tineꞌ mili numuda igi vamuꞌ neꞌmine veteloꞌ o molavo angeloꞌ ma sotoꞌ i limi tiꞌ li lasive li veteteꞌ igi li-limave: Izesuꞌ nene oto velesi neive. ");
INSERT INTO aso_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Neꞌmine li veneꞌ nete li-limikevo lelikutiꞌ malite gonoso galesela vi ninganiꞌ nene venelite laniꞌ maꞌmino neivo ninganiꞌza eiꞌ Izesuꞌni nene okoꞌnoloꞌ ma ningamave. ");
INSERT INTO aso_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Neꞌmine li li-imikesivo aza tiꞌ lo eikumukisi lo-ngimineꞌ: Lingine nene ha eveneꞌ negi nizasive. Lingine polohetelite laniꞌ gamazi mukiꞌ gili eleꞌvoleꞌ igaꞌ ilisanako geni lingibilineꞌ gelavo mini gamazi linge ma nene gili eleꞌvoleꞌ isaꞌmasive. ");
INSERT INTO aso_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Idoꞌ do lunguꞌ izelive lo Oꞌmosoꞌmo imiselelesa live nene mulumo alumo niteꞌ gehosavoꞌ alingeꞌ nene Guvelesi ve loloꞌ ogo minaaꞌ moꞌmosiꞌve labanaꞌvesi minineꞌ nene daloseive li gizi nizaniꞌ nenako aꞌmine gamaziloꞌ eꞌmeto do gihile izamilineꞌ o neihe. ");
INSERT INTO aso_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Neꞌmine losa eikumuꞌ monoꞌ godolouꞌ gizikaniꞌ gamazi mukiꞌ nene Moseꞌ gizineꞌ gamazi mukikutiꞌ nene apiꞌ ogo lo ngoloꞌ lo lo-ngemeꞌmo vo polohete mukilite gizangukotikisi nene lo-ngeme osuꞌ lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Neꞌmino lo-ngeme ngemeꞌ ivo ingine vi aꞌmine velise vilisa asineꞌ numuno ebeꞌ Emausi nene di alitaniꞌ ve. Neꞌmine igi aza nene aꞌmine numuno ebeꞌ nene hulo ivileꞌ oko volosa neivo ");
INSERT INTO aso_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ve sitaꞌ ingine oꞌve li-di tiꞌ li li-imasineꞌ: Hoꞌ nene mo lemo vo mo litiꞌmuso izelidoꞌ o neize. Gaza nene lelikisi makaꞌ ongalone likesivo gele ngemavo numunguko nene makaꞌ vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mo numunguko dizi vi nosoꞌ niteꞌ nalisa nene mitoꞌ minisa aza beleti ma dosa Oꞌmosola opoꞌni lo apilo ngimineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Idoꞌ ve sitaꞌ nene veꞌnidoꞌ hite minivo Izesuꞌ neive li ma ningamasivo aniꞌ ma neineꞌza beleti nene apilo nongimivo Izesuꞌ neive li ninge lamineꞌ asineꞌ. Mo ninge lamineꞌ nasivo makaꞌ minadotiꞌ nene gopo ogavo gohi ningamasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Neꞌmine ogavo ingine tiꞌ li li voleloꞌ meloꞌ igi tiꞌ li lasineꞌ: Aza nene akala unida gamazi lo-liminguꞌ nene monoꞌ godoloutiꞌ gamazi lo ngoloꞌ lo lo-lemeꞌmo navo luteuꞌ gulumo liso minivo usineꞌ ma nene eiꞌ neive lo ningelosinako agae, nanimuꞌ ningamusivo. ");
INSERT INTO aso_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Neꞌmine lisa liteꞌ li oti Zelusalemi numuda tineꞌ mili vasineꞌ ve. Vi Zelusalemi numuda heteli eiꞌ Izesuꞌ izipahala zuho leveni nesi idoꞌ inginesi makaꞌ minaaꞌ ave linge ma nesi nene mulise mili nizavo vi hetelikesivo ingine ");
INSERT INTO aso_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","tiꞌ li ve sitaꞌ nene li-ngimaniꞌ: Guvetesi ve ma nene mo laminetoꞌ hilingutiꞌ otosa Simoniꞌni nene sotoꞌ o emave. ");
INSERT INTO aso_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Neꞌmine li ingine likevo ve sitaꞌ ingine Emausi numuno akala nivasivo Guvelesi ve aza vovoꞌninguꞌ sotoꞌ o ngemavo ingine eiꞌ ve li ningi gilamasivo makatoꞌ vi numunguꞌ dizi mini beleti gito apilo nongimivo eze ningi hehe lasineꞌ nemuꞌ nene veteteꞌ igi li-ngimasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Li-ngimikesivo izipahala zuho ingine aꞌmine gamazi nene li voleloꞌ meloꞌ igi nizavo Izesuꞌ asiꞌve nene vovoꞌninguꞌ sotoꞌ ogo ote mino tiꞌ lo lo-ngimineꞌ: Muludinguꞌ nene lamineꞌ hongu lo minivo. ");
INSERT INTO aso_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Neꞌmine lo lo-ngimineꞌza ingine upuhoꞌ goloso igi ngehelele goloso izavo ingine nene holoso neꞌmine ma noningube li gaꞌine gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Neꞌmine li nigilavo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Lingine upuhoꞌ igi lutinguꞌ gopo gatine nigilaniꞌ nene nanimuꞌ nigilave. ");
INSERT INTO aso_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lingine idise nininganiꞌ okoꞌne neꞌmino holoso neve okoꞌinesi amuzohazaꞌinesi nene mo nomineꞌ nizaniꞌ nenako nemuꞌ naza mene neniꞌ ma nene nouze. Lingine gizeꞌne aꞌneloꞌ huꞌne mene ningi okoꞌneloꞌ nesi di gili ningi gililo.  ");
INSERT INTO aso_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aza neꞌmine lo lo-ngemosa gizene analoꞌ bilaniꞌ hulo nene do ngelebizineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Neꞌmine ineꞌza ingine nene lolize izaaꞌ initeꞌ atoliꞌmine goloso nene lelita ngelo sotoꞌ ilihe lisa Izesuꞌ ma nene mo galeseutiꞌ otave li gili eleꞌvoleꞌ ami gopo gaꞌine ha gili nizavo Izesuꞌ aza nosoꞌ niteꞌ ma milahe milamave lo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Neꞌmine lavo izipahala zuho ingine alahaꞌ olotoꞌ miliviꞌ diviꞌ igi gizaniꞌ ma di imikevo ");
INSERT INTO aso_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","dosa ningi nizavo naniꞌ. ");
INSERT INTO aso_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Idoꞌ Izesuꞌ tiꞌ lo izipahala zuho lo-ngimineꞌ: Naza gomuꞌ linginesi makaꞌ haza minunidoꞌ ma nene tiꞌ lo lo-lengemaaꞌ uvoniꞌ ma neive: Moseꞌ louꞌ gamazi idoꞌ Oꞌmosoꞌmi veletiꞌ gamazi li sotoꞌ igaꞌ avete gizaniꞌ gamaziuꞌ idoꞌ Oꞌmoso di naba i-di laaꞌ aniꞌ nama gizanguꞌ nenikumuꞌ li mili luhuvo gizaniꞌ gamazi nene gihile ize osuꞌ lilidoꞌ o neive lo lo-lengemaaꞌ uvoniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Neꞌmine lo lo-ngemo aꞌmine monoꞌ godolouꞌ luhuvo eikumuꞌ gizaniꞌ mamuꞌ nene gili ngoloꞌ li gililizave lo luꞌine gaꞌine do ngolose-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Neꞌmine o-ngedo tiꞌ lo lo-ngimineꞌ: Monoꞌ godolouꞌ nene do lunguꞌ izelive lo Oꞌmosoꞌmo imiselelesa live aza nene mulumo alumo gelo helosa gamene sito hamo mino hilingutiꞌ gohi oteleseive li gizi nizaniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Idoꞌ neꞌmine ogavosa eveneꞌ nene lutine di velepeꞌ izikevo Oꞌmosoꞌmo lihimetine hulo-lengedeleseive li Zelusalemi numuno ebekutiꞌ apiꞌ igi eiꞌ velemuꞌ li-ngimi ngimiꞌ iꞌmi moni eveneꞌ zuho ato atoꞌ minaniꞌ mukiꞌ nene li-ngimilisave li gizi nizaniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aꞌmine gamazi mukiꞌ nene gihile izeꞌmo novivo lingine ningiꞌmi nivaniꞌ nenako nemuꞌ lengiꞌ nene li sotoꞌ sotoꞌ iliza ve ma nene nizave. ");
INSERT INTO aso_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Idoꞌ gililo. Meꞌneho aza Sikalahuꞌve nene lehize-lengedelesuve lo lo hukineꞌ maloꞌ nene eꞌmeto imiselekuvo lengita lemeleseive. Lemeleseiha olihe Okulumokutiꞌ lemo do amuzo molo-lengedamidoꞌ nene Zelusalemi numuno ebeꞌ mene liteꞌ li huli mala vami ha gizebo i minilo. ");
INSERT INTO aso_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Idoꞌ Izesuꞌ aza izipahala zuho nene ngeleꞌmizo Betani numuno ebeꞌ minida vo mino ana do hozi losa noꞌnohoꞌ ize-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Neꞌmine o-ngedosa mo hulo-ngedavo Oꞌmosoꞌmo Okulumokuko eleꞌmizo do dizo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Okulumokuko dizo vavo izipahala zuho ingine di naba i-disa Zelusalemi numuda muluꞌninguꞌ lamineꞌ goloso gili tineꞌ mili vi mini ");
INSERT INTO aso_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","gamene gamene monoꞌ numuno nabauꞌ nene dizi Oꞌmoso opoꞌni li minaaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Oꞌmosoꞌmo initeꞌ mataꞌ olihe do sotoꞌ amineꞌ gameneloꞌ vomine Oꞌmosoꞌmi gamaziloꞌ medelive nene ha minineꞌ ve. Idoꞌ aꞌmine ve nene Oꞌmososi makaꞌ mino azasi Oꞌmoso minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ganakutiꞌ Oꞌmoso mine do ada nene azasi makaꞌ minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Initeꞌ mataꞌ mukiꞌ sotoꞌ aniꞌ nene aꞌmine Oꞌmosoꞌmi gamaziloꞌ medelivelatikovoꞌ sotoꞌ aniꞌ ve. Eitatiꞌ sotoꞌ amineꞌ initeꞌ nene hamokisi ma nomive. ");
INSERT INTO aso_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aza nene minevoꞌ minevoꞌ lemeni dameniꞌmi meleho minaavo eveneꞌ laza eitatiꞌ minevoꞌ minevoꞌ lemeni nene dokunivo neꞌmo liviꞌ neꞌmino do labanaꞌ ele-ledaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aꞌmine labanaꞌ nene litiꞌmusouꞌ hize labanaꞌ elaaꞌ neivo litiꞌmuso neꞌmo nene ngelo molo hite-desaꞌmivo ha labanaꞌ ele minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Eveneꞌ ma Oꞌmosoꞌmo imiselavo aniꞌ nene gulive Zohaneꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aza eveneꞌ maliti gamazi li sotoꞌ igaꞌ ave neꞌmine loloꞌ ogo ogo hetelineꞌ nene aꞌmine labanaliꞌmi melehi gamaziꞌve lo sotoꞌ o ngemavo nemuꞌ eveneꞌ mukiꞌ nene aꞌminemuꞌ gili eleꞌvoleꞌ ilizave losa ogo hetelineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Eiꞌ neve nene aꞌmine labanaliꞌmi meleho gehepeve nene minivoba asi aꞌmine labanaliꞌmi melehinemuꞌ nene lo sotoꞌ sotoꞌ olosa aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Labanaliꞌmi meleho gehepeve eveneꞌ mukiꞌ lute hize labanaꞌ ele-ledaaꞌ ive nene mo me misubouko navosa lo sotoꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aꞌmine Oꞌmosoꞌmi gamaziloꞌ medelive aza nene me misubouꞌ omo minineꞌza me misubo nesi nene do sotoꞌ ineꞌza me misubouꞌ aleve nete nene eze ningi eiꞌ monovomuꞌ nesi nene mo ningi gilamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eiꞌ misuboꞌveuko nene ogo hetelineꞌza eiꞌ aleve gehepeve nete nene ma gili imamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Idoꞌ eveneꞌ ma gili imave mukiꞌ adoꞌ eikumuꞌ lineꞌ gamazi gili eleꞌvoleꞌ igi eitoꞌ gili muꞌmusiꞌ i-dave engiꞌ nene gele ngemavo Oꞌmosoꞌmi izipahala liliꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Idoꞌ Oꞌmosoꞌmi izipahala liliꞌ aniꞌ nene eveneꞌ zuho malotiꞌ sotoꞌ adotiꞌ nene nomive. Idoꞌ veneꞌ vemohoꞌ okoꞌineꞌmo laniteꞌ gilivo ingasidotiꞌ sotoꞌ aniꞌ nene nomive. Idoꞌ ve maliꞌmi luloloꞌ sotoꞌ aniꞌ nomive. Asi mo Oꞌmosoꞌmo gelavo eiꞌ izipahala gihile liliꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Idoꞌ Oꞌmosoꞌmi gamaziloꞌ medelive nene leliꞌ okode neꞌmine do otuho eveneꞌ loloꞌ ogosa leliꞌ vovoteuꞌ ogo gamene liꞌnibemukovoꞌ minevo dovoꞌ inguꞌ nene nasahiliꞌ ogaꞌ monovosi idoꞌ Oꞌmosoꞌmi monovo gihile nesi nene ezela vauve elo minivosa amuzoꞌve do sotoꞌ ogo minineꞌ nene mo ninguneꞌ ve. Asiꞌve eiꞌ meleho Oꞌmosoꞌmi vonoloꞌ gipele hamoꞌ gehepeve minineꞌ nenako neꞌmo nene aꞌmine ninguneꞌ amuzoꞌve nene do minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Eze monovo nene Zohaneꞌ aza tiꞌ lo lo sotoꞌ ineꞌ ve: Neniꞌ meheꞌnela nave nene nenikisi olihe sotoꞌ amuvosa gomukutiꞌ ha minive neineꞌ nenako eiꞌ neniꞌ nene nivileꞌ ogo ve naba neive lo gomuꞌ luhe. Aꞌmine luve ma nene me ve nene neive lo nongelebizo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ee, ezela nasahiliꞌ ogaꞌ monovo vauve elo minineꞌ ve luvoniꞌ nene aza leze mukiꞌ nene nasahiliꞌ gohi gohi o-lidineꞌ nene aꞌmine monovo ezela vauve elo minidotiꞌ neꞌmine o-lidineꞌ nenako nemuꞌ luve. ");
INSERT INTO aso_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Idoꞌ me gamazi noluvoniꞌ nene Oꞌmosoꞌmo eiꞌ louꞌ gamaziꞌve lo-emavo lo-limive Moseꞌ nene lo-limineꞌza nasahiliꞌ monovo nesi idoꞌ Oꞌmosoꞌmi monovo gihile nesi do sotoꞌ ive nene Izesuꞌ Kilisitoꞌ do sotoꞌ ineꞌ nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Idoꞌ Oꞌmoso nene ve hamolitesi mo kekeꞌ ningamune. Ningamuneꞌza Oꞌmosoꞌmi gipele hamoꞌ minive azasi nene Oꞌmoso mino melehosi makaꞌ bizi minasive neꞌmo Oꞌmoso nene do sotoꞌ ogo lelebizavo ningo gele none. ");
INSERT INTO aso_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Idoꞌ Zuda veti monoꞌ gizebo ve ingine nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ avesi idoꞌ Leviꞌ aꞌvopilemoꞌ monoꞌ numuno nabauꞌ gonoloꞌ ve nesi nene Zelusalemi numuno ebetatiꞌ ngimiselikevo vi Zohaneꞌnimuꞌ nene zaho nane li eiꞌ monovomuꞌ longoꞌ i-dikevo eiꞌ monovo nene neꞌmino lo sotoꞌ ogo lo-ngimineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ingine gamazi ladoꞌ nene ataize livoba mo lamino lo sotoꞌ ogo naza nene Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ma nene nomuve lo lo-ngimineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Neꞌmine lo lo-ngemavo tiꞌ li longoꞌ i-daniꞌ: Idoꞌ neꞌmine lo ma gaza nene zaho nane. Gomuꞌ polohete Eliaꞌni nene Oꞌmosoꞌmo gohi imiselelesa live ma ne nabe. Likevo aza nene aꞌmine nomuve lineꞌ. Neꞌmine lavo ingine tiꞌ li laniꞌ: Idoꞌ gaza neꞌmine laniko polohete alingeꞌ ma aloseive lo Moseꞌ live ma nene nabe. Neꞌmine laniꞌza oꞌve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Neꞌmine lavo ingine tiꞌ li gohi longoꞌ i-daniꞌ: Laza nene geiꞌ nene zaho nolibe gaza nemuꞌ lo-lemanivo longoꞌ i-gidilisa limiselave nene vo lo-ngemesoꞌ nenaze. Gaza nene mo zaho nouve laaꞌ nane. ");
INSERT INTO aso_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ: Polohete Isaiaꞌ tiꞌ lo live ma nene nouve. Ebeꞌ hadivelatiꞌ eveneꞌ maliꞌmo asi naba ma tiꞌ lo nolive: Guvelesi ve alingumuꞌ ve li akaꞌve di lisiheꞌ i-dilo. ");
INSERT INTO aso_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Idoꞌ neꞌmine lavo Halisaioꞌ monoꞌ laaꞌ avete ngimiselikevo ave ");
INSERT INTO aso_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ingine longoꞌ i-di tiꞌ li laniꞌ: Gaza monoꞌ noso eveneꞌ noholo-ngedaineꞌ nene gaza Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live minamo polohete Eliakisi minamo idoꞌ polohete aloseive lave nesi minamaneꞌ nenako nanimuꞌ neꞌmine nane. ");
INSERT INTO aso_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Neꞌmine likevo Zohaneꞌ aza aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ ve: Neniꞌ nene haza nosodunukovoꞌ holo-ngedaaꞌ nouvoniꞌza ");
INSERT INTO aso_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","lengiꞌ vovotinguꞌ nene ve ma neive. Aꞌmine ve nene lingine ningamaniꞌza aza nene nenitoꞌ medelelesa meheꞌnela nave. Naza aꞌneꞌmine goboni gono do do eiꞌ suuꞌvelotiꞌ nalaꞌve nesi nene apase hulo-delodoꞌ lisiheꞌ amuve lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Idoꞌ aꞌmine noluvoniꞌ initeꞌ meve nene Zohaneꞌ monoꞌ noso holo-ngedo minaaꞌ idaa hoꞌ dizaaꞌ idaa Zodani noso hela holela Betania numuno ebeta sotoꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ongo goꞌ lavo Izesuꞌ nene monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ neida navo ningo tiꞌ lo lineꞌ ve: Aizo, ningilo. Lihimetemuꞌ belaaꞌ nouneꞌ sipisipi angaleloꞌ medelo Oꞌmosolatiꞌ minive me misubouꞌ aleveti lihimete apase-ledaaꞌ ive ma ve. ");
INSERT INTO aso_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Naza neniꞌ meheꞌnela ve ma naniꞌ nene nenikisi olihe sotoꞌ amuvosa gomukutiꞌ ha minive neineꞌ nenako eiꞌ neꞌmo neniꞌ nene nivileꞌ ogo ve naba neive lo gomuꞌ luvoniꞌ ma nene me vemuꞌ luve. ");
INSERT INTO aso_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nazasi nene eze ma ningo gelamo minuvoniꞌza naza ogo hetelo eveneꞌ nosodunuꞌ noso holo-ngedeꞌmo ogo minuvoniꞌ nene Isilaeleꞌ aleve ezemuꞌ ningi gililizave losa do sotoꞌ o-delesa uvoniꞌ ve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Idoꞌ Zohaneꞌ tiꞌ lo gamazi ma lo sotoꞌ ineꞌ ve: Naza Oꞌmosoꞌmi Sikalahuꞌ nene nama viluso neꞌmino Okulumokutiꞌ lemo navo ninguve. Aꞌmine nene lemo ogo aꞌmine vela minive. ");
INSERT INTO aso_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gomuꞌ nene aꞌmine veꞌmi monovo nene ningo gelamuvoniꞌza eveneꞌ nosodunuꞌ noso holo-ngedeline lo nimiselive neꞌmo tiꞌ lo lo-nimive: Neniꞌ Sikalahuꞌneliꞌmo lemo ogo ezela nominivo ningelinive nene aꞌmine Sikalahuꞌne nedunuꞌ nene noso neꞌmino holo-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Neꞌmine lo lineꞌ ma nene naza mo ningosa eiꞌ nene mo Oꞌmosoꞌmi gipele ve lo lo sotoꞌ okaꞌ okaꞌ nouve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ongo goꞌ lavo mino holiseꞌ gamene ogavo Zohaneꞌ nene izipahala zuho sitakisi imi nizavo ");
INSERT INTO aso_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Izesuꞌ aꞌmida ogo novivo Zohaneꞌ vonuꞌ bele mino tiꞌ lo lineꞌ: Ningilo. Lihimetemuꞌ belaaꞌ nouneꞌ sipisipi angaleloꞌ medelo Oꞌmosolatiꞌ minive ma ve. ");
INSERT INTO aso_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Neꞌmine lavo izipahala zuho sitaꞌ nene gili Izesuꞌni eꞌmeti vasineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Eꞌmeti nivasivo Izesuꞌ velepeꞌ izo ningineꞌ nene eꞌmeti nasineꞌ neivo tiꞌ lo lineꞌ: Lingine nanitekumuꞌ nasive. Neꞌmine lavo tiꞌ li li-imasineꞌ: Labi, gaza nene zala minaaꞌ nane (laza aꞌmine gamazi labi nene do velepeꞌ izo tiꞌ lo lolosune: Tisazo). ");
INSERT INTO aso_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tiꞌ li likesivo aza tiꞌ lo lo-ngimineꞌ: Lingine igi ningilizo. Neꞌmine lavo nemuꞌ ezesi makaꞌ vi eiꞌ minaaꞌ ineꞌ numuno nene ningi aꞌmida aꞌmine gamene nene ezesi makaꞌ minaniꞌ. Idoꞌ Izesuꞌ numuꞌvela vaniꞌ nene nivengaꞌ fo kilokuloꞌ nene vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aꞌmine Zohaneꞌ lineꞌ gamazi gili Izesuꞌni eꞌmetasive engikutiꞌ ma neve nene Simoniꞌ Petoloꞌ akunolo Adeleaꞌ minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aza Izesukisi minosa aꞌmidotiꞌ nene geto vo uvolohine Simoniꞌni viseꞌ ogo ningo tiꞌ lo lo-imineꞌ: Mesiaꞌni nene mo ningekune (laza aꞌmine gamazi Mesiaꞌ nene do velepeꞌ izo tiꞌ lo lolosune: Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ve). ");
INSERT INTO aso_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Neꞌmine lo lo-emo eleꞌmizo Izesuda vineꞌ. Eleꞌmizo vavo Izesuꞌ aza vonuꞌ belo tiꞌ lo lineꞌ: Gaza nene Zohaneꞌ gipele Simoniꞌ ma nene nane. Guliveka Kehaꞌ ve lo nomolo-giduve (aꞌmine gulive Kehaꞌ nene do velepeꞌ izo Petoloꞌ ve laaꞌ noune. Aꞌmine Petoloꞌ neꞌmi monovo nene geheni gavulo ve). ");
INSERT INTO aso_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ingi goꞌ lavo Izesuꞌ nene nGalilaia misubouko volove lo gilineꞌ. Neꞌmine lo gelosa Hilipoꞌni viseꞌ ogo ningosa Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza neꞌmeto ano lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Idoꞌ aꞌmine Hilipoꞌ nene Adeleaki Petoloki asineꞌ numuno ebeꞌ Betesaida nelotiꞌ ve minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Neꞌmeto ano lo-davo Hilipoꞌ aza vo Natanieleꞌni ningo tiꞌ lo lo-imineꞌ: Laza Moseꞌ louꞌ gamazi gizingukisi polohetelite gizangukisi ve mamuꞌ li sotoꞌ igi monovoꞌve gizikavo minive ma nene mo ningekune. Aꞌmine ve nene Izesuꞌ Zoseheꞌ gipele Nasalete numuno ebetotiꞌ ave ve. ");
INSERT INTO aso_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Neꞌmine lavo Natanieleꞌ aza tiꞌ lo lineꞌ: Nasalete numudotiꞌ ve ve labe. Aꞌneꞌmine ebekutiꞌ nene initeꞌ lamineꞌ ma ngelo sotoꞌ ilihe. Neꞌmine lavo Hilipoꞌ aza tiꞌ lo lo-imineꞌ: Gasika ma ogo ningeꞌ nazo. ");
INSERT INTO aso_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Neꞌmine lo-davo Natanieleꞌ nene ningelesa Izesuꞌ neida vo nohetelivo Izesuꞌ ningo ezemuꞌ tiꞌ lo lineꞌ: Ningilo. Me ve nene Isilaeleꞌ ve gihile eveneꞌ goꞌine izaaꞌ monovo mo kekeꞌ eita nomive ne neive. ");
INSERT INTO aso_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Neꞌmine lo-davo Natanieleꞌ tiꞌ lo Izesuꞌni longoꞌ o-dineꞌ: Gaza neniꞌ monovo nene nadosa ningo gelane. Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Hilipoꞌ nene geikumuꞌ viseꞌ ogo olihe ningamivosa gaza nene gohuno zaliꞌmi monovouꞌ nanivo ma nene ninguve. ");
INSERT INTO aso_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Neꞌmine lavo Natanieleꞌ tiꞌ lo lo-imineꞌ: Tisazo, gaza nene mo Oꞌmosoꞌmi gipele nane. Adoꞌ Isilaeleꞌ aleve leliꞌ Guvetesi ve naba ma nene nane. ");
INSERT INTO aso_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza idise nenikumuꞌ gele eleꞌvoleꞌ aineꞌ nene gaza gohuno zaliꞌmi monovouꞌ nanivo ninguve luvongumuꞌ nene gele eleꞌvoleꞌ abe. Alingeꞌ nene idise gele eleꞌvoleꞌ aineꞌ initeꞌ nesi nene ivileꞌ ivosa initeꞌ naba goloso ningelesane. ");
INSERT INTO aso_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Neꞌmine lo aꞌmidoꞌ gohi imineꞌ molo tiꞌ lo lo-imineꞌ: Naza laminetoꞌ gehepeve nolo-lingimuve. Okulumoꞌ huko godavo Oꞌmosoꞌmi angeloꞌve nete nene Oꞌmosolatiꞌ ve gihile nenita limaaꞌ dizaaꞌ igi nizavo ningilisave lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Gamene setaꞌ ma ogo vavo sitohamoloꞌ nene nGalilaia misubouꞌ numuno ebeꞌ ma Kana neuꞌ nene ve maloꞌ veneꞌ ma huki mili-di nosoꞌ niteꞌ ni minaniꞌ. Aꞌminguꞌ nene Izesuꞌ izelehosi neivo ");
INSERT INTO aso_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Izesuꞌ eiꞌ izipahala zuhosi nene vise li-ngimikevo vi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Minanguꞌ nene vaini nosoꞌine nene mo osuꞌ lavo Izesuꞌni nene izeleho tiꞌ lo lo-imineꞌ: Vaini nosoꞌine nene mo osuꞌ laniꞌ lae. ");
INSERT INTO aso_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-dineꞌ: Veneꞌ menelo, neniꞌ gono neivosa nolabe. Neꞌmino nomive. Eveneꞌ veꞌnidoꞌ nene neniꞌ monovoꞌne do sotoꞌ oloniꞌ gameneꞌve nene olihe amive. ");
INSERT INTO aso_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Neꞌmine lineꞌza Izesuꞌ izeleho neꞌmo gelekeleꞌ izipe nene tiꞌ lo lo-ngimineꞌ: Aza lo-lengemelineꞌ gamaziloꞌ nene eꞌmeti ilo. ");
INSERT INTO aso_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aꞌmida nene Zuda veti monovoloꞌ eꞌmeti eveneꞌ Oꞌmosomuꞌ gili noso gili hili hiliꞌ igi aꞌine noso izilizangumuꞌ nene geheni somo nabaꞌ naba sigisi nene ma minaniꞌ ve. Aꞌmine somo hamoꞌ hamokuꞌ nene noso tuvedi ngaleni teoti ngaleni neꞌmine ohizi milaaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Idoꞌ Izesuꞌ aꞌmine somouꞌ nene noso ohizi vaiꞌ lilo lo gelekeleꞌ izipe nene lo-ngedavo mo ohizi vaiꞌ goloso likaꞌ likaꞌ aniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Neꞌmine ikevo Izesuꞌ tiꞌ lo lo-ngidineꞌ: Aꞌmingutiꞌ ma nene ohizi nosoꞌ nitetoꞌ gizebo vela di vi imilo. Lavo ohizi di vi imaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Imikevo aꞌmine haza noso neꞌmo nene vaini noso loloꞌ ogo neivo nosoꞌ nitetoꞌ gizebo ve neꞌmo aꞌmingutiꞌ ma no gilineꞌ. No gilineꞌza aꞌmine vaini noso ohizi di igi imave gelekeleꞌ izipe engikovoꞌ nene aꞌmine noso sotoꞌ ineꞌ monovo nene gili minaniꞌza nosoꞌ nitetoꞌ gizebo ve aza nene aꞌmine vaini noso nene zalatiꞌ di ahe aꞌminemuꞌ nene ma ningo gelamo mino no gelosa aza veneꞌ dalosa ive nene vise lo-do ");
INSERT INTO aso_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tiꞌ lo lo-imineꞌ: Eveneꞌ nosoꞌ niteꞌ nanguꞌ nene nosoꞌ niteꞌ gizi vataꞌ igaꞌ ave mukiꞌ nete gomuꞌ nene vaini noso lamineꞌ gehepeve nene ngimikevo vaiꞌ nikevosa alingeꞌ nene vaini noso laniteꞌ amineꞌ ngimaaꞌ naha geiꞌ nene aꞌmineꞌmine ogo gomuꞌ ngemamo idise aꞌnene vaini noso lamineꞌ ma nene do sotoꞌ ogo nongemane lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Idoꞌ aꞌmine nGalilaia misubouꞌ Kana numuno ebeꞌ mininguꞌ initeꞌ ineꞌ me ve nene mo ganaꞌ apiꞌ ogosa eiꞌ Izesuꞌ monovoꞌve ngelebizo atoꞌ suno do sotoꞌ ogavo izipahala zuho nete aꞌmine amuzoꞌve nene ningi ezemuꞌ nene gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aꞌmine nosoꞌ niteꞌ ni minadotiꞌ nene Izesuꞌ aza izelehosi nakunolomotesi idoꞌ izipahala zuhosi Kahanaumi numuda limi vi mini gamene ngomosiꞌ ma ingi moni minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Idoꞌ engiꞌ avoꞌningine Oꞌmosoꞌmo iseꞌine izingumuꞌ gili Zuda ve holiseꞌ mini nosoꞌ niteꞌ nalizaniꞌ gamene nene noalitivo Izesuꞌ nene Zelusalemi numuda dizo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dizo vo monoꞌ numuno nabaꞌmi gesi minguꞌ dizo ningineꞌ nene eveneꞌ nete bulumakaꞌ izesi idoꞌ nama viluso neꞌminesi nene Oꞌmoso lehizi-dilizangumuꞌ meni hizilizaniꞌ ve li maketi nimilavo idoꞌ Oꞌmoso lehizi-dilizaniꞌ moni senisimi igaꞌ ave nesi nene gonoꞌine di nizavo ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ningosa Izesuꞌ aza naladunuꞌ ngebelelineꞌ gavoso ma loloꞌ ogo monoꞌ numuno nabaꞌmi gesi mingutiꞌ nene sipisipi izeꞌinesi bulumakaꞌinesi mukitoꞌ nene ngeleto do hulo heta ogo moni senisimi igi minaveti holomo nene do velepeꞌ izo moniꞌine nene do tululu lo hulo misuboloꞌ o-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Neꞌmine ogo nama viluso neꞌmine maketi mili minave nene tiꞌ lo lo-ngidineꞌ ve: Lingine meꞌnehi numuno mene maketi numuno neꞌmine loloꞌ i-di minaniꞌ nene huli aꞌmine initeꞌ mukiꞌ nene di heta vilo lo lo-ngidineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Neꞌmine ogavo izipahala zuho nene Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa liveꞌmi gamazi monoꞌ godolouꞌ tiꞌ li gizikaniꞌ mamuꞌ nene gohi gilaniꞌ: Geiꞌ numunga nene di goloso amavo lamineꞌ minelive lo neniꞌ luꞌne nene oto ngilingiliꞌ ogovoꞌ minaaꞌ neineꞌ nenako neꞌmino minelodiꞌmo initeꞌ mamukisi gele minamolosuve. ");
INSERT INTO aso_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Idoꞌ Izesuꞌ neꞌmino ngeleto do hulineꞌ nemuꞌ nene Zuda veti eveneꞌ nabaꞌine nete tiꞌ li li-imaniꞌ: Oꞌmosoꞌmo neꞌmine iline lo gele gimineꞌ nene lelebizo atoꞌ suno nene naniꞌmine initeꞌ do sotoꞌ iline. ");
INSERT INTO aso_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ do velepeꞌ izo tiꞌ lo lineꞌ: Monoꞌ numuno mene bili di goloso ikevo gamene sitohamo ogo novivo naza gohi do otelesuve. ");
INSERT INTO aso_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Neꞌmine lavo Zuda veti eveneꞌ nabaꞌine nete aꞌmidoꞌ tiꞌ li li-imaniꞌ: Monoꞌ numuno me ve nene giziviꞌ giziviꞌ igi nizavo kilisimasi foti sigisi (46) ogo novineꞌ nene gaza gamene sitohamo neꞌmi lulouꞌ nene gohi do otelesuve nolabe. ");
INSERT INTO aso_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Neꞌmine laniꞌza aza nene eiꞌ okoꞌnomuꞌ monoꞌ numunoloꞌ lo molo lineꞌ nenako ");
INSERT INTO aso_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","nemuꞌ nene alingeꞌ hilingutiꞌ otavosa izipahala zuho neꞌmine lingumuꞌ nene gohi gili mini monoꞌ godolouꞌ minineꞌ gamazisi idoꞌ Izesuꞌ lineꞌ gamazi nesi nene gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aꞌmine avoꞌningine Oꞌmosoꞌmo iseꞌine izingumuꞌ gili holiseꞌ mini nosoꞌ niteꞌ ni minaniꞌ gameneuꞌ nene Izesuꞌ aza Zelusalemi numuno ebekuꞌ mininguꞌ nene eveneꞌ linge mukiꞌ neꞌminete atoꞌ suno daniꞌ nene ningi ezemuꞌ gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Ezemuꞌ gili eleꞌvoleꞌ aniꞌza Izesuꞌ aza luteuꞌ minaaꞌ neineꞌ initeꞌ nemuꞌ nene ningo gelo osuꞌ lo mino eveneꞌ maliꞌmosi aꞌmine eveneꞌ monovotemuꞌ li sotoꞌ igi li-imilizadoꞌ lisiheꞌ amaniꞌ nene aza eveneꞌ mukiliti monovote ningo gele osuꞌ lo neineꞌ nenako nemuꞌ nene gele mino aꞌmine gili eleꞌvoleꞌ i-daniꞌ aleve ingine ezemuꞌ gili eleꞌvoleꞌ adoꞌ nene aza engikumuꞌ gilivo muꞌmusiꞌ amineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Idoꞌ ve ma minineꞌ gulive Nikodemoꞌ nene Halisaioꞌ monoꞌ laaꞌ aveutiꞌ mino Zuda veti kanisoleliti muliseutiꞌ ve mino ve naba neꞌmine minineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aꞌmine ve nene Izesuꞌ neida holukaꞌ ogo hetelo tiꞌ lo lineꞌ ve: Tisazo, gaza atoꞌ suno do sotoꞌ ogaꞌ naineꞌ neꞌmine nene ve maliꞌmo Oꞌmoso ezesi mino hize eleꞌ o-damivo nene ngelo ma do sotoꞌ amoloseinako nemuꞌ laza geikumuꞌ nene Oꞌmosoꞌmo tisaꞌ gono daline lo gimiselive ma ne nane losa gele none. ");
INSERT INTO aso_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ: Naza mo laminetoꞌ gehepeve tiꞌ lo nolo-gimuve: Eveneꞌ ma ingine Oꞌmosolatiꞌ gohi sotoꞌ amilizaniꞌ nene Oꞌmosoꞌmo gizebo o neinguꞌ nene mo kekeꞌ vi hilami ma ningamilisave. ");
INSERT INTO aso_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Neꞌmine lavo Nikodemoꞌ tiꞌ lo lo-imineꞌ: Eveneꞌ lodive ikeniꞌ nete gohi nadisa sotoꞌ ilizave. Izeꞌningi muluꞌninguꞌ nene gohi visa ngeli ma sotoꞌ amilisave. ");
INSERT INTO aso_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Naza mo laminetoꞌ gehepeve tiꞌ lo nolo-gimuve: Ve ma nosolatiꞌ sotoꞌ igisa Oꞌmosoꞌmi Sikalahutatikisi sotoꞌ amilizave ingine nene Oꞌmosoꞌmo gizebo o neinguꞌ nene mo kekeꞌ vi hilamilisave. ");
INSERT INTO aso_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Eveneꞌ okodeutiꞌ sotoꞌ ogaꞌ neineꞌ initeꞌ nene mo okode neꞌminevoꞌ sotoꞌ ogaꞌ neive. Idoꞌ Sikalahutatiꞌ sotoꞌ ogaꞌ neineꞌ initeꞌ nene mo Sikalahuliꞌmi emeni damenisivoꞌ nene sotoꞌ ogo minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naza Oꞌmosolatiꞌ gohi sotoꞌ ilizadoꞌ o neive noluvoniꞌ nemuꞌ nene upuhoꞌ ogo gaka mukiꞌ gelamozo. ");
INSERT INTO aso_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hepeꞌ neꞌmo huhu lo ma volosa gilida nene vaaꞌ neive. Novivo gugu lo vilineꞌ nene ha gelelesaineꞌza nelatiꞌ ogosa nela novive lo ngelo ningo gelamolosane. Aꞌmineꞌmine ogosa Sikalahutatiꞌ sotoꞌ ave nene sotoꞌ aniꞌ aka ne ningamii igi mili igaꞌ naniꞌ initekovoꞌ ningaaꞌ naniꞌ nenako aꞌmine hepeꞌ neꞌminisa nizave. ");
INSERT INTO aso_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Neꞌmine lavo Nikodemoꞌ aza aꞌmidoꞌ do velepeꞌ izo tiꞌ lo longoꞌ o-dineꞌ: Gaza nolaineꞌ initeꞌ me ve nadiꞌ ogosa sotoꞌ ilingumuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Neꞌmino longoꞌ o-davo Izesuꞌ tiꞌ lo lo-dineꞌ: Geiꞌ nene Isilaeleꞌ aleve gozopotiꞌ monoꞌ apize ngemeꞌmo ogo minaaꞌ anive ma nene naineꞌza mene initekumuꞌ nene mo gelamaneꞌ neive. Olo. ");
INSERT INTO aso_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naza laminetoꞌ gehepeve tiꞌ lo nolo-gimuve: Laza gamazi laaꞌ nouneꞌ nene mo gele minuneꞌ initekumukovoꞌ laaꞌ noune. Idoꞌ laza lo sotoꞌ sotoꞌ ogaꞌ nouneꞌ initeꞌ nene mo ningo gele noneꞌ initekumukovoꞌ nene laaꞌ noune. Neꞌmine ogaꞌ nouneꞌza lingine nene aꞌmidoꞌ ma gili limisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Misubouꞌ initetoꞌ lo molo lo-lengemaaꞌ uvoniꞌ initekumuꞌ nene gili eleꞌvoleꞌ isaꞌmaniꞌ nenako Okulumoꞌ initetoꞌ lo molo lo-lengemeloniꞌ nene nadisa gili eleꞌvoleꞌ ilizave. nGeli ma gili eleꞌvoleꞌ amilisave. ");
INSERT INTO aso_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Idoꞌ Okulumokuꞌ nene eveneꞌ hamolitesi ma dizi vi ningamave. Ma vi ningamaniꞌza Okulumokutiꞌ limuve Oꞌmosolatiꞌ ve gihile nenikovoꞌ nene aꞌmida mino ninge nouve. ");
INSERT INTO aso_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Idoꞌ Moseꞌ Isilaeleꞌ aleve ebeꞌ hadiveuꞌ ngeleꞌmizo moninguꞌ nene gosihelite ngibilikaꞌ ngibilikaꞌ navo Moseꞌ aza gosiheꞌ neꞌmi avazahaloꞌ ma loloꞌ ogo za posiloꞌ do otineꞌ nene aꞌmine gosihetoꞌ ningilizave nene hilami veꞌine gizi minilizave losa neꞌmine ineꞌ ve. Idoꞌ neꞌmine ineꞌ neꞌmini Oꞌmosolatiꞌ ve gihile nenikumuꞌ gili eleꞌvoleꞌ ilizave ingine nene minevoꞌ minevoꞌ ngemeni damenisi minilizave losa nenikisi nene aꞌmineꞌmine igi zaloꞌ di oti-nidilizaniꞌ o neive lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Idoꞌ Izesuꞌ neꞌmine lineꞌ nene nemuꞌ lineꞌ ve: Oꞌmosoꞌmo me misubouꞌ ve lulo limineꞌ nene atoliꞌmine goloso ogosa lulo limidiꞌmo eiꞌ gipele nene mo hamoꞌ gehepeve minineꞌza ve ma ingine eikumuꞌ gili eleꞌvoleꞌ ilizave nene vi tolovo ami minevoꞌ minevoꞌ ngemeni dameni dalisave losa aꞌmine gipele hamoꞌ nene lehize-lidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Idoꞌ Oꞌmosoꞌmo aꞌmine gipele me misubouko imiselineꞌ nene me misubouko aleve leliꞌ nene goniꞌ o-ledo lihime lemelive losa imiselineꞌ nevoba asi me misubouꞌ aleve leliꞌ nene do luꞌ izelingumuꞌ ve losa imiselineꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Idoꞌ ve ma ingine ezemuꞌ gili eleꞌvoleꞌ ilizave nene Oꞌmosoꞌmo lihime ngemamoloseineꞌza ma gili imamilizave nene Oꞌmosoꞌmi gipele hamoꞌ ma ne neive li gili imami ezemuꞌ gili eleꞌvoleꞌ ami haza minaniꞌ nenako nemuꞌ nene Oꞌmosoꞌmo goniꞌine nene gomukutiꞌ gele osuꞌ lo neineꞌ nenako lihime mo ngemelidoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Idoꞌ lihime ngemelineꞌ monovo nene neꞌminemuꞌ ngemeleseive: Labanaliꞌmi meleho nene me misubouko oganiꞌza me misubouꞌ aleve ingine nene monovo golosovoꞌ igi mili minadiꞌmo labanaliꞌmi lulouꞌ minaakumuꞌ goseleꞌ ngebelavo litiꞌmusouꞌ minaakumuꞌ ngumo helaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Eveneꞌ mukiꞌ monovo goloso daaꞌ nave nene aꞌmine monovo golosote nene labanaliꞌmo do sotoꞌ ogalive li labanaꞌ nene meheꞌine imisa labanaliꞌmi lulouꞌ nene imi hilisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Neꞌmine isaꞌmaniꞌza monovo gihile laminekovoꞌ igi mili minaaꞌ nave mukiꞌ ingine ogo molo ogaꞌ nouneꞌ initeꞌ mukiꞌ nene Oꞌmosoꞌmovoꞌ hize eleꞌ o-lidivosavoꞌ ogo molo ogaꞌ nouneꞌ nenako aꞌmine nene sotoꞌ ilive li labanaliꞌmi lulouꞌ imi hilaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nelotiꞌ nene Izesuꞌ aza izipahala zuhosi Zudaia misubouko vi mini eveneꞌ monoꞌ noso holo-ngedeꞌmo vo minivo minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Idoꞌ Zohaneꞌ nene noso vaiꞌ minida Salemi numuno ebeꞌ avita minineꞌ ebeꞌ Ainoni nela nene azasi noso holo-ngedeꞌmo vo neivo eveneꞌ nene ezela igi noso hilikaꞌ hilikaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Neꞌmine aniꞌ nene Zohaneꞌni nene Helodeꞌ aza olihe galapuso numunguꞌ hulo-damivosa neꞌmine aniꞌ ve.) ");
INSERT INTO aso_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Idoꞌ neꞌmini noso hili-ngidiꞌmi vi nizasivo Zohaneꞌ izipahala zuhosi idoꞌ Zuda ve masi noso holaakumuꞌ gamazidunuꞌ lovo aniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Neꞌmine igisa Zohaneꞌ izipahala zuho ingine Zohaneꞌ neida vi tiꞌ li li-imaniꞌ ve: Tisazo, Zodani noso hela holela nanivo ve ma geikisi neivo eze monovomuꞌ lo sotoꞌ sotoꞌ abe. Aꞌmine ve maꞌmo nene eveneꞌ noso noholo-ngidivo eveneꞌ vaiꞌ goloso nene ezela nivave. ");
INSERT INTO aso_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Neꞌmine likevo Zohaneꞌ aza aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Okulumokuꞌ minive Oꞌmoso neꞌmo eveneꞌ ma lehize-damo nolineꞌ initeꞌ nene asiꞌvelatiꞌ amuzo molo ngelo damoloseive. ");
INSERT INTO aso_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Naza tiꞌ lo luvoniꞌ gamazi ma nene langisetine mo gili nizave: Naza nene Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ma ne nomuvoniꞌza asi Oꞌmosoꞌmo ha gomuꞌ molo-deline lo nimiselive ma ne nouve luvoniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Idoꞌ izeni ikaniꞌ veneꞌ nene mo vanahidokovoꞌ vaaꞌ neineꞌza veneliꞌmi vanahi zuho neꞌmo aꞌmine venetoꞌ nene gizebo o-do neivo ogo elenahine do vilineꞌ nene gizebo o-do minelive aza izeboloꞌ molamoloseive. Asi elenahine dalosa ogo vise lilineꞌ noloꞌve gelelineꞌ nene olize izeleseive. Aꞌmineꞌmine ogo eveneꞌ nete neniꞌ huli-nidi Izesuda nivangumuꞌ nene naza nolize izo nouvo luꞌneuꞌ nene gulumo lise osuꞌ nolive. ");
INSERT INTO aso_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aꞌmine ve nene mineꞌmo dizovoꞌ neivo naza nene mineꞌmo lemo mineloniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Veletatiꞌ limive neꞌmo nene eveneꞌ mukiꞌ livileꞌ ogo dizo minive neive. Idoꞌ ve ma misuboukotiꞌ mene sotoꞌ ive nene misuboukotiꞌ monovovoꞌ ogo molo mino misubouko initekumukovoꞌ nene laaꞌ neive. Okulumokutiꞌ limive eveneꞌ mukiꞌ livileꞌ ogo dizo minive neꞌmo nene ");
INSERT INTO aso_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ningaaꞌ neineꞌ initekumukisi idoꞌ gelaaꞌ neineꞌ initekumukisivoꞌ lo sotoꞌ ogaꞌ neineꞌza aꞌmidoꞌ nene ma gili imisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Ne neiha Oꞌmoso neꞌmo eiꞌ Sikalahuꞌve emaaꞌ neineꞌ nene apa niteꞌ ogo emamo mo eme osuꞌ laaꞌ neineꞌ nenako nemuꞌ nene aꞌmine Oꞌmosoꞌmo imiselive nene Oꞌmosoꞌmi gamazi gihilevoꞌ laaꞌ neive. Nemuꞌ nene aꞌmine lo sotoꞌ ogaꞌ neineꞌ initetoꞌ gili imaaꞌ nave ingine gili imaaꞌ nadiꞌmo nene Oꞌmosoꞌmo gamazi gihile laminekovoꞌ laaꞌ neive li aꞌmine gamazi nene hize eleꞌ igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Meleho neꞌmo nene gipele lulo eme osuꞌ lo mino initeꞌ mataꞌ nene eiꞌ anauꞌ molo osuꞌ lo neive. ");
INSERT INTO aso_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Idoꞌ gipelemuꞌ gili eleꞌvoleꞌ igaꞌ nave mukiꞌ nete nene minevoꞌ minevoꞌ ngemeni dameni nene mo di nizaha ve ma ingine aꞌmine gipelemuꞌ gili eleꞌvoleꞌ ami gamaziꞌve gili hulaaꞌ ilizave nete nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene ma di ningamilisave. Neꞌmine ilisaniꞌza engikumuꞌ Oꞌmosoꞌmo izeboloꞌ sotoꞌ ineꞌ nene mo engita mine molosa mine do novive. ");
INSERT INTO aso_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Izesuꞌ nene Zohaneꞌ eveneꞌ do giꞌmizo noso holo-ngidineꞌ nene ivileꞌ ivosa eitoꞌ nene eveneꞌ vaiꞌ goloso do giꞌmizo noso holo-ngedeꞌmo vo neivo Halisaioꞌ monoꞌ laaꞌ ave ingine aꞌminemuꞌ gilangumuꞌ nene Izesuꞌ gelosa ");
INSERT INTO aso_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","3","Zudaia misubo hulo nGalilaia misubola volosa vineꞌ. Aꞌmine Izesuꞌ eveneꞌ do giꞌmizo noso holo-ngidineꞌ nene asiꞌve Izesuꞌ holo-ngidineꞌ nevoba asi izipahala zuho nete ezeloꞌ medeli mini noso hili-ngidaniꞌ nemuꞌ luve. ");
INSERT INTO aso_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Izesule nene nGalilaia misubouꞌ vi hetelilisa Samalia misubouꞌ vi hilisa vilizaniꞌ o neivosa aꞌminguꞌ vi hili vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aꞌminguꞌ vilizaniꞌ o neivosa vanguꞌ nene Zakoboꞌ gipele Zoseheꞌni imineꞌ misubo minidoꞌ avita Samalia aleveti numuno ebeꞌ ma Sekemi nela igi hetelaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aꞌmida nene avoteho Zakoboꞌ galese elo noso do sotoꞌ ineꞌ nene neivo Izesuꞌ aza aka haꞌna haꞌnatiꞌ ogo abusolo elavo gamene tuvelu (12) kiloku neꞌmidoꞌ nene aꞌmine noso engetineꞌ gahevela nene mitoꞌ minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Neivo Samalia veneꞌ maliꞌmo noso ohizelesa navo Izesuꞌ tiꞌ lo lo-imineꞌ: Nosomuꞌ nonisize. Noso ma ohize nemezo lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nosomuꞌ vokuꞌ lo-dineꞌ nene izipahala zuho ingine nosoꞌ niteꞌ meni hizi di alisa Sekemi numuno ebekuꞌ vikevosa lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Idoꞌ Samalia alevesi Zuda alevesi hamoꞌ lapeseuꞌ mo kekeꞌ ma nisaꞌmaniꞌ nenako Izesuꞌ neꞌmine lo vokuꞌ lavo Samalia veneꞌ neꞌmo tiꞌ lo lineꞌ: Gaza Zuda ve minanidike neniꞌ Samalia veneꞌ nene nosomuꞌ vokuꞌ nanimuꞌ nolo-nedane. ");
INSERT INTO aso_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gaza Oꞌmosoꞌmo lehize-lengedaaꞌ neineꞌ initekumukisi idoꞌ nosomuꞌ vokuꞌ lo-giduve neniꞌ monovoꞌne nemukisi nene ma ningo gele minaineꞌ neidiniko gaza vokuꞌ laanivo naza nene noso hinipinikutiꞌ dizaaꞌ neineꞌ noso minevoꞌ minevoliꞌmi izelehosi minineꞌ noso nene gimuvodine. ");
INSERT INTO aso_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Neꞌmine lavo veneꞌ aza tiꞌ lo lo-imineꞌ: Ve melo, gaza noso ohizaaꞌ initeka nene ma do minamaneꞌ nenako idoꞌ galeseuꞌ noso nesi nene homiuꞌ goloso neineꞌ nenako gaza aꞌmine hinipinikutiꞌ minineꞌ noso nemelove laineꞌ nene zaukotiꞌ do nemelesa lane. ");
INSERT INTO aso_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Leliꞌ avoteho Zakoboꞌ neꞌmo galese mene elo noso do sotoꞌ ogosa azasi idoꞌ izipahalasi idoꞌ ato atoꞌ izeꞌvesi mukitoꞌ ingine aꞌmingutiꞌ nene noso ni minaniꞌ ve. Idoꞌ gaza nene aꞌmine noso do sotoꞌ o-lidive avoteho Zakoboꞌni nene ivileꞌ o nabe. ");
INSERT INTO aso_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Neꞌmine lavo Izesuꞌ aza aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Mene galeseutiꞌ noso nalizave nene gohi nosomuꞌ ngisivo nikaꞌ nikaꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Neꞌmine ilisaniꞌza neniꞌ ngemeloniꞌ noso nalizave nene gohi aꞌminemuꞌ ngisamivo mini di dizi nizavo aꞌmine ngemeloniꞌ noso minevoꞌ minevoꞌ ogaliꞌmi izeleho neꞌmo engiꞌ luꞌninguꞌ nene hinipiniꞌ neꞌmino dizo mineleseive. ");
INSERT INTO aso_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Neꞌmine lavo veneꞌ aza tiꞌ lo lineꞌ: Ve melo, gaza nolaineꞌ noso nene naza nosa nosomuꞌ gohi nisamivo mela noso ohizelesa ogaꞌ nouvoniꞌ nene gohi amolongisi aꞌmine noso nene ma nemevo. ");
INSERT INTO aso_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Neꞌmine lavo Izesuꞌ aza tiꞌ lo lo-imineꞌ: Gaza vo vangahine vise lo-danivo alizo. ");
INSERT INTO aso_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Neꞌmine lavo veneꞌ aza tiꞌ lo lineꞌ: Naza nene vaꞌneho ma nomive. Lavo Izesuꞌ tiꞌ lo lineꞌ: Gaza vaꞌneho nomive laineꞌ nene mo laminetoꞌ laane. ");
INSERT INTO aso_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nanitekumuꞌ ve. Gomuꞌ nene ve faefuloꞌ vaanivo vangamote liliꞌ aniꞌza idise veloꞌ vo naneꞌ nene aka lamineꞌ avutoꞌ ogosa gopo vo naneꞌ neꞌmo nene geiꞌ vangaho gihile loloꞌ amivo gopo ingaaꞌ nasineꞌ nenako nemuꞌ nene vaꞌneho nomive laineꞌ nene mo laminetoꞌ laane. ");
INSERT INTO aso_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Neꞌmine lavo veneꞌ aza Izesuꞌnimuꞌ tiꞌ lo lineꞌ: Ve nabo, naza ningo giluvoniꞌ geiꞌ nene mo polohete nane lo ningekuve. ");
INSERT INTO aso_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nemuꞌ nene Samalia aleve leliꞌ avotemote ingine Gelazimi gololoꞌ mene dizi Oꞌmoso opoꞌni laaꞌ aniꞌza Zuda ve lingine Zelusalemi numuno ebeꞌ neevoꞌ nene Oꞌmoso opoꞌni laaꞌ ebeꞌ neive li laaꞌ naniꞌ nenako mo laminetoꞌ laaꞌ aniꞌ nehe nemuꞌ nene lo-nemezo. ");
INSERT INTO aso_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ: Alungoo, naza lo-gemeloniꞌ gamazi nene gelezo. Gamene ma sotoꞌ ilineꞌ nene me gololokisi Zelusalemi numuno ebekukisi nene metehine Oꞌmoso opoꞌni lamiliza gamene ma sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lingine Samalia aleve Oꞌmoso opoꞌni laaꞌ naniꞌ nene eze monovomuꞌ nene ma ningi gilamisa opoꞌni laaꞌ nave. Neꞌmine igaꞌ naniꞌza Oꞌmosoꞌmo eveneꞌ do luꞌ izelineꞌ aka nene leliꞌ Zuda velatiꞌ sotoꞌ ineꞌ nenako Zuda ve leliꞌ nene eze monovo ningo gele minosavoꞌ opoꞌni laaꞌ nene noune. ");
INSERT INTO aso_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gamene ma alineꞌ o minineꞌ gamene idise mo oganguꞌ mene luꞌine laminetotiꞌ Oꞌmoso opoꞌni laaꞌ ave ingine eiꞌ Sikalahuꞌve neꞌmo ngelebizelineꞌ monovo gihilelotikovoꞌ nene opoꞌni lilizave. Neꞌmine noluvoniꞌ nene meꞌneho Oꞌmoso aza aꞌmine neꞌmine monovolotiꞌ opoꞌni lilizavemuꞌ nene viseꞌ ogo minaaꞌ neineꞌ nenako nemuꞌ ne luve. ");
INSERT INTO aso_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Oꞌmosoꞌmi emeni dameni nene Sikalahuꞌ neꞌmine neineꞌ nenako eiꞌ Oꞌmoso opoꞌni lilizave nete eiꞌ Sikalahuꞌve neꞌmo ngelebizelineꞌ monovo gihilelotikovoꞌ nene opoꞌni lilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Neꞌmine lavo veneꞌ aza tiꞌ lo lo-imineꞌ: Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ve lave nene mo aloseive likevosa naza nene mo aloseive lo gele nouve. Aza ogo initeꞌ mukikumuꞌ nene lo sotoꞌ ogo lo-lemeleseive. ");
INSERT INTO aso_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gamazi nolo-gimuve neniꞌ nene aꞌmine ve ne nouve. ");
INSERT INTO aso_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Neꞌmine nolivo izipahala zuho ingine nosoꞌ nitetoꞌ vadotiꞌ tineꞌ mili igi heteli ninganiꞌ nene veneꞌ masi gamazi li minasineꞌ ningi gopo gaꞌine gilaniꞌ. Gopo gaꞌine gilaniꞌza izipahala zuho ingine engikumuꞌ nene gaza nani dalosa nane idoꞌ veneꞌ mene nanitekumuꞌ gamazi nolo-emane li aꞌneꞌmine igi longoꞌ hamokisi ma i-damaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Neꞌmine igi nizavo veneꞌ aza noso gomiseꞌve nene aꞌmida huloko aꞌmine Sekemi numuno ebekuꞌ vo eveneꞌ tiꞌ lo lo-ngimineꞌ: ");
INSERT INTO aso_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Lingine ve ma neniꞌ ogo molo ogaꞌ uvoniꞌ monovo mukiꞌ lo sotoꞌ o-nidive nene ningilizaze. Alo. Aza nene Oꞌmosoꞌmo do luꞌ izelesa kegese-dive Kilisitoꞌ nehe lo gaꞌne sitaꞌ nogiluze. Igi ningiꞌ nalo. ");
INSERT INTO aso_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Neꞌmine lavo eveneꞌ taunilatiꞌ nene Izesuꞌ neida vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Neꞌmine navo izipahala zuho Izesuꞌni tiꞌ li geligelinga li-daniꞌ: Tisazo, nosoꞌ niteꞌ mene do novo li-di minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Neꞌmine aniꞌza aza tiꞌ lo lo-ngimineꞌ: Neniꞌ naloniꞌ nosoꞌ niteꞌne ma neineꞌ nene lingine ma ningi gilamave. ");
INSERT INTO aso_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Neꞌmine lavo izipahala zuho engikuꞌ tiꞌ li li voleloꞌ meloꞌ igi minaniꞌ: Nosoꞌ niteꞌ ma di-di amahe. Olo. ");
INSERT INTO aso_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Neniꞌ nosoꞌ niteꞌne nene nimiselive eiꞌ luloloꞌ initeꞌ ogo molo mino nimineꞌ gonoꞌve do peleloniꞌ neve nene nosoꞌ niteꞌne ve. ");
INSERT INTO aso_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lingine tiꞌ li laaꞌ nave: Ikeꞌni sitaꞌ ve sitaꞌ ve ogo vavosa nosoꞌ niteꞌ dolizelone. Neꞌmine laaꞌ naniꞌza naza tiꞌ lo nolo-lingimuve. Ningiꞌ nalo. Minguꞌ akaꞌmene mo minamuno dolizaatoꞌ vave. Eveneꞌ nenita alisa di nene igi minikeve. ");
INSERT INTO aso_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Zuho niteꞌ zuhoꞌ avesi idoꞌ nosoꞌ niteꞌ dolizavesi makatokovoꞌ ngolize izilizave lisa minamuno dolizaaꞌ nave ingine meniꞌine mo nidi gonoꞌineꞌmi gihile nene eveneꞌ ingine minevo minevoꞌ ngemeni dameni nene dalizave li di nubo nii-ngidave. ");
INSERT INTO aso_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Neꞌmine naniꞌ neꞌmo nene evenelite tiꞌ li laaꞌ naniꞌ gamazi ma nene mo gihile izave: Ve malite zuhoꞌ aniꞌ initeꞌ nene ve atolite dolizaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lingine zuhoꞌ igi gono damaniꞌ minguꞌ nene vi mine dolizilizave lo lingimiselekuvo ve atolite daniꞌ gonoꞌmi gihile ma nene dalisa nave. ");
INSERT INTO aso_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aꞌmine Sekemi numuno ebetotiꞌ Samalia ve mukiꞌ neꞌminete veneꞌ neꞌmo neniꞌ ogo molo ogaꞌ uvoniꞌ monovo mukiꞌ ma nene lo sotoꞌ o-nidave lo lineꞌ gamazi nene giladiꞌmo nene Izesuꞌnimuꞌ gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Idoꞌ ezemuꞌ gili eleꞌvoleꞌ aniꞌ nenako nemuꞌ nene ezela igi hetelisa engikisi makaꞌ minelive li amuzonga li-dikevo aza gamene sitaꞌ engikisi makaꞌ ma minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Neꞌmine ogo gamazi lo-ngimineꞌ gamaziꞌve giladiꞌmo eveneꞌ gohi vaiꞌ neꞌmine nete imineꞌ mili ezemuꞌ gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Neꞌmine igi veneꞌ nene tiꞌ li li-imaniꞌ: Ezemuꞌ gele eleꞌvoleꞌ uneꞌ nene gomuꞌ geiꞌ gamazi lanidotiꞌ gele eleꞌvoleꞌ uneꞌza idise asiꞌve lineꞌ gamazi giluneꞌ neꞌmo nene gele eleꞌvoleꞌ gehepeve ogosa laza aꞌmine me vemuꞌ giluneꞌ nene misubouko aleve mukiꞌ leliꞌ nene do luꞌ izeleseive lave ma nene mo laminetoꞌ eiꞌ nene neive losa gelekune. ");
INSERT INTO aso_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Asiꞌve Izesuꞌ gomuꞌ lineꞌ gamazi ma neꞌmino neive: Polohete nene engiꞌ numuꞌine ebeꞌinelotiꞌ aleve nete nene gili ngimami di nabasi ma i-ngidisaꞌmave. Idoꞌ aꞌmineꞌmine igi eiꞌ misuboꞌveuꞌ aleve nene eze gili imami di naba i-damilizaniꞌ o neineꞌ nenako nemuꞌ nene aza Sekemi alevesi minelineꞌ gamene sitaꞌ nene mo osuꞌ lavo aꞌmine numuno ebeꞌ nene hulo aꞌmine misuboꞌve nGalilaia misubouko vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Neꞌmino ma nenako nGalilaia aleve ma Zelusalemi numuda holiseꞌ mini nosoꞌ niteꞌ ni minada inginesi vi minaniꞌ nenako aꞌmida Izesuꞌ ogo molo minineꞌ initeꞌ nene ninganiꞌ nenako nemuꞌ nene Izesuꞌ nGalilaia misubouko ogo nohetelivo eleꞌmizi lamineꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Neꞌmine ikevo Izesuꞌ aza nGalilaia misubouꞌ numuno ebeꞌ ma Kana neuꞌ gomuꞌ haza nosodunuꞌ vaini noso loloꞌ ineꞌ numuno ebeta nene gohi vineꞌ ve. Aꞌmida vo neivo Kahanaumi numuno ebekuꞌ nene guvelesi ve maliꞌmi gonouꞌ ve naba ma minineꞌ. Aꞌmine veꞌmi gipele nene initeꞌ gize do minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Neꞌmino neivo meleho aza Izesuꞌ nene Zudaia misubo hulo nGalilaia misubouko mene tineꞌ molo ogave laniꞌ nemuꞌ nene gilineꞌ. Neꞌmine ogosa eiꞌ gipele nene mo helaatoꞌ neivo aza Izesuꞌ neida vosa Izesuꞌ lemo ogo do lamineꞌ o-delive lo amuzonga lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Neꞌmine lo-davo Izesuꞌ tiꞌ lo lo-imineꞌ: Lingine naza atoꞌ suno golize laaꞌ initeꞌ ma do sotoꞌ okuvo ningamilizaniꞌ nene nenikumuꞌ gili eleꞌvoleꞌ amilisaave. ");
INSERT INTO aso_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Lavo guvelesi veꞌmi gonouꞌ ve naba neꞌmo tiꞌ lo lo-imineꞌ: Ve nabo, gipeꞌne nene helalize. Lemo volosize. Ano. ");
INSERT INTO aso_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Gipa nene velesi ha minelize. Numungala vozo. Neꞌmine lavo aꞌmine ve nene Izesuꞌ lo-imineꞌ gamaziloꞌ nene gele eleꞌvoleꞌ ogo numuꞌvela vineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Neꞌmine ogo olihe numuꞌvela volosa akaloꞌ novivo gelekeleꞌ izipeꞌve malite akala novidoꞌ igi voteneꞌ i-di gipele vele gizingumuꞌ nene li-imaniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Neꞌmine ikevo umungive nene nani gameneloꞌ lamineꞌ gele nolihe lo aꞌminemuꞌ gelelesa longoꞌ o-ngidineꞌ. Neꞌmine ogavo ingine tiꞌ li li-imaniꞌ: Okoꞌnoloꞌ oloꞌ lineꞌ nene aizeꞌ holiseꞌ vanu kiloku neꞌmidoꞌ nene hulo-dive. ");
INSERT INTO aso_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Neꞌmine likevo izipeliꞌmi meleho gilineꞌ nene Izesukahoꞌmo gipa nene velesi ha minelive lineꞌ gameneloꞌ gehepeve nene lamineꞌ gelaniꞌ neive lo gelosa azasi eze numuꞌveuꞌ minaaꞌ aniꞌ alevesi mukitoꞌ nene Izesuꞌnimuꞌ gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Idoꞌ Izesuꞌ Zudaia misubo hulo nGalilaia misubouko tineꞌ molo ogosa atoliꞌmine suno do sotoꞌ ineꞌ meꞌmo nene atoꞌ suno nGalilaia misubouꞌ do sotoꞌ ineꞌ nene mo gamene sitaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nelotiꞌ alingeꞌ nene Zuda velite holiseꞌ mini nosoꞌ niteꞌ naaꞌ aniꞌ gamene ma alitavo Izesuꞌ nene Zelusalemi numuda vineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Idoꞌ Zelusalemi numuno ebekuꞌ sipisipi dizaaꞌ aniꞌ gateniꞌmi gahevela nene noso ohuno ma minineꞌ nene gulive Zuda veti gamaziꞌningutiꞌ Beꞌsada ve laaꞌ nave. Aꞌmida nene gehenidunuꞌ azibe faefu aꞌmine noso ohuno nene di vodo vodo i-di gizikavo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aꞌmine azibe numunguꞌ nene initeꞌ gizi daniꞌ aleve mukiꞌ, veꞌine likive, idoꞌ gizeꞌine aꞌninguꞌ gebili di minave neꞌmine nene mukiꞌ vaiꞌ minaniꞌ ve.  ");
INSERT INTO aso_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ingine aꞌmine noso ohunouꞌ nene Oꞌmosoꞌmi angeloꞌve maliꞌmo gameneloꞌ gameneloꞌ lemo ogo noso nene do moꞌmongoꞌ o-davo aꞌminguꞌ gomuꞌ limive nene gize daniꞌ initeꞌve osuꞌ lo-davo lamineꞌ gelaaꞌ ineꞌ nenako nemuꞌ nene gizebo igi ingi minaaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Engikutiꞌ ve ma ongo minineꞌ nene kilisimasi teoti eiti (38) neꞌmine initeꞌ gize do minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Neꞌmino neivo Izesuꞌ aza ningo gamene haꞌnaloꞌ initeꞌ gize do minineꞌ nemukisi nene ningo gelo tiꞌ lo longoꞌ o-dineꞌ: Gaza nene lamineꞌ olove lo gele nabe. ");
INSERT INTO aso_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Neꞌmine lavo initeꞌ gize dave aza tiꞌ lo lineꞌ: Ve melo, angeloꞌ neꞌmo noso do moꞌmongoꞌ neivo aꞌminguꞌ lemo lamineꞌ olongumuꞌ neleꞌmizi limilizave nene ma nizamavo neꞌmo neniꞌ nene zou zou lo nouvosa ve ma gomuꞌ vive neꞌmovoꞌ nene lamineꞌ ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Otezo. Oto aviliseka do geho aka vozo. ");
INSERT INTO aso_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Neꞌmine lo-davo aꞌmine ve nene aꞌmidoꞌ liteꞌ lo lamineꞌ ogosa aviliseꞌve nene do otosa aka vineꞌ ve. Aꞌmine gameneuꞌ nene holiseꞌ gamene minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nemuꞌ nene Zuda ve nete aꞌmine lamineꞌ ive nene tiꞌ li li-daniꞌ: Idise nene holiseꞌ gamene neineꞌ nenako gaza aviliseka do novaineꞌ neꞌmo nene louꞌ gamazite ma nene avutoꞌ nane. ");
INSERT INTO aso_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Neꞌmine laniꞌza aza do velepeꞌ izo tiꞌ lo lo-ngimineꞌ: Neniꞌ do lamineꞌ o-nidive asiꞌve neꞌmo aviliseka do oto vozo lo-nedavosa nene neꞌmine nouve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Neꞌmine lavo ingine tiꞌ li longoꞌ i-daniꞌ: Gaza aviliseka do oto vozo lo-gidive nene zaho ma neve. ");
INSERT INTO aso_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Neꞌmine li longoꞌ i-daniꞌza Izesuꞌ nene aꞌmida eveneꞌ mulise minanguꞌ nene gopo ogavo lamineꞌ gilive aza nene eveneꞌ neꞌmo do lamineꞌ o-nidineꞌ ve lo ma ningo gelamineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Neꞌmine ogosa aꞌmine ve nene alingeꞌ monoꞌ numuno nabauꞌ neivo Izesuꞌ ningo tiꞌ lo lo-dineꞌ: Ningezo. Gaza nene mo lamineꞌ ogange. Gomuꞌ goloso ogo minaineꞌ nene ivileꞌ ivosa goloso gehepeve ogalinge. Gaza nene lihimeka hulo gohi damozo. ");
INSERT INTO aso_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Neꞌmine lo-davosa aꞌmine ve aza vo Zuda ve nene tiꞌ lo lo-ngimineꞌ: Aꞌmine do lamineꞌ o-nidive ma nene Izesuꞌ do lamineꞌ o-nedaniꞌ neive lo lo-ngimineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Idoꞌ Izesuꞌ holiseꞌ gameneuꞌ neꞌmine gono daaꞌ ineꞌ nemuꞌ Zuda veti ve nabaꞌine nete apiꞌ igi elemi biluvaꞌ i-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Neꞌmine ikevo Izesuꞌ aza do velepeꞌ izo tiꞌ lo lo-ngimineꞌ: Meꞌneho gono doꞌmo doꞌmo ogo neineꞌ nene idisesi ha do neivo nazasi nene aꞌmineꞌmine ogo gono doꞌmo novuve. ");
INSERT INTO aso_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Neꞌmine lavo Zuda veti ve nabaꞌine nete Izesuꞌni bililiza akamuꞌ nene gohi amuzo goloso milisa viseꞌ igi minaniꞌ. Idoꞌ neꞌmine aniꞌ nene nanitekumuꞌ ve. Ingine holisekumuꞌ louꞌ milaniꞌ nene Izesuꞌ avutoꞌ ogave li neemukovoꞌ nene bililiza akamuꞌ viseꞌ igi minaniꞌ nevoba asiꞌve Izesuꞌ neꞌmo Oꞌmoso nene neniꞌ meꞌneho gehepeve ve lineꞌ neꞌmo nene eiꞌ Izesuꞌ nene Oꞌmososi do lisiheꞌ ogosa lave liisa nemukisi nene bililisa gohi nabisa amuzo milave. ");
INSERT INTO aso_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Neꞌmine navo nemuꞌ nene Izesuꞌ aza aꞌmidoꞌ do velepeꞌ izo tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ tiꞌ lo nolo-lingimuve: Meꞌneho aza naniteꞌ naniteꞌ ogo molo ilihe gipele nazasi nene aꞌmineꞌminevoꞌ ogo, ogo molo minelesuvonako nemuꞌ nene naza luꞌneloꞌ do molo initeꞌ hamokisi ngelo ma amolosuve. Asi meꞌneho ogo molo neineꞌ initekovoꞌ nene ogo molo ogaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Idoꞌ gamazi mene noluvoniꞌ nene neemuꞌ noluve. Meꞌneho aza gipele neniꞌ nene lulo neme neineꞌ nenako nemuꞌ nene aza ogo molo ogaꞌ neineꞌ initeꞌ mukiꞌ nene nelebize osuꞌ laaꞌ neive. Idoꞌ neꞌmine ogaꞌ neineꞌ nenako nemuꞌ nene lingine upuhoꞌ igi golize lilizave lo idise ogo molo nouvoniꞌ initeꞌ mene ivileꞌ ivosa atoliꞌmine suno naba goloso nelebizavo olosuve. ");
INSERT INTO aso_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ee, meꞌneho aza eveneꞌ hilave nene veꞌine gizi minilizave lo do ote-ngedaaꞌ neineꞌ neꞌmino gipele nazasi nene aꞌmineꞌmine ogo neniꞌ gaꞌne giluvoniꞌ aleve mukikumuꞌ nene gohi miniviꞌ aliviꞌ igi minilizave lokuvo gohi miniviꞌ aliviꞌ igi minaaꞌ naniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Idoꞌ naza neꞌmine olosuve lo noluvoniꞌ nene nanitekumuꞌ ve. Meꞌneho aza neve eveneꞌ monovoꞌinemuꞌ izeꞌ molo goniꞌ ma o-ngedesaꞌmo aꞌmine neꞌmine gono mukiꞌ nene gipele neniꞌ aꞌneuꞌ molo neive. ");
INSERT INTO aso_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aza neꞌmine ineꞌ nene eveneꞌ mukiꞌ ingine meꞌnehine opoꞌni li di naba i-daaꞌ naaniꞌ neꞌmine igi gipele neniꞌ nene nopoꞌni li di naba i-nidilizave losa neꞌmine ineꞌ ve. Idoꞌ gipele neniꞌ nopoꞌni li di naba i-nidamilizave nene nimiselive meꞌnehine nene opoꞌni li di naba i-disaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Naza mo laminetoꞌ tiꞌ lo nolo-lingimuve: Ve ma ingine neniꞌ gamaziꞌneloꞌ gili di mini nimiselivemuꞌ gili eleꞌvoleꞌ i-di minilizave nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene mo di tiꞌ ikeve. Aꞌmine ve ingine nene gonitoꞌ vi otami asi luꞌine hele vivo minadotiꞌ nene upuhoꞌ igi veꞌine gizikeve. ");
INSERT INTO aso_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ee, naza mo laminetoꞌ tiꞌ lo nolo-lingimuve: Gamene ma naaniꞌ nene eveneꞌ mo luꞌine helavo nizave netesi Oꞌmosoꞌmi gipele neniꞌ noꞌne nene gililisave. Aꞌmine gamene nene mo idisesi ogave. Neꞌmine oganako noꞌne gililizave mukiꞌ nene veꞌine gizilisave. ");
INSERT INTO aso_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Neꞌmine noluvoniꞌ nene nanitekumuꞌ ve. Meꞌnehi minevoꞌ alevoꞌve nene malatiꞌ damiha asiꞌve nene minevoꞌ alevoꞌ ogaliꞌmi izeleho gehepeve ma ne neive. Idoꞌ aꞌmineꞌmine ogo meꞌneho lavosa gipele nazasi nene eiꞌ neꞌmine mino minevoꞌ alevoꞌ neꞌmi izeleho gehepeve nouve. ");
INSERT INTO aso_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Idoꞌ naza nene Oꞌmosolatiꞌ eveneꞌ gihile nouvonako nemuꞌ nene naza eveneꞌ goniꞌine gelaaꞌ gono nene daline lo amuzo nemavo nouve. ");
INSERT INTO aso_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Lingine gamazi memuꞌ nene gatine gopo gilamilo. Gamene ma aliteleseive. Aꞌminguꞌ nene mati matiuꞌ minave mukiꞌ nene neniꞌ gamazi loloniꞌ noꞌne nene gili ");
INSERT INTO aso_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aꞌmingutiꞌ heta alisave. Ingine monovo lamineꞌ igi mili minave nene otisa minevoꞌ minevoꞌ igi minilisaha monovo goloso igi mili minave ingine nene otisa gonitoꞌ otikevo naza lokuvo mulumo gono dalisave. ");
INSERT INTO aso_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Idoꞌ neꞌmine oloniꞌ nene neniꞌ luꞌneloꞌ do molo initeꞌ hamokisi ngelo ma amolosuve. Asi meꞌneho lidokovoꞌ nene gelo eꞌmeto goniꞌ gelo izeꞌ molaaꞌ nouve. Idoꞌ neniꞌ luꞌneloꞌ do molo eꞌmetamo nimiseliveꞌmi luloloꞌ do molo eꞌmeto goniꞌ gelo izeꞌ molaaꞌ nouvoniꞌ nene mo lisiheꞌ gehepeve o minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Naza neniꞌ monovomuꞌ naꞌniseꞌnelatiꞌ ma lo sotoꞌ sotoꞌ ogo mineloniꞌ nene lingine soza nolihe lamineꞌ nolive. Laza gelamune li gili minilisave. ");
INSERT INTO aso_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Idoꞌ nenikumuꞌ lo sotoꞌ sotoꞌ ogaꞌ ive nene ma neinako naza eikumuꞌ giluvo nenikumuꞌ lo sotoꞌ sotoꞌ neineꞌ nene mo laminetoꞌ laaꞌ neive losa gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lingine monoꞌ noso holo-ngedaaꞌ ive Zohaneꞌ neida eveneꞌ ma vi longoꞌ i-dilizave li ngimiselikevo aza neniꞌ monovoꞌne lo sotoꞌ ogo gamazi gihilevoꞌ lo-lengemavo nigilaniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nenikumuꞌ nene Zohaneꞌ neꞌmine lineꞌza naza nene me misubouꞌ ve malite nenikumuꞌ li sotoꞌ ilizangumuꞌ ve lo engita ma gele medelesaꞌmuvoniꞌza Zohaneꞌ lineꞌ gamazimuꞌ noluvoniꞌ nene lingine aꞌmine gamazi gili eleꞌvoleꞌ ikevosa Oꞌmosoꞌmo do lunguꞌ izelive losa noluve. ");
INSERT INTO aso_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zohaneꞌ aza nene lamu ma lo lamineꞌ o mino hize labanaꞌ elo minaaꞌ neineꞌ neꞌmine mino hize labanaꞌ elo gamazi lokaꞌ lokaꞌ neivo aꞌminemuꞌ lingine gilavo lamineꞌ ogavo gamene liꞌnibemuꞌ longolize izi minaniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ne neiha Zohaneꞌ neniꞌ monovoꞌne lo sotoꞌ ineꞌ nene ivileꞌ ivosa neniꞌ monovoꞌne lo sotoꞌ ogo lengelebizaaꞌ neineꞌ initeꞌ gohi ma neive. Aꞌmine nene meꞌneho aza neꞌmine gono doꞌmo vo do peleline lo-nididoꞌ nene ato atoꞌ suno do sotoꞌ ogo gono doꞌmo vo minaaꞌ nouvoniꞌ neꞌmo nene neniꞌ monovo do sotoꞌ ogo lengelebize neivo neꞌmo nene meꞌneho Oꞌmoso neꞌmo nimiselaniꞌ neive li ningi gililizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Idoꞌ aꞌmine nimiselive meꞌneho aza nesi neniꞌ monovoꞌne nene lo sotoꞌ oganiꞌ neiha lingine eiꞌ nolo nene mo kekeꞌ gilami eiꞌ okoꞌnoloꞌ nesi nene ma ningamave. ");
INSERT INTO aso_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Idoꞌ lingine Oꞌmosoꞌmo imiselive nenikumuꞌ gili eleꞌvoleꞌ amaniꞌ neꞌmo Oꞌmosoꞌmi gamazi lengiꞌ lutinguꞌ minamineꞌ nene do sotoꞌ ogo lelebizave. ");
INSERT INTO aso_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Idoꞌ lingine monoꞌ godoloutiꞌ gamazi neꞌmo nene minevoꞌ minevoꞌ lengemeni dameni dalizaniꞌ aka nene do sotoꞌ o-ledelihe li aꞌminguꞌ amuzo mili viseꞌ igi minaaꞌ nave. Aꞌmine monoꞌ gamazi nene nenikumuꞌ lo sotoꞌ ogaꞌ neiha ");
INSERT INTO aso_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nenita minevoꞌ minevoꞌ lengemeni dameni dalone li alisa gilisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Guveꞌne vilingumuꞌ ve lo naza eveneꞌ di naba i-nidilizave lo luꞌninguꞌ hizesaꞌmuvoniꞌza ");
INSERT INTO aso_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","lengiꞌ monovotine nene mo gele nouve. Lutine nene Oꞌmoso imisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naza nene meꞌneho lavo ezeloꞌ medelosa uvoniꞌza lingine gili nimisaꞌmaha ve ma ingine meꞌneho lamivo angiseꞌine engitoꞌ medeli mini alizaniꞌ nene lingine aꞌmine ve gili ngimilisave. ");
INSERT INTO aso_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lingine nene ge do naba o-nede ne do naba o-gede li minilisa laniteꞌ gili mini igaꞌ naha Oꞌmoso eiꞌ hamoꞌ minive neꞌmo do naba o-lengedelineꞌ akaloꞌ nene eꞌmetilisa gilisaꞌmaniꞌ nenako nemuꞌ nene lingine ezemuꞌ nadisa gili eleꞌvoleꞌ ilizave. ");
INSERT INTO aso_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nenikumuꞌ nene melehida goniꞌ o-ledeleseive li gilamilo. Lengiꞌ goniꞌ o-lengedelive nene ezemuꞌ hize eleꞌ o-ledelive li gili eleꞌvoleꞌ ave Moseꞌ nene goniꞌ o-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Idoꞌ mene noluvoniꞌ nene nanitekumuꞌ ve. Moseꞌ aza nenikumuꞌ gizineꞌ nenako eiꞌ gizineꞌ gamazi nene ma gili eleꞌvoleꞌ adiniko nenikumukisi gili eleꞌvoleꞌ adine. ");
INSERT INTO aso_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gili eleꞌvoleꞌ adineꞌza eiꞌ gizineꞌ gamazi nene gili eleꞌvoleꞌ amadiꞌmo nene neniꞌ gamaziꞌne nene nadisa gili eleꞌvoleꞌ ilizave. nGeli ma gili eleꞌvoleꞌ amilisave. ");
INSERT INTO aso_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Idoꞌ nelotiꞌ nene Izesuꞌ aza minineꞌ ebeꞌ nene hulo sipiuꞌ dizo nGalilaia noso ohuno naba gulive ma Tibeliaꞌ noso ohunoloꞌ nene ledo vo helala vineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Neꞌmino novivo eveneꞌ mukiꞌ goloso nene Izesuꞌ atoꞌ suno do sotoꞌ ogo initeꞌ gizi dave do lamineꞌ o-ngididoꞌ ningadiꞌmo eꞌmeti vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Neꞌmini navo Izesuꞌ aza nene gololoꞌ ma dizo vo izipahala zuhosi mitoꞌ minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aꞌmine gameneloꞌ nene Zuda veti avoꞌninge Aigita misubouꞌ minaniꞌ gameneuꞌ Oꞌmosoꞌmo iseꞌine izingumuꞌ gili holiseꞌ mini nosoꞌ niteꞌ naaꞌ aniꞌ gamene nene mo avitoꞌ o minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Idoꞌ Izesuꞌ vokeneꞌ ogo ningineꞌ nene eveneꞌ mukiꞌ goloso eiꞌ neida navo ningo Hilipoꞌni tiꞌ lo lo-imineꞌ: Eveneꞌ mukiꞌ emesene naaniꞌ neti nosoꞌ niteꞌine nene zalatiꞌ meni hizelone. ");
INSERT INTO aso_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Izesuꞌ neꞌmine lineꞌ nene aꞌmine aleve do veꞌine molalineꞌ monovomuꞌ nene ha gele neiha ha Hilipoꞌni emenguꞌ molalosamuꞌ nene neꞌmine lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Neꞌmine lavo Hilipoꞌ aza tiꞌ lo lo-imineꞌ: Moni naba fo hadeti kina (K400) neꞌmine hulo nosoꞌ niteꞌ meni hizesoꞌ nene vo damivo ngomo lasolo pasolo nalizadoꞌ mineleseive. ");
INSERT INTO aso_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Neꞌmine lavo Izesuꞌ izipahala zuho ma Simoniꞌ Petoloꞌ akunolo Adeleaꞌ aza minosa tiꞌ lo Izesuꞌni lo-imineꞌ: ");
INSERT INTO aso_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Gipe mene balidunuꞌ loloꞌ aniꞌ sikoni faefusi idoꞌ alahaꞌ ngomo setakisi ma do neineꞌza eveneꞌ mukikuꞌ mene nadosa vo dalive. ");
INSERT INTO aso_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Neꞌmine lavo Izesuꞌ aza izipahala zuho tiꞌ lo lo-ngimineꞌ: Eveneꞌ nene mitoꞌ minilizaze. Li-ngidilo lineꞌ. Aꞌmida nene guvise lamineꞌ vaiꞌ minidoꞌ eveneꞌ nene mitoꞌ minikevo gataniꞌ nene vemohoꞌ faef tauseni (5,000) neꞌmine minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mitoꞌ minikevo Izesuꞌ aza sikoni nene do Oꞌmosola opoꞌni losa aꞌmine aleve nene ngimineꞌ. Idoꞌ aꞌmineꞌmine ogo alahakisi nene ngimineꞌ ve. Ingine nisa goseleꞌ ilizaniꞌ votigileloꞌ ngimineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mukitoꞌ gatuꞌine ogavo nizavo izipahala zuho tiꞌ lo lo-ngimineꞌ: Nosoꞌ niteꞌ linge nene labuluvo ogalize. Lumo sama nene di nubo ilo. ");
INSERT INTO aso_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Neꞌmine lavo ingine balidunuꞌ loloꞌ aniꞌ sikoni faef neꞌmi lumo sama nosoꞌ niteꞌ navete hulaniꞌ nene di nubo igi gosuvahaꞌ tuvelu goꞌzi vaiꞌ laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Idoꞌ eveneꞌ ingine Izesuꞌ atoliꞌmine suno ineꞌ nene ningi nemuꞌ tiꞌ li laniꞌ: Me ve nene polohete ma me misubouꞌ aloseive lave ma nene mo laminetoꞌ eiꞌ ne neive. ");
INSERT INTO aso_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Neꞌmine likevo Izesuꞌ aza ingine Guvetesi ve naba loloꞌ o-delone li igi analoꞌ dalisa minaniꞌ nene mo ningo gelo aꞌmine ebeꞌ nene hulo asiꞌvevoꞌ gohi golola ma dize minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Izesuꞌ golola dizo neivo nivengaꞌ nomolavo izipahala zuho ingine noso ohuno gahevela limi heteli ");
INSERT INTO aso_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","sipiuꞌ dizi Kahanaumi numuno noso helala minida nene vilisa vaniꞌ. Nivavo litiꞌmuso nene mo izineꞌza Izesuꞌ nene olihe engita ogo giꞌmizamineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Giꞌmizamivo haza nivavo hepeꞌ nene amuzo malehe goloso noilivo noso nene amuzo molo siiꞌ naba goloso olosa ineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Neꞌmine neivo ingine 5, 6 kilomita (3, 4 maili) neꞌmine sipiuꞌ nivi Izesuꞌ nene noso avileloꞌ lise lise navo ningi ngehelele izavo golise goloso gilaniꞌza ");
INSERT INTO aso_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","aza tiꞌ lo lo-ngimineꞌ: Neniꞌ ma ne nouze. Golise gilamilo. ");
INSERT INTO aso_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Neꞌmine lavo ingine sipiuꞌ dizelive li gili niimavo aꞌmidoꞌ liteꞌ lo sipi nene mo aꞌmine vilisa gilaniꞌ ebeta noso gahevela nene hetele minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gohi goꞌ lavo noso ohuno helala aizetiꞌ ha minaniꞌ aleve mukiꞌ nete ningi gilaniꞌ nene aꞌmida sipi hamokovoꞌ minineꞌ vinguꞌ nene Izesuꞌ aza izipahala zuhosi aꞌminguꞌ dizamivo izipahala zuho engikovoꞌ vi nizave lisa gili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Neꞌmine igi nizavo aꞌmine Izesuꞌ Oꞌmosola opoꞌni lo nosoꞌ niteꞌ do veꞌine molavo ni minaniꞌ ebeꞌ avita nene Tibeliaꞌ numuno ebekutiꞌ sipi ma igi heteli minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Minikevo eveneꞌ mukiꞌ aꞌmine ebeta ninganiꞌ Izesuꞌ nene nomivo idoꞌ izipahala zuhosi nizamavo ningi aꞌmine imi minaniꞌ sipiuꞌ nene dizi Kahanaumi numuda Izesuꞌnimuꞌ visetoꞌ vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Neꞌmine igi noso ohuno helala vi Izesuꞌni nene ningi tiꞌ li li-imaniꞌ: Tisazo, gaza mela aineꞌ nene naniheꞌ neve. Sipiuꞌ amaneꞌ nenako misubouꞌ nene gaza nadosa geto ogo hetelane laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Neꞌmine likevo Izesuꞌ aza aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ gehepeve tiꞌ lo nolo-lingiduve: Lingine nenikumuꞌ viseꞌ naniꞌ nene atoꞌ suno duvoniꞌ neꞌmi monovo ningangumuꞌ viseꞌ navoba asi gaꞌnamuꞌ nolingisidoꞌ do vetine molokuvo gatudine ineꞌ mamuꞌ nene mo neꞌminevoꞌ o-ledelihe lisa nene nenikumuꞌ viseꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Neꞌmine igi unuvo goloso ogaꞌ neineꞌ nosoꞌ nitekumukovoꞌ nene gono dami asi minevoꞌ minevoꞌ ogo minaaꞌ neineꞌ nosoꞌ niteꞌ minevoꞌ minevoꞌ lengemeni dameni do sotoꞌ o-lengedelingumuꞌ Oꞌmosolatiꞌ ve gihile neniꞌ lengemeloniꞌ nemukovoꞌ nene viseꞌ igaꞌ gono dalo. Idoꞌ neꞌmine nosoꞌ niteꞌ lengemeloniꞌ nene meꞌneho Oꞌmoso asiꞌve nene neniꞌ neꞌmine iline lo amuzo nemo neleꞌmize molaniꞌ nenako nemuꞌ nene neꞌmine olosuve. ");
INSERT INTO aso_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Oꞌmosoꞌmo gilivo leliꞌ dalonidoꞌ o neineꞌ gono daloneꞌ nene nani gono dalone. ");
INSERT INTO aso_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Oꞌmosoꞌmo gilivo lingine dalizadoꞌ o neineꞌ gono nene neꞌmino neive: Asiꞌve Oꞌmosoꞌmo imiselive nenikumuꞌ nene gili eleꞌvoleꞌ ilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Idoꞌ nenikumuꞌ gili eleꞌvoleꞌ ilo laineꞌ nenako laza geikumuꞌ gele eleꞌvoleꞌ o-gedesoꞌ nene atoliꞌmine suno naniꞌmine do sotoꞌ oganivosa ningosa gele eleꞌvoleꞌ olone. ");
INSERT INTO aso_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Idoꞌ avotemote neve nene ebeꞌ hadivela nivanguꞌ Okulumokutiꞌ limineꞌ nosoꞌ niteꞌ gulive mana nangumuꞌ nene gele none. Monoꞌ godolouꞌ nene tiꞌ li gizi nizaniꞌ ma neive: Aza nene nalizave lo Okulumokutiꞌ nosoꞌ niteꞌ ngimineꞌ ma neive. Neꞌmine ineꞌ nenako gaza nene nadiꞌ ilinidoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngimineꞌ: Okulumokutiꞌ nosoꞌ niteꞌ nene lingine gilavo Moseꞌ nene lemave li gilahe. Naza laminetoꞌ nolo-lingimuve. Moseꞌ aza Okulumokutiꞌ nosoꞌ niteꞌ gihile lamineꞌ nene olihe lengemamineꞌ ma neive. Asi Okulumokutiꞌ nosoꞌ niteꞌ gihile lamineꞌ lengemelive nene meꞌneho eiꞌ lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Idoꞌ neꞌmine noluvoniꞌ nene nanitekumuꞌ ve. Okulumokutiꞌ lemo misubouꞌ aleve hize eleꞌ o-lengedo minevoꞌ minevoꞌ minaaꞌ lengemeni dameni lehize-lengedaaꞌ neive nene Oꞌmosolatiꞌ nosoꞌ niteꞌ gihile nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Ve melo, gaza neꞌmine loo ma nene aꞌmine nolaineꞌ nosoꞌ niteꞌ nene gamene gamene lemezo. ");
INSERT INTO aso_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo sotoꞌ o ngimineꞌ: Neniꞌ neve nene minevoꞌ minevoꞌ minaaꞌ do sotoꞌ ogaꞌ neineꞌ nosoꞌ niteꞌ ma ne nouve. Neꞌmine nouvoniꞌ nenako ve ma ingine nenita igi giꞌmizi minilizave nene aꞌmine nosoꞌ nitekumuꞌ gohi gaꞌna hilamilisave. Ee, idoꞌ nenikumuꞌ ma gili eleꞌvoleꞌ ilizave nene nosomuꞌ gohi ma ngisamoloseive. ");
INSERT INTO aso_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ne neiha mo gomuꞌ lo-lingimuvodiꞌmine igi lingine neniꞌ nene mo ningi nizaha aꞌminesi nene mo gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Meꞌneho neniꞌ nimive mukiꞌ nene nenita alisave. Idoꞌ nenita alizave mukiꞌ nene mo kekeꞌ vasa izo do hulo-ngedamolosuve. ");
INSERT INTO aso_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Neꞌmine amolosuve noluvoniꞌ nene nanitekumuꞌ ve. Naza Okulumokutiꞌ lemo uvoniꞌ nene naꞌniseꞌne luꞌneloꞌ do molo ogo molo olove losa limuvoba asi nimiselive eiꞌ luloloꞌ do molo ogo molo olove losa lemo omo nouvoniꞌ nenako nemuꞌ nene neꞌmine amolosuve noluve. ");
INSERT INTO aso_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aꞌmine nimiseliveꞌmi luloloꞌ ogo molo oloniꞌ nene ma neꞌmino neive: Naza gizebo lamineꞌ okuvo aꞌmine neniꞌ nimingutiꞌ nene hamolitesi ma vi tolovo amavo alingeꞌ gamene nabala nene mukiꞌ gohi do ote-ngedeline losa gele neive. ");
INSERT INTO aso_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee, meꞌneho aza lulouꞌ gele neineꞌ nene gipele neniꞌ ningisa nenikumuꞌ gili eleꞌvoleꞌ ilizave mukiꞌ nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni ngemanivo di nizavo alingeꞌ gamene nabala nene gohi do ote-ngedelesane losa gele neive. ");
INSERT INTO aso_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Idoꞌ Izesuꞌ neꞌmine loꞌmo vinguꞌ nene aza neniꞌ neve nene Okulumokutiꞌ limineꞌ nosoꞌ niteꞌ ma nene nouve lineꞌ nemuꞌ nene Zuda ve naba ingine ningedo hangedoka li emenga li ");
INSERT INTO aso_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","tiꞌ li li minaniꞌ: Me ve nene Zoseheꞌ gipele neive. Olo. Izelehingi melehingi nene mo ninge none. Nemuꞌ nene aza Okulumokutiꞌ limuve nolineꞌ nene lamilinako nanimuꞌ nolive. ");
INSERT INTO aso_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Neꞌmine li nizavo Izesuꞌ aꞌmidoꞌ do velepeꞌ izo tiꞌ lo lo-ngimineꞌ: Lingine lengikuꞌ lihiteheka li ningedo hangedoka li minaniꞌ nene alamilevo. ");
INSERT INTO aso_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Eveneꞌ ma nenita alizaniꞌ nene haza ma ngeli amilisave. Asi nimiselive meꞌneho neꞌmo do nenita ogavosavoꞌ alisave. Idoꞌ ikevosa gamene nabala nene do ote-ngedelesuve. ");
INSERT INTO aso_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Monoꞌ godolouꞌ nene polohetelite ma tiꞌ li gizi nizaniꞌ ve: Oꞌmoso neꞌmo evenele mukiꞌ nene apize ngemeleseive. Neꞌmine oloseinako ve ma ingine eiꞌ gamaziꞌve gilisa lo-ngimineꞌ gamazi gili lamineꞌ ave nene nenita igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Idoꞌ meꞌnehine nene eveneꞌ hamolitesi kekeꞌ mo ningisi amave. Oꞌmosolatiꞌ uve neniꞌ hamoꞌ neꞌmovoꞌ nene meꞌnehine ningo gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Naza mo laminetoꞌ gehepeve nolo-lingimuve. Gili eleꞌvoleꞌ ilizave mukiꞌ nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni nene mo di nizave. ");
INSERT INTO aso_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Neniꞌ neve nene minevoꞌ minevoꞌ minaaꞌ do sotoꞌ ogaꞌ neineꞌ nosoꞌ niteꞌ ma ne nouve. ");
INSERT INTO aso_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Lengiꞌ avotinge misubo hadivela monanguꞌ nene Okulumokutiꞌ ngemaaꞌ ineꞌ nosoꞌ niteꞌ mana nene nikaꞌ nikaꞌ iꞌmi vi minaniꞌza nesi mo hilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mo hilaniꞌza Okulumokutiꞌ limineꞌ nosoꞌ niteꞌ gihile lamineliꞌmi monovo nene neꞌmino neive: Aꞌmine nosoꞌ niteꞌ ma nalizave nene mo hili osuꞌ lamilisave. ");
INSERT INTO aso_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Idoꞌ neniꞌ neve nene aꞌmine Okulumokutiꞌ limineꞌ nosoꞌ niteꞌ minevoꞌ minevoꞌ izelehosi minineꞌ initeꞌ ma ne nouve. Nouvonako aꞌmine nosoꞌ nitekutiꞌ ma nalizave nene minevoꞌ minevoꞌ igi minilisave. Neꞌmine ilisanako me misubouꞌ aleve miniviꞌ miniviꞌ igi minilizave lo nenitatiꞌ nosoꞌ niteꞌ ma ngemeloniꞌ nene neniꞌ meꞌmeleꞌne ngemelesuve. ");
INSERT INTO aso_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Neꞌmine lavo Zuda ve naba ingine engikuꞌ lovo lolize goloso igi tiꞌ li laniꞌ: Ve meꞌmo okoꞌno meꞌmele lengemekuvo nalizave nolineꞌ nene ngelo lemelivoba nadosa lemelesa nolive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ mo tiꞌ lo nolo-lingimuve: Lingine Oꞌmosolatiꞌ ve gihile neniꞌ meꞌmeleꞌne nami idoꞌ vaniseꞌnesi ma namilizaniꞌ nene minevoꞌ minevoꞌ minaaꞌ lengemeni dameni nene lengita ma minamoloseive. ");
INSERT INTO aso_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Idoꞌ ingine neniꞌ meꞌmeleꞌnesi vaniseꞌnesi ma nalizave nene minevoꞌ minevoꞌ minaaꞌ ngemeni dameni di nizanako alingeꞌ gamene nabaloꞌ nene do ote-ngedelesuve. ");
INSERT INTO aso_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Neꞌmine noluvoniꞌ nene nanitekumuꞌ ve. Neniꞌ meꞌmeleꞌne nene mo nosoꞌ niteꞌ gihile neivo idoꞌ vaniseꞌne nesi nene mo naaꞌ noso gihile lamineꞌ neineꞌ nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ve ma ingine neniꞌ meꞌmeleꞌnesi vaniseꞌnesi ma nalizave ingine nene nenita mini mili nizavo naza nene inginela mine molo nouve. ");
INSERT INTO aso_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nimiselive minevoꞌ minevoꞌ minaaꞌ meleho minive meꞌnehidatiꞌ nene naza amuzo do mino minevoꞌ minevoꞌ ogo minaaꞌ nouvoniꞌ neꞌmine igi neniꞌ okoꞌne nalizave ingine nenitatiꞌ nene amuzo di mini miniviꞌ miniviꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Meve nene Okulumokutiꞌ limineꞌ nosoꞌ niteꞌ gihile mamuꞌ nene noluve. Aꞌmine nosoꞌ niteꞌ nene avotinge nisa hilaniꞌ nosoꞌ niteꞌ neꞌmine nevoba asi aꞌmine mene noluvoniꞌ nosoꞌ niteꞌ nalizave nene hili osuꞌ lami mo miniviꞌ miniviꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Neꞌmine lineꞌ nene Kahanaumi numuda Zuda veti monoꞌ numunguꞌ monoꞌ apize nongemosa lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Izesuꞌ eiꞌ okoꞌno nalizangumuꞌ lineꞌ nene gili izipahala zuho linge mukiꞌ nete tiꞌ li laniꞌ: Gamazi nolineꞌ mene goseleꞌ gamazi geniꞌvesi nolineꞌ nenako eveneꞌ hamolitesi aꞌmidoꞌ gelo ngelo amoloneꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Neꞌmine li izipahala zuho ingine ningedo hangedoka li minaniꞌ nemuꞌ nene eiꞌ lulouꞌ gelo tiꞌ lo lo-ngimineꞌ: Neꞌmine gamazi luvodiꞌmo nene okodidoꞌ do molahe. ");
INSERT INTO aso_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Lingine neꞌmine luvoniꞌ nemuꞌ nene ningedo hangedoka li minikeko Oꞌmosolatiꞌ ve gihile naza gomuꞌ minuvoniꞌ ebeta dizo novuvo ningilizaniꞌ nene nadive li gililizave. ");
INSERT INTO aso_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Okode losuvolotiꞌ ogo molo ogaꞌ nouneꞌ monovote neꞌmo nene lute ma hize eleꞌ osaꞌminako haza okodine losuvolotiꞌ meꞌmeleꞌne naaꞌ neꞌmosi nene lutine ma hize eleꞌ ogo minevoꞌ minevoꞌ minaaꞌ lengemeni dameni do sotoꞌ o-lengedelivoba asi minevoꞌ minevoꞌ minaaꞌ nene Oꞌmosoꞌmi Sikalahuꞌ neꞌmovoꞌ do sotoꞌ o-lengedaaꞌ neive. Idoꞌ neniꞌ noluvoniꞌ gamazi meve nene Sikalahuliꞌmi amuzosi neivosa minevoꞌ minevoꞌ igi minilizaniꞌ aka do sotoꞌ o-lengedelingumuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Neꞌmine o neineꞌza lengikutiꞌ linge ma nizaniꞌ nene nenikumuꞌ olihe gili eleꞌvoleꞌ amavesi nene ha ma nizave. Neꞌmine lo Izesuꞌ lineꞌ nene nanitekumuꞌ ve. Aza nene gomuꞌ akaꞌmilatiꞌ gili eleꞌvoleꞌ amavemukisi idoꞌ biluvaliti aꞌninguꞌ molo-delive nemukisi nene mo ningo gele minineꞌ nenako nemuꞌ nene lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Idoꞌ neꞌmine lo gohi imineꞌ molo tiꞌ lo lineꞌ: Idoꞌ eveneꞌ ma nenita alizaniꞌ nene haza ma ngeli amilisave. Asi meꞌneho gele ngemavosavoꞌ alisave lo gomuꞌ lo-lingimuvoniꞌ nene lengikutiꞌ linge ma nenikumuꞌ gili eleꞌvoleꞌ amangumuꞌ nene gele minosa lo-lingimuvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Neꞌmine lo lidotiꞌ nene eze eꞌmeti monaaꞌ ave linge mukiꞌ nene Izesuꞌni meheꞌine imi huli-di viisa gohi eꞌmeti vamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Neꞌmine ikevo nemuꞌ nene Izesuꞌ aza izipahala zuho tuvelu nene tiꞌ lo lo-ngimineꞌ: Linginesi nene huli-nidi vilisa nigilahe. olo. ");
INSERT INTO aso_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Neꞌmine lavo Simoniꞌ Petoloꞌ aꞌmidoꞌ tiꞌ lo lineꞌ: Guvekasi ve. Minevoꞌ minevoꞌ minaaliꞌmi gamaziꞌve nene geitavoꞌ neineꞌ nenako ve gohi ma zahida vo giꞌmizelone. ");
INSERT INTO aso_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gaza nene Oꞌmosoꞌmo eiꞌ gonomuꞌ do kegese-gidive hamoꞌ eitatiꞌ anive ma nene nane lo geikumuꞌ gele eleꞌvoleꞌ ogo gele none. ");
INSERT INTO aso_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Naꞌniseꞌne nene lengiꞌ izipahaꞌne zuho tuvelu do kegeso do nenita o-lingiduvoniꞌza aꞌmingutiꞌ hamoꞌ nene Sataniꞌmi zuho gehepeve ma neive. ");
INSERT INTO aso_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Neꞌmine lineꞌ nene Kelioto ve Simoniꞌ gipele Zudaꞌnimuꞌ lineꞌ ve. Aꞌmine ve nene Izesuꞌ izipahala zuho tuvelu engiꞌ muliseutiꞌ minineꞌza aza nene Izesuꞌni biluvaliti aꞌninguꞌ molo-delive minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nelotiꞌ nene Zuda ve nete Izesuꞌni bililisa viseꞌ iꞌmi vi nizaniꞌ nenako nemuꞌ aza Zudaia misubouꞌ nene monelesa gelamo nGalilaia misubouꞌ nene mone mone ogo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Neꞌmino neivo Zuda velite azibe mili ingi mini holiseꞌ mini nosoꞌ niteꞌ naaꞌ aniꞌ gamene nene avitoꞌ ogavo ");
INSERT INTO aso_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","4","Izesuꞌ akunolomote zuho nete tiꞌ li li-daniꞌ: Eveneꞌ ma aza guveꞌne monelive lo gelelive neꞌmo initeꞌ ogo molo ilineꞌ nene halekovoꞌ ogo molo osaꞌmive. Idoꞌ gaza nene atoliꞌmine suno ogaꞌ naineꞌ nenako eveneꞌ mukiliti veꞌnidoꞌ nene vo neꞌmine ogo ngelebizelinge. Ebeꞌ mene hulo izipaha aꞌmida nizaniꞌ nete nene gaza ogaꞌ naineꞌ initeꞌ ningilizangumuꞌ nene Zudaia misubouꞌ nene vozo. ");
INSERT INTO aso_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Idoꞌ neꞌmine li akunolomote li-daniꞌ nene inginesi eikumuꞌ gili eleꞌvoleꞌ amaniꞌ nenako neꞌmo nene neꞌmine li-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Neꞌmine li-dikevo Izesuꞌ aza aꞌmidoꞌ nene tiꞌ lo lineꞌ ve: Naza vo eveneꞌ mukiliti veꞌnidoꞌ neze monovo do sotoꞌ ogo ngelebizeloniꞌ gameneꞌne nene olihe alitamive. Alitamiha lengita nene neꞌmino nomive. Gopo gameneloꞌ nesi neꞌmida nene lingine ha vaakovoꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Me misubouꞌ monoꞌ gili lamineꞌ amaniꞌ aleve nete nene lengikumuꞌ nene goseleꞌ igi gili goloso i-lingidamilisanako aꞌmida nene ha vilisaha naza nene aꞌmine monoꞌ gili lamineꞌ amaniꞌ aleve nene monovo goloso daaꞌ nave lo lo sotoꞌ ogaꞌ nouvoniꞌ nenako nemuꞌ nene ingine nenikumuꞌ goseleꞌ igi gili goloso i-nidaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nemuꞌ lengiꞌ nene aꞌmine nosoꞌ niteꞌ nalizada nene ha dizi vilo. Naza aꞌmine ebeꞌ nabala monovoꞌne do sotoꞌ oloniꞌ gameneꞌne nene olihe amineꞌ nenako nemuꞌ nene aꞌmine nosoꞌ niteꞌ nalizada nene idise dizo vamolosuve. ");
INSERT INTO aso_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aꞌmine gamazi nene lo-ngemosa aꞌmine nGalilaia misubouko nene gohi imineꞌ molo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Idoꞌ akunolomote ingine Zelusalemi numuda aꞌmine nosoꞌ niteꞌ nalizada nene dizi vikevo Izesuꞌ azasi nene aꞌmida dizo vineꞌ ve. Vineꞌza eveneꞌ veꞌnidoꞌ sotoꞌ ogo vamo halekosa vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nemuꞌ nene aꞌmine nosoꞌ niteꞌ nada nene Zuda ve naba ingine nene aꞌmine ve nene zala neve li viseꞌ igi minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Idoꞌ eveneꞌ vaiꞌ di geseꞌ igi minangutiꞌ mukiꞌ neꞌminete nene Izesuꞌnimuꞌ nunungaꞌ tiꞌ li li minaniꞌ: Aza nene eveneꞌ lamineꞌ neive li eveneꞌ linge nete nilavo ma nete nene eveneꞌ mukiꞌ goꞌine izo do goloso neive li laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ne neiha Zuda ve nabamuꞌ nene golise gilaniꞌ nenako Izesuꞌnimuꞌ nene gamazi eveneꞌ gililizadoꞌ li sotoꞌ igi eveneꞌ hamolitesi ma lamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Idoꞌ aꞌmine nosoꞌ niteꞌ nene niꞌmi vi di goholo naavo Izesuꞌ nene monoꞌ numuno nabauꞌ dizo eveneꞌ nene apize ngemo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Neꞌmino neivo Zuda ve naba ingine ningi aizo li tiꞌ li laniꞌ: Ve me ve nene monoꞌ gamazi neꞌmine lilineꞌ votigileloꞌ vivo sukulu ma lamineꞌ maha gamazi neꞌmine nolineꞌ nene nadosa nolive li laniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Neꞌmine likevo aꞌmidoꞌ aza tiꞌ lo lineꞌ: Naza gamazi mene apize nolingimuvoniꞌ nene naꞌniseꞌne gaꞌneutiꞌ gelo apize lengemamuve. Asi nimiselive eitatiꞌ nene do minosa apizo nolo-lingimuve. ");
INSERT INTO aso_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nemuꞌ nene ve ma ingine nimiselive Oꞌmosoꞌmi luloloꞌ di mili gonoꞌve ma di-dilisa gili nilizaniꞌ nene naza gamazi apize lengemaaꞌ nouvoniꞌ nene mo Oꞌmosolatiꞌ nolihe idoꞌ naꞌniseꞌne gaꞌnetiꞌ gelo noluhe neꞌmi monovo nene ningi vevesilisave. ");
INSERT INTO aso_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Idoꞌ ve ma ingine engiꞌ gaꞌningutiꞌ gili gamazi apizi ngimaaꞌ nave nene engiꞌ guveꞌine vilingumukovoꞌ nene gili minisa gamazi apizi ngimaaꞌ nave. Neꞌmine igaꞌ naniꞌza ve ma ingine ve maliꞌmo ngimiselavo igi gamazi apizi ngimaaꞌ nanguꞌ nene aꞌmine ngimiselive neꞌmi guvele vilingumukovoꞌ ve li gono dalizaniꞌ nene mo eveneꞌ gihile lamineꞌ monovo goloso engita nomineꞌ alevetevoꞌ neꞌmine ilisave. ");
INSERT INTO aso_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ne neiha Oꞌmosoꞌmi louꞌ gamazi nene Moseꞌ mo do sotoꞌ o-lengemavo di nizaniꞌza aꞌmine louꞌ gamazi nene lingine mukitoꞌ avutoꞌ igaꞌ nave. Lingine neniꞌ nibililisa gili nizaniꞌ nene nanimuꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Neꞌmine lavo aꞌmida minave mukiꞌ ingine tiꞌ li li-imaniꞌ: Laza ma gebelelesa gelamuniko sikalahuꞌ golosoliꞌmo do dudu lo-gedavo negi gamazi nolabe. ");
INSERT INTO aso_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Naza eveneꞌ do lamineꞌ o-do holisekuꞌ gono hamoꞌ duvoniꞌ neꞌmo nene lengiꞌ mukiꞌ okodidoꞌ do molavo upuhoꞌ ikeve. ");
INSERT INTO aso_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Lengiꞌ gipetineti okoꞌnidoꞌ nene Oꞌmosoꞌmi noso mili-ngidilizave lo Moseꞌ lo-lingimineꞌ ve (Ee, Moseꞌ lo-lingimineꞌza asiꞌve neꞌmo aꞌmine monovo nene ganaꞌ do sotoꞌ ineꞌ nevoba asi avotingidatiꞌ akaꞌmine sotoꞌ ineꞌ ve). Nemuꞌ nene lingine gipetineti okoꞌnidoꞌ Oꞌmosoꞌmi noso mili-ngidaaꞌ gamene nene gono damaaꞌ ve laniꞌ holisekuꞌ alitelinekisi nene holiseꞌ gamene ma ne neive lami ha gono di Oꞌmosoꞌmi noso mili-ngidaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Idoꞌ lingine Moseꞌ Louꞌ gamazi nene avutoꞌ ogalone li neꞌmine igi gipetine Oꞌmosoꞌmi evenele minilizangumuꞌ di lamineꞌ i-ngidi holisekukisi okoꞌnidoꞌ Oꞌmosoꞌmi noso mili-ngidaaꞌ naniꞌ nenako naza holisekuꞌ eveneꞌ ma do lamineꞌ gehepeve o-duvongumuꞌ nene lingizeboloꞌ nanimuꞌ nomolave. ");
INSERT INTO aso_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lingine eveneꞌ maliti monovoꞌinemuꞌ izeꞌ mili lili ma nene gopo liteꞌ li lami asi monovo ningi hehe likisavoꞌ nene izeꞌ mili lilo. ");
INSERT INTO aso_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Neꞌmine lavo Zelusalemi aleve linge nene tiꞌ li li minaniꞌ: Me ve nene leliꞌ ve nabalite bililisa gilave ma nene neive. Olo. ");
INSERT INTO aso_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ne neiha aza mela nene golise gelamo monoꞌ lovo kiselevoꞌ ogo nolo-limivo ingine aꞌminemuꞌ nene ma lamave. Idoꞌ oꞌve li-damaniꞌ nene ingine aꞌmine ve nene mo lamineꞌ Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ma nene noloseive li gilisa lamaniꞌ nolihe. ");
INSERT INTO aso_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ne neineꞌza aꞌmine aniꞌ numuno ebeꞌve nene laza mo vaitoꞌ ningo gele noba aꞌmine Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ogo sotoꞌ ilineꞌ nene aza nelatiꞌ aniꞌ ve li ma ningi gilamilisave li nizaniꞌ nenako aꞌmine ve nene Oꞌmosoꞌmo imiselelesa live ngelo minelihe. ");
INSERT INTO aso_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Neꞌmine likevo nemuꞌ nene Izesuꞌ monoꞌ numuno nabauꞌ monoꞌ apize ngemo mininguꞌ nene pigi izo tiꞌ lo lineꞌ: Lingine gilavo neniꞌ nene ningi nizave nouve. Idoꞌ numuꞌne ebeꞌne nesi nene mo ningi nizaha neniꞌ nene naꞌniseꞌne gaꞌne gelo luꞌneloꞌ do molo amuve. Ve maliꞌmo nimiselive luvoniꞌ nene ladanga lamuve. Aꞌmine nimiselive nene nomineꞌ nevoba mo laminetoꞌ neive. Lingine eiꞌ nene ningi gilamaniꞌza ");
INSERT INTO aso_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","neniꞌ nene ezelatiꞌ uvoniꞌ nenako neniꞌ nene mo ninge nouve neive. Ee, aꞌmine ninge nouve neꞌmo nene nimiselineꞌ ve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Neꞌmine lingumuꞌ nene goniꞌ o-deloningumuꞌ analoꞌ dalone li neꞌmine ilisa aniꞌza neꞌmine i-dilizave lo Oꞌmosoꞌmo molo-dineꞌ gamene nene olihe amineꞌ nenako neꞌmo nene neꞌmine i-damaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Idoꞌ aꞌmida eveneꞌ vaiꞌ mulise mili minangutiꞌ mukiꞌ nene Izesuꞌnimuꞌ tiꞌ li li minaniꞌ: Oꞌmosoꞌmo do luꞌ izelesa imiselelesa live neꞌmo nene atoliꞌmine suno vaiꞌ goloso do sotoꞌ ivo monovolo sotoꞌ oloseive li laaꞌ nanako me ve neꞌmo atoꞌ suno vaiꞌ do sotoꞌ ineꞌ nene ve gohi ma ogo atoꞌ suno vaiꞌ ivileꞌ ogo ngelo damoloseinako me ve nene mo aꞌmine Oꞌmosoꞌmo do luꞌ izelesa imiselelesa live ma nene neive li li minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eveneꞌ mukiꞌ nete Izesuꞌnimuꞌ neꞌmine li engikuꞌ li voleloꞌ meloꞌ igi nizavo Halisaioꞌ monoꞌ laaꞌ ave naba nete gili inginesi idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi makaꞌ mini engitoꞌ gono daaꞌ aniꞌ pilisi ve linge nene Izesuꞌni dalizave li ngimiselaniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Neꞌmine angumuꞌ nene Izesuꞌ tiꞌ lo lineꞌ: Naza lengikisi mineloniꞌ nene ha gamene liꞌnibevoꞌ minosa nelotiꞌ nene nimiselive neida volosuve. ");
INSERT INTO aso_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lingine nene nenikumuꞌ hize eleꞌ o-ledelive li viseꞌ ilizaha okoꞌneloꞌ nene mo ngeli ma ningamilisave. Idoꞌ aꞌmine vo mineloda nesi nene lingine ngeli ma vamilisave. ");
INSERT INTO aso_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Neꞌmine lavo Zuda ve naba nete engikuꞌ tiꞌ li laniꞌ: Ve me ve nene laza ngelo ma ningamolonida volosuve nolineꞌ nene zala volosamuꞌ nolive. Aza nene heta atoꞌ vetida Zuda ve vi ingi monavela nene vo aꞌmine heta atoꞌ vesi makaꞌ gamazi apize ngemelesamuꞌ nene ngelo ma lamoloseiha aza nene zala volosa nolivoo. ");
INSERT INTO aso_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Aza nene nenikumuꞌ viseꞌ ilizaniꞌ nene ngeli ningamilisave idoꞌ vo mineloda nesi nene ngeli ma vamilisave nolineꞌ nene nadive losa nolive li gopo gaꞌine gili minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Azibe mili ingi mini holiseꞌ mini nosoꞌ niteꞌ naaꞌ aniꞌ gamene osuꞌ lineꞌ gameneuꞌ nene gamene naba minaaꞌ neineꞌ nenako aꞌmine gameneloꞌ nene Izesuꞌ aza ote mino gamazi naba ogo aneza gamazi gidini ma tiꞌ lo lineꞌ: Ve ma ingine nosomuꞌ ngiselive nene nenita igi aꞌmine noso nene nalizave. ");
INSERT INTO aso_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ee, monoꞌ godolouꞌ tiꞌ li gizi nizaniꞌ maꞌmino sotoꞌ oloseive: Ve ma nenikumuꞌ gili eleꞌvoleꞌ igi minilizave nene luꞌningutiꞌ minevoꞌ minevoliꞌmi izeleho minineꞌ noso nene vaiꞌ lemovoꞌ mineleseive. ");
INSERT INTO aso_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Idoꞌ Izesuꞌ neꞌmine lineꞌ nene ezemuꞌ gili eleꞌvoleꞌ igi minilizave nete Oꞌmosoꞌmi Sikalahuꞌ nene alingeꞌ dalizaniꞌ nenako aꞌminemuꞌ nene lineꞌ ve. Idoꞌ alingeꞌ dalizave luvoniꞌ nene nemuꞌ luvoniꞌ ve: Izesuꞌ aꞌmine gamazi lineꞌ gamenela nene Okulumokuꞌ moꞌmosiꞌve nabala nene olihe dizo vamineꞌ nenako neꞌmo nene aꞌmine Sikalahuꞌ nene olihe imiselamivo amineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Neꞌmine lineꞌ nene eveneꞌ mukiꞌ nete gilisa linge ma nete tiꞌ li li minaniꞌ ve: Mo laminetoꞌ me ve nene polohete ma aloseive lo Moseꞌ live ma nene neive. ");
INSERT INTO aso_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Neꞌmine likaꞌ likaꞌ navo linge ma nete nene tiꞌ li li minaniꞌ ve: Me ve nene Oꞌmosoꞌmo do luꞌ izelesa imiselelesa live ma ne neive. Neꞌmine laniꞌza linge ma nete nene tiꞌ li laniꞌ ve: Monoꞌ godolouꞌ nene tiꞌ li gizi nizaniꞌ ma neive. Olo: Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live neve nene Davidiꞌ numuno ebeꞌve Betelehemi neuꞌ eiꞌ Davidiꞌ aꞌvopilemoꞌ zuhoutiꞌ sotoꞌ oloseive. Neꞌmine li gizi nizaniꞌ nenako aꞌmine nGalilaia misuboutiꞌ ve me ve nene ngelo Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live minamoloseive. Olo. ");
INSERT INTO aso_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Neꞌmine li eveneꞌ linge ma Oꞌmosoꞌmo do luꞌ izelive lo imiselelesa live ve lavo linge ma oꞌve eiꞌ nomive lavo eveneꞌ mukiꞌ nene hizi hoꞌli minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Neꞌmine navo eveneꞌ linge ma nete di gonitoꞌ i-dilisa gilaniꞌza eveneꞌ hamolitesi okoꞌnoloꞌ ma damaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aꞌmine gomuꞌ ngimiselaniꞌ pilisi ve ingine tineꞌ mili Halisaioꞌ ve nabasi idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi nizada Izesuꞌni di ami haza ikevo tiꞌ li longoꞌ i-ngidaniꞌ: Izesuꞌni nene nanimuꞌ analoꞌ di di amave. ");
INSERT INTO aso_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Neꞌmine likevo pilisi ve nete tiꞌ li li-ngimaniꞌ: Vekizo, eveneꞌ hamolitesi aꞌmine ve neꞌmo gamazi lineꞌ neꞌmini mo lisaꞌmaniꞌ nenako eiꞌ nene ngelo damoloneꞌ ogavo damune. ");
INSERT INTO aso_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Neꞌmine likevo Halisaioꞌ ve ingine tiꞌ li longoꞌ i-ngidaniꞌ: Lengiꞌ nene gotine izamilinako lengikisi gotine izo live. Olo. ");
INSERT INTO aso_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Leliꞌ eveneꞌ nabatine minuningutiꞌ mene hamolitesi eitoꞌ gili eleꞌvoleꞌ aniꞌ ma ningikehe. Oꞌve. Halisaioꞌ ve netesi nene ma gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Neꞌmine aniꞌza eveneꞌ mukiꞌ mete nene Moseꞌ louꞌ gamaziꞌve nene gili lamineꞌ amaniꞌ nenako neꞌmo nene eikumuꞌ gili eleꞌvoleꞌ aniꞌ ve. Engiꞌ nene Oꞌmosoꞌmo usiꞌ ize-ngede neive. ");
INSERT INTO aso_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Neꞌmine likevo Izesuꞌ neida gomuꞌ ma vive Nikodemoꞌ eiꞌ nene engiꞌ mulisetiꞌ minive nenako aza tiꞌ lo longoꞌ o-ngidineꞌ ve: ");
INSERT INTO aso_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ve ma olihe goniꞌ o-do initeꞌ inekumuꞌ gele hehe lamosa ve goloso ve ha gopo loloneꞌ nene leliꞌ louꞌ gamazite nene avutoꞌ amolobe. Olo. ");
INSERT INTO aso_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Neꞌmine lavo aꞌmidoꞌ tiꞌ li li-imaniꞌ: Gazasi nene aꞌmine veꞌmi zuho nGalilaia ve nolosane. Olo. nGalilaia misuboutiꞌ nene polohete ma sotoꞌ ilizave li monoꞌ godolouꞌ nene ma gizamaniꞌ nenaze. Geiꞌ nene monoꞌ godolouꞌ aꞌminemuꞌ luhuvo ma gizi nizahe viseꞌ ogo ningo do sotoꞌ ozo.  ");
INSERT INTO aso_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eveneꞌ mukiꞌ numuꞌnida vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Izesuꞌ aza gohi Oliva Golola dizo vineꞌ ");
INSERT INTO aso_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Idoꞌ nedengaꞌ goꞌ vesemeꞌ neivo Izesuꞌ nene monoꞌ numuno nabaꞌmi gesi minguꞌ dizo neivo eveneꞌ mukiꞌ nene aꞌmine neida navo Izesuꞌ aza mitoꞌ mino apiꞌ ogo monoꞌ apize ngemeꞌmo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Neꞌmine oꞌmo novivo louꞌ gamazi apizi ngimaaꞌ avesi idoꞌ Halisaioꞌ vesi ingine veneꞌ ma ve masi monovo goloso ikesivo ningi aꞌmine veneꞌ nene eleꞌmizi igi eveneꞌ mukilite ningilizadoꞌ di oti-di ");
INSERT INTO aso_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Izesuꞌni tiꞌ li li-imaniꞌ: Tisazo, veneꞌ me ve nene ve masi monovo goloso nasivo laza ningo analoꞌ dokune. ");
INSERT INTO aso_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nemuꞌ nene Moseꞌ louꞌ gamazi gize-lidinguꞌ nene neꞌmine veneꞌ nene geheni huli huliꞌ igi ngibili hililizave lo-lede neineꞌ nenako gaza aꞌminemuꞌ nene nadive lilinidoꞌ o neive laniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Neꞌmine li longoꞌ i-daniꞌ nene Izesuꞌ gamazi do gopo ogo lilineꞌ nene goniꞌ nabaloꞌ eleꞌmize molalobe li gili ha emenguꞌ neꞌmine milisa golo izi longoꞌ i-daniꞌ ve. Neꞌmine li longoꞌ i-dikevo Izesuꞌ aza gubiꞌ izo anadunuꞌ misubouꞌ luhuvo gizo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Neꞌmine ineꞌza ingine geligeli igi gohi longoꞌ i-dikevo Izesuꞌ oto tiꞌ lo lo-ngimineꞌ: Lengikutiꞌ ve ma lihimeꞌvesi nomo nolive ma nolineꞌ neꞌmo nene ganaꞌ apiꞌ ogo geheni hulo belavosa nene bililo. ");
INSERT INTO aso_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Neꞌmine lo gohi gubiꞌ izo misubouꞌ luhuvo gizo minineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Idoꞌ Izesuꞌ neꞌmine lineꞌ nene gili ingine eveneꞌ nabalatiꞌ apiꞌ igi hamo hamoꞌ vikaꞌ vikaꞌ igi osuꞌ likevo Izesukovoꞌ nene aꞌmine veneꞌ masi ha ote minivo minasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Neꞌmine ogo Izesuꞌ aza gohi ote pehe lo veneꞌ nene tiꞌ lo longoꞌ o-dineꞌ: Geiꞌ gelemi minave ma nene zaala vave. Eveneꞌ hamolitesi ma lihime gimamahe. ");
INSERT INTO aso_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Neꞌmine lavo veneꞌ aza aꞌmidoꞌ tiꞌ lo lineꞌ: Oꞌove, ma neꞌmine i-nidamave lineꞌ. Neꞌmine lavo Izesuꞌ asi nene tiꞌ lo lineꞌ: Nazasi nene aꞌmineꞌmine ogo lihime ma gemamolosuze. Gaza voosa nene lihime gohi ma damozo lo-dineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Idoꞌ Izesuꞌ aza gamazi gohi ma eveneꞌ lo-ngiminguꞌ nene tiꞌ lo lineꞌ: Naza nene misubouꞌ aleve hize labanaꞌ ele-ngedaaꞌ uve ma nene nouve. Ve ma neꞌmeti minilizave nene luꞌninguꞌ litiꞌmuso ize minamivo aꞌmine neniꞌ hize eleꞌ o-ngedeloniꞌ labanaꞌ neꞌmo nene minevoꞌ minevoꞌ iliza aka ngelebizivo minilisave. ");
INSERT INTO aso_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Neꞌmine lavo Halisaioꞌ ve aꞌmidoꞌ tiꞌ li laniꞌ: Geiꞌ monovoka nene eveneꞌ atolitesi hize eleꞌ i-gidi lamavo gasikavoꞌ lo sotoꞌ sotoꞌ naineꞌ nenako neꞌmo nene geiꞌ gamazika nene gamazi gihile nehe lo ngelo ma gelamolosune. ");
INSERT INTO aso_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Neꞌmine likevo aꞌmidoꞌ Izesuꞌ tiꞌ lo lineꞌ: Lingine nenikumuꞌ geiꞌ monovoka nene gasikavoꞌ nolane laniꞌ nene laminetokisi nililizaha gamaziꞌne nene gamazi gihile gehepeve neive. Nene nanitekumuꞌ ve. Naza nene zalatiꞌ uvoniꞌ nehe idoꞌ zala voloniꞌ nehe nemuꞌ nene mo gele nouve. Gele nouvoniꞌza lingine nene zaala voloniꞌ nehe idoꞌ zaalatiꞌ uhe nemuꞌ nene ma gilamave. ");
INSERT INTO aso_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lingine eveneliti monovomuꞌ izeꞌ mili laaꞌ naniꞌ nene ha me misubouꞌ monovolokovoꞌ eꞌmetisa neꞌmine igaꞌ nave. Idoꞌ neniꞌ nene eveneꞌ maliti monovomuꞌ izeꞌ molo lihime ngemesaꞌmuve. ");
INSERT INTO aso_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ne neiha eveneliti monovomuꞌ izeꞌ molo lihime ma ngimuvodiniko neniꞌ hamokovoꞌ nene neꞌmine amo nimiselive meꞌnehosi nene makaꞌ neꞌmine usidinako nemuꞌ nene eveneliti monovoꞌinemuꞌ nene ma luvodiniko aꞌminemuꞌ nene mo gamazi gihile ve li lingine mo gililizadoꞌ o minidine. ");
INSERT INTO aso_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Idoꞌ lengiꞌ louꞌ gamazitinguꞌ nene tiꞌ li gizi nizaniꞌ ma neive: Eveneꞌ setalitise initeꞌ maliꞌmi monovomuꞌ hamoꞌ gamazivoꞌ li sotoꞌ ilisineꞌ nene aꞌmine li sotoꞌ ilisineꞌ gamazi nene gamazi gihile neive li gililizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naza naꞌniseꞌne neniꞌ monovoꞌnemuꞌ nene lo sotoꞌ sotoꞌ nouha nimiselive meꞌneho nesi nene neniꞌ monovoꞌnemuꞌ lo sotoꞌ sotoꞌ ogaꞌ neinako nemuꞌ nene nenikumuꞌ naꞌniseꞌne gamazi laaꞌ nouvoniꞌ ma nene mo laminekovoꞌ neive li gililizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Neꞌmine lavo Halisaioꞌ ve ingine tiꞌ li longoꞌ i-daniꞌ: Aꞌmine maho nene zala neive. Neꞌmine li longoꞌ i-dikevo aꞌmidoꞌ Izesuꞌ tiꞌ lo lo-ngimineꞌ: Neniꞌ nene zaho nouhe lingine ningi gilamaniꞌ nene meꞌnehinemukisi nene aza zaho nehe ma ningi gilamave. Nenikumuꞌ nene ma ningi giladiniko meꞌnehinemukisi ningi giladine. ");
INSERT INTO aso_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Neꞌmine lineꞌ nene monoꞌ numuno nabauꞌ Oꞌmoso imaniꞌ moni milaniꞌ bokisi minaniꞌ numuno luloꞌmi gahevela mino monoꞌ apize ngemeꞌmo vo mininguꞌ nene aꞌmine gamazi lineꞌ ve. Neꞌmine ineꞌza Oꞌmosoꞌmo eze dalizave lo gamene molo-dineꞌ nene olihe amineꞌ nenako neꞌmo nene eveneꞌ hamolitesi analoꞌ di di gonitoꞌ i-damave. ");
INSERT INTO aso_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Idoꞌ Izesuꞌ aza gohi tiꞌ lo lo-ngimineꞌ: Naza mo lengiꞌ hulo-lengedo volosuve. Neꞌmine okuvo lingine nenikumuꞌ viseꞌ igi minilizaha mo ningami mini lihimetine apasamo ha neivo hililisave. Idoꞌ neniꞌ ningamilizave noluvoniꞌ nene nanitekumuꞌ ve. Neniꞌ voloda nene lingine ngeli vamilizaniꞌ ogavosa noluve. ");
INSERT INTO aso_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Neꞌmine lavo Zuda ve naba nete tiꞌ li laniꞌ: Aza neniꞌ voloda nene lingine ngeli vamilisave nolineꞌ nene eiꞌ okoꞌno bele helelesa nene ngelo neꞌmine lamoloseiha neꞌmine lineꞌ nene nanitekumuꞌ live. ");
INSERT INTO aso_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Neꞌmine likevo aza imineꞌ molo tiꞌ lo lo-ngimineꞌ: Lengiꞌ nene galaꞌmuno melatiꞌ ma nene nizave. Idoꞌ neniꞌ nene veletatiꞌ ma nene nouve. Ee, lingine nene me misuboutiꞌ ma nene nizave. Idoꞌ neniꞌ nene me misuboutiꞌ nomuve. ");
INSERT INTO aso_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Neꞌmini nizangumuꞌ nene lingine lihimetinesi ha neivo hililisave luvoniꞌ ma neive. Ee, lingine nenikumuꞌ aꞌmine neive ma ne neive li ma gili eleꞌvoleꞌ amilizaniꞌ nene lihimetine apasamo ha neivo aꞌminesi hililisave. ");
INSERT INTO aso_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Gaza nene zaho ma nane. Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Gamene galaꞌmuda vomine lo-lingimuve ma adoꞌ nene nouve. ");
INSERT INTO aso_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Idoꞌ lengiꞌ monovotinemuꞌ izeꞌ molo lihime lengemelodoꞌ o minineꞌ gamazi nene vaiꞌ lo neiha nimiselive neꞌmo mo gamazi gihile laminekovoꞌ laaꞌ neivo eitatiꞌ giluvoniꞌ gamazivoꞌ nene me misubouꞌ aleve lo-ngemaaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aꞌmine neꞌmine lineꞌ nene metehine Oꞌmosomuꞌ lineꞌ nene ingine gilamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Neꞌmine lo Izesuꞌ tiꞌ lo lineꞌ: Lingine alingeꞌ Oꞌmosolatiꞌ ve gihile neniꞌ zaloꞌ di oti-nidiliza gameneloꞌ nenikumuꞌ nene mo eiꞌ ma neive li ningi gilisa idoꞌ naza initeꞌ ogo molo ogaꞌ nouvoniꞌ nene naꞌniseꞌne gaꞌnetiꞌ gelo ma osaꞌmuvoniꞌza asi meꞌneho nelebizineꞌ initekovoꞌ nene lo sotoꞌ ogaꞌ nouvoniꞌ nesi ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aꞌmine nimiselive nene nenikisi makaꞌ neive. Ee, naza eiꞌ mulunouꞌ lamineꞌ gelelineꞌ initekovoꞌ ogaꞌ nouvoniꞌ nenako nemuꞌ nene aza ninge mate nimikivo ma minesaꞌmuve. ");
INSERT INTO aso_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Neꞌmine lo loꞌmo novivo eveneꞌ linge mukiꞌ nene ezela gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Neꞌmine ikevo Zuda ve ezemuꞌ gili eleꞌvoleꞌ avemuꞌ nene Izesuꞌ tiꞌ lo lineꞌ: Lingine neniꞌ apize lingimuvoniꞌ gamaziloꞌ eꞌmeti mini di vi nilizaniꞌ nene neniꞌ izipahaꞌne zuho gihile nene nizave. ");
INSERT INTO aso_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Neꞌmine igisa nene gamazi gihileꞌmi monovo nene ningi gilikevo lingine gelekeleꞌ goloso igi nizangutiꞌ nene aꞌmine gamazi gihile neꞌmo nene do kuluhize-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Neꞌmine lavo eveneꞌ linge malite aꞌmidoꞌ tiꞌ li li-imaniꞌ: Laza Oꞌmosoꞌmo do ote-dive Abalahamuꞌ aꞌvopilemoꞌ zuho noneꞌ nenako laza nene mo kekeꞌ eveneꞌ malite di gelekeleꞌ i-lidikevo minamuneꞌ nenako gaza gelekeleꞌ goloso igi nizangutiꞌ kuluhizi minilisave nolaneꞌ nene lamilinako nanimuꞌ lane. ");
INSERT INTO aso_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Neꞌmine likevo aꞌmidoꞌ Izesuꞌ tiꞌ lo lo-ngimineꞌ: Naza laminetoꞌ tiꞌ lo nolo-lingimuve: Lihime dalizave mukiꞌ nene mo lihime monovoliꞌmi gelekeleꞌ ve nizave. ");
INSERT INTO aso_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ve ma ve mala vi gelekeleꞌ ve minilizave ingine aꞌmine meꞌnibi numuꞌveuꞌ mudise minilizaniꞌ moꞌmosiꞌine nene ma minesaꞌmineꞌza aꞌmine meꞌnibi gipele zuho nete nene mudise minilizaniꞌ moꞌmosiꞌine nene mo ha minaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nemuꞌ nene Oꞌmosoꞌmi gipele naza lihime monovoliꞌmi gelekeleꞌ ve minangutiꞌ do kuluhize-lengedeloniꞌ nene mo mudise haza gehepeve minilisave. ");
INSERT INTO aso_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Idoꞌ lengiꞌ nene mo Abalahamuꞌ aꞌvopilemoꞌ nizave losa nene ha gele nouha lingine nene neniꞌ nibili hililiza aka nene viseꞌ igi nizave. Nene nanitekumuꞌ ve. Lingine neniꞌ gamaziꞌne damavo lutinguꞌ vo minamineꞌ nemuꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Idoꞌ naza neniꞌ gamaziꞌne laaꞌ nouvoniꞌ nene meꞌnehosi makatoꞌ minosa ninguvoniꞌ initekumukovoꞌ nene laaꞌ nouve. Idoꞌ lingine igi mili igaꞌ naniꞌ nene lengiꞌ metibidatiꞌ gilaniꞌ initeꞌ nene igi mili igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Neꞌmine lavo ingine tiꞌ li li-imaniꞌ: Gaza leliꞌ metehinemuꞌ laineꞌ nene leze meteho nene Abalahamuꞌ ma ve. Neꞌmine likevo Izesuꞌ aza tiꞌ lo lo-ngidineꞌ: Lingine mo laminetoꞌ Abalahamuꞌ aꞌvopilemoꞌ minadiniko mo Abalahamuꞌ ogo molo ogo minaaꞌ ineꞌ monovoloꞌ nene eꞌmeti minadineꞌza neꞌmine ma isaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Naza gamazi gihile Oꞌmosoꞌmo lo-nemavo giluvoniꞌ lo-lingimuve neniꞌ nene nibili hililiza aka viseꞌ igi nizave. Neꞌmine igi nizaniꞌza Abalahamuꞌ nene neꞌmine initeꞌ ma osaꞌmineꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lingine neꞌmine igi mili naniꞌ nene mo lingi metibo ogo molo ogaꞌ idiꞌmine nave. Neꞌmine lavo ingine aꞌmidoꞌ tiꞌ li laniꞌ: Laza nene gopo akaloꞌ izipe nomune. Meteho nene Oꞌmoso hamoꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Neꞌmine likevo aꞌmidoꞌ Izesuꞌ tiꞌ lo lo-ngimineꞌ: Idoꞌ naza mela ogo nouvoniꞌ nene Oꞌmosolatiꞌ uvoniꞌ ve. Naꞌniseꞌne gaꞌne gelo amo eiꞌ Oꞌmosoꞌmo nimiselavo nouve. Nouvoniꞌ nenako Oꞌmoso nene metibo minidiniko lingine neniꞌ nene lutine nimadine. ");
INSERT INTO aso_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Lingine neniꞌ gamazi lo-lengemaaꞌ nouvoniꞌ gilamaniꞌ nene nanitekumuꞌ ve. Lingine neniꞌ gamazi gililizadoꞌ lisiheꞌ amaniꞌ nenako neꞌmo ve. ");
INSERT INTO aso_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lingine nene metibo Satanilatiꞌ sotoꞌ aniꞌ nenako nemuꞌ nene aꞌmine metibo lulouꞌ laniteꞌ gilineꞌ initeꞌ nene igi mili ilisa gilaaꞌ nave. Aꞌmine Satani nene ganaꞌ sotoꞌ idatiꞌ eveneꞌ ngebele helaaꞌ ive minineꞌ ve. Gamazi gihile eita nomineꞌ nenako neꞌmo aza nene gamazi gihileloꞌ eꞌmeto ogo molo osaꞌmive. Aza nene sozaloꞌ ve mino soza laaꞌ monovoliꞌmi meleho neineꞌ nenako neꞌmo nene aza soza lilineꞌ nene ha eiꞌ emeni dameni gehepeveloꞌ eꞌmeto loloseive. ");
INSERT INTO aso_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne neiha neniꞌ nene gamazi gihilevoꞌ laaꞌ nouvoniꞌ nenako nemuꞌ nene lingine aꞌmine metibine neꞌmine mini aꞌmine laaꞌ nouvoniꞌ gamazi nene gili eleꞌvoleꞌ isaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Lengikutiꞌ ve maliꞌmosi neniꞌ monovo goloso do noloniꞌ nene ngelo ma do sotoꞌ amoloseinako nemuꞌ nene naza gamazi gihile noluvoniꞌ nenako nanimuꞌ gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Idoꞌ Oꞌmosolatiꞌ sotoꞌ igi minave nene Oꞌmosoꞌmi gamazi gilaaꞌ naha lingine Oꞌmosolatiꞌ sotoꞌ amaniꞌ nenako neꞌmo nene eiꞌ gamazi gilisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Neꞌmine lavo Zuda ve ingine aꞌmidoꞌ tiꞌ li li-imaniꞌ: Gaza nene gopo izipe Samalia vete gidaniꞌ ma nanivosa sikalahuꞌ goloso nene lukauꞌ neive noluneꞌ nene mo laminetoꞌ nololosune. ");
INSERT INTO aso_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Neꞌmine likevo aꞌmidoꞌ Izesuꞌ tiꞌ lo lo-ngimineꞌ: Naza sikalahuꞌ goloso neve nene mo kekeꞌ luꞌneuꞌ nomive noluve. Asi meꞌnehine nene gelekeleꞌ o-do do naba o-daaꞌ nouve. Neꞌmine ogaꞌ nouvoniꞌza lingine neꞌmine i-nidami di limi-nidilisa igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne neiha neniꞌ di naba i-nidilizave losa gono dosaꞌmuve. Neniꞌ di naba i-nidilizave losa gono daaꞌ neive nene ma mino aꞌminemuꞌ izeꞌ molaloseive. ");
INSERT INTO aso_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naza laminetoꞌ tiꞌ lo nolo-lingimuve: Neniꞌ gamaziꞌne gili di minilizave mukiꞌ nene hili osuꞌ lami miniviꞌ miniviꞌ igivoꞌ minilisave. ");
INSERT INTO aso_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Neꞌmine lavo Zuda ve ingine tiꞌ li laniꞌ: Idise gamazi nolainidotiꞌ nogiluneꞌ geikuꞌ sikalahuꞌ goloso neive luneꞌ nene mo laminetoꞌ lokuneꞌ neive lo gele none. Oꞌmosola giꞌmizive naba Abalahamuꞌ nene mo helave. Idoꞌ polohete minaniꞌ nesi mo hilikeve. Neꞌmine ikeniꞌza gaza nene neniꞌ gamaziꞌne gili dalizave mukiꞌ nene hilami ha minilisave nolabe. ");
INSERT INTO aso_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Avoteho naba Abalahamuꞌ nene helaaniꞌ nenako geiꞌ nene eiꞌ ivileꞌ ogo eveneꞌ naba nabe. Idoꞌ polohete nesi hilaakovoꞌ aniꞌ nenako gaza nene okonga do dizo naniꞌmine ve nouve losa nane. ");
INSERT INTO aso_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lineꞌ: Naza guveꞌne monelive lo naꞌniseꞌne okoꞌne do dizeꞌmo vo nouvo guveꞌne vilineꞌ nene mo haza niteꞌ loloꞌ oloseive. Neniꞌ guveꞌne vilive lo neniꞌ do naba o-nedaaꞌ neive nene meꞌneho lengiꞌ nete eiꞌ nene Oꞌmosote ve laaꞌ nave ne neive. ");
INSERT INTO aso_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ne neiha lingine eiꞌ monovomuꞌ nene ningi gilamavo nenikovoꞌ nene eikumuꞌ ningo gele nouve. Idoꞌ naza nene ezemuꞌ ma ningo gelamuve luvodiniko lengiꞌ neꞌmine mino sozaloꞌ ve minuvodine. Ne neiha ezemuꞌ nene mo ningo gelosa gamaziꞌvesi nene mo gele daaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Lengiꞌ avotibo Abalahamuꞌ nene neniꞌ me misubouꞌ ogo, ogo molo nouvo ningelingumuꞌ nene olize goloso izineꞌ ve. Ee, aꞌmine mela nouvoniꞌ gamene nene ningo gelo mulunouꞌ lamineꞌ gilineꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Neꞌmine lavo Zuda ve ingine tiꞌ li li-daniꞌ: Gaza nene kilisimasika olihe fifti (50) nelasi amineꞌ neke nene gozopoꞌ akaꞌmila hele vive Abalahamuꞌ nene ningaineꞌ gani nolabe. ");
INSERT INTO aso_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Naza mo laminetoꞌ gehepeve nolo-lingimuve. Aꞌmine Abalahamuꞌ olihe sotoꞌ amivosa neniꞌ nene nouvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Neꞌmine lavo nemuꞌ nene Zuda ve ingine geheni bililisa geheni daniꞌza Izesuꞌ aꞌminguꞌ vo haleko monoꞌ numuno nabautiꞌ nene heta lemo vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Idoꞌ Izesuꞌ nene akaloꞌ ma novo ve ma izelehi mulunoutiꞌ vele like minivo sotoꞌ ive ma ningineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aꞌmine vemuꞌ nene Izesuꞌ izipahala zuho nete tiꞌ li longoꞌ i-daniꞌ: Tisazo, ve me ve ne vele like minivo sotoꞌ ineꞌ nene eita lihime minidiꞌmo ihe idoꞌ izele melela minidiꞌmo ive. ");
INSERT INTO aso_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Aza vele like minivo sotoꞌ ineꞌ nene lihime izele melelasi ezelasi minidiꞌmo nomive. Asi Oꞌmosoꞌmo ezela gono davo eiꞌ amuzoꞌve ezela sotoꞌ ogavo ningilizangumuꞌ nene izelehi mulunoutiꞌ vele like minivo sotoꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Idoꞌ labanaꞌ ele minelineꞌ gamene nene gono daaꞌ gamene ne neive. Litiꞌmuso izelineꞌ nene gono ngelo ma damolosunako nemuꞌ nene laza idise nimiseliveꞌmo molo-lidineꞌ gameneuꞌ mene eiꞌ gono nene geho voloneꞌ aka olihe tilamo gode neidoꞌ nene ha geheꞌmo vo mineloneꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Naza me misubouꞌ omo nouvoniꞌ nene eveneꞌ hize labanaꞌ ele-ngedaaꞌ uve nouve. ");
INSERT INTO aso_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Neꞌmine losa misubouꞌ gituhoꞌ ogo do gohiꞌ loloꞌ ogo vele likiveꞌmi veleloꞌ nene holo-do ");
INSERT INTO aso_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","tiꞌ lo lo-dineꞌ: Gaza vo Siloamu noso ohunguꞌ nene nosoꞌ izezo (Aꞌmine gamazi Siloamu neꞌmi monovo nene neꞌmino neive: imiselave). Neꞌmine lavo vele likive aza vo nosoꞌ izoosa numuꞌvela tineꞌ molo aniꞌ nene vele lamineꞌ o minivosa tineꞌ molo aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Neꞌmine ogavo eiꞌ numuꞌvela avitoꞌ minaaꞌ avesi idoꞌ akaloꞌ mitoꞌ mino monimuꞌ vokuꞌ vokuꞌ lo minaaꞌ ivo ningaaꞌ avesi ingine tiꞌ li li minaniꞌ: Me ve nene akaloꞌ mitoꞌ mino vokuꞌ vokuꞌ lo minaaꞌ ive ma noloseive. Olo. ");
INSERT INTO aso_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eveneꞌ linge ma nete nene mo aꞌmine ve ma ne neive laniꞌza ma nete nene Oꞌve. Eiꞌ nene aꞌmine ve gele vive neive laniꞌ. Neꞌmine likevo aꞌmine ve neꞌmo tiꞌ lo lineꞌ: Aꞌmine ve ma nouve. ");
INSERT INTO aso_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Neꞌmine lavo ingine tiꞌ li longoꞌ i-daniꞌ: Neꞌmine lo ma veka nene nadosa lamineꞌ ive. ");
INSERT INTO aso_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Neꞌmine li longoꞌ i-dikevo aza aꞌmidoꞌ tiꞌ lo lo-ngidineꞌ: Izesuꞌ ve laaꞌ nave neꞌmo nene gohiꞌ loloꞌ ogo veꞌneloꞌ holo-nido tiꞌ lo lo-nimive: Gaza vo Siloamu nosouꞌ nosoꞌ izezo. Lavo naza vo aꞌminguꞌ nosoꞌ izuvoniꞌ nene aꞌmidoꞌ liteꞌ lo veꞌne ningekuve. ");
INSERT INTO aso_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Neꞌmine lavo ingine tiꞌ li longoꞌ i-daniꞌ: Aꞌmine ve nene zala neve. Neꞌmine likevo aza nene naza ma gelamuve lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aꞌmine vele likive lamineꞌ ive nene Halisaioꞌ ve naba nizada eleꞌmizi vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aꞌmine vele likive do lamineꞌ o-delesa Izesuꞌ gohiꞌ loloꞌ ineꞌ gameneuꞌ nene holiseꞌ gamene minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nemuꞌ nene Halisaioꞌ ve ingine aꞌmine ve vele ningineꞌ monovomuꞌ gohi longoꞌ i-dikevo aza tiꞌ lo lo-ngimineꞌ ve: Aza nene veꞌneloꞌ gohiꞌ holo-nedavo nosoꞌ ize hulokosa veꞌne nene ninguve. ");
INSERT INTO aso_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Neꞌmine lavo Halisaioꞌ ve linge malite tiꞌ li laniꞌ ve: Ve me ve nene holiseꞌ gamene mauꞌ ve lo gelamo vele likive do lamineꞌ o-dineꞌ nene gono daniꞌ nenako Oꞌmosolatiꞌ ave nomo noloseive. Neꞌmine li laniꞌza linge ma nete nene tiꞌ li laniꞌ: Lihimeloꞌ ve nete nene atoꞌ suno meꞌmine nene ngeli di sotoꞌ ilizahe. Likevo lovoꞌninguꞌ ogavo ingine hizi hoꞌli minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Neꞌmine igi mini nelotiꞌ nene vele likive nene gamazi gohi ma tiꞌ li longoꞌ i-daniꞌ: Geiꞌ veka do lamineꞌ o-gidineꞌ nenako geiꞌ nene eikumuꞌ nadive lo-daaꞌ nane. Neꞌmine likevo aza nene polohete ma ve lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Idoꞌ Zuda ve naba ingine aꞌmine ve nene gomuꞌ vele like minidotiꞌ vele ningave laniꞌ nemuꞌ nene gili eleꞌvoleꞌ ami mini aꞌmine veꞌmi izele mele nene asi li-ngidi longoꞌ i-ngidi engiꞌ gamazi gilisa nene gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ee, aꞌmine veꞌmi izele mele nene asi li-ngidi tiꞌ li longoꞌ i-ngidaniꞌ: Me ve nene lengiꞌ gipetine vele like minivo sotoꞌ ive lave ma ne neihe. Aꞌmine nolineꞌ nene vele nene nadosa ningive. ");
INSERT INTO aso_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Neꞌmine li likevo izelehoi melehoi ingine tiꞌ li lasineꞌ: Me ve nene mo leliꞌ gipete neivo idoꞌ velesi nene like minivo sotoꞌ ineꞌ ve lo gele nosiha ");
INSERT INTO aso_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","idise vele ningineꞌ monovo nemukisi idoꞌ vele do lamineꞌ o-dive nemukisi nene mo gelamusize. Eiꞌ nene izipe namuno nomize. Eiꞌ nene ha lo-lengemeleseize. Longoꞌ i-dilo. ");
INSERT INTO aso_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Idoꞌ izelehoi melehoi neꞌmine lasineꞌ nene Zuda ve naba nete nene gomukutiꞌ gamazi neꞌmine li li hukikaniꞌ ve: Ve malite Izesuꞌ nene Oꞌmosoꞌmo do luꞌ izelesa imiselelesa live ve li lilizave nene Zuda ve leliꞌ monoꞌ muliseutiꞌ do hulo-ngedelesune. Neꞌmine li li hukikaniꞌ nenako nemuꞌ nene izelehoi melehoi ingine aꞌmine Zuda ve nabamuꞌ golise gili minisa nene neꞌmine lasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ee, Zuda ve naba gamazi neꞌmine li li hukikaniꞌ nenako nemuꞌ nene eiꞌ nene izipe ngomo nomize. Longoꞌ i-dilo li izelehoi melehoi lasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Neꞌmine likesivo Halisaioꞌ ve ingine aꞌmine vele like minidotiꞌ lamineꞌ ive nene gohi gamene sitaꞌ ivo asi li-daniꞌ ve. Vise likevo ogavo tiꞌ li li-daniꞌ: Laza nene aꞌmine veka do lamineꞌ o-nidive lanive nene lihimeloꞌ ve neivo ningo gele noneꞌ nenaze. Gaza Oꞌmoso opoꞌni lo eiꞌ veleloꞌ nene gamazi lisiheꞌ ogo lamineꞌ lozo. ");
INSERT INTO aso_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Neꞌmine likevo aza tiꞌ lo lo-ngimineꞌ ve: Aza nene lihimeloꞌ ve nolineꞌ nemuꞌ nene ma gelamuvoniꞌza naza initeꞌ hamokumuꞌ ma gele nouvoniꞌ nene naza gomuꞌ veꞌne like minidotiꞌ gohi ninguvoniꞌ nemukovoꞌ nene gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Neꞌmine lavo tiꞌ li longoꞌ i-daniꞌ: Nadiꞌ ogosa veka do lamineꞌ o-gidive. ");
INSERT INTO aso_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Longoꞌ i-dikevo aꞌmidoꞌ nene tiꞌ lo lo-ngimineꞌ ve: Naza mo lo-lengemekuvoniꞌ maha lingine gilami nanitekumuꞌ gohi gililisa nilave. Linginesi nene eiꞌ izipahala zuho loloꞌ olone li gili nizahe. Nanimuꞌ geligelinga nilave. ");
INSERT INTO aso_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Neꞌmine lavo ingine gamazi goloso li-di elemisa tiꞌ li laniꞌ ve: Geiꞌ gehepeve nene eiꞌ izipahala nene nane. Idoꞌ laza nene Moseꞌ izipahala nene none. ");
INSERT INTO aso_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Laza nene Oꞌmosoꞌmo eiꞌ gamazi Moseꞌni lo-imineꞌ nene gele noba gaza nolanive nene aniꞌ akaꞌve nene gelamune. ");
INSERT INTO aso_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Neꞌmine likevo vele likive aza aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Agae, voꞌne vave. Aꞌmine neniꞌ veꞌne do lamineꞌ o-nididotiꞌ nene aꞌmine ve aniꞌ akaꞌve nene sotoꞌ o neineꞌza lingine gililizanako gelamune likeve. ");
INSERT INTO aso_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Laza mo gele none. Oꞌmoso neꞌmo nene lihimeloꞌ ve nene gele ngemesaꞌmo asi eveneꞌ lamineꞌ Oꞌmosola luꞌine mili eiꞌ luloloꞌ eꞌmetaaꞌ avevoꞌ nene gele ngemaaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gozopoꞌ gozopokisi nene ve malitesi izeꞌningi muluꞌningutiꞌ veꞌine like minivo sotoꞌ ave di lamineꞌ i-ngidave nene hamokisi mo kekeꞌ minamaniꞌza aꞌmine ve hamokovoꞌ ne neive. ");
INSERT INTO aso_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eiꞌ nene Oꞌmosolatiꞌ amidiniko aꞌneꞌmine initeꞌ neꞌminesi nene mo ngelo ma amidine. ");
INSERT INTO aso_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Neꞌmine lavo ingine aꞌmidoꞌ tiꞌ li li-daniꞌ: Gaza izipe goloso lihimekasi sotoꞌ aineꞌ neke nene leliꞌ nene apize nolemabe. Neꞌmine li engiꞌ muliseutiꞌ ve minamilive li mudise di huli heta i-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Izesuꞌ nene aꞌmine vele like minivo do lamineꞌ o-dive nene Halisaioꞌ vete di huli-dangumuꞌ nene gelo aꞌmine ve nene viseꞌ ogo ningo tiꞌ lo lo-imineꞌ: Oꞌmosolatiꞌ ve gihilemuꞌ nene gele eleꞌvoleꞌ abe amane. ");
INSERT INTO aso_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Neꞌmine lavo vele likive aza tiꞌ lo lineꞌ: Ve melo, naza aꞌmine ve gele eleꞌvoleꞌ o-deloko zaho neve. ");
INSERT INTO aso_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Aꞌmine ve nene gaza vonuꞌ bele minanive gamazi nolo-gimuve ne nouve. ");
INSERT INTO aso_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Neꞌmine lavo ve aza tiꞌ lo lineꞌ: Guvekasi ve, naza nene gele eleꞌvoleꞌ okuve lo gubiꞌ ize emo opoꞌni lineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Neꞌmine ogavo Izesuꞌ aza tiꞌ lo lineꞌ: Naza me misubouꞌ uvoniꞌ nene eveneꞌ luꞌineꞌmi vele likavo nizave nene ningilizave idoꞌ laza aka ninge none li soza laaꞌ ave nene luꞌineꞌmi vele nene mudise like minelive losa eveneꞌ izeꞌ molo-ngedelesa uvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Neꞌmine nolivo Halisaioꞌ ve linge makaꞌ minaniꞌ nete gili tiꞌ li li-imaniꞌ: Nadive. Lelikisi nene vete likineꞌ ve nolo-ledabe. ");
INSERT INTO aso_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Lutineꞌmi vele nene lamineꞌ like minidiniko lihime nene lengiꞌ okodida dizamidineꞌza lingine aka ninge none li zovoꞌ izi vaaꞌ nanako neꞌmo nene lihimetine ha neive. ");
INSERT INTO aso_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Izesuꞌ imineꞌ molo tiꞌ lo lineꞌ: Naza laminetoꞌ tiꞌ lo nolo-lingimuve: Ve ma ingine sipisipi izeliti gesi minguko dizilisa nene gatenguko dizami aka atota gesi goholouꞌ dizaaꞌ nave nene mo aꞌmine sipisipi gizebo veꞌine minami gizengize ve goloso nizave. ");
INSERT INTO aso_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Idoꞌ ve ma gatenguꞌ alineꞌ neꞌmo nene aꞌmine sipisipi izeliti gizebo ve gehepeve mineleseive. ");
INSERT INTO aso_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aꞌmine ve alineꞌ nene gatedoꞌ gizebo ve neꞌmo akahe siꞌze-davo dizo eiꞌ sipisipi izeꞌvela nene guliveꞌine ogo vise lavo eiꞌ noloꞌve nene lubamu gilikaꞌ gilikaꞌ igi ikevo ngeleꞌmizo lemo vo guvisela voloseive. ");
INSERT INTO aso_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Idoꞌ neꞌmine ogo eiꞌ sipisipi izeꞌve mukiꞌ ngeleꞌmizo lemo gomuꞌ molo-ngedo vavo eiꞌ noloꞌve nene lubamu gili nizaniꞌ nenako nemuꞌ nene eꞌmeti vaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ve gohiliti noꞌine nene lubamu gilamaaꞌ naniꞌ nenako nemuꞌ nene ve gohi nene ngeꞌmeti vami golise i-ngidilisave. ");
INSERT INTO aso_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Neꞌmine lo aneza gamazi nene Halisaioꞌ vesi eveneꞌ aꞌmida minavesi nene lo-ngimineꞌza ingine nene monovo nanitekumuꞌ lihe li gili guno amaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nemuꞌ nene imineꞌ molo Izesuꞌ tiꞌ lo lineꞌ: Naza nene mo laminetoꞌ gehepeve nolo-lingimuve. Sipisipi ize dizi ingaaꞌ aniꞌ gesiꞌmi gateni nene neniꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Olihe amuvo gomuꞌ ave mukiꞌ nene gizengize ve gumineloꞌ ve neꞌminevoꞌ minaniꞌza sipisipi ize nete ingine ma gili ngimamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ee, neniꞌ nene aꞌmine gesiꞌmi gateni nouvonako aꞌminguꞌ nenikuꞌ imi hili gesi minguko dizilizave mukiꞌ nene initeꞌ maliꞌmosi do goloso o-ngedamivo laminekovoꞌ minilisave. Neꞌmine igi mini dizi limi igi nosoꞌ niteꞌ ningi ni lamini minilisave. ");
INSERT INTO aso_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Idoꞌ gumine gizengizeloꞌ ve ingine hazamuꞌ ami asi gumine damine igi ngibili di goloso ilisavoꞌ igaꞌ nave. Neꞌmine igaꞌ naha neniꞌ uvoniꞌ nene neꞌmine olosa amo asi neniꞌ sipisipi izeꞌne nene minevoꞌ minevoꞌ ngemeni dameni nene ingine dalizaniꞌ votigile ivileꞌ ivosa lehize-ngedekuvo di tiꞌ igi lamini gehepevevoꞌ minilizave losa uvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Neniꞌ nene sipisipi izeloꞌ gizebo ve lamineꞌ gehepeve ma ne nouve. Sipisipi izeloꞌ gizebo ve lamineꞌ nete nene sipisipi izeꞌine di nguꞌ izilisa nene golise ami okoꞌine huli hililizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Idoꞌ monimuꞌ sipisipi izeloꞌ gizebo gono daaꞌ ave sipisipi meꞌninge minamaniꞌ nete nene loposo gulo navo ningilizaniꞌ nene sipisipi ize huli-ngidi golise vilisave. Neꞌmine ikevo aꞌmine loposo gulo nene ogo sipisipi ize ma belo geleleheꞌ o-do novivo sipisipi ize linge nene hutileꞌ igi vilisave. ");
INSERT INTO aso_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Idoꞌ sipisipiloꞌ gono dave huli-ngidi vilizaniꞌ nene nanitekumuꞌ ve. Ingine monimukovoꞌ gono di minisa sipisipi izeliti mulumoꞌine nene gilamaniꞌ nenako nemuꞌ nene huli-ngidi vilisave. ");
INSERT INTO aso_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Idoꞌ naza meꞌnehinemuꞌ ningo gele nouvo aza neniꞌ ningo gele neineꞌ neꞌmino naza nene sipisipi izeloꞌ gizebo ve lamineꞌ gehepeve nouvonako nemuꞌ nene naza sipisipi izeꞌne engikumuꞌ nene mo ningo gele nouvo ingine nenikumuꞌ nene ningi gili nizave. Idoꞌ naza engikumuꞌ nene neniꞌ okoꞌne hulolosuve. ");
INSERT INTO aso_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Idoꞌ neniꞌ sipisipi izeꞌne gohi ma nizave. Ingine nene Zuda ve lengiꞌ minaniꞌ gesi mingutiꞌ mene minamave. Engikisi nene do neꞌmete-ngedekuvo ingine nene neniꞌ noꞌne lubamu gililisave. Neꞌmine okuvo mulise hamoꞌ liliꞌ igi minikevo aꞌmidoꞌ gizebo ve nene mo hamoꞌ minelesuve. ");
INSERT INTO aso_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Idoꞌ naza neniꞌ minevoꞌ alevoꞌne hulo helelesa nouvoniꞌ nenako nemuꞌ nene meꞌneho lulo nemave. Idoꞌ minevoꞌ alevoꞌne huloloniꞌ nene gohi do tineꞌ molo dalosuve losa hulolosuve. ");
INSERT INTO aso_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Idoꞌ eveneꞌ nibili hilikevo minevoꞌ alevoꞌne hulo heleloniꞌ nene ingine nivileꞌ igi amuzo milalizadiꞌmo nomive. Asi neniꞌ luꞌneloꞌ do molo gele ngemekuvosa nene neꞌmine i-nidilisave. Idoꞌ meꞌneho neꞌmo nene neꞌmine iline lo-nede neineꞌ nenako nemuꞌ nene okoꞌne nene haza hulolosuve. Aꞌmine neꞌmine oloniꞌ amuzoꞌne nene do nouve. Idoꞌ aꞌmineꞌmine ogo minevoꞌ alevoꞌne gohi do tineꞌ molo daloniꞌ amuzoꞌne nesi nene do nouve lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gamazi neꞌmine lidiꞌmo nene Zuda veti luꞌine nene do sitaꞌ o-ngedavo gohi hizi hoꞌli minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Engikutiꞌ linge mukiꞌ nete tiꞌ li li minaniꞌ ve: Eiꞌ nene sikalahuꞌ goloso lulouꞌ minavo negi hizo gamazi gopo nolinguꞌ nene lingine aꞌmidoꞌ nene nanitekumuꞌ nigilave. ");
INSERT INTO aso_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Neꞌmine likevo linge nete tiꞌ li li minaniꞌ ve: Neꞌmine gamazi nene sikalahuꞌ goloso luꞌninguꞌ minive nete nene ma lisaꞌmave. Sikalahuꞌ goloso neꞌmo nene vele likiveꞌmi vele nene ngelo ma do lamineꞌ o-delihe. nGelo ma do lamineꞌ o-damoloseive. ");
INSERT INTO aso_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kilisimasi gameneloꞌ Zelusalemi numuno ebekuꞌ nene monoꞌ numuno naba gozopoꞌ biluvalite di goloso angutiꞌ di lamineꞌ angumuꞌ Zuda vete gili ngolize izi holiseꞌ minaaꞌ aniꞌ gamene ogavo idoꞌ hepeꞌ elaaꞌ ineꞌ gamene nesi nene mo omo neivo minanguꞌ nene ");
INSERT INTO aso_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Izesuꞌ aza monoꞌ numuno nabaꞌmi gesila heꞌ numuno naba gizikaniꞌ gulive Solomoniꞌ ve languꞌ nene nomonivo ");
INSERT INTO aso_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zuda ve naba nete igi di vodo vodo i-di mini tiꞌ li li-daniꞌ ve: Gaza gamene haꞌna geiꞌ monovoka do haleko nanivo laza gopo gate gele noneꞌ nene lo-lemamo lane. Gaza nene mo Oꞌmosoꞌmo do luꞌ izelesa gimiselelesa live noo ma nene lisiheꞌ ogo laminetoꞌ lo-lemevo. ");
INSERT INTO aso_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Neꞌmine likevo Izesuꞌ aza aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Naza nene mo lo-lingimuvoniꞌza lingine ma gili eleꞌvoleꞌ i-nidamaniꞌ ma neive. Naza meꞌnehi velemuꞌ ogo ogo molo nouvoniꞌ initeꞌ mukiꞌ neꞌmo nene neniꞌ monovoꞌne do sotoꞌ neiha ");
INSERT INTO aso_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","lingine nene neniꞌ sipisipi izeꞌne minamadiꞌmo nene gili eleꞌvoleꞌ amave. ");
INSERT INTO aso_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Neniꞌ sipisipi izeꞌne nete noꞌneloꞌ nene lubamu gili nimaaꞌ navo naza engiꞌ nene ningo gele nouvo ingine nene neniꞌ neꞌmetaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naza minevoꞌ minevoꞌ ngemeni dameni ngemekuvo ingine mo kekeꞌ vi tolovo igi hahasi mo amavo eveneꞌ malitesi ipeꞌ igi aꞌneutiꞌ ma di vamilisave. ");
INSERT INTO aso_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aꞌmine sipisipi izeꞌne do neniꞌ nimive meꞌneho nene initeꞌ mukiꞌ ngivileꞌ ogo naba goloso neinako eveneꞌ malitesi nene ipeꞌ igi anautiꞌ ma di vamilisave. ");
INSERT INTO aso_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Idoꞌ meꞌnehosi nazasi nene do bizo mo hamoꞌ gehepeve nosive. ");
INSERT INTO aso_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Neꞌmine lavo Zuda ve ingine bililisa geheni gohi nidavo ");
INSERT INTO aso_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Izesuꞌ tiꞌ lo lo-ngidineꞌ: Naza meꞌneho lidoꞌ eꞌmeto gono lamineꞌ ato atoꞌ mukiꞌ noduvo lingine ningikeve. Aꞌmine duvongutiꞌ nene nani gonomuꞌ geheni huli huliꞌ igi nibililisa nave. ");
INSERT INTO aso_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Neꞌmine lavo aꞌmidoꞌ nene Zuda ve ingine tiꞌ li li-imaniꞌ: Laza geheni gebelelesa nouneꞌ nene gono lamineꞌ daningumuꞌ nevoba asi Oꞌmoso ivileꞌ ilineꞌ gamazi laineꞌ nemuꞌ nene geheni gebelelesa noune. Nene nanitekumuꞌ ve. Gaza nene haza evenelike Oꞌmoso loloꞌ ogo gamazi laineꞌ nemuꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Lengiꞌ monoꞌ gamazitinguꞌ nene Oꞌmosoꞌmo eze gono dave lo-ngimineꞌ gamazi nene tiꞌ li gizi nizaniꞌ ve: Naza tiꞌ lo lo-lingiduve: Lingine nenitoꞌ medeli minaniꞌ nenako nemuꞌ lengikumuꞌ oꞌmoso ve nolo-lingiduve. ");
INSERT INTO aso_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Idoꞌ monoꞌ godolouꞌ gamazi nene gihile amo haza gamazi loloꞌ ilivoba asi gihile neineꞌ nenako aꞌmine Oꞌmosoꞌmo lineꞌ gamazi nesi nene gamazi gihile neive. Idoꞌ aꞌmine eze gamazi ngimive nene haza eveneꞌ minaniꞌza oꞌmoso nizave lo lo-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nemuꞌ nene engiꞌ ngivileꞌ ogo Oꞌmosoꞌmo do kegeso neleꞌmize molo me misubouꞌ nimiselive neniꞌ nene Oꞌmosoꞌmi gipele nouve luvongumuꞌ nene lingine Oꞌmoso ivileꞌ ilineꞌ gamazi lane nilahe. ");
INSERT INTO aso_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Idoꞌ lingine gilavo naza gono noduvoniꞌ nene meꞌneho daaꞌ idoꞌ do molo damuvo ma nene nenikumuꞌ gili eleꞌvoleꞌ amilizadoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Idoꞌ lingine gamaziꞌnelotikovoꞌ nenikumuꞌ gili eleꞌvoleꞌ amilizaniꞌ nolinekisi nene naza lamineꞌ meꞌneho daaꞌ idoꞌ do molo gono daaꞌ nouvoniꞌ nenako nemuꞌ nene aꞌmine gono daaꞌ nouvodotiꞌ nene nenikumuꞌ gili eleꞌvoleꞌ ilizadoꞌ o neive. Idoꞌ gonoꞌnelotiꞌ gili eleꞌvoleꞌ ilizave noluvoniꞌ nene lingine meꞌneho nene nenikisi neivo naza nene meꞌnehosi nouvoniꞌ nene gilii gili lamineꞌ igi minilizave losa noluve. ");
INSERT INTO aso_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Neꞌmine lavo ingine analoꞌ do goniꞌ o-delone li gohi neꞌmine ilisa aniꞌza Izesuꞌ aza engiꞌ vovoꞌningutiꞌ nene hulo-ngedo vavo ingine di aꞌninguꞌ milamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Neꞌmine ogo Izesuꞌ aza Zodani noso liko vo gomuꞌ Zohaneꞌ eveneꞌ noso holo-ngedo minineꞌ ebeta nene vo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Neivo eveneꞌ vaiꞌ nene ezela aniꞌ ve. Ingine tiꞌ li laniꞌ: Eveneꞌ linge noso holo-lidive Zohaneꞌ nene atoliꞌmine suno ma do sotoꞌ osaꞌmineꞌza aza aꞌmine ve meꞌmi monovo lo sotoꞌ ogo gamazi lineꞌ ma nene mo laminetokovoꞌ laaniꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Neꞌmine lisa aꞌmine ebekuꞌ nene eveneꞌ mukiꞌ Izesuꞌnimuꞌ gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania numudotiꞌ ve ma minineꞌ nene gulive Lasaloꞌ ve. Aꞌmine ve nene initeꞌ gize do minineꞌ. Idoꞌ alungo setaꞌ atelehoi alunoloi Maliaki Mataki nene makaꞌ hamoꞌ numudotiꞌ minasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Aꞌmine meuko guliveꞌve nouvoniꞌ Maliaꞌ Guvelesi veꞌmi gizeneloꞌ uveli lamineꞌ leke-do godolo zopovodunuꞌ gilite-dineꞌ alu nene initeꞌ gize dave Lasaloꞌ alunolo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Minineꞌ nenako alunolo setaꞌ ingine Izesuda gamazi tiꞌ li li hulasineꞌ: Guvekasi ve, gelezo. Gaza luka eme minanive ma nene initeꞌ gize dave. ");
INSERT INTO aso_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Idoꞌ Izesuꞌ nene aꞌmine gamazi gelosa tiꞌ lo lineꞌ: Initeꞌ gize daniꞌ nene mudise helelive losa nevoba asi Oꞌmosoꞌmi guvele monelive losasi idoꞌ nelotiꞌ nene Oꞌmosoꞌmi gipele neniꞌ nene di hozi li-nidilizangumuꞌ ve losasi nene initeꞌ gize daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Idoꞌ Izesuꞌ aza Mataꞌnisi alunolosi idoꞌ uvoꞌnibine Lasaloꞌnisi nene lulo ngeme minive minaniꞌza ");
INSERT INTO aso_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasaloꞌ initeꞌ gize dave li laniꞌ gamaziꞌve gilidotiꞌ nene gohi gamene sitaꞌ ma imineꞌ molo aꞌmine minineꞌ ebekuꞌ nene ha minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Neꞌmine ogo izipahala zuho alingeꞌ tiꞌ lo lo-ngimineꞌ ve: Laza Zudaia misubouko nene gohi vukeꞌzo. ");
INSERT INTO aso_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Neꞌmine lavo izipahala zuho ingine tiꞌ li laniꞌ ve: Tisazo, aꞌmida aizeꞌ aꞌmene Zuda vete geheni gibililisa aniꞌ ma nene gohi volone nolabe. ");
INSERT INTO aso_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Gamene hamokuꞌ hoꞌ loꞌmo do vo tuvelu (12) aua neꞌmida novivo aꞌmine tuvelu (12) aua nene olihe osuꞌ lamidoꞌ gono nene ha doꞌmo vo minelesune. Ve ma ingine labanaꞌ ele neivo aka monilizaniꞌ nene me misubouꞌ hize labanaꞌ elaaꞌ ive nene ningi nizaniꞌ nenako neꞌmo nene zodohoꞌ ngebelamivo ha aka monilisave. ");
INSERT INTO aso_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Idoꞌ ve ma ingine litiꞌmuso izavo aꞌminguꞌ monilizave nene inginela hize labanaꞌ ele-ngedeli labanaꞌ nomineꞌ nenako neꞌmo nene mo zodohoꞌ izilisave. ");
INSERT INTO aso_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Neꞌmine lo gohi imineꞌ molo tiꞌ lo lineꞌ: Leliꞌ zogo ve Lasaloꞌ aza nene mo ongo neive. Naza nene uꞌmukoꞌ olosa volosuve. ");
INSERT INTO aso_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Neꞌmine lavo izipahala zuho ingine tiꞌ li li-imaniꞌ: Guvekasi ve, aza okise ongo nolineꞌ nene alingeꞌ lamineꞌ geleleseive laniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Izesuꞌ aza ongo neive lineꞌ nene mo hilingumuꞌ lineꞌza ingine gilaniꞌ nene ha okise ongangumuꞌ lihe li gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nemuꞌ nene Izesuꞌ aza lo ngoloꞌ lo tiꞌ lo lo-ngimineꞌ: Lasaloꞌ nene mo hele neive. ");
INSERT INTO aso_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Idoꞌ naza hilineꞌ gameneuꞌ ezesi minamuvoniꞌ nene lamineꞌ ve lo gele nouve. Nene nanitekumuꞌ ve. Lingine Lasaloꞌ hilidotiꞌ nene nenikumuꞌ gili eleꞌvoleꞌ ikevo lengiꞌ hize eleꞌ o-lengedeleseive losa nemuꞌ nene naza minamuvoniꞌ nene lamineꞌ ve lo gele nouve. Neꞌmine nouvoniꞌza aꞌmine Lasaloda nene vukeꞌ nalo. ");
INSERT INTO aso_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Neꞌmine lavo lobeꞌ izipe ve lave Tomasiꞌ aza Izesuꞌ izipahala gonolomotine tiꞌ lo lo-ngimineꞌ: Lazasi Izesuꞌnisi nene libili hililizangisi makatoꞌ lazasi vukeꞌzo. ");
INSERT INTO aso_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Idoꞌ Izesuꞌ Nene Lasaloꞌ numuꞌvela vo hetelavo Lasaloꞌni galese ize-dekunivo mo gamene setaꞌ ve setaꞌ ve minave li likevo ningo gilineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Idoꞌ aꞌmine Betania numuno ebeꞌ nene Zelusalemi numuno ebetotiꞌ tuu (2) maili (tili kilomita) neꞌmino avita minineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Neꞌmino neivo Zuda ve vaiꞌ nene Maliaki Mataki uvoꞌnibo hilingumuꞌ nene mulumoꞌine gili ive nama i-ngidi di lamineꞌ i-ngidilisa vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Idoꞌ Izesuꞌ nene nave li-imikevo Mataꞌ aza oto akaloꞌ navo voteneꞌ o-delesa vineꞌza Maliaꞌ neve nene numunguko minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mataꞌ aza Izesuꞌ naada vo hetelo tiꞌ lo lo-imineꞌ ve: Guvekasi ve, geiꞌ nene mela ogo minanidoꞌ neidiniko uvoꞌneho helamidine. ");
INSERT INTO aso_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ne neiha idisesi nene Oꞌmosola nanitekumuꞌ longoꞌ o-delibe ha gele gemeleseive lo gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Uvaho nene gohi vele gizo oteleseive. ");
INSERT INTO aso_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Neꞌmine lavo Mataꞌ tiꞌ lo lo-imineꞌ: Ee, alingeꞌ gamene nabala eveneꞌ hilaniꞌ otilizaniꞌ gameneuꞌ nene azasi oteleseive losa gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Neniꞌ neve nene helaakutiꞌ otaakisi idoꞌ minevoꞌ minevoꞌ ogakisi do sotoꞌ uve nene nouve. Nenikumuꞌ gili eleꞌvoleꞌ igi minilizave mukiꞌ nene hililizaha nesi nene ha gohi miniviꞌ miniviꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ee, idoꞌ ve ma ingine miniviꞌ aliviꞌ igi mini nenikumuꞌ gilii gili eleꞌvoleꞌ igi minilizave mukiꞌ nene mo mudise hili osuꞌ lami miniviꞌ miniviꞌ igivoꞌ minilisave. Gamazi mene noluvongumuꞌ nene gele eleꞌvoleꞌ abe amane. ");
INSERT INTO aso_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Neꞌmine lavo Mataꞌ aza tiꞌ lo lo-imineꞌ: Guvekasi ve, naza mo gele eleꞌvoleꞌ o nouve. Geiꞌ nene Oꞌmosoꞌmo do luꞌ izelesa gimiselelesa live eiꞌ gipele me misubouꞌ aloseive lave ma nene nane losa gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Neꞌmine lo Mataꞌ aza tineꞌ molo ogo atelehine Maliaꞌni vise lo do abazaꞌ o-do zegeno tiꞌ lo lo-imineꞌ: Maliazo, Tisaꞌ nene mo omo mino geikumuꞌ nolive. ");
INSERT INTO aso_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Neꞌmine lavo gelo oto aꞌmine neida vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Izesuꞌ nene Maliale Matale numuꞌine ebeꞌninguꞌ olihe ogo hetelamo Mataꞌ vo voteneꞌ o-dineꞌ ebeta nene havoꞌ minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Idoꞌ Zuda aleve igi Maliaꞌni mulumo gili-di ive nama igi eleꞌmizi minaniꞌ aleve ingine Maliaꞌ liteꞌ lo oto numungutiꞌ lemo vineꞌ nene ningi gonoso galesela vo ive nama olosa novive li eꞌmeti vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Neꞌmine navo Maliaꞌ nene Izesuꞌ neida vo hetelo eze ningo gizeneuꞌ golo hizo noongo tiꞌ lo lineꞌ ve: Guvekasi ve, geiꞌ nene mela ogo minanidoꞌ neidiniko uvoꞌneho nene helamidine. ");
INSERT INTO aso_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Neꞌmine lo ive ogo neivo idoꞌ ezesi ave nesi nene ive navo nene ningo lulosi mutuhavo Izesuꞌ gisingisi molo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Neꞌmino mino lingine Lasaloꞌni nene zala mili-di nizave lavo ingine tiꞌ li laniꞌ: Guvekasi ve, gaza nene ningelinge. Ano. ");
INSERT INTO aso_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Neꞌmine nilavo Izesuꞌni nene vele novozo doꞌmozineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Neꞌmine neivo aꞌmida Zuda ve minaniꞌ nete nene tiꞌ li laniꞌ ve: Aizoo, ve meꞌmo Lasaloꞌni nene atoliꞌmine ogo lulo eme minaaniꞌ neineꞌ ningiꞌ nalo. ");
INSERT INTO aso_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Neꞌmine laniꞌza linge ma nete nene tiꞌ li laniꞌ ve: Ve meve nene vele like minive ma do lamineꞌ o-de neineꞌ nenako hilive mene helamilive lo initeꞌ ma o-delinako neꞌmine amivo helave. ");
INSERT INTO aso_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Izesuꞌ nene gohi gisingisi moloꞌmo gonoso galesela aniꞌ ve. Aꞌmine gonoso galese nene geheni mulikuꞌ neivo gatedoꞌ nene geheni naba di tilikavo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aꞌmine geheni nene di hulilo lo Izesuꞌ lavo Mataꞌ aꞌmine hiliveꞌmi alunolo neꞌmo tiꞌ lo lineꞌ ve: Guvekasi ve, aꞌmine ve nene gamene setaꞌ ve setaꞌ ve neꞌmine minaaniꞌ nenako idise nene unuvo goloso oloseive. ");
INSERT INTO aso_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Gaza gele eleꞌvoleꞌ ilineꞌ nene Oꞌmosoꞌmo amuzoꞌve do sotoꞌ ilineꞌ ningelesane lo lo-gimuhe lo-gemamuvoniꞌ neve. Gaza gele eleꞌvoleꞌ ozo. ");
INSERT INTO aso_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Neꞌmine lavo aꞌmine gonoso galeseloꞌ geheni naba tilikaniꞌ nene di hulikevo Izesuꞌ aza vokeneꞌ ogo veleta ningo tiꞌ lo lineꞌ: Ahono, gaza gele nemaningumuꞌ nene isaaꞌ neve lo geita noluve. ");
INSERT INTO aso_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gaza gamene gamene gele nemaaꞌ naineꞌ nene naza ha gele nouha eveneꞌ mene nizaniꞌ nete neniꞌ nene geiꞌ nimiselane li gili eleꞌvoleꞌ ilizave losa engikumuꞌ nene mene gamazi nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Neꞌmine lo nolo nabautiꞌ tiꞌ lo vise lineꞌ: Lasaloo, neutiꞌ nene heta lemo ano. ");
INSERT INTO aso_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Neꞌmine lavo aꞌmine hilive nene banisi neꞌminedunuꞌ asabuꞌ izimikaniꞌ minineꞌ nene leme hetoꞌ ineꞌ ve. Neꞌmine ogavo Izesuꞌ aza aꞌmine initeꞌ nene apasi di huli-dilo. Vilize. Tiꞌ lavo neꞌmine i-daniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Neꞌmine ogavo Maliaꞌ neida aniꞌ Zuda ve linge mukiꞌ nene ingine Izesuꞌ initeꞌ ineꞌ nemuꞌ nene ningi ezemuꞌ gili eleꞌvoleꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Neꞌmine aniꞌza linge ma nete nene Halisaioꞌ ve nizada vi Izesuꞌ ineꞌ initeꞌ nemuꞌ nene li-ngimaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Neꞌmine ikevo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ Halisaioꞌ vesi nene Zuda veti kanisole ve naba linge minaniꞌ nene vise li di nubo i-ngidi tiꞌ li laniꞌ: Aꞌmine ve nene atoliꞌmine suno vaiꞌ nodangumuꞌ nene nadiꞌ o-deꞌ nalone. ");
INSERT INTO aso_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Laza ninge mate-dekunivo neꞌmine o do vo minelineꞌ nene eveneꞌ mukiꞌ ingine ezemuꞌ gili eleꞌvoleꞌ igi eꞌmetilisave. Neꞌmine ikevo Loma ve nete nene igi leliꞌ monoꞌ numuno nabate nesi idoꞌ Zuda ve mukiꞌ leliꞌ nesi nene di goloso i-lidilisave. ");
INSERT INTO aso_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Neꞌmine likevo engikutiꞌ ve ma aꞌmine kilisimasiuꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveti ve nabaꞌine minive Kaiahaꞌ aza Loma ve igi libilikelizave lo gelo tiꞌ lo lo-ngimineꞌ ve: Lingine negi nizahe. ");
INSERT INTO aso_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Zuda ve mukiꞌ hilikilizave lo belekunivo eveneꞌ mukitoꞌ medelo aꞌmine ve hamokovoꞌ helelineꞌ nene lamineꞌ o neineꞌ ma gilamaniꞌ nehe. ");
INSERT INTO aso_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Idoꞌ Kaiahaꞌ neꞌmine lineꞌ nene asiꞌve galatiꞌ gelo lamive. Asi aza aꞌmine kilisimasiuꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveti ve nabaꞌine minidiꞌmo ve losa Oꞌmosoꞌmi veletiꞌ gamazi nene polohete laaꞌ aniꞌ neꞌmino Izesuꞌ Zuda ve mukikumuꞌ helelineꞌ o neineꞌ nemuꞌ lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Idoꞌ helelineꞌ ogavo hilineꞌ nene Zuda ve mukiꞌ engikumukovoꞌ nevoba asi Oꞌmosoꞌmi izipahala mukiꞌ ato atoꞌ ebekuꞌ miniꞌmi monave nene do hamoꞌ zuho loloꞌ o-ngedelingumukisi nene helelineꞌ ogavosa hilineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Idoꞌ nelotiꞌ nene Izesuꞌni bililiza akamuꞌ viseꞌ igi lovo gizi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Neꞌmine igi minaniꞌ nenako nemuꞌ nene Izesuꞌ aza gohi Zuda vetinguꞌ sotoꞌ mino monamilidoꞌ ogavo aꞌmine minineꞌ ebeꞌ nene hulo vo misubo hadive neꞌmi gahevela numuno ebeꞌ ma gulive Ehelaimi nela vo izipahala zuhosi aꞌmida vi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Idoꞌ Aigita misubouꞌ minaniꞌ gameneloꞌ nene Oꞌmosoꞌmo avoꞌningine iseꞌine izingumuꞌ gili Zuda ve nosoꞌ niteꞌ ni holiseꞌ minaaꞌ aniꞌ gamene nene avitoꞌ ogavo eveneꞌ mukiꞌ Zelusalemi numuno ebeliꞌmi gahevela miniꞌmi monaniꞌ nene aꞌmine gamene alingumuꞌ nene Oꞌmosoꞌmi veleloꞌ nene goloso niteꞌine nomivo lamineꞌ minilisa ingine igaꞌ naniꞌ niteꞌ neꞌmine nene olone li aꞌmine Zelusalemi ebekuꞌ nene vi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Neꞌmine igi monoꞌ numuno nabauꞌ vi minanguꞌ nene engikuꞌ tiꞌ li longoꞌ igi minaniꞌ ve: Izesuꞌ nene holiseꞌ gamene noalitinguꞌ nene mela ngelo amoloseive. Nemuꞌ lingine nadive li gili nizave. ");
INSERT INTO aso_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave nabasi idoꞌ Halisaioꞌ ve nesi nene Izesuꞌnimuꞌ gamazi tiꞌ li li hukikaniꞌ ve: Analoꞌ daloneꞌ nenaze. Eze minineꞌ ebekumuꞌ nene ve ma gele nolineꞌ nene aza ogo lo sotoꞌ ogo lo-lemelive. ");
INSERT INTO aso_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Izesuꞌ nene Oꞌmosoꞌmo iseꞌine izingumuꞌ gili mini nosoꞌ niteꞌ naaꞌ holiseꞌ nene alosa gamene sigisi (6) neꞌmine nene ha neivo hilingutiꞌ gohi do ote-dive Lasaloꞌ minida Betania numuno ebeꞌ nela nene vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aꞌmida neivo nosoꞌ niteꞌ gize vataꞌ i-daniꞌ nene Mataꞌ do vaꞌvaꞌ ogo do ngeme ngemeꞌ gono do neivo aꞌminguꞌ Lasalokisi makaꞌ mino nosoꞌ niteꞌ no minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Neꞌmini nizavo Maliaꞌ nene okoꞌnidoꞌ hilaaꞌ aniꞌ uveli meniꞌve dize minineꞌ uveli nalida guvisedunuꞌ gehepeve liliꞌ aniꞌ uveli nene botoloꞌ naba gidini ma do ogo Izesuꞌ gizeneloꞌ leko holo-dosa godolo zopovodunuꞌ nene gilite-dineꞌ ve. Neꞌmine neivo aꞌmine uveliꞌmi unuvo lamineꞌ nene numunguꞌ bizo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Neꞌmine ogavo izipahala zuhoutiꞌ alingeꞌ Izesuꞌni biluvaliti aꞌninguꞌ molave Kelioto numudotiꞌ ve Zudaꞌ nene tiꞌ lo lineꞌ ve: ");
INSERT INTO aso_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Aꞌmine uveli meve nene sigisi hadeti kina (K600) neꞌmidoꞌ maketi mili moni di gohoꞌ gahaliꞌ aleve ngimilizanako neꞌmine amave. ");
INSERT INTO aso_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Zudaꞌ aza neꞌmine gamazi lineꞌ nene gohoꞌ gahaliꞌ alevemuꞌ nene mulumoꞌine gelosa lamive. Asi aza nene engiꞌ moni milaniꞌ beniloꞌ gizebo ve mino gumineloꞌ ve minineꞌ nenako aꞌmingutiꞌ nene do halekeꞌ halekeꞌ ogo minaaꞌ ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Idoꞌ Zudaꞌ neꞌmine lavo Izesuꞌ tiꞌ lo lineꞌ ve: Lihiteheka lo-damozo. Aꞌmine uveli mene do minineꞌ nene galese izi-nidilizaniꞌ gamenemuꞌ nene holo-nedelove losa do minelineꞌ ogavosa do minosa holo-nedave. ");
INSERT INTO aso_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Neꞌmine ineꞌ nene lingine gohoꞌ alevesi nene ha mini di vi minikelizaha nezesi nene mudive ma mine do vamolosunako aza ineꞌ initeꞌ nene mo lamineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zuda ve vaiꞌ goloso nene Izesuꞌ Betania numuno ebekuꞌ neive laniꞌ nemuꞌ nene gilii aꞌmida nene vaniꞌ ve. Idoꞌ aꞌmida vaniꞌ nene Izesuꞌnivoꞌ ningilisa vaniꞌ nevoba asi hilingutiꞌ do ote-dive Lasaloꞌni nesi nene ningelone lisa vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Aꞌmine Lasaloꞌnimuꞌ nene eveneꞌ mukiꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba nene meheꞌine ngimi Izesuda vi giꞌmizikaꞌ giꞌmizikaꞌ igi minaniꞌ nenako nemuꞌ nene aꞌmine evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ ave naba ingine Lasaloꞌni nene belelone li gamazi di hamoꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Goꞌ losa gohi gamene ogavo eveneꞌ vaiꞌ goloso nene Oꞌmosoꞌmo avoꞌningine iseꞌine izineꞌ holiseꞌ minilisa aniꞌ nene Izesuꞌ Zelusalemi numuda mene nave likevo gili ");
INSERT INTO aso_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","zavile davile ledi di vi numuno ebekutiꞌ gesi heta limi igi akaloꞌ naada nene vi voteneꞌ igi gamazi nabautiꞌ tiꞌ li laniꞌ ve: Geikumuꞌ gopoꞌni nolunize. Guvetesi ve Oꞌmosoꞌmi velemuꞌ anive Isilaeleꞌ aleve leliꞌ Guvetesi ve naba geiꞌ nene Oꞌmosoꞌmo noꞌnohoꞌ ize-gidivoo. ");
INSERT INTO aso_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Idoꞌ Izesuꞌ aza dongi ize ma mo ningo Monoꞌ Godolouꞌ gizi nizaniꞌ neꞌmine ogo aꞌmidoꞌ dizo mino vineꞌ ve. Aꞌmine Monoꞌ Godolouꞌ gamazi nene tiꞌ lo neive: ");
INSERT INTO aso_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Zaioni golola minave Zelusalemi alevekizo, golise gilikiliꞌ ami longolize izilo. Lingine giliꞌ nalo. Guvetinesi ve naba ma nene dongi ize olihe lodive olosa neidoꞌ nene meheneloꞌ mino lengita nave. ");
INSERT INTO aso_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Izesuꞌ neꞌmino numunguꞌ dizo vineꞌ nemuꞌ nene izipahala zuho ingine nene Monoꞌ Godolouꞌ minineꞌ gamazi maloꞌ nene eꞌmetosa neꞌmine neive li aꞌmine gameneuꞌ nene ma gili vevesami minaniꞌza asi Izesuꞌ nene Okulumokuꞌ moꞌmosiꞌvela dizavosa alingeꞌ nene Monoꞌ Godolouꞌ neꞌmine oloseive li gizaniꞌ minineꞌ mamuꞌ nene gilisa laza mo aꞌmine maloꞌ eꞌmeto okuneꞌ neive li gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Idoꞌ eveneꞌ ingine Izesuꞌni voteneꞌ ilisa vaniꞌ nene eveneꞌ vaiꞌ Lasaloꞌni hilingutiꞌ do noote-do gonoso galeseutiꞌ vise lo do heta noo-divo aꞌmida makaꞌ minave ingine nete nene aꞌminemuꞌ li sotoꞌ sotoꞌ ikevo nemuꞌ nene atoꞌ suno meꞌmine ogave li gilaniꞌ nenako nemuꞌ nene eze voteneꞌ ilisa giliisa vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Neꞌmine igi vaniꞌ nene Halisaioꞌ ve ingine ningi tiꞌ li li voleloꞌ meloꞌ aniꞌ ve: Lingine ningahe. Laza eiꞌ ivileꞌ amoloneꞌ ogave. Eveneꞌ vaiꞌ goloso nene mo eikovoꞌ eꞌmeti vikeve. ");
INSERT INTO aso_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Idoꞌ Oꞌmosoꞌmo Zuda ve iseꞌine izineꞌ holiseꞌ mini Oꞌmoso opoꞌni li minilisa Zelusalemi numuda dizi minaveuꞌ nene nGiliki ve ma minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aꞌmine ve nete nene nGalilaia misubouꞌ Betesaida numudotiꞌ ve Hilipoꞌ neida igi tiꞌ li laniꞌ ve: Ve melo, laza nene Izesuꞌni ninge-delesa noune. ");
INSERT INTO aso_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Neꞌmine likevo Hilipoꞌ aza voosa Adeleaꞌni lo-emavo ingine di bizi makatoꞌ vi Izesuꞌni li-imasineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Li-imikesivo aꞌmidoꞌ Izesuꞌ tiꞌ lo lo-ngimineꞌ: Oꞌmosolatiꞌ ve gihile neniꞌ nene di hozi li-nidikevo Guveꞌnesi ve mineloniꞌ gamene nene mo avitoꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Neꞌmine lo eitoꞌ lo molo tiꞌ lo lineꞌ: Naza laminetoꞌ gehepeve tiꞌ lo nolo-lingimuve: Viti zuho gihile hamoꞌ ma misubouꞌ lemo helamilineꞌ nene gihile izamo hazavoꞌ mineleseive. Neꞌmine oloseineꞌza misubouꞌ lemo helelidotiꞌ nene gihileꞌve vaiꞌ izeleseive. ");
INSERT INTO aso_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Idoꞌ ve ma ingine minevoꞌ alevote hulalone li ingine di aꞌmanapa igi minaaꞌ nave nete nene aꞌmine minevoꞌ alevoꞌine nene di goloso igi di hulaaꞌ naha ve ma ingine minevoꞌ alevoꞌine di aꞌmanapa amaaꞌ ave nete nene hulami ha di mini miniviꞌ miniviꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ve ma ingine neniꞌ gonoꞌneloꞌ gelekeleꞌ ilisa ilizave nene neniꞌ mo neꞌmetaakovoꞌ ilizadoꞌ o neive. Neꞌmine igi mini ingine nene naza zaala zaala minelohe inginesi nene makakovoꞌ minilisave. Ve ma ingine neniꞌ gonoꞌneloꞌ gelekeleꞌ ilizave mukiꞌ nene neniꞌ meꞌnehoꞌmo do naba o-ngedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Naza idise nene nemeni balala nolive. Nemuꞌ nene nadive lolove. Ahono, nenita initeꞌ sotoꞌ olosa neineꞌ nene do olovoꞌ ogo do nuꞌ izezo lolohe. Oꞌove. Naza nene aꞌmine sotoꞌ o-nedelesa neineꞌ initeꞌ nene gehelesa uvoniꞌ nenako mo ma lamolodoꞌ o noolive. ");
INSERT INTO aso_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nemuꞌ nene Ahono, geze guliveka nene do hozi nolozo. Neꞌmine lavo Okulumokutiꞌ gamazi ma tiꞌ lo lineꞌ ve: Naza guliveꞌne nene mo do hozi lokuze. Mo gohi do hozi lolosuve. ");
INSERT INTO aso_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Neꞌmine lavo aꞌmida gili minaniꞌ aleve mukiꞌ ingine nete nene mo goꞌ ngilili logave li laniꞌza linge ma nete nene tiꞌ li laniꞌ: Aꞌmine neve nene angeloliꞌmo gamazi lo-imineꞌ ve laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Gamazi mene lineꞌ nene nenikumuꞌ lamive. Asi lengikumuꞌ lineꞌ ma ne neive. ");
INSERT INTO aso_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Idise melotiꞌ nene Oꞌmosoꞌmo me misubouꞌ aleve nene lihime ngemelesa apiꞌ ogo izeꞌ nomolo-ngidive. Neꞌmine noogo me misubouꞌ guvelesi ve loloꞌ ogo minive Satani nene imiselo do nohulive. ");
INSERT INTO aso_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Idoꞌ misuboutiꞌ mene neniꞌ di oti-nidilizaniꞌ nene naza eveneꞌ mukiꞌ nene do nenita olosuve. ");
INSERT INTO aso_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Neꞌmine gamazi lineꞌ nene eiꞌ helelineꞌ monovo nene do sotoꞌ ogosa lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Neꞌmine lavo eveneꞌ mukiꞌ nete tiꞌ li laniꞌ ve: Leliꞌ louꞌ gamazite Monoꞌ Godolouꞌ neineꞌ neꞌmo nene Oꞌmosoꞌmo do luꞌ izelesa imiselelesa live nene helamo minevoꞌ minevoꞌ oloseive lavo gele noneꞌ nenako gaza aꞌmine Oꞌmosolatiꞌ ve gihile nene di oti-dilizaniꞌ o neive laineꞌ nene zahinemuꞌ lane. ");
INSERT INTO aso_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Labanaꞌ neꞌmo nene lengiꞌ vovotinguꞌ gamene liꞌnibevoꞌ mine molo mineleseive. Litiꞌmuso neꞌmo molo hite-lengedavo minikelizave. Lengitoꞌ labanaꞌ omo neidoꞌ nene ningi monilo. Nanitekumuꞌ ve. Eveneꞌ litiꞌmuso lulouꞌ aka monaaꞌ ave nene neꞌmine akaloꞌ novune li ningi gilamave. ");
INSERT INTO aso_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Labanaꞌ lengemeni damenisi minilizangumuꞌ ve li labanaꞌ lengikuꞌ ha neidoꞌ nene aꞌmine labanakumuꞌ gili eleꞌvoleꞌ igi minilo. Neꞌmine lo engikisi gohi minelesa gelamo vo halekineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Idoꞌ neꞌmine ogo Zuda ve hulo-ngedo vo halekineꞌ nene aza engiꞌ vovoꞌninguꞌ nene atoliꞌmine suno vaiꞌ do sotoꞌ inekisi ningi ingine ezemuꞌ nene ma gili eleꞌvoleꞌ amaniꞌ nenako nemuꞌ nene vo halekineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Idoꞌ ingine ezemuꞌ gili eleꞌvoleꞌ amaniꞌ nene polohete Isaiaꞌ gizineꞌ gamazi ma nene gihile izelingumuꞌ ve losa gili eleꞌvoleꞌ amaniꞌ ve. Aꞌmine gamazi nene neꞌmino gizineꞌ ve: Guvekasi ve, Geiꞌ lo-lemaineꞌ gamazi lo-ngimuneꞌ nene eveneꞌ hamolitesi nene ma gili eleꞌvoleꞌ amave. Ee, Guvelesi veꞌmo eiꞌ amuzoꞌve do sotoꞌ ineꞌ nene eveneꞌ hamolitesi ma ningi gilamaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Idoꞌ ingine ngeli gili eleꞌvoleꞌ ilizadoꞌ amaniꞌ monovo Isaiaꞌ lo sotoꞌ ogo gamazi gohi ma tiꞌ lo gizineꞌ ve: ");
INSERT INTO aso_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Guvelesi ve neꞌmo nene luꞌineꞌmi vele do like-ngedo luꞌineꞌmi gala nesi nene do ngi lo-ngidineꞌ ve. Idoꞌ neꞌmine ineꞌ nene luꞌineꞌmi vele ninge minivo idoꞌ luꞌineꞌmi gala nene gele hehe lo minivo minisa luꞌine di velepeꞌ izilizaniꞌ nene naza do lamineꞌ o-ngedalove losa neꞌmine ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiaꞌ neꞌmine lo gizineꞌ nene Guvelesi ve Okulumokuꞌ minineꞌ moꞌmosiꞌveloꞌ emeni dameni lamineꞌ atoliꞌminesi miningumuꞌ nene ningosa nemuꞌ nene gizineꞌ ve. Idoꞌ aꞌmine nene Izesuꞌnimuꞌ loganiꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Neꞌmino neiha Zuda ve naba minangutiꞌ mukiꞌ nesi nene ezemuꞌ gili eleꞌvoleꞌ aniꞌza ingine eveneꞌ engiꞌ di hozi li-ngidilizangumuꞌ laniteꞌ gilaniꞌ nene ivileꞌ ogavo Zuda ve leliꞌ muliseutiꞌ huli heta i-lidikelizave li Halisaioꞌ vemuꞌ golise gili aꞌmine Izesuꞌnimuꞌ gili eleꞌvoleꞌ aniꞌ nene ma li sotoꞌ amaaꞌ aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nelotiꞌ Izesuꞌ gamazi nabautiꞌ tiꞌ lo lineꞌ: Ve ma ingine nenikumuꞌ gili eleꞌvoleꞌ igaꞌ nave nene nenikumukovoꞌ gili eleꞌvoleꞌ navoba aꞌminguꞌ nene mo nimiselive eikumukisi nene gili eleꞌvoleꞌ igaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Idoꞌ ve ma ingine neniꞌ ningi minaaꞌ nave nene nenikovoꞌ ningi minaaꞌ navoba aꞌminguꞌ nene mo nimiselive nesi nene ningaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naza me misubouꞌ uvoniꞌ nene labanaꞌ neꞌminosa uvoniꞌ nene ve ma ingine nenikumuꞌ gili eleꞌvoleꞌ igaꞌ nave mukiꞌ nene litiꞌmuso monovouꞌ mini mili minikelizave losa uvoniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Idoꞌ ve ma ingine neniꞌ laaꞌ nouvoniꞌ gamazi gilisa gili dami minaaꞌ nave nene naꞌniseꞌne lihime ngemesaꞌmuve. Ee, naza me misubouꞌ uvoniꞌ nene eveneꞌ izeꞌ molo-ngedo lihime ngemelesa amo do nguꞌ izelesa uvoniꞌ nenako nemuꞌ nene naꞌniseꞌne lihime ngemesaꞌmuve. ");
INSERT INTO aso_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Asi aꞌmine neniꞌ meheꞌine nimi gamaziꞌnesi gili dami minilizave izeꞌ molo-ngedelive ma neineꞌ nene neniꞌ gamazi luvoniꞌ neꞌmo nene alingeꞌ gamene nabala izeꞌ molo-ngedavo lihime dalisave. ");
INSERT INTO aso_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aꞌmine gamaziꞌne laaꞌ nouvodiꞌmo izeꞌ molo-ngedeleseive luvoniꞌ nene nanitekumuꞌ ve. Aꞌmine gamazi nene naꞌnise gaꞌneutiꞌ laaꞌ nouvoba asi nimiselive meꞌneho neꞌmo nene mo lilinidoꞌ o neive lineꞌ gamazivoꞌ nene laaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Meꞌneho lo-nidineꞌ gamazi laaꞌ nouvoniꞌ nene eiꞌ gamaziꞌve neꞌmo minevoꞌ minevoꞌ minaaꞌ monovo do sotoꞌ ogaꞌ neive lo gele nouvodiꞌmo nene aꞌmine gamazi laaꞌ nouvoniꞌ mukiꞌ nene meꞌneho lo-nimineꞌ gamazi gehepevevoꞌ nene laaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Zuda ve Oꞌmosoꞌmo avoꞌningine iseꞌine izingumuꞌ gili holiseꞌ minaaꞌ aniꞌ gamene nene alitelesa gamene hamoꞌ ha neivo Izesuꞌ aza me misubo hulosa melehida vilineꞌ gamene nene mo ogave lo gala gilineꞌ ve. Eze evenele me misubouꞌ minaniꞌ lulo ngimineꞌ nene atoliꞌmine ogo ngemo helelineꞌ nesi nene ivileꞌ ivosa minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Idoꞌ nivengaꞌ molavo nosoꞌ niteꞌ ni nizavo Kelioto numudotiꞌ ve Simoniꞌ gipele Zudaꞌni nene Izesuꞌni biluvalite dalizangumuꞌ do sotoꞌ o-delineꞌ gamazi nene Satani neꞌmo do lulouꞌ molo-davo neivo ");
INSERT INTO aso_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Izesuꞌ aza meleho initeꞌ mataꞌ eiꞌ anauꞌ molo neineꞌ nesi idoꞌ eiꞌ nene Oꞌmosolatiꞌ ogosa Oꞌmosola volosa neineꞌ nesi nene gele mino ");
INSERT INTO aso_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","nosoꞌ niteꞌ no miningutiꞌ nene oto saketiꞌve apaso do molo tauli do gopololoꞌ izineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Neꞌmine ogo lapese mauꞌ noso lekosa apiꞌ ogo izipahala zuholiti gizeꞌine nosoꞌ izekaꞌ izekaꞌ ogo gopololoꞌ likekineꞌ taulidunuꞌ nene gilite ngimikaꞌ gilite ngimikaꞌ oꞌmo vineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Neꞌmine ogo nosoꞌ ize-ngedeꞌmo novo Simoni Petolodoꞌ ogavo aza tiꞌ lo lo-imineꞌ: Guvekasi ve, geiꞌ nene neniꞌ gizeꞌne nene nosoꞌ ize-nedelesa nabe. ");
INSERT INTO aso_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Naza mene ogo molo nouvoniꞌ initeliꞌmi monovo nene idise mene mo gelamaneꞌza alingeꞌ nene gele hehe lolosane. ");
INSERT INTO aso_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Neꞌmine lavo Petoloꞌ tiꞌ lo lo-imineꞌ: Geiꞌ nene mo kekeꞌ gizeꞌneloꞌ nene nosoꞌ izo gilite-nedamozo. Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Idoꞌ geiꞌ nene ma nosoꞌ ize-gedamoloniꞌ nene neniꞌ eveneꞌne zuholiti muliseutiꞌ minamolosane. ");
INSERT INTO aso_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Neꞌmine lavo Simoniꞌ Petoloꞌ aza tiꞌ lo lo-imineꞌ: Gaza neꞌmine lo ma nene gizeꞌnevoꞌ nene nosoꞌ ize-nedamo aꞌnelasi maduꞌneukisi nene nosoꞌ ize-nedezo. ");
INSERT INTO aso_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Nosouꞌ ongosa minelive neꞌmo nene okoꞌno mukiꞌ nene mo guluviꞌ lo neivo akala adotiꞌ uꞌmusupo giꞌmize minelineꞌ nemuꞌ nene gizenelokovoꞌ nosoꞌ izelidoꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Lengiꞌ nene mo guluviꞌ li lamineꞌ nizaha lengiꞌ vaitoꞌ nene neꞌmine amave. Vaitoꞌ guluviꞌ amave lineꞌ nene eze biluvaliti aꞌninguꞌ do molo-delivemuꞌ nene ha gele minineꞌ nenako nemuꞌ live. ");
INSERT INTO aso_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gizeꞌnidoꞌ nene nosoꞌ izo gilito osuꞌ lo-ngedo saketiꞌve nene do izo gohi mitoꞌ minosa tiꞌ lo lo-ngimineꞌ: Lingine idise o-lingiduvoniꞌ initeliꞌmi monovo nene gilahe gilamave. ");
INSERT INTO aso_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lingine nenikumuꞌ nene Tisaꞌ ve idoꞌ Guvekasi ve ve li li-nidaaꞌ nave. Idoꞌ naza nene mo neꞌmine ve nouvoniꞌ nenako neꞌmine li-nidaaꞌ naniꞌ nene mo laminetoꞌ gehepeve li-nidaaꞌ nave. ");
INSERT INTO aso_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Idoꞌ neniꞌ nene tisatine neꞌminesi idoꞌ Guvetinesi ve neꞌminesi minuvodiꞌmine naza gelekeleꞌ izipe neꞌmine loloꞌ ogo gizedidoꞌ nene nosoꞌ izo gilite-lengedekuze. Aꞌmineꞌmine igi linginesi nene ge gizeꞌne nosoꞌ ize-nede ne gizenga nosoꞌ ize-gede li minilizave. ");
INSERT INTO aso_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naza neꞌmine noo-lingiduvoniꞌ nene linginesi nene naza o-lingiduvoniꞌ neꞌmine ilizave losa nene aka lengelebizo neꞌmine nouve. ");
INSERT INTO aso_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Naza mo laminetoꞌ tiꞌ lo nolo-lingimuve: Gelekeleꞌ izipe neꞌmo nene gizebo o-do minive guvelesi veꞌve nene ivileꞌ o-do minesaꞌmive. Idoꞌ gonouꞌ ngimiselavo gonoloꞌ monaaꞌ nave nete nene ngimiselive ivileꞌ i-di minisaꞌmave. ");
INSERT INTO aso_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lingine aꞌmine noluvoniꞌ initekumuꞌ nene gili nizanako aꞌmidoꞌ eꞌmete gehepeve ilizaniꞌ nene Oꞌmosoꞌmo do lamineꞌ o-lengedeli akaloꞌ mini mili minilisave. ");
INSERT INTO aso_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Neꞌmine noluvoniꞌ nene naza neniꞌ ve lo do kegese-lingiduve nene mo ningo gele nouvoniꞌ nenako lengiꞌ mukikumuꞌ lamuve. Monoꞌ Godolouꞌ tiꞌ li gizi nizaniꞌ gamazi nene gihile izelive losa neꞌmine nouve: Neniꞌ nosoꞌ niteꞌneutiꞌ naaꞌ usive neꞌmo nene biluvaꞌ o-nedo nebele leive. ");
INSERT INTO aso_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Naza idise aꞌmine gamazi nene nolo-lingimuvoniꞌ mene aꞌmine initeꞌ olihe sotoꞌ olosa neivosa noluve. Sotoꞌ ilineꞌ nene lingine aꞌmidotiꞌ ningi neniꞌ nene mo neive neniꞌ ma ne neive li gili eleꞌvoleꞌ ilizave losa noluve. ");
INSERT INTO aso_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Naza laminetoꞌ gehepeve tiꞌ lo nolo-lingimuve: Ve ma ingine neniꞌ ngimiseleloniꞌ aleve ngeleꞌmize lamineꞌ ilizaniꞌ nene aꞌminguꞌ mo nenikisi neleꞌmize lamineꞌ ilisave. Idoꞌ ve ma ingine neniꞌ neleꞌmize lamineꞌ ilizaniꞌ nene aꞌminguꞌ nimiselive eiꞌ nene eleꞌmize lamineꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Neꞌmine losa Izesuꞌ nene emeni balala livo mino tiꞌ lo lo sotoꞌ ogo lineꞌ: Naza laminetoꞌ tiꞌ lo nolo-lingimuve. Lengikutiꞌ maliꞌmo nenikumuꞌ me neive lo biluvaliti aꞌninguꞌ molo-nedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Neꞌmine lavo izipahala zuho nene zahinemuꞌ nolive li gopo gaꞌine gili vonuꞌ gimise aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Izipahala zuho engikutiꞌ ve ma nene vonoloꞌ izipe neꞌmine minive nene Izesuꞌ minida avitoꞌ gehepeve minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nemuꞌ aꞌmine vemuꞌ nene Simoniꞌ Petoloꞌ aza godolodunuꞌ avazaha ogo zahinemuꞌ lihe longoꞌ o-dezo lo-dineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Neꞌmine lo-davo aꞌmine ve aza Izesuda mine lehete ogo tiꞌ lo longoꞌ o-dineꞌ ve: Guvekasi ve, gaza nene zahinemuꞌ nolane. ");
INSERT INTO aso_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lineꞌ: Aꞌmine ve nene beleti lumo ma do supu nosouꞌ lupizo emelove ne neive. Neꞌmine lo beleti lumo ma do lupizo Kelioto numudotiꞌ ve Simoniꞌ gipele Zudaꞌni nene imineꞌ. ");
INSERT INTO aso_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Emavo do anauꞌ ogo nonavo aꞌmidoꞌ liteꞌ lo Satani neꞌmo lulouꞌ dizineꞌ ve. Neꞌmine ogavo Izesuꞌ aza Zudaꞌni tiꞌ lo lo-imineꞌ: Gaza olosa naineꞌ initeꞌ nene geto olosane. ");
INSERT INTO aso_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Neꞌmine lo lineꞌza nosoꞌ niteꞌ makaꞌ ni minave mukiꞌ nene Zudaꞌni neꞌmine lo-dineꞌ nene nanimuꞌ lo-dihe nemuꞌ ma gilami minaniꞌ. ");
INSERT INTO aso_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ee, Zudaꞌ nene engiꞌ moni milaniꞌ beniloꞌ nene gizebo ve minineꞌ nenako nemuꞌ nene engikutiꞌ linge ma nete Izesuꞌ aza neꞌmine lineꞌ nene holiseꞌ nosoꞌ niteꞌ nevoꞌmine vo meni hizelingumuꞌ lo-dihe idoꞌ moni ma gohoꞌ gahaliꞌ aleve ngemelingumuꞌ lo-dihe lisa gilaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Neꞌmine ogo Zudaꞌ nene aꞌmine beleti nene no osuꞌ lo liteꞌ lo oto numungutiꞌ lemo heta vohaha ineꞌ nene litiꞌmuso ize mininguꞌ vineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Idoꞌ Zudaꞌ nene heta lemo vavo Izesuꞌ tiꞌ lo lineꞌ: Idise nene Oꞌmosolatiꞌ ve gihile nene di hozi li-nidilizaniꞌ gamene nene mo ogave. Idoꞌ nenitotiꞌ nene Oꞌmoso di hozi li-dilisave. ");
INSERT INTO aso_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Idoꞌ neꞌmino neineꞌ nenako Oꞌmosoꞌmo eitoꞌ do medele-nedo do hozi lo-nedeleseive. Ee, idoꞌ gamene haꞌna vamivo mo liteꞌ lo do hozi lo-nedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Izipekizo, naza lengikisi nene gamene liꞌnibevoꞌ mineloniꞌ ogave. Nenikumuꞌ lingine viseꞌ ilizaha mo ngeli ningamilisave. Zuda ve lo-ngimuvoniꞌ maꞌmino idise nene lengikisi tiꞌ lo nolo-lingimuve: Naza vo mineloda lingine ngeli amilisave. ");
INSERT INTO aso_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Naza gamazi gosohoꞌ ma tiꞌ lo lo huko nolo-lingimuve: Lingine nene ge luka neme ne luꞌne geme livoꞌ minilo. Ee, neniꞌ luꞌne lengeme nouvoniꞌ neꞌmine igi lingine nesi nene ge luka neme ne luꞌne geme livoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Eveneꞌ mukiꞌ nete lingine neniꞌ izipahaꞌne zuhoutiꞌ nizave li ningi gililizaniꞌ nene lingine ge luka neme ne luꞌne geme li minilizadotiꞌ nene ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Neꞌmine lavo Simoniꞌ Petoloꞌ aza Izesuꞌni tiꞌ lo longoꞌ o-dineꞌ ve: Guvekasi ve, gaza zala viliningumuꞌ nolane. Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Naza voloda nene idise nene gaza ngelo neꞌmeto vamolosaba asi alingeꞌ nene neꞌmeto volosane. ");
INSERT INTO aso_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Neꞌmine lavo Petoloꞌ aza tiꞌ lo lo-imineꞌ: Guvekasi ve, idise nene nanitekumuꞌ geꞌmeto vamolove. Gaza libililiza akaloꞌ volosa nolilineꞌ nene naza nene geikumuꞌ okoꞌne nene ha hulolosuve. ");
INSERT INTO aso_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Gaza okonga nenikumuꞌ ha hulolosuve nolabe. Oꞌove. Idise melotiꞌ nene okoloholiꞌmo olihe nolo molamivo gaza neniꞌ nene ningamuve ve lo ataize gamene setohamo lolosane. ");
INSERT INTO aso_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Neꞌmine lo Izesuꞌ imineꞌ molo tiꞌ lo lineꞌ: Lingine lutinguꞌ naniteꞌ sotoꞌ o-ledelivo li gili lengemeni balala lokaꞌ lokaꞌ ivo nizaniꞌ nene mo alamilo. Asi Oꞌmosomuꞌ gili eleꞌvoleꞌ igi nenikumukisi nene gili eleꞌvoleꞌ igi minilo. ");
INSERT INTO aso_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Meꞌnehi numuno ebeꞌvela minevoꞌ alevoꞌ igi minilizaniꞌ numuno nene vaiꞌ goloso neive. Idoꞌ neꞌmino ma minamidiniko naza vo numuno do vaꞌvaꞌ o-lengedelove lo lo-lingimuvoniꞌ nene ma lamuvodine. ");
INSERT INTO aso_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Idoꞌ naza vo numuno do vaꞌvaꞌ o-lengedeloniꞌ nene aꞌmine vo mineloda nene linginesi vi minilizangumuꞌ ve lo lengiꞌ nene do nenita ogo lengeleꞌmizo volosa gohi alosuve. ");
INSERT INTO aso_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Idoꞌ aꞌmine naza voloniꞌ ebeta aka vo neineꞌ nene lingine mo ningi gili nizave. ");
INSERT INTO aso_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Idoꞌ izipahala zuhoutiꞌ Tomasiꞌ neꞌmo tiꞌ lo lo-dineꞌ ve: Guvekasi ve, gaza vilineꞌ ebekumuꞌ nene ma gelamuneꞌ nenako aꞌmida vaaꞌ akasi nene laza nado ningo gelelone. ");
INSERT INTO aso_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lineꞌ: Meꞌneho Oꞌmosola vaaꞌ aka nene naꞌniseꞌne nouve. Aka nouvonako naza nene aꞌmida vilizangumuꞌ gamazi gihile neꞌmi meleho mino minevoꞌ minevoꞌ lengemeni dameni lengemaaꞌ meleho nesi nene naꞌniseꞌne nouve. Nemuꞌ nene aꞌmine aka nenita vamilizave hamolitesi nene meꞌnehida ngeli ma vi hetelamilisave. ");
INSERT INTO aso_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lingine neniꞌ nene mo ningi gili nizanako meꞌnehinesi nene mo ningi gililisave. Idise melotiꞌ nene eze mo ningi gilisa mo ningi nizave. ");
INSERT INTO aso_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Neꞌmine lavo Hilipoꞌ tiꞌ lo lo-imineꞌ: Guvekasi ve, mahine nene lelebizezo. Lelebizanivo laza ningekunivo neꞌmo vo davo gohi viseꞌ amolone. ");
INSERT INTO aso_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Neꞌmine lavo Izesuꞌ tiꞌ lo lo-imineꞌ: Hilipoo, naza nene lengikisi gamene haꞌna nene minuneꞌ neineꞌza gaza nene nenikumuꞌ olihe ningo gelamabe. Ve ma ingine neniꞌ ningaaꞌ nave nene aꞌminguꞌ nene meꞌnehinesi ningaaꞌ nave. Neꞌmine o neineꞌ nenako gaza meꞌnehine lelebizezo laineꞌ nene lamilinako nanimuꞌ lane. ");
INSERT INTO aso_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Meꞌneho nene nenikisi minaaꞌ neivo naza nene meꞌnehosi minaaꞌ nouvoniꞌ mamuꞌ nene gele eleꞌvoleꞌ amabe. Gamazi mene lo-lengemaaꞌ nouvoniꞌ ma nene neniꞌ gaꞌneutiꞌ gelo lo-lengemesaꞌmuve. Asi meꞌneho neꞌmo nene nenikuꞌ mino eiꞌ gono nodavosa nene laaꞌ nouve. ");
INSERT INTO aso_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Meꞌneho nene nenikisi minaaꞌ neivo naza nene meꞌnehosi minaaꞌ nouve lo lo-lengemaaꞌ nouvoniꞌ nene gili eleꞌvoleꞌ ilizadoꞌ o neive. Idoꞌ haza gili eleꞌvoleꞌ amilizadoꞌ nolineꞌ nene neniꞌ meꞌnehi gono do ogo molo nouvoniꞌ initetotiꞌ nene gili eleꞌvoleꞌ ilizaniꞌ o neive. ");
INSERT INTO aso_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Naza mo laminetoꞌ gehepeve nolo-lingimuve. Ve ma ingine nenikumuꞌ gili eleꞌvoleꞌ i minilizave mukiꞌ nesi nene naza ogo molo nouvoniꞌ initeꞌ neꞌmine nene ha igi mili ilisave. Ee, idoꞌ naza nene meꞌnehida voloniꞌ nenako neꞌmo nene ingine naza uvoniꞌ initeꞌ nene ivileꞌ ivosa atoliꞌmine initeꞌ naba nesi ha ilisave. ");
INSERT INTO aso_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Neniꞌ guliveꞌne di tiꞌ igi mini neniꞌ eveneꞌne loloꞌ igi minilizangutiꞌ initeꞌ mamuꞌ lilizaniꞌ nene gipele nenitotiꞌ nene meꞌnehi guliveꞌve di hozi lilizangumuꞌ ve losa nene ha gele lengemelesuve. ");
INSERT INTO aso_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ee, neniꞌ eveneꞌne liliꞌ igi minilizangutiꞌ initeꞌ mamuꞌ nenita lilizaniꞌ nene ha gele lengemelesuve. ");
INSERT INTO aso_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Lingine lutine nimi nizaniꞌ nolineꞌ nene naza lo-lingimuvoniꞌ gamazi nene gili di minilisave. ");
INSERT INTO aso_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Neꞌmine ikevo naza meꞌnehine lokuvo lengita minevoꞌ minevoꞌ ilingumuꞌ nene hize eleꞌ o-lengedelive gohi ma imiseleleseive. ");
INSERT INTO aso_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aꞌmine imiselelive nene gamazi gihile do sotoꞌ ive Oꞌmosoꞌmi Sikalahuꞌ nene neive. Me misubouꞌ initekumukovoꞌ gilaaꞌ ave ingine aꞌminemuꞌ nene ma ningi gilisaꞌmaniꞌ nenako eze nene ngeli ma di tiꞌ amilisave. Nene neiha aza nene lengita mino lutinguꞌ omo minaaꞌ neineꞌ nenako lingine nene ezemuꞌ mo ningi gili nizave. ");
INSERT INTO aso_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Naza hulo-lengedo voloniꞌ nene lingine mudise muheleꞌ izipe neꞌmine minilizave losa hulo-lengedamolosuve. Naza nene lengita gohi alosuve. ");
INSERT INTO aso_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Melotiꞌ nene gamene liꞌnibevoꞌ ogo vavo me misubouꞌ aleve nete neniꞌ nene gohi ma ningamilisaha lengiꞌ nene neniꞌ ha ningilisave. Naza nene mo minevoꞌ minevoꞌ ogo nouvoniꞌ nenako nemuꞌ nene linginesi miniviꞌ miniviꞌ igi minilisave. ");
INSERT INTO aso_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aꞌmine neniꞌ gohi ningilizaniꞌ gameneloꞌ nene naza meꞌnehida mine molo nouvo idoꞌ lingine nene nenita mini mili nizavo naza nene lengita mine molo nouvoniꞌ nemuꞌ nene mo ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Eveneꞌ ma ingine neniꞌ gamaziꞌne di mini aꞌmidoꞌ gili di minaaꞌ nave nene mo luꞌine laminetotiꞌ nimaaꞌ nave nene nizave. Idoꞌ aꞌmine luꞌine laminetotiꞌ nimaaꞌ nave nene meꞌneho lulo ngemeleseive. Neꞌmine neivo nazasi nene luꞌne ngemo neniꞌ nemeni dameni ngelebizelesuve. ");
INSERT INTO aso_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Neꞌmine lavo Kelioto ve Zudaꞌ abalaho Zudaꞌ gohi ma neꞌmo Izesuꞌni nene tiꞌ lo lo-imineꞌ ve: Gaza leliꞌ Zuda veti guvetesi ve naba naneꞌ gemeni dameni nene me misubouꞌ aleve mukiꞌ ngelebizamo lelikovoꞌ lelebizelove nolaineꞌ nene do nadosa lelikovoꞌ lelebizeline. ");
INSERT INTO aso_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Neꞌmine lavo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Naza nemeni dameni lengelebizeloniꞌ aka neꞌmino neive: Ve ma ingine luꞌine neniꞌ nimi minilizave nete nene neniꞌ gamaziꞌneloꞌ eꞌmeti gili di minilisave. Neꞌmine ikevo meꞌneho lulo ngemavo azasi nazasi engita ogo mine molo minelesusive. ");
INSERT INTO aso_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ve ma ingine luꞌine neniꞌ nimamaaꞌ nave nene neniꞌ gamaziꞌneloꞌ eꞌmetamaaꞌ nave. Aꞌmine lokuvo gilaaꞌ naniꞌ gamazi nene neniꞌ gamaziꞌne nomive. Asi nimiselive meꞌnehi gamazi nene neive. ");
INSERT INTO aso_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Aꞌmine nolo-lingimuvoniꞌ gamazi meve nene naza linginesi ha minuvodoꞌ ve losa nene nolo-lingimuve. ");
INSERT INTO aso_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Neꞌmine nouha naza vokuvo meꞌneho nene neniꞌ veꞌnemuꞌ ogo lengita imiselelive lengiꞌ hize eleꞌ o-lengedelive Oꞌmosoꞌmi Sikalahuꞌ neꞌmo nene initeꞌ mataꞌ mukikumuꞌ nene apize lengemo lo-lingimuvo niteꞌ mukikumuꞌ nene gohi lo gatine oloseive. ");
INSERT INTO aso_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Idoꞌ mo hulo-lengedeloniꞌ o neineꞌ nenako haza hulo-lengedamo hongu monovo nesi nene nohulo-lingiduve. Aꞌmine hongu monovo nene me misubouꞌ alevete hongu monovo di sotoꞌ igaꞌ naniꞌ neꞌmine minamo nenitatiꞌ atoliꞌmine ogo minineꞌ hongu nene nolingimuze. Lingine lengemeni balala livo mini goliseloꞌ ve minamilo. ");
INSERT INTO aso_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naza hulo-lengedo vosa lengita alosuve lo lo-lingimuvoniꞌ nene lingine mo gilikeve. Nemuꞌ lingine nene lutine lamineꞌ gehepeve nimi minadiniko meꞌneho nene neniꞌ nivileꞌ ogo naba neineꞌ nenako aꞌmine meꞌnehida volongumuꞌ nene lingine mo lamineta novive li longolize izi minadine. ");
INSERT INTO aso_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Idoꞌ initeꞌ mataꞌ idise mene nolo-lingimuvoniꞌ nene alingeꞌ sotoꞌ ilineꞌ nene lingine gili eleꞌvoleꞌ ilizave losa olihe sotoꞌ amidoꞌ nene gomuꞌ nolo-lingimuve. ");
INSERT INTO aso_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Me misubouꞌ guvelesi ve loloꞌ ogo minive nene nenita mo nave. Nemuꞌ nene lengikisi gamazi haꞌna lamolonidoꞌ o neive. Aꞌmine nenita nave nene initeꞌ hamokisi neniꞌ o-nedelidoꞌ mo lisiheꞌ amineꞌza ");
INSERT INTO aso_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","oloniꞌ initeꞌ nene me misubouꞌ aleve ningi meꞌnehine luꞌne eme mino aza lo-nidineꞌ initetokovoꞌ eꞌmeto ogo molo ogaꞌ neive li ningi gililizave losa aꞌmine initeꞌ nene olosa nouze. Mo valonge. Otilo. ");
INSERT INTO aso_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Izesuꞌ imineꞌ molo tiꞌ lo lo-ngimineꞌ: Neniꞌ nene vaini nalaꞌ neꞌmi zava gehepeve ne nouve. Idoꞌ meꞌneho neve nene aꞌmine vaini nalatoꞌ gizebo ve ne neive. ");
INSERT INTO aso_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aꞌmine nenikuꞌ aꞌnava neꞌmine mini gihile izamaniꞌ nene huko do hulaaꞌ neive. Idoꞌ gihile izi minaniꞌ aꞌnava mukikuꞌ nene gihile mo vaiꞌ goloso izelingumuꞌ ve lo sisive do do lisiheꞌ gehepeve ogaꞌ neive. ");
INSERT INTO aso_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Naza gamazi lo-lengemaaꞌ nouvoniꞌ neꞌmo lengikuꞌ nene mo sisive do do lisiheꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nemuꞌ lingine nenitoꞌ nene giꞌmizi giliꞌ li minilo. Aꞌmineꞌmine ogo naza linginela giꞌmizo minelove. Aꞌnava neꞌmo zavaꞌveloꞌ giꞌmize minamilineꞌ nene asiꞌve ngelo gihile izamoloseiha zavaꞌveloꞌ giꞌmize minelineꞌ nene gihile izeleseive. Aꞌmineꞌmine ogo lingine nenita giꞌmizami minilizaniꞌ nene gihile ma izami asi nenita giꞌmizi minilizanikovoꞌ nene gihile izilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ee, neniꞌ nene vaini nalaꞌ neꞌmi zavaꞌve nene nouvo lingine nene aꞌnava neꞌmine nene nizave. Idoꞌ neniꞌ nene hize eleꞌ o-ngedamuvo initeꞌ hamokisi ma amilisanako ve ma ingine nenita giꞌmizi nizavo naza inginela giꞌmizo minelove nete nene gihile vaiꞌ goloso izilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ve ma ingine nenitoꞌ giꞌmizi minamave nene za aꞌnava huki hulikevo gokoꞌ lavo di nubuho igi olokuꞌ gizikevo laaꞌ neineꞌ neꞌmine nene nizave. ");
INSERT INTO aso_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lingine nenitoꞌ giꞌmizi minilizaniꞌ nene naniteꞌ naniteꞌ dalisa gililizahe aꞌminemuꞌ lilizaniꞌ nene meꞌneho ha gele lengemavo dalisave. ");
INSERT INTO aso_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Idoꞌ lingine gihile vaiꞌ izi neniꞌ izipahaꞌne zuho gihile liliꞌ igi minilizadotiꞌ nene meꞌnehine di hozi li-dilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Meꞌneho lulo nene neniꞌ neme neineꞌ neꞌmino naza luꞌne nene lengeme nouve. Nemuꞌ nene luꞌne lengemeꞌmo vo minelodoꞌ vo lisiheꞌ ivosavoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Naza meꞌneho lo huko lo-nidineꞌ gamaziloꞌ eꞌmeto mino meꞌneho lulo nimidoꞌ lisiheꞌ ivosa minaaꞌ nouvoniꞌ neꞌmine igi linginesi nene aꞌmineꞌmine igi neniꞌ lo huko lo-lingiduvoniꞌ gamaziloꞌ eꞌmeti minilizaniꞌ nene luꞌne lengemeꞌmo vo minelodoꞌ vo lisiheꞌ ivosavoꞌ nene minilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gamazi mene nolo-lingimuvoniꞌ nene luꞌne gulumo avile lisivo minaaꞌ nouvoniꞌ monovo nene lengitasi minivo aꞌmine neꞌmo vaiꞌ lo lingibilivo minilizave losa noluve. ");
INSERT INTO aso_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Neniꞌ gamazi ma lo huko lo-lingiduvoniꞌ ma nene neꞌmino neive: Naza luꞌne lengiꞌ lengeme nouvoniꞌ neꞌmine igi linginesi nene ge luka neme ne luꞌne geme livoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ve maliꞌmo eze zogo alevemuꞌ okoꞌno hulo labuluvo ogosa helelineꞌ nene lulo atoliꞌmine gehepeve ogo ngeme minosa nene neꞌmine ilineꞌ nenako lulo mo ngemo minineꞌ votigile nene ivileꞌ ivosa lulo gohi ngemelidoꞌ ngelo minamoloseive. ");
INSERT INTO aso_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lingine lo huko lo-lingimuvodoꞌ eꞌmeti minilizaniꞌ nene neniꞌ zogone nene nizave. ");
INSERT INTO aso_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Idoꞌ gelekeleꞌ izipe nete nene guveꞌinesi ve gizebo o-ngede miniveꞌmo ogo molo ogaꞌ neineꞌ initekumuꞌ nene ma ningi gilisaꞌmaniꞌ nenako nemuꞌ nene naza lengikumuꞌ nene gelekeleꞌ izipe ve lo gohi ma lo-lengedamolodoꞌ o neive. Asi meꞌnehidatiꞌ ningo giluvoniꞌ initeꞌ mukiꞌ nene lengiꞌ gililizave lo do sotoꞌ ogo lo-lengeme nouvoniꞌ nenako nemuꞌ nene idise lengiꞌ nene zogone ve nolo-lingiduve. ");
INSERT INTO aso_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Lengiꞌ nene gomuꞌ apizi neniꞌ nene lengiꞌ ve li ma di tiꞌ amave. Asi neniꞌ neve lengiꞌ do tiꞌ uvoniꞌ nene vi gono dikevo minevoꞌ minevoꞌ ilineꞌ gihile nene izelive losasi idoꞌ lingine neniꞌ veꞌnemuꞌ igi meꞌnehida vokuꞌ nanitekumuꞌ lilizahe aꞌmine initeꞌ nene lengemelive losasi do tiꞌ o-lingiduvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Naza nene mo neꞌmine lo nolo huko-lingiduve: Lingine nene ge luka neme ne luꞌne geme li minilo. ");
INSERT INTO aso_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Me misubouꞌ initetoꞌ luꞌine milaaꞌ nave nete lengiꞌ biluvaꞌ i-lingidilizaniꞌ nene gomuꞌ neniꞌ biluvaꞌ i-nidi minaniꞌ ma nene idise leliꞌ nene biluvaꞌ nii-lidave lisa gili minilo. ");
INSERT INTO aso_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lingine nene aꞌmine me misubouꞌ aleveti muliseꞌningutiꞌ minadiniko ingine lengikumuꞌ nene leliꞌ aleve ve li zogo mili-lingidadine. Neꞌmine adineꞌza engiꞌ muliseutiꞌ lengiꞌ nene neniꞌ ve lo do kegese-lengedo do nenita o-lingiduvoniꞌ neꞌmo nene biluvaꞌ nii-lingidave. ");
INSERT INTO aso_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Naza tiꞌ lo lo-lingimuvoniꞌ gamazi mamuꞌ nene gili minilo: Gelekeleꞌ izipe neꞌmo nene gizebo o-do minive guvelesi veꞌve nene ivileꞌ o-do minesaꞌmive. Neniꞌ goboni mili-nidaaꞌ ave nilizaniꞌ nene lengikisi goboni mili-lingidilisave. Idoꞌ neniꞌ gamaziꞌneloꞌ gili di minaaꞌ ave nilizaniꞌ nene lengiꞌ gamazitinesi nene gili di minilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mene noluvoniꞌ initeꞌ i-lingidilizaniꞌ nene ingine neniꞌ nimiselive nene ningi gilami minilisanako neꞌmo nene lingine neniꞌ guliveꞌne di tiꞌ igi nenitoꞌ giꞌmizi minangumuꞌ ve li aꞌmine noluvoniꞌ initeꞌ nene ha i-lingidilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Idoꞌ naza ma amo gamaziꞌne nene ma lo-ngemamuvodiniko nenikumuꞌ gili hulamavo lihime nene engita mo minamivo minadineꞌza idise nene ingine laza lihime nodune lo gelamo gopo minune li eꞌmenga lilizaniꞌ aka nene ogo hize tile-ngedekuvoniꞌ nenako olovoꞌ ma amilisave. ");
INSERT INTO aso_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ve ma ingine neniꞌ biluvaꞌ i-nidaaꞌ nave nene aꞌminguꞌ meꞌnehinesi nene biluvaꞌ nii-dave. ");
INSERT INTO aso_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Idoꞌ neniꞌ nene eveneꞌ malitesi amaniꞌ initeꞌ atoliꞌmine suno gehepeve nene engiꞌ vovoꞌninguꞌ do sotoꞌ uvoniꞌ ma nene ma do sotoꞌ amuvodiniko lihime engita ma minamivo minadineꞌza engiꞌ vovoꞌninguꞌ nene aꞌmine atoꞌ suno nene do sotoꞌ nouvo ningisasi nene nenikisi meꞌnehinesi nene biluvaꞌ i-lidi minaniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Neꞌmine igi minaniꞌ nene engiꞌ monoꞌ gamaziꞌninguꞌ gizikaniꞌ minineꞌ gamazi ma nene gihile izelingumuꞌ ve losa nene neꞌmine aniꞌ ve. Aꞌmine gamazi nene neꞌmino neive: Biluvaꞌ i-nidaniꞌ nene mo hazamuꞌ gehepeve neꞌmine aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Idoꞌ meꞌnehosi minasidotiꞌ imiselekuvo alive hize eleꞌ o-lengedelive adoꞌ gamazi gihile do sotoꞌ ive Oꞌmosoꞌmi Sikalahuꞌ alineꞌ nene neniꞌ monovoꞌnemuꞌ lo sotoꞌ sotoꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Idoꞌ lengiꞌ nene gono apiꞌ ogo do minuvodotiꞌ nene nenikisi makaꞌ mine do ogo noneꞌ nenako nemuꞌ nene linginesi nene neniꞌ monovoꞌnemuꞌ li sotoꞌ sotoꞌ ilisave. ");
INSERT INTO aso_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Gamazi mene nolo-lingimuvoniꞌ nene lingine nenikumuꞌ gili eleꞌvoleꞌ aniꞌ nene hulii limi ingikelizave losa nene nolo-lingimuve. ");
INSERT INTO aso_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Zuda ve nete monoꞌ muliseꞌningutiꞌ nene huli heta i-lingidilisave. Ee, gamene ma alosa neive. Aꞌminguꞌ nene lengiꞌ lingibili hililizave mukiꞌ nete Oꞌmosoꞌmi gono nodube li gilii lingibili hililisave. ");
INSERT INTO aso_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Initeꞌ nevoꞌmine nene ingine meꞌnehinesi nenikisi nene ningi gilamaniꞌ nenako neꞌmo nene neꞌmine ilisave. ");
INSERT INTO aso_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naza aꞌmine sotoꞌ ilineꞌ initekumuꞌ do gomuꞌ molo nolo-lingimuvoniꞌ nene aꞌmine initeꞌ alingeꞌ sotoꞌ ilineꞌ gamenela nene lingine neniꞌ lo-limineꞌ maloꞌ nene sotoꞌ neive li gili minilizangumuꞌ nene nolo-lingimuve. Naza nene lengikisi mine do ogo nouvoniꞌ nenako nemuꞌ nene naza idise nolo-lingimuvoniꞌ initekumuꞌ ganaꞌ ma lo-lengemamuvoniꞌ ma neive. ");
INSERT INTO aso_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ee, gomuꞌ lengikisi mine do ogo minuvoniꞌza idise nene mo nimiselivela nene novuve. Novuvoniꞌza lengikutiꞌ hamoliꞌmosi nene zala novane lo longoꞌ ma o-nedamive. ");
INSERT INTO aso_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne neiha gamazi mene lo-lingimuvoniꞌ neꞌmo nene mulumo alumo lutinguꞌ do vaiꞌ lo-lengedavo vaiꞌ lo neive. ");
INSERT INTO aso_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ne neiha naza mo laminetoꞌ tiꞌ lo nolo-lingimuve: Naza hulo-lengedo ma vamoloniꞌ nene aꞌmine hize eleꞌ o-lengedelive nene ma alidoꞌ minamoloseiha naza voloniꞌ nene lengita imiselekuvo aloseinako nemuꞌ voloniꞌ neꞌmo nene hize eleꞌ o-lengedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Idoꞌ aꞌmine hize eleꞌ o-lengedelive alineꞌ nene lihimeꞌineꞌmi monovo nesi idoꞌ lihime nomineꞌ lisiheꞌ lamineꞌ minaaliꞌmi monovo nesi idoꞌ Oꞌmosoꞌmo goniꞌ o-ngedo lihime ngemelineꞌ monovo nesi nene do sotoꞌ ogo me misubouꞌ aleve nene luꞌninguꞌ hizivo ningi gililisave. ");
INSERT INTO aso_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ee, ingine nenikumuꞌ gili eleꞌvoleꞌ ami minaaꞌ naadotiꞌ nene lihime engita neineꞌ nene ngelebizeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Idoꞌ lingine neniꞌ nene gohi ningamilizada meꞌnehida volodotiꞌ nene aza lihimeꞌve nomineꞌ mino ve lisiheꞌ lamineꞌ minineꞌ ve li ningilizave lo nesi ngelebizeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Idoꞌ me misubouꞌ aleveti guveꞌinesi ve loloꞌ ogo minive nene naza mo ivileꞌ okuvo Oꞌmosoꞌmo goniꞌ o-do lihime emelingumuꞌ lo huko-didotiꞌ nene me misubouꞌ aleve monoꞌ gilamave engikisi Oꞌmosoꞌmo goniꞌ o-ngedo lihime ngemelineꞌ o neineꞌ nesi nene ngelebizeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Agae, naza idise nene gamazi vaiꞌ goloso ha lo-lengemeloniꞌ o neineꞌza lingine idise aꞌmene liteꞌ li di lutinguꞌ milalizadoꞌ lisiheꞌ amilisave. ");
INSERT INTO aso_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ne neiha aꞌmine luve gamazi gihile do sotoꞌ ogaꞌ ive Oꞌmosoꞌmi Sikalahuꞌ alineꞌ nene lengeleꞌmize gamazi gihile mukiliꞌmi akaloꞌ molaloseive. Neꞌmine ilineꞌ nene nanitekumuꞌ ve. Aza nene eiꞌ galautiꞌ gelo lilivoba asi meꞌnehidatiꞌ gelelineꞌ initekovoꞌ nene lo-lengemo idoꞌ alingeꞌ sotoꞌ ilineꞌ initekumuꞌ nene lo sotoꞌ o-lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aꞌmine luve neꞌmo nene neniꞌ gamaziꞌneutiꞌ ma dosa lengiꞌ lo-lengemelineꞌ nene aꞌmine neꞌmo neniꞌ nene do hozi lo-nedeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Naza aꞌmine luve neꞌmo lo-lengemaaꞌ neineꞌ initeꞌ nene nenitatiꞌ dalineꞌ initekovoꞌ nene lo-lengemeleseive noluvoniꞌ nene neniꞌ meꞌnehida neineꞌ initeꞌ mukiꞌ nene neniꞌ initeꞌne neineꞌ nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Idoꞌ gamene liꞌnibevoꞌ gehepeve ogo vavo neniꞌ nene gohi ma ningamilisave. Idoꞌ aꞌmidotiꞌ nene gamene liꞌnibevoꞌ gehepeve gohi ogo vavo neniꞌ nene ningilisave. ");
INSERT INTO aso_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Neꞌmine lavo izipahala zuho linge ma nete nene angiseꞌine li voleloꞌ meloꞌ igi tiꞌ li laniꞌ ve: Aza nene gamene liꞌnibe ogo vavo neniꞌ ningamilisave idoꞌ gamene liꞌnibe gohi ma ogo vavo neniꞌ nene ningilisave lineꞌ ve. Idoꞌ gamazi ma meꞌnehida voloniꞌ nenako nemuꞌ noluve lo nesi nene lineꞌ ve. Idoꞌ aꞌmine neꞌmine gamazi lineꞌ nene nanitekumuꞌ live. Laza gelamune. ");
INSERT INTO aso_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Neꞌmine li gohi tiꞌ li laniꞌ: Gamene liꞌnibe ve lineꞌ neꞌmi monovo nene nado nolive. Laza nene nadive nolihe nemuꞌ nene ma gelamolonidoꞌ ogave. ");
INSERT INTO aso_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Neꞌmine nilavo Izesuꞌ nene ingine longoꞌ i-dilisa gili minaniꞌ nemuꞌ nene mo ningo gelo aza tiꞌ lo lo-ngimineꞌ ve: Lingine langisetine longoꞌ tongoꞌ igi li voleloꞌ meloꞌ naniꞌ nene naza nene gamene liꞌnibe gehepeve ogo vavo neniꞌ ningamilisave idoꞌ gamene liꞌnibe gehepeve gohi ogo vavo neniꞌ nene ningilisave luvongumuꞌ nene nilahe. ");
INSERT INTO aso_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Naza laminetoꞌ tiꞌ lo nolo-lingimuve: Lengiꞌ nene vetingutiꞌ ive novozo doꞌmozeꞌ mozeꞌ neivo ive nama igi nizavo me misubouꞌ aleve nene ngolize izilisave. Lingine muheleꞌ igi mulumo alumo gililisaha aꞌmine mulumo alumo gililizaniꞌ nene do velepeꞌ izo longoloze izaaꞌ loloꞌ oloseive. ");
INSERT INTO aso_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Veneliꞌmo nene izipe gedelineꞌ gamene ogavo izipe nogedo mulumo alumo gelaaꞌ neiha alingeꞌ nene izipe sotoꞌ ogavosa eveneꞌ ma nene me misubouꞌ sotoꞌ ogave lo olize izosa aꞌmine mulumo gilineꞌ mamuꞌ nene gohi ma gele minesaꞌmive. ");
INSERT INTO aso_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Idoꞌ aꞌmineꞌmine igi lingine idise mulumo nigilaniꞌza alingeꞌ naza gohi lengiꞌ ningeloniꞌ gameneuꞌ nene lutinguꞌ gulumo avile lise minivo longolize izi minilisave. Ee, idoꞌ aꞌmine lutinguꞌ longolize izilizaniꞌ nene eveneꞌ gohi malitesi nene ngeli ma di hulamilisave. ");
INSERT INTO aso_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Aꞌmine gamene alineꞌ nene lingine initeꞌ hamokumukisi longoꞌ ma i-nidamilisave. Naza mo laminetoꞌ tiꞌ lo nolo-lingimuve: Neniꞌ veꞌnemuꞌ igi lingine meꞌnehida initeꞌ mamuꞌ lilizaniꞌ nene aza aꞌmine initeꞌ nene mo lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Neꞌmine o neineꞌza vokuꞌ lilizadoꞌ minamivo ganakutiꞌ nene neniꞌ veꞌnemuꞌ initeꞌ mamukisi vokuꞌ lamavo mine do ogo idisesi nene ha none. Vokuꞌ lilo. Vokuꞌ lilizaniꞌ nene lengita longolize neꞌmo nene vaiꞌ goloso lo minelive lo aꞌmine vokuꞌ liliza initeꞌ nene ha lengemavo dalisave. ");
INSERT INTO aso_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Naza gamazi nolo-lingimuvoniꞌ mene lo sotoꞌ lamineꞌ amo ha gepeꞌ gamaziutiꞌ lo-lingimuvoniꞌza gamene ma naniꞌ aꞌmine gameneloꞌ nene gepeꞌ gamaziutiꞌ lo-lengemamo asi haza gamaziutikovoꞌ nene lisiheꞌ ogo laminetoꞌ gehepeve meꞌnehinemuꞌ lo-lengemelesuve. ");
INSERT INTO aso_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Aꞌmine gameneuꞌ nene neniꞌ veꞌnemuꞌ igi initeꞌ mamuꞌ vokuꞌ lilizaniꞌ nene naza lengitoꞌ medelo mino aꞌmine initekumuꞌ nene meꞌnehine longoꞌ o-delesuve lamolosuve. Nene nanitekumuꞌ ve. Lingine nene lutine nimi Oꞌmosolatiꞌ ave ve li gili gili eleꞌvoleꞌ igisa minaniꞌ nenako nemuꞌ nene meꞌneho asiꞌve nene lulo lengeme neineꞌ nenako langisetine eita lilizaniꞌ nene ha gele lengemeleseive. ");
INSERT INTO aso_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ee, naza nene meꞌnehidatiꞌ ogo me misubouꞌ ogo hetelosa aꞌminguꞌ mene mino mo me misubo hulo meꞌnehida tineꞌ molo volosa nouve. ");
INSERT INTO aso_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Neꞌmine lavo izipahala zuho ingine tiꞌ li li-imaniꞌ: Gaza idise gamazi nolaineꞌ nene do haleko gepeꞌ gamaziutiꞌ lamo gamazi gihile lamineꞌ nolo-lemane. ");
INSERT INTO aso_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Idise neꞌmine nolanidotiꞌ nene laza tiꞌ lo gele osuꞌ lo none: Eveneꞌ lelita longoꞌ minineꞌ aꞌminemuꞌ nene gaza longoꞌ o-gedamunivosi nene aꞌmine longoꞌ nene mo ningo gelaaꞌ nane. Neꞌmine ogaꞌ naningumuꞌ geiꞌ nene mo Oꞌmosolatiꞌ anive ma ne nane losa gele eleꞌvoleꞌ o none. ");
INSERT INTO aso_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-ngimineꞌ: Lingine idise mo gili eleꞌvoleꞌ ikehe. Oꞌove. ");
INSERT INTO aso_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lingine giliꞌ nalo. Gamene atoliꞌmine ma alineꞌ nene idise mo sotoꞌ o neinako lingine huli-nidi hutileꞌ igi numudida numudida vikevo nenikovoꞌ minuvodiba mo meꞌneho nene nenikisi neineꞌ neꞌmo nene nenikovoꞌ ma minamolosuve. ");
INSERT INTO aso_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lingine mene gamazi nolo-lingimuvoniꞌ nene nenitatiꞌ hongu lo lamino minaaꞌ monovo di minilizave losa nene nolo-lingimuve. Ne neiha me misubouꞌ minilizanguꞌ nene geni initeliꞌmi lulouꞌ lengeleꞌmizi milalisave. Neꞌmine ilisaha naza me misubouꞌ aleve nene mo ngivileꞌ o nouvoniꞌ nenaze. Lingine aꞌmine geniliꞌmi lulouꞌ minilizanguꞌ nesi nene ha amuzo milivoꞌ minilo. ");
INSERT INTO aso_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Izesuꞌ aza aꞌmine mene gamazi nene lo-ngemo osuꞌ lo vokeneꞌ ogo Okulumokuko noningo tiꞌ lo lineꞌ: Ahonoo, gamene molo-nedaineꞌ ma nene mo ogave. Nemuꞌ gipa neniꞌ nene geiꞌ nene do naba o-gedelesuze. Gaza gipa neniꞌ nene do naba o-nedezo. ");
INSERT INTO aso_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Idoꞌ neꞌmine noluvoniꞌ nene gaza nemaineꞌ eveneꞌ mukiꞌ nene minevoꞌ minevoꞌ ngemeni ngemeline lo eveneꞌ ato atoꞌ mukitoꞌ nesi gizebo oloniꞌ amuzo nene mo neme naneꞌ nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Idoꞌ minevoꞌ minevoꞌ ngemeni dameni daaꞌ nene geiꞌ Oꞌmoso gihile hamoꞌ nemuꞌ ningi gili hehe laatotiꞌ nesi idoꞌ eveneꞌ do nguꞌ izeline lo nimiselanive Izesuꞌ Kilisitoꞌ nenikumuꞌ ningi gili hehe lilizadotiꞌ nesi nene dalisave. ");
INSERT INTO aso_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Naza nene geiꞌ nemaineꞌ gono do piluvodiꞌmo nene me misubouꞌ geiꞌ nene do naba o-gedekuve. ");
INSERT INTO aso_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nemuꞌ nene naza gomuꞌ misubo mene olihe sotoꞌ aminguꞌ geikisi mino guveꞌnesi ve naba minuvodiꞌmine ogo idise geikisi gohi nouvo aꞌmida nene do naba o-nedezo. ");
INSERT INTO aso_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Me misubouꞌ aleveutiꞌ eveneꞌ ma do kegese-ngedo neniꞌ nemelove lo nemanive engiꞌ nene geiꞌ monovoka ngelebizekuvo mo ningi gili nizave. Ingine nene geiꞌ eveneka minadotiꞌ nene neme nenita ogane. Idoꞌ geiꞌ gamazika nene mo gili di nizave. ");
INSERT INTO aso_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Geiꞌ nemaineꞌ initeꞌ mukiꞌ nene geitatikovoꞌ aniꞌ ma neive li mo gili nizave. ");
INSERT INTO aso_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Idoꞌ neꞌmine li gili nizaniꞌ nene geiꞌ lo-nemaineꞌ gamazi nene lo-ngemekuvo di luꞌninguꞌ milisa neniꞌ nene lamineꞌ geitatiꞌ uvoniꞌ nemuꞌ nene gili osuꞌ li geiꞌ nimiselaningumuꞌ nene gili eleꞌvoleꞌ aniꞌ nenako nemuꞌ nene neꞌmine li gili nizave. ");
INSERT INTO aso_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aꞌmine eveneꞌ nemaineꞌ nene geiꞌ eveneka nizaniꞌ nenako nemukisi idoꞌ aꞌmine alevelotiꞌ nene neniꞌ guveꞌne monaaꞌ neineꞌ nenako nemukisi nene engikumuꞌ geita noluve. Me misubouꞌ aleve geiꞌ gelekeleꞌ i-gidisaꞌmangumuꞌ nene geita noluvoba asi aꞌmine nemaineꞌ evenekumukovoꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ee, idoꞌ geiꞌ eveneka nizave luvoniꞌ nene nenita neineꞌ initeꞌ mukiꞌ nene geiꞌ initeka neivo geita neineꞌ initeꞌ mukiꞌ nene neniꞌ initeꞌne neineꞌ nenako nemuꞌ nene luvoniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naza nene me misubouꞌ gohi imineꞌ molo minamo geita alosa nouha aꞌmine aleve nete nene me misubouꞌ miniꞌmi igi nizave. Nemuꞌ nene lamineꞌ atoliꞌmine ogo minanive meꞌneho make, gazasi nazasi bizo hamoꞌ nosineꞌ neꞌmino inginesi bizi hamoꞌ minilizangumuꞌ ve lo geiꞌ amuzoka do sotoꞌ ogo nedunuꞌ nene alete molo-ngedezo. Aꞌmine nemaineꞌ amuzoka mamuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Naza me misubouꞌ engikisi makaꞌ minuvoniꞌ gameneuꞌ nene geiꞌ nemaineꞌ amuzo do sotoꞌ ogo nedunuꞌ alete molo-ngedo gizebo lamineꞌ o-ngedekuvo engikutiꞌ nene hamokisi ma vi tolovo amavo vo tolovo ilidoꞌ lisiheꞌ o minive neevoꞌ nene vo tolovo ogave. Idoꞌ aꞌmine vo tolovo ineꞌ nene monoꞌ godolouꞌ gizi nizaniꞌ gamazi nene gihile izelive losa vo tolovo ineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Idoꞌ idise nene naza mo geita nouve. Idoꞌ naza me misubouko ha mino vekisine mene gamazi mene nolo-ngimuvoniꞌ nene ingine luꞌninguꞌ gulumo avile lisivo minaaꞌ monovo nenitatiꞌ nene dikevo engita vaiꞌ lilive losa nene nolo-ngimuve. ");
INSERT INTO aso_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naza vekisine mene geiꞌ gamazika nene lo-ngemekuvo me misubouꞌ aleve nete nene biluvaꞌ i-ngidi nizave. Idoꞌ biluvaꞌ nii-ngidaniꞌ nene naza aꞌmine me misubouꞌ aleveti muliseutiꞌ minamuvoniꞌ neꞌmino inginesi nene aꞌmine muliseutiꞌ minamaniꞌ nenako nemuꞌ nene biluvaꞌ nii-ngidave. ");
INSERT INTO aso_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gaza nene aꞌmine vekisine meve nene me misuboukotiꞌ do viline losa geita noluvoba asi ve goloso ngemenguꞌ molavo goloso ikelizave losa alete molo-ngedeline losa noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Naza nene me misubouꞌ aleveti muliseutiꞌ minamuvoniꞌ neꞌmino engikisi nene me misubouꞌ aleveti muliseꞌningutiꞌ minamave. ");
INSERT INTO aso_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gamazi gihile lamineꞌ nene apize ngemo nedunuꞌ gono dalizadoꞌ do lisiheꞌ o-ngedo do kegese-ngedezo. Idoꞌ gamazi gihile laminekumuꞌ noluvoniꞌ meve nene geiꞌ gamazika nene gamazi gihile lamineꞌ neineꞌ nenako nemuꞌ nene noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gaza me misubouꞌ alevetinguꞌ nimiselanivo uvoniꞌ neꞌmino nazasi nene vekisine mene me misubouꞌ alevetinguꞌ nene ngimiseluve. ");
INSERT INTO aso_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Idoꞌ gamazi gihile lamineꞌ neꞌmo gonoꞌinemuꞌ do lisiheꞌ o-ngedavo mini kegesi minilizadoꞌ o neize. Nemuꞌ nene naza engikumuꞌ ve lo okoꞌne hulolodoꞌ naꞌniseꞌne nene mine kegese nouve. ");
INSERT INTO aso_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Idoꞌ geita noluvoniꞌ mene engikumukovoꞌ noluvoba asi engiꞌ gamaziꞌine gilisa nenikumuꞌ gili eleꞌvoleꞌ ilizavemukisi nene geita noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Idoꞌ geita engikumuꞌ noluvoniꞌ nene ingine bizi hamoꞌ minilizave losa geita noluve. Ee, meꞌneho make, gaza nenita nanivo naza geita nouvo nosineꞌ neꞌmine igi inginesi lelita bizi minikevo nelotiꞌ nene me misubouꞌ aleve nete nene nenikumuꞌ geiꞌ nimiselaineꞌ neive li ningi gili gili eleꞌvoleꞌ ilizave losa nemukisi nene geita noluve. ");
INSERT INTO aso_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Idoꞌ gaza nemaineꞌ amuzo ma nene laza hamoꞌ loloꞌ ogo nosineꞌ neꞌmine igi inginesi hamoꞌ liliꞌ igi minilizave lo engiꞌ ngemekuve. ");
INSERT INTO aso_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ee, naza engita nouvo gaza nenita nanivo neꞌmo engiꞌ nene bizi hamoꞌ gehepeve liliꞌ igi minikevo nelotiꞌ nene me misubouꞌ aleve nete nene geiꞌ nimiselaineꞌ ve idoꞌ gaza luka nemaaꞌ naineꞌ neꞌmino vekisine nene luka ngeme naineꞌ neive li ningi gililizave losa aꞌmine amuzo nene vekisine ngemekuve. ");
INSERT INTO aso_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ahonoo, misubo mene olihe do sotoꞌ amosa luka nemosa nemuꞌ amuzo atoliꞌmine ogo minineꞌ nemaineꞌ nene ningilizangumuꞌ nene aꞌmine geiꞌ do nemaineꞌ eveneꞌ nene neniꞌ mineloda nenikisi makaꞌ minelone losa gele nouve. ");
INSERT INTO aso_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ahonoo, ve lisiheꞌ gehepeve ve. Me misubouꞌ aleve nete nene geikumuꞌ ma ningi gilamaniꞌza neniꞌ neevoꞌ nene mo ningo gele nouvoniꞌ nenako vekise nete nene geiꞌ nimiselaineꞌ neive li ningi gili nizave. ");
INSERT INTO aso_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Idoꞌ naza geiꞌ monovoka nene mo lo-ngemekuvo gilikeve. Idoꞌ gohi ha lo-ngemelesuve. Nanitekumuꞌ ve. Gaza nenitoꞌ luka naba goloso nemaaꞌ naineꞌ monovo ma nene engita neivo nazasi engita mine molo minelongumuꞌ ve losa nene geiꞌ monovoka gohi lo-ngemelesuve. ");
INSERT INTO aso_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Izesuꞌ aza gamazi mene lo osuꞌ lo izipahala zuhosi Zelusalemi numuno ebekutiꞌ limi heta igi Kidiloni giꞌmize nosouꞌ nene ledi vi za zuho ma minida aꞌminguꞌ dizi minaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Izesukisi izipahala zuhosi nene aꞌminguꞌ igi di geseꞌ ikaꞌ ikaꞌ igaꞌ aniꞌ nenako biluvaliti aꞌninguꞌ molo-dive Zudaꞌ azasi nene aꞌmine ebekumuꞌ nene ha ningo gele minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Neꞌmine o neineꞌ nenako nemuꞌ nene Zudaꞌ nene Loma veti ami linge ma do idoꞌ eveneliti lihimeꞌine apaselive li Oꞌmoso guno gizi imaaꞌ ave nabasi Halisaioꞌ vesi mini ngimiselaniꞌ pilisi ve linge masi nene lovouꞌ initekisi idoꞌ lamusi livikisi davo ngeleꞌmizo aꞌmine za zuhouko nene aniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","nGeleꞌmizo ogavo Izesuꞌ aza ezela sotoꞌ ilineꞌ initeꞌ mukikumuꞌ nene mo gele mino engiꞌ nizada ogo hetelo zahinemuꞌ viseꞌ iꞌmi nave lo longoꞌ o-ngidineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Neꞌmine lo longoꞌ o-ngedavo laza Nasalete ve Izesuꞌni nene viseꞌ oꞌmo noune li ingine laniꞌ. Neꞌmine likevo Izesuꞌ tiꞌ lo lo-ngimineꞌ: Aꞌmine ve ma nene nouve. Idoꞌ aꞌmine Izesuꞌni biluvaliti aꞌninguꞌ molave nene engikisi aꞌmida ote minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Idoꞌ Izesuꞌ aza aꞌmine ve ma nene nouve nolivo analoꞌ dalisa ave nene meheꞌnidatiꞌ nene lomi limi misuboloꞌ pouꞌ li inganiꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Neꞌmine ikevo zahinemuꞌ viseꞌ iꞌmi nave lo gohi longoꞌ o-ngedavo laza Nasalete ve Izesuꞌni mamuꞌ viseꞌ oꞌmo noune li laniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Neꞌmine likevo Izesuꞌ aꞌmidoꞌ tiꞌ lo lineꞌ ve: Aꞌmine viseꞌ iꞌmi nave ma nene nouve lo lo-lingimuvoniꞌ ma ve. Aꞌmine viseꞌ iꞌmi nave ma nene nouvonaze. Lingine vekisine menesi nene aꞌnidoꞌ dami ha huli-ngidikevo vilizave. ");
INSERT INTO aso_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Neꞌmine lo lineꞌ nene gomuꞌ melehinemuꞌ nene gaza nemaineꞌ eveneꞌ hamokisi ma vo tolovo amive lo lineꞌ gamazi ma nene gihile izelive losa nene lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Neꞌmine lavo Simoni Petoloꞌ neꞌmo nene bainati miteꞌ do minineꞌ nenako aꞌmine nene goꞌveutiꞌ geleleheꞌ oko evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve nabaliꞌmi gelekeleꞌ ve belo gala zamela nene hasaꞌ o hulineꞌ ve. Aꞌmine gelekeleꞌ ve neꞌmi gulive nene Malakusiꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Neꞌmine ogavo Izesuꞌ aza Petoloꞌni nene tiꞌ lo lo-imineꞌ: Gaza nene meꞌneho geheline losa nimineꞌ geni ekeseꞌ noso neꞌmine nene geheloniꞌ o neineꞌ ma nene gelamabe. Gaza aka hize tile-nedamo aꞌmine bainati miteka nene goꞌveuꞌ goꞌzekezo. ");
INSERT INTO aso_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Neꞌmine lavo amisi idoꞌ engiꞌ guveꞌinesi ve naba nesi idoꞌ Zuda veti pilisi vesi nene Izesuꞌni analoꞌ di nalaꞌ di-disa ");
INSERT INTO aso_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","aꞌmine kilisimasiuꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve nabaꞌine minive Kaiahaꞌ izemo Anasiꞌ neida nene gomuꞌ eleꞌmizi vaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aꞌmine Kaiahaꞌ nene Zuda ve naba gaꞌine do eveneꞌ mukitoꞌ medelo ve hamokovoꞌ helelineꞌ nene lamineꞌ o neive live minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petoloꞌ nene Izesuꞌ izipahala masi Izesuꞌni eꞌmeti vasineꞌ ve. Aꞌmine Izesuꞌ izipahala ma neve nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve naba neꞌmosi nene mo ninge neive minineꞌ nenako Izesuꞌni eleꞌmizi aꞌmine evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve nabaꞌmi numuno vodo vodo ogo minavo olusoꞌ omoꞌ naba mininguꞌ dizanguꞌ nene azasi aꞌminguꞌ dizineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dizineꞌza Petoloꞌ nene dizamo heta gatedoꞌ ha ote minineꞌ ve. Nemuꞌ nene aꞌmine Izesuꞌ izipahala ma ve naba neꞌmosi ninge neive minive nene lemo gatedoꞌ gizebo ogo minineꞌ gelekeleꞌ alu ma nene Petoloꞌnimuꞌ lo-emosa eleꞌmizo dizineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Neꞌmine ogavo gatedoꞌ gizebo ogo minineꞌ alu neꞌmo nene Petoloꞌni tiꞌ lo longoꞌ o-dineꞌ: Geikisi nene aꞌmine Izesuꞌ izipahala zuhoutiꞌ nomo nolosane. Olo. Neꞌmine lo longoꞌ o-davo aza nene oꞌove. Engikutiꞌ nomuve lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Idoꞌ aꞌmine gameneloꞌ nene mo hepeꞌ noilivo gelekeleꞌ vesi idoꞌ pilisi vesi nene oloꞌ siꞌnibuloꞌ nene ingi viteꞌ iki lahizi minaniꞌ ve. Neꞌmine igi nizavo Petoloꞌ nesi nene aꞌmida ote mino lahizo minineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Idoꞌ evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve nabaꞌine Anasiꞌ neꞌmo Izesuꞌni nene izipahala zuhomukisi idoꞌ eveneꞌ gamazi apize ngemaaꞌ ineꞌ nemukisi nene longoꞌ o-davo ");
INSERT INTO aso_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Izesuꞌ aꞌmidoꞌ tiꞌ lo lo-imineꞌ: Naza eveneꞌ mukiliti veꞌnidoꞌ nene gamazi sotokovoꞌ laaꞌ uvoniꞌ ma ve. Ee, Zuda ve mukiꞌ di geseꞌ igaꞌ ada monoꞌ numuno ngomo ngomoukisi monoꞌ numuno nabaꞌ nabaukisi nene gamazi apize ngemaaꞌ uvoniꞌ ma ve. Idoꞌ haleke mino gamazi ma losaꞌmuvoniꞌ ma ve. ");
INSERT INTO aso_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Neniꞌ neve nene nanitekumuꞌ longoꞌ noo-nedane. Gamazi noluvo gilave nete aꞌmine luvoniꞌ gamazi nene gili nizaniꞌ nenaze. Engiꞌ nene longoꞌ o-ngedevo. ");
INSERT INTO aso_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Neꞌmine lavo aꞌmida pilisi ve minangutiꞌ maliꞌmo nene ana gavoso golo veleuꞌ belo tiꞌ lo lineꞌ: Gaza evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve nabamuꞌ nene neꞌmine gamazi lo-emamilinako nanimuꞌ neꞌmine lo-emane. ");
INSERT INTO aso_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Neꞌmine lavo aꞌmidoꞌ nene Izesuꞌ tiꞌ lo lo-dineꞌ: Naza gamazi goloso ma luvoniꞌ neivo ma nene aꞌmine gamazi goloso neꞌmi monovo nene lo sotoꞌ ozo. Idoꞌ naza nene mo laminetokovoꞌ noluvoniꞌ nolineꞌ nene gaza hazamuꞌ nanimuꞌ nonebelane. ");
INSERT INTO aso_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Neꞌmine lavo nalaꞌ di-dikaniꞌ ha neivo Anasiꞌ nene evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve naba Kaiahaꞌ neida eleꞌmizi vilo lo aꞌmida ngimiselineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Idoꞌ Petoloꞌ nene oloꞌ lahizo neivo tiꞌ li longoꞌ i-daniꞌ: Geikisi nene aꞌmine veꞌmi izipahala zuhoutiꞌ nomo nolosane. Olo. Neꞌmine likevo aza nene aꞌmidoꞌ oꞌove. Naza nene engikutiꞌ nomuve lo ataize lineꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Neꞌmine lavo evenetoꞌ medeli mini Oꞌmoso initeꞌ lehizi-daaꞌ aveliti ve nabaliꞌmi gelekeleꞌ ve Petoloꞌ gala huko huliveꞌmi zuho minive maliꞌmo nene tiꞌ lo lineꞌ ve: Gaza nene Oliva golo za zuhouꞌ Izesulesi nizavo ninguve ma ne nane. Olo. ");
INSERT INTO aso_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Neꞌmine lavo Petoloꞌ gohi ataize lineꞌ. Lavo aꞌmidoꞌ liteꞌ lo okoloho nolo molaniꞌ ve. ");
INSERT INTO aso_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Neꞌmine ogavo Zuda ve nete nedengaꞌ holukaꞌ nene Kaiahaꞌ numuꞌveutiꞌ nene Izesuꞌni eleꞌmizi Loma ve Zudaia misubouꞌ ngamani naba loloꞌ o miniveꞌmi numuꞌvela nene vaniꞌ ve. Neꞌmine aniꞌza laza avotemote Aigita misubouꞌ minaniꞌ gameneuꞌ Oꞌmosoꞌmo iseꞌine izingumuꞌ gel