﻿USE sofia;
DROP TABLE IF EXISTS sofia.asmfb_vpl;
CREATE TABLE asmfb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES asmfb_vpl WRITE;
INSERT INTO asmfb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","আদিতে ঈশ্বৰে আকাশ-মণ্ডল আৰু পৃথিৱী সৃষ্টি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","পৃথিবীৰ আকাৰ নাছিল আৰু সম্পূর্ণ শূণ্য আছিল; তাৰ ওপৰত আন্ধাৰে ঢকা অগাধ জল আছিল আৰু ঈশ্বৰৰ আত্মাই সেই জলৰ ওপৰত উমাই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ঈশ্বৰে ক’লে, “পোহৰ হওক,” তেতিয়া পোহৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ঈশ্বৰে পোহৰক অতি উত্তম দেখিলে; তেওঁ আন্ধাৰৰ পৰা পোহৰক পৃথক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","পাছত ঈশ্বৰে পোহৰৰ নাম “দিন” আৰু আন্ধাৰৰ নাম “ৰাতি” হ’ল। এইদৰে গধূলি হ’ল আৰু পুৱা হোৱাত এক দিন হ’ল। পাছত ঈশ্বৰে পোহৰৰ নাম দিন, আৰু আন্ধাৰৰ নাম ৰাতি থলে। গধূলি আৰু পুৱা হোৱাত প্রথম দিন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","তাৰ পাছত ঈশ্বৰে ক’লে, “জলৰ মাজত ভাগ হৈ এক বিস্তৃত খালী অংশ হওঁক আৰু ই জলক দুভাগ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","এইদৰে ঈশ্বৰে জলৰ মাজত এক খালী অংশৰ সৃষ্টি কৰিলে আৰু তলত থকা জল ভাগৰ পৰা ওপৰৰ জল ভাগক পৃথক কৰিলে; তাতে তেনেদৰেই হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ঈশ্বৰে সেই বিস্তৃত খালী অংশৰ নাম “আকাশ” ৰাখিলে। গধূলি আৰু পুৱা হ’লত, দ্বিতীয় দিন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","তাৰ পাছত ঈশ্বৰে ক’লে, “আকাশৰ তলত থকা জল ভাগ এক ঠাইত আহি গোট খাওঁক আৰু শুকান ভূমি ওলাওক;” তেতিয়া তেনেদৰেই হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ঈশ্বৰে শুকান ভূমিৰ নাম “স্থল” আৰু গোট খোৱা জল ভাগৰ নাম “সমুদ্ৰ” হ’ল; তেতিয়া ঈশ্বৰে ইয়াক উত্তম দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ঈশ্বৰে ক’লে, “ভূমিয়ে ঘাঁহ-বন, শস্য উৎপাদনকাৰী উদ্ভিদ আৰু বীজ থকা গছ উৎপন্ন কৰক; বিভিন্ন ধৰণৰ ভিতৰত গুটি থকা ফলৰ গছ স্থলভাগৰ ওপৰত গজি উঠক।” তাতে তেনেদৰেই হ’ল; ");
INSERT INTO asmfb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ভূমিত ঘাঁহ-বন, শস্যদায়ী উদ্ভিদ আৰু বীজ থকা গছ উৎপন্ন হ’ল; বিভিন্ন ধৰণৰ ফলৰ গছ হ’ল আৰু ফলৰ ভিতৰত গুটি হ’ল। তেতিয়া ঈশ্বৰে এইবোৰ উত্তম দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","গধূলি আৰু পুৱা হোৱাৰ পাছত তৃতীয় দিন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","তাৰ পাছত ঈশ্বৰে ক’লে, “পোহৰ হ’বলৈ আকাশত অনেক জ্যোতিবোৰ হওঁক; সেই পোহৰে ৰাতিৰ পৰা দিনক পৃথক কৰিব। সেইবোৰ বেলেগ বেলেগ ঋতু, দিন আৰু বছৰৰ চিন ৰূপে ব্যৱহাৰ হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","সেইবোৰে পৃথিবীৰ ওপৰত পোহৰ দিবলৈ আকাশত প্ৰদীপস্বৰূপ হওঁক।” তেতিয়া তেনেদৰেই হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ঈশ্বৰে দিনৰ ওপৰত অধিকাৰ চলাবলৈ এক মহা-জ্যোতি, আৰু ৰাতিৰ ওপৰত অধিকাৰ চলাবলৈ তাতকৈ এক ক্ষুদ্ৰ-জ্যোতি, এই দুই বৃহৎ জ্যোতি আৰু তৰাবোৰকো নিৰ্ম্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ঈশ্বৰে সেইবোৰক আকাশৰ মাজত স্থাপন কৰিলে যাতে সেইবোৰে পৃথিবীৰ ওপৰত পোহৰ দিয়ে; ");
INSERT INTO asmfb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","দিন আৰু ৰাতিৰ ওপৰত অধিকাৰ চলায় আৰু আন্ধাৰৰ পৰা পোহৰক পৃথক কৰে। তেতিয়া ঈশ্বৰে ইয়াক উত্তম দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","গধূলি আৰু পুৱা হোৱাৰ পাছত চতুৰ্থ দিন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","তাৰ পাছত ঈশ্বৰে ক’লে, “বিভিন্ন প্রাণীৰে জল ভাগ পূর্ণ হওঁক আৰু পৃথিবীৰ ওপৰ ভাগত আকাশৰ মাজত চৰাইবোৰ উড়ি ফুৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","এইদৰে ঈশ্বৰে ডাঙৰ ডাঙৰ সাগৰীয় প্রাণী, জলৰ মাজত বিচৰণ কৰা বিভিন্ন প্রকাৰৰ উৰগ প্রাণী আৰু নানাবিধ ডেউকা থকা চৰাই সৃষ্টি কৰিলে; তেতিয়া ঈশ্বৰে এইবোৰ উত্তম দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ঈশ্বৰে সেইবোৰক আশীৰ্ব্বাদ কৰি ক’লে, “বংশ বৃদ্ধি কৰি তোমালোকে নিজৰ সংখ্যা বঢ়াই তোলা আৰু সমুদ্ৰবোৰৰ পানী পৰিপূৰ্ণ কৰা; পৃথিবীৰ ওপৰত চৰাইবোৰেও নিজৰ সংখ্যা বৃদ্ধি কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","গধূলি আৰু পুৱা হোৱাৰ পাছত পঞ্চম দিন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","তাৰ পাছত ঈশ্বৰে ক’লে, “পৃথিৱীত বিভিন্ন ধৰণৰ প্ৰাণী উৎপন্ন হওঁক; ঘৰচীয়া পশু, বগাই ফুৰা প্ৰাণী আৰু নানা বিধ বনৰীয়া জন্তু উৎপন্ন হওঁক।” তাতে তেনেকুৱাই হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ঈশ্বৰে বিভিন্ন বনৰীয়া জন্তু, বিভিন্ন ঘৰচীয়া পশু আৰু মাটিত বগাই ফুৰা বিভিন্ন প্ৰাণী নিৰ্ম্মাণ কৰিলে। তেতিয়া ঈশ্বৰে এইবোৰ উত্তম দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","তাৰ পাছত ঈশ্বৰে ক’লে, “আমি নিজৰ প্ৰতিমুৰ্ত্তিৰ দৰে আমাৰ সাদৃশ্যেৰে মানুহ নিৰ্ম্মাণ কৰোঁহক; তেওঁলোকে সমুদ্ৰৰ মাছ, আকাশৰ চৰাই, ঘৰচীয়া পশু, সমুদায় পৃথিৱী আৰু পৃথিবীত বগাই ফুৰা প্রাণীৰ ওপৰত অধিকাৰ চলাওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","তেতিয়া ঈশ্বৰে নিজৰ প্ৰতিমূৰ্ত্তিৰে মানুহ সৃষ্টি কৰিলে; ঈশ্বৰে নিজৰ প্ৰতিমূৰ্ত্তিৰেই মানুহ সৃষ্টি কৰিলে; তেওঁ তেওঁলোকক পুৰুষ আৰু স্ত্ৰী কৰি সৃষ্টি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","পাছত ঈশ্বৰে তেওঁলোকক আশীৰ্ব্বাদ কৰি ক’লে, “তোমালোক বহুবংশ হোৱা; বাঢ়ি বাঢ়ি পৃথিবীখন পৰিপূৰ্ণ কৰা আৰু তাক বশীভুত কৰা; সমুদ্ৰৰ মাছ; আকাশৰ চৰাই, আৰু পৃথিবীৰ ওপৰত বিচৰণ কৰা সকলো প্রাণীৰ ওপৰত অধিকাৰ চলোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ঈশ্বৰে ক’লে, “চোৱা, গোটেই পৃথিবীৰ ওপৰিভাগত গুটি উৎপন্ন কৰা গছ আৰু ভিতৰত গুটি থকা সকলো ফলধৰা গছ মই তোমালোকক দিলোঁ; সেয়ে তোমালোকৰ আহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","সকলো বনৰীয়া জন্তু, আকাশৰ সকলো চৰাই আৰু মাটিত বগাই ফুৰা সকলো প্রাণীৰ আহাৰৰ কাৰণে সকলো কেচাঁ বন দিলোঁ।” তাতে তেনেকুৱাই হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","পাছত ঈশ্বৰে নিজে নিৰ্ম্মাণ কৰা সকলোকে চালে। সেইবোৰ চাই অতি উত্তম পালে। গধূলি আৰু পুৱা হোৱাৰ পাছত ষষ্ঠ দিন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","এনেদৰে আকাশ-মণ্ডল আৰু পৃথিৱী নির্ম্মাণ কৰা হ’ল; আৰু উভয়কে সকলোৰে পৰিপূর্ণ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ইতিমধ্যে ঈশ্বৰে তেওঁৰ কাম শেষ কৰি সপ্তম দিনত সোমাল আৰু সেইদিনা সকলো কাৰ্যৰ পৰা তেওঁ বিশ্ৰাম ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ঈশ্বৰে সেই সপ্তম দিনক আশীৰ্ব্বাদ কৰি পবিত্ৰ কৰিলে; কিয়নো সেইদিনা ঈশ্বৰে নিজৰ সকলো সৃষ্টি কাৰ্যৰ পৰা বিশ্ৰাম ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","এয়াই হৈছে আকাশ-মণ্ডল আৰু পৃথিৱী সৃষ্টিৰ ইতিহাস। ঈশ্বৰ যিহোৱাই যিদিনা পৃথিৱী আৰু আকাশ-মণ্ডল নিৰ্ম্মাণ কৰিলে, সেই কালৰ ঘটনাৰ বিৱৰণ এই। ");
INSERT INTO asmfb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","তেতিয়াও পৃথিবীৰ পথাৰত একো তৃণ আদি নাছিল; পথাৰত কোনো শস্যদায়ী গছ গজা নাছিল; কিয়নো তেতিয়াও ঈশ্বৰ যিহোৱাই পৃথিবীত বৰষুণ বৰষোৱা নাছিল আৰু মাটি চহাবৰ কাৰণে মানুহো নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","কিন্তু পৃথিবীৰ পৰা এক ঘন কুঁৱলী উঠি আহিল আৰু গোটেই ভূমি ভিজালে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ঈশ্বৰ যিহোৱাই মাটিৰ পৰা ধুলি লৈ মানুহ নিৰ্ম্মাণ কৰিলে আৰু সেই মানুহৰ নাকত ফু দি নিশ্বাস সুমুৱাই দিলে; তাতে মানুহ জীৱন্ত প্ৰাণী হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ঈশ্বৰ যিহোৱাই পূবফালে এদনত এখন বাৰী পাতিলে আৰু তাতে তেওঁ নিজে নিৰ্ম্মাণ কৰা মানুহক ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","সেই ঠাইৰ মাটিত ঈশ্বৰ যিহোৱাই দেখিবলৈ সুন্দৰ, খাবলৈকো ভাল এনে সকলো জাতৰ গছ উৎপন্ন কৰিলে; বাৰীৰ মাজত তেওঁ জীৱন-বৃক্ষ আৰু ভাল বেয়া জ্ঞান দিওঁতা বৃক্ষকো উৎপন্ন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","সেই বাৰীত পানী দিবৰ কাৰণে এদনৰ পৰা এখন নদী ওলাই আহিছিল আৰু সেই ঠাইৰ পৰাই নদীখন চাৰিটা উপনৈত ভাগ হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","প্ৰথম নৈৰ নাম পীচোন; এই নদীখন সমুদায় হবীলা দেশকে ঘেৰি বৈ গৈছে; এই দেশত সোণ পোৱা যায়। ");
INSERT INTO asmfb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","সেই দেশৰ সোণ উত্তম; তাত গুগগুলু আৰু বহুৰঙী মূল্যৱান পাথৰো পোৱা যায়। ");
INSERT INTO asmfb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","দ্বিতীয় নৈখনৰ নাম গীহোন। এই নদী কুচ দেশখনক ঘেৰি বৈ গৈছে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","তৃতীয় নৈখনৰ নাম হিদ্দেকেল। সেই নদী অচুৰ দেশৰ পূবদিশে বৈ গৈছে। চতুৰ্থ নদীখনৰ নাম হৈছে ফৰাৎ। ");
INSERT INTO asmfb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ঈশ্বৰ যিহোৱাই মানুহক নি এদন বাৰীত ৰাখিলে যাতে তেওঁ তাত কাম কৰে আৰু তাৰ যত্ন লয়। ");
INSERT INTO asmfb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ঈশ্বৰ যিহোৱাই মানুহক এই আজ্ঞা দিলে, “তুমি বাৰীৰ সকলো গছৰ ফল স্বচ্ছন্দে খাব পাৰা; ");
INSERT INTO asmfb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","কিন্তু ভাল বেয়া জ্ঞান দিওঁতা গছৰ ফল হ’লে নাখাবা; কিয়নো যি দিনা তুমি তাক খাবা, সেই দিনা অৱশ্যেই তোমাৰ মৃত্যু হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","তাৰ পাছত ঈশ্বৰ যিহোৱাই ক’লে, “মানুহ অকলে থকা ভাল নহয়; মই তেওঁৰ বাবে এজন উপযুক্ত সহকাৰী নিৰ্ম্মাণ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ঈশ্বৰ যিহোৱাই মাটিৰ পৰা সকলো প্রকাৰৰ জীৱ-জন্তু আৰু আকাশৰ চৰাইবোৰ নিৰ্ম্মাণ কৰিলে; তাৰ পাছত তেওঁ সকলো প্রাণীকে মানুহৰ ওচৰলৈ আনিলে; তেওঁ চাব বিচাৰিলে যে মানুহে সেই সকলোবোৰক কি নাম দি মাতে। তেওঁ সেই প্রাণীবোৰৰ যাক যি নামেৰে মাতিলে, তাৰ নাম সেয়ে হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","মানুহে সকলো ঘৰচীয়া পশু, আকাশৰ চৰাই, বনৰীয়া জন্তুবোৰৰ নাম দিলে; কিন্তু মানুহে নিজৰ কাৰণে সেইবোৰৰ মাজত উপযুক্ত সহকাৰী নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","সেয়ে ঈশ্বৰ যিহোৱাই মানুহলৈ গভীৰ টোপনি আনিলে; তাতে তেওঁ গভীৰ টোপনি গ’ল। তেতিয়া ঈশ্বৰ যিহোৱাই তেওঁৰ এডাল কামী-হাড় উলিয়াই সেই ঠাই মঙহেৰে পুৰালে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ঈশ্বৰ যিহোৱাই মানুহৰ পৰা উলিওৱা কামী-হাড়ডালেৰে এগৰাকী স্ত্ৰী নিৰ্ম্মাণ কৰি তেওঁক মানুহৰ ওচৰলৈ লৈ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","তেতিয়া মানুহে ক’লে, “এতিয়া হৈছে; এওঁ মোৰ হাড়ৰো হাড়, মোৰ মঙহৰো মঙহ; এওঁক ‘নাৰী’ বুলি মতা হ’ব; কিয়নো এওঁক নৰৰ পৰা লোৱা হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","সেইবাবে মানুহে নিজৰ পিতৃ মাতৃক ত্যাগ কৰি তেওঁৰ স্ত্রীৰ প্রতি আসক্ত হ’ব আৰু তেওঁলোক দুয়োজন এক দেহ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","সেই সময়ত সেই মানুহ আৰু তেওঁৰ স্ত্রী দুয়োজন বিবস্ত্ৰ আছিল; কিন্তু তাক তেওঁলোকে লাজ বুলি নাজানিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ঈশ্বৰ যিহোৱাই নিৰ্ম্মাণ কৰা সকলো বন্য প্রাণীৰ মাজত সৰ্প আছিল আটাইতকৈ টেঙৰ। সেই সর্পই এদিন নাৰী গৰাকীক ক’লে, “ঈশ্বৰে কি সঁচাই ‘তোমালোকে বাৰীত থকা কোনো গছৰ ফল নাখাবা’এইবুলি তোমালোকক ক’লে নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","নাৰীয়ে সৰ্পক ক’লে, “বাৰীৰ গছবোৰৰ ফল আমি খাব পাৰোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","কিন্তু বাৰীৰ মাজত থকা গছ জোপাৰ ফলৰ বিষয়ে হ’লে আমাক ঈশ্বৰে ক’লে, ‘তোমালোকে তাক নাখাবাও, নুচুবাও; তাকে কৰিলে তোমালোকৰ মৃত্যু হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","তেতিয়া সৰ্পই নাৰীক ক’লে, “দৰাচলতে তোমালোকৰ মৃত্যু নহয়। ");
INSERT INTO asmfb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","কিয়নো ঈশ্বৰে জানে যে, যিদিনাই তোমালোকে সেই গছৰ ফল খাবা, সেইদিনাই তোমালোকৰ চকু মুকলি হ’ব। তাতে তোমালোকে ভাল বেয়া জানোতা হৈ ঈশ্বৰৰ নিচিনা হ’বা।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","নাৰীগৰাকীয়ে যেতিয়া বুজিলে যে সেই গছৰ ফল খাবলৈ ভাল হব; ই দেখাত লোভনীয় আৰু জ্ঞান লাভ কৰা কথাটোও মনোমোহা; তেতিয়া নাৰীগৰাকীয়ে তাৰ পৰা কেইটামান ফল চিঙি খালে আৰু লগত থকা তেওঁৰ গিৰিয়েককো দিলে; তাতে তেৱোঁ খালে। ");
INSERT INTO asmfb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","তেতিয়া তেওঁলোক দুয়োজনৰ চকু মুকলি হ’ল। তেওঁলোক যে বিবস্ত্ৰ অৱস্থাত আছে, এই বিষয়ে বুজি পালে। সেয়ে তেওঁলোকে ডিমৰু গছৰ পাতবোৰ একেলগে জোৰা লগাই নিজৰ কাৰণে কপিং চিলাই ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","পাছত যেতিয়া সন্ধ্যাবেলাৰ শীতল বতাহ ববলৈ ধৰিলে, তেতিয়া সেই মানুহ আৰু তেওঁৰ স্ত্রীয়ে বাৰীৰ মাজত ঈশ্বৰ যিহোৱাৰ খোজৰ শব্দ শুনিবলৈ পালে আৰু তেওঁৰ সৈতে সাক্ষাৎ নহ’বলৈ গছবোৰৰ মাজত লুকালগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ঈশ্বৰ যিহোৱাই মানুহক মাতি সুধিলে, “তুমি ক’ত আছা?” ");
INSERT INTO asmfb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","মানুহে ক’লে, “মই বাৰীত আপোনাৰ শব্দ শুনি মোৰ বিবস্ত্ৰতাৰ কাৰণে ভয় কৰি লুকাই আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ঈশ্বৰে ক’লে, “তুমি যে বিবস্ত্ৰ, তাক তোমাক কোনে ক’লে? যি গছৰ ফল নাখাবা বুলি মই তোমাক নিষেধ কৰিছিলোঁ, তাক তুমি খালা নেকি?” ");
INSERT INTO asmfb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","তেতিয়া মানুহে ক’লে, “যি স্ত্রী গৰাকীক আপুনি মোৰ সঙ্গীনী কৰি দিলে, তেঁৱেই মোক সেই গছৰ ফল দিলে আৰু সেই ফল মই খালোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","তেতিয়া ঈশ্বৰ যিহোৱাই সেই নাৰীক ক’লে, “তুমি এইটো কি কৰিলা?” নাৰীয়ে ক’লে, “সৰ্পই মোক ছলনা কৰি ভুলালে আৰু সেয়ে মই তাক খালো।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ঈশ্বৰ যিহোৱাই সৰ্পক ক’লে, “তোৰ এই কার্যৰ কাৰণে ভূমিৰ সকলো ঘৰচীয়া আৰু বনৰীয়া প্রাণীবোৰৰ মাজত কেৱল তোকে অভিশপ্ত কৰা হ’ল। তই পেটেৰে গতি কৰিবি আৰু তোৰ জীৱনৰ গোটেই কালত ধুলি খাবি। ");
INSERT INTO asmfb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","মই তোৰ আৰু নাৰীৰ মাজত, তোৰ বংশ আৰু নাৰীৰ বংশৰে মাজত শত্রুতা সৃষ্টি কৰিম; তেওঁ তোৰ মূৰ গুড়ি কৰিব আৰু তই তেওঁৰ ভৰিৰ গোৰোহা গুড়ি কৰিবি।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","তাৰ পাছত ঈশ্বৰে নাৰীক ক’লে, “মই তোমাৰ গৰ্ভ-বেদনা অতিশয় ৰূপে বৃদ্ধি কৰিম; তুমি কষ্টেৰে সন্তান প্ৰসৱ কৰিবা; স্বামীৰ কাৰণে তোমাৰ কামনা হ’ব, কিন্তু তেওঁ তোমাৰ ওপৰত অধিকাৰ চলাব।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","তেওঁ আদমক ক’লে, “যি গছৰ ফল খাবলৈ মই তোমাক নিষেধ কৰিছিলোঁ, তুমি তোমাৰ স্ত্রীৰ কথা শুনি তাক খালা। সেয়ে তোমাৰ কাৰণে ভূমি অভিশপ্ত হৈছে। তুমি গোটেই জীৱন কালত কষ্টৰে পৰিশ্রম কৰি তাৰ পৰা খাবলৈ পাবা। ");
INSERT INTO asmfb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ভূমিয়ে তোমালৈ কাঁইট আৰু কাঁইটীয়া বন উৎপন্ন কৰিব আৰু তুমি পথাৰৰ শস্য ভোজন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","মাটিলৈ উলটি নোযোৱা পর্যন্ত মূৰৰ ঘাম পেলাই তুমি আহাৰ কৰিব লাগিব; কিয়নো তোমাক মাটিৰ পৰা লোৱা হৈছিল; তুমি ধুলি মাথোন আৰু পুনৰায় ধুলিলৈকে উলটি যাবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","পাছত মানুহে নিজৰ ভার্য্যাৰ নাম হৱা ৰাখিলে; কিয়নো তেওঁ সকলো জীৱিত লোকৰ মাতৃ। ");
INSERT INTO asmfb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ঈশ্বৰ যিহোৱাই আদম আৰু তেওঁৰ ভাৰ্যাৰ কাৰণে ছালৰ বস্ত্ৰ তৈয়াৰ কৰি তেওঁলোকক পিন্ধাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","তাৰ পাছত ঈশ্বৰ যিহোৱাই ক’লে, “চোৱা, ভাল বেয়া জ্ঞান পাই মানুহ আমাৰ এজনৰ নিচিনা হৈ গৈছে। সেয়ে এতিয়া আমি মানুহক এই অনুমতি দিব নালাগে যেন তেওঁ হাত আগবঢ়াই জীৱন বৃক্ষৰ ফল পাৰি খাই সদাকাললৈকে জীৱিত হৈ থাকে।” ");
INSERT INTO asmfb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","এইবুলি কৈ ঈশ্বৰ যিহোৱাই মাটিৰ পৰা নির্ম্মাণ কৰা মানুহক মাটিত খেতি কৰিবৰ বাবে এদন বাৰীৰ পৰা বাহিৰ কৰি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","এইদৰে ঈশ্বৰে মানুহক এদন বাৰীৰ পৰা খেদাই দিলে; তাৰ পাছত জীৱন-বৃক্ষৰ ওচৰলৈ যোৱাৰ পথ ৰখিবলৈ, এদন বাৰীৰ পুবফালে কৰূবসকলক ৰাখিলে আৰু চাৰিওফালে ঘূৰি থকা এখন জলন্তময় তৰোৱালকো তাত থলে। ");
INSERT INTO asmfb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","মানুহে তেওঁৰ ভাৰ্যা হৱাৰ সৈতে একেলগ হোৱাত তেওঁ গৰ্ভৱতী হৈ কয়িনক প্ৰসৱ কৰিলে। তেতিয়া হৱাই ক’লে, “যিহোৱাৰ সহায়ত মই এটি পুত্র সন্তান পালোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","পাছত তেওঁ পুনৰায় কয়িনৰ ভায়েক হেবলক প্ৰসৱ কৰিলে। হেবল এজন মেৰ-ছাগৰ পালক আৰু কয়িন কৃষক হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","পাছত এটা সময়ত কয়িনে যিহোৱাৰ উদ্দেশ্যে তেওঁৰ ভূমিত উৎপন্ন হোৱা কিছু ফল উৎসৰ্গ কৰিলে; ");
INSERT INTO asmfb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","হেবলেও নিজৰ জাকৰ পৰা প্ৰথমে জগা কেইটামান পশু আৰু সেইবোৰৰ চর্বি উৎসৰ্গ কৰিলে। যিহোৱাই হেবলক আৰু তেওঁৰ উৎসর্গ গ্ৰহণ কৰিলে; ");
INSERT INTO asmfb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","কিন্তু কয়িনক আৰু তেওঁৰ উৎসৰ্গক হলে গ্ৰহণ নকৰিলে। সেয়ে কয়িনৰ অতিশয় খং উঠিল আৰু তেওঁৰ মুখো ক’লা পৰি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","তেতিয়া যিহোৱাই কয়িনক ক’লে, “কিয় খং কৰিছা আৰু কেলেই বা মুখ ক’লা কৰি আছা? ");
INSERT INTO asmfb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","তুমি যদি ভাল কাম কৰা, তেন্তে জানো তোমাক গ্ৰহণ কৰা নহ’ব? কিন্তু যদি ভাল কাম নকৰা, তেন্তে পাপে তোমাক তাৰ বশ কৰিবলৈ দুৱাৰ মুখত খাপ পাতি থাকে; সেয়ে তুমি তাক দমন কৰিব লাগে।” ");
INSERT INTO asmfb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","তাৰ পাছত এদিন খেতি-পথাৰত থকাৰ সময়ত কয়িনে ভায়েক হেবলৰ লগত কথা কৈ আছিল আৰু তেতিয়া কয়িনে নিজ ভায়েক হেবলৰ বিৰুদ্ধে উঠি তেওঁক বধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","তেতিয়া যিহোৱাই কয়িনক সুধিলে, “তোমাৰ ভাই হেবল ক’ত আছে?” কয়িনে ক’লে, “মই নেজানো, মই মোৰ ভাইৰ ৰখীয়া নেকি?” ");
INSERT INTO asmfb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","তেতিয়া যিহোৱাই ক’লে, “তুমি কি কৰিলা? তোমাৰ ভাইৰ তেজে ভূমিৰ পৰা মোলৈ চিঞৰি মাতিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","সেয়ে যি ভূমিয়ে তোমাৰ হাতৰ পৰা তোমাৰ ভাইৰ তেজ গ্ৰহণ কৰিবৰ কাৰণে মুখ মেলিলে, সেই ভূমিৰ পৰাই তুমি অভিশপ্ত হ’লা। ");
INSERT INTO asmfb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","এতিয়াৰে পৰা তুমি ভূমিত খেতি কৰিলেও ভুমিৰ পৰা উৎপাদিত বহু শস্য তুমি নাপাবা। তুমি পৃথিবীত পলৰীয়া আৰু থানথিত নোহোৱা হ’বা।” ");
INSERT INTO asmfb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","তেতিয়া কয়িনে যিহোৱাক ক’লে, “এই শাস্তি মোৰ বাবে অসহনীয়। ");
INSERT INTO asmfb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","আজি আপুনি মোক ভূমিৰ পৰা খেদি পঠালে; মই আপোনাৰ সন্মুখৰ পৰা লুকাই থকিব লগা হ’ব; এই পৃথিবীত পলৰীয়া হৈ মই যেতিয়া ঘূৰি ফুৰিব লগা হ’ব, তেতিয়া যেয়ে মোক পাব তেৱেঁ মোক বধ কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","তেতিয়া যিহোৱাই তেওঁক ক’লে, “তেনেহলে যি কোনোৱে তোমাক বধ কৰিব, তেওঁৰ ওপৰত সাতগুণ প্ৰতিশোধ লোৱা হ’ব।” তাৰ পাছত যিহোৱাই কয়িনৰ বাবে এনে এটা চিন দিলে যেন কোনেও তেওঁক পাই বধ নকৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","তাৰ পাছত কয়িনে যিহোৱাৰ সন্মুখৰ পৰা ওলাই গৈ, এদনৰ পূব দিশে থকা নোদ দেশত বাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","কয়িনে তেওঁৰ ভার্য্যাৰ সৈতে একেলগ হোৱাত, তেওঁ গৰ্ভৱতী হৈ হনোকক প্ৰসৱ কৰিলে; কয়িনে এখন নগৰ নিৰ্ম্মাণ কৰিলে আৰু পুত্রৰ নাম অনুসাৰে সেই নগৰখনৰ নাম হনোক ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","হনোকৰ পুতেকৰ নাম ঈৰদ, ঈৰদৰ পুতেকৰ নাম মহুৱায়েল, মহুৱায়েলৰ পুতেকৰ নাম মথুচায়েল, মথুচায়েলৰ পুতেকৰ নাম লেমক। ");
INSERT INTO asmfb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","লেমকৰ দুগৰাকী ভার্য্যা আছিল। এগৰাকীৰ নাম আদা আৰু আনগৰাকীৰ নাম চিল্লা। ");
INSERT INTO asmfb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","আদাৰ গর্ভত যাবলৰ জন্ম হ’ল; তম্বুত বাস কৰি পশুপালন কৰা লোকসকলৰ তেওঁ পূৰ্বপুৰুষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","তেওঁৰ ভায়েকৰ নাম আছিল যুবল; তেওঁ বীণা আৰু বাঁহী বজোৱাসকলৰ আদি পুৰুষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","চিল্লাৰ গর্ভত তুবল-কয়িনৰ জন্ম হ’ল; তেওঁ পিতল আৰু লোহাৰ নানাবিধ অস্ত্ৰ গঢ়োতা আছিল; সেই তুবল-কয়িনৰ নয়মা নামেৰে এজনী ভনীয়েক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","লেমকে তেওঁৰ দুই ভার্য্যাক ক’লে, “হে আদা আৰু চিল্লা, তোমালোকে মোৰ কথা শুনা; হে লেমকৰ ভার্য্যাসকল, মোৰ কথালৈ কাণ দিয়া; কিয়নো আঘাত কৰাৰ বাবে এজন লোকক, আঘাত কৰাৰ বাবে এজন যুবকক মই বধ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","কয়িনে হত্যা কৰাৰ প্রতিশোধ যদি সাতগুণ হয়, তেন্তে অৱশ্যেই লেমকৰ প্রতিশোধ হ’ব সাতসত্তৰ গুণ।” ");
INSERT INTO asmfb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","পাছত আদমে পুনৰায় তেওঁৰ ভাৰ্যাৰ সৈতে একেলগ হোৱাত, তেওঁৰ পুনৰ এটি পুত্ৰ সন্তান জন্ম হ’ল। হৱাই সেই সন্তানৰ নাম চেথ ৰাখিলে আৰু ক’লে, “কয়িনে হেবলক বধ কৰাৰ কাৰণে ঈশ্বৰে মোক হেবলৰ সলনি পুনৰ এটি সন্তান দিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","পাছত চেথৰো এটি পুত্ৰ জন্মিল। তেওঁ তেওঁৰ নাম ইনোচ ৰাখিলে। সেই সময়ৰ পৰা লোকসকলে যিহোৱাৰ নামেৰে প্ৰাৰ্থনা আদি কৰিবলৈ আৰম্ভ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","এয়া হৈছে আদমৰ বংশৰ বিৱৰণ। মানুহ সৃষ্টি কৰাৰ দিনা, ঈশ্বৰে তেওঁলোকক নিজৰ সাদৃশ্যেৰে সৃষ্টি কৰিলে; ");
INSERT INTO asmfb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","তেওঁলোকক পুৰুষ আৰু স্ত্ৰী কৰি সৃষ্টি কৰিলে; সৃষ্টিৰ সময়ত তেওঁলোকক আশীৰ্ব্বাদ কৰি “মানুহ” নাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","এশ ত্ৰিশ বছৰ বয়সত নিজৰ সাদৃশ্যেৰে আদমৰ এটি পুত্ৰ জন্মিল আৰু তেওঁৰ নাম চেথ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","চেথৰ জন্মৰ পাছত আদম আঠশ বছৰ জীয়াই থাকিল। ইতিমধ্যে তেওঁৰ আৰু পুতেক জীয়েকৰ জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","সৰ্ব্বমুঠ ন শ ত্রিশ বছৰ জীয়াই থকাৰ পাছত আদমৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","চেথৰ যেতিয়া এশ পাঁচ বছৰ বয়স হ’ল, তেতিয়া তেওঁৰ পুত্ৰ ইনোচৰ জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ইনোচৰ জন্মৰ পাছত চেথ আঠ শ সাত বছৰ কাল জীয়াই আছিল। সেই সময়ত তেওঁৰ আৰু পুতেক জীয়েকৰ জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","মুঠ ন শ বাৰ বছৰ জীয়াই থকাৰ পাছত চেথৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ইনোচৰ নব্বই বছৰ বয়সত তেওঁৰ পুতেক কৈনন জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","কৈননৰ জন্মৰ পাছত ইনোচ আঠ শ পোন্ধৰ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ পুনৰ পুতেক জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","সৰ্ব্বমুঠ ন শ পাঁচ বছৰ জীয়াই থকাৰ পাছত ইনোচৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","কৈননৰ সত্তৰ বছৰ বয়সত তেওঁৰ পুতেক মহললেল জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","মহললেলৰ জন্মৰ পাছত কৈনন আঠ শ চল্লিশ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আন আন পুতেক জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","সৰ্ব্বমুঠ ন শ দহ বছৰ জীয়াই থকাৰ পাছত কৈননৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","মহললেলৰ পয়ষষ্ঠি বছৰ বয়সত তেওঁৰ পুত্র যেৰদ জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","যেৰদৰ জন্মৰ পাছত মহললেল আঠশ ত্রিশ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ পুনৰ পুতেক জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","সৰ্ব্বমুঠ আঠ শ পঞ্চানব্বৈ বছৰ জীয়াই থকাৰ পাছত মহললেলৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","যেৰদৰ এশ বাষষ্ঠি বছৰ বয়সত তেওঁৰ পুতেক হনোক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","হনোকৰ জন্মৰ পাছত যেৰদ আঠ শ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ পুনৰ পুতেক জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","সৰ্ব্বমুঠ ন শ বাষষ্ঠি বছৰ জীয়াই থকাৰ পাছত যেৰদৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","হনোকৰ পয়ষষ্ঠি বছৰ বয়সত তেওঁৰ পুতেক মথুচেলহ জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","মথুচেলহৰ জন্মৰ পাছত তিনি শ বছৰ পর্যন্ত ঈশ্বৰৰ লগত হনোকৰ অহা-যোৱাৰ সম্বন্ধ আছিল। সেই সময়ত তেওঁৰ পুনৰ পুতেক জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","হনোক সৰ্ব্বমুঠ তিনি শ পয়ষষ্ঠি বছৰ কাল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","তাৰ পাছত তেওঁক পুনৰ দেখা নগ’ল; ঈশ্বৰৰ লগত অহা-যোৱাৰ সম্বন্ধ আছিল বাবেই ঈশ্বৰে তেওঁক লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","মথুচেলহৰ এশ সাতাশী বছৰ বয়সত তেওঁৰ পুতেক লেমক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","লেমকৰ জন্মৰ পাছত মথুচেলহ সাত শ বিৰাশী বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আৰু পুতেক জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","সৰ্ব্বমুঠ ন শ উনসত্তৰ বছৰ জীয়াই থকাৰ পাছত মথুচেলহৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","লেমকৰ এশ বিৰাশী বছৰ বয়সত এটি পুত্ৰ জন্মিল; ");
INSERT INTO asmfb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","তেওঁ ক’লে, “যিহোৱাই ভূমিক শাও দিয়াৰ কাৰণে আমি যি পৰিশ্রম আৰু হাতেৰে কষ্ট কৰিব লাগে, তাৰ মাজতো আমাক এই ল’ৰায়েই শান্তনা দিব।” এই বুলি কৈ তেওঁ তেওঁৰ নাম নোহ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","নোহৰ জন্মৰ পাছত লেমক পাঁচ শ পঞ্চানব্বৈ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ পুনৰ পুতেক আৰু জীয়েক জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","সৰ্ব্বমুঠ সাত শ সাতসত্তৰ বছৰ জীয়াই থকাৰ পাছত লেমকৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","নোহ পাঁচ শ বছৰ জীয়াই থকাত তেওঁৰ চেম, হাম আৰু যেফৎ এই তিনিজন পুত্ৰৰ জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","এইদৰে পৃথিবীত মানুহৰ সংখ্যা বাঢ়িবলৈ ধৰিলে আৰু তেওঁলোকৰ মাজত অনেক কন্যা সন্তানৰো জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ঈশ্বৰৰ সন্তানসকলে মানুহৰ এই যুৱতীবোৰক ৰূপৱতী দেখিলে আৰু সেয়ে, তেওঁলোকৰ যিয়ে যাকে পছন্দ কৰে, তেওঁ তাইকে বিয়া কৰাই ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","এই অবস্থা দেখি যিহোৱাই ক’লে, “মোৰ আত্মাই চিৰকাললৈকে মানুহত থাকি অধিকাৰ নচলাব; কিয়নো মানুহ ৰক্তমাংসৰে গঠিত মাত্ৰ। তেওঁলোক এশ বিশ বছৰ জীয়াই থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","সেইকালত আৰু পৰৱর্তীকালত পৃথিৱীত নাফিলসকল আছিল। তেওঁলোক আছিল ঈশ্বৰৰ সন্তান সকলৰ লগত মানুহৰ যুৱতীবোৰৰ মিলনৰ ফলত জন্ম পোৱা সন্তান। নাফিলসকল পুৰনাকালৰ মহাবলী পুৰুষৰূপে বিখ্যাত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","যিহোৱাই দেখিলে যে, পৃথিবীত মানুহৰ দুষ্টতা অধিককৈ বৃদ্ধি পাইছে আৰু তেওঁলোকৰ হৃদয়ৰ সকলো ভাৱ-চিন্তা সকলো সময়তে কেৱল মন্দতাৰ ফালে যায়। ");
INSERT INTO asmfb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","পৃথিৱীত মানুহ সৃষ্টি কৰি যিহোৱা দুঃখিত হ’ল আৰু অন্তৰত বেজাৰ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","সেয়ে যিহোৱাই ক’লে, “মই নিজে সৃষ্টি কৰা মানুহক পৃথিবীৰ পৰা উচ্ছন্ন কৰিম; মানুহৰ লগতে সকলো ডাঙৰ জীৱ-জন্তু, বগাই ফুৰা প্রাণী আৰু আকাশৰ চৰাইবোৰ লুপ্ত কৰিম; কিয়নো এই সকলোকে সৃষ্টি কৰি মই দুখ পাইছো।” ");
INSERT INTO asmfb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","কিন্তু নোহৰ প্রতি যিহোৱাৰ অনুগ্ৰহৰ দৃষ্টি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","এয়া হৈছে নোহৰ বিৱৰণ। নোহ এজন ধাৰ্মিক লোক আছিল। সেই সময়ৰ লোকসকলৰ মাজত তেৱেঁই সিদ্ধ আছিল; ঈশ্বৰৰ লগত নোহে সম্পর্ক ৰাখি চলিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","চেম, হাম আৰু যেফৎ নামৰ নোহৰ তিনিজন পুত্ৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","সেই কালত ঈশ্বৰৰ দৃষ্টিত গোটেই পৃথিৱী দুর্নীতি আৰু হিংসাৰে পৰিপূৰ্ণ হৈ পৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ঈশ্বৰে পৃথিৱীলৈ দৃষ্টিপাত কৰি দেখিলে যে, পৃথিৱী ভ্রষ্টতাৰে পূর্ণ হৈছে; কিয়নো পৃথিবীৰ সকলো প্রাণীয়ে দুর্নীতিৰ পথত চলিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ঈশ্বৰে নোহক ক’লে, “মই দেখা পাইছো যে, সমগ্র মানৱজাতিকে ধ্বংস কৰাৰ সময় হ’ল; কিয়নো তেওঁলোকে ক্রোধ আৰু হিংসাৰে পৃথিৱী পৰিপূৰ্ণ কৰিছে। মানুহৰ লগতে মই পৃথিৱীৰ সকলোকে ধ্বংস কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","তুমি নিজৰ কাৰণে গোফৰ কাঠেৰে এখন জাহাজ নিৰ্ম্মাণ কৰা। তাৰ ভিতৰত কিছুমান কোঠালি থাকিব আৰু সেই জাহাজৰ ভিতৰে বাহিৰে শিলাজতুৰে লিপি দিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","জাহাজখন তুমি এইদৰে নির্ম্মাণ কৰিবা: দীঘলে তিনিশ হাত, পথালিয়ে পঞ্চাশ হাত আৰু তাৰ উচ্চতা হ’ব ত্ৰিশ হাত। ");
INSERT INTO asmfb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","জাহাজখনত এখন চালি বনাবা আৰু চালৰ পৰা তললৈ একহাত পর্যন্ত খিড়িকি কৰিবা আৰু জাহাজৰ কাষত দুৱাৰ ৰাখিবা; প্ৰথম, দ্বিতীয় আৰু তৃতীয় এনে তিনি তলাকৈ তাক নিৰ্ম্মাণ কৰিবা; ");
INSERT INTO asmfb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","আৰু চোৱা, মই পৃথিৱীত এনে এক বন্যা আনিম, তাতে আকাশৰ তলত শ্বাস-প্রশ্বাস লৈ জীয়াই থকা সকলো প্ৰাণীয়েই ধ্বংস হৈ যাব। তেতিয়া পৃথিৱীত থকা সকলো প্রাণীৰ মৃত্যু হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","কিন্তু মই তোমাৰ লগত মোৰ ব্যৱস্থা স্থাপন কৰিম; তুমি গৈ জাহাজত উঠিবা আৰু তোমাৰ লগত তোমাৰ পুত্ৰসকল, তোমাৰ ভাৰ্যা আৰু তোমাৰ পো-বোৱাৰীসকল থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","তোমাৰ লগত জীয়াই ৰাখিবলৈ প্রত্যেকবিধ প্রাণীৰ পৰা মতা মাইকী এযোৰ এযোৰকৈ জাহাজত তুলিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","বিধে বিধে চৰাই, বিধে বিধে পশু, আৰু বিধে বিধে মাটিত বগাই ফুৰা সকলোৰে এযোৰ এযোৰকৈ তোমাৰ ওচৰলৈ আহিব। তুমি সিহঁতক জীয়াই ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","তুমি সকলোবিধৰ খোৱা-বস্তু গোটাই থ’বা। সেইবোৰ তোমাৰ আৰু সিহঁতৰ বাবে আহাৰ হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","তেতিয়া নোহে সেই দৰেই কৰিলে; ঈশ্বৰে আজ্ঞা দিয়াৰ দৰেই তেওঁ সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","তাৰ পাছত যিহোৱাই নোহক ক’লে, “তুমি আৰু তোমাৰ পৰিয়ালৰ সকলোৱে জাহাজত উঠাগৈ; কিয়নো মোৰ দৃষ্টিত এই কালৰ লোকসকলৰ মাজত কেৱল তুমিয়েই ধাৰ্মিক হৈ আছা। ");
INSERT INTO asmfb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","তুমি তোমাৰ লগত প্রতিবিধ শুচি পশুৰ মতা মাইকী সাতোটা সাতোটা আৰু অশুচি পশুৰ মতা মাইকী এযোৰ এযোৰ কৈ আনিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","আকাশত উৰিফুৰা চৰাইবোৰৰো মতা মাইকী সাতোটা সাতোটা তোমাৰ লগত ল’বা; পৃথিৱীৰ ওপৰত সেইবোৰৰ বংশ জীয়াই ৰাখিবলৈ তুমি ইয়াকে কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","সাত দিনৰ পাছত মই দিনে-ৰাতিয়ে চল্লিশ দিনলৈকে পৃথিবীৰ ওপৰত বৰষুণ বৰষাম আৰু মই সৃষ্টি কৰা সকলোবোৰ জীৱকুলকে পৃথিৱীৰ পৰা উচ্ছন্ন কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","যিহোৱাৰ আজ্ঞা অনুসাৰে নোহে সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","পৃথিৱীত জলপ্লাৱন হোৱাৰ সময়ত নোহৰ বয়স আছিল ছশ বছৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","জলপ্লাৱনৰ পৰা ৰক্ষা পাবৰ কাৰণে নোহ, তেওঁৰ ভাৰ্যা, তেওঁৰ পুত্ৰসকল আৰু তেওঁলোকৰ ভার্য্যাসকল জাহাজত উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","শুচি আৰু অশুচি পশু, চৰাই আৰু মাটিত বগাই ফুৰা সকলোবিধ জন্তুৰ ");
INSERT INTO asmfb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","মতা মাইকী যোৰ যোৰকৈ নোহৰ ওচৰলৈ আহিল আৰু ঈশ্বৰে আজ্ঞা দিয়াৰ দৰে সেইবোৰ জাহাজত উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","সাত দিনৰ পাছত পৃথিৱীত জল-প্লাৱন হ’বলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","নোহৰ বয়স যেতিয়া ছশ বছৰ হৈছিল, সেই বছৰৰ দ্বিতীয় মাহৰ সোঁতৰ দিনৰ দিনা ভূগর্ভস্থৰ সকলো ভুমুক ফুটি পানী ওলাবলৈ ধৰিলে আৰু আকাশৰ খিড়িকিবোৰ মুকলি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","চল্লিশ দিন আৰু চল্লিশ ৰাতি পৃথিৱীত বৰষুণ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","যি দিনা বৰষুণ পৰিবলৈ আৰম্ভ কৰিলে, সেই দিনা নোহ, তেওঁৰ ভাৰ্যা, তেওঁৰ তিনিজন পুত্র চেম, হাম, যেফৎ আৰু তিনিগৰাকী পুত্র-বোৱাৰী জাহাজত গৈ উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","তেওঁলোকৰ লগত বিধে বিধে সকলো বনৰীয়া পশু আৰু ঘৰচীয়া পশু, বিধে বিধে মাটিত বগাই ফুৰা সকলো প্ৰাণী আৰু সকলো বিধ চৰাই চিৰিকটিও উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","শ্বাস-প্রশ্বাস লৈ জীয়াই থকা সকলো প্ৰাণী এযোৰ এযোৰকৈ নোহৰ ওচৰলৈ আহি জাহাজত সোমাল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ঈশ্বৰে তেওঁক যেনেদৰে আজ্ঞা দিছিল, সেই অনুসাৰে সকলো প্ৰাণীৰে মতা আৰু মাইকী জাহাজত সোমালগৈ; তাৰ পাছত যিহোৱাই জাহাজৰ দুৱাৰ বন্ধ কৰি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","তাৰ পাছত চল্লিশ দিনলৈকে পৃথিবীৰ ওপৰত জলপ্লাৱনৰ পানী বাঢ়ি যাবলৈ ধৰিলে; পানী বাঢ়ি যোৱাত জাহাজখন মাটিৰ পৰা দাং খাই পানীত ওপঙি উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","পৃথিৱীৰ ওপৰত পানী বাঢ়ি বাঢ়ি গৈ থাকিল আৰু সোঁত প্রৱলৰূপে প্লাৱিত হোৱাত জাহাজখন পানীত ওপঙিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","পৃথিবীৰ ওপৰত পানী কেৱল বাঢ়িয়েই থাকিল; সমুদায় আকাশৰ তলত থকা সকলো ওখ ওখ পৰ্ব্বত ডুব গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","পাহাৰ-পর্ব্বতবোৰ ডুব গৈ পোন্ধৰ হাত ওপৰলৈকে পানী উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","পৃথিৱীৰ ওপৰত থকা সকলো জীৱিত প্রাণীৰে মৃত্যু হ’ল। চৰাই-চিৰিকতি, ঘৰচীয়া আৰু বনৰীয়া পশু, মাটিৰ ওপৰত জাক পাতি ঘূৰি ফুৰা কীট-পতঙ্গ আৰু সকলো মানুহৰেই মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","শুকান মাটিৰ ওপৰত থকা সকলো প্রাণীৰে অর্থাৎ শ্বাস-প্রশ্বাস লৈ জীয়াই থকা আটাই প্ৰাণীৰে মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","এইদৰে পৃথিৱীৰ ওপৰি ভাগত থকা সকলো প্ৰাণীকে নিঃশেষ কৰা হ’ল - মানুহকে আদি কৰি ডাঙৰ ডাঙৰ পশু, বগাই ফুৰা প্রাণী আৰু আকাশৰ চৰাইবোৰক উচ্ছন্ন কৰা হ’ল; কেৱল নোহ আৰু তেওঁৰ লগত যি সকল জাহাজত থাকিল সেইসকলহে জীয়াই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","এইদৰে পৃথিবীৰ ওপৰত এশ পঞ্চাশ দিনলৈকে জলপ্লাৱন হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","পাছত ঈশ্বৰে নোহ আৰু তেওঁৰ লগত জাহাজত থকা পশু আদি সকলো প্ৰাণীকে সুঁৱৰিলে; তেওঁ পৃথিবীৰ ওপৰেদি বতাহ বোৱালে আৰু তাতে পানী কমিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ভূগর্ভস্থৰ জলৰ ভুমুকবোৰ আৰু আকাশৰ খিড়িকিবোৰ বন্ধ হৈ গ’ল; আকাশৰ পৰা বৰষুণ পৰিবলৈ এৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","পৃথিবীৰ ওপৰৰ পানী ক্ৰমান্বয়ে কমিবলৈ ধৰিলে আৰু এশ পঞ্চাশ দিনৰ মূৰত পানী অনেক কমিল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","সেই বছৰৰ সপ্তম মাহৰ সোঁতৰ দিনৰ দিনা জাহাজখন অৰাৰট পৰ্ব্বতশ্রেণীৰ ওপৰত গৈ লাগি ৰ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","তাৰ পাছতো পানী ক্রমে কমি কমি গৈ থাকিল আৰু দশম মাহৰ প্ৰথম দিনা পৰ্ব্বতশ্রেণীৰ টিংবোৰ দেখা গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","তাৰ পাছত চল্লিশ দিন পাৰ হোৱাত নোহে নিজে সজা জাহাজৰ খিড়িকিখন মেলিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","তেওঁ এটি ঢোৰা কাউৰী বাহিৰলৈ উড়ুৱাই পঠালে। পৃথিৱীৰ পৰা পানী নুশুকুৱা পর্যন্ত কাউৰীজনীয়ে অহা-যোৱা কৰি উড়ি ফুৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","তাৰ পাছত পৃথিবীৰ পৰা পানী শুকাল নে নাই, তাক জানিবৰ কাৰণে তেওঁ এটা কপৌ বাহিৰলৈ উড়ুৱাই পঠালে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","কিন্তু তেতিয়াও গোটেই পৃথিৱীত পানী আছিল আৰু সেয়ে কপৌজনীয়ে নিজৰ ভৰি থ’বলৈ ঠাই বিচাৰি নাপাই জাহাজলৈ নোহৰ ওচৰলৈ উভটি আহিল। তেতিয়া নোহে হাত মেলি তাক ধৰি জাহাজত নিজৰ ওচৰলৈ সুমুৱাই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","তাৰ পাছত তেওঁ আৰু সাত দিন অপেক্ষা কৰি পুনৰ সেই কপৌজনীক জাহাজৰ পৰা উড়ুৱাই পঠালে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","সন্ধিয়া সময়ত কপৌজনী নোহৰ ওচৰলৈ উলটি আহিল আৰু তাইৰ ঠোঁটত এইমাত্র চিঙি অনা জিতগছৰ নতুন পাত এখিলা আছিল; তেতিয়া নোহে বুজি পালে যে, পৃথিবীৰ ওপৰৰ পৰা পানী কমি গৈছে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","নোহে আৰু সাত দিন অপেক্ষা কৰি পুনৰ সেই কপৌজনীক উড়ুৱাই পঠালে; কিন্তু এইবাৰ তাই আৰু তেওঁৰ ওচৰলৈ পুনৰ উভটি নাহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","নোহৰ বয়স তেতিয়া ছশ এক বছৰ। সেই বছৰৰ প্ৰথম মাহৰ প্ৰথম দিনৰ পৰা পৃথিবীৰ পানী শুকাবলৈ ধৰিলে; তেতিয়া নোহে জাহাজৰ দুৱাৰখন মেলি বাহিৰলৈ চাই দেখিলে যে, ভূমিৰ ওপৰৰ পানী শুকাই গৈছে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","দ্বিতীয় মাহৰ সাতাইশ দিনৰ ভিতৰত পৃথিৱী একেবাৰে শুকাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","তেতিয়া ঈশ্বৰে নোহক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“তুমি তোমাৰ ভাৰ্যা, পুত্ৰ আৰু বোৱাৰীসকলক লগত লৈ, জাহাজৰ পৰা ওলাই যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","তোমাৰ লগত চৰাই, ঘৰচীয়া পশু আৰু মাটিত বগাই ফুৰা উৰগ আদি কৰি সকলো জীৱিত প্রাণীকে জাহাজৰ পৰা উলিয়াই আনা; সেইবোৰে পৃথিৱীত সিহঁতৰ বংশ বৃদ্ধি কৰক আৰু বহুবংশ হৈ সংখ্যাত বাঢ়ি যাওক।” ");
INSERT INTO asmfb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","তেতিয়া নোহে তেওঁৰ ভাৰ্যা, তেওঁৰ পুত্ৰ আৰু বোৱাৰীসকলৰ সৈতে জাহাজৰ বাহিৰলৈ ওলাই আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","পৃথিৱীত ঘূৰি-ফুৰা সকলো জীৱিত প্রাণী, সকলো বগাই ফুৰা জীৱ, পশু-পক্ষীও নিজৰ জাতি অনুসাৰে জাহাজৰ পৰা ওলাই আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","তাৰ পাছত নোহে যিহোৱাৰ উদ্দেশ্যে এটা যজ্ঞ-বেদি নিৰ্ম্মাণ কৰিলে; তেওঁ কিছুমান শুচি পশু আৰু পক্ষী লৈ সেই বেদীৰ ওপৰত হোম-বলি উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","যিহোৱাই সেই হোম-বলিৰ সুঘ্ৰাণত সন্তোষ পাই নিজৰ মনেতে ক’লে, “সৰু কালৰে পৰা মানুহৰ মন মন্দতাৰ ফালে ঢাল খোৱা; কিন্তু মই মানুহৰ কাৰণে ভূমিক আৰু কেতিয়াও শাও নিদিওঁ; সেয়ে, মই যি দৰে কৰিলোঁ, পুনৰায় সেইদৰে সকলো প্ৰাণীক ধ্বংস নকৰোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","যিমান দিনলৈকে এই পৃথিৱী থাকিব, সিমান দিন শস্য ৰোৱা আৰু শস্য দোৱাৰ সময় থাকিব; সিমান দিন শীতকাল আৰু গ্ৰীষ্মকাল, গৰম আৰু ঠাণ্ডা, দিন আৰু ৰাতি এইবোৰ চলি থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ঈশ্বৰে নোহ আৰু তেওঁৰ পুত্ৰসকলক আশীৰ্ব্বাদ কৰি ক’লে, “তোমালোক বহুবংশ হৈ বাঢ়ি বাঢ়ি পৃথিৱীখন পৰিপূৰ্ণ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","পৃথিৱীৰ সকলো জীৱ-জন্তু, আকাশৰ চৰাই, মাটিত বগাই ফুৰা সকলোবোৰ প্রাণী আৰু সমুদ্ৰৰ সকলো মাছে তোমালোকক ভয় কৰিব; সেইবোৰ তোমালোকৰ হাতত শোধাই দিয়া হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","সকলো চলা-ফুৰা কৰা প্রাণীয়েই তোমালোকৰ আহাৰ হ’ব; যি দৰে তোমালোকক সকলো সেউজীয়া শস্য আদি আহাৰ হিচাবে দিলোঁ, তেনেদৰে এতিয়া মই এই সকলোবোৰ তোমালোকক দিছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","কিন্তু প্রাণে সৈতে অৰ্থাৎ তেজেৰে সৈতে তোমালোকে মঙহ নাখাবা। ");
INSERT INTO asmfb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","কিন্তু তোমালোকক যদি কোনোবাই বধ কৰে, তোমালোকৰ সেই তেজৰ কাৰণে, যি তেজত তোমালোকৰ প্রাণ আছে তাৰ প্ৰতিকাৰ মই অৱশ্যেই সাধিম; সেয়ে পশুৱেই হওঁক বা মানুহেই হওঁক, প্ৰত্যেকৰে পৰা তাক সাধিম। এনেকি নিজ ভায়েকক হত্যা কৰা প্ৰত্যেক মানুহৰ পৰাও প্ৰাণৰ প্ৰতিকাৰ মই সাধিম। ");
INSERT INTO asmfb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ঈশ্বৰে মানুহক নিজ প্ৰতিমূৰ্ত্তিৰ দৰেই নিৰ্ম্মাণ কৰিলে। সেয়ে, কোনো মানুহে যদি কাৰোবাৰ ৰক্তপাত কৰে, তেন্তে মানুহৰ দ্বাৰাই তেওঁৰো ৰক্তপাত কৰা হ’ব; ");
INSERT INTO asmfb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","তোমালোক বহুবংশ হৈ বৃদ্ধি হোৱা; পৃথিবীৰ চৌদিশে বিয়পি পৰা আৰু প্ৰচুৰ পৰিমাণে সংখ্যাত বৃদ্ধি পাই যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","তাৰ পাছত ঈশ্বৰে নোহক আৰু তেওঁৰ লগত থকা তেওঁৰ পুত্ৰসকলক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“চোৱা! মই তোমালোকৰ আৰু তোমালোকৰ বংশধৰসকলৰ সৈতে আৰু ");
INSERT INTO asmfb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","যি সকলো প্রাণী তোমালোকৰ লগত আছে অর্থাৎ চৰাই, ঘৰচীয়া আৰু বনৰীয়া পশু আদি কৰি তোমালোকৰ লগত থকা যিমান জীৱ-জন্তু জাহাজৰ পৰা ওলাল, পৃথিৱীত থকা সেই সকলোবোৰৰ কাৰণে মই মোৰ নিয়ম স্থাপন কৰোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","মই তোমালোকৰ সৈতে মোৰ এই নিয়মটি স্থাপন কৰিলোঁ যে, জল-প্লাৱনৰ দ্বাৰাই কেতিয়াও কোনো প্ৰাণীকে আৰু বিনষ্ট কৰা নহব; পৃথিৱী ধ্বংস কৰাৰ দৰে জল-প্লাৱনো আৰু কেতিয়াও নহ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ঈশ্বৰে আৰু ক’লে, “মোৰ আৰু তোমালোকৰ মাজত আৰু তোমালোকৰ লগত যি সকলো জীৱিত প্রাণী আছে, সেই সকলোৰে সৈতে ভৱিষ্যতৰ সকলো বংশৰ কাৰণে যি নিয়ম স্থাপন কৰিলোঁ, তাৰ চিন এই: ");
INSERT INTO asmfb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","মেঘত মই মোৰ ধনু থৈছো; এই মেঘধনুয়েই হ’ব মোৰ আৰু পৃথিৱীৰ মাজত হোৱা প্রতিজ্ঞাৰ চিন। ");
INSERT INTO asmfb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","যেতিয়া মই পৃথিৱীৰ ওপৰলৈ মেঘ আনিম, তেতিয়া তোমালোকে সেই মেঘৰ মাজত মেঘধনু দেখা পাবা; ");
INSERT INTO asmfb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","তেতিয়া মোৰ আৰু তোমালোকৰ মাজত আৰু তোমালোকৰ লগত যি সকলো জীৱিত প্রাণী আছে, সেই সকলোৰে বাবে কৰা মোৰ নিয়মৰ কথা মই সুঁৱৰিম; তাতে পানীয়ে সকলো প্ৰাণী ধ্বংস কৰাকৈ কেতিয়াও আৰু জলপ্লাৱন নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","মেঘত যেতিয়া মেঘধনু ওলাব, তেতিয়া মই তাক দেখি পৃথিৱীৰ সকলো প্ৰাণীৰ কাৰণে মোৰ এই চিৰস্থায়ী নিয়মৰ কথা মই সোঁৱৰণ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ঈশ্বৰে নোহক ক’লে, “মোৰ আৰু পৃথিবীত থকা সকলো প্ৰাণীৰে মাজত মই যি নিয়ম স্থাপন কৰিছোঁ, ইয়েই হৈছে তাৰ চিন। ");
INSERT INTO asmfb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","জাহাজৰ পৰা নোহৰ পুত্ৰ চেম, হাম আৰু যেফৎ বাহিৰলৈ ওলাই আহিল। পাছত কনান নামেৰে হামৰ এটি পুত্র জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","গোটেই পৃথিৱীতে নোহৰ এই তিনি জন পুত্ৰৰ বংশধৰসকল বিয়পি পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","নোহ এজন কৃষক হ’ল আৰু তেওঁ এখন দ্ৰাক্ষাবাৰী পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","তেওঁ এদিন দ্রাক্ষাৰস খাই মতলীয়া হ’ল আৰু নিজৰ তম্বুৰ ভিতৰত বিবস্ত্ৰ হৈ পৰি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","তেতিয়া কনানৰ পিতৃ হামে নিজৰ দেউতাকক বিবস্ত্ৰ অৱস্থাত দেখিলে আৰু বাহিৰলৈ আহি সেই কথা তেওঁৰ দুজন ভাই-ককাইক ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","তাতে চেম আৰু যেফতে এখন কাপোৰ তেওঁলোকৰ কান্ধত তুলি ল’লে আৰু পাছ হুঁহকি হুঁহকি গৈ বাপেকৰ বিবস্ত্ৰতা ঢাকিলে। তেওঁলোকৰ মুখ বিপৰীত দিশত আছিল বাবে বাপেকৰ নগ্নতা তেওঁলোকে দেখা নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","পাছত নোহৰ চেতনা অহাত তেওঁৰ সৰু পুতেকে তেওঁলৈ যি কৰিলে, তাক জানিবলৈ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","তেতিয়া তেওঁ ক’লে, “কনানৰ ওপৰত অভিশাপ আহঁক; সি তাৰ ভাতৃসকলৰ দাসবোৰৰো দাস হওক।” ");
INSERT INTO asmfb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","তেওঁ পুনৰ ক’লে, “চেমৰ ঈশ্বৰ যিহোৱা ধন্য; কনান চেমৰ দাস হওক। ");
INSERT INTO asmfb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ঈশ্বৰে যেফতক যেন বিস্তাৰিত কৰে, সি চেমৰ তম্বুত বসতি কৰক, আৰু কনান তাৰ দাস হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","জল-প্লাৱনৰ পাছত নোহ পুনৰ তিনিশ পঞ্চাশ বছৰ জীয়াই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","পাছত নোহৰ সৰ্ব্বমুঠ ন শ পঞ্চাশ বছৰ বয়সত তেওঁৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","নোহৰ পুত্ৰ চেম, হাম আৰু যেফতৰ বংশৰ বিৱৰণ এই: জলপ্লাৱনৰ পাছত তেওঁলোকৰ বহুতো সন্তান জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","যেফতৰ সন্তানসকলৰ নাম গোমৰ, মাগোগ, মাদয়, যাবন, তুবল, মেচেক আৰু তীৰচ। ");
INSERT INTO asmfb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","গোমৰৰ সন্তান সকল হ’ল অস্কিনজ, ৰীফৎ, আৰু তোগৰ্মা। ");
INSERT INTO asmfb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","যাবনৰ সন্তান সকল হ’ল ইলীচা, তৰ্চীচ, কিত্তীম আৰু দোদানীম। ");
INSERT INTO asmfb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","যাবনৰ বংশৰ লোকসকলে সাগৰৰ কাষৰীয় অঞ্চল আৰু দ্বীপবোৰত বসবাস কৰিলে। তেওঁলোকৰ বংশধৰসকল বিভক্ত হৈ বিভিন্ন জাতি হ’ল আৰু প্রত্যেক জাতিৰ নিজস্ব ভাষা, গোষ্ঠী আৰু অঞ্চল হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","হামৰ সন্তান সকলৰ নাম কুচ, মিচৰ, পূট, আৰু কনান। ");
INSERT INTO asmfb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","কুচৰ সন্তান সকল হ’ল চবা, হবীলা, চব্তা, ৰয়মা, আৰু চব্তকা; ৰয়মাৰ সন্তান সকল হ’ল চিবা আৰু দদান। ");
INSERT INTO asmfb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","কুচৰ পুত্ৰৰ নাম নিম্ৰোদ; এই নিম্রোদ পৃথিবীত এজন মহা-পৰাক্ৰমী পুৰুষ হৈ উঠিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","যিহোৱাৰ সন্মুখত তেওঁ আছিল এজন পৰাক্ৰমী চিকাৰী। সেইবাবে তেওঁৰ তুলনা দি এই লোক-প্রবাদ আছে, “নিম্রোদৰ নিচিনা, যিহোৱাৰ সন্মুখতো এজন পৰাক্রমী চিকাৰী।” ");
INSERT INTO asmfb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","নিম্রোদৰ ৰাজত্বৰ প্রথম ঠাইবোৰ আছিল চিনাৰ দেশৰ বাবিল, এৰক, অক্কদ, আৰু কলনি। ");
INSERT INTO asmfb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","তেওঁ সেই ঠাইৰ পৰা অচুৰ দেশলৈকে গ’ল; তেওঁ নীনবি, ৰহোবোৎ-ঈৰ, কেলহ, ");
INSERT INTO asmfb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","আৰু ৰেচন, এইবোৰ নগৰ নির্ম্মাণ কৰিলে। নীনবি আৰু কেলহৰ মাজত অৱস্থিত ৰেচন এখন মহানগৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","লুদীয়া, অনামীয়া, লহাবীয়া, নপ্তুহীয়া, ");
INSERT INTO asmfb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","পথ্ৰোচীয়া, কচলুহীয়া আৰু কপ্তোৰীয়াসকল মিচৰৰ বংশৰ লোক আছিল। পলেষ্টীয়াসকল এই কচলুহীয়াসকলৰ পৰা আহিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","কনান, চীদোন আৰু হেতৰ পিতৃ আছিল। চীদোন আছিল কনানৰ প্রথম সন্তান। ");
INSERT INTO asmfb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","যিবুচীয়া ইমোৰীয়া, গিৰ্গাচীয়া, ");
INSERT INTO asmfb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","হিব্বীয়া, অৰ্কীয়া, চীনীয়া, ");
INSERT INTO asmfb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","অৰ্বদীয়া, চমৰীয়া, আৰু হমাতীয়াসকলো কনানৰ বংশৰ লোক আছিল। পাছত কনানীয়া গোষ্ঠীবোৰ বিস্তাৰিত হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","কনানীয়াসকলৰ সীমা চীদোনপৰা গৰাৰৰ ফালে গাজা পর্যন্ত আৰু চদোম, ঘমোৰা, অদ্মা, আৰু চবোয়ীমলৈ যোৱাৰ ফালে লেচা পর্যন্ত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","নিজৰ নিজৰ ফৈদ, ভাষা, দেশ আৰু জাতি হিচাবে এইসকল লোকেই আছিল হামৰ বংশৰ লোক। ");
INSERT INTO asmfb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","যেফতৰ ডাঙৰ ককায়েক চেমৰো সন্তান-সন্ততি হ’ল। চেম এবৰৰ বংশধৰসকলৰ আদি পুৰুষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","চেমৰ পুত্রসকল থ’ল এলম, অচুৰ, অৰ্ফকচদৰ, লুদ আৰু অৰাম। ");
INSERT INTO asmfb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","অৰামৰ পুত্রসকল উচ, হুল, গেথৰ, আৰু মচ। ");
INSERT INTO asmfb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","অৰ্ফকচদৰ সন্তানৰ নাম চেলহ আৰু চেলহৰ সন্তানৰ নাম এবৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","এবৰৰ দুজন পুত্ৰ আছিল। তেওঁলোকৰ এজনৰ নাম পেলগ, কিয়নো তেওঁৰ দিনতে পৃথিৱী বিভক্ত হৈছিল। পেলগৰ ভায়েকৰ নাম আছিল যক্তন। ");
INSERT INTO asmfb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","যক্তনৰ পুত্ৰসকলৰ নাম অলমোদদ, চেলফ, হচমাবৎ, যেৰহ, ");
INSERT INTO asmfb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","হদোৰাম, উজল, দিক্লা, ");
INSERT INTO asmfb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ওবল, অবীমায়েল, চিবা, ");
INSERT INTO asmfb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ওফীৰ, হবীলা আৰু যোবব; এইলোক সকলোৱেই যক্তনৰ সন্তান। ");
INSERT INTO asmfb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","মেচাৰ পৰা পূব দিশৰ ছফাৰ পৰ্ব্বতলৈকে যোৱা অঞ্চলত তেওঁলোকে বসবাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","নিজৰ নিজৰ ফৈদ, ভাষা, দেশ আৰু জাতি হিচাবে এইসকল লোকেই আছিল চেমৰ বংশৰ লোক। ");
INSERT INTO asmfb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","এয়াই হ’ল বংশানুক্রমে আৰু জাতি অনুসাৰে নোহৰ পুত্রসকলৰ গোষ্ঠী। জলপ্লাৱনৰ পাছত এওঁলোকৰ বংশৰ লোকসকলেই পৃথক পৃথক জাতি হ’ল আৰু গোটেই পৃথিৱীতে সিচঁৰিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","সেই সময়ত গোটেই পৃথিৱীৰ মানুহে কেৱল এটা ভাষাতে কথা কৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","পাছত লোকসকলে পূব দিশে ঘূৰি ফুৰি গৈ চিনাৰ দেশত আহি এখন সমতল ভূমি পালে আৰু তাতে বাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","তেওঁলোকে এজনে আন জনক ক’লে, “ব’লা, আমি ইটা সাজি ভালকৈ জুইত পোৰোঁহঁক।” এইবুলি কৈ তেওঁলোকে শিলৰ সলনি ইটা আৰু গাঁথনিৰ কাৰণে এঠামাটিৰ সলনি আলকতৰাৰ প্ৰলেপ ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","তেওঁলোকে ক’লে, “আহাঁ, আমি নিজৰ কাৰণে এখন নগৰ নির্ম্মাণ কৰোঁ আৰু এনে এটা উচ্চ স্তম্ভ নিৰ্ম্মাণ কৰোঁহক যাৰ চূড়াই আকাশ চুব পাৰে। আমি আমাৰ নাম খ্যাতিমন্ত কৰোঁহক, নহ’লে আমি গোটেই পৃথিৱীতে সিচঁৰিত হৈ পৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","আদমৰ বংশধৰসকলে যি নগৰ আৰু উচ্চ স্তম্ভ নিৰ্ম্মাণ কৰিছিল, তাক চাবলৈ যিহোৱা নামি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","যিহোৱাই কৈছিল, “এই লোকসকল এক জাতিৰ লোক আৰু এইসকলৰ ভাষাও এক! এওঁলোকে এনেকুৱাকৈ কাৰ্যও আৰম্ভ কৰিলে! এতিয়া তেওঁলোকে ইচ্ছা কৰা কোনো কাৰ্যই তেওঁলোকৰ বাবে অসাধ্য নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","গতিকে, আহাঁ, আমি নামি গৈ তেওঁলোকৰ ভাষাত বিভ্রান্তিৰ সৃষ্টি কৰোঁ যাতে তেওঁলোকে এজনে আন জনৰ কথা বুজিব নোৱাৰে।” ");
INSERT INTO asmfb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","এইদৰে যিহোৱাই তেওঁলোকক সেই ঠাইৰ পৰা গোটেই পৃথিৱীতে সিচঁৰিত কৰিলে; তাতে তেওঁলোকে সেই নগৰ সজাৰ কাম বন্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","এইবাবেই সেই ঠাইৰ নাম বাবিল ৰখা হ’ল, কিয়নো সেই ঠাইতেই যিহোৱাই গোটেই পৃথিৱীত ভাষাৰ ভেদ জন্মালে আৰু তাৰ পৰাই যিহোৱাই তেওঁলোকক পৃথিৱীত সিচঁৰিত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","চেমৰ বংশৰ বিৱৰণ এই। জলপ্লাৱনৰ দুবছৰৰ পাছত যেতিয়া চেমৰ বয়স এশ বছৰ তেতিয়া তেওঁৰ পুত্র অৰ্ফকচদ জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","অৰ্ফকচদৰ জন্মৰ পাছত চেম আৰু পাঁচ শ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আৰু পুত্র-কন্যা জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","অৰ্ফকচদৰ পঁয়ত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র চেলহ জন্মিল; ");
INSERT INTO asmfb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","চেলহৰ জন্মৰ পাছত অৰ্ফকচদ আৰু চাৰি শ তিনি বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আৰু পুত্র-কন্যা জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","চেলহৰ ত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র এবৰ জন্মিল; ");
INSERT INTO asmfb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","এবৰৰ জন্মৰ পাছত চেলহ পুনৰ চাৰি শ তিনি বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আন আন পুত্র-কন্যা জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","এবৰৰ চৌত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র পেলগ জন্মিল; ");
INSERT INTO asmfb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","পেলগৰ জন্মৰ পাছত এবৰ পুনৰ চাৰি শ ত্ৰিশ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আন আন পুত্র-কন্যাসকল জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","পেলগৰ ত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র ৰিয়ু জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ৰিয়ুৰ জন্মৰ পাছত পেলগ পুনৰ দুশ ন বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আন আন পুত্র আৰু কন্যাসকল জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ৰিয়ুৰ ত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র চৰূগ জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","চৰূগৰ জন্মৰ পাছত ৰিয়ু পুনৰ দুশ সাত বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আন আন পুত্র আৰু কন্যাসকল জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","চৰূগৰ ত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র নাহোৰ জন্মিল; ");
INSERT INTO asmfb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","নাহোৰৰ জন্মৰ পাছত চৰূগ আৰু দুশ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আৰু পুত্র-কন্যা জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","নাহোৰৰ উনত্ৰিশ বছৰ বয়সত তেওঁৰ পুত্র তেৰহ জন্মিল; ");
INSERT INTO asmfb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","তেৰহৰ জন্মৰ পাছত নাহোৰ পুনৰ এশ উনৈশ বছৰ জীয়াই আছিল। সেই সময়ত তেওঁৰ আন আন পুত্র আৰু কন্যাসকল জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","তেৰহৰ সত্তৰ বছৰ বয়সৰ পাছত তেওঁৰ পুত্র অব্ৰাম, নাহোৰ আৰু হাৰণ জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","তেৰহৰ বংশৰ বিৱৰণ এই। তেৰহৰ সন্তান সকল আছিল অব্ৰাম, নাহোৰ আৰু হাৰণ; হাৰণৰ সন্তানৰ নাম আছিল লোট। ");
INSERT INTO asmfb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","পিতৃ তেৰহ জীয়াই থাকোতেই জন্মস্থান কলদীয়াসকলৰ উৰ নগৰত হাৰণৰ মৃত্যু হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","অব্ৰাম আৰু নাহোৰ এই দুজনেই বিয়া কৰিছিল। অব্ৰামৰ ভার্য্যাৰ নাম আছিল চাৰী আৰু নাহোৰৰ ভার্য্যাৰ নাম আছিল মিল্কা; তেওঁ হাৰণৰ জীয়েক আছিল। সেই হাৰণ মিলকা আৰু যিচকাৰ পিতৃ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","কিন্তু চাৰী বন্ধ্যা আছিল; তেওঁৰ কোনো সন্তান নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","তেৰহে তেওঁৰ পুত্ৰ অব্ৰাম, হাৰণৰ পুত্র তেওঁৰ নাতিয়েক লোট, অব্ৰামৰ ভাৰ্যা তেওঁৰ বোৱাৰীয়েক চাৰীক লগত লৈ কনান দেশলৈ যাবৰ কাৰণে কলদীয়াসকলৰ উৰ নগৰৰ পৰা ওলাই গ’ল; কিন্তু তেওঁলোকে হাৰণ নগৰ পর্যন্ত গৈ তাতে বসবাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","দুশ পাঁচ বছৰ বয়সত তেৰহৰ হাৰণতে মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","যিহোৱাই অব্ৰামক ক’লে, “তুমি তোমাৰ নিজৰ দেশ, তোমাৰ আত্মীয়-স্বজন আৰু তোমাৰ পিতৃৰ ঘৰ ত্যাগ কৰি মই যি দেশ তোমাক দেখুৱাম সেই দেশলৈ যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","মই তোমাৰ পৰা এক মহাজাতি সৃষ্টি কৰিম আৰু তোমাক আশীৰ্ব্বাদ কৰি তোমাৰ নাম খ্যাতিমন্ত কৰিম; তাতে তুমি আশীৰ্ব্বাদৰ আকৰ হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","যিসকলে তোমাক আশীৰ্ব্বাদ কৰে, মই তেওঁলোকক আশীৰ্ব্বাদ কৰিম আৰু যিসকলে তোমাক শাও দিয়ে, মই তেওঁলোকক শাও দিম। তোমাৰ দ্বাৰায়েই পৃথিৱীৰ সমুদায় গোষ্ঠীয়ে আশীৰ্ব্বাদ পাব।” ");
INSERT INTO asmfb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","পাছত অব্ৰামে যিহোৱাৰ কথা মতে যাত্ৰা কৰিলে আৰু লোট তেওঁৰ লগত গ’ল। হাৰণ নগৰৰ পৰা ওলাই যোৱাৰ সময়ত অব্ৰামৰ বয়স আছিল পঁয়সত্তৰ বছৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","অব্ৰামে তেওঁৰ ভার্য্যা চাৰী আৰু ভতিজা পুতেক লোটক লগত লৈ ওলাই গ’ল। তেওঁৰ সকলো উপাৰ্জিত ধন, সম্পত্তি আৰু তেওঁ হাৰণত পোৱা সকলো দাসবোৰক লৈ কনান দেশ অভিমুখে যাত্রা কৰিলে। পাছত তেওঁলোকে কনান দেশ গৈ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","কনান দেশৰ মাজেদি অব্ৰাম চিখিম নগৰলৈ গ’ল আৰু তাৰ পাছত মোৰিৰ ওক গছজোপা পর্যন্ত গ’ল। সেইসময়ত কনানীয়াসকলে সেই দেশত বাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","পাছত যিহোৱাই অব্ৰামক দৰ্শন দি ক’লে, “এই দেশখনকে মই তোমাৰ বংশক দিম।” তাতে অব্রামে তেওঁক দৰ্শন দিয়া যিহোৱাৰ উদ্দেশ্যে সেই ঠাইত এটা যজ্ঞবেদী নিৰ্ম্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","তাৰ পাছত চিখিমৰ পৰা অব্রামে বৈৎএলৰ পূবফালে পাহাৰীয়া এলেকালৈ আগুৱাই গ’ল আৰু তাত তেওঁ বৈৎএলক পশ্চিম আৰু অয়ক পূব কৰি তম্বু তৰিলে; সেই ঠাইতো তেওঁ যিহোৱালৈ এটা যজ্ঞ-বেদী নিৰ্ম্মাণ কৰিলে আৰু যিহোৱাৰ নামেৰে প্ৰাৰ্থনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","তাৰ পাছত অব্ৰামে পুনৰ যাত্রা আৰম্ভ কৰিলে আৰু তেওঁ নেগেভৰ ফালে অগ্রসৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","পাছত কনান দেশত আকাল হ’ল; আকাল অতিশয়ৰূপে বৃদ্ধি হোৱাত অব্ৰামে মিচৰ দেশত প্ৰবাস কৰিবলৈ নামি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","তেওঁ মিচৰ দেশত প্রৱেশ কৰাৰ ঠিক আগমুহূর্তত তেওঁৰ ভাৰ্যা চাৰীক ক’লে, “শুনা, মই জানো তুমি এগৰাকী সুন্দৰী মহিলা। ");
INSERT INTO asmfb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","তোমাক যেতিয়া মিচৰীয়াসকলে দেখিব, তেতিয়া তেওঁলোকে ক’ব, ‘এই মহিলাগৰাকী সেই লোকজনৰ ভাৰ্যা।’ পাছত তেওঁলোকে মোক বধ কৰি তোমাক জীয়াই ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","সেয়ে তুমি ক’বা যে, তুমি মোৰ ভনী হয়। তাতে তোমাৰ কাৰণে মোলৈ ভাল হ’ব পাৰে আৰু মোৰ প্ৰাণো ৰক্ষা পৰিব পাৰে।” ");
INSERT INTO asmfb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","অব্ৰাম যেতিয়া মিচৰ দেশত সোমাল, তেতিয়া মিচৰীয়াসকলে চাৰীক অতি সুন্দৰী দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ফৰৌণৰ ৰাজপুত্রসকলেও চাৰীক দেখা পাই ফৰৌণ ৰজাৰ আগত তেওঁৰ প্রশংসা কৰিলে। ফলত চাৰীক ফৰৌণৰ ৰাজপ্রাসাদলৈ লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","চাৰীৰ কাৰণে ফৰৌণে অব্ৰামলৈ ভাল ব্যৱহাৰ কৰিবলৈ ধৰিলে; তেওঁ অব্রামক অনেক মেৰ-ছাগ, গৰু, গাধ, গাধী, দাস-দাসী আৰু উট দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","কিন্তু অব্ৰামৰ ভাৰ্যা চাৰীৰ কাৰণে যিহোৱাই ফৰৌণ আৰু তেওঁৰ পৰিয়ালৰ সকলো লোকৰ মাজত ভয়ঙ্কৰ মহামাৰী ঘটালে। ");
INSERT INTO asmfb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ফৰৌণে অব্ৰামক মাতি ক’লে, “আপুনি মোৰ লগত এইটো কি কাম কৰিলে? এওঁ যে আপোনাৰ ভাৰ্যা, তাক মোক কিয় কোৱা নাছিল? ");
INSERT INTO asmfb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","আপুনি কিয় ‘তাই মোৰ ভনী’ বুলি কৈছিল? সেই কাৰণেহে মই তেওঁক বিয়া কৰিবলৈ আনিছিলোঁ। এতিয়া, এয়া আপোনাৰ ভাৰ্যা; তেওঁক লৈ আপুনি গুছি যাওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","তাৰ পাছতে অব্রামৰ বিষয়ে ফৰৌণে তেওঁৰ লোকসকলক আজ্ঞা দিলে আৰু তেওঁলোকে অব্রামক তেওঁৰ ভার্য্যা আৰু তেওঁৰ সকলো সম্পদেৰে সৈতে দূৰলৈ পঠিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","তেতিয়া অব্ৰামে তেওঁৰ ভাৰ্যা আৰু তেওঁলোকৰ সকলো বয়-বস্তুৰে সৈতে মিচৰ দেশ এৰি নেগেভলৈ গ’ল; সেই সময়ত লোটও তেওঁলোকৰ লগত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","এই সময়ত অব্ৰাম অতিশয় ধনী আছিল। তেওঁৰ অনেক পশু, সোণ আৰু ৰূপ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","পাছত তেওঁ নেগেভৰ পৰা যাত্রা কৰি কৰি বৈৎএল পর্যন্ত গ’ল। এই বৈৎএল আৰু অয় নগৰৰ মধ্যৱর্তী স্থানতে পূৰ্বতে তেওঁৰ তম্বু আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","এই ঠাইতে তেওঁ আগেয়ে নির্ম্মাণ কৰা যজ্ঞবেদীটো আছিল আৰু তাত তেওঁ যিহোৱাৰ নামেৰে প্ৰাৰ্থনা কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","অব্ৰামৰ যাত্রাত একেলগে থকা যি লোট, তেওঁৰ নিজৰো বহুত মেৰ-ছাগ, পশুৰ জাক, আৰু তম্বু আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","অব্রাম আৰু লোট উভয়ৰ কাৰণে একেলগে কাষত থাকি বাস কৰিবলৈ সেই ঠাই যথেষ্ট নাছিল, কাৰণ তেওঁলোকৰ সা-সম্পদ বহুত বেছি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","তাৰ উপৰি অব্ৰাম আৰু লোটৰ পশু-ৰখীয়াৰ মাজতো বিবাদ আৰম্ভ হৈছিল। সেই সময়ত কনানীয়া আৰু পৰিজ্জীয়াসকলো সেই দেশত বাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","তেতিয়া অব্ৰামে লোটক ক’লে, “চোৱা, আমি আত্মীয় হওঁ আৰু সেয়ে, মোৰে তোমাৰে মাজত, মোৰ পশু-ৰখীয়া আৰু তোমাৰ পশু-ৰখীয়াৰ মাজত বিবাদ হোৱাটো উচিত নহব; ");
INSERT INTO asmfb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","গোটেই দেশখনেই জানো তোমাৰ আগত নাই? সেয়ে তুমি মোৰ পৰা বেলেগ হোৱা উচিত; তুমি বাওঁহাতে গ’লে, মই সোঁহাতে যাম; নাইবা তুমি সোঁহাতে গ’লে মই বাওঁহাতে যাম।” ");
INSERT INTO asmfb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","তেতিয়া লোটে চাৰিওফালে চাই দেখিলে যে যৰ্দ্দন নদীৰ পাৰৰ গোটেই সমতল ভূমিত চোৱৰলৈকে প্রচুৰ পানী আছে; সেই ঠাইখিনি যিহোৱাৰ বাগিছাৰ নিচিনা আৰু মিচৰ দেশৰ নিচিনা; যিহোৱাই চদোম আৰু ঘমোৰা নগৰ ধ্বংস কৰাৰ পূৰ্বতে এই সমতল ভূমি তেনেকুৱা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","তেতিয়া লোটে যৰ্দ্দন নদীৰ গোটেই সমভূমিলৈ নিজৰ কাৰণে বাচি লৈ পূব ফাললৈ যাত্ৰা কৰিলে; এইদৰে তেওঁলোক এজন আন জনৰ কাষৰ পৰা বেলেগ হৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","অব্ৰামে কনান দেশত আৰু লোটে সেই সমভূমিৰ নগৰবোৰত বাস কৰিবলৈ ধৰিলে। লোটে চদোমৰ ওচৰত তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","চদোমত বাস কৰা অধিবাসীসকল অতিশয় দুষ্ট আছিল আৰু যিহোৱাৰ বিৰুদ্ধে তেওঁলোকে ভীষণ পাপ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","অব্ৰামৰ পৰা লোট বেলেগ হৈ যোৱাৰ পাছত যিহোৱাই অব্ৰামক ক’লে, “তুমি যি ঠাইত থিয় হৈ আছা, তাৰ পৰা উত্তৰ-দক্ষিণ আৰু পূব-পশ্চিমলৈ এবাৰ চোৱা; ");
INSERT INTO asmfb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","যি সকলো ঠাই তুমি দেখিছা, তাক মই তোমাক আৰু তোমাৰ বংশক চিৰকালৰ কাৰণে দিম। ");
INSERT INTO asmfb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","মই তোমাৰ বংশৰ লোকসকলক পৃথিবীৰ ধূলিৰ নিচিনা অসংখ্য কৰিম; কোনোৱে যদি পৃথিবীৰ ধূলি গণিব পাৰে, তেন্তে তোমাৰ বংশকো গণিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","উঠা, এই ভূমিৰ দীঘে পথালিয়ে ঘূৰি ফুৰা; কিয়নো মই তোমাক এই দেশখনকে দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","তেতিয়া অব্ৰামে তেওঁৰ তম্বু তুলি ল’লে আৰু হিব্ৰোণ এলেকালৈ আহি মম্ৰিৰ ওক গছবোৰৰ ওচৰত নিবাস কৰিলে। সেই ঠাইত তেওঁ যিহোৱাৰ উদ্দেশে এটা যজ্ঞ-বেদী নিৰ্ম্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","যি সময়ত চিনাৰ দেশৰ ৰজা অম্ৰাফল আছিল, তেতিয়া অৰিয়োক আছিল ইল্লাচৰৰ ৰজা, এলমৰ ৰজা আছিল কদৰ্লায়োমৰ আৰু গোয়ীমৰ ৰজা তিদিয়ল আছিল, ");
INSERT INTO asmfb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","সেইসময়ত এই কেইজন ৰজাই মিলি চদোমৰ বিৰা ৰজা, ঘমোৰাৰ বিৰ্চা ৰজা, অদ্মাৰ চিনাব ৰজা, চবোয়ীমৰ চিমেবৰ ৰজা আৰু বিলা অৰ্থাৎ চোৱৰৰ ৰজাসকলৰ বিৰুদ্ধে যুদ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","পাছৰ এই পাঁচজন ৰজা চিদ্দিম উপত্যকাত একত্রিত হ’ল। এই ঠাইখিনিক লোণসমুদ্ৰ বোলা হ’য়। ");
INSERT INTO asmfb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","এই ৰজাসকল বাৰ বছৰলৈকে ৰজা কদৰ্লায়োমৰ অধীনত আছিল, কিন্তু তেৰ বছৰত তেওঁলোকে বিদ্ৰোহ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","তাৰ পাছত চৈধ্য বছৰত ৰজা কদৰ্লায়োমৰ আৰু তেওঁৰ সংগী ৰজাসকলে গৈ ৰফায়ীয়াসকলক অস্তৰোৎকৰ্ণয়িমত, জজীয়াসকলক হামত, এমীয়াসকলক চাবি-কিৰিয়াথয়িমত আহি আক্রমণ কৰিলে আৰু ");
INSERT INTO asmfb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","হোৰীয়াসকলক এল-পাৰণলৈকে তেওঁলোকৰ পাহাৰীয়া অঞ্চল চেয়ীত পৰাজয় কৰিলে। এল-পাৰণ মৰু-প্রান্তৰৰ কাষত অৱস্থিত। ");
INSERT INTO asmfb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","তাৰ পাছত এই ৰজাসকল ঘূৰি গৈ অয়িন-মিস্পাট অৰ্থাৎ কাদেচলৈ গ’ল। তেওঁলোকে অমালেকীয়াসকলৰ গোটেই দেশ জয় কৰি ল’লে আৰু হচচোন-তামৰত থকা ইমোৰীয়াসকলকো পৰাজয় কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","এই সকলো ঘটনাৰ পাছত চদোমৰ ৰজা, ঘমোৰাৰ ৰজা, অদ্মাৰ ৰজা, চবোয়ীমৰ ৰজা আৰু বিলাৰ ৰজা অৰ্থাৎ চোৱৰৰ ৰজা ওলাই গৈ যুদ্ধৰ কাৰণে যুগুত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","তেওঁলোকে এলমৰ ৰজা কদৰ্লায়োমৰ, গোয়ীমৰ ৰজা তিদিয়ল, চিনাৰ দেশৰ ৰজা অম্ৰাফল, ইল্লাচৰৰ ৰজা অৰিয়োকৰ বিৰুদ্ধে যুদ্ধ কৰিবলৈ গ’ল। এই যুদ্ধ পাঁচ জন ৰজাৰ বিৰুদ্ধে চাৰিজন ৰজাৰ মাজত হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","চিদ্দিম উপত্যকাত আলকতৰাৰে পূর্ণ বহুতো গাত আছিল; যেতিয়া চদোম আৰু ঘমোৰাৰ ৰজা পলাই গৈছিল, তেতিয়া তেওঁলোক সেই গাতত পৰিল; আন অৱশিষ্ট লোকসকল পাহাৰলৈ পলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","শত্রুপক্ষই চদোম আৰু ঘমোৰাৰ সকলো ধন-সম্পত্তি আৰু বয়-বস্তু লুট কৰি লৈ গুচি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","তেওঁলোক যাওঁতে সকলো সম্পদেৰে সৈতে চদোমত বাস কৰা অব্ৰামৰ ভতিজা পুতেক লোটকো বন্দী কৰি লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","তেতিয়া পলাই আহি ৰক্ষা পোৱা এজন পলাতকে ইব্ৰীয়া অব্ৰামক সেই খবৰ দিলে; সেই সময়ত অব্রাম ইষ্কোল আৰু আনেৰৰ ভায়েক ইমোৰীয়া মম্ৰিৰ ওক গছবোৰৰ ওচৰত বাস কৰিছিল আৰু তেওঁলোক অব্ৰামৰ মিত্ৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","অব্ৰামে যেতিয়া শুনিলে যে তেওঁৰ আত্মীয়ক বন্দী কৰি লৈ গৈছে, তেতিয়া তেওঁ প্রশিক্ষণ প্রাপ্ত তেওঁৰ গৃহতেই জন্ম হোৱা তিনি শ ওঠৰ জন দাসক লৈ শত্রুবোৰৰ পাছে পাছে দানলৈকে খেদি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","পাছত ৰাতি তেওঁ নিজৰ লোকসকলক কিছুমান দলত বিভক্ত কৰি শত্রুবোৰক আঘাত কৰিলে আৰু দম্মেচকৰ উত্তৰে অৱস্থিত হোবা পর্যন্ত তেওঁলোকক খেদি পঠিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","তেওঁ সকলোবোৰ সম্পত্তি ঘূৰাই আনিলে; তেওঁৰ ভতিজা পুতেক লোটক তেওঁৰ বয়-বস্তুৰে সৈতে উদ্ধাৰ কৰিলে আৰু পুৰুষ-মহিলা সকলোকে ওভটাই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","কদৰ্লায়োমৰ আৰু তেওঁৰ সংগী ৰজাসকলক অব্রামে যেতিয়া হৰুৱাই উভতি আহিছিল, তেতিয়া চদোমৰ ৰজাই তেওঁৰ লগত সাক্ষাত হবলৈ চাবি উপত্যকালৈ অৰ্থাৎ ৰজাৰ উপত্যকালৈ ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","চালেমৰ ৰজা মল্কীচেদকে পিঠা আৰু দ্ৰাক্ষাৰস আনিলে; মল্কীচেদক সৰ্ব্বোপৰি ঈশ্বৰৰ পুৰোহিত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","তেওঁ অব্ৰামক আশীৰ্ব্বাদ কৰি ক’লে, “স্বৰ্গ আৰু পৃথিৱীৰ সৃষ্টিকর্তা সৰ্ব্বোপৰি ঈশ্বৰৰ দ্বাৰা অব্ৰাম আশীৰ্ব্বাদপ্ৰাপ্ত হওক; ");
INSERT INTO asmfb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","যিজনে আপোনাৰ শত্রুবোৰক আপোনাৰ হাতত সমৰ্পণ কৰিছে, সেই সৰ্ব্বোপৰি ঈশ্বৰৰ ধন্য হওক।” তেতিয়া অব্ৰামে সকলো বস্তুৰে দহ ভাগৰ এভাগ তেওঁক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","পাছত চদোমৰ ৰজাই অব্ৰামক ক’লে, “আপুনি ধন-সম্পদবোৰ ৰাখি লোকসকলক মোক দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","অব্ৰামে চদোমৰ ৰজাক ক’লে, “মই স্বৰ্গ আৰু পৃথিৱীৰ সৃষ্টিকর্তা সৰ্ব্বোপৰি ঈশ্বৰ যিহোৱাৰ নামেৰে হাত দাঙি শপত খাই কৈছোঁ যে, ");
INSERT INTO asmfb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","আপোনাৰ একো বস্তুৱেই, এনে কি এগছি সূতা কি জোতাৰ ফিটাও নলওঁ; যাতে আপুনি কেতিয়াও ক’ব নোৱাৰে ‘মইহে অব্ৰামক ধনৱান কৰিলোঁ’ বুলি। ");
INSERT INTO asmfb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","কেৱল মোৰ যুবকসকলে ইতিমধ্যে যি খালে, তাৰ বাহিৰে মই ইয়াৰ পৰা একো নিনিও; কিন্তু আনেৰ, ইষ্কোল আৰু মম্ৰি মোৰ লগত গৈছিল; তেওঁলোকক নিজৰ ভাগ ল’ব দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","এইবোৰ ঘটনাৰ পাছত, দৰ্শনযোগে অব্ৰামলৈ যিহোৱাৰ বাক্য আহিল, তেওঁ ক’লে, “হে অব্ৰাম, ভয় নকৰিবা; ময়েই তোমাৰ ঢাল আৰু মহা পুৰস্কাৰস্বৰূপ।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","অব্ৰামে ক’লে, “হে প্ৰভু যিহোৱা; আপুনি মোক কি দিব? মই যে নিঃসন্তান। দম্মেচকীয়া ইলীয়েজৰহে মোৰ ঘৰৰ উত্তৰাধিকাৰী হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","অব্ৰামে ক’লে, “আপুনি মোক সন্তান নিদিলে আৰু সেয়ে মোৰ ঘৰৰ এজন দাসেই মোৰ উত্তৰাধিকাৰী হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","তেতিয়া যিহোৱাৰ বাক্য তেওঁলৈ আহিল; তেওঁ ক’লে, “নহয়, এই মানুহ তোমাৰ উত্তৰাধিকাৰী নহ’ব। কিন্তু তোমাৰ ঔৰসত জন্মা জনহে তোমাৰ উত্তৰাধিকাৰী হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","তেতিয়া যিহোৱাই অব্ৰামক বাহিৰলৈ নি ক’লে, “তুমি আকাশৰ ফালে চোৱা আৰু যদি পাৰা তৰাবোৰ গণনা কৰা।” তেওঁ আকৌ অব্ৰামক ক’লে, “এইদৰে তোমাৰ বংশও হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","তেতিয়া অব্রামে যিহোৱাত বিশ্বাস কৰিলে আৰু যিহোৱাই অব্রামৰ বিশ্বাসক তেওঁৰ পক্ষে ধাৰ্মিকতা বুলি গণ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","পাছত যিহোৱাই তেওঁক ক’লে, “ময়েই সেই যিহোৱা! এই দেশৰ অধিকাৰী হবৰ কাৰণে ময়েই তোমাক কলদীয়াসকলৰ উৰ নগৰৰ পৰা বাহিৰ কৰি আনিলো।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","তেতিয়া তেওঁ ক’লে, “হে প্ৰভু যিহোৱা, মই কেনেকৈ জানিম যে এই দেশখন মোৰ অধিকাৰত আহিব?” ");
INSERT INTO asmfb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","তেতিয়া যিহোৱাই তেওঁক ক’লে, “তুমি মোৰ ওচৰলৈ এজনী তিনি বছৰীয়া চেঁউৰী গৰু, এজনী তিনি বছৰীয়া মাইকী ছাগলী, এটা তিনিবছৰীয়া মতা মেৰ-ছাগ পোৱালি, এটা কপৌ আৰু এটা পাৰ পোৱালি আনা।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","অব্রামে সেই সকলোকে আনি সেইবোৰক দুফালকৈ কাটি প্রতিডোখৰ টুকুৰা তাৰ অন্য টুকুৰাৰ বিপৰীতে সজাই ৰাখিলে; কিন্তু চৰাইবোৰ হ’লে তেওঁ দুফাল নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","পাছত চিকাৰী চৰাইবোৰ নামি আহি সেই পশুৰ মাংসখণ্ডৰ ওপৰত পৰিল, কিন্তু অব্ৰামে সেইবোৰক খেদাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","পাছত যেতিয়া সূর্য মাৰ গৈছিল, তেতিয়া অব্ৰামৰ ঘোৰ টোপনি আহিল; হঠাতে এক ঘন আৰু ভয়ংকৰ অন্ধকাৰ তেওঁৰ ওপৰত নামি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","তেতিয়া তেওঁ অব্ৰামক ক’লে, “তুমি এই কথা নিশ্চিতভাৱে জনা উচিত যে তোমাৰ বংশৰ লোকসকল যি দেশত বাস কৰিব, সেই দেশ তেওঁলোকৰ নিজৰ নহয়। সেই ঠাইত তেওঁলোকে প্রবাসী হৈ দাস হ’ব আৰু চাৰিশ বছৰ কাল তেওঁলোকে উৎপীড়ন ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","তেওঁলোকে যি জাতিৰ বন্দীকাম কৰিব, মই সেই জাতিৰ সোধ-বিচাৰ কৰিম আৰু পাছত তেওঁলোকে অধিক সম্পত্তিৰে সৈতে বাহিৰ হৈ আহিব। ");
INSERT INTO asmfb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","কিন্তু তুমি শান্তিৰে তোমাৰ পূৰ্বপুৰুষসকলৰ ওচৰলৈ যাবা; অতি বৃদ্ধ অৱস্থাত তোমাক মৈদাম দিয়া হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","তোমাৰ চতুৰ্থ প্রজন্মৰ লোকসকল ইয়ালৈ পুনৰ উলটি আহিব; কিয়নো এতিয়ালৈকে মোৰ ওচৰত ইমোৰীয়াসকলৰ অপৰাধ শাস্তি পোৱাৰ দৰে হোৱা নাই।” ");
INSERT INTO asmfb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","বেলি মাৰ গৈ যেতিয়া আন্ধাৰ হ’ল তেতিয়া জুইৰ এক ধোঁৱাময় চুলা আৰু এক জ্বলন্ত মশাল দেখা গ’ল। সেইবোৰ সেই মঙহৰ টুকুৰাবোৰৰ মাজেদি পাৰ হৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","সেইদিনা যিহোৱাই অব্ৰামে সৈতে এটি এইবুলি কৈ এটা নিয়ম স্থিৰ কৰিলে, “মিচৰৰ নদীৰ পৰা মহানদী ইউফ্রেটিচ পর্যন্ত গোটেইখন দেশ মই তোমাৰ বংশক দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","তাৰ মাজত থাকিব কেনীয়া, কনিজ্জীয়া, কদমোনীয়া, ");
INSERT INTO asmfb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","হিত্তীয়া, পৰিজ্জীয়া, ৰফায়ীয়া, ");
INSERT INTO asmfb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ইমোৰীয়া, কনানীয়া, গিৰ্গাচীয়া, আৰু যিবুচীয়া।” ");
INSERT INTO asmfb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","অব্ৰামৰ ভাৰ্যা চাৰী তেতিয়ালৈকে নিঃসন্তান আছিল; হাগাৰ নামেৰে চাৰীৰ এগৰাকী মিচৰীয়া দাসী আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","এদিন চাৰীয়ে অব্ৰামক ক’লে, “চোৱা, যিহোৱাই মোক নিঃসন্তান কৰি ৰাখিছে। সেই কাৰণে আপুনি মোৰ দাসীৰ শয্যাৰ সংগী হওঁক, কিজানি মই তাইৰ পৰা সন্তান লাভ কৰিম।” তেতিয়া অব্ৰাম চাৰীৰ কথাত মান্তি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","কনান দেশত অব্ৰামে দহ বছৰ কটোৱাৰ পাছত ভাৰ্যা চাৰীয়ে তেওঁৰ মিচৰীয়া দাসী হাগাৰক আনি নিজৰ স্বামী অব্ৰামৰ সংগী কৰি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","অব্ৰামে হাগাৰৰ সৈতে একেলগ হোৱাত তাই গৰ্ভৱতী হ’ল। হাগাৰে যেতিয়া বুজি পালে যে তাই গৰ্ভৱতী হৈছে, তেতিয়া তাই নিজৰ গৰাকীয়ণীক তুচ্ছ জ্ঞান কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","সেয়ে চাৰীয়ে অব্ৰামক ক’লে, “মোৰ প্রতি কৰা তাইৰ এই অন্যায়ৰ কাৰণে আপুনিয়ে দায়ী; মোৰ এই দাসীক ময়েই আপোনাৰ বাহুত দিলোঁ; কিন্তু এতিয়া তাই নিজকে গৰ্ভৱতী হোৱা জানি মোকেই হেয়জ্ঞান কৰিছে; এতিয়া যিহোৱায়ে আপোনাৰ আৰু মোৰ মাজত বিচাৰ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","অব্ৰামে চাৰীক ক’লে, “চোৱা, তোমাৰ দাসী তোমাৰ অধীনতে আছে; গতিকে যিহকে ভাল বুলি ভাবা, তুমি তাইৰ প্রতি তাকে কৰা।” তেতিয়া চাৰীয়ে হাগাৰৰ প্রতি এনে কঠোৰ ব্যৱহাৰ কৰিবলৈ ধৰিলে যে তাই তেওঁৰ ওচৰৰ পৰা পলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","পাছত মৰুপ্রান্তৰৰ মাজত এটা জলৰ ভুমুকৰ কাষত যিহোৱাৰ দূতে হাগাৰক দেখা পালে। এই ভুমুকতো চূৰলৈ যোৱাৰ পথত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","যিহোৱাৰ দূতে ক’লে, “হেৰা চাৰীৰ দাসী হাগাৰ, তুমি ক’ৰ পৰা আহিছা আৰু ক’লৈ গৈ আছা?” তাই ক’লে, “মই মোৰ গৰাকীয়ণী চাৰীৰ ওচৰৰ পৰা পলাই আহিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","তেতিয়া যিহোৱাৰ দূতে ক’লে, “তুমি তোমাৰ গৰাকীয়ণীৰ ওচৰলৈ উলটি যোৱা আৰু তেওঁৰ অধীনত থাকি বাধ্য হোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","যিহোৱাৰ দূতে পুনৰ তাইক ক’লে, “মই তোমাৰ বংশৰ লোকৰ সংখ্যা ইমান বৃদ্ধি কৰিম যে তেওঁলোকৰ সংখ্যা গণিবই নোৱাৰা হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","পুনৰ যিহোৱাৰ দূতে তাইক ক’লে, “চোৱা, তুমি গৰ্ভৱতী। তোমাৰ এটি পুত্ৰ জন্ম হ’ব; তুমি সেই ল’ৰাৰ নাম ইশ্মায়েল ৰাখিবা; কিয়নো যিহোৱাই তোমাৰ দূখৰ কথা শুনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","মানুহ হলেও সেই ল’ৰা বনৰীয়া গাধৰ দৰে হ’ব। সি তাৰ সকলো ভাইৰ বিৰুদ্ধে শত্রুভাৱ কৰিব আৰু সকলো মানুহেও তাক শত্রু জ্ঞান কৰিব; সি নিজৰ ভাইসকলৰ দেশৰ কাষত বাস কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","এই কথা শুনি হাগাৰে তেওঁৰে সৈতে কথা কোৱা যিহোৱাক এই নাম দিলে, আল-ৰোৱী কিয়নো তাই ক’লে, “মই তেনেহলে সচাঁকৈয়ে যি জনাই মোক চাই আছে, সেইজনা যিহোৱাক দেখিলোঁ নেকি!” ");
INSERT INTO asmfb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","সেই নাদৰ নাম বেৰ-লহয়-ৰোৱী হ’ল; সেই নাদ কাদেচ আৰু বাৰদৰ মাজত অৱস্থিত ");
INSERT INTO asmfb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","পাছত হাগাৰে অব্ৰামলৈ এটি পুত্ৰ প্ৰসৱ কৰিলে আৰু অব্ৰামে হাগাৰৰ পৰা জন্মা সেই পুত্ৰৰ নাম ইশ্মায়েল হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","অব্রামৰ ছয়াশী বছৰ বয়সত হাগাৰে অব্ৰামলৈ ইশ্মায়েলক প্ৰসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","অব্ৰামৰ বয়স যেতিয়া নিৰানব্বই বছৰ হ’ল, তেতিয়া যিহোৱাই অব্ৰামক দৰ্শন দি ক’লে, “মই সৰ্ব্বশক্তিমান ঈশ্বৰ; মোৰ লগত চলাচল কৰা আৰু সিদ্ধ হোৱা। ");
INSERT INTO asmfb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","মোৰ আৰু তোমাৰ মাজত মই মোৰ বিধি স্থাপন কৰিম আৰু মই তোমাৰ বংশক অতিশয় ৰূপে বৃদ্ধি কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","তেতিয়া অব্ৰামে উবুৰি খাই মাটিত মুখ থৈ প্রণিপাত কৰিলে আৰু ঈশ্বৰে তেওঁৰে সৈতে কথা ক’বলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","তেওঁ ক’লে, “শুনা, তোমাৰ সৈতে স্থাপন কৰা মোৰ বিধি এই: তুমি এক বাহুল্য জাতিৰ আদিপিতৃ হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","তোমাক অব্ৰাম বুলি পুনৰ কোৱা নহ’ব, কিন্তু এতিয়াৰ পৰা তোমাৰ নাম অব্ৰাহামহে হ’ব; কিয়নো মই তোমাক আদিপিতৃ হ’বলৈ নিৰূপণ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","মই তোমাৰ বংশ অতিশয়ৰূপে বৃদ্ধি কৰিম। তোমাৰ পৰা মই অনেক নতুন জাতিৰ সৃষ্টি কৰিম আৰু তোমাৰ পৰা ৰজাসকলৰো জন্ম হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","এই বিধি মোৰ, তোমাৰ আৰু তোমাৰ ভাবী-বংশৰ মাজত পুৰুষানুক্রমে স্থাপন কৰিলোঁ; ই এক চিৰকালৰ বিধি হ’ব। মই তোমাৰ আৰু তোমাৰ ভাবী-বংশৰ লোকসকলৰ ঈশ্বৰ হ’বলৈ মোৰ বিধি স্থাপন কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","যি কনান দেশত তুমি প্রবাসী হৈ বাস কৰিছা, মই তোমাক আৰু তোমাৰ ভাবী-বংশক এই সমুদায় দেশ সদাকালৰ অধিকাৰৰ অৰ্থে দিম আৰু মই তেওঁলোকৰ ঈশ্বৰ হ’ম।” ");
INSERT INTO asmfb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","পুনৰ ঈশ্বৰে অব্ৰাহামক ক’লে, “তোমালোকৰ বাবে মোৰ এই বিধি পালন কৰিব লাগিব; তুমি আৰু তোমাৰ ভাবী-বংশই পুৰুষানুক্ৰেমে তাক পালন কৰিব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","তোমালোকে মানিবলগীয়া এই বিধি হৈছে - তোমালোকৰ মাজৰ প্রত্যেক পুৰুষৰ চুন্নৎ হ’ব লাগিব; এই বিধি তোমাৰ আৰু তোমাৰ বংশৰ লোকসকলে মানি চলিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","তোমালোকে নিজ নিজ লিঙ্গাগ্ৰ-চৰ্ম্ম ছেদন কৰিবা আৰু সেয়ে মোৰে আৰু তোমালোকৰ মাজত স্থাপিত হোৱা নিয়মৰ চিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","বংশানুক্রমে তোমালোকৰ প্রত্যেকজন পুত্ৰ-সন্তানৰ জন্মৰ আঠ দিনৰ দিনা এই চুন্নৎ হ’ব লাগিব; বংশৰ কোনো নহলেওঁ তোমালোকৰ ঘৰত জন্ম হোৱা আৰু বিদেশীৰ পৰা কিনি লোৱা দাসবোৰৰো চুন্নৎ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","তোমাৰ ঘৰত জন্ম হোৱা পুৰুষ আৰু তুমি কিনি লোৱা সকলো পুৰুষৰে চুন্নৎ হ’বই লাগিব; এইদৰে তোমালোকৰ শৰীৰত মোৰ বিধি চিৰকালৰ এক নিয়ম হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","যি জন পুৰুষৰ লিঙ্গগ্ৰ-চৰ্ম্ম ছেদন কৰা নহয়, এনে চুন্নৎ নোহোৱা পুৰুষক নিজ জাতিৰ মাজৰ পৰা বহিস্কাৰ কৰা হ’ব; কাৰণ তেওঁ মোৰ বিধি অমান্য কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ঈশ্বৰে অব্ৰাহামক ক’লে, “তোমাৰ ভাৰ্যা চাৰীক আৰু চাৰী বুলি নামাতিবা; কিন্তু তেওঁৰ নাম চাৰা ৰাণী হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","মই তেওঁক আশীৰ্ব্বাদ কৰিম আৰু তেওঁৰ পৰা তোমাক এটি পুত্ৰও দিম; মই তেওঁক আশীৰ্ব্বাদ কৰিম যাতে তেওঁ অনেক জাতি আৰু তেওঁলোকৰ ৰজাসকলৰ আদিমাতৃ হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","এই কথা শুনি অব্ৰাহামে মাটিত উবুৰি হৈ পৰিল আৰু হাঁহি মাৰি মনতে ক’লে, “এশ বছৰীয়া বৃদ্ধই সন্তান পাবনে আৰু নব্বৈ বছৰীয়া চাৰাই জানো সন্তান প্ৰসৱ কৰিব পাৰে?” ");
INSERT INTO asmfb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","অব্ৰাহামে ঈশ্বৰক ক’লে, “ইশ্মায়েলেই যেন আপোনাৰ দৃষ্টিত জীয়াই থাকে, মোলৈ এয়ে সন্তোষজনক।” ");
INSERT INTO asmfb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ঈশ্বৰে ক’লে, “নহয়, তোমাৰ ভাৰ্যা চাৰাই তোমালৈ এটি পুত্ৰ প্ৰসৱ কৰিব আৰু তুমি তেওঁৰ নাম ইচহাক হাঁহি ৰাখিবা; মই চিৰকালৰ এক বিধিৰূপে ইচহাক আৰু তেওঁৰ ভাবী-বংশৰ লোকসকলৰ সৈতে মোৰ বিধি স্থাপন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ইশ্মায়েলৰ বিষয়ে হ’লে মই তোমাৰ কথা শুনিলোঁ; চোৱা, মই তেওঁক আশীৰ্ব্বাদ কৰিলোঁ; তেওঁকো মই বহুবংশ কৰিম আৰু তেওঁৰ সন্তান-সন্ততি অতিশয়ৰূপে বৃদ্ধি কৰিম; তেৱোঁ বাৰজন গোষ্ঠী-নেতাৰ পিতৃ হ’ব আৰু তেওঁৰ পৰা মই এক মহাজাতি উৎপন্ন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","কিন্তু মোৰ নিয়মটি হ’লে অহা বছৰ এই সময়তে চাৰাই তোমালৈ যি সন্তান প্ৰসৱ কৰিব, সেই ইচহাকৰ সৈতেহে স্থাপন কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","অব্ৰাহামৰ লগত কথা কৈ শেষ কৰাৰ পাছত ঈশ্বৰ তেওঁৰ ওচৰৰ পৰা ওপৰলৈ গুছি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","তাৰ পাছত ঈশ্বৰৰ কথা অনুসাৰে অব্ৰাহামে তেওঁৰ পুতেক ইশ্মায়েলক, তেওঁৰ ঘৰত জন্ম হোৱা আৰু কিনি লোৱা দাসবোৰক অৰ্থাৎ অব্ৰাহামৰ ঘৰত যিমান পুৰুষ আছিল, তেওঁ সেই দিনাই সকলোৰে লিঙ্গাগ্ৰ-চৰ্ম্ম ছেদন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","অব্ৰাহামে যেতিয়া নিজৰ লিঙ্গাগ্ৰ-চৰ্ম্ম ছেদন কৰিছিল, সেই সময়ত তেওঁৰ বয়স আছিল নিৰানব্বৈ বছৰ আৰু ");
INSERT INTO asmfb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","তেওঁৰ পুত্ৰ ইশ্মায়েলৰ বয়স আছিল তেৰ বছৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","সেই একে দিনাই অব্ৰাহাম আৰু তেওঁৰ পুত্ৰ ইশ্মায়েল দুয়োৰে চুন্নৎ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","তেওঁৰ লগতে ঘৰৰ আন সকলো পুৰুষৰ অর্থাৎ তেওঁৰ ঘৰত জন্ম হোৱা আৰু বিদেশীৰ পৰা যি সকলক কিনি লোৱা হৈছিল, সেই সকলো পুৰুষৰে চুন্নৎ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","অব্রাহামে যেতিয়া মম্ৰিৰ ওক গছবোৰৰ ওচৰত বাস কৰিছিল, তেতিয়া যিহোৱাই তেওঁক এদিন দৰ্শন দিলে। তেওঁ দুপৰীয়াৰ ৰদত নিজৰ তম্বুৰ দুৱাৰ মুখত বহি আছিল; ");
INSERT INTO asmfb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","তেনে সময়তে তেওঁ মূৰ তুলি চাই দেখিলে, কিছু দূৰৈত তেওঁৰ সন্মুখত তিনি জন লোক থিয় হৈ আছে; তেওঁলোকক দেখামাত্ৰকে লগ ধৰিবলৈ তেওঁ তম্বুৰ দুৱাৰ মুখৰ পৰা লৰি গ’ল আৰু মাটিত উবুৰি হৈ প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","তেওঁ ক’লে, “হে প্ৰভু, যদি আপোনালোকৰ দৃষ্টিত মই অনুগ্ৰহ প্ৰাপ্ত হৈছোঁ, তেন্তে আপোনালোকৰ এই দাসক এৰি পাৰ হৈ আগবাঢ়ি নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","মই অলপ পানী আনি দিওঁ, আপোনালোকে ভৰি ধুই লওঁক আৰু গছজোপাৰ তলতে বিশ্ৰাম লওঁক। ");
INSERT INTO asmfb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","আপোনালোক যেতিয়া এই দাসৰ গুৰিলৈ আহিছে, তেন্তে মই অলপমান আহাৰো লৈ আনোগৈ; তাৰে আপোনালোকে যেন নিজৰ প্ৰাণ জুৰাব পাৰে আৰু পুনৰ যাত্রা কৰিব পাৰিব।” তেতিয়া তেওঁলোকে ক’লে, “ঠিক আছে, তুমি কোৱাৰ দৰেই কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","অব্ৰাহামে তেতিয়া বেগাই তম্বুৰ ভিতৰলৈ গৈ চাৰাক ক’লে, “তুমি সোনকালে তিনি চেয়া ভাল ময়দা মাখি লৈ কেইখনমান পিঠা যুগুত কৰি দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","তাৰ পাছত অব্ৰাহামে লৰি গৈ পশুৰ জাকৰ পৰা ভাল চাই এটা সৰু দামুৰি আনি তেওঁৰ দাসক দিলে; সেই দাসেও ততাতৈয়াকৈ তাক ৰান্ধিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","পাছত অব্রাহামে দৈ, গাখীৰ আৰু দামুৰিৰ ৰন্ধা মঙহ লৈ তেওঁলোকৰ সন্মুখত থলে; তেওঁলোকে যেতিয়া ভোজন কৰি আছিল, তেতিয়া অব্রাহাম তেওঁলোকৰ কাষতে থকা গছজোপাৰ তলত থিয় হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","তেওঁলোকে অব্রাহামক সুধিলে, “তোমাৰ ভাৰ্যা চাৰা ক’ত আছে?” তেওঁ ক’লে, “সৌ তাত, তম্বুৰ ভিতৰত আছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","তেতিয়া তেওঁলোকৰ মাজৰ এজনে ক’লে, “বসন্তকালত মই নিশ্চয়ে তোমাৰ ওচৰলৈ আকৌ উলটি আহিম; তেতিয়া তোমাৰ ভাৰ্যা চাৰাৰ এটি পুত্ৰ হ’ব।” চাৰাই তেওঁৰ পাছফালে তম্বুৰ দুৱাৰমুখত থাকি সকলো কথা শুনি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","অব্ৰাহাম আৰু চাৰা সেই সময়ত যথেষ্ট বৃদ্ধ-বৃদ্ধা; বয়সে ভাঁটি দিছিল আৰু চাৰাৰ পক্ষে সন্তান লাভৰ বয়সো নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","সেয়ে চাৰাই মনৰ ভিতৰতে হাঁহি নিজকে ক’লে, “মোৰ স্বামী এতিয়া বুঢ়া হ’ল আৰু ময়ো ক্ষয় পাই আহিলোঁ, মোৰ এনে আনন্দ হ’ব নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","যিহোৱাই তেতিয়া অব্ৰাহামক ক’লে, “চাৰাই কেলেই এই কথা কৈ হাঁহিলে যে ‘মই বুঢ়ীয়ে জানো সচাঁকৈয়ে এটি পুত্ৰ প্ৰসৱ কৰিম?’ ");
INSERT INTO asmfb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","যিহোৱাৰ ওচৰত দুঃসাধ্য বুলি জানো কিবা আছে? বসন্তকালত, মই নিৰূপণ কৰা সময়ত মই তোমাৰ ওচৰলৈ আকৌ আহিম। অহা বছৰ প্রায় এই সময়তে চাৰাৰ এটি পুত্ৰ হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","চাৰাই তেতিয়া ভয় খাই আসৈ মাতি ক’লে, “নাই, মই হ’লে হঁহা নাছিলো”; কিন্তু যিহোৱাই ক’লে, “নহয়, তুমি হাঁহিছিলা।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","তাৰ পাছত সেই লোককেইজন উঠিল আৰু তললৈ চদোমৰ ফালে চালে। অব্ৰাহামে তেওঁলোকক আগবঢ়াই থবলৈ তেওঁলোকৰ লগে লগে গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","পাছত যিহোৱাই ক’লে, “মই যি কৰিম, তাক জানো অব্ৰাহামৰ পৰা লুকুৱাই ৰাখিম? ");
INSERT INTO asmfb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","অৱশ্যেই অব্ৰাহামৰ পৰা এক মহান আৰু পৰাক্ৰমী জাতি হ’ব। তেওঁতেই পৃথিৱীৰ সমুদায় জাতিবোৰ আশীৰ্ব্বাদপ্ৰাপ্ত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","মই তেওঁক মনোনীত কৰিলোঁ যেন তেওঁ নিজৰ সন্তান সকলক আৰু ঘৰৰ ভাবীসন্তান সকলক যিহোৱাৰ পথত চলিবলৈ, সৎ আৰু ন্যায় কার্য কৰিবলৈ আজ্ঞা দিয়ে আৰু যেন যিহোৱাই অব্ৰাহামক যি কথা ক’লে তাক সিদ্ধ কৰিব পাৰে।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","তাৰ পাছত যিহোৱাই ক’লে, “চদোম আৰু ঘমোৰাক লৈ ভীষণ চিঞৰ-বাখৰ হৈছে আৰু তেওঁলোকৰ পাপও অতিশয় গুৰুতৰ হৈছে; ");
INSERT INTO asmfb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","সেইবাবে, মই এতিয়া তালৈ নামি গৈ তেওঁলোকে যি কৰিছে বুলি মই শুনিছো, সচাঁকৈয়ে তেওঁলোক সেইদৰে দুষ্ট হৈছে নেকি তাক চাম; যদি তেনে নহয়, তাকো মই জানিব পাৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","তাৰ পাছতে সেই পুৰুষ কেইজন তাৰ পৰা ঘূৰি চদোমৰ ফাললৈ গ’ল আৰু অব্ৰাহাম তেতিয়াও যিহোৱাৰ সন্মুখত থিয় হৈ থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","অব্ৰাহামে যিহোৱাৰ ওচৰলৈ আগবাঢ়ি গৈ সুধিলে, “আপুনি দুষ্টৰ লগত ধাৰ্মিককো বিনষ্ট কৰিব নে? ");
INSERT INTO asmfb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","সেই নগৰৰ মাজত যদি পঞ্চাশজন ধাৰ্মিক লোক আছে, সেই পঞ্চাশ জনৰ কাৰণে আপুনি সেই নগৰক ক্ষমা নিদি বিনষ্ট কৰিব নে? ");
INSERT INTO asmfb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ই আপোনাৰ পৰা দূৰ হওক! ধাৰ্মিক আৰু দুষ্টৰ প্রতি একে ধৰণৰ ব্যৱহাৰ কৰি, দুষ্টৰ লগত ধাৰ্মিকৰ প্ৰাণ লোৱা এনে কৰ্ম আপোনাৰ পৰা দূৰ হওক; সমুদায় পৃথিৱীৰ বিচাৰকর্তাজনাই জানো ন্যায়-বিচাৰ নকৰিব?” ");
INSERT INTO asmfb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","তেতিয়া যিহোৱাই ক’লে, “যদি চদোম নগৰত পঞ্চাশ জনও ধাৰ্মিক লোক পাওঁ, তেন্তে তেওঁলোকৰ কাৰণে মই সেই গোটেই নগৰ খনকে ক্ষমা দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","অব্ৰাহামে উত্তৰ দি ক’লে, “চাওক, যদিও মই কেৱল ধুলি আৰু ছাঁই, তথাপিও মই প্ৰভুৰ লগত কথা ক’বলৈ সাহ কৰিছোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","যদি পঞ্চাশজন ধাৰ্মিক লোক নহৈ পাঁচজন কম হয় তেনেহলে কি সেই পাঁচজন কম হোৱাৰ কাৰণে গোটেইখন নগৰকে আপুনি বিনষ্ট কৰিব নে?” তেতিয়া তেওঁ ক’লে, “মই তাত পঞ্চল্লিশজনক পালেও বিনষ্ট নকৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","অব্রাহামে আকৌ তেওঁক ক’লে, “ধৰক, যদি তাত মাত্র চল্লিশজন ধার্মিক লোকক পোৱা গ’ল!” তেওঁ ক’লে, “সেই চল্লিশজনৰ কাৰণেও মই বিনষ্ট নকৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","তেতিয়া অব্রাহামে ক’লে, “মোৰ প্ৰভুৱে যেন ক্ৰোধ নকৰে, মই পুনৰ কওঁ যদি তাত ত্ৰিশজনকো পোৱা যায়?” তেওঁ ক’লে, “মই যদি তাত ত্ৰিশজনকো পাওঁ, তেতিয়াও বিনষ্ট নকৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","অব্রাহামে ক’লে, “চাওক, মই আকৌ এবাৰ সাহস কৰি প্ৰভুক কব বিচাৰিছোঁ! যদি তাত বিশজনক পোৱা যায়?” “বিশজনৰ কাৰণেও মই সেই নগৰ বিনষ্ট নকৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","অৱশেষত অব্রাহামে ক’লে, “প্ৰভুৱে যেন মোক ক্ৰোধ নকৰে; মই কেৱল আৰু এবাৰহে মাথেন কওঁ, তাত যদি দহজনকো পোৱা যায়?” তেতিয়া তেওঁ ক’লে, “সেই দহজনৰ কাৰণেও মই তাক বিনষ্ট নকৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","অব্ৰাহামৰ সৈতে কথোপকথন শেষ হোৱাৰ পাছত যিহোৱা নিজ বাটেদি সেই ঠাইৰ পৰা গুচি গ’ল আৰু অব্ৰাহামো নিজৰ ঘৰলৈ উভটি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","সেইদিনা সন্ধিয়া দুজন দূত চদোম নগৰলৈ আহিল। লোট তেতিয়া চদোম নগৰৰ প্রৱেশ দুৱাৰত বহি আছিল। তেওঁলোকক দেখা পাই লোটে উঠি সাক্ষাৎ কৰিবলৈ গ’ল আৰু মাটিত উবুৰি হৈ প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","তেওঁ ক’লে, “হে মোৰ প্ৰভুসকল, অনুগ্রহ কৰি আপোনালোকৰ এই দাসৰ ঘৰলৈ আহঁক আৰু ভৰি-হাত ধুই ৰাতিটো আজি ইয়াতে কটাওক। পুনৰ ৰাতিপুৱাতে উঠি নিজ বাটেদি গুচি যাব।” তেতিয়া তেওঁলোকে ক’লে, “নহয়, ৰাতিটো আমি নগৰৰ চকতেই থাকিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","কিন্তু বৰকৈ জোৰ কৰিবলৈ ধৰাত, তেওঁলোক লোটৰ লগত গৈ তেওঁৰ ঘৰত সোমাল; লোটে তেওঁলোকৰ কাৰণে খমীৰ নিদিয়া পিঠা সেকি এসাঁজ আহাৰ যুগুত কৰিলে আৰু তেওঁলোকক খাবলৈ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","কিন্তু তেওঁলোকে শুবলৈ যোৱাৰ আগতে নগৰৰ লোকসকলে অৰ্থাৎ চদোমৰ ল’ৰা-বৃদ্ধ আদি কৰি সকলো লোক নগৰৰ চাৰিওফালৰ পৰা আহি ঘৰটো বেৰি ধৰিলেহি। ");
INSERT INTO asmfb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","তেওঁলোকে লোটক মাতি ক’লে, “আজি ৰাতি যি কেইজন লোক তোমাৰ ইয়াত সোমাল, তেওঁলোক ক’ত আছে? তেওঁলোকক আমাৰ ওচৰলৈ উলিয়াই আনা; আমি সিহঁতৰ পৰিচয় লওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","তেতিয়া লোটে দুৱাৰৰ বাহিৰত ওলাই গৈ দুৱাৰখন জপাই ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“হে ভাইসকল, মই বিনয় কৰিছোঁ, আপোনালোকে এনে কু-আচৰণ নকৰিব; ");
INSERT INTO asmfb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","চাওঁক, মোৰ দুজনী ছোৱালী আছে; কোনো পুৰুষৰ সৈতে সিহঁতৰ সংস্পৰ্শ হোৱা নাই; সিহঁতকে মই আপোনালোকৰ ওচৰলৈ উলিয়াই আনো; সিহঁতৰ লগত আপোনালোকে যি ভাল দেখে কৰক; কেৱল এই লোকসকলক একো নকৰিব; কিয়নো তেওঁলোকে এতিয়া মোৰ ঘৰৰ ছাঁত আশ্ৰয় লৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","তেতিয়া তেওঁলোকে ক’লে, “যোৱা, আমাৰ পথৰ পৰা আঁতৰ হৈ যোৱা!” তেওঁলোকে আকৌ ক’লে, “এইজন বিদেশী হিচাবে আমাৰ ইয়ালৈ আহিছিল আৰু এতিয়া আমাৰে বিচাৰক হ’বলৈ গৈছে। এতিয়া আমি সিহঁততকৈ তোৰ লগত আৰু বেয়া আচৰণ কৰিম।” এই বুলি কৈ লোকসকলে সেই মানুহৰ বিৰুদ্ধে আগবঢ়িল আৰু লোটক ঠেলা মাৰি দুৱাৰ ভাঙিবলৈ কাষ চাপি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","তেতিয়া সেই দুজন পুৰুষে হাত মেলি লোটক ঘৰৰ ভিতৰলৈ টানি নিলে আৰু ভিতৰৰ পৰা দুৱাৰ বন্ধ কৰি দিলে; ");
INSERT INTO asmfb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","তাৰ পাছত লোটৰ অতিথিসকলে ঘৰৰ দুৱাৰৰ বাহিৰত থকা সৰু বৰ সকলো মানুহকে আঘাত কৰি কণা কৰিলে; তাতে সেই মানুহবোৰে দুৱাৰ বিচাৰি বিচাৰি হাবাথুৰি খালে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","তাৰ পাছত সেই লোক দুজনে লোটক সুধিলে, “এই ঠাইত তোমাৰ আৰু কোনোবা আছে নেকি? তোমাৰ জোঁৱাই, পো, জী বা কোনো আত্মীয়-স্বজন আদি কৰি যিসকল লোক এই নগৰত আছে, সেই সকলোকে এই ঠাইৰ পৰা উলিয়াই লৈ যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","কিয়নো আমি এই নগৰ ধ্বংস কৰিবৰ কাৰণে যুগুত হৈছোঁ। যিহোৱাৰ আগত এই ঠাইৰ লোকসকলৰ বিৰুদ্ধে ভীষণ হৈ চৈ হৈছে আৰু সেইবাবে তেওঁ তাক ধ্বংস কৰিবলৈ আমাক পঠাইছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","তেতিয়া লোটে বাহিৰলৈ গৈ তেওঁৰ হবলগীয়া জোৱাঁইসকলক ক’লে, “সোনকাল কৰা! এতিয়াই এই ঠাই এৰি গুছি যোৱা; কিয়নো যিহোৱাই এই নগৰ ধ্বংস কৰিবলৈ যুগুত হৈছে।” কিন্তু জোঁৱায়েকহঁতে ভাৱিলে, তেওঁ ধেমালি কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","তাৰ পাছত ৰাতিপুৱা সেই দুজন দূতে লোটক সোনকাল কৰিবলৈ দিলে আৰু ক’লে, “ইয়াত থকা তোমাৰ ভার্য্যা আৰু দুজনী জীয়ৰীক লৈ গৈ থাকা; তেতিয়াহে নগৰৰ লগত তোমালোকক এই শাস্তিত ধ্বংস কৰা নহ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","লোটে সংকোচ কৰি পলম কৰিবলৈ ধৰিলে। কিন্তু যিহোৱাৰ দয়া তেওঁৰ ওপৰত থকা কাৰণে সেই পুৰুষ দুজনে তেওঁক, তেওঁৰ ভার্য্যাক আৰু দুজনী জীয়েককো হাতত ধৰি টানি নগৰৰ বাহিৰলৈ উলিয়াই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","সকলোকে বাহিৰ কৰি অনাৰ পাছত তেওঁলোকৰ এজনে লোটক ক’লে, “প্ৰাণ বচাবলৈ হ’লে পলোৱা! পাছলৈ ঘূৰি নাচাবা আৰু এই সমভূমিৰ কোনো ঠাইতে নৰখিবা; পাহাৰটোলৈ পলাই যোৱা; নহ’লে তোমালোকো বিনষ্ট হ’বা।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","তেতিয়া লোটে তেওঁলোকক ক’লে, “নহয়, হে মোৰ প্ৰভু, তেনে নকব! ");
INSERT INTO asmfb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","চাওঁক, আপোনালোকৰ দৃষ্টিত আপোনালোকৰ এই দাসে অনুগ্ৰহ পাইছো আৰু মোৰ জীৱন ৰক্ষা কৰাত আপোনালোকে মোলৈ দয়াও দেখুৱালে; কিন্তু মই পাহাৰটোলৈ পলাই যাব নোৱাৰোঁ; কিয়নো মই গৈ পোৱাৰ আগেয়ে হয়তো সেই বিপদ আহি পৰিব আৰু মই মৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","চাওঁক, পলাই যাবলৈ হ’লে যথেষ্ট কাষতে সেইখন সৰু চহৰ আছে। প্রাণ ৰক্ষাৰ বাবে মোক তালৈকে পলাই যাবলৈ দিয়ক। ই জানো সৰু নহয়? তাতেই মোৰ প্ৰাণ ৰক্ষা পৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","তেতিয়া দূতে ক’লে, “বাৰু, মই তোমাৰ এই অনুৰোধ ৰাখিলোঁ। যি চহৰখনৰ কথা তুমি ক’লা, তাক মই ধ্বংস নকৰোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","কিন্তু সোনকাল কৰা! বেগাই সেই ঠাইলৈকে পলোৱা; কিয়নো তুমি সেই ঠাই নোপোৱালৈকে, মই একো কৰিব নোৱাৰোঁ।” সেয়ে সেই চহৰখনৰ নাম হ’ল চোৱৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","লোটে যেতিয়া চোৱৰ গৈ পালে তেতিয়া সূৰ্য উদয় হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","তেনেতে যিহোৱাই আকাশৰ পৰা চদোম আৰু ঘমোৰাৰ ওপৰত গন্ধক আৰু অগ্নি বর্ষাবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","তেওঁ সেই নগৰকেইখন, গোটেই সমথল, নগৰৰ সকলো লোক আৰু ভূমিত গজা সকলো বস্তুকে বিনষ্ট কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","কিন্তু পাছত গৈ থকা লোটৰ ভার্য্যাই পাছফালে উভটি চালে, তাতে তেওঁ লোণৰ এটা স্তম্ভ হৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","অব্ৰাহামে অতি পুৱাতে উঠি যি ঠাইত পূৰ্বতে যিহোৱাৰ সন্মুখত থিয় হৈছিল, সেই ঠাইলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","তেওঁ তলৰ ফালে চদোম, ঘমোৰা আৰু গোটেই সমতল ভূমিলৈ চাই দেখিলে যে অগ্নিকুণ্ডৰ ধুঁৱাৰ দৰে সেই সকলো ঠাইৰ পৰা ধুঁৱা উঠিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","যেতিয়া ঈশ্বৰে সমথলৰ নগৰবোৰ বিনষ্ট কৰিলে, তেতিয়া ঈশ্বৰে অব্ৰাহামক সোঁৱৰণ কৰিলে; তেওঁ লোটে য’ত বাস কৰিছিল, সেই নগৰবোৰৰ ধ্বংসস্তূপৰ মাজৰ পৰা তেওঁক বাহিৰলৈ উলিয়াই পঠালে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","পাছত লোটৰ চোৱৰত থাকিবলৈ সাহস নহ’ল আৰু সেয়ে তেওঁ জীয়েক দুজনীক লগত লৈ চোৱৰৰ পৰা ওলাই পাহাৰত বাস কৰিবলৈ উঠি গ’ল; তাত তেওঁ জীয়েক দুজনীৰে সৈতে এটা গুহাত বাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","পাছত ডাঙৰ জীয়েকে সৰু জনীক ক’লে, “আমাৰ পিতৃ বৃদ্ধ হৈ গৈছে। এই এলেকাত এনে কোনো পুৰুষ নাই যেয়ে পৃথিৱীৰ নিয়ম অনুসাৰে আমাৰ লগত সম্বন্ধ কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","আহাঁ, আমি আমাৰ পিতৃক দ্ৰাক্ষাৰস পান কৰাই তেওঁৰ লগত শয়ন কৰোঁহক। তাতে আমি আমাৰ পিতৃৰ বংশ ৰক্ষা কৰিব পাৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","সেই কথা অনুসাৰে সেইদিনা ৰাতি তেওঁলোকে বাপেকক দ্ৰাক্ষাৰস পান কৰাই মতলীয়া কৰিলে। তাৰ পাছত ডাঙৰজনীয়ে সোমাই গৈ বাপেকৰ লগত শয়ন কৰিলে; কিন্তু কেতিয়া তাই শুলে আৰু কেতিয়ানো উঠি গ’ল লোটে গমকে নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","পাছদিনা ডাঙৰজনীয়ে সৰু জনীক ক’লে, “শুনা, যোৱাকালি ৰাতি মই পিতৃৰ লগত শয়ন কৰিলোঁ; আহাঁ আজি ৰাতিও আমি পিতৃক দ্ৰাক্ষাৰস পান কৰাওঁ আৰু তুমি সোমাই গৈ তেওঁৰ লগত শয়ন কৰিবা। তাতে পিতৃৰ পৰা আমি আমাৰ বংশ ৰক্ষা কৰিব পাৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","এইদৰে সেইদিনা ৰাতিও তেওঁলোকে নিজৰ বাপেকক দ্ৰাক্ষাৰস পান কৰালে আৰু সৰু জীয়েকে গৈ বাপেকৰ লগত শয়ন কৰিলে; কিন্তু কেতিয়া যে তেওঁৰ ওচৰত শুলে আৰু কেতিয়ানো উঠি গ’ল, তাক লোটে গম নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","এইদৰে লোটৰ দুয়ো জনী জীয়েক নিজ বাপেকৰ দ্বাৰা গৰ্ভৱতী হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","পাছত ডাঙৰজনীৰ এটি পুত্ৰ হ’ল আৰু তেওঁ তাৰ নাম মোৱাব ৰাখিলে; এই মোৱাবেই বর্তমানৰ মোৱাবীয়াহঁতৰ আদিপিতৃ। ");
INSERT INTO asmfb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","পাছত সৰুজনীয়েও এটি পুত্ৰ প্ৰসব কৰিলে আৰু তাৰ নাম বিন-অম্মি হ’ল; তেওঁ বর্তমানৰ অম্মোনীয়াহঁতৰ আদিপিতৃ। ");
INSERT INTO asmfb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","অব্ৰাহামে পূর্বৰ ঠাই এৰি নেগেভ দেশৰ ফালে গ’ল। তাত তেওঁ কাদেচ আৰু চূৰৰ মাজৰ এঠাইত থাকিবলৈ ল’লে; সেই গৰাৰ নগৰত তেওঁ প্ৰবাসী আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","তাত অব্ৰাহামে নিজৰ ভাৰ্যা চাৰাৰ বিষয়ে ক’লে, “এওঁ মোৰ ভনী।” সেয়ে সেই ঠাইৰ ৰজা অবীমেলকে মানুহ পঠাই চাৰাক লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","কিন্তু ৰাতি ঈশ্বৰে সপোনত অবীমেলকৰ ওচৰলৈ আহি ক’লে, “চোৱা, যি মহিলাগৰাকীক তুমি লৈ আনিছা, তেওঁৰ কাৰণে তোমাৰ মৃত্যু অনিবার্য। কিয়নো তেওঁ এজন পুৰুষৰ ভাৰ্যা।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","অবীমেলকে কিন্তু তেতিয়াও চাৰাৰ ওচৰলৈ যোৱা নাছিল; সেয়ে তেওঁ ক’লে, “হে প্ৰভু, অপৰাধ নকৰিলেও আপুনি এটা সৎ জাতিক সংহাৰ কৰিব নে? ");
INSERT INTO asmfb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","সেই লোকজনে জানো নিজেই মোক কোৱা নাছিল ‘তাই মোৰ ভনী’ বুলি? এনেকি সেই মহিলাগৰাকীয়েও কৈছিল, ‘তেওঁ মোৰ ককাই’ বুলি। মই মোৰ সৰল মনেৰে আৰু নির্দোষী হাতেৰেহে এই কাম কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","তেতিয়া ঈশ্বৰে সপোনত তেওঁক ক’লে, “হয়, মই জানো যে তুমি সৰল মনেৰেই এই কাম কৰিলা আৰু সেই কাৰণেই মোৰ অহিতে পাপ নকৰাকৈ তোমাক ৰাখিলোঁ; তেওঁক স্পৰ্শ কৰিবলৈ তোমাক নিদিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","গতিকে সেই পুৰুষৰ ভাৰ্যাক এতিয়া ওভটাই দিয়া; কিয়নো সেই লোকজন এজন ভাববাদী। তেওঁ তোমাৰ অৰ্থে প্ৰাৰ্থনা কৰিব আৰু তুমি জীবা। কিন্তু যদি তেওঁক উভটাই নিদিয়া, তেন্তে ইয়াকে জানিবা যে তুমি আৰু তোমাৰ লোকসকলৰ সকলোৰে অৱশ্যেই মৃত্যু হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","পাছদিনা অবীমেলকে অতি ৰাতিপুৱাতে উঠি নিজৰ দাসবোৰক ওচৰলৈ মাতি এই সকলো কথা ক’লে। এই কথা শুনি লোকসকলৰ অতিশয় ভয় লাগিল। ");
INSERT INTO asmfb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","তেতিয়া অবীমেলকে অব্ৰাহামক মাতি আনি ক’লে, “আপুনি আমাৰ লগত এইটো কি কাম কৰিলে? মইনো আপোনাৰ বিৰুদ্ধে কি দোষ কৰিলোঁ যে আপুনি মোক আৰু মোৰ ৰাজ্যক ইমান ডাঙৰ এক মহাপাপত পেলালে। মোলৈ এই ধৰণৰ ব্যৱহাৰ কৰা আপোনাৰ মুঠেই উচিত হোৱা নাই।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","অবীমেলকে অব্ৰাহামক পুনৰ ক’লে, “আপুনি কি ভাৱি এনে কাৰ্য কৰিলে?” ");
INSERT INTO asmfb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","তেতিয়া অব্ৰাহামে ক’লে, “মই ভাৱিছিলো, এই ঠাইৰ লোকসকলৰ ঈশ্বৰৰ প্রতি নিশ্চয়ে ভয়-ভীতি নাই; সেয়ে মোৰ ভার্য্যাক পাবলৈ তেওঁলোকে মোকেই বধ কৰিব’। ");
INSERT INTO asmfb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","তাৰ বাহিৰেও বাস্তৱিকত তেওঁ মোৰ ভনীও হয়; আমাৰ মাতৃ বেলেগ হ’লেও তেওঁৰ আৰু মোৰ পিতৃ একে। এতেকে তেওঁ মোৰ ভার্য্যা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ঈশ্বৰে যেতিয়া মোক মোৰ পিতৃৰ ঘৰ ত্যাগ কৰিবলৈ দিলে আৰু মোক এঠাইৰ পৰা আন ঠাইলৈ ভ্রমণ কৰাই লৈ ফুৰালে, তেতিয়া মই মোৰ ভার্য্যাক কৈছিলোঁ, ‘মোৰ ভার্য্যা হিচাবে তুমি মোলৈ এই বিশ্বস্ততা প্রকাশ কৰিবা: আমি যি ঠাইলৈকে যাম, তুমি মোক তোমাৰ ককাই বুলি পৰিচয় দিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","তাৰ পাছত অবীমেলকে কিছুমান মেৰ-ছাগ, গৰু আৰু দাস-দাসীক আনি অব্ৰাহামক দিলে আৰু তাৰ লগতে তেওঁৰ ভাৰ্যা চাৰাকো ওভটাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","অবীমেলকে ক’লে, “চোৱা, মোৰ দেশখনেই আপোনাৰ আগত আছে; আপোনাৰ যি ঠাইতে ভাল লাগে, তাতে নিগাজীকৈ থাকক।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","তেওঁ চাৰাকো ক’লে, “চোৱা, তোমাৰ ককায়েৰাক মই এক হাজাৰ ৰূপ দিছোঁ; ইয়েই তোমাৰ লগতে সকলো লোকৰ সন্মুখত তোমাৰ বিৰুদ্ধে হোৱা অপৰাধ ঢাকিবলৈ কৰা হৈছে। তোমাৰ কোনো দোষ নাই।” ");
INSERT INTO asmfb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","তাৰ পাছত অব্ৰাহামে ঈশ্বৰৰ আগত প্ৰাৰ্থনা কৰিলে। তেতিয়া অবীমেলক, তেওঁৰ ভাৰ্যা, আৰু তেওঁৰ আন আন দাসীসকলে যাতে সন্তান লাভ কৰিবলৈ সক্ষম হ’ব পাৰে, ঈশ্বৰে তেওঁলোকক সুস্থ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","কিয়নো যিহোৱাই অব্ৰাহামৰ ভাৰ্যা চাৰাৰ কাৰণে অবীমেলকৰ ঘৰত থকা সকলো মহিলাৰ সন্তান ধাৰণৰ ক্ষমতা সম্পূর্ণভাৱে বন্ধ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","যিহোৱাই নিজৰ কথাৰ দৰে চাৰালৈ অনুগ্ৰহ কৰিলে আৰু চাৰালৈ যি কৰিব বুলি কৈছিল তেওঁ তাক সিদ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","চাৰা গৰ্ভৱতী হ’ল। অব্ৰাহামৰ অতি বৃদ্ধ বয়সত চাৰাই তেওঁলৈ এটি পুত্ৰ প্ৰসৱ কৰিলে। ঈশ্বৰে প্রতিজ্ঞা কৰাৰ সময়তে সেই পুত্রৰ জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","অব্ৰাহামে চাৰাই প্রসৱ কৰা এই পুত্ৰৰ নাম “ইচহাক” ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ঈশ্বৰৰ আজ্ঞা অনুসাৰে অব্ৰাহামে আঠ দিনৰ দিনা নিজ পুত্ৰ ইচহাকৰ চুন্নৎ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","পুত্ৰ ইচহাকৰ জন্মৰ সময়ত অব্ৰাহামৰ বয়স হৈছিল এশ বছৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","চাৰাই ক’লে, “পূর্বে নিঃসন্তান হোৱাৰ বাবে যদিও মই দুখী আছিলোঁ, ঈশ্বৰে মোৰ মুখত আনন্দৰ হাঁহি দিলে; তেওঁ যি কৰিলে সেই কথা শুনা প্রতিজনেও মোৰে সৈতে হাঁহিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","তেওঁ পুনৰ ক’লে, “ইয়াৰ আগতে কোনোৱে জানো অব্ৰাহামক ক’ব পাৰিলেহেঁতেন যে মই এদিন সন্তানক পিয়াহ খুৱাম? কিয়নো মই এতিয়া তেওঁৰ বুঢ়া কালত তেওঁলৈ এটি পুত্ৰ প্ৰসৱ কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ইচহাক ক্রমে ডাঙৰ হ’বলৈ ধৰিলে আৰু তেওঁৰ পিয়াহো এৰুৱালে। পিয়াহ এৰুৱাৰ দিনা অব্ৰাহামে এক বৰভোজ পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","এদিন চাৰাই দেখিলে যে হাগাৰৰ পুত্র ইশ্মায়েলে ইচহাকক ইতিকিং কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","তাকে দেখি চাৰাই অব্ৰাহামক ক’লে, “তুমি এই মিচৰীয়া দাসী আৰু তাইৰ পুতেকক খেদি দিয়া! মই নিবিচাৰোঁ যে আমাৰ ইচহাকৰ সৈতে সেই দাসীৰ পুত্র উত্তৰাধিকাৰৰ ভাগী হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","পুত্র ইশ্মায়েলৰ বিষয়ে এই কথা শুনি অব্ৰাহামে মনত অতিশয় বেজাৰ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","কিন্তু ঈশ্বৰে অব্ৰাহামক ক’লে, “তোমাৰ ল’ৰা ইশ্মায়েল কাৰণে আৰু তোমাৰ দাসীৰ কথা ভাৱি মনত বেজাৰ নকৰিবা। চাৰাই কোৱা কথাবোৰ শুনি তুমি সেইদৰে কার্য কৰা; কিয়নো ইচহাকৰ দ্বাৰায়েই তোমাৰ বংশধৰসকলৰ নামাকৰণ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","সেই দাসীৰ পুত্রৰ যোগেদিও মই এক জাতি উৎপন্ন কৰিম, কাৰণ তেৱোঁ তোমাৰেই বংশৰধৰ।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","পিছদিনা অব্ৰাহামে নিচেই পুৱাতে উঠি কিছু পিঠা আৰু ছালেৰে তৈয়াৰী পানী ভৰা এটা মোনা লৈ হাগাৰৰ কান্ধত তুলি দিলে। তাৰ পাছত ইশ্মায়েলকো শোধাই দি তেওঁলোক দুয়োকো বিদায় দিলে; পাছত দুয়ো আঁতৰি গ’ল আৰু বেৰ-চেবাৰ মৰুপ্রান্তৰত ভ্ৰমি ফুৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","যেতিয়া ছালৰ মোনাৰ পানী শেষ হৈ গ’ল, তেতিয়া হাগাৰে ল’ৰাটোক এটা জোপোহাৰ তলত শুৱাই হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","তাৰ পাছত অলপ আতঁৰতে, প্রায় এটা কাঁড় মাৰিলে যোৱা দূৰত্বমানলৈ গৈ হাগাৰ বহি থাকিল। “ল’ৰাৰ মৃত্যু মই চকুৰে চাই থাকিব নোৱাৰো,” বুলি কৈ তেওঁ তাতে বহি উচুপি উচুপি কান্দিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ল’ৰাটিৰ কান্দোন ঈশ্বৰৰ কাণত পৰাত ঈশ্বৰৰ দূতে আকাশৰ পৰা হাগাৰক মাত দিলে; দূতে ক’লে, “হাগাৰ, তোমাৰ কি হৈছে? ভয় নকৰিবা; কিয়নো তাত পৰি থকা তোমাৰ ল’ৰাৰ কান্দোন ঈশ্বৰে শুনা পাইছে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","তুমি উঠা আৰু ল’ৰাটিক তুলি লৈ শান্ত কৰাত সহায় কৰা; কিয়নো মই তেওঁৰ যোগেদি এক মহাজাতি উৎপন্ন কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","তাৰ পাছতে ঈশ্বৰে হাগাৰৰ চকু মুকলি কৰাত তেওঁ এটা কুৱাঁ দেখা পালে; তেতিয়া হাগাৰে সেই কুৱাঁৰ কাষলৈ গৈ নিজৰ ছালৰ মোনাটোত পানী ভৰাই ল’ৰাক পান কৰালে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ঈশ্বৰ সেই ল’ৰাৰ লগত থাকিল আৰু তেওঁ ডাঙৰ হ’বলৈ ধৰিলে। তেওঁ মৰুপ্রান্তৰত বাস কৰিলে আৰু এজন ধনুৰ্দ্ধৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","পাৰণ নামৰ এক মৰুপ্রান্তৰত তেওঁ বসতি কৰিবলৈ ধৰিলে; পাছত মিচৰ দেশৰ এজনী ছোৱালীক তেওঁৰ বাবে ভার্য্যা কৰি মাকে বিয়া পাতি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","সেই সময়ত অবীমেলক আৰু তেওঁৰ সৈন্যদলৰ সেনাপতি ফীখোলে অব্ৰাহামৰ ওচৰলৈ আহি ক’লে, “আপোনাৰ সকলো কাৰ্যতে ঈশ্বৰ আপোনাৰ সংগত আছে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","সেইবাবে ঈশ্বৰৰ নামত আপুনি এতিয়া মোৰ ওচৰত এই শপত খাওঁক যে, মোৰ অথবা মোৰ সন্তান সকলৰ সৈতে নাইবা মোৰ বংশধৰসকলৰ কাৰো লগত আপুনি ছলনাৰ কার্য নকৰিব। মই যেনেকৈ আপোনাৰ প্রতি বিশ্বস্ততাৰে ব্যৱহাৰ কৰিছোঁ, ঠিক তেনেকৈ আপুনিও মোৰ সৈতে আৰু যি দেশত আপুনি বাস কৰি আছে, সেই দেশৰ প্রতিও বিশ্বস্ততাৰে ব্যৱহাৰ কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","অব্ৰাহামে ক’লে, “হয়, মই শপত খাইছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","কিন্তু তেওঁ এটা কুৱাঁৰ বিষয়ে অভিযোগ কৰি অবীমেলকক ক’লে যে অবীমেলকৰ দাসবোৰে সেইটো বলেৰে তেওঁৰ পৰা অধিকাৰ কৰি লৈছে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","তেতিয়া অবীমেলকে ক’লে, “এই কাম কোনে কৰিলে তাক মই নাজানো; এই কথা আগেয়ে আপুনি মোক জনোৱাও নাই। মই আজিলৈকে এই কথা শুনা নাছিলো, এতিয়াহে শুনিলো।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","তাৰ পাছত অব্ৰাহামে কিছুমান মেৰ-ছাগ আৰু গৰু আনি অবীমেলকক দিলে আৰু দুয়োজনে এক চুক্তি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","পাছত অব্ৰাহামে নিজৰ মেৰ-ছাগৰ জাকৰ পৰা সাতজনী মাইকী মেৰ-ছাগৰ পোৱালি বেলেগ কৰি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","তাকে দেখি অবীমেলকে অব্ৰাহামক সুধিলে, “আপুনি এই সাতজনী মাইকী মেৰ-ছাগৰ পোৱালি বেলেগে যে থৈছে, তাৰ কাৰণটো কি?” ");
INSERT INTO asmfb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","তেওঁ ক’লে, “আপুনি মোৰ হাতৰ পৰা এইবোৰ গ্রহণ কৰিলেহে মোৰ বাবে ই প্রমাণিত হ’ব যে এই কুৱাঁটো মই খান্দিছিলো।” ");
INSERT INTO asmfb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","সেই ঠাইতে তেওঁলোক দুয়োয়ে এক শপত লোৱাৰ বাবে তেওঁ সেই ঠাইৰ নাম বেৰ-চেবা ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","এইদৰে তেওঁলোকে বেৰ-চেবাত চুক্তি কৰাৰ পাছত অবীমেলক আৰু তেওঁৰ সেনাপতি ফীখোল পলেষ্টীয়াসকলৰ দেশলৈ উভটি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","অব্ৰাহামে বেৰ-চেবাত যিহোৱা অর্থাৎ সেই অনন্তকালৰ ঈশ্বৰৰ নামেৰে প্রার্থনা কৰিলে। তেওঁ সেই ঠাইত এজোপা ঝাওঁ গছ ৰুলে। ");
INSERT INTO asmfb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","অব্ৰাহাম পলেষ্টীয়াসকলৰ দেশত বহুদিন ধৰি বিদেশীৰূপে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","এইবোৰ ঘটনাৰ পাছত ঈশ্বৰে অব্ৰাহামক পৰীক্ষা কৰিলে। ঈশ্বৰে তেওঁক “অব্ৰাহাম!” বুলি মতাত অব্রাহামে ক’লে, “এইয়া, মই আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","তেতিয়া ঈশ্বৰে ক’লে, “তুমি প্ৰেম কৰা তোমাৰ একমাত্র পুত্র ইচহাকক লৈ মোৰিয়া দেশলৈ যোৱা; তাত যি পাহাৰটোৰ কথা মই তোমাক কম, তাৰ ওপৰতে তুমি ল’ৰাক হোমবলিৰূপে উৎসর্গ কৰাগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","সেয়ে, অব্ৰাহামে ৰাতিপুৱাতে উঠি নিজৰ গাধৰ পিঠিত আসন সজালে। তাৰ পাছত পুত্র ইচহাক আৰু দুজন যুবক দাসকো লগত ল’লে। তেওঁ হোমবলি উৎসর্গৰ কাৰণে কাঠো কাটি ল’লে আৰু ঈশ্বৰে যি ঠাইৰ কথা তেওঁক কৈছিল সেই ঠাইলৈ যাত্ৰা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","তিন দিনৰ দিনা অব্ৰাহামে চকু তুলি চাই দূৰৈৰ পৰাই সেই ঠাই দেখা পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","তেতিয়া অব্ৰাহামে নিজৰ দাস দুজনক ক’লে, “তোমালোক গাধটোৰে সৈতে ইয়াতে থাকা; মই আৰু মোৰ ল’ৰাই সেই ঠাইলৈকে যাওঁ; তাত আমাৰ প্রার্থনা শেষ কৰি তোমালোকৰ ওচৰলৈ পুনৰ উলটি আহিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","এইবুলি কৈ অব্ৰাহামে হোমবলিৰ কাঠখিনি তেওঁৰ পুত্ৰ ইচহাকৰ কান্ধত দি অগ্নি আৰু ছুৰীখন নিজৰ হাতত ল’লে। তাৰ পাছত তেওঁলোক দুয়ো একেলগে খোজকাঁঢ়ি যাবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","তেতিয়া ইচহাকে তেওঁৰ পিতৃ অব্ৰাহামক মাতিলে, “হে মোৰ পিতৃ।” তাতে অব্রাহামে ক’লে, “মোৰ বোপা, মই ইয়াতে আছোঁ।” সি ক’লে, “হোমবলি উৎসর্গৰ কাৰণে চাওঁক জুই আৰু কাঠ আছে, কিন্তু মেৰ-ছাগৰ পোৱালি ক’ত?” ");
INSERT INTO asmfb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","অব্ৰাহামে ক’লে, “বোপা, হোমবলিৰ কাৰণে ঈশ্বৰে নিজেই মেৰ-ছাগ পোৱালি যোগাব।” এইদৰে কথা পাতি পাতি তেওঁলোক দুয়ো একেলগে আগুৱাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","পাছত যি ঠাইৰ কথা ঈশ্বৰে অব্রাহামক কৈছিল, তেওঁলোকে গৈ সেই ঠাই পালে আৰু সেই ঠাইতে অব্ৰাহামে এটা যজ্ঞবেদি নির্ম্মাণ কৰি তাৰ ওপৰত কাঠ সজাই হ’ল। তাৰ পাছত নিজৰ পুত্ৰ ইচহাকক বান্ধি যজ্ঞবেদিৰ কাঠৰ ওপৰত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","তেতিয়া অব্ৰাহামে নিজ পুত্ৰক বধ কৰিবলৈ ছুৰীখন হাতত ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","তেনে সময়তে আকাশৰ পৰা যিহোৱাৰ দূতে তেওঁক মাতি ক’লে, “অব্ৰাহাম, অব্ৰাহাম!” তেওঁ ক’লে, “এইয়া মই আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","দূতে ক’লে, “তুমি ল’ৰাটোৰ গাত হাত নিদিবা আৰু তাৰ একো হানি নকৰিবা; কিয়নো তুমি যে ঈশ্বৰৰ ভয়কাৰী লোক, সেই বিষয়ে মই এতিয়া জানিছোঁ; কাৰণ তুমি তোমাৰ একেটি পুত্ৰকো মোৰ বাবে বলি দিবলৈ অসন্মত নহলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","তেতিয়া অব্ৰাহামে চকু তুলি চাই নিজৰ পাছফালে এটা মতা মেৰ-ছাগক দেখা পালে আৰু তাৰ শিংকেইটা জোপোহাৰ মাজত জপটিয়াই লাগি আছিল। অব্ৰাহামে গৈ সেই মেৰ-ছাগটো আনি নিজৰ পুত্ৰৰ সলনি তাকে হোমবলি উৎসর্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","তাৰবাবে অব্ৰাহামে সেই ঠাইৰ নাম যিহোৱা-যিৰি ৰাখিলে; সেয়ে আজিও লোকে এইবুলি কয়, “যিহোৱাৰ পাহাৰত যিহোৱায়ে যোগাই দিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","পাছত ঈশ্বৰৰ দূতে আকাশৰ পৰা পুনৰ মাত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","তেওঁ ক’লে, “যিহোৱাই এই কথা কৈছে, ‘তুমি তোমাৰ পুত্র, একেটি পুত্রকো মোৰ বাবে বলিদান দিবলৈ অসন্মত নহলে আৰু যিহেতু তুমি এই কার্য কৰিলা, সেয়ে মই নিজ নামেৰে শপত খাই কৈছো যে, ");
INSERT INTO asmfb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","মই নিশ্চয় তোমাক আশীৰ্ব্বাদ কৰিম; আকাশৰ তৰাবোৰৰ দৰে আৰু সাগৰৰ তীৰত থকা বালিৰ দৰে তোমাৰ বংশ অতিশয় ৰূপে বৃদ্ধি কৰিম; তোমাৰ বংশৰ লোকসকলে তেওঁলোকৰ শত্রুবোৰৰ নগৰৰ দুৱাৰ জয় কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","তোমাৰ বংশৰ যোগেদিয়েই পৃথিৱীৰ সমুদায় জাতি আশীৰ্ব্বাদ প্ৰাপ্ত হ’ব; তুমি মোৰ কথা পালন কৰিলা বাবেই তেনে হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","পাছত অব্ৰাহাম নিজৰ দাসবোৰৰ ওচৰলৈ উভটি আহিল আৰু সকলো একেলগে বেৰ-চেবালৈ ঘূৰি গ’ল; এই বেৰ-চেবাতে অব্ৰাহামে বাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","এইবোৰ ঘটনাৰ পাছত অব্ৰাহামে এই কথা শুনিবলৈ পালে, “তোমাৰ ককাই নাহোৰৰ ভার্য্যা মিল্কাৰো সতি-সন্ততিৰ জন্ম হ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","তেওঁলোক হ’ল তেওঁৰ বৰ পুতেক উচ; তাৰ পাছত ভায়েক বুজ আৰু কমৱেলৰ জন্ম হ’ল। কমৱেলৰ পুত্রৰ নাম আছিল অৰাম। ");
INSERT INTO asmfb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","অন্যান্য সন্তান সকল কেচদ, হজো, পিলদচ, ফিদলফ, আৰু বথোৱেল। ");
INSERT INTO asmfb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","এই বথোৱেলৰ ছোৱালীৰ নাম ৰিবেকা আছিল। মিল্কাই অব্ৰাহামৰ ককায়েক নাহোৰলৈ এই আঠজনক প্ৰসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","নাহোৰৰ এগৰাকী উপপত্নী আছিল। তাইৰ নাম আছিল ৰোমা। তাই টেবহ, গহম, তহচ, আৰু মাখা এইসকলক প্ৰসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","চাৰা এশ সাতাইশ বছৰ কাল জীয়াই আছিল। এয়ে আছিল চাৰাৰ জীৱনৰ আয়ুসৰ কাল। ");
INSERT INTO asmfb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","কনান দেশৰ কিৰিয়ৎ-অর্ব্ব নগৰত অর্থাৎ হিব্ৰোণত তেওঁৰ মৃত্যু হ’ল; তাতে অব্ৰাহামে চাৰাৰ কাৰণে কান্দি কান্দি শোক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","পাছত অব্ৰাহামে তেওঁৰ মৃত ভার্য্যাৰ ওচৰৰ পৰা উঠি গৈ সেই ঠাইৰ হেতৰ সন্তান সকলক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“মই আপোনালোকৰ মাজত এজন বিদেশী হিচাবে বাস কৰিছোঁ। সেয়ে, দয়া কৰি আপোনালোকৰ মাজৰ এডোখৰ স্থান আমাৰ অধিকাৰত দিয়ক যাতে মই মোৰ মৃতকক মৈদাম দিব পাৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","তেতিয়া হেতৰ সন্তান সকলে অব্ৰাহামক উত্তৰ দি ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“হে মালিক, আমাৰ কথা শুনক; আপুনি আমাৰ মাজত ঈশ্বৰৰ এজন নিযুক্ত ৰজা স্বৰূপ; আমাৰ মৈদামবোৰৰ আটাইতকৈ উত্তমটো নির্বাচন কৰি তাতেই আপোনাৰ মৃতকক মৈদাম দিয়ক। আপোনাৰ মৃতকক মৈদাম দিবৰ কাৰণে আমাৰ মাজৰ কোনেও নিজৰ মৈদামস্থান এৰি দিবলৈ আপত্তি নকৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","তেতিয়া অব্ৰাহামে উঠি সেই দেশৰ লোকসকলৰ অর্থাৎ হেতৰ বাসিন্দাসকলৰ আগত নতশিৰে প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","তেওঁলোকৰ সৈতে কথা-বতৰা হৈ ক’লে, “মোৰ মৃতকৰ মৈদাম দিবলৈ তোমালোক যে সন্মত হৈছা এই কাৰণে মোৰ কথা শুনা মোৰ হৈ চোহৰৰ পুত্র ইফ্রোণৰ সৈতে আলোচনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","পথাৰৰ মুৰত যিটো মকপেলাৰ গুহা আছে সেইটো মই কিনিবলৈ বিছাৰো, ইফ্রোণ সেই গুহাৰ গৰাকী সেয়ে যি মূল্য হয় সকলো মই পৰিশোধ কৰিম। মই বিছাৰো মোৰ পত্নীৰ মৈদামৰ বাবে যে এই ঠাই কিনি লৈছোঁ তাৰ সাক্ষী আপোনালোক হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","তেতিয়া হেতৰ সন্তান সকলৰ মাজত ইফ্রোণ বহি আছিল। হেতৰ সন্তান সকল আৰু নগৰৰ প্রৱেশ দুৱাৰেদি সোমোৱা সকলোৱে শুনাকৈ, হিত্তীয়া ইফ্ৰোণে অব্ৰাহামক উত্তৰ দি ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“নহয়, মোৰ মালিক, মোৰ কথা শুনক, পথাৰ খন মই আপোনাক দিছোঁ আৰু তাত থকা গুহাটো মই আপোনাক দিছোঁ; মই স্ব-জাতীয় সকলৰ সাক্ষাতেই আপোনাক দিছোঁ; যাতে আপোনাৰ ইচ্ছামতে নিজ পত্নীক মৈদাম দিয়ে।” ");
INSERT INTO asmfb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","তাতে অব্ৰাহামে সেই বাসিন্দাসকলৰ আগত নতশিৰে প্রণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","আৰু বাসিন্দাসকলে শুনাকৈ ইফ্রোণক ক’লে, কিন্তু “মই সেই মাটিৰ উচিত দাম আপোনাক দিবলৈ বিচাৰো। মই দিয়া দাম অনুগ্রহ কৰি আপুনি গ্রহণ কৰক, পাছত মই সেই ঠাইত মোৰ মৃত পত্নীক মৈদাম দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","তেতিয়া ইফ্রোণে অব্ৰাহামক উত্তৰ দি ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“হে মোৰ মালিক, মোৰ কথা শুনক, চাৰিশ চেকল ৰূপৰ মাটি; আপোনাৰ আৰু মোৰ মাজত সিনো কি বস্তু? এতেকে আপোনাৰ মৃতকৰ মৈদাম দিয়কগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","পাছত অব্ৰাহামে ইফ্রোণৰ কথাত মান্তি হৈ, হেতৰ সন্তান সকলে শুনাকৈ তেওঁ যি ৰূপৰ কথা কৈছিল, সেই চাৰি শ চেকল ৰূপ বণীয়াহঁতৰ দ্বাৰাই জুখি তেওঁক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","মম্ৰিৰ সন্মুখত মকপেলাত ইফ্রোণৰ যি পথাৰ আছিল, সেই পথাৰ আৰু তাত থকা গুহা আৰু সেই পথাৰৰ আটাইবোৰ গছ, তাৰ চাৰিও সীমাৰ ভিতৰত থকা গছ, এই সকলোতে, ");
INSERT INTO asmfb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","হেতৰ সন্তান সকল, তাৰ নগৰৰ দুৱাৰেদি সোমোৱা সকলোৰে আগতে অব্ৰাহামৰ স্বত্বাধিকাৰ নিশ্চয় কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","পাছে অব্ৰাহামে কনান দেশৰ মম্ৰিৰ অৰ্থাৎ হিব্ৰোণৰ সন্মুখত থকা মকপেলাৰ পথাৰৰ গুহাত তেওঁৰ ভাৰ্যা চাৰাক মৈদাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","এই দৰে মৈদামৰ ঠাই অধিকাৰৰ অৰ্থে, সেই পথাৰ আৰু তাত থকা গুহাত, হেতৰ সন্তান সকলৰ দ্বাৰাই অব্ৰাহামৰ স্বত্বাধিকাৰ স্থিৰ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","অব্ৰাহাম অতিশয় বৃদ্ধ অৱস্থালৈ জীয়াই আছিল। আৰু যিহোৱাই সকলোতে অব্ৰাহামক আশীৰ্ব্বাদ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","পাছত অব্ৰাহামে সকলো কাৰ্য পৰিচালনা কৰা ঘৰৰ বৃদ্ধ দাসক ক’লে, “বিনয় কৰোঁ, তুমি মোৰ কৰঙনৰ তলত হাত দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","মই তোমাক স্বর্গ আৰু পৃথিৱীৰ ঈশ্বৰ যিহোৱাৰ নামেৰে শপত দিছো। এই যি কনানীয়া লোকৰ মাজত বাস কৰিছোঁ, তুমি মোৰ পুত্ৰৰ বিয়াৰ বাবে ইহঁতৰ কোনো ছোৱালী নানিবা, ");
INSERT INTO asmfb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","তুমি মোৰ দেশত থকা জ্ঞাতিসকলৰ ওচৰলৈ গৈ মোৰ পুত্ৰ ইচহাকৰ বিয়াৰ বাবে ছোৱালী বিচাৰি ইয়ালৈ লৈ আনিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","তেতিয়া সেই দাসে তেওঁক ক’লে, “যদি কোনো ছোৱালী মোৰ লগত এই দেশলৈ আহিবলৈ মান্তি নহয়? পাছত আপুনি যি দেশৰ পৰা ওলাই আহিল, মই আপোনাৰ পুত্ৰক লৈ আকৌ সেই দেশলৈ যাম নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","অব্ৰাহামে তেওঁক ক’লে, “সাৱধান হোৱা, তুমি মোৰ পুত্ৰক সেই দেশলৈ কেতিয়াও ওলোটাই নিনিবা! ");
INSERT INTO asmfb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","স্বর্গৰ প্রভু স্বয়ং ঈশ্বৰ যিহোৱাই মোৰ পিতৃৰ জন্মভূমিৰ পৰা মোক সপৰিয়ালে সৈতে ইয়ালৈ লৈ আহিল আৰু মই তোমাৰ বংশক এই দেশ দিম বুলি মোৰ আগত শপত কৰিলে, স্বৰ্গৰ ঈশ্বৰ যিহোৱাই তোমাৰ আগে আগে নিজ দূত পঠাই দিব; তাতে তুমি মোৰ পুত্ৰৰ নিমিত্তে সেই ঠাইৰ পৰাই ছোৱালী আনিব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","যদি কোনো ছোৱালী তোমাৰ লগত আহিবলৈ মান্তি নহয়, তেন্তে তুমি এই শপতৰ পৰা মুক্ত হ’বা; কিন্তু মোৰ পুত্ৰক হ’লে তালৈ পুনৰাই নিনিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","তাতে, সেই দাসে নিজ প্ৰভু অব্ৰাহামৰ কৰঙনৰ তলত হাত দি, সেই বিষয়ে তেওঁৰ আগত শপত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","পাছত সেই দাসে নিজ প্ৰভুৰ উটবোৰৰ মাজৰ দহোটা উট লগত ল’লে; আৰু নিজ প্ৰভুৰ পৰা সকলো ধৰণৰ উত্তম উত্তম বস্তুৰ অলপ লৈ সেই ঠাইৰ পৰা অৰাম-নহৰিয়মৰ নাহোৰ নগৰৰ ওচৰ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","তাতে তেওঁ নগৰৰ বাহিৰত থকা কুৱাঁৰ ওচৰলৈ গ’ল। তাতে গধূলি সময়ত মহিলাসকল ওলাই কুৱাঁৰ পানী তুলিবলৈ সেই ঠাইলৈ আহে। তেওঁ তাতেই উটবোৰক আঠুকঢ়াই বহাই থ’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","তেতিয়া সেই দাসে ক’লে, “হে মোৰ প্ৰভু অব্ৰাহামৰ ঈশ্বৰ যিহোৱা, মই বিনয় কৰোঁ, আজি মোক সহায় কৰি সফল কৰক। মোৰ প্ৰভু, অব্ৰাহামৰ পুত্রৰ বাবে এগৰাকী যোগ্য পাত্ৰী বাচিবলৈ সহায় কৰক। অনুগ্ৰহ কৰি মোৰ প্রভু অব্রাহমক এই দয়া কৰক। ");
INSERT INTO asmfb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","চাওকচোন, মই এই ভুমুকৰ ওচৰত থিয় হৈ আছোঁ; পাছত সেই নগৰীয়া মানুহৰ ছোৱালীবোৰ পানী তুলিবলৈ ওলাই আহিব। ");
INSERT INTO asmfb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ইচহাকৰ বাবে যি গৰাকী যোগ্য হ’ব তেওঁ যদি আমাক কলহ নমাই পানী খাবলৈ দিয়ে। তেতিয়া ‘বিনয় কৰোঁ তুমি কলহ নমাই মোক পানী খাবলৈ দিয়া’, এই কথা মই যি ছোৱালীক ক’ম, সেই ছোৱালীয়ে যদি কয়, ‘খাওক আৰু আপোনাৰ উটবোৰকো খুৱাওঁক’, তেন্তে সেই ছোৱালী জনীয়েই আপোনাৰ দাস ইচহাকৰ কাৰণে আপোনাৰ নিৰূপিত কন্যা হওক; আৰু ইয়াৰ দ্বাৰাই যে মোৰ প্ৰভুলৈ আপুনি দয়া কৰিছে, সেই বিষয়ে মই জানিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","পাছত তেওঁ প্রার্থনা শেষ কৰাৰ আগতে, ৰিবেকাই কান্ধত কলহ লৈ বাহিৰলৈ ওলাই আহিল। ৰিবেকা অব্ৰাহামৰ ভাই নাহোৰৰ ভার্যা মিল্কাৰ পুতেক বথোৱেলৰ জীয়েক। ");
INSERT INTO asmfb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","সেই যুৱতী দেখাত পৰম সুন্দৰী আৰু কোনো পুৰুষৰ সৈতে সংস্পর্শ নথকা কুমাৰী আছিল। তাই ভুমুকলৈ নামি কলহ ভৰাই উঠি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","এনেতে, দাসজনে লৰি গৈ, তাইৰে সৈতে সাক্ষাত কৰি ক’লে, “বিনয় কৰোঁ, তোমাৰ কলহৰ পৰা মোক অলপমান পানী খাবলৈ দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","তাতে তাই ক’লে, “আপুনি খাওঁক,” এই বুলি তাই হাতত লৈ অহা কলহটো নমাই থলে আৰু সেই দাসক পানী খাবলৈ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","এনেদৰে পানী খুৱাই অঁতোৱাৰ পাছত তাই ক’লে, “আৰু আপোনাৰ উটবোৰেও পানী খাই নুঠালৈকে মই সিহঁতলৈকো তুলিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","এই বুলি তাই বেগতে ঘোলনিত কলহৰ পানী বাকি দি, আকৌ পানী তুলিবলৈ কুৱাঁলৈ গৈ, উটবোৰলৈ পানী তুলি দি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","তাতে সেই দাসে তাইৰ সকলো কর্ম নীৰৱে লক্ষ্য কৰি আছিল। তেওঁ নিশ্চিত হ’ব বিচাৰিছিল যে যিহোৱাই তেওঁৰ যাত্রা সফল কৰিছে নে নাই। ");
INSERT INTO asmfb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","উটবোৰে পানী খাই শেষ কৰাৰ পাছত, সেই দাসজনে আধা চেকল সোণৰ এটা নথ আৰু হাতৰ কাৰণে দহ চেকল সোণৰ এযোৰ খাৰু লৈ তাইক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“কোৱাচোন তুমি কাৰ জীয়েক? বিনয় কৰোঁ, এই ৰাতি থাকিবলৈ তোমাৰ পিতৃৰ ঘৰত আমাৰ বাবে ঠাই হ’ব নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","তেতিয়া তাই ক’লে, “মই নাহোৰ আৰু মিল্কাৰ পুত্র বথোৱেলৰ জীয়েক।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","তাই তেওঁক আৰু ক’লে, “আমাৰ তাত খেৰ আৰু দানা বহুত আছে ৰাতি থাকিবলৈ কোঁঠালিও আছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","তেতিয়া সেই দাসজনে মূৰ দোঁৱালে আৰু যিহোৱাৰ আগত প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","তেওঁ ক’লে “মোৰ প্রভু অব্ৰাহামৰ ঈশ্বৰ যিহোৱা ধন্য; মোৰ প্ৰভুৰ প্রতি তেওঁ বিশ্বস্ততা আৰু বিশ্বাসযোগ্যতা এতিয়ালৈ ত্যাগ কৰা নাই। এইদৰে মোক যিহোৱাই স্পষ্টভাৱে বাট দেখুৱাই মোৰ প্রভুৰ আত্মীয়ৰ ঘৰলৈ লৈ আনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","পাছত সেই ছোৱালীজনী বেগাই ঘৰলৈ গ’ল আৰু মাকৰ লগতে ঘৰৰ সকলোকে এই সকলো কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ৰিবেকাৰ লাবন নামেৰে এজন ককায়েক আছিল; তেতিয়া লাবনে বেগাই সেই ভুমুকৰ ওচৰত থকা সেই পুৰুষজনৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","তেওঁ যেতিয়া ভনীয়েকৰ হাতত খাৰু আৰু নথ দেখিলে আৰু নিজৰ ভনী ৰিবেকাৰ মুখেৰে যেতিয়া “তেওঁ এই কথা ক’লে,” বুলি শুনিলে, তেতিয়া তেওঁ সেই পুৰুষজনৰ ওচৰলৈ গ’ল। সেই পুৰুষজন তেতিয়া উটবোৰৰ সৈতে পানীৰ ভুমুকটোৰ ওচৰত থিয় হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","লাবনে ক’লে, “আপুনি যিহোৱাৰ আশীৰ্ব্বাদপ্ৰাপ্ত লোক, আহঁক; বাহিৰত কিয় এনেদৰে থিয় হৈ আছে? মই আপোনাৰ বাবে ঘৰ আৰু উটবোৰলৈয়ো ঠাই যুগুত কৰিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","তেতিয়া পুৰুষজন গৈ সেই ঘৰত সোমাল। উটবোৰৰ পৰা বোজাবোৰ নমালে আৰু খাবলৈ খেৰ আৰু দানা দিলে। তাৰ পাছত তেওঁক আৰু তেওঁৰ লগত যোৱা লোকসকলক ভৰি ধুবলৈ পানী দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","পাছত তেওঁলোকৰ আগত খাবলৈ আহাৰ যুগুত কৰি দিলে; কিন্তু তেওঁ খাবলৈ সন্মত নহ’ল। তেওঁ ক’লে, “মোৰ ক’বলগীয়া কথা নোকোৱালৈকে মই আহাৰ গ্রহণ নকৰোঁ।” তেতিয়া লাবনে ক’লে, “তেনেহ’লে কওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","তেতিয়া তেওঁ ক’লে, “মই অব্ৰাহামৰ দাস। ");
INSERT INTO asmfb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","যিহোৱাই মোৰ প্ৰভুক অতিশয়ৰূপে আশীৰ্ব্বাদ কৰিছে আৰু এতিয়া এজন মহান ব্যক্তি। যিহোৱাই তেওঁক মেৰ-ছাগ, ছাগলী আৰু গৰুৰ জাক, ৰূপ আৰু সোণ, দাস-দাসী, উট, গাধ এই সকলো দিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","চাৰা, মোৰ প্রভুৰ ভার্য্যাই বৃদ্ধ কালত মোৰ প্ৰভুলৈ এটি পুত্ৰ সন্তান প্ৰসৱ কৰিলে আৰু তেওঁকেই তেওঁ নিজৰ সকলোখিনি দিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","মোৰ প্ৰভুৱে শপত খুৱাই মোক কৈছিল যে, ‘মই যি কনান দেশত বাস কৰিছোঁ, তুমি মোৰ পুত্রৰ ভার্য্যাৰূপে এই দেশৰ কোনো কনানীয়া লোকৰ ছোৱালীক নানিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ইয়াৰ পৰিবর্তে, মোৰ পিতৃৰ আৰু মোৰ আত্মীয়সকলৰ পৰিয়াললৈ যোৱা আৰু মোৰ পুত্রৰ বাবে এগৰাকী ভার্য্যা লৈ আহাঁ’। ");
INSERT INTO asmfb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","মই মোৰ প্ৰভুক ক’লোঁ, ‘সম্ভৱতঃ ছোৱালীয়ে যদি মোক অনুসৰণ নকৰে’। ");
INSERT INTO asmfb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","কিন্তু তেওঁ মোক ক’লে, ‘যিজনৰ সাক্ষাতত মই জীৱন-যাপন কৰি আছোঁ, সেইজনা যিহোৱাই তোমাৰ সৈতে যাবৰ বাবে তেওঁৰ দূত পঠিয়াই দিব, আৰু তোমাৰ পথ উন্নত কৰিব; তাতে তুমি মোৰ পুত্রৰ বাবে মোৰ আত্মীয়সকলৰ আৰু মোৰ পিতৃৰ বংশৰ পৰা ভার্য্যা আনিব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","কিন্তু তুমি যদি মোৰ আত্মীয়সকলৰ ওচৰলৈ যোৱা আৰু তেওঁলোকে যদি মোৰ পুত্ৰৰ বাবে ছোৱালী দিবলৈ অস্বীকাৰ কৰে, তেনেহলে তুমি মোৰ এই শপতৰ পৰা মুক্ত হ’বা’। ");
INSERT INTO asmfb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","সেয়ে মই আজি এই পানীৰ ভুমুকৰ ওচৰ পালোঁ আৰু ক’লো, ‘হে যিহোৱা, মোৰ প্ৰভু অব্ৰাহামৰ ঈশ্বৰ; অনুৰোধ কৰোঁ, তুমি যদি মোৰ যাত্ৰা সফল কৰিবলৈ প্ৰকৃতপক্ষে মনস্থ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","তেনেহ’লে মই এই পানীৰ ভুমুকৰ ওচৰত থিয় হৈ আছোঁ; ইয়াতে পানী তুলিবলৈ অহা যিজনী ছোৱালীক ক’ম, ‘বিনয় কৰোঁ, তোমাৰ কলহৰ পৰা মোক পানী খাবলৈ দিয়া’। ");
INSERT INTO asmfb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","তাতে সেই ছোৱালীজনীয়ে যদি মোক কয়, ‘আপুনিও খাওঁক আৰু আপোনাৰ উটবোৰলৈকো পানী তুলি দিম’, তেনেহ’লে সেই ছোৱালীয়েই মোৰ প্ৰভুৰ পুত্ৰলৈ যিহোৱাই নিৰূপণ কৰা কন্যা হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","এই কথা মই মনতে ভাৱি শেষ নকৰোঁতেই, চাওক, ৰিবেকাই কান্ধত কলহ লৈ ওলাই আহিল আৰু পানী নিবৰ বাবে জলৰ ভুমুকৰ ওচৰ পালে। তাতে মই তেওঁক ক’লো, ‘অনুৰোধ কৰোঁ, মোক পানী খাবলৈ দিয়া’। ");
INSERT INTO asmfb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","তেতিয়া তেওঁ বেগতে কান্ধৰ পৰা কলহ নমাই থৈ ক’লে, ‘খাওঁক, মই আপোনাৰ উটবোৰকো খুৱাম’। তাতে মই খালো আৰু তেওঁ উটবোৰকো খুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","পাছত মই তেওঁক সুধিলোঁ, ‘তুমি কাৰ জীয়েক’? তেওঁ ক’লে, ‘মই বথোৱেলৰ জীয়েক; তেওঁ নাহোৰ আৰু মিল্কাৰ পুত্ৰ’। তেতিয়া মই তেওঁৰ নাকত সেই নথ আৰু হাতত সেই খাৰুও পিন্ধালোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","তেতিয়া মই মুৰ দোৱালো আৰু যিহোৱাৰ আৰাধনা কৰিলোঁ। ধন্য যিহোৱা, মোৰ প্ৰভু অব্ৰাহামৰ ঈশ্বৰ; মোৰ প্ৰভুৰ পুত্ৰৰ বাবে তেওঁৰ আত্মীয়ৰ পৰা কন্যা বিচাৰি আনিবলৈ তেওঁ মোক সঠিক পথত চলায় আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","এতিয়া মই কওঁ, ‘তুমি যদি মোৰ প্ৰভুৰ পৰিয়ালৰ সৈতে বিশ্বাসযোগ্য আৰু নিৰ্ভৰযোগ্য হ’বলৈ সন্মত হোৱা, তেনেহলে মোক কোৱা; কিন্তু যদি নহোৱা, তেনেহলেও মোক কোৱা, কিয়নো তেতিয়া মই সোঁফালে বা বাওঁফালে ঘূৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","তেতিয়া লাবন আৰু বথোৱেলে উত্তৰ দি ক’লে, “এই বিষয় যিহোৱাৰ পৰা আহিল; সেয়ে এই বিষয়টো ভাল বা বেয়া বুলি আমি তোমাক ক’ব নোৱাৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","চোৱা, ৰিবেকা তোমাৰ ওচৰতে আছে; তাইক লৈ যোৱা; যিহোৱাই কোৱাৰ দৰেই তাই তোমাৰ প্ৰভুৰ পুত্ৰৰ ভাৰ্যা হওক।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","যেতিয়া অব্ৰাহামৰ দাসে তেওঁলোকৰ কথা শুনিলে, তেতিয়া তেওঁ মাটিত আঠুকাঢ়ি যিহোৱাৰ আগত প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","পাছত সেই দাসে সোণ, ৰূপৰ অলংকাৰ আৰু বস্ত্র উলিয়াই ৰিবেকাক দিলে, আৰু তেওঁৰ ককায়েক আৰু মাককো বহুমূলীয়া উপহাৰ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","পাছত তাতে তেওঁ আৰু তেওঁৰ লগত অহা লোকসকলে ভোজন-পান কৰিলে আৰু ৰাতিটো থাকিল। তাতে ৰাতিপুৱা তেওঁলোক যেতিয়া উঠিল, তেতিয়া সেই দাসে ক’লে, “এতিয়া মোৰ প্ৰভুৰ ওচৰলৈ মোক যাবলৈ দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","তেতিয়া তেওঁৰ ককায়েক আৰু মাকে ক’লে, “আমাৰ লগত পুনৰ কিছু দিনলৈ কন্যাজনী থাকক; অতি কমেও দহ দিন মান থাকক। তাৰ পাছত তেওঁ যাব।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","কিন্তু তেওঁ তেওঁলোকক ক’লে, “যিহোৱাই মোৰ যাত্ৰা সফল কৰিছে; এতেকে মোক পলম কৰি নাৰাখিব; মই মোৰ প্ৰভুৰ ওচৰলৈ যাওঁ, মোক বিদায় দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","তেতিয়া তেওঁলোকে ক’লে, “আমি আমাৰ ছোৱালীক মাতি আনো আৰু তেওঁৰ মুখৰ কথা শুনো।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","তাৰ পাছত তেওঁলোকে ৰিবেকাক মাতি আনি সুধিলে, “তুমি এই জন মানুহৰ লগত যাবা নে?” তেতিয়া তেওঁ উত্তৰ দিলে, “হয়, মই যাম।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","তেতিয়া তেওঁ নিজ ভনী ৰিবেকা আৰু ৰিবেকাৰ আলপৈচান ধৰা দাসীগৰাকীক অব্ৰাহামৰ দাস আৰু তেওঁৰ সৈতে অহা লোকসকলৰ লগত যাত্রা কৰিবলৈ পঠিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","তেওঁলোকে ৰিবেকাক আশীৰ্ব্বাদ কৰিলে আৰু ক’লে, “হে আমাৰ ভনী, তুমি অযুত অযুত লোকৰ আদি-মাতৃ হোৱাগৈ, আৰু তোমাৰ বংশই তোমাক ঘৃণা কৰা লোকসকলৰ নগৰৰ দুৱাৰবোৰ অধিকাৰ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","তেতিয়া ৰিবেকা আৰু তেওঁৰ দাসীয়ে আহি উটত উঠিল আৰু সেই লোকজনক অনুসৰণ কৰিলে। তাতে সেই দাসে ৰিবেকাক লগত ল’লে আৰু তেওঁৰ পথত যাত্রা কৰিব ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","সেই সময়ত ইচহাকে নেগেভত বাস কৰিছিল, আৰু তেওঁ বেৰ-লহয়-ৰোৱীৰ পৰা উভতি আহিছিলহে মাত্র। ");
INSERT INTO asmfb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ইচহাকে সন্ধিয়া সময়ত কোনো বিষয় বিবেচনা কৰি পথাৰলৈ গৈছিল। তাতে তেওঁ যেতিয়া চকু তুলি চালে, তেতিয়া উটবোৰক আহি থকা দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","তাতে ইচহাকক যেতিয়া ৰিবেকাই দেখা পালে, তেতিয়া তেওঁ লগে লগে উটৰ পৰা নামিল। ");
INSERT INTO asmfb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","আৰু সেই দাসক তেওঁ সুধিলে, “আমাক সাক্ষাত কৰিবলৈ পথাৰৰ মাজেদি খোজকাঢ়ি আহি থকা সেইজন কোন?” সেই দাসে ক’লে, “এইজন মোৰ প্ৰভু।” তেতিয়া ৰিবেকাই ওৰণি ল’লে আৰু নিজকে ঢাকিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","পাছত সেই দাসে নিজে কৰা সকলো কাৰ্যৰ কথা ইচহাকক জনালে। ");
INSERT INTO asmfb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","তেতিয়া ইচহাকে নিজ মাতৃ চাৰাৰ তম্বুলৈ ৰিবেকাক লৈ গ’ল আৰু ইচহাকে তেওঁক গ্ৰহণ কৰিলে, তাতে ৰিবেকা তেওঁৰ ভাৰ্যা হ’ল। আৰু ইচহাকে তেওঁক প্ৰেম কৰিলে; তাতে তেওঁৰ মাতৃৰ মৰণৰ পাছত, তেওঁ শান্ত্বনা পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","পাছত অব্ৰাহামে কটুৰা নামৰ আন এগৰাকীক বিয়া কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","তেওঁৰ ঔৰসত জিম্ৰণ, যক্সন, মদান, মিদিয়ন, যস্বক আৰু চুহৰ জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","যক্সনৰ সন্তান চিবা আৰু দদান। অচুৰীয়া, লটুচীয়া, লিয়ুম্মীয়া, এইকেইজন দদানৰ সন্তান। ");
INSERT INTO asmfb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","মিদিয়নৰ সন্তান ঐফা, এফৰ, হনোক, অবীদা আৰু ইলদায়া। এই আটাইকেইজন আছিল সেই কটুৰাৰ বংশধৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","অব্ৰাহামে নিজৰ সৰ্ব্বস্বৰ ওপৰত ইচহাকক অধিকাৰ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","কিন্তু উপপত্নীৰ সন্তান সকলকো তেওঁ জীৱিত কালত অলপ অলপ দানস্বৰূপে দিলে। এই সন্তান সকলক তেওঁ তেওঁৰ পুত্ৰ ইচহাকৰ ওচৰৰ পৰা দূৰ কৰি পূবফালৰ দেশলৈ পঠাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","অব্ৰাহাম মুঠ 175 বছৰ জীয়াই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","অব্ৰাহামে সম্পূৰ্ণ আয়ুস পাই এক উত্তম বৃদ্ধ অৱস্থাত মৃত্যু বৰণ কৰিলে আৰু তেওঁ ওপৰ পিতৃসকলৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","মম্ৰি চহৰৰ পূব ফালে হিত্তীয়া চোহৰৰ পুত্র ইফ্রোণৰ পথাৰত মকপেলাৰ গুহাত পুত্ৰ ইচহাক আৰু ইশ্মায়েলে একেলগে অব্রাহামক মৈদাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","সেই পথাৰ অব্ৰাহামে হেতৰ সন্তানসকলৰ পৰা কিনিছিল; তাতেই অব্ৰাহামে চাৰাক মৈদাম দিছিল আৰু তাতে অব্ৰাহামকো মৈদাম দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","অব্ৰাহামৰ মৃত্যুৰ পাছত ঈশ্বৰে তেওঁৰ পুত্ৰ ইচহাকক আশীৰ্ব্বাদ কৰিলে; আৰু ইচহাকে বেৰ-লহয়-ৰোৱীৰ ওচৰত বসবাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","চাৰাৰ দাসী মিচৰীয়া হাগাৰে অব্ৰাহামলৈ যি পুত্ৰ জন্ম দিছিল, অব্ৰাহামৰ সেই পুত্ৰ ইশ্মায়েলৰ বংশৰ বিৱৰণ এই। ");
INSERT INTO asmfb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","জন্ম অনুসাৰে ইশ্মায়েলৰ বংশধৰসকলৰ নাম হ’ল: ইশ্মায়েলৰ জ্যেষ্ঠ পুত্ৰ নবায়োৎ, তেওঁৰ পাছত কেদৰ, অদবেল, মিবচম, ");
INSERT INTO asmfb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","মিস্মা, দুমা, মচ্ছা ");
INSERT INTO asmfb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","হদদ, তেমা, যটূৰ, নাফীচ আৰু কেদ্মা; ");
INSERT INTO asmfb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ইশ্মায়েলৰ এই বাৰজন পুত্রই আছিল তেওঁলোকৰ ফৈদৰ মূলসূঁতি আৰু তেওঁলোকৰ নাম অনুসাৰেই গাওঁ আৰু ছাউনিবোৰৰ নাম ৰখা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ইশ্মায়েল 137 বছৰ জীয়াই আছিল। পাছত তেওঁ মৃত্যু বৰণ কৰিলে আৰু নিজৰ মৃত পূর্বপুৰুষসকলৰ ওচৰলৈ তেওঁক নিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","হবীলাৰ পৰা চূৰ পর্যন্ত যি ঠাই আছিল, তেওঁৰ বংশৰ লোকসকলে তাতে বাস কৰিছিল। এই ঠাইখিনি আছিল মিচৰ দেশৰ কাষত অচুৰলৈ যোৱাৰ পথত। এইদৰে তেওঁলোকে নিজৰ শত্রুসকলৰ ওচৰত বসতি কৰিবলৈ ঠাই পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","অব্ৰাহামৰ পুত্ৰ ইচহাকৰ বিৱৰণ এই। অব্ৰাহামৰ পুত্রৰ নাম ইচহাক। ");
INSERT INTO asmfb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ইচহাকে চল্লিশ বছৰ বয়সত ৰিবেকাক পত্নীৰূপে গ্রহণ কৰে। ৰিবেকা আছিল পদ্দন-অৰাম দেশৰ অৰামীয়া বথোৱেলৰ জীয়েক আৰু অৰামীয়া লাবনৰ ভনীয়েক। ");
INSERT INTO asmfb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ইচহাকৰ ভাৰ্যা নিঃসন্তান আছিল বাবে ইচহাকে তেওঁৰ বাবে যিহোৱাৰ ওচৰত প্ৰাৰ্থনা কৰিলে; তাতে যিহোৱাই তেওঁৰ প্ৰাৰ্থনা শুনিলে আৰু তেওঁৰ ভাৰ্যা ৰিবেকা গৰ্ভৱতী হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","তেওঁৰ গর্ভত যমজ সন্তান আছিল আৰু সিহঁতে ইটোৱে সিটোক ঠেলা-ঠেলি কৰিব ধৰিলে; সেয়ে ৰিবেকাই ক’লে, “মোৰ কিয় এনেকুৱা হৈছে?” এইবুলি কাৰণটোনো কি তাক জানিবলৈ তেওঁ যিহোৱাক সুধিবলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","যিহোৱাই তেওঁক ক’লে, “তোমাৰ গৰ্ভত দুটা ভিন্ন জাতি আছে, আৰু তোমাৰ উদৰৰ পৰাই দুই জাতি বাহিৰ হৈ বেলেগ হ’ব; এক জাতি আন জাতিতকৈ পৰাক্ৰমী হ’ব, আৰু বৰটো সৰুটোৰ দাস হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","যেতিয়া সন্তান প্ৰসৱৰ কাল সম্পূৰ্ণ হ’ল, সঁচাই তেওঁৰ গৰ্ভত এহাল যঁজা সন্তান আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","তাৰে প্ৰথমটো ৰঙা আৰু গোটেই গা নোমাল বস্ত্ৰৰ নিচিনা নোমাল হৈ ওলাল; এই কাৰণে তেওঁলোকে তাৰ নাম এচৌ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","তাৰ পাছত এচৌৰ গোৰোৱা ধৰা অৱস্থাৰে তাৰ ভায়েকৰ জন্ম হ’ল; তাৰ নাম যাকোব ৰখা হ’ল। ইচহাকৰ ষাঠি বছৰ বয়সত তেওঁৰ ভার্য্যাই সিহঁতক জন্ম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","এই ল’ৰা দুটি ডাঙৰ হোৱাৰ পাছত এচৌ এজন নিপুণ চিকাৰী হ’ল। তেওঁ বনে বনে ঘূৰি ফুৰিছিল। কিন্তু যাকোব আছিল শান্ত স্বভাৱৰ। তেওঁ তম্বুত থাকিয়েই সময় কটাইছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","চিকাৰ কৰা মঙহ খাবলৈ পোৱাৰ কাৰণে ইচহাকে এচৌক স্নেহ কৰিছিল, কিন্তু ৰিবেকাই হ’লে যাকোবকহে স্নেহ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","এদিনাখন যাকোবে দাইল ৰান্ধিছিল; তেনে সময়তে এচৌ পথাৰৰ পৰা উলটি আহিছিল আৰু তেওঁ বৰ ক্লান্ত হৈ পৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","তেওঁ যাকোবক ক’লে, “মই বৰ ক্লান্ত। অনুগ্রহ কৰি তোমাৰ সেই ৰঙা বস্তুৰ কিছু মোক খাবলৈ দিয়া।” এই কথাৰ কাৰণে এচৌৰ নাম ইদোম ৰঙা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","তেতিয়া যাকোবে ক’লে, “প্রথমে ডাঙৰ ল’ৰা হিচাবে তোমাৰ যি অধিকাৰ আছে, সেয়া আজি মোক বেচা।” ");
INSERT INTO asmfb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","তাতে, এচৌৱে ক’লে, “চোৱা, মোৰ প্রাণ যাওঁ যাওঁ যেন হৈছে, সেয়ে জেষ্ঠাধিকাৰত মোৰ কি লাভ?” ");
INSERT INTO asmfb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","যাকোবে ক’লে, “আগেয়ে তুমি মোৰ আগত শপত খোৱা।” তাতে এচৌৱে তেওঁৰ আগত শপত খাই নিজৰ জেষ্ঠাধিকাৰ যাকোবক বেচিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","তেতিয়া যাকোবে এচৌক পিঠা আৰু মচুৰ দাইল খাবলৈ দিলে; তাতে তেওঁ খাই উঠি গুচি গ’ল। এইদৰে এচৌৱে নিজৰ জেষ্ঠাধিকাৰ হেয়জ্ঞান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","অব্ৰাহামৰ দিনত হোৱা প্ৰথম আকালৰ দৰে সেই দেশত পুনৰায় আকাল হোৱাত, ইচহাকে গৰাৰালৈ, পলেষ্টীয়াসকলৰ ৰজা অবীমেলকৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","পাছত যিহোৱাই তেওঁক দৰ্শন দি ক’লে, “তুমি মিচৰ দেশলৈ নামি নাযাবা; যি দেশৰ কথা মই তোমাক ক’ম, তাতে থাকিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","তুমি এই দেশতে প্ৰবাস কৰা; তাতে মই তোমাৰ সঙ্গী হৈ তোমাক আশীৰ্ব্বাদ কৰিম; কিয়নো এই সকলো দেশ তোমাক আৰু তোমাৰ বংশকেই দিম, মই তোমাৰ পিতৃ অব্ৰাহামলৈ কৰা শপত সাম্ফল কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","মই আকাশৰ তৰাবোৰৰ দৰে তোমাৰ বংশ বঢ়াই, তোমাৰ বংশক এই সকলো দেশ দিম; আৰু তোমাৰ বংশতে পৃথিৱীৰ সমুদায় জাতি আশীৰ্ব্বাদ প্ৰাপ্ত হ’ব; ");
INSERT INTO asmfb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","কিয়নো অব্ৰাহামে মোৰ কথা মানি, মোৰ আজ্ঞা আৰু বিধি-ব্যৱস্থাবোৰ পালন কৰিছিল।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","সেইবাবে ইচহাকে গৰাৰত বসবাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","সেই ঠাইৰ লোকসকলে ইচহাকৰ ভাৰ্যাৰ কথা সোধাত, “তেওঁ মোৰ ভনী বুলি ক’লে।” ৰিবেকা বৰ সুন্দৰী, ইয়াৰ মানুহবোৰে ৰিবেকাক পাবলৈ কিজানি মোক বধ কৰে এই কাৰণে “মোৰ ভার্য্যা বুলি” পৰিচয় নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","পাছত তেওঁ সেই ঠাইত ভালেমান দিন থাকিল, এদিন পলেষ্টীয়াসকলৰ ৰজা অবীমেলকে খিড়িককিদি চাই, ইচহাকক তেওঁৰ ভাৰ্যা ৰিবেকাই সৈতে ক্ৰীড়া কৰিবৰ দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","তাতে অবীমেলকে ইচহাকক মাতি আনি ক’লে তুমি তেওঁৰ লগত কি কৰি আছিলা? “সেই মহিলা গৰাকী নিশ্চয়ে তোমাৰ ভাৰ্যা; তেন্তে তুমি ভনী বুলি কেনেকৈ ক’লা? ইচহাকে ক’লে, তেওঁৰ কাৰণে মই মৰিম বুলি ভাবি সেইদৰে কৈছিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","তেতিয়া অবীমেলকে ক’লে, “তুমি আমালৈ এইটো কি কাম কৰিলা? লোকসকলৰ মাজৰ কোনো এজনে তোমাৰ ভাৰ্যাৰে সৈতে অনায়েসে শয়ন কৰিব পাৰিলেহেঁতেন; সেয়ে হোৱা হ’লে তুমি আমাক দোষী সাব্যস্ত কৰিলাহেঁতেন।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","পাছত অবীমেলকে সকলো লোকক এই আজ্ঞা দি সাবধান কৰি ক’লে, “যি কোনোৱে এই পুৰুষ বা তেওঁৰ ভাৰ্যাক স্পৰ্শ কৰিব, নিশ্চয়ে তাৰ প্ৰাণদণ্ড হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","সেই কালত ইচহাকে সেই দেশত ধান ৰোপণ কৰি, সেই একে বছৰতেই এশ গুণ পালে; আৰু যিহোৱাই তেওঁক আশীৰ্ব্বাদ কৰিলে আৰু তেওঁ বৰ মানুহ হ’ল; ");
INSERT INTO asmfb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","আৰু ইচহাক বৰ ধনী হৈ হৈ, ক্ৰমেৰে অতিশয় মহান ব্যক্তি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","আৰু তেওঁৰ অনেক পশুধন আৰু অনেক দাস-দাসী হ’ল। এইকাৰণে পলেষ্টীয়াসকলে তেওঁক ঈৰ্ষা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ইচহাকৰ পিতৃ অব্ৰাহামৰ দিনত, অব্ৰাহামৰ বন্দীবোৰে যি যি নাদ খান্দিছিল, সেই সকলোকে পলেষ্টীয়াসকলে মাটি দি পুতি বন্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","পাছত অবীমেলকে ইচহাকক ক’লে, “তুমি আমাৰ ওচৰৰ পৰা গুচি যোৱা কিয়নো তুমি আমাতকৈও অতিশয় ক্ষমতাশালী থ’লো।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","তেতিয়া ইচহাকে তাৰ পৰা গুচি গৈ, গৰাৰৰ উপত্যকাত তম্বু তৰি তাতেই বাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","আৰু তেওঁৰ পিতৃ অব্ৰাহামৰ দিনত খন্দা যি যি পানীৰ নাদ পলেষ্টীয়াসকলে অব্ৰাহামৰ মৃত্যুৰ পাছত পুতি পেলাইছিল, ইচহাকে পুনৰাই সেইবোৰ নাদ খানি উলিয়ালে; আৰু তেওঁৰ পিতৃয়ে দিয়া নামৰ দৰেই, ইচহাকে সেইবোৰৰ নাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","আৰু ইচহাকৰ বন্দীবোৰে সেই উপত্যকা খানি তাত এটা পানীৰ নিজৰাৰ ভূমূক পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","তাতে গৰাৰৰ পশু ৰখীয়াবোৰে ইচহাকৰ পশু ৰখীয়াই সৈতে বিবাদ কৰি ক’লে, “এই পানী আমাৰ।” এই হেতুকে ইচহাকে সেই নাদৰ নাম “এচক” ৰাখিলে; কাৰণ সিহঁতে তেওঁৰ লগত বিবাদ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","পাছে আৰু এটা নাদ খান্দিলে, সিহঁতে তাৰ নিমিত্তেও বিবাদ কৰিলে; তাতে ইচহাকে তাৰ নাম “চিত্না” ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","আকৌ তেওঁ তাৰ পৰা গৈ, আন এটা নাদ খান্দিলে। তাৰ নিমিত্তে হ’লে সিহঁতে বিবাদ নকৰিলে; তাতে তেওঁ তাৰ নাম ৰহোবোৎ ৰাখি ক’লে, “এতিয়াহে যিহোৱাই আমাক বহল ঠাই দিছে; এতেকে আমি দেশত বৃদ্ধি হ’ম।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","তাৰ পাছত ইচহাক তাৰ পৰা বেৰ-চেবালৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","সেই ৰাতিয়েই যিহোৱাই তেওঁক দৰ্শন দি ক’লে, “মই তোমাৰ পিতৃ অব্ৰাহামৰ ঈশ্বৰ, ভয় নকৰিবা; কিয়নো মই তোমাৰ সঙ্গী হৈ তোমাক আশীৰ্ব্বাদ কৰিম আৰু মোৰ নিজ দাস অব্ৰাহামলৈ চাই তোমাৰ বংশ বৃদ্ধি কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","পাছত ইচহাকে সেই ঠাইতে এটা যজ্ঞ-বেদি নিৰ্ম্মাণ কৰি যিহোৱাৰ নামেৰে প্ৰাৰ্থনা কৰিলে আৰু তাতে নিজ তম্বু তৰিলে। পাছে ইচহাকৰ বন্দীহঁতে তাত এটা নাদ খান্দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","তেতিয়া অবীমেলকে অহুজ্জৎ নামেৰে নিজৰ এজন বন্ধুক আৰু তেওঁৰ প্ৰধান সেনাপতি ফীখোলকো লগত লৈ, গৰাৰৰ পৰা ইচহাকৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","তাতে ইচহাকে তেওঁলোকক ক’লে, “তোমালোকে মোক ঘিণ কৰি তোমালোকৰ ওচৰৰ পৰা খেদি পঠালা; এতিয়া নো তোমালোক মোৰ ওচৰলৈ কেলৈ আহিছা?” ");
INSERT INTO asmfb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","তাতে তেওঁলোকে ক’লে, “যিহোৱা যে তোমাৰ সঙ্গী, তাক আমি জানিলোঁ তোমাৰ আৰু আমাৰ মাজত এক শপত হ’বলৈ, ");
INSERT INTO asmfb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","আমি যেনেকৈ তোমাক স্পৰ্শ কৰা নাই, বৰং শান্তিৰে বিদায় কৰিছিলোঁ, তেনেকৈ তুমিও যাতে আমাক হিংসা নকৰা, এয়ে তোমাৰে সৈতে এটা নিয়ম স্থাপন কৰিলোঁ; তুমি এতিয়া যিহোৱাৰ আশীৰ্ব্বাদ প্ৰাপ্ত থ’লো।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","তেতিয়া ইচহাকে তেওঁলোকলৈ ভোজ যুগুত কৰিলে আৰু তেওঁলোকে ভোজন-পান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","পাছত তেওঁলোক দুজনে নিচেই ৰাতিপুৱাতে উঠি, ইজনে সিজনৰ আগত শপত কৰিলে আৰু ইচহাকে তেওঁলোকক বিদায় কৰিলে, তেওঁলোক শান্তিৰে তেওঁৰ ওচৰৰ পৰা গুচি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","আৰু সেই দিনাই ইচহাকৰ দাসবোৰে আহি সিহঁতে খন্দা এটা নাদৰ বিষয়ে তেওঁক সম্বাদ দিলেহি বোলে “আমি পানী পালোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","তাতে তেওঁ সেই নাদৰ নাম চিবিয়া ৰাখিলে; এই হেতুকে আজিলৈকে সেই নগৰৰ নাম বেৰ-চেবা বুলি প্ৰখ্যাত। ");
INSERT INTO asmfb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","পাছত এচৌৱে 40 বছৰ বয়সত, হিত্তীয়া বেৰীৰ জীয়েক যিহূদিৎ আৰু হিত্তীয়া এলোনৰ জীয়েক বাচমতক বিয়া কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","কিন্তু ইহঁত দুজনী ইচহাক আৰু ৰিবেকাৰ মনত দুখ দিওঁতা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ইচহাক ক্রমে বৃদ্ধ হ’ল; তাতে চকুৰ দৃষ্টিশক্তি দুৰ্ব্বল হোৱাত তেওঁ চকুৰে মনিব নোৱাৰা হ’ল; এদিন তেওঁ বৰ পুতেক এচৌক মাতি ক’লে, “বোপা।” এচৌৱে উত্তৰ দিলে, “মই ইয়াতে আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","তেতিয়া ইচহাকে ক’লে, “চোৱা, মই বৃদ্ধ হৈছোঁ আৰু কোন দিনা যে মৰিম, তাকো নাজানো। ");
INSERT INTO asmfb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","সেয়ে, তোমাৰ অস্ত্ৰ-শস্ত্ৰ, তীৰ-ধনু লৈ চিকাৰলৈ যোৱা আৰু মোৰ বাবে পহু মাৰি আনাগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","মৃত্যুৰ আগতে মই তোমাক আশীৰ্ব্বাদ কৰি যাবৰ কাৰণে মই ভাল পোৱা সু-স্বাদু আহাৰ মোলৈ যুগুত কৰি আনা।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","তাৰ পাছত এচৌৱে পহু মাৰি আনিবৰ বাবে চিকাৰলৈ গ’ল। ইচহাকে যেতিয়া এইবোৰ কথা তেওঁৰ পুত্ৰ এচৌক কৈছিল, তেতিয়া ৰিবেকাই শুনি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ৰিবেকাই তেওঁৰ প্রিয়পুত্ৰ যাকোবক ক’লে, “চোৱা, তোমাৰ পিতৃয়ে তোমাৰ ককায়েৰা এচৌক এইবুলি কোৱা মই শুনা পালোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘মোৰ মৃত্যুৰ আগতে, তোমাক যিহোৱাৰ উপস্থিতিত আশীৰ্ব্বাদ কৰি যাবৰ কাৰণে তুমি পহু মাৰি আনি মোৰ বাবে সু-স্বাদু আহাৰ যুগুত কৰা।’ ");
INSERT INTO asmfb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","সেয়ে বোপা, এতিয়া মই যি কথা কওঁ, তাক মানি তুমি সেইদৰে কৰা। ");
INSERT INTO asmfb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","তুমি পশুৰ জাকলৈ গৈ, তাৰ পৰা দুটা উত্তম ছাগলী পোৱালি মোৰ ওচৰলৈ লৈ আনা; তাৰে মই তোমাৰ পিতৃয়ে যেনেকৈ ভাল পায়, তেনেদৰেই সু-স্বাদু আহাৰ তেওঁৰ কাৰণে ৰান্ধি দিম। ");
INSERT INTO asmfb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","মৃত্যুৰ পূর্বেই তোমাক আশীৰ্ব্বাদ কৰিবৰ কাৰণে, সেই আহাৰ তুমি পিতৃক খোৱাবলৈ তেওঁৰ কাষলৈ লৈ যাবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","তেতিয়া যাকোবে তেওঁৰ মাক ৰিবেকাক ক’লে, “মোৰ ককাই এচৌ এজন নোমাল মানুহ; কিন্তু মই হ’লে এজন মসৃণ ছালৰ মানুহ। ");
INSERT INTO asmfb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","কিজানি মোৰ পিতৃয়ে মোক চুই চাব আৰু তেওঁৰ আগত মই এজন প্ৰবঞ্চক হ’ম; তাতে মই নিজলৈ আশীৰ্ব্বাদ নানি এক অভিশাপহে আনিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","তাতে মাকে তেওঁক ক’লে, “মোৰ বোপা, সেই শাও মোৰ ওপৰতে পৰক; তুমি কেৱল মোৰ কথা মানি ছাগলী আনাগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","তেতিয়া যাকোবে গৈ ছাগলী পোৱালিবোৰ আনি মাকক দিলেহি আৰু মাকে তেওঁৰ পিতৃয়ে ভাল পোৱাকৈ সু-স্বাদু আহাৰ যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","তাৰ পাছত ৰিবেকাই তেওঁৰ ওচৰত ঘৰতে থকা বৰ পুতেক এচৌৰ আটাইতকৈ উত্তম বস্ত্ৰ লৈ সৰু পুতেক যাকোবক পিন্ধালে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","যাকোবৰ হাত আৰু ডিঙিৰ মসৃণ অংশত সেই ছাগলী পোৱালি দুটাৰ ছালবোৰ লগাই দিলে ");
INSERT INTO asmfb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","সেই সু-স্বাদু আহাৰ আৰু পিঠা নিজে যুগুত কৰা তেওঁৰ পুত্ৰ যাকোবৰ হাতত দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","যাকোবে পিতৃৰ ওচৰলৈ গৈ মাত দিলে, “হে মোৰ পিতৃ।” ইচহাকে ক’লে, “মই ইয়াতে আছোঁ; বোপা, তুমিনো কোন?” ");
INSERT INTO asmfb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","যাকোবে পিতৃক ক’লে, “মই আপোনাৰ বৰ পুত্র এচৌ; আপুনি মোক কোৱাৰ দৰে মই কৰিলোঁ; এতিয়া উঠি বহক আৰু মাংস ভোজন কৰক যাতে আপুনি মোক আশীৰ্ব্বাদ কৰিব পাৰে।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","তেতিয়া ইচহাকে নিজ পুত্ৰক সুধিলে, “বোপা, তুমি কেনেকৈ তাক ইমান সোনকালে পালা?” তেওঁ ক’লে, “কিয়নো আপোনাৰ ঈশ্বৰ যিহোৱায়েই তাক মোলৈ আনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ইচহাকে যাকোবক পুনৰ ক’লে, “মোৰ ওচৰলৈ চাপি আহাঁ বোপা; তুমি সঁচায়েই মোৰ পুত্ৰ এচৌ হোৱানে নোহোৱা, তাক জানিবলৈ মই তোমাক যেন চুই চাব পাৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","তাতে যাকোবে তেওঁৰ পিতৃ ইচহাকৰ ওচৰলৈ চাপি গ’ল; তেতিয়া ইচহাকে তেওঁক চুই চাই ক’লে, “মাত-কথা যাকোবৰ, কিন্তু হাত হ’লে এচৌৰ।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ইচহাকে যাকোবক চিনি নাপালে, কাৰণ তেওঁৰ হাত দুখন ককায়েক এচৌৰ হাতৰ দৰে নোমাল আছিল। সেয়ে ইচহাকে যাকোবক আশীৰ্ব্বাদ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","তেওঁ ক’লে, “তুমি সচাঁকৈয়ে মোৰ পুত্ৰ এচৌ হোৱানে?” যাকোবে ক’লে, “হয়, মইয়ে হওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","তেতিয়া ইচহাকে ক’লে, “মোৰ ওচৰলৈ আহাৰখিনি আনা; তুমি চিকাৰ কৰি অনা মাংস খাই মই তোমাক আশীৰ্ব্বাদ কৰোঁ।” তাতে যাকোবে আহাৰখিনি আনি দিলে আৰু ইচহাকে তাক ভোজন কৰিলে। তাৰ পাছত যাকোবে দ্ৰাক্ষাৰসো আনি দিয়াত, তেওঁ তাকো পান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","তাৰ পাছত তেওঁৰ পিতৃ ইচহাকে তেওঁক ক’লে, “বোপা, ওচৰলৈ আহি তুমি মোক চুমা খোৱাহি।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","যাকোবে ওচৰলৈ গৈ ইচহাকক চুমা খালে আৰু ইচহাকে তেওঁৰ গাৰ কাপোৰৰ গোন্ধ পাই তেওঁক আশীৰ্ব্বাদ কৰি ক’লে, “চোৱা, মোৰ পুত্ৰৰ গোন্ধ যিহোৱাই আশীৰ্ব্বাদ কৰা এক ক্ষেত্ৰৰ দৰে এই গোন্ধ। ");
INSERT INTO asmfb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ঈশ্বৰে যেন তোমাক আকাশৰ নিয়ৰৰ এক অংশ দিয়ে, পৃথিৱীৰ উৰ্ব্বৰতাৰ এক অংশ দিয়ে, আৰু প্রচুৰ শস্য আৰু নতুন দ্ৰাক্ষাৰস দিয়ে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","লোক সকলে তোমাৰ সেৱা কৰক আৰু জাতিবোৰে তোমাৰ আগত প্ৰণিপাত কৰক। তোমাৰ ভাইসকলৰ ওপৰত তুমি প্ৰভুত্ব কৰা, আৰু তোমাৰ মাতৃৰ সন্তান সকলে তোমাক প্ৰণিপাত কৰক। যিসকলে তোমাক শাও দিব, তেওঁলোক অভিশপ্ত হওঁক; যিসকলে তোমাক আশীৰ্ব্বাদ কৰিব, তেওঁলোক আশীৰ্ব্বাদ প্ৰাপ্ত হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ইচহাকে যাকোবক আশীৰ্ব্বাদ দি শেষ কৰিলে আৰু যাকোবে তেওঁৰ পিতৃ ইচহাকৰ ওচৰৰ পৰা বাহিৰ হৈ যোৱা মাত্ৰকেই, তেওঁৰ ককায়েক এচৌ চিকাৰৰ পৰা ঘূৰি আহি পালেহি। ");
INSERT INTO asmfb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","তেৱোঁ সুস্বাদু আহাৰ ৰান্ধি বাপেকৰ ওচৰলৈ আনি ক’লে, “হে পিতৃ, উঠক আৰু আপোনাৰ পুত্রই চিকাৰ কৰি অনা মাংস ভোজন কৰি মোক আশীৰ্ব্বাদ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","তেতিয়া তেওঁৰ পিতৃ ইচহাকে তেওঁক সুধিলে, “তুমি কোন?” এচৌৱে ক’লে, “মই আপোনাৰ বৰপুত্ৰ এচৌ।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","এই কথা শুনি ইচহাকৰ শৰীৰত কঁপনি উঠিল। তেওঁ সুধিলে, “তেন্তে যিটোৱে মোৰ ওচৰলৈ চিকাৰৰ মঙহ আনিছিল, সি কোন? তুমি অহাৰ আগেয়েই মই সেই সকলোকে খালোঁ আৰু তাক আশীৰ্ব্বাদো কৰিলোঁ; সেই আশীর্বাদৰ ফলও অৱশ্যেই সিয়ে পাব।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","বাপেকৰ এই কথা শুনি এচৌ শোকত ভাগি পৰিল আৰু হুৰাওৰাৱে কান্দি কান্দি বাপেকক ক’লে, “পিতৃ, মোক, মোকো আশীৰ্ব্বাদ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","তেওঁ ক’লে, “তোমাৰ ভায়েৰাই আহি ছল কৰি তুমি পাবলগীয়া আশীৰ্ব্বাদ লৈ গ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","তেতিয়া এচৌৱে ক’লে, “তাক দিয়া যাকোব নামটো স্বৰূপেই সঠিক হোৱা নাই নে? কিয়নো এইবাৰকে লৈ দুবাৰ সি মোৰ অধিকাৰ ছল কৰি ললে; ডাঙৰ ল’ৰা হিচাবে মোৰ যি জ্যেষ্ঠ অধিকাৰ, তাক সি ল’লে আৰু চাওঁক, এতিয়া মোৰ আশীৰ্ব্বাদো লৈ গ’ল।” এচৌৱে আকৌ ক’লে, “মোৰ কাৰণে আপুনি একো আশীৰ্ব্বাদ ৰখা নাই নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","তেতিয়া ইচহাকে এচৌক উত্তৰ দি ক’লে, “চোৱা, মই তাক তোমাৰ ওপৰত প্ৰভু পাতিলোঁ আৰু তাৰ জ্ঞাতি-ভাইসকলক তাৰেই দাস কৰিলোঁ; মই তাক শস্য আৰু নতুন দ্ৰাক্ষাৰস দিলোঁ; ইয়াৰ পিছত বোপা, মইনো তোমাৰ অৰ্থে আৰু কি কৰিব পাৰোঁ?” ");
INSERT INTO asmfb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","তেতিয়া এচৌৱে আকৌ বাপেকক কাকুতি-মিনতি কৰি ক’লে, “হে পিতৃ, মোৰ কাৰণে আপোনাৰ ওচৰত এটাও আশীর্বাদ নাইনে? হে মোৰ পিতৃ, আপুনি মোক, মোকো আশীৰ্ব্বাদ কৰক।” এইদৰে কৈ এচৌৱে বৰকৈ কান্দিব ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","পাছে তেওঁৰ বাপেক ইচহাকে উত্তৰ দি ক’লে, “চোৱা, যি ঠাইত তুমি বাস কৰিবা সেই ভূমি উর্বৰ নহ’ব; তাত আকাশৰ পৰা নিয়ৰ নপৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","তুমি নিজৰ তৰোৱালৰ দ্বাৰাই জীবা, তুমি তোমাৰ ভাইৰ সেৱা কৰিবা; কিন্তু যেতিয়া তুমি বিদ্রোহী হৈ উঠিবা, তেতিয়া তুমি তোমাৰ ডিঙিৰ পৰা তাৰ যুৱলি জোকাৰি পেলাবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","পাছত যাকোবে তেওঁৰ পিতৃৰ পৰা আশীৰ্ব্বাদ লাভ কৰাৰ কাৰণে এচৌৱে তেওঁক ঘিণ কৰিবলৈ ধৰিলে। তেওঁ নিজ মনতে ক’লে, “মোৰ পিতৃৰ বাবে শোকৰ দিন ওচৰ চাপি আহিছে; তাৰ পাছতে মই মোৰ ভাই যাকোবক বধ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","বৰপুতেক এচৌৰ এই সকলো কথা ৰিবেকাই জানিব পাৰিলে আৰু সেয়ে তেওঁ মানুহ পঠাই সৰু পুতেক যাকোবক মতাই আনি ক’লে, “শুনা, তোমাৰ ককায়েৰা এচৌৱে তোমাক বধ কৰাৰ মন্ত্রণাৰে নিজকে নিজে শান্ত্বনা দিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","সেইবাবে বোপা, তুমি মোৰ কথা শুনা। এতিয়া তুমি হাৰণত থকা মোৰ ককাই লাবনৰ ওচৰলৈকে পলাই যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","তোমাৰ ককাইৰ খং মাৰ নেযায় মানে তুমি তেওঁৰ লগতে কিছুদিন থাকাগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","তোমাৰ প্রতি তোমাৰ ককায়েৰাৰ খং মাৰ নোযোৱা পর্যন্ত আৰু তুমি তেওঁলৈ যি কৰিলা তাক তেওঁ পাহৰি নোযোৱালৈকে তুমি তেওঁৰ লগত কিছুদিন থাকা; পাছত মানুহ পঠাই মই তোমাক তাৰ পৰা ঘূৰাই আনিম; কিয় মই একেদিনাই তোমালোক দুয়োকো হেৰুৱাম?” ");
INSERT INTO asmfb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","পাছত ৰিবেকাই ইচহাকক ক’লে, “এই হিত্তীয়া ছোৱালীবোৰৰ কাৰণে মোৰ আৰু জীয়াই থাকিবলৈ ইচ্ছা নোহোৱা হৈছে। তাৰ উপৰি যাকোবেও যদি এই দেশৰে কোনো হিত্তীয়া ছোৱালী বিয়া কৰে, তেন্তে মই জীয়াই থকাৰ কি লাভ?” ");
INSERT INTO asmfb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ইচহাকে যাকোবক মাতি আশীৰ্ব্বাদ কৰিলে আৰু এই আজ্ঞা দিলে, “তুমি কনান দেশৰ কোনো ছোৱালী বিয়া নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","তুমি উঠি পদ্দন-অৰাম দেশত তোমাৰ মাতৃৰ পিতৃগৃহ বথোৱেলৰ ঘৰলৈ যোৱা। তাৰ পৰা তোমাৰ মোমায়েৰা লাবনৰ জীয়েকহঁতৰ মাজৰ কোনো এজনীক বিয়া কৰি আনাগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","সৰ্ব্বশক্তিমান ঈশ্বৰে তোমাক আশীৰ্ব্বাদ কৰক আৰু বহুবংশ কৰি বৃদ্ধি কৰক। তোমাক অনেক জাতি সমূহৰ পিতৃ হোৱাৰ ক্ষমতা দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","যি আশীৰ্ব্বাদ ঈশ্বৰে অব্ৰাহামক দিছিল, সেই আশীর্বাদ তেওঁ তোমাক আৰু তোমাৰ পাছত তোমাৰ বংশৰ লোকসকলক দান কৰক। যি দেশ ঈশ্বৰে অব্রাহামক দিছিল আৰু য’ত তুমি বাস কৰি আছা, সেই দেশ তোমাৰ অধিকাৰলৈ আহক।” ");
INSERT INTO asmfb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","এইদৰে ইচহাকে যাকোবক পঠাই দিলে আৰু যাকোবেও পদ্দন-অৰামৰ অৰামীয়া বথোৱেলৰ পুত্ৰ লাবনৰ ওচৰলৈ গ’ল। লাবন যাকোব আৰু এচৌৰ মাক ৰিবেকাৰ ককায়েক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","পাছত এচৌৱে জানিলে যে ইচহাকে যাকোবক আশীৰ্ব্বাদ কৰি পদ্দন-অৰামৰ পৰা কোনো ছোৱালীক বিয়া কৰি আনিবলৈ পঠাইছে; তেওঁ আৰু শুনিলে যে ইচহাকে যাকোবক আশীৰ্ব্বাদ দিয়াৰ সময়ত এই আজ্ঞা দিছিল “তুমি কোনো কনানীয়া ছোৱালীক বিয়া নকৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","এচৌৱে দেখিলে, যাকোবে তেওঁৰ পিতৃ-মাতৃৰ আদেশ মানি পদ্দন-অৰামলৈ গুছি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","তাতে এচৌৱে বুজি পালে যে এই কনানীয়া মহিলাসকলৰ প্রতি তেওঁৰ পিতৃ ইচহাক সন্তুষ্ট নহয়। ");
INSERT INTO asmfb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","সেয়ে দুগৰাকী ভার্য্যা থকাতো তেওঁ অব্ৰাহামৰ পুতেক ইশ্মায়েলৰ ঘৰলৈ গৈ তেওঁৰ জীয়েক মহলতক বিয়া কৰিলে। মহলত নবায়োতৰ ভনীয়েক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","আনফালে যাকোবে বেৰ-চেবাৰ পৰা ওলাই হাৰণৰ ফালে যাত্ৰা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","এখন ঠাইত বেলি মাৰ যোৱাত তেওঁ সেই ঠাইতে ৰাতিটো কটালে। সেই ঠাইৰে এটা শিল মূৰৰ তলত লৈ তেওঁ শুই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","তেওঁ শুই থাকোতে সপোনত দেখিলে যে পৃথিৱীৰ ওপৰত এডাল জখলা থিয় হৈ আছে আৰু তাৰ মূৰটো গৈ স্বর্গত লাগি আছে। তেওঁ দেখিলে যে তাৰ ওপৰেদি ঈশ্বৰৰ দূতবোৰে উঠা-নমা কৰি আছিল আৰু ");
INSERT INTO asmfb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","যিহোৱাই খটখটিৰ ওপৰত থিয় হৈ কৈছিল, “মই যিহোৱা। মই তোমাৰ ওপৰ পিতৃ অব্ৰাহামৰ ঈশ্বৰ আৰু ইচহাকৰো ঈশ্বৰ; তুমি যি ঠাইত শয়ন কৰিছা, সেই দেশ মই তোমাক আৰু তোমাৰ বংশক দিম। ");
INSERT INTO asmfb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","তোমাৰ বংশ পৃথিৱীৰ ধুলিৰ নিচিনা অসংখ্য হ’ব; তুমি পূৱ, পশ্চিম, উত্তৰ আৰু দক্ষিণলৈ বিস্তাৰিত হৈ যাবা; পৃথিৱীৰ সমুদায় জাতি, তোমাৰ আৰু তোমাৰ বংশতে আশীৰ্ব্বাদপ্ৰাপ্ত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","চোৱা, মই তোমাৰ লগত আছোঁ; তুমি যি যি ঠাইলৈ যাবা, মই তোমাক ৰক্ষা কৰিম আৰু পুনৰায় মই তোমাক এই দেশলৈ ওলোটাই আনিম; কিয়নো মই তোমাক কোৱা সকলো কথাকে সিদ্ধ নকৰোঁমানে, মই তোমাক ত্যাগ নকৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","যাকোবে টোপনিৰ পৰা সাৰ পাই ক’লে, “তেন্তে যিহোৱা নিশ্চয়কৈ এই ঠাইত আছে, অথচ মই তাক জনা নাছিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","তেওঁ ভয়তে ক’লে, “কি ভয়ানক এই ঠাই! ই ঈশ্বৰৰ গৃহৰ বাহিৰে আন একো নহয়; ইয়েই স্বৰ্গৰ দুৱাৰ।” ");
INSERT INTO asmfb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","পাছত যাকোবে অতি ৰাতিপুৱাতে উঠিল আৰু তেওঁ যি শিল মুৰৰ তলত লৈছিল তাক স্তম্ভৰূপে স্থাপন কৰি ওপৰত তেল বাকি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","তেওঁ সেই ঠাইৰ নাম বৈৎএল ৰাখিলে; কিন্তু পূৰ্বতে সেই নগৰৰ নাম লুজ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","যাকোবে সঙ্কল্প কৰি এই প্ৰতিজ্ঞা কৰিলে, “যদি ঈশ্বৰ মোৰ সঙ্গী হয়, মোৰ এই যাত্রাপথত তেওঁ মোক ৰক্ষা কৰে, যদি তেওঁ মোক অন্ন-বস্ত্রও যোগাই দিয়ে, ");
INSERT INTO asmfb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","যদি মই পিতৃৰ ঘৰলৈ পুনৰায় নিৰাপদে ঘূৰি আহিব পাৰোঁ, তেন্তে এই যিহোৱায়েই মোৰ ঈশ্বৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","তেতিয়া এই যি শিল মই স্তম্ভ স্বৰূপে স্থাপন কৰিলোঁ, ই এক পবিত্র শিল হ’ব; আপুনি মোক যি যি দিব, মই তাৰ দহ ভাগৰ এভাগ আপোনাক ঘূৰাই দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","পাছত যাকোবে যাত্ৰা কৰি কৰি পূৱদেশীয় লোকসকলৰ দেশ পালেগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","তাত তেওঁ চাৰিওফালে চাই পথাৰৰ মাজত এটা নাদ দেখা পালে। সেই নাদটোৰ ওচৰত তিনি জাক মেৰ-ছাগ শুই আছিল। ৰখীয়াবোৰে সেই নাদৰ পৰা জাকবোৰক পানী খুৱায়। নাদটোৰ মুখত এটা ডাঙৰ শিল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","যেতিয়া মেৰ-ছাগৰ জাকবোৰ আহি তাৰ কাষত গোট খায়, তেতিয়া ৰখীয়াবোৰে নাদৰ মুখৰ পৰা শিলটো আঁতৰাই মেৰ-ছাগবোৰক পানী খুৱায় আৰু তাৰ পাছত পুণৰায় নাদৰ মুখত শিলটো আগৰ দৰে থৈ দিয়ে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","যাকোবে তেওঁলোকক সুধিলে “হে ভাইসকল, আপোনালোক ক’ৰ মানুহ?” তেওঁলোকে ক’লে “আমি হাৰণৰ মানুহ।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","যাকোবে তেওঁলোকক সুধিলে, “আপোনালোকে নাহোৰৰ পো-নাতি লাবনক চিনি পাইনে?” তেওঁলোকে ক’লে, “হয়, আমি চিনি পাওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","তেওঁ তেওঁলোকক সুধিলে, “তেওঁ ভালে আছেনে?” তেওঁলোকে ক’লে, “হয়, তেওঁ ভালে আছে; সৌৱা চাওঁক, তেওঁৰ জীয়েক ৰাহেলে মেৰ-ছাগৰ জাক লৈ আহিছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","যাকোবে ক’লে, “চোৱা, বেলি পৰিবলৈ এতিয়াও বহুত দেৰি আছে; পশুবোৰ এঠাইত গোট খোৱাৰ সময় এতিয়াও হোৱা নাই। আপোনালোকে মেৰ-ছাগবোৰক পানী খুৱাই আকৌ চৰাবলৈ লৈ যাওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","কিন্তু তেওঁলোকে ক’লে, “আটাইবোৰ পশুৰ জাক একেলগে গোট নাখায় মানে আমি সেইবোৰক পানী খুৱাব নোৱাৰোঁ; পাছত নাদৰ মুখৰ পৰা শিলটো আতৰোৱা হব আৰু তেতিয়াহে আমি মেৰ-ছাগবোৰক পানী খুৱাব পাৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","যাকোবে তেওঁলোকৰ সৈতে কথাবাৰ্তা হৈ থাকোঁতেই, ৰাহেলে নিজৰ পিতৃৰ মেৰ-ছাগবোৰক লৈ সেই ঠাই পালেহি; কিয়নো তেওঁ সেই জাকবোৰক চৰাইছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","যাকোবে নিজৰ মোমায়েক লাবনৰ জীয়েক ৰাহেল আৰু তেওঁৰ মেৰ-ছাগবোৰক দেখি ওচৰ চাপি গ’ল। তেওঁ নাদৰ মুখৰ পৰা শিলচটা আঁতৰাই দি মেৰ-ছাগৰ জাকক পানী খুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","তাৰ পাছত যাকোবে ৰাহেলক চুমা খাই বৰকৈ কান্দিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","তেওঁ ৰাহেলক জনালে যে, তেওঁ তাইৰ পিতৃৰ আত্মীয়, ৰিবেকাৰ ল’ৰা। তেতিয়া ৰাহেলে দৌৰি গৈ নিজৰ পিতৃক এই কথা জনালে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","লাবনে নিজৰ ভনীয়েকৰ ল’ৰা যাকোব অহাৰ খবৰ পাই আগবঢ়াই নিবলৈ দৌৰি আহি তেওঁক সাৱটি ধৰি চুমা খালে আৰু নিজৰ ঘৰলৈ লৈ গ’ল। তেতিয়া যাকোবে লাবনক তেওঁ অহাৰ সকলো কথা জনালে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","লাবনে তেওঁক ক’লে, “তুমি সচাঁকৈয়ে মোৰ শৰীৰৰ হাড় আৰু মঙহৰ লোক।” তাৰ পাছত যাকোব লাবনৰ ঘৰত এমাহ থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","এদিন লাবনে যাকোবক ক’লে, “তুমি মোৰ আত্মীয় হোৱা বাবে জানো বিনা পাৰিশ্রমিককেৰে মোৰ সেৱা কৰা উচিত? তুমি কি বেচ লবা, তাক মোক কোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","লাবনৰ দুজনী জীয়েক আছিল; তাৰে বৰ জনীৰ নাম লেয়া আৰু সৰু জনীৰ নাম ৰাহেল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","লেয়াৰ চকু দুটা দুৰ্বল দৃষ্টিশক্তিৰ আছিল; কিন্তু ৰাহেল গঠণত ধুনীয়া আৰু দেখনীয়া আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","যাকোবে ৰাহেলক প্ৰেম কৰিছিল; সেয়ে তেওঁ ক’লে, “আপোনাৰ সৰু ছোৱালী ৰাহেলৰ কাৰণে মই সাত বছৰ আপোনাৰ সেৱা কৰি দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","তেতিয়া লাবনে ক’লে, “ৰাহেলক আন কোনো মানুহক দিয়াতকৈ তোমাক দিয়াই ভাল; তুমি মোৰ লগতে থাকা।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","সেয়ে, যাকোবে ৰাহেলৰ কাৰণে সাত বছৰ সেৱা কার্য কৰিলে; ৰাহেলক প্ৰেম কৰাৰ কাৰণেই সেই বছৰবোৰ যাকোবৰ মনত মাত্র অলপ দিন যেন লাগিল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","তাৰ পাছত যাকোবে লাবনক ক’লে, “মোৰ কামৰ কাল পূৰ হৈ গ’ল; গতিকে মই যেন বিবাহত বহিব পাৰোঁ, সেয়ে মোৰ ভাৰ্যাক মোক দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","তেতিয়া লাবনে সেই ঠাইৰ সকলো মানুহক গোটাই এটা ভোজৰ আয়োজন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","পাছত সন্ধিয়া সময়ত লাবনে তেওঁৰ জীয়েক লেয়াক আনি যাকোবৰ ওচৰত দিলে আৰু যাকোবে লেয়াক শয্যাৰ সঙ্গী কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","লাবনে নিজৰ দাসী জিল্পাক জীয়েক লেয়াক তেওঁৰ দাসী হিচাবে দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ৰাতিপুৱা হোৱাত যাকোবে আচৰিত হৈ দেখিলে যে, এওঁ দেখুন লেয়াহে! যাকোবে লাবনক ক’লে, “আপুনি মোলৈ এইটো কি কাম কৰিলে? ৰাহেলৰ কাৰণে মই জানো আপোনাৰ সেৱা কৰা নাছিলো? তেন্তে মোক কিয় ছলনা কৰিলে?” ");
INSERT INTO asmfb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","তেতিয়া লাবনে ক’লে, “ডাঙৰ জনীৰ আগেয়ে সৰু জনীক বিয়া দিয়া আমাৰ নিয়ম নাই। ");
INSERT INTO asmfb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","এতিয়া তুমি মোৰ এই ছোৱালীৰ বিবাহৰ উৎসৱ সপ্তাহ পূর্ণ কৰা। তুমি আৰু সাত বছৰ মোৰ সেৱা কৰিলে, আমি তোমাক আন জনীও দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","তেতিয়া যাকোবে সেইদৰেই কৰিলে আৰু লেয়াৰ সপ্তাহো সম্পূর্ণ কৰিলে। তাৰ পাছত লাবনে তেওঁৰ জীয়েক ৰাহেলকো তেওঁৰ লগত বিয়া দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","লাবনে তেওঁৰ দাসী বিলহাকো জীয়েক ৰাহেলক তেওঁৰ দাসী ৰূপে দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","এইদৰে যাকোবে ৰাহেলকো বিয়া কৰিলে; কিন্তু তেওঁ লেয়াতকৈ ৰাহেলক অধিক প্ৰেম কৰিলে; তাৰ পাছত তেওঁ আৰু সাত বছৰ খাটি লাবনৰ সেৱা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","যিহোৱাই লেয়াক অৱহেলা কৰা দেখি, তেওঁক গৰ্ভধাৰণৰ ক্ষমতা দিলে; কিন্তু ৰাহেল নিঃসন্তান হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","লেয়া গৰ্ভৱতী হৈ এটি পুত্ৰ সন্তানৰ জন্ম দিলে আৰু তাৰ নাম থলে ৰূবেণ পুত্ৰক চোৱা; কিয়নো তেওঁ ক’লে, “যিহোৱাই মোৰ দুখ দেখিলে, সেয়ে এতিয়া মোৰ স্বামীয়ে মোক প্ৰেম কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","তাৰ পাছত লেয়া পুনৰ গৰ্ভৱতী হ’ল আৰু তেওঁৰ এটি পুত্ৰ জন্মিল। তেওঁ ক’লে, “মোক অৱহেলা কৰাৰ কথা যিহোৱাই শুনিলে আৰু সেয়ে মোক এই ল’ৰাটিও দিলে।” তেওঁ সেই পুত্রৰ নাম চিমিয়োন শ্ৰৱণ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","পুনৰ তেওঁ গৰ্ভৱতী হৈ এটি পুত্ৰ প্ৰসৱ কৰিলে। তেওঁ ক’লে, “এইবাৰ মোৰ স্বামী মোত আসক্ত হ’ব; কিয়নো মই তেওঁলৈ তিনিটি পুত্ৰ প্ৰসৱ কৰিলোঁ।” এইবুলি তেওঁ ল’ৰাটোৰ নাম লেবী ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","তাৰ পাছত তেওঁ পুনৰায় গৰ্ভৱতী হৈ এটি পুত্ৰ প্ৰসৱ কৰিলে। তেওঁ ক’লে, “এইবাৰ মই যিহোৱাৰ প্ৰশংসা কৰিম।” সেয়ে তেওঁ ল’ৰাটোৰ নাম যিহূদা ৰাখিলে; তাৰ পাছত তেওঁৰ আৰু সন্তান জন্ম নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ৰাহেলে যেতিয়া দেখিলে যে তেওঁ যাকোবলৈ কোনো সন্তান জন্ম দিব পৰা নাই, তেতিয়া বায়েকক হিংসা কৰিবলৈ ধৰিলে। ৰাহেলে যাকোবক ক’লে, “মোক সন্তান দিয়া, নহ’লে মই মৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","তেতিয়া ৰাহেললৈ যাকোবৰ অতিশয় খং উঠিল। তেওঁ ক’লে, “যিজনে তোমাক গৰ্ভফল নিদিয়াকৈ ৰাখিছে, মই সেই ঈশ্বৰ নেকি?” ");
INSERT INTO asmfb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ৰাহেলে ক’লে, “চাওঁক, মোৰ দাসী বিলহা আছে; আপুনি তাইৰ সৈতে শয়ন কৰক যাতে তাই মোৰ কোলাত সন্তান দিব পাৰে আৰু মই তাইৰ দ্বাৰাই সন্তান লাভ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","তেতিয়া ৰাহেলে তেওঁৰ দাসী বিলহাৰ লগত যাকোবৰ বিয়া দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","তাতে বিলহা গৰ্ভৱতী হৈ যাকোবলৈ এটি পুত্ৰ প্ৰসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","তেতিয়া ৰাহেলে ক’লে, “ঈশ্বৰে মোৰ কথা শুনি সুবিচাৰ কৰিলে। তেওঁ নিশ্চয়কৈ মোৰ কাকুতি শুনিলে আৰু মোক এটি পুত্ৰ দিলে।” সেয়ে তেওঁ সেই পুত্রৰ নাম দান ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ৰাহেলৰ দাসী বিলহা পুনৰ্ব্বাৰ গৰ্ভৱতী হৈ যাকোবলৈ দ্বিতীয় পুত্ৰ প্রসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","তেতিয়া ৰাহেলে ক’লে, “মই মোৰ বাইদেউৰ সৈতে মালযুদ্ধ কৰি জয়ী থ’লো।” সেয়ে তেওঁ ল’ৰাটিৰ নাম নপ্তালী থলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","পাছত লেয়াই নিজে গর্ভধাৰণ কৰিবলৈ এৰা দেখি, তেৱোঁ নিজৰ দাসী জিল্পাক যাকোবৰ ভার্য্যা কৰি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","তাতে লেয়াৰ দাসী জিল্পাই যাকোবলৈ এটি পুত্ৰৰ জন্ম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","লেয়াই ক’লে, “ই কেনে সৌভাগ্য!” এইবুলি তেওঁ ল’ৰাটিৰ নাম গাদ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","তাৰ পাছত লেয়াৰ দাসী জিল্পাই যাকোবলৈ তেওঁৰ দ্বিতীয় পুত্ৰ জন্ম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","তাতে লেয়াই ক’লে, “মই সুখী! কিয়নো ছোৱালীবোৰে মোক সুখী বুলি ক’ব।” সেয়ে তেওঁ তাৰ নাম আচেৰ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","পাছত ঘেহুঁধান দোৱাৰ সময়ত, ৰূবেণে ওলাই গৈ পথাৰত দুদা ফল পাই তেওঁৰ মাক লেয়াক আনি দিলে; তেতিয়া ৰাহেলে লেয়াক ক’লে, “তোমাৰ পুত্রই অনা দুদা ফলৰ কেইটামান মোকো দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","তাতে লেয়াই তেওঁক ক’লে “তুমি মোৰ স্বামীকে ল’লা, ই জানো সৰু কথা? আকৌ এতিয়া মোৰ পুত্রই অনা দুদা ফলো তুমি ল’ব খোজানে?” তেতিয়া ৰাহেলে ক’লে, “তেন্তে তোমাৰ পুত্রই অনা দুদা ফলৰ সলনি তেওঁ আজি ৰাতি তোমাৰে সৈতে শয়ন কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","গধূলিপৰত যাকোব যেতিয়া পথাৰৰ পৰা উলটি আহিল লেয়াই বাহিৰলৈ আহি তেওঁক আগবঢ়ায় আনিবলৈ গ’ল। লেয়াই ক’লে, “তুমি আজি ৰাতি মোৰ লগত শয়ন কৰিব লাগে; কিয়নো মোৰ ল’ৰাই অনা দুদা ফল দি মই আপোনাৰ বেচ দিলোঁ।” তাতে সেই ৰাতি যাকোবে লেয়াৰ সৈতে শয়ন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ঈশ্বৰে লেয়াৰ প্ৰাৰ্থনা শুনিলে আৰু তেওঁ পুনৰ গৰ্ভৱতী হৈ যাকোবলৈ পঞ্চম পুত্ৰ প্রসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","তেতিয়া লেয়াই ক’লে, “মই মোৰ স্বামীক মোৰ দাসীক দিছিলোঁ আৰু সেয়ে, ঈশ্বৰে মোক তাৰ বেচ দিলে।” তাৰ কাৰণে তেওঁ পুত্রৰ নাম ইচাখৰ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","পাছত লেয়া আকৌ গৰ্ভৱতী হ’ল আৰু যাকোবলৈ তেওঁ ষষ্ঠ পুত্ৰ প্রসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","লেয়াই ক’লে, “ঈশ্বৰে মোক এক উত্তম উপহাৰ দিলে। এতিয়া মোৰ স্বামীয়ে মোক সন্মান কৰিব, কিয়নো মই তেওঁলৈ ছয়টি পুত্ৰ প্রসৱ কৰিলোঁ।” তাতে লেয়াই তেওঁৰ পুত্রৰ নাম জবূলূন ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","তাৰ পাছত তেওঁ এজনী ছোৱালী প্ৰসৱ কৰিলে আৰু তাইৰ নাম দীনা ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","পাছত ঈশ্বৰে ৰাহেলক সুঁৱৰিলে। ঈশ্বৰে ৰাহেলৰ প্ৰাৰ্থনা শুনিলে আৰু তেওঁকো গৰ্ভধাৰণৰ ক্ষমতা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","তাতে ৰাহেল গৰ্ভৱতী হ’ল আৰু তেওঁ এটি পুত্ৰ প্রসৱ কৰিলে। তেতিয়া তেওঁ ক’লে, “ঈশ্বৰে মোৰ অপযশ দূৰ কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","তেওঁ সন্তানৰ নাম যোচেফ ৰাখি ক’লে যে, “যিহোৱাই মোক আন এটি পুত্ৰ দান কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ৰাহেলে যোচেফক প্ৰসৱ কৰাৰ পাছত যাকোবে লাবনক ক’লে, “এতিয়া মোক বিদায় দিয়ক যাতে মই নিজৰ দেশ আৰু নিজৰ ঘৰলৈ যাব পাৰোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","মোৰ ভার্য্যা আৰু সন্তান সকলৰ কাৰণে মই আপোনাৰ সেৱা কৰিলোঁ। এতিয়া তেওঁলোকক লৈ মোক যাবলৈ দিয়ক। কিয়নো আপুনি নিজেই জানে মই কিভাৱে আপোনাৰ সেৱা কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","তেতিয়া লাবনে তেওঁক ক’লে, “যদিহে মই তোমাৰ দৃষ্টিত অনুগ্ৰহপ্ৰাপ্ত হৈছোঁ, তেন্তে থাকা। কাৰণ যিহোৱাই যে তোমাৰ কাৰণে মোক আশীৰ্ব্বাদ কৰিছে, তাক মই অনুমান কৰি বুজিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","তেওঁ আৰু ক’লে, “তোমাৰ বেচ তুমি নিৰূপণ কৰা, মই তাকে তোমাক দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","তেতিয়া যাকোবে তেওঁক ক’লে “মই কেনেকৈ আপোনাৰ সেৱা কৰিছোঁ আৰু মোৰ হাতত আপোনাৰ পশুৰ জাকবোৰৰ কি অৱস্থা হৈছে, তাক আপুনি জানে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","মই অহাৰ আগেয়ে আপোনাৰ পশুধন অলপ আছিল; কিন্তু এতিয়া সেইবোৰ বাঢ়ি গৈ প্রচুৰ হ’ল; মই যি যি ঠাইতে কাম কৰিলোঁ তাতেই যিহোৱাই আপোনাক আশীৰ্ব্বাদ কৰিলে। কিন্তু মোৰ নিজৰ পৰিয়ালৰ কাৰণেনো মই কেতিয়া কাম কৰিম?” ");
INSERT INTO asmfb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","তেতিয়া লাবনে ক’লে, “মই তোমাক কি বেচ দিম?” যাকোবে ক’লে, “আপুনি মোক একোকে দিব নালাগে। আপুনি যদি মোলৈ এই কাম কৰে, তেন্তে মই পুনৰ আপোনাৰ পশুৰ জাক চৰাম আৰু তাৰ যত্ন লম। ");
INSERT INTO asmfb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","আজি আপোনাৰ আটাইবোৰ পশুৰ জাকৰ মাজেদি মোক যাবলৈ দিয়ক। সেইবোৰৰ মাজৰ যিবোৰ মেৰ-ছাগৰ গাত ফুটুকা-ফুটুকী আৰু পখৰা-পখৰি দাগ আছে আৰু সকলো ক’লা বৰণৰ মেৰ-ছাগ আছে, মই বেলেগ কৰিম। আকৌ যি ছাগলী ফুটুকা-ফুটুকী আৰু পখৰা-পখৰি দাগ আছে, সেইবোৰকো বেলেগ কৰিম। সেয়ে মোৰ বেচ হব। ");
INSERT INTO asmfb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","তাতে ভৱিষ্যতে যেতিয়া আপুনি মোৰ বেচ চাবলৈ আহিব, তেতিয়া মোৰ ন্যায় কার্যই আপোনাৰ আগত মোৰ পক্ষে সাক্ষ্য দিব; ফুটুকা-ফুটুকী আৰু পখৰা-পখৰি দাগ নথকা, এনে কোনো ছাগলী আৰু ক’লা বৰণ নোহোৱা, এনে কোনো মেৰ-ছাগ যদি মোৰ ওচৰত পায়, সেয়ে মই চুৰ কৰা বুলি ধৰা হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","তেতিয়া লাবনে ক’লে, “বাৰু, তোমাৰ কথাৰ দৰেই হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","পাছত লাবনে সেই দিনাই পখৰা-পখৰি আৰু ফুটুকা-ফুটুকি দাগ থকা মতা ছাগলী আৰু পখৰা-পখৰি ও ফুটুকা-ফুটুকী মাইকী ছাগলীবোৰক অৰ্থাৎ যিবোৰৰ গাত বগা বৰণ আছিল সেইবোৰক আৰু ক’লা বৰণৰ মেৰ-ছাগবোৰক বেলেগ কৰি নিজৰ পুতেকসকলৰ হাতত সেইবোৰ গটাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","তাৰ পাছত তেওঁ যাকোবৰ ওচৰৰ পৰা তিনি দিনৰ পথৰ দূৰত্বলৈ আতৰি গ’ল আৰু যাকোবে লাবনৰ অৱশিষ্ট পশুৰ জাকবোৰ চৰাবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","তাৰ পাছত যাকোবে ঝাও, বাদাম আৰু অম্মোন গছৰ কেঁচা ডাল কাটি আনি সেইবোৰৰ বগা আঁচৰ ছাল গুছালে। তাতে ডালবোৰত থকা ভিতৰৰ বগা কাঠৰ আঁচ দেখা পোৱা গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","পশুৰ জাকবোৰে যেতিয়া পানী খাবলৈ আহে, তেতিয়া তেওঁ সেই ডালবোৰ লৈ সিহঁতৰ সন্মুখত পানী খোৱা পাত্রবোৰৰ মাজত থিয়কৈ থয়; তাতে পানী খাবলৈ আহোঁতে, সিহঁত গাভিনী হয়। ");
INSERT INTO asmfb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","এইদৰে সেই ডালবোৰৰ সন্মুখত মিলিত হোৱাৰ পাছত জাকবোৰ গাভিনী হয় আৰু সিহঁতে ফুটুকা-ফুটুকী ও পখৰা-পখৰি পোৱালি জগায়। ");
INSERT INTO asmfb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","যাকোবে মাইকী মেৰ-ছাগবোৰক বেলেগ কৰে আৰু পোৱালিবোৰক লৈ লাবনৰ আঁচ থকা পশুবোৰ আৰু ক’লা বৰণীয়া সকলো মেৰ-ছাগবোৰৰ মাজত ৰাখে; এইদৰে তেওঁ নিজৰ কাৰণে বেলেগে এক পশুপাল গঢ়ি তোলে আৰু সেইবোৰক তেওঁ লাবণৰ জাকৰ সৈতে মিলিবলৈ নিদিয়ে। ");
INSERT INTO asmfb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","যেতিয়া জাকত থকা স্বাস্থ্যবান মেৰ-ছাগবোৰ গাভিনী হয়, তেতিয়া যাকোবে সিহঁতৰ পানী খোৱা পাত্রৰ মাজত চকুৰ সম্মুখত সেই ডালবোৰ থয় যাতে সেই ডালবোৰৰ সন্মুখতে সিহঁত গাভিনী হয়। ");
INSERT INTO asmfb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","কিন্তু দুৰ্ব্বল পশুবোৰৰ আগত হ’লে নথয়; তাতে দুৰ্ব্বলবোৰ লাবনৰ আৰু বলী পশুবোৰ যাকোবৰ হয়। ");
INSERT INTO asmfb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","এইদৰে যাকোব অতিশয় ধনী লোক হৈ উঠিল। তেওঁৰ পশুধন, উট, গাধ আৰু দাস দাসীৰ সংখ্যা অধিকৰূপে বৃদ্ধি পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","পাছত যাকোবে শুনিলে, লাবনৰ পুতেকহঁতে এই কথা কৈ ফুৰিছে যে “যাকোবে আমাৰ পিতৃৰ সকলোবোৰ লৈছে আৰু আমাৰ পিতৃৰ সম্পদৰ পৰাহে সি ইমান ঐশ্বৰ্য্যশালী হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","যাকোবেও লক্ষ্য কৰিলে যে তেওঁৰ প্রতি লাবনৰ আগৰ সেই মনোভাৱ সলনি হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","তেতিয়া যিহোৱাই যাকোবক ক’লে, “তুমি তোমাৰ পূর্বপুৰুষসকলৰ দেশলৈ, নিজৰ আত্মীয়সকলৰ ওচৰলৈ উভটি যোৱা; মই তোমাৰ সঙ্গী হ’ম।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","তেতিয়া যাকোবে মানুহ পঠাই পথাৰত থকা নিজৰ জাকবোৰৰ ওচৰলৈ ৰাহেল আৰু লেয়াক মাতি আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","যাকোবে তেওঁলোকক ক’লে, “মই লক্ষ্য কৰিছোঁ মোৰ প্রতি তোমালোকৰ পিতৃৰ মনোভাৱ সলনি হৈছে, কিন্তু মোৰ পিতৃৰ ঈশ্বৰ হ’লে মোৰ সংগে সংগে আছে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","তোমালোকেতো জানাই যে মই মোৰ সকলো শক্তিৰে তোমালোকৰ পিতৃৰ সেৱা কার্য কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","তথাপিও তোমালোকৰ পিতৃয়ে মোক প্রতাৰনা কৰিলে আৰু মোৰ বেচ দহ বাৰকৈ সলনি কৰিলে। যিয়েই নহওঁক, ঈশ্বৰে মোৰ কোনো ক্ষতি কৰিবলৈ তেওঁক নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","যেতিয়া তেওঁ কৈছিল, ‘ফুটুকা-ফুটুকী পশুবোৰ তোমাৰ বেচ হ’ব’, তেতিয়া জাকৰ সকলো পশুৱেই ফুটুকা-ফুটুকী পোৱালি জগালে; আকৌ, তেওঁ যেতিয়া কৈছিল, আঁচ থকা পশুবোৰ তোমাৰ বেচ হ’ব, তেতিয়া জাকৰ সকলো পশুৱেই আঁচ থকা পোৱালি জগালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","এইদৰেই ঈশ্বৰে তোমালোকৰ পিতৃৰ পশুবোৰ নি মোক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","এবাৰ পশুবোৰ গাভিনী হোৱাৰ সময়ত মই এটা সপোন দেখিছিলোঁ। জাকৰ মাইকী ছাগলীবোৰৰ ওপৰত যিবোৰ মতা ছাগলী উঠিছে, সেই সকলোবোৰ আঁচ থকা, ফুটুকা-ফুটুকী আৰু পখৰা-পখৰী। ");
INSERT INTO asmfb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","তেতিয়া সপোনতে ঈশ্বৰৰ দূতে মোক মাতিলে, ‘হে যাকোব।’ মই ক’লোঁ, ‘কওঁক, মই ইয়াতে আছোঁ।’ ");
INSERT INTO asmfb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ঈশ্বৰে ক’লে, সৌৱা, চকু তুলি চোৱা, মাইকী ছাগলীবোৰৰ ওপৰত যিবোৰ মতা ছাগলী উঠিছে, সেইবোৰ আঁচ থকা, ফুটুকা-ফুটুকী আৰু পখৰা-পখৰী; কিয়নো লাবনে তোমালৈ যি যি কৰিছে, সেই সকলোকে মই দেখিছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ময়েই বৈৎএলৰ সেই ঈশ্বৰ, যি ঠাইত তুমি স্তম্ভৰ ওপৰত তেল ঢালি মোৰ ওচৰত সঙ্কল্প কৰি প্ৰতিজ্ঞা কৰিছিলা। এতিয়া এই ঠাই এৰি তোমাৰ জন্মস্থানলৈ উলটি যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","তাতে ৰাহেল আৰু লেয়াই তেওঁক ক’লে, “পিতৃৰ ঘৰত আমাৰ জানো কিবা ভাগ বা অধিকাৰ আছে? ");
INSERT INTO asmfb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","তেওঁ আমাক বিদেশীনীৰূপে গণ্য হোৱা নাই নে? কিয়নো তেওঁ আমাক বেচিলে আৰু বেচি পোৱা ধনকো তেওঁ গ্ৰাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","কাৰণ ঈশ্বৰে আমাৰ পিতৃৰ পৰা যি সকলো সম্পত্তি নিলে, সেই সকলোবোৰ এতিয়া নিশ্চয়ে আমাৰ আৰু আমাৰ সন্তান সকলৰ; গতিকে ঈশ্বৰে আপোনাক যি দৰে কৈছে আপুনি এতিয়া সেইদৰেই কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","তেতিয়া যাকোবে উঠি, তেওঁৰ সন্তান আৰু ভার্য্যা দুগৰাকীক উটত উঠালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","তেওঁ পদ্দন-অৰামত উপাৰ্জিত নিজৰ পশুধনবোৰকে আদি কৰি সকলো সম্পত্তি লৈ যাত্রা আৰম্ভ কৰিলে। তেওঁ কনান দেশলৈ নিজৰ পিতৃ ইচহাকৰ ওচৰলৈ ৰাওনা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","সেই সময়ত লাবনে তেওঁৰ মেৰ-ছাগবোৰৰ নোম কাটিবৰ কাৰণে গৈছিল আৰু সেই সুযোগতে ৰাহেলে তেওঁৰ বাপেকৰ গৃহ-দেৱতাবোৰ চুৰ কৰি নিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","যাকোবেও তেওঁৰ যোৱাৰ কথা অৰামীয়া লাবনক নজনাই তেওঁৰ প্রতি ছলনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","এইদৰে যাকোবে নিজৰ সকলো বয়-বস্তু লৈ পলাই গ’ল। তেওঁ সোনকালেই নদী পাৰ হৈ গিলিয়দৰ পৰ্ব্বতীয়া অঞ্চলৰ ফালে আগবাঢ়ি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","পাছত তৃতীয় দিনা লাবনে জানিব পাৰিলে যে যাকোব পলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","তেওঁ নিজৰ আত্মীয়স্বজনক লগত লৈ যাকোবৰ পাছে পাছে খেদি গৈ সাত দিনৰ পথ গ’ল আৰু গিলিয়দৰ পৰ্ব্বতীয়া অঞ্চলত তেওঁক লগ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","কিন্তু ঈশ্বৰে নিশা সপোনত অৰামীয়া লাবনৰ ওচৰলৈ আহি ক’লে, “সাৱধান, তুমি যাকোবক ভাল-বেয়া একোকে নক’বা।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","যাকোবৰ তম্বু পাহাৰৰ ওপৰত তৰা আছিল আৰু তাতেই লাবনে গৈ যাকোবক লগ ধৰিলে। লাবন আৰু তেওঁৰ আত্মীয়স্বজনসকলেও গিলিয়দৰ পাহাৰীয়া অঞ্চলত তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","পাছত লাবনে যাকোবক ক’লে, “তুমি এইয়া কি কৰিলা? কিয় মোক ঠগালা আৰু মোৰ ছোৱালীবোৰক যুদ্ধৰ বন্দীৰ দৰে লৈ আহিলা? ");
INSERT INTO asmfb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","কিয় চালাকি কৰি মোক নোকোৱাকৈ মনে মনে পলাই আহিলা? মোক কোৱা হ’লে আনন্দেৰে মই খঞ্জৰী আৰু বীণা-বাদ্যেৰে গান কৰি কৰি তোমালোকক বিদায় দিলোঁহেঁতেন? ");
INSERT INTO asmfb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","তুমি মোক মোৰ ছোৱালী আৰু নাতি-নাতিনীবোৰক বিদায় বেলাত চুমা খাবলৈকো নিদিলা। তুমি অজ্ঞানৰ দৰে কৰ্ম কৰিলা। ");
INSERT INTO asmfb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","তোমালোকৰ ক্ষতি কৰিবৰ ক্ষমতা মোৰ আছে, কিন্তু যোৱা ৰাতি তোমাৰ পিতৃৰ ঈশ্বৰে মোক এই কথা ক’লে, ‘সাৱধান, যাকোবক তুমি ভাল কি বেয়া একোকে নক’বা।’ ");
INSERT INTO asmfb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","এতিয়া তুমি তোমাৰ পিতৃৰ ঘৰলৈ যাবলৈ ইচ্ছা কৰাৰ কাৰণে তুমি ওলাই গৈছা; কিন্তু মোৰ দেৱ-দেৱীবোৰক কিয় চুৰ কৰি আনিলা?” ");
INSERT INTO asmfb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","তাতে যাকোবে উত্তৰত লাবনক ক’লে, “মোৰ ভয় লাগিছিল; কিয়নো মই ভাবিছিলোঁ যে আপুনি আপোনাৰ ছোৱালীক মোৰ পৰা বলেৰে কাঢ়ি ল’ব আৰু সেইবাবে মই গোপনে পলাই আহিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","কিন্তু আপোনাৰ দেৱ-দেৱীবোৰক যেয়ে চুৰ কৰি আনিছে, সি জীয়াই নেথাকিব; আমাৰ বস্তুবোৰৰ মাজত যদি আপোনাৰ কিবা বস্তু আছে, তেন্তে আমাৰ উভয়ৰ আত্মীয়-স্বজনৰ সন্মুখতে তাক বিচাৰি লওঁক।” কিয়নো সেই দেৱ-দেৱীৰ মূর্তিবোৰ যে ৰাহেলে চুৰ কৰি আনিছিল, তাক যাকোবে জনা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","তেতিয়া লাবনে এটা এটাকৈ যাকোব, লেয়া আৰু দুজনী দাসীৰ তম্বুত সোমাল, কিন্তু তাত তেওঁ সেইবোৰ নাপালে; তেওঁ লেয়াৰ তম্বুৰ পৰা ওলাই ৰাহেলৰ তম্বুত সোমালগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","কিন্তু ৰাহেলে সেই মূর্তিবোৰ নি উটৰ গাদিৰ ভিতৰত সুমুৱাই থৈছিল আৰু তেওঁ নিজে সেই গাদিৰ ওপৰত বহি আছিল। লাবনে তম্বুৰ সকলো ঠাইতে তন্নতন্নকৈ বিচাৰিলে, কিন্তু তাতো সেইবোৰ নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ৰাহেলে বাপেকক ক’লে, “মই আপোনাৰ আগত উঠি থিয় হ’ব নোৱাৰাৰ কাৰণে মোৰ প্ৰভু ক্রোধিত নহব। কিয়নো মোৰ মাহেকীয়া হৈছে।” সেয়ে লাবনে বিচাৰিলতো সেই মূর্তিবোৰ নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","তেতিয়া যাকোবৰ খং উঠিল আৰু লাবনৰ সৈতে বিবাদ কৰিবলৈ ধৰিলে। যাকোবে লাবনক ক’লে, “মোৰ অপৰাধেই বা কি আৰু মইনো কি পাপ কৰিলোঁ যে, আপুনি প্ৰজ্বলিত হৈ মোৰ পাছত খেদি আহিছে? ");
INSERT INTO asmfb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","মোৰ সকলো বস্তু তন্নতন্নকৈ খেপিয়াই চাই আপোনাৰ ঘৰৰ কি বস্তু পালে? যদিহে পালে, তাক ইয়াত, আমাৰ উভয়ৰ আত্মীয়স্বজনৰ আগত ৰাখক যাতে তেওঁলোকে আমাৰ দুয়ো পক্ষৰে মাজত বিচাৰ কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","মই আপোনাৰ লগত বিশ বছৰ ধৰি আছিলোঁ। এই কালছোৱাত আপোনাৰ কোনো মাইকী মেৰ-ছাগ বা ছাগলীৰ গর্ভফল বিনষ্ট হোৱা নাছিল নাইবা আপোনাৰ জাকৰ কোনো এটা মতা মেৰ-ছাগো মই মাৰি খোৱা নাছিলো। ");
INSERT INTO asmfb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","এনেকি বন্য জন্তুৱে মৰা কোনো পশুও মই আপোনাৰ ওচৰলৈ অনা নাছিলো; সেই ক্ষতি মই নিজেই বহন কৰিছিলোঁ; কিন্তু কোনো পশু চুৰ হ’লে - সেইয়া দিনতেই হওঁক বা ৰাতিয়েই হওঁক, আপুনি তাৰ ক্ষতিপূৰণ মোৰ পৰা আদায় কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","মই দিনৰ গৰমত পুৰিছিলো আৰু ৰাতিৰ ঠাণ্ডাত কঁপিছিলো, মোৰ চকুত টোপনি নাছিল; তাত মোৰ অৱস্থা এয়ে আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","এই যি বিশ বছৰ মই আপোনাৰ ঘৰত আছিলোঁ, তাৰ চৌদ্ধ বছৰ মই আপোনাৰ দুজনী ছোৱালীৰ কাৰণে আপোনাৰ সেৱা কৰিছিলোঁ আৰু ছয় বছৰ কটালোঁ আপোনাৰ পশুজাকৰ পাছত। তাৰ মাজতে আপুনি মোৰ বেচ দহবাৰ সলনি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","মোৰ পিতৃ ঈশ্বৰ, যিজন অব্ৰাহামৰ ঈশ্বৰ আৰু ইচহাকৰ ভয়ৰ পাত্র, তেওঁ মোৰ সঙ্গী নোহোৱা হলে, আপুনি নিশ্চয়ে মোক আজি শুদা-হাতেই বিদায় দিলেহেঁতেন। ঈশ্বৰে মোৰ দুখ আৰু কঠোৰ পৰিশ্ৰমলৈ দৃষ্টি কৰিলে। সেইবাবেই যোৱা ৰাতি তেওঁ আপোনাক ধমকি দিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","এই কথাত লাবনে যাকোবক উত্তৰ দি ক’লে, “ছোৱালীকেইজনী মোৰেই ছোৱালী, সন্তানবোৰ মোৰ নাতি-নাতিনী আৰু এই পশুৰ জাকবোৰো মোৰ পশুৰ জাক। তুমি যি সকলো দেখিছা, সেই সকলোবোৰ মোৰেই। তথাপিও মই আজি মোৰ এই ছোৱালী বা সিহঁতৰ সন্তানবোৰলৈ কি কৰিব পাৰোঁ? ");
INSERT INTO asmfb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","সেয়ে এতিয়া আহাঁ, আমি দুজনে এটি চুক্তি কৰোঁহক যি তোমাৰ আৰু মোৰ মাজত সাক্ষী হৈ থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","তেতিয়া যাকোবে এটা শিল আনি তাক স্তম্ভস্বৰূপে স্থাপন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","যাকোবে তেওঁৰ আত্মীয়সকলক ক’লে “আপোনালোকে শিলবোৰ গোটাওক।” তেতিয়া তেওঁলোকে শিলবোৰ আনি এটা স্তূপ বনালে আৰু সকলোৱে সেই স্তূপৰ কাষতে ভোজনপান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","লাবনে সেই স্তূপৰ নাম যিগৰ-চাহদুথা ৰাখিলে; কিন্তু যাকোবে হ’লে, তাৰ নাম গলেদ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","তেতিয়া লাবনে ক’লে, “এই স্তূপেই আজি তোমাৰে মোৰে মাজত সাক্ষী হৈছে।” এই হেতুকে এই স্তূপৰ নাম গলেদ ৰখা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","তাৰ উপৰি ইয়াৰ নাম মিস্পাও ৰখা হ’ল, কিয়নো লাবনে ক’লে, “আমি ইজনে সিজনে চকুৰ আঁতৰা-আঁতৰি হ’লে, যিহোৱাই তোমাৰ আৰু মোৰ মাজত পৰ দি থাকক। ");
INSERT INTO asmfb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","তুমি যদি মোৰ ছোৱালী দুজনীক বেয়া ব্যৱহাৰ কৰা নাইবা মোৰ ছোৱালীবোৰ থকাতো আন মহিলাক গ্রহণ কৰা, তেতিয়া যদিও আমাৰ ওচৰত কোনো মানুহ নাথাকিব, কিন্তু মনত ৰাখিবা ঈশ্বৰ তোমাৰ আৰু মোৰ মাজত সাক্ষী হৈ থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","লাবনে যাকোবক আৰু ক’লে, “এই স্তূপটোলৈ চোৱা আৰু এই যি স্তম্ভটো মই তোমাৰ আৰু মোৰ মাজত স্থাপন কৰিলোঁ, তাৰ ফালেও চোৱা; ");
INSERT INTO asmfb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","এই স্তূপ আৰু স্তম্ভ দুয়োটাই এই কথাৰ সাক্ষী হৈ থাকিল যে, এই স্তূপ পাৰ হৈ মই তোমাৰ অপকাৰ কৰিবলৈ নাযাওঁ আৰু তুমিও এই স্তূপ আৰু স্তম্ভ পাৰ হৈ মোৰ অপকাৰ কৰিবলৈ নাহিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","তেনে কৰিলে অব্ৰাহামৰ ঈশ্বৰ আৰু নাহোৰ ও তেওঁলোকৰ পিতৃৰো ঈশ্বৰে যেন আমাৰ বিচাৰ কৰে।” তেতিয়া যাকোবে তেওঁৰ পিতৃ ইচহাকে ভয় ৰখা ঈশ্বৰৰ নামেৰে শপত খালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","তাৰ পাছত যাকোবে সেই পৰ্ব্বতত পশুবলি উৎসর্গ কৰিলে আৰু তেওঁৰ আত্মীয়সকলক ভোজন কৰিবলৈ মাতিলে; তাতে তেওঁলোকে ভোজন কৰি সেই পৰ্ব্বততে ৰাতিটো কটালে। ");
INSERT INTO asmfb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","পাছদিনা পুৱাতে উঠি লাবনে তেওঁৰ জীয়েক আৰু নাতি-নাতিনীক চুমা খাই আশীৰ্ব্বাদ কৰিলে। তাৰ পাছত লাবনে প্ৰস্থান কৰি নিজৰ ঘৰলৈ উভটি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","পাছত যাকোবেও নিজৰ পথত যাত্রা কৰিলে। বাটত ঈশ্বৰৰ দূতবোৰে তেওঁৰ লগত সাক্ষাৎ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","তেওঁলোকক দেখি যাকোবে ক’লে, “এইয়া ঈশ্বৰৰ শিবিৰ।” সেই কাৰণে তেওঁ সেই ঠাইৰ নাম মহনয়িম ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","যাকোবে তেওঁৰ আগে আগে চেয়ীৰ, অর্থাৎ ইদোমৰ অঞ্চললৈ তেওঁৰ ককায়েক এচৌৰ ওচৰলৈ কেইজনমান বার্তাবাহকক পঠালে, ");
INSERT INTO asmfb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","তেওঁ তেওঁলোকক এই বুলি আজ্ঞা দিলে, “তোমালোকে মোৰ মালিক এচৌক জনাবা যে তেওঁৰ দাস যাকোবে এই দৰে কৈ পঠাইছে, মই আজিলৈকে লাবনৰ সৈতে আছিলোঁ।। ");
INSERT INTO asmfb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","মোৰ গৰু, গাধ, মেৰ-ছাগ আৰু ছাগলী আদি পশু আৰু দাস-দাসী সকলো আছে। সেয়ে মই মোৰ প্ৰভুৰ ওচৰলৈ আগতীয়াকৈ সংবাদ পঠাইছো মই যেন আপোনাৰ দৃষ্টিত অনুগ্ৰহ পাওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","বার্তাবাহকসকলে যাকোবৰ ওচৰলৈ উলটি আহি ক’লে, “আমি আপোনাৰ ককাই এচৌৰ তালৈ গৈছিলোঁ। তেওঁ চাৰিশ মানুহ লগত লৈ আপোনাৰে সৈতে সাক্ষাৎ কৰিবলৈ আহিছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","তাতে যাকোবে অতিশয় ভয় খালে আৰু তেওঁৰ মন অস্থিৰ হৈ পৰিল। সেয়ে তেওঁ তেওঁৰ লগত থকা লোকসকলক, গৰু, গাধ, মেৰ-ছাগ আৰু ছাগলী, উট আদি পশুৰ জাকবোৰক দুটা দলত ভাগ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","তেওঁ ক’লে, “এচৌৱে যদি আহি এটা দলক আক্রমণ কৰে, তেন্তে আনটো দলে পলাব পাৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","যাকোবে এইবুলি প্রার্থনা কৰিলে, “হে যিহোৱা, মোৰ পূর্বপুৰুষ অব্ৰাহামৰ ঈশ্বৰ আৰু মোৰ পিতৃ ইচহাকৰো ঈশ্বৰ, তুমি মোক কৈছিলা, ‘তোমাৰ দেশ আৰু তোমাৰ লোকসকলৰ ওচৰলৈ উভতি যোৱা। মই তোমাৰ মঙ্গল কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","আপোনাৰ এই দাসক আপুনি যে সকলো কৰুণা আৰু বিশ্বস্ততা দেখুৱাইছে, মই তাৰ এফেৰিও যোগ্য নহওঁ; কিয়নো মই কেৱল এডাল লাখুটি লৈয়েই এই যৰ্দ্দন নদী পাৰ হৈ গৈছিলোঁ; কিন্তু এতিয়া মোৰ দুটা দল হৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","মই মিনতি কৰোঁ, মোৰ ককাই এচৌৰ হাতৰ পৰা মোক ৰক্ষা কৰক। কিয়নো মোৰ ভয় লাগিছে যে তেওঁ আহি মোৰ লগতে মাক আৰু সন্তান সকলকো বধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","কিন্তু আপুনি কৈছিলে, ‘মই নিশ্চয়ে তোমাৰ মঙ্গল কৰিম; তোমাৰ বংশ সাগৰৰ তীৰৰ বালিৰ দৰে কৰিম যাক গণি শেষ কৰিব নোৱাৰিব।’” ");
INSERT INTO asmfb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","যাকোবে সেই ঠাইতে ৰাতিটো কটালে। তেওঁৰ যি আছিল তাৰ পৰাই কিছু লৈ ককায়েক এচৌৰ কাৰণে এক উপহাৰ স্বৰূপে ঠিক কৰি ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","দুশ মাইকী ছাগলী আৰু বিশটা মতা ছাগলী, দুশ মাইকী মেৰ-ছাগ আৰু বিশটা মতা মেৰ-ছাগ, ");
INSERT INTO asmfb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","পোৱালিয়ে সৈতে ত্ৰিশ জনী খিৰতী উট, চল্লিশ জনী গাই গৰু আৰু দহোটা ভতৰা গৰু, বিশ জনী গাধী আৰু দহোটা গাধ এই সকলোকে ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","সেইবোৰক জাক জাক কৰি দাসবোৰৰ হাতত শোধাই দি এই আজ্ঞা দিলে, “তোমালোক মোৰ আগেয়ে যোৱা আৰু প্রত্যেকটো জাকৰ মাজত কিছু ঠাই ৰাখি ৰাখি যাবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","তেওঁ প্ৰথমটো দলৰ দাসক এই আজ্ঞা দিলে, “মোৰ ককাই এচৌৰ লগত দেখা হ’লে তেওঁ তোমাক যেতিয়া সুধিব, ‘তুমি ক’ৰ মানুহ? তুমি কলৈ গৈ আছা? তোমাৰ আগত থকা সেই পশুবোৰ কাৰ?’ ");
INSERT INTO asmfb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","তেতিয়া তুমি ক’বা, ‘সেইবোৰ আপোনাৰ দাস যাকোবৰ; তেওঁ মোৰ মালিক এচৌলৈ এই উপহাৰ পঠাইছে। তেৱোঁ আমাৰ পাছে পাছে আহি আছে।’” ");
INSERT INTO asmfb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","এইদৰে যাকোবে দ্বিতীয়, তৃতীয় আৰু জাকবোৰৰ পাছত যোৱা আন আন সকলোকে এই আজ্ঞা দিলে, “তোমালোকেও এচৌক ল’গ পালে ঠিক এই কথাকে কবা। ");
INSERT INTO asmfb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","তোমালোকেও কবা, ‘আপোনাৰ দাস যাকোবও আমাৰ পাছত আহি আছে।’” কিয়নো যাকোবে ভাবিলে, “মোৰ আগে আগে যি উপহাৰবোৰ গৈছে, তাৰ দ্বাৰাই মই তেওঁক শান্ত কৰিম। পাছত যেতিয়া মোৰ তেওঁৰে সৈতে দেখাদেখি হব, তেতিয়া হয়তো তেওঁ মোক গ্রহণ কৰি লব।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","এইদৰে তেওঁৰ আগে আগে উপহাৰবোৰ গ’ল; কিন্তু তেওঁ নিজে সেই ৰাতি তেওঁৰ ছাউনিতে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","সেই ৰাতিয়েই যাকোবে উঠি তেওঁৰ দুজনী ভাৰ্যা, দুজনী দাসী আৰু তেওঁৰ এঘাৰজন পুত্রক লৈ খোজকাঢ়ি পাৰ হব পৰা এনে এক খৰাং ঠাইয়েদি যব্বোক নদীৰ সিপাৰে পঠালে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","এইদৰে তেওঁৰ যি যি আছিল সেই সকলো বস্তুও তেওঁলোকৰ লগত সিপাৰলৈ পঠাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","তাতে যাকোব সেই ঠাইত অকলে থাকিল। তেতিয়া এজন পুৰুষে আহি ৰাতিপুৱা নোহোৱা পর্যন্ত তেওঁৰ সৈতে মল্লযুদ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","সেই পুৰুষে যেতিয়া দেখিলে যে তেওঁ যাকোবক পৰাজয় কৰিব পৰা নাই, তেতিয়া তেওঁ যাকোবৰ কৰঙনৰ জোৰাত আঘাত কৰিলে; তাতে তেওঁৰ কৰঙনৰ হাড়ৰ জোৰা লৰিল। ");
INSERT INTO asmfb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","পুৰুষ জনে ক’লে, “ৰাতিপুৱা হৈ আহিছে, মোক এৰি দিয়া।” যাকোবে ক’লে, “আপুনি মোক আশীৰ্ব্বাদ নকৰা পর্যন্ত মই আপোনাক এৰি নিদিওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","পুৰুষজনে তেওঁক ক’লে, “তোমাৰ নাম কি?” তেওঁ ক’লে, “যাকোব।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","পুৰুষজনে ক’লে, “তুমি ঈশ্বৰ আৰু মানুহৰ সৈতে যুদ্ধ কৰি বিজয়ী হলা; সেয়ে তোমাক আৰু যাকোব নামেৰে মতা নহ’ব, কিন্তু ইস্ৰায়েল বুলিহে মতা হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","যাকোবে তেওঁক সুধিলে, “আপোনাৰ নামটোনো কি অনুগ্রহ কৰি মোক কওঁক।” তাতে তেওঁ ক’লে, “তুমি মোৰ নাম কিয় সুধিছা?” এই কথা কৈয়ে তেওঁ যাকোবক সেই ঠাইতে আশীৰ্ব্বাদ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","তেতিয়া যাকোবে সেই ঠাইৰ নাম পনীয়েল ৰাখিলে। তেওঁ ক’লে, “মই ঈশ্বৰক সন্মুখা-সন্মুখিকৈ দেখা পালতো, মই জীয়াই আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","যাকোবে পনুৱেল পাৰ হৈ যাওঁতে সূর্য উদয় হ’ল; কৰঙনৰ হাড়ৰ জোৰা লৰাৰ কাৰণে তেওঁ লেকেচিয়াবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","সেই কাৰণে ইস্ৰায়েলৰ লোকসকলে আজিও কৰঙনৰ জোৰাৰ পেশীৰ মাংস নাখায়, কাৰণ সেই পুৰুষে যাকোবৰ কৰঙনৰ জোৰা লৰাই পেশীবোৰ আঘাত কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","তাৰ পাছত যাকোবে দেখিলে যে, এচৌৱে চাৰিশ মানুহ লগত লৈ আগুৱাই আহি আছে। তেওঁ তেতিয়া লেয়া, ৰাহেল, আৰু দুজনী দাসীৰ মাজত সন্তান সকলক ভাগ কৰি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","দুয়োজনী দাসী আৰু তেওঁলোকৰ সন্তান সকলক তেওঁ প্রথমতে ৰাখিলে, তাৰ পাছত ৰাখিলে লেয়া আৰু তেওঁৰ সন্তান সকলক। অৱশেষত ৰাহেল আৰু যোচেফক ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","তেওঁ নিজে সকলোৰে আগে আগে গ’ল। ককায়েকৰ ওচৰ নোপোৱালৈকে তেওঁ মাটিত উবুৰি হৈ সাতবাৰ প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","তেতিয়া এচৌৱে তেওঁৰ ওচৰলৈ দৌৰি আহি তেওঁক সাৱটি ধৰিলে; ডিঙিত ধৰি সাৱটি চুমা খালে আৰু তাৰ পাছত দুয়োৱে কান্দিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","পাছত এচৌৱে চকু তুলি মহিলা আৰু সন্তান সকলক দেখি সুধিলে, “তোমাৰ লগত এওঁলোক কোন?” যাকোবে ক’লে “ঈশ্বৰে অনুগ্ৰহ কৰি আপোনাৰ দাসক এই সকলো সন্তান দিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","তেতিয়া দাসী দুজনীয়ে নিজৰ সন্তান সকলৰ সৈতে আগবাঢ়ি গৈ প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","তাৰ পাছত লেয়াই তেওঁৰ সন্তান সকলক লৈ আগবাঢ়ি আহি প্ৰণিপাত কৰিলে; শেষত যোচেফ আৰু ৰাহেলেও আগুৱাই গৈ প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","এচৌৱে ক’লে, “মই যি দলবোৰক লগ পালোঁ, সেই সকলো কিহৰ বাবে?” যাকোবে ক’লে, “সেইবোৰ মোৰ মালিকৰ দৃষ্টিত অনুগ্ৰহ পাবৰ বাবে।” ");
INSERT INTO asmfb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","তেতিয়া এচৌৱে ক’লে, “ভাই, মোৰ যথেষ্ট আছে; তোমাৰ যি আছে, সেয়া তোমালৈকো থাকক।” ");
INSERT INTO asmfb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","যাকোবে ক’লে, “নহয় নহয়, মই মিনতি কৰি কৈছো, যদি আপোনাৰ দৃষ্টিত মই অনুগ্ৰহ পাইছোঁ, তেন্তে মোৰ হাতৰ পৰা উপহাৰ গ্ৰহণ কৰক। কিয়নো, আপুনি মোক গ্রহণ কৰিছে আৰু অৱশ্যেই মোৰ বাবে অাপোনাৰ মুখ দেখা ঈশ্বৰৰ মুখ দেখাৰ দৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","বিনয় কৰোঁ, আপোনালৈ অনা মোৰ উপহাৰ গ্ৰহণ কৰক; কিয়নো ঈশ্বৰে মোক প্রচুৰ দয়া কৰিছে আৰু মোৰ যথেষ্ট আছে।” যাকোবে এইদৰে কাবৌকাকুতি কৰাত এচৌৱে তাক গ্রহণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","পাছত এচৌৱে ক’লে, “আহাঁ, আমি আমাৰ পথত যাওঁহঁক। মই তোমাৰ আগে আগে যাম।” ");
INSERT INTO asmfb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","যাকোবে তেওঁক ক’লে, “মোৰ মালিকেতো জানেই যে, এই ল’ৰা-ছোৱালীবোৰৰ বয়স বেচি নহয় আৰু মোৰ লগত থকা মেৰ-ছাগ গৰুৰ জাকবোৰৰ পিয়াহ খোৱা পোৱালিও আছে। যদি ততাতৈয়া কৰি সিহঁতক এটা দিনো লৈ যোৱা হয়, তেন্তে আটাইবোৰেই মৰি যাব। ");
INSERT INTO asmfb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","তাতোকৈ বৰং মোৰ মালিকে তেওঁৰ এই দাসৰ আগেয়ে যাওঁক; মই চেয়ীৰত মোৰ প্ৰভুৰ ওচৰলৈ গৈ নাপাওঁমানে, মোৰ আগত থকা পশুধন আৰু ল’ৰা-ছোৱালীবোৰে যাব পৰাকৈ মই অধিক ধীৰে ধীৰে যাব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","এচৌৱে ক’লে, “তেন্তে মোৰ লগৰ কিছুমান মানুহ তোমাৰ লগত থৈ যাওঁ।” কিন্তু যাকোবে ক’লে, “তাৰ কি প্রয়োজন? মোৰ মালিকৰ পৰা মই যি দয়া পাইছো, সেয়ে মোলৈ যথেষ্ট।” ");
INSERT INTO asmfb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","পাছত এচৌৱে সেই দিনাই চেয়ীৰৰ ফাললৈ নিজ বাটেদি উভটি গ’ল; ");
INSERT INTO asmfb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","যাকোবে যাত্রা কৰি চুক্কোতলৈ গ’ল। তেওঁ নিজৰ কাৰণে তাত এটা ঘৰ সাজিলে আৰু তেওঁৰ পশুবোৰৰ কাৰণে আশ্রয়ৰ চালিঘৰ সাজিলে; এই নিমিত্তে সেই ঠাইৰ নাম চুক্কোৎ চালিঘৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","পদ্দন-অৰামৰ পৰা যাকোবে কুশলে আহি কনান দেশৰ চিখিম নগৰ পালে। তাত তেওঁ নগৰৰ ওচৰত নিজৰ তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","পাছত তেওঁ নিজৰ তম্বু তৰা মাতি ডোখৰ চিখিমৰ বাপেক হমোৰৰ সন্তান সকলৰ পৰা কিনি ললে। ");
INSERT INTO asmfb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","সেই ঠাইত তেওঁ এটা যজ্ঞবেদি স্থাপন কৰি তাৰ নাম এল-এলোহে ইস্ৰায়েল ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","লেয়াৰ গৰ্ভত দীনা নামেৰে যাকোবৰ যিগৰাকী ছোৱালীৰ জন্ম হৈছিল, তাই এদিন সেই ঠাইৰ ছোৱালীবোৰৰ লগত দেখা কৰিবলৈ ওলাই গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","তেতিয়া চিখিম নামৰ সেই দেশৰ ৰজা হিব্বীয়া হমোৰৰ পুতেকে তাইক দেখা পালে। চিখিমে দীনাক ধৰি নি বেয়া ব্যৱহাৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","চিখিম যাকোবৰ জীয়েক দীনাৰ প্রেমত পৰি আকৰ্ষিত হৈছিল; তেওঁ দীনাক ভাল পাইছিল আৰু তাইৰ লগত মৰমেৰে কথা পাতিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","চিখিমে নিজৰ বাপেক হমোৰক ক’লে, “আপুনি এই ছোৱালীগৰাকীক মোক বিয়া কৰাই দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","জীয়েক দীনাক যে সেই ল’ৰাজনে বেয়া ব্যৱহাৰ কৰিলে, যাকোবৰ কাণত পৰিল। সেই সময়ত যাকোবৰ পুত্ৰসকল পথাৰত পশুধন চৰাবলৈ গৈছিল; সেয়ে তেওঁলোক আহি নোপোৱালৈকে যাকোব মনে মনে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","চিখিমৰ বাপেক হমোৰ যাকোবৰে সৈতে কথা-বতৰা হ’বলৈ ওলাই আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","এই বিষয়ে শুনি যাকোবৰ পুত্ৰসকল পথাৰৰ পৰা আহিল; তেওঁলোকে মনত যিমান কষ্ট পালে, সিমান বেছিকৈ খঙত জ্বলিও উঠিল। কিয়নো যাকোবৰ জীয়েকৰ প্রতি বেয়া ব্যৱহাৰ কৰি চিখিমে ইস্ৰায়েলৰ প্রতি এক অপমানৰ কার্য কৰিলে, যি কৰা তেওঁৰ উচিত নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","হমোৰে তেওঁলোক সকলোকে ক’লে, “মোৰ পুত্র চিখিমে আপোনালোকৰ ছোৱালীক ভাল পায়। অনুগ্রহ কৰি তাইক আপোনালোকে মোৰ পুত্ৰলৈ বিয়া দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ইয়াৰ দ্বাৰা আপোনালোকৰ সৈতে আমাৰ বিবাহৰ এক ব্যৱস্থা হ’ব। আপোনালোকৰ জীয়ৰী আমালৈ দিয়ক আৰু আমাৰ জীয়ৰীকো আপোনালোকে বিয়া কৰি গ্ৰহণ কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","আপোনালোকে আমাৰ মাজতে বাস কৰক। আপোনালোকৰ কাৰণে এই দেশ মুকলি হৈ আছে; ইয়াতেই থাকি বেহা বেপাৰ কৰি ঐশ্বৰ্য্যৱন্ত হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","চিখিমেও দীনাৰ বাপেক আৰু ভায়েক ককায়েকসকলক ক’লে, “আপোনালোকে মোলৈ এই অনুগ্ৰহ দান কৰক; আপোনালোকে মোক যিহকে কব, মই তাকে কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","বিয়াৰ ধন আৰু উপহাৰ হিচাবে আপোনালোকে যিহকে দাবী কৰিব, মই সেই সকলো আপোনালোকক দিম; আপোনালোকে মাথোন ছোৱালীজনীক মোৰ লগত বিয়া দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","যিহেতু চিখিমে তেওঁলোকৰ ভনীয়েক দীনাক ভ্রষ্ট কৰিলে, সেয়ে যাকোবৰ পুত্রসকলে চিখিম আৰু তেওঁৰ বাপেক হমোৰক ছলনাৰে উত্তৰ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","তেওঁলোকে ক’লে, “আমি এনে কাম কৰিব নোৱাৰোঁ; যাৰ চুন্নৎ কৰা হোৱা নাই, এনে কাৰো লগত আমাৰ ভনীক বিয়া দিয়াটো আমাৰ বাবে অসন্মানৰ বিষয়। ");
INSERT INTO asmfb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","কেৱল এটা কাৰ্য কৰিলে আমি আপোনালোকৰ কথাত মান্তি হ’ব পাৰোঁ; সেয়া হৈছে আপোনালোকৰ প্রত্যেকজন পুৰুষে আমাৰ নিচিনাকৈ চুন্নৎ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","তেতিয়া আমি আপোনালোকলৈ আমাৰ ছোৱালী দিম; আপোনালোকৰ ছোৱালীবোৰকো আমি গ্ৰহণ কৰিম আৰু আমি আপোনালোকৰ সৈতে নিবাস কৰি এক জাতি হ’ম। ");
INSERT INTO asmfb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","কিন্তু যদি আপোনালোকে আমাৰ কথা নুশুনে আৰু চুন্নৎ হবলৈ মান্তি নহয়, তেনেহলে আমাৰ ছোৱালীক লৈ আমি ইয়াৰ পৰা গুচি যাম।” ");
INSERT INTO asmfb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","তেওঁলোকৰ কথাত হমোৰ আৰু তেওঁৰ পুতেক চিখিমে সন্তোষ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","পৰিয়ালৰ সকলোতকৈ সন্মানীত ব্যক্তি যুবক চিখিমে পলম নকৰি তেওঁলোকে কোৱা কথাত সন্মতি জনালে; কাৰণ তেওঁ যাকোবৰ জীয়েকক বৰ ভাল পাইছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","পাছত হমোৰ আৰু তেওঁৰ পুতেক চিখিমে তেওঁলোকৰ নগৰৰ দুৱাৰ মুখলৈ গৈ নগৰৰ লোক সকলৰ সৈতে কথোপকথন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","তেওঁলোকে ক’লে, “এই লোকসকল আমাৰ সৈতে মিলেৰে আছে; তেওঁলোক থাকিবৰ কাৰণে আমাৰ দেশত যথেষ্ট এক বৃস্তিত ঠাই আছে। তেওঁলোক ইয়াতেই থাকক আৰু বেহা-বেপাৰ কৰক। আমি তেওঁলোকৰ ছোৱালীবোৰক বিয়া কৰাই আনিম আৰু আমাৰ ছোৱালীকো তেওঁলোকলৈ দিম। ");
INSERT INTO asmfb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","কিন্তু মাথোন এটা কথাহে আছে, তেওঁলোক যেনেকৈ চুন্নৎ হোৱা লোক, আমি প্ৰত্যেক পুৰুষেও তেনেকৈ চুন্নৎ হলেহে তেওঁলোক আমাৰ কথাত আমাৰ মাজত নিবাস কৰি এক জাতি হ’বলৈ মান্তি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","তেওঁলোকৰ পশুধন আৰু সা-সম্পত্তি - অর্থাৎ সকলো জীৱ-জন্তুৱেই জানো আমাৰ নহ’ব? গতিকে আহঁক, আমি তেওঁলোকৰ সেই কথাত মান্তি হওঁহক; তাতে তেওঁলোকে আমাৰে সৈতে বাস কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","তেতিয়া নগৰৰ সকলো মানুহে হমোৰ আৰু তেওঁৰ পুতেক চিখিমৰ কথাত মান্তি হ’ল আৰু প্ৰত্যেক পুৰুষৰ চুন্নৎ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","তাৰ পাছত তৃতীয় দিনা যেতিয়া পুৰুষসকলে বিষত কষ্ট পাই আছিল, তেতিয়া দীনাৰ ককায়েক অর্থাৎ যাকোবৰ দুজন পুতেক চিমিয়োন আৰু লেবীয়ে তৰোৱাল লৈ হঠাৎ নগৰত সোমাই সকলো পুৰুষক বধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","তেওঁলোকে হমোৰ আৰু চিখিমক তৰোৱালৰ ধাৰেৰে বধ কৰিলে আৰু চিখিমৰ ঘৰৰ পৰা দীনাক উলিয়াই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ভনীয়েকক ভ্রষ্ট কৰাৰ কাৰণে যাকোবৰ আন আন পুত্ৰসকলেও হত হোৱা লোকসকলৰ কাষলৈ গৈ নগৰখন লুটপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","নগৰৰ ভিতৰত আৰু পথাৰত চৰি থকা তেওঁলোকৰ যিমান মেৰ-ছাগ, ছাগলী, গৰু, গাধ আদি আছিল, সেই সকলো তেওঁলোকে লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","তেওঁলোকে লোকসকলৰ ধন-সম্পদ, ভার্য্যা আৰু তেওঁলোকৰ শিশুসকলক বন্দী কৰি নিলে; এনেকি ঘৰত থকা বস্তুবোৰো তেওঁলোকে লুট কৰি নিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","যাকোবে চিমিয়োন আৰু লেবীক ক’লে, “তোমালোকে এই দেশ-নিবাসী কনানীয়া আৰু পৰিজ্জীয়া লোকসকলৰ মাজত মোক ঘৃণাৰ পাত্র কৰি বিপদত পেলালা; মোৰ লোক সংখ্যাত তাকৰ। যদি তেওঁলোকে মোৰ অহিতে একগোট হৈ মোক আক্রমণ কৰে, তেতিয়া মই সপৰিবাৰে বিনষ্ট হ’ম।” ");
INSERT INTO asmfb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","তাতে চিমিয়োন আৰু লেবীয়ে ক’লে, “চিখিমে আমাৰ ভনীক জানো বেশ্যাৰ দৰে ব্যৱহাৰ কৰা উচিত আছিল?” ");
INSERT INTO asmfb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","তাৰ পাছত ঈশ্বৰে যাকোবক ক’লে, “উঠা, তুমি এতিয়া বৈৎএললৈ গৈ তাত নিবাস কৰাগৈ আৰু তুমি তোমাৰ ককাই এচৌৰ আগৰ পৰা পলাই যোৱা সময়ত, যিজন সৰ্বশক্তিমান ঈশ্বৰে তোমাক দৰ্শন দিছিল, সেই ঈশ্বৰৰ উদ্দেশ্যে তাত এটা যজ্ঞবেদি নিৰ্ম্মাণ কৰাগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","তেতিয়া যাকোবে নিজৰ পৰিয়াল আৰু তেওঁৰ লগৰ সকলো লোকক ক’লে, “তোমালোকৰ মাজত বিদেশৰ যিবোৰ দেৱ-দেৱী আছে, সেইবোৰ দূৰ কৰা আৰু নিজকে শুচি কৰি আন কাপোৰ পিন্ধা। ");
INSERT INTO asmfb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","তাৰ পাছত, ব’লা আমি বৈৎএললৈ যাওঁহঁক; তাত ঈশ্বৰৰ উদ্দেশ্যে এটা যজ্ঞবেদি নির্ম্মাণ কৰিম, যিজনা ঈশ্বৰে মোৰ দুখৰ সময়ত মোৰ প্ৰাৰ্থনাৰ উত্তৰ দিছিল আৰু মই যোৱা বাটত মোৰ সংগত আছিল।” ");
INSERT INTO asmfb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","তেতিয়া তেওঁলোকৰ হাতত বিদেশৰ যিমানবোৰ দেৱ-দেৱী আছিল যাকোবক দিলে। তাৰ লগতে কাণৰ কুণ্ডলবোৰো যাকোবক দিলে; যাকোবে সেই সকলোকে লৈ চিখিম নগৰৰ ওচৰত ওচৰৰ এলা গছজোপাৰ ত’লতে পুতি থলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","পাছত তেওঁলোকে যাত্ৰা আৰম্ভ কৰিলে। তেওঁলোক যোৱাৰ পথত ঈশ্বৰে চাৰিওফালৰ নগৰৰ মাজত এনে এক ভয়ৰ সৃষ্টি কৰিলে যাৰ ফলত সেই লোকসকলে যাকোবৰ পুত্রসকলৰ পাছত খেদি নগ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","এইদৰে যাকোব আৰু তেওঁৰ লগত থকা আনসকলো কনান দেশৰ লুজ নগৰ অৰ্থাৎ বৈৎএল গৈ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","তেওঁ তাত এটা যজ্ঞবেদি নিৰ্মাণ কৰিলে। তেওঁ সেই ঠাইৰ নাম এল বৈৎএল ৰাখিলে, কিয়নো, তেওঁ নিজৰ ককায়েকৰ ওচৰৰ পৰা পলাই অহাৰ সময়ত, ঈশ্বৰে সেই ঠাইতে তেওঁক দৰ্শন দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ইতিমধ্যে ৰিবেকাৰ ধাত্রী দবোৰাৰ মৃত্যু হ’ল। তেওঁক বৈৎএলৰ ওচৰত থকা এজোপা ওক গছৰ তলত মৈদাম দিয়া হ’ল; সেই কাৰণে সেই ঠাইৰ নাম অল্লোন-বাখুৎ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","পদ্দন-অৰামৰ পৰা যাকোব উভটি অহাৰ পাছত, ঈশ্বৰে তেওঁক পুনৰায় দৰ্শন দি আশীৰ্ব্বাদ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ঈশ্বৰে তেওঁক ক’লে, “তোমাৰ নাম হৈছে যাকোব, কিন্তু তোমাক আৰু যাকোব বুলি মতা নহ’ব; তোমাৰ নাম হ’ব ইস্ৰায়েল।” এইদৰে ঈশ্বৰে তেওঁৰ নাম ইস্ৰায়েল ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ঈশ্বৰে তেওঁক আৰু ক’লে, “ময়েই সৰ্ব্বশক্তিমান ঈশ্বৰ; তুমি বহুবংশ হৈ বাঢ়ি বাঢ়ি যোৱা; তোমাৰ পৰা এক জাতি, এনে কি, জাতি সমূহৰ এক সমাজ গঠন হ’ব; তোমাৰ বংশত অনেক ৰজাসকলৰ জন্ম হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","মই অব্ৰাহাম আৰু ইচহাকক দিয়া দেশ তোমাক আৰু তোমাৰ পাছত তোমাৰ ভাবী-বংশকো দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ঈশ্বৰে তেওঁৰে সৈতে কথা বতৰা হোৱা ঠাইতে তেওঁক এৰি ওপৰলৈ উঠি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","যাকোবে তেওঁৰে সৈতে কথা বতৰা হোৱা সেই ঠাইতে এটা শিলৰ স্তম্ভ স্থাপন কৰিলে আৰু তাৰ ওপৰত পেয় নৈবেদ্য উৎসর্গ কৰিলে। তেওঁ তাৰ ওপৰত তেলো ঢালি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ঈশ্বৰে সৈতে কথা বতৰা হোৱা সেই ঠাইৰ নাম যাকোবে বৈৎএল ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","তাৰ পাছত যাকোব আৰু তেওঁৰ লোকসকলে বৈৎএলৰ পৰা যাত্ৰা কৰিলে। তেওঁলোকে ইফ্ৰাথ পাবলৈ কিছু বাট থাকোঁতেই ৰাহেলৰ প্ৰসৱ-বেদনা আৰম্ভ হ’ল আৰু তেওঁ বৰকৈ কষ্ট পাবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","প্ৰসৱৰ কালত তেওঁৰ বেদনা যেতিয়া ভীষণ বাঢ়ি গ’ল, তেতিয়া ধাত্ৰীয়ে তেওঁক ক’লে, “ভয় নকৰিবা; কিয়নো এইবাৰো আপোনাৰ এটি পুত্ৰ সন্তান হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","কিন্তু ৰাহেলৰ মৃত্যু হ’ল। প্ৰাণত্যাগ কৰাৰ সময়ত তেওঁ সেই পুত্ৰৰ নাম বিন-ওনী ৰাখিলে; কিন্তু তাৰ বাপেকে হ’লে তাৰ নাম বিন্যামীন ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ৰাহেলৰ মৃত্যু হোৱাৰ পাছত ইফ্ৰাথ অৰ্থাৎ বৈৎলেহেমলৈ যোৱা বাটৰ ওচৰতে তেওঁক মৈদাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","যাকোবে তেওঁৰ মৈদামৰ ওপৰত এটা স্তম্ভ স্থাপন কৰিলে; সেয়া আজিও ৰাহেলৰ মৈদামৰ চিহ্ন হিচাবে সেই ঠাইত আছে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","তাৰ পাছত ইস্ৰায়েলে তাৰ পৰা আকৌ যাত্ৰা কৰিলে। তেওঁ মিকদল-এদৰ নামৰ ঠাইখন এৰি আগবাঢ়ি গৈ তেওঁৰ তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ইস্ৰায়েলে সেই দেশত নিবাস কৰা সময়ত ৰূবেণে তেওঁৰ বাপেকৰ উপপত্নী বিলহাৰ লগতে শয়ন কৰিলে; সেই কথা ইস্ৰায়েলৰ কাণত পৰিল। যাকোবৰ পুত্ৰ আছিল বাৰজন। ");
INSERT INTO asmfb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","লেয়াৰ গর্ভত যাকোবৰ জেষ্ঠ্য পুত্ৰ ৰূবেণৰ জন্ম হৈছিল। তাৰ পাছত চিমিয়োন, লেবী, যিহূদা, ইচাখৰ আৰু জবূলূনৰ জন্ম হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ৰাহেলৰ গর্ভত তেওঁৰ পুত্র যোচেফ আৰু বিন্যামীন। ");
INSERT INTO asmfb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ৰাহেলৰ দাসী বিলহাৰ গর্ভত তেওঁৰ পুত্র দান আৰু নপ্তালী। ");
INSERT INTO asmfb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","লেয়াৰ দাসী জিল্পাৰ গর্ভত তেওঁৰ পুত্র গাদ আৰু আচেৰ। এইসকলেই হৈছে পদ্দন-অৰামত জন্মা যাকোবৰ পুত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","শেষত যাকোব কিৰিয়ৎ-অর্ব্ব অৰ্থাৎ হিব্ৰোণৰ ওচৰৰ মম্ৰি নগৰত তেওঁৰ পিতৃ ইচহাকৰ ওচৰলৈ আহিল। এই ঠাইতে অব্ৰাহাম আৰু ইচহাকে বাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ইচহাক এশ আশী বছৰ জীয়াই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ইচহাকে এক পৰিপূর্ণ আয়ুস কটাই বৃদ্ধ হৈ মৃত্যু বৰণ কৰি তেওঁৰ পূর্বপুৰুষসকলৰ ওচৰলৈ গ’ল; তাতে তেওঁৰ পুত্ৰ এচৌ আৰু যাকোবে তেওঁক মৈদাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","এচৌ অর্থাৎ যিজনক ইদোম বোলা হয়, তেওঁৰ বংশৰ তালিকা হৈছে এনেদৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","এচৌৱে কনানীয়া ছোৱালীবোৰক বিয়া কৰিছিল। সেই ছোৱালীবোৰ হৈছে হিত্তীয়া এলোনৰ জীয়েক আদা; হিব্বীয়া চিবিয়োনৰ নাতিনীয়েক অর্থাৎ অনাৰ জীয়েক অহলীবামা। ");
INSERT INTO asmfb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","আৰু ইশ্মায়েলৰ জীয়েক নবায়োতৰ ভনীয়েক বাচমতকো বিয়া কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","এইসকলৰ মাজত আদাই এচৌলৈ ইলীফজ আৰু বাচমতে ৰূৱেলক প্রসৱ কৰিলে; ");
INSERT INTO asmfb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","অহলীবামাৰ ঔৰসত যিয়ূচ, যালম, আৰু কোৰহৰ জন্ম হ’ল; কনান দেশত এচৌৰ এই সকলো পুত্রৰে জন্ম হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","পাছত এচৌৱে তেওঁৰ ভার্য্যাসকলক, ল’ৰা-ছোৱালীক আৰু তেওঁৰ ঘৰৰ আন সকলোৰে লগত তেওঁৰ পশুধন অর্থাৎ মেৰ-ছাগ, ছাগলী, গৰু আদি অন্যান্য পশু আৰু কনান দেশত উপাৰ্জন কৰা সকলো সম্পত্তিকে লৈ তেওঁ ভায়েক যাকোবৰ ওচৰৰ পৰা আন এক দেশলৈ গুছি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","এচৌ আৰু যাকোবৰ ধন-সম্পদ ইমান বেছি হ’ল যে তেওঁলোকৰ পক্ষে একেলগে বাস কৰাটো সম্ভৱ নহ’ল; কিয়নো তেওঁলোক যি ঠাইত আছিল সেই ঠাইত তেওঁলোকৰ পশুৰ জাকবোৰ চৰাবলৈ যথেষ্ট ঠাইৰ অভাৱ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","সেয়ে এচৌৱে চেয়ীৰৰ পাহাৰীয়া এলেকাত গৈ স্থায়ীভাৱে বাস কৰিবলৈ ধৰিলে; সেই এচৌৰ আন এটা নাম আছিল ইদোম। ");
INSERT INTO asmfb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","চেয়ীৰৰ পাহাৰীয়া এলেকাত ইদোমীয়াসকলৰ ওপৰপিতৃ এচৌৰ বংশৰ তালিকা হৈছে এনেধৰণৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","এচৌৰ পুত্রসকলৰ নাম ইলীফজ আৰু ৰূৱেল। ইলীফজ আদাৰ পুত্ৰ আৰু ৰূৱেল এচৌৰ বাচমতৰ পুত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ইলীফজৰ পুত্ৰসকল হ’ল তৈমন, ওমাৰ, চফো, গয়িতম আৰু কনজ। ");
INSERT INTO asmfb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","এচৌৰ পুত্ৰ ইলীফজৰ তিম্না নামেৰে এজনী উপপত্নী আছিল। তেওঁৰ গর্ভত অমালেকৰ জন্ম হ’ল; এই সকলোৱেই এচৌৰ ভার্য্যা আদাৰ পো-নাতি। ");
INSERT INTO asmfb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ৰূৱেলৰ পুত্ৰসকল হ’ল নহৎ, জেৰহ, চম্মা আৰু মিজ্জা; এই সকলোৱেই এচৌৰ ভার্য্যা বাচমতৰ পো-নাতি। ");
INSERT INTO asmfb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","চিবিয়োনৰ নাতিনী অর্থাৎ অনাৰ জীয়েক আৰু এচৌৰ ভার্য্যা অহলীবামাই এচৌলৈ প্রসৱ কৰা পুত্ৰসকল হ’ল যিয়ূচ, যালম আৰু কোৰহ। ");
INSERT INTO asmfb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","এচৌৰ বংশৰ সন্তান সকলৰ মাজত এইসকলেই অধিপতি হৈছিল - এচৌৰ জ্যেষ্ঠ পুত্ৰ ইলীফজৰ বংশৰ পৰা হোৱা অধিপতিসকল হ’ল- তৈমন, ওমাৰ, চফো, কনজ অধিপতি। ");
INSERT INTO asmfb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","কোৰহ, গয়িতম, অমালেক অধিপতি; ইলীফজৰ বংশৰ পৰা, ইদোম দেশত এওঁলোকেই অধিপতি হ’ল। এইসকল আদাৰ পো-নাতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","এচৌৰ পুত্ৰ ৰূৱেলৰ বংশৰ পৰা হোৱা অধিপতিসকল হ’ল: নহৎ, জেৰহ, চম্মা আৰু মিজ্জা; ৰূৱেলৰ বংশৰ পৰা ইদোম দেশত এওঁলোক অধিপতি হ’ল। এইসকল এচৌৰ ভার্য্যা বাচমতৰ পো-নাতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","এচৌৰ ভার্য্যা অহলীবামাৰ বংশত এইসকল অধিপতি হ’ল: যিয়ূচ, যালম আৰু কোৰহ; অনাৰ জীয়েক এচৌৰ ভার্য্যা অহলীবামাৰ বংশৰ পৰা এইসকলেই অধিপতি হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","এওঁলোকেই এচৌ অর্থাৎ ইদোমৰ সন্তান আৰু তেওঁলোকই নিজৰ বংশৰ অধিপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","সেই ঠাইৰ বাসিন্দা হোৰীয়া চেয়ীৰৰ সন্তান সকলৰ নাম লোটন, চোবল, চিবিয়োন, অনা, ");
INSERT INTO asmfb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","দিচোন, এচৰ আৰু দীচন। ইদোমত চেয়ীৰৰ এইসকল সন্তানেই হোৰীয়া বংশৰ অধিপতি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","লোটনৰ পুত্রসকলৰ নাম হোৰী আৰু হেমম; লোটনৰ ভনীয়েকৰ নাম তিম্না। ");
INSERT INTO asmfb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","চোবলৰ পুত্রসকলৰ নাম: অলবন, মানহৎ, এবল, চফো, আৰু ওনম। ");
INSERT INTO asmfb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","চিবিয়োনৰ পুত্রসকলৰ নাম: অয়া আৰু অনা; এই অনাই পিতৃ চিবিয়োনৰ গাধ চৰাওঁতে মৰুপ্রান্তৰৰ মাজত গৰম পানীৰ জুৰি পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","এই অনাৰ পুত্ৰৰ নাম দীচন আৰু জীয়েকৰ নাম অহলীবামা। ");
INSERT INTO asmfb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","দীচনৰ পুত্ৰসকলৰ নাম হিমদন, ইচবন, যিত্ৰন আৰু কৰান। ");
INSERT INTO asmfb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","এচৰৰ পুত্ৰ বিলহন, জাবন, আৰু অকন। ");
INSERT INTO asmfb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","দীচনৰ পুত্ৰ উচ আৰু অৰান। ");
INSERT INTO asmfb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","হোৰীয়াৰ অধিপতিসকলৰ নাম আছিল: লোটন, চোবল, চিবিয়োন, অনা, ");
INSERT INTO asmfb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","দিচোন, এচৰ আৰু দীচন; এইসকলেই চেয়ীৰ দেশত বংশৰ তালিকা অনুসাৰে হোৰীয়া জাতিৰ অধিপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ইস্ৰায়েলীসকলৰ মাজত কোনো ৰজাই ৰাজত্ব কৰাৰ আগতে, ইদোম দেশত যি সকল ৰজাই ৰাজত্ব কৰিছিল, তেওঁলোক হ’ল: ");
INSERT INTO asmfb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","বিয়োৰৰ পুত্ৰ বিলাই ইদোমত ৰাজত্ব কৰিছিল; তেওঁৰ নগৰৰ নাম আছিল দিনহাবা। ");
INSERT INTO asmfb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","বিলাৰ মৃত্যুৰ পাছত তেওঁৰ ঠাইত বস্ৰা নগৰৰ জেৰহৰ পুত্ৰ যোববে ৰাজত্ব কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","যোববৰ মৃত্যুৰ পাছত তেওঁৰ ঠাইত তৈমনীয়াসকলৰ দেশৰ হূচমে ৰাজত্ব কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","হূচমৰ মৃত্যুৰ পাছত তেওঁৰ ঠাইত বদদৰ পুত্র হদদে ৰাজত্ব কৰিছিল। তেওঁ মোৱাব দেশত মিদিয়নীয়সকলক পৰাজয় কৰিছিল; তেওঁৰ নগৰৰ নাম আছিল অবীৎ। ");
INSERT INTO asmfb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","যেতিয়া হদদৰ মৃত্যু হ’ল, তেতিয়া তেওঁৰ ঠাইত মস্ৰেকাৰ চম্নাই ৰাজত্ব কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","চম্নাৰ মৃত্যু হ’লত, তেওঁৰ ঠাইত ফৰাৎ নদীৰ ওচৰৰ ৰহোবোতীয়া চৌলে ৰাজত্ব কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","চৌলৰ মৃত্যু পাছত তেওঁৰ ঠাইত অকবোৰৰ পুত্ৰ বাল-হাননে ৰাজত্ব কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","অকবোৰৰ পুত্ৰ বাল-হাননৰ মৃত্যু পাছত তেওঁৰ ঠাইত হদৰে ৰাজত্ব কৰিছিল; তেওঁৰ নগৰৰ নাম পাউ আছিল; তেওঁৰ ভাৰ্যাৰ নাম আছিল মহেটবেল। তেওঁ মট্ৰেদৰ জীয়েক আৰু মে-জাহবৰ নাতিনীয়েক। ");
INSERT INTO asmfb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","এচৌৰ বংশৰ যি সকল লোক অধিপতি আছিল, সেইসকলৰ নাম: তিম্না, অলবা, যিথেৎ, ");
INSERT INTO asmfb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","অহলীবামা, এলা, পীনোন, ");
INSERT INTO asmfb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","কনজ, তৈমন, মিবচৰ, ");
INSERT INTO asmfb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","মগ্দীয়েল আৰু ঈৰম; এওঁলোক আছিল ইদোমীয়সকলৰ পূর্বপুৰুষ এচৌৰ বংশৰ লোক ইদোমৰ অধিপতি। দেশৰ যিবোৰ ঠাইত তেওঁলোকে বাস কৰিছিল, তেওঁলোকৰ নাম অনুসাৰে সেই সকলো ঠাইৰ নাম দিয়া হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","যাকোব কনান দেশত বাস কৰিবলৈ ধৰিলে। তেওঁৰ পিতৃয়েও কনান দেশত বাস কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","যাকোবৰ বংশৰ বৃত্তান্ত এইধৰণৰ। যোচেফ যেতিয়া সোঁতৰ বছৰ বয়সৰ এজন যুবক, তেতিয়া তেওঁ ককায়েকসকলৰ সৈতে পশুৰ জাকবোৰ চৰাইছিল। তেওঁ মাহী মাক বিলহা আৰু জিল্পাৰ পুতেকসকলৰ লগত আছিল আৰু বাপেকৰ আগত তেওঁলোকৰ বেয়া কার্যবোৰৰ বিষয়ে সংবাদ দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","বৃদ্ধ বয়সত হোৱা পুত্র দেখি ইস্ৰায়েলে যোচেফক আন সকলো পুতেকতকৈ তেওঁক অধিক স্নেহ কৰিছিল। তেওঁ তেওঁক এটা ধুনীয়া দীঘল চোলা তৈয়াৰ কৰি দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ককায়েকসকলে যেতিয়া বুজিলে যে পিতৃয়ে তেওঁলোকতকৈ যোচেফক অধিক স্নেহ কৰে, তেতিয়া তেওঁলোকে যোচেফক ঘৃণা কৰিবলৈ ধৰিলে আৰু সেয়ে, তেওঁলোকে তেওঁক মৰমেৰে কথা কবলৈও নিবিচাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","এদিন যোচেফে এটা সপোন দেখিলে আৰু তেওঁ সেই সপোনৰ বিষয়ে ককায়েকসকলক কোৱাত তেওঁলোকে তেওঁক অধিক বেছিকৈ ঘৃণা কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","যোচেফে তেওঁলোকক ক’লে, “শুনা, মই এটা সপোন দেখিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","মই দেখিলোঁ যে আমি পথাৰত কাটি থোৱা শস্যৰ মুঠি বান্ধিছিলোঁ; তাতে মোৰ মুঠিটো পোন হৈ উঠি থিয় হ’ল; তাৰ পাছত তোমালোকৰ মুঠিবোৰে মোৰ মুঠিৰ চাৰিওফালে থিয় হৈ প্ৰণিপাত কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","তাতে তেওঁৰ ককায়েকসকলে তেওঁক ক’লে, “তেনেহ’লে তই সচাঁকৈয়ে আমাৰ ওপৰত ৰজা হবি নেকি? আমাৰ ওপৰত সঁচাই তই অধিকাৰ চলাবি নেকি?” এইদৰে তেওঁৰ সপোন, আৰু তেওঁৰ কথাৰ কাৰণে ককায়েকসকলে আৰু অধিককৈ তেওঁক ঘিণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","পাছত যোচেফে আন এটা সপোন দেখিলে আৰু তেওঁৰ ককায়েকসকলক তাক ক’লে। তেওঁ ক’লে, “শুনা, মই আন এটা সপোন দেখিলোঁ; মই দেখিলোঁ যে সূৰ্য, চন্দ্ৰ আৰু এঘাৰটা তৰাই মোৰ আগত প্ৰণিপাত কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","তেওঁ এই সপোনৰ কথা ককায়েকসকলক কোৱাৰ দৰে বাপেককো কোৱাত বাপেকে তেওঁক ধমকি দি ক’লে, “তই এইটো কি সপোন দেখিলি? তোৰ মাৰ, মই আৰু ককায়েৰহঁতে তোৰ আগত মাটিত পৰি প্ৰণিপাত কৰিবলৈ আহিম নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","তাতে তেওঁৰ ককায়েকসকলে তেওঁক হিংসা কৰিলে; কিন্তু বাপেকে হ’লে সেই কথা মনত ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","পাছত যোচেফৰ ককায়েকসকলে তেওঁলোকৰ বাপেকৰ পশুৰ জাকবোৰ চৰাবলৈ চিখিমলৈ গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ইস্ৰায়েলে যোচেফক ক’লে, “তোমাৰ ককায়েৰাসকলে চিখিমত পশুৰ জাকবোৰ জানো চৰাই থকা নাই? আহাঁ, মই তোমাক সিহঁতৰ ওচৰলৈ পঠাম।” তাতে যোচেফে তেওঁক ক’লে “ঠিক আছে, মই যাবলৈ প্রস্তুত আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","তেতিয়া বাপেকে তেওঁক ক’লে, “তুমি গৈ তোমাৰ ককায়েৰাহঁত আৰু পশুৰ জাকবোৰ কুশলে আছে নে নাই, সেই সংবাদ লৈ আহি মোক দিবা।” ইয়াকে কৈ যাকোবে যোচেফক হিব্ৰোণ উপত্যকাৰ পৰা পঠালে আৰু যোচেফও চিখিমলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","কোনো এজন মানুহে যোচেফক পথাৰৰ মাজত ঘূৰি ফুৰা দেখি সুধিলে, “তুমি কি বিচাৰি ফুৰিছা?” ");
INSERT INTO asmfb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","যোচেফে ক’লে, “মই মোৰ ককাইহঁতক বিচাৰি আছোঁ; দয়া কৰি আপুনি মোক কবনে তেওঁলোকে ক’ত পশুৰ জাকক চৰাই আছে?” ");
INSERT INTO asmfb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","মানুহজনে ক’লে, “এই ঠাই এৰি তেওঁলোক গুছি গ’ল; মই তেওঁলোকে এইবুলি কোৱা শুনিছিলো, ‘ব’লা, আমি দোথানলৈ যাওঁ’।” তাতে যোচেফে তেওঁৰ ককায়েকসকলৰ পাছত গৈ দোথানত তেওঁলোকক বিচাৰি পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","যোচেফক ককায়েকসকলে দূৰৰ পৰাই দেখা পালে আৰু তেওঁলোকৰ ওচৰলৈ আহি পোৱাৰ আগেয়েই, তেওঁক বধ কৰাৰ ষড়যন্ত্র কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","তেওঁলোকে ইজনে সিজনক ক’লে, “সৌটো চা, সপোন দেখাটো আহিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ব’লা এতিয়াই আমি তাক বধ কৰি, কোনো এটা গাতত পেলাই দিওঁ আৰু পাছত আমি ক’ম, কোনো হিংস্র জন্তুৱে তাক খালে। তেতিয়া তাৰ সপোনবোৰ কি হয়, আমি চাম।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","কিন্তু ৰূবেণে সেই কথা শুনি তেওঁলোকৰ হাতৰ পৰা তেওঁক ৰক্ষা কৰি ক’লে, “নহয়, আমি তাৰ প্রাণ নলওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ৰূবেণে তেওঁলোকক ক’লে, “ৰক্তপাত নকৰোঁ। তেওঁৰ শৰীৰত হাত নুতুলাকৈয়ে বৰং তেওঁক এই মৰুপ্রান্তৰৰ এটা গাতত পেলাই দিয়া”- পাছত যোচেফক তেওঁলোকৰ হাতৰ পৰা উদ্ধাৰ কৰি যেন পিতৃৰ ওচৰলৈ আনি ঘূৰাই দিব এই মনেৰে তেওঁ এই কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","যোচেফ তেওঁৰ ককায়েকসকলৰ ওচৰ পালত তেওঁলোকে তেওঁৰ গাৰ পৰা পিন্ধি থকা দীঘল চোলাটো জোৰেৰে সোলোকাই ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","তাৰ পাছত তেওঁলোকে তেওঁক ধৰি গাতৰ ভিতৰত পেলাই দিলে; সেই গাতটো পানী নথকা এটা শুকান গাত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","তাৰ পাছত তেওঁলোকে ভোজন কৰিবলৈ বহিল; তেনেতে তেওঁলোকে চকু তুলি চাই দেখিলে যে, গিলিয়দৰ পৰা ইশ্মায়েলীয়া এক ব্যৱসায়ী দল আহি আছে। উটৰ পিঠিত তেওঁলোকে মা-মচলা, বিষ নিৰাময়ৰ সুগন্ধি মলম আৰু গন্ধৰস লৈ মিচৰ দেশলৈ নামি যাবলৈ আহি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","তেতিয়া যিহূদাই তেওঁৰ ককায়েকসকলক ক’লে, “আমি ভাইক বধ কৰি তাৰ তেজ লুকুৱাই ৰাখিলে আমাৰ কি লাভ হ’ব? ");
INSERT INTO asmfb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","কাৰণ সি আমাৰ নিজৰে ভাই আৰু আমাৰ মঙহো। সেয়ে তাৰ শৰীৰত হাত নিদি বৰং আহাঁ, আমি তাক এই ইশ্মায়েলীয়াসকলৰ ওচৰত বিক্রী কৰোঁ।” ককায়েকসকল তেওঁৰ এই কথাত মান্তি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","সেই মিদিয়নীয়া ব্যৱসায়ীসকল ওচৰেদি পাৰ হোৱাত, তেওঁলোকে যোচেফক গাতৰ পৰা টানি ওপৰলৈ উঠালে আৰু বিশ চেকল ৰূপৰ বিনিময়ত যোচেফক ইশ্মায়েলীয়াসকলৰ ওচৰত বিক্রী কৰিলে। তাতে সেই ব্যৱসায়ীসকলে যোচেফক মিচৰ দেশলৈ লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","পাছত ৰূবেণে গাতৰ ওচৰলৈ গৈ যোচেফক গাতত নেদেখি দুখতে নিজৰ কাপোৰ ফালিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","তেওঁ ভায়েকসকলৰ ওচৰলৈ গৈ ক’লে, “যোচেফ ক’লৈ গ’ল - তাতটো নাই; এতিয়া মই কলৈ যাম?” ");
INSERT INTO asmfb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","তেতিয়া তেওঁলোকে এটা ছাগলী মাৰি তাৰ তেজত যোচেফৰ সেই চোলাটো জুবুৰিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","পাছত তেওঁলোকে চোলাটো বাপেকৰ ওচৰলৈ আনি ক’লে, “এইটো আমি পালোঁ; চাওকচোন, এইটো আপোনাৰ পুত্রৰ চোলা হয় নে নহয়।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","যাকোবে চোলাটো চিনি পায় ক’লে, “এইটো মোৰ পুত্ৰৰেই চোলা হয়; কোনো হিংস্র জন্তুৱে তাক খালে; নিশ্চয়ে জন্তুটোৱে যোচেফক ডোখৰ ডোখৰ কৰি ফালি পেলালে।” ");
INSERT INTO asmfb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","তেতিয়া যাকোবে নিজৰ কাপোৰ ফালি কঁকালত চট পিন্ধি বহুদিনলৈকে পুতেকৰ কাৰণে শোক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","তেওঁৰ পুতেক জীয়েক আটাইবোৰে আহি তেওঁক শান্তনা দিবলৈ ধৰিলে; কিন্তু তেওঁ কোনো শান্তনাই নুশুনিলে। তেওঁ ক’লে, “শোক কৰিয়েই মই চিয়োললৈ মোৰ পুত্ৰৰ ওচৰলৈ যাম।” এইবুলি কৈয়ে যোচেফৰ কাৰণে যাকোবে ক্ৰন্দন কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","আনফালে, সেই মিদিয়নীয়াসকলে যোচেফক মিচৰ দেশলৈ লৈ গৈ পোটিফৰৰ ওচৰত বিক্রি কৰিলে। পোটিফৰ আছিল ফৰৌণ ৰজাৰ এজন বিষয়া, ৰক্ষকৰ প্রধান সেনাপতি। ");
INSERT INTO asmfb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","পাছত যিহূদাই তেওঁৰ ভায়েক ককায়েকসকলক এৰি অদুল্লমীয়া হীৰা নামৰ এজন লোকৰ লগত বাস কৰিলেগৈ। ");
INSERT INTO asmfb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","সেই ঠাইত যিহূদাই চুৱা নামৰ কোনো এজন কনানীয়া মানুহৰ ছোৱালীক দেখা পাই তেওঁ সেই ছোৱালীজনীক বিয়া কৰিলে আৰু তাইৰ সৈতে শয়ন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","পাছত তাই গৰ্ভৱতী হৈ এটি পুত্ৰ প্ৰসৱ কৰিলে আৰু ল’ৰাটিৰ নাম এৰ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","পুনৰায় তাই গৰ্ভৱতী হৈ এটি পুত্ৰ প্ৰসৱ কৰি তাৰ নাম ওনন ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","তাই পুনৰ এটি পুত্ৰ প্ৰসৱ কৰিলে আৰু তাৰ নাম চেলা ৰাখিলে; তাই এই পুত্র কজীবত থকাৰ সময়ত প্ৰসৱ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","পাছত যিহূদাই তেওঁৰ জেষ্ঠ্য পুত্ৰ এৰৰ লগত তামাৰ নামেৰে এজনী ছোৱালীক বিয়া কৰাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","কিন্তু যিহূদাৰ জ্যেষ্ঠ পুত্ৰ এৰ যিহোৱাৰ দৃষ্টিত দুষ্ট হোৱাত যিহোৱাই তাক বিনষ্ট কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","তেতিয়া যিহূদাই ওননক ক’লে, “তুমি তোমাৰ ককায়েৰাৰ ভার্য্যাক বিয়া কৰোঁৱা। দেওৰেক হিচাবে তুমি তাইলৈ কৰিবলগীয়া কর্তব্য কৰা আৰু তোমাৰ ককায়েৰাৰ বংশ বৃদ্ধি কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","কিন্তু ওননে জানিছিল যে, সেই বংশ তেওঁৰ নিজৰ নহ’ব। সেয়ে ককায়েকৰ হৈ বংশ ৰক্ষা নকৰাৰ উদ্দেশ্যেৰে বৌৱেকৰ লগত শয়ন কৰা কালত তেওঁ মাটিতে বীৰ্য্যপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","তেওঁ কৰা কার্য্য যিহোৱাৰ দৃষ্টিত দুষ্টতা আছিল। সেয়ে যিহোৱাই তেওঁকো বিনষ্ট কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","তেতিয়া যিহূদাই নিজৰ পো-বোৱাৰী তামাৰক ক’লে, “যেতিয়ালৈকে মোৰ পুত্ৰ চেলা ডাঙৰ নহয়, তেতিয়ালৈকে তুমি তোমাৰ পিতৃৰ ঘৰত বিধৱা হিচাবে থাকাগৈ।” কিয়নো তেওঁ ভাবিছিল, “কিজানি চেলাৰো ককায়েকহঁতৰ দৰে মৃত্যু হ’ব।” তাতে তামাৰে নিজৰ পিতৃৰ ঘৰত গৈ বাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","পাছত কালক্রমে যিহূদাৰ ভার্য্যা অর্থাৎ চুৱাৰ জীয়েকৰ মৃত্যু হ’ল। যিহূদাৰ শোক প্রকাশৰ দিন শেষ হোৱাত, যিহূদা আৰু তেওঁৰ অদুল্লমীয়া বন্ধু হীৰা তিম্নালৈ যিহূদাৰ মেৰ-ছাগৰ নোম কটা লোকসকলৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","তেতিয়া কোনোৱে তামাৰক ক’লে, “শুনা, তোমাৰ শহুৰ দেউতাই নিজৰ মেৰৰ নোম কটাবলৈ তিম্নালৈ গৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","তাকে শুনি তামাৰে বিধৱা-বস্ত্ৰ সোলোকাই থৈ, ওৰণিৰে মুখ ঢাকি, গাত কাপোৰ মেৰিয়াই ঐনয়িমৰ দুৱাৰমুখত বহি থাকিল; ঐনয়িম তিম্নালৈ যোৱা বাটৰ ওচৰত আছিল। কিয়নো তাই মন কৰিছিল যে, চেলা ডাঙৰ হোৱাটো তেওঁৰ সৈতে তাইক বিয়া নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","তেতিয়া যিহূদাই তাইক দেখি বেশ্যা বুলি জানিলে; কিয়নো তাই নিজ মুখ ঢাকি ৰাখিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","তাতে তেওঁ বাটৰ দাঁতিলৈ তাইৰ ওচৰলৈ গৈ, তাইক নিজ পো-বোৱাৰীয়েক বুলি নেজানি তাইক ক’লে, “আহাঁ, মই তোমাৰ লগত শয়ন কৰোঁ।” তাতে তামাৰে ক’লে, “মোৰ লগত শয়ন কৰাৰ বাবদ আপুনি মোক কি দিব?” ");
INSERT INTO asmfb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","তেওঁ ক’লে, “মোৰ জাকৰ পৰা এটা ছাগলী পোৱালি পঠাই দিম।” তাতে তাই ক’লে, “তাক পঠাই নিদিয়েমানে মোৰ ইয়াত কিবা বন্ধক ৰাখি যাবনে?” ");
INSERT INTO asmfb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","যিহূদাই ক’লে, “কি বন্ধক ৰাখিম?” তাই ক’লে, “জৰীডালেৰে সৈতে আপোনাৰ মোহৰটো আৰু আপোনাৰ হাতত থকা লাখুটিডাল ৰাখক।” তেতিয়া তেওঁ তাইক সেইবোৰ দি তাইৰ লগত শয়ন কৰিলে; তাৰফলত তাই তেওঁৰ দ্বাৰা গৰ্ভৱতী হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","পাছত তামাৰে উঠি গুচি গ’ল আৰু ওৰণি গুচাই নিজৰ বিধৱা-বস্ত্ৰ পিন্ধিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","যিহূদাই সেই মহিলাৰ হাতৰ পৰা বন্ধক মোকোলাই নিবলৈ, তেওঁৰ বন্ধু অদুল্লমীয়াৰ হাতত নিজৰ জাকৰ পৰা ছাগলী পোৱালিটো পঠাই দিলে। কিন্তু তেওঁ আহি তাইক নেপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","তেতিয়া তেওঁ সেই ঠাইৰ লোকসকলক সুধিলে, “ঐনয়িমৰ বাটৰ ওচৰত যি মন্দিৰৰ দেৱদাসী আছিল, তাই ক’ত?” তেওঁলোকে ক’লে, “ইয়াত কোনো দেৱদাসী নাই।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","তেতিয়া তেওঁ যিহূদাৰ ওচৰলৈ উভটি গৈ ক’লে, “মই তাইক বিচাৰি নাপালোঁ। সেই ঠাইৰ মানুহেও ক’লে যে, ‘তাত কোনো দেৱদাসী নাই’।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","যিহূদাই ক’লে, “তেন্তে সেই বন্ধকৰ বস্তুবোৰ তাইৰ লগতে থাকক, নহলে আমাক লাজত পেলাব; মইতো ছাগলী পোৱালি পঠায়েই দিছিলোঁ, কিন্তু তুমি তাইক বিচাৰি নাপালা।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ইয়াৰ তিনি মাহৰ পাছত যিহূদাই এই খবৰ পালে যে, “আপোনাৰ বোৱাৰী তামাৰে ব্যভিচাৰ কৰিছে; ব্যভিচাৰত তাই গৰ্ভৱতীও হ’ল।” তেতিয়া যিহূদাই ক’লে, “তাইক উলিয়াই আনি পুৰি পেলোৱা হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","পাছে তাইক যেতিয়া বাহিৰলৈ অনা হ’ল, তাই শহুৰেকলৈ এই বার্তা পঠালে, “মোৰ গর্ভত যিজনৰ সন্তান আছে, এইবোৰ তেওঁৰ বস্তু।” তাই আৰু ক’লে, “দয়া কৰি এই জৰীৰে সৈতে মোহৰ আৰু লাখুটি কাৰ, তাক এবাৰ পৰীক্ষা কৰি চাওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","তেতিয়া যিহূদাই সেইবোৰ চিনি পাই ক’লে, “তাই মোৰ তুলনাত অধিক ধাৰ্মিক; কিয়নো মই তাইক মোৰ পুত্ৰ চেলাৰ সৈতে বিয়া নিদিলোঁ।” তাৰ পিছত যিহূদাই আৰু তাইৰ সৈতে পুনৰ শয়ন নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","পাছত তাইৰ প্ৰসৱৰ কাল ওচৰ হোৱাত দেখা গ’ল তামাৰৰ গৰ্ভত এহাল যঁজা ল’ৰা আছে। ");
INSERT INTO asmfb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","জন্ম হওঁতে, এটা সন্তানে তাৰ হাতখন বাহিৰ কৰিলে; তেতিয়া ধাত্ৰীয়ে এডাল ৰঙা সূতা লৈ তাৰ সেই হাতত বান্ধি ক’লে, “এইটোৰ জন্ম প্ৰথমে হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","কিন্তু সি যেতিয়া নিজৰ হাতখন ভিতৰলৈ সুমুৱাই নিলে, তেতিয়াই তাৰ ভায়েক প্রথমে বাহিৰ ওলাই আহিল; তাতে ধাত্ৰীয়ে ক’লে, “তুমি কেনেকৈ ভেদ ভাঙি ওলাই আহিলা!” এই কাৰণে তেওঁৰ নাম পেৰচ ৰখা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","পাছত হাতত ৰঙা সূতা বন্ধা তাৰ ভায়েক বাহিৰ হ’ল আৰু তাৰ নাম জেৰহ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","যোচেফক মিচৰ দেশলৈ লৈ যোৱা হ’ল। ইশ্মায়েলীয়াসকলে যোচেফক মিচৰ দেশলৈ আনিছিল আৰু তাত ফৰৌণ ৰজাৰ পোটিফৰ নামৰ এজন মিচৰীয় বিষয়াই যোচেফক তেওঁলোকৰ পৰা কিনি লৈছিল। পোটিফৰ ফৰৌণ ৰজাৰ ৰক্ষক-সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","যিহোৱা যোচেফৰ সংগে সংগে থকাত তেওঁ এজন সফল ব্যক্তি হৈছিল। তেওঁ তেওঁৰ মিচৰীয় প্রভুৰ ঘৰত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","যিহোৱা যে তেওঁৰ সংগে সংগে আছে আৰু তেওঁ কৰা সকলো কার্যকে যিহোৱাই যে সফল কৰি তুলিছে, তাক তেওঁৰ প্ৰভুৱে দেখিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","যোচেফে পোটিফৰৰ দৃষ্টিত অনুগ্ৰহ পাই তেওঁ তেওঁৰ ব্যক্তিগত পৰিচাৰক হ’ল; তাতে পোটিফৰে যোচেফক নিজৰ ঘৰৰ অধ্যক্ষ পাতিলে আৰু তেওঁৰ যি যি আছিল, সেই সকলোৰে দেখা-শুনাৰ ভাৰও তেওঁৰ অধীনত দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","যোচেফক তেওঁ নিজ ঘৰ আৰু সৰ্বস্বৰ ওপৰত অধ্যক্ষ পতাৰ পাছৰ পৰাই যোচেফৰ কাৰণে যিহোৱাই সেই মিচৰীয়ৰ ঘৰক আশীৰ্ব্বাদ কৰিলে; তাতে পোটিফৰৰ ঘৰ-বাৰী আৰু খেতি-পথাৰ সকলোৰে ওপৰত যিহোৱাৰ আশীৰ্ব্বাদ কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","সেয়ে পোটিফৰে নিজৰ সৰ্ব্বস্ব যোচেফৰ তত্বাৱধানত শোধাই দিলে। কেৱল নিজৰ খোৱা আহাৰৰ বাহিৰে পোটিফৰে আৰু আন একো চিন্তা নকৰিছিল। গঠণত যোচেফ সুন্দৰ আৰু দেখনীয়া আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","কিছুদিনৰ পাছতে, যোচেফৰ ওপৰত তেওঁৰ প্ৰভুৰ ভার্য্যাৰ দৃষ্টি পৰিল। তেওঁ যোচেফক ক’লে, “মোৰ লগত শয়ন কৰাহি।” ");
INSERT INTO asmfb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","কিন্তু তেওঁ সেই কথাত ৰাজী নহ’ল। তেওঁ নিজ প্ৰভুৰ ভার্য্যাক ক’লে, “চাওঁক, এই ঘৰত মই যি কৰোঁ, মোৰ প্ৰভুৱে তাৰ একোৰে বিচাৰ নলয়; তেওঁ মোৰ হাতত তেওঁৰ সৰ্ব্বস্ব শোধাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","এই ঘৰত মোৰ ওপৰত আন কোনো নাই; তেওঁ মোক নিদিয়াকৈ একোকে ধৰি ৰখা নাই; কিন্তু কেৱল আপোনাকহে মোক দিয়া নাই; কাৰণ আপুনি তেওঁৰ ভাৰ্যা; তেন্তে মই কেনেকৈ ইমান ডাঙৰ এটা জঘন্য কাম কৰি ঈশ্বৰৰ বিৰুদ্ধে পাপ কৰিব পাৰোঁ?” ");
INSERT INTO asmfb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","পোটিফৰৰ ভার্য্যাই দিনে দিনে যোচেফক এই কথা কৈ থাকিবলৈ ধৰিলে। কিন্তু যোচেফে তেওঁৰ লগত শয়ন কৰিবলৈ, এনেকি তাইৰ ওচৰত থাকিবলৈও তেওঁ মান্তি নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","এদিনাখন নিজৰ কোনো কার্যৰ বাবে যোচেফ ঘৰৰ ভিতৰলৈ গৈছিল। তেতিয়া ঘৰৰ কোনো মানুহ সেই ঠাইত নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","পোটিফৰৰ ভার্য্যাই যোচেফক তেওঁৰ কাপোৰত ধৰি টানি ক’লে, “মোৰে সৈতে শয়ন কৰাহি।” কিন্তু যোচেফে কাপোৰখন তাইৰ হাততে এৰি থৈ বাহিৰলৈ পলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","তাতে তাইৰ হাতত যোচেফে নিজৰ কাপোৰ এৰি থৈ বাহিৰলৈ পলাই যোৱা দেখি, ");
INSERT INTO asmfb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","তাইৰ ঘৰৰ মানুহবোৰক তাই মাতিবলৈ ধৰিলে আৰু সিহঁতক ক’লে, “চোৱাচোন, আমাক অপমানিত কৰিবৰ কাৰণেহে মোৰ স্বামীয়ে এই ইব্ৰীয়া মানুহক আমাৰ ইয়ালৈ আনিছে; সি মোৰ ওচৰলৈ মোৰ লগত শোৱাৰ উদ্দেশ্যেৰে আহিছিল; সেয়ে মই বৰকৈ চিঞঁৰ মাৰি উঠিলোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","মই চিঞৰ-বাখৰ কৰা শুনি, সি তাৰ কাপোৰ মোৰ ওচৰতে এৰি থৈ বাহিৰলৈ পলাই গ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","যোচেফৰ প্রভু ঘৰলৈ নহা পর্যন্ত কাপোৰখন তাই নিজৰ ওচৰতে ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","পাছত তাই পোটিফৰৰ ওচৰত এই কথা কবলৈ গৈ ক’লে, “তুমি যি ইব্ৰীয়া দাসক আমাৰ ইয়ালৈ আনি ৰাখিছা, সি মোক অপমান কৰিবলৈ মোৰ ইয়ালৈ সোমাই আহিছিল; ");
INSERT INTO asmfb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","কিন্তু মই চিঞৰ-বাখৰ কৰাত সি মোৰ ওচৰত নিজৰ কাপোৰ এৰি বাহিৰলৈ পলাই গ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","যোচেফৰ প্রভুৱে যেতিয়া নিজৰ ভার্য্যাৰ মুখেৰে “তোমাৰ দাসে মোলৈ এনেধৰণৰ ব্যৱহাৰ কৰিছে” বুলি শুনিলে, তেওঁ খঙত জ্বলি উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","সেয়ে, তেওঁ যোচেফক ধৰি নি যি ঠাইত ৰজাৰ বন্দীবোৰক ৰখা হয়, তেওঁক সেই কাৰাগাৰত আটক কৰি থলে; তাতে তেওঁ কাৰাগাৰতে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","কিন্তু যিহোৱা যোচেফৰ সংগে সংগে আছিল আৰু তেওঁ যোচেফৰ প্রতি অংগীকাৰযুক্ত বিশ্বস্ততা দেখুৱাইছিল। যিহোৱাই তেওঁক কাৰাগাৰৰ অধ্যক্ষৰ দৃষ্টিত অনুগ্ৰহপ্ৰাপ্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","তাতে অধ্যক্ষই কাৰাগাৰত থকা সকলো বন্দীবোৰক যোচেফৰ তত্বাৱধানত শোধাই দিলে; তেতিয়া সিহঁতে তাত কৰা সকলো কাৰ্য যোচেফৰ পৰিচালনাত হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","যোচেফৰ তত্বাৱধানত থকা কোনো বিষয়ক লৈ কাৰাগাৰৰ অধ্যক্ষ চিন্তিত নাছিল; কাৰণ যিহোৱা তেওঁৰ সংগত আছিল আৰু সেয়ে যোচেফে কৰা সকলো কার্যকে যিহোৱাই সফল কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","এইবোৰ ঘটনাৰ পাছত, মিচৰৰ ৰজাৰ প্রধান পান-পাত্ৰ ধৰোঁতা আৰু প্রধান পিঠা প্রস্তুতকাৰীয়ে তেওঁলোকৰ প্ৰভু অর্থাৎ মিচৰৰ ৰজাৰ অহিতে অপৰাধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ফৰৌণে তেওঁৰ এই প্ৰধান পান-পাত্ৰ ধৰোঁতা আৰু প্রধান পিঠা প্রস্তুতকাৰী বিষয়া দুজনৰ ওপৰত ক্রোধিত হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","তাতে যি কাৰাগাৰত যোচেফ আটকাধীন হৈ আছিল, কাৰাৰক্ষক প্রধানৰ সেই একেটা ঘৰৰ কাৰাগাৰতে তেওঁলোকক বন্দী কৰি থলে। ");
INSERT INTO asmfb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","প্রধান কাৰাৰক্ষকে তেওঁলোকক যোচেফৰ পৰিচর্যাৰ অধীনত ৰাখিলে আৰু তেওঁ তেওঁলোকৰ তত্বাৱধান লবলৈ ধৰিলে। এইদৰে তেওঁলোক কিছু দিন সেই কাৰাগাৰত থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","এদিনাখন ৰাতি কাৰাগাৰত আটকাধীন অৱস্থাতে মিচৰৰ ৰজাৰ সেই পান-পাত্ৰ ধৰোঁতা আৰু ৰুটি-প্রস্তুতকাৰী দুয়োৱে এটাকৈ সপোন দেখিলে আৰু প্রত্যেকৰ সপোনৰ নিজস্ব অর্থ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ৰাতিপুৱা যোচেফে তেওঁলোকৰ ওচৰলৈ গৈ তেওঁলোকক মন মাৰি থকা দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","তেতিয়া তেওঁ তেওঁৰ প্ৰভুৰ ঘৰৰ কাৰাগাৰত নিজৰ সৈতে বন্দী হৈ থকা, ফৰৌণৰ সেই দুজন বিষয়াক সুধিলে, “আজি আপোনালোকক কিয় ইমান মন মাৰি থকা দেখা গৈছে?” ");
INSERT INTO asmfb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","তেওঁলোকে ক’লে, “আমি দুয়োজনেই এটাকৈ সপোন দেখিলোঁ; কিন্তু তাৰ অর্থ বুজাবলৈ কোনো নাই।” তেতিয়া যোচেফে তেওঁলোকক ক’লে, “সপোনৰ অর্থ কোৱাৰ ক্ষমতা জানো ঈশ্বৰৰ পৰা নহয়? আপোনালোকে অনুগ্রহ কৰি মোক কওঁকচোন।” ");
INSERT INTO asmfb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","তেতিয়া প্ৰধান পান-পাত্ৰ ধৰোঁতাই যোচেফক নিজৰ সপোনৰ কথা ক’লে। তেওঁ ক’লে, “শুনক, সপোনত মই মোৰ সন্মুখত এজোপা দ্ৰাক্ষালতাৰ গছ দেখিলোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","সেই গছত তিনিটা ডাল আছিল; সেই ডালত কুঁহি মেলাৰ লগে লগে ফুল ফুলিবলৈ ধৰিলে আৰু থোপে থোপে আঙুৰবোৰ লাগি পকি উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ফৰৌণৰ পান-পাত্ৰ তেতিয়া মোৰ হাততে আছিল। মই সেই আঙুৰবোৰ লৈ পাত্ৰটোত চেপি ৰস উলিয়াই ফৰৌণৰ হাতত সেই পান-পাত্ৰ দিলোঁগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","যোচেফে তেওঁক ক’লে, “ইয়াৰ অর্থ হৈছে এই; সেই তিনিটা ডালে তিনি দিন বুজায়। ");
INSERT INTO asmfb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","তিনি দিনৰ ভিতৰত ফৰৌণে আপোনাৰ মূৰ উচ্চ কৰি আপোনাক পুনৰ আগৰ কার্যত নিযুক্তি দিব; আপুনি আগেয়ে পান-পাত্ৰ ধৰোঁতা হৈ যেনেকৈ ফৰৌণৰ হাতত পান-পাত্ৰ তুলি দিছিলে, তেনেকৈয়ে আকৌ দিব। ");
INSERT INTO asmfb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","তেন্তে আপোনাৰ সুদিনৰ সময়ত মোক সুঁৱৰি মোলৈ দয়া কৰি কৃপা দৃষ্টি কৰিব; ফৰৌণৰ আগত মোৰ সম্বন্ধে জনাই মোক এই কাৰাগাৰৰ পৰা উলিয়াই নিব; ");
INSERT INTO asmfb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","কিয়নো সত্য কথা কবলৈ হ’লে ইব্ৰীয়াবিলাকৰ দেশৰ পৰা মোক জোৰ কৰি অনা হৈছিল আৰু এই দেশতো মই এনে একো কার্য কৰা নাই যিহৰ কাৰণে তেওঁলোকে মোক এই কাৰাগাৰত ভৰাই থৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","প্রধান ৰুটি-প্রস্তুতকাৰীয়ে যেতিয়া দেখিলে যে, অন্যজনৰ সপোনৰ অর্থটো ভাল, তেতিয়া তেওঁ যোচেফক ক’লে, “মইও এটা সপোন দেখিলোঁ; শুনক, মই সপোনত মোৰ মূৰৰ ওপৰত ৰুটিৰ তিনিটা খৰাহি থকা দেখিলোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","তাৰে ওপৰৰ খৰাহিটোত আছিল ফৰৌণৰ কাৰণে বিভিন্ন ধৰণৰ তাও দি সেকা আহাৰ; কিন্তু চৰাইবোৰে আহি মোৰ মূৰৰ ওপৰৰ সেই খৰাহিৰ পৰা সেইবোৰ খালে।” ");
INSERT INTO asmfb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","তেতিয়া যোচেফে উত্তৰ দি ক’লে, “আপোনাৰ সপোনৰ অর্থ এই; তিনিটা খৰাহিৰে তিনি দিন বুজায়; ");
INSERT INTO asmfb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","তিনি দিনৰ ভিতৰত ফৰৌণে আপোনাৰ পৰা আপোনাৰ মূৰ কাটি লৈ এডাল কাঠত আৰিব; চৰাইবোৰে আহি আপোনাৰ শৰীৰৰ পৰা মঙহ খাবহি।” ");
INSERT INTO asmfb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","পাছত তৃতীয় দিনা ফৰৌণৰ জন্ম দিন আছিল। ফৰৌণে তেওঁৰ দাসবোৰৰ কাৰণে এক ভোজৰ আয়োজন কৰিলে। সেইদিনা ফৰৌণে তেওঁৰ অন্যান্য দাসবোৰতকৈ তেওঁৰ প্ৰধান পান-পাত্ৰ ধৰোঁতা আৰু প্রধান ৰুটি-প্রস্তুতকাৰীৰ প্রতি বিশেষ মনোযোগ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","তেওঁ প্ৰধান পান-পাত্ৰ ধৰোঁতাক আগৰ কামত নিযুক্ত কৰিলে আৰু তেওঁ পুনৰ ফৰৌণৰ হাতত পান-পাত্র তুলি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","কিন্তু প্রধান ৰুটি-প্রস্তুতকাৰীক হ’লে তেওঁ আৰি থলে। যোচেফে তেওঁলোকক যেনেকৈ সপোনৰ অর্থ কৈছিল, তেনেকৈয়ে ঘটিল। ");
INSERT INTO asmfb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","কিন্তু তথাপিও যোচেফক সহায় কৰিবলৈ প্ৰধান পান-পাত্ৰ ধৰোঁতাৰ মনত নপৰিল; যোচেফৰ কথা তেওঁ একেবাৰে পাহৰি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","এই ঘটনা ঘটি যোৱাৰ সম্পূৰ্ণ দুবছৰৰ পাছত, ফৰৌণে এটা সপোন দেখিলে। তেওঁ নীল নদীৰ দাঁতিত থিয় হৈ আছে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","এনে সময়ত নদীৰ পৰা দেখিবলৈ সুন্দৰ আৰু হৃষ্টপুষ্ট সাতজনী গৰু ওলাই আহি নল বননিত চৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","তাৰ পাছত, দেখিবলৈ কুচ্ছিত আৰু ক্ষীণোৱা আন সাতজনী গৰুও সেই কেইজনীৰ পাছত নীল নদীৰ পৰা ওলাই, নদীৰ দাঁতিত আগতে অহা গৰু কেইজনীৰ ওচৰতে আহি থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","তাতে সেই ক্ষীণোৱা আৰু দেখিবলৈ কুচ্ছিত গৰু কেইজনীয়ে দেখিবলৈ সুন্দৰ আৰু হৃষ্টপুষ্ট সেই গৰু সাতজনীক গিলি পেলালে। এনেতে ফৰৌণে সাৰ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","তাৰ পাছত তেওঁ পুনৰ টোপনি গৈ দ্বিতীয় বাৰ সপোন দেখিলে; তেওঁ দেখিলে ঘেহুঁৰ একে ডাল ঠাৰিতে গুটিৰে ভৰা সাতোটা থোক ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","তেতিয়া চোৱা, সেইবোৰৰ পাছতে, পূবৰ বতাহত লেৰেলি শুকাই যোৱা এনে সাতোটা থোক ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","লেৰেলা থোকবোৰে গুটিৰে ভৰা সেই সাতোটা পূৰঠ থোক গিলি পেলালে। তেতিয়া ফৰৌণে সাৰ পাই দেখিলে যে, এইটো সপোনহে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","যেতিয়া ৰাতি পুৱাল, তেতিয়া তেওঁৰ মনটো অস্থিৰ হৈ উঠিল। তেওঁ মানুহ পঠাই মিচৰ দেশৰ শাস্ত্ৰজ্ঞ আৰু বিদ্বান লোক সকলক মতাই আনিলে আৰু ফৰৌণে তেওঁলোকৰ আগত তেওঁৰ সপোনৰ কথা ক’লে। কিন্তু কোনেও ফৰৌণক এই সপোনৰ ফলিতা দিব নোৱাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","তেতিয়া প্ৰধান পান-পাত্ৰ ধৰোঁতাই ফৰৌণক ক’লে, “আজি মোৰ নিজৰ অপৰাধৰ কথা মনত পৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ফৰৌণে নিজৰ দাসবোৰলৈ ক্রোধিত হৈ মূখ্য ৰান্ধনিৰ সতে মোক কাৰাৰক্ষকৰ অধ্যক্ষৰ ঘৰৰ বন্দীশালত থৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","তেতিয়া সেই ৰাতিয়েই আমি দুয়ো এটা এটা সপোন দেখিলোঁ। আমি দেখা প্রত্যেকটো সপোনৰ বেলেগ বেলেগ অৰ্থ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","তেতিয়া সেই ঠাইত ৰক্ষক-সেনাপতিৰ ওচৰত এজন ইব্ৰীয়া ডেকা বন্দী হৈ আমাৰ লগত আছিল। আমি তেওঁৰ আগত আমাৰ সপোনৰ কথা ক’ওতে, তেওঁ আমাক সপোনৰ অর্থ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","আৰু তেওঁ যেনেকৈ আমাক সপোনৰ অর্থ কৈছিল, তেনেকৈয়ে আমালৈ ঘটিল। মোক মহাৰাজে পুনৰায় আগৰ পদতে নিযুক্ত কৰিলে, কিন্তু অন্য সকলক হ’লে ফাঁচি দিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","তেতিয়া ফৰৌণে যোচেফক আনিবলৈ মানুহ পঠালে। বন্দীশালৰ পৰা তেওঁক যেতিয়া বেগাই উলিয়াই দিয়া হ’ল; তেতিয়া তেওঁ মূৰ খুৰালে আৰু কাপোৰ সলাই ফৰৌণৰ সন্মুখলৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","তাতে ফৰৌণে যোচেফক ক’লে, “মই এটা সপোন দেখিলোঁ, তাৰ অর্থ বুজাই দিব পৰা কোনো নাই; কিন্তু তুমি শুনামাত্ৰে সপোনৰ ফলিতা দিব পাৰা বুলি মই তোমাৰ বিষয়ে শুনিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","তেতিয়া যোচেফে ফৰৌণক উত্তৰ দি ক’লে, “এইটো মোৰ বাবে অসাধ্য। ঈশ্বৰেহে ফৰৌণ ৰজাৰ সপোনৰ অর্থ বুজাই দিয়াৰ লগতে মনত শান্তনা দিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","তেতিয়া ফৰৌণে যোচেফক ক’লে, “মই সপোনত নীল নদীৰ দাঁতিত থিয় হৈ আছিলোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","এনে সময়ত নদীৰ পৰা হৃষ্টপুষ্ট আৰু দেখিবলৈ সুন্দৰ সাত জনী গৰু ওলাই আহি নল বননিত চৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","পাছত চোৱা, ক্ষীণোৱা, দেখিবলৈ কূচ্ছিত, চেৰেলা গাৰে সাত জনী গৰুও সেই কেইজনীৰ পাছত ওলাই আহিল; তেনেকুৱা কুচ্ছিত গৰু মই গোটেই মিচৰ দেশত কেতিয়াও দেখা নাই। ");
INSERT INTO asmfb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","আৰু চেৰেলা গাৰে দেখিবলৈ কুচ্ছিত গৰু কেইজনীয়ে প্ৰথমে হৃষ্টপুষ্ট গৰু সাত জনী গিলি পেলালে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","যেতিয়া হৃষ্টপুষ্ট গৰুবোৰ কুচ্ছিত কেইজনীয়ে খালে, সেইবোৰ চেৰেলা কেইজনীৰ পেটত সোমোৱা যেন নালাগিল। কিন্তু সিহঁত আগৰ দৰে কুচ্ছিত হৈয়েই থকিল। তেতিয়া মই সাৰ পালোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","মই পুনৰাই সপোন দেখিলোঁ, একে ডাল ঠাৰিতে গুটিৰে ভৰা ঘেহুঁৰ উত্তম সাতোটা থোক ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","তেতিয়া সেইবোৰৰ পাছত শুকান, পতনুৱা সেইবোৰ পুবৰ গৰম বতাহত শুকায় গৈছিল, এনে সাতোটা থোকো ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","পাছত সেই শুকান পতনুৱা থোকবোৰে সাতোটা উত্তম থোক গিলি পেলালে। পাছত শাস্ত্ৰজ্ঞসকলক মই ক’লোঁ; কিন্তু কোনেও মোক তাৰ অর্থ ক’ব নোৱাৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","তেতিয়া যোচেফে ফৰৌণক ক’লে, “ফৰৌণৰ সপোনৰ অৰ্থও একেই। ঈশ্বৰে যি কৰিব খুজিছে, তাক তেওঁ ফৰৌণক জনাইছে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","সেই সাত জনী উত্তম গৰু সাত বছৰক বুজায়; সেই সাতোটা উত্তম থোকেও সাত বছৰক বুজায়; সপোনৰ অৰ্থও একেই। ");
INSERT INTO asmfb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","পাছত অহা সেই কুচ্ছিত সাত জনী গৰুও সাত বছৰ, পূবৰ বতাহত শুকুৱা গুটি নথকা সাতোটা থোকেও সাত বছৰক বুজায়। সেইবোৰ আকালৰ সাত বছৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","মই ফৰৌণৰ আগত ইয়াকে ক’লোঁ যে, ঈশ্বৰে যি কৰিব খুজিছে, তাকেহে তেওঁ ফৰৌণক দেখুৱাইছে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","তাতে গোটেই মিচৰ দেশত এনে সাতটা বছৰ আহিব য’ত বহুত শষ্য উৎপন্ন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","সেইবোৰৰ পাছত হ’ব আকালৰ সাত বছৰ, তাতে মিচৰ দেশত বহু শস্যৰ কথা সকলোৱে পাহৰি যাব; আৰু সেই আকালে দেশখনকে নষ্ট কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","এই আকালৰ কাৰণে লোকসকলৰ দেশত, আগতে উৎপন্ন হোৱা বহু শস্যৰ কথা মনত নপৰিব। কিয়নো এইটো অতিশয় ভয়ংকৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ফৰৌণৰ আগত দুবাৰ এই সপোন দেখুৱা হৈছে। ইয়াৰ কাৰণ হৈছে ঈশ্বৰে, নিজ মন স্থিৰ কৰিছে আৰু ঈশ্বৰে অতি শীঘ্ৰেই এই সকলো কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","এই হেতুকে এতিয়া ফৰৌণ ৰজাই এনে এজন বুদ্ধিমান জ্ঞানী মানুহ বিচাৰি আনক, তেওঁক আনি আপুনি মিচৰ দেশৰ ওপৰত নিযুক্ত কৰক। ");
INSERT INTO asmfb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ফৰৌণে এইদৰে কৰক; তেওঁ দেশৰ ওপৰত বিষয়াসকলক পাতক আৰু বহু শস্য উৎপন্ন হোৱা সাত বছৰত, মিচৰ দেশৰ পৰা শস্য পাঁচ ভাগৰ এভাগ তুলি আনক। ");
INSERT INTO asmfb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","এই লোকসকলে অহা বছৰ কেইটাৰ সকলো শস্য গোটাই ফৰৌণৰ অধীনলৈ আহাৰ হ’বৰ কাৰণে নগৰে নগৰে তাক সাঁচি ৰাখক। তাক সুৰক্ষা দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","এইদৰে মিচৰ দেশত আগলৈ হ’ব লগা আকালৰ সাত বছৰৰ কাৰণে, সেই আহাৰ দেশত সঞ্চিত হৈ থাকিব; তাতে আকালত দেশখন বিনষ্ট নহব।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","তেতিয়া ফৰৌণে আৰু তেওঁৰ পাত্ৰমন্ত্ৰীসকলেও এই সকলো কথাকে উত্তম দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","তেতিয়া ফৰৌণে তেওঁৰ পাত্ৰমন্ত্ৰীসকলক ক’লে, “এই যি জন মানুহত ঈশ্বৰৰ আত্মা আছে, এওঁৰ নিচিনা আমি কাক পাম?” ");
INSERT INTO asmfb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","তেতিয়া ফৰৌণে যোচেফক ক’লে, “ঈশ্বৰে তোমাক এই সকলো কথা জনাইছে; এই যে তোমাৰ নিচিনা বুদ্ধিমান জ্ঞানী মানুহ কোনো নাই। ");
INSERT INTO asmfb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","তুমিয়েই মোৰ ঘৰৰ অধ্যক্ষ হ’ব লাগে; মোৰ সকলো প্ৰজা তোমাৰ কথাৰ দৰেই চলিব; কেৱল সিংহাসনতহে মই তোমাতকৈ শ্ৰেষ্ঠ হ’ম।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ফৰৌণে যোচেফক পুনৰ ক’লে, “চোৱা, গোটেই মিচৰ দেশৰ ওপৰত মই তোমাক নিযুক্ত কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","পাছত ফৰৌণে নিজৰ হাতৰ পৰা মোহৰ মৰা আঙঠি সোলোকাই যোচেফৰ হাতৰ আঙুলিত পিন্ধাই দিলে। তেওঁক আৰু মিহি শণ সূতাৰ কাপোৰ পিন্ধাই, ডিঙিত সোণৰ অলঙ্কাৰও দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","তেওঁক নিজৰ দ্বিতীয় ৰথত উঠালে; তাতে লোকসকলে তেওঁৰ আগে আগে “আঁঠুকাঢ়া” বুলি ঘোষণা কৰিলে। এইদৰে ফৰৌণে তেওঁক গোটেই মিচৰ দেশ খনৰ ওপৰত নিযুক্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ফৰৌণে যোচেফক ক’লে, “মই ফৰৌণ, কিন্তু তোমাৰ বিনা অনুমতিত গোটেই মিচৰ দেশত কোনেও হাত, ভৰি লৰচৰ কৰিব নোৱাৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ফৰৌণে যোচেফৰ নাম “চাফনৎপানেহ ৰাখিলে।” তেওঁ ওন নগৰৰ পুৰোহিত পোটী-ফেৰাৰ জীয়েক আচনতৰ লগত বিয়া পাতি দিলে। পাছত যোচেফ গোটেই মিচৰ দেশ খন চাব লৈ ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","যোচেফ মিচৰৰ ৰজা ফৰৌণৰ আগত উপস্থিত হোৱা সময়ত, তেওঁৰ বয়স ত্ৰিশ বছৰ হৈছিল। যোচেফ ফৰৌণ ৰজাৰ আগৰ পৰা ওলাই গ’ল আৰু মিচৰ দেশৰ সকলো ঠাইতে ফুৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","তাতে বহু শস্য হোৱা সেই সাত বছৰত ভূমিয়ে মুঠিয়ে মুঠিয়ে শস্য উৎপন্ন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","মিচৰ দেশত সেই সাত বছৰত উৎপন্ন হোৱা সকলো শস্য গোটাই, তেওঁ নগৰে নগৰে সাঁচি হ’ল; প্ৰত্যেক নগৰৰ চাৰিওফালৰ পথাৰত যি শস্য উৎপন্ন হ’ল, তাক তেওঁ সেই নগৰতে সাঁচি থলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","এইদৰে যোচেফে সাগৰৰ বালিৰ দৰে ইমান বহু শস্য গোটালে যে, তাক পাছত লেখিবলৈকে এৰিলে; কিয়নো সেয়ে অসংখ্য হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","যোচেফৰ দুটি পুত্র আকাল অহাৰ আগেয়ে জন্ম পালে, ওন নগৰৰ পুৰোহিত পোটী-ফেৰাৰ জীয়েক আচনতে জন্ম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","তাতে যোচেফে জ্যেষ্ঠ পুত্ৰৰ নাম মনচি হ’ল; কিয়নো তেওঁ ক’লে, “ঈশ্বৰে মোৰ সকলো দুখ আৰু নিজ পিতৃৰ ঘৰকো পাহৰাইছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","দ্বিতীয় পুত্ৰৰ নাম তেওঁ ইফ্ৰয়িম ৰাখিলে; কাৰণ তেওঁ ক’লে, “ঈশ্বৰে মোক দুখ ভোগ কৰা এই দেশত ফলৱান কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","তাৰ পাছত মিচৰ দেশত বহু শষ্য উৎপন্ন হোৱা সাত বছৰ শেষ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","তাতে যোচেফে কোৱাৰ দৰেই আকালৰ সাত বছৰ আৰম্ভ হ’ল, তেতিয়া সকলো দেশতে আকাল হ’ল; কিন্তু গোটেই মিচৰ দেশত হ’লে আহাৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","যেতিয়া মিচৰ দেশৰ গোটেইখনতে আকাল হ’বলৈ ধৰিলে, তেতিয়া প্ৰজাসকলে আহাৰৰ অৰ্থে ফৰৌণ ৰজাৰ আগত ভিক্ষা খুজিলে গৈ; তাতে ফৰৌণে সকলো মিচৰীয়াকে ক’লে, “তোমালোকে যোচেফৰ ওচৰলৈ যোৱা; তেওঁ যি কৰিবলৈ কয়, তাকে তোমালোকে কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","তেতিয়া গোটেই দেশতে আকাল হ’ল, যোচেফে সকলো ঠাইৰ ভঁৰালবোৰ খুলিলে আৰু মিচৰীয়াসকলৰ ওচৰত শস্য বেচিবলৈ ধৰিলে। সেই সময়ত মিচৰ দেশত ভয়ংকৰ আকাল হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","সকলো দেশৰ মানুহবোৰে শস্য কিনিবৰ কাৰণে মিচৰ দেশত থকা যোচেফৰ ওচৰলৈ আহিল; কিয়নো গোটেই পৃথিৱীত ভীষণ আকাল হ’বলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","যেতিয়া যাকোবে মিচৰত শস্য আছে বুলি শুনা পালে, তেতিয়া তেওঁৰ পুত্ৰসকলক ক’লে, “তোমালোকে ইজনে সিজনৰ মুখলৈ কিয় চোৱাচুই কৰি আছা?” ");
INSERT INTO asmfb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","তেওঁ পুনৰ ক’লে, “চোৱা, মিচৰত শস্য আছে বুলি মই শুনিছোঁ; তোমালোকে তালৈ নামি গৈ, তাৰ পৰা আমাৰ বাবে শস্য কিনি আনাগৈ; তেতিয়াহে আমি নমৰি জীয়াই থাকিব পাৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","যোচেফৰ ককায়েক দহ জনে মিচৰৰ পৰা শস্য কিনি আনিবলৈ নামি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","কিন্তু যোচেফৰ ভায়েক বিন্যামীনক হ’লে, যাকোবে ককায়েকসকলৰ লগত নপঠালে; কিয়নো তেওঁ ক’লে, “কিজানি তাৰ কিবা বিপদ ঘটে।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","এইদৰে শস্য কিনিবলৈ যোৱা মানুহবোৰৰ লগত ইস্ৰায়েলৰ পুত্ৰসকল গ’ল; কিয়নো কনান দেশত আকাল হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","সেই সময়ত যোচেফ মিচৰ দেশৰ অধ্যক্ষ আছিল। তেৱেঁই দেশৰ সকলো লোকক শস্য বেচিছিল। যেতিয়া যোচেফৰ ককায়েকসকলে গৈ তেওঁৰ আগত মাটিত উবুৰি হৈ প্ৰণিপাত কৰিলে, ");
INSERT INTO asmfb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","তেতিয়া যোচেফে তেওঁৰ ককায়েকসকলক দেখি চিনি পালে; কিন্তু তেওঁ অচিনাকিৰ দৰে ব্যৱহাৰ কৰিলে আৰু কঠোৰভাৱে তেওঁলোকৰ লগত কথা পাতিলে। তেওঁ তেওঁলোকক সুধিলে, “তোমালোক ক’ৰ পৰা আহিছা?” তেওঁলোকে ক’লে, “কনান দেশৰ পৰা শস্য কিনিবলৈ আহিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","এইদৰে যোচেফে ককায়েকসকলক চিনি পালে, কিন্তু তেওঁলোকে হ’লে ভায়েকক চিনি নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","যোচেফে তেওঁলোকৰ সম্বন্ধে যি সপোন দেখিছিল, সেই কথা তেতিয়া তেওঁৰ মনত পৰিল। তেওঁ তেওঁলোকক ক’লে, “তোমালোক গুপ্তচৰ। আমাৰ দেশৰ অসুৰক্ষিত অংশবোৰ চাবলৈহে তোমালোক আহিছা।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","তেওঁলোকে তেওঁক ক’লে, “নহয়, মোৰ প্ৰভু; আপোনাৰ এই দাস সকলে শস্য কিনিবলৈহে আহিছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","আমি সকলো এজন লোকৰে পুত্র; আমি সৎ মানুহ। আপোনাৰ দাসবোৰ গুপ্তচৰ নহয়।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","তেতিয়া যোচেফে তেওঁলোকক ক’লে, “নহয়, তোমালোকে দেশৰ অসুৰক্ষিত অংশবোৰ চাবলৈহে আহিছা।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","কিন্তু তেওঁলোকে ক’লে, “আপোনাৰ দাস আমি ভাই ককাই বাৰজন; আমি কনান দেশৰ বাসিন্দা এজন লোকৰেই সন্তান; আমাৰ সকলোতকৈ সৰু ভাইটো বর্তমান পিতাৰ ওচৰত আছে আৰু আন এজন ভাই জীৱিত নাই।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","যোচেফে তেওঁলোকক ক’লে, “মই তোমালোকৰ বিষয়ে যি কৈছোঁ, সেয়াই ঠিক; তোমালোক গুপ্তচৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ইয়াৰেই তোমালোকক পৰীক্ষা কৰা হ’ব - তোমালোকৰ সৰু ভাই যেতিয়ালৈকে ইয়ালৈ নাহে, তেতিয়ালৈকে তোমালোকে এই ঠাই এৰি যাব নোৱাৰিবা। এই কথা মই ফৰৌণৰ জীৱনৰে শপত খাই কৈছো। ");
INSERT INTO asmfb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","সৰু ভাইক আনিবলৈ তোমালোকৰ মাজৰ পৰা এজনক পঠাই দিয়া আৰু আন সকলো বন্দী হৈ থাকা। তাতে তোমালোকৰ কথা সত্য হয় নে নহয়, প্রমাণিত হ’ব। নহ’লে, ফৰৌণৰ জীৱনৰে শপত, তোমালোক যে গুপ্তচৰ, ই নিশ্চিত।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","এইবুলি কৈ যোচেফে তিনি দিনলৈকে তেওঁলোক সকলোকে কাৰাগাৰত বন্দী কৰি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","তৃতীয় দিনা যোচেফে তেওঁলোকক ক’লে, “তোমালোকে মই কোৱাৰ দৰে কৰি প্রাণ ৰক্ষা কৰা; কিয়নো মই ঈশ্বৰ ভয়কাৰী লোক হওঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","তোমালোক যদি সঁচাই সৎ লোক হোৱা, তেন্তে তোমালোকৰ ভাইসকলৰ মাজৰ পৰা এজন এই কাৰাগাৰত বন্দী হৈ থাকক; বাকী সকলোৱে তোমালোকৰ ভোকত থকা পৰিয়ালৰ কাৰণে আকালৰ শস্য লৈ যাওক। ");
INSERT INTO asmfb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","তোমালোকৰ কথা সত্য বুলি প্রমাণ হ’বৰ কাৰণে সৰু ভাইক মোৰ ওচৰলৈ লৈ আনা; তেতিয়াহে তোমালোকৰ প্রাণ ৰক্ষা পাব।” তাতে তেওঁলোকে সেইদৰে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","তাৰ পাছত তেওঁলোকে এজনে আন জনক ক’লে, “বাস্তৱিকতে আমাৰ ভাইৰ বিষয়টোত আমি দোষী; সি যেতিয়া আমাৰ আগত কাকুতি-মিনতি কৰিছিল, তেতিয়া তাৰ মনোকষ্ট দেখিও, আমি কাণসাৰ নিদিলোঁ। সেইবাবেই আমাৰ ওপৰত এই সঙ্কট আহিছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","তেতিয়া ৰূবেণে তেওঁলোকক উত্তৰ দি ক’লে, “মই জানো তোমালোকক কোৱা নাছিলো, ‘ল’ৰাটোৰ প্রতি অন্যায় কৰি পাপ নকৰিবা,’ তথাপিও তোমালোকে নুশুনিলা; এতিয়া চোৱা, আমি তাৰ ৰক্তপাতৰ পৰিশোধ সাধিব লগা হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","যোচেফে যে তেওঁলোকৰ কথাবোৰ বুজি পাইছিল, সেই বিষয়ে তেওঁলোকে নাজানিলে; কিয়নো দুভাষীৰ মাধ্যমেদিহে তেওঁ তেওঁলোকৰ সৈতে কথা-বতৰা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","পাছত যোচেফে তেওঁলোকৰ ওচৰৰ পৰা গ’ল আৰু কান্দিবলৈ ধৰিলে। পুনৰ আহি তেওঁলোকৰ সৈতে কথাবার্তা হ’ল। তেওঁ তেওঁলোকৰ মাজৰ পৰা চিমিয়োনক বাচি ল’লে আৰু তেওঁলোকৰ চকুৰ সন্মুখতে তেওঁক বান্ধিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","তাৰ পাছত যোচেফে নিজৰ দাসবোৰক আদেশ দিলে যেন তেওঁলোকৰ বস্তাবোৰত শস্য ভৰাই দিয়া হয় আৰু প্ৰতিজনে দিয়া ধন তাৰ বস্তাত ওভটাই দিয়া হয়; তাৰ উপৰিও যাত্রাৰ কাৰণে তেওঁলোকৰ প্রয়োজনীয় বস্তুবোৰো দিবলৈ আদেশ দিলে। তাতে তেওঁলোকৰ কাৰণে যোচেফে কোৱাৰ দৰেই সকলো কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","তাৰ পাছত তেওঁলোকে নিজৰ নিজৰ গাধৰ পিঠিত শস্য বোজা তুলি লৈ তাৰ পৰা প্রস্থান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","পাছত বিশ্ৰামৰ ঠাই পাই তেওঁলোকৰ মাজৰ এজনে যেতিয়া নিজৰ গাধক দানা দিবলৈ বস্তা মেলিলে, তেতিয়া তেওঁ নিজৰ ধনখিনি দেখা পালে; ধনখিনি বস্তাৰ মুখতে আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","তাতে তেওঁ ভায়েক-ককায়েকসকলক ক’লে, “এই চোৱাহি, মোৰ ধনখিনি উভটাই দিছে। এয়া চোৱা, মোৰ বস্তাতেই সেই ধন আছে।” তেতিয়া তেওঁলোকৰ প্ৰাণ উড়ি গ’ল। তেওঁলোকে ভয়তে কঁপি কঁপি ইজনে সিজনৰ ফালে ঘূৰি ক’লে, “ঈশ্বৰে নো আমালৈ এইটো কি কৰিলে?” ");
INSERT INTO asmfb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","কনান দেশলৈ উলটি গৈ তেওঁলোকে তেওঁলোকৰ বাপেক যাকোবক তেওঁলোকলৈ যি যি ঘটিল সেই সকলোকে জনাই ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“যি জন লোক সেই দেশৰ প্ৰভু, তেওঁ আমাৰ লগত অতি কর্কশভাৱে কথা পাতিছিল। তেওঁ ভাৱিছিল যে আমি সেই দেশত গুপ্তচৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","কিন্তু আমি তেওঁক কলোঁ, ‘আমি সৎ মানুহ, গুপ্তচৰ নহওঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","আমি ভাই-ককাই বাৰজন, একে পিতাৰে সন্তান; এজন জীৱিত নাই আৰু সকলোতকৈ সৰুটো এতিয়া পিতাৰ লগত কনান দেশত আছে।’ ");
INSERT INTO asmfb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","তেতিয়া সেই দেশৰ যি জন প্ৰভু, তেওঁ আমাক ক’লে, ‘‘বোলে, ইয়াৰ দ্বাৰায়েই মই জানিম যে তোমালোক সৎ মানুহ, সেয়ে তোমালোকৰ এজন ভাইক মোৰ লগত থৈ, ভোকত থকা পৰিয়ালৰ কাৰণে আকালৰ শস্য লোৱা আৰু নিজ বাটে যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","তোমালোকৰ সৰু ভাইক মোৰ ওচৰলৈ লৈ আনা; তেতিয়া মই জানিম যে, তোমালোক গুপ্তচৰ নোহোঁৱা, কিন্তু সৎ লোক। তেতিয়াহে মই তোমালোকৰ ভাইক তোমালোকলৈ মুকলি কৰি দিম আৰু তোমালোকে এই দেশত ব্যৱসায়-বাণিজ্য কৰিব পাৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","তাৰ পাছত তেওঁলোকে নিজৰ বস্তাবোৰ খালী কৰাৰ সময়ত দেখিলে যে, তেওঁলোক প্ৰত্যেকৰ ধনৰ টোপোলাও প্রত্যেকৰ বস্তাৰ ভিতৰত আছে; তাকে দেখি তেওঁলোক আৰু তেওঁলোকৰ পিতৃয়ে ভয় খালে। ");
INSERT INTO asmfb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","তেওঁলোকৰ পিতৃ যাকোবে তেওঁলোকক ক’লে, “তোমালোকে মোক সন্তানহাৰা কৰিছা। যোচেফ গ’ল, চিমিয়োনও নাই আৰু এতিয়া বিন্যামীনকো তোমালোকে লৈ যাব খুজিছা; এই সকলোবোৰ দুখ-কষ্ট মোৰ অহিতেই হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ৰূবেণে তেওঁৰ পিতৃক ক’লে, “মই যদি বিন্যামীনক আপোনাৰ ওচৰলৈ উভটাই আনিব নোৱাৰো, তেন্তে আপুনি মোৰ দুই পুত্ৰকে বধ কৰিব। কেৱল বিন্যামীনক মোৰ হাতত শোধাই দিয়ক, মই পুনৰ তাক আপোনাৰ ওচৰলৈ ঘূৰাই আনিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","তেতিয়া যাকোবে ক’লে, “নহয়, মোৰ পুত্ৰ তোমালোকৰ লগত নাযায়; কিয়নো তাৰ ককায়েক মৰিল আৰু এতিয়া সি অকলে আছে; তোমালোকৰ যাত্রাপথত যদিহে তালৈ কিবা আপদ ঘটে, তেন্তে এই পকা চুলিৰে সৈতে দুখ দি মোক চিয়োললৈহে পঠাবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","কনান দেশত আকালে ভয়ানক ৰূপ লৈ উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","মিচৰ দেশৰ পৰা কিনি অনা শস্য খাই শেষ হোৱাত, তেওঁলোকৰ বাপেকে ক’লে, “তোমালোকে আকৌ যোৱা আৰু আমাৰ বাবে কিছুমান শস্য কিনি আনাগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","যিহূদাই তেওঁক ক’লে, “সেই পুৰুষে আমাক দৃঢ়ভাৱে সতর্ক কৰি দি কৈছিল যে, ‘তোমালোকৰ লগত তোমালোকৰ ভাই নাহিলে, মোৰ মুখ চাব নোৱাৰিবা।’ ");
INSERT INTO asmfb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","এতিয়া তুমি যদি আমাৰ ভাইক আমাৰ লগত পঠোৱা, তেতিয়াহে আমি নামি গৈ তোমাৰ কাৰণে শস্য কিনি আনিম। ");
INSERT INTO asmfb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","কিন্তু যদি নপঠোৱা, তেন্তে আমি নাযাওঁ; কিয়নো সেই লোকে আমাক কৈছিল, ‘তোমালোকৰ লগত তোমালোকৰ ভাই নাহিলে, মোৰ মুখ চাব নোৱাৰিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ইস্ৰায়েলে ক’লে, “তোমালোকে মোলৈ কিয় এনে দুর্ব্যৱহাৰ কৰিলা? তোমালোকৰ যে এজন ভাই আছে সেই কথানো লোকজনক কিয় ক’লা?” ");
INSERT INTO asmfb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","তেওঁলোকে ক’লে, “সেই লোকজনে আমাৰ আৰু আমাৰ পৰিয়ালৰ সম্বন্ধে পুংখানুপুংখভাবে সুধিছিল; তেওঁ সুধিছিল, ‘তোমালোকৰ পিতা এতিয়াও জীয়াই আছে নে? তোমালোকৰ আৰু কোনো ভাই আছে নে?’ আমিও তেওঁৰ প্রশ্নবোৰৰ উত্তৰ সেইদৰেই দিছিলোঁ; পাছত তেওঁ যে আমাক ‘তোমালোকৰ ভাইক লৈ আনা’ বুলি ক’ব অামি কেনেকৈ জানিম?” ");
INSERT INTO asmfb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","তেতিয়া যিহূদাই পিতৃ ইস্ৰায়েলক ক’লে, “আপুনি বিন্যামীনক মোৰ লগত পঠাওঁক; আমি, আপুনি আৰু আমাৰ সন্তানবোৰেৰে সৈতে উভয়ে যেন নমৰি জীয়াই থাকিম, তাৰ বাবে আমি সোনকালে ওলাই যাওঁহক। ");
INSERT INTO asmfb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","মই বিন্যামীনৰ বাবে জামিন হৈছোঁ। বিন্যামীনৰ দায়িত্বক লৈ আপুনি মোকে জগৰীয়া কৰিব। মই যদি তাক ঘূৰাই আনি আপোনাৰ সন্মুখলৈ নানো, তেন্তে চিৰকাল মই আপোনাৰ ওচৰত অপৰাধী হৈ থাকিম। ");
INSERT INTO asmfb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","আমি যদি ইমান পলম নকৰিলোঁ হয়, ইতিমধ্যে আমি দ্বিতীয়বাৰো ঘূৰি আহিব পাৰিলোহেঁতেন।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","তেওঁলোকৰ পিতৃ ইস্ৰায়েলে তেতিয়া ক’লে, “যদি সেয়ে কৰিব লাগে, তেন্তে এতিয়া এটা কাম কৰা। সেই লোকৰ কাৰণে উপহাৰ হিচাবে তোমালোকৰ নিজৰ নিজৰ বস্তাত এই দেশৰ সকলোতকৈ উত্তম দ্ৰব্যবোৰৰ কিছু কিছু লৈ যোৱা; যেনে, কিছু বিষ নিৰাময়ৰ মলম, মৌজোল, মা-মচলা, গন্ধৰস, পেস্তা আৰু বাদাম। ");
INSERT INTO asmfb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","তোমালোকৰ হাতত দুগুণ ধন লোৱা; কাৰণ তোমালোকৰ বস্তাৰ মুখত যি ধন তেওঁলোকে উভটাই দিলে, তাকো ঘূৰাই দিবলৈ লৈ যোৱা। হয়তো ভুলতে সেয়া তোমালোকক দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","তোমালোকৰ ভাইক লৈ সোনকালে সেই লোকৰ ওচৰলৈ আকৌ যোৱাহঁক। ");
INSERT INTO asmfb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","সেই লোক জনে তোমালোকক যেন দয়া কৰে, সৰ্ব্বশক্তিমান ঈশ্বৰে ইয়াকে কৰক আৰু তোমালোকৰ আনজন ভাই চিমিয়োন আৰু বিন্যামীনক তোমালোকলৈ এৰি দিয়ে। মই যদি পুত্রহীনৰ শোক ভুগিব লগাই হয়, তেন্তে তেনেকৈয়ে থাকিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","তেতিয়া তেওঁলোকে সেই উপহাৰ, হাতত দুগুণ ধন আৰু বিন্যামীনক লগত লৈ মিচৰ দেশলৈ নামি গ’ল, আৰু তেওঁলোক যোচেফৰ সন্মুখত উপস্থিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","তাতে তেওঁলোকৰ লগত বিন্যামীনক দেখি, যোচেফে তেওঁৰ ঘৰৰ ঘৰগিৰীক ক’লে, “এই লোকসকলক ঘৰৰ ভিতৰলৈ লৈ আহা আৰু এটা পশু মাৰি আহাৰ যুগুত কৰা; এই লোকসকলে দুপৰীয়া মোৰ সৈতে ভোজন কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","যোচেফে যিদৰে ক’লে, ঘৰগিৰীয়ে সেইদৰেই কৰিলে; তেওঁ তেওঁলোকক যোচেফৰ ঘৰলৈ লৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","যোচেফৰ ঘৰলৈ তেওঁলোকক লৈ যোৱাৰ বাবে তেওঁলোকে ভয়তে কোৱাকুই কৰি ক’লে, “আগৰ বাৰত যি ধন আমাৰ বস্তাৰ ভিতৰত উভটি গ’ল, তাৰ কাৰণেই আমাক তালৈ লৈ আনিছে নেকি; এইবাৰ হয়তো আমাৰ বিৰুদ্ধে দোষ বিচাৰি তেওঁ আমাক বন্দী কৰি থ’ব আৰু আমাৰ গাধবোৰকো লৈ আমাক তেওঁৰ দাস কৰি ৰাখিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","সেয়ে তেওঁলোকে যোচেফৰ ঘৰৰ দুৱাৰ মুখত ঘৰগিৰীজনৰ কাষলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","তেওঁলোকে ক’লে, “মালিক, আমি ইয়াৰ আগেয়েও প্রথমবাৰ শস্য কিনিবলৈ আহিছিলোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","কিন্তু উলটি যোৱাৰ পথত বিশ্রামৰ ঠাই পোৱাত আমি আমাৰ বস্তা মেলোতেই দেখিলোঁ যে, আমাৰ সম্পূর্ণ ধন প্ৰতিজনৰ বস্তাৰ মুখত আছিল; আমি এতিয়া সেই ধন উভটাই আনিছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ইয়াৰ উপৰিও আমি শস্য কিনিবলৈ লগত ধন আনিছোঁ। আমাৰ সেই ধন আমাৰ বস্তাৰ ভিতৰত কোনে যে সুমুৱাই দিছিল, তাক আমি নাজানো।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","সেই ঘৰগিৰীয়ে তেতিয়া কলে, “আপোনালোকে ভয় কৰিব নালাগে, শান্তি মনেৰে থাকক। আপোনালোকৰ আৰু আপোনালোকৰ পিতৃৰ ঈশ্বৰেই নিশ্চয়কৈ সেই ধন আপোনালোকৰ বস্তাত ৰাখিছিল। মই কিন্তু আপোনালোকৰ ধন পালোঁ।” পাছত ঘৰগিৰীজনে চিমিয়োনক বাহিৰ কৰি তেওঁলোকৰ ওচৰলৈ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","তাৰ পাছত ঘৰগিৰীয়ে সেই সকলো লোকক যোচেফৰ ঘৰৰ ভিতৰলৈ লৈ গৈ পানী দিলে আৰু তেওঁলোকে নিজৰ ভৰি ধুলে; তেওঁ তেওঁলোকৰ গাধবোৰকো খাবলৈ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","যোচেফ দুপৰীয়া আহিব বুলি তেওঁলোকে নিজৰ নিজৰ উপহাৰবোৰ যুগুত কৰি ৰাখিলে। কিয়নো তেওঁলোকে শুনিছিল যে তেওঁলোকৰ খোৱা-বোৱা তাতেই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","যোচেফ যেতিয়া ঘৰলৈ আহিল, তেতিয়া তেওঁলোকে নিজৰ নিজৰ উপহাৰবোৰ ঘৰৰ ভিতৰলৈ আনি তেওঁক দিলে আৰু মাটিত উবুৰি হৈ পৰি তেওঁক প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","তেওঁলোকৰ কুশল মঙ্গল জনাৰ পাছত তেওঁ তেওঁলোকক সুধিলে, “তোমালোকৰ বৃদ্ধ পিতাৰ কথা যে তোমালোকে কৈছিলা, তেওঁ ভালে আছে নে? তেওঁ এতিয়ালৈকে জীয়াই আছে নে?” ");
INSERT INTO asmfb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","তেওঁলোকে ক’লে, “আপোনাৰ দাস আমাৰ পিতৃ এতিয়াও জীয়াই আছে আৰু তেওঁ ভালে আছে।” এই বুলি তেওঁলোকে উবুৰি হৈ প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","তেতিয়া তেওঁ চকু তুলি নিজ মাকৰ পুতেক ভায়েক বিন্যামীনক দেখি ক’লে, “এওঁৱেই নেকি তোমালোকৰ সেই সৰু ভাই, যি জনৰ কথা তোমালোকে মোক কৈছিলা?” তেওঁ তাক ক’লে, “বোপা, ঈশ্বৰে তোমাক আশীর্বাদ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","নিজ ভায়েকক দেখি মৰমতে যোচেফৰ অন্তৰ শোকত ভাগি পৰিল। তেওঁ কান্দিবলৈ ঠাই বিচাৰি বেগাবেগিকৈ সেই ঠাইৰ পৰা ওলাই গ’ল আৰু নিজৰ কোঁঠালিত সোমাই কান্দিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","পাছত তেওঁ নিজৰ চকু-মুখ ধুই বাহিৰলৈ আহিল আৰু নিজকে নিয়ন্ত্রণ কৰি আহাৰ পৰিবেশন কৰিবলৈ ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","তেতিয়া দাসবোৰে যোচেফক, তেওঁৰ ভায়েক-ককায়েকসকলক আৰু যি মিচৰীয়সকলে যোচেফৰ লগত ভোজন কৰে, তেওঁলোকক বেলেগ বেলেগকৈ খাবলৈ দিলে; কিয়নো মিচৰীয়সকলে ইব্ৰীয়াসকলৰ সৈতে খোৱা-বোৱা নকৰে; কাৰণ সেয়া মিচৰীয়সকলৰ কাৰণে এক ঘৃণনীয় কাৰ্য। ");
INSERT INTO asmfb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ভায়েক-ককায়েকসকল যোচেফৰ সন্মুখত বয়স অনুসাৰে জ্যেষ্ঠৰ পৰা কনিষ্ঠজন বহিল। তাতে তেওঁলোক সকলোৱে একেলগে আচৰিত মানিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","তাৰ পাছত যোচেফে তেওঁৰ নিজৰ সন্মুখৰ আহাৰৰ পৰা কিছু ভাগ ভায়েক-ককায়েকসকলক দিবলৈ দিলে। কিন্তু আন সকলো ভায়েক-ককায়েকসকলৰ ভাগতকৈ বিন্যামীনক পাঁচ গুণ অধিক দিয়া হ’ল। এইদৰে তেওঁলোকে যোচেফৰ সৈতে ভোজন-পান কৰি আনন্দ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","যোচেফে তেওঁৰ ঘৰৰ ঘৰগিৰীক আদেশ দি ক’লে, “এই লোকসকলে যিমান শস্য লৈ যাব পাৰে, তেওঁলোকৰ বস্তাবোৰ সিমানকৈ পূৰ কৰি দিয়া আৰু প্ৰতিজন লোকৰ ধন তেওঁলোকৰ বস্তাৰ মুখত থ’বা। ");
INSERT INTO asmfb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","মোৰ ৰূপৰ পিয়লাটো সবাটোকৈ সৰুটোৰ শস্য ভৰোৱা বস্তাৰ মুখত থ’বা; শস্য কিনাৰ বাবে অনা তাৰ ধনখিনিও থ’বা।” তেতিয়া ঘৰগিৰী জনে যোচেফে কোৱাৰ দৰেই কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","পাছদিনা অতি পুৱাতেই লোকসকলক তেওঁলোকৰ গাধবোৰৰ সৈতে বিদায় দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","তেওঁলোক নগৰৰ পৰা ওলাই যোৱাৰ পাছত, অধিক দূৰ গৈ পোৱাৰ আগতেই যোচেফে তেওঁৰ ঘৰগিৰীক ক’লে, “সোনকালে সেই লোকসকলৰ পাছে পাছে যোৱা। তেওঁলোকক লগ পাই ক’বা, ‘তোমালোকে উপকাৰৰ সলনি কিয় অপকাৰ কৰি আহিলা? কিয় তোমালোকে মোৰ প্রভুৰ পিয়লা চুৰ কৰিলা? ");
INSERT INTO asmfb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","সেইটো পিয়লাতে মোৰ প্ৰভুৱে পান কৰে আৰু মঙ্গল চোৱাৰ কাৰণেও ব্যৱহাৰ কৰে? তোমালোকে এই কৰ্ম কৰি অতি অন্যায় কৰিছা’।” ");
INSERT INTO asmfb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","এইদৰে সেই ঘৰগিৰীয়েও গৈ বাটত তেওঁলোকক লগ ধৰিলে আৰু এইবোৰ কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","কিন্তু তেওঁলোকে তেওঁক ক’লে, “মহাশয়, আপুনি কিয় এনেবোৰ কথা কৈছে? আপোনাৰ দাসবোৰৰ পৰা এনে ধৰণৰ কৰ্ম কৰা দূৰ হওক। ");
INSERT INTO asmfb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","চাওক, যোৱাবাৰ আমাৰ বস্তাৰ মুখত যি ধন পাইছিলোঁ, সেয়া আমি কনান দেশৰ পৰা পুনৰ আপোনালৈ ওভটাই আনিলো; তেন্তে আপোনাৰ প্ৰভুৰ ঘৰৰ পৰা আমি ৰূপ বা সোণ কেনেকৈ চুৰ কৰি আনিব পাৰোঁ? ");
INSERT INTO asmfb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","যদি সেই পিয়লা আপোনাৰ এই দাসবোৰৰ কোনোবা এজনৰ ওচৰত পোৱা যায়, তেন্তে তাৰ মৃত্যু হওঁক আৰু আমিও প্ৰভুৰ দাস হৈ থাকিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","তেতিয়া ঘৰগিৰীজনে ক’লে, “ঠিক আছে, আপোনালোকৰ কথাৰ দৰেই হওক; কিন্তু যিজনৰ ওচৰত সেই পিয়লা পোৱা যাব, কেৱল তেৱেঁ মোৰ দাস হ’ব; আন সকলো নিৰ্দ্দোষী হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","তেতিয়া তেওঁলোকে বেগতে নিজৰ বস্তা মাটিত নমাই খুলিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ঘৰগিৰীয়ে ডাঙৰজনৰ পৰা আৰম্ভ কৰি শেষত সৰুজনলৈকে বিচাৰোতে বিন্যামীনৰ বস্তাৰ ভিতৰত সেই পিয়লা পোৱা গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","তেতিয়া তেওঁলোকে নিজৰ কাপোৰ ফালিলে। নিজৰ গাধত বোজাবোৰ দি পুনৰ নগৰলৈ উভটি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","যিহূদা আৰু তেওঁৰ ভায়েক-ককায়েকসকল যেতিয়া যোচেফৰ ঘৰ আহি পালে, যোচেফ তেতিয়াও তাতে আছিল। তেওঁলোকে তেওঁৰ সন্মুখলৈ গৈ মাটিত উবুৰি হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","তেতিয়া যোচেফে তেওঁলোকক ক’লে, “তোমালোকেনো এইটো কি কাম কৰিলা? তোমালোকে নাজানা নে যে মোৰ নিচিনা এজন লোকে মঙ্গল চোৱাৰ অভ্যাস কৰিব পাৰে?” ");
INSERT INTO asmfb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","যিহূদাই ক’লে, “মোৰ প্ৰভুকনো আমি কি ক’ম? উত্তৰেইবা কি দিম? কেনেদৰেইবা আমি নিজক নিৰ্দ্দোষী বুলি প্রমাণ কৰিম? আপোনাৰ দাসবোৰৰ অপৰাধ ঈশ্বৰেই প্ৰকাশ কৰি দিলে; যাৰ হাতত সেই পিয়লাটো পোৱা গৈছে, চাওঁক, সি আৰু আমি সকলোৱেই মোৰ প্ৰভুৰ দাস হলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","তাতে যোচেফে ক’লে, “এনে কৰ্ম কৰা মোৰ পৰা দূৰ হওঁক; যাৰ হাতত পিয়লাটো পোৱা গৈছে, তেওঁহে মোৰ দাস হ’ব; কিন্তু আন সকলোৱে শান্তিৰে তোমালোকৰ পিতৃৰ কাষলৈ ঘূৰি যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","তেতিয়া যিহূদাই তেওঁৰ ওচৰলৈ আগুৱাই গৈ ক’লে, “হে মোৰ মালিক, ফৰৌণ যেনে আপুনিও তেনে। দয়া কৰি মোৰ প্ৰভুৰ কাণত আপোনাৰ এই দাসক এষাৰ কথা জনাবলৈ অনুমতি দিয়ক। আপোনাৰ এই দাসৰ ওপৰত আপোনাৰ ক্ৰোধ প্রজ্বলিত নহওঁক। ");
INSERT INTO asmfb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","মোৰ প্ৰভুৱে তেওঁৰ এই দাসবোৰক সুধিছিল, ‘তোমালোকৰ পিতৃ আৰু কোনো ভাই আছে নে?’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","তাতে আমি প্ৰভুক কৈছিলোঁ, ‘আমাৰ এজন বৃদ্ধ পিতা আছে আৰু তেওঁৰ বুঢ়া কালৰ এজন সৰু ল’ৰাও আছে; তাৰ ককায়েকৰ মৃত্যু হৈছে আৰু একে মাকৰ সন্তান হিচাবে সি এতিয়া অকলেই আছে; সেয়ে তাৰ পিতাই তাক অতি মৰম কৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","পাছত আপুনি আপোনাৰ এই দাসবোৰক কৈছিল, ‘তাক মোৰ ওচৰলৈ লৈ আনা, মই তাক চাব বিচাৰো।’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","তেতিয়া আমি প্ৰভুক কৈছিলোঁ, ‘ল’ৰাটিয়ে তাৰ পিতাকক এৰি আহিব নোৱাৰে; কিয়নো যদি আহে, তেন্তে তাৰ পিতাৰ মৃত্যু হ’ব।’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","কিন্তু আপুনি আপোনাৰ দাসবোৰক কৈছিল, ‘তোমালোকৰ সৰু ভাইক লগত লৈ নাহিলে, তোমালোকে পুনৰ মোৰ মুখ দেখা নাপাবা।’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","সেয়ে মোৰ প্ৰভুৰ সকলো কথা আমি আপোনাৰ দাস, মোৰ পিতাক কৈছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","পাছত আমাৰ পিতায়ে কৈছিল, ‘তোমালোকে পুনৰ গৈ আমাৰ বাবে কিছু শস্য কিনি আনাগৈ।’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","তেতিয়া আমি ক’লোঁ, ‘আমাৰ সৰু ভাই যদি আমাৰ লগত যায়, তেতিয়াহে আমি যাম। নহ’লে আমি যাব নোৱাৰো। কিয়নো আমাৰ সৰু ভাই যদি আমাৰ লগত নাথাকে, তেন্তে সেই পুৰুষৰ মুখকে আমি দেখিবলৈ নাপাম।’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","তেতিয়া আপোনাৰ দাস অর্থাৎ মোৰ পিতায়ে আমাক ক’লে, ‘তোমালোকেতো জানাই যে মোৰ ভাৰ্যাই মোলৈ দুটি পুত্ৰ প্ৰসৱ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","তাৰে এটি মোৰ পৰা ওলাই গ’ল আৰু মই কলোঁ, ‘নিশ্চয় কোনো জন্তুৱে তাক ডোখৰ ডোখৰ কৰি ছিৰাছিৰ কৰিলে; তাৰ পাছৰ পৰাই মই তাক পুনৰ দেখা নাপালোঁ; ");
INSERT INTO asmfb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","এতিয়া যদি তোমালোকে ইয়াকো মোৰ ওচৰৰ পৰা লৈ যোৱা আৰু তাৰ যদি কোনো ক্ষতি হয়, তেন্তে এই পকা চুলিৰে সৈতে শোকতে মোক তোমালোকে চিয়োললৈ পঠাবা।’ ");
INSERT INTO asmfb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","গতিকে, এতিয়া মই আপোনাৰ দাসৰ কাষলৈ অর্থাৎ মোৰ পিতাৰ কাষলৈ যদি ল’ৰাটো অবিহনে উভটি যাওঁ আৰু যিহেতু ল’ৰাটোৰ লগত তেওঁৰ প্রাণ একেলগে বন্ধা আছে, ");
INSERT INTO asmfb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","সেয়ে ল’ৰাটোক আমাৰ লগত নেদেখিলে, তেওঁৰ নিশ্চয়ে মৃত্যু হ’ব। তাতে আপোনাৰ এই দাসবোৰে আপোনাৰ দাস অর্থাৎ আমাৰ পিতাইক তেওঁৰ পকা চুলিৰে সৈতে শোকতে চিয়োললৈ পঠাব; ");
INSERT INTO asmfb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","মই, এই আপোনাৰ দাসে মোৰ পিতাৰ ওচৰত এই ল’ৰাৰ কাৰণে জামিন হৈ কৈছিলোঁ, ‘মই যদি তাক আপোনাৰ ওচৰলৈ নানো, তেন্তে পিতা মই চিৰকাললৈকে আপোনাৰ ওচৰত অপৰাধী হৈ থাকিম। ");
INSERT INTO asmfb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","সেয়ে মোৰ প্ৰভু, দয়া কৰি সেই ল’ৰাৰ পৰিবর্তে মোকে আপোনাৰ দাসৰ দৰে ৰাখক আৰু ল’ৰা জনক তাৰ ককায়েকসকলৰ সৈতে ঘূৰি যাবলৈ দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","কিয়নো, ল’ৰা জনক লগত নিনিয়াকৈ মই কেনেকৈ পিতাৰ ওচৰলৈ উলটি যাম? মোৰ পিতালৈ যি আপদ ঘটিব, তাক মই চাব নোৱাৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","তেতিয়া যোচেফে তেওঁৰ কর্মচাৰীসকলৰ সন্মুখত নিজকে নিয়ন্ত্রণত ৰাখিব নোৱাৰিলে। তেওঁ চিঞঁৰি ক’লে, “মোৰ আগৰ পৰা সকলো গুছি যাওঁক।” সেয়ে ভায়েক-ককায়েকসকলৰ ওচৰত যোচেফে যেতিয়া নিজৰ পৰিচয় দিছিল, তেতিয়া তেওঁৰ কাষত কোনো দাস থিয় হৈ থকা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","তাৰ পাছত তেওঁ চিঞঁৰি চিঞঁৰি ইমানকৈ কান্দিব ধৰিলে যে, মিচৰীয়সকলে তেওঁৰ কান্দোন শুনা পালে আৰু ফৰৌণৰ ঘৰত থকা লোকসকলেও শুনা পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","যোচেফে ককায়েকসকলক ক’লে, “মই যোচেফ! মোৰ পিতৃ কি এতিয়াও জীয়াই আছে?” এই কথা শুনি তেওঁৰ ককায়েকসকলে একো উত্তৰ দিব নোৱাৰিলে; কাৰণ যোচেফৰ উপস্থিতিত তেওঁলোক হতবুদ্ধি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","তেতিয়া যোচেফে তেওঁৰ ভায়েক-ককায়েকসকলক ক’লে, “তোমালোকে অনুগ্রহ কৰি মোৰ ওচৰ চাপি আহাঁ।” তাতে তেওঁলোকে ওচৰ চাপি অহাত তেওঁ ক’লে, “মই যোচেফ, তোমালোকৰ সেই ভাই, যি জনক তোমালোকে মিচৰ দেশলৈ বিক্রী কৰি দিছিলা। ");
INSERT INTO asmfb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","কিন্তু তোমালোকে মোক ইয়াত বিক্রী কৰি দিছিলা বুলি এতিয়া বেজাৰ নকৰিবা নাইবা নিজৰ ওপৰত খং নকৰিবা। কিন্তু প্ৰাণ ৰক্ষা কৰিবৰ কাৰণেহে ঈশ্বৰে তোমালোকৰ আগেয়ে মোক ইয়ালৈ পঠিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","কাৰণ, এই দুবছৰ ধৰি দেশত আকাল হৈছে; এইদৰে আৰু পাঁচ বছৰ কাল চলিব; কোনো খেতি কৰা নহ’ব আৰু শস্য দোৱাও নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","পৃথিবীত অৱশেষ স্বৰূপে তোমালোকৰ বংশক জীৱিত ৰাখিবৰ কাৰণে আৰু ধ্বংসৰ পৰা উদ্ধাৰ কৰি তোমালোকৰ প্ৰাণ ৰক্ষা কৰিবৰ কাৰণে ঈশ্বৰে তোমালোকৰ আগেয়ে মোক পঠাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","গতিকে, তোমালোকে মোক ইয়ালৈ পঠোৱা নাই, ঈশ্বৰেহে পঠালে; তেওঁ মোক ফৰৌণৰ এজন পিতৃৰ স্থানত ৰাখিলে আৰু তেওঁৰ গোটেই পৰিয়ালৰ অধিপতি কৰিলে। ইয়াৰোপৰি তেওঁ মোক গোটেই মিচৰ দেশৰ ওপৰত শাসনকৰ্ত্তা পাতিলে।” ");
INSERT INTO asmfb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","এতিয়া তোমালোকে অতি শীঘ্রেই পিতাৰ ওচৰলৈ গৈ তেওঁক কোৱাগৈ যে, “আপোনাৰ পুত্র যোচেফে এই কথা কৈছে, ‘ঈশ্বৰে মোক সমুদায় মিচৰ দেশৰ অধিপতি কৰিলে; আপুনি এতিয়া পলম নকৰি মোৰ ওচৰলৈ নামি আহঁক। ");
INSERT INTO asmfb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","আপুনি আহি গোচন এলেকাত বাস কৰিব; তাতে আপুনি আৰু আপোনাৰ ল’ৰা-ছোৱালী, আপোনাৰ নাতি-নাতিনী, আপোনাৰ পশু আৰু মেৰ-ছাগৰ জাককে আদি কৰি যি সকলো আপোনাৰ আছে, সেই সকলোবোৰ লৈ মোৰ কাষত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","আপোনাৰ, আপোনাৰ পৰিয়ালৰ আৰু আপোনাৰ আন লোক সকলৰ যাতে কোনো অভাৱ নহয়, সেইবাবে মই সেই ঠাইতে আপোনালোকৰ বাবে যোগানৰ ব্যৱস্থা কৰিম। কিয়নো আকাল শেষ হ’বলৈ এতিয়াও পাঁচ বছৰ আছে।’ ");
INSERT INTO asmfb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","মই যে নিজ মুখেৰে তোমালোকক এইবোৰ কৈছোঁ, ইয়াক তোমালোকে নিজৰ চকুৰে দেখা পাইছা আৰু মোৰ ভাই বিন্যামীনৰ চকুৱেও দেখিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","মিচৰ দেশত থকা মোৰ ক্ষমতাৰ বিষয়ে আৰু যি সকলোবোৰ দেখিছা, সেইবোৰৰ বিষয়ে মোৰ পিতাৰ ওচৰত গৈ জনাবা। এতিয়া সোনকাল কৰা আৰু পিতাক ইয়ালৈ লৈ আনাগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","তেতিয়া তেওঁ তেওঁৰ ভায়েক বিন্যামীনৰ ডিঙিত ধৰি কান্দিবলৈ ধৰিলে আৰু বিন্যামীনেও তেওঁৰ ডিঙিত ধৰি কান্দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","পাছত যোচেফে তেওঁৰ সকলো ভায়েক-ককায়েকক চুমা খালে আৰু তেওঁলোকৰো ডিঙিত ধৰি কান্দিলে; তাৰ পাছতহে তেওঁৰ ককায়েকসকলে তেওঁৰ লগত কথা পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","যোচেফৰ ভায়েক-ককায়েকসকল অহাৰ বাতৰি যেতিয়া ফৰৌণৰ ঘৰৰ লোকসকলে শুনিবলৈ পালে, তেতিয়া ফৰৌণ আৰু তেওঁৰ কর্মচাৰীসকল অতিশয় আনন্দিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ফৰৌণে যোচেফক ক’লে, “তোমাৰ ভাই-ককাইসকলক ক’বা, ‘তেওঁলোকে যেন এনেদৰে কৰে: তেওঁলোকৰ গাধবোৰত শস্যৰ বোজা লৈ তেওঁলোক কনান দেশলৈ উলটি যাওঁক ");
INSERT INTO asmfb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","আৰু তেওঁলোকৰ পিতৃৰ সৈতে সপৰিবাৰক লৈ তেওঁলোক মোৰ ওচৰলৈ আহক।’ ইয়াকো ক’বা যে, ‘মিচৰ দেশৰ উত্তম উত্তম বস্তু মই তেওঁলোকক দিম আৰু দেশৰ ভাল খাদ্য তেওঁলোকে ভোগ কৰিবলৈ পাব।’ ");
INSERT INTO asmfb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","এতিয়া তোমাক মই আদেশ দিছো, ‘তুমি তোমাৰ ভাই-ককাইসকলক ক’বা: ‘তোমালোকৰ ল’ৰা-ছোৱালী, ভার্য্যাসকলৰ কাৰণে মিচৰ দেশৰ পৰা কিছুমান পশুৱে টনা গাড়ী লৈ যোৱা আৰু তোমালোকৰ পিতৃক লৈ ঘূৰি আহাঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","তোমালোকে তোমালোকৰ বস্তুবোৰক লৈ চিন্তা নকৰিবা, কাৰণ সমগ্র মিচৰ দেশৰ উত্তম উত্তম বস্তুবোৰতো তোমালোকৰেই’।” ");
INSERT INTO asmfb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","পাছত ইস্ৰায়েলৰ পুত্ৰসকলে তেনেকৈয়ে কৰিলে; ফৰৌণৰ আদেশ অনুসাৰে যোচেফে তেওঁলোকৰ কাৰণে গাড়ী আৰু পথত যোৱাৰ বাবে প্ৰয়োজনীয় বস্তুবোৰো দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","তেওঁ তেওঁলোকৰ প্রত্যেককে এযোৰকৈ পোছাক দিলে; কিন্তু বিন্যামীনক হ’লে তেওঁ তিনিশ চেকল ৰূপৰ মুদ্ৰা আৰু পাঁচ যোৰ পোছাক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","তাৰ পাছত তেওঁৰ পিতৃৰ কাৰণে তেওঁ এইখিনি বস্তু পঠালে: দহটা গাধ আৰু দহজনী গাধী। এই দহটা গাধৰ পিঠিত মিচৰ দেশৰ উত্তম উত্তম বস্তুবোৰ বোজাই কৰা আছিল আৰু গাধীবোৰৰ পিঠিত আছিল পিতৃৰ বাটৰ বাবে শস্য, পিঠা অাৰু আন আন খোৱা বস্তু সমূহ। ");
INSERT INTO asmfb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","এইদৰে ব্যৱস্থা কৰি তেওঁ নিজৰ ভায়েক-ককায়েকসকলক পঠাই দিলে। বিদায়ৰ সময়ত তেওঁ তেওঁলোকক ক’লে, “সাৱধান, বাটত তোমালোকে কাজিয়া-পেচাল নকৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","পাছত তেওঁলোকে মিচৰ দেশৰ পৰা গৈ কনান দেশত থকা তেওঁলোকৰ পিতৃ যাকোবৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","তেওঁলোকে তেওঁক ক’লে, “যোচেফ এতিয়াও জীয়াই আছে, আৰু সিয়েই গোটেই মিচৰ দেশৰ শাসনকৰ্তা।” যাকোবে যেতিয়া এই কথা শুনিলে, তেতিয়া তেওঁ স্তম্ভিত হৈ পৰিল; কিয়নো পুত্রসকলৰ কথাষাৰ তেওঁৰ বিশ্বাসেই হোৱা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","পাছত যোচেফে তেওঁলোকক যি যি কৈছিল, সেইবোৰ শুনি আৰু তেওঁক লৈ যোৱাৰ কাৰণে যোচেফে যি গাড়ী পঠাইছিল, তাকে দেখি তেওঁলোকৰ পিতৃ যাকোবৰ মন জাগি উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","তেওঁ ক’লে, “মোৰ পুত্ৰ যোচেফ যে এতিয়াও জীয়াই আছে, সেয়াই যথেষ্ট; মৃত্যুৰ আগতে মই গৈ তাক চাম।” ");
INSERT INTO asmfb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ইস্ৰায়েলে নিজৰ সকলোকে লগত লৈ যাত্ৰা আৰম্ভ কৰিলে আৰু গৈ বেৰ-চেবা পালে। তাতে তেওঁ নিজ পিতৃ ইচহাকৰ ঈশ্বৰৰ উদ্দেশ্যে বলি উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ঈশ্বৰে ৰাতি দৰ্শনত ইস্ৰায়েলৰ লগত কথা ক’লে; তেওঁ ক’লে, “যাকোব, হে যাকোব।” যাকোবে ক’লে, “এয়া মই আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ঈশ্বৰে ক’লে, “মই ঈশ্বৰ, তোমাৰ পিতৃৰ ঈশ্বৰ। মিচৰ দেশলৈ নামি যাবলৈ ভয় নকৰিবা; কিয়নো মই সেই ঠাইতে তোমাৰ পৰা এক মহাজাতিৰ সৃষ্টি কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","মই তোমাৰ সংগে সংগে মিচৰলৈ নামি যাম আৰু পুনৰ ময়েই তোমাক নিশ্চয় উভটাই আনিম। মৃত্যুকালত যোচেফে নিজ হাতেৰে তোমাৰ চকু বন্ধ কৰি দিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","তাৰ পাছত যাকোব বেৰ-চেবাৰ পৰা ৰাওনা হ’ল; ইস্ৰায়েলৰ পুত্রসকলে তেওঁলোকৰ পিতৃ যাকোবক আৰু তেওঁলোকৰ ভার্য্যাৰে সৈতে লৰা-ছোৱালীকবোৰক লৈ ফৰৌণে যাকোবক নিবৰ কাৰণে পঠোৱা বাহনবোৰত উঠি যাত্রা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","যি সকলো পশুধন আৰু ধন-সম্পত্তি তেওঁলোকে কনান দেশত লাভ কৰিছিল, সেই সকলোবোৰ লগত লৈ যাকোব আৰু তেওঁৰ সকলো বংশধৰেই মিচৰ দেশ অভিমুখে যাত্ৰা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","এইদৰে যাকোবে তেওঁৰ পুতেক-জীয়েক, নাতি-নাতিনী আৰু তেওঁৰ বংশধৰ সকলোকে নিজৰ লগত লৈ মিচৰ দেশলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ইস্ৰায়েলীয়াসকল অর্থাৎ যাকোব আৰু তেওঁৰ বংশৰ যি সন্তান সকল মিচৰ দেশলৈ আহিছিল, তেওঁলোকৰ নামৰ তালিকা এই: যাকোবৰ জেষ্ঠ পুত্ৰ ৰূবেণ। ");
INSERT INTO asmfb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ৰূবেণৰ পুত্র হনোক, পল্লু, হিষ্রোণ, আৰু কৰ্ম্মী। ");
INSERT INTO asmfb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","চিমিয়োনৰ পুত্র যিমূৱেল, যামীন, ওহদ, যাখীন, চোহৰ আৰু চৌল। চৌল এগৰাকী কনানীয়া মহিলাৰ পুত্র। ");
INSERT INTO asmfb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","লেবীৰ পুত্র গেৰ্চোন, কহাৎ, আৰু মৰাৰী। ");
INSERT INTO asmfb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","যিহূদাৰ পুত্র এৰ, ওনন, চেলা, পেৰচ, আৰু জেৰহ; এৰ আৰু ওনন কনান দেশতে মৰিল। পেৰচৰ পুত্র হিষ্ৰোণ আৰু হামূল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ইচাখৰৰ পুত্র তোলা, পুব্বা, যোব আৰু চিম্ৰোণ। ");
INSERT INTO asmfb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","জবূলূনৰ পুত্র চেৰদ, এলোন আৰু যহলেল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","জীয়েক দীনাৰে সৈতে এওঁলোক লেয়াৰ দ্বাৰা যাকোবৰ বংশ। এওঁলোক পদ্দন-অৰামত জন্মিছিল। পুত্র আৰু জীয়ৰীৰে সৈতে এওঁলোক সৰ্ব্বমুঠ তেত্ৰিশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","গাদৰ পুত্র চিপুন, হগ্গী, চূনী, ইচবোন, এৰী, আৰোদী আৰু অৰেলী। ");
INSERT INTO asmfb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","আচেৰৰ পুত্র যিম্না, যিচবা, যিচবি, বৰীয়া, আৰু তেওঁলোকৰ ভনীয়েক চেৰহ; বৰীয়াৰ পুত্র হেবৰ আৰু মল্কীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","এওঁলোক হ’ল, লাবনে নিজৰ জীয়েক লেয়াৰ লগত দিয়া জিল্পাৰ যোগেদি; এওঁলোক আছিল সৰ্ব্বমুঠ ষোল্লজন। ");
INSERT INTO asmfb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","যাকোবৰ ভাৰ্যা ৰাহেলৰ পুত্ৰ যোচেফ আৰু বিন্যামীন। ");
INSERT INTO asmfb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ওন নগৰৰ পুৰোহিত পোটী-ফেৰাৰ জীয়েক আচনতে প্ৰসব কৰা মনচি আৰু ইফ্ৰয়িম, যোচেফৰ এই দুই পুত্ৰ মিচৰ দেশত জন্মিছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","বিন্যামীনৰ পুত্র বেলা, বেখৰ, অচবেল, গেৰা, নামন, এহী, ৰোচ, মূপপীম, হুপপীম আৰু অৰ্দ। ");
INSERT INTO asmfb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","এওঁলোক ৰাহেলে জন্ম দিয়া যাকোবৰ সন্তান; এওঁলোক আছিল সৰ্ব্বমুঠ চৌদ্ধ জন। ");
INSERT INTO asmfb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","দানৰ পুত্র হূচীম। ");
INSERT INTO asmfb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","নপ্তালীৰ পুত্র যহচিয়েল, গূনী, যেচৰ, আৰু চিল্লেম। ");
INSERT INTO asmfb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","এওঁলোক হ’ল, লাবনে নিজৰ জীয়েক ৰাহেলৰ লগত দিয়া বিলহাৰ যোগেদি জন্ম হোৱা যাকোবৰ সন্তান। এওঁলোক সৰ্ব্বমুঠ সাতজন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","পুত্র-বোৱাৰীৰ উপৰিও যাকোবৰ লগত মিচৰ দেশলৈ যিসকল লোক আহিছিল, তেওঁৰ নিজৰ বংশধৰৰ এই লোকসকল আছিল সৰ্ব্বমুঠ ছয়ষষ্ঠী জন। ");
INSERT INTO asmfb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","মিচৰ দেশত যোচেফৰ যি দুজন পুত্ৰ জন্মিছিল আৰু যাকোবৰ পৰিয়ালৰ যিসকল লোক মিচৰলৈ গৈছিল, তেওঁলোক সৰ্ব্বমুঠ সত্তৰ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","যাকোবে নিজে যোৱাৰ আগেয়ে যিহূদাক যোচেফৰ ওচৰলৈ পঠাই দিলে, যাতে যোচেফে তেওঁক গোচনলৈ যোৱাৰ পথ দেখুৱাই দিয়ে; আৰু তাৰ পাছত তেওঁলোক গৈ গোচন পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","যোচেফে নিজৰ ৰথ সজালে আৰু তেওঁৰ পিতৃ ইস্ৰায়েলৰ সৈতে সাক্ষাত কৰিবলৈ গোচনলৈ গ’ল। পিতৃক দেখা পায়েই যোচেফে তেওঁৰ ডিঙিত সাবটি ধৰি বহু সময় কান্দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ইস্ৰায়েলে যোচেফক ক’লে, “তুমি যে এতিয়াও জীয়াই আছা, আৰু মই যে তোমাৰ শ্রীমুখ নিজ চকুৰে দেখিলোঁ; এতিয়া মই মৰিবলৈ প্রস্তুত আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","তাৰ পাছত যোচেফে ভায়েক-ককায়েক আৰু তেওঁৰ পিতৃৰ ঘৰৰ সকলোকে ক’লে, “মই ফৰৌণৰ ওচৰলৈ গৈ তেওঁক জনাওঁগৈ যে, ‘কনান দেশত থকা মোৰ ভাই-ককাইসকল আৰু মোৰ পিতৃৰ ঘৰৰ সকলো লোক মোৰ ওচৰলৈ আহিছে। ");
INSERT INTO asmfb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","এই লোকসকল মেৰ-ছাগৰ ৰখীয়া; পশুধন ৰখাই হৈছে এওঁলোকৰ জীৱিকা। এওঁলোকে মেৰ-ছাগ আৰু ছাগলী, গৰুৰ জাক আদি যি যি আছিল, সেই সকলোকে লৈ আনিছে’। ");
INSERT INTO asmfb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","তাতে ফৰৌণে যেতিয়া তোমালোকক মাতি সুধিব, ‘আপোনালোকে কি কাম কৰে?’ ");
INSERT INTO asmfb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","তেতিয়া তোমালোকে ক’বা, ‘আপোনাৰ এই দাসবোৰ আৰু আমাৰ পূর্বপুৰুষসকলে সৰু কালৰে পৰা এই পর্যন্ত পশু পালন কৰি আহিছোঁ।’ তোমালোকে গোচনত বাস কৰিবৰ বাবে এইদৰে কৰা; কাৰণ পশুপালকসকল মিচৰীয়াসকলৰ মানত ঘৃণাৰ পাত্ৰ।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","যোচেফে ফৰৌণৰ ওচৰলৈ গৈ ক’লে, “মোৰ পিতৃ আৰু ভাই-ককাইসকলে তেওঁলোকৰ মেৰ-ছাগ, ছাগলী, গৰুৰ জাক আদি যি যি আছিল সকলোকে লৈ কনান দেশৰ পৰা আহি পালে। তেওঁলোক এতিয়া গোচনত আছে।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ভাই-ককাইসকলৰ মাজৰ পাচঁজনক বাচি লৈ তেওঁ ফৰৌণৰ সৈতে পৰিচয় কৰাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ফৰৌণে তেওঁলোকক সুধিলে, “আপোনালোকৰ জীৱিকা কি?” তেওঁলোকে ক’লে, “আমাৰ পূৰ্বপুৰুষসকলৰ দৰে আপোনাৰ এই দাসবোৰ পশুপালক।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","তেওঁলোকে পুনৰ ক’লে, “আমি এই দেশত কিছুকালৰ বাবে থাকিবলৈ আহিছোঁ। কনান দেশত অতিশয় আকাল হোৱাৰ কাৰণে আপোনাৰ এই দাসবোৰৰ পশুৰ জাকে খাবলৈ চৰণীয়া ঠাই পোৱা নাই; সেয়ে দয়া কৰি আপোনাৰ এই দাসবোৰক গোচনত থাকিবলৈ অনুমতি দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ফৰৌণে যোচেফক ক’লে, “তোমাৰ পিতৃ আৰু তোমাৰ ভাই-ককাইসকল তোমাৰ ওচৰলৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","মিচৰ দেশখনেই তোমাৰ সন্মুখত আছে। দেশৰ সকলোতকৈ উত্তম ঠাইত তোমাৰ পিতৃ আৰু ভাই-ককাইসকলক থাকিবলৈ দিয়া। তেওঁলোক গোচনতে বাস কৰক। তেওঁলোকৰ মাজত কোনো যোগ্য লোকক যদি জানা, তেন্তে মোৰ পশুধনৰো দায়িত্ব তেওঁলোকৰ ওপৰত দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","তাৰ পাছত যোচেফে তেওঁৰ পিতৃ যাকোবক আনি ফৰৌণৰ সন্মুখত উপস্থিত কৰিলে। তাতে যাকোবে ফৰৌণক আশীৰ্ব্বাদ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ফৰৌণে যাকোবক সুধিলে, “আপোনাৰ বয়স কিমান হ’ল?” ");
INSERT INTO asmfb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","যাকোবে ক’লে, “মোৰ আয়ুসৰ যাত্রাকাল এশ ত্ৰিশ বছৰ; মোৰ জীৱনৰ আয়ুস অলপদিনীয়া আৰু দুখজনক। মোৰ পূর্বপুৰুষসকলে যিমান দীর্ঘ দিনলৈকে জীৱন কটাইছিল, মই সিমান আয়ুস পোৱা নাই।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","তাৰ পাছত যাকোবে ফৰৌণক আশীৰ্ব্বাদ কৰি তাৰ পৰা ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","যোচেফে তেওঁৰ পিতৃ আৰু ভাই-ককাইসকলৰ বাবে স্থায়ীভাৱে বসবাসৰ ব্যৱস্থা কৰিলে। ফৰৌণৰ আজ্ঞা অনুসাৰে, মিচৰ দেশৰ আটাইতকৈ উত্তম ঠাই ৰামিচেচৰ অঞ্চলত যোচেফে অধিকাৰ হিচাবে তেওঁলোকক বসতি কৰিবলৈ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","যোচেফে তেওঁৰ পিতৃ, ভাই-ককাই আৰু পিতৃৰ পৰিয়ালৰ সকলোকে আহাৰ যোগান ধৰিলে, আৰু তেওঁলোকৰ ল’ৰা-ছোৱালীৰ সংখ্যা অনুসাৰে যোগান ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","পাছত আকাল ইমান ভীষণ হ’ল যে, গোটেই দেশৰ কোনো ঠাইতে আহাৰ পাবলৈ নাইকিয়া হ’ল। আকালৰ কাৰণে মিচৰ আৰু কনান দেশ বিধ্বস্ত হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","মিচৰ আৰু কনান দেশৰ বাসিন্দাসকলৰ শস্য বিক্রী কৰি পোৱা যি ধন সেই দুই দেশত আছিল, যোচেফে তাক গোটাই ফৰৌণৰ ৰাজকাৰেঙলৈ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","যেতিয়া মিচৰ আৰু কনান দেশৰ সকলো ধন শেষ হ’ল, তেতিয়া মিচৰীয়সকলে যোচেফৰ ওচৰলৈ আহি ক’লে, “আমাক শস্য দিয়ক! আমি আপোনাৰ চকুৰ আগতেই মৰিম নেকি? কিয়নো আমাৰ যি ধন আছিল সকলো শেষ হ’ল?” ");
INSERT INTO asmfb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","যোচেফে ক’লে, “তেনেহ’লে তোমালোকৰ পশুধনবোৰ মোক দিয়া; তোমালোকৰ ধন যদি শেষ হ’ল, তেন্তে সেইবোৰৰ সলনিয়েই মই শস্য দিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","তেতিয়া লোকসকলে তেওঁলোকৰ সকলো পশুধন যোচেফৰ ওচৰলৈ আনিবলৈ ধৰিলে। ঘোঁৰা, মেৰ-ছাগ, ছাগলী, গৰুৰ জাক আৰু গাধবোৰৰ সলনি তেওঁ তেওঁলোকক শস্য দিলে; এইদৰে পশুবোৰ লৈ যোচেফে সেই বছৰ তেওঁলোকলৈ আহাৰ যোগালে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","সেই বছৰ অন্ত হোৱাত, তাৰ পাছৰ বছৰত লোকসকলে যোচেফৰ ওচৰলৈ আহি ক’লে, “প্রভুৰ ওচৰত আমি লুকাই নাৰাখোঁ যে, আমাৰ সকলো ধন শেষ হ’ল আৰু আমাৰ পশুবোৰো প্ৰভুৰেই হ’ল; এতিয়া শৰীৰ আৰু মাটিৰ বাহিৰে প্ৰভুক দিবলৈ আমাৰ একো নাই। ");
INSERT INTO asmfb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","মাটিৰে সৈতে আমি সকলোবোৰ আপোনাৰ চকুৰ সন্মুখতে বিনষ্ট হ’ম কিয়? সেয়ে আপুনি আমাক আৰু আমাৰ মাটিকো কিনি লওক আৰু তাৰ সলনি আমাক আহাৰ দিয়ক। মাটিয়ে সৈতে আমি সকলো ফৰৌণৰ দাস হৈ থাকিম। তাৰ পাছত আমি যেন নমৰি জীয়াই থাকিব পাৰোঁ, সেই কাৰণে আমাক কিছুমান বীজো দিয়ক; তাতে আমাৰ মাটি ছন পৰি নাথাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","তেতিয়া যোচেফে মিচৰ দেশৰ সকলো মাটি ফৰৌণৰ বাবে কিনি ল’লে; আকাল ইমান বেছি হ’ল যে, মিচৰীয়সকলে তেওঁলোকৰ নিজ নিজ মাটি বেচি দিব লগীয়া হ’ল। এইদৰে মিচৰ দেশৰ সকলো মাটি ফৰৌণৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ফৰৌণৰ দাস হ’বৰ কাৰণে যোচেফে লোকসকলক মিচৰ দেশৰ এক সীমাৰ পৰা অন্য সীমা পর্যন্ত তুলি আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","কেৱল পুৰোহিতসকলৰ মাটিহে যোচেফে নিকিনিলে; কিয়নো পুৰোহিতসকলে ফৰৌণৰ পৰা এক অংশ পায় আৰু তাৰেই তেওঁলোক চলে। সেয়ে তেওঁলোকে নিজৰ মাটি নেবেচিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","তেতিয়া যোচেফে লোকসকলক ক’লে, “চোৱা, ফৰৌণৰ পক্ষে মই আজি তোমালোকক আৰু তোমালোকৰ মাটি কিনি ললোঁ। এতিয়া এয়া বীজ তোমালোকে লোৱা আৰু গৈ নিজৰ মাটিত খেতি কৰা। ");
INSERT INTO asmfb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","শস্য চপোৱাৰ পাছত শস্যৰ পাঁচ ভাগৰ এভাগ ফৰৌণক অৱশ্যেই দিবা; বাকি চাৰিভাগ হ’লে, মাটিৰ বীজৰ কাৰণে আৰু তোমালোকৰ নিজৰ ও পৰিয়ালৰ সকলো ল’ৰা-ছোৱালীবোৰৰ আহাৰৰ কাৰণে ৰাখিবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","তেওঁলোকে ক’লে, “আপুনি আমাৰ প্ৰাণ ৰক্ষা কৰিলে। আপোনাৰ দৃষ্টিত দয়া পালে আমি ফৰৌণৰ দাস হৈ থাকিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","পাছত যোচেফে মিচৰৰ ভূমি সম্বন্ধে এই ব্যৱস্থা স্থাপন কৰিলে যে, সকলো শস্যৰ পাঁচ ভাগৰ এভাগ ফৰৌণৰ হ’ব। এইটো ব্যৱস্থা মিচৰ দেশত আজিলৈকে চলি আছে; কেৱল পুৰোহিতসকলৰ মাটিহে ফৰৌণৰ নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ইস্ৰায়েলে মিচৰ দেশৰ গোচনত বাস কৰিবলৈ ধৰিলে। সেই ঠাই অধিকাৰ কৰি তেওঁলোক বহুবংশ হ’ল আৰু অতিশয়ৰূপে বৃদ্ধি পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","মিচৰ দেশত যাকোবে সোঁতৰ বছৰ জীয়াই থাকিল। সেয়ে, তেওঁ সৰ্ব্বমুঠ এশ সাতচল্লিশ বছৰ জীয়াই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ইস্ৰায়েলৰ মৃত্যুৰ সময় ওচৰ হোৱাত, তেওঁ নিজ পুত্ৰ যোচেফক মাতি আনি ক’লে, “তোমাৰ অনুগ্ৰহ যদি মোলৈ হয়, মোৰ কৰঙনৰ তলত তোমাৰ হাত ৰাখি মোক কথা দিয়া যে, তুমি মোৰ প্রতি বিশ্বাসী আৰু বিশ্বস্ত হৈ থাকিবা। অনুগ্রহ কৰি মোক মিচৰত মৈদাম নিদিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","কাৰণ মই মোৰ পূর্বপুৰুষসকলৰ মৈদামৰ মাজত সমাধিস্থ হ’ব বিচাৰো। তুমি মোৰ মৃতদেহ মিচৰ দেশৰ পৰা বাহিৰ কৰি লৈ গৈ আমাৰ পূর্বপুৰুষসকলক যি ঠাইত মৈদাম দিয়া হৈছিল, সেই ঠাইতে মোকো মৈদাম দিবা।” যোচেফে তেওঁক ক’লে, “আপুনি কোৱাৰ দৰেই মই কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ইস্রায়েলে পুনৰায় ক’লে, “মোৰ ওচৰত শপত খোৱা।” তেতিয়া যোচেফে যাকোবৰ ওচৰত শপত খালে। তাৰ পাছত ইস্ৰায়েল শয্যাৰ মূৰৰ শিতানত মূৰ দোঁৱাই পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","এইবোৰ ঘটনা ঘটি যোৱাৰ পাছত কোনো এজনে আহি যোচেফক ক’লে, “চোৱা, তোমাৰ পিতৃ নৰিয়াত পৰিছে।” সেয়ে তেওঁ তেওঁৰ দুজন পুত্ৰ, মনচি আৰু ইফ্ৰয়িমক লগত লৈ পিতৃৰ ওচৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","যেতিয়া যোচেফ গৈ পালে, তেতিয়া কোনো এজনে আহি যাকোবক ক’লে, “চাওক, আপোনাৰ পুত্ৰ যোচেফে আপোনাক চাবলৈ ওচৰলৈ আহিছে।” তেতিয়া ইস্ৰায়েলে বল পালে আৰু শয্যাত উঠি বহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","তেতিয়া যাকোবে যোচেফক ক’লে, “সৰ্ব্বশক্তিমান ঈশ্বৰে কনান দেশৰ লুজত মোক দৰ্শন দিলে, ");
INSERT INTO asmfb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","আৰু তেওঁ মোক আশীৰ্ব্বাদ কৰি ক’লে, ‘চোৱা মই তোমাক বহুবংশ কৰিম আৰু অতিশয়ৰূপে বৃদ্ধি কৰিম। মই তোমাৰ পৰাই জাতি সমূহ উৎপন্ন কৰিম আৰু চিৰকাল অধিকাৰ কৰিবৰ অৰ্থে মই তোমাৰ ভাবী-বংশক এই দেশ দিম। ");
INSERT INTO asmfb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","মই মিচৰত তোমাৰ ওচৰলৈ অহাৰ আগতে তোমাৰ যি দুজন পুত্ৰ মিচৰ দেশত জন্মিছে, তেওঁলোকো মোৰেই। ৰূবেণ আৰু চিমিয়োনৰ দৰে ইফ্ৰয়িম আৰু মনচি মোৰেই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","তেওঁলোকৰ পাছত তোমাৰ যি সন্তান জন্ম হ’ব, সেই সন্তান সকল হ’লে তোমাৰ হ’ব। সেই দুজন ভায়েক-ককায়েকৰ নাম অনুসাৰেই তেওঁলোকৰ অধিকাৰত তেওঁলোক প্ৰখ্যাত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","কিন্তু মোৰ হ’লে, যেতিয়া মই পদ্দনৰ পৰা আহি আছিলোঁ, তেতিয়া ইফ্ৰাথ পাবলৈ কিছু সময় থাকোতেই কনান দেশৰ বাটত ৰাহেল মৰিল। মই বাটত আহি থাকোতেই ইফ্ৰাথ তেওঁক মৈদাম দিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","পাছত ইস্ৰায়েলে যেতিয়া যোচেফৰ পুত্ৰ দুজনক দেখিলে, তেতিয়া তেওঁ সুধিলে, “এওঁলোক কোন?” ");
INSERT INTO asmfb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","তাতে যোচেফে তেওঁৰ পিতৃক ক’লে, “ঈশ্বৰে এই ঠাইত মোক দিয়া, এওঁলোক মোৰ পুত্ৰ।” তেতিয়া ইস্ৰায়েলে তেওঁক ক’লে, “তেওঁলোকক মোৰ ওচৰলৈ লৈ আহা, মই তেওঁলোকক আশীৰ্ব্বাদ দিওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","বৃদ্ধ হৈ অহাৰ কাৰণে ইস্ৰায়েলৰ চকু দুৰ্ব্বল হৈ পৰিছিল, সেয়ে তেওঁ ভালদৰে দেখা পোৱা নাছিল। পাছত যোচেফে তেওঁলোকক তেওঁৰ ওচৰলৈ লৈ আহিল, তেতিয়া তেওঁ তেওঁলোকক চুমা খালে, আৰু সাবট মাৰি ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ইস্ৰায়েলে যোচেফক ক’লে, “মই ভাবিছিলোঁ তোমাৰ মুখকেই দেখিবলৈ নাপাম; কিন্তু চোৱা, ঈশ্বৰে মোক তোমাৰ সন্তানকো দেখুৱালে।” ");
INSERT INTO asmfb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","তেতিয়া যোচেফে ইস্ৰায়েলৰ আঠু দুটাৰ মাজৰ পৰা তেওঁলোকক উলিয়াই আনিলে, আৰু মাটিত মুখ লগাই প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","যোচেফে তেওঁলোক দুয়োকো ইস্ৰায়েলৰ ওচৰলৈ আনিলে। ইফ্ৰয়িমক তেওঁৰ সোঁ হাতেৰে ধৰি ইস্ৰায়েলৰ বাওঁহাতলৈ, আৰু মনচিক তেওঁৰ বাওঁ হাতেৰে ধৰি ইস্ৰায়েলৰ সোঁহাতলৈ লৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","কিন্তু ইস্ৰায়েলে তেওঁৰ সোঁ হাত মেলি ইফ্ৰয়িম সৰুটোৰ মুৰত, আৰু বাওঁ হাত মনচিৰ মুৰত দিলে; তেওঁ বুজিবাজি হাত দিলে; কিয়নো মনচি জেষ্ঠ পুত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","পাছত তেওঁ যোচেফক আশীৰ্ব্বাদ কৰি ক’লে, “যি ঈশ্বৰৰ সাক্ষাতে মোৰ ওপৰপিতৃ অব্ৰাহাম আৰু ইচহাক চলিছিল, যি ঈশ্বৰে পূৰ্বৰে পৰা আজিলৈকে মোক প্ৰতিপালন কৰি আহিছে, ");
INSERT INTO asmfb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","যি দূতে সকলো আপদৰ পৰা মোক মুক্ত কৰিলে, তেৱেঁই এই ল’ৰাহঁতক আশীৰ্ব্বাদ কৰক। মোৰ নাম আৰু মোৰ ওপৰ-পিতৃ অব্ৰাহাম আৰু ইচহাকৰ নাম এওঁলোকৰ দ্বাৰাই প্ৰখ্যাত হওক। এওঁলোক বাঢ়ি বাঢ়ি পৃথিবীৰ মাজত বহুবংশ হওক।” ");
INSERT INTO asmfb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","পাছত যোচেফে তেওঁৰ বাপেকৰ সোঁ হাত ইফ্ৰয়িমৰ মূৰত দেখি অসন্তোষ পালে; তাতে তেওঁ ইফ্ৰয়িমৰ মূৰৰ পৰা মনচি মূৰত দিবলৈ, বাপেকৰ হাত দাঙি বাপেকক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“এনে নহয় পিতৃ; কিয়নো এওঁহে জ্যেষ্ঠ; এওঁৰেই মূৰত আপোনাৰ সোঁ হাত দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","কিন্তু এই কথাত তেওঁৰ পিতৃ অমান্তি হ’ল আৰু ক’লে, “মোৰ পুত্ৰ মই জানো; মই জানিছোঁ। তেৱোঁ এক জাতি হ’ব আৰু এৱোঁ মহান হ’ব, তথাপিও ইয়াৰ সৰু ভায়েক হ’লে, ইয়াতকৈয়ো মহান হ’ব, আৰু তেওঁৰ বংশই জাতি সমূহৰ মাজত বৃদ্ধি হৈ যাব।” ");
INSERT INTO asmfb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","তেওঁলোকক সেইদিনাই তেওঁ আশীৰ্ব্বাদ কৰিলে আৰু ক’লে, “ইস্ৰায়েলৰ লোকসকলে আশীৰ্ব্বাদ কৰাৰ সময়ত তোমালোকৰ নাম ধৰি ক’ব, ‘ঈশ্বৰে তোমাক ইফ্ৰয়িম আৰু মনচিৰ নিচিনা কৰক’।” এইদৰে তেওঁ মনচিতকৈ ইফ্ৰয়িমক অগ্ৰগণ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","পাছত ইস্ৰায়েলে যোচেফক ক’লে, “চোৱা, মই এতিয়া প্ৰায় মৰিবলৈ ওলোৱাৰ নিচিনা; কিন্তু ঈশ্বৰ তোমালোকৰ সঙ্গী হ’ব, আৰু তোমালোকক পুনৰায় তোমালোকৰ ওপৰ-পিতৃসকলৰ দেশলৈ লৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","তোমাক মই তোমাৰ ভাই-ককাইসকলতকৈ অধিক দিলোঁ, মোৰ নিজ তৰোৱাল আৰু ধনুৰে ইমোৰীয়াসকলৰ পৰা যি পাহাৰ লৈছিলোঁ, সেয়া মই তোমাক বেচিকৈ দিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","পাছত যাকোবে তেওঁৰ পুত্ৰসকলক মাতি আনিলে আৰু ক’লে, “তোমালোক গোট খোৱা; আগলৈ তোমালোকৰ যি যি ঘটিব, সেই বিষয়ে মই তোমালোকক জনাওঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","হে যাকোবৰ পুত্ৰসকল, গোট খোৱা আৰু শুনা; তোমালোকৰ পিতৃ ইস্ৰায়েলৰ বাক্য শ্ৰৱণ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","হে ৰূবেণ, তুমি মোৰ জ্যেষ্ঠ পুত্ৰ, মোৰ বল, আৰু মোৰ শক্তিৰ প্ৰথম ফল; তুমি মৰ্যদাত লক্ষণীয় আৰু পৰাক্ৰমত লক্ষণীয়। ");
INSERT INTO asmfb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","তুমি উতলা পানীৰ নিচিনা হোৱা বাবে তোমাৰ প্ৰাধান্যতা নাথাকিব; কিয়নো তুমি নিজ পিতৃৰ শোৱা বিচনালৈ উঠি গৈছিলা। তেতিয়া তুমি অপবিত্ৰ কৰ্ম কৰিছিলা। সি মোৰ শয্যালৈ উঠি গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","চিমিয়োন আৰু লেবী দুয়ো ভাই, সিহঁতৰ তৰোৱাল হিংস্ৰতাৰ অস্ত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","মই নিজে সিহঁতৰ সভালৈ নাহিম; মোৰ হৃদয়ৰ বহু সন্মানৰ বাবে, মই সিহঁতৰ সমাজত যোগ নহম। কিয়নো সিহঁতে ক্ৰোধত নৰ-হত্যা কৰে, আৰু আনন্দ কৰি ষাঁড় গৰুবোৰ বধ কৰে। ");
INSERT INTO asmfb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","সিহঁতৰ খং অভিশপ্ত হওক, সেয়ে প্ৰচণ্ড, প্ৰকোপ আৰু নিষ্ঠুৰ মই যাকোবৰ মাজত সিহঁতক ভাগ কৰিম; আৰু ইস্ৰায়েলৰ মাজত সিহঁতক ছিন্ন-ভিন্ন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","হে যিহূদা, তোমাক হ’লে, নিজৰ ভাইসকলে প্ৰশংসা কৰিব; তোমাৰ হাতে শত্ৰুবোৰৰ ডিঙিত ধৰিব; তোমাৰ পিতৃৰ সন্তান সকলে তোমাৰ আগত প্ৰণিপাত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","যিহূদা যুবা সিংহ; হে মোৰ বোপা, তুমি পশু ছিৰি পেলোৱাৰ পৰা উঠি আহিলা। সি সিংহৰ দৰে পৰি শুইছে, এনে কি, শক্তিশালী সিংহৰ দৰে শুইছে; কোনে তাক জগাব? ");
INSERT INTO asmfb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","চীলো নহালৈকে যিহূদাৰ পৰা ৰাজদণ্ড নাযাব, আৰু তাৰ ভৰি দুখনৰ মাজৰ পৰা বিচাৰদণ্ড নুগুচিব; লোক সমূহ সেই জনাৰ আজ্ঞাধীন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","সি দ্ৰাক্ষালতাত নিজৰ ডেকা গাধ, আৰু উত্তম দ্ৰাক্ষালতাত নিজৰ গাধ পোৱালি বান্ধি, নিজ বস্ত্ৰ দ্ৰাক্ষাৰসত, নিজ কাপোৰ দ্ৰাক্ষাদুটিৰ তেজৰূপ ৰসত ধুইছে। ");
INSERT INTO asmfb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","তাৰ চকু দ্ৰাক্ষাৰসেৰে ৰঙা, তাৰ দাঁত গাখীৰেৰে বগা। ");
INSERT INTO asmfb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","জবূলূনে সমুদ্ৰৰ তীৰত বসতি কৰিব; সি জাহাজবোৰৰ আশ্ৰয়ৰ তীৰ হ’ব; আৰু চীদোনলৈকে তাৰ সীমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ইচাখৰ বলৱান গাধ; সি দুটা গঁৰালৰ মাজত শোৱে। ");
INSERT INTO asmfb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","সি জিৰণিক ভাল দেখি, আৰু দেশক সুন্দৰ দেখি, ভাৰ ব’বলৈ নিজৰ কান্ধ পাতি দিলে আৰু কৰি দিবলগীয়া কামৰ ভাৰ লৈ দাস হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","দান ইস্ৰায়েলৰ এক ফৈদ হ’ল; তেওঁ নিজ লোকসকলৰ সোধ-বিচাৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","দান পথৰ দাঁতিত থকা সাপ, সি পথৰ দাঁতিত থকা বিষাক্ত সাপ, যিয়ে ঘোঁৰাৰ ঠেঙত দংশিব পাৰে, য’ত অশ্বাৰোহী জন পাছফালে পৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","হে যিহোৱা, মই তোমাৰ পৰিত্ৰাণলৈ অপেক্ষা কৰি আছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","গাদ - অশ্বাৰোহীয়ে তেওঁক হ’লে আক্ৰমণ কৰিব; কিন্তু সি সিহঁতৰ পাছফালে আক্ৰমণ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","আচেৰৰ মাজৰ পৰা নিজৰ উত্তম আহাৰ জন্মিব; সি ৰজাই খাব পৰা সুখাদ্য আহাৰ যোগাব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","নপ্তালী মুকলি হোৱা হৰিণ; সি মনোহৰ কথা কয়। ");
INSERT INTO asmfb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","যোচেফ ফলৱান গছৰ ডাল; ভুমুকৰ ওচৰত থকা লাগনী গছৰ ডাল; তাৰ ডালবোৰ গড়ৰ ওপৰলৈকে জুৰি যায়। ");
INSERT INTO asmfb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ধনুৰ্দ্ধৰসকলে তাক বৰকৈ ক্লেশ দিলে, আৰু তালৈ কঢ়িয়াই আনি তাক তাড়না কৰিলে; ");
INSERT INTO asmfb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","কিন্তু তেওঁৰ অৱশিষ্ট ধনু অতল হৈ থাকিল, আৰু তেওঁৰ হাত দক্ষতাপূৰ্ণ কিয়নো যাকোবৰ একমাত্র পৰাক্ৰমী জনাৰ হাতৰ দ্বাৰাই, কিয়নো তেওঁৰ নাম মেৰ-ছাগৰ ৰখীয়া, ইস্ৰায়েলৰ শিলা। ");
INSERT INTO asmfb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","কিয়নো তোমাৰ পিতৃ ঈশ্বৰ, তেৱেঁ তোমাক সহায় কৰিব, কিয়নো সৰ্ব্বশক্তিমান ঈশ্বৰ জনাই আশীৰ্ব্বাদ কৰিব, তেওঁ ওপৰত থকা আকাশৰ আশীৰ্ব্বাদৰ সৈতে তলত থকা অগাধ জল, স্তন আৰু গৰ্ভৰ আশীৰ্ব্বাদেৰে, তোমাক আশীৰ্ব্বাদ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","মোৰ পূর্বপুৰুষসকলৰ আশীৰ্ব্বাদতকৈ তোমাৰ নিজ পিতৃৰ আশীৰ্ব্বাদ ফলদায়ক হ’ল, আৰু চিৰকালীয়া পৰ্ব্বতৰ সীমালৈকে বিয়পি গ’ল। সেয়ে যোচেফৰ মূৰত থকিব; ভায়েক- ককায়েকসকলৰ পৰা পৃথকে থকা জনৰ মূৰৰ তালুত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","বিন্যামীন পশু ছিৰি পেলাব পৰা ৰাংকুকুৰ। ৰাতিপুৱা সি মৃগ ভক্ষণ কৰিব; সন্ধিয়া পৰত লুটদ্ৰব্য ভগাই দিব।” ");
INSERT INTO asmfb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","এই সকলেই হ’ল ইস্ৰায়েলৰ বাৰ ফৈদ; আৰু তেওঁলোকৰ পিতৃয়ে আশীৰ্ব্বাদ কৰি তেওঁলোকক কোৱা কথাও এয়ে। তেওঁলোকৰ প্ৰতিজনকে এইদৰে তেওঁ বিশেষ বিশেষ আশীৰ্ব্বাদেৰে আশীৰ্ব্বাদ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","পাছত তেওঁ তেওঁলোকক আজ্ঞা কৰি ক’লে, “মই মোৰ নিজ লোকসকলৰ ওচৰলৈ যাম। হিত্তীয়া ইফ্রোণৰ পথাৰত যি গুহা আছে, তাতে মোৰ ওপৰ-পিতৃসকলৰ সৈতে মোক মৈদাম দিবা। ");
INSERT INTO asmfb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","সেই গুহা কনান দেশত মম্ৰিৰ ওচৰৰ মকপেলাৰ পথাৰত আছে, অব্ৰাহামে মৈদাম দিবৰ বাবে সেই গুহা হিত্তীয়া ইফ্রোণৰ পৰা পথাৰে সৈতে কিনি লৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","সেই ঠাইতে অব্ৰাহাম আৰু তেওঁৰ ভাৰ্যা চাৰাক মৈদাম দিয়া হ’ল; সেই ঠাইতে ইচহাক আৰু তেওঁৰ ভাৰ্যা ৰিবেকাকো মৈদাম দিয়া হ’ল, আৰু সেই ঠাইতে মইও লেয়াক মৈদাম দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","সেই পথাৰ আৰু গুহা হেতৰ সন্তান সকলৰ পৰা কিনা হৈছিল।” ");
INSERT INTO asmfb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","এইদৰে যাকোবে তেওঁৰ পুত্ৰসকলক আজ্ঞা দিয়াৰ পাছত, ভৰি দুখন শয্যাৰ ওপৰত কোঁচ খুৱাই ল’লে আৰু শেষ নিশ্বাস ত্যাগ কৰিলে। পাছত তেওঁৰ লোকসকলৰ ওচৰলৈ তেওঁক নিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","তেতিয়া যোচেফে তেওঁৰ বাপেকৰ মুখৰ ওপৰত মুখ দি পৰিল, আৰু কান্দি কান্দি তেওঁক চুমা খালে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","পাছত যোচেফে তেওঁৰ বাপেকৰ মৃতদেহ সুগন্ধিদ্ৰব্যযুক্ত কৰি ৰাখিবলৈ, তেওঁৰ দাস চিকিৎসকসলক আজ্ঞা দিলে; তাতে চিকিৎসকসকলে ইস্ৰায়েলৰ দেহ সুগন্ধিদ্ৰব্যযুক্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","তেওঁলোকে এই কাৰ্যত চল্লিশ দিন সময় ল’লে; কিয়নো সেই কাৰ্য কৰিবলৈ ইমান দিনেই প্ৰয়োজন হয়। পাছত মিচৰীয়াসকলে তেওঁৰ কাৰণে সত্তৰ দিন শোক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","সেই শোকৰ দিন অতীত হোৱাৰ পাছত, যোচেফে ফৰৌণৰ অধিকাৰীসকলক ক’লে, “মই যদি আপোনালোকৰ আগত অনুগ্ৰহ প্ৰাপ্ত হৈছোঁ, তেনেহলে বিনয় কৰোঁ, ফৰৌণৰ ওচৰত এই কথা কওক যে, ");
INSERT INTO asmfb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘মোৰ পিতৃয়ে মোক শপত কৰাই কৈছিল, চোৱা, মই এতিয়া মৰোঁহে; কনান দেশত মই মোৰ নিজৰ অৰ্থে খান্দি থোৱা মৈদামতেই তুমি মোক মৈদাম দিবা’। এতেকে, মই বিনয় কৰোঁ, এতিয়া মোৰ পিতৃক মৈদাম দিবলৈ মোক যাব দিয়ক; পাছত মই পুনৰ ঘূৰি আহিম’।” ");
INSERT INTO asmfb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","তেতিয়া ফৰৌণে ক’লে, “যোৱা; তোমাৰ পিতৃয়ে তোমাক শপত কৰোঁৱাৰ দৰেই তুমি তেওঁক মৈদাম দিয়াগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","তেতিয়া যোচেফে তেওঁৰ বাপেকক মৈদাম দিবলৈ যাত্ৰা কৰিলে; তাতে ফৰৌণৰ পাত্ৰমন্ত্ৰীসকল, তেওঁৰ ঘৰৰ বৃদ্ধসকল, মিচৰ দেশৰ সকলো বৃদ্ধ লোক, ");
INSERT INTO asmfb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","যোচেফ আৰু তেওঁৰ আটাই পৰিয়াল, তেওঁৰ ভায়েক-ককায়েকসকল, আৰু বাপেকৰ পৰিয়ালো তেওঁৰ লগত গ’ল; তেওঁলোকে কেৱল নিজৰ ল’ৰা-তিৰোতা আৰু মেৰ, ছাগ, আৰু গৰু আদিৰ জাকবোৰহে গোচনত এৰি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","তেওঁৰ লগত ৰথ, আৰু অশ্বাৰোহীসকল গ’ল। এইদৰে সকলো মিলি এটা অতি বৃহৎ দল হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","পাছত তেওঁলোকে গৈ যৰ্দ্দনৰ সিপাৰে থকা আটদৰ মৰণা মৰা ঠাই পালে, সেই ঠাইতে তেওঁলোকে অতি দাৰুণ মহা-বিলাপেৰে বিলাপ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","তাতে সেই দেশ নিবাসী কনানীয়াসকলে আটদৰ মৰণা মৰা ঠাইত এইদৰে শোক কৰা দেখি ক’লে, “মিচৰীয়াসকলৰ এয়ে অতি দাৰুণ শোক।” এই হেতুকে যৰ্দ্দনৰ সিপাৰে থকা সেই ঠাই আবেল-নিশ্ৰিয়াম নামেৰে প্ৰখ্যাত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","পাছত যাকোবে নিজৰ পুত্ৰসকলক আজ্ঞা দিয়াৰ দৰেই তেওঁলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","তেওঁৰ পুত্ৰসকলে তেওঁক কনান দেশলৈ লৈ গ’ল আৰু মম্ৰিৰ সন্মুখত থকা মকপেলাৰ পথাৰৰ যি গুহা আছিল, তাতে মৈদাম দিলে। অব্ৰাহামে পথাৰে সৈতে সেই গুহা মৈদাম দিবৰ বাবে কিনিছিল। তেওঁ হিত্তীয়া ইফ্রোণৰ পৰা সেই ঠাই কিনি লৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","বাপেকক মৈদাম দিয়াৰ পাছত যোচেফ আৰু তেওঁৰ ভায়েক-ককায়েকসকলৰ লগতে বাপেকক মৈদাম দিবলৈ তেওঁলোকৰ লগত অহা সকলো লোক মিচৰদেশলৈ উভতি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","পাছত যোচেফৰ ককায়েকসকলে দেখিলে যে তেওঁলোকৰ পিতৃৰ মৃত্যু হ’ল, সেয়ে তেওঁলোকে ক’লে, “যদি যোচেফে ঘৃণা কৰে, আৰু আমি তেওঁলৈ যি যি অন্যায় কৰিছিলোঁ, তাৰ যদি প্ৰতিফল আমাক দিয়ে?” ");
INSERT INTO asmfb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","সেয়ে তেওঁলোকে যোচেফলৈ বার্তা পঠালে, আৰু ক’লে, “তোমাৰ পিতৃয়ে তেওঁৰ মৃত্যুৰ আগেয়ে এই আদেশ দিছিল, যে, ");
INSERT INTO asmfb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","তোমালোকে যোচেফক এইদৰে ক’বা, ‘বিনয় কৰোঁ, তুমি তোমাৰ ককায়েৰাহঁতৰ জগৰ, তেওঁলোকৰ পাপ ক্ষমা কৰা; কিয়নো তেওঁলোকে তোমাক দুৰ্গতি কৰিছিল’। এতেকে, এতিয়া আমি বিনয় কৰোঁ, আপুনি নিজ পিতৃৰ ঈশ্বৰৰ দাসসকলৰ দোষ ক্ষমা কৰক।” এইদৰে তেওঁলোকে যোচেফলৈ কৈ পঠোৱাত, তেওঁ কান্দি পেলালে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","তাৰ পাছত তেওঁৰ ককায়েকসকলে গৈ তেওঁৰ সন্মুখত পৰি ক’লে, “চাওক, আমি আপোনাৰে বন্দী।” ");
INSERT INTO asmfb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","তেতিয়া যোচেফে তেওঁলোকক ক’লে, “ভয় নকৰিবা; কিয়নো, মই জানো ঈশ্বৰৰ প্ৰতিনিধি? ");
INSERT INTO asmfb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","তোমালোকে মোৰ বিৰুদ্ধে অনিষ্টৰ কল্পনা কৰিছিলা হয়, কিন্তু এতিয়া যেনেকৈ দেখিছা তেনেকৈ অনেক লোকৰ প্ৰাণ ৰক্ষা কৰা কাৰ্য সিদ্ধ কৰাৰ অভিপ্ৰায়েৰে, ঈশ্বৰে ইয়াকে মঙ্গলৰ কল্পনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","এতিয়া তোমালোকে ভয় নকৰিবা; মই তোমালোকক আৰু তোমালোকৰ ল’ৰা-তিৰোতাসকলকো প্ৰতিপালন কৰিম।” এইদৰে তেওঁলোকক তেওঁ শান্ত্বনা দিলে, আৰু মৰমৰ কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","পাছত যোচেফে তেওঁৰ পিতৃ-বংশৰ সৈতে মিচৰ দেশতে নিবাস কৰি থাকিল। আৰু যোচেফ এশ দহ বছৰ জীয়াই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","এইদৰে যোচেফে ইফ্ৰয়িমৰ পৰিনাতি দেখিবলৈ পালে। তেওঁ মনচিৰ পুতেক মাখীৰৰ সন্তান সকলকো দেখা পালে। তেওঁ তেওঁলোকক কোলাত লবলৈ পালে। ");
INSERT INTO asmfb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","পাছত যোচেফে তেওঁৰ ভায়েক-ককায়েকসকলক ক’লে, “মই এতিয়া মৃত্যুৰ সময়ত উপস্থিত হৈছোঁ; কিন্তু ঈশ্বৰে তোমালোকলৈ অৱশ্যে দৃষ্টি কৰিব আৰু অব্ৰাহাম, ইচহাক, আৰু যাকোবৰ আগত যি দেশ দিম বুলি শপত কৰিছিল, সেই দেশলৈ তোমালোকক এই দেশৰ পৰা লৈ যাব।” ");
INSERT INTO asmfb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","তাৰ পাছত যোচেফে ইস্ৰায়েলৰ সন্তান সকলক শপত কৰালে। তেওঁ ক’লে, “ঈশ্বৰে অৱশ্যে তোমালোকলৈ দৃষ্টি কৰিব। সেই সময়ত নিশ্চয়কৈ তোমালোকে ইয়াৰ পৰা মোৰ অস্থি লৈ যাবা।” ");
INSERT INTO asmfb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","এইদৰে যোচেফ এশ দহ বছৰ বয়সত মৰিল; পাছত তেওঁক সুগন্ধিদ্ৰব্য যুক্ত কৰি, মিচৰত এটা পেড়াত ভৰাই ৰখা হ’ল।");
INSERT INTO asmfb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","যাকোবৰ লগত ইস্ৰায়েলৰ যিসকল পুত্ৰই নিজৰ পৰিয়ালৰ সৈতে মিচৰ দেশলৈ আহিছিল, তেওঁলোকৰ নাম: ");
INSERT INTO asmfb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ৰূবেণ, চিমিয়োন, লেবী আৰু যিহূদা; ");
INSERT INTO asmfb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ইচাখৰ, জবূলূন, আৰু বিন্যামীন; ");
INSERT INTO asmfb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","দান আৰু নপ্তালী; গাদ আৰু আচেৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","যাকোবৰ বংশধৰ সৰ্ব্বমুঠ সত্তৰ জন আছিল। ইতিমধ্যে যোচেফ মিচৰত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","তাৰ পাছত যোচেফ, তেওঁৰ ভায়েক-ককায়েক সকল আৰু সেই প্রজন্মৰ সকলোৰেই মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ইস্ৰায়েলৰ সন্তান সকল বহু বংশ হৈ সংখ্যাত বৃদ্ধি পালে; আৰু বাঢ়ি বাঢ়ি অতিশয় বলৱন্ত হ’ল। তেওঁলোকৰ দ্বাৰাই দেশ পৰিপূৰ্ণ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","তাৰ পাছত মিচৰত যোচেফক সোঁৱৰণ কৰা কথাত গুৰুত্ব নিদিয়া এজন নতুন ৰজাৰ উত্থান হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","তেওঁৰ প্ৰজা সকলক তেওঁ ক’লে, “সেই ইস্ৰায়েল জাতিক চোৱা; তেওঁলোক সংখ্যাত অধিক আৰু আমাতকৈ বলৱন্ত। ");
INSERT INTO asmfb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","আহাঁ, আমি তেওঁলোকৰ লগত জ্ঞানেৰে লেনদেন কৰোঁহক। নহলে তেওঁলোক অবিৰত ভাৱে বৃদ্ধি পাব, আৰু কোনো যুদ্ধ হ’লে, তেওঁলোকে আমাৰ শত্ৰুবোৰৰ লগত যোগ হৈ আমাৰ বিৰুদ্ধে যুদ্ধ কৰিব, আৰু দেশ ত্যাগ কৰি যাব।” ");
INSERT INTO asmfb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","সেয়ে তেওঁলোকক কঠিন পৰিশ্রমৰ দ্বাৰাই অত্যাচাৰ কৰিবলৈ তেওঁলোকৰ ওপৰত কঠোৰ তত্ত্বাবধায়ক নিযুক্ত কৰিলে। ইস্রায়েলী লোক সকলে পিথোম আৰু ৰামিচেচ নামেৰে ফৰৌণৰ অৰ্থে ভঁৰাল ঘৰৰ নগৰ নিৰ্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","কিন্তু মিচৰীয়া সকলে যিমান বেছিকৈ ইস্রায়েলী সকলক অত্যাচাৰ কৰিলে, সিমান বেছিকৈ তেওঁলোক সংখ্যাত বৃদ্ধি পালে আৰু বিস্তাৰ লাভ কৰিবলৈ ধৰিলে। সেয়ে মিচৰীয়া সকলে ইস্ৰায়েলী লোক সকলক ভয় কৰিবলৈ আৰম্ভ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","মিচৰীয়া সকলে ইস্ৰায়েলী লোক সকলক অব্যাহতি নিদিয়াকৈ কাম কৰাইছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","চূণ, বালি আৰু পানী মিহলাই তৈয়াৰ কৰোঁৱা বোকাৰে ইটা প্রস্তুত কৰা, আৰু পথাৰৰ সকলো বিধৰ কামৰ দ্বাৰাই তেওঁলোকৰ জীৱন তিক্ত কৰিছিল। তেওঁলোকে কৰিব লগা সকলো কামেই কঠিন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","তাৰ পাছত মিচৰৰ ৰজাই চিফ্ৰা আৰু পুৱা নামৰ দুজনী ইব্ৰীয়া ধাত্ৰীৰ লগত কথা পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ৰজাই ক’লে, “যি সময়ত তোমালোকে ইব্ৰীয়া মহিলা সকলক প্রসৱ আসনত সন্তান প্ৰসৱ কৰাত সহায় কৰিবা, সেই সময়ত তেওঁলোকে জন্ম দিয়া সন্তান লক্ষ্য কৰিবা; যদি সেই সন্তান ল’ৰা হয় তেনেহ’লে তাক অৱশ্যে বধ কৰিবা, আৰু যদি ছোৱালী হয়, তেনেহ’লে তাইক জীয়াই থাকিবলৈ দিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","কিন্তু ধাত্ৰী দুজনীয়ে ঈশ্বৰলৈ ভয় কৰিছিল, সেয়ে মিচৰৰ ৰজাই তেওঁলোকক দিয়া আজ্ঞা পালন নকৰি, তাৰ পৰিৱৰ্তে ল’ৰা শিশু বিলাকক জীয়াই ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","মিচৰৰ ৰজাই ধাত্ৰী দুজনীক মাতি অনালে আৰু তেওঁলোকক ক’লে, “তোমালোকে কিয় ল’ৰা শিশু বিলাকক জীয়াই ৰাখিলা?” ");
INSERT INTO asmfb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","তেতিয়া ধাত্ৰী দুজনীয়ে ফৰৌণক ক’লে, “ইব্ৰীয়া মহিলা সকল মিচৰীয়া মহিলা সকলৰ দৰে নহয়; তেওঁলোক সবল, আৰু তেওঁলোকৰ ওচৰলৈ ধাত্ৰী অহাৰ আগতে, তেওঁলোকে নিজে সন্তান প্ৰসৱ কৰে।” ");
INSERT INTO asmfb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ঈশ্বৰে সেই ধাত্ৰী দুজনীক ৰক্ষা কৰিলে। লোক সকল সংখ্যাত বৃদ্ধি পালে আৰু অধিক বলৱন্ত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ধাত্ৰী দুজনীয়ে ঈশ্বৰলৈ ভয় কৰিছিল, সেয়ে ঈশ্বৰে তেওঁলোকৰ বাবে পৰিয়াল গঠন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","পাছত ফৰৌণে নিজৰ সকলো প্ৰজাকে এই আজ্ঞা দিলে যে, “তোমালোকে নতুন কৈ জন্ম হোৱা প্ৰত্যেক ল’ৰা শিশুক নীল নদীত পেলাই দিব লাগিব, কিন্তু প্ৰতিজনী ছোৱালীক হ’লে জীয়াই ৰাখিব পাৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","লেবী বংশৰ এজন মানুহে এজনী লেবীয়া ছোৱালী বিয়া কৰালে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","পাছত সেই মহিলা গৰাকী গৰ্ভৱতী হ’ল, আৰু এটি পুত্র সন্তান প্ৰসৱ কৰিলে। তেওঁ যেতিয়া দেখিলে যে, সন্তানটো স্বাস্থ্যবান; তেতিয়া তেওঁ সন্তানটি তিনি মাহলৈ লুকুৱাই ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","কিন্তু তেওঁ যেতিয়া দেখিলে যে, ল’ৰাটোক বেছি দিন লুকুৱাই ৰাখিব নোৱাৰিব; তেতিয়া তেওঁ নলেৰে এটা পাচি সাজিলে, আৰু সেই পাচিটো শিলাজতু আৰু এঠাৰে লেপি ল’লে, পাছত সেই পাচিটোত ল’ৰাজনক সুমুৱাই ল’লে, আৰু নদীৰ দাঁতিত থকা নল-খাগড়িৰ মাজত গৈ থলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","তাতে দূৰৈত থিয় হৈ বায়েকে সেই শিশুটোৰ কি হ’ব, সেই বিষয়ে জানিবলৈ বাট চাই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ফৰৌণৰ জীয়েকে নদীত গা ধুবলৈ নামি গৈছিল, আৰু তেওঁৰ যুৱতী দাসী সকলে নদীৰ তীৰত ফুৰি আছিল। এনেতে তেওঁ নল খাগড়ি মাজত সেই পাচিটো দেখি, তেওঁৰ দাসী এজনীক পাচিটো আনিবলৈ পঠিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","তেওঁ পাচিটো মেলি শিশুটি দেখিলে। এনেতে শিশুটিয়ে কান্দিবলৈ ধৰিলে; আৰু তেওঁৰ শিশুটিলৈ মৰম লাগি ক’লে, “এই সন্তানটি নিশ্চয় এটি ইব্ৰীয়া সন্তান।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","তেতিয়া শিশুটিৰ বায়েকে ফৰৌণৰ জীয়েকক ক’লে, “আপোনাৰ অৰ্থে এই সন্তানটিক পিয়াহ খোৱাই তুলিবলৈ, মই এজনী ইব্ৰীয়া মহিলা বিচাৰি মাতি আনিম নে?” ");
INSERT INTO asmfb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ফৰৌণৰ জীয়েকে ক’লে, “যোৱা।” তেতিয়া সেই ছোৱালী জনীয়ে শিশুটিৰ মাককে মাতি নিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ফৰৌণৰ জীয়েকে শিশুটিৰ মাতৃক ক’লে, “আপুনি এই ল’ৰাটি লওক আৰু মোৰ বাবে পিয়াহ খুৱাই প্রতিপালন কৰক; তাৰ বাবে মই আপোনাক পাৰিশ্রমিক দিম।” তেতিয়া মহিলা গৰাকীয়ে ল’ৰাটি নিলে আৰু পিয়াহ খোৱাই প্রতিপালন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ল’ৰাটি যেতিয়া ডাঙৰ হ’ল, তেওঁ ল’ৰাটিক ফৰৌণৰ জীয়েকৰ ওচৰলৈ আনিলে; তেতিয়া সেই লৰাটি তেওঁৰ পুত্ৰ হ’ল। তেওঁ লৰাটিৰ নাম মোচি ৰাখি ক’লে, “কিয়নো মই ইয়াক পানীৰ পৰা তুলি আনিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","মোচি যেতিয়া ডেকা হ’ল, তেওঁ বাহিৰলৈ ওলাই গৈ নিজৰ লোকসকলৰ কঠোৰ পৰিশ্রম লক্ষ্য কৰিলে। তেওঁ দেখিলে যে, নিজৰ লোকসকলৰ মাজৰ এজন ইব্ৰীয়াক এজন মিচৰীয়াই মাৰি আছে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","তেতিয়া মোচিয়ে ইফালে সিফালে চাই কাকো দেখা নাপায়, সেই মিচৰীয়াজনক বধ কৰি বালিত পুতি থলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","তাৰ পাছদিনা তেওঁ ওলাই গৈ, দুজন ইব্ৰীয়াক বিবাদ কৰি থকা দেখি, দোষী জনক তেওঁ ক’লে, “তোমাৰ ভাইক কিয় মাৰিছা?” ");
INSERT INTO asmfb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","কিন্তু মানুহ জনে ক’লে, “আমাৰ ওপৰত আপোনাক কোনে অধিপতি আৰু বিচাৰক পাতিছে? সেই মিচৰীয়াজনক যেনেদৰে বধ কৰিলে, তেনেদৰে মোকো বধ কৰিবলৈ পৰিকল্পনা কৰিছে নেকি?” তেতিয়া মোচিয়ে আতঙ্কিত হৈ ক’লে, “বাস্তৱিকতে মই যি কৰিলোঁ, সেই কথা নিশ্চয় আনেও গ’ম পালে।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ফৰৌণে যেতিয়া সেই কথা শুনিলে, তেতিয়া তেওঁ মোচিক বধ কৰিবলৈ চেষ্টা কৰিলে। কিন্তু তেওঁ ৰজা ফৰৌণৰ ওচৰৰ পৰা পলাই গ’ল, আৰু মিদিয়ন দেশত বাস কৰিলে। তাত তেওঁ এটা নাদৰ ওচৰত বহিল। ");
INSERT INTO asmfb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","মিদিয়নৰ পুৰোহিতৰ সাত গৰাকী জীয়েক আছিল। তেওঁলোকে সেই নাদলৈ আহিছিল, আৰু পিতৃৰ মেৰ-ছাগৰ জাকক পানী খুৱাবৰ বাবে নাদৰ পৰা পানী তুলি পাত্রত ভৰাই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","তেতিয়া মেৰ-ছাগ ৰখীয়া সকল তালৈ আহিল আৰু তেওঁলোকক খেদিবলৈ চেষ্টা কৰিলে; কিন্তু মোচিয়ে গৈ তেওঁলোকক সহায় কৰিলে। তাৰ পাছত মোচিয়ে তেওঁলোকৰ মেৰ-ছাগৰ জাকক পানী খুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ছোৱালী কেইজনী যেতিয়া তেওঁলোকৰ পিতৃ ৰূৱেলৰ ওচৰলৈ গ’ল, তেতিয়া তেওঁ ছোৱালী কেইজনীক সুধিলে, “আজিনো কেনেকৈ ইমান সোনকালে ঘৰলৈ আহিলা?” ");
INSERT INTO asmfb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","তেওঁলোকে ক’লে, “এজন মিচৰীয়া মানুহে আমাক মেৰ-ছাগ ৰখীয়া সকলৰ পৰা ৰক্ষা কৰিলে। এনেকি তেওঁ আমাৰ বাবে পানী তুলি মেৰ-ছাগ জাকক খুৱালে।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","তেতিয়া তেওঁৰ ছোৱালী কেইগৰাকীক তেওঁ সুধিলে, “তেওঁ ক’ত আছে? তোমালোকে সেই ব্যক্তি জনক কিয় এৰি আহিলা? তেওঁক মাতি আনা যাতে তেওঁ আমাৰ লগত ভোজন কৰিব পাৰে।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","মোচিয়ে সেই মানুহ জনৰ লগত থাকিবলৈ মান্তি হ’ল, আৰু তেওঁৰ ছোৱালী চিপ্পোৰাক তেওঁৰ সৈতে বিয়া দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","চিপ্পোৰাই এটি পুত্ৰ প্ৰসৱ কৰিলে, আৰু মোচিয়ে পুত্রটিৰ নাম গেৰ্চোম ৰাখিলে। মোচিয়ে ক’লে, “মই বিদেশত প্ৰবাসী হৈ আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","বহুত দিনৰ পাছত, মিচৰৰ ৰজাৰ মৃত্যু হ’ল। ইস্ৰায়েলী লোকসকলে বন্দীকামৰ বাবে আৰ্তনাদ কৰিলে। তেওঁলোকে সহায়ৰ বাবে কাতৰোক্তি কৰিলে আৰু তেওঁলোকৰ দাসত্ব জীৱনৰ কাৰণে তেওঁলোকৰ অনুৰোধ ঈশ্বৰে শুনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","তেতিয়া ঈশ্বৰে তেওঁলোকৰ ক্রন্দন শুনি, অব্ৰাহাম, ইচহাক, আৰু যাকোবৰ লগত কৰা তেওঁৰ নিয়মটি পুনৰ সোঁৱৰণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ঈশ্বৰে ইস্ৰায়েলী লোকসকললৈ দৃষ্টি কৰিলে, আৰু তেওঁলোকৰ পৰিস্থিতি বুজি পালে। ");
INSERT INTO asmfb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","মোচিৰ শহুৰ যিথ্ৰো মিদিয়নৰ পুৰোহিত আছিল, মোচিয়ে তেওঁৰ মেৰ-ছাগৰ জাক চৰাইছিল। তেতিয়া মোচিয়ে মৰুপ্রান্তৰ কাষদি মেৰ-ছাগৰ জাক লৈ গৈ আছিল, আৰু তেওঁ গৈ হোৰেব নামৰ ঈশ্বৰৰ পৰ্বত পাইছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","সেই ঠাইত যিহোৱাৰ দূতে এজোপা জোপোহা গছৰ মাজত অগ্নি শিখাত তেওঁক দেখা দিলে। মোচিয়ে চাই দেখিলে যে, জোপোহাটোত জুই জ্বলি আছে, কিন্তু জোপোহাটো পুৰি যোৱা নাই। ");
INSERT INTO asmfb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","তেতিয়া মোচিয়ে ক’লে, “মই এফলীয়া হৈ যাওঁ, আৰু এই আচৰিত বিষয়টো মই চাওঁ, কিয়নো এই জোপোহাটো পুৰি যোৱা নাই?” ");
INSERT INTO asmfb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","যেতিয়া যিহোৱাই দেখিলে যে, তেওঁক চাবলৈ মোচি এফলীয়া হৈ গৈছে, তেতিয়া জোপোহাটোৰ মাজৰ পৰা ঈশ্বৰে তেওঁক মাতি ক’লে, “হে মোচি, হে মোচি।” তেওঁ ক’লে, “চাওঁক, মই ইয়াতে আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","যিহোৱাই ক’লে, “তুমি ওচৰ চাপি নাহিবা; তোমাৰ ভৰিৰ পৰা জোতা সোলোকোৱা, কিয়নো তুমি যি ঠাইত থিয় হৈ আছা, সেয়া পবিত্ৰ ভূমি।” ");
INSERT INTO asmfb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","তেওঁ পুনৰ ক’লে, “মই তোমাৰ পূর্বপুৰুসকলৰ ঈশ্বৰ; অব্ৰাহামৰ ঈশ্বৰ, ইচহাকৰ ঈশ্বৰ, আৰু যাকোবৰ ঈশ্বৰ।” তেতিয়া মোচিয়ে নিজৰ মুখ ঢাকিলে, কিয়নো তেওঁ ঈশ্বৰক চাবলৈ ভয় কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","যিহোৱাই ক’লে, “মই মিচৰত থকা মোৰ লোকসকলৰ যন্ত্রণালৈ নিশ্চয়ে দৃষ্টি কৰিছোঁ। কাৰণ তেওঁলোক অতি কঠোৰ তত্বাৱধায়কৰ তলত আছে, মই তেওঁলোকৰ ক্রন্দন শুনিছোঁ, মই তেওঁলোকৰ যন্ত্রণাৰ বিষয় বুজি পাইছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","মই তেওঁলোকক মিচৰীয়া লোকৰ হাতৰ পৰা উদ্ধাৰ কৰিবলৈ নামি আহিলোঁ। সেই দেশৰ পৰা উলিয়াই আনি, গাখীৰ মৌ-জোলবৈ থকা এখন উত্তম আৰু বহল দেশ, য’ত কনানীয়া, হিত্তীয়া, ইমোৰীয়া, পৰিজ্জীয়া, হিব্বীয়া, যিবুচীয়া লোক সকলে বাস কৰে, এনে ঠাইলৈ তেওঁলোকক নিবলৈ আহিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","এতিয়া ইস্ৰায়েলৰ লোকসকলৰ কাতৰোক্তি মোৰ ওচৰলৈ আহিল। অৱশ্যে মিচৰীয়া সকলে তেওঁলোকৰ ওপৰত কৰা উপদ্ৰবো মই দেখিছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","সেয়ে মোৰ ইস্ৰায়েলী লোকসকলক মিচৰৰ পৰা উলিয়াই আনিবলৈ, মই এতিয়া তোমাক ফৰৌণৰ ওচৰলৈ পঠাওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","কিন্তু মোচিয়ে ঈশ্বৰক ক’লে, “মইনো কোন যে, ফৰৌণৰ ওচৰলৈ গৈ ইস্ৰায়েলী লোকসকলক মিচৰৰ পৰা উলিয়াই আনিম?” ");
INSERT INTO asmfb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ঈশ্বৰে উত্তৰ দি ক’লে, “অৱশ্যে মই তোমাৰ সঙ্গী হ’ম; আৰু মইয়ে তোমাক পঠালোঁ, ইয়াৰ চিন তোমালৈ এয়ে হ’ব যে, তুমি মিচৰৰ পৰা লোকসকলক উলিয়াই আনি, এই পৰ্ব্বততে তোমালোকে ঈশ্বৰৰ আৰধনা কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","মোচিয়ে ঈশ্বৰক ক’লে, “মই যেতিয়া ইস্ৰায়েলী লোকসকলক ক’ম যে, তোমালোকৰ ওপৰ-পিতৃসকলৰ ঈশ্বৰে মোক তোমালোকৰ ওচৰলৈ পঠালে; তেতিয়া তেওঁলোকে মোক ক’ব, ‘তেওঁৰ নাম কি?’ তেতিয়া মই কি উত্তৰ দিম?” ");
INSERT INTO asmfb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ঈশ্বৰে মোচিক ক’লে, “মই যি জন হওঁ, সেই জনেই হওঁ।” ঈশ্বৰে পুনৰ ক’লে, “তুমি ইস্ৰায়েলী লোকসকলক নিশ্চয়কৈ ক’বা যে, ‘মই যি জন হওঁ’ তেৱেঁই মোক তোমালোকৰ ওচৰলৈ পঠালে।” ");
INSERT INTO asmfb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ঈশ্বৰে মোচিক পুনৰ ক’লে, “তুমি ইস্ৰায়েলী লোকসকলক অৱশ্যে ক’বা যে, ‘তোমালোকৰ ওপৰ-পিতৃসকলৰ ঈশ্বৰ, অব্ৰাহামৰ ঈশ্বৰ, ইচহাকৰ ঈশ্বৰ, আৰু যাকোবৰ ঈশ্বৰ যিহোৱায়ে মোক তোমালোকৰ ওচৰলৈ পঠালে। এয়ে মোৰ চিৰস্থায়ী নাম, আৰু ইয়াৰ দ্বাৰাই পুৰুষানুক্ৰমে মই সোঁৱৰণীয় হম।’ ");
INSERT INTO asmfb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","তুমি যোৱা, আৰু ইস্ৰায়েলৰ বৃদ্ধ লোকসকলক একত্রিত কৰি সমবেত কৰোঁৱা। তেওঁলোকক ক’বা যে, ‘তোমালোকৰ ওপৰ-পিতৃ অব্ৰাহাম, ইচহাক, আৰু যাকোবৰ ঈশ্বৰ যিহোৱাই মোক দৰ্শন দি ক’লে যে, ‘মই তোমালোকক নিৰীক্ষণ কৰিলোঁ আৰু তোমালোকক মিচৰত কেনে ব্যৱহাৰ কৰিছে, সেয়া মই দেখিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","মিচৰ দেশত তোমালোকৰ ওপৰত কৰা উপদ্রৱৰ পৰা তোমালোকক উলিয়াই আনি, গাখীৰ, মৌ-জোল বৈ থকা সেই কনানীয়া, হিত্তীয়া, ইমোৰীয়া, পৰিজ্জীয়া, হিব্বীয়া, আৰু যিবুচীয়া সকলৰ দেশলৈ মই তোমালোকক লৈ যাবলৈ প্রতিজ্ঞা কৰিছোঁ’। ");
INSERT INTO asmfb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","তেতিয়া তেওঁলোকে তোমাৰ কথা শুনিব। তাৰ পাছত তুমি আৰু ইস্ৰায়েলৰ বৃদ্ধ লোকসকলে মিচৰৰ ৰজাৰ ওচৰলৈ গৈ, তেওঁক নিশ্চয়কৈ ক’বা যে, ‘ইব্ৰীয়াসকলৰ ঈশ্বৰ যিহোৱা আমাৰ আগত সাক্ষাৎ হ’ল। সেয়ে আমি তিনি দিন মৰুভূমিৰ মাজেৰে গৈ ঈশ্বৰ যিহোৱাৰ উদ্দেশে বলিদান কৰিবৰ অৰ্থে আমাক যাবলৈ দিয়ক।’ ");
INSERT INTO asmfb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","কিন্তু মই জানো, যেতিয়ালৈকে মিচৰৰ ৰজাক বাধ্য কৰোঁৱা নহয়, তেতিয়ালৈকে তেওঁ তোমালোকক যাব নিদিব। ");
INSERT INTO asmfb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","মই নিজ হাত মেলিম, আৰু মিচৰ দেশৰ মাজত সকলো আচৰিত কৰ্মেৰে মই তেওঁলোকক আঘাত কৰিম। তাৰ পাছতহে তেওঁ তোমালোকক যাবলৈ দিব। ");
INSERT INTO asmfb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","মই মিচৰীয়াসকলৰ পৰা তোমালোকক অনুগ্ৰহপ্ৰাপ্ত কৰিম। সেয়ে তোমালোকে যোৱা সময়ত শুদা-হাতে যাব লগা নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","প্ৰতি গৰাকী মহিলাই নিজৰ ওচৰ-চুবুৰীয়া, আৰু নিজৰ ঘৰৰ ওচৰত বাস কৰা মহিলা সকলৰ পৰা ৰূপ আৰু সোণৰ অলঙ্কাৰ আৰু বস্ত্ৰ খুজিবা; আৰু তোমালোকে সেইবোৰ নিজৰ লৰা-ছোৱালীক পিন্ধাবা; এই দৰে তোমালোকে মিচৰীয়া সকলক লুট কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","মোচিয়ে উত্তৰ দি ক’লে, “কিন্তু তেওঁলোকে যদি মোক বিশ্বাস নকৰে, আৰু মোৰ কথাও নুশুনে; আৰু তাৰ পৰিৱৰ্ত্তে তেওঁলোকে মোক ক’ব, ‘যিহোৱাই তোমাক দৰ্শন দিয়া নাই’ তেতিয়া কি হ’ব?” ");
INSERT INTO asmfb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","যিহোৱাই তেওঁক ক’লে, “তোমাৰ হাতত কি আছে?” মোচিয়ে ক’লে, “লাখুটি।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","তেতিয়া যিহোৱাই ক’লে, “লাখুটি ডাল মাটিত পেলাই দিয়া।” তেতিয়া মোচিয়ে লাখুটিডাল মাটিত পেলাই দিলে, আৰু তেতিয়াই সেই লাখুটি ডাল সাপ হৈ পৰিল। মোচিয়ে তাৰ পৰা পাছ হুঁহকি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “তুমি তোমাৰ হাত মেলি তাৰ নেগুৰত ধৰা।” মোচিয়ে নিজৰ হাত মেলি তাক ধৰিলে, আৰু তেওঁৰ হাতত সেই সাপ ডাল পুনৰ লাখুটি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“ইয়াৰ বাবেই তেওঁলোকৰ ওপৰ-পিতৃ অব্ৰাহাম, ইচহাক আৰু যাকোবৰ ঈশ্বৰ যিহোৱাই যে তোমাক দৰ্শন দিলে, সেই কথা তেওঁলোকে বিশ্বাস কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","যিহোৱাই তেওঁক পুনৰ ক’লে, “তুমি তোমাৰ হাত চোলাত ভৰোৱা।” সেয়ে মোচিয়ে হাতখন নিজৰ চোলাত ভৰালে। পাছত তেওঁ যেতিয়া হাতখন বাহিৰলৈ উলিয়াই আনিলে, তেতিয়া তেওঁ দেখিলে যে, তেওঁৰ হাত কুষ্ঠ ৰোগেৰে হিমৰ নিচিনা বগা হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","যিহোৱাই ক’লে, “তোমাৰ হাত পুনৰ চোলাত ভৰোৱা।” তেতিয়া মোচিয়ে নিজৰ হাত পুনৰ চোলাত ভৰালে; আৰু যেতিয়া বাহিৰলৈ উলিয়ালে তেওঁ দেখিলে যে, তেওঁৰ শৰীৰৰ অৱশিষ্ট অংশৰ দৰেই হাতখন পুনৰ সুস্থ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","যিহোৱাই ক’লে, “তেওঁলোকে যদি তোমাক বিশ্বাস নকৰে, আৰু মোৰ শক্তিৰ সেই প্ৰথম চিনকো যদি বিশ্বাস নকৰে, তেনেহ’লে তেওঁলোকে দ্বিতীয় চিনত বিশ্বাস কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","তেওঁলোকে যদি এই দুয়োটা চিনকো বিশ্বাস নকৰে, আৰু তোমাৰ কথাও নুশুনে, তেনেহ’লে তুমি নদীৰ পৰা অলপ পানী লৈ শুকান মাটিত ঢালিবা। তেতিয়া তুমি নদীৰ পৰা লোৱা সেই পানী শুকান মাটিত ঢালি দিওঁতে, সেই পানী তেজলৈ পৰিণত হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","তেতিয়া মোচিয়ে যিহোৱাক ক’লে, “হে মোৰ প্ৰভু মিনতি কৰিছোঁ, মই বাকপটু নহওঁ; ইয়াৰ পূৰ্বেও নাছিলোঁ, বা আপুনি নিজ দাসক কথা কোৱাৰ পাছতো নহওঁ। কাৰণ মোৰ মুখ আৰু জীবা গধূৰ।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","যিহোৱাই মোচিক ক’লে, “মানুহৰ মুখ কোনে নিৰ্মাণ কৰিলে? বোবা বা কলা, নাইবা চকু থকা বা অন্ধ কোনে কৰিলে? মই যিহোৱায়ে জানো তাক নকৰোঁ? ");
INSERT INTO asmfb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","তেনেহ’লে এতিয়া তুমি যোৱা; মই তোমাৰ মুখত থাকিম, আৰু তুমি কবলগীয়া কথা মই তোমাক শিকাম।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","কিন্তু মোচিয়ে ক’লে, “হে মোৰ প্ৰভু অনুগ্রহ কৰি, আপুনি যি জনক ইচ্ছা কৰে, তেনে আন কোনো এজনক পঠিয়াওক।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","তেতিয়া মোচিলৈ যিহোৱাৰ ক্ৰোধ প্ৰজ্বলিত হ’ল। তেওঁ ক’লে, “তোমাৰ লেবীয়া ককায়েৰ হাৰোণ ক’ত আছে? মই জানো, তেওঁ ভালকৈ কথা ক’ব পাৰে। অৱশ্যে তেওঁ তোমাক ল’গ পাবলৈ আহি আছে; আৰু তেওঁ আহি তোমাক যেতিয়া দেখিব, তেতিয়া তেওঁ আনন্দিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","তুমি তেওঁক ক’বা, আৰু তেওঁৰ মুখে কি ক’ব লাগে সেই বাক্য দিবা। মই তোমাৰ আৰু তেওঁৰ মুখৰো সহায় হ’ম, আৰু কি কৰিব লাগে, সেই বিষয়ে তোমালোকক জনাম। ");
INSERT INTO asmfb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","তেওঁ লোক সকলৰ আগত তোমাৰ হৈ কথা ক’ব। তেওঁ তোমাৰ মুখস্থৰূপ হ’ব, আৰু তুমি তেওঁৰ ঈশ্বৰ স্বৰূপ হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","এই লাখুটিডাল তুমি নিজ হাতত লোৱা। এই লাখুটি ডালেৰেই তুমি চিনবোৰ দেখুৱাবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","তাৰ পাছত মোচিয়ে তেওঁৰ শহুৰেক যিথ্রোৰ ওচৰলৈ উভটি গ’ল, আৰু তেওঁক ক’লে, “মই বিনয় কৰোঁ, মিচৰত থকা মোৰ সম্পৰ্কীয় লোকসকল এতিয়ালৈকে জীয়াই আছে নে নাই, তাক চাবৰ বাবে তেওঁলোকৰ ওচৰলৈ উভটি যাবলৈ মোক দিয়ক।” যিথ্ৰোৱে মোচিক ক’লে, “শান্তিৰে যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","যিহোৱাই মিদিয়নত মোচিক ক’লে, “তুমি মিচৰলৈ উভটি যোৱা; কিয়নো যি সকল লোকে তোমাৰ প্ৰাণ ল’ব বিচাৰিছিল, সেই লোক সকলৰ মৃত্যু হ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","তেতিয়া মোচিয়ে নিজৰ ভাৰ্যা আৰু পুত্রক এটা গাধত উঠাই ল’লে আৰু মিচৰ দেশলৈ যাত্রা কৰিলে। মোচিয়ে ঈশ্বৰৰ সেই লাখুটি ডালো নিজৰ হাতত ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","যিহোৱাই মোচিক কৈছিল, “তুমি যেতিয়া মিচৰলৈ উভটি যাবা, তেতিয়া মই তোমাৰ হাতত যিবোৰ আচৰিত কাৰ্যৰ শক্তি দিলোঁ, সেই সকলো ফৰৌণৰ সাক্ষাতে কৰিবা। কিন্তু মই তেওঁৰ মন কঠিন কৰিম, আৰু সেয়ে তেওঁ তেতিয়া লোকসকলক এৰি নিদিব। ");
INSERT INTO asmfb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","তুমি ফৰৌণক নিশ্চয়কৈ ক’বা, ‘যিহোৱাই এইদৰে কৈছে: ইস্ৰায়েল মোৰ পুত্ৰ, মোৰ জ্যেষ্ঠ পুত্ৰ’; ");
INSERT INTO asmfb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","মই তোমাক কৈছিলোঁ, ‘মোৰ আৰধনা কৰিবৰ অৰ্থে মোৰ পুত্ৰক এৰি দিয়া’। কিন্তু তথাপিও তেওঁলোকক এৰি দিবলৈ তুমি অসন্মত হ’লা; সেয়ে মই তোমাৰ পুত্ৰ, তোমাৰ জ্যেষ্ঠ পুত্ৰক নিশ্চয় বধ কৰিম’।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","তাৰ পাছত যাত্রা কৰি গৈ থাকোতে, ৰাতি হোৱাৰ বাবে তেওঁলোক এঠাইত থাকিল; তাতে যিহোৱাই মোচিক লগ পালে, আৰু বধ কৰিব খুজিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","তেতিয়া চিপ্পোৰাই এটুকুৰা চিকমিকিয়া চোকা পাথৰ ল’লে; আৰু নিজৰ পুত্ৰৰ লিঙ্গাগ্ৰ-চৰ্ম্ম ছেদন কৰি, মোচিৰ ভৰিত পেলাই দি ক’লে, “নিশ্চয়ে আপুনি মোৰ পক্ষে তেজৰ দ্বাৰাই পোৱা দৰা।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","সেয়ে যিহোৱাই তেওঁক এৰি দিলে। চিপ্পোৰাই ক’লে, “চুন্নতৰ কাৰণে আপুনি তেজৰ দ্বাৰাই পোৱা দৰা।” ");
INSERT INTO asmfb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","যিহোৱাই হাৰোণক কৈছিল, “তুমি মোচিৰে সৈতে সাক্ষাৎ কৰিবলৈ মৰুভূমিলৈ যোৱা।” তেতিয়া হাৰোণ গ’ল, আৰু ঈশ্বৰৰ পৰ্বতত মোচিক লগ ধৰি, তেওঁক চুমা খালে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","তেতিয়া মোচিয়ে যিহোৱাই কোৱা সকলো কথা আৰু চিন দেখুৱাবৰ বাবে শক্তিৰে কাৰ্য কৰিবলৈ যিহোৱাই দিয়া আজ্ঞাৰ কথা হাৰোণক ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","তাৰ পাছত মোচি আৰু হাৰোণ দুয়ো গৈ ইস্ৰায়েলী লোকসকলৰ বৃদ্ধ লোকসকলক একগোট কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","যিহোৱাই মোচিক কোৱা সকলো কথা হাৰোণে তেওঁলোকক ক’লে। তেওঁ লোকসকলৰ আগত যিহোৱাৰ শক্তিৰ দ্বাৰাই চিনবোৰো দেখুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","তেতিয়া লোকসকলে বিশ্বাস কৰিলে। যিহোৱাই যে ইস্ৰায়েলী লোক সকললৈ দৃষ্টি কৰিলে; আৰু তেওঁলোকৰ যাতনাবোৰ চালে, সেই কথা শুনি তেওঁলোকে মূৰ দোঁৱাই প্রণিপাত কৰি ঈশ্বৰৰ আৰাধনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","এই ঘটনাৰ পাছত মোচি আৰু হাৰোণে গৈ ফৰৌণক ক’লে, “ইস্ৰায়েলৰ ঈশ্বৰ যিহোৱাই এইদৰে কৈছে, ‘মৰুভূমিত মোৰ উদ্দেশ্যে উৎসৱ পালন কৰিবলৈ, মোৰ লোকসকলক যাবলৈ দিয়া’।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ফৰৌণে ক’লে, “যিহোৱা কোন? কিয় মই তেওঁৰ কথা শুনিম; আৰু ইস্ৰায়েলী লোক সকলক যাবলৈ কিয় এৰি দিম? মই যিহোৱাক নাজানো, গতিকে ইস্ৰায়েলী লোক সকলক যাবলৈ এৰি নিদিওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","তাৰ পাছত মোচি আৰু হাৰোণে ক’লে, “ইব্ৰীয়াসকলৰ ঈশ্বৰে আমাৰ লগত সাক্ষাত কৰিলে। আহক আমি আমাৰ ঈশ্বৰ যিহোৱাৰ উদ্দেশ্যে বলিদান কৰিবৰ অৰ্থে মৰুভূমিৰ মাজেৰে তিনি দিনৰ বাট যাওঁহক; যাতে তেওঁ আমাক মহামাৰী বা তৰোৱালেৰে আক্ৰমণ নকৰে।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","কিন্তু মিচৰৰ ৰজাই তেওঁলোকক ক’লে, “মোচি আৰু হাৰোণ, তোমালোকে কিয় লোক সকলক তেওঁলোকৰ কামৰ পৰা লৈ গৈছা?” এই বুলি লোকসকলক তেওঁ ক’লে, “তোমালোক কামলৈ ঘূৰি যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ফৰৌণে পুনৰ ক’লে, “বৰ্তমান আমাৰ দেশত অনেক ইস্ৰায়েলী লোক আছে, আৰু তোমালোকে তেওঁলোকৰ কাম বন্ধ কৰাইছা।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","সেই দিনাই ফৰৌণে লোক সকলৰ কঠোৰ তত্বাৱধায়ক আৰু মুখিয়াল সকলক এই আজ্ঞা দি ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“আগেয়ে দিয়াৰ দৰে তেওঁলোকক ইটা বনাবলৈ তোমালোকে নৰা আনি নিদিবা। তেওঁলোকে নিজেই গৈ নৰা বিচাৰি লওক। ");
INSERT INTO asmfb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","তেওঁলোকে আগেয়ে যিমান পৰিমাণৰ ইটা বনাইছিল, এতিয়াও তেওঁলোকক সিমানেই বনাবলৈ দিয়া। তাৰ অলপো কম গ্ৰহণ নকৰিব; কাৰণ তেওঁলোক এলেহুৱা। তেওঁলোকে চিঞৰিছে আৰু ক’বলৈ ধৰিছে, ‘আমাক যাবলৈ অনুমতি দিয়ক আৰু আমাৰ ঈশ্বৰৰ উদ্দেশ্যে বলিদান উৎসৰ্গ কৰিবলৈ দিয়ক’।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","তেওঁলোকৰ ওপৰত কামৰ ভাৰ অধিক গধূৰ কৰি দিয়া হওক; যাতে তেওঁলোকে কামৰ মাজত ব্যস্ত থাকি বিভ্রান্তিজনক কথাত মন নিদিয়ে। ");
INSERT INTO asmfb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","তাৰ পাছত, কঠোৰ তত্বাৱধায়ক আৰু মুখিয়াল সকলে বাহিৰলৈ ওলাই আহিল আৰু লোকসকলক তেওঁলোকে ক’লে, “ফৰৌণে এইদৰে কৈছে, ‘মই তোমালোকক এতিয়াৰ পৰা কোনো নৰা নিদিওঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","তোমালোক নিজে যোৱা আৰু য’ত বিচাৰি পোৱা, তাৰ পৰা নৰা বিচাৰি আনা; কিন্তু তোমালোকৰ কামৰ নিৰ্দ্দিষ্ট পৰিমাণ হ্রাস কৰা নহব।’” ");
INSERT INTO asmfb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","তেতিয়া লোক সকলে নৰা বিচাৰি জমা কৰিবলৈ মিচৰ দেশৰ চাৰিওফালে সিঁচৰতি হৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","তথাপি কঠোৰ তত্বাৱধায়ক সকলে তেওঁলোকক তাড়না কৰি ক’লে, “তোমালোকক নৰা দিওঁতে, তোমালোকে যেনেকৈ কাম কৰিছিলা, এতিয়াও তেনেকৈ প্ৰতিদিনৰ নিৰূপিত কাম সম্পূৰ্ণ কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","তাৰ পাছত ফৰৌণৰ কঠোৰ তত্বাৱধায়ক সকলে শ্রমিক সকলৰ ওপৰত নিযুক্ত কৰা ইস্ৰায়েলী মুখিয়াল সকলক প্ৰহাৰ কৰিলে। সেই তত্বাৱধায়ক সকলে তেওঁলোকক সুধিলে, “তোমালোকক নিৰূপিত কৰি দিয়া অনুপাতে আগৰ দৰে, কালি আৰু আজি তোমালোকে কিয় ইটা তৈয়াৰ কৰিব পৰা নাই?” ");
INSERT INTO asmfb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","সেয়ে কাৰখানাত কাম কৰা ইস্ৰায়েলী কৰ্মচাৰী সকলে ফৰৌণৰ ওচৰলৈ আহিল; আৰু তেওঁক কাকুতি কৰি ক’লে, “আপোনাৰ দাস বিলাকৰ খেত্ৰত কিয় আপুনি এনে ব্যৱহাৰ কৰিছে? ");
INSERT INTO asmfb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","আপোনাৰ দাস সকলক এতিয়া নৰা দিয়া হোৱা নাই, তথাপিও তেওঁলোকে আমাক কৈ আছে ‘ইটা তৈয়াৰ কৰা!’ এনেকি আমিও আপোনাৰ দাস সকলৰ দ্বাৰাই প্ৰহাৰিত হৈছোঁ। কিন্তু এয়া আপোনাৰ নিজৰ লোক সকলৰহে ভূল।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","কিন্তু ফৰৌণে ক’লে, “তোমালোক এলেহুৱা! তোমালোক সকলোৱে এলেহুৱা! তোমালোকে কৈছা, ‘আমাৰ ঈশ্বৰ যিহোৱাৰ উদ্দেশ্যে বলিদান কৰিবলৈ আমাক যাবলৈ দিয়ক।’ ");
INSERT INTO asmfb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","সেয়ে এতিয়া কাম কৰিবলৈ ঘূৰি যোৱা। আপোনালোকক পুনৰ নৰা দিয়া নহব, কিন্তু তোমালোকে আগৰ পৰিমাণৰ সমানেই ইটা তৈয়াৰ কৰিব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“তোমালোক প্ৰতিদিনে বনাব লগা ইটাৰ সংখ্যা অলপো কম কৰা নহব।” এই কথা কোৱাৰ পাছত, ইস্ৰায়েলী মুখিয়াল সকলে দেখিলে যে, তেওঁলোক বিপদত পৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","তেওঁলোকে ফৰৌণৰ আগৰ পৰা ওলাই আহোঁতে ৰাজপ্রসাদৰ বাহিৰত ঠিয় হৈ থকা মোচি আৰু হাৰোণক লগ পালে। ");
INSERT INTO asmfb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","তেওঁলোকে মোচি আৰু হাৰোণক ক’লে, “যিহোৱাই আপোনালোকলৈ দৃষ্টি কৰি দণ্ড দিয়ক; কাৰণ আপোনালোকে ফৰৌণ আৰু তেওঁৰ দাস সকলৰ সাক্ষাতে আমাক দোষী কৰিলে। আমাক বধ কৰিবলৈ আপোনালোকে তেওঁলোকৰ হাতত তৰোৱাল তুলি দিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","তেতিয়া মোচিয়ে যিহোৱাৰ ওচৰত প্রাৰ্থনা কৰি ক’লে, “হে প্ৰভু, আপুনি এই লোক সকলক বিপদত কিয় পেলালে? মোৰ আগৰ ঠাইলৈ মোক কিয় পঠিয়ালে? ");
INSERT INTO asmfb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","মই যেতিয়াৰে পৰা আপোনাৰ নামেৰে ফৰৌণৰ আগত কথা ক’বলৈ উপস্থিত হলোঁ, তেতিয়াৰে পৰা তেওঁ এই লোক সকলক যন্ত্রণা দিছে; আৰু আপুনি নিজৰ লোক সকলক সমূলি উদ্ধাৰ কৰা নাই।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","তেতিয়া যিহোৱাই মোচিক ক’লে, “ফৌৰণলৈ মই কি কৰিম, এতিয়া তুমি দেখিবলৈ পাবা। তুমি দেখিবলৈ পাবা যে, মোৰ হাতৰ শক্তিৰ বাবেই ৰজাই লোক সকলক যাবলৈ দিব। মোৰ হাতৰ শক্তিৰ কাৰণেই ৰজা ফৰৌণে নিজই তেওঁলোকক দেশৰ পৰা খেদি পঠিয়াব।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ঈশ্বৰে মোচিৰ সৈতে কথা পাতি তেওঁক ক’লে, “মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","মই অব্ৰাহাম, ইচহাক, আৰু যাকোবৰ আগতো সৰ্ব্বশক্তিমান ঈশ্বৰ বুলি দৰ্শন দিছিলোঁ, কিন্তু মোৰ যিহোৱা নামৰ দ্বাৰাই মই তেওঁলোকক পৰিচয় দিয়া নাই। ");
INSERT INTO asmfb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ইয়াৰ উপৰিও যি কনান দেশত তেওঁলোকে বিদেশীৰ দৰে বাস কৰিছিল, আৰু অনাই বনাই ঘুৰি ফুৰিছিল, সেই দেশ তেওঁলোকক দিবলৈ মই তেওঁলোকৰ সৈতে এটা নিয়ম স্থিৰ কৰিছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","তাৰ উপৰিও, মিচৰীয়া সকলে বন্দীকামত লগোৱা ইস্ৰায়েলী লোক সকলৰ ক্রন্দন মই শুনিলো, আৰু মোৰ সেই নিয়মটি মই স্মৰণ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","এই হেতুকে ইস্ৰায়েলী লোক সকলক কোৱা, ‘মই যিহোৱা; মই মিচৰীয়া সকলৰ বন্দীত্বৰ পৰা তোমালোকক উলিয়াই আনিম, আৰু মই তেওঁলোকৰ ক্ষমতাৰ পৰা তোমালোকক মুক্ত কৰিম। মই মোৰ শক্তি প্রদর্শন কৰিম; আৰু ন্যায় বিচাৰৰ মহা-কৰ্মেৰে তোমালোকক উদ্ধাৰ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","মই তোমালোকক মোৰ নিজৰ লোক কৰি ল’ম, আৰু মইয়ে তোমালোকৰ ঈশ্বৰ হ’ম। তোমালোকক মিচৰৰ বন্দীত্বৰ পৰা উলিয়াই অনা ময়েই যে তোমালোকৰ সেই ঈশ্বৰ যিহোৱা, ইয়াক তোমালোকে জানিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","মই যি দেশ অব্ৰাহাম, ইচহাক, আৰু যাকোবক দিম বুলি শপত খাইছিলোঁ, সেই দেশলৈ তোমালোকক নিম, আৰু তোমালোকৰ অধিকাৰৰ অৰ্থেও সেই দেশ মই তোমালোকক দিম; ময়েই যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","যেতিয়া মোচি গৈ ইস্ৰায়েলী লোক সকলক সেই কথা কলে; তেতিয়া তেওঁলোকে কঠিন বন্দীকামৰ বাবে নিৰুৎসাহ হৈ মোচিৰ কথাত মন নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","সেয়ে যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“তুমি গৈ মিচৰৰ ৰজা ফৰৌণক কোৱা যে, ইস্ৰায়েলী লোক সকলক আপোনাৰ দেশৰ পৰা ওলাই যাবলৈ এৰি দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","মোচিয়ে যিহোৱাক ক’লে, “যদি ইস্ৰায়েলী লোক সকলেই মোৰ কথা নুশুনে; তেনেহ’লে ফৰৌণে মোৰ কথা কিয় শুনিব? যিহেতু মই কথা কোৱাত নিপুণ নহয়।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","যিহোৱাই মোচি আৰু হাৰোণৰ লগত কথা পাতিলে; আৰু মিচৰ দেশৰ পৰা ইস্রায়েলী লোক সকলক উলিয়াই দিবলৈ ইস্ৰায়েলী লোক আৰু মিচৰ দেশৰ ৰজা ফৰৌণৰ বাবে তেওঁ আজ্ঞা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","এওঁলোকেই নিজৰ পিতৃ-বংশৰ প্রধান লোক আছিল: ইস্ৰায়েলৰ জ্যেষ্ঠ পুত্ৰ ৰূবেণ, আৰু ৰূবেণৰ পুত্র হনোক, পল্লু, হিষ্রোণ, আৰু কৰ্ম্মী। এওঁলোক আছিল ৰূবেণ গোষ্ঠীৰ পূৰ্বপুৰুষ। ");
INSERT INTO asmfb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","চিমিয়োনৰ পুত্র সকল আছিল যিমূৱেল, যামীন, ওহদ, যাখীন, চোহৰ আৰু চৌল। চৌল কনানীয়া মহিলাৰ পুত্র আছিল। এওঁলোক আছিল চিমিয়োন গোষ্ঠীৰ পূৰ্বপুৰুষ। ");
INSERT INTO asmfb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","লেবীৰ পুত্র সকলৰ সৈতে তেওঁলোকৰ বংশধৰ নাম এই তালিকাত উল্লেখিত আছে। তেওঁলোকৰ নাম হ’ল: গেৰ্চোন, কহাৎ, আৰু মৰাৰী। লেবী এশ সাতত্ৰিশ বছৰ বয়সলৈকে জীয়াই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","গেৰ্চোনৰ পুত্ৰ লিবনী আৰু চিমিয়ী আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","কহাতৰ পুত্র সকল হ’ল অম্ৰম, যিচহৰ, হিব্ৰোণ, আৰু উজ্জীয়েল। কহাত এশ তেত্ৰিশ বছৰ বয়সলৈকে জীয়াই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","মৰাৰীৰ পুত্র সকল হ’ল মহলী আৰু মুচী। এওঁলোক বংশধৰ সকলৰ সৈতে লেবী গোষ্ঠীৰ পূৰ্বপুৰুষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","অম্ৰমে তেওঁৰ পিতৃৰ ভনীয়েক যোকেবদক বিয়া কৰাইছিল। তেওঁ হাৰোণ আৰু মোচিক জন্ম দিছিল। অম্ৰম এশ সাতত্ৰিশ বছৰ জীয়াই আছিল আৰু তাৰ পাছত তেওঁৰ মৃত্যু হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","যিচহৰৰ পুত্র সকল আছিল কোৰহ, নেফগ, আৰু জিখ্ৰী। ");
INSERT INTO asmfb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","উজ্জীয়েলৰ পুত্র সকল আছিল মিচায়েল, ইলিচাফন, আৰু চিথ্ৰী। ");
INSERT INTO asmfb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","হাৰোণে অম্মীনাদবৰ জীয়েক নহচোনৰ ভনীয়েক ইলীচেবাক বিয়া কৰিছিল। তেওঁ নাদব, অবীহূ, ইলিয়াজৰ, আৰু ঈথামৰক, জন্ম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","কোৰহৰ পুত্র সকল আছিল অচীৰ, ইলকানা, আৰু অবীয়াচক। এওঁলোক কোৰহীয়া গোষ্ঠীৰ পূৰ্বপুৰুষ। ");
INSERT INTO asmfb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","হাৰোণৰ পুত্ৰ ইলিয়াজৰে পুটীয়েলৰ এজনী জীয়েকক বিয়া কৰিলে। তেওঁ পীনহচক জন্ম দিলে। এওঁলোকেই লেবীয়া সকলৰ বংশৰ সৈতে পিতৃবংশৰো প্রধান লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","এই দুজন পুৰুষ হাৰোণ আৰু মোচিক যিহোৱাই কৈছিল, “তোমালোকে ইস্ৰায়েলৰ লোকসকলক তেওঁলোকৰ যুদ্ধাৰু দলৰ সৈতে মিচৰ দেশৰ পৰা উলিয়াই আনাগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","মিচৰ দেশৰ পৰা ইস্ৰায়েলী লোকসকলক উলিয়াই আনিবৰ বাবে মিচৰৰ ৰজা ফৰৌণক কোৱা লোক সকল মোচি আৰু হাৰোণেই হয়। ");
INSERT INTO asmfb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","মিচৰ দেশত যেতিয়া যিহোৱাই মোচিৰ সৈতে কথা পাতিছিল, ");
INSERT INTO asmfb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","তেতিয়া যিহোৱাই মোচিক কৈছিল, “মই যিহোৱা; মই তোমাক যি যি কথা কলোঁ, সেই সকলো কথা তুমি মিচৰৰ ৰজা ফৰৌণৰ আগত গৈ কবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","কিন্তু মোচিয়ে যিহোৱাক কৈছিল, “মই কথা কোৱাত পাৰ্গত নহয়, সেয়ে ফৰৌণে মোৰ কথা কিয় শুনিব?” ");
INSERT INTO asmfb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","তেতিয়া যিহোৱাই মোচিক ক’লে, “চোৱা, ফৰৌণৰ আগত মই তোমাক ঈশ্বৰস্বৰূপ কৰিলোঁ; আৰু তোমাৰ ককায়েৰা হাৰোণ তোমাৰ ভাববাদী হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","মই তোমাক যি আজ্ঞা দিওঁ, সেই সকলোকে তুমি ক’বা; তাতে ফৰৌণে ইস্ৰায়েলী লোক সকলক নিজৰ দেশৰ পৰা যাবৰ বাবে এৰি দিবলৈ, তোমাৰ ককায়েৰ হাৰোণে সেই সকলো কথা ফৰৌণক ক’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","কিন্তু মই ফৰৌণৰ মন কঠিন কৰিম, আৰু মিচৰ দেশত মোৰ পৰাক্রমী চিন আৰু অদ্ভুত লক্ষণ দেখুৱাম। ");
INSERT INTO asmfb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","তথাপিও ফৰৌণে তোমালোকৰ কথা নুশুনিব। সেয়ে মই মিচৰৰ ওপৰত আঘাত কৰিম, আৰু মোৰ ইস্ৰায়েলী লোকসকল, যুদ্ধাৰু দল, ইস্রায়েলৰ বংশধৰ সকলক দণ্ডৰ পৰাক্রমী কাৰ্য কৰি মিচৰ দেশৰ পৰা উলিয়াই আনিম। ");
INSERT INTO asmfb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","মই মিচৰৰ ওপৰত মোৰ পৰাক্রমী হাত দিম, আৰু মিচৰ দেশৰ পৰা ইস্ৰায়েলী লোকসকলক উলিয়াই আনিম, তেতিয়া ময়েই যে যিহোৱা, সেই বিষয়ে মিচৰীয়া সকলে জানিব পাৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","মোচি আৰু হাৰোণে সেইদৰে কৰিলে; যিহোৱাই আজ্ঞা দিয়াৰ দৰেই তেওঁলোকে কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","তেওঁলোকে যেতিয়া ফৰৌণৰ লগত কথা পাতিছিল, তেতিয়া মোচিৰ আশী বছৰ আৰু হাৰোণৰ তিৰাশী বছৰ বয়স হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","যিহোৱাই মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“যেতিয়া ফৰৌণে তোমালোকক ক’ব, তোমালোকে কোনো এটা আচৰিত কাৰ্য কৰি দেখুউৱা, তেতিয়া তুমি হাৰোণক ক’বা যে, তোমাৰ লাখুটি সাপ হ’বৰ বাবে, লাখুটিডাল ফৌৰণৰ সন্মুখত পেলোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","তাৰ পাছত মোচি আৰু হাৰোণে ফৰৌণৰ ওচৰলৈ গ’ল, আৰু যিহোৱাই আজ্ঞা দিয়াৰ দৰেই কাৰ্য কৰিলে। হাৰোণে নিজৰ লাখুটি ফৰৌণ আৰু তেওঁৰ দাস সকলৰ সন্মুখত পেলাই দিলে; আৰু সেই লাখুটিডাল সাপ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","তেতিয়া ফৰৌণে তেওঁৰ জ্ঞানী আৰু মায়া-কৰ্ম জনা লোক সকলক মাতি পঠিয়ালে; তেতিয়া সেই মিচৰীয়া শাস্ত্ৰজ্ঞ সকলেও নিজৰ নিজৰ মায়াকৰ্মেৰে সেইদৰেই কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","তেওঁলোকৰ প্ৰতিজনে নিজৰ নিজৰ লাখুটি তলত পেলাই দিলে, আৰু সেইবোৰো সাপ হ’ল। কিন্তু হাৰোণৰ লাখুটিয়ে তেওঁলোকৰ সাপবোৰ গিলি পেলালে। ");
INSERT INTO asmfb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","তাৰ পাছত যিহোৱাই কোৱাৰ দৰেই, ফৰৌণৰ মন কঠিন হ’ল, আৰু তেওঁ তেওঁলোকৰ কথা নুশুনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","যিহোৱাই মোচিক ক’লে, “ফৰৌণৰ মন কঠিন হ’ল, আৰু তেওঁ লোকসকলক এৰি দিবলৈ অমান্তি হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ৰাতিপুৱা যেতিয়া ফৰৌণে পানীৰ ওচৰলৈ যায়, সেই সময়ত তুমি তেওঁৰ ওচৰলৈ যাবা। তুমি তেওঁৰে সৈতে সাক্ষাৎ কৰিবলৈ নদীৰ পাৰত থিয় হৈ থাকিবা; আৰু যি লাখুটিডাল সাপ হৈছিল, সেই লাখুটি ডালো তোমাৰ হাতত ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","তুমি তেওঁক ক’বা, ‘ইব্ৰীয়া সকলৰ ঈশ্বৰ যিহোৱাই আপোনাৰ ওচৰলৈ মোক ক’বলৈ পঠিয়াইছে, “মৰুভূমিত ঈশ্বৰৰ আৰধনা কৰিবৰ অৰ্থে ঈশ্বৰৰ লোক সকলক যাবলৈ দিয়ক। কিন্তু আপুনি এতিয়ালৈকে শুনা নাই।” ");
INSERT INTO asmfb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","যিহোৱাই এইদৰে কৈছে, “মই যে যিহোৱা, তাক তুমি ইয়াৰ দ্বাৰাই জানিবা।” মই নিজৰ হাতত থকা লাখুটিৰে নীল নদীৰ পানীত প্ৰহাৰ কৰিম, তাতে নদীৰ পানী তেজলৈ পৰিণত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","তেতিয়া নদীত থকা মাছবোৰ মৰিব, আৰু নদী দুৰ্গন্ধময় হ’ব। দুৰ্গন্ধময় পানী হোৱাৰ বাবে মিচৰীয়া সকলে নদীৰ পানী খাব নোৱাৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “হাৰোণক এই কথা কোৱা, ‘তুমি তোমাৰ লাখুটিডাল হাতত লৈ মিচৰ দেশৰ সকলো পানী যেনে নদী, খাল, বিল, আৰু সকলো পুখুৰীবোৰত লাখুটিডালেৰে প্রহাৰ কৰা; যাতে সেই সকলো পানী তেজলৈ ৰূপান্তৰিত হয়। এইদৰে কৰা যাতে গোটেই মিচৰ দেশত এনেকি তেওঁলোকৰ কাঠ আৰু শিলৰ পাত্ৰতো পানী তেজলৈ ৰূপান্তৰিত হয়।” ");
INSERT INTO asmfb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","তেতিয়া মোচি আৰু হাৰোণে যিহোৱাই আজ্ঞা দিয়াৰ দৰেই সেই কাৰ্য কৰিলে। হাৰোণে ফৰৌণ আৰু তেওঁৰ দাস সকলৰ সন্মুখত নদীৰ পানীত লাখুটি দাঙি প্ৰহাৰ কৰিলে; তেতিয়া নদীৰ সকলো পানী তেজ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","নদীৰ মাছবোৰ মৰিল, আৰু নদী দুৰ্গন্ধময় হ’ল। মিচৰীয়া লোক সকলে নদীৰ পানী খাব নোৱাৰিলে; আৰু সেই তেজ মিচৰ দেশৰ সকলো ঠাইতে হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","কিন্তু মিচৰীয়া শাস্ত্ৰজ্ঞসকলেও নিজৰ নিজৰ মায়াকৰ্মেৰে সেইদৰেই কৰিলে। সেয়ে যিহোৱাই কোৱাৰ দৰে ফৰৌণৰ মন কঠিন হ’ল, আৰু তেওঁ তেওঁলোকৰ কথা শুনিবলৈ অমান্তি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","তাৰ পাছত ফৰৌণে সেই আচৰিত কাৰ্যলৈ মনযোগ নিদি, নিজৰ ঘৰলৈ উভটি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","সকলো মিচৰীয়া লোকে খোৱা পানীৰ বাবে নদীৰ চাৰিওফালে গাত খানিলে; কিন্তু সেই পানীও নদীৰ পানী দৰে হোৱা বাবে তেওঁলোকে খাব নোৱাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","যিহোৱাই নদী প্ৰহাৰ কৰা সাত দিন পূৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “তুমি ফৰৌণৰ ওচৰলৈ গৈ তেওঁক কোৱা যে, ‘যিহোৱাই এইদৰে কৈছে: মোৰ আৰধনা কৰিবৰ অৰ্থে মোৰ লোকসকলক যাবলৈ দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","তুমি যদি তেওঁলোকক যাবলৈ দিয়াত অমান্তি হোৱা, তেনেহ’লে মই তোমাৰ দেশৰ সকলো ঠাইত ভেকুলীৰে উপদ্ৰৱ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","নদী ভেকুলীৰে পৰিপূৰ্ণ হ’ব; সেইবোৰ উঠি তোমাৰ ঘৰত, শোৱা কোঁঠালিত, বিচনাত, আৰু তোমাৰ দাসসকলৰ ঘৰতো সোমাব। এনেকি তোমাৰ লোকসকলৰ গাৰ ওপৰত উঠিব, তোমাৰ তন্দুৰ আৰু তোমাৰ আটা খচা পাত্ৰতো সোমাব। ");
INSERT INTO asmfb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ভেকুলীয়ে তোমাক, তোমাৰ লোকসকলক, আৰু তোমাৰ দাসসকলক আক্রমণ কৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","যিহোৱাই মোচিক ক’লে, “তুমি হাৰোণক কোৱা, ‘নদী, নিজৰা আৰু বিলৰ ওপৰলৈ তুমি তোমাৰ হাত দাঙি লাখুটিৰে প্রহাৰ কৰি মিচৰ দেশৰ ওপৰলৈ ভেকুলীবোৰ তুলি আনা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","তেতিয়া হাৰোণে মিচৰ দেশৰ সকলো পানীৰ ওপৰত নিজৰ হাত মেলিলে, আৰু ভেকুলীবোৰ উঠি আহি, গোটেই মিচৰ দেশখনক চানি ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","কিন্তু শাস্ত্ৰজ্ঞসকলেও নিজৰ নিজৰ মায়াকৰ্মেৰে সেইদৰেই কৰিলে, আৰু মিচৰ দেশৰ ওপৰলৈ ভেকুলীবোৰ তুলি আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","তেতিয়া ফৰৌণে মোচি আৰু হাৰোণক মাতি ক’লে, “যিহোৱাই যেন মোৰ আৰু মোৰ লোকসকলৰ পৰা ভেকুলীবোৰ আঁতৰাই নিয়ে, তাৰ বাবে তেওঁৰ আগত প্ৰাৰ্থনা কৰক। তাৰ পাছত মই যিহোৱাৰ উদ্দেশ্যে বলিদান কৰিবলৈ ইস্রায়েলী লোকসকলক যাবলৈ দিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","তেতিয়া মোচিয়ে ফৰৌণক ক’লে, “ভেকুলীবোৰ আপোনাৰ দাস আৰু আপোনাৰ ঘৰবোৰৰ পৰা নাইকিয়া হৈ কেৱল যেন নদীতহে থাকে, সেইবাবে আপোনাৰ লোকসকলৰ অৰ্থে প্রাৰ্থনা কৰি ক’বৰ বাবে আপুনি নিৰূপিত সময়ৰ সুযোগ পাইছে।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","তেতিয়া ফৰৌণে তেওঁক ক’লে, “কাইলৈ।” মোচিয়ে তেওঁৰ কথা শুনি ক’লে, “আমাৰ ঈশ্বৰ যিহোৱাৰ তুল্য কোনো নাই, ইয়াক যেন আপুনি জানিব পাৰে, সেই বাবে আপুনি কোৱাৰ দৰেই হওক। ");
INSERT INTO asmfb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ভেকুলীবোৰ আপোনাৰ, আপোনাৰ ঘৰ, দাস, আৰু লোকসকলৰ পৰাও গুচি যাব। সেইবোৰ কেৱল নদীতহে থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","মোচি আৰু হাৰোণ ৰজা ফৰৌণৰ সন্মুখৰ পৰা আঁতৰি গ’ল। পাছত ফৰৌণৰ বিৰুদ্ধে যিহোৱাই অনা ভেকুলীবোৰৰ কাৰণে মোচিয়ে যিহোৱাৰ আগত কাতৰোক্তি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","তাতে যিহোৱাই মোচিৰ নিবেদন শুনিলে; আৰু ঘৰ, চোতাল, আৰু পথাৰবোৰত ভেকুলীবোৰ মৰিল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","তেতিয়া লোকসকলে সেইবোৰ গোটাই দ’ম দ’ম কৰিলে; আৰু গোটেই দেশ দুৰ্গন্ধময় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","কিন্তু ফৰৌণে ভেকুলীৰ উপদ্রৱৰ পৰা সকাহ পোৱা দেখি, যিহোৱাই কোৱাৰ দৰে, ফৰৌণে পুনৰ নিজৰ মন কঠিন কৰি মোচি আৰু হাৰোণৰ কথা নুশুনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","যিহোৱাই মোচিক ক’লে, “হাৰোণক কোৱা যে, ‘গোটেই মিচৰ দেশত পৃথিৱীৰ ধূলি ওকণী হ’বৰ বাবে তুমি নিজৰ লাখুটি দাঙি ধুলিত প্ৰহাৰ কৰা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","তেতিয়া তেওঁলোকে সেইদৰে কৰিলে; হাৰোণে নিজৰ লাখুটি লৈ, হাত দাঙি দেশৰ ধুলিত প্ৰহাৰ কৰিলে, আৰু মানুহ আৰু পশুবোৰতো ওকণী হ’ল। গোটেই মিচৰ দেশৰ ধুলিবোৰ ওকণী হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","শাস্ত্ৰজ্ঞসকলেও নিজৰ নিজৰ মায়াকৰ্মেৰে সেইদৰেই ওকণী উৎপন্ন কৰিবলৈ চেষ্টা কৰিছিল, কিন্তু তেওঁলোকে কৰিব নোৱাৰিলে। দেশত মানুহ আৰু পশুবোৰতো ওকণী হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","তেতিয়া শাস্ত্ৰজ্ঞসকলে ফৰৌণক ক’লে, “এই কৰ্ম, ঈশ্বৰৰ আঙুলিৰ দ্বাৰাই কৰা কৰ্ম।” কিন্তু যিহোৱাই কোৱাৰ দৰে, ফৰৌণৰ মন পুনৰ কঠিন হ’ল, সেয়ে তেওঁ তেওঁলোকৰ কথা শুনিবলৈ অমান্তি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","যিহোৱাই মোচিক ক’লে, “তুমি ৰাতিপুৱাতে উঠি গৈ ফৰৌণে পানীৰ ওচৰলৈ যোৱাৰ সময়ত তুমি তেওঁৰ সন্মুখত থিয় হৈ ক’বা, যিহোৱাই এইদৰে কৈছে: ‘মোৰ আৰধনা কৰিবৰ অৰ্থে মোৰ লোকসকলক যাব দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","কিন্তু যদি মোৰ লোকসকলক যাব নিদিয়া, তেনেহ’লে মই তোমাৰ, তোমাৰ দাসসকলৰ, লোকসকলৰ আৰু ঘৰবোৰৰ ভিতৰলৈকে জাকে জাকে ডাঁহ পঠাম; তেতিয়া মিচৰীয়াসকলৰ ঘৰ, এনেকি তেওঁলোকে বাস কৰা ভূমিও ডাঁহৰ জাকেৰে পৰিপূৰ্ণ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","কিন্তু সেই দিনা গোচন দেশত বাস কৰা মোৰ লোকসকলৰ বাবে মই বেলেগ ব্যৱস্থা কৰিম। সেয়ে গোচন দেশত কোনো ডাঁহৰ জাক নহ’ব। পৃথিৱীৰ মাজত ময়েই যে যিহোৱা, এই কথা জানিবৰ বাবে এই সকলো ঘটিব। ");
INSERT INTO asmfb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","এইদৰে মোৰ লোকসকলৰ, আৰু তোমাৰ লোকসকলৰ মাজত মই প্ৰভেদ জন্মাম। মোৰ পৰাক্রমৰ কাৰ্য কাইলৈ সম্পন্ন হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","যিহোৱাই সেইদৰেই কৰিলে। ফৰৌণ আৰু তেওঁৰ দাসসকলৰ ঘৰত জাকে জাকে ডাঁহবোৰ সোমাল। গোটেই মিচৰ দেশতে সেই ডাঁহৰ জাকৰ উৎপাতত ভূমি নষ্ট হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","তেতিয়া ফৰৌণে মোচি আৰু হাৰোণক মাতি আনি ক’লে, “তোমালোকে আমাৰ দেশতে তোমালোকৰ ঈশ্বৰৰ উদ্দেশ্যে বলিদান কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","মোচিয়ে ক’লে, “সেইদৰে কৰাটো আমাৰ বাবে উচিত নহয়; কাৰণ আমি আমাৰ ঈশ্বৰ যিহোৱাৰ উদ্দেশ্যে কৰা বলিদান মিচৰীয়াসকলৰ বাবে ঘৃণনীয়। সেয়ে মিচৰীয়াসকলৰ সাক্ষাতে তেওঁলোকৰ ঘৃণনীয় বলিদান কৰিলে তেওঁলোকে আমাক শিল দলিয়াই নামাৰিব নে? ");
INSERT INTO asmfb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","নহয়! আমাৰ ঈশ্বৰ যিহোৱাই আমাক আজ্ঞা দিয়াৰ দৰে, তেওঁৰ উদ্দেশ্যে বলিদান কৰিবৰ অৰ্থে, আমাক তিনিদিনৰ বাট মৰুভূমিৰ মাজেৰে যাবলৈ দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","তাৰ পাছত ফৰৌণে ক’লে, “মৰুভূমিত তোমালোকৰ ঈশ্বৰ যিহোৱাৰ উদ্দেশ্যে বলিদান কৰিবৰ অৰ্থে, মই তোমালোকক যাবলৈ অনুমতি দিছোঁ। কিন্তু তোমালোক বহুত দূৰলৈ নাযাবা। তোমালোকে মোৰ বাবে প্ৰাৰ্থনা কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","তেতিয়া মোচিয়ে ক’লে, “মই আপোনাৰ ওচৰৰ পৰা যোৱাৰ পাছতে যিহোৱাৰ আগত প্ৰাৰ্থনা কৰিম; যাতে ফৰৌণ, আৰু আপোনাৰ দাসসকল, আৰু লোকসকলক কাইলৈ ডাঁহৰ জাকবোৰে যেন এৰি গুচি যায়। কেৱল যিহোৱাৰ উদ্দেশ্যে বলিদান কৰিবৰ অৰ্থে ইস্রায়েলী লোকসকলক যাবলৈ দিয়াত আপুনি যেন পুনৰ প্ৰবঞ্চনা নকৰে।” ");
INSERT INTO asmfb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","তাৰ পাছত মোচিয়ে ফৰৌণৰ ওচৰৰ পৰা ওলাই গৈ, যিহোৱাৰ আগত প্ৰাৰ্থনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","তেতিয়া যিহোৱাই মোচিয়ে কোৱাৰ দৰে কৰিলে: তেওঁ ফৰৌণ, তেওঁৰ দাসসকল, আৰু লোকসকলৰ পৰা ডাঁহৰ জাকবোৰ আতৰাই পঠালে। তাতে এটিও অবশিষ্ট নাথাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","তথাপিও ফৰৌণে সেইবাৰো মন কঠিন কৰিলে, আৰু তেওঁ লোকসকলক যাবলৈ এৰি নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “তুমি ফৰৌণৰ ওচৰলৈ গৈ তেওঁক কোৱা, ইব্ৰীয়া লোকসকলৰ ঈশ্বৰ যিহোৱাই এইদৰে কৈছে, ‘মোৰ আৰধনা কৰিবৰ অৰ্থে মোৰ লোকসকলক যাবলৈ দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","কিন্তু এতিয়াও যদি তেওঁলোকক যাব দিয়াত অমান্তি হৈ তেওঁলোকক ধৰি ৰাখিব বিচাৰে, ");
INSERT INTO asmfb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","তেনেহ’লে আপোনাৰ পথাৰত থকা পশুবোৰ, যেনে ঘোঁৰা, গাধ, উট, গৰু, মেৰ-ছাগ, আৰু ছাগলী জাকবোৰৰ ওপৰত যিহোৱাই হাত দিব; আৰু ইয়াৰ দ্বাৰাই ভয়ানক মহামাৰী হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","কিন্তু যিহোৱাই ইস্ৰায়েলী লোকসকলৰ পশুবোৰ আৰু মিচৰীয়া লোকসকলৰ পশুবোৰৰ মাজত প্ৰভেদ কৰিব; তেতিয়া যিবোৰ পশু ইস্ৰায়েলী লোকসকলৰ নহয় সেইবোৰ মৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","যিহোৱাই সময় নিৰূপণ কৰি ক’লে, “কাইলৈ দেশত মই এই কাৰ্য কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","পাছদিনা যিহোৱাই সেই কাৰ্য কৰিলে। মিচৰৰ আটাইবোৰ পশু মৰিল; কিন্তু ইস্ৰায়েলী লোকসকলৰ পশুবোৰৰ এটাও নমৰিল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","তেতিয়া ফৰৌণে বিচাৰ কৰি দেখিলে যে, ইস্ৰায়েলী লোকসকলৰ এটাও পশু মৰা নাই। তথাপিও ফৰৌণৰ মন কঠিন হল, আৰু তেওঁ লোক সকলক যাবলৈ এৰি নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","তাৰ পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে, “তোমালোকে মুঠি ভৰাই অগ্নিকুণ্ডৰ পৰা ছাঁই লোৱা, কিন্তু মোচি, তুমি ফৰৌণে চাই থকা সময়ত সেই ছাঁই ওপৰ ফাললৈ ছটিয়াই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","তাতে, সেই ছাঁই গোটেই মিচৰ দেশখনতে মিহি ধূলি হৈ পৰিব। এই ধূলিৰ কাৰণে গোটেই মিচৰ দেশৰ মানুহ আৰু পশুবোৰৰ শৰীৰত অনেক ঘা আৰু ফোহাঁ উঠিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","সেয়ে তেওঁলোকে অগ্নিকুণ্ডৰ পৰা ছাঁই লৈ, ফৰৌণৰ আগত থিয় হ’ল। মোচিয়ে সেই ছাঁই ওপৰলৈ ছটিয়াই পঠিয়ালে, আৰু সেই ছাঁইৰ কাৰণে মানুহ আৰু পশুবোৰৰ শৰীৰত অনেক ঘা আৰু ফোঁহা উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","শাস্ত্ৰজ্ঞ সকলে সেই বিষম খহুৰ কাৰণে মোচিক বাধা দিব নোৱাৰিলে। কাৰণ সকলো শাস্ত্ৰজ্ঞ আৰু মিচৰীয়া লোকসকলৰ শৰীৰত সেই বিষম খহু ওলাইছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","তথাপি যিহোৱাই মোচিক কোৱাৰ দৰে, তেওঁ ফৰৌণৰ মন কঠিন কৰিলে, সেয়ে ফৰৌণে মোচি আৰু হাৰোণৰ কথা নুশুনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “তুমি ৰাতিপুৱাতে উঠি, ফৰৌণৰ আগত থিয় হৈ, তেওঁক কবা, ‘ইব্ৰীয়াসকলৰ ঈশ্বৰ যিহোৱাই এইদৰে কৈছে, “মোৰ সেৱা কৰিবৰ অৰ্থে মোৰ লোকসকলক যাবলৈ দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","কিয়নো গোটেই পৃথিৱীত মোৰ তুল্য যে কোনো নাই, ইয়াক আপুনি জানিবৰ বাবে, মই এইবাৰ তোমাৰ, তোমাৰ দাস আৰু তোমাৰ লোকসকলৰ ওপৰলৈ মোৰ সকলো মহামাৰী পঠিয়াম।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","মই এতিয়ালৈকে তোমাৰ ওপৰত হাত দি, তোমাক আৰু তোমাৰ লোকসকলক মহামাৰীৰে প্ৰহাৰ কৰা হ’লে, তোমালোকে পৃথিৱীৰ পৰা উচ্ছন্ন হ’লাহেঁতেন। ");
INSERT INTO asmfb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","অৱশ্যে তোমাক মোৰ শক্তি দেখুৱাবলৈ আৰু গোটেই পৃথিৱীত মোৰ নাম যেন খ্যাতিমন্ত হয়, সেই কাৰণে মই তোমাক জীয়াই থাকিব দিছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","এতিয়ালৈকে তুমি গৰ্ব কৰি, মোৰ লোকসকলক এৰি দিবলৈ সন্মত হোৱা নাই। ");
INSERT INTO asmfb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","শুনা, মিচৰ দেশ স্থাপন হোৱা দিনেৰে পৰা আজিলৈকে যি ধৰণে শিলাবৃষ্টি হোৱা নাই, মই কাইলৈ এনে সময়তে প্রচণ্ড শিলাবৃষ্টি বৰষাম। ");
INSERT INTO asmfb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","সেয়ে তুমি এতিয়া মানুহ পঠিয়াই পথাৰত থকা তোমাৰ পশু আৰু যি সকলো আছে, সেই সকলো গোটাই নিৰাপদ স্থানত ৰাখা। যিবোৰ মানুহ আৰু পশু ঘৰলৈ ননাকৈ পথাৰত থাকিব, সেইবোৰৰ ওপৰত শিলাবৃষ্টি হোৱাত, সেইবিলাক মৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","তেতিয়া ফৰৌণৰ যি সকল দাসে যিহোৱাৰ বাক্য বিশ্বাস কৰিছিল, তেওঁলোকে নিজৰ বন্দী আৰু পশুবোৰক বেগাই ঘৰলৈ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","কিন্তু যি সকল লোকে যিহোৱাৰ বাক্য গুৰুত্বৰ ভাবে লোৱা নাছিল, তেওঁলোকে নিজৰ বন্দী আৰু পশুবোৰক পথাৰতে থাকিব দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “গোটেই মিচৰ দেশৰ মানুহ, পশু, আৰু পথাৰত থকা সকলো গছ-গছনিৰ ওপৰত শিলাবৃষ্টি হবলৈ তুমি আকাশৰ ফাললৈ চাই তোমাৰ হাত মেলা।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","মোচিয়ে আকাশলৈ চাই নিজৰ লাখুটি দাঙিলে। তেতিয়া যিহোৱাই গোটেই মিচৰ দেশত মেঘ-গৰ্জ্জন কৰি বিজুলী আৰু শিলাবৃষ্টি বৰষালে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","এইদৰে শিলাবৃষ্টি আৰু বিজুলী মিহলি হৈ ভয়ঙ্কৰ ৰূপ ল’লে। এনে শিলাবৃষ্টি মিচৰ দেশ স্থাপন হোৱা দিনৰে পৰা কেতিয়াও হোৱা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","গোটেই মিচৰ দেশৰ পথাৰত থকা মানুহ আৰু পশু সকলোকে শিলাবৃষ্টিয়ে বিনষ্ট কৰিলে। শিলাবৃষ্টিয়ে পথাৰৰ সকলো গছ-গছনি আৰু দেশৰ সকলো গছ ভাঙিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","কেৱল ইস্ৰায়েলী লোকসকল বাস কৰা গোচন দেশতহে শিলাবৃষ্টি হোৱা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","তেতিয়া ফৰৌণে মানুহ পঠিয়াই মোচি আৰু হাৰোণক মাতি অনালে। ফৰৌণে তেওঁলোকক ক’লে, “মই এইবাৰ পাপ কৰিলোঁ। যিহোৱা ন্যায়পৰায়ণ, কিন্তু মই আৰু মোৰ লোক সকল হ’লে দুৰ্নীতিপৰায়ণ। ");
INSERT INTO asmfb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","মহা-গৰ্জ্জন আৰু শিলাবৃষ্টি সহিব নোৱাৰাকৈ অধিক হৈছে, সেয়ে তোমালোকে যিহোৱাৰ আগত প্ৰাৰ্থনা কৰা। মই তোমালোকক যাবলৈ দিম; তোমালোক আৰু ইয়াত থাকিব নালাগে।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","মোচিয়ে তেওঁক ক’লে, “নগৰ ত্যাগ কৰাৰ পাছতেই মই যিহোৱালৈ হাত মেলি প্রাৰ্থনা কৰিম। তেতিয়া পৃথিৱী যে যিহোৱাৰহে হয়, এই কথা আপুনি জানিবলৈ মেঘ-গৰ্জ্জন বন্ধ হ’ব, আৰু শিলাবৃষ্টিও নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","কিন্তু আপুনি আৰু আপোনাৰ দাসসকলে যে এতিয়াও ঈশ্বৰ যিহোৱাক প্রকৃততে সন্মান কৰা নাই, সেই কথা মই জানো।” ");
INSERT INTO asmfb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","সেই সময়ত শণ সূতাৰ ফুলবোৰ আৰু যৱ ধান নষ্ট হৈছিল; কাৰণ যৱ ধানৰ থোক পুৰঠ হৈছিল, আৰু শণ সূতাৰ ফুলবোৰ ফুলিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","কিন্তু ঘেঁহু আৰু সৰিয়হ নষ্ট নহ’ল কাৰণ সেইবোৰ ইয়াৰ পাছত হোৱা শস্য। ");
INSERT INTO asmfb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","মোচিয়ে যেতিয়া ফৰৌণ আৰু তেওঁৰ নগৰ ত্যাগ কৰি যোৱাৰ পাছত যিহোৱালৈ হাত মেলি প্রাৰ্থনা কৰিলে, তেতিয়া মেঘ-গৰ্জ্জন আৰু শিলাবৃষ্টি হ’বলৈ বন্ধ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ফৰৌণে যেতিয়া বৰষুণ, শিলাবৃষ্টি, আৰু মেঘ-গৰ্জ্জন বন্ধ হোৱা দেখিলে, তেতিয়া তেওঁ আৰু তেওঁৰ দাসসকলে নিজৰ মন পুনৰ কঠিন কৰি পাপ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","এইদৰে যিহোৱাই মোচিক কোৱাৰ দৰে, ফৰৌণৰ মন কঠিন হ’ল, আৰু তেওঁ ইস্ৰায়েলী লোকসকলক যাবলৈ এৰি নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","যিহোৱাই মোচিক ক’লে, “তুমি ফৰৌণৰ ওচৰলৈ যোৱা। মিচৰ দেশত মোৰ শক্তিৰ চিনবোৰ দেখুৱাবৰ বাবে মই ফৰৌণ আৰু তেওঁৰ দাস সকলৰ মন কঠিন কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","মই এইদৰে কৰাৰ কাৰণ এয়াও হয় যে, মই মিচৰীয়া লোক সকলক কিদৰে কঠোৰ ব্যৱহাৰ কৰিলোঁ, আৰু তেওঁলোকৰ মাজত মোৰ শক্তিৰ চিন কিদৰে দেখুৱালোঁ এই সকলো কথা তুমি তোমাৰ সন্তান আৰু নাতি-নাতিনীয়েক সকলক যাতে ক’ব পাৰিবা। ইয়াৰ যোগেদি তোমালোকে জানিবা যে, মই যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","তেতিয়া মোচি আৰু হাৰোণ ফৰৌণৰ ওচৰলৈ গ’ল, আৰু তেওঁক ক’লে, “ইব্ৰীয়া সকলৰ ঈশ্বৰ যিহোৱাই এইদৰে কৈছে: ‘তুমি মোৰ আগত নম্ৰ হবলৈ কিমান সময়লৈকে অমান্তি হৈ থাকিবা? মোৰ আৰাধনা কৰিবৰ অৰ্থে মোৰ লোক সকলক যাবলৈ এৰি দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","কিন্তু তুমি যদি মোৰ লোক সকলক যাবলৈ দিয়াত অমান্তি হোৱা, তেনেহ’লে শুনা, কাইলৈ তোমাৰ দেশলৈ মই কাকতী ফৰিং আনিম। ");
INSERT INTO asmfb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","সেইবোৰে গোটেই দেশখন এনেকৈ ঢাকি ধৰিব যে, কোনো এজনে মাটিও দেখা নাপাব। শিলাবৃষ্টিৰ পৰা ৰক্ষা পোৱা অৱশিষ্ট গছবোৰ সেইবোৰে খাই পেলাব। আনকি আপোনালোকৰ বাবে পথাৰত উৎপন্ন হোৱা সকলো গছো খাই পেলাব ");
INSERT INTO asmfb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","আপোনাৰ ঘৰ, আৰু আপোনাৰ দাস সকলৰ ঘৰত, আৰু সকলো মিচৰীয়াৰে সকলৰ ঘৰবোৰ সেই কাকতী ফৰিঙেৰে ভৰি পৰিব। ইমান ফৰিং হ’ব যে, আপোনাৰ পিতৃ আৰু আপোনাৰ ওপৰ-পিতৃসকলে কেতিয়াও তেনে ফৰিং দেখা নাই।” তাৰ পাছত মোচি ফৰৌণৰ আগৰ পৰা বাহিৰলৈ ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","তেতিয়া ফৰৌণৰ দাস সকলে ফৰৌণক ক’লে, “এই মানুহ জন আমালৈ কিমান দিনলৈকে ফান্দস্বৰূপ হৈ থাকিব? ইস্রায়েলী লোকসকল নিজৰ ঈশ্বৰ যিহোৱাৰ আৰাধনা কৰিবৰ অৰ্থে যাবলৈ এৰি দিয়ক। মিচৰ দেশখন যে ধ্বংস হ’ল, এতিয়ালৈকে সেই কথা আপুনি উপলব্ধি কৰা নাই নে?” ");
INSERT INTO asmfb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","তেতিয়া মোচি আৰু হাৰোণক ফৰৌণৰ আগলৈ পুনৰ মাতি অনা হ’ল, ফৰৌণে তেওঁলোকক ক’লে, “যোৱা, তোমালোকৰ ঈশ্বৰ যিহোৱাৰ আৰাধনা কৰা; কিন্তু কোনবোৰ লোক যাব?” ");
INSERT INTO asmfb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","মোচিয়ে ক’লে, “আমি আমাৰ ডেকা, বুঢ়া, নিজৰ নিজৰ লৰা-ছোৱালী, আৰু মেৰ-ছাগ, ছাগলী, গৰুৰ জাকবোৰকো লগত লৈ যাম। কাৰণ যিহোৱাৰ উদ্দেশ্যে আমি উৎসৱ পালন কৰিব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ফৰৌণে তেওঁলোকক ক’লে, “যিহোৱা তোমালোকৰ লগত থাকক; যিহেতু মই তোমালোকক সন্তানসকলৰ সৈতে যাবলৈ এৰি দিছোঁ, আৰু চোৱা, তোমালোকৰ মন কিছু দুষ্টতাৰে পৰিপূৰ্ণ। ");
INSERT INTO asmfb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","সেয়ে নহব; কেৱল তোমালোকৰ মাজৰ পুৰুষসকল যাওক, আৰু যিহোৱাৰ সেৱা কৰক; কিয়নো এইদৰে কৰাটোৱেই তোমালোকে বিচাৰিছে।” পাছত ফৰৌণৰ আগৰ পৰা মোচি আৰু হাৰোনক পঠিয়াই দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “কাকতী ফৰিংবোৰ মিচৰ দেশলৈ আহি, শিলাবৃষ্টিৰ পৰা অৱশিষ্ট থকা তৃণ আদি সকলোকে খাবলৈ তুমি কাকতী ফৰিঙৰ বাবে মিচৰ দেশৰ ওপৰলৈ হাত মেলা।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","তেতিয়া মোচিয়ে মিচৰ দেশৰ ওপৰলৈ নিজৰ লাখুটি দাঙিলে, আৰু যিহোৱাই সেই দিনা দিনে ৰাতিয়ে সেই দেশৰ ওপৰত পূব ফালৰ পৰা বায়ু বোৱালে। যেতিয়া ৰাতিপুৱা হ’ল, তেতিয়া পূব ফালৰ পৰা অহা বতাহে কাকতি ফৰিংবোৰ উৰোৱাই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","তাতে ফৰিংবোৰ সমগ্র মিচৰ দেশলৈ আহিল, আৰু মিচৰৰ আটাই অঞ্চলত উপদ্রৱ কৰিলে। ইমান বেছি ফৰিং পূৰ্বতে কেতিয়াও হোৱা নাই, আৰু পুনৰ কেতিয়াও নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","সেই ফৰিংবোৰে সমগ্র দেশ ছানি ধৰিলে, তাতে দেশখন অন্ধকাৰময় হ’ল। সেই ফৰিংবোৰে দেশৰ সকলো গছ-গছনি আৰু শিলাবৃষ্টিৰ পৰা অবশিষ্ট থকা গছৰ সকলো ফলবোৰ খালে। তাতে সমগ্র মিচৰ দেশত এজোপাও সেউজীয়া গছ জীয়াই নাথাকিল, আৰু পথাৰত এজোপাও গছ-গছনি নাথাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","তেতিয়া ফৰৌণে মোচি আৰু হাৰোণক বেগাই মাতি আনি কলে, “মই তোমালোকৰ ঈশ্বৰ যিহোৱা আৰু তোমালোকৰ বিৰুদ্ধে পাপ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","এতেকে বিনয় কৰোঁ, এইবাৰৰ বাবে মোৰ পাপ ক্ষমা কৰা, আৰু তোমালোকৰ ঈশ্বৰ যিহোৱাৰ আগত প্রাৰ্থনা কৰা, যাতে তেওঁ মোৰ পৰা এই মৃত্যুদায়ক কষ্ট আঁতৰায়।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","তেতিয়া মোচিয়ে ফৰৌণৰ ওচৰৰ পৰা বাহিৰলৈ গ’ল; আৰু যিহোৱাৰ আগত প্ৰাৰ্থনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","যিহোৱাই পশ্চিম ফালৰ পৰা অতি প্ৰবল বতাহ বোৱাই আনিলে; তাতে সেই বতাহে ফৰিংবোৰ উৰোৱাই নি চূফ সাগৰত পেলাই দিলে। সমগ্র মিচৰ দেশৰ কোনো অঞ্চলতে এটাও ফৰিং অৱশিষ্ট নাথাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","কিন্তু যিহোৱাই ফৰৌণৰ মন কঠিন কৰিলে, তাতে তেওঁ ইস্ৰায়েলৰ লোকসকলক যাবলৈ নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “সমগ্র মিচৰ দেশ অন্ধকাৰময় হ’বলৈ, তুমি আকাশৰ ফাললৈ হাত মেলা; তাতে সেই আন্ধাৰে সমগ্র দেশ গ্রাস কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","তেতিয়া মোচিয়ে আকাশৰ ফাললৈ হাত মেলিলে, আৰু সমগ্র মিচৰ দেশ তিনি দিনলৈকে ঘোৰ অন্ধকাৰময় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","কোনেও ইজনে সিজনক দেখা নাপালে, আৰু তিনি দিনলৈকে কোনেও নিজৰ ঘৰৰ পৰা নোলাল। অৱশ্যে ইস্ৰায়েলী লোকসকল বাস কৰা ঠাইত পোহৰ হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","তেতিয়া ফৰৌণে মোচিক মাতি আনি ক’লে, “তোমালোক যোৱা, যিহোৱাৰ আৰধনা কৰা গৈ। এনেকি তোমালোকৰ পৰিয়াল বৰ্গও লগত যাব পাৰিব, কিন্তু তোমালোকৰ মেৰ-ছাগ, ছাগলী, আৰু গৰুৰ জাকবোৰ ইয়াতেই থাকিব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","কিন্তু মোচিয়ে ক’লে, “আমাৰ ঈশ্বৰ যিহোৱাৰ উদ্দেশ্যে বলিদান কৰিবলৈ আৰু হোম বলিৰ অৰ্থে আপুনি আমাৰ লগত জীৱ জন্তুবোৰো দিবই লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","আমাৰ লগত আমাৰ পশুবোৰো নিশ্চয় যাব; আমাৰ ঈশ্বৰ যিহোৱাৰ আৰধনা কৰিবলৈ আমাৰ পশুবোৰৰ এটা খুৰাও ইয়াত নাথাকিব। কাৰণ আমি কিহেৰে যিহোৱাৰ আৰাধনা কৰিম, সেই বিষয়ে আমি সেই ঠাই নোপোৱালৈকে নাজানো।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","কিন্তু যিহোৱাই ফৰৌণৰ মন কঠিন কৰিলে, তাতে তেওঁ তেওঁলোকক যাবলৈ নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","তেতিয়া ফৰৌণে মোচিক ক’লে, “মোৰ সন্মুখৰ পৰা গুচি যোৱা। এটা বিষয়ত সাৱধান হবা, মোৰ মুখ পুনৰ চাব নিবিচাৰিব; কিয়নো যি দিনাই মোৰ মুখ চাবা, সেই দিনাই তোমাৰ মৃত্যু হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","তেতিয়া মোচিয়ে ক’লে, “আপুনি নিজেই কৈছে; মই আপোনাৰ মুখ পুনৰ নাচাও।” ");
INSERT INTO asmfb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","যিহোৱাই মোচিক ক’লে, “মই ফৰৌণ আৰু মিচৰ দেশৰ ওপৰত আন এক মহামাৰি আনিম। তাৰ পাছত তেওঁ তোমালোকক ইয়াৰ পৰা যাবলৈ এৰি দিব। আৰু অৱশেষত তেওঁ যেতিয়া তোমালোকক যাবলৈ দিব, তেতিয়া তেওঁ তোমালোকৰ সকলোকে ইয়াৰ পৰা খেদি পঠিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","সেয়ে, প্ৰতিজন পুৰুষ আৰু মহিলাক নিজৰ নিজৰ ওচৰ-চুবুৰীয়াৰ পৰা তেওঁলোকৰ ৰূপ আৰু সোণৰ অলঙ্কাৰবোৰ খুজি ল’বলৈ নিৰ্দেশ দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","যিহোৱাই মিচৰীয়া লোকসকলক ইস্রায়েলী লোকসকললৈ অনুগ্ৰহ কৰিবলৈ আগ্রহী কৰালে। অৱশ্যে মিচৰ দেশত মোচি, ফৰৌণৰ দাস আৰু লোকসকলৰ দৃষ্টিত অতি আকৰ্ষণীয় পুৰুষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","মোচিয়ে ক’লে, “যিহোৱাই এই কথা কৈছে, ‘মই মাজ নিশামানত মিচৰ দেশৰ মাজেৰে যাম। ");
INSERT INTO asmfb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","তেতিয়া মিচৰ দেশৰ সকলো প্রথম পুত্রৰ মৃত্যু হ’ব। সিংহাসনত বহা ৰজা ফৰৌণৰ প্রথম পুত্ৰৰ পৰা জাঁত ঘৰুৱা দাসীৰ প্রথম পুত্রলৈকে, আৰু মিচৰ দেশত থকা সকলো প্ৰথমে জন্মা পশুবোৰৰো মৃত্যু হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","তেতিয়া সমগ্র মিচৰ দেশত এনে ক্ৰন্দন হ’ব যে, তেনে ক্রন্দন কেতিয়াও হোৱা নাছিল, আৰু পুনৰ কেতিয়াও নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","কিন্তু যিহোৱাই যে মিচৰীয়া আৰু ইস্ৰায়েলী লোকসকলৰ মাজত প্ৰভেদ কৰে, ইয়াক যেন আপোনালোকে জানিব পাৰে, সেই বাবে ইস্ৰায়েলী লোকসকল হওক বা তেওঁলোকৰ পশুৱেই হওক, তেওঁলোকৰ অহিতে এটা কুকুৰেও নুভুকিব।’ ");
INSERT INTO asmfb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ফৌৰণ, আপোনাৰ সকলো দাস সকল মোৰ ওচৰলৈ নামি আহি মোৰ আগত প্ৰণিপাত কৰিব। তেওঁলোকে ক’ব, ‘আপুনি আৰু আপোনাক অনুসৰণ কৰা লোকসকল ওলাই যাওক!’ তাৰ পাছতহে মই বাহিৰলৈ ওলাই যাম।” এই বুলি তেওঁ বৰ ক্ৰোধেৰে ফৰৌণৰ ওচৰৰ পৰা ওলাই আহিল। ");
INSERT INTO asmfb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","যিহোৱাই মোচিক কৈছিল, “মোৰ অদ্ভুত লক্ষণ যেন মিচৰ দেশত অধিককৈ দেখুউৱাব পাৰোঁ, সেই বাবে ফৰৌণে তোমাৰ কথা নুশুনিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","মোচি আৰু হাৰোণে ফৰৌণৰ সাক্ষাতে সেই সকলো অদ্ভুত লক্ষণ দেখুৱাইছিল। কিন্তু যিহোৱাই ফৰৌণৰ মন কঠিন কৰিছিল, সেই বাবে তেওঁ নিজৰ দেশৰ পৰা ইস্ৰায়েলী লোকসকলক যাবলৈ এৰি নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","যিহোৱাই মিচৰ দেশত মোচি আৰু হাৰোণৰ সৈতে কথা পাতিলে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“এই মাহেই তোমালোকৰ বাবে মাহৰ আৰম্ভণি হ’ব; আৰু এই মাহ তোমালোকৰ কাৰণে বছৰৰ প্ৰথম মাহ। ");
INSERT INTO asmfb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","তোমালোক সমবেত হোৱা আৰু ইস্ৰায়েলী লোকসকলক কোৱা, ‘এই মাহৰ দশম দিনা তেওঁলোক প্রত্যেকে নিজৰ বাবে এটাকৈ মেৰ-ছাগ পোৱালি বা ছাগলী পোৱালি ল’ব। প্রত্যেক পৰিয়ালে এইদৰে পৰিয়ালবৰ্গৰ বাবে এটা মেৰ-ছাগ পোৱালি ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","সেই মেৰ-ছাগ পোৱালি ভোজন কৰিবলৈ যদি পৰিয়ালৰ মানুহ তাকৰ হয়, তেনেহলে তেওঁ আৰু তেওঁৰ ওচৰ-চুবুৰীয়াৰ সদস্যৰ সংখ্যা অনুসাৰে এটা মেৰ-ছাগ পোৱালি বা ছাগলীৰ মাংস প্রত্যেক মানুহলৈ জোৰাকৈ লওক। প্রত্যেক মানুহে খাব পৰা শক্তি অনুসাৰে সেই মাংস যাতে হয়। ");
INSERT INTO asmfb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","তোমালোকৰ সেই মেৰ-ছাগ বা ছাগলী পোৱালি এবছৰীয়া আৰু নিৰ্ঘূণী মতা পোৱালি হ’ব লাগিব। তোমালোকে তাক মেৰ-ছাগ বা ছাগলীবোৰৰ জাকৰ মাজৰ পৰা ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","তোমালোকে এই মাহৰ চৌদ্ধ দিনলৈকে তাক ৰাখিবা; তাৰ পাছত সমবেত ইস্ৰায়েলী সকলো লোকে গধূলি পৰত তাক বধ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","তোমালোকে তাৰ কিছু তেজ লৈ, যি ঘৰবোৰত মাংস ভোজন কৰা হ’ব, সেই ঘৰবোৰৰ দুৱাৰৰ চৌকাঠৰ দুই দাঁতিত, আৰু ওপৰতো লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","সেই ৰাতিয়েই তোমালোকে প্রথমে জুইত খৰিকাত দি সেই মাংস খমীৰ নিদিয়া পিঠা আৰু তিতা শাকেৰে সৈতে ভোজন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","তোমালোকে তাক কেঁচাই, নাইবা পানীত সিজায়ো নাখাবা; তাৰ পৰিৱৰ্তে মুৰ, ঠেং, আৰু তাৰ ভিতৰত থকা অংশই সৈতে জুইত খৰিকাত দিহে খাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ৰাতিপুৱালৈ তাৰ অলপো অৱশিষ্ট নাৰাখিবা। কিন্তু ৰাতিপুৱালৈ যি অৱশিষ্ট থাকিব, তাক তোমালোকে জুইত পুৰি ভষ্ম কৰি দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","তোমালোকে টঙালিৰে কঁকাল বান্ধি, জোতা পিন্ধি, আৰু হাতত লাখুটি লৈ, বেগাবেগিকৈ তাক ভোজন কৰিবা। সেয়ে যিহোৱাৰ নিস্তাৰ-পৰ্ব্ব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","যিহোৱাই এই কথা কৈছে: ‘মই সেই ৰাতিয়েই মিচৰ দেশৰ মাজেদি গৈ, মিচৰ দেশত প্রথমে জন্ম হোৱা মানুহ বা পশুৱেই হওক, সকলোকে সংহাৰ কৰিম। মিচৰীয়াসকলৰ সকলো দেৱতাকে মই দণ্ড দিম। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","তোমালোকে যিবোৰ ঘৰত থাকা, সেইবোৰ ঘৰত সেই তেজেই তোমালোকৰ চিন হ’ব; মই যেতিয়া মিচৰ দেশ মই আক্রমণ কৰিম, তেতিয়া সেই তেজ দেখি, মই তোমালোকক অতিক্রম কৰি এৰি থৈ যাম। এই মহামাৰিয়ে তোমালোকক স্পৰ্শ নকৰিব আৰু তোমালোকক বিনষ্ট নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","এই দিন সোঁৱৰণীয় দিন হ’ব; আৰু তোমালোকে এই দিন যিহোৱাৰ বাবে উৎসৱৰ দিন বুলি নিশ্চয়কৈ পালন কৰিবা। এই দিন পালন কৰাটো তোমালোকৰ বাবে এটা বিধান হ’ব, পুৰুষানুক্ৰমে চিৰস্থায়ী বিধিমতে এই দিন তোমালোকে পালন কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","তোমালোকে সাত দিন খমীৰ নিদিয়া পিঠা ভোজন কৰিবা। প্ৰথম দিনাই তোমালোকে নিজৰ ঘৰৰ পৰা খমীৰ দূৰ কৰিবা। কিয়নো যি কোনোৱে প্ৰথম দিনৰ পৰা সপ্তম দিনলৈকে খমীৰ দিয়া পিঠা খাব, তেওঁক ইস্ৰায়েলৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","প্ৰথম দিনা লোক সকল সমবেত হৈ মোৰ উদ্দেশ্যে পবিত্রকৃত হ’ব, আৰু সপ্তম দিনাও সেই একেদৰে লোকসকল সমবেত হ’ব। সেই দিনবোৰত কোনো কাম কৰা নহব, কেৱল প্রত্যেকে খাব পৰাকৈ ৰন্ধা কাম কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","এইদৰে তোমালোকে খমীৰ নিদিয়া পিঠাৰ পৰ্ব্ব পালন কৰিবা; কিয়নো সেই দিনাই মই তোমালোকৰ লোক সকলক, সৈন্যৰ দলক মিচৰ দেশৰ পৰা বাহিৰ কৰি অনিছিলো। এতেকে তোমালোকে পুৰুষানুক্ৰমে চিৰস্থায়ী বিধিমতে সেই দিন পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","তোমালোকে বছৰৰ প্ৰথম মাহৰ চৌদ্ধ দিনৰ গধুলিৰে পৰা একৈশ দিনৰ গধুলিলৈকে খমীৰ নিদিয়া পিঠাহে ভোজন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","এই সাত দিনলৈকে তোমালোকৰ ঘৰবোৰত খমিৰ পোৱা নাযাব। কাৰণ বিদেশী হওক, বা স্বদেশীয়েই হওক, যি কোনোৱে খমিৰ দিয়া বস্তু খাব, তেওঁক ইস্ৰায়েলৰ সমাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","তোমালোকে খমিৰ দিয়া কোনো বস্তুৱেই নাখাবা। তোমালোকে যি ঠাইতে বাস কৰা সেই সকলো ঠাইত, খমীৰ নিদিয়া পিঠাহে খাবা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","তেতিয়া মোচিয়ে ইস্ৰায়েলৰ সকলো পৰিচাৰকক মাতি আনিলে আৰু তেওঁলোকক ক’লে, তোমালোকে নিজৰ নিজৰ পৰিয়ালৰ লোকক পৰ্যাপ্ত পৰিমাণে খোৱাবলৈ ভেৰাৰ জাকৰ পৰা পোৱালি বাছি লবা আৰু নিস্তাৰ-পৰ্ব্বৰ বলিৰ বাবে তাক কাটিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","তাৰ পাছত এচোব বন একোচা লৈ, পাত্ৰটোত থকা তেজত জুবুৰিয়াবা। সেই তেজ পাত্ৰৰ পৰা লৈ দুৱাৰৰ চৌকাঠৰ ওপৰত আৰু দুই দাঁতিৰ কাঠত লগাবা। ৰাতিপুৱালৈকে তোমালোকৰ কোনেও নিজৰ নিজৰ ঘৰৰ দুৱাৰৰ বাহিৰ নহবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","কিয়নো যিহোৱাই মিচৰীয়া সকলক আক্ৰমণ কৰিবৰ বাবে, তোমালোকৰ ওচৰেদি গমন কৰিব। যেতিয়া তেওঁ দুৱাৰৰ চৌকাঠৰ ওপৰত, আৰু চৌকাঠৰ দুই দাঁতিত সেই তেজ দেখিব, তেতিয়া যিহোৱাই সেই দুৱাৰ এৰি যাব, আৰু তোমালোকক আক্ৰমণ কৰিবৰ বাবে, আপোনালোকৰ ঘৰত আক্ৰমণকাৰীক সোমাবলৈ নিদিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","তোমালোকে আৰু তোমালোকৰ সন্তান সকলেও চিৰকাললৈকে পালন কৰিবলগীয়া বিধি বুলি, এই ৰীতি পালন কৰি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","যিহোৱাই নিজৰ প্ৰতিজ্ঞাৰ দৰে তোমালোকক যি দেশ দিব, সেই দেশত যেতিয়া তোমালোক সোমাবা, তেতিয়াও তোমালোকে এই উপসনাৰ কাৰ্য কৰি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","যেতিয়া তোমালোকৰ সন্তান সকলে সুধিব “এই উপসনাৰ অৰ্থ কি,” ");
INSERT INTO asmfb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","তেতিয়া তোমালোকে ক’বা, ‘যিহোৱাই মিচৰীয়ালোকক আক্ৰমণ কৰোঁতে মিচৰত থকা ইস্ৰায়েলৰ লোকসকলৰ ঘৰবোৰ এৰি থৈ গৈছিল, এই দৰেই তেওঁ ইস্ৰায়েলৰ ঘৰবোৰ নিস্তাৰ কৰিছিল, সেইয়ে যিহোৱাৰ উদ্দেশে কৰা এয়ে নিস্তাৰ-পৰ্ব্বৰ বলিদান’।” তেতিয়া লোকসকলে মূৰ দোঁৱাই যিহোৱাৰ আৰাধনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ইস্ৰায়েলৰ লোকসকলে সেয়ে যিহোৱাই মোচি আৰু হাৰোণক দিয়া আজ্ঞাৰ দৰেই কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","মাজ নিশা সিংহাসনত বহা ফৰৌণৰ জেষ্ঠ পুত্ৰৰ পৰা বন্দীশালত থকা লোকৰ বৰ পুত্ৰলৈকে মিচৰ দেশত প্ৰথমে জন্মা সকলোলোক আৰু পশুবোৰৰ প্ৰথমে জন্মাবোৰকো আক্ৰমণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","সেয়ে ফৰৌণ, তেওঁৰ দাসবোৰ আৰু মিচৰৰ সকলোলোক ৰাতিয়েই উঠিল। মিচৰত সেয়ে মহাক্ৰন্দন হ’ল; কাৰণ এনে এটা ঘৰ নাছিল য’ত প্ৰথমা জন্মা পুএৰ মৃত্যু হোৱা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ৰাতিয়েই ফৰৌণে মোচি আৰু হাৰোণক মাতি আনি ক’লে, “উঠা, তোমালোক আৰু ইস্ৰায়েলৰ সকলো লোক মোৰ প্ৰজাসকলৰ মাজৰ পৰা বাহিৰ হৈ যোৱা। তোমালোকে কোৱাৰ দৰেই যিহোৱাৰ আৰধনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","তোমালোকে কোৱাৰ দৰেই নিজৰ নিজৰ ভেৰা, ছাগলী, আৰু তোমালোকৰ জাকবোৰকো লৈ যোৱা; আৰু মোকো আশীৰ্ব্বাদ কৰি যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","তেতিয়া মিচৰীয়া লোকসকলে শীঘ্ৰে ইস্ৰায়েলী লোকসকলক দেশৰ পৰা পঠাবৰ বাবে ততাতৈয়া লগালে; কাৰণ তেওঁলোকে ক’লে, “আমি সকলো মৃত লোক।” ");
INSERT INTO asmfb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","সেয়ে লোকসকলে খমীৰ নিদিয়াকৈ নিজৰ নিজৰ আটাগুড়ি ল’লে। তেওঁলোকে নিজৰ নিজৰ সনা পাত্ৰ গাৰ কাপোৰত বান্ধিলৈ, নিজৰ নিজৰ কান্ধত ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","তাৰ পাছত ইস্ৰায়েলৰ লোকসকলে মোচিয়ে কোৱাৰ দৰেই কৰিলে। তেওঁলোকে মিচৰীয়া লোকসকলৰ পৰা সোণ আৰু ৰূপৰ অলঙ্কাৰ, আৰু বস্ত্ৰও খুজি ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","যিহোৱাই মিচৰীয়া লোকসকলৰ আগত ইস্ৰায়েলী লোকসকলক অনুগ্ৰহপ্ৰাপ্ত কৰিলে। সেয়ে তেওঁলোকে খোজাৰ দৰেই তেওঁলোকক দিলে; এইদৰে তেওঁলোকে মিচৰীয়ালোক সকলক লুট কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ইস্ৰায়েলী লোকসকল ৰামিচেচৰ পৰা চুক্কোতলৈ যাত্ৰা কৰি গ’ল। মহিলা আৰু সন্তানৰ ওপৰিও তেওঁলোকৰ ছয় লাখমান পদাতিক পুৰুষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ইয়াৰ উপৰিও অনা ইস্ৰায়েলী বহুলোক,তেওঁলোকৰ ভেৰা, ছাগলী আদি কৰি বহুতো পশুৰে সৈতে তেওঁলোকৰ লগত গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","তাৰ পাছত, তেওঁলোকে মিচৰৰ পৰা অনা খমীৰ নিদিয়া আটাগুড়িৰে পিঠা যুগুত কৰিলে। সেইবোৰত খমীৰ দিয়া নাছিল, কাৰণ তেওঁলোকক মিচৰৰ পৰা খেদাই দিয়া হ’ল, সেয়ে খোৱা যুগুত কৰিবৰ কাৰণে তেওঁলোকে পলম কৰিব নোৱাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ইস্ৰায়েলী লোকসকল মিচৰ দেশত প্ৰবাসী হৈ চাৰিশ ত্ৰিশ বছৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","চাৰিশ ত্ৰিশ বছৰৰ শেষৰ দিনা, যিহোৱাৰ বাহিনীৰ সকলো দল মিচৰ দেশৰ পৰা বাহিৰ হৈ আহিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","যিহোৱাই মিচৰ দেশৰ পৰা তেওঁলোকক বাহিৰ কৰি অনাৰ কাৰণে, সেই ৰাতি তেওঁলোক সজাগ হৈ আছিল। সেই ৰাতি যিহোৱাৰ উদ্দেশে পালন কৰা ৰাতি বুলি ইস্ৰায়েলৰ সকলো লোকে পুৰুষানুক্ৰমে পালন কৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","যিহোৱাই মোচি আৰু হাৰোণক ক’লে, “নিস্তাৰ-পৰ্ব্বৰ বলিৰ বিধি এই: কোনো বিদেশী লোকে ইয়াক ভোজন কৰিব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","অৱশ্যে ইস্ৰায়েলী লোকৰ প্ৰতিজন ধন দি কিনা বন্দীক যদি চুন্নৎ কৰা হৈছে, তেতিয়া তেৱোঁ ভোজন কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","কিন্তু বিদেশী সকল আৰু ভাড়া কৰি অনা দাস সকলে ইয়াক খাব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","আহাৰ একেটা ঘৰতে ভোজন কৰিবই লাগিব। সেই মাংসৰ অলপো ঘৰৰ বাহিৰলৈ নিনিবা, আৰু তাৰ এডাল হাড়ো নেভাঙিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ইস্ৰায়েলৰ গোটেই সমাজে তাক পালন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","তোমাৰ লগত বাস কৰা কোনো বিদেশী লোকে যদি যিহোৱাৰ নিস্তাৰ-পৰ্ব্ব পালন কৰিব খোজে, তেন্তে তেওঁৰ পৰিয়ালৰ সকলো পুৰুষে চুন্নৎ কৰিব লাগিব। তেতিয়াহে তেওঁ আহি তাক পালন কৰিব পাৰিব। তেওঁ দেশত জন্ম হোৱা লোকৰ নিচিনা হ’ব। অৱশ্যে চুন্নৎ নোহোৱা কোনো লোকে ইয়াক ভোজন কৰিব নালাগে।” ");
INSERT INTO asmfb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","দেশত জন্ম হোৱা লোকৰ বাবে, আৰু তোমালোকৰ মাজত বাস কৰা বিদেশী লোকৰ কাৰণেও একেটা বিধিয়েই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","সেয়ে ইস্ৰায়েলৰ সকলো লোকে যিহোৱাই মোচি আৰু হাৰোণক দিয়া আজ্ঞাৰ দৰেই কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","এইদৰে যিহোৱাই সেই দিনাই ইস্ৰায়েলৰ লোক সকলক সৈন্যৰ দলেৰে সৈতে মিচৰ দেশৰ পৰা বাহিৰ কৰি আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","যিহোৱাই মোচিৰ সৈতে কথা পাতি ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ইস্ৰায়েলৰ লোক সকলৰ মানুহৰেই হওক বা পশুৰেই হওক, সকলো প্ৰথম গৰ্ভফল মোৰ উদ্দেশে উৎসৰ্গ কৰা। প্ৰথমে জন্মা সকলো মোৰেই।” ");
INSERT INTO asmfb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","মোচিয়ে লোকসকলক ক’লে, “তোমালোকে বন্দী-ঘৰস্বৰূপ মিচৰৰ পৰা ওলাই অহা এই দিন সোঁৱৰণ কৰিবা; কাৰণ যিহোৱাই তেওঁৰ বাহু-বলেৰে আপোনালোকক সেই ঠাইৰ পৰা উলিয়াই আনিলে। খমীৰ দিয়া পিঠা আৰু ভোজন কৰা নহব। ");
INSERT INTO asmfb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","আবীব মাহৰ এই দিনাই তোমালোক মিচৰ দেশৰ পৰা বাহিৰ হৈ আহিলা। ");
INSERT INTO asmfb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","কনানীয়া, হিত্তীয়া, ইমোৰীয়া, হিব্বীয়া আৰু যিবুচীয়া লোকসকলৰ যি দেশ তোমালোকক দিবলৈ, যিহোৱাই তোমালোকৰ পূৰ্বপুৰুষ সকলৰ আগত প্রতিজ্ঞা কৰিছিল, সেই গাখীৰ আৰু মৌ বৈ থকা দেশত, যেতিয়া তেওঁ তোমালোকক সুমুৱাব, তেতিয়া তোমালোকে এই মাহত যিহোৱাৰ উদ্দেশ্যে আৰাধনাৰ কাৰ্য কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","সাত দিনলৈকে খমীৰ নিদিয়া পিঠা ভোজন কৰিবা; আৰু সপ্তম দিনটো যিহোৱাৰ উদ্দেশ্যে উৎসৱৰ দিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","সেই সাত দিন নিশ্চয়কৈ খমীৰ নিদিয়া পিঠা ভোজন কৰিব লাগিব; তোমালোকৰ মাজত খমীৰ দিয়া কোনো পিঠা যাতে দেখা পোৱা নাযাওক। এনেকি তোমালোকৰ চাৰিও সীমাৰ ভিতৰতো খমীৰ দেখা পোৱা নাযাওক। ");
INSERT INTO asmfb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","সেই দিনা তোমালোকে আপোনালোকৰ সন্তান সকলক ক’বা, ‘যেতিয়া মিচৰৰ পৰা আমি ওলাই আহিলোঁ, তেতিয়া যিহোৱাই আমাৰ বাবে যি কৰিছিল, সেই কাৰ্যৰ কাৰণে এইদৰে কৰা হৈছে।’ ");
INSERT INTO asmfb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","এয়ে উদ্ধাৰ সোঁৱৰণৰ বাবে তোমালোকৰ হাত আৰু কপালত থাকক। যিহোৱাৰ ব্যৱস্থা তোমালোকৰ কথাত থাকক, কিয়নো তোমালোকৰ হাত, আৰু কপালত এই মুক্তি সোঁৱৰণীয় হৈ থাকিব। কিয়নো যিহোৱাই বাহুবলেৰে মিচৰৰ পৰা তোমালোকক বাহিৰ কৰি আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","এই হেতুকে তোমালোকে প্রত্যেক বছৰে এই সময়ত, এই বিধি পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","যিহোৱাই তোমাক আৰু তোমালোকৰ পূৰ্বপুৰুষ সকলক দিয়া প্রতিজ্ঞা অনুসাৰে, যেতিয়া তোমাক কনানীয়া সকলৰ দেশত আনি সোমুৱাব, ");
INSERT INTO asmfb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","তেতিয়া তোমালোকৰ প্রত্যেকৰে প্রথমে জন্ম হোৱা সন্তান আৰু তোমালোকৰ জীৱ জন্তুৰ প্রথমে জন্মা পশু যিহোৱাৰ উদ্দেশ্যে পৃথক কৰিবা। প্রথমে জন্মা সকলো পুৰুষ আৰু মতাপশু যিহোৱাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","প্রত্যেক প্রথমে জন্মা গাধ এটা মেৰ-ছাগ পোৱালি দি মুক্ত কৰিব। যদি মুক্ত নকৰে, তেন্তে তাৰ ডিঙি ভাঙিব; কিন্তু তোমালোকৰ পুত্রসকলৰ মাজত প্রথমে জন্মা পুত্ৰ তোমালোকে নিশ্চয় কিনি মুক্ত কৰিব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","পাছত তোমালোকৰ পুত্ৰই যেতিয়া ‘ইয়াৰ অৰ্থ কি’ বুলি সুধিব?’ তেতিয়া তুমি তাক ক’বা যে, “যিহোৱাই বাহুবলেৰে মিচৰৰ বন্দী ঘৰৰ পৰা আমাক উলিয়াই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","যেতিয়া ফৰৌণে আমাক এৰি দিবলৈ মন কঠিন কৰিলে, তেতিয়া যিহোৱাই মিচৰ দেশত, মানুহৰ প্ৰথমে জন্মা পুত্র আৰু পশুৰ প্ৰথমে জগা মতাপশু সকলোকে বধ কৰিলে। এই হেতুকে, মই পশুবোৰৰ প্রথমে জন্মা মতা পশু যিহোৱাৰ উদ্দেশ্যে বলিদান কৰোঁ; সেই বাবে মই মোৰ প্ৰথমে জন্মা পুত্ৰক কিনি লৈ মুক্ত কৰোঁ।’ ");
INSERT INTO asmfb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","এয়ে তোমালোকৰ হাত, আৰু কপালত সোঁৱৰণী স্বৰূপে থাকিব। কিয়নো যিহোৱাই বাহুবলেৰে আমাক মিচৰৰ পৰা বাহিৰ কৰি আনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ফৰৌণে যেতিয়া লোকসকলক যাবলৈ এৰি দিলে, তেতিয়া পলেষ্টীয়াসকলৰ দেশেৰে বাট চমু আছিল যদিও, ঈশ্বৰে তেওঁলোকক সেই বাটেদি নিনিলে। কিয়নো ঈশ্বৰে ক’লে, “হয়তো যুদ্ধৰ সন্মুখিন হ’লে লোকসকলে মন সলনি কৰি মিচৰলৈ উভটি যাব।” ");
INSERT INTO asmfb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","সেয়ে ঈশ্বৰে লোকসকলক মৰুভুমিৰ মাজেৰে চূফ সাগৰলৈকে লৈ গ’ল। ইস্ৰায়েলী লোক সকলে যুদ্ধৰ বাবে সুসজ্জিত হৈ মিচৰ দেশৰ পৰা ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","মোচিয়ে যোচেফৰ অস্থিকো নিজৰ লগত ল’লে; কিয়নো যোচেফে ইস্ৰায়েলী লোকসকলক শপত খুৱাই কৈছিল, “ঈশ্বৰে আপোনালোকক নিশ্চয় উদ্ধাৰ কৰিব আৰু আপোনালোকে তেতিয়া মোৰ অস্থিক আপোনালোকৰ লগত লৈ যাব।” ");
INSERT INTO asmfb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ইস্রায়েলী লোকসকলে চুক্কোতৰ পৰা যাত্ৰা কৰি, মৰুপ্রান্তৰ দাঁতিত থকা এথমত তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","তেওঁলোকে দিনে-ৰাতিয়ে যাত্রা কৰিবলৈ যিহোৱাই দিনত তেওঁলোকক মেঘ-স্তম্ভ, আৰু ৰাতি পোহৰ দিবলৈ অগ্নি-স্তম্ভৰে তেওঁলোকৰ আগে আগে গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","যিহোৱাই লোকসকলৰ আগৰ পৰা দিনত মেঘ-স্তম্ভ, আৰু ৰাতি অগ্নিস্তম্ভ আঁতৰ নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","তাৰ পাছত যিহোৱাই মোচিক ক’লে: ");
INSERT INTO asmfb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ইস্ৰায়েলী লোক সকলক কোৱা যে, তেওঁলোক ঘূৰি বাল-চফোনৰ সন্মুখত, মিগদোল আৰু সাগৰৰ মাজত, পী-হহীৰোতৰ আগত তম্বু তৰিব। তোমালোকে পী-হহীৰতৰ বিপৰীতে থকা সাগৰৰ দাঁতিত তম্বু তৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ফৰৌণে ইস্ৰায়েলী লোকসকলৰ বিষয়ে এই দৰে ক’ব, ‘তেওঁলোকে দেশৰ মাজত বিচৰণ কৰি ফুৰিছে, আৰু তেওঁলোক মৰুভূমিত আৱদ্ধ হৈ আছে।’ ");
INSERT INTO asmfb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","মই ফৰৌণৰ মন কঠিন কৰিম; আৰু তেওঁ তেওঁলোকৰ পাছে পাছে খেদি আহিব। মই ফৰৌণৰ আৰু তেওঁৰ সকলো সৈন্য সমূহৰ বাবে গৌৰৱান্বিত হ’ম। মিচৰীয়া সকলে জানিব যে, মই যিহোৱা।” সেয়ে ইস্রায়েলী লোক সকলে তেওঁলোকক নিৰ্দেশ দিয়াৰ দৰে তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ইস্রায়েলী লোকসকল পলাই গ’ল বুলি মিচৰৰ ৰজাক জনোৱাৰ পাছত ফৰৌণ আৰু তেওঁৰ দাসবোৰৰ মন ইস্ৰায়েলী লোকসকলৰ বিৰুদ্ধে হ’ল। তেওঁলোকে ক’লে, “আমাৰ বন্দীকামৰ পৰা ইস্ৰায়েলী লোকসকলক এৰি দি আমি কি কাম কৰিলোঁ?” ");
INSERT INTO asmfb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","তেতিয়া ফৌৰণে নিজৰ ৰথ সাজু কৰিলে, আৰু নিজৰ সৈন্য সকলক তেওঁৰ লগত ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","তেওঁ মনোনীত ছশ ৰথ, আৰু মিচৰৰ আন সকলো ৰথ, আৰু সেই সকলোবোৰৰ ওপৰত নিযুক্ত সেনাপতি সকলকো ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","যিহোৱাই মিচৰৰ ৰজা ফৰৌণৰ মন কঠিন কৰিলে, তাতে তেওঁ ইস্ৰায়েলী লোকসকলৰ পাছে পাছে খেদি গ’ল। তেতিয়া ইস্ৰায়েলী লোকসকলে যিহোৱাৰ জয়ধ্বনি কৰি ওলাই গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","কিন্তু মিচৰীয়া লোক সকলে ঘোঁৰা, ৰথ, অশ্বাৰোহী, আৰু সৈন্যৰ সৈতে তেওঁলোকৰ পাছে পাছে খেদি গ’ল। বাল-চফোনৰ সন্মুখত পী-হহীৰোতৰ ওচৰৰ সাগৰৰ দাঁতিত ইস্রায়েলী লোকসকলে তম্বু তৰি থকা ঠাইত, তেওঁলোকে আগচি ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ফৰৌণ যেতিয়া ওচৰ চাপি আহিল, তেতিয়া ইস্ৰায়েলী লোকসকলে তেওঁলোকক চাই আচৰিত হ’ল। তেওঁলোকৰ পাছে পাছে মিচৰীয়া সকল আহি আছিল; তাতে ইস্ৰায়েলী লোকসকলে অতিশয় ভয় কৰি যিহোৱাৰ আগত কাতৰোক্তি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","তেওঁলোকে মোচিক ক’লে, “মিচৰত মৈদাম নাই নে যে, আমি মৰুভূমিত মৰিবলৈ, আপুনি আমাক ইয়ালৈ আনিলে? আপুনি আমাক মিচৰৰ পৰা উলিয়াই আনি, আমালৈ কিয় এনেকুৱা ব্যৱহাৰ কৰিছে? ");
INSERT INTO asmfb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","আমি মিচৰতে আপোনাক এই কথা কোৱা নাছিলোঁ নে? আমি আপোনাক কৈছিলোঁ, ‘আমাক মিচৰীয়া সকলৰ বন্দীকাম কৰিবলৈ অকলে এৰি দিয়ক? কিয়নো মৰুভূমিত মৰাতকৈ মিচৰীয়া সকলৰ বন্দীকাম কৰাই আমাৰ পক্ষে ভাল আছিল।’” ");
INSERT INTO asmfb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","মোচিয়ে লোকসকলক ক’লে, “ভয় নকৰি। নিৰৱে থাকা; আৰু চাওক, যিহোৱাই আজি তোমালোকলৈ পৰিত্ৰাণৰ কাৰ্য সিদ্ধ কৰিব। কাৰণ যি মিচৰীয়া সকলক আজি তোমালোকে দেখিছা, তেওঁলোকক পুনৰ কেতিয়াও নেদেখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","যিহোৱাই তোমালোকৰ বাবে যুদ্ধ কৰিব; আৰু আপোনালোক কেৱল নিৰৱে থাকা।” ");
INSERT INTO asmfb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “তুমি মোলৈ কিয় কাতৰোক্তি কৰিছা? ইস্ৰায়েলী লোকসকলক আগুৱাই যাবলৈ কোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","তুমি তোমাৰ লাখুটি তুলি, সাগৰৰ ওপৰলৈ তোমাৰ হাত মেলা, আৰু সাগৰক দুভাগ কৰা; তাতে ইস্ৰায়েলী লোকসকলে সাগৰৰ মাজেৰে শুকান বাটেদি যাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","চোৱা মই মিচৰীয়া সকলৰ মন কঠিন কৰিম; তাতে তেওঁলোকে তেওঁলোকৰ পাছে পাছে যাব। মই ফৰৌণ, তেওঁৰ সকলো ৰথ ও অশ্বাৰোহী আৰু সৈন্য সকলৰ দ্বাৰাই গৌৰৱান্বিত হ’ম। ");
INSERT INTO asmfb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","তেতিয়া ফৰৌণ, তেওঁৰ ৰথ, আৰু অশ্বাৰোহী সকলৰ দ্বাৰাই মই গৌৰৱান্বিত হ’লে, ময়েই যে যিহোৱা, এই কথা মিচৰীয়া সকলে জানিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ঈশ্বৰৰ যি দূত ইস্ৰায়েলী লোকসকলৰ আগে আগে গৈছিল, তেওঁ তেওঁলোকৰ আগৰ পৰা আঁতৰি পাছফাললৈ গ’ল। মেঘ-স্তম্ভ তেওঁলোকৰ আগৰ পৰা আঁতৰি গৈ তেওঁলোকৰ পাছফালে স্থিৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","মেঘ-স্তম্ভ মিচৰীয়া সৈন্য সকল আৰু ইস্ৰায়েলী লোকসকলৰ তম্বুৰ মাজলৈ আহিল। সেয়ে মিচৰীয়া লোকসকলৰ বাবে অন্ধকাৰময় মেঘ হ’ল, কিন্তু ইস্রায়েলী লোকসকলৰ বাবে ৰাতি পোহৰ দিওঁতা হ’ল। তাতে ওৰে ৰাতি ইদলে সিদলৰ ওচৰ চাপিব নোৱাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","মোচিয়ে সাগৰৰ ওপৰত তেওঁৰ হাত মেলিলে। যিহোৱাই সেই গোটেই নিশা পূব ফালৰ প্ৰবল বতাহেৰে সাগৰ হোঁহোকাই নি, তাক শুকান ভূমি কৰিলে। এইদৰে পানী দুভাগ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","তেতিয়া ইস্ৰায়েলী লোকসকল শুকান বাটেদি সাগৰৰ মাজেলৈ গ’ল। তেওঁলোকৰ সোঁফালে আৰু বাওঁফালে জল সমূহ তেওঁলোকলৈ দেৱাল স্বৰূপ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","মিচৰীয়া সকলে তেওঁলোকক খেদি গ’ল। ফৰৌণৰ সকলো ঘোঁৰা, ৰথ, আৰু অশ্বাৰোহী বিলাক তেওঁলোকৰ পাছে পাছে সাগৰৰ মাজলৈ সোমাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","কিন্তু দোকমোকালীতে যিহোৱাই অগ্নিস্তম্ভ আৰু মেঘ-স্তম্ভৰ মাজৰ পৰা মিচৰীয়া সৈন্য সকললৈ চাই, মিচৰীয়া সৈন্য সকলক ব্যাকুল কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","যিহোৱাই তেওঁলোকৰ ৰথৰ চকা সোলোকালে, আৰু অশ্বাৰোহী বিলাকে অতি কষ্টেৰে ৰথ চলালে। সেয়ে মিচৰীয়া সকলে ক’লে, “আহাঁ, আমি ইস্ৰায়েলৰ সন্মুখৰ পৰা পলাওহঁক; কিয়নো যিহোৱাই তেওঁলোকৰ ফলীয়া হৈ, আমাৰ বিৰুদ্ধে যুদ্ধ কৰিছে।” ");
INSERT INTO asmfb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “মিচৰীয়া সকল, তেওঁলোকৰ ৰথ আৰু অশ্বাৰোহী বিলাকৰ ওপৰলৈ যেন পুনৰায় জল সমূহ আহিব, তাৰ বাবে তুমি সাগৰৰ ওপৰলৈ তোমাৰ হাত মেলা।” ");
INSERT INTO asmfb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","সেয়ে মোচিয়ে সাগৰৰ ওপৰলৈ হাত মেলিলে, আৰু যেতিয়া ৰাতিপুৱা হ’ল, তেতিয়া সাগৰ পুনৰ স্বাভাৱিক ৰূপত আহিল। মিচৰীয়া সকলে সাগৰলৈ সোমাই যাওঁতে, যিহোৱাই মিচৰীয়া সকলক সাগৰৰ মাজত পেলালে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","জল সমূহ উভটি আহি ফৌৰণৰ ৰথ, অশ্বাৰোহী আৰু তেওঁলোকৰ পাছে পাছে সাগৰত সোমোৱা ফৰৌণৰ সকলো সৈন্য পানীয়ে ঢাকি ধৰিলে। তাতে তেওঁলোকৰ কোনো জীয়াই নাথাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ইস্ৰায়েলী লোকসকল সাগৰৰ মাজেদি শুকান বাটেৰে গ’ল; আৰু তেওঁলোকৰ সোঁফালে আৰু বাওঁফালে জল সমূহ তেওঁলোকলৈ দেৱাল স্বৰূপ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","এইদৰে সেই দিনা যিহোৱাই মিচৰীয়া সকলৰ হাতৰ পৰা ইস্ৰায়েলক পৰিত্ৰাণ কৰিলে। ইস্ৰায়েলী লোকসকলে মিচৰীয়া সকলৰ মৃতদেহ সাগৰৰ তীৰত পৰি থকা দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ইস্ৰায়েলী লোক সকলে যেতিয়া মিচৰীয়া সকলৰ বিৰুদ্ধে যিহোৱাৰ মহা পৰাক্রম দেখিলে, তেতিয়া তেওঁলোকে যিহোৱাৰ গৌৰৱ কৰিলে,আৰু তেওঁলোকে যিহোৱা আৰু তেওঁৰ দাস মোচিক বিশ্বাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","তাৰ পাছত মোচি আৰু ইস্ৰায়েলী লোকসকলে যিহোৱাৰ উদ্দেশ্যে এই স্তুতি গীত গাইছিল; তেওঁলোকে এইদৰে গাইছিল, “মই যিহোৱাৰ উদ্দেশ্যে গান কৰিম, কিয়নো তেওঁ মহা জয়েৰে গৌৰৱাম্বিত হ’ল; তেওঁ ঘোঁৰা আৰু অশ্বাৰোহী সমূদ্ৰত পেলালে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","যিহোৱা মোৰ বল আৰু গান; তেওঁ মোৰ পৰিত্ৰাণকৰ্ত্তা হ’ল; তেওঁ মোৰ ঈশ্বৰ, আৰু মই তেওঁৰ প্ৰশংসা কৰিম; তেওঁ মোৰ পিতৃৰো ঈশ্বৰ, আৰু মই তেওঁৰ প্রশংসা কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","যিহোৱা পৰাক্ৰমী বীৰ; যিহোৱা তেওঁৰ নাম। ");
INSERT INTO asmfb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","তেওঁ ফৰৌণৰ ৰথ আৰু সৈন্য সমূহক সমুদ্ৰত পেলালে। ফৌৰণৰ মনোনীত সেনাপতিসকল চূফ সাগৰত ডুবিল। ");
INSERT INTO asmfb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","জল সমূহে তেওঁলোকক ঢাকি ধৰিলে; শিলৰ দৰে তেওঁলোক অগাধ জলৰ ত’ললৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","হে যিহোৱা, আপোনাৰ সোঁ হাত, পৰাক্ৰমত মহিমান্বিত হ’ল; হে যিহোৱা, আপোনাৰ সোঁ হাতে শত্ৰুক গুড়ি কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","আপুনি আপোনাৰ মহান মহিমাৰে আপোনাৰ বিৰুদ্ধে উঠাবোৰক বিনষ্ট কৰিলে। আপুনি পঠোৱা আপোনাৰ ক্ৰোধাগ্নিয়ে; তেওঁলোকক নৰাৰ দৰে গ্রাস কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","আপোনাৰ নিশ্বাসতে জল সমূহ স্তূপাকৃত হ’ল; বৈ যোৱা জল সমূহো স্তূপাকৃত হ’ল; সমুদ্ৰৰ অগাধ জল সাগৰৰ অন্তৰ ভাগত গোট বান্ধিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","শত্ৰুৱে কৈছিল, ‘মই পাছে পাছে খেদি যাম, মই আগ ভেটি ধৰিম, মই লুটদ্ৰব্য ভগাই ল’ম; মোৰ হাবিয়াহ তেওঁলোকৰ ওপৰত পূৰ হ’ব; মই তৰোৱাল উলিয়াম, মোৰ হাতে তেওঁলোকক সংহাৰ কৰিব।’ ");
INSERT INTO asmfb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","কিন্তু আপুনি আপোনাৰ বায়ুৰে ফু দিলত সাগৰে তেওঁলোকক ঢাকি ধৰিলে; তেওঁলোক সীহৰ দৰে মহাজলত ডুব গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","হে যিহোৱা, দেৱতাবোৰৰ মাজত আপোনাৰ তুল্য কোন? পবিত্ৰতাত আপোনাৰ দৰে মহিমান্বিত কোন? প্ৰশংসাত গৌৰৱাম্বিত, আচৰিত কৰ্ম কৰোঁতা কোন? ");
INSERT INTO asmfb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","আপুনি আপোনাৰ সোঁ হাত মেলিলে, আৰু পৃথিৱীয়ে তেওঁলোকক গ্ৰাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","আপুনি উদ্ধাৰ কৰা লোকসকলক আপোনাৰ দয়াৰে চলাই আনিছে; আপুনি আপোনাৰ পৰাক্ৰমেৰেই তেওঁলোকক আপোনাৰ পবিত্ৰ নিবাসলৈ লৈ গৈছে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","লোকসকলে শুনিব আৰু তেওঁলোক কঁপি উঠিব; পলেষ্টিয়া লোকসকলক ত্ৰাসে বেৰি ধৰিছে।” ");
INSERT INTO asmfb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","তেতিয়া ইদোমৰ প্রধান লোকসকলে ভয় কৰিলে; মোৱাবৰ সৈন্য সকল কঁপি উঠিল; কনান-বাসী সকলোৱেই দিশহাৰা হৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ভয় আৰু ত্ৰাসে তেওঁলোকক বেৰি ধৰিলে; আপোনাৰ বাহুবলৰ শক্তিৰ কাৰণে তেওঁলোক শিলৰ দৰে নীৰৱ হৈ ৰ’ল; হে যিহোৱা, আপোনাৰ লোকসকল পাৰ নোহোৱালৈকে; আপুনি উদ্ধাৰ কৰা লোকসকল পাৰ নোহোৱালৈকে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","আপুনি তেওঁলোকক আনিব আৰু আপোনাৰ অধিকাৰ কৰা পাহাৰত স্থাপন কৰিব, হে যিহোৱা, আপুনি নিবাস কৰিবলৈ যুগুত কৰা ঠাই, হে প্ৰভু, যি ধৰ্মধাম আপুনি নিজৰ হাতেৰে নিৰ্ম্মাণ কৰিলে, ");
INSERT INTO asmfb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","যিহোৱাই সদা-সৰ্ব্বদায় ৰাজত্ব কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","কাৰণ ফৰৌণৰ ৰথ আৰু অশ্বাৰোহীৰ সৈতে ঘোঁৰাবোৰ সমুদ্ৰৰ মাজত সোমাল। যিহোৱাই সমুদ্ৰৰ জল তেওঁলোকৰ ওপৰলৈ উভটাই আনিলে। কিন্তু ইস্ৰায়েলী লোকসকল হ’লে, সমুদ্ৰৰ মাজেদি শুকান বাটেদি গুছি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","তেতিয়া হাৰোণৰ বায়েক মিৰিয়ম ভাববাদিনীয়ে তেওঁৰ হাতত খঞ্জৰি ল’লে; আৰু তেওঁৰ পাছে পাছে আন আন মহিলাসকলেও হাতত খঞ্জৰি লৈ, নাচি নাচি ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","মিৰিয়মে তেওঁলোকৰ আগত গীত গালে, “তোমালোকে যিহোৱাৰ উদ্দেশ্যে গান কৰা, কিয়নো তেওঁ মহা-গৌৰৱাম্বিত হ’ল; তেওঁ ঘোঁৰা আৰু অশ্বাৰোহীক সমুদ্ৰত পেলাই দিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","তাৰ পাছত মোচিয়ে ইস্ৰায়েলী লোকসকলক চূফ সাগৰৰ তীৰৰ পৰা যাত্ৰা কৰিবলৈ দিলে, তেওঁলোকে চূৰ মৰুভূমিৰ মাজেৰে যাত্রা কৰি গ’ল। তেওঁলোকে সেই মৰুভূমিৰ মাজেৰে তিনি দিনৰ বাট গ’ল, আৰু সেই ঠাইত পানী বিচাৰি নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","তাৰ পাছত তেওঁলোকে মাৰা গৈ পালে, আৰু মাৰাত থকা পানী তিতা হোৱাৰ বাবে, তেওঁলোকে পান কৰিব নোৱাৰিলে; সেয়ে তেওঁলোকে সেই ঠাইৰ নাম মাৰা ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","সেই কাৰণে লোকসকলে মোচিক অভিযোগ কৰি ক’লে, “আমি কি পান কৰিম?” ");
INSERT INTO asmfb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","তেতিয়া মোচিয়ে যিহোৱাৰ আগত কাতৰোক্তি কৰিলে, আৰু যিহোৱাই তেওঁক এজোপা গছ দেখুৱালে। তেওঁ তাকে আনি পানীত পেলাই দিলে, আৰু পানী খাবলৈ মিঠা হ’ল। সেই ঠাইতে যিহোৱাই তেওঁলোকৰ অৰ্থে এটা কঠোৰ বিধি আৰু শাসন-প্রণালী দিলে। সেই ঠাইতে যিহোৱাই তেওঁলোকক পৰীক্ষা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","তেওঁ ক’লে, “মই, তোমালোকৰ ঈশ্বৰ যিহোৱা, যদি তোমালোকে সাৱধানে মোৰ বাক্য শুনা, আৰু মোৰ দৃষ্টিত যি উচিত সেই কাৰ্য কৰা, আৰু মোৰ আজ্ঞাবোৰলৈ মনোযোগ দিয়া আৰু মোৰ সকলো বিধি পালন কৰা তেনেহ’লে, মই মিচৰীয়াসকলক যি সকলো ৰোগ দিছিলোঁ, সেইবোৰৰ কোনো ৰোগ তোমালোকক নিদিম, কাৰণ মই তোমালোকৰ আৰোগ্যকাৰী যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","তাৰ পাছত লোকসকল এলীমলৈ আহিল; সেই ঠাইত পানীৰ বাৰটা ভুমুক, আৰু সত্তৰ জোপা খাজুৰ গছ আছিল; তেওঁলোকে সেই ঠাইতে পানীৰ কাষত তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ইস্ৰায়েলী লোকসকলে এলীমৰ পৰা যাত্ৰা কৰিলে। মিচৰ দেশৰ পৰা ওলাই অহাৰ পাছত দ্বিতীয় মাহৰ পোন্ধৰ দিনৰ দিনা, এলীম আৰু চীনয় এই দুয়োৰো মাজত থকা চীন মৰুপ্রান্তৰ পালে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ইস্ৰায়েলী সকলৰ গোটেই সমাজে মোচি আৰু হাৰোণৰ বিৰুদ্ধে মৰুভূমিত অভিযোগ কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ইস্ৰায়েলী সকলে তেওঁলোকক ক’লে, “আমি যেতিয়া মাংস ৰখা পাত্ৰৰ ওচৰত বহি লৈ হেঁপাহ নপলাইমানে পিঠা খাইছিলোঁ, সেই সময়তেই মিচৰ দেশত যিহোৱাৰ হাতত মৰা হ’লে ভাল আছিল। আপোনালোকে আমাক সকলোকে ভোকত মৰিবলৈ এই মৰুভূমিলৈ উলিয়াই আনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","তেতিয়া যিহোৱাই মোচিক ক’লে, “লোকসকলে মোৰ ব্যৱস্থা মানি চলিব নে নাই, তাৰ পৰীক্ষা কৰিবৰ অৰ্থে, ‘মই তোমালোকলৈ আকাশৰ পৰা পিঠা বৰষাম’ আৰু লোকসকলে ওলাই গৈ প্রতি দিনৰ আহাৰ প্রতি দিনে গোটাব। ");
INSERT INTO asmfb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","তেওঁলোকে প্রতিদিনে যিমান আহাৰ গোটাইছিল প্রতি ষষ্ঠ দিনত তাতকৈ দুগুণ গোটাব, আৰু তেওঁলোকে যি পৰিমাণে আনিব, তাকে ৰান্ধিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","তাৰ পাছত মোচি আৰু হাৰোণে ইস্ৰায়েলী লোকসকলক ক’লে, “গধূলি তোমালোকে জানিব পাৰিবা যে, যিহোৱাইহে তোমালোকক মিচৰ দেশৰ পৰা উলিয়াই আনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ৰাতিপুৱা তোমালোকে যিহোৱাৰ মহিমা দেখিবলৈ পাবা; কাৰণ যিহোৱাৰ বিৰুদ্ধে তোমালোকে কৰা অভিযোগ তেওঁ শুনিলে। আমি নো কোন যে, তোমালোকে আমাৰ বিৰুদ্ধে অভিযোগ কৰিছা?” ");
INSERT INTO asmfb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","মোচিয়ে পুনৰ ক’লে, “যিহোৱাই গধূলি যেতিয়া তোমালোকক খাবলৈ মাংস, আৰু ৰাতিপুৱা উপচি পৰাকৈ পিঠা দিব, তেতিয়া যিহোৱাৰ বিৰুদ্ধে তোমালোকে কৰা অভিযোগ তেওঁ যে শুনিলে, সেই কথা তোমালোকে বুজি পাবা। হাৰোণ আৰু মই কোন? তোমালোকৰ অভিযোগ আমাৰ বিৰুদ্ধে নহয়; যিহোৱাৰ বিৰুদ্ধেহে।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","মোচিয়ে হাৰোণক ক’লে, “আপুনি ইস্ৰায়েলী লোকসকলৰ সমাজক কওক, তোমালোক যিহোৱাৰ ওচৰলৈ চাপি আহা; কাৰণ তেওঁ তোমালোকৰ অভিযোগ শুনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","হাৰোণে ইস্ৰায়েলী লোকসকলৰ সমাজক এই কথা কৈ থাকোতে, তেওঁলোকে মৰুপ্রান্তৰ ফাললৈ চাই দেখিলে যে, মেঘৰ মাজত যিহোৱাৰ মহিমা প্ৰকাশিত হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","তেতিয়া যিহোৱাই মোচিৰ সৈতে কথা পাতি ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“মই ইস্ৰায়েলী লোকসকলৰ অভিযোগ শুনিলোঁ। তুমি তেওঁলোকক কোৱা, ‘গধূলি তোমালোকে মাংস আৰু ৰাতিপুৱা হেঁপাহ পলুৱাই পিঠা খাবলৈ পাবা। তেতিয়া তোমালোকে জানিবা যে, ময়েই তোমালোকৰ যিহোৱা, তোমালোকৰ ঈশ্বৰ’।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","গধূলি পৰত, বটা চৰাইবোৰ তম্বুৰ ওপৰলৈ আহি তম্বু ঢাকি ধৰিলে। ৰাতিপুৱা তম্বুৰ চাৰিওফালে নিয়ৰ পৰি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","পৰি থকা সেই নিয়ৰবোৰ যেতিয়া শুকাই গ’ল, তেতিয়া ক্ষুদ্র বৰফৰ টুকুৰাৰ দৰে সৰু সৰু ঘূৰণীয়া বস্তু গোটেইখন মৰুপ্রান্তৰ ভূমিত পৰি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ইস্ৰায়েলী লোকসকলে সেই বস্তু দেখি ইজনে সিজনক ক’লে, “এইয়া কি?” কিয়নো সেই বস্তু নো কি তেওঁলোকে নাজানিছিল। তেতিয়া মোচিয়ে তেওঁলোকক ক’লে, “এইয়া যিহোৱাই তোমালোকক খাবলৈ দিয়া পিঠা।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","যিহোৱাই দিয়া আজ্ঞা এই, “তোমালোক প্ৰতিজনে খাব পৰা শক্তি অনুসাৰে; আৰু তোমালোক প্রতিজনে তম্বুত থকা মানুহৰ সংখ্যা অনুসাৰে এক ওমৰ গোটাবা। এইদৰেই তোমালোকে গোটাবা: তোমালোকে তম্বুত থকা প্রতিজন মানুহে খাব পৰা অনুসাৰে গোটাবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","তেতিয়া ইস্ৰায়েলী লোকসকলে সেইদৰেই কৰিলে। কিছুমান লোকে অধিক আৰু কিছুমান লোকে তাকৰকৈ গোটালে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","তেওঁলোকে যেতিয়া সেইবোৰ ওমৰৰ জোখত জুখিলে, যি সকলে অধিককৈ গোটাইছিল, তেওঁলোকৰ অতিৰিক্ত নহ’ল, আৰু যি সকলে তাকৰকৈ গোটাইছিল তেওঁলোকৰো অভাৱ নহ’ল। তেওঁলোক প্ৰতিজনে প্রয়োজন অনুসাৰে গোটালে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","তেতিয়া মোচিয়ে তেওঁলোকক ক’লে, “কোনো এজনেও ৰাতিপুৱালৈকে ইয়াৰ অৱশিষ্ট নাৰাখিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","তথাপিও তেওঁলোকে মোচিৰ কথা নুশুনিলে। কিছুমানে ৰাতিপুৱালৈকে সেইবোৰৰ কিছু অৱশিষ্ট ৰাখি থলে; কিন্তু সেইবোৰত পোক জন্মিল, আৰু দুৰ্গন্ধময় হ’ল; তেতিয়া তেওঁলোকৰ ওপৰত মোচিৰ খং উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","প্রতি ৰাতিপুৱাতে তেওঁলোকে সেইবোৰ গোটাইছিল। প্ৰতিজন মানুহে সেই দিনটোত খাব পৰা অনুসাৰে গোটাইছিল। যেতিয়া ৰ’দ প্রখৰ হয়, সেইবোৰ গ’লি গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","তাৰ পাছত ষষ্ঠ দিনৰ দিনা তেওঁলোকে দুগুণ, অৰ্থাৎ প্ৰতিজনৰ বাবে দুই ওমৰকৈ পিঠা গোটাইছিল। তেতিয়া সমাজৰ মূখ্য লোকসকল মোচিৰ ওচৰলৈ আহি সেই কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","মোচিয়ে তেওঁলোকক ক’লে, “যিহোৱাই যে কৈছিল সেয়া এই, ‘কাইলৈ সম্পূৰ্ণ বিশ্ৰাম-দিন, যিহোৱাৰ গৌৰৱৰ উদ্দেশ্যে পবিত্ৰ বিশ্ৰাম-দিন। তোমালোকে যি ভাজিব খোজা, আৰু যি সিজাব খোজে সিজাবা। নিজৰ বাবে ৰাতি পুৱালৈকে তাৰ অৱশিষ্ট অংশ থৈ দিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","সেয়ে তেওঁলোকে মোচিৰ নিৰ্দেশ অনুসাৰে, ৰাতিপুৱালৈকে একাষৰিয়াকৈ থৈ দিলে। সেই খাদ্য দুৰ্গন্ধময় নহ’ল, আৰু তাত পোকো নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","মোচিয়ে ক’লে, “সেই আহাৰ আজি ভোজন কৰা; কাৰণ আজি যিহোৱাৰ গৌৰৱৰ উদ্দেশ্যে বিশ্ৰাম-দিন। আজি তোমালোকে পথাৰত সেইবোৰ বিচাৰি নাপাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","তোমালোকে ছয় দিন সেইবোৰ গোটাবা; কিন্তু সপ্তম দিন বিশ্ৰাম-দিন হয়। সেয়ে বিশ্রাম বাৰে পথাৰত মান্না নাথাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","তথাপিও সপ্তম দিনা কিছুমান লোকে মান্না গোটাবলৈ ওলাই গৈছিল; কিন্তু তেওঁলোকে একো বিচাৰি নাপালে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","তেতিয়া যিহোৱাই মোচিক ক’লে, “তোমালোকে মোৰ আজ্ঞা আৰু ব্যৱস্থাবোৰ কিমান দিনলৈকে পালন কৰিবলৈ অমান্তি হৈ থাকিবা? ");
INSERT INTO asmfb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","চোৱা, মই যিহোৱা, ময়েই তোমালোকক বিশ্ৰামবাৰ দিলোঁ। সেয়ে তোমালোকক ষষ্ঠ দিনা মই দুদিনৰ আহাৰ দি আছোঁ। তোমালোক প্ৰতিজনে নিজৰ ঠাইত থাকিব লাগিব; সপ্তম দিনত কোনো এজনেও নিজৰ ঠাইৰ পৰা বাহিৰলৈ ওলাই নাযাওক।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","সেয়ে লোকসকলে সপ্তম দিনা বিশ্ৰাম কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ইস্ৰায়েলী লোকসকলে সেই আহাৰৰ নাম “মান্না” ৰাখিলে। সেইবোৰ ধনীয়া গুটিৰ দৰে বগা; আৰু ইয়াৰ সোৱাদ মৌজোলৰ সৈতে বনোৱা পিঠাৰ দৰে আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","মোচিয়ে ক’লে, “যিহোৱাই কৰা আজ্ঞা এই মই তোমালোকক মিচৰ দেশৰ পৰা বাহিৰ কৰি অনাৰ পাছত, মৰুভূমিত যি পিঠা তোমালোকক খুৱাইছিলোঁ, সেই পিঠা তোমালোকৰ ভাবী-বংশই যাতে দেখিবলৈ পাব; তাৰ বাবে তোমালোকে পুৰুষানুক্ৰমে এক ওমৰ ৰাখি থবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","মোচিয়ে হাৰোণক ক’লে, “তুমি এটা পাত্ৰ লোৱা, আৰু তাত এক ওমৰ মান্না ভৰোৱা। পুৰুষানুক্ৰমে তোমালোকৰ লোকসকললৈ, যিহোৱাৰ সন্মুখত সেই পত্রটো সংৰক্ষিত কৰি থৈ দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰে, হাৰোণে সেই পাত্রত এক ওমৰ মান্না ভৰাই নিয়ম চন্দুকৰ ভিতৰত বিধান পুস্তকৰ কাষত সংৰক্ষিত কৰি ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ইস্ৰায়েলী লোকসকলে নিবাস কৰা দেশ নোপোৱালৈকে চল্লিশ বছৰ সেই মান্না খাইছিল। তেওঁলোকে কনান দেশৰ সীমা নোপোৱালৈকে সেই মান্নাকে ভোজন কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","এক ওমৰ ঐফাৰ দহ ভাগৰ এভাগ। ");
INSERT INTO asmfb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","তাৰ পাছত ইস্ৰায়েলৰ গোটেই সমাজে যিহোৱাৰ নিৰ্দেশ অনুসাৰে চীন মৰুভূমিৰ পৰা যাত্ৰা কৰিলে। তেওঁলোকে ৰফীদীমত তম্বু তৰিলে; কিন্তু সেই ঠাইত লোকসকলৰ খাবলৈ পানী নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","সেই অৱস্থাৰ কাৰণে লোকসকলে মোচিক দোষ ধৰি ক’লে, “আমাক খাবলৈ পানী দিয়ক।” মোচিয়ে তেওঁলোকক ক’লে, “আপোনালোকে মোৰে সৈতে কিয় বিবাদ কৰিছে?” যিহোৱাক আপোনালোকে কিয় পৰীক্ষা কৰিছে?” ");
INSERT INTO asmfb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","লোকসকল পিয়াহত আতুৰ হ’ল, আৰু মোচিৰ বিৰুদ্ধে অভিযোগ কৰিলে। তেওঁলোকে ক’লে, “আপুনি কিয় আমাক মিচৰৰ পৰা উলিয়াই আনিলে? আমাক, আমাৰ সন্তানসকলক, আৰু পশুবোৰকো পিয়াহত মৰিবলৈ মিচৰৰ পৰা আনিলে নেকি?” ");
INSERT INTO asmfb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","তাৰ পাছত মোচিয়ে যিহোৱাৰ আগত কাতৰোক্তি কৰি ক’লে, “মই এই লোকসকলৰ সৈতে কি কৰিম? তেওঁলোকে মোক শিল দলিয়াই মাৰিবলৈ প্ৰায় যুগুত হৈ আছে।” ");
INSERT INTO asmfb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","তেতিয়া যিহোৱাই মোচিক ক’লে, “তুমি ইস্ৰায়েলৰ পৰিচাৰক কেইজন মানক লগত লৈ, লোক সকলৰ আগে আগে যোৱা; আৰু তুমি যিডাল লাখুটিৰে নদীত প্ৰহাৰ কৰিছিলা, তোমাৰ সেই লাখুটিকো লগত লৈ যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","মই হোৰেবত শিলৰ ওপৰত তোমাৰ সন্মুখত থিয় হ’ম; আৰু তুমি সেই শিলটোক প্ৰহাৰ কৰিবা। তেতিয়া লোকসকলে খাবলৈ, সেই শিলৰ পৰা পানী ওলাব।” তাৰ পাছত মোচিয়ে ইস্ৰায়েলৰ পৰিচাৰকসকলৰ আগত সেইদৰে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","মোচিয়ে সেই ঠাইৰ নাম মচ্ছা আৰু মিৰীবা ৰাখিলে। কাৰণ সেই ঠাইতে ইস্ৰায়েলী লোকসকলে অভিযোগ কৰিছিল, আৰু “যিহোৱা আমাৰ মাজত আছে নে নাই?” এই কথা কৈ যিহোৱাৰ পৰীক্ষাৰ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","সেই সময়ত অমালেকৰ লোকসকলে ৰফীদীমত ইস্ৰায়েলক আক্রমণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","সেয়ে মোচিয়ে যিহোচূৱাক ক’লে, “কিছুমান লোকক মনোনীত কৰি বাহিৰলৈ ওলাই গৈ, অমালেকৰ সৈতে যুদ্ধ কৰক। কাইলৈ মই ঈশ্বৰৰ লাখুটি হাতত লৈ পৰ্ব্বতৰ ওপৰত থিয় হ’ম।” ");
INSERT INTO asmfb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","মোচি, হাৰোণ, আৰু হূৰ যেতিয়া পৰ্ব্বতৰ ওপৰলৈ উঠি গ’ল, তেতিয়া যিহোচূৱাই মোচিৰ নিৰ্দেশ অনুসাৰে অমালেকৰ সৈতে যুদ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","মোচিয়ে যেতিয়া হাত ওপৰলৈ দাঙি ৰাখিছিল, তেতিয়া ইস্ৰায়েলৰ জয় হৈছিল; কিন্তু যেতিয়াই হাত তললৈ নমাইছিল, তেতিয়াই অমালেক জয়ী হ’বলৈ ধৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","এইদৰে হাত দাঙি মোচিৰ হাত ভাগৰি পৰিল, তেতিয়া হাৰোণ আৰু হূৰে এচটা শিল আনি, তেওঁ বহিবৰ কাৰণে তেওঁৰ তলত হ’ল। সেই একে সময়তে হাৰোণ আৰু হূৰে, এজনে এফালে, আৰু আনজনে আন ফালে তেওঁৰ হাত দুখন ধৰি দাঙি ৰাখিলে। সেয়ে বেলি মাৰ নোযোৱালৈকে মোচিৰ হাত থিৰে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","তেতিয়া যিহোচূৱাই অমালেকৰ লোকসকলক তৰোৱালেৰে পৰাজয় কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “সোঁৱৰণৰ অৰ্থে এই কথা পুস্তকত লিখা, আৰু যিহোচূৱাক শুনোৱা; কাৰণ মই আকাশৰ তলৰ পৰা অমালেকৰ নাম সম্পূৰ্ণকৈ লুপ্ত কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","তেতিয়া মোচিয়ে এটা যজ্ঞবেদী নিৰ্মাণ কৰি, তাৰ নাম “যিহোৱা-নিচ্চী” ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","তেওঁ এইদৰে কৰিলে, কিয়নো তেওঁ যিহোৱাৰ যজ্ঞবেদীৰ বিৰুদ্ধ কৰিলে, সেয়ে তেওঁ কৈছিল, “যিহোৱাই প্রতিজ্ঞা কৰিলে যে, তেওঁ পুৰুষে, পুৰুষে অমালেকৰ সৈতে যুদ্ধ কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ঈশ্বৰে মোচিলৈ আৰু নিজৰ প্ৰজা ইস্ৰায়েললৈ যি যি কাৰ্য কৰিলে, বিশেষকৈ যিহোৱাই মিচৰৰ পৰা ইস্ৰায়েলক কেনেকৈ বাহিৰ কৰি আনিলে, সেই সকলো কথা মোচিৰ শহুৰেক মিদিয়নীয়া পুৰোহিত যিথ্ৰোৱে শুনিবলৈ পালে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","তেতিয়া মোচিৰ শহুৰেক যিথ্ৰোৱে, মোচিৰ ভাৰ্যা চিপ্পোৰাক, আৰু দুজন পুত্রক ঘৰলৈ পঠোৱাৰ পাছত, ");
INSERT INTO asmfb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","তেওঁৰ এজন পুত্ৰৰ নাম গেৰ্চোম, কাৰণ মোচিয়ে কৈছিল, “মই বিদেশত প্রবাসী হৈ আছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","আৰু আন জন পুত্রৰ নাম ইলিয়েজৰ কাৰণ তেওঁ কৈছিল, “মোৰ পূৰ্বপুৰুষৰ ঈশ্বৰে মোক সহায় কৰিছিল; আৰু তেওঁ মোক ফৰৌণৰ তৰোৱালৰ পৰা উদ্ধাৰ কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","মোচিয়ে মৰুভূমিত, ঈশ্বৰৰ পৰ্ব্বতৰ যি ঠাইত তম্বু তৰি আছিল, সেই ঠাইলৈ মোচিৰ শহুৰেক যিথ্ৰোৱে মোচিৰ ভাৰ্যা আৰু দুজন পুত্ৰক লগত লৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","তেওঁ মোচিক ক’লে, “মই তোমাৰ শহুৰ যিথ্ৰোৱে তোমাৰ ভাৰ্যা আৰু তাইৰ দুজন পুত্রক লগত লৈ তোমাৰ ওচৰলৈ আহিছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","মোচিয়ে তেওঁৰ শহুৰেকক লগ ধৰিবলৈ বাহিৰলৈ ওলাই গ’ল, আৰু তেওঁক প্ৰণাম কৰি চুমা খালে। তেওঁলোকে ইজনে সিজনৰ ভাল-বেয়া খবৰ ল’লে, আৰু তাৰ পাছত তম্বুলৈ সোমাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","তাৰ পাছত যিহোৱাই ফৰৌণ আৰু মিচৰীয়া লোকসকললৈ, আৰু ইস্ৰায়েলীলোক সকলৰ বাবে যি যি কৰিছিল, বাটত তেওঁলোকলৈ যি সকলো ক্লেশ ঘটিছিল, আৰু যিহোৱাই তেওঁলোকক কেনেকৈ উদ্ধাৰ কৰিলে, সেই সকলো কথা মোচিয়ে তেওঁৰ শহুৰেকক ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","যিহোৱাই মিচৰীয়াসকলৰ হাতৰ পৰা ইস্ৰায়েলক উদ্ধাৰ কৰি, তেওঁলোকৰ বাবে যি যি সকলো মঙ্গলৰ কৰিলে, সেই কাৰ্যবোৰৰ বাবে যিথ্ৰোৱে আনন্দ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","যিথ্ৰোৱে ক’লে, “যিজন সৰ্বশক্তিমান ঈশ্বৰে মিচৰীয়াসকলৰ হাতৰ পৰা, আৰু ফৰৌণৰ হাতৰ পৰা তোমালোকক উদ্ধাৰ কৰিলে, সেই যিহোৱাৰ গৌৰৱ হ’ওক। ");
INSERT INTO asmfb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","যিহোৱা যে সকলো দেৱতাবোৰতকৈ মহান, তাক মই এতিয়া জানিলোঁ; কাৰণ মিচৰীয়াসকলে যেতিয়া ইস্ৰায়েলী লোকসকলৰ বিৰুদ্ধে গৰ্ব্ব আচৰণ কৰিছিল, তেতিয়া ঈশ্বৰে তেওঁৰ লোকসকলক তেওঁলোকৰ পৰা উদ্ধাৰ কৰিছিল।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","তাৰ পাছত মোচিৰ শহুৰেক যিথ্ৰোৱে ঈশ্বৰৰ উদ্দ্যেশে হোম-বলি, আৰু মঙ্গলাৰ্থক বলি উৎসৰ্গ কৰিলে। হাৰোণ আৰু ইস্ৰায়েলৰ সকলো পৰিচাৰক আহি, ঈশ্বৰৰ সন্মুখত মোচিৰ শহুৰেকৰ সৈতে ভোজন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","তাৰ পাছদিনা মোচিয়ে লোকসকলৰ সোধ-বিচাৰ কৰিবলৈ বহিল। ৰাতিপুৱাৰে পৰা সন্ধ্যালৈকে লোকসকল তেওঁৰ চাৰিওফালে থিয় হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","মোচিয়ে লোকসকললৈ কৰা সকলো কাৰ্য দেখি তেওঁৰ শহুৰেকে তেওঁক ক’লে, “তুমি লোকসকলৰ সৈতে এয়া কি কাৰ্য কৰিছা? তুমি কিয় অকলে বহি থাকা, আৰু লোকসকল ৰাতিপুৱাৰ পৰা সন্ধ্যালৈকে তোমাৰ চাৰিওফালে থিয় হৈ থাকে?” ");
INSERT INTO asmfb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","তেতিয়া মোচিয়ে তেওঁৰ শহুৰেকক ক’লে, “লোকসকলে ঈশ্বৰৰ নিৰ্দেশনৰ কথা সুধিবলৈ মোৰ ওচৰলৈ আহে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","যেতিয়া তেওঁলোকৰ মাজত বিবাদ হ’য়, তেতিয়া তেওঁলোক মোৰ ওচৰলৈ আহে। তেতিয়া মই এজনৰ লগত আন জনৰ মীমাংসা কৰোঁ; আৰু মই ঈশ্বৰৰ বিধি আৰু ব্যৱস্থাবোৰ তেওঁলোকক বুজাই দিওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","তেতিয়া মোচিৰ শহুৰেকে মোচিক ক’লে, “তুমি যি কাৰ্য কৰি আছা সেই কাৰ্য বৰ ভাল নহয়। ");
INSERT INTO asmfb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","এই দায়িত্ব তোমাৰ বাবে ভাৰস্বৰূপ হৈছে, সেয়ে তুমি অকলে বহন কৰিব নোৱাৰিবা। এইদৰে কৰিলে তুমি আৰু তোমাৰ ওচৰলৈ অহা লোকসকল নিশ্চয় ভাগৰি পৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","মোৰ কথা শুনা, মই তোমাক পৰামৰ্শ দিম, আৰু ঈশ্বৰ তোমাৰ লগত থাকক; কাৰণ তুমি ঈশ্বৰৰ সন্মুখত লোকসকলৰ প্ৰতিনিধি হৈ, তেওঁলোকৰ বিবাদৰ কথা ঈশ্বৰৰ ওচৰত জনোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","তুমি তেওঁলোকক তেওঁৰ বিধি আৰু ব্যৱস্থাবোৰ শিকোৱা উচিত। তেওঁলোকে চলিবলগীয়া পথ আৰু কৰিবলগীয়া কার্য তেওঁলোকক দেখুৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","তুমি এই লোকসকলৰ মাজৰ পৰা সক্ষম, ঈশ্বৰক সন্মান কৰা, আৰু অন্যায় ঘৃণা কৰা, সত্যবাদী লোকক মনোনীত কৰা। লোকসকলৰ ওপৰত তেওঁলোকক সহস্ৰপতি, শতপতি, পঞ্চাশপতি, আৰু দশপতি নিযুক্ত কৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","তেওঁলোকে লোকসকলৰ সকলো সাধাৰণ বিষয়বোৰৰ সোধ-বিচাৰ কৰিব; কিন্তু কঠিন বিষয়বোৰ বিচাৰৰ বাবে তোমাৰ ওচৰলৈ আনিব। সকলো সাধাৰণ বিষয়ৰ বিচাৰ তেওঁলোকে নিজেই কৰিব। এইদৰে কৰিলে তোমাৰ কাৰণে সহজ হ’ব; আৰু তেওঁলোকে তোমাৰ সৈতে ভাৰ বহন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","তুমি যদি এইদৰে কাৰ্য কৰা, আৰু ঈশ্বৰে যদি তোমাক এইদৰে কৰিবলৈ আজ্ঞা দিয়ে, তেতিয়া তুমি সহ্য কৰিব পাৰিবা, আৰু লোকসকল সন্তুষ্ট হৈ নিজৰ ঘৰলৈ যাব পাৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","সেয়ে মোচিয়ে তেওঁৰ শহুৰেকৰ কথা শুনিলে, আৰু তেওঁ কোৱাৰ দৰেই সকলো কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","মোচিয়ে সকলো ইস্ৰায়েলৰ মাজৰ পৰা সক্ষম লোকসকলক মনোনীত কৰি, লোকসকলৰ ওপৰত সহস্ৰপতি, শতপতি, পঞ্চাশপতি, আৰু দশপতি, এইদৰে প্ৰধান লোক নিযুক্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","তেওঁলোকে সাধাৰণ পৰিস্থিতিত লোকসকলৰ বিচাৰ কৰিছিল। কঠিন বিষয়বোৰ তেওঁলোকে মোচিৰ ওচৰলৈ আনিছিল; কিন্তু সাধাৰণ বিষয়বোৰ তেওঁলোকে নিজে বিচাৰ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","তাৰ পাছত মোচিয়ে শহুৰেকক বিদায় দিলে, আৰু যিথ্রো তেওঁৰ নিজৰ দেশলৈ গুচি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ইস্ৰায়েলৰ লোকসকল তৃতীয় মাহত মিচৰ দেশৰ পৰা ওলাই যোৱাৰ পাছত, সেই দিনাই তেওঁলোক চীনয় মৰুভূমি আহি পালে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","তেওঁলোকে ৰফীদীমৰ পৰা যাত্ৰা কৰি চীনয় মৰুভূমিলৈ অহাৰ পাছত, মৰুভূমিত পৰ্ব্বতৰ সন্মুখত তম্বু তৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","মোচি ঈশ্বৰৰ ওচৰলৈ উঠি গ’ল। যিহোৱাই পৰ্ব্বতৰ পৰা তেওঁক মাত লগাই ক’লে, “তুমি যাকোবৰ বংশক আৰু ইস্ৰায়েলী লোকসকলক নিশ্চয়কৈ কোৱা: ");
INSERT INTO asmfb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","মই মিচৰীয়া লোকসকললৈ যি কৰিলোঁ, আৰু কেনেকৈ কুৰৰ পক্ষীৰ ডেউকাৰ দ্বাৰাই, তোমালোকক মোৰ ওচৰলৈ আনিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","এতিয়া যদি তোমালোকে বাধ্যতাৰে মোৰ কথা শুনা, আৰু মোৰ নিয়মটি পালন কৰা, তেতিয়াহে তোমালোক সকলো লোকৰ মাজৰ পৰা লোৱা মোৰ বিশেষ অধিকাৰ প্রাপ্ত লোক হ’বা; কাৰণ সমূদায় পৃথিৱী মোৰেই। ");
INSERT INTO asmfb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","মোৰ বাবে তোমালোক ৰাজকীয় পুৰোহিত আৰু পবিত্ৰ জাতি হ’বা। এই সকলো কথা তুমি ইস্ৰায়েলী লোকসকলক ক’ব লাগে।” ");
INSERT INTO asmfb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","সেয়ে মোচিয়ে আহি লোকসকলৰ পৰিচাৰক সকলক মাতিলে। যিহোৱাই তেওঁক দিয়া সকলো আজ্ঞা তেওঁলোকৰ আগত প্রকাশ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","সকলো লোকে একেলগে উত্তৰ দি ক’লে, “যিহোৱাই যি কৈছে, সেইবোৰ আমি কৰিম।” তেতিয়া মোচিয়ে যিহোৱাৰ আগত লোকসকলে কোৱা কথা জনালে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","যিহোৱাই মোচিক ক’লে, “মই ঘন মেঘৰ মাজত তোমাৰ ওচৰলৈ আহিম; আৰু মই যেতিয়া তোমাৰ লগত কথা পাতিম, তেতিয়া যেন লোকসকলে সেই কথা শুনিবলৈ পাই; আৰু তোমাকো যেন তেওঁলোকে সদায় বিশ্বাস কৰিব পাৰে।” তেতিয়া মোচিয়ে যিহোৱাৰ আগত লোকসকলৰ কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","যিহোৱাই মোচিক ক’লে, “লোকসকলৰ ওচৰলৈ যোৱা। আজি আৰু কাইলৈ তেওঁলোকক পবিত্ৰ কৰিবা, আৰু তেওঁলোকক নিজৰ কাপোৰ ধুই, মই অহাৰ বাবে তেওঁলোকক যুগুত কৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","তৃতীয় দিনৰ বাবে প্রস্তুত হোৱা, তৃতীয় দিনৰ দিনা মই যিহোৱা, চীনয় পৰ্ব্বতলৈ নামি আহিম। ");
INSERT INTO asmfb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","তুমি লোকসকলৰ বাবে পৰ্ব্বতৰ চাৰিওফালে সীমা নিৰূপন কৰা। তেওঁলোকক কোৱা, ‘সাৱধান হওক; আপোনালোক পৰ্ব্বতৰ ওপৰলৈ উঠি নাযাব, আৰু তাৰ সীমাও স্পৰ্শ নকৰিব। যিজনে পৰ্ব্বত স্পৰ্শ কৰিব, তেওঁক অৱশ্যেই প্ৰাণদণ্ড দিয়া হ’ব।’ ");
INSERT INTO asmfb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","সেই লোকক কোনেও হাতেৰে স্পৰ্শ নকৰিব। তাৰ পৰিৱৰ্তে, তেওঁলৈ শিল দলিওৱা হ’ব বা কাঁড় মৰা হ’ব। পশুৱেই হওক, বা মানুহেই হওক, তেওঁ নিশ্চয় মৃত্যুদণ্ড পাব। যেতিয়া দীঘল কৈ শিঙা বাজিব, তেতিয়া তেওঁলোক পৰ্ব্বতৰ নামনিলৈ নামি আহিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","তেতিয়া মোচিয়ে পৰ্ব্বতৰ পৰা লোকসকলৰ ওচৰলৈ নামি আহিল। তেওঁ লোকসকলক পবিত্ৰকৃত কৰিলে; আৰু তেওঁলোকে নিজৰ নিজৰ কাপোৰবোৰ ধুলে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","তেওঁ লোকসকলক ক’লে, “আপোনালোক তৃতীয় দিনৰ বাবে যুগুত হওক; আৰু আপোনালোকৰ ভাৰ্যাৰ ওচৰলৈ নাযাব।” ");
INSERT INTO asmfb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","তৃতীয় দিনা ৰাতি পুৱা, মেঘ-গৰ্জ্জন, বিজুলী, পৰ্ব্বতৰ ওপৰত ঘন মেঘ, আৰু উচ্চ শিঙা-ধ্বনি হ’ল। তাতে তম্বুত থকা সকলো লোক কঁপিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","মোচিয়ে ঈশ্বৰক ল’গ ধৰিবলৈ লোকসকলক তম্বুৰ পৰা উলিয়াই আনিলে; আৰু তেওঁলোক পৰ্ব্বতৰ নামনিত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","যিহোৱা চীনয় পৰ্ব্বতৰ ওপৰলৈ অগ্নিত নামি অহাত, গোটেই পৰ্ব্বত ধোঁৱাময় হ’ল; আৰু অগ্নিকুণ্ডৰ ধোঁৱাৰ নিচিনাকৈ তাৰ ধোঁৱা উঠিল। সেয়ে গোটেই পৰ্ব্বত বৰকৈ কঁপিব ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","শিঙাৰ উচ্চ ধ্বনি যেতিয়া ক্রমে ক্রমে বাঢ়ি গ’ল, তেতিয়া মোচিয়ে কথা ক’লে, আৰু ঈশ্বৰে আকাশী-বাণীৰে তেওঁক উত্তৰ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","এইদৰে যিহোৱা চীনয় পৰ্ব্বতৰ ওপৰলৈ নামি আহিল; আৰু মোচিক ওপৰলৈ মাতিলে। সেয়ে মোচি উঠি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","যিহোৱাই মোচিক ক’লে, “লোকসকলে মোক চাবৰ বাবে যেন সীমা লঙ্ঘন কৰি নাহে, আৰু তেওঁলোকৰ অনেক লোক যেন বিনষ্ট নহয়, সেই বাবে তুমি নামি গৈ তেওঁলোকক সাৱধান কৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","যি পুৰোহিতসকল মোৰ ওচৰলৈ আহে, তেওঁলোকক পৃথক কৰা; যিহোৱাই যেন তেওঁলোকক আক্ৰমণ নকৰে, সেই বাবে তেওঁলোকে নিজকে পবিত্ৰকৃত কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","মোচিয়ে যিহোৱাক ক’লে, “লোকসকল চীনয় পৰ্ব্বতৰ ওপৰলৈ আহিব নোৱাৰে; কাৰণ, আপুনি আমাক আজ্ঞা কৰিছে: ‘বিশেষভাৱে যিহোৱাৰ গৌৰৱৰ অৰ্থে পৰ্ব্বতৰ সীমা নিৰূপণ কৰি তাক পবিত্ৰ কৰিবলৈ’।” ");
INSERT INTO asmfb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","তেতিয়া যিহোৱাই মোচিক ক’লে, “তুমি পৰ্ব্বতৰ পৰা নামি যোৱা; আৰু হাৰোণক তোমাৰ লগত লৈ আহাঁ; কিন্তু পুৰোহিত আৰু লোকসকলক সীমা অতিক্রম কৰিব নিদিবা। নহ’লে মই তেওঁলোকক আক্ৰমণ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","সেয়ে মোচিয়ে লোকসকলৰ ওচৰলৈ নামি গ’ল, আৰু তেওঁলোকৰ আগত সেই কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ঈশ্বৰে এই সকলো কথা ক’লে: ");
INSERT INTO asmfb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“মই যিহোৱা, তোমালোকৰ ঈশ্বৰ, মিচৰ দেশৰ বন্দীঘৰৰ পৰা উলিয়াই অনা তোমালোকৰ ঈশ্বৰ যিহোৱা ময়েই। ");
INSERT INTO asmfb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","মোৰ আগত তোমালোকৰ আন কোনো দেৱতা নাথাকক। ");
INSERT INTO asmfb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","তোমালোকে নিজৰ বাবে, স্বৰ্গত থকা, অথবা পৃথিবীত থকা, বা পানীৰ তলত থকা কোনো আকৃতিৰ মূৰ্ত্তি নাসাজিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","সেইবোৰৰ আগত তোমালোকে প্ৰণিপাত নকৰিবা, আৰু সেইবোৰক সেৱাপূজাও নকৰিবা; কাৰণ মই যিহোৱা, তোমালোকৰ ঈশ্বৰ। মই ঈৰ্ষাম্বিত ঈশ্বৰ। মোক ঘৃণা কৰা লোকসকলৰ সন্তানসকলক তেওঁলোকৰ পিতৃসকলৰ অপৰাধৰ শাস্তি মই তৃতীয় চতুৰ্থ পুৰুষলৈকে দিওঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","কিন্তু মোক প্ৰেম কৰা আৰু মোৰ আজ্ঞা পালন কৰা সকলক মই মোৰ বিশ্বাসযোগ্য চুক্তি হাজাৰ হাজাৰ পুৰুষলৈকে দেখাও। ");
INSERT INTO asmfb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","তোমালোকে তোমালোকৰ ঈশ্বৰ যিহোৱাৰ নাম অনৰ্থকৰূপে নলবা; কিয়নো, যি কোনোৱে তেওঁৰ নাম অনৰ্থকৰূপে লয়, যিহোৱাই তেওঁক নিৰ্দ্দোষী নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","মোৰ উদ্দেশ্যে বিশ্ৰাম-দিন সোঁৱৰণ কৰি পবিত্ৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ছয় দিন পৰিশ্ৰম কৰি তোমালোকে সকলো কাৰ্য কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","কিন্তু সপ্তম দিন তোমালোকৰ ঈশ্বৰ যিহোৱাৰ উদ্দেশ্যে বিশ্ৰাম-দিন। সেই দিনা তোমালোকে, অথবা তোমালোকৰ পুত্র, ছোৱালী, বা তোমালোকৰ দাস, বা দাসী, বা তোমালোকৰ পশু, বা তোমালোকৰ দুৱাৰৰ ভিতৰত থকা বিদেশী, কোনোৱে একো কাম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","কাৰণ, মই যিহোৱাই আকাশ-মণ্ডল, পৃথিৱী, সমুদ্ৰ, আৰু সেইবোৰত থকা সকলোকে ছয় দিনত নিৰ্মাণ কৰিলোঁ, আৰু তাৰ পাছত সপ্তম দিনা বিশ্ৰাম কৰিলোঁ; এই হেতুকে মই যিহোৱাই মোৰ উদ্দেশ্যে বিশ্ৰাম-দিনক আশীৰ্ব্বাদ কৰি পবিত্ৰ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","তোমালোকৰ ঈশ্বৰ যিহোৱাই তোমালোকক যি দেশ দিছে, সেই দেশত তোমালোকৰ আয়ুস দীঘল হ’বলৈ, তোমালোকে তোমালোকৰ পিতৃ-মাতৃক সন্মান কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","নৰ-বধ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","কোনো লোকৰ সৈতে ব্যভিচাৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","কাৰো পৰা চুৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","তোমালোকে তোমালোকৰ চুবুৰীয়াৰ অহিতে মিছা সাক্ষ্য নিদিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","তোমালোকে তোমালোকৰ চুবুৰীয়াৰ ঘৰলৈ লোভ নকৰিবা; তোমালোকে তোমালোকৰ চুবুৰীয়াৰ ভার্যালৈ লোভ নকৰিবা, অথবা তেওঁৰ দাস, তেওঁৰ দাসী, তেওঁৰ গৰু, তেওঁৰ গাধ, বা তেওঁৰ আন কোনো বস্তুলৈকে লোভ নকৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","তেতিয়া লোকসকলে মেঘ-গৰ্জ্জন, বিজুলী, শিঙাধ্বনি, আৰু পৰ্ব্বত ধোঁৱাময় হোৱা দেখিলে। লোকসকলে এইদৰে হোৱা দেখি ভয়ত কম্পমান হৈ তেওঁলোক দূৰত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","তেওঁলোকে মোচিক ক’লে, “আপুনিয়ে আমাক কথা কওক; আমি শুনিম। কিন্তু আমাৰ সৈতে ঈশ্বৰক কথা ক’বলৈ নিদিব, নহ’লে আমি মৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","তেতিয়া মোচিয়ে তেওঁলোকক ক’লে, “ভয় নকৰিব; আপোনালোকে যেন ঈশ্বৰলৈ ভয়ভক্তি ৰাখে আৰু পাপ নকৰে, সেই বাবে আপোনালোকক পৰীক্ষা কৰিবলৈ তেওঁ আপোনালোকৰ ওচৰলৈ আহিল।” ");
INSERT INTO asmfb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","সেয়ে লোকসকল দূৰত থিয় হৈ আছিল; কিন্তু মোচিয়ে যি ঠাইত ঈশ্বৰ আছিল, সেই ঘোৰ অন্ধকাৰৰ ফালে গতি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","যিহোৱাই মোচিক ক’লে, “তুমি ইস্ৰায়েলী লোকসকলক এই কথা কবা: ‘মই যে স্বৰ্গৰ পৰা তোমালোকৰ সৈতে কথা পাতিলোঁ, তোমালোকে নিজেই তাক দেখিলা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","তোমালোকে মোৰ কাষত তোমালোকৰ বাবে আন কোনো ৰূপৰ বা সোণৰ দেৱমূৰ্তি নাসাজিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","তোমালোকে মোৰ অৰ্থে মাটিৰ যজ্ঞবেদী নিৰ্মাণ কৰিবা, আৰু তাৰ ওপৰতে তোমালোকৰ হোম-বলি, সমজুৱা বলি, মেৰ-ছাগ, আৰু ষাঁড়গৰুবোৰ উৎসৰ্গ কৰিবা। যি ঠাইবোৰত মই মোৰ নাম গৌৰৱম্বানিত কৰিম, সেই সকলো ঠাইতে মই তোমাৰ ওচৰলৈ আহি তোমাক আশীৰ্ব্বাদ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","তুমি যদি মোৰ অৰ্থে শিলৰ যজ্ঞবেদী নিৰ্মাণ কৰা, তেনেহলে তুমি সেই বেদী কটা-শিলেৰে নিৰ্মাণ নকৰিবা; কাৰণ তাৰ ওপৰত যদি তুমি তোমাৰ অস্ত্ৰ লগোৱা, তেন্তে তুমি তাক অপবিত্ৰহে কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","তোমাৰ গোপনীয় অংশ যেন দেখা নাযায়, সেই বাবে মোৰ যজ্ঞবেদীলৈ তুমি খটখটিয়েদি নাযাবা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“তুমি যিবোৰ বিধি তেওঁলোকৰ আগত প্ৰকাশ কৰিবা, সেয়ে এই: ");
INSERT INTO asmfb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘তুমি যদি কোনো ইব্ৰীয়া দাস কিনি লোৱা, তেওঁ ছয় বছৰৰ বাবে সেৱা কৰিব; কিন্তু সপ্তম বছৰত তেওঁ বিনামূল্যে মুক্ত হৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","তেওঁ যদি নিজে আহে, তেনেহ’লে তেওঁ নিজেই মুক্ত হৈ যাব। তেওঁ যদি বিবাহিত হয়, তেনেহ’লে তেওঁৰ ভাৰ্যা তেওঁৰে সৈতে মুক্ত হৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","যদি তেওঁৰ মালিকে তেওঁক বিয়া কৰাই দিয়ে, আৰু তেওঁ ল’ৰা বা ছোৱালী জন্ম দিয়ে, তেনেহ’লে সেই ভাৰ্যা আৰু তেওঁৰ সন্তান সকল মালিকৰ স্বত্বত থাকিব, আৰু তেওঁ নিজেই মুক্ত হৈ যাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","সেই দাসে যদি স্পষ্টৰূপে কয়, ‘মই মোৰ মালিকক, মোৰ ভাৰ্যাক, আৰু মোৰ সন্তানসকলক প্ৰেম কৰোঁ, সেয়ে মই মুক্ত হৈ নাযাওঁ’। ");
INSERT INTO asmfb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","তেতিয়া তেওঁৰ মালিকে তেওঁক ঈশ্বৰৰ ওচৰলৈ আনিব লাগিব। মালিকে তেওঁক দুৱাৰ বা দুৱাৰৰ চৌকাঠৰ দুই দাঁতিৰ এডাললৈ আনি, তেওঁৰ মালিকে বেজিৰে তেওঁৰ কাণ ফুটা কৰিব লাগিব। তেতিয়াহে দাস জনে গোটেই জীৱন তেওঁৰ মালিকৰ সেৱা কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","কোনো মানুহে যদি নিজৰ জীয়েকক দাসী হ’বলৈ বিক্রী কৰে, তেনেহ’লে দাসৰ দৰে তেওঁ মুক্ত হৈ যাব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","যিজনে তাইক নিজৰ কাৰণে মনোনীত কৰি লয়; সেই মালিকক যদি তাই সন্তুষ্ট কৰিব নোৱাৰে, তেনেহ’লে তেওঁ তাইক ঘূৰাই পঠিয়াব লাগিব। তেওঁ তাইক বিদেশীক বেচিবৰ অধিকাৰ নাথাকিব। তাইক প্রতাৰণা কৰাৰ কাৰণে তেওঁৰ সেই অধিকাৰ নাথাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","তাইৰ মালিকে যদি তাইক নিজৰ পুত্রৰ বাবে ভাৰ্যা কৰি লয়, তেনেহ’লে তেওঁ তাইক নিজৰ জীয়েকৰ দৰে ব্যৱহাৰ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","তেওঁ যদি নিজৰ বাবে আন এগৰাকী ভাৰ্যা আনে, তেনেহ’লে তেওঁ তাইৰ অন্ন, বস্ত্ৰ, আৰু বিবাহৰ অধিকাৰৰ বিষয়ে ত্রুটি কৰিব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","কিন্তু যদি তেওঁ তাইলৈ এই তিনিওটা বিষয়ত ত্ৰুটি কৰে, তেনেহ’লে তাই বিনামূল্যে মুক্ত হৈ যাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","কোনো মানুহে যদি কোনো মানুহক মাৰোতে তেওঁৰ মৃত্যু হয়; তেনেহ’লে সেই ব্যক্তিৰ অৱেশ্যে প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","কোনো মানুহে যদি পূৰ্বপৰিকল্পনা নকৰাকৈ মাৰোতে আকস্মিকভাৱে কাৰো মৃত্যু হয়; তেনেহ’লে তেওঁ পলাই যাব পৰা ঠাই মই নিৰূপণ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","যদি কোনোবাই ছলেৰে দুঃসাহিয়াল হৈ কোনো লোকক বধ কৰে, তেনেহ’লে তেওঁক প্ৰাণদণ্ড দিবৰ বাবে, ঈশ্বৰৰ যজ্ঞবেদীত থাকিলেও তেওঁক লৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","যি কোনোৱে নিজৰ পিতৃ বা মাতৃক প্ৰহাৰ কৰে, তেওঁৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","কোনোৱে যদি কোনো মানুহক অপহৰণ কৰি বিক্রী কৰে বা সেই মানুহক যদি অপহৰণকাৰীৰ হাতত পোৱা যায়, তেনেহ’লে তেওঁৰো অৱশ্যে প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","যি কোনোৱে নিজৰ পিতৃ বা মাতৃক শাও দিয়ে, তেওঁৰ অৱশ্যেই প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","লোকসকলে বিবাদ কৰোঁতে, এজনে আন জনক শিল দলিয়ালে বা ভুকু মাৰিলে, তেওঁ যদি নমৰি শয্যাগত হয়, ");
INSERT INTO asmfb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","তাৰ পাছত তেওঁ সুস্থ হৈ লাখুটি ধৰি খোজ কাঢ়িব পৰা হয়, তেতিয়া সেই ব্যক্তিৰ নষ্ট হোৱা সময় আৰু সম্পূৰ্ণ সুস্থতাৰ কাৰণে প্ৰহাৰ কৰা জনে তাৰ মূল্য দিব লাগিব। কিন্তু সেই প্রহাৰক জন হত্যাকাৰী বুলি বিবেচিত নহব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","কোনোৱে নিজৰ দাস বা দাসীক লাখুটিৰে মাৰোঁতে, তেওঁৰ যদি মৃত্যু হয়, তেনেহ’লে তেওঁ অৱশ্যে শাস্তি পাব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","তথাপিও তেওঁ যদি এদিন বা দুদিন জীয়াই থাকে, তেনেহ’লে তেওঁ শাস্তি নাপায়; কাৰণ তেওঁ তেওঁৰ দাস হেৰোৱাই কষ্ট ভুগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","পুৰুষসকলে ইজনে সিজনৰ লগত বিবাদ কৰোঁতে যদি কোনো গৰ্ভৱতী মহিলাই আঘাত পাই তেওঁৰ গৰ্ভপাত হয়, কিন্তু তেওঁৰ যদি আন কোনো ঠাইত আঘাত নহয়, তেনেহ’লে দোষী পুৰুষজনে জৰিমনা দিব লাগিব। সেই মহিলাৰ স্বামীয়ে যদি তেওঁৰ পৰা জৰিমনা বিচাৰে, তেনেহ’লে বিচাৰকৰ্ত্তাসকলে নিৰূপন কৰা অনুসাৰে জৰিমনা দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","কিন্তু যদি গভীৰ আঘাত হয়, তেনেহ’লে প্ৰাণৰ সলনি প্ৰাণ, ");
INSERT INTO asmfb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","চকুৰ সলনি চকু, দাঁতৰ সলনি দাঁত, হাতৰ সলনি হাত, ভৰিৰ সলনি ভৰি, ");
INSERT INTO asmfb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","জুইৰ আঘাতৰ সলনি জুইৰ আঘাত, আঘাতৰ সলনি আঘাত, বা থেতেলা খোৱাৰ সলনি থেতেলা খোৱা, দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","কোনো লোকে যদি নিজৰ দাস বা দাসীৰ চকুত আঘাত কৰোঁতে চকু নষ্ট হয়, তেনেহ’লে তেওঁৰ চকুৰ বাবে তেওঁক ক্ষতিপূৰণ দি মুক্ত কৰি পঠাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","তেওঁ যদি মাৰোঁতে নিজৰ দাস বা দাসীৰ দাঁত সৰে, তেনেহ’লে সেই দাঁতৰ কাৰণে ক্ষতিপূৰণ দি তেওঁ তেওঁক মুক্ত কৰি পঠাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","কোনো গৰুৱে যদি কোনো পুৰুষ বা মহিলাক শিঙেৰে খোঁচোতে, তেওঁৰ মৃত্যু হয়, তেনেহ’লে লোকসকলে সেই গৰুটোক অৱশ্যে শিল দলিয়াই বধ কৰিব। সেই গৰুৰ মাংস খাব নোৱাৰিব; কিন্তু গৰুৰ গৰাকী সেই দোষত নির্দোষী হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","কিন্তু যদি সেই গৰুৱে আগেও শিঙেৰে খোঁচাৰ অভ্যাস আছে, আৰু গৰাকীক সেই বিষয়ে সাৱধান কৰি দিয়াৰ পাছতো যদি গৰাকীয়ে গৰুটোক সাৱধানে নাৰাখে, আৰু সেই গৰুৱে যদি কোনো পুৰুষ বা মহিলাক খুচি মাৰে, তেনেহ’লে সেই গৰুটোক শিল দলিয়াই বধ কৰা হ’ব, লগতে গৰুটোৰ গৰাকীকো প্ৰাণদণ্ড দিয়া হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","তেওঁৰ পৰা যদি মূল্য বিচাৰা হয়, তেনেহ’লে তেওঁ দিবলগীয়া মূল্য দিবই লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","সেই গৰুৱে যদি কোনো লোকৰ পুত্র বা জীয়েকক খোঁচে, তেনেহ’লে এই নিয়ম অনুসাৰেই গৰুৰ গৰাকীয়ে তেওঁলৈ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","সেই গৰুৱে যদি কোনো লোকৰ দাস বা দাসীক খোঁচে, তেনেহ’লে গৰুৰ গৰাকীয়ে ত্ৰিশ চেকল ৰূপ দিব লাগিব, আৰু গৰুটোক শিল দলিয়াই বধ কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","কোনো লোকে যদি গাত মুকলি কৰি ৰাখে, বা গাত খানি তাক ঢাকি নথয়, আৰু সেই গাতত যদি কোনো গৰু বা গাধ পৰে, ");
INSERT INTO asmfb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","তেনেহ’লে সেই গাতৰ গৰাকীয়ে ক্ষতিপূৰণ দিব লাগিব। তেওঁ মৃত জন্তুটোৰ গৰাকীক ধন দিব লাগিব, কিন্তু সেই মৃত জন্তুটো তেওঁৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","এজনৰ গৰুৱে যদি আন জনৰ গৰুক খোঁচোতে, সেই গৰু মৰে, তেনেহ’লে তেওঁলোকে জীয়াই থকা গৰুটো বেচি তাৰ মূল্য দুভাগ কৰিব, আৰু সেই মৰা গৰুটোকো দুভাগ কৰি লব। ");
INSERT INTO asmfb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","কিন্তু যদি সেই গৰুৱে আগেও খোঁচাৰ অভ্যাস আছে, আৰু সেই কথা গৰাকীয়ে জানিবলৈ পায়ো গৰুটোক সাৱধানে নেৰাখে, তেনেহ’লে তেওঁ সেই গৰুৰ সলনি আন গৰু দি ক্ষতিপূৰণ কৰিব লাগিব, আৰু মৰা গৰুটো তেওঁৰ নিজৰ হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","কোনো লোকে যদি গৰু বা মেৰ-ছাগ চুৰ কৰি বধ কৰে অথবা বিক্রী কৰে, তেনেহ’লে তেওঁ এটা গৰুৰ সলনি পাঁচটা গৰু, আৰু এটা মেৰ-ছাগৰ সলনি চাৰিটা মেৰ-ছাগ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","চোৰে সিন্ধি দিওঁতে যদি ধৰা পৰে, আৰু তেওঁক প্ৰহাৰ কৰোঁতে যদি তেওঁ মৰে, তেনেহ’লে তেওঁৰ ৰক্তপাতৰ দোষত কোনো লোকক হত্যাকাৰী বুলি গণিত কৰা নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","কিন্তু যদি সিন্ধি দিয়াৰ আগতে সূৰ্য উদয় হয়, তেনেহ’লে তেওঁৰ ৰক্তপাতৰ দোষত হত্যাকাৰীজন দোষী হ’ব। চোৰে অৱশ্যে ক্ষতিপূৰণ কৰিবই লাগিব। তেওঁৰ যদি একো নাথাকে, তেনেহ’লে চোৰি কাৰ্যৰ বাবে তেওঁ নিজে বেচা যাব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","চোৰে চুৰ কৰা গৰু, গাধ, বা মেৰ-ছাগ, যদি তেওঁৰ হাতত জীয়াই থকা পোৱা যায়, তেনেহ’লে তেওঁ তাৰ পৰিৱৰ্তে দুগুণ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","কোনো লোকে যদি শস্য-ক্ষেত্ৰত বা দ্ৰাক্ষাবাৰীত পশু চৰায় বা নিজৰ পশু মেলি দিওঁতে যদি আনৰ পথাৰত গৈ চৰে, তেনেহ’লে তেওঁ নিজৰ পথাৰৰ উত্তম শস্য, বা নিজৰ দ্ৰাক্ষাবাৰীৰ উত্তম ফল দি ক্ষতিপূৰণ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","জুই বিস্তাৰিত হৈ কাঁইটনিত লাগি যদি কোনো লোকৰ দমাই থোৱা শস্য, বা পথাৰৰ শস্য, বা পথাৰ গ্রাস কৰে, তেনেহ’লে যি জনে সেই জুই লগাবলৈ আৰম্ভ কৰিছিল, তেওঁ অৱশ্যে ক্ষতিপূৰণ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","কোনো লোকে যদি ধন বা বস্তু আন লোকৰ হাতত থ’বলৈ দিয়ে, আৰু সেয়ে যদি সেই লোকৰ ঘৰৰ পৰা চুৰি হয়, তেনেহ’লে চোৰ ধৰা পৰিলে, চোৰে তাৰ দুগুণ লাগিব দিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","কিন্তু যদি চোৰ ধৰা নপৰে, তেনেহ’লে চুবুৰীয়াৰ সম্পতিৰ ওপৰত তেওঁ হাত দিছে নে নাই সেই কথা প্রমান কৰিবলৈ ঘৰৰ গৰাকী বিচাৰকৰ্ত্তাৰ ওচৰলৈ যাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","কোনো বস্তুৰ বাবে হোৱা সকলো বিবাদ, যেনে গৰু, গাধ, মেৰ-ছাগ বা কাপোৰ আদি যি কোনো হেৰোৱা বস্তুৰ বিষয়ে “এই বস্তু মোৰ” বুলি কোৱা দুয়ো পক্ষৰ লোক বিচাৰকৰ্ত্তাৰ ওচৰলৈ আহিব লাগিব। এই বিষয়ত বিচাৰকৰ্ত্তাই যিজনক দোষী সাব্যস্ত কৰিব, তেওঁ তেওঁৰ চুবুৰীয়াক তাৰ দুগুণ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","কোনো লোকে যদি নিজৰ চুবুৰীয়াক এটা গাধ বা গৰু, বা মেৰ-ছাগ বা আন কোনো পশু ৰাখিবলৈ দিয়ে, আৰু কোনোৱে নেদেখাকৈ সেই পশু মৰে, বা আঘাত পায়, অথবা কোনোৱে যদি লৈ যায়, ");
INSERT INTO asmfb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","তেনেহ’লে মই চুবুৰীয়াৰ বস্তুত হাত দিয়া নাই, এই বুলি এজনে আন জনৰ আগত যিহোৱাৰ নামেৰে শপত খাব। পশুৰ গৰাকীয়ে সেই শপতত মান্তি হ’ব লাগিব; আৰু আন জনে তাৰ বাবে ক্ষতিপূৰণ দিব নালাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","কিন্তু যদি সেই পশু তেওঁৰ ঘৰৰ পৰা চুৰি হয়, তেনেহ’লে তেওঁ তাৰ গৰাকীক ক্ষতিপূৰণ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","যদি কোনো জন্তুৱে সেই পশুটো ছিন্ন বিছিন্ন কৰি টুকুৰা কৰে, তেনেহ’লে আনজনে প্ৰমাণৰ বাবে পশুটোক আনিব লাগে। তেওঁ ছিৰা পশুৰ বাবে ক্ষতিপূৰণ দিব নালাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","কোনো লোকে যদি চুবুৰীয়াৰ কোনো পশু ধাৰত আনে, আৰু গৰাকী নথকা অৱস্থাত সেই পশুটোৱে আঘাত পায়, বা মৰে, তেনেহ’লে তেওঁ অৱশ্যে ক্ষতিপূৰণ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","কিন্তু যদি গৰাকী পশুটোৰ লগত থাকে, তেনেহ’লে তেওঁ ক্ষতিপূৰণ দিব নালাগিব; পশুটো যদি ভাড়াত অনা হয়, তেনেহ’লে তাৰ বাবে ভাড়াৰ মূল্য দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","কোনো লোকে যদি তেওঁলৈ বাগ্দান নকৰা কুমাৰী যুৱতীৰ সৈতে শয়ন কৰে, তেনেহ’লে ইয়াৰ বাবে তেওঁ অৱশ্যেই যুৱতী গৰাকীৰ গা ধন দি তেওঁক নিজৰ ভাৰ্যা কৰি ল’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","যদি যুৱতী গৰাকীৰ পিতৃয়ে সেই লোকজনলৈ বিয়া দিবলৈ অসন্মত হয়, তেনেহ’লে তেওঁ যুৱতী গৰাকীৰ কুমাৰীত্বৰ গা-ধন অনুসাৰে ধন দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","তোমালোকে মায়াকৰ্ম কৰা সকলক জীয়াই থাকিব নিদিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","পশুৰ সৈতে যৌন সম্পৰ্ক কৰা লোকক অৱশ্যে প্ৰাণদণ্ড দিয়া হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","যি জনে যিহোৱাৰ বাহিৰে আন কোনো দেৱতাৰ আগত বলিদান কৰে, তেওঁ নিঃশেষে বিনষ্ট হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","তোমালোকে বিদেশীক অন্যায় নকৰিবা, আৰু তেওঁলোকক উপদ্ৰৱ নকৰিবা; কিয়নো মিচৰ দেশত তোমালোকো বিদেশী হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","তোমালোকে বিধৱা আৰু পিতৃহীন সন্তানক বেয়া ব্যৱহাৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","তেওঁলোকক যদি তোমালোকে কষ্ট দিয়া, আৰু তেওঁলোকে যদি মোৰ আগত কাতৰোক্তি কৰে, তেনেহ’লে মই যিহোৱাই অৱশ্যে তেওঁলোকৰ কাতৰোক্তি শুনিম। ");
INSERT INTO asmfb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","মোৰ ক্ৰোধ প্ৰজ্বলিত হ’ব, আৰু মই তোমালোকক তৰোৱালেৰে বধ কৰিম। তোমালোকৰ ভাৰ্যাসকল বিধৱা, আৰু সন্তান সকল পিতৃহীন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","তোমালোকে যদি মোৰ লোকসকলৰ মাজত থকা কোনো দৰিদ্ৰ লোকক ধন ধাৰে দিয়া, তেনেহ’লে তোমালোকে সুতলৈ ধাৰ দিয়া অথবা সুত আদায় কৰা লোকৰ দৰে নহ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","তোমালোকে যদি কেতিয়াবা তোমালোকৰ চুবুৰীয়াৰ পৰা কাপোৰ বন্ধকত লোৱা, তেনেহ’লে বেলি মাৰ যোৱাৰ আগেয়ে তাক ঘূৰাই দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","কাৰণ সেই কাপোৰখন তেওঁৰ একমাত্র গা ঢকা কাপোৰ; সেই খন নহ’লে তেওঁ কিহত শুব? তেওঁ যেতিয়া মোৰ আগত কাতৰোক্তি কৰিব, তেতিয়া মই তেওঁৰ কাতৰোক্তি শুনিম; কাৰণ মই দয়ালু। ");
INSERT INTO asmfb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","তোমালোকৰ ঈশ্বৰ যি মই, মোক নিন্দা নকৰিবা, নাইবা তোমালোকৰ শাসনকৰ্ত্তাক শাও নিদিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","তোমালোকৰ শস্য, বা পেয় দ্ৰব্যৰ পৰা উৎসৰ্গ কৰিবলৈ তোমালোকে পলম কৰিব নালাগে। তোমালোকৰ প্ৰথমে জন্ম হোৱা পুত্ৰক মোৰ অৰ্থে দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","তোমালোকৰ গৰু আৰু মেৰ-ছাগৰ জাকৰ ক্ষেত্রতো সেইদৰেই কৰিবা। সেই পশুবোৰ সাত দিন নিজৰ মাকৰ লগত থাকিব, কিন্তু অষ্টম দিনা তোমালোকে সেইবোৰ মোক দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","তোমালোক মোৰ উদ্দেশ্যে পবিত্ৰ লোক হ’বা। সেয়ে পথাৰত জন্তুৱে ছিৰা ছিৰ কৰা যিকোনো মাংস তোমালোকে নাখাবা; তাৰ পৰিৱৰ্তে কুকুৰৰ আগত পেলাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","তোমালোকে কোনো লোকৰ অহিতে মিছা কথা নকবা। অন্যায় সাক্ষী দিবলৈ তোমালোকে দুৰ্জন লোকৰ লগত সহযোগ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","তোমালোকে কু-কৰ্ম কৰিবলৈ জনসাধাৰণক অনুসৰণ নকৰিবা; নাইবা অন্যায় বিচাৰ কৰিবলৈ জনসাধাৰণৰ পক্ষত থাকি সিদ্ধান্ত নলবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","তোমালোকে কোনো দৰিদ্র লোকৰ বিচাৰত তেওঁৰ পক্ষ নল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","তোমালোকৰ শত্ৰুৰ গৰু বা গাধ বাট হেৰুওৱা দেখিলে, তোমালোকে অৱশ্যে তাক তেওঁৰ ওচৰলৈ উভতাই লৈ যাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","তোমালোকে যদি তোমালোকক ঘৃণা কৰা কোনো লোকৰ মালবাহী গাধক বস্তুৰ ভৰত মাটিত পৰা দেখা, তেনেহ’লে সেই লোকজনক তোমালোকে এৰি থৈ নাযাবা। তেওঁৰ গাধ, লগতে তেওঁকো নিশ্চয় সহায় কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","তোমালোকে কোনো দৰিদ্ৰ লোকৰ বিচাৰত তেওঁৰ প্রতি অন্যায় বিচাৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","মিছা অভিযোগ দিওঁতে আনলোকৰ সৈতে সহযোগ নকৰিবা, নিৰ্দ্দোষী বা ধাৰ্মিক লোকক হত্যা নকৰিবা; কাৰণ মই দুষ্টলোকক নিৰ্দ্দোষী নকৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","তোমালোকে ভেটী নলবা; কাৰণ ভেঁটীয়ে, ভেঁটীলোৱা সকলক অন্ধ কৰে, আৰু ধাৰ্মিক সকলৰ কথা বিপথগামী কৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","তোমালোকে বিদেশী লোকক উপদ্ৰৱ নকৰিবা; কাৰণ তোমোলোকো মিচৰ দেশত বিদেশী হৈ আছিলা, সেয়ে বিদেশী লোকৰ মনৰ কথা তোমালোকে জানিব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","তোমালোকে তোমালোকৰ মাটিত ছয় বছৰৰ বাবে গুটি সিঁচিবা, আৰু তাত উৎপন্ন হোৱা শস্য চপাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","কিন্তু সপ্তম বছৰত, সেই মাটি ছন পৰি থাকিবলৈ দিবা; সেয়ে তোমালোকৰ মাজৰ দৰিদ্ৰ লোকসকলে খাবলৈ পাব। তেওঁলোকে যি এৰিব, তাক বনৰীয়া পশুবোৰে খাব। এইদৰেই তোমালোকৰ দ্ৰাক্ষাবাৰী আৰু জিতগছৰ বাৰীৰ ক্ষেত্রতো কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","তোমালোকে ছয় দিন নিজৰ কাম কৰিবা, কিন্তু সপ্তম দিনা বিশ্রাম কৰিবা। এইদৰে কৰিবা; যাতে তোমালোকৰ গৰু, গাধ, তোমালোকৰ দাসীৰ পুত্র আৰু যিকোনো বিদেশী লোকে বিশ্রাম ল’ব পাৰিব আৰু সতেজতা লাভ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","মই তোমালোকক যি সকলো কথা কলোঁ, সেই সকলো কথাত মনোযোগ দিবা। তোমালোকে আন দেৱতাবোৰৰ নাম উল্লেখ নকৰিবা, নাইবা তোমালোকৰ মুখৰ পৰা সেইবোৰৰ নাম শুনা নাযাওক। ");
INSERT INTO asmfb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","তোমালোকে প্রতি বছৰত তিনিবাৰ মোৰ অৰ্থে উৎসৱ পালন কৰিবলৈ নিৰ্দ্দিষ্ট স্থানলৈ আহিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","তোমালোকে খমীৰ নিদিয়া পিঠাৰ উৎসৱ পালন কৰিবা। মই দিয়া আজ্ঞা অনুসাৰে, সাত দিন খমীৰ নিদিয়া পিঠা ভোজন কৰিবা। সেই সময়তে এই উদ্দেশ্যৰ কাৰণে নিৰ্দ্দিষ্ট কৰা আবীব মাহত মোৰ সন্মুখত উপস্থিত হ’বা। কাৰণ এই মাহতে তোমালোক মিচৰ দেশৰ পৰা বাহিৰ হৈ আহিলা। কিন্তু তোমালোকে শুদা হাতে মোৰ ওচৰত উপস্থিত হ’ব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","তোমালোকে শস্য দোৱাৰ উৎসৱ, অৰ্থাৎ পথাৰত যি গুটি সিঁচিলা, সেই পৰিশ্রমৰ প্ৰথম ফলৰ উৎসৱ পালন কৰিব লাগিব; আৰু বছৰৰ শেষত তোমালোকে উৎপন্ন কৰা খেতিৰ ফল চপোৱা সময়ত, ফল চপোৱা উৎসৱ পালন কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","তোমালোকৰ পুৰুষসকলে প্রতি বছৰে তিনি বাৰ, যিহোৱাৰ আগত উপস্থিত হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","তোমালোকে খমীৰ দিয়া পিঠাৰে সৈতে বলিৰ তেজ মোলৈ উৎসৰ্গ নকৰিবা। মোৰ উৎসৱৰ সময়ত বলিদান কৰা পশুৰ চৰ্বি গোটেই ৰাতিৰ পৰা ৰাতিপুৱালৈকে অৱশিষ্ট থাকিব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","তোমালোকৰ মাটিৰ প্ৰথম ফলৰ উত্তম ভাগ তোমালোকৰ ঈশ্বৰ যিহোৱাৰ গৃহলৈ আনিবা। ছাগলী পোৱালিৰ মাংস তাৰ মাকৰ গাখীৰৰ লগত নিসিজাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","যাত্রা পথত তোমালোকক সুৰক্ষা দান কৰিবলৈ, আৰু মই যি ঠাই তোমালোকৰ বাবে যুগুত কৰিছোঁ, সেই ঠাইলৈ তোমালোকক লৈ যাবলৈ, মই তোমালোকৰ আগে আগে এজন দূত পঠাম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","তেওঁলৈ মনোযোগী হ’বা আৰু তেওঁক মানি চলিবা। তেওঁক উত্তেজিত নকৰিবা, কাৰণ তেওঁ তোমালোকৰ অপৰাধ ক্ষমা নকৰিব। মোৰ নাম তেওঁত আছে। ");
INSERT INTO asmfb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","তোমালোকে যদি নিশ্চয়ে তেওঁৰ কথা শুনা, আৰু মই যি কলোঁ সেই সকলোকে কৰা, তেনেহ’লে মই তোমালোকৰ শত্ৰুবোৰৰ শত্ৰু আৰু প্রতিদ্বন্দীৰ প্রতিদ্বন্দী হম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","মোৰ দূত তোমালোকৰ আগে আগে যাব, আৰু ইমোৰীয়া, হিত্তীয়া, পৰিজ্জীয়া, কনানীয়া, হিব্বীয়া, আৰু যিবুচীয়া লোকসকলৰ দেশলৈ তোমালোকক লৈ যাব। মই তেওঁলোকক ধ্বংস কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","তোমালোকে তেওঁলোকৰ দেৱতাবোৰৰ আগত প্ৰণিপাত নকৰিবা, সেৱা পূজাও নকৰিবা বা তেওঁলোকে কৰা কাৰ্যৰ দৰে কোনো কাৰ্য নকৰিবা। তাৰ পৰিৱৰ্তে সেইবোৰক সম্পূৰ্ণকৈ বিনষ্ট কৰিবা, আৰু তেওঁলোকৰ শিলৰ স্তম্ভবোৰ একেবাৰে ভাঙি গুড়ি কৰি পেলাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","তোমালোকে নিজৰ ঈশ্বৰ যিহোৱাৰ সেৱা কৰিবা। তোমালোকে এইদৰে কৰিলে মই তোমালোকৰ অন্ন-জলক আশীৰ্ব্বাদ কৰিম। মই তোমালোকৰ মাজৰ পৰা ৰোগ দূৰ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","তোমালোকৰ দেশত কোনো মহিলাৰ গৰ্ভপাত নহ’ব, আৰু কোনো বাঁজী হৈ নাথাকিব। মই তোমালোকক দীর্ঘায়ু দিম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","তোমালোক যি দেশলৈ যাবা সেই দেশৰ লোকসকলৰ মনত মই মোৰ ভয় জন্মাম। তোমালোকে যি লোকসকলক ল’গ পাবা, সেই লোকসকলক মই বধ কৰিম। মই তোমালোকৰ সকলো শত্ৰুবোৰক তোমালোকৰ ভয়ত তোমালোকৰ পৰা দূৰ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","মই তোমালোকৰ আগেয়ে কোদো পঠাম; সেয়ে সেইবোৰে হিব্বীয়া, কনানীয়া, আৰু হিত্তীয়া সকলক তোমালোকৰ আগৰ পৰা খেদি পঠিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","দেশ যেন পৰিত্যক্ত নহয়, আৰু তোমালোকৰ বিৰুদ্ধে বনৰীয়া জন্তুবোৰ যেন বৃদ্ধি নাপায়, সেই বাবে মই একে বছৰতে তেওঁলোকক তোমালোকৰ আগৰ পৰা খেদি নপঠিয়াম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","তাৰ পৰিৱৰ্তে তোমালোক বৃদ্ধি পাই দেশ অধিকাৰ নকৰা মানে, মই তেওঁলোকক তোমালোকৰ আগৰ পৰা অলপ অলপকৈ বাহিৰলৈ খেদি থাকিম। ");
INSERT INTO asmfb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","মই চূফ সাগৰৰ পৰা পলেষ্টীয়াসকলৰ সমুদ্ৰলৈকে, আৰু মৰুভূমিৰ পৰা ফৰাৎ নদীলৈকে তোমালোকৰ সীমা নিৰূপণ কৰিম। সেই দেশ নিবাসী সকলৰ ওপৰত মই তোমালোকক জয়ী কৰিম। তোমালোকে তোমালোকৰ আগৰ পৰা তেওঁলোকক খেদি বাহিৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","তোমালোকে তেওঁলোকৰ সৈতে, বা তেওঁলোকৰ দেৱতাবোৰৰ সৈতে কোনো নিয়ম স্থিৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","তেওঁলোকে তোমালোকৰ দেশত বাস কৰিব নোৱাৰিব; বাস কৰিলে, তেওঁলোকে তোমালোকক মোৰ বিৰুদ্ধে পাপ কৰাব। কিয়নো তুমি যদি তেওঁলোকৰ দেৱতাবোৰক পূজা কৰা, তেনেহ’লে নিশ্চয়ে তোমালোকলৈ সেয়ে ফান্দস্বৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","যিহোৱাই মোচিক কলে, “তুমি, হাৰোণ, নাদব, অবীহূ, আৰু ইস্ৰায়েলৰ সত্তৰজন পৰিচাৰক মোৰ ওচৰলৈ উঠি আহাঁ; আৰু তোমালোকে দূৰৰে পৰা মোক আৰাধনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","কেৱল মোচিহে মোৰ ওচৰলৈ আহিব। আন লোকসকল ওচৰলৈ আহিব নালাগে; বা লোকসকল তেওঁৰ লগত ওপৰলৈ উঠি আহিব নালাগে।” ");
INSERT INTO asmfb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","তেতিয়া মোচিয়ে গৈ, যিহোৱাৰ সকলো বাক্য আৰু শাসন প্ৰণালীৰ কথা লোকসকলক ক’লে। সকলোৱে একে লগে উত্তৰ দি ক’লে, “যিহোৱাই কোৱা সকলো কথা আমি পালন কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","তাৰ পাছত মোচিয়ে যিহোৱাৰ সকলো বাক্য লিখিলে। ৰাতিপুৱাই উঠি, মোচিয়ে পৰ্ব্বতৰ তলত এটা যজ্ঞবেদী আৰু ইস্ৰায়েলৰ বাৰ ফৈদ অনুসাৰে বাৰটা স্তম্ভ নিৰ্ম্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","তেওঁ ইস্ৰায়েলী লোকসকলৰ মাজৰ কিছুমান যুৱকক যিহোৱাৰ উদ্দেশ্যে হোমবলি আৰু মঙ্গলাৰ্থক বলিস্বৰূপে ভতৰা গৰু উৎসৰ্গ কৰিবলৈ পঠিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","মোচিয়ে তেজৰ আধা অংশ, কেইটামান চৰিয়াত থলে, আৰু বাকি আধা অংশ বেদীৰ ওপৰত ছটিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","তেওঁ নিয়ম-পুস্তকখন ল’লে লোকসকলে শুনাকৈ পাঠ কৰিলে। তেওঁলোকে ক’লে, “যিহোৱাই যি যি সকলো কৈছে, সেই সকলোকে আমি পালন কৰিম, আৰু আমি তেওঁৰ আজ্ঞাধীন হম।” ");
INSERT INTO asmfb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","তাৰ পাছত মোচিয়ে সেই তেজ লৈ, লোকসকলৰ ওপৰত ছটিয়াই দিলে। মোচিয়ে ক’লে, “যিহোৱাই এই সকলো বাক্যৰ সৈতে আপোনালোকক দিয়া প্রতিজ্ঞাৰ যি নিয়ম স্থাপন কৰিলে, এয়ে সেই নিয়মৰ তেজ।” ");
INSERT INTO asmfb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","তাৰ পাছত মোচি, হাৰোণ, নাদব, অবীহূ, আৰু ইস্ৰায়েলৰ মাজৰ সত্তৰ জন পৰিচাৰক পৰ্ব্বতৰ ওপৰলৈ উঠি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","তেওঁলোকে ইস্ৰায়েলৰ ঈশ্বৰৰ দৰ্শন পালে। নীলা আকাশৰ দৰে স্বচ্ছ নীলকান্ত বাখৰেৰে তৈয়াৰী বাটত তেওঁ থিয় হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ঈশ্বৰে ক্রোধেৰে ইস্ৰায়েলী মুখ্যলোক সকলৰ ওপৰত হাত নিদিলে। তেওঁলোকে ঈশ্বৰৰ দৰ্শন পালে আৰু তেওঁলোকে ভোজন পান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","যিহোৱাই মোচিক কলে, “তুমি পৰ্ব্বতলৈ মোৰ ওচৰলৈ উঠি আহাঁ, আৰু তাতে থাকা। মই লিখা ব্যৱস্থা আৰু আজ্ঞাৰ শিলৰ ফলি মই তোমাক দিম; যাতে সেইবোৰ তুমি তেওঁলোকক শিকাব পাৰা।” ");
INSERT INTO asmfb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","তেতিয়া মোচিয়ে আৰু তেওঁৰ পৰিচাৰক যিহোচূৱাক লগত লৈ ঈশ্বৰৰ পৰ্ব্বতলৈ উঠি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","মোচিয়ে পৰিচাৰক সকলক ক’লে, “আমি আপোনালোকৰ ওচৰলৈ উভটি নহালৈকে, আপোনালোক ইয়াতে থাকক। হাৰোণ আৰু হূৰ আপোনালোকৰ লগত আছে। কোনো জনৰ যদি কিবা বিবাদ থাকে, তেওঁক তেওঁলোকৰ ওচৰলৈ যাব দিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","সেই বুলি কৈ, মোচি পৰ্ব্বতলৈ উঠি গ’ল, আৰু মেঘে পৰ্ব্বত ঢাকি ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","সেই চীনয় পৰ্ব্বতৰ ওপৰত যিহোৱাৰ প্ৰতাপ স্থাপিত আছিল, আৰু ছয় দিনলৈকে মেঘে পৰ্ব্বত ঢাকি ৰাখিছিল। সপ্তম দিনত তেওঁ মেঘৰ মাজৰ পৰা মোচিক মাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ইস্ৰায়েলী লোকসকলৰ দৃষ্টিত, যিহোৱাৰ প্ৰতাপ পৰ্ব্বতৰ ওপৰত গ্ৰাসকাৰী অগ্নিৰ দৰে প্ৰকাশিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","মোচি মেঘৰ মাজত সোমাই পৰ্ব্বতলৈ উঠি গ’ল। মোচি সেই পৰ্ব্বততে চল্লিশ দিন আৰু চল্লিশ ৰাতি থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“মনৰ ইচ্ছাৰে প্রভাৱিত হোৱা প্রতিজন ইস্ৰায়েলী লোকৰ পৰা মোৰ অৰ্থে দান গ্রহণ কৰিবলৈ ক’বা। তুমি নিশ্চয়কৈ মোৰ অৰ্থে এই দান গ্রহণ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","তুমি তেওঁলোকৰ পৰা গ্ৰহণ কৰিব লগা দান এইবোৰ: সোণ, ৰূপ, পিতল, ");
INSERT INTO asmfb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","আৰু নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা, মিহি শণ সূতা, ছাগলীৰ নোম, ");
INSERT INTO asmfb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ৰঙা ৰং কৰা মেৰ-ছাগ পোৱালীৰ ছাল, গৰুৰ মিহি ছাল, চিটীম কাঠ, ");
INSERT INTO asmfb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","পবিত্র প্ৰদীপৰ বাবে তেল, অভিষেক তেলৰ বাবে মচলা, আৰু সুগন্ধি ধূপ, ");
INSERT INTO asmfb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","এফোদ আৰু বুকুপতাত লগাবৰ বাবে গোমেদক আৰু আন বহুমূল্য বাখৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","মই তেওঁলোকৰ মাজত বাস কৰিবৰ অৰ্থে, তেওঁলোকক মোৰ বাবে এটা ধৰ্মধাম নিৰ্মাণ কৰিবলৈ কোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","সেই আবাস আৰু তাৰ সকলো বস্তুৰ যি নমুনা মই তোমাক দেখুৱাম, তোমালোকে সেই নমুনাৰ দৰেই সকলো কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","তেওঁলোকে চিটীম কাঠেৰে আঢ়ৈ হাত দীঘল, ডেৰ হাত বহল আৰু ডেৰ হাত ওখকৈ এটা নিয়ম-চন্দুক সাজিব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","তুমি সেই নিয়ম চন্দুকৰ ভিতৰে বাহিৰে শুদ্ধ সোণৰ পতা মাৰিবা; আৰু তাৰ ওপৰৰ চাৰিওফালৰ সীমা সোণেৰে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ইয়াৰ বাবে সোণৰ চাৰিটা আঙঠি সাঁচত বনাবা, আৰু নিয়ম চন্দুকৰ এফালে দুটা, আৰু আন ফালে দুটা, এইদৰে চাৰিওটা খুৰাত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","তুমি চিটীম কাঠৰ দুডাল কানমাৰি সাজি, তাতো সোণৰ পতা মাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","নিয়ম চন্দুক বৈ নিবৰ বাবে, সেই কানমাৰি নিয়ম-চন্দুকৰ দুয়ো ফালে থকা আঙঠিত সুমুৱাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","সেই কানমাৰি নিয়ম-চন্দুকৰ আঙঠিৰ ভিতৰতে থাকিব লাগে, তাৰ পৰা উলিয়াব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","মই তোমাক যি সাক্ষ্য ফলি দিম, সেই সাক্ষ্য ফলি নিয়ম-চন্দুকৰ ভিতৰত ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","তাৰ পাছত তুমি শুদ্ধ সোণৰ আঢ়ৈ হাত দীঘল, ডেৰ হাত বহল এখন পাপাবৰণ সাজিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","তুমি সোণ পিটি দুটা কৰূব সাজিবা; পাপাবৰণৰ দুই মুৰত সেই কৰূব দুটা লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","এক মুৰত এটা কৰূব আৰু আন মুৰত আনটো কৰূব লগাবা; পাপাবৰণৰ দুই মুৰত তাৰে সৈতে একে ডোখৰ সোণতে সেই দুটা কৰূব সাজিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","কৰূব দুটাই ওপৰলৈ ডেউকা মেলি নিজৰ ডেউকাৰে পাপাবৰণক ঢাকিব; সেই কেইটা মুখামুখি হৈ থাকিব; আৰু কৰূব দুটাৰ দৃষ্টি পাপাবৰণৰ মাজত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","তুমি সেই পাপাবৰণ, সেই নিয়ম চন্দুকৰ ওপৰত ৰাখিবা; আৰু মই তোমাক যি সাক্ষ্য-ফলি দিম, সেই ফলি নিয়ম চন্দুকৰ ভিতৰত থ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","মই সেই নিয়ম চন্দুকতে তোমাৰে সৈতে সাক্ষাৎ কৰিম। পাপাবৰণৰ ওপৰৰ পৰা, সাক্ষ্য ফলিৰ নিয়ম চন্দুকৰ ওপৰত থকা কৰূব দুটাৰ মাজৰ পৰা, ইস্ৰায়েলৰ লোকসকলৰ বাবে যিবোৰ আজ্ঞা দিম, সেই বিষয়ে তোমাৰে সৈতে কথা পাতিম। ");
INSERT INTO asmfb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","তুমি দুহাত দীঘল, এহাত বহল, আৰু ডেৰ হাত ওখকৈ চিটীম কাঠৰ এখন মেজ সাজিবা, ");
INSERT INTO asmfb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","সেই মেজত শুদ্ধ সোণৰ পতা মাৰিবা, আৰু তাৰ চাৰিওফালে সোণৰ সীমা দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","সেই মেজৰ চাৰিওফালে চাৰি আঙুলি জোখৰ এচটা কাঠ দি ফ্রেম বনাবা, আৰু সেই ফ্রেমৰ চাৰিও ফালে সোণৰ সীমা বনাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","সোণৰ চাৰিটা আঙঠি সাজি, সেই আঙঠি চাৰিটা খুৰা থকা মেজৰ চাৰি চুকত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","মেজ বৈ নিবলৈ কানমাৰি সুমুউৱাবলৈ ফ্রেমত আঙঠি লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","তুমি মেজ বৈ নিবৰ বাবে, চিটীম কাঠৰ দুডাল কানমাৰি সাজি, তাতো সোণৰ পতা মাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","পেয় নৈবেদ্যৰ বাবে ব্যৱহাৰ কৰিবলৈ কাঁহি, চামুচ, জাৰ আৰু বাটি গঢ়াবা। এই সকলোকে শুদ্ধ সোণেৰে গঢ়াবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","তুমি সেই মেজৰ ওপৰত মোৰ আগত সদায় দৰ্শন-পিঠা ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","তুমি শুদ্ধ পিটা সোণৰ এটা দীপাধাৰ সাজিবা। দীপাধাৰৰ সৈতে তাৰ বাটিবোৰ, তাৰ তলৰ পাতবোৰ, আৰু ফুলবোৰ একেডোখৰ সোণেৰেই বনোৱা হ’ব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","দীপাধাৰৰ কাষৰ পৰা ছয়ডাল শাখা ওলোৱা হ’ব লাগিব। তাৰে তিনি ডাল শাখা এফালৰ পৰা, আৰু আন তিনি ডাল শাখা আন ফালৰ পৰা ওলোৱা হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","তাৰ এটা শাখাত বাদাম ফুলৰ আকৃতিৰে তিনিটা বাটি, এটা কলি, আৰু এটা ফুল থাকিব লাগিব। আন শাখাতো বাদাম ফুলৰ আকৃতিৰে তিনিটা বাটি, এটা কলি, আৰু এটা ফুল থাকিব। দীপাধাৰৰ পৰা ওলোৱা ছয়টা ডালতে সেই একে দৰেই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","দীপাধাৰৰ মাজভাগতো বাদাম ফুলৰ আকৃতিৰে চাৰিটা বাটি, কলি, আৰু ফুল থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","সেই দীপাধাৰৰ প্রথম যোৰ শাখাত একে ডোখৰ সোণেৰে এটা কলি, আৰু আন দ্বিতীয় যোৰ শাখাতো একে ডোখৰ সোণেৰে এটা কলি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","সেইবোৰৰ কলি আৰু সেইবোৰৰ শাখাবোৰ একে ডোখৰ সোণেৰে হ’ব; আৰু সেই সকলোৱেই শুদ্ধ সোণ পিটি বনোৱা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","তুমি দীপাধাৰ আৰু ইয়াৰ সাতটা প্ৰদীপ সাজিবা। প্রদীপৰ পৰা পোহৰ ওলাবলৈ প্ৰদীপবোৰ দীপাধাৰত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","এঙাৰ ধৰা চেপেনা আৰু ট্রে শুদ্ধ সোণৰ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","দীপাধাৰ আৰু দীপাধাৰৰ বাবে ব্যৱহাৰ কৰা সকলো বস্তু সাজিবলৈ এক কিক্কৰ শুদ্ধ সোণ ব্যৱহাৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","মই তোমাক পৰ্ব্বতত দেখুউৱা নমুনাৰ দৰেই সেই সকলো নিশ্চয় সাজিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","তুমি দহখন পৰ্দাৰে আবাস যুগুত কৰিবা; সেই পৰ্দাৰ কাপোৰ কেইখন পকোৱা মিহি শণ সূতা, আৰু নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতাৰে নিপুণ শিল্পকাৰৰ দ্বাৰাই কৰূবৰ নক্সাৰে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","প্ৰত্যেক খন পৰ্দা আঁঠাইশ হাত দীঘল, আৰু চাৰি হাত বহল, এইদৰে সকলোবোৰ পৰ্দা একে জোখৰ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","পাঁচখন পৰ্দা ইখনৰ লগত সিখন একেলগে জোৰা দিব লাগিব, আৰু আন পাঁচখন পৰ্দাও একেদৰে যোৰা দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","প্ৰথম জোৰা দিয়া পৰ্দা কেইখনৰ শেষৰ খনৰ চুকত, আৰু দ্বিতীয়তে জোৰা দিয়া পৰ্দা কেইখনৰ শেষৰ খনৰ চুকত নীলা বৰণীয়া জৰীৰ পাক লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","সেই প্ৰথম খন পৰ্দাৰ কিনাৰত পঞ্চাশটা জৰীৰ পাক লগাবা, আৰু জোৰা দিয়া দ্বিতীয়খন পৰ্দাৰ শেষৰ কিনাৰতো পঞ্চাশটা জৰীৰ পাক লগাবা। এইদৰে কৰিবা যাতে, জৰীৰ পাক দুশাৰী মুখামুখি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","সোণৰ পঞ্চাশটা হাঁকোটা গঢ়াই সেই হাঁকোটাৰে কাপোৰ দুখন ইখনৰ সৈতে সিখনক বান্ধিবা; সেইদৰে কৰিলে আবাস একলগ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","সেই আবাস ঢাকিবলৈ তম্বুৰ দৰে ছাগলীৰ নোমেৰে পৰ্দা যুগুত কৰিবা। তুমি এঘাৰখন পৰ্দা যুগুত কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","প্ৰতিখন পৰ্দা দীঘলে ত্রিশ হাত আৰু বহলে চাৰি হাত হ’ব; সেই এঘাৰখন পৰ্দা একে জোখৰ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","পাঁচখন পৰ্দা ইখনৰ লগত সিখনক জোৰা লগাবা, আৰু আন ছয়খন পৰ্দাও ইখনৰ লগত সিখনক জোৰা লগাবা। তুমি ষষ্ঠ পৰ্দাখন দুতৰপিয়া কৰি তম্বুৰ সন্মুখত থবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","প্ৰথম জোৰা দিয়া পাঁচখন পৰ্দাৰ শেষৰ খনৰ আউঠিত পঞ্চাশটা জৰীৰ পাক লগাবা, আৰু সেই দৰে জোৰা দিয়া দ্বিতীয়খন পৰ্দাৰ শেষৰ আউঠিতো পঞ্চাশটা জৰীৰ পাক লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","পিতলৰ পঞ্চাশটা হাঁকোটা গঢ়াই, সেই হাঁকোটাৰে জৰীৰ পাক যোৰা দি তম্বু ল’গ লগাবা। তাৰ পাছত তম্বুৰ ঢাকনিৰ দৰে একেলগে যোৰা দিবা, সেয়ে এটাৰ দৰে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","সেই তম্বুৰ পৰ্দা কেইখনৰ পৰা ওলমি থকা আধা কাপোৰ আবাসৰ পাছফালে ওলমি থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","তম্বুৰ পৰ্দা কেইখনৰ এফালে এহাত দীঘল, আৰু আনফালে এহাত দীঘল হ’ব লাগিব। তম্বুৰ বাকী থকা পৰ্দাৰ দীঘল অংশ আবাসৰ এটা ফালে ওলমি থাকিব লাগিব, আৰু আন ফালৰ ওলমি থকা অংশ আবাস ঢাকি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","তুমি ৰঙা ৰং কৰা মেৰ-ছাগ পোৱালীৰ ছালেৰে তম্বুৰ বাবে এটা আবৰণ যুগুত কৰিবা। তাৰ ওপৰত আন এটা আবৰণ মিহি ছালেৰে যুগুত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","তুমি আবাসৰ বাবে চিটীম কাঠৰ থিয়কৈ তক্তা যুগুত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","প্রতিখন তক্তা দহ হাত দীঘল, আৰু ডেৰ হাত বহল হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","প্ৰতিখন তক্তাত একে ধৰণৰ দুটা ভাগ ওলাই থকা হ’ব লাগিব; যাতে ইখন তক্তা সিখন তক্তাৰ লগত যোৰা দিব পাৰি। আবাসৰ কাৰণে এইদৰেই তক্তা তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","তুমি আবাসৰ বাবে তক্তা যুগুত কৰোঁতে, বিশখন তক্তা দক্ষিণ দিশৰ বাবে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","সেই বিশখন তক্তাৰ তলত চল্লিশটা ৰূপৰ চুঙী লগাবা, এখন তক্তাৰ তলত দুটা স্তম্ভমূলৰ বাবে দুটা চুঙী, আৰু আনবোৰ তক্তাৰ তলতো দুটা দুটাকৈ স্তম্ভমূলৰ বাবে দুটাকৈ চুঙী লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","তুমি আবাসৰ দ্বিতীয় ফালৰ উত্তৰদিশত বিশখন তক্তা তৈয়াৰ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","আৰু সেইবোৰত চল্লিশটা ৰূপৰ চুঙী লগাবা; প্রথম তক্তাৰ তলত দুটা চুঙী, আৰু আনবোৰ তক্তাৰ তলতো দুটাকৈ চুঙী থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","আবাসৰ পশ্চিমদিশে পাছফালৰ বাবে ছয়খন তক্তা তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","তুমি আবাসৰ পাছফালৰ চুক দুটাৰ বাবে দুখন তক্তা যুগুত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","প্ৰত্যেক তক্তা তলৰ ফালে খোলা হৈ থাকিব, কিন্তু ওপৰফালে একেডাল আঙঠিতে যোৰা লাগি থাকিব। এইদৰেই পিছফালৰ দুয়োটা চুকৰ বাবেও হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","তাত আঠখন তক্তা ৰূপৰ চুঙীৰ সৈতে একেলগে থাকিব লাগিব। সৰ্ব্বমুঠ ষোল্লটা চুঙী হ’ব লাগিব। প্রথম তক্তাৰ তলত দুটা চুঙী, আৰু আনখন তক্তাৰ তলতো দুটা চুঙী থাকিব। এইদৰে বাকিবোৰ তক্তাতো থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","তুমি আবাসৰ এটা ফালৰ তক্তাৰ বাবে চিটীম কাঠৰ ছয়ডাল পথালি ডাং বনাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","আবাসৰ আনফালৰ তক্তাৰ বাবে পাঁচডাল, আৰু আবাসৰ পশ্চিমদিশে থকা পাছফালৰ তক্তাৰ বাবেও পাঁচডাল; চিটীম কাঠৰ পথলি ডাং বনাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","তক্তাৰ মাজত থকা ডাং ডাল তক্তাবোৰৰ মাজেদি এমুৰৰ পৰা আন মুৰলৈকে যাব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","সেই তক্তাবোৰত সোণৰ পতা মাৰিবা, আৰু ডাংবোৰ সুমুউৱাবলৈ, সোণৰ চক্র গঢ়াবা; আৰু ডাংবোৰতো সোণৰ পতা মাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","তোমাক পৰ্ব্বতত আবাসৰ যি আচনি দেখুউৱা হৈছিল, তুমি সেইদৰেই তাক তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","তুমি নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে এখন পৰ্দা যুগুত কৰিবা। সেই পৰ্দা নিপুণ শিল্পকাৰে কৰূবৰ নক্সাৰে তৈয়াৰ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","তুমি সেই পৰ্দাবোৰ, সোণৰ পতা মৰা চিটীম কাঠৰ চাৰিটা খুটাৰ ওপৰত ওলমাই দিবা। সেই খুটাবোৰৰ হাঁকোটা সোণৰ হ’ব লাগিব, আৰু সেই খুঁটা ৰূপৰ চাৰিটা চুঙীৰ ওপৰত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","তুমি পৰ্দাবোৰ হাঁকোটাবোৰত ওলমাবা; আৰু তাৰ ভিতৰলৈ নিয়ম চন্দুকৰ সাক্ষ্য ফলি আনিবা। সেই পৰ্দাই পবিত্ৰ-স্থান আৰু অতি পবিত্ৰ-স্থানৰ মাজত প্ৰভেদ ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","তুমি অতি পবিত্ৰ-স্থানত সাক্ষ্য-ফলিৰ নিয়ম চন্দুকৰ ওপৰত পাপাবৰণ থ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","মেজখন পৰ্দাৰ বাহিৰত ৰাখিবা, মেজৰ বিপৰীতে আবাসৰ দক্ষিণ ফালে দীপাধাৰ ৰাখিবা, আৰু মেজখন উত্তৰফালে থ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","তম্বুৰ প্রবেশ দুৱাৰৰ বাবে নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে ফুল বছা এখন পৰ্দা যুগুত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","সেই পৰ্দা ওলমাবলৈ চিটীম কাঠৰ পাঁচটা খুঁটা যুগুত কৰিবা, আৰু সেইবোৰত সোণৰ পতা মাৰিবা। সেইবোৰৰ হাঁকোটা সোণৰ হ’ব; আৰু সেইবোৰৰ বাবে পিতলৰ পাঁচটা চুঙী সাঁচত ঢালিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","তুমি যজ্ঞবেদীটো চিটীম কাঠেৰে সাজিবা। সেই বেদীৰ দীঘলে পাঁচ হাত, বহলে পাঁচ হাত হ’ব লাগিব। যজ্ঞবেদীৰ চাৰিও দিশ সমান হ’ব লাগিব, আৰু ওখই তিনি হাত হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","তুমি তাৰ চাৰিও চুকে ওলাই থকা অংশ, গৰুৰ শিঙৰ আকৃতিৰে তৈয়াৰ কৰিব লাগিব। শিং কেইটা যজ্ঞবেদিৰ সৈতে একেলগে তৈয়াৰ কৰিব লাগিব; আৰু তাত পিতলৰ পতা মাৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","তুমি যজ্ঞবেদীৰ সকলো সামগ্রী তৈয়াৰ কৰিবা: ছাঁই পেলোৱা পাত্ৰ, হেঁতা, চৰিয়া, মাংস খোঁচ যাঠি, আৰু জুই ধৰা পাত্ৰ। সেই সকলো সঁজুলি পিতলেৰে গঢ়াবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","যজ্ঞবেদীৰ বাবে পিতলৰ এটা জালি গঢ়াবা, আৰু সেই জালিৰ চাৰিওটা চুকত পিতলৰ চাৰিটা চক্র লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","তুমি সেই জালি, যজ্ঞবেদীৰ ভিতৰৰ স্তৰত লগাবা। সেই জালি বেদীৰ তলৰ আধা ভাগলৈকে পাব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","বেদিৰ বাবে চিটীম কাঠৰ কান্ধমাৰি সাজিবা, আৰু তাত পিতলৰ পতা মাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","কান্ধমাৰি কেইডাল চক্রৰ ভিতৰত সুমুউৱাই ৰাখিবা; আৰু যজ্ঞবেদি কঢ়িয়াবলৈ কান্ধমাৰিবোৰ বেদীৰ দুয়ো কাষে ৰাখিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","তুমি সেই যজ্ঞবেদী তক্তাৰে ফোঁপোলা কৰি সাজিবা। পৰ্ব্বতত তোমাক যি দৰে দেখুৱা হৈছিল, সেইদৰেই তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","তুমি আবাসৰ বাবে চোতাল প্রস্তুত কৰিব লাগিব। চোতালৰ দক্ষিণফালে মিহি শণ সূতাৰ এশ হাত দীঘল কাপোৰ ওলমাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","সেই কাপোৰ ওলমাবলৈ বিশটা খুঁটা; আৰু সেইবোৰৰ বাবে পিতলৰ বিশটা চুঙী; খুটাবোৰৰ হাঁকোটা আৰু মাৰি কেইডাল ৰূপৰ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","সেইদৰে উত্তৰফালে এশ হাত দীঘল কাপোৰ বিশটা খুটাৰ সৈতে থাকিব। সেই খুটাবোৰত বিশটা পিতলৰ চুঙী, আৰু হাঁকোটা লগা থাকিব আৰু মাৰি কেইডাল ৰূপৰ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","সেই চোতালৰ পশ্চিমফালে পঞ্চাশহাত দীঘল পৰ্দা থাকিব। তাত দহটা খুঁটা আৰু দহটা চুঙী থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","পূবদিশে চোতালখন পঞ্চাশ হাত দীঘল হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","প্রবেশ দুৱাৰৰ এফালে ওলমাই থোৱা পৰ্দা পোন্ধৰ হাত দীঘল হ’ব লাগিব; আৰু সেই পৰ্দাৰ বাবে তিনিটা চুঙীৰে সৈতে তিনিটা খুঁটা লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","আনদিশে পোন্ধৰ হাত দীঘল কাপোৰ ওলমাব লাগিব। তাৰ বাবে তিনিটা চুঙী আৰু তিনিটা খুঁটা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","চোতালখনৰ দুৱাৰৰ বাবে নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা ও পকোৱা মিহি শণ সূতাৰে ফুল বছা বিশ হাত দীঘল এখন পৰ্দা তৈয়াৰ কৰিব লাগিব। সেই পৰ্দাৰ চাৰিটা খুঁটা, আৰু সেই খুটাবোৰৰ বাবে চাৰিটা চুঙী লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","চোতালৰ সকলো খুটাবোৰত ৰূপৰ মাৰি, ৰূপৰ হাঁকোটা আৰু পিতলৰ চুঙী থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","চোতাল দীঘলে এশ হাত, পথালিয়ে পঞ্চাশ হাত, আৰু ওখই পাঁচ হাত। চোতালৰ চাৰিওফালে ওলমি থকাকৈ পকোৱা মিহি শণ সূতাৰ পৰ্দা, আৰু চুঙীবোৰ পিতলৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","আবাসৰ কাৰ্যত ব্যৱহাৰ হোৱা সকলো সামগ্রী, আবাস আৰু চোতালৰ কাৰণে সকলো তম্বুৰ খুটি পিতলৰ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","সদায় প্ৰদীপ জ্বলাই পোহৰ কৰিবলৈ, খান্দি উলিওৱা জিতগছৰ গুটিৰ শুদ্ধ তেল তোমাৰ ওচৰলৈ আনিবলৈ, তুমি ইস্ৰায়েলী লোকসকলক আজ্ঞা দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","সাক্ষাৎ কৰা তম্বুৰ ভিতৰত সাক্ষ্য-ফলিৰ নিয়ম চন্দুকৰ আগত থকা পৰ্দাৰ বাহিৰত যিহোৱাৰ আগত গধূলিৰ পৰা ৰাতিপুৱালৈকে প্রদীপ জ্বলি থাকিবৰ বাবে হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে তত্বাৱধান ল’ব লাগিব। এয়ে ইস্ৰায়েলী লোকসকলে পুৰুষানুক্ৰমে পালন কৰিব লগীয়া চিৰস্থায়ী বিধি। ");
INSERT INTO asmfb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","পুৰোহিত হৈ মোৰ পৰিচৰ্যা কৰিবলৈ, ইস্ৰায়েলী লোকসকলৰ মাজৰ পৰা তোমাৰ ককায়েক হাৰোণক আৰু তেওঁৰ লগত তেওঁৰ পুত্ৰ নাদব, অবীহূ, ইলিয়াজৰ, আৰু ঈথামৰক তুমি নিজে মাতি আনিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","তোমাৰ ককায়েৰা হাৰোণৰ বস্ত্র মোৰ উদ্দেশ্যে পবিত্ৰ কৰি সংৰক্ষিত কৰি ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","মোৰ অৰ্থে পুৰোহিতৰ কাৰ্য কৰিবলৈ হাৰোণক পবিত্ৰকৃত কৰিবলৈ মই দিয়া জ্ঞানৰ আত্মাৰে পৰিপূৰ্ণ হোৱা নিপূণ লোকসকলক তেওঁৰ বস্ত্ৰ যুগুত কৰিবলৈ তুমি আজ্ঞা কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","তেওঁলোকে তৈয়াৰ কৰিব লগীয়া বস্ত্ৰ এইবোৰ: এটা বুকুপটা, এফোদ, চোলা, হাতে বোৱা কোট চোলা, পাগুৰি, আৰু টঙালি। তেওঁলোকে এইসকলো বস্ত্র তৈয়াৰ কৰি পবিত্ৰ কৰিব; আৰু মোৰ উদ্দেশ্যে সংৰক্ষিত কৰি ৰাখিব। পুৰোহিত হৈ মোৰ পৰিচৰ্যা কৰিবলৈ, তোমাৰ ককায়েক হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ কাৰণে এই সকলো বস্ত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","শিল্পকাৰে সোণালী, নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা আৰু মিহি শণ সূতা ব্যৱহাৰ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","তেওঁলোকে সোণালী আৰু নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া ঊল, আৰু মিহি পকোৱা শণ সূতাৰে সেই এফোদ বস্ত্ৰ তৈয়াৰ কৰিব। সেয়ে নিপুণ শিল্পকাৰৰ কাৰ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","এফোদৰ ওপৰৰ দুয়ো কান্ধৰ চুকত লগাবলৈ দুপাত স্কন্ধপটি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","এফোদৰ দৰেই কঁকালত বান্ধিবৰ বাবে এডাল টঙালি এফোদৰ সৈতে সোণোৱালী, নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা, ও পকোৱা মিহি শণ সূতাৰে তৈয়াৰ কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","তুমি দুটা গোমেদক বাখৰ ল’বা, আৰু তাৰ ওপৰত ইস্ৰায়েলৰ বাৰ জন পুত্ৰৰ নাম খোদিত কৰাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","তেওঁলোকৰ জন্মৰ ক্ৰম অনুসাৰে ছয় জনৰ নাম এটা বাখৰত আৰু বাকী ছয় জনৰ নাম আন এটা বাখৰৰ ওপৰত ক্ষোদিত কৰাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","পাথৰৰ খনিকৰে মোহৰত খোদিত কৰাৰ দৰেই সেই দুটা বাখৰৰ ওপৰতো ইস্ৰায়েলৰ পুত্ৰসকলৰ নাম ক্ষোদিত কৰাবা। তুমি সেই বাখৰ দুটা সোণত খটোৱাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ইস্ৰায়েলৰ সন্তান সকলৰ সোঁৱৰণীয় বাখৰ হ’বলৈ, তুমি সেই দুটা বাখৰ এফোদৰ দুয়ো কান্ধত লগাবা। সেয়ে হাৰোণে তেওঁৰ দুয়ো কান্ধত তেওঁলোকৰ নাম সোঁৱৰণৰ অৰ্থে যিহোৱাৰ সাক্ষাতে বহন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","তুমি নিশ্চয়কৈ সেই বাখৰ দুটা লগাবলৈ সোণ ব্যৱহাৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","দুটা পকোৱা ৰচিৰ দৰে দুডাল শুদ্ধ সোণৰ শিকলি তৈয়াৰ কৰি, বাখৰ লগোৱা সোণত লগাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","তুমি সিদ্ধান্ত ল’বলৈ এটা বুকুপটা তৈয়াৰ কৰিবা। সেয়ে নিপুণ শিল্পকাৰৰ কাৰ্য হ’ব; এফোদ বস্ত্ৰৰ দৰে তাক প্রস্তুত কৰিবা। নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা ও পকোৱা মিহি শণ সূতাৰ লগত সোণেৰে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","তুমি বুকুপতাৰ চাৰিওদিশ সমানে দুতৰপীয়াকৈ ভাজ কৰিবা। সেয়ে দীঘলে এবেগেত আৰু পথালিয়েও এবেগেত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","বুকুপতাত চাৰি শাৰী বহুমূলীয়া পাথৰ খুৱাবা। তাৰ প্ৰথম শাৰীত এটা ৰুবী, এটা পোখৰাজ, আৰু এটা ৰক্তমণি। ");
INSERT INTO asmfb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","দ্বিতীয় শাৰীত এটা মৰকত, এটা নীলকান্ত, আৰু এটা হীৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","তৃতীয় শাৰীত এটা নীলকান্তমণি, এটা আকীক, আৰু এটা নীলা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","আৰু চতুৰ্থ শাৰীত এটা পান্না, গোমেদক, আৰু জ্যাসপাৰ। এই সকলোবোৰ সোণৰ ওপৰত খটোৱাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","এই পাথৰবোৰ ইস্ৰায়েলৰ পুত্ৰসকলৰ নাম অনুসাৰে স্থিৰ কৰা হ’ব। মোহৰত খোদিত কৰাৰ দৰেই তেওঁলোকৰ নাম প্ৰত্যেক পাথৰত বাৰ ফৈদ অনুসাৰে ক্ষোদিত কৰা হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","বুকুপটাত লগাবলৈ, তুমি পকোৱা ৰচীৰ দৰে দুডাল শুদ্ধ সোণৰ শিকলি তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","তুমি বুকুপটাৰ বাবে সোণৰ দুটা আঙঠি গঢ়াই, সেই দুটা আঙঠি বুকুপটাৰ দুই মুৰত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","সোণৰ সেই শিকলি দুডাল বুকুপটাৰ দুই চুকত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","শিকলি দুডালৰ দুই মুৰ, পাথৰ খটোৱা সোণত লগাবা। তাৰ পাছত এফোদৰ আগফালৰ কান্ধৰ ওপৰত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","তুমি সোণৰ দুটা আঙঠি গঢ়াবা, আৰু বুকুপটাৰ দুই মুৰত, এফোদৰ সন্মুখত থকা ভিতৰ দাঁতিত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","তুমি আৰু দুটা সোণৰ আঙঠি গঢ়াবা, আৰু এফোদৰ আগফালে থকা দুপাত স্কন্ধপটিৰ তল ভাগত লগাবা। অৱশেষত এফোদৰ বাবে বোৱা টঙালি বান্ধিবলৈ ইয়াৰ ওপৰত লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","বুকুপটা যেন এফোদৰ বোৱা টঙালিৰ ওপৰত থাকে, আৰু এফোদৰ পৰা এৰাই নাযায়, সেই বাবে নীলা বৰণীয়া ফিতাৰে সেই বুকুপটাক তাৰ আঙঠিৰে সৈতে এফোদৰ আঙঠিত বান্ধিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","হাৰোণ যেতিয়া পবিত্ৰ স্থানলৈ যাব, তেতিয়া তেওঁ হৃদয়ত সিদ্ধান্ত ল’বলৈ, ইস্ৰায়েলৰ পুত্ৰসকলৰ নাম নিজৰ বুকুপটাত কঢ়িয়াব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","সেই সিদ্ধান্ত লোৱা বুকুপটাত ঊৰীম আৰু তুম্মীম লগাবা। হাৰোণে যি সময়ত যিহোৱাৰ আগলৈ যাব, সেই সময়ত হাৰোণৰ বুকুৰ ওপৰত সেইবোৰ থাকিব। যিহোৱাৰ আগত হাৰোণে ইস্ৰায়েলীসকলৰ বাবে সিদ্ধান্ত ল’বলৈ সেইবোৰ সদায় নিজৰ বুকুত কঢ়িয়াব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","তুমি এফোদৰ চোলা সম্পূৰ্ণ বেঙুনীয়া ৰঙৰ কাপোৰেৰে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","তাৰ সোঁ মাজত, মুৰ সুমুৱাবলৈ এটা বাট থাকিব। সেয়ে নাফালিবলৈ মুৰ সোমোৱা অংশৰ চাৰিওফাল সিপিনীয়ে বোৱা হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","তুমি তাৰ তল দাঁতিৰ চাৰিওফালে নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতাৰে ডালিমৰ চানেকী তুলিবা, আৰু তাৰ মাজে মাজে চাৰিওফালে সোণৰ জুনুকা থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","সেই এফোদৰ তল দাঁতিত চাৰিওফালে এটা সোণৰ জুনুকা এটা ডালিম, আৰু এটা সোণৰ জুনুকা এটা ডালিম এইদৰে থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","হাৰোণে যেতিয়া পৰিচৰ্যা কৰিব, তেতিয়া সেই বস্ত্র পিন্ধিব। তেওঁ যেতিয়া যিহোৱাৰ পবিত্র-স্থানত যিহোৱাৰ আগলৈ যাব, আৰু ওলাই আহিব, তেতিয়া সেই জুনুকাৰ শব্দ শুনা যাব। এইদৰে কৰাত তেওঁৰ মৃত্যু নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","তুমি শুদ্ধ সোণৰ এচটা পতা গঢ়িবা, আৰু মোহৰত খোদিত কৰাৰ দৰে সেই পতাৰ ওপৰত “যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ” এই কথা ক্ষোদিত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","তুমি সেই পতা নীলা বৰণীয়া ফিতাৰে পাগুৰিৰ আগফালে লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","সেয়ে হাৰোণৰ কপালত থাকিব। ইস্ৰায়েলীসকলে পবিত্র কৰি উৎসৰ্গ কৰা পবিত্ৰ দানত থকা যিকোনো দোষ হাৰোণে বব। তেওঁলোক যেন যিহোৱাৰ আগত গ্ৰহণীয় হোৱা, সেইবাবে পাগুৰি সদায় তেওঁৰ কপালৰ ওপৰত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","তুমি মিহি শণ সূতাৰে কোট চোলা আৰু পাগুৰি তৈয়াৰ কৰিবা, আৰু এটা ফুল বছা টঙালিও তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","হাৰোণৰ পুত্ৰসকলৰ বাবে কোট চোলা, টঙালি, আৰু পাগুৰি তেওঁলোকৰ মৰ্য্যদা আৰু শোভাৰ বাবে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","তোমাৰ ককায়েক হাৰোণ, আৰু তেওঁৰ সৈতে তেওঁৰ পুত্ৰসকলক সেইবোৰ পিন্ধিবা, আৰু মোৰ পৰিচৰ্যাৰ বাবে পুৰোহিতৰ কাৰ্য কৰিবলৈ তুমি তেওঁলোকক পবিত্ৰ কৰি অভিষিক্ত কৰিবা, আৰু পুৰোহিত পদত নিযুক্ত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","তেওঁলোকৰ গোপনীয় অংশ ঢাকিবলৈ, কঁকালৰ পৰা কৰঙণলৈকে তুমি তেওঁলোকলৈ শণ সূতাৰ বস্ত্র তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","যেতিয়া হাৰোণ আৰু তেওঁৰ পুত্ৰসকল সাক্ষাৎ কৰা তম্বুৰ ভিতৰলৈ সোমাব, বা পবিত্ৰ-স্থানত পৰিচৰ্যা কৰিবলৈ বেদীৰ ওচৰ চাপিব, তেতিয়া তেওঁলোকে যেন সেইবস্ত্র পৰিধান কৰে। তেওঁলোকে নিশ্চয়কৈ এইদৰে কৰিব লাগিব যাতে তেওঁলোকে পাপৰ ভাৰ বব লগা নহয় আৰু তেওঁলোকৰ মৃত্যু নহয়। এয়ে হাৰোণ আৰু তেওঁৰ ভাবি বংশৰ পালন কৰিবলগীয়া চিৰস্থায়ী বিধি। ");
INSERT INTO asmfb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","মোৰ পৰিচৰ্যাৰ বাবে পুৰোতহিৰ কাৰ্য কৰিবলৈ, এতিয়া তুমি তেওঁলোকক পবিত্ৰ কৰিবৰ বাবে এই কাৰ্য কৰিবা; এটা নিৰ্ঘূণী দমৰা আৰু দুটা নিঘূণী মতা মেৰ-ছাগ ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","খমিৰ নিদিয়া পিঠা, তেল মিহলোৱা খমীৰ নিদিয়া পিঠা, আৰু তেল সনা খমীৰ নিদিয়া পাতল পিঠা ল’বা। সেইবোৰ মিহি আটাগুড়িৰে তৈয়াৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","এটা পাচিত সেইবোৰ ৰাখিবা; আৰু সেই পাচিৰ সৈতে দমৰা আৰু দুটা মেৰ-ছাগ উপহাৰ দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","হাৰোণ, আৰু তেওঁৰ পুত্ৰসকলক তুমি সাক্ষাৎ কৰা তম্বুৰ দুৱাৰমুখত আনি তেওঁলোকৰ গা ধুৱাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","তুমি সেই বস্ত্রবোৰ, হাৰোণৰ কোট চোলা, এফোদ বস্ত্র, এফোদ আৰু বুকুপটা, আৰু এফোদৰ নিপুণৰূপে বোৱা টঙালি ল’বা আৰু তেওঁক পিন্ধাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","তেওঁৰ মুৰত পাগুৰি পিন্ধাই তাৰ ওপৰত পবিত্ৰ মুকুট লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","তাৰ পাছত অভিষেক কৰা তেল ল’বা, আৰু তেওঁৰ মুৰত বাকি, তেওঁক অভিষেক কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","তুমি তেওঁৰ পুত্ৰসকলক আনিবা; আৰু কোট চোলা পিন্ধাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ কঁকালত টঙালি বান্ধিবা, আৰু তেওঁলোকৰ মুৰত পাগুৰি মাৰি দিবা। পুৰোহিত পদৰ কার্য এক চিৰস্থায়ী বিধিৰ দ্বাৰাই তেওঁলোকৰ অধিকাৰত থাকিব। এইদৰেই তুমি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক মোৰ পৰিচৰ্যাৰ বাবে পবিত্রকৃত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","তুমি সাক্ষাৎ কৰা তম্বুৰ সন্মুখলৈ সেই দমৰাটো লৈ আনিবা; তেতিয়া হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে দমৰাটোৰ মুৰত হাত দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","তুমি সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত যিহোৱাৰ সন্মুখত সেই দমৰাটো বধ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","তুমি বধ কৰা দমৰাটোৰ কিছু অংশ তেজ লৈ, আঙুলিৰে বেদীৰ শিঙত লগাবা, আৰু বাকী তেজখিনি বেদীৰ ভিত্তিমূলত বাকি দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","তাৰ প্রতিটো অংশত থকা তেল, কলিজাৰ ওপৰত থকা তেলীয়া ভাগ, ঘিলা দুটা, আৰু সেই দুটাৰ ওপৰত থকা তেল লৈ, বেদীত জ্বলাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","কিন্তু সেই দমৰা টোৰ মাংস আৰু তাৰ লগতে ছাল আৰু গোবৰ তম্বুৰ বাহিৰফালে জুইত পুৰি ভষ্ম কৰি দিবা; সেয়ে পাপাৰ্থক বলি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","তুমি এটা মেৰ-ছাগ পোৱালিও লগত ল’বা। হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে সেই মেৰ-ছাগটোৰ মুৰত হাত দিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","তুমি সেই মেৰ-ছাগটো বধ কৰিবা। তাৰ পাছত সেই বধ কৰা মেৰ-ছাগটোৰ তেজ লৈ বেদীৰ ওপৰৰ চাৰিওফালে ছটিয়াই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","তুমি মেৰ-ছাগটো কাটি টুকুৰা টুকুৰ কৰিবা। তাৰ ভিতৰৰ অংশ আৰু ঠেংবোৰ ধুবা; ধুই মাংসৰ টুকুৰাবোৰৰ সৈতে মুৰটো একেলগে বেদীৰ ওপৰত থবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","তাৰ পাছত সম্পূৰ্ণ মেৰ-ছাগটো বেদীত জ্বলাই দিবা; সেয়ে মোৰ অৰ্থাৎ যিহোৱাৰ উদ্দেশ্যে হোম-বলি হ’ব। এয়ে মোৰ বাবে সুমধুৰ সুগন্ধ উৎপন্ন কৰিব; এয়ে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","তাৰ পাছত তুমি আনটো মেৰ-ছাগ পোৱালি ল’বা। হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে সেই মেৰ-ছাগটোৰ মুৰত হাত দিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","তুমি সেই মেৰ-ছাগ বধ কৰিবা আৰু তাৰ অলপমান তেজ লৈ, হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ সোঁ কাণৰ অগ্রভাগত, তেওঁলোকৰ সোঁ হাতৰ বুঢ়া আঙুলি, আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিত লগাবা। তেজৰ বাকী থকা অংশ বেদীৰ ওপৰৰ চাৰিওফালে ছটিয়াই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","তুমি বেদীৰ ওপৰত থকা তেজ, আৰু অভিষেক কৰা তেলৰ কিছু অংশ লৈ, হাৰোণৰ ওপৰত, তেওঁৰ বস্ত্ৰৰ ওপৰত, তেওঁৰ পুত্ৰসকলৰ ওপৰত আৰু তেওঁলোকৰ বস্ত্ৰৰ ওপৰতো ছটিয়াই দিবা। এইদৰে তেওঁ, তেওঁৰ বস্ত্ৰ, তেওঁৰ পুত্ৰ আৰু তেওঁলোকৰ বস্ত্ৰ পবিত্ৰীকৃত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","তুমি মেৰ-ছাগটোৰ চৰ্বি, নেগুৰৰ চৰ্বি, ভিতৰৰ অংশত থকা চৰ্বি, কলিজাৰ ওপৰত থকা চৰ্বি, ঘিলা দুটা আৰু তাৰ ওপৰত থকা চৰ্বি, আৰু পাছফালৰ সোঁ কৰঙন ল’বা; কাৰণ সেয়ে মোৰ বাবে পুৰোহিতক পবিত্রকৃত কৰিবৰ বাবে লোৱা মেৰ-ছাগ। ");
INSERT INTO asmfb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","তুমি যিহোৱাৰ সন্মুখত থকা খমীৰ নিদিয়া পিঠাৰ সেই পাচিটোৰ পৰা এটা পিঠা, তেল মিহলোৱা এটা পিঠা, আৰু খমীৰ নিদিয়া এটা পাতল পিঠা ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ হাতত সেই সকলোকে দিবা। তেওঁলোকে যিহোৱাৰ সন্মুখত উৎসৰ্গ কৰিবৰ বাবে সেই পিঠাবোৰ ওপৰলৈ তুলি ধৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","তুমি তেওঁলোকৰ হাতত পৰা আহাৰ লৈ, সেইবোৰ হোমবলিৰ সৈতে সুঘ্ৰাণৰ অৰ্থে বেদীত জ্বলাই দিবা। ই যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","তুমি হাৰোণক পবিত্রকৰণৰ অৰ্থে লোৱা মেৰ-ছাগৰ বুকু ল’বা, আৰু ওপৰলৈ তুলি লৈ, যিহোৱাক দিয়াৰ দৰে উপহাৰ দিবা। তাৰ পাছত সেই অংশ তোমাৰ খোৱাৰ বাবে থবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","মোলৈ হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ পবিত্রকৰণৰ যি মেৰ-ছাগটোৰ বুকু ওপৰলৈ তুলি ধৰিবা আৰু উপহাৰ দিয়া কৰঙণ, সেই দুয়োটাকে তুমি পবিত্ৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ইস্রায়েলী সকলৰ পৰা পোৱা হাৰোণ আৰু তেওঁৰ বংশৰ লোকসকলৰ এয়ে চিৰস্থায়ী বিধি হ’ব। কিয়নো সেয়ে উত্তোলনীয় উপহাৰ। ইস্ৰায়েলী লোকসকলৰ মঙ্গলাৰ্থক বলিৰ পৰা দিবলগীয়া এয়ে যিহোৱাৰ উদ্দেশ্যে তেওঁলোকৰ উত্তোলনীয় উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","পবিত্র বস্ত্ৰ পিন্ধি অভিষিক্ত আৰু নিযুক্ত হ’বলৈ হাৰোণৰ পাছত তেওঁৰ পবিত্ৰ বস্ত্ৰ তেওঁৰ পুত্ৰসকলৰ বাবে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","তেওঁৰ পুত্ৰসকলৰ মাজৰ যি জনে তেওঁৰ সলনি পুৰোহিত হৈ পবিত্ৰ-স্থানত পৰিচৰ্যা কৰিবলৈ সাক্ষাৎ কৰা তম্বুত সোমাব, সেই জনেই সেই বস্ত্ৰ সাত দিন পিন্ধিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","তুমি মোৰ উদ্দেশ্যে পুৰোহিতসকলক পবিত্রকৃত কৰিবলৈ, মেৰ-ছাগ পোৱালিটোৰ মাংস এক পবিত্ৰ স্থানত সিজাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে সেই মেৰ-ছাগ মাংস আৰু পাচিত থকা পিঠা ভোজন কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","মোৰ পৰিচৰ্যাৰ বাবে তেওঁলোকক পবিত্ৰ কৰিবলৈ আৰু তেওঁলোকৰ প্ৰায়শ্চিত্ত হ’বলৈ, তেওঁলোকে মাংস আৰু পিঠা ভোজন কৰিব। কিন্তু আন কোনো লোকে সেইবোৰ ভোজন কৰিব নালাগে; কাৰণ সেই সকলো পবিত্ৰ বস্তু। ");
INSERT INTO asmfb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","সেই নিযুক্তকৰণৰ মাংস আৰু পিঠাৰ পৰা যদি কিছু অৱশিষ্ট ৰাতিপুৱালৈকে থাকি যায়, তেনেহ’লে সেই অৱশিষ্ট ভাগ জুইত পুৰি ভস্ম কৰিব লাগিব। এইটো কোনেও ভোজন কৰিব নোৱাৰিব, কাৰণ সেয়ে মোৰ বাবে পবিত্রকৃত কৰি ৰখা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","মই তোমাক কৰিবলৈ দিয়া সকলো আজ্ঞা অনুসাৰে, হাৰোণ আৰু তেওঁৰ পুত্ৰসকললৈ কৰিবা। এনেকি তেওঁলোকক মোৰ বাবে পবিত্রকৃত কৰিবলৈ তুমি সাত দিন ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","তুমি প্ৰায়শ্চিত্তৰ বাবে প্ৰতি দিনে পাপাৰ্থক বলিৰূপে এটা ভতৰা গৰু বলি দিবা। এইদৰে প্ৰায়শ্চিত্ত বেদীক শুচি কৰিবলৈ ইয়াকে কৰিব লাগিব। এই বেদী পবিত্ৰ কৰি ইয়াক অভিষেক কৰিবা, আৰু মোৰ বাবে পৃথক কৰি ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","তুমি সাত দিন ধৰি প্ৰায়শ্চিত্ত কৰি বেদীক পবিত্ৰ কৰিবা। তাৰ পাছত সেই বেদী অতি পবিত্ৰ হ’ব। বেদীৰ সংস্পৰ্শত যি কোনোৱে আহিব, তেৱোঁ পবিত্ৰ হৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","সেই যজ্ঞবেদীৰ ওপৰত তুমি প্রতিদিনে সদায় এবছৰীয়া দুটা মেৰ-ছাগ পোৱালি বলি উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","তাৰে এটা ৰাতিপুৱা, আনটো গধূলি উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","প্ৰথম মেৰ-ছাগ পোৱালিটোৰ লগত হিনৰ চাৰি ভাগৰ এভাগ খুন্দি উলিওৱা হিন তেল মিহলোৱা এক ঐফাৰ দহ ভাগৰ এভাগ মিহি আটাগুড়ি, আৰু পেয় নৈবেদ্যৰ বাবে হিনৰ চাৰিভাগৰ এভাগ দ্ৰাক্ষাৰস দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","দ্বিতীয় মেৰ-ছাগ পোৱালিটো গধূলি উৎসৰ্গ কৰিবা। ৰাতিপুৱাৰ ভক্ষ্য আৰু পেয় নৈবেদ্যৰ দৰেই কৰিবা; সেয়ে সুমধুৰ সুগন্ধ উৎপন্ন কৰি যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","তোমাৰ সৈতে কথা পাতিবলৈ য’ত মই তোমাক সাক্ষাৎ কৰিম, সেই সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত যিহোৱাৰ সন্মুখত এয়ে তোমালোকৰ পুৰুষানুক্ৰমে সদায় কৰিবলগীয়া হোমবলি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","সেই ঠাইতে মই ইস্ৰায়েলী লোকসকলৰ সৈতে সাক্ষাৎ কৰিম; তাতে মোৰ প্ৰতাপৰ দ্বাৰাই সেই তম্বু পবিত্ৰকৃত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","মই সেই সাক্ষাৎ কৰা তম্বু আৰু যজ্ঞবেদী পবিত্ৰ কৰিম, আৰু মোৰ অৰ্থে পুৰোহিত কাৰ্য কৰিবলৈ হাৰোণক আৰু তেওঁৰ পুত্ৰসকলকো পবিত্ৰ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","মই ইস্ৰায়েলী লোকসকলৰ মাজত বাস কৰিম, আৰু তেওঁলোকৰ ঈশ্বৰ হম। ");
INSERT INTO asmfb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","তেতিয়া যিজন সৰ্বশক্তিমান ঈশ্বৰে তেওঁলোকৰ মাজত বাস কৰিবলৈ তেওঁলোকক মিচৰ দেশৰ পৰা উলিয়াই আনিলে, তেওঁলোকৰ সেই ঈশ্বৰ যিহোৱা যে মই, সেই কথা তেওঁলোকে জানিব। ময়েই তেওঁলোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","তুমি ধূপ জ্বলাবৰ বাবে চিটীম কাঠেৰে এটা বেদী সাজিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","সেয়ে এহাত দীঘল, এহাত বহল হ’ব; আৰু সেই বেদীৰ চাৰিওদিশ সমান হ’ব। ওখই দুহাত; তাৰ শিংবোৰ একে ডোখৰ কাঠেৰে হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","তুমি বেদীটোৰ ওপৰত, চাৰিও ফালে আৰু শিংবোৰত শুদ্ধ সোণৰ পতা মাৰি আৱৰণ কৰিবা। তাৰ চাৰিওফালৰ কিনাৰত সোণ লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","তুমি সোণৰ দুটা আঙঠি গঢ়াই, কিনাৰৰ তলত দুই কাষৰ দুই চুকৰ ওপৰত লগাবা। বেদীটো বৈ নিবলৈ আঙঠি দুটা কানমাৰি সুমুউৱাৰ ঠাই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","সেই কানমাৰি চিটীম কাঠেৰে সাজিবা, আৰু তাত সোণৰ পতা মাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","তুমি ধূপবেদিটো সাক্ষ্য-ফলিৰ নিয়ম চন্দুকৰ পৰ্দাৰ আগফালে ৰাখিব লাগিব। সেই পৰ্দা সাক্ষ্য-ফলিৰ নিয়ম চন্দুকৰ ওপৰত থকা পাপাবৰণৰ ওচৰত থাকিব। সেই ঠাইতে মই তোমালোকৰ সৈতে সাক্ষাৎ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","হাৰোণে প্রতি ৰাতিপুৱা সুগন্ধি ধূপ জ্বলাব। প্ৰতি ৰাতিপুৱা প্ৰদীপ পৰিষ্কাৰ কৰা সময়ত তেওঁ সেই ধূপ জ্বলাব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","গধূলিও প্ৰদীপ জ্বলোৱাৰ সময়ত তেওঁ ধূপ জ্বলাব। সেয়ে তোমালোকৰ পুৰুষানুক্ৰমে যিহোৱাৰ সন্মুখত নিত্য ধূপদাহ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","তোমালোকে তাৰ ওপৰত সাধাৰণ ধূপ, বা হোম বলি, বা ভক্ষ্য নৈবেদ্য উৎসৰ্গ নকৰিবা, আৰু তাৰ ওপৰত পেয় নৈবেদ্যও নাঢালিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","বছৰত এবাৰ হাৰোণে তাৰ শিংবোৰ পবিত্রকৃত কৰিব। তোমালোকৰ পুৰুষানুক্ৰমে প্ৰায়শ্চিত্তাৰ্থক পাপ-বলিৰ তেজেৰে তেওঁ বছৰত এবাৰ পবিত্রকৃত কৰিব। এই বেদী যিহোৱাৰ উদ্দেশ্যে অতি পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“তুমি যেতিয়া ইস্ৰায়েলৰ জনসংখ্যা গণনা কৰিবা, তেতিয়া তেওঁলোকৰ প্ৰতিজনে যিহোৱাৰ উদ্দেশ্যে নিজৰ নিজৰ প্ৰাণৰ অৰ্থে মুক্তি ধন দিব লাগিব। তুমি তোমাৰ পাছত তেওঁলোকৰ গণনা কৰিব লাগিব। তুমি তেওঁলোকক গণনা কৰিবা, তাতে তেওঁলোকৰ মাজত মহামাৰী নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","প্রতিজন লোকে গণনা কৰা সময়ত আধা চেকল ৰূপ দিব লাগিব। তেওঁ পবিত্ৰ-স্থানৰ চেকল অনুসাৰে আধা চেকল দিব। আধা চেকলত বিশ গেৰা হয়; সেই আধা চেকল যিহোৱাৰ উদ্দেশ্যে দিবলগা উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","বিশ বছৰ আৰু তাতকৈ অধিক বয়সৰ লোক প্রতিজনে গণনা কৰা সময়ত, যিহোৱালৈ উপহাৰ দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","তোমালোকে প্ৰাণৰ অৰ্থে প্ৰায়শ্চিত্ত কৰিবলৈ যিহোৱাৰ সেই উপহাৰ দিয়াৰ সময়ত, ধনী লোকসকলে আধা চেকলতকৈ অধিক নিদিব, আৰু দুখীয়া লোকসকলে তাতকৈ কম নিদিব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","তুমি ইস্ৰায়েলী লোকসকলৰ পৰা সেই প্ৰায়শ্চিত্তৰ ধন ল’ব লাগিব, আৰু সেই ধন সাক্ষাৎ কৰা তম্বুৰ কাৰ্যৰ অৰ্থে দিব লাগিব। তোমালোকৰ প্ৰাণৰ প্ৰায়শ্চিত্তৰ বাবে সেয়ে ইস্ৰায়েলী লোকসকলৰ সোঁৱৰণৰ অৰ্থে যিহোৱাৰ আগত থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“প্রক্ষালনৰ বাবে তুমি পিতলৰ এটা প্ৰক্ষালন-পাত্ৰ গঢ়াবা, আৰু তাত পিতলৰ খুৰা লগাবা। তুমি সেই প্রক্ষালন পাত্র সাক্ষাৎ কৰা তম্বু আৰু হোম বেদীৰ মাজত থবা; আৰু তুমি ইয়াৰ ভিতৰত পানী ভৰাই ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে তাত থকা পানী লৈ নিজৰ হাত ভৰি ধুব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","তেওঁলোকে যেতিয়া সাক্ষাৎ কৰা তম্বুত সোমাব, বা যিহোৱাৰ পৰিচৰ্যা কৰিবলৈ, তেওঁৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ দগ্ধ কৰিবলৈ বেদীৰ ওচৰলৈ যাব, তেতিয়া তেওঁলোকৰ যেন মৃত্যু নহয়, সেই কাৰণে তেওঁলোকে নিজৰ হাত ভৰি ধুব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","তেওঁলোকৰ মৃত্যু নহবলৈ তেওঁলোকৰ নিজৰ হাত ভৰি ধুব লাগিব। এয়ে তেওঁ আৰু তেওঁৰ বংশৰ পুৰুষানুক্ৰমে পালন কৰিব লগীয়া চিৰস্থায়ী বিধি হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“তুমি নিজৰ বাবে বিশেষ বিশেষ সুগন্ধি দ্ৰব্য, অৰ্থাৎ পবিত্ৰ-স্থানৰ চেকল অনুসাৰে, পাঁচশ চেকল গন্ধৰস, আৰু দুশ পঞ্চাশ চেকল সুগন্ধি ডালচেনি, দুশ পঞ্চাশ চেকল সুগন্ধি বচ, ");
INSERT INTO asmfb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","পাঁচ শ চেকল তেজপাত, আৰু এক হিন জিতগছৰ তেল ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","সেইবোৰেৰে তুমি অভিষেকৰ অৰ্থে পবিত্ৰ তেল, অৰ্থাৎ সুগন্ধি দ্ৰব্য ব্যৱসায়ীয়ে তৈয়াৰ কৰা অনুসাৰে সুগন্ধি তেল যুগুত কৰিবা। সেয়ে অভিষেকৰ পবিত্ৰ তেল হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","তুমি সাক্ষাৎ কৰা তম্বু, সাক্ষ্য ফলিৰ নিয়ম চন্দুক, ");
INSERT INTO asmfb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","মেজ আৰু তাৰ সকলো সঁজুলি, দীপাধাৰ আৰু তাৰ সঁজুলিবোৰ, ধূপ বেদী, ");
INSERT INTO asmfb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","হোমবেদি আৰু তাৰ সকলো সঁজুলি, প্ৰক্ষালন পাত্ৰ আৰু তাৰ খুৰা সেই অভিষেক তেলেৰে অভিষেক কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","সেই সকলোকে অভিষেক কৰি পবিত্ৰ কৰিবা; তাতে সেই সকলো বস্তু মোৰ বাবে পবিত্ৰ আৰু সংৰক্ষিত হ’ব। সেইবোৰৰ সংস্পৰ্শত যি লোক আহিব, তেৱোঁ পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","মোৰ উদ্দেশ্যে পুৰোহিত কাৰ্য কৰিবলৈ, তুমি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক অভিষেক কৰি তেওঁলোকক পবিত্ৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","তুমি ইস্ৰায়েলী লোকসকলক কবা, “তোমালোকৰ পুৰুষানুক্ৰমে মোৰ বাবে সেয়ে অভিষেকৰ পবিত্ৰ তেল হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","মানুহৰ গাত সেই তেল ব্যৱহাৰ কৰা নহ’ব। সেই তেলৰ সূত্র অনুসাৰে, সেই তেলৰ দৰে আন কোনো তেল প্রস্তুত কৰা নহ’ব; কাৰণ সেয়ে মোৰ বাবে পবিত্ৰ কৰি সংৰক্ষিত কৰা তেল। ");
INSERT INTO asmfb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","যি কোনোৱে এই তেলৰ দৰে আন সুগন্ধি প্রস্তুত কৰিব, বা যি কোনোৱে গাত তাৰ অলপো লগাব, তেওঁক নিজৰ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","যিহোৱাই মোচিক ক’লে, “তুমি নিজৰ বাবে সুগন্ধি দ্ৰব্য, অৰ্থাৎ নাটাফ, নখী, হেল্বনা, এই সকলো সুগন্ধি দ্ৰব্যৰ, আৰু নিৰ্মল কুন্দুৰুৰ প্ৰতিটো সমান পৰিমাণে লোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","সেইবোৰৰ দ্বাৰাই সুগন্ধি-দ্ৰব্য ব্যৱসায়ীৰ সূত্র অনুসাৰে লোণ মিহলোৱা এক নিৰ্মল পবিত্ৰ সুগন্ধি ধূপ যুগুত কৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","সেই ধূপ গুড়ি কৰি মিহি কৰিবা, যি সাক্ষাৎ কৰা তম্বুত মই তোমাৰে সৈতে সাক্ষাৎ কৰিম, সেই সাক্ষ্য ফলিৰ নিয়ম চন্দুকৰ সন্মুখত তাক থবা। সেয়ে তোমালোকলৈ অতি পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","তুমি যি সুগন্ধি ধূপ প্রস্তুত কৰিবা, সেই সূত্র অনুসাৰে তোমালোকৰ বাবে ধূপ প্রস্তুত নকৰিবা। সেয়ে তোমাৰ মানত যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","যি কোনোৱে নিজৰ বাবে এইদৰে সুগন্ধি তৈয়াৰ কৰিব, তেওঁক নিজৰ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","তাৰ পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“চোৱা, মই যিহূদা ফৈদৰ পৰা হূৰ, হূৰৰ পুত্র ঊৰী, ঊৰীৰ পুত্ৰ বচলেলক নাম কাঢ়ি মাতিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","মই বচলেলক মোৰ আত্মাৰে পৰিপূৰ্ণ কৰিম, তেওঁলৈ সকলো প্রকাৰ শিল্পকৰ্মৰ বাবে প্রজ্ঞা, বুদ্ধি, আৰু জ্ঞান দিম। ");
INSERT INTO asmfb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","সোণ, ৰূপ, আৰু পিতলত শিল্পিসুলভ নক্সাৰে কাম কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","তেওঁ পাথৰ কটা, পাথৰ খটোৱা আৰু কাঠৰ কাম, এই সকলো প্রকাৰৰ শিল্পকৰ্ম কৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","চোৱা, মই দান ফৈদৰ অহীচামকৰ পুত্ৰ অহলীয়াবক তেওঁৰ সহকাৰী নিযুক্ত কৰিলোঁ। সকলো জ্ঞানী লোকৰ হৃদয়ত দক্ষতাৰে পৰিপূৰ্ণ কৰিলোঁ; সেয়ে মই তোমাক যিবোৰ নিৰ্মাণ কৰিবলৈ আজ্ঞা দিলোঁ, সেই সকলোবোৰ তেওঁলোকে নিৰ্মাণ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","সাক্ষাৎ কৰা তম্বু, সাক্ষ্য-ফলিৰ নিয়ম চন্দুক, আৰু নিয়ম চন্দুকৰ ওপৰত থকা পাপাবৰণ, আৰু তম্বুৰ সকলো আচবাবপত্র। ");
INSERT INTO asmfb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","মেজ আৰু তাৰ সামগ্রী, শুদ্ধ সোণৰ দীপাধাৰাৰ সৈতে তাৰ সকলো সামগ্রী, ধূপবেদী, ");
INSERT INTO asmfb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","হোমবেদিৰ সৈতে সকলো সামগ্রী, প্ৰক্ষালন-পাত্ৰৰ সৈতে তাৰ খুৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","এই সকলো বোৱা বস্ত্রৰ লগত সংযুক্ত কৰা হৈছিল। পুৰোহিতৰ পৰিচৰ্যাৰ বাবে পুৰোহিত হাৰোণ আৰু তেওঁৰ পুত্ৰসকল বাবে এই সকলো পবিত্ৰ বস্ত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","অভিষেক তেল, আৰু পবিত্ৰ স্থানৰ বাবে মধুৰ সুগন্ধি ধূপ। মই যিদৰে তোমাক আজ্ঞা কৰিলোঁ, সেইদৰেই শিল্পকাৰ সকলে সকলো বস্তু তৈয়াৰ কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“তুমি ইস্ৰায়েলী লোকসকলক কোৱা, ‘তোমালোকে নিশ্চয় মোৰ বিশ্ৰাম-দিন পালন কৰিব লাগিব। ময়েই যে তোমালোকৰ যিহোৱা, ইয়াক যেন তোমালোকে বুজি পোৱা, সেই বাবে তোমালোকৰ পুৰুষানুক্ৰমে মোৰ আৰু তোমালোকৰ মাজত এয়ে এক চিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","সেয়ে তোমালোকে বিশ্ৰাম-দিন পালন কৰিব লাগিব; কিয়নো তোমালোকৰ বাবে সেয়ে পবিত্ৰ দিন। যিজনে সেই দিন অপবিত্ৰ কৰিব, অৱশ্যেই তেওঁৰ প্ৰাণ দণ্ড হ’ব; কিয়নো যিকোনোৱে সেই দিনা কাম কৰিব, তেওঁক নিজৰ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ছয়দিন কাম কৰিব লাগিব, কিন্তু সপ্তম দিন সম্পূৰ্ণ বিশ্ৰামৰ বাবে বিশ্ৰাম-দিন হ’ব। সেয়ে যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ দিন; সেই বিশ্ৰাম দিনত যি কোনোৱে কাম কৰিব, তাৰ অৱশ্যেই প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","এই হেতুকে ইস্ৰায়েলী লোকসকলে চিৰস্থায়ী বিধিৰূপে পুৰুষানুক্ৰমে মানি চলিবলৈ এই বিশ্ৰাম দিন পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","মোৰ আৰু ইস্ৰায়েলী লোকসকলৰ মাজত এয়ে চিৰস্থায়ী চিন হ’ব; কাৰণ যিহোৱাই ছয়দিনতে আকাশ-মণ্ডল আৰু পৃথিৱী সৃষ্টি কৰি সপ্তম দিনা বিশ্ৰাম কৰিবৰ বাবে বিশ্রাম লৈছিল’।” ");
INSERT INTO asmfb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","যিহোৱাই যেতিয়া চীনয় পৰ্ব্বতত মোচিৰ সৈতে কথা পাতি শেষ কৰিলে, তেতিয়া ঈশ্বৰে নিজৰ হাতেৰে লিখা সাক্ষ্য-ফলি দুখন মোচিক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","পৰ্ব্বতৰ পৰা নামি আহিবলৈ মোচিৰ পলম হোৱা দেখি, লোকসকলে হাৰোণৰ চাৰিওফালে গোট খাই তেওঁক ক’লে, “আহক, আমাৰ আগে আগে যাবৰ বাবে আমাৰ অৰ্থে এজন দেৱতা নিৰ্মাণ কৰোঁ। কিয়নো যি দেৱতবোৰে আমাক মিচৰ দেশৰ পৰা উলিয়াই আনিছিল, সেই মোচিৰ লগত কি হ’ল, সেই বিষয়ে আমি একো নাজানো।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","তেতিয়া হাৰোণে তেওঁলোকক ক’লে, “আপোনালোকে আপোনালোকৰ ভাৰ্যা, পুত্র আৰু জীয়েক সকলৰ কাণৰ সোণৰ ফুলিবোৰ সোলোকাই মোৰ ওচৰলৈ আনক।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","সকলো লোকে নিজৰ নিজৰ কাণৰ পৰা সোণৰ ফুলিবোৰ সোলোকাই হাৰোণৰ ওচৰলৈ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","হাৰোণে তেওঁলোকৰ পৰা সোণ ল’লে, আৰু সেইবোৰ সাঁচত ঢলি এটা দামুৰিৰ আকৃতিৰে সোণৰ দামুৰি তৈয়াৰ কৰিলে। তাৰ পাছত লোকসকলে ক’লে, “হে ইস্ৰায়েল, মিচৰ দেশৰ পৰা তোমাক উলিয়াই অনা ঈশ্বৰ এয়া।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","হাৰোণে যেতিয়া এইবোৰ দেখিলে, তেতিয়া সেই দামুৰিটোৰ আগত এটা যজ্ঞবেদী নিৰ্মাণ কৰিলে; আৰু “কাইলৈ যিহোৱাৰ সন্মানৰ উদ্দেশ্যে উৎসৱ হ’ব”; এইবুলি তেওঁ ঘোষণা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","লোকসকলে তাৰ পাছ দিনা ৰাতিপুৱাতে উঠি হোম-বলি উৎসৰ্গ কৰিলে, আৰু মঙ্গলাৰ্থক বলি দিলে। তাৰ পাছত তেওঁলোকে ভোজন পান কৰিবলৈ বহিলে, আৰু ভোজন কৰাৰ পাছত উঠি আনন্দেৰে উৎসৱ পালন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","তেতিয়া যিহোৱাই মোচিক ক’লে, “তুমি তোমাৰ লোকসকলৰ ওচৰলৈ বেগাই যোৱা; কাৰণ যি লোকসকলক তুমি মিচৰ দেশৰ পৰা উলিয়াই আনিলা, তেওঁলোকে নিজেই নিজকে ভ্ৰষ্ট কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","তেওঁলোকক যি পথত যাবলৈ মই আজ্ঞা দিছিলোঁ, সেই পথৰ পৰা তেওঁলোকে ক্ষিপ্রবেগে ঘূৰিলে। তেওঁলোকে নিজৰ বাবে সাঁচত ঢলা এটা দামুৰি নিৰ্মাণ কৰিলে, আৰু তাৰ আগত প্ৰণিপাত কৰিলে। তেওঁলোকে ক’লে, ‘হে ইস্ৰায়েল, মিচৰ দেশৰ পৰা তোমাক উলিয়াই অনা ঈশ্বৰ এয়া’।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","যিহোৱাই মোচিক পুনৰ ক’লে, “মই সেই লোকসকলক দেখিলোঁ। চোৱা, তেওঁলোক ঠৰডিঙীয়া লোক। ");
INSERT INTO asmfb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","সেয়ে এতিয়া মোক বাধা দিবলৈ চেষ্টা নকৰিবা। তেওঁলোকৰ বিৰুদ্ধে মোৰ ক্ৰোধ প্ৰজ্বলিত হৈছে, সেয়ে মই তেওঁলোকক সংহাৰ কৰিম। তাৰ পাছতহে মই তোমাৰ পৰা এক মহাজাতি উৎপন্ন কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","কিন্তু মোচিয়ে তেওঁৰ ঈশ্বৰ যিহোৱাক শান্ত কৰিবলৈ চেষ্টা কৰি ক’লে, “হে যিহোৱা, আপোনাৰ লোকসকলৰ বিৰুদ্ধে কিয় ক্ৰোধ প্ৰজ্বলিত হৈছে; কাৰণ তেওঁলোকক আপুনি মহা পৰাক্ৰম আৰু বলৱান হাতেৰে মিচৰ দেশৰ পৰা উলিয়াই আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","মিচৰীয়া লোকসকলক কিয় ক’ব দিব যে, ‘তেওঁলোকক পৰ্ব্বতীয়া অঞ্চলত বিনষ্ট কৰি পৃথিৱীৰ পৰা লুপ্ত কৰিবৰ বাবেহে তেওঁ তেওঁলোকক বাহিৰ কৰি আনিলে’। আপুনি নিজৰ প্ৰচণ্ড ক্ৰোধৰ পৰা ঘূৰি নিজৰ লোকসকলৰ অপকাৰ কৰাৰ বিষয়ে ক্ষান্ত হওক। ");
INSERT INTO asmfb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","আপোনাৰ দাস অব্ৰাহাম, ইচহাক, আৰু ইস্ৰায়েলক সোঁৱৰণ কৰক। তেওঁলোকৰ আগত আপুনি নিজৰ নামেৰে শপত দি তেওঁলোকক কৈছিলে, ‘মই আকাশৰ তৰাবোৰৰ নিচিনাকৈ তোমালোকৰ বংশ বৃদ্ধি কৰিম, আৰু এই যি দেশৰ কথা কলোঁ, সেই গোটেইখন দেশ তোমালোকৰ বংশক দিম। তেওঁলোকে চিৰকাল অধিকাৰ কৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","তেতিয়া যিহোৱাই নিজৰ লোকসকলৰ যি অপকাৰ কৰিম বুলি কৈছিল, তাৰ পৰা ক্ষান্ত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","তাৰ পাছত মোচিয়ে ঘূৰি, সাক্ষ্য ফলি দুখন হাতত লৈ পৰ্ব্বতৰ পৰা নামি আহিল। সেই ফলিৰ আগফালৰ আৰু পিছফালৰ দুয়ো পিঠিতে লিখা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","সেই ফলি দুখন ঈশ্বৰে নিজৰ হাতেৰে তৈয়াৰ কৰা। সেই দুখন ফলিৰ লিখনীও ঈশ্বৰে নিজে লিখা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","যিহোচূৱাই যেতিয়া লোকসকলৰ চিঞঁৰ শুনিলে, তেতিয়া তেওঁ মোচিক ক’লে, “ছাউনিত যুদ্ধৰ শব্দ হৈছে।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","কিন্তু মোচিয়ে তেওঁক ক’লে, “এয়ে জয় ধ্বনিৰ শব্দ নহয়; আৰু পৰাজয়ী লোকসকলৰো শব্দ নহয়, কিন্তু গান গোৱাৰহে শব্দ মই শুনিবলৈ পাইছোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","মোচিয়ে যেতিয়া তম্বুৰ ওচৰ চাপি আহিল, তেতিয়া তেওঁ সেই দামুৰিটোক দেখিলে, আৰু লোকসকলে তেতিয়া নাচি আছিল। তেওঁ ক্রোধাম্বিত হ’ল। তেওঁৰ হাতৰ পৰা সেই ফলি দুখন পৰি গ’ল; আৰু পৰ্ব্বতৰ তলত পৰি ভাঙি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","লোকসকলে নিৰ্মাণ কৰা দামুৰিটো লৈ জুইত পুৰি দিলে। পুৰা দামুৰিটোক পিহি ধূলিৰ নিচিনা কৰি পানীত মিহলাই ইস্ৰায়েলী লোকসকলক পান কৰালে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","তাৰ পাছত মোচিয়ে হাৰোণক ক’লে, “এই লোকসকলে তোমাক কি কৰিছিল, যে তুমি তেওঁলোকক এনে মহাপাপত পেলালা?” ");
INSERT INTO asmfb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","হাৰোণে ক’লে, “হে মোৰ প্ৰভু, আপোনাৰ ক্ৰোধ প্ৰজ্বলিত নহওঁক; আপুনি এই লোকসকলক জানে, যে তেওঁলোক দুষ্ট কাৰ্যত কিমান আসক্ত। ");
INSERT INTO asmfb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","তেওঁলোকে মোক ক’লে, ‘আমাৰ আগে আগে যাবৰ বাবে আমাৰ অৰ্থে এজন দেৱতা নিৰ্মাণ কৰক; কাৰণ যি মোচিয়ে আমাক মিচৰ দেশৰ পৰা উলিয়াই আনিলে, সেই মোচিৰ কি হ’ল, সেই বিষয়ে আমি নাজানো’। ");
INSERT INTO asmfb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","সেয়ে মই তেওঁলোকক ক’লোঁ, ‘যি কোনো লোকৰ সোণৰ অলঙ্কাৰ আছে, সেই সকলোবোৰ সোলোকাই দিয়ক’। তেতিয়া তেওঁলোকে সেই সোণবোৰ মোক দিলে, আৰু মই সেইবোৰ জুইত পেলাই দিলোঁ; আৰু এই দামুৰি বাহিৰলৈ ওলাই আহিল।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","মোচিয়ে দেখিলে যে, হাৰোণৰ লোকসকলৰ ওপৰত নিয়ন্ত্রণ হেৰাইছে আৰু তেওঁলোকে নিজৰ ইচ্ছামতে চলি, তেওঁলোক শত্রুবোৰৰ আগত হাঁহিয়াতৰ পাত্র হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","তেতিয়া মোচিয়ে তম্বুৰ প্রবেশ দুৱাৰত থিয় হৈ ক’লে, “যিজন যিহোৱাৰ ফলীয়া, তেওঁ মোৰ ওচৰলৈ আহক।” লেবীৰ সকলো লোক তেওঁৰ চাৰিওকাষে গোট খালে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","তেতিয়া মোচিয়ে তেওঁলোকক ক’লে, “ইস্ৰায়েলৰ ঈশ্বৰ যিহোৱাই এই কথা কৈছে, ‘তোমালোক প্ৰতিজনে নিজৰ তৰোৱাল নিজৰ কাষত বান্ধা, আৰু তম্বুৰ চাৰিওফালৰ এটা প্রবেশ দুৱাৰৰ পৰা আন প্রবেশ দুৱাৰলৈকে ঘূৰি গৈ নিজৰ ভাই, বন্ধু আৰু চুবুৰীয়া সকলক বধ কৰা’।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","তেতিয়া লেবীয়া লোকসকলে মোচিয়ে কোৱাৰ দৰেই কৰিলে। সেইদিনা লোকসকলৰ মাজত প্রায় তিনি হাজাৰ লোকৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","মোচিয়ে লেবীয়া লোকসকলক ক’লে, “আজিৰ পৰা যিহোৱাই তোমালোকক তেওঁৰ সেৱাৰ বাবে উৎসৰ্গ কৰিলে; কাৰণ তোমালোক প্রতিজনে তোমালোকৰ ভাইসকলৰ বিৰুদ্ধে কাৰ্য কৰিলা, সেয়ে যিহোৱা তোমালোকক আজি আশীৰ্ব্বাদ কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","তাৰ পাছদিনা মোচিয়ে লোকসকলক ক’লে, “তোমালোকে মহাপাপ কৰিলা। মই এতিয়া যিহোৱাৰ ওচৰলৈ যাওঁ; যদি পাৰোঁ তেনেহ’লে মই তোমালোকৰ পাপৰ প্ৰায়শ্চিত্ত কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","মোচিয়ে যিহোৱাৰ ওচৰলৈ উভটি গৈ ক’লে, “হায় হায়, এই লোকসকলে মহাপাপ কৰিলে; আৰু নিজৰ বাবে এটা সোণৰ দেৱতা নিৰ্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","তথাপি এতিয়া অনুগ্রহ কৰি তেওঁলোকক ক্ষমা কৰক; কিন্তু যদি আপুনি ক্ষমা নকৰে, তেনেহ’লে আপুনি লিখা আপোনাৰ পুস্তকৰ পৰা মোৰ নাম বাহিৰ কৰি দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","যিহোৱাই মোচিক ক’লে, “যি জনে মোৰ বিৰুদ্ধে পাপ কৰিলে, সেই জনৰ নামহে মই মোৰ পুস্তকৰ পৰা বাহিৰ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","এতেকে এতিয়া যোৱা, মই যি দেশৰ বিষয়ে তোমাক কৈছিলোঁ, সেই দেশলৈকে লোকসকলক লৈ যোৱা। চোৱা, মোৰ দূত তোমাৰ আগে আগে যাব; কিন্তু যি দিনা তেওঁলোকে দণ্ড পাব লাগে; সেই দিনা তেওঁলোকৰ পাপৰ দণ্ড মই দিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","তাৰ পাছত যিহোৱাই লোকসকলৰ ওপৰত মহামাৰী পঠাই আঘাত কৰিলে; কিয়নো লোকসকলে হাৰোণক দামুৰি নিৰ্মাণ কৰিবলৈ বাধ্য কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","যিহোৱাই মোচিক ক’লে, “ইয়াৰ পৰা যোৱা, যি দেশ তোমাৰ বংশক দিম বুলি মই অব্ৰাহাম, ইচহাক, আৰু যাকোবৰ আগত শপত কৰিছিলোঁ, সেই দেশলৈ, মিচৰ দেশৰ পৰা বাহিৰ কৰি অনা লোকসকলৰ সৈতে তুমি যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","মই তোমাৰ আগে আগে এজন দূত পঠাম, আৰু কনানীয়া, ইমোৰীয়া, হিত্তীয়া, পৰিজ্জীয়া, হিব্বীয়া, আৰু যিবুচীয়া লোকসকলক খেদিম। ");
INSERT INTO asmfb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","গাখীৰ আৰু মৌজোল বৈ থকা দেশলৈ যোৱা। কিন্তু মই তোমালোকৰ লগত নাযাওঁ; কাৰণ তোমালোক ঠৰডিঙীয়া লোক। মই হয়তো বাটতে তোমালোকক বিনষ্ট কৰিব পাৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","লোকসকলে যেতিয়া সেই সমস্যাৰ কথা শুনিলে, তেতিয়া তেওঁলোকে শোক কৰিলে; আৰু কোনো এজনেও অলঙ্কাৰ পৰিধান নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","যিহোৱাই মোচিক কৈছিল, “তুমি ইস্ৰায়েলী লোকসকলক এই কথা কোৱা, ‘তোমালোক ঠৰডিঙীয়া লোক। মই যদি তোমালোকৰ মাজলৈ এক মুহূৰ্তৰ বাবেও যাওঁ, তেনেহ’লে মই তোমালোকক বিনষ্ট কৰিম। সেয়ে তোমালোকৰ লগত মই কি কৰিব লাগে, সেই বিষয়ে যেতিয়ালৈকে মই সিদ্ধান্ত নলওঁ, তেতিয়ালৈকে তোমালোকে নিজৰ অলঙ্কাৰ খুলি ৰাখিব’।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","তেতিয়া ইস্ৰায়েলী লোকসকলে হোৰেব পৰ্ব্বতৰ পৰাই নিজৰ অলঙ্কাৰবোৰ পৰিধান নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","মোচিয়ে তম্বুৰ কাপোৰ এটা লৈ, তম্বুৰ বাহিৰত কিছু দূৰত তৰিলে; আৰু তাৰ নাম সাক্ষাৎ কৰা তম্বু ৰাখিলে। যিহোৱাক বিচাৰা প্ৰতিজনে তম্বুৰ বাহিৰত থকা সেই সাক্ষাৎ কৰা তম্বুলৈ যায়। ");
INSERT INTO asmfb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","মোচি যেতিয়া সেই তম্বুৰ ভিতৰলৈ যায়, তেতিয়া সকলো লোকে উঠি প্ৰতিজনে নিজৰ তম্বুৰ প্রবেশ দুৱাৰত থিয় হয়। মোচিয়ে যেতিয়ালৈকে সেই তম্বুত নোসোমায়, তেতিয়ালৈকে লোকসকলে মোচিক চাই থাকে। ");
INSERT INTO asmfb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","মোচি যেতিয়াই তম্বুত সোমায়, তেতিয়াই মেঘ-স্তম্ভ নামি আহি তম্বুৰ প্রবেশ দুৱাৰত স্থিতি লয়, আৰু যিহোৱাই মোচিৰে সৈতে কথা পাতে। ");
INSERT INTO asmfb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","লোকসকলে যেতিয়াই তম্বুৰ প্রবেশ দুৱাৰত মেঘ-স্তম্ভ স্থিতি হোৱা দেখে, তেতিয়াই প্ৰতিজনে নিজৰ তম্বুৰ প্রবেশ দুৱাৰত থিয় হৈ আৰাধনা কৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","যিদৰে মানুহে নিজৰ বন্ধুৰ লগত কথা পাতে, সেইদৰে যিহোৱাই মুখামুখি মোচিৰ লগত কথা পাতে। তাৰ পাছত মোচিয়ে তম্বুৰ পৰা ওলাই আহে, কিন্তু তেওঁৰ যুৱক পৰিচাৰক, নুনৰ পুত্ৰ যিহোচূৱা তম্বুৰ ভিতৰতে থাকে। ");
INSERT INTO asmfb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","মোচিয়ে যিহোৱাক ক’লে, “চাওক, আপুনি এই লোকসকলক লৈ মোক যাত্রা কৰিব কৈছে; কিন্তু মোৰ লগত যি জনক পঠাব, তেওঁৰ বিষয়ে আপুনি মোক জানিব দিয়া নাই। আপুনি কৈছিল, মই নামৰ দ্বাৰাই তোমাক জানো, আৰু তুমি মোৰ দৃষ্টিত অনুগ্ৰহ পালা। ");
INSERT INTO asmfb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","এতিয়া মই যদি আপোনাৰ দৃষ্টিত অনুগ্ৰহ পালোঁ, তেনেহ’লে বিনয় কৰিছোঁ, মই যেন আপোনাক জানি আপোনাৰ দৃষ্টিত অনুগ্ৰহ পাওঁ, সেই বাবে মোক আপোনাৰ পথ দেখাওক; আৰু এই লোকসকল যে আপোনাৰেই লোক ইয়াকো সোঁৱৰণ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","তেতিয়া যিহোৱাই উত্তৰ দিলে, “মই স্বয়ং তোমাৰ লগত যাম, আৰু মই তোমাক বিশ্ৰাম দিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","মোচিয়ে তেওঁক ক’লে, “যদি আপুনি স্বয়ং মোৰ লগত নাযায়, তেনেহ’লে আমাক ইয়াৰ পৰা লৈ নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","নহ’লে আমি কি দৰে বুজি পাম যে, আপোনাৰ দৃষ্টিত মই আৰু আপোনাৰ লোকসকলে অনুগ্ৰহ পাইছো ইয়াক কিহৰ দ্বাৰাই জনা যাব? আপুনি আমাৰ লগত যোৱাৰ দ্বাৰায়েই মই আৰু আপোনাৰ লোকসকল পৃথিৱীত থকা সকলো জাতিৰ পৰা পার্থক্য হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","যিহোৱাই মোচিক ক’লে, “এই যি কথা তুমি ক’লা, তাকো মই কৰিম। কিয়নো তুমি মোৰ দৃষ্টিত অনুগ্ৰহ পাইছা, আৰু মই তোমাক তোমাৰ নামে সৈতে জানো।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","তেতিয়া মোচিয়ে ক’লে, “বিনয় কৰিছোঁ মোক আপোনাৰ প্ৰতাপ দেখাওক।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","যিহোৱাই ক’লে, “মই তোমাৰ ওচৰেৰে মোৰ সকলো ধাৰ্মিকতা গমন কৰাম, আৰু তোমাৰ আগত মোৰ নাম ঘোষণা কৰিম। যাক মই অনুগ্ৰহ কৰিব খোজোঁ, তাক মই অনুগ্ৰহ কৰিম, আৰু যাক মই দয়া কৰিব খোজোঁ, তাক মই দয়া কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","কিন্তু যিহোৱাই পুনৰ ক’লে, “তুমি মোৰ চেহেৰা দেখা নোপোৱা; কাৰণ কোনো মানুহে মোক দেখাৰ পাছত জীয়াই নাথাকে।” ");
INSERT INTO asmfb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","যিহোৱাই ক’লে, “চোৱা, মোৰ ওচৰত এটা শিল আছে, আৰু তুমি সেই শিলটোৰ ওপৰত থিয় হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","তোমাৰ আগেদি যেতিয়া মোৰ প্ৰতাপ গমন কৰিব, তেতিয়া মই তোমাক শিলটোৰ ফাটত থম, আৰু মোৰ গমন শেষ নোহোৱালৈকে মোৰ হাতেৰে তোমাক ঢাকি ধৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","তাৰ পাছত মই তোমাৰ ওপৰৰ পৰা হাত গুচাম, আৰু তুমি মোৰ পাছফাল দেখিবলৈ পাবা, কিন্তু মোৰ মুখ দেখা নাপাবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","যিহোৱাই মোচিক ক’লে, “তুমি প্রথম ফলিৰ দৰে দুখন শিলৰ ফলি কাটা। তুমি ভঙা আগৰ সেই ফলি দুখনত যি যি লিখা আছিল, সেই সকলো কথা, মই পুনৰ এই দুখন ফলিত লিখিম। ");
INSERT INTO asmfb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","তুমি ৰাতিপুৱাতে যুগুত হৈ চীনয় পৰ্ব্বতলৈ উঠি আহিবা। পৰ্ব্বতৰ ওপৰত মোৰ ওচৰত উপস্থিত হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","আন কোনো লোক তোমাৰ লগত নাহিব; আৰু গোটেই পৰ্ব্বতত কোনো লোক যেন দেখা পোৱা নাযায়। গৰু মেৰ-ছাগৰ জাকোবোৰো যেন পৰ্ব্বতৰ আগত চৰি নাথাকে।” ");
INSERT INTO asmfb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","সেয়ে মোচিয়ে আগৰ নিচিনা শিলৰ দুখন ফলি কাটি, যিহোৱাৰ আজ্ঞা অনুসাৰে ৰাতিপুৱাই উঠি চীনয় পৰ্ব্বতলৈ গ’ল। যিহোৱাই নিৰ্দেশ দিয়া অনুসাৰে শিলৰ সেই ফলি দুখনো লগত লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","যিহোৱা মেঘৰ মাজত নামি আহিল; আৰু মোচিৰ সৈতে সেই ঠাইত থিয় হ’ল। তেওঁ “যিহোৱা” নাম উচ্চাৰণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","যিহোৱাই তেওঁৰ আগেদি গমন কৰিলে আৰু ঘোষণা কৰিলে, “যিহোৱা, যিহোৱা কৃপা আৰু দয়াৰে পৰিপূৰ্ণ ঈশ্বৰ, ক্ৰোধত ধীৰ, দয়া আৰু সত্যতাত মহান; ");
INSERT INTO asmfb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","হাজাৰ হাজাৰ পুৰুষলৈকে দয়া কৰোঁতা; অপৰাধ, আজ্ঞা লঙ্ঘন, আৰু পাপ ক্ষমা কৰোঁতা। তথাপি তেওঁ নিশ্চয়ে দোষীক নিৰ্দ্দোষী নকৰে। তৃতীয় চতুৰ্থ পুৰুষলৈকে তেওঁলোকৰ সন্তানক পিতৃৰ অপৰাধৰ প্ৰতিফল দিওঁতা।” ");
INSERT INTO asmfb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","তেতিয়া মোচিয়ে বেগাই মাটিলৈ মূৰ দোঁৱাই প্ৰণিপাত কৰিলে, ");
INSERT INTO asmfb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","তাৰ পাছত মোচিয়ে কলে, “হে প্ৰভু, মই যদি আপোনাৰ দৃষ্টিত অনুগ্ৰহ পাইছোঁ, তেনেহ’লে বিনয় কৰিছোঁ আমাৰ লগত যাওঁক। কিয়নো এইলোক ঠৰডিঙীয়া লোক; আৰু আমাৰ অপৰাধ আৰু পাপ ক্ষমা কৰি, আমাক নিজৰ অধিকাৰৰ অৰ্থে গ্ৰহণ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","যিহোৱাই কলে, “চোৱা, এই বিষয়ত মই এটি নিয়ম কৰিলোঁ। মই তোমাৰ লোকসকলৰ আগত এনে আচৰিত কৰ্ম কৰিম যে, ইয়াৰ পূৰ্বে গোটেই পৃথিৱীত আৰু কোনো জাতিতৰ মাজত এনে কৰ্ম হোৱা নাই। তুমি যি লোকসকলৰ মাজত আছা, তেওঁলোক সকলোৱে যিহোৱাৰ সেই কাৰ্য দেখিব, কাৰণ তোমাৰ আগত মই যি কৰিম, সেয়ে ভয়ঙ্কৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","মই তোমাক যি আজ্ঞা দিছোঁ আজি তাক পালন কৰা। মই ইমোৰীয়া, কনানীয়া, হিত্তীয়া, পৰিজ্জীয়া, হিব্বীয়া, আৰু যিবুচীয়া সকলক তোমাৰ আগৰ পৰা খেদি বাহিৰ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","সাৱধান, তোমালোক যি দেশলৈ গৈ আছা, সেই দেশত নিবাস কৰা লোকসকলৰ সৈতে কোনো নিয়ম স্থিৰ নকৰিবা। যদি কৰা, তেনেহ’লে সেয়ে তোমাৰ মাজত ফান্দস্বৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","তাৰ পৰিৱৰ্তে, তোমালোক তেওঁলোকৰ যজ্ঞবেদিবোৰ ভাঙিব লাগিব। তেওঁলোকৰ স্তম্ভবোৰ গুড়ি কৰিবা, আৰু তেওঁলোকৰ আচেৰা দেৱীৰ দণ্ডবোৰ কাটি পেলাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","তুমি অন্য কোনো দেৱতাৰ আৰাধনা নকৰিবা; কাৰণ, মই যিহোৱা, যাৰ নাম ঈৰ্ষাম্বিত; তেওঁ নিজ মৰ্য্যাদা ৰখাত ঈৰ্ষাম্বিত ঈশ্বৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","তুমি সেই দেশ নিবাসী সকলৰ সৈতে কোনো চুক্তি নকৰিবা; কাৰণ তেওঁলোকে ব্যভিচাৰ কৰে আৰু দেৱতাবোৰৰ আগত তেওঁলোকে বলিদান কৰে। তেওঁলোকে তেওঁলোকৰ নৈবেদ্য খাবলৈ তোমালোকক নিমন্ত্রণ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","সেয়ে তোমালোকে যদি তেওঁলোকৰ ছোৱালী নিজৰ পুত্ৰৰ বাবে বিয়া কৰি আনা, তেনেহ’লে সেই ছোৱালীয়ে তোমালোকৰ পুত্রক তেওঁলোকৰ দেৱতাৰ অনুগামী কৰাব; আৰু ব্যভিচাৰ কৰাব। তোমালোকৰ পুত্ৰসকলেও তেওঁলোকৰ দেৱতাৰ অনুগামী হৈ ব্যভিচাৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","তুমি নিজৰ বাবে কোনো দেৱমূৰ্তি নিৰ্মাণ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","তোমালোকে খমীৰ নিদিয়া পিঠাৰ পৰ্ব্ব পালন কৰিবা। মই তোমালোকক আজ্ঞা দিয়াৰ দৰে আবীব মাহৰ নিৰূপিত কালত সাত দিন ধৰি খমীৰ নিদিয়া পিঠা খাবা। কিয়নো সেই আবীব মাহতে তুমি মিচৰ দেশৰ পৰা ওলাই আহিলা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","প্রথমে জন্ম হোৱা সকলো মোৰ, এনেকি গৰু, মেৰ-ছাগ সকলো পশু জাকৰ মাজতো সকলো প্রথমে জগা মতা পশু মোৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","তোমালোকে প্রথমে জগা গাধ কিনিব খোজা যদি এটা মেৰ-ছাগ দিব লাগিব; কিন্তু যদি কিনি লব নোখোজা, তেনেহ’লে তোমালোকে গাধটোৰ ডিঙি নিশ্চয় ভাঙিব লাগিব। তোমালোকৰ প্ৰথমে জন্ম হোৱা পুত্ৰসকলক তোমালোক কিনি ল’ব লাগিব। কোনো এজনো শুদা হাতে মোৰ আগত উপস্থিত নহ’বা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","তোমালোকে ছয় দিন পৰিশ্ৰম কৰিবা, কিন্তু সপ্তম দিনা বিশ্ৰাম কৰিবা। শস্য ৰোৱা আৰু শস্য দোৱা সময়ত অৱশ্যে বিশ্ৰাম কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","তোমালোক সপ্তাহৰ পৰ্ব্ব পালন কৰিবা। ঘেঁহু কটাৰ প্ৰথম ফল এই পৰ্ব্বত ব্যৱহাৰ কৰিবা, আৰু বছৰৰ শেষত ফল চপোৱাৰ পৰ্ব্ব পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","বছৰত তিনিবাৰ তোমালোকৰ পুৰুষসকল ইস্ৰায়েলৰ ঈশ্বৰ যিহোৱাৰ আগত উপস্থিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","মই তোমালোকৰ পৰা পৰজাতিসকলক দূৰ কৰিম, আৰু তোমালোকৰ দেশৰ সীমা বিস্তাৰ কৰিম। তোমালোক অৱশ্যে বছৰত তিনিবাৰ নিজৰ ঈশ্বৰ যিহোৱাৰ আগত উপস্থিত হ’ব লাগিব, যাতে কোনেও তোমালোকৰ দেশ অধিকাৰ কৰাৰ চেষ্টা নকৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","তোমালোকে মোৰ নৈবেদ্য হিচাপে তেজ উৎসৰ্গ কৰোঁতে তাৰ লগত খমীৰ নিদিবা। নিস্তাৰ-পৰ্ব্বত উৎস্বৰ্গিত মাংস পাছদিনা ৰাতিপুৱালৈকে নাৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","তোমালোকে নিজৰ খেতিৰ প্ৰথম ফলৰ উত্তম ভাগ নিজৰ ঈশ্বৰ যিহোৱাৰ গৃহলৈ আনিবা। তোমালোকে ছাগলী পোৱালিক তাৰ মাকৰ গাখীৰ দি নিসিজাবা।” ");
INSERT INTO asmfb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","তাৰ পাছত যিহোৱাই মোচিক ক’লে, “তোমাক মই যি সকলো কথা কলোঁ, সেই সকলো লিখি ৰাখা। ইয়াৰ দ্বাৰাই তোমাৰ আৰু ইস্ৰায়েলৰ লগত মই এটি নিয়ম স্থিৰ কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","মোচি সেই ঠাইত যিহোৱাৰ সৈতে চল্লিশ দিন চল্লিশ ৰাতি বাস কৰিছিল। মোচিয়ে চল্লিশ দিন একো ভোজন পান কৰা নাছিল; আৰু তেওঁ সেই দুখন ফলিত নিয়মৰ বাক্য, দহ আজ্ঞা লিখিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","মোচি যেতিয়া সেই দুখন ফলি লৈ চীনয় পৰ্ব্বতৰ পৰা নামি আহিল, তেতিয়া যিহোৱাৰ লগত কথা পতাৰ পাছত তেওঁৰ চেহেৰা যে উজ্জ্বল হৈ আছিল, সেই কথা মোচিয়ে নিজে জনা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","হাৰোণ আৰু ইস্ৰায়েলৰ সকলো লোকে মোচিৰ চেহেৰা উজ্জ্বল দেখি, তেওঁলোকে তেওঁৰ ওচৰলৈ যাবলৈ ভয় কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","কিন্তু মোচিয়ে তেওঁলোকক মাতিলে, তেতিয়া হাৰোণ আৰু সমাজৰ মূখ্যলোক সকল তেওঁৰ ওচৰলৈ ওভটি আহিল। তেতিয়া মোচিয়ে তেওঁলোকৰ লগত কথা পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","তাৰ পাছত, ইস্ৰায়েলৰ লোকসকল মোচিৰ ওচৰ চাপিলে। তেওঁ চীনয় পৰ্ব্বতত যিহোৱাই যিবোৰ আজ্ঞা দিছে সেই সকলো তেওঁলোকক ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","মোচিয়ে যেতিয়া তেওঁলোকৰ লগত কথা পাতি শেষ কৰিলে, তেতিয়া মোচিয়ে নিজৰ চেহেৰা ওৰণি লৈ ঢাকি ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","মোচিয়ে যেতিয়াই যিহোৱাৰ লগত কথা পাতিবলৈ তেওঁৰ সন্মুখলৈ গৈছিল, তেতিয়া সেই ওৰণি গুচাইছিল। কিন্তু ঘূৰি অহাৰ লগে লগে তেওঁ পুনৰ ওৰণি লৈছিল। তেওঁ যি সকলো নিৰ্দেশ পাইছিল, সেই সকলো তম্বুৰ বাহিৰলৈ আহি ইস্ৰায়েলৰ লোকসকলক কৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","তেতিয়া ইস্ৰায়েলী লোকসকলে তেওঁৰ চেহেৰাত এটা উজ্জ্বলতা দেখা পাইছিল। কিন্তু মোচিয়ে যিহোৱাৰ লগত কথা পাতিবলৈ পুনৰ ভিতৰলৈ নোযোৱালৈকে, নিজৰ চেহেৰা ওৰণিৰে ঢাকি লৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","মোচিয়ে ইস্ৰায়েলৰ লোকসকলক গোট খুৱালে, আৰু তেওঁলোকক ক’লে, “আপোনালোকে পালন কৰিবলৈ যিহোৱাই দিয়া আজ্ঞা এইবোৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ছয়দিন কাম কৰিব, কিন্তু সপ্তম দিনা আপোনালোকলৈ পবিত্ৰ দিন হ’ব। সেয়ে যিহোৱাৰ উদ্দেশ্যে সম্পূৰ্ণ বিশ্ৰামৰ বাবে বিশ্ৰাম-দিন হ’ব; যি কোনোৱে সেই দিনা কাম কৰিব, তাৰ নিশ্চয় প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","বিশ্ৰাম দিনত আপোনালোকৰ কাৰো ঘৰত জুই নজ্বলাব।” ");
INSERT INTO asmfb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","মোচিয়ে ইস্ৰায়েলৰ সকলো সমাজক কলে, “যিহোৱাই দিয়া আজ্ঞা এইবোৰ; ");
INSERT INTO asmfb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","যিহোৱাৰ বাবে আপোনালোকে উপহাৰ আনক। ইচ্ছাকৃত মনেৰে আনিব বিচাৰা উপহাৰসমূহ এইবোৰ; সোণ, ৰূপ আৰু পিতল; ");
INSERT INTO asmfb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা, মিহি শণ সূতা, আৰু ছাগলীৰ নোম। ");
INSERT INTO asmfb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ৰঙা ৰং কৰা মেৰ-ছাগৰ ছাল, তহচ জন্তুৰ ছাল, আৰু চিটীম কাঠ। ");
INSERT INTO asmfb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","প্ৰদীপৰ বাবে তেল, আৰু অভিষেক তেল আৰু সুগন্ধি ধূপৰ বাবে গন্ধদ্ৰব্য। ");
INSERT INTO asmfb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","এফোদ আৰু বুকুপতাৰ বাবে গোমেদক আৰু আন বহুমূলীয়া পাথৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","আপোনালোকৰ মাজৰ প্ৰত্যেক দক্ষতাসম্পন্ন লোক আহক, আৰু যিহোৱাই আজ্ঞা কৰা সকলোকে তৈয়াৰ কৰক। ");
INSERT INTO asmfb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","আবাসৰ তম্বু, আবৰণ, হাঁকোটা, তক্তা, ডাং, খুঁটা, আৰু চুঙী। ");
INSERT INTO asmfb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","চন্দুক আৰু তাৰ কানমাৰি, পাপাবৰণ আৰু আঁৰ কৰি ৰখা পৰ্দা। ");
INSERT INTO asmfb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","তেওঁলোকে মেজৰ সৈতে তাৰ খুটাবোৰ, আৰু তাৰ সকলো সঁজুলি, দৰ্শন-পিঠা; ");
INSERT INTO asmfb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","দীপ্তিৰ বাবে দীপাধাৰ আৰু তাৰ প্রয়োজনীয় সামগ্রী, প্ৰদীপবোৰ, আৰু প্ৰদীপৰ বাবে তেল; ");
INSERT INTO asmfb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ধূপ-বেদি আৰু তাৰ খুটাবোৰ, অভিষেকৰ তেল আৰু সুগন্ধি ধূপ, আবাসৰ প্রবেশ দুৱাৰত ওলমাবলৈ পৰ্দা। ");
INSERT INTO asmfb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","হোমবলিৰ বাবে বেদি আৰু তাৰ পিতলৰ জালি, খুটাবোৰ আৰু তাৰ সামগ্রী, ডাঙৰ পাত্র আৰু তাৰ ভিত্তি আনিব। ");
INSERT INTO asmfb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","তেওঁলোকে চোতালত ওলমাবলৈ তাৰ খুঁটা, চুঙী, আৰু চোতালৰ দুৱাৰৰ পৰ্দাবোৰ, ");
INSERT INTO asmfb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","আবাসৰ খুঁটা, চোতালৰ খুটাৰ সৈতে সেইবোৰৰ ৰচি। ");
INSERT INTO asmfb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","তেওঁলোকে পবিত্ৰ-স্থানত পৰিচৰ্যা কৰিবৰ বাবে বোৱা মিহি বস্ত্ৰ, পুৰোহিতৰ কৰ্ম কৰিবলৈ হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ বস্ত্ৰ আনিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","তাৰ পাছত ইস্ৰায়েলৰ জাতিৰ সকলো লোক মোচিৰ আগৰ পৰা আঁতৰি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","যিসকলৰ হৃদয়ত প্রবৃত্তি আৰু মনত ইচ্ছা জন্মিল তেওঁলোকে যিহোৱাৰ বাবে উপহাৰ আনিলে। তেওঁলোকে সাক্ষাৎ কৰা তম্বুৰ, তম্বুৰ সম্পৰ্কীয় সকলো সামগ্রীৰ, আৰু পবিত্ৰ বস্ত্ৰৰ বাবে যিহোৱাৰ উদ্দেশ্যে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","পুৰুষ আৰু স্ত্ৰী যিসকল লোকৰ ইচ্ছা জন্মিল, তেওঁলোক সকলোৱে ব্রোচ, কাণফুলি, আঙঠি, আৰু অলঙ্কাৰ, সকলো ধৰণৰ সোণৰ অলঙ্কাৰ আনিলে। তেওঁলোকে যিহোৱাৰ উদ্দেশ্যে সোণৰ উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","যিসকল লোকৰ নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতা আৰু মিহি শণ সূতা, ছাগলীৰ নোম, ৰঙা ৰং কৰা মেৰ-ছাগৰ ছাল, আৰু তহচ জন্তুৰ ছাল আছিল, তেওঁলোকে প্ৰতিজনে সেইবোৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","প্রতিজনে যিহোৱাৰ উদ্দেশ্যে ৰূপ বা পিতল উপহাৰস্বৰূপে আনিলে; আৰু যিসকলৰ চিটীম কাঠ আছিল, তেওঁলোক যিকোনো কাৰ্যত ব্যৱহাৰ কৰিবলৈ সেইবোৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","প্রত্যেক দক্ষতাসম্পন্ন মহিলা নিজৰ হাতেৰে সূতা কাটি নীলা, বেঙুনীয়া, ৰঙা বৰণীয়া আৰু মিহি শণ সূতা আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","সকলো মহিলাৰ যিসকলৰ হৃদয়ত উৎসাহ জন্মিছিল তেওঁলোকে ছাগলীৰ নোমৰ সূতা কাটিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","মূখ্যলোক সকলে এফোদ আৰু বুকুপটাত লগাবলৈ গোমেদ আৰু আন পাথৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","তেওঁলোকে মছলা আৰু প্ৰদীপৰ বাবে তেল, অভিষেকৰ তেল, আৰু সুগন্ধি ধূপৰ বাবে সুগন্ধি দ্ৰব্য আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ইস্ৰায়েলৰ সকলোলোকে ইচ্ছাকৃত ভাৱে যিহোৱাৰ উদ্দেশ্যে উপহাৰ আনিলে। প্রত্যেক পুৰুষ আৰু মহিলাই ইচ্ছাকৃতভাৱে উপহাৰ প্রদান কৰিলে। যিহোৱাই মোচিক যিসকলো কৰিবলৈ আজ্ঞা কৰিছিল, সেই সকলো উপহাৰ সামগ্রীৰ সহায়ত মোচিয়ে তৈয়াৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","তাৰ পাছত মোচিয়ে ইস্ৰায়েলৰ লোকসকলক ক’লে, “চোৱা, যিহোৱাই যিহূদা ফৈদৰ হূৰৰ পুত্র ঊৰী, ঊৰীৰ পুত্ৰ বচলেলৰ নাম কাঢ়ি মাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","যিহোৱাই বচলেলক তেওঁৰ আত্মাৰে পৰিপূৰ্ণ কৰিলে, তেওঁক জ্ঞান, বুদ্ধি, বিদ্যা, আৰু সকলো প্ৰকাৰ শিল্প কৌশল দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","তেওঁ সোণ, ৰূপ, আৰু পিতলৰ সামগ্রী তৈয়াৰ কৰি তাৰ ওপৰত কাৰুকাৰ্য কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","পাথৰ কাটি খটাব পাৰে, আৰু কাঠেৰেও সকলো প্ৰকাৰ শিল্প কৰ্ম কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","যিহোৱাই বচলেল আৰু অহলীয়াবক শিক্ষা দান কৰিবলৈ বিশেষ ক্ষমতা দিলে, অহলীয়াব হ’ল দান বংশৰ অহীচামকৰ পুত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","যিহোৱাই এই দুয়োজনক সকলো প্রকাৰ কাৰ্য কৰিবলৈ বিশেষ দক্ষতা দিলে। তেওঁলোক সূতাৰ আৰু ধাতুৰ কাৰ্য কৰাত দক্ষতাসম্পন্ন। নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া মিহি শণ সূতাৰে ফুল বছা কৰ্ম, আৰু কাপোৰ বোৱা কাৰ্য কৰে। তেওঁলোকে সকলো প্রকাৰৰ শিল্পকাৰ্য কৰে, আৰু তেওঁলোক শিল্পিসুলভ নক্সাকাৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","সেয়ে পবিত্ৰ-স্থানৰ সকলো কাৰ্য ভালদৰে কৰিবলৈ, যিহোৱাই বচলেল আৰু অহলীয়াৰ সৈতে আন যি সকলো লোকক দক্ষতা আৰু বুজিব পৰা শক্তি দিলে, সেই সকলো জ্ঞানী লোকে যিহোৱাৰ আজ্ঞা অনুসাৰে কাৰ্য কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","তাৰ পাছত মোচিয়ে বচলেল আৰু অহলীয়াবৰ সৈতে যিহোৱাই যিসকল লোকক দক্ষতা দিছিল, আৰু ইচ্ছাকৃত ভাৱে তেওঁলোকৰ লগত কাম কৰিবলৈ আহিছিল, তেওঁলোকক মাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","তেওঁলোকে, পবিত্ৰ-স্থানৰ নিৰ্মাণ কাৰ্যৰ বাবে ইস্ৰায়েলী লোকসকলে আনি দিয়া সকলো উপহাৰ মোচিৰ পৰা গ্রহণ কৰিলে। লোকসকলে প্ৰতি ৰাতিপুৱা মোচিৰ আগত ইচ্ছাকৃত ভাৱে দান আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","সেয়ে পবিত্ৰ স্থানত কাম কৰি থকা সকলো দক্ষতাসম্পন্ন লোকসকল কামৰ পৰা আহিল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","তেওঁলোকে মোচিক ক’লে, “যিহোৱাই যিবোৰ কাম কৰিবলৈ আজ্ঞা দিছিল, সেই কাৰ্যৰ বাবে প্রয়োজনীয় বস্তুতকৈ লোকসকলে অধিক বস্তু আনি আছে।” ");
INSERT INTO asmfb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","সেয়ে মোচিয়ে নিৰ্দেশ দিলে যে, তম্বুত থকা লোকসকলে পবিত্ৰ-স্থানৰ কাৰ্যৰ বাবে আৰু উপহাৰ আনিব নালাগে। তেতিয়া লোকসকলে উপহাৰ অনা বন্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","কিয়নো সকলো কাৰ্য কৰিবৰ অর্থে তেওঁলোকৰ যথেষ্ট বস্তু আছিল, এনেকি প্রয়োজনতকৈ অধিক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","সেয়ে তেওঁলোকৰ মাজত শিল্পকাৰ্য কৰা লোকসকলে আবাসৰ কাৰ্য আৰম্ভ কৰিলে। তেওঁলোকে পকোৱা মিহি শণ সূতা, আৰু নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া সূতাৰে দহখন পৰ্দা তৈয়াৰ কৰিলে। তেওঁলোকে পৰ্দাৰ ওপৰত কৰূবৰ ছবি আঁকিলে। এই কাৰ্য অতি নিপূণ শিল্পকাৰ বচলেলৰ কাম আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","প্ৰত্যেকখন পৰ্দাই সমান জোখৰ আছিল, আঠাইশ হাত দীঘল, আৰু চাৰি হাত বহল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","তাৰ পাছত বচলেলে পাঁচখন পৰ্দা ইখনক সিখনৰ লগত জোৰা দিলে, আৰু আন পাঁচখনো ইখনক সিখনৰ লগত জোৰা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","তেওঁ নীলা জৰীৰ পাক প্ৰথমে জোৰা দিয়া পাঁচখন পৰ্দাৰ শেষৰ খনৰ আউঠিত লগালে, আৰু দ্বিতীয়তে জোৰা দিয়া পাঁচখন পৰ্দাৰ শেষৰ খনৰ আউঠিতো নীলা জৰীৰ পাক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","সেই প্ৰথমখন পৰ্দাৰ পঞ্চাশটা আউঠিত পঞ্চাশটা জৰীৰ পাক, আৰু দ্বিতীয়তে জোৰা দিয়া পৰ্দাৰ শেষৰ আউঠিত পঞ্চাশটা জৰীৰ পাক দিলে। সেই জৰীৰ পাক দুশাৰী মুখামুখকৈ লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","তেওঁ সোণৰ পঞ্চাশটা হাঁকোটা গঢ়াই, সেই হাঁকোটাৰে পৰ্দা দুখন ইখনক সিখনৰ লগত বান্ধিলে; আৰু এইদৰে সেই আবাস একলগ কৰি এটা কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","সেই আবাসৰ ওপৰৰ তম্বুৰ বাবে ছাগলীৰ নোমেৰে কাপোৰ যুগুত কৰিলে। তেওঁ এঘাৰখন পৰ্দা যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","প্ৰতিখন পৰ্দা সমান জোখৰ আছিল, দীঘলে ত্ৰিশ হাত, আৰু বহলে চাৰি হাত। ");
INSERT INTO asmfb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","তেওঁ পাঁচখন পৰ্দা ইখনক সিখনৰ লগত জোৰা দিলে, আৰু আন ছয়খন পৰ্দা ইখনক সিখনৰ লগত জোৰা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","প্ৰথমে জোৰা দিয়া পাঁচখন পৰ্দাৰ শেষৰ খনৰ আউঠিত পঞ্চাশটা জৰীৰ পাক, আৰু তেনেকুৱাই জোৰা দিয়া দ্বিতীয়খন পৰ্দাৰ শেষৰ আউঠিত পঞ্চাশটা জৰীৰ পাক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","বচলেলে প্রথম আৰু দ্বিতীয়তে জোৰা দিয়া পৰ্দাবোৰ লগলগাই তম্বু একে লগ কৰিবৰ অৰ্থে পিতলৰ পঞ্চাশটা হাঁকোটা গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ৰঙা ৰং কৰা মেৰ-ছাগৰ ছালেৰে তম্বুৰ বাবে এটা আবৰণ আৰু তাৰ ওপৰতো তহচ জন্তুৰ ছালেৰে আৰু এটা আবৰণ যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","বচলেলে আবাসৰ বাবে চিটীম কাঠেৰে থিয়কৈ দিয়া তক্তা যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","তাৰ এখন তক্তা দহ হাত দীঘল, আৰু ডেৰ হাত বহল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","প্ৰতিখন তক্তাত তেওঁ একে জোখৰ দুটাকৈ ওলোৱা অংশ কৰিলে; এইদৰে তাৰ আবাসৰ সকলো তক্তা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","এইদৰে আবাসৰ বাবে যি তক্তা প্রস্তুত কৰিলে তাৰে বিশখন তক্তা দক্ষিণ ফালৰ বাবে যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","বচলেলে সেই বিশখন তক্তাৰ তলত ৰূপৰ চল্লিশটা চুঙী গঢ়ালে; এখন তক্তাৰ তলত তাৰ দুটা খুটাৰ বাবে দুটা চুঙী, আৰু আন আন তক্তাৰ তলতো দুটাকৈ চুঙী গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","আবাসৰ দ্বিতীয় ফালৰ উত্তৰ দিশে বিশখন তক্তা যুগুত কৰিলে, ");
INSERT INTO asmfb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","আৰু সেইবোৰৰ বাবে ৰূপৰ চল্লিশটা চুঙী গঢ়ালে। এখন তক্তাৰ তলত দুটা চুঙী, আৰু আনবোৰ তক্তাৰ তলতো দুটাকৈ চুঙী লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","আবাসৰ পিছফালৰ পশ্চিম দিশৰ বাবে ছয় খন তক্তা যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","আবাসৰ পিছফালৰ চুক দুটাৰ বাবে দুখন তক্তা যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","প্ৰত্যেক তক্তাৰ তলৰফাল খোলা ৰাখিলে, কিন্তু ওপৰফালে আঙঠিৰে একলগ কৰা হ’ল। দুয়োটা চুকৰ বাবে দুয়োখন তক্তা এইদৰে কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ৰূপৰ চুঙীৰে সৈতে আঠখন তক্তা আছিল। সেইবোৰৰ বাবে ৰূপৰ চুঙী সৰ্বমুঠ ষোল্লটা, প্ৰত্যেক তক্তাৰ তলত দুটাকৈ চুঙী লগোৱা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","বচলেলে আবাসৰ এফালৰ তক্তাৰ বাবে পাঁচডাল, ");
INSERT INTO asmfb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","আৰু আবাসৰ আন ফালৰ তক্তাৰ বাবে পাঁচডাল, আৰু আবাসৰ পশ্চিম দিশে থকা পাছফালৰ তক্তাৰ বাবেও পাঁচডাল চিটীম কাঠৰ পথালি ডাং যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","কিন্তু মাজৰ ডাং ডাল তক্তাবোৰৰ মাজেদি এমুৰৰ পৰা আন মুৰলৈকে যোৱাকৈ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","সেই তক্তাবোৰত সোণৰ পতা মাৰিলে, আৰু ডাংবোৰ সুমুৱাবলৈ, সেইবোৰত সোণৰ আঙঠি গঢ়ালে; আৰু ডাং বোৰতো সোণৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","বচলেলে নীলা, বেঙেনা, আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে এখন পৰ্দা তৈয়াৰ কৰিলে। সেই পৰ্দাত নিপুণ শিল্পকাৰৰ দ্বাৰাই কৰূবৰ নক্সা তৈয়াৰ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","পৰ্দাৰ বাবে চিটীম কাঠৰ চাৰিটা খুঁটা বনাই, সেইবোৰত সোণৰ পতা মাৰিলে। খুটাৰ বাবে সোণৰ হাঁকোটা গঢ়ালে, আৰু ৰূপৰ চাৰিটা চুঙী সাঁচত ঢালিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","তেওঁ তম্বুৰ দুৱাৰৰ বাবে নীলা, বেঙেনা আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে বোৱা, শিল্পকাৰে ফুল বছা এখন পৰ্দা যুগত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","পৰ্দাৰ বাবে পাঁচোটা খুঁটা আৰু সেইবোৰৰ হাঁকোটা বনালে। খুটাবোৰৰ ওপৰভাগত আৰু মাৰিবোৰত সোণৰ পতা মাৰিলে। সেইবোৰৰ বাবে পাঁচটা পিতলৰ চুঙী তৈয়াৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","তাৰ পাছত বচলেলে চিটীম কাঠৰ আঢ়ৈ হাত দীঘল, ডেৰ হাত বহল, আৰু ডেৰ হাত ওখকৈ নিয়ম চন্দুক নিৰ্মাণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","তেওঁ নিয়ম চন্দুকৰ বাহিৰে ভিতৰে শুদ্ধ সোণৰ পতা মাৰিলে, আৰু তাৰ চাৰিওফালৰ কিনাৰ বোৰত সোণ লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","তেওঁ তাৰ খুটাৰ বাবে সোণৰ চাৰিটা চক্র গঢ়ালে। তাৰ এফালে দুটা আন ফালে দুটা এই দৰে তাৰ চাৰিটা খুৰাত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","আৰু তেওঁ চিটীম কাঠৰ দুডাল কানমাৰি সাজি, তাত সোণৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","তেওঁ চন্দুক বৈ নিবলৈ, সেই কানমাৰি চন্দুকৰ দুই কাষে থকা আঙঠি সুমুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","তেওঁ শুদ্ধ সোণৰ আঢ়ৈ হাত দীঘল আৰু ডেৰ হাত বহলকৈ এখন পাপাবৰণ সাজিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","বচলেলে সোণ পিটাই দুটা সোণৰ কৰূব সাজিলে, আৰু পাপাবৰণৰ দুই মুৰত ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","এটা মুৰত এটা কৰূব আৰু আনটো মুৰত আন এটা কৰূব হ’ল। পাপাবৰণৰ দুই মুৰত একে ডোখৰ সোণতে সেই দুটা কৰূব সাজিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","কৰূবে ওপৰলৈ ডেউকা মেলি নিজৰ ডেউকাৰে পাপাবৰণক ঢাকি ধৰিলে; আৰু কৰূব দুটা মুখামুখি হৈ থাকিল; আৰু কৰূবৰ দৃষ্টি পাপাবৰণৰ মাজভাগত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","তেওঁ দুহাত দীঘল, এহাত বহল, আৰু ডেৰ হাত ওখকৈ চিটীম কাঠৰ মেজ সাজি, তাত শুদ্ধ সোণৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","মেজখনত তেওঁ সোণৰ পতা মাৰিলে, আৰু তাৰ ওপৰৰ চাৰিওফালৰ দাঁতিত সোণ লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","তাৰ চাৰিওফালে চাৰি আঙুলি জোখৰ এটা কাঠৰ ফ্রেম যুগুত কৰিলে, আৰু ফ্রেমৰ চাৰিওকাষৰ দাঁতি সোণৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","তেওঁ তাৰ বাবে সোণৰ চাৰিটা আঙঠি সাঁচত ঢালিলে। সেই আঙঠি চাৰিটা খুঁটা থকা ঠাইৰ চাৰি চুকত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","মেজ বৈ নিবলৈ, আৰু কানমাৰি সুমুৱাবলৈ সেই আঙঠি ফ্রেমৰ কাষত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","তেওঁ মেজ বৈ নিবৰ কাৰণে চিটীম কাঠৰ দুডাল কানমাৰি সাজি, তাতো সোণৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","মেজৰ ওপৰত থকা পাত্ৰবোৰ, অৰ্থাৎ তাৰ কাঁহি, চামুচ, বাটি, আৰু দ্ৰাক্ষাৰস ঢালিবলৈ জাৰ প্রস্তুত কৰিলে। সেই সকলো শুদ্ধ সোণেৰে গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","তেওঁ শুদ্ধ সোণ হাতুৰিৰে পিটি এটা দীপাধাৰ সাজিলে; তাৰ খুৰা, গা ভাগ, তাত কটা বাটি, কলি, আৰু ফুল একে ডোখৰ সোণেৰে গঢ়িলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","তাৰ এফালৰ পৰা তিনটা শাখা, আৰু আনফালৰ পৰা তিনটা শাখা, এই দৰে সেই দীপাধাৰৰ দুই ফালৰ পৰা ছটা শাখা ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","তাৰ প্রথম শাখাত বাদাম ফুলৰ আকৃতিৰে তিনটা বাটি, এটা কলি, আৰু এটা ফুল, আৰু আনটো শাখাত বাদাম ফুলৰ আকৃতিৰে তিনটা বাটি, এটা কলি, আৰু এটা ফুল কৰিলে। দীপাধাৰৰ পৰা ওলোৱা ছয়োটা শাখাত একে দৰেই কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","সেই দীপাধাৰৰ মাজভাগতো বাদামফুলৰ আকৃতিৰে চাৰিটা বাটি, তাৰ কলি আৰু ফুল কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","সেই দীপাধাৰৰ প্রথম জোৰা শাখাৰ তলত একে ডোখৰ সোণতে এটা কলি আৰু আনটো শাখাৰ তলতো একে ডোখৰ সোণতে এটা কলি আছিল। এইদৰে তৃতীয় শাখাতো একে ডোখৰ সোণতে এটা কলি আছিল। এইদৰেই দ্বীপাধাৰৰ পৰা বহিৰ ওলোৱা ছয়োটা শাখাতে একেদৰে কৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","সেইবোৰৰ কলি আৰু সেইবোৰৰ ডাল একে ডোখৰ সোণতেই আছিল। সেই সকলোৱেই শুদ্ধ সোণ হাতুৰিৰে পিটি গঢ়োৱা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","বচলেলে দীপাধাৰৰ সাতোটা প্ৰদীপ, চেপেনা আৰু তাৰ ট্রে শুদ্ধ সোণেৰে গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","সেই দীপাধাৰ আৰু তাৰ সকলো বস্তু এক কিক্কৰ শুদ্ধ সোণেৰে নিৰ্মান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","বচলেলে চিটীম কাঠেৰে ধূপ-বেদি নিৰ্মান কৰিলে। সেই বেদি এহাত দীঘল, আৰু এহাত বহল; তাৰ চাৰিওফালৰ চাৰিওটা চুক সমান; তাৰ ওখই দুহাত; আৰু তাৰ শিং একে ডোখৰ কাঠেৰেই তৈয়াৰ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","তেওঁ ধূপ বেদিত, ইয়াৰ ওপৰত, কাষত, আৰু শিংবোৰত শুদ্ধ সোণেৰে পতা মাৰিলে। তেওঁ চাৰিওফালৰ দাঁতিও সোণেৰে তৈয়াৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ধূপ বেদি বৈ নিবৰ বাবে কানমাৰি সুমুউৱাবলৈ, তেওঁ সোণৰ দুটা খাৰুৱা গঢ়ালে, আৰু দাঁতিৰ তলত দুয়ো ফালে লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","তেওঁ চিটীম কাঠেৰে কানমাৰি সাজি, তাত সোণৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","সুগন্ধিদ্ৰব্য তৈয়াৰ কৰা লোক সকলৰ দৰে, তেওঁ অভিষেকৰ পবিত্ৰ তেল, আৰু শুদ্ধ সুগন্ধি ধূপ যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","বচলেলে চিটীম কাঠেৰে পাঁচ হাত দীঘল,পাঁচ হাত বহল, আৰু তিনি হাত ওখকৈ চাৰিওদিশ আৰু চাৰিওটা চুক সমানকৈ হোমবলিৰ অৰ্থে বেদি সাজিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","তেওঁ তাৰ চাৰিওটা চুক ষাঁড় গৰুৰ শিঙৰ আকৃতিত সাজিলে। সেই শিংবোৰ বেদিৰ সৈতে একে ডোখৰ কাঠেৰেই সাজিলে; আৰু তাত পিতলৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","তেওঁ বেদিৰ সকলো সামগ্রী যেনে, ছাঁই পেলোৱা পাত্ৰ, ছাঁই উলিওৱা হেঁতা, চৰিয়া, মাংস খোঁচ যাঠি, আৰু জুই ধৰা পাত্ৰ, এই সকলো সামগ্রী পিতলেৰে গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","তেওঁ বেদিৰ বাবে পিতলৰ জালি গঢ়ালে, আৰু বেদিৰ তলৰ পৰা ওপৰলৈকে আধা অংশত সেই জাল লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","কানমাৰি সুমুৱাবলৈ, চাৰিটা আঙঠি সাঁচত ঢালিলে, আৰু পিতলৰ সেই জালিৰ চাৰি চুকত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","বচলেলে চিটীম কাঠেৰে মাৰি সাজিলে, আৰু তাত পিতলৰ পতা মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","বেদি বৈ নিবৰ বাবে, তেওঁ তাৰ কাষত থকা আঙঠিত কানমাৰি সুমুৱালে; তেওঁ সেই বেদি তক্তাৰে ফোঁপোলাকৈ নিৰ্মান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","যি মহিলাসকলে সাক্ষাৎ কৰা তম্বুৰ প্রবেশ দুৱাৰত সেৱা কৰিছিল, সেই মহিলাসকলৰ পিতলৰ দৰ্পণেৰে বচলেলে ডাঙৰ প্ৰক্ষালন পাত্ৰ আৰু তাৰ খুঁটা গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","তেওঁ চোতালখনো যুগুত কৰিলে। চোতালৰ দক্ষিণ দিশে পকোৱা মিহি শণ সূতাৰে এশ হাত দীঘল পৰ্দা যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","বিশটা খুটাৰ পৰা পৰ্দাবোৰ ওলমোৱা হৈছিল, আৰু খুটাবোৰৰ বিশটা চুঙী পিতলৰ আছিল। খুটাবোৰৰ হাঁকোটা আৰু শলি ৰূপৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","একেদৰেই উত্তৰদিশৰ বাবেও পৰ্দা যুগুত কৰিলে। সেইবোৰো এশ হাত দীঘল আছিল। সেইবোৰৰ খুঁটা বিশটা; আৰু খুটাবোৰৰ বিশটা চুঙী পিতলৰ আছিল, আৰু সেই খুটাবোৰৰ হাঁকোটা আৰু মাৰি ৰূপৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","আৰু পশ্চিম দিশৰ পৰ্দা পঞ্চাশ হাত দীঘল আছিল। সেইবোৰৰ খুঁটা দহটা, আৰু খুটাবোৰৰ চুঙী দহটা আছিল; আৰু খুটাবোৰৰ হাঁকোটা আৰু মাৰি ৰূপৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","চোতালখনৰ পূৱদিশও পঞ্চাশ হাত দীঘল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","প্রবেশ দুৱাৰৰ এটা কাষৰ পৰ্দা পোন্ধৰ হাত দীঘল আছিল; আৰু সেইবোৰৰ খুঁটা তিনিটা আৰু খুটাবোৰৰ চুঙী তিনিটা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","চোতালৰ প্রবেশ দুৱাৰৰ আন কাষতো একেদৰে পোন্ধৰ হাত দীঘল পৰ্দা আছিল। সেইবোৰৰ খুঁটা তিনিটা আৰু খুটাবোৰৰ চুঙী তিনিটা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","চোতালৰ চাৰিওদিশৰ পৰ্দাবোৰ পকোৱা মিহি শণ সূতাৰে তৈয়াৰী আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","খুটাবোৰৰ চুঙীবোৰ পিতলেৰে তৈয়াৰ কৰিছিল। খুটাবোৰৰ বাবে হাঁকোটা আৰু মাৰিবোৰ ৰূপেৰে তৈয়াৰ কৰিছিল। খুটাবোৰৰ মুৰ ৰূপেৰে তৈয়াৰ কৰা হৈছিল; আৰু চোতালৰ আটাইবোৰ খুটাতে ৰূপৰ মাৰি লগোৱা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","চোতালৰ দুৱাৰৰ পৰ্দাবোৰ নীলা, বেঙুনীয়া, আৰু ৰঙা বৰণীয়া মিহি শণ সূতাৰে বোৱা, আৰু শিল্পকাৰে ফুল বাছি তৈয়াৰ কৰিছিল। পৰ্দাখন আছিল দীঘলে বিশ হাত, আৰু ওখই পাঁচ হাত, চোতালৰ বাকী পৰ্দাবোৰৰ জোখৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","পৰ্দাৰ বাবে চাৰিটা খুঁটা; আৰু চাৰিটা পিতলৰ চুঙী; আৰু সেইবোৰৰ হাঁকোটা ৰূপৰ আছিল। খুটাৰ ওপৰভাগ আৰু মাৰী বোৰ ৰূপেৰে তৈয়াৰী। ");
INSERT INTO asmfb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","আবাসৰ আৰু চোতালৰ চাৰিওফালৰ খুটাবোৰ পিতলৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","মোচিৰ নিৰ্দেশ অনুসাৰে, সাক্ষ্য ফলি থকা আবাসৰ সকলো বস্তুৰ সংখ্যাৰ বৃত্তান্ত লিখিবলৈ পুৰোহিত হাৰোণৰ পুত্ৰ ঈথামৰে লেবীয়া সকলক আদেশ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","যিহূদা ফৈদৰ হূৰৰ পুত্র ঊৰী, ঊৰীৰ পুত্ৰ বচলেলে, যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰে সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","দান ফৈদৰ অহীচামকৰ পুত্ৰ অহলীয়াব তেওঁৰ সহায়কাৰী আছিল, তেওঁ এজন দক্ষতাসম্পন্ন লোক আৰু নিপুণ শিল্পকাৰ আছিল। তেওঁ নীলা, বেঙুনীয়া আৰু ৰঙা বৰণীয়া মিহি শণ সূতাৰে ফুল বাছিব জনা লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","পবিত্র স্থানৰ প্রকল্পৰ বাবে ব্যৱহাৰ হোৱা সকলো উপহাৰৰ সোণ পবিত্ৰ স্থানৰ চেকলৰ জোখৰ অনুপাতে ঊনত্ৰিশ কিক্কৰ আৰু সাত শ ত্ৰিশ চেকল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","সমাজৰ দ্বাৰাই দিয়া ৰূপৰ ওজন পবিত্ৰ স্থানৰ চেকলৰ জোখৰ অনুপাতে এশ কিক্কৰ আৰু এক হাজাৰ সাত শ পঁয়সত্তৰ চেকল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","বা বিশ বছৰ আৰু তাতকৈ অধিক বয়সৰ লোকপিয়ল অনুসাৰে ছয় লাখ তিনি হাজাৰ পাঁচশ পঞ্চাশ জন লোকৰ প্ৰতিজনে এক এক বেকা, অৰ্থাৎ পবিত্ৰ স্থানৰ চেকল অনুসাৰে আধা চেকলকৈ ৰূপ দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","এশ কিক্কৰ ৰূপ পবিত্ৰ স্থান আৰু পৰ্দাৰ চুঙীৰ বাবে খৰচ কৰা হ’ল। প্ৰত্যেক চুঙীত এক কিক্কৰকৈ এশ চুঙীৰ বাবে এশ কিক্কৰ ৰূপ খৰচ কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","এক হাজাৰ সাত শ পঁয়সত্তৰ চেকল ৰূপেৰে তেওঁ খুটাবোৰৰ হাঁকোটা তৈয়াৰ কৰিছিল। সেইবোৰৰ মুৰত, ৰূপৰ পতা মাৰিছিল, আৰু সেইবোৰৰ বাবে মাৰী তৈয়াৰ কৰা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","উপহাৰৰ পৰা পোৱা পিতলৰ ওজন সত্তৰ কিক্কৰ দুই হাজাৰ চাৰিশ চেকল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","এইবোৰেৰে তেওঁ সাক্ষাৎ কৰা তম্বুৰ প্রবেশ দুৱাৰৰ বাবে চুঙী, পিতলৰ বেদি, পিতলৰ জালিকটা, আৰু বেদিৰ সকলো সামগ্রী তৈয়াৰ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","চোতালৰ বাবে চুঙী, চোতালৰ প্রবেশ দুৱাৰৰ বাবে চুঙী, আবাসৰ বাবে সকলো খুঁটা, আৰু চোতালৰ বাবে সকলো খুঁটা গঢ়ালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","তেওঁলোকে, যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, নীল বৰণীয়া, বেঙেনা বৰণীয়া আৰু ৰঙা বৰণীয়া সূতাৰে, পবিত্ৰ স্থানত পৰিচৰ্যা কৰিবৰ বাবে নিপুণৰূপে বোৱা মিহি বস্ত্ৰ, আৰু হাৰোণৰ বাবে পবিত্ৰ বস্ত্ৰ যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","তেওঁ সোণ, আৰু নীল বৰণীয়া, বেঙেনা বৰণীয়া, আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে এফোদ বস্ত্ৰখন যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","তেওঁলোকে সোণ পিটি পতা কৰি, কাটি মিহি গুনা তৈয়াৰ কৰি নীল বৰণীয়া, বেঙেনা বৰণীয়া, আৰু ৰঙা বৰণীয়া মিহি শণ সূতাৰ কাপোৰত নিপুণ শিল্পকাৰ্য্যৰ দ্বাৰাই কাম কৰালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","তেওঁলোকে ওপৰৰ দুয়োফালে এফোদৰ কান্ধত লগাবলৈ স্কন্ধপটি যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","এফোদৰ কঁকালত বান্ধিবৰ বাবে তাৰ লগত নিপুণৰূপে বোৱা কাপোৰৰ সোণোৱালী, আৰু নীলা, বেঙেনা আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে টঙালি প্রস্তুত কৰিলে। যিহোৱাই মোচিক আজ্ঞা কৰাৰ দৰে তেওঁলোকে সেই সকলো কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","তেওঁলোকে মোহৰ কটাৰ দৰে কটা, ইস্ৰায়েলৰ বাৰজন পুত্ৰৰ নাম থকা, সোণত খটোৱাবলৈ গোমেদ পাথৰ যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","সেয়ে ইস্ৰায়েলৰ পুত্ৰসকলৰ সোঁৱৰণীয় পাথৰ স্বৰূপে তাক এফোদৰ স্কন্ধপটিৰ ওপৰত লগালে। যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰেই কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","এফোদ তৈয়াৰ কৰাৰ দৰে, তেওঁ সোণোৱালী, আৰু নীলা, বেঙেনা আৰু ৰঙা বৰণীয়া সূতা আৰু পকোৱা মিহি শণ সূতাৰে নিপুণ শিল্পকাৰ্যেৰে বুকুপটা যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","এই বুকুপটা চাৰিচুকীয়া আছিল। তেওঁলোকে বুকুপটাটো দুতৰপ কৰিলে; সেয়ে দীঘে এবেগেত, বহলে এবেগেত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","তেওঁলোকে তাত চাৰি শাৰী বহুমূলীয়া পাথৰ খুৱালে। প্ৰথম শাৰীত ৰুবী, পীতমণি, আৰু মৰকত; ");
INSERT INTO asmfb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","দ্বিতীয় শাৰীত পদ্মৰাগ, নীলকান্ত, আৰু হীৰা; ");
INSERT INTO asmfb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","তৃতীয় শাৰীত পেৰোজ, যিষ্ম, আৰু কটাহেলা; ");
INSERT INTO asmfb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","আৰু চতুৰ্থ শাৰীত বৈদূৰ্য্য, গোমেদক আৰু সূৰ্যকান্ত আছিল; এই সকলো পাথৰ সোণত খটোৱা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","এই পাথৰ ইস্ৰায়েলৰ বাৰজন পুত্রৰ নাম অনুসাৰে, একাদিক্রমে ডাঙৰৰ পৰা সৰুলৈকে লিখা হ’ল; মোহৰৎ খোদিত কৰা দৰে প্ৰত্যেক পাথৰত বাৰ ফৈদৰ বাবে এজন এজন পুত্ৰৰ নাম ক্ষুদিত কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","তেওঁলোকে ৰছীৰ দৰে পকোৱা মালাৰ নিচিনা দুডাল শুদ্ধ সোণৰ শিকলি তৈয়াৰ কৰি, বুকুপটাত লগাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","তেওঁলোকে সোণৰ দুটা আঙঠি তৈয়াৰ কৰি, বুকুপটাৰ দুই মূৰত সেই আঙঠি দুটা লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","মালাৰ দৰে গঁথা সোণৰ সেই শিকলি দুডাল বুকুপটাৰ দুই মুৰত থকা আঙঠি দুটাত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","মালাৰ দৰে গঁথা শিকলি দুডালৰ দুই মূৰ সোণৰ খাপ দুটাত লগালে, এফোদৰ আগফালে স্কন্ধপটি দুটাৰ ওপৰত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","সোণৰ দুটা আঙঠি গঢ়াই, বুকুপটাৰ দুই মূৰত এফোদৰ সন্মুখত থকা ভিতৰৰ দাঁতিত লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","তাৰ পাছত আৰু দুটা আঙঠি গঢ়াই, এফোদৰ স্কন্ধপটি দুটাৰ তল ভাগত তাৰ আগফালে, জোৰা দিয়া ঠাইৰ ওচৰত, এফোদৰ নিপুণৰূপে বোৱা টঙালিৰ ওপৰত তাক লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","বুকুপটা এফোদৰ নিপুণৰূপে বোৱা টঙালিৰ ওপৰত যেন থাকে, আৰু এফোদৰ পৰা যেন এৰাই নাযায়, সেই বাবে তেওঁলোকে নীলা ফিতাৰে বুকুপটাক তাৰ আঙঠিৰে সৈতে এফোদৰ আঙঠিত বান্ধিলে। যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰে তেওঁলোকে সকলো কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","বচলেলে এফোদৰ চোলা সিপিনীয়ে বোৱা, সম্পূৰ্ণ বেঙেনা বৰণীয়া কাপোৰেৰে তৈয়াৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","সেই চোলাত মুৰ সুমুৱাবলৈ সোঁ মাজত খোলা আছিল। সেয়ে নাফালিবৰ বাবে, ডিঙিৰ চাৰিওফালটো চিলোৱা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","তেওঁলোকে সেই চোলাৰ তল দাঁতিত, নীলা, বেঙেনা আৰু ৰঙা বৰণীয়া সূতা, আৰু পকোৱা মিহি শণ সূতাৰে ডালিমৰ নক্সা তুলিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","তেওঁলোকে শুদ্ধ সোণৰ জুণুকা গঢ়াই, সেই জুণুকাবোৰ ডালিমৰ মাজে মাজে চোলাৰ তলৰ দাঁতিৰ চাৰিওফালে লগাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","পৰিচৰ্যা কৰোঁতে, পিন্ধিবলৈ চোলাৰ তল দাঁতিত এটা জুণুকা এটা ডালিম, এটা জুণুকা এটা ডালিম এই দৰে চোলাৰ চাৰিওফালে লগাই দিলে। যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰে তেওঁলোকে সকলো কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","তেওঁলোকে হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ বাবে মিহি শণ সূতাৰে কোট চোলা প্রস্তুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","মিহি শণ সূতাৰ পাগুৰি, পকোৱা মিহি শণ সূতাৰে কপালত বন্ধা কাপোৰ, মিহি শণ সূতাৰে গুপ্তাঙ্গ ঢাকিবলৈ কাপোৰ প্রস্তত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","পকোৱা মিহি শণ সূতা আৰু নীলা, বেঙেনা, আৰু ৰঙা বৰণীয়া সূতাৰে, শিল্পকাৰে ফুল বছা টঙালি যুগুত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁলোকে শুদ্ধ সোণৰ পবিত্ৰ মুকুট যুগুত কৰিলে, আৰু মোহৰত খোদিতকৰাৰ দৰে তাৰ ওপৰত “যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ”, এই বচন ক্ষুদিত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","তেওঁলোকে পাগুৰিৰ ওপৰত মুকুট বান্ধিবলৈ, নীলা বৰণীয়া ফিতা লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","এই দৰে সাক্ষাৎ কৰা তম্বুৰ আবাসৰ সকলো কাৰ্য কৰি শেষ কৰিলে, যিহোৱাই মোচিক দিয়া আজ্ঞাৰ দৰেই ইস্ৰায়েলৰ লোকসকলে সকলো কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","তেওঁলোকে মোচিৰ ওচৰলৈ সেই আবাস লৈ গ’ল; তম্বু, আৰু তাৰ সকলো সামগ্রী, তাৰ হাঁকোটা, তক্তা, ডাং, খুঁটা, আৰু চুঙী। ");
INSERT INTO asmfb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ৰঙা ৰং কৰা মেৰ-ছাগৰ ছালৰ আৱৰণ, তহচ জন্তুৰ ছালৰ আৱৰণ, আৰু আঁৰ কৰি ৰখা পৰ্দা, ");
INSERT INTO asmfb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","সাক্ষ্য-ফলিৰ নিয়ম চন্দুক, আৰু তাৰ কানমাৰি, আৰু পাপাবৰণ। ");
INSERT INTO asmfb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","মেজ, তাৰ সকলো সঁজুলি, আৰু দৰ্শন-পিঠা; ");
INSERT INTO asmfb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","শুদ্ধ সোণৰ দীপাধাৰ আৰু শাৰী পাতি ৰখা প্ৰদীপবোৰ, তাৰ সকলো সঁজুলি, আৰু প্ৰদীপৰ বাবে তেল; ");
INSERT INTO asmfb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","সোণৰ বেদি, অভিষেক কৰা তেল, সুগন্ধি ধূপ, আৰু তম্বুৰ দুৱাৰৰ বাবে পৰ্দা। ");
INSERT INTO asmfb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","পিতলৰ বেদি তাৰ লগৰ পিতলৰ জালি, তাৰ কানমাৰি, আৰু তাৰ সকলো সঁজুলি। প্ৰক্ষালন-পাত্ৰ, আৰু তাৰ খুৰা। ");
INSERT INTO asmfb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","চোতালৰ পৰ্দাবোৰ, তাৰ খুঁটা আৰু চুঙী, আৰু চোতালৰ দুৱাৰৰ পৰ্দা, তাৰ ৰছী আৰু তম্বুৰ খুটি, আৰু সাক্ষাৎ কৰা তম্বুৰ বাবে আবাসৰ কাৰ্যৰ সকলো সজুলি। ");
INSERT INTO asmfb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","পবিত্ৰ-স্থানত পৰিচৰ্যা কৰিবলৈ নিপুণৰূপে প্রস্তুত কৰা মিহি বস্ত্ৰ, আৰু পুৰোহিত কৰ্ম কৰিবলৈ হাৰোণ পুৰোহিতৰ পবিত্ৰ বস্ত্ৰ, আৰু তেওঁৰ পুত্ৰসকলৰ বস্ত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","যি যি কৰ্ম কৰিবলৈ যিহোৱাই মোচিক আজ্ঞা কৰিছিল, সেই সকলোকে ইস্ৰায়েলৰ লোকসকলে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","তাৰ পাছত মোচিয়ে সেই সকলো কাম চোৱা চিতা কৰি সেই কাম সম্পূৰ্ন হোৱা দেখিলে। যিহোৱাৰ আজ্ঞা অনুসাৰেই সকলোকে কৰিলে; সেয়ে মোচিয়ে তেওঁলোকক আশীৰ্ব্বাদ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","তাৰ পাছত যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“তুমি নতুন বছৰৰ প্ৰথম মাহৰ প্ৰথম দিনা সাক্ষাৎ কৰা তম্বুৰ আবাস স্থাপন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","তুমি তাৰ ভিতৰত সাক্ষ্য-ফলিৰ নিয়ম চন্দুক ৰাখি পৰ্দাৰে সেই চন্দুক আঁৰ কৰি ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","মেজ ভিতৰলৈ আনি তাক সজাই ৰাখিবা; আৰু দীপাধাৰ ভিতৰলৈ আনি, তাৰ ওপৰত প্ৰদীপবোৰ জ্বলাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ধূপ জ্বলাবৰ বাবে সোণৰ বেদিটো সাক্ষ্য-ফলিৰ নিয়ম চন্দুকৰ আগত ৰাখিবা, আৰু আবাসৰ দুৱাৰত পৰ্দাবোৰ লগাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","সাক্ষাৎ কৰা তম্বুৰ আবাসৰ দুৱাৰৰ সন্মুখত হোমবেদি ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","সাক্ষাৎ কৰা তম্বু আৰু হোম-বেদিৰ মাজত প্ৰক্ষালন-পাত্ৰ থৈ, তাত পানী ভৰাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","চাৰিওফালে চোতাল যুগুত কৰিবা, আৰু চোতালৰ দুৱাৰত পৰ্দাবোৰ লগাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","তুমি অভিষেক কৰা তেল লৈ, আবাস আৰু তাৰ সকলোকে অভিষেক কৰি, তাক আৰু তাৰ সকলো বস্তু পবিত্ৰ কৰিবা; তাতে সেয়ে পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","তুমি হোম-বেদিটো আৰু তাৰ সকলো সঁজুলি অভিষেক কৰি, সেই বেদি পবিত্ৰ কৰিবা; তাতে সেই বেদি অতি পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","তুমি প্ৰক্ষালন পাত্ৰ আৰু তাৰ খুৰা অভিষেক কৰি তাক পবিত্ৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","তুমি হাৰোণক আৰু তেওঁৰ পুত্রসকলক সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখলৈ আনি, তেওঁলোকক পানীৰে গা ধুৱাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","হাৰোণক পবিত্ৰ বস্ত্ৰ পিন্ধাই, মোৰ অৰ্থে পুৰোহিত কৰ্ম কৰিবলৈ তেওঁক অভিষেক কৰি পবিত্ৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","তেওঁৰ পুত্ৰসকলকো আনি, কোট চোলা পিন্ধাবা। ");
INSERT INTO asmfb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","তেওঁলোকৰ পিতৃক যেনেকৈ অভিষেক কৰিবা, তেনেকৈ, তেওঁলোকেও মোৰ অৰ্থে পুৰোহিত কৰ্ম কৰিবলৈ পুত্রসকলক অভিষেক কৰিব। তাতে সেই অভিষেকেই তেওঁলোকৰ পুৰুষানুক্ৰমে চিৰস্থায়ী পুৰোহিত পদৰ চিন হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","মোচিয়ে সেইদৰেই কৰিলে; যিহোৱাই আজ্ঞা দিয়াৰ দৰেই তেওঁ সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","পাছে দ্বিতীয় বছৰৰ প্ৰথম মাহৰ প্ৰথম দিনা আবাস স্থাপন কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁ আবাস স্থাপন কৰিবলৈ, তাৰ চুঙী বহুৱাই, তক্তা খুৱাই ডাং সুমুৱাই, আৰু তাৰ খুটাবোৰ তুলি, ");
INSERT INTO asmfb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","সেই আবাসৰ ওপৰত তম্বু তৰিলে, আৰু তাৰ ওপৰত তম্বুৰ আৱৰণ লগালে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","পাছে যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁ সাক্ষ-ফলি দুখন লৈ নিয়ম চন্দুকটোৰ ভিতৰত ভৰাই, চন্দুকত কানমাৰি লগাই, নিয়ম চন্দুকৰ ওপৰত পাপাবৰণ থৈ, ");
INSERT INTO asmfb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","আৰু আবাসৰ ভিতৰলৈ নিয়ম চন্দুকটো আনি, আঁৰ কৰি ৰখা পৰ্দা লগাই, সাক্ষ-ফলিৰ নিয়ম চন্দুক ঢাকিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁ আবাসৰ উত্তৰফালে পৰ্দাৰ বাহিৰত সাক্ষাৎ কৰা তম্বুত মেজ ৰাখিলে, ");
INSERT INTO asmfb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","তাৰ ওপৰত যিহোৱাৰ সন্মুখত পিঠা সজাই থলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","পাছে যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁ সাক্ষাৎ কৰা তম্বুত মেজৰ সন্মুখত আবাসৰ দক্ষিণফালে দীপাধাৰ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","যিহোৱাৰ সন্মুখত প্ৰদীপবোৰ জ্বলাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","পাছে যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁ সাক্ষাৎ কৰা তম্বুৰ পৰ্দাৰ আগত সোণৰ বেদি ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","তাৰ ওপৰত সুগন্ধি ধূপ জ্বলালে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","পাছে যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, তেওঁ আবাসৰ দুৱাৰৰ পৰ্দা লগালে, ");
INSERT INTO asmfb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","আৰু সাক্ষাৎ কৰা তম্বুত আবাসৰ দুৱাৰৰ মুখত হোম-বেদি ৰাখি তাৰ ওপৰত হোমবলি আৰু ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","পাছে যিহোৱাই মোচিক দিয়া আজ্ঞাৰ দৰে, তেওঁ সাক্ষাৎ কৰা তম্বুৰ আৰু হোম-বেদিৰ মাজত, প্ৰক্ষালন-পাত্ৰ ৰাখি ধুবলৈ তাত পানী ভৰাই থলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","তাৰ পৰাই মোচি, হাৰোণ, আৰু তেওঁৰ পুত্ৰসকলে নিজৰ নিজৰ হাত ভৰি ধোৱে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","যেতিয়া তেওঁলোকে সাক্ষাৎ কৰা তম্বুত সোমায়, বা বেদিৰ ওচৰলৈ আহে, তেতিয়া ধোৱে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","পাছে তেওঁ আবাসৰ আৰু হোমবেদিৰ চাৰিওফালে চোতাল যুগুত কৰিলে; আৰু চোতালৰ দুৱাৰত পৰ্দা লগালে। এইদৰে মোচিয়ে কাৰ্য সমাপ্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","তাৰ পাছত মেঘে সাক্ষাৎ কৰা তম্বুটো ঢাকি ধৰিলে, আৰু যিহোৱাৰ প্ৰতাপে আবাস পৰিপূৰ্ণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","মোচিয়ে সাক্ষাৎ কৰা তম্বুত সোমাব নোৱাৰিলে; কিয়নো মেঘ তাৰ ওপৰত আছিল, আৰু যিহোৱাৰ প্ৰতাপে আবাস পৰিপূৰ্ণ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","পাছে আবাসৰ ওপৰৰ পৰা মেঘ উঠিলে, ইস্ৰায়েলৰ লোকসকলে তেওঁলোকৰ যাত্ৰা আৰম্ভ কৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","কিন্তু আবাসৰ ওপৰৰ পৰা যদি মেঘ আঁতৰি নাযায়, তেতিয়ালৈকে তেওঁলোকে যাত্ৰা নকৰে। ");
INSERT INTO asmfb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","কিয়নো গোটেই ইস্ৰায়েল বংশৰ চকুৰ আগত, তেওঁলোকৰ আটাই যাত্ৰাত, দিনত যিহোৱাৰ মেঘ আবাসৰ ওপৰত আছিল, আৰু ৰাতি অগ্নি আবাসৰ ভিতৰত আছিল।");
INSERT INTO asmfb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","যিহোৱাই মোচিক মাতিলে, আৰু সাক্ষাৎ কৰা তম্বুৰ পৰা তেওঁ এই কথা ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক এই কথা কোৱা, ‘তোমালোকৰ মাজৰ কোনোৱে যদি যিহোৱাৰ উদ্দেশ্যে উপহাৰ উৎসৰ্গ কৰে, তেন্তে সেয়ে ষাঁড়-গৰু আৰু মেৰ বা মেৰ-ছাগ হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","যদি তেওঁৰ উপহাৰ ষাঁড়-গৰুৰ জাকৰ পৰা অনা হোম বলি হয়, তেন্তে নিৰ্ঘূণী মতা গৰু উৎসৰ্গ কৰিব লাগিব। যিহোৱাৰ আগত গ্ৰাহ্য হ’বৰ কাৰণে, সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত ইয়াক উৎসৰ্গ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","পাছত তেওঁ হোম-বলিৰ মূৰত হাত দিব; তেতিয়া সেই বলি তেওঁৰ প্ৰায়শ্চিত্তৰ অৰ্থে তেওঁৰ পক্ষত গ্ৰাহ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","আৰু তেওঁ যিহোৱাৰ সন্মুখত সেই দমৰা ষাঁড়-গৰুটো কাটিব। তেতিয়া হাৰোণৰ পুত্ৰ পুৰোহিত সকলে তাৰ তেজ আনিব, আৰু সাক্ষাৎ কৰা তম্বুৰ দুৱাৰৰ সন্মুখত থকা যজ্ঞবেদীৰ চাৰিওফালে সেই তেজ ছটিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","তেতিয়া সেই বলিৰ ছাল বখলিয়াই তাক খণ্ড খণ্ড কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","আৰু হাৰোণ পুৰোহিতৰ পুত্ৰসকলে বেদীৰ ওপৰত জুই ৰাখিব আৰু জুইৰ ওপৰত কাঠ জাপি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","আৰু হাৰোণৰ পুত্ৰ পুৰোহিতসকলে সেই বেদীৰ ওপৰত থকা জুই আৰু কাঠৰ ওপৰত সেই খণ্ডবোৰ, মূৰ আৰু তেল ঠিক মতে ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","কিন্তু তেওঁ তাৰ নাড়ী-ভুৰু আৰু ঠেং পানীত ধুব লাগিব। তেতিয়া পুৰোহিতে বেদীৰ ওপৰত সেই সকলোকে দগ্ধ কৰিব। সেয়ে হোম-বলি, যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","আৰু যদি তেওঁৰ উপহাৰ মেৰ-ছাগ বা ছাগলীৰ জাকৰ পৰা অনা হোম-বলি হয়, তেন্তে তেওঁ নিৰ্ঘূণী মতা পশু উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","আৰু যজ্ঞবেদীৰ কাষত উত্তৰফালে যিহোৱাৰ সন্মুখত তাক কটা হ’ব; তেতিয়া হাৰোণৰ পুত্ৰ পুৰোহিত সকলে বেদীৰ চাৰিওফালে তাৰ তেজ ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","পাছত তেওঁ তাক খণ্ড খণ্ড কৰি কাটিব; আৰু পুৰোহিতে তাৰ মূৰ আৰু তেলেৰে সৈতে তাক বেদীৰ ওপৰত থকা জুই আৰু কাঠৰ ওপৰত ঠিকমতে সজাই ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","কিন্তু তাৰ নাড়ী-ভুৰু আৰু ঠেং পানীৰে ধুব লাগিব; তাৰ পাছত পুৰোহিতে সেই সকলো উৎসৰ্গ কৰিব আৰু বেদীৰ ওপৰত দগ্ধ কৰিব; সেয়ে হোম-বলি, যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","যদি যিহোৱাৰ উদ্দেশ্যে দিয়া তেওঁৰ উপহাৰ পক্ষীবোৰৰ মাজৰ পৰা অনা হোম-বলি হয়, তেন্তে তেওঁ কপৌবোৰৰ বা পাৰ পোৱালিবোৰৰ মাজৰ পৰা নিজ উপহাৰ উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","পাছত পুৰোহিতে তাক বেদীৰ ওপৰলৈ আনি, মূৰটো মুচৰি চিঙি, তাক বেদীত দগ্ধ কৰিব; আৰু তাৰ তেজ বেদীৰ কাষেৰে উলিয়াই দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","পাছত পুৰোহিতে তাৰ নাড়ী-ভুৰু আৰু আমঠুটো লৈ, বেদীৰ কাষত থকা পূবফালৰ ছাঁই পেলোৱা ঠাইত পেলাই দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","তাৰ পাছত পুৰোহিতে তাৰ ডেউকা দুখন কাটিব, কিন্তু সম্পূৰ্ণৰূপে তাক দুভাগ নকৰিব, আৰু বেদীত জুই আৰু কাঠৰ ওপৰত তাক দগ্ধ কৰিব; সেয়ে হোম-বলি, যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","যেতিয়া কোনো লোক এজনে যিহোৱাৰ উদ্দেশ্যে ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰে, তেতিয়া তেওঁৰ উপহাৰ মিহি আটাগুড়ি হ’ব; আৰু তেওঁ তাত তেল ঢালি তাৰ ওপৰত ধূপ-ধূনা দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","তেতিয়া তেওঁৰ সেই উপহাৰ তেওঁ হাৰোণৰ পুত্ৰ পুৰোহিত সকলৰ ওচৰলৈ আনিব; পাছত পুৰোহিতসকলৰ এজনে তাৰ পৰা এমুঠি মিহি আটাগুড়ি, এচলু তেল, আৰু আটাইখিনি ধূপ-ধূনা লৈ, তাৰ স্মৰণাৰ্থক অংশ বুলি তাক বেদীৰ ওপৰত দগ্ধ কৰিব; সেয়ে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","সেই ভক্ষ্য নৈবেদ্যৰ বাকীখিনি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ কাৰণে হ’ব; যিহোৱাৰ অগ্নিকৃত উপহাৰবোৰৰ মাজত সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","যেতিয়া তুমি তন্দুৰত তাও দিয়া ভক্ষ্য নৈবেদ্য উপহাৰস্বৰূপে উৎসৰ্গ কৰিবা, তেতিয়া তেল মিহলোৱা মিহি আটাগুড়িৰে কৰা খমিৰ নিদিয়া বিন্ধা থকা কেইটামান পিঠা, বা তেল ঢলা খমিৰ নিদিয়া কেইটামান পাতল চকলীয়া পিঠা দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","আৰু যদি তাৱাত তাও দিয়া ভক্ষ্য নৈবেদ্য তোমাৰ উপহাৰ হয়, তেন্তে খমীৰ নিদিয়া তেল মিহলোৱা মিহি আটাগুড়িৰে কৰা পিঠা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","তুমি তাক ডোখৰ-ডোখৰ কৰি, তাৰ ওপৰত তেল ঢালিবা; সেয়ে ভক্ষ্য নৈবেদ্য। ");
INSERT INTO asmfb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","আৰু যদি কেৰাহীত ভজা ভক্ষ্য নৈবেদ্য তোমাৰ উপহাৰ হয়, তেন্তে তেলত ভাজি মিহি আটাগুড়িৰে কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","এইবোৰ নিয়মৰ কোনো নিয়মৰে যুগুত কৰা ভক্ষ্য নৈবেদ্য তুমি যিহোৱাৰ উদ্দেশ্যে আনিবা; আৰু তাক পুৰোহিতক দিয়া হব। তেতিয়া তেওঁ তাক বেদীৰ ওচৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","পুৰোহিত জনে সেই নৈবেদ্যৰ স্মৰণাৰ্থক অংশ লৈ বেদীত দগ্ধ কৰিব; সেয়ে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","আৰু সেই নৈবেদ্যৰ বাকীখিনি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ হ’ব; যিহোৱাৰ অগ্নিকৃত উপহাৰবোৰৰ মাজত সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","তোমালোকে যিহোৱাৰ উদ্দেশ্যে যি কোনো ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰিবা, তাক খমীৰেৰে যুগুত কৰা হ’ব নালাগে; কিয়নো খমীৰ বা মৌ ইয়াৰে একোকে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে তোমালোকে দগ্ধ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","তোমালোকে প্ৰথম ফলৰ উপহাৰ বুলি তাক যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিব পাৰা; কিন্তু সুঘ্ৰাণৰ অৰ্থে বেদীৰ ওপৰত তাক তোলা নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","আৰু তুমি নিজ ভক্ষ্য নৈবেদ্যৰ প্ৰত্যেক উপহাৰত লোণ সানিবা; তুমি নিজ ভক্ষ্য নৈবেদ্যত, নিজ ঈশ্বৰৰ নিয়মটিৰ চিন যি লোণ, তাক দিবলৈ ক্রুটি নকৰিবা; তোমাৰ সকলো উপহাৰবোৰ লোণে সৈতে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","তুমি যদি যিহোৱাৰ উদ্দেশ্যে শস্যৰ প্ৰথম ফলৰ নৈবেদ্য স্বৰূপে জুইত পোৰা থোক, অৰ্থাৎ মোহাৰি উলিওৱা শস্যৰ নতুন গুটি উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","তাৰ পাছত তুমি তাৰ ওপৰত তেল আৰু ধূপ-ধূনা দিবা; সেয়ে ভক্ষ্য নৈবেদ্য। ");
INSERT INTO asmfb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","পাছত পুৰোহিতে তাৰ স্মৰণাৰ্থক অংশ বুলি কিছু মোহৰা শস্য, কিছু তেল আৰু আটাইখিনি ধূপ-ধূনা দগ্ধ কৰিব; সেয়ে যিহোৱাৰ উদ্দেশ্যে অগ্নিতকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","যদি কোনো এজন লোকৰ উপহাৰ মঙ্গলাৰ্থক বলি হয়, তেন্তে পশুৰ জাকৰ মতা বা মাইকীয়েই হওঁক, তাক উৎসৰ্গ কৰিলে, তেওঁ যিহোৱাৰ সন্মুখত এটা নিৰ্ঘূণী পশু উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","তেওঁ নিজ উপহাৰৰ মূৰত হাত দিব আৰু সাক্ষাৎ কৰা তম্বুৰ দুৱাৰমুখত তাক কাটিব; তেতিয়া হাৰোণৰ পুত্ৰ পুৰোহিত সকলে তাৰ তেজ বেদীৰ কাষৰ চাৰিওফালে ছটিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","সেই লোক জনে তেওঁৰ সেই মঙ্গলাৰ্থক বলিৰ পৰা যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে তাৰ নাড়ি-ভুৰু ঢকা তেল, ");
INSERT INTO asmfb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","নাড়ীত লাগি থকা আটাই তেল, ঘিলা দুটা আৰু কলিজাৰ ওচৰত থকা তেলীয়া ভাগ উৎসৰ্গ কৰিব; সেই ভাগ ঘিলালৈকে এৰুৱাই ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","তেতিয়া হাৰোণৰ পুত্ৰসকলে বেদীত, জুই, কাঠ আৰু হোমৰ ওপৰত তাক দগ্ধ কৰিব; সেয়ে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","আৰু যদি তেওঁ যিহোৱাৰ উদ্দেশ্যে মঙ্গলাৰ্থক বলিৰ উপহাৰ মেৰ-ছাগ বা ছাগলীৰ জাকৰ পৰা দিয়ে, তেন্তে তেওঁ নিঘূণ মতা বা মাইকী পশু উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","নিজ উপহাৰৰ অৰ্থে যদি তেওঁ মেৰ-ছাগ পোৱালি উৎসৰ্গ কৰে, তেন্তে তেওঁ তাক যিহোৱাৰ সন্মুখত উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","তেওঁ নিজ উপহাৰৰ মূৰত হাত দিব আৰু সাক্ষাৎ কৰা তম্বুৰ সন্মুখত তাক কাটিব; তেতিয়া হাৰোণৰ পুত্ৰসকলে বেদীৰ কাষৰ চাৰিওফালে তাৰ তেজ ছটিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","পাছত তেওঁ সেই মঙ্গলাৰ্থক বলিৰ পৰা যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে তাৰ তেল, গোটেইডাল নেগুৰ, নাড়ী-ভুৰু ঢকা তেল আৰু নাড়ীত লাগি থকা আটাই তেল, ");
INSERT INTO asmfb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ঘিলা দুটা আৰু কিনাৰত লাগি থকা তাৰ ওপৰৰ তেল আৰু কলিজাৰ ওচৰত থকা তাৰ তেলীয়া ভাগ উৎসৰ্গ কৰিব; তেওঁ এই ভাগবোৰ ঘিলালৈকে এৰুৱাই ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","তেতিয়া পুৰোহিতে তাক বেদীত দগ্ধ কৰিব। সেয়ে যিহোৱাৰ উদ্দেশ্যে দিয়া অগ্নিকৃত উপহাৰ স্বৰূপ ভক্ষ্য নৈবেদ্য। ");
INSERT INTO asmfb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","আৰু যদি তেওঁৰ উপহাৰ ছাগলী হয়, তেন্তে তেওঁ তাক যিহোৱাৰ সন্মুখত দান কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","তেওঁ সেই ছাগলীৰ মূৰত হাত দিব আৰু সাক্ষাৎ কৰা তম্বুৰ সন্মুখত তাক কাটিব; তেতিয়া হাৰোণৰ পুত্ৰসকলে বেদীৰ কাষৰ চাৰিওফালে তাৰ তেজ ছটিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","পাছত তেওঁ তাৰ পৰা নিজৰ নৈবেদ্য, অৰ্থাৎ যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে নাড়ী-ভুৰু ঢকা তেল, নাড়ীত লাগি থকা আটাই তেল এৰুৱাব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","তেওঁ তাৰ ভিতৰৰ ঘিলা দুটা আৰু কিনাৰত লাগি থকা তাৰ ওপৰৰ তেল আৰু কলিজাৰ ওচৰত থকা তেলীয়া ভাগ ঘিলালৈকে এৰুৱাই ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","তেতিয়া পুৰোহিতে বেদীৰ ওপৰত সেই সকলোকে দগ্ধ কৰিব; সেয়ে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ স্বৰূপ ভক্ষ্য দ্ৰব্য; সকলো তেল যিহোৱাৰ উদ্দেশ্যে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","তোমালোকে তেল আৰু তেজ যে খাব নালাগে, এয়ে তোমালোকৰ পুৰুষানুক্ৰমে, তোমালোকে বাস কৰা সকলো ঠাইতে পালন কৰিবলগীয়া চিৰস্থায়ী বিধি’।” ");
INSERT INTO asmfb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক কোৱা, ‘যেতিয়া কোনো এজন লোকে, যিহোৱাই নিষেধ কৰা কোনো কৰ্ম কৰি, নজনাকৈ পাপ কৰে, তেতিয়া তেওঁ এই ধৰণে কৰিব লাগিব; ");
INSERT INTO asmfb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","তেতিয়া লোকসকলক দোষত পেলোৱাকৈ পাপ কৰা জন যদি অভিষিক্ত পুৰোহিত হয়, তেন্তে তেওঁ নিজে কৰা পাপৰ কাৰণে, যিহোৱাৰ উদ্দেশ্যে এটা নিঘূণ দমৰা ষাঁড়-গৰু পাপাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","তেওঁ সেই দমৰা ষাঁড়-গৰুটো সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখেৰে যিহোৱাৰ আগলৈ আনিব আৰু ষাঁড়-গৰুটোৰ মূৰত হাত দি, যিহোৱাৰ সন্মুখত তাক কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","তেতিয়া সেই অভিষিক্ত পুৰোহিত জনে দমৰা ষাঁড়-গৰুটোৰ অলপ তেজ সাক্ষাৎ কৰা তম্বুৰ ভিতৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","আৰু পুৰোহিত জনে সেই তেজত নিজৰ আঙুলি জুবুৰিয়াই পবিত্ৰ স্থানৰ প্ৰভেদক বস্ত্ৰৰ আগফালে যিহোৱাৰ সন্মুখত সাতবাৰ তাৰ কিছু তেজ ছটিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","পুৰোহিত জনে তাৰে কিছু তেজ লৈ, সাক্ষাৎ কৰা তম্বুৰ ভিতৰত যিহোৱাৰ সন্মুখত থকা সুগন্ধি ধূপৰ বেদীৰ শিঙত লগাব; তেওঁ ভতৰা গৰুটোৰ বাকী তেজখিনি সাক্ষাৎ কৰা তম্বুৰ দুৱাৰমুখত থকা হোম-বেদিৰ মূলত ঢালি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","আৰু পাপাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰা ষাঁড়-গৰুটোৰ আটাইবোৰ তেল এৰুৱাই ল’ব; তাৰ নাড়ী-ভুৰু ঢকা তেল, নাড়ীত লাগি থকা আটাই তেল, ");
INSERT INTO asmfb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ঘিলা দুটা আৰু কিনাৰত লাগি থকা তাৰ ওপৰৰ তেল আৰু কলিজাৰ ওচৰত থকা তেলীয়া ভাগ - তেওঁ এই সকলো এৰুৱাই ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","মঙ্গলাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰা ষাঁড়-গৰুটোৰ তেল যেনেকৈ এৰুৱাই লয়, তেনেকৈ এইটোৰো এৰুৱাই ল’ব। তেতিয়া পুৰোহিতে সেই সকলো হোমবেদিৰ ওপৰত দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","পাছত সেই ষাঁড়-গৰুটোৰ ছাল আৰু অৱশিষ্ট মঙহ, মূৰ আৰু ঠেং, নাড়ী-ভুৰু আৰু গোবৰৰ সৈতে, ");
INSERT INTO asmfb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ষাঁড়-গৰুটোৰ ৰৈ যোৱা সকলো অৱশিষ্ট অংশ ছাউনিৰ বাহিৰত মোৰ কাৰণে, সেই শুচি কৰা ছাঁই পেলোৱা ঠাইলৈ লৈ আনিব; আনিব; আৰু সেইবোৰ কাঠৰ ওপৰত তুলি জুইত জ্বলাই ভষ্ম কৰিব লাগিব, আৰু সেইবোৰ ছাঁই পেলাই দিয়া ঠাইতহে পুৰি ভষ্ম কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ইস্ৰায়েলী লোকসকলে যদি নজনাকৈ পাপ কৰে আৰু যিহোৱাই নিষেধ কৰা কোনো কৰ্ম কৰাৰ বিষয়ে যদি সমাজে নেদেখাকৈ থাকে, আৰু তেওঁলোক যদি দোষী হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","আৰু ইস্ৰায়েলী লোকসকলে কৰা সেই পাপ যেতিয়া প্ৰকাশ পাব, তেতিয়া তেওঁলোকে পাপাৰ্থক বলি স্বৰূপে এটা দমৰা ষাঁড়-গৰু উৎসৰ্গ কৰিব আৰু তেওঁলোকে তাক সাক্ষাৎ কৰা তম্বুৰ সন্মুখলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","তেতিয়া সমাজৰ পৰিচাৰকসকলে যিহোৱাৰ সন্মুখত সেই ষাঁড়-গৰুটোৰ মূৰত হাত দিব আৰু তেওঁলোকৰ এজনে যিহোৱাৰ সন্মুখত তাক কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","তেতিয়া অভিষিক্ত পুৰোহিত জনে ষাঁড়-গৰুটোৰ কিছু তেজ লৈ সাক্ষাৎ কৰা তম্বুৰ ভিতৰলৈ আনিব; ");
INSERT INTO asmfb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","আৰু পুৰোহিত জনে সেই তেজত নিজ আঙুলি জুবুৰিয়াই, তাৰ কিছু তেজ প্ৰভেদক বস্ত্ৰৰ আগফালে যিহোৱাৰ সন্মুখত সাতবাৰ ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","তেওঁ সেই তেজৰ পৰা কিছু তেজ লৈ, সাক্ষাৎ কৰা তম্বুৰ ভিতৰত যিহোৱাৰ সন্মুখত থকা বেদীৰ শিঙত লগাব, আৰু অৱশিষ্ট থকা তেজখিনি তেওঁ সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত থকা হোমবেদিৰ মূলত ঢালি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","তেওঁ সেই বলিৰ পৰা তাৰ আটাইবোৰ তেল এৰুৱাই ল’ব আৰু বেদীৰ ওপৰত তাক দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","তেওঁ সেই দমৰা ষাঁড়-গৰুটোকো এইদৰে কৰিব। পাপাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰা গৰুটো যেনেকৈ কৰে, তেনেকৈ ষাঁড়-গৰুটোকো কৰিব। এইদৰে পুৰোহিত জনে লোকসকলক প্ৰায়শ্চিত্ত কৰিব আৰু তেতিয়া তেওঁলোকৰ পাপ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","তেওঁ সেই ষাঁড়-গৰুটো চাউনিৰ বাহিৰলৈ নি প্ৰথম গৰুটোৰ নিচিনাকৈ তাকো পুৰি ভষ্ম কৰিব লাগিব; এয়েই সমাজৰ পাপাৰ্থক বলি। ");
INSERT INTO asmfb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","যেতিয়া কোনো শাসনকৰ্ত্তাই নাজানি পাপ কৰে, নিজ ঈশ্বৰ যিহোৱাই নিষেধ কৰা কৰ্মবোৰৰ কোনো এটা কৰে, আৰু তেওঁ যদি দোষী হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","পাছত নিজে কৰা সেই পাপৰ বিষয়ে তেওঁ যেতিয়া জ্ঞাত হ’ব, তেতিয়া তেওঁ নিজ উপহাৰ স্বৰূপে এটা নিৰ্ঘূণী মতা ছাগলী আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","তেওঁ সেই ছাগলীটোৰ মূৰত হাত দিব আৰু হোম-বলি কটা ঠাইত যিহোৱাৰ সাক্ষাতে তাক কাটিব; সেয়ে পাপাৰ্থক বলি। ");
INSERT INTO asmfb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","তেতিয়া পুৰোহিতে নিজ আঙুলিৰে সেই পাপাৰ্থক বলিৰ অলপ তেজ লৈ, হোমবেদীৰ শিঙত লগাব; আৰু অৱশিষ্ট তেজ খিনি হোমবেদিৰ মূলত ঢালি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","তেওঁ মঙ্গলাৰ্থক বলিৰ তেলৰ দৰে তাৰ আটাই তেল বেদীত দগ্ধ কৰিব। এইদৰে পুৰোহিতে শাসনকৰ্তা জনৰ পাপ-মোচনৰ অৰ্থে প্ৰায়শ্চিত্ত কৰিব আৰু তেতিয়া তেওঁৰ পাপৰ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","আৰু সাধাৰণ লোকসকলৰ মাজৰ যদি কোনোৱে নজনাকৈ পাপ কৰে; যিহোৱাই নিষেধ কৰা কোনো কৰ্ম কৰে, আৰু সেই পাপত যদি তেওঁ দোষী হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","তেন্তে নিজে কৰা পাপ যেতিয়া তেওঁৰ জ্ঞাত হ’ব, তেতিয়া নিজে কৰা সেই পাপৰ কাৰণে নিজ উপহাৰ স্বৰূপে তেওঁ জাকৰ মাজৰ পৰা এজনী নিৰ্ঘূণী ছাগলী আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","তেওঁ সেই পাপাৰ্থক বলিৰ মূৰত হাত দিব আৰু হোম-বলি কটা ঠাইত সেই পাপাৰ্থক বলি কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","তেতিয়া পুৰোহিতে আঙুলিৰে তাৰ কিছু তেজ লৈ, হোমবেদিৰ শিঙত লগাব আৰু তাৰ অৱশিষ্ট তেজখিনি বেদিৰ মূলত ঢালি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","আৰু মঙ্গলাৰ্থক বলিৰ পৰা তেল এৰুৱাই লোৱাৰ দৰে তাৰো আটাইবোৰ তেল এৰুৱাই ল’ব; তাৰ পাছত পুৰোহিতে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে বেদীৰ ওপৰত তাক দগ্ধ কৰিব; এইদৰে পুৰোহিতে সেই লোক জনৰ পাপৰ অৰ্থে প্ৰায়শ্চিত্ত কৰিব আৰু তেওঁৰ পাপ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","যদি তেওঁ পাপাৰ্থক বলিৰ উপহাৰ স্বৰূপে মেৰ-ছাগ পোৱালি আনে, তেন্তে তেওঁ এজনী নিৰ্ঘূণী চেঁউৰী মেৰ-ছাগ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","তাৰ পাছত তেওঁ সেই পাপাৰ্থক বলিৰ মূৰত হাত দিব আৰু হোমবলি কটা ঠাইত পাপাৰ্থক বলি স্বৰূপে তাক কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","পুৰোহিতে নিজ আঙুলিৰে সেই পাপাৰ্থক বলিৰ কিছু তেজ লৈ হোম-বেদিৰ শিঙত লগাব আৰু অৱশিষ্ট তেজখিনি বেদিৰ মূলত ঢালি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","তেওঁ মঙ্গলাৰ্থক বলিৰ মেৰ-ছাগ পোৱালিটোৰ তেল এৰুৱাই লোৱাৰ দৰে ইয়াৰো আটাইবোৰ তেল এৰুৱাই ল’ব আৰু যিহোৱাৰ উদ্দেশ্যে দিয়া অগ্নিকৃত উপহাৰৰ বিধি মতে পুৰোহিতে বেদীত তাক দগ্ধ কৰিব; এইদৰে পুৰোহিতে লোক জনে কৰা পাপৰ অৰ্থে প্ৰায়শ্চিত্ত কৰিব আৰু তেওঁৰ পাপৰ ক্ষমা হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","যদি কোনো এজন লোকে কোনো এক বিষয়ৰ কথা শুনি বা দেখি, সেই বিষয়ে সাক্ষ্য দিব পৰা হৈয়ো তাক প্ৰকাশ নকৰি পাপ কৰে, তেন্তে তেওঁ নিজ অপৰাধৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","অথবা কোনো অশুচি বনৰীয়া জন্তুৰ শৱ বা অশুচি ঘৰচীয়া পশুৰ শৱ আৰু অশুচি উৰগ আদি জন্তুৰেই হওঁক, যিটোক ঈশ্বৰে অশুচি কৰিলে, তাক যদি কোনোবাই কোনো অশুচি বস্তু বুলি নজনাকৈ স্পৰ্শ কৰি আনুষ্ঠানিকভাবে অশুচি হয়, তেন্তে তেওঁ দোষী হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","বা মানুহৰ যিকোনো ধৰণৰ অশৌচ হওঁক, তাক যদি কোনোৱে নজনাকৈ স্পৰ্শ কৰে, তেন্তে তেওঁ সেই বিষয়ে জানিলে দোষী হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","বা মানুহে অবিবেচনাৰে যি যি বিষয় শপত লয়, সেই সেই বিষয়ে ভাল কাৰ্যই হওঁক বা বেয়া কাৰ্যই হওঁক, কৰিম বুলি যদি কোনোৱে নিজ ওঁঠেৰে অবিবেচনাৰে, আগলৈ কি হব তাক নজনাকৈ শপত খায়, তেন্তে তেওঁ তাক জানিলে, সেই সেই বিষয়ত তেওঁ দোষী হব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","আৰু সেই বিষয়বোৰৰ কোনো বিষয়ত যেতিয়া কোনোজন দোষী হয়, তেতিয়া তেওঁ নিজ পাপ অৱশ্যে স্বীকাৰ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","তেওঁ নিজে কৰা পাপৰ দণ্ডস্বৰূপে পাপাৰ্থক বলিদানৰ বাবে, জাকৰ পৰা এজনী চেঁউৰী মেৰ-ছাগ বা চেঁউৰী ছাগলী যিহোৱাৰ উদ্দেশ্যে আনিব; আৰু পুৰোহিতে তেওঁৰ পাপৰ কাৰণে তেওঁক প্ৰায়শ্চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","যদি তেওঁ মেৰ বা ছাগলী আনিবলৈ অসমৰ্থ হয়, তেন্তে তেওঁ কৰা নিজৰ পাপৰ দণ্ডস্বৰূপে যিহোৱাৰ উদ্দেশ্যে দুটা কপৌ বা দুটা পাৰ পোৱালি আনিব, তাৰে এটা পাপাৰ্থক বলিৰ বাবে আৰু আনটো হোম-বলিৰ বাবে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","তেওঁ সেই দুটাক পুৰোহিতৰ ওচৰলৈ আনিব; আৰু পুৰোহিতে আগেয়ে পাপাৰ্থক বলি উৎসৰ্গ কৰিবলৈ তাৰ মুৰৰ ওচৰত ডিঙি মুচৰিব, কিন্তু মূৰটো সম্পূৰ্ণকৈ নেৰুৱাব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","তাৰ পাছত পাপাৰ্থক বলিৰ অলপ তেজ বেদীৰ গাত ছটিয়াব আৰু অৱশিষ্ট তেজখিনি বেদীৰ মুলত বাকি দিব লাগিব; এয়ে পাপাৰ্থক বলি। ");
INSERT INTO asmfb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","তেতিয়া তেওঁ প্ৰথমতে দিয়া বিধিমতে দ্বিতীয়টো হোমৰ অৰ্থে উৎসৰ্গ কৰিব। এইদৰে পুৰোহিতে, তেওঁ কৰা পাপৰ কাৰণে তেওঁক প্ৰায়চিত্ত কৰিব; আৰু তেওঁৰ পাপ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","কিন্তু তেওঁ যদি দুটা কপৌ বা দুটা পাৰ পোৱালি আনিবলৈ অসমৰ্থ হয়, তেন্তে তেওঁ নিজে কৰা পাপ কৰ্মৰ বাবে, নিজ উপহাৰ স্বৰূপে ঐফাৰ দহ ভাগৰ এভাগ মিহি আটাগুড়ি, পাপাৰ্থক নৈবেদ্যস্বৰূপে আনিব; তাৰ ওপৰত তেল নিদিব, কিয়নো সেয়ে পাপাৰ্থক নৈবেদ্য। ");
INSERT INTO asmfb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","তেওঁ ইয়াক নিশ্চয়ে পুৰোহিতৰ ওচৰলৈ আনিব আৰু পুৰোহিতে তেওঁৰ স্মৰণাৰ্থক নৈবেদ্য হিচাবে তেওঁৰ বুলি তেওঁৰ পৰা এমুঠি লৈ যিহোৱাৰ অগ্নিকৃত উপহাৰৰ বিধিমতে তাক বেদীত দগ্ধ কৰিব; সেয়ে পাপাৰ্থক নৈবেদ্য। ");
INSERT INTO asmfb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","এইদৰে, পুৰোহিতে সেইবোৰ ভিতৰৰ কোনো এটা বিষয়ত, তেওঁ কৰা পাপৰ কাৰণে তাক প্ৰায়চিত্ত কৰিব; তেতিয়া তেওঁৰ পাপ ক্ষমা হ’ব; আৰু অৱশিষ্ট ভাগ ভক্ষ্য নৈবেদ্যৰ দৰে পুৰোহিতৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","তেতিয়া যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“যদি কোনোৱে যিহোৱাৰ পবিত্ৰ বস্তুৰ কোনো এটা বস্তু ৰাখি, আজ্ঞা লংঘন কৰি নজনাকৈ পাপ কৰে, তেন্তে তেওঁ জাকৰ পৰা, পবিত্ৰ-স্থানৰ চেকল অনুসাৰে যিহোৱাই নিৰূপণ কৰাৰ দৰে, অতি কমেও দুই চেকল দামৰ এটা নিৰ্ঘূণী মতা মেৰ দোষাৰ্থক বলি স্বৰূপে যিহোৱাৰ উদ্দেশ্যে আনিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","তেওঁ যি যি পবিত্ৰ বস্তু ৰাখি তেওঁ পাপ কৰিলে, যিহোৱাক সন্তুষ্ট কৰিবলৈ ক্ষতি পুৰণ কৰিব লাগিব আৰু তাৰ লগত পাঁচভাগৰ এভাগ পুৰোহিতক বেছিকৈ দিব লাগিব; পাছত পুৰোহিতে সেই দোষাৰ্থক মেৰটো বলি দিয়াৰ দ্বাৰাই তেওঁক প্ৰায়চিত্ত কৰিব, তেতিয়া তেওঁৰ পাপ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","আৰু কোনোৱে যদি যিহোৱাই নিষেধ কৰা কোনো কৰ্ম কৰি পাপ কৰে, তেন্তে তেওঁ তাক নাজানিলেও দোষী হ’ব; আৰু নিজ অপৰাধৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","তেওঁ দোষাৰ্থক বলি দানৰ বাবে, জাকৰ পৰা তোমাৰ নিৰূপিত মূল্য এটা নিৰ্ঘূণী মতা মেৰ পুৰোহিতৰ ওচৰলৈ আনিব আৰু পুৰোহিতে, তেওঁ নাজানি কৰা দোষৰ বাবে তেওঁক প্ৰায়চিত্ত কৰিব, তেতিয়া তেওঁৰ পাপৰ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","এয়ে হৈছে দোষাৰ্থক বলি; তেওঁ অৱশ্যে যিহোৱাৰ সাক্ষাতে দোষী।” ");
INSERT INTO asmfb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","যিহোৱাই মোচিক ক’লে, আৰু মোচিয়ে, ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“কোনোৱে যদি যিহোৱাৰ বিৰুদ্ধে আজ্ঞা লংঘন কৰি পাপ কৰে, আৰু কোনো লোকৰ তাত বস্তু থোৱা বা বন্ধক ৰখা বা অপহৰণ কৰা, কোনো বস্তুৰ বিষয়ে লোকৰ আগত মিছা কথা কোৱা বা লোকক অত্যাচাৰ কৰা ");
INSERT INTO asmfb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","বা হেৰুৱা বস্তু পাই ৰাখি মিছা কথা কোৱা আৰু মিছা শপত কৰা আদি যি সকলো কৰ্মৰ দ্বাৰাই মানুহ পাপী হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","সেইবোৰৰ এটা কৰ্ম কৰি যদি পাপ কৰে আৰু দোষী হয়, তেন্তে তেওঁ যি বস্তু অপহৰণ কৰিলে বা অত্যাচাৰ কৰি পালে বা যি বস্তু থবলৈ তেওঁৰ হাতত গটাই দিয়া হ’ল বা হেৰুৱা বস্তু পাই ৰাখিলে, তাক পুনৰ ঘূৰাই দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","বা যিকোনো বিষয়ত যদি তেওঁ মিছা শপত খালে, তেনেহলে নিশ্চয়কৈ সম্পূৰ্ণৰূপে তেওঁ সেই বস্তুৰ ক্ষতি পুৰণ কৰিব লাগিব আৰু তাৰ লগত পাঁচভাগৰ এভাগ বেছিকৈ দিব লাগিব আৰু তাৰ দোষ প্ৰকাশিত হোৱা দিনা তেওঁ সেই বস্তুৰ প্ৰকৃত গৰাকীক দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","তেওঁ দোষাৰ্থক বলিদানৰ কাৰণে যিহোৱালৈ বলি আনিব আৰু ইয়াক জাকৰ পৰা নিৰূপিত মূল্যৰ এটা নিৰ্ঘূণী মতা মেৰ নিজৰ দোষাৰ্থক বলি স্বৰূপে পুৰোহিতৰ ওচৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","পুৰোহিতে যিহোৱাৰ সন্মুখত তেওঁক প্ৰায়চিত্ত কৰিব; আৰু যি কৰ্মৰ দ্বাৰাই তেওঁ দোষী হয়, সেই দোষৰ পৰা তেওঁ ক্ষমা পাব।” ");
INSERT INTO asmfb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","তেতিয়া যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“তুমি হাৰোণক আৰু তেওঁৰ পুত্ৰসকলক এই আজ্ঞা দিয়া, ‘হোমৰ নিয়ম এই: হোম-দ্ৰব্য ওৰে ৰাতি আনকি ৰাতিপুৱালৈকে বেদীৰ ওপৰত জুইশালত থাকিব আৰু বেদীৰ জুই তাৰ দ্ৱাৰাই জ্বলি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","পুৰোহিত শণ সূতাৰ অন্তৰ্বাস পিন্ধিব আৰু বেদীৰ ওপৰত অগ্নিকৃত হোমৰ পাছত যি ভস্ম বাকি থাকে, তাক গুচাই বেদীৰ দাঁতিত থব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","পাছত তেওঁ নিজৰ সেই বস্ত্ৰ পিন্ধিব আৰু ছাউনিৰ বাহিৰৰ কোনো শুচি ঠাইলৈ সেই ভস্ম লৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","আৰু বেদীৰ ওপৰত জুই তাত সদায় জ্বলি থাকিব, নুনুমাব; পুৰোহিতে প্ৰতি ৰাতিপুৱা তাৰ ওপৰত কাঠ দি জুই জ্বলাব, আৰু তাৰ ওপৰত হোম-বলি সজাই দিব, আৰু মঙ্গলাৰ্থক বলিৰ তেলখিনি তাৰ ওপৰত দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","বেদীৰ ওপৰত অগ্নি সদায় জ্বলি থাকিব। ই কেতিয়াও নুমাই নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","শস্য উৎসৰ্গ কৰাৰ নিয়ম এই। হাৰোণৰ পুত্ৰসকলে ইয়াক বেদীৰ আগত যিহোৱাৰ সন্মুখত উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","পাছত পুৰোহিতে ভক্ষ্য নৈবেদ্যৰ পৰা এমুঠি মিহি আটাগুড়ি আৰু সেই তেল লৈ নৈবেদ্যৰ ওপৰত থকা আটাইখিনি ধূপ-ধূনা লৈ, তাৰ স্মৰণাৰ্থক অংশ বুলি সুঘ্ৰাণৰ অৰ্থে যিহোৱাৰ উদ্দেশ্যে বেদীত দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ইয়াৰ অৱশিষ্ট ভাগ হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে ভোজন কৰিব; খমীৰ নিদিয়াকৈ কোনো পবিত্ৰ ঠাইত সেই ভাগ ভোজন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","খমীৰেৰে সৈতে তাক তন্দুৰত তাও দিয়া নহ’ব। মই নিজ অগ্নিকৃত উপহাৰৰ পৰা তেওঁলোকৰ পাবলগীয়া ভাগ বুলি তাক দিলোঁ; পাপাৰ্থক বলি আৰু দোষাৰ্থক বলিৰ দৰে সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","হাৰোণৰ সন্তান সকলৰ মাজত যি কোনো পুৰুষে তাক ভোজন কৰিব পাৰিব; যিহোৱাৰ অগ্নিকৃত উপহাৰৰ পৰা এয়ে পুৰুষানুক্ৰমে চিৰকাল তোমালোকৰ অধিকাৰ হ’ব। যিকোনোৱে ইয়াক স্পৰ্শ কৰিব, তেৱোঁ পবিত্ৰ হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","পাছত যিহোৱাই মোচিক পুনৰ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“হাৰোণ অভিষিক্ত হোৱা দিনা তেওঁ আৰু তেওঁৰ পুত্ৰসকলে যিহোৱাৰ উদ্দেশ্যে যি উপহাৰ উৎসৰ্গ কৰিব, সেয়ে এই; তেওঁলোকে নিত্য ভক্ষ্য নৈবেদ্যৰ অৰ্থে, ঐফাৰ দহভাগৰ এভাগ মিহি আটাগুড়ি লৈ ৰাতিপুৱা আধা আৰু গধূলি আধা উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","তাক তেলেৰে তাৱাত যুগুত কৰিব লাগিব; সেয়ে ভাজা হ’লে তাক তুমি ভিতৰলৈ আনিবা; তুমি যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে, সেই ভক্ষ্য নৈবেদ্যৰ সিজোৱা খণ্ডবোৰ উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","পাছত হাৰোণৰ পুত্ৰসকলৰ মাজৰ যি জন তেওঁৰ পদত অভিষিক্ত পুৰোহিত হ’ব, তেওঁ ইয়াক উৎসৰ্গ কৰিব। ইয়াক যিহোৱাৰ উদ্দেশ্যে সম্পূৰ্ণৰূপে দগ্ধ কৰা হ’ব; এয়ে চিৰস্থায়ী বিধি। ");
INSERT INTO asmfb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","পুৰোহিতে দিয়া প্ৰত্যেক ভক্ষ্য নৈবেদ্য সম্পূৰ্ণৰূপে দগ্ধ কৰিব লাগিব, তাৰ একোকে খাব নালাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“তুমি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক কোৱা, ‘পাপাৰ্থক বলিদানৰ নিয়ম এই: যি ঠাইত হোমবলি কটা হ’ব, সেই ঠাইতে যিহোৱাৰ সন্মূখত পাপাৰ্থক বলিও কটা হ’ব; সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","যি পুৰোহিতে পাপৰ অৰ্থে তাক উৎসৰ্গ কৰিব, তেৱেঁই তাক ভোজন কৰিব; সাক্ষাৎ কৰা তম্বুৰ চোতালত কোনো পবিত্ৰ ঠাইত তাক ভোজন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","যিকোনোৱে তাৰ মাংস স্পৰ্শ কৰিব, তেওঁ পবিত্ৰ হ’ব; আৰু যদি তাৰ তেজৰ কিছু কোনো বস্ত্ৰত ছিতা লাগে, তেন্তে তুমি সেই তেজ লগা বস্ত্ৰ কোনো পবিত্ৰ ঠাইত ধুবা। ");
INSERT INTO asmfb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","কিন্তু যি মাটিৰ পাত্ৰত তাক সিজোৱা হ’ব, তাক ভাঙি পেলাব লাগিব; যদি পিতলৰ পাত্ৰত তাক সিজোৱা হয়, তেন্তে তাক ভালদৰে মাজি পানীত ধুই পৰিষ্কাৰ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","পুৰোহিতসকলৰ মাজৰ যিকোনো পুৰুষে ইয়াক ভোজন কৰিব পাৰিব; সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","আৰু পবিত্ৰ স্থানত প্ৰায়শ্চিত্ত কৰিবৰ বাবে যি পাপাৰ্থক বলিৰ তেজ সাক্ষাৎ কৰা তম্বুৰ ভিতৰলৈ অনা হ’ব, সেই বলিৰ অলপো ভোজন কৰা নহব; তাক জুইত পুৰি পেলোৱা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","এয়া দোষাৰ্থক বলিদানৰ নিয়ম:ই অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","‘যি ঠাইত হোম-বলি কটা হ’ব, সেই ঠাইতে দোষাৰ্থক বলিও কটা হ’ব; আৰু পুৰোহিতে বেদীৰ চাৰিওকাষে তাৰ তেজ ছটিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","তেওঁ তাৰ সকলো তেল উৎসৰ্গ কৰিব: চৰ্বিযুক্ত নেজ, ভিতৰভাগৰ নাড়ী-ভুৰুৰ তেল, ");
INSERT INTO asmfb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ঘিলা দুটা আৰু কিনাৰত লাগি থকা তাৰ ওপৰৰ তেল আৰু কলিজাৰ ওচৰত থকা তাৰ তেলীয়া ভাগ উৎসৰ্গ কৰিব; আৰু সেই ভাগ ঘিলালৈকে এৰুৱাই ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","পাছত পুৰোহিতে সেই সকলোকে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে বেদীৰ ওপৰত দগ্ধ কৰিব; সেয়ে দোষাৰ্থক বলি। ");
INSERT INTO asmfb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","পুৰোহিতসকলৰ মাজৰ যিকোনো পুৰুষে তাক ভোজন কৰিব পাৰিব আৰু কোনো পবিত্ৰ ঠাইত তাক ভোজন কৰিব লাগিব; সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","পাপাৰ্থক বলি যেনে, দোষাৰ্থক বলিও তেনে। আৰু দুয়োৰো নিয়ম-নীতি একে। যি পুৰোহিতে তাৰ দ্বাৰাই প্ৰায়শ্চিত্ত কৰিব সেয়ে তেওঁৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","আৰু যি পুৰোহিতে কোনো হোম-বলি উৎসৰ্গ কৰিব, নিজে উৎসৰ্গ কৰা সেই হোম বলিৰ ছাল তেওঁৰ নিজৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","আৰু তন্দুৰত তাও দিয়া প্ৰত্যেক ভক্ষ্য নৈবেদ্য আৰু কেৰাহীত ভজা, বা তাৱাত তাও দিয়া সকলো বস্তু উৎসৰ্গকাৰী পুৰোহিতৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","তেল মিহলোৱা বা শুকান প্ৰত্যেক ভক্ষ্য নৈবেদ্য হাৰোণৰ পুত্ৰসকলে সমানে পাব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰা মঙ্গলাৰ্থক বলিৰ নিয়ম এই। ");
INSERT INTO asmfb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","যদি কোনোৱে ধন্যবাদাৰ্থক বলি উৎসৰ্গ কৰে, তেনেহলে তেওঁ বলিৰ সৈতে, তেল মিহলোৱা খমীৰ নিদিয়া বিন্ধা থকা কেইটামান পিঠা, তেল নিদিয়া খমীৰ কেইটামান পাতল চকলীয়া পিঠা আৰু তেলত ভজা মিহি আটাগুড়িৰে কৰা তেল মিহলোৱা বিন্ধা থকা কেইটামান পিঠা উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ধন্যবাদ দিয়াৰ উদ্দেশ্যে নিজ মঙ্গলাৰ্থক বলিৰে সৈতে খমীৰ দিয়া বিন্ধা থকা কেইটামান পিঠাও উপহাৰ স্বৰূপে উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","আৰু তেওঁ প্ৰত্যেক উপহাৰৰ পৰা এটা এটা পিঠা লৈ, উত্তোলনীয় উপহাৰ স্বৰূপে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিব; যি পুৰোহিতে মঙ্গলাৰ্থক বলিৰ তেজ ছটিয়াব; তেওঁৱেই তাক পাব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ধন্যবাদ দিয়াৰ উদ্দেশ্যে দিয়া মঙ্গলাৰ্থক বলিৰ মাংসৰ উপহাৰ উৎসৰ্গ কৰাৰ দিনাখনে ভোজন কৰিব লাগিব; তাৰ অলপো ৰাতিপুৱালৈ ৰাখিব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","কিন্তু তেওঁ উৎসৰ্গ কৰা বলি যদি সংকল্প কৰা বা নিজৰ ইচ্ছামতে এনেই দিয়া উপহাৰ হয়; তেন্তে বলি উৎসৰ্গ কৰা দিনাই তাক ভোজন কৰিব লাগিব; আৰু পাছ দিনাও তাৰ অৱশিষ্ট ভাগ ভোজন কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","কিন্তু তৃতীয় দিনা বলিৰ অৱশিষ্ট মাংস জুইত পুৰি ভস্ম কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","যদি তৃতীয় দিনাও সেই মঙ্গলাৰ্থক বলিৰ অলপ মাংস ভোজন কৰে, তেন্তে সেই বলি গ্ৰহন নহব আৰু সেই বলি উৎসৰ্গকাৰীৰ পক্ষে গণিত নহব; সেয়ে ঘিণলগীয়া হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","যদি কোনো মঙহ অশুচি বস্তুৰ লগত স্পৰ্শ হয়, তেনেহলে সেই মঙহ খাব পৰা নহ’ব। সেয়া জুইত পুৰি ভস্ম কৰা হ’ব। আন মঙহ হ’লে, প্ৰত্যেক শুচি মানুহে খাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","যি কোনোৱে অশুচি হৈ থাকি যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰা মঙ্গলাৰ্থক বলিৰ মাংস ভোজন কৰিব, সেই মানুহক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","কোনোৱে যদি কোনো অশুচি দ্ৰব্য- মানুহৰ অশৌচ বা অশুচি পশু বা কোনো অশুচি ঘিণলগীয়া বস্তু চুই, যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰা মঙ্গলাৰ্থক বলিৰ মাংস ভোজন কৰে, তেন্তে সেই মানুহক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘তোমালোকে গৰুৰ, কি মেৰৰ, কি ছাগলীৰ তেল নাখাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","আৰু নিজে-নিজেই মৰা বা জন্তুৰ দ্বাৰাই চিৰা পশুৰ তেল কোনো কামত লগাব পাৰা, কিন্তু তাক তোমালোকে কোনোমতে নাখাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","কিয়নো যিকোনো পশুৰ পৰা যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰা যায়, সেই পশুৰ তেল যি কোনোৱে খাব, সেই খোৱা জনক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","আৰু তোমালোকে বাস কৰা কোনো ঠাইত, পক্ষীৰে হওঁক বা পশুৰেই হওঁক, তোমালোকে একোৰেই তেজ নাখাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","যি কোনোৱে কোনো ধৰণৰ তেজ খাব, সেই মানুহক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘যি জনে যিহোৱাৰ উদ্দেশ্যে নিজৰ মঙ্গলাৰ্থক বলি উৎসৰ্গ কৰিব, সেই জনে নিজৰ মঙ্গলাৰ্থক বলিৰ পৰা যিহোৱাৰ উদ্দেশ্যে নিজ উপহাৰ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","তেওঁ নিজ হাতে যিহোৱাৰ অগ্নিকৃত উপহাৰ আনিব। দোলনীয় নৈবেদ্য স্বৰূপে বলিৰ আমঠু যিহোৱাৰ সন্মূখত দোলোৱা হবলৈ, আমঠুৱে সৈতে তেওঁ তেলখিনি আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","আৰু পুৰোহিতে সেই তেল বেদীৰ ওপৰত দগ্ধ কৰিব; কিন্তু আমঠুটো হাৰোণৰ আৰু তেওঁ পুত্ৰসকলৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","আৰু তোমালোকে নিজ নিজ মঙ্গলাৰ্থক বলিৰ সোঁ কৰঙন অংশটো উত্তোলনীয় উপহাৰৰ অৰ্থে পুৰোহিতক দিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","হাৰোণৰ পুত্ৰসকলৰ মাজৰ যি জনে মঙ্গলাৰ্থক বলিৰ তেজ আৰু তেল উৎসৰ্গ কৰিব, তেওঁ নিজৰ অঙ্গ স্বৰূপে সেই সোঁ কৰঙনটো পাব। ");
INSERT INTO asmfb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ইস্ৰায়েলৰ সন্তান সকলৰ পৰা মই তেওঁলোকৰ প্ৰত্যেক মঙ্গলাৰ্থক বলিৰ দোলনীয় উপহাৰ যি আমঠু আৰু উত্তোলনীয় উপহাৰ যি সোঁ পাছ-পিৰা, তাক লৈ ইস্ৰায়েলৰ সন্তান সকলে দিবলগীয়া বুলি চিৰস্থায়ী অধিকাৰ স্বৰূপে হাৰোণ পুৰোহিত আৰু তেওঁৰ পুত্ৰসকলক দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","যিদিনা তেওঁ হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক যিহোৱাৰ পুৰোহিত কৰ্মৰ বাবে উপস্থিত কৰিলে, সেই দিনা যিহোৱাৰ অগ্নিকৃত উপহাৰৰ পৰা সেইয়াই তেওঁলোকে পাবলগীয়া ভাগ। ");
INSERT INTO asmfb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","তেওঁ তেওঁলোকক অভিষেক কৰা দিনা পুৰুষানুক্ৰমে ইস্ৰায়েলৰ সন্তান সকলে দিবলগীয়া বুলি চিৰস্থায়ী অধিকাৰ স্বৰূপে তাক তেওঁলোকক দিবলৈ যিহোৱাই আজ্ঞা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","এইবোৰেই হোম-বলিৰ, ভক্ষ্য নৈবেদ্যৰ, পাপাৰ্থক বলিৰ, দোষাৰ্থক বলিৰ, নিযুক্তকৰণাৰ্থক বলিৰ আৰু মঙ্গলাৰ্থক বলিৰ নিয়ম।” ");
INSERT INTO asmfb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","যিহোৱাই যিদিনা চীনয় অৰণ্যত ইস্ৰায়েলৰ সন্তান সকলক যিহোৱাৰ উদ্দেশ্যে নিজ নিজ উপহাৰৰ উৎসৰ্গ কৰিবলৈ আজ্ঞা কৰিলে সেই দিনা তেওঁ চীনয় পৰ্ব্বতত মোচিক এইবোৰৰ বিষয়ে আজ্ঞা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“তুমি হাৰোণক আৰু তেওঁৰ লগত তেওঁৰ পুত্ৰসকলক, লগত বস্ত্ৰবোৰ, অভিষেকাৰ্থক তেল, পাপাৰ্থক বলিদানৰ দমৰা গৰুটো, মতা মেৰ দুটা আৰু খমীৰ নিদিয়া পিঠাৰ খৰাহিটো লোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","আৰু সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত গোটেই সমাজক গোটোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","সেয়ে মোচিয়ে যিহোৱাৰ আজ্ঞাৰ দৰে কৰিলে আৰু সাক্ষাৎ কৰা তম্বুৰ দুৱাৰমুখত সমাজ গোট খালে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","তেতিয়া মোচিয়ে গোট খোৱা সমাজখনক ক’লে, “যিহোৱাই এই কৰ্ম কৰিবলৈ আজ্ঞা কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","এইদৰে মোচিয়ে হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক ওচৰলৈ আনি পানীৰে গা ধুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","তেওঁ হাৰোণক অঙ্গৰক্ষক বস্ত্ৰখন পিন্ধালে আৰু টঙালি বন্ধা চোলাটো পিন্ধালে আৰু এফোদ পিন্ধাই, এফোদত নিপুণ ৰূপে বোৱা টঙালি কাপোৰ কঁকালত মেৰাই তাৰে সৈতে এফোদ বান্ধিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","তেওঁৰ বুকুত বুকুপতা দিলে আৰু বুকুপতাত পুৰীম আৰু তুস্মীম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","আৰু তেওঁৰ মূৰত পাগুৰি পিন্ধালে, আৰু পাগুৰিটোৰ ওপৰত আগফালে পবিত্ৰ মুকুটস্বৰূপ সোণৰ পচাখন লগাই দিলে। যিহোৱাই দিয়া আজ্ঞাৰ দৰেই মোচিয়ে এই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","মোচিয়ে অভিষেকাৰ্থক তেল লৈ, আবাস আৰু তাৰ সকলোকে অভিষেক কৰি পবিত্ৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","তাৰ পৰা অলপ তেল লৈ যজ্ঞবেদীৰ ওপৰত সাতবাৰ ছটিয়ালে আৰু বেদী আৰু তাৰ সকলো সজুলি, প্ৰক্ষালন-পাত্ৰ আৰু তাৰ খুৰা পবিত্ৰ কৰিবৰ অৰ্থে অভিষেক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","তেওঁ অভিষেকাৰ্থক তেলৰ কিছু লৈ, হাৰোণৰ মুৰত ঢালি দিলে আৰু তেওঁক পবিত্ৰ কৰিবৰ অৰ্থে অভিষেক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","মোচিয়ে হাৰোণৰ পুত্ৰসকলক আগলৈ আনি তেওঁলোককো অঙ্গৰক্ষক বস্ত্ৰ পিন্ধাই, কঁকালত টঙালি বান্ধি মুৰত পাগুৰি মাৰি দিলে। যিহোৱাই দিয়া আজ্ঞাৰ দৰেই মোচিয়ে এই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","তেতিয়া মোচিয়ে পাপাৰ্থক বলিদানৰ বাবে অনা দমৰা গৰুটো লৈ অহাৰ পাছত, হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে সেই পাপাৰ্থক গৰুটোৰ মূৰত হাত দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","তেওঁ তাক কাটিলে আৰু মোচিয়ে তাৰ কিছু তেজ লৈ, আঙুলিৰে বেদীৰ চাৰিওফালৰ শিঙত লগাই বেদীটো পাপৰ পৰা মুক্ত কৰিলে; আৰু বাকী তেজখিনি লৈ, বেদীৰ মূৰত ঢালি দিলে আৰু তাক প্ৰায়চিত্ত কৰি পবিত্ৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","পাছত নাড়ী-ভুৰু লাগি থকা আটাই তেল আৰু কলিজাৰ ওচৰত থকা, তেলীয়া ভাগ, ঘিলা দুটা আৰু তাৰ তেল আতৰোৱাৰ পাছত, মোচিয়ে সেইবোৰ বেদীত দগ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","কিন্তু গৰুটো, ইয়াৰ ছাল, মাংস আৰু গোবৰেৰে সৈতে ছাউনিৰ বাহিৰত জুইত পুৰি ভস্ম কৰা হ’ল। যিহোৱাই দিয়া আজ্ঞাৰ দৰেই মোচিয়ে এই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","পাছত মোচিয়ে আন এটা মতা মেৰ হোমবলিৰ বাবে লৈ আহিল; হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে মেৰৰ মূৰত হাত দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","তেওঁ তাক কাটিলে আৰু বেদীৰ চাৰিওঁফালে তাৰ তেজ ছটিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","মোচিয়ে মেৰটো খণ্ড খণ্ড কৰি কাটিলে, আৰু তাৰ মূৰ, আন খণ্ডবোৰ আৰু তেল জুইত পুৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","তেওঁ মেৰটোৰ ভিতৰ অংশৰ নাড়ী-ভুৰু আৰু ঠেংকেইখন পানীত ধুলে, আৰু সম্পূৰ্ণ মেৰটো বেদীত পুৰিলে। এয়ে হোম-বলি, সুঘ্ৰাণৰ অৰ্থে যিহোৱাৰ উদ্দেশ্যে দিয়া অগ্নিকৃত উপহাৰ। যিহোৱাই দিয়া আজ্ঞাৰ দৰেই মোচিয়ে এই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","তাৰ পাছত মোচিয়ে দ্বিতীয় মতা মেৰটো আনিলে, এইটো অভিষেকৰ মেৰ; হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে সেই মেৰৰ মূৰত হাত দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","হাৰোণে এইটো কটাৰ পাছত, মোচিয়ে ইয়াৰ অলপ তেজলৈ, হাৰোণৰ সোঁ কাণত, মূৰত, সোঁ হাতৰ বুঢ়া আঙুলিত আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিটোত লগাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","পাছত তেওঁ হাৰোণৰ পুত্ৰসকলক নিজৰ ওচৰলৈ আনিলে আৰু তেওঁ সেই তেজৰ অলপমান তেওঁলোকৰো সোঁ কাণত, সোঁ হাতৰ বুঢ়া আঙুলিত আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিত লগাই দিলে। তাৰ পাছত অৱশিষ্ট তেজখিনি বেদীৰ চাৰিওফালে ছটিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","পাছত তেওঁ তেল খিনি, নেজডাল, নাড়ী-ভুৰুত লাগি থকা আটাই তেল, কলিজা আৰু কলিজাৰ ওচৰত থকা তেলীয়া ভাগ, ঘিলা দুটাৰ সৈতে তাৰ তেল আৰু পাছফালৰ সোঁ কৰঙনটো ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","আৰু যিহোৱাৰ সন্মূখত থকা খমীৰ নিদিয়া পিঠা, খৰাহিৰ পৰা এটা খমীৰ নিদিয়া বিন্ধা থকা পিঠা আৰু এটা পাতল চকলীয়া পিঠা লৈ, সেই তেল আৰু সোঁ কৰঙনটোৰ ওপৰত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","আৰু হাৰোণ ও তেওঁৰ পুৰোহিতসকলৰ হাতত সেই সকলোকে দি, যিহোৱাৰ সন্মূখত দোলনীয় নৈবেদ্যৰ অৰ্থে দোলালে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","তেতিয়া মোচিয়ে, তেওঁলোকৰ হাতৰ পৰা সেইবোৰ লৈ, বেদীত হোম-বলিৰ ওপৰত দগ্ধ কৰিলে; এয়ে সুঘ্ৰাণৰ অৰ্থে দিয়া অভিষেকৰ নৈবেদ্য। এয়ে যিহোৱাৰ উদ্দেশ্যে দিয়া অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","পাছত তেওঁ আমঠুটো লৈ যিহোৱাৰ সন্মূখত দোলনীয় নৈবেদ্যৰ অৰ্থে দোলালে; অভিষেকৰ মেৰৰ এই আমঠুটো মোচিৰ ভাগ হ’ল। যিহোৱাই দিয়া আজ্ঞাৰ দৰে মোচিয়ে এই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","পাছত মোচিয়ে অভিষেকাৰ্থক তেলৰ পৰা আৰু বেদীৰ ওপৰত থকা তেজৰো পৰা কিছু লৈ, হাৰোণৰ ওপৰত আৰু তেওঁৰ বস্ত্ৰৰ ওপৰত, তেওঁৰে সৈতে তেওঁৰ পুত্ৰসকলৰ ওপৰত আৰু তেওঁলোকৰ বস্ত্ৰৰ ওপৰতো ছটিয়াই দি, হাৰোণক আৰু তেওঁৰ বস্ত্ৰবোৰ আৰু তেওঁৰে সৈতে তেওঁ পুত্ৰসকলক আৰু তেওঁলোকৰ বস্ত্ৰবোৰ পবিত্ৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","সেয়ে মোচিয়ে হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক ক’লে, “সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত তোমালোকে মঙহখিনি সিজাবা; আৰু ‘হাৰোণ ও তেওঁৰ পুত্ৰসকলে তাক ভোজন কৰিব লাগে’, এইবুলি কোৱা মোৰ আজ্ঞাৰ দৰে তোমালোকে সেই ঠাইত তাক আৰু নিযুক্ত কৰণাৰ্থক খৰাহিত থকা পিঠা ভোজন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","যিবোৰ বাকী থকা মাংস আৰু পিঠা ৰৈ যাব, সেইবোৰ জুইত পুৰি ভস্ম কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","আৰু তোমালোকে সাত দিনলৈকে, অৰ্থাৎ তোমালোকক নিযুক্ত কৰা দিন শেষ নোহোৱালৈকে, সাক্ষাৎ কৰা তম্বু দুৱাৰৰ পৰা বাহিৰলৈ নাযাবা। কাৰণ তোমালোকক নিযুক্ত কৰোঁতে সাতদিন লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","আজি যেনেকৈ কৰা গ’ল, তোমালোকক প্ৰায়চিত্ত কৰিবৰ অৰ্থে তেনেকৈ কৰিবলৈ যিহোৱাই আজ্ঞা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","এই হেতুকে তোমালোকে মৰা নপৰিবৰ বাবে, সাত দিনলৈকে দিনে ৰাতিয়ে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত থাকি পাৰ্য্যমানে যিহোৱাৰ পালনীয়খিনি পালন কৰিবা, কিয়নো মই এনে আজ্ঞা পালোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","যিহোৱাই মোচিৰ দ্বাৰাই যি সকলো কৰিবলৈ আজ্ঞা দিছিল, হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে সেই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","অষ্টম দিনৰ আনুষ্ঠানিকৰ পাছত মোচিয়ে হাৰোণ আৰু তেওঁৰ পুত্ৰসকল আৰু ইস্ৰায়েলৰ পৰিচাৰক সকলক মাতি আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","তেওঁ হাৰোণক ক’লে, “তুমি নিজৰ অৰ্থে, পাপাৰ্থক বলিৰ কাৰণে জাকৰ পৰা এটা নিঘূণ দামুৰি আৰু হোম-বলিৰ কাৰণে এটা নিৰ্ঘূণী মতা মেৰ লৈ, যিহোৱাৰ সন্মুখত উৎসৰ্গ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","আৰু ইস্ৰায়েলৰ সন্তান সকলক তুমি নিশ্চয় কোৱা, ‘তোমালোকে যিহোৱাৰ সন্মূখত বলিদান কৰিবৰ অৰ্থে, পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী আৰু হোমৰ কাৰণে এটা এবছৰীয়া নিঘূণ দমৰা গৰু আৰু এটা এবছৰীয়া নিঘূণ মেৰ পোৱালি, ");
INSERT INTO asmfb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","আৰু মঙ্গলাৰ্থক বলিৰ কাৰণে এটা ষাঁড় আৰু এটা মতা মেৰ আৰু তেল মিহলোৱা ভক্ষ্য নৈবেদ্য লোৱা; কিয়নো আজি যিহোৱাই তোমালোকক দৰ্শন দিব’।” ");
INSERT INTO asmfb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","তেতিয়া তেওঁলোকে, মোচিয়ে আজ্ঞা কৰা সকলোকে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখলৈ নিলে আৰু গোটেই মণ্ডলী ওচৰ চাপি যিহোৱাৰ সন্মূখত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","পাছত মোচিয়ে ক’লে, “যিহোৱাই তোমালোকক এই কৰ্ম কৰিবলৈ আজ্ঞা কৰিলে; ইয়াকে কৰিলে তোমালোকলৈ যিহোৱাৰ প্ৰতাপ প্ৰকাশিত হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","পাছত মোচিয়ে হাৰোণক ক’লে, “তুমি বেদীৰ ওচৰলৈ গৈ, যিহোৱাৰ আজ্ঞা অনুসাৰে তোমাৰ পাপাৰ্থক বলি আৰু হোম-বলি উৎসৰ্গ কৰি, নিজক আৰু লোকসকলক প্ৰায়শ্চিত্ত কৰা; আৰু লোকসকলৰো উপহাৰ উৎসৰ্গ কৰি, তেওঁলোককো প্ৰায়শ্চিত্ত কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","তেতিয়া হাৰোণে বেদীৰ ওচৰলৈ গৈ, নিজৰ অৰ্থে লোৱা পাপাৰ্থক বলিদানৰ দামুৰীটো কাটিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","পাছত হাৰোণৰ পুত্ৰসকলে সেই বলিৰ তেজ তেওঁৰ ওচৰলৈ আনিলে; আৰু তেওঁ নিজ আঙুলি তেজত জুবুৰিয়াই বেদীৰ শিঙত লগালে, পাছত অৱশিষ্ট তেজখিনি বেদীৰ মুলত ঢালি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","কিন্তু পাপাৰ্থক বলিৰ তেল, ঘিলা দুটা আৰু কলিজাৰ ওচৰত থকা তেলীয়া ভাগ বেদীত দগ্ধ কৰিলে। যিহোৱাই দিয়া আজ্ঞাৰ দৰেই মোচিয়ে এই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","আৰু তাৰ মঙহখিনি আৰু ছালখন ছাউনিৰ বাহিৰত জুইত পুৰি ভস্ম কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","পাছে হোম-বলিটো কটা হ’ল, আৰু হাৰোণৰ পুত্ৰসকলে তাৰ তেজখিনি তেওঁৰ ওচৰলৈ তেওঁ বেদীত চাৰিওফালে ছটিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","পাছত তেওঁলোক হোম-বলিৰ মাংস খণ্ড খণ্ড কৰি মূৰটোৰে সৈতে খণ্ডবোৰ তেওঁৰ ওচৰলৈ আনিলে, আৰু তেওঁ সেই সকলোকে বেদীৰ ওপৰত দগ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","তেওঁ নাড়ী-ভুৰুখিনি আৰু ঠেং-কেইটা ধুই, বেদীত হোমৰ ওপৰত দগ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","পাছত লোকসকলৰ উপহাৰ ওচৰলৈ নিয়া হ’ল। তেওঁ লোকসকলৰ পাপাৰ্থক বলিদানৰ ছাগলীটো লৈ, প্ৰথমটোৰ নিচিনাকৈ কাটি পাপৰ অৰ্থে উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","আৰু হোম-বলিটোও নিয়া হ’ল আৰু তেওঁ বিধিমতে তাক উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","আৰু ভক্ষ্য নৈবেদ্য নিয়াৰ পাছত তেওঁ তাৰ পৰা মুঠি ভৰাই ল’লে, আৰু বেদীৰ ওপৰত দগ্ধ কৰিলে; ৰাতিপুৱাৰ হোম-বলিৰ দৰে তেওঁ ইয়াকো কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","পাছত তেওঁ লোকসকলৰ মঙ্গলাৰ্থক বলিদানৰ ষাঁড় আৰু মতা মেৰটো কাটিলে; তেতিয়া হাৰোণৰ পুত্ৰসকলে তেওঁৰ ওচৰলৈ সেই বলিৰ তেজ আনিলে, আৰু তেওঁ বেদীৰ চাৰিওকাষে তাক ছটিয়াই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","পাছত তেওঁলোকে ষাঁড় আৰু মতা মেৰটোৰ তেল, নাড়ী-ভুৰুত লাগি থকা তেল, ঘিলা দুটা আৰু কলিজাৰ ওচৰত থকা তেলীয়া ভাগ আৰু মেৰটোৰ নেজডাল ল’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","সেই সকলো তেল আমঠু দুটাৰ ওপৰত হ’ল; আৰু তেতিয়া তেওঁ বেদীৰ ওপৰত সেই তেল দগ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","আৰু মোচিৰ আজ্ঞা অনুসাৰে, হাৰোণে যিহোৱাৰ সন্মূখত আমঠু দুটা আৰু সোঁ কৰঙনটো দোলনীয় উপহাৰৰ অৰ্থে দোলালে। ");
INSERT INTO asmfb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","তেতিয়া হাৰোণে তেওঁলোকৰ ফাললৈ হাত দাঙি তেওঁলোকক আশীৰ্ব্বাদ কৰিলে; এইদৰে তেওঁ পাপাৰ্থক বলি, হোম-বলি আৰু মঙ্গলাৰ্থক বলি উৎসৰ্গ কৰি নামি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","পাছত মোচি আৰু হাৰোণ সাক্ষাৎ কৰা তম্বুৰ ভিতৰত সোমাল আৰু তেওঁলোকে বাহিৰ ওলাই লোকসকলক আশীৰ্ব্বাদ কৰিলে; তেতিয়া সকলো লোকসকলৰ আগত যিহোৱাৰ প্ৰতাপ প্ৰকাশিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","আৰু যিহোৱাৰ সন্মূখৰ পৰা অগ্নি ওলাই, বেদীৰ ওপৰত থকা হোম-বলি আৰু তেলখিনি পুৰি ভস্ম কৰিলে। তাকে দেখি সকলো লোকে আনন্দ-ধ্বনি কৰি উবুৰি হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","পাছত হাৰোণৰ পুত্ৰ নাদব আৰু অবীহূৱে নিজ নিজ আঙঠা ধৰা লৈ, তাত জুই ৰাখি তাৰ ওপৰত ধূঁপ দি, যিহোৱাই আজ্ঞা নিদিয়া সাধাৰণ জুই যিহোৱাৰ সন্মুখত উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","তেতিয়া যিহোৱাৰ সন্মুখৰ পৰা অগ্নি ওলাই তেওঁলোকক গ্ৰাস কৰিলে; তেওঁলোকে যিহোৱাৰ সন্মূখত প্ৰাণত্যাগ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","তেতিয়া মোচিয়ে হাৰোণক ক’লে, “যিহোৱাই ইয়াকে কৈছিল, বোলে, ‘যি সকলে মোৰ কাষ চাপিব, তেওঁলোকৰ মাজত মোৰ পবিত্ৰতা প্রকাশ কৰিম। আৰু সকলো লোকৰ সাক্ষাতে মই গৌৰৱান্বিত হ’ম।” হাৰোণ হতভম্ব হৈ নিজমে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","মোচিয়ে হাৰোণৰ দদায়েক উজ্জীয়েলৰ পুত্ৰ মিচায়েল আৰু ইলিচাফনক মাতি নি ক’লে, “ইয়ালৈ আহাঁ আৰু ওচৰলৈ গৈ তোমালোকৰ জ্ঞাতি দুজনক তুলি পবিত্ৰ স্থানৰ সন্মূখৰ পৰা ছাউনিৰ বাহিৰলৈ লৈ যোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","আৰু সেয়ে তেওঁলোকে মোচিৰ আজ্ঞা অনুসাৰে, ওচৰলৈ গৈ, অঙ্গৰক্ষক বস্ত্ৰে সৈতে তেওঁলোকক তুলি ছাউনিৰ বাহিৰলৈ লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","তেতিয়া মোচিয়ে হাৰোণক আৰু তেওঁৰ পুত্ৰ ইলিয়াজৰ আৰু ঈথামৰক ক’লে, “তোমালোক যেন নমৰা আৰু গোটেই মণ্ডলীলৈ যেন তেওঁৰ ক্ৰোধ প্ৰজ্বলিত নহয়, এই কাৰণে তোমালোকে নিজ নিজ মূৰৰ চুলি মুকলিকৈ নাৰাখিবা আৰু নিজ নিজ কাপোৰ নাফালিবা; কিন্তু যিহোৱাৰ ক্ৰোধাগ্নি জ্বলাৰ বাবে তোমালোকৰ ভাই গোটেই ইস্ৰায়েল বংশই ক্ৰন্দন কৰক। ");
INSERT INTO asmfb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","আৰু এই সাক্ষাৎ কৰা তম্বুৰ দুৱাৰৰ পৰা বাহিৰলৈ নাযাবা, নহ’লে মৰিবা, কিয়নো তোমালোকৰ গাত যিহোৱাৰ অভিষেকাৰ্থক তেল আছে।” তেতিয়া তেওঁলোকে মোচিৰ বাক্য অনুসাৰে সেই দৰে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","তেতিয়া যিহোৱাই হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“তোমালোক যেন নমৰা, সেই কাৰণে তুমি বা তোমাৰে সৈতে তোমাৰ পুত্ৰসকলে সাক্ষাৎ কৰা তম্বুত সোমোৱা কালত, দ্ৰাক্ষাৰস বা সুৰা পান নকৰিবা। এয়ে তোমালোকে পুৰুষানুক্ৰমে পালন কৰিবলগীয়া চিৰস্থায়ী বিধি, ");
INSERT INTO asmfb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","আৰু তোমালোকে যেন পবিত্ৰ আৰু সামান্য বিষয়ৰ আৰু শুচি আৰু অশুচিৰ প্ৰভেদ কৰিব পাৰিবা, ");
INSERT INTO asmfb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","আৰু মোচিৰ দ্বাৰাই যিহোৱাই ইস্ৰায়েলৰ সন্তান সকলক দিয়া সকলো বিধিৰ শিক্ষা তোমালোকে যেন তেওঁলোকক দিব পাৰিবা, সেই বাবে এই বিধি তোমোলোকক দিয়া হ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","মোচিয়ে হাৰোণক আৰু তেওঁৰ অৱশিষ্ট পুত্ৰ ইলিয়াজৰ আৰু ঈথামৰ এই দুজনক ক’লে, “যিহোৱাৰ অগ্নিকৃত উপহাৰবোৰৰ অৱশিষ্ট ভক্ষ্য নৈবেদ্য লৈ গৈ, বেদীৰ কাষত খমীৰ নোহোৱাকৈ ভোজন কৰিবা। কিয়নো সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","কোনো পবিত্ৰ ঠাইত তাক ভোজন কৰিবা; কিয়নো যিহোৱাৰ অগ্নিকৃত উপহাৰবোৰৰ মাজত সেয়ে তুমি আৰু তোমাৰ পুত্ৰসকলে পাবলগীয়া ভাগ, কাৰণ মই এই আজ্ঞা পালোঁ। ");
INSERT INTO asmfb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","আৰু দোলনীয় উপহাৰ যি সোঁ ফালৰ কৰঙনটো, তাক তুমি তোমাৰ পো-জীসকলেৰে সৈতে কোনো শুচি ঠাইত ভোজন কৰিবা। কিয়নো ইস্ৰায়েলৰ সন্তান সকলৰ মঙ্গলাৰ্থক বলিৰ পৰা তাক তোমাৰ আৰু তোমাৰ সন্তান সকলক পাবলগীয়া ভাগ বুলি দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","অগ্নিকৃত উপহাৰৰ অৰ্থে দিয়া তেলখিনিয়ে সৈতে উত্তোলনীয় উপহাৰ যি সোঁ কৰঙন আৰু যিহোৱাৰ সন্মূখত দোলনীয় উপহাৰৰ অৰ্থে দোলাবলৈ দোলনীয় উপহাৰৰ যি আমঠু, এইবোৰ যিহোৱাৰ আজ্ঞাৰ দৰে আনিব লাগিব; সেয়ে তোমাৰ আৰু তোমাৰ সন্তান সকলৰ চিৰস্থায়ী অধিকাৰ হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","তেতিয়া মোচিয়ে পুৰুষাৰ্থ কৰি, পাপাৰ্থক বলিদানৰ অৰ্থে দিয়া ছাগলীটো বিচাৰোতে দেখিলে যে, তাক পুৰি ভস্ম কৰা হ’ল। গতিকে তেওঁ হাৰোণৰ অৱশিষ্ট পুত্ৰ ইলিয়াজৰ আৰু ঈথামৰ এই দুজনলৈ ক্ৰুদ্ধ হৈ তেওঁলোকক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“তোমালোকে সেই পাপাৰ্থক বলি কোনো পবিত্ৰ স্থানত কিয় ভোজন নকৰিলা? কাৰণ সেয়ে অতি পবিত্ৰ আৰু মণ্ডলীৰ অপৰাধ বৈ যিহোৱাৰ সন্মূখত তেওঁলোকক প্ৰায়চিত্ত কৰিবৰ অৰ্থে তাক তোমালোকক দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","চোৱা, পবিত্ৰ স্থানৰ ভিতৰলৈ তাৰ তেজ নিয়া নহ’ল; মোৰ আজ্ঞা অনুসাৰে তোমালোকে অৱশ্যে তাক পবিত্ৰ স্থানত ভোজন কৰিব লাগিছিল।” ");
INSERT INTO asmfb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","তেতিয়া হাৰোণে মোচিক ক’লে, “চোৱা, এওঁলোক দুজনেই আজি যিহোৱাৰ উদ্দেশ্যে নিজ পাপাৰ্থক বলি আৰু নিজ হোমবলি উৎসৰ্গ কৰিলে, তথাপি মোলৈ এনে ঘটিল; যদি মই আজি পাপাৰ্থক বলি ভোজন কৰিলোঁহেতেন, তেন্তে যিহোৱাই তাত সন্তোষ পালেহেঁতেন নে?” ");
INSERT INTO asmfb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","মোচিয়ে ইয়াকে শুনি সন্তুষ্ট হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“তোমালোকে ইস্ৰায়েলৰ সন্তান সকলক কোৱা যে, ‘সকলো ভূ-চৰ পশুবোৰৰ মাজত এইবোৰ জন্তু তোমালোকে খাব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","পশুবোৰৰ মাজত যি কোনো জন্তুৰ খুৰা সম্পুৰ্ণৰূপে দুফাল আৰু ঘাঁহ পাগুলে তাক তোমালোকে খাব পাৰিবা ");
INSERT INTO asmfb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","তথাপি ঘাঁহ পাগুলা বা খুৰা দুফাল হোৱাবোৰৰ মাজত তোমালোকে কোনোমতে খাব নলগীয়া পশু এইবোৰ; উট, কিয়নো সি ঘাঁহ পাগুলে হয়, কিন্তু দুফলীয়া খুৰা থকা নহয়, সি তোমালোকৰ পক্ষে অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","আৰু চাফন পশু, কিয়নো সিও ঘাঁহ পাগুলে, তথাপি দুফলীয়া খুৰা থকা নহয়, সিওঁ তোমালোকৰ পক্ষে অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","শহা; কিয়নো সিও ঘাঁহ পাগুলে, কিন্তু দুফলীয়া খুৰা থকা নহয়, সি তোমালোকৰ পক্ষে অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","আৰু গাহৰি: কিয়নো তাৰ খুৰা সম্পুৰ্ণৰূপে দুফাল হয় তথাপি সি ঘাঁহ নাপাগুলে, তোমালোকৰ পক্ষে সিও অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","তোমালোকে সেইবোৰৰ মাংস ভোজন নকৰিবা আৰু সেইবোৰৰ শৱকো নুচুবা; সেইবোৰ তোমালোকৰ পক্ষে অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","জলজন্তুবোৰৰ মাজত সমুদ্ৰত কি নদীত বা আন পানীত থকা জন্তুৰ মাজত, পাখি আৰু বাকলি থকা জন্তু তোমালোকে খাব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","কিন্তু সমুদ্ৰত বা নদীত থকা জলচৰবোৰৰ মাজত বা পানীত থকা সকলো প্ৰাণীৰ মাজত, যিবোৰৰ পাখি আৰু বাকলি নাই, সেইবোৰ তোমালোকৰ পক্ষে ঘিণলগা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","সেইবোৰ তোমালোকৰ পক্ষে সদায় ঘিণলগা। তোমালোকে সেইবোৰৰ মাংস ভোজন নকৰিবা আৰু সেইবোৰৰ শৱকো ঘিণ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","জলন্তুবোৰৰ মাজত যিবোৰৰ পাখি আৰু বাকলি নাই, সেই সকলোৱেই তোমালোকৰ পক্ষে ঘিণলগা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","আৰু পক্ষীবোৰৰ মাজত এইবোৰ তোমালোকে ঘিণ কৰিবা আৰু এইবোৰ নাখাবা, ঈগল, শগুণ, ");
INSERT INTO asmfb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","মটিয়া চিলনী আৰু সকলো বিধৰ ৰঙা চিলনী; ");
INSERT INTO asmfb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","আৰু সকলো বিধৰ কাউৰী, ");
INSERT INTO asmfb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","বগা ফেচাঁ, লক্ষী ফেচাঁ, গঙ্গা-চিলনী আৰু সকলো বিধৰ শেন। ");
INSERT INTO asmfb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","তোমালোকে এইবোৰকো ঘিণ কৰিবা, যেনে - ফেঁচা, মাছৰোকা আৰু হুদু, ");
INSERT INTO asmfb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","দীঘল ডিঙীয়া হাঁহ, ঢোঁৰা কাউৰী আৰু সৰু শগুণ, ");
INSERT INTO asmfb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","বৰটোকোলা, সকলো বিধৰ বগলী, গোবৰ খোঁচোৰা আৰু বাদুলী। ");
INSERT INTO asmfb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","চাৰি ঠেঙেৰে উৰি ফুৰা সকলো পাখি থকা জন্তু তোমালোকৰ পক্ষে ঘিণলগা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","তথাপি পাখি থকা উৰি ফুৰা চাৰি ঠেঙেৰে ফুৰা জন্তুৰ মাজত, মাটিত ভৰ দি জাপ মাৰিবৰ বাবে যিবোৰৰ চাৰি ভৰিৰ ওপৰত দুটা ঠেং থাকে, সেইবোৰ খাব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","আৰু সকলো বিধৰ কাকতী ফৰিং, সকলো বিধৰ খগা ফৰিং, সকলো বিধৰ উই-চিৰিঙা আৰু সকলো বিধৰ তামুলী ফৰিং, এই সকলোকে তোমালোকে খাব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","কিন্তু উৰি ফুৰা সকলো চাৰি ঠেঙীয়া জন্তু তোমালোকৰ পক্ষে ঘিণ লগা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","তোমালোক এই জন্তুবোৰৰ দ্বাৰাই সন্ধিয়ালৈকে অশুচি হৈ পৰিবা, যদি কোনোৱে এইবোৰৰ শৱবোৰো স্পৰ্শ কৰে, তেৱোঁ অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","আৰু যিকোনোৱে সেইবোৰৰ শৱ লৈ যাব, সি নিজ কাপোৰ ধুব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","যিবোৰ জন্তুৰ খুৰা দুফাল হলেও সম্পুৰ্ণৰূপে দুফাল নহয় আৰু যি জন্তুৱে ঘাঁহ নাপাগুলে, সেইবোৰ তোমালোকৰ পক্ষে অশুচি। যিকোনোৱে সেইবোৰৰ শৱ চুব, তেওঁ অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","আৰু চাৰি ঠেঙেৰে ফুৰা সকলো জন্তুৰ মাজত যিবোৰ ভৰিৰ তলুৱাৰে খোজ কাঢ়ে, সেইবোৰ তোমালোকৰ পক্ষে অশুচি। যিকোনোৱে সেইবোৰৰ শৱ চুব, তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","আৰু যিকোনোৱে সেইবোৰৰ শৱ লৈ যাব, সি নিজ বস্ত্ৰ ধুব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। সেইবোৰেই তোমালোকৰ পক্ষে অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","মাটিত বগাই ফুৰা সকলো বিধৰ উৰগ জন্তুৰ মাজত এইবোৰ তোমালোকৰ পক্ষে অশুচি; নেউল, এন্দুৰ, ");
INSERT INTO asmfb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","সকলো বিধৰ গুঁই জেঠী, নাইপিয়া, তেজপিয়া, সোণগুঁই, আৰু মটিয়া গুঁই। ");
INSERT INTO asmfb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","বগাই ফুৰা জন্তুৰ জন্তুবোৰৰ ভিতৰত এইবোৰ তোমালোকৰ পক্ষে অশুচি; সেইবোৰ মৰিলে, যি কোনোৱে সেইবোৰৰ শৱ চুব, তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","আৰু সেইবোৰৰ মাজৰ কোনো শৱ যি বস্তুৰ ওপৰত পৰিব, সিও অশুচি হ’ব; কাঠৰ পাত্ৰ বা বস্ত্ৰ বা ছাল বা মোনা, যিকোনো কামত লগা বস্তুৱেই হওক, তাক পানীত জুবুৰিয়াব লাগিব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব আৰু তেতিয়াহে শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","আৰু কোনো মাটিৰ পাত্ৰৰ ভিতৰত সেইবোৰৰ শৱ পৰিলে, তাৰ ভিতৰত থকা সকলো বস্তু অশুচি হ’ব আৰু তোমালোকে তাক ভাঙি পেলাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","তাৰ ভিতৰত থকা পানী দি সিজোৱা সকলো খোৱা বস্তু অশুচি হ’ব আৰু তেনেকুৱা সকলো পাত্ৰত থকা সকলো প্ৰকাৰ পেয় দ্ৰব্য অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","আৰু এন্দুৰেই হওঁক বা চুলাই হওঁক, যিকোনো বস্তুৰ ওপৰত সেইবোৰৰ শৱ পৰিব, সেয়ে অশুচি হ’ব; তাক ভাঙি পেলাব লাগিব; সেইবোৰ অশুচি, তোমালোকৰ পক্ষে সেইবোৰ অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","তথাপি ভুমুক বা যি নাদত অনেক পানী জমা হৈ থাকে, সেয়ে শুচি হব; কিন্তু যি জনে সেইবোৰৰ মৰা শৱ চুব, তেওঁ অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","আৰু সেইবোৰৰ শৱ যদি কোনো ববলগীয়া গুটিত পৰে, তেন্তে সেয়ে শুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","কিন্তু গুটিৰ ওপৰত পানী দিলে, যদি সেইবোৰৰ শৱ তাৰ ওপৰত পৰে, তেন্তে সেয়ে তোমালোকৰ পক্ষে অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","তোমালোকে খাব পৰা পশুৰ মাজত কোনো পশু মৰিলে, যিকোনোৱে তাৰ শৱ চুব, সি সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","আৰু যিকোনোৱে তাৰ মাংস খাব, সি নিজৰ কাপোৰ ধুব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। আৰু যি কোনোৱে তাৰ শৱ লৈ যাব তেওঁ নিজ বস্ত্ৰ ধুব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","আৰু মাটিত বগাই ফুৰা প্ৰত্যেক উৰগ জন্তু ঘিণ লগা; তাক খাব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","মাটিত বগাই ফুৰা যিকোনো জীৱজন্তু পেটেৰে যায় বা চাৰি ঠেঙেৰে যায় বা যিবোৰৰ অধিক ভৰি থাকে, সেইবোৰ তোমালোকে নাখাবা; কিয়নো সেইবোৰ ঘিণ লগা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","সেই সকলো বগাই ফুৰা উৰগ আদি জন্তুবোৰৰ দ্বাৰাই তোমালোকে নিজক অশুচি নকৰিবা আৰু অশুচি হবলৈ সেইবোৰৰ দ্বাৰাই নিজকে অশুচি নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","কাৰণ মই তোমালোকৰ ঈশ্বৰ যিহোৱা; এই হেতুকে তোমালোকে নিজকে পবিত্ৰ কৰি পবিত্ৰ হোৱা, কিয়নো মই পবিত্ৰ; তোমালোকে মাটিৰ ওপৰত বগাই ফুৰা ভূ-চৰ জন্তুবোৰৰ দ্বাৰাই নিজকে অশুচি নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","কিয়নো, তোমালোকৰ ঈশ্বৰ হ’বলৈ তোমালোকক মিচৰ দেশৰ পৰা উলিয়াই অনা যিহোৱা মই; এই হেতুকে তোমালোক পবিত্ৰ হোৱা, কাৰণ মই পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","শুচি অশুচি বস্তুৰ আৰু খাব পৰা, খাব নোৱাৰা জন্তু, প্ৰভেদ জন্মাবৰ বাবে, ");
INSERT INTO asmfb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","পশু, পক্ষী; জলচৰ আৰু বগাই ফুৰা উৰগ আদি প্ৰাণীবোৰৰ বিষয়ে এই নিয়ম’।” ");
INSERT INTO asmfb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক কোৱা বোলে, ‘কোনো এগৰাকী মহিলাই প্ৰসৱ কৰিলে, যদি তাইৰ ল’ৰা হয়, তেতিয়া তাই সাতদিন অশুচি হৈ থাকিব; তাইৰ মাহেকীয়া অশৌচৰ কালৰ দৰেই অশুচিতাৰ দৰেই তাই অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","পাছত অষ্টম দিনা ল’ৰাটিৰ লিঙ্গাগ্ৰ-চৰ্ম ছেদন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","আৰু সেই মহিলা গৰাকীৰ ৰক্তস্ৰাৱৰ পৰা শুচি হ’বৰ অৰ্থে তাই তেত্ৰিশ দিন ৰখিব লাগিব; ৰক্তস্ৰাৱৰ অৱস্থাৰ পৰা শুচি নোহোৱালৈ তাই কোনো পবিত্ৰ বস্তু নুচুব আৰু ধৰ্মধামত নোসোমাব। ");
INSERT INTO asmfb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","যদি তাইৰ ছোৱালী হয়, তেতিয়া তাইৰ মাহেকীয়া অশৌচৰ কালৰ দৰে দুসপ্তাহ অশুচি হৈ থাকিব; আৰু ৰক্তস্ৰাৱৰ পৰা শুচি হ’বৰ কাৰণে তাইক ছয়ষষ্টি দিন ৰখিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","পাছত যেতিয়া তাইৰ ৰক্তস্ৰাৱৰ পৰা শুচি হোৱা দিনবোৰ পুৰ হ’ব, তেতিয়া তাইৰ ল’ৰা বা ছোৱালীৰ অৰ্থে তাই হোম-বলিৰ এটা এবছৰীয়া মেৰ-ছাগ পোৱালি, আৰু পাপাৰ্থক বলিৰ কাৰণে এটা পাৰ পোৱালি বা এটা কপৌ সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ পুৰোহিতৰ ওচৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","তেতিয়া পুৰোহিত জনে যিহোৱাৰ সন্মুখত তাক উৎসৰ্গ কৰি, সেই মহিলা গৰাকীক প্ৰায়চিত্ত কৰিব; তেতিয়া তাই নিজ ৰক্তস্ৰাৱৰ পৰা শুচি হ’ব। ল’ৰা বা ছোৱালী প্ৰসৱ কৰা মহিলাসকলৰ কাৰণে এই নিয়ম। ");
INSERT INTO asmfb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","যদি তাই মেৰ-ছাগ পোৱালি আনিবলৈ অসমৰ্থ হয়, তেতিয়া তাই দুটা কপৌ বা দুটা পাৰ পোৱালি লৈ, তাৰ এটা হোমৰ অৰ্থে, আনটো পাপাৰ্থক বলিৰ অৰ্থে দিব, আৰু পুৰোহিতে তাইক প্ৰায়চিত্ত কৰিব; তেতিয়া তাই শুচি হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“যদি কোনো এজন লোকৰ গাৰ ছাল উখহি উঠে, বা চোকোৰা বান্ধি উঠে, বা জিলিকা দাগ হয়, আৰু সেয়ে যদি গাৰ ছালত কুষ্ঠৰোগৰ ঘা হৈ যায়, তেতিয়া তেওঁক হাৰোণ পুৰোহিত বা তেওঁৰ পুত্ৰ পুৰোহিতসকলৰ মাজৰ এজনৰ ওচৰলৈ অনা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","তেতিয়া পুৰোহিত জনে তেওঁৰ গাৰ ছালত থকা সেই ঘাটো চাব; যদি সেই ঘাৰ নোম বগা হৈ উঠে, আৰু ঘা যদি গাৰ ছালতকৈ দ যেন বোধ হয়, তেতিয়া সেই ঘা কুষ্ঠৰোগৰ ঘা; তেওঁৰ সেই ঘা চোৱাৰ পাছত পুৰোহিতে তেওঁক অশুচি বুলি জনাব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","আৰু যদি তেওঁৰ সেই জিলিকা দাগ ঘাৰ ছালত বগা হয়, কিন্তু ছালতকৈ দ যেন বোধ নহয়, আৰু তেওঁৰ ঘাৰ নোম বগা হৈ যোৱা নাই, তেতিয়া সেই ঘা হোৱা লোক জনক পুৰোহিতে সাতদিন আতৰ কৰি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","পাছত সপ্তম দিনা পুৰোহিত জনে সেই ঘা হোৱা লোকজনক চাই যদি তেওঁৰ দৃষ্টিত ঘা সেই একেদৰে থাকে বা ছালত ব্যাপি যোৱা নাই, তেতিয়া পুৰোহিত জনে তেওঁক আকৌ সাত দিনলৈ আতৰত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","আৰু সপ্তমদিনা পুৰোহিত জনে তেওঁক আকৌ চাব; তেতিয়া যদি সেই ঘা শুকাবলৈ ধৰে, আৰু ছালত যদি বিয়পি যোৱা নেদেখে, তেতিয়া পুৰোহিতে তেওঁক শুচি বুলি জনাব; সেয়ে কেৱল চোকোৰা বন্ধা ঘা হে; পাছত তেওঁ নিজ বস্ত্ৰ ধুই শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","কিন্তু তেওঁৰ শুচিৰ অৰ্থে নিজকে পুৰোহিতক দেখুউৱাৰ পাছত যদি সেই চোকোৰা বন্ধা ঘা ছালত বিয়পি যায়, তেতিয়া তেওঁ পুনৰায় নিজকে পুৰোহিতক দেখুৱাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","তেতিয়া পুৰোহিতে সেই ঘা চাই যদি তেওঁৰ চোকোৰা বন্ধা ঘা ছালত বিয়পি যোৱা দেখে, তেতিয়া তেওঁ লোকজনক অশুচি বুলি জনাব; সেয়ে কুষ্ঠৰোগ। ");
INSERT INTO asmfb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","কোনো এজন লোকৰ কুষ্ঠৰোগৰ ঘা হ’লে, তেওঁক পুৰোহিতৰ ওচৰলৈ অনা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","তেতিয়া পুৰোহিতে তেওঁক চাব; যদি তেওঁৰ ছালত বগা ধৰণৰ টেমুনা বান্ধে, আৰু তাৰ দ্বাৰাই তাৰ নোম বগা হৈ উঠে, আৰু সেই টেমুনাত কেঁচা মঙহ থাকে, ");
INSERT INTO asmfb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","তেতিয়া তেওঁৰ গাৰ ছালত সেয়ে পুৰণি কুষ্ঠৰোগ; তাতে পুৰোহিতে তেওঁক অশুচি বুলি জনাব; তেওঁ সেই লোকজনক আতৰত নাৰাখিব, কিয়নো তেওঁ আগৰে পৰা অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","যদি ছালৰ সকলোতে সেই কুষ্ঠৰোগ ব্যাপি যায়, আৰু পুৰোহিতৰ যিমানলৈকে চকু পৰে, সিমানলৈকে সেই ঘা থকা লোকজনৰ মূৰৰ পৰা ভৰিলৈকে গোটেই ছাল কুষ্ঠৰোগেৰে ঢাকে, ");
INSERT INTO asmfb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","তেতিয়া তেওঁৰ গোটেই গা কুষ্ঠৰোগেৰে ঢকা দেখি, পুৰোহিতে সেই ঘা থকা লোকজনক শুচি বুলি ক’ব; তেওঁৰ গোটেই গা বগা হোৱাত তেওঁ শুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","কিন্তু যেতিয়া সেই ঘাত কেঁচা মঙহ দেখা যায়, তেতিয়া তেওঁ অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","তেতিয়া পুৰোহিতে সেই কেঁচা মঙহ দেখি, তেওঁক অশুচি বুলি ক’ব, কিয়নো সেই কেঁচা মঙহ অশুচি; সেয়ে কুষ্ঠৰোগ। ");
INSERT INTO asmfb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","আৰু সেই কেঁচা মঙহ যদি পুনৰায় বগা হৈ যায়, তেতিয়া তেওঁ পুৰোহিতৰ ওচৰলৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","তেতিয়া পুৰোহিতে সেই লোকজনৰ বগা হৈ উঠা ঘাটো চাব, আৰু যদি সেই ঘা বগা হোৱা দেখে, তেতিয়া পুৰোহিতে সেই ঘা থকা লোকজনক শুচি বুলি ক’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","আৰু গাৰ ছালত ফোঁহোৰা হৈ ভাল হোৱাৰ পাছত, ");
INSERT INTO asmfb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","যদি সেই ফোঁহোৰাৰ ঠাইত বগা বৰণৰ টেমুনা বান্ধে, বা বগা আৰু অলপ ৰঙা বৰণৰ জিলিকা দাগ হয়, তেতিয়া তাক পুৰোহিতক দেখুউৱা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","তেতিয়া পুৰোহিতে তাক চাব; যদি সেয়ে ছালতকৈ দ যেন বোধ হয়, আৰু তাৰ নোম বগা হৈ গ’ল, তেতিয়া পুৰোহিতে তেওঁক অশুচি বুলি ক’ব; সেয়ে ফোঁহোৰাত ওলোৱা কুষ্ঠৰোগৰ ঘা। ");
INSERT INTO asmfb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","কিন্তু পুৰোহিতে তাক চাই যদি বগা নোম নেদেখে, আৰু সেয়ে ছালতকৈ দ নহয়, কিন্তু শুকাই গৈছে, তেতিয়া পুৰোহিতে তেওঁক সাত দিন আতৰত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","পাছত সেয়ে যদি ছালত বিয়পি যায়, তেন্তে পুৰোহিতে তেওঁক অশুচি বুলি ক’ব; সেয়ে কুষ্ঠ ৰোগৰ ঘা। ");
INSERT INTO asmfb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","কিন্তু যদি সেই জিলিকা দাগ নিজ ঠাইতে থাকে, আৰু বিয়পি নাযায়, তেন্তে সেয়ে ফোঁহোৰাৰ দাগ মাত্ৰ; আৰু পুৰোহিতে তেওঁক শুচি বুলি ক’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","যদি গাৰ ছালত পোৰা দাগ হয়, আৰু সেই দাগৰ নতুন ছালৰ ৰঙচুৱা বগা বা শুদ্ধ বগা বা জিলিকা দাগ হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","তেন্তে পুৰোহিতে তাক চাব; যদি জিলিকা দাগত থকা নোম বগা হৈ গ’ল, আৰু আন ছালতকৈ দ যেন দেখা যায়, তেতিয়া সেয়ে জুইয়ে পোৰা দাগত ওলোৱা কুষ্ঠ ৰোগ; পুৰোহিতে তাক অশুচি বুলি ক’ব, কিয়নো সেয়ে কুষ্ঠ ৰোগৰ ঘা। ");
INSERT INTO asmfb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","কিন্তু যদি পুৰোহিতে চাই জিলিকা দাগত বগা নোম নেদেখে, আৰু সেই দাগ ছালতকৈ দ নহয়, কিন্তু শুকাই গ’ল, তেতিয়া পুৰোহিতে তেওঁক সাত দিন আতৰত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","পাছত সপ্তম দিনা পুৰোহিতে তেওঁক চাব; তেতিয়া যদি ছালত সেয়ে বিয়পি যায়, তেন্তে পুৰোহিতে তেওঁক অশুচি বুলি ক’ব; সেয়ে কুষ্ঠ ৰোগৰ ঘা। ");
INSERT INTO asmfb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","আৰু যদি সেই জিলিকা দাগ নিজ ঠাইতে থাকে, আৰু ছালত ব্যাপি নাযায়, কিন্তু শুকাই যায়, তেন্তে সেয়ে পোৰা ঠাইত উঠা টেমুনা মাথোন; আৰু পুৰোহিতে তেওঁক শুচি বুলি ক’ব, কিয়নো সেয়ে জুইয়ে পোৰা ঘাৰ দাগহে মাথোন। ");
INSERT INTO asmfb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","কোনো পুৰুষ বা স্ত্ৰীৰ মূৰত বা থুঁতৰিৰ তলত ঘা হ’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","পুৰোহিতে সেই ঘা চাব; সেয়ে যদি ছালতকৈ দ যেন বোধ হয়, আৰু তাত হালধীয়া মিহি নোম থাকে তেন্তে পুৰোহিতে তেওঁক অশুচি বুলি ক’ব; সেয়ে খজুৱা ৰোগ; মূৰৰ চুলি বা দাড়ি সৰা কুষ্ঠ ৰোগ। ");
INSERT INTO asmfb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","আৰু পুৰোহিতে সেই খজুৱা চুলি বা দাড়ি সৰা ৰোগৰ ঘা চালে, যদি সেয়ে ছালতকৈ দ যেন বোধ নহয়, আৰু তাত ক’লা নোম নাথাকে, তেন্তে পুৰোহিতে সেই চুলি কি দাড়ি সৰা ৰোগ থকা লোকজনক সাতদিন আতৰ কৰি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","পাছত পুৰোহিতে সপ্তম দিনা সেই ঘা চাব; যদি সেই ঘা বিয়পি যোৱা নাই, আৰু তাত হালধীয়া নোম নাই, আৰু ছালতকৈ ঘাৰ ছাল দ যেন বোধ নহয়, ");
INSERT INTO asmfb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","তেন্তে সেই ঘাৰ কাষৰ চৰিওফালে থকা চুলি খুৰুউৱা হ’ব, কিন্তু ঘা থকা ঠাইডোখৰ নুখুৰাব; তেতিয়া পুৰোহিতে সেই খজুৱা ঘা থকা লোকজনক আৰু সাতদিন আতৰ কৰি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","পাছত সপ্তমদিনা পুৰোহিতে সেই ঘা চাব; তাতে, যদি সেই ঘা ছালত ব্যাপি যোৱা নাই, আৰু ছালতকৈ দ যেন বোধ নহয়, তেন্তে পুৰোহিতে তেওঁক শুচি বুলি ক’ব; পাছত সেই লোকজনে নিজ বস্ত্ৰ ধুই শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","কিন্তু পুৰোহিতে শুচি কৰোঁৱাৰ পাছত, যদি তেওঁৰ ছালত সেই ঘা ব্যাপি যায়, ");
INSERT INTO asmfb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","তেন্তে পুৰোহিতে তেওঁক পুনৰায় চাব; যদি তেওঁৰ ছালত সেই ঘা ব্যাপি যোৱা দেখে, তেন্তে পুৰোহিতে হালধীয়া নোম নিবিচাৰিব; সেই লোকজন অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","কিন্তু তেওঁৰ দৃষ্টিত যদি সেই ঘা একেদৰে থাকে, আৰু তাৰ মাজত ক’লা নোম গজে, তেন্তে সেই ৰোগ ভাল হ’ল; তেওঁ শুচি; আৰু পুৰোহিতে তেওঁক শুচি বুলি ক’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","আৰু যদি কোনো পুৰুষ বা স্ত্ৰীৰ গাৰ ছালত ঠায়ে ঠায়ে বগা দাগ হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","তেন্তে পুৰোহিতে সেই লোকজনক চাব; যদি তেওঁৰ ছালত হোৱা জিলিকা দাগবোৰ গোম বৰণীয়া বগা হয়, তেন্তে সেয়ে ছালত উৎপন্ন হোৱা এবিধ ফোঁহা; আৰু তেওঁ শুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","আৰু যদি কোনো মানুহৰ মূৰৰ চুলি সৰি যায়, তেন্তে তেওঁ টকলা মূৰা; কিন্তু তেওঁ শুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","আৰু যদি তেওঁৰ মূৰৰ আগফালৰ চুলি সৰি যায় আৰু টপা; তেৱোঁ শুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","কিন্তু যদি তেওঁৰ টকলা বা টপা মূৰত ৰঙচীয়া বগা ঘা হয়, তেন্তে সেয়ে তাৰ টকলা মূৰত বা টপা মূৰত হোৱা কুষ্ঠ ৰোগ। ");
INSERT INTO asmfb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","তেতিয়া পুৰোহিতে তেওঁক চাব; যদি গাৰ ছালত হোৱা কুষ্ঠ ৰোগৰ দৰে তেওঁৰ টকলা বা টপা মূৰত সেই ঘা দমলা ৰঙচীয়া বগা হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","তেন্তে তেওঁ কুষ্ঠ ৰোগী আৰু অশুচি; অৱশ্যে পুৰোহিতে তেওঁক অশুচি বুলি ক’ব; তাৰ কুষ্ঠৰোগৰ ঘা তেওঁৰ মূৰতে আছে। ");
INSERT INTO asmfb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","যি কুষ্ঠৰোগীৰ গাত কুষ্ঠৰোগৰ ঘা থাকে, তেওঁ ফলা বস্ত্ৰ পিন্ধিব, আৰু তেওঁৰ মূৰৰ চুলি মুকলিকৈ ৰখা হ’ব, আৰু তেওঁ নিজৰ ওপৰ ওঁঠ ঢাকিব, আৰু ‘অশুচি, অশুচি,’ বুলি চিঞৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","যিমান দিন তেওঁৰ গাত সেই কুষ্ঠৰোগ ঘা থাকিব, সিমান দিন তেওঁ অশুচি হৈ থাকিব; তেওঁ অশুচি হোৱাত আৰু তেওঁৰ সেই ৰোগ যেন ব্যাপি নাযায় সেই কাৰণে তেওঁ অকলে থাকিব; তেওঁৰ থকা ঠাই ছাউনিৰ বাহিৰত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","আৰু নোমৰ কি শণ সুতাৰ এটা বস্ত্ৰত, কুষ্ঠৰোগৰ কোনো দাগ থাকিলে ");
INSERT INTO asmfb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","বা শণৰ কি নোমৰ দীঘ সুতা বা বাণী সুতাত, বা কোনো ছালত, কি ছালেৰে সজা ");
INSERT INTO asmfb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","কোনো বস্ত্ৰত, বস্ত্ৰ বা ছালত, বা দীঘ সুতাত বা বাণী সুতাত, বা ছালৰ কোনো বস্ত্ৰত থকা সেই দাগ যদি অলপ কেঁচা বৰণীয়া বা ৰঙচুৱা হয়, তেন্তে সেয়ে কুষ্ঠৰোগ দাগ, তাক পুৰোহিতক দেখুউৱা যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","পাছত পুৰোহিতে সেই দাগ চাই, দাগ থকা বস্তুটো সাতদিন আতৰ কৰি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","পাছত সপ্তমদিনা পুৰোহিতে সেই দাগ চাই যদি কাপোৰত, বা দীঘ সুতা কি বাণী সুতাত, বা কোনো কামৰ কাৰণে ব্যৱহাৰ কৰা ছালত সেই দাগ ব্যাপি যোৱা দেখে, তেন্তে সেই দাগ সংহাৰক কুষ্ঠৰোগৰ দাগ; সেয়ে অশুচি বস্তু। ");
INSERT INTO asmfb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","এই কাৰণে যি বস্ত্ৰত, বা নোমৰ যি শণ বা যি দীঘ সুতাত বা বাণী সুতাত, বা ছালেৰে সজা যি বস্ত্ৰত সেই দাগ হয়, তাক পুৰি ভস্ম কৰিব; কিয়নো সেয়ে সংহাৰক কুষ্ঠ; তাক সম্পূৰ্ণৰূপে জুইত পুৰি ভস্ম কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","কিন্তু পুৰোহিতে চাই যদি সেই দাগ কাপোৰত, বা দীঘ সুতাত কি বাণী সুতাত, বা ছালৰ কোনো বস্ত্ৰত সেই দাগ ব্যাপি যোৱা নেদেখে, ");
INSERT INTO asmfb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","তেতিয়া পুৰোহিতে সেই দাগ থকা বস্তুটো ধুবলৈ আজ্ঞা দিব; পাছত আৰু সাতদিন সেই বস্তুটো আতৰত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","সেই দাগ থকা বস্তু ধোৱাৰ পাছত পুৰোহিতে সেই দাগ চাব; আৰু সেই দাগ ব্যাপি নগলেও যদি আন বৰণ ধৰা নাই, তেন্তে সেয়ে অশুচি; যি ঠাইতে সেই দাগে বস্তুটোক অশুচি নকৰক, তুমি তাক জুইত পুৰি ভস্ম কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","কিন্তু ধোৱাৰ পাছত পুৰোহিতে চাই যদি সেই দাগ গোমা দেখে, তেন্তে তেওঁ সেই বস্ত্ৰৰ পৰা, বা ছালৰ পৰা, বা দীঘ সুতা বা বাণী সুতাৰ পৰা তাক চিঙি পেলাব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","তথাপিও যদি সেই বস্ত্ৰত, বা দীঘ সুতা কি বাণী সুতাত, বা ছালেৰে সজা কোনো বস্ত্ৰত তাক পুনৰাই দেখা যায়, তেন্তে সেয়ে ব্যাপি যোৱা কুষ্ঠ; সেই দাগ থকা যিয়ে বস্তু তুমি তাক জুইত পুৰি ভস্ম কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","আৰু ধোৱাৰ পাছত সেই দাগ বস্ত্ৰৰ পৰা বা দীঘ সুতা কি বাণী সুতাৰ পৰা, বা ছালৰ কোনো বস্তুৰ পৰা এৰাই, তেন্তে দ্বিতীয়বাৰ তাক ধোৱা হ’ব; তেতিয়া সেয়ে শুচি হব। ");
INSERT INTO asmfb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","নোমৰ বা শণ সুতাৰ বস্ত্ৰত, বা দীঘ সুতা কি বাণী সুতাত বা ছালৰ কোনো বস্তুত হোৱা কুষ্ঠ ৰোগৰ দাগৰ বিষয়ে শুচি অশুচি বুলি কোৱা নিয়ম এই।” ");
INSERT INTO asmfb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“কুষ্ঠৰোগী লোক জন সুস্থ হোৱাৰ দিনা তেওঁৰ শুচি হোৱা নিয়ম এই; তেওঁক পুৰোহিতৰ ওচৰলৈ অনা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","তেতিয়া পুৰোহিতে ছাউনিৰ বাহিৰলৈ ওলাই গৈ সেই কুষ্ঠৰোগী জনৰ কুষ্ঠৰোগ যদি সুস্থ হৈছে, তেনেহলে সেই বিষয়ে তেওঁ লক্ষ্য কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","তেতিয়া পুৰোহিতে সেই শুচি কৰিব লগা লোকজনৰ কাৰণে দুটা জীয়া শুচি চৰাই, এডোখৰ এৰচ কাঠ, অলপ ৰঙা নোম, আৰু একোচা এচোব বন, এই সকলোকে লবলৈ আজ্ঞা দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","আৰু পুৰোহিত জনে তেওঁক মাটিৰ পাত্ৰত থোৱা নিৰ্মল পানীৰ ওপৰত সেই দুটা চৰাইৰ এটাক কাটিবলৈ আজ্ঞা কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","তাৰ পাছত তেওঁ জীয়া চৰাইটো, এৰচ কাঠডোখৰ আৰু এচোব বন কোচা, এই সকলোকে লৈ সেই নিৰ্মল পানীৰ ওপৰত কটা চৰাইটোৰ তেজত জীয়া চৰাইটোৰে সৈতে জুবুৰিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","তেতিয়া কুষ্ঠ ৰোগৰ পৰা শুচি হ’বলগীয়া লোক জনৰ ওপৰত সাতবাৰ এই পানী ছটিয়াব, আৰু তেওঁক শুচি বুলি ঘোষণা কৰিব। তাৰ পাছত পুৰোহিত জনে জীয়া চৰাইটো মুকলি পথাৰত উৰুৱাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","আৰু সেই শুচি হ’বলগীয়া লোক জনে নিজ বস্ত্ৰ ধুই, চুলি দাড়ি আদি গাৰ আটাই নোম খুৰাই পানীত গা ধুব আৰু তাৰ পাছত তেওঁ শুচি হ’ব। এই বোৰ কৰাৰ পাছত তেওঁ ছাউনিত সোমাব, কিন্তু তেওঁ সাত দিন নিজ তম্বুৰ বাহিৰত থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","পাছত সপ্তম দিনা তেওঁ নিজ মূৰৰ চুলি, দাড়ি, চেলাউৰি আদি গোটেই গাৰ নোম খুৰাব, আৰু নিজ বস্ত্ৰ ধুই, নিজেও পানীত গা ধুব; তেতিয়া তেওঁ শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","অষ্টম দিনা তেওঁ দুটা নঘূণ মতা মেৰ-ছাগ পোৱালি, এজনী এবছৰীয়া নিঘূণ চেঁউৰী মেৰ-ছাগ পোৱালি, ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা আটা গুড়ি ঐফাৰ দহ ভাগৰ তিনিভাগ, আৰু এক “লোগ” তেল ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","তাৰ পাছত শুচি কৰোঁতা পুৰোহিত জনে, সেই শুচি হ’বলগীয়া লোক জনক আৰু সেই বস্তুবোৰ লৈ সাক্ষাৎ কৰা তম্বুৰ দুৱাৰৰ ওচৰত যিহোৱাৰ সন্মুখত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","পাছত পুৰোহিত জনে সেই মেৰ-ছাগ পোৱালি দুটাৰ এটা পোৱালি, সেই এক “লোগ” তেলেৰে সৈতে দোষাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰিব, আৰু দোলনীয় নৈবেদ্যৰ অৰ্থে সেইবোৰ যিহোৱাৰ সন্মুখত তুলি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","আৰু যি ঠাইত পাপাৰ্থক বলি আৰু হোম-বলি কটা যায়, পবিত্ৰ স্থানৰ সেই ঠাইতে সেই মেৰ-ছাগৰ পোৱালিটো কাটিব লাগিব, কিয়নো সেই দোষাৰ্থক বলি পুৰোহিতৰ ভাগ, আৰু সেয়ে অতি পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","পুৰোহিতে সেই দোষাৰ্থক বলিৰ কিছু তেজ লৈ, সেই শুচি হবলগীয়া মানুহটোৰ সোঁ কাণৰ মুৰত, সোঁ হাতৰ বুঢ়া আঙুলিত আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিত লগাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","তাৰ পাছত পুৰোহিতে সেই “লোগ” তেলৰ কিছু লৈ নিজৰ বাওঁহাতৰ তলুৱাত ঢালিব; ");
INSERT INTO asmfb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","আৰু সেই বাওঁ হাতৰ তলুৱাত থকা তেলত নিজ সোঁহাতৰ আঙুলি জুবুৰিয়াই, আঙুলিৰে সেই তেলৰ পৰা অলপ অলপকৈ যিহোৱাৰ সন্মুখত সাতবাৰ ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","পুৰোহিতে নিজৰ হাতৰ তলুৱাত থকা অৱশিষ্ট তেলৰ কিছু লৈ, শুচি হ’বলগীয়া লোক জনৰ সোঁ কাণৰ মূৰত, সোঁ হাতৰ বুঢ়া আঙুলিত আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিত পুৰ্বে দিয়া দোষাৰ্থক বলিৰ তেজৰ ওপৰত লগাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","পুৰোহিতে নিজৰ হাতৰ তলুৱাত থকা অৱশিষ্ট তেল খিনি সেই শুচি হ’বলগীয়া লোক জনৰ মূৰত দিব, আৰু পুৰোহিতে যিহোৱাৰ সন্মুখত তেওঁক প্ৰায়চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","তাৰ পাছত পুৰোহিতে পাপাৰ্থক বলিটো উৎসৰ্গ কৰিব, আৰু সেই শুচি হ’বলগীয়া লোকজনৰ অশৌচৰ কাৰণে তেওঁক প্ৰায়চিত্ত কৰিব; তাৰ পাছত হোমবলিটো কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","যেতিয়া পুৰোহিতে হোমবলিটো আৰু ভক্ষ্য নৈবেদ্য খিনি বেদীত উৎসৰ্গ কৰিব, তেতিয়া পুৰোহিতে সেই ব্যক্তিক প্ৰায়শ্চিত্ত কৰিব আৰু তেওঁ তেতিয়া শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","কিন্তু যদি সেই লোক জন দৰিদ্ৰ হয়, আৰু এই সকলো বলি আনিবলৈ তেওঁৰ সমৰ্থ নাথাকে, তেতিয়া তেওঁ নিজৰ কাৰণে প্ৰায়চিত্ত কৰিবলৈ দোলনীয় নৈবেদ্যৰ অৰ্থে দোষাৰ্থক বলি স্বৰূপে এটা মতা মেৰ-ছাগ পোৱালি, ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা আটাগুড়িৰ ঐফাৰ দহভাগৰ এভাগ এক “লোগ” তেল, ");
INSERT INTO asmfb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","আৰু নিজৰ সমৰ্থ অনুসাৰে দুটা কপৌ বা দুটা পাৰ পোৱালি আনিব; তাৰে এটা পাপাৰ্থক বলি আৰু আনটো হোমবলি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","পাছত অষ্টম দিনা, তেওঁ নিজকে শুচি কৰিবৰ অৰ্থে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ যিহোৱাৰ সন্মুখত পুৰোহিতৰ ওচৰলৈ সেইবোৰ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","তেতিয়া পুৰোহিতে দোষাৰ্থক বলিৰ কাৰণে সেই মেৰ-ছাগ পোৱালিটো আৰু সেই “লোগ” তেল লৈ, যিহোৱাৰ সন্মুখত দোলনীয় নৈবেদ্যৰ অৰ্থে তুলি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","পাছত তেওঁ সেই দোষাৰ্থক বলিৰ মেৰ-ছাগ পোৱালিটো কাটিব লাগিব; পুৰোহিতে সেই দোষাৰ্থক বলিৰ কিছু তেজ লৈ, শুচি হ’বলগীয়া লোকজনৰ সোঁ কাণৰ মূৰত, সোঁ হাতৰ বুঢ়া আঙুলিত আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিত লগাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","তাৰ পাছত পুৰোহিতে সেই তেলৰ অলপ নিজৰ বাওঁ হাতৰ তলুৱাত বাকিব, ");
INSERT INTO asmfb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","আৰু পুৰোহিতে সোঁ আঙুলিৰে বাওঁ হাতৰ তলুৱাত থকা সেই তেল অলপ অলপকৈ সাতবাৰ যিহোৱাৰ সন্মুখত ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","আৰু পুৰোহিতে নিজৰ হাতৰ তলুৱাত থকা তেলৰ কিছু লৈ, শুচি হ’ব লগীয়া লোক জনৰ সোঁ কাণৰ মূৰত, সোঁ হাতৰ বুঢ়া আঙুলিত আৰু সোঁ ভৰিৰ বুঢ়া আঙুলিত পুৰ্বে দিয়া সেই দোষাৰ্থক বলিৰ তেজ থকা সেই একে ঠাইবোৰৰ ওপৰত লগাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","আৰু শুচি হ’বলগীয়া লোক জনক যিহোৱাৰ সন্মুখত প্ৰায়চিত্ত কৰিবলৈ, পুৰোহিতে নিজৰ হাতত থকা অৱশিষ্ট তেল খিনি তেওঁৰ মূৰত দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","পাছত সেই লোক জনৰ সমৰ্থ অনুসাৰে অনা সেই কপৌ দুটাৰ বা পাৰ পোৱলি দুটাৰ মাজৰ এটা উৎসৰ্গ কৰিব; ");
INSERT INTO asmfb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","অৰ্থাৎ সেই দুটাৰ এটা পাপাৰ্থক বলি আনটো হোম-বলিস্বৰূপে আৰু সেই ভক্ষ্য নৈবেদ্যখিনিয়ে সৈতে উৎসৰ্গ কৰিব। তাৰ পাছত পুৰোহিতে শুচি হ’ব লগীয়া লোক জনক যিহোৱাৰ সন্মুখত প্ৰায়চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","কুষ্ঠৰোগৰ ঘা থকা যি লোক জনে নিজকে শুচি কৰা সময়ত নিয়মিত বলিদান আদি দিবলৈ অসমৰ্থ, তাৰ এই নিয়ম।” ");
INSERT INTO asmfb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“মই যি দেশ অধিকাৰ অৰ্থে তোমালোকক দিম, সেই কনান দেশত তোমালোকে যেতিয়া সোমাবা, তোমালোকে অধিকাৰ কৰা সেই দেশৰ কোনো এটা ঘৰত যদি মই কুষ্ঠৰোগৰ দাগ উৎপন্ন কৰোঁ, ");
INSERT INTO asmfb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","তেতিয়া সেই ঘৰৰ গৰাকীয়ে আহি পুৰোহিতক জনাব। তেওঁ এই বুলি ক’ব যে, ‘মই মোৰ ঘৰত কুষ্ঠ ৰোগৰ দাগ যেন দেখিছোঁ’। ");
INSERT INTO asmfb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","তেতিয়া ঘৰৰ সকলো বস্তু যেন অশুচি নহয় এই কাৰণে, সেই দাগ চাবলৈ পুৰোহিতে ঘৰ সোমোৱাৰ পুৰ্বেই ঘৰ খালী কৰিবলৈ তেওঁলোকক আজ্ঞা কৰিব; তাৰ পাছত পুৰোহিতে ঘৰটো চাবলৈ সোমাব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","তেওঁ সেই দাগৰ বিষয়ে চাব; যদি সেই দাগ ঘৰৰ দেৱালত অলপ কেঁচা বৰণীয়া বা ৰঙচীয়া চকলা-চকলী হয় আৰু দেৱালতকৈ দ যেন বোধ হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","আৰু যদি সঁচাকৈ সেই ঘৰত কুষ্ঠ ৰোগৰ দাগ আছে, তেতিয়া পুৰোহিতে ঘৰৰ পৰা দুৱাৰ-মুখলৈ ওলাই সাতদিন সেই ঘৰ বন্ধ কৰি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","সপ্তমদিনা পুৰোহিতে পুনৰায় আহি সেই ঘৰৰ দেৱালত সেই দাগ বিয়পি যোৱা বিষয়ে চাব; ");
INSERT INTO asmfb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","আৰু এনে যদি হয়, তেনেহলে মানুহে যেন সেই দাগ থকা শিলবোৰ উলিয়াই নগৰৰ বাহিৰত অশুচি ঠাইত পেলাই দিয়ে, পুৰোহিতে এনে আজ্ঞা কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","পাছত সেই ঘৰৰ ভিতৰৰ চাৰিওফালৰ দেৱাল তেওঁ চোঁচাই পেলোব লাগিব, আৰু চুঁচি পেলোৱাৰ কৰালবোৰ তেওঁলোকে নগৰৰ বাহিৰত সেই অশুচি ঠাইত পেলাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","তেওঁলোকে আন শিল লৈ সেই শিলৰ ঠাইত বহুৱাব, আৰু নতুন কৰাল লৈ পুনৰায় সেই ঘৰ লিপিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","এইদৰে শিল উলিওৱা আৰু ঘৰ চোঁচা আৰু লিপাৰ পাছত, যদি পুনৰায় ঘৰত সেই দাগ ওলাই, ");
INSERT INTO asmfb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","তেতিয়া পুৰোহিতে আহি চাব আৰু যদি সেই ঘৰত দাগ ব্যাপি যোৱা দেখে, তেনেহলে সেই ঘৰত সংহাৰক কুষ্ঠ আছে; আৰু সেই ঘৰখন অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","তেতিয়া সেই ঘৰ ভাঙি পেলোৱা হ’ব। তাৰ শিল, কাঠ আৰু কৰাল আদি সকলোকে নগৰৰ বাহিৰলৈ সেই অশুচি ঠাইলৈ লৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","তদুপৰি সেই ঘৰ বন্ধ থকাত যদি কোনো লোকে তাৰ ভিতৰত সোমাব, তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","আৰু যিকোনো লোকে সেই ঘৰত শুব, তেওঁ নিজ বস্ত্ৰ ধুব আৰু যিকোনো লোকে সেই ঘৰত আহাৰ কৰিব, তেৱোঁ নিজ বস্ত্ৰ ধুব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","আৰু সেই ঘৰ লিপাৰ পাছত পুৰোহিতে সোমাই যদি সেই দাগ ব্যাপি নোযোৱা দেখে, তেন্তে পুৰোহিতে সেই ঘৰ শুচি বুলি ক’ব; কিয়নো তাৰ কুষ্ঠ ভাল হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","পাছত তেওঁ সেই ঘৰ শুচি কৰিবৰ কাৰণে দুটা চৰাই, এডোখৰ এৰচ কাঠ, অলপ ৰঙা নোম, আৰু একোচা এচোব বন ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","মাটিৰ পাত্ৰত থোৱা নিৰ্মল পানীৰ ওপৰত তেওঁ এটা চৰাই কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","তেওঁ সেই এৰচ কাঠডোখৰ, এচোব বনকোচা, ৰঙা নোমখিনি আৰু জীয়া চৰাইটো এই সকলোকে লৈ, সেই কটা চৰাইৰ তেজত আৰু নিৰ্মল পানীত জুবুৰিয়াই সাতবাৰ ঘৰত ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","এইদৰে তেওঁ চৰাইৰ তেজ, নিৰ্মল পানী, জীয়া চৰাই, এৰচ কাঠ, এচোব বন আৰু ৰঙা নোম, এই সকলোৰে দ্বাৰাই সেই ঘৰ শুচি কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","কিন্তু তেওঁ নগৰৰ বাহিৰত থকা মুকলি পথাৰত সেই জীয়া চৰাইটো উৰুৱাই দিব; এইদৰে তেওঁ ঘৰ প্ৰায়চিত্ত কৰিব; তাতে সেই ঘৰ শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","এয়ে ছালৰ সকলো প্ৰকাৰ কুষ্ঠ ৰোগৰ চিনৰ নিয়ম যেনে ছালত খজুৱতি ধৰা চুলি দাড়ি সৰা, ");
INSERT INTO asmfb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","কাপোৰ আৰু ঘৰত হোৱা কুষ্ঠ, ");
INSERT INTO asmfb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ছাল উখহি উঠা, চোকোৰা বন্ধা, জিলিকা দাগ। ");
INSERT INTO asmfb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","এই সকলো কোন সময়ত শুচি আৰু কোন সময়ত অশুচি, সেই বিষয়ে জনোৱাই তাৰ অভিপ্ৰায়; এইয়ে কুষ্ঠৰোগ আৰু কুষ্ঠৰোগৰ দাগৰ নিয়ম।” ");
INSERT INTO asmfb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","যিহোৱাই মোচি আৰু হাৰোণক কোৱা কথাখিনি এইদৰে ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“তোমালোকে ইস্ৰায়েলৰ সন্তান সকলক এই কথা কোৱা, ‘কোনো পুৰুষৰ শৰীৰৰ পৰা কোনো ধৰণৰ বৈ থকা সোঁচৰা ৰোগ হ’লে, সেই ৰোগৰ কাৰণে তেওঁ অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","সেই ৰোগ থকাৰ বাবে তেওঁ অশুচি হৈ থাকিব। তেওঁৰ শৰীৰৰ পৰা সেই ৰোগ বৈ থাকক বা বন্ধ হওঁক, তথাপি তেওঁ অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","সেই ৰোগী শোৱা প্ৰত্যেক শয্যা অশুচি আৰু তেওঁ বহা প্ৰত্যেক আসনো অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","যিজনে তেওঁৰ শয্যা চুব, তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু পানীৰে গা ধুব লাগিব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","আৰু সেই ৰোগী বহা আসনত যদি কোনোজনে বহে, তেন্তে তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু পানীত গা ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","আৰু যিজনে সেই ৰোগীৰ গা চুব, তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু পানীত গা ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","সেই ৰোগীয়ে যদি কোনো মানুহৰ গা’ত থুই পেলায়, তেন্তে তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু পানীত গা ধুব লাগিব, এইদৰে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","আৰু সেই ৰোগী যিকোনো বাহনত উঠিব, সেয়ে অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","আৰু যিজনে তেওঁৰ তলত থকা কোনো বস্তু চুব, তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব আৰু যিজনে সেই বস্তু তুলি বৈ নিব, তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","সেই ৰোগীয়ে হাত নোধোৱাকৈ যিজনক চুব, তেওঁ নিজ বস্ত্ৰ ধুব লাগিব, পানীত গা ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","আৰু সেই ৰোগীয়ে যি কোনো মাটিৰ পাত্ৰ চুব, তাক ভাঙি পেলাব লাগিব আৰু সকলো কাঠৰ পাত্ৰ পানীত ধুব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","পাছত সেই ৰোগী যেতিয়া নিজ ৰোগৰ পৰা সুস্থ হ’ব, তেতিয়া তেওঁ নিজ শুচিৰ অৰ্থে, সাত দিন বাট চাই থাকি নিজ বস্ত্ৰ ধুব আৰু বোৱতী পানীত গা ধুব লাগিব; তেতিয়া তেওঁ শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","অষ্টম দিনা তেওঁ নিজৰ কাৰণে দুটা কপৌ বা দুটা পাৰ পোৱালি লৈ, সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ যিহোৱাৰ আগলৈ আহি সেইবোৰ পুৰোহিতক দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","তেতিয়া পুৰোহিতে তাৰ এটা পাপাৰ্থক বলিৰ বলি স্বৰূপে উৎসৰ্গ কৰিব; এইদৰে পুৰোহিতে তেওঁৰ সেই ৰোগৰ কাৰণে যিহোৱাৰ সন্মূখত তাক প্ৰায়শ্চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","যদি কোনো পুৰুষৰ স্বাভাৱিকভাৱে বীৰ্য্যপাত হয়, তেন্তে তেওঁ নিজৰ গোটেই শৰীৰ পানীত ধুব লাগিব আৰু সন্ধিয়ালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","আৰু যিকোনো বস্তুত বা ছালত বীৰ্য্য লাগিলে, তাক পানীত ধুব লাগিব আৰু সেয়ে সন্ধিয়ালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","আৰু কোনো পুৰুষে স্ত্রীৰ সৈতে শয়ন কৰোঁতে যদি বীৰ্য্যপাত হয়, তেওঁলোক দুয়ো পানীত গা ধুব লাগিব আৰু সন্ধিয়ালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","যেতিয়া কোনো মহিলাৰ ঋতুস্রাৱ হয়, তেতিয়া সাত দিনলৈ তেওঁ অশুচি হৈ থাকিব আৰু যিজনে তাইক চুব, সি সন্ধিয়ালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","আৰু সেই অশৌচৰ কালত তেওঁ য’ত শুব, সেই ঠাইও অশুচি হ’ব; আৰু য’ত তেওঁ বহিব, সেইবোৰো অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","আৰু যিজনে তেওঁৰ শয্যা চুব; তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু পানীত গা ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধিয়ালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","আৰু যিজনে তেওঁ বহা আসন চুব, তেওঁ নিজ বস্ত্ৰ ধুব লাগিব আৰু পানীত গা ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","আৰু তাইৰ শয্যাৰ ওপৰত থকা কিবা বস্তু বা যিকোনো বস্তু যদি তেওঁ চোৱে তেন্তে তেওঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","আৰু যদি কোনো পুৰুষে তাইৰে সৈতে শয়ন কৰে আৰু তাইৰ তেজ তেওঁৰ শৰীৰত লাগে, তেন্তে তেওঁ সাত দিনলৈ অশুচি হৈ থাকিব আৰু যিকোনো শয্যাত তেওঁ শুব, সেই শয্যাও অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","আৰু মাহেকীয়া অশৌচৰ কালত ৰক্তস্ৰাৱ নহৈ, যদি অসময়ত কোনো স্ত্রী’ৰ বহু দিনলৈকে ৰক্তস্ৰাৱ হয় বা মাহেকীয়া অশৌচৰ কালত যদি অনেক দিনলৈ ৰক্তস্ৰাৱ হয়, তেন্তে মাহেকীয়া অশৌচৰ কালৰ দৰে, সেই অশুচি ৰক্তস্ৰাৱৰ সকলো দিন তাই অশুচি হৈ থাকিব; তাই অশুচি। ");
INSERT INTO asmfb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","সেই ৰক্তস্ৰাৱৰ সকলো দিন যিকোনো শয্যাত তাই শুব, সেয়ে মাহেকীয়া অশৌচৰ কালৰ দৰে অশুচি হব; আৰু যিকোনো আসনৰ ওপৰত তাই বহিব সেয়ে মাহেকীয়া অশৌচৰ কালৰ অশুচিতাৰ দৰে অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","আৰু যিজনে সেইবোৰ চুব, তেওঁ অশুচি হ’ব আৰু তেওঁ বস্ত্ৰ ধুই পানীত গা ধুব লাগিব আৰু এইদৰে তেওঁ সন্ধিয়ালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","পাছত সেই স্ত্রী ৰক্তস্ৰাৱৰ পৰা সুস্থ হ’লে, তাই সাত দিন থাকিব; তাৰ পাছত তাই শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","পাছত অষ্টম দিনা, তাই নিজৰ কাৰণে দুটা কপৌ বা দুটা পাৰ পোৱালি লৈ, সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ পুৰোহিতৰ ওচৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","পুৰোহিতে তাৰ এটা পাপাৰ্থক বলি স্বৰূপে আৰু আনটো হোম-বলিস্বৰূপে উৎসৰ্গ কৰিব; এইদৰে তাই অশুচি ৰক্তস্ৰাৱৰ কাৰণে পুৰোহিতে যিহোৱাৰ সন্মূখত তাইক প্ৰায়শ্চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","ইস্ৰায়েলৰ সন্তান সকলে তাৰ মাজত থকা মোৰ আৱাস অশুচি কৰি তেওঁলোকে নিজ নিজ অশৌচৰ কাৰণে নমৰিবলৈ এইদৰে তোমালোকে তেওঁলোকক নিজ নিজ অশৌচৰ পৰা পৃথক কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","গা’ৰ পৰা কিবা বৈ থকা ৰোগী, বীৰ্য্যপাতৰ অশুচি হোৱা লোক, ");
INSERT INTO asmfb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ৰজস্বলা হোৱা কোনো পুৰুষ বা মহিলাৰ শৰীৰৰ পৰা যদি কোনো তৰল পদাৰ্থ বৈ থাকে, আৰু অশুচি স্ত্রী’ৰে সৈতে শয়নকাৰী পুৰুষ, এই লোকসকলৰ বাবে এই নিয়ম’।” ");
INSERT INTO asmfb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","হাৰোণৰ যি দুজন পুত্ৰ যিহোৱাৰ ওচৰলৈ গ’ল, তেওঁলোকৰ মৃত্যুৰ পাছত যিহোৱাই মোচিক কৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","যিহোৱাই মোচিক এই কথা ক’লে, “হাৰোণ নমৰিবৰ বাবে, চন্দুকৰ ওপৰত থকা পাপাবৰণৰ সন্মূখলৈ প্ৰভেদক বস্ত্ৰৰ ভিতৰৰ পবিত্ৰ-স্থানলৈ সকলো সময়ত নোসোমাবৰ বাবে আজ্ঞা কৰা; কিয়নো মই পাপাবৰণৰ ওপৰত মেঘত দৰ্শন দিম। ");
INSERT INTO asmfb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","হাৰোণে এইদৰে পবিত্ৰ স্থানত সোমাব লাগিব। তেওঁ পাপাৰ্থক বলিৰ বাবে এটা দমৰা গৰু আৰু হোমৰ অৰ্থে এটা মতা মেৰ লগত ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","তেওঁ শণ সুতাৰ পবিত্ৰ বস্ত্ৰখন গাত লব, শণৰ জাঙিয়াটো পিন্ধিব, শণৰ টঙালি গছ কঁকালত বান্ধিব আৰু পাগটো পিন্ধিব। এইবোৰ পবিত্ৰ বস্ত্ৰ; তেওঁ পানীত গা ধুই, এইবোৰ পিন্ধিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","পাছত তেওঁ ইস্ৰায়েলৰ সন্তান সকলৰ সমাজৰ পৰা পাপাৰ্থক বলি উৎসৰ্গ কৰিবলৈ দুটা ছাগলী আৰু হোমৰ অৰ্থে এটা মতা মেৰ ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","আৰু হাৰোণে পাপাৰ্থক বলিৰ বাবে দমৰা গৰুটো আনি, নিজক আৰু নিজ বংশক প্ৰায়শ্চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","তেতিয়া তেওঁ নিশ্চয়কৈ ছাগলী দুটা ল’ব আৰু সাক্ষাৎ কৰা তম্বুৰ দুৱাৰমুখত যিহোৱাৰ আগত উপস্থিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","তেতিয়া হাৰোণে সেই দুটা ছাগলীৰ বিষয়ে চিঠি খেলিব; এটা গুটি যিহোৱাৰ বাবে, আনটো অজাজেলৰ বাবে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","তেতিয়া যি ছাগলী যিহোৱাৰ নামত উঠিব, হাৰোণে সেই ছাগলীটো লৈ পাপাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","কিন্তু যি ছাগলীৰ অৰ্থে অজাজেলৰ নামত গুটি উঠিব, তাক অজাজেললৈ অৰ্থাৎ ভিতৰলৈ পঠিয়াবৰ কাৰণে, তাৰ প্ৰায়শ্চিত্ত কৰিবলৈ যিহোৱাৰ সন্মূখত তাক জীয়াই উপস্থিত কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","তেতিয়া হাৰোণে নিজৰ বাবে লোৱা পাপাৰ্থক বলিৰ দমৰা গৰুটো আনি নিজক আৰু নিজ বংশক প্ৰায়শ্চিত্ত কৰিব। তেওঁ নিজৰ বাবে লোৱা সেই পাপাৰ্থক বলিৰ বাবে অনা দমৰা গৰুটো কাটিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","হাৰোনে যিহোৱাৰ সন্মুখত থকা বেদীৰ ওপৰৰ পৰা জ্বলা আঙঠাৰে এটা আঙঠা-ধৰাত ভৰাই ল’ব আৰু মিহিকৈ গুড়ি কৰা দুমুঠি সুগন্ধি ধূপ লৈ প্ৰভেদক বস্ত্ৰৰ ভিতৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","আৰু তেওঁ নমৰিবলৈ সাক্ষ্য ফলিৰ চন্দুকৰ ওপৰত থকা পাপাবৰণক যেন ধূপৰ ধোঁৱাই ঢাকে, এই কাৰণে সেই সুগন্ধি ধূপ যিহোৱাৰ সন্মূখত থকা জুইত দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","তেতিয়া তেওঁ সেই দমৰাৰ অলপমান তেজ লৈ, পূবফালে থকা পাপাবৰণত আঙুলিৰে ছঠিয়াব আৰু আঙুলিৰে পাপাবৰণৰ সন্মুখতো সেই তেজৰ কিছু লৈ সাতবাৰ ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","তেতিয়া তেওঁ লোকসকলৰ পাপাৰ্থক বলিৰ ছাগলীটো কাটি, তাৰ তেজ প্ৰভেদক বস্ত্ৰৰ ভিতৰলৈ আনিব আৰু দমৰাৰ তেজ লৈ যেনেকৈ কৰিছিল, তেনেকৈ ইয়াৰ তেজকো কৰিব, অৰ্থাৎ পাপাবৰণত আৰু পাপাবৰণৰ সন্মূখত তাক ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","এইদৰে, ইস্ৰায়েলৰ সন্তান সকলৰ সকলো প্ৰকাৰ অশৌচ আৰু অপৰাধৰ কাৰণে, তেওঁলোকৰ আটাই পাপৰ কাৰণেই তেওঁ পবিত্ৰ স্থান প্ৰায়শ্চিত্ত কৰিব; আৰু যি সাক্ষাৎ কৰা তম্বু তেওঁলোকৰ লগত তেওঁলোকৰ সকলো প্ৰকাৰ অশৌচৰ মাজত আছে তাকো সেইদৰে কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","আৰু প্ৰায়শ্চিত্ত কৰিবলৈ পবিত্ৰ স্থানত তেওঁ সোমোৱাৰে পৰা নিজক, নিজ বংশক আৰু ইস্ৰায়েলৰ গোটেই সমাজক প্ৰায়শ্চিত্ত সম্পূৰ্ণকৈ প্ৰায়শ্চিত্ত নকৰালৈকে, কোনো কোনো লোক সেই সাক্ষাৎ কৰা তম্বুত নাথাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","তেওঁ যিহোৱাৰ সন্মূখত থকা বেদীৰ ওচৰলৈ ওলাই গৈ তাক প্ৰায়শ্চিত্ত কৰিব। তেওঁ সেই দমৰাটোৰ অলপ তেজ আৰু ছাগলীটোৰ অলপ তেজ লৈ বেদীৰ চাৰিওফালৰ শিং কেইটাত লগাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","আৰু তেওঁ নিজ আঙুলিৰে তেজৰ কিছু লৈ তাৰ ওপৰত সাতবাৰ ছটিয়াই তাক শুচি কৰিব আৰু ইস্ৰায়েলৰ সন্তান সকলৰ সকলো প্ৰকাৰৰ অশৌচৰ পৰা শুচি কৰি তাক পবিত্ৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","এইদৰে পবিত্ৰ স্থান, সাক্ষাৎ কৰা তম্বু আৰু বেদী প্ৰায়শ্চিত্ত কৰাৰ পাছত, হাৰোণে সেই জীয়া ছাগলীটো আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","পাছত তেওঁ তেওঁৰ হাত দুখন সেই জীয়া ছাগলীটোৰ মুৰত দিব; আৰু ইস্ৰায়েলৰ সন্তান সকলৰ সকলো অপৰাধ আৰু তেওঁলোকৰ আটাই অধৰ্ম, তেওঁলোকৰ সকলো পাপ তাৰ ওপৰত স্বীকাৰ কৰি, তেওঁ সেই সকলোকে সেই ছাগলীৰ মুৰত অৰ্পণ কৰিব। পাছে যুগুতে থকা মানুহ এটাৰ হতুৱাই তাক মৰুভূমিলৈ পঠিয়াই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","আৰু ছাগলীটোৱে নিজৰ ওপৰত তেওঁলোকৰ সকলো অপৰাধ নিৰ্জ্জন ঠাইলৈ বৈ নিব। আৰু তাত সেই লোকে সেই ছাগলীটো মৰুভূমিত এৰি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","তেতিয়া হাৰোণে সাক্ষাৎ কৰা তম্বুত সোমাব আৰু পবিত্ৰ স্থানত সোমোৱা সময়ত যি শণৰ বস্ত্ৰবোৰ পিন্ধে তাক সোলোকাই সেই ঠাইতে থ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","পাছত তেওঁ কোনো পবিত্ৰ ঠাইত গা ধুই, নিজ বস্ত্ৰ পিন্ধি ওলাব; আৰু নিজৰ হোম-বলি উৎসৰ্গ কৰি নিজক আৰু লোকসকলক প্ৰায়শ্চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","আৰু পাপাৰ্থক বলিটোৰ তেলখিনি বেদীত দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","আৰু যিজনে অজাজেলৰ কাৰণে ছাগলীটো এৰি দিব, তেওঁ নিজ বস্ত্ৰ আৰু গা ধুব আৰু তাৰ পাছত ছাউনিত সোমাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","আৰু পাপাৰ্থক বলিৰ অর্থে যি দমৰা গৰু আৰু পাপাৰ্থক বলিৰ অৰ্থে যি ছাগলী, যিবোৰৰ তেজ প্ৰায়শ্চিত্ত কৰিবৰ বাবে পবিত্ৰ স্থানৰ ভিতৰলৈ অনা হ’ব আৰু সেইবোৰৰ ছাল, মঙহ আৰু গোবৰ জুইত পুৰি ভস্ম কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","আৰু যিজনে সেইবোৰ পুৰিব, তেওঁ নিজ বস্ত্ৰ ধুব, পানীত গা ধুব আৰু তাৰ পাছত ছাউনিত সোমাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","তোমালোকৰ বাবে চিৰস্থায়ী বিধি এই। সপ্তম মাহৰ দশম দিনা স্বদেশীয় হওঁক বা তোমালোকৰ মাজত বাস কৰা বিদেশীয়েই হওঁক, তোমালোক সকলোৱেই নিজ নিজ প্ৰাণক দুখ দি লঘোন দিবা আৰু কোনো কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","কিয়নো সেই দিনা তোমালোকক শুচি কৰিবৰ অৰ্থে তোমালোকক প্ৰায়শ্চিত্ত কৰা হ’ব; আৰু তোমালোক সকলোৱেই পাপৰ পৰা যিহোৱাৰ সাক্ষাতে শুচি হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","সেয়েই তোমোলোকৰ সম্পূর্ণ বিশ্ৰামৰ বিশ্ৰাম-দিন; তোমালোকে নিজ নিজ প্ৰাণত দুখ দি লঘোন দিবা। এইয়েই তোমালোকৰ মাজত চিৰস্থায়ী বিধি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","পিতৃৰ সলনি পুৰোহিত কৰ্ম কৰিবলৈ যিজনক অভিষিক্ত আৰু নিযুক্ত কৰা হ’ব, সেই পুৰোহিতে প্ৰায়শ্চিত্ত কৰিব আৰু শণ সুতাৰ বস্ত্ৰ অৰ্থাৎ পবিত্ৰ বস্ত্ৰবোৰ পিন্ধিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","আৰু তেওঁ পবিত্ৰ-স্থান প্ৰায়শ্চিত্ত কৰিব, সাক্ষাৎ কৰা তম্বু আৰু বেদী প্ৰায়শ্চিত্ত কৰিব। আৰু পুৰোহিতসকলৰ আৰু গোটেই সমাজৰ বাবে প্রায়শ্চিত্ত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ইস্ৰায়েলৰ সন্তান সকল, তেওঁলোকৰ সকলো পাপৰ কাৰণে বছৰৰ ভিতৰত এবাৰ প্ৰায়শ্চিত্ত কৰাটোৱেই তোমালোকৰ বাবে চিৰস্থায়ী বিধি হ’ব।” তেতিয়া হাৰোণে মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰেই কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“তুমি হাৰোণক, তেওঁৰ পুত্ৰসকলক আৰু ইস্ৰায়েলৰ সন্তান সকলক এই কথা কোৱা; এই বিষয়ে যিহোৱাই আজ্ঞা কৰি কৈছে, ");
INSERT INTO asmfb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","‘ইস্ৰায়েলৰ বংশৰ যি কোনো লোক এজনে গৰু, মেৰ-ছাগ বা ছাগলী, ছাউনিৰ ভিতৰত বা ছাউনিৰ বাহিৰত, যিহোৱাৰ উদ্দেশ্যে উপহাৰ স্বৰূপে উৎসৰ্গ কৰে- ");
INSERT INTO asmfb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","কিন্তু তেওঁ যদি সেই উপহাৰ যিহোৱাৰ আবাসৰ সন্মুখত সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ নানে, তেতিয়া সেই লোকজনলৈ ৰক্তপাতৰ দোষ গণিত হ’ব; সেই লোকজনে ৰক্তপাত কৰাত, তেওঁক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ইয়াৰ অভিপ্ৰায় এই, যে, ইস্ৰায়েলৰ সন্তান সকলে মুকলি পথাৰত যি যি পশু বলিদান কৰে, সেই সকলোকে তেওঁলোকে যেন সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ যিহোৱাৰ উদ্দেশ্যে পুৰোহিতৰ ওচৰলৈ আনি, যিহোৱাৰ উদ্দেশ্যে মঙ্গলাৰ্থক বলি স্বৰূপে উৎসৰ্গ কৰে। ");
INSERT INTO asmfb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","পুৰোহিতে সেই মঙ্গলাৰ্থক বলিৰ তেজ সাক্ষাৎ কৰা তম্বুৰ দুৱাৰমুখত যিহোৱাৰ বেদীৰ ওপৰত ছটিয়াব আৰু তাৰ তেলখিনি সুঘ্ৰাণৰ অৰ্থে যিহোৱাৰ উদ্দেশ্যে দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","তেওঁলোকে যি ছাগলীৰ মূর্তিৰ অনুগামী হৈ ব্যভিচাৰ কৰি আহিছে, সেইবোৰৰ উদ্দেশ্যে আৰু বলিদান কৰিব নালাগে। এয়ে তেওঁলোকৰ পুৰুষানুক্ৰমে পালন কৰিবলগীয়া চিৰস্থায়ী বিধি হ’ব’। ");
INSERT INTO asmfb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","আৰু তুমি তেওঁলোকক কোৱা, ‘ইস্ৰায়েল-বংশীয় যি কোনো লোক বা তেওঁলোকৰ মাজত প্ৰবাস কৰা যি কোনো বিদেশী জনে নিজৰ হোম-বলি বা মঙ্গলাৰ্থক বলি, ");
INSERT INTO asmfb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিবলৈ সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখলৈ ননাকৈ উৎসৰ্গ কৰিব, সেই লোকজন নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ইস্ৰায়েল বংশীয় যিকোনো লোক এজনে বা তেওঁলোকৰ মাজত প্ৰবাস কৰা যি কোনো বিদেশীয়ে কোনো প্ৰকাৰৰ তেজ খাব, মই সেই তেজ খোৱা জনৰ পৰা বিমুখে থাকিম আৰু তেওঁৰ লোকসকলৰ মাজৰ পৰা তেওঁক উচ্ছন্ন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","কিয়নো শৰীৰৰ প্ৰাণ তেজত থাকে; আৰু তোমালোকৰ প্ৰাণ প্ৰায়শ্চিত্ত কৰিবৰ অৰ্থে মই সেই তেজ বেদীৰ ওপৰত দিবলৈ তোমালোকক দিলোঁ; কিয়নো প্ৰাণৰ গুণে তেজেই প্ৰায়শ্চিত্ত সাধক! ");
INSERT INTO asmfb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","এই হেতুকে মই ইস্ৰায়েলৰ সন্তান সকলক ক’লো বোলে, তোমালোকৰ মাজৰ কোনেও তেজ খাব নালাগে আৰু তোমালোকৰ মাজত প্ৰবাস কৰা কোনো বিদেশীয়েও তেজ খাব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","আৰু ইস্ৰায়েলৰ সন্তান সকলৰ মাজত যি কোনো লোক বা তেওঁলোকৰ মাজত প্ৰবাস কৰা যি কোনো বিদেশীয়ে কোনো খাব পৰা পশু বা চৰাই চিকাৰত মাৰিব, তেওঁ তাৰ তেজ উলিয়াই ধুলিৰে ঢাকি থ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","কিয়নো প্ৰত্যেক প্ৰাণীৰ প্ৰাণ তেজত থাকে; এই হেতুকে মই ইস্ৰায়েলৰ সন্তান সকলক ক’লোঁ, “তোমালোকে কোনো প্ৰাণীৰ তেজ নাখাবা; কিয়নো প্ৰত্যেক প্ৰাণীৰ তেজেই তাৰ প্ৰাণ; যিকোনোৱে তাক খাব, তেওঁ উচ্ছন্ন হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","স্বদেশীয় বা বিদেশীয় লোকসকলৰ মাজৰ যি কোনোৱে নিজে নিজেই মৰা, বা হিংসুক জন্তুৱে ছিৰা পশু ভোজন কৰিব তেওঁ নিজ বস্ত্ৰ ধুই পানীত গা ধুব আৰু সন্ধ্যালৈকে তেওঁ অশুচি হৈ থাকিব; তাৰ পাছত তেওঁ শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","কিন্তু যদি তেওঁ নিজ বস্ত্ৰ বা গা নুধোৱে, তেতিয়া তেওঁ নিজ অপৰাধৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক এই কথা কোৱা, ‘মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","তোমালোকে যেতিয়া মিচৰ দেশত বাস কৰিছিলা, সেই দেশৰ ৰীতি-নীতিৰ দৰে আচৰণ নকৰিবা। মই তোমালোকক যি কনান দেশলৈ লৈ আহিম, সেই দেশৰ ৰীতি-নীতিৰ দৰে আচৰণ নকৰিবা আৰু তেওঁলোকৰ বিধি অনুসাৰেও নচলিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","তোমালোকে মোৰ শাসন প্ৰণালী মতে কাৰ্য কৰিবা আৰু মোৰ বিধিবোৰ পালন কৰিবা, আৰু সেইদৰে আচৰণ কৰিবা; কিয়নো মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","এই হেতুকে তোমালোকে মোৰ বিধি আৰু শাসন প্ৰাণালীবোৰ সকলোকে পালন কৰিবা। কোনো এজন লোকে যদি সেইবোৰ পালন কৰে, তেনেহলে তেওঁ তাৰ দ্বাৰাই জীয়াই থাকিব। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","তোমালোকে কোনেও উলঙ্গতা অনাবৃত কৰিবলৈ, নিজ বংশ পৰিয়ালৰ কাৰো ওচৰলৈ নাযাবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","তুমি নিজ পিতৃক, তোমাৰ মাতৃৰ উলঙ্গতাৰেই অনাবৃত নকৰিবা; তেওঁ তোমাৰ মাতৃ; তেওঁক লজ্জিত নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","তোমাৰ পিতৃৰ ভাৰ্য্যাৰ উলঙ্গতা অনাবৃত নকৰিবা; সেইদৰে তোমাৰ পিতৃক লজ্জিত নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","তোমাৰ বাই, ভনী, তোমাৰ পিতৃৰ জীয়েক বা তোমাৰ মাতৃৰ জীয়েক, ঘৰত জন্মাই হওঁক বা আন ঠাইতে জন্মা হওঁক, তেওঁলোকৰ উলঙ্গতা অনাবৃত নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","তোমাৰ পো-নাতিয়েৰ বা জী-নাতিয়েৰ উলঙ্গতা অনাবৃত নকৰিবা; কিয়নো তেওঁলোকৰ উলঙ্গতা তোমাৰ নিজৰেই উলঙ্গতা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","তোমাৰ পিতৃৰ ঔৰসত জন্মা তোমাৰ পিতৃৰ ভাৰ্য্যাৰ জীয়েকৰ উলঙ্গতা অনাবৃত নকৰিবা; তাই তোমাৰ ভনী। ");
INSERT INTO asmfb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","তোমাৰ পিতৃৰ বায়েক বা ভনীয়েকৰ উলঙ্গতা অনাবৃত নকৰিবা; তাই তোমাৰ পিতৃৰ ওচৰ সম্বন্ধীয়া। ");
INSERT INTO asmfb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","তোমাৰ মাতৃৰ বায়েক বা ভনীয়েকৰ উলঙ্গতা অনাবৃত নকৰিবা; কিয়নো তাই তোমাৰ মাতৃৰ ওচৰ সম্বন্ধীয়া। ");
INSERT INTO asmfb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","তোমাৰ পিতৃৰ ককায়েক বা ভায়েকৰ উলঙ্গতা অনাবৃত নকৰিবা; তুমি তেওঁৰ ভাৰ্য্যাৰ ওচৰলৈ নাযাবা; তাই তোমাৰ বৰমা, বা খুৰী। ");
INSERT INTO asmfb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","তোমাৰ বোৱাৰীয়েৰ উলঙ্গতা অনাবৃত নকৰিবা; কিয়নো তাই তোমাৰ পো’ৰ ভাৰ্য্যা। তাইৰ উলঙ্গতা অনাবৃত নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","তোমাৰ ককায়েৰা বা ভায়েৰাৰ ভাৰ্যাৰ উলঙ্গতা অনাবৃত নকৰিবা; সেয়ে তোমাৰ ককায়েৰা বা ভায়েৰাৰ উলঙ্গতা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","কোনো মহিলা আৰু তাইৰ জীয়েকৰ উলঙ্গতা অনাবৃত নকৰিবা; উলঙ্গতা অনাবৃত কৰিবলৈ তাইৰ পো-নাতিয়েক বা জী-নাতিয়েকক বিয়া নকৰিবা। তেওঁলোক ওচৰ সম্বন্ধীয়া; এইয়ে লম্পটতা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","নিজ তিৰোতাৰ সতিনী খটাবলৈ তাই জীয়াই থকা কালত, উলঙ্গতা অনাবৃত কৰিবৰ অৰ্থে তাইৰ লগত বায়েক বা ভনীয়েকক বিয়া নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","আৰু কোনো মহিলাৰ মাহেকীয়া অশৌচেৰে অশুচি হৈ থকা সময়ত, তাইৰ উলঙ্গতা অনাবৃত কৰিবলৈ তাইৰ ওচৰলৈ নাযাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","আৰু তুমি নিজকে অশুচি কৰিবলৈ ওচৰ-চুবুৰিয়াৰ ভাৰ্য্যাৰ লগত সহবাস নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","তোমাৰ সন্তানৰ কাকো মোলক দেৱতাৰ উদ্দেশ্যে অগ্নিৰ মাজেদি গমণ কৰাই, তোমাৰ ঈশ্বৰৰ নাম অপবিত্ৰ নকৰিবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","তুমি মহিলাৰ লগত শয়ন কৰাৰ দৰে পুৰুষে সৈতে শয়ন নকৰিবা। সেয়ে ঘিণলগীয়া কৰ্ম। ");
INSERT INTO asmfb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","আৰু তুমি নিজকে অশুচি কৰিবলৈ, কোনো জন্তুত পতিত নহ’বা; আৰু কোনো মহিলাই নিজৰে সৈতে সংসৰ্গ কৰিবলৈ, কোনো জন্তুৰ আগত থিয় নহ’ব, সেয়ে স্বভাৱৰ বিৰুদ্ধে কৰা কাৰ্য। ");
INSERT INTO asmfb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","তোমালোকে এই কার্যবোৰৰ ভিতৰৰ কোনো কাৰ্যৰ দ্বাৰাই নিজকে অশুচি নকৰিবা; কিয়নো যি যি জাতিক মই তোমালোকৰ সন্মুখৰ পৰা খেদিম, তেওঁলোক এই সকলো কৰ্মৰ দ্বাৰাই অশুচি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","আৰু সেই দেশখনো অশুচি হ’ল; এই হেতুকে মই তাৰ অপৰাধৰ ফল তাক ভোগ কৰালো আৰু সেই দেশে নিজ নিবাসীসকলক বতিয়াই পেলালে। ");
INSERT INTO asmfb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","এই হেতুকে তোমালোকে মোৰ বিধি আৰু শাসন প্ৰণালীবোৰ পালন কৰিবা, আৰু স্বদেশীয় বা তোমালোকৰ মাজত প্ৰবাস কৰা বিদেশীয়েই হওঁক, তোমালোকে সেই সকলো ঘিণলগীয়া কাৰ্যৰ মাজৰ কোনো কাৰ্য নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","কিয়নো তোমালোকৰ পূৰ্বে থকা লোকসকলে এই সকলো ঘিণলগীয়া কৰ্ম কৰাত সেই দেশ অশুচি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","কিয়নো সাৱধান, তোমালোকে সেই দেশ অশুচি কৰিলে, তোমালোকৰ পূৰ্বে থকা সেই জাতিক বতিয়াই পেলোৱাৰ নিচিনাকৈ, সেই দেশে তোমালোককো বতিয়াই পেলাব। ");
INSERT INTO asmfb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","কিয়নো যি যি লোকে এইবোৰ ঘিণলগীয়া কাৰ্যৰ মাজৰ কোনো কাৰ্য কৰিব, ঘিণলগীয়া কাৰ্য কৰা সেই সকলোকে নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","এই হেতুকে তোমালোকৰ পূৰ্বে প্ৰচলিত হোৱা ঘিণলগীয়া ৰীতি-নীতিবোৰৰ মাজৰ একোকে তোমালোকে যেন নকৰা, আৰু তাৰ দ্বাৰাই নিজকে যেন অশুচি নকৰা, এই কাৰণে মোৰ আজ্ঞা পালন কৰিবা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“তুমি ইস্ৰায়েলৰ সমুদায় মণ্ডলীক এই কথা কোৱা, ‘তোমালোক পবিত্ৰ হ’ব লাগে; কিয়নো মই তোমালোকৰ যি ঈশ্বৰ যিহোৱা, মই পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","তোমালোকে প্ৰতিজনে নিজ নিজ মাতৃ আৰু নিজ নিজ পিতৃক সন্মান কৰিবা আৰু মোৰ বিশ্ৰাম দিনবোৰ পালন কৰিবা। মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","তোমালোকে প্ৰতিমাবোৰৰ ফালে মূৰ নুঘূৰাবা আৰু তোমালোকৰ কাৰণে সাঁচত ঢলা মূৰ্ত্তি নিৰ্ম্মাণ নকৰিবা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","যেতিয়া তোমালোকে যিহোৱাৰ উদ্দেশ্যে মঙ্গলাৰ্থক বলি উৎসৰ্গ কৰিবা, তেতিয়া তোমালোকে গ্রহণ হ’বৰ কাৰণে ইয়াকে কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","তোমালোকে তাক উৎসৰ্গ কৰা দিনা বা তাৰ পাছদিনা তাক ভোজন কৰিব লাগিব; তৃতীয় দিনলৈ যদি অৱশিষ্ট থাকে, তেন্তে তাক জুইত পুৰি ভস্ম কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","তৃতীয় দিনা যদি কেনেবাকৈ তাৰ অলপ খোৱা যায়, তেন্তে সেয়ে ঘিণলগীয়া আৰু অগ্ৰাহ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","কিন্তু ভোজন কৰা জনে নিজ অপৰাধৰ ফল ভোগ কৰিব, কিয়নো তেওঁ যিহোৱাৰ পবিত্ৰ বস্তু অপবিত্ৰ কৰিলে, সেই লোক জনক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","যেতিয়া তোমালোকে নিজ নিজ ভুমিত উৎপন্ন হোৱা শস্য দাবৰ সময়ত, খেতিৰ চুকত থকা শস্য সম্পূৰ্ণৰূপে শেষ নকৰাকৈ নাদাবা আৰু তোমাৰ খেতিৰ এৰি যোৱা শস্য নুবুটলিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","আৰু নিজ নিজ দ্ৰাক্ষাবাৰীৰ এৰি যোৱা দ্ৰাক্ষাফল নিছিঙিবা আৰু দ্ৰাক্ষাবাৰীৰ সৰি পৰা দ্ৰাক্ষাফল নুবুটলিবা; তুমি দুখীয়া আৰু বিদেশীৰ কাৰণে তাক এৰি যাবা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","তোমালোকে চুৰ নকৰিবা। মিছা কথা নকবা। আৰু ইজনে সিজনক নঠগাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","আৰু তুমি মোৰ নাম লৈ মিছা শপত খাই তোমাৰ ঈশ্বৰৰ নাম অপবিত্ৰ নকৰিবা। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","তুমি নিজ চুবুৰীয়াক অত্যাচাৰ নকৰিবা আৰু তেওঁৰ বস্তু অপহৰণ নকৰিবা; বেচলৈ কাম কৰা চাকৰৰ বেচ গোটেই ৰাতি নিদিয়াকৈ থাকি ৰাতিপুৱালৈ নাৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","তুমি কলাক শাও নিদিবা আৰু অন্ধৰ আগত উজুতি খোৱা মুঢ়া নথবা, কিন্তু তোমাৰ ঈশ্বৰলৈ ভয় ৰাখিবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","তোমালোকে বিচাৰত অন্যায় নকৰিবা; বিচাৰত তুমি দুখীয়াৰ মুখলৈ নাচাবা আৰু সম্ভ্ৰান্ত লোকক সমাদৰ নকৰিবা; কিন্তু তুমি ধাৰ্মিক ভাৱে নিজ চুবুৰীয়াৰ বিচাৰ নিস্পত্তি কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","তুমি নিজ লোকসকলৰ মাজত চৰ্চ্চি ফুৰোঁতা নহ’বা; আৰু তোমাৰ ওচৰ চুবুৰীয়াৰ বিৰুদ্ধে প্রাণ হত্যাকাৰী নহ’বা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","তুমি নিজ ভাইক নিজ মনত ঘিণ নকৰিবা; তুমি নিজ চুবুৰীয়াক চুবুৰীয়াৰ কাৰণে পাপৰ ভাৰ নব’বলৈ, অৱশ্যে তেওঁক সতৰ্ক কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","তুমি নিজ সন্তান সকলৰ প্ৰতিকাৰ নাসাধিবা বা তেওঁলোকৰ বিৰুদ্ধে আখেজ নাৰাখিবা; কিন্তু নিজ ওচৰ-চুবুৰীয়াক নিজৰ নিচিনাকৈ প্ৰেম কৰিবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","তোমালোকে মোৰ বিধিবোৰ পালন কৰিবা। তোমাৰ পশুৰে সৈতে, তুমি বেলেগ বেলেগ প্ৰজাতিৰ পশুৰ জাকক ফুৰিবলৈ চেষ্টা কৰিব নিদিবা। তোমাৰ পথাৰত একেডোখৰ মাটিত দুবিধ শস্যৰ গুটি নিসিঁচিবা; আৰু দুই প্ৰকাৰ সুতা মিহলি কৰি বোৱা বস্ত্ৰ নিপিন্ধিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ধনেৰে বা আন ৰূপে মুক্ত নোহোৱা এনে যি বাগদান কৰা বেটী, তাইৰে সৈতে যদি কোনোৱে শয়ন কৰে, তেন্তে তেওঁলোক দুয়ো দণ্ডনীয় হ’ব, কিন্তু তেওঁলোকৰ প্ৰাণদণ্ড নহ’ব; কিয়নো তাই মুক্ত হোৱা নাই। ");
INSERT INTO asmfb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","তেতিয়া সেই পুৰুষে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ, যিহোৱাৰ উদ্দেশ্যে নিজৰ দোষাৰ্থক বলিৰ কাৰণে এটা মতা মেৰ-ছাগ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","তেতিয়া পুৰোহিতে যিহোৱাৰ সাক্ষাতে সেই দোষাৰ্থক মেৰ-ছাগটোৰ দ্বাৰাই, তেওঁ কৰা পাপৰ কাৰণে তেওঁক প্ৰায়শ্চিত্ত কৰিব; তেতিয়া তেওঁ কৰা সেই পাপৰ ক্ষমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","তোমালোকে যেতিয়া দেশত সোমাই, খাদ্যৰ অৰ্থে সকলো প্ৰকাৰ গছ ৰুবা, তেতিয়া তাৰ ফল নিষিদ্ধ যেন গণ্য কৰিবা আৰু তিনি বছৰলৈকে সেয়ে তোমালোকৰ মানত নিষিদ্ধ হৈ থাকিব। তাক খাব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","পাছত চতুৰ্থ বছৰত তাৰ সকলো ফল যিহোৱাৰ প্ৰশংসাৰ্থক উপহাৰ স্বৰূপে পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","আৰু গছে ফল উৎপন্ন কৰি থাকিবৰ কাৰণে, তোমালোকে পঞ্চম বছৰত তাৰ ফল খাবা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","তোমালোকে তেজেৰে সৈতে একো মঙহ নাখাবা। শুভ অশুভ লক্ষণ নামানিবা আৰু গণকৰ বিদ্যা ব্যৱহাৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","তোমালোকে নিজ নিজ মূৰৰ চুলি ঘুৰণীয়াকৈ নাকাটিবা আৰু নিজ নিজ দাড়িৰ চুক অশুৱনীকৈ নুখুৰাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","আৰু মৰা লোকৰ কাৰণে তোমালোকে নিজ গা কাট-কুট নকৰিবা আৰু গাত কাটি বা বিন্ধি দাগ নলগাবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","তুমি নিজ জীয়েৰাক বেশ্যা হ’বলৈ দি তাইক ভ্ৰষ্ট নকৰিবা; কিয়নো তেনে কৰিলে দেশ ব্যভিচাৰত পতিত হ’ব আৰু দেশ দুষ্টতাৰে পৰিপূৰ্ণ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","তোমালোকে মোৰ বিশ্ৰাম দিন পালন কৰিবা আৰু মোৰ ধৰ্মধামলৈ ভয় ৰাখিবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ভূত পোহা আৰু গুণ-মন্ত্ৰ জনাসকলৰ ফালে মুখ নকৰিবা; নিজকে অশুচি কৰিবৰ কাৰণে তেওঁলোকক সুধিবলৈ তেওঁলোকৰ ওচৰলৈ নাযাবা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","তুমি পকামুৰীয়া জনৰ আগত উঠি থিয় হ’বা, বৃদ্ধলোকক সমাদৰ কৰিবা আৰু নিজ ঈশ্বৰলৈ ভয় ৰাখিবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","আৰু কোনো বিদেশী লোকে যদি তোমালোকৰ দেশত তোমালোকৰে সৈতে বাস কৰে, তেন্তে তোমালোকে তাক উপদ্ৰৱ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","তোমালোকৰ মাজত স্বদেশীয় লোক যেনে, তোমালোকৰ মাজত প্ৰবাস কৰা বিদেশী লোকো তোমালোকৰ পক্ষে তেনে হ’ব আৰু তুমি সেই লোকসকলক নিজৰ নিচিনাকৈ প্ৰেম কৰিবা; কাৰণ মিচৰ দেশত তোমালোকো বিদেশী আছিলা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","তোমালোকে বিচাৰত, পৰিমাণত বা ওজনত বা দ্ৰব্যৰ জোখত অন্যায় নকৰিবা; ");
INSERT INTO asmfb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","তোমালোকে সঠিক পাল্লা, সঠিক দগা, ঠিক ঐফা আৰু ঠিক হীন ৰাখিবা; মিচৰ দেশৰ পৰা তোমালোকক উলিয়াই অনা তোমালোকৰ ঈশ্বৰ যিহোৱা ময়েই। ");
INSERT INTO asmfb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","এতেকে তোমালোকে মোৰ সকলো বিধি আৰু সকলো শাসন-প্ৰণালী পালন কৰি, সেই অনুসাৰে আচৰণ কৰিবা। মই যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","পাছে যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক পুনৰ কোৱা, ‘ইস্ৰায়েলৰ সন্তান সকলৰ যিকোনোৱে বা ইস্ৰায়েলৰ মাজত প্ৰবাস কৰা যিকোনো বিদেশীয়ে নিজ সন্তানৰ কোনো এজনক মোলক দেৱতাৰ উদ্দেশ্যে দান কৰিব, তেওঁৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। দেশীয় লোকসকলে তেওঁক শিল দলিয়াই বধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ময়ো সেই লোকলৈ কোন্দোৱাকৈ চাই তেওঁৰ লোকসকলৰ মাজৰ পৰা তেওঁক উচ্ছন্ন কৰিম; কাৰণ মোৰ ধৰ্মধাম অশুচি কৰিবলৈ আৰু মোৰ পবিত্ৰ নাম অপবিত্ৰ কৰিবলৈ, তেওঁ নিজ সন্তানৰ কোনো এজনক মোলক দেৱতাৰ উদ্দেশ্যে দান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","আৰু যি সময়ত সেই মানুহে নিজ সন্তানৰ কোনো এজনক মোলক দেৱতাৰ উদ্দেশ্যে দান কৰে, সেই সময়ত যদি দেশীয় লোকসকলে সেই মানুহৰ কাৰ্যলৈ চকু মুদে আৰু তেওঁক বধ নকৰে, ");
INSERT INTO asmfb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","তেন্তে ময়েই সেই মানুহলৈ আৰু তেওঁৰ গোষ্ঠীলৈ কোন্দোৱাকৈ চাই তেওঁক আৰু মোলক দেৱতাৰে সৈতে ব্যভিচাৰ কৰিবৰ অৰ্থে তেওঁৰ অনুগামী হোৱা আটাই ব্যভিচাৰীক আৰু তেওঁলোকক, লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","আৰু যি কোনো মানুহে ভূত পোহা আৰু গুণ-মন্ত্ৰ জনাসকলৰ অনুগামী হৈ ব্যভিচাৰ কৰিবলৈ তেওঁলোকৰ ফাললৈ মুখ কৰিব, মই সেই মানুহলৈ কোন্দোৱাকৈ চাই, তেওঁৰ লোকসকলৰ মাজৰ পৰা তেওঁক উচ্ছন্ন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","এই হেতুকে তোমালোকে তোমালোকক পবিত্ৰ কৰি পবিত্ৰ হোৱা; কিয়নো মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","তোমালোকে মোৰ বিধিবোৰ পালন কৰিবা আৰু সেই অনুসাৰে আচৰণ কৰিবা। মই তোমালোকৰ পবিত্ৰকাৰী যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","কিয়নো যিকোনোৱে নিজ পিতৃ বা মাতৃক শাও দিব, তাৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। পিতৃ-মাতৃক শাও দিয়াৰ বাবে সেই ৰক্তপাতৰ দোষ তেওঁৰ নিজৰ গাতে থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","যি লোকে পৰস্ত্ৰীৰে সৈতে ব্যভিচাৰ কৰিব, যি লোকে ওচৰ-চুবুৰীয়াৰ মহিলাৰে সৈতে ব্যভিচাৰ কৰিব, সেই ব্যভিচাৰী আৰু সেই ব্যভিচাৰিণী দুয়োৰো অৱশ্যে প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","আৰু যি মানুহে নিজ পিতৃ-ভাৰ্য্যাৰে সৈতে শয়ন কৰিব, তেওঁ নিজ পিতৃৰ উলঙ্গতা প্ৰকাশ কৰে। অৱশ্যে সিহঁত দুয়োৰো প্ৰাণদণ্ড হব। তেওঁলোকৰ ৰক্তপাতৰ দোষ তেওঁলোকৰ গাতে লাগি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","যদি কোনো লোকে নিজ নিজ পো-বোৱাৰীয়েকৰ লগত শয়ন কৰে, তেন্তে অৱশ্যে তেওঁলোক দুয়োৰো প্ৰাণদণ্ড হ’ব। তেওঁলোকে স্বভাৱৰ বিৰুদ্ধে কাৰ্য কৰে। তেওঁলোকৰ ৰক্তপাতৰ দোষ তেওঁলোকৰ গাতে লাগি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","আৰু কোনো পুৰুষে যদি মহিলাৰ দৰে পুৰুষে সৈতে শয়ন কৰে, তেন্তে তেওঁলোক দুয়ো ঘিণ লগীয়া কৰ্ম কৰে। তেওঁলোকৰ প্ৰাণদণ্ড অৱশ্যে হ’ব। তেওঁলোকৰ ৰক্তপাতৰ দোষ তেওঁলোকৰ গাতে লাগি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","কোনো লোকে যদি কোনো মহিলাক আৰু তাইৰ মাকক গ্ৰহণ কৰে, তেন্তে সেয়ে কুকৰ্ম; তোমালোকৰ মাজত যেন এনে কুকৰ্ম নহয়, এই কাৰণে তেওঁক আৰু তেওঁলোকক তিনিওটাকে জুইত পুৰি ভস্ম কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","যদি কোনো লোকে পশুত পতিত হয়, তেওঁৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। আৰু তোমালোকে সেই পশুকো বধ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","যদি কোনো মহিলাই সংসৰ্গ কৰিবলৈ পশুৰ ওচৰলৈ যায়, তেন্তে তুমি সেই মহিলাক আৰু পশুক বধ কৰিবা। তেওঁলোকৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। তেওঁলোকৰ ৰক্তপাতৰ দোষ তেওঁলোকৰ গাতে লাগি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","যদি কোনো লোকে নিজৰ বায়েক কি ভনীয়েক, অৰ্থাৎ বাপেকৰ জীয়েক বা মাকৰ জীয়েকক গ্ৰহণ কৰি উভয়ে উভয়ৰ উলঙ্গতা দেখে, তেন্তে সেয়ে বৰ লাজৰ বিষয়। তেওঁলোক নিজ জাতিৰ সন্তান সকলৰ সাক্ষাতে উচ্ছন্ন হ’ব। তেওঁ নিজ বায়েক কি ভনীয়েকৰ উলঙ্গতা অনাবৃত কৰাত, তেওঁ নিজ অপৰাধৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","যদি কোনোবাই মাহেকীয়া অশৌচ হোৱা মহিলাৰে সৈতে যৌন সম্পৰ্ক স্থাপন কৰে, তাইৰ উলঙ্গতা প্ৰকাশ কৰে, তেন্তে সেই পুৰুষে তাইৰ ভুমুক অনাবৃত কৰাত আৰু সেই মহিলায়ো নিজৰ তেজৰ ভুমুক অনাবৃত কৰাত, তেওঁলোক দুয়ো নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","তুমি নিজ মাতৃৰ বা পিতৃৰ বায়েক কি ভনীয়েকৰ সৈতে যৌন সম্পৰ্ক স্থাপন নকৰিবা। কিয়নো ইয়াকে কৰিলে, নিজ ওচৰ-সম্বন্ধীয়াৰ উলঙ্গতা অনাবৃত কৰা হয়; তেওঁলোক দুয়ো নিজ নিজ অপৰাধৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","আৰু যদি কোনো মানুহে নিজ বৰ-মাক বা খুৰীয়েকেৰে সৈতে শয়ন কৰে, তেন্তে তেওঁ নিজ বৰ-বাপেকৰ বা দদায়েকৰ উলঙ্গতা অনাবৃত কৰা হয়। তেওঁলোক নিজ নিজ পাপৰ ফল ভোগ কৰিব; তেওঁলোক নিঃসন্তান হৈ মৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","আৰু যদি কোনোবাই নিজ ককায়েক কি ভায়েকৰ ভাৰ্য্যাক গ্ৰহণ কৰে, তেন্তে সেয়ে অশুচি কৰ্ম। নিজ ককায়েক কি ভায়েকৰ ভাৰ্য্যাৰ উলঙ্গতা অনাবৃত কৰাত, তেওঁলোক নিঃসন্তান হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","এই হেতুকে তোমালোকে বাস কৰিবৰ বাবে যি দেশলৈ মই তোমালোকক লৈ আহিছোঁ, সেই দেশে যেন তোমালোকক বতিয়াই নেপেলায় এই কাৰণে তোমালোকে মোৰ সকলো বিধি আৰু সকলো শাসন প্ৰণালী পালন কৰিবা আৰু সেই অনুসাৰে আচৰণ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","মই তোমালোকৰ সন্মূখৰ পৰা যি জাতিক খেদিম, তেওঁলোকৰ ৰীতি-নীতিৰ দৰে তোমালোকে আচৰণ নকৰিবা, কিয়নো তেওঁলোকে সেই সকলো কাৰ্য কৰাত, মই তেওঁলোকক ঘিণ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","কিন্তু মই তোমালোকক ক’লোঁ, তোমালোকেই তেওঁলোকৰ দেশ অধিকাৰ কৰিবা; মই তোমালোককেই অধিকাৰৰ অৰ্থে সেই গাখীৰ আৰু মৌ-জোল বৈ থকা দেশ দিম। আন জাতি সমূহৰ পৰা তোমালোকক পৃথক কৰা তোমালোকৰ ঈশ্বৰ যিহোৱা ময়েই। ");
INSERT INTO asmfb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","এতেকে তোমালোকে শুচি অশুচি পশুৰ, আৰু শুচি অশুচি পক্ষীৰ প্ৰভেদ কৰিবা। মই যি যি পশু,পক্ষী আৰু ভুচৰ পোক পৰুৱা আদি জন্তু অশুচি বুলি তোমালোকৰ পৰা পৃথক কৰিলোঁ, সেইবোৰৰ কোনো এটাৰ দ্বাৰাই তোমালোকে নিজক ঘিণলগীয়া নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","তোমালোক মোৰ উদ্দেশ্যে পবিত্ৰ হব লাগে; কিয়নো মই যিহোৱা পবিত্ৰ আৰু তোমালোক মোৰ হবলৈ মই তোমালোকক আন জাতিৰ পৰা পৃথক বেলেগ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","যি পুৰুষ কি স্ত্ৰীয়ে ভূত পুহিব বা গুণী হ’ব, তেওঁৰ প্ৰাণদণ্ড হ’ব, তেওঁৰ প্ৰাণদণ্ড অৱশ্যে হব; লোকসকলে তেওঁলোকক শিল দলিয়াই বধ কৰিব; তেওঁলোকৰ ৰক্তপাতৰ দোষ তেওঁলোকৰ গাতে লাগি থাকিব’।” ");
INSERT INTO asmfb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","পাছত যিহোৱাই মোচিক ক’লে: “তুমি পুৰোহিতসকলক অৰ্থাৎ হাৰোণৰ পুত্ৰসকলক কোৱা, ‘নিজ লোকসকলৰ মাজৰ কোনো মানুহ মৰিলে, তেওঁৰ বাবে কোনেও নিজকে অশুচি কৰিব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","কেৱল নিজৰ ওচৰ সম্বন্ধীয়া একে তেজৰ, অৰ্থাৎ নিজৰ মাক, বাপেক, পুতেক, জীয়েক, ককায়েক আৰু ভায়েকৰ বাবে নিজকে অশুচি কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","আৰু যি কন্যা ছোৱালী বিয়া হোৱা নাই, এনে ওচৰ সম্বন্ধীয়া নিজৰ বায়েক কি ভনীয়েক মৰিলে, তেওঁৰ বাবেও নিজকে অশুচি কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","নিজ লোকসকলৰ মাজত এজন প্ৰধান লোক হোৱাৰ কাৰণে, তেওঁ আন লোকৰ বাবে নিজকে অপবিত্ৰ কৰিবৰ অৰ্থে নিজকে অশুচি কৰিব নোৱাৰে। ");
INSERT INTO asmfb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","পুৰোহিতসকলে নিজ নিজ মুৰৰ কোনো ঠাই খুৰাই টকলা নকৰিব, দাড়িৰ চুক নুখুৰাব আৰু নিজ গা কাট-কুট নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","তেওঁলোক তেওঁলোকৰ ঈশ্বৰৰ উদ্দেশ্যে পবিত্ৰ হ’ব, নিজৰ ঈশ্বৰৰ নাম অপবিত্ৰ নকৰিব। কিয়নো তেওঁলোকে যিহোৱাৰ অগ্নিকৃত উপহাৰ, নিজৰ ঈশ্বৰৰ “ভক্ষ্য” উৎসৰ্গ কৰে, এই হেতুকে তেওঁলোক পবিত্ৰ হ’ব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","পুৰোহিতে বেশ্যা বা ভ্ৰষ্টা মহিলা গ্ৰহণ নকৰিব আৰু স্বামীয়ে ত্যাগ কৰা মহিলা গ্ৰহণ নকৰিব, কিয়নো তেওঁ নিজ ঈশ্বৰৰ উদ্দেশ্যে পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","এই কাৰণে তুমি তেওঁক পবিত্ৰ কৰি ৰাখিবা; কিয়নো তেওঁ তোমাৰ ঈশ্বৰৰ ‘ভক্ষ্য দ্ৰব্য’ উৎসৰ্গ কৰে। তেওঁ তোমাৰ পক্ষে পবিত্ৰ হ’ব লাগে, কিয়নো তোমালোকক পবিত্ৰ কৰোঁতা যিহোৱা যি মই, মই পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","কোনো পুৰোহিতৰ জীয়েকে যদি বেশ্যা কৰ্ম কৰি নিজক অপবিত্ৰ কৰে, তেন্তে তাই নিজ বাপেককো অপবিত্ৰ কৰা হয়; তাইক জুইত পোৰা যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","আৰু নিজ ভাইসকলৰ মাজত যি প্ৰধান পুৰোহিতৰ মুৰত যি অভিষেকাৰ্থক তেল ঢলা গ’ল আৰু পবিত্ৰ বস্তুবোৰ পিন্ধিবৰ কাৰণে নিযুক্ত কৰা হ’ল, তেওঁ নিজৰ মুৰৰ চুলি মুকলিকৈ নাৰাখিব আৰু নিজৰ কাপোৰ নাফালিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","তেওঁ কোনো মৰা শৱৰ ওচৰলৈ নাযাব; নিজ পিতৃ কি মাতৃৰ কাৰণেও তেওঁ নিজকে অশুচি নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ধৰ্মধামৰ পৰা বাহিৰ হৈ নাযাব আৰু নিজ ঈশ্বৰৰ ধৰ্মধাম অপবিত্ৰ নকৰিব, কিয়নো নিজ ঈশ্বৰৰ অভিষেকাৰ্থক তেল কিৰীটি স্বৰূপে তেওঁৰ মুৰত আছে। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","প্রধান পুৰোহিতে কেৱল পুৰুষে স্পৰ্শ নকৰা ছোৱালীহে বিয়া কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","বিধৱা বা স্বামীয়ে ত্যাগ কৰা, ভ্ৰষ্টা বা বেশ্যা এনে মহিলা তেওঁ বিয়া নকৰিব। কিন্তু নিজ লোকসকলৰ মাজৰ পুৰুষে স্পৰ্শ নকৰা কোনো ছোৱালী বিয়া কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","তেওঁ নিজ লোকসকলৰ মাজত নিজ বংশ অপবিত্ৰ নকৰিব, কিয়নো মই তেওঁক পবিত্ৰ কৰোঁতা যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","যিহোৱাই মোচিক আৰু ক’লে, বোলে, ");
INSERT INTO asmfb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“তুমি হাৰোণক কোৱা, পুৰুষানুক্ৰমে তোমাৰ বংশৰ মাজত যিজনৰ গাত ঘুণ থাকিব, তেওঁ নিজ ঈশ্বৰৰ ‘ভক্ষ্য’ উৎসৰ্গ কৰিবলৈ ওচৰ নাচাপিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","কিয়নো যিকোনো লোকৰ ঘুণ থাকিব, সি ওচৰ নাচাপিব; যেনে কণা, খোৰা, ফেঁচা-নকা, ");
INSERT INTO asmfb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","অধিক অঙ্গ থকা, কি ভৰি ভগা, কি হাত ভগা, ");
INSERT INTO asmfb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","কি কুজাঁ, কি বাওনা বা চকুৰ ৰোগী বা খজুলি থকা, কি নিকৰি বন্ধা, কি অণ্ডকোষ কঢ়া। ");
INSERT INTO asmfb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","আদি কৰি কোনো ঘুণ থকা যি পুৰুষ হাৰোণ পুৰোহিতৰ বংশৰ মাজত থাকিব, তেওঁ যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবলৈ ওচৰ নাচাপিব। তেওঁৰ ঘুণ আছে; তেওঁ নিজ ঈশ্বৰৰ ‘ভক্ষ্য’ উৎসৰ্গ কৰিবলৈ ওচৰ নাচাপিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ঈশ্বৰৰ ‘ভক্ষ্য’, অৰ্থাৎ অতি পবিত্ৰ আৰু পবিত্ৰ বস্তু দুয়োকো তেওঁ ভোজন কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","কেৱল প্ৰভেদক বস্ত্ৰৰ ভিতৰলৈ নোসোমাব আৰু যজ্ঞবেদীৰ ওচৰ নাচাপিব, কিয়নো তেওঁৰ ঘুণ আছে; তাতে তেওঁ মোৰ পবিত্ৰ ঠাইবোৰ অপবিত্ৰ নকৰিব। কিয়নো মই সেই সকলোকে পবিত্ৰ কৰোঁতা যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","এইদৰে মোচিয়ে হাৰোণক, তেওঁৰ পুত্ৰসকলক আৰু ইস্ৰায়েলৰ আটাই সন্তানসকলক এই কথাবোৰ ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","যিহোৱাই মোচিক ক’লে, বোলে, ");
INSERT INTO asmfb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ইস্ৰায়েলৰ সন্তানসকলে মোৰ উদ্দেশ্যে যি বস্তু পবিত্ৰ কৰে, তাৰ পৰা যেন নিজকে পৃথকে ৰাখে আৰু মোৰ পবিত্ৰ নাম যেন অপবিত্ৰ নকৰে, এনে আজ্ঞা তুমি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক দিয়া। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","তুমি তেওঁলোকক কোৱা, ‘ইস্ৰায়েলৰ সন্তানসকলে যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ কৰা পবিত্ৰ বস্তুৰ ওচৰলৈ, পুৰুষানুক্ৰমে তোমালোকৰ বংশৰ মাজৰ যিকোনোৱে অশুচি হৈ ওচৰ চাপিব, তেওঁক মোৰ সন্মূখৰ পৰা উচ্ছন্ন কৰা হ’ব। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","হাৰোণৰ বংশৰ মাজত যিজন লোক কুষ্ঠৰোগী বা যিজনৰ গাৰ পৰা কিবা বৈ থকা ৰোগ থাকে, তেওঁ শুচি নহয় মানে পবিত্ৰ বস্তুৰ একোকে ভোজন কৰিব নোৱাৰিব। আৰু মৰা শৱৰ দ্বাৰাই অশুচি হোৱা বস্তু চুব বা যিজনৰ বীৰ্য্যপাত হ’ব, ");
INSERT INTO asmfb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","বা বস্তুৰ দ্বাৰাই মানুহ অশুচি হ’ব পৰা এনে বগাই ফুৰা জন্তু বা যিকোনো প্ৰকাৰ অশৌচ মানুহৰ পৰা লাগিব পৰা অৱস্থা, এনে অশৌচ থকা মানুহক যদি চুব, ");
INSERT INTO asmfb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","সেই চুৱা লগা মানুহজন সন্ধ্যালৈকে অশুচি হৈ থাকিব আৰু পানীত নিজৰ গা নুধুলে পবিত্ৰ বস্তু ভোজন কৰিব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","বেলি মাৰ গলেহে তেওঁ শুচি হ’ব। বেলি মাৰ যোৱাৰ পাছত তেওঁ পবিত্ৰ বস্তু ভোজন কৰিব পাৰিব, কিয়নো সেইবোৰ তেওঁৰেই আহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","পুৰোহিতে নিজক অশুচি কৰিবৰ অৰ্থে কোনো মৰি থকা বা হিংসুক জন্তুৱে ছিৰা পশুৰ মঙহ নাখাব। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","এই হেতুকে তেওঁলোকে মোৰ পালনীয় নিৰ্দেশনাবোৰ পালন কৰিব লাগে, নতুবা তেওঁলোকে সেইবোৰ অপবিত্ৰ কৰিলে, তাৰ কাৰণে তেওঁলোক পাপত পৰিব আৰু তাৰ বাবে মৰিব। মই তেওঁলোকক পবিত্ৰ কৰোঁতা যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","পুৰোহিত বংশৰ নোহোৱা কোনো লোকে পবিত্ৰ বস্তু খাব নোৱৰিব; পুৰোহিতৰ ঘৰত থকা আলহী বা বেচ-খোৱা চাকৰসকলেও পবিত্ৰ বস্তু ভোজন কৰিব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","কিন্তু যদি পুৰোহিতে ধন দি কোনো লোকক কিনি লয়, তেন্তে তেওঁ যিহোৱাৰ বাবে ৰখা অংশৰ পৰা ভোজন কৰিব পাৰিব; আৰু তেওঁৰ ঘৰৰ উপজা লোকসকল আৰু চাকৰসকলেও তেওঁৰ সৈতে আহাৰ খাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","পুৰোহিতৰ জীয়েক যদি আন বংশৰ লোকৰ সৈতে বিয়া হয়, তেন্তে উপহাৰ স্বৰূপে দিয়া পবিত্ৰ বস্তু তাই ভোজন কৰিব নোৱাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","কিন্তু পুৰোহিতৰ জীয়েক যদি বিধৱা বা স্বামীয়ে ত্যাগ কৰা হয় আৰু তাইৰ যদি সন্তান নাথাকে আৰু নিজ পিতৃৰ ঘৰলৈ আহি, জীয়াৰীকালৰ দৰে থাকে, তেন্তে তাই পিতৃৰ আহাৰ খাব পাৰে। কিন্তু পুৰোহিত বংশৰ নোহোৱা লোকে সেই পুৰোহিতৰ আহাৰ ভোজন নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","যদি কোনোৱে অজানিতে পবিত্ৰ বস্তু খায়, তেন্তে তেওঁ পুৰোহিতক তাৰ ক্ষতিপূৰণ কৰিব আৰু তাৰ পাঁচভাগৰ এভাগ বেচিকৈ দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","এইদৰে ইস্ৰায়েলৰ সন্তানসকলে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰা পবিত্ৰ বস্তুবোৰ পুৰোহিতসকলে অপবিত্ৰ নকৰিব, ");
INSERT INTO asmfb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ইস্ৰায়েলৰ সন্তানসকলে তেওঁলোকৰ পবিত্ৰ বস্তুবোৰ খোৱাৰ সময়ত, তেওঁলোকক দোষাৰোপ কৰি অপৰাধৰ ফল ভোগ কৰাব নালাগে। কিয়নো মই তেওঁলোকক পবিত্ৰ কৰোঁতা যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","পাছে যিহোৱাই মোচিক ক’লে, বোলে, ");
INSERT INTO asmfb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“তুমি হাৰোণক, তেওঁৰ পুত্ৰসকলক আৰু ইস্ৰায়েলৰ সকলো সন্তানক কোৱা; তেওঁলোকক এইদৰে কোৱা যে, ‘প্ৰতিজ্ঞা সিদ্ধ কৰিবৰ অৰ্থে দিয়া বা ইচ্ছামতে এনেই দিয়া, যিহোৱাৰ উদ্দেশ্যে হোম-বলি স্বৰূপে অনা উপহাৰবোৰৰ মাজৰ নিজৰ উপহাৰ যদি ইস্ৰায়েল বংশৰ কোনো মানুহে, নাইবা ইস্ৰায়েলৰ মাজত প্ৰবাস কৰা কোনো বিদেশীলোকে আনে, ");
INSERT INTO asmfb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","তেন্তে সেয়ে গ্ৰাহ্য হ’বৰ বাবে গৰুৰ বা মেৰৰ বা ছাগলীৰ পৰা নিঘূণ মতা পশু উৎসৰ্গ কৰিব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","কিন্তু তোমালোকে ঘূণ থকা একোকে উৎসৰ্গ নকৰিবা। কিয়নো সেয়ে তোমালোকৰ পক্ষে মই গ্রহণ নকৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","কোনো লোকে যদি প্ৰতিজ্ঞা সিদ্ধ কৰিবৰ অৰ্থে নাইবা ইচ্ছামতে এনেই দিবৰ অৰ্থে, গৰু, কি মেৰ, কি ছাগলীৰ জাকৰ পৰা মঙ্গলাৰ্থক বলি যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰে, তেন্তে গ্ৰাহ্য হবৰ বাবে সেয়ে নিৰ্ঘূণ হব লাগিব। তাত কোনো ঘূণ থাকিব নালাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","কণা, কি ঠেং ভগা, কি খুন হোৱা, কি পুঁজ-পানী বৈ থকা, কি খহুৱা, কি নিকৰি বন্ধা, এনে পশু তোমালোকে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ নকৰিবা; আৰু তাৰ একোকে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে যজ্ঞবেদীত নুতুলিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","আৰু অধিক অঙ্গ কি কম অঙ্গ থকা গৰু, মেৰ বা ছাগলী পোৱালি ইচ্ছামতে এনেই দিয়া উপহাৰ স্বৰূপে উৎসৰ্গ কৰিব পাৰা; কিন্তু প্ৰতিজ্ঞা সিদ্ধ কৰিবৰ অৰ্থে সেয়ে গ্ৰহণ নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","আৰু অণ্ডকোষ চেপি ভঙা, কি খুন্দা, কি মুচৰি চিঙা, কি কটা, একোকে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ নকৰিবা। এইবোৰ তোমাৰ দেশত উৎসৰ্গ নকৰিবা, ");
INSERT INTO asmfb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","আৰু বিদেশীৰ হাতৰ পৰাও কিবা লৈ, সেইবোৰৰ মাজৰ তোমালোকৰ ঈশ্বৰৰ ভক্ষ্য স্বৰূপে উৎসৰ্গ নকৰিবা; কিয়নো সেইবোৰত দোষ আছে, সেইবোৰত ঘূণ আছে; সেইবোৰ তোমালোকৰ পক্ষে মই গ্ৰহণ নকৰিম’।” ");
INSERT INTO asmfb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“গৰু, কি মেৰ, কি ছাগলী জগাৰ পাছত সাতদিনলৈকে মাকৰ লগত থাকিব লাগিব। তেতিয়া অষ্টম দিনৰ পৰা যিহোৱাৰ উদ্দেশ্যে আগ কৰা অগ্নিকৃত উপহাৰৰ বাবে তাক গ্ৰহণ কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","গাই গৰু হওঁক, কি মাইকী মেৰ বা ছাগলী হওঁক, তাইক তাইৰ পোৱালিৰে সৈতে একেদিনাই মাৰিব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","তোমালোকে যি সময়ত যিহোৱাৰ উদ্দেশ্যে অনুগ্ৰহ মনা বলি উৎসৰ্গ কৰিবা সেই সময়ত, গ্রহণ হবৰ বাবেহে তাক উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","সেয়ে একেদিনাই তাক ভোজন কৰিব লাগিব। তোমালোকে ৰাতিপুৱালৈ তাৰ একোকে অৱশিষ্ট নাৰাখিবা। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","এই হেতুকে তোমালোকে মোৰ আজ্ঞাবোৰ পালন কৰি, সেই অনুসাৰে কাৰ্য কৰিবা। মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","আৰু তোমালোকে মোৰ পবিত্ৰ নাম অপবিত্ৰ নকৰিবা; কিন্তু মই ইস্ৰায়েলৰ সন্তান সকলৰ মাজত পবিত্ৰীকৃত হ’ম। তোমালোকক পবিত্ৰ কৰোঁতা যিহোৱা ময়েই। ");
INSERT INTO asmfb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","তোমালোকৰ ঈশ্বৰ হবৰ বাবে যিজনে মিচৰ দেশৰ পৰা তোমালোকক উলিয়াই আনিলে। মই যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কথা কোৱা, তেওঁলোকক এই কথা কোৱা যে ‘তোমালোকে যিহোৱাৰ যি সকলো পৰ্ব্ব পবিত্ৰ সভা বুলি ঘোষণা কৰিবা, মোৰ সেইবোৰ পৰ্ব্ব এই। ");
INSERT INTO asmfb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ছদিনৰ কাম কৰা যাব; কিন্তু সপ্তমদিন বিশ্ৰাম-দিন, অৰ্থাৎ সম্পূৰ্ণ বিশ্ৰামৰ, সেই দিনা পবিত্ৰ সভা হ’ব। সেই দিনা তোমালোকে কোনো প্ৰকাৰৰ কাম নকৰিবা; সেয়ে তোমালোক থকা সকলো ঠাইতে যিহোৱাৰ উদ্দেশ্যে বিশ্ৰাম-দিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","যিহোৱাৰ যিবোৰ পৰ্ব্ব, যিবোৰ পবিত্ৰ সভা তোমালোকে নিজ নিজ নিৰূপিত সময়ত ঘোষণা কৰিবা, সেইবোৰ এই। ");
INSERT INTO asmfb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","প্ৰথম মাহৰ চতুৰ্দশ দিনা সন্ধিয়া সময়ত যিহোৱাৰ উদ্দেশ্যে নিস্তাৰ-পৰ্ব্ব হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","আৰু সেই মাহৰ পঞ্চদশ দিনা যিহোৱাৰ উদ্দেশ্যে খমীৰ নিদিয়া পিঠাৰ উৎসৱ হ’ব। তোমালোকে সাত দিন ধৰি খমীৰ নিদিয়া পিঠা ভোজন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","প্ৰথম দিনা তোমালোকৰ পবিত্ৰ সভা হ’ব; সেই দিনা তোমালোকে কোনো ব্যৱসায়ৰ সাধাৰণ কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","কিন্তু সাত দিন যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবা; সপ্তম দিনা পবিত্ৰ সভা হ’ব; সেই দিনা তোমালোকে কোনো ব্যৱসায়ৰ সাধাৰণ কৰ্ম নকৰিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","পাছে যিহোৱাই মোচিৰ সৈতে কথা পাতি এইদৰে ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘মই তোমালোকক যি দেশ দিম, সেই দেশত সোমালে তোমালোকে যেতিয়া তাত শস্য দাবা, তেতিয়া, তোমালোকে দোৱা শস্যৰ আগভাগ বুলি এডাঙৰি পুৰোহিতৰ গুৰিলৈ আনিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","তোমালোকে গ্ৰহণীয় হ’বৰ বাবে, তেওঁ যিহোৱাৰ আগত সেই ডাঙৰি দোলাব; বিশ্ৰামবাৰৰ পাছদিনাখনত পুৰোহিতে তাক দোলাব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","আৰু যি দিনা তোমালোকে সেই ডাঙৰি দোলাবা, সেই দিনা যিহোৱাৰ উদ্দেশ্য হোমৰ অৰ্থে এটা এবছৰীয়া নিৰ্ঘূণী মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","তাৰ ভক্ষ্য নৈবেদ্য ঐফাৰ দহভাগৰ দুভাগ তেল মিহলোৱা মিহি আটা গুৰি; সেয়ে যিহোৱাৰ উদ্দেশ্য সুঘ্ৰাণৰ অৰ্থে অগ্নিকৃত উপহাৰ হ’ব; আৰু তাৰ পেয় নৈবেদ্য এক হীন দ্ৰাক্ষাৰস চাৰিভাগৰ এভাগ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","আৰু তোমালোকে নিজ ঈশ্বৰৰ উদ্দেশ্যে এই উপহাৰ ননা দিনলৈকে; পিঠা বা ভজা শস্য বা ছিঙা নতুন চেঁই ভোজন নকৰিবা; তোমালোকে থকা আটাই ঠাইতে এইয়া পুৰুষানুক্ৰমে পালন কৰিব লগীয়া চিৰকলীয়া বিধি। ");
INSERT INTO asmfb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","সেই বিশ্ৰাম-বাৰৰ পাছদিনাৰ পৰা, দোলনীয় নৈবেদ্য স্বৰূপে ডাঙৰি অনা দিনাৰ পৰা তোমালোকে পুৰা সাত বিশ্ৰাম-বাৰ লেখ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","এইদৰে সপ্তম বিশ্ৰাম-বাৰৰ পাছদিনালৈকে তোমালোকে পঞ্চাশদিন লেখ কৰিবা। আৰু তেতিয়া যিহোৱাৰ উদ্দেশ্যে নতুন ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","তোমালোকে থকা ঠাইৰ পৰা দোলনীয় নৈবেদ্যৰ অৰ্থে ঐফাৰ দহভাগৰ দুভাগ দুটা পিঠা আনিবা; সেইবোৰ মিহি আটাগুৰিৰে যুগুত কৰা আৰু খমীৰ দি তন্দুৰত তাও দিয়া হ’ব লাগে; সেইবোৰ যিহোৱাৰ উদ্দেশ্যে প্ৰথমে পকা শস্যৰ আগভাগ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","আৰু তোমালোকে সেই দুটা পিঠাৰ লগত সাতোটা এবছৰীয়া নিঘূণ মেৰ পোৱালি আৰু এটা দমৰা গৰু আৰু দুটা মতা মেৰ উৎসৰ্গ কৰিবা; সেইবোৰৰ নিজ নিজ ভক্ষ্য নৈবেদ্য আৰু পেয় নৈবেদ্যৰে সৈতে সেইবোৰ যিহোৱাৰ উদ্দেশ্যে হোম-বলি, যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","আৰু তোমালোকে পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী আৰু মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা এবছৰীয়া মতা মেৰ-ছাগ পোৱালি উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","আৰু পুৰোহিতে সেই প্ৰথমে পকা শস্যৰ পিঠাৰে সৈতে যিহোৱাৰ আগত দোলনীয় নৈবেদ্য স্বৰূপে সেইবোৰ দোলাব আৰু মেৰ পোৱালি দুটাৰে সৈতে পুৰোহিতৰ কাৰণে যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","আৰু সেই দিনা তোমালোকে ঘোষণা কৰিবা, তোমালোকৰ পবিত্ৰ সভা হ’ব আৰু তোমালোকে কোনো ব্যৱসায় কৰ্ম নকৰিবা; এইয়ে তোমালোকে থকা সকলো ঠাইতে পুৰুষানুক্ৰমে পালন কৰিবলগীয়া সদাকালৰ বিধি। ");
INSERT INTO asmfb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","আৰু তোমালোকে নিজ নিজ ভুমিত উৎপন্ন হোৱা শস্য দাবৰ কালত, খেতিৰ চুকত থকা শস্যৰ সম্পূৰ্ণৰূপে নথকাকৈ নাদাবা আৰু তোমাৰ খেতিৰ এৰি যোৱা শস্য নুবুটলিবা। তুমি সেইবোৰ দুখীয়া আৰু বিদেশীৰ কাৰণে এৰি যাবা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘সপ্তম মাহৰ প্ৰথম দিনা তোমালোকৰ সম্পূৰ্ণ বিশ্ৰামৰ দিন, শিঙা বজাই সোঁৱৰণ কৰোওৱা দিন আৰু পবিত্ৰ সভা হব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","সেই দিনা তোমালোকে কোনো ব্যৱসায় কৰ্ম নকৰিবা; আৰু তোমালোকে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","তাৰ পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“সেই সপ্তম মাহৰ দশম দিন অৱশ্যে প্ৰায়শ্চিত্তৰ দিন হ’ব; সেই দিনা তোমালোকে যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ সভা পালন কৰিবা; তোমালোকে উপবাস ৰাখিবা আৰু যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","আৰু সেই দিনা তোমালোকে কোনো প্ৰকাৰৰ কাম নকৰিবা কিয়নো তোমালোকৰ ঈশ্বৰ যিহোৱাৰ আগত তোমালোকক প্ৰায়শ্চিত্ত কৰিবলৈ সেয়ে প্ৰায়শ্চিত্তৰ দিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","কিয়নো যিকোনোৱে সেই দিনা উপবাস নাৰাখে, তেওঁক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","আৰু যিকোনো লোকে সেই দিনা কোনো প্ৰকাৰৰ কাম কৰিব মই তেওঁক তেওঁৰ লোকসকলৰ মাজৰ পৰা বিনষ্ট কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","তোমালোকে সেই দিনা কোনো প্ৰকাৰৰ কাম নকৰিবা; এইটো তোমালোকৰ সকলো নিবাসৰ ঠাইত পুৰুষানুক্ৰমে পালন কৰিব লগীয়া চিৰস্থায়ী বিধি। ");
INSERT INTO asmfb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","সেই দিন তোমালোকৰ সম্পূৰ্ণ বিশ্ৰামৰ দিন হ’ব; সেই মাহৰ নৱম দিনা তোমালোকে উপবাস ৰাখিবা আৰু সন্ধিয়া সময়ত এক সন্ধ্যাৰ পৰা আন সন্ধ্যালৈকে তোমালোকে তোমালোকৰ সেই বিশ্ৰাম-দিন পালন কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","আৰু যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘সেই সপ্তম মাহৰ পঞ্চদশ দিনাৰ পৰা সাত দিনলৈকে যিহোৱাৰ উদ্দেশ্যে পঁজা-পৰ্ব্ব হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","প্ৰথম দিনা পবিত্ৰ সভা হ’ব। সেই দিনা তোমালোকে কোনো ব্যৱসায় কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","তোমালোকে সাত দিনালৈকে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গা কৰিবা; অষ্টম দিনা তোমালোকৰ পবিত্ৰ সভা হ’ব আৰু তোমালোকে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবা; সেয়ে ধৰ্ম-সভা; সেই দিনা তোমালোকে কোনো ব্যৱসায় কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","অগ্নিকৃত উপহাৰ, অৰ্থাৎ হোম-বলি, ভক্ষ্য নৈবেদ্য, মঙ্গলাৰ্থক বলি, আৰু পেয় নৈবেদ্য নিজ নিজ দিন উৎসৰ্গ কৰিবলৈ তোমালোকে পবিত্ৰ সভা বুলি ঘোষণা কৰিবলগীয়া যিহোৱাৰ পৰ্ব্ব এইবোৰ।, ");
INSERT INTO asmfb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","যিহোৱাৰ বিশ্ৰাম-বাৰ বোৰৰ বাহিৰে আৰু তোমালোকে যিহোৱাৰ উদ্দেশ্যে যি যি দান দিয়া, প্ৰতিজ্ঞা সিদ্ধ কৰিবৰ অৰ্থে আৰু ইচ্ছামতে এনেই দিবৰ অৰ্থে যিহোৱাৰ উদ্দেশ্যে তোমালোকে যি যি উপহাৰ দিয়া, সেই বোৰৰ কাৰণে এই পৰ্ব্ববোৰ পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ভুমিত উৎপন্ন হোৱা শস্য চপোৱাৰ পাছত, সপ্তম মাহৰ পঞ্চদশ দিনাৰ পৰা সাতদিন তোমালোকে অৱশ্যে যিহোৱাৰ উদ্দেশ্যে পঁজা পৰ্ব্ব পালন কৰিবা; প্ৰথম আৰু অষ্টম দিন সম্পূৰ্ণ বিশ্ৰামৰ বিশ্ৰাম-দিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","আৰু প্ৰথম দিনা তোমালোকে শুৱনি গছৰ গুটি, খাজুৰ গছৰ পাত, ঘন পতীয়া গছৰ ডাল আৰু জুৰিৰ পাৰত থকা বাইচি গছ লৈ তোমালোকৰ ঈশ্বৰ যিহোৱাৰ আগত সাতদিন আনন্দ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","আৰু তোমালোকে বছৰে বছৰে সাতদিন যিহোৱাৰ উদ্দেশ্যে সেই উৎসৱ পালন কৰিবা; এইয়ে তোমালোকৰ পুৰুষানুক্ৰমে পালন কৰিবলগীয়া চিৰস্থায়ী বিধি; সপ্তম মাহত তোমালোকে সেই উৎসৱ পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","তোমালোকে সাতদিন সৰু পঁজাত বাস কৰিবা। ইস্ৰায়েল বংশত ওপজা সকলোৱে সাত দিন সৰু পঁজাত বাস কৰিব; ");
INSERT INTO asmfb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","কিয়নো যি বিষয়ে তোমালোকৰ ভাবী-বংশই যেন জানে যে মই কিদৰে ইস্ৰায়েলৰ সন্তান সকলক মিচৰ দেশৰ পৰা উলিয়াই অনা সময়ত পঁজাত বাস কৰাইছিলোঁ। মই তোমালোকৰ ঈশ্বৰ যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","তেতিয়া মোচিয়ে ইস্ৰায়েলৰ সন্তানসকলক যিহোৱাৰ সকলো পৰ্ব্বৰ কথা এইদৰে জনালে। ");
INSERT INTO asmfb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“সদায় প্ৰদীপ জ্বলাই পোহৰ কৰি ৰাখিবৰ কাৰণে, খুন্দি উলিওৱা জিত গছৰ গুটিৰ নিৰ্ম্মল তেল তোমাৰ ওচৰলৈ আনিবলৈ, তুমি ইস্ৰায়েলৰ সন্তানসকলক আজ্ঞা দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","সাক্ষাৎ কৰা তম্বুৰ ভিতৰত সাক্ষ্য-ফলি থকা নিয়ম-চন্দুকৰ আগত থকা প্ৰভেদক বস্ত্ৰৰ বাহিৰত হাৰোণে যিহোৱাৰ আগত গধূলি আৰু ৰাতিপুৱা সদায় তাক যুগুত কৰি থ’ব লাগিব। এয়ে তোমালোকৰ পুৰুষানুক্ৰমে পালন কৰিবলগীয়া চিৰস্থায়ী বিধি। ");
INSERT INTO asmfb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","পুৰোহিতে শুদ্ধ সোণৰ দীপাধাৰৰ ওপৰত যিহোৱাৰ সন্মুখত সেই প্ৰদীপবোৰ সদায় যুগুত কৰি জ্ৱলাই থ’বা। ");
INSERT INTO asmfb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","তুমি মিহি আটাগুৰি লৈ, বাৰটা পিঠা তন্দুৰত তাও দিবা; প্ৰত্যেক পিঠাত ঐফাৰ দহভাগৰ দুভাগ আটাগুৰি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","তাৰ পাছত তুমি শাৰীত ছটাকৈ দুশাৰী কৰি যিহোৱাৰ আগত শুদ্ধ সোণৰ মেজখনৰ ওপৰত সেইবোৰ ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","আৰু প্ৰত্যেক শাৰীৰ ওপৰত নিৰ্ম্মল ধূপ-ধূনা দিবা; তাতে সেই পিঠাৰ ওপৰত সেয়ে সোঁৱৰণৰ অৰ্থে হ’ব। সেয়ে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","আৰু পুৰোহিতে প্ৰত্যেক বিশ্ৰাম-বাৰে যিহোৱাৰ আগত সেই পিঠা সদায় সজাই থ’ব; সেয়ে চিৰস্থায়ী নিয়মৰ চিন স্বৰূপে ইস্ৰায়েলৰ সন্তান সকলৰ পক্ষে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","আৰু সেয়ে হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ উপহাৰ হ’ব। কোনো পবিত্ৰ ঠাইত তেওঁলোকে তাক ভোজন কৰিব; কিয়নো যিহোৱাৰ উদ্দেশ্যে দিয়া অগ্নিকৃত উপহাৰ বোৰৰ মাজত সেয়ে অতি পবিত্ৰ; সেয়ে তেওঁৰ চিৰস্থায়ী অধিকাৰ।” ");
INSERT INTO asmfb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","পাছত মাক ইস্ৰায়েলীয়া, কিন্তু বাপেক মিচৰীয়া, এনে এজন মানুহ ওলাই ইস্ৰায়েলৰ সন্তানসকলৰ মাজলৈ গ’ল; তাতে ছাউনিৰ মাজত সেই ইস্ৰায়েলীয়া মহিলাৰ পুত্রৰ সৈতে এটা ইস্ৰায়েলীয়া মানুহৰ দণ্ড লাগিল। ");
INSERT INTO asmfb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","তেতিয়া সেই ইস্ৰায়েলীয়া মহিলাৰ পুত্রই যিহোৱাৰ নাম নিন্দা কৰি শাও দিয়াত, লোকসকলে তেওঁক মোচিৰ ওচৰলৈ আনিলে। তেওঁৰ মাতৃৰ নাম চলোমীথ; তাই দান ফৈদীয়া, দিব্ৰীৰ জীয়েক। ");
INSERT INTO asmfb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","লোকসকলে তেওঁক বন্ধ কৰি ৰাখি, যিহোৱাৰ মুখৰ পৰা ঠিক আদেশ পাবলৈ বাট চাই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","তেতিয়া যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“তুমি সেই শাও দিয়া জনক ছাউনিৰ বাহিৰলৈ লৈ যোৱা। পাছত যিসকলে তেওঁক শাও দিয়া শুনিছিল, সেই সকলোৱে তেওঁৰ মূৰত হাত দিয়ক আৰু গোটেই মণ্ডলীয়ে শিল দলিয়াই তেওঁক বধ কৰক। ");
INSERT INTO asmfb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","আৰু তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘যি কোনোৱে নিজৰ ঈশ্বৰক শাও দিব, তেওঁ নিজৰ পাপৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","আৰু যি জনে যিহোৱাৰ নামৰ নিন্দা কৰিব, সেই জনৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। গোটেই সমাজে তেওঁলৈ অৱশ্যে শিল দলিয়াব, যদিও তেওঁ বিদেশী বা ইস্রায়েলৰ বংশত জন্মাই হওঁক। যি কোনোৱে যিহোৱাৰ নামৰ নিন্দা কৰিব, সেই জনৰ অৱশ্যে প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","আৰু যি জনে আন এজনক বধ কৰিব, তেওঁৰ প্ৰাণদণ্ড অৱশ্যে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","আৰু যি জনে আন এজনৰ পশুক মাৰিব, তেওঁ তাৰ সলনি দিব; প্ৰাণৰ সলনি প্ৰাণ। ");
INSERT INTO asmfb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","আৰু যদি কোনোৱে তেওঁৰ ওচৰ-চুবুৰীয়াক আঘাত কৰে, তেন্তে তেওঁ যেনে কৰিলে, তেওঁলৈকো তেনে কৰা যাব; ");
INSERT INTO asmfb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","অঙ্গ ভঙাৰ সলনি অঙ্গ ভঙা, চকুৰ সলনি চকু, দাঁতৰ সলনি দাঁত। যিদৰে তেওঁ আন জনক আঘাত কৰিলে, তেওঁলৈকো তেনেই কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","যি জনে পশু বধ কৰিব, তেওঁ তাৰ সলনি দিব আৰু যি জন লোকে বধ কৰিব, তেওঁৰ প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","তোমালোকৰ স্বদেশীয় আৰু বিদেশীয় উভয়ৰ কাৰণে একে ৰূপবিধি হ’ব; কিয়নো মই তোমালোকৰ ঈশ্বৰ যিহোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","তেতিয়া মোচিয়ে ইস্ৰায়েলৰ সন্তান সকললৈ এই আজ্ঞা প্ৰকাশ কৰাত, লোকসকলে সেই শাও দিয়াজনক ছাউনিৰ বাহিৰলৈ নি, শিল দলিয়াই তেওঁক বধ কৰিলে। যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰেই, ইস্ৰায়েলৰ সন্তান সকলে কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","পাছত যিহোৱাই চীনয় পৰ্ব্বতত মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক কোৱা, মই তোমালোকক যি দেশ দিম, তোমালোকে সেই দেশত সোমালে, যিহোৱাৰ উদ্দেশ্যে ভুমিয়ে বিশ্ৰাম ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","তুমি ছবছৰ নিজ পথাৰত গুটি ববা, আৰু ছবছৰ নিজ বাৰীৰ দ্ৰাক্ষালতাবোৰ পৰিষ্কাৰ কৰিবা, আৰু তাৰ গুটি চপাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","কিন্তু সপ্তম বছৰ যিহোৱাৰ উদ্দেশ্যে ভুমিৰ সম্পূৰ্ণ বিশ্ৰামৰ বিশ্ৰাম-কাল হ’ব; সেই বছৰত তুমি নিজ পথাৰত গুটি নব’বা, আৰু দ্ৰাক্ষালতা পৰিষ্কাৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","তুমি নিজ পথাৰত নিজে হোৱা শস্য নাদাবা, আৰু পৰিষ্কাৰ নকৰা দ্ৰাক্ষালতাৰ গুটি নচপাবা; সেয়ে ভুমি সম্পূৰ্ণ বিশ্ৰামৰ বছৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","তাতে, বিশ্ৰাম-বছৰত হোৱা ভুমি শস্য তোমালোকলৈ আহাৰ হ’ব; অৰ্থাৎ তোমাৰ পথাৰত উৎপন্ন হোৱা সকলো শস্য তোমাৰ আৰু তোমাৰ দাস, বেটী আৰু তোমাৰ লগত থকা বেচ খোৱা দাস আৰু বিদেশীৰ বাবে যুগুত কৰিব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","আৰু তোমাৰ পশু আৰু দেশত থকা বনৰীয়া পশুবোৰৰ অৰ্থে সেইবোৰ আহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","তুমি নিজৰ কাৰণে সাত বিশ্ৰাম-বছৰ, সাত গুণ সাত বছৰ লেখ কৰিবা; তাতে সাত বিশ্ৰাম-বছৰৰ কাল ঊনপঞ্চাশ বছৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","তেতিয়া সপ্তম মাহৰ দশম দিনা দেশৰ সকলো ফালে বৰ মাতৰ শিঙা বজাবা; প্ৰায়শ্চিত্তৰ দিনা তোমালোকৰ দেশৰ সকলো ফালে শিঙা বজাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","তোমালোকে পঞ্চাশ বছৰটো পবিত্ৰ বুলি মানিবা, আৰু গোটেই দেশত তাৰ সকলো নিবাসীসকললৈ মুক্তি ঘোষণা কৰিবা; সেয়ে তোমালোকৰ কাৰণে বৰ্ষপূৰ্তি উৎসৱ হ’ব, আৰু তোমালোক প্ৰতিজনে নিজ নিজ উত্তৰাধিকাৰলৈ উলতি যাবা আৰু দাসবোৰক নিজ নিজ গোষ্ঠীৰ ওচৰলৈ পঠিয়াই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","সেই পঞ্চাশ বছৰটো তোমালোকৰ কাৰণে বৰ্ষপূৰ্তি উৎসৱ হ’ব; সেই বছৰত তোমালোকে গুটি নববা, নিজে হোৱা শস্যও নাদাবা আৰু কলম নিদিয়া দ্ৰাক্ষালতাৰ গুটিও নচপাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","কিয়নো সেয়ে বৰ্ষপূৰ্তি উৎসৱৰ বছৰ; সেয়ে তোমালোকলৈ পবিত্ৰ হ’ব। তোমালোকে সেই বছৰত নিজে উৎপন্ন হোৱা শস্য পথাৰৰ পৰা আনি খাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","সেই বৰ্ষপূৰ্তি উৎসৱৰ বছৰত তোমালোকে সকলোকে নিজ নিজ উত্তৰাধিকাৰবোৰ ঘূৰাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","যদি তুমি নিজ চুবুৰীয়াক কোনো মাটি বেচা, বা তেওঁলোকৰ পৰা কিনা, তেতিয়া তোমালোকে ইজনে সিজনক অন্যায় নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","তুমি বৰ্ষপূৰ্তি উৎসৱৰ পাছত হোৱা বছৰৰ লেখ অনুসাৰে লোকৰ পৰা মাটি কিনিবা, আৰু শস্য উৎপন্ন হোৱা বছৰৰ সংখ্যা অনুসাৰে তেওঁ তোমাক বেচিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","বৰ্ষপূৰ্তি উৎসৱলৈ বেছি বছৰ থাকিলে বেছি দাম কৰিবা আৰু কম বছৰ থাকিলে কম দাম কৰিবা; কিয়নো নতুন গৰাকীৰ ভুমিত শস্য উৎপন্ন হোৱা বছৰৰ সংখ্যা অনুসাৰে তেওঁ তোমাক মাটি বেচে। ");
INSERT INTO asmfb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","আৰু তোমালোকে ইজনে সিজনক অন্যায় নকৰিবা, কিন্তু নিজ ঈশ্বৰক ভয় কৰিবা; কিয়নো মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","এই কাৰণে তোমালোকে মোৰ বিধি অনুসাৰে আচৰণ কৰিবা, আৰু মোৰ শাসন প্ৰণালী পালন কৰি, সেই অনুসাৰে কাৰ্য কৰিবা; তেতিয়া তোমালোকে দেশত নিৰ্ভয়ে বাস কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","আৰু ভুমিয়ে নিজ শস্য উৎপন্ন কৰিব; তাতে তোমালোকে হেঁপাহ পলোৱাকৈ খাবলৈ পাবা; আৰু দেশত নিৰ্ভয়ে থাকিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","কিন্তু তোমালোকে ক’ব পাৰা যে, “পথাৰ নবলে, আৰু তাত উৎপন্ন হোৱা গুটি নচপালে আমি সপ্তম বছৰত কি খাম?” ");
INSERT INTO asmfb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","তেতিয়া মই ষষ্ঠ বছৰত তোমালোকৰ ওপৰত আশীৰ্ব্বাদ আহিবলৈ আদেশ কৰিম, তাতে ভুমিয়ে সেই বছৰত তিনি বছৰলৈ থকাকৈ শস্য উৎপন্ন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","পাছত অষ্টম বছৰত তোমালোকে গুটি ববা, কিন্তু তেতিয়াও পুৰণি শস্য খাবা; নৱম বছৰৰ শস্য নহয় মানে তোমালোকে পুৰণি শস্য খাই থাকিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","আৰু মাটি চিৰকালৰ কাৰণে আনক বেচা নহব; কিয়নো সেই মাটি মোৰ, আৰু তোমালোক মোৰ লগত অতিথি আৰু প্রবাসী আছা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","আৰু তোমালোকে তোমালোকৰ উত্তৰাধীকাৰ সকলো দেশত মাটি মোকলাবলৈ ক্ষমতা দিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","তোমাৰ ইস্রায়েলী লগৰ যদি দুখীয়া হৈ তেওঁৰ উত্তৰাধিকাৰৰ মাটি তোমাক কিছু বেচে, তেন্তে তাক মোকলাব পৰা তেওঁৰ ওচৰ সম্বন্ধীয়াই আহি, নিজ ভায়েকে বেচা সেই মাটি মোকলাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","আৰু যাৰ মুকলি কৰোঁতা গৰাকী নাই, কিন্তু তেওঁ চহকী হোৱাত, তেওঁৰ যদি নিজে মুকলি কৰিবা পৰা সমৰ্থ হয়, ");
INSERT INTO asmfb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","তেন্তে তেওঁ তাক বেচা বছৰ লেখ কৰি, বাকী থকা ধন বেচাজনক ওলোটাই দিব; তেতিয়া তেওঁ পুনৰায় তেওঁৰ নিজৰ উত্তৰাধীকাৰ পাব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","কিন্তু যদি তেওঁ তাক ওলোটাই লবলৈ অসমৰ্থ হয়, তেন্তে সেই বেচা মাটি বৰ্ষপূৰ্তি উৎসৱৰ বছৰলৈকে কিনা জনৰ হাতত থাকিব, পাছত বৰ্ষপূৰ্তি উৎসৱৰ বছৰত সেয়ে মুকলি হ’ব, তেতিয়া তেওঁৰ সেই উত্তৰাধীকাৰ তেওঁ পুনৰায় পাব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","আৰু যদি গড়েৰে আবৃত থকা নগৰৰ ভিতৰত বাস কৰা ঘৰ কোনোৱে বেচে, তেন্তে তেওঁ বেচাৰ পাছত সম্পূৰ্ণ এবছৰৰ ভিতৰত তাক মুকলি কৰিব পাৰিব; গোটেই বছৰৰ ভিতৰত তাক মুকলি কৰিবলৈ তেওঁৰ ক্ষমতা থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","কিন্তু যদি পুৰা এবছৰৰ ভিতৰত তাক মুকলি কৰা নহয়, তেন্তে গড়েৰে আবৃত থকা নগৰৰ সেই ঘৰ পুৰুষানুক্ৰমে চিৰকাললৈ কিনা জনৰ অধিকাৰ হ’ব; সেইয়ে বৰ্ষপূৰ্তি উৎসৱৰ বছৰতো মুকলি নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","কিন্তু গড়েৰে আবৃত নোহোৱা গাঁৱত থকা যিবোৰ ঘৰ, সেইবোৰ নগৰৰ বাহিৰৰ মাটিৰ লগত লেখ কৰা হব; সেইবোৰ ঘৰক মোকলাব পাৰে, আৰু বৰ্ষপূৰ্তি উৎসৱৰ বছৰত সেইবোৰ মুকলি হৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","তথাপি লেবীয়াসকলৰ উত্তৰাধিকাৰত থকা নগৰৰ ঘৰবোৰ লেবীয়াসকলে যি কোনো সময়ত মুকলি কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","যদি লেবীয়াসকলৰ মাজৰ কোনো এজনে তাক মুকলি নকৰে, তেন্তে লেবীয়াসকলৰ উত্তৰাধিকাৰত থকা সেই বেচা ঘৰ বৰ্ষপূৰ্তি উৎসৱৰ বছৰত মুকলি হৈ যাব, কিয়নো লেবীয়াসকলৰ নগৰৰ ঘৰবোৰ ইস্ৰায়েলৰ সন্তান সকলৰ মাজত থকা তেওঁলোকৰ উত্তৰাধীকাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","কিন্তু তেওঁলোকৰ নগৰৰ চাৰিওফালে থকা চৰণীয়া পথাৰ বেচা নহ’ব; কিয়নো সেয়ে তেওঁলোকৰ চিৰকলীয়া উত্তৰাধীকাৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","আৰু তোমাৰ লগৰ নিবাসী যদি দুখীয়া হয়, আৰু নিজৰ কাৰণে একোকে যুগুত কৰিব নোৱাৰে তেন্তে তেওঁক বিদেশী আৰু প্ৰবাসীৰ নিচিনাকৈ তোমাৰ লগত জীৱন-ধাৰণ কৰিবলৈ সহায় কৰিবা; ");
INSERT INTO asmfb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","তেওঁৰ পৰা সুত বা বাঢ়ি নলবা, কিন্তু নিজ ঈশ্বৰক ভয় কৰিবা যাতে তোমাৰ ভাই তোমাৰ লগত জীৱন-ধাৰণ কৰি থাকে। ");
INSERT INTO asmfb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","তুমি সুতলৈ তাক ধন নিদিবা, বা বাঢ়িলৈ তাক অন্ন নিদিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","যিজন সৰ্বশক্তিমান ঈশ্বৰে তোমালোকক কনান দেশ দিবৰ কাৰণে, তোমালোকৰ ঈশ্বৰ হবলৈ তোমালোকক মিচৰ দেশৰ পৰা উলিয়াই আনিলে, তোমালোকৰ সেই ঈশ্বৰ যিহোৱা মই। ");
INSERT INTO asmfb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","আৰু তোমাৰ ভাই যদি তোমাৰ গুৰিত দুখীয়া হৈ, নিজকে নিজে বেচে, তেন্তে তুমি তেওঁক বন্দীৰ নিচিনাকৈ কাম নকৰাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","তেওঁ বেচ খোৱা চাকৰ আৰু প্ৰবাসীৰ নিচিনাকৈ তোমাৰ লগত থাকিব আৰু বৰ্ষপূৰ্তি উৎসৱৰ বছৰলৈকে তোমাক খাতি দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","তাৰ পাছত তেওঁ নিজ সন্তান সকলৰে সৈতে মুকলি হৈ নিজ গোষ্ঠীৰ ওচৰলৈ উভতি যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","কিয়নো তেওঁলোক, মই মিচৰ দেশৰ পৰা উলিয়াই অনা মোৰ দাস; তেওঁলোকক বন্দীস্বৰূপে বেচা নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","তুমি তেওঁলোকলৈ কঠিন ব্যৱহাৰ নকৰিবা, কিন্তু নিজ ঈশ্বৰক ভয় কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","তোমাৰ বন্দী আৰু বেটী, তুমি তোমালোকৰ চাৰিওফালে থকা জাতি সমূহৰ মাজৰ পৰা তেওঁলোকক কিনিব পাৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","আৰু তোমালোকৰ মাজত প্ৰবাস কৰা আন জাতিৰ সন্তান সকলৰ আৰু তোমালোকৰ দেশত তেওঁলোকৰ পৰা জন্মা তেওঁলোকৰ যি যি গোষ্ঠী তোমালোকৰ লগত বাস কৰিছে, তেওঁলোকৰ পৰাও কিনিবা আৰু তেওঁলোকৰ ওপৰত তোমালোকৰ অধিকাৰ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","আৰু তোমালোকে নিজ নিজ ভাবী সন্তান সকলৰ উত্তৰাধিকাৰৰ বাবে দিব লগা ভাগ স্বৰূপে তেওঁলোকক দিব পাৰিবা, আৰু চিৰকাললৈকে তেওঁলোকক বন্দী কাম কৰিব পাৰিবা; কিন্তু নিজ ভাই ইস্ৰায়েলৰ সন্তান সকলৰ মাজত হ’লে, তোমালোক কোনেও কাৰো ওপৰত কঠিন ব্যৱহাৰ নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","আৰু যদি তোমালোকৰ মাজত কোনো প্ৰবাসী বা বিদেশী লোক ধনী হয়, আৰু তাৰ ওচৰত থকা তোমাৰ ভাই দৰিদ্ৰ হৈ, সেই প্ৰবাসী বা বিদেশীৰ গুৰিত, বা বিদেশীৰ গোষ্ঠীত জন্মালোকৰ গুৰিত যদি তেওঁ নিজকে বেচে, ");
INSERT INTO asmfb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","তেন্তে বেচাৰ পাছত তাক মোকলাব পাৰে; তাৰ পৰিয়ালৰ মাজৰ কোনোৱে তেওঁক মোকলাব পাৰে; ");
INSERT INTO asmfb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","তেওঁৰ মোমায়েক, বা মোমায়েকৰ পুত্র, বা তাৰ গোষ্ঠীৰ মাজৰ তাৰ ওচৰ-সম্বন্ধীয়াই তেওঁক মুকলি কৰিব পাৰে; নাইবা তেওঁ যদি ধনী হয়, তেন্তে তেওঁ নিজে নিজকে মুকলি কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","তেওঁক বেচা বছৰেৰে পৰা বৰ্ষপূৰ্তি উৎসৱৰ বছৰলৈকে, কিনা জনে সৈতে হিচাপ কৰি, বছৰৰ সংখ্যা অনুসাৰে মুক্তিৰ ধন দিব; বেচ-খোৱা দাসৰ নিৰিখেৰে, তেওঁ কিনাজনৰ লগত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","যদি অনেক বছৰ বাকী থাকে, তেন্তে সেই বছৰৰ সংখ্যা অনুসাৰে যিমান ধন দি তেওঁক কিনা হৈছিল, তেওঁ সেই ধনৰ পৰা নিজকে মুকলি কৰা ধন ওলোটাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","আৰু যদি বৰ্ষপূৰ্তি উৎসৱৰ বছৰলৈকে অলপ বছৰহে বাকী থাকে, তেন্তে তেওঁক কিনাজনে সৈতে হিচাপ কৰি, নিজৰ খাটিব লগা বছৰৰ সংখ্যা অনুসাৰে, নিজকে মুকলি কৰা ধন ওলোটাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","বছৰে বেচ-খোৱা দসৰ দৰে, তেওঁ তাৰে সৈতে থাকিব; তোমাৰ সাক্ষাতে তেওঁ তাৰ ওপৰত, কঠিন ব্যৱহাৰ নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","আৰু যদি তেওঁ এইবোৰ উপায়েৰে মুক্ত হ’ব নোৱাৰে, তেন্তে নিজ সন্তান সকলৰে সৈতে বৰ্ষপূৰ্তি উৎসৱৰ বছৰত মুকলি হৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","কিয়নো ইস্ৰায়েলৰ সন্তান সকল মোৰেই দাস, তেওঁলোক মিচৰ দেশৰ পৰা মই উলিয়াই অনা মোৰ দাস; মই তোমালোকৰ ঈশ্বৰ যিহোৱা’। ");
INSERT INTO asmfb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“তোমালোকে তোমালোকৰ কাৰণে প্ৰতিমা নাসাজিবা, আৰু কটা-মুৰ্ত্তি বা স্তম্ভ স্থাপন নকৰিবা, পৰিসেৱা কৰিবৰ কাৰণে তোমালোকৰ দেশত নক্সা কটা কোনো শিল স্থাপন নকৰিবা; কিয়নো মই তোমালোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","তোমালোকে মোৰ বিশ্ৰাম-বাৰ পালন কৰিবা, আৰু মোৰ ধৰ্মধামলৈ ভয় ৰাখিবা; মই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","যদি তোমালোকে মোৰ বিধানতে চলা আৰু মোৰ আজ্ঞা পালন কৰি সেই অনুসাৰে কাৰ্য কৰা, ");
INSERT INTO asmfb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","তেতিয়া মই উচিত সময়ত তোমালোকলৈ বৰষুণ বৰষাম; তাতে ভুমিয়ে নিজৰ শস্য উৎপন্ন কৰিব, আৰু বাৰীৰ নিজ গছবোৰত গুটি লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","তোমালোকৰ শস্য মৰা কাল দ্ৰাক্ষাগুটি চিঙা কাললৈকে থাকিব, আৰু তোমালোকে হেঁপাহ পলুৱাকৈ তোমালোকৰ আহাৰ ভোজন কৰিবা আৰু নিৰ্ভয়ে তোমালোকৰ দেশত বাস কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","আৰু মই দেশত শান্তি দান কৰিম; তাতে তোমালোকক কোনেওঁ ভয় নোখোৱাকৈ তোমালোকে শুবলৈ পাবা; মই তোমালোকৰ দেশৰ পৰা হিংসুক জন্তুবোৰ নাইকিয়া কৰিম, আৰু তোমালোকৰ দেশৰ মাজেদি তৰোৱাল নচলিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","তোমালোকে তোমালোকৰ শত্ৰুবোৰক খেদি দিবা, আৰু তোমালোকৰ আগতে তেওঁলোক তৰোৱালৰ দ্বাৰাই পতিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","আৰু তোমালোকৰ পাঁচজনে এশ জনক আৰু তোমালোকৰ এশজনে দহ হাজাৰ জনক খেদি দিব, আৰু তোমালোকৰ শত্ৰুবোৰ তোমালোকৰ আগত পতিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","মই তোমালোকলৈ অনুগ্রহেৰে দৃষ্টি কৰি তোমালোকক বহুবংশ কৰিম; আৰু অতিশয়ৰূপে বৃদ্ধি কৰিম; আৰু মই তোমালোকৰ লগত কৰা মোৰ নিয়মটি সিদ্ধ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","আৰু তোমালোকে বহুদিনৰ পৰা সাঁচি থোৱা পুৰণি শস্য ভোজন কৰিবা, আৰু নতুন শস্য থবলৈ পুৰণি শস্য বোৰ উলিয়াবা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","মই তোমালোকৰ মাজত মোৰ আবাস স্থাপন কৰিম, আৰু মোৰ মনে তোমালোকক ঘিণ নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","আৰু মই তোমালোকৰ মাজত অহা-যোৱা কৰি, তোমালোকৰ ঈশ্বৰ হম আৰু তোমালোক মোৰ প্ৰজা হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","মিচৰীয়াসকলৰ বন্দী নহবৰ কাৰণে যিজনাই মিচৰ দেশৰ পৰা তোমালোকক উলিয়াই আনিলে, তোমালোকৰ সেই ঈশ্বৰ যিহোৱা মই; মই তোমালোকৰ যুৱলিৰ শ’লমাৰি ভাঙি, তোমালোকক মূৰ দঙাই গমণ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","কিন্তু যদি তোমালোকে মোৰ বাক্যলৈ কাণ নিদিয়া, মোৰ এই সকলো আজ্ঞামতে কাৰ্য নকৰা, ");
INSERT INTO asmfb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","মোৰ বিধি অগ্ৰাহ্য কৰা, আৰু মনতে মোৰ শাসন-প্ৰণালীবোৰ ঘিণ কৰি মোৰ আজ্ঞামতে কাৰ্য নকৰা, কিন্তু মোৰ নিয়মটি লঙ্ঘন কৰা; ");
INSERT INTO asmfb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","তেন্তে তোমালোকে এনে কৰাত মইও তোমালোকলৈ এইদৰে আচৰণ কৰিম: মই তোমালোকৰ ওপৰত চকু নাশকাৰী আৰু প্ৰাণ ক্ষয়কাৰী ব্যাকুলতা, যক্ষ্মাৰোগ আৰু পোৰণি জ্বৰ নিৰূপণ কৰিম; আৰু তোমালোকে মিছায়ে গুটি ববা; কিয়নো তোমালোকৰ শত্ৰুৱে সেইবোৰ খাব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","আৰু মই তোমালোকলৈ কোন্দোৱাকৈ চাম, তাতে তোমালোক তোমালোকৰ শত্ৰুবোৰৰ আগত ঘাটিবা, তোমালোকক ঘিণাওঁতাবোৰে তোমালোকৰ ওপৰত শাসন কৰিব, আৰু কোনেও তোমালোকক নেখেদিলেও তোমালোক পলাই যাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","আৰু যদি তোমালোকে মোৰ বাক্যলৈ কাণ নিদিয়া তেন্তে মই তোমালোকৰ পাপৰ কাৰণে তোমালোকক আৰু সাতগুণ দণ্ড দিম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","মই তোমালোকৰ গৰ্ব্ব খৰ্ব্ব কৰিম, আৰু তোমালোকৰ আকাশ লোহা যেন, আৰু মাটি পিতল যেন কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","তাতে তোমালোকৰ পৰিশ্ৰম বিফল হ’ব; কিয়নো তোমালোকৰ ভুমিয়ে শস্য উৎপন্ন নকৰিব; আৰু দেশৰ গছবোৰত গুটি নালাগিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","আৰু যদি তোমালোকে মোৰ বিপৰীত আচৰণ কৰা আৰু মোৰ বাক্য শুনিবলৈ অসন্মত হোৱা, তেন্তে মই তোমালোকৰ পাপ অনুসাৰে তোমালোকলৈ আৰু সাতগুণ আপদ ঘটাম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","তোমালোকৰ মাজলৈ বনৰীয়া জন্তুবোৰ পঠিয়াম; সেইবোৰে তোমালোকৰ সন্তান নাইকিয়া কৰিব, তোমালোকৰ পশু নষ্ট কৰিব, আৰু তোমালোকৰ সংখ্যা কম কৰিব; আৰু তোমালোকৰ ৰাজ-আলিবোৰ নিজান হৈ পৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ইমানতো যদি মোৰ শিকনি নোলোৱা, কিন্তু মোৰ বিপৰীত আচৰণ কৰা, ");
INSERT INTO asmfb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","তেন্তে মইয়ো তোমালোকৰ বিপৰীত আচৰণ কৰিম আৰু তোমালোকৰ পাপৰ কাৰণে, মই তোমালোকলৈ সাতগুণ আপদ ঘটাম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","আৰু নিয়মটিৰ উলঙ্ঘন প্ৰতিফল দিবলৈ তোমালোকলৈ তৰোৱাল আনিম, আৰু তোমালোকে নগৰৰ মাজত গোট খালে তোমালোকৰ মাজলৈ মহামাৰী পঠিয়াম; আৰু তোমালোকক শত্ৰুৰ হাতত শোধাই দিয়া যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","মই তোমালোকৰ অন্ন ৰূপ লাখুটি ভঙা কালত দহজনী মহিলাই একেটা তন্দুৰত তোমালোকৰ পিঠা তাও দিব, আৰু তেওঁলোকে জোখ কৰি তোমালোকৰ পিঠা তোমালোকক দিব, আৰু তাক খাই তোমালোকৰ ভোক নপলাব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ইমানতো তোমালোকে যদি মোৰ বাক্যলৈ কাণ নিদি মোৰ বিপৰীত আচৰণ কৰা, ");
INSERT INTO asmfb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","তেন্তে মইও ক্ৰোধত তোমালোকৰ বিপৰীত আচৰণ কৰিম, আৰু তোমালোকৰ পাপৰ কাৰণে তোমালোকক সাতগুণ দণ্ড দিম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","তোমালোকে নিজ নিজ পো-জীহঁতৰ মঙহ খাবা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","মই তোমালোকৰ পবিত্র ঠাইবোৰ নষ্ট কৰিম, তোমালোক সুৰ্য্য প্ৰতিমা কাটি পেলাম, আৰু তোমালোকৰ মুৰ্ত্তিবোৰৰ শৱৰ ওপৰত তোমালোকৰ শৱ পেলাম; আৰু মোৰ মনে তোমালোকক ঘিণ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","মই তোমালোকৰ নগৰবোৰ ধ্বংস কৰিম, তোমালোকৰ ধৰ্মধামবোৰ উচ্ছন্ন কৰিম, আৰু তোমালোকৰ সুগন্ধ বস্তুৰ ঘ্ৰাণ গ্ৰহণ নকৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","মই তোমালোকৰ দেশখন উচ্ছন্ন কৰিম; তাতে দেশত থকা তোমালোকৰ শত্ৰুবোৰে তাকে দেখি আচৰিত মানিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","মই জাতিবোৰৰ মাজত তোমালোকক গোট গোট কৰিম, আৰু মোৰ তৰোৱাল উলিয়াই তোমালোকৰ পাছত খেদি যাম; তাতে তোমালোকৰ দেশ উচ্ছন্ন আৰু নগৰবোৰ ধ্বংশ কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","যেতিয়ালৈতে দেশ উচ্ছন্ন হৈ থাকিব আৰু তোমালোক শত্ৰুবোৰৰ দেশত থাকিবা তেতিয়ালৈকে দেশে নিজৰ বিশ্ৰাম-বছৰবোৰ ভোগ কৰিব; সেই কালত দেশে বিশ্ৰাম পাই, নিজৰ বিশ্ৰাম-বছৰবোৰ ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","যিমান কাল সেয়ে উচ্ছন্ন হৈ থাকিব, সিমান কাল বিশ্ৰাম কৰিব; তোমালোকে দেশত বাস কৰা কালত তোমালোকৰ বিশ্ৰাম-বছৰবোৰত যি যি বিশ্ৰাম ভোগ কৰা নাই, দেশে তাক ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","আৰু শত্ৰুৰ দেশত থকা তোমালোকৰ মাজৰ অৱশিষ্ট লোকসকলৰ মনলৈ ব্যাকুলতা পঠিয়াম; আৰু সৰি পৰা পাতৰ শব্দেয়ো তেওঁলোকক পলুৱাব; যেনেকৈ তৰোৱালৰ আগৰ পৰা পলাই তেনেকৈ পলাব; আৰু কোনেও তোমালোকক খেদি নিনিলেও তোমালোক পতিত হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","আৰু কোনেও তোমালোকক খেদি নিনিলেও তৰোৱালৰ আগৰ পৰা পলাওঁতে ইজনে-সিজনৰ লগত খুন্দা খাই পৰিবা; আৰু শত্ৰুবোৰৰ সন্মুখত থিয় হ’বলৈ তোমালোকৰ শক্তি নাথাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","আৰু তোমালোক জাতি সমূহৰ মাজত বিনাশ হ’বা, আৰু তোমালোকৰ শত্ৰুবোৰৰ দেশে তোমালোকক গ্ৰাস কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","আৰু তোমালোকৰ মাজৰ অৱশিষ্ট ভাগ নিজ নিজ অপৰাধৰ কাৰণে শত্ৰুবোৰৰ দেশত ক্ষীণ হৈ যাব, আৰু তেওঁলোকৰ নিজৰ আৰু পুৰ্ব্ব-পুৰুষসকলৰ অপৰাধৰ কাৰণেও ক্ষীণ হৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","কিন্তু যদি তেওঁলোকে আৰু তেওঁলোকৰ পিতৃয়ে কৰা পাপ বা মোৰ সত্যলঙ্ঘন কৰাৰ কাৰণে নিজ নিজ অপৰাধ স্বীকাৰ কৰে, আৰু তেওঁলোকে মোৰ বিপৰীত আচৰণ কৰাত, ");
INSERT INTO asmfb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","মইও তেওঁলোকৰ বিপৰীত আচৰণ কৰি তেওঁলোকক শত্ৰুবোৰৰ দেশলৈ অনাকো স্বীকাৰ কৰে, বিশেষকৈ যদি তেওঁলোকে নিজৰ অচুন্নৎ মন নম্ৰ কৰে, আৰু নিজৰ পাপৰ দণ্ড যোগ্য যেন মানে, ");
INSERT INTO asmfb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","তেন্তে যাকোবেৰে সৈতে কৰা মোৰ নিয়মটি মই সোঁৱৰিম আৰু ইচহাকেৰে সৈতে কৰা মোৰ নিয়মটিও, অব্ৰাহামেৰে সৈতে কৰা মোৰ নিয়মটিও সুঁৱৰিম; আৰু মই দেশকো সোঁৱৰণ কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","দেশ তেওঁলোকৰ দ্বাৰাই পৰিত্যক্ত হ’ব, আৰু তেওঁলোক নথকাকৈ দেশ উচ্ছন্ন হৈ থকা মানে নিজৰ বিশ্ৰাম-বছৰবোৰ ভোগ কৰিব; আৰু তেওঁলোকে নিজ নিজ অপৰাধ দণ্ড যোগ্য যেন মানিব; কিয়নো তেওঁলোকে মোৰ শাসন প্ৰণালীবোৰ অগ্ৰাহ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","তথাপি যেতিয়া তেওঁলোক শত্ৰুবোৰৰ দেশত থাকিব, তেতিয়াও মই শেষ নথকাকৈ বিনষ্ট কৰিবৰ অৰ্থে বা তেওঁলোকৰ সৈতে কৰা মোৰ নিয়মটি ভাঙিবৰ কাৰণে তেওঁলোকক অগ্ৰাহ্য বা ঘিণ নকৰিম; কিয়নো মই তেওঁলোকৰ ঈশ্বৰ যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","কিন্তু মই তেওঁলোকৰ ঈশ্বৰ হ’বৰ অৰ্থে তেওঁলোকৰ যি পুৰ্ব্বপুৰুষসকলক জাতি সমূহৰ আগতে মিচৰ দেশৰ পৰা উলিয়াই আনিলোঁ, তেওঁলোকৰ সেই পুৰ্ব্বপুৰুষসকলৰে সৈতে কৰা মোৰ নিয়মটি তেওঁলোকৰ মঙ্গলৰ অৰ্থে সোঁৱৰিম; মই যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","চীনয় পৰ্ব্বতত যিহোৱাই মোচিৰ দ্বাৰাই নিজৰ আৰু ইস্ৰায়েলৰ সন্তান সকলৰ মাজত এইবোৰ বিধি, শাসন-প্ৰণালী আৰু ব্যৱস্থা স্থাপন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","আৰু এইদৰে যিহোৱাই মোচিক কৈছিল আৰু ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘তোমাৰ নিৰূপিত মূল্য অনুসাৰে যদি কোনোৱে যিহোৱাৰ উদ্দেশ্যে মানুহে দিয়া সঙ্কল্প সিদ্ধ কৰিব খোজে, তলত উল্লেখ কৰা মূল্যৰ ব্যৱহাৰ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","তেন্তে বিশ বছৰতকৈ অধিক আৰু ষাঠি বছৰতকৈ কম বয়স হোৱা পুৰুষৰ কাৰণে হ’লে, পবিত্ৰ স্থানৰ চেকল অনুসাৰে তোমাৰ নিৰূপিত মূল্য পঞ্চাশ চেকল ৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","কিন্তু স্ত্ৰীৰ বাবে হ’লে, তোমাৰ নিৰূপিত মূল্য ত্ৰিশ চেকল হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","আৰু যদি পাঁচ বছৰতকৈ অধিক আৰু বিশ বছৰতকৈ কম বয়সীয়া হয়, তেন্তে পুৰুষৰ বাবে তোমাৰ নিৰূপিত মূল্য বিশ চেকল হ’ব আৰু স্ত্রীৰ বাবে দহ চেকল হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","আৰু যদি এমাহতকৈ অধিক আৰু পাঁচ বছৰতকৈ কম বয়সীয়া হয়, তেন্তে ল’ৰাৰ বাবে তোমাৰ নিৰূপিত মূল্য পাঁচ চেকল হ’ব আৰু ছোৱালীৰ বাবে তিনি চেকল ৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","আৰু যদি ষাঠি বছৰ ও তাতকৈ অধিক বয়সীয়া হয়, তেনেহলে পুৰুষৰ বাবে তোমাৰ নিৰূপিত মূল্য পোন্ধৰ চেকল আৰু স্ত্ৰীৰ বাবে দহ চেকল ৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","কিন্তু যদি লোকজন দুখীয়া হয় আৰু তুমি নিৰূপণ কৰা মূল্য তেওঁ দিবলৈ যদি অক্ষম হয়, তেন্তে পুৰোহিতে তাৰ মূল্য স্থিৰ কৰিব; সঙ্কল্প কৰা লোকজনৰ সমৰ্থ অনুসাৰে পুৰোহিতে তাৰ মূল্য স্থিৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","আৰু যদি যিহোৱাৰ উদ্দেশ্যে কোনো পশু উৎসৰ্গ কৰিবলৈ খোজে আৰু সেই পশু যদি যিহোৱাৰ দৃষ্টিত গ্রহণযোগ্য হয়, তেন্তে সেই পশু সম্পূর্ণৰূপে তেওঁৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","তেওঁ তাৰ অন্যথা বা সলনি নকৰিব, বেয়াৰ সলনি ভাল বা ভালৰ সলনি বেয়া নিদিব; যদি তেওঁ কোনো ৰূপে পশু সলনি কৰে, তেন্তে সেইটো আৰু তাৰ সলনি দিয়াটো পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","আৰু যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিব নোৱাৰা কোনো অশুচি পশু যদি হয়, তেন্তে তেওঁ সেই পশু পুৰোহিতৰ ওচৰলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","সেই পশুৰ ভাল বেয়া বিবেচনা কৰি পুৰোহিতে বজাৰ দৰৰূপে মূল্য স্থিৰ কৰিব। পুৰোহিতে নিৰূপণ কৰাৰ দৰে তাৰ মূল্য স্থিৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","গৰাকীয়ে যদি কোনো ৰূপে তাক মুকলি কৰিব খোজে, তেন্তে তেওঁ তোমাৰ নিৰূপিত মূল্যৰ পাঁচভাগৰ এভাগ বেছিকৈ দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","আৰু যদি কোনো লোকে তেওঁৰ ঘৰ যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হবলৈ ইচ্ছা কৰে, তেন্তে সেই ঘৰ ভাল বেয়া বিবেচনা কৰি পুৰোহিতে তাৰ মূল্য স্থিৰ কৰিব। পুৰোহিতে নিৰূপণ কৰাৰ দৰে তাৰ মূল্য স্থিৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","আৰু গৰাকীয়ে তেওঁ পবিত্ৰ কৰা ঘৰ যদি মোকলাব খোজে, তেন্তে তেওঁ নিৰূপিত মূল্যৰ পাঁচভাগৰ এভাগ বেচিকৈ দিব; আৰু তেতিয়া সেই ঘৰ তেওঁৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","আৰু যদি কোনোৱে নিজৰ আধিপত্যৰ মাটি কোনো এভাগ যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ কৰিব খোজে, তেন্তে তাত সিচাঁ কঠিয়া অনুসাৰে তোমাৰ নিৰূপিত মূল্য হব। এক হোমৰ যৱ সিঁচিবা পৰা মাটিৰ মূল্য পঞ্চাশ চেকল ৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","যদি তেওঁ যোৱেল বছৰ যোৱা মাত্ৰকে নিজৰ সেই ডোখৰ মাটি পবিত্ৰ কৰে, তেন্তে তোমাৰ নিৰূপিত মূল্য অনুসাৰে সেয়ে স্থিৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","আৰু যদি তেওঁ যোৱেল বছৰৰ কিছু কালৰ পাছত নিজৰ মাটি পবিত্ৰ কৰে, তেন্তে পুৰোহিতে যোৱেল বছৰলৈকে বাকী থকা বছৰৰ সংখ্যা অনুসাৰে তালৈ হিচাপ কৰিব আৰু নিৰূপিত মূল্য কম কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","আৰু যদি সেই মাটি পবিত্ৰ কৰাজনে কোনো ৰূপে তাক মুকলি কৰিব খোজে তেন্তে তেওঁ নিৰূপিত মূল্যৰ পাঁচভাগৰ এভাগ বেছিকৈ দিব, তাতে সেইয়ে তেওঁৰ নিজৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","কিন্তু যদি তেওঁ সেই মাটি মুকলি নকৰে বা যদি আন কোনোজনক বেচি দিয়ে, তেন্তে তাক আৰু মোকলোৱা নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","কিন্তু সেই মাটি যোৱেল বছৰত মুকলি হৈ, বৰ্জিত কৰি দিয়া মাটিৰ নিচিনাকৈ যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হ’ব; আৰু তাত পুৰোহিতৰহে অধিকাৰ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","আৰু যদি কোনোৱে নিজৰ পৈত্রিক ভুমিৰ বাহিৰে নিজে কিনি লোৱা মাটি এডোখৰ যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ কৰে, ");
INSERT INTO asmfb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","তেন্তে যোৱেল বছৰলৈকে তুমি নিৰূপণ কৰা মূল্য পুৰোহিতে তাক হিচাপ কৰা দিব; তেওঁ সেই দিনাই, যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হোৱা বস্তুৰূপে তোমাৰ নিৰূপিত মূল্য দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","সেই মাটি যাৰ পৰা কিনা হৈছিল, তেওঁ, সেই মাটিৰ যাৰ স্বত্ত্ব আছিল, তেওঁৱেই যোৱেল বছৰত তাক পুনৰায় পাব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","আৰু তুমি নিৰূপণ কৰা আটাই মূল্য পবিত্ৰ স্থান চেকল অনুসাৰে হব; বিশ গেৰাই এক চেকল হয়। ");
INSERT INTO asmfb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","তথাপি প্ৰথমে জগা বুলি যি পশু যিহোৱাৰ, পশুবোৰৰ মাজত সেই প্ৰথমে জগা পশু কোনেও পবিত্ৰ কৰিব নোৱাৰিব; গৰু, মেৰ, বা ছাগলী হওক, সেয়ে যিহোৱাৰেই। ");
INSERT INTO asmfb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","যদি সেই পশু অশুচি পশু হয়, তেন্তে উৎসৰ্গ কৰা জনে নিৰূপিত মূল্যৰ পাঁচভাগৰ এভাগ বেছলৈ দি তাক মোকলাব পাৰে। মোকলোৱা নহ’লে, নিৰূপণ কৰা মূল্যত তাক বেচা যাব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","তথাপি মানুহ বা পশু হওক বা নিজ আধিপত্যৰ মাটিয়েই হওক, যি কোনো মানুহে নিজৰ সৰ্ব্বস্বৰ পৰা যিহোৱাৰ উদ্দেশ্যে বৰ্জিত কৰি দিয়ে, সেই বৰ্জিত বস্তু বেচা মোকলোৱা নাযাব; প্ৰত্যেক বৰ্জিত বস্তু যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","মানুহৰ মাজত যাক বৰ্জিত কৰি দিয়া হয়, সেই বৰ্জিত লোকক মোকলোৱা নাযাব; নিশ্চয়ে তেওঁক বধ কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","আৰু ভুমিৰ শস্য বা গছৰ গুটিয়েই হওক, ভুমিৰ উৎপন্ন সকলো বস্তুৰ দশম ভাগ যিহোৱাৰ হ’ব; সেয়ে যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","আৰু যদি কোনোৱে নিজৰ দশম ভাগৰ কিছু মোকলাব খোজে, তেন্তে তেওঁ তাৰ পাঁচভাগৰ এভাগ বেছিকৈ দিব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","আৰু গৰু বা মেৰ বা ছাগলীৰ জাকৰ আটাই দশমভাগ, লাখুটিৰ তলেদি যোৱা সকলৰ দশমভাগ যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","তাৰ ভাল বেয়া বিচাৰ নকৰিব আৰু তাক নসলাব। কিন্তু যদি তেওঁ কোনো প্ৰকাৰে তাক সলায়, তেন্তে সেইটো আৰু সলনি দিয়াটো দুয়োটাও পবিত্ৰ হ’ব। তাক মোকলোৱা নাযাব’।” ");
INSERT INTO asmfb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","এইবোৰ আজ্ঞাই ইস্ৰায়েলৰ সন্তান সকলৰ বাবে যিহোৱাই চীনয় পৰ্ব্বতত মোচিক দিছিল।");
INSERT INTO asmfb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","পাছত মিচৰ দেশৰ পৰা লোকসকল ওলাই যোৱাৰ দ্বিতীয় বছৰৰ দ্বিতীয় মাহৰ প্ৰথম দিনা, চীনয় মৰুভূমিত সাক্ষাৎ কৰা তম্বুত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“তোমালোকে গোষ্ঠী অনুসাৰে আৰু পিতৃ বংশৰ নামৰ সংখ্যা অনুসাৰে ইস্ৰায়েলৰ সন্তানসকলৰ গোটেই মণ্ডলীৰ প্ৰত্যেক জনৰ নাম অনুসাৰে গণনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া যিমান পুৰুষ ইস্ৰায়েলৰ মাজত যুদ্ধলৈ যাব পৰা অৱস্থাত আছে, তেওঁলোকৰ সৈন্যদল অনুসাৰে তুমি আৰু হাৰোণে তেওঁলোকক গণনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","প্ৰত্যেক ফৈদৰ এজন এজন লোক, নিজ নিজ পিতৃবংশৰ প্রধান লোক, তেওঁলোকৰ নিজ নিজ ফৈদৰ বিষয়া হিচাবে তোমালোকৰ লগত সহায় কৰোঁতা হ’ব লাগিব। সেই প্রত্যেকজন বিষয়াই নিজ নিজ ফৈদৰ অনুসাৰে যুদ্ধ কৰিবলৈ নেতৃত্ব দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","যি সকল লোকে তোমালোকক সহায় কৰিবলৈ আহিব, সেই সহায় কৰোঁতা লোকসকলৰ নামবোৰ হ’ল: ৰূবেণ ফৈদৰ পৰা চদেয়ূৰৰ পুত্ৰ ইলীচূৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","চিমিয়োন ফৈদৰ পৰা চূৰীচদ্দয়ৰ পুত্ৰ চলমীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","যিহূদা ফৈদৰ পৰা অম্মীনাদবৰ পুত্ৰ নহচোন। ");
INSERT INTO asmfb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ইচাখৰ ফৈদৰ পৰা চূৱাৰৰ পুত্ৰ নথনেল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","জবূলূন ফৈদৰ পৰা হেলোনৰ পুত্ৰ ইলীয়াব। ");
INSERT INTO asmfb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","যোচেফৰ সন্তানসকলৰ মাজত ইফ্ৰয়িম ফৈদৰ পৰা অম্মীহূদৰ পুত্ৰ ইলীচামা, আৰু আন এজন হ’ল, মনচি ফৈদৰ পৰা পদাচূৰৰ পুত্ৰ গম্লীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","বিন্যামীন ফৈদৰ পৰা গিদিয়োনীৰ পুত্ৰ অবীদান। ");
INSERT INTO asmfb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","দান ফৈদৰ পৰা অম্মীচদ্দয়ৰ পুত্ৰ অহীয়েজৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","আচেৰ ফৈদৰ পৰা আক্ৰণৰ পুত্ৰ পগীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","গাদ ফৈদৰ পৰা দুৱেলৰ পুত্ৰ ইলিয়াচফ। ");
INSERT INTO asmfb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","নপ্তালী ফৈদৰ পৰা ঐননৰ পুত্ৰ অহীৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","এইসকল লোকেই মণ্ডলীৰ আমন্ত্ৰিত লোক আছিল। তেওঁলোক নিজ নিজ পিতৃ-বংশৰ অধ্যক্ষ আৰু ইস্ৰায়েলৰ গোষ্ঠীসকলৰ প্রধান লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","তেতিয়া মোচি আৰু হাৰোণে নামেৰে উল্লেখ কৰা সেই লোকসকলক লগত ল’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","আৰু তেওঁলোকৰ সৈতে দ্বিতীয় মাহৰ প্ৰথম দিনাই গোটেই মণ্ডলীক গোটালে। তেতিয়া মণ্ডলীৰ লোকসকলে নিজ নিজ গোষ্ঠী অনুসাৰে আৰু পিতৃ-বংশমতে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া লোকসকলৰ নাম আৰু তেওঁলোকৰ সংখ্যা অনুসাৰে সকলোৰে বংশাৱলী নামাকৰণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","এইদৰে মোচিয়ে যিহোৱাৰ আজ্ঞা অনুসাৰে চীনয় মৰুভূমিত তেওঁলোকৰ গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ইস্ৰায়েলৰ প্ৰথমে জন্মা ৰূবেণ গোষ্ঠীৰ পৰা সকলো লোকক গণনা কৰা হ’ল, আৰু পূৰ্বপুৰুষ আৰু পৰিয়ালৰ নথি অনুসাৰে প্ৰতিজন বিশ বছৰ বা তাতকৈ অধিক বয়সীয়া যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ৰূবেণ ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা ছয়চল্লিশ হাজাৰ পাঁচশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","চিমিয়োনৰ গোষ্ঠীৰ পৰা সকলো লোকক গণনা কৰা হ’ল, আৰু এওঁলোক পূৰ্বপুৰুষৰ বংশৰ আৰু পৰিয়ালৰ নথিৰ পৰা যুদ্ধলৈ যাব পৰা বিশ বছৰ বা তাতকৈ অধিক বয়সীয়া লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","চিমিয়োনৰ সেই ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা ঊনষাঠি হাজাৰ তিনিশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","গাদ গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","গাদৰ ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা পঞ্চল্লিশ হাজাৰ ছশ পঞ্চাশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","যিহূদা গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","যিহূদা ফৈদৰ গণনা কৰা সেই লোকসকলৰ সংখ্যা চৌসত্তৰ হাজাৰ ছশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ইচাখৰ গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ইচাখৰ ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা চৌৱন্ন হাজাৰ চাৰিশ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","জবূলূন গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","জবূলূন ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা সাতাৱন হাজাৰ চাৰিশ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","যোচেফৰ সন্তান ইফ্ৰয়িম গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ইফ্ৰয়িম ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা চল্লিশ হাজাৰ পাঁচ শ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","মনচিৰ গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","মনচি ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা বত্ৰিশ হাজাৰ দুশ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","বিন্যামীন গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","বিন্যামীন ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা পঁয়ত্ৰিশ হাজাৰ চাৰিশ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","দান গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","দান ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা বাষষ্ঠি হাজাৰ সাত শ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","আচেৰ গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","আচেৰ ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা আছিল একচল্লিশ হাজাৰ পাঁচশ জন। ");
INSERT INTO asmfb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","নপ্তালী গোষ্ঠীৰ সকলো লোককে গণনা কৰা হ’ল আৰু এওঁলোক প্ৰতিজনে পূর্বপুৰুষৰ বংশ আৰু পৰিয়ালৰ নথি অনুসাৰে বিশ বছৰ আৰু তাতকৈ অধিক বয়সীয়া, যুদ্ধলৈ যাব পৰা লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","নপ্তালী ফৈদৰ পৰা গণনা কৰা সেই লোকসকলৰ সংখ্যা তেপন্ন হাজাৰ চাৰিশ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","মোচি আৰু হাৰোণে এইদৰে আটাই লোককে গণনা কৰিলে আৰু তেওঁলোকৰ সৈতে ইস্ৰায়েলৰ গোষ্ঠী সমূহক নেতৃত্ব দিয়া, সেই বাৰ জন অধ্যক্ষকো গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","এইদৰে যি সকলে যুদ্ধলৈ যাব পাৰে, এনে বিশ বছৰ বা তাতকৈ বয়সীয়া ইস্ৰায়েলৰ সকলো লোকক পৰিয়াল অনুসাৰে গণনা কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","গণনা কৰা সেই লোকসকলৰ সংখ্যা ছয় লাখ তিনি হাজাৰ পাঁচশ পঞ্চাশ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","কিন্তু লেবী গোষ্ঠীৰ পৰা হোৱা লেবীয়াসকলক গণনা কৰা নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","কিয়নো যিহোৱাই মোচিক কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","‘তুমি লেবী ফৈদক সৰ্বমুঠ ইস্ৰায়েলৰ সন্তান সকলৰ মাজত তেওঁলোকক গণনা বা অন্তৰ্ভুক্ত নকৰিবা।’ ");
INSERT INTO asmfb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","কিন্তু বিধানৰ নিয়ম চন্দুক থকা আবাস, তাৰ সকলো বস্তু আৰু তাৰ সম্পৰ্কীয় সকলোৰে ওপৰত লেবীয়াসকলক যত্ন লবলৈ নিযুক্ত কৰিবা। তেওঁলোকে নিয়ম চন্দুকৰ আবাস আৰু তাৰ আটাই বস্তুৰ ভাৰ বৈ নিব লাগিব। তেওঁলোকে তাৰ পৰিচৰ্যা কৰি আবাসৰ চাৰিওফালে তম্বু তৰি থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","আৰু যেতিয়া নিয়ম চন্দুকৰ আবাসখন আন ঠাইলৈ নিব লগা হয়, তেতিয়া লেবীয়াসকলেহে তাক খণ্ড-বিখণ্ডকৈ খুলিব। পাছত নিয়ম চন্দুকৰ আবাসখন স্থাপন কৰাৰ সময়ত তেওঁলোকেই তাক সাজিব। আৰু যি লোক সেই আবাসৰ ওচৰলৈ আহিব, তেওঁৰ প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ইস্ৰায়েলৰ সন্তানসকলে নিজ নিজ সৈন্যদল অনুসাৰে নিজ নিজ ছাউনিৰ পতাকাৰ গুৰিত, তম্বু তৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","কিন্তু ইস্ৰায়েলৰ লোকসকলৰ ওপৰত মোৰ ক্ৰোধ নহ’বলৈ, নিয়ম চন্দুক থকা সেই আবাসৰ চাৰিওফালে লেবীয়াসকলে তম্বু তৰি থাকিব লাগিব। নিয়ম চন্দুক থকা আবাসখন লেবীয়াসকলৰ জিম্মাত থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ইস্ৰায়েলৰ সন্তানসকলে সেইদৰে এই সকলোকে কৰিলে। যিহোৱাই মোচিৰ দ্ৱাৰাই দিয়া আজ্ঞা অনুসাৰে তেওঁলোকে আটাই কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","যিহোৱাই পুনৰায় মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ইস্ৰায়েলৰ সন্তান সকলে তেওঁলোকৰ নিজ নিজ সৈন্য দলৰ পিতৃ-বংশৰ পতাকাৰ গুৰিৰ চৰিওফালে তম্বু তৰি থাকিব লাগিব। তেওঁলোকৰ তম্বু সাক্ষাৎ কৰা তম্বুলৈ মুখ কৰি থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","যিহূদাৰ ছাউনিৰ অধীনত থকা লোকসকলে নিজ নিজ সৈন্যদল অনুসাৰে, পূৱদিশে থকা সাক্ষাৎ কৰা তম্বুৰ ফালে অৰ্থাৎ সূৰ্য উদয় হোৱা দিশে তম্বু তৰি যিহূদাৰ পতাকাৰ চাৰিওফালে থাকিব লাগিব। অম্মীনাদবৰ পুত্ৰ নহচোন যিহূদাৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","তেওঁৰ সৈন্য সমূহৰ গণিত লোক আছিল চৌসত্তৰ হাজাৰ ছশ জন। ");
INSERT INTO asmfb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","তেওঁলোকৰ কাষত ইচাখৰ ফৈদে তম্বু তৰি থাকিব লাগিব। চূৱাৰৰ পুত্ৰ নথনেলে ইচাখৰৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","নথনেলৰ সৈন্যৰ সংখ্যা আছিল চৌৱন্ন হাজাৰ চাৰিশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ইচাখৰৰ গোষ্ঠীৰ কাষত জবূলূনৰ গোষ্ঠীয়ে ছাউনি পাতিব লাগিব। হেলোনৰ পুত্ৰ ইলীয়াব জবূলূনৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","জবূলূনৰ সৈন্যৰ সংখ্যা আছিল সাতাৱন হাজাৰ চাৰিশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","যিহূদাৰ ছাউনিৰ গণিত লোক, নিজ নিজ সৈন্যদল অনুসাৰে, সৰ্ব্বমুঠ আছিল এক লাখ ছয়াশী হাজাৰ চাৰিশ জন। প্ৰথমে তেওঁলোকে ছাউনিৰ পৰা প্ৰস্থান কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","দক্ষিণ দিশে থকা সৈন্যদলবোৰে ৰূবেণৰ ছাউনিৰ পতাকাৰ চাৰিওফালে থাকিব। চদেয়ূৰৰ পুত্ৰ ইলীচূৰ ৰূবেণৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ৰূবেনৰ সৈন্যৰ সংখ্যা আছিল ছয়চল্লিশ হাজাৰ পাঁচশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","তেওঁলোকৰ কাষত চিমিয়োনৰ গোষ্ঠীয়ে তম্বু তৰি থাকিব। চূৰীচদ্দয়ৰ পুত্ৰ চলমীয়েল চিমিয়োনৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","চিমিয়োনৰ সৈন্যৰ সংখ্যা আছিল ঊনষাঠি হাজাৰ তিনিশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","তেওঁলোকৰ কাষত গাদৰ ফৈদ থাকিব। ৰূৱেলৰ পুত্ৰ ইলিয়াচফ গাদৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","গাদৰ সৈন্যৰ সংখ্যা আছিল পঞ্চল্লিশ হাজাৰ ছশ পঞ্চাশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ৰূবেণৰ ছাউনিৰ গণিত লোক, নিজ নিজ সৈন্যদল অনুসাৰে, সৰ্ব্বমুঠ আছিল এক লাখ একাৱন্ন হাজাৰ চাৰিশ পঞ্চাশ জন। তেওঁলোকে দ্বিতীয় হৈ ছাউনিৰ পৰা প্ৰস্থান কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","তেওঁলোকৰ সৈন্যদলৰ পাছত ছাউনিবোৰৰ মাজত লেবীয়াসকলৰ ছাউনি ৰাখি, সাক্ষাৎ কৰা তম্বু নিয়া হ’ব; প্ৰতিজনে যি দৰে তম্বু তৰে, সেই দৰে নিজ নিজ শ্ৰেণীত থাকি, নিজ নিজ পতাকাৰ কাষে কাষে প্ৰস্থান কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","সাক্ষাৎ কৰা তম্বুৰ পশ্চিম দিশে, নিজ নিজ সৈন্যদল অনুসাৰে, ইফ্ৰয়িমৰ ফৈদে ছাউনি পাতি থাকিব। অম্মীহূদৰ পুত্ৰ ইলীচামা ইফ্ৰয়িমৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ইফ্ৰয়িমৰ সৈন্যৰ সংখ্যা আছিল চল্লিশ হাজাৰ পাঁচ শ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","তেওঁলোকৰ কাষত মনচিৰ ফৈদ থাকিব। পদাচূৰৰ পুত্ৰ গম্লীয়েল মনচিৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","মনচিৰ সৈন্যৰ সংখ্যা আছিল বত্ৰিশ হাজাৰ দুশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","তেওঁলোকৰ পাছত আহিব বিন্যামীনৰ ফৈদ। গিদিয়োনীৰ পুত্ৰ অবীদান বিন্যামীনৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","বিন্যামীনৰ সৈন্যৰ সংখ্যা আছিল পঁয়ত্ৰিশ হাজাৰ চাৰিশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ইফ্ৰয়িমৰ ছাউনিৰ গণিত লোক, নিজ নিজ সৈন্যদল অনুসাৰে, সৰ্ব্বমুঠ আছিল এক লাখ আঠ হাজাৰ এশ জন। তেওঁলোকে তৃতীয় হৈ প্ৰস্থান কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","সাক্ষাৎ কৰা তম্বুৰ উত্তৰ দিশে দানৰ সৈন্যদলে তেওঁলোকৰ পতাকাৰ চাৰিওফালে ছাউনি পাতিব। অম্মীচদ্দয়ৰ পুত্ৰ অহীয়েজৰ দানৰ সন্তান সকলৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","দানৰ সৈন্যৰ সংখ্যা আছিল বাষষ্ঠি হাজাৰ সাতশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","তেওঁলোকৰ কাষতে আচেৰৰ ফৈদে তম্বু তৰি থাকিব। আক্ৰণৰ পুত্ৰ পগীয়েল আচেৰৰ সন্তান সকলৰ অধ্যক্ষ হ’ব; ");
INSERT INTO asmfb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","আচেৰৰ সৈন্যৰ সংখ্যা আছিল একচল্লিশ হাজাৰ পাঁচ শ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","তেওঁলোকৰ পাছত আহিব নপ্তালীৰ গোষ্ঠী। ঐননৰ পুত্ৰ অহীৰা নপ্তালীৰ সন্তান সকলৰ অধ্যক্ষ হ’ব; ");
INSERT INTO asmfb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","নপ্তালীৰ সৈন্যৰ সংখ্যা আছিল তেপন্ন হাজাৰ চাৰিশ। ");
INSERT INTO asmfb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","দানৰ ছাউনিৰ গণিত লোক সৰ্ব্বমুঠ আছিল একলাখ সাতাৱন হাজাৰ ছশ জন। তেওঁলোকে ছাউনিৰ পৰা নিজ নিজ পতাকা লৈ, শেষত প্ৰস্থান কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ইস্ৰায়েলৰ সন্তান সকলৰ পিতৃ-বংশৰ সৰ্ব্বমুঠ ছয় লাখ তিনি হাজাৰ পাঁচশ পঞ্চাশ জন সৈন্যদল অনুসাৰে ছাউনিবোৰৰ গণিত লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","কিন্তু যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰে, লেবীয়াসকলক ইস্ৰায়েলৰ সন্তান সকলৰ মাজত গণনা কৰা নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","যিহোৱাই মোচিৰ দ্ৱাৰা দিয়া আজ্ঞা অনুসাৰে ইস্ৰায়েলৰ সন্তান সকলে সেই সকলো কাৰ্য কৰিলে। তেওঁলোকে নিজ নিজ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে নিজ নিজ পতাকাৰ তলত তম্বু তৰিলে আৰু সেই দৰেই প্ৰস্থান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","যি কালত যিহোৱাই চীনয় পৰ্বতত মোচিক কথা কৈছিল, সেই সময়ৰ হাৰোণ আৰু মোচিৰ বংশৰ জীৱনি এয়ে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","হাৰোণৰ পুত্ৰসকলৰ মাজত প্ৰথমে জন্ম পোৱা জনৰ নাম নাদব, তাৰ পাছত অবীহূ, ইলিয়াজৰ আৰু ঈথামৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","পুৰোহিতৰ কৰ্ম কৰিবলৈ যিসকলক তেওঁ নিযুক্ত কৰিছিল, সেই অভিষিক্ত পুৰোহিত হাৰোণৰ পুত্ৰসকলৰ নাম এয়ে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","কিন্তু নাদব আৰু অবীহূৱে চীনয় পৰ্ব্বতৰ মৰুপ্রান্তত যিহোৱাৰ আগলৈ অগ্রহণীয় সাধাৰণ জুই নিওতে যিহোৱাৰ আগতে প্ৰাণ ত্যাগ কৰিলে। নাদব আৰু অবীহূৰ কোনো সন্তান নাছিল, এই হেতুকে, ইলিয়াজৰ আৰু ঈথামৰে নিজ পিতৃ হাৰোণৰ সৈতে পুৰোহিতৰ কৰ্ম কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","যিহোৱাই মোচিক কথা কৈছিল। তেওঁ কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“হাৰোণ পুৰোহিতৰ পৰিচৰ্যাত সহায় কৰিবলৈ, তুমি লেবীৰ ফৈদক তেওঁৰ সন্মুখলৈ আনা। ");
INSERT INTO asmfb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","আবাসৰ পৰিচৰ্যা কৰি, সাক্ষাৎ কৰা তম্বুৰ আগত হৰোণৰ আৰু গোটেই ইস্রায়েলৰ হৈ যি যি কৰিবলগীয়া আছে, সেয়া তেওঁলোকে সম্পন্ন কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","আবাসৰ কাৰ্য কৰি সাক্ষাৎ কৰা তম্বুৰ আটাই বস্তুৰ বাবে যি যি যত্ন ল’ব লগীয়া আৰু ইস্ৰায়েলৰ সন্তান সকলৰ যি যি কৰিব লগীয়া, তাত তেওঁলোকে সহায় কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","আৰু তুমি লেবীয়াসকলক হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক দিবা। ইস্ৰায়েলৰ সন্তান সকলৰ পৰিচর্যাত সহায় কৰিবলৈ সম্পূৰ্ণৰূপে তেওঁলোকক তেওঁলৈ দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","তুমি হাৰোণক আৰু তেওঁৰ পুত্ৰসকলক পুৰোহিত ৰূপে নিযুক্ত কৰিবা, কিন্তু আন বংশৰ যিকোনো লোক ওচৰলৈ আহিলে তেওঁৰ প্ৰাণদণ্ড হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","যিহোৱাই মোচিক কথা কৈছিল। তেওঁ কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“চোৱা, মই ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা লেবীয়াসকলক ল’লো। ইস্ৰায়েলৰ সন্তান সকলৰ মাজত গৰ্ভভেদ কৰি অহা প্ৰথমে জন্ম পোৱা সকলৰ সলনি লবলৈ মই ইয়াকে কৰিলোঁ। এই হেতুকে লেবীয়াসকল মোৰেই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","কিয়নো সকলো প্ৰথমে জন্ম পোৱা সকল মোৰেই। যিদিনা মিচৰ দেশত সকলো প্ৰথমে জন্ম পোৱা সকলক ধংস কৰিছিলোঁ, সেই দিনাই মানুহৰ পৰা জীৱ-জন্তুলৈকে ইস্ৰায়েলৰ আটাই প্ৰথমে জন্ম পোৱা সকলক মোৰ অৰ্থে পবিত্ৰ কৰিলোঁ। এতেকে সেই সকলো মোৰেই হ’ব। মই যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","চীনয় মৰুপ্রান্তত যিহোৱাই মোচিক কৈছিল। তেওঁ কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“তুমি নিজ নিজ পিতৃ-বংশ আৰু গোষ্ঠী অনুসাৰে লেবীৰ সন্তান সকলক গণনা কৰা। এমহীয়া আৰু তাতকৈ অধিক বয়সীয়া আটাই পুৰুষক গণনা কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","তাতে মোচিয়ে যেনেকৈ যিহোৱাৰ পৰা আজ্ঞা পালে, তেনেকৈ যিহোৱাৰ বাক্যৰ দৰেই তেওঁলোকক গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","লেবীৰ পুত্ৰসকলৰ নাম আছিল গেৰ্চোন, কহাৎ আৰু মৰাৰী। ");
INSERT INTO asmfb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","আৰু নিজ নিজ বংশ অনুসাৰে গেৰ্চোনৰ পুতেক সকলৰ নাম লিবনী আৰু চিমিয়ী আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","আৰু নিজ নিজ বংশ অনুসাৰে কহাতৰ পুতেক সকলৰ নাম অম্ৰম, যিচহৰ, হিব্ৰোণ আৰু উজ্জীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","আৰু নিজ নিজ বংশ অনুসাৰে মৰাৰীৰ পুতেক সকলৰ নাম মহলী আৰু মুচী। নিজ নিজ পিতৃ-বংশ অনুসাৰে এই সকলেই লেবীয়াসকলৰ বংশ। ");
INSERT INTO asmfb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","গেৰ্চোনৰ পৰা লিবনীয়া সকলৰ বংশ আৰু চিমিয়ীয়া সকলৰ বংশ উৎপন্ন হ’ল। এওঁলোকেই হ’ল গেৰ্চোনীয়া সকলৰ বংশ। ");
INSERT INTO asmfb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","এওঁলোকৰ এমহীয়া আৰু তাতকৈ অধিক বয়সীয়া আটাই পুৰুষকে গণনা কৰা হ’ল, এওঁলোকৰ গণিত লোক সাত হাজাৰ পাঁচশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","গেৰ্চোনীয়া সকলৰ দুই বংশই আবাসৰ পশ্চিম দিশে তম্বু তৰি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","লায়েলৰ পুত্ৰ ইলিয়াচফ গেৰ্চোনীয়া সকলৰ পিতৃ-বংশৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","গেৰ্চোনৰ পৰিয়ালে আবাসৰ আৱৰণৰ ভিতৰত থকা সাক্ষাৎ কৰা তম্বুৰ দুৱাৰৰ পৰ্দ্দাৰ যত্ন ল’ব। পৰ্দা তম্বু, তাৰ আৱৰণ আৰু প্রবেশ দুৱাৰৰ পৰ্দাবোৰৰ যত্ন ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","আবাসৰ আৰু যজ্ঞবেদীৰ চাৰিওফালে থকা চোতালৰ আঁৰ কাপোৰবোৰ আৰু তাৰ দুৱাৰৰ পৰ্দ্দাবোৰৰ যত্ন ল’ব। তাৰ আটাই কামৰ ৰছী, সাক্ষাৎ কৰা তম্বুৰ এই সকলো বস্তু তেওঁলোকৰ জিম্মাত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","কহাতৰ পৰা অম্ৰীময়া সকলৰ বংশ, যিচহৰীয়া সকলৰ বংশ, হিব্ৰোণীয়া সকলৰ বংশ আৰু উজ্জীয়েলীয়া সকলৰ বংশৰ জন্ম হ’ল; এই সকলো কহাতীয়া সকলৰ গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","এওঁলোকৰ এমহীয়া আৰু তাতকৈ অধিক বয়সীয়া আটাই পুৰুষৰ সংখ্যা আঠ হাজাৰ ছশ জন, পবিত্ৰ স্থানৰ যি যি কৰিবলগীয়া, তাক এওঁলোকেই কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","কহাতৰ সন্তান সকলৰ বংশবোৰে আবাসৰ দক্ষিণফালে তম্বু কৰি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","আৰু উজ্জীয়েলৰ পুত্ৰ ইলিচাফন কহাতীয়া গোষ্ঠী সকলৰ পিতৃ-বংশৰ অধ্যক্ষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","আৰু চন্দুক, মেজ, দীপাধাৰ বেদীবোৰ, পবিত্ৰ স্থানৰ পৰিচৰ্যা কৰা আটাই বস্তুবোৰ যত্ন ল’ব। আৰু আঁৰ কৰি ৰখা বস্ত্ৰবোৰ তেওঁলোকৰ জিম্মাত থাকিব আৰু তাৰ সম্পৰ্কীয় সকলো কাৰ্য তেওঁলোকে কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","আৰু হাৰোণ পুৰোহিতৰ পুত্ৰ ইলিয়াজৰ লেবীয়া সকলৰ অধ্যক্ষৰো অধ্যক্ষ হ’ব। যিসকলৰ জিম্মাত পবিত্ৰ স্থান থাকিব, তেওঁলোকৰ ওপৰত তেওঁ নিযুক্ত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","মৰাৰীৰ পৰা মহলীয়া সকলৰ বংশ আৰু মুচীয়া সকলৰ বংশ উৎপন্ন হ’ল। এওঁলোকেই মৰাৰীয়া সকলৰ গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","এওঁলোকৰ এমাহ আৰু তাতকৈ অধিক বয়সীয়া আটাই পুৰুষৰ সংখ্যা ছয় হাজাৰ দুশ জন। ");
INSERT INTO asmfb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","অবীহয়িলৰ পুত্ৰ চুৰীয়েল মৰাৰীৰ গোষ্ঠী সকলৰ পিতৃ-বংশৰ অধ্যক্ষ হ’ব। তেওঁলোকে আবাসৰ উত্তৰফালে কাষত তম্বু তৰি থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","আবাসৰ তক্তা, তাৰ ডাং, তাৰ খুঁটা, তাৰ চুঙী আৰু তাৰ সকলো বস্তু মৰাৰীৰ সন্তান সকলৰ জিম্মাত থাকিব আৰু তাৰ সম্পৰ্কীয় আটাই কাৰ্য তেওঁলোকে কৰিব, ");
INSERT INTO asmfb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ইয়াৰ লগতে চোতালৰ চাৰিওফালে থকা খুটাবোৰ আৰু সেইবোৰৰ চুঙী, খুটি আৰু ৰছী তেওঁলোকৰ জিম্মাত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","মোচি, হাৰোণ আৰু তেওঁৰ পুত্রসকলে পূৱফালে আবাসৰ আগত, সূৰ্য উদয় হোৱা ফালে, সাক্ষাৎ কৰা তম্বুৰ আগত তম্বু তৰি থাকিব। ইস্ৰায়েলৰ সন্তান সকলৰ পবিত্ৰ স্থানৰ বিষয়ে যি কৰিব লগীয়া, তাৰ কাৰ্য তেওঁলোকৰ জিম্মাত থাকিব। বিদেশী যি কোনো লোক তাৰ ওচৰ চাপিলে তেওঁৰ প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","মোচি আৰু হাৰোণে যিহোৱাৰ আজ্ঞাৰ দৰে নিজ নিজ বংশ অনুসাৰে যি লেবীয়া সকলক গণনা কৰিলে, লেবীয়া সকলৰ সেই গণিত লোক, এমহীয়া আৰু তাতকৈ অধিক বয়সীয়া পুৰুষৰ সংখ্যা সৰ্ব্বমুঠ বাইচ হাজাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","পাছত যিহোৱাই মোচিক ক’লে, “তুমি ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ, এমহীয়া আৰু তাতকৈ অধিক বয়সীয়া প্ৰথমে জন্ম পোৱা সকলো পুৰুষক গণনা কৰা আৰু তেওঁলোকৰ নামৰ তালিকা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","আৰু মোৰ অৰ্থে, তুমি ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰথমে জন্মা আটাই মানুহৰ সলনি লেবীয়া সকলক গ্রহণ কৰা। ময়েই যিহোৱা। আৰু ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰথমে জগা আটাই পশুৰ সলনি লেবীয়া সকলৰ পশুবোৰ গ্ৰহণ কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","মোচিয়ে যিহোৱাৰ আজ্ঞা অনুসাৰে ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ প্ৰথমে জন্মা আটাই লোকসকলক গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","তেওঁলোকৰ এমহীয়া আৰু তাতকৈ অধিক বয়সীয়া প্ৰথমে জন্মা সকলো পুৰুষৰ নামে সৈতে তেওঁ গণনা কৰিলে। তেওঁৰ গণনাত সংখ্যা বাইশ হাজাৰ দুশ ত্ৰেসত্তৰ জন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","পাছত যিহোৱাই মোচিক কথা ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“তুমি ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰথমে জন্মা আটাই লোকৰ সলনি লেবীয়া সকলক লোৱা। আৰু তেওঁলোকৰ পশুবোৰৰ সলনি লেবীয়া সকলৰ পশুবোৰ লোৱা। লেবীয়া সকল মোৰেই হ’ব। ময়েই যিহোৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","তেওঁলোকক মুকলি কৰিবৰ বাবে, ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰথমে জন্ম পোৱা সকলৰ মাজত লেবীয়া সকলৰ সংখ্যাতকৈ বঢ়া যি দুশ ত্ৰেসত্তৰ জন লোক আছে, ");
INSERT INTO asmfb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","তুমি তেওঁলোকৰ সলনি এজন এজনৰ সলনি পাঁচ চেকলকৈ ল’বা; বিশ গেৰাই এক চেকল হয়। ");
INSERT INTO asmfb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","আৰু সেই সংখ্যাতকৈ বৃদ্ধ লোকসকলক যি ধনেৰে মুকলি কৰা হ’ব, সেই ধন হাৰোণক আৰু তেওঁৰ পুত্ৰসকলক দিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","তেতিয়া লেবীয়া সকলৰ যোগেদি মুকলি কৰা লোক সকলৰ বাহিৰে যি লোক বাঢ়ি আছিল, তেওঁলোকক মুকলি কৰা ধন মোচিয়ে সংগ্রহ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","তেওঁ ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰথমে জন্ম পোৱা লোকসকলৰ পৰা পবিত্ৰ স্থানৰ চেকল অনুসাৰে সেই ধন এক হাজাৰ তিনিশ পঁয়ষষ্ঠি চেকল সংগ্রহ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","পাছত যিহোৱাৰ বাক্য অনুসাৰে মোচিয়ে সকলো কৰিলে, যিহোৱাই যিদৰে মোচিক আজ্ঞা দিছিল, মোচিয়ে সেই মুকলি কৰা ধন হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","পাছত যিহোৱাই মোচি আৰু হাৰোণক কথা কৈছিল। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“তোমালোকে লেবীৰ সন্তানসকলৰ মাজত নিজ নিজ বংশ আৰু পিতৃ-বংশ অনুসাৰে কহাতৰ সন্তানসকলৰ লোকপিয়ল গণনা কৰিবলৈ পৰিচালনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ত্ৰিশ বছৰ বয়সৰ পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান পুৰুষ সাক্ষাৎ কৰা তেওঁলোকৰ লেখ লোৱা। তম্বুৰ কাৰ্য কৰিবলৈ কৰ্মচাৰীবোৰৰ শ্ৰেণীত, এই লোকসকল অন্তৰ্ভুক্ত হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","মোৰ বাবে সংৰক্ষিত কৰি ৰখা অতিশয় পবিত্ৰ বস্তুৰ বিষয়ে কহাতীয়াসকলে সাক্ষাৎ কৰা তম্বুৰ কাম কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","যেতিয়া ছাউনি উঠিব লগা হ’ব, তেতিয়া হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে তম্বুৰ ভিতৰত সোমাই, আঁৰ কৰি ৰখা প্ৰভেদক বস্ত্ৰ নমাই তাৰে সাক্ষ্য-ফলিৰ চন্দুক ঢাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","তেওঁলোকে তাৰ ওপৰত তহচৰ ছালৰ এক আৱৰণ দিব। তেওঁলোকে তাৰ ওপৰত সম্পূৰ্ণ নীল বৰণীয়া এখন বস্ত্ৰ মেলি দিব। তেওঁলোকে তাক বৈ নিবলৈ তাত কানমাৰি সুমুৱাব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","আৰু তেওঁলোকে দৰ্শন পিঠাৰ মেজৰ ওপৰত এখন নীল বৰণীয়া কাপোৰ পাৰিব। তাৰ ওপৰত তেওঁলোকে থাল, পিয়লা, বাটি, আৰু পেয় নৈবেদ্য দ্ৰাক্ষাৰসৰ পাত্ৰ থ’ব। আৰু নিত্য পিঠা সদায় তাৰ ওপৰত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","সেইবোৰৰ ওপৰত তেওঁলোকে ৰঙা বৰণীয়া কাপোৰ এখন মেলি দিব আৰু তহচৰ ছালৰ এক আৱৰণেৰে তাক ঢাকিব। আৰু তেওঁলোকে তাক কঢ়িয়াই লৈ যাবলৈ তাত কানমাৰি সুমুৱাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","আৰু এখন নীল বৰণীয়া কাপোৰ লৈ, দীপাধাৰ, তাৰ প্ৰদীপ, শলাকানি-কটা, এঙেৰুৱা ধৰা আৰু তাৰ পৰিচৰ্যা কৰা গোটেই তেলৰ পাত্ৰ ঢাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","তাক আৰু তাৰ সকলো সঁজুলি তহচৰ ছালৰ এক আৱৰণেৰে মেৰাই লৈ এখন বৈ নিয়া যতনৰ ওপৰত থ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","পাছত তেওঁলোকে সোণৰ বেদীৰ ওপৰত নীল বৰণীয়া কাপোৰ পাৰি দিব। তহচৰ ছালৰ এক আৱৰণেৰে তাক ঢাকিব আৰু পাছত বৈ নিয়া কানমাৰি সুমুৱাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","তেওঁলোকে পবিত্ৰ স্থানত পৰিচৰ্যা কৰিব লগা সকলো সা-সৰঞ্জাম লৈ, নীল বৰণীয়া কাপোৰেৰে মেৰাব। আৰু তেওঁলোকে তহচৰ ছালৰ এক আৱৰণেৰে ঢাকি, তাক বৈ নিয়া যতনৰ ওপৰত ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","আৰু যজ্ঞ বেদীৰ পৰা ছাঁই উলিয়াই পেলাই দি, তাৰ ওপৰত এখন বেঙেনা বৰণীয়া কাপোৰ পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","আৰু তাৰ ওপৰত তাৰ পৰিচৰ্যা কৰিব লগা আটাই সঁজুলি আদি বেদীৰ সকলো পাত্ৰ ৰাখিব। তেওঁলোকে অৰ্থাৎ আঙঠা-ধৰা, ত্ৰিশূল, ছাঁই উলিওৱা হেতা, তেজ ছটিওৱা পাত্ৰ, পাছে তেওঁলোকে তাৰ ওপৰত তহচৰ ছালৰ এক আৱৰণ দি, কানমাৰি সুমুৱাই দি তাক ঢাকি ৰাখিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ছাউনি উঠিব যাব লগা সময়ত, হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে পবিত্ৰ স্থান আৰু ইয়াৰ সকলো বস্তু ঢকাৰ পাছত, কহাতৰ সন্তান সকলে তাক বৈ নিবলৈ আহিব লাগিব। কিন্তু তেওঁলোকে যদি পবিত্ৰ বস্তুবোৰ স্পৰ্শ কৰে, তেনেহলে তেওঁলোক মৰিব লাগিব। এইবোৰেই কহাতৰ সন্তান সকলৰ সাক্ষাৎ কৰা তম্বুৰ বস্তুবোৰ বৈ নিয়া কাম আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","আৰু প্ৰদীপৰ অৰ্থে তেল, সুগন্ধি ধূপ, নিত্য ভক্ষ্য নৈবেদ্য, অভিষেকাৰ্থক তেল, হাৰোণ পুৰোহিতৰ পুত্ৰ ইলিয়াজৰৰ জিম্মাত থাকিব। গোটেই আবাস আৰু তাত থকা সকলো পবিত্ৰ স্থান আৰু তাৰ সকলো বস্তু তেওঁৰ জিম্মাত থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","এইদৰে যিহোৱাই মোচি আৰু হাৰোণক কথা ক’লে। তেওঁ আৰু ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“তোমালোকে লেবীয়াসকলৰ মাজৰ পৰা কহাতীয়া গোষ্ঠীৰ বংশক উচ্ছন্ন হ’বলৈ নিদিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","তেওঁলোকক সুৰক্ষিত কৰি ৰাখিবা, এইবোৰ কৰাৰ দ্বাৰাই তেওঁলোক নমৰিব, কিন্তু জীয়াই থাকিব। যেতিয়া তেওঁলোকে অতি পবিত্ৰ স্থানৰ ওচৰ চাপে, ");
INSERT INTO asmfb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","তেতিয়া কিন্তু তেওঁলোকে মৰা নপৰিবৰ বাবে পবিত্ৰ বস্তুবোৰ খন্তেকৰ বাবে চাবলৈ পবিত্রস্থানৰ ভিতৰলৈ নাহিব। হাৰোণ আৰু তেওঁৰ পুত্ৰসকলে ভিতৰত সোমাই কহাতীয়াসকলৰ প্ৰতিজনক নিজ নিজ কৰিবলগীয়া কামত আৰু নিযুক্ত কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","যিহোৱাই মোচিক পুনৰ কথা ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“তুমি পিতৃ-বংশ আৰু বংশানুসাৰে গেৰ্চোনৰ সন্তানসকলৰো লোকপিয়ল পৰিচালনা কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ত্ৰিশ বছৰ বয়সৰে পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান লোক সাক্ষাৎ কৰা তম্বুৰ কাৰ্য কৰিবলৈ কৰ্মকাৰীসকলৰ শ্ৰেণীত সোমায়, তেওঁলোকক গণনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","পৰিচৰ্যা আৰু ভাৰ বৈ লৈ যোৱাই গেৰ্চোনীয়া গোষ্ঠীসকলৰ কাম আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","তেওঁলোকে আবাসৰ কাপোৰবোৰ সাক্ষাৎ কৰা তম্বু, তাৰ আৱৰণ, তাৰ ওপৰত থকা তহচৰ ছালৰ আৱৰণ, সাক্ষাৎ কৰা তম্বুৰ দুৱাৰৰ পৰ্দা এই সকলো বৈ লৈ যাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","আবাসৰ আৰু যজ্ঞবেদীৰ চাৰিওফালে থকা চোতালৰ আঁৰ কাপোৰবোৰ আৰু তাৰ দুৱাৰৰ পৰ্দা, সেইবোৰৰ ৰছী আৰু তাৰ কাম কৰা আটাই হাতিয়াৰ, এইবোৰ তেওঁলোকে বব আৰু এইবোৰৰ সম্পৰ্কীয় যি যি কাম কৰিব লগা হ’ব, তাকো কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","গেৰ্চোনৰ সন্তানসকলৰ সকলো ভাৰ বোৱা কাৰ্য, হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ আজ্ঞা অনুসাৰে হ’ব। ভাৰ বোৱা আটাই বস্তু তোমালোকে তেওঁলোকৰ জিম্মালৈ দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","গেৰ্চোনৰ সন্তানসকলৰ গোষ্ঠীৰ লোকসকলে সাক্ষাৎ কৰা তম্বুৰ কৰিব লগা কাম এয়ে। আৰু তেওঁলোকে কৰিব লগা কাম হাৰোণৰ পুত্ৰ ঈথামৰৰ জিম্মাত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","পাছত নিজ নিজ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে মৰাৰীৰ সন্তানসকলকো তুমি গণনা কৰা, ");
INSERT INTO asmfb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ত্ৰিশ বছৰ বয়সৰে পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান লোক সাক্ষাৎ কৰা তম্বুৰ কাৰ্য কৰিবলৈ কৰ্মকাৰীসকলৰ শ্ৰেণীত সোমায়, তেওঁলোকক গণনা কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","আৰু সাক্ষাৎ কৰা তম্বুৰ তেওঁলোকৰ সকলো কাৰ্য অনুসাৰে তেওঁলোকৰ জিম্মাত থকা তেওঁলোকে বৈ নিব লগা বস্তু এই - আবাসৰ তক্তা, তাৰ ডাং, খুঁটা, চুঙী, ");
INSERT INTO asmfb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","আৰু চোতালৰ চাৰিওফালে থকা খুঁটা, সেইবোৰৰ চুঙী, খুটি, ৰছী আৰু তাৰ আটাই কাৰ্যৰ হাতিয়াৰ; তোমালোকে নাম ধৰি ধৰি, তেওঁলোকে বৈ নিব লগা সকলো বস্তু তেওঁলোকক গতাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","মৰাৰীৰ সন্তানসকলৰ গোষ্ঠীৰ লোকসকলে তেওঁলোকৰ সকলো কাৰ্য অনুসাৰে সাক্ষাৎ কৰিব লগা তম্বুৰ কৰিব লগা কাৰ্য এয়ে। তেওঁলোকৰ কাৰ্য হাৰোণ পুৰোহিতৰ পুত্ৰ ঈথামৰৰ জিম্মাত থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","পাছত মোচি, হাৰোণ আৰু মণ্ডলীৰ অধ্যক্ষসকলে কহাতৰ সন্তান সকলৰ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","তেওঁলোকৰ মাজৰ পৰা ত্ৰিশ বছৰ বয়সৰে পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান লোক সাক্ষাৎ কৰা তম্বুৰ কাৰ্য কৰিবলৈ কৰ্মকাৰীসকলৰ শ্ৰেণীত সোমাল, তেওঁলোকক গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","তেতিয়া তেওঁলোকৰ গোষ্ঠী অনুসাৰে তেওঁলোকৰ গণিত লোক দুই হাজাৰ সাতশ পঞ্চাশ জন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","মোচিৰ যোগেদি দিয়া যিহোৱাৰ আজ্ঞা মতে যিসকলক মোচি আৰু হাৰোণে গণনা কৰিলে, সাক্ষাৎ কৰা তম্বুৰ কাম কৰা, কহাতীয়া গোষ্ঠীসকলৰ সেই গণিত লোক এইসকল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","গেৰ্চোনৰ সন্তান সকলৰ মাজত, যিসকলক নিজ নিজ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে গণনা কৰা হ’ল, ");
INSERT INTO asmfb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ত্ৰিশ বছৰ বয়সৰ পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান লোক সাক্ষাৎ কৰা তম্বুৰ কাম কৰিবলৈ কৰ্মকাৰীসকলৰ শ্ৰেণীত সোমাল, ");
INSERT INTO asmfb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","নিজ নিজ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে তেওঁলোকৰ মাজৰ সেই গণিত লোক দুই হাজাৰ ছশ ত্ৰিশ জন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","যিহোৱাই আজ্ঞা কৰাৰ দৰে মোচি আৰু হাৰোণে যিসকলক গণনা কৰিলে, সাক্ষাৎ কৰা তম্বুৰ কাৰ্য কৰা গেৰ্চোনৰ গোষ্ঠীসকলৰ সেই গণিত লোক এইসকল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","আৰু মৰাৰীৰ সন্তান সকলৰ গোষ্ঠীসকলৰ মাজত যিসকলক নিজ নিজ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে গণনা কৰা হ’ল, ");
INSERT INTO asmfb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ত্ৰিশ বছৰ বয়সৰ পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান লোক সাক্ষাৎ কৰা তম্বুৰ কাৰ্য কৰিবলৈ কৰ্মকাৰীসকলৰ শ্ৰেণীত সোমাল, ");
INSERT INTO asmfb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","নিজ নিজ গোষ্ঠী অনুসাৰে তেওঁলোকলৰ মাজৰ সেই গণিত লোক তিনি হাজাৰ দুশ জন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","মোচিৰ যোগেদি যিহোৱাই আজ্ঞা কৰাৰ দৰে মোচি আৰু হাৰোণে যিসকলক গণনা কৰিলে, মৰাৰীৰ সন্তান সকলৰ গোষ্ঠীসকলৰ সেই গণিত লোক এইসকল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","নিজ নিজ গোষ্ঠী আৰু পিতৃ-বংশ অনুসাৰে, মোচি, হাৰোণ আৰু ইস্ৰায়েলৰ অধ্যক্ষ সকলে গণনা কৰা, লেবীয়া লোকসকলৰ যিমান লোকক গণনা কৰা হ’ল, ");
INSERT INTO asmfb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ত্ৰিশ বছৰ বয়সৰ পৰা পঞ্চাশ বছৰ বয়সলৈকে যিমান লোক সেৱাকৰ্ম কৰিবলৈ, সাক্ষাৎ কৰা তম্বুৰ ভাৰ বোৱা কাম কৰিবলৈ সোমাল, ");
INSERT INTO asmfb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","তেওঁলোকৰ মাজৰ সেই গণিত লোক আঠ হাজাৰ পাঁচশ আশী জন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","কি কি কামত আৰু কি কি ভাৰত কিমান মানুহ লাগিব, তাক যিহোৱাৰ আজ্ঞাৰ দৰে মোচিৰ যোগেদি গণনা কৰা হ’ল। এইদৰে মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰেই তেওঁলোক তেওঁৰ যোগেদি গণিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","তাৰ পাছত যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“তুমি প্ৰতিজন কুষ্ঠৰোগীক, আৰু গাৰ ঘাৰ পৰা কিবা বৈ থকা প্ৰতিজন ৰোগীক, আৰু মৰা শ চুই অশুচি হোৱা প্ৰতিজন লোককে ছাউনিৰ পৰা বাহিৰ কৰিবলৈ, ইস্ৰায়েলৰ সন্তান সকলক আজ্ঞা দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","তোমালোকে পুৰুষহে হওঁক বা স্ত্ৰীয়ে হওঁক, দুয়োকো ছাউনিৰ পৰা বাহিৰ কৰিব লাগিব। তেওঁলোকে যেন কোনো প্রকাৰে ছাউনিবোৰ অশুচি নকৰে সেই বাবে তেওঁলোকক বাহিৰ কৰা, কিয়নো মই তাত বাস কৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","তেতিয়া ইস্ৰায়েলৰ সন্তান সকলে তাকে কৰিলে, আৰু যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰে তেওঁলোকে সেইদৰেই কাৰ্য কৰি ছাউনিৰ পৰা তেওঁলোকক বাহিৰ কৰি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","যিহোৱাই মোচিক পুনৰায় ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, যেতিয়া কোনো এজন পুৰুষে হওঁক বা স্ত্ৰীয়েই হওঁক, যদি কোনোবাই মানুহে মানুহক কৰা পাপৰ দৰে কোনো পাপ কৰি যিহোৱাৰ অহিতে অপৰাধ কৰে, সেই জন ব্যক্তি দোষী হয়। ");
INSERT INTO asmfb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","তেতিয়া সেই পুৰুষ বা স্ত্ৰীয়ে নিজে কৰা সেই পাপ স্বীকাৰ কৰিব লাগিব, আৰু যি দোষ কৰিছিল সেই পাপৰ মূল্য সম্পূৰ্ণৰূপে তাৰ ক্ষতিপূৰণ কৰিব লাগিব; আৰু পাঁচ ভাগৰ এভাগ বেচিকৈ দিব লাগিব। তেওঁ যাৰ অহিতে দোষ কৰিলে, সেই জন লোকক দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","আৰু যাক দোষৰ বাবে ক্ষতিপূৰণ কৰিব লগীয়া, সেই জন লোকৰ যদি এনে কোনো ওচৰ সম্বন্ধীয়া লোক নাথাকে, তেন্তে যি প্ৰায়শ্চিত্তৰ মতা মেৰটোৰ দ্বাৰাই তাক প্ৰায়শ্চিত্ত কৰা হ’ব, তেওঁৰ সেই দোষৰ বাবে যিহোৱাৰ উদ্দেশ্যে কৰিব লগা ক্ষতিপূৰণ পুৰোহিতে পাব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","আৰু ইস্ৰায়েলৰ সন্তান সকলে তেওঁলোকৰ পবিত্ৰ বস্তুৰ মাজৰ যিমান উত্তোলনীয় উপহাৰ মোৰ উদ্দেশ্যে পুৰোহিতৰ গুৰিলৈ আনিব, সেই সকলো সেই পুৰোহিত জনৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","প্ৰতিজনৰ পবিত্ৰীকৃত বস্তু তেওঁৰেই হ’ব। যিকোনো বস্তু যেতিয়া কোনো এজন লোকে পুৰোহিতক দিব, তাকো তেওঁৰেই হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","যিহোৱাই মোচিক আকৌ কলে, ");
INSERT INTO asmfb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“তুমি ইস্ৰায়েলৰ সন্তানসকলক কোৱা, ‘ধৰি লোৱা কোনো এজন লোকৰ পত্নীয়ে যদি অবাটে গ’ল আৰু তেওঁৰ বিৰুদ্ধে সত্যলঙ্ঘন কৰিলে; ");
INSERT INTO asmfb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","অৰ্থাৎ আন এজন পুৰুষে তাইৰে সৈতে শয়ন কৰিলে; সেই ক্ষেত্রত তাই অশুচি হ’ল; যদিও তাইৰ গিৰীয়েকে নেদেখাকৈ বা নজনাকৈ বা যদিও তাইৰ সেই কৰ্ম ধৰাত নপৰিল বা তাইৰ অহিতে সাক্ষী কোনো নাই, ");
INSERT INTO asmfb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","আৰু নিজ পত্নী অশুচি হ’লে, এই বুলি তাইৰ প্রতি গিৰীয়েকৰ অন্তৰ্জ্বালাযুক্ত মন হ’ব পাৰে, নাইবা নিজ পত্নী অশুচি নহলেও, মিছাতে তাইৰ প্রতি তেওঁৰ অন্তৰ্জ্বালাযুক্ত মন হ’ব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","তেতিয়া এই বোৰ ক্ষেত্রত সেই পুৰুষ জনে নিজ পত্নীক পুৰোহিতৰ ওচৰলৈ আনিব। তেওঁ তাইৰ কাৰণে তাইৰ উপহাৰ, অৰ্থাৎ ঐফাৰ দহ ভাগৰ এভাগ যৱৰ আটাগুড়ি আনিব। কিন্তু তেওঁ তাৰ ওপৰত তেল নাঢালিব, আৰু কুন্দুৰু নিদিব; কিয়নো সেয়ে অন্তৰ্জ্বালাৰ ভক্ষ্য নৈবেদ্য, অপৰাধ সোঁৱৰণ কৰাওঁতা স্মৰণাৰ্থক ভক্ষ্য নৈবেদ্য। ");
INSERT INTO asmfb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","তেতিয়া পুৰোহিতে সেই মহিলাক আনি যিহোৱাৰ আগত উপস্থিত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","আৰু পুৰোহিতে মাটিৰ পাত্ৰত পবিত্ৰ জল ৰাখি, আবাসৰ মজিয়াৰ কিছু ধূলি লৈ, সেই জলত দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","পুৰোহিতে সেই মহিলা গৰাকীক যিহোৱাৰ আগত উপস্থিত কৰিব আৰু তাইৰ মূৰৰ চুলি মুকলি কৰিব। আৰু সেই স্মৰণাৰ্থক নৈবেদ্য, অন্তৰ্জ্বালাৰ ভক্ষ্য নৈবেদ্য তাইৰ হাতত থ’ব, আৰু শাও জন্মাওতা সেই তিতা পানী পুৰোহিতে নিজৰ হাতত ল’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","আৰু পুৰোহিতে সেই মহিলাক শপত খুৱাব লাগিব, তেওঁ তাইক ক’ব লাগিব বোলে, “কোনো পুৰুষে যদি তোমাৰে সৈতে শয়ন কৰা নাই, আৰু তুমি নিজ স্বামীৰ অধীন হৈ অবাটে যোৱা নাই, তেতিয়াহলে শাও জন্মাওতা এই তিতা পানী তোমালৈ নিষ্ফল হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","কিন্তু তুমি যদি নিজ স্বামীৰ অধীন হৈয়ো অবাটে গৈ অশুচি হ’লা, আৰু তোমাৰ স্বামীৰ বাহিৰে আন কোনো পুৰুষে যদি তোমাৰ লগত শয়ন কৰিলে,’ ");
INSERT INTO asmfb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","এইবোৰ কথা কৈ পুৰোহিতে শাও জন্মাওতা শপতেৰে সেই মহিলাক শপত খুৱাব, ‘তেন্তে যিহোৱাই তোমাৰ কৰঙন শুকুৱাই আৰু তোমাৰ পেট উখহাই তোমাৰ লোকসকলৰ মাজত তোমাক শাও আৰু শপতৰ বিষয় কৰিব; ");
INSERT INTO asmfb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","আৰু এই শাও জন্মাওতা পানী তোমাৰ পেট উখহাবলৈ আৰু কৰঙন শুকুৱাবলৈ তোমাৰ পেটত সোমাব।” তেতিয়া সেই মহিলাই উত্তৰ দিব, ‘হয়, যদি মই দোষী, তেনেহলে এনেই হওঁক।’ ");
INSERT INTO asmfb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","পুৰোহিতে জনে এইবোৰ শাও এখনি পুথিত লিখিব আৰু তাৰ পাছত তাক সেই তিতা পানীত তেওঁ ধুই পেলাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","তাৰ পাছত পুৰোহিতে সেই শাও জন্মাওতা তিতা পানী তাইক পান কৰাব; তাতে সেই শাও জন্মাওতা তিতা পানী তাইৰ পেটত সোমাই তিতা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","পুৰোহিতে সেই মহিলাৰ হাতৰ পৰা সেই অন্তৰ্জ্বালাৰ ভক্ষ্য নৈবেদ্য নিজ হাতত লৈ যিহোৱাৰ সাক্ষাতে দোলাই যজ্ঞবেদীৰ ওচৰলৈ আনিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","আৰু পুৰোহিতে সেই ভক্ষ্য নৈবেদ্যৰ এমুঠি লৈ, তাৰ স্মৰণাৰ্থক অংশস্বৰূপে যজ্ঞবেদীৰ ওপৰত দগ্ধ কৰিব; তাৰ পাছত তেওঁ সেই মহিলাক সেই পানী পান কৰাব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","আৰু তাই যদি নিজ স্বামীৰ বিৰুদ্ধে কুকৰ্ম কৰি অশুচি হৈছে, তেন্তে সেই পানী খুউৱাৰ পাছত সেই শাও জন্মাওতা পানী তাইৰ পেটত সোমাই তিতা হ’ব। তাইৰ পেট উখহিব আৰু কৰঙন শুকাই যাব। আৰু তাই নিজ লোকসকলৰ মাজত শাওৰ বিষয় হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","কিন্তু যদি সেই মহিলা অশুচি নহৈ, শুচি আছে, তেন্তে তাই শাওৰ পৰা মুক্ত হ’ব আৰু গৰ্ভধাৰণ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","এয়ে অন্তৰ্জ্বালাযুক্ত বিধি; যেতিয়া কোনো মহিলাই নিজ স্বামীৰ অধীন হৈয়ো অবাটে গৈ অশুচি হয়, তাইৰ বাবেই এই বিধি। ");
INSERT INTO asmfb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","যেতিয়া কোনো মানুহৰ মন অন্তৰ্জ্বালাযুক্ত হৈ, তেওঁ নিজৰ পত্নীৰ প্রতি অন্তৰ্জ্বালাৰে জ্বলে, সেই সময়ত তেওঁ নিজ পত্নীক যিহোৱাৰ আগত উপস্থিত কৰিব, আৰু পুৰোহিতে তাইৰ বিষয়ে এই সকলো বিধি পালন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","তেতিয়া নিজ পত্নীক পুৰোহিতৰ ওচৰলৈ অনাৰ কাৰণে সেই পুৰুষ অপৰাধৰ পৰা মুক্ত হ’ব, আৰু সেই তিৰোতাই নিজ অপৰাধৰ ফল ভোগ কৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘কোনো পুৰুষ বা স্ত্ৰীয়ে যেতিয়া যিহোৱাৰ উদ্দেশ্যে বিশেষ নাচৰীয়া ব্ৰত ধৰিবৰ অৰ্থে পৃথকে থাকিব, ");
INSERT INTO asmfb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","তেতিয়া তেওঁ দ্ৰাক্ষাৰস আৰু সুৰাপানৰ পৰা নিজকে আতৰত ৰাখিব লাগিব। তেওঁ দ্ৰাক্ষাৰসৰ চিৰ্কা বা সুৰাৰ চিৰ্কা পান নকৰিব আৰু দ্ৰাক্ষাফলৰ পৰা চেপি উলিওৱা নতুন ৰসকো পান নকৰিব, বা কেঁচা কি শুকান দ্ৰাক্ষাফলো নাখাব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","তেওঁ মোৰ উদ্দেশ্যে পৃথকে থকা সকলো কালত, গুটিৰ পৰা বাকলিলৈকে দ্ৰাক্ষাফলৰে যুগুত কৰা কোনো বস্তু ভোজন নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","আৰু ব্ৰত ধৰি পৃথকে থকা সকলো কালত তেওঁৰ মূৰত ক্ষুৰ নলগাব; যিহোৱাৰ উদ্দেশ্যে বেলেগে থকা দিনৰ সংখ্যা পূৰ নহয়মানে তেওঁ নিজৰ মূৰৰ চুলি বাঢ়িবলৈ দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","তেওঁ যেতিয়ালৈকে যিহোৱাৰ উদ্দেশ্যে পৃথকে থাকে, তেতিয়ালৈকে কোনো মৰা শৱৰ ওচৰলৈ নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","তেওঁৰ পিতৃৰ বা মাতৃৰ, ককায়েকৰ বা ভনীয়েকৰ মৃত্যুৰ সময়ত, তেওঁ তেওঁলোকৰ কাৰণে নিজকে অশুচি নকৰিব, কিয়নো তেওঁৰ মূৰৰ দীঘল চুলি দেখি, তেওঁ নিজ ঈশ্বৰৰ উদ্দেশ্যে যে পৃথকে আছে সেই বিষয়ে সকলোৱে জানিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","তেওঁ পৃথকে হৈ থকা সকলো কালত, যিহোৱাৰ উদ্দেশ্যে পবিত্ৰ হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","আৰু যদি কোনো এজন মানুহৰ অকস্মাৎ তেওঁৰ ওচৰত মৃত্যু হয়, তেতিয়া তেওঁ তেওঁৰ নিজ পৃথকে থকাৰ চিন অশুচি কৰে। তেতিয়া তেওঁ শুচি হোৱা দিনা, নিজৰ মূৰ ক্ষুৰাব। সেয়া সপ্তম দিনাই তেওঁ নিজ মূৰৰ চুলি ক্ষুৰাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","অষ্টম দিনা তেওঁ দুটা কপৌ, বা দুটা পাৰ পোৱালি সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ-মুখলৈ পুৰোহিতৰ ওচৰলৈ আনিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","তেতিয়া পুৰোহিতে তাৰে এটা পাপাৰ্থক বলিস্বৰূপে, আৰু আনটো হোম বলিস্বৰূপে উৎসৰ্গ কৰিব। তেতিয়া তেওঁ মৰা শৱৰ ওচৰত থকাৰ পাপৰ কাৰণে তেওঁক প্ৰায়শ্চিত্ত কৰিব; আৰু সেই দিনাই তেওঁ নিজকে পুনৰ পবিত্ৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","তেওঁ নিজকে পুনৰায় যিহোৱাৰ উদ্দেশ্যে পৃথকে থাকিব লাগিব। তেওঁ দোষাৰ্থক বলিস্বৰূপে এটা এবছৰীয়া মেৰ-ছাগ পোৱালি আনিব। কিয়নো তেওঁ পূৰ্বতে নিজকে অশুচি কৰালে সেই কাৰণে তেওঁ পূৰ্বতে নিজকে যিহোৱাৰ উদ্দেশ্যে পৃথকে থকা দিনবোৰ গণ্য নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","নাচৰীয়া লোক হৈ পৃথকে থকাৰ কাল পূৰ হলে, তেওঁ পালন কৰিব লগা বিধি এনে- তেওঁক সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখলৈ অনা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","তেওঁ নিজে অনা উপহাৰ যিহোৱালৈ দান কৰিব। তেওঁ হোম বলিৰ কাৰণে গাত কোনো দাগ নথকা এটা এবছৰীয়া মতা মেৰ-ছাগ পোৱালি আৰু পাপাৰ্থক বলিৰ কাৰণে গাত দাগ নথকা এজনী এবছৰীয়া নিঘূণ চেঁউৰী মেৰ-ছাগ পোৱালি, আৰু মঙ্গলাৰ্থক বলিৰ কাৰণে গাত দাগ নথকা এটা নিঘূণ মতা মেৰ-ছাগ দান কৰিব লাগিব; ");
INSERT INTO asmfb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","আৰু সেই জন্তুবোৰৰ সৈতে একেৰাহি খমিৰ নিদিয়া পিঠা অৰ্থাৎ তেল মিহলোৱা মিহি আটাগুড়িৰ বিন্ধা থকা পিঠা কেইটামান, আৰু খমীৰ নিদিয়া তেল ঢলা পাতল চকলীয়া পিঠা কেইটামান, আৰু তাৰ লগত ভক্ষ্য আৰু পেয় নৈবেদ্য উপহাৰৰ সৈতে এই সকলো উপহাৰ যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিবলৈ আনিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","তাতে পুৰোহিতে এই সকলো বস্তু যিহোৱাৰ আগলৈ আনিব। তেতিয়া তেওঁৰ পাপাৰ্থক বলি আৰু হোম বলি উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","খমীৰ নিদিয়া পিঠাৰ খৰাহিটোৰে সৈতে মঙ্গলাৰ্থক বলিৰ মেৰ-ছাগটো যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিব আৰু তাৰ পাছত পুৰোহিতে তাৰ লগৰ ভক্ষ্য নৈবেদ্য আৰু পেয় নৈবেদ্যও উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","পাছত নাচৰীয়া লোকজনে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত নিজে পৃথক হৈ থকাৰ চিন অৰ্থাৎ তেওঁৰ মূৰৰ দীঘল চুলি ক্ষুৰাই, সেই মূৰৰ চুলি লৈ, মঙ্গলাৰ্থক বলিৰ তলত থকা অগ্নিত পেলাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","আৰু নাচৰীয়া লোকজনে পৃথকে থকাৰ যি চিন, তাক ক্ষুৰুৱাৰ পাছত, পুৰোহিতে পানীত সিজোৱা মেৰৰ আগ-পিৰাটো, আৰু খৰাহিৰ পৰা খমীৰ নিদিয়া বিন্ধা থকা পিঠা এটা, আৰু খমীৰ নিদিয়া পাতল চাকলিয়া পিঠা এটা লৈ, নাচৰীয়া লোকজনৰ হাতত দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","আৰু পুৰোহিতে সেই সকলোকে দোলনীয় নৈবেদ্যস্বৰূপে যিহোৱাৰ সাক্ষাতে তেওঁৰ সন্মুখত দান কৰিব; দোলনীয় আমঠু আৰু উত্তোলনীয় পাছ-পিৰাই সৈতে সেয়ে পুৰোহিতৰ অৰ্থে পবিত্ৰ হ’ব। তাৰ পাছত নাচৰীয়া লোকজনে দ্ৰাক্ষাৰস পান কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","নাচৰীয়া ব্ৰত ধৰোঁতা মানুহৰ আৰু পৃথকে থকাৰ কাৰণে যিহোৱাক দিব লগা তাৰ উপহাৰৰ এয়ে বিধি। ইয়াৰ বাহিৰে তেওঁ নিজৰ শক্তি অনুসাৰে দিবলৈ আগ কৰে, তাকো দিব পাৰে; তেওঁ যি ব্ৰত ধৰে, সেই ব্ৰত অনুসাৰে তেওঁ নিজে পৃথকে থকা বিধি পালন কৰিব লাগে’।” ");
INSERT INTO asmfb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","পাছত যিহোৱাই পুনৰায় মোচিক ক’লে, “তুমি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক কোৱা, ");
INSERT INTO asmfb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","‘তোমালোকে ইস্ৰায়েলৰ সন্তানসকলক এইদৰে আশীৰ্ব্বাদ কৰিবা। তোমালোকে তেওঁলোকক এইদৰে ক’বা: ");
INSERT INTO asmfb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","যিহোৱাই তোমালোকক আশীৰ্ব্বাদ কৰি ৰাখক। ");
INSERT INTO asmfb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","যিহোৱাই তেওঁৰ নিজ পোহৰৰে তোমালোকক উজ্জ্বল কৰি ৰাখক আৰু তোমালোকৰ প্রতি দয়ালু হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","যিহোৱাই তোমালৈ দৃষ্টি কৰক আৰু তোমাক শান্তি দান কৰক।’ ");
INSERT INTO asmfb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","এইদৰে তেওঁলোকে ইস্ৰায়েলৰ সন্তান সকলৰ ওপৰত মোৰ নাম স্থাপন কৰিব। তেতিয়া মই তেওঁলোকক আশীৰ্ব্বাদ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","পাছত যি দিনা মোচিয়ে আবাস স্থাপন কৰি সমপন্ন কৰিলে, তেতিয়া তেওঁ সেই আবাস আৰু তাৰ সকলো বস্তু যিহোৱাৰ বাবে অভিষেক আৰু পবিত্ৰ কৰিলে। তেওঁ যজ্ঞবেদী আৰু তাৰ সকলো বস্তু, সকলোকে সঁজুলি অভিষেক আৰু পবিত্ৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","সেই দিনা ইস্ৰায়েলৰ অধ্যক্ষসকল, তেওঁলোকৰ পিতৃ-বংশৰ মুখিয়ালসকলে নিজ নিজ উপহাৰ দান কৰিলে। তেওঁলোক ফৈদবোৰৰ অধ্যক্ষ আছিল। তেওঁলোক যুদ্ধৰ বাবে গণিত লোকসকলৰ ওপৰত নিযুক্ত হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","তেওঁলোকে যিহোৱাৰ সন্মুখত তেওঁৰ উদ্দেশ্যে নিজ নিজ উপহাৰ স্বৰূপে ঢাকনি থকা ছখন গাড়ী আৰু বাৰটা ষাঁড়-গৰু আনিলে। তেওঁলোকে দুজন দুজন অধ্যক্ষলৈ এখন এখন গাড়ী, আৰু প্ৰতিজনৰ কাৰণে এটা এটা ষাঁড়-গৰু আনি আবাসৰ আগত উপস্থিত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","তেতিয়া যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“সাক্ষাৎ কৰা তম্বুৰ কামত ব্যৱহাৰ কৰাৰ কাৰণে, তুমি তেওঁলোকৰ পৰা উপহাৰবোৰ লোৱা। তুমি সেই সকলোকে লেবীয়াসকলক দিবা, অৰ্থাৎ তেওঁলোকৰ প্রতিজনকে নিজ নিজ কাৰ্য অনুসাৰে দিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","পাছত মোচিয়ে সেই সকলো গাড়ী আৰু ষাঁড়-গৰুবোৰ লৈ লেবীয়াসকলক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","গেৰ্চোনৰ সন্তান সকলক তেওঁলোকৰ কাৰ্যৰ প্রয়োজন অনুসাৰে দুখন গাড়ী আৰু চাৰিটা ষাঁড়-গৰু দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","তেওঁ মৰাৰীৰ সন্তান সকলক চাৰিখন গাড়ী আৰু আঠটা ষাঁড়-গৰু হাৰোণ পুৰোহিতৰ পুত্ৰ ঈথামৰৰ দায়িত্বত দিলে। তেওঁলোকৰ কাৰ্যৰ প্রয়োজন অনুসাৰে মোচিয়ে এনে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","কিন্তু কহাতৰ সন্তান সকলক মোচিয়ে একোকে নিদিলে, কিয়নো পবিত্ৰ স্থানৰ বস্তুবোৰৰ ভাৰ হে তেওঁলোকৰ ওপৰত আছিল আৰু তেওঁলোকৰ প্রয়োজনীয়া বস্তুবোৰ তেওঁলোকে কান্ধতকৈ ভাৰ বব লগীয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","মোচিয়ে যজ্ঞবেদী অভিষেক কৰা দিনা, অধ্যক্ষসকলে তাৰ প্ৰতিষ্ঠাৰ অৰ্থে উপহাৰ আনিলে আৰু নিজ নিজ উপহাৰ যজ্ঞবেদীৰ আগত উপস্থিত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","তেতিয়া যিহোৱাই মোচিক কলে, “প্রতিজন অধ্যক্ষই এদিন যজ্ঞবেদীৰ প্ৰতিষ্ঠাৰ অৰ্থে নিজ নিজ উপহাৰ আনিব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","তেতিয়া প্ৰথম দিনা যিহূদা ফৈদৰ অম্মীনাদবৰ পুত্ৰ নহচোনে নিজৰ উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","তেওঁৰ উপহাৰ পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখ ৰূপৰ এটা বাটি আছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","তেওঁ ধূপেৰে পূৰ হোৱা দহ চেকল জোখ সোণৰ এটা পিয়লাও দান কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","নহচোনে হোমৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","তেওঁ পাপাৰ্থক বলিৰ কাৰণে এটা এবছৰীয়া মতা ছাগলী পোৱালি দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","আৰু মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচোটা এবছৰীয়া মতা মেৰ পোৱালি দিছিল। এয়ে অম্মীনাদবৰ পুত্ৰ নহচোনৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","দ্বিতীয় দিনা, ইচাখৰৰ অধ্যক্ষ চূৱাৰৰ পুত্ৰ নথনেলে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","তেওঁ অনা উপহাৰ পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকলজোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখৰ ৰূপৰ এটা বাটি আছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও দান কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","নথনেলে হোমৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","তেওঁ পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","মঙ্গলাৰ্থক বলিৰ কাৰণে তেওঁ দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল চূৱাৰৰ পুত্ৰ নথনেলৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","তৃতীয় দিনা, জবূলূনৰ সন্তান সকলৰ অধ্যক্ষ হেলোনৰ পুত্ৰ ইলীয়াবে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখ ৰূপৰ এখন থাল আৰু সত্তৰ চেকল জোখৰ ৰূপৰ এটা বাটি আনিলে। এই দুই পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","তেওঁ হোমৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","পাপাৰ্থক বলিৰ কাৰণে তেওঁ এটা মতা ছাগলী আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","আৰু মঙ্গলাৰ্থক বলিৰ কাৰণে তেওঁ দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল হেলোনৰ পুত্ৰ ইলীয়াবৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","চতুৰ্থ দিনা, ৰূবেণৰ সন্তান সকলৰ অধ্যক্ষ চদেয়ূৰৰ পুত্ৰ ইলীচূৰে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল আৰু সত্তৰ চেকল জোখৰ ৰূপৰ এটা বাটি আনিছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","তেওঁ হোমৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","আৰু পাপাৰ্থক বলিৰ বাবে এটা মতা ছাগলী আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ইলীচূৰে মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল চদেয়ূৰৰ পুত্ৰ ইলীচূৰৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","পঞ্চম দিনা চিমিয়োনৰ সন্তান সকলৰ অধ্যক্ষ চূৰীচদ্দয়ৰ পুত্ৰ চলমীয়েলে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখ ৰূপৰ এটা বাটি আনিছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","আৰু ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","তেওঁ হোম বলিৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","আৰু পাপাৰ্থক বলিৰ বাবে এটা মতা ছাগলী। ");
INSERT INTO asmfb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল চূৰীচদ্দয়ৰ পুত্ৰ চলমীয়েলৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ষষ্ঠ দিনা, গাদৰ সন্তান সকলৰ অধ্যক্ষ দুৱেলৰ পুত্ৰ ইলিয়াচফে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখৰ এটা বাটি আনিছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ এটা সোণৰ পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","তেওঁ হোম বলিৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী; ");
INSERT INTO asmfb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল দুৱেলৰ পুত্ৰ ইলিয়াচফৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","সপ্তম দিনা, ইফ্ৰয়িমৰ সন্তান সকলৰ অধ্যক্ষ অম্মীহূদৰ পুত্ৰ ইলীচামাই উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখ ৰূপৰ এটা বাটি আনিছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","তেওঁ হোম বলিৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","তেওঁ পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","আৰু মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল অম্মীহূদৰ পুত্ৰ ইলীচামাৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","অষ্টম দিনা, মনচিৰ সন্তান সকলৰ অধ্যক্ষ পদাচূৰৰ পুত্ৰ গম্লীয়েলে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখৰ ৰূপৰ এটা বাটি আনিছিল; এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","তেওঁ হোম বলিৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী। ");
INSERT INTO asmfb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল পদাচূৰৰ পুত্ৰ গম্লীয়েলৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","নৱম দিনা, বিন্যামীনৰ সন্তান সকলৰ অধ্যক্ষ গিদিয়োনীৰ পুত্ৰ অবীদানে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চোকল জোখৰ ৰূপৰ এটা বাটি আনিছিল। এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চোকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","হোম বলিৰ অৰ্থে তেওঁ এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ ");
INSERT INTO asmfb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","আৰু এটা এবছৰীয়া মেৰ পোৱালি আনিছিল আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী; ");
INSERT INTO asmfb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল গিদিয়োনীয়া পুত্ৰ অবীদানৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","দশম দিনা, দানৰ সন্তান সকলৰ অধ্যক্ষ অম্মীচদ্দয়ৰ পুত্ৰ অহীয়েজৰে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখ এখন ৰূপৰ থাল, আৰু সত্তৰ চেকল জোখৰ ৰূপৰ এটা বাটি আনিছিল; এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","তেওঁ ধূপেৰে পূৰ হোৱা দহ চোকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","তেওঁ হোম বলিৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী; ");
INSERT INTO asmfb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল অম্মীচদ্দয়ৰ পুত্ৰ অহীয়েজৰৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","একাদশ দিনা, আচেৰৰ সন্তান সকলৰ অধ্যক্ষ আক্ৰণৰ পুত্ৰ পগীয়েলে উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখৰ ৰূপৰ এটা বাটি আনিছিল; এই দুটা পাত্ৰ ভক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","তেওঁ হোম অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী। ");
INSERT INTO asmfb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল আক্ৰণৰ পুত্ৰ পগীয়েলৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","দ্বাদশ দিনা, নপ্তালীৰ সন্তান সকলৰ অধ্যক্ষ ঐননৰ পুত্ৰ অহীৰাই উপহাৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","তেওঁ উপহাৰ হিচাপে পবিত্ৰ স্থানৰ চেকল অনুসাৰে এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ এখন থাল, আৰু সত্তৰ চেকল জোখৰ ৰবপৰ এটা বাটি আনিছিল; এই দুটা পাত্ৰ ভৈক্ষ্য নৈবেদ্যৰ অৰ্থে তেল মিহলোৱা মিহি আটাগুড়িৰে ভৰা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","তেওঁ ধূপেৰে পূৰ হৈ থকা দহ চেকল জোখৰ সোণৰ এটা পিয়লাও আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","তেওঁ হোম বলিৰ অৰ্থে এটা দমৰা ষাঁড়-গৰু, এটা মতা মেৰ-ছাগ আৰু এটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী। ");
INSERT INTO asmfb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","তেওঁ মঙ্গলাৰ্থক বলিৰ কাৰণে দুটা ষাঁড়-গৰু, পাঁচটা মতা মেৰ-ছাগ, পাঁচটা মতা ছাগলী আৰু পাঁচটা এবছৰীয়া মতা মেৰ পোৱালি আনিছিল। এয়ে আছিল ঐননৰ পুত্ৰ অহীৰাৰ উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","মোচিয়ে যজ্ঞবেদী অভিষেক কৰা দিনা, তাৰ প্ৰতিষ্ঠাৰ অৰ্থে, এই সকলোবোৰ উপহাৰ ইস্ৰায়েলৰ অধ্যক্ষসকলৰ দ্বাৰাই দিয়া হ’ল; তেওঁলোকে ৰূপৰ বাৰখন থাল, ৰূপৰ বাৰটা বাটি আৰু সোণৰ বাৰটা পিয়লা দান কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","তাৰে প্ৰতিখন থাল এশ ত্ৰিশ চেকল জোখৰ ৰূপৰ আৰু প্ৰত্যেক বাটি সত্তৰ চেকল জোখৰ ৰূপৰ আছিল; সৰ্ব্বমুঠ এই সকলো পাত্ৰৰ ৰূপ পবিত্ৰ স্থানৰ চেকল অনুসাৰে দুই হাজাৰ চাৰিশ চেকল আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","প্ৰত্যেকখন ধূপেৰে পূৰ হোৱা সোণৰ বাৰটা পিয়লা পবিত্ৰ স্থানৰ চেকল অনুসাৰে দহ চেকল জোখৰ সোণৰ আছিল; আটাই কেইটা পিয়লাৰ সোণ সৰ্ব্বমুঠ এশ বিশ চেকল আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","তেওঁলোকে হোম বলিৰ অৰ্থে সৰ্ব্বমুঠ বাৰটা দমৰা ষাঁড়-গৰু, বাৰটা মতা মেৰ-ছাগ, বাৰটা এবছৰীয়া মতা মেৰ পোৱালি, আৰু এইবোৰৰ সৈতে ভক্ষ্য নৈবেদ্য আৰু পাপাৰ্থক বলিৰ কাৰণে বাৰটা মতা ছাগলী দান কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","তেওঁলোকৰ পোহনীয়া জন্তুৰ জাকৰ পৰা তেওঁলোকে মঙ্গলাৰ্থক বলিৰ কাৰণে সৰ্ব্বমুঠ চব্বিশটা ষাঁড়-গৰু, ষাঠিটা মতা মেৰ-ছাগ, ষাঠিটা মতা ছাগলী আৰু ষাঠিটা এবছৰীয়া মতা মেৰ পোৱালি দান কৰিছিল। যজ্ঞবেদী অভিষেক কৰাৰ পাছত, তাৰ প্ৰতিষ্ঠা কৰাৰ উপহাৰ এইবোৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","পাছত যেতিয়া মোচিয়ে যিহোৱাৰ সৈতে কথা-বতৰা কৰিবলৈ সাক্ষাৎ কৰা তম্বুৰ ভিতৰলৈ সোমাল, তেতিয়া তেওঁ ঈশ্বৰৰ বাক্যৰ শব্দ সেই সাক্ষ্য-ফলিৰ চন্দুকৰ ওপৰত থকা পাপাবৰণৰ পৰা, কৰূব দুটাৰ মাজৰ পৰা তেওঁক কোৱা শুনিলে। এইদৰে তেওঁ মোচিক কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“তুমি হাৰোণক কোৱা বোলে, ‘যেতিয়া তুমি প্ৰদীপবোৰ জ্বলাবা, তেতিয়া সেই সাতোটা প্ৰদীপ দীপাধাৰৰ সন্মুখত পোহৰ কৰাকৈ ৰাখিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","তেতিয়া হাৰোণে সেইদৰে কৰিলে। মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰেই দীপাধাৰৰ সন্মুখত পোহৰ কৰাকৈ তেওঁ প্ৰদীপবোৰ জ্বলালে। ");
INSERT INTO asmfb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","সেই দীপাধাৰ এইদৰে সজা হৈছিল: দীপাধাৰটো তলৰ পৰা ওপৰলৈ সোণৰে পিটাই সজা হৈছিল আৰু তাৰ ওপৰটো ফুলৰ আকৃতিত সজা হৈছিল; যিহোৱাই মোচিক এইদৰেই দীপাধাৰটো সাজিবলৈ কৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","যিহোৱাই মোচিক পুনৰায় ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“তুমি ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা লেবীয়াসকলক লৈ, তেওঁলোকক শুচি কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","তেওঁলোকক শুচি কৰিবলৈ, তেওঁলোকলৈ এই কাম কৰা; তেওঁলোকৰ ওপৰত পাপ নাশক জল ছটিওৱা, আৰু তেওঁলোকৰ প্রতিজনে নিজ গোটেই গাৰ চুলি ক্ষুৰাই আৰু কাপোৰ ধুই নিজকে শুচি কৰক। ");
INSERT INTO asmfb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","তাৰ পাছত তেওঁলোকে এটা দমৰা ষাঁড়-গৰু আৰু তেল মিহলোৱা মিহি আটাগুড়িৰে যুগুত কৰক তাৰ ভক্ষ্য নৈবেদ্য আনক; আৰু পাপাৰ্থক বলিৰ কাৰণে আৰু এটা দমৰা গৰু লওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","তুমি লেবীয়াসকলক সাক্ষাৎ কৰা তন্বুৰ আগত উপস্থিত কৰাবা, আৰু ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীক একত্রিত কৰাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","তাৰ পাছত লেবীয়াসকলক মোৰ আগত উপস্থিত কৰাবা। ইস্ৰায়েলৰ সন্তান সকলে লেবীয়াসকলৰ গাত হাত দিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ইস্ৰায়েলৰ সন্তান সকলৰ পক্ষে হাৰোণে মোৰ আগত লেবীয়াসকলক উৎসৰ্গ কৰিব যাতে তেওঁলোক মোৰ সেৱাৰ কাৰ্যত নিযুক্ত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","পাছত লেবীয়াসকলে সেই দুটা দমৰা ষাঁড়-গৰুৰ মূৰত হাত দিব; আৰু তুমি লেবীয়াসকলক প্ৰায়শ্চিত্ত কৰিবৰ কাৰণে, যিহোৱাৰ উদ্দেশ্যে এটা দমৰা ষাঁড়-গৰু পাপাৰ্থক বলিস্বৰূপে আৰু আনটো হোম বলিস্বৰূপে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","এইদৰে তুমি হাৰোণ আৰু তেওঁৰ পুত্ৰসকলৰ আগত লেবীয়াসকলক উপস্থিত কৰাবা আৰু তেওঁলোকক মোৰ উদ্দেশ্যে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","এইদৰে তুমি ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা লেবীয়াসকলক পৃথক কৰিবা; আৰু লেবীয়াসকল মোৰেই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","তাৰ পাছত লেবীয়াসকলে সাক্ষাৎ কৰা তম্বুৰ কাৰ্য কৰিবলৈ সেই ঠাইত সোমাব। এইদৰে তুমি তেওঁলোকক শুচি কৰিবা আৰু মোলৈ তেওঁলোকক উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","তুমি ইয়াকে কৰিবা কিয়নো তেওঁলোকক সম্পূৰ্ণৰূপে ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা মোক দিয়া হ’ল। তেওঁলোকে ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ গৰ্ভ ভেদ কৰি সকলো প্ৰথমে জন্মাসকলৰ সলনি তেওঁলোকক মোৰ কাৰণে গ্ৰহণ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","কাৰণ মানুহেই হওঁক বা পশুৱেই হওঁক, ইস্ৰায়েলৰ মাজত প্ৰথমে জন্মা সকলো মোৰেই; যিদিনা মই মিচৰ দেশৰ পৰা প্ৰথমে জন্মা সকলোকে মাৰিলোঁ, সেই দিনা মোৰ কাৰণে তেওঁলোকক পবিত্ৰ কৰিছিলোঁ।। ");
INSERT INTO asmfb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","এই কাৰণে ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰথমে জন্মা সকলো সন্তান সকলৰ সলনি মই লেবীয়াসকলক গ্ৰহণ কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","আৰু সাক্ষাৎ কৰা তম্বুত ইস্ৰায়েলৰ সন্তান সকলে কৰিবলগীয়া কাৰ্য কৰিবলৈ আৰু ইস্ৰায়েলৰ সন্তান সকলক প্ৰায়শ্চিত্ত কৰিবলৈ, ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা লেবীয়াসকলক, হাৰোণ আৰু তেওঁৰ পুত্ৰসকলক দানস্বৰূপে দিলোঁ; যাতে ইস্ৰায়েলৰ সন্তান সকলে পবিত্ৰ স্থানৰ ওচৰ চাপিলে ইস্ৰায়েলৰ সন্তান সকলৰ মাজত কোনো আপদ নঘটিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","মোচি, হাৰোণ আৰু ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীয়ে লেবীয়াসকললৈ এই দৰে কৰিলে। যিহোৱাই লেবীয়াসকলৰ বিষয়ে মোচিক দিয়া সকলো আদেশ অনুসাৰেই, ইস্ৰায়েলৰ সন্তান সকলে তেওঁলোকলৈ এই কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","লেবীয়াসকলে নিজ নিজ কাপোৰ ধুই নিজকে পাপৰ পৰা মুক্ত কৰিলে; আৰু হাৰোণে তেওঁলোকক যিহোৱাৰ উৎসৰ্গ কৰিলে, আৰু তেওঁলোকক শুচি কৰিবৰ অৰ্থে তেওঁলোকক প্ৰায়শ্চিত্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","তেতিয়াৰে পৰা লেবীয়াসকলে হাৰোণৰ আগত আৰু তেওঁৰ পুত্ৰসকলৰ আগত সাক্ষাৎ কৰা তম্বুত নিজ নিজ কাৰ্য কৰিবলৈ সোমাল। লেবীয়াসকলৰ বিষয়ে যিহোৱাই মোচিক দিয়া আজ্ঞা অনুসাৰেই তেওঁলোকে সেইদৰেই তেওঁলোকলৈ কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","পাছত যিহোৱাই পুনৰায় মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“লেবীয়াসকলৰ বিষয়ে এই নিয়ম - পঁচিশ বছৰ বয়সৰে পৰা লেবীয়াসকলে সাক্ষাৎ কৰা তম্বুত কাম কৰিবলৈ কৰ্মকাৰীসকলৰ শ্ৰেণীত সোমাব। ");
INSERT INTO asmfb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","আৰু পঞ্চাশ বছৰ বয়স হ’লে, সেই কৰ্মকাৰীসকলৰ শ্ৰেণীৰ পৰা ওলাব আৰু সেই কাম বন্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","তেওঁলোকে সাক্ষাৎ কৰা তম্বুত বস্তুৰ বুজ-বিচাৰ লৈ নিজৰ ভাইসকলৰ সহায় কৰোঁতা হ’ব কিন্তু সেৱাকৰ্ম আৰু নকৰিব। লেবীয়াসকলে কৰিবলগীয়া কাৰ্যৰ বিষয়ে তুমি তেওঁলোকলৈ এইদৰে কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ইস্ৰায়েল লোক মিচৰ দেশৰ পৰা ওলাই অহাৰ পাছত, দ্বিতীয় বছৰৰ প্ৰথম মাহত, চীনয় মৰুভূমিত যিহোৱাই মোচিক ক’লে, তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ইস্ৰায়েলৰ সন্তান সকলে নিৰূপিত সময়ত নিস্তাৰ-পৰ্ব্ব পালন কৰিব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","এই মাহৰ চতুৰ্দ্দশ দিনা সন্ধ্যাপৰত নিৰূপিত সময়ত তোমালোকে তাক বছৰি পালন কৰিবা। আৰু এই সমন্ধে ইয়াৰ নিয়ম-নীতি অনুসৰণ কৰা আৰু সকলো আজ্ঞাবোৰ পালন কৰি ইয়াক তোমালোকে ধৰি ৰাখিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","তেতিয়া মোচিয়ে ইস্ৰায়েলৰ সন্তান সকলক নিস্তাৰ-পৰ্ব্ব পালন কৰিবলৈ আজ্ঞা দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","তেতিয়া তেওঁলোকে প্ৰথম মাহৰ চতুৰ্দ্দশ দিনা সন্ধ্যাপৰত চীনয় মৰুভূমিত নিস্তাৰ-পৰ্ব্ব পালন কৰিলে। যিহোৱাই মোচিক দিয়া আজ্ঞাৰ দৰেই, ইস্ৰায়েলৰ সন্তান সকলে সেই সকলোকে কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","কিন্তু কিছুমান লোকে মানুহৰ শৱ চুই অশুচি হোৱা হেতুকে সেই দিনা নিস্তাৰ-পৰ্ব্ব পালন কৰিব নোৱাৰিলে। সেইবাবে তেওঁলোকে সেই দিনা মোচি আৰু হাৰোণৰ গুৰিলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","সেই লোকসকলে তেওঁক ক’লে, “আমি মানুহৰ শৱ চুই অশুচি হলোঁ; ইস্ৰায়েলৰ সন্তান সকলৰ মাজত নিৰূপিত সময়ত যিহোৱাৰ উদ্দেশ্যে উপহাৰ উৎসৰ্গ কৰিবলৈ আমি কিয় বঞ্চিত হ’ম?” ");
INSERT INTO asmfb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","তাতে মোচিয়ে তেওঁলোকক ক’লে, “তোমালোক অলপ ৰ’বা; তোমালোকৰ বিষয়ে যিহোৱাই কি আজ্ঞা দিয়ে, তাক শুনো।” ");
INSERT INTO asmfb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","পাছত যিহোৱাই মোচিক ক’লে, তেওঁ ক’লে ");
INSERT INTO asmfb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ক’বা, ‘তোমালোকৰ মাজত নাইবা তোমালোকৰ ভাবি-বংশৰ মাজত যদি কোনোৱে শৱ চুই অশুচি হয়, বা দূৰ বাটত পথিক হৈ থাকে, তথাপিও তেওঁ যিহোৱাৰ নিস্তাৰ-পৰ্ব্ব পালন কৰিব লাগিব’। ");
INSERT INTO asmfb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","দ্বিতীয় মাহৰ চতুৰ্দ্দশ দিনা সন্ধ্যাপৰত তেওঁলোকে তাক পালন কৰিব। তেওঁলোকে খমীৰ নিদিয়া পিঠা আৰু তিতা শাকেৰে নিস্তাৰ-পৰ্বৰ বলি খাব। ");
INSERT INTO asmfb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ৰাতিপুৱালৈ তাৰ একোকে অৱশিষ্ট নাৰাখিব আৰু কোনো হাড় নাভাঙিব; তেওঁলোকে নিস্তাৰ-পৰ্ব্বৰ সকলো বিধি অনুসাৰে তাক পালন কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","কিন্তু যিকোনোৱে শুচি হৈ থাকে আৰু পথিকো নহয়, কিন্তু তেওঁ যদি নিস্তাৰ-পৰ্ব্ব পালন কৰিবলৈ হেলা কৰে, তেন্তে সেই মানুহ নিজ লোকসকলৰ মাজত পৰা উচ্ছন্ন কৰা হ’ব। কাৰণ, নিৰূপিত সময়ত যিহোৱাৰ উদ্দেশ্যে উপহাৰ নিদিয়াত, তেওঁ নিজৰ পাপৰ ফল ভোগ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","আৰু কোনো বিদেশী লোকে তোমালোকৰ মাজত প্ৰবাসী হৈ থাকি যিহোৱাৰ উদ্দেশ্যে যদি নিস্তাৰ-পৰ্ব্ব পালন কৰিব খোজে, তেন্তে তেওঁ নিস্তাৰ-পৰ্ব্বৰ বিধিমতে আৰু তাৰ শাসন-প্ৰণালী অনুসাৰে তাক পালন কৰিব; স্বদেশত জন্মা, দুয়োৰো বাবে তোমালোকৰ একেটাই বিধি হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","আৰু যিদিনা আবাস স্থাপন কৰা হ’ল, সেই দিনা মেঘে সেই আবাস, সেই সাক্ষ্য-ফলি থকা তম্বু ঢাকি ধৰিলে, আৰু সন্ধ্যাবেলাৰ পৰা ৰাতিপুৱালৈকে সেই আবাসৰ ওপৰত তাক জুই যেন দেখা গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","এইদৰে সদায় আছিল। মেঘে তাক ঢাকিছিল আৰু ৰাতি জুইৰ নিচিনা দেখা গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","পাছে তম্বুৰ ওপৰৰ পৰা সেই মেঘ ওপৰলৈ নিয়া হ’লে, ইস্ৰায়েলৰ সন্তান সকলে যাত্ৰা কৰে। আৰু সেই মেঘ যি ঠাইত ৰখে, ইস্ৰায়েলৰ সন্তান সকলেও সেই ঠাইতে ছাউনি পাতি থাকে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","যিহোৱা আজ্ঞা অনুসাৰেই ইস্ৰায়েলৰ সন্তান সকলে যাত্ৰা কৰে আৰু তেওঁৰ আজ্ঞাৰ দৰেই ছাউনি পাতি থাকে; সেই মেঘ যেতিয়ালৈকে আবাসৰ ওপৰত থাকে, তেতিয়ালৈকে তেওঁলোক ছাউনিত থাকে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","আৰু সেই মেঘে যেতিয়া আবাসৰ ওপৰত বহুদিন ধৰি থাকে, তেতিয়া ইস্ৰায়েলৰ সন্তান সকলেও যাত্ৰা নকৰি, যিহোৱাৰ উদ্দেশ্যে যি কৰিব লগীয়া, তাকে কৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","আৰু সেই মেঘ কোনো কোনো সময়ত আবাসৰ ওপৰত অলপ দিন থাকে। তেনে স্থলত যিহোৱাৰ আজ্ঞা মতে তেওঁলোকে ছাউনিত থাকে আৰু যিহোৱাৰ আজ্ঞামতে যাত্ৰাও কৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","আৰু কোনো কোনো সময়ত মেঘ সন্ধ্যাপৰৰ পৰা ৰাতিপুৱালৈকে থাকে। আৰু ৰাতিপুৱা ওপৰলৈ নিয়া হ’লে, তেওঁলোকে যাত্ৰা কৰে। দিনত কি ৰাতিয়েই হওক, মেঘ ওপৰলৈ নিয়া হ’লেই তেওঁলোকে যাত্ৰা কৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","দুদিন বা এমাহ, নাইবা এবছৰ হওক, যিমান দিন আবাসৰ ওপৰত মেঘে ৰখি থাকে ইস্ৰায়েলৰ সন্তান সকলেও সিমান দিন যাত্ৰা নকৰি ছাউনিত থাকে। কিন্তু তাক ওপৰলৈ নিয়া হ’লেই, তেওঁলোকে যাত্ৰা কৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","যিহোৱাৰ আজ্ঞামতেই তেওঁলোকে ছাউনিত থাকে আৰু যিহোৱাৰ আজ্ঞা মতেই যাত্ৰাও কৰে; এইদৰে, মোচিৰ যোগেদি দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে তেওঁলোকে যিহোৱাৰ উদ্দেশ্যে কৰিব লগীয়া কাৰ্য কৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","পাছত যিহোৱাই মোচিক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“তুমি ৰূপৰ দুটা তূৰী সাজা। সেই ৰূপক পিতাই গঢ়াবা। লোকসকলক মাতিবলৈ আৰু ছাউনিবোৰ উঠি যাবৰ বাবে তুমি তাক ব্যৱহাৰ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","সেই দুটা তূৰী বজালে, গোটেই লোকসকলে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত তোমাৰ গুৰিত গোট খাব। ");
INSERT INTO asmfb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","কিন্তু এটা তূৰী বজালে, অধ্যক্ষসকল ইস্ৰায়েলৰ সন্তান সকলৰ গোষ্ঠীসকলৰ মূল মানুহ তোমাৰ গুৰিত গোট খাব। ");
INSERT INTO asmfb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","আৰু তোমালোকে ৰণত বজোৱাৰ দৰে তূৰী বজালে, পূৱফালে থকা ছাউনিবোৰ উঠি যাব। ");
INSERT INTO asmfb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","আৰু দ্বিতীয়বাৰ ৰণত বজোৱাৰ দৰে তূৰী বজালে, দক্ষিণফালে থকা ছাউনিবোৰ উঠি যাব। এইক্ৰমে তেওঁবিলাকে উঠি যাবলৈ ৰণৰ দৰে তূৰী বজাব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","লোকসকল গোট খাবৰ হলেও, তোমালোকে তূৰী বজাবা, কিন্তু ৰণত বজোৱাৰ দৰে নবজাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","হাৰোণৰ পুত্ৰ পুৰোহিত সকলে সেই দুটা তূৰী বজাব। তোমালোকৰ পুৰুষানুক্ৰমে চিৰস্থায়ী বিধিৰ কাৰণে তোমালোকে তাক ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","আৰু যি সময়ত তোমালোকে তোমালোকৰ দেশত উপদ্ৰৱ কৰোঁতা শত্ৰুবোৰৰ বিৰুদ্ধে যুদ্ধ কৰিবলৈ ওলাবা, সেই সময়ত সেই দুটা তূৰী ৰণত বজোৱাৰ দৰে বজাবা। তেতিয়া মই, তোমালোকৰ ঈশ্বৰ যিহোৱাই তোমালোকক সোঁৱৰণ কৰিব আৰু তোমালোকক তোমালোকৰ শত্ৰুবোৰৰ পৰা নিস্তাৰ পাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","আৰু আমোদৰ দিনতো, পৰ্ব্বৰ দিনত আৰু মাহৰ আৰম্ভণত, তোমালোকৰ হোম-বলিৰ আৰু মঙ্গলাৰ্থক বলিৰ কাষত তোমালোকে সেই তূৰী বজাবা; তাতে সেয়ে তোমালোকৰ ঈশ্বৰৰ সাক্ষাতে তোমালোকৰ সোঁৱৰণৰ উপায় হ’ব। মই তোমালোকৰ ঈশ্বৰ যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","পাছত দ্বিতীয় বছৰৰ দ্বিতীয় মাহৰ বিশ দিনৰ দিনা সেই মেঘ সাক্ষ্য-ফলি থকা আবাসৰ ওপৰৰ পৰা নিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","তাতে, ইস্ৰায়েলৰ সন্তান সকলে যাত্ৰা কৰাৰ নিয়ম অনুসাৰে চীনয় অৰণ্যৰ পৰা প্ৰস্থান কৰিলে; পাছত সেই মেঘ পাৰণ মৰুভুমিত ৰ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","মোচিৰ যোগেদি যিহোৱাই আজ্ঞা দিয়াৰ দৰে, তেওঁলোকে এই প্ৰথম বাৰ যাত্ৰা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","প্ৰথমে যিহূদাৰ সন্তান সকলৰ ছাউনিৰ পতাকাৰ অধীনে থকা লোকসকলে নিজ নিজ সৈন্য দল অনুসাৰে প্ৰস্থান কৰিলে। আৰু অম্মীনাদবৰ পুত্ৰ নহচোন তেওঁলোকৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","আৰু চূৱাৰৰ পুত্ৰ নথনেলে ইচাখৰ ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","আৰু হেলোনৰ পুত্ৰ ইলীয়াব জবূলূন ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","পাছে আবাস ভঙা হ’ল, আৰু গেৰ্চোনৰ সন্তান সকলে আৰু মৰাৰীৰ সন্তান সকলে সেই আবাস ভাৰ বৈ প্ৰস্থান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","তাৰ পাছত ৰূবেণৰ ছাউনিৰ পতাকাৰ অধীনে থকা লোকসকলে নিজ নিজ সৈন্যদল অনুসাৰে প্ৰস্থান কৰিলে। আৰু চদেয়ূৰৰ পুত্ৰ ইলীচূৰ তেওঁলোকৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","আৰু চূৰীচদ্দয়ৰ পুত্ৰ চলমীয়েল চিমিয়োন ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","আৰু দুৱেলৰ পুত্ৰ ইলিয়াচফ গাদ ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","পাছে পবিত্ৰ স্থানৰ বস্তু ভাৰ বওঁতা কহাতীয়া লোকসকলে প্ৰস্থান কৰিলে। আৰু তেওঁলোকে গৈ নৌ পাওঁতেই, আন লোকসকলে আবাস স্থাপন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","পাছে ইফ্ৰয়িমৰ ছাউনিৰ পতাকাৰ অধীনে থকা লোকসকলে নিজ নিজ সৈন্যদল অনুসাৰে প্ৰস্থান কৰিলে; আৰু অম্মীহূদৰ পুত্ৰ ইলীচামা তেওঁলোকৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","আৰু পদাচূৰৰ পুত্ৰ গম্লীয়েল মনচি ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","আৰু গিদিয়োনীৰ পুত্ৰ অবীদান বিন্যামীন ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","পাছে সকলো ছাউনিৰ পাছত, নিজ নিজ সৈন্যদল অনুসাৰে দানৰ সন্তান সকলৰ ছাউনিৰ পতাকাৰ অধীনে থকা লোকসকলে প্ৰস্থান কৰিলে; আৰু অম্মীচদ্দয়ৰ পুত্ৰ অহীয়েজৰ তেওঁলোকৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","আৰু আক্ৰণৰ পুত্ৰ পগীয়েল আচেৰ ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","আৰু ঐননৰ পুত্ৰ অহীৰা নপ্তালী ফৈদৰ সেনাপতি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","প্ৰস্থান কৰা সময়ত ইস্ৰায়েলৰ সন্তান সকলে নিজ নিজ সৈন্যদল অনুসাৰে এইদৰে প্ৰস্থান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","পাছে মোচিয়ে তেওঁৰ শহুৰেক মিদিয়ন দেশৰ ৰূৱেলৰ পুত্ৰ হোববক ক’লে, “যিহোৱাই আমাক যি দেশ দিম বুলি কৈছে, আমি সেই দেশলৈ যাত্ৰা কৰিছোঁ। যিহোৱাই ক’লে, ‘এই দেশ মই তোমাক দিম’। তুমিও আমাৰ লগত ব’লা, তাতে আমি তোমাৰ মঙ্গল কৰিম; কিয়নো যিহোৱাই ইস্ৰায়েলৰ মঙ্গল কৰিবলৈ প্রতিজ্ঞা কৰিছে।” ");
INSERT INTO asmfb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","কিন্তু হোবাবে মোচিক ক’লে, “মই তোমাৰ লগত নাযাওঁ। মই নিজ দেশৰ জ্ঞাতিসকলৰ ওচৰলৈ যাম।” ");
INSERT INTO asmfb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","মোচিয়ে আকৌ ক’লে, “মিনতি কৰিছোঁ, তুমি আমাক নেৰিবা; কিয়নো মৰুভুমিত মাজত কোন ঠাইত আমাৰ ছাউনি স্থাপন কৰিব লগা হ’ব, তাক তুমি জানা। এই কাৰণে তুমি আমাৰ চকুস্বৰূপ হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","আৰু যদি তুমি আমাৰ লগত যোৱা, তেনেহলে, যিহোৱাই আমাৰ যি মঙ্গল কৰিব, আমি তোমাকো সেই মঙ্গল ভোগ কৰাম।” ");
INSERT INTO asmfb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","পাছত তেওঁলোকে যিহোৱাৰ পৰ্ব্বতৰ পৰা তিনদিনৰ বাট প্ৰস্থান কৰিলে; আৰু যিহোৱাৰ নিয়ম চন্দুক তেওঁলোকৰ কাৰণে বিশ্ৰামৰ ঠাই বিচাৰি বিচাৰি তিন দিনৰ বাট তেওঁলোকৰ আগে আগে গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","আৰু ছাউনি ভাঙি প্ৰস্থান কৰা সময়ত যিহোৱাৰ মেঘ দিনত তেওঁলোকৰ ওপৰত থাকিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","আৰু চন্দুক যোৱা সময়ত মোচিয়ে কয়, “হে যিহোৱা উঠা, তোমাৰ শত্ৰুবোৰ ছিন্ন ভিন্ন হওঁক আৰু তোমাক ঘিণ কৰোঁতাসকল তোমাৰ আগৰ পৰা পলাই যাওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","আৰু যেতিয়াই নিযম-পুস্তকটি ৰৈ যায়, তেতিয়া মোচিয়ে কয়, “হে যিহোৱা তুমি ইস্ৰায়েলৰ হাজাৰ হাজাৰ গোষ্ঠীৰ ওচৰলৈ উলটি আহা।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","পাছত লোকসকলে, যিহোৱাৰ কাণত পৰাকৈ বাটৰ দুখৰ কাৰণে বকা লোকৰ নিচিনাকৈ আচৰণ কৰিলে, তাকে শুনি যিহোৱাৰ ক্ৰোধ জ্বলি উঠিল; তাতে তেওঁলোকৰ বিৰুদ্ধে যিহোৱাৰ ক্ৰোধাগ্নি জ্বলি উঠি, ছাউনিৰ শেষ ভাগত লোকসকলক গ্ৰাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","এই কাৰণে লোকসকলে মোচিৰ গুৰিত কাতৰোক্তি কৰিলে; তাতে মোচিয়ে যিহোৱাৰ আগত প্ৰাৰ্থনা কৰাত সেই অগ্নি নুমাল। ");
INSERT INTO asmfb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","তেতিয়া সেই ঠাইৰ নাম তবিয়েৰা দাহ ৰখা হ’ল; কিয়নো যিহোৱাৰ অগ্নিয়ে তেওঁলোকৰ বিৰুদ্ধে দাহ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","তাৰ পাছত, তেওঁলোকৰ মাজত থকা মিশ্ৰিত লোকসকলে খঁকুৱা স্বভাৱ কৰিবলৈ ধৰিলে আৰু ইস্ৰায়েলৰ সন্তান সকলে পুনৰায় কান্দি কান্দি ক’লে, “আমাক মঙহ খাবলৈ কোনে দিব? ");
INSERT INTO asmfb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","আমি মিচৰ দেশত বিনামূল্যে যি যি মাছ খাইছিলোঁ আৰু তিয়হ, খৰমূজা; পৰু, পিঁয়াজ আৰু নহৰুলৈ মনত পৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","আৰু এতিয়া আমাৰ প্ৰাণ শুকাল; আমাৰ আগত এই মান্নাৰ বাহিৰে আৰু একোৱেই নাই।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","সেই মান্না ধনীয়া গুটিৰ নিচিনা আৰু তাৰ বৰণ গুগগুলুৰ বৰণৰ নিচিনা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","লোকসকলে ইফালে সিফালে ফুৰি তাক চপায় আৰু জাঁতত পিহি বা খপবলি খুন্দি গুড়ি কৰি টৌত সিজায় আৰু তাৰ দ্বাৰাই পিঠা বনায়; তাৰ আস্বাদ তেলেৰে যুগুত কৰা সুস্বাদু আহাৰৰ আস্বাদৰ নিচিনা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ৰাতি ছাউনিৰ ওপৰত নিয়ৰ পৰা সময়ত, নিয়ৰৰ লগত সেই মান্না পৰি থাকে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","পাছে মোচিয়ে লোকসকলৰ গোষ্ঠী অনুসাৰে নিজ নিজ তম্বুৰ দুৱাৰৰ ওচৰত প্ৰতিজনে কান্দি থকা শুনিলে। তেতিয়া যিহোৱাৰ ক্ৰোধ অতিশয়ৰূপে জ্বলি উঠিল, আৰু মোচিয়েও অসন্তোষ পালে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","পাছে মোচিয়ে যিহোৱাক জনালে, “তুমি কি কাৰণে তোমাৰ দাসক ইমান ক্লেশ দিছা? কি কাৰণে বা মই তোমাৰ দৃষ্টিত অনুগ্ৰহ পোৱা নাই? তুমি এই সকলো লোকৰ ভাৰ মোৰ ওপৰত দিছা? ");
INSERT INTO asmfb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","মই জানো এই সকলো লোকক গৰ্ভধাৰণ কৰিলোঁ, বা এই সকলো লোকক প্ৰসৱ কৰিলোঁ, যে তুমি এওঁলোকৰ পূৰ্বপুৰুষসকলৰ আগত যি দেশ দিবলৈ প্রতিজ্ঞা কৰিছিলা, সেই দেশলৈ গাখীৰ খোৱা কেঁচুৱাক পালন কৰোঁতা বাপেকৰ দৰে তেওঁলোকক বুকুত বান্ধি নিবলৈ মোক আজ্ঞা দিছা? ");
INSERT INTO asmfb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","এই সকলো লোকক দিবৰ বাবে মই ক’ত মাংস পাম? কিয়নো এওঁলোক সকলোৱে মোৰ গুৰিত কান্দি কৈছে, ‘আমাক মাংস দিয়া আমি খাওঁ।’ ");
INSERT INTO asmfb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","এই আটাই লোকৰ ভাৰ মই অকলেই বব নোৱাৰোঁ; কিয়নো সেয়ে মোৰ শক্তিতকৈয়ো গধুৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","তুমি যদি মোলৈ এনে ব্যৱহাৰ কৰা, তেন্তে মই বিনয় কৰিছোঁ, মই যদি তোমাৰ দৃষ্টিত অনুগ্ৰহপ্ৰাপ্ত হৈছোঁ, তেন্তে এতিয়া মোক একেবাৰে মাৰা আৰু মোৰ দুৰ্গতি মোক দেখিবলৈ নিদিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","তেতিয়া যিহোৱাই মোচিক ক’লে, “তুমি লোকসকলৰ মাজত যিসকলক বৃদ্ধ আৰু লোকসকলৰ অধ্যক্ষ বুলি জানা, ইস্ৰায়েলৰ এনে সত্তৰ জন বৃদ্ধ লোকক চপাই সাক্ষাৎ কৰা তম্বুৰ দুৱাৰলৈ লৈ আহা; তেওঁলোকে তোমাৰ লগত সেই ঠাইত থিয় হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","পাছত মই সেই ঠাইলৈ নামি আহি তোমাৰে সৈতে কথা হ’ম আৰু তোমাত যি আত্মা আছে, তাৰ কিছু লৈ তেওঁলোকত ৰাখিম; তাতে, তুমি যেন অকলেই লোকসকলৰ ভাৰ নোবোৱা, এইবাবে তেওঁলোকে তোমাৰ লগত লোকসকলৰ ভাৰ ব’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","আৰু তুমি লোকসকলক কোৱা, ‘তোমালোকে কালিৰ বাবে নিজক পবিত্ৰ কৰা; যিহোৱা যে আহিব নিজকে যুগুত কৰা। তেতিয়া তোমালোকে মাংস খাবলৈ পাবা; কিয়নো তোমালোকে কান্দি কান্দি কৈছিলা, ‘আমাক মাংস খাবলৈ কোনে দিব? কিয়নো মিচৰ দেশত আমাৰ ভাল আছিল।’ এই হেতুকে যিহোৱাই তোমালোকক মাংস দিব; আৰু তোমালোকে খাবলৈ পাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","তোমালোকে এদিন বা দুদিন, বা পাঁচ দিন, বা দহ দিন, বা বিশ দিন যে তাক খাবা এনে নহয়; ");
INSERT INTO asmfb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","সম্পূৰ্ণ এমাহলৈকে খাবা, যেতিয়ালৈকে সেয়ে তোমালোকৰ নাকেদি নোলায় আৰু ঘিণ লগা নহয়, তেতিয়ালৈকে তাক খাবা, কিয়নো তোমালোকে তোমালোকৰ মাজত থকা যিহোৱাক অগ্ৰাহ্য কৰি তেওঁৰ আগত কান্দি কান্দি এই কথা কৈছিলা যে, ‘আমি কিয় মিচৰ দেশৰ পৰা বাহিৰ হৈ আহিলোঁ’?” ");
INSERT INTO asmfb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","তেতিয়া মোচিয়ে ক’লে, “যি লোকসকলৰ মাজত আছোঁ, তেওঁলোক ছয় লাখ পদাতিক; তথাপি তুমি কৈছা, ‘সম্পূৰ্ণ এমাহ খাবৰ বাবেই মই তেওঁলোকক মঙহ দিম।’ ");
INSERT INTO asmfb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","তেওঁলোকক আটাই মেৰ, ছাগলী আৰু গৰুৰ জাক মাৰিব লাগে নে? নাইবা তেওঁলোকক প্ৰয়োজন হোৱাকৈ সাগৰৰ আটাই মাছ গোটাব লাগে নে?” ");
INSERT INTO asmfb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","তেতিয়া যিহোৱাই মোচিক ক’লে, “যিহোৱাৰ হাত জানো চুটি হ’ল? তোমাৰ আগত মোৰ বাক্য সিদ্ধ হ’ব নে নহ’ব, তাক তুমি এতিয়া দেখিবলৈ পাবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","তেতিয়া মোচিয়ে বাহিৰলৈ গৈ, যিহোৱাৰ বাক্য লোকসকলক ক’লে, আৰু তেওঁলোকৰ বৃদ্ধ লোকৰ মাজৰ সত্তৰ জনক গোটাই তম্বুৰ চাৰিওফালে থিয় কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","তাতে যিহোৱাই মেঘত নামি তেওঁক কথা ক’লে আৰু যি আত্মা মোচিত আছিল, তাৰ কিছু লৈ, সেই সত্তৰজন বৃদ্ধ লোকত ৰাখিলে। তাতে সেই আত্মা তেওঁলোকত থকাত, তেওঁলোকে ভাববাণী প্ৰচাৰ কৰিলে; কিন্তু তাৰ পাছত আৰু নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","কিন্তু দুজন মানুহ ছাউনিত থাকিল, এজনৰ নাম ইল্দদ, আন জনৰ নাম মেদদ। এই দুজনতো আত্মা থাকিল। তেওঁলোকৰ নাম বহীত নাম লিখা লোকসকলৰ মাজত আছিল হয়, কিন্তু ওলাই তম্বুৰ ওচৰলৈ যোৱা নাছিল। যিয়েই নহওঁক লাগে, কিন্তু তেওঁলোকে ছাউনিত ভাববাণী প্ৰচাৰ কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","তাতে এজন ডেকা মানুহে লৰি গৈ মোচিক ক’লে, “ইল্দদ আৰু মেদদে ছাউনিত ভাববাণী প্ৰচাৰ কৰিছে।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","তেতিয়া মোচিৰ পৰিচাৰক, তেওঁৰ মনোনীত লোক নুনৰ পুত্ৰ যিহোচূৱাই উত্তৰ দি ক’লে, “হে মোৰ প্ৰভু মোচি, তেওঁলোকক নিষেধ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","তাতে মোচিয়ে তেওঁ ক’লে, “তুমি মোৰ পক্ষ হৈ ঈৰ্ষা কৰিছা নে? যিহোৱাৰ আটাইলোক ভাববাদী হোৱা হ’লে, আৰু যিহোৱাই তেওঁলোকৰ ওপৰত নিজ আত্মা থাকিবলৈ দিয়া হ’লে, মই কেনে সন্তোষ পালোঁহেঁতেন।” ");
INSERT INTO asmfb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","পাছত মোচি আৰু ইস্ৰায়েলৰ বৃদ্ধসকল ছাউনিলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","পাছত যিহোৱাৰ ওচৰৰ পৰা বায়ু ওলাই সমুদ্ৰৰ পৰা ইমান বটা চৰাই আনি ছাউনিৰ ওপৰত পেলালে, যে, ছাউনিৰ চাৰিওফালে ইকাষে-সিকাষে এদিনৰ বাটলৈকে, সেইবোৰ দুহাত ওখ হৈ মাটিৰ ওপৰত পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","তাতে তেওঁলোকে সেই ওৰে দিন ওৰে ৰাতি আৰু পিছদিনাও গোটেই দিন উঠি সেই বটা চৰাইবোৰ গোটালে। তেওঁলোকৰ মাজত যেয়ে সকলোতকৈ তাকৰকৈ গোটালে, তাৰো দহ হোমৰ আছিল। পাছত তেওঁলোকৰ ছাউনিৰ চাৰিওফালে নিজৰ বাবে, তাক শুকাবলৈ মেলি দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","কিন্তু তেওঁলোকে দুই দাঁতৰ মাজত মঙহ কামোৰ মাৰি ধৰোঁতেই, চোবোৱাৰ আগেয়ে লোকসকললৈ যিহোৱাৰ ক্ৰোধ জ্বলি উঠিল। তাতে যিহোৱাই লোকসকলক অতিশয় মহামাৰীৰ দ্বাৰাই আঘাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","আৰু সেই ঠাইৰ নাম কিব্ৰোৎ-হত্তাবা খঁকুৱা স্বভাৱৰ লোকসকলৰ মৈদাম ৰখা হ’ল; কিয়নো সেই ঠাইত তেওঁলোকে খঁকুৱা স্বভাৱৰ লোকবোৰক মৈদাম দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","পাছত লোকসকলে কিব্ৰোৎ-হত্তাবাৰ পৰা হচেৰোতলৈ যাত্ৰা কৰি সেই ঠাইতে থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","মোচিয়ে কুচ দেশীয় যি জনীক বিয়া কৰিছিল, সেই গৰাকীৰ বিষয়ে মিৰিয়ম আৰু হাৰোণে মোচিৰ অহিতে কথা কলে; কাৰণ তেওঁ এজনী কুচীয়া মহিলাৰ সৈতে বিয়া পাতিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","তেওঁলোকে ক’লে, “যিহোৱাই জানো কেৱল মোচিৰ যোগেদি কথা কয়? আমাৰ যোগেদি নকয় জানো?” আৰু যিহোৱাই সেই কথা শুনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","পৃথিৱীত থকা লোকসকলৰ মাজত মোচি সকলোতকৈ অতিশয় নম্ৰ লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","পাছে যিহোৱাই পোনে পোনেই মোচি, হাৰোণ আৰু মিৰিয়মক ক’লে, “তোমালোক তিনিওজন বাহিৰ হৈ সাক্ষাৎ কৰা তম্বুৰ গুৰিলৈ আহাঁ।” তাতে তেওঁলোক তিনিওজন ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","তেতিয়া যিহোৱাই মেঘ-স্তম্ভত নামি আহি, তম্বুৰ দুৱাৰ মুখত স্থিতি হৈ, হাৰোণ আৰু মিৰিয়মক মাতিলে। তেতিয়া তেওঁলোক দুয়ো আগ বাঢ়ি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","যিহোৱাই ক’লে, “এতিয়া তোমালোকে মোৰ বাক্য শুনা। তোমালোকৰ মাজত যদি মোৰ কোনো ভাববাদী হয়, তেন্তে মই যিহোৱাই তেওঁৰ আগত কোনো দৰ্শনৰ দ্বাৰাই নিজকে চিনাকি দিম, নাইবা সপোনত তেওঁৰ লগত কথা হ’ম। ");
INSERT INTO asmfb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","মোৰ দাস মোচি তেনে নহয়। তেওঁ মোৰ ঘৰৰ আটাই লোকৰ মাজত বিশ্বাসী। ");
INSERT INTO asmfb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","তেওঁৰে সৈতে মই নিগূঢ় বাক্যৰ দ্বাৰাই কথা নহওঁ, কিন্তু মুখা-মুখি হৈ, স্পষ্টকৈ কথা হওঁ। আৰু তেওঁ মোৰ আকাৰ দেখে। এই হেতুকে মোৰ দাস মোচিৰ অহিতে কথা ক’বলৈ তোমালোকে কিয় ভয় নকৰিলা?” ");
INSERT INTO asmfb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","তাতে তেওঁলোকলৈ যিহোৱাৰ ক্ৰোধ জ্বলি উঠিল আৰু তেওঁ প্ৰস্থান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","পাছে তম্বুৰ ওপৰৰ পৰা মেঘ গুচিলত, চোৱা, মিৰিয়মৰ গাত হিমৰ দৰে কুষ্ঠৰোগ হ’ল - তেতিয়া হাৰোণে মিৰিয়মৰ ফাললৈ মুখ ঘূৰাই চাই তেওঁক কুষ্ঠৰোগ হোৱাতো তেওঁ দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","তেতিয়া হাৰোণে মোচিক ক’লে, “হায় হায় মোৰ প্ৰভু, আমি মুৰ্খৰ দৰে কাৰ্য কৰি যি পাপ কৰিলোঁ, বিনয় কৰিছোঁ, সেই পাপৰ ফল আমাক ভোগ কৰিবলৈ নিদিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","মাকৰ গৰ্ভৰ পৰা ওলোৱা কালত যাৰ মাংস আধা নষ্ট, এনে মৰা গৰ্ভফলৰ দৰে এওঁক হ’বলৈ নিদিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","তেতিয়া মোচিয়ে যিহোৱাৰ আগত কাতৰোক্তি কৰি ক’লে, “হে ঈশ্বৰ, বিনয় কৰিছোঁ, এওঁক সুস্থ কৰক।” ");
INSERT INTO asmfb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","পাছত যিহোৱাই মোচিক ক’লে, “তেওঁৰ বাপেকে তেওঁৰ মুখত যদি কেৱল থুই পেলালেহেঁতেন, তেনেহলে তেওঁৰ জানো সাত দিনলৈকে লাজ কৰি নাথাকিলহেঁতেন? এই হেতুকে তেওঁ সাত দিন ছাউনিৰ বাহিৰে বন্ধ হৈ থাওঁক, পাছত তেওঁক পুনৰায় ভিতৰলৈ আনিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","তেতিয়া মিৰিয়মক সাদিন ছাউনিৰ বাহিৰত বন্ধ কৰি ৰখা হ’ল; যেতিয়ালৈকে মিৰিয়মক ভিতৰলৈ অনা নহ’ল, তেতিয়ালৈকে লোকসকলে যাত্ৰা নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","পাছত লোকসকলে হচেৰোতৰ পৰা যাত্ৰা কৰি, পাৰণ মৰুভূমি ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","তেতিয়া যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“মই ইস্ৰায়েল সন্তান সকলক যি দেশ দিম, সেই কনান দেশ গুপুতে চাবলৈ তুমি কেইজনমান মানুহ পঠোৱা। তোমালোকে তেওঁলোকৰ নিজ নিজ পিতৃ-বংশৰ প্রত্যেকখন ফৈদৰ পৰা এজন এজন অধ্যক্ষক পঠোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","তেতিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে মোচিয়ে পাৰণ মৰুভূমিৰ পৰা তেওঁলোকক পঠিয়ালে। তেওঁলোক সকলোৱে ইস্ৰায়েলৰ সন্তান সকলৰ মূল মানুহ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","তেওঁলোকৰ নাম এই এই; ৰূবেণ ফৈদৰ মাজৰ জক্কূৰৰ পুত্ৰ চম্মুৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","চিমিয়োন ফৈদৰ মাজৰ হোৰীৰ পুত্ৰ চাফট। ");
INSERT INTO asmfb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","যিহূদা ফৈদৰ মাজৰ যিফুন্নিৰ পুত্ৰ কালেব। ");
INSERT INTO asmfb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ইচাখৰ ফৈদৰ মাজৰ যোচেফৰ পুত্ৰ যিগাল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ইফ্ৰয়িম ফৈদৰ মাজৰ নুনৰ পুত্ৰ হোচেয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","বিন্যামীন ফৈদৰ মাজৰ ৰাফূৰ পুত্ৰ পল্টী। ");
INSERT INTO asmfb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","জবূলূন ফৈদৰ মাজৰ চোদীৰ পুত্ৰ গদ্দীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","যোচেফ ফৈদৰ অৰ্থাৎ মনচি ফৈদৰ মাজৰ চুচীৰ পুত্ৰ গদ্দী। ");
INSERT INTO asmfb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","দান ফৈদৰ মাজৰ গমল্লীৰ পুত্ৰ অম্মীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","আচেৰ ফৈদৰ মাজৰ মীখায়েলৰ পুত্ৰ চখূৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","নপ্তালী ফৈদৰ মাজৰ বফচীৰ পুত্ৰ নহ্বী। ");
INSERT INTO asmfb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","গাদ ফৈদৰ মাজৰ মাখীৰ পুত্ৰ গূৱেল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","এই এই নামৰ লোকসকল মোচিয়ে গুপুতে দেশ চাবলৈ পঠিয়ালে। মোচিয়ে নুনৰ পুত্ৰ হোচেয়াৰ নাম যিহোচূৱা ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","কনান দেশ চাবলৈ পঠোৱা সময়ত মোচিয়ে তেওঁলোকক ক’লে, “তোমালোক এই দক্ষিণ অঞ্চলেদি গৈ পৰ্ব্বতত উঠাগৈ। ");
INSERT INTO asmfb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","আৰু সেই দেশ কেনেকুৱা আৰু তাত বাস কৰা লোকসকল বলী নে নিৰ্ব্বলী আৰু তাকৰ নে সৰহ। ");
INSERT INTO asmfb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","আৰু তেওঁলোক যি দেশত বাস কৰিছে, সেই দেশ কেনেকুৱা, ভাল নে বেয়া আৰু যি যি নগৰত তেওঁলোকে বাস কৰিছে, সেইবোৰ নগৰ কেনেধৰণৰ, মুকলি নে গড়েৰে আবৃত হোৱা? ");
INSERT INTO asmfb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","আৰু সিহঁতৰ মাটি কেনেকুৱা, সাৰুৱা নে অসাৰোৱা, তাৰ মাজত গছ-গছনি আছে নে নাই, এই সকলোকে তোমালোকে চাবা। তোমালোকে সাহিয়াল হোৱা আৰু সেই দেশৰ কোনো কোনো ফল লগত আনিবা।” তেতিয়া প্ৰথমে পকা দ্ৰাক্ষাফলৰ সময় আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","তাতে তেওঁলোকে উঠি গৈ, ছিন মৰুভূমিৰ পৰা ৰহোবলৈ, হমাতৰ প্ৰৱেশস্থানলৈকে দেশখন গুপুতে চালে। ");
INSERT INTO asmfb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","তেওঁলোক দক্ষিণ অঞ্চলেদি গৈ, হিব্ৰোণলৈকে উঠিল, সেই ঠাইতে অহিমন, চেচয় আৰু তল্ময়, এই তিনিজন অনাক’ৰ সন্তান আছিল। মিচৰ দেশত থকা চোৱন নগৰ স্থাপন কৰাৰ সাত বছৰৰ আগেয়ে হিব্ৰোণ স্থাপন কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","পাছত তেওঁলোকে ইষ্কোল উপত্যকালৈ আহি সেই ঠাইতে এথোপা দ্ৰাক্ষাফল থকা দ্ৰাক্ষালতাৰ এটা ডাল কাটি, কানমাৰি লগাই দুজনে সাঙ্গী কৰি ল’লে আৰু কিছুমান ডালিম আৰু ডিমৰু ফলো লগত ললে। ");
INSERT INTO asmfb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ইস্ৰায়েলৰ সন্তান সকলে সেই ঠাইতে সেই দ্ৰাক্ষাৰ থোপা কাটিলে দেখি, সেই ঠাইৰ নাম ইষ্কোল উপত্যকা ৰখা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","চল্লিশ দিনৰ পাছত, তেওঁলোকে দেশ চাই উলটি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","পাছত তেওঁলোকে পাৰণ মৰুভূমিৰ কাদেচলৈ, মোচি, হাৰোণ আৰু ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীৰ গুৰিলৈ আহি, তেওঁলোকক আৰু গোটেই সমাজক সম্বাদ দিলে আৰু সেই দেশৰ ফল তেওঁলোকক দেখুৱালে। ");
INSERT INTO asmfb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","আৰু তেওঁলোকে মোচিক ক’লে, “আপুনি যি দেশলৈ আমাক পঠাইছিল, আমি সেই দেশলৈ গৈছিলোঁ। সঁচাকৈ সেই দেশ গাখীৰ আৰু মৌজোল বৈ থকা দেশ। চাওঁক এইয়া তাৰ ফল। ");
INSERT INTO asmfb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","সেই দেশত থকা লোকসকল বলী আৰু নগৰবোৰ গড়েৰে আবৃত আৰু অতি ডাঙৰ। আৰু সেই ঠাইতে আমি অনাকীয়া সন্তান সকলকো দেখিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","দক্ষিণ অঞ্চলত অমালেকে বাস কৰিছে। আৰু পৰ্ব্বতত হিত্তীয়া, যিবুচীয়া, আৰু ইমোৰীয়া লোকসকলে বাস কৰিছে। সমুদ্ৰৰ দাঁতিত আৰু যৰ্দ্দনৰ পাৰত কনানীয়া লোকসকলে বাস কৰিছে।” ");
INSERT INTO asmfb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","পাছত কালেবে মোচিৰ আগত লোকসকলক শান্ত কৰিবৰ অৰ্থে ক’লে, “আহা, আমি একেবাৰে উঠি গৈ, তাক অধিকাৰ কৰোঁ; কিয়নো তাক জয় কৰিবলৈ অৱশ্যে আমাৰ অধিক শক্তি আছে।” ");
INSERT INTO asmfb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","কিন্তু যি লোকসকল তেওঁৰ লগত গৈছিল, তেওঁলোকে ক’লে, “আমি সেই লোকসকলৰ বিৰুদ্ধে উঠি যাব নোৱাৰোঁ, কিয়নো আমাতকৈ সিহঁত বলী।” ");
INSERT INTO asmfb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","এইদৰে, তেওঁলোকে যি দেশ চাবলৈ গৈছিল, ইস্ৰায়েলৰ সন্তান সকলৰ আগত সেই দেশ দুৰ্যশ কৰি ক’লে, “আমি যি দেশৰ মাজেদি চাই চাই গৈছিলোঁ; সেই দেশ নিজৰ নিবাসীসকলক গ্ৰাস কৰোঁতা দেশ। আৰু তাৰ মাজত আমি যিমান মানুহ দেখিলোঁ, তেওঁলোক অতি ওখ ওখ লোক। ");
INSERT INTO asmfb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","আৰু তাৰ নাফিল বংশ অনাকৰ সন্তান নাফিলসকলক দেখি, আমাৰ মানত আমি ফৰিঙৰ নিচিনা হ’লো; আৰু সিহঁতৰ দৃষ্টিতো তেনেকুৱাই আছিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","পাছত গোটেই সমাজে বৰকৈ ক্রন্দন কৰিলে; সেই ৰাতি তেওঁলোকে সকলোৱে চকুলো টুকিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","আৰু ইস্ৰায়েলৰ সন্তান সকলৰ সকলোৱে মোচি আৰু হাৰোণৰ অহিতে নিন্দা কৰিবলৈ ধৰিলে। আৰু গোটেই সমাজে তেওঁলোকৰ আগতে ক’লে, “হায় হায়, আমি এই মৰুভূমিত মৰাতকৈ মিচৰ দেশতেই মৰা হ’লে কেনে ভাল আছিল! ");
INSERT INTO asmfb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","যিহোৱাই আমাক তৰোৱালৰ আগত পেলাবলৈ আৰু আমাৰ পত্নীসকল আৰু আমাৰ কনমানি সকলক লুট কৰাবলৈ এই দেশলৈ আমাক কিয় আনিছে? মিচৰ দেশলৈ উলটি যোৱা জানো আমাৰ পক্ষে ভাল নহয়?” ");
INSERT INTO asmfb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","পাছত তেওঁলোকে ইজনে সিজনক ক’লে, “আহাঁ, আমি কোনো এজনক প্ৰধান কৰি লৈ মিচৰ দেশলৈ উলটি যাওঁ ব’লা।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","তেতিয়া মোচি আৰু হাৰোণে ইস্ৰায়েলৰ সন্তান সকলৰ সমাজৰ, আৰু তেওঁলোকৰ গোটেই গোট খোৱা সমাজৰ আগত উবুৰি হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","দেশ গুপুতে চাই অহাসকলৰ মাজত নুনৰ পুত্ৰ যিহোচূৱা আৰু যিফুন্নিৰ পুত্ৰ কালেবে নিজ নিজ কাপোৰ ফালিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই সমাজক ক’লে, “আমি যি দেশ চাবলৈ দেশৰ মাজেদি গৈছিলোঁ সেয়ে যাৰ পাৰ নাই উত্তম দেশ। ");
INSERT INTO asmfb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","যিহোৱাই যদি আমাত সন্তোষ পায়, তেন্তে তেওঁ আমাক সেই দেশলৈ নিব, গাখীৰ আৰু মৌজোল বোৱা সেই দেশ আমাক দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","কেৱল তোমালোকে কোনো ধৰণৰ যিহোৱাৰ বিৰুদ্ধে বিদ্ৰোহ আচৰণ নকৰিবা, সেই দেশৰ লোকসকললৈ ভয়ো নকৰিবা। কিয়নো তেওঁলোক আমাৰ ভক্ষ্যনস্বৰূপ। সিহঁতৰ আশ্ৰয় সিহঁতৰ পৰা গুচিল, কাৰণ যিহোৱা আমাৰ সঙ্গত আছে; তেওঁলোকলৈ ভয় নকৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","কিন্তু গোটেই সমাজে তেওঁলোকক শিল দলিয়াই বধ কৰিবলৈ ক’লে, তাতে সাক্ষাৎ কৰা তম্বুত যিহোৱাৰ প্ৰতাপ ইস্ৰায়েলৰ সন্তান সকলৰ আগত প্ৰকাশিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","পাছত যিহোৱাই মোচিক ক’লে, “এই লোকসকলে কিমান দিন মোক হেয়জ্ঞান কৰিব? আৰু তেওঁলোকৰ মাজত মই দেখুউৱা আটাইবোৰ চিন দেখিও, তেওঁলোকে কিমান কাল মোত অবিশ্বাস কৰি থাকিব? ");
INSERT INTO asmfb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","মই মহামাৰীৰ দ্বাৰাই তেওঁলোকক আঘাত কৰিম আৰু তেওঁলোকৰ আধিপত্য গুচাম আৰু তেওঁলোকতকৈ তোমাকেই ডাঙৰ আৰু বলৱান জাতি কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","মোচিয়ে যিহোৱাক ক’লে, “তেনে কৰিলে, মিচৰীয়াসকলে তাক শুনিবলৈ পাব; কিয়নো সিহঁতৰেই মাজৰ পৰা তুমি নিজ শক্তিৰ দ্বাৰাই এই লোকসকলক উলিয়াই আনিলা। ");
INSERT INTO asmfb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","আৰু তেওঁলোকে এই দেশ নিবাসীসকলকো সম্বাদ দিব। তেওঁলোকে শুনিছে, যে, তুমি যিহোৱা এই লোকসকলৰ মাজত আছা, তুমি যিহোৱাই সন্মুখা-সন্মুখিকৈ তেওঁলোকক দৰ্শন দি থাকা, তোমাৰ মেঘ তেওঁলোকৰ ওপৰত আছে আৰু তুমি দিনত মেঘ-স্তম্ভ আৰু ৰাতি অগ্নি স্তম্ভত তেওঁলোকৰ আগে আগে যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","এতিয়া যদি তুমি এই লোকসকলক এজনক মৰাৰ দৰে মাৰা, তেন্তে এই যি আন জাতি সমূহে তোমাৰ যশস্যাৰ কথা শুনিছে, সিহঁতে ক’ব, ");
INSERT INTO asmfb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘যিহোৱাই এই লোকসকলক যি দেশ দিবলৈ শপত কৰিছিল, সেই দেশলৈ তেওঁলোকক নিবলৈ তেওঁ অসমৰ্থ হ’ল, এই কাৰণে অৰণ্যত তেওঁলোকক মাৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","এতিয়া মই এই নিবেদন কৰোঁ, যে, যিহোৱা ক্ৰোধত ধীৰ আৰু দয়াতো মহান, অপৰাধ আৰু আজ্ঞা-লঙ্ঘন ক্ষমা কৰোঁতা, তথাপি তেওঁ অৱশ্যে দোষীক নিৰ্দ্দোষী নকৰে আৰু তৃতীয় চতুৰ্থ পুৰুষলৈকে সন্তান সকলক পিতৃসকলৰ অপৰাধৰ প্ৰতিফল দিওঁতা, ");
INSERT INTO asmfb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","তুমি এই কথা কোৱামতে প্ৰভুৰ মহৎ প্ৰভাৱ দেখা যাওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","বিনয় কৰোঁ, তুমি মিচৰ দেশৰ পৰা এতিয়ালৈকে এই লোকসকলক যেনেকৈ ক্ষমা কৰি আহিছা, তেনেকৈ তোমাৰ মহৎ কৃপাৰ দৰে তেওঁলোকৰ এই অপৰাধ ক্ষমা কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","তেতিয়া যিহোৱাই ক’লে, “তোমাৰ বাক্যমতে মই তেওঁলোকক ক্ষমা কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","তথাপি মই যদি সঁচাকৈ জীৱন্ত ঈশ্বৰ হওঁ আৰু গোটেই পৃথিৱী যদি যিহোৱাৰ প্ৰতাপেৰে পৰিপূৰ্ণ হয়, ");
INSERT INTO asmfb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","তেন্তে তেওঁলোকৰ মাজত যিমান লোকে মোৰ প্ৰতাপ আৰু মিচৰত ও মৰুভূমিত দেখুউৱা মোৰ চিন দেখিও, এই দহবাৰ মোক পৰীক্ষা কৰিছে আৰু মোৰ বাক্যলৈ কাণ নকৰা হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","তেওঁলোকৰ পূৰ্বপুৰুষ সকলক মই যি দেশ দিবলৈ শপত কৰিছিলোঁ, তেওঁলোকৰ কোনেও সেই দেশ দেখিবলৈ নাপাব, মোক হেয়জ্ঞান কৰা সকলৰ কোনেও তাক দেখা নাপাব, ");
INSERT INTO asmfb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","কিন্তু মোৰ দাস কালেবৰ মন বেলেগ, তেওঁ সম্পূৰ্ণকৈ মোৰ আজ্ঞামতে চলিলে; এতেকে কেৱল তেওঁ যি দেশত সোমাল, সেই দেশৰ ভিতৰলৈ মই তেওঁক নিম আৰু তেওঁৰ বংশই তাক অধিকাৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","অমালেকীয়া আৰু কনানীয়া লোকসকলে উপত্যকাত বাস কৰিছে; কাইলৈ তোমালোকে মুখ ঘূৰাই চূফ সাগৰৰ বাটেদি মৰুভূমিলৈ যাবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“মোৰ বিৰুদ্ধে নিন্দা কৰি থকা এই দুষ্ট সমাজৰ ভাৰ মই কিমান কাল সহিম? ইস্ৰায়েলৰ সন্তান সকলে মোৰ বিৰুদ্ধে যি যি বকিছিল, তাক মই শুনিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","তুমি তেওঁলোকক কোৱা, যিহোৱাই এই কথা কৈছে, ‘মোৰ জীৱনৰ শপত’, ‘তোমালোকে মোৰ কাণত যি ক’লা, অৱশ্যে মই তোমালোকলৈ তাক কৰিম ");
INSERT INTO asmfb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","তোমালোকৰ সম্পূৰ্ণ সংখ্যা অনুসাৰে গণিত হোৱা বিশ বছৰ আৰু তাতকৈয়ো অধিক বয়সীয়া তোমালোকৰ যি সকলো লোকে মোৰ অহিতে বকিছিল, তোমালোকৰ সেই সকলোৰ শৱ এই মৰুভূমিত পতিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","মই তোমালোকক যি দেশত বাস কৰাবলৈ শপত কৰিছিলোঁ, সেই দেশত তোমালোকে সোমাবলৈ নাপাবা; কেৱল যিফুন্নিৰ পুত্ৰ কালেব আৰু নুনৰ পুত্ৰ যিহোচূৱা সোমাব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","কিন্তু তোমালোকে নিজৰ যি ল’ৰা-ছোৱালীবোৰৰ বিষয়ে লুটদ্ৰব্য হ’ব বুলি কৈছিলা, মই তেওঁলোকক তাত সোমোৱাম; আৰু তোমালোকে যি দেশ অগ্ৰাহ্য কৰিলা, তেওঁলোকে তাৰ পৰিচয় পাব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","কিন্তু তোমালোকৰ বিষয়ে হ’লে, তোমালোকৰ শৱ এই মৰুভূমিত পতিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","আৰু তোমালোকৰ সন্তান সকলে চল্লিশ বছৰ এই মৰুভূমিত ভ্ৰমি ফুৰি, মৰুভূমিত তোমালোকৰ শৱৰ সংখ্যা পূৰ নহয়মানলৈকে তোমালোকৰ ব্যভিচাৰৰ ফল সিহঁতে ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","তোমালোকে যি চল্লিশ দিন দেশ চাই ফুৰিছিলা সেই দিনৰ লেখ অনুসাৰে চল্লিশ বছৰ অৰ্থাৎ এক এক বছৰ তোমালোকে নিজ নিজ অপৰাধৰ ফল ভোগ কৰিবা; আৰু মোৰ বিপক্ষতা কেনে তাক জানিবলৈ পাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","মই যিহোৱাই ইয়াক ক’লোঁ। মোৰ বিপৰীতে গোট খোৱা এই গোটেই দুষ্ট সমাজলৈ মই ইয়াক অৱশ্যে কৰিম; এই অৰণ্যত তেওঁলোক নিচেইকৈ বিনষ্ট হ’ব, এই ঠাইতে তেওঁলোক মৰিব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","পাছত দেশ চাবলৈ মোচিয়ে পঠোৱা যি লোকসকলে উলটি আহি সেই দেশৰ কুযশ কৰি তেওঁৰ অহিতে গোটেই সমাজক বকাইছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","দেশৰ কুযশ কৰা সেই লোকসকল যিহোৱাৰ আগত মহামাৰীৰ দ্বাৰাই মৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","দেশ চাবলৈ যোৱা সেই লোক সকলৰ মাজত কেৱল নুনৰ পুত্ৰ যিহোচূৱা আৰু যিফুন্নিৰ পুত্ৰ কালেব জীয়াই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","মোচিয়ে ইস্ৰায়েলৰ সন্তান সকলক সেই সকলো কথা যেতিয়া জনালে, লোকসকলে অতিশয় শোক কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","পাছত তেওঁলোকে ৰাতিপুৱাতে ওলাই পৰ্ব্বতৰ টিঙলৈ উঠিবলৈ উদ্যত হৈ ক’লে, “চোৱা, এইয়া আমি আছোঁ, যিহোৱাই যি ঠাইৰ বিষয়ে প্ৰতিজ্ঞা কৰিছিল, আমি সেই ঠাইলৈ যাওঁ; কিয়নো আমি পাপ কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","তাতে মোচিয়ে ক’লে, এতিয়া যিহোৱাৰ আজ্ঞা কিয় লঙ্ঘন কৰিছা? তোমালোকৰ সেই কাৰ্য সাম্ফল নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","তোমালোকে উঠি নাযাবা, কাৰণ যিহোৱা তোমালোকৰ মাজত নাই; গ’লে শত্ৰুৰ আগত পৰাজয় হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","কিয়নো অমালেকীয়া আৰু কনানীয়া লোকসকল সেই ঠাইত তোমালোকৰ আগত আছে আৰু তোমালোক তৰোৱালৰ ধাৰত পতিত হ’বা। তোমালোক যিহোৱাৰ পাছত চলিবলৈ বিমুখ হোৱাত যিহোৱা তোমালোকৰ লগত নাথাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","তথাপি তেওঁলোকে কুসাহ কৰি, পৰ্ব্বতৰ টিঙলৈ উঠি গ’ল; কিন্তু যিহোৱাৰ নিয়ম চন্দুক আৰু মোচি ছাউনিৰ পৰা নগ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","তেতিয়া সেই পৰ্ব্বতত থকা অমালেকীয়া আৰু কনানীয়া লোকসকল নামি আহি তেওঁলোকৰ কিছুমানক বধ কৰিলে, আৰু হৰ্মালৈকে তেওঁলোকক আঘাত কৰি কৰি খেদিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","পাছত যিহোৱাই মোচিক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, তেওঁলোকক এই আজ্ঞা দিয়া, ‘মই তোমালোকক যি দেশ দিম, তোমালোকে বসতি কৰিব লগা সেই দেশত সোমোৱাৰ পাছত, ");
INSERT INTO asmfb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","যেতিয়া তোমালোকে প্ৰতিজ্ঞা সিদ্ধিৰ অৰ্থে বা নিজ ইচ্ছাৰে এনেই দিবৰ অৰ্থে নাইবা তোমালোকৰ পৰ্ব্বৰ দিনত, গৰু, কি মেৰ, কি মেৰ-ছাগৰ জাকৰ পৰা আনি যিহোৱাক সুঘ্ৰাণ দিবৰ কাৰণে, হোম-বলি বা মঙ্গলাৰ্থক বলি আদি অগ্নিকৃত উপহাৰ যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিবা, ");
INSERT INTO asmfb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","তেতিয়া যিহোৱাৰ উদ্দেশ্যে উপহাৰ উৎসৰ্গ কৰা লোকে হোম-বলি আৰু আন বলিৰ অৰ্থে দিয়া প্ৰত্যেক মেৰে সৈতে, হীনৰ চাৰিভাগৰ এভাগ এভাগ তেল মিহলোৱা মিহি আটাগুড়িৰ দহ ভাগৰ এভাগ ভক্ষ্য নৈবেদ্য আনিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","আৰু তুমি হীনৰ চাৰিভাগৰ এভাগ দ্ৰাক্ষাৰসৰ পেয় নৈবেদ্য যুগুত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","বা এটা মতা মেৰে সৈতে, তুমি যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে, হীনৰ তিনি ভাগৰ এভাগ তেল মিহলোৱা মিহি আটাগুড়ি দহ ভাগৰ দুভাগেৰে ভক্ষ্য নৈবেদ্য যুগুত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","আৰু পেয় নৈবেদ্যৰ বাবে হীনৰ তিনি ভাগৰ এভাগ দ্ৰাক্ষাৰস উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","আৰু যিহোৱাৰ অৰ্থে প্ৰতিজ্ঞা সিদ্ধ কৰিবলৈ, বা মঙ্গলাৰ্থক বলিৰ অৰ্থে যেতিয়া তুমি হোম বলি বা আন বলিস্বৰূপে দমৰা গৰু উৎসৰ্গ কৰিবা, ");
INSERT INTO asmfb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","তেতিয়া সেই দমৰাই সৈতে, হীনৰ আধা ভাগ তেল মিহলোৱা দহ ভাগৰ তিনি ভাগ মিহি আটাগুড়িৰ ভক্ষ্য নৈবেদ্য অনা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","আৰু পেয় নৈবেদ্যৰ অৰ্থে হীনৰ আধা ভাগ দ্ৰাক্ষাৰস আনিবা; সেয়ে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিয়া অগ্নিকৃত উপহাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","প্ৰত্যেক দমৰা নাইবা প্ৰত্যেক মতা মেৰ, বা প্ৰত্যেক মতা মেৰ পোৱালি; বা প্ৰত্যেক মেৰ-ছাগ পোৱালিৰ কাৰণে এইদৰে কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","তোমালোকে যিমান পশু উৎসৰ্গ কৰিবা, সেইবোৰৰ সংখ্যা অনুসাৰে প্ৰত্যেক পশুলৈ এইদৰে কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","স্বদেশীয় লোকসকলে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবৰ সময়ত, তেওঁলোক আটায়ে এই নিয়মৰ দৰে সেই সকলো যুগুত কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","আৰু তোমালোকৰ লগত প্ৰবাস কৰা কোনো বিদেশী লোকে, নাইবা তোমালোকৰ মাজত পুৰুষানুক্ৰমে বাস কৰা কোনো লোকে যদি যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণ দিবৰ অৰ্থে অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিব খোজে, তেন্তে তোমালোকে যেনেকৈ কৰা, তেৱোঁ তেনেকৈ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","সমাজৰ কাৰণে হ’লে, তোমালোক আৰু তোমালোকৰ মাজত প্ৰবাস কৰা বিদেশী লোক, উভয়ৰে একেটা বিধি হ’ব: এয়ে তোমালোকৰ পুৰুষানুক্ৰমে পালন কৰিবলগীয়া চিৰ স্থায়ী বিধি। যিহোৱাৰ আগত তোমালোক যেনে, বিদেশীও তেনে। ");
INSERT INTO asmfb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","তোমালোকৰ আৰু তোমালোকৰ মাজত প্ৰবাস কৰা বিদেশী, উভয়েৰে একে বিধি আৰু একে শাসন প্ৰণালী হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","পাছত যিহোৱাই মোচিক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, তেওঁলোকক এই আজ্ঞা দিয়া, ‘মই তোমালোকক যি দেশলৈ লৈ আহিছোঁ, সেই দেশত সোমোৱাৰ পাছত, ");
INSERT INTO asmfb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","তোমালোকে সেই দেশৰ অন্ন ভোজন কৰা কালত, যিহোৱাৰ উদ্দেশ্যে উত্তোলনীয় নৈবেদ্য উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","তোমালোকে প্ৰথমে উৎপন্ন হোৱা শস্যৰ খৰচীয়া আটাৰ এটা পিঠা উত্তোলনীয় নৈবেদ্যস্বৰূপে উৎসৰ্গ কৰিবা; মৰণা মৰা খোলাৰ উত্তোলনীয় নৈবেদ্যৰ নিচিনাকৈ ইয়াকো উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","তোমালোকে পুৰুষানুক্ৰমে প্ৰথমে উৎপন্ন হোৱা শস্যৰ নিজ নিজ খৰচিয়া আটাৰ কিছু উত্তোলনীয় নৈবেদ্যস্বৰূপে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","মোচিক যিহোৱাই কোৱা এই সকলো আজ্ঞা, তোমালোক ইস্রায়েলৰ সন্তান সকলে পালন কৰা নাছিলা, যদিওবা পালন নকৰিবলৈ তোমালোকৰ কোনো উদ্দেশ্য নাছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","অৰ্থাৎ যিহোৱাই যি দিনা তোমালোকক আজ্ঞা দিছিল, সেই দিনাৰ পৰা তোমালোকৰ পুৰুষানুক্ৰমে তেওঁ মোচিৰ দ্বাৰাই যি যি আজ্ঞা কৰিছিল, সেই সকলোকে যেতিয়া তোমালোকে ভূলক্ৰমে পালন নকৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","তেতিয়া সেয়ে যদি সমাজে নজনাকৈ ভূলক্ৰমে কৰা হয়, তেন্তে গোটেই সমাজে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে হোমৰ কাৰণে এটা দমৰা আৰু নিয়ম মতে তাৰ ভক্ষ্য আৰু পেয় নৈবেদ্য আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা মেৰ-ছাগ উৎসৰ্গ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","আৰু পুৰোহিতে ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই প্ৰায়শ্চিত্ত কৰিব; তাতে তেওঁলোকক ক্ষমা কৰা হ’ব। কিয়নো তাক ভূলক্ৰমে কৰা হ’ল আৰু তেওঁলোকে সেই ভূলৰ কাৰণে যিহোৱাৰ উদ্দেশ্যে তেওঁলোকৰ উপহাৰ, তেওঁলোকৰ অগ্নিকৃত উপহাৰ আনিলে আৰু যিহোৱাৰ উদ্দেশ্যে তেওঁলোকৰ পাপাৰ্থক বলিও আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","এইদৰে ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই সমাজক আৰু তেওঁলোকৰ মাজত প্ৰবাস কৰা বিদেশীক ক্ষমা কৰা হ’ব; কিয়নো সকলো লোকৰ সম্পৰ্কে সেই কাৰ্য ভূলক্ৰমে কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","আৰু যদি কোনো মানুহে ভূলক্ৰমে পাপ কৰে, তেন্তে, সি পাপাৰ্থক বলিস্বৰূপে এজনী এবছৰীয়া মেৰ-ছাগ উৎসৰ্গ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","আৰু যিহোৱাৰ সাক্ষাতে সেই লোকে ভূলক্ৰমে পাপ কৰাত, সেই ভূল কৰা লোকক প্ৰায়শ্চিত্ত কৰিবলৈ পুৰোহিতে তেওঁৰ বাবে প্ৰায়শ্চিত্ত কাৰ্য কৰিব; তাতে তেওঁক ক্ষমা কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ইস্ৰায়েলৰ সন্তান সকলৰ স্বজাতীয় বা তেওঁলোকৰ মাজত প্ৰাবস কৰা বিদেশী হওঁক উভয়ৰে বাবে, ভূলক্ৰমে কোনো কাৰ্য কৰা লোকৰ অৰ্থে একেটা বিধি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","কিন্তু স্বদেশীয় কি বিদেশীয় যি লোকে কৰোঁ বুলি পাপ কৰিব, তেওঁ যিহোৱাক অপমান কৰা হ’ব; সেই লোকক নিজ লোকসকলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","কিয়নো তেওঁ যিহোৱাৰ বাক্য হেয়জ্ঞান কৰিলে আৰু তেওঁৰ আজ্ঞা লঙ্ঘন কৰিলে; অৱশ্যে সেই মানুহক উচ্ছন্ন কৰা হ’ব আৰু তাৰ দোষ তাৰ গাতে থাকিব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ইস্ৰায়েলৰ সন্তান সকল যেতিয়া মৰুভূমিত আছিল, তেতিয়া তেওঁলোকে বিশ্ৰাম দিনত এজনক খৰি বুটলা পালে। ");
INSERT INTO asmfb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","আৰু যিসকলে তেওঁক খৰি বুটলা পাইছিল, তেওঁলোকে মোচি, হাৰোণ আৰু গোটেই সমাজৰ আগলৈ তেওঁক আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","আৰু তেওঁলোকে তেওঁক বন্ধ কৰি ৰাখিলে; কিয়নো তেওঁলৈ কি কৰা উচিত, সেয়ে ঠিককৈ প্ৰকাশিত হোৱা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","পাছত যিহোৱাই মোচিক ক’লে, “সেই মানুহৰ প্ৰাণদণ্ড অৱশ্যে হ’ব লাগে; গোটেই সমাজে তাক ছাউনিৰ বাহিৰলৈ নি শিল দলিয়াই বধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","তেতিয়া, যিহোৱাই মোচিক আজ্ঞা দিয়াৰ দৰে, গোটেই সমাজে তেওঁক ছাউনিৰ বাহিৰলৈ লৈ গৈ, তেওঁ মৰাকৈ, তেওঁলৈ শিল দলিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","পাছত যিহোৱাই আকৌ মোচিক ক’লে। তেওঁ ক’লে ");
INSERT INTO asmfb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, তেওঁলোকক এই আজ্ঞা দিয়া; তেওঁলোকে পুৰুষানুক্ৰমে নিজ নিজ কাপোৰৰ চুকত আৰিবলৈ সূতাৰ থোপা সাজক আৰু নিজ নিজ কাপোৰৰ চুকত লগাব লগীয়া থোপাত নীল বৰণীয়া ফিতা লগাওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","তোমালোকে যেন সেই থোপা দেখি, যিহোৱাৰ আজ্ঞাবোৰ সোঁৱৰণ কৰি পালন কৰা আৰু নিজৰ যি মন আৰু চকুৰ পাছত চলি তোমালোকে ব্যভিচাৰী হৈছিলা, সেই মন আৰু চকুৰ পাছত যেন আৰু নচলা। ");
INSERT INTO asmfb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","কিন্তু মোৰ সকলো আজ্ঞা সোঁৱৰি পালন কৰি, নিজ ঈশ্বৰৰ উদ্দেশ্যে যেন পবিত্ৰ হোৱা, এই কাৰণে তোমালোকলৈ সেই থোপা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","তোমালোকৰ ঈশ্বৰ যিহোৱা হ’বৰ কাৰণে, যিজন সৰ্বশক্তিমান ঈশ্বৰে তোমালোকক মিচৰ দেশৰ পৰা উলিয়াই আনিলে, ময়েই তোমালোকৰ সেই ঈশ্বৰ যিহোৱা; মই তোমালোকৰ ঈশ্বৰ যিহোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","পাছত লেবীৰ পৰিনাতি, কহাতৰ নাতিয়েক, যিচহৰৰ পুতেক কোৰহ আৰু ৰূবেণৰ সন্তান সকলৰ মাজৰ, ইলিয়াবৰ পুতেক দাথন আৰু অবীৰাম আৰু পেলতৰ পুতেক ওনে, এওঁলোকে কিছুমান লোকক গোটাই ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ দুশ পঞ্চাশজন মণ্ডলীৰ অধ্যক্ষ আৰু সমাজ ভূক্ত নাম জ্বলা লোকক লগত লৈ, মোচিৰ বিৰুদ্ধে উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","তেওঁলোকে মোচি আৰু হাৰোণৰ বিৰুদ্ধে গোট খাই তেওঁলোকক ক’লে, “তোমালোকে তোমালোকৰ পদ বৰ বুলি মানিছা। কিয়নো গোটেই সমাজৰ প্ৰতিজনেই পবিত্ৰ আৰু যিহোৱা তেওঁলোকৰ মাজত আছে; তেন্তে তোমালোকে কিয় যিহোৱাৰ সমাজৰ ওপৰত নিজকে ওখ কৰিছা?” ");
INSERT INTO asmfb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","যেতিয়া মোচিয়ে সেই কথা শুনিলে, তেওঁ উবুৰি হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","আৰু তেওঁ কোৰহক আৰু তেওঁৰ গোটেই দলটোক ক’লে, “যিহোৱাৰ লোক কোন আৰু কোন পবিত্ৰ, যিহোৱাই তাক ৰাতিপুৱাই জনাব আৰু তাক নিজৰ ওচৰ চপাব; তেওঁ যিজনক মনোনীত কৰিব, তেওঁকেই নিজৰ ওচৰ চপাব। ");
INSERT INTO asmfb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","হে কোৰহ আৰু তোমাৰ গোটেই দল, এই কাম কৰা; ধূপাধাৰ লোৱা ");
INSERT INTO asmfb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","তোমালোকে আঙঠা-ধৰালৈ, তাত জুই দি কাইলৈ যিহোৱাৰ আগত তাৰ ওপৰত ধূপ দিবা। তাতে যিহোৱাই তেওঁক মনোনীত কৰিব, সেইজনেই পবিত্ৰ হ’ব। হে লেবীয়া সন্তান সকল, তোমালোকে নিজকে বৰ বুলি মানিছা। ");
INSERT INTO asmfb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","পাছত মোচিয়ে কোৰহক ক’লে, হে লেবীৰ সন্তান সকল, মোৰ কথা শুনা: ");
INSERT INTO asmfb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ইস্ৰায়েলৰ ঈশ্বৰে যে তোমালোকক ইস্ৰায়েলৰ সমাজৰ পৰা পৃথক কৰি, যিহোৱাৰ আবাসৰ সেৱাকৰ্ম কৰিবলৈ আৰু মণ্ডলীৰ আগত থিয় হৈ তাৰ পৰিচৰ্যা কৰিবলৈ নিজৰ ওচৰ চপাই ৰাখিছে, ই জানো তোমালোকৰ মানত সৰু কথা? ");
INSERT INTO asmfb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","তেওঁ তোমাক, আৰু তোমাৰে সৈতে তোমাৰ ভাই লেবীৰ সন্তান সকলক নিজৰ ওচৰ চপাই ৰাখিছে, তথাপি তোমালোকে পুৰোহিতৰ বাবলৈকো চেষ্টা কৰিছা নে! ");
INSERT INTO asmfb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","সেইবাবে তুমি আৰু তোমাৰ গোটেই দলে যিহোৱাৰ বিৰুদ্ধে গোট খাইছা। গতিকে কিয় তোমালোকে হাৰোণৰ বিৰুদ্ধে আপত্তি কৰিছা, যিজনে যিহোৱাক মানি চলে?” ");
INSERT INTO asmfb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","তেতিয়া মোচিয়ে ইলিয়াবৰ পুতেক দাথনক আৰু অবীৰামক মাতিবলৈ মানুহ পঠালে, কিন্তু তেওঁলোকে ক’লে, আমি নাযাওঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","তুমি আমাক মৰুভূমিত মাৰিবলৈ দুগ্ধমধু বোৱা দেশৰ পৰা আনিছা, এয়ে জানো সৰু কথা? তুমি সদায় আমাৰ ওপৰত অধিকাৰ কৰি থাকিবানে? ");
INSERT INTO asmfb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","কেৱল এয়ে নহয়, তুমি আমাক দুগ্ধমধু বোৱা দেশলৈ নিয়া নাই আৰু শস্যৰ খেতি ও দ্ৰাক্ষাবাৰীৰো অধিকাৰ দিয়া নাই। তুমি এই লোকসকলক অন্ধ কৰিবা নে? আমি নাযাওঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","তাতে মোচিয়ে অতিশয় ক্ৰুদ্ধ হৈ যিহোৱাক জনালে, বোলে, “এওঁলোকৰ উপহাৰ গ্ৰহণ নকৰিবা; মই এওঁলোকৰ পৰা এটা গাধও লোৱা নাই, আৰু এওঁলোকৰ এজনকো দুখ দিয়া নাই।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","পাছত মোচিয়ে কোৰহক ক’লে, “তুমি আৰু তোমাৰ গোটেই দল কাইলৈ হাৰোণে সৈতে যিহোৱাৰ আগত উপস্থিত হ’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","তোমালোকে প্ৰতিজনে আঙঠা-ধৰালৈ তাৰ ওপৰত ধূপ দি, নিজ নিজ আঙঠা-ধৰা যিহোৱাৰ আগত লৈ আনিবা। দুশ পঞ্চাশ আঙঠা-ধৰাই আগ কৰিবা; তুমি আৰু হাৰোণেও নিজ নিজ আঙঠা-ধৰা ল’বা।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","পাছত তেওঁলোক প্ৰতিজনে নিজ নিজ আঙঠা-ধৰা লৈ, তাৰ ওপৰত জুই ৰাখি, ধূপ দি, মোচি আৰু হাৰোণৰ লগত সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","আৰু কোৰহে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰৰ ওচৰত তেওঁলোকৰ অহিতে গোটেই সমাজকে গোট খুৱালে; তেতিয়া যিহোৱাৰ প্ৰতাপ গোটেই সমাজলৈ প্ৰকাশিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“তোমালোক এই সমাজৰ মাজৰ পৰা বেলেগ হোৱা, মই এক নিমিষতে এওঁলোকক সংহাৰ কৰোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","তেতিয়া তেওঁলোকে উবুৰি হৈ পৰি ক’লে, “হে ঈশ্বৰ, এজনে পাপ কৰাত তোমাৰ কুপ জানো গোটেই সমাজৰ ওপৰত হ’ব লাগে?” ");
INSERT INTO asmfb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","তেতিয়া যিহোৱাই মোচিক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“তুমি সমাজক কোৱা, ‘তোমালোক কোৰহ, দাথন আৰু অবীৰামৰ বসতিৰ ঠাইৰ চাৰিওফালৰ পৰা গুচি যোৱা’।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","তেতিয়া মোচি উঠি দাথন আৰু অবীৰামৰ ওচৰলৈ গ’ল; আৰু ইস্ৰায়েলৰ বৃদ্ধসকলে তেওঁৰ পাছে পাছে গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","তেওঁ সমাজক ক’লে, “বিনয় কৰোঁ, তোমালোকে এই দুষ্ট লোকসকলৰ তম্বুৰ ওচৰৰ পৰা আঁতৰি যোৱা, আৰু এওঁলোকৰ একো বস্তু নুচুবা; নহ’লে এওঁলোকৰ পাপ সমূহত বিনষ্ট হ’বা।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","তেতিয়া তেওঁলোকে কোৰহ, দাথন আৰু অবীৰামৰ বসতিৰ ঠাইৰ চাৰিওফালৰ পৰা আঁতৰি গ’ল, কিন্তু দাথন আৰু অবীৰাম ওলাই নিজ নিজ ল’ৰা-তিৰোতাই সৈতে নিজ নিজ দুৱাৰমুখত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","পাছত মোচিয়ে কলে, এই সকলো কাৰ্য কৰিবলৈ মোক যে, যিহোৱাই পঠালে, তাক ইয়াৰ দ্বাৰাই জানিবলৈ পাবা। কিয়নো মই নিজ ইচ্ছাৰে তাক কৰা নাই। ");
INSERT INTO asmfb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","আন লোক সমূহ যি মৰণেৰে মৰে, এই মানুহ যদি তেনে মৰণেৰে মৰে বা লোকসমূহলৈ যেনে আপদ ঘটে, এই লোক সমূহৰ প্ৰতিও যদি তেনে আপদ ঘটে, তেন্তে যিহোৱাই মোক পঠোৱা নাই। ");
INSERT INTO asmfb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","কিন্তু যিহোৱাই যদি নতুন কাৰ্য কৰে, আৰু যদি পৃথিৱীয়ে নিজ মুখ মেলি ইহঁতক, আৰু ইহঁতৰ সকলোকে গ্ৰাস কৰে, আৰু ইহঁত জীয়াই জীয়াই চিয়োললৈ নামি যায়, তেন্তে এওঁলোকে যে যিহোৱাক হেয়জ্ঞান কৰিলে, তাক তোমালোকে জানিবলৈ পাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","পাছত মোচিয়ে এইবোৰ কথা কৈ শেষ কৰা মাত্ৰকে, তেওঁলোকৰ তলত থকা মাটি ফাটিল, ");
INSERT INTO asmfb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","আৰু পৃথিৱীয়ে নিজ মুখ মেলি তেওঁলোকক আৰু তেওঁলোকৰ পৰিয়ালবোৰক আৰু কোৰহৰ আটাই লোকক আৰু তেওঁলোকৰ সৰ্ব্বস্ব গ্ৰাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","এইদৰে তেওঁলোক আৰু তেওঁলোকৰ লগৰ সকলোৱেই জীয়াই জীয়াই চিয়োললৈ নামি গ’ল; আৰু পৃথিৱী তেওঁলোকৰ ওপৰত জাপ খাই পৰিলত, তেওঁলোক সমাজৰ মাজৰ পৰা লুপ্ত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","তেওঁলোকৰ চাৰিওফালে থকা গোটেই ইস্ৰায়েলে তেওঁলোকৰ চিঞঁৰ শুনি পলাল। কিয়নো তেওঁলোকে আৱেগিক হৈ কৈছিল, “পৃথিৱীয়ে কিজানি আমাকো গ্ৰাস কৰিব!” ");
INSERT INTO asmfb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","তেতিয়া যিহোৱাৰ পৰা অগ্নি ওলাই ধূপ উৎসৰ্গ কৰা সেই দুশ পঞ্চাশ জনক গ্ৰাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","আকৌ যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“তুমি হাৰোণৰ পুত্ৰ ইলিয়াজৰ পুৰোহিতক অগ্নিয়ে গ্ৰাস কৰা ঠাইৰ পৰা এই সকলো আঙঠা ধৰা তুলি নিবলৈ আৰু তাৰ জুই দূৰৈত সিচঁৰিত কৰি পেলাই দিবলৈ কোৱা; কিয়নো সেইবোৰ আঙঠা ধৰা পবিত্ৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","নিজৰ প্ৰাণৰ বিৰুদ্ধে পাপ কৰা সেই লোকসকলৰ আঙঠা ধৰাবোৰ পিতাই যজ্ঞবেদী ঢাকিবৰ বাবে লোকসকলে পতা কৰক; কিয়নো তেওঁলোকে সেইবোৰ যিহোৱাৰ আগত উৎসৰ্গ কৰিলে; এইহেতুকে সেইবোৰ পবিত্ৰ; আৰু সেইবোৰ ইস্ৰায়েলৰ সন্তান সকললৈ চিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","তাতে সেই গ্ৰাসিত লোকসকলে উৎসৰ্গ কৰা পিতলৰ আঙঠা ধৰাবোৰ ইলিয়াজৰ পুৰোহিতে নিলে, ");
INSERT INTO asmfb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","আৰু মোচিৰ দ্বাৰাই যিহোৱাই দিয়া আজ্ঞা অনুসাৰে, ইস্ৰায়েলৰ সন্তান সকলৰ সোঁৱৰণৰ অৰ্থে, অৰ্থাৎ হাৰোণৰ বংশৰ বাহিৰে আন বংশৰ কোনো মানুহ যেন যিহোৱাৰ আগত ধূপ উৎসৰ্গ কৰিবৰ নিমিত্তে ওচৰ নাচাপে আৰু কোৰহৰ ও তাৰ দলৰ দৰে নহয়, এই কাৰণে সেইবোৰ পিতাই যজ্ঞবেদীৰ ঢাকনিৰ অৰ্থে পতা কৰা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","তথাপি পাছদিনা ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই সমাজে মোচি আৰু হাৰোণৰ বিৰুদ্ধে বকি ক’লে, “তোমালোকেই যিহোৱাৰ প্ৰজাসকলক বধ কৰিলা।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","তেতিয়া মোচি আৰু হাৰোণৰ বিৰুদ্ধে গোট খালত, তেওঁলোকে সাক্ষাৎ কৰা তম্বুলৈ মুখ ঘূৰাই দেখিলে, যে, মেঘে তাক ঢাকিছে আৰু যিহোৱাৰ প্ৰতাপ প্ৰকাশিত হৈছে। ");
INSERT INTO asmfb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","তেতিয়া মোচি আৰু হাৰোণ সাক্ষাৎ কৰা তম্বুৰ আগলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","তেতিয়া যিহোৱাই মোচিক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“তোমালোকে এই সমাজৰ মাজৰ পৰা আঁতৰি যোৱা, মই এক নিমিষতে এওঁলোকক সংহাৰ কৰোঁ।” তেতিয়া তেওঁলোক উবুৰি হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","মোচিয়ে হাৰোণক ক’লে, “তোমাৰ আঙঠা ধৰা লোৱা আৰু যজ্ঞবেদীৰ ওপৰৰ পৰা জুই লৈ তাত ধূপ দি, শীঘ্ৰে সমাজৰ গুৰিলৈ লৈ যোৱা আৰু তেওঁলোকক প্ৰায়শ্চিত্ত কৰা; কিয়নো যিহোৱাৰ আগৰ পৰা ক্ৰোধ বাহিৰ হোৱাত মহামাৰী আৰম্ভ হ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","গতিকে হাৰোণে মোচিৰ আজ্ঞা অনুসাৰে আঙঠা ধৰা লৈ, সমাজৰ মাজলৈ লৰি গ’ল। তেতিয়া চোৱা, তেওঁলোকৰ মাজত মহামাৰী আৰম্ভ হৈছে, তেতিয়া তেওঁ ধূপ দি লোকসকলক প্ৰায়শ্চিত্ত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","আৰু মৰা ও জীয়া লোকসকলৰ মাজত তেওঁ থিয় হোৱাত, মহামাৰী নিবাৰণ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","যিসকল লোক কোৰহৰ দোষত মৰিছিল, সেইসকলৰ বাহিৰে চৌদ্ধ হাজাৰ সাত শ লোক এই মহামাৰীত মৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","মহামাৰী নিবাৰণ হোৱাৰ পাছত, হাৰোণ সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখলৈ মোচিৰ গুৰিলৈ উলটি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","যিহোৱাই মোচিক ক’লে। তেওঁ ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক কথা কোৱা। তেওঁলোকৰ পিতৃ-বংশৰ অধ্যক্ষসকলৰ পৰা এক এক পিতৃ-বংশৰ কাৰণে এডালকৈ লাখুটি, এইদৰে বাৰডাল লাখুটি লোৱা আৰু প্ৰত্যেকৰ লাখুটিত তেওঁৰ নাম লিখা। ");
INSERT INTO asmfb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","আৰু লেবীৰ লাখুটিত হাৰোণৰ নাম লিখা। কিয়নো তেওঁলোকৰ প্ৰত্যেক পিতৃ-বংশৰ মুখ্যলোকৰ বাবে এডালকৈ লাখুটি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","আৰু সাক্ষাৎ কৰা তম্বুত যি ঠাইত মই তোমালোকেৰে সৈতে সাক্ষাৎ হওঁ, সেই ঠাইতে সাক্ষ্য-ফলিৰ চন্দুকৰ আগত সেই সকলোকে থবা। ");
INSERT INTO asmfb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","পাছত মোৰ মনোনীত লোকৰ লাখুটিত কলি ধৰিব। তাতে ইস্ৰায়েলৰ সন্তান সকলে তোমালোকৰ বিৰুদ্ধে বকা বকনি মোৰ ওচৰৰ পৰা মই দূৰ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","পাছত মোচিয়ে ইস্ৰায়েলৰ সন্তানসকলক এই কথাবোৰ ক’লে। তেওঁলোকৰ অধ্যক্ষসকলৰ প্ৰতিজনে নিজ নিজ পিতৃ-বংশৰ বাবে এডালকৈ লাখুটি, এইদৰে বাৰডাল লাখুটি তেওঁক দিলে। আৰু হাৰোণৰ লাখুটি তেওঁলোকৰ লাখুটিবোৰৰ মাজত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","তাতে মোচিয়ে সেই সকলো লাখুটি লৈ, সাক্ষ্য-ফলি থকা তম্বুত যিহোৱাৰ আগত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","আৰু পাছদিনা মোচিয়ে সাক্ষ্য-ফলি থকা তম্বুত সোমাই দেখিলে, যে, লেবী বংশৰ নিমিত্তে লোৱা হাৰোণৰ লাখুটিত কুঁহি ওলাই কলি ধৰি ফুলিল, আৰু বাদামৰ পকা গুটি লাগিল। ");
INSERT INTO asmfb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","তেতিয়া মোচিয়ে যিহোৱাৰ সন্মূখৰ পৰা সেই সকলো লাখুটি উলিয়াই ইস্ৰায়েলৰ সন্তানসকলৰ আগলৈ আনিলে, আৰু তেওঁবিলাক প্ৰতিজনে চাই চাই নিজ নিজ লাখুটি ললে। ");
INSERT INTO asmfb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","পাছে যিহোৱাই মোচিক কলে, এই বিদ্ৰোহ আচৰণ কৰা সন্তান সকলৰ বিৰুদ্ধে চিন থাকিবৰ কাৰণে তুমি হাৰোণৰ লাখুটিডাল পুনৰায় সাক্ষ্য-ফলিৰ চম্দুকৰ আগত ৰাখা; তাতে, তেওঁলোক নমৰিবৰ বাবে, মোৰ বিৰুদ্ধে হোৱা তেওঁলোকৰ বকনি নাইকিয়া কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","তেতিয়া মোচিয়ে সেইদৰেই কৰিলে; যিহোৱাই আজ্ঞা দিয়াৰ দৰেই তেওঁ কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","পাছে ইস্ৰায়েলৰ সন্তান সকলে মোচিক কলে, চাওঁক, আমি মৰিলোঁ, আমি বিনষ্ট হলোঁ, আমি সকলোৱেই বিনষ্ট হলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","যি কোনো লোক ওচৰ চাপে, যি কোনো লোক যিহোৱাৰ আবাসৰ ওচৰ চাপে, তেৱেঁই মৰা পৰে, আমি সকলোৱেই মৰা পৰিম নেকি? ");
INSERT INTO asmfb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","যিহোৱাই হাৰোণক ক’লে, “তুমি আৰু তোমাৰে সৈতে তোমাৰ পিতৃ-বংশই পবিত্ৰ স্থানত হোৱা অপৰাধৰ ভাৰ ববা। আৰু তুমিও তোমাৰে সৈতে তোমাৰ পুত্ৰসকলে পুৰোহিত পদত হোৱা অপৰাধৰ ভাৰ ববা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","আৰু তোমাৰ ভাই লেবী ফৈদ, অৰ্থাৎ তোমাৰ পিতৃ ফৈদক লগত আনিবা; তেওঁলোকে তোমাৰ লগ লৈ, তোমাৰ পৰিচৰ্যা কৰিব লাগে, কিন্তু তুমি আৰু তোমাৰে সৈতে তোমাৰ পুত্ৰসকলে সাক্ষ্য-ফলি থকা তম্বুৰ আগত থাকিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","তেওঁলোকে তোমাৰ আৰু গোটেই তম্বুৰ কৰিব লগীয়া কাৰ্য কৰিব। কিন্তু তেওঁলোক আৰু তোমালোক নমৰিবৰ বাবে, তেওঁলোক পবিত্ৰ স্থানৰ বস্তুৰ আৰু যজ্ঞবেদীৰ ওচৰলৈ নাযাব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","তেওঁলোকে তোমাৰ লগ লৈ সাক্ষাৎ কৰা তম্বুৰ আটাই দাস্যকৰ্মৰ সম্বন্ধে যি কৰিব লাগে, অৰ্থাৎ কৰিব লগীয়া তম্বুৰ সেই কাৰ্য কৰিব আৰু আন বংশৰ কোনো মানুহ তোমালোকৰ ওচৰ নাচাপিব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ইস্ৰায়েলৰ সন্তান সকললৈ মোৰ যেন আৰু ক্ৰোধ নহয়, এই কাৰণে তোমালোকে পবিত্ৰ স্থানৰ আৰু যজ্ঞবেদীৰ কৰিব লগীয়া কাৰ্য কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","আৰু চোৱা, মই ময়েই তোমালোকৰ ভাই লেবীয়াসকলক ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা গ্ৰহণ কৰিলোঁ। সাক্ষাৎ কৰা তম্বুৰ সেৱাকৰ্ম কৰিবৰ অৰ্থে, যিহোৱাৰ উদ্দেশ্যে তেওঁলোকক তোমালোকলৈ দান দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","এই হেতুকে তুমি আৰু তোমাৰে সৈতে তোমাৰ পুত্ৰসকলে যজ্ঞবেদী সম্বন্ধীয় সকলো বিষয়ত আৰু প্ৰভেদক বস্ত্ৰৰ ভিতৰৰ সকলো বিষয়ত নিজ নিজ পুৰোহিত পদৰ কৰিবলগীয়া কাৰ্য কৰিবা, তোমালোকে নিজেই সেৱাকৰ্ম সকলো কাম সমাধা কৰিবা, মই দান স্বৰূপেই পুৰোহিত পদৰ কাৰ্য তোমালোকক দিলোঁ। কিন্তু আন বংশৰ যি কোনো লোক ওচৰ চাপিলে, তেওঁৰ প্ৰাণদণ্ড হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","পাছত যিহোৱাই হাৰোণক ক’লে, “চোৱা, মোৰ উত্তোলনীয় নৈবেদ্য অৰ্থাৎ ইস্ৰায়েলৰ সন্তানসকলৰ সকলো পবিত্ৰীকৃত বস্তুৰ মাজৰ পৰা অনা মোৰ উত্তোলনীয় নৈবেদ্যবোৰ পৰিচালনা কৰিবলৈ দিলোঁ। মই তোমাক আৰু তোমাৰ পুত্ৰসকলক এক অংশ স্বৰূপে সেই সকলোকে তোমালোকক দিলোঁ তোমালোকে সেইবোৰ পাবলৈ চিৰস্থায়ী বিধি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","অগ্নিত নিদিয়াকৈ ৰখা অতি পবিত্ৰ বস্তুৰ মাজৰ এই আটাইবোৰ তোমাৰ হ’ব। মোৰ উদ্দেশ্যে অনা তেওঁলোকৰ প্ৰত্যেক ভক্ষ্য নৈবেদ্য, প্ৰত্যেক পাপাৰ্থক বলি আৰু প্ৰত্যেক দোষাৰ্থক বলি, এই সকলো অতি পবিত্র উপহাৰ তোমাৰ আৰু তোমাৰ পুত্ৰসকলৰ বাবে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","সেইবোৰ মোৰ বাবে সংৰক্ষিত অতি পবিত্ৰ বস্তু, তোমালোকে এইবোৰ নিশ্চয় খাবা। প্ৰতিজন পুৰুষে সেইবোৰ নিশ্চয় খাব লাগিব। সেইবোৰ মোৰ বাবে সংৰক্ষিত তোমাৰ পক্ষে পবিত্ৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","আৰু এইবোৰ তোমাৰ হ’ব: অৰ্থাৎ ইস্ৰায়েলৰ সন্তান সকলে দান দিয়া সকলো উত্তোলনীয় নৈবেদ্য আৰু তেওঁলোকৰ সকলো দোলনীয় নৈবেদ্য; চিৰকালৰ অধিকাৰৰ অৰ্থে মই তোমাৰ আৰু তোমাৰে সৈতে তোমাৰ পো-জীসকলক সেইবোৰ দিলোঁ; তোমাৰ বংশৰ সকলো শুচি লোকে সেইবোৰ ভোজন কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","তেওঁলোকে সকলো উত্তম তেল, উত্তম দ্ৰাক্ষা ৰস আৰু শস্য আদিৰ যি যি আগভাগ যিহোৱাৰ উদ্দেশ্যে দিব, সেইবোৰ মই তোমাক দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","তেওঁলোকৰ ভূমিত উৎপন্ন হোৱা ফল আদিৰ প্ৰথমে পকা যি ভাগ তেওঁলোকে যিহোৱাৰ উদ্দেশ্যে আনিব, সেয়ো তোমাৰেই হ’ব। তোমাৰ বংশৰ সকলো শুচিলোকে তাক ভোজন কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ইস্ৰায়েলৰ মাজত বৰ্জিত কৰি দিয়া সকলো বস্তু তোমাৰেই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","মানুহেই হওঁক বা পশুৱেই হওঁক, সকলো প্ৰাণীৰ মাজত গৰ্ভভেদ কৰি প্ৰথমে ওলোৱা যিবোৰক তেওঁলোকে যিহোৱাৰ অৰ্থে আগদান কৰিব, সেই সকলো তোমাৰেই হ’ব। কিন্তু মানুহৰ প্ৰথমে জন্মাক তুমি অৱশ্যে মোকলাই দিবা, আৰু অশুচি পশুৰ প্ৰথমে জন্মাকো তুমি মোকলাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","সেইবোৰৰ মাজৰ এমাহ বয়সৰে পৰা মোকলাই দিব লগা প্ৰতিজনক পবিত্ৰ স্থানৰ চেকল অনুসাৰে, তুমি নিৰূপণ কৰাৰ দৰে পাঁচ চেকল ৰূপলৈ মোকলাই দিবা; সেয়ে বিশ গেৰাই এক চেকল হয়। ");
INSERT INTO asmfb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","কিন্তু গৰুৰ বা মেৰ-ছাগৰ বা ছাগলীৰ প্ৰথমে জন্মাক তুমি মোকলাই নিদিবা। সেইবোৰ পবিত্ৰ আৰু মোৰ উদ্দেশ্যে পৃথকে ৰখা হ’ল। তুমি যজ্ঞবেদীৰ ওপৰত সেইবোৰৰ তেজ ছটিয়াবা আৰু যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে অগ্নিকৃত উপহাৰৰ কাৰণে সেইবোৰৰ তেল দগ্ধ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","সেইবোৰৰ মঙহ তোমাৰ হ’ব; দোলনীয় নৈবেদ্যৰ অৰ্থে দিয়া আমঠু আৰু সোঁ পাছ পিৰাটো যেনেকৈ তোমাৰ হয়, তেনেকৈ সেইবোৰৰ মঙহো তোমাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ইস্ৰায়েলৰ সন্তান সকলে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰা পবিত্ৰ বস্তুৰ মাজৰ আটাই উত্তোলনীয় নৈবেদ্য তোমাক আৰু তোমাৰে সৈতে তোমাৰ পো-জীসকলক চিৰ কালৰ অধিকাৰৰ অৰ্থে দিলোঁ; তোমাৰ আৰু তোমাৰ সৈতে তোমাৰ বংশৰ পক্ষে এয়ে যিহোৱাৰ সাক্ষাতে লোণৰ চিৰস্থায়ী নিয়মৰ চিন হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","পাছত যিহোৱাই হাৰোণক ক’লে, “ইস্রায়েলৰ সন্তান সকলৰ মাটিত তোমাৰ কোনো অধিকাৰ নাথাকিব, আৰু তেওঁলোকৰ মাজত তুমি কোনো ভাগ নাপাবা; ইস্ৰায়েলৰ সন্তানসকলৰ মাজত তোমাৰ ভাগ আৰু উত্তৰাধিককাৰ ময়েই। ");
INSERT INTO asmfb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","আৰু চোৱা, লেবীৰ সন্তানসকলে কৰা দাস্যকৰ্মৰ, সাক্ষাৎ কৰা তম্বুৰ কাৰ্যৰ বেচ স্বৰূপে মই তেওঁলোকৰ উত্তৰাধিকাৰৰ অৰ্থে ইস্ৰায়েলৰ মাজৰ আটাই দশম ভাগ দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","আৰু ইস্ৰায়েলৰ সন্তানসকলে পাপ বৈ যেন নমৰে এই কাৰণে এতিয়াৰ পৰা তেওঁলোকে সাক্ষাৎ কৰা তম্বুৰ ওচৰ চাপিব নালাগে। ");
INSERT INTO asmfb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","কিন্তু লেবীয়াসকলেই সাক্ষাৎ কৰা তম্বুৰ সেৱাকৰ্ম কৰিব, আৰু তেওঁলোকে সেই বিষয়ে কোনো পাপৰ ভাৰ ব’ব; এয়ে তোমালোকৰ পুৰুষানুক্ৰমে পালন কৰিবলগীয়া চিৰস্থায়ী বিধি; আৰু ইস্ৰায়েলৰ সন্তানসকলৰ মাজত তেওঁলোকে কোনো অধিকাৰ নাপাব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","কিয়নো ইস্ৰায়েলৰ সন্তানসকলে যিহোৱাৰ উদ্দেশ্যে উত্তোলনীয় উপহাৰ স্বৰূপে যি দশম ভাগ উৎসৰ্গ কৰিব, তাকে মই লেবীয়াসকলৰ উত্তৰাধীকাৰ স্ৱৰূপে দিলোঁ; এই কাৰণে মই তেওঁলোকক ক’লোঁ, ‘ইস্ৰায়েলৰ সন্তানসকলৰ মাজত তেওঁলোকে কোনো অধিকাৰ নাপাব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","পাছত যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“তুমি লেবীয়াসকলক এই আজ্ঞা দি কোৱা, ‘তোমালোকক উত্তৰাধিকাৰৰ অৰ্থে ইস্ৰায়েলৰ সন্তানসকলৰ পৰা যি দশম ভাগ যিহোৱাই দিলে, তাক যেতিয়া তোমালোকে ইস্ৰায়েলৰ সন্তানসকলৰ পৰা গ্ৰহণ কৰিবা, তেতিয়া তোমালোকে যিহোৱাৰ উদ্দেশ্যে উত্তোলনীয় উপহাৰ স্বৰূপে সেই দশম ভাগৰো দশম ভাগ উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","তোমালোকে সেই উপহাৰ মৰণা মৰা ঠাইৰ শস্য আৰু কুণ্ড পূৰ কৰা দ্ৰাক্ষাৰস যেন বুলি তোমালোকৰ পক্ষে গণিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","তোমালোকে ইস্ৰায়েলৰ সন্তান সকলৰ পৰা যি দশম ভাগ গ্ৰহণ কৰিবা, তাৰ পৰা তোমালোকেও এইদৰে যিহোৱাৰ উদ্দেশ্যে উত্তোলনীয় উপহাৰ উৎসৰ্গ কৰিবা; তাৰ পৰা যিহোৱাৰ উদ্দেশ্যে দিয়া সেই উত্তোলনীয় উপহাৰ তোমালোকে হাৰোণ পুৰোহিতক দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","যিহোৱাই পাব লগা এই সকলো উত্তোলনীয় উপহাৰ তোমালোকে লোৱা দানৰ পৰাই উৎসৰ্গ কৰিবা, অৰ্থাৎ তাৰ সকলো উত্তম ভাগৰ পৰা পবিত্ৰীকৃত ভাগ উৎসৰ্গ কৰিবা’। ");
INSERT INTO asmfb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","এই হেতুকে তুমি তেওঁলোকক কোৱা, ‘তোমালোকে যেতিয়া তাৰ পৰা উত্তম ভাগ উত্তোলনীয় উপহাৰ স্বৰূপে উৎসৰ্গ কৰিবা, তেতিয়া সেয়ে লেবীয়াসকলৰ পক্ষে মৰণা মৰা ঠাইত মৰা শস্য আৰু কুণ্ডৰ পৰা উলিওৱা দ্ৰাক্ষাৰস যেন গণিত হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","তোমালোকে আৰু তোমালোকৰ পৰিয়ালসকলে যি কোনো ঠাইত তাক ভোজন কৰিব পাৰিবা, কিয়নো সেয়ে সাক্ষাৎ কৰা তম্বুত কৰা তোমালোকৰ কাৰ্যৰ কাৰণে তোমালোকৰ বেচ স্বৰূপ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","আৰু তাৰ পৰা তাৰ উত্তম ভাগ উত্তোলনীয় উপহাৰস্বৰূপে উৎসৰ্গ কৰিলে, তাৰ কাৰণে পাপৰ ভাৰ নববা, আৰু নিজৰ মৃত্যু নহবলৈ সেই বিষয়ে ইস্ৰায়েলৰ সন্তান সকলৰ পবিত্ৰ বস্তু অপবিত্ৰ নকৰিবা’।” ");
INSERT INTO asmfb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","পাছত যিহোৱাই মোচি আৰু হাৰোণক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“যিহোৱাই আজ্ঞা দিয়া ব্যৱস্থাৰ বিধি এই: ইস্ৰায়েলৰ সন্তান সকলক, নিখুঁত, নিৰ্ঘূণী আৰু যুৱলি নোলোৱা ৰাঙলী চেঁউৰি গৰু এজনী তোমাৰ গুৰিলৈ আনিবলৈ আজ্ঞা দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","পাছত তোমালোকে তাইক ইলিয়াজৰ পুৰোহিতক দিবা; আৰু তেওঁ তাইক ছাউনিৰ বাহিৰলৈ নিব, আৰু তেওঁৰ সাক্ষাতে কোনো এজন লোকে তাইক বধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","তেতিয়া ইলিয়াজৰ পুৰোহিতে নিজ আঙুলিৰে তাৰ কিছু তেজ লৈ, সাক্ষাৎ কৰা তম্বুৰ আগলৈ সাত বাৰ ছটিয়াব; ");
INSERT INTO asmfb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","তেওঁৰ সাক্ষাতে সেই গৰুজনীক আন এজন পুৰোহিতে দগ্ধ কৰিব; তাইৰ গোবৰে সৈতে তাইৰ ছাল, মঙহ, তেজ দগ্ধ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","সেই পুৰোহিতে এডোখৰ এৰচ কাঠ, একোচা এচোব বন আৰু অলপ ৰঙা নোম লৈ, গৰুজনীক পোৰা জুইৰ মাজত পেলাই দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","তাৰ পাছত পুৰোহিতজনে নিজ কাপোৰ আৰু গা ধুব। তাৰ পাছত তেওঁ ছাউনিত সোমাব পাৰিব; কিন্তু পুৰোহিতজনে সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","আৰু যিজনে গৰুজনীক পুৰিব, তেওঁ পানীত নিজ কাপোৰ আৰু গা ধুব আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","পাছত কোনো এজন শুচি লোকে সেই গৰুজনীৰ ছাঁই গোটাই, ছাউনিৰ বাহিৰত কোনো পৰিস্কাৰ ঠাইত ৰাখিব। তাক ইস্ৰায়েলৰ সন্তান সকলৰ মণ্ডলীৰ কাৰণে অশুচিতা নাশক জলৰ কাৰণে ৰখা যাব কিয়নো সেই বলি পাপাৰ্থক বলি স্ৱৰুপে দান কৰা হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","আৰু যি জন লোকে গৰুজনীৰ ছাঁই গোটাব, তেৱোঁ নিজৰ কাপোৰ ধুব, আৰু সন্ধ্যালৈকে অশুচি হৈ থাকিব। এয়ে ইস্ৰায়েলৰ সন্তান সকলৰ আৰু তেওঁলোকৰ মাজত প্ৰবাস কৰা বিদেশীসকলৰো পালন কৰিবলগা চিৰস্থায়ী বিধি। ");
INSERT INTO asmfb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","যি কোনো লোকে যেতিয়া মৰা মানুহৰ শৱ চুব, তেওঁ সাত দিন অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","তেওঁ তৃতীয় দিনা আৰু সপ্তমদিনা নিজকে শুচি কৰিব, তাৰ পাছত শুচি হ’ব। কিন্তু তেওঁ যদি তৃতীয় দিনা আৰু সপ্তম দিনা নিজকে শুচি নকৰে, তেন্তে তেওঁ শুচি নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","যি কোনোৱে মৰা মানুহৰ শৱ চুই নিজকে শুচি নকৰিব, তেওঁ যিহোৱাৰ আবাস অশুচি কৰিব; সেই লোকজনক ইস্ৰায়েলৰ মাজৰ পৰা উচ্ছন্ন কৰা হ’ব, কিয়নো তেওঁৰ ওপৰত অশুচিতা নাশক জল নছটিওৱাত তেওঁ অশুচি হ’ল আৰু তেওঁৰ অশুচিতা তেওঁৰ লগতে থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","যেতিয়া কোনো এজন লোকৰ তম্বুৰ ভিতৰত মৃত্যু হ’ব তেতিয়া এনে নিয়ম হ’ব- সেই তম্বুৰ ভিতৰত সোমোৱা সকলো লোক আৰু তম্বুৰ ভিতৰত থকা সকলো মানুহ সাত দিন অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","আৰু ৰছীৰে বন্ধা ঢাকনি নথকা সকলো মুকলি পাত্ৰ অশুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","আৰু যি কোনো লোকে মুকলি ঠাইত তৰোৱালত হত হোৱা বা এনেই মৰা লোকৰ শৱ, নাইবা নৰা মানুহৰ হাড়, বা মৈদাম চুব- তেওঁ সাত দিন অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","আৰু সেই অশুচি মানুহৰ কাৰণে পাপাৰ্থক বলিৰ সেই পোৰা ছাঁইৰ কিছু পাত্ৰত ৰাখি, তাৰ ওপৰত ভুমুকৰ পানী দিয়া যাব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","আৰু কোনো শুচি লোক এজনে একোচা এচোব বন লৈ, সেই পানীত জুবুৰীয়াই, সেই তম্বুৰ ওপৰত, আৰু তাত থকা সকলো বস্তুৰ আৰু আটাই প্ৰাণীৰ ওপৰত আৰু হাড়, বা হত হোৱা বা এনেই মৰা লোকৰ শৱ, নাইবা মাদাম স্পৰ্শ কৰা সেই মানুহজনৰ ওপৰতো তাক ছটিয়াব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","সেই শুচি লোকজনে তৃতীয় দিনা আৰু সপ্তম দিনা সেই অশুচি লোকজনৰ ওপৰত সেই জল ছটিয়াব। পাছত সপ্তম দিনা সেই অশুচি লোকজনে নিজকে শুচি কৰিব; তেওঁ নিজৰ কাপোৰ ধুব আৰু পানীত গা ধুব। পাছত সন্ধিয়া সময়ত তেওঁ শুচি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","কিন্তু যি জন লোকে অশুচি হৈয়ো নিজকে শুচি নকৰিব, সেই লোকজনক সমাজৰ পৰা উচ্ছন্ন কৰা হ’ব, কিয়নো তেওঁ যিহোৱাৰ পবিত্ৰ স্থান অশুচি কৰিলে; তেওঁৰ ওপৰত অশুচিতা-নাশক জল ছটিওৱা নহ’ল; আৰু তেওঁ অশুচি হৈ থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","এয়ে তেওঁলোকে পালন কৰিব লগীয়া চিৰস্থায়ী বিধি হ’ব। আৰু যি জনে অশুচিতা-নাশক জল ছটিয়াব, তেওঁ নিজৰ কাপোৰ ধুব; আৰু যি জনে সেই অশুচিতা-নাশক জল চুব তেৱোঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","আৰু সেই অশুচি লোকে যি কিছু চুব, সেয়ে অশুচি হ’ব; আৰু যি লোকে তাক চুব, তেৱোঁ সন্ধ্যালৈকে অশুচি হৈ থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","পাছত ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীয়ে প্ৰথম মাহত ছিন অৰণ্য পালে। তেওঁলোকে কাদেচত থাকিল, সেই ঠাইতে মিৰিয়মৰ মৃত্যু হ’ল আৰু তাতে তেওঁক মৈদাম দিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","সেই ঠাইত মণ্ডলীৰ কাৰণে পানী নথকাত, লোকসকলে মোচি আৰু হাৰোণৰ অহিতে গোট খালে। ");
INSERT INTO asmfb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","তেওঁলোকে মোচিৰে সৈতে বিবাদ কৰি ক’লে, “যিহোৱাৰ আগত আমাৰ ভাইসকলৰ মৃত্যু হোৱাৰ সময়ত আমাৰো মৃত্যু হোৱা হেতেন কেনে ভাল আছিল! ");
INSERT INTO asmfb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","আমি আৰু আমাৰ পশুবোৰ মৰিবৰ কাৰণে যিহোৱাৰ সমাজক কেলেই তোমালোকে এই মৰুভূমিলৈ আনিলা? ");
INSERT INTO asmfb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","এই কুচ্ছিত ঠাইলৈ আনিবৰ বাবে আমাক কেলেই মিচৰৰ পৰা উলিয়াই আনিলা? এয়ে শস্য বা ডিমৰু, বা দ্ৰাক্ষা, বা ডালিমৰ ঠাই নহয় আৰু খাবলৈকো পানী নাই।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","পাছত মোচি আৰু হাৰোণে সমাজৰ আগৰ পৰা সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখলৈ গৈ উবুৰি হৈ পৰিল। তাতে যিহোৱাৰ প্ৰতাপ তেওঁলোকৰ আগত প্ৰকাশিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","আৰু যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“তুমি লাখুটিডাল লোৱা, আৰু তুমি আৰু তোমাৰ ককায় হাৰোণে সমাজক গোটাই লোৱা। শিলটোৱে পানী উলিয়াই বৈ যাবৰ বাবে, তোমালোকে তেওঁলোকৰ চকুৰ আগতেই শিলটোক আজ্ঞা কৰা। এইদৰে তুমি তেওঁলোকৰ বাবে শিলটোৰ পৰা পানী উলিয়াই সমাজক আৰু তেওঁলোকৰ পশুবোৰকো খুৱাবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","তেতিয়া মোচিয়ে যিহোৱাৰ আজ্ঞা অনুসাৰে তেওঁৰ আগত পৰা লাখুটি ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","তাৰ পাছত মোচি ও হাৰোণে শিলটোৰ আগত সমাজক গোটাই ল’লে, তেওঁ তেওঁলোকক ক’লে, “হে বিদ্ৰোহীহঁত, শুন তহঁতৰ কাৰণে আমি এই শিলৰ পৰা পানী উলিয়াম নে?” ");
INSERT INTO asmfb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","এই বুলি মোচিয়ে হাত দাঙি, সেই লাখুটিৰে শিলটোত দুবাৰ কোব মাৰিলে; তেতিয়া অধিক পানী ওলাল আৰু সমাজে আৰু তেওঁলোকৰ পশুবোৰেও পানী খালে। ");
INSERT INTO asmfb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","তেতিয়া যিহোৱাই মোচি আৰু হাৰোণক ক’লে, “তোমালোকে ইস্ৰায়েলৰ সন্তান সকলৰ আগত মোক পবিত্ৰ কৰিবলৈ মোত দৃঢ়ৰূপে বিশ্বাস নকৰিলা; এই হেতুকে মই এই সমাজক দিয়া দেশত তোমালোকে তেওঁলোকক নুসুমুৱাবা। ");
INSERT INTO asmfb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","সেই ঠাইৰ নাম মিৰীবা বিবাদ ৰাখিলে; কিয়নো ইস্ৰায়েলৰ সন্তান সকলে যিহোৱাৰে সৈতে বিবাদ কৰিলে; আৰু তেওঁ তেওঁলোকৰ মাজত পবিত্ৰ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","পাছত মোচিয়ে কাদেচৰ পৰা ইদোমৰ ৰজাৰ গুৰিলৈ দূত পঠাই ক’লে, তোমাৰ ভায়েৰা ইস্ৰায়েলৰ এই কথা কৈছে: “আমালৈ যি সকলো দুখ ঘটিল, তাক তুমি জানি আছা। ");
INSERT INTO asmfb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","আমাৰ পূৰ্বপুৰুষসকল মিচৰলৈ নামি গৈছিল, সেই মিচৰতে আমি অনেক দিন বাস কৰি আছিলোঁ। আৰু মিচৰীসকলে আমালৈ আৰু আমাৰ পূৰ্বপুৰুষসকললৈ কু-ব্যৱহাৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","তেতিয়া আমি যিহোৱাৰ আগত কাতৰোক্তি কৰোঁতে, তেওঁ আমাৰ বাক্যলৈ কাণ দিলে, তেওঁ দূত পঠাই মিচৰৰ পৰা আমাক উলিয়াই আনিলে। আৰু এতিয়া চোৱা, আমি তোমাৰ দেশৰ সীমাত থকা কাদেচ নগৰত আছোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","বিনয় কৰোঁ, তোমাৰ দেশৰ মাজেদি আমাক যাবলৈ দিয়া। আমি শস্য ক্ষেত্ৰ বা দ্ৰাক্ষা-ক্ষেত্ৰেদি নাযাওঁ আৰু নাদৰ পানীও পান নকৰোঁ, কেৱল ৰাজবাটেদি যাম। তেতিয়ালৈকে তোমাৰ দেশৰ সীমা পাৰ নহোৱালৈকে, সোঁহাতে কি বাওঁহাতে নুঘূৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","তাতে ইদোমৰ ৰজাই তেওঁক উত্তৰ দি ক’লে, “তুমি মোৰ দেশৰ মাজেদি যাব নোৱাৰা; গ’লে মই তৰোৱাল লৈ তোমাৰ বিৰুদ্ধে ওলাম।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","তেতিয়া ইস্ৰায়েলৰ সন্তানসকলে তেওঁক ক’লে, “আমি কেৱল ৰাজবাটেদি যাম, যদি মই আৰু মাৰ পশুবোৰে তোমাৰ পানী খায়, তেন্তে মই তাৰ মূল্য দিম; মোক আন একোকে নালাগে, কেৱল মোক খোজকাঢ়ি যাব দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","কিন্তু তেওঁ উত্তৰ দি ক’লে, “তুমি ইয়াৰ মাজেৰে যাবলৈ নোৱৰিবা।” পাছত ইদোমৰ ৰজাই অনেক সৈন্যক লগত লৈ বাহুবল দেখুৱাই তেওঁৰ বিৰুদ্ধে ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","এইদৰে ইদোমৰ ৰজাই ইস্ৰায়েলক নিজ অঞ্চলৰ মাজেদি যাবলৈ অনুমতি দিবলৈ অমান্তি হ’ল। সেইবাবেই ইস্ৰায়েল তেওঁৰ পৰা ঘুৰি আন বাটেদি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","তাৰ পাছত ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই সমাজে কাদেচৰ পৰা যাত্ৰা কৰি হোৰ পৰ্ব্বত পালেগৈ। ");
INSERT INTO asmfb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","তেতিয়া ইদোম দেশৰ সীমাৰ ওপৰত থকা হোৰ পৰ্ব্বতত যিহোৱাই মোচি আৰু হাৰোণক কথা ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“হাৰোণক নিজ লোকসকলৰ লগলৈ নিয়া হ’ব; কিয়নো মই ইস্ৰায়েলৰ সন্তান সকলক দিয়া দেশত তেওঁ সোমাব নোৱাৰিব। কাৰণ মিৰীবা জলৰ ওচৰত তোমালোক দুয়োই মোৰ বাক্যৰ বিৰুদ্ধে আচৰণ কৰিলা। ");
INSERT INTO asmfb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","তুমি হাৰোণক আৰু তেওঁৰ পুত্ৰ ইলিয়াজৰক হোৰ পৰ্ব্বতলৈ লৈ যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","আৰু হাৰোণৰ বস্ত্ৰ সোলোকাই তেওঁৰ পুত্ৰ ইলিয়াজৰক পিন্ধোৱা। হাৰোণক নিজ লোকসকলৰ লগত নিয়া হ’ব, আৰু তেওঁ সেই ঠাইতে মৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","তেতিয়া মোচিয়ে যিহোৱাৰ আজ্ঞা অনুসাৰে কৰিলে। তেওঁলোকে গোটেই সমাজৰ আগতে হোৰ পৰ্ব্বতলৈ উঠি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","আৰু মোচিয়ে হাৰোণৰ বস্ত্ৰ সোলোকাই তেওঁৰ পুত্ৰ ইলিয়াজৰক পিন্ধালে। আৰু হাৰোণ সেই পৰ্ব্বতৰ টিঙত থকা ঠাইতে মৰিল। পাছে মোচি আৰু ইলিয়াজৰ পৰ্ব্বতৰ পৰা নামি আহিল। ");
INSERT INTO asmfb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","যেতিয়া গোটেই সমাজে হাৰোণৰ মৃত্যু হোৱা দেখিলে, তেতিয়া ইস্ৰায়েলৰ গোটেই বংশই হাৰোণৰ কাৰণে ত্ৰিশ দিনলৈকে ক্ৰন্দন কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","পাছত দক্ষিণ অঞ্চলত থকা অৰাদৰ কনানীয়া ৰজাই অথাৰীমৰ বাটেদি ইস্ৰায়েল আহিছে বুলি শুনি, তেওঁলোকৰ বিৰুদ্ধে যুদ্ধ কৰি তেওঁলোকৰে কিছুমান লোকক বন্দী কৰি নি ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","তেতিয়া ইস্ৰায়েলে যিহোৱাৰ আগত প্ৰতিজ্ঞা কৰি ক’লে, “আপুনি যদি এই লোকসকলক আমাৰ হাতত সমৰ্পণ কৰে, তেন্তে আমি তেওঁলোকৰ নগৰবোৰ নিঃশেষে বিনষ্ট কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","তেতিয়া যিহোৱাই ইস্ৰায়েলৰ বাক্যলৈ কাণ দিলে, সেই কনানীয়াসকলক সমৰ্পণ কৰিলে। তেতিয়া লোকসকলে তেওঁলোকক আৰু তেওঁলোকৰ নগৰবোৰ নিঃশেষে বিনষ্ট কৰিলে। সেই ঠাইৰ নাম হৰ্মা ৰখা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","পাছত তেওঁলোকে ইদোম দেশ ঘূৰিবৰ অৰ্থে, চূফ সাগৰৰ বাটেদি হোৰ পৰ্ব্বতৰ পৰা যাত্ৰা কৰিলে। আৰু বাটৰ কাৰণে লোকসকলৰ মন অতিশয় অধৈৰ্য হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","আৰু লোকসকলে ঈশ্বৰ ও মোচিৰ বিৰুদ্ধে ক’বলৈ ধৰিলে: বোলে, “মৰুভূমিত মৰিবলৈ তোমালোকে মিচৰৰ পৰা আমাক কেলেই উলিয়াই আনিলা?” কিয়নো আহাৰো নাই পানীও নাই আৰু আমাৰ মনে এই সামান্য আহাৰ ঘিণ কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","তেতিয়া যিহোৱাই লোকসকলৰ মাজলৈ বিষাক্ত সাপ পঠিয়ালে আৰু সেইবোৰে দংশিবলৈ ধৰাত ইস্ৰায়েলৰ মাজত অনেক লোক মৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","লোকসকলে মোচিৰ গুৰিলৈ আহি ক’লে, “আমি গুপ্ত পাপ কৰিলোঁ, কাৰণ আমি যিহোৱা আৰু তোমাৰ বিৰুদ্ধে কথা কলোঁ। আমাৰ ওচৰৰ পৰা যিহোৱাই সাপবোৰ দূৰ কৰিবৰ বাবে, তুমি তেওঁৰ আগত প্ৰাৰ্থনা কৰা।” তেতিয়া মোচিয়ে লোকসকলৰ বাবে প্ৰাৰ্থনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","যিহোৱাই মোচিক ক’লে, “তুমি এটা বিষাক্ত সাপ সাজি এডাল খুটিৰ ওপৰত নিচানস্বৰূপে তুলি ৰাখিবা। তেতিয়া সাপে দংশা যিকোনো লোকে যদি তালৈ চায়, সেইজন জীৱ।” ");
INSERT INTO asmfb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","তেতিয়া মোচিয়ে পিতলৰ এটা সাপ বনাই নিচানস্বৰূপে এডাল খুটিত তুলি ৰাখিলে। যেতিয়া সাপে কোনো মানুহক দংশিলে, তেতিয়া তেওঁ সেই পিতলৰ সাপলৈ দৃষ্টি কৰি জীলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","তেতিয়া ইস্ৰায়েলৰ সন্তান সকলে যাত্ৰা কৰি এবোতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","আৰু এবোতৰ পৰা যাত্ৰা কৰি সূৰ্য ওলোৱা দিশে মোৱাবৰ সন্মুখে থকা মৰুভূমিৰ ইয়ে-অবাৰীমত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","তাৰ পৰা যাত্ৰা কৰি জেৰদ উপত্যকাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","আৰু তাৰ পৰা যাত্ৰা কৰি ইমোৰীয়াসকলৰ সীমাৰ পৰা ওলোৱা, মৰুভূমিত থকা অৰ্ণোনৰ অন্য পাৰে ছাউনি পাতিলে, কিয়নো মোৱাবৰ আৰু ইমোৰীয়াসকলৰ মাজত থকা অৰ্ণোন মোৱাবৰ সীমা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","এই হেতুকে যিহোৱাৰ যুদ্ধ-পুস্তকত কোৱা হৈছে, বোলে, “চুফাত বাহেবক, অৰ্ণোনৰ উপত্যকাবোৰক, ");
INSERT INTO asmfb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","আৰু আৰ নামেৰে লোকালয়লৈ মুখ কৰা আৰু মোৱাবৰ সীমাত লগা চাৱলীয়া উপত্যকাবোৰ তেওঁ জয় কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","তাৰ পৰা তেওঁলোকে বেৰলৈ, অৰ্থাৎ যি নাদৰ বিষয়ে যিহোৱাই মোচিক কৈছিল, তুমি লোকসকলক গোটোৱা, মই তেওঁলোকক পানী দিম। সেই নাদলৈ যাত্ৰা কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","সেই কালত ইস্ৰায়েলে এই গীত গান কৰিলে: “হে নাদ উঠলি উঠা; তোমালোকে ইয়াৰ উদ্দেশ্যে গান গোৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","এয়ে অধ্যক্ষ সকলে খনা নাদ, লোকসকলৰ প্ৰধানসকলে ৰাজ-দণ্ডেৰে আৰু নিজ নিজ লাখুটিৰে ইয়াক খনন কৰিলে।” পাছত তেওঁলোকে অৰণ্যৰ পৰা মত্তানালৈ। ");
INSERT INTO asmfb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","মত্তানাৰ পৰা নহলীয়েললৈ, নহলীয়েলৰ পৰা বামোতলৈ, ");
INSERT INTO asmfb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","আৰু বামোতৰ পৰা উপত্যকাইদি মোৱাবৰ দেশলৈ। সেয়ে যিচীমোনৰ ফাললৈ মুখ কৰি থকা পিচগা পৰ্ব্বতৰ টিঙলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","পাছত ইস্ৰায়েলে ইমোৰীয়াসকলৰ ৰজা চীহোনৰ গুৰিলৈ দূতৰ দ্বাৰাই এই কথা কৈ পঠিয়ালে বোলে, ");
INSERT INTO asmfb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“তুমি নিজ দেশৰ মাজেদি মোক যাবলৈ দিয়া; আমি শস্যক্ষেত্ৰত বা দ্ৰাক্ষা-ক্ষেত্ৰত নোসোমাও আৰু নাদৰ পানীও নাখাওঁ। তোমাৰ সীমা পাৰ নহওঁমানে ৰাজবাটে গৈ থাকিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","তথাপি চীহোনৰ ৰজাই নিজ অঞ্চলৰ মাজেদি ইস্ৰায়েলক যাবলৈ নিদিলে। কিন্তু চীহোনে নিজৰ সকলো প্ৰজাক গোটাই ইস্ৰায়েলৰ বিৰুদ্ধে মৰুভূমিলৈ ওলাল আৰু যহচলৈ গৈ ইস্ৰায়েলে সৈতে যুদ্ধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ইস্ৰায়েলে তৰোৱালৰ ধাৰত তেওঁক আঘাত কৰি, অৰ্ণোনৰ পৰা যব্বোকলৈকে অম্মোনৰ সন্তান সকলৰ সীমালৈকে তেওঁৰ দেশ অধিকাৰ কৰিলে; কাৰণ অম্মোনৰ সন্তান সকলৰ সীমা গড়েৰে দৃঢ় আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","এইদৰে ইস্ৰায়েলে সেই সকলো নগৰ হাত কৰি ললে; আৰু ইস্ৰায়েলে ইমোৰীয়াসকলৰ আটাই নগৰত, হিচবোনত আৰু তাৰ সকলো উপত্যকাবোৰত বাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","কিয়নো হিচবোন ইমোৰীয়াহঁতৰ ৰজা চীহোনৰ নগৰ আছিল; সেই চীহোনে মোৱাবৰ আগৰ ৰজাৰ অহিতে যুদ্ধ কৰি তেওঁৰ হাতৰ পৰা অৰ্ণোনলৈকে তেওঁৰ আটাই দেশ লৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","এই কাৰণে কবি সকলে কয়, “তোমালোক হিচবোনলৈ আহা, চীহোনৰ নগৰ সজা আৰু দৃঢ় কৰা হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","কিয়নো হিচবোনৰ পৰা অগ্নি-শিখা ওলাই, চীহোনৰ পৰা শিখাই, মোৱাবৰ আৰ লগৰ গ্ৰাস কৰিলে, আৰু অৰ্ণোনৰ ওখ ঠাইবোৰৰ প্ৰভুসকলক গ্ৰাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","হে মোৱাব!, তোমাৰ সন্তাপ হ’ল, আৰু হে কমোচৰ প্ৰজা, তুমি বিনষ্ট থ’লো; সি নিজৰ পুতেকসকলক পলাবলৈ, আৰু নিজৰ জীয়েকসকলক বন্দী অৱস্থাত পৰিবলৈ এৰি দিলে, ইমোৰীয়াসকলক ৰজা চীহোনৰ হাতত সমৰ্পণ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","আৰু আমি তেওঁলোকলৈ বাণ মাৰিলোঁ; দীবোনলৈকে হিচবোন বিনষ্ট হ’ল। মেদবালৈ বিস্তৃত নোফহলৈকে আমি সকলোকে ধ্বংস কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","এইদৰে ইস্ৰায়েলে ইমোৰীয়াসকলৰ দেশত বাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","মোচিয়ে যাজেৰক গুপুতে চাবলৈ মানুহ পঠালে। তাৰ পাছত লোকসকলে তাৰ সকলো উপনগৰ হাত কৰি লৈ, তাত থকা ইমোৰীয়াসকলক দূৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","তেতিয়া তেওঁলোক ঘূৰি বাচানৰ বাটেদি উঠি গ’ল। তেওঁলোকৰ বিৰুদ্ধে ইদ্ৰেয়ীত যুদ্ধ কৰিবলৈ বাচানৰ ৰজা ওগ আৰু তেওঁৰ সকলো প্ৰজাসকল ওলাল। ");
INSERT INTO asmfb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","তেতিয়া যিহোৱাই মোচিক ক’লে, “তুমি তেওঁলৈ ভয় নকৰিবা; কিয়নো মই তেওঁক, তেওঁৰ আটাই প্ৰজাক আৰু তেওঁৰ দেশকো তোমাৰ হাতত শোধাই দিলোঁ। তুমি হিচবোনত থকা ইমোৰীয়া ৰজা চীহোনলৈ যেনে কৰিলা, তেওঁলৈকো তেনে কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","গতিকে তেওঁলোকৰ তেওঁৰ কোনো শেষ নথকাকৈ, তেওঁক, তেওঁৰ পুতেকসকলক আৰু তেওঁৰ আটাই প্ৰজাক মাৰি, তেওঁৰ দেশ অধিকাৰ কৰি ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","যৰ্দ্দন নদীৰ পৰা আনফালে যিৰীহোৰ ওচৰত থকা মোৱাবৰ সমথলত ছাউনি নপতালৈকে ইস্ৰায়েলৰ সন্তান সকলে যাত্রা কৰি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","তেতিয়া আটাই ইস্ৰায়েলে ইমোৰীয়াসকললৈ কৰা আটাইকে চিপ্পোৰৰ পুত্ৰ বালাকে দেখি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","আৰু মোৱাবে লোকসকলৰ কাৰণে অতিশয় ভয়ত আছিল, কিয়নো তেওঁলোক অধিক আছিল; আৰু মোৱাব ইস্ৰায়েলৰ সন্তান সকলৰ কাৰণে অতিশয় ব্যাকুল হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","মোৱাবৰ ৰজাই মিদিয়নৰ বৃদ্ধ লোক সকলক ক’লে, “গৰুৱে পথাৰৰ কোমল ঘাঁহ চেলেকাদি, এই লোক সকলে আমাৰ চাৰিওঁফালে থকা সকলোকে খাই শেষ কৰিব।” সেই কালত চিপ্পোৰৰ পুত্ৰ বালাক মোৱাবৰ ৰজা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","তেওঁ বিয়োৰৰ পুত্ৰ বিলিয়মক মাতিবলৈ, তেওঁৰ স্ব-জাতীয় লোকসকলৰ দেশলৈ ফৰাৎ নদীৰ পাৰত থকা পথোৰ নগৰলৈ দূত পঠাই তেওঁক ক’লে, “চোৱা, মিচৰৰ পৰা এক জাতি ওলাই আহিছে। চোৱা, তেওঁলোকে পৃথিৱীখন ঢকাৰ দৰে ঢাকি এই মূহূর্ত্তত আমাৰ সন্মূখতে আছে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","মই নিবেদন কৰোঁ, আপুনি আহি মোৰ কাৰণে সেই জাতিক শাও দিয়ক, কিয়নো তেওঁলোক মোতকৈ অতি বলৱন্ত। কিজানি তেওঁলোকক জয় কৰি দেশৰ পৰা খেদিবলৈ মোৰ সাধ্য হ’ব। কিয়নো মই জানো, আপুনি যিজনক আশীৰ্ব্বাদ কৰে, তেওঁ আশীৰ্ব্বাদ পায়, আৰু যিজনক শাও দিয়ে, তেওঁ শাও পায়।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","পাছে মোৱাবৰ বৃদ্ধসকলে আৰু মিদিয়নৰ বৃদ্ধসকলে মঙ্গল চোৱাৰ বেচ হাতত লৈ প্ৰস্থান কৰিলে। আৰু তেওঁলোকে বিলিয়মৰ ওচৰ পাই বালাকৰ কথাবোৰ তেওঁক ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","তাতে তেওঁ তেওঁলোকক উত্তৰ দিলে, “তোমালোক আজি ৰাতি এই ঠাইতে থাকা। যিহোৱাই মোক যিহকে ক’ব, সেই দৰেই মই তোমালোকক উত্তৰ দিম।” গতিকে মোৱাবৰ অধ্যক্ষসকল বিলিয়মৰ লগতে সেই ৰাতিটো থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ঈশ্বৰে বিলিয়মৰ ওচৰলৈ আহি তেওঁক ক’লে, “তোমাৰ লগত থকা এই লোকসকল কোন?” ");
INSERT INTO asmfb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","বিলিয়মে ঈশ্বৰক উত্তৰ দি ক’লে, “মোৱাবৰ ৰজা চিপ্পোৰৰ পুত্ৰ বালাকে মোৰ ওচৰলৈ তেওঁলোকক কৈ পঠিয়াইছে। তেওঁ কৈছে, ");
INSERT INTO asmfb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘চোৱা, মিচৰৰ পৰা ওলাই অহা জাতিয়ে পৃথিৱী ঢকা দি মোৰ ঠাই ঢাকি ধৰিছে। এতিয়া তুমি আহি মোৰ কাৰণে তেওঁলোকক শাও দিয়া। কিজানি মই যুদ্ধ কৰি তেওঁলোকক খেদিব পাৰিম’।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","তেতিয়া ঈশ্বৰে বিলিয়মক ক’লে, “তুমি তেওঁলোকৰ লগত নাযাবা। তুমি সেই জাতিক শাও নিদিবা; কিয়নো তেওঁলোক আশীৰ্ব্বাদ পোৱা লোক।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","পাছত বিলিয়মে ৰাতিপুৱাতে উঠি বালাকৰ অধ্যক্ষসকলক ক’লে, “তোমালোকে নিজ দেশলৈ গুচি যোৱা; কিয়নো যিহোৱাই তোমালোকৰ লগত মোক যাবলৈ অনুমতি নিদিলে।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","তাতে মোৱাবৰ অধ্যক্ষসকলে উঠি বালাকৰ গুৰিলৈ আহিল। তেওঁলোকে ক’লে, “আমাৰ লগত আহিবলৈ বিলিয়ম অসন্মত হ’ল।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","বালাকে তেওঁলোকতকৈ অর্থাৎ প্রথম দলটিতকৈ অধিক আৰু অতিশয় সম্ভ্ৰান্ত আন অধ্যক্ষসকলক পঠিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","তেওঁলোকে বিলিয়মৰ ওচৰলৈ গৈ তেওঁক ক’লে, “চিপ্পোৰৰ পুত্ৰ বালাকে এই কথা কৈছে, ‘মই নিবেদন কৰোঁ, মোৰ ওচৰলৈ আহিবলৈ আপোনাক একোৱে বাধা নিদিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","কিয়নো মই আপোনাক অতিশয়ৰূপে সন্মানিত কৰিম আৰু যি যি আজ্ঞা দিব, তাকে কৰিম; এই হেতুকে বিনয় কৰোঁ। আপুনি আহি মোৰ কাৰণে এই জাতিক শাও দিয়ক’।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","তেতিয়া বিলিয়মে বালাকৰ দাসবোৰক উত্তৰ দিলে, “যদিও বালাকে ৰূপ আৰু সোণেৰে পূৰ হোৱা নিজৰ ৰাজপ্রাসাদো মোক দিয়ে, তথাপি মই ক্ষুদ্ৰ কি মহৎ কাৰ্য কৰিবলৈ নিজ ঈশ্বৰ যিহোৱাৰ আজ্ঞা উলঙ্ঘন কৰিব নোৱাৰোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","এতিয়া নিবেদন কৰোঁ, তোমালোকো এই ঠাইতে আজি ৰাতিটো থাকা, যিহোৱাই মোক আৰু যি ক’ব, তাক মই জানিম।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","পাছত ঈশ্বৰে ৰাতি বিলিয়মৰ ওচৰলৈ আহি তেওঁক ক’লে, “যিহেতু সেই লোকসকলে তোমাক মাতিবলৈ আহিছে, তুমি উঠি তেওঁলোকৰ লগত যোৱা; কিন্তু মই তোমাক যিহকে ক’ম, তাকেহে তুমি কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","বিলিয়মে ৰাতিপুৱাতে উঠি নিজৰ গাধ সজাই তাত উঠি মোৱাবৰ অধ্যক্ষসকলৰ লগত প্ৰস্থান কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","পাছত তেওঁ যোৱাতে ঈশ্বৰৰ ক্ৰোধ জ্বলি উঠিল। আৰু যিহোৱাৰ দূত তেওঁৰ বিৰুদ্ধকাৰী হৈ বাটৰ মাজত থিয় হ’ল। তেতিয়া তেওঁ নিজৰ গাধত উঠি নিজৰ দুজন দাসেৰে সৈতে গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","তেতিয়া সেই গাধজনীয়ে খোলা তৰোৱাল ধৰা যিহোৱাৰ দূতক বাটৰ মাজত থিয় হৈ থকা দেখিলে। এই হেতুকে গাধজনীয়ে বাট এৰি পথাৰৰ ফাললৈ গ’ল। বিলিয়মে গাধজনীক বাটলৈ আনিবৰ কাৰণে তাইক কোবালে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","তেতিয়া যিহোৱাৰ দূত দুইফালে গড় থকা দ্ৰাক্ষাবাৰীৰ ঠেক বাটত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","গাধজনীয়ে যিহোৱাৰ দূতক আকৌ দেখি গড়ত গা ঘঁহাই যাওঁতে, বিলিয়মৰ ভৰি গড়ত ঘঁহা খালে; তেতিয়া তেওঁ আকৌ তাইক কোবালে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","যিহোৱাৰ দূত আৰু অলপমান আগলৈ গৈ, সোঁফালে কি বাওঁফালে ঘূৰিবলৈ ঠাই নোহোৱা এনে এক চেপ ঠাইত থিয় হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","তেতিয়া গাধজনীয়ে যিহোৱাৰ দূতক দেখি বিলিয়মেৰে সৈতে আঁঠুকাঢ়ি পৰিল, বিলিয়াম খঙত জ্বলি উঠিল আৰু তেওঁ গাধজনীক লাখুটিৰে কোবাবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","তেতিয়া যিহোৱাই গাধক কথা ক’বলৈ শক্তি দিলে। গাধজনীয়ে বিলিয়মক ক’লে, “মই তোমাক কি কৰিলোঁ যে, তুমি এই তিনিবাৰ মোক কোবালা?” ");
INSERT INTO asmfb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","বিলিয়মে গাধজনীক ক’লে, “তই মোক অমান্য কৰিছ; মোৰ হাতত তৰোৱাল থকা হ’লে বৰ ভাল আছিল; সেয়ে হোৱা হ’লে মই এতিয়াই তোক বধ কৰিলোঁহেঁতেন।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","গাধজনীয়ে বিলিয়মক ক’লে, “যাৰ ওপৰত তুমি আজিলৈকে তোমাৰ সমস্ত জীৱন উঠি আহিছা, মই জানো সেই গাধজনী নহওঁ? মই জানো কেতিয়াবা তোমালৈ এনে ব্যৱহাৰ কৰিছিলোঁ?” বিলিয়মে ক’লে, “নাই কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","তেতিয়া যিহোৱাই বিলিয়মৰ চকু মুকলি কৰিলে, খোলা তৰোৱাল হাতত লোৱা যিহোৱাৰ দূতক বাটৰ মাজত থিয় হৈ থকা তেওঁ দেখিলে; তেতিয়াই তেওঁ মূৰ দোঁৱাই উবুৰি হৈ পৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","তেতিয়া যিহোৱাৰ দূতে তেওঁক ক’লে, “তুমি সেই তিনিবাৰ নিজৰ গাধজনীক কিয় মাৰিলা? চোৱা, মই তোমাৰ বিৰুদ্ধকাৰী হৈ ওলাইছোঁ, কিয়নো মোৰ সাক্ষাতে তুমি অপথে গৈছা। ");
INSERT INTO asmfb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","আৰু গাধজনীয়ে মোক দেখি এই তিনিবাৰ মোৰ সন্মুখৰ পৰা ঘূৰিছিল। তাই মোৰ সন্মূখৰ পৰা নুঘূৰা হ’লে মই নিশ্চয়ে তোমাক বধ কৰিলোঁহেঁতেন, কিন্তু তাইক জীয়াই ৰাখিলোঁহেঁতেন।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","বিলিয়মে যিহোৱাৰ দূতক ক’লে, “মই পাপ কৰিলোঁ; কিয়নো আপুনি যে মোৰ বিৰুদ্ধে বাটত থিয় হৈ আছে, তাক মই নাজানিলোঁ। কিন্তু এতিয়া যদি ইয়াত আপোনাৰ বেজাৰ হৈছে, তেন্তে মই উলটি যাওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","তেতিয়া যিহোৱাৰ দূতে বিলিয়মক ক’লে, “সেই লোকসকলেৰে সৈতে যোৱা। কিন্তু মই যি কথা তোমাক ক’ম, কেৱল তাকেহে ক’বা।” আৰু বিলিয়ম বালাকৰ অধ্যক্ষসকলেৰে সৈতে গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","পাছে বিলিয়ম অহাৰ বাতৰি শুনি, বালাকে তেওঁক আগবঢ়াই নিবলৈ দেশৰ সীমাৰ দাঁতিত অৰ্ণোনৰ সীমাত থকা মোৱাবৰ নগৰলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","পাছত বালাকে বিলিয়মক ক’লে, “মই আপোনাক মাতিবলৈ জানো অতি যত্নেৰে মানুহ পঠোৱা নাছিলো? আপুনি মোৰ ওচৰলৈ কিয় নহাকৈ আছিল? আপোনাক সন্মানিত কৰিবলৈ মই জানো নিচেই অসমৰ্থ?” ");
INSERT INTO asmfb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","তাতে বিলিয়মে বালাকক ক’লে, “এইয়া চোৱা, মই তোমাৰ ওচৰলৈ আহিছোঁ। তথাপি এতিয়াও কোনো কথা ক’বলৈ জানো মোৰ ক্ষমতা আছে? ঈশ্বৰে মোৰ মুখত যি বাক্য দিব, তাকেহে মই ক’ম।” ");
INSERT INTO asmfb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","বিলিয়মে বালাকৰ লগত আহি কিৰিয়ৎ-হুচোৎ পালেহি। ");
INSERT INTO asmfb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","আৰু বালাকে গৰু আৰু মেৰ বলিদান কৰি, বিলিয়ম আৰু তেওঁৰ লগৰ অধ্যক্ষসকললৈ মাংস পঠিয়ালে। ");
INSERT INTO asmfb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","পাছত ৰাতিপুৱাতে বালাকে বিলিয়মক বালৰ পবিত্র ঠাইবোৰলৈ লৈ গ’ল। তাৰ পৰা তেওঁ ইশ্রায়েলীয়া সকলৰ মাথোন এফালহে দেখা পালে। ");
INSERT INTO asmfb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","বিলিয়মে বালাকক ক’লে, “তুমি এই ঠাইত মোৰ কাৰণে সাতোটা যজ্ঞবেদী নিৰ্ম্মাণ কৰোঁৱা আৰু এই ঠাইতে মোৰ বাবে সাতোটা ভতৰা আৰু সাতোটা মতা মেৰ আয়োজন কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","বালাকে বিলিয়মৰ কথাৰ দৰেই কৰিলে। তেতিয়া বালাক আৰু বিলিয়মে প্রত্যেকটা যজ্ঞবেদীত এটা এটা ভতৰা আৰু এটা এটা মতা মেৰ উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","তেতিয়া বিলিয়মে বালাকক ক’লে, “তুমি তোমাৰ হোম বলিৰ ওচৰত থিয় হোৱা, মই যাওঁ। কিজানি যিহোৱাই মোৰে সৈতে সাক্ষাৎ কৰিব। সেয়ে হলে তেওঁ মোক যিহকে দেখুৱাই, তাকেই মই তোমাক ক’ম।” পাছে তেওঁ গছ-গছনি নথকা এনে এখন ওখ ঠাইলৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","তেতিয়া ঈশ্বৰে বিলিয়মেৰে সৈতে সাক্ষাৎ কৰিলত, বিলিয়মে তেওঁ ক’লে, “মই সাতোটা যজ্ঞবেদী যুগুত কৰিলোঁ আৰু প্ৰত্যেকটি যজ্ঞবেদীত এটা এটা ভতৰা আৰু এটা এটা মতা মেৰ উৎসৰ্গ কৰিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","তেতিয়া যিহোৱাই বিলিয়মৰ মুখত এক বাক্য দি তেওঁক ক’লে, “তুমি বালাকৰ ওচৰলৈ উলটি গৈ তেওঁক এই কথা কোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","তেতিয়া বিলিয়ম বালাকৰ ওচৰলৈ উলটি গ’ল, চোৱা, সেই সময়ত মোৱাবৰ অধ্যক্ষসকলেৰে সৈতে বালাক নিজৰ হোম বলিৰ ওচৰত থিয় হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","তেতিয়া বিলিয়মে নিজৰ ভৱিষ্যৎ বাণী পদ্যৰূপে গাই ক’লে, “বালাকে অৰামৰ পৰা মোক অনালে, মোৱাবৰ ৰজাই পূবফালৰ পৰ্ব্বতৰ পৰা মোক অনালে। ‘আহাঁ, মোৰ কাৰণে যাকোবক শাও দিয়া,’ তেওঁ ক’লে। আহাঁ, ইস্ৰায়েলক ধিক্কাৰ দিয়া।’ ");
INSERT INTO asmfb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","কিন্তু ঈশ্বৰে শাও নিদিয়া লোকক মই কেনেকৈ শাও দিম? আৰু যিহোৱাই ধিক্কাৰ নিদিয়া লোকক মই কেনেকৈ ধিক্কাৰ দিম? ");
INSERT INTO asmfb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","কিয়নো মই শিলবোৰৰ টিঙৰ পৰা সেইজনক দেখা পাইছোঁ; আৰু পৰ্ব্বতৰ পৰা সেইজনক দেখিছোঁ। চোৱা, তেওঁলোক অকলে বাস কৰা লোক জাতি সমূহৰ মাজত তেওঁলোক গণিত নহয়। ");
INSERT INTO asmfb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","যাকোবৰ ধূলি কোনে লেখ কৰিব পাৰে? বা ইস্ৰায়েলৰ চাৰি ভাগৰ এভাগকে কোনে গণিব পাৰে? ধাৰ্মিকৰ মৃত্যুৰ নিচিনা মোৰ মৃত্যু হওঁক, আৰু তেওঁৰ শেষ গতিৰ নিচিনা মোৰ শেষগতি হওঁক।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","তেতিয়া বালাকে বিলিয়মক ক’লে, “আপুনি মোলৈ এইয়া কি কৰিলে? মোৰ শত্ৰুবোৰক শাও দিবলৈ মই আপোনাক অনিলোঁ; আপুনি সিহঁতক সকলো ভাৱে আশীৰ্ব্বাদহে কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","তেতিয়া বিলিয়ামে উত্তৰ দি ক’লে, “যিহোৱাই মোৰ মুখত যি কথা দিব, সাৱধান হৈ মই তাকে নক’ম নে?” ");
INSERT INTO asmfb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","পাছত বালাকে তেওঁক ক’লে, “মই বিনয় কৰোঁ, আপুনি যি ঠাইৰ পৰা তেওঁলোকক দেখিবলৈ পাব, এনেকুৱা আন ঠাইলৈ মোৰ লগত আহক। আপুনি তেওঁলোকৰ সকলোকে দেখা পোৱা নাই, কেৱল এফালহে দেখিবলৈ পাইছে, সেই ঠাইৰ পৰা মোৰ কাৰণে তেওঁলোকক শাও দিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","তেতিয়া বালাকে তেওঁক চোফীম পথাৰৰ মাজলৈ পিচগাৰ টিঙলৈ লৈ গ’ল; সেই ঠাইতে তেওঁ সাতোটা যজ্ঞবেদী নিৰ্ম্মাণ কৰিলে আৰু প্ৰত্যেক যজ্ঞ-বেদীত এটা এটা ভতৰা আৰু এটা এটা মতা মেৰ উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","পাছত তেওঁ বালাকক ক’লে, “তুমি এই ঠাইতে তোমাৰ হোম-বলিৰ ওচৰত থিয় হৈ থাকা; মই হ’লে, সৌ তাত ঈশ্বৰৰ সাক্ষাৎ কৰোঁগৈ।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","তেতিয়া যিহোৱাই বিলিয়মেৰে সৈতে সাক্ষাৎ কৰি, তেওঁৰ মুখত এক বাক্য দি তেওঁক ক’লে, “তুমি বালাকৰ ওচৰলৈ উলটি গৈ তেওঁক এই কথা কোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","বিলিয়ম তেওঁৰ ওচৰলৈ ঘূৰি আহিল; সেই সময়ত মোৱাবৰ অধ্যক্ষসকলেৰে সৈতে বালাক নিজৰ হোম-বলিৰ গুৰিত থিয় হৈ আছিল। তেতিয়া বালাকে তেওঁক সুধিলে, যিহোৱাই কি ক’লে? ");
INSERT INTO asmfb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","বিলিয়মে নিজৰ ভৱিষ্যৎ বাণী পদ্যৰূপে গাই ক’লে, তেওঁ ক’লে, “হে বালাক, উঠি শুনা, হে চিপ্পোৰৰ পুত্ৰ, মোৰ কথালৈ কাণ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ঈশ্বৰ মনুষ্য নহয়, যে তেওঁ মিছা কথা ক’ব, তেওঁ মানুহৰ সন্তানো নহয়, যে তেওঁ মন ঘূৰাব। তেওঁ কৈ জানো সিদ্ধ নকৰিব? তেওঁ বাক্য কৈ জানো সাম্ফল নকৰিব? ");
INSERT INTO asmfb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","চোৱা, মই আশীৰ্ব্বাদ কৰিবলৈ আজ্ঞা পালোঁ। তেওঁ আশীৰ্ব্বাদ কৰিলে; মই তাৰ অন্যথা কৰিব নোৱাৰোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","তেওঁ যাকোবত অধৰ্ম দেখা নাই, বা ইস্ৰায়েলৰ মাজত দুষ্টতা দেখা নাই; নিজ ঈশ্বৰ যিহোৱা তেওঁৰ লগত থাকে, আৰু তেওঁলোকৰ মাজত ৰজাৰ জয়ধ্বনি আছে। ");
INSERT INTO asmfb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ঈশ্বৰে মিচৰ দেশৰ পৰা তেওঁলোকক আনিছে। তেওঁৰ বল মেঠনৰ বলৰ নিচিনা। ");
INSERT INTO asmfb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","নিশ্চয়ে যাকোবৰ মাজত লক্ষণ চোৱা দস্তুৰ নাই, ইস্ৰায়েলৰ মাজত মঙ্গল চোৱা কাৰ্য নাই। এতিয়া যাকোব আৰু ইস্ৰায়েলৰ বিষয়ে কোৱা যাব, ‘চোৱা ঈশ্বৰে কেনে কাৰ্য কৰিলে!’ ");
INSERT INTO asmfb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","চোৱা, সেই লোক সমূহ সিংহীৰ দৰে উঠিছে, সিংহৰ দৰে নিজৰ গা দাঙিছে; তেওঁ ধৰা পশু নাখায়মানে নুশুব, আৰু বধ কৰা লোকৰ তেজ পান নকৰেমানে শয়ন নকৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","তেতিয়া বালাকে বিলিয়মক ক’লে, “আপুনি তেওঁলোকক সমূলি শাৱো নিদিব আৰু সমূলি আশীৰ্ব্বাদো নকৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","তেতিয়া বিলিয়মে উত্তৰ দি বালাকক ক’লে, “যিহোৱাই মোক যি যি ক’ব, মই তাকেই কৰিম, এইবুলি জানো মই তোমাক কোৱা নাছিলো?” ");
INSERT INTO asmfb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","তথাপি বালাকে বিলিয়মক ক’লে, “বিনয় কৰি কওঁ, আহক, মই আপোনাক আন ঠাইলৈ লৈ যাওঁ। সেই ঠাইতে মোৰ কাৰণে আপুনি তেওঁলোকক শাও দিবলৈ কিজানি ঈশ্বৰ সন্তুষ্ট হ’ব পাৰে।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","গতিকে বালাকে যিচীমোনৰ ফাললৈ মুখ কৰা পিয়োৰৰ টিঙলৈ বিলিয়মক লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","বিলিয়মে বালাকক ক’লে, “এই ঠাইত মোৰ বাবে সাতোটা যজ্ঞবেদী নিৰ্ম্মাণ কৰোঁৱা আৰু ইয়াতো মোৰ বাবে সাতোটা ভতৰা আৰু সাতোটা মতা মেৰ আয়োজন কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","তেতিয়া বালাকে বিলিয়মৰ বাক্য অনুসাৰে কাৰ্য কৰি, প্ৰত্যেক যজ্ঞবেদীতে এটা এটা ভতৰা আৰু এটা এটা মতা মেৰ উৎসৰ্গ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","যেতিয়া বিলিয়ামে দেখিলে যে ইস্ৰায়েলক আশীৰ্ব্বাদ কৰাত ঈশ্বৰ তুষ্ট হৈছে, ইয়াকে দেখি বিলিয়মে আগৰ দৰে লক্ষণ চাবৰ কাৰণে নগ’ল। বৰং, মৰুভূমিৰ ফাললৈহে মুখ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","বিলিয়মে নিজৰ চকু তুলি ফৈদ অনুসাৰে বাস কৰা ইস্ৰায়েলক ছাউনি পাতি থকা দেখিলে আৰু ঈশ্বৰৰ আত্মা তেওঁত স্থিতি হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","তেতিয়া তেওঁ এই ভৱিষ্যৎ বাণী পাই নিজৰ পদ্যৰূপে গাই গাই ক’লে, বিয়োৰৰ পুত্ৰ বিলিয়মে কৈছে, যাৰ চকু সম্পূর্ণ মেলা আছিল, সেই পুৰুষে কৈছে, ");
INSERT INTO asmfb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","যি জনে ঈশ্বৰৰ বাক্য শুনে, যি জনে সৰ্ব্বশক্তিমানক দৰ্শন পায়, তেওঁ মাটিত পৰি চকু মেলি কৈছে। ");
INSERT INTO asmfb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","হে যাকোব, তোমাৰ তম্বুবোৰ কেনে সুন্দৰ! হে ইস্ৰায়েল, তোমাৰ আবাসবোৰ কেনে মনোহৰ! ");
INSERT INTO asmfb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","সেইবোৰ উপত্যকাৰ নিচিনা বিস্তৃত, আৰু নদীৰ পাৰত থকা বাৰীবোৰৰ সদৃশ, যিহোৱাই ৰোৱা অগৰু গছৰ নিচিনা, আৰু পানীৰ ওচৰত থকা এৰচ গছৰ তুল্য। ");
INSERT INTO asmfb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","তেওঁৰ কলহৰ পৰা পানী উথালি খাই পৰিছে; তেওঁৰ গুটি অনেক পানীৰ কাষত সিঁচা হ’ব, তেওঁৰ ৰজা অগাগতকৈয়ো ওখ হ’ব, তেওঁৰ ৰাজ্যৰ উন্নতি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ঈশ্বৰে মিচৰৰ পৰা তেওঁক উলিয়াই আনিছে; তেওঁৰ বল মেঠনৰ বলৰ নিচিনা। তেওঁ নিজৰ বিৰুদ্ধী জাতিবোৰক গ্ৰাস কৰিব, আৰু তেওঁলোকৰ হাড় গুড়ি কৰিব, আৰু নিজৰ বাণৰ দ্বাৰাই সিহঁতক সৰকাই পেলাব। ");
INSERT INTO asmfb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","তেওঁ সিংহৰ দৰে পৰি শুলে, সিংহীৰ দৰে শয়ন কৰিলে; কোনে তেওঁক জগাব? তোমাক আশীৰ্ব্বাদ দিওঁতা প্ৰতিজন আশীৰ্ব্বাদপ্ৰাপ্ত হওঁক, আৰু তোমাক শাও দিওঁতা প্ৰতিজন অভিশপ্ত হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","তেতিয়া বিলিয়মলৈ বালাকৰ ক্ৰোধ জ্বলি উঠিলত, তেওঁ নিজৰ হাতত চাপৰ মাৰিলে। আৰু বালাকে বিলিয়মক ক’লে, “মোৰ শত্ৰুবোৰক শাও দিবলৈ মই তোমাক অনিলোঁ, কিন্তু চোৱা, তিনিবাৰ তুমি সকলো প্ৰকাৰে তেওঁলোকক আশীৰ্ব্বাদহে কৰিলা। ");
INSERT INTO asmfb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","এই হেতুকে মোক এতিয়াই এৰা আৰু নিজ ঘৰলৈ গুচি যোৱা। মই তোমাক অতিশয় সন্মানিত কৰিম বুলি কৈছিলোঁ, কিন্তু চোৱা, যিহোৱাই তোমাক সন্মানিত হোৱাৰ পৰা আঁতৰাই ৰাখিলে।” ");
INSERT INTO asmfb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","তেতিয়া বিলিয়মে বালাকক ক’লে, “তুমি পঠিওৱা দূতবোৰৰ আগত মই কোৱা নাছিলো নে যে, ");
INSERT INTO asmfb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘যদি বালাকে সোণ আৰু ৰূপেৰে পূৰ হোৱা নিজৰ ৰাজপ্রাসাদো মোক দিয়ে, তথাপি মই নিজ ইচ্ছাৰে ভাল বা বেয়া কাৰ্য কৰিবলৈ যিহোৱাৰ আজ্ঞা উলঙ্ঘন কৰিব নোৱাৰোঁ; যিহোৱাই যিহকে ক’ব, মই তাকেই ক’ম।’ ");
INSERT INTO asmfb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","এতিয়া চোৱা, মই এই স্ব-জাতীয় লোকসকলৰ ওচৰলৈ যাওঁ। আহা, এই জাতিয়ে পাছত তোমাৰ প্ৰজাসকলক কি কৰিব, তাক মই তোমাক জনাওঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","বিলিয়ামে নিজৰ পদ্য গাই ক’লে, বিয়োৰৰ পুত্ৰ বিলিয়মে কৈছে, যাৰ চকু মেলা আছিল, সেই পুৰুষে কৈছে। ");
INSERT INTO asmfb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","এয়েই এজনৰ ভাৱবাণী যি জনে ঈশ্বৰৰ বাক্য শুনে, আৰু সৰ্ব্বোপৰি জনাৰ তত্ব জানে, যি জনে সৰ্ব্বশক্তিমানক দৰ্শন পায়, সেই জনে মাটিত পৰি চকু মেলি কৈছে। ");
INSERT INTO asmfb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","মই তেওঁক দেখিছোঁ, কিন্তু বৰ্ত্তমানে নাই; তেওঁক দৰ্শন পাইছোঁ, কিন্তু তেওঁৰ ওচৰত থকা নাই। যাকোবৰ মাজৰ পৰা এটা তৰা উদয় হ’ব, ইস্ৰায়েলৰ মাজৰ পৰা এক ৰাজ-দণ্ড উঠিব; সেয়ে মোৱাবৰ দীৰ্ঘ-প্ৰস্থ গুড়ি কৰিব, আৰু হুৰামূৰা কৰা গোটেই বংশক সংহাৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","তেওঁৰ শত্ৰু ইদোম এক উত্তৰাধীকাৰ হ’ব, তেওঁৰ শত্ৰু চেয়ীৰেই এক উত্তৰাধীকাৰ হ’ব; তেতিয়া ইস্ৰায়েলে বীৰৰ কাৰ্য কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","যাকোবৰ পৰা উৎপন্ন হোৱা এজনে ৰাজত্ব কৰিব, আৰু নগৰৰ অৱশিষ্ট লোকসকলক বিনষ্ট কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","তেতিয়া বিলিয়মে অমালেকলৈ দৃষ্টি কৰি নিজৰ পদ্য গাই ভৱিষ্যৎ বাণী গাবলৈ ধৰিলে। তেওঁ ক’লে, “এই অমালেক জাতি সমূহৰ মাজত প্ৰথম; কিন্তু তাৰ শেষ-দশা সৰ্ব্বনাশ।” ");
INSERT INTO asmfb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","তেতিয়া বিলিয়মে কেনীয়া সকললৈ দৃষ্টি কৰি নিজৰ পদ্য গাই ক’লে, “তোমাৰ নিবাস অতি দৃঢ়, আৰু তোমাৰ বাহ শিলত পতা। ");
INSERT INTO asmfb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","তথাপি কেনীয়ালোক বিনষ্ট হ’ব, শেষত অচুৰে তোমাক বন্দী কৰি লৈ যাব। ");
INSERT INTO asmfb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","তেতিয়া বিলিয়ামে নিজৰ শেষ পদ্যটি গাই গ’ল। তেওঁ ক’লে, হায় হায়! যেতিয়া ঈশ্বৰে ইয়াক কৰিব, তেতিয়া কোন জীয়াই থাকিব পাৰিব? ");
INSERT INTO asmfb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","আৰু কিত্তীমৰ তীৰৰ পৰা জাহাজবোৰ আহিব; সেইবোৰে অচুৰক ক্লেশ দিব, আৰু এবৰকো ক্লেশ দিব, কিন্তু তেওঁলোকৰো আৰু তাৰো বিনাশ ঘটিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","তেতিয়া বিলিয়মে উঠি গুচি গ’ল। তেওঁ নিজৰ ঘৰলৈ উলটি আহিল আৰু বালাকো নিজৰ বাটে গুচি গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","পাছত ইস্ৰায়েলে চিটীমত বাস কৰিলে আৰু লোকসকলে মোৱাবৰ জীয়ৰীসকলেৰে সৈতে ব্যভিচাৰ কৰিবলৈ ধৰিলে, ");
INSERT INTO asmfb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","কিয়নো সেই জীয়ৰীসকলে তেওঁলোকক নিজ দেৱতাৰ বলিদান দিয়াবলৈ মাতিছিল। তেতিয়া লোকসকলে ভোজন কৰি তেওঁলোকৰ দেৱতাৰ আগত প্ৰণিপাত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ইস্ৰায়েল পিয়োৰৰ বাল দেৱতাত আসক্ত হোৱাত, ইস্ৰায়েলৰ অহিতে যিহোৱাৰ ক্ৰোধ জ্বলি উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","যিহোৱাই মোচিক ক’লে, “যিহোৱাৰ প্ৰচণ্ড ক্ৰোধ ইস্ৰায়েলৰ পৰা গুচিবৰ বাবে, তুমি লোকসকলৰ আটাই মূল মানুহক নি, যিহোৱাৰ উদ্দেশ্যে সূৰ্যৰ সন্মুখত তেওঁলোকক আঁৰি থোৱা।” ");
INSERT INTO asmfb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","তেতিয়া মোচিয়ে ইস্ৰায়েলৰ বিচাৰকৰ্ত্তাসকলক ক’লে, “তোমালোক প্ৰতিজনে পিয়োৰৰ বাল দেৱতাত আসক্ত হোৱা নিজ লোকসকলক বধ কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","পাছত ইস্ৰায়েলৰ সন্তান সকলে সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ মুখত ক্ৰন্দন কৰি থাকোঁতে, মোচিৰ আৰু গোটেই সমাজৰ সাক্ষাতে ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ এজন পুৰুষে নিজ জ্ঞাতিসকলৰ গুৰিলৈ এজনী মিদিয়নীয়া মহিলাক আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","তাকে দেখি, হাৰোণ পুৰোহিতৰ নাতিয়েক ইলিয়াজৰৰ পুত্ৰ পীনহচে সমাজৰ মাজৰ পৰা উঠি হাতত বৰচা ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","সেই ইস্ৰায়েলীয়া পুৰুষৰ পাছে পাছে খেদি গৈ, কোঁঠালিত সোমাই সেই দুই জনক, সেই ইস্ৰায়েলীয়া পুৰুষক আৰু সেই মহিলাগৰাকীৰ পেটত খুচি মাৰিলে। তাতে ইস্ৰায়েলৰ সন্তান সকলৰ মাজৰ পৰা মহামাৰী স্থগিত হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","আৰু যিসকল মহামাৰীত মৰিল, তেওঁলোক চব্বিশ হাজাৰ লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“হাৰোণ পুৰোহিতৰ নাতিয়েক ইলিয়াজৰৰ পুত্ৰ পীনহচে ইস্ৰায়েলৰ মাজত মোৰ অন্তৰ্জ্বালাৰে জ্বলি উঠি ইস্ৰায়েলৰ সন্তান সকলৰ পৰা মোৰ ক্ৰোধ ঘূৰুৱাত মই নিজ অন্তৰ্জ্বালাৰে ইস্ৰায়েলৰ সন্তানসকলক বিনষ্ট নকৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","এই হেতুকে তুমি এই কথা কোৱা, ‘যিহোৱাই কৈছে, চোৱা, মই পিনহচক শান্তিদায়ক নিয়মটিৰ প্ৰতিজ্ঞা সিদ্ধ কৰোঁ; ");
INSERT INTO asmfb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","সেয়ে তেওঁৰ পক্ষে আৰু তেওঁৰ ভাবি-বংশৰ পক্ষেও চিৰস্থায়ী পুৰোহিত পদৰ নিয়ম হ’ব; কিয়নো তেওঁ নিজ ঈশ্বৰৰ পক্ষে অন্তৰ্জ্বালাৰে জ্বলিছিল আৰু ইস্ৰায়েলৰ সন্তানসকলক প্ৰায়শ্চিত্ত কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","হত হোৱা যি ইস্ৰায়েলীয়া পুৰুষক সেই মিদিয়নীয়া তিৰোতাৰ লগত বধ কৰা হৈছিল, তেওঁৰ নাম চালূৰ পুতেক জিম্ৰী, তেওঁ চিমিয়োনীয়াসকলৰ পিতৃ-বংশৰ এজন অধ্যক্ষ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","আৰু সেই হত হোৱা মিদিয়নীয়া মহিলাগৰাকিৰ নাম চূৰৰ জীয়েক কজ্বী, চূৰ মিদিয়নৰ মাজত পিতৃ-বংশৰ লোকসকলৰ মূল মানুহ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","গতিকে যিহোৱাই মোচিক কৈছিল আৰু ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“তুমি মিদিয়নীয়া লোকসকললৈ শত্ৰুতা আচৰণ কৰি সিহঁতক প্ৰহাৰ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","কিয়নো পিয়োৰ দেৱতাৰ বিষয়ে আৰু সেই পিয়োৰৰ কাৰণে মহামাৰীৰ দিনা হত হোৱা তেওঁলোকৰ নিজ জাতিৰ কজ্বী নামেৰে মিদিয়নীয়া অধ্যক্ষৰ জীয়েকৰ বিষয়েও তেওঁলোকে তোমালোকক প্ৰতাৰণা কৰি ছলেৰে তোমালোকলৈ শত্ৰুতা আচৰণ কৰিলে।” ");
INSERT INTO asmfb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","এই মহামাৰীৰ পাছত যিহোৱাই মোচি আৰু হাৰোণৰ পুত্ৰ ইলিয়াজৰ পুৰোহিতক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“তোমালোকে ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীৰ মাজত নিজ নিজ পিতৃ-বংশ অনুসাৰে, ইস্ৰায়েলৰ কাৰণে ৰণলৈ যাব পৰা অৱস্থাত থকা বিশ বছৰ বয়সীয়া আৰু তাতকৈ অধিক বয়সীয়া যিমান লোক আছে, তেওঁলোকক গণনা কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","তেতিয়া মোচি আৰু ইলিয়াজৰ পুৰোহিতে যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ ওচৰত মোৱাবৰ সমথলত লোকসকলক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“মোচিক, আৰু মিচৰ দেশৰ পৰা ওলাই অহা ইস্ৰায়েলৰ সন্তান সকলক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে, বিশ বছৰ বয়সীয়া আৰু তাতকৈ অধিক বয়সীয়া লোকক গণনা কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ৰূবেণ ইস্ৰায়েলৰ জ্যেষ্ঠ পুত্ৰ আছিল। তেওঁৰ পুত্র হনোকৰ পৰা হনোকীয়া গোষ্ঠী, পল্লুৰ পৰা পল্লূইয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","হিষ্রোণৰ পৰা হিষ্ৰোণীয়া গোষ্ঠী, কৰ্ম্মীয়াৰ পৰা কৰ্ম্মীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","এই সকলোৱেই ৰূবেণৰ গোষ্ঠী; তেওঁলোকৰ মাজৰ গণিত লোক তিয়াল্লিশ হাজাৰ সাতশ ত্ৰিশজন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","আৰু পল্লুৰ সন্তান ইলিয়াব আছিল; ইলিয়াবৰ সন্তান সকল নমূৱেল, দাথন, আৰু অবীয়াম আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","কোৰহৰ দলে যেতিয়া যিহোৱাৰ বিৰুদ্ধে বিবাদ কৰিছিল, তেতিয়া মোচি আৰু হাৰোণৰ অহিতে বিবাদ কৰা মণ্ডলীভূক্ত লোক সেই দাথন আৰু অবীৰামেই আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","সেই সময়ত পৃথিৱীয়ে মুখ মেলি তেওঁলোকক আৰু কোৰহকো গ্ৰাস কৰিলে, আৰু তেওঁৰ পাছত চলোঁতাসকলোৰে মৃত্যু হ’ল; সেই সময়ত অগ্নিয়ে দুশ পঞ্চাশ জনক পুৰি ভষ্ম কৰিলে, আৰু তেওঁলোকেই দৃষ্টন্তস্বৰূপ হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","কিন্তু কোৰহৰ সন্তান সকলৰ হ’লে মৃত্যু হোৱা নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকল চিমিয়োনৰ সন্তান: নমূৱেলৰ পৰা নমূৱেলীয়া গোষ্ঠী, যাখীনৰ পৰা যাখীনীয়া গোষ্ঠী, যামীনৰ পৰা যামীনীয়া গোষ্ঠী, যাখীনৰ পৰা যাখীনীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","জেৰহৰ পৰা জেৰহীয়া গোষ্ঠী, চৌলৰ পৰা চৌলীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","চিমিয়োনীয়া গোষ্ঠীবোৰৰ বাইশ হাজাৰ দুশজন লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকল গাদৰ সন্তান: চফোনৰ পৰা চফোনীয়া গোষ্ঠী, হগ্গীয়াৰ পৰা হগ্গীয়া গোষ্ঠী, চূনীৰ পৰা চূনীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","অজনী পৰা অজনীয়া গোষ্ঠী, এৰীৰ পৰা এৰীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","অৰোদৰ পৰা অৰোদীয়া গোষ্ঠী, অৰেলাৰ পৰা অৰেলীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","গাদৰ এই গোষ্ঠীবোৰৰ লোকসকলৰ সংখ্যা চল্লিশ হাজাৰ পাঁচ শ লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","যিহূদাৰ পুত্র এৰ আৰু ওনন আছিল; এই দুজন লোকৰ কনান দেশতেই মৃত্যু হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকল যিহূদাৰ সন্তান: চেলাৰ পৰা চেলানীয়া গোষ্ঠী, পেৰচৰ পৰা পেৰচীয়া গোষ্ঠী, জেৰহৰ পৰা জেৰহীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","পেৰচৰ সন্তান এইসকল: হিষ্ৰোণৰ পৰা হিষ্ৰোণীয়া গোষ্ঠী, হামূলৰ পৰা হামূলীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","যিহূদাৰ এই গোষ্ঠীবোৰৰ লোকসকলৰ সংখ্যা ছয়সত্তৰ হাজাৰ পাঁচ শ লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকল ইচাখৰৰ সন্তান: তোলাৰ পৰা তোলাইয়া গোষ্ঠী, পুব্বাৰ পৰা পুনীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","যাচূবৰ পৰা যাচূবীয়া গোষ্ঠী, চিম্ৰোণৰ পৰা চিম্ৰোণীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ইচাখৰৰ এই গোষ্ঠীবোৰৰ লোকসকলৰ সংখ্যা চৌষষ্ঠী হাজাৰ তিনিশ লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকল জবূলূনৰ সন্তান: চেৰদৰ পৰা চেৰদীয়া গোষ্ঠী, এলোনৰ পৰা এলোনীয়া গোষ্ঠী, যহলেলৰ পৰা যহলেলীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","জবূলূনৰ এই গোষ্ঠীবোৰৰ লোকসকলৰ সংখ্যা ষাঠী হাজাৰ পাঁচশ লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","নিজ নিজ গোষ্ঠী অনুসাৰে যোচেফৰ পুত্ৰ মনচি আৰু ইফ্ৰয়িম আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","মনচিৰ সন্তান এইসকল: মাখীৰৰ পৰা মাখীৰীয়া গোষ্ঠী, সেই গিলিয়দৰ পৰা গিলিয়দীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","গিলিয়দৰ সন্তান এইসকল: ঈয়েজৰৰ পৰা ঈয়েজৰীয়া গোষ্ঠী, হেলকৰ পৰা হেলকীয়া গোষ্ঠী ");
INSERT INTO asmfb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","অস্ৰীয়েলৰ পৰা অস্ৰীয়েলীয়া গোষ্ঠী, চেখমৰ পৰা চেখমীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","চমীদাৰ পৰা চমীদাইয়া গোষ্ঠী, আৰু হেফৰৰ পৰা হেফৰীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","সেই হেফৰৰ পুত্র চলফাদৰ কোনো পুত্ৰ সন্তান নাছিল, কেৱল জীয়েক আছিল। সেই চলফাদৰ জীয়েকসকলৰ নাম মহলা, নোৱা, হগ্লা, মিল্কা, আৰু তিৰ্চা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","এইসকলেই মনচিৰ গোষ্ঠী আছিল যাৰ লোকসকলৰ সংখ্যা বাৱন্ন হাজাৰ সাত শ জন লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","নিজ নিজ গোষ্ঠী অনুসৰি এই লোকসকল ইফ্ৰয়িমৰ সন্তান: চুথেলহৰ পৰা চুথেলহীয়া গোষ্ঠী, বেখৰৰ পৰা বেখৰীয়া গোষ্ঠী, তহনৰ পৰা তহনীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","আৰু চুথেলহৰ সন্তান সকল এই, এৰণৰ পৰা এৰণীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ইফ্ৰয়িমৰ সন্তান সকলৰ এই গোষ্ঠীবোৰৰ বত্ৰিশ হাজাৰ পাঁচ শ লোক আছিল। নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকলেই যোচেফৰ সন্তান। ");
INSERT INTO asmfb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","নিজ নিজ গোষ্ঠী অনুসাৰে বিন্যামীনৰ সন্তান এই লোকসকল: বেলাৰ পৰা বেলাইয়া গোষ্ঠী, অচবেলৰ পৰা অচবেলীয়া গোষ্ঠী, অহীৰামৰ পৰা অহীৰামীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","চুফুফমৰ পৰা চুফমীয়া গোষ্ঠী, হূফমৰ পৰা হূফমীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","আৰু বেলাৰ সন্তান অৰ্দ আৰু নামন আছিল; অৰ্দৰ পৰা অৰ্দীয়া গোষ্ঠী আৰু নামনৰ পৰা নামনীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","নিজ নিজ গোষ্ঠী অনুসাৰে এওঁলোকেই বিন্যামীনৰ সন্তান; তেওঁলোকৰ সংখ্যা পঞ্চল্লিশ হাজাৰ ছশ জন লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","নিজ নিজ গোষ্ঠী অনুসাৰে দানৰ সন্তান এই লোকসকল: চূহমৰ পৰা চুহমীয়া গোষ্ঠী। নিজ নিজ গোষ্ঠী অনুসাৰে এওঁলোকেই দানৰ গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","চুহমীয়াৰ আটাই গোষ্ঠীৰ সংখ্যা চৌষষ্ঠী হাজাৰ চাৰিশ জন লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","নিজ নিজ গোষ্ঠী অনুসাৰে আচেৰৰ সন্তান এই লোকসকল: যিম্নাৰ পৰা যিম্নীয়া গোষ্ঠী, যিচবিৰ পৰা যিচবিয়া গোষ্ঠী, বৰীয়াৰ পৰা বৰীয়াইয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","বৰীয়াৰ সন্তান এই লোকসকল: হেবৰৰ পৰা হেবৰীয়া গোষ্ঠী, মল্কীয়েলৰ পৰা মল্কীয়েলীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","আচেৰৰ জীয়েকৰ নাম চেৰহ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","আচেৰৰ এই গোষ্ঠীবোৰৰ সন্তান সকলৰ সংখ্যা ত্ৰেপন্ন হাজাৰ চাৰিশ জন লোক আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","নিজ নিজ গোষ্ঠী অনুসাৰে নপ্তালীৰ সন্তান এই লোকসকল: যহচিয়েলৰ পৰা যহচিয়েলীয়া গোষ্ঠী, গূণীৰ পৰা গূণীয়া গোষ্ঠী, ");
INSERT INTO asmfb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","যেচৰৰ পৰা যেচৰীয়া গোষ্ঠী, চিল্লেমৰ পৰা চিল্লেমীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","নিজ নিজ গোষ্ঠী অনুসাৰে এই লোকসকল নপ্তালীৰ গোষ্ঠী; তেওঁলোকৰ গণিত লোক পঞ্চল্লিশ হাজাৰ চাৰিশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ইস্ৰায়েলৰ সন্তান সকলৰ মাজত গণনা কৰা লোকসকলৰ সংখ্যা ছয় লাখ এক হাজাৰ সাতশ ত্ৰিশ জন আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“নামৰ সংখ্যা অনুসাৰে উত্তৰাধিকাৰৰ অৰ্থে এই লোকসকলৰ মাজত দেশ ভাগ কৰা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","অধিককে থকা লোকসকলৰ গোষ্ঠীক অধিককৈ উত্তৰাধিকাৰ দিবা, আৰু কমকৈ থকা লোকসকলৰ গোষ্ঠীক কমকৈ দিবা; প্রতিজন পৰিয়ালৰ যিমান গণিত লোক, তাক সেই হিচাপে তাৰ উত্তৰাধীকাৰ দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","কিন্তু চিঠি খেলৰ দ্ৱাৰাই দেশ ভাগ কৰা হ’ব; নিজ নিজ পিতৃ বংশৰ নাম অনুসাৰে তেওঁলোকে উত্তৰাধীকাৰ পাব। ");
INSERT INTO asmfb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","লোক অধিক বা কমে হওঁক, চিঠি খেলৰ দ্বাৰাইহে তেওঁলোকৰ উত্তৰাধীকাৰ তেওঁলোকৰ মাজত ভাগ বাঁটি দিয়া হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","নিজ নিজ গোষ্ঠী অনুসাৰে লেবী ফৈদৰ মাজত গণিত লোক এই সকল: গেৰ্চোনৰ পৰা গেৰ্চোনীয়া গোষ্ঠী, কহাতৰ পৰা কহাতীয়া গোষ্ঠী, মৰাৰীৰ পৰা মৰাৰীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","লেবীয়া গোষ্ঠী এই লোকসকল: লিবনীয়া গোষ্ঠী, হিব্ৰোণীয়া গোষ্ঠী মহলীয়া গোষ্ঠী, মুচীয়া গোষ্ঠী আৰু কোৰহীয়া গোষ্ঠী। ");
INSERT INTO asmfb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","অম্ৰমৰ সন্তান কহাত আছিল; অম্ৰমৰ ভাৰ্য্যাৰ নাম যোকেবদ; তেওঁ লেবীৰ জীয়েক; তেওঁৰ মাকে তেওঁক লেবীসকললৈ মিচৰ দেশত জন্মালে; তেওঁ অম্ৰমলৈ হাৰোণ, মোচি আৰু তেওঁলোকৰ বায়েক মিৰিয়মক জন্মালে। ");
INSERT INTO asmfb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","হাৰোণলৈ নাদব, অবীহূ, ইলিয়াজৰ আৰু ঈথামৰ জন্মিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","কিন্তু নাদব আৰু অবীহূয়ে যিহোৱাৰ সাক্ষাতে সাধাৰণ জুই উৎসৰ্গ কৰোঁতে তেওঁলোকৰ মৃত্যু হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","তেওঁলোকৰ মাজত এমাহ বয়সীয়া আৰু তাতকৈ অধিক বয়সীয়া পুৰুষসকলৰ সংখ্যা তেইশ হাজাৰ জন হ’ল আছিল। কিয়নো, ইস্ৰায়েলৰ সন্তান সকলৰ মাজত তেওঁলোকক কোনো উত্তৰাধিকাৰ নিদিয়াৰ কাৰণে, ইস্ৰায়েলৰ সন্তান সকলৰ মাজত তেওঁলোক গণিত নহ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","এই সকল লোকক মোচি আৰু পুৰোহিত ইলিয়াজৰৰ দ্বাৰাই গণনা কৰা হ’ল; তেওঁলোকে যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ ওচৰত মোৱাবৰ সমথলত ইস্ৰায়েলৰ সন্তান সকলক গণনা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","কিন্তু চীনয় মৰুপ্রান্তত ইস্ৰায়েলৰ সন্তান সকলক গণনা কৰা মোচি আৰু হাৰোণ পুৰোহিতৰ দ্বাৰাই যি লোকসকলক গণনা কৰা হৈছিল, তেওঁলোকৰ এজনো এই লোকসকলৰ মাজত নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","কাৰণ যিহোৱাই তেওঁলোকৰ বিষয়ে কৈছিল যে তেওঁলোকে নিশ্চয়ে মৰুপ্রান্তত মৰিব। এই হেতুকে তেওঁলোকৰ মাজত যিফুন্নিৰ পুত্ৰ কালেব আৰু নুনৰ পুত্ৰ যিহোচূৱাৰ বাহিৰে এজনো অৱশিষ্ট নাথাকিল। ");
INSERT INTO asmfb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","পাছত যোচেফৰ পুত্ৰ মনচিৰ গোষ্ঠীৰ মাজৰ মনচিৰ বৃদ্ধ পৰিনাতি, মাখীৰৰ পৰিনাতি, গিলিয়দৰ নাতি হেফৰৰ পুত্র চলফাদৰ জীয়েক যি মহলা, নোৱা, হগ্লা, মিল্কা আৰু তিৰ্চা, তেওঁলোক মোচিৰ ওচৰলৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","তেওঁলোকে মোচি, পুৰোহিত ইলিয়াজৰ, অধ্যক্ষসকল আৰু গোটেই মণ্ডলীৰ আগত সাক্ষাৎ কৰা তম্বুৰ দুৱাৰ সন্মুখত থিয় হৈ এই কথা ক’লে বোলে, ");
INSERT INTO asmfb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“আমাৰ পিতৃৰ মৰুপ্রান্তত মৃত্যু হ’ল; তেওঁ কোৰহৰ দলৰ মাজত, যিহোৱাৰ বিৰুদ্ধে আলচ পতাসকলৰ দলৰ মাজত নাছিল, তেওঁৰ নিজ পাপতেহে মৃত্যু হৈছিল; অৰ্থাৎ তেওঁৰ নিজ পাপৰ কাৰণেই তেওঁৰ মৃত্যু হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","আমাৰ পিতৃৰ পুত্ৰ সন্তান নথকাত তেওঁৰ গোষ্ঠীৰ মাজৰ পৰা তেওঁৰ নাম কিয় লোপ পাব? আমাৰ পিতৃ বংশৰ ভাইসকলৰ মাজত আমাকো আমাৰ উত্তৰাধীকাৰ দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","তেতিয়া মোচিয়ে সেই বিষয়ে যিহোৱাৰ আগত তেওঁলোকৰ কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","তেতিয়া যিহোৱাই মোচিক কলে, ");
INSERT INTO asmfb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“চলফাদৰ জীয়েকসকলে ঠিকেই কৈছে। তুমি তেওঁলোকৰ পিতৃ বংশৰ ভাইসকলৰ মাজত অৱশ্যে তেওঁলোকক উত্তৰাধিকাৰ দিবা আৰু তেওঁলোকৰ পিতৃৰ উত্তৰাধীকাৰ তেওঁলোকে যেন পাই সেই বিষয়ে নিশ্চিত কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","আৰু ইস্ৰায়েলৰ সন্তান সকলক কোৱা, ‘কোনো এজন লোকৰ যদি মৃত্যু হয় আৰু তেওঁৰ যদি কোনো পুত্ৰ নাথাকে তেতিয়া তোমালোকে তেওঁৰ উত্তৰাধিকাৰ তেওঁৰ জীয়েকক গতাই দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","যদি তেওঁৰ জীয়েক নাথাকে, তেন্তে তেওঁৰ ভায়েক-ককায়েকক তেওঁৰ উত্তৰাধিকাৰ দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","যদি তেওঁৰ কোনো ভাই বা ককাই নাথাকে, তেন্তে তেওঁৰ পিতৃৰ ভাইসকলক তেওঁৰ উত্তৰাধিকাৰ দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","যদি তেওঁৰ পিতৃৰ কোনো ভাই বা ককাই নাথাকে, তেন্তে তাৰ গোষ্ঠীৰ মাজৰ আটাইতকৈ ওচৰৰ সম্বন্ধীয়া লোক জনক তেওঁৰ উত্তৰাধীকাৰ দিবা; আৰু তেওঁ তাক নিজ অধিকাৰ কৰিব। মোচিলৈ কোৱা যিহোৱাৰ আজ্ঞাৰ দৰে এয়ে ইস্ৰায়েলৰ সন্তান সকলৰ স্বত্ববিষয়ক বিধি হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","যিহোৱাই মোচিক পুনৰায় কলে, “তুমি অবাৰীম পৰ্ব্বতত উঠি, যি দেশ মই ইস্ৰায়েলৰ সন্তান সকলক দিলোঁ, তাক চোৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","তাক দেখাৰ পাছত তোমাৰ ভাই হাৰোণৰ নিচিনাকৈ তোমাকো নিজ লোকসকলৰ ওচৰলৈ নিয়া হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","কিয়নো ছিন মৰুপ্রান্তত মণ্ডলীৰ বিবাদত, শিলৰ পৰা জল বৈ যোৱা সময়ত তোমালোকে লোকসকলৰ আগত মোক পবিত্ৰৰূপে মান্য কৰিবলৈ দিয়া আজ্ঞা উলঙ্ঘন কৰিলা।” সেই জল ছিন অৰণ্যৰ কাদেচত থকা মিৰীবাৰ জল। ");
INSERT INTO asmfb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","তেতিয়া মোচিয়ে যিহোৱাক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“হে যিহোৱা, আপুনি সকলোৰে শৰীৰত থকা আত্মাৰ ঈশ্বৰ, আপুনি মণ্ডলীৰ ওপৰত এজন লোকক নিযুক্ত কৰক, যি জন লোকে ");
INSERT INTO asmfb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ইস্ৰায়েলৰ সন্তান সকলৰ আগত অহা-যোৱা কৰিব পাৰে আৰু তেওঁলোকক বাহিৰলৈ-ভিতৰলৈ নিব পাৰে যাতে যিহোৱাৰ মণ্ডলী ৰখীয়া নোহোৱা মেৰৰ জাকৰ নিচিনা নহয়।” ");
INSERT INTO asmfb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","তেতিয়া যিহোৱাই মোচিক ক’লে, “মোৰ আত্মাই বাস কৰা নুনৰ পুত্ৰ যিহোচূৱাক লৈ তেওঁৰ মূৰত হাত দিয়া, ");
INSERT INTO asmfb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","আৰু ইলিয়াজৰ পুৰোহিত আৰু গোটেই মণ্ডলীৰ আগত তেওঁক উপস্থিত কৰি তেওঁলোকৰ আগতে তেওঁলোকক আগবঢ়াই নিবলৈ তেওঁক আদেশ দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীয়ে তেওঁৰ আজ্ঞা মানিবৰ কাৰণে তেওঁক নিজ সন্মানৰ ভাগী কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","তেওঁ পুৰোহিত ইলিয়াজৰ সন্মুখত থিয় হ’ব, আৰু ইলিয়াজৰে তেওঁৰ কাৰণে ঊৰীমৰ বিচাৰৰ দ্বাৰাই যিহোৱাক সুধিব, তেতিয়া তেওঁ আৰু তেওঁৰ লগত ইস্ৰায়েলৰ সকলো সন্তান সকলে, গোটেই মণ্ডলীয়ে সৈতে ইলিয়াজৰৰ আজ্ঞাতে বাহিৰলৈ-ভিতৰলৈ অহা-যোৱা কৰিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","পাছত মোচিয়ে যিহোৱাই দিয়া আজ্ঞাৰ দৰেই কাৰ্য কৰিলে; তেওঁ যিহোচূৱাক নি, গোটেই মণ্ডলীৰ আগত উপস্থিত কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","তেওঁ তেওঁৰ মূৰত হাত দি, মোচিৰ দ্বাৰাই কোওৱা যিহোৱাৰ বাক্য অনুসাৰে তেওঁক আদেশ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“তুমি ইস্ৰায়েলৰ সন্তানসকলক আজ্ঞা দিয়া আৰু কোৱা, ‘তেওঁলোকে যেন মোৰ উপহাৰ আৰু মোৰ সুঘ্ৰাণাৰ্থক মোৰ ভক্ষ্যস্বৰূপ মোৰ অগ্নিকৃত উপহাৰ নিজ নিজ নিয়মিত সময়ত মোৰ অৰ্থে উৎসৰ্গ কৰিবৰ বাবে তেওঁলোক যেন সজাগে থাকে’। ");
INSERT INTO asmfb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","এই হেতুকে তুমি ইয়াকো তেওঁলোকক কোৱা যে, ‘তোমালোকে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিব লগা অগ্নিকৃত উপহাৰ এই, প্ৰতিদিনে নিত্য হোমৰ অৰ্থে দুটা এবছৰীয়া নিঘূণ মতা মেৰ পোৱালি ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","এটা মেৰ পোৱালি ৰাতিপুৱা উৎসৰ্গ কৰিবা আৰু আনটো মেৰ পোৱালি সন্ধিয়া পৰত উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","আৰু ভক্ষ্য নৈবেদ্যৰ কাৰণে হীনৰ চাৰিভাগৰ এভাগ খুন্দি উলিওৱা তেল মিহলোৱা ঐফাৰ দহ ভাগৰ এভাগ মিহি আটাগুড়ি ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","এয়ে নিত্য হোম; যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণাৰ্থক অগ্নিকৃত উপহাৰস্বৰূপে চীনয় পৰ্ব্বতত এই আজ্ঞাই নিৰূপিত হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","আৰু তাৰ প্ৰথম মেৰ পোৱালিৰ কাৰণে হীনৰ চাৰি ভাগৰ এভাগ তাৰ পেয় নৈবেদ্য হ’ব; তুমি পবিত্ৰ স্থানত যিহোৱাৰ উদ্দেশ্যে পেয় নৈবেদ্যস্বৰূপে ৰাগীয়াল ৰস ঢালি দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","আৰু দ্বিতীয় মেৰ পোৱালিটো সন্ধিয়া পৰত উৎসৰ্গ কৰিবা; ৰাতিপুৱা দিয়া ভক্ষ্য নৈবেদ্য আৰু তাৰ পেয় নৈবেদ্যৰ দৰে তাকো যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণাৰ্থক অগ্নিকৃত উপহাৰস্বৰূপে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","আৰু বিশ্ৰাম-দিনত দুটা এবছৰীয়া নিঘূণ মতা মেৰ পোৱালি, আৰু তেল মিহলোৱা ঐফাৰ দহ ভাগৰ দুভাগ ভক্ষ্য নৈবেদ্য আৰু তাৰ পেয় নৈবেদ্য উৎসৰ্গ কৰিবা;। ");
INSERT INTO asmfb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","নিত্য হোম আৰু পেয় নৈবেদ্যৰ বাহিৰেও প্ৰতি বিশ্ৰাম-বাৰে এই হোম হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","আৰু প্ৰত্যেক মাহৰ আৰম্ভণিতে তোমালোকে যিহোৱাৰ উদ্দেশ্যে হোমৰ বাবে দুটা দমৰা গৰু, এটা মতা মেৰ আৰু সাতোটা নিঘূণ মতা মেৰ পোৱালি, এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","আৰু প্ৰত্যেক দমৰা গৰুৰ কাৰণে ভক্ষ্য নৈবেদ্যস্বৰূপে ঐফাৰ দহ ভাগৰ তিনি ভাগ, তেল মিহলোৱা মিহি আটাগুড়ি, আৰু মতা মেৰটোৰ কাৰণে ভক্ষ্য নৈবেদ্যস্বৰূপে দহ ভাগৰ দুভাগ, তেল মিহলোৱা মিহি আটাগুড়ি, ");
INSERT INTO asmfb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","আৰু প্ৰত্যেক মেৰ পোৱালিৰ কাৰণে ভক্ষ্য নৈবেদ্যস্বৰূপে দহ ভাগৰ এভাগ, তেল মিহলোৱা মিহি আটাগুড়ি উৎসৰ্গ কৰিবা; সেয়ে সুঘ্ৰাণাৰ্থক হোম-বলি, যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","আৰু প্ৰত্যেক দমৰা গৰুৰ কাৰণে হীনৰ আধা ভাগ, আৰু মতা মেৰটোৰ কাৰণে হীনৰ তিনি ভাগৰ এভাগ আৰু প্ৰত্যেক মেৰ পোৱালিৰ কাৰণে হীনৰ চাৰিভাগৰ এভাগ দ্ৰাক্ষাৰস সেইবোৰৰ পেয় নৈবেদ্য হ’ব; এয়ে বছৰৰ প্ৰত্যেক মাহত কৰিব লগীয়া মাহেকীয়া হোম। ");
INSERT INTO asmfb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","আৰু যিহোৱাৰ উদ্দেশ্যে পাপাৰ্থক বলিস্বৰূপে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম আৰু তাৰ পেয় নৈবেদ্যৰ বাহিৰেও ইয়াক কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","পাছত প্ৰথম মাহৰ চতুৰ্দ্দশ দিনা যিহোৱাৰ নিস্তাৰ-পৰ্ব্ব হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","আৰু সেই মাহৰ পঞ্চদশ দিনা উৎসৱ হ’ব, সাত দিন খমীৰ নিদিয়া পিঠা ভোজন কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","প্ৰথম দিনা পবিত্ৰ সভা হ’ব; সেই দিনা তোমালোকে কোনো ব্যৱসায় কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","কিন্তু যিহোৱাৰ উদ্দেশ্যে হোম-বলিৰ অৰ্থে অগ্নিকৃত উপহাৰস্বৰূপে দুটা দমৰা গৰু, এটা মতা মেৰ আৰু সাতোটা এবছৰীয়া মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা; সেইবোৰ নিঘূণ পশু হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","আৰু প্ৰত্যেক দমৰা গৰুৰ কাৰণে দহ ভাগৰ তিনিভাগ, মতা মেৰটোৰ কাৰণে দহ ভাগৰ দুভাগ। ");
INSERT INTO asmfb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","আৰু মেৰ পোৱালি সাঁতোটাৰ প্ৰত্যেক পোৱালিৰ কাৰণে দহ ভাগৰ এভাগ, তেল মিহলোৱা মিহি আটাগুড়ি সেইবোৰৰ ভক্ষ্য নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","আৰু তোমালোকক প্ৰায়শ্চিত্ত কৰিবলৈ পাপাৰ্থক বলিস্বৰূপে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","নিত্য হোমৰ অৰ্থে ৰাতিপুৱাৰ যি হোম-বলি, তাৰ বাহিৰেও এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","এই নিয়ম অনুসাৰে তোমালোকে সাত দিনলৈকে প্ৰতি দিনে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে ভক্ষ্যস্বৰূপ অগ্নিকৃত উপহাৰ উৎসৰ্গ কৰিবা; নিত্য হোম আৰু তাৰ পেয় নৈবেদ্যৰ বাহিৰেও ইয়াক উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","আৰু সপ্তম দিনা তোমালোকৰ পবিত্ৰ সভা হ’ব। সেই দিনা তোমালোকে কোনো ব্যৱসায় কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","যি দিনা তোমালোকে সাত সপ্তাহৰ অন্তত হোৱা পৰ্ব্বত যিহোৱালৈ কোনো নতুন ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰা, প্ৰথমে পকা ফল দিয়া সেই দিনা তোমালোকৰ পবিত্ৰ সভা হ’ব। সেই দিনা কোনো ব্যৱসায় কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","কিন্তু যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে হোম-বলিস্বৰূপে দুটা দমৰা গৰু, এটা মতা মেৰ আৰু সাতোটা এবছৰীয়া মতা মেৰ পোৱালি ");
INSERT INTO asmfb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","আৰু প্রত্যেক দমৰা গৰুৰ কাৰণে দহ ভাগৰ তিনি ভাগ, মতা মেৰটোৰ কাৰণে দহ ভাগৰ দুভাগ। ");
INSERT INTO asmfb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","আৰু মেৰ পোৱালি সাঁতোটাৰ প্ৰত্যেক পোৱালিৰ কাৰণে দহ ভাগৰ এভাগ, তেল মিহলোৱা মিহি আটাগুড়ি সেইবোৰৰ ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","আৰু তোমালোকক প্ৰায়শ্চিত্ত কৰিবলৈ এটা মতা ছাগলী উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে আৰু এইবোৰৰ পেয় নৈবেদ্য উৎসৰ্গ কৰিবা; এই সকলো নিঘূণ পশু হ’ব লাগিব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","আৰু সপ্তম মাহত, মাহৰ প্ৰথম দিনা যিহোৱাৰ সন্মানৰ অৰ্থে তোমালোকৰ পবিত্ৰ সভা হ’ব। সেই দিনা তোমালোকৰ কোনো দৈনন্দিন ব্যৱসায় কৰ্ম নকৰিবা। সেই দিনা তোমালোকৰ তূৰী বজোৱা দিন হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","সেই দিনা তোমালোকে যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে হোম-বলিস্বৰূপে এটা দমৰা গৰু, এটা মতা মেৰ আৰু সাতোটা নিঘূণ এবছৰীয়া মতা মেৰ পোৱালি ৰাখিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","আৰু সেই দমৰা গৰুটোৰ কাৰণে দহ ভাগৰ তিনি ভাগ, মতা মেৰটোৰ কাৰণে দহ ভাগৰ দুভাগ, ");
INSERT INTO asmfb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","আৰু মেৰ পোৱালিৰ সাঁতোটাৰ প্ৰত্যেক পোৱালিৰ কাৰণে দহ ভাগৰ এভাগ, তেল মিহলোৱা মিহি আটাগুড়ি সেইবোৰৰ ভক্ষ্য নৈবেদ্য উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","আৰু তোমালোকক প্ৰায়শ্চিত্ত কৰিবলৈ পাপাৰ্থক বলিস্বৰূপে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","নতুন জোনৰ হোম-বলি আৰু তাৰ ভক্ষ্য নৈবেদ্য, নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য নৈবেদ্য আৰু সেইবোৰৰ পেয় নৈবেদ্যৰ বাহিৰেও, সেইবোৰৰ বিধিমতে তোমালোকে সুঘ্ৰাণৰ অৰ্থে যিহোৱাৰ উদ্দেশ্যে অগ্নিকৃত উপহাৰ স্বৰূপে সেই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","সেই সপ্তম মাহৰ দশম দিনা যিহোৱাৰ সন্মানৰ অৰ্থে তোমালোকৰ পবিত্ৰ সভা হ’ব; সেই দিনা তোমালোকে নিজ নিজ প্ৰাণক দুখ দিবা আৰু কোনো কাৰ্য নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","কিন্তু যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে হোম-বলি স্বৰূপে এটা দমৰা গৰু, এটা মতা মেৰ আৰু সাতোটা এবছৰীয়া মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা; আৰু সেইবোৰ নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","আৰু দমৰা গৰুটোৰ কাৰণে দহ ভাগৰ তিনি ভাগ, মতা মেৰটোৰ কাৰণে দহ ভাগৰ দুভাগ, ");
INSERT INTO asmfb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","আৰু মেৰ পোৱালি সাঁতোটাৰ প্ৰত্যেক পোৱালিৰ কাৰণে দহ ভাগৰ এভাগ, তেল মিহলোৱা মিহি আটাগুড়ি সেইবোৰৰ ভক্ষ্য নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","আৰু পাপাৰ্থক বলিস্বৰূপে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। প্ৰায়শ্চিত্তৰ পাপাৰ্থক বলিৰ, নিত্য হোম বলিৰ, তাৰ ভক্ষ্য নৈবেদ্যৰ আৰু সেইবোৰৰ পেয় নৈবেদ্যৰ বাহিৰেও, এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","আৰু সপ্তম মাহৰ পঞ্চদশ দিনা যিহোৱাৰ সন্মানৰ উদ্দেশ্যে তোমালোকৰ পবিত্ৰ সভা হ’ব। সেই দিনা তোমালোকে কোনো দৈনন্দিন ব্যৱসায় কৰ্ম নকৰিবা আৰু তোমালোকে সাত দিনলৈকে যিহোৱাৰ উদ্দেশ্যে উৎসৱ পালন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","আৰু যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে অগ্নিকৃত উপহাৰস্বৰূপে হোম-বলিৰ কাৰণে তেৰটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা; আৰু সেইবোৰ প্রত্যেকটিয়েই নিৰ্ঘূণী পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","আৰু দমৰা গৰু তেৰটাৰ প্ৰত্যেক গৰুৰ কাৰণে দহ ভাগৰ তিনি ভাগ আৰু মতা মেৰ দুটাৰ প্ৰত্যেক মেৰৰ কাৰণে দহ ভাগৰ দুভাগ, ");
INSERT INTO asmfb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","আৰু মতা মেৰ পোৱালি চৌধ্যটাৰ প্ৰত্যেক মেৰ পোৱালিৰ কাৰণে দহ ভাগৰ এভাগ, তেল মিহলোৱা মিহি আটাগুড়ি সেইবোৰৰ ভক্ষ্য নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","আৰু পবিত্র সভাৰ দ্বিতীয় দিনা বাৰটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া নিঘূণ মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা; আৰু সেইবোৰ প্রত্যেকটি নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","আৰু দমৰা গৰুৰ, মেৰৰ আৰু মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধিমতে সেইবোৰৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব; আৰু পাপাৰ্থক বলিৰ নিমিত্তে এটা মতা ছাগলী আজ্ঞা দিয়াৰ দৰেই উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য ও সেইবোৰৰ পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","আৰু পবিত্র সভাৰ তৃতীয় দিনা এঘাৰটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া নিঘূণ মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা, আৰু সেইবোৰ নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","আৰু দমৰা গৰুৰ, মেৰৰ আৰু মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধিমতে সেইবোৰৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","আৰু পাপাৰ্থক বলিৰ অৰ্থে এটা মতা ছাগলী, উৎসৰ্গ কৰিবা। নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","আৰু পবিত্র সভাৰ চতুৰ্থ দিনা দহোটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া নিঘূণী মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা আৰু প্রত্যেকটি নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","আৰু দমৰা গৰুৰ, মেৰৰ, আৰু মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধি অনুসাৰে সেইবোৰৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","আৰু পঞ্চম দিনা নটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া নিঘূণ মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা, আৰু প্রত্যেকটি নিঘুণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","আৰু দমৰা গৰুৰ, মেৰৰ, মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধি অনুসাৰে সেইবোৰৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব; ");
INSERT INTO asmfb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","আৰু পবিত্র সভাৰ ষষ্ঠ দিনা আঠোটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা আৰু প্রত্যেকটি নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","আৰু দমৰা গৰুৰ, মেৰৰ আৰু মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধিমতে সেইবোৰৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম-বলি আৰু তাৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","আৰু সপ্তম দিনা সাতোটা দমৰা গৰু, দুটা মতা মেৰ আৰু চৌধ্যটা এবছৰীয়া মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা আৰু প্রত্যেকটি নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","আৰু দমৰা গৰুৰ, মেৰৰ আৰু মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধিমতে সেইবোৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম বলি আৰু তাৰ ভক্ষ্য নৈবেদ্য আৰু তাৰ পেয় নৈবেদ্যবোৰৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","অষ্টম দিনা তোমালোকৰ আৰু এখন ধৰ্মীয় সভা হ’ব। সেইদিনা তোমালোকে কোনো দৈনন্দিন ব্যৱসায়ৰ কৰ্ম নকৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","কিন্তু যিহোৱাৰ উদ্দেশ্যে সুঘ্ৰাণৰ অৰ্থে অগ্নিকৃত উপহাৰ স্বৰূপে হোম বলিৰ কাৰণে এটা দমৰা গৰু এটা মতা মেৰ আৰু সাতোটা এবছৰীয়া মতা মেৰ পোৱালি উৎসৰ্গ কৰিবা আৰু প্রত্যেকটি নিঘূণ পশু হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","আৰু দমৰা গৰুৰ, মেৰৰ আৰু মেৰ পোৱালিৰ সংখ্যা অনুসাৰে বিধিমতে সেইবোৰৰ ভক্ষ্য আৰু পেয় নৈবেদ্য হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","আৰু পাপাৰ্থক বলিৰ কাৰণে এটা মতা ছাগলী উৎসৰ্গ কৰিবা। নিত্য হোম আৰু তাৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ বাহিৰেও তোমালোকে এই সকলোকে উৎসৰ্গ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","সঙ্কল্প সিদ্ধ কৰিবৰ কাৰণে দিয়া আৰু ইচ্ছামতে এনেই দিয়া তোমালোকৰ উপহাৰৰ বাহিৰে, তোমালোকৰ ভক্ষ্য ও পেয় নৈবেদ্যৰ কাৰণে আৰু তোমালোকৰ মঙ্গলাৰ্থক বলিৰ কাৰণে এইবোৰ তোমালোকৰ নিজৰ নিৰূপিত পৰ্ব্ববোৰত যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","মোচিয়ে যিহোৱাৰ পৰা পোৱা সকলো আজ্ঞা অনুসাৰে ইস্ৰায়েলৰ সন্তান সকলক এই সকলো কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","পাছত মোচিয়ে ইস্ৰায়েলৰ সন্তান সকলৰ ফৈদৰ মূল লোকসকলক ক’লে। তেওঁ ক’লে, যিহোৱাই এই আজ্ঞা দিছে। ");
INSERT INTO asmfb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","কোনো পুৰুষে যদি যিহোৱাৰ উদ্দেশ্যে সঙ্কল্প কৰে বা ব্ৰত-বন্ধনেৰে নিজ প্ৰাণ বন্ধ কৰিবলৈ শপত কৰে, তেন্তে তেওঁ নিজৰ বাক্য ব্যৰ্থ নকৰি, নিজৰ মুখৰ পৰা ওলোৱা আটাই বাক্য সিদ্ধ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","আৰু কোনো মহিলাই যদি জীয়াৰী কালত পিতৃৰ ঘৰত থাকোঁতে যিহোৱাৰ উদ্দেশ্যে কোনো সঙ্কল্প কৰে বা ব্ৰত-বন্ধনেৰে নিজকে বন্ধ কৰে ");
INSERT INTO asmfb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","আৰু তাইৰ পিতৃয়ে যদি, তাই সঙ্কল্প কৰা, বা ব্ৰত-বন্ধনেৰে তাই নিজকে বন্ধ কৰা কথা শুনিও, তাইক একো নকৈ মনে মনে থাকে, তেন্তে তাইৰ সকলো সঙ্কল্প সিদ্ধ কৰিব লাগিব আৰু বন্ধনেৰে তাই নিজকে বন্ধ কৰে, তাকো সিদ্ধ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","কিন্তু শুনা দিনা যদি তাইৰ পিতৃয়ে তাইক নিষেধ কৰে, তেন্তে তাইৰ সঙ্কল্প বা যি বন্ধনেৰে তাই নিজকে বন্ধ কৰিলে, সেই আটাই কথা সিদ্ধ কৰিব নালাগিব; আৰু তাইৰ পিতৃয়ে নিষেধ কৰা হেতুকে যিহোৱাই তাইক ক্ষমা দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","আৰু তাই সঙ্কল্পৰ অধীন থকা বা অবিবেচনাৰূপে মুখৰ পৰা ওলোৱা বাক্যেৰে নিজকে বন্ধ কৰা কালত, যদি তাইক বিয়া দিয়া হয়, ");
INSERT INTO asmfb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","আৰু তাইৰ স্বামীয়ে তাক শুনিও, শুনা দিনা তাইক একো নকৈ মনে মনে থাকে, তেন্তে তাইৰ সঙ্কল্পবোৰ সিদ্ধ কৰিব লাগিব বা যি যি বন্ধনেৰে তাই নিজকে বন্ধ কৰিলে, তাকো সিদ্ধ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","কিন্তু শুনা দিনা যদি তাইৰ স্বামীয়ে তাইক নিষেধ কৰে, তেন্তে তাই যি সঙ্কল্পৰ অধীন আৰু অবিবেচনাৰূপে নিজৰ মুখৰ পৰা ওলোৱা যি বাক্যৰ দ্বাৰাই তাই নিজকে বন্ধ কৰিলে, স্বামীয়ে তাক ব্যৰ্থ কৰিব আৰু যিহোৱাই তাইক ক্ষমা দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","কিন্তু বাঁৰী বা স্বামীয়ে ত্যাগ কৰা মহিলাই সঙ্কল্প আদি বন্ধনেৰে নিজকে বন্ধ কৰা সকলো কথা সিদ্ধ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","আৰু তেওঁ যদি স্বামীৰ ঘৰত থাকোঁতে সঙ্কল্প কৰে বা শপত কৰি নিজকে ব্ৰত বন্ধনেৰে বন্ধ কৰে, ");
INSERT INTO asmfb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","আৰু তাইৰ স্বামীয়ে সেই বিষয়ে শুনি তাইক একো নকৈ যদি মনে মনে থাকে, তাইক নিষেধ নকৰে, তেন্তে তাইৰ সকলো সঙ্কল্প সিদ্ধ কৰিব লাগিব। আৰু তাই যি বন্ধনেৰে নিজকে বন্ধ কৰিলে, তাকো সিদ্ধ কৰিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","কিন্তু শুনা দিনা তাইৰ স্বামীয়ে যদি সেই সকলোকে কোনো ৰূপে ব্যৰ্থ কৰে, তেন্তে তাইৰ সঙ্কল্প আৰু তাইৰ ব্ৰত-বন্ধনৰ বিষয়ে তাইৰ মুখৰ পৰা যি বাক্য ওলাইছিল, তাকো সিদ্ধ কৰিব নালাগিব। তাইৰ স্বামীয়ে তাক ব্যৰ্থ কৰিলে আৰু যিহোৱাই তাইক ক্ষমা দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","মহিলাৰ প্ৰত্যেক সঙ্কল্প আৰু নিজকে দুখ দিবলৈ নিজকে বন্ধ কৰা শপত তাইৰ স্বামীয়ে সিদ্ধও কৰিব পাৰে, তাইৰ স্বামীয়ে তাক ব্যৰ্থও কৰিব পাৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","কিন্তু তাইৰ স্বামীয়ে যদি কেইবা দিনলৈকে তাইক একো নকৈ সকলোভাৱে মনে মনে থাকে, তেন্তে তাইৰ সকলো সঙ্কল্প আৰু নিজকে বন্ধ কৰা সকলো কথা সিদ্ধ কৰিব লগীয়া কৰে। কিয়নো শুনা দিনা একো নকৈ মনে মনে থকাত, সি তাক সিদ্ধ কৰিব লগীয়া কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","কিন্তু তাক শুনাৰ পাছত যদি কোনোৰূপে সি তাক ব্যৰ্থ কৰে, তেন্তে স্বামীয়ে তাইৰ অপৰাধৰ ফল ভোগ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","স্বামী আৰু ভাৰ্য্যাৰ বিষয়ে, পিতৃয়ে আৰু যৌৱন কালত তেওঁৰ ঘৰত থকা জীয়েকৰ বিষয়ে যিহোৱাই মোচিক আজ্ঞা দিয়া বিধি এইবোৰ। ");
INSERT INTO asmfb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলৰ কাৰণে মিদিয়নীয়াসকলৰ প্ৰতিকাৰ সাধা; তেনে কৰি উঠি তোমাৰ মৃত্যু হ’ব আৰু নিজ লোকসকলৰ মাজত তোমাক নিয়া হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","তেতিয়া মোচিয়ে লোকসকলক ক’লে, “যিহোৱাৰ কাৰণে মিদিয়নৰ প্ৰতিকাৰ সাধিবলৈ, মিদিয়নৰ বিৰুদ্ধে যুদ্ধযাত্ৰা কৰিবৰ কাৰণে তোমালোকৰ মাজৰ কিছুমান লোকক যুদ্ধলৈ সুসজ্জিত কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","তোমালোকে ইস্ৰায়েলৰ প্রত্যেকখন ফৈদৰ পৰা এক এক হাজাৰ লোকক যুদ্ধলৈ পঠিয়াবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","তেতিয়া ইস্ৰায়েলৰ প্রত্যেক গোষ্ঠী অনুসাৰে এক এক হাজাৰ লোকক যুদ্ধৰ বাবে যুগুত কৰা হ’ল। এইদৰে যুদ্ধলৈ সুসজ্জিত হোৱা বাৰ হাজাৰ জন লোকক উলিওৱা হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","তাৰ পাছত মোচিয়ে, প্ৰত্যেকখন ফৈদৰ পৰা এক এক হাজাৰ লোকৰ সৈতে পুৰোহিত ইলিয়াজৰৰ পুত্ৰ পীনহচক যুদ্ধলৈ পঠিয়ালে; পবিত্ৰ স্থানৰ বস্তু, ৰণ বাদ্যৰ অৰ্থে কালি সেই পীনহচৰ হাতত আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে তেওঁলোকে মিদিয়নৰ বিৰুদ্ধে যুদ্ধ কৰি তেওঁলোকৰ সকলো পুৰুষকে বধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","আৰু তেওঁলোকে আন আন হত লোকৰ লগত মিদিয়নৰ ৰজাসকলক, অৰ্থাৎ ইবী, ৰেকম, চূৰ, হূৰ আৰু ৰেবা, এই মিদিয়নীয়া পাঁচজন ৰজাক বধ কৰিলে; আৰু বিয়োৰৰ পুত্র বিলিয়মকো তেওঁলোকে তৰোৱালেৰে বধ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ইস্ৰায়েলৰ সৈন্যসকলে মিদিয়নৰ সকলো মহিলা, তেওঁলোকৰ ল’ৰা-ছোৱালী বন্দী কৰি লৈ গ’ল, আৰু তেওঁলোকৰ গৰু, মেৰ-ছাগৰ জাক আদি সকলো সম্পত্তি লুটি লৈ গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","তেওঁলোকে যি যি ঠাইত বাস কৰিছিল, তেওঁলোকৰ সেই সকলো নগৰ আৰু তেওঁলোকৰ আটাই ছাউনিবোৰ জ্ৱলাই দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","তেওঁলোকে লুট-দ্রব্য আৰু বনদীবোৰক আৰু তাৰে সৈতে সকলো পশুৰ জাকবোৰ লগত ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","তেওঁলোকে যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ পাৰৰ মোৱাবৰ সমথলত থকা ছাউনিলৈ, মোচি, পুৰোহিত ইলিয়াজৰ আৰু ইস্ৰায়েলৰ সন্তান সকলৰ গোটেই মণ্ডলীৰ গুৰিলৈ, সেই বন্দী কৰি নিয়া লোকবোৰ, যুদ্ধত ধৰা পশুবোৰ, আৰু লুটি লোৱা সম্পত্তিবোৰ আনিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","তেতিয়া মোচি, পুৰোহিত ইলিয়াজৰ আৰু মণ্ডলীৰ আটাই অধ্যক্ষসকলে তেওঁলোকক সাক্ষাৎ কৰিবলৈ ছাউনিৰ বাহিৰলৈ ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","তেতিয়া যুদ্ধৰ পৰা উভটি অহা সহস্ৰপতি আৰু শতপতি, এই সেনাপতিসকলৰ ওপৰত মোচিৰ খং উঠিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","মোচিয়ে তেওঁলোকক ক’লে, “তোমালোকে মহিলাসকলক জীয়াই ৰাখিছা নেকি? ");
INSERT INTO asmfb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","চোৱা, বিলিয়মৰ পৰামৰ্শত তেওঁলোকে পিয়োৰ দেৱতাৰ কথাত ইস্ৰায়েলৰ সন্তান সকলক যিহোৱাৰ বিৰুদ্ধে সত্যলঙ্ঘন কৰাইছিল; সেই কাৰণেই যিহোৱাৰ মণ্ডলীত মহামাৰী হৈ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","এতিয়া এই হেতুকে, তোমালোকে শিশুবোৰৰ মাজৰ আটাই ল’ৰাবোৰক বধ কৰা, আৰু পুৰুষৰে সৈতে শয়ন কৰা সকলো মহিলাক বধ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","কিন্তু ছোৱালীসকলৰ মাজৰ যিবোৰে পুৰুষৰে সৈতে কেতিয়াও শয়ন কৰা নাই, তেওঁলোকক তোমালোকে নিজৰ কাৰণে ৰাখা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","তোমালোকে সাত দিনলৈকে ছাউনিৰ বাহিৰত ছাউনি পাতি থাকা; তোমালোকৰ যিমান লোকে বধ কৰিছা বা হত হোৱা লোককো চুইছা, তোমালোকৰ সেই সকলোৱে আৰু বন্দী কৰি অনা লোকসকলক তৃতীয় আৰু সপ্তম দিনা শুচি কৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","আৰু সকলো কাপোৰ, ছালেৰে সজা বা মেৰ-ছাগৰ নোমেৰে যুগুত কৰা বা কাঠেৰে সজা আটাই বস্তুৰ বিষয়ে তোমালোকে নিজৰ কাৰণে শুচি কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","পাছত পুৰোহিত ইলিয়াজৰে ৰণলৈ যোৱা লোকসকলক ক’লে, “যিহোৱাই মোচিক দিয়া ব্যৱস্থাৰ এয়াও এক বিধি বোলে: ");
INSERT INTO asmfb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","কেৱল সোণ, ৰূপ, পিতল, লোহা, বগীতাম, ");
INSERT INTO asmfb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","আৰু সীহ আদি যিবোৰ বস্তু জুইত নুপোৰে, সেই সকলোকে জুইৰ মাজেদি নিবা, তেতিয়া সেয়া শুচি হ’ব। তাৰ পাছত তোমালোকে তাক অশুচিতা-নাশক জলৰ দ্বাৰাই শুচি কৰিব লাগিব; কিন্তু যি যি বস্তু জুইত পোৰে, তাক প্রথমে তোমালোকে সেই পানীৰে শুচি কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","আৰু সপ্তম দিনা তোমালোকে নিজ নিজ কাপোৰ ধুবা, তেতিয়া তোমালোক শুচি হ’বা; তাৰ পাছত তোমালোকে ছাউনিত সোমাব পাৰিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","যিহোৱাই পুনৰায় মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“তুমি, পুৰোহিত ইলিয়াজৰ আৰু মণ্ডলীৰ পিতৃ-বংশৰ অধ্যক্ষসকল, যুদ্ধত ধৰা মানুহ বা পশু সেই আটাই লুট-দ্রব্যৰ লেখ লোৱা; ");
INSERT INTO asmfb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","আৰু সেইবোৰ দুভাগ কৰি, এভাগ ৰণলৈ যোৱা লোকসকল আৰু এভাগ গোটেই মণ্ডলীৰ মাজত ভাগ কৰি দিয়া; ");
INSERT INTO asmfb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","আৰু যুদ্ধলৈ যোৱা লোকসকলৰ পৰা মানুহ, গৰু, গাধ, আৰু মেৰ-ছাগ বা ছাগলীৰ পাঁচ শ পাঁচ শ প্ৰাণীৰ মাজৰ এটা এটা প্ৰাণী যিহোৱাৰ কাৰণে কৰস্ৱৰুপে লোৱা; ");
INSERT INTO asmfb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","তেওঁলোকৰ আধা ভাগৰ পৰা তাক লৈ, যিহোৱাৰ উত্তোলনীয় উপহাৰস্বৰূপে পুৰোহিত ইলিয়াজৰক দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","আৰু ইস্ৰায়েলৰ সন্তান সকলৰ আধা ভাগৰ পৰা মানুহ, গৰু, গাধ আৰু মেৰ-ছাগৰ জাক আদি আটাই প্ৰাণীৰেই পঞ্চাশটা পঞ্চাশটাৰ মাজৰ পৰা এটা লৈ যিহোৱাৰ আবাসৰ ৰখীয়া লেবীয়াসকলক দিয়া।” ");
INSERT INTO asmfb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","তেতিয়া মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে মোচি আৰু পুৰোহিত ইলিয়াজৰে সেই কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ৰণুৱাসকলে লুটি অনা সম্পত্তিৰ বাহিৰে ধৰি অনা প্ৰাণীৰ সংখ্যা এইদৰে: ছয় লাখ পঁয়সত্তৰ হাজাৰ মেৰ-ছাগ ");
INSERT INTO asmfb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","বাসত্তৰ হাজাৰ ষাঁড়-গৰু, ");
INSERT INTO asmfb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","এষষ্ঠী হাজাৰ গাধ, ");
INSERT INTO asmfb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","আৰু কেতিয়াও পুৰুষে সৈতে শয়ন নকৰা ছোৱালীৰ সংখ্যা সৰ্ব্বমুঠ বত্ৰিশ হাজাৰ আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","যুদ্ধলৈ যোৱা সৈন্যসকলৰ আধা ভাগ প্ৰাণীৰ সংখ্যা তিনি লাখ সাতত্ৰিশ হাজাৰ পাঁচ শ মেৰ-ছাগ; ");
INSERT INTO asmfb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","সেই মেৰ-ছাগবোৰৰ পৰা লোৱা যিহোৱাৰ কৰ ছশ পঁয়সত্তৰটা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ষাঁড়-গৰু ছয়ত্ৰিশ হাজাৰ; সেইবোৰৰ মাজৰ পৰা লোৱা যিহোৱাৰ কৰ বাসত্তৰটা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","গাধবোৰৰ সংখ্যা ত্ৰিশ হাজাৰ পাঁচশ আছিল আৰু সেইবোৰৰ মাজৰ পৰা লোৱা যিহোৱাৰ কৰ এষষ্ঠীটা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","মানুহৰ সংখ্যা ষোল্ল হাজাৰ গৰাকী মহিলা আৰু তেওঁলোকৰ পৰা লোৱা যিহোৱাৰ কৰ বত্ৰিশটা। ");
INSERT INTO asmfb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","তাৰ পাছত মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে, সেই কৰ তেওঁ যিহোৱাৰ উত্তোলনীয় উপহাৰ স্বৰূপে পুৰোহিত ইলিয়াজৰক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","আৰু যুদ্ধলৈ যোৱা লোকসকলৰ ভাগৰ পৰা যি আধা ভাগ মোচিয়ে ইস্ৰায়েলৰ সন্তান সকলৰ কাৰণে ৰাখিলে- ");
INSERT INTO asmfb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","মণ্ডলীৰ সেই আধা ভাগৰ সংখ্যা তিনি লাখ সাতত্ৰিশ হাজাৰ পাঁচশ মেৰ-ছাগ, ");
INSERT INTO asmfb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ছয়ত্ৰিশ হাজাৰ ষাঁড়-গৰু, ");
INSERT INTO asmfb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ত্ৰিশ হাজাৰ পাঁচশটা গাধ ");
INSERT INTO asmfb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","আৰু কেতিয়াও পুৰুষৰ সৈতে শয়ন নকৰা ষোল্ল হাজাৰ মহিলা আছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ইস্ৰায়েলৰ সন্তান সকলৰ পৰা সেই আধা ভাগৰ পৰা মানুহ আৰু পশুৰ পঞ্চাশটা পঞ্চাশটাৰ মাজৰ এটা এটা লৈ মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে তেওঁ যিহোৱাৰ আবাসৰ ৰখীয়া লেবীয়াসকলক দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","তাৰ পাছত সহস্ৰপতি আৰু শতপতি, সৈন্য সমূহৰ হাজাৰ হাজাৰৰ ওপৰত সেই সেনাপতিসকল মোচিৰ ওচৰলৈ আহিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","তেওঁলোকে তেওঁক কলে, “আপোনাৰ এই দাসবোৰে নিজৰ নিজৰ অধীনে থকা সৈন্যবোৰৰ লেখ ল’লে আৰু আমাৰ মাজৰ এজনো হেৰোৱা নাই। ");
INSERT INTO asmfb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","এই হেতুকে আমি প্ৰতিজনে যি সোণৰ অলঙ্কাৰ, অৰ্থাৎ নেপুৰ, খাৰু, আঙঠি, কুণ্ডল, হাৰ, এইবোৰ যি পাইছোঁ, তাক আমি যিহোৱাৰ আগলৈ, নিজৰ নিজৰ প্ৰাণ প্ৰায়শ্চিত্ত কৰিবলৈ যিহোৱাৰ উপহাৰ স্বৰুপে আনিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","তেতিয়া মোচি আৰু পুৰোহিত ইলিয়াজৰে তেওঁলোকৰ পৰা সেই সোণ, অৰ্থাৎ শিল্পকাৰে বনোৱা সেই সকলো অলঙ্কাৰবোৰ ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","সহস্ৰপতি আৰু শতপতিসকলে যিহোৱাৰ উদ্দেশ্যে উৎসৰ্গ কৰা উত্তোলনীয় উপহাৰৰ সেই সোণ ষোল্ল হাজাৰ সাতশ পঞ্চাশ চেকল আছিল; ");
INSERT INTO asmfb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","কিয়নো সৈন্যসকলৰ প্ৰতিজনে নিজৰ কাৰণে লুটদ্ৰব্য আনিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","পাছত মোচি আৰু পুৰোহিত ইলিয়াজৰে সহস্ৰপতি আৰু শতপতি, এই সেনাপতিসকলৰ পৰা সেই সোণ লৈ, যিহোৱাৰ আগত ইস্ৰায়েলৰ সন্তান সকলৰ স্মৰণাৰ্থক চিন হ’বলৈ, তাক সাক্ষাৎ কৰা তম্বুত ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ৰূবেণৰ সন্তান সকলৰ আৰু গাদৰ সন্তান সকলৰ অতিশয় অধিক পশুৰ জাক আছিল; এই কাৰণে তেওঁলোকে যেতিয়া যাজেৰ আৰু গিলিয়দ দেশখন দেখিলে, তেওঁলোকে তেওঁলোকৰ পশুবোৰৰ কাৰণে সেই ঠাই ভাল দেখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","সেই কাৰণে গাদ আৰু ৰূবেণৰ সন্তান সকলে আহি মোচিক, পুৰোহিত ইলিয়াজৰক আৰু মণ্ডলীৰ অধ্যক্ষসকলক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","অটাৰোৎ, দীবোন, যাজেৰ, নিম্ৰা, হিচবোন, ইলিয়ালি, চিবাম, নবো আৰু বিয়োন, ");
INSERT INTO asmfb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","এই যি যি দেশ যিহোৱাই ইস্ৰায়েলৰ মণ্ডলীৰ আগত পৰাজয় কৰিলে, এয়ে পশুবোৰৰ বাবে যোগ্য ঠাই; আৰু আমি, আপোনাৰ যি দাসকল, আমাৰ অধিক পশুৰ জাক আছে।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","তেওঁলোকে আকৌ ক’লে, “আমি যদি আপোনাৰ দৃষ্টিত অনুগ্ৰহ পাইছোঁ, তেতিয়াহলে উত্তৰাধিকাৰৰ অৰ্থে আপোনাৰ এই দাসবোৰক এই দেশ দান কৰক। আমাক যৰ্দ্দন পাৰ কৰি নিনিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","তেতিয়া মোচিয়ে গাদৰ আৰু ৰূবেণৰ সন্তান সকলক ক’লে, “তোমালোকৰ ভাইসকলে যুদ্ধ কৰিবলৈ যোৱাৰ সময়ত তোমালোকে এই ঠাইত বাস কৰিবা নে? ");
INSERT INTO asmfb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","যিহোৱাই ইস্ৰায়েলৰ সন্তান সকলক দিয়া দেশলৈ তেওঁলোকে পাৰ হৈ নাযাবলৈ তেওঁলোকৰ মন কেলেই নিৰুৎসাহ কৰিছা? ");
INSERT INTO asmfb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","যি কালত মই তোমালোকৰ পিতৃসকলক দেশ চাবৰ কাৰণে কাদেচ-বৰ্ণেয়াৰ পৰা পঠিয়াইছিলোঁ সেই কালত তেওঁলোকেও সেইদৰে কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","কিয়নো তেওঁলোকে ইষ্কোল উপত্যকালৈকে গৈ দেশ চাই, যিহোৱাই দিয়া সেই দেশত নোসোমাবলৈ ইস্ৰায়েলৰ সন্তান সকলৰ মন নিৰোৎসাহ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","এই কাৰণে সেই দিনা যিহোৱাৰ ক্ৰোধ জ্বলি উঠিল আৰু তেওঁ শপত কৰি, এই কথা কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘মই অব্ৰাহাম, ইচহাক আৰু যাকোবক যি দেশ দিম বুলি শপত কৰিছিলোঁ, মিচৰৰ পৰা অহা লোকসকলৰ মাজত বিশ বছৰ আৰু তাতোতকৈ অধিক বয়সীয়া কোনো এজন লোকেও সেই দেশ দেখিবলৈ নাপাব, কিয়নো তেওঁবিলাকে মোৰ পথত সম্পূৰ্ণৰূপে নচলিলে; ");
INSERT INTO asmfb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","কেৱল কনিজ্জীয়া যিফুন্নিৰ পুত্ৰ কালেব আৰু নুনৰ পুত্ৰ যিহোচূৱাই সেই দেশ দেখিব, কাৰণ তেওঁলোকে যিহোৱাৰ পথত সম্পূৰ্ণৰূপে চলিলে’। ");
INSERT INTO asmfb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","এইদৰে ইস্ৰায়েললৈ যিহোৱাৰ ক্ৰোধ জ্বলি উঠাত, যিহোৱাৰ দৃষ্টিত কু কৰ্ম কৰা আটাই বংশৰ শেষ নোহোৱালৈকে, তেওঁ চল্লিশ বছৰ ধৰি তেওঁলোকক অৰণ্যত ভ্ৰমণ কৰালে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","এতিয়া চোৱা, ইস্ৰায়েলৰ বিৰুদ্ধে যিহোৱাৰ প্ৰচণ্ড ক্ৰোধ আৰু বঢ়াবলৈ, পাপী লোকসকলৰ নিচিনা তোমালোকে তোমালোকৰ পিতৃসকলৰ ঠাইত উঠিছা। ");
INSERT INTO asmfb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","কিয়নো, তোমালোকে যদি এইদৰে তেওঁৰ পাছৰ পৰা বিমুখ হোৱা, তেনেহলে তেওঁ পুনৰায় ইস্ৰায়েলক অৰণ্যত ত্যাগ কৰিব; তেতিয়া তোমালোকে এই সকলো লোকক বিনষ্ট কৰাবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","তেতিয়া তেওঁলোকে মোচিৰ ওচৰলৈ আহি ক’লে, “আমি এই ঠাইত নিজ পশুবোৰৰ কাৰণে গঁৰাল সাজিম, আৰু আমাৰ পৰিয়ালবোৰৰ কাৰণে নগৰবোৰ নিৰ্ম্মাণ কৰিম; ");
INSERT INTO asmfb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","আৰু আমি ইস্ৰায়েলৰ সন্তান সকলক নিজ ঠাইলৈ নিনিয়া মানে আমি নিজে ৰণলৈ সাজো হৈ, তেওঁলোকৰ আগে আগে যাম; কেৱল আমাৰ পৰিয়ালবোৰ দেশ নিবাসীসকলৰ ভয়ত গঢ়েৰে আবৃত নগৰবোৰত বাস কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰতিজনে নিজ নিজ উত্তৰাধিকাৰৰ ভাগ নোপোৱালৈ আমি নিজ নিজ ঘৰলৈ উভটি নাহিম। ");
INSERT INTO asmfb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","আমি যৰ্দ্দনৰ সিপাৰে থকা সেই দেশৰ উত্তৰাধিকাৰৰ ভাগ তেওঁলোকৰ সৈতে নলওঁ, কিয়নো পূৱ দিশে যৰ্দ্দনৰ এইপাৰে আমি উত্তৰাধিকাৰৰ ভাগ পালোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","তেতিয়া মোচিয়ে তেওঁলোকক ক’লে, “তোমালোকে কোৱা এই কাৰ্য যদি কৰা, তোমালোকে যদি সুসজ্জিত হৈ যিহোৱাৰ সাক্ষাতে যুদ্ধলৈ যাব নিজকে সাজু কৰা, ");
INSERT INTO asmfb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","তেতিয়া তোমালোকৰ প্রতিজন যুদ্ধলৈ সাজু হোৱা লোকে যিহোৱাৰ সাক্ষাতে যৰ্দ্দন পাৰ হৈ যাব লাগিব যেতিয়ালৈ তেওঁ নিজ শত্ৰুবোৰক নিজৰ আগৰ পৰা দূৰ নকৰে ");
INSERT INTO asmfb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","আৰু তেওঁৰ আগত যেতিয়ালৈ দেশ বশীভূত নহয়। তাৰ পাছত তোমালোক উভটি আহিব পাৰিবা। যিহোৱাৰ দৃষ্টিত আৰু ইস্ৰায়েলৰ দৃষ্টিত তোমালোক নিৰ্দ্দোষী হ’বা, আৰু যিহোৱাৰ সাক্ষাতে এই দেশ তোমালোকৰ উত্তৰাধীকাৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","কিন্তু যদি তোমালোকে সেই দৰে নকৰা, তেন্তে চোৱা, তোমালোকে যিহোৱাৰ অহিতে পাপ কৰিবা, আৰু তোমালোকৰ পাপে যে তোমালোকক বিচাৰি ওলিয়াব, সেই বিষয়ে নিশ্চয় জানিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","তোমালোকে নিজ নিজ পৰিয়ালৰ কাৰণে নগৰ, আৰু মেৰ-ছাগ আৰু ছাগলীৰ জাকৰ কাৰণে গঁৰাল সাজা; আৰু তোমালোকৰ মুখৰ পৰা ওলোৱা বাক্যৰ দৰেই সেই কাৰ্য কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","তেতিয়া গাদৰ আৰু ৰূবেণৰ সন্তান সকলে মোচিক ক’লে, “আমাৰ প্ৰভুৱে যি আজ্ঞা কৰিলে, আপোনাৰ এই দাসবোৰে সেইদৰেই কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","আমাৰ ল’ৰা-ছোৱালী, আমাৰ পত্নীসকল আৰু মেৰ-ছাগ, ছাগলী গৰু আদিৰ আটাই পশুৰ জাকবোৰ এই ঠাইৰ গিলিয়দৰ নগৰবোৰত থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","কিন্তু আমাৰ প্ৰভুৰ কথাৰ দৰে, আপোনাৰ এই দাসবোৰৰ সকলোৱে সাজু হৈ যুদ্ধ কৰিবৰ কাৰণে যিহোৱাৰ সাক্ষাতে পাৰ হৈ যাব।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","তেতিয়া মোচিয়ে তেওঁলোকৰ বিষয়ে পুৰোহিত ইলিয়াজৰক, নুনৰ পুত্ৰ যিহোচূৱাক আৰু ইস্ৰায়েলৰ সন্তান সকলৰ সকলো পিতৃ-বংশৰ অধ্যক্ষসকলক উপদেশ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","মোচিয়ে তেওঁলোকক ক’লে, “গাদৰ আৰু ৰূবেণৰ সন্তান সকলৰ প্ৰতিজনে যুদ্ধলৈ সুসজ্জিত হৈ, যিহোৱাৰ সাক্ষাতে তোমালোকৰ লগত যদি যৰ্দ্দন পাৰ হৈ যায়, তেন্তে দেশ তোমালোকৰ আগত বশীভূত হ’লে, তোমালোকে অধিকাৰ কৰিবৰ অৰ্থে তেওঁলোকক এই গিলিয়দ দেশ দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","কিন্তু যদি তেওঁলোক সুসজ্জিত হৈ, তোমালোকৰ লগত পাৰ নহয়, তেন্তে তেওঁলোকে তোমালোকৰ মাজত কনান দেশত উত্তৰাধীকাৰ পাব।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","তেতিয়া গাদৰ আৰু ৰূবেণৰ সন্তান সকলে উত্তৰ দিলে, “যিহোৱাই আপোনাৰ এই দাসবোৰক যি আজ্ঞা কৰিছে, আমি সেইদৰেই কৰিম। ");
INSERT INTO asmfb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","আমি সুসজ্জিত হৈ, যিহোৱাৰ সাক্ষাতে পাৰ হৈ কনান দেশত সোমাম, কিন্তু আমাৰ উত্তৰাধীকাৰ যৰ্দ্দনৰ ইপাৰত আমাৰ স্বত্ব থাকিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","পাছত মোচিয়ে গাদৰ আৰু ৰূবেণৰ সন্তান সকলক, আৰু যোচেফৰ পুত্ৰ মনচিৰ আধা ফৈদক ইমোৰীয়াসকলৰ ৰজা চীহোনৰ ৰাজ্য আৰু বাচানৰ ৰজা ওগৰ ৰাজ্য দিলে। আৰু নিজ নিজ অঞ্চলে সৈতে নগৰ থকা দেশবোৰ, এইদৰে চাৰিওফালে থকা দেশৰ আটাই নগৰবোৰ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","গাদৰ সন্তান সকলে দীবোন, অটাৰোৎ, অৰোয়েৰ, ");
INSERT INTO asmfb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","অটাৰোৎ-চোফন, যাজেৰ, যগ্বেহা, ");
INSERT INTO asmfb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","বৈৎ-নিম্ৰা আৰু বৈৎ-হাৰণ, গড়েৰে আবৃত এই নগৰবোৰ পুনৰায় নিৰ্ম্মাণ কৰিলে আৰু মেৰ-ছাগবোৰ জাকৰ কাৰণে গঁৰালবোৰ সাজিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","আৰু ৰূবেণৰ সন্তান সকলে হিচবোন, ইলিয়ালি, কিৰিয়াথয়িম, ");
INSERT INTO asmfb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","নবো, আৰু বাল-মিয়োন, আৰু চিবমাও পুনৰায় নিৰ্ম্মাণ কৰিলে; তেওঁলোকে পুনৰায় নিৰ্ম্মাণ কৰা নগৰৰ নাম নতুনকৈ দিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","আৰু মনচিৰ পুত্ৰ মাখীৰৰ সন্তান সকলে গিলিয়দলৈ গৈ, তাক হাত কৰি ল’লে, আৰু তাত থকা ইমোৰীয়াসকলক দূৰ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","পাছত মোচিয়ে মনচিৰ পুত্ৰ মাখীৰক গিলিয়দ দেশ দিলে; তেওঁৰ লোকসকলে তাৰ মাজত বাস কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","আৰু মনচিৰ সন্তান যায়ীৰে গৈ, তেওঁলোকৰ সৰু গাওঁবোৰ হাত কৰি ল’লে, আৰু সেইবোৰৰ নাম হব্বোৎ-যায়ীৰ অৰ্থাৎ যায়ীৰৰ গাওঁ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","আৰু নোবহে গৈ, কনাৎ নগৰ আৰু তাৰ গাওঁবোৰ হাত কৰি ল’লে, আৰু নিজৰ নামৰ দৰেই তাৰো নাম নোবহ ৰাখিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ইস্ৰায়েলৰ সন্তান সকলে মোচি আৰু হাৰোণৰ অধীনত নিজ সৈন্যদল অনুসাৰে মিচৰ দেশৰ পৰা ওলাই আহোঁতে, তেওঁলোকে যি যি যাত্ৰা কৰিছিল, সেই সকলো যাত্ৰাৰ বিৱৰণ এই। ");
INSERT INTO asmfb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","মোচিয়ে যিহোৱাৰ আজ্ঞামতেই তেওঁলোকৰ সকলো যাত্ৰা অনুসাৰে তেওঁলোকে থাকি ৰাওনা হোৱা ঠাইৰ তালিকা লিখিলে। তেওঁলোকে থাকি ৰাওনা হোৱা ঠাই অনুসাৰে তেওঁলোকৰ এই এই যাত্ৰা। ");
INSERT INTO asmfb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","প্ৰথম মাহত, প্ৰথম মাহৰ পঞ্চদশ দিনা ইস্ৰায়েলৰ সন্তান সকলে ৰামিচেচৰ পৰা যাত্ৰা কৰি নিস্তাৰ-পৰ্ব্বৰ পাছদিনা আটাই মিচৰীয়া লোকৰ সাক্ষাতে যিহোৱাৰ পৰাক্ৰমী বাহুৰে ওলাই গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","তেতিয়া মিচৰীয়াসকলে, যিহোৱাই তেওঁলোকৰ মাজত বধ কৰা তেওঁলোকৰ প্ৰথমে ওপজাবোৰৰ মৰা শৱ পুতি আছিল, আৰু যিহোৱাই তেওঁলোকৰ দেৱতাবোৰকো দণ্ড দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ৰামিচেচৰ পৰা যাত্ৰা কৰি, ইস্ৰায়েলৰ সন্তান সকলে চুক্কোতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","আৰু চুক্কোতৰ পৰা যাত্ৰা কৰি, মৰুভূমিৰ দাঁতিত থকা এথমত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","আৰু এথমৰ পৰা যাত্ৰা কৰি, বাল-চফোনৰ আগত থকা পী-হহীৰোতলৈ ঘূৰি আহি মিগদোলৰ সন্মুখত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","তেতিয়া পী-হহীৰোতৰ সন্মুখৰ পৰা যাত্ৰা কৰি, সমুদ্ৰৰ মাজেদি গৈ মৰুভূমিত সোমাল আৰু এথন অৰণ্যত তিন দিনৰ বাট যাত্ৰা কৰি, মাৰাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","আৰু মাৰাৰ পৰা যাত্ৰা কৰি, এলীম পালে; এলীমত বাৰটা জলৰ ভূমূক আৰু ষাঠী জোপা খাজুৰ গছ আছিল; তেওঁলোকে সেই ঠাইত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","পাছত এলীমৰ পৰা যাত্ৰা কৰি, চূফ সাগৰৰ ওচৰত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","আৰু চূফ সাগৰৰ পৰা যাত্ৰা কৰি, চীন অৰণ্যত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","পাছত চীন মৰুভূমিৰ পৰা যাত্ৰা কৰি দফকাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","আৰু দফকাৰ পৰা যাত্ৰা কৰি, আলূচত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","আৰু আলূচৰ পৰা যাত্ৰা কৰি, ৰফীদীমত ছাউনি পাতিলে; সেই ঠাইত লোকসকলৰ খাবলৈ পানী নাছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","পাছত তেওঁলোকে ৰফীদীমৰ পৰা যাত্ৰা কৰি, চীনয় মৰুভূমিত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","আৰু চীনয় মৰুভূমিৰ পৰা যাত্ৰা কৰি, কিব্ৰোৎ-হত্তাবাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","আৰু কিব্ৰোৎ-হত্তাবাৰ পৰা যাত্ৰা কৰি, হচেৰোতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","আৰু হচেৰোতৰ পৰা যাত্ৰা কৰি, ৰিৎমাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","আৰু ৰিৎমাৰ পৰা যাত্ৰা কৰি, ৰিম্মোন-পেৰচত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","আৰু ৰিম্মোন-পেৰচৰ পৰা যাত্ৰা কৰি, লিবনাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","আৰু লিবনাৰ পৰা যাত্ৰা কৰি, ৰিচ্ছাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","আৰু ৰিচ্ছাৰ পৰা যাত্ৰা কৰি, কহেলাথাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","আৰু কহেলাথাৰ পৰা যাত্ৰা কৰি, চেফৰ পৰ্ব্বতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","পাছত তেওঁলোকে চেফৰ পৰ্ব্বতৰ পৰা যাত্ৰা কৰি, হৰাদাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","আৰু হৰাদাৰ পৰা যাত্ৰা কৰি, মখেলোতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","আৰু মখেলোতৰ পৰা যাত্ৰা কৰি, তহতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","আৰু তহতৰ পৰা যাত্ৰা কৰি, তেৰহত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","আৰু তেৰহৰ পৰা যাত্ৰা কৰি, মিৎকাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","আৰু মিৎকাৰ পৰা যাত্ৰা কৰি, হচমোনাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","আৰু হচমোনাৰ পৰা যাত্ৰা কৰি, মোচেৰোতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","আৰু মোচেৰোতৰ পৰা যাত্ৰা কৰি, বনেই-যাকনত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","আৰু বনেই-যাকনৰ পৰা যাত্ৰা কৰি, হোৰহগ্গিদগদত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","আৰু হোৰহগ্গিদগদৰ পৰা যাত্ৰা কৰি, যটবাথাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","আৰু যটবাথাৰ পৰা যাত্ৰা কৰি, অব্ৰোণাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","আৰু অব্ৰোণাৰ পৰা যাত্ৰা কৰি, ইচিয়োন-গেবৰত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","আৰু ইচিয়োন-গেবৰৰ পৰা যাত্ৰা কৰি, ছিন মৰুভূমিত থকা কাদেচত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","আৰু কাদেচৰ পৰা যাত্ৰা কৰি, ইদোম দেশৰ কাষত থকা হোৰ পৰ্ব্বতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","এই সময়ত হাৰোণ পুৰোহিত যিহোৱাৰ আজ্ঞা অনুসাৰে হোৰ পৰ্ব্বতত উঠি, মিচৰৰ পৰা ইস্ৰায়েলৰ সন্তান সকল ওলাই অহাৰ চল্লিশ বছৰৰ পঞ্চম মাহৰ প্ৰথম দিনা সেই ঠাইতে মৰিল। ");
INSERT INTO asmfb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","হোৰ পৰ্ব্বতত হাৰোণ মৰা সময়ত, তেওঁৰ এশ তেইশ বছৰ বয়স হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","আৰু কনানৰ দক্ষিণ মৰুভূমিত থকা অৰাদৰ কনানীয়া ৰজাই ইস্ৰায়েলৰ সন্তান সকল অহা সম্বাদ পালে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","পাছত তেওঁলোকে হোৰ পৰ্ব্বতৰ পৰা যাত্ৰা কৰি, চল্মোনাত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","আৰু চল্মোনাৰ পৰা যাত্ৰা কৰি, পুনোনত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","আৰু পুনোনৰ পৰা যাত্ৰা কৰি, এবোতত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","আৰু এবোতৰ পৰা যাত্ৰা কৰি, মোৱাবৰ সীমাৰ ওচৰত থকা ইয়ে-অবাৰীমত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","আৰু ইয়ীমৰ পৰা যাত্ৰা কৰি, দীবোন-গাদত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","আৰু দীবোন-গাদৰ পৰা যাত্ৰা কৰি, অল্মোনদিব্লাথয়িমত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","আৰু অল্মোনদিব্লাথয়িমৰ পৰা যাত্ৰা কৰি, নবোৰ সন্মুখত থকা অবাৰীম পৰ্ব্বতৰ মাজত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","আৰু অবাৰীম পৰ্ব্বতবোৰৰ পৰা যাত্ৰা কৰি, যিৰীহোৰ সন্মুখত থকা যৰ্দ্দনৰ ওচৰত মোৱাবৰ সমথলত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","আৰু তেওঁলোকে যৰ্দ্দনৰ ওচৰত বৈৎ-যিচীমোতৰ পৰা আবেল-চিটীমলৈকে মোৱাবৰ সমথলত ছাউনি পাতিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","তেতিয়া যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ ওচৰত মোৱাবৰ সমথলত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, তেওঁলোকক এই আজ্ঞা দিয়া, ‘তোমালোকে যেতিয়া যৰ্দ্দন পাৰহৈ কনান দেশত সোমাবা, ");
INSERT INTO asmfb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","তেতিয়া তোমালোকৰ আগৰ পৰা সেই দেশ নিবাসী সকলো লোকক দূৰ কৰিবা। আৰু তেওঁলোকৰ সকলো নক্সা কটা শিলবোৰ আৰু আটাই সাঁচত ঢলা প্ৰতিমাবোৰ নষ্ট কৰিবা আৰু তেওঁলোকৰ আটাই ওখ ঠাইবোৰ উচ্ছন্ন কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","আৰু তোমালোকে সেই দেশ অধিকাৰ কৰি, তাৰ মাজত বাস কৰিবা; কিয়নো মই উত্তৰাধিকাৰৰ অৰ্থে সেই দেশ তোমালোকক দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","আৰু তোমালোকে চিঠি-খেলেৰে নিজ নিজ গোষ্ঠী অনুসাৰে দেশ অধিকাৰ কৰি ল’বা; অধিকক অধিক উত্তৰাধীকাৰ আৰু তাকৰক কম উত্তৰাধীকাৰ দিবা; আৰু যাৰ ভাগ যি ঠাইত পৰে, তাৰ ভাগ সেই ঠাইতে হ’ব; তোমালোকে নিজ নিজ পিতৃ-বংশ অনুসাৰে তাক অধিকাৰ কৰি ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","কিন্তু তোমালোকে যদি তোমালোকৰ আগৰ পৰা সেই দেশ নিবাসীসকলক দূৰ নকৰা, তেন্তে তোমালোকে যিসকলক অৱশিষ্ট ৰাখিবা, তেওঁলোকেই তোমালোকৰ চকুত কাঁইট আৰু তোমালোকৰ গাৰ কাষত হুলস্বৰূপ হ’ব আৰু তোমালোকে নিবাস কৰা সেই দেশত তেওঁলোকে তোমালোকক ক্লেশ দিব। ");
INSERT INTO asmfb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","আৰু মই তেওঁলোকলৈ যি কৰিবৰ মন কৰিছোঁ, তাক তোমালোকলৈ কৰিম’।” ");
INSERT INTO asmfb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক এই আজ্ঞা দিয়া, তেওঁলোকক এই কথা কোৱা, ‘যেতিয়া তোমালোক কনান দেশত সোমাবা, তোমালোকে অধিকাৰৰ অৰ্থে পাব লগা দেশ এই, চাৰিসীমা অনুসাৰে এয়ে কনান দেশ, ");
INSERT INTO asmfb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","তেতিয়া ইদোমৰ কাষত থকা ছিন মৰুভূমিৰ পৰা তোমালোকৰ দক্ষিণ অঞ্চল হ’ব; তোমালোকৰ দক্ষিণ সীমা লৱণ-সমুদ্ৰৰ অন্তৰ পৰা পূৱফালে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","আৰু তোমালোকৰ সীমা পৰ্ব্বত পাৰ হৈ যোৱা অক্ৰব্বীম নামেৰে ঠাইৰ দক্ষিণে ঘূৰি ছিনলৈকে যাব আৰু কাদেচ-বৰ্ণেয়াৰ দক্ষিণফালে ওলাব আৰু হচৰ-অদ্দৰ ওলাই অচমোনলৈকে যাব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","পাছত এই সীমা অচমোনৰ পৰা মিচৰ জুৰিলৈ ঘূৰি আহিব আৰু সমুদ্ৰত এই সীমা শেষ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","আৰু তোমালোকৰ পশ্চিম সীমা হ’লে, মহাসাগৰ আৰু তাৰ অঞ্চল; এয়ে তোমালোকৰ পশ্চিম সীমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","আৰু তোমালোকৰ উত্তৰ সীমা এই; তোমালোকে মহাসাগৰ পৰা হোৰ পৰ্ব্বত লক্ষ্য কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","পাছত হোৰ পৰ্ব্বতৰ পৰা হমাতৰ প্ৰৱেশস্থানলৈকে ঠিক কৰিবা আৰু তাৰ পৰা সেই সীমা ওলাই চদাদ পাব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","আৰু সেই সীমা বাহিৰ হৈ জিফ্ৰোণলৈ যাব আৰু হচৰ-ঐননত তাৰ শেষ হ’ব। এয়ে তোমালোকৰ উত্তৰ সীমা হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","আৰু তোমালোকে হচৰ-ঐননৰ পৰা চফামলৈকে তোমালোকৰ পূৱ সীমা ঠিক কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","পাছত সেই সীমা চফামৰ পৰা ঐনৰ পূৱফাল হৈ ৰিব্লালৈ নামি যাব; সেয়ে আৰু নামি কিন্নেৰৎ সাগৰৰ পূৱ চুকত লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","পাছত সেই সীমা যৰ্দ্দনলৈ নামি লৱণ-সমুদ্ৰত তাৰ শেষ হ’ব। সেই চাৰিফালৰ সীমা অনুসাৰেই তোমালোকৰ দেশ হ’ব’।” ");
INSERT INTO asmfb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","পুনৰায় মোচিয়ে ইস্ৰায়েলৰ সন্তান সকলক এই আজ্ঞা কৰিলে, “যি দেশ তোমালোকে চিঠি-খেলেৰে অধিকাৰ কৰিবা, যি দেশ যিহোৱাই ন ফৈদ আৰু আধা ফৈদক দিবলৈ আজ্ঞা কৰিছে, সেয়ে এই দেশ। ");
INSERT INTO asmfb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","কিয়নো নিজ নিজ পিতৃ-বংশ অনুসাৰে ৰূবেণৰ সন্তান সকলৰ ফৈদ আৰু নিজ নিজ পিতৃ-বংশ অনুসাৰে গাদৰ সন্তান সকলৰ ফৈদ আৰু মনচিৰ আধা ফৈদে নিজ নিজ উত্তৰাধিকাৰ ল’লে। ");
INSERT INTO asmfb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ পূৱ পাৰত সূৰ্য ওলোৱা ফালে সেই আঢ়ৈ ফৈদে নিজ নিজ উত্তৰাধিকাৰ ল’লে।” ");
INSERT INTO asmfb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","যিসকলে দেশ ভাগ কৰি তোমালোকক দিব, তেওঁলোকৰ নাম এই, ইলিয়াজৰ পুৰোহিত আৰু নুনৰ পুত্ৰ যিহোচূৱা। ");
INSERT INTO asmfb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","আৰু উত্তৰাধিকাৰৰ অৰ্থে দেশ ভাগ কৰিবলৈ প্ৰত্যেক ফৈদৰ এজন এজন অধ্যক্ষ ল’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","সেই লোকসকলৰ নাম এই: যিহূদা ফৈদৰ যিফুন্নিৰ পুত্ৰ কালেব। ");
INSERT INTO asmfb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","আৰু চিমিয়োনৰ সন্তান সকলৰ ফৈদৰ অম্মীহূদৰ পুত্ৰ চমূৱেল। ");
INSERT INTO asmfb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","আৰু বিন্যামীন ফৈদৰ কিশ্লোনৰ পুত্ৰ ইলীদদ। ");
INSERT INTO asmfb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","আৰু দানৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ যগ্লীৰ পুত্ৰ বুক্লী। ");
INSERT INTO asmfb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","আৰু যোচেফৰ পুত্ৰসকলৰ মাজত মনচিৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ এপোদৰ পুত্ৰ হন্নীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","আৰু ইফ্ৰয়িমৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ চিপ্তনৰ পুত্ৰ কেমূৱেল। ");
INSERT INTO asmfb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","আৰু জবূলূনৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ পৰ্ণাকৰ পুত্ৰ ইলিচাফন। ");
INSERT INTO asmfb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","আৰু ইচাখৰৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ অজ্জনৰ পুত্ৰ পল্টীয়েল। ");
INSERT INTO asmfb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","আৰু আচেৰৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ চলোমীৰ পুত্ৰ অহীহূদ। ");
INSERT INTO asmfb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","আৰু নপ্তালীৰ সন্তান সকলৰ ফৈদৰ অধ্যক্ষ অম্মীহূদৰ পুত্ৰ পদহেল। ");
INSERT INTO asmfb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","কনান দেশত ইস্ৰায়েলৰ সন্তান সকলৰ কাৰণে উত্তৰাধীকাৰ ভাগ কৰি দিবলৈ যিহোৱাই এই সকলো লোকক আজ্ঞা কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","পাছত যিহোৱাই মোৱাবৰ সমথলত যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ ওচৰত মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“তুমি ইস্ৰায়েলৰ সন্তান সকলক তেওঁলোকৰ স্বত্ব থকা আধিপত্যৰ পৰা কেইখনমান নগৰ, বাস কৰিবৰ কাৰণে লেবীয়াসকলক দিবলৈ আৰু সেই নগৰে সৈতে তাৰ চাৰিওফালে থকা চৰণী ঠাই তেওঁলোকক দিবলৈ আজ্ঞা দিয়া। ");
INSERT INTO asmfb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","তেতিয়া, তেওঁলোকে নিবাস কৰিবৰ কাৰণে সেই সকলো নগৰ হ’ব আৰু সেই নগৰৰ চৰণী ঠাই তেওঁলোকৰ গৰু, মেৰ, মেৰ-ছাগ আদি পশু চৰাবৰ বাবে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","আৰু তোমালোকে যি যি নগৰ লেবীয়াসকলক দিবা, তাৰ চৰণী ঠাই নগৰৰ চাৰিওফালে গড়ৰ বাহিৰে এক হাজাৰ হাতলৈকে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","আৰু তোমালোকে নগৰৰ বাহিৰে, পূৱদিশে দুই হাজাৰ হাত আৰু দক্ষিণ দিশে দুই হাজাৰ হাত, পশ্চিম দিশে দুই হাজাৰ হাত আৰু উত্তৰ দিশে দুই হাজাৰ হাত জুখি দিবা; তাৰ মাজ ঠাইত নগৰ থাকিব; এয়ে তেওঁলোকৰ নগৰৰ চৰণী ঠাই হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","তোমালোকে যি যি নগৰ লেবীয়াসকলক দিবা, সেইবোৰ নগৰৰ মাজত, মানুহ বধী পলাবৰ কাৰণে ছখন আশ্ৰয় নগৰ হ’ব লাগিব; আৰু তাৰ বাহিৰেও বিয়াল্লিশখন নগৰ তোমালোকে তেওঁলোকক দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","তোমালোকে সৰ্ব্বমুঠ আঠচল্লিশখন নগৰ আৰু তাৰ চৰণী ঠায়ে সৈতে দিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","আৰু ইস্ৰায়েলৰ সন্তান সকলৰ আধিপত্যৰ পৰা যি যি নগৰ দিবা, সেইবোৰ নগৰৰ বিষয়ে হ’লে, তোমালোকে অধিকাৰ কৰা অধিক, কমৰ পৰা কম ল’বা; এইদৰে প্ৰত্যেক ফৈদে নিজে পোৱা নিজ আধিপত্য অনুসাৰে, নিজ নিজ নগৰবোৰৰ পৰা কেইখনমান নগৰ লেবীয়াসকলক দিবা।” ");
INSERT INTO asmfb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","পাছত যিহোৱাই মোচিক ক’লে, ");
INSERT INTO asmfb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“তুমি ইস্ৰায়েলৰ সন্তান সকলক কোৱা, তেওঁলোকক এই আজ্ঞা দিয়া, ‘তোমালোকে যেতিয়া যৰ্দ্দন পাৰ হৈ কনান দেশত সোমাবা, ");
INSERT INTO asmfb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","তেতিয়া অজ্ঞানত কোনো লোকৰ প্ৰাণ হানি কৰা কোনো নৰ-বধী পলাই যাবলৈ, তোমালোকে তোমালোকৰ কাৰণে কেইখনমান নগৰ আশ্ৰয়-নগৰ নিৰূপণ কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","আৰু মানুহ বধীটো বিচাৰৰ অৰ্থে সমাজৰ আগলৈ নৌ আহোঁতেই যেন নমৰে, এই কাৰণে সেই নগৰ প্ৰতিকাৰ সাধকৰ হাতৰ পৰা তোমালোক ৰক্ষা পোৱা আশ্ৰয়স্থান হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","আৰু যি যি নগৰ তোমালোকে দিবা, সেইবোৰৰ মাজৰ তোমালোকৰ ছখন আশ্ৰয়-নগৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","তোমালোকে তাৰ মাজৰ তিনিখন নগৰ যৰ্দ্দনৰ পূৱ পাৰত আৰু আন তিনিখন কনান দেশত দিবা। সেইবোৰ আশ্ৰয়-নগৰ হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","যিকোনোৱে অজ্ঞানত মানুহক বধ কৰে, সি যেন সেই ঠাইলৈ পলাব পাৰে, এই কাৰণে ইস্ৰায়েলৰ সন্তান সকললৈ, বিদেশীলৈ আৰু তেওঁলোকৰ মাজত প্ৰবাস কৰা লোকলৈ সেই ছখন নগৰ আশ্ৰয়স্থান হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","কিন্তু যদি সি লোহাৰ অস্ত্ৰেৰে তাক মৰাকৈ মাৰে, তেন্তে সি মানুহ বধী; তেনে মানুহবধীৰ অবশ্যে প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","নাইবা যিহেৰে মানুহ মাৰিব পাৰে, সি হাতত এনে শিল লৈ যদি তাক মৰাকৈ মাৰে, তেন্তে সি মানুহ বধী; অৱশ্যে তেনে মানুহ বধীৰ প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","নাইবা যিহৰ দ্বাৰাই মৰিব পাৰে, এনে কাঠৰ বস্তু লৈ যদি তাক মৰাকৈ মাৰে, তেন্তে সি মানুহ বধী; অৱশ্যে তেনে মানুহ বধীৰ প্ৰাণদণ্ড হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ৰক্তপাতৰ প্ৰতিকাৰসাধকে নিজে তেনে মানুহ বধীক বধ কৰিব পাৰিব; সি তাক লগ পালেই বধ কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","আৰু যদি সি হিংসা কৰি তাক আঘাত কৰে, বা খাপ দি থাকি তাৰ ওপৰলৈ কিবা বস্তু দলি মাৰে আৰু সি যদি তাতে মৰে, ");
INSERT INTO asmfb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","নাইবা শত্ৰুভাব কৰি তাক হাতেৰে মৰাকৈ মাৰে, তেন্তে, যিজনে তাক মাৰে, অৱশ্যে তাৰ প্ৰাণদণ্ড হ’ব; সি মানুহ বধী; ৰক্তপাতৰ প্ৰতিকাৰসাধকে তেনে মানুহ বধীক লগ পালেই তাক বধ কৰিব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","কিন্তু যদি শত্ৰুভাব নকৰাকৈ অকস্মাতে তাক আঘাত কৰে, বা খাপ দি নথকাকৈ তাৰ গালৈ কিবা দলি মাৰে, ");
INSERT INTO asmfb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","বা যিহৰ দ্বাৰাই মৰিব পাৰে, এনে শিল তাৰ ওপৰত তাক নেদেখাকৈ পেলায় আৰু তাতে সি মৰে, তথাপি সি তাৰ শত্ৰু বা অনিষ্টকাৰী নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","তেতিয়া সমাজে সেই প্ৰহাৰকৰ আৰু ৰক্তপাতৰ প্ৰতিকাৰ সাধকৰ মাজত এই শাসন অনুসাৰে বিচাৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","আৰু সমাজে ৰক্তপাতৰ প্ৰতিকাৰ সাধকৰ হাতৰ পৰা সেই মানুহ বধীক উদ্ধাৰ কৰিব; আৰু সি যি ঠাইলৈ পলাইছিল, নিজৰ সেই আশ্ৰয় নগৰলৈ সমাজে তাক পুনৰায় পঠাই দিব; আৰু পবিত্ৰ তেলেৰে অভিষিক্ত হোৱা প্ৰধান পুৰোহিতৰ মৃত্যু নহয়মানলৈকে সি সেই নগৰতে থাকিব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","কিন্তু এই মানুহ বধী যদি কোনো সময়ত পলাই যোৱা আশ্ৰয় নগৰৰ সীমাৰ বাহিৰ হয়, ");
INSERT INTO asmfb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","আৰু ৰক্তপাতৰ প্ৰতিকাৰ সাধকে আশ্ৰয় নগৰৰ সীমাৰ বাহিৰে তাক পাই যদি বধ কৰে, তেন্তে সি ৰক্তপাতৰ দোষী নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","কিয়নো প্ৰধান পুৰোহিতৰ মৃত্যু নোহোৱালৈকে সি নিজৰ আশ্ৰয় নগৰত থাকিব লাগিছিল; কিন্তু প্ৰধান পুৰোহিতৰ মৃত্যুৰ পাছত সেই মানুহ বধী নিজ আধিপত্যৰ দেশলৈ উলটি যাব পাৰিব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","আৰু তোমালোকৰ পুৰুষানুক্ৰমে, তোমালোকে নিবাস কৰা সকলো ঠাইতে এয়ে তোমালোকৰ বিচাৰৰ বিধি হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","যি মানুহে কোনো লোকক বধ কৰে, সেই মানুহ বধীক সাক্ষীৰ মুখেই বধ কৰা হ’ব; কিন্তু এজন সাক্ষীৰ কথা কোনো লোকৰ বিৰুদ্ধে প্ৰাণদণ্ডৰ বাবে গ্ৰাহ্য নহ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","আৰু প্ৰাণদণ্ডৰ যোগ্য মানুহ বধীৰ প্ৰাণৰ বাবে তোমালোকে কোনো প্ৰায়শ্চিত্ত নল’বা; কিন্তু তাৰ প্ৰাণদণ্ড অৱশ্যে হ’ব। ");
INSERT INTO asmfb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","আৰু যি মানুহ আশ্ৰয় নগৰলৈ পলাই গ’ল, সেই মানুহ পুৰোহিত নৌ মৰোঁতেই দেশত বাস কৰিবলৈ উলটি আহিবৰ বাবে প্ৰায়শ্চিত্ত নল’বা। ");
INSERT INTO asmfb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","এইদৰে, তোমালোকে থকা দেশ অশুচি নকৰিবা; কিয়নো তেজে দেশ অশুচি কৰে আৰু তাত যি ৰক্তপাত কৰা হয় তাৰ কাৰণে ৰক্তপাতৰ বিনে দেশৰ প্ৰায়শ্চিত্ত হ’ব নোৱাৰে। ");
INSERT INTO asmfb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","এই হেতুকে, তোমালোকে নিবাস কৰা যি দেশৰ মাজত মই বাস কৰোঁ, সেই দেশ তোমালোকে অশুচি নকৰিবা; কিয়নো মই যিহোৱাই ইস্ৰায়েলৰ মাজত বাস কৰোঁ’।” ");
INSERT INTO asmfb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","পাছত যোচেফৰ সন্তান সকলৰ গোষ্ঠীবোৰৰ মাজৰ মনচিৰ নাতিয়েক মাখীৰৰ পুত্ৰ গিলিয়দৰ গোষ্ঠীৰ পিতৃ-বংশৰ মূল ব্যক্তিসকলে মোচিৰ আৰু ইস্ৰায়েলৰ সন্তান সকলৰ পিতৃ-বংশৰ মূল ব্যক্তি যি অধ্যক্ষসকল, ");
INSERT INTO asmfb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","তেওঁলোকৰ ওচৰলৈ আহি এই কথা ক’লে, “ইস্ৰায়েলৰ সন্তান সকলক আধিপত্যৰ অৰ্থে এই দেশ চিঠি খেলাই দিবলৈ, যিহোৱাই মোৰ প্ৰভুক আজ্ঞা কৰিলে আৰু আমাৰ ভাই চলফাদৰ আধিপত্য তেওঁৰ জীয়েকসকলক দিবলৈ মোৰ প্ৰভুৱে যিহোৱাৰ পৰা আজ্ঞা পালে। ");
INSERT INTO asmfb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","কিন্তু ইস্ৰায়েলৰ সন্তান সকলৰ আন ফৈদৰ কোনো লোকেৰে সৈতে যদি তেওঁলোক বিয়া হয় তেন্তে আমাৰ পিতৃৰ আধিপত্যৰ পৰা তেওঁলোকৰ অধিকাৰ কটা যাব আৰু তেওঁলোক যি ফৈদৰ হ’ব, সেই ফৈদৰ উত্তৰাধিকাৰৰ লগত তাক যোগ কৰা হ’ব; এইদৰে তেওঁক আমাৰ উত্তৰাধিকাৰৰ ভাগৰ পৰা কটা যাব। ");
INSERT INTO asmfb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","আৰু যেতিয়া ইস্ৰায়েলৰ সন্তান সকলৰ যোৱেল বছৰ হ’ব, তেতিয়া তেওঁলোক যি ফৈদৰ হ’ব, সেই ফৈদৰ উত্তৰাধিকাৰৰ লগত তেওঁলোকৰ উত্তৰাধীকাৰ যোগ কৰা হ’ব; এইদৰে আমাৰ পিতৃৰ ফৈদৰ ভাগৰ পৰা তেওঁলোকৰ উত্তৰাধীকাৰ কটা যাব।” ");
INSERT INTO asmfb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","তাতে মোচিয়ে যিহোৱাৰ বাক্য অনুসাৰে ইস্ৰায়েলৰ সন্তান সকলক এই আজ্ঞা কৰিলে, “যোচেফৰ সন্তান সকলৰ ফৈদে ঠিক কৈছে। ");
INSERT INTO asmfb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","যিহোৱাই চলফাদৰ জীয়েকসকলৰ বিষয়ে এই আজ্ঞা কৰিছে, ‘তেওঁলোকে যাক ভাল পায়, তাৰে সৈতে বিয়া হ’ব পাৰিব কিন্তু কেৱল নিজৰ পিতৃ-বংশৰ কোনো গোষ্ঠীৰ মাজতহে বিয়া হ’ব পাৰিব।’ ");
INSERT INTO asmfb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","এইদৰে ইস্ৰায়েলৰ সন্তান সকলৰ কোনো আধিপত্য এক ফৈদৰ পৰা আন ফৈদলৈ নাযাব; কিয়নো ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰতিজনে নিজ নিজ পিতৃ-বংশৰ আধিপত্যতে থাকিব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","আৰু ইস্ৰায়েলৰ সন্তান সকলে প্ৰতিজনে যেন নিজ নিজ পিতৃৰ আধিপত্য ভোগ কৰে, এই কাৰণে ইস্ৰায়েলৰ সন্তান সকলৰ কোনো ফৈদৰ মাজত আধিপত্য পোৱা প্ৰতিজনী জীয়েক নিজ পিতৃ-বংশৰ গোষ্ঠীৰ মাজৰ কোনো পুৰুষে সৈতে বিয়া হ’ব লাগিব। ");
INSERT INTO asmfb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","তেতিয়া এক ফৈদৰ পৰা আন ফৈদলৈ কোনো আধিপত্য নাযাব; কিয়নো ইস্ৰায়েলৰ সন্তান সকলৰ প্ৰত্যেক ফৈদ নিজ নিজ আধিপত্যতে থাকিব লাগিব।” ");
INSERT INTO asmfb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","চলফাদৰ জীয়েকসকলে মোচিক দিয়া যিহোৱাৰ আজ্ঞা অনুসাৰে কাৰ্য কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","কিয়নো মহলা, তিৰ্চা হগ্লা, মিল্কা আৰু নোৱা, চলফাদৰ এই জীয়েক কেইজনীয়ে নিজৰ বৰ বাপেক কি দদায়েকৰ পুতেকসকলৰ সৈতে বিয়া হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","যোচেফৰ পুত্ৰ মনচিৰ সন্তান সকলৰ গোষ্ঠীৰ মাজত তেওঁলোকৰ বিয়া হোৱাত, তেওঁলোকৰ আধিপত্য, তেওঁলোকৰ পিতৃ-গোষ্ঠীৰ ফৈদতেই থাকিল। ");
INSERT INTO asmfb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","যিহোৱাই যিৰীহোৰ সন্মুখত যৰ্দ্দনৰ ওচৰত মোৱাবৰ সমথলত মোচিৰ দ্বাৰাই ইস্ৰায়েলৰ সন্তান সকলক এই সকলো আজ্ঞা আৰু শাসন-প্ৰণালী দিলে।");
INSERT INTO asmfb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","মোচিয়ে যৰ্দ্দন নদীৰ সিপাৰে মৰুভূমি অঞ্চলত সকলো ইস্ৰায়েলীয়াসকলক এইবোৰ কথা কৈছিল। এই ঠাই চুফৰ সন্মুখত আছিল। এফালে পাৰণ মৰুভূমি আৰু আনফালে তোফল,লাবন, হচেৰোত আৰু দী-জাহব নগৰবোৰৰ মাজত যর্দন নদীৰ উপত্যকাৰ সমথল ভূমিত তেওঁ এই বার্তা দিছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","হোৰেব পাহাৰৰ পৰা চেয়ীৰ পৰ্ব্বতমালাৰ পথেদি কাদেচ-বৰ্ণেয়ালৈ যাবলৈ এঘাৰ দিন লাগে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ইস্রায়েলীয়াসকলে মিচৰ দেশ ত্যাগ কৰাৰ চল্লিশ বছৰ হ’ল। সেই বছৰৰ এঘাৰ মাহৰ প্রথম দিনা যিহোৱাই ইস্ৰায়েলীয়া সকলৰ সম্পর্কে মোচিক যি সকলো আজ্ঞা দিছিল, সেই সকলো কথা তেওঁ তেওঁলোকৰ ওচৰত প্ৰকাশ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","যিহোৱাই ইমোৰীয়াসকলৰ ৰজা হিচবোন নিবাসী চীহোনক আৰু অষ্টাৰোৎ নিবাসী বাচানৰ ৰজা ওগক ইদ্ৰেয়ীত বধ কৰাৰ পাছত মোচিয়ে এই কথা ক’লে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","বিধানৰ এই সকলোবোৰ কথা মোচিয়ে যৰ্দ্দনৰ সিপাৰে মোৱাব দেশত ঘোষণা কৰিবলৈ আৰম্ভ কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","তেওঁ ক’লে, হোৰেব পাহাৰত, “আমাৰ ঈশ্বৰ যিহোৱাই আমাক কৈছিল, ‘তোমালোকে যথেষ্ট কাল এই পাহাৰত বাস কৰিছা। ");
INSERT INTO asmfb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","এতিয়া তোমালোকে ঘূৰি যাত্ৰা কৰা। ইমোৰীয়াসকলে বাস কৰা পাহাৰীয়া অঞ্চললৈ যোৱা। তাৰ ওচৰ পাজৰৰ সকলো ঠাইলৈকে যোৱা। তাৰ ওচৰৰ যর্দন নদীৰ উপত্যকাৰ সমথল, পাহাৰীয়া অঞ্চল, নিম্ন ভূমি অঞ্চল, নেগেভ আৰু সমুদ্ৰতীৰলৈ যোৱা। কনানীয়াসকলৰ দেশৰ লগতে লিবানোনৰ পাহাৰলৈকে ইউফ্রেটিচ নামৰ মহানদী পর্যন্ত যোৱা। ");
INSERT INTO asmfb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","শুনা, মই সেই দেশ তোমালোকৰ আগত ৰাখিছোঁ; মই যিহোৱাই তোমালোকৰ পূর্বপুৰুষ অব্ৰাহাম, ইচহাক আৰু যাকোবলৈ আৰু পাছত তেওঁলোকৰ ভাবী-বংশলৈকো যি দেশ দিম বুলি শপত খাইছিলো, তোমালোকে গৈ তাক অধিকাৰ কৰা।’” ");
INSERT INTO asmfb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","সেই সময়ত মই আপোনালোকক কৈছিলোঁ, “মোৰ পক্ষে আপোনালোকৰ ভাৰ অকলে বৈ নিয়াটো সম্ভৱ নহয়। ");
INSERT INTO asmfb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","আপোনালোকৰ ঈশ্বৰ যিহোৱাই আপোনালোকৰ জনসংখ্যা অধিককৈ বৃদ্ধি কৰিলে আৰু চাওঁক, আজি আপোনালোক আকাশৰ তৰাৰ নিচিনা অসংখ্য হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","আপোনালোকৰ পূর্বপুৰুষ সকলৰ ঈশ্বৰ যিহোৱাই বর্তমানতকৈ আপোনালোকৰ সংখ্যা আৰু হাজাৰ গুণে বৃদ্ধি কৰক; তেওঁৰ প্রতিজ্ঞা অনুসাৰেই আপোনালোকক তেওঁ আশীৰ্ব্বাদ কৰক। ");
INSERT INTO asmfb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","কিন্তু মই অকলে কেনেকৈ আপোনালোকৰ সকলো বাদ-বিবাদ মীমাংসা কৰাৰ ভাৰ আৰু বোজা বহন কৰিম? ");
INSERT INTO asmfb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","আপোনালোকে আপোনালোকৰ প্রত্যেকটো ফৈদৰ পৰা কেইজনমান জ্ঞানৱান, বিজ্ঞ আৰু সুখ্যাতিপূর্ণ লোকক বাচি লওঁক; মই আপোনালোকৰ ওপৰত তেওঁলোকক মুখিয়াল পাতিম।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","আপোনালোকে তাৰ উত্তৰত মোক কৈছিল, “আপুনি যি কথা কৈছে তাকে কৰা ভাল।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","সেয়ে মই আপোনালোকৰ ফৈদবোৰৰ পৰা জ্ঞানৱান আৰু সুখ্যাতিপূর্ণ লোকসকলক লৈ আপোনালোকৰ ওপৰত মুখিয়াল পাতিলো। প্রত্যেক ফৈদৰ পৰা হাজাৰপতি, শতপতি, পঞ্চাশপতি, দশপতি আৰু অন্যান্য পদাধিকাৰী ব্যক্তিক নিযুক্ত কৰিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","আপোনালোকৰ বিচাৰকসকলক সেই সময়ত মই এই আজ্ঞা দিছিলোঁ, “আপোনালোকে বাদ-বিবাদৰ সময়ত ভাইসকলৰ দুই পক্ষৰ কথা শুনি ন্যায়ভাৱে বিচাৰ কৰিব; সেই বিবাদ ইস্রায়েলীয়া ভাইসকলৰ মাজতেই হওঁক বা এজন ইস্রায়েলীয়া আৰু ভিন্ন জাতিৰ বিদেশীৰ মাজতেই হওঁক। ");
INSERT INTO asmfb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","বিবাদৰ সময়ত আপোনালোকে কাৰো পক্ষ নল’ব আৰু ডাঙৰ-সৰু সকলোৰে কথা সমানে শুনিব। বিচাৰৰ কার্য প্রকৃততে ঈশ্বৰৰ; সেয়ে আপোনালোকে মানুহৰ মুখলৈ চাই ভয় নাখাব। যদি কোনো বিবাদ আপোনালোকৰ কাৰণে কঠিন যেন লাগে, তেন্তে সেই বিচাৰ মোৰ ওচৰলৈ আনিব, মই সেই বিচাৰ কৰিম।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","আপোনালোকে কৰিবলগীয়া সকলোবোৰেই মই তেতিয়া আপোনালোকক আজ্ঞা দিছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ইয়াৰ পাছত আমাৰ ঈশ্বৰ যিহোৱাৰ আজ্ঞা অনুসাৰে আমি হোৰেব পাহাৰ এৰি ইমোৰীয়াসকলৰ পাহাৰীয়া অঞ্চলৰ অভিমুখে যাত্রা কৰিছিলোঁ। আপোনালোকে যি ডাঙৰ আৰু বিপদসংকুল মৰুভূমি দেখিছিল, তাৰ মাজেদি আমি গৈ কাদেচ-বৰ্ণেয়া পাইছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","তাৰ পাছত মই আপোনালোকক কৈছিলোঁ, “আপোনালোক ইমোৰীয়া পাহাৰী অঞ্চল আহি পালে। আমাৰ ঈশ্বৰ যিহোৱাই আমাক এই দেশ দিবলৈ গৈ আছে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","চাওঁক, আপোনালোকৰ ঈশ্বৰ যিহোৱাই দিয়া গোটেই দেশ আপোনালোকৰ আগত আছে। আপোনালোকৰ পূর্বপুৰুষসকলৰ ঈশ্বৰ যিহোৱাৰ কথা অনুসাৰে আপোনালোকে গৈ দেশখন অধিকাৰ কৰক; আপোনালোকে ভয় নকৰিব, নিৰাশ নহ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","তেতিয়া আপোনালোক সকলোৱে আহি মোক কৈছিলে, “কেইজনমান লোকক আগেয়ে পঠাই দিয়া হওঁক যাতে তেওঁলোকে দেশখন চাই মেলি আহি আমাক কব পাৰে কোন পথেৰে গৈ আমি আক্রমণ কৰা উচিত আৰু কোন কোন নগৰবোৰ আমি সন্মুখত পাম।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","আপোনালোকৰ এই প্রস্তাৱ মোৰ ভাল লাগিছিল; সেয়ে মই আপোনালোকৰ প্রত্যেক ফৈদৰ পৰা এজনকৈ মুঠ বাৰজন লোকক বাচি লৈছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","তেওঁলোকে পার্বত্য দেশৰ ওপৰলৈ উঠি গৈছিল আৰু ইষ্কোলৰ উপত্যকালৈ আহি ভালদৰে দেশখন অনুসন্ধান কৰি আহিছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","তেওঁলোকে হাতত সেই দেশৰ কিছু কিছু ফল লৈ নামি আহি আমাক কৈছিল, “আমাৰ ঈশ্বৰ যিহোৱাই যি দেশ আমাক দিছে, ই সঁচাকৈয়ে এক উত্তম দেশ।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","কিন্তু আপোনালোকে সেই দেশ আক্রমণ কৰিবলৈ অস্বীকাৰ কৰিছিল। আপোনালোকে আপোনালোকৰ ঈশ্বৰ যিহোৱাৰ আজ্ঞাৰ বিৰুদ্ধাচৰণ কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","আপোনালোকে আপোনালোকৰ তম্বুত আপত্তি দর্শাই কৈছিল, “যিহোৱাই আমাক ঘৃণা কৰে। সেয়ে তেওঁ আমাক মিচৰ দেশৰ পৰা বাহিৰ কৰি আনিছিল যাতে ইমোৰীয়াসকলৰ শক্তিৰ দ্বাৰা আমি পৰাজিত হৈ সম্পূর্ণ বিনষ্ট হওঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","এতিয়া আমি ক’লৈ যাব পাৰোঁ? ভাইসকলে আমাৰ মন ভাঙি দিলে। কিয়নো তেওঁলোকে কৈছিল, ‘সেই ঠাইৰ অধিবাসীসকল আমাৰ তুলনাত অতিশয় ডাঙৰ আৰু দীঘল; তেওঁলোকৰ নগৰবোৰো ডাঙৰ ডাঙৰ আৰু তাৰ চৌদিশ আকাশ লঙ্ঘা প্রাচীৰেৰে আবৃত। তাত বাজেও, আমি সেই ঠাইত অনাকীয়াৰ বংশধৰ দৈত্যকায় লোকসকলকো দেখিলোঁ।’” ");
INSERT INTO asmfb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","তেতিয়া মই আপোনালোকক কৈছিলোঁ, “আপোনালোকে ভয় নকৰিব, সেই লোকসকললৈ ভয় নকৰিব। ");
INSERT INTO asmfb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","আপোনালোকৰ ঈশ্বৰ যিহোৱা আপোনালোকৰ আগে আগে আছে আৰু তেওঁ আপোনালোকৰ হৈ যুদ্ধ কৰিব। মিচৰ দেশত আপোনালোকৰ চকুৰ সন্মুখত তেওঁ যি কৰিছিল, ইয়াতো তেওঁ সেই একে কার্য কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","পুনৰ আপোনালোকে মৰুভূমিত দেখিছিল যে, কেনেদৰে আপোনালোকৰ ঈশ্বৰ যিহোৱাই সন্মুখত থাকি আপোনালোকক লৈ গৈছিল; যেনেকৈ পিতৃয়ে পুত্রক কোলাত তুলি লৈ যায়, তেনেকৈয়ে আপোনালোক যোৱা সকলো ঠাইতে, গোটেই পথত এই ঠাই নোপোৱালৈকে আপোনালোকৰ ঈশ্বৰ যিহোৱাই আপোনালোকক লৈ আনিলে।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","তথাপিও ইমানতো আপোনালোকে আপোনালোকৰ ঈশ্বৰ যিহোৱাৰ ওপৰত ভাৰসা নকৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","যিহোৱা! যি জন আপোনালোকৰ যাত্রাপথত আগে আগে গৈছিল, যাতে তেওঁ আপোনালোকৰ কাৰণে শিবিৰ পাতিবৰ ঠাই বিচাৰি পায় আৰু যি পথেদি আপোনালোক যোৱা উচিত, সেই পথ দেখুৱাই আপোনালোকক লৈ যাবলৈ তেঁৱেই ৰাতি অগ্নিৰ মাজেৰে আৰু দিনত মেঘৰ মাজেদি আপোনালোকৰ আগে আগে গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","আপোনালোকৰ কথা শুনি যিহোৱাই ক্রোধিত হৈ শপত খাই এইদৰে কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“যি উত্তম দেশ তোমালোকৰ পূর্বপুৰুষসকলক দিম বুলি মই শপত খাইছিলোঁ, নিশ্চয়কৈ এই দুষ্ট বংশৰ লোকসকলৰ মাজৰ এজনেও সেই উত্তম দেশ দেখা নাপাব। ");
INSERT INTO asmfb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","কেৱল যিফুন্নিৰ পুত্ৰ কালেবে তাক দেখিব; কালেবে যি ঠাইৰ মাজেদি খোজ কাঢ়ি গৈছিল, সেই ভূমি মই তেওঁক আৰু তেওঁৰ উত্তৰপুৰুষসকলক দিম। কাৰণ তেওঁ যিহোৱাৰ পথত সম্পুৰ্ণভাৱে চলিলে।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","আপোনালোকৰ বাবে যিহোৱাই মোৰ ওপৰতো ক্রুদ্ধ হৈ কৈছিল, “তুমিও সেই ঠাইত সোমাবলৈ নাপাবা। ");
INSERT INTO asmfb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","কিন্তু পৰিচাৰক হিচাবে তোমাৰ আগত থকা নুনৰ পুত্ৰ যিহোচূৱাইহে সেই দেশত প্রৱেশ কৰিব; তুমি যিহোচূৱাক উৎসাহিত কৰিবা, কিয়নো দেশখন অধিকাৰ কৰিবৰ কাৰণে তেওঁৱেই ইস্ৰায়েলীয়াসকলক নেতৃত্ব দি আগবঢ়াই নিব। ");
INSERT INTO asmfb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","তাৰোপৰি তোমালোকে কৈছিলা, তোমালোকৰ সৰু সৰু ল’ৰা–ছোৱালীবোৰ ক্ষতিগ্রস্ত হ’ব; কিন্তু শিশুবোৰে সেই দেশত প্রৱেশ কৰিব। কাৰণ, সিহঁতৰ ভাল বা বেয়া বুজাৰ জ্ঞান বর্তমানো হোৱা নাই। সিহঁতকেই মই এই দেশ দিম আৰু সিহঁতেইহে তাক অধিকাৰ কৰিব। ");
INSERT INTO asmfb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","কিন্তু তোমালোকে হ’লে চূফ সাগৰলৈ যোৱা বাটেদি ঘূৰি মৰুভূমিৰ ফালে যাত্ৰা কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","যিহোৱাৰ এই কথা শুনি আপোনালোকে মোক কৈছিল, “আমি যিহোৱাৰ বিৰুদ্ধে পাপ কৰিলোঁ; আমি যুদ্ধ কৰিবলৈ উঠি যাম আৰু আমি আমাৰ ঈশ্বৰ যিহোৱাই দিয়া আজ্ঞা অনুসাৰেই সকলো কার্য কৰিম।” এই বুলি আপোনালোক প্ৰতিজনে যুদ্ধৰ অস্ত্ৰ-শস্ত্র লৈ পার্বত্য অঞ্চল আক্রমণ কৰিবলৈ যুগুত হৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","তেতিয়া যিহোৱাই মোক কৈছিল, “তুমি তেওঁলোকক কোৱা, ‘তোমালোকে আক্রমণ নকৰিবা আৰু যুদ্ধও নকৰিবা। কিয়নো মই তোমালোকৰ লগত নাথাকিম’; সেয়ে যদি তোমালোক যোৱা, তোমালোক শত্রুবোৰৰ হাতত পৰাজিত হ’বা।” ");
INSERT INTO asmfb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","মই আপোনালোকক সেই কথা জনাইছিলোঁ, কিন্তু আপোনালোকে তাক নুশুনিলে। আপোনালোকে যিহোৱাৰ আজ্ঞাৰ বিৰুদ্ধাচৰণ কৰিলে; কিন্তু আপোনালোক অভিমানী লোক আৰু পার্বত্য অঞ্চললৈ উঠি গৈছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","সেই পৰ্ব্বতত বাসকৰা ইমোৰীয়াসকল আপোনালোকৰ বিৰুদ্ধে ওলাই আহিছিল আৰু মৌ-মাখিৰ দৰে আপোনালোকক খেদি পঠাইছিল। চেয়ীৰত হৰ্মালৈকে আপোনালোকক আঘাত কৰি খেদি নিছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","তেতিয়া আপোনালোকে উলটি আহি যিহোৱাৰ আগত কান্দিছিল, কিন্তু যিহোৱাই আপোনালোকৰ ক্রন্দন নুশুনিলে; তেওঁ আপোনালোকৰ ক্রন্দনলৈ কাণ নিদিলে। ");
INSERT INTO asmfb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","এইদৰে আপোনালোক কাদেচত অনেক দিন ধৰি আছিল আৰু তাতেই দীর্ঘদিন অতিবাহিত কৰিছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","যিহোৱাই যেনেকৈ আমাক নির্দেশ দিছিল, সেইদৰে আমি ঘূৰি চূফ সাগৰৰ বাটেদি মৰুভূমিলৈ যাত্ৰা কৰিছিলোঁ আৰু বহুদিন ধৰি আমি চেয়ীৰ পর্বতমালাত ঘূৰি ফুৰিছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","তাৰ পাছত যিহোৱাই মোক কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“তোমালোকে অনেক দিন ধৰি এই পাহাৰী এলেকাত ঘূৰিলা; এতিয়া উত্তৰ ফালে ঘূৰা। ");
INSERT INTO asmfb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","তুমি লোকসকলক এই আজ্ঞা দিয়া, ‘চেয়ীৰত বাস কৰা তোমালোকৰ ভাই এচৌৰ বংশধৰসকলৰ সীমাৰ ওচৰেদি এতিয়া তোমালোক যাব লাগে; তাতে তেওঁলোকে তোমালোকলৈ ভয় কৰিব; তোমালোকক দেখি তেওঁলোক আতঙ্কিত হ’ব; সেয়ে তোমালোক সাৱধানে থাকিবা। ");
INSERT INTO asmfb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","তোমালোকে এচৌৰ বংশধৰৰ সৈতে যুদ্ধ নকৰিবা; কিয়নো তেওঁলোকৰ দেশৰ কোনো অংশই মই তোমালোকক নিদিওঁ; এনেকি ভৰি থব পৰা ঠাইৰ পৰিমাণো নিদিওঁ। কাৰণ চেয়ীৰ এই পার্বত্য অঞ্চল মই এচৌক অধিকাৰ কৰিবলৈ দিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","তোমালোকে আহাৰৰ কাৰণে তেওঁলোকৰ পৰা ধন দি আহাৰ কিনি খাবা; সেইদৰে পানীও তেওঁলোকৰ পৰা কিনি পান কৰিবা। ");
INSERT INTO asmfb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","কিয়নো, মনত ৰাখিবা যে তোমালোকৰ ঈশ্বৰ যিহোৱাই তোমালোকৰ হাতে কৰা সকলো কাৰ্যত তোমালোকক আশীৰ্ব্বাদ কৰিছে; এই বৃহৎ মৰুভূমিৰ মাজেদি তোমালোকে খোজকাঢ়ি ফুৰা সময়ৰ ঘটনাবোৰ তেওঁৰ অৱগত। এই চল্লিশটা বছৰ তোমালোকৰ ঈশ্বৰ যিহোৱা তোমালোকৰ লগত আছে আৰু তোমালোকৰ একোৰে অভাৱ হোৱা নাই।” ");
INSERT INTO asmfb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","সেয়ে আমি আমাৰ ভাই চেয়ীৰৰ বাসিন্দা এচৌৰ বংশধৰৰ ওচৰেদি পাৰ হৈ আহিলোঁ। আমি এলৎ ও ইচিয়োন-গেবৰ নগৰৰ পৰা অৰাবাৰ বাট ত্যাগ কৰি মোৱাবৰ মৰুভূমিলৈ যোৱা পথৰ ফালে ঘূৰিছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","তাৰ পাছত যিহোৱাই মোক কৈছিল, “তোমালোকে মোৱাবীয়াসকলক বিৰক্ত নকৰিবা। তেওঁলোকৰ বিৰুদ্ধে যুদ্ধ নকৰিবা। তেওঁলোকৰ দেশৰ কোনো অংশই মই তোমালোকক অধিকাৰ কৰিবলৈ নিদিওঁ; কাৰণ, তেওঁলোক লোটৰ বংশধৰ আৰু মই তেওঁলোকক অধিকাৰৰ অৰ্থে আৰ নগৰ দিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","পূর্বে এই ঠাইত এমীয়াসকলে বাস কৰিছিল; এমীয়া জাতিৰ লোকসকল আছিল শক্তিশালী, সংখ্যাত অধিক আৰু অনাকীয়াসকলৰ দৰে দীৰ্ঘকায়। ");
INSERT INTO asmfb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","অনাকীয়াসকলৰ দৰে এমীয়সকলকো ৰফায়ীয়া বুলি গণিত কৰা হৈছিল; কিন্তু মোৱাবীয়াসকলে তেওঁলোকক এমীয়া বুলি কয়। ");
INSERT INTO asmfb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","চেয়ীৰতো পূর্বে হোৰীয়াসকলে বাস কৰিছিল, কিন্তু পাছত এচৌৰ বংশধৰসকলে তেওঁলোকৰ সেই ঠাইত আধিপত্য বিস্তাৰ কৰিলে। যিহোৱাই অধিকাৰ সূত্রে ইস্ৰায়েলীয়াসকলক যি দেশ দিছিল তাত তেওঁলোকে যি কার্য কৰিছিল, এচৌৰ বংশধৰসকলেও সেই একে কার্য কৰিছিল। তেওঁলোকৰ আগৰ পৰা হোৰীয়াসকলক বিনষ্ট কৰি তেওঁলোকে সেই ঠাইত নিজে বাস কৰিবলৈ ধৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","পাছত যিহোৱাই কৈছিল, “এতিয়া তোমালোকে উঠি জেৰদ জুৰি পাৰ হৈ যোৱা।” তেতিয়া আমি জেৰদ জুৰি পাৰ হলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","কাদেচ-বৰ্ণেয়াৰ পৰা জেৰদ জুৰি পাৰ হোৱালৈকে আমি যাত্ৰা কৰা আঠত্ৰিশ বছৰ হ’ল; এই আঠত্রিশ বছৰত আমাৰ ছাউনিত যিসকল যোদ্ধা পুৰুষ আছিল, তেওঁলোক সকলো যিহোৱাৰ শপত অনুসাৰে সেই প্রজন্মৰ সকলো লোক উচ্ছন্ন হ’ল। ");
INSERT INTO asmfb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ছাউনিৰ মাজৰ পৰা সেই প্রজন্মক উচ্ছন্ন কৰিবৰ কাৰণে তেওঁলোক নিঃশেষ নোহোৱা পর্যন্ত যিহোৱাৰ হাত তেওঁলোকৰ বিৰুদ্ধে আছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","সেয়ে, সকলো যোদ্ধাৰ মৃত্যু হ’ল আৰু তেওঁলোক লোকসকলৰ মাজৰ পৰা গ’ল। ");
INSERT INTO asmfb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","যিহোৱাই মোক কৈছিল, ");
INSERT INTO asmfb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“আজি তোমালোকে মোৱাবৰ সীমায়েদি আৰ নগৰ পাৰ হৈ যাব লাগে। ");
INSERT INTO asmfb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","তোমালোকে যেতিয়া অম্মোনৰ লোকসকলৰ কাষত গৈ উপস্থিত হ’বা, তেতিয়া তেওঁলোকক বিৰক্ত নকৰিবা আৰু তেওঁলোকৰ বিৰুদ্ধে যুদ্ধও নকৰিবা। কিয়নো, অম্মোনীয়াসকলৰ দেশৰ কোনো অংশই মই তোমালোকক অধিকাৰ কৰিবলৈ নিদিওঁ; কাৰণ, লোটৰ বংশধৰসকলক মই অধিকাৰৰ অৰ্থে এই নগৰ দিলোঁ।” ");
INSERT INTO asmfb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","সেই দেশকো ৰফায়ীয়াসকলৰ দেশ বুলি গণিত কৰা হয়, কাৰণ পূর্বে ৰেফায়ীয়াসকলে তাত বাস কৰিছিল। কিন্তু অম্মোনীয়াসকলে তেওঁলোকক জুমজুমীয়া বুলিহে কয়। ");
INSERT INTO asmfb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","এই জাতিৰ লোকসকল আছিল শক্তিশালী, সংখ্যাত অধিক আৰু অনাকীয়াসকলৰ দৰেই দীর্ঘকায়। কিন্তু যিহোৱাই তেওঁলোকক উচ্ছন্ন কৰিলে; অম্মোনীয়াসকলে জুমজুমীয়াসকলক উচ্ছন্ন কৰিলে আৰু তেওঁলোকৰ ঠাইত নিজৰ আধিপত্য বিস্তাৰ কৰি সেই ঠাইত বসতি কৰিলে। ");
INSERT INTO asmfb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","যিহোৱাই চেয়ীৰ-নিবাসী এচৌৰ বংশধৰসকলৰ কাৰণেও এই একে কাৰ্য কৰিছিল। সেই সময়ত যিহোৱাই এচৌৰ লোকসকলৰ সন্মুখৰ পৰা হোৰীয়াসকলক উচ্ছন্ন কৰিছিল আৰু তেওঁলোকে সেই ঠাইৰ আধিপত্য ল’লে; আজি পর্যন্ত তেওঁলোক সেই ঠাইতে বাস কৰি আছে। ");
INSERT INTO asmfb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","কপ্তোৰৰ পৰা কপ্তোৰীয়াসকলে আহি অবীয়াসকলক উচ্ছন্ন কৰি তেওঁলোকৰ সেই ঠাইত বসতি কৰিছিল। অব্বীয়াসকল তেতিয়া গাজা পর্যন্ত সকলো গাওঁবোৰতে বাস কৰি আছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","তাৰ পাছত যিহোৱাই কৈছিল, “তোমালোক উঠা আৰু যাত্ৰা কৰি অৰ্ণোন উপত্যকা পাৰ হৈ যোৱা। চোৱা, মই হিচবোনৰ ৰজা ইমোৰীয়া চীহোনক আৰু তেওঁৰ দেশকো তোমালোকৰ হাতত সমৰ্পণ কৰিলোঁ; তোমালোকে তাক অধিগ্রহণ কৰিবলৈ আৰম্ভ কৰা; সেয়ে তেওঁৰ বিৰুদ্ধে যুদ্ধ আৰম্ভ কৰা। ");
INSERT INTO asmfb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","আজিৰ পৰা মই আকাশৰ তলত থকা সমগ্র জাতিৰ মাজত তোমালোকৰ সম্বন্ধে এক ভীতি আৰু ত্ৰাসৰ সঞ্চাৰ কৰিম। তোমালোকৰ বিষয়ে শুনা মাত্ৰকেই তেওঁলোকৰ কঁপনি উঠিব আৰু তোমালোকৰ কাৰণে অত্যন্ত আতঙ্কিত হ’ব।” ");
INSERT INTO asmfb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","সেয়ে মই কদেমোৎ মৰুভূমিৰ হিচবোনৰ ৰজা চীহোনলৈ লোক পঠাই শান্তিৰ প্রস্তাৱ দি কৈছিলোঁ, ");
INSERT INTO asmfb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“আপোনাৰ দেশৰ মাজেদি মোক ৰাজআলিয়েদি যাবলৈ দিয়ক; মই সোঁ বা বাওঁ কোনোফালে নুঘূৰিম। ");
INSERT INTO asmfb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","আপোনালোকে ধনৰ বিনিময়ত মোক খাবলৈ আহাৰ আৰু পান কৰিবলৈও পানী বেচিব। কেৱল আপোনাৰ দেশৰ মাজেদি মোক খোজকাঢ়ি যাবলৈ দিয়ক। ");
INSERT INTO asmfb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","চেয়ীৰ-নিবাসী এচৌৰ বংশধৰসকলে আৰু আৰ নগৰ নিবাসী মোৱাবীয়াসকলে মোক তেওঁলোকৰ দেশৰ মাজেদি খোজকাঢ়ি যাবলৈ দিয়াৰ দৰে আপুনিও মোক ঈশ্বৰ যিহোৱাই যি দেশ আমাক দিছে, যৰ্দ্দন নদী অতিক্রম কৰি সেই দেশ নোপোৱা পর্যন্ত আপোনাৰ দেশৰ মাজেদি পাৰ হৈ যাবলৈ দিয়ক।” ");
INSERT INTO asmfb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","কিন্তু হিচবোনৰ ৰজা চীহোনে নিজ দেশৰ মাজেদি যাবলৈ আমাক অনুমতি নিদিলে; কিয়নো আপোনালোকৰ ঈশ্বৰ যিহোৱাই তেওঁৰ মন কঠিন কৰি হৃদয় অটল কৰি ৰাখিছিল, যাতে তেওঁ আপোনালোকৰ হাতত পৰে। আজি এই সময়ত তেওঁ তাকেই কৰিছে। ");
INSERT INTO asmfb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","পাছত যিহোৱাই মোক কৈছিল, “শুনা, মই চীহোন আৰু তেওঁৰ দেশ তোমাৰ হাতত শোধাই দিবলৈ আৰম্ভ কৰিলোঁ। তুমি এতিয়া তেওঁৰ দেশত বাস কৰিবৰ অর্থে সেই দেশ অধিগ্রহণ কৰা।” ");
INSERT INTO asmfb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","তেতিয়া আমাৰ বিপক্ষে যুদ্ধ কৰিবলৈ চীহোন আৰু তেওঁৰ সকলো লোক যহচ নামৰ ঠাইলৈ ওলাই আহিছিল। ");
INSERT INTO asmfb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","আমাৰ ঈশ্বৰ যিহোৱাই তেওঁক আমাৰ হাতত শোধাই দিলে; তাতে আমি তেওঁক, তেওঁৰ পুত্রসকলক আৰু তেওঁৰ লোকসকলকো আঘাত কৰি পৰাস্ত কৰিছিলোঁ। ");
INSERT INTO asmfb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","সেই সময়ত আমি তেওঁৰ সকলো নগৰ অধিকাৰ কৰি লৈছিলোঁ; নগৰৰ সকলো অধিবাসীৰ লগতে মহিলা, সৰু ল’ৰা-ছোৱালীক নিঃশেষে বিনষ্ট কৰিছিলোঁ, কাকো অৱশিষ্ট নাৰাখিলোঁ; ");
INSERT INTO asmfb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","কেৱল পশুধনবোৰ আৰু নগৰৰ পৰা লুট কৰা বস্তুবোৰ আমি নিজৰ কাৰণে লৈ আহিছিলো। ");
INSERT INTO asmfb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","অৰ্ণোন উপত্যকাৰ দাঁতিত অৰোয়েৰ নগৰ আৰু সেই উপত্যকাৰ মাজত থকা নগৰৰ পৰা গিলিয়দলৈকে আমি জয় কৰিব নোৱাৰা এনে কো