﻿USE sofia;
DROP TABLE IF EXISTS sofia.asj_vpl;
CREATE TABLE asj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES asj_vpl WRITE;
INSERT INTO asj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Maaŋ mɛŋkooŋ mɛ bɛte kini ki Jiso Krai-i: Tɛ̀ nuuŋ ŋwanɛ kini ki Mfɔŋ Daafi-i wu tɛ̀ nuuŋ ŋwanɛ kini ki Abraha-aŋ. ");
INSERT INTO asj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahaŋ tɛ̀ nuuŋ te Adzi, Adzi nuuŋ te Yakɔ, Yakɔ nuuŋ te Judas bee bɛŋwaantee, ");
INSERT INTO asj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judas nuuŋ te Pɛrɛs bɛ Dzara ɛ ni wu be tɛ̀ nuuŋ Tama. Pɛrɛs nuuŋ te Hɛsrɔŋ, Hɛsrɔŋ nuuŋ te Lam. ");
INSERT INTO asj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lam nuuŋ te Aminada, Aminada nuuŋ te Nashɔŋ, Nashɔŋ nuuŋ te Salmɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔŋ nuuŋ te Bwaas wu ni tɛ̀ nuuŋ Lahab. Bwaas nuuŋ te Obɛd wu ni tɛ̀ nuuŋ Lut. Obɛd nuuŋ te Jɛɛsi. ");
INSERT INTO asj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jɛɛsi nuuŋ te Mfɔŋ Daafi. Mfɔŋ Daafi nuuŋ te Salimu wu ni tɛ̀ nuuŋ kwɛɛ Yuria. ");
INSERT INTO asj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salimu nuuŋ te Lehobwam, Lehobwam nuuŋ te Abija, Abija nuuŋ te Asa. ");
INSERT INTO asj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nuuŋ te Jɛhoshafat, Jɛhoshafat nuuŋ te Jora, Jora nuuŋ te Yusaya. ");
INSERT INTO asj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yusaya nuuŋ te Jotam, Jotam nuuŋ te Ahas, Ahas nuuŋ te Hɛsɛkaya, ");
INSERT INTO asj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɛsɛkaya nuuŋ te Manasi, Manasi nuuŋ te Emɔ, Emɔ nuuŋ te Josaya. ");
INSERT INTO asj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya nuuŋ te Jɛkonaya bee bɛŋwaantee. Bɛ tɛ̀ biɛ be nuuŋ mfi wu bɛniiŋ bɛ Babilɔŋ tɛ̀ kɔɔ bɛniiŋ bɛ Isɛlɛɛ be gɛɛŋ bɛ be li kwɛɛŋ wube wu Babilɔ-ɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lɛjiŋ lɛlu, si bɛ tɛ̀ kɔɔyɛ bɛniiŋ bɛ Isɛlɛɛ bɛ giiŋgi bɛ be Babilɔŋ lɛ, Jɛkonaya tɛ̀ nuuŋ te Shitiya, Shitiya nuuŋ te Sɛlubabɛ, ");
INSERT INTO asj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sɛlubabɛ nuuŋ te Abiyut, Abiyut nuuŋ te Ɛliakiŋ, Ɛliakiŋ nuuŋ te Aso, ");
INSERT INTO asj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso nuuŋ te Sadok, Sadok nuuŋ te Akiŋ, Akiŋ nuuŋ te Ɛliyut, ");
INSERT INTO asj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛliyut nuuŋ te Ɛliasa, Ɛliasa nuuŋ te Mataŋ, Mataŋ nuuŋ te Yakɔ. ");
INSERT INTO asj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakɔ nuuŋ te Jɔsɛ wu nyumɛ Maariya, Maariya nuuŋ wu wu tɛ̀ biɛ Jiso wu bɛ tɛ̀ teenyi le Krai Kinsofu ki Nyɔ tɛ̀ kaachɛ. ");
INSERT INTO asj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bɛdɛɛni, bɛte kini ki Jiso-o kini tɛ̀ nuuŋ yoofi ntsɔ binɛɛ mbɛɛchɛ li Abrahaŋ mbɛ mbochu li Mfɔŋ Daafi-i, ki tuu ki nuuŋ tɛ yoofi ntsɔ binɛɛ mbɛɛchɛ li Mfɔŋ Daafi-i mbɛ mbochu li mfi wu bɛ tɛ̀ kɔɔyɛ bɛniiŋ bɛ Isɛlɛɛ bɛ giiŋgi bɛ be Babilɔŋ. Mbɛɛchɛ mfi wu bɛ tɛ̀ kɔɔyɛ bɛniiŋ bɛ Isɛlɛɛ mbɛ mbochu mfi wu bɛ tɛ̀ biɛ Krai nuuŋ ɛ bɛte bini bi bee nuuŋ yoofi ntsɔ binɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Biɛrɔ chi Jiso Krai tɛ̀ ka lɛ dze yini-i: Ni wu Maariya tɛ̀ nuuŋ ɛ bɛ tɛ̀ koo fieeŋ le gii nuuŋ kwɛɛ Jɔsɛ. Fɛ be tɛ̀ mɛɛŋ le be se fɛ bugoo, bɛ dza bɛ ŋɛŋ le wu kɛmɔɔ fwe li buŋga bu Fiana yi Waaŋ li. ");
INSERT INTO asj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si fi tɛ̀ kɛti lɛ, Jɔsɛ wu nyumi, si tɛ̀ nuuŋ wi wu tsaaŋ lɛ, tɛ̀ gii kɔŋgisi yɛ le chɔɔri wu kɛ, se beechɛ nuuŋ le gatɛ bee wu lɛjiŋ lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Si tɛ̀ gii mɛɛŋ beechi le fɛ lɛ, fi ka le nchindaa wu Taa tɛ̀ dza bɛ lɛ wuu lɛ kifiee li mfi wu tɛ̀ gii liiti, tee li wuu le, “Jɔsɛ, ŋwanɛ kini ki Mfɔŋ Daafi-i, kiiŋ ɔ ni chɛŋ ndzɔtsu Maariya si ni yih wa kɛ, kifɛ fwe chi nuuŋ bɛ chi chini chɛɛ chi wu kɛmɛ bɛ buŋga bu Fiana yi Waaŋ lɛ.” ");
INSERT INTO asj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gii biɛ ŋwaŋ wu nyuŋ bɛ nyɛ bukooŋ bwee le Jiso, kifɛ gii naa soo bɛniiŋ bee li ŋgɛ wu bibifi bi bee. ");
INSERT INTO asj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Biee bini bichu tɛ̀ ka le fi bɛ fi kɔchɛ si Taa tɛ̀ tee li kimfimɛ ki ntomfɔŋ we-e le, ");
INSERT INTO asj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yikɛ yɛɛŋ nɛ woo, ŋwaakwɛɛŋ wu kii yɛ nyuŋ kɛ wumu gii fwee, biɛ ŋwaŋ wu nyuŋ bɛ teeŋ wu le Imaniwe.” Bukooŋ buni nuuŋ le, “Nyɔ yɛ bɛ bee.” ");
INSERT INTO asj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Si kifiee kɛɛ laŋɛ li Jɔsɛ-ɛ lɛ, le kaaŋgi biee fɛ nɛɛ si nchindaa wu Taa bee tee li wuu lɛ. Tɛ̀ dzɔ Maariya li ni yih we, ");
INSERT INTO asj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","se nuuŋ le, bee wu ti mɛɛŋ ki ka kɛ kintaa si kwɛɛŋ bee nyuŋ kɛ. Bee wu tɛ̀ tsiiŋ lɛ nsiiŋ gɛɛŋ bo bu Maariya tɛ̀ biɛ. Jɔsɛ se biee nyɛ bukooŋ bu ŋwaŋ wulu-u le Jiso. ");
INSERT INTO asj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bɛ tɛ̀ biɛ Jiso li kitoŋ ki Bɛtɛlɛhɛŋ lɛ kimbɛ ki Judiya-a. Tɛ̀ nuuŋ li mfi wulu-u, Hɛrɔ tɛ̀ nuuŋ Mfɔŋ wu Judiya. Fi ka le bɛ bufii lɛ bamu tɛ̀ dza li kwɛɛŋ wumu-u lɛ kimbɛ ki jobɛ tɛti-i, be bɛ Jɛrosalɛŋ be biiti laa, ");
INSERT INTO asj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Mfɔŋ wu Bɛjuu wu bɛ biɛ wɛ nuuŋ fɛŋ le? Tɛ biiti ni kifɛ tɛ bee tɛ ŋɛŋ fintsɔŋ fiee lɛ kimbɛ ki jobɛ tɛti-i, tɛ se bɛ le tɛ boŋ wu.” ");
INSERT INTO asj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Le Mfɔŋ Hɛrɔ tuu woo ntoŋ wuni, shéŋ tɔŋ wu, yi tɔŋ tɛ mɔɔ bɛniiŋ bɛ Jɛrosalɛŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Se konchɛ bɛte muntofi bɛnɔŋa bɛnɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ bɛchu, le be banchɛ. Se bii li bee laa fɛ bɛ tɛ̀ nuuŋ le bɛ gii bɛ biɛ Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛɛ nuuŋ fɛŋ le? ");
INSERT INTO asj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Be tuu le, “Bɛ tɛ̀ nuuŋ le bɛ gii bɛ biɛ ki li kitoŋ ki Bɛtɛlɛhɛŋ ki nuuŋ kimbɛ ki Judiya. Fini nuuŋ si ntomfɔŋ wu Nyɔ tɛ̀ tsɛɛ le, ");
INSERT INTO asj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wɛ wu Bɛtɛlɛhɛŋ li kwɛɛŋ wu Juda-a, Ɔ beechɛ kɛ le ɔ sendɔɔ ŋge li kwɛɛŋ wu Juda-a kɛ. Ɔ kɛɛ le wi gii naa bo li kitoŋ kini-i wu gii ni sɛki, bɛniiŋ beŋ bɛ Isɛlɛɛ.’” ");
INSERT INTO asj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mfɔŋ Hɛrɔ se konchɛ tɛ bɛ bufii lɛ baa lɛjiŋ lɛjiŋ bii woo bujɔŋ, mfi wu fintsɔŋ filu tɛ̀ bo. ");
INSERT INTO asj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Le woo, biee toŋ be Bɛtɛlɛhɛŋ tee le, “Gɛnɛ yɛɛŋ nɛ bɔsɛyi nɛ gɔɔŋ ŋwaŋ wulu bujɔŋ. Ɛ nɛ gɔɔŋ nɛ ŋɛŋ wu, nɛ kaari nɛ bɛ nɛ tee mi nse ŋgɛɛŋ tɛ mboŋ wu.” ");
INSERT INTO asj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bɛniiŋ bɛlu woo si Mfɔŋ tee lɛ, be biee be dza ŋgɛnu wube. Le be ni be giiŋgi, be ka be ŋɛŋ fintsɔŋ fi be tɛ̀ ŋɛŋ lɛ kimbɛ ki jobɛ tɛti-i fiɛɛ si fi giiŋgi be limfwe fi doonchi be dze. Le fi gɛɛŋ fi bo fɛ ŋwaŋ wulu tɛ̀ nuuŋ, fi leŋ fe. ");
INSERT INTO asj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Si be tɛ̀ ŋɛŋ fintsɔŋ filu lɛ, be kɛmɛ kinɛɛtinɛ ŋge yi dzɔɔŋ be. ");
INSERT INTO asj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Le be gɛɛŋ be lɛ li yih yi ŋwaŋ wulu tɛ̀ nuuŋ lu, be ŋɛŋ ŋwaŋ wulu bee ni wu Maariya, be ŋguumɛ ŋwaŋ wulu lii be bundi wu. Le be boŋ wu lɛ, be gwiyɛ bɛ babi bɛ bee be buu biee bi bɛ bundi mfɔŋ lu, be nyɛ li wuu. Biee bini tɛ̀ nuuŋ kikwa ki gaa, bɛ kidzoma kimu ki bɛ teenyi le fraŋkinsɛŋ, bɛ mɛɛŋ mamu mɛ bɛ teenyi le mɛɛr. ");
INSERT INTO asj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nyɔ chiinsɛ li bee lɛ kifiee li le kiiŋ be ni kaari be to lijiŋ le be ŋɛŋ Mfɔŋ Hɛrɔ kɛ. Be dza be to lijiŋ li kwɛɛŋ wu bee lɛ dze yi jetɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Si bɛ bufii lɛ baa tɛ̀ dza be giiŋgi lɛ, fi ka le nchindaa wu Taa tɛ̀ dza bɛ lɛ Jɔsɛ lɛ kifiee li tee li wuu le, “Dza we ɔ dzɔɔ ŋwaŋ bee ni nɛɛ be nɛ bo nɛ kifi nɛ gɛɛŋ li kwɛɛŋ wu Iji-ip, nɛ ni nɛ nuuŋ le nsiiŋ gɛɛŋ bo mfi wu ŋgii naa ntee le nɛ kaari. Ntiitɔɔ ni kifɛ Mfɔŋ Hɛrɔ gii ni wɛki ŋwaŋ wulu le wo.” ");
INSERT INTO asj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jɔsɛ biee dza we, dzɔ ŋwaŋ wulu bee ni butuu butuu be dza be gɛɛŋ Ijip, ");
INSERT INTO asj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","be nuuŋ le gɛɛŋ bo mfi wu Mfɔŋ Hɛrɔ tɛ̀ la waŋ. Fi tɛ̀ ka ni le fi bɛ fi kɔchɛ si Nyɔ tɛ̀ tee li kimfimɛ ki Ntomfɔŋ we-e le, “Mi nteeŋɔ Ŋwanɛŋ wu bo li kwɛɛŋ wu Iji-ip.” ");
INSERT INTO asj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Le Hɛrɔ ŋɛŋ le bɛ bufii lɛ baa yɛɛŋ baa bɛ wu, fi fuumi wu ŋge. Se biee toŋ bɛniiŋ le be gɛɛŋ Bɛtɛlɛhɛŋ mɔɔ bimbe bi lu lichiŋ bichu, be woyɛ bɔɔŋ bɛ buniŋ bɛ nuuŋ si mbɛɛchɛ biya bifɛ nto lijiŋ. Tɛ̀ nyɛ biya bini biki si tɛ̀ bii li bɛ bufii lɛ baa woo bujɔŋ mfi wu be tɛ̀ ŋɛŋ fintsɔŋ filu. ");
INSERT INTO asj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Le be gɛɛŋ be woyɛ bɔɔŋ baa lɛ, fi se kɔchɛ si ntomfɔŋ wu Nyɔ-ɔ wu Jeremaya tɛ̀ saa wu tee le, ");
INSERT INTO asj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bɛ woo baa kitata li kitoŋ ki Lama-a, wi dii kwe, dii fuuti. Nuuŋ Lachɛ wu dii bɔɔŋ bee. Bɛ chiiŋgisi wu bɛ chiŋgisi nsiŋ, kifɛ bɔɔŋ bee mɛɛŋ yɛ lu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Le Mfɔŋ Hɛrɔ la waŋ, fi se ka le nchindaa wu Taa tɛ̀ tuu busɛ lɛ Jɔsɛ-ɛ lɛ kifiee li, li kwɛɛŋ wu Ijip wɛɛ, tee li wuu le, ");
INSERT INTO asj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Dza ɔ dzɔɔ ŋwaŋ bee ni nɛɛ be kaari nɛ to lijiŋ li kwɛɛŋ wu Isɛlɛɛ, kifɛ bɛniiŋ bɛ tɛ̀ wɛki le be wo ŋwaŋ wuni baa kwiyɛ baa.” ");
INSERT INTO asj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bɛdɛɛni Jɔsɛ dza we dzɔ ŋwaŋ wulu bee ni be to lijiŋ li kwɛɛŋ wu Isɛlɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Se nuuŋ le, tuu bɛɛ lɔɔ, woo le ŋwanɛ Mfɔŋ Hɛrɔ wu Akilo jiɔ kitindɛ ki tee lɛ Judiya sɛki, chɛŋ ŋgɛnu le. Bɛ tuu bɛ chiinsɛ li wuu lɛ kifiee li le kiiŋ ni gɛɛŋ le kɛ. Se ya gɛɛŋ nuuŋ li kitoŋ ki tɛ nuuŋ lɛ kimbɛ ki kwɛɛŋ wu Galilii, ");
INSERT INTO asj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","gɛɛŋ tsiiŋ li kitoŋ ki bɛ teenyi le Nasarɛ. Fi tɛ̀ ka lɛ le fi bɛ fi kɔchɛ si ntomfɔŋ wu Nyɔ tɛ̀ tee ŋkosi le, “Bɛ gii bɛ ni bɛ teenyi wu le Wi wu Nasarɛ.” ");
INSERT INTO asj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tɛ nuuŋ li jo yɛɛ, Jɔɔŋ Nlisulidzɔɔ dza bo gɛɛŋ libuka lɛ kimbɛ ki Judiya fenjisi jɛ yi Nyɔ li bɛniiŋ li le, ");
INSERT INTO asj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Fiiki yɛɛŋ shéŋ yinɛ, kifɛ bumfɔŋ bu liboo bwɛɛ tsɛkɛtsɛkɛ.” ");
INSERT INTO asj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔɔŋ wuni nuuŋ wu ntomfɔŋ wu Nyɔ wu Ɛsaya tɛ̀ tee kii wu mfi wu tɛ̀ yɔ le, “Jɛ yi wi dzɛŋgi yɛ libuka le, ‘Bɛ nachɛ dze yi Taa, bɛ leeki yi, yi ni yi nuuŋ tsaaŋ.’” ");
INSERT INTO asj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔɔŋ tɛ̀ lisi nuuŋ ndú yi bɛ toŋ bɛ dzúŋ yi Kamɛɛ, tɛ̀ kɛndi kitsaa li tiŋ ki bɛ nachɛ bɛ dzi yi nyaŋ, bijinɛ biee tɛ̀ nuuŋ tsóma bɛ ŋgɔɔ yi litɔɔ. ");
INSERT INTO asj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Si tɛ̀ tiiti lɛ, bɛniiŋ se buti Jɛrosalɛŋ bɛ bitoŋ bi Judiya mɔɔ bimbe bi li Dzɔɔ yi Joodaaŋ lichiŋ bichu, be bɛɛ lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Si be tɛ̀ bɛɛ lɛ, be teyi bibifi bi bee li Nyɔ-ɔ, Jɔɔŋ se lisi be li dzɔɔ li Dzɔɔ yi Joodaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Se nuuŋ le, mfi wu tɛ̀ ŋɛŋ si Bɛfarasii bee Bɛsadusii bamu ŋge bɛɛ le lii be li dzɔɔ, kweeŋ li bee le, “Kiŋgɔkɛ ki mufaa lɛ kini, ɛ noo wu tifi beŋ le nɛ kifi shéŋ yi fuuti Nyɔ yi yi gii yi doonchɛ li be-eŋ yɛɛ, nɛ se bɛɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Fɛrɛ yɛɛŋ biee bi doonchi le nɛ fiiki baa shéŋ yinɛ kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kiiŋ nɛ ni nɛ tiiti finɛ le Abrahaŋ nuuŋ chaa wunɛ kɛ. Ntee beŋ le Nyɔ nuuŋ yi fiiki ta yini yi to bɔɔŋ bɛ Abraha-aŋ. ");
INSERT INTO asj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nɛ kɛɛ le bɛ gɛɛ baa fɔɔ kituŋ li gɛɛŋ yi biti-i. Kiti kichu ki wundi yɛ muntaaŋ mu dzeeŋ kɛ, bɛ gii bɛ wa ki li gɛɛŋ yi ki-i, bɛ tɔŋ fɛtaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nlisɔɔ beŋ li dzɔɔ kifɛ nɛ fiiki baa shéŋ yinɛ. Se nuuŋ le, wi wu bɛɛ lɛ mi-i jiŋ koɔ wu yaa mi. Mmɛɛŋɔ ki kɔchɛ kɛ wi wu nnuuŋ mfanchɛ bikpɔ biee kɛ. Gii ni lisi fiee beŋ nuuŋ li tsaŋ yi Fiana yi Waaŋ li mɔɔ li wi-i. ");
INSERT INTO asj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kɛmɔɔ kintɛkɛ kee lɛ bɔ ki gii fɛɛ giiŋ lu, ke wu fɛɛ, banchɛ giiŋ yi dzeeŋ yɛɛ gɛɛ li gwɛɛ, se kotɛ mumfɛɛ tɔŋ bɛ wi wu duti nyimu nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Si Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ lɛ, Jiso tɛ̀ dza lɛ kimbɛ ki Galilii bɛ fɛ Dzɔɔ yi Joodaaŋ le Jɔɔŋ lii wu li dzɔɔ tɛ. ");
INSERT INTO asj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Se nuuŋ le, Jɔɔŋ tɛ̀ bɛchi fɛŋgi tiiti le, “Ɛ wɛ ɔ beeɔ kɛmi le ɔ lii mi li dzɔɔ, ɔ tuu ɔ bɛɛ lɛ mi-i ni?” ");
INSERT INTO asj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jiso se tuu li wuu le, “Gɛɛ fi nuuŋ lɛ dɛɛni, ɛ lɛ dze yini lɛ tɛɛ wɛ fɛ baa fiee fichu tsaaŋ fi Nyɔ wɛki.” Bɛdɛɛni Jɔɔŋ se beŋ, lii Jiso li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nɛɛ si Jiso tɛ̀ gii buti li dzɔɔ ni, fi ka le kiboo tɛ̀ gwiyɛ, ŋɛŋ Fiana yi Nyɔ si yi shiiti yi bɛɛ si kibimɛ, yi bɛ yi geri li wuu bwiŋ. ");
INSERT INTO asj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Fi ka le jɛ tɛ̀ yɔ liboo le, “Wuni nuuŋ Ŋwanɛŋ wu shéŋ, wu ŋ'wuki bujɔŋ bɛ wu ŋge.” ");
INSERT INTO asj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Fiana yi Waaŋ se tuu yi dza yi dzɔ Jiso yi gɛɛŋ bɛ wu libuka le kiŋkundi mɔnchɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Gɛɛŋ shiiŋ fe tsiiŋ fe, tɛ̀ jiti biee li jo mbaanyɛɛ li. Lɛjiŋ lɛlu, dzeeŋ bɛchi yi wuu wu. ");
INSERT INTO asj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wi wu ti mɔnchi bɛniiŋ wɛ se bɛ tee li wuu le, “Ɔɔ nuuŋ ŋwanɛ Nyɔ, ɔ tee le ta yini fiiki yi to tsée yi kibele.” ");
INSERT INTO asj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jiso tuu le, “Bɛ tsɛɛ baa le, ‘Wi ti tsiiŋ yɛ kii kibele kwaa kɛ. Wi tsiiŋ kii jɛ chichi yi buti lɛ kimfimɛ ki Nyɔ-ɔ.’” ");
INSERT INTO asj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bɛdɛɛni kiŋkundi kilu tuu ki dzɔ wu ki gɛɛŋ bɛ wu Jɛrosalɛŋ kitoŋ ki waaŋ, ki leeki wu fɛ kigɔ ki yih yi muntofi, ");
INSERT INTO asj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ki tee li wuu le, “Ɔɔ nuuŋ Ŋwanɛ Nyɔ, ɔ jiiŋ ɔ seri lɛkwiiŋ, kifɛ fi fiɛɛ ɛ bɛ tsɛɛ le, ‘Nyɔ gii yi tee le bɛnchindaa bee kiichɛ wɛ.’ Fi tuu fi nuuŋ ɛ bɛ tsɛɛ tɛ le, ‘Be gii be ka wɛ bɔbɔ le kii ɔ ni ju kikaa ko li tɛtɛ-ɛ.’” ");
INSERT INTO asj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jiso se tuu li kii le “Bɛ tsɛɛ baa tɛ le, ‘Kiiŋ ɔ ni mɔnchɛ Taa wu Nyɔ ya kɛ.’” ");
INSERT INTO asj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kiŋkundi kilu tuu ki dzɔ Jiso fe, ki gɛɛŋ bɛ wu fɛ ŋkumɛ wumu-u fɛ fwa wu dɛɛŋ liwe ŋge, ki doonchɛ wu bitoŋ bi li kikoo ki nshɛ-ɛ bichu bɛ bunɔŋa bu nuuŋ li bi-i li wuu. ");
INSERT INTO asj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Si ki doonchɛ wu lɛ ki tee li wuu le, “Ŋgii nyɛ biee bini bichu li wɛ-ɛ, ɔɔ we lɛ mi-i lii ɔ guuŋ mi.” ");
INSERT INTO asj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jiso tee li ki-i le, “Gɛnɛ laa Sataŋ! Bɛ tsɛɛ baa le, ‘Ɔ guundi Taa wu Nyɔ ya, ɔ nindi nuuŋ li yi-i kwaa.’” ");
INSERT INTO asj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bɛdɛɛni, kiŋkundi kilu chinɛ li Jiso-o, ki gɛɛŋ. Fi se ka le bɛnchindaa bɛ Nyɔ-ɔ tɛ̀ dza be bɛ be bichi lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Le Jiso dza woo le bɛ kɔɔ baa Jɔɔŋ Nlisulidzɔɔ bɛ bɛŋɛ li yih yi ncha-a, tuu dza kaari to lijiŋ kimbɛ ki Galilii. ");
INSERT INTO asj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gɛɛŋ bo Nasarɛ, dza fe gɛɛŋ tsi li kitoŋ ki Kapanu-uŋ. Kitoŋ kini nuuŋ li libɛ chi Galilii lichiŋ, libɛ chɛɛ nuuŋ lɛ bimbe bi bɛniiŋ bɛ Sɛbulɔ-ɔŋ bɛ bi Naftali. ");
INSERT INTO asj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Fini tɛ̀ ka ni le fi bɛ fi kɔchɛ si ntomfɔŋ wu Nyɔ wu Ɛsaya tɛ̀ tee le, ");
INSERT INTO asj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kimbɛ ki Sɛbulɔŋ bɛ ki Naftali bi nuuŋ lichiŋ li libɛ liwiŋ li Dzɔɔ yi Joodaaŋ, kimbɛ kɛɛ nuuŋ tɛ nshɛ yi Galilii yi bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ tɛ̀ tsiiŋ, ");
INSERT INTO asj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","bɛniiŋ bɛ tɛ̀ shiiŋ be tsiiŋ li kijibɛ-ɛ, ŋɛŋ baa kiŋ'wofu kinɔŋa. Butuu woo bwɛɛ li bɛniiŋ bani-i bɛ tɛ̀ shiiŋ be tsiiŋ li nshɛ yi kijibɛ ki kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mbɛɛchɛ li mfi wulu-u, Jiso tuu bɛchi fenjisi li bɛniiŋ li tiiti le, “Fiiki yɛɛŋ shéŋ yinɛ, kifɛ bumfɔŋ bu liboo bwɛɛ tsɛkɛtsɛkɛ”. ");
INSERT INTO asj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Le Jiso dza ni deŋgi li libɛ chi Galilii lichiŋ, ŋɛŋ bɛniiŋ bamu bɛfɛ, nuuŋ wi bee ŋwaani. Bɛniiŋ bani tɛ̀ nuuŋ Simu wu bɛ tɛ̀ teenyi le Pita, bɛ ŋwaani wu Andolo, be lendi gwii lɛ libɛ-ɛ, si nimɛ chi bee tɛ̀ nuuŋ nsuuŋ yi kɔfɛ. ");
INSERT INTO asj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jiso tee li bee le, “Biee yɛɛŋ mi, ŋgii mfɛ beŋ nɛ ni nɛ keeti nuuŋ bɛniiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mfwaa mumkpaŋ be biee be chinɛ gii yibe be dza be biki wu. ");
INSERT INTO asj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jiso se dza fe kiiŋgi, tuu ŋɛŋ bɛniiŋ bamu bɛfɛ nuuŋ tɛ wi bee ŋwaani. Bɛniiŋ bani tɛ̀ nuuŋ Jeeŋ bee ŋwaani wu Jɔɔŋ bɛ tɛ̀ nuuŋ bɔɔŋ bɛ Dzɛbɛdii, be tɛ̀ nuuŋ lɛ ŋgo-o bɛ tee wube wu Dzɛbɛdii be tuushi gii. Teeŋ tɛ be. ");
INSERT INTO asj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mfwaa mumkpaŋ be biee be shɛ ŋgo bɛ tee wube be dza be biki wu. ");
INSERT INTO asj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiso tɛ̀ dza tuu deŋgi lɛ kimbɛ ki Galilii kichu tiifi bɛniiŋ li yíh yibe yi bintaashɛ-ɛ, fenjisi ntoŋ wu dzeeŋ kii bumfɔŋ bu Nyɔ-ɔ. Tɛ̀ gii wɔnchi chigɔŋ chichu, mɔɔ chigɔŋ chi nɔŋa chichu li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bɛdɛɛni, ntoŋ wu kii wu se saaŋgɛ gɛɛŋ li kwɛɛŋ wu Silia kwikwi. Bɛniiŋ tɛ̀ bɛɛ bɛ bɛniiŋ bɛchu bɛ tɛ̀ gendi mɔɔ bɛ tɛ̀ nuuŋ li ntɔnyɛ-ɛ lɛ wuu, mɔɔ nuuŋ bɛ bɔɔŋ bɛ kiŋkundi-i ŋwɛki bɛ be, mɔɔ nuuŋ bɛ wi-i kika, mɔɔ nuuŋ bɛ tɛ̀ nuuŋ bɛ ŋgwɛ. Be bɛɛ bɛ be lɛ wɔnchi be bɛchu. ");
INSERT INTO asj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mɔɔ nuuŋ fɛŋ fɛ tɛ̀ gii giiŋgi le, bintutu bi bɛniiŋ lɛ bi nɔŋa banchi lɛ wuu jiŋ. Bɛniiŋ bani tɛ̀ dzɛti lɛ kimbɛ ki kwɛɛŋ wu Galilii, bamu dzɛti lɛ Bintsii bi Yoofi, bamu Jɛrosalɛŋ mɔɔ bitoŋ bi Judiya bimu. Bamu se dzɛti li Dzɔɔ yi Joodaaŋ liwiŋ. ");
INSERT INTO asj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Le Jiso ŋɛŋ si bintutu bi bɛniiŋ lɛ bɛɛ lɛ wuu, dza miri shee fɛ ŋkumɛ-ɛ, bɔɔŋ bee bɛ kintutu banchɛ be bɛ li wuu lichiŋ. ");
INSERT INTO asj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Se bɛchi tiifi be, tiiti le, ");
INSERT INTO asj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ kii le be baa bɛ kifoo lɛ kimbɛ ki Nyɔ-ɔ, kifɛ bumfɔŋ bu liboo bwɛɛ bu bee ");
INSERT INTO asj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ dii kwe-e, kifɛ Nyɔ gii yi chiiŋgi be. ");
INSERT INTO asj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ shiiki yi yibe fɛkwiiŋ kifɛ be gii be ji kikoo ki nshɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ dzeeŋ wuu bee, kii ntsɛ wu tsaaŋ, nshɔɔŋ se tɛti be bɛ ntsɛ wulu, kifɛ Nyɔ gii yi nyɛkɛ be. ");
INSERT INTO asj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ keeti nshiiŋ li bamu-u, kifɛ Nyɔ gii yi kɔɔ tɛ nshiiŋ bɛ be. ");
INSERT INTO asj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ shéŋ wuuti be kifɛ be gii naa be ŋɛŋ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ bɛɛ bɛ mbɛɛŋgii kifɛ bɛ gii bɛ teeŋ be le bɔɔŋ bɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kinɛɛtinɛ kinɔŋa kɛɛ ki bɛniiŋ bɛ bɛniiŋ biindi bikaa lɛ be jiŋ, kii ntsɛ wu be wu tsaaŋ, kifɛ bumfɔŋ bu liboo bwɛɛ bubee. ");
INSERT INTO asj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kinɛɛtinɛ kinɔŋa kɛɛ kinɛ, mfi wu bɛniiŋ gaashi beŋ, be biindi bikaa lɛ benɛ jiŋ, be tiiti ŋwaani biee bi bibifi bichu kii beŋ li yee li kifɛ nɛ baa bɛniiŋ beŋ. ");
INSERT INTO asj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ɛ fi kɛti lɛ nɛ nɛki yɛɛŋ nɛ kiiti, kifɛ kinsomfu kinɔŋa kɛɛ kinɛ liboo. Nɛ kɛɛ le, ɛ lɛ si bɛ gii bɛ biindi bikaa lɛ bɛntomfɔŋ bɛ Nyɔ-ɔ bɛ ŋkosi lɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nɛ baa nuuŋ ntɔŋ mɛ li nshɛ yini-i. Se nuuŋ le, ɛ ntɔŋ dza me to n'yikɛ nsiŋ, bɛ geeŋ bɛ me, me se kaari me yikɛ? Kɛ me mɛɛŋ yɛ bujɔŋ le bɛ fɛ fiee fi dzeeŋ lu fuki le bɛ shooshɛ me nsiŋ kɛ, bɛniiŋ ni be kɛti be dɛnchi me bɛ bikaa. ");
INSERT INTO asj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nɛ baa nuuŋ kiŋ'wofu ki li nshɛ yini-i. Kitoŋ ki bɛ gwaŋ li ŋkumɛ-ɛ ti nyiki yɛ yi kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wi ti tendi yɛ lambo le tuu dzɔɔ kuuki bɛ ŋkaa kɛ. Wi ti bɛɛ ɛ wu tɔŋ lambo tɔmi nuuŋ li fiee fi bɛ ti tɔɔmi lambo lu-u, wu se yeŋgi li wi kwikwi wu nuuŋ li yi-ih. ");
INSERT INTO asj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɛ nɛɛ lɛ si kiŋ'wofu wunɛ kɛmi le ni wuuti lɛ bɛniiŋ lii, ke be se ŋɛŋ nimɛ chinɛ chi dzeeŋ, be nyɛ kiyɔɔni li chaa wunɛ wu nuuŋ liboo li. ");
INSERT INTO asj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kiiŋ nɛ ni nɛ beechi le mi mbɛɛɔ le nlɛɛ biee bi nuuŋ lɛ Kiŋwaati ki bɛnchi bɛ Mɔɔsɛ-ɛ mɔɔ bi nuuŋ lɛ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ kɛ. Mi mbɛɛɔ nuuŋ le mfɛ le bi kɔchɛ bu kɔchinɛ. Mɛɛŋɔ ki mbɛ kɛ le nlɛɛshɛ bi bu lɛɛshɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ntee beŋ chɛɛŋ chɛɛŋ le nsiiŋ kiboo bɛ nshɛ gii bi ma, finlaŋ fi biooŋ lɛ fi nuuŋ lɛ Kiŋwaati ki bɛnchi fi sendɛ nuuŋ tɛ naa la li yee li fuki fɛ fi bɛ fi kɔchɛ li fiee fi fi doonchi nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Fi fiɛɛ le, wi kwikwi wu bondɛ nchi wumu lɛ bɛnchi bani-i, mɔɔ wɛɛ nchi sendɛ si la le, tiifi tɛ bɛniiŋ le be ni be bondini, kɛ mwɛ gii naa ni nuuŋ wi wu ŋkweŋ lɛ bumfɔŋ bu liboo li. Se nuuŋ le, ɛ wi wu kichi bɛnchi bani, tuu tiifi tɛ bɛniiŋ le be ni be kichi be, kɛ mwɛ gii naa ni nuuŋ wi wu nyɔŋa lɛ bumfɔŋ bu liboo li lɛnti. ");
INSERT INTO asj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ntuu ntee beŋ le, ɛ nɛ feti yɛ kiŋge kinɛ tsaaŋ le ki ni ki yɛki ki bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ mɔɔ ki Bɛfarasii lɛ kɛ, nɛ tɛ naa mɔɔ lɛ lɛ bumfɔŋ bu liboo li kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nɛ woo baa le bɛ tɛ̀ tee li bɛniiŋ bɛ ŋkosi le, ‘Kiiŋ ɔ ni wo wi kɛ. Ɛ wi wo wi, kɛ mwɛ kɛmɔɔ nsa.’ ");
INSERT INTO asj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Se nuuŋ le, ntiitɔɔ li be-eŋ le wi kwi wu dzɔ shéŋ bɛ ŋwaani, kɛ kɛmɔɔ tɛ nsa. Wi wu gaa ŋwaani, mwɛ kɛɛ le gii naa leŋ li bɛniiŋ bɛ sɛki bɛnsa-a limfwe. Wi wu teeŋ ŋwaani le, ‘Kibere, mwɛ kɛɛ le gii naa lɛ li wi wu nyɔŋa-a.’ ");
INSERT INTO asj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Fi fiɛɛ le, ɔɔ wɛki le ɔ nyɛ nya ya fɛ taantaa chi muntofi-i, ɔ kimi bubiɛɛ bu nɛɛ ŋwaana lɛ wɛ-ɛ shéŋ, ");
INSERT INTO asj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ɔ gɛɛ nya ya fɛ taantaa chi muntofi fɛchiŋ, ɔ gɛɛŋ nɛɛ ŋwaana saa nɛ nachɛ biee kwɛ, ɔ se kaari ɔ bɛ ɔ nyɛ nya ya. ");
INSERT INTO asj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ɛ wi dzɔ wɛ giiŋgi bɛ wɛ li yih yi nsa-a, ɔ gwenɛ ɔ nachɛ nɛɛ wu nɛ to wi bee sini nɛ mɛɛŋ lɛ dze, kii ni gɛɛŋ nyɛ wɛ li tsaŋ yi wi wu sɛki bɛnsa-a, se tuu wɛ li tsaŋ yi wi wu nchi-i bɛ fa wɛ li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ntee wɛ chɛɛŋ le, ɔ nuuŋ tɛ bo lu fuki fɛ ɔ mɛɛshi ɔ sooŋ finini fichu fi be tee le ɔ sooŋ siŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nɛ woo baa le bɛ tɛ̀ tee le, ‘Kiiŋ ɔ ni giiŋ bɛ kwɛɛ wi kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Se nuuŋ le, ntiitɔɔ beŋ le, wi kwikwi wu bichi kwɛɛŋ kɛmi ŋgeeŋ li wu-u, kɛ wu giiŋɔ bɛ wu li shéŋ yee li kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Fi fiɛɛ le ɛ lisi cho chi lɛ kigɔŋɛ feti le ɔ ni ɔ feti bubiɛɛ, ɔ buu lisi chilu ɔ too. Fi dzɔɔŋ le ɔ lɛɛ kimbɛ ki yi ya-a kimumkpaŋ, yɛki fɛ bɛ nuuŋ bɛ lɔŋ wɛ kwikwi fɛ wi wu nyɔŋa-a. ");
INSERT INTO asj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ɛ kibɛnɛ ko ki kigɔŋɛ feti le ɔ ni ɔ feti bubiɛɛ, ɔ sondɛ kibɛnɛ kilu ɔ too. Fi dzɔɔŋ le ɔ lɛɛ kimbɛ ki yi ya-a kimumkpaŋ, yɛki fɛ yi ya chichi nuuŋ yi gɛɛŋ fɛ wi wu nyɔŋa-a. ");
INSERT INTO asj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bɛ tɛ̀ tuu bɛ tee tɛ le, ‘Ɛ wi kooŋ bɛ kwɛsi, mwɛ tsɛɛ kiŋwaati nyɛ li kwɛɛŋ wulu-u ki doonchi le mɛɛŋ yɛ kwɛsi kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Se nuuŋ le, ntee beŋ le, ɛ wi kooŋ bɛ kwɛsi, nuuŋ yɛ le kwɛɛŋ wulu jiiɔ bukwɛɛ kɛ, kɛ wu fɛɔ nuuŋ le kwɛɛŋ wulu gɛɛŋ ni gimi bɛ buniŋ bɛ bukɛɛŋ bamu-u. Wi wu dzɔ kwɛɛŋ wu bo li nyuŋ wumu yih, wu gɛɛ li wuu yih, kɛ mwɛ dzɔɔ kwɛɛ wi. ");
INSERT INTO asj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nɛ tɛ̀ woo tɛ si bɛ tɛ̀ tee li bɛniiŋ bɛ ŋkosi-i le, ‘Ɔɔ tee fiee ɔ chini, kiiŋ ɔ ni ba fi mfɛru nsiŋ kɛ. Ɔ kɛmi le ɔ fɛ fiee fi ɔ tee, ɔ chini li Taa li limfwe le ɔ gii ɔ fɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Se nuuŋ le, ntuuɔ ntiiti li be-eŋ le, kiiŋ wi ni tee fiee chini kɛ. Kiiŋ wi ni chini li bukooŋ bu liboo li kɛ, kifɛ liboo nuuŋ kabara wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kiiŋ wi ni chini li nshɛ-ɛ kɛ, kifɛ nshɛ nuuŋ kilaanda ki bikaa bi Nyɔ-ɔ tɛ. Kiiŋ wi ni chini li Jɛrosalɛŋ kɛ, kifɛ Jɛrosalɛŋ nuuŋ kitoŋ ki Mfɔŋ wu nyɔŋa-a. ");
INSERT INTO asj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kiiŋ wi ni tuu chini nɛɛ li yi yee li kɛ, kifɛ wi nuuŋ tɛ fɛ le yi ye yi li fa mumkpaŋ to chibu, kɛ le yi libɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ɛ wi beŋ fiee le, ‘Iiŋ’, fi kɔchɛ lɛ. Ɔ wu faaŋ le, ‘Wohoo’, fi kɔchɛ nɛɛ tɛ lɛ. Ɛ wu taa fiee fe, kɛ fiɛɛ fiee dza fiɛɛ nuuŋ fɛ wi wu bifi wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nɛ woo baa tɛ le, bɛ tɛ̀ tee le, ‘Ɛ wi buu lisi chi wi-i, bɛ buu tɛ chi mwɛ-ɛ. Ɛ wi buu kige ki wi-i, bɛ buu tɛ kee.’ ");
INSERT INTO asj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Se nuuŋ le, ntiitɔɔ li be-eŋ le, kiiŋ wi ni ni nyiitini fiee bɛ wi wu bifi kɛ. Ɛ wi maaŋ kilaanchɛ ko ki kigɔŋɛ, ɔ fiiki ki kimɛsɛ mɛɛshi maaŋ. ");
INSERT INTO asj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ɛ wi dzeti wɛ li nsa-a kii ndu ya yi lɛnti, ɔ mɛɛshi ɔ taa mɔɔ kiŋkoŋ ko fe. ");
INSERT INTO asj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɛ wi kaŋ wɛ le ɔ dɛndɛ ma mumkpaŋ, ɔ dɛndɛ bɛma bɛfɛ nɛɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɛ wi lɛkɛ fiee li wɛ-ɛ, ɔ nyɛ wu. Ɛ wi feeti fiee li wɛ-ɛ, kiiŋ ɔ ni faaŋ nyɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nɛ woo baa tɛ ɛ bɛ tɛ̀ tee le, ‘Ɔ kɔŋgisi ŋwaana, ɔ baanini wi wa wu mbani.’ ");
INSERT INTO asj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Se nuuŋ le, ntiitɔɔ li be-eŋ le, nɛ kɔŋgisi yɛɛŋ bɛniiŋ bɛnɛ bɛ mbani-i, nɛ lɛki li Nyɔ-ɔ li bɛ biindi bikaa lɛ benɛ jiŋ. ");
INSERT INTO asj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bɛdɛɛni, nɛ se ni nɛ nuuŋ bɔɔŋ bɛ Baa wunɛ wu nuuŋ liboo li. Ɛ wu, wu ti feti wiiŋ bɛndi li bɛniiŋ bɛ bifi-i mɔɔ li bɛ dzeeŋ li. Ti feti tɛ dzaaŋ bɛɛ li bɛniiŋ bɛ feti biee bi tsaaŋ li, mɔɔ li bɛ feti yɛ biee bi tsaaŋ kɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nɛ beechi le ɛ nɛ kɔŋgisi nuuŋ bɛniiŋ bɛ kɔŋgisi beŋ kwaa, mbeŋ wulu se nuuŋ la li be-eŋ? Ɛ nɛɛ lɛ tɛ si bɛniiŋ bɛ kundi kiŋwaati ti feti ni? ");
INSERT INTO asj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ɛ nɛ yɛɛshi nɛɛ nuuŋ bɛŋwaana bɛnɛ kwaa, fiee fi nɛ se feti fi bɛniiŋ bamu feti yɛ kɛ nuuŋ fi la? Mɔɔ bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ ti feti nɛɛ tɛ lɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Fi fiɛɛ le nɛ dzɔɔŋ nɛ gɛɛŋ nɛ mɛɛshi si Baa wunɛ wu nuuŋ liboo dzɔɔŋ wu gɛɛŋ wu mɛɛshi tɛ lɛ.” ");
INSERT INTO asj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nɛ ŋiŋgi yɛɛŋ le, ɛ nɛ feti biee bi dzeeŋ, nɛ fɛ kɛ lɛ bɛniiŋ li limfwe le be ni be ŋiŋgi kɛ. Ɛ nɛ feti lɛ, Baa wunɛ wu nuuŋ liboo tɛ sooŋ beŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Fi fiɛɛ nuuŋ le, mfi wu ɔ nyɛɛ fiee li wi wu kifoo li, kiiŋ ɔ ni ɔ teŋgi kimbuu si bɛniiŋ bɛ nimi ti shiiŋ be feti li yíh yi lɛkɛ li Nyɔ-ɔ mɔɔ lɛ dze, le bɛniiŋ ni be piɛti be kɛ. Ntee beŋ chɛɛŋ chɛɛŋ le be kɛmɛ baa kinsomfu ki bee kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Se nuuŋ le, mfi wu ɔ nyɛɛ fiee li wi wu kifoo li, kiiŋ ɔ ni fɛ le kibɛnɛ ko ki kimɛsɛ kɛɛ fiee fi ki kigɔŋɛ feti kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bɛdɛɛni, nya ya ni yi nuuŋ lɛ munyiikɔɔ li, Baa wa wu ti ŋiŋgi biee bi bɛ feti lɛ munyiikɔɔ li se sooŋ wɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mfi wu nɛ lɛki li Nyɔ-ɔ, nɛ fɛ kɛ si bɛniiŋ bɛ nimi-i ti feti kɛ. Be ti kɔŋgisi nlemɛ li yih yi nlɛkɛ li Nyɔ-ɔ, mɔɔ lɛ dzé ntasɛ be se lɛki li Nyɔ-ɔ, le bɛniiŋ se ŋɛŋ be. Ntee beŋ chɛɛŋ le be kɛmɛ baa kinsomfu ki bee kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Se nuuŋ le, mfi wuɔ wɛki le ɔ lɛkɛ li Nyɔ-ɔ, ɔ lɛ lɛ yi-ih lɛnti, ɔ bɛŋɛ kigoo ɔ se lɛki. Baa wa wu nuuŋ lɛ munyiikɔɔ li, Baa wa wu shiiŋ ŋiŋgi biee bi ɔ feti lɛ munyiikɔɔ li se sooŋ wɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ɛ nɛ tuu lɛki li Nyɔ-ɔ, kiiŋ nɛ ni nɛ yoomfi si bɛniiŋ bɛ ti kii yɛ Nyɔ kɛ ti shiiŋ be feti lɛ kɛ. Be ti feti lɛ be beechi le bɛ gii bɛ woo nlɛkɛ li Nyɔ-ɔ wu be kii jɛ́ yibe yeti ŋge. ");
INSERT INTO asj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kiiŋ nɛ ni nɛ nuuŋ si be kɛ. Nɛ kɛɛ le Baa wunɛ kiiɔ fiee fi nɛ wɛki kituŋ nɛ mɛɛŋ saa fi ki bii kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nɛ kɛmi le nɛ ni nɛ lɛki li Nyɔ-ɔ ni: ‘Baa wusɛŋ wu nuuŋ liboo, fɛrɛ bɛniiŋ ni be guundi bukooŋ bwo, ");
INSERT INTO asj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ɔ fɛ le bumfɔŋ bwo bɛ, ɔ fɛ le fiee fi ɔ kɔŋgisi ni fi nuuŋ laaŋkwiiŋ si fi nuuŋ liboo. ");
INSERT INTO asj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyɛ bee bijinɛ bi bɛŋ. ");
INSERT INTO asj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɔ feeki bee bibifi bisɛŋ, si tɛ̀ gii ti fekisi bibifi bi bɛniiŋ bamu feti li bee li. ");
INSERT INTO asj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kiiŋ ɔ ni chinɛ le tɛ lɛ li mɔnchɛ-ɛ kɛ. Fi bee li tsaŋ yi wi wu bifi wɛ-ɛ. Bumfɔŋ nuuŋ bwo, buŋga nuuŋ bwo, bunɔŋa nuuŋ bwo mfi kwi ma nsiŋ. Gɛɛ fi nuuŋ lɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nɛ kɛɛ le ɛ nɛ fekisi bibifi bi bɛniiŋ bamu feti li be-eŋ, Baa wunɛ wu nuuŋ liboo se ni fekisi binɛ tɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Se nuuŋ le, ɛ nɛ fekisi yɛ bibifi bi bɛniiŋ bamu feti li be-eŋ kɛ, Baa wunɛ tɛ feeki tɛ bibifi binɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mfi wu nɛ jiti biee bijɛ, kiiŋ nɛ ni nɛ bichi fuyaa si bɛniiŋ bɛ nimi-i ti feti kɛ. Be ti suuti fɛ lii fɛ bee li mfi wulu-u, le bɛniiŋ se ŋɛŋ le be jiti baa biee bijɛ. Nse ntiitɔɔ li be-eŋ chɛɛŋ le be kɛmɛ baa kinsomfu ki bee li nshɛ yini-i kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Se nuuŋ le, mfi wu ɔ jiti biee bijɛ, ɔ tsootsɛ yi ya, ɔ fwa bushi bwo, ");
INSERT INTO asj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bɛniiŋ se tɛ kɛɛ le ɔ jitɔɔ biee bijɛ kɛ, Baa wa wu nuuŋ lɛ munyiikɔɔ li ni ŋiŋgi. Baa wa wu ti ŋiŋgi biee bi bɛniiŋ feti lɛ munyiikɔɔ li se sooŋ wɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kiiŋ nɛ ni kiri bulofu bunɛ laaŋkwiiŋ fɛ nuuŋ shee kaaŋ, maŋgere kɔɔ, mɔɔ fɛ bɛyi nuuŋ be bondɛ be lɛ be yi kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kiri yɛɛŋ bulofu bunɛ nuuŋ li kwɛɛŋ wu liboo li, fɛ shee nuuŋ tɛ kaaŋ kɛ, bɛ fɛ maŋgere nuuŋ tɛ kɔɔ bu kɛ, mɔɔ bɛ fɛ bɛyi nuuŋ tɛ naa bondɛ le be lɛ be yi kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nɛ ni nɛ kii le fɛ wi kiri bulofu bwee fe, ɛ nɛɛ fe fɛ shéŋ yee gii yi ni yi nuuŋ. ");
INSERT INTO asj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lisi cho nuuŋ lambo li yi ya-a. Bɛdɛɛni, ɛ lisi cho wuutɔɔ, kɛ yi ya chichi yisɛ yɛɛ bɛ kiŋ'wofu. ");
INSERT INTO asj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Se nuuŋ le, ɛ lisi cho kwi, kɛ yi ya chichi yisɛ yɛɛ bɛ kijibɛ. Ɛ kiŋ'wofu ki wi-i dza ki to kijibɛ, se kijibɛ kilu gbɛɛŋ ki nuuŋ niŋ? ");
INSERT INTO asj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Wi nuuŋ tɛ niŋ li bɛte bikoo li bɛfɛ kɛ. Ɛ nindi lɛ, kɛ gii ni baanini wumu, kɔŋgisi wumu, gii ni wuki li wumu ŋge, tɛ dzɔ wumu wɛ li fiee li kɛ. Nɛ nuuŋ nɛ tɛ niŋ li Nyɔ-ɔ le nɛ tuu nɛ niŋ li kwa-a kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Bɛdɛɛni, ntiitɔɔ li be-eŋ le kiiŋ nɛ ni nɛ buki yi kii ntsɛ wunɛ laa, nɛ gii nɛ ji la, mɔɔ laa nɛ gii nɛ woŋ la, mɔɔ nuuŋ kii yi yinɛ laa, nɛ gii nɛ lii la le kɛ. Ntsɛ wu wi yɛki nɛɛ biee bijɛ, yi yi wi yɛki nɛɛ ndú ni? ");
INSERT INTO asj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bichɛ yɛɛŋ nɛ ŋɛŋ si muniiŋ mu jiindi liwe. Mu ti tɔyi yɛ, mu ŋ'wechi yɛ bijinɛ le mu banchɛ mu gɛɛ li bigɔɔnu kɛ. Se nuuŋ le, Baa wunɛ wu nuuŋ liboo nyɛki nɛɛ mu. Bɛdɛɛni, nɛ yɛki yɛ muniiŋ muni ni? ");
INSERT INTO asj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɛ noo lɛ be-eŋ lɛnti wu buki yi wu nuuŋ tondɛ mfi mumkpaŋ li ntsɛ we-e? ");
INSERT INTO asj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nɛ se buki yi kii ndú le la? Bichɛ yɛɛŋ nɛ ŋɛŋ si bɛflaaba bɛ kuu libuka ti nindi yɛ, kɛ le be taa ndú kii yi yi be kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nɛɛ lɛ ntee beŋ le mɔɔ nuuŋ Mfɔŋ Salimu li bunɔŋa bwee buchu bu gii tɛ̀ kɛmi ti mɛɛŋɔ saa ki chuumɛ kɛ yi yee bɛ ndú le kɔchɛ bujɔɔŋ bu flaaba wumu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɛ Nyɔ ti chuumini kitɔɔ ki kuu libuka, kitɔɔ ki kuu bɛŋ, ɛ bo fwaa bɛ kukɛ ki fɛtaaŋ, yi gii se lee ki chuumɛ kɛ beŋ bɛ ndú yi yaa ki ni? Hooo beŋ bɛniiŋ bɛ kɛmi kimbeenchɛ kintɛŋ bani! ");
INSERT INTO asj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bɛdɛɛni, kiiŋ nɛ ni nɛ buki yi nɛ kweŋgi laa nɛ gii nɛ ji la, nɛ woŋ la, kɛ nɛ gii nɛ lii la li yi yinɛ le kɛ. ");
INSERT INTO asj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Biee bini bichu nuuŋ bi bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ ti shiiŋ be giki bufii li bi-i. Nɛ kɛɛ le Baa wunɛ wu nuuŋ liboo kiiɔ le nɛ wɛki baa biee bini bichu. ");
INSERT INTO asj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Saa yɛɛŋ nɛ gɛɛ bufii bunɛ nuuŋ li bumfɔŋ bu Nyɔ-ɔ kwɛ bɛ li biee bi nuuŋ tsaaŋ lɛ yi-i lii, yi se tondɛ biee bini bichu li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Fi se fiɛɛ le, kiiŋ nɛ ni nɛ bakini kii fwaa kɛ. Mbakinɛ kii fiee fi fwaa, nuuŋ fwaa. Ŋgɛ wu li jobɛ kɔchɛ nɛɛ nuuŋ li jobɛ chilu-u chɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nɛ saa kɛ biŋge bi bɛniiŋ bamu-u kɛ, ɛ fi nuuŋ lɛ, Nyɔ tɛ saa tɛ kinɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nɛ kɛɛ le dze yi nɛ sɛki kiŋge ki wumu-u, ɛ nɛɛ yi yi Nyɔ gii yi saa tɛ kinɛ le. Fiee fi wi fichini fiee le nyɛ li wi-i ɛ fi fi Nyɔ gii naa yi fichɛ le yi se nyɛ li mwɛ-ɛ tɛ. ");
INSERT INTO asj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Fi geeŋ fiɔɔ ŋiŋgi sheeŋ yi kwiŋ yi nuuŋ ŋwaana lɛ lii, ɔ se tɛ ŋɛŋ kiŋkɔsi ki kwi-iŋ ki nuuŋ lɛ lii ya kɛ? ");
INSERT INTO asj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kɛ fi geeŋ fiɔɔ nuuŋ ɔ tee li ŋwaana le ‘Ŋwaanɛŋ bɛ mbuu sheeŋ yɛɛ lɛ wɛɛ lii,’ ɔ tɛ ŋɛŋ tɛ kiŋkɔsi ki nuuŋ wɛɛ lɛ lii kɛ? ");
INSERT INTO asj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɛ wi wu nimi! Saa buu ko ki nuuŋ wɛ lɛ lii ɔ se bɔsɛyi ɔ ŋɛŋ sheeŋ yi nuuŋ ŋwaana lɛ lii, ɔ se buu. ");
INSERT INTO asj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kiiŋ nɛ ni dzɔɔ fiee fi Nyɔ-ɔ nɛ nyɛ li bwí kɛ. Ɛ nɛ fɛ lɛ, yi fiiki yi numɛ beŋ. Kiiŋ nɛ ni dzɔɔ fincha fi waaŋ nɛ nyɛ li dziiŋ li kɛ. Ɛ nɛ fɛ lɛ, yi bɛ yi dɛnchɛ beŋ bɛ bikaa.” ");
INSERT INTO asj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nɛ biiti yɛɛŋ, Nyɔ gii yi nyɛ beŋ. Nɛ geendi yɛɛŋ, Nyɔ gii yi doonchɛ beŋ. Nɛ kundi yɛɛŋ kigoo, Nyɔ gii yi gwiyɛ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nɛ kɛɛ le wi kwikwi wu biiti, gii kɛmɛ, wi kwikwi wu wɛki, gii ŋɛŋ, wi wu kundi kigoo bɛ gii bɛ gwiyɛ li mwɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ɛ noo li be-eŋ linti wu ŋwani bii wu bunɛɛŋ, se tuu nyɛ wu nuuŋ tɛtɛ? ");
INSERT INTO asj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kɛ wu bii wu nsuuŋ, tuu nyɛ wu nuuŋ yɔ? ");
INSERT INTO asj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɛ beŋ bɛ nuuŋ bɛniiŋ bɛ bifi ti kii si bɛ nyɛɛ biee bi dzeeŋ li bɔɔŋ bɛnɛ, Baa wunɛ wu nuuŋ liboo lee ki nyɛ kɛ biee bi dzeeŋ li bɛniiŋ bɛ biiti li wuu yɛki si nɛ nyɛɛ lɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Fi se fiɛɛ le, fiee fi nɛ kɔŋgisi le bɛniiŋ fɛ li be-eŋ, ɛ nɛɛ fi fi nɛ nuuŋ nɛ ni nɛ feti tɛ li bee, kifɛ fini fiɛɛ fiee fichu fi kiŋwaati ki bɛnchi bɛ Mɔɔsɛ mɔɔ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ tiifi.” ");
INSERT INTO asj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Lɛ yɛɛŋ nuuŋ lɛ fweeŋ wu mbaŋ wu nuuŋ kimfasɛ-ɛ, kifɛ fweeŋ wu nuuŋ mgbooŋ bɛ dze yi nuuŋ tsɛkɛ, giiŋgi nuuŋ fɛ be gii be la bula, bɛniiŋ se lii baa lɛ yi-i ŋge. ");
INSERT INTO asj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nɛ ni nɛ kii le fweeŋ wu mbaŋ wu kimfasɛ, bɛ dze yi tɛɛmi nuuŋ yi giiŋgi fɛ ntsɛ wu kimakɛ-ɛ. Bɛniiŋ bɛ ŋiŋgi yi baa niiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nɛ dzeti yɛɛŋ mfi kii bɛniiŋ bɛ yɛŋgi le be baa bɛntomfɔŋ bɛ Nyɔ-ɔ. Be bɛɛ lɛ be-eŋ be yeŋgi le be baa nshɔ́ɔŋ, se nuuŋ le, be nuuŋ bɛmbɔɔŋku lɛnti bɛ yeŋgi si nshɔ́ɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nɛ gii nɛ kɛɛ be nuuŋ li biŋge bi bee nɛɛ si bɛ ti kii kiti nuuŋ li muntaaŋ mu woŋ li kiti kilu-u lɛ. Nuuŋ bɛ kɔ muntaaŋ mu lembee li bifafu ni, kɛ nuuŋ bɛ kɔ muntaaŋ mu ‘fi-ig’ li kiti ki biaaŋ ni? ");
INSERT INTO asj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Fi fiɛɛ le kiti ki dzeeŋ kichu ti wundi muntaaŋ mu dzeeŋ, kiti ki bifi wundi muntaaŋ mu bifi. ");
INSERT INTO asj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nuuŋ kiti ki dzeeŋ tɛ woŋ muntaaŋ mu bifi kɛ. Fi nuuŋ tɛ le kiti ki bifi nuuŋ tɛ woŋ muntaaŋ mu dzeeŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kiti kichu ki wundi yɛ muntaaŋ mu dzeeŋ kɛ, bɛ gii bɛ wa ki bɛ tɔŋ fɛtaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Fi fiɛɛ le, nɛ gii nɛ kɛɛ bɛniiŋ bɛ binsɛɛ lɛ bɛlu nuuŋ li biŋge bi bee.” ");
INSERT INTO asj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ɛ wi kwikwi wu teenyi mi le, ‘Taa, Taa’, wu gii lɛ li bumfɔŋ bu liboo li kɛ. Ɛ nɛɛ wi wu feti fiee fi Taa wu nuuŋ liboo kɔŋgisi. ");
INSERT INTO asj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gii bɛ bo jobɛ chi nsa wu kimɛrisɛ, bɛniiŋ ŋge gii be ni be biiti li mi-i laa, ‘Taa, Taa, tɛ tɛ̀ laŋini bɛntoŋ bɛ Nyɔ-ɔ li bukooŋ bwo-o, tɛ bushi bɔɔŋ bɛ kiŋkundi-i li yi yi bɛniiŋ li bukooŋ bwo-o, tɛ feti nɛɛ mɔɔ bintɛwa bi biee lɛ li bukooŋ bwo-o ni?’ ");
INSERT INTO asj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nse ntuu ntee li bee le, ‘Nti mɛɛŋɔ nsaa ki kɛɛ kɛ beŋ kɛ. Dzatsɛ yɛɛŋ mi lii beŋ bɛniiŋ bɛ nuuŋ tɛ biee bɛnchi bɛ Nyɔ-ɔ kɛ.’” ");
INSERT INTO asj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bɛdɛɛni, wi kwikwi wu wuki jɛ yɛŋ yini, feti si yi tiiti wɛ si wi wu bufii wu tɛ̀ gwaŋ yih ye li kimba-aŋ. ");
INSERT INTO asj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Le dzaaŋ we, dzɔ́ɔ yisɛ, mbaandze ka ju yih yilu, se nuuŋ le, yih yilu ba ki kemɛ kɛ, kifɛ tɛ̀ fɛ kimfoo kilu li kimba-aŋ liwe. ");
INSERT INTO asj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Se nuuŋ le, wi wu wuki jɛ yɛŋ yini tɛ fɛ si yi tiiti kɛ, kɛ mwɛ wɛ nɛɛ si kibere ki wi-i ki tɛ̀ gwaŋ yih ye nuuŋ li mfwɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Le dzaaŋ we, dzɔ́ɔ yisɛ, mbaandze ka, ju yih yilu, yi kemɛ, yi we likwiiŋ chichi bɛ chiiŋ ni guuu.” ");
INSERT INTO asj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Le Jiso tee be biee bini bichu mɛɛshi, wa tɛ kintutu ki bɛniiŋ lɛ kilu kii ntiifɛ we, ");
INSERT INTO asj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kifɛ tɛ̀ gii tiifi si wi wu kɛmi buŋga bu ntiifɛ. Tɛ̀ tiifi yɛ si bɛniiŋ bɛ bee bɛ ti tiifi bɛnchi bɛ Nyɔ-ɔ tɛ̀ shiiŋ be tiifi kɛ. ");
INSERT INTO asj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jiso tɛ̀ dza li ŋkumɛ-ɛ bɔɔ, kintutu ki bɛniiŋ lɛ kinɔŋa banchɛ ki biki wu. ");
INSERT INTO asj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Fi se ka le wi wumu wu tɛ̀ gendi bɛ chigɔŋ chi nɔŋa, tɛ̀ dza bɛ toŋ núŋ Jiso limfwe tee li wuu le, “Taa, nuuŋ ɔ wɔnchɛ mi ni ŋ'wuuti, ɔɔ kɔŋgisi lɔɔ.” ");
INSERT INTO asj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jiso dza nɛɛki kibɛnɛ, koŋ li wuu, tee le, “Ŋkɔŋgisɔɔ, tɛmi ɔ ni ɔ wuuti.” Mfwaa mumkpaŋ, chigɔŋ chi nɔŋa chilu biee chi ma li wuu bwiŋ, to waaŋ. ");
INSERT INTO asj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jiso se chiinsɛ li wuu le, “Bichɛ, kiiŋ ɔ ni tee li wi-i kɛ. Si fi nuuŋ ni, gɛnɛ ɔ doonchɛ yi ya nuuŋ li te muntofi-i, ɔ nyɛ nya yi Mɔɔsɛ tɛ̀ tee le wi kɛmi le nyɛ, le doonchɛ li bɛniiŋ li le wu tɛmɔɔ li chigɔŋ chini wu to waaŋ.” ");
INSERT INTO asj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jiso dza gɛɛŋ lɛ li kitoŋ ki Kapanu-uŋ, te kikoo wu bɛniiŋ bɛ nchi-i wumu bɛ ŋɛŋ wu suŋgi bɔ li wuu tiiti le, ");
INSERT INTO asj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Taa, ŋwanɛŋ wu nimɛ gimɔɔ li yih ɛ ŋgwɛ kɔɔ wu.” ");
INSERT INTO asj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jiso tee li wuu le, “Ŋgii mbɛ ŋ'wɔnchɛ wu.” ");
INSERT INTO asj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Se nuuŋ le, te kikoo wu bɛniiŋ bɛ nchi-i wulu tuu li Jiso le, “Taa, mɛɛŋɔ ki kɔchɛ kɛ wi wu ɔ nuuŋ ɔ bɛ li wuu yi kɛ. Yɔrɛ nɛɛ nuuŋ jɛ kwaa, ŋwanɛŋ wu nimɛ tɛmi. ");
INSERT INTO asj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mi ŋ'we tɛ lɛ buŋga bu wi wumu lɛkwiiŋ, bɛniiŋ bɛ nchi-i nuuŋ tɛ lɛ mi-i lɛkwiiŋ. Mbɛɛ ɛ mi ntee li wumu le, ‘Ɔ giiŋgi,’ mwɛ gɛɛŋ, ɛ mi ntuu mi ntee li wumu le, ‘Bɛ,’ mwɛ bɛ. Ɛ mi ntee tɛ li mfwa wɛ-ɛŋ le, ‘Fɛrɛ fini,’ fɛ nɛɛ tɛ lɛ.” ");
INSERT INTO asj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Le Jiso woo fiee fi wu tee, wa tɛ wu. Kweeŋ li bɛniiŋ bɛ tɛ̀ biki wu baa le, “Ntee beŋ chɛɛŋ le, mɛɛŋɔ saa ki ŋɛŋ mɔɔ nuuŋ wi mumkpaŋ wu Isɛlɛɛ wu gɛɛ ŋwaani yini shéŋ li mi-i ni kɛ. ");
INSERT INTO asj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ntee beŋ le, bɛniiŋ ŋge gii naa be dza bimbe bichu mbɛɛchɛ lɛ jobɛ tɛti ŋgɛnu mbochu lɛ chi sechi, be ni be bɛɛ be shiiti be jii biee bɛ bɛ chaa bɛnɛ, Abrahaŋ, Adzi mɔɔ Yakɔ li kwɛɛŋ wu Nyɔ-ɔ wu liboo li, ");
INSERT INTO asj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","se nuuŋ le, bɔɔŋ bɛ li kwɛɛŋ wulu kibɛɛ bɛ gii bɛ lɔŋ be li kijibɛ-ɛ lɛkuuŋ fɛ be gii be ni be dii be jii ŋgesi.” ");
INSERT INTO asj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Si Jiso tɛ̀ yɔ lɛ, biee tee li te kikoo wu bɛniiŋ bɛ nchi-i wɛ le, “Nuuŋ ɔ gɛɛŋ fio, si ɔ bee ɔ gɛɛ shéŋ li mi-i ni, fi ka nɛɛ bɛ wɛ lɛ.” Le tee lɛ, ŋwaŋ wu nimɛ wu te kikoo wu bɛniiŋ bɛ nchi-i wulu biee tɛmi nɛɛ li mfi wulu-u. ");
INSERT INTO asj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jiso tɛ̀ dza gɛɛŋ lɛ li Pita yih, ŋɛŋ si mwɛsɛ Pita gimi gendi bɛ kiŋkɛŋkɛ. ");
INSERT INTO asj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jiso koŋ li kibɛnɛ kee li, kiŋkɛŋkɛ kilu se biee ki chikɛ, dza we bichɛ fiee Jiso ji. ");
INSERT INTO asj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Le ni nuuŋ lɛ fɛmfo-o, bɛniiŋ bɛɛ bɛ bɛniiŋ ŋge bɛ bɔɔŋ bɛ kiŋkundi-i tɛ̀ gii be ŋwɛki bɛ be lɛ Jiso-o. Bɛchi buushi fiana yi tii yilu nuuŋ nɛɛ bɛ jɛ yi lɛwa kwaa. Se wɔnchi bɛniiŋ bɛchu bɛ tɛ̀ gendi. ");
INSERT INTO asj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fi bɛ fi kɔchɛ si ntomfɔŋ wu Nyɔ wu Ɛsaya tɛ̀ saa wu tee le, “Wu tsaakɔɔ bɛ ntɔnyɛ bɛsɛŋ, wu too chigɔŋ chisɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Le Jiso tuu ŋɛŋ si kintutu ki bɛniiŋ lɛ kinɔŋa banchɛ li wuu lichiŋ, tee li bɔɔŋ bee bɛ kintutu-u le, “Tɛ lenchi libɛ chini tɛ gɛɛŋ luwiŋ lɔɔ.” ");
INSERT INTO asj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wi wumu wu tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ biee kiiŋgi tee li Jiso le, “Wi wu ntiifɛ, ŋgii ni mbiki wɛ mɔɔ ɔ giiŋgi fɛŋ le.” ");
INSERT INTO asj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jiso tuu li wuu le, “Bijinu kɛmi ntuuŋ yi bi, muniiŋ mu jiindi liwe kɛmi yíh yi mu, se nuuŋ le, Ŋwanɛwi kɛmi yɛ mɔɔ fɛ nuuŋ gɛɛ kikoo kee fe kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wi we wu kintutu wumu tuu tee li wuu le, “Taa, gɛɛ mi nsaa ŋgɛɛŋ ndiiyɛ taa kwɛ nse ni mbiki wɛ.” ");
INSERT INTO asj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jiso se tuu li wuu le, “Ɔ biki mi, gɛɛ biŋkwi ni bi diyi biŋkwi bi bee bi kwiyɛ.” ");
INSERT INTO asj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jiso gɛɛŋ lɛ lɛ ŋgo-o, bɔɔŋ bee bɛ kintutu-u biee tɛ wu le. ");
INSERT INTO asj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Fi ka le, mfiee yi tɛɛmi yimi tɛ̀ taa yi dza yi bɛchi lɛ libɛ chilu-u yi nduŋgi dzɔɔ yɛki, yi leki le yi yisɛ lɛ ŋgo wulu. Si fi tɛ̀ kɛti lɛ, Jiso tɛ̀ liiti fiee. ");
INSERT INTO asj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bɔɔŋ bee bɛ kintutu-u se gɛɛŋ be kaaŋgi wu be tee le, “Taa, fi bee, tɛ kwii baa.” ");
INSERT INTO asj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Se kaaŋgi tee li bee le, “Hooo bɛniiŋ bɛ kimbeenchɛ-ɛ ki sendɛ-ɛ. Nɛ chɛndi la?” Le tee lɛ, se dza we waŋ mfiee yilu mɔɔ dzɔɔ yi nyɔŋa yɛ, se yi chikɛ ni nshiiŋŋ. ");
INSERT INTO asj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bimfimu wondɛ bɛniiŋ bɛlu ni katara. Be tee le, “Ŋwaani wuni wi nuuŋ wi wu la wu mfiee mɔɔ dzɔɔ wuki li wuu ni?” ");
INSERT INTO asj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jiso lenchi bo kimbɛ ki bɛniiŋ bɛ Gadalaŋ. Bikɛ bɛ bɛniiŋ bɛfɛ ɛ bɔɔŋ bɛ kiŋkundi-i tɛ̀ ŋwɛki bɛ be. Bɛniiŋ bɛlu tɛ̀ bo lɛ dzíŋ yí bɛ diyi bɛniiŋ le, be bɛndi yi ŋge si nuuŋ wi tɛ mɔɔ ka lɛ dze yilu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Fi se ka le, be tɛ̀ tuu be bɛchi be wɛndi lɛwe ŋge be tiiti le, “Ŋwanɛ Nyɔ, ɔ wɛki la li bee li? Ɔ bɛɛ le ɔ nyɛ bee ŋgɛ mfi mɛɛŋ saa ki kɔchɛ kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɛ kintutu ki dzíiŋ lɛ kimu tɛ̀ jii biee fe fɛchiŋ ŋgɔŋgɔmɔɔ ki. ");
INSERT INTO asj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bɔɔŋ bɛ kiŋkundi-i bɛlu se lɛkɛ Jiso le, “Mintemii, ɔɔ buu bee, ɔ tuumi bee tɛ gɛɛŋ tɛ lɛ li dzíiŋ yɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jiso se tee li bee le, “Gɛnɛ yɛɛŋ lɛ.” Be se bo, be gɛɛŋ be lɛ li dzíiŋ yilu. Fi se ka le kintutu ki dzíiŋ lɛ kilu kichu tɛ̀ bɔɔ li mbɛmɛ wu ŋkumɛ-ɛ ki seri, ki shee lɛ libɛ chilu ki kwiyɛ li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bɛniiŋ bɛ tɛ̀ kiichi dzíiŋ yilu baa kifi be gɛɛŋ li bintsii li, be tiiti fiee fichu fi ka bɛ bɛniiŋ bɛ bɔɔŋ bɛ kiŋkundi-i tɛ̀ nuuŋ li bee baa. ");
INSERT INTO asj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Fi se ka le kitoŋ kilu kichu tɛ̀ tuu ki bo ki bɛ le ki chiiŋ Jiso. Si be tɛ̀ bɛ be ŋɛŋ wu lɛ, be sooŋ bɔ li Jiso le dza fɛ kintsii ki bee. ");
INSERT INTO asj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jiso lɛ lɛ ŋgo-o, kaari lenchi gɛɛŋ li kitoŋ kee li. ");
INSERT INTO asj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fi ka le bɛniiŋ bamu tɛ̀ bɛ bɛ wi wumu ɛ ŋgwɛ kɔɔ wu, ɛ be too wu fɛ kida-aŋ. Jiso ŋɛŋ si bɛniiŋ bɛlu gɛɛ shéŋ li wuu, tee li wi wu ŋgwɛ tɛ̀ kɔɔ wɛɛ le, “Ŋwanɛŋ, kɛmɛ shéŋ. Mi mfeekɔɔ bibifi bio.” ");
INSERT INTO asj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Fi ka le bɛniiŋ bamu bɛ doonchi bɛnchi bɛ Nyɔ-ɔ tɛ̀ bɛchi be ŋuŋini bebe be tiiti le, “Wi wuni dzetɔɔ kintsii ki Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jiso kɛɛ fiee fi be tɛ̀ beechi, bii li bee laa, “Nɛ kɛmi bɛ mbeechɛ bɛ bifi li shéŋ yinɛ ni kii la? ");
INSERT INTO asj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Fiee fi nuuŋ tsɛkɛ li ntefu nuuŋ fi la? Ntefu li wi wuni le mi mfeekɔɔ bibifi biee, mɔɔ le dza we ɔ ni ɔ deŋgi le? ");
INSERT INTO asj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Se nuuŋ le, ŋgii mfɛ nɛ kɛɛ le Ŋwanɛwi kɛmi buŋga laaŋkwiiŋ bu fekisɛ bibifi.” Le tee lɛ, biee tee li wi wu ŋgwɛ tɛ̀ kɔɔ wɛɛ le, “Dza we, ɔ dzɔɔ kidaŋ ko ɔ ni ɔ giiŋgi li yih.” ");
INSERT INTO asj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mwɛ se dza giiŋgi fɛkuuŋ. ");
INSERT INTO asj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Le kintutu ki bɛniiŋ lɛ kɛɛ ŋɛŋ fiee fi ka, be kɛmɛ chɛnɛ, be bɛchi be yɔɔnchi Nyɔ yi nyɛ ŋwaani buni buŋga li wiwo-oŋ. ");
INSERT INTO asj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Le Jiso dza fe le tuu ni deŋgi giiŋgi, ŋɛŋ wi wumu wu bɛ teenyi le Maacho, nuuŋ wi wu kundi kiŋwaati, ɛ tɛ̀ shee fɛ kintsii kee ki nimɛ-ɛ. Jiso tee li wuu le, “Ɔ biki mi.” Biee dza we biki wu. ");
INSERT INTO asj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jiso dza gɛɛŋ shee jii biee li Maacho yih, fi se ka le, bɛniiŋ bamu ŋge bɛ tɛ̀ kundi kiŋwaati, mɔɔ bɛniiŋ bamu bɛ bifi tɛ̀ bɛ be shee be jii biee bɛ Jiso mɔɔ bɔɔŋ bee bɛ kintutu-u. ");
INSERT INTO asj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Le Bɛfarasii ŋɛŋ si bee be jii biee lɛ, be bii li bɔɔŋ bee bɛ kintutu-u laa, “Fi geeŋ fi wi wunɛ wu ntiifɛ jii biee bee bɛniiŋ bɛ kundi kiŋwaati mɔɔ bɛniiŋ bamu bɛ bifi?” ");
INSERT INTO asj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jiso woo si be bii lɛ, tee li bee le, “Bɛniiŋ bɛ tɛɛmi ti wɛki yɛ wi wu ntsi kɛ. Ɛ bɛniiŋ bɛ gendi bɛ ti wɛki wi wu ntsi. ");
INSERT INTO asj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gɛnɛ yɛɛŋ nɛ beechɛ nɛ ŋɛŋ laa kinyi ki fiee fi bɛ tsɛɛ Nyɔ tiiti le, ‘Ŋ'wɛkɔɔ le bɛniiŋ ni be keeti nshiiŋ li bɛniiŋ bamu-u, ŋ'wɛki yɛ nuuŋ le be ni be feti muntofi li mi-i kɛ’, fi nuuŋ le la le? Nɛ kɛɛ le mɛɛŋɔ ki mbɛ kɛ le nteeŋ bɛniiŋ bɛ nuuŋ tsaaŋ kɛ. Mi mbɛɛɔ nuuŋ le nteeŋ bɛ bifi.” ");
INSERT INTO asj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bɔɔŋ bɛ kintutu bɛ Jɔɔŋ Nlisulidzɔɔ lɛ dza be bii li Jiso laa, “Fi geeŋ fi bee Bɛfarasii tuu jiti bijɛ, bɔɔŋ bo bɛ kintutu-u jiti yɛ tɛ kɛ?” ");
INSERT INTO asj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jiso tuu li bee le, “Nɛ beechi le bɛ nuuŋ bɛ teeŋ bɛniiŋ fɛ bugoo li, be gɛɛŋ be ni be nuuŋ li nshiiŋ li nyuŋ wutso mɛɛŋ bɛ be ni? Mfi bɛɛɔ wu bɛ gii bɛ fi nyuŋ wutso wulu li bee, be se bɛchi njiru bijɛ. ");
INSERT INTO asj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wi nuuŋ tɛ dzɔ nshɛŋgɛ yi ndu yi fiɛŋ le taa kiŋkoŋ ki fichi lu kɛ. Ɛ wu fɛ lɛ, nshɛŋgɛ yi ndu yilu gii yi mɛɛshi yi gaamɛ kiŋkoŋ ki fichi kilu, ŋgaaminɛ wulu tuu yaa wu bee saa nuuŋ ŋkosi. ");
INSERT INTO asj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Fi se nuuŋ tɛ le wi nuuŋ tɛ dzɔ mbiiŋ mɛ fɛŋ le gɛɛ lɛ kibɛɛŋ ki fichi-i kɛ Ɛ wu fɛ lɛ, mbiiŋ mɛ fɛŋ mɛlu be ŋge, kibɛɛŋ kilu munchi ki shaanshɛ, mbiiŋ mɛlu shooshɛ likwiiŋ. Chɛɛŋ wulu wɛ le, bɛ kɛmi le bɛ gɛɛ mbiiŋ mɛ fɛŋ nuuŋ lɛ kibɛɛŋ ki fɛ-ɛŋ. Bɛdɛɛni, mbiiŋ mɛlu bɛ kibɛɛŋ se ba nyɛɛkii.” ");
INSERT INTO asj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nɛɛ si Jiso tɛ̀ mɛɛŋ yeti li bee lɛ, fi dza fi ka le wi wu nyɔŋa wumu tɛ̀ bɛ toŋ núŋ wu limfwe lɛkɛ wu tiiti le, “Ŋwanɛŋ wu kwɛɛŋ wɛ lɛ kwe wa, bɛdɛɛni, bɛ nɛɛ ɔ koŋ li wuu bɛ kibɛnɛ ko kaari tɛmi.” ");
INSERT INTO asj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jiso se dza bee wu bɛchi be giiŋgi, bɔɔŋ bee bɛ kintutu-u biki wu tɛ. ");
INSERT INTO asj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Fi tuu fi ka tɛ le kwɛɛŋ wumu wu tɛ̀ gɔŋ bɛ chigɔŋ chi bukɛɛŋ lɛ biya yoofi ntsɔ bifɛ tɛ̀ dza bɛ Jiso lɛ jiŋ koŋ li wooŋ wu kiŋkoŋ kee li. ");
INSERT INTO asj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Si tɛ̀ koŋ lɛ, nuuŋ ɛ tɛ̀ tee li shéŋ yee li le, “Ɛ mi ŋkoŋ mɔɔ nuuŋ li kiŋkoŋ kee li kwaa, kɛ mi ntɛmɔɔ.” ");
INSERT INTO asj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Le koŋ lɛ, Jiso fiiki ŋɛŋ wu, tee li wuu le, “Naaŋ, kiiŋ ɔ ni chɛŋ kɛ. Shéŋ ya yi ɔ gɛɛ li mi-i fɛ yɛɛ ɔ tɛmi kituŋ.” Nɛɛ li mfi wulu-u, kwɛɛŋ wulu biee tɛmi. ");
INSERT INTO asj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jiso gɛɛŋ fɛsi fɛ la wu wi wu nyɔŋa wulu-u, ŋɛŋ bɛniiŋ bɛ ti teŋgi teh yi kwe mɔɔ kintutu ki bɛniiŋ lɛ fe. Kintsii kilu fuuti bɛ kwe yi dɛ. ");
INSERT INTO asj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jiso se tee li bee le, “Saaŋgɛ yɛɛŋ, ŋwaŋ wulu mɛɛŋɔ ki kwi-i kɛ, liitɔɔ.” Bɛniiŋ bɛlu tɛ̀ kee wu bu kefu. ");
INSERT INTO asj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Buu bɛniiŋ bɛlu lɛkuuŋ, se lɛ gɛɛŋ li yih, kɛmɛ ŋwaŋ wulu li kibɛnɛ-ɛ, ŋwaŋ wulu se biee dza we. ");
INSERT INTO asj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ntoŋ wu kii fiee filu se saaŋgɛ gɛɛŋ lɛ kimbɛ ki kwɛɛŋ lɛ kilu-u kichu. ");
INSERT INTO asj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Le Jiso dza fɛ yih yilu-u tuu ni deŋgi giiŋgi, binyɛɛ bimu bifɛ, bi buniŋ dza bi dzɛŋgi lɛwe ŋge bi biki wu, bi tiiti le, “Ŋwanɛ kini ki Mfɔŋ Daafi-i, kɔɔ nshiiŋ bɛ bee.” ");
INSERT INTO asj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jiso gɛɛŋ lɛ li yih, binyɛɛ bilu biee wu lu, se bii li bi-i laa, “Nɛ beŋ baa le nuuŋ mfɛ fiee fi nɛ dii kii fi fini ni?” Be se beŋ le, “Iiŋ Taa.” ");
INSERT INTO asj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jiso se koŋ li lii yi bee, tee le, “Kii shéŋ yi nɛ gɛɛ li mi-i, fi nuuŋ lɛ bɛ beŋ.” ");
INSERT INTO asj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lii yibe biee yi gwiyɛ. Jiso bɔsɛyi chiinsɛ li bee, tee le, “Kiiŋ nɛ ni fɛ le wi kɛɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Se nuuŋ le, be tuu be gɛɛŋ be biaki ntoŋ wu kii nimɛ chi Jiso-o wulu lɛ kimbɛ ki kwɛɛŋ lɛ kilu kichu. ");
INSERT INTO asj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Si bɛniiŋ bɛlu tɛ̀ dza be giiŋgi lɛ, fi ka le bɛniiŋ tɛ̀ dza be bɛɛ bɛ kibere kimu lɛ Jiso-o ɛ ŋwanɛ kiŋkundi tɛ̀ ŋwɛki bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jiso se buu ŋwanɛ kiŋkundi wulu li wi wulu-u, wi wulu se bɛchi yeti. Kintutu ki bɛniiŋ lɛ ŋɛŋ lɛ, wa tɛ be, be se tiiti le, “Fini fiee ti mɛɛŋ fiɛɛ saa ki ka kɛ li kwɛɛŋ wu Isɛlɛɛ wuni kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Se nuuŋ le, Bɛfarasii tee fibee le, “Busɔɔ bɔɔŋ bɛ kiŋkundi-i bani, nuuŋ bɛ buŋga bu mfɔŋ wu bɔɔŋ bɛ kiŋkundi-i.” ");
INSERT INTO asj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jiso dza deŋgi li bitoŋ bichu mɔɔ li bintsii li fenjisi li bɛniiŋ li li yíh yi kintaashɛ yibee, tiiti tɛ nsa wu dzeeŋ wu kii bumfɔŋ bu Liboo. Si tɛ̀ deŋgi lɛ, tɛ̀ gii wɔnchi chigɔŋ chichu. ");
INSERT INTO asj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Le tuu ŋɛŋ bintutu bi bɛniiŋ lɛ, nshiiŋ kɔɔ wu bɛ be, kifɛ be tɛ̀ nuuŋ li ntɔnyɛ, wi se foo wu nuuŋ fi be, be nuuŋ si nshɔ́ɔŋ yi nuuŋ wi wu kiichi yi nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dza tee li bɔɔŋ bee bɛ kintutu-u le, “Ŋ'wechɛ yaŋɔ ŋge, se nuuŋ le, bɛniiŋ bɛ ŋ'wechɛ-ɛ baa niiŋ ");
INSERT INTO asj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bɛdɛɛni, lɛkɛ yɛɛŋ li Nyɔ-ɔ le Taa wu Te wɛ tuumi bɛniiŋ bɛ ŋ'wechɛ-ɛ liwɛ wee li.” ");
INSERT INTO asj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Dza teeŋ bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa, be bɛ. Nyɛ buŋga li bee bu buushɛ fiana yi tii li bɛniiŋ li mɔɔ bu wɔnchɛ chigɔŋ mɔɔ ntɔnyɛ kwikwi. ");
INSERT INTO asj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maaŋ mɛŋkooŋ mɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso bɛ yoofi ntsɔ bɛfɛ bɛlu: Wu ŋkosi tɛ̀ nuuŋ Simu wu bɛ teenyi le Pita, bɛ Andolo wu ŋwaani. Bamu tɛ̀ nuuŋ Jeeŋ wu ŋwanɛ Dzɛbɛdii bɛ ŋwaani wu Jɔɔŋ mɔɔ ");
INSERT INTO asj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fili bɛ Batolomu, Tomɛ bɛ Maacho wu tɛ̀ kundi kiŋwaati, Jeeŋ wu ŋwanɛ Afiyus, Tajɔ bɛ ");
INSERT INTO asj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simu wu tɛ̀ nuuŋ wi wu kintutu ki Bɛsilɔ-ɔ bɛ Judas Iskaliyɔ wu tɛ̀ kabɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jiso toŋ bɛniiŋ bɛ yoofi ntsɔ bɛfɛ bani, tee li bee le, “Ɛ nɛ giiŋgɔɔ kiiŋ nɛ ni gɛɛŋ fɛ kintsii ki nuuŋ yɛ ki wi wu Bɛjuu lɛ kɛ. Kiiŋ nɛ ni gɛɛŋ li bintsii bi bɛniiŋ bɛ Samaaria kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gɛnɛ yɛɛŋ nuuŋ fɛ bɔɔŋ bɛ Isɛlɛɛ bɛ tɛ̀ layɛ si bɔɔŋ bɛ nshɔ́ɔŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɛ nɛ gɛɛŋ nɛ tiifi be nɛ tiiti le, ‘Bumfɔŋ bu liboo bwɛɛ tsɛkɛtsɛkɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nɛ wɔnchi bɛniiŋ bɛ gendi, nɛ yimisi yɛɛŋ bɛniiŋ bɛ kwiyɛ, nɛ wɔnchi yɛɛŋ bɛniiŋ bɛ kɛmi chigɔŋ chi nɔŋa, nɛ busi yɛɛŋ tɛ bɔɔŋ bɛ kiŋkundi-i li yi yi bɛniiŋ li. Mi nyɛɔ buŋga li be-eŋ li yee li. Gɛnɛ yɛɛŋ tɛ nɛ ni nɛ fii bɛniiŋ lu li yee li. ");
INSERT INTO asj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ɛ nɛ giiŋgɔɔ, kiiŋ wi ni dzɔɔ kwa litiŋ kɛ, mɔɔ nuuŋ kwa wu nyɔŋa mɔɔ nuuŋ wu ŋkwɛŋ mɔɔ nuuŋ wu sendɛ si la le kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kiiŋ wi ni dzɔɔ babi kɛ. Kiiŋ wi ni dzɔɔ ndú fiɛɛtu mɔɔ nuuŋ bikpɔ bimu mɔɔ nuuŋ kimbaaŋ kɛ. Nɛ kɛɛ le wi wu nimɛ kɛmi le ni jii fɛ kintsii kee ki nindi-i. ");
INSERT INTO asj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɛ nɛ gɛɛŋ nɛ lɛ li kito-oŋ, mɔɔ nuuŋ fɛ kintsii li, nɛ gɔɔŋ nɛ ŋɛŋ wi wu kɔchɛ, nɛ tsi bɛ wu nsiiŋ gɛɛŋ bo jobɛ chi nɛ dzɛti fe. ");
INSERT INTO asj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ɛ nɛ gɛɛŋ, fɛ nɛ lii li yih, nɛ yɛsi yih yilu. ");
INSERT INTO asj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ɛ yih yilu kɔchɛ, mbɛɛŋgii wunɛ bɛ li yih yilu-u. Ɛ yih yilu mɛɛŋ ki kɔchɛ kɛ mbɛɛŋgii wunɛ kaari wu to li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɛ wi faaŋ mfiɛ beŋ, kɛ le wuki yɛ fiee fi nɛ tiiti kɛ, mfi wu nɛ buti li yih yilu-u, kɛ li kitoŋ kilu-u, nɛ kachɛ kiboŋ ki bee li bikaa binɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ntee beŋ chɛɛŋ le, bu jobɛ chi nsa wu kimɛrisɛ Nyɔ gii yi kɔɔ nshiiŋ li kitoŋ ki Sɔdɔŋ bɛ ki Gɔmɔra yɛki kitoŋ ki kee yɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yikɛ yɛɛŋ nɛ woo, ntundɔɔ beŋ le nɛ gɛɛŋ si nshɔ́ɔŋ li bɛmbɔɔŋku-u linti. Bɛdɛɛni, ɛ nɛ deŋgɔɔ, nɛ kɛmi bufii si yɔ́, nɛ nuuŋ nyɛɛkii si bibimu. ");
INSERT INTO asj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mfi wu nɛ deŋgi, nɛ dzeti yɛɛŋ mfi bɛ bɛniiŋ. Nɛ kɛɛ le bɛ gii bɛ nyɛ beŋ li tsaŋ yi bɛniiŋ bɛ sɛki bɛnsa-a. Be fiaamfiɛ beŋ li yíh yibe yi lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Be gii be kwachɛ beŋ be gɛɛŋ bɛ beŋ li ŋgɔmina-a limfwe, mɔɔ li bɛmfɔ-ɔŋ limfwe kii mi, le nɛ se yɔ li bee mɔɔ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ-ɛ kii mi. ");
INSERT INTO asj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ɛ be nyɛ beŋ li bee lɛ, kiiŋ nɛ ni nɛ mbeechi laa nɛ gii nɛ gɛɛŋ nɛ tee le la, kɛ lɛ dze yi la le kɛ, kifɛ Nyɔ gii yi nyɛ beŋ fiee fi nɛ gii nɛ tee li mfi wulu-u. ");
INSERT INTO asj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɛ beŋ nɛ gii nɛ yɔ kɛ. Ɛ fiana yi Baa wunɛ yi gii yi yɔ li bimfimu binɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Wi gii dzɔɔ ŋwaani nyɛ le bɛ wo, te ŋwaŋ dzɔɔ ŋwani nyɛ bɛ wo. Bɔɔŋ gii be dza tɛ be ni be biindi bikaa lɛ bɛtee bɛ bee lɛjiŋ, be ni be feti le bɛ woyɛ be. ");
INSERT INTO asj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bɛniiŋ bɛchu gii be ni be baanini beŋ kii bukooŋ bweŋ. Se nuuŋ le, wi wu gii kaŋ shéŋ nsiiŋ gɛɛŋ bo fɛ kimɛrisɛ-ɛ, gii naa bɔnɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mfi wu bɛniiŋ biindi bikaa lɛ benɛ jiŋ fɛ kintsii kimu-u, nɛ kifi nɛ gɛɛŋ fɛ kimu-u. Ntee beŋ chɛɛŋ chɛɛŋ le, nuuŋ nɛ tɛ dɛndɛ bitoŋ bichu bi Isɛlɛɛ Ŋwanɛwi se naa bɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nɛ kɛɛ le ŋwaŋ wu laanchi ti yɛki yɛ wi we wu ntiifɛ kɛ, nɛɛ si ŋwanɛ nimɛ ti yɛki yɛ te kikoo we kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Fi fiɛɛ nɛɛ bujɔŋ le ŋwaŋ wu laanchi kiŋwaati nuuŋ nɛɛ nuuŋ si wi wu tiifi wu, ŋwaŋ wu nimɛ nuuŋ nɛɛ tɛ nuuŋ si te kikoo we. Ɛ bɛ teenyi te yih le Bɛɛsɛbu, bɛ se tuu bɛ teeŋ bɔɔŋ bee bukooŋ bu bɛndi yi bu yɛki buni ni? ");
INSERT INTO asj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Bɛdɛɛni, kiiŋ nɛ ni nɛ chɛndi wi kɛ. Nɛ kɛɛ le fiee fimu nuuŋ yɛ lu fi bɛ baanyɛ fi gii naa fi ba mbochu fɛ waaŋ nsiŋ kɛ. Fiee nuuŋ yɛ tɛ lu lɛ munyiikɔɔ li fi bɛ nuuŋ tɛ naa kɛɛ fi nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Fiee fi ntiiti li beŋ butuu, nɛ tiiti fi li bɛniiŋ li fɛnshaaŋ. Fi mi ntee beŋ lɛ ntsooŋ li, nɛ dzaaŋ fi nuuŋ fɛ kigɔ ki yi-ih. ");
INSERT INTO asj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kiiŋ nɛ ni nɛ chɛndi bɛniiŋ bɛ nuuŋ be wo nuuŋ nyaŋ yi li bwiŋ kwaa, be tɛ wo fiana yi wi kɛ. Chɛŋ yɛɛŋ nuuŋ Nyɔ yi nuuŋ yi lɛɛ fiana yi wi, bɛ yi yee chi fɛ wi wu duti nyimu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bɛ ti kabini nɛɛ munchaandi mumfɛɛŋ li fi nini kwaa ni? Se nuuŋ le, nuuŋ fimumkpaŋ tɛ we fɛkwiiŋ Baa wunɛ ŋkɛɛ fe nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Li be-eŋ, Nyɔ fa yɛ yi chichi yi nuuŋ beŋ li fa. ");
INSERT INTO asj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kiiŋ nɛ ni nɛ chɛndi kɛ. Nɛ yaa baa munchaandi kiŋga ŋge. ");
INSERT INTO asj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Bɛdɛɛni wi kwikwi wu beŋ lɛ bɛniiŋ lii le kii mi, kɛ ŋgii naa beŋ tɛ mwɛ li Baa wɛŋ wu nuuŋ liboo li limfwe. ");
INSERT INTO asj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Se nuuŋ le, wi kwi wu faaŋ mi li bɛniiŋ li limfwe, kɛ ŋgii naa faaŋ tɛ wu li Baa wɛŋ wu nuuŋ liboo li limfwe. ");
INSERT INTO asj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nɛ beechɛ kɛ le mi mbɛɛɔ nuuŋ bɛ mbɛɛŋgii li nshɛ yini kɛ. Ɛ fiɛɛ yɛ fi mi mbɛ kii fi kɛ. Mi mbɛɛɔ nuuŋ bɛ dziŋ. ");
INSERT INTO asj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nɛ kɛɛ le mi mbɛɛɔ nuuŋ le mfɛ le ŋwaŋ wu nyuŋ ni gwii bee tee, wu kwɛɛŋ ni gwii bee ni, kwɛɛ ŋwaŋ ni gwii bee ni nyumi. ");
INSERT INTO asj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bɛniiŋ bɛ mbani bɛ wi-i gii ni nuuŋ nɛɛ bɛniiŋ bee bɛ li wuu yih. ");
INSERT INTO asj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ɛ wi kɔŋgisi tee kɛ ni yɛki mi, kɛ mwɛ mɛɛŋɔ ki kɔchɛ kɛ le ni nuuŋ wi wɛŋ kɛ. Wi wu kɔŋgisi ŋwani wu nyuŋ kɛ wu kwɛɛŋ yɛki mi, kɛ mwɛ mɛɛŋɔ ki kɔchɛ kɛ le ni nuuŋ wi wɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɛ wi mɛɛŋ ki too kɛ kintaaŋ kee le ni biki mi kɛ, kɛ mwɛ mɛɛŋɔ ki kɔchɛ kɛ le ni nuuŋ wi wɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɛ wi bachi yi yee, kɛ mwɛ gii lɛɛ yi. Se nuuŋ le, wi wu lɛɛ yi yee kii mi, kɛ mwɛ gii kɛmɛ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ɛ wi fi beŋ, kɛ mwɛ fiiɔ tɛ nuuŋ mi. Wi wu fi mi, kɛ mwɛ fiiɔ tɛ nuuŋ wi wu toŋ mi. ");
INSERT INTO asj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɛ wi fi ntomfɔŋ wu Nyɔ, kifɛ mwɛ kiiɔ le ɛ Nyɔ yi toŋ wu, kɛ mwɛ gii kɛmɛ kinsomfu, ki Nyɔ suundi bɛniiŋ bee bɛ ntoŋ lu. Ɛ wi fi wi wu tsaaŋ, kifɛ mwɛ kiiɔ le mwɛ nuuŋ wi wu tsaaŋ, kɛ mwɛ gii kɛmɛ kinsomfu ki Nyɔ suundi bɛniiŋ bee bɛ tsaaŋ lu. ");
INSERT INTO asj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ntee beŋ chɛɛŋ le, ɛ wi nyɛ mɔɔ nuuŋ fika fi dzɔɔ yi tsɔɔŋ lɛ li wi mumkpaŋ li kintutu ki bɛniiŋ bɛ ntɛŋ bɛ ntɛŋ bani, kifɛ mwɛ kiiɔ le nuuŋ wi wɛŋ wu kintutu, kɛ mwɛ nuuŋ tɛ lɛɛ kinsomfu kee kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Le Jiso mɛɛshi tifi bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ bɛfɛ baa, biee dza fe tuu deŋgi li bintsii bi fe tiifi bɛniiŋ fenjisi mɔɔ ntoŋ wu dzeeŋ. ");
INSERT INTO asj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ɛ li mfi wulu, wu Jɔɔŋ Nlisulidzɔɔ tɛ̀ nuuŋ li yih yi ncha-a. Se dza woo kii biee bi Krai tɛ̀ feti, biee toŋ bɔɔŋ bee bɛ kintutu-u le be gɛɛŋ, ");
INSERT INTO asj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","be bii li wuu laa, ɛ wu, wu tɛ̀ nuuŋ le gii bɛ wɛ, mɔɔ bɛ ni bɛ ni tɛŋgi wumu le? ");
INSERT INTO asj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Be gɛɛŋ be bii, Jiso tuu li bee le, “Kaari yɛɛŋ nɛ gɛɛŋ nɛ tee Jɔɔŋ, biee bi nɛ woo bɛ bi nɛ ŋɛŋ. ");
INSERT INTO asj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Binyɛɛ ŋɛŋ biɛɛ biee kituŋ, biŋkɛrɛ deŋgi biɛɛ tsaaŋ, bɛniiŋ bɛ gendi bɛ chigɔŋ chi nɔŋa tɛmi baa kituŋ, binchiinchi wuki biɛɛ biee, bɛniiŋ bɛ kwiyɛ kaari baa be yiŋ, be tuu be fenjisi ntoŋ wu dzeeŋ wu wu Nyɔ li bɛniiŋ bɛ kifoo lɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tee yɛɛŋ tɛ wu le kinɛɛtinɛ ki nɔŋa kɛɛ ki wi wu mɛɛŋ ki mɛŋɛ kɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Le bɔɔŋ bɛ Jɔɔŋ lɛ bɛ kintutu-u baa dza, Jiso tuu bɛchi tiiti li kintutu ki bɛniiŋ lɛ, kii Jɔɔŋ biiti laa, “Nɛ tɛ̀ shiiŋ nɛ buti nɛ giiŋgi libuka le nɛ gɛɛŋ nɛ ŋɛŋ nuuŋ la? Kitɔɔ ki mbaandze kɛti ki sɛɛsi ni? ");
INSERT INTO asj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɛ tɛ̀ nuuŋ yɛ lɛ kɛ, nɛ tɛ̀ buti nɛ giiŋgi fe le nɛ ŋɛŋ la? Nɛ tɛ̀ giiŋgi le nɛ ŋɛŋ wi wu tɛ̀ chuumɛ ndú yi shaaŋ ni? Yikɛ yɛɛŋ nɛ woo, bɛniiŋ bɛ ti chuumini ndú yi shaaŋ ti nuuŋ nuuŋ lɛ bɛntɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɛ tɛ̀ nuuŋ yɛ lɛ kɛ, nɛ se tɛ̀ buti nɛ giiŋgi le kii la? Le nɛ gɛɛŋ nɛ ŋɛŋ ntomfɔŋ wu Nyɔ ni? Iiŋ, ntee beŋ le ɛ wi wu yɛki ntomfɔŋ wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ɛ wu, wu bɛ tɛ̀ tsɛɛ kii wu, Nyɔ tiiti le, ‘Yikɛ yɛɛŋ nɛ woo, ŋgii ntuumi wi wɛŋ wu ntoŋ ni tuuti mbaaŋ li wɛ-ɛ, nachɛ dze ya ɔ se bɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ntee beŋ chɛɛŋ le, lɛnti lɛ bɛniiŋ bɛ bukɛɛŋ biɛ-ɛ, wi nuuŋ yɛ lu wu ko wu yaa Jɔɔŋ Nlisulidzɔɔ kɛ. Se nuuŋ le, wi wu nuuŋ wi wu ŋkwɛŋ li bumfɔŋ bu liboo li wɛ, ɛ wu wu ko wu yaa wu. ");
INSERT INTO asj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mbɛɛchɛ li mfi wu Jɔɔŋ Nlisulidzɔɔ tɛ̀ bɛchi nimɛ chee mbɛ mbochu dɛɛni, bɛniiŋ nukini baa bumfɔŋ bu liboo, bɛniiŋ bɛ buŋga lɔchi bɛ buŋga. ");
INSERT INTO asj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bɛntomfɔŋ bɛ Nyɔ-ɔ bɛchu mɔɔ bɛnchi bɛ Mɔɔsɛ tɛ̀ tiiti kii bumfɔŋ bu liboo nsiiŋ gɛɛŋ bo li mfi wu Jɔɔŋ Nlisulidzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ɛ nɛ ŋɛŋ le nɛ nuuŋ nɛ beŋ, nɛ beŋ le Jɔɔŋ wuni nuuŋ Ɛlaja wu tɛ̀ nuuŋ le gii naa bɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wi wu kɛmi bintooŋ mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jiso dza ta maa laa, “Ɛ la fi nnuuŋ nɛɛ mmaa kiŋgɔkɛ ki dɛɛni kini bɛ fi? Bɛ nuuŋ si bɔɔŋ bɛntɛŋ bɛntɛŋ bɛ shiiti li bintsii bi wa-aŋ, bamu teenyi bamu be biiti laa, ");
INSERT INTO asj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tɛ tɔɔŋ baa teh nɛ tɛ biŋ kɛ ni? Tɛ nyɛ baa juuŋ yi kwe nɛ tɛ beŋ kɛ ni?’ ");
INSERT INTO asj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ntiitɔɔ lɛ kifɛ Jɔɔŋ tɛ̀ bɛ jiti bijɛ mɔɔ bi wonɛ, bɛ tee le bɔɔŋ bɛ kiŋkundi-i fieŋgisi baa wu. ");
INSERT INTO asj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ŋwanɛwi bɛɛɔ, jii biee, wundi biee, nɛ tee le bichɛ yɛɛŋ nɛ ŋɛŋ, wi wuni deŋgɔɔ wuti biee, wundi mbiiŋ piɛndi, tuu shiiŋ mɔɔ nsáŋ bɛ bɛniiŋ bɛ kundi kiŋwaati mɔɔ bɛniiŋ bɛ bifi bamu. Se nuuŋ le bufii ti doonchi yi nuuŋ li fiee fi bu nindi-i.” ");
INSERT INTO asj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jiso dza bɛchi fuushi biŋge bi bintsii bimu bi tɛ̀ fɛ bintɛwa bi biee lɛ li bi-i, kifɛ tɛ̀ fɛ lɛ, bɛniiŋ bɛ fe faaŋ le be fikisi yɛ biŋge bi bee kɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Le fusi lɛ, tee le, “Ŋgɛ wu nyɔŋa wɛ wunɛ beŋ bɛniiŋ bɛ Korasiŋ, ŋgɛ wu nyɔŋa wɛ tɛ wunɛ beŋ bɛniiŋ bɛ Besaida. Nɛ kɛɛ le, gii nuuŋ le mfɛ bintɛwa bi biee lɛ bi ntɛ̀ mfɛ li be-eŋ bini nuuŋ li kwɛɛŋ wu Tayɛ bee Sidɔ-ɔŋ, bee nuuŋ dɛɛŋ be tɛ̀ fiiki shéŋ yibe, be liishɛ ndú yi kwe, be fwa taŋɛ li bwiŋ kichu le be doonchɛ le be fiiki baa shéŋ yibe. ");
INSERT INTO asj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Se nuuŋ le, ntee beŋ le, naa nuuŋ bu jobɛ chi nsa wu kimakɛ, biee biaaŋ li bɛniiŋ bɛ Tayɛ mɔɔ bɛ Sidɔ-ɔŋ yaa binɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mɔɔ beŋ bɛniiŋ bɛ Kapanu-uŋ, nɛ beechi le bɛ gii bɛ yɛɛki beŋ nɛ yɛɛ liboo ni? Wohoo! Bɛ gii naa bɛ lɔŋ beŋ li kwɛɛŋ wu bɛŋku-u. Nɛ kɛɛ le, bee le mbɛ mfɛ bintɛwa bi biee lɛ bi ntɛ̀ mfɛ li be-eŋ nuuŋ Sɔdɔŋ, bee nuuŋ kitoŋ kilu ki mɛɛŋ lu bɛ bo bɛŋ. ");
INSERT INTO asj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Se nuuŋ le, ntee beŋ le, naa nuuŋ jobɛ chi nsa wu kimakɛ, biee yaanɛ li bɛniiŋ bɛ Sɔdɔŋ yaa binɛ.” ");
INSERT INTO asj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nɛɛ li mfi wɛɛ, Jiso dza tee le, “Mi nyɛɔ kiyɔɔni li wɛ-ɛ Baa wɛŋ Mfɔŋ wu kiboo bɛ nshɛ le ɔ nyikɔɔ biee bini li bɛ bufii lɛ mɔɔ bɛŋkɛɛ biee, ɔ doonchɛ nuuŋ li bɔɔŋ bɛ bwi-i. ");
INSERT INTO asj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Fi fiɛɛ lɛ Taa, kifɛ fi nuuŋ fiɛɛ si ɔ tɛ̀ kɔŋgisi le fi nuuŋ. ");
INSERT INTO asj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Baa wɛŋ nyɛɔ biee bichu li mi-i. Wi nuuŋ yɛ lu wu kii Ŋwanɛ Nyɔ yɛki Baa we kɛ. Wi nuuŋ yɛ lu wu kii Baa we yɛki Ŋwani mɔɔ bɛniiŋ bɛ Ŋwani tsaa le doonchɛ Baa we li bee kɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Beŋ bɛchu bɛ too bɛntɛ be luuti be yɛki beŋ, bɛ yɛɛŋ bɛ be fɛ mi-i, ŋgii nyɛ beŋ mfufinɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Dzɔɔ yɛɛŋ kimboŋ keŋ nɛ sumɛ, nɛ ni nɛ biki ntiifɛ wɛŋ, kifɛ nnuuŋ fieŋ wi wu mbɛɛŋgii, ŋkɛmi shéŋ yi tsɔɔŋ, nɛ gii nɛ kɛmɛ mfufinɛ li shéŋ yinɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kimboŋ keŋ luuti yɛ kɛ, ntɛ wɛŋ nuuŋ tɛ futuru-u.” ");
INSERT INTO asj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Le ni nuuŋ nɛɛ li mfi wulu-u, Jiso bee bɔɔŋ bee bɛ kintutu-u deŋgi be kɛti li wɛ wu giiŋ wumu-u, ɛ tɛ nuuŋ jobɛ chi bɛshiinshi. Ɛ dzeeŋ tɛ̀ wuu bɔɔŋ bee bɛ kintutu-u, be dza be bɛchi be soomi bikoo bi giiŋ lɛ be jii. ");
INSERT INTO asj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Le Bɛfarasii ŋɛŋ lɛ, be tee li Jiso-o le, “Bichɛ ɔ ŋɛŋ, bɔɔŋ bo bɛ kintutu-u feti baa fiee fi nchi mɛɛŋ ki beŋ kɛ le wi fɛ jobɛ chi bɛshiinshi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bii li bee laa, “Nɛ mɛɛŋ baa saa ki teeŋ kɛ lɛ Kiŋwaati ki Nyɔ-ɔ si dzeeŋ tɛ̀ wo Daafi bee kintutu kee, fɛ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tɛ̀ lɛ li yih yi Nyɔ-ɔ, ji kibele ki bɛ tɛ̀ tsaa bɛ gɛɛ le ɛ ki Nyɔ-ɔ, ɛ tɛ nuuŋ nchi le kiiŋ wu mɔɔ nuuŋ bɛniiŋ bɛ tɛ nuuŋ bɛ wu ji kɛ. Tɛ nuuŋ nɛɛ bɛte muntofi kwaa bɛ nuuŋ be ji. ");
INSERT INTO asj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mɔɔ nɛ mɛɛŋ baa ki teeŋ kɛ lɛ bɛnchi bɛ Mɔɔsɛ le tɛ̀ nuuŋ jobɛ chi bɛshiinshi, te muntofi bondɛ nchi wu jobɛ chi bɛshiinshi niŋ nimɛ chee se fiee ba wu ki ge kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ntee beŋ le fiee fiɛɛ lu fɛni dɛɛni fi ko fi yaa yih yi muntofi. ");
INSERT INTO asj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bɛ tsɛɛ baa lɛ Kiŋwaati ki Nyɔ-ɔ, Nyɔ tiiti le, ‘Ŋ'wɛkɔɔ nuuŋ le bɛniiŋ ni be keeti nshiiŋ li bɛniiŋ li, ŋ'wɛki yɛ le be ni be feti nuuŋ muntofi li mi-i kɛ.’ Bee le nɛ ni nɛ kii fiee fi bintsii bini tiiti, bee nɛ sɛki yɛ bɛniiŋ be nchɔru fiee nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Fi fiɛɛ le Ŋwanɛwi nuuŋ Te Kikoo wu jobɛ chi bɛshiinshi.” ");
INSERT INTO asj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jiso dza fe, gɛɛŋ lɛ li yih yi nlɛkɛ li Nyɔ-ɔ yibe-e. ");
INSERT INTO asj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Fi se ka le wi wumu tɛ̀ nuuŋ lu ɛ ŋgwɛ tɛ̀ kɔɔ wu li kibɛnɛ-ɛ. Bɛfarasii bamu dza be bii li Jiso laa, “Nchi beenchi le nuuŋ bɛ wɔnchɛ wi jobɛ chi bɛshiinshi ni?” Be tɛ̀ biiti lɛ be wɛki nuuŋ fiee fi be nuuŋ be terɛ wu lu. ");
INSERT INTO asj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jiso se bii li bee laa, “Ɛ noo li be-eŋ linti wu nuuŋ ni kɛmi nshɔɔŋ yee, ke yi we lɛ fweeŋ jobɛ chi bɛshiinshi, mwɛ se ba ki seri kɛ le, le chee yi buu kɛ? ");
INSERT INTO asj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wi woŋ yɛki yɛ nshɔɔŋ yi nyɔŋa kɛ ni? Fi fiɛɛ le nchi beŋɔ le wi nuuŋ fɛ nimɛ chi dzeeŋ bu jobɛ chi bɛshiinshi.” ");
INSERT INTO asj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Biee tee li wi wu ŋgwɛ tɛ̀ kɔɔ wu li kibɛnɛ-ɛ wɛɛ le, “Nɛɛmi kibɛnɛ ko.” Wi wulu nɛɛmi. Ki biee ki tɛmi si kimu kɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Se nuuŋ le, Bɛfarasii baa tuu be bo be gɛɛŋ be lii ntsuuŋ si be gii be wo Jiso. ");
INSERT INTO asj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jiso kɛɛ kii taaŋ wu be dzɔ, biee dza fe. Bɛniiŋ ŋge biee wu. Se wɔnchɛ be bɛchu bɛ tɛ̀ kɛmi chigɔŋ, ");
INSERT INTO asj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","chiinsɛ li bee le kiiŋ be ni fɛ bɛniiŋ kɛɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Fi tɛ̀ gii fi nuuŋ lɛ le fi bɛ fi kɔchɛ si ntomfɔŋ wu Nyɔ wu Ɛsaya tɛ̀ tee le, ");
INSERT INTO asj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bichɛ yɛɛŋ nɛ ŋɛŋ, wuni nuuŋ ŋwanɛŋ wu nimɛ wu ntɛ̀ ntsaa. Nuuŋ shéŋ yɛŋ, ŋ'wuki bujɔŋ bɛ wu. Ŋgii nyɛ Fiana yɛŋ li wuu, ni tiifi bitoŋ kii dze yi tsaaŋ yi nsondini bɛnsa le. ");
INSERT INTO asj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nuuŋ tɛ naa le ni tsuki ntsooŋ bɛ bɛniiŋ, kɛ le ni kuundi kimfimɛ kɛ. Wi nuuŋ tɛ woo jɛ ye lɛ dzé ntasɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nuuŋ tɛ mɛɛshi le bondɛ yɔchɛ yi bondini kituŋ kɛ. Nuuŋ tɛ naa nyiimi kuu wu lambo wu duti jibi jibi kɛ. Fi gii fi nuuŋ lɛ gɛɛŋ bo mfi wu dze yi tsaaŋ, yi sondini bɛnsa le, sɔ. ");
INSERT INTO asj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bitoŋ bichu gii bi ni bi bichi limfwe bi giki bufii li wuu.” ");
INSERT INTO asj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bɛniiŋ bamu tɛ̀ dza be bɛ bɛ wi wumu ɛ tɛ̀ nyɛɛ, nuuŋ tɛ kibere, bɔɔŋ bɛ kiŋkundi-i ŋwɛki bɛ wu. Jiso fɛ wu bɛchi yeti tuu ŋiŋgi mɔɔ biee. ");
INSERT INTO asj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wa tɛ bɛniiŋ bɛ tɛ̀ nuuŋ fe bɛchu, be bɛchi be biiti laa, “Wi wuni nuuŋ nɛɛ ŋwanɛ kini ki Mfɔŋ Daafi ni?” ");
INSERT INTO asj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bɛfarasii woo si be biiti lɛ be tee li bee le, “Wi wuni busɔɔ bɔɔŋ bɛ kiŋkundi-i nuuŋ bɛ buŋga bu Bɛɛsɛbu-u mfɔŋ wu bɔɔŋ bɛ kiŋkundi-i.” ");
INSERT INTO asj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jiso kɛɛ fiee fi be beechi biee tee li bee le, “Ɛ kitoŋ dza ki gatɛ ki gwii kiki, kɛ ki gii ki dza ki to nuuŋ kimfoo. Ɛ kintsii kɛ yih dza yi gatɛ yi tuu yi gwii yi yi, yi tɛ naa leŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ɛ Sataŋ busi yi yee li wi-i bwiŋ, kɛ wu gatɔɔ yi yee. Ɛ fi nuuŋ lɛ, bumfɔŋ bwee tɛ naa leŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ɛ fi nuuŋ le mbusi bɔɔŋ bɛ kiŋkundi-i nuuŋ bɛ buŋga bu Bɛɛsɛbu-u, bɔɔŋ bɛnɛ se busi tɛ nuuŋ bɛ bu noo lɛ? Fiee fi bɔɔŋ bɛnɛ bɛlu feti doonchɛ fiɛɛ le nɛ we baa nsa kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Se nuuŋ le ɛ mbusi bɔɔŋ bɛ kiŋkundi-i bɛlu nuuŋ bɛ buŋga bu Fiana yi Nyɔ-ɔ, kɛ bumfɔŋ bu Nyɔ-ɔ bɛ bwɛɛ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nɛ beechi le nuuŋ wih lɛ li wi buŋga yih, kotɛ biee bo bɛ bi, mɛɛŋ saa ki kɔɔ kɛ wi wu buŋga wulu le kaŋ ni? Ke wu kaŋ se lɛ kotɛ biee bo bɛ bi. ");
INSERT INTO asj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɛ wi nuuŋ yɛ kimbɛ keŋ kɛ, kɛ mwɛ baaninɔɔ mi. Ɛ wi fii yɛ mi li mbanchɛ-ɛ kɛ, kɛ mwɛ tɛɛtɔɔ bu tafu. ");
INSERT INTO asj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bɛdɛɛni, ntiitɔɔ li be-eŋ le Nyɔ nuuŋ yi feeki biee bibifi mɔɔ jɛ́ yi bifi chichi yi bɛniiŋ yeti. Se nuuŋ le ɛ wi tiiti jɛ yi bifi kii Fiana yi Waaŋ, kɛ Nyɔ nuuŋ tɛ feeki mwɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɛ wi tee bubiɛɛ kii Ŋwanɛwi, Nyɔ nuuŋ nɛɛ yi feeki mwɛ. Se nuuŋ le ɛ wi tee bubiɛɛ kii Fiana yi Waaŋ, Nyɔ tɛ naa feeki mwɛ li mfi wuni mɔɔ li mfi wu bɛɛ limfwe kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wi wu kɛmi kiti kee ki dzeeŋ, ti kɛmi muntaaŋ mu dzeeŋ. Wi wu kɛmi kiti ki bifi kɛmi tɛ muntaaŋ mu bifi, kifɛ bɛ ti kii kiti nuuŋ li muntaaŋ mu ki wundi-i. ");
INSERT INTO asj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kiŋgɔkɛ ki yɔ́-ɔ kini. Nɛ gii nɛ geeŋ nɛ se yɔ n'yɔru wu dzeeŋ fɛ nɛ baa bɛniiŋ bɛ bifi ni? Nɛ kɛɛ le fiee fi yisɛ li shéŋ yi wi-i ɛ fi fi ti buti lɛ kimfimɛ kee li. ");
INSERT INTO asj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wi wu dzeeŋ kɛmi gwɛɛ wu biee bi dzeeŋ lɛ wuu shéŋ, busi biee bi dzeeŋ le. Wi wu bifi se kɛmi nuuŋ gwɛɛ wu biee bibifi, busi biee bibifi lɛ wu shéŋ. ");
INSERT INTO asj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ntee beŋ le naa nuuŋ jobɛ chi nsa wu kimakɛ-ɛ, wi kwikwi ni kɛmi le ku bɛ kimfimɛ kee jɛ́ yi lɔɔlɔɔ chichi yi tɛ̀ yeti. ");
INSERT INTO asj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nɛ kɛɛ le naa nuuŋ fɛ bɛ sɛki wi, ɛ jɛ́ yi buti lɛ kimfimɛ ki wi-i yi gii yi fɛ mwɛ bɔnɛ, ɛ nɛɛ jɛ́ yi buti lɛ kimfimɛ ki wi-i yi gii yi fɛ mwɛ se we nsa.” ");
INSERT INTO asj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bɛniiŋ bamu bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ mɔɔ Bɛfarasii dza be tee li Jiso-o le, “Wi wu ntiifɛ, tɛ wɛki baa le ɔ fɛ fiee fi doonchi buŋga bwo tɛ ŋɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jiso tuu li bee le, “Kiŋgɔkɛ ki bifi ki chinɛ Nyɔ si kwɛɛŋ wu chinɛ nyumi, nɛ wɛki le nɛ ŋɛŋ fiee fi doonchi buŋga bweŋ! Nuuŋ ntɛ ndoonchɛ fiee li kiŋgɔkɛ kini-i fi yɛki fi tɛ̀ ka bɛ ntomfɔŋ wu Nyɔ wu Jɔna kɛ. ");
INSERT INTO asj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Si Jɔna tɛ̀ tsi li dzɔɔ lɛ nsuuŋ yi nyɔŋa shéŋ jo taa, ɛ nɛɛ lɛ si Ŋwanɛwi gii naa nuuŋ lɛ nshɛ-ɛ lɛŋkwiiŋ jo taa. ");
INSERT INTO asj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Naa nuuŋ bu jobɛ chi nsa-a, bɛniiŋ bɛ Ninibɛ leŋ bɛ kiŋgɔkɛ ki dɛɛni kini be tee le ki we kɛɛ nsa, kifɛ bɛniiŋ bɛ Ninibɛ tɛ̀ woo fiee fi Jɔna tɛ̀ fenjisi, be fiiki ntsɛ wube. Fi fiɛɛ le, yikɛ yɛɛŋ nɛ woo, wi wumu wɛ fɛni bɛ fiee fi ko fi yaa fi Jɔna. ");
INSERT INTO asj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yaa wu sɛki kitoŋ ki Shɛba gii naa leŋ tɛ bu jobɛ chi nsa wu kimakɛ bɛ kiŋgɔkɛ ki dɛɛni kini fɛ bɛ se lii ki li ŋgɛ-ɛ, kifɛ tɛ̀ dza li kitoŋ kee li lɛ kwɛɛŋ luushi le bɛ woo bufii bu Mfɔŋ Salimu. Ntee beŋ yikɛ yɛɛŋ nɛ woo, wi wumu wɛ fɛni bɛ fiee fi kuu fi yɛki fi Salimu-u. ");
INSERT INTO asj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Fiana yi tii ti buti li yi yi wi-i yi gɛɛŋ libuka yi geendi fɛ yi gii yi ni yi tsiiŋ. Se nuuŋ le, ɛ yi tuu yi gɔɔŋ nsiŋ, ");
INSERT INTO asj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yi tuu yi kweeŋ li yi yee li le, ‘Ŋgii ŋkaari nto li mi-i yih lu ntuu mbo.’ Mfi wu yi kaari yi bɛ yi ŋɛŋ le yih yilu yɛ kilɛrɛ, ɛ bɛ nachɛ bɛ fweyɛ yi wuuti, ");
INSERT INTO asj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","bɛdɛɛni, yi biee yi kaari yi gɛɛŋ, yi bɛ bɛ fiana yi tii yimi mfomɛnyaaŋ yi tɛɛmi yi yɛki yi, bee yi se tuu be bɛ be lɛ be tsiiŋ lu. Biee tuu bi mɛɛshi bi bee li mwɛ mfi wulu yaa si mwɛ tɛ̀ saa nuuŋ. Fi fiɛɛ nɛɛ lɛ si fi gii naa fi nuuŋ li kiŋgɔkɛ ki bifi ki dɛɛni kini.” ");
INSERT INTO asj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nɛɛ si Jiso tɛ̀ mɛɛŋ yeti li bɛniiŋ li lɛ, fi ka le ni Jiso bee bɛ ŋwaani Jiso tɛ̀ bɛ be leŋ lɛkuuŋ be wɛki le be yɔ bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wi wumu se tee li Jiso-o le, “Na bee bɛŋwaana lemi baa lɛkuuŋ be wɛki le nɛɛ be nɛ yɔ.” ");
INSERT INTO asj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Se bii li wuu laa, “Naaŋ nuuŋ noo, bɛŋwaanɛŋ nuuŋ baŋ?” ");
INSERT INTO asj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Le bii lɛ, biee doonchɛ bɛniiŋ bee bɛ kintutu-u, tee le, “Baaŋ bɛnaaŋ bee bɛŋwaanɛŋ. ");
INSERT INTO asj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nɛ kɛɛ le wi kwikwi wu feti fiee fi Baa wɛŋ wu liboo kɔŋgisi, kɛ mwɛ wɛ ŋwaanɛŋ wu nyuŋ mɔɔ wu kwɛɛŋ mɔɔ naaŋ.” ");
INSERT INTO asj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nɛɛ booyaa, Jiso dza bo li yih, gɛɛŋ shee li libɛ lichiŋ. ");
INSERT INTO asj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kintutu ki bɛniiŋ lɛ kinɔŋa banchɛ li wuu lichiŋ ki kɛnɛ. Dza lɛ shee nuuŋ lɛ ŋgo-o, kintutu kilu leŋ libuka li ŋgemɛ yi dzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bɛchi tiiti biee ŋge li bee lɛ ŋgaŋgaa li. Tee le, “Wi wumu tɛ̀ la le gɛɛŋ tuŋ biee. ");
INSERT INTO asj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Si tɛ gii tumi lɛ, bimu we yɛ lɛ dze, muniiŋ bɛ mu chɔchɛ mu ji. ");
INSERT INTO asj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bimu we yɛ li bintsii bi ta-a nshɛ nuuŋ yɛ fe ŋge kɛ, bi bo kifɛ nshɛ tɛ̀ nuuŋ yɛ fe ŋge kɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Le wiiŋ bɛchi mbanu wu sooŋ biee bilu. Si bi ti mɛɛŋ ki seri kɛ le bi gɛɛŋ ŋge kɛ lɛ, bi biee bi wɔɔbɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bimu we yɛ li bifafu-u. Bifafu bilu ko bi beemɛ biee bilu. ");
INSERT INTO asj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bimu we yɛ tɛ nuuŋ li nshɛ yi dzeeŋ li, le bi bo bi ko bi woŋ bujɔŋ. Bintutu bimu tɛ̀ nuuŋ sháŋ gwii, bimu mbaambusɔɔ, bimu mbaanshɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wi wu kɛmi bitooŋ, mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bɔɔŋ bɛ kintutu-u bɛ Jiso dza be kiiŋgi, be gɛɛŋ be bii li wuu laa, “Ɔ yeti li bɛniiŋ bani nuuŋ lɛ ŋgaŋgaa kii la?” ");
INSERT INTO asj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tuu li bee le, “Nyɔ fɛ yɛ beŋ le nɛ kɛɛ biee bi bumfɔŋ bu liboo bi nuuŋ lɛ munyiikɔɔ li. Se nuuŋ le, yi se mɛɛŋ yɛ ki fɛ kɛ le bɛniiŋ bani kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nɛ kɛɛ le wi wu kɛmi fiee bɛ gii bɛ tondɛ fi yaŋ. Wi wu kɛmi yɛ fiee kɛ mɔɔ fi niiŋ fi kɛmi, bɛ gii bɛ fi li wuu bufiɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Fiɛɛ fiee fi ntiiti li bee lɛ ŋgaŋgaa li, kifɛ be bichi biee be tɛ ŋɛŋ kɛ. Be yiki biee be tɛ woo mɔɔ nuuŋ le be kɛɛ bi kɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Fiee fi ntomfɔŋ wu Nyɔ wu Ɛsaya tɛ̀ tee fi gbɛɛŋ fiɛɛ fi kɔchɛ bɛ fiee fi bɛniiŋ bani feti. Tɛ̀ tee le, ‘Nɛ gii nɛ ni nɛ yiki biee, se nuuŋ le nɛ tɛ woo kɛ. Nɛ gii nɛ ni nɛ bichi biee, se nuuŋ le nɛ tɛ̀ ŋɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Fi fiɛɛ lɛ kifɛ shéŋ yi bɛniiŋ bani dɛŋ yɛɛ kituŋ, bintooŋ bi bee chiinyɛ biɛɛ kituŋ, bɛ baanyɛ baa lii yibe kituŋ. Bɛ fɛ baa lɛ le kiiŋ be ni be ŋiŋgi biee bɛ lii yibe, le be ni be wuki mɔɔ biee bɛ bintooŋ bi bee kɛ, shéŋ yibe se ni yi yuusi, le be se kaari be to lijiŋ lɛ mi-i, nse ŋ'wɔnchɛ be.’ ");
INSERT INTO asj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Se nuuŋ le, kinɛɛtinɛ ki nɔŋa kɛɛ kinɛ kifɛ lii yinɛ ŋɛŋ yɛɛ biee bini, bintooŋ binɛ woo biɛɛ biee bini. ");
INSERT INTO asj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ntee beŋ chɛɛŋ le, bɛntomfɔŋ bɛ Nyɔ-ɔ ŋge bɛ bɛniiŋ bɛ tsaaŋ bamu tɛ̀ shiiŋ be dii le be ŋɛŋ biee bi nɛ ŋiŋgi bini, be tɛ ŋɛŋ kɛ. Be dii tɛ le be woo biee bi nɛ wuki bini, be tɛ woo kɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Woo yɛɛŋ fiee fi ŋgaŋgaa chi kii wi wu tɛ̀ tumi biee chini doonchi. ");
INSERT INTO asj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɛ wi shiiŋ wuki fiee kii bumfɔŋ bu liboo ŋkɛɛ kinyi kilu nsiŋ, kɛ Sataŋ wu wi wu bifi bɛɛɔ wu kɛnchɛ jɛ yi bɛ tɔyɛ li shéŋ yee li wu buu. Fini fiɛɛ nɛɛ si biee bi bɛ tɛ̀ tumi bi we yɛ lɛ dze biɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Biee bi bɛ tɛ̀ tumi bi we yɛ li kintsii ki taa biɛɛ nuuŋ si wi wu wuki jɛ yi Nyɔ fi yi mfwa mumkpaŋ bɛ kinɛɛtinɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Se nuuŋ le, ɛ yi lɛ li shéŋ yee li, yi tɛ lii gɛɛŋ kɛ. Yi ŋɔɔnɛ niiŋkwaa. Ɛ ŋgɛ bɛchi mɔɔ nuuŋ bikaa bi beŋɛ lɛ wuu jiŋ kii jɛ yilu, biee to lijiŋ mfwaa mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Biee bi bɛ tɛ̀ tumi bi we yɛ li bifafu-u biɛɛ, se nuuŋ wi wu wuki jɛ yi Nyɔ, bɛmfumisɛ bɛ biee bi li nshɛ yini-i, mɔɔ bɛmbeechɛ kii bulofu tuu bi baanyɛ jɛ yilu yi laayɛ li yee li. ");
INSERT INTO asj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Biee bi bɛ tɛ̀ tuŋ li nshɛ yi dzeeŋ li se nuuŋ wi wu wuki jɛ yilu, woo fiee bujɔŋ feti si yi wɛki, biee bilu se woŋ, bimu nyɛ lii gwii, bimu lii mbaambusɔɔ, bimu mbaanshɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiso tuu wa ŋgaŋgaa chimu li bee le, “Bumfɔŋ bu liboo nuuŋ bɛ maa bɛ wi wumu wu tɛ̀ gɛɛŋ tuŋ ŋgɔ yi giiŋ yi dzeeŋ li wuu wɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Le bɛniiŋ ni be liiti, wi we wu mbani gɛɛŋ tuŋ ŋgɔ yi kitɔɔ ki bosini giiŋ lu linti dza. ");
INSERT INTO asj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Le giiŋ yilu maŋ yi bɛchi ŋko, ŋgɔ yi kitɔɔ yɛ biee yi yenɛ tɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bɛniiŋ bɛ nimɛ-ɛ bɛ wi wɛ wulu bɛ be bii li wi wulu laa, ‘Te Kikoo, ɔ tɛ̀ tuŋ nuuŋ ŋgɔ yi giiŋ, yi kitɔɔ yini tuu yi bo fɛŋ lu linti?’ ");
INSERT INTO asj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tuu li bee le, ‘Ɛ wi wɛŋ wu mbani wu fɛ fiee fini.’ Bɛniiŋ bee bɛ nimɛ bɛlu bii li wuu laa, ‘ɔ wɛki le tɛ gɛɛŋ tɛ chɔɔchɛ ni?’ ");
INSERT INTO asj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te Kikoo wube faaŋ tee li bee le, ‘Ɛ nɛ gɛɛŋ le nɛ chɔɔchi baa kitɔɔ, nɛ dza nɛ chɔɔchɛ mɔɔ giiŋ lu linti. ");
INSERT INTO asj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gɛɛ yɛɛŋ lɛ bi ni bi kuu nsiiŋ bi gɛɛŋ bi bo mfi wu ŋ'wechɛ. Ke mfi wu ŋ'wechɛ nse ntee li bɛniiŋ bɛ ŋ'wechɛ le be saa be chɔɔchɛ kitɔɔ kilu be banchɛ be gɛɛ li bintutu-u li bintutu-u, be tɔŋ, be se banchɛ giiŋ be gɛɛ li gwɛɛ wɛ-ɛŋ.’” ");
INSERT INTO asj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jiso se tuu wa ŋgaŋgaa chimu li bee le, “Bumfɔŋ bu liboo nuuŋ si lisi chi ŋgɔ yi fintaaŋ fimu fi wi tɛ̀ tɔyɛ li wuu wɛ, ");
INSERT INTO asj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ŋgɔ yini nuuŋ yi sendɛ yi yaa ŋgɔ́ yimi chichi. Se nuuŋ le, mfi wu yi bo, yi gii yi ko yi yaa biee bichu, yi tuu yi dza yi to kiti ki muniiŋ mu jiindi liwe gii mu bɛ mu gwanyɛ yíh li yɛŋɛ yilu-u.” ");
INSERT INTO asj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Se tuu wa ŋgaŋgaa chimu li bee le, “Bumfɔŋ bu liboo bwɛɛ si kishee ki kwɛɛŋ tɛ̀ fichɛ musu bɛke bɛ nɔŋa bɛ nɔŋa bitɛɛtu, dzɔ finsɛ lu, tɔ gɛɛ, ki se tuu ki fɛ musu mɛlu mɛnchu dooki ŋge.” ");
INSERT INTO asj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiso tɛ̀ gii tiiti biee bini bichu li kintutu ki bɛniiŋ lɛ, nuuŋ nɛɛ lɛ ŋgaŋgaa li. Tɛ̀ gii gbɛŋgi yɛ tiiti biee li bee fuki lɛ ŋgaŋgaa li nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tɛ̀ gii feti lɛ le fi bɛ fi kɔchɛ si ntomfɔŋ wu Nyɔ wumu tɛ̀ saa tee le, “Ŋgii ni ŋgwiyi kimfimɛ keŋ buti nɛɛ nuuŋ ŋgaŋgaa le. Ŋgii ntee kii biee bi tɛ̀ nuuŋ lɛ munyiikɔɔ li mbɛɛchɛ si bɛ tɛ̀ tɔŋ nshɛ.” ");
INSERT INTO asj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jiso dza shɛ kintutu ki bɛniiŋ lɛ, gɛɛŋ lɛ li yih. Bɔɔŋ bee bɛ kintutu biee wu, be tee li wuu le, “Tee bee fiee fi ŋgaŋgaa chi kitɔɔ ki liwɛ chɛɛ doonchi.” ");
INSERT INTO asj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Se tee le, “Wi wu tumi ŋgɔ yi dzeeŋ yilu ɛ Ŋwanɛwi. ");
INSERT INTO asj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wɛ wulu ɛ nshɛ yini. Ŋgɔ yi dzeeŋ yɛ doonchi bɔɔŋ bɛ nuuŋ bɛ bumfɔŋ bu Nyɔ-ɔ. Kitɔɔ kɛɛ nuuŋ bɔɔŋ bɛ wi wu bifi wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wi wu mbani wu tɛ̀ tuŋ kitɔɔ kilu ɛ kiŋkundi. Mfi wu ŋ'wechɛ wɛ nuuŋ mfi wu ntsɛ wu li nshɛ yini-i gii naa wu ma. Bɛniiŋ bɛ ŋ'wechɛ nuuŋ bɛnchindaa bɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Si bɛ tɛ̀ banchɛ kitɔɔ kilu bɛ tɔŋ fɛ wi lɛ, ɛ nɛɛ lɛ si fi gii fi nuuŋ mfi wu nshɛ mɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ŋwanɛwi gii naa tuumi bɛnchindaa bee, be dɛndɛ li bumfɔŋ bwee li buchu be banchɛ biee bichu mɔɔ bɛniiŋ bɛ kichi yɛ bɛnchi bɛ Nyɔ-ɔ kɛ bɛchu be buu, ");
INSERT INTO asj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","be lɔŋ be fɛ mbwɛɛŋ wu wi-i. Ɛ fe fɛ bɛniiŋ gii be ni be dii be jii ŋgesi. ");
INSERT INTO asj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bɛdɛɛni bɛniiŋ bɛ tsaaŋ gii be ni bɛndi si jobɛ, lɛ bumfɔŋ bu Tee wube-e. Wi wu kɛmi bintooŋ mwɛ woo. ");
INSERT INTO asj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Bumfɔŋ bu liboo bwɛɛ si bulofu bu wi tɛ̀ dzɔ gɛɛŋ nyikɛ liwɛ. Le wumu bɛ buŋɛ, kaari baanyɛ, koo fɛkuuŋ bɛ kinɛɛtinɛ. Gɛɛŋ kabɛ biee bichu bi tɛ̀ kɛmi, gɛɛŋ go wɛ wulu. ");
INSERT INTO asj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bumfɔŋ bu liboo bwɛɛ nɛɛ si wi wu waŋ wumu wu tɛ̀ deŋgi wɛki sháŋ yi munchi mu dzeeŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Le ni geendi, gɛɛŋ buŋɛ fimu nuuŋ fi tɛɛmi. Gɛɛŋ kabɛ biee bichu bi tɛ̀ kɛmi le gɛɛŋ go shaŋ yi finchi filu. ");
INSERT INTO asj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Bumfɔŋ bu liboo bwɛɛ si gwii wu bɛ tɛ̀ lɔŋ li dzɔɔ, bini bi nsúuŋ lɛ bichu bɛ bi lɛ lu, ");
INSERT INTO asj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","wu yisɛ. Le bɛniiŋ chee be buu lɛ bukaka, be shee fɛkwiiŋ, be tsaa nsúuŋ yi dzeeŋ be gɛɛ lɛ bɛŋkaa li, be too yi bifi yɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɛ nɛɛ lɛ si fi gii fi nuuŋ li mfi wu nshɛ naa mɛɛ. Bɛnchindaa bɛ Nyɔ-ɔ gii naa be bo be bɛ be gatɛ bɛniiŋ bɛ bifi li bɛ dzeeŋ li linti, ");
INSERT INTO asj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","be lɔŋ be fɛ mbwɛɛŋ wu wi-i, fɛ bɛniiŋ gii be ni be jii ŋgesi.” ");
INSERT INTO asj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jiso se bii li bɔɔŋ bee bɛ kintutu-u laa, “Nɛ woo baa biee bini bichu bujɔŋ ni?” Be beŋ le, “Iiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Se tuu tee li bee le, “Fi se fiɛɛ le, wi kwikwi wu tiifi bɛnchi bɛ Nyɔ-ɔ wu bɛ tɛ̀ saa bɛ tifi wu kituŋ kii bumfɔŋ bu liboo nuuŋ si te yih wu kɛmi bulofu, wu nuuŋ buu biee bi fɛŋ lu, kɛ biee bi fichi fɛ kintsii kilu-u.” ");
INSERT INTO asj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Le Jiso mɛɛshi wa ŋgaŋgaa yini ni, biee dza fe, ");
INSERT INTO asj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","gɛɛŋ li kitoŋ kee li, gɛɛŋ lɛ tiifi bɛniiŋ li yíh yibe yi lɛkɛ li Nyɔ-ɔ. Le be woo ntiifɛ we, be kɛmɛ kintɛwa, be bɛchi be tiiti laa, “Wi wuni dzɔ buni bufii bɛ buŋga fɛŋ bu feti bintɛwa bi biee lɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ɛ nɛɛ ŋwanɛ te la wuni wu ti keendi biti wɛ ni? Ni nuuŋ nɛɛ Maariya ni? Bɛŋwaani nuuŋ nɛɛ Jeeŋ bee Jɔsɛ mɔɔ Simu mɔɔ Judas ni? ");
INSERT INTO asj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dzɛ́mi yee chichi nuuŋ nɛɛ bɛ bee fɛni ni? Wi wuni dza fɛŋ bɛ biee bini bichu ni?” ");
INSERT INTO asj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Si be njanji lɛ be biee be faaŋ wu. Jiso se tee li bee le, “Bɛ ti guundi ntomfɔŋ wu Nyɔ fɛ bintsii bichu-u, ɛ nɛɛ fɛ kwɛɛŋ wee li mɔɔ li kini kee li kwaa fɛ bɛ ti guundi yɛ wu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jiso ti mɛɛŋ ki tuu kɛ le fɛ mfiŋ fe ŋge kɛ, kifɛ be ti mɛɛŋ ki gɛɛ kɛ shéŋ li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tɛ̀ nuuŋ li mfi wulu, Mfɔŋ Hɛrɔ wu tɛ̀ sɛki kimbɛ ki kwɛɛŋ lɛ ki Galilii woo kii nimɛ chi Jiso. ");
INSERT INTO asj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Se tee li bɛniiŋ bɛ tɛ̀ nindi lɛ wu lɛŋkwiiŋ li le, “Wi wuni wɛ nuuŋ Jɔɔŋ Nlisulidzɔɔ wu kaari wu bo li kwe-e. Fiɛɛ fiee fi fɛ se kɛmi buŋga bu fɛrɛ bintɛwa bi biee lɛ bini ni.” ");
INSERT INTO asj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tɛ̀ tee lɛ kifɛ tɛ̀ nuuŋ li mfi wu Hɛrɔ tɛ̀ kɔɔ Jɔɔŋ fa wu li yih yi ncha-a kii Hɛroja wu kwɛɛ ŋwaani wu Fili, wu Hɛrɔ tɛ̀ dzɔ li kwɛsi. ");
INSERT INTO asj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jɔɔŋ tɛ̀ faaŋ tee le nchi mɛɛŋɔ ki beŋ kɛ le Hɛrɔ dzɔɔ kwɛɛ ŋwaani li kwɛsi-i kɛ. ");
INSERT INTO asj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛrɔ se waaŋ dze le wo Jɔɔŋ, se nuuŋ le tuu chɛndi bɛniiŋ, kifɛ bɛniiŋ tɛ̀ dzeti Jɔɔŋ si ntomfɔŋ wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Le ni nuuŋ jobɛ chi Mfɔŋ Hɛrɔ tɛ̀ feti tsɔnɔ le kimi jobɛ chi bɛ tɛ̀ biɛ wu, ŋwanɛ Hɛroja wu kwɛɛŋ lɛ, bwachɛ binɛ limfwe li bɛniiŋ bɛ tɛ̀ nuuŋ fɛ tsɔnɔ chilu-u, Hɛrɔ ŋɛŋ lɛ yi yuusɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Se kaachɛ ŋwaŋ wulu, chini le gii fenyɛ wu mɔɔ nuuŋ bɛ la fi wu bii le fenyɛ wu lu le. ");
INSERT INTO asj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ni ŋwaŋ wulu se tifi ŋwaŋ wulu le tee li wuu le katɛ kikoo ki Jɔɔŋ Nlisulidzɔɔ li nyɛ wu ki fɛ kintɛkɛ-ɛ fɛwe. ");
INSERT INTO asj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Le tee lɛ, Mfɔŋ Hɛrɔ woo, yi wɔɔ wu. Se nuuŋ le, si tɛ̀ chini li bɛniiŋ bɛ tɛ̀ nuuŋ fɛ tsɔnɔ limfwe lɛ, beŋ tee le be fɛ si ŋwaŋ wulu tee. ");
INSERT INTO asj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Se toŋ bɛniiŋ be gɛɛŋ li yih yi ncha-a be ka kikoo ki Jɔɔŋ lɛ, ");
INSERT INTO asj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","be bɛ bɛ kikoo kee fɛ kintɛkɛ-ɛ be nyɛ li ŋwaakwɛɛŋ wulu-u, se gɛɛŋ bɛ ki nyɛ li ni-i. ");
INSERT INTO asj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bɔɔŋ bɛ Jɔɔŋ lɛ bɛ kintutu gɛɛŋ be dzɔ gwini chi Jɔɔŋ lɛ be diyɛ, be gɛɛŋ be tee ntoŋ wulu li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Le Jiso woo fiee fi ka bɛ Jɔɔŋ, biee lɛ lɛ ŋgo cheekiyi gɛɛŋ fɛ kintsii ki bɛniiŋ nuuŋ yɛ kɛ. Se nuuŋ le, bintutu bi bɛniiŋ lɛ woo, bi bo li bintsii li bi deŋgi bɛ bikaa bi biki wu. ");
INSERT INTO asj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Le bo lɛ ŋgo ni fɛɛshi li buka, ŋɛŋ si kintutu ki bɛniiŋ lɛ turi fe ni mamama. Nshiiŋ kɔɔ wu bɛ be, se bɛchi wɔnchi bɛniiŋ bɛ tɛ̀ gendi. ");
INSERT INTO asj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Le ni nuuŋ lɛ fɛmfo-o, bɔɔŋ bee bɛ kintutu kiiŋgi li wuu lichiŋ, be tee li wuu le, “Fɛni fɛɛ fɛbuka, jobɛ kɔɔ chɛɛ chi seri, tee le bɛniiŋ bani gɛɛŋ li bɛla-a be go biee bi bee bijɛ.” ");
INSERT INTO asj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jiso tuu li bee le, “Fi nuuŋ yɛ le nuuŋ be dza kɛ. Ɛ beŋ nɛ gii nɛ nyɛ be fiee fi jɛ.” ");
INSERT INTO asj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Be tuu li wuu le, “Tɛ kɛmi baa nuuŋ biŋkɛ bi bibele bitiinu bɛ nsúuŋ fiɛɛtu kwaa.” ");
INSERT INTO asj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tee li bee le, “Bɛ yɛɛŋ nɛ nyɛ mi.” ");
INSERT INTO asj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Be bɛ, fi, tee le kintutu ki bɛniiŋ lɛ kilu shee yɛ fɛkwiiŋ li kitɔɔ li. Dzɔ biŋkɛ bi bibele-e bi bi bitiinu biɛɛ bɛ nsúuŋ yi fiɛɛtu yɛɛ, bichɛ liwe, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ li biŋkɛ nyɛ li bɔɔŋ bee bɛ kintutu, be gachɛ li bintutu bilu. ");
INSERT INTO asj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bɛniiŋ bɛchu ji be fukɛ. Bɔɔŋ bɛ Jiso-o bɛ kintutu-u banchɛ mukɛ mu tɛ̀ shɛ mu yisɛ bɛŋkaa yoofi ntsɔ bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bɛniiŋ bɛ tɛ̀ ji bibele bilu tɛ̀ nuuŋ buniŋ kwaa si bɛnchuki bɛtiinu, bɛ ti mɛɛŋ ki fa kɛ bukɛɛŋ bɛ bɔɔŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jiso tuu tee li bɔɔŋ bee bɛ kintutu le be lɛ lɛ ŋgo-o, be too wu mbaaŋ shɛ tee li kintutu ki bɛniiŋ lɛ kilu le ki ni ki kuuki. ");
INSERT INTO asj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Shɛ yɛsi be, dza yɛɛ li ŋkumɛ-ɛ, le lɛkɛ li Nyɔ-ɔ. Le lɛkuuŋ jiŋ nuuŋ nɛɛ fe wuu mbiiŋ. ");
INSERT INTO asj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Se nuuŋ le li mfi wulu-u, be tɛ̀ gɛɛŋ mfiiŋ li dzɔɔ, ŋgo wulu tɛ̀ nduŋgi, kifɛ mbaandze tɛ̀ bɛɛ dze limfwe yɛkisi dzɔɔ yi juti wu. ");
INSERT INTO asj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Le ni nuuŋ lɛ ŋ'wori, Jiso dza bɛɛ fɛ bee deŋgi li dzɔɔ li liwe. ");
INSERT INTO asj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Se nuuŋ le bɔɔŋ bee bɛ kintutu ŋɛŋ si deŋgi li dzɔɔ li, be dzakɛ be kɛɛti. Be bɛchi be tiiti le “Ɛ ŋkuubee.” Be bɛchi be chɛndi be dzɛŋgi lɛwe ŋge. ");
INSERT INTO asj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mfwaa mumkpaŋ Jiso tee li bee le, “Kɛmɛ yɛɛŋ shéŋ, ɛ mi nɛ chɛŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita tee li wuu le, “Taa ɛ nuuŋ wɛ, ɔ tee ndɛndɛ tɛ li dzɔɔ li liwe mbɛ fɛ wɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jiso tee li wuu le, “Ɔ bɛɛ lɛ.” Nɛɛlɛ Pita bo lɛ ŋgo-o deŋgi li dzɔɔ giiŋgi fɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Si tɛ̀ deŋgi giiŋgi lɛ, ŋɛŋ si mbaandze nduŋgi dzɔɔ, se bɛchi chɛndi, bɛchi sechi li dzɔɔ. Si tɛ̀ sechi lɛ dii le, “Taa fi mi!” ");
INSERT INTO asj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mfwaa mumkpaŋ Jiso lɔŋ kibɛnɛ kɛmɛ li wuu, tee li wuu le, “Hooo, kimbeenchɛ ko sendɛ kɛɛ ŋge! Ɔ bee ɔ mɛŋini kii la?” ");
INSERT INTO asj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bee wu se miri lɛ ŋgo-o lɛnti, mbaandze wulu chikɛ. ");
INSERT INTO asj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bɔɔŋ bee bɛ kintutu-u bɛ tɛ̀ nuuŋ lɛ ŋgo-o baa yɔɔŋgi wu be tee le, “Chɛɛŋ, chɛɛŋ ɛ wɛ Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Le be lenchi libɛ be bo kimbɛ ki Jɛnɛsarɛ. ");
INSERT INTO asj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bɛniiŋ bɛ fe ŋɛŋ wu, be jiiŋgi wu, be tuumi ntoŋ li bimbe bi fe bichu-u, bɛniiŋ bɛɛ bɛ bɛniiŋ bɛ chigɔ-ɔŋ lɛ bɛchu lɛ Jiso-o, ");
INSERT INTO asj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","be suŋgi bɔ le gɛɛ be koŋ mɔɔ nuuŋ li wooŋ wu kiŋkoŋ kee li. Wi kwikwi wu tɛ̀ koŋ, tɛ tɛmi. ");
INSERT INTO asj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bɛfarasii bɛ bɛniiŋ bamu bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ tɛ̀ dza Jɛrosalɛŋ be bɛ fɛ Jiso-o be bii li wuu laa, ");
INSERT INTO asj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Fi nuuŋ kii la fi bɔɔŋ bo bɛ kintutu-u biki yɛ ntsɛ wu bɛtaa bɛsɛŋ? Be tsootsi yɛ tsaŋ lɛ dze yi nchi wɛki be se jii biee kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jiso se tuu li bee le, “Fi nuuŋ tɛ kii la fi nɛ bondini finɛ nuuŋ bɛnchi bɛ Nyɔ nɛ biki nuuŋ ntsɛ wunɛ? ");
INSERT INTO asj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ntiitɔɔ ni, kifɛ Nyɔ tɛ̀ tee le, ‘Yooki chaa bee na.’ Tuu tee tɛ le, ‘Ɛ wi gaa tee kɛ ni, bɛ wo mwɛ dududu.’ ");
INSERT INTO asj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Se nuuŋ le, nɛ tiiti baa finɛ le, ‘Ɛ wi dza wu tee li tee li kɛ li ni-i le, “Fiee fi bee ɔ kɛmɛ li tsaŋ yɛɛŋ, mi nyɛɔ fi li Nyɔ kituŋ,” kɛ nuuŋ tɛ tuu le yooki tee kɛ ni le dzɔɔ fiee filu nyɛ li bee kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ɛ lɛ si nɛ biki baa ntsɛ wunɛ wu kwɛɛŋ ni, nɛ se feti jɛ yi Nyɔ tuu fiee fi yee. ");
INSERT INTO asj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bɛniiŋ bɛ nimi-i bani! Fiee fi ntomfɔŋ wu Nyɔ wu Ɛsaya tɛ̀ tee kii beŋ fiɛɛ chɛɛŋ, si tɛ̀ tiiti le, ");
INSERT INTO asj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bɛniiŋ bani guundi mi nuuŋ bɛ bimfimu, shéŋ yibe nuuŋ mfiiŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Be guundi mi nuuŋ li yee li, kifɛ be dzeti biee bi bɛniiŋ beechi be tiifi le ɛ jɛ yɛŋ.’” ");
INSERT INTO asj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jiso dza teeŋ bɛniiŋ le be bɛ. Tee li bee le, “Yikɛ yɛɛŋ nɛ woo, nɛ kɛɛ bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fiee fi lii wi lɛwa nuuŋ fi tɛ̀ naa biifi wi kɛ. Ɛ fiee fi buti lɛ wi-i wa fi nuuŋ fi biifi wi.” ");
INSERT INTO asj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bɔɔŋ bɛ Jiso bɛ kintutu dza be bɛ be tee li wuu le, “Ɔ kii nɛɛ le Bɛfarasii be be woo fiee fi ɔ bee ɔ kweeŋ fiɛɛ fi tɔŋ be ni?” ");
INSERT INTO asj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tuu li bee le, “Kiti kichu ki nuuŋ yɛ ntɔyɛ wu Baa wɛŋ wu nuuŋ liboo nsiŋ kɛ bɛ gii bɛ buu ki. ");
INSERT INTO asj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Daayɛ yɛɛŋ lɛ bee, ɛ kinyɛɛ ki doonchi dze li kinyɛɛ kimu. Ɛ kinyɛɛ doonchi dze li kimu, kɛ bi bichu gii bi gɛɛŋ bi we yɛ lɛ kitoo li.” ");
INSERT INTO asj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita se tee li Jiso-o le, “Naanyɛ bee fiee fi ŋgaŋgaa chini tiiti.” ");
INSERT INTO asj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jiso bii laa, “Nɛ kii yɛ tɛ biee ni? ");
INSERT INTO asj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nɛ kii yɛ le fiee fichu fi ti lii lɛ wi-i wa fi bɔɔ li shéŋ fi dɛndɛ fi bo ni? ");
INSERT INTO asj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Se nuuŋ le, fiee fi buti lɛ kimfimɛ ki wi-i dzɛti nuuŋ li shéŋ yee li, fi se bifisi wi. ");
INSERT INTO asj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Fi ti dzɛti li shéŋ, wi se kɛmɛ mbeechɛ wu bifi, tuu wo wi, dzɔ kwɛɛ wi mɔɔ nuuŋ nyumɛ wi, ji bukwɛɛ, yi buyi, leŋ lɛjiŋ lɛ nsa wu binsɛɛ lɛ, bɛ bukooŋ bu wi-i bu bifisɛ. ");
INSERT INTO asj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bini nuuŋ biee bi nuuŋ bi biifi wi. Se nuuŋ le njɛ biee bɛ tsaŋ ntsootsɛ nsiŋ nuuŋ tɛ biifi wi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jiso dza fe cheekiyi gɛɛŋ kimbɛ ki Tayɛ bɛ Sidɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Fi se ka le kwɛɛŋ wumu wu Kana wu tɛ̀ nuuŋ fe tɛ̀ dza bɛ ŋɛŋ Jiso, dii li wuu le, “Hooo Taa, Ŋwanɛ kini ki Mfɔŋ Daafi, kɔɔ nshiiŋ bɛ mi. Ŋwanɛ kiŋkundi wumu ŋ'wɛkɔɔ bɛ ŋwanɛŋ wu kwɛɛŋ ŋge.” ");
INSERT INTO asj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jiso woo, ba fiee n'yɔru nsiŋ. Bɔɔŋ bee bɛ kintutu kiiŋgi be lɛki wu be tiiti le, “Tee li kwɛɛŋ wuni le ni giiŋgi. Bikɔɔ nyɛɛ bee ŋgɛ.” ");
INSERT INTO asj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jiso se tuu le, “Bɛ tɛ̀ toŋ mi nuuŋ li bɛniiŋ bɛ Isɛlɛɛ kwaa. Be baa si nshɔ́ɔŋ yi la.” ");
INSERT INTO asj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Se nuuŋ le, kwɛɛŋ wulu bɛ nɛɛ tuu toŋ núŋ li Jiso-o limfwe tee le, “Taa, fi nɛɛ mi.” ");
INSERT INTO asj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jiso se tuu li wuu le, “Fi mɛɛŋ ki dzɔɔŋ kɛ le bɛ dzɔɔ bijinɛ bi bɔɔŋ lɛ bɛ lɔŋ li bwí kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kwɛɛŋ wulu se tee le, “Fi fiɛɛ chɛɛŋ baa wɛŋ. Se nuuŋ le, bwí ti bɛɛ yi bɔɔnyi muŋkɛ mu mwee lɛ fɛ baa we jii biee mu weyi.” ");
INSERT INTO asj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jiso se tuu li wuu le, “Hooo kwɛɛŋ wuni, mbeenchɛ wa tɛmɔɔ. Fi ka bɛ wɛ si ɔ kɔŋgisi.” Nɛɛ lɛ ŋwaŋ wɛ biee tɛmi. ");
INSERT INTO asj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Le Jiso dza fe ni giiŋgi, gɛɛŋ ka li libɛ chi Galilii lichiŋ, miri gɛɛŋ li ŋkumɛ-ɛ, shee fe. ");
INSERT INTO asj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kintutu ki bɛniiŋ lɛ ki nɔŋa bɛ lɛ wuu ni giiŋŋ. Bamu tɛ̀ bɛɛ bɛ bɛniiŋ bɛ nuuŋ bimbonyɛ, mɔɔ binyɛɛ, mɔɔ bɛ biŋkɛrɛ, mɔɔ bibere, bɛ bamu ŋgee. Si be tɛ̀ bɛɛ bɛ be lɛ, be gikisi wu limfwe se wɔnchi be. ");
INSERT INTO asj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kintutu kilu tɛ tuu ki kɛmɛ bintɛwa si ki tɛ̀ ŋɛŋ bibere yeti, bimbonyɛ deŋgi, biŋkɛrɛ deŋgi tsaaŋ, binyɛɛ ŋiŋgi biee. Be yooki Nyɔ yi bɛniiŋ bɛ Isɛlɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiso tuu teeŋ bɔɔŋ bee bɛ kintutu-u tee li bee le, “Ŋkɛmɔɔ nshiiŋ li kintutu kini, kifɛ ki nuuŋ kɛɛ bɛ mi jo taa, fiee fi ki nuuŋ ki ji se nuuŋ yɛ lu kɛ. Ŋ'wɛki yɛ le nchinɛ li bee le be gɛɛŋ bɛ dzeeŋ kɛ, kifɛ nuuŋ be gɛɛŋ be we yɛ lɛ dze bɛ dzeeŋ.” ");
INSERT INTO asj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bɔɔŋ bee bɛ kintutu-u baa se bii li wuu laa, “Tɛ gii tɛ dzɔɔ biee bijɛ fɛŋ libuka luni bi tɛ nuuŋ tɛ nyɛkɛ ŋwaani kintutu ki bɛniiŋ lɛ kini lu?” ");
INSERT INTO asj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jiso bii li bee laa, “Nɛ kɛmi baa tsée yi bibele bi mɛ?” Be tuu le, “Yi yɛɛ mfomɛnyaaŋ bɛ musuŋgu niiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jiso tee le kintutu ki bɛniiŋ lɛ kilu le ki shee yɛ fɛkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ki shee yɛ, dzɔ tsée yi bibele yi mfomɛnyaaŋ yɛɛ mɔɔ nsúuŋ yilu, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ nyɛ li bɔɔŋ bee bɛ kintutu-u, be gachɛ li bɛniiŋ bɛlu-u. ");
INSERT INTO asj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wi kwi ji fukɛ. Be banchɛ muŋkɛ mu tɛ̀ shɛ, mu yisɛ bɛŋkaa mfomɛnyaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bɛniiŋ bɛ tɛ̀ ji, tɛ̀ nuuŋ buniŋ kwaa bɛnchuki bɛnɛɛ, bɛ tɛ̀ mɛɛŋ ki fa kɛ bukɛɛŋ mɔɔ bɔɔŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Se chinɛ kintutu kilu ki koo. Lɛ lɛ ŋgo-o gɛɛŋ lɛ kimbɛ ki Magada-aŋ. ");
INSERT INTO asj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bɛfarasii bee Bɛsadusii tɛ̀ dza be bɛ le be mɔnchɛ Jiso, be tee le fɛ fiee fi doonchi buŋga bu bɛɛ liboo. ");
INSERT INTO asj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jiso tee li bee le, “Bɛɛ ɛ nuuŋ mfi wu jobɛ sechi kiboo yɛchi, nɛ tee le, ‘Kikuuŋ gii ki bo ki dzɔɔŋ,’ kifɛ nɛ ŋɛŋ baa kiboo yɛchi. ");
INSERT INTO asj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɛ nuuŋ mfi wu jobɛ tɛti kiboo yɛchi ɛ kikuŋ laaŋ, nɛ tee le, ‘Mbaandze gii ka bɛŋ,’ kifɛ nɛ ŋɛŋ baa kiboo yɛchi kikuŋ lɛɛndi. Nɛ ti mbichi kiboo nɛ kii si kikuuŋ gii ki nuuŋ, nɛ se tɛ kɛɛ bɛŋkiki bɛ biee bi kɛti li mfi wuni kɛ kii la? ");
INSERT INTO asj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kiŋgɔkɛ ki bifi ki chinɛ Nyɔ ki to si kwɛɛŋ wu chinɛ nyumi kini, ki wɛki fiee fi doonchi buŋga bu bɛɛ liboo. Nnuuŋ ntɛ ndoonchɛ beŋ mfiŋ yimi kɛ fuki nɛɛ mfiŋ yi ntomfɔŋ wu Nyɔ wu Jɔna yɛɛ nsiŋ kɛ.” Si tɛ̀ tee lɛ shɛ be dza giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bɔɔŋ bɛ Jiso bɛ kintutu fɛsi luwiŋ be ŋɛŋ le be daayɛ baa le be dzɔɔ kibele. ");
INSERT INTO asj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jiso dza tee li bee le, “Dzɔɔ yɛɛŋ mfi kii kishee ki Bɛfarasii mɔɔ ki Bɛsadusii.” ");
INSERT INTO asj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bɔɔŋ bee bɛ kintutu bɛchi be yeti li yi yi bee kii fiee filu, be tiiti le, “Tiitɔɔ tefɛ chini ni kifɛ tɛ mɛɛŋ baa ki bɛ kɛ bɛ kibele kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jiso kɛɛ fiee fi be yeti kii fi biee tee le, “Hooo bɛniiŋ bɛ kimbeenchɛ kintɛŋ bani-i! Nɛ yeti li yi yinɛ-ɛ nuuŋ kii kibele ki nɛ mɛɛŋ ki kɛmɛ kɛ kii la? ");
INSERT INTO asj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nɛ kii yɛ biee kɛ ni? Nɛ kiimi yɛ tsée yi bibele yi shiŋ yi bɛniiŋ tuu be ji bɛnchuki bɛtiinu yɛɛ ni? Biŋkɛ bi nɛ tuu nɛ banchɛ tuu be bo bɛŋkaa bɛmɛ? ");
INSERT INTO asj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nɛ kiimi yɛ tɛ tsée yi bibele yi mfomɛnyaaŋ yi bɛniiŋ tuu be ji bɛnchuki bɛnɛɛ yɛɛ ni? Nɛ tuu nɛ banchɛ biŋkɛ bi bo bɛŋkaa bɛmɛ? ");
INSERT INTO asj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɛ la fi fɛ, fi nɛ mɛɛŋ ki kɛɛ kɛ le ntiiti yɛ nuuŋ kii bibele kɛ? Ntiitɔɔ nuuŋ le nɛ dzɔɔ mfi kii kishee ki Bɛfarasii bee Bɛsadusii.” ");
INSERT INTO asj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Si tɛ̀ kweŋgi lɛ be tɛ̀ kɛɛ le tiiti yɛ le be dzɔɔ mfi nuuŋ kii kishee ki bɛ teti kibele lu kɛ, le tiitɔɔ nuuŋ kii ntiifɛ wu Bɛfarasii bee Bɛsadusii. ");
INSERT INTO asj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jiso dza gɛɛŋ bo li kimbɛ ki kwɛɛŋ wu Kasaria wu Filipi, dza bii li bɔɔŋ bee bɛ kintutu-u laa, “Bɛniiŋ kweŋgi le Ŋwanɛwi nuuŋ noo?” ");
INSERT INTO asj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Be tuu li wuu le, “Bɛniiŋ bamu kweŋgi baa le ɛ wɛ Jɔɔŋ Nlisulidzɔɔ, bamu le Ɛlaja bamu kweŋgi le ɔ nuuŋ Jeremaya bamu le ntomfɔŋ wu Nyɔ wumu.” ");
INSERT INTO asj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Se bii li bee laa, “Beŋ kibɛɛ nɛ kweŋgi finɛ le nnuuŋ noo?” ");
INSERT INTO asj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simu Pita se tuu le, “Ɛ wɛ Kinsofu ki Nyɔ tɛ̀ kaachɛ ki nuuŋ Ŋwanɛ Nyɔ, Nyɔ yi kɛmi ntsɛ.” ");
INSERT INTO asj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jiso se tuu li wuu le, “Simu ŋwanɛ Jɔna, Nyɔ bɔɔni yɛ wɛ, kifɛ fini nuuŋ yɛ wi wu bɔ wu tee wɛ kɛ. Ɛ Baa wɛŋ wu nuuŋ liboo wu tee wɛ. ");
INSERT INTO asj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ntiitɔɔ li wɛ-ɛ le ɛ wɛ Pita, ɛ li kimbaŋ kini-i li ŋgii gwaŋ kintaashɛ ki bɛniiŋ beŋ bɛ kimbeenchɛ-ɛ. Nuuŋ buŋga bu kwe-e tɛ shaanshɛ yih yi nlɛkɛ li Nyɔ-ɔ ki bɛniiŋ bɛ kimbeenchɛ-ɛ yilu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ŋgii nyɛ biŋgwiyɛ bi bumfɔŋ bu liboo lɛ li wɛ-ɛ. Fiee fi ɔ gii ɔ kaŋ laaŋkwiiŋ, kɛ bɛ gii bɛ kaŋ liboo tɛ. Fiee fi ɔ gii ɔ fanchɛ laaŋkwiiŋ, kɛ bɛ gii bɛ fanchɛ liboo tɛ.” ");
INSERT INTO asj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Si Jiso tɛ̀ tee lɛ, bɔsɛyi chiinsɛ li bɔɔŋ bee bɛ kintutu-u le kiiŋ be ni mɔŋ be tee li wi-i le nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mbɛɛchɛ li mfi wɛɛ, Jiso bɛchi tiiti li bɔɔŋ bee bɛ kintutu-u le kɛmi le gɛɛŋ Jɛrosalɛŋ, gɛɛŋ ŋɛŋ bumfa le ŋge li tsaŋ yi bɛniiŋ bɛ sɛki kwɛɛŋ li bɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ. Bɛ gii bɛ wo wu, ke jo ka taa kaari bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita dzɔ wu bee wu cheekiyi. Bɛchi wami wu li fiee filu, tiiti le, “Taa, Nyɔ leesɛ! Fini fiee nuuŋ tɛ naa ka bɛ wɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jiso fiiki yi tee li Pita le, “Dza mi lɛjiŋ Sataŋ! Ɔ baŋgɔɔ mi bu baŋgɛ kifɛ ɔ ŋiŋgi yɛ biee si Nyɔ kɛ. Ɔ ŋiŋgɔɔ si wiwoŋ.” ");
INSERT INTO asj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Si Jiso tɛ̀ kweeŋ lɛ, tee li bɔɔŋ bee bɛ kintutu-u le, “Ɛ wi wɛki le ni nuuŋ wi wɛŋ wu kintutu, kɛ kɛmɔɔ le faaŋ yi yee, too kintaaŋ kee ni biki mi. ");
INSERT INTO asj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nɛ kɛɛ le wi wu bachi yi yee kii ni lɛɛ yi kɛ gii lɛɛ yi. Se nuuŋ le, wi wu lɛɛ yi yee kii mi kɛ gii kɛmɛ yi. ");
INSERT INTO asj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɛ bɛ banchɛ nshɛ yini chichi, bɛ nyɛ li wi-i wu ji, se wu tuu wu lɛɛ ntsɛ we, mbeŋ wulu ni nuuŋ la? Fiee fiɛɛ lu fi wi nuuŋ kosɛ bɛ fiana yee ni? ");
INSERT INTO asj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nɛ ni nɛ kii le Ŋwanɛwi gii bɛ bɛ bɛnchindaa bee li bunɔŋa bu Tee lɛ, sooŋ wi kwikwi li fiee fi mwɛ fɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ntee beŋ chɛɛŋ le bɛniiŋ bamu lemi baa fɛni bɛ nuuŋ tɛ naa woo kintsi ki kwe-e fuki fɛ be ŋɛŋ si Ŋwanɛwi bɛɛ bɛ bumfɔŋ bwee nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Le jo ka busɔɔ, Jiso dzɔ Pita bee Jeeŋ mɔɔ Jɔɔŋ wu ŋwaani Jeeŋ, bee be yɛɛ li ŋkumɛ wumu wu ŋgweeŋ li, be nuuŋ fe be be. ");
INSERT INTO asj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Be dza be ŋɛŋ si mfisɛ yee fiiki lɛ be lii, bushi bwee miɛŋini si jobɛ, ndú yee nɛɛŋ yi miɛŋini ni mwamwamwa. ");
INSERT INTO asj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Fi se ka le Mɔɔsɛ bee Ɛlaja tɛ̀ dza be busɛ fe, be tiiti biee bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita se dza taa tee li Jiso le, “Taa, fi dzɔɔŋ fiɛɛ si tɛ baa fɛni ni. Ɔɔ kɔŋgisi lɔɔ, ŋgwaŋ bigɔɔnu fɛni bitɛɛtu, kimu ni ki nuuŋ ko, kimu ki Mɔɔsɛ-ɛ, kimu ki Ɛlaja-a.” ");
INSERT INTO asj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nɛɛ si tɛ̀ gii mɛɛŋ yeti lɛ, fi se ka le kikuŋ ki ncherere tɛ̀ dza ki shee ki baanyɛ be, jɛ yɔ li kikuŋ kilu-u le, “Wuni nuuŋ ŋwanɛŋ, nuuŋ shéŋ yɛŋ. Ŋ'wuki bujɔŋ bɛ wu ŋge. Nɛ wuki yɛɛŋ nuuŋ li wuu.” ");
INSERT INTO asj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Le bɔɔŋ bee bɛ kintutu-u woo jɛ yilu be chɛŋ be kɛɛti, be we be toŋ mɛnshi mɛ bee fɛkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jiso se gɛɛŋ konchɛ li bee tee le, “Dza yɛɛŋ we. Kiiŋ nɛ ni nɛ chɛndi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Le be tsaaki lii liwe be ti mɛɛŋ ki ŋɛɛŋ wi wumu kɛ, be ŋɛŋ nuuŋ Jiso kwaa. ");
INSERT INTO asj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Le be dza li ŋkumɛ wulu-u be ni be beki, Jiso chiinsɛ li bee le, “Kiiŋ nɛ ni tee fiee fi lii yinɛ bee yi ŋɛŋ li wi-i, fuki fɛ Ŋwanɛwi bo li kwe-e nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bɔɔŋ bee bɛ kintutu-u bii li wuu laa, “Fi geeŋ fi bɛniiŋ bɛ tiifi bɛnchi kweŋgi le Ɛlaja kɛmi le naa saa bɛ Kinsofu ki Nyɔ tɛ̀ kaachɛ se bɛ le?” ");
INSERT INTO asj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jiso tuu le, “Fi fiɛɛ chɛɛŋ le Ɛlaja kɛmi le naa saa bɛ nachɛ biee bichu. ");
INSERT INTO asj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Se nuuŋ le, ntee beŋ le Ɛlaja bɛɛɔ kituŋ bɛ se mɛɛŋ baa ki kɛɛ kɛ wu kɛ, be tuu be feti fiee fi be kɔŋgisi bɛ wu. Ɛ nɛɛ lɛ si Ŋwanɛwi gii naa ŋɛŋ ŋgɛ li tsaŋ yi bee.” ");
INSERT INTO asj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Si tɛ̀ tee lɛ, bɔɔŋ bee bɛ kintutu biee be kɛɛ le tiitɔɔ nuuŋ kii Jɔɔŋ Nlisulidzɔɔ. ");
INSERT INTO asj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Le Jiso bee bɔɔŋ bee bɛ kintutu-u bɔɔ be fɛsi fɛ kintutu ki bɛniiŋ lɛ tɛ̀ nuuŋ. Wi wumu dza bɛ toŋ núŋ li Jiso-o limfwe, tee li wuu le, ");
INSERT INTO asj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Taa, kɔɔ nshiiŋ li ŋwanɛŋ wu wii kika wuni-i, ŋiŋgɔɔ ŋgɛ ŋge. Ti dzɛti wii fɛtaaŋ, ɛ wu dza tuu we li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mbee mbɛ bɛ wu fɛ bɔɔŋ bo bɛ kintutu-u le be wɔnchɛ wu, be mɔŋ nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Le Jiso woo lɛ tee le, “Hooo! Kiŋgɔkɛ ki lɔɔlɔɔ ki mɛɛŋ ki gɛɛ kɛ shéŋ li Nyɔ-ɔ kɛ kini. Ŋgii nuuŋ tɛɛbeŋ ŋgɛɛŋ mbo buŋ? Ŋgii ŋkaŋ shéŋ bɛ beŋ ŋgɛɛŋ mbo buŋ? Bɛ yɛɛŋ bɛ ŋwaŋ wulu fɛni nɛ nyɛ li mi-i.” ");
INSERT INTO asj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Be bɛ bɛ wu, Jiso waŋ ŋwanɛ kiŋkundi wu tɛ̀ nuuŋ li ŋwaŋ wulu-u bo, biee tɛmi mfwaa mumkpaŋ dududu. ");
INSERT INTO asj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bɔɔŋ bɛ Jiso bɛ kintutu-u dza be gɛɛŋ fɛ wuu lɛjiŋ lɛjiŋ, be bii li wuu laa, “Fi geeŋ fi tɛ bee tɛ mɔŋ le tɛ buu ŋwanɛ kiŋkundi wulu nsiŋ?” ");
INSERT INTO asj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tuu li bee le, “Fi fiɛɛ lɛ kifɛ kimbeenchɛ kinɛ sendɛ. Ntee beŋ chɛɛŋ le, bee le nɛ kɛmɛ kimbeenchɛ ki nuuŋ si shaŋ yi finsoo, nɛ nuuŋ nɛ tee li ŋkumɛ wuni le dza fɛni ɔ gɛɛŋ ɔ leŋ fɛɛ, biee dza, fiee tɛ nuuŋ lu fi nuuŋ fi yaa beŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Se nuuŋ le, ŋwaani wuni ŋwanɛ kiŋkundi nuuŋ wi tɛ buu wu fuki fɛ mwɛ lɛki li Nyɔ-ɔ, jiti biee bijɛ nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Si Jiso bee bɔɔŋ bee bɛ kintutu-u tɛ̀ banchɛ Galilii lɛ, tee li bee le, “Bɛ gii bɛ kabɛ Ŋwanɛwi li tsaŋ yi bɛniiŋ li, ");
INSERT INTO asj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","be wo wu, ke bo jo taa, bo li kwe-e.” Le be woo lɛ, yi bee be ŋge. ");
INSERT INTO asj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jiso bee bɔɔŋ bee bɛ kintutu-u gɛɛŋ be bo Kapanuŋ, bɛniiŋ bɛ tɛ̀ kundi kiŋwaati ki li yih yi muntofi-i bɛ be ŋɛŋ Pita be sɔɔsɛ laa, “Wi wu ntiifɛ wunɛ wuni ti suuti nɛɛ kiŋwaati ki li yih yi muntofi-i ni?” ");
INSERT INTO asj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Beŋ le, “Iiŋ.” Le Pita to fɛkuuŋ, Jiso se shiiki fiee filu fɛkwiiŋ, bii li wuu laa, “Simu, ɔ ŋɛŋ fio le la? Bɛmfɔŋ bɛ laaŋkwiiŋ bani shiiŋ be fii kiŋwaati mɔɔ kichorɛ nuuŋ li ba-aŋ? Be ti shiiŋ be fii nuuŋ li bɔɔŋ bɛ bee mɔɔ li mfoŋ le?” ");
INSERT INTO asj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita tuu le, “Bɛ ti shiiŋ bɛ fii nuuŋ li mfoŋ.” Jiso se tee li wuu le, “Ɛ nuuŋ lɛ kɛ bɔɔŋ bɛɛŋku-u kɛmi yɛ le be ni be suuti kɛ. ");
INSERT INTO asj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Se nuuŋ le, kii tɛ ni tiŋgi-i shéŋ yi bɛniiŋ bɛlu siŋ, gɛnɛ ɔ lɔŋ ŋgwe lɛ libɛ-ɛ, nsuuŋ yi ɔ saa ɔ kɔɔ, ɔ gwiyɛ kimfimɛ ki yi-i, ɔ gii ɔ ŋɛŋ siri wu kwa le, ɔ buu wu ɔ gɛɛŋ ɔ nyɛ li bee le ɔ sooɔ kiŋwaati ki tɛɛbeŋ lu.” ");
INSERT INTO asj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Le ni nuuŋ li mfi wulu-u, bɔɔŋ bɛ Jiso-o bɛ kintutu bɛ be bii li wuu laa, “Ɛ ŋwaani wi wu la wu ko ŋge lɛ bumfɔŋ bu liboo li?” ");
INSERT INTO asj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jiso teeŋ ŋwaŋ wu bwi leeki lɛ bee lɛnti, ");
INSERT INTO asj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tee le, “Ntee beŋ chɛɛŋ le, ɛ nɛ mɛɛŋ ki fiiki kɛ le nɛ to si bɔɔŋ bɛ bwi kɛ, nɛ tɛ naa le nɛ lɛ lɛ bumfɔŋ bu liboo li kɛ. ");
INSERT INTO asj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wi wu shiiki yi yee si ŋwaŋ wuni, ɛ wu wu gii naa nuuŋ wi wu ko lɛ bumfɔŋ bu liboo li. ");
INSERT INTO asj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ɛ wi fi ŋwaŋ si wuni kii mi, kɛ mwɛ fiiɔ tɛ nuuŋ mi.” ");
INSERT INTO asj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Se nuuŋ le ɛ wi fɛ ŋwaŋ mumkpaŋ li kintutu ki bɔɔŋ bɛ bwi bɛ gɛɛ shéŋ li mi-i bani we li bibifi-i, kɛ fi dzɔɔŋ fiɛɛ le wɛɛ wi, bɛ shiiŋɛ jeni chi nɔŋa wu lɛwe, bɛ lɔŋ wu shee seri fɛ kindundu fɛkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ŋgɛ wu nyɔŋa wɛ li bɛniiŋ bɛ li nshɛ yini-i, kifɛ biee bi teeki le bɛniiŋ ni be feti biee bibifi biɛɛ lu. Biee bini kɛmi le bi ni bi nuuŋ lu, se nuuŋ le ŋgɛ wu nyɔŋa wɛ li wi wu bɛɛ bɛ biee bilu. ");
INSERT INTO asj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bɛdɛɛni ɛ kibɛnɛ ko mɔɔ nuuŋ kikaa ko feti le ɔ ni ɔ feti biee bibifi, ɔ sondɛ kibɛnɛ kilu kɛ kikaa kilu ɔ too. Fi dzɔɔŋ le ɔ lɛ li ntsɛ wu kimakɛ bɛ kibɛnɛ kɛ kikaa kiŋkɔsi, yɛki le ɔ kɛmɛ bibɛnu bichu bɛ bikaa bichu bɛ dzɔɔ wɛ bɛ lɔŋ fɛ wi wu kimakɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ɛ lisi cho feti le ɔ ni ɔ feti biee bibifi, ɔ buu lisi chilu ɔ too. Fi dzɔɔŋ le ɔ lɛ lɛ ntsɛ wu kimakɛ-ɛ bɛ lisi chimumkpaŋ, yɛki le ɔ kɛmɛ lii chichi, bɛ lɔŋ wɛ fɛ wi wu kimakɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ŋɛŋ yɛɛŋ le kiiŋ nɛ ni nɛ dzeti wumu li bɔɔŋ bɛ bɛntɛŋ bɛntɛŋ bani fɛkwiiŋ kɛ. Ntee beŋ chɛɛŋ le bɛnchindaa bɛ bee shiiŋ baa lɛ Baa wɛŋ lii mfi kwi liboo, be ŋiŋgi bushi bu Baa wɛŋ mfi kwi be bichi lɛ bɔɔŋ bani-i ");
INSERT INTO asj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ŋwanɛwi tɛ̀ bɛ nuuŋ le soo bɛniiŋ bɛ tɛ̀ saa be la. ");
INSERT INTO asj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nɛ beechi le la? Ɛ wi kɛmi nshɔ́ɔŋ gwii, yimumkpaŋ la li yi-i linti, gii le ki saa kɛ le chinɛ yi gwii mfomɛyoofi ntsɔ mfomɛyoofi yɛɛ li ŋkumɛ-ɛ, le gɛɛŋ gɔɔŋ nshɔɔŋ yimumkpaŋ yi la yilu ni? ");
INSERT INTO asj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ntee beŋ chɛɛŋ le, ɛ wu gɔɔŋ wu ŋɛŋ, woo bujɔŋ bɛ nshɔɔŋ yimumkpaŋ yilu yɛki yi gwii mfomɛyoofi ntsɔ mfomɛyoofi yi mɛɛŋ ki laa kɛ yɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɛ nɛɛ lɛ si Baa wunɛ wu nuuŋ liboo kɔŋgisi yɛ le wi mumkpaŋ li bɔɔŋ bɛ bwi bani-i le la kɛ. ");
INSERT INTO asj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ɛ ŋwaana fɛ fiee fi bifi li wɛ-ɛ, ɔ gɛɛŋ ɔ ŋɛŋ wu ɔ doonchɛ bubiɛɛ bwee li wuu nɛɛ wu beŋ bɛfɛ. Ɛ wu woo fiee fiɔ tee, kɛ ɔ kaarɔɔ ɔ tuu ŋwaana li wɛ-ɛ bwiŋ. ");
INSERT INTO asj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɛ mɛɛŋ ki woo kɛ fiee fiɔ tee kɛ, ɔ dzɔ wi mumkpaŋ kɛ bɛfɛ nɛɛ be kaari nɛ gɛɛŋ fɛ wuu, le n'yɔru kwikwi kɛmɛ bɛniiŋ bɛfɛ kɛ bɛtɛɛtu bɛ lemi lɛ nsa wulu-u lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ɛ nɛ gɛɛŋ wu faaŋ le wuki yɛ fiee fi nɛ tiiti kɛ, ɔ se dzɔ dɛɛni ɔ gɛɛŋ bɛ fi li kintaashɛ ki bɛniiŋ bɛ kimbeenchɛ-ɛ. Ɛ wu tuu wu faaŋ le wuki yɛ li kintaashɛ ki bɛniiŋ bɛ kimbeenchɛ-ɛ kɛ, ɔ dzɔ wu si wi wu ti kii yɛ Nyɔ kɛ, kɛ si wi wu kundi kiŋwaati. ");
INSERT INTO asj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ntee beŋ chɛɛŋ le fiee fi nɛ gii nɛ kaŋ laaŋkwiiŋ fiɛɛ, ɛ bɛ tɛ̀ kaŋ liboo kituŋ, fiee fi nɛ gii nɛ fanchɛ laaŋkwiiŋ fiɛɛ, ɛ bɛ tɛ̀ fanchɛ liboo kituŋ. ");
INSERT INTO asj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nse ntuuɔ ntiiti li be-eŋ chɛɛŋ le, ɛ bɛniiŋ bɛfɛ lɛ be-eŋ lɛnti beŋ li fiee li laaŋkwiiŋ, be lɛkɛ li Nyɔ-ɔ, kɛ Baa wɛŋ wu nuuŋ liboo gii fɛ fi li bee. ");
INSERT INTO asj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nɛ ni nɛ kii le, fɛ bɛniiŋ bɛfɛ kɛ bɛtɛɛtu taashɛ li bukooŋ bweŋ, kɛ mi ŋ'we li bee linti.” ");
INSERT INTO asj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita kiiŋgi bii li Jiso laa, “Taa, ɛ kiŋga kimɛ ki ŋwaanɛŋ nuuŋ fɛ biee bibifi li mi-i, mfeeki wu? Nuuŋ gɛɛŋ bo si kiŋga mfomɛnyaaŋ ni?” ");
INSERT INTO asj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jiso se tuu li wuu le, “Nnuuŋ ntɛ ntee wɛ le ɛ kiŋga mfomɛnyaaŋ kwaa kɛ. Nuuŋ ɔ feeki kiŋga gwii mfomɛnyaaŋ ntsɔ mfomɛnyaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ɛ nɛɛ lɛ si nuuŋ bɛ maa bumfɔŋ bu liboo bɛ mfɔŋ wumu wu tɛ̀ wɛki le nachɛ bɛ bɛniiŋ bee bɛ nimɛ kii kwa wee wu tɛ̀ kiri li tsaŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Si tɛ̀ bɛchi le ni tɛɛti lɛ, be bɛ bɛ wi wumu wu fiɔɔ ye tɛ nuuŋ bɛnchuki yoofi. ");
INSERT INTO asj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Si yi tɛ̀ yaa wu soŋu lɛ, mfɔŋ wulu se tee le bɛ dzɔɔ wu bee kwɛsi mɔɔ bɔɔŋ mɔɔ biee biee bichu bɛ kabɛ bɛ bɛ kwa wulu bɛ sooŋ fiɔɔ ye lu. ");
INSERT INTO asj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Si mfɔŋ wulu tɛ̀ tee lɛ, wi wulu toŋ núŋ wu limfwe sooŋ bɔ li wuu tee le, ‘Taa, kɔɔ nshiiŋ bɛ mi, ŋgii nsooŋ wɛ fiee fichu.’ ");
INSERT INTO asj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nshiiŋ fɛ te kikoo we chinɛ li wuu daayɛ lɛ fiɔɔ yilu. ");
INSERT INTO asj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Se nuuŋ le, wi wɛ kibɛɛ bo le ni giiŋgi, gɛɛŋ chiiŋ wi wumu wu bee be tɛ̀ nindi li mfɔŋ wɛ-ɛ, ɛ tɛ̀ gii kɛmi wu fiɔɔ babi wu kwa mumkpaŋ. Biee cha wu fɛ we tee le, ‘Soŋɛ fiɔɔ ya.’ ");
INSERT INTO asj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wi wu nimɛ wulu se toŋ tɛ núŋ wu limfwe, lɛkɛ wu tee le, ‘Kɔɔ nshiiŋ bɛ mi, ŋgii nsooŋ fiɔɔ ya.’ ");
INSERT INTO asj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Faaŋ, dzɔ wu gɛɛŋ bɛŋɛ wu li yih yi ncha-a le ni nuuŋ lu nsiiŋ fɛ wu sooŋ fiɔɔ ye. ");
INSERT INTO asj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bɛniiŋ bamu bɛ bee be tɛ̀ nindi ŋɛŋ fiee fi ka, fi fieeŋgi be ŋge. Be gɛɛŋ be tee fiee fichu fi bee fi ka li mfɔŋ wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mfɔŋ sɔɔmi wu, tee li wuu le, ‘Ɛ wɛ wi wu bifi. Mbee ndaayɛ lɛ ya fiɔɔ li chichi kifɛ ɔ bee ɔ sooŋ bɔ li mi-i. ");
INSERT INTO asj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bee nuuŋ ɔ kɔɔ tɛ nshiiŋ bɛ wi wulu nɛɛ si mbee ŋkɔɔ nshiiŋ bɛ wɛ tɛ’ ");
INSERT INTO asj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Shéŋ tɔnyɛ mfɔŋ, nyɛ wu le bɛ fa wu li yih yi ncha-a, bɛ ni bɛ ŋ'wɛki bɛ wu gɛɛŋ bo fɛ wu naa wu sooŋ fiɔɔ ye chichi. ");
INSERT INTO asj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ɛ nɛɛ lɛ si Baa wɛŋ wu nuuŋ liboo gii fɛ bɛ beŋ bɛchu, fɛ wi mɛɛŋ ki feeki kɛ bɛ shéŋ yee chichi li fiee fi bifi-i fi ŋwaani tuu fɛ li wuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Le Jiso tee biee bini mɛɛshi, dza lɛ kimbɛ ki kwɛɛŋ wu Galilii, lenchi gɛɛŋ Judiya liwiŋ li kimbɛ ki Dzɔɔ yi Joodaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Le gɛɛŋ lɛ, kintutu ki bɛniiŋ lɛ banchɛ ki biki wu, wɔnchɛ be bɛchu bɛ tɛ̀ gendi fe. ");
INSERT INTO asj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bɛfarasii dza be bɛ lɛ wuu le be mɔnchɛ wu, be bii li wuu laa, “Nchi beenchi le wi nuuŋ kooŋ bɛ kwɛsi kii fiee fimu, mɔɔ nuuŋ fi la le ni?” ");
INSERT INTO asj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jiso tuu li bee le, “Nɛ mɛɛŋ baa saa ki teeŋ kɛ fiee fi bɛ tɛ̀ tsɛɛ le, ‘Fɛ mbɛɛchɛ, wi wu tɛ̀ tɔŋ bɛniiŋ tɛ̀ tɔŋ le be ni be nuuŋ nɛɛ nyuŋ bee kwɛɛŋ ni?’ ");
INSERT INTO asj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tɛ̀ tɔŋ be, tee le, ‘Ɛ kii fini fi nyuŋ gii naa shɛ tee bee ni, taashɛ bee kwɛsi, be bɛfɛ se to wi mumkpaŋ.’ ");
INSERT INTO asj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bɛdɛɛni, be mɛɛŋ yɛ bɛniiŋ bɛfɛ kɛ, be to baa wi mumkpaŋ. Fi se fiɛɛ le, fiee fi Nyɔ taashɛ, kiiŋ wi ni mɔŋ ŋgatinɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bɛniiŋ bɛlu se tuu be bii li Jiso laa, “Se nuuŋ kii la fi Mɔɔsɛ tɛ̀ tee le wi nuuŋ tsɛɛ kiŋwaati nyɛ li kwɛsi ki doonchi le wu kooŋɔ bɛ wu, se kooŋ wu le?” ");
INSERT INTO asj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jiso tuu le, “Fi tɛ̀ nuuŋ lɛ kii bikoo binɛ bi tɛɛmɛ bi Mɔɔsɛ tɛ̀ gɛɛ le wi nuuŋ kooŋ bɛ kwɛsi. Se nuuŋ le, ɛ lɛɛ si fi tɛ̀ nuuŋ lɛ fɛmbɛɛchɛ-ɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ntiitɔɔ fieŋ li be-eŋ le, ɛ wi kooŋ bɛ kwɛsi nuuŋ yɛ kii le wu kɔɔ ɔ kwɛɛŋ wulu bɛ nyuŋ wumu kɛ, ɛ wu dzɔ kwɛɛŋ wumu, kɛ wu giŋɔ bɛ kwɛɛ wi.” ");
INSERT INTO asj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Le bɔɔŋ bɛ Jiso bɛ kintutu-u woo fini, be tee li wuu le, “Ɛ fini nuuŋ kii nyuŋ bee kwɛɛŋ lɛ, kɛ fi dzɔɔŋ le wi ba fi mwɛɛ kwerɛ, tɛ dzɔ kwɛɛŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jiso se tee li bee le, “Se nuuŋ le ɛ wi kwikwi wu nuuŋ beŋ fini fiee kɛ. Ɛ nɛɛ bɛniiŋ bɛ Nyɔ fɛ le be beŋ kwaa. ");
INSERT INTO asj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nɛ ni nɛ kii le bɛniiŋ bamu baa lu bɛ kɛmi yɛ mbeechɛ kii kwɛɛŋ kɛ, fi fiɛɛ si bɛ tɛ̀ biɛ be be nuuŋ. Bamu se baa lɛ, nuuŋ bɛniiŋ bɛ fɛ be bɔ le be ni be nuuŋ lɛ. Bamu baa tɛ fi bee lɛ, nuuŋ be bɛ fɛ bɛ yi yi bee le be ni be nuuŋ lɛ, kii bumfɔŋ bu liboo. Wi wu nuuŋ beŋ fini mwɛ beŋ.” ");
INSERT INTO asj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bɛniiŋ tɛ̀ dza be bɛɛ bɛ bɔɔŋ lɛ Jiso-o le koŋ li bee, bɔɔŋ bee bɛ kintutu-u wami be. ");
INSERT INTO asj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jiso se tee fiee le, “Gɛɛ yɛɛŋ bɔɔŋ bɛlu ni be bɛɛ lɛ mi-i. Nɛ loosɛ kɛ be kɛ, kifɛ bumfɔŋ bu liboo bwɛɛ li bɛniiŋ si bani-i.” ");
INSERT INTO asj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Le tee lɛ, tiiŋ mwɛ li bee, dza giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fi se ka le wumu tɛ̀ dza bɛ lɛ Jiso-o, bii li wuu laa, “Wi wu ntiifɛ, fiee fi dzeeŋ fi nnuuŋ mfɛ nse ŋkɛmɛ ntsɛ wu kimakɛ nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jiso bii li wuu laa, “Ɔ biiti mi kii fiee fi dzeeŋ kii la? Wi wu dzeeŋ wɛ lu mumkpaŋ kwaa. Ɔɔ wɛki le ɔ naa ɔ kɛmɛ ntsɛ wu kimakɛ, ɔ kiri bɛnchi bɛ Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wi wulu se bii li Jiso laa, “Bɛnchi bɛ Nyɔ-ɔ nuuŋ bɛ la?” Jiso tuu li wuu le, “Ɔ wo kɛ wi kɛ, ɔ giŋ kɛ bɛ kwɛɛ wi kɛ, ɔ yi kɛ biee kɛ, ɔ leŋ kɛ lɛ nsa wu binsɛɛ lɛ lɛjiŋ kɛ, ");
INSERT INTO asj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɔ guundi chaa bee na, mɔɔ le, ɔ ni ɔ kɔŋgisi ŋwaana siɔ kɔŋgisi yi ya.” ");
INSERT INTO asj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sɔɔnɛ wi wulu tuu tee li wuu le, “Ntɛ̀ ŋkiri bɛnchi bani bɛchu. Ɛ la fi se shɛ?” ");
INSERT INTO asj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jiso tuu li wuu le, “Ɔɔ wɛki le ɔ ni ɔ nuuŋ wi wu dzeeŋ, ɔ gɛɛŋ ɔ kabɛ biee bi ɔ kɛmi bichu, ɔ gachɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ, ɔ se kɛmɛ bulofu liboo. Ɔɔ fɛ lɛ ɔ se bɛ ɔ ni ɔ biki mi.” ");
INSERT INTO asj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Le sɔɔnɛ wi wulu woo lɛ, dza giiŋgi nshiiŋ nshiiŋ, kifɛ tɛ̀ gii kɛmi kwa ŋge. ");
INSERT INTO asj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jiso se tuu tee li bɔɔŋ bee bɛ kintutu-u le, “Ntee beŋ chɛɛŋ le, fi tɛɛmi fɛ wi wu kwa nuuŋ lɛ li bumfɔŋ bu liboo li. ");
INSERT INTO asj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ntuu ntee beŋ tɛ le, fi nuuŋ tsɛkɛ fɛ kamɛɛ nuuŋ lɛ lɛ fiooŋ yi nsara, yɛki fɛ wi wu kwa nuuŋ lɛ li bumfɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Le bɔɔŋ bɛ Jiso bɛ kintutu-u woo fini, wa tɛ be ŋge. Be bii laa, “Ɛ fi nuuŋ lɛ, ɛ noo wu se gii bo lu?” ");
INSERT INTO asj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jiso bichɛ be ni, tee li bee le, “Fi tɛɛmi nuuŋ bɛ wiwoŋ, bɛ Nyɔ fiee nuuŋ yɛ lu fi nuuŋ fi yaa yi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita tee li wuu le, “Bichɛ ɔ ŋɛŋ, tɛ shɛ baa biee bichu tɛ biki wɛ. Tɛ gii tɛ kɛmɛ la?” ");
INSERT INTO asj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jiso tee li bee le, “Ntee beŋ chɛɛŋ le, mfi wu Ŋwanɛwi gii naa shee li kabara we wu bunɔŋa, li kwɛɛŋ wu fwɛ-ɛŋ, beŋ bani bɛ biki mi, nɛ gii nɛ naa nɛ shee tɛ li bɛkabara yoofi ntsɔ bɛfɛ, nɛ ni nɛ sɛki bini bi Isɛlɛɛ bi yoofi ntsɔ bɛfɛɛtu biɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wi kwi wu chinɛ la we, mɔɔ bɛŋwaani, bɛ dzɛ́mi yee, mɔɔ nuuŋ tee, mɔɔ nuuŋ ni, mɔɔ nuuŋ bɔɔŋ bee, kɛ yɛ́h yee, kii mi, gii kɛmɛ bɛniiŋ bɛ biee kiŋga gwii yɛki si tɛ̀ saa kɛmi. Se kɛmɛ tɛ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Se nuuŋ le, bɛniiŋ ŋge bɛ nuuŋ limfwe dɛɛni gii be nuuŋ lɛjiŋ, bɛ ŋge bɛ nuuŋ lɛjiŋ dɛɛni to limfwe.” ");
INSERT INTO asj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jiso tuu tee le, “Bumfɔŋ bu liboo bwɛɛ si te la wumu wu tɛ̀ dza taantaaŋ le gɛɛŋ dzɔɔ bɛniiŋ bɛ nimɛ-ɛ gɛɛ li wɛ wee li. ");
INSERT INTO asj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Si tɛ̀ gɛɛŋ ŋɛŋ be lɛ, bee be nachɛ le gii sooŋ be nchuki nchuki li jobɛ-ɛ. Se tuumi be, be gɛɛŋ be nindi li wuu wɛ. ");
INSERT INTO asj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Le ni nuuŋ si jobɛ bikaa mfomɛyoofi lɛ, bo gɛɛŋ ŋɛŋ bɛniiŋ bamu si be lemi fɛ waŋ li yee li. ");
INSERT INTO asj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tee li bee le, ‘Gɛnɛ yɛɛŋ tɛ nɛ niŋ li mi-i wɛ, ŋgii nsooŋ beŋ fiee fi kɔchɛ.’ Be biee be gɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Le tuu bo nɛɛ si fɛnshaaŋ tsoo, fɛ nɛɛ lɛ, le gɛɛŋ bo nɛɛ tɛ si jobɛ bikaa bitɛɛtu lɛ, ka tuu dzɔ bɛniiŋ bɛ nimɛ-ɛ bamu. ");
INSERT INTO asj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Le tuu ni nuuŋ si jobɛ bikaa bitiinu lɛ fɛmfo-o lɛ, ka bo gɛɛŋ ŋɛŋ bɛniiŋ bamu be ŋgɛɛshi fɛ waŋ mfɛru fiee nsiŋ. Bii li bee laa, ‘Ɛ la fi nɛ bɛɛ nɛ shiiti nɛ ŋgɛɛshi fɛni jobɛ chichu li yee li ni?’ ");
INSERT INTO asj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Be tuu le, ‘kifɛ wi mɛɛŋɔ ki dzɔ kɛ bee li nimɛ-ɛ kɛ.’ Se tee li bee le, ‘Gɛnɛ yɛɛŋ tɛ nɛ ni nɛ nindi li mi-i wɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Le ni nuuŋ lɛ fɛmfo-o, te wɛ wulu bɛ tee li te kikoo wu bɛniiŋ bɛ nimɛ-ɛ wɛ le teeŋ bɛniiŋ bɛ nimɛ-ɛ baa, nsooŋ be, bɛchi nsomfu nuuŋ bɛniiŋ bɛ tɛ̀ dzɔ lɛjiŋ, gɛɛŋ mɛɛshi bɛ bɛ ŋkosi. ");
INSERT INTO asj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Se bɛchi suundi be. Bɛniiŋ bɛ tɛ̀ dzɔ li nimɛ-ɛ jobɛ bikaa bitiinu bɛ, sooŋ be nchuki nchuki. ");
INSERT INTO asj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bɛniiŋ bɛ tɛ̀ saa dzɔ baa tɛ̀ beechi le gii sooŋ be yaa bamu baa. Se nuuŋ le, tɛ̀ tuu sooŋ nɛɛ be nchuki nchuki. ");
INSERT INTO asj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Le be fi kinsomfu kibee, be bɛchi be ŋunyi te la wɛ, ");
INSERT INTO asj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","be tiiti le, ‘Bɛniiŋ bani ɔ bee ɔ dzɔ be lɛjiŋ be niŋ baa kikaa ki mfi kimumkpaŋ kwaa, ɔ se tuu ɔ sooŋ tɛɛ be yɛɛŋ, nuuŋ bee tɛ be tɛ shi tɛ fieŋgi bɛ nimɛ jobɛ kimbiri, wiiŋ bɛndi bee fɛ fa.’ ");
INSERT INTO asj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te wɛ wulu tuu li wi wu be wumu le, ‘Sinɛŋ, mɛɛŋɔ mfɛ kɛ bubiɛɛ li wɛ-ɛ kɛ. Tɛ be tɛ nachɛ nɛɛ nimɛ chini li nchuki-i ni? ");
INSERT INTO asj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dzɔɔ kinsomfu ko ɔ ni ɔ giiŋgi. Ɛ mi wu ŋkɔɔŋgi le nsooŋ wi wu lɛjiŋ yɛɛŋ si mi nsooŋ wɛ. ");
INSERT INTO asj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ŋkɛmi nɛɛ buŋga bu fɛrɛ fiee fi ŋkɔŋgisi bɛ fiee fi nuuŋ nɛɛ fieŋ ni? Mɔɔ ɔ feti bukaaŋ kifɛ mi ŋgwiyɔɔ tsáŋ yɛŋ li bɛniiŋ li le?’” ");
INSERT INTO asj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Si Jiso tɛ̀ tee lɛ, biee mɛɛshi le, “Ɛ lɛ si bɛniiŋ bɛ nuuŋ lɛjiŋ dɛɛni gii be to limfwe, bɛ nuuŋ limfwe se to bɛ lɛjiŋ.” ");
INSERT INTO asj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Le Jiso ni yɛki Jɛrosalɛŋ le bee bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa bo lɛ dze, teeŋ be bee be cheekiyi, se tee li bee le, ");
INSERT INTO asj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yikɛ yɛɛŋ nɛ woo, tɛɛbeŋ yɛki baa tɛ giiŋgi Jɛrosalɛŋ bɛ gii bɛ gɛɛŋ bɛ nyɛ Ŋwanɛwi li tsaŋ yi bɛte muntofi-i bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ, bɛ saa wu bɛ sondɛ le be wo wu, ");
INSERT INTO asj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bɛ biee bɛ nyɛ wu li tsaŋ yi bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛɛ, be ni be kwɛrisi wu, be fiaamfiɛ wu bɛ muŋwaaŋ, bɛ taaŋ wu li kintaaŋ li kwi, ke bo jo taa Nyɔ kaari yi buu wu li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ni bɔɔŋ bɛ Dzɛbɛdii tɛ̀ dza bɛ lɛ Jiso bee bɔɔŋ bee, toŋ núŋ wu limfwe le lɛkɛ fiee. ");
INSERT INTO asj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jiso bii li wuu laa, “Ɔ wɛki nuuŋ la?” Se tee li wuu le, “Kaachɛ le ke mfi wu ɔ sɛki bumfɔŋ bwo, bɔɔŋ beŋ bɛ bɛfɛ bani shee li wɛ-ɛ lichiŋ, wumu lɛ kibɛnɛ ko ki kigɔŋɛ-ɛ, wumu lɛ ki kimɛsɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Se nuuŋ le, Jiso tuu li bɔɔŋ bɛlu le, “Nɛ kii yɛ fiee fi nɛ biiti kɛ. Nuuŋ nɛ woŋ fika fi ŋgɛ-ɛ fi ŋgii ŋ'woŋ fini ni?” Be tuu le, “Tɛ nuuŋ tɛ woŋ.” ");
INSERT INTO asj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tee li bee le, “Chɛɛŋ nɛ gii nɛ woŋ fika fieŋ. Se nuuŋ le nshewu lɛ kibɛnɛ keŋ ki kigɔŋɛ-ɛ bɛ ki kimɛsɛ nuuŋ yɛ kintsii keŋ le nyɛ li be-eŋ kɛ. Bintsii bilu nuuŋ li bɛniiŋ bɛ Baa wɛŋ nachɛ wu gɛɛ li bee.” ");
INSERT INTO asj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Le kiŋkɛ ki bɔɔŋ bɛ kintutu-u bɛ Jiso bɛ yoofi baa woo kii fiee filu lɛ, shéŋ tɔnyɛ be bɛ bɔɔŋ bɛ bɛfɛ bɛlu. ");
INSERT INTO asj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jiso se teeŋ be bɛchu, be bɛ tee li bee le, “Nɛ kii yɛ le bɛniiŋ bɛ sɛki bitoŋ ti shiiti li bɛniiŋ bɛ bee, bɛniiŋ bɛ nɔŋa bɛ nɔŋa bɛ bee doonchi buŋga lɛ bee lɛ we ni? ");
INSERT INTO asj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dɛɛni fiee fini kɛmi yɛ le fi nuuŋ lɛ be-eŋ lɛnti kɛ. Wi wu wɛki le ni nuuŋ wi wu nyɔŋa li be-eŋ linti kɛmɔɔ le ni nuuŋ wi wu nindi li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wi wu wɛki le ni nuuŋ wi wu limfwe li be-eŋ linti, kɛ mwɛ kɛmɔɔ le ni nuuŋ mfwa wunɛ. ");
INSERT INTO asj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Fi fiɛɛ yɛɛŋ le, Ŋwanɛwi tɛ̀ mɛɛŋ ki bɛ kɛ le bɛniiŋ ni be nindi li wuu kɛ. Tɛ̀ bɛ nuuŋ le niŋ li bɛniiŋ li, nyɛ ntsɛ we le ya bɛniiŋ ŋge li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Le Jiso bee bɔɔŋ bee bɛ kintutu-u gɛɛŋ be ni be kɛti Jɛriko, kintutu ki bɛniiŋ lɛ banchɛ ki biki wu lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fi se ka le binyɛɛ bimu bifɛ, nuuŋ buniŋ bɛ tɛ̀ bɛɛ be shiiti li ŋgemɛ yi dze-e, nuuŋ ɛ be woo le Jiso yɛkɔɔ, be bɛchi be dzɛŋgi be tiiti le, “Taa, Ŋwanɛ kini ki Mfɔŋ Daafi-i, kɔɔ nshiiŋ bɛ bee.” ");
INSERT INTO asj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kintutu ki bɛniiŋ lɛ kɛɛ se wami be ki tiiti le shee yɛɛŋ nshiiŋ. Se nuuŋ le be tuu be wɛndi be giiŋgi bu limfwe le, “Taa, Ŋwanɛ kini ki Mfɔŋ Daafi kɔɔ nshiiŋ bɛ bee.” ");
INSERT INTO asj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jiso biee leŋ, teeŋ be, be bɛ, bii li bee laa, “Nɛ wɛki le mfɛ la li be-eŋ?” ");
INSERT INTO asj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Be tuu le, “Taa, fɛrɛ le lii yisɛŋ gwiyɛ.” ");
INSERT INTO asj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nshiiŋ kɔɔ Jiso, koŋ li lii yi bee. Mfwaa mumkpaŋ be ŋɛŋ biee, be dza be biki Jiso. ");
INSERT INTO asj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Le Jiso bee bɔɔŋ bee bɛ kintutu-u ni be fɛɛshi Jɛrosalɛŋ ɛ be bo li kitoŋ ki Bɛtfaj ki nuuŋ li Ŋkumɛ wu Biti bi Oli-if, biee toŋ bɔɔŋ bee bɛ kintutu bamu bɛfɛ, ");
INSERT INTO asj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","tee li bee le, “Gɛnɛ yɛɛŋ li kitoŋ ki limfwe kɛɛ. Ɛ nɛ gɛɛŋ, nɛ ŋɛŋ ni sɔmbwaa ɛ bɛ gerɛ, ŋwani nuuŋ li wuu lichiŋ, nɛ fanchɛ, nɛ bɛ mi bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ɛ wi bii fiee li be-eŋ, nɛ tuu li wuu le Te Kikoo wɛkɔɔ wu, kɛ gii chinɛ le nɛ bɛ bɛ wu.” ");
INSERT INTO asj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Fini tɛ̀ ka lɛ le fi bɛ fi kɔchɛ si ntomfɔŋ wu Nyɔ wumu tɛ̀ tee, tiiti le, ");
INSERT INTO asj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tee li kitoŋ ki Sayɔŋ le. ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, Mfɔŋ wunɛ bɛɛɔ lɛ be-eŋ. Wu shiikɔɔ yi yee fɛkwiiŋ, wu beeŋɔ lɛ sɔmbwaa li lɛwe, nuuŋ ŋwanɛ sɔmbwaa wu mɛɛŋ bwi.’” ");
INSERT INTO asj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Le bɔɔŋ bɛ Jiso bɛ kintutu-u baa gɛɛŋ, be fɛ nɛɛ si tɛ tee. ");
INSERT INTO asj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Be se bɛ bɛ sɔmbwaa wulu mɔɔ ŋwaŋ, be lɔŋ ndú yibe li bee liwe, Jiso beeŋ shee lɛ wumu, giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kintutu ki bɛniiŋ lɛ kinɔŋa tɛ̀ gikisi ndú yibe lɛ dze, bamu bonyi yɛŋɛ yi biti be gikisi. ");
INSERT INTO asj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kintutu ki tɛ̀ giiŋgi Jiso limfwe bɛ ki tɛ̀ biki lɛjiŋ kɛɛ tɛ̀ wuuyi le, “Yiyi-i yiyi-i yiyi-i, bunɔŋa bwɛɛ bu ŋwanɛ kini ki Mfɔŋ Daafi looo! Nyɔ tiiŋ yɛ mwɛ li wi wu bɛɛ li bukooŋ bu Taa lɛ looo! Yiyi-i yiyi-i yiyi-i, bunɔŋa bwɛɛ bu Nyɔ yi nuuŋ liboo li looo!” ");
INSERT INTO asj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Le Jiso gɛɛŋ fɛsi Jɛrosalɛŋ kitoŋ kilu kichu sɛɛsɛ. Bɛniiŋ tɛki wa, be biiti laa, “Wuni nuuŋ noo le?” ");
INSERT INTO asj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Se kintutu kilu tuu ki tiiti le, “Ɛ ntomfɔŋ wu Nyɔ wu Jiso wu dza li kitoŋ ki Nasarɛ, li kwɛɛŋ wu Galilii.” ");
INSERT INTO asj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiso gɛɛŋ lɛ fɛ yih yi muntofi yi Nyɔ-ɔ, kooŋ bɛ bɛniiŋ bɛchu bɛ tɛ̀ kabini biee mɔɔ bɛ tɛ̀ guti biee lu, bachɛ bidaŋ bi bɛniiŋ bɛ tɛ̀ fikisi kwa-a, bɛ bidaŋ bi bɛniiŋ bɛ tɛ̀ kabini bibimu. ");
INSERT INTO asj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tɛ kuŋgi be, tiiti le, “Fi fiɛɛ ɛ bɛ tɛ̀ tsɛɛ, Nyɔ tiiti le, ‘Bɛ gii bɛ ni bɛ teenyi yih yɛɛŋ le yih yi nlɛkɛ li Nyɔ-ɔ.’ Nɛ fiiki baa yi to nuuŋ ntuuŋ wu bɛyi.” ");
INSERT INTO asj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Le Jiso ni nuuŋ fɛ yih yi muntofi yilu, binyɛɛ bɛ biŋkɛrɛ bɛ lɛ wuu wɔnchɛ be. ");
INSERT INTO asj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Se nuuŋ le, le bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ doonchi bɛnchi bɛ Nyɔ-ɔ ŋɛŋ biee bi bimfimu wondini, bɛ si bɔɔŋ bɛ niiŋ niiŋ tɛ̀ wuuyi fɛ yih yi muntofi, be tiiti le, “Eeeee, kinɔŋa nuuŋ ki ŋwanɛ kini ki Mfɔŋ Daafi leee,” fi tɔŋ be ŋge. ");
INSERT INTO asj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Be wamɛ Jiso laa, “Ɔ wuki yɛ fiee fi bɔɔŋ bani tiiti ni?” Tuu li bee le, “Iiŋ, ŋ'wukɔɔ. Fi fiɛɛ le nɛ mɛɛŋ baa saa ki teeŋ kɛ fiee fi bɛ tsɛɛ le, ‘Nyɔ gɛɛ yɛ jɛ yi buti li bimfimu bi bɔɔŋ bɛ bwi-i, mɔɔ li bimfimu bi bɔɔŋ bɛ mɛɛŋ be yɛɛndi mbeeŋ yi bɛ ni bɛ bee le be ni be piɛti wu lu?’” ");
INSERT INTO asj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jiso dza shɛ be, bo li kitoŋ kilu, gɛɛŋ li kitoŋ ki Bɛtani-i, tsi fe. ");
INSERT INTO asj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Le ni nuuŋ fɛŋwɛɛŋ taantaaŋ, si Jiso tɛ̀ kaarisi tuu lijiŋ lɛ kitoŋ ki Jɛrosalɛŋ dzeeŋ tɛ̀ wuu wu. ");
INSERT INTO asj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ŋɛŋ kiti kimu li dzee lichiŋ ki bɛ ti jii muntaaŋ mulu, gɛɛŋ fe, bɛdɛɛni ti mɛɛŋ ki ŋɛŋ kɛ fiee li ki-i kɛ, ŋɛŋ nuuŋ bibɛ kwaa li ki-i, tsoŋ kiti kilu, chini li ki-i le kiiŋ fintaaŋ ni naa tuu fi woŋ li wɛ-ɛ kɛ! Mfwaa mumkpaŋ, kiti kilu biee ki wɔɔbɛ. ");
INSERT INTO asj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Le bɔɔŋ bɛ kintutu bɛ Jiso ŋɛŋ lɛ, bimfimu wondɛ be. Be se ta maa laa, “Kiti kilu geeŋ ki wɔɔbɛ mfwaa mumkpaŋ ni le?” ");
INSERT INTO asj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jiso tuu li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le, ɛ nɛ gɛɛ shéŋ li Nyɔ-ɔ, mɛŋinɛ siŋ, nɛ tɛ̀ fɛ fiee fi mi mfɛ bɛ kiti kini kwaa kɛ. Ɛ nɛ tee li ŋkumɛ wuni le, ‘Dzatsɛ fɛni ɔ gɛɛŋ ɔ we li dzɔɔ yi nyɔŋa,’ fi ka lɛ. ");
INSERT INTO asj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mɔɔ nuuŋ la fi nɛ lɛki li Nyɔ-ɔ le, kɛ nɛ gii nɛ kɛmɛ, laa nɛ gɛɛ baa shéŋ li Nyɔ-ɔ kwaa le.” ");
INSERT INTO asj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiso tɛ̀ kaari lɛ li yih yi muntofi-i, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ wu Bɛjuu bɛ be ŋɛŋ si tiifi bɛniiŋ, be bii li wu laa, “Ɔ dzɔ buŋga bu ɔ feti biee bini fɛŋ? Ɛ noo wu nyɛ buŋga bulu li wɛ-ɛ?” ");
INSERT INTO asj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jiso tuu li bee le, “Ŋgii mbii tɛ fiee li be-eŋ, ɛ nɛ tuu, nse ntee beŋ wi wu nyɛ buŋga li mi-i le ni mfeti biee bini. ");
INSERT INTO asj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ, buŋga bulu buti nuuŋ fɛŋ? Ɛ Nyɔ yi tɛ̀ nyɛ wu liboo, mɔɔ wiwoŋ le?” Le bii lɛ, be tɛchɛ bebe, be tiiti le, “Ɛ tɛ tuu le ɛ Nyɔ yi tɛ̀ nyɛ, tuu bii li bee li laa, fi ge la fi tɛ̀ ti mɛɛŋ ki beŋ kɛ li Jɔɔŋ li kɛ le? ");
INSERT INTO asj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Se nuuŋ le, ɛ tɛ tuu le, ‘Ɛ wiwoŋ wu tɛ̀ nyɛ,’ kɛ tɛ chɛndi baa kintutu ki bɛniiŋ lɛ, si be bɛchu beenchi baa le Jɔɔŋ tɛ̀ nuuŋ ntomfɔŋ wu Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nɛɛ lɛ, be se tuu li Jiso le, “Tɛ kii yɛ kɛ.” Jiso se tuu tee li be le, “Kɛ nuuŋ ntɛ ntee tɛ beŋ wi wu nyɛ mi buŋga le ni mfeti biee bini kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jiso gɛɛŋ limfwe bii laa, “Nɛ beechi le la kii fini? Wi wumu tɛ̀ kɛmi bɔɔŋ bee bɛ buniŋ bɛfɛ. Dza gɛɛŋ fɛ ŋwaŋ wu kaaŋ li, tee li wuu le, ‘Ŋwanɛŋ, gɛnɛ ɔ shi ɔ ni ɔ nindi liwɛ bɛŋ.’ ");
INSERT INTO asj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ŋwaŋ wulu tuu li wuu le, ‘Nnuuŋ ntɛ ŋgɛɛŋ kɛ.’ Se nuuŋ le dza tuu beechɛ li shéŋ yee li gɛɛŋ liwɛ lɔɔ. ");
INSERT INTO asj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wi wulu tuu dza gɛɛŋ fɛ ŋwani wu lɛjiŋ tee nɛɛ fiee fi bee tee li wu kaaŋ wɛɛ, tuu li wuu le ‘Ŋgii ŋgɛɛŋ taa.’ Se nuuŋ le, ba ŋgɛnu nsiŋ ");
INSERT INTO asj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Li bɔɔŋ bɛ bɛfɛ bani linti, ɛ wu la wu tɛ̀ fɛ fiee fi tee tɛ̀ gii kɔŋgisi?” Be tuu le, “Ɛ wu kaaŋ wɛ.” Jiso se tee li bee le, “Ntee beŋ chɛɛŋ le, bɛniiŋ bɛ kundi biŋwaati mɔɔ binjiŋkwiiŋ lii baa lɛ bumfɔŋ bu Nyɔ-ɔ limfwe li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ntiitɔɔ ni kifɛ Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ le doonchɛ dze yi tsaaŋ li be-eŋ, nɛ faaŋ mbeenchɛ li wuu. Se nuuŋ le, bɛniiŋ bɛ kundi kiŋwaati bɛ binjiŋkwiiŋ tɛ̀ beŋ li wuu. Nɛ se tuu nɛ ŋɛŋ si be beŋ lɛ, nɛ faaŋ tɛ mfikisɛ shéŋ yinɛ le nɛ beŋ tɛ li wuu.” ");
INSERT INTO asj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jiso tuu kweeŋ le, “Tuu woo yɛɛŋ ŋgaŋgaa chimu. Wi wumu tɛ̀ niŋ wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu, toŋ mbaŋ kɛnɛ, chiŋ kisɔ ki bɛ gii bɛ ni bɛ kee muntaaŋ mulu bɛ seendi le, mbiiŋ se buti, gwaŋ kikɔ ki wi wu kiichi wɛ wulu, shɛ wɛ wulu li bɛniiŋ li, dza gɛɛŋ li kitoŋ kimu. ");
INSERT INTO asj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mfi wu bɛ ti kee muntaaŋ mulu tɛ̀ bɛ kɔchɛ, toŋ bɛniiŋ bee bɛ nimɛ lɛ bɛniiŋ bɛ tɛ̀ shɛ wɛ li bee baa, le be gɛɛŋ be fi mwee muntaaŋ. ");
INSERT INTO asj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Be gɛɛŋ, bɛniiŋ bɛ tɛ̀ shɛ wɛ li bee baa kɔɔ be, be too wumu, be wo wumu, be tomɛ wumu bɛ ta. ");
INSERT INTO asj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tuu toŋ bɛniiŋ bɛ nimɛ-ɛ bamu be yaŋ be yaa bɛ ŋkosi baa, bɛniiŋ baa tuu be fɛ nɛɛ si be be be fɛ bɛ bɛ ŋkosi baa lɛ. ");
INSERT INTO asj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lɛjiŋ lɛlu, toŋ nuuŋ ŋwani kibɛɛ, beechi le be gii be guuŋ ŋwani wuni. ");
INSERT INTO asj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Se nuuŋ le, le gɛɛŋ, bɛniiŋ bɛlu ŋɛŋ wu, be tee bebe le, ‘Wuni wɛ nuuŋ kinjila ki wi wu wɛ wuni. Bɛ yɛɛŋ tɛ wo wu tɛ ji bishɛyɛ bilu.’ ");
INSERT INTO asj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Be kɔɔ wu be buu wu li wɛ wulu, be wo wu.” ");
INSERT INTO asj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Si Jiso tɛ̀ tee ni, tuu bii laa, “Wi wu wɛ wulu gii ge la bɛ bɛniiŋ bɛlu fɛ wu bɛ?” ");
INSERT INTO asj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Be tuu le, “Gii bɛ mɛɛshi bɛ munyaminɛ mulu mu kwiyɛ, shɛ wɛ wulu li bɛniiŋ bamu bɛ gii be nyɛ wu mwee muntaaŋ mfi wu be kɔ.” ");
INSERT INTO asj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jiso se bii li bee laa, “Nɛ ti mɛɛŋ ki teeŋ kɛ lɛ kiŋwaati ki Nyɔ le, ‘Tɛtɛ chi bɛniiŋ bɛ ŋgwanu-u tɛ̀ faaŋ chɛɛ, chi kaari chɛɛ chi to tɛtɛ chi fɛ boo chi yi ni? Mɔɔ fini nuuŋ mfɛru wu Taa, bɛniiŋ bichi be tɛti maa ni’? ");
INSERT INTO asj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ntusɔɔ ntiiti li be-eŋ le, Nyɔ gii yi fi bumfɔŋ bwee li tsaŋ yinɛ-ɛ, yi nyɛ nuuŋ li bɛniiŋ bɛ gii be gbɛɛŋ be ni be feti si bɛniiŋ bɛ li kwɛɛŋ wɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tɛtɛ chilu chini nuuŋ ɛ chi we li wi-i mwɛ chaafɛ, ɛ wi we li chi-i, mwɛ fwachɛ. ");
INSERT INTO asj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Si Jiso tɛ̀ wa ŋgaŋgaa chilu lɛ, bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ Bɛfarasii woo lɛ, be kɛɛ le wu wa wɛ nuuŋ kii be. ");
INSERT INTO asj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Be dza be wɛki le be kɔɔ wu, se nuuŋ le be kaari be chɛŋ kintutu ki bɛniiŋ lɛ, kifɛ kintutu kilu tɛ kɛmi li Jiso le ni nuuŋ ntomfɔŋ wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiso tɛ̀ yeti li bee lɛ ŋgaŋgaa li, chimu tɛ̀ nuuŋ le ");
INSERT INTO asj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bumfɔŋ bu liboo nuuŋ bɛ maa bu bɛ mfɔŋ wumu wu tɛ̀ nachɛ tsɔnɔ chi bugoo lɛ bu ŋwani wu nyu-uŋ. ");
INSERT INTO asj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Toŋ bɛnchindaa bee le be gɛɛŋ be teeŋ bɛniiŋ bɛ tɛ̀ teeŋ le be bɛ tsɔnɔ chi bugoo lɛ baa le be bɛ. Se nuuŋ le, bɛnchindaa bɛlu gɛɛŋ bɛniiŋ bɛlu faaŋ mbɛ. ");
INSERT INTO asj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tuu toŋ bɛnchindaa bamu tee li bee le, ‘Gɛnɛ yɛɛŋ nɛ ni tiiti li bɛniiŋ bɛ ntuu ntee le be bɛ tsɔnɔ chi bugoo lɛ chini le be yikɛ be woo, le mi mfɛɔ biee bijɛ kituŋ, mi nsɛɔ bintomu bi bɔɔŋ bɛ bɛnaŋ lɛ bi fɔɔŋ. Mi nachɔɔ biee bichu kituŋ, le be bɛ fɛ tsɔnɔ-ɔ.’ ");
INSERT INTO asj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Se nuuŋ le, be gɛɛŋ bɛniiŋ bɛlu nyaami, be dza fibee be giiŋgi. Wi wumu la liwɛ, wi wumu bo waŋ wee. ");
INSERT INTO asj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kiŋkɛ ki bɛniiŋ lɛ kɔɔ bɛnchindaa bɛlu be ŋwɛɛ bɛ be, be wooyɛ be. ");
INSERT INTO asj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Shéŋ tɔnyɛ mfɔŋ wulu, tuumi bɛniiŋ bee bɛ dzi-iŋ, be gɛɛŋ be lɛɛshɛ bɛniiŋ bɛ tɛ̀ wooyɛ bɛnchindaa bee baa dududu, be tɔŋ kitoŋ kibee kilu. ");
INSERT INTO asj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Si tɛ̀ fɛ lɛ, tuu tee li bɛniiŋ bee bɛ nimɛ-ɛ bamu le, ‘Mi mfɛɔ tsɔnɔ chi bugoo lɛ kituŋ. Se nuuŋ le bɛniiŋ bɛ ntuu nteeŋ baa tuu nuuŋ yɛ bɛniiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dɛɛni, gɛnɛ yɛɛŋ lɛ dzé ntasɛ chi, nɛ teeŋ bɛniiŋ bɛchu bɛ nɛ ŋɛŋ, le be bɛ fɛ tsɔnɔ chi bugoo lɛ chini.’ ");
INSERT INTO asj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bɛniiŋ bɛ nimɛ-ɛ bɛlu bo be gɛɛŋ lɛ dze chichi, be konchɛ bɛniiŋ bɛchu bɛ be tɛ̀ ŋɛŋ, bɛniiŋ bɛ dzeeŋ bɛ bɛ bifi be bɛ. Yih yi bugoo yisɛ bɛ bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mfɔŋ dza lɛ li yih yi bugoo yilu-u ŋɛŋ bɛniiŋ bɛ tɛ̀ bɛ fɛ tsɔnɔ chilu-u, ŋɛŋ wi wumu lu mwɛ mɛɛŋ ki lii kɛ ndu yi tsɔnɔ chi bugoo lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bii li wuu laa, ‘Sinɛŋ, ɔ geeŋ ɔ lɛ luuŋ yih ndu yi tsɔnɔ nsiŋ?’ Wi wulu ba nshiiŋ. ");
INSERT INTO asj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bɛdɛɛni, mfɔŋ wulu biee tee li bɛniiŋ bɛ nimɛ-ɛ baa le, ‘Kanɛ yɛɛŋ bibɛnu biee mɔɔ bikaa biee nɛ lɔŋ wu li kijibɛ lɛkuuŋ, fɛ bɛniiŋ dii be jii ŋgesi.’” ");
INSERT INTO asj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Si Jiso tɛ̀ tee lɛ, tee le, “Nɛ kɛɛ le, Nyɔ nuuŋ yi teeŋ bɛniiŋ ŋge, se nuuŋ le, ɛ bɛ niiŋ bɛ yi tsɛki.” ");
INSERT INTO asj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bɛfarasii dza be gɛɛŋ be nachɛ si nuuŋ be fɛ Jiso lɔɔŋgɛ bɛ n'yɔru be se kɔɔ wu. ");
INSERT INTO asj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Be se toŋ bɔɔŋ bɛ bee bɛ kintutu-u mɔɔ kintutu ki bɛniiŋ bɛ Mfɔŋ Hɛrɔ fɛ Jiso. Be gɛɛŋ be tee li wuu le, “Wi wu ntiifɛ tɛ kii nɛɛ le ɔ nuuŋ wi wu chɛɛŋ, ɔ ti tiifi bɛniiŋ lɛ dze yi chɛɛŋ li. Ɔ ti dzeti yɛ le wi wumu nuuŋ chichi kɛ, kifɛ ɔ ti bichi yɛ wi li fiee fi mwɛ nuuŋ lu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dɛɛni, tee bee wa mbeechɛ. Nchi beŋ le tɛ ni tɛ suuti kiŋwaati li Kaisa mfɔŋ wu Lo-om, mɔɔ tɛ soo kɛ le?” ");
INSERT INTO asj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jiso kɛɛ fiee fi be gwenini bɛ fi, biee tee li bee le, “Beŋ bɛniiŋ bɛ nimi-i bani, nɛ teeki mi kii la? ");
INSERT INTO asj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bɛ yɛɛŋ bɛ kwa wu nɛ shiiŋ nɛ suuti kiŋwaati lu wɛ-ɛ ŋɛŋ.” Be bɛ bɛ danali, be nyɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jiso bii li bee laa, “Kikoo kini nuuŋ ki noo lɛ? Bukooŋ buni nuuŋ bu noo lɛ?” ");
INSERT INTO asj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Be tuu le, “Ɛ ki Kaisa, bukooŋ nuuŋ nɛɛ tɛ bwee.” Jiso tuu tee li bee le, “Nɛ nyɛɛ li Kaisa fiee fi nuuŋ fi Kaisa, nɛ nyɛɛ li Nyɔ-ɔ fi nuuŋ fi Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Le be woo lɛ, bimfimu wondɛ be. Be chinɛ li wuu dza giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nɛɛ booyaa, Bɛsadusii tɛ̀ dza be bɛ fɛ Jiso-o. Bɛsadusii nuuŋ kintutu ki bɛniiŋ bɛ tɛ̀ shiiŋ be kweŋgi le bɛniiŋ nuuŋ tɛ naa bo li kwe-e kɛ. Si be tɛ̀ bɛ lɛ, be bii li Jiso-o laa, ");
INSERT INTO asj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Wi wu ntiifɛ, Mɔɔsɛ tɛ̀ tee le, ‘Ɛ wi kwi ŋkɛmɛ ŋwaŋ nsiŋ, kɛ ŋwaani kɛmi le dzɔɔ kwɛsi bee wu biɛ bɔɔŋ li bukooŋ bu ŋku ŋwaani wulu.’ ");
INSERT INTO asj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dɛɛni, bɔɔŋ bɛ wi wumu tɛ̀ tsiiŋ bɛ bee fɛni mfomɛnyaaŋ. Wu kaaŋ tɛ̀ dzɔ kwɛɛŋ, kwi bee wu ŋkɛmɛ ŋwaŋ siŋ, shɛ kwɛsi li ŋwaani wu biki li wuu. ");
INSERT INTO asj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Fi ka nɛɛ tɛ lɛ bɛ wu biki mɔɔ wu tɛ tuu biki, gɛɛŋ bo li wu mfomɛnyaaŋ li be kwi yɛ ŋkɛmɛ ŋwaŋ siŋ. ");
INSERT INTO asj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lɛjiŋ lɛlu, kwɛɛŋ wulu kwi tɛ. ");
INSERT INTO asj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lɛ dɛɛni, si be bɛchu bɛ mfomɛnyaaŋ baa tɛ̀ dzɔ kwɛɛŋ wulu lɛ, gii naa ni nuuŋ mfi wu bɛniiŋ buti li kwe-e, kwɛɛŋ wulu nuuŋ kwɛɛ noo?” ");
INSERT INTO asj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jiso tuu li bee le, “Nɛ chaŋ baa ŋge, kifɛ nɛ kii yɛ fiee fi bɛ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ kɛ. Nɛ ti kii yɛ tɛ buŋga bu Nyɔ-ɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nɛ ni nɛ kii le naa nuuŋ mfi wu bɛniiŋ buti li kwe-e, buniŋ bee bukɛɛŋ tɛ tuu le be ni be feti bugoo kɛ, bɛniiŋ mɛɛŋ yɛ be tuu be ni be nyɛɛ bɔɔŋ li bugoo li kɛ. Be gii naa be ni be nuuŋ nɛɛ si bɛnchindaa bɛ Nyɔ-ɔ liboo. ");
INSERT INTO asj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɛ nuuŋ kii mbochu wu bɛniiŋ gii naa be ni be buti li kwe-e, nɛ tɛ̀ mɛɛŋ ki teeŋ kɛ Kiŋwaati ki Nyɔ-ɔ nɛ woo fiee fi ki tiiti li be-eŋ ni? Nyɔ tɛ̀ tee le, ");
INSERT INTO asj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ɛ mi Nyɔ yi Abrahaŋ bɛ Nyɔ yi Adzi mɔɔ Nyɔ yi Yakɔ.’ Fi nuuŋ le Nyɔ nuuŋ yɛ Nyɔ yi bɛŋku kɛ, yi nuuŋ Nyɔ yi bɛniiŋ bɛ nuuŋ bɛ yoŋ.” ");
INSERT INTO asj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kintutu ki tɛ̀ lemi fe woo ntusu wu Jiso tɛ̀ tuu, wa tɛ̀ be bɛ ntiifɛ we. ");
INSERT INTO asj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Le Bɛfarasii woo le Jiso makɛ wɛ bimfimu bi Bɛsadusii, be banchɛ yi be bɛ fɛ wuu. ");
INSERT INTO asj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wi wumu wu tɛ̀ gbɛŋgi kii bɛnchi bɛ Nyɔ-ɔ, mɔnchɛ wu bɛ mbifu wumu le, ");
INSERT INTO asj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wi ntiifɛ, nchi wu ko wu yaa bɛnchi bɛchu nuuŋ wu la?” ");
INSERT INTO asj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jiso tuu li wuu le, “Nchi wu ko nuuŋ wu tiiti le, ‘Ɔ kɔŋgisi Chaa yi Nyɔ ya bɛ shéŋ ya chi, ɔ nyɛɛ yi ya li yi-i ɔ giki bufii bwo li yi-i buchu.’ ");
INSERT INTO asj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wuni nuuŋ nchi wu limfwe wu ko wu yaa bɛnchi bɛchu. ");
INSERT INTO asj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wu biki se nuuŋ nɛɛ si wɛɛ. Wu nuuŋ le, ‘Ɔ kɔŋgisi ŋwaana siɔ kɔŋgisi yi ya.’ ");
INSERT INTO asj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Biee bichu bi nuuŋ lɛ kiŋwaati ki bɛnchi, mɔɔ bi nuuŋ lɛ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ, bi lemi li bɛnchi bɛ bɛfɛ bani-i.” ");
INSERT INTO asj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Si Bɛfarasii tɛ̀ taashɛ fe lɛ, Jiso dza bii mbifu wumu li bee laa, ");
INSERT INTO asj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nɛ beechi le la kii Kinsofu ki Nyɔ tɛ̀ kaachɛ? Nɛ beechi le ɛ ŋwanɛ noo?” Be tuu li wu le, “Nuuŋ ŋwanɛ kini ki Mfɔŋ Daafi-i.” ");
INSERT INTO asj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jiso se kaari bii li bee laa, “Si nuuŋ ŋwanɛ kini ki Mfɔŋ Daafi-i lɛ, fi geeŋ fi Fiana yi Nyɔ fɛ Mfɔŋ Daafi se teenyi wu le Taa? Daafi tɛ̀ tee le, ");
INSERT INTO asj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Taa Nyɔ tɛ̀ tee li Taa li le shee lɛ kibɛnɛ keŋ ki kigɔŋɛ-ɛ, gɛɛŋ bo mfi wu ŋgii gɛɛ bɛniiŋ bo bɛ mbani-i ɔ tɔmi bikaa bio li bee.’ ");
INSERT INTO asj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ɛ Daafi teenyi wu le Taa, fi geeŋ se tuu ni nuuŋ ŋwani?” ");
INSERT INTO asj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Si Jiso tɛ̀ yɔ lɛ, wi tɛ̀ mɛɛŋ ki kɛmɛ kɛ fiee fi tusɛ li wuu kɛ. Mbɛɛchɛ booyaa, wi ti mɛɛŋ ki tuu kɛ mɔɔ le bii fiee li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jiso dza tee li kintutu ki bɛniiŋ lɛ bɛ bɔɔŋ bee bɛ kintutu-u le, ");
INSERT INTO asj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bɛniiŋ bɛ doonchi bɛnchi mɔɔ Bɛfarasii nuuŋ bɛniiŋ bɛ dzɔ kintindɛ ki Mɔɔsɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Fi se nuuŋ le, nɛ ni nɛ wuki fiee fichu fi bɛ tee li be-eŋ, nɛ feti. Se nuuŋ le, nɛ fɛ kɛ fiee fichu fi be feti kɛ, kifɛ be nuuŋ bɛniiŋ bɛ nimi-i. ");
INSERT INTO asj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Be dzɛti be yekɛ bɛntɛ bɛ yɛki buŋga bu bɛniiŋ lɛ be yiki bɛniiŋ bɛ be, be kibɛɛ tɛ mɔɔ mɔŋ le be laa tsaŋ le be fi be kɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Biee bi be feti bichu nuuŋ nɛɛ le be fɛ le bɛniiŋ ŋɛŋ be. Muŋko mu bee mu Kiŋwaati ki Nyɔ-ɔ ko ŋge. Munshɛŋgɛ mu yooŋ yi ndú yi bee nuuŋ mu ndeeŋ. ");
INSERT INTO asj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Be ti giiŋgi fɛ tsɔnɔ-ɔ be kɔŋgisi nshewu nuuŋ fɛ bɛniiŋ guundi be, ɛ be gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ be kɔŋgisi nshewu nuuŋ li bintindu bi limfwe-e. ");
INSERT INTO asj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Be ti kɔŋgisi ndɛndɛ fɛ waŋ le bɛniiŋ ni be yɛɛshi be, be kɔŋgisi le bɛniiŋ ni be teenyi be le Bɛlabi. ");
INSERT INTO asj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Se nuuŋ le, kiiŋ wi ni beenchi le bɛniiŋ ni be teenyi wu le Labi kɛ, kifɛ nɛ kɛmi Wi wu Ntiifɛ nuuŋ nɛɛ mumkpaŋ kwaa, beŋ bɛchu baa wi bee ŋwaani. ");
INSERT INTO asj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kiiŋ nɛ ni nɛ teenyi wi wumu li nshɛ yini le ɛ wu Baa wunɛ kɛ, kifɛ nɛ kɛmi Baa wunɛ mumkpaŋ wu nuuŋ liboo. ");
INSERT INTO asj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kiiŋ wi ni beŋ le bɛ ni bɛ teenyi wu le Te Kikoo kɛ, kifɛ Te Kikoo wunɛ nuuŋ mumkpaŋ kwaa, wu nuuŋ Krai Kinsofu ki Nyɔ tɛ̀ Kaachɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wi wu nyɔŋa lɛ be-eŋ lɛnti kɛmi le ni nuuŋ wi wu nindi li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wi kwikwi wu tsakisi yi yee, Nyɔ gii yi shiiki wu, wi kwikwi wu shiiki yi yee, Nyɔ gii yi tsaaki wu. ");
INSERT INTO asj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ baa bɛniiŋ bɛ nimi-i! Nɛ lemi bɛniiŋ lii, nɛ baanyi dze yi lii li bumfɔŋ bu liboo. Beŋ kibɛɛ nɛ kɔŋgisi yɛ nlɛ lu kɛ, nɛ tuu nɛ baŋgi dze li bɛniiŋ bɛ kɔŋgisi nlɛ lu-u.  ");
INSERT INTO asj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ gbɛŋgi nɛ fieŋgisi bukɛɛŋ bɛɛŋku-u, nlɛkɛ li Nyɔ-ɔ wunɛ deendi le nɛ doonchɛ yi. Nɛ ni nɛ kii le wunɛ ŋgɛ gii naa bee. ");
INSERT INTO asj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ŋgɛ wu nyɔŋa wɛ wunɛ beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ baa bɛniiŋ bɛ nimi-i! Nɛ dzɛti nɛ dɛndɛ kwɛɛŋ wuni kwikwi nɛ lenchi dzɔ́ɔ yi nyɔŋa yi nyɔŋa le nɛ wɛki baa wi wu mumkpaŋ wu gii fiiki shéŋ to wi wunɛ wu kimbeenchɛ-ɛ. Ɛ wu fiiki lɛ, nɛ tuu nɛ fɛ wu mɛɛshi bee bubefu yaa mɔɔ wi wu gɛɛŋ fɛ wi wu duti nyimu si-iŋ, se tuu nuuŋ wi wu nyɔŋa nɛɛ si beŋ tɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ŋgɛ wu nyɔŋa wɛ wunɛ. Nɛ baa binyɛɛ nɛ kweŋgi le nɛ doonchi baa dzé li bɛniiŋ li! Nɛ baa bɛniiŋ bɛ kweŋgi le, ‘Ɛ wi tee fiee, wu chini li bukooŋ bu yih yi muntofi, kɛ fi nuuŋ yɛ nɛɛ fiee kɛ. Se nuuŋ le, ɛ wi tee fiee wu chini nuuŋ li bukooŋ bu kikwa ki kwa-a li yih yi muntofi-i, kɛ kɛmɔɔ le fɛ si wu tee wu chini lɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Binyɛɛ bini! Nɛ baa bibere! Fiee fi ko fi yaa fimu nuuŋ fi la? Fi ŋge nuuŋ kikwa ki kwa-a mɔɔ yih yi muntofi yi feti se kikwa kilu tuu ki nuuŋ fiee fi nuuŋ fi Nyɔ-ɔ le? ");
INSERT INTO asj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɛ kweŋgi tɛ le, ‘Ɛ wi tee fiee wu chini li bukooŋ bu taantaa chi muntofi-i, kɛ fi nuuŋ yɛ tɛ fiee kɛ. Se nuuŋ le, ɛ wi tee fiee wu chini nuuŋ li bukooŋ bu fiee fi wi fɛ muntofi lu, kɛ kɛmɔɔ le fɛ si wu tee wu chini lɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Binyɛɛ bini! Fiee fi ko fi yaa fimu nuuŋ fi la? Fi ŋge nuuŋ nya yilu mɔɔ taantaa chi muntofi-i chi wu fɛ se nya yilu nuuŋ fiee fi nuuŋ fi Nyɔ-ɔ le? ");
INSERT INTO asj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Fiee fi nuuŋ lu fiɛɛ le ɛ wi chini li bukooŋ bu taantaa chi muntofi-i, kɛ wu chinɔɔ nɛɛ lɛ mɔɔ li biee bichu bi nuuŋ lu-u. ");
INSERT INTO asj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ɛ wi chini li bukooŋ bu yih yi muntofi-i, kɛ wu chinɔɔ li yih yilu mɔɔ li Nyɔ-ɔ yi ntsiiŋ lu-u. ");
INSERT INTO asj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɛ wi chini li kwɛɛŋ wu liboo li, kɛ wu chinɔɔ tɛ nuuŋ li kabara wu Nyɔ-ɔ mɔɔ li Nyɔ yi shiiti lu. ");
INSERT INTO asj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ŋgɛ wu nyɔŋa wɛ wunɛ beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ baa bɛniiŋ bɛ nimi-i! Nɛ ti nyɛɛ kimbɛ kimumkpaŋ li Nyɔ-ɔ lɛnti lɛ bimbe yoofi-i bi bɛŋɔ bɛ nɛ keeti nɛ giki lɛ mbasi le yi ni yi yiki, nɛ tuu nɛ fɛŋgi fiee fi luuti fi nchi tiiti kii fi le nɛ ni nɛ feti, fi nuuŋ le nɛ ni nɛ feti biee bi tsaaŋ li bɛniiŋ li, nɛ keeti nshiiŋ li bɛniiŋ li mɔɔ le nɛ gɛɛ shéŋ li Nyɔ-ɔ. Nɛ kɛmi le nɛ fɛ biee bilu bichu nɛ tɛ shɛ fimu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Binyɛɛ bi doonchi dzé li bɛniiŋ bamu bini! Nɛ kɔŋgisi mbusu finyunyu lɛ mbiiŋ li, se nuuŋ le, nɛ tuu nɛ miyi nyaŋ yi nyɔŋa lɛ shéŋ! ");
INSERT INTO asj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ baa bɛniiŋ bɛ nimi-i! Nɛ tsootsi muka bɛ shó bwiŋ kwaa, se nuuŋ le, biee yisɛ biɛɛ le nuuŋ bi nɛ lɔchi li bɛniiŋ li mɔɔ bi lii yinɛ funyi. ");
INSERT INTO asj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Binyɛɛ bi Bɛfarasii, saa yɛɛŋ nɛ tsootsɛ muka bɛ shó lɛnti kwɛ, se mu ni mu wuuti tɛ li bwiŋ. ");
INSERT INTO asj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ baa bɛniiŋ bɛ nimi-i! Nɛ baa si dzíŋ yi bɛ nachɛ bɛ fwa yi to ncherere yi yeŋgi lii bujɔŋ, se nuuŋ le, lɛnti lɛlu nuuŋ ɛ le yisɛ bɛ biŋkomfu bi gooŋ yi bɛniiŋ lɛ mɔɔ biee bi nyɛndi bichu. ");
INSERT INTO asj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɛ lɛ si nɛ gwiyi baa lii le nɛ baa bɛniiŋ bɛ tsaaŋ, se nuuŋ le, lɛnti laa ɛ le yisɛ bɛ kimfi mɔɔ biee bifi bi fɛrɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛniiŋ bɛ tiifi bɛnchi mɔɔ beŋ Bɛfarasii. Nɛ baa bɛniiŋ bɛ nimi-i! Nɛ gwɛndi dzíŋ yi bɛ ntomfɔŋ bɛ Nyɔ-ɔ, nɛ nachi tɛ dzíŋ yi bɛniiŋ bɛ tɛ̀ tsiiŋ ntsɛ wu tsaaŋ, nɛ nachi yi dzeeŋ. ");
INSERT INTO asj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nɛ feti lɛ nɛ doonchi le, ‘Gii nuuŋ le tɛ ni tɛ nuuŋ lu li mfi wu bɛtaa bɛsɛŋ wɛɛ, gii tɛ lemi yɛ fisɛŋ fɛ fiee fi be tɛ̀ feti le bɛ ni bɛ woyi bɛ ntomfɔŋ bɛ Nyɔ-ɔ fiɛɛ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nɛ tiiti baa lɛ, nɛ tiiti nuuŋ kii bikoo binɛ nɛ tuu nɛ teendi bɛ bimfimu binɛ le nɛ baa nuuŋ bɔɔŋ bɛ bɛniiŋ bɛ tɛ̀ woyɛ bɛ ntomfɔŋ bɛ Nyɔ-ɔ baa. ");
INSERT INTO asj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gɛnɛ yɛɛŋ limfwe, nɛ mɛɛshi nimɛ chi bɛchaa bɛnɛ tɛ̀ bɛchi! ");
INSERT INTO asj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yɔ́ yini! Kiŋgɔkɛ ki mu faa lɛ kini! Nɛ beechi le bɛ nuuŋ tɛ naa gɛɛ beŋ fɛ wi wu nyɔŋa-a kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Si fi nuuŋ lɛ, mi nse ntuuɔ mi ntoŋ bɛ ntomfɔŋ bɛ Nyɔ-ɔ lɛ be-eŋ mɔɔ lɛ bɛniiŋ bɛ bufii lɛ bɛ bɛniiŋ bɛ tiifi bɛnchi. Nɛ gii nɛ naa nɛ woyɛ bamu, nɛ tayɛ bamu li bintaaŋ li nɛ fiaaŋ bamu li yih yinɛ yi nlɛkɛ li Nyɔ-ɔ, nɛ beeŋ bikaa lɛ bamu jiŋ bintsii bichu bi be giiŋgi li bi-i. ");
INSERT INTO asj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɛ gii ke nɛ fɛ lɛ se ŋgɔŋ mɛ bɛniiŋ bɛchu bɛ tɛ̀ tsiiŋ ntsɛ wu tsaaŋ li nshɛ yini-i bɛ bɛ tɛ̀ woyɛ, nuuŋ fɛ benɛ fa. Ngɔŋ mani gii naa me nuuŋ fɛ benɛ fa mbɛɛchɛ li mɛ Abɛ wu bɛ tɛ̀ wo nchɔru fiee nsiŋ, mbɛ mbochu li mɛ Sakariya wu ŋwanɛ Belekayɛ wu nɛ tɛ̀ wo kintikinti ki yih yi muntofi-i bɛ taantaa chi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ntee beŋ chɛɛŋ le, mudzɔŋ mu biee bini bichu gii mu kɔɔ kiŋgɔkɛ ki dɛɛni kini kichu.” ");
INSERT INTO asj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Le Jiso yɔ ni, bɛɛni yi le, “Hebee Jɛrosalɛŋ! Hebee Jɛrosalɛŋ! Wɛ wu woyi bɛ ntomfɔŋ bɛ Nyɔ-ɔ, ɔ tuu ɔ tomi bɛniiŋ bɛ Nyɔ tuumi li wɛ-ɛ bɛ ta! Ɛ kiŋga kimɛ ki mi ŋgwɛnɔɔ le mbanchɛ bɔɔŋ bo nɛɛ si ni shee ti banchi bɔɔŋ bee foochɛ bɛ bibɛ biee lɛ, ɔ se tuu ɔ faaŋ? ");
INSERT INTO asj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bichɛ ɔ ŋɛŋ, bɛ chinɛ baa yih ya, yi gii yi to kichiiyɛ. ");
INSERT INTO asj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ntiitɔɔ tɛ li wɛ-ɛ le ɔ mɛɛŋ yɛ le ɔ tuu ɔ ŋɛŋ mi kɛ, ŋgɛnu mbochu mfi wu ɔ gii naa ɔ tee le, ‘Nyɔ tiiŋ yɛ mwɛ li wi wu bɛɛ li bukooŋ bu Taa Nyɔ-ɔ.’” ");
INSERT INTO asj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Le Jiso bo li yih yi muntofi-i, ni giiŋgi, bɔɔŋ bee bɛ kintutu kiiŋgi be bɛ li wuu lichiŋ be doonchi yíh yi fɛ yih yi muntofi-i li wuu. ");
INSERT INTO asj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Se nuuŋ le, Jiso tuu tee li bee le, “Nɛ ŋɛŋ baa yíh yini ni? Ntee beŋ chɛɛŋ le tɛtɛ chi mumkpaŋ nuuŋ tɛ shɛ li chimu liwe bɛ mɛɛŋ ki bachɛ kɛ chi fɛkwiiŋ nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Le Jiso gɛɛŋ miri shee li Ŋkumɛ wu Biti bi Oli-if, bɔɔŋ bee bɛ kintutu-u kiiŋgi bebe, be bɛ fɛ wuu be bii laa, “Tee bee mfi wu biee bini gii bi yenɛ, bɛ fiee fi gii fi doonchɛ mfi wu ɔ gii ɔ kaari ɔ bɛ, ɔ se tuu ɔ tee bee mfi wu ntsɛ wu li nshɛ yini-i gii ma?” ");
INSERT INTO asj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jiso tuu li bee le, “Ŋɛŋ yɛɛŋ le kiiŋ wi ni yɛɛŋ bɛ beŋ nɛ taŋ dze kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nɛ kɛɛ le bɛniiŋ ŋge gii be bɛ be dzɔɔ bukooŋ bweŋ be gɛɛ limfwe, wi ni kweŋgi le ɛ wu Kinsofu ki Nyɔ tɛ̀ kaachɛ. Mfi wu be gii be ni be feti lɛ, be gii be ni be yɛŋgi bɛ bɛniiŋ ŋge be tɛndi dzé. ");
INSERT INTO asj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɛ gii nɛ woo bɛ tundi dziŋ, nɛ ni nɛ wuki bɛntoŋ tɛ le dziŋ yɛ lu. Ɛ nɛ wuki lɛ, kiiŋ shéŋ ni yi soomi beŋ kɛ. Bini biɛɛ biee bi kɛmi le bi bɛ bi ka. Se nuuŋ le bi doonchi yɛ le ntsɛ wu li nshɛ yini-i maɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwɛɛŋ gii wu ni wu tundi dziŋ bɛ wumu, mfɔŋ wumu tundi dziŋ bɛ wumu. Nshɛ gii yi ni yi nduŋgi li bintsii li, li bintsii li, dzeeŋ ni yi keeti. Bini biee mɛɛŋ biɛɛ fintɛŋ si ntunu wu kwɛɛŋ ti bɛɛchi. ");
INSERT INTO asj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Biee bini bichu biɛɛ si mfi wu kwɛɛŋ ti bɛchi ntunu. ");
INSERT INTO asj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bɛniiŋ gii be nyɛ beŋ bɛ ni bɛ liti beŋ, bɛ ni bɛ woyi beŋ. Bitoŋ bichu ni bi baanini beŋ kii bukooŋ bweŋ. ");
INSERT INTO asj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bɛdɛɛni bɛniiŋ ŋge ni be tusi bikaa lijiŋ, be kɛmi mbani, be kabini mɔɔ yi yibe. ");
INSERT INTO asj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bɛniiŋ ŋge bɛ yɛŋgi le ɛ Nyɔ yi toŋ be gii be busɛ be ni be yɛŋgi bɛ bɛniiŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Si bubefu gii bu yaŋ bu gɛɛŋ limfwe lɛ, fi gii fi fɛ se kiŋkɔŋgisɛ ki bɛniiŋ lɛ ŋgee to wɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Se nuuŋ le, wi wu gii kaŋ shéŋ gɛɛŋ bo fɛ kimɛrisɛ gii bɔnɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bɛ kɛmi le be ni be tiifi ntoŋ wu dzeeŋ wuni kii bumfɔŋ bu Nyɔ-ɔ gɛɛŋ bo li kikoo ki nshɛ-ɛ kichu, bitoŋ bichu se woo, se ntsɛ wu li nshɛ-ɛ yini-i naa ma. ");
INSERT INTO asj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Bɛdɛɛni mfi wu nɛ ŋɛŋ fiee fi bɛndi yi fi nuuŋ fi biifi kintsii fi ntomfɔŋ wu Nyɔ wu Danyɛ tɛ tee kii fi, fi lemi li yih yi muntofi, (wi wu teenyi kiŋwaati kini woo fini bujɔŋ,) ");
INSERT INTO asj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bɛniiŋ bɛ nuuŋ Judiya kifi be miri li bɛŋkumɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kiiŋ wi wu nuuŋ lɛ yi-ih lɛwe tuu shee le lɛ dzɔɔ fiee li yih kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kiiŋ wi wu nuuŋ liwɛ tuu kaari lɛ gɛɛŋ dzɔɔ kiŋkoŋ ki fochɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ŋgɛ wu nyɔŋa wɛ li jo yɛɛ li bukɛɛŋ bɛ nuuŋ bɛ fe-e, mɔɔ bɛ kisi bɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nɛ lɛki li Nyɔ-ɔ le kiiŋ wuni ŋgwɛti nuuŋ mfi wu fokpɔŋ, kɛ jobɛ chi bɛshiinshi kɛ, ");
INSERT INTO asj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kifɛ ŋgɛ wu ŋge gii nuuŋ li wɛɛ mfi-i, ŋwaani wɛɛ ŋgɛ ti mɛɛŋɔ saa ki nuuŋ kɛ lu fɛ mbɛɛchɛ si nshɛ tɛ̀ bɛchi mbɛ mbochu dɛɛni kɛ, ŋwaani wɛɛ ŋgɛ mɛɛŋ yɛɛ naa nuuŋ lu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nyɔ tɛ̀ gii mɛɛŋ ki gatɛ kɛ li jo yilu kɛ, wi mumkpaŋ gii wu bochɛ-ɛ lu kɛ. Se nuuŋ le Nyɔ tɛ̀ gatɛ jo yilu kii bɛniiŋ bee bɛ tɛ̀ tsaa. ");
INSERT INTO asj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Gii ni nuuŋ li mfi wu wɛɛ, ɛ wi kweŋgi li be-eŋ le, ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, kinsofu ki Nyɔ tɛ̀ kaachɛ kɛɛ kɛ fɛni!’ Dɛɛŋ le, ‘wɛ fɛ fiiyɛ!’ Kiiŋ nɛ ni beŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nɛ ni nɛ kii le bɛniiŋ gii naa be ni be bɛɛ be yɛŋgi le be baa nuuŋ binsofu bi Nyɔ tɛ̀ kaachɛ, bamu ni be kweŋgi le ɛ be bɛntomfɔŋ bɛ Nyɔ-ɔ, be ni be feti biee bi tɛɛmi bi doonchi buŋga bubee, be fɛ tɛ bintɛ wa bi biee lɛ, le be yɛɛŋ bɛ bɛniiŋ se be taŋ dzé, be gii be gwenɛ le be yɛɛŋ mɔɔ bɛ bɛniiŋ bɛ Nyɔ tɛ̀ tsaa, ɛ dze bo lu. ");
INSERT INTO asj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yikɛ yɛɛŋ nɛ woo, mi nteeɔ biee bini li be-eŋ se bi naa bi ka. ");
INSERT INTO asj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bɛdɛɛni, ɛ bɛniiŋ dza be tiiti li be-eŋ le, ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛɛ libuka,’ kiiŋ nɛ ni gɛɛŋ lu kɛ. Kɛ le, ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, wɛ li yih lɛnti kibɛɛ,’ kiiŋ nɛ ni beŋ li bee kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nɛ ni nɛ kii le si dzaaŋ ti lɛɛbi liwe lɛ kimbɛ ki jobɛ tɛti, yi yenɛ yi gɛɛŋ yi bo fɛ jobɛ sechi, ɛ lɛ si mbɛ wu Ŋwanɛwi gii naa nuuŋ. ");
INSERT INTO asj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘Ɛ fɛ gwini chi fiee lɛ nuuŋ, ɛ nɛɛ fe fɛ biŋguru banchi.’ ");
INSERT INTO asj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mfwaa mumkpaŋ fɛ mfi wu ŋgɛ wu nyɔŋa wuni bɛ wu ka, jobɛ dza chi jiŋ, kwii tɛ nɛɛŋ kɛ, muntsɔŋ dza liboo mu weyɛ, biee bi liboo bichu bi kɛmi buŋga sɛɛsɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Se ndoonchɛ wu Ŋwanɛwi yenɛ liboo. Bitoŋ bichu bi li nshɛ-ɛ bɛchi bi ni bi fuuti bɛ kwe. Bɛniiŋ gii be ŋɛŋ si Ŋwanɛwi bɛɛ li kiku-uŋ liboo bɛ buŋga mɔɔ bunɔŋa. ");
INSERT INTO asj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Fɛ sɔŋ yi nyɔŋa gii yi yɔ liboo, biee toŋ bɛnchindaa bee be gɛɛŋ li boo yi naa yi li nshɛ-ɛ, be yɛɛ mɔɔ liboo, be banchɛ bɛniiŋ bee bɛ tɛ̀ tsaa. ");
INSERT INTO asj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Laanchɛ yɛɛŋ fiee li kigumɛ-ɛ. Ki bɛɛ fɛ ki sanyɛ yɛŋɛ, bibɛ bɛchi mbɔchɛ li ki-i, nɛ kɛɛ le ndzɛɛŋ yɛ tsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nɛɛ lɛ ɛ nɛ ŋɛŋ biee bini bichu kɛti, nɛ kɛɛ le mfi wulu wɛ tsɛkɛtsɛkɛ mfweeŋ. ");
INSERT INTO asj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ntee beŋ chɛɛŋ le kiŋgɔkɛ ki dɛɛni kini nuuŋ ki tɛ naa ma biee bini bichu mɛɛŋ ki ka kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kiboo bee nshɛ gii bi ka, se nuuŋ le jɛ yɛŋ nuuŋ tɛ naa ka kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Wi nuuŋ yɛ mɔɔ lu wu kii jobɛ chilu, mɔɔ mfi wulu kɛ. Mɔɔ bɛnchindaa bɛ Nyɔ-ɔ bɛ liboo mɔɔ Ŋwanɛ Nyɔ kii yɛ tɛ kɛ. Ɛ Nyɔ Baa yi yi mbiiŋ kwaa yi kii. ");
INSERT INTO asj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nɛɛ si fi tɛ nuuŋ li mfi wu Noa li lɛ, ɛ lɛ si fi gii fi nuuŋ li mfi wu Ŋwanɛwi gii kaari bɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tɛ̀ nuuŋ mfi wu dzɔɔ ti mɛɛŋ ki yisɛ kɛ li kikoo ki nshɛ kɛ, bɛniiŋ nuuŋ fibee, be jii biee, be wundi biee, bukɛɛŋ bɛ buniŋ feti bugoo, bɛniiŋ nyɛɛ bɔɔŋ bɛ bukɛɛŋ li bugoo li, gɛɛŋ bo jobɛ chi Noa tɛ̀ lɛ lɛ yih yi li dzɔɔ li, ");
INSERT INTO asj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","bɛniiŋ bɛlu tɛ̀ kii yɛ fiee fi gii fi ka kɛ, gɛɛŋ bo mfi wu dzɔɔ tɛ̀ yisɛ li nshɛ-ɛ yi too be bɛchu yi gɛɛŋ bɛ be. Ɛ lɛ si fi gii fi nuuŋ jobɛ chi Ŋwanɛwi gii naa bɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Buniŋ bɛfɛ gii be ni be nuuŋ liwɛ, bɛ dzɔɔ mumkpaŋ mumkpaŋ shɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bukɛɛŋ bɛfɛ gii be ni be geki bunɛɛŋ fɛ jeeŋ, bɛ dzɔɔ mumkpaŋ mumkpaŋ shɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bɛdɛɛni, nɛ tɛŋgi yɛɛŋ kifɛ nɛ kii yɛ jobɛ chi Taa wunɛ gii naa bɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nɛ kii le ɛ te yih kɛɛ mfi wu wih gii bɛ butuu, tɛ lee kɛ, ni kiichi, tɛ chinɛ le bɛ bondɛ yih ye kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Fi se nuuŋ le, nɛ kɛmi le nɛ ni nɛ tɛŋgi kifɛ Ŋwanɛwi gii bɛ li mfi wu nɛ kii yɛ kɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ŋwanɛ nimɛ wu chɛɛŋ mɔɔ wu kɛmi bufii nuuŋ wu la? Ɛ nɛɛ wu te kikoo we gɛɛ wu le ni bichi fɛ yih ye le ke mfi kɔchɛ, nyɛ biee bijɛ li bɔɔŋ bee bɛ nimɛ-ɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kinɛɛtinɛ kinɔŋa gii ki nuuŋ ki ŋwanɛ nimɛ wu te kikoo we gii ke wu bɛ ŋɛŋ ɛ wu fɛ nimɛ tsaaŋ si bee gɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ntee beŋ chɛɛŋ le te kikoo we gii bɛ yɛɛki wu ni bichi lɛ biee biee bichu-u. ");
INSERT INTO asj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Se nuuŋ le ɛ ŋwaanɛ nimɛ wulu dza tuu kɛmi kiŋge ki bifi, wu tee li yi yee le, ‘Te Kikoo wɛŋ nuuŋ tɛ kaari tsɛkɛ kɛ’, ");
INSERT INTO asj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ɛ wu bɛchi tuki bɔɔŋ bɛ nimɛ-ɛ bamu bɛ bee be nindi baa, jii biee tuu wundi biee bɛ bɛniiŋ bɛ wundi mbiiŋ, ");
INSERT INTO asj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kɛ te kikoo we gii dza taa mbundɛ jobɛ chimu chi beechi yɛ mɔɔ mfi wu kii yɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɛ wu mbundɛ lɛ, nyɛ ŋgɛ li ŋwani wu nimɛ wulu-u, tuumi wu gɛɛŋ ni nuuŋ li kintutu ki bɛniiŋ bɛ nimi-i, ni nuuŋ fɛ bɛniiŋ gii be ni be dii be jii ŋgesi.” ");
INSERT INTO asj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Bɛ nuuŋ bɛ maa bumfɔŋ bu liboo bɛ bɛsɔɔŋ bɛ bukɛɛŋ lɛ bamu yoofi bɛ tɛ̀ dzɔ bɛlambo bɛ bee, le be gɛɛŋ be taaŋ nyuŋ wutso be chinɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bɛtiinu tɛ̀ nuuŋ bibere, bɛtiinu nuuŋ bɛ bufii lɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Fi se ka le bɛ tɛ̀ nuuŋ bibere baa tɛ̀ dzɔ bɛlambo bɛ bee ndzɔtsu mɛɛŋ mamu siŋ, ");
INSERT INTO asj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","bɛ bufii lɛ baa se dzɔ bɛlambo bɛ bee mɔɔ sho yi mɛɛŋ mamu lu lichiŋ. ");
INSERT INTO asj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Le be gɛɛŋ be ni be tɛŋgi nyuŋ wutso wulu, le ni chiiti yi li mbɛɛ, chilefɛ dza chi kɔɔ be, be bɛchi nlefu. ");
INSERT INTO asj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Le bo butuu kintikinti, be dza be woo si wi wuuyi le, ‘Yiyi-i yiyi-i yiyi-i, bichɛ yɛɛŋ nɛ ŋɛŋ, nyuŋ wutso wulu fɛsɔɔ looo! Bo yɛɛŋ nɛ bɛ nɛ fi wu looo’ ");
INSERT INTO asj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bɛsɔɔŋ bɛ bukɛɛŋ lɛ baa bɛchu dza we be yɛɛki bɛlambo bɛ bee. ");
INSERT INTO asj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bɛsɔɔŋ bɛ bukɛɛŋ lɛ bɛ tɛ̀ nuuŋ bibere baa se tee li bɛ bufii lɛ baa le, ‘Nyɛ yɛɛŋ bee fɛ mɛɛŋ mɛnɛ. Bɛlambo bɛsɛŋ shiiti baa.’ ");
INSERT INTO asj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bɛ bufii lɛ baa se tuu le, ‘Wohoo, me nuuŋ tɛ kɔchɛ li tɛɛbeŋ bɛchu kɛ. Gɛnɛ yɛɛŋ nuuŋ fɛ bɛ kabini, nɛ go mɛnɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Si be tɛ̀ gɛɛŋ le be go lɛ, nyuŋ wutso wulu shɛ fɛsi. Bɛ tɛ̀ nachɛ yi kituŋ be tɛŋgi baa, biee be gɛɛŋ be lɛ bɛ wu li yih yi tsɔnɔ chi bugoo lɛ, bɛ bɛŋɛ kigoo. ");
INSERT INTO asj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lɛjiŋ lɛlu, bɛsɔɔŋ bɛ bukɛɛŋ lɛ bamu bɛ tɛ̀ gɛɛŋ le be go mɛɛŋ baa fɛsi, be leŋ mfweeŋ be tiiti le, ‘Te Kikoo, te kikoo, gwiyɛ kigoo tɛ lɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Se tuu li bee le, ‘Chɛɛŋ chɛɛŋ ŋkii yɛ beŋ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Fi se fiɛɛ le, nɛ nachɛ yi, nɛ ni nɛ tɛŋgi, kifɛ nɛ kii yɛ jobɛ mɔɔ mfi wulu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mfi wulu gii ni nuuŋ si wumu wu tɛ̀ wɛki le gɛɛŋ ndɛndɛ, teeŋ bɔɔŋ bee bɛ nimɛ nyɛ kwa we li tsáŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tɛ̀ nyɛ ŋwani wu nimɛ wumu bɛbabi bɛ kwaa bɛtiinu, nyɛ wumu bɛbabi bɛfɛ, nyɛ wumu babi wu kwa mumkpaŋ. Tɛ̀ nyɛɛ lɛ biki si buŋga bu wi nuuŋ. Si tɛ̀ nyɛ lɛ, la ndɛndɛ we. ");
INSERT INTO asj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ŋwaŋ wu nimɛ wu tɛ̀ fi bɛbabi bɛ kwaa bɛtiinu wɛ, tɛ̀ gɛɛŋ mfwaa mumkpaŋ fɛ waŋ lu, ji mbeŋ le bɛbabi bɛtiinu. ");
INSERT INTO asj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wu tɛ̀ fi bɛbabi bɛfɛ wɛ, tɛ̀ fɛ waŋ lu, ji mbeŋ bɛbabi bɛfɛ le lɛwe. ");
INSERT INTO asj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Se nuuŋ le, ŋwaŋ wu nimɛ wu tɛ̀ fi babi wu kwa mumkpaŋ wɛ, tɛ̀ gɛɛŋ fiee chiŋ kitoo nyikɛ kwa wu te kikoo wɛɛ le lɛnti. ");
INSERT INTO asj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Si te kikoo wu bɔɔŋ bɛ nimɛ wulu tɛ̀ la ndɛndɛ wɛ lɛ, tɛ̀ gɛɛŋ tsiiŋ le ŋge. Le kaari bɛ, teeŋ bɔɔŋ bee bɛ nimɛ, le be bɛ, be bee nachɛ biee. ");
INSERT INTO asj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ŋwaŋ wu nimɛ wu tɛ̀ fi bɛbabi bɛ kwaa bɛtiinu wɛ bɛ kituŋ bɛ bɛbabi yoofi, tee le, ‘Te Kikoo, ɔ tuu ɔ nyɛ mi bɛbabi bɛ kwaa bɛtiinu, bichɛ ɔ ŋɛŋ ntuu nshɛ mi mfɛ waŋ lu, mi ŋkɛmɛ bɛbabi bamu bitiinu le lɛwe.’ ");
INSERT INTO asj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Te Kikoo we tee li wuu le, ‘Kiyɔɔni kinɔŋa. Ɛ wɛ ŋwaŋ wu nimɛ wu dzeeŋ mɔɔ wu chɛɛŋ! Ɔ tuu ɔ shɛ ɔ nuuŋ tsaaŋ lɛ mbichɛ lɛ fiee fi ntɛŋ bujɔŋ. Bɛdɛɛni, ŋgii ŋgɛɛ wɛ dɛɛni ɔ ni ɔ bichi tɛ lɛ fi nɔŋa-a. Bɛ ɔ woo bujɔŋ bɛ te kikoo wa.’ ");
INSERT INTO asj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ŋwaŋ wu nimɛ wu kwa we tɛ̀ nuuŋ bɛbabi bɛfɛ wɛ tɛ lɛ, tee le, ‘Te Kikoo, ɔ tɛ̀ nyɛ mi bɛbabi bɛ kwaa bɛfɛ. Bichɛ ɔ ŋɛŋ, ntuu nshɛ mi fɛ waŋ lu, mi ŋkɛmɛ bɛbabi bamu bɛ kwa bɛfɛ le lɛwe.’ ");
INSERT INTO asj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Te Kikoo we tee li wuu le, ‘Kiyɔɔni kinɔŋa. Ɛ wɛ ŋwaŋ wu nimɛ wu dzeeŋ mɔɔ wu chɛɛŋ! Ɔ tuu ɔ shɛ ɔ nuuŋ tsaaŋ lɛ mbichɛ lɛ fiee fintɛ-ɛŋ bujɔŋ. Bɛdɛɛni, ŋgii ŋgɛɛ wɛ dɛɛni ɔ ni ɔ bichi tɛ lɛ fi nɔŋa-a. Bɛ ɔ woo bujɔŋ bɛ te kikoo wa.’ ");
INSERT INTO asj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Le ŋwaŋ wu nimɛ wumu wu tɛ̀ nyɛ babi wu kwa mumkpaŋ wɛ bɛ lɛ, tee le, ‘Te Kikoo, ŋkii le ɔ nuuŋ wi wu tɛɛmi lɛ dzaa. Ɔ ti wechi fɛ ɔ mɛɛŋ ki tɔyɛ kɛ, ɔ se banchi giiŋ yɔɔ ti mɛɛŋ ki tuŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bɛdɛɛni ntɛ̀ chɛndi ŋgɛɛŋ nyikɛ kwa wa fɛtoo. Bichɛ ɔ ŋɛŋ, wuuŋ kwa wa, kɔ.’ ");
INSERT INTO asj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Te Kikoo we tuu li wuu le, ‘Ɛ wɛ ŋwaŋ wu nimɛ wu bifi, ɔ wɛ kiniŋgɛ! Ɔ ti kii le nti ŋ'wechi mɛɛŋ ki ntɔyɛ kɛ, mbaanchi giiŋ mɛɛŋ ki tuŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Si ɔ tuuɔ kii lɛ, tuu nuuŋ ɔ kiri kwa wɛŋ li yih yi bɛ kichi kwa lu, le ke mfi wu mi ŋkaari mfi kwa wɛŋ bɛ mbeŋ le lɛwe.’ ");
INSERT INTO asj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Si tɛ̀ tee lɛ, tee le be fi babi wu kwa wulu li wuu, be nyɛ li wi wu kɛmi bɛbabi bɛ kwa yoofi wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Le be kɛɛ le wi wu kɛmi, bɛ gii bɛ naa bɛ tondɛ wu kɛmɛ ŋge. Se nuuŋ le wi wu kɛmi yɛ kɛ, mɔɔ nuuŋ fi niiŋ fi kɛmi bɛ gii bɛ fi li wuu. ");
INSERT INTO asj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Si tɛ̀ tee lɛ, tee le, ‘Lɔmɛ yɛɛŋ kibere ki ŋwaŋ wu nimɛ-ɛ kini li kijibɛ lɛkuuŋ, fɛ gii ni dii jii ŋgesi.’ ");
INSERT INTO asj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gii ni nuuŋ mfi wu Ŋwanɛwi kaarisi bɛɛ li bunɔŋa bwee li, ni bɛɛ bɛ bɛnchindaa bɛ Nyɔ-ɔ bɛchu, gii shee li kabara we wu bunɔŋa. ");
INSERT INTO asj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bitoŋ bichu bi li kikoo ki nshɛ gii bi leŋ wu limfwe, se gatɛ be li bintutu bifɛ si wi wu ŋkiichɛ ti gatini nshɔ́ɔŋ buu li bí linti lɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Gii gɛɛ nshɔ́ɔŋ lɛ kibɛnɛ ki kigɔŋɛ-ɛ, se gɛɛ bí lɛ kibɛnɛ ki kimɛsɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wu wu Mfɔŋ gii tee li bɛ nuuŋ lɛ kibɛnɛ kee ki kigɔŋɛ-ɛ le, ‘Bɛniiŋ bɛ Taa tiiŋ mwɛ li bee, bɛ yɛɛŋ nɛ kɛmɛ bintsii lɛ bumfɔŋ bu bɛ nachɛ li be-eŋ mbɛɛchɛ si bɛ tɛ̀ tɔŋ nshɛ, ");
INSERT INTO asj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kifɛ dzeeŋ tɛ̀ wuu mi, nɛ nyɛ mi biee bijɛ. Ndɔɔŋ tɛ̀ wondɛ mi, nɛ nyɛ mi fiee ŋ'woŋ. Ntɛ̀ nuuŋ kilɔ, nɛ fi mi. ");
INSERT INTO asj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ntɛ̀ nuuŋ bwiŋ kilɛrɛ, nɛ lii mi ndu. Ntɛ̀ ŋgendi nɛ bɛ nɛ yɛsi mi. Ntɛ̀ nuuŋ li yih yi ncha-a, nɛ bɛ nɛ yɛsi mi.’ ");
INSERT INTO asj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Gii ke wu tee lɛ, bɛniiŋ bɛ tsaaŋ baa se tuu be bii li wuu laa, ‘Taa, ɛ mfi wu la wu tɛ tɛ̀ ŋɛŋ wɛ dzeeŋ wuu wɛ, tɛ̀ nyɛ wɛ biee bijɛ, bɛ mfi wu la wu ndɔɔŋ tɛ̀ wondɛ wɛ tɛ nyɛ wɛ fiee ɔ woŋ? ");
INSERT INTO asj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɛ mfi wu la wu tɛ tɛ̀ ŋɛŋ wɛ ɔ nuuŋ kilɔ, tɛ fi wɛ, bɛ mfi wu la wɔɔ tɛ̀ nuuŋ bwiŋ kilɛrɛ, tɛ lii wɛ ndu? ");
INSERT INTO asj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɛ mfi wu la wu tɛ tɛ ŋɛŋ wɛ ɔ gendi ɔ nuuŋ tɛ li yih yi ncha-a, tɛ se bɛ tɛ yɛsi wɛ?’ ");
INSERT INTO asj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mfɔŋ se tuu li bee le, ‘Ntee beŋ chɛɛŋ le, si nɛ tɛ̀ feti biee bini, li wi wu ŋkwɛŋ li bɛŋwaanɛŋ bani-i, nɛ tɛ̀ feti nuuŋ li mi-i.’ ");
INSERT INTO asj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Bɛdɛɛni, gii tuu tee li bɛ nuuŋ lɛ kibɛnɛ kee ki kimɛsɛ baa le, ‘Beŋ bɛ kinlɔɔ lɛ bani, dza yɛɛŋ mi limfwe, nɛ gɛɛŋ nɛ lɛ li ŋgɛ wu kimakɛ-ɛ wu bɛ tɛ̀ nachɛ li kiŋkundi bɛ bɛnchindaa bee li, ");
INSERT INTO asj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kifɛ dzeeŋ tɛ̀ wuu mi, nɛ ti mɛɛŋ ki nyɛ kɛ mi fiee fijɛ kɛ. Ndɔɔŋ tɛ̀ wondɛ mi, nɛ faaŋ nyɛ mi fiee fi ŋ'wonɛ. ");
INSERT INTO asj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ntɛ̀ nuuŋ kilɔ, nɛ tɛ̀ mɛɛŋ ki fii mi kɛ. Ntɛ̀ nuuŋ bwiŋ kilɛrɛ, nɛ tɛ̀ mɛɛŋ ki lii kɛ mi ndu li bwiŋ kɛ. Ntɛ̀ ŋgendi, ntuu nuuŋ li yih yi ncha-a, nɛ ti mɛɛŋ ki bɛ kɛ le nɛ yɛsi mi kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Be se tuu be bii li wuu laa, ‘Taa, ɛ mfi wu la wu tɛ tɛ̀ ŋɛŋ wɛ dzeeŋ wuu wɛ, kɛ ndɔɔŋ wondini wɛ, ɔ nuuŋ kilɔ, kɛ bwiŋ kilɛrɛ, ɔ gendi, bɛ li yih yi ncha-a, tɛ se mɛɛŋ ki fi kɛ wɛ kɛ?’ ");
INSERT INTO asj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Se tuu li bee le, ‘Ntee beŋ chɛɛŋ le, si nɛ ti mɛɛŋ ki fɛ kɛ biee bini li wi wu ŋkwɛ-ɛŋ li bɛŋwaanɛŋ bani ni kɛ, kɛ ɛ li mi li nɛ ti mɛɛŋ ki fɛɛ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Beeyɛ bɛniiŋ gii be gɛɛŋ be lɛ li ŋgɛ wu kimakɛ-ɛ. Se bɛ nuuŋ tsaaŋ baa gɛɛŋ be lɛ fibee nuuŋ li ntsɛ wu shaaŋ wu nuuŋ tɛ ma kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Le Jiso yɔ biee bini bichu mɛɛshi, tee li bɔɔŋ bee bɛ kintutu-u le, ");
INSERT INTO asj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nɛ kɛɛ le shɛɔ jo faa, ni nuuŋ Tsɔnɔ chi N'yafuwee, bɛ gii bɛ nyɛ Ŋwanɛwi li tsaŋ yi bɛniiŋ li be ta wu li kintaaŋ li.” ");
INSERT INTO asj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nɛɛ li mfi wulu, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ se gɛɛŋ be lɛ ntsuuŋ lɛ ntɔ wu Kaifas wu tɛ̀ nuuŋ kikoo ki bɛte muntofi, ");
INSERT INTO asj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","be biee be dzɔ ntaŋ si be gii be wɛɛŋ be se kɔɔ Jiso, be wo. ");
INSERT INTO asj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Si be tɛ̀ dzɔ ntaŋ lɛ, be tee le, “Kiiŋ tɛ ni mɔŋ fiee fini li mfi wu Tsɔnɔ-ɔ kɛ, kifɛ ɛ tɛ mɔŋ, fi bɛ bɛ kweŋɛ lɛ bɛniiŋ li lɛnti.” ");
INSERT INTO asj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Le Jiso tuu ni nuuŋ lɛ kitoŋ ki Bɛtani-i, li Simu wu wi wu chigɔŋ chi nɔŋa yih, ");
INSERT INTO asj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","be shee be jii biee, kwɛɛŋ wumu dza lɛ lu kɛmi mɛɛŋ mamu mɛ sɛɛndi lɛ fika fimu fi bɛ nachɛ bɛ tɛtɛ, me tɛɛmi kwa ŋge, tumi li kikoo ki Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Le bɔɔŋ bɛ Jiso-o bɛ kintutu-u ŋɛŋ lɛ, fiee filu tɔŋ be shéŋ ŋge. Be tee le, “Bifisi mɛɛŋ mɛlu kii la? ");
INSERT INTO asj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bee nuuŋ bɛ kabɛ mɛɛŋ mɛlu li kwa ŋgee, bɛ nyɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Se nuuŋ le, Jiso tɛ̀ kɛɛ mbeechɛ wube, tee li bee le, “Nɛ nyɛɛ ŋgɛ li kwɛɛŋ wuni kii la? Wu fɛɔ nuuŋ fiee fi dzeeŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nɛ ni nɛ kii le bɛniiŋ bɛ kifoo lɛ gii be ni be nuuŋ bɛ beŋ mfi kwi, se nuuŋ le, nuuŋ tɛ nuuŋ tɛɛbeŋ mfi kwi kɛ. ");
INSERT INTO asj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wu shooshɔɔ mɛɛŋ mani li yi yɛɛŋ ni le nachɛ nuuŋ si bɛ gii bɛ diyɛ mi. ");
INSERT INTO asj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ntee beŋ chɛɛŋ le mɔɔ nuuŋ fɛŋ fɛ bɛ gii bɛ ni bɛ tiifi ntoŋ wu dzeeŋ wuni li kikoo ki nshɛ kichu, bɛ gii bɛ ni bɛ tiiti kii fiee fi kwɛɛŋ wuni fɛ bɛ se ni bɛ kiimi wu.” ");
INSERT INTO asj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wi wumu li kintutu ki bɔɔŋ bɛ Jiso bɛ yoofi ntsɔ bɛfɛ baa wu bɛ tɛ̀ teenyi le Judas Iskaliyɔ dza gɛɛŋ ŋɛŋ bɛte muntofi bɛ nɔŋa bɛ nɔŋa, ");
INSERT INTO asj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bii li bee laa, “Ɛ mi nyɛ Jiso li tsaŋ yinɛ-ɛ, nɛ nyɛ mi la?” Be biee be fa bɛ siri mbaanshɛɛ be nyɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mbɛɛchɛ li mfi wɛ, bɛchi wɛki dze yi gii nyɛ Jiso li tsáŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Le ni nuuŋ jobɛ chi ŋkosi chi Tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ kishee le kɛ, bɔɔŋ bɛ kintutu-u bɛ Jiso bɛ fɛ wuu, be bii li wuu laa, “Ɔ wɛki le tɛ gɛɛŋ tɛ nachɛ fɛ ɔ gii ɔ ji Tsɔnɔ chi N'yafuwee chilu nuuŋ fɛŋ?” ");
INSERT INTO asj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tuu li bee le, “Gɛnɛ yɛɛŋ fɛ la nyɔŋa ɛ nɛ ŋɛŋ wi, nɛ tee li mwɛ le, ‘Wi wu Ntiifɛ teeɔ le mfi we kɔchɔɔ. Gii ji Tsɔnɔ chi N'yafuwee bee bɔɔŋ bee bɛ kintutu-u li wɛɛ yih.’” ");
INSERT INTO asj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bɔɔŋ bɛ kintutu-u bɛlu gɛɛŋ be fɛ nɛɛ si Jiso bee tee li bee, be biee be nachɛ biee bijɛ bi Tsɔnɔ chi N'yafuwee chilu lu. ");
INSERT INTO asj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Le ni nuuŋ lɛ fɛmfo-o, shee bee bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ bɛfɛ baa le be ji biee. ");
INSERT INTO asj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Le be ni be jii, dza tee li be le, “Ntee li be-eŋ chɛɛŋ le, wi wumu li be-eŋ linti gii kabɛ mi.” ");
INSERT INTO asj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Si bee tee lɛ, bɔɔŋ bee bɛ kintutu-u dza be to nshiiŋ nshiiŋ, be bɛchi be biiti li wuu mumkpaŋ mumkpaŋ laa, “Nuuŋ bo mi ni Taa?” ");
INSERT INTO asj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tuu li bee le, “Wi wu gii kabɛ mi ɛ wi wu tɛɛ wu gii tɛ bikɛ kibɛnɛ lɛ sho-o. ");
INSERT INTO asj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ŋwanɛwi gii gɛɛŋ nɛɛ fiee si bɛ tɛ̀ tsɛɛ kii wu. Se nuuŋ le, kinlɔɔ kinɔŋa kɛɛ li wi wu kabɛ Ŋwanɛwi-i. Fi tɛ̀ dzɔɔŋ ŋge le gii bɛ ba wu ki biɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas wu tɛ̀ nuuŋ le gii kabɛ Jiso bii tɛ li wuu laa, “Nuuŋ bo mi ni, Wi wu Ntiifɛ?” Jiso tee li wuu le, “Ɔ teeɔ bɛ kimfimɛ ko.” ");
INSERT INTO asj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Si be tɛ̀ jii biee lɛ, Jiso dza dzɔ kibele, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ nyɛ li bɔɔŋ bee bɛ kintutu-u tee le, “Kɔ yɛɛŋ nɛ ji, yini nuuŋ yi yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tuu dzɔ tɛ fika, nyɛ kiyɔɔni li Nyɔ-ɔ nyɛ fika filu li bee tee le, “Wonɛ yɛɛŋ nɛ tasɛ beŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mani nuuŋ ŋgɔŋ meŋ mɛ Nyɔ ji leh lu mɛ bo kii bɛniiŋ ŋgee, le se feeki bibifi bi bee. ");
INSERT INTO asj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ntee beŋ le mɛɛŋ yɛ ntuu ŋ'woŋ mbiiŋ mɛ fiŋgeetɛ fi lɛɛndi mani mbɛɛchɛ dɛɛni, nsiiŋ gɛɛŋ bo jobɛ chi ŋgii naa ŋ'woŋ mɛ fɛŋ tɛɛbeŋ lɛnti lɛ bumfɔŋ bu Baa wɛŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Le Jiso bee bɔɔŋ bee bɛ kintutu-u mɛɛshi, be yoo jumi chi n'yɔɔnchɛ, be dza be michi be giiŋgi li ŋkumɛ wu Biti bi Oli-if. ");
INSERT INTO asj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Si Jiso bee bɔɔŋ bee bɛ kintutu-u tɛ̀ giiŋgi lɛ, dza tee li bee le, “Butuu bu bɛŋ buni beŋ bɛchu gii nɛ chee bikaa lijiŋ kii fiee fi gii fi ka bɛ mi. Fi fiɛɛ si bɛ tɛ̀ tsɛɛ Nyɔ tiiti le, ‘Ŋgii ŋ'wo kiŋkiichɛ nshɔ́ɔŋ kintutu ki nshɔɔŋ lɛ se saaŋgɛ.’ ");
INSERT INTO asj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Se nuuŋ le, mfi wu Nyɔ buu mi li kwe-e, ntoo mbaŋ li be-eŋ Galilii.” ");
INSERT INTO asj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Se Pita biee tee fiee li wuu le, “Ɛ bɛniiŋ bɛchu chee bikaa lijiŋ kii fiee fi gii fi ka bɛ wɛ, ɛ bɛ nyɛ ntɛ chee bikaa lijiŋ tɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiso tee li wuu le, “Ntee wɛ chɛɛŋ le butuu bu bɛŋ buni, nyinɛshee gii ke yi teŋgɔɔ, nuuŋ ɔɔ faaŋ mi kiŋga kitɛɛtɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita tee li wuu le, “Mɔɔ nuuŋ le ŋgii ŋkwi tɛɛ wɛ, nuuŋ bɛ tɛ faaŋ wɛ kɛ.” Si tɛ̀ tee nɛɛ lɛ, bɔɔŋ bɛ kintutu-u bɛ Jiso bamu baa bɛchu tee nɛɛ tɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jiso bee bɔɔŋ bee bɛ kintutu-u gɛɛŋ be lɛ li wɛ wu biti bi muntaaŋ lɛ wumu, wu bɛ teenyi le Gɛsɛmani, tee li bɔɔŋ bee bɛ kintutu baa le, “Shee yɛɛŋ fɛni ŋ'waaki yi fɛŋgooŋ fɛmu nlɛkɛ li Nyɔ-ɔ” ");
INSERT INTO asj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dzɔ Pita bee bɔɔŋ bɛ Dzɛbɛdii bɛ bɛfɛ baa, bee be gɛɛŋ. Se bɛchi nuuŋ nshiiŋ nshiiŋ, shéŋ yee kɛɛti. ");
INSERT INTO asj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Biee tee li bee le, “Shéŋ yɛŋ yɛɛ nshiiŋ nshiiŋ ŋge nuuŋ kɛɛ ŋkwiiɔ. Shɛ yɛɛŋ fɛni nɛ ni nɛ tɛŋgi.” ");
INSERT INTO asj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jiso dza fe kiiŋgi gɛɛŋ limfwe niiŋ, we chiŋ bushi fɛkwiiŋ, lɛki li Nyɔ-ɔ le, “Baa wɛŋ, ɛ dze nuuŋ lu yi nuuŋ nɛɛ ɔ fɛ le fika fi ŋgɛ-ɛ fini ka mi ŋ'wonu siŋ, ɔ fɛ. Se nuuŋ le, kiiŋ ɔ ni fɛ si ŋkɔŋgisi kɛ, fɛrɛ nuuŋ si ɔ kɔŋgisi.” ");
INSERT INTO asj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dza kaari to lijiŋ fɛ bɔɔŋ bee bɛ kintutu, ŋɛŋ si be liiti. Bii li Pita laa, “Fi nuuŋ le ɛ bɛ nyɛ nɛ tɛ shee we bɛ mi le bo si mfi ntaŋ mumkpaŋ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nɛ nuuŋ yɛɛŋ we, nɛ lɛki li Nyɔ-ɔ kii nɛ ni lɛ li mɔnchɛ. Fi nuuŋ chɛɛŋ le shéŋ kɔŋgisi lɔ, se nuuŋ le nyaŋ yi bwiŋ nuuŋ fɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tuu kaari gɛɛŋ kiŋga kifɛ lɛki li Nyɔ-ɔ le, “Baa wɛŋ, ɛ fi nuuŋ le ɛ bɛ nyɛ fika fini tɛ ka fuki fɛ mi ŋ'woŋ siŋ ɔ fɛ nɛɛ si ɔ kɔŋgisi.” ");
INSERT INTO asj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Le tuu kaari to lijiŋ ka ŋɛŋ si bɔɔŋ bee bɛ kintutu-u liiti kifɛ chilefɛ tɛ nuuŋ be lɛ lii ŋge. ");
INSERT INTO asj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tuu ka shɛ be, kaari gɛɛŋ tuu lɛki li Nyɔ-ɔ kiŋga kitɛɛtɛ, lɛki li Nyɔ-ɔ tiiti nɛɛ nuuŋ fiee fi bee saa tiiti fiɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tuu kaari to lijiŋ fɛ bɔɔŋ bee bɛ kintutu tee li bee le, “Nɛ mɛɛŋ baa nɛ liiti nɛ fufini finɛ ni? Bichɛ yɛɛŋ nɛ ŋɛŋ, mfi kɔchɔɔ kituŋ. Bɛ kabɛ baa Ŋwanɛwi li bɛniiŋ bɛ bifi-i. ");
INSERT INTO asj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dza yɛɛŋ we tɛɛbeŋ tɛ ni tɛ giiŋgi. Bichɛ yɛɛŋ nɛ ŋɛŋ wi wu kabɛ mi bɛɛɔ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nɛɛ si Jiso tɛ̀ mɛɛŋ yeti lɛ, Judas wu tɛ̀ nuuŋ wi kintutu ki bɔɔŋ bɛ Jiso bɛ yoofi ntsɔ bɛfɛ baa biee busɛ. Tɛ̀ gii bɛɛ bee kintutu ki bɛniiŋ lɛ kinɔŋa, be kɛmi nyɔ bɛ bimboki, ɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ sɛki kwɛɛŋ bɛ tɛ̀ toŋ be. ");
INSERT INTO asj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wi wu tɛ̀ kabɛ Jiso tɛ̀ nachɛ si gii doonchɛ li bɛniiŋ bɛlu, tee le, “Wi wu mi n'yɛsi wu, mi ŋkokɛ, kɛ ɛ wu, nɛ biee nɛ kɔɔ wu.” ");
INSERT INTO asj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Si bee be tɛ̀ bɛɛ lɛ, biee gɛɛŋ fɛ Jiso mfwaa mumkpaŋ tee li wu le, “Mi n'yɛsɔɔ wɛ Wi wu Ntiifɛ.” Si wu tee lɛ, biee kokɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jiso tee li wu le, “Sinɛŋ, fɛrɛ fiee fi ɔ bɛ le ɔ fɛ.” Bɛniiŋ baa biee be gɛɛŋ fɛ Jiso-o be cha wu. ");
INSERT INTO asj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Fi se ka le wumu wu tɛ̀ nuuŋ bɛ Jiso ɛ tɛ̀ nuuŋ bɛ nyɔ ye yi dziŋ lɛ mbwa-a buu, kɛri kintooŋ ki mfwa wu kikoo ki bɛte muntofi lu, sondɛ. ");
INSERT INTO asj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jiso tee li wi wulu le, “Kaari tuu nyɔ ya lɛ mbwa li. Ɔ kɛɛ le wi kwi wu tsakisi nyɔ li we, gii naa kwi bɛ nyɔ. ");
INSERT INTO asj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɔ beechi le nuuŋ nlee ki nlaŋɛ kɛ le Taa tuumi bɛnchindaa bee fɛni mfwaa mumkpaŋ li bɛnchuki le be gwe kii mi kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Se nuuŋ le, ɛ mi dza mi fɛ lɛ, fi dɛndɛ niŋ fi se bɛ fi kɔchɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ le fi kɛmi le fi nuuŋ?” ");
INSERT INTO asj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Li mfi wɛɛ, Jiso tuu bii li kintutu kɛɛ laa, “Nɛ bɛɛ le nɛ kɔɔ mi nɛ bɛɛ bɛ nyɔ mɔɔ bimboki kɛ nɛɛ bɛɛ le nɛ kɔɔ nuuŋ wi wu bɛɛ bɛ kpɛ li kwɛɛŋ li ni? Ntuu nshiiŋ jo chi nshiiti li yih yi muntofi ntiifi bɛniiŋ lu nɛ tɛ kɔɔ mi kɛ kii la? ");
INSERT INTO asj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Se nuuŋ le, fiee fini fichu kɛti fiɛɛ nɛɛ le fi bɛ fi kɔchɛ si bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ.” Bɔɔŋ bɛ Jiso bɛ kintutu-u bɛchu biee be shɛ wu fɛ, be kifi. ");
INSERT INTO asj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bɛniiŋ bɛ tɛ̀ kɔɔ Jiso dzɔ wu be gɛɛŋ bɛ wu fɛ Kaifas wu te kikoo ki bɛte muntofi-i. Bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ bɛ bɛniiŋ bɛ sɛki kwɛɛŋ banchɛ tɛ fe. ");
INSERT INTO asj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Be tɛ̀ giiŋgi bɛ Jiso Pita biki lɛjiŋ mfiiŋ. Le gɛɛŋ bo fɛ la wu kikoo ki bɛte muntofi-i, tuu lɛ gɛɛŋ shee bɛ bɛniiŋ bɛ tɛ̀ kiichi la wulu le ŋɛŋ si fi gii fi ka. ");
INSERT INTO asj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛchu bɛ sɛki bɛnsa tɛ̀ wɛki fiee fi be gii be sɛɛyɛ be terɛ Jiso le bɛ se wo wu. ");
INSERT INTO asj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Se nuuŋ le, be ti mɛɛŋ ki kɛmɛ kɛ fiee kɛ, bɛniiŋ ŋge buti be bɛɛ limfwe be sɛɛyi binsɛɛ. Si fi tɛ̀ kɛti lɛ bɛniiŋ bamu bɛfɛ bo be leŋ limfwe, ");
INSERT INTO asj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","be tee le, “Bwɛɛ wuni tɛ̀ tiiti le nuuŋ shaanshɛ yih yi muntofi yi Nyɔ kaari gwaŋ li jo taa li.” ");
INSERT INTO asj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kikoo ki bɛte muntofi kɛɛ dza we ki bii li Jiso laa, “Ɔ kɛmi yɛ fiee fi tusɛ kɛ ni? Ɔ wuki nɛɛ biee bi bɛniiŋ bani tiiti kii wɛ ni?” ");
INSERT INTO asj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jiso ba nɛɛ nshiiŋ. Kikoo ki bɛte muntofi kɛɛ tuu ki tee li wuu le, “Tee chɛɛŋ li bukooŋ bu Nyɔ yi kɛmi ntsɛ, ɔɔ nuuŋ kinsofu ki Nyɔ tɛ̀ kaachɛ ki Ŋwanɛ Nyɔ, ɔ tee bee.” ");
INSERT INTO asj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jiso tuu li wuu le, “Fi fiɛɛ sɔɔ tee lɛ. Se nuuŋ le, ntee beŋ le, lɛjiŋ lɛ mfi wuni-i, nɛ gii nɛ ŋɛŋ Ŋwanɛwi, ɛ wu shee lɛ kibɛnɛ ki kigɔŋɛ ki Wi wu kɛmi Buŋga-a, nɛ tuu nɛ ŋɛŋ si bɛɛ li kiku-uŋ liboo.” ");
INSERT INTO asj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kikoo ki bɛte muntofi kɛɛ woo lɛ, ki tuu ki gaamɛ ndú yi ki, ki tee le, “Wu dzɔɔ kintsii ki Nyɔ-ɔ. Fiee nuuŋ yɛ lu fi tɛɛbeŋ tuu geendi le wi leŋ fɛni ni tiiti kɛ? Nɛ woo baa kituŋ si wu dzɔ kintsii ki Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nɛ se sondɛ le la?” Be tuu le, “Ɛ wi wu bɛ nuuŋ bɛ wo.” ");
INSERT INTO asj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Be se bɛchi be kwiyi budii li bushi bu Jiso-o, be juti wu bɛ muŋkɔ, be suŋgi bɛ tsaŋ be tiiti li wuu le, ");
INSERT INTO asj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Wɛ wu nuuŋ Krai, fɛrɛ kintomfɔŋ ko ki Nyɔ dɛɛni li bee li. Tee wi wu sooŋ wɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tɛ̀ nuuŋ ɛ Pita shee lɛkuuŋ la kintikinti. Ŋwaŋ wu kwɛɛŋ wumu wu tɛ̀ nindi fe, dza bɛ li wuu lichiŋ tee li wuu le, “Ɔ bee tɛ nɛɛ Jiso wu Galilii wulu.” ");
INSERT INTO asj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Se nuuŋ le, Pita faaŋ limfwe li bɛniiŋ bɛchu tee le, “Ŋkii yɛ fiee fi ɔ tiiti kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita tuu dza bo gɛɛŋ fɛ fweeŋ wu ntɔ-ɔ. Se ŋwaakwɛɛŋ wumu wu tɛ̀ nindi tɛ fe, ŋɛŋ wu, tuu tee li bɛniiŋ bɛ tɛ̀ nindi fe baa le, “Wi wuni bee nuuŋ bee Jiso wu Nasarɛ wulu.” ");
INSERT INTO asj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita tuu faaŋ, chini, tee le, “Ŋkii yɛ wi wulu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Le mfi tuu kiiŋgi niiŋ, bɛniiŋ bɛ tɛ̀ lemi fe kiiŋgi be gɛɛŋ li Pita lichiŋ be tee li wuu le, “Li chɛɛŋ li, ɔ nuuŋ tɛ wi wu be wumu, kifɛ n'yɔru wa wɛ si wube.” ");
INSERT INTO asj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita tuu faaŋ, teeŋ kinlɔɔ li yi yee li tee le, “Ŋkii yɛ wi wuni kɛ.” Mfwaa mumkpaŋ nyinɛshee biee yi tɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pita kimi n'yɔru wu Jiso bee yɔ li wu le, “Nyinɛshee gii ke yi tɔɔŋ, ɔɔ faaŋ mi kiŋga kitɛɛtɛ.” Se dza fe bo lɛkuuŋ, keeri kwe ŋge. ");
INSERT INTO asj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Le butuu ni bu wuuti, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ, shee be dzɔ ntaŋ kii Jiso le be wo wu. ");
INSERT INTO asj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Be se kaŋ wu, be dzɔ wu be gɛɛŋ be nyɛ li tsaŋ yi Pailɛ-ɛt wu tɛ̀ nuuŋ ŋgɔmina lɛ kimbɛ kilu. ");
INSERT INTO asj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Le Judas wu tɛ̀ kabɛ Jiso ŋɛŋ le bɛ sondɛ baa le bɛ gii bɛ wo wu, kaari shéŋ yee, dzɔ bɛ siri bɛ mbaanshɛɛ baa kaari gɛɛŋ le tuu li bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ baa. ");
INSERT INTO asj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Le gɛɛŋ lɛ, tee li bee le, “Mi mfɛɔ bubiɛɛ le ŋkabɛ wi wu mɛɛŋ ki chɔ kɛ fiee kɛ wuni.” Be se tuu li wu laa, “Fiɛɛ fiee kɛmi la fi fɛrɛ bɛ be le? Ɛ wɛ wu kiiɔ fiɛɛ fiee.” ");
INSERT INTO asj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas se bwaaki kwa wulu fɛkwiiŋ li yih yi muntofi-i, bo gɛɛŋ shiŋ. ");
INSERT INTO asj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa kwachɛ kwa wulu be tee le, “Wuni wɛɛ kwa wu ŋgɔŋ, nchi mɛɛŋɔ ki beŋ kɛ le nuuŋ tɛ gɛɛ wu lɛ ŋko wu kwa wu li yih yi muntofi-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Be shee be dzɔ ntaŋ, be gɛɛŋ be go kintsii li wumu wu tɛ mɛɛ mubee li, le be ni be diiyi mfoŋ fe. ");
INSERT INTO asj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Fiɛɛ fiee fi bɛ teenyi kintsii kilu mbɛ mbochu bɛŋ le, “Kintsii ki ŋgɔ-ɔŋ.” ");
INSERT INTO asj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Fi tɛ̀ ka lɛ le fiee fi ntomfɔŋ wu Nyɔ wu Jeremaya tɛ̀ tee bɛ fi kɔchɛ si tɛ̀ tiiti le, “Be tɛ̀ dzɔ kwa bɛ siri mbaanshɛɛ nuuŋ kwa wee wu bɔɔŋ bɛ Isɛlɛɛ tɛ̀ seesɛ li yi yee li, ");
INSERT INTO asj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","be go kintsii li wi wu mɛɛ mubee li, nɛɛ si Taa Nyɔ tɛ̀ tee li mi-i.” ");
INSERT INTO asj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Si Jiso tɛ̀ leŋ limfwe li Pailɛ-ɛt wu ŋgɔmina wu Lo-om lɛ, Pailɛt bii li wu laa “Ɛ wɛ Mfɔŋ wu Bɛjuu ni?” Jiso tuu le, “Fi fiɛɛ si ɔ tee lɛ.” ");
INSERT INTO asj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Se bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ bɛchi be kayɛ biee li wuu, se tɛ mɔɔ tuu kɛ. ");
INSERT INTO asj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pailɛt tuu bii li wu laa, “Ɔ wuki nɛɛ ŋwaani biee bi bɛ kayi li wɛ-ɛ bini ni?” ");
INSERT INTO asj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Se nuuŋ le, Jiso ti mɛɛŋ fiee li wuu ki tuu kɛ mɔɔ nuuŋ fimumkpaŋ li biee bi be tɛ̀ sɛɛyɛ li yee li biɛɛ kɛ. Le ŋgɔmina wulu ŋɛŋ lɛ wa tɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bɛdɛɛni tɛ̀ nuuŋ li mfi wu Tsɔnɔ chi N'yafuwee, ŋgɔmina wuni tɛ̀ shiiŋ busi wi mumkpaŋ wu bɛniiŋ wɛki li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Le ni nuuŋ li mfi wulu-u, wumu tɛ̀ nuuŋ li yih yi ncha, ɛ be tɛ̀ kii wu kii kiŋge kee ki bifi, bukooŋ bwee tɛ̀ nuuŋ le Baraba. ");
INSERT INTO asj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Le bɛniiŋ bɛ be banchɛ, Pailɛt bii li be laa, “Nɛ wɛki le mbuu nuuŋ noo li yih yi ncha-a? Nɛ wɛki le mbuu Baraba, mɔɔ Jiso wu bɛ teenyi le Kinsofu ki Nyɔ tɛ̀ kaachɛ le?” ");
INSERT INTO asj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tɛ̀ gii biiti lɛ kifɛ tɛ̀ gii kii le be nyɛ baa Jiso li tsaŋ yee li, kii shéŋ tɛ̀ yɛɛti be bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Le ni nuuŋ mfi wu tɛ̀ shee fɛ kintindɛ ki ti shiiti sɛki bɛnsa-a, kwɛsi tuumi ntoŋ li wuu, tee le, “Kiiŋ ɔ ni fɛ fiee bɛ wi wɛɛ kɛ. Ɛ wi wu tsaaŋ. Ntiiti ni kifɛ kifiee ŋwɛɛ kɛɛ bɛ mi butuu bu bɛŋ buni ŋge kii wu.” ");
INSERT INTO asj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Le Pailɛt bii lɛ, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ tɛ̀ kunyi le bɛniiŋ ni be tiiti le buu nuuŋ Baraba, bɛ mɛɛshi bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋgɔmina wɛ dza bii li bee laa, “Wi wu nɛ wɛki le nchinɛ li bɛniiŋ bɛ bɛfɛ bani-i linti nuuŋ noo?” Be tuu le, “Baraba.” ");
INSERT INTO asj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailɛt tuu bii li be laa, “Ɛ mi mbuu lɛ, nse ŋgeeŋ bɛ Jiso wu bɛ teenyi le Kinsofu ki Nyɔ tɛ̀ kaachɛ?” Be bɛchu tee le, “Bɛ taaŋ wu li kintaaŋ li bu tamfu.” ");
INSERT INTO asj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kaari bii laa, “Bɛ taaŋ wu kii la? Fiee fi bifi fi wu fɛ nuuŋ la?” Be tuu be giiŋgi limfwe bɛ dzaŋu le, “Bɛ taaŋ wu li kintaaŋ li.” ");
INSERT INTO asj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Le Pailɛt ŋɛŋ le dze lu kɛ, le ŋkweŋɛ bɛchi chɛ. Dzɔ dzɔɔ, tsootsɛ tsaŋ yee lu li kintutu ki bɛniiŋ lɛ limfwe, tee le, “Tsaŋ yɛŋ nuuŋ yɛ fɛ kwe yi wi wuni-i kɛ. Kiiɔ nuuŋ beŋ.” ");
INSERT INTO asj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bɛniiŋ bɛchu tuu li wuu le, “Iiŋ, gɛɛ ŋgɔŋ mee nuuŋ li bikoo bisɛ-ɛŋ mɔɔ li bɔɔŋ bɛsɛ-ɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pailɛt biee buu Baraba si be tɛ̀ wɛki, tee le be fiaamfiɛ Jiso, tuu nyɛ le be gɛɛŋ be taaŋ wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bɛniiŋ bɛ nchi-i bɛ ŋgɔmina dzɔ Jiso be lɛ bɛ wu lɛntɔ we-e, bintutu bi bɛniiŋ bɛ nchi-i bichu banchɛ bi kɛnɛ Jiso lɛnti. ");
INSERT INTO asj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bi buushɛ wu ndú bi dzɔ ndu yi bumfɔŋ yi yɛchi bi chuumɛ wu li bwiŋ, ");
INSERT INTO asj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","be dzɔ bifafu be lo kifɔ ki bumfɔ-ɔŋ lu be beeŋ wu lifa be tuu be nyɛ wu kimbaaŋ lɛ kibɛnɛ kee ki kigɔŋɛ-ɛ le ki ni ki nuuŋ si kimbaaŋ kee. Be bɛchi be bɛɛ be guundi wu limfwe be choosi wu be tiiti le, “Buri, Mfɔŋ wu Bɛjuu!” ");
INSERT INTO asj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Si be feti lɛ, be kwiyi wu bɛ budii li bwiŋ, be fi kimbaaŋ kɛɛ be tuki wu bɛ ki li fa. ");
INSERT INTO asj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Le be mɛɛshi nchoosɛ wu lɛ, be buu wu ndu yi bumfɔŋ yɛ, be lii wu nuuŋ ndu ye li wuu bwiŋ, be biee be dzɔ wu le be gɛɛŋ be taaŋ wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Si be tɛ̀ giiŋgi lɛ, be busɛ li wi wumu wu li kitoŋ ki Sɛli-iŋ, bukooŋ bwee nuuŋ le Simu. Be kaŋ wi wuni le too kintaaŋ ki Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Be tɛ̀ gɛɛŋ be bo kintsii kimu ki bɛ teenyi le Gɔɔgɔɔta, (Bukooŋ buni nuuŋ le Kintsii ki Kiŋgefi-i,) ");
INSERT INTO asj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","be nyɛ wuu mbiiŋ ɛ bɛ finsɛ bɛ fiee fimu fi lochi si kikurɛ le woŋ. Se nuuŋ le, tɛ mɔŋ, faaŋ ŋ'wonu. ");
INSERT INTO asj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Se be ta wu li kintaaŋ li, be dzɔ ndú yee be toŋ kaŋ lu le be gachɛ li yi yi bee. ");
INSERT INTO asj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Si be tɛ̀ fɛ lɛ, be sheeyɛ fe be kiichi wu. ");
INSERT INTO asj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Be tsɛɛ kiŋwaati ki doonchi fiee fi bɛ ta wu li kintaaŋ li kii fi, be ta fi li kintaaŋ li lɛ kikoo kee li lɛwe le, “Wuni nuuŋ Jiso, Mfɔŋ wu Bɛjuu.” ");
INSERT INTO asj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Be tayɛ tɛ bɛyi bɛfɛ li bintaaŋ li bɛ Jiso, wumu lɛ kibɛnɛ ki kigɔŋɛ-ɛ, wumu lɛ kibɛnɛ ki kimɛsɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bɛniiŋ kɛti be ŋiŋgi Jiso be sɛɛsi bikoo, be tsuki wu bɛ tsooŋ, ");
INSERT INTO asj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","be tiiti le, “Wɛ wu tɛ̀ tiiti le ɛ bɛ shaanshɛ yih yi muntofi ɔ kaari ɔ gwaŋ li jo taa li, sofɛ yi ya! Ɔɔ nuuŋ ŋwanɛ Nyɔ, shee li kintaaŋ kɛɛ li.” ");
INSERT INTO asj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tiifi bɛnchi mɔɔ bɛniiŋ bɛ sɛki kwɛɛŋ tɛ̀ choosi wu be tiiti le, ");
INSERT INTO asj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tɛ̀ gii suuti bɛniiŋ bamu, kɛɛ nuuŋ soo yi yee nsiŋ. Mɔɔ Mfɔŋ wu bɛniiŋ bɛ Isɛlɛɛ. Shee li kintaaŋ li dɛɛni, se tɛ beŋ li wuu. ");
INSERT INTO asj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tɛ̀ nyɛ yi yee li Nyɔ-ɔ. Ɛ Nyɔ kɔŋgisi wu, yi soo wu dɛɛni, si tɛ̀ kweŋgi le nuuŋ ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɛyi bɛ bɛ tɛ̀ ta li bintaaŋ li bɛ Jiso baa, tɛ̀ tsuki wu bɛ ntsooŋ tɛ. ");
INSERT INTO asj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Le nshaaŋ yuusɛ, lɛkuuŋ dza le jiŋ kwɛɛŋ kwikwi, gɛɛŋ bo jobɛ bikaa bitɛɛtu lɛ fɛmfo-o. ");
INSERT INTO asj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Le mfi gɛɛŋ bo si jobɛ bikaa bitɛɛtu, Jiso dza waŋ lɛwe ŋge le, “Hɛli, Hɛli, lama sabatani.” Fi nuuŋ le, “Nyɔ yɛŋ, Nyɔ yɛŋ, ɔ lɔŋ mi ni kii la?” ");
INSERT INTO asj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bɛniiŋ bamu bɛ tɛ̀ lemi fe woo lɛ, be tee le, “Wi wuni teenyɔɔ Ɛlaja.” ");
INSERT INTO asj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wi wu be wumu letɛ mfwaa mumkpaŋ dzɔ kifiiŋ, fooŋ li mbiiŋ mɛ mgbanyi, sɔ li fintiiŋ li, nɛɛki le woŋ. ");
INSERT INTO asj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Se nuuŋ le, bɛniiŋ bamu tee le, “Tɛ leŋ kwɛ, tɛ ŋɛŋ laa Ɛlaja gii bɛ soo wu le!” ");
INSERT INTO asj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jiso ka waŋ lɛwe ŋge, nyɛ fiana yee li tsaŋ yi Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Fi dza fi ka le, ndu yi tɛ̀ gatini yih yi muntofi lɛnti tɛ dza yi batɛ kintikinti, mbɛɛchɛ fɛ we mbɔɔwu mbochu fɛkwiiŋ li biŋkɛ bifɛ. Nshɛ sɛɛsɛ, bimbaŋ weyɛ, ");
INSERT INTO asj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","dzíŋ gwiyɛ, se bɛniiŋ bɛ tɛ̀ kwiyɛ lɛ dze yi Nyɔ-ɔ ŋge kaari be bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Le Jiso bo li kwe-e, bɛniiŋ bɛlu dza be gɛɛŋ li kitoŋ ki wuuti Jɛrosalɛŋ bɛniiŋ ŋge ŋɛŋ be. ");
INSERT INTO asj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Le te kikoo wu bɛniiŋ bɛ nchi-i, bɛ bɛniiŋ bɛ bee be tɛ̀ nuuŋ fe be kiichi Jiso baa tuu be ŋɛŋ tɛ si nshɛ sɛɛsɛ, bɛ biee bichu bi tɛ̀ kɛti, chɛnɛ kɔɔ be ŋge. Be tee le, “Chɛɛŋ, chɛɛŋ wi wuni tɛ̀ nuuŋ Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bukɛɛŋ ŋge tɛ̀ lemi tɛ fe mfiiŋ be bichi. Bukɛɛŋ bani tɛ̀ gii be nuuŋ bɛ tɛ̀ dza Galilii be biki Jiso, be fii wu. ");
INSERT INTO asj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lɛ bee lɛnti tɛ̀ nuuŋ, Maariya Madaliŋ mɔɔ Maariya wu ni Jeeŋ bee Jɔsɛ, mɔɔ ni bɔɔŋ bɛ Dzɛbɛdii. ");
INSERT INTO asj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Le ni nuuŋ lɛ fɛmfo-o, wi wu biee wumu wu Arimatia dza bɛ bukooŋ bwee tɛ̀ nuuŋ le Jɔsɛ. Tɛ̀ nuuŋ wi kintutu ki Jiso wumu. ");
INSERT INTO asj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Gɛɛŋ ŋɛŋ Pailɛt, lɛkɛ le nyɛ gwini chi Jiso le gɛɛŋ diyɛ. Nɛɛ lɛ Pailɛt tee le, be gɛɛŋ be nyɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jɔsɛ fi gwini chilu biee fiɛmɛ fɛ ndu yi wuuti-i, ");
INSERT INTO asj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","gɛɛŋ giiki lɛ dziŋ yi tɛ̀ mɛɛŋ fiɛŋ, yi bɛ tɛ̀ chɔ lɛ kimbaŋ, se biiŋgi tɛtɛ chi nɔŋa chi banyɛ fweeŋ wu dziŋ yilu, dza. ");
INSERT INTO asj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maariya Madaliŋ bɛ Maariya wumu wɛ tɛ̀ nuuŋ fe, be shee li dziŋ yilu lichiŋ kibɛɛ. ");
INSERT INTO asj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Le butuu woo, ɛ jobɛ chi be tɛ̀ shiiŋ be nachi biee kii bu bɛshiinshi bɛ chi ka, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ Bɛfarasii gɛɛŋ be ŋɛŋ Pailɛt, ");
INSERT INTO asj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","be tee li wuu le, “Wi wu nyɔŋa, tɛ kimi baa fiee fi wi wu binsɛɛ wɛ tɛ̀ tiiti mfi wu tɛ̀ mɛɛŋ lu. Tɛ̀ tee le, gii ni nuuŋ jo taa kaari bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Si fi tɛ̀ nuuŋ lɛ, se tee bɛniiŋ le be gɛɛŋ be ni be kiichi dziŋ nsiiŋ gɛɛŋ bo jo taa, kifɛ tɛ chɛndi baa le bɔɔŋ bee bɛ kintutu gii be dza be gɛɛŋ be yi gwini chee be tuu be ni be tiiti li bɛniiŋ li le, ‘Wu boɔ li kwe-e.’ Ɛ be fɛ lɛ, binsɛɛ bi bee bi dɛɛni yaa bi ŋkosi.” ");
INSERT INTO asj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailɛt se tee li bee le, “Dzɔɔ yɛɛŋ bɛniiŋ bɛ nchi-i nɛɛ be nɛ gɛɛŋ, nɛ tee le be ni be kiichi dziŋ yilu bujɔŋ si nuuŋ be kiichɛ.” ");
INSERT INTO asj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nɛɛ lɛ, be se gɛɛŋ be bɔsɛyi be bɛŋɛ fweeŋ wu dziŋ yilu, be fɛ ŋkiki li tɛtɛ chi bɛ tɛ̀ baŋɛ fweeŋ wu dziŋ yilu chɛɛ, be gɛɛ bɛniiŋ bɛ nchi le be ni be kiichi. ");
INSERT INTO asj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Le jobɛ chi bɛshiinshi bɛ chi ka, le butuu ni bu wuuti, nuuŋ jobɛ chi ŋkosi li fuu li, Maariya Madaliŋ bee Maariya wumu wɛ gɛɛŋ le be bichɛ lɛ dziŋ. ");
INSERT INTO asj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Fi se ka le, nshɛ tɛ̀ dza yi sɛɛsɛ bɛ buŋga, kifɛ nchindaa wu Taa tɛ̀ shee liboo bɛ biiŋgi tɛtɛ chi bɛ tɛ̀ baŋɛ fweeŋ wu dziŋ yɛɛ lu, se shee li chi-i liwe. ");
INSERT INTO asj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nchindaa wulu tɛ̀ gii nuuŋ ɛ bushi bwee miɛŋini si dzaaŋ ti lɛɛbi lɛ, ndu yee tɛ̀ nɛŋgi ncherere si kikuŋ. ");
INSERT INTO asj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bɛniiŋ bɛ tɛ̀ kiichi dziŋ baa ŋɛŋ lɛ, be chɛŋ ŋge, be kɛɛti ni kikiki, be weyɛ fɛkwiiŋ be gimɛ si gooŋ yi bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nchindaa wu Nyɔ wulu tee li bukɛɛŋ baa li le, “Kiiŋ nɛ ni nɛ chɛndi kɛ. Ŋkiiɔ le nɛ wɛki baa nuuŋ Jiso wu bɛ tuu bɛ ta li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mɛɛŋ yɛ fɛni kɛ, wu bo ɔ li kwe-e kituŋ si tɛ̀ tiiti lɛ. Bɛ yɛɛŋ nɛ ŋɛŋ fɛ tuu gimi fe. ");
INSERT INTO asj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gɛnɛ yɛɛŋ tsɛkɛtsɛkɛ nɛ tee li bɔɔŋ bee bɛ kintutu-u le wu boɔ li kwe-e, le wu tooɔ mbaaŋ limfwe li bee giiŋgi Galilii. Nɛ gii nɛ ŋɛŋ wu le. Yikɛ yɛɛŋ nɛ woo mi nteeɔ beŋ.” ");
INSERT INTO asj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bukɛɛŋ baa biee be dza fɛ dziŋ fɛlu tsɛkɛtsɛkɛ jaaŋ nuuŋ bɛ be, se nuuŋ le, be tɛ kɛmɛ kinɛɛtinɛ kinɔŋa, be letini be giiŋgi le be gɛɛŋ be tee li bɔɔŋ bɛ Jiso bɛ kintutu. ");
INSERT INTO asj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Si bɛ tɛ mɛɛŋ be giiŋgi lɛ, fi ka le Jiso tɛ bikɛ bɛ be, tee li bee le, “Mi n'yɛsɔɔ beŋ.” Be bɛ li wu lichiŋ, be we be kɛmɛ wu li bikaa li, be boŋ wu. ");
INSERT INTO asj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jiso se tee li bee le, “Kiiŋ nɛ ni nɛ chɛndi kɛ. Gɛnɛ yɛɛŋ nɛ tee li bɛŋwaanɛŋ le be ni be giiŋgi Galilii ɛ le lɛ be gii be ŋɛŋ mi.” ");
INSERT INTO asj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Fɛ bukɛɛŋ baa tɛ dza be giiŋgi lɛ, fi se ka le bɛniiŋ bɛ nchi-i bɛ tɛ kiichi dziŋ baa tɛ dza be gɛɛŋ fɛ kito-oŋ, le be gɛɛŋ be tee fiee fichu fi tɛ ka li bɛte muntofi bɛ nɔŋa bɛ nɔŋa-a. ");
INSERT INTO asj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bɛte muntofi bɛlu konchɛ bɛniiŋ bɛ sɛki kwɛɛŋ bee be shee be cho ntaŋ, be nyɛ kwa ŋge li bɛniiŋ bɛ nchi baa, ");
INSERT INTO asj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","be tee li bee le, “Nɛ tiiti li bɛniiŋ li le, bɔɔŋ bee bɛ kintutu bɛ baa butuu be yi gwini chee be gɛɛŋ bɛ chi mfi wu tɛ tuu tɛ liiti. ");
INSERT INTO asj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ɛ nɛ tiiti lɛ, ke fi lɛ li bintooŋ bi ŋgɔmina, ɛ wɛki le nyɛ ŋgɛ li be-eŋ, tɛ nachɛ bɛ wu, tɛ tuu le lii beŋ li ŋgɛ-ɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bɛdɛɛni be fi kwa wulu be fɛ nɛɛ si bɛ tɛ tee li bee lɛ. Binsɛɛ kii le bɛ tɛ yi gwini chi Jiso tɛ saaŋgɛ bi gɛɛŋ li bini bi Bɛjuu lɛ bɛ tiiti nsiŋ bɛ bo bɛŋ. ");
INSERT INTO asj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bɔɔŋ bɛ kintutu bɛ Jiso-o bɛ yoofi ntsɔ mumkpaŋ baa dza be gɛɛŋ Galilii, be yɛɛ li ŋkumɛ wu Jiso tɛ tee be. ");
INSERT INTO asj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Le be gɛɛŋ be ŋɛŋ wu fe, be guumɛ be boŋ wu. Se nuuŋ le, bamu mɛŋɛ wu. ");
INSERT INTO asj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jiso se kiiŋgi bɛ li bee lichiŋ tee li bee le, “Baa wɛŋ nyɛɔ buŋga li mi-i buchu bu liboo mɔɔ bu laaŋkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bɛdɛɛni, gɛnɛ yɛɛŋ li bitoŋ bichu-u, nɛ fɛ bɛniiŋ ni be nuuŋ bɛniiŋ beŋ bɛ kintutu, nɛ ni nɛ lisi be li dzɔɔ, li bukooŋ bu Baa wɛŋ bɛ bu Ŋwaaŋ mɔɔ bu Fiana yi Waaŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nɛ tiifi be le be ni be feti fiee fichu fi ntɛ̀ ntee li be-eŋ. Yikɛ yɛɛŋ nɛ woo, ŋgii ni nuuŋ bɛ beŋ mfi kwi gɛɛŋ bo li mfi wu ntsɛ wu li nshɛ yini-i gii ma.”");
INSERT INTO asj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wuni nuuŋ ntoŋ wu dzeeŋ wu kii Jiso Krai wu Ŋwanɛ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Fi tɛ̀ bɛchi nɛɛ si Ɛsaya wu ntomfɔŋ wu Nyɔ tɛ̀ tsɛɛ le Nyɔ tiiti yɛ le, “Yikɛ ɔ woo, ŋgii ntuumi wi wɛŋ wu ntoŋ ni tuuti mbaaŋ li wɛ-ɛ, gii gɛɛŋ nachɛ dze ya. ");
INSERT INTO asj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jɛ yi wi dii yɛ libuka le bɛ nachɛ dze yi Taa, bɛ leeki yi ni yi nuuŋ tsaaŋ.” ");
INSERT INTO asj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bɛdɛɛni, wi wumu wu bɛ tɛ̀ teenyi le Jɔɔŋ Nlisulidzɔɔ tɛ̀ dza busɛ libuka, fenjisi li bɛniiŋ li le be fiiki shéŋ yibe, lii be li dzɔɔ Nyɔ se feeki bibifi bi bee. ");
INSERT INTO asj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bɛniiŋ se tɛ̀ dzɛti li bitoŋ bi kwɛɛŋ wu Judiya kwikwi mɔɔ li kitoŋ ki Jɛrosalɛ-ɛŋ kichu be giiŋgi lɛ Jɔɔŋ li, be teyi bibifi bi bee, se lisi be li dzɔɔ, li Dzɔɔ yi Joodaaŋ. ");
INSERT INTO asj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔɔŋ tɛ̀ lisi ndú yi bɛ nachɛ bɛ dzúŋ yi nyaŋ yimi yi bɛ teenyi le kamɛɛ, tɛ̀ kɛndi kitsaa litiŋ ɛ bɛ nachɛ bɛ dzi yi nyaŋ, jii nuuŋ tsóma bɛ ŋgɔɔ yi litɔɔ. ");
INSERT INTO asj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tɛ̀ gii fenjisi lɛ, tiiti le, “Wumu bɛɛɔ lɛ mi-i jiŋ wu ko wu yaa mi, mɛɛŋɔ mɔɔ ki kɔchɛ kɛ le ŋguumɛ mfanchɛ bikpɔ biee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nlisɔɔ beŋ nuuŋ li dzɔɔ, se nuuŋ le, gii lii fiee beŋ nuuŋ li tsaŋ yi Fiana yi Waaŋ li.” ");
INSERT INTO asj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nɛɛ li jo yɛɛ, Jiso dza Nasarɛ kimbɛ ki Galilii, bɛ Jɔɔŋ lii wu li dzɔɔ, li Dzɔɔ yi Joodaaŋ. ");
INSERT INTO asj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɛɛ si Jiso tɛ̀ buti li dzɔɔ ni, biee ŋɛŋ si kiboo gwiyɛ, Fiana yi Waaŋ shiiti yi bɛɛ li wuu bwiŋ si kibimɛ. ");
INSERT INTO asj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jɛ se yɔ liboo le, “Ɔ nuuŋ Ŋwanɛŋ wu shéŋ, ŋ'wuki bujɔŋ bɛ wɛ ŋge.” ");
INSERT INTO asj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Fiana yi Waaŋ biee yi fɛ mfwaa mumkpaŋ Jiso gɛɛŋ tsiiŋ libuka. ");
INSERT INTO asj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tɛ nuuŋ lu li jo mbaanyɛɛ li, Sataŋ mɔnchi wu. Tɛ nuuŋ lu lɛ, bɛ nyáŋ yi tɔɔ, bɛnchindaa bɛ Nyɔ-ɔ bichi lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bɛ tɛ̀ dza bɛ kɔɔ Jɔɔŋ bɛ gɛɛ li yih yi ncha-a. Le ni nuuŋ lɛjiŋ lɛlu, Jiso gɛɛŋ Galilii, fenjisi ntoŋ wu dzeeŋ wu kii Nyɔ le. ");
INSERT INTO asj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tɛ̀ bɛchi fenjisi, tiiti le, “Mfi kɔchɔɔ, bumfɔŋ bu Nyɔ-ɔ bwɛɛ tsɛkɛtsɛkɛ. Fiiki yɛɛŋ shéŋ yinɛ, nɛ beŋ li ntoŋ wu dzeeŋ wuni-i.” ");
INSERT INTO asj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jiso dza le ni kɛti li Libɛ chi Galilii lichiŋ, ŋɛŋ Simu bee ŋwaani wu Andolo be lendi gwii lɛ libɛ-ɛ, ɛ nimɛ chi bee tɛ nuuŋ nsúuŋ yi kɔfɛ. ");
INSERT INTO asj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jiso tee li bee le, “Biee yɛɛŋ mi mfɛ nɛ ni nɛ keeti nuuŋ bɛniiŋ.” ");
INSERT INTO asj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mfwaa mumkpaŋ, be biee be chinɛ gii yibe fe, be biki wu. ");
INSERT INTO asj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jiso tuu kiiŋgi gɛɛŋ limfwe niiŋ, ŋɛŋ Jeeŋ bee ŋwaani wu Jɔɔŋ, bɛ tɛ̀ nuuŋ bɔɔŋ bɛ Dzɛbɛdii, bee be nuuŋ lɛ ŋgo-o be tuushi gii yi nsúuŋ. ");
INSERT INTO asj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jiso se tuu teeŋ tɛ be. Be shɛ tee wu be lɛ ŋgo bɛ bɛniiŋ bɛ be tɛ̀ dzɔ le be ni be nindi li bee, be se biee wu. ");
INSERT INTO asj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jiso bee be se dza be gɛɛŋ li kitoŋ ki Kapanu-uŋ. Le ni nuuŋ jobɛ chi bɛshiinshi, Jiso se biee gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ tiifi bɛniiŋ lu. ");
INSERT INTO asj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bɛniiŋ wuki, wa tii be bɛ ntiifɛ we, kifɛ tɛ tiifi si wi wu kɛmi buŋga bu ntiifɛ-ɛ. Tɛ̀ gii tiifi yɛ si bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ ti shiiŋ be tiifi lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nɛɛ li mfi wulu-u, wumu tɛ dza fɛsi li yih yi nlɛkɛ li Nyɔ-ɔ yilu-u, ɛ tɛ̀ nuuŋ wi wu fiana yi tii tɛ̀ nuuŋ wu libwiŋ. ");
INSERT INTO asj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Le lɛ lu, biee waŋ le, “Jiso wu Nasarɛ, ɛ la fi ɔ wɛki le ɔ fɛ bɛ bee? Ɔ bɛ le ɔ lɛɛshɛ bee ni? Ŋkiiɔ wi wu nuuŋ wɛ. Ɛ wɛ wi wu Waaŋ wu dza fɛ Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jiso waŋ fiana yi tii yilu, tee le, “Makɛ, bo li wi wuni-i!” ");
INSERT INTO asj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Fiana yi tii yilu se fɛ wu we fɛkwiiŋ kakini, yi waŋ lɛwe ŋge, yi se bo li wuu bwiŋ. ");
INSERT INTO asj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Le bɛniiŋ ŋɛŋ lɛ, bimfimu wondɛ be, be bɛchi be tiiti li yi yi bee, be biiti laa, “Fini nuuŋ la? Ɛ ntiifɛ wumu wu fwɛŋ ni? Wi wuni kɛmɔɔ buŋga bu wanɛ mɔɔ fiana yi tii yi wuki li wuu.” ");
INSERT INTO asj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mfwaa mumkpaŋ, ntoŋ wu kii Jiso saaŋgɛ gɛɛŋ bintsii bichu bi li kimbe ki Galilii. ");
INSERT INTO asj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jiso bo li yih yi nlɛkɛ li Nyɔ-ɔ yilu-u, gɛɛŋ li yih yi Simu bee Andolo-o, ɛ Jeeŋ bee Jɔɔŋ tɛ̀ nuuŋ bee be. ");
INSERT INTO asj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tɛ̀ nuuŋ ɛ mwɛsɛ Simu tɛ̀ gimi lu, gendi bɛ kiŋkɛŋkɛ. Nɛɛ si Jiso tɛ̀ lɛ li yih yilu lɛ, be biee be tee wu kii kwɛɛŋ wulu. ");
INSERT INTO asj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jiso gɛɛŋ fɛ tɛ̀ gimi fɛɛ, kɛmɛ wu li kibɛnɛ-ɛ, tsaaki wu we. Kiŋkɛŋkɛ kɛɛ se biee ki chikɛ li wuu, dza we, bichɛ fiee fijɛ nyɛ be. ");
INSERT INTO asj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Le ni nuuŋ lɛ fɛmfo-o booyaa jobɛ sechi, be tuu be bɛɛ bɛ bɛniiŋ bɛchu bɛ tɛ̀ gendi mɔɔ bɛniiŋ bɛ bɔɔŋ bɛ kiŋkundi-i tɛ̀ ŋwɛki bɛ be lɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kitoŋ kilu kichu se banchɛ lɛ fweeŋ. ");
INSERT INTO asj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wɔnchɛ bɛniiŋ ŋge bɛ tɛ̀ kɛmi chigɔŋ chichi chichi, tuu bushi tɛ bɔɔŋ bɛ kiŋkundi-i ŋge li bɛniiŋ bamu-u. Ɛ busi lɔɔ, tɛ beŋ le bɛnchindaa bɛlu ni be yeti kɛ, kifɛ be tɛ̀ kii wi wu tɛ nuuŋ wu. ");
INSERT INTO asj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Le ni mɛɛŋ fɛŋwɛɛ taantaaŋ lɛkuuŋ mɛɛŋ fiii Jiso dza we, bo gɛɛŋ fɛ kintsii kimu wuu mbiiŋ lɛki li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simu bee bɛniiŋ bɛ bee be tɛ̀ nuuŋ, shɛ be bo be gɛɛŋ le be gɔɔŋ wu. ");
INSERT INTO asj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Be gɛɛŋ be ŋɛŋ wu, be tee li wuu le, “Bɛniiŋ bɛchu bee be shɛ be wɛki wɛ.” ");
INSERT INTO asj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jiso tuu fiee li bee le, “Tɛ lenchi tɛ gɛɛŋ li bitoŋ bimu nse mfeenji tɛ jɛ yi Nyɔ le. Ɛ fiee fi ntɛ̀ mbɛ kii fi.” ");
INSERT INTO asj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Se deŋgi kimbe ki Galilii kichu fenjisi jɛ yi Nyɔ li yíh yi nlɛkɛ li Nyɔ-ɔ yibee, buushi bɔɔŋ bɛ kiŋkundi-i li yí yi bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wumu wu tɛ̀ gendi bɛ chigɔŋ chi nɔŋa tɛ̀ dza bɛ toŋ núŋ Jiso limfwe, lɛki wu tiiti le, “Ɔ nuuŋ nɛɛ ɔ wɔnchɛ mi ni ŋ'wuuti, ɔɔ kɔŋgisi lɔ.” ");
INSERT INTO asj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nshiiŋ kɔɔ Jiso, nɛɛki kibɛnɛ koŋ li wuu, tee li wuu le, “Ŋkɔŋgisɔɔ, tɛmi lɛ, ɔ ni ɔ wuuti.” ");
INSERT INTO asj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mfwaa mumkpaŋ, chigɔŋ chi nɔŋa chilu biee chi chinɛ li wuu, tɛmi, woo. ");
INSERT INTO asj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jiso se tee li wuu le ni giiŋgi, bɔsɛyi chiinsɛ li wuu, ");
INSERT INTO asj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","tee le, “Ŋɛŋ le kiiŋ ɔ ni tee li wi-i kɛ. Se nuuŋ le, gɛnɛ ɔ doonchɛ yi ya li te muntofi-i, ɔ se nyɛ nya yi Mɔɔsɛ tɛ̀ tiiti le wi kɛmi le nyɛ le doonchɛ li bɛniiŋ li le wu tɛmɔɔ li chigɔŋ chini-i wuuti.” ");
INSERT INTO asj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Si Jiso chiinsɛ lɛ, wi wulu se tuu gɛɛŋ yaki fiee filu. Ntoŋ wulu se saaŋgɛ, dze foo yi Jiso nuuŋ tuu ni lii li kito-oŋ gbanaa. Se ba fiee nuuŋ litɔɔ, bɛniiŋ dzɛti li bitsii li, li bitsii li, be bɛɛ lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Le jo ka niiŋ, Jiso kaari to lijiŋ Kapanuŋ. Bɛniiŋ woo le wɛ fɛkuuŋ kituŋ, ");
INSERT INTO asj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","be banchɛ be bɛ fe ŋge, dze foo yi nuuŋ wi tɔmi kikaa mɔɔ nuuŋ fweeŋ, se fenjisi jɛ yi Nyɔ li bee. ");
INSERT INTO asj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bɛniiŋ bamu dza be bɛɛ be bɛnɛɛ bɛ wi wumu ɛ be sumɛ wu fɛ kida-aŋ, ɛ ŋgwɛ tɛ̀ kɔɔ wu kimbɛ kimumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Fi yaa be fɛ nuuŋ be gɛɛŋ bɛ wu fɛ Jiso-o kifɛ bɛniiŋ tɛ̀ yiŋgɛ fe ŋge. Be se beeŋ nuuŋ lɛ yi-ih lɛwe, be tɔ kiyɛ. Le be tɔ lɛ, be shiiki wi wulu fɛ fiee fi tɛ̀ gimi fe fiɛɛ. ");
INSERT INTO asj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jiso ŋɛŋ si be gɛɛ shéŋ li wuu, se tee li wi wu ŋgwɛ tɛ̀ wu kɔɔ kimbɛ kimumkpaŋ wɛ-ɛ le, “Sinɛŋ, mi mfeekɔɔ bibifi bio.” ");
INSERT INTO asj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bɛniiŋ bamu bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ bɛ tɛ̀ shee yɛ fe be wuki se bɛchi be ŋuŋini lɛ shéŋ lɛ shéŋ, be biiti laa, ");
INSERT INTO asj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wi wuni tiiti ni, kii la? Dzetɔɔ kintsii ki Nyɔ-ɔ. Ɛ noo wu nuuŋ feeki bibifi fuki Nyɔ nsiŋ?” ");
INSERT INTO asj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jiso biee kɛɛ li shéŋ yee li fiee fi be tɛ̀ beechi, bii li bee laa, “Nɛ kɛmi ŋwaani bani bɛmbeechɛ li shéŋ yinɛ ni kii la? ");
INSERT INTO asj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Fi tsɛkɛ fi tefɛ li wi wuni nuuŋ fi la? Ɛ ntefu le mi mfeekɔɔ bibifi biee mɔɔ le dzɔ kidaŋ kee ni giiŋgi le? ");
INSERT INTO asj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Se nuuŋ le, ŋgii mfɛ nɛ kɛɛ le Ŋwanɛwi kɛmi buŋga laaŋkwiiŋ bu fekisɛ bibifi.” Le tee lɛ, biee tee li wi wu ŋgwɛ tɛ̀ kɔɔ wu wɛ-ɛ le, ");
INSERT INTO asj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Dza we ɔ dzɔɔ kidaŋ ko ɔ ni ɔ giiŋgi li yih.” ");
INSERT INTO asj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Se dza we, dzɔ kidaŋ kee buti bɛniiŋ bɛchu bichi wu. Le be nɛŋ lɛ, bimfimu wondɛ be, be bɛchi be yɔɔnchi Nyɔ, be tiiti le, “Tɛ̀ mɛɛŋ baa saa ki ŋɛŋ kɛ ŋwaani fini fiee kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiso tuu dza gɛɛŋ li libɛ-ɛ lichiŋ, kintutu ki bɛniiŋ lɛ bɛ fe, bɛchi tiifi be. ");
INSERT INTO asj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Le dza ni giiŋgi, ŋɛŋ Lebi wu ŋwanɛ Afiyus, ɛ wu shee fɛ kintsii kee ki nimɛ-ɛ, kundi kiŋwaati. Jiso tee li wuu le, “Ɔ biki mi!” Dza we biki wu. ");
INSERT INTO asj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jiso bee bɔɔŋ bee bɛ kintutu gɛɛŋ be jii biee li Lebi yih bɛ bɛniiŋ bɛ tɛ̀ kundi kiŋwaati mɔɔ bɛniiŋ bamu bɛ bifi. Ŋwaani bani bɛniiŋ tɛ̀ shiiŋ be biki wu ŋge. ");
INSERT INTO asj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bɛfarasii bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ ŋɛŋ si Jiso jii biee bee bɛniiŋ bɛ bifi mɔɔ bɛ tɛ̀ kundi kiŋwaati, be se bii li bɔɔŋ bee bɛ kintutu-u laa, “Ɛ kii la fi jii biee bee bɛniiŋ bɛ kundi kiŋwaati mɔɔ bɛniiŋ bɛ bifi bamu?” ");
INSERT INTO asj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Le Jiso woo si be bii lɛ, tee li bee le, “Bɛniiŋ bɛ tɛɛmi ti wɛki yɛ wi wu ntsi kɛ. Ɛ bɛniiŋ bɛ gendi bɛ ti wɛki. Mɛɛŋɔ ki mbɛ kɛ le nteeŋ nuuŋ bɛniiŋ bɛ nuuŋ tsaaŋ kɛ. Mi mbɛ le nteeŋ nuuŋ bɛ bifi.” ");
INSERT INTO asj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tɛ nuuŋ mfi wumu ɛ bɔɔŋ bɛ Jɔɔŋ lɛ bɛ kintutu-u, mɔɔ bɛ Bɛfarasii tɛ̀ jiti biee. Bɛniiŋ bamu tuu be bɛ be bii li Jiso laa, “Fi geeŋ fi bɔɔŋ bɛ kintutu-u bɛ Jɔɔŋ lɛ, mɔɔ bɛ Bɛfarasii jiti biee, se bɔɔŋ bo bɛ kintutu-u tɛ ji tɛ kɛ?” ");
INSERT INTO asj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jiso tuu li bee le, “Nuuŋ bɛ teeŋ bɛniiŋ fɛ bugoo li be gɛɛŋ be tuu be ni be jiti biee nyuŋ wutso mɛɛŋ bee be ni? Nuuŋ be tɛ ji biee bijɛ fɛ mɛɛŋ bee be kɛ. ");
INSERT INTO asj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Se nuuŋ le, mfi gii naa bɛ wu bɛ gii bɛ fi nyuŋ wutso wulu li bee, be se bɛchi be ni be jiti biee bijɛ li mfi wulu-u. ");
INSERT INTO asj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nuuŋ wi tɛ dzɔ shɛŋgɛ yi ndu yi fiɛŋ le tuushɛ ndu yi fichi lu kɛ. Ɛ wu fɛ lɛ, nshɛŋgɛ yi ndu yilu mɛɛshi yi gaamɛ ndu yi fichi yilu bu gaamɛ, fiooŋ yi nuuŋ fe se mɛɛshi yi ko yi yaa si yi tɛ saa yi nuuŋ. ");
INSERT INTO asj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nuuŋ wi tɛ gɛɛ mbiiŋ mɛ fɛŋ lɛ kibɛɛŋ ki bɛ nachɛ bɛ dzi yi nyaŋ, yi kɔɔ yi doŋ kɛ. Ɛ wu fɛ lɛ, mbiiŋ mɛ fɛŋ mɛlu wo kibɛɛŋ ki fichi kilu, mbiiŋ bɛ kibɛɛŋ kilu la li yee li. Fi chɛɛŋ fiɛɛ le, bɛ kɛmi le bɛ gɛɛ mbiiŋ mɛ fɛŋ nuuŋ lɛ kibɛɛŋ ki fɛ-ɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tɛ̀ nuuŋ jobɛ chi bɛshiinshi chimu, Jiso bee bɔɔŋ bee bɛ kintutu-u tɛ̀ deŋgi be kɛti li wɛ wu giiŋ wumu-u. Bɔɔŋ bee bɛ kintutu-u bɛchi be soomi bikoo bi giiŋ lɛ be jii. ");
INSERT INTO asj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bɛfarasii ŋɛŋ lɛ, be bii li Jiso laa, “Bichɛ ɔ ŋɛŋ, fi geeŋ fi bɔɔŋ bo bɛ kintutu-u feti fiee fi nchi mɛɛŋ ki be-eŋ le wi fɛ jobɛ chi bɛshiinshi kɛ?” ");
INSERT INTO asj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jiso bii tɛ li bee laa, “Nɛ mɛɛŋ baa saa ki teeŋ kɛ lɛ Kiŋwaati ki Nyɔ-ɔ si dzeeŋ tɛ̀ wuu Mfɔŋ Daafi bee bɛniiŋ bee fɛ ni? ");
INSERT INTO asj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tɛ̀ nuuŋ mfi wu Abiata tɛ̀ nuuŋ kikoo ki bɛte muntofi-i, Daafi lɛ li yih yi Nyɔ-ɔ dzɔ kibele ki bɛ tɛ̀ tsaa bɛ gɛɛ le ɛ ki Nyɔ-ɔ ki te muntofi tɛ̀ nyɛ wu, ji nyɛ mɔɔ bɛniiŋ bee, ɛ tɛ̀ nuuŋ nchi le nuuŋ wi tɛ ji kibele kilu fuki bɛte muntofi nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jiso se mɛɛshi tee li bee le, “Nyɔ tɛ̀ gɛɛ jobɛ chi bɛshiinshi kii wi. Tɛ̀ mɛɛŋ ki tɔŋ kɛ wi kii jobɛ chi bɛshiinshi kɛ. ");
INSERT INTO asj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Se nuuŋ le, Ŋwanɛwi nuuŋ Te Kikoo wu bwɛɛshiinshi.” ");
INSERT INTO asj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiso tuu gɛɛŋ lɛ li yih yi nlɛkɛ li Nyɔ-ɔ. Wi wumu tɛ̀ nuuŋ lu ɛ ŋgwɛ kɔɔ wu li kibɛnɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bɛniiŋ bamu tɛ̀ nuuŋ lu be wɛki fiee fi nuuŋ be kayɛ li Jiso-o nsiŋ, be se toŋ lii li wuu be bichi laa gii wɔnchɛ wi wulu jobɛ chi bɛshiinshi le. ");
INSERT INTO asj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jiso se tee li wi wu ŋgwɛ tɛ̀ kɔɔ wu wɛɛ le, “Dza we ɔ bɛ fɛni.” ");
INSERT INTO asj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Le mwɛ bɛ, Jiso bii li bɛniiŋ li laa, “Fiee fi nchi beenchi le nuuŋ wi fɛ jobɛ chi bɛshiinshi nuuŋ fi la? Ɛ mfɛru fiee fi dzeeŋ, mɔɔ fi bifi le? Nsofu wi, mɔɔ ŋ'wo wi le?” Be chikɛ. ");
INSERT INTO asj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jiso dzɔ shéŋ bɛ be, bichɛ be bɛchu kɛnɛ, yi wɔɔ wu kii shéŋ yibe yi bifi. Tee li wi wu ŋgwɛ tɛ̀ kɔɔ wu li kibɛnɛ-ɛ wɛɛ le, “Nɛɛki kibɛnɛ ko.” Nɛɛki ki, ki se biee ki tɛmi. ");
INSERT INTO asj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bɛfarasii se bo, be gɛɛŋ bɛ kintutu ki bɛniiŋ bɛ Mfɔŋ Hɛrɔ-ɔ, be gɛɛŋ be lii ntsuuŋ si be gii be wo Jiso. ");
INSERT INTO asj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jiso bee bɔɔŋ bee bɛ kintutu-u dza fe be gɛɛŋ fɛ libɛ chi Galilii. Kintutu ki bɛniiŋ lɛ ki nɔŋa biee wu fe. Bɛniiŋ bamu tɛ dza kimbɛ ki Galilii bɛ ki Judiya. ");
INSERT INTO asj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bamu dza tɛ̀ Jɛrosalɛŋ bamu kimbɛ ki Idumea, bamu dzɛti liwiŋ li Dzɔɔ yi Joodaaŋ, bamu bimbɛ bi Tayɛ bɛ bi Sidɔ-ɔŋ. Kintutu ki nɔŋa kilu tɛ̀ bɛ nɛɛ lɛ kifɛ be tɛ̀ wuki biee bi Jiso tɛ̀ feti bichu. ");
INSERT INTO asj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jiso dza tee li bɔɔŋ bee bɛ kintutu-u le be gɔɔŋ ŋgo be nachɛ be gɛɛ se lɛ le kii kintutu kilu ni dza ki ni ki fachi wu. ");
INSERT INTO asj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tɛ tee lɛ kifɛ tɛ̀ saa wu wɔnchɛ bɛniiŋ ŋge, bɛniiŋ bɛ chigɔ-ɔŋ se mɛɛŋ be bɛɛ le be koŋ li wuu. ");
INSERT INTO asj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Le bɛniiŋ bɛ Fiana yi tii ti ŋwɛki bɛ be tuu be ŋɛŋ Jiso, be weyɛ wu limfwe be dii be tiiti le, “Ɛ wɛ Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Si be tɛ̀ dii lɛ, Jiso gbɛɛnɛ chiinsɛ li bee bu chiinsinɛ le kiiŋ be ni fɛ le bɛniiŋ kɛɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tɛ̀ dza miri gɛɛŋ li ŋkumɛ-ɛ, teeŋ bɛniiŋ bɛ tɛ̀ gii wɛki, be bɛ lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Buu bɛniiŋ yoofi ntsɔ bɛfɛ, teeŋ be le bɔɔŋ bee bɛ nto-oŋ, le ke ni nuuŋ bee be, tundi be be deŋgi be fenjisi jɛ yi Nyɔ, ");
INSERT INTO asj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","be ni be kɛmi tɛ buŋga bu buushɛ bɔɔŋ bɛ kiŋkundi-i li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bɛniiŋ bɛlu tɛ̀ nuuŋ: Simu, wu tɛ nyɛ bukooŋ bwee bumu le Pita. ");
INSERT INTO asj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeeŋ bee ŋwaani wu Jɔɔŋ bɛ tɛ nuuŋ bɔɔŋ bɛ Dzɛbɛdii, bɛ tɛ̀ nyɛ mɛŋkooŋ mɛ bee le, “Bohanɛgɛs,” mɛ nuuŋ le, “Bɔɔŋ bɛ dzaaŋ yi wɛndi-i.” ");
INSERT INTO asj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bamu se nuuŋ Andolo, Fili, Batolomu, Maacho, Tomɛ, Jeeŋ wu ŋwanɛ Afiyus, Tajɔ, Simu wu tɛ nuuŋ wi wu kintutu ki Bɛsilɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mɔɔ Judas Iskaliyɔ wu tɛ̀ wɛɛŋ kabɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jiso tɛ̀ dza gɛɛŋ fɛ tɛ̀ tsiiŋ, kintutu ki bɛniiŋ lɛ tuu ki banchɛ fe, bee bɔɔŋ bee bɛ kintutu se foo dze yi jɛ biee. ");
INSERT INTO asj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Le kini kee woo, ki gɛɛŋ le ki dzɔɔ wu kifɛ bɛniiŋ tɛ̀ kweŋgi le yoomfɔɔ. ");
INSERT INTO asj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ tɛ̀ dza Jɛrosalɛŋ be bɔɔ le, be se tuu be tiiti le, “Bɛɛsɛbu wɛ li wuu bwiŋ, busɔɔ bɔɔŋ bɛ kiŋkundi-i ni, nuuŋ bɛ buŋga bu mfɔŋ wu bɛnchindaa wulu-u.” ");
INSERT INTO asj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jiso teeŋ be, bii li bee lɛ ŋgaŋgaa li laa, “Nuuŋ Sataŋ tuu ni busi yi yee li wi-i nindee? ");
INSERT INTO asj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɛ kitoŋ dza ki gatɛ ki gwii kiki, ki tɛ naa leŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɛ yih dza yi gatɛ yi gwii yi yi, yi tɛ naa leŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nɛɛ lɛ, ɛ Sataŋ dza wu gatɛ bee kintutu kee bee be tuu be gwii li yi yi bee, be tɛ naa leŋ kɛ, ni nuuŋ kimɛrisɛ kee. ");
INSERT INTO asj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nɛ kɛɛ le wih nuuŋ yɛ lu wu nuuŋ naa lɛ li yih yi wi wu buŋga-a, kotɛ biee biee chɛɛŋ letɛ bɛ bi, fuki fɛ wu saa wu kaŋ wi wu buŋga wulu, se kotɛ biee bi li mwɛ yi nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ntee beŋ chɛɛŋ le, Nyɔ gii yi feeki bibifi mɔɔ jɛ́ yi bifi chichi yi bɛniiŋ tiiti kii yi. ");
INSERT INTO asj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Se nuuŋ le, ɛ wi kweeŋ jɛ yi bifi kii Fiana yi Waaŋ, Nyɔ nuuŋ tɛ naa feeki wɛɛ wi kɛ, kifɛ wu fɛɔ bubiɛɛ bu kimakɛ.” ");
INSERT INTO asj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jiso tɛ̀ kweeŋ lɛ kifɛ bɛniiŋ bɛlu tɛ̀ kweŋgi le fiana yi tii yɛɛ li wuu bwiŋ. ");
INSERT INTO asj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ni Jiso bee bɛŋwaani Jiso biee be fɛsi, be leŋ lɛkuuŋ, be toŋ wi le mwɛ teeŋ wu. ");
INSERT INTO asj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɛ kintutu ki bɛniiŋ lɛ tɛ̀ shee yɛ ki kɛnɛ wu ki tasɛ. Be tee li wuu le, “Na bee bɛŋwaana biiti baa wɛ lɛkuuŋ.” ");
INSERT INTO asj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jiso se bii laa, “Naaŋ bee bɛŋwaanɛŋ nuuŋ baŋ?” ");
INSERT INTO asj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Si tɛ̀ bii lɛ bichɛ bɛniiŋ bɛ tɛ̀ shee yɛ be kɛnɛ wu baa, tee le, “Baaŋ bɛnaaŋ bee bɛŋwaanɛŋ. ");
INSERT INTO asj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wi kwikwi wu feti fiee fi Nyɔ wɛki, ɛ wu wu nuuŋ ŋwaanɛŋ bɛ dzɛ́mi yɛŋ mɔɔ bɛnaaŋ.” ");
INSERT INTO asj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jiso tɛ̀ tuu bɛchi tiifi bɛniiŋ li libɛ-ɛ lichiŋ, ɛ kintutu ki bɛniiŋ lɛ tɛ̀ banchɛ fe weseeŋ. Se dza lɛ shee nuuŋ lɛ ŋgo-o, kintutu kilu lemi li ŋgemɛ yi dzɔɔ li, lɛ bukaka. ");
INSERT INTO asj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tɛ̀ tiifi be biee ŋge nuuŋ lɛ ŋgaŋgaa li. Dza wa ŋgaŋgaa chimu li bee le, ");
INSERT INTO asj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yikɛ yɛɛŋ nɛ woo, wi tɛ̀ la le gɛɛŋ tuŋ ŋgɔ. ");
INSERT INTO asj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Le ni tumi, yimi weyɛ lɛ dze, muniiŋ bɛ mu chɔchɛ mu ji. ");
INSERT INTO asj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yimi weyɛ fɛ kintsii ki ta-a, fɛ nshɛ nuuŋ yɛ fe ŋge kɛ. Yi biee yi bo kifɛ nshɛ tɛ̀ nuuŋ yɛ fe bujɔŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Le wiiŋ bɛchi mbanu, wu sooŋ ŋgɔ yilu yi wɔɔbɛ, kifɛ yi tɛ̀ mɛɛŋ ki lii kɛ gɛɛŋ le yi seri kɛ. ");
INSERT INTO asj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ŋgɔ yimi weyɛ li bifafu-u. Bifafu bilu ko bi baanyɛ ŋgɔ yilu yi se ba ŋ'wonu muntaaŋ nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ŋgɔ yimi weyɛ nuuŋ li nshɛ yi dzeeŋ li, yi bo, yi ko, yi woŋ, yaa si bɛ tɛ̀ tuŋ, lii yi yimi woŋ muntaaŋ mbaanshɛɛ, yi yimi sháŋ mbaambusɔɔ, yimi sháŋ gwii.” ");
INSERT INTO asj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Le Jiso wa lɛ biee mɛɛshi le, “Wi wu kɛmi bintooŋ mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jiso tɛ̀ nuuŋ wuu mbiiŋ, bɛniiŋ bamu bɛ bee be tɛ̀ nuuŋ mɔɔ bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa tɛ̀ bii li wuu kii ŋgaŋgaa chilu. ");
INSERT INTO asj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tuu li bee le, “Ɛ li be-eŋ bɛ Nyɔ doonchɛ yɛ biee bi li bumfɔŋ bwee li bi nuuŋ lɛ munyiikɔɔ li. Se nuuŋ le, li bɛniiŋ bamu-u fiee fichu fiɛɛ nuuŋ lɛ ŋgaŋgaa li, ");
INSERT INTO asj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ke be se ni be bichi, be tɛ ŋɛŋ kɛ, be ni be yiki, be tɛ woo kɛ. Bee nuuŋ yɛ lɛ kɛ dɛɛŋ be fiiki shéŋ yibe, Nyɔ feeki bibifi bi bee.” ");
INSERT INTO asj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jiso dza bii li bɛniiŋ bɛ tɛ̀ nuuŋ bɛ wu baa laa, “Fi nuuŋ le nɛ mɛɛŋ ki kɛɛ kɛ fiee fi ŋgaŋgaa chini tiiti kɛ ni? Ɛ nɛ mɛɛŋ ki kɛɛ kɛ chini kɛ, nɛ gii nɛ geeŋ nɛ se kɛɛ ŋgaŋgaa yimi? ");
INSERT INTO asj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋgɔ yi wi wulu tɛ̀ tumi yɛ ɛ jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ŋgɔ yi tɛ̀ weyɛ lɛ dze yɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, Sataŋ se bɛ mfwaa mumkpaŋ buu jɛ yilu li shéŋ yibe. ");
INSERT INTO asj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ŋgɔ yi tɛ̀ weyɛ fɛ kintsii ki ta-a yɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, be fi yi mfwaa mumkpaŋ bɛ kinɛɛtinɛ, ");
INSERT INTO asj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","se nuuŋ le, yi tɛ̀ seri le yi gɛɛŋ li shéŋ yibee kɛ. Ɛ yi ŋɔɔnɛ niiŋ kwaa, ɛ ŋgɛ bɛ, kɛ ɛ bɛniiŋ biindi bikaa lɛ be jiŋ kii jɛ yilu, be chee bikaa lijiŋ mfwaa mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ŋgɔ yi tɛ̀ weyɛ li bifafu-u yɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, ");
INSERT INTO asj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bɛmbeechɛ kii biee bi li nshɛ yini-i, bɛ kiŋkɔŋgisɛ ki bunɔŋa-a mɔɔ biee bimu bɛ bi taashɛ bi baanyɛ jɛ yilu yi la li yee li. ");
INSERT INTO asj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ŋgɔ yi tɛ̀ weyɛ li nshɛ yi dzeeŋ li yɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, be fi yi, be feti si yi wɛki be giiŋgi limfwe limfwe, nɛɛ si ŋgɔ, yi ti wundi muntaaŋ sháŋ mbaanshɛɛ, yimi sháŋ mbaambusɔɔ, yimi sháŋ gwii.” ");
INSERT INTO asj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jiso dza bii laa, “Wi ti lii bɛ lambo li yih kuuki bɛ ŋkaa, kɛ gɛɛ lintakwiiŋ ni? Ti lii nɛɛ tɔmi nuuŋ nɛɛ li fiee fi bɛ ti tɔɔmi lambo lu ni? ");
INSERT INTO asj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nɛ ni nɛ kii le fiee fichu fi nuuŋ lɛ munyiikɔɔ li fiɛɛ ɛ bɛ tɛ̀ nyikɛ le bɛ naa bɛ yiiŋgi fi, fi nuuŋ lɛjiŋ lɛjiŋ fichu bɛ gii naa bɛ fɛ fi bo fɛ waaŋ. ");
INSERT INTO asj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wi wu kɛmi bintooŋ, mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jiso tuu tee le, “Ɛ nɛ yiki jɛ yi Nyɔ nɛ yiki bujɔŋ, nɛ kɛɛ le dze yi wi yiki le ɛ yi yi Nyɔ gii naa yi fichɛ le se yi nyɛ li mwɛ, yi gii naa yi nyɛ yaa bu yawu. ");
INSERT INTO asj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wi wu kɛmi fiee bɛ gii naa bɛ tondɛ. Wi wu kɛmi yɛ fiee kɛ, mɔɔ nuuŋ fi niiŋ fi kɛmi bɛ gii naa bɛ fi bu fiɛ li wu-u.” ");
INSERT INTO asj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jiso tuu tee le, “Bumfɔŋ bu Nyɔ-ɔ nuuŋ si ŋgɔ yi wi tuŋ liwɛ. ");
INSERT INTO asj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɛ nuuŋ butuu liiti, ɛ bu woo dza we. Ŋgɔ yilu se yi maŋ yi kuu, tɛ kɛɛ mɔɔ laa yi kuu niŋ le kɛ, ");
INSERT INTO asj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","nuuŋ nshɛ yi feti yi se kuu. Ɛ yi kuu lɔɔ, yi dza yi tɔɔŋ, yi boo yi fɛ bikiiŋ, yi toŋ sháŋ. ");
INSERT INTO asj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ɛ yi ta, dzɔ finyɔɔ lɛ liwɛ, kifɛ mfi wu ŋ'wechɛ kɔchɔɔ.” ");
INSERT INTO asj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jiso tuu dza tee le, “Tɛɛbeŋ nuuŋ tɛ maa bumfɔŋ bu Nyɔ-ɔ bɛ la? Tɛ nuuŋ tɛ maa bu bɛ ŋgaŋgaa chi la? ");
INSERT INTO asj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bu bwɛɛ si ŋwaani ŋgɔ yi fintaaŋ fimu, yi sendɛ yi yaa ŋgɔ́ chichi yi laaŋkwiiŋ. Ɛ wi tuŋ liwɛ, ");
INSERT INTO asj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","yi ko, yi yaa biti bichu bi bɛ ti tumi liwɛ, yi nyɛ yɛ́ŋɛ yi nyɔŋa, yi fɛ kiyuundɛ ki muniiŋ mu jiindi liwe nuuŋ mu gwanyɛ yíh li kiyuundɛ ki yɛ́ŋɛ yilu-u.” ");
INSERT INTO asj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ɛ lɛ si Jiso tɛ̀ gii fenjisi jɛ yi Nyɔ li bɛniiŋ li lɛ ŋgaŋgaa li si yini, si nuuŋ be woo. ");
INSERT INTO asj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tɛ̀ gii tiiti yɛ fiee li bee fuki lɛ ŋgaŋgaa li nsiŋ kɛ. Se nuuŋ le, ɛ nuuŋ bee bɔɔŋ bee bɛ kintutu-u be be, se mɛɛshi naanyɛ ŋgaŋgaa yilu chichi li bee. ");
INSERT INTO asj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jiso tɛ̀ gii tiifi bɛniiŋ booyaa, le ni nuuŋ lɛ fɛmfo-o, tee li bɔɔŋ bee bɛ kintutu-u le, “Tɛɛbeŋ tɛ lenchi libɛ tɛ gɛɛŋ luwiŋ lɔɔ.” ");
INSERT INTO asj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Be shɛ kintutu ki bɛniiŋ lɛ ki tɛ̀ nuuŋ fe, be lɛ lɛ ŋgo-o wu Jiso tɛ nuuŋ le wɛɛ, bee be se lenchi, bɛŋgo bamu biki be. ");
INSERT INTO asj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Si be tɛ̀ leenchi lɛ, kiŋkuŋku ki tɛɛmi bɛchi ki nduŋgi bɛ dzɔɔ, dzɔɔ lɛ lɛ ŋgo-o yi wɛki le yi yisɛ le. ");
INSERT INTO asj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jiso tɛ̀ nuuŋ lɛ kinyi ki ŋgo-o liiti, ɛ wu gɛɛ kikoo kee li fiee fi miɔɔfi-i liwe. Be gɛɛŋ be kaŋgisi wu be tiiti le, “Wi wu ntiifɛ, kwe wɛki yɛ le yi dzɔɔ bee ni ɔ tɛ boo kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jiso kaaŋgi, waŋ kiŋkuŋku kilu, tee li dzɔɔ li le, “Chikɛ nshiiŋ.” Kiŋkuŋku kilu biee ki chikɛ, bintsii se dɛŋ ni nshiiŋŋ. ");
INSERT INTO asj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bii li bɔɔŋ bee bɛ kintutu laa, “Nɛ chɛndi la? Nɛ mɛɛŋ ki gɛɛ kɛ shéŋ li mi-i kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Be kɛmɛ chɛnɛ, se be yeti bebe laa, “Wuni wi nuuŋ niŋ, wu kiŋkuŋku mɔɔ dzɔɔ wuki li wuu?” ");
INSERT INTO asj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jiso bee bɔɔŋ bee bɛ kintutu-u lenchi libɛ chilu be bo liwiŋ, kimbɛ ki bɛniiŋ bɛ Jerasɛnɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Si tɛ̀ buti lɛ ŋgo-o lɛ, bee wumu wu fiana yi tii tɛ̀ ŋwɛki bɛ mwɛ, ɛ wu bo lɛ dzíŋ yi bɛ tɛ̀ diyi bɛniiŋ le-e. ");
INSERT INTO asj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wi wulu tɛ̀ tsiiŋ lɛ dzíŋ yilu-u. Wi tɛ̀ nuuŋ yɛ lu wu nuuŋ mɔɔ kaŋ wu bɛ bɛ ncha kɛ. ");
INSERT INTO asj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kiŋga ŋge tɛ̀ nuuŋ ɛ bɛ gɛɛ wu li bɛmfaŋgɛ-ɛ, bɛ kaŋ tsaŋ yee bɛ bɛncha, soomɛ bɛncha bɛlu, shaanshɛ bɛmfaŋgɛ bɛlu. Wi tɛ̀ nuuŋ yɛ lu wu nuuŋ mɔɔ kɛmɛ li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wi wulu tɛ̀ shiiŋ deŋgi lɛ dzíŋ yilu-u buti michi li bɛŋkumɛ-ɛ butuu bɛ fɛnshaaŋ, dzɛŋgi, kwaashi yi yee li ta-a. ");
INSERT INTO asj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Le ŋɛŋ Jiso mɛɛŋ mfiiŋ, letɛ bɛ toŋ núŋ wu limfwe, ");
INSERT INTO asj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","dzaaŋ lɛwe le, “Jiso ŋwanɛ Nyɔ, Nyɔ yi nuuŋ Kikoo ki Biee Bichu-u, ɔ wɛki la li mi-i? Nlɛkɔɔ wɛ li bukooŋ bu Nyɔ-ɔ le kiiŋ ɔ ni nyɛ ŋgɛ li mi-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tɛ̀ tiiti lɛ, kifɛ Jiso bee saa wu dzaaŋ le, “Fiana yi tii yini, bochɛ li wi wuni.” ");
INSERT INTO asj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jiso se bii li wuu laa, “Bukooŋ bwo nuuŋ le noo.” Tuu le, “Bukooŋ bweŋ nuuŋ le kiyaŋ, kifɛ tɛ̀ yaŋ ŋge.” ");
INSERT INTO asj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Le tuu lɛ, bɔsɛyi sooŋ bɔ li Jiso le kiiŋ ni kooŋ bɛ be kimbɛ kilu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Fi tɛ̀ nuuŋ lɛ ɛ kintutu ki nɔŋa ki dziiŋ lɛ tɛ̀ jii biee li mbɛmɛ wu ŋkumɛ-ɛ fe. ");
INSERT INTO asj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Fiana yi tii yilu lɛkɛ Jiso le, “Tuumi bee nuuŋ li dzíiŋ yɛɛ, tɛ̀ lɛ li yi-i.” ");
INSERT INTO asj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jiso beŋ. Fiana yi tii yilu bo li wi wulu-u, yi gɛɛŋ yi lɛ li dzíiŋ yilu-u. Kintutu ki dzíiŋ lɛ kilu tɛ̀ nuuŋ si bɛnchuki bɛfɛ. Yi letɛ, yi bɔɔ li mbɛmɛ wɛɛ, yi seri lɛ libɛ-ɛ yi kwiyɛ. ");
INSERT INTO asj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bɛniiŋ bɛ tɛ̀ kiichi dzíiŋ yilu se dza fe, be kifi, be gɛɛŋ be tee ntoŋ wulu li bito-oŋ mɔɔ li bintsii bi fe-e. Bɛniiŋ tɛ̀ wuki, be buti be bɛɛ le be ŋɛŋ fiee fi tɛ̀ kɛti. ");
INSERT INTO asj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Le be bɛ fɛ Jiso tɛ̀ nuuŋ, be ŋɛŋ wi wu kiyaŋ ki bɔɔŋ bɛ kiŋkundi-i tɛ̀ shiiŋ be ŋwɛki bɛ wu wɛ, ɛ wu shee fe, wu lii ndu, bufii bwee kaari bu to tsaaŋ. Be chɛŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bɛniiŋ bɛ tɛ̀ ŋɛŋ fiee fi tɛ̀ ka, se tiiti si fi tɛ̀ ka bɛ wi wulu mɔɔ kintutu ki dzíiŋ lɛ kilu. ");
INSERT INTO asj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Le be woo lɛ, be lɛkɛ Jiso le dza li kwɛɛŋ wu bee. ");
INSERT INTO asj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Le Jiso ni lii lɛ ŋgo-o, wi wu bɔɔŋ bɛ kiŋkundi-i tɛ̀ bo li wuu bwiŋ wɛ bɛchi lɛki Jiso le bee wu ni be giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jiso faaŋ, tee li wuu le, “Ɔ giiŋgi nuuŋ fɛkuuŋ, ɔ gɛɛŋ ɔ tee li bɛniiŋ bo-o fiee fi Taa fɛ li wɛ-ɛ, bɛ si wu kɔɔ ɔ nshiiŋ bɛ wɛ.” ");
INSERT INTO asj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Se nuuŋ le, wi wulu tɛ̀ dza gɛɛŋ, deŋgi li kwɛɛŋ wu bɛ teenyi le Bitoŋ bi Yoofi wɛɛ kwikwi, tiiti fiee fi Jiso fɛ li wuu. Bɛniiŋ tɛ̀ wuki, be tɛti maa. ");
INSERT INTO asj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jiso tuu kaari lenchi lɛ ŋgo-o gɛɛŋ luwiŋ lɔɔ nuuŋ li libɛ lichiŋ, kintutu ki bɛniiŋ lɛ tuu ki banchɛ fe. ");
INSERT INTO asj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Te Kikoo wu yih yi nlɛkɛ li Nyɔ-ɔ wumu tɛ̀ dza bɛ fe, bukooŋ bwee nuuŋ le Jairɔs. Le ŋɛŋ Jiso, gɛɛŋ we wu limfwe, ");
INSERT INTO asj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","bɔsɛyi suŋgi bɔ li wuu tiiti le, “Ŋwanɛŋ wu kwɛɛŋ wu bwi wɛ lɛ kwe wa. Mintemii, bɛ ɔ koŋ li wuu tɛmi kii ni kwi.” ");
INSERT INTO asj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jiso se dza bee wu gɛɛŋ, kintutu ki bɛniiŋ lɛ banchɛ ki biki ki fachi Jiso. ");
INSERT INTO asj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kwɛɛŋ wumu tɛ̀ nuuŋ li kintutu kilu-u linti, ɛ wu gɔŋ bɛ chigɔŋ chi mfi wu ŋɛnɛ-ɛ biya yoofi ntsɔ bifɛ. ");
INSERT INTO asj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tɛ̀ fiɔɔŋ ŋge li bɛniiŋ bɛ ntsi-i, biifi fiee fichu fi tɛ̀ kɛmi, biee se biiti bi giiŋgi bu limfwe-e. ");
INSERT INTO asj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Si tɛ̀ woo kii Jiso, biee lɛ wuu jiŋ li kintutu kɛɛ linti, koŋ li ndu yee, ");
INSERT INTO asj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kifɛ tɛ̀ tee li shéŋ yee li le, “Ɛ mi ŋkoŋ nɛɛ mɔɔ nuuŋ li ndu ye kwaa, kɛ mi ntɛmɔɔ.” ");
INSERT INTO asj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Si tɛ̀ koŋ lɛ, mfi wu ŋɛŋgɛ we biee wu ma mfwaa mumkpaŋ. Kwɛɛŋ wulu woo tɛ li yi yee li le, wu tɛmɔɔ. ");
INSERT INTO asj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jiso woo li yi yee li le, buŋga bo bwɛɛ li wuu, fiiki yi mfwaa mumkpaŋ, bii li bɛniiŋ li laa, “Ɛ noo wu koŋ li ndu yɛɛŋ?” ");
INSERT INTO asj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bɔɔŋ bee bɛ kintutu tuu li wuu le, “Ɔ ŋiŋgi yɛ si kintutu ki bɛniiŋ lɛ fachi wɛ, ɔ tuu ɔ biiti wi wu koŋ li wɛ-ɛ ni?” ");
INSERT INTO asj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jiso ba bichi kɛnini le ŋɛŋgɛ wi wu koŋ li wuu. ");
INSERT INTO asj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nɛɛlɛ si kwɛɛŋ wulu tɛ̀ kɛɛ fiee fi ka bɛ wu, biee bɛ, chɛndi, kɛɛti, toŋ núŋ li Jiso limfwe tee chɛɛŋ we kwikwi li wuu. ");
INSERT INTO asj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jiso tee li wuu le, “Ŋwanɛŋ, shéŋ yɔɔ gɛɛ li mi-i, fɛ yɛɛ ɔ tɛmi. Ɔ giiŋgi bujɔŋ. Chigɔŋ cho ma chɛɛ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nɛɛ si Jiso tɛ̀ mɛɛŋ yeti li kwɛɛŋ wulu-u lɛ, bɛniiŋ bamu fɛsi ɛ be dza fɛ Jairɔs kuuŋ wu te kikoo ki yih yi nlɛkɛ li Nyɔ-ɔ wɛ, be tee li wuu le, “Ŋwana mɛɛshɔɔ. Ɛ la fi ɔ fieŋgisi Wi wu Ntiifɛ?” ");
INSERT INTO asj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Si be tee lɛ, Jiso woo, se nuuŋ le, tɛ̀ fɛ kɛɛ mɛɛŋɔ ki woo kɛ, tee li Jairɔs le, “Kiiŋ ɔ ni ɔ chɛndi kɛ, gɛɛ shéŋ ya nuuŋ li mi-i kwaa.” ");
INSERT INTO asj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Be ba be ŋgiiŋgi, Jiso mɛɛŋ ki beŋ le wumu biee wu kɛ, fuki Pita bɛ Jeeŋ mɔɔ Jɔɔŋ wu ŋwaani Jeeŋ nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Le be gɛɛŋ be fɛsi fɛ Jairɔs kuuŋ, Jiso ŋɛŋ si bɛniiŋ yɛti fe bɛ kwe. ");
INSERT INTO asj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lɛ li yih, bii laa, “Nɛ dii, nɛ fieŋgisi bintsii ni kii la? Ŋwaŋ wulu mɛɛŋɔ ki kwi-i kɛ, liitɔɔ bu lefu.” ");
INSERT INTO asj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Be kee wu bu kefu. Dza buu bɛniiŋ bɛchu lɛkuuŋ, dzɔ nuuŋ te ŋwaŋ bɛ ni ŋwaŋ mɔɔ bɛniiŋ bee bɛ kintutu-u bɛ bɛtɛɛtu baa, bee be lɛ be gɛɛŋ fɛ ŋwaŋ wulu tɛ gimi. ");
INSERT INTO asj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kɛmɛ ŋwaŋ wulu li kibɛnɛ-ɛ, yɔ lɛ jɛ́ yi bee le, “Talita kum!” Fi nuuŋ le, “Ŋwaakwɛɛŋ, n'yetɔɔ li wɛ-ɛ, dza we.” ");
INSERT INTO asj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mfwaa mumkpaŋ, dza we deŋgi. Ŋwaakwɛɛŋ wulu tɛ̀ nuuŋ biya yoofi ntsɔ bifɛ. Le be ŋɛŋ lɛ wa tɛ be. ");
INSERT INTO asj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jiso chiinsɛ li bee mkpaaŋ le, kiiŋ be ni fɛ wi kɛɛ fiee fi bee fi nuuŋ kɛ, se tee le be nyɛ wu fiee ji. ");
INSERT INTO asj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jiso tɛ̀ dza fe, bee bɔɔŋ bee bɛ kintutu-u gɛɛŋ li kitoŋ kee li. ");
INSERT INTO asj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Le ni nuuŋ jobɛ chibee chi bɛshiinshi, gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ bɛchi tiifi bɛniiŋ lu. Bɛniiŋ ŋgee bɛ tɛ̀ wuki si tiifi, wa tɛ tii be. Be tuu be dza be njanji be tiiti le, “Wi wuni laanchɛ bini biee nuuŋ fɛŋ? Wu dzɔ buni bufii fɛŋ? Wu ge niŋ se feti bini biŋkoofɛyi bi biee lɛ? ");
INSERT INTO asj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ɛ nɛɛ wu, wi wu keendi biti wu nuuŋ ŋwanɛ Maariya ni? Nuuŋ nɛɛ ŋwaani Jeeŋ bee Jɔsɛ mɔɔ Judas bee Simu ni? Mɔɔ bɛŋwaani bɛ buŋkɛɛŋ nuuŋ nɛɛ fɛni bɛ bee ni?” Si be tee lɛ be faaŋ wu. ");
INSERT INTO asj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Se nuuŋ le Jiso tɛ̀ tee li bee le, “Bɛ ti guundi ntomfɔŋ wu Nyɔ li bintsii bichu. Ɛ nɛɛ li kwɛɛŋ we-e li kwaa bɛ li kini kee li, mɔɔ li wuu yih, li bɛ ti guundi yɛ wu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Si be tɛ̀ faaŋ Jiso lɛ, fi yaa wu fɛ nuuŋ tuu fɛ biŋkoofɛyi bi biee lɛ fe ŋge, fuki nɛɛ le tɛ̀ koŋ li bɛniiŋ bɛ chigɔ-ɔŋ niiŋ be tɛmi nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Fi yaa wu fɛ be tɛ̀ mɛɛŋ ki gɛɛ kɛ shéŋ li wuu kɛ. Jiso dza fe deŋgi li bitoŋ bi fe-e, tiifi bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dza teeŋ bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa, tundi be lɛkuuŋ bɛfɛ bɛfɛ, nyɛɛ buŋga li bee bu buushɛ fiana yi tii li bɛniiŋ li lu. ");
INSERT INTO asj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Le ni tundi be tee le kiiŋ be ni dzɔɔ fiee fuki kimbaaŋ siŋ kɛ. Kiiŋ be ni dzɔɔ biee bijɛ kɛ. Kiiŋ be ni dzɔɔ babi, kɛ kwa li bitsaa bi bee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Le be liishɛ bikpɔ, se nuuŋ le kiiŋ be ni chuumɛ biŋkoŋ bi fɛɛtu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Se tuu tee li bee le, “Mfi wu nɛ gɛɛŋ li kito-oŋ, nɛ lɛ li yih, nɛ tsiiŋ lu gɛɛŋ bo jobɛ chi nɛ dzɛti fe. ");
INSERT INTO asj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɛ kitoŋ kimu faaŋ le ki fii yɛ beŋ kɛ, mɔɔ le ki wuki yɛ fiee fi nɛ tiiti kɛ, nɛ dza fe, mfi wu nɛ dzɛti lɔɔ nɛ kachɛ kiboŋ ki li bikaa binɛ-ɛ, le fi doonchɛ fiee fi be mɔŋ.” ");
INSERT INTO asj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nɛɛlɛ, be dza be gɛɛŋ be fenjisi le bɛniiŋ fiiki shéŋ yibe. ");
INSERT INTO asj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Be tuu be buushi tɛ bɔɔŋ bɛ biŋkundi-i ŋge li bɛniiŋ li, be tsiti bɛniiŋ bɛ chigɔŋ ŋge bɛ mɛɛŋ, be wɔnchi be. ");
INSERT INTO asj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Le Mfɔŋ Hɛrɔ woo ntoŋ wu kii Jiso, si bɛniiŋ tɛ̀ wuki bukooŋ bwee li bintsii bichu-u, bɛniiŋ bamu tiiti le, “Jiso wuni nuuŋ Jɔɔŋ Nlisulidzɔɔ wu tɛ̀ kaari wu bo li kwe-e. Fiɛɛ fiee fi feti se kɛmi buŋga bu fɛrɛ biee bi koofi yi bini ni.” ");
INSERT INTO asj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bamu tiiti le, “Ɛ Ɛlaja wu tɛ̀ kaari wu bɛ.” Bamu le, “Ɛ ntomfɔŋ wu Nyɔ wumu si bɛ lindɛɛri.” ");
INSERT INTO asj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Le Hɛrɔ woo biee bini ni, tee fiee le, “Ɛ Jɔɔŋ Nlisulidzɔɔ, wu ntɛ̀ ŋka kikoo kee wu kaari wu bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hɛrɔ tɛ̀ toŋ bɛniiŋ be gɛɛŋ be kɔɔ wu, be kaŋ be bɛŋɛ wu li yih yi ncha-a, kii Hɛroja wu kwɛɛ Fili wu ŋwaani Hɛrɔ, wu Hɛrɔ tɛ̀ dzɔ li kwɛsi-i. ");
INSERT INTO asj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔɔŋ tɛ̀ fɛŋgi tiiti li wuu le, “Nchi mɛɛŋ ki beŋ kɛ le wi dzɔɔ kwɛɛ ŋwaani si kwɛsi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Si Jɔɔŋ tɛ̀ tee lɛ, Hɛroja gɛɛ wu lɛ shéŋ, wɛki le wo wu, le fi ni fi nuuŋ ni, se nuuŋ le tɛ̀ kɛmi yɛ dze kɛ, ");
INSERT INTO asj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kifɛ Hɛrɔ tɛ̀ chɛndi Jɔɔŋ le ɛ wi wu waaŋ tuu nuuŋ tɛ̀ wi wu Nyɔ. Se tuu ŋɛŋ le kiiŋ be ni wo wu kɛ. Mfi wu Hɛrɔ tɛ̀ shiiŋ yiki fiee fi Jɔɔŋ tiiti, shéŋ yee wɛsini ŋge, se nuuŋ le tɛ̀ kɔŋgisi nɛɛ le ni yiki fiee fi tiiti. ");
INSERT INTO asj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dze tɛ̀ dza yi yenɛ li Hɛroja-a, jobɛ chimu chi Hɛrɔ tɛ̀ feti tsɔnɔ bee bɛte kwɛɛŋ mɔɔ bikoo bi nchi-i mɔɔ bɛniiŋ bɛ nɔŋa bɛ nɔŋa bɛ Galilii, le kimi jobɛ chi bɛ tɛ̀ biɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ŋwanɛ Hɛroja wu kwɛɛŋ lɛ bwachɛ binɛ, chi dzɔɔŋ fɛ Hɛrɔ bee bɛniiŋ bee bɛ tsɔnɔ. Se tee li ŋwaŋ wulu le, “Bii fiee fiɔɔ kɔŋgisi, mfenyɔɔ lu.” ");
INSERT INTO asj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Se tuu chini tee le, “Ɔɔ bii mɔɔ nuuŋ la li mi-i le, mɔɔ nuuŋ kiŋgatɛ ki kwɛɛŋ wɛ-ɛŋ, kɛ ŋgii nyɛ wɛ.” ");
INSERT INTO asj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ŋwaŋ wu kwɛɛŋ wulu se bo gɛɛŋ bii li ni-i laa, “Ntee le mfenyɛ mi bɛ la?” Ni se tuu le, “Gɛnɛ ɔ tee le bɛ nyɛ wɛ kikoo ki Jɔɔŋ Nlisulidzɔɔ li.” ");
INSERT INTO asj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Se bakɛ to lijiŋ mfwaa mumkpaŋ, tee li Mfɔŋ Hɛrɔ le, “Ŋwɛkɔɔ le ɔ nyɛ mi kikoo ki Jɔɔŋ Nlisulidzɔɔ li dɛɛni fɛ kintɛkɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mfɔŋ woo lɛ, yi kwi wu ŋge. Se nuuŋ le, si tɛ̀ chini limfwe li bɛniiŋ bɛ tɛ̀ nuuŋ fɛ tsɔnɔ-ɔ, tɛ̀ wɛki yɛ le tuu fiiki jɛ ye yi bee tee li ŋwaŋ wulu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Se biee toŋ nchindaa we mfwaa mumkpaŋ le gɛɛŋ bɛ bɛ kikoo ki Jɔɔŋ lɛ. Gɛɛŋ li yih yi ncha-a, ka kikoo ki Jɔɔŋ lɛ, ");
INSERT INTO asj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bɛ bɛ ki fɛ kintɛkɛ-ɛ, bɛ nyɛ li ŋwaakwɛɛŋ wulu-u. Fi, bo gɛɛŋ nyɛ li ni-i. ");
INSERT INTO asj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Le bɔɔŋ bɛ kintutu-u bɛ Jɔɔŋ lɛ wuki lɛ, be gɛɛŋ be dzɔ gwini chi Jɔɔŋ lɛ be diyɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bɔɔŋ bɛ ntoŋ bɛ Jiso tɛ̀ dɛndɛ be kaari be to lijiŋ lɛ wuu, be tee wu biee bichu bi be tɛ̀ fɛ, bɛ bi be tɛ̀ tiifi bɛniiŋ lu li wuu. ");
INSERT INTO asj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Se dza tee li bee le, “Bɛ yɛɛŋ, beŋ beŋ tɛ̀ gɛɛŋ fɛ kintsii ki bɛniiŋ nuuŋ yɛ fe kɛ-ɛ, tɛ fufɛ niiŋ.” Tɛ̀ tee lɛ kifɛ bɛniiŋ ŋge tɛ̀ bɛɛ fɛ be tɛ̀ nuuŋ, bamu tɛ̀ bɛɛ, bamu karisi. Be tɛ̀ kɛmi yɛ dze yi be nuuŋ mɔɔ be ji biee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bee be lɛ lɛ ŋgo-o be cheekiyi, be gɛɛŋ fɛ kintsii ki bɛniiŋ tɛ̀ nuuŋ yɛ fe kɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Se nuuŋ le, bɛniiŋ ŋge tɛ̀ ŋɛŋ nɛɛ be si be giiŋgi, be kɛɛ be, be dza li bintsii li bichu be letini be giiŋgi be soomi be limfwe. Le be gɛɛŋ be fɛsi fe, Jiso bee bɔɔŋ bee bɛ kintutu-u se fɛsi tɛ̀. ");
INSERT INTO asj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Le bo lɛ ŋgo ni fɛɛshi li buka, ŋɛŋ kintutu ki bɛniiŋ lɛ turi fe ni mamama, nshiiŋ kɔɔ wu bɛ be, kifɛ be tɛ̀ nuuŋ si nshɔ́ɔŋ yi nuuŋ yɛ bɛ kiŋkiichɛ kɛ. Se bɛchi tiifi be, tiifi be biee ŋge tɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Le jobɛ bɛchi chi ni chi sechi, bɔɔŋ bee bɛ kintutu-u kiiŋgi li wuu lichiŋ, be tee li wuu le, “Fɛni fɛɛ fɛbuka mfi gɛɛŋɔ kituŋ, ");
INSERT INTO asj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","gɛɛ bɛniiŋ bani be gɛɛŋ li bito-oŋ bɛ bɛla bɛ tsɛkɛtsɛkɛ, be go biee bi bee bijɛ.” ");
INSERT INTO asj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Se nuuŋ le Jiso tuu fiee le, “Beŋ kibɛɛ nyɛ yɛɛŋ be fiee be ji.” Be bii li wuu laa, “Ɔ wɛki le tɛ gɔɔŋ bɛdanali gii fɛɛ tɛ go biee bijɛ lu, tɛ bɛ tɛ nyɛ li bee ni?” ");
INSERT INTO asj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jiso bii li bee laa, “Nɛ kɛmi baa bibele bimɛ? Gɛnɛ yɛɛŋ nɛ bichɛ.” Le be gɛɛŋ be bichɛ, be tee le, “Tsee yi bibele yɛɛ shiŋ bɛ nsúuŋ fiɛɛtu.” ");
INSERT INTO asj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jiso se tee li bɔɔŋ bee bɛ kintutu le be tee le, bɛniiŋ bɛlu shee yɛ li bintutu-u li bintutu-u, li ntsɛɛ li. ");
INSERT INTO asj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Le bɛniiŋ bɛlu shee yɛ fɛkwiiŋ li bintutu-u gwii gwii li bamu mbaanshiŋ mbaanshiŋ. ");
INSERT INTO asj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jiso fi tsée yi bibele yi shiŋ yɛɛ bɛ nsúuŋ yi fiɛɛtu yɛɛ, bichɛ liwe, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ nyɛ li bɔɔŋ bee bɛ kintutu-u, be gachɛ li bɛniiŋ bɛlu-u. Se gachɛ tɛ nsúuŋ yi fiɛɛtu yɛɛ li be bɛchu-u. ");
INSERT INTO asj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bɛniiŋ bɛchu ji be fukɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bɔɔŋ bɛ Jiso bɛ kintutu-u banchɛ muŋkɛ mu bibele mwɛɛ bɛ biŋkɛ bi nsúuŋ lɛ biɛɛ, bi yisɛ bɛŋkaa yoofi ntsɔ bifɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bɛniiŋ bɛ tɛ̀ ji bibele bilu tɛ nuuŋ buniŋ kwaa bɛnchuki bɛtiinu. ");
INSERT INTO asj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jiso se tee li bɔɔŋ bee bɛ kintutu-u le be lɛ lɛ ŋgo-o be saa be gɛɛŋ limfwe Besaida le shɛ yɛsi bɛniiŋ bɛlu be ni be kuuki. ");
INSERT INTO asj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Shɛ yɛsi be, dza yɛɛ li ŋkumɛ-ɛ, le lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Le lɛkuuŋ jiŋ, ɛ ŋgo wulu tɛ̀ nuuŋ dzɔɔ kintikinti kituŋ, Jiso mɛɛŋ nɛɛ libuka wuu mbiiŋ. ");
INSERT INTO asj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ŋɛŋ si bɔɔŋ bee bɛ kintutu-u gwenini bɛ ŋgo wu chefɛ, kifɛ mbaandze tɛ̀ bɛɛ dze limfwe fɛɛti wu. Ɛ tɛ̀ nuuŋ si lɛ ŋwori lɛ se dza bɛɛ fɛ bee, deŋgi li dzɔɔ li liwe. Tɛ̀ bɛɛ wɛki le ka li bee lichiŋ. ");
INSERT INTO asj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Le be ŋɛŋ si deŋgi li dzɔɔ li liwe, be beechi le ɛ ŋkuubee. Be waŋ lɛwe, ");
INSERT INTO asj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kifɛ be bɛchu tɛ̀ ŋɛŋ wu jaaŋ kɔɔ be. Mfwaa mumkpaŋ, Jiso yɔ li bee, tee li bee le, “Kɛmɛ yɛɛŋ shéŋ, ɛ mi. Kiiŋ nɛ ni chɛŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Si wu tee lɛ, se lɛ shee lɛ ŋgo-o bee be, mbaandze wulu biee wu chikɛ. Be nɛŋ ni, bimfimu wondɛ be ni kataraa, ");
INSERT INTO asj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","be ti mɛɛŋ ki kɛɛ kɛ tɛ fiee fi tsee yi bibele yɛɛ tɛ̀ doonchi kii Jiso kɛ kifɛ be tɛ̀ mɛɛŋ ki gwiyɛ kɛ shéŋ yi be kɛ. ");
INSERT INTO asj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Le be lenchi libɛ be bo kimbɛ ki Jɛnɛsarɛ, be shiŋɛ ŋgo li ŋgemɛ yi dzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Le be bo lɛ ŋgo-o, bɛniiŋ kɛɛ Jiso mfwaa mumkpaŋ, ");
INSERT INTO asj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","be bɛchi be letini be giiŋgi li bitoŋ bi fe bichu-u, be busi bɛniiŋ bɛ chigɔ-ɔŋ, be tuuti bɛniiŋ bɛ chigɔ-ɔŋ fɛ bida-aŋ fɛ kintsii kichu ki be woo le Jiso wɛ fe. ");
INSERT INTO asj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kintsii kichu ki Jiso gɛɛŋ fe, mɔɔ nuuŋ fɛ kintsii li mɔɔ nuuŋ fɛ kito-oŋ, mɔɔ nuuŋ libuka, bɛniiŋ giki bɛniiŋ bɛ chigɔ-ɔŋ fɛ bɛniiŋ ti taashi. Mfi wu Jiso kɛtɔɔ, be lɛki le gɛɛ be koŋ mɔɔ nuuŋ li wooŋ wu ndu yee. Wi kwikwi wu tɛ̀ kundi, tɛ̀ tɛmi. ");
INSERT INTO asj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jobɛ chimu Bɛfarasii bɛ bɛniiŋ bamu bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ dza Jɛrosalɛŋ be bɛ be banchɛ li Jiso-o lichiŋ. ");
INSERT INTO asj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Be dza be ŋɛŋ bɔɔŋ bɛ kintutu-u bɛ Jiso-o bamu jii biee tsaŋ tii, fi nuuŋ le be ti mɛɛŋ ki tsootsɛ kɛ tsaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bɛfarasii mɔɔ Bɛjuu bɛchu tɛ̀ biki nuuŋ ntsɛ wu kwɛɛŋ wu bɛ tee bɛ bee bɛ ŋkosi, le nuuŋ wi tɛ̀ ji biee fuki fɛ mwɛ tsootsɛ tsaŋ nɛɛ si bɛ tɛ̀ shiiŋ bɛ tsootsi nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Le nuuŋ wi tɛ̀ ji tɛ fiee fɛ mwɛ koo fɛwaŋ fuki fɛ wu tsootsɛ bikaa bɛ tsaŋ yee lɛ dze yi lu nsiŋ kɛ. Be tuu be feti biee bimu bi ntsɛ wu kwɛɛŋ lɛ ŋge, si ntsootsɛ muka bɛ bibɛɛŋ mɔɔ sháŋ. ");
INSERT INTO asj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bɛfarasii bɛ bɛniiŋ bɛ tiifi bɛnchi bɛlu tɛ̀ bii li Jiso laa, “Ɛ kii la fi bɔɔŋ bo bɛ kintutu biki yɛ ntsɛ wu kwɛɛŋ wu bɛtaa bɛsɛŋ bɛ ŋkosi kɛ? Ɛ kii la fi be jii biee tsaŋ tii?” ");
INSERT INTO asj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jiso tuu li bee le, “Ɛsaya ntomfɔŋ wu Nyɔ tɛ̀ tee chɛɛŋ kii beŋ le nɛ baa bɛniiŋ bɛ nimi-i. Nɛ feti baa nɛɛ nuuŋ fiee fi bɛ tɛ̀ tsɛɛ, Nyɔ tiiti le, ‘Bɛniiŋ bani guundi mi nuuŋ bɛ bimfimu, shéŋ yibe nuuŋ mfiiŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Be guundi mi nuuŋ li yee li, kifɛ be dzeti biee bi bɛniiŋ beechi, be tiifi le ɛ jɛ yɛŋ’. ");
INSERT INTO asj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ɛ nɛɛ lɛ si nɛ chiiŋgi baa bɛnchi bɛ Nyɔ-ɔ, nɛ kichi nuuŋ bɛ bɛniiŋ gɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jiso se tee li bee le, “Nɛ gbɛŋgi nɛ kii faŋu bɛnchi bɛ Nyɔ-ɔ le se nɛ ni nɛ biki nuuŋ bɛnɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Fi fiɛɛ ɛ Mɔɔsɛ tɛ̀ tee le, ‘Yooki chaa bee na.’ Tuu tee tɛ le, ‘Ɛ wi gaa tee kɛ ni, bɛ wo mwɛ dududu.’ ");
INSERT INTO asj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Se nuuŋ le, nɛ tiiti baa finɛ le, ‘Ɛ wi dza wu tee li tee li kɛ li ni-i le fiee fi bee nuuŋ wu fi tee kɛ ni lu, le fiee filu to fiɛɛ Kɔbaŋ,’ fi nuuŋ le fi to fiɛɛ fiee fi Nyɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kɛ mɛɛŋ yɛ beŋ le dzɔɔ fiee filu fi tee kɛ ni lu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nɛ feti baa lɛ, nɛ feti jɛ yi Nyɔ tuu fiee fi yee kii ntsɛ wunɛ wu kwɛɛŋ, wu nɛ tiifi bɛniiŋ lu. Biee bimu se biɛɛ tɛ lu ŋge si bini bi nɛ feti.” ");
INSERT INTO asj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jiso dza tuu teeŋ bɛniiŋ le be bɛ, tee li bee le, “Beŋ bɛchu yikɛ yɛɛŋ nɛ woo fiee fi ntiiti, nɛ kɛɛ bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fiee fimu nuuŋ yɛ lu lɛkuuŋ fi nuuŋ fi lɛ li wi-i fi liibi wi kɛ. Ɛ fiee fi buti li wi-i, fi nuuŋ fi liibi wi.  ");
INSERT INTO asj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wi wu kɛmi bintooŋ le woo, mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiso shɛ bɛniiŋ bɛlu, lɛ li yih, bɔɔŋ bee bɛ kintutu-u bii li wuu kii ŋgaŋgaa chilu. ");
INSERT INTO asj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tuu li bee le, “Nɛ kii yɛ biee tɛ ni? Kɛ nɛ kii yɛ le fiee fichu fi wi lisi lɛ wuu wa nuuŋ tɛ biifi wu kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Fi nuuŋ lɛ, kifɛ fi ti lii yɛ le fi gɛɛŋ nuuŋ li shé-eŋ kɛ, fi sɛchi nuuŋ lɛ shéŋ, fi se dɛndɛ fi bo.” (Si Jiso tɛ̀ tee lɛ, fi se nuuŋ le biee bijɛ bichu biɛɛ waaŋ.) ");
INSERT INTO asj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tuu gɛɛŋ limfwe tee le, “Ɛ fiee fi buti li wi-i, fi bifisi mwɛ, ");
INSERT INTO asj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kifɛ biee bichu bibifi bi wi feti dzɛti nuuŋ li shéŋ yee li. Biee si bɛmbeechɛ bɛ bifi, kii bukwɛɛ, n'yɛ buyi, ŋ'wo wi, ŋgimu bɛ kwɛɛ wi kɛ nyumɛ wi, ");
INSERT INTO asj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nsɔmfu biee, ŋkɛmɛ tee chi bifi mfɛru kimfi, mfɛru nyɛŋ, ŋkɛmɛ shéŋ yi yɛɛti, mɛŋkooŋ mɛ bɛniiŋ lɛ mɛ bifisɛ, ntsakisɛ yi mɔɔ n'yoomfɛ kiyoomfɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Biee bibifi bini bichu dzɛti nuuŋ li shéŋ yi wi-i bi se bifisi mwɛ.” ");
INSERT INTO asj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jiso tɛ̀ dza fe, gɛɛŋ kimbɛ ki Tayɛ bɛ Sidɔ-ɔŋ. Le gɛɛŋ le, lɛ li yih, tɛ̀ wɛki yɛ le wi kɛɛ le wɛ lu kɛ. Se nuuŋ le, bɛniiŋ tɛ̀ tuu be kɛɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kwɛɛŋ wumu tɛ̀ nuuŋ fe fiana yi tii tɛ̀ nuuŋ li ŋwani wu kwɛɛŋ li. Mfwaa mumkpaŋ si tɛ̀ woo kii Jiso lɛ, se bɛ we li bikaa biee li. ");
INSERT INTO asj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kwɛɛŋ wulu tɛ̀ nuuŋ wi wu Grik, tɛ̀ nuuŋ yɛ wi wu Juu kɛ. Bɛ tɛ̀ biɛ wu Fonisha li kwɛɛŋ wu Silia. Si tɛ̀ we lɛ, lɛkɛ Jiso le buu ŋwanɛ kiŋkundi wulu li ŋwani wɛɛ. ");
INSERT INTO asj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jiso se tuu li wuu le, “Gɛɛ bɛ saa bɛ nyɛkɛ bɔɔŋ, kifɛ fi mɛɛŋ ki dzɔɔŋ kɛ le bɛ dzɔɔ bijinɛ bi bɔɔŋ lɛ bɛ lɔŋ li bwí kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kwɛɛŋ wulu se tuu li wuu le, “Ɛ chɛɛŋ baa wɛŋ. Se nuuŋ le, bɔɔŋ ti bɛɛ ɛ be ji biee bwí bɔɔnyi mukɛ mu weyi fɛkwiiŋ.” ");
INSERT INTO asj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jiso se tee li wuu le, “Kii fiee fiɔɔ tuu fini, ɔ nuuŋ ɔ gɛɛŋ fio, ŋwanɛ kiŋkundi wulu bee chinɛ li ŋwana kituŋ.” ");
INSERT INTO asj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kwɛɛŋ wulu dza giiŋgi fɛ wu kuuŋ, gɛɛŋ ŋɛŋ ŋwani gimi fɛntaa ɛ ŋwanɛ kiŋkundi wulu bo kituŋ. ");
INSERT INTO asj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jiso dza lɛ kimbɛ ki Tayɛ-ɛ, ka Sidɔŋ ka kimbɛ ki Bitoŋ bi Yoofi-i, to dze lɛ Libɛ chi Galilii. ");
INSERT INTO asj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bɛniiŋ bamu tɛ̀ dza be bɛ bɛ wi wumu nuuŋ kinchiinchii tɛ̀ kii yɛ n'yɔru kɛ. Be lɛkɛ Jiso le gɛɛ tsaŋ yee li wuu bwiŋ, wɔnchɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jiso se dzɔ wu bee wu bo li kintutu linti bebe. Gɛɛ tsaŋ yee li bintooŋ bi wi wulu, kwiyɛ budii, koŋ li nimi chi wi wulu bɛ bu, ");
INSERT INTO asj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","bichɛ liwe, shɔɔŋ, kweeŋ li wuu le, “Ɛfata,” fi nuuŋ le, “Gwiyɛ.” ");
INSERT INTO asj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bintooŋ bi wi wulu se gwiyɛ mfwaa mumkpaŋ, nimi chee fuutɛ, bɛchi yeti bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jiso chiinsɛ li bɛniiŋ li le kiiŋ be ni tee li wi-i kɛ. Se nuuŋ le, si tɛ̀ chiinsini lɛ, tuu to nuuŋ fiee fi be yaki be giiŋgi bɛ fi limfwe limfwe. ");
INSERT INTO asj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bimfimu tɛ̀ wondini bɛniiŋ ŋge. Be njanji, be tiiti le, “Jiso kii mfɛru biee bichu bujɔŋ. Feti binchiinchi wuki biee, bibere yeti.” ");
INSERT INTO asj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nɛɛ li jo yɛɛ, kintutu ki bɛniiŋ lɛ tuu ki bɛ ki turi ni mamama. Fi se nuuŋ le be tɛ̀ kɛmi yɛ fiee fijɛ kɛ, Jiso teeŋ bɔɔŋ bee bɛ kintutu tee li bee le, ");
INSERT INTO asj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ŋkɛmɔɔ nshiiŋ fɛ kintutu kini-i, kifɛ be nuuŋ baa tɛɛ be jo taa, fiee fi be nuuŋ be ji se mɛɛŋ yɛ lu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ɛ mi nchinɛ le be ni be giiŋgi li bɛla bɛ bee, be gɛɛŋ be kwiyɛ bɛ dzeeŋ lɛ dze, kifɛ bamu li bee linti dza baa mfiiŋ.” ");
INSERT INTO asj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bɔɔŋ bee bɛ kintutu tuu le, “Wi gii dzɔɔ biee bijɛ libuka luni fɛŋ bi nyɛkɛ ŋwaani bani bɛniiŋ lu?” ");
INSERT INTO asj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Se bii li bee laa, “Nɛ kɛmi baa tsée yi bibele bi mɛ?” Be tuu le, “Yi yɛɛ mfomɛnyaaŋ.” ");
INSERT INTO asj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jiso se tee li kintutu ki bɛniiŋ lɛ kilu le ki shee yɛ fɛkwiiŋ. Ki shee yɛ, dzɔ tsée yi bibele yi mfomɛnyaaŋ yɛɛ, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ, nyɛ li bɔɔŋ bee bɛ kintutu-u le be gachɛ li be-e. Be gachɛ. ");
INSERT INTO asj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Be tɛ̀ kɛmi tɛ munsuŋu mumu niiŋ kwaa. Se tuu dzɔ tɛ, nyɛ kiyɔɔni li Nyɔ-ɔ, tee le be gachɛ li bɛniiŋ bɛlu-u. ");
INSERT INTO asj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wi kwi ji fukɛ. Be banchɛ muŋkɛ mu tɛ̀ shɛ, mu yisɛ bɛŋkaa mfomɛnyaaŋ. ");
INSERT INTO asj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bɛniiŋ bɛ tɛ̀ ji tɛ̀ nuuŋ si bɛnchuki bɛnɛɛ. ");
INSERT INTO asj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Se chinɛ be le be ni be kooyi. Lɛ lɛ ŋgo-o mfwaa mumkpaŋ bee bɔɔŋ bee bɛ kintutu-u dza be gɛɛŋ bimbe bi Dalmanuta. ");
INSERT INTO asj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bɛfarasii dza be bɛ fɛ Jiso-o, be bɛchi bitɛchinɛ bɛ wu, be tee le fɛ fiee fi doonchi buŋga bu dzɛti liboo. Be tɛ̀ tiiti lɛ le be mɔnchɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jiso se shɔɔnshɛ ŋge, tee le, “Kiŋgɔkɛ kini wɛki fiee fi doonchi buŋga bu dzɛti liboo le be fɛ la lu? Ntee beŋ chɛɛŋ le kiŋgɔkɛ kini nuuŋ tɛ̀ ŋɛŋ fiee kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Shɛ be, se kaari tuu lɛ lɛ ŋgo-o, lenchi gɛɛŋ liwiŋ lumu lɔɔ. ");
INSERT INTO asj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jiso tɛ̀ giiŋgi lɛ ɛ bɔɔŋ bee bɛ kintutu-u daayɛ le be dzɔɔ kibele, be tɛ̀ kɛmi nɛɛ nuuŋ tsee mumkpaŋ kwaa lɛ ŋgo-o. ");
INSERT INTO asj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Se tuu tifi be tiiti le, “Nɛ dzeti yɛɛŋ, mfi kii kishee ki Bɛfarasii mɔɔ ki Hɛrɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bɔɔŋ bee bɛ kintutu-u bɛchi be yeti be be kii fiee filu, be tiiti le, “Tiitɔɔ kii kishee kini ni kifɛ tɛ mɛɛŋ baa ki kɛmɛ kɛ kibele kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jiso kɛɛ fiee fi be tiiti kii fi, bii li bee laa, “Nɛ tiiti kii kibele ki nɛ kɛmi yɛ kɛ kii la? Nɛ mɛɛŋ baa ki ŋɛŋ kɛ biee, mɔɔ le nɛ kɛɛ biee kɛ ni? Fi nuuŋ le bufii bunɛ mɛɛŋ bwɛɛ saa ki gwiyɛ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nɛ kɛmi lii nɛ tɛ ŋɛŋ biee kɛ ni? Nɛ kɛmi bintooŋ nɛ tɛ woo biee kɛ ni? Nɛ kiimi yɛ biee kɛ ni? ");
INSERT INTO asj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mfi wu ntɛ̀ mbooyɛ tsée yi bibele shiŋ bɛniiŋ bɛnchuki bɛtiinu ji, nɛ tɛ̀ banchɛ biŋkɛ bi tɛ̀ shɛ bi yisɛ bɛŋkaa bɛ mɛ?” Be tuu le, “Yoofi ntsɔ bɛfɛ.” ");
INSERT INTO asj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tuu bii li bee laa, “Kii tsée yi mfomɛnyaaŋ yi bɛniiŋ bee be ji bɛnchuki bɛnɛɛ, nɛ bee nɛ banchɛ biŋkɛ bi shɛ bi yisɛ bɛŋkaa bɛ mɛ?” Be tuu le, “Mfomɛnyaaŋ.” ");
INSERT INTO asj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Se bii li bee laa, “Nɛ mɛɛŋ baa ki kɛɛ kɛ biee ni?” ");
INSERT INTO asj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jiso bee bɔɔŋ bee bɛ kintutu-u tɛ̀ lenchi be bo Besaida, bɛniiŋ bamu bɛ bɛ kinyɛɛ kimu lɛ wuu be lɛkɛ le koŋ li ki-i le wɔnchɛ ki. ");
INSERT INTO asj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jiso kɛmɛ ki li kibɛnɛ-ɛ, dzɔ ki bee ki bo li kitoŋ kilu-u. Kwiyɛ budii li lii yi ki-i, gɛɛ tsaŋ li ki bwiŋ bii li ki-i laa, “Ɔ ŋɛŋgɔɔ biee ni?” ");
INSERT INTO asj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kinyɛɛ kilu tsaaki lii liwe, ki bichɛ ki tee le, “Ŋiŋgɔɔ bɛniiŋ jibi jibi be deŋgi be nuuŋ si biti.” ");
INSERT INTO asj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jiso tuu gɛɛ tsaŋ li lii yi wi wulu-u, mwɛ bichɛ fwiiŋ, lii yee woo, ŋɛŋ biee bichu bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jiso se tee li wuu le, “Ɔ giiŋgi fio fɛkuuŋ, si ɔ giiŋgi lɛ kiiŋ ɔ ni tuu ɔ lɛ li kito-oŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jiso bee bɔɔŋ bee bɛ kintutu-u dza fe be giiŋgi li bitoŋ bi kimbɛ ki Kasaria Filipi. Le be ni be giiŋgi, se bii li bee laa, “Bɛniiŋ kweŋgi le nuuŋ noo?” ");
INSERT INTO asj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Be tuu le, “Bɛniiŋ bamu kweŋgi baa le ɛ wɛ Jɔɔŋ Nlisulidzɔɔ, bamu le Ɛlaja, bamu se kweŋgi le ɔ nuuŋ ntomfɔŋ wu Nyɔ wumu.” ");
INSERT INTO asj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Se fiiki bii li bee laa, “Nɛ kweŋgi finɛ le nnuuŋ noo?” Pita tuu le, “Ɔ nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ.” ");
INSERT INTO asj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jiso chiinsɛ li bee le kiiŋ be ni mɔŋ be tee fini li wi kii wu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bɛchi tiifi bɔɔŋ bee bɛ kintutu-u tiiti kii yi yee le, “Ŋwanɛwi kɛmi le ŋɛŋ bumfa ŋge, bɛniiŋ bɛ sɛki kwɛɛŋ bɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ se faaŋ wu. Be gii be wo wu, ke bo jo taa kaari bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tɛ̀ tiiti biee bini li bee ni gbanaa. Pita se dzɔ wu bee wu cheekiyi, bɛchi wami wu li fiee filu-u. ");
INSERT INTO asj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jiso fiiki yi, bichɛ bɔɔŋ bee bɛ kintutu-u, waŋ Pita tee le, “Dza mi lii Sataŋ! Ɔ lemi yɛ lɛ kimbɛ ki Nyɔ-ɔ kɛ. Ɔ lemɔɔ nuuŋ lɛ ki wiwo-oŋ.” ");
INSERT INTO asj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Se teeŋ kintutu ki bɛniiŋ lɛ bɛ bɔɔŋ bee bɛ kintutu-u, tee li bee le, “Ɛ wi wɛki le ni biki mi, kɛ kɛmɔɔ le faaŋ yi yee, too kintaaŋ kee se biee mi. ");
INSERT INTO asj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nɛ kɛɛ le wi wu bachi ntsɛ we kii ni la, kɛ gii nɛɛ lɛɛ wu. Se nuuŋ le, wi wu lɛɛ ntsɛ we kii mi mɔɔ kii ntoŋ wu dzeeŋ kɛ banchɔɔ ntsɛ wulu bu banchɛ. ");
INSERT INTO asj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ɛ bɛ banchɛ nshɛ yini chichi bɛ nyɛ li wi wu ji, wu tuu wu lɛɛ ntsɛ we, mbeŋ wulu ni nuuŋ la? ");
INSERT INTO asj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Fiee fi wi nuuŋ go fiana yee lu nuuŋ la? ");
INSERT INTO asj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nɛ kɛɛ le ɛ wi kɛmi buya bu biee yɛ mi mɔɔ jɛ yɛŋ lɛnti lɛ kiŋgɔkɛ ki bifisi biee kini-i kɛ wɛ si wi wu chiiŋgi li nyumi kɛ kwɛsi tuu buti jii bukwɛɛ lɛ kuuŋ, mwɛ kɛɛ le Ŋwanɛwi gii naa kɛmɛ buya bɛ mwɛ tɛ mfi wu kaari wu bɛ lɛ bunɔŋa bu Tee lɛ bɛ bɛnchindaa bɛ Nyɔ bɛ wuuti.” ");
INSERT INTO asj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jiso tuu tee li bee le, “Ntee beŋ chɛɛŋ le, bɛniiŋ bamu lemi baa fɛni bɛ nuuŋ tɛ̀ naa woo kintsi ki kwe-e fuki fɛ be ŋɛŋ bumfɔŋ bu Nyɔ-ɔ si bu bɛɛ bɛ buŋga bu buu nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Le jo ka busɔɔ, Jiso dzɔ Pita bee Jeeŋ mɔɔ Jɔɔŋ bee be miri be gɛɛŋ li ŋkumɛ wumu wu ŋgweeŋ li, be gɛɛŋ be nuuŋ fe bebe. Be dza be ŋɛŋ si mfisɛ yi Jiso fiiki lɛ be lii, ");
INSERT INTO asj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ndú yee nɛɛŋ, yi miɛŋini yi yɛki si nuuŋ wi tsootsɛ laaŋkwiiŋ yi nɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Be dza be ŋɛŋ si Ɛlaja bee Mɔɔsɛ busɛ, be yeti bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita se dza tee li Jiso-o le, “Wi wu ntiifɛ wu nyɔŋa, fi dzɔɔŋ fiɛɛ si tɛ baa fɛni ni. Gɛɛ tɛ gwaŋ bigɔɔnu bitɛɛtu, kimu ni ki nuuŋ ko, kimu ki Mɔɔsɛ, kimu se ni ki nuuŋ ki Ɛlaja-a.” ");
INSERT INTO asj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tɛ̀ tiiti lɛ kifɛ jaaŋ tɛ̀ kɔɔ be ŋge tɛ tuu le kɛɛ fiee fi nuuŋ tee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nɛɛ si tɛ̀ mɛɛŋ yeti lɛ, kikuŋ dza ki shee ki baanyɛ be, jɛ se yɔ li kikuŋ kilu linti le, “Wuni nuuŋ Ŋwanɛŋ wu shéŋ. Nɛ wuki yɛɛŋ li wuu.” ");
INSERT INTO asj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Le be tuu bichi lɔɔ, be ti mɛɛŋ tuu kɛ le be ŋɛŋ bɛniiŋ bɛlu kɛ, be ŋɛŋ nɛɛ nuuŋ Jiso kwaa. ");
INSERT INTO asj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Le be dza li ŋkumɛ wulu-u be beki, Jiso chiinsɛ li bee le kiiŋ be ni tee fiee fi be ŋɛŋ li wi-i fuki fɛ Ŋwanɛwi bo li kwe-e nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Be woo lɛ be kiri lɛ be shéŋ, be tɛti maa li yi yi bee laa mbochu li kwe-e wuni nuuŋ la le. ");
INSERT INTO asj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Be se dza be bii li wuu laa, “Ɛ kii la fi bɛniiŋ bɛ tiifi bɛnchi kweŋgi le Ɛlaja kɛmi le saa bɛ se Kinsofu ki Nyɔ tɛ̀ kaachɛ se bɛ?” ");
INSERT INTO asj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jiso tuu li bee le, “Fi fiɛɛ chɛɛŋ le Ɛlaja gii naa saa bɛ nachɛ biee bichu bi to si bi tɛ̀ nuuŋ. Se nuuŋ le, ɛ kii la fi bɛ tɛ̀ tsɛɛ le Ŋwanɛwi kɛmi le naa ŋɛŋ bumfa ŋge, bɛniiŋ se faaŋ wu? ");
INSERT INTO asj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Se nuuŋ le, ntee beŋ le Ɛlaja bɛɛɔ kituŋ, bɛniiŋ se fɛ baa fiee fi be kɔŋgisi bɛ wu. Fi fiɛɛ si bɛ tɛ̀ tsɛɛ kii wu.” ");
INSERT INTO asj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Le Jiso bee bɔɔŋ bee bɛ kintutu-u bɔɔ be bo fɛ bɔɔŋ bɛ kintutu-u bamu tɛ̀ nuuŋ, ŋɛŋ ɛ kintutu ki bɛniiŋ lɛ ŋge kɛnɛ be, bɛniiŋ bamu bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ tɛchini biee bee be. ");
INSERT INTO asj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mfwaa mumkpaŋ, si kintutu kichu tɛ̀ ŋɛŋ Jiso lɛ, ki dzakɛ ŋge, ki letɛ ki gɛɛŋ ki yɛsi wu. ");
INSERT INTO asj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bii li bee laa, “Nɛ tɛchini biee bɛ be kii la?” ");
INSERT INTO asj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wi tɛ̀ tuu li wuu li kintutu kɛɛ linti le, “Wi wu Ntiifɛ, mbee mbɛ bɛ ŋwanɛŋ fɛ wɛ-ɛ kifɛ fiana yimi yɛɛ li wuu bwiŋ, yi ti feti wi to kibere. ");
INSERT INTO asj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Fiana yilu bɛɛ yi choofi wu yi tundi wu fɛkwiiŋ, bɛfuu buti wu lɛ wa, bɛkini bige, dzɛti nɛchi. Mi nteeɔ le bɔɔŋ bo bɛ kintutu-u buu fiana yilu, be mɔŋ nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Le Jiso woo lɛ, tee li bee le, “E ee! Kiŋgɔkɛ ki mɛɛŋ ki gɛɛ kɛ shéŋ li Nyɔ-ɔ kɛ kini. Ŋgii nuuŋ tɛɛbeŋ ŋgɛɛŋ mbo buŋ? Ŋgii ŋkaŋ shéŋ bɛ beŋ ŋgɛɛŋ mbo buŋ? Bɛ yɛɛŋ bɛ ŋwaŋ wulu fɛni nɛ nyɛ li mi-i.” ");
INSERT INTO asj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Be se dzɔ ŋwaŋ wulu be bɛɛ bɛ wu fɛ Jiso-o. Le fiana yilu ŋɛŋ Jiso, yi biee yi chofi ŋwaŋ wulu mfwaa mumkpaŋ we fɛkwiiŋ biŋgisi fe, bɛfuu buti wu lɛwa. ");
INSERT INTO asj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jiso bii li te ŋwaŋ wulu-u laa, “Fiee fini tɛ̀ bɛchi mfi wu la?” Tuu le, “Fi tɛ̀ bɛchi fɛ tɛ̀ mɛɛŋ bwi. ");
INSERT INTO asj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fiana yilu bachɛ yɛɛ wu li kiŋga-a li kiŋga-a fɛ wi-i mɔɔ lidzɔɔ, yi leki le yi wo wu. Ɔɔ nuuŋ ɔ fɛ fiee, nlɛkɔɔ wɛ, ɔ kɔɔ nshiiŋ bɛ bee, ɔ fi bee.” ");
INSERT INTO asj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jiso bii li wuu laa, “Le nnuuŋ mfɛ fiee ni? Nuuŋ mfɛ fiee fichu li wi wu gɛɛ shéŋ li mi-i.” ");
INSERT INTO asj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mfwaa mumkpaŋ te ŋwaŋ wulu waŋ lɛwe ŋge le, “Mi ŋgɛɛɔ shéŋ li Nyɔ-ɔ. Fɛrɛ ntuu ŋgɛɛ yaa lɛ.” ");
INSERT INTO asj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Le Jiso ŋɛŋ si kintutu ki bɛniiŋ lɛ letini ki bɛɛ ki banchi fɛ tɛ̀ nuuŋ, waŋ fiana yi tii yilu, tee le, “Wɛ, fiana yi tii yini yi feti ŋwaŋ wuni tɛ̀ yɔ kɛ tɛ woo biee kɛ, ntiitɔɔ li wɛ-ɛ le, bochɛ li ŋwaŋ wuni-i, ɔ gɛɛŋ. Kiiŋ ɔ ni tuu ɔ lɛ li wuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Fiana yilu waŋ lɛwe ŋge, yi ka yi chofi ŋwaŋ wulu, yi toŋ fɛkwiiŋ lɛ dze yi bifi, yi bo li wuu bwiŋ. Giŋ fɛkwiiŋ si gwini chi wi lɛ. Le bɛniiŋ ŋge ŋɛŋ lɛ, be tee le, “Wu kwiɔ kituŋ!” ");
INSERT INTO asj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jiso kɛmɛ wu li kibɛnɛ-ɛ tsaaki wu leŋ we. ");
INSERT INTO asj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Le Jiso bee bɔɔŋ bee bɛ kintutu-u gɛɛŋ be lɛ li yih, be bii li wuu lɛ jiŋ lɛ jiŋ laa, “Ɛ kii la fi tɛ̀ bee tɛ̀ mɔŋ nsiŋ le tɛ̀ buu ŋwanɛŋ kiŋkundi wulu?” ");
INSERT INTO asj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tuu li bee le, “Fiee fi nuuŋ fi buu ŋwaani wuni nchindaa nuuŋ nlɛkɛ li Nyɔ-ɔ kwaa. Nuuŋ fiee fimu fi chichi tɛ̀ buu wu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Be tɛ̀ dza fe be ka dze yi Galilii, ɛ Jiso tɛ̀ wɛki yɛ le wi kɛɛ kɛ, ");
INSERT INTO asj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kifɛ tɛ̀ deŋgi tiifi bɔɔŋ bee bɛ kintutu-u. Tɛ̀ tiifi be le bɛniiŋ gii be nyɛ Ŋwanɛwi li tsaŋ yi bɛniiŋ li be wo wu. Ke bo jo taa, bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Le tee lɛ, be ti mɛɛŋ ki kɛɛ kɛ fiee fi tɛ̀ tiiti kɛ, kifɛ be tɛ̀ chɛndi mbifu li wuu. ");
INSERT INTO asj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Be gɛɛŋ be bo Kapanuŋ, le be lɛ be ni be nuuŋ li yih, Jiso bii li bee laa, “Nɛ bee nɛ tɛchini biee lɛ dze kii la?” ");
INSERT INTO asj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Be ba nshiiŋ, kifɛ be tɛ̀ deŋgi lɛ dze be tɛchini li yi yi bee laa wi wu limfwe nuuŋ noo le. ");
INSERT INTO asj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jiso shee fɛkwiiŋ, teeŋ bɛ yoofi ntsɔ bɛfɛ baa tee li bee le, “Ɛ wi wɛki le ni nuuŋ wi wu limfwe, kɛ kɛmi le dzɔɔ yi yee le wɛ wi wu kinshiiŋgi mɔɔ wi wu nindi li bɛniiŋ bɛchu-u.” ");
INSERT INTO asj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Le tee lɛ, dzɔ ŋwaŋ wu bwi leeki lɛ bee lɛnti, tuu dzɔ too wu bɔ tee li bee le, ");
INSERT INTO asj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ɛ wi fi ŋwaŋ si wuni li bukooŋ bwe-eŋ, kɛ wu fiɔ nuuŋ mi. Wi wu fi mi, kɛ mɛɛŋɔ ki fi kɛ nuuŋ mi kwaa kɛ, wu fiɔ nuuŋ wi wu toŋ mi.” ");
INSERT INTO asj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jɔɔŋ tee li wuu le, “Wi wu Ntiifɛ, tɛ̀ bee tɛ̀ ŋɛŋ wumu teenyi bukooŋ bwo se busi bɔɔŋ bɛ kiŋkundi-i li bɛniiŋ li, tɛ̀ loosɛ wu, kifɛ nuuŋ yɛ wi wusɛŋ wu kintutu kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Se nuuŋ le, Jiso tɛ̀ tuu li bee le, “Nɛ loosɛ kɛ ŋwaani wɛɛ wi kɛ. Nɛ kɛɛ le ɛ wi feti mfiŋ teenyi bukooŋ bweŋ, kɛ mwɛ nuuŋ yɛ wi wu nuuŋ tuu ni baanini mi kɛ. ");
INSERT INTO asj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɛ wi gwii yɛ bɛ bee kɛ, kɛ mwɛ fɛɛfɔɔ bee. ");
INSERT INTO asj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ntee beŋ chɛɛŋ le, ɛ wi nyɛ mɔɔ nuuŋ fika fi dzɔɔ lɛ li be-eŋ le nɛ woŋ kifɛ bɛ teenyi baa beŋ le bɛniiŋ bɛ Krai lɛ, kɛ nuuŋ mwɛ tɛ̀ naa foo kinderi kee lɛ dzé chichi-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jiso tuu tee le, “Ɛ wi fɛ ŋwaŋ mumkpaŋ li kintutu ki bɔɔŋ bɛ bwi bɛ gɛɛ shéŋ li mi-i bani we li bibifi-i, kɛ fi dzɔɔŋ fiɛɛ le wɛɛ wi-i le bɛ shiiŋɛ jeni chi nɔŋa li kimi kee li, bɛ bachɛ wu li dzɔɔ yi nyɔŋa. ");
INSERT INTO asj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Fi tuu fi nuuŋ le, ɛ kibɛnɛ ko feti le ɔ ni ɔ feti bubiɛɛ, ɔ sondɛ kibɛnɛ kilu. Fi dzɔɔŋ le ɔ lɛ li ntsɛ wu kimakɛ-ɛ bɛ kibɛnɛ kiŋkɔsi, yɛki fɛ ɔ nuuŋ ɔ ni ɔ nuuŋ bɛ bibɛnu bio bichu ɔ tuu ɔ gɛɛŋ fɛ wi wu kimakɛ-ɛ wu duti nyimu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ɛ kikaa ko feti le ɔ ni ɔ feti bubiɛɛ, ɔ sondɛ kikaa kilu. Fi dzɔɔŋ le ɔ lɛ li ntsɛ wu kimakɛ-ɛ ɔ mɛndi, yɛki le ɔ kɛmɛ bikaa bichu bɛ se lɔŋ wɛ fɛ wi wu kimakɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɛ lisi cho feti le ɔ ni ɔ feti bubiɛɛ, ɔ buu lisi chilu. Fi dzɔɔŋ le ɔ lɛ li bumfɔŋ bu Nyɔ-ɔ bɛ lisi chimumkpaŋ, yɛki fɛ ɔ ni kɛmɛ lii chichi, bɛ se lɔŋ wɛ fɛ wi wu nyɔŋa-a. ");
INSERT INTO asj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kintsii kini nuuŋ ki bimuunu jii bɛniiŋ fe bi tɛ naa kwi kɛ, wi tɛ̀ naa nyiŋ fe kɛ. ");
INSERT INTO asj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nɛ kɛɛ le wi gii naa wu mɔŋ wi kwikwi nɛɛ si bɛ ti kusi fiee bɛ ntɔŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ntɔŋ ti nuuŋ fiee fi dzeeŋ, fi se fiɛɛ le, ɛ me to n'yikɛ nsiŋ, ɔ gii ɔ geeŋ bɛ me se me kaari me yikɛ? Nɛ nuuŋ yɛɛŋ si ntɔŋ mɛ yiki, wi bee wi se ni be nuuŋ li mbɛɛŋgii li.” ");
INSERT INTO asj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jiso se dza fe, gɛɛŋ kimbɛ ki Judiya-a, lenchi Dzɔɔ yi Joodaaŋ gɛɛŋ luwiŋ. Bintutu bi bɛniiŋ lɛ tuu bi banchi bi bɛɛ lɛ wuu, tiifi be nɛɛ si tɛ̀ shiiŋ tiifi. ");
INSERT INTO asj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɛfarasii dza be bɛ le be mɔnchɛ wu, be bii li wuu laa, “Nchi beŋ le nuuŋ wi kooŋ bɛ kwɛsi ni?” ");
INSERT INTO asj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jiso kaari bii tɛ li bee laa, “Mɔɔsɛ tɛ̀ nyɛ nchi le nɛ ge la?” ");
INSERT INTO asj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Be tuu le, “Mɔɔsɛ tɛ̀ gɛɛ le nuuŋ wi kooŋ bɛ kwɛsi. Ɛ kuŋgi lɔɔ, tsɛɛ kiŋwaati ki doonchi le wu kooŋɔ bɛ wu, nyɛ li wuu.” ");
INSERT INTO asj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jiso tuu li bee le, “Tɛ̀ nuuŋ kii bikoo binɛ bi tɛɛmɛ bi Mɔɔsɛ tɛ̀ tsɛɛ nchi wuni li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Se nuuŋ le, tɛ̀ nuuŋ fɛmbɛɛchɛ-ɛ mfi wu Nyɔ tɛ̀ tɔŋ biee, tɛ tɔŋ nuuŋ nyuŋ bee kwɛɛŋ. Si tɛ̀ tɔŋ lɛ, tee le, ");
INSERT INTO asj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ɛ kii fini fi nyuŋ gii shɛ tee bee ni taashɛ bee kwɛsi, ");
INSERT INTO asj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","be bɛfɛ se to wi mumkpaŋ.’ Nɛɛlɛ, be mɛɛŋ yɛ bɛniiŋ bɛfɛ kɛ, be baa dɛɛni wi mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Fi se nuuŋ le, fiee fi Nyɔ taashɛ, kiiŋ wi ni mɔŋ ŋgatinɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Le Jiso bee bɔɔŋ bee bɛ kintutu-u gɛɛŋ be ni be nuuŋ li yih, be ka be bii li wuu kii fiee filu. ");
INSERT INTO asj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tuu li bee le, “Mɔɔ nuuŋ noo wu kooŋ bɛ kwɛsi wu dzɔ wumu, kɛ wu fɛɔ bubiɛɛ li kwɛsi-i li ŋgimu bɛ kwɛɛŋ wumu-u. ");
INSERT INTO asj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɛ kwɛɛŋ bo li nyumi-i, wu gɛɛŋ wu giŋ bɛ nyuŋ wumu, kɛ wu fɛɔ bubiɛɛ li nyumi-i li ŋgimu bɛ nyuŋ wumu-u.” ");
INSERT INTO asj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bɛniiŋ tɛ̀ dza be bɛɛ bɛ bɔɔŋ lɛ Jiso-o le koŋ li bee, bɔɔŋ bee bɛ kintutu-u wami be. ");
INSERT INTO asj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Le Jiso ŋɛŋ lɛ, shéŋ tɔŋ wu, tee li bee le, “Gɛɛ yɛɛŋ bɔɔŋ bɛ bwi ni be bɛɛ lɛ mi-i, nɛ baŋgɛ kɛ be kɛ, kifɛ bumfɔŋ bu Nyɔ-ɔ bwɛɛ nuuŋ li bɛniiŋ si bani-i. ");
INSERT INTO asj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ntee beŋ chɛɛŋ le, ɛ wi mɛɛŋ ki fi kɛ bumfɔŋ bu Nyɔ-ɔ si ŋwaŋ wu bwi kɛ, mwɛ tɛ naa mɔɔ lɛ lɛ bumfɔŋ bulu-u kɛ”. ");
INSERT INTO asj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Si tɛ̀ tee lɛ, dzeti be kokini li guu, giki tsaŋ li bee, tiŋi mwɛ li bee. ");
INSERT INTO asj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jiso dza le giiŋgɔ, wi wumu letɛ bɛ toŋ núŋ wu lii bii li wuu laa, “Wi wu Ntiifɛ, wɛ wu wi wu dzeeŋ, fiee fi ŋkɛmi le mfɛ nse ŋkɛmɛ ntsɛ wu kimakɛ nuuŋ fi la?” ");
INSERT INTO asj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jiso bii li wu laa, “Ɔ teenyi mi le wi wuu dzeeŋ kii la? Wi nuuŋ yɛ lu wu nuuŋ wi wu dzeeŋ kɛ. Ɛ nɛɛ Nyɔ kwaa yi nuuŋ wi wu dzeeŋ. ");
INSERT INTO asj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mɔɔ ɔ kiiɔ bɛnchi bɛ nuuŋ le, ‘Kiiŋ ɔ ni wo wi kɛ, kiiŋ ɔ ni giiŋ bɛ kwɛɛ wi kɛ, kiiŋ ɔ ni yi biee kɛ, kiiŋ ɔ ni leŋ lɛ nsa wu binsɛɛ lɛ lɛjiŋ kɛ, kiiŋ ɔ ni fɛ kimfi kɛ, mɔɔ le ɔ ni ɔ guundi chaa bɛ na?’” ");
INSERT INTO asj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wi wulu tuu li Jiso-o le, “Wi ntiifɛ, bɛnchi bani bɛchu ntɛ mbɛchi ŋkichi be mɛɛŋ sɔɔnɛwi.” ");
INSERT INTO asj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jiso bichɛ wu ni fwiiŋ, kɔɔŋgi wu, tee li wuu le, “Fiee shɛ fiɛɛ fimumkpaŋ fi ɔ mɛɛŋɔ ɔ fɛ. Gɛnɛ ɔ kabɛ biee bi ɔ kɛmi bichu, ɔ gachɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ, ɔ se kɛmɛ bulofu nuuŋ liboo. Ɔɔ fɛ lɛ, ɔ se bɛ ɔ ni ɔ biki mi.” ");
INSERT INTO asj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Le Jiso tee lɛ, wi wulu woo, soo bilii, fiiki yi yee dza giiŋgi nshiiŋ nshiiŋ, kifɛ tɛ̀ kɛmi kwa ŋge. ");
INSERT INTO asj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jiso dza fiiki yi bichɛ bɔɔŋ bee bɛ kintutu-u, tee li bee le, “Fi gii fi tɛmi ŋge le bɛniiŋ bɛ kwa lɛ li bumfɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","N'yɔru wulu fieeŋgi bɔɔŋ bee bɛ kintutu-u. Jiso tuu tee li bee le, “Bɔɔŋ beŋ, fi tɛɛmi ŋge fɛ wi-i le lɛ li bumfɔŋ bu Nyɔ-ɔ! ");
INSERT INTO asj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Fi fiɛɛ tsɛkɛ fɛ kikuŋ nuuŋ ki lɛ lɛ fiooŋ yi nsara-a yɛki fɛ wi wu kwa nuuŋ lɛ li bumfɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Be woo lɛ fi se fieeŋgi be ŋge, be tuu be njanjɛ be tee le, “Ɛ fi nuuŋ lɛ, noo se naa bo lu?” ");
INSERT INTO asj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jiso kaari bichɛ be, tee le, “Fini nuuŋ fi yaa wiwoŋ, se nuuŋ le fi tɛ̀ nyɛ tɛ yaa Nyɔ kɛ, kifɛ Nyɔ nuuŋ yi fɛ fiee fichu.” ");
INSERT INTO asj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita se dza tee li Jiso-o le, “Bichɛ ɔ ŋɛŋ, tɛ chinɛ baa biee bichu tɛ tuu tɛ biki wɛ.” ");
INSERT INTO asj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jiso tuu li wuu le, “Ntee wɛ chɛɛŋ le, wi nuuŋ yɛ lu wu chinɛ yih ye, kɛ bɛŋwaani, kɛ dzɛ́mi yee, kɛ ni, kɛ tee, kɛ bɔɔŋ bee, kɛ yɛ́h yee, le wu chinɔɔ kii mi mɔɔ ntoŋ wu dzeeŋ wu kii Nyɔ, ");
INSERT INTO asj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wu nuuŋ tɛ nuuŋ le kɛmɛ yih mɔɔ bɛŋwaani, mɔɔ dzɛmi, mɔɔ bɛni, mɔɔ bɔɔŋ, mɔɔ yɛ́h li ntsɛ wu dɛɛni foo ŋkɛmɛ kiŋga gwii siŋ kɛ. Bɛniiŋ gii be tuu be ni be biindi tɛ bikaa lɛ wuu jiŋ, ke tuu nuuŋ li mfi wu ntsɛ wu bɛɛ li, nɛ kɛmɛ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Se nuuŋ le, bɛniiŋ ŋge bɛ nuuŋ limfwe dɛɛni gii be nuuŋ lɛjiŋ, bɛ ŋge bɛ nuuŋ lɛjiŋ dɛɛni to limfwe.” ");
INSERT INTO asj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jiso bee bɔɔŋ bee bɛ kintutu-u dza be dzɔ dze, be yɛki Jɛrosalɛŋ tuuti mbaaŋ. Bɔɔŋ bee bɛ kintutu-u tɛti maa. Bɛniiŋ bɛ tɛ̀ biki wu, tɛ̀ kɛmi chɛnɛ. Jiso tuu dzɔ bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa bee be cheekiyi se tuu tiiti be fiee fi gii fi ka bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tee li bee le, “Yikɛ yɛɛŋ nɛ woo, tɛ yɛki baa tɛ giiŋgi Jɛrosalɛŋ bɛ giiŋgi baa bɛ nyɛ Ŋwanɛwi li tsaŋ yi bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ, be saa wu be sondɛ le be wo wu, be nyɛ wu li tsaŋ yi bito-oŋ, ");
INSERT INTO asj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","be ni be choosi wu, be kwiyi wu bɛ budii, be ni be tuki wu, be se wo wu, ke bo jo taa, bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jeeŋ bee Jɔɔŋ bɛ tɛ̀ nuuŋ bɔɔŋ bɛ Dzɛbɛdii dza be kiŋgi be bɛ Jiso limfwe be tee li wuu le, “Wi wu Ntiifɛ, fiee fiɛɛ lu fi tɛ wɛki le ɔ fɛ li bee li.” ");
INSERT INTO asj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jiso bii li bee laa, “Nɛ wɛki le mfɛ la li be-eŋ?” ");
INSERT INTO asj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Be tuu le, “Tɛ wɛki baa le ke mfi wuɔ shee li kabara wu bunɔŋa bwo-o, tɛ shee li bintindu-u bi nɔŋa bi nɔŋa, wi wumu lɛ kibɛnɛ ko ki kigɔŋɛ-ɛ, wumu lɛ kibɛnɛ ki kimɛsɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Se nuuŋ le, Jiso tɛ̀ tuu li bee le, “Nɛ kii yɛ fiee fi nɛ biiti kɛ. Nuuŋ nɛ woŋ fika fi ŋgɛ-ɛ fi ŋgii ŋ'woŋ, kɛ nɛ lɛ li ŋwaani ŋgɛ wu nyɔŋa wu ŋgii nlɛ wuni ni?” ");
INSERT INTO asj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Be tuu li wuu le, “Tɛ nuuŋ tɛ fɛ.” Jiso tee li bee le, “Nuuŋ nɛ woŋ fika fi ŋgɛ-ɛ fi ŋgii ŋ'woŋ, kɛ nɛ lɛ tɛ ŋwaani ŋgɛ wu nyɔŋa wu ŋgii lɛ lu wuni. ");
INSERT INTO asj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Se nuuŋ le li nshewu lɛ kibɛnɛ keŋ ki kigɔŋɛ-ɛ kɛ lɛ ki kimɛsɛ-ɛ nuuŋ yɛ kintsii keŋ le nyɛ li wi-i kɛ. Bintsii bilu biɛɛ li bɛniiŋ bɛ bɛ nachɛ li bee.” ");
INSERT INTO asj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Le kiŋkɛ ki bɔɔŋ bɛ kintutu-u bɛ Jiso bɛ yoofi baa tuu be woo kii fiee filu shéŋ tɔŋ be bɛ Jeeŋ bee Jɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jiso se teeŋ be bɛchu be bɛ, tee li bee le, “Mɔɔ nɛ kii baa le bɛniiŋ bɛ sɛki tɛɛŋ yimi ti shiiti li bɛniiŋ bɛbee bɛ bito-oŋ, bɛniiŋ bɛ nɔŋa bɛ nɔŋa bɛbee doonchi buŋga lɛ bee lɛwe ni? ");
INSERT INTO asj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Fiɛɛ kɛmi yɛ le fi ni fi nuuŋ li be-eŋ linti kɛ. Wi wu wɛki le ni nuuŋ wi wu nyɔŋa lɛ be-eŋ lɛnti kɛmi le ni nuuŋ wi nindi li be-eŋ bu nimu. ");
INSERT INTO asj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Wi wu wɛki le ni nuuŋ wi wu limfwe li be-eŋ linti, kɛ kɛmɔɔ le ni nuuŋ mfwa wu wi kwikwi. ");
INSERT INTO asj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nɛ kɛɛ le Ŋwanɛwi ti mɛɛŋ ki bɛ kɛ le bɛniiŋ ni be nindi li wuu kɛ. Tɛ̀ bɛ nuuŋ le niŋ li bɛniiŋ li, nyɛ ntsɛ we soo bɛniiŋ ŋge li tsaŋ yi kwe-e.” ");
INSERT INTO asj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Be dɛndɛ be bɛ be bo li kitoŋ ki Jɛriko-o. Le Jiso ni tuu dzɛti fe, bee bɔɔŋ bee bɛ kintutu mɔɔ kintutu ki bɛniiŋ lɛ ki nɔŋa, be ŋɛŋ kinyɛɛ kimu ɛ ki shee li ŋgemɛ yi dze-e ki lɛki biee bukooŋ le Batimayu, ŋwanɛ Timayu. ");
INSERT INTO asj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Le woo le ɛ Jiso wu Nasarɛ, bɛchi dzɛŋgi le, “Jiso, Ŋwanɛ kini ki Mfɔŋ Daafi, kɔɔ nshiiŋ bɛ mi.” ");
INSERT INTO asj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bɛniiŋ ŋge dza be bɛchi be wami wu, be tiiti le makɛ. Se nuuŋ le, tɛ̀ tuu mɛɛshi dzaaŋ le, “Ŋwanɛ kini ki Mfɔŋ Daafi, kɔɔ nshiiŋ bɛ mi.” ");
INSERT INTO asj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jiso leŋ, tee le be teeŋ wu. Be se teeŋ kinyɛɛ kilu be tee le, “Kɛmɛ shéŋ, dza we, teenyɔɔ wɛ.” ");
INSERT INTO asj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kinyɛɛ kilu lɔŋ ndu ye fɛkwiiŋ, ki jiŋ liwe ki gɛɛŋ fɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jiso bii li ki-i laa, “Ɔ wɛki le mfɛ la li wɛ?” Se kinyɛɛ kilu tuu le, “Wi Ntiifɛ, ŋ'wɛkɔɔ le ŋɛŋ biee.” ");
INSERT INTO asj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jiso se tee li ki-i le, “Ɔ giiŋgi fio. Shéŋ yi ɔ gɛɛ li mi-i fɛ yɛɛ ɔ tɛmi.” Mfwaa mumkpaŋ, lii yi ki woo, ki tuu ki ŋɛŋ biee, ki dza ki biki Jiso fɛ tɛ̀ giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Le Jiso bee bɔɔŋ bee bɛ kintutu-u ni be fɛɛshi Jɛrosalɛŋ fɛ be tɛ̀ nuuŋ li bintsii bi Bɛtfaj lichiŋ bɛ bi Bɛtani bi nuuŋ lichiŋ li Ŋkumɛ wu Biti bi Oli-if, buu bɔɔŋ bee bɛ kintutu-u bɛfɛ toŋ, ");
INSERT INTO asj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tee li bee le, “Gɛnɛ yɛɛŋ li kintsii ki nuuŋ limfwe kii yɛ, si nɛ gii nɛ ni nɛ lii fe ni, mfwaa mumkpaŋ, nɛ gii nɛ ŋɛŋ ŋwanɛ sɔmbwaa ɛ bɛ kaŋ, wi mɛɛŋɔɔ saa kɛ le beŋ li wuu liwe kɛ, nɛ fanchɛ nɛ bɛ bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɛ wi bii li be-eŋ laa nɛ fanchi kii la le, nɛ tuu le Te Kikoo kɛmɔɔ fiee fi fɛrɛ bɛ wu, gii kaari tuu wu lijiŋ dɛɛŋ dɛɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Be se dza be gɛɛŋ be ŋɛŋ ŋwanɛ sɔmbwaa wulu ɛ bɛ kaŋ wu fɛ fweeŋ wu yih yimi lɛ dze. Be se fanchɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Si be tɛ̀ fanchi lɛ bɛniiŋ bamu bɛ tɛ̀ lemi fe bii li bee laa, “Nɛ fanchi ŋwanɛ sɔmbwaa wɛɛ kii la?” ");
INSERT INTO asj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Be se tee li bee fiee fi Jiso bee tee. Be chinɛ li bee be gɛɛŋ bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Be bɛ bɛ wu fɛ Jiso-o, be deeri ndú yi be li sɔmbwaa wulu-u liwe, Jiso beŋ li wuu. ");
INSERT INTO asj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bɛniiŋ ŋge tɛ̀ gikisi ndú lɛ dze, bamu bonyi yɛ́ŋɛ yi biti libuka be gikisi tɛ̀ lɛ dze. ");
INSERT INTO asj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bɛniiŋ bɛ tɛ̀ giiŋgi Jiso limfwe mɔɔ bɛ tɛ̀ biki lɛjiŋ tɛ̀ wuuyi le, “Yiyi-i, yiyi-i, yiyi-i, kiyɔɔni nuuŋ li Nyɔ-ɔ looo! Nyɔ tiiŋ yɛ mwɛ li wi wu bɛɛ li bukooŋ bu Taa lɛ looo! ");
INSERT INTO asj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyɔ tiiŋ yɛ mwɛ li bumfɔŋ bu taa wusɛŋ wu Daafi-i bu bɛɛ li looo, mpiaru nuuŋ li Nyɔ-ɔ yi liboo li looo, yiyi-i, yiyi-i, yiyi-i!” ");
INSERT INTO asj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jiso se gɛɛŋ fɛsi Jɛrosalɛŋ lɛ li yih yi muntofi, bichɛ ŋɛŋ si biee bichuchu nuuŋ. Le mɛrisi lɔɔ nuuŋ si mfi tɛ̀ ka lɛ, bee bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa dza be gɛɛŋ Bɛtani. ");
INSERT INTO asj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Butuu bo bu woo Jiso bee bɔɔŋ bee bɛ kintutu-u dza Bɛtani be tuu be giiŋgi Jɛrosalɛŋ dzeeŋ tɛ̀ wuu wu. ");
INSERT INTO asj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Lɔŋ lii ŋɛŋ kiti kimu limfwe mfiiŋ ki bɛ ti shiiŋ bɛ jii, ki bɔchi bɛ bibɛ. Se dza giiŋgi fe le ŋɛŋ laa nuuŋ nɛɛ kɔ fiee li ki-i jii le. Le gɛɛŋ bo fe ti mɛɛŋ ki ŋɛŋ kɛ fiee li kii kɛ, ŋɛŋ nuuŋ bibɛ kwaa, kifɛ tɛ̀ nuuŋ yɛ mfi wu ki ti wundi kɛ. ");
INSERT INTO asj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Se tee li kiti kilu le, “Kiiŋ wi ni naa tuu ka ji fiee li wɛ-ɛ kɛ.” Si tɛ̀ tee lɛ bɔɔŋ bee bɛ kintutu-u woo. ");
INSERT INTO asj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Be dza be gɛɛŋ be fɛsi Jɛrosalɛŋ Jiso se gɛɛŋ lɛ li yih yi muntofi-i bɛchi kuŋgi bɛniiŋ bɛ tɛ̀ feti waŋ fe. Tɛ̀ kuŋgi lɛ bachi mɔɔ bidaŋ bi bɛniiŋ bɛ tɛ̀ fikisi kwa-a, mɔɔ bintindu bi bɛniiŋ bɛ tɛ̀ kabini bibimu-u. ");
INSERT INTO asj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tɛ̀ mɛɛŋ tuu kɛ le beŋ le, wi too fiee dansɛ bɛ fi li yih yi muntofi kɛ. ");
INSERT INTO asj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Se tɛ̀ tiifi be tiiti le, “Mɔɔ bɛ tɛ̀ tsɛɛ Nyɔ tiiti le, ‘Yih ye bɛ gii bɛ ni bɛ teenyi le yih yi nlɛkɛ li Nyɔ-ɔ li tɛɛŋ chichi-i?’ Se nuuŋ le, nɛ fiiki baa yih yi to ntuuŋ wu bɛyi.” ");
INSERT INTO asj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Le bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi woo lɛ be se tuu be wɛki dze yibe gii be wo wu le. Be tɛ̀ kɛmi chɛnɛ li ŋ'wo wuu kifɛ kintutu ki bɛniiŋ lɛ kɛɛ kichu tɛ̀ wuki ntiifɛ we bimfimu wondini be. ");
INSERT INTO asj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Le tuu ni nuuŋ lɛ fɛmfo-o, Jiso bee bɔɔŋ bee bɛ kintutu-u bo li kitoŋ kilu-u. ");
INSERT INTO asj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jiso bee bɔɔŋ bee bɛ kintutu-u bo be kɛti fɛŋwɛɛ, be ŋɛŋ kiti kɛɛ ɛ ki wɔɔbɛ kichu ki shee ki bo li gɛɛŋ li. ");
INSERT INTO asj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita kimi fiee fi tuu fi ka, kweeŋ li Jiso-o le, “Wi wu Ntiifɛ, ŋɛŋ si kiti ki ɔ tuu ɔ tsoŋ kɛɛ si ki wɔɔbɛ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jiso se tee li be bɛchu-u le, “Gɛɛ yɛɛŋ shéŋ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ntee beŋ chɛɛŋ le, ɛ wi tee li ŋkumɛ wuni-i le, ‘Mubɛ fɛni ɔ gɛɛŋ ɔ we li dzɔɔ yi nyɔŋa’, ɛ tiiti lɛ mɛŋini yɛ li shéŋ yee li kɛ, nuuŋ ɛ wu beŋ le fiee fi tiiti nuuŋ fi ji, wu mubɛ. ");
INSERT INTO asj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bɛdɛɛni, ntee beŋ chɛɛŋ le, fiee fichu fi nɛ lɛkɛ li Nyɔ-ɔ, ɛ nɛ beŋ le nɛ kɛmɛ baa kituŋ, kɛ nɛ gii nɛ kɛmɛ. ");
INSERT INTO asj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ɛ nɛ leŋ le nɛ lɛkɛ li Nyɔ-ɔ, ɛ nuuŋ le wumu kɛmi wumu lɛ shéŋ, feeki wu. Nɛ feti lɛ kifɛ Baa wunɛ wu nuuŋ liboo gii ni fekisi tɛ bibifi binɛ.  ");
INSERT INTO asj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ɛ nɛ mɛɛŋ ki feeki kɛ bibifi bi bɛniiŋ bamu-u kɛ, Baa wunɛ wu nuuŋ liboo nuuŋ tɛ dzɛŋ le ni fekisi tɛ binɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jiso bee bɔɔŋ bee bɛ kintutu-u tɛ̀ tuu be bɛ be lɛ Jɛrosalɛŋ. Le ni tuu deŋgi fɛ yih yi muntofi, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ mɔɔ bɛniiŋ bɛ sɛki kwɛɛŋ dza be bɛ be ŋɛŋ wu, ");
INSERT INTO asj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","be bii li wuu laa, “Ɔ dzɔ buŋga fɛŋ bu ɔ feti biee bini? Ɛ noo wu nyɛ wɛ buŋga bulu le ɔ ni ɔ feti biee bini?” ");
INSERT INTO asj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jiso tee li bee le, “Ŋgii mbii fiee li be-eŋ fimumkpaŋ, nɛ tuu mi, nse ntuu ntee beŋ wi wu nyɛ buŋga le ni mfeti biee bini. ");
INSERT INTO asj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ɛ noo wu tɛ̀ nyɛ Jɔɔŋ buŋga se lisi bɛniiŋ li dzɔɔ? Ɛ Nyɔ mɔɔ wi wu laaŋ we le? Tee yɛɛŋ mi ŋ'woo!” ");
INSERT INTO asj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Be se bɛchi be tɛchini li yi yi bee le, “Ɛ tɛ tuu le ɛ Nyɔ, se bii li bee li laa, ɛ la fi tɛ̀ fɛ, se tɛ mɛɛŋ ki beŋ kɛ li Jɔɔŋ li kɛ? ");
INSERT INTO asj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɛ nuuŋ le tɛ tuu le ɛ wiwoŋ wu nyɛ, nuuŋ fi ji ni?” Be tɛ̀ chɛndi bɛniiŋ kifɛ bɛniiŋ bɛchu tɛ̀ beŋ le Jɔɔŋ tɛ̀ gbɛŋgi nuuŋ ntomfɔŋ wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bɛdɛɛni, be se tuu li Jiso le, “Tɛ kii yɛ kɛ.” Jiso se tuu tee li bee le, “Kɛ nuuŋ ntɛ̀ ntee tɛ beŋ wi wu nyɛ mi buŋga le ni mfeti biee bini kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiso se dza bɛchi yeti li bee lɛ ŋgaŋgaa li le, “Wi wumu tɛ̀ niŋ wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu, toŋ mbaŋ kɛnɛ, se chiŋ kisɔ ki bɛ gii bɛ ni bɛ seendi muntaaŋ mulu le mbiiŋ buti, gwaŋ kikɔ li wi wu kiichi wɛ wulu, gɛɛ bɛniiŋ li wɛ wulu-u, se dza gɛɛŋ li kitoŋ kimu-u. ");
INSERT INTO asj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Le mfi wu bɛ ti kee mu bɛ wu kɔchɛ, toŋ ŋwani wu nimɛ wumu lɛ bɛniiŋ bɛ tɛ̀ gɛɛ wɛ li bee baa le be nyɛ wu mwee muntaaŋ le be bɛ mu. ");
INSERT INTO asj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Le gɛɛŋ, be tuu be kɔɔ wu be too wu, be kooŋ bɛ wu, to lijiŋ bɔ kilɛrɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wi wu wɛ wulu se tuu ka toŋ ŋwani wu nimɛ wumu, le gɛɛŋ, be ka be too wu be tɔ wu kikoo, be chɔɔri wu. ");
INSERT INTO asj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Se tuu ka toŋ wumu, be wo wu buwo. Se tuu nɛɛ toŋ bamu ŋge mumkpaŋ mumkpaŋ, be too bamu, be woyɛ bamu. ");
INSERT INTO asj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Toŋ nsiiŋ bɛ shɛ nuuŋ ŋwaŋ mumkpaŋ, wuni se nuuŋ ŋwani nuuŋ shéŋ yee tɛ̀ mɛɛshi toŋ wu lɛ bee, beechi le be gii be gɛɛŋ be guuŋ kwiiŋ li ŋwani wulu-u. ");
INSERT INTO asj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Le gɛɛŋ, bɛniiŋ bɛlu tuu be tee li yi yi bee le, ‘Wuni wɛ kinjila ki wi wu wɛ wuni-i, bɛ yɛɛŋ tɛ wo wu, bishɛyɛ bilu se ni bi nuuŋ bisɛŋ.’ ");
INSERT INTO asj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Be se kɔɔ wu, be wo wu, be buu wu be lɔŋ wu lɛ mba-aŋ lɛkuuŋ.” ");
INSERT INTO asj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Le Jiso tee lɛ, se bii laa, “Fiee fi wi wu wɛ wuni nuuŋ fɛ, nuuŋ la? Gii bɛ lɛɛshɛ bɛ bɛniiŋ balu bu lɛɛshɛ, gɛɛ nuuŋ bɛniiŋ bɛ detɛ li wɛ wulu-u. ");
INSERT INTO asj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nɛ mɛɛŋ baa ki teeŋ kɛ kintsii kini lɛ Kiŋwaati ki Nyɔ-ɔ ni? Bɛ tsɛɛ le, ‘Tɛtɛ chi bɛniiŋ bɛ ŋgwanu tɛ̀ faaŋ, tɛ̀ tuu chi dza chi to tɛtɛ chi boo chi yi-i. ");
INSERT INTO asj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Fini nuuŋ mfɛru wu Taa, bɛniiŋ se bichi be tii wa.’” ");
INSERT INTO asj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bɛniiŋ baa woo ŋgaŋgaa chini, be se kɛɛ le Jiso waɔ nuuŋ li bee. Be se wɛki le be kɔɔ wu, be chɛndi nuuŋ kintutu ki bɛniiŋ lɛ ki tɛ̀ nuuŋ fe. Be se chinɛ li wuu, be dza be giiŋgi. ");
INSERT INTO asj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bikoo bi kwɛɛŋ lɛ dza bi toŋ Bɛfarasii mɔɔ bɛniiŋ bamu bɛ kintutu ki Mfɔŋ Hɛrɔ le be gɛɛŋ be terɛ Jiso be kɔɔ wu li n'yɔru we-e. ");
INSERT INTO asj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Be bɛ be tee li Jiso-o le, “Wi wu ntiifɛ, tɛ ti kii le ɔ shiiŋ ɔ tiiti nuuŋ chɛɛŋ, kifɛ ɔ chɛndi yɛ wi lii kɛ, mɔɔ mwɛ nuuŋ noo le. Ɔ tiifi chɛɛŋ lɛ dze yi Nyɔ-ɔ. Tee bee laa nchi beenchi le bɛ ni bɛ suuti kiŋwaati li Kaisa wu nuuŋ Mfɔŋ wu nyɔŋa wu Lom, mɔɔ wu mɛɛŋ ki beŋ kɛ le? ");
INSERT INTO asj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tɛ ni tɛ suuti, mɔɔ tɛ soo kɛ le?” Jiso kɛɛ fiee fi be gii be kanyi bɛ fi, tuu li bee le, “Nɛ teeki mi kii la? Bɛ yɛɛŋ bɛ lisi chi kwa-a ŋɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Be se bɛ bɛ chi, fi, bii laa, “Kikoo kini bɛ bukooŋ buni nuuŋ bu noo lɛ?” Be tuu le, “Ɛ ki Kaisa, bukooŋ se nuuŋ nɛɛ bwee.” ");
INSERT INTO asj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jiso se tee li bee le, “Nɛ nyɛɛ fiee fi nuuŋ fi Kaisa li wuu, nɛ nyɛɛ fi Nyɔ li Nyɔ-ɔ.” Le be woo lɛ, yi kwi be. ");
INSERT INTO asj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bɛsadusii bamu tɛ̀ dza be bɛ le be bii fiee li Jiso-o. Bɛsadusii tɛ̀ nuuŋ bɛniiŋ bɛ tɛ̀ kweŋgi le nuuŋ bɛniiŋ tɛ̀ bo li kwe-e kɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Le be bɛ lɛ, be tee le, “Wi wu ntiifɛ, Mɔɔsɛ tɛ̀ tsɛɛ li bee li lɛ bɛnchi-i le, ‘Ɛ ŋwaani wi kwi wu shɛ kwɛɛŋ ŋwaŋ nsiŋ, kɛ wi wulu kɛmi le dzɔɔ kwɛɛ ŋku wulu bee wu biɛ bɔɔŋ li bukooŋ bu ŋku ŋwaani-i.’ ");
INSERT INTO asj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bɛdɛɛni, wi wumu tɛ̀ kɛmi bɔɔŋ bɛ buniŋ mfomɛnyaaŋ, wu kaaŋ tɛ̀ dzɔ kwɛɛŋ, kwi bee wu mbiɛ ŋwaŋ nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wu biki se dzɔ tɛ̀ kwɛɛŋ wulu, kwi tɛ̀ ŋwaŋ nsiŋ. Fi ka nɛɛ tɛ lɛ bɛ wu biki li wuu wɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Be bɛchu dzɔ wu, wi se tɛ̀ mɛɛŋ ki nuuŋ kɛ li bɛniiŋ bɛ mfomɛnyaaŋ bɛlu-u lɛnti wu tɛ̀ biɛ ŋwaŋ bɛ kwɛɛŋ wulu kɛ. Lɛjiŋ lɛlu kwɛɛŋ wulu tɛ̀ kwi tɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Si bɛniiŋ bɛ mfomɛnyaaŋ bani tɛ̀ dzɔ kwɛɛŋ wulu be bɛchu lɛ, gii ni nuuŋ mfi wu bɛniiŋ buti li kwe-e, kwɛɛŋ wulu se nuuŋ kwɛɛ noo?” ");
INSERT INTO asj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jiso tee li bee le, “Nɛ kii baa fiee fi feti nɛ se tɛndi dzé ni? Fi fiɛɛ lɛ kifɛ nɛ kii yɛ fiee fi bɛ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ kɛ, nɛ kii yɛ tɛ mɔɔ buŋga bu Nyɔ-ɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Fiee fi nuuŋ lu fiɛɛ le mfi wu bɛniiŋ buti li kwe-e, buniŋ bee bukɛɛŋ mɛɛŋ yɛ le be ni be feti bugoo kɛ, bɛniiŋ mɛɛŋ yɛ be tuu be ni be nyɛɛ bɔɔŋ li bugoo li kɛ. Be gii naa be ni be nuuŋ nɛɛ si bɛnchindaa bɛ Nyɔ-ɔ liboo. ");
INSERT INTO asj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kii fiee fi mbochu li kwe-e, nɛ mɛɛŋ baa ki teeŋ kɛ kintsii lɛ Kiŋwaati ki Mɔɔsɛ-ɛ kii kiti ki tɛ̀ duti Nyɔ yeti li Mɔɔsɛ yi tiiti le, ‘Ɛ mi Nyɔ yi Abrahaŋ bɛ Nyɔ yi Adzi mɔɔ Nyɔ yi Yakɔ ni?’ ");
INSERT INTO asj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Fi nuuŋ le Nyɔ nuuŋ yɛ Nyɔ yi biŋkwi kɛ, yi nuuŋ nuuŋ Nyɔ yi bɛniiŋ bɛ yoŋ. Nɛ chaŋ baa biee ŋge.” ");
INSERT INTO asj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wi wumu wu tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ bɛ, woo si Jiso bee bɛniiŋ baa tɛchini biee, tuu ŋɛŋ si wu tuu fiee fi be bii li wuu lɛ dze yi dzeeŋ li, bii tɛ li Jiso laa, “Nchi wu yɛki bɛnchi bɛchu nuuŋ wu la?” ");
INSERT INTO asj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jiso tuu li wuu le, “Nchi wu yɛki bɛnchi bɛchu nuuŋ wuni wu tiiti le, ‘Hooo bɛniiŋ bɛ Isɛlɛɛ woo yɛɛŋ, Taa Nyɔ, wu Nyɔ yisɛŋ, Taa Nyɔ wulu nuuŋ nɛɛ mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ɔ kɔŋgisi Taa wu Nyɔ ya bɛ shéŋ ya chi, ɔ nyɛɛ kikoo ko li yi-i kichu, ɔ gɛɛ bufii bwo li yi-i buchu, ɔ nindi li yi-i bɛ buŋga bwo buchu.’ ");
INSERT INTO asj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nchi wu biki li wuni se nuuŋ le, ‘Ɔ kɔŋgisi ŋwaana siɔ kɔŋgisi yi ya.’ Nchi wumu nuuŋ yɛ lu wu yɛki bani kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wi wu tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ wɛ se tee li Jiso-o le, “Wi wu Ntiifɛ, ɔ tuuɔ nɛɛ bujɔŋ. Ɔ tiitɔɔ nuuŋ chɛɛŋ le Nyɔ nuuŋ nɛɛ mumkpaŋ yimi nuuŋ yɛ lu fuki yi nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ŋkɔŋgisɛ yi bɛ shéŋ chi, ŋgɛwu bufii li yi-i buchu, nimu li yi-i bɛ buŋga buchu bɛ ŋkɔŋgisɛ ŋwaana siɔ kɔŋgisi yi ya, tuuɔ wu yaa mɔɔ mfɛru muntofi bɛ nyáŋ yi tɔnyɛ mɔɔ bɛntaanchɛ bamu.” ");
INSERT INTO asj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Le Jiso tuu ŋɛŋ si wu tuu si wi bufii, se tuu tee li wuu le, “Ɔ nuuŋ yɛ mfiiŋ li nlɛ li bumfɔŋ bu Nyɔ-ɔ kɛ.” Lɛjiŋ lɛlu, wi se tɛ̀ mɛɛŋ ki tuu kɛ le mɔŋ mbɛ le bii fiee li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jiso bɛ tiifi bɛniiŋ li yih yi muntofi-i, dza bii li bee laa, “Bɛniiŋ bɛ tiifi bɛnchi geeŋ be se tiiti le Kinsofu ki Nyɔ tɛ̀ kaachɛ nuuŋ ŋwanɛ Mfɔŋ Daafi? ");
INSERT INTO asj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nuuŋ ɛ Fiana yi Waaŋ tɛ̀ saa yi fɛ se Mfɔŋ Daafi wuni kweeŋ kii Kinsofu kilu tiiti le, ‘Taa Nyɔ tɛ̀ tee li Taa li le shee lɛ kibɛnɛ kee ki kigɔŋɛ-ɛ, nsiiŋ fɛ yi giiki bɛniiŋ bee bɛ mbani-i wu tɔmi bikaa biee li bee’. ");
INSERT INTO asj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ɛ Daafi kibɛɛ teenyi wu le Taa we, fi geeŋ se tuu ni nuuŋ ŋwani?” Si Jiso tɛ̀ tiiti biee bini lɛ, kintutu ki bɛniiŋ lɛ ŋge ki tɛ̀ nuuŋ fe tɛ̀ wuki kinɛɛtinɛ wuu be. ");
INSERT INTO asj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Le tuu ni tiifi bɛniiŋ dza tee li bee le, “Dzɔɔ yɛɛŋ mfi, bɛ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ. Be ti kɔŋgisi nchuminɛ ndú yi nyɔŋa yi nyɔŋa be deŋgi li bintsii bi bɛ kabini biee li le bɛniiŋ ni be yɛɛshi be bɛ kin'yokisɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Fɛ be gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ, kɛ fɛ tsɔnɔ-ɔ, be tsaa nɛɛ nuuŋ bintindu bi nɔŋa bi nɔŋa, be se shee li bi-i liwe. ");
INSERT INTO asj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɛ nɛɛ be bɛ tusi bukɛɛŋ bɛɛŋku-u lijiŋ, be yɛŋgi be fii biee bi bee, be tuu be feti nlɛkɛ li Nyɔ-ɔ wu deendi le be ni be doonchi yi. Ŋwaani bani bɛniiŋ, wu be wu ŋgɛ gii naa bee ŋge.” ");
INSERT INTO asj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jiso dza gɛɛŋ lɛ shee limfwe li fiŋko fi nya-a fi li yih yi muntofi-i, se bichi si bɛniiŋ bɛɛ be giki kwa lɛ fiŋko filu-u. Bɛniiŋ bɛ kwaa se tɛ̀ bɛɛ ŋge be giki kwa le ŋgɔɔkwe-e wu. ");
INSERT INTO asj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kwɛɛŋku wumu se dza bɛ, nuuŋ wi wu kifoo, gɛɛ munini le mumfɛɛŋ mu feti lisi chi kwa-a chi mumkpaŋ, wu mɛɛŋ ki bo kɛ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jiso se teeŋ bɔɔŋ bee bɛ kintutu-u tee li bee le, “Ntee li be-eŋ chɛɛŋ le kwɛɛ ŋku wuni wu nuuŋ wi wu kifoo, nyɛɔ wu yaa bɛniiŋ bɛchu bɛ gɛɛ fiee lɛ fiŋko fi li yih yi muntofi fini. ");
INSERT INTO asj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bɛniiŋ bɛchu bɛ be be nyɛɛ, be be bɛɛ nuuŋ bɛ tsuu yi kwa wu be wu yisɛ wu shooshi. Se nuuŋ le, bee bɛ bɛ kifoo kee kichu wu nyɛ fiee fichu fi be kɛmi, nuuŋ fi fi bee nuuŋ le ni tsiiŋ li fi-i.” ");
INSERT INTO asj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Le Jiso ni dzɛti fɛ yih yi muntofi-i, ŋwani wu kintutu wumu tee li wuu le, “Wi wu Ntiifɛ bichɛ ɔ ŋɛŋ ta yi nyɔŋa yi nuuŋ li yih yini-i. Yih yini gbɛŋgi yɛ yi nuuŋ yih yi shaaŋ!” ");
INSERT INTO asj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jiso tuu li wuu le, “Ɔ ŋiŋgɔɔ yih yi shaaŋ yini ni? Nuuŋ tɛtɛ chimumkpaŋ tɛ̀ shɛ li chimu-u fuki fɛ bɛ bachɛ chi fɛkwiiŋ nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jiso dza gɛɛŋ beeŋ shee li Ŋkumɛ wu Biti bi Oli-if lɛ kimbɛ ki bichi yih yi muntofi, Pita bee Jeeŋ mɔɔ Jɔɔŋ mɔɔ Andolo gɛɛŋ bebe be tee li wuu le, ");
INSERT INTO asj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tee bee mfi wu biee bini gii naa bi ka, ɔ tuu ɔ tee tɛ̀ bee bɛndoonchɛ bɛ gii naa be doonchɛ mfi wu biee bini bichu tɛ̀ nuuŋ le bi ka.” ");
INSERT INTO asj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jiso se tee li bee le, “Ŋɛŋgɛ yɛɛŋ le kiiŋ wi ni tuu yɛɛŋ bɛ beŋ nɛ taŋ dze kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bɛniiŋ ŋge gii be ni bɛɛ be dzeti bukooŋ bweŋ be tɛkisi fɛlii, wi ni kweŋgi le, ‘Ɛ mi wulu.’ Be gii be ni be feti lɛ be yɛŋgi bɛ bɛniiŋ ŋge be se tɛndi dzé. ");
INSERT INTO asj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ɛ nɛ naa nɛ woo le bɛ tundi baa dziŋ kɛ le dziŋ gii yi nuuŋ lu, kiiŋ shéŋ ni yi kɛɛti beŋ kɛ. Bini biɛɛ biee bi kɛmi le bi ka. Se nuuŋ le, bi doonchi yɛ le nshɛ mɛɛ yɛ kituŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwɛɛŋ gii wu ni wu tundi dziŋ bɛ wumu, mfɔŋ wumu tundi dziŋ bɛ wumu. Nshɛ gii yi ni yi nduŋgi li bintsii li bintsii li, dzeeŋ ni yi keeti. Bini biee mɛɛŋ biɛɛ fintɛŋ si ntunu wu kwɛɛŋ ti bɛɛchi. ");
INSERT INTO asj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Fɛ nɛ nuuŋ fe, nɛ dzeti yɛɛŋ mfi. Nɛ kɛɛ le bɛ gii bɛ nyɛ beŋ li tsaŋ yi bɛniiŋ bɛ sɛki bɛnsa-a. Bɛ gii bɛ fiaamfiɛ beŋ li yíh yi kintaashɛ, nɛ gii nɛ leŋ li ŋgɔmina-a limfwe, mɔɔ li bɛmfɔ-ɔŋ limfwe kii mi, kii le nɛ tiiti baa li bee kii mi. ");
INSERT INTO asj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Se nuuŋ le bɛ kɛmi le bɛ saa bɛ tee kii ntoŋ wu dzeeŋ wu Nyɔ li tɛɛŋ chichi-i. ");
INSERT INTO asj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mfi wu bɛ kɔɔ beŋ bɛ giiŋgi bɛ beŋ li yih yi nsa-a, kiiŋ nɛ ni nɛ buki yi laa nɛ giiŋgi baa nɛ tee le la le kɛ. Mfi wu nɛ gɛɛŋ, nɛ tiiti nɛɛ nuuŋ fiee fi buti li bimfimu binɛ-ɛ li mfi wulu-u, kifɛ mɛɛŋ yɛ n'yɔru wunɛ kɛ. Ɛ Fiana yi Waaŋ yi gii yi ni yi nyɛɛ n'yɔru li bimfimu binɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wi gii dza dzɔɔ ŋwaani nyɛ le bɛ wo, te ŋwaŋ dzɔɔ ŋwani nyɛ le bɛ wo. Bɔɔŋ gii be dza tɛ be ni be biindi bikaa lɛ bɛtee bɛbee mɔɔ lɛ bɛni bɛbee lɛjiŋ, be ni be feti le bɛ woyɛ be. ");
INSERT INTO asj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bɛniiŋ bɛchu gii be ni be baanini beŋ kii bukooŋ bweŋ. Se nuuŋ le, wi wu gii kaŋ shéŋ nsiiŋ gɛɛŋ bo fɛ kimɛrisɛ-ɛ gii naa bɔnɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Wi wu teenyi kiŋwaati kini woo fini bujɔŋ,) mfi wu nɛ ŋɛŋ fiee fi bɛndi yi fi nuuŋ fi biifi kintsii fi lemi fɛ fi bee fi kɛmi yɛ le fi ni fi lemi kɛ, bɛniiŋ bɛ nuuŋ Judiya kifi be miri li bɛŋkumɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kiiŋ wi wu nuuŋ lɛ yi-ih lɛwe tuu shee le lɛ li yih dzɔɔ mɔɔ nuuŋ fiee le ni giiŋgi bɛ fi kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kiiŋ wi wu nuuŋ liwɛ tuu kaari le bɛ dzɔɔ ndu ye yi foochɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋgɛ wu nyɔŋa wɛ li jo yɛɛ li bukɛɛŋ bɛ nuuŋ bɛ fe-e, mɔɔ bɛ kisi bɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nɛ lɛki yɛɛŋ li Nyɔ-ɔ le kiiŋ fiee fini naa fi ka nuuŋ mfi wu fokpɔŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bɛniiŋ gii be ŋɛŋ ŋgɛ li jo yilu-u, se ŋwaani wɛɛ ŋgɛ ti mɛɛŋɔ mɔɔ saa ki nuuŋ kɛ lu fɛ mbɛɛchɛ si Nyɔ tɛ̀ tɔŋ nshɛ mbɛ mbochu dɛɛni kɛ. Ŋwaani wɛɛ ŋgɛ mɛɛŋ yɛ le naa tuu nuuŋ mɔɔ lu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bee le Taa ni mɛɛŋ ki gatɛ kɛ fɛ jo yi ŋgɛ yilu kɛ, wiwoŋ mumkpaŋ wu bochɛ-ɛ lu kɛ. Se nuuŋ le, kii bɛniiŋ bee bɛ tɛ̀ tsaa kituŋ wu gɛɛ, wu gatɔɔ fɛ jo yilu-u. ");
INSERT INTO asj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ɛ wi tee li be-eŋ li jo yilu-u le, ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛɛ fɛni!’ Mɔɔ nuuŋ le, ‘Ŋɛŋ yɛɛŋ wuu wu fɛ fiiyɛ!’ Kiiŋ nɛ ni beŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nɛ kɛɛ le bɛniiŋ gii naa be ni be bɛɛ be yɛŋgi le ɛ be binsofu bi Nyɔ tɛ̀ kaachɛ, bamu se ni be kweŋgi le ɛ be bɛ nuuŋ bɛntomfɔŋ bɛ Nyɔ-ɔ, be feti biee bi doonchi buŋga bubee, be feti tɛ bintɛ wa bi biee lɛ, be mɔnchi le ɛ dze nuuŋ lu, be yɛɛŋ bɛ bɛniiŋ bɛ Nyɔ tɛ̀ tsaa be se taŋ dze. ");
INSERT INTO asj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nɛ kɛɛ le. Mi nteeɔ biee bini bichu li be-eŋ bi mɛɛŋ se bi naa bi dzɔɔ kintsii. ");
INSERT INTO asj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Naa nuuŋ li jo yilu-u, mfi wu ŋgɛ wulu ka, jobɛ dza chi jiŋ, kwii tɛ tuu le wu nɛɛŋ kɛ, ");
INSERT INTO asj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","muntsɔŋ ni mu dzɛti liboo mu weyi, biee bi liboo bichu bi kɛmi buŋga sɛɛsɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bɛdɛɛni, bɛniiŋ se ŋɛŋ si Ŋwanɛwi shiiti bɛɛ li kikuŋ kɛmi buŋga ŋge mɔɔ bunɔŋa. ");
INSERT INTO asj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gii se tuumi bɛnchindaa bee be gɛɛŋ li boo yi naa li, fɛ kiboo bee nshɛ luushi, banchɛ bɛniiŋ bee bɛ tɛ̀ tsaa. ");
INSERT INTO asj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Laanchɛ yɛɛŋ fiee li kigumɛ-ɛ. Ki bɛɛ fɛ ki sanyɛ yɛŋɛ, bibɛ bɛchi mbɔchɛ li ki-i, nɛ kɛɛ le ndzɛɛŋ yɛ tsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nɛɛ lɛ ɛ nɛ ŋɛŋ biee bini kɛti, nɛ kɛɛ le mfi wulu wɛ tsɛkɛtsɛkɛ fweeŋ. ");
INSERT INTO asj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ntee beŋ chɛɛŋ le kiŋgɔkɛ ki dɛɛni kini nuuŋ ki tɛ̀ naa ma fuki fɛ biee bini bichu ka nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kiboo bee nshɛ gii bi ka, se nuuŋ le, jɛ yɛŋ nuuŋ tɛ̀ naa ka kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Bɛdɛɛni, wi se nuuŋ yɛ lu wu kii jobɛ chilu mɔɔ nuuŋ mfi wulu kɛ. Mɔɔ nuuŋ bɛnchindaa bɛ Nyɔ-ɔ bɛ liboo kɛ Ŋwanɛ Nyɔ kii yɛ nɛɛ tɛ kɛ. Ɛ nɛɛ Tee wuu mbiiŋ wu kii. ");
INSERT INTO asj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bɛdɛɛni, nɛ bichi nɛ tɛŋgi, kifɛ nɛ kii yɛ mɔɔ mfi wulu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Fi fiɛɛ si wi ti bɛɛ ɛ lɛti ndɛndɛ, fɛ dzɛti lɔɔ, gɛɛ yih ye li tsaŋ yi bɔɔŋ bee bɛ nimɛ, wi bɛ chee chi nimɛ, wi bɛ chee chi nimɛ, tee li wi wu kiichi fweeŋ wu mbaŋ le shɛ ɔ ni ɔ kiichi bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bɛdɛɛni, nɛ tɛŋgi tɛ, kifɛ nɛ kii yɛ mfi wu te yih gii naa kaari bɛ kɛ. Nuuŋ tuu bɛ lɛ fɛmfo-o, kɛ butuu kintikinti, kɛ mfi wu nyinɛshee yi ŋkosi tɔɔŋ, kɛ fɛ ŋwɛɛŋ taantaaŋ. ");
INSERT INTO asj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kiiŋ ni dza taa mbundɛ ŋɛŋ nɛ liiti kɛ. ");
INSERT INTO asj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Fiee fi mi n'yɔ li be-eŋ fini, mi n'yɔɔ li bɛniiŋ bɛchu le, ‘Wi ni tɛŋgi.’” ");
INSERT INTO asj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tɛ̀ shɛ jo faa le ni nuuŋ jobɛ chi Tsɔnɔ chi N'yafuwee bɛ Tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ kishee le kɛ-ɛ. Bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ tɛ̀ wɛki dze yi be nuuŋ be kɔɔ Jiso le lɛ munyiikɔɔ li, be wo. ");
INSERT INTO asj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Be lɛ ntsooŋ li yi yi bee le, “Kiiŋ tɛ ni mɔŋ fiee fini li mfi wu bɛ feti Tsɔnɔ-ɔ kɛ, kifɛ ɛ tɛ mɔŋ, fi bɛ bɛ ŋkweŋɛ lɛ bɛniiŋ li lɛnti.” ");
INSERT INTO asj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jiso tɛ̀ nuuŋ li kitoŋ ki Bɛtani-i, li yih yi Simu wu wi wu chigɔŋ chi nɔŋa-a, ɛ be tɛ̀ shee be jii biee, kwɛɛŋ wumu dza lɛ bɛ fikoo fi mɛɛŋ mamu mɛ sɛɛndi ni shuuŋŋ. Mɛɛŋ mani tɛ̀ tɛɛmi kwa ŋge, bɛ tɛ̀ nachɛ me bɛ naad wuwu. Le lɛ lɛ, bootɛ kimfimɛ ki fikoo filu tumi mɛɛŋ malu li kikoo ki Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bɛniiŋ bamu dza be ŋuŋini be be, be tiiti le, “Bifisi mɛɛŋ mani ni kii la? ");
INSERT INTO asj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bee nuuŋ bɛ kabɛ mɛɛŋ malu, me yaa kwa bɛnchuki gii tɛɛ, bɛ nyɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ.” Be ŋasɛ bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Se nuuŋ le, Jiso tɛ̀ tee li bee le, “Gɛɛ yɛɛŋ wu nshiiŋ. Nɛ nyɛɛ wu ŋgɛ kii la? Wu fɛɔ nuuŋ fiee fi dzeeŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nɛ kɛɛ le bɛniiŋ bɛ kifoo lɛ gii be ni be nuuŋ bɛ beŋ mfi kwi. Nuuŋ nɛ ni nɛ fii be mfi wu nɛ kɔŋgisi. Se nuuŋ le, nnuuŋ ntɛ nuuŋ bɛ beŋ mfi kwi kɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kwɛɛŋ wuni fɛɔ nuuŋ fiee fi bee kɛmi le fɛ. Wu fwaɔ mi bɛ mɛɛŋ mani ni, le nachɛ nuuŋ yi yɛŋ mɛɛŋ si bɛ gii bɛ diyɛ mi. ");
INSERT INTO asj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ntee beŋ chɛɛŋ le, mɔɔ nuuŋ fɛŋ fɛ bɛ gii bɛ ni bɛ fenjisi ntoŋ wu dzeeŋ wuni li kikoo ki nshɛ kichu, fiee fi kwɛɛŋ wuni fɛ bɛ gii bɛ ni bɛ tiiti tɛ kii fi, bɛ kiimi wu.” ");
INSERT INTO asj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskaliyɔ wu tɛ̀ nuuŋ wi kintutu ki bɔɔŋ bɛ kintutu-u bɛ Jiso bɛ yoofi ntsɔ bɛfɛ wɛ tɛ̀ dza gɛɛŋ fɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa le kabɛ Jiso li bee. ");
INSERT INTO asj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Le be woo lɛ, be nɛɛtɛ ŋge, be kaachɛ wu le be gii be nyɛ wu kwa. Se bɛchi wɛki dze yi gii nyɛ Jiso li tsaŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jobɛ chi ŋkosi chi Tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ kishee le kɛ chi be tɛ̀ shiiŋ be sɛɛti ŋwaŋ wu kiŋkɔ li Tsɔnɔ chi N'yafuwee tɛ̀ bɛ chi kɔchɛ, bɔɔŋ bɛ Jiso-o bɛ kintutu-u bii li wuu laa, “Ɔ wɛki le tɛ gɛɛŋ tɛ nachɛ nuuŋ fɛŋ le ke ɔ ji Tsɔnɔ chi N'yafuwee fe?” ");
INSERT INTO asj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Se toŋ bɔɔŋ bee bɛ kintutu bamu bɛfɛ, tee li bee le, “Gɛnɛ yɛɛŋ li kito-oŋ, mfi wu nɛ giiŋgi lɔɔ, nɛ gii nɛ ŋɛŋ wi wumu ɛ wu too dzɔɔ lɛ tɛnɛ-ɛ, nɛ biee wu. ");
INSERT INTO asj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mfi wu wu gɛɛŋ wu lɛ li yih yi wu lɛ lu-u, nɛ tee li wi wu kɛmi yih yilu-u le Wi wu Ntiifɛ biitɔɔ laa loŋ we wu bɛniiŋ bɛ ndɛndɛ-ɛ wu bee bɔɔŋ bee bɛ kintutu-u gii be ji Tsɔnɔ chi N'yafuwee lu nuuŋ fɛŋ le? ");
INSERT INTO asj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Gii se doonchɛ loŋ wu nyɔŋa wu lɛwe li yih yi biji-i wu bɛ bɔsɛyi bɛ nachɛ kituŋ wu nuuŋ, nɛ se nachɛ biee bijɛ lu.” ");
INSERT INTO asj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bɔɔŋ bɛ kintutu bɛlu se dza be gɛɛŋ li kitoŋ kilu-u, be gɛɛŋ be ŋɛŋ biee nɛɛ yɛɛŋ si Jiso bee tee li bee. Be se nachɛ biee bijɛ bi Tsɔnɔ chi N'yafuwee chilu-u lu. ");
INSERT INTO asj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Le ni nuuŋ lɛ fɛmfo-o, Jiso bee bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ bɛfɛ baa taashɛ lu. ");
INSERT INTO asj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Be shee be jii biee, Jiso dza tee li bee le, “Ntee beŋ chɛɛŋ le wi wumu li beŋ linti gii kabɛ mi, wi wuni jiiɔ biee tɛɛ wu.” ");
INSERT INTO asj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Le be woo lɛ, be dza be to nshiiŋ nshiiŋ, be se tiiti li wuu wi mumkpaŋ mumkpaŋ le, “Ŋkiiɔ le ɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Se tuu le, “Ɛ nɛɛ wi wumu li beŋ bɛ yoofi ntsɔ bɛfɛ bani-i wu fuundi kibele lɛ sho-o tɛɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ŋwanɛwi gii gɛɛŋ nɛɛ si bɛ tɛ̀ tsɛɛ kii wu. Se nuuŋ le, ŋgɛ wu nyɔŋa wɛ li wi wu kabɛ Ŋwanɛwi. Fi tɛ̀ dzɔɔŋ ŋge le gii bɛ ba wu ki biɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Si be tɛ̀ jii biee lɛ, Jiso dza dzɔ kibele, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ, nyɛ li bɔɔŋ bee bɛ kintutu-u tee le, “Kɔ yɛɛŋ, yiiŋ yi yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tuu dzɔ tɛ fika, nyɛ kiyɔɔni li Nyɔ-ɔ, se nyɛ fika filu li bee, be woŋ be bɛchu. ");
INSERT INTO asj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tee li bee le, “Mani nuuŋ ŋgɔŋ meŋ mɛ Nyɔ ji leh lu me bo kii bɛniiŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ntee beŋ chɛɛŋ le mɛɛŋ yɛ naa ntuu ŋ'woŋ mbiiŋ mɛ gwɛɛŋ wu kiti ki lɛɛndi mani-i kɛ nsiiŋ gɛɛŋ bo jobɛ chi ŋgii naa ŋ'woŋ mɛfɛŋ bɛ beŋ lɛnti lɛ bumfɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Le Jiso bee bɔɔŋ bee bɛ kintutu-u mɛɛshi, be yoo jumi chi n'yɔɔnchɛ-ɛ, be dza be michi be giiŋgi li Ŋkumɛ wu Biti bi Oli-if. ");
INSERT INTO asj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jiso tɛ̀ dza tee li bee le, “Beŋ bɛchu gii nɛ tuu bikaa lijiŋ. Fi nuuŋ si bɛ tɛ̀ tsɛɛ Nyɔ tiiti le, ‘Ŋgii ŋ'wo wi wu kiichi nshɔ́ɔŋ, nshɔ́ɔŋ se saaŋgɛ.’ ");
INSERT INTO asj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Se nuuŋ le, mfi wu Nyɔ buu mi li kwe-e, ntoo mbaŋ li be-eŋ Galilii.” ");
INSERT INTO asj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita tuu li Jiso le, “Mɔɔ nuuŋ le bɛniiŋ bɛchu gii be chee bikaa lɛ wɛɛ jiŋ, be to lijiŋ, nuuŋ ntɛ nchee kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jiso tee li wuu le, “Ntee wɛ chɛɛŋ le butuu bu bɛŋ buni, fi fiɛɛ le fɛ nyinɛshee gii yi ni yi nuuŋ le yi tɔɔŋ kiŋga kifɛ, nuuŋ ɔɔ faaŋ mi kiŋga kitɛɛtɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita yɔ bɛ buŋga tee le, “Mɔɔ nuuŋ le ŋkwi tɛɛ wɛ, nuuŋ ntɛ naa mfaaŋ wɛ kɛ.” Le tee lɛ, be bɛchu tee nɛɛ tɛ si wu tee lɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Be gɛɛŋ be lɛ li wɛ wu mbaŋ wumu-u, bɛ teenyi le Gɛsɛmani, Jiso tee li bɔɔŋ bee bɛ kintutu le, “Shee yɛɛŋ fɛni, ŋgɛɛŋ nlɛkɛ li Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dzɔ Pita bɛ Jeeŋ mɔɔ Jɔɔŋ, bee be dza fe. Se dza tuu seki biee wuki ntɔnyɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tee li bee le, “Shéŋ yɛŋ yɛɛ nshiiŋ nshiiŋ ŋge yi nuuŋ ŋkwi. Shɛ yɛɛŋ nɛ ni nɛ tɛŋgi fɛni.” ");
INSERT INTO asj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jiso dza fe kiiŋgi gɛɛŋ limfwe niiŋ, we fɛkwiiŋ, lɛkɛ li Nyɔ-ɔ le ɛ dze bee yi nuuŋ lu, mfi wu ŋgɛ wulu ka nɛɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Lɛkɛ li Nyɔ-ɔ le, “Abba, Baa wɛŋ, ɔ nuuŋ ɔ fɛ nɛɛ fiee fichu. Tsaaki fika fi ŋgɛ fini kii ni ŋ'woŋ. Se nuuŋ le, fɛrɛ nɛɛ si ɔ kɔŋgisi. Kiiŋ ɔ ni fɛ si ŋkɔŋgisi kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jiso kaari to lijiŋ lɛ bee, ŋɛŋ be liiti. Bii li Pita laa, “Simu, ɔ liiti lɔɔ ni? Ɔ nuuŋ tɛ taaŋ le gɛɛŋ bo ntaŋ wu mfi mumkpaŋ ni? ");
INSERT INTO asj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nɛ nuuŋ yɛɛŋ we nɛ lɛki li Nyɔ-ɔ kii mɔnchɛ ni bɛ lɛ be-eŋ. Fi fiɛɛ chɛɛŋ le shéŋ kɔŋgisi yɛɛ, se nuuŋ le nyaŋ yi bwiŋ nuuŋ fɛɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Si wu tee lɛ kaari gɛɛŋ lɛkɛ li Nyɔ-ɔ nɛɛ si bee saa lɛki li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Le tuu ni karisi tuu lijiŋ, ŋɛŋ bɔɔŋ bee bɛ kintutu-u be liiti kifɛ chilefɛ tɛ̀ nuuŋ be lɛ lii ŋge. Be mɛɛŋ ki kɛɛ kɛ fiee fi be nuuŋ be tuu li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kaari to lijiŋ kiŋga kitɛɛtɛ, bii li bee laa, “Nɛ mɛɛŋ nɛ liiti nɛ fufini finɛ ni? Chi kɔchɛ chɛɛ. Mfi wulu bɛɛɔ. Bɛ kabɛ baa Ŋwanɛwi li bɛniiŋ bɛ bifi-i. ");
INSERT INTO asj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dza yɛɛŋ we tɛɛbeŋ tɛ ni tɛ giiŋgi. Bichɛ yɛɛŋ nɛ ŋɛŋ, wi wu kabɛ mi bɛɛɔ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nɛɛ si Jiso tɛ̀ mɛɛŋ yeti lɛ, mfwaa mumkpaŋ Judas wu tɛ̀ nuuŋ wi kintutu ki bɔɔŋ bɛ Jiso bɛ yoofi ntsɔ bɛfɛ baa biee busɛ. Tɛ̀ gii bɛɛ bɛ kintutu ki bɛniiŋ lɛ be kɛmi nyɔ́ bɛ bimboki, ɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tiifi bɛnchi mɔɔ bɛniiŋ bɛ sɛki kwɛɛŋ tɛ̀ toŋ be. ");
INSERT INTO asj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tɛ̀ nuuŋ ɛ wi wu tɛ̀ kabɛ Jiso wulu tɛ̀ nachɛ bɛ bɛniiŋ bɛlu tee le, “Wi wu ŋgii n'yɛsi, ŋkokɛ nyɔɔchɛ, ɛ wu, nɛ biee nɛ kɔɔ wu, nɛ dzɔ wu, nɛ giiŋgi bɛ wu nɛ bichi kii ni letɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Si Judas bɛ lɛ, gɛɛŋ mfwaa mumkpaŋ fɛ Jiso, yɛsi wu le, “Wi wu Ntiifɛ.” Si wu yɛsi wu lɛ, kokɛ wu nyɔɔchɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bɛniiŋ baa lɔŋ tsaŋ li Jiso, be cha wu. ");
INSERT INTO asj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wi wumu tɛ̀ gii lemi bee bɛ Jiso tsɔɔ nyɔ ye yi dziŋ, kɛri kintooŋ ki mfwa wu kikoo ki bɛte muntofi lu, sondɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jiso bii li bɛniiŋ bɛlu laa, “Nɛ bɛ le nɛ kɔɔ mi nɛ bɛɛ bɛ nyɔ́ mɔɔ bimboki kɛɛ nɛ bɛ le nɛ kɔɔ nuuŋ wi ni? ");
INSERT INTO asj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ntuu nshiiŋ nuuŋ tɛɛbeŋ li jo-o li jo-o mɔɔ li yíh yi muntofi, ntiifi bɛniiŋ, nɛ mɛɛŋ ki kɔɔ kɛ mi kɛ. Se nuuŋ le, fini kɛti fiɛɛ dɛɛni ni le fiee fi bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ bɛ fi kɔchɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bɔɔŋ bɛ Jiso bɛ kintutu bɛchu se lɔŋ wu fe, be kifi. ");
INSERT INTO asj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sɔɔnɛ wi wumu tɛ̀ biki wu, ti mɛɛŋ ki lii kɛ fiee ndu li wuu bwiŋ kɛ, tɛ̀ nuuŋ nɛɛ bɛ ŋkweŋkwe wu ndu kwaa libwiŋ. Be gɛɛŋ le be kɔɔ tɛ̀ wu, ");
INSERT INTO asj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ndu yilu fanchɛ, chinɛ letɛ tiŋ kilɛrɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Be dzɔ Jiso, be gɛɛŋ bɛ wu fɛ kikoo ki bɛte muntofi-i. Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ mɔɔ bɛniiŋ bɛ tiifi bɛnchi baanchɛ fe. ");
INSERT INTO asj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Be tɛ̀ giiŋgi bɛ Jiso Pita biki lɛjiŋ mfiiŋ. Gɛɛŋ bo la kintikinti wu kikoo ki bɛte muntofi-i, se shee bee bɛniiŋ bɛ tɛ̀ kiichi la wulu wɔɔnsi wi. ");
INSERT INTO asj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛchu bɛ sɛki bɛnsa tɛ wɛki fiee fi be nuuŋ be kayɛ li Jiso-o, fi fɛ se be wo wu. Se nuuŋ le, be ti mɛɛŋ ki ŋɛŋ kɛ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bɛniiŋ ŋge tɛ̀ lemi lɛjiŋ lɛ nsa wu binsɛɛ li kii Jiso. Se nuuŋ le, wi tɛ̀ tiiti yɛ fiee fi kɔchini bɛ fi wumu kɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bɛniiŋ bamu tɛ̀ dza be leŋ we, be kayɛ bi bee binsɛɛ li wuu, be tee le, ");
INSERT INTO asj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tɛ̀ tuu tɛ̀ woo tiiti le gii shaanshɛ yih yi muntofi yini yi wiwoŋ gwaŋ bɛ tsaŋ, dzɔɔ jo taa kaari gwaŋ yimi yi nuuŋ yɛ ŋgwanu wu wiwoŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mɔɔ si be tɛ̀ tiiti lɛ, tefɛ chi bee tɛ̀ bɛɛ yɛ chi kɔchini kɛ. ");
INSERT INTO asj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kikoo ki bɛte muntofi-i se dza ki leŋ we bɛniiŋ limfwe, ki bii li Jiso-o laa, “Ɔ kɛmi yɛ fiee fi ɔ nuuŋ ɔ tuu kɛ ni? Ɔ wuki nɛɛ biee bi bɛniiŋ bani tiiti kii wɛ ni?” ");
INSERT INTO asj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jiso ba shiiŋ, mɛɛŋ ki tuu kɛ fiee kɛ. Kikoo ki bɛte muntofi kɛɛ tuu ki bii li Jiso-o laa, “Ɔ nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ ki Ŋwanɛ Nyɔ, Nyɔ yi bɛ yɔɔnchi ni?” ");
INSERT INTO asj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jiso tuu le, “Ɛ mi. Nɛ gii naa nɛ ŋɛŋ si Ŋwanɛwi shee lɛ kibɛnɛ ki kigɔŋɛ ki Nyɔ-ɔ yi kɛmi Buŋga-a, nɛ tuu nɛ ŋɛŋ si shiiti bɛɛ liboo li kiku-uŋ.” ");
INSERT INTO asj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kikoo ki bɛte muntofi kɛɛ woo lɛ, ki gaamɛ ndú yi ki, ki bii laa, “Fiee mɛɛŋ lu fi tɛɛbeŋ tuu geendi wi le leŋ fɛni ni tiiti ni? ");
INSERT INTO asj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nɛ mɛɛŋ ki woo kɛ si dzeti kintsii ki Nyɔ-ɔ ni? Nɛ tee le la?” Bɛniiŋ bɛchu sondɛ le wɛ wi wu bɛ nuuŋ bɛ wo buwo. ");
INSERT INTO asj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bɛniiŋ bamu bɛchi be kwiyi Jiso bɛ budii, be kaŋ lii yee, be juti wu bɛ muŋkɔ, be tiiti le, “Doonchɛ kintomfɔŋ ki Nyɔ-ɔ kɛɛ dɛɛni.” Bɛniiŋ bɛ nchi dza be dzɔ Jiso be bɛchi be tuki wu. ");
INSERT INTO asj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Si Pita tɛ̀ nuuŋ dze lɛ kwiiŋ la kintikinti lɛ, ŋwaakwɛɛŋ wumu li bɔɔŋ bɛ bukɛɛŋ bɛ tɛ̀ nindi li kikoo ki bɛte muntofi-i dza bɛ li wuu lichiŋ. ");
INSERT INTO asj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Si wu ŋɛŋ Pita wɔɔnsi wi lɛ, bichɛ wu ni fwiiŋ, tee le, “Ɔ bee tɛ nɛɛ Jiso Wi wu Nasarɛ wɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita faaŋ, tee le, “Ŋkii yɛ fiee fi ɔ tiiti fini kɛ. Ŋkii yɛ kɛ.” Si wu tee lɛ, dza fe gɛɛŋ fɛ fweeŋ wu mbaŋ, nyinɛshee tɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Le ŋwaakwɛɛŋ wɛ ka ŋɛŋ wu, tee li bɛniiŋ bɛ tɛ̀ lemi fe-e le, “Wi wuni ɛ wi wumu li bee linti.” ");
INSERT INTO asj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita ka faaŋ. Le mfi kiiŋgi niiŋ, bɛniiŋ bɛ tɛ̀ lemi fe baa tuu be tee li Pita-a le, “Ɛ chɛɛŋ le ɔ nuuŋ wi wu be, kifɛ ɛ wɛ wi wu Galilii.” ");
INSERT INTO asj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita chini, teeŋ kinlɔɔ li yi yee li, tee le, “Ŋkii yɛ wi wu nɛ tiiti kii wu wuni kɛ.” ");
INSERT INTO asj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mfwaa mumkpaŋ nyinɛshee tuu yi tɔɔŋ li kiŋga kifɛ. Pita se kimi tefɛ chi Jiso bee tee li wuu le, “Nyinɛshee gii ni yi nuuŋ le yi tɔɔŋ kiŋga kifɛ, nuuŋ ɔɔ faaŋ mi kiŋga kitɛɛtɛ.” Waŋ kwe. ");
INSERT INTO asj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Le lɛkuuŋ ni le nuuŋ kɛɛ le wuuti laa ni, bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ, mɔɔ bɛniiŋ bɛchu bɛ sɛki bɛnsa, bɛ be shee be dzɔ ntaŋ, be kaŋ Jiso, be dzɔ wu be gɛɛŋ bɛ wu be nyɛ li tsaŋ yi Pailɛ-ɛt. ");
INSERT INTO asj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailɛt bii li Jiso laa, “Ɛ wɛ Mfɔŋ wu Bɛjuu ni?” Jiso tuu li wuu le, “Fi fiɛɛ si ɔ tee.” ");
INSERT INTO asj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa se bɛchi be kayi biee li Jiso-o ŋge. ");
INSERT INTO asj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nɛɛ lɛ, Pailɛt tuu bii li Jiso laa, “Ɔ kɛmi yɛ fiee fi ɔ nuuŋ ɔ tuu kɛ ni? Ɔ wukɔɔ nɛɛ biee bi bɛ kayi li wɛ-ɛ bini ni?” ");
INSERT INTO asj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Se nuuŋ le, Jiso ti mɛɛŋ ki tuu kɛ le tuu fiee li wuu kɛ. Fiee filu yaa Pailɛt. ");
INSERT INTO asj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bɛdɛɛni tɛ̀ nuuŋ li mfi wu Tsɔnɔ chi N'yafuwee chini, Pailɛt buu wi wu ncha mumkpaŋ li yih yi ncha-a wu bɛniiŋ lɛkɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tɛ̀ nuuŋ li mfi wulu-u, wi wumu nuuŋ li yih yi ncha-a bukooŋ le Baraba, nuuŋ li kintutu ki bɛniiŋ bɛ tɛ̀ nuuŋ li yih yi ncha-a bɛ tɛ̀ bɛchi kpɛ fɛ kintsii li be woyɛ bɛniiŋ baa. ");
INSERT INTO asj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kintutu ki bɛniiŋ lɛ se bɛchi ki tiiti le Pailɛt fɛ si ti shiiŋ feti li bee. ");
INSERT INTO asj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailɛt bii li bee laa, “Nɛ wɛki le mbuu nuuŋ Mfɔŋ wu Bɛjuu ni?” ");
INSERT INTO asj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tɛ̀ gii biiti lɛ kifɛ tɛ̀ kii le bɛte muntofi bɛ nɔŋa bɛ nɔŋa tɛ̀ nyɛ Jiso li tsaŋ yee li kifɛ bimi tɛ̀ fuumi be bɛ wu. ");
INSERT INTO asj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Se nuuŋ le, bɛte muntofi bɛ nɔŋa bɛ nɔŋa tɛ̀ kunsɛ kintutu ki bɛniiŋ lɛ le be tee le buu nuuŋ Baraba. ");
INSERT INTO asj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailɛt tuu bii li bee laa, “Ɛ mi mbuu lɛ, ŋgeeŋ bɛ wi wuni wu nɛ teenyi le Mfɔŋ wu Bɛjuu wuni?” ");
INSERT INTO asj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Be tuu be waŋ lɛwe le, “Bɛ ta wu li kintaaŋ li bu taru.” ");
INSERT INTO asj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailɛt bii li bee laa, “Bɛ ta wu kii la? Fiee fi bifi fi wu fɛ nuuŋ la?” Be tuu be wɛndi be giiŋgi nɛɛ bulimfwee le, “Bɛ taaŋ wu li kintaaŋ li.” ");
INSERT INTO asj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nɛɛ lɛ, Pailɛt se buu nuuŋ Baraba kifɛ tɛ̀ wɛki le fɛ si kintutu kɛɛ tɛ̀ kɔŋgisi. Tee bɛ fiaaŋ Jiso, se nyɛ le be gɛɛŋ be taaŋ wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bɛniiŋ bɛ nchi bɛ Pailɛ-ɛt se dzɔ Jiso be lɛ be gɛɛŋ bɛ wu lɛ ntɔ wu bɛ tɛ̀ teenyi le Pletoolom. Si be tɛ̀ lɛ lɛ, be se koŋ kiŋkɛ ki kintutu ki bɛniiŋ bɛ nchi-i kɛɛ kichu ki banchɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Be dzɔ ndu yi bumfɔŋ yi gbɔɔ be chuumɛ wu li bwiŋ, be se lo kifɔ ki bumfɔ-ɔŋ ki nuuŋ biaŋ biaŋ be beeŋ wu li fa. ");
INSERT INTO asj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Be bɛchi be bundi wu le, “Buri, Mfɔŋ wu Bɛjuu.” ");
INSERT INTO asj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Si be tɛ̀ feti lɛ be tuki wu bɛ kimbaaŋ li kikoo li, be kwiyi wu bɛ budii, be bɛɛ be tundi núŋ wu lii, be bundi wu. ");
INSERT INTO asj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Le be choosɛ wu lɛ be mɛɛshi, be kaari be buu ndu yi bumfɔŋ yi gbɔɔ yɛ wu li bwiŋ, be lii wu ndú yee li bwiŋ, be dzɔ wu be giiŋgi le be gɛɛŋ be taaŋ wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Le be ni be giiŋgi, be bikɛ bɛ wi wumu kuuki litɔɔ bukooŋ bwee le Simu, nuuŋ wi wu Sɛliŋ. Tɛ̀ nuuŋ te Alɛkɛsanda bɛ Lufu. Be kaŋ wu le too kintaaŋ ki Jiso-o. ");
INSERT INTO asj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Be giiŋgi bɛ Jiso, be gɛɛŋ be bo fɛ kintsii ki bɛ teenyi le Gɔɔgɔɔta, (bukooŋ buni nuuŋ le Kiŋgefi ki Kikoo lɛ,) ");
INSERT INTO asj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","be nyɛ mbiiŋ li wuu le woŋ ɛ be fiinsɛ bɛ ntsi yimi yi bɛ teenyi le mɛɛ. Se nuuŋ le Jiso ti mɛɛŋ ki woŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Be se ta wu li kintaaŋ li. Be dzɔ ndú yee le be gachɛ li yi yi bee be se toŋ kaŋ bɛ ndú yilu le be kɛɛ wi wu nuuŋ dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mfi wu be tɛ ta Jiso li kintaaŋ li tɛ̀ nuuŋ jobɛ bikaa mfomɛyoofi fɛŋwɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bɛ tsɛɛ fiee fi bɛ ta wu li kintaaŋ li kii fi, fi nuuŋ le, “Mfɔŋ wu Bɛjuu.” ");
INSERT INTO asj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɛ tɛ̀ tayɛ tɛ bɛyi bamu bɛfɛ li bintaaŋ li wumu lɛ kibɛnɛ ki Jiso-o ki kigɔŋɛ, wumu lɛ kibɛnɛ kee ki kimɛsɛ.  ");
INSERT INTO asj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Fi se bɛ fi kɔchɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ le, “Bɛ tɛ̀ fa wu li kintutu ki bɛniiŋ bɛ tɛ̀ chɔ biee li lɛnti.” ");
INSERT INTO asj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bɛniiŋ se kɛti be ŋiŋgi Jiso be tiki bikoo, be tsuki wu bɛ ntsooŋ be tiiti le, “Ɛŋhɛɛŋ! Wɛ wu nuuŋ ɔ shaanshɛ yih yi muntofi ɔ kaari ɔ gwaŋ yi li jo taa li, ");
INSERT INTO asj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","fi yi ya, ɔ shee li kintaaŋ kɛɛ li.” ");
INSERT INTO asj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ tuu bee choosi wu be tiiti li yi yi bee le, “Tɛ̀ gii fii bɛniiŋ bamu, kɛɛ nuuŋ fi yi yee nsiŋ. ");
INSERT INTO asj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wu wu nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ, wu wu nuuŋ Mfɔŋ wu bɛniiŋ bɛ Isɛlɛɛ shee li kintaaŋ li dɛɛni tɛ ŋɛŋ tɛ se beŋ li wuu.” Bɛniiŋ bɛ bɛ tɛ̀ taaŋ be li bintaaŋ li bɛ Jiso baa tɛ̀ tsuki tɛ wu bɛ ntsooŋ. ");
INSERT INTO asj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Le gɛɛŋ bo fɛnshaaŋ kintikinti, lɛkuuŋ dza le jiŋ kwɛɛŋ kwikwi nsiiŋ gɛɛŋ bo jobɛ bikaa bitɛɛtu lɛ fɛmfo-o. ");
INSERT INTO asj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Le ni nuuŋ jobɛ bikaa bitɛɛtu, Jiso dza dzaaŋ lɛwe le, “Ɛlɔy, Ɛlɔy lama sabatani,” fi nuuŋ le, “Nyɔ yɛŋ, Nyɔ yɛŋ, ɛ la fi ɔ lɔŋ mi ni?” ");
INSERT INTO asj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Le bɛniiŋ bamu bɛ tɛ̀ lemi fe woo, be tee le, “Yikɛ yɛɛŋ nɛ woo, teenyɔɔ Ɛlaja.” ");
INSERT INTO asj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wi wumu li bee linti dza letɛ dzɔ kifiiŋ, fooŋ li mbiiŋ mɛ mgbanyi-i, fasɛ li fintiiŋ li nɛɛki le woŋ, se tee le, “Lemɛ yɛɛŋ tɛ ŋɛŋ laa Ɛlaja gii bɛ shiiki wu li kintaaŋ kini-i le.” ");
INSERT INTO asj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jiso dza waŋ kwe lɛwe ŋge se yindɛ yindinɛ wu kimɛrisɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ndu yi tɛ̀ gatini yih yi muntofi lɛnti tɛ̀ batɛ kintikinti mbɛɛchɛ fɛwe mbɔwu mbochu fɛtɛ li biŋkɛ bifɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Le te kikoo wu bɛniiŋ bɛ nchi-i wu tɛ̀ lemi Jiso limfwe tuu ŋɛŋ dze yi Jiso kwi le, se tee le, “Chɛɛŋ chɛɛŋ, wi wuni tuu nuuŋ Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bukɛɛŋ bamu tɛ̀ lemi fe mfiiŋ be bichi. Li bee linti tɛ̀ nuuŋ Maariya Madaliŋ bɛ Maariya wu ni Jeeŋ wu bwi bɛ Jɔsɛ, wumu nuuŋ Salomɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bukɛɛŋ bani nuuŋ bɛ tɛ̀ shiiŋ be biki Jiso Galilii be fii wu. Be tɛ̀ nuuŋ fe mɔɔ bukɛɛŋ bamu tɛ ŋge bɛ tɛ̀ biee Jiso bee be bɛ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tɛ̀ nuuŋ lɛ fɛmfo-o booyaa, ɛ tɛ̀ nuuŋ Jobɛ chi nachɛ-ɛ le be lɛ li jobɛ chi bɛshiinshi-i, ");
INSERT INTO asj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wi wumu wu Arimatia wu bɛ tɛ̀ teenyi le Jɔsɛ, kaŋ shéŋ gɛɛŋ ŋɛŋ Pailɛt lɛkɛ gwini chi Jiso-o le gɛɛŋ diyɛ. Jɔsɛ wuni tɛ̀ nuuŋ wi wu kintutu ki bɛniiŋ bɛ sɛki kwɛɛŋ lɛ, ɛ bɛniiŋ tɛ̀ guundi wu ŋge. Ɛ wu kibɛɛ tɛ̀ gii tɛŋgi tɛ mfi wu bumfɔŋ bu Nyɔ-ɔ gii naa bu bɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailɛt woo, kimfimɛ wondɛ wu le Jiso kwiɔ kituŋ. Se teeŋ te kikoo wu bɛniiŋ bɛ nchi-i wɛ bɛ, se bii li wuu laa Jiso bee kwi kituŋ ni. ");
INSERT INTO asj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Le woo li te kikoo wu bɛniiŋ bɛ nchi-i wɛ le Jiso bee kwi, se nyɛ gwini chilu li Jɔsɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jɔsɛ se dza gɛɛŋ go ndu yi dzeeŋ, gɛɛŋ shiiki gwini chi Jiso-o, fiɛɛmɛ fe, gɛɛŋ giiki lɛ dziŋ yi bɛ tɛ̀ chɔ li kimba-aŋ, biiŋgi tɛtɛ chi nɔŋa baanyɛ fweeŋ wu dziŋ yilu lu. ");
INSERT INTO asj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maariya Madaliŋ bɛ Maariya wu ni Jɔsɛ tɛ̀ ŋɛŋ kintsii ki bɛ diyɛ Jiso fe. ");
INSERT INTO asj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Le jobɛ chi bɛshiinshi bɛ chi ka, Maariya Madaliŋ bɛ Maariya wu ni Jeeŋ, mɔɔ Salomɛ go mɛɛŋ mɛ sɛɛndi le be gɛɛŋ be fwa gwini chi Jiso-o lu. ");
INSERT INTO asj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ɛ tɛ̀ gii mɛɛŋ taantaaŋ nɛɛ si jobɛ mɛɛŋ chi tɛti li jobɛ chi ŋkosi li fuu li, be dza be giiŋgi fɛ dziŋ fɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Si be tɛ̀ giiŋgi lɛ be tɛ̀ tiiti li yi yi bee le, ɛ noo wu gii bachɛ tɛtɛ chi bɛ bɛŋɛ mfweeŋ wu dziŋ wɛɛ be se lɛ le? ");
INSERT INTO asj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Se nuuŋ le, le be lendi lii, be ŋɛŋ ɛ bɛ tɛ̀ biiŋgi tɛtɛ chilu. Tɛtɛ chini tɛ̀ nuuŋ kiŋgiŋgiri ki tɛtɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Le be lɛ lɛ dziŋ, be ŋɛŋ sɔɔnɛ wi wumu ɛ wu shee lɛ kibɛnɛ ki kigɔŋɛ-ɛ ɛ wu chuumɛ ndú yi njeeŋ, yi nɛŋgi. Yi kofi be. ");
INSERT INTO asj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sɔɔnɛ wi wulu tee li bee le, “Kiiŋ yi ni yi koofi beŋ kɛ. Ŋkiiɔ le nɛ wɛki baa nuuŋ Jiso wu Nasarɛ wu bɛ tuu bɛ taaŋ li kintaaŋ li wɛ. Mɛɛŋ yɛ fɛni kɛ. Wu boɔ li kwe-e. Bichɛ yɛɛŋ nɛ ŋɛŋ fɛ bɛ tuu bɛ giiki wu. ");
INSERT INTO asj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gɛnɛ yɛɛŋ nɛ tee li bɔɔŋ bee bɛ kintutu-u mɔɔ li Pita-a le tuutɔɔ mbaaŋ li bee Galilii. Nɛ gii nɛ ŋɛŋ wu le si tɛ̀ tee beŋ.” ");
INSERT INTO asj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bukɛɛŋ baa bo lɛ dziŋ be kɛɛti ni kikikiki, be dza be kifi, ɛ bimfimu gbɛɛŋ bi wondɛ be ni kataraa. Be ti mɛɛŋ ki tee kɛ fiee li wi-i kɛ, kifɛ be tɛ̀ chɛndi.  ");
INSERT INTO asj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jiso tɛ̀ bo li kwe-e li jobɛ chi ŋkosi chi li fuu li mɛɛŋ li ki bitebite-e, saa busɛ nuuŋ lɛ Maariya Madaliŋ lii wu tɛ̀ buu bɔɔŋ bɛ kiŋkundi-i li yi yee li mfomɛnyaaŋ. ");
INSERT INTO asj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maariya se gɛɛŋ tee li bɛniiŋ bɛ Jiso tɛ̀ nuuŋ bee be. Bɛniiŋ bani tɛ̀ nuuŋ ɛ be shee be chiŋ bikoo be dii. ");
INSERT INTO asj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Le be woo si kwɛɛŋ wɛ tiiti le bee ŋɛŋ Jiso nuuŋ lu, be ti mɛɛŋ ki beŋ kɛ dududu. ");
INSERT INTO asj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lɛjiŋ lɛlu, Jiso tuu doonchɛ yi yee li bɛniiŋ bee bamu bɛ kintutu-u bɛfɛ be giiŋgi li kitoŋ kimu ɛ mbosɛ yee fiiki. ");
INSERT INTO asj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Be to lijiŋ, be gɛɛŋ be tee li kiŋkɛ ki bɛniiŋ bɛ kintutu-u, be ti mɛɛŋ ki beŋ li bee kɛ. ");
INSERT INTO asj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lɛjiŋ lɛlu Jiso doonchɛ yi yee dɛɛni li bɔɔŋ bee bɛ yoofi ntsɔ mumkpa-aŋ kibɛɛ fɛ be tɛ̀ jii biee. Se wamɛ be, kifɛ be tɛ̀ mɛɛŋ ki beŋ kɛ, be tɛ̀ tɛɛmi bikoo le be beŋ li bɛniiŋ bɛ tɛ̀ ŋɛŋ wu mfi wu tɛ̀ bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Se tee li bee le, “Gɛnɛ yɛɛŋ li kwɛɛŋ kwikwi-i nɛ gɛɛŋ nɛ ni nɛ fenjisi ntoŋ wu dzeeŋ wu Nyɔ li bɛniiŋ bɛchu-u. ");
INSERT INTO asj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wi wu beŋ li ntoŋ wulu-u, bɛ lii wu li dzɔɔ, gii bɔnɛ. Wi wu faaŋ mbeenchɛ, gii we nsa. ");
INSERT INTO asj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bɛniiŋ bɛ gii be beŋ gii be ni be feti biee bi doonchi buŋga bu Nyɔ-ɔ si buni: be gii be ni be busi bɔɔŋ bɛ kiŋkundi-i li bɛniiŋ li, li bukooŋ bwe-eŋ. Be gii be yɔ jɛ́ yi fiɛŋ. ");
INSERT INTO asj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Be gii be ni be kɛmi li yɔ́-ɔ bɛ tsaŋ. Mɔɔ be woŋ tsi, yi tɛ ge be fiee kɛ. Be gii be ni be giki tsaŋ li bɛniiŋ bɛ gendi-i, be tɛɛmi.” ");
INSERT INTO asj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Le Taa Jiso yɔ li bee lɛ mɛɛshi, Nyɔ se dzɔ wu yɛɛ liboo shee lɛ kibɛnɛ ki kigɔŋɛ ki Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bɔɔŋ bee bɛ kintutu-u dza be deŋgi be tiifi toŋ wu dzeeŋ li bitsii bichu-u. Taa se nindi bee be fɛɛfi fiee fi be tɛ̀ tiifi le fi fiɛɛ chɛɛŋ bɛ biee bi doonchi buŋga bu Nyɔ-ɔ bi be tɛ̀ feti.");
INSERT INTO asj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wi wu nyɔŋa Tiofilos bɛniiŋ ŋge gwenɛ baa le be tsɛɛ kii biee bi tɛ̀ kɛti lɛ bee li lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Be tsɛɛ baa biee bilu nɛɛ tsaaŋ si bi tɛ tɛ̀ woo bɛ bɛniiŋ bɛ tɛ̀ ŋɛŋ bɛ lii yibe, mɔɔ bɛniiŋ bɛ tɛ̀ laanchɛ nsa wulu si wu tɛ̀ bɛchi. ");
INSERT INTO asj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mi nse ndzɔɔ mfi le ntaashɛ lɛ biee bini-i lɛnti bichu fɛmbɛɛchɛ-ɛ, mi nse ŋɛŋ le fi dzɔɔŋ le mbanchɛ ntsɛɛ tɛ li wɛ-ɛ lɛ dze yi tsaaŋ li. ");
INSERT INTO asj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi mfɛɔ ni le ɔ kɛɛ chɛɛŋ wu biee bi bɛ tɛ̀ saa bɛ tifi wɛ ŋkosi. ");
INSERT INTO asj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mfi wu Mfɔŋ Hɛrɔ tɛ̀ sɛki kwɛɛŋ wu Judiya, wi wu muntofi wumu tɛ̀ nuuŋ le bɛ teenyi wu le Sakariya. Ɛ tɛ̀ nindi li kintutu ki bɛte muntofi-i bɛ Abija-a, ɛ ni yih we tɛ̀ bo li kini ki Ɛrɔ-ɔŋ, bɛ teenyi wu le Lisabɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bɛniiŋ bɛ bɛfɛ bani tɛ̀ nuuŋ bɛniiŋ bɛ tsaaŋ lɛ Nyɔ lii, be kichi bɛnchi bɛ Taa lɛ bɛchu, be nuuŋ findzɔŋ siŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Se nuuŋ le, be ti mɛɛŋ ki kɛmɛ kɛ ŋwaŋ kɛ, kifɛ Lisabɛ tɛ̀ nuuŋ kaa, be bɛchu tɛ̀ nuuŋ ɛ be doŋ kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mfi tɛ̀ kɔchɛ le kintutu ki Sakariya ni ki nindi li yih yi muntofi-i yi Taa li. Ɛ tɛ̀ nuuŋ te muntofi lɛ Nyɔ lii booyaa, ");
INSERT INTO asj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ɛ bɛ tɛ̀ tsaa wu biki si bɛ tɛ̀ shiiŋ bɛ tsɛki bɛte muntofi li ntsɛ wube-e. Se tɛ̀ lɛ li yih yi muntofi le tɔŋ kidzoma. ");
INSERT INTO asj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mfi se tɛ̀ kɔchɛ le tɔŋ kidzoma ɛ bɛniiŋ bɛchu tɛ̀ nuuŋ lɛkuuŋ be lɛki li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nchindaa wu Taa, taa busɛ wu lii, leŋ lɛ kibɛnɛ ki kigɔŋɛ ki taantaa chi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mfi wu Sakariya tɛ̀ ŋɛŋ wu, dzakɛ bɛchi kɛɛti bɛ chɛnɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Se nuuŋ le, nchindaa wulu tɛ̀ tuu tee li wuu le, “Kiiŋ ɔ ni chɛŋ kɛ Sakariya. Nyɔ woo yɛ nlɛkɛ li Nyɔ-ɔ wa kituŋ. Ni yih wa wu Lisabɛ gii biɛ ŋwaŋ wu nyuŋ ɔ choŋ wu bukooŋ le Jɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gii bɛ bɛ kinɛɛtinɛ li wɛ-ɛ, bɛniiŋ ŋge se woo bujɔŋ kii biɛrɔ chee. ");
INSERT INTO asj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gii ni nuuŋ wi wu nyɔŋa lɛ Nyɔ lii. Kiiŋ ni ni wundi mbiiŋ kɛ, teege mɛ tɛɛmi. Fiana yi Waaŋ gii yi yisɛ li wuu mɛɛŋ lɛ ni shéŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gii fɛ le bɛniiŋ bɛ Isɛlɛɛ ŋge fiiki shéŋ yibe, be kaari be to bɛ Taa wu Nyɔ yibe. ");
INSERT INTO asj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Gii gɛɛŋ limfwe li Taa li, bɛ fiana mɔɔ buŋga bu Ɛlaja-a le fiiki shéŋ yi bɛ te bɔɔŋ, yi to li bɔɔŋ bɛ bee. Gii fɛ bɛniiŋ bɛ tɛɛmi bikoo chinɛ li bikoo bi tɛɛmɛ-ɛ, se fiiki bɛntsɛ bɛ bee, be ni be kɛmi bɛmbeechɛ bɛ nuuŋ bɛ bɛniiŋ bɛ tsaaŋ lɛ. Gii naa fɛ lɛ, le nachɛ bɛniiŋ be ni be tɛŋgi Taa.” ");
INSERT INTO asj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariya se bii li nchindaa wu Nyɔ wulu-u laa, “Fiee fi gii fi fɛ nse ŋkɛɛ lɛ nuuŋ la, si tɛɛ ni yi wɛŋ nuuŋ ɛ tɛ̀ doŋ kituŋ ni?” ");
INSERT INTO asj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nchindaa wulu se tuu le, “Ɛ mi Gabriya, nlemi lɛ Nyɔ lii mfi kwi, ɛ yi yi toŋ mi le mbɛ nlaŋɛ ntoŋ wu dzeeŋ wuni li wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bichɛ ɔ ŋɛŋ, si ɔ mɛɛŋ ɔ ki beŋ kɛ ntoŋ wuni kɛ lɛ, mfi gii bɛ kɔchɛ le fi dzɔɔ kintsii, ɔ gii ɔ to kinchiinchii, ɔ tɛ̀ yɔ kɛ, giiŋgi buti mfi wu fiee fini gii fi yenɛ.” ");
INSERT INTO asj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Si fi tɛ̀ kɛti lɛ, bɛniiŋ bɛ tɛ̀ nuuŋ lɛkuuŋ be tɛŋgi Sakariya baa tɛ̀ ta maa laa, ɛ la fi fɛ wu se ba li yih yi muntofi-i ŋge lɛ le. ");
INSERT INTO asj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mfi wu tɛ̀ bo lu, tɛ̀ mɛɛŋ yɛ kii n'yɔru li bee kɛ. Be se kɛɛ le Nyɔ doonchɛ yɛ fiee fi kimfimɛ wondini li wuu lu. Se tɛ̀ to mɛki biee li bee nuuŋ bɛ tsaŋ, tɛ̀ yɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Le Sakariya mɛɛshi nimɛ chee li yih yi muntofi-i, kaari to lijiŋ fɛ wuu kuuŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Le jo yimi ka, kwɛsi wu Lisabɛ fwee. Tɛ̀ to li yih, li yih kii tiŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Lisabɛ se tee le, “Dɛɛni Taa kɔɔ ɔ nshiiŋ bɛ mi, wu buu buya li kikoo ke-eŋ.” ");
INSERT INTO asj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Le fwe chi Lisabɛ-ɛ chɛɛ bo kii busɔɔ, Nyɔ toŋ nchindaa we wu Gabriya li kitoŋ kimu ki Galilii ki bɛ teenyi le Nasarɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tɛ̀ gɛɛŋ bɛ ntoŋ lɛ sɔɔnɛ kwɛɛŋ wumu wu bɛ tɛ teenyi le Maariya, wu tɛ̀ mɛɛŋ saa nyuŋ ki kɛɛ kɛ. Tɛ̀ nuuŋ ɛ bɛ tɛ̀ nachɛ le gii naa nuuŋ kwɛɛ Jɔsɛ wu li kini ki Mfɔŋ Daafi-i. ");
INSERT INTO asj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nchindaa wu Nyɔ wulu se gɛɛŋ ŋɛŋ Maariya tee li wuu le, “N'yɛɛshɔɔ wɛ. Taa tsaaɔ wɛ kituŋ wɛ bɛ wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Le Maariya woo lɛ fi fieeŋgi wu ŋge, se ta maa laa ŋwaani wuni n'yɛɛshɛ nuuŋ wu niŋ le. ");
INSERT INTO asj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Se nuuŋ le, nchindaa wu Nyɔ wulu tɛ̀ tee li wuu le, “Maariya kiiŋ ɔ ni chɛŋ kɛ. Nyɔ tsaa yɛ wɛ kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bichɛ ɔ ŋɛŋ, ɔ gii ɔ fwee, ɔ biɛ ŋwaŋ wu nyuŋ, ɔ choŋ bukooŋ bwee le Jiso. ");
INSERT INTO asj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Gii ni nuuŋ wi wu nyɔŋa, bɛ ni bɛ teenyi wu le Ŋwanɛ Nyɔ, Nyɔ yi nuuŋ Kikoo ki biee bichu-u. Taa wu Nyɔ gii biiŋgi wu li kabara wu Mfɔŋ Daafi-i wu te kini ki bee. ");
INSERT INTO asj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Gii ni taanchi kini ki Yakɔ-ɔ mfi kwi, bumfɔŋ bwee nuuŋ tɛ naa ma kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maariya se bii li nchindaa wu Nyɔ wulu laa, “Fini gii fi ka nindee le, si mɛɛŋ ŋwaŋ wu kii yɛ nyuŋ kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nchindaa wu Nyɔ wulu se tuu li wuu le, “Fiana yi Waaŋ gii yi bɛ li wɛɛ, buŋga bu Nyɔ yi liboo yi nuuŋ kikoo ki biee bichu gii bu yisɛ li wɛ-ɛ. Bɛdɛɛni, ŋwaŋ wu ɔ gii ɔ biɛ wulu gii ni nuuŋ waaŋ, bɛ se teeŋ wu le Ŋwanɛ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bichɛ ɔ ŋɛŋ, ŋwanchaa wu Lisabɛ wu tɛ nyiichɛ bɛ budonu bɛ teenyi wu le kaa, wɛ dɛɛni bɛ fwe kii busɔɔ, gii biɛ ŋwaŋ wu nyuŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bɛ Nyɔ fiee fimu lu fi nuuŋ fi yaa yi kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maariya se tee le, “Ɛ mi ŋwanɛ nimɛ wu Nyɔ. Fɛrɛ fi ka bɛ mi nɛɛ si ɔ tee.” Le tee lɛ, nchindaa wu Nyɔ wulu dza. ");
INSERT INTO asj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mbɛɛchɛ li jo yilu-u, Maariya dza bakɛ gɛɛŋ li kitoŋ kimu ki li kwɛɛŋ wu Juda wu nuuŋ li ŋkumɛ-ɛ, ");
INSERT INTO asj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","le gɛɛŋ bo le, lɛ li Sakariya yih, yɛsi ni yih we wu Lisabɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Le Lisabɛ woo n'yɛɛshɛ wu Maariya wɛ, ŋwaŋ nduuŋ wu lɛ shéŋ ŋge. Fiana yi Waaŋ yisɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Se wuri lɛwe ŋge, tee le, “Kimbɔnɛ ki Nyɔ-ɔ kɛɛ li wɛɛ yɛki bukɛɛŋ bɛchu, kimbɔnɛ kilu kɛɛ tɛ li ŋwaŋ wu ɔ gii ɔ biɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ŋwaani fiee fi nɔŋa fini geeŋ fi ka bɛ mi, le ni Taa wɛŋ la ŋka lɛ mi-i? ");
INSERT INTO asj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bichɛ ɔ ŋɛŋ, mfi wu mbee ŋ'woo n'yɛɛshɛ wa, ŋwaŋ nduuŋ mi lɛ shéŋ bɛ kinɛɛtinɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bujɔŋ bunɔŋa bwɛɛ bwo, kifɛ ɔ beŋɔ le ŋkaachɛ wu Nyɔ tɛ̀ kaachɛ gii naa bɛ kɔchɛ.” ");
INSERT INTO asj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maariya se tee le, “shéŋ yɛŋ yɔɔnchi yɛɛ Taa wu Nyɔ, ");
INSERT INTO asj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ŋ'wuki bujɔŋ kii Nyɔ yi nuuŋ Kinsofu keŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yi kimi yɛ lɛ mi-i, nuuŋ ɛ mi ŋwani wu nimɛ wu yee. Mbɛɛchɛ dɛɛni ŋgɛnu limfwe, kiŋgɔkɛ kichu gii ki ni ki tiiti le, Nyɔ lɔŋ yɛ kimbɔnɛ li mi-i, ");
INSERT INTO asj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kifɛ Nyɔ yi Buŋga Buchu fɛ yɛ biee bi nɔŋa bi nɔŋa ŋge li mi-i. Bukooŋ bu yi kɛmi yɛ mawu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yi ti keeti nshiiŋ bɛ bɛniiŋ bɛ guundi li yi-i. Nshiiŋ yini se nuuŋ li kiŋgɔkɛ kichu-u. ");
INSERT INTO asj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yi doonchɛ yɛ buŋga bu kibɛnɛ kee lɛ, yi shaanshɛ yɛ bɛniiŋ bɛ tsakisi yí, bɛmbeechɛ bɛ bee layɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yi shɔni yɛ bɛmfɔŋ bɛ nɔŋa bɛ nɔŋa li bɛkabara, yi se tsaaki bɛniiŋ bɛ yee liwe. ");
INSERT INTO asj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yi nyɛkɛ yɛ bɛniiŋ bɛ dzeeŋ wuu be, be fukɛ bɛ biee bi dzeeŋ kituŋ, Yi kooŋ bɛ bɛniiŋ bɛ biee lɛ bɔ kilɛrɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yi fi yɛ wi we wu nimɛ wu Isɛlɛɛ, Yi kimi ndoonchɛ nshiiŋ li Abrahaŋ bɛ kini kee, yi gɛɛŋ yi mɛɛshi nɛɛ si yi tɛ̀ kaachɛ li bɛte taa bɛsɛ-ɛŋ.” ");
INSERT INTO asj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Le Maariya, tsi bee Lisabɛ, kii tɛɛ, tuu kaari to lijiŋ fɛ kuuŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Le mfi wu Lisabɛ wu biɛrɔ kɔchɛ, biɛ ŋwaŋ wu nyuŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Le kini kee mɔɔ bɛniiŋ bɛ tɛ̀ tsiiŋ tsɛkɛ tsɛkɛ fe woo le Nyɔ doonchɛ yɛ nshiiŋ li wuu ŋge, be nɛɛtɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Le jo bo nyaaŋ, be bɛ le bɛ sɛɛ ŋwaŋ wulu dzoo, be tuu be wɛki tɛ le be nyɛ wu bukooŋ le Sakariya nɛɛ si bu Tee lɛ, ");
INSERT INTO asj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","se nuuŋ le, ni tɛ̀ faaŋ fiee, tee le bɛ gii bɛ ni bɛ teenyi wu le Jɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Be se tee li wuu le, “Wi nuuŋ yɛ li kini kinɛ bɛ bukooŋ buni kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Be se bɛchi be mɛki bɛ tsaŋ li te ŋwa-aŋ, le be kɛɛ laa wɛki le bɛ nyɛ bukooŋ bu ŋwaŋ le noo le. ");
INSERT INTO asj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Se maa le be bɛ bɛ fiee tsɛɛ fe fɛwe. Be bɛ bɛ fi, se tsɛɛ le, “Bukooŋ bwee bwɛɛ le Jɔɔŋ.” Le be ŋɛŋ lɛ bimfimu wondɛ be. ");
INSERT INTO asj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mfwaa mumkpaŋ, kimfimɛ ki Sakariya biee ki gwiyɛ, nimi chee fanchɛ, tuu bɛchi n'yɔru, piɛti Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bɛniiŋ bɛ kitoŋ kilu-u tɛ̀ tɛ wa ŋge. Ntoŋ wu biee bini bichu se saaŋgɛ wu gɛɛŋ li kwɛɛŋ wu Judiya wu nuuŋ li ŋkumɛ-ɛ kwikwi. ");
INSERT INTO asj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bɛniiŋ bɛchu bɛ tɛ̀ woo biee bini tɛ̀ gɛɛ li shéŋ yi bee, be se biiti laa wuni ŋwaŋ gii naa nuuŋ wu la le? Kifɛ fi tɛ̀ gbɛŋgi fi doonchi le kimbɔnɛ ki Nyɔ-ɔ kɛɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Fiana yi Waaŋ tɛ̀ dza yi yisɛ li Sakariya wu te Jɔɔŋ li, se dza yeti nɛɛ si ntomfɔŋ wu Nyɔ, tiiti le, ");
INSERT INTO asj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tɛ pia Taa wu nuuŋ Nyɔ yi bɛniiŋ bɛ Isɛlɛɛ. Yi bɛ yɛ kituŋ le yi soo bikoo bi bɛniiŋ bee li, li ŋgɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yi gɛɛ yɛ wi wu buŋga kituŋ wu gii soo bee, wu bo li kini ki wi we wu nimɛ-ɛ wu Mfɔŋ Daafi. ");
INSERT INTO asj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Fini nuuŋ si yi tɛ̀ kaachɛ mɛɛŋ lindɛɛri lɛ bimfimu bi bɛntomfɔŋ bee bɛ waaŋ bɛ tɛ̀ gɛɛ, ");
INSERT INTO asj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","le yi gii naa yi soo bee li tsaŋ yi bɛniiŋ bɛ wɛki le be lɛɛshɛ bee, mɔɔ bɛniiŋ bɛsɛŋ bɛ mbani-i. ");
INSERT INTO asj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yi tɛ̀ kaachɛ le yi gii naa yi kɔɔ nshiiŋ li bɛte taa bɛsɛŋ yi se shiiŋ yi kiimi leh wu yi yi Nyɔ tɛ̀ ji. ");
INSERT INTO asj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yi tɛ̀ kaachɛ li te bɛtaa bɛsɛŋ wu Abraha-aŋ bɛ nchini, yi chini le, ");
INSERT INTO asj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yi gii yi buu bee li tsaŋ yi bɛniiŋ bɛsɛŋ bɛ mbani-i, ke tɛ ni tɛ nindi li yi-i nchɛnu nsiŋ, ");
INSERT INTO asj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tɛ ni tɛ tsiiŋ ntsɛ wu waaŋ bɛ wu tsaaŋ lɛ yi-i lii jo chichi li ntsɛ wusɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wɛ ŋwanɛŋ, bɛ gii bɛ ni bɛ teenyi wɛ le ntomfɔŋ wu Nyɔ, Nyɔ yi nuuŋ kikoo ki biee bichu-u, kifɛ ɔ gii naa ɔ gɛɛŋ limfwe li Taa li ɔ ni ɔ nachi dze ye. ");
INSERT INTO asj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ɔ gii ɔ ni ɔ tiifi bɛniiŋ bee, dze yibe gii be kɛmɛ Kinsofu le, ki nuuŋ kimfekisɛ ki Nyɔ gii yi feeki bibifi bi bee, ");
INSERT INTO asj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kii nshiiŋ yi Nyɔ ŋge yi keeti li bɛniiŋ li. Yi gii yi tuumi Kinsofu ki ni ki shiiti ki bɛɛ liwe si jobɛ ti tɛti lɛ. ");
INSERT INTO asj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yi gii yi nyɛ kiŋ'wofu li bɛniiŋ bɛ nuuŋ li kijibɛ-ɛ mɔɔ bɛ nuuŋ lɛ kwe wa, se leeki bee lɛ dze yi mbɛɛŋgii li.” ");
INSERT INTO asj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ŋwaŋ wulu se gii kuu li nyaŋ ye-e, kuu tɛ bɛ fiana. Se dza gɛɛŋ le ni tsiiŋ tɛ li buka, gɛɛŋ bo jobɛ chi tɛ̀ bo le doonchɛ yi yee li bɛniiŋ bɛ Isɛlɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tɛ̀ nuuŋ li mfi wumu-u, nchi bo le, bɛ fa bɛniiŋ bɛchu bɛ nuuŋ li bitoŋ bi kwɛɛŋ wu Lo-om. Wu tɛ̀ bo lɛ Kaisa Agustu wu tɛ̀ nuuŋ Mfɔŋ wu nyɔŋa wu Lom. ");
INSERT INTO asj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mfa wuni tɛ̀ nuuŋ wu ŋkosi li mfi wu Kwilinu tɛ̀ nuuŋ ŋkuŋ wu tɛ̀ sɛki kimbɛ ki kwɛɛŋ wu Silia. ");
INSERT INTO asj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bɛdɛɛni, bɛniiŋ bɛchu tɛ̀ tuu lijiŋ li bitoŋ bi bee, le be tsɛɛ mɛŋkooŋ mɛ bee mɔɔ mfa wu be. ");
INSERT INTO asj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jɔsɛ se dza tɛ Nasarɛ li kitoŋ kimu ki Galilii, gɛɛŋ Bɛtɛlɛhɛŋ lɛ kimbɛ ki kwɛɛŋ wu Judiya, lɛ bɛ tɛ̀ biɛ Mfɔŋ Daafi. Tɛ̀ gɛɛŋ le kifɛ tɛ̀ nuuŋ wi wu li kini ki Mfɔŋ Daafi-i. ");
INSERT INTO asj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jɔsɛ tɛ̀ gɛɛŋ bee Maariya wu tɛ̀ koo fieeŋ le gii naa ni nuuŋ kwɛsi le be tsɛɛ mɛŋkooŋ mɛ bee, ɛ tɛ̀ nuuŋ bɛ fwe. ");
INSERT INTO asj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Le be gɛɛŋ be bo le, mfi we wu biɛrɔ kɔchɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Biɛ ŋwani wu ŋkosi nuuŋ ŋwaŋ wu nyuŋ, fiɛɛmɛ fɛ ndú, giiki lɛ ŋgo wu nyá-aŋ, kifɛ be tɛ̀ foo kintsii ki tsɛ fɛ yih yi bɛniiŋ fufini fe-e. ");
INSERT INTO asj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tɛ̀ nuuŋ li mfi wulu-u, bɛniiŋ bɛ kiichi nshɔ́ɔŋ bamu nuuŋ li kitoŋ kilu lichiŋ litɔɔ, be kiichi kintutu ki nshɔ́ɔŋ yi be butuu. ");
INSERT INTO asj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nchindaa wu Taa taa busɛ be lii, kiŋ'wofu ki Nyɔ-ɔ kinɔŋa woo fɛ be tɛ nuuŋ, be kɛmɛ chɛnɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nchindaa wulu se tee li bee le, “Kiiŋ nɛ ni chɛŋ kɛ. Woo yɛɛŋ, mi mbɛɛɔ nuuŋ bɛ ntoŋ wu dzeeŋ li be-eŋ, wu gii wu bɛ bɛ kinɛɛtinɛ kinɔŋa li bɛniiŋ bɛnɛ-ɛ bɛchu-u. ");
INSERT INTO asj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Li jobɛ chi bɛŋ chini bɛ biɛ baa Kinsofu kinɛ li kitoŋ ki Mfɔŋ Daafi-i ki nuuŋ Krai wu Taa. ");
INSERT INTO asj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Fiiŋ fiee fi gii fi doonchɛ ntoŋ wulu li be-eŋ. Nɛ gii nɛ gɛɛŋ nɛ ŋɛŋ ŋwaŋ ɛ bɛ fiɛɛmɛ wu fɛ ndu-u, bɛ giiki lɛ ŋgo wu nyá-aŋ.” ");
INSERT INTO asj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Be se dza be taa be ŋɛŋ nchindaa wulu lɛ kintutu kimu ki bɛniiŋ bɛ dziŋ bɛ liboo li ŋge be yɔɔnchi Nyɔ, be tiiti le, ");
INSERT INTO asj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“N'yɔɔnchɛ nuuŋ li Nyɔ-ɔ yi yɛki biee bichu mbɛɛŋgii ni nuuŋ laaŋkwiiŋ li bɛniiŋ bɛ Nyɔ wuki bujɔŋ bɛ be.” ");
INSERT INTO asj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mfi wu bɛnchindaa baa tɛ chinɛ li bee, be kaari be yɛɛ liboo, bɛniiŋ bɛ kiichi nshɔ́ɔŋ bɛlu tee li yi yi bee le, “Tɛ̀ gɛɛŋ dɛɛni yani Bɛtɛlɛhɛŋ, tɛ ŋɛŋ fiee fi ka fi Taa fɛ le tɛ kɛɛ fini.” ");
INSERT INTO asj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mfwa mumkpaŋ, be dza be bakɛ be gɛɛŋ be ŋɛŋ Jɔsɛ bee Maariya mɔɔ ŋwaŋ, gimi lɛ ŋgo wu nyáŋ. ");
INSERT INTO asj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Si be tɛ̀ ŋɛŋ lɛ, be bɛchi be tiiti biee bichu bi nchindaa wu Nyɔ bee tee li bee kii ŋwaŋ wulu. ");
INSERT INTO asj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bimfimu se wondɛ bɛniiŋ bɛchu bɛ tɛ̀ woo biee bi bɛniiŋ bɛ kiichi nshɔ́ɔŋ baa tɛ̀ tiiti be. ");
INSERT INTO asj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maariya se kiri biee bini bichu lɛ shéŋ, shiiŋ kiimi kii bi mfi kwi. ");
INSERT INTO asj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɛniiŋ bɛ kiichi nshɔ́ɔŋ baa se kaari be to lijiŋ be yɔɔnchi be piɛti Nyɔ li biee bichu bi be tɛ̀ woo be ŋɛŋ. Bi tɛ̀ nuuŋ nɛɛ si nchindaa wu Taa tɛ̀ tee. ");
INSERT INTO asj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Le ŋwaŋ wulu bo jo nyaaŋ, bɛ sɛɛ wu dzoo, bɛ choŋ wu bukooŋ le Jiso, bukooŋ buni tɛ̀ nuuŋ nɛɛ bu nchindaa wu Nyɔ-ɔ tɛ̀ tee li ni-i, mɛɛŋ se kɛmɛ fwe. ");
INSERT INTO asj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mfi se tɛ̀ kɔchɛ wu fɛrɛ muntofi le be tsootsɛ bikoo bi bee si nchi wu Mɔɔsɛ tɛ̀ wɛki. Be se dzɔ ŋwaŋ wulu be yɛɛ bɛ wu Jɛrosalɛŋ le be yiiŋgi li Taa li. ");
INSERT INTO asj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Fini nuuŋ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Bɛnchi bɛ Taa lɛ le, “Ɛ wi biɛ ŋwaŋ wu ŋkosi ɛ nuuŋ ŋwaŋ wu nyuŋ, bɛ yiiŋgi li Taa li, to wu Taa.” ");
INSERT INTO asj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Be tɛ̀ gɛɛŋ le be fɛ muntofi muni bɛ bibimu bifɛ, mɔɔ bɛ bɔɔŋ bɛ mundoŋgu mumfɛɛntu biki si fi tɛ̀ nuuŋ lɛ kiŋwaati ki bɛnchi bɛ Taa lɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Li mfi wulu-u, nyuŋ wumu tɛ̀ nuuŋ Jɛrosalɛŋ bɛ teenyi wu le Simiɔŋ. Ɛ tɛ̀ nuuŋ wi wu tsaaŋ feti si Nyɔ wɛki, tɛ̀ gii tɛŋgi wi wu gii bɛ deeni shéŋ yi bɛniiŋ bɛ Isɛlɛɛ. Fiana yi Waaŋ tɛ nuuŋ li wu-u, ");
INSERT INTO asj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Fiana yi waaŋ yilu fɛ le kɛɛ le kwe nuuŋ tɛ naa dzɔ wu mɛɛŋ ki ŋɛŋ kɛ Kinsofu ki Taa lɛ ki tɛ̀ kaachɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Fiana yi Waaŋ se dza yi fɛ Simiɔŋ gɛɛŋ li yih yi muntofi. Le Jɔsɛ bee Maariya bɛ bɛ ŋwaŋ wu Jiso li yih yi muntofi le be fɛ si nchi wɛki, ");
INSERT INTO asj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiɔŋ se fi ŋwaŋ wulu kɛmɛ bɔ, bɛchi yɔɔnchi Nyɔ, tiiti le, ");
INSERT INTO asj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Taa bɛdɛɛni, siɔ fɛ ŋkaachɛ wa bɛ wu kɔchɛ, dzɔɔ wi wa wu nimɛ dɛɛni li mbɛɛŋgii li. ");
INSERT INTO asj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lii yɛŋ ŋɛŋ yɛɛ Kinsofu ko ");
INSERT INTO asj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ki ɔ tuumi, bɛniiŋ bɛchu gi be ŋɛŋ ki. ");
INSERT INTO asj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ki nuuŋ kiŋ'wofu li bɛniiŋ bɛ nuuŋ yɛ bɛjuu kɛ-ɛ, ki gii ki doonchɛ wɛ li bee ki fɛ bɛ se tsaaki bukooŋ bu bɛniiŋ bo bɛ Isɛlɛɛ liwe.” ");
INSERT INTO asj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Le te ŋwaŋ bee ni ŋwaŋ woo biee bi Simiɔŋ tee kii ŋwaŋ wuni, wa tɛ be. ");
INSERT INTO asj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiɔŋ se tuu lɔŋ kimbɔnɛ li bee, tee li Maariya wu ni-i le, “Bichɛ ɔ ŋɛŋ, Nyɔ tsaayɛ ŋwana wuni, li ŋ'weyɛ bɛ ndzatsu wu bɛniiŋ ŋge bɛ Isɛlɛɛ. Gii ni nuuŋ doonchɛ wu fiee bɛniiŋ se ni be tiiti kii wu. ");
INSERT INTO asj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bɛdɛɛni, fini gii fi doonchɛ biee bi bɛniiŋ nyiki li shéŋ yi bee. Mfi wu biee bini bichu gii bi ni bi kɛti, shéŋ ya gii yi ni yi nuuŋ kɛɛ bɛ beeŋ baa bɛ finyɔɔ.” ");
INSERT INTO asj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gii nuuŋ li mfi wulu-u, kwɛɛŋ wumu nuuŋ lu bɛ teenyi wu le Anas, ɛ tɛ̀ nuuŋ ntomfɔŋ wu Nyɔ. Tɛ̀ nuuŋ ŋwanɛ Fanuwɛ wu wi wu kini ki Asha-a. Kwɛɛŋ wulu tɛ̀ nuuŋ ɛ wu doŋ ŋge. Tɛ̀ nuuŋ bee nyumi biya mfomɛnyaaŋ kwaa, nyumi kwi. ");
INSERT INTO asj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tɛ̀ to kwɛɛ ŋku, se ba lɛ biya gwii nyaaŋ ntsɔ binɛ-ɛ (84) shiiŋ li yih yi muntofi-i mbochu nsiŋ yɔɔnchi Nyɔ butuu bɛ fɛnshaaŋ, jiti biee, lɛki li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Le mfi wu be tɛ̀ bɛɛ bɛ ŋwaŋ wulu li yih yi muntofi, si kwɛɛŋ wulu tɛ̀ ŋɛŋ be lɛ, nyɛ kiyɔɔni li Nyɔ-ɔ, tee kii ŋwaŋ wuni li bɛniiŋ bɛchu bɛ tɛ̀ tɛŋgi mfi wu Nyɔ gii yi soo bɛniiŋ bɛ Jɛrosalɛŋ li tsaŋ yi ŋgɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mfi wu Jɔsɛ bee Maariya tɛ̀ mɛɛshi biee bichu si nchi wu Taa tɛ̀ wɛki, be kaari be to lijiŋ li kitoŋ kibee ki Nasarɛ lɛ kimbɛ ki kwɛɛŋ wu Galilii. ");
INSERT INTO asj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ŋwaŋ wulu se ko, kɛmɛ buŋga, tɛ̀ yisɛ bɛ bufii bunɔŋa, Nyɔ se tɛ̀ Kɔɔŋgi wu. ");
INSERT INTO asj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Te Jiso bee ni tɛ̀ shiiŋ be yɛki Jɛrosalɛŋ biya bichu kii Tsɔnɔ chi N'yafuwee. ");
INSERT INTO asj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Le Jiso bo biya yoofi ntsɔ bifɛ, be yɛɛ kii tsɔnɔ chilu nɛɛ si be tɛ̀ shiiŋ be yɛki. ");
INSERT INTO asj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Le be ji tsɔnɔ be mɛɛshi, be to lijiŋ, ŋwaŋ wu Jiso se shɛ lɛjiŋ Jɛrosalɛŋ. Se nuuŋ le tee bee ni tɛ mɛɛŋ ki kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Be dɛndɛ jobɛ chichu, be beechi le wɛ li kintutu ki bɛniiŋ bɛ bee be tɛ̀ deŋgi. Be se bɛchi be wɛki wu lɛ kini kibee mɔɔ lɛ nsáŋ yi bee linti, ");
INSERT INTO asj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","le be gɔɔŋ nsiŋ, be tuu be kaari be to lijiŋ Jɛrosalɛŋ le be gɔɔŋ wu. ");
INSERT INTO asj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Le gɛɛŋ bo jo taa si be tɛ̀ bɛchi be wɛki wu, be ŋɛŋ wu nuuŋ fɛ yih yi muntofi, ɛ tɛ̀ shee fe bee bɛniiŋ bɛ ntiifɛ yiki li bee, biiti bɛmbifu. ");
INSERT INTO asj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bɛniiŋ bɛchu bɛ tɛ̀ yiki tɛ̀ ta maa ŋge kifɛ tɛ̀ kii biee ŋge mɔɔ ntusu bɛmbifu bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Si ni bee te tɛ̀ ŋɛŋ wu lɛ, wa tɛ be. Ni se teeŋ wu tee le, “Ŋwanɛŋ ɔ geeŋ ɔ ŋwɛɛ bɛ bee ni? Bichɛ ɔ ŋɛŋ, tɛɛ chaa tɛ gɔɔŋ baa wɛ nsiiŋ tɛ wɛsɛ.” ");
INSERT INTO asj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Se tuu le, “Nɛ bee nɛ wɛki mi kii la? Nɛ kii yɛ le ŋkɛmi le ni nuuŋ li Taa yih fɛni kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Se nuuŋ le be ti mɛɛŋ ki kɛɛ kɛ fiee fi wu tee kɛ. ");
INSERT INTO asj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Se tuu dza bee be, be beki Nasarɛ. Gɛɛŋ wuki li bee. Si biee bini tɛ̀ kɛti ni, ni se gɛɛ biee bini bichu li shéŋ yee li. ");
INSERT INTO asj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jiso tɛ̀ kuu, kɛmi bufii ŋge, Nyɔ kɔŋgisi wu, bɛniiŋ kɔŋgisi wu tɛ. ");
INSERT INTO asj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Mfi wu Jɔɔŋ wu ŋwanɛ Sakariya tɛ̀ nuuŋ libuka, ntoŋ wu Nyɔ bɛ lɛ wuu. Kiya kɛɛ tɛ̀ nuuŋ ɛ Tibɛrius Kaisa tɛ̀ nuuŋ ŋgɔmina wu Lom li biya yoofi ntsɔ bitiinu. Pontu Pailɛt se sɛki kimbɛ ki kwɛɛŋ wu Judiya, Hɛrɔ sɛki Galilii. Fili wu ŋwaani Hɛrɔ tɛ̀ sɛki kimbɛ ki Ituliya bɛ ki Tɛlakoniti, Lisanya se sɛki Abilɛŋ. Ɛ tɛ̀ nuuŋ mfi wu Anas bee Kaifas tɛ̀ nuuŋ bikoo bi bɛte muntofi-i. ");
INSERT INTO asj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Le Jɔɔŋ woo ntoŋ wu Nyɔ wulu, dza gɛɛŋ bimbe bi tɛɛŋ lɛ bichu bi nuuŋ li Dzɔɔ yi Joodaaŋ, tuu tiifi bɛniiŋ le be fiiki shéŋ yi be, se lii be lidzɔɔ, Nyɔ se feeki bibifi bi bee. ");
INSERT INTO asj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Fini nuuŋ si Ɛsaya wu ntomfɔŋ wu Nyɔ tɛ̀ tsɛɛ lɛ Kiŋwaati kee li le, “Jɛ yi wi dii yɛɛ libuka le, bɛ nachɛ dze yi Taa, bɛ leeki yi nuuŋ tsaaŋ, ");
INSERT INTO asj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","bɛ shiiki bɛŋkumɛ bɛ nɔŋa bɛ nɔŋa mɔɔ bɛ ntɛŋ bɛ ntɛŋ bɛchu, bɛ yiiki feeŋ chichi, bɛ leeki dzé yi nuuŋ tsaaŋ, bɛ yiiki bitoo dze nuuŋ shiiŋgii, ");
INSERT INTO asj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","bɛniiŋ bɛchu se ŋɛŋ si Nyɔ ti suuti bɛniiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Si Jɔɔŋ tɛ̀ tiiti lɛ, bintutu bi bɛniiŋ lɛ tuu bi bɛɛ le lii be lidzɔɔ. Se tuu dza tee li bee le, “Kiŋgɔkɛ ki yɔ́ kini, ɛ noo wu tee beŋ le nɛ kifi shéŋ yi Nyɔ nuuŋ yi tuumi li be-eŋ? ");
INSERT INTO asj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Fɛrɛ yɛɛŋ biee bi doonchi le nɛ fiiki baa shéŋ yinɛ. Kiiŋ nɛ ni tuu nɛ bɛchi n'yɔru li yi yinɛ le Abrahaŋ nuuŋ taa wusɛŋ kɛ. Nse ntee li be-eŋ le Nyɔ nuuŋ yi fiiki ta yini yi to kini ki Abraha-aŋ! ");
INSERT INTO asj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nɛ kɛɛ le bɛ gɛɛ baa fɔɔ kituŋ li gɛɛŋ yi biti-i. Kiti kichu ki wundi yɛ muntaaŋ mu dzeeŋ kɛ, bɛ gii bɛ wa ki li gɛɛŋ yi ki-i, bɛ tɔŋ fɛtaaŋ.” ");
INSERT INTO asj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Le bintutu bi bɛniiŋ lɛ biɛɛ woo lɛ, bi bii li Jɔɔŋ li laa, “Tɛ gii tɛ ge la dɛɛni?” ");
INSERT INTO asj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Se tuu le, “Wi wu kɛmi ndú fiɛɛtu nyɛ yimi li wi wu kɛmi yɛ kɛ-ɛ, ɛ wi kɛmi biee bijɛ gatɛ bɛ wi wu kɛmi yɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bɛniiŋ bamu bɛ kundi kiŋwaati tɛ̀ bɛ lɛ wuu, le lii be lidzɔɔ, be bii li wu laa, “Wi wu ntiifɛ, tɛ gii tɛ geeŋ fisɛŋ?” ");
INSERT INTO asj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Se tuu li bee le, “Kiiŋ nɛ ni nɛ kundi kiŋwaati yɛki si nchi wɛki kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bɛniiŋ bɛ nchi bɛ be bii tɛ laa, “Fisɛŋ nuuŋ le tɛ geeŋ?” Se tuu le, “Ŋɛŋ yɛɛŋ le, kiiŋ nɛ ni nɛ chɛnisi bɛniiŋ nɛ lɔchi kwa nɛ kayi mɔɔ biee li bɛniiŋ li, li yee li kɛ. Nɛ wuki yɛŋ bujɔŋ bɛ fiee fi bɛ suundi beŋ lu.” ");
INSERT INTO asj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Si bɛniiŋ tɛ̀ nuuŋ be tɛŋgi Kinsofu ki Nyɔ tɛ̀ kaachɛ lɛ, be tɛ̀ tuu be biiti biee kii Jɔɔŋ, be tuu be beechi le semukɛ ɛ wu Kinsofu kilu. ");
INSERT INTO asj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jɔɔŋ se tuu bɛchi tiiti li bee le, “Nlisɔɔ beŋ nuuŋ li dzɔɔ kwaa, wi wu ko wu yaa mi mɛɛŋɔ bɛɛ lɛjiŋ, mɛɛŋɔ ki kɔchɛ kɛ wi wu nuuŋ guumɛ fanchɛ bikpɔ biee kɛ. Mwɛ gii naa ni lisi fiee beŋ nuuŋ bɛ tsaŋ yi Fiana yi Waaŋ mɔɔ bɛ wi. ");
INSERT INTO asj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kɛmɔɔ kintɛkɛ kee lɛ bɔ ki gii fɛɛ giiŋ lu, ke wu fɛɛ, banchɛ giiŋ yi dzeeŋ yɛɛ gɛɛ li gwɛɛ, se fweyɛ mumfɛɛ tɔŋ bɛ wi wu duti nyimu nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ɛ lɛ si Jɔɔŋ tɛ̀ tiifi ntoŋ wu dzeeŋ wu Nyɔ li bɛniiŋ li lɛ, nyɛɛ mɔɔ bɛntiifɛ bɛ dzeeŋ ŋge li bee. ");
INSERT INTO asj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Se nuuŋ le, tɛ̀ yɔ li Hɛrɔ wu wi wu nsawu kasi yi, kifɛ Hɛrɔ tɛ̀ dzɔ Hɛroja wu kwɛɛ ŋwaani li kwɛsi-i, se tuu yɔ mɔɔ kii biee bibifi bichu bi Hɛrɔ tɛ̀ betini. ");
INSERT INTO asj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛrɔ tɛ̀ fɛ biee bibifi bi yaŋ ŋge se mɛɛshi biifi kiŋge kee tee le bɛ kɔɔ Jɔɔŋ bɛ fa li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mfi wu Jɔɔŋ tɛ̀ mɛɛŋ lisi bɛniiŋ li dzɔɔ, le lii jobɛ chimu mɛɛshi, Jiso se bɛ tɛ Jɔɔŋ lii wu li dzɔɔ. Le Jiso bɛchi ni lɛki li Nyɔ-ɔ, kiboo gwiyɛ, ");
INSERT INTO asj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Fiana yi Waaŋ shee yi bɛ li wuu bwiŋ yi nuuŋ si kibimɛ. Jɛ se yɔ liboo le, “Wuni ɛ Ŋwanɛŋ, nuuŋ shéŋ yɛŋ, nɛ wuki yɛɛŋ li wuu.” ");
INSERT INTO asj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jiso tɛ̀ nuuŋ si biya mbaanshɛɛ li mfi wu tɛ̀ bɛchi nimɛ chee. Bɛniiŋ tɛ̀ beechi le ti nuuŋ ŋwanɛ Jɔsɛ wu ŋwanɛ Hɛli. ");
INSERT INTO asj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hɛli tɛ̀ nuuŋ ŋwanɛ Maata, wu ŋwanɛ Lebi, wu tɛ̀ nuuŋ ŋwanɛ Mɛki wu ŋwanɛ Jana, wu tɛ̀ nuuŋ ŋwanɛ Jɔsɛ. ");
INSERT INTO asj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jɔsɛ wuni tɛ̀ nuuŋ ŋwanɛ Matasha, wu ŋwanɛ Emɔ, wu tɛ̀ nuuŋ ŋwanɛ Nahuŋ, wu ŋwanɛ Ɛsili, wu tɛ̀ nuuŋ ŋwanɛ Naga. ");
INSERT INTO asj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naga tɛ̀ nuuŋ ŋwanɛ Maat wu ŋwanɛ Matasha, wu tɛ̀ nuuŋ ŋwanɛ Semɛŋ, wu ŋwanɛ Jɔsɛ, wu tɛ̀ nuuŋ ŋwanɛ Joda. ");
INSERT INTO asj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda tɛ̀ nuuŋ ŋwanɛ Joanaŋ, wu ŋwanɛ Lesa, wu tɛ̀ nuuŋ ŋwanɛ Sɛlubabɛ, wu ŋwanɛ Shitiya, wu tɛ̀ nuuŋ ŋwanɛ Nɛli. ");
INSERT INTO asj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛli tɛ̀ nuuŋ ŋwanɛ Mɛki wu ŋwanɛ Adi, wu tɛ̀ nuuŋ ŋwanɛ Kosam, wu ŋwanɛ Ɛmadam, wu tɛ̀ nuuŋ ŋwanɛ Ɛl. ");
INSERT INTO asj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛl tɛ̀ nuuŋ ŋwanɛ Joshwa wu ŋwanɛ Ɛliesa, wu tɛ̀ nuuŋ ŋwanɛ Joleŋ wu ŋwanɛ Maata wu tɛ̀ nuuŋ ŋwanɛ Lebi. ");
INSERT INTO asj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi tɛ̀ nuuŋ ŋwanɛ Simiɔŋ wu ŋwanɛ Judas, wu tɛ̀ nuuŋ ŋwanɛ Jɔsɛ, wu ŋwanɛ Jonam, wu tɛ̀ nuuŋ ŋwanɛ Ɛliakiŋ. ");
INSERT INTO asj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliakiŋ tɛ̀ nuuŋ ŋwanɛ Mɛlia wu ŋwanɛ Mena, wu tɛ̀ nuuŋ ŋwanɛ Matata wu ŋwanɛ Nataŋ, wu tɛ̀ nuuŋ ŋwanɛ Daafi. ");
INSERT INTO asj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daafi tɛ̀ nuuŋ ŋwanɛ Jɛɛsi, wu ŋwanɛ Obɛd, wu tɛ̀ nuuŋ ŋwanɛ Bwas, wu ŋwanɛ Sala wu tɛ̀ nuuŋ ŋwanɛ Nashɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashɔŋ tɛ̀ nuuŋ ŋwanɛ Aminada, wu ŋwanɛ Amina, wu tɛ̀ nuuŋ ŋwanɛ Alni, wu ŋwanɛ Hɛsrɔŋ, wu tɛ̀ nuuŋ ŋwanɛ Pɛrɛs wu ŋwanɛ Judas. ");
INSERT INTO asj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judas tɛ̀ nuuŋ ŋwanɛ Yakɔ wu ŋwanɛ Adzi, wu tɛ̀ nuuŋ ŋwanɛ Abrahaŋ, wu ŋwanɛ Tera, wu tɛ̀ nuuŋ ŋwanɛ Naho. ");
INSERT INTO asj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho tɛ̀ nuuŋ ŋwanɛ Sɛruk wu ŋwanɛ Leu, wu tɛ̀ nuuŋ ŋwanɛ Pɛlɛg wu ŋwanɛ Ɛbɛ, wu tɛ̀ nuuŋ ŋwanɛ Shɛla. ");
INSERT INTO asj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shɛla tɛ̀ nuuŋ ŋwanɛ Keenaŋ wu ŋwanɛ Alfasa, wu tɛ̀ nuuŋ ŋwanɛ Shɛŋ wu ŋwanɛ Noaa, wu tɛ̀ nuuŋ ŋwanɛ Lamek. ");
INSERT INTO asj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek tɛ̀ nuuŋ ŋwanɛ Metusɛla wu ŋwanɛ Ɛnɔ, wu tɛ̀ nuuŋ ŋwanɛ Jalɛd wu ŋwanɛ Mahalalɛ, wu tɛ̀ nuuŋ ŋwanɛ Keenaŋ. ");
INSERT INTO asj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenaŋ wuni tɛ̀ nuuŋ ŋwanɛ Ɛnɔs wu ŋwanɛ Sɛt wu tɛ̀ nuuŋ ŋwanɛ Adaŋ, Adaŋ nuuŋ ŋwanɛ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jiso tɛ̀ dza fɛ Dzɔɔ yi Joodaaŋ, ɛ wu yisɛ bɛ Fiana yi Waaŋ. Yi dzɔ wu gɛɛŋ tsiiŋ libuka. ");
INSERT INTO asj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tɛ̀ tsi le jo mbaanyɛɛ, Kiŋkundi mɔnchi wu. Tɛ̀ nuuŋ lɛ njɛ fiee nsiŋ. Le jo yɛɛ ka, dzeeŋ se bɛchi yi wuu wu. ");
INSERT INTO asj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kiŋkundi kilu se dza ki tee li wuu le, “Ɔɔ nuuŋ Ŋwanɛ Nyɔ, ɔ tee le tɛtɛ chini to bijɛ.” ");
INSERT INTO asj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jiso tuu li ki-i le, “Bɛ tsɛɛ baa le, ‘Wi ti tsiiŋ yɛ kii bijɛ kwaa kɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kiŋkundi kilu dzɔ wu ki yɛɛ bɛ wu fɛ kintsii kimu-u fɛwe, ki doonchɛ wu bitoŋ bi li kikoo ki nshɛ-ɛ bichu. Jiso ŋɛŋ bi ni ŋwaaŋŋ. ");
INSERT INTO asj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kiŋkundi kilu se tee li wuu le, “Bɛ nyɛ baa kikoo ki nshɛ-ɛ kini li mi-i kichu, nnuuŋ nɛɛ nnyɛ li wi wu ŋkɔŋgisi-i. Ŋgii nnyɛ li wɛɛ ɔ ni ɔ sɛki, ɔ ni ɔ kɛmi bunɔŋa bɛ buŋga bintsii bichu. ");
INSERT INTO asj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fi fiɛɛ kwaa le ɔ guuŋ mi, nse nyɛ biee bichu li wɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jiso tuu li kii le, “Bɛ tsɛɛ baa le, ‘Ɔ guundi Taa wu Nyɔ-ɔ ya, ɔ ni nindi nuuŋ li yi-i kwaa.’” ");
INSERT INTO asj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kiŋkundi kilu se dzɔ wu ki gɛɛŋ bɛ wu li kitoŋ ki Jɛrosalɛŋ ki leeki wu fɛ kigɔ ki yih yi muntofi-i, ki tee li wuu le, “Ɔɔ nuuŋ Ŋwanɛ Nyɔ, ɔ jiiŋ lɛkwiiŋ, ");
INSERT INTO asj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kifɛ bɛ tsɛɛ baa le, ‘Nyɔ gii yi tee li bɛnchindaa bee li le be bichɛ lɛ wɛ-ɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Fi tuu fi nuuŋ ɛ bɛ tɛ̀ tsɛɛ le, ‘Be gii be ka wɛ bɔ bɔ, kii ɔ ni ju bikaa bio li tɛtɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jiso tuu li ki-i le, “Kiŋwaati ki Nyɔ-ɔ tiiti kɛɛ tɛ le, ‘Kiiŋ ɔ ni mɔnchɛ Taa wu Nyɔ ya kɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Le kiŋkundi kilu mɛɛshi dzé chichi yi ki tɛ nuuŋ le ki mɔnchɛ Jiso le, ki se dza ki gɛɛŋ ki tɛŋgi mfi wumu. ");
INSERT INTO asj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jiso tɛ̀ dza to lijiŋ Galilii, ɛ tɛ̀ yisɛ bɛ buŋga bu Fiana yi Waaŋ lɛ. Ntoŋ wu kii wu se saaŋgɛ gɛɛŋ bimbɛ bi tɛɛŋ lɛ bichu. ");
INSERT INTO asj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tɛ̀ tiifi bɛniiŋ li yíh yi lɛkɛ li Nyɔ-ɔ, bɛniiŋ bɛchu se piɛti wu. ");
INSERT INTO asj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jiso tɛ̀ dza gɛɛŋ li kitoŋ ki Nasarɛ-ɛ fɛ tɛ̀ ko. Le ni nuuŋ jobɛ chi bɛshiinshi, se dza gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ nɛɛ si tɛ̀ shiiŋ giiŋgi. Tɛ̀ dza leŋ we le teeŋ Kiŋwaati ki Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bɛ tɛ̀ nyɛ wu kiŋwaati ki Ɛsaya-a ntomfɔŋ wu Nyɔ tɛ̀ tsɛɛ. Le ni teenyi, ŋɛŋ kintsii kimu ki bɛ tsɛɛ fe le, ");
INSERT INTO asj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Fiana yi Taa Nyɔ yɛɛ li yi yɛ-ɛŋ, kifɛ yi be yi tsaa mi kituŋ le mbɛ nlaŋɛ ntoŋ wu dzeeŋ li bɛniiŋ bɛ kifoo lɛ. Yi tɛ̀ toŋ tɛ mi le mbɛ ntee li bɛniiŋ bɛ nuuŋ li ncha-a le, bɛ gii bɛ buu be, nse ntee li binyɛɛ li le bi gii bi ŋɛŋ biee. Yi tɛ̀ toŋ tɛ mi le mbɛ mbuu bɛniiŋ bɛ bɛ ŋ'wɛki bɛ be li ncha-a, ");
INSERT INTO asj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nse ntee kiya ki Taa Nyɔ gii fi bɛniiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Le Jiso teeŋ ki ni, baaŋ kiŋwaati kilu nyɛ li wi wu tɛ shiiŋ kiichi ki-i gɛɛŋ shee fɛkwiiŋ. Bɛniiŋ bɛchu bɛ tɛ̀ nuuŋ li yih yi nlɛkɛ li Nyɔ-ɔ yilu-u, toŋ lii li wuu. ");
INSERT INTO asj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Se bɛchi naanyi li bee le, “Fiee fi nɛ woo lɛ Kiŋwaati ki Nyɔ-ɔ fini bɛ fiɛɛ fi kɔchɛ bɛŋ.” ");
INSERT INTO asj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bɛniiŋ yikɛ jɛ yilu yi dzɔɔŋ fɛ bee ŋge, be se kɛmɛ chɛnɛ li n'yɔru wu dzeeŋ wu buti lɛ wuu wa. Se nuuŋ le, be tɛ̀ ya wa, be biiti laa, “Wuni nuuŋ nɛɛ ŋwanɛ Jɔsɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jiso se tee li bee le, “Ɛ fiee fi mɛŋinɛ kɛ, le nɛ gii nɛ wa ŋgaŋgaa chini li mi-i le, ‘Wi wu wɔnchi bɛniiŋ, wɔnchɛ yi ya.’ Fiee fi tɛ tɛ̀ woo le ɔ fɛɔ Kapanuŋ, fɛrɛ fi fɛni li kwɛɛŋ waa tɛ.” ");
INSERT INTO asj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jiso tuu tee li bee le, “Ntee li be-eŋ chɛɛŋ le, bɛ ti naa guundi yɛ ntomfɔŋ wu Nyɔ li kwɛɛŋ wee li kɛ. ");
INSERT INTO asj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bɛ chɛɛŋ, ntee li be-eŋ le tɛ̀ nuuŋ li mfi wu ntomfɔŋ wu Nyɔ wu Ɛlaja-a dzaaŋ tɛ̀ ba liwe li biya bitɛɛtu bɛ kii busɔɔ, dzeeŋ kɔɔ kwɛɛŋ kwi. Bukɛɛŋ bɛɛŋku-u tɛ̀ nuuŋ li kwɛɛŋ wu Isɛlɛɛ li mfi wulu ŋge. ");
INSERT INTO asj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nyɔ tɛ̀ mɛɛŋ ki toŋ kɛ Ɛlaja lɛ bee kɛ, yi tɛ̀ toŋ wu nuuŋ lɛ kwɛɛ ŋku wu tɛ̀ nuuŋ Sarefa-a kwaa, li kwɛɛŋ wu Sidɔ-ɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nɛ kɛɛ tɛ le, tɛ̀ nuuŋ li mfi wu ntomfɔŋ wu Nyɔ wu Ɛlisha-a, bɛniiŋ tɛ̀ nuuŋ Isɛlɛɛ ŋge bɛ tɛ̀ kɛmi chigɔŋ chi nɔŋa, bɛ se tɛ̀ mɛɛŋ wumu li bee linti ki wɔnchɛ kɛ. Ɛ Naama kwaa li kwɛɛŋ wu Siliya wu bɛ tɛ̀ wɔnchɛ, woo.” ");
INSERT INTO asj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Le Jiso tee lɛ, bɛniiŋ bɛchu bɛ tɛ̀ nuuŋ li yih yi nlɛkɛ li Nyɔ-ɔ woo, shéŋ tɔŋ be ŋge. ");
INSERT INTO asj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Be se dza we, be chiiŋ wu, be bo bɛ wu li kwɛɛŋ wulu-u, be miri bɛ wu fɛ ŋkumɛ fɛfwa wu tɛ̀ nuuŋ li kitoŋ ki bee, be tɛ̀ wɛki le be lɔŋ wu le we lɛ ba bɛ kikoo. ");
INSERT INTO asj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Se nuuŋ le, tɛ̀ ka be kintikinti gɛɛŋ fiee. ");
INSERT INTO asj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jiso tɛ̀ dza bɔɔ Kapanuŋ, kitoŋ kimu ki Galilii. Le ni nuuŋ jobɛ chi bɛshiinshi, gɛɛŋ tiifi bɛniiŋ li yih yi nlɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bɛniiŋ bɛchu bɛ tɛ̀ yiki tɛ̀ kɛmɛ chɛnɛ li ntiifɛ we-e, kifɛ ntiifɛ we tɛ̀ kɛmi buŋga. ");
INSERT INTO asj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wumu tɛ̀ nuuŋ li yih yi nlɛkɛ li Nyɔ-ɔ yilu-u, ɛ Fiana yi tii tɛ̀ nuuŋ li wuu bwiŋ. Tɛ̀ dza dzɛŋgi lɛwe ŋge le, ");
INSERT INTO asj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hebee Jiso wu Nasarɛ, ɔ wɛki la li bee li? Ɔ bɛ le ɔ lɛɛ bee ni? Ŋkiiɔ wi wu nuuŋ wɛ. Ɔ nuuŋ wi wu waaŋ wu buti fɛ Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jiso waŋ Fiana yi tii yilu, tee le, “Makɛ, bochɛ li wi wuni.” Le yi tsaaki wi wulu yi toŋ wu fɛkwiiŋ lɛ bɛniiŋ lii, yi bo li wuu bwiŋ, se nuuŋ le, yi ti mɛɛŋ ki kpɔɔshɛ kɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bɛniiŋ bɛchu ŋɛŋ, bimfimu wondɛ be, be ta maa, be biiti laa, “Wuni n'yɔru nuuŋ wu niŋ wu wi wuni yɔ le? Kɛmɔɔ buŋga bu nɔŋa bu wanɛ Fiana yi tii yi buti li bɛniiŋ li.” ");
INSERT INTO asj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ntoŋ wu kii Jiso dɛndɛ li bitoŋ bichu bi lɛ kimbɛ ki le-e. ");
INSERT INTO asj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jiso dza bo li yih yi nlɛkɛ li Nyɔ-ɔ yilu-u, gɛɛŋ lɛ li Simu yi. Tɛ̀ nuuŋ ɛ mwɛsɛ Simu tɛ̀ gendi bɛ kiŋkɛŋkɛ. Be se lɛkɛ le Jiso fi wu. ");
INSERT INTO asj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jiso gɛɛŋ fɛ tɛ̀ gimi, leŋ lɛ wuu lɛwe, waŋ kiŋkɛŋkɛ kilu. Ki se chinɛ li wuu tɛmi. Mfwaa mumkpaŋ, kwɛɛŋ wulu dza we, bichɛ fiee fijɛ nyɛ be. ");
INSERT INTO asj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Le jobɛ ni chi sechi, bɛniiŋ bɛ tɛ̀ kɛmi bɛniiŋ bɛ gendi bɛ chigɔŋ chichi chichi be dzeti be bɛɛ bɛ be fɛ Jiso-o. Se kundi li bee bɛchu-u, be tɛɛmi. ");
INSERT INTO asj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bɛnchindaa bɛ kiŋkundi-i baa tɛ̀ buti li bɛniiŋ bamu ŋge be dzɛŋgi le, “Ɛ wɛ Ŋwanɛ Nyɔ.” Se nuuŋ le Jiso waŋ le kiiŋ nɛ ni nɛ yeti kɛ, kifɛ be tɛ̀ kii le ɛ wu Kinsofu ki Nyɔ tɛ̀ kaachɛ. ");
INSERT INTO asj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Le butuu woo, Jiso bo gɛɛŋ fɛ kintsii kimu wuu mbiiŋ. Bɛniiŋ shɛ be bɛchi be wɛki wu. Le be ŋɛŋ wu, ɛ tɛ̀ wɛki le dza li kitoŋ kilu-u. Be tɛ̀ wɛki dzé le ba bɛ be. ");
INSERT INTO asj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Se nuuŋ le tɛ̀ faaŋ tee li bee le, “Ŋkɛmi le ntifi ntoŋ wu dzeeŋ wu kii bumfɔŋ bu Nyɔ-ɔ li bitoŋ bimu-u tɛ, kifɛ ɛ fiee fi Nyɔ toŋ mi le mbɛ mfɛ.” ");
INSERT INTO asj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tuu dza gɛɛŋ deŋgi fenjisi ntoŋ wu dzeeŋ wulu li yíh yi kintaashɛ li kwɛɛŋ wu Judiya-a kwikwi. ");
INSERT INTO asj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Le ni nuuŋ jobɛ chimu, Jiso lemi li libɛ chi Jɛnɛsarɛ-ɛ lichiŋ, ɛ bɛniiŋ tɛ̀ kɛnɛ be fachɛ wu be yiki jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Se dza ŋɛŋ bɛŋgo bɛfɛ li ŋgemɛ yi dzɔɔ li, ɛ bɛniiŋ bɛ tɛ̀ kɛmi be tɛ̀ bochɛ le be tsootsi gii yibe yi nsúuŋ. ");
INSERT INTO asj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gɛɛŋ lɛ lɛ ŋgo wumu-u, ɛ tɛ̀ nuuŋ wu Simu, tee le kiiŋgi wu gɛɛŋ li dzɔɔ niiŋ. Le kiiŋgi, Jiso se lɛ shee le, bɛniiŋ nuuŋ lɛ buka tiifi be. ");
INSERT INTO asj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Le tifi mɛɛshi, tee li Simu le, “Konɛ ŋgo wu gɛɛŋ fɛ kindundu, nɛ lɔŋ gii yinɛ, nɛ kɔɔ nsúuŋ.” ");
INSERT INTO asj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simu tuu le, “Te Kikoo tɛ tsi baa we tɛ lendi gii nsiiŋ bu woo, tɛ mɛɛŋ ki kɔɔ kɛ fiee kɛ. Se nuuŋ le, si ɔ tee lɛ, ŋgii nlɔŋ nɛɛ.” ");
INSERT INTO asj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Be gɛɛŋ be lɔŋ, be kɔɔ nsúuŋ ŋgee, le be ni be busi gii yibe, yi leki le yi soomɛ. ");
INSERT INTO asj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bɛdɛɛni, be kwafi bɛniiŋ bɛ bee bɛ kintutu bɛ lɛ ŋgo wumu wɛɛ le be bɛ be fi be. Be bɛ be buu nsúuŋ yilu, yi yisɛ lɛ bɛŋgo bɛ bee, be leki le be shee li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Le Simu Pita ŋɛŋ fiee fi ka, gɛɛŋ toŋ núŋ Jiso limfwe tee le, “Mintemii Taa, dzatsɛ fio fɛni ɔ shɛ mi, nuuŋ fieŋ wi wu bifi.” ");
INSERT INTO asj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tɛ kweŋgi lɛ, kifɛ wu bee bɛniiŋ bee bɛ kintutu tɛ̀ ŋɛŋ nsúuŋ yi be tɛ̀ kɔɔ, yi bɛŋ be. ");
INSERT INTO asj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yi bɛŋ tɛ Jeeŋ bee Jɔɔŋ bɔɔŋ bɛ Dzɛbɛdii bɛ tɛ̀ nuuŋ lɛ kintutu ki Simu-u. Jiso tee li Simu-u le, “Kiiŋ ɔ ni ɔ chɛndi kɛ. Mbɛɛchɛ li dɛɛni ŋgɛnu limfwe, ɔ gii ɔ ni ɔ keeti nuuŋ bɛniiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Le be woo lɛ, be buushɛ bɛŋgo bɛ bee lɛ buka, be chinɛ biee bichu fe be dza be biki Jiso. ");
INSERT INTO asj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Le ni nuuŋ mfi wumu, Jiso nuuŋ li kitoŋ kimu-u, wumu tɛ̀ nuuŋ fe bɛ chigɔŋ chi nɔŋa. Le wi wulu ŋɛŋ Jiso, bɛ we wu lii, lɛkɛ wu tee le, “Taa, fɛrɛ mi ntɛmi, ɔɔ kɔŋgisɔɔ.” ");
INSERT INTO asj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jiso se nɛɛki kibɛnɛ koŋ li wuu tee le, “Ŋkɔŋgisɔɔ, tɛmi ɔ ni ɔ wuuti.” Mfwaa mumkpaŋ, chigɔŋ chi nɔŋa chilu biee chi chinɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jiso chiinsɛ li wuu le, “Ɔ kiiŋ ɔ ni tee li wi-i kɛ. Se nuuŋ le, gɛnɛ ɔ doonchɛ yi ya li Te muntofi, ɔ se nyɛ nya yi Mɔɔsɛ tɛ̀ tiiti le wi kɛmi le nyɛ le doonchɛ li bɛniiŋ li le wu tɛmɔɔ li chigɔŋ chini-i wu woo.” ");
INSERT INTO asj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Si Jiso tɛ̀ chinsɛ li wi wulu lɛ, ntoŋ wu kii Jiso se tuu saaŋgɛ gɛɛŋ limfwe ŋge, bintutu bi bɛniiŋ lɛ ŋge banchi bi bɛɛ le bini bi yiki ntifi yee, mɔɔ le ni wɔnchi chigɔŋ chi bee. ");
INSERT INTO asj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Se nuuŋ le, Jiso tɛ̀ dzɛti shiiŋ be giiŋgi lɛki li Nyɔ-ɔ li buka. ");
INSERT INTO asj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tɛ̀ nuuŋ jobɛ chimu Jiso tiifi bɛniiŋ, ɛ buŋga bu Taa lɛ tɛ̀ nuuŋ wu li bwiŋ le ni wɔnchi chigɔŋ lu. Bɛfarasii mɔɔ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ tɛ̀ shee fe, ɛ be tɛ̀ bo li bitoŋ bichu-u bi Galilii mɔɔ bimbe bi Judiya bɛ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Fi se ka le bɛniiŋ bamu tɛ̀ dza be bɛɛ ɛ be tɛ̀ sumɛ wi fɛ kida-aŋ fɛwe, ɛ ŋgwɛ tɛ̀ kɔɔ wu. Be tɛ̀ gii be gwenini le be lɛ bɛ wu be giiki wu Jiso limfwe. ");
INSERT INTO asj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Se nuuŋ le, be tɛ̀ mɛɛŋ ki kɛmɛ kɛ dze kɛ, kifɛ bɛniiŋ tɛ̀ yiŋgɛ fe ŋge. Be se beeŋ bɛ wu nuuŋ lɛ yi-ih lɛwe be tɔtɛ kiyɛ, be shiiki wi wulu kintikinti ki bɛniiŋ lɛ Jiso limfwe, fɛ kidaŋ ki tɛ̀ gimi fe kɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Si tɛ̀ ŋɛŋ le bɛniiŋ bɛlu gɛɛ baa shéŋ yi be li wuu lɛ, biee tee li wi wulu le, “Sinɛŋ, mi mfeekɔɔ bibifi bio kituŋ.” ");
INSERT INTO asj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ bɛ kintutu ki Bɛfarasii lɛ kɛɛ, be tuu be bɛchi be ŋuŋini be tiiti le, “Wi wuni nuuŋ noo wu dzɔ kintsii ki Nyɔ-ɔ? Ɛ noo wu nuuŋ feeki bibifi fuki Nyɔ nsiŋ?” ");
INSERT INTO asj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jiso kɛɛ fiee fi be ŋuŋini, bii li bee laa, “Nɛ kɛmi ŋwaani wuni mbeechɛ li shéŋ yinɛ ni kii la? ");
INSERT INTO asj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Fi tsɛkɛ nuuŋ fi la, ntefu le mi mfeekɔɔ bibifi bi wi wuni, mɔɔ le dza we ni deŋgi le? ");
INSERT INTO asj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Se nuuŋ le, ŋgii ndoonchɛ beŋ le Ŋwanɛwi kɛmi buŋga laaŋkwiiŋ bu fekisɛ bibifi.” Se tuu tee li wi wu ŋgwɛ tɛ̀ kɔɔ wɛɛ le, “Mi nteeɔ li wɛ-ɛ, dza we, ɔ dzɔɔ kidaŋ ko ɔ ni ɔ kuuki fɛkuuŋ.” ");
INSERT INTO asj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mfwaa mumkpaŋ, se biee dza we leŋ lɛ bɛniiŋ lii, dzɔ kidaŋ ki tɛ̀ gimi fe kɛɛ kuuki fɛ wuu kuuŋ, yɔɔnchi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Le bɛniiŋ ŋɛŋ lɛ, wa tɛ be, be kɛmɛ chɛnɛ, be guumɛ be lɛki li Nyɔ-ɔ be tiiti le, “Tɛ ŋɛŋ baa fiee fi tɛɛmi bɛŋ.” ");
INSERT INTO asj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jiso tɛ̀ dza bo fe deŋgi. Si tɛ̀ giiŋgi lɛ, ŋɛŋ wumu wu tɛ̀ kundi kiŋwaati bɛ teenyi wu le Lebi, ɛ tɛ̀ shee fɛ yih yi kiŋwaati ki sofɛ-ɛ. Jiso tee li wuu le, “Ɔ biki mi.” ");
INSERT INTO asj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lebi chinɛ biee bichu, se dza biki Jiso. ");
INSERT INTO asj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Se nuuŋ le, Lebi tɛ̀ dza fɛ tsɔnɔ chi nɔŋa li wuu yih le nɛɛtɛ bɛ Jiso. Bɛniiŋ bɛ tɛ̀ kundi kiŋwaati nɛki tɛ̀ fe mɔɔ bɛniiŋ bamu bɛ bee be tɛ̀ jii biee. ");
INSERT INTO asj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bɛfarasii mɔɔ bɛniiŋ bɛ bee bɛ tiifi bɛnchi bɛ Nyɔ-ɔ bɛchi be ŋuŋini, be biiti li bɔɔŋ bɛ kintutu-u bɛ Jiso-o laa, “Fi geeŋ fi nɛ jii biee, nɛ wundi biee bɛ bɛniiŋ bɛ kundi kiŋwaati mɔɔ bɛ bifi bɛmu le?” ");
INSERT INTO asj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jiso tuu li bee le, “Bɛniiŋ bɛ tɛɛmi ti wɛki yɛ mfindɛ kɛ. Ɛ bɛniiŋ bɛ gendi bɛ ti wɛki. ");
INSERT INTO asj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mɛɛŋɔ ki mbɛ kɛ le nteeŋ bɛniiŋ bɛ nuuŋ tsaaŋ kɛ. Mi mbɛɛɔ nuuŋ le nteeŋ bɛniiŋ bɛ bifi le be fiiki shéŋ yi be.” ");
INSERT INTO asj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Be dza be tee li Jiso-o le, “Bɔɔŋ bɛ kintutu-u bɛ Jɔɔŋ lɛ tɛ̀ shiiŋ be jiti biee be lɛki li Nyɔ-ɔ mfi kwi, fi nuuŋ si Bɛfarasii ti feti, bɛdɛɛni bɔɔŋ bo se jii baa biee be wundi biee.” ");
INSERT INTO asj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jiso tuu li bee le, “Bɛ nuuŋ bɛ teeŋ bɛniiŋ fɛ tsɔnɔ chi bugoo lɛ ke be gɛɛŋ, nɛ fɛ le be ni be jiti biee bijɛ fɛ nyuŋwutso nuuŋ bee be ni? Nuuŋ fi tɛ̀ nuuŋ lɛ kɛ! ");
INSERT INTO asj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Fi fiɛɛ le, mfi gii bɛ wu bɛ gii bɛ lɔ nyuŋwutso li bee, be se tuu be bɛchi njiru biee bijɛ.” ");
INSERT INTO asj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Se tuu wa ŋgaŋgaa chini li bee le, “Se nuuŋ le, wi nuuŋ yɛ lu wu nuuŋ naa gaamɛ ndu yi fiɛŋ tuushɛ yi fichi lu kɛ. Ɛ wi wu fɛ lɛ, kɛ wu biifɔɔ ndu yi fiɛŋ yilu. Fi nuuŋ le ndu yi fiɛŋ nuuŋ tɛ gɛɛŋ tsaaŋ bɛ finshɛŋgɛ fi fichi kɛ. ");
INSERT INTO asj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nɛɛ lɛ le nuuŋ wi tɛ dzɔ mbiiŋ mɛ fɛŋ, le gɛɛ lɛ kibɛɛŋ ki mbiiŋ mɛ fichi-i kɛ, ɛ wu fɛ lɛ kɛ mbiiŋ mɛ fɛŋ mɛlu gii mɛ wo kibɛɛŋ ki fichi kɛɛ, mbiiŋ mɛlu shooshɛ. ");
INSERT INTO asj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chɛɛŋ wulu nuuŋ le, bɛ kɛmi le bɛ gɛɛ mbiiŋ mɛ fɛŋ nɛɛ nuuŋ lɛ kibɛɛŋ ki fɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɛ kii tɛ le wi ti nuuŋ yɛ lu wu wundi mbiiŋ mɛ be, fɛ wu woŋ mɛ yiki kɛ. Wi ti bɛɛ piɛti nuuŋ mɛ be.” ");
INSERT INTO asj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tɛ̀ nuuŋ jobɛ chi bɛshiinshi chimu, Jiso bee bɔɔŋ bee bɛ kintutu-u dza be deŋgi be kɛti li wɛ wu giiŋ wumu-u. Bɔɔŋ bee bɛ kintutu-u bɛchi be soomi bikoo bi giiŋ lɛ be jii. ");
INSERT INTO asj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bɛfarasii bamu ŋɛŋ lɛ, be bii laa, “Ɛ la fi nɛ feti biee bi nchi mɛɛŋ ki beŋ kɛ, le wi ni feti jo yi bɛshiinshi kɛ?” ");
INSERT INTO asj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jiso tuu bii li bee laa, “Fi nuuŋ le nɛ mɛɛŋ baa ki teeŋ kɛ lɛ Kiŋwaati ki Nyɔ-ɔ si dzeeŋ tɛ̀ wo Mfɔŋ Daafi bee kintutu kee fɛ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Si tɛ̀ lɛ li yih yi Nyɔ-ɔ dzɔ kibele ki bɛ tɛ̀ tsaa bɛ gɛɛ le ɛ ki Nyɔ-ɔ, ji nyɛ mɔɔ kintutu kee fe tɛ, ɛ tɛ̀ nuuŋ nchi, fɛ wi nuuŋ ji kibele kilu fuki bɛte muntofi nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jiso se mɛɛshi tee li bee le, “Ŋwanɛwi nuuŋ Te Kikoo wu jobɛ chi bɛshiinshi.” ");
INSERT INTO asj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Le ni tuu nuuŋ jobɛ chi bɛshiinshi chimu, Jiso gɛɛŋ lɛ li yih yi nlɛkɛ li Nyɔ-ɔ yi Nyɔ yimi tiifi bɛniiŋ. Wumu tɛ̀ nuuŋ lu ɛ ŋgwɛ kɔɔ wu li kibɛnɛ kee ki kigɔŋɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ mɔɔ Bɛfarasii gii be wɛki fiee fi be gii be kayɛ li Jiso-o. Be tuu be toŋ lii li wuu, be bichi laa gii wɔnchɛ wi jobɛ chi bɛshiinshi le. ");
INSERT INTO asj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jiso kɛɛ fiee fi be tɛ̀ beechi, tee li wi wu ŋgwɛ tɛ̀ kɔɔ wu wɛ-ɛ le, “Dza we, ɔ bɛ ɔ leŋ fɛni.” Se dza leŋ we. ");
INSERT INTO asj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jiso tee li bee le, “Mbiitɔɔ li beŋ laa, fiee fi nchi beŋ le wi fɛ jobɛ chi bɛshiinshi nuuŋ fi la? Le ɔ fɛ fiee fi dzeeŋ mɔɔ, fi biifi le, le ɔ yiimi wi mɔɔ, le ɔ lɛɛ wi le?” ");
INSERT INTO asj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bichɛ be li lii bɛchu kɛnɛ, se tee li wi wɛɛ le, “Nɛɛmi kibɛnɛ ko.” Mwɛ nɛɛmi, ki biee ki tɛmi. ");
INSERT INTO asj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Se nuuŋ le, fi tɛ̀ gbɛɛŋ fi tuu fi tɔŋ be shéŋ, be bɛchi be chuti ntaŋ si be gii be fɛ bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Li jo yilu, Jiso se dza yɛɛ li ŋkumɛ le gɛɛŋ lɛkɛ li Nyɔ-ɔ, tsi we lɛki li Nyɔ-ɔ nsiiŋ butuu woo. ");
INSERT INTO asj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Le butuu woo, se teeŋ bɛniiŋ bee bɛ tɛ̀ biki wu, be bɛ. Se tsaa bamu yoofi ntsɔ bɛfɛ teeŋ be le bɔɔŋ bee bɛ nto-oŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bɛniiŋ bɛ tɛ̀ tsaa bɛlu tɛ nuuŋ: Simu, wu tɛ̀ nyɛ bukooŋ bwee bumu le Pita, bɛ Andolo wu ŋwaani Simu. Bamu se nuuŋ Jeeŋ, Jɔɔŋ, Fili, Batolomu, ");
INSERT INTO asj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maacho, Tomɛ mɔɔ Jeeŋ ŋwanɛ Afiyus, Simu wu tɛ̀ nuuŋ wi kintutu ki Bɛsilɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas wu ŋwanɛ Jeeŋ mɔɔ Judas Iskaliyɔ wu tɛ̀ kabɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Le tsaa be lɛ, be bɛchu se dza be beki, le be bɔɔ, be leŋ li kinɛɛŋ li, bɔɔŋ bee bɛ kintutu-u tɛ̀ nuuŋ fe ŋge, mɔɔ kiyaŋ ki bɛniiŋ lɛ tɛ̀ turi fe ki tɛ̀ dzɛti Judiya bɛ Jɛrosalɛŋ bamu tɛ bo li dzɔɔ yi Tayɛ-ɛ bɛ yi Sidɔ-ɔŋ lichiŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Be tɛ̀ bɛ le be yikɛ ntiifɛ wu Jiso, le wɔnchɛ mɔɔ chigɔŋ chi bee. Bɛniiŋ bɛ Fiana yi tii tɛ̀ fieŋgisi be tɛ̀ bɛɛ tɛ busi fiana yilu. ");
INSERT INTO asj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bɛniiŋ bɛchu se tuu be gwenini le be koŋ li wuu, kifɛ buŋga bu tɛ̀ buti li wuu bwiŋ tɛ̀ wɔnchi bɛniiŋ bɛchu bɛ tɛ̀ kundi li wuu. ");
INSERT INTO asj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jiso dza tsaaki lii bichɛ bɛniiŋ bee bɛ kintutu-u, tee le, “Kinɛɛtinɛ ki nɔŋa kɛɛ kinɛ, beŋ bɛ kifoo lɛ, kifɛ bumfɔŋ bu Nyɔ-ɔ bwɛɛ bunɛ ");
INSERT INTO asj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kinɛɛtinɛ ki nɔŋa kɛɛ kinɛ, beŋ bɛ dzeeŋ wuu dɛɛni, Kifɛ Nyɔ gii yi fɛ nɛ fukɛ Kinɛɛtinɛ ki nɔŋa kɛɛ kinɛ, beŋ bɛ dii dɛɛni, kifɛ nɛ gii nɛ kwakɛ chike. ");
INSERT INTO asj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kinɛɛtinɛ ki nɔŋa kɛɛ kinɛ, mfi wu nɛ biki Ŋwanɛwi, bɛniiŋ baanini beŋ, be busi beŋ lɛ bee lɛnti, be gaashi beŋ be nyɛɛ mɔɔ beŋ mɛŋkooŋ mɛ bifi. ");
INSERT INTO asj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ɛ fi kɛti lɛ, nɛ nɛki yɛɛŋ, nɛ wuki bujɔŋ, kifɛ kinsomfu kinɛ kinɔŋa kɛɛ liboo Ɛ nɛɛ lɛ si bɛtee ŋkosi bɛ bee tɛ̀ ŋwɛki bɛ bɛntomfɔŋ bɛ Nyɔ-ɔ lɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Se nuuŋ le, ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛniiŋ bɛ bulofu-u, kifɛ nshiiŋ yinɛ ma yɛɛ kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛ bite yisɛ dɛɛni, kifɛ nɛ gii nɛ de dzeeŋ. Ŋgɛ wu nyɔŋa wɛ wunɛ, beŋ bɛ kiiti dɛɛni, kifɛ nɛ gii nɛ ni nɛ dii nɛ seti bikoo. ");
INSERT INTO asj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ŋgɛ wu nyɔŋa wɛ wunɛ, mfi wu bɛniiŋ bɛchu piɛti beŋ. Nɛ kɛɛ le ɛ nɛɛ lɛ si bɛte bɛniiŋ bɛ lindɛɛri tɛ̀ shiiŋ be piɛti bɛniiŋ bɛ binsɛɛ lɛ bɛ tɛ̀ yɛŋgi le be baa bɛntomfɔŋ bɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Se nuuŋ le ntiitɔɔ beŋ bani bɛ wuki fiee fi ntiiti le nɛ ni nɛ kɔŋgisi bɛniiŋ bɛnɛ bɛ mbani-i, nɛ feti nuuŋ biee bi dzeeŋ li bɛniiŋ bɛ baanini be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nɛ lɛki yɛɛŋ nuuŋ le Nyɔ lɔŋ kimbɔnɛ li bɛniiŋ bɛ lɛki le bubiɛɛ ni bu biki be-eŋ, nɛ lɛki li Nyɔ-ɔ li bɛniiŋ bɛ ŋwɛki bɛ be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ɛ wi maaŋ wɛ li kilaanchɛ, ɔ fiiki kimu mɛɛshi maaŋ ki. Ɛ wu buu ndu ya yi lɛkuuŋ, ɔ gɛɛ mɛɛshi dzɔ mɔɔ yi lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɛ wi lɛkɛ fiee li wɛ-ɛ, ɔ nyɛ mwɛ. Ɛ wi dzɔ fiee fio, ɔ bii kɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nɛ feti li bɛniiŋ bamu-u fiee fi nɛ wɛki le be ni be feti li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ɛ nɛ kɔŋgisi nuuŋ bɛniiŋ bɛ kɔŋgisi beŋ kwaa, fiee fi bɛ gii bɛ pia beŋ li fi-i nuuŋ la? Ɛ nɛɛ lɛ si bɛniiŋ bɛ bifi ti feti nɛɛ tɛ lɛ ni? Be kɔŋgisi nuuŋ bɛniiŋ bɛ kɔŋgisi be kwaa. ");
INSERT INTO asj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ɛ nɛ feti biee bi dzeeŋ nuuŋ li bɛniiŋ bɛ feti li beŋ kwaa, fiee fi bɛ gii bɛ pia beŋ li fi-i nuuŋ la? Mɔɔ bɛniiŋ bɛ bifi, be ti feti nɛɛ tɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ɛ nɛ feeti bɛniiŋ biee nɛ bichi limfwe le be gii be kaari be tuu li be-eŋ, fiee fi bɛ gii bɛ ni bɛ piɛti beŋ lu nuuŋ la? Mɔɔ bɛniiŋ bɛ bifi ti feeti biee li nsáŋ yi bee kifɛ be gii be kaari be tuu fiee fichu nɛɛ ni? ");
INSERT INTO asj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Fi dzɔɔŋ le nɛ ni nɛ kɔŋgisi bɛniiŋ bɛnɛ bɛ mbani-i, nɛ feti tɛ nuuŋ biee bi dzeeŋ li bee, ɛ nɛ feeti bɛniiŋ biee nɛ beechɛ kɛ le be gii be tuu kɛ. Nɛɛlɛ, nɛ se kɛmɛ kinderi ki nɔŋa, nɛ se nuuŋ bɔɔŋ bɛ Nyɔ yi nuuŋ Kikoo ki Biee Bichu, nɛ se ni nɛ nuuŋ bɔɔŋ bee, kifɛ ɛ nɛɛ Nyɔ yi ti feti biee bi dzeeŋ li bɛniiŋ bɛchu bɛ yɛchi lii mɔɔ bɛ shéŋ yi tii lɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nɛ ni nɛ keeti nshiiŋ li bɛniiŋ li nɛɛ si Baa wunɛ keeti nshiiŋ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nɛ saa kɛ biŋge bi bɛniiŋ bamu-u kɛ, ɛ fi nuuŋ lɛ Nyɔ tɛ saa tɛ kinɛ kɛ. Nɛ beeŋ kɛ bikaa lɛ bɛniiŋ jiŋ le be lɛ li ŋgɛ-ɛ kɛ, bɛdɛɛni, Nyɔ se tɛ beeŋ tɛ lɛ benɛ jiŋ kɛ. Nɛ fekisi bibifi bi bɛniiŋ bamu-u, Nyɔ se feeki tɛ binɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nɛ nyɛɛ yɛɛŋ nya li bɛniiŋ li, Nyɔ se ni yi nyɛɛ tɛ li be-eŋ. Mfi wu yi gii yi nyɛ, ɛ yi fichɛ bujɔŋ, yi sɛɛsɛ, yi chiiŋ bi yisɛ bi ni bi shooshi fɛkwiiŋ. Fiee fi wi fichini fiee le, se nyɛ li wi-i, ɛ nɛɛ fi fi Nyɔ gii naa yi fichɛ le yi se nyɛ li mwɛ-ɛ tɛ.” ");
INSERT INTO asj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jiso tuu wa ŋgaŋgaa chimu li bee le, “Kinyɛɛ nuuŋ ki tɛ doonchɛ dze li kimu-u kɛ. Ɛ ki mɔŋ tɛ lɛ, bi bichu lee ki we-e lɛ kitoo li ni? ");
INSERT INTO asj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nɛ kɛɛ le ŋwaŋ wu laanchi ti yɛki yɛ wi we wu wu ntiifɛ kɛ, bɛdɛɛni, ɛ mfi wu wu laanchɛ wu mɛɛshi, se kɛɛ tɛ si wi wu tɛ̀ tifi wu. ");
INSERT INTO asj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Fi geeŋ fiɔɔ ŋiŋgi sheeŋ yi kwiŋ yi nuuŋ ŋwaana lɛ lii, ɔ se tɛ ŋɛŋ kiŋkɔsi ki kwi-iŋ ki nuuŋ lɛ lii yaa kɛ? ");
INSERT INTO asj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kɛ fi geeŋ fiɔɔ nuuŋ ɔ tee li ŋwaana le, ‘Ŋwaanɛŋ bɛ mbuu sheeŋ yɛɛ lɛ wɛɛ lii’, ɔ se tɛ ŋɛŋ tɛ kiŋkɔsi ki nuuŋ wɛ lɛ lii kɛ? Wɛ wi wu nimi! Saa buu ko ki nuuŋ lɛ wɛɛ lii, ɔ se bɔsɛyi ɔ ŋɛŋ sheeŋ yi nuuŋ ŋwaana lɛ lii, ɔ se buu.” ");
INSERT INTO asj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jiso tuu tee le, “Se nuuŋ le kiti ki dzeeŋ nuuŋ tɛ woŋ muntaaŋ mu bifi kɛ, si kiti ki bifi nuuŋ tɛ woŋ muntaaŋ mu dzeeŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bɛ ti kii kiti nuuŋ li muntaaŋ mu ki wundi-i. Fi nuuŋ le wi nuuŋ tɛ kɔ fimbi li bifafu-u kɛ, nuuŋ wi tɛ kɔ fiŋgaa li bufii li kɛ. ");
INSERT INTO asj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wi wu dzeeŋ lɛ fikoo fiee fi shaaŋ li ti busi biee bi dzeeŋ le. Wi wu fikoo fiee nuuŋ biee bifi li shéŋ yee li, ti busi nɛɛ nuuŋ biee bibifi. Fi fiɛɛ nɛɛ lɛ kifɛ fiee fi yisɛ li shéŋ yi wi-i ɛ fi fi ti buti lɛ kimfimɛ kee li.” ");
INSERT INTO asj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jiso tuu bii laa, “Fi geeŋ fi nɛ teenyi mi le, ‘Taa, Taa’, nɛ tɛ fɛ fiee fi ntiiti li be-eŋ kɛ? ");
INSERT INTO asj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wi kwi wu bɛɛ lɛ mi-i, wuki jɛ yɛŋ, giiŋgi feti si yi tiiti, ŋgii doonchɛ beŋ si ti nuuŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wɛ si wi wu tɛ̀ wɛki le gwaŋ yih, saa chiŋ seri koŋ li kimbaŋ se gwaŋ kimfoo li kimbaŋ kilu-u. Ɛ dzɔɔ yisɛ, yi bɛ yi ju li yih yilu-u, yi tɛ sɛɛsɛ kɛ, kifɛ tɛ̀ bɔsɛyi gwaŋ bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Se nuuŋ le, wi wu wuki jɛ yɛŋ, ɛ wu gɛɛŋ tɛ fɛ si yi tiiti kɛ, wɛ si wi wu tɛ̀ wɛki le gwaŋ yih, fooshɛ kimfoo li nshɛ li we, ɛ dzɔɔ yisɛ, yi kemɛ yih yilu, yi biee yi we bɛ nchiiŋ ni guuu.” ");
INSERT INTO asj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Si Jiso tɛ̀ mɛɛshi ntiifɛ bɛniiŋ biee bini bichu lɛ, tuu dza gɛɛŋ lɛ kitoŋ ki Kapanu-uŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te Kikoo wu kintutu ki bɛniiŋ bɛ nchi wu Lom tɛ̀ nuuŋ fe, kɛmi mfwa we wumu, kɔŋgisi wu ŋge. Ɛ mfwa wulu tɛ̀ gendi, nuuŋ lɛ kwe bɔ. ");
INSERT INTO asj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Le te kikoo wulu woo kii Jiso, toŋ bɛkaaŋ bɛ sɛki kwɛɛŋ wu Bɛjuu, le be gɛɛŋ be lɛkɛ Jiso le bɛ wɔnchɛ mfwa we wuni. ");
INSERT INTO asj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Be se gɛɛŋ be ŋɛŋ Jiso, be sooŋ bɔ li wuu, be tee le, “Mintemii bɛ ɔ gɛɛŋ ɔ fi wi wusɛŋ wuni, wɛ nuuŋ wi wu ɔ nuuŋ nɛɛ ɔ fi wu. ");
INSERT INTO asj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kɔŋgisi kwɛɛŋ wusɛŋ ŋge, ɛ wu wu tɛ̀ gwaŋ yih yisɛŋ yi kintaashɛ.” ");
INSERT INTO asj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jiso se dza bee be giiŋgi. Fɛ be tɛ̀ nuuŋ tsɛkɛtsɛkɛ li mbochu fɛ yih yi Te Kikoo wu bɛniiŋ bɛ nchi wɛɛ, toŋ nsáŋ yee yimi le yi gɛɛŋ yi loosɛ Jiso. Be se gɛɛŋ, be bikɛ bɛ wu, be laŋɛ li wuu le, “Taa, Te Kikoo wu bɛniiŋ bɛ nchi teeɔ le, kiiŋ ɔ ni fieeŋgi yi ya le ɔ bɛ kɛ. Le mɛɛŋɔ ki kɔchɛ kɛ wi wu ɔ nuuŋ ɔ lɛ li wuu yih kɛ. ");
INSERT INTO asj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Le fiɛɛ fiee fi fɛ se mɛɛŋ ki bɛ kɛ bɛ bikaa biee le ŋɛŋ wɛ kɛ. Se nuuŋ le, ɔ yɔ nɛɛ nuuŋ jɛ kwaa bɛ kimfimɛ ko, kɛ ŋwani wu nimɛ gii tɛmi. ");
INSERT INTO asj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mi ŋ'wɛ tɛ lɛ buŋga bu wi wumu lɛkwiiŋ, bɛniiŋ bɛ nchi-i nuuŋ tɛ lɛ mi-i lɛkwiiŋ. Mbɛɛ ɛ mi ntee li wumu le, ‘Ɔ giiŋgi,’ mwɛ gɛɛŋ, ɛ mi ntuu mi ntee li wumu le, ‘Bɛ,’ mwɛ bɛ nɛɛ. Ɛ mi ntee tɛ li mfwa wɛ-ɛŋ le, ‘Fɛrɛ fini’ fɛ nɛɛ tɛ lɛ.” ");
INSERT INTO asj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Le Jiso woo ntoŋ wulu, wa tɛ wu, se fiiki yi tee li kimbanchɛ ki bɛniiŋ lɛ ki tɛ̀ biki wu kɛɛ le, “Ntee beŋ le, mɛɛŋɔ nsaa ki ŋɛŋ kɛ wi wu kɛmi ŋwaani kini kimbeenchɛ li mi-i mɔɔ nuuŋ li kwɛɛŋ wu Isɛlɛɛ li kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Le bɛniiŋ bɛ te kikoo wu bɛniiŋ bɛ nchi tɛ̀ toŋ baa tuu be kaari be to li yih, be ŋɛŋ mfwa wulu ɛ wu tɛmi. ");
INSERT INTO asj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lɛjiŋ lɛlu, Jiso bɛ bɔɔŋ bee bɛ kintutu dza be giiŋgi li kitoŋ kimu ki bɛ teenyi le Nayiŋ, kintutu ki bɛniiŋ lɛ biki wu lɛ jiŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Si be tɛ̀ giiŋgi lɛ, le be buti fɛ fweeŋ wu mbaŋ wu tɛ̀ lii li kitoŋ kilu, le be bichi lɔɔ be ŋɛŋ si bɛ too gwini chi wi bɛ buti bɛ chi. Wi wulu tɛ̀ nuuŋ wu kwaa lɛ ni bɔ. Ɛ ni tɛ̀ nuuŋ kwɛɛ ŋku. Si be tɛ̀ buti lɛ, kintutu ki bɛniiŋ lɛ bɛ li kitoŋ kilu tɛ̀ biki ni ŋwaŋ wulu. ");
INSERT INTO asj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Le Taa tuu ŋɛŋ kwɛɛŋ wulu, nshiiŋ kɔɔ wu, tee li wuu le, “Kiiŋ ɔ ni tuu ɔ de kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Fɛ tɛ̀ tee lɛ, ka gɛɛŋ koŋ li kidaŋ ki bɛ tɛ̀ too gwini chilu fe. Bɛniiŋ bɛ tɛ̀ too gwini chilu baa se leŋ. Tee le, “Sɔɔnɛ nyuŋ, ntiitɔɔ li wɛɛ dzatsɛ we!” ");
INSERT INTO asj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Biee dza we shee, bɛchi n'yɔru. Jiso kɛmɛ li wu nyɛ li ni-i. ");
INSERT INTO asj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bɛniiŋ bɛchu ŋɛŋ lɛ, wa tɛ be. Be se guumɛ be yɔɔnchi Nyɔ be tiiti le, “Ntomfɔŋ wu Nyɔ wu nyɔŋa busɔɔ lɛ bee li lɛnti. Nyɔ bɛ yɛ le yi fi bɛniiŋ bee.” ");
INSERT INTO asj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ntoŋ wuni wu kii Jiso se saaŋgɛ wu gɛɛŋ li kwɛɛŋ wu Judiya kwikwi mɔɔ bitoŋ bi nuuŋ li kwɛɛŋ wulu lichiŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bɔɔŋ bɛ kintutu-u bɛ Jɔɔŋ lɛ woo biee bini bichu, be gɛɛŋ be tee li wuu. Teeŋ bamu bɛfɛ, ");
INSERT INTO asj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","toŋ be lɛ Taa li le be gɛɛŋ be bii li wuu laa ɛ wu wu tɛ̀ nuuŋ le gii bɛ mɔɔ, be ni be tɛŋgi wi wumu le? ");
INSERT INTO asj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Be gɛɛŋ be ŋɛŋ Jiso be tee li wuu le, “Jɔɔŋ Nlisulidzɔɔ toŋ wɛ bee le tɛ bii li wɛ laa, ɛ wɛ wu tɛ̀ nuuŋ le ɔ gii ɔ bɛ mɔɔ, be ni be tɛŋgi wi wumu le?” ");
INSERT INTO asj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Be tɛ̀ biiti lɛ, nuuŋ li mfi wu Jiso tɛ̀ wɔnchi chigɔŋ bɛ chigɔŋ chichu, busi mɔɔ Fiana yi tii li bɛniiŋ li, gwiyi lii yi binyɛɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jiso tuu li bee le, “Kaari yɛɛŋ nɛ gɛɛŋ nɛ tee li Jɔɔŋ li biee bi nɛ ŋɛŋ mɔɔ bi nɛ woo. Binyɛɛ ŋɛŋ biɛɛ biee, bimbonyɛ deŋgi biɛɛ tsaaŋ, bɛniiŋ bɛ gendi bɛ chigɔŋ chi nɔŋa tɛmi baa. Binchiinchi wuki biɛɛ biee, bɛniiŋ bɛ kwiyɛ kaari be bo li kwe-e, be tuu be tiifi tɛ ntoŋ wu Nyɔ wu dzeeŋ li bɛniiŋ bɛ kifoo lɛ. ");
INSERT INTO asj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kinɛɛtinɛ ki kinɔŋa kɛɛ ki wi wu mɛɛŋ ki mɛŋɛ kɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mfi wu bɛniiŋ bɛ Jɔɔŋ tɛ̀ toŋ baa tɛ̀ dza, Jiso se biee bɛchi tiiti li kimbanchɛ ki bɛniiŋ lɛ, kii Jɔɔŋ, biiti laa, “Nɛ tuu nɛ shiiŋ nɛ buti nɛ giiŋgi libuka le nɛ gɛɛŋ nɛ ŋɛŋ tɛ nuuŋ la? Kitɔɔ ki mbaandze kɛti ki sɛɛsi ni? ");
INSERT INTO asj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɛ nuuŋ yɛ lɛ kɛ nɛ se tɛ̀ shiiŋ nɛ buti nɛ giiŋgi le nɛ ŋɛŋ tɛ nuuŋ la? Wi wu chuumɛ yi yee bɛ ndú yi shaaŋ ni? Yikɛ yɛɛŋ nɛ woo, bɛniiŋ bɛ chumini yi yi be bɛ ndú yi tɛɛmi mɔɔ bɛ tsiiŋ ntsɛ wu shaaŋ ti nuuŋ nuuŋ lɛ bɛntɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nɛ se tɛ̀ giiŋgi le nɛ ŋɛŋ tɛ nuuŋ la? Ntomfɔŋ wu Nyɔ ni? Iiŋ, ntee beŋ le, wu yaaɔ ntomfɔŋ wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ɛ wu wu bɛ tɛ̀ tsɛɛ kii wu, Nyɔ tiiti le, ‘Yikɛ yɛɛŋ nɛ woo, ŋgii ntuumi wi wɛŋ wu ntoŋ ni tuuti mbaaŋ li wɛ-ɛ, nachɛ dze ya ɔ se bɛɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ntee beŋ le, lɛnti lɛ bɛniiŋ bɛ bukɛɛŋ biɛ, wi nuuŋ yɛ lu wu ko wu yaa Jɔɔŋ kɛ. Se nuuŋ le, wi wu nuuŋ wi wu ŋkwɛŋ li bumfɔŋ bu Nyɔ-ɔ wɛ ɛ wu wu ko wu yaa Jɔɔŋ”. ");
INSERT INTO asj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bɛniiŋ bɛchu mɔɔ bɛniiŋ bɛ tɛ̀ kundi kiŋwaati woo si Jiso tee le tɛ̀ nuuŋ ntomfɔŋ wu Nyɔ, be pia bumfɔŋ bu Nyɔ-ɔ le bu nuuŋ tsaaŋ kifɛ be tɛ̀ beŋ Jɔɔŋ lii be lidzɔɔ. ");
INSERT INTO asj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Se nuuŋ le, Bɛfarasii mɔɔ bɛniiŋ bɛ tɛ̀ gbɛŋgi be kii bɛnchi bɛ Nyɔ-ɔ faaŋ fi bee ntaŋ wu Nyɔ tɛ̀ bɛ bɛ wu wɛ kifɛ be tɛ̀ faaŋ le kiiŋ Jɔɔŋ ni lii be lidzɔɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jiso dza tee le, “Ɛ la fi nnuuŋ mmaa bɛ kiŋgɔkɛ ki bɛniiŋ bɛ dɛɛni kini? Be baa si la? ");
INSERT INTO asj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ntee beŋ fiee fi be baa si fi. Be baa si bɔɔŋ bɛ bwi bɛ shiiti fɛ kintsii ki wa-aŋ, bamu teenyi bamu be biiti laa, ‘Tɛ teh teŋgi tebi nɛ tɛ̀ biŋ kɛ, tɛ nyɛ juuŋ yi kwe nɛ de kɛ kii la?’ ");
INSERT INTO asj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ɛ nɛɛ lɛ si Jɔɔŋ Nlisulidzɔɔ tɛ̀ bɛ, shiiŋ bɛ dzeeŋ tɛ̀ woŋ mbiiŋ kɛ, nɛ tee le kɛmɔɔ bɔɔŋ bɛ kiŋkundi-i li wuu bwiŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ŋwanɛwi bɛɛɔ, jii biee, wundi biee, nɛ tee le, bichɛ yɛɛŋ nɛ ŋɛŋ wi wuni deŋgɔɔ wuti biee, wundi mbiiŋ piɛndi, tuu shiiŋ mɔɔ nsáŋ bɛ bɛniiŋ bɛ kundi kiŋwaati mɔɔ bɛniiŋ bɛ bifi bamu. ");
INSERT INTO asj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Se nuuŋ le, bufii ti doonchi yi nuuŋ li bɔɔŋ bee bɛchu-u.” ");
INSERT INTO asj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wi wu Bɛfarasii wumu tɛ̀ dza teeŋ Jiso le bɛ ji biee li wuu yih. Jiso beŋ, gɛɛŋ be shee be jii biee. ");
INSERT INTO asj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Se nuuŋ le kinjikwiiŋ kimu tɛ̀ nuuŋ li kitoŋ kilu. Ki woo le Jiso jiiɔ biee li wi Bɛfarasii wɛ yih, ki se dzɔ fika fi mɛɛŋ mamu mɛ sɛɛndi bujɔŋ ki gɛɛŋ bɛ me fe, ");
INSERT INTO asj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ki se gɛɛŋ ki leŋ Jiso lɛjiŋ, ki bɛchi ki dii, musu sɛyi Jiso li bikaa li. Ki biee ki guumɛ, ki bɛɛki kikoo ki kii ki wɔɔyi bikaa bi Jiso bɛ yi yi ki yi lifa, ki nyɔɔchɛ wu, ki fwa bɛ mɛɛŋ malu. ");
INSERT INTO asj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Le wi Bɛfarasii wu tɛ̀ teeŋ Jiso le bɛ ji biee wɛ ŋɛŋ lɛ, beechɛ li shéŋ yee li le, ɛ wi wuni bee nuuŋ ntomfɔŋ wu Nyɔ, bee nuuŋ wu kɛɛ le ŋwaani wuni kwɛɛŋ, ɛ kinjikwiiŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jiso dza tee li wi wu Bɛfarasii wɛ-ɛ le, “Simu, ŋkɛmɔɔ fiee fi ŋgii ntee li wɛɛ.” Simu se tuu le, “Wi wu Ntiifɛ, tee lɛ.” ");
INSERT INTO asj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jiso bɛchi le, “Wi wumu tɛ̀ fɔɔ bɛniiŋ bɛfɛ kwa, fɔɔ wumu bɛ danali gii tiŋ, fɔɔ wumu bɛdanali mbaanshiŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wu tɛ̀ yaa be nsomfu, se tuu chinɛ kwa wulu li bee. Se nuuŋ le, lɛ bee lɛnti ɛ wu la wu gii ni kɔŋgisi wu ŋge?” ");
INSERT INTO asj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simu tuu le, “Fi nuuŋ fi nuuŋ wi wu bɛ tɛ̀ fɔɔ wu kwa wu nyɔŋa wɛ.” Jiso se kweeŋ le, ɔ saaɔ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Si kweŋgi lɛ, fiiki yi bichɛ kwɛɛŋ wɛɛ, biee tee li Simu le, “Ɔ ŋɛŋ kwɛɛŋ wuni ni? Si mbee mbɛ li wɛɛ yih, ɔ bee mɛɛŋ mɔɔ ki nyɛɛ mi dzɔɔ le ntsootsɛ bikaa bieŋ kɛ. Se nuuŋ le, kwɛɛŋ wuni tsootsɔɔ bikaa bieŋ nuuŋ bɛ musu mee mɛ lɛ lii, wu wɔɔyɛ bɛ yi ye yi lifa. ");
INSERT INTO asj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɔ bee ɔ mɛɛŋ ki kokɛ kɛ mi le ɔ nyɔɔchɛ bikaa bieŋ kɛ. Se nuuŋ le, si mbee mbɛ fɛni, ɛ nɛɛ kwɛɛŋ wuni kwaa wu nyɔɔchɛ bikaa bieŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɔ bee mɛɛŋ mɔɔ ki fwa kɛ kikoo keŋ bɛ mɛɛŋ kɛ. Se nuuŋ le, ɛ nɛɛ kwɛɛŋ wuni kwaa wu fwaɔ bikaa bieŋ bɛ mɛɛŋ mɛ sɛɛndi ni shuuŋŋ. ");
INSERT INTO asj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Se nuuŋ le, ntee wɛ le, kwɛɛŋ wuni bee doonchɛ kiŋkɔŋgisɛ ki ŋge, bɛ gii bɛ feeki bibifi biee bi ŋge. Se nuuŋ le, wi wu bɛ feeki bibifi biee bi niiŋ doonchi kiŋkɔŋgisɛ ki niiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jiso se biee tee li kwɛɛŋ wulu-u le, “Bɛ feeki baa bibifi bio.” ");
INSERT INTO asj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bɛniiŋ bɛ bee be tɛ̀ jii biee baa tuu be bɛchi be ŋuŋini li yi yi bee, be tiiti laa, “Wuni nuuŋ noo kibɛɛ wu fekisi bibifi bi bɛniiŋ le?” ");
INSERT INTO asj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jiso se mɛɛshi tee li kwɛɛŋ wulu-u le, “Gɛnɛ fio bɛ mbɛɛŋgii, shéŋ ya yi ɔ gɛɛ li mi-i soo yɛɛ wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lɛjiŋ lɛlu, Jiso tɛ̀ dza deŋgi li bitoŋ li bɛ li bintsii li tiifi ntoŋ wu dzeeŋ kii bumfɔŋ bu Nyɔ-ɔ. Bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ bɛfɛ tɛ̀ biki wu, ");
INSERT INTO asj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mɔɔ bukɛɛŋ bamu bɛ tɛ̀ wɔnchɛ chigɔŋ chi bee bɛ bamu bɛ tɛ̀ buushɛ fiana yi tii li bee. Bukɛɛŋ bani tɛ̀ nuuŋ Maariya wu bɛ tɛ̀ teenyi le Madaliŋ, wu Jiso tɛ̀ buushɛ bɔɔŋ bɛ kiŋkundi li wuu bwiŋ mfomɛnyaaŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana wu kwɛɛ Chusa wu tɛ̀ nindi li Hɛrɔ-ɔ, mɔɔ Sosana bɛ bukɛɛŋ bamu bɛnɔŋa. Be tɛ̀ deŋgi lɛ, be busi biee lɛ bɛ babi bɛ bee be fii Jiso bee bɔɔŋ bee bɛ kintutu-u lu. ");
INSERT INTO asj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bɛniiŋ tɛ̀ dza be buti li bitoŋ li bitoŋ li be bɛɛ fɛ Jiso-o. Le kintutu ki bɛniiŋ lɛ yisɛ fe, se wa ŋgaŋgaa chini li bee le, ");
INSERT INTO asj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wumu tɛ̀ la le gɛɛŋ tuŋ muntaaŋ mwee. Le ni tumi, mumu weyɛ lɛ dze, bɛniiŋ kɛti be dɛnchi bɛ bikaa, muniiŋ mu jiindi liwe se bɛ mu chɔchɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mumu se weyɛ li bikooshu-u, le mu maŋ mu bɛchi ŋko mu wɔɔbɛ kifɛ nshɛ yi fe tɛ̀ nuuŋ siiŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mumu weyɛ li bifafu-u, le mu bo mu ni mu kuu bɛ bifafu bilu, bi beeme mu, mu ba ŋko nsiŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mumu weyɛ tɛ nuuŋ li nshɛ yi dzeeŋ li, le mu maŋ, mu ko, bɛ kɔ mu bo bɛŋkaa gwii yaa si bɛ tɛ̀ tuŋ.” Le Jiso wa ni, dzaaŋ le, “Wi wu kɛmi bintooŋ, mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bɔɔŋ bee bɛ kintutu dza be bii li wu laa ŋgaŋgaa chini tiiti le la? ");
INSERT INTO asj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Se tuu le, “Ɛ beŋ bani bɛ Nyɔ fɛ yɛ le nɛ kɛɛ bɛntsooŋ bɛ bumfɔŋ bu Nyɔ-ɔ. Se nuuŋ le bɛniiŋ bamu wuki baa nuuŋ lɛ ŋgaŋgaa li, fi se fiɛɛ si fi tɛ̀ nuuŋ le, ‘Ɛ be bichi lɔ be tɛ ŋɛŋ kɛ, ɛ be yiki lɔ be tɛ woo kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Woo yɛɛŋ naanyɛ wu ŋgaŋgaa chilu. ");
INSERT INTO asj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Muntaaŋ mulu ɛ jɛ yi Nyɔ. Muntaaŋ mu tɛ̀ weyɛ lɛ dzeti mwɛɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, kiŋkundi se bɛ ki buu yi li shéŋ yi bee ki feti le be beŋ kɛ le yi fi be kɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mu tɛ̀ weyɛ li bikooshu-u mwɛɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, be fi yi bɛ kinɛɛtinɛ, se nuuŋ le yi tɛ̀ lii gwɛɛŋ le yi seri li shéŋ yi bee kɛ, be beenchi fefe, ɛ mɔnchɛ bɛ lɛ bee, be tuu be to lijiŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Muntaaŋ mu tɛ̀ weyɛ li bifafu mwɛ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ, si be giiŋgi lɛ bɛmfumisɛ bɛ bunɔŋa mɔɔ bujɔŋ bu biee bi li nshɛ yini-i bɛ bi yikɛ jɛ yilu yi layɛ yi tɛ ko kɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mu tɛ̀ weyɛ li nshɛ yi dzeeŋ li mwɛɛ nuuŋ bɛniiŋ bɛ kɛmi shéŋ yi dzeeŋ, bɛ wuki jɛ yi Nyɔ, be bɔsɛyi be gɛɛ yi li shéŋ yi bee, be se kaŋ shéŋ, be feti si yi wɛki nsiiŋ biee bi bee bi dzeeŋ yenɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wi ti tendi yɛ lambo le tuu dzɔɔ ŋkwaa kuuki lu kɛ. Kɛ le tuu dzɔɔ lii litakwiiŋ kɛ. Bɛ ti tendi lambo, bɛ tɔmi nuuŋ li fiee fi bɛ ti tɔɔmi lu-u, le bɛniiŋ bɛ lii li yi ni be ŋiŋgi kiŋ'wofu. ");
INSERT INTO asj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Fiee fichu fi bɛ nyikɛ gii fi yenɛ, biee bi lɛjiŋ lɛjiŋ gii bi yenɛ bi bo lɛ waaŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bɛdɛɛni, ɛ nɛ yiki jɛ yi Nyɔ nɛ yikɛ bujɔŋ, kifɛ wi wu kɛmi fiee bɛ gii bɛ taa wu fimu. Wi wu kɛmi yɛ fiee kɛ mɔɔ nuuŋ fintɛŋ fi beechi le kɛmɔɔ bɛ gii bɛ fi li wuu.” ");
INSERT INTO asj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Si Jiso tɛ̀ tiifi bɛniiŋ lɛ, ni bee bɛŋwaani dza be bɛ le be ŋɛŋ wu. Fi se yaa be nlɛ kifɛ bɛniiŋ tɛ̀ yaŋ lu ŋge. ");
INSERT INTO asj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wumu se tee li wuu le, “Na bee bɛŋwaana lemi baa lɛkuuŋ be wɛki le be ŋɛŋ wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Se tuu fiee le, “Naaŋ bee bɛŋwaanɛŋ nuuŋ bɛniiŋ bɛ wuki jɛ yi Nyɔ be feti si yi wɛki.” ");
INSERT INTO asj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Le ni nuuŋ jobɛ chimu, Jiso lɛ lɛ ŋgo-o bee bɔɔŋ bee bɛ kintutu-u tee li bee le, “Tɛ lenchi libɛ chini tɛ gɛɛŋ luwiŋ lɔɔ.” Be se bɛchi nleenchɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Le be ni be lenchi, Jiso dza bɛchi liiti. Mfiee yi tɛɛmi, bɛchi yi nduŋgi li dzɔɔ bɛ buŋga, dzɔɔ bɛchi yi lii lɛ ŋgo-o yi wɛki le yi yisɛ le, be gii be nuuŋ lɛ kwe wa. ");
INSERT INTO asj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Be se gɛɛŋ be kaŋgisi Jiso be tiiti le, “Te Kikoo, Te Kikoo, tɛ baa lɛ kwe wa.” Jiso kaaŋgi waŋ mfiee yi tɛɛmi mɔɔ dzɔɔ yi tɛ̀ nduŋgi yilu. Mfiee yilu mɔɔ dzɔɔ yilu se chikɛ, bintsii deŋ ni nshiiŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Se bii li bee laa, “Nɛ gɛɛ shéŋ yinɛ li noo li?” Bɛ chɛnɛ mɔɔ kiŋkoofɛyi, be se bii li yi yi bee laa, “Wuni nuuŋ noo, wu wɛndi mfiee mɔɔ dzɔɔ bi wuki li wuu le?” ");
INSERT INTO asj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Le be lenchi libɛ chilu be bo kimbɛ ki Jerasɛnɛ, ki nuuŋ liwiŋ lɛ kimbɛ ki kwɛɛŋ wu Galilii. ");
INSERT INTO asj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Si Jiso tɛ̀ bo lɛ ŋgo-o leŋ lɛ buka lɛ, bee wumu wu li kitoŋ kɛɛ bikɛ, nuuŋ ɛ bɛnchindaa bɛ kiŋkundi-i tɛ̀ shiiŋ be ŋwɛki bɛ mwɛ. Be tɛ̀ tsi wu li bwiŋ ŋge deŋgi tiŋ kilɛrɛ, tɛ̀ tsi li yih kɛ, tsiiŋ nuuŋ lɛ dzíŋ yi bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Le ŋɛŋ Jiso, biee toŋ kitata, gɛɛŋ we wu limfwe, waŋ bɛ buŋga le, “Jiso, Ŋwanɛ Nyɔ, Nyɔ yi nuuŋ Kikoo ki Biee Bichu-u, ɔ wɛki la li mi-i? Mintemi-i ɔ kiiŋ ɔ ni nyɛ ŋgɛ li mi-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tɛ̀ yɔ lɛ kifɛ Jiso tɛ̀ waŋ Fiana yi tii yilu yi bo li wuu. Yi tɛ̀ shiiŋ yi choofi wu li kiŋga-a li kiŋga-a bɛ keeti wu bɛ kɛndi wu bibɛnu mɔɔ bikaa bɛ bɛncha bɛ kiichi wu. Si bɛ tɛ̀ shiiŋ bɛ kɛndi wu lɛ, soomi bɛncha bɛlu, fiana yilu choofi wu letini giiŋgi libuka. ");
INSERT INTO asj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jiso se bii li wi wulu-u laa, “Bukooŋ bwo nuuŋ le noo?” Tuu le, “Bukooŋ bweŋ nuuŋ le kimbanchɛ.” Tɛ̀ tuu lɛ kifɛ bɔɔŋ bɛ kiŋkundi-i bɛlu tɛ̀ banchɛ li yi yee li ŋge. ");
INSERT INTO asj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bɛnchindaa bɛlu se sooŋ bɔ li Jiso le, kiiŋ ɔ ni tuumi bee nuuŋ lɛ kitoo ki sechi wuuŋŋ li kɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Fi tɛ̀ nuuŋ lɛ ɛ kintutu ki dzíiŋ lɛ tɛ̀ jii biee fe li mbɛmɛ-ɛ. Bɛnchindaa bɛ kiŋkundi-i bɛlu se sooŋ bɔ li Jiso-o le, tuumi be, be gɛɛŋ be lɛ nuuŋ li dzíiŋ yilu. Se beŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bɛnchindaa bɛ kiŋkundi-i bɛlu se biee be bo li wi wulu-u, be dansɛ li dzíiŋ yilu-u. Kintutu ki dziiŋ lɛ kilu kichu se kɛŋ ki bɔɔ li mbɛmɛ wɛɛ ki seri lɛ libɛ-ɛ ki woŋ dzɔɔ ki kwiyɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Le bɛniiŋ bɛ tɛ̀ kiichi dzíiŋ yilu ŋɛŋ fiee fi ka lɛ, be dza fe, be kifi, be gɛɛŋ be tee ntoŋ wulu li bintsii bi li bitoŋ bi fe-e. ");
INSERT INTO asj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Le bɛniiŋ woo lɛ, be buti be giiŋgi le be ŋɛŋ fiee fi ka fe. Le be bɛ fɛ Jiso tɛ̀ nuuŋ, be ŋɛŋ wi wulu fe, nuuŋ ɛ bɛnchindaa bɛ kiŋkundi-i baa chinɛ li wuu, nuuŋ ɛ wu shee li Jiso-o lichiŋ, ɛ wu liishɛ ndú, bufii bwee nuuŋ tsaaŋ. Be se kɛmɛ chɛnɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bɛniiŋ bɛ tɛ̀ ŋɛŋ fiee fi tɛ̀ ka, tɛ̀ tiiti li bee si fi tɛ̀ nuuŋ bɛ wi wu tɛ̀ kɛmi bɛnchindaa bɛ kiŋkundi-i wɛ se tɛmi. ");
INSERT INTO asj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bɛniiŋ bɛchu bɛ lɛ bimbe bi Jerasɛnɛ-ɛ kɛmɛ jaaŋ, be biee be sooŋ bɔ li Jiso-o le dza ni giiŋgi. Jiso se biee dza fiee lɛ lɛ ŋgo-o gɛɛŋ, ");
INSERT INTO asj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wi wu bɛnchindaa bɛ kiŋkundi-i tɛ̀ bo li wuu wɛ se sooŋ bɔ li Jiso le bee wu gɛɛŋ. Jiso faaŋ, tuu wu lijiŋ, tee le, ");
INSERT INTO asj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kaari to li yih, ɔ gɛɛŋ ɔ tee fiee fi tɛɛmi fi Nyɔ fɛ li wɛ-ɛ fini.” Si fi tɛ̀ nuuŋ lɛ, wi wulu biee to lijiŋ gɛɛŋ deŋgi li kitoŋ kilu kichu, tiiti fiee fi tɛɛmi fi Jiso fɛ li wuu fini. ");
INSERT INTO asj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jiso lenchi libɛ chilu kaari to lijiŋ. Kintutu ki bɛniiŋ lɛ tɛ̀ nuuŋ fe, ki tɛŋgi wu. ");
INSERT INTO asj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nyuŋ wumu se bɛ fe bukooŋ le Jairɔs, ɛ tɛ̀ nuuŋ te kikoo wu yih yi nlɛkɛ li Nyɔ-ɔ yi fe. Tɛ̀ bɛ, we li bikaa bi Jiso, suŋgi bɔ le Jiso bɛ li wuu yih, ");
INSERT INTO asj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kifɛ ŋwani wu kwɛɛŋ mumkpaŋ wu tɛ̀ nuuŋ si biya yoofi ntsɔ bifɛ tɛ̀ nuuŋ lɛ kwe wa. Le Jiso dza ni giiŋgi kintutu ki bɛniiŋ lɛ fachi wu bimbɛ bichu. ");
INSERT INTO asj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɛ kwɛɛŋ wumu tɛ̀ nuuŋ li bee linti wu tɛ̀ nuuŋ bɛ chigɔŋ chi mfi wu ŋɛnɛ-ɛ biya yoofi ntsɔ bifɛ. Ɛ wu biifi fiee fichu fi tɛ̀ kɛmi li bɛniiŋ bɛ ntsi-i chi yaa be wɔnchɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kiiŋgi li Jiso lɛjiŋ koŋ li wooŋ wu kiŋkoŋ kee li, mfi we biee wu sondɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jiso bii laa, “Ɛ noo wu koŋ li mi-i?” Bɛniiŋ bɛchu mɛŋɛ. Pita se dza tee le, “Te Kikoo, ɔ ŋiŋgi yɛ le bɛniiŋ kɛnɛ baa wɛ lɛnti ŋge be fachi wɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jiso tuu kweeŋ nɛɛ le, “Wumu koŋ li mi-i. Mi ŋ'woo ɔ si buŋga bo li yi yɛ-ɛŋ.” ");
INSERT INTO asj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kwɛɛŋ wɛ ŋɛŋ le dze yi nyimɛ nuuŋ yɛ lu kɛ, bɛ kɛɛti gɛɛŋ we li bikaa bi Jiso, lɛ bintooŋ bi bɛniiŋ bɛchu, tee fiee fi bee koŋ li Jiso-o kii fi, tee mɔɔ si bee koŋ lɛ, chigɔŋ chee ma mfwaa mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jiso se tee li wuu le, “Ŋwaŋ wu kwɛɛŋ, shéŋ ya yi ɔ gɛɛ li mi-i fɛ yɛɛ ɔ tɛmi gɛnɛ bɛ mbɛɛŋgii.” ");
INSERT INTO asj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nɛɛ si Jiso tɛ̀ mɛɛŋ yeti li kwɛɛŋ wulu lɛ, wi wumu fɛsi fe, wu tɛ̀ bo li Jairɔs yih wu te Kikoo ki yih yi nlɛkɛ li Nyɔ-ɔ, tee li Jairɔs le, “Ŋwana mɛɛshɔɔ wu kwi kituŋ. Ɔ fieeŋgi kɛ Wi wu Ntiifɛ wuni kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Le tee lɛ, Jiso woo, tee li Jairɔs le, “Kiiŋ ɔ ni chɛŋ kɛ, beŋ li mi-i, ŋwana gii yiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Be se dza be giiŋgi fɛ Jairɔs kuuŋ, le be fɛsi fe, Jiso faaŋ le kiiŋ wi ni lɛ li yih kɛ. Dzɔ nuuŋ Pita bɛ Jeeŋ mɔɔ Jɔɔŋ mɔɔ te ŋwaŋ bɛ ni ŋwaŋ bee be lɛ. ");
INSERT INTO asj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tɛ̀ nuuŋ ɛ wi kwi wu tɛ nuuŋ fe dii kwe, kwe fuuti fe kichu. Jiso tee le, “Chikɛ yɛɛŋ bɛ kwe, ŋwaŋ wuni mɛɛŋɔ ki kwi kɛ, liitɔɔ nuuŋ chilefɛ.” ");
INSERT INTO asj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bɛniiŋ dza be kiiti wu nuuŋ chike, kifɛ be tɛ kii bujɔŋ le ŋwaŋ wulu bee kwi kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jiso gɛɛŋ fɛ ŋwaŋ wulu tɛ gimi, kɛmɛ wu li kibɛnɛ teeŋ le, “Ŋwaŋ wu kwɛɛŋ, dza we!” ");
INSERT INTO asj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ŋwaŋ wulu biee yiŋ, dza we mfwaa mumkpaŋ. Jiso tee le bɛ bichɛ fiee bɛ nyɛ wu ji. ");
INSERT INTO asj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Le ni bee tee ŋɛŋ fiee fi ka lɛ, wa tɛ̀ be. Jiso chiinsɛ le kiiŋ be ni tee li wi-i fiee fi ka fini kɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Dza teeŋ bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa le be banchɛ be bɛ. Nyɛ be buŋga bɛ dze le be ni be buushi bɛnchindaa bɛ kiŋkundi-i li bɛniiŋ li be wɔnchi mɔɔ chigɔŋ, ");
INSERT INTO asj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","biee toŋ be le be gɛɛŋ be ni be tiifi bɛniiŋ kii bumfɔŋ bu Nyɔ-ɔ, be wɔnchi tɛ mɔɔ bɛniiŋ bɛ chigɔ-ɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Se tee li bee le, “Si nɛ giiŋgi lɛ, kiiŋ wi ni dzɔɔ fiee kɛ. Kiiŋ wi ni dzɔɔ kimbaaŋ, kɛ babi, kɛ fiee fijɛ, mɔɔ nuuŋ kwa kɛ, kiiŋ wi ni dzɔɔ ndú fiɛɛtu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ɛ nɛ gɛɛŋ, yih chi yi nɛ lɛ lu, nɛ tsiiŋ lu nsiiŋ gɛɛŋ bo jobɛ chi nɛ dzɛti. ");
INSERT INTO asj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ɛ fɛ bɛ mɛɛŋ beŋ ki fi kɛ, nɛ dza fe, mfi wu nɛ dzɛti lɔɔ, nɛ kachɛ kiboŋ ki li bikaa binɛ-ɛ, se ni nuuŋ ŋkiki wu fiee fi be mɔŋ.” ");
INSERT INTO asj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Be se dza be giiŋgi be kɛti li bitooŋ, li bitooŋ, be tiifi ntoŋ wu dzeeŋ wu kii bumfɔŋ bu Nyɔ-ɔ, be wɔnchi mɔɔ bɛniiŋ bɛ chigɔŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Le Hɛrɔ wu tɛ̀ nuuŋ ŋgɔmina kimbɛ ki kwɛɛŋ lɛ ki Galilii woo biee bichu bi tɛ̀ kɛti, bi fieeŋgi wu kifɛ bɛniiŋ bamu tɛ̀ dza be kweŋgi le Jiso wuni nuuŋ Jɔɔŋ Nlisulidzɔɔ wu kaari wu bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bamu kweŋgi le ɛ Ɛlaja wu kaari wu bɛ. Bamu se kweŋgi fi bee le ɛ ntomfɔŋ wu Nyɔ wu ŋkosi wumu wu kaari wu bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛrɔ se bii laa, “Jɔɔŋ wuni ntuu ŋka kikoo kee. Wuni wi se tuu nuuŋ noo wu ŋ'wuki ŋwaani bini biee kii wu dɛɛni?” Se ba tuu gwenini le ŋɛŋ Jiso wulu. ");
INSERT INTO asj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Le bɔɔŋ bɛ nto-oŋ bɛ Jiso dɛndɛ be kaari be to lijiŋ, be tee wu biee bichu bi be fɛ. Se dza dzɔ be, be cheekiyi, be gɛɛŋ lɛ kitoŋ ki Besaida-a. ");
INSERT INTO asj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Se nuuŋ le, kiyaŋ ki bɛniiŋ lɛ tɛ̀ kɛɛ, ki biee wu. Se tuu bɛchi tiifi be kii bumfɔŋ bu Nyɔ-ɔ wɔnchi mɔɔ bɛniiŋ bɛ chigɔ-ɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Le jobɛ bɛchi chi ni chi sechi, bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ bɛfɛ baa kiiŋgi be tee li wuu le, “Tee li bɛniiŋ bani-i le be gɛɛŋ li bitoŋ bɛ bɛla bɛ nuuŋ tsɛkɛtsɛkɛ, be bichɛ biee bijɛ mɔɔ bintsii bi tsɛ, kifɛ fɛni fɛɛ fɛtɔɔ.” ");
INSERT INTO asj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jiso tuu fiee le, “Ɛ beŋ nɛ gii nɛ nyɛ be biee bijɛ.” Be tuu li wuu le, “Fiee fi tɛ kɛmi ɛ nɛɛ tsée yi bibele shiŋ bɛ nsúuŋ fiɛɛtu kwaa, fi fiɛɛ le ɔ wɛki le tɛ gɛɛŋ tɛ go biee bijɛ tɛ bɛ tɛ nyɛ li bɛniiŋ bani bɛchu ni?” ");
INSERT INTO asj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Be tɛ̀ tiiti lɛ kifɛ bɛniiŋ tɛ̀ yaŋ fe ŋge, ɛ buniŋ kwaa tɛ̀ giiŋgi li bɛnchuki bɛtiinu. Jiso tuu tee li bɔɔŋ bee bɛ kintutu-u le, “Tee yɛɛŋ li bɛniiŋ bɛlu-u le be shee yɛ fɛkwiiŋ li bintutu-u li bintutu-u, si mbaanshiŋ mbaanshiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Be tee, be shee yɛ fɛkwiiŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jiso fi tsée yi bibele yi shiŋ yɛɛ, bɛ nsúuŋ yi fiɛɛtu yɛɛ, bichɛ liwe, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ nyɛ li bɔɔŋ bee bɛ kintutu le be gachɛ li kiyaŋ ki bɛniiŋ lɛ kɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Be se gachɛ, li kiyaŋ ki bɛniiŋ lɛ kilu-u kichu, be ji be fukɛ. Bɔɔŋ bɛ Jiso bɛ kintutu-u banchɛ muŋkɛ mu tɛ̀ weyɛ mwɛɛ, mu yisɛ bɛŋkaa yoofi ntsɔ bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jobɛ chimu le Jiso ni lɛki li Nyɔ-ɔ wuu mbiiŋ, bɔɔŋ bee bɛ kintutu bɛ li wuu lichiŋ. Se dza bii li bee laa, “Bɛniiŋ tiiti le ɛ mi noo?” ");
INSERT INTO asj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Be tuu li wuu le, “Bɛniiŋ bamu kweŋgi baa le ɛ wɛ Jɔɔŋ Nlisulidzɔɔ, bamu le Ɛlaja bamu se kweŋgi le ɛ wɛ ntomfɔŋ wu Nyɔ wu ŋkosi wumu wu kaari wu bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Se tuu bii li bee laa, “Beŋ kibɛɛ nɛ kweŋgi finɛ le ɛ mi noo?” Pita tuu le, “Ɛ wɛ Kinsofu ki Nyɔ tɛ̀ kaachɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jiso se bɔsɛyi chiinsɛ li bee le kiiŋ be ni mɔŋ be tee fini li wi-i kɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Se tuu tee li bee le, “Ŋwanɛwi kɛmi le ŋɛŋ bumfa ŋge, bɛniiŋ bɛ sɛki kwɛɛŋ bee bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ gii be se faaŋ wu. Be gii be wo wu, ke jo ka taa, Nyɔ se kaari yi buu wu li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jiso se dza tee li bɛniiŋ bɛchu-u le, “Ɛ wi wɛki le ni nuuŋ wi wɛŋ, kɛ mwɛɛ kɛmi le faaŋ yi yee, ni tuuti kintaaŋ kee jo chichi biki mi. ");
INSERT INTO asj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kifɛ, wi wu bachi ntsɛ we kii wu ni la, kɛ gii lɛɛ ntsɛ wulu. Se nuuŋ le, wi wu lɛɛ ntsɛ we kii mi, kɛ mwɛ gii kɛmɛ ntsɛ wulu. ");
INSERT INTO asj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ɛ bɛ banchɛ nshɛ yini chichi, bɛ nyɛ li wi-i wu ji wu tuu wu lɛɛ ntsɛ we mbeŋ wulu ni nuuŋ la? ");
INSERT INTO asj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɛ kɛɛ le wi wu nuuŋ bɛ buya le biee mi mɔɔ jɛ yɛŋ, mwɛ kɛɛ le, Ŋwanɛwi gii naa nuuŋ bɛ buya tɛ mfi wu wu kaari wu bɛ li bunɔŋa bu Tee lɛ bɛ bu bɛnchindaa bee bɛ waaŋ li. ");
INSERT INTO asj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ntee beŋ chɛɛŋ le, bɛniiŋ bamu lemi baa fɛni bɛ nuuŋ tɛ naa woo kintsi ki kwe-e fuki fɛ be ŋɛŋ si Nyɔ sɛki bumfɔŋ bu yi-i nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tɛ̀ giiŋgi li jo nyaaŋ li, fɛ Jiso tɛ̀ tee biee bini, se dzɔ Pita bee Jɔɔŋ mɔɔ Jeeŋ le bee be yɛɛ li ŋkumɛ wumu le be lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Le ni lɛki li Nyɔ-ɔ, mfisɛ yee dza yi fiiki, ndú yee fiiki yi bɛndi, yi miɛŋini ni mwamwamwa. ");
INSERT INTO asj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Fi se ka le buniŋ bamu bɛfɛ tɛ̀ nuuŋ fe be tiiti biee bɛ wu. Be tɛ̀ nuuŋ Mɔɔsɛ bee Ɛlaja. ");
INSERT INTO asj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kiŋ'wofu ki Nyɔ-ɔ woo li bee. Bee be tiiti kii kwe yi Jiso tɛ̀ kɛmi le gɛɛŋ kwi Jɛrosalɛŋ fi bɛ fi kɔchɛ si Nyɔ tɛ̀ gɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Be tɛ̀ tiiti lɛ, ɛ Pita bee Jɔɔŋ mɔɔ Jeeŋ tɛ̀ geki chilefɛ chi bee. Le be kaaŋgi, be ŋɛŋ si kiŋ'wofu ki Nyɔ-ɔ woo li Jiso-o, be ŋɛŋ mɔɔ buniŋ bɛfɛ be lemi bɛ wu. ");
INSERT INTO asj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mfi wu bɛniiŋ bɛ bɛfɛ bɛlu tɛ gatɛ bɛ Jiso, Pita se dza taa tee li Jiso le, “Te Kikoo, fi dzɔɔŋ fiɛɛ si tɛ baa fɛni ni. Tɛ gwaŋ bigɔɔnu bitɛɛtu, kimu ni ki nuuŋ ko, kimu ki Mɔɔsɛ, kimu se ni ki nuuŋ ki Ɛlaja.” Tɛ̀ tiiti lɛ, tɛ kɛɛ fiee fi tiiti kɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fɛ gii mɛɛŋ yeti lɛ, kikuŋ bɛ lɛ bee lɛwe ki baanyɛ be. Be tɛ̀ kɛmɛ jaaŋ li kikuŋ kilu linti. ");
INSERT INTO asj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jɛ se yɔ li kikuŋ kilu le, “Wuuŋ Ŋwanɛŋ wu mi ntsaa. Nɛ wuki yɛɛŋ li wuu.” ");
INSERT INTO asj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Le jɛ yilu chikɛ n'yɔru, be dza be ŋɛŋ si Jiso lemi fe wuu mbiiŋ. Be ba nshiiŋ, be mɛɛŋ ki tee kɛ wi fiee fi ka li mfi wɛɛ li kumɛ wɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Le butuu woo, Jiso dza bee be li ŋkumɛ-ɛ be bɔɔ. Le be ni be beki, be bikɛ bɛ kintutu ki bɛniiŋ lɛ ki nɔŋa. ");
INSERT INTO asj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Le be bichɛ, be ŋɛŋ si wumu li kintutu kɛɛ dza wu waŋ le, “Wi wu ntiifɛ, mi nsooŋ ɔ bɔ li wɛ-ɛ, bichɛ lɛ ŋwanɛŋ. Ɛ wu kwaa wu nuuŋ ŋwanɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yikɛ ɔ woo, fiana yimi dzɛti yi choofi wu, yi lendi wu fɛkwiiŋ, dzakini kɛɛti, sukini bɛ fin'yuusɛ, bɛfuu buti wu lɛwa. Yi giiŋgi bɛ wu, yi tɛ beŋ le yindɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mbee nlɛkɛ le bɔɔŋ bo bɛ kintutu buu fiana yilu be mɔŋ nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Le Jiso woo lɛ, tee le, “E ee! Kiŋgɔkɛ ki lɔɔlɔɔ ki mɛɛŋ ki gɛɛ kɛ shéŋ li Nyɔ-ɔ kɛ kini. Ŋgii nuuŋ bɛ beŋ ŋgɛɛŋ mbo buŋ, ŋkaŋ shéŋ bɛ beŋ ŋgɛɛŋ mbo buŋ?” Se tuu tee li te ŋwaŋ wulu le, “Bɛ bɛ ŋwana fɛni.” ");
INSERT INTO asj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dzɔ ŋwaŋ wulu bɛ bɛ wu, kiŋkundi kilu tuu ki chofi ŋwaŋ wulu ki toŋ fɛkwiiŋ, bɛchi kakini. Jiso waŋ fiana yi tii yilu yi bo li ŋwaŋ wulu-u, se tɛmi. Jiso se nyɛ wu li tee li. ");
INSERT INTO asj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bɛniiŋ bɛchu ŋɛŋ buŋga bu nuuŋ bu Nyɔ-ɔ, wa tɛ be. Bɛniiŋ bɛchu mɛɛŋ be beechi biee bichu bi Jiso tɛ̀ feti, se dza tee li bɔɔŋ bee bɛ kintutu-u le, ");
INSERT INTO asj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Jɛ yini seri li bintooŋ binɛ-ɛ li fiee fi ŋgii ntee li be-eŋ fini. Bɛ gii bɛ nyɛ Ŋwanɛwi li tsaŋ yi bɛniiŋ bamu-u.” ");
INSERT INTO asj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Le tee lɛ, be mɛɛŋ ki kɛɛ kɛ fiee fi tɛ̀ tee lɛ kɛ, kifɛ fiee fimu tɛ baŋgi le be kɛɛ kɛ, le fi nuuŋ lɛ, be chɛŋ mbifu li wu kii tefɛ chilu. ");
INSERT INTO asj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Be tɛ̀ dza be bɛchi bitɛchinɛ li yih yi bee laa, si tɛ nuuŋ ni, ɛ noo wu nuuŋ wi wu nyɔŋa lɛ bee li lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jiso kɛɛ fiee fi be beechi li shéŋ yi bee, se dzɔ ŋwaŋ wu bwi leeki fɛ wuu fɛ chiŋ, ");
INSERT INTO asj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tee li bee le, “Ɛ wi fii ŋwaŋ si wuni li bukooŋ bweeŋ, kɛ wu fiiɔ tɛ nuuŋ mi. Wi wu fi mi, kɛ mwɛ fiɔ tɛ nuuŋ wi wu tɛ̀ toŋ mi. Fi se fiɛɛ le, wi wu guundi lɛ beeŋ lɛnti ɛ wu, wu nuuŋ wi wu nyɔŋa.” ");
INSERT INTO asj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔɔŋ se dza teeŋ Jiso, be tee li wuu le, “Te Kikoo, tɛ bee tɛ ŋɛŋ wumu busi bɛnchindaa bɛ kiŋkundi-i li yi yi bɛniiŋ li li bukooŋ bwo-o, tɛ wamɛ wu, kifɛ ti nuuŋ yɛ wi wu kintutu kisɛŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jiso tuu fiee le, “Kiiŋ nɛ ni loosɛ wɛɛ wi kɛ, kifɛ ɛ wi baanini yɛ beŋ kɛ, kɛ mwɛ wɛ wi wunɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Fɛ mfi tɛ̀ bɛ kɔchɛ wu Nyɔ tɛ̀ wɛki le yi dzɔɔ Jiso le yi yɛɛ bɛ wu liboo, Jiso sɔnɛ le gii gɛɛŋ Jɛrosalɛŋ, se dza ŋgɛnu. ");
INSERT INTO asj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Le ni dzɛti, toŋ bɛniiŋ bamu limfwe. Be gɛɛŋ be lɛ li kitoŋ kimu ki Samaaria le be nachɛ kintsii fe li wuu. ");
INSERT INTO asj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bɛniiŋ bɛlu faaŋ bɛ kintsii le be fii yɛ wu kɛ, kifɛ be tɛ kii waaŋ le kɛtɔɔ giiŋgi nuuŋ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jeeŋ bee Jɔɔŋ bɔɔŋ bɛ Jiso bɛ kintutu woo fiee filu, be bii li wuu laa, “Taa, ɔ wɛki le tɛ teeŋ wi li liboo wu shee wu duuri bɛniiŋ bani ni?” ");
INSERT INTO asj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jiso tuu fiiki wamɛ be, ");
INSERT INTO asj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","bee be dza be gɛɛŋ li kitoŋ kimu ki dee. ");
INSERT INTO asj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Si be gii be giiŋgi lɛ dze lɛ, nyuŋ wumu se kweeŋ li Jiso le, ŋgii ni mbiki wɛ mɔɔ ɔ giiŋgi fɛŋ le. ");
INSERT INTO asj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jiso tuu li wuu le, “Bijinu kɛmi ntuuŋ yi bi, muniiŋ mu jiindi liwe kɛmi yíh yi mu, se nuuŋ le Ŋwanɛwi kɛmi yɛ mɔɔ fɛ nuuŋ gɛɛ kikoo kee fe kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jiso se dza tee li nyuŋ wumu le, “Ɔ biki mi.” Mwɛ se tuu le, “Taa, gɛɛ mi nsaa ŋgɛɛŋ ndiyɛ taa kwɛ nse mbiee wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Se nuuŋ le, Jiso tɛ tuu li wuu le, “Gɛɛ bɛniiŋ bɛ kwiyɛ ni be diyi biŋkwi bi bee. Li wɛ-ɛ, gɛnɛ fio ɔ ni ɔ tiifi kii bumfɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wi wumu tuu tee le, “Taa, ŋgii ni mbiki wɛ, se nuuŋ le, gɛɛ mi nsaa ŋgɛɛŋ n'yɛsi kini keŋ kwɛ nse mbiee wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jiso se tuu li wuu le, “Ɛ wi guumɛ bɛ jii le niŋ nimɛ, mwɛ se tuu nindi bichi lɛjiŋ, kɛ mɛɛŋɔ ki kɔchɛ kɛ le ni nuuŋ lɛ bumfɔŋ bu Nyɔ-ɔ lɛnti kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lɛjiŋ lɛlu, Taa tsaa bɛniiŋ bamu gwii mfomɛnyaaŋ ntsɔ bɛfɛ toŋ be limfwe, bɛfɛ bɛfɛ le be gɛɛŋ li bitoŋ li mɔɔ li bintsii bi gii nuuŋ li gii gɛɛŋ li. ");
INSERT INTO asj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Le ni tundi be, tee le, “Ŋ'wechɛ yaŋ ɔ ŋge se nuuŋ le, bɛniiŋ bɛ ŋ'wechɛ-ɛ sendɛ. Bɛdɛɛni, lɛkɛ yɛɛŋ li Nyɔ-ɔ yi Te Ŋ'wechɛ-ɛ le yi tuumi bɛniiŋ bɛ ŋ'wechɛ-ɛ li wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɛ giiŋgi yɛɛŋ. Yikɛ yɛɛŋ nɛ woo si nɛ giiŋgi lɛ, nɛ kɛɛ le mi ntoŋɔ beŋ le nɛ gɛɛŋ nuuŋ si bɔɔŋ bɛ nshɔ́ɔŋ lɛ lɛ bɛmbɔɔŋku lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Si nɛ giiŋgi lɛ, kiiŋ wi ni dzɔɔ babi wu kwa, mɔɔ babi, mɔɔ nuuŋ bikpɔ bimu kɛ. Ɛ nɛ bo lɛ dze, kiiŋ nɛ ni nɛ lemi nɛ yɛɛshi bɛniiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ɛ nɛ gɛɛŋ, yih chi yi nɛ lɛ lu, nɛ saa nɛ yɛsi bɛniiŋ bɛ li yih yilu le, ‘Mbɛɛŋgii nuuŋ bɛ yih yini’ ");
INSERT INTO asj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɛ wi wu kɔŋgisi mbɛɛŋgii nuuŋ lu, mbɛɛŋgii wunɛ ba li wi wulu. Ɛ wu foo lu nsiŋ wu kaari wu to li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mfi wu nɛ lɛ li yih, nɛ ba nɛ tsiiŋ lu, nɛ dɛndɛ kɛ li yíh li yíh kɛ, nɛ jii nɛ wundi fiee fichu fi bɛ nyɛ li be-eŋ, kifɛ wi wu nindi nimɛ kɛmi le kɛmɛ kinsomfu kee. ");
INSERT INTO asj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ɛ nɛ lɛ li kito-oŋ, bɛ fi beŋ, nɛ jii fiee fichu fi bɛ nyɛ le nɛ ji. ");
INSERT INTO asj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Fɛ nɛ nuuŋ fe, nɛ wɔnchi bɛniiŋ bɛ chigɔ-ɔŋ, nɛ tiiti li bɛniiŋ bɛlu-u le bumfɔŋ bu Nyɔ-ɔ bwɛɛ tsɛkɛtsɛkɛ li bee. ");
INSERT INTO asj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Se nuuŋ le, ɛ nɛ lɛ li kito-oŋ, bɛ faaŋ le bɛ fii yɛ beŋ kɛ, nɛ bo nɛ gɛɛŋ lɛ dzé ntasɛ nɛ dzaaŋ le, ");
INSERT INTO asj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kiboŋ ki li kitoŋ kinɛ-ɛ ki tɛ dzɔ li bikaa bisɛŋ kini, kiiŋ ki, ki tɛ̀ kachɛ le fiee fichu kaari fi to li bikoo binɛ-ɛ. Se nuuŋ le, nɛ kɛɛ le bumfɔŋ bu Nyɔ-ɔ bɛɛ bwɛɛ tsɛkɛtsɛkɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ntee beŋ le, naa nuuŋ bu nsa wu kimɛrisɛ biee dzɔɔŋ bɛ Sɔdɔŋ yaa kwɛɛŋ wɛɛ.” ");
INSERT INTO asj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jiso dza tee le, “Ŋgɛ wu nyɔŋa wɛ wunɛ beŋ bɛniiŋ bɛ Korasiŋ, ŋgɛ wu nyɔŋa wɛ tɛ wunɛ beŋ bɛniiŋ bɛ Besaida. Nɛ kɛɛ le, gii nuuŋ le mfɛ bintɛwa bi biee lɛ bi ntɛ̀ mfɛ li be-eŋ bini nuuŋ li kwɛɛŋ wu Tayɛ bee Sidɔ-ɔŋ, bee nuuŋ dɛɛŋ be tɛ fiiki shéŋ yibe, be liishɛ ndú yi kwe, be fwa taŋɛ li bwiŋ kichu le be doonchɛ le be fiiki baa shéŋ yibe. ");
INSERT INTO asj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Se nuuŋ le, naa nuuŋ jobɛ chi nsa wu lɛ kimɛrisɛ-ɛ biee gii bi dzɔɔŋ li Tayɛ-ɛ mɔɔ Sidɔŋ jobɛ chilu yɛki binɛ. ");
INSERT INTO asj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mɔɔ beŋ bɛniiŋ bɛ Kapanuŋ, nɛ beechi le bɛ gii bɛ yɛɛki beŋ nɛ yɛɛ liboo ni? Wohoo, bɛ gii naa bɛ lɔŋ beŋ li kwɛɛŋ wu bɛŋku-u.” ");
INSERT INTO asj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jiso tuu tee li bɔɔŋ bee bɛ kintutu-u le, “Ɛ wi woo beŋ, kɛ mwɛ wooɔ nuuŋ mi. Wi wu faaŋ beŋ, kɛ mwɛ faaŋ ɔ nuuŋ mi. Ɛ wi faaŋ mi, kɛ mwɛ faaŋ ɔ tɛ nuuŋ wi wu tɛ̀ toŋ mi.” ");
INSERT INTO asj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bɛniiŋ bɛ gwii mfomɛnyaaŋ ntsɔ bɛfɛ baa tɛ̀ kaari be to lijiŋ bɛ kinɛɛtinɛ, be se tee li Jiso-o le, “Taa, mɔɔ bɛnchindaa bɛ kiŋkundi-i bee be wuki li bee li fɛ tɛ teenyi bukooŋ bwo.” ");
INSERT INTO asj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jiso tuu li bee le, “Mbee ŋɛŋ si Sataŋ dza liboo wii lɛkwiiŋ si dzaaŋ yi lɛɛbi liboo. ");
INSERT INTO asj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bichɛ yɛɛŋ, mi nyɛɔ beŋ buŋga kituŋ le nɛ ni nɛ dɛnchi yɔ́ bɛ bibobu. Mi ntuu mi nyɛ beŋ buŋga le nɛ yaa buŋga bu Sata-aŋ wu wi wu mbani buchu. Fiee nuuŋ fi tɛ koŋ li be-eŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Se nuuŋ le, kiiŋ nɛ ni nɛ nɛki le bɛnchindaa bɛ kiŋkundi-i wuki baa li be-eŋ kɛ. Nɛ nɛki yɛɛŋ nuuŋ le bɛ tsɛɛ baa mɛŋkooŋ mɛnɛ lɛ Kiŋwaati ki Nyɔ-ɔ ki liboo.” ");
INSERT INTO asj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nɛɛ li mfi wulu-u, Fiana yi Waaŋ fɛ Jiso nɛɛtɛ ŋge. Se biee tee le, “Nyɛɛɔ kiyɔɔni li wɛ Taa Mfɔŋ wu kiboo bɛ nshɛ le ɔ nyikɔɔ biee bini li bɛ bufii lɛ mɔɔ li bɛ ŋkɛɛ ŋge li, ɔ se doonchɛ nuuŋ li bɔɔŋ bɛ bwi-i. Ɛ lɛ Taa, kifɛ fi nuuŋ fiɛɛ si ɔ tɛ̀ kɔŋgisi.” ");
INSERT INTO asj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jiso tuu kweeŋ le, “Taa nyɛɔ biee bichu li mi-i. Wi nuuŋ yɛ lu wu kii Ŋwaŋ fuki Tee nsiŋ kɛ. Wi se nuuŋ yɛ lu tɛ wu kii Taa, fuki mi Ŋwani nsiŋ bɛ bɛniiŋ bɛ Ŋwani tsaa le doonchɛ wu li bee nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Se dza fiiki yi kweeŋ li bɔɔŋ bee bɛ kintutu-u le, “Kinɛɛtinɛ ki kinɔŋa kɛɛ kinɛ le lii yinɛ ŋiŋgi yɛɛ biee bini. ");
INSERT INTO asj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nɛ kɛɛ le bɛntomfɔŋ bɛ Nyɔ-ɔ bɛnɔŋa bɛ bɛmfɔŋ wɛki baa le be ŋɛŋ biee bi nɛ ŋɛŋ bini, be se tɛ ŋɛŋ kɛ. Be dii baa tɛ le be woo biee bi nɛ wuki bini, be se tɛ woo kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Fi dza fi ka le wi wumu wu tɛ̀ gbɛŋgi kii bɛnchi bɛ Nyɔ-ɔ, tɛ̀ dza bɛ le mɔnchɛ Jiso. Mwɛ bii li wuu laa, “Wi wu ntiifɛ, ɛ la fi nuuŋ mfɛ nse ŋkɛmɛ ntsɛ wu kimakɛ?” ");
INSERT INTO asj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jiso se bii li wuu laa, “Ɛ la fi bɛ tsɛɛ lɛ kiŋwaati ki Nyɔ ki bɛnchi-i? Ɔ teenyi ɔ wuki le la?” ");
INSERT INTO asj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mwɛ tuu le, “Bɛ tsɛɛ baa le, ‘Ɔ kɔŋgisi Taa Nyɔ ya bɛ shéŋ ya chi, mɔɔ bɛ ntsɛ wa kwi, ɔ nindi li yi-i bɛ buŋga bwo buchu, ɔ gɛɛ bufii bwo buchu li yi-i, ɔ kɔɔŋgi tɛ ŋwaana si ɔ kɔŋgisi yi ya.’” ");
INSERT INTO asj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jiso se tee li wuu le, “Ntusu wa wɛ bujɔŋ. Ɔ feti lɛ, ɔ se kɛmɛ ntsɛ wu kimakɛ.” ");
INSERT INTO asj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wi wulu tɛ̀ dza wɛki le doonchɛ le ɛ wu nyuŋ bii li Jiso laa, “Ɛ noo wu nuuŋ ŋwaanɛŋ?” ");
INSERT INTO asj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jiso tuu nuuŋ lɛ ŋgaŋgaa li le, “Nyuŋ wumu tɛ̀ dza Jɛrosalɛŋ beki Jɛriko, le ni giiŋgi lɛ li tsaŋ yi bɛyi-i be too wu shɛ niiŋ le kwi be buushɛ wu ndú be fi mɔɔ biee biee bichu be dza be lɔŋ wu fe. ");
INSERT INTO asj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fi dza fi ka le, te muntofi wu Nyɔ wumu tɛ̀ beki lɛ dze yilu-u, le ŋɛŋ wi wulu, saŋ dze yi je. ");
INSERT INTO asj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wumu dza tɛ bɛɛ nuuŋ wi wu li kini ki Lebi, le bo fe, gɛɛŋ lɛ wuu lɛwe ŋɛŋ wu, wɛɛŋ ka tɛ dze yi je. ");
INSERT INTO asj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Se nuuŋ le, wi wumu tɛ deŋgi tɛ bɛɛ lɛ dze yilu, nuuŋ wi wu Samaaria. Le bɛ bo fe ŋɛŋ wu nshiiŋ kɔɔ wu bɛ mwɛ. ");
INSERT INTO asj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gɛɛŋ lɛ wuu lɛwe, gɛɛ mbiiŋ bɛ mɛɛŋ li bibaa biee li, kaŋ bibaa bilu bɛ nshɛŋgɛ yi ndu, biee too wu lɛ nyaŋ ye lɛwe, gɛɛŋ bɛ wu fɛ yih yi bɛniiŋ bɛ ndɛndɛ-ɛ ti fufini fe bichi lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bee wu tsi le bu woo, buu bɛdanali bɛfɛ nyɛ li wi wu yih wulu-u tee li wuu le, ‘Shɛ ɔ ni ɔ bichi lɛ wi wuni. Ɔɔ shɛ ɔ bifii kwa wu ka, ke mi ŋkaari ntuu li wɛ-ɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Le Jiso wa ŋgaŋgaa chilu lɛ, biee bii li wi wu tɛ gbɛŋgi kii bɛnchi wɛɛ laa, “Li bɛniiŋ bɛ bɛtɛɛtu bani, ɔ ŋɛŋ fio le wi wu tɛ̀ doonchɛ le nuuŋ ŋwaani wi wu bɛyi tɛ̀ too wɛ nuuŋ wu la?” ");
INSERT INTO asj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tuu le, “Tɛ̀ nuuŋ wi wu tɛ̀ kɔɔ nshiiŋ bɛ wi wu bɛyi tɛ̀ too wɛ.” Jiso se biee tee li wuu le, “Gɛnɛ, ɔ ni ɔ feti tɛ lɛ.” ");
INSERT INTO asj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jiso bee bɔɔŋ bee bɛ kintutu-u dza be giiŋgi, be gɛɛŋ be lɛ li kitoŋ kimu-u, kwɛɛŋ wumu nuuŋ fe bɛ teenyi wu le Maata. Fi Jiso li wuu yih. ");
INSERT INTO asj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tɛ̀ kɛmi ŋwaani wumu bɛ teenyi le Maariya. Le Jiso gɛɛŋ lɛ lu, Maariya biee gɛɛŋ shee li wuu lichiŋ yiki fiee fi Jiso tɛ tiifi. ");
INSERT INTO asj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maata tuu nyɛ ŋgeeŋ ye nuuŋ lɛ ntɛwuu. Dza gɛɛŋ bii li Jiso laa, “Taa, ɔ mɛɛŋ ki ŋɛŋ kɛ le ŋwaanɛŋ chinɔɔ mi mbuki yi bɛ bufɛ mi-i mbiiŋ, ɔ tɛ dzɔ li fiee li kɛ ni? Tee nɛɛ li wuu le bɛ fi mi lu.” ");
INSERT INTO asj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Taa tuu li wuu le, “Maata, Maata, ɔ nyɛɔ ŋgeeŋ lɛ biee bi ŋgee, ");
INSERT INTO asj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nuuŋ fiee fiɛɛ lu fimumkpaŋ kwaa fi bɛ wɛki. Maariya tsaaɔ nuuŋ fiee fi dzeeŋ fi bɛ nuuŋ tɛ naa fi li wuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tɛ̀ nuuŋ jobɛ chimu, Jiso lɛki li Nyɔ-ɔ fɛ kintsii kimu-u, le lɛkɛ mɛɛshi, ŋwani wu kintutu wumu tee li wuu le, “Taa, tifi bee si bɛ lɛki li Nyɔ-ɔ, nɛɛ si Jɔɔŋ tɛ̀ tifi bɛniiŋ bee bɛ kintutu le be ni be lɛki li Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jiso se tee li bee le, “Ɛ nɛ lɛki li Nyɔ-ɔ, nɛ tiiti le, ‘Taa wusɛŋ, fɛrɛ le bɛniiŋ ni be guundi bukooŋ bwo, ɔ fɛ le bumfɔŋ bwo bɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɔ nyɛɛ bee biee bijɛ jo chichi, ");
INSERT INTO asj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ɔ feeki bee bibifi bisɛŋ, si tɛ ti feekisi bibifi bi bɛniiŋ bamu feti li bee li. Kiiŋ ɔ ni chinɛ le bɛ mɔnchɛ yaa bee kɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Si tɛ tee lɛ, se biee maa li bee le, “Dzɔ yɛɛŋ le wumu lɛ be-eŋ lɛnti bee dza wu gɛɛŋ wu koŋ sini kigoo butuu taantaaŋ kweŋgi le, ‘Sinɛŋ, dzatsɛ we ɔ fɔɔ mi tsée yi bunɛɛŋ shɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Sinɛŋ wumu taaɔ wu la ŋka lɛ mi-i, ŋkɛmi yɛ fiee fi nuuŋ nyɛ wu le ji kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nsaŋ ye yilu gii yi tuu fiee le, ‘Ɔ mi fieeŋgi kɛ. Tɛɛ bɔɔŋ beŋ tɛ giŋ baa kituŋ tɛ bɛŋɛ kigoo. Nnuuŋ ntɛ̀ ndza we le ntuu ŋgɔɔŋ fiee le nyɛ wɛ kɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Le Jiso maa lɛ, tuu tee le, “Ntee beŋ le ɛ mɛɛŋ we ki dza kɛ le nyɛ wu bijɛ kifɛ ɛ wu sini, kɛ gii nɛɛ dza we nyɛ wu fiee fichu fi kɔŋgisi fɛ wu ba fe kundi mfiɔŋu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nse ntiiti li be-eŋ le, nɛ biiti yɛɛŋ, Nyɔ gii yi nyɛ beŋ. Nɛ geendi yɛɛŋ, Nyɔ gii yi fɛ nɛ ŋɛŋ. Nɛ kundi yɛɛŋ kigoo, Nyɔ gii yi gwiyɛ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nɛ kɛɛ le wi kwikwi wu biiti, gii kɛmɛ, wi kwikwi wu wɛki, gii ŋɛŋ, wi wu kundi kigoo, bɛ gii bɛ gwiyɛ li mwɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ɛ te ŋwaŋ wu la lɛ be-eŋ lɛnti wu ŋwani nuuŋ bii wu nsuuŋ, se tuu nyɛ wu nuuŋ yɔ? ");
INSERT INTO asj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mɔɔ ɛ ŋwaŋ bee bii wu giki nyɛ wu nuuŋ kibobɛ le? ");
INSERT INTO asj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɛ beŋ bɛ nuuŋ bɛniiŋ bɛ bifi ti kii si bɛ nyɛɛ biee bi dzeeŋ li bɔɔŋ bɛnɛ-ɛ, Baa wunɛ wu nuuŋ liboo gii se lee ki nyɛ kɛ tɛ Fiana yi Waaŋ li beŋ nɛ biiti li wuu yɛki lɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jiso tɛ̀ buu ŋwanɛ kiŋkundi li wumu wu tɛ̀ nuuŋ kinchiinchii. Le ŋwanɛ kiŋkundi wulu bo, wi wulu se bɛchi n'yɔru. Le kintutu ki bɛniiŋ lɛ ŋɛŋ lɛ, wa tɛ be. ");
INSERT INTO asj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Se nuuŋ le, bɛniiŋ bamu bɛchi be kweŋgi le, “Busɔɔ bɛnchindaa bɛ kiŋkundi-i nuuŋ bɛ buŋga bu Bɛɛsɛbu-u wu nuuŋ mfɔŋ wu bɛnchindaa bɛ kiŋkundi-i.” ");
INSERT INTO asj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bɛniiŋ bamu tɛ̀ wɛki le be terɛ Jiso, be tee li wuu le fɛ mfiŋ yi doonchi buŋga bu buti liboo. ");
INSERT INTO asj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Se nuuŋ le Jiso kɛɛ bɛmbeechɛ bɛ bee se tuu tee li bee le, “Ɛ kitoŋ dza ki gatɛ ki tuu ki gwii li yi yi kii, kɛ ki nuuŋ tɛ leŋ kɛ. Ɛ kini dza ki gatɛ ki gwii li yi yi kii, kɛ ki gii ki shaanshɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Fi fiɛɛ tɛ le ɛ Sataŋ bee kintutu kee dza be tuu be gatɛ be gwii li yi yibe-e, bumfɔŋ bwee tɛ̀ naa leŋ tɛ kɛ. Ntiiti ni kifɛ nɛ kweŋgi baa le mbusɔɔ bɔɔŋ bɛ kiŋkundi-i nuuŋ bɛ buŋga bu Bɛɛsɛbu-u. ");
INSERT INTO asj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ɛ fi nuuŋ le mbusi bɔɔŋ bɛ kiŋkundi-i nuuŋ bɛ buŋga bu Bɛɛsɛbu-u, bɔɔŋ bɛnɛ se busi tɛ nuuŋ bɛ buŋga bu noo lɛ? Fiee fi bɔɔŋ bɛnɛ bɛlu feti doonchɛ fiɛɛ le nɛ we baa nsa kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Se nuuŋ le, ɛ mbusi bɛnchindaa bɛ kiŋkundi-i bɛlu nuuŋ bɛ kibɛnɛ ki Nyɔ-ɔ, kɛ bumfɔŋ bu Nyɔ-ɔ bɛ bwɛɛ kituŋ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ɛ wi wu buŋga nachɛ biee biee bi dzi-iŋ, wu shee kiichi la we, wi nuuŋ tɛ koŋ li fiee fiee li kɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Se nuuŋ le, ɛ wi buŋga wumu wu yɛki wu bɛ wu gwe wu yaa wu, gii se lɔ biee biee bi dziŋ bi baŋgi yi yee lu biɛɛ, se kotɛ biee biee bichu gɛɛŋ bɛ bi bee nsáŋ yee gachɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ɛ wi nuuŋ yɛ kimbɛ keŋ kɛ, kɛ mwɛ baaninɔɔ mi. Ɛ wi fii yɛ mi li mbanchɛ-ɛ kɛ, kɛ mwɛ tɛɛtɔɔ bu tafu. ");
INSERT INTO asj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Fiana yi tii ti buti li wi-i yi gɛɛŋ li buka yi wɛki kintsii ki tsɛ. Se nuuŋ le ɛ yi tuu yi gɔɔŋ nsiŋ, yi kweeŋ li yi yee li le, ‘Ŋgii ŋkaari nto li mi-i yih lu ntuu mbo.’ ");
INSERT INTO asj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mfi wu yi kaari yi ŋɛŋ yih ɛ bɛ fweyɛ bɛ nachɛ yi wuuti waaŋ, ");
INSERT INTO asj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","bɛdɛɛni yi tuu yi kaari yi gɛɛŋ, yi bɛ bɛ fiana yi tii yimi mfomɛnyaaŋ yi biiti yi yɛki yi, bee yí se tuu be lɛ be tsiiŋ lu. Biee mɛɛshi bi bee bɛ mwɛ li mfi wulu yɛki si tɛ̀ shiiŋ nuuŋ ŋkosi.” ");
INSERT INTO asj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Si Jiso tɛ̀ mɛɛŋ yeti lɛ, kwɛɛŋ wumu li kimbanchɛ ki bɛniiŋ lɛ kɛɛ tɛ dza kweeŋ le, “Kinɛɛtinɛ ki kinɔŋa kɛɛ ki kwɛɛŋ wu tɛ̀ biɛ wɛɛ, mɔɔ li mbeeŋ yɔɔ tɛ̀ yaaŋ li.” ");
INSERT INTO asj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jiso tuu fiee nuuŋ le, “Kinɛɛtinɛ ki kinɔŋa kɛɛ nuuŋ ki bɛniiŋ bɛ wuki jɛ yi Nyɔ be feti si yi wɛki.” ");
INSERT INTO asj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Le kintutu ki bɛniiŋ lɛ ni ki banchi ki bɛɛ li Jiso lichiŋ, dza tee le, “Kiŋgɔkɛ ki dɛɛni kini nuuŋ ki bifi. Ki wɛki le ki ŋɛŋ mfiŋ yi doonchi buŋga bweŋ, bɛ nuuŋ tɛ doonchɛ li ki-i kɛ. Se nuuŋ le mfiŋ yi tɛɛmi nuuŋ yɛ lu yi yɛki yi Ntomfɔŋ wu Nyɔ wu Jɔna kɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Si Jɔna tɛ̀ nuuŋ ŋkiki li bɛniiŋ bɛ Ninibɛ-ɛ lɛ, ɛ nɛɛ lɛ si Ŋwanɛwi wɛ ŋkiki li kiŋgɔkɛ ki bɛniiŋ bɛ dɛɛni kini. ");
INSERT INTO asj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Gii naa ni nuuŋ jobɛ chi nsa wu kimakɛ-ɛ, Yaa wu tɛ̀ sɛki kitoŋ ki Shɛba leŋ bɛ kiŋgɔkɛ ki dɛɛni kini, fɛ le bɛ lii ki li ŋgɛ-ɛ, kifɛ tɛ̀ gii dzɛti li kitoŋ kee li fɛ tɛɛŋ luushi, le bɛ woo bufii bu Mfɔŋ Salimu-u. Se nuuŋ le yikɛ yɛŋ nɛ woo, wumu lemɔɔ fɛni bɛ fiee fi ko fi yaa fi Salimu-u. ");
INSERT INTO asj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Naa nuuŋ bu jobɛ chi nsa-a, bɛniiŋ bɛ Ninibɛ leŋ bɛ kiŋgɔkɛ ki dɛɛni kini be tee le ki we kɛɛ nsa, kifɛ bɛniiŋ bɛ Ninibɛ tɛ̀ woo fiee fi Jɔna tɛ̀ fenjisi, be fiiki ntsɛ wube. Fi fiɛɛ le, yikɛ yɛɛŋ nɛ woo, wi wumu wɛ fɛni bɛ fiee fi ko fi yaa fi Jɔna. ");
INSERT INTO asj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wi ti tendi yɛ lambo le gɛɛ lintakwiiŋ kɛ. Kɛ le dzɔɔ ŋkwaa kuuki lu kɛ. Wi ti tendi, tɔmi nuuŋ li fiee fi bɛ tɔɔmi lambo lu-u, le ke bɛniiŋ lii li yih, be ŋɛŋ kiŋ'wofu. ");
INSERT INTO asj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lisi cho nuuŋ lambo li yi ya-a. Ɛ lisi cho wuuti lɔɔ, kɛ yi ya chichi gii yi yisɛ bɛ kiŋ'wofu. Se nuuŋ le, ɛ lisi cho wuuti yɛ kɛ, kɛ yi ya chichi gii yi yisɛ bɛ kijibɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Fi se tuu fi nuuŋ le, wi ni bichi le mwɛ deŋgɔɔ nuuŋ li kiŋ'wofu-u nuuŋ yɛ li kijibɛ-ɛ linti kɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ɛ yi ya chichi yisɛ bɛ kiŋ'wofu, kimbɛ kimu nuuŋ yɛ li kijibɛ-ɛ kɛ, kɛ biee bichu gii bi ni bi wuuti tɛ si lambo ti wuuti wu nyɛɛ kiŋ'wofu li yi ya-a.” ");
INSERT INTO asj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Le Jiso mɛɛshi tefɛ chee, wi Bɛfarasii wumu se teeŋ wu le bɛ bee wu gɛɛŋ be ji biee. Jiso gɛɛŋ, lɛ bee wu shee, be jii biee, ");
INSERT INTO asj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","tɛ mɛɛŋ saa ki tsootsɛ kɛ tsaŋ kɛ. Wi wu Bɛfarasii wɛ se bichɛ fi yaa wu. ");
INSERT INTO asj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Taa tɛ̀ kii fiee fi tɛ̀ beechi se biee kweeŋ li wuu laa, “Beŋ Bɛfarasii tsootsi muka bɛ shó lɛkuuŋ kwaa, se nuuŋ le, biee bibifi bɛ kin'yɛrisɛ lii yisɛ biɛɛ li shéŋ yinɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bibere bini! Nyɔ yi tɛ̀ tɔŋ lɛkuuŋ, ɛ nɛɛ yi yi tɛ̀ tɔŋ lɛnti tɛ ni? ");
INSERT INTO asj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Fi bee nuuŋ nɛ fɛ nuuŋ le, nɛ nyɛɛ biee li biee bi nɛ kɛmi biɛɛ li bɛniiŋ bɛ kifoo lɛ, biee bichu se ni bi wuuti bɛ beŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ŋgɛ wu nyɔŋa gii ni nuuŋ wunɛ beŋ Bɛfarasii. Nɛ nyɛɛ kimbɛ kimumkpaŋ li Nyɔ-ɔ lɛnti lɛ bimbe yoofi bi mbási yi nɛ keeti mɔɔ bɛŋɔ bɛ nɛ keeti nɛ giki lɛ mbasi le yi ni yi yiki, se nuuŋ le nɛ se tuu nɛ nyamisi mfɛru biee bi tsaaŋ li bɛniiŋ li, bɛ kiŋkɔŋgisɛ Nyɔ. Nɛ bee nɛ kɛmi le nɛ ni nɛ feti biee bilu bichu, nshɛ fimu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ŋgɛ wu nyɔŋa wɛ wunɛ beŋ Bɛfarasii. Nɛ ti kɔŋgisi nshewu nuuŋ limfwe li yíh yi kintaashɛ, nɛ tuu nɛ kɔŋgisi le bɛ ni bɛ yɛɛshi beŋ fɛ waŋ bɛ piɛti beŋ. ");
INSERT INTO asj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ŋgɛ wu nyɔŋa wɛ wunɛ, kifɛ nɛ nuuŋ si dzíŋ yi ti yeŋgi yɛ kɛ, bɛniiŋ deŋgi li yi-i ŋkɛɛ nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Si Jiso tɛ̀ yeti ni, wumu wu tɛ̀ gbɛŋgi kii bɛnchi bɛ Nyɔ-ɔ ŋge tee li wuu le, “Wi wu Ntiifɛ, ɔ kɛɛ le fiee fiɔ tiiti fini koŋ fiɛɛ li bee li.” ");
INSERT INTO asj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jiso tuu le, “Ŋgɛ wu nyɔŋa wɛ tɛ wunɛ beŋ bɛniiŋ bɛ gbɛŋgi be kii bɛnchi bɛ Nyɔ-ɔ ŋge. Nɛ yiki bɛniiŋ bɛ bɛntɛ bɛ yɛki buŋga bu bee bɛ nuuŋ nɛ tɛ laa kwaŋ le nɛ fi be kɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ŋgɛ wu nyɔŋa wɛ wunɛ. Nɛ gwɛndi dzíŋ yi bɛntomfɔŋ bɛ Nyɔ-ɔ, bɛ bɛte chaa bɛnɛ tɛ̀ woyɛ. ");
INSERT INTO asj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fini doonchi fiɛɛ le nɛ gbɛŋgi baa nɛ fɛɛfi fiee fi bɛte chaa bɛnɛ tɛ̀ fɛ. Be tɛ̀ woyɛ bɛntomfɔŋ bɛ Nyɔ-ɔ, nɛ shɛ nɛ nachɛ nɛ gwɛndi dzíŋ yibe. ");
INSERT INTO asj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Fiiŋ fiee fi tɛ̀ fɛ se Nyɔ bɛ bufii bwee kweeŋ le, ‘Ŋgii ntuumi bɛntomfɔŋ bɛ bɔɔŋ beŋ bɛ ntoŋ lɛ bee, be woyɛ bamu, be ŋwɛɛ bɛ bamu.’ ");
INSERT INTO asj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɛ lɛ si Nyɔ gii yi bii li kiŋgɔkɛ ki dɛɛni kini kii ŋgɔŋ mɛ bɛntomfɔŋ bee bɛchu bɛ be tɛ̀ woyɛ mbɛɛchɛ si kwɛɛŋ tɛ̀ bɛchi. ");
INSERT INTO asj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Gii naa bii mbɛɛchɛ fɛ mɛ Abɛ ŋgɛnu mbochu fɛ mɛ Sakariya wu be tɛ̀ wo kintikinti ki taantaa chi muntofi bɛ yih yi muntofi. Ntiitɔɔ li beŋ chɛɛŋ le Nyɔ gii yi bii li kiŋgɔkɛ ki dɛɛni kini kii kwe yi bɛniiŋ bɛlu bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ŋgɛ wu nyɔŋa wɛ wunɛ beŋ bɛniiŋ nɛ gbɛŋgi nɛ kii bɛnchi bɛ Nyɔ-ɔ. Nɛ nyikɛ baa kiŋgwiyɛ ki gwiyi kigoo ki wi nuuŋ lɛ le laanchɛ, kɛɛ fiee fi nuuŋ chɛɛŋ nɛ se baŋgi bɛniiŋ bɛ wɛki le be lɛ fe, beŋ kibɛɛ se ba nlɛ nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Le Jiso dza fe ni giiŋgi, Bɛfarasii bɛ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ bɛchi be lendi wu bɛ jɛ́ be biiti biee li wuu ŋge ŋge, ");
INSERT INTO asj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","be tɛ̀ feti lɛ be teeki wu le be woo fiee li kimfimɛ kee li be se kɔɔ wu. ");
INSERT INTO asj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Si Jiso tɛ̀ yeti lɛ, bintutu bi bɛniiŋ lɛ tɛ̀ banchi bi bɛɛ li bɛnchuki-i li bɛnchuki-i bi fakini. Bamu denchi bikaa bi bamu. Jiso se dza bɛchi tiiti li bɔɔŋ bee bɛ kintutu le, “Dzɔɔ yɛɛŋ mfi kii kishee ki Bɛfarasii lɛ ki ti nuuŋ fiee fi biee bi bee bi be ti tiiti chichi, be feti chichi. ");
INSERT INTO asj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nɛ kɛɛ le fiee fimu nuuŋ yɛ lu fi bɛ baanyɛ fi nuuŋ fi tɛ yenɛ kɛ. Fiee nuuŋ yɛ lu tɛ fi bɛ nyikɛ fi bɛ nuuŋ tɛ kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nɛ kɛɛ le fiee fichu fi nɛ tiiti butuu fiɛɛ fi bɛ gii bɛ woo fɛnshaaŋ. Fiee fichu fi nɛ shiiŋ nɛ bɛŋi kigoo nɛ tsuundi lɛ munyiikɔɔ li, bɛ gii bɛ dzaaŋ fɛ kigɔ ki yi-ih. ");
INSERT INTO asj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nsáŋ yɛŋ, ntiitɔɔ li be-eŋ le, kiiŋ nɛ ni nɛ chɛndi bɛniiŋ bɛ wuu nyaŋ yi li bwiiŋ kwaa, be se tɛ tuu le be fɛ fiee fimu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ŋgii ntee beŋ wi wu nɛ nuuŋ nɛ chɛŋ. Chɛŋ yɛɛŋ nuuŋ Nyɔ kifɛ ɛ yi yi kɛmi buŋga bu yi nuuŋ yi wo wi yi tuu yi lɔŋ mwɛ fɛ wi wu duti nyimu siŋ. Ntiitɔɔ beŋ chɛɛŋ le ɛ yi kwaa yi nɛ nuuŋ nɛ chɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ɛ nɛɛ munchaandi muntiinu mu bɛ ti kabini li munini mumfɛɛntu ni? Se nuuŋ le, finchaandi fimumkpaŋ nuuŋ yɛ mɔɔ lu fi Nyɔ ti daayi lɛ fi-i kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Li be-eŋ, Nyɔ fa yɛ yi chichi yi nuuŋ beŋ li fa. Kiiŋ nɛ ni nɛ chɛndi kɛ. Nɛ yaa baa munchaandi kiŋga ŋge. ");
INSERT INTO asj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ntuu ntee li be-eŋ le, wi kwikwi wu beŋ lɛ bɛniiŋ lii le kii mi, kɛ Ŋwanɛwi gii beŋ tɛ li bɛnchindaa bɛ Nyɔ-ɔ limfwe le kii wu. ");
INSERT INTO asj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Se nuuŋ le, ɛ wi faaŋ mi li bɛniiŋ li limfwe, kɛ ŋgii faaŋ tɛ mwɛ lɛ bɛnchindaa bɛ Nyɔ-ɔ lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Fi se tuu fi nuuŋ le, Nyɔ nuuŋ yi feeki jɛ́ yi bifi chichi yi wi tiiti kii Ŋwanɛwi, se nuuŋ le, Nyɔ nuuŋ tɛ naa feeki jɛ yi bifi yi wi tiiti kii Fiana yi Waaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mfi wu bɛ kɔɔ beŋ bɛ gɛɛŋ bɛ beŋ li yíh yi lɛkɛ li Nyɔ-ɔ, mɔɔ nuuŋ li bɛniiŋ bɛ sɛki kwɛɛŋ lɛ limfwe, mɔɔ nuuŋ li bɛniiŋ bɛ kɛmi buŋga bu nsawuu limfwe, le be gɛɛŋ be saa beŋ, kiiŋ nɛ ni nɛ buki kii fiee fi nɛ gii nɛ gɛɛŋ nɛ ku kɛ, mɔɔ nuuŋ ntefu kɛ, ");
INSERT INTO asj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kifɛ Fiana yi Waaŋ gii yi tifi beŋ fiee fi nɛ gii nɛ tee li mfi wulu.” ");
INSERT INTO asj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Si Jiso tɛ̀ tiifi bɔɔŋ bee bɛ kintutu lɛ, wi wumu li kimbanchɛ kilu se dza tee li wuu le, “Wi wu ntiifɛ, tee li ŋwaanɛŋ le gatɛ bishɛyɛ bi tɛɛ wu nyɛ bieŋ.” ");
INSERT INTO asj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jiso se bii li wuu laa, “Nyuŋ, ɛ noo wu gɛɛ mi le ni le ni nuuŋ kinsondinɛ bɛnsa kinɛ, ntuu ŋgatini mɔɔ bishɛyɛ binɛ?” ");
INSERT INTO asj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Si tɛ̀ bii lɛ, biee tee li wi kwikwi le, “Bɔsɛ yɛɛŋ yi nɛ dzɔɔ mfi le, kiiŋ lii ni yi yɛchi beŋ li biee li kɛ, kifɛ ntsɛ wu wi ti nuuŋ yɛ kii biee bi mwɛ kɛmi kɛ, mɔɔ mwɛ loo niŋ le.” ");
INSERT INTO asj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Le tee lɛ, biee wa ŋgaŋgaa chini le, “Wi wu biee wumu tɛ̀ kɛmi wɛ wee wu biee tɛ̀ dzɔɔŋ lu ŋge. ");
INSERT INTO asj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Se bɛchi beechi lɛ wuu shéŋ laa gii geeŋ le? Laa gii se gɛɛ bijinɛ biee fɛŋ le? ");
INSERT INTO asj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Se dzɔ ntaŋ lɛ wuu shéŋ le, ‘Fiiŋ fiee fi ŋgii mfɛ: Ŋgii nsaa bigɔɔnu bieŋ, ŋkaari mgbɛŋɛ bi, nse ŋgɛɛ bijinɛ bɛ biee bieŋ lu bichu. ");
INSERT INTO asj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ke mi mfɛ lɛ, nse ntuu ntee li yi yɛ-ɛŋ le mi ŋ'wɛ wi wu kishi. Ŋkɛmɔɔ biee bi ŋgii ni njii li biya-a ŋgee li. Mɛɛŋ yɛ ntuu ni mbuki kɛ. Ŋgii ni njii ŋ'wundi ŋ'wuki bujɔŋ.’ ");
INSERT INTO asj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Si tɛ nachi lɛ, Nyɔ se teeŋ wu le, ‘Kibere kini! Butuu bu bɛŋ buni ŋgii ŋkaari mfi ntsɛ wa. Biee bichu bi ɔ nachɛ ɔ gɛɛ bini gii bi to bi noo lɛ?’” ");
INSERT INTO asj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Le Jiso tee lɛ, biee kweeŋ le, “Ɛ nɛɛ lɛ si fi gii fi nuuŋ li wi kwikwi wu banchɛ bulofu li yi yee li se tɛ kɛmɛ bulofu lɛ kimbɛ ki Nyɔ-ɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jiso tuu dza kweeŋ li bɔɔŋ bee bɛ kintutu-u le, “Kiiŋ nɛ ni nɛ buki yi kii ntsɛ wunɛ laa nɛ gii nɛ ji la, mɔɔ laa nɛ gii nɛ lii la le kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nɛ kɛɛ le ntsɛ wu wi yɛki biee bijɛ, yi yi wi yɛki ndú. ");
INSERT INTO asj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bichɛ yɛɛŋ nɛ ŋɛŋ bigɔ, bi ti fiee tɔyi yɛ kɛ se bo ŋ'wechɛ. Bi ti kɛmi yɛ bɛ sambwa bɛ kichɛ biee lu, kɛ dɛɛ kɛ. Nyɔ se nyɛki nɛɛ bi bichu. Nɛ kii yɛ le nɛ yɛki baa muniiŋ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɛ noo lɛ be-eŋ lɛnti wu buki yi, wu nuuŋ tondɛ mfi mumkpaŋ li ntsɛ we-e? ");
INSERT INTO asj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ɛ nuuŋ nɛ tɛ fɛ mɔɔ nuuŋ fi niiŋ fini kɛ, ɛ la fi fɛ nɛ buki yi yinɛ kii biee bimu? ");
INSERT INTO asj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Bichɛ yɛɛŋ nɛ ŋɛŋ si bɛflaaba ti kuu be nuuŋ. Bɛflaaba ti nindi yɛ, kɛ le be taa ndú kii yi yi be kɛ. Nɛɛ lɛ, ntee beŋ le mɔɔ nuuŋ Mfɔŋ Salimu, li bunɔŋa bwee buchu bu tɛ kɛmi, ti mɛɛŋɔ saa ki chuumɛ kɛ yi yee bɛ ndú le kɔchɛ bujɔɔŋ bu flaaba wumu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɛ Nyɔ ti chuumini kitɔɔ ki kuu libuka, kitɔɔ ki kuu bɛŋ, ɛ bo fwaa bɛ kukɛ ki fɛtaaŋ, yi gii se lee ki chuumɛ kɛ beŋ bɛ ndú yi yaa ki ni? Hooo beŋ bɛniiŋ bɛ kɛmi kimbeenchɛ kintɛŋ bani! ");
INSERT INTO asj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Fi se fiɛɛ le kiiŋ nɛ ni nɛ buki yi kii fiee fi nɛ gii nɛ ji bɛ fi nɛ gii nɛ woŋ kɛ, ");
INSERT INTO asj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","kifɛ bini biee beechi nɛɛ nuuŋ bɛniiŋ bɛ li nshɛ-ɛ bɛ kii yɛ Nyɔ kɛ. Nɛ kɛɛ le Baa wunɛ kiiɔ le nɛ wɛki baa biee bini bichu. ");
INSERT INTO asj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gɛɛ yɛɛŋ bufii bunɛ li bumfɔŋ bu Nyɔ-ɔ kwɛ, yi se tuu yi ni yi nyɛɛ biee bini bichu li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kintutu keŋ si nɛ sendɛ ni, nɛ chɛŋ kɛ yɛɛŋ fiee kɛ, kifɛ Nyɔ yi nuuŋ Baa wunɛ tsaa yɛ le yi nyɛ bumfɔŋ bwee li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kabɛ yɛɛŋ biee bi nɛ kɛmi, nɛ nyɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ. Nɛ bichɛ bɛbabi bɛ kwa-a bɛnɛ bɛ nuuŋ tɛ gaamɛ kɛ, nɛ kichi yɛɛŋ bulofu bunɛ nuuŋ liboo, fɛ bu nuuŋ tɛ naa ma kɛ, fɛ wih nuuŋ tɛ bo fe kɛ, mɔɔ le mun'yoo yoo kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nɛ ni nɛ kii le fɛ wi kiri bulofu bwee fe, ɛ nɛɛ fe fɛ shéŋ yee gii yi ni yi nuuŋ. ");
INSERT INTO asj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kanɛ yɛɛŋ bitsaa binɛ, nɛ tɔŋ bɛlambo nɛ ni nɛ lemi nɛ tɛŋgi nimɛ, ");
INSERT INTO asj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","si bɔɔŋ bɛ nimɛ-ɛ bɛ tɛŋgi te kikoo wube wu karisi lɛ tsɔnɔ chi bugoo lɛ. Ke wu kaari wu bɛ wu koŋ kigoo, be gwiyɛ le lɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kinɛɛtinɛ ki kinɔŋa gii ki nuuŋ ki bɔɔŋ bɛ nimɛ bɛ te kikoo wube gii ke wu fɛsi ŋɛŋ si be nuuŋ we be tɛŋgi wu. Ntee li be-eŋ chɛɛŋ le, gii kɛnchi ndú kaŋ li tiŋ, be se shee yɛ fɛkwiiŋ, bɛ se bɛ bɛ bijɛ gachɛ be. ");
INSERT INTO asj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kinɛɛtinɛ ki kinɔŋa gii ki nuuŋ ki bɔɔŋ bɛ nimɛ-ɛ fɛ wu fɛsi wu chiiŋ be, be tɛŋgi wu butuu ntaaŋ mɔɔ nuuŋ lɛ ŋwori. ");
INSERT INTO asj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nɛ kɛɛ le ɛ te yih kii mfi wu wih gii bɛ, kɛ gii ni kiichi. Nuuŋ tɛ chinɛ le bɛ bondɛ yih ye kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mɔɔ beŋ tɛ, nɛ kɛmi le nɛ ni nɛ tɛŋgi, kifɛ Ŋwanɛwi gii naa kaari bɛ nuuŋ li mfi wu nɛ kii yɛ kɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita se dza bii li wuu laa, “Taa, ɔ wa ŋgaŋgaa chini nuuŋ li bee li, mɔɔ li bɛniiŋ bɛchu-u le?” ");
INSERT INTO asj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Taa se tuu le, “Ŋwaŋ wu nimɛ wu nuuŋ tsaaŋ wu kɛmi bufii se nuuŋ wu la? Ɛ nɛɛ wɛɛ wu te kikoo we gɛɛ le ni kiichi yih ye, le ke mfi kɔchɛ se nyɛ biee bijɛ li bɔɔŋ bɛ nimɛ-ɛ lɛ mfi lɛ wa ni? ");
INSERT INTO asj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kinɛɛtinɛ kinɔŋa gii ki nuuŋ ki ŋwanɛ nimɛ wu te kikoo we gii ke wu bɛ ŋɛŋ ɛ wu fɛ nimɛ tsaaŋ si bee gɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ntee beŋ chɛɛŋ le te kikoo we gii bɛ yɛɛki wu ni bichi lɛ biee biee bichu-u. ");
INSERT INTO asj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Se nuuŋ le, ɛ ŋwaŋ wu nimɛ wulu dza wu tuu wu tee li yi yee li le, ‘Te Kikoo wɛŋ nuuŋ tɛ bɛ tsɛkɛ kɛ,’ wu bɛchi tuu tuki bɔɔŋ bɛ nimɛ-ɛ bɛ buniŋ mɔɔ bɛ bukɛɛŋ, jii biee tuu wundi biee bi keeti wu, ");
INSERT INTO asj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","te kikoo wu ŋwanɛ nimɛ wɛ gii taa bɛ nuuŋ jobɛ chi tɛ beechi yɛ kɛ, mɔɔ mfi wu tɛ gii kii yɛ kɛ. Gii ke wu fɛsi lɛ, gii wachɛ ŋwaŋ wu nimɛ wulu-u, tuumi wu gɛɛŋ chiiŋ nuuŋ bɛniiŋ bɛ mɛɛŋ ki gɛɛ kɛ shéŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ŋwaŋ wu nimɛ wu kii fiee fi te kikoo we wɛki le fɛ, mɛɛŋ nachɛ kɛ le ni feti kɛ, kɛ bɛ gii bɛ fiaaŋ wu bɛ muŋwaaŋ ŋge ");
INSERT INTO asj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ŋwaŋ wu nimɛ wu kii yɛ fiee fi te kikoo we wɛki le fɛ kɛ, ɛ wu fɛ fiee fi bɛ nuuŋ bɛ fiaaŋ wu bɛ muŋwaaŋ ŋge, kɛ bɛ gii bɛ fiaaŋ wu bɛ muŋwaaŋ niiŋ kwaa. Wi wu bɛ nyɛ biee li wuu ŋge, kɛ bɛ gii bɛ fi ŋge li wuu. Wi wu bɛ gɛɛ biee li tsaŋ yee li ŋge, bɛ gii bɛ bii ŋge li wuu.” ");
INSERT INTO asj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jiso se tuu tee li bɔɔŋ bee bɛ kintutu le, “Mi mbɛɛɔ le ŋkukɛ nuuŋ wi li nshɛ yini. Bɛ dzɔɔ le wu duti wɛ kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ŋkɛmɔɔ ŋwaani ŋgɛ wu mkpaaŋ wumu le nlɛ li wuu, shéŋ yɛŋ gii yi fufɛ nuuŋ nɛɛ mfi wu mi nlɛ li wuu. ");
INSERT INTO asj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɛ beechi le mi mbɛ nuuŋ bɛ mbɛɛŋgii li nshɛ yini-i ni? Wohoo, nɛ kɛɛ le mi mbɛɛɔ nuuŋ bɛ buga. ");
INSERT INTO asj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mbɛɛchɛ li mfi wuni ŋgɛnu limfwe, yih yi kɛmi bɛniiŋ bɛtiinu gii yi gatɛ. Bɛniiŋ bɛ bɛtɛɛtu gii be gatɛ bɛ bɛfɛ, bɛ bɛfɛ se gatɛ bɛ bɛtɛɛtu. ");
INSERT INTO asj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Te ŋwaŋ gii gatɛ bee ŋwani wu nyuŋ, ŋwaŋ wu nyuŋ se gatɛ bee tee. Ni ŋwaŋ gatɛ bee ŋwani wu kwɛɛŋ ŋwaakwɛɛŋ se gatɛ bee ni. Ni nyuŋ gii gatɛ bee kwɛɛ ŋwani, kwɛɛ ŋwaŋ se gatɛ bee ni nyumi.” ");
INSERT INTO asj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jiso kɔɔ tee li kimbanchɛ ki bɛniiŋ lɛ le, “Mfi wu nɛ ŋɛŋ si kikuŋ yɛki kimbɛ ki jobɛ sechi, nɛ tuu nɛ tee le, ‘Dzaŋ gii yi we.’ Yi se biee yi we. ");
INSERT INTO asj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ɛ nɛ ŋɛŋ tɛ si mfiee fɛɛti nuuŋ kimbɛ litɛ, nɛ tuu nɛ kweeŋ le, ‘Kiyubɛ ki kinɔŋa gii ki nuuŋ lu.’ Ki se nuuŋ lu. ");
INSERT INTO asj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Beŋ bɛniiŋ bɛ nimi-i bani, si nɛ bichi kiboo bɛ nshɛ nɛ tuu nɛ kii si kikuuŋ gii ki nuuŋ lɛ, nɛ se tɛ kɛɛ tɛ biee bi Nyɔ doonchi li mfi wuni kɛ ni? ");
INSERT INTO asj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nuuŋ nɛ tɛ beechɛ fiee fi tsaaŋ fi nuuŋ nɛ ni nɛ sɛki ni? ");
INSERT INTO asj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɛ wi dzɔ wɛ giiŋgi bɛ wɛ li yih yi nsa-a, ɔ gwenɛ le nɛɛ wu nɛ nachɛ nɛ mɛɛŋ lɛ dze, kii ni chee wɛ gɛɛŋ nyɛ wɛ li tsaŋ yi wi wu sɛki bɛnsa-a, tuu nyɛ wɛ li tsaŋ yi bɛniiŋ bɛ nchi-i, be se fa wɛ li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ntee wɛ le ɔ nuuŋ tɛ bo lu fuki fɛɔ mɛɛshi ɔ sooŋ finini fichu fi bɛ wɛki nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tɛ̀ nuuŋ li mfi wumu, bɛniiŋ bamu dza be tee Jiso kii bɛniiŋ bɛ Galilii bamu bɛ tɛ̀ gɛɛŋ le be fɛ muntofi li Nyɔ-ɔ, Pailɛt toŋ bɛniiŋ be gɛɛŋ be wachɛ be. Ŋgɔŋ mɛ bee fiinsɛ bɛ mɛ nyáŋ yibe tɛ̀ fɛ muntofi lu-u. ");
INSERT INTO asj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Le Jiso woo lɛ, bii li bee laa, “Nɛ beechi le bɛniiŋ bɛlu tɛ̀ kwi ŋwaani yɛɛ kwe kifɛ bibifi bi bee tɛ̀ yaa bi bɛniiŋ bɛ Galilii bamu ni? ");
INSERT INTO asj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ɛ lɛ kɛ. Ntee beŋ le, ɛ nɛ mɛɛŋ ki fiiki kɛ shéŋ yinɛ kɛ, kɛ beŋ bɛchu gii nɛ kwiyɛ tɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nɛ kiimi nɛɛ bɛniiŋ bɛ yoofi ntsɔ nyaaŋ bɛ yih yi njeeŋ yi Siloŋ tɛ̀ we yi woyɛ baa ni? Nɛ beechi le bɛniiŋ bɛlu tɛ̀ kwiyɛ lɛ kifɛ be tɛ̀ nuuŋ bɛniiŋ bɛ bibifi wu bibifi bi bee tɛ̀ yaa bi bɛniiŋ bɛ Jɛrosalɛŋ bamu ni? ");
INSERT INTO asj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ɛ lɛ kɛ. Ntee beŋ le, ɛ nɛ mɛɛŋ ki fiiki kɛ shéŋ yinɛ kɛ, kɛ beŋ bɛchu gii nɛ kwiyɛ tɛ lɛ.” ");
INSERT INTO asj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jiso se wa ŋgaŋgaa chimu li bee le, “Tɛ̀ nuuŋ li mfi wumu, wi wumu tɔyɛ kiti kimu li wɛ wee li, le mfi kɔchɛ, bɛ le bɛ kɔ muntaaŋ mɛɛŋ ki ŋɛŋ kɛ fiee lu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Se tee li wi wu tɛ̀ bichi lɛ wɛ wee wɛɛ le, ‘Bichɛ ɔ ŋɛŋ, dɛɛni yaa biya bitɛɛtu bi mbɛɛ le ŋkɔ muntaaŋ li kiti kini, ntɛ ŋɛŋ fiee li ki-i kɛ. Warɛ ki! Ki baŋgi kɛɛ kintsii li yee li.’ ");
INSERT INTO asj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wi wu nimɛ wulu se tuu le, ‘Te Kikoo, tɛ tuu tɛ gɛɛ ki nuuŋ li kiya kini-i, ntuu nchuu fɛ kinyi kilu ŋkɛnɛ ŋgɛɛ bichɔchɔ fe. ");
INSERT INTO asj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ɛ ki woŋ muntaaŋ li kiya ki bɛɛ kini, kɛ fiee fishaaŋ, ɛ ki ba ŋwonu nsiŋ, nse wa ki.’” ");
INSERT INTO asj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Le ni nuuŋ jobɛ chi bɛshiinshi chimu, Jiso tiifi bɛniiŋ li yih yi nlɛkɛ li Nyɔ-ɔ yimi-i. ");
INSERT INTO asj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kwɛɛŋ wumu nuuŋ lu kɛmi fiana yi kiŋkundi li yi yee li, yi ti feti wi mwɛ to wi wu chigɔŋ. Tɛ gɔŋ biya yoofi ntsɔ nyaaŋ, ba kiŋguuŋ, tɛ leŋ we tsaaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Le Jiso ŋɛŋ kwɛɛŋ wulu, teeŋ wu le bɛ. Se tee li wuu le, “Naaŋ, ɔ tɛmɔɔ li chigɔŋ cho chini.” ");
INSERT INTO asj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Le tee lɛ, nɛɛmi kibɛnɛ kee koŋ li wuu, mfwaa mumkpaŋ, dzaa ye nɛɛmi, leŋ we tsaaŋ, biee bɛchi yɔɔnchi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Te Kikoo wu li yih yi nlɛkɛ li Nyɔ-ɔ yilu ŋɛŋ si Jiso wɔnchɛ kwɛɛŋ wulu nuuŋ jobɛ chi bɛshiinshi, fiee filu tuu fi tɔnyɛ wu ŋge. Se tee li bɛniiŋ li le, “Jo yi nimɛ nuuŋ busɔɔ. Nɛ bɛɛ yɛɛŋ li jo yilu bɛ ni bɛ wɔnchi chigɔŋ chinɛ. Kiiŋ wi ni mɔŋ le bɛ nuuŋ jobɛ chi bɛshiinshi kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Taa tuu li wuu le, “Beŋ bɛniiŋ bɛ nimi-i bani, bɛɛ ɛ nuuŋ bu bɛshiinshi, wi mumkpaŋ mumkpaŋ lɛ beŋ lɛnti ti dzeti yɛ naŋ mɔɔ nuuŋ sɔmbwaa we fɛ tsiiŋ le gɛɛŋ nyɛ wu dzɔɔ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kwɛɛŋ wuni wu nuuŋ ŋwanɛ Abrahaŋ, wu Sataŋ tɛ̀ ta wu li mfaŋgɛ-ɛ biya yoofi ntsɔ nyaaŋ, fi mɛɛŋ ki dzɔɔŋ kɛ le bɛ buu wu li ŋgɛ-ɛ jobɛ chi bɛshiinshi kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Le Jiso kweeŋ lɛ, bɛniiŋ bee bɛ mbani kɛmɛ buya, bɛniiŋ bamu ŋgee tɛ̀ nɛki kii bintɛwa bi biee lɛ bichu bi Jiso tɛ̀ feti. ");
INSERT INTO asj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jiso dza kweeŋ le, “Bumfɔŋ bu Nyɔ-ɔ nuuŋ si la? Fiee fi nuuŋ maa bɛ bu nuuŋ la? ");
INSERT INTO asj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bu bwɛɛ si ŋgɔ yi fintaaŋ fimu yi wi tɛ̀ tuŋ liwɛ wee li, le yi maŋ, yi ko yi to kiti muniiŋ mu jiindi liwe se bɛ mu gwanyɛ yíh lu ki-i.” ");
INSERT INTO asj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Se dza tuu kweeŋ le, “Ŋgii ntuu maa bumfɔŋ bu Nyɔ-ɔ bɛ la? ");
INSERT INTO asj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bu bwɛɛ si kishee ki kwɛɛŋ tɛ̀ fichɛ musu bɛke bɛ nɔŋa bɛ nɔŋa bɛtɛɛtu fiinsɛ lu, dzɔ tɔ, me se biee me fe me dooki.” ");
INSERT INTO asj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jiso tɛ dza giiŋgi Jɛrosalɛŋ. Tɛ̀ gii giiŋgi kɛti li bintsii li bɛ li bitoŋ li tiifi bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wumu se dza bii li wuu laa, “Taa, ɛ bɛniiŋ niiŋ bɛ gii be bɔnɛ li ŋgɛ-ɛ ni?” Jiso se biee tuu li bee le, ");
INSERT INTO asj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gwenɛ yɛɛŋ nuuŋ le nɛ lɛ lɛ fweeŋ wu kimfasɛ-ɛ. Nɛ kɛɛ le bɛniiŋ ŋge gii be ni be geendi le be lɛ be tɛ kɛmɛ dze kɛ. ");
INSERT INTO asj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mfi gii kɔchɛ, te yih se dza we fa kigoo. Mfi wu wu fa, nɛ gii nɛ ba lɛkuuŋ nɛ ni nɛ juti kigoo nɛ lɛki le, ‘Te Kikoo, gwiyɛ nɛɛ kigoo tɛ lɛ.’ Se tuu tuu li be-eŋ le, ‘Ŋkii yɛ fɛ nɛ bɛɛ fe kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nɛ se bɛchi nɛ ni nɛ fayi le, ‘Ɛ nɛɛ bee tɛ tuu tɛ̀ jii biee tɛ wundi biee, ɔ se deŋgi ɔ tiifi bɛniiŋ li bitoŋ bisɛ-ɛŋ ni!’ ");
INSERT INTO asj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gii tuu kaari tuu li bee le ntiitɔɔ li be-eŋ le, ‘Ŋkii yɛ fɛ nɛ bo fe kɛ. Dzatsɛ yɛɛŋ mi lii beŋ nɛ deŋgi nɛ bifisi biee bani.’ ");
INSERT INTO asj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nɛ gii nɛ ŋɛŋ Abrahaŋ bɛ Adzi mɔɔ Yakɔ mɔɔ bɛntomfɔŋ bɛ Nyɔ-ɔ bɛchu lɛ bumfɔŋ bu Nyɔ-ɔ lɛnti ɛ bɛ bɛŋɛ beŋ lɛkuuŋ, nɛ se ni nɛ dii nɛ jii ŋgesi. ");
INSERT INTO asj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bɛniiŋ gii be dza bimbe bichu mbɛɛchɛ lɛ jobɛ tɛti ŋgɛnu mbochu fɛ chi sechi, mɔɔ we we bɛ kwiiŋ kwiiŋ lɛ kwɛɛŋ li, be ni be jii biee lɛ bumfɔŋ bu Nyɔ-ɔ lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yikɛ yɛɛŋ nɛ woo, bɛniiŋ bamu bɛ nuuŋ lɛjiŋ dɛɛni be gii be to bɛ limfwe, bamu bɛ nuuŋ limfwe dɛɛni be gii be se to bɛ lɛjiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tɛ̀ nuuŋ li mfi wulu, Bɛfarasii se tee li Jiso le, “Bo fio fɛni ɔ gɛɛŋ kimbɛ kimu kifɛ Mfɔŋ Hɛrɔ wɛkɔɔ le wo wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jiso se tuu li bee le, “Gɛnɛ yɛɛŋ nɛ tee li kijinɛ kilu le mbusɔɔ bɛnchindaa bɛ kiŋkundi-i li bɛniiŋ li bɛŋ, ntuu ŋ'wɔnchi mɔɔ chigɔŋ, nɛɛ si ŋgii mfɛ fwaa, ke fɛɛshi fwaa se mɛɛshi nimɛ cheŋ. ");
INSERT INTO asj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Se nuuŋ le, ŋgii mbɛchi ndɛndɛ wɛŋ Jɛrosalɛŋ bɛŋ, mbo ndɛndɛ fwaa, gɛɛŋ bo fɛɛshi fwaa. Fi mɛɛŋ ki dzɔɔŋ kɛ le bɛ wo ntomfɔŋ wu Nyɔ fɛ kintsii kimu fuki Jɛrosalɛŋ siŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Le Jiso yɔ ni, bɛɛni yi le, “Hebee Jɛrosalɛŋ! Hebee Jɛrosalɛŋ! Wɛ wu woyi bɛ ntomfɔŋ bɛ Nyɔ-ɔ, ɔ tuu ɔ tomi bɛniiŋ bɛ Nyɔ tuumi li wɛ-ɛ bɛ ta! Ɛ kiŋga kimɛ ki mi ŋgwɛnɔɔ le mbanchɛ bɔɔŋ bo nɛɛ si ni shee ti banchi bɔɔŋ bee foochɛ bɛ bibɛ biee lɛ, ɔ se tuu ɔ faaŋ? ");
INSERT INTO asj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bichɛ ɔ ŋɛŋ, yih ya gii yi to kichiiyɛ. Ntee li be-eŋ chɛɛŋ le nɛ nuuŋ tɛ tuu le nɛ ŋɛŋ mi kɛ, nsiiŋ gɛɛŋ bo mfi wu nɛ tee le, ‘Nyɔ nyɛ yɛ kimbɔnɛ li wi wu bɛɛ li bukooŋ bu Taa lɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tɛ̀ nuuŋ jobɛ chi bɛshiinshi chimu, Jiso gɛɛŋ le ji biee li yih yi wi wu nyɔŋa wumu. Ɛ wi wulu tɛ nuuŋ wi Bɛfarasii. Bɛniiŋ bɛ tɛ̀ nuuŋ fe tɛ̀ nyaanchi Jiso le be ŋɛŋ fiee fi gii fɛ. ");
INSERT INTO asj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Fi tɛ̀ nuuŋ lɛ ɛ nyuŋ wumu tɛ̀ lemi fe Jiso limfwe, gendi bɛ chigɔŋ chi tɛ̀ fɛ le tsaŋ yee bɛ bikaa biee ni bi muchi. ");
INSERT INTO asj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jiso se bii li Bɛfarasii li mɔɔ li bɛniiŋ bɛ tɛ̀ gbɛŋgi be kii bɛnchi bɛ Nyɔ-ɔ bɛ tɛ̀ nuuŋ fe baa laa, “Nchi wusɛŋ ti beenchi le bɛ wɔnchɛ wi jobɛ chi bɛshiinshi mɔɔ lɛ kɛ le?” ");
INSERT INTO asj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Be se ba nshiiŋ. Jiso se kɛmɛ li wi wulu, wɔnchɛ wu, se tee li wu-u le gɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jiso se bii li bɛniiŋ bɛlu laa, “Ɛ wi wumu li be-eŋ linti kɛmi ŋwaŋ mɔɔ nuuŋ naŋ wu we lɛ fweeŋ, gii leeki seri kɛ le mfwaa mumkpaŋ le buu wu mɔɔ nuuŋ jobɛ chi bɛshiinshi kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Be se waaŋ fiee fi be nuuŋ be tuu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Le Jiso bichɛ ŋɛŋ si bɛniiŋ bɛɛ be tsɛki nuuŋ bintsii bi limfwe be se shiiti, se wa ŋgaŋgaa chini li bee le, ");
INSERT INTO asj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mfi wu bɛ teeŋ wɛ fɛ tsɔnɔ chi bugoo lɛ, kiiŋ ɔ ni shee nuuŋ fɛ kintsii ki limfwe kɛ, kifɛ nuuŋ fi nuuŋ le bɛ teeŋ baa tɛ wi wumu wu nyɔŋa wu yɛki wɛ. ");
INSERT INTO asj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nyuŋ wutso wu bee teeŋ beŋ bɛchu nuuŋ bɛ tuu tee li wɛ-ɛ le, ‘Dzatsɛ we ɔ nyɛ kintsii kini li wi wu nyɔŋa wuni-i.’ Mfi wu tee lɛ, ɔ gii ɔ tuu ɔ dza bɛ buya ɔ gɛɛŋ ɔ shee nuuŋ lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mfi wu bɛ teeŋ wi le bɛ fɛ tsɔnɔ chi bugoo lɛ, mwɛ gɛɛŋ shee nuuŋ lɛjiŋ, ke nyuŋ wutso bɛ se tee li wuu le, ‘Sinɛŋ, dzatsɛ we fɛni ɔ gɛɛŋ ɔ shee nuuŋ limfwe.’ Bɛdɛɛni, ɔ gii se nuuŋ bɛkiyunɛ li bɛniiŋ bɛchu bɛ nuuŋ fe limfwe. ");
INSERT INTO asj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ɛ lɛ si fi fiɛɛ bɛ wi kwikwi wu tsakisi yi yee liwe, bɛ gii bɛ shiiki wu fɛkwiiŋ. Wi wu shikisi yi yee fɛkwiiŋ, bɛ gii bɛ yɛɛki wu liwe.” ");
INSERT INTO asj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jiso se dza fiiki tee li te yih wu tɛ̀ teeŋ wu li wuu yih wɛɛ le, “Mfi wu ɔ wɛki le ɔ teeŋ bɛniiŋ le be bɛ be ji biee, kiiŋ ɔ ni teeŋ nuuŋ nsáŋ ya, kɛ bɛŋwaana, kɛ kini ko, kɛ bɛniiŋ bɛ biee lɛ bɛ li kitoŋ ko-o kɛ. Ɔɔ teenyi beeyɛ bɛniiŋ, kɛ ɔ wɛkɔɔ le be naa be teeŋ tɛ wɛ li yíh yi bee, fi se doonchɛ le be tuu baa nya ya. ");
INSERT INTO asj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mfi wu ɔ kaa tsɔnɔ, ɔ teeŋ nuuŋ bɛniiŋ bɛ kifoo lɛ, biŋkɛrɛ bɛ bimbonyɛ mɔɔ binyɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ɔɔ fɛ lɛ, kɛ ɔ giiɔ kɛmɛ kimbɔnɛ, kifɛ beeyɛ bɛniiŋ kɛmi yɛ fiee fi be gii be naa be kaari be tuu li wɛ-ɛ kɛ. Ɛ nɛɛ Nyɔ kwaa yi gii yi sooŋ wɛ jobɛ chi bɛniiŋ bɛ tsaaŋ gii be bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Le Jiso yɔ lɛ, wumu wu bee be tɛ̀ jii biee tuu tee li wuu le, “Kinɛɛtinɛ ki kinɔŋa kɛɛ ki wi wu gii naa ji biee lɛ bumfɔŋ bu Nyɔ-ɔ lɛnti.” ");
INSERT INTO asj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jiso se tuu tee li wuu le, “Tɛ̀ nuuŋ li mfi wumu, wumu kaa tsɔnɔ chi nɔŋa, teeŋ bɛniiŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Le jobɛ bɛ chi kɔchɛ, toŋ ŋwani wu nimɛ le gɛɛŋ dɛndɛ tee li bɛniiŋ bɛchu bɛ tɛ̀ teeŋ baa le be ni be bɛɛ, le wu nachɔɔ biee bichu! ");
INSERT INTO asj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ŋwani wu nimɛ wulu gɛɛŋ ŋɛŋ be, be bɛchi be tuu be lɛki dze mumkpaŋ mumkpaŋ. Wi wu ŋkosi wu tɛ ŋɛŋ tee li wuu le, ‘Mi ŋgoɔ wɛ wɛŋ wu fwɛŋ, ŋkɛmɔɔ le ŋgɛɛŋ mbichɛ wu kwɛ. Mintemii, kiiŋ nɛ ni nɛ tɛŋgi mi kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Le tuu ŋɛŋ wumu, mwɛ tee le, ‘Mi ŋgoɔ bɛnaŋ beŋ bɛ nimɛ yoofi, ŋgiiŋgɔɔ dɛɛni mɔnchɛ be. Mintemii, kiiŋ nɛ ni nɛ tɛŋgi mi kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Le ŋɛŋ wumu, mwɛ se tee fiee le, ‘Mɛɛŋɔ fɛ mi ndzɔ kwɛɛŋ, fiɛɛ fiee fi nuuŋ ntɛ mbɛ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Le be tuu lɛ, ŋwani wu nimɛ wɛ kaari to lijiŋ gɛɛŋ tee fiee fichu li te kikoo we. Le te tsɔnɔ wulu woo lɛ, shéŋ tɔŋ wu. Se tuu toŋ ŋwani wu nimɛ wɛ, tee le, ‘Gɛnɛ tsɛkɛ, lɛ dzé ntasɛ mɔɔ li mu dzekɛ munchu-u li kitoŋ kini, ɔ konchɛ bɛniiŋ bɛ kifoo lɛ, bimbonyɛ, bɛ binyɛɛ mɔɔ biŋkɛrɛ ɔ bɛ bɛ be.’ ");
INSERT INTO asj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Le mfwa wulu gɛɛŋ kaari, tee le, ‘Te Kikoo, mi fɛɔ siɔ beeɔ tee, se nuuŋ le, yi mɛɛŋ yɛ nɛɛ kiyisɛ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Te Kikoo wulu se tuu tee li mfwa wulu le, ‘Bochɛ dɛɛni ɔ gɛɛŋ lɛ dze bɛ mu dzekɛ munchu, ɔ kaŋ bɛniiŋ le be bɛ, yih yɛŋ se yisɛ. ");
INSERT INTO asj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nɛ kɛɛ le wi lu kɛ lɛ bɛniiŋ bɛ ntɛ nteeŋ baa lɛnti wu gii mɔŋ fiee fieŋ lɛ wa kɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jiso tuu dza le ni giiŋgi, kintutu ki bɛniiŋ lɛ banchɛ ki biki wu. Dza fiiki yi tee li bee le, ");
INSERT INTO asj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nuuŋ wi tɛ nuuŋ ŋwanɛŋ wu kintutu fuki fɛ wu kɔɔŋgi mi wu yaa ni bee tee, wu kɔɔŋgi mi wu yaa kwɛsi bee bɔɔŋ mɔɔ bɛŋwaani, mɔɔ dzɛmi yee nsiŋ kɛ, kɛmi le kɔɔŋgi mi yaa yi yee. ");
INSERT INTO asj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nuuŋ wi tɛ nuuŋ wi wɛŋ wu kintutu mɛɛŋ ki too kɛ kintaaŋ kee le ni biki mi kɛ. ");
INSERT INTO asj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ɛ noo lɛ be-eŋ lɛnti wu wɛki le gwaŋ yih yi njeeŋ, mɛɛŋ saa ki shee kɛ fɛkwiiŋ le beechɛ laa kɛmɔɔ kwa wu gii gwaŋ mɛɛshi le? ");
INSERT INTO asj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ɛ mɛɛŋ saa ki fɛ lɛ kɛ, kɛ nuuŋ tɛ mɛɛshi ŋgwanu yih yilu kɛ mɔɔ nuuŋ le tɛ̀ saa wu fɛ kimfoo wu gɛɛ. Bɛniiŋ gii be ni be kɛti be yɛndi wu be tiiti le, ");
INSERT INTO asj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Bwɛɛ wuni tɛ̀ bɛchi yih yi gwanɛ yi se yaa wu mɛrisɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kɛ mfɔŋ wu la wu wɛki le gɛɛŋ toŋ dziŋ bɛ mfɔŋ wumu, tɛ saa le shee fɛkwiiŋ le beechɛ laa tɛɛmɔɔ bɔ bee bɛniiŋ bee bɛ dziŋ lɛ bɛ bɛnchuki yoofi bani le toŋ dziŋ bɛ mfɔŋ wumu wu bɛɛ bee bɛniiŋ bee bɛ dziŋ lɛ bɛ nuuŋ bɛnchuki mbaamfiɛɛ le? ");
INSERT INTO asj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ɛ wu beechɛ wu ŋɛŋ le fi gii fi yaa, se tuu toŋ bɛniiŋ bee bamu le be gɛɛŋ be ŋɛŋ mfɔŋ wumu wɛɛ mɛɛŋ mfiiŋ be lɛkɛ wu le mbɛɛŋgii ni nuuŋ lɛ bee lɛnti. ");
INSERT INTO asj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Fi tuu fi nuuŋ le, ɛ wi mɛɛŋ ki chinɛ kɛ li biee biee li bichuchu kɛ, kɛ nuuŋ tɛ nuuŋ ŋwanɛŋ wu kintutu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ntɔŋ nuuŋ fiee fi dzeeŋ. Se nuuŋ le, ɛ me to n'yikɛ nsiŋ, bɛ ge niŋ me se tuu me kaari me yikɛ? ");
INSERT INTO asj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kɛ me la maa li yee li. Me mɛɛŋ yɛ me dzɔɔŋ ŋgɛwu li wɛ kɛ, mɔɔ nuuŋ li bichɔchɔ kɛ. Mani maa dɛɛni nuuŋ mɛ shooshɛ. Wi wu kɛmi bintooŋ mwɛ woo.” ");
INSERT INTO asj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bɛniiŋ bɛ tɛ̀ kundi kiŋwaati mɔɔ bɛniiŋ bɛ bifi bamu tɛ̀ bɛɛ lɛ Jiso le be yikɛ fiee fi tɛ̀ tiifi. ");
INSERT INTO asj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bɛfarasii bɛ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ se bɛchi be ŋuŋini, be tiiti le, “Wi wuni fiiɔ bɛniiŋ bɛ bifi tuu jii mɔɔ biee bee be.” ");
INSERT INTO asj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bɛdɛɛni, Jiso se wa ŋgaŋgaa chini li bee le, ");
INSERT INTO asj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ɛ noo lɛ be-eŋ lɛnti wu kɛmi nshɔ́ɔŋ gwii, yi mumkpaŋ la, gii chikɛ nshiiŋ ni? Gii leeki shɛ kɛ yi gwii mfomɛyoofi ntsɔ mfomɛyoofi yɛɛ li buka le gɛɛŋ ni geendi yi mumkpaŋ yɛ nsiiŋ mfi wu ŋɛŋ yi ni? ");
INSERT INTO asj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mfi wu gɔɔŋ wu ŋɛŋ yi, gii nɛɛtɛ se too yi fɛ ŋgeŋge, ");
INSERT INTO asj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","koo bɛ yi fɛkuuŋ. Mfi wu koo bɛ yi, gii teenyɛ nsáŋ yee mɔɔ bɛniiŋ bɛ tsiiŋ li wuu lichiŋ tee li bee le, ‘Bɛ yɛɛŋ tɛɛbeŋ tɛ ni tɛ nɛki, kifɛ nshɔɔŋ yɛŋ bee yi la, mi se ntuu mi ŋɛŋ yi.’ ");
INSERT INTO asj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ntee beŋ le, ɛ lɛ si kinɛɛtinɛ ki kinɔŋa gii ki nuuŋ liboo kii wi wu bifi mumkpaŋ, wu fiiki shéŋ yee, yɛki bɛniiŋ bɛ gwii mfomɛyoofi ntsɔ mfomɛyoofi bɛ nuuŋ tsaaŋ bɛ mɛɛŋ yɛ be wɛki kimfikisɛ shéŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kɛ kwɛɛŋ wu la, wu kɛmi bɛsiri yoofi, mumkpaŋ la lɛ bee lɛnti wu se chikɛ nshiiŋ? Gii leeki tɔŋ kɛ lambo yiiri, fweyɛ yih, se gɔɔŋ bujɔŋ nsiiŋ mfi wu ŋɛŋ ni? ");
INSERT INTO asj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ke wu gɔɔŋ wu ŋɛŋ, gii teenyɛ nsáŋ yee bɛ bɛniiŋ bɛ tsiiŋ li wuu lichiŋ se tee le, ‘Bɛ yɛɛŋ tɛɛbeŋ tɛ ni tɛ nɛki kii siri wɛŋ bee la, mi se ntuu mi ŋɛŋ.’ ");
INSERT INTO asj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ntee beŋ le, ɛ lɛ si bɛnchindaa bɛ Nyɔ-ɔ ti nɛki kii wi wu bifi mumkpaŋ wu fiiki shéŋ yee.” ");
INSERT INTO asj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jiso tuu gɛɛŋ limfwe tee le, “Wumu tɛ̀ kɛmi bɔɔŋ bee bɛ buniŋ bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wu lɛjiŋ wɛ se dza tee li wuu le, ‘Taa, gatɛ bieŋ bishɛyɛ ɔ nyɛ mi dɛɛni.’ Tee se dza gatɛ bishɛyɛ bilu li bee. ");
INSERT INTO asj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ŋwaŋ wu bwi wɛ fi biee bishɛyɛ, le jo ka niiŋkwaa, banchɛ biee biee bichu kabɛ dza la dɛndɛ li kwɛɛŋ wumu mfiiŋ, gɛɛŋ bonyɛ kwa wulu li ntsɛ wu waniti-i. ");
INSERT INTO asj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Le bonyɛ fiee fichu fi tɛ̀ kɛmi, dzeeŋ yi tɛɛmi se dza yi kɔɔ li kwɛɛŋ wɛɛ, bɛchi fuki fiee fijɛ. ");
INSERT INTO asj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Se dza gɛɛŋ gɔɔŋ nimɛ li wumu-u wu li kwɛɛŋ wɛɛ le ni nindi li wuu. Wi wulu se toŋ wu gɛɛŋ kiichi dzíiŋ yee. ");
INSERT INTO asj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Se dza beechi le gii ni jii fɛ bijinɛ bi dzíiŋ tɛ̀ jii biɛɛ, se nuuŋ le wi ti mɛɛŋ ki nyɛɛ wu fiee fimu le ji kɛ. ");
INSERT INTO asj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Se tuu dza bɛchi seki biee, teeŋ bufii bwee lijiŋ, tuu tee li yi yee li le, ‘Bɛniiŋ bɛ nindi li taa li, kɛmi baa biee bijɛ ŋge bi yɛki be, ŋkwii fɛni bɛ dzeeŋ. ");
INSERT INTO asj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ŋgii dza ŋgɛɛŋ lɛ Taa li, ntee li wuu le, “Taa, mi mfɛɔ biee bibifi li Nyɔ-ɔ yi liboo li mɔɔ li wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mɛɛŋɔ ki kɔchɛ kɛ le bɛ ni bɛ teenyi mi le ŋwana kɛ. Yo dzɔɔ mi dɛɛni si wi wa wu nimɛ.”’ ");
INSERT INTO asj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bɛdɛɛni, se dza tuu lijiŋ lɛ tee li. Le ni mɛɛŋ se fɛsi fɛkuuŋ, tee lɔŋ lii ŋɛŋ wu. Nshiiŋ kɔɔ wu bɛ ŋwaŋ wulu, dza we, letɛ gɛɛŋ, kokɛ wu, nyɔɔchɛ wu. ");
INSERT INTO asj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ŋwaŋ wulu se tee li wuu le, ‘Taa, mi mfɛɔ biee bibifi li Nyɔɔ mɔɔ li wɛɛ. Mɛɛŋɔ ki kɔchɛ kɛ le bɛ teeŋ mi le ŋwana kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Se nuuŋ le, tee tɛ̀ tuu teeŋ bɛniiŋ bee bɛ nimɛ-ɛ tee le, ‘Gɛnɛ yɛɛŋ tsɛkɛ, nɛ bichɛ ndú yi dzeeŋ ŋge, nɛ bɛ nɛ chuumɛ wu li bwiŋ, nɛ lii wu finsɛŋɛ li kwaŋ wee li, mɔɔ bikpɔ li bikaa biee li. ");
INSERT INTO asj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nɛ se gɛɛŋ nɛ kɔɔ kintomɛ ki fɔ-ɔŋ, nɛ sɛɛ ki, tɛ ni tɛ jii tɛ nɛki, ");
INSERT INTO asj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kifɛ ŋwanɛŋ wuni tɛ̀ kwi, wu se tuu wu bo. Tɛ̀ la wu se tuu wu yenɛ.’ Bɛdɛɛni, be se tuu be bɛchi be nɛki. ");
INSERT INTO asj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Fiee fini tɛ̀ kɛti lɛ, ɛ ŋwaŋ wu kaaŋ wɛ tɛ̀ nuuŋ fiee litɔɔ. Le ni kuuki, le bɛ bo lu laa lichiŋ, woo si bɛ kuti biee, bɛniiŋ bindi. ");
INSERT INTO asj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Se teeŋ wi wu nimɛ wumu, bii li wuu laa bɛ bindi nuuŋ la le? ");
INSERT INTO asj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wi wulu tuu li wuu le, ‘Ŋwaana bee kaari bɛŋ. Chaa wunɛ se sɛɛ kintomɛ kinaaŋ ki fɔ-ɔŋ, kifɛ bee ŋɛŋ ŋwaana mɛɛŋ we, tɛɛmi.’ ");
INSERT INTO asj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Le woo lɛ, shéŋ tuu yi bee wu, se faaŋ fiee nlɛ li yih. Tee se bo gɛɛŋ suŋgi bɔ li wuu le bɛ lɛ nɛɛ li yih. ");
INSERT INTO asj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Se nuuŋ le, ŋwaŋ wulu se tuu li tee li le, ‘Bichɛ ɔ ŋɛŋ, nshiiŋ nindi li wɛ-ɛ si mfwa li biya bini bichu-u, mɛɛŋɔ nsaa ki faaŋ kɛ mfɛru fintoŋ fio fimu kɛ. Ɔ ti mɛɛŋɔ saa ki nyɛ kɛ mi mɔɔ nuuŋ fi ŋwaaŋ bi le ni nɛki tɛɛ nsáŋ yɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Le ŋwana wuni wu tɛ̀ gɛɛŋ wu bonyɛ bishɛyɛ bɛ binjiŋkwiiŋ tuu kaari bɛ, ɔ se tuu ɔ kɔɔ kintomɛ ki fɔ-ɔŋ ɔ sɛɛ kii wu.’ ");
INSERT INTO asj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tee tuu li wuu le, ‘Ŋwanɛŋ, ɛ tɛɛ wɛ tɛ ti nuuŋ fɛni mfi kwi, fiee fichu fi ŋkɛmi ɛ nɛɛ fio. ");
INSERT INTO asj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Se nuuŋ le, fi bee fi dzɔɔŋ le tɛ ni tɛ nɛki kifɛ ŋwaana wuni tɛ̀ kwi, wu se bo, tɛ̀ la, wu se tuu wu yenɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jiso tuu tee li bɔɔŋ bee bɛ kintutu-u le, “Wi wu biee wumu tɛ̀ kɛmi ŋwani wu nimɛ wu tɛ̀ gɛɛ le ni bichi lɛ biee biee li. Tɛ̀ dza woo le ŋwaŋ wu nimɛ wulu bifisɔɔ kwa wee, ");
INSERT INTO asj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","se teeŋ ŋwani wu nimɛ wulu bii li wuu laa, ‘Fiee fi ŋwuki kii wɛ fini nuuŋ la? Banchɛ biŋwaati bichu bi ɔ tsɛki kwa wɛŋ le ɔ bɛ bɛ bi. Kifɛ ɔ mɛɛŋ yɛ le ɔ ni ɔ nindi li mi-i kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ŋwaŋ wu nimɛ wɛ gɛɛŋ shee beechɛ li yi yee li le, ‘Si te kikoo wɛŋ gii buu mi li nimɛ-ɛ lɛ, ɛ la fi ŋgii ŋge? Si ŋkɛmi yɛ buŋga bu nimɛ bɛ jii kɛ, ntuu nuuŋ tɛ bɛ buya bu munlɛɛkɔɔ lɛ ni.’ ");
INSERT INTO asj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Se tuu dza beechɛ le, ‘Mi ŋkɛɛɔ fiee fi ŋgii mfɛ mfi wu bɛ buu mi li nimɛ-ɛ. Ŋgii ŋkɛmɛ nsáŋ yi gii yi ni yi fii mi li yíh yi bee.’ ");
INSERT INTO asj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Se biee teeŋ bɛniiŋ bɛ tɛ kɛmi fíɔɔ yi te kikoo we mumkpaŋ mumkpaŋ. Le wu ŋkosi bɛ, bii li wuu laa, ‘Ɔ kɛmi te Kikoo wɛŋ kwa kimɛ?’ ");
INSERT INTO asj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mwɛ tuu le, ‘Biginu bi mɛɛŋ lɛ bi nɔŋa bi nɔŋa gwii.’ Se tee le, ‘Kɔ kiŋwaati ko ki fiɔɔ lɛ kini ɔ shee fɛkwiiŋ tsɛkɛtsɛkɛ ɔ fiiki ɔ tsɛɛ le mbaanshiŋ.’ ");
INSERT INTO asj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Se tuu kaari bii li wumu le, ‘Ɔ kɛmi ya niŋ?’ Se mwɛ tuu le, ‘Ɛ bɛbabi bɛ giiŋ lɛ gwii.’ Se tee le, ‘Kɔ kiŋwaati ko ki fiɔɔ lɛ kini ɔ fiiki ɔ tsɛɛ le bɛbabi gwii nyaaŋ.’ ");
INSERT INTO asj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Le te kikoo wu ŋwanɛ nimɛ wɛ ŋɛŋ si wu fiiri wu lɛ, tuu pia wu ŋge li kimfi kee li.” Jiso se mɛɛshi tee le, “Bɛniiŋ bɛ laaŋkwiiŋ kɛmi baa bufii bu fɛrɛ biee bi bee, yɛki si bɛniiŋ bɛ li kiŋ'wofu ti feti bi bee biee bi kiŋ'wofu-u. ");
INSERT INTO asj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nse ntiitɔɔ li be-eŋ le, nɛ dzɔɔ biee binɛ bi laaŋkwiiŋ nɛ kɔɔ nsáŋ lu, ke mfi wu bi ma, Nyɔ se fi beŋ li wuu yih fɛ nɛ gii nɛ ni nɛ nuuŋ mfi kwi. ");
INSERT INTO asj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wi wu kii mbichɛ lɛ fiee fi niiŋ li bujɔŋ, kɛ nuuŋ kɛɛ mbichɛ lɛ fi nɔŋa-a. Wi wu feti kimfi li fiee fi niiŋ li, kɛ gii fɛ tɛ li fiee fi nɔŋa-a. ");
INSERT INTO asj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ɛ nɛ nuuŋ tɛ kɛɛ mbichɛ lɛ biee bi laaŋkwiiŋ bini-i bujɔŋ kɛ, ɛ noo wu gii se nyɛ beŋ biee bi chɛɛŋ? ");
INSERT INTO asj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ɛ nɛ kii yɛ mbichɛ lɛ fiee fi wumu-u bujɔŋ kɛ, ɛ noo wu gii se nyɛ tɛ beŋ binɛ? ");
INSERT INTO asj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nuuŋ ŋwaŋ wu nimɛ tɛ niŋ li bɛ te bikoo li bɛfɛ kɛ. Ɛ nindi lɛ, kɛ gii ni baanini wumu, kɔŋgisi wumu, gii ni wuki li wumu bujɔŋ, se tɛ̀ dzɔ wumu li fiee li kɛ. Nuuŋ nɛ tɛ niŋ li Nyɔ-ɔ, le nɛ tuu nɛ niŋ li kwa-a kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Le Jiso yɔ lɛ, Bɛfarasii woo fiee fichu be dza be yɛndi wu, kifɛ be tɛ kɔŋgisi kwa ŋge. ");
INSERT INTO asj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jiso se tee li bee le, “Ɛ nɛɛ beŋ nɛ feti yi le nɛ ni nɛ nuuŋ bɛniiŋ bɛ dzeeŋ limfwe li bɛniiŋ li, se nuuŋ le, Nyɔ kii yɛ biee bichu bi nuuŋ li shéŋ yinɛ. Nɛ ni nɛ kii le biee bi bɛniiŋ piɛti le ɛ bi dzeeŋ ŋge, ɛ bi bi Nyɔ bichi le ɛ biee bi bɛndi yi.” ");
INSERT INTO asj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jiso tuu tee le, “Tɛ nuuŋ ŋkosi bɛ tiifi nuuŋ bɛnchi bɛ Mɔɔsɛ-ɛ bɛ biee bi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛki. Se nuuŋ le, mbɛɛchɛ si Jɔɔŋ tɛ̀ bɛ, bɛ tɛ̀ to bɛ tiifi nuuŋ ntoŋ wu dzeeŋ wu kii bumfɔŋ bu Nyɔ-ɔ. Wi kwikwi gweninɔɔ le bɛ lɛ lɛnti lɛ bumfɔŋ bu Nyɔ-ɔ tɛ. ");
INSERT INTO asj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Fi nuuŋ tsɛkɛ fɛ kiboo bee nshɛ nuuŋ bi ma, yɛki fɛ biooŋ yi lɛ kiŋwaati ki bɛnchi bɛ Nyɔ-ɔ nuuŋ yi la li yee li. ");
INSERT INTO asj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Fi se fiɛɛ le, ɛ wi kooŋ bɛ kwɛsi, wu dzɔ wumu, kɛ wu giŋɔ bɛ kwɛɛ wi. Wi wu dzɔ kwɛɛŋ wu bo li wumu-u, kɛ mwɛ giŋɔ tɛ bɛ kwɛɛ wi.” ");
INSERT INTO asj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jiso se dza tee le, “Wi wu biee wumu tɛ̀ nuuŋ lu, chumini ndú yi dzeeŋ yi tɛɛmi kwa, tsiiŋ ntsɛ wu shaaŋ jo chichi. ");
INSERT INTO asj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wi wu kifoo wumu tɛ nuuŋ lu, bukooŋ le Lasɔrɔ. Ɛ bikɔti tɛ ji wu bwiŋ kichu. Bɛ tɛ̀ giiki wu fɛ wi wu biee wɛ mfweeŋ, ");
INSERT INTO asj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","tɛŋgi le gii ni bɔɔnyi jii fɛ biee bi weyi fɛ kideŋ ki wi wu biee wɛɛ. Si tɛ̀ gimi fe lɛ, bwí tɛ̀ tuu yi bɛɛ yi mɛrisi yi lachi bikɔti biee biɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Le ni nuuŋ mfi wumu, wi wu kifoo wulu kwi, bɛnchindaa bɛ Nyɔ-ɔ too wu be gɛɛŋ be gɛɛ wu fɛ kintsii ki dzeeŋ li, li Abrahaŋ lichiŋ. Wi wu biee wɛ kwi tɛ bɛ diyɛ wu. ");
INSERT INTO asj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Gɛɛŋ nuuŋ li kwɛɛŋ wu biŋkwi-i, nuuŋ fe li ŋgɛ wu nyɔŋa-a. Le dza lɔŋ lii, ŋɛŋ Abrahaŋ mfiiŋ bɛ Lasɔrɔ li wuu lichiŋ. ");
INSERT INTO asj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Teeŋ le, ‘Taa Abrahaŋ, kɔɔ nshiiŋ bɛ mi ɔ tuumi Lasɔrɔ lii kwaŋ li dzɔɔ li, bɛ deeni nimi cheŋ lu. Ŋ'wukɔɔ ntɔnyɛ wu nyɔŋa li wi wuni-i.’ ");
INSERT INTO asj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahaŋ tuu li wuu le, ‘Ŋwaanɛŋ, kimi mfi wɔɔ tɛ mɛɛŋ ɔ tsiiŋ li nshɛ-ɛ. Ɔ tɛ̀ kɛmi biee bi dzeeŋ bichu mfi wɛ, Lasɔrɔ ŋiŋgi fiee nuuŋ ŋgɛ. Dɛɛni, Lasɔrɔ wɛ li bujɔɔŋ li, ɔ nuuŋ li ntɔnyɛ. ");
INSERT INTO asj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɛ fini kwaa kɛ. Ɔ kɛɛ le foŋɛ chi nɔŋa chi bɛ nachɛ chɛɛ tɛɛbeŋ nti le kiiŋ wi ni dza lani dansɛ bɛ fɔɔ nuuŋ fɛɛ kɛ, se nuuŋ nɛɛ tɛ wi tɛ dza fɔɔ nuuŋ fɛɛ le dansɛ bɛ lani kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Se wi wu biee wɛ tuu lɛkɛ le, ‘Mintemii taa, tuumi Lasɔrɔ fɛ besɛ kuuŋ. ");
INSERT INTO asj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ŋkɛmɔɔ bɛŋwaanɛŋ bɛtiinu, gɛɛŋ chiinsɛ li bee le kiiŋ be ni naa be bɛ tɛ fɛ kintsii ki ŋgɛ kini kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahaŋ se tuu le, ‘Bɛ ŋwaana bɛlu kɛmi baa biŋwaati bi bɛnchi bɛ Mɔɔsɛ tɛ̀ tsɛɛ bɛ bi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛɛ, be ni be wuki fiee fi bi tiiti.’ ");
INSERT INTO asj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wi wu biee wɛ faaŋ tee le, ‘Aay, Taa Abrahaŋ, bee nuuŋ le wumu bo li kwe-e gɛɛŋ ni tiifi be, be se woo, be fiiki shéŋ yibe.’ ");
INSERT INTO asj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahaŋ se tuu li wuu le, ‘Ɛ be faaŋ le be wuki yɛ fiee fi Mɔɔsɛ bee bɛntomfɔŋ bɛ Nyɔ-ɔ tiiti kɛ, be tɛ naa woo mɔɔ nuuŋ fiee fi wi wu bo li kwe-e tiiti kɛ.’” ");
INSERT INTO asj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jiso tee li bɔɔŋ bee bɛ kintutu-u le, “Biee bi teeki bɛniiŋ le be ni be feti biee bibifi nuuŋ bi tɛ̀ ma kɛ. Se nuuŋ le, ŋgɛ wu nyɔŋa wɛ li wi wu teeki bɛniiŋ le be ni be weyi li biee bibifi-i. ");
INSERT INTO asj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bee fi dzɔɔŋ le wɛɛ wi bɛ shiiŋɛ wu jeni li kimi-i, bɛ bachɛ wu li dzɔɔ yi nyɔŋa-a kii ni fɛ bɔɔŋ bani ni be feti biee bibifi. ");
INSERT INTO asj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ɛ nɛ nuuŋ lɔɔ nɛ dzeti yɛɛŋ mfi. Ɛ ŋwaana fɛ fiee fi bifi, ɔ yɔ li wuu. Ɛ wu fiiki, ɔ feeki wu. ");
INSERT INTO asj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ɛ wu fɛ biee bibifi li wɛ-ɛ kiŋga mfomɛnyaaŋ li jobɛ-ɛ, ɛ wu faaŋ le, nuuŋ tɛ kaari le soŋ bɔ le wu fɛɔ bubiɛɛ kɛ, kɛ ɔ kɛmi nɛɛ le ɔ ni ɔ fekisi wu.” ");
INSERT INTO asj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bɔɔŋ bɛ ntoŋ bɛ Taa lɛ dza be tee li wuu le, “Fɛrɛ se kimbeenchɛ kisɛŋ tɛmi ŋge.” ");
INSERT INTO asj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Taa tuu le, “Bee le nɛ ni nɛ kɛmi kimbeenchɛ ki sendɛ mɔɔ nuuŋ si shaŋ yi finsoo, kɛ nɛ nuuŋ ɛ nɛ tee le kiti ki nɔŋa kini dza fɛni ki gɛɛŋ ki leŋ li dzɔɔ yi nyɔŋa, ki woo li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dzɔɔ yɛɛŋ le wi wumu lɛ be-eŋ lɛnti kɛmɔɔ ŋwani wu nimɛ, wu bee shi nindi li wɛ we-e li, kɛ bichi lɛ nshɔ́ɔŋ yee li, mfi wu koo, gii tee li ŋwaŋ wu nimɛ wulu le gɛɛŋ dzɔ biee bijɛ shee ni jii ni? ");
INSERT INTO asj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Fi nuuŋ yɛ lɛ kɛ. Fiee fi nuuŋ tee nuuŋ le gɛnɛ ɔ buushɛ ndú, ɔ nachɛ biee bijɛ ɔ bɛ bɛ bi, ɔ ni ɔ tɛŋgi ke mi nji mi ŋ'woŋ mi mɛɛshi ɔ se gɛɛŋ ɔ ji bio. ");
INSERT INTO asj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ŋwaŋ wu nimɛ wuni fetɔɔ biee bini bichu, gii nyɛ mɔɔ wu kiyɔɔni ni? ");
INSERT INTO asj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Fi fiɛɛ lɛ bɛ beŋ. Ɛ nɛ niŋ nimɛ chi bɛ nyɛ li be-eŋ chi ma, nɛ tee le, ‘Tɛ baa fisɛŋ bɔɔŋ bɛ nimɛ-ɛ, tɛ feti baa nɛɛ nuuŋ nimɛ chi tɛ bee tɛ kɛmi le tɛ fɛ kwaa.’” ");
INSERT INTO asj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Le Jiso ni giiŋgi Jɛrosalɛŋ tɛ̀ gii kɛti lɛ ŋgagwii wu kwɛɛŋ wu Samaaria bɛ wu Galilii. ");
INSERT INTO asj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Le gɛɛŋ ni lii li kitoŋ kimu-u, buniŋ bamu yoofi bɛ tɛ̀ gendi bɛ chigɔŋ chi nɔŋa ŋɛŋ wu mɛɛŋ mfiiŋ, ");
INSERT INTO asj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","be bɛchi be teenyi wu bɛ jɛ yi tɛɛmi le, “Jiso te bɛniiŋ, kɔɔ nshiiŋ bɛ bee.” ");
INSERT INTO asj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Le Jiso ŋɛŋ be, tee le, “Gɛnɛ yɛɛŋ nɛ doonchɛ yi yinɛ li bɛte muntofi-i.” Si be tɛ̀ dza be giiŋgi lɛ, be tɛmi be woo be mɛɛŋ dze. ");
INSERT INTO asj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wi wumu lɛ bee lɛnti ŋɛŋ le wu tɛmɔɔ, tuu kaari to lijiŋ lɛ Jiso-o yɔɔnchi Nyɔ lɛwe ŋge. ");
INSERT INTO asj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Si tɛ̀ bɛ lɛ we fɛkwiiŋ li Jiso-o limfwe yɔɔnchi wu. Ɛ wi wulu tɛ nuuŋ wi wu Samaaria. ");
INSERT INTO asj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jiso tee le, “Bɛniiŋ bee be nuuŋ yoofi bɛ mbee mfɛ be woo, bɛ mfomɛyoofi nuuŋ fɛŋ? ");
INSERT INTO asj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Fi nuuŋ le wi nuuŋ yɛ lu wu ŋɛŋ le mwɛ nuuŋ kaari to lijiŋ nyɛ n'yɔɔnchɛ li Nyɔ-ɔ fuki nɛɛ kilɔ kini siŋ ni?” ");
INSERT INTO asj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jiso se tee li wuu le, “Dza we ɔ ni ɔ giiŋgi fio. Shéŋ ya yi ɔ gɛɛ li mi fɛ yɛɛ ɔ tɛmi.” ");
INSERT INTO asj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bɛfarasii tuu be dza be bii li Jiso laa bumfɔŋ bu Nyɔ-ɔ gii bu bɛ nuuŋ buŋ le. Se tuu le, “Ndoonchɛ nuuŋ yɛ lu wu gii doonchɛ mfi wu Nyɔ gii yi bɛchi yi ni yi sɛki bumfɔŋ bwee kɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wi nuuŋ yɛ lu wu gii ni tiiti le, ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, Nyɔ sɛki yɛ fɛni, kɛ le yɛɛ yi yi sɛki fɛɛ kɛ,’ yikɛ yɛɛŋ nɛ woo bumfɔŋ bu Nyɔ-ɔ bwɛɛ li shéŋ yinɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Se tuu kaari yɔ kituŋ li bɔɔŋ bee bɛ kintutu li le, “Mfi gii bɛ wu nɛ gii nɛ ni nɛ geendi le nɛ ŋɛŋ Ŋwanɛwi jobɛ chimumkpaŋ kwaa nɛ tɛ ŋɛŋ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gii ni nuuŋ li mfi wɛɛ, bɛniiŋ bamu gii be ni be tiiti le, ‘Bichɛ yɛɛŋ nɛ ŋɛŋ, wuu wu fɛ fii yɛ’, kɛ le, ‘Bichɛ ɔ ŋɛŋ, wɛ fɛni.’ Ɛ be tiiti lɛ, kiiŋ nɛ ni nɛ biki be nɛ giiŋgi le nɛ bichi kɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nɛ kii si dzaaŋ ti shiiŋ yi lɛbi liwe ni mwaŋmwaŋ, bimbɛ bi kwɛɛŋ lɛ bi binɛɛ bichu woo ni ŋwaaŋ, bɛniiŋ bɛchu ŋɛŋ. Ɛ nɛɛ lɛ si bɛniiŋ bɛchu gii be ŋɛŋ Ŋwanɛwi li jobɛ chi wu kaari wu bɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Se nuuŋ le, si gii gɛɛŋ se kaari bɛ lɛ, kɛmi le saa ŋɛŋ bumfa ŋge, se kiŋgɔkɛ ki dɛɛni kini faaŋ wu. ");
INSERT INTO asj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ɛ nɛɛ lɛ si fi tɛ̀ nuuŋ li mfi wu Noaa li, ɛ fi fi gii fi naa fi nuuŋ li mfi wu Ŋwanɛwi-i. ");
INSERT INTO asj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bɛniiŋ tɛ̀ jii be wundi, bukɛɛŋ bɛ buniŋ feti bugoo, bɛniiŋ nyɛɛ bɔɔŋ bɛ bee bɛ bukɛɛŋ bɛ buniŋ dzeti be li baa, gɛɛŋ bo jobɛ chi Noaa tɛ̀ lɛ lɛ yih yi dzɔɔ li se dzɔɔ bo yi woyɛ be bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Fi gii fi nuuŋ nɛɛ tɛ lɛ si fi tɛ nuuŋ li mfi wu Lɔ-ɔt. Bɛniiŋ tɛ̀ jii be wundi, be feti waŋ, be nindi yɛ́h, be gwɛndi yíh. ");
INSERT INTO asj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jobɛ chi Lɔt tɛ̀ dza Sɔdɔŋ, Nyɔ tɛ̀ biee yi shiiki wi liwe wu duti si mukaŋ, wu shee wu duuri bɛniiŋ bɛ Sɔdɔŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ɛ lɛɛ si fi gii fi nuuŋ jobɛ chi Ŋwanɛwi gii naa taa mbundɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Fɛ gii naa ni nuuŋ jobɛ chilu, kiiŋ wi wu nuuŋ lɛ yi-ih lɛwe wu biee biee nuuŋ li yih, tuu shee lɛ li yih le dzɔɔ, kɛ le letɛ kɛ; Ɛ nɛɛ yɛɛŋ tɛ le, kiiŋ wi wu nuuŋ litɔɔ kaari to fɛkuuŋ le gɛɛŋ dzɔɔ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kimi yɛɛŋ fiee fi tɛ̀ ka bɛ kwɛɛ Lɔt. ");
INSERT INTO asj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wi wu wɛki le kiri ntsɛ we kii ni lɛɛ, kɛ gii lɛɛ wu, wi wu lɛɛ ntsɛ we, kɛ gii kɛmɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ntee beŋ le, gii ni nuuŋ butuu bulu, bɛniiŋ gii be ni be gimi fɛntaa bɛfɛ, bɛ dzɔɔ mumkpaŋ wumu shɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bukɛɛŋ bɛfɛ gii be ni be geki bunɛɛŋ fɛ jeeŋ, bɛ dzɔɔ mumkpaŋ wumu shɛ. ");
INSERT INTO asj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Buniŋ bɛfɛ gii be ni be nuuŋ liwɛ, se bɛ dzɔɔ mumkpaŋ wumu shɛ.” ");
INSERT INTO asj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bɔɔŋ bee bɛ kintutu se bii li wuu laa, “Taa, fiee fini gii fi ka nuuŋ fɛŋ?” Tuu nuuŋ lɛ ŋgaŋgaa li le, “Fɛ kiŋkwi ki fiee lɛ nuuŋ fe, ɛ fe fɛ biŋguru taashi.” ");
INSERT INTO asj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jiso wa ŋgaŋgaa chimu le tifi bɔɔŋ bee bɛ kintutu-u, le be kɛmi le be ni be lɛki li Nyɔ-ɔ mfi kwi mfiɔŋu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tee le, “Wi wu sɛki bɛnsa wumu tɛ̀ nuuŋ li kitoŋ kimu-u, tɛ̀ chɛndi yɛ Nyɔ kɛ, dzeti yɛ tɛ wi li fiee li kɛ. ");
INSERT INTO asj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kwɛɛŋku wumu tɛ̀ nuuŋ tɛ li kitoŋ kilu-u. Tɛ shiiŋ giiŋgi mfi kwi suuŋgi bɔ li wi wu sɛki bɛnsa wɛ-ɛ le, mwɛ fi wu sondɛ nsa wu bee wi we wu mbani. ");
INSERT INTO asj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wi wulu tɛ̀ nyɛɛ yɛ bintooŋ le kɛ, kwɛɛ ŋku wɛ ba bɛɛ fe jo chi. Lɛjiŋ lɛ lu wi wulu tee le, ‘Mɔɔ nuuŋ le nchɛndi yɛ Nyɔ kɛ, ndzeti yɛ wi li fiee li kɛ, ");
INSERT INTO asj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","se nuuŋ le si kwɛɛ ŋku wuni bɛɛ nyɛɛ mi ŋgɛ ni, ŋgii ŋɛŋ le nsondɛ nsa we wuni si wɛki, ɛ foo lɛ siŋ, ba ni bɛɛ fieŋgisi mi, ntaa ndza ŋkwi lɛ wuu bɔ.’” ");
INSERT INTO asj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Le Taa wa lɛ, tuu tee le, “Woo yɛɛŋ fiee fi wi wu sɛki bɛnsa bɛ kimfi wuni tɛ̀ tee. ");
INSERT INTO asj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Si tɛ̀ fi kwɛɛ ŋku wɛ lɛ, Nyɔ gii se leeki fi kɛ tɛ bɛniiŋ bee bɛ tɛ̀ tsaa bɛ dii li yi-i butuu mɔɔ fɛnshaaŋ ni? Yi gii se tuu yi chee yi ni? ");
INSERT INTO asj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ntee beŋ le Nyɔ gii yi sondɛ nsa wu be tsɛkɛ. Se nuuŋ le Ŋwanɛwi gii ke karisi bɛɛ ŋɛŋ nɛɛ ɛ bɛniiŋ gɛɛ shéŋ li Nyɔ-ɔ laaŋkwiiŋ nɛɛ lɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jiso tuu dza wa ŋgaŋgaa chimu nuuŋ li bɛniiŋ bɛ tɛ̀ ŋiŋgi yi yibe le be baa bɛniiŋ bɛ tsaaŋ, be se nyamisi bɛniiŋ bamu. ");
INSERT INTO asj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tee le, “Bɛniiŋ bamu bɛfɛ tɛ̀ dza be yɛɛ li yih yi muntofi-i le be lɛkɛ li Nyɔ-ɔ. Wumu tɛ̀ nuuŋ wi Bɛfarasii, wumu se nuuŋ wi wu kundi kiŋwaati. ");
INSERT INTO asj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Be gɛɛŋ be lɛ, wi Bɛfarasii wɛ gɛɛŋ leŋ fiee wuu mbiiŋ lɛki li Nyɔ-ɔ le, ‘Nyɔ, nyɛɛɔ kiyɔɔni li wɛ-ɛ kifɛ nnuuŋ yɛ si bɛniiŋ bamu kɛ. Lii ti yɛchi yɛ mi bɛ biee kɛ. Nti mfeti yɛ kimfi kɛ. Nti mbiki yɛ bukɛɛŋ bɛ bɛniiŋ lɛ kɛ, nnuuŋ yɛ si wi wu kundi kiŋwaati wɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nti njiti biee bijɛ jo faa li fuu li. Nti nyɛɛ kimbɛ kimumkpaŋ li wɛ-ɛ lɛnti lɛ bimbe yoofi bi biee bichu bi kɛmi-i.’ ");
INSERT INTO asj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Se nuuŋ le, wi wu tɛ̀ kundi kiŋwaati wɛ tɛ̀ leŋ fiee mfiiŋ, ti mɛɛŋ mɔɔ liwe ki bichi kɛ, chiŋ kikoo, lɔŋ ki tuu lɛki le, ‘Hooo Nyɔ, nnuuŋ fieŋ wi wu bifi, kɔɔ nshiiŋ bɛ mi.’” ");
INSERT INTO asj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Le Jiso wa ni, biee tee le, “Ntee li be-eŋ le wi wu tɛ̀ kundi kiŋwaati wɛ tɛ̀ bo beki li wuu yih nuuŋ tsaaŋ lɛ Nyɔ lii nuuŋ yɛ si wi wu Bɛfarasii wɛ kɛ. Fi fiɛɛ nɛɛ lɛ le wi kwikwi wu yɛkisi yi yee bɛ gii bɛ shiiki wu, se wi kwikwi wu shiiki yi yee, bɛ gii bɛ yɛɛki wu.” ");
INSERT INTO asj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bɛniiŋ tɛ̀ dza be bɛɛ bɛ bɔɔŋ bɛ bwi lɛ Jiso le koŋ li bee. Le bɔɔŋ bee bɛ kintutu ŋɛŋ lɛ, be bɛchi be wami be. ");
INSERT INTO asj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Se nuuŋ le, Jiso teeŋ bɔɔŋ bɛlu le be ni be bɛɛ, tee li bɔɔŋ bee bɛ kintutu le, “Gɛɛ yɛɛŋ bɔɔŋ bɛ bwi ni be bɛɛ lɛ mi-i. Nɛ baŋɛ kɛ be kɛ, kifɛ bumfɔŋ bu Nyɔ-ɔ bwɛɛ nuuŋ li bɛniiŋ si bani-i. ");
INSERT INTO asj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ntee beŋ chɛɛŋ le, ɛ wi mɛɛŋ ki fi kɛ bumfɔŋ bu Nyɔ-ɔ si ŋwaŋ wu bwi kɛ, mwɛ tɛ̀ naa mɔɔ lɛ lɛ bumfɔŋ bulu-u kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wi wu nyɔŋa wumu bii li Jiso laa, “Wi wu ntiifɛ wu dzeeŋ, fiee fi ŋkɛmi le mfɛ nse ŋkɛmɛ ntsɛ wu kimakɛ nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jiso bii li wu laa, “Ɔ teenyi mi le wi wu dzeeŋ kii la? Wi nuuŋ yɛ lu wu nuuŋ wi wu dzeeŋ kɛ. Ɛ nɛɛ Nyɔ kwaa yi nuuŋ wi wu dzeeŋ. ");
INSERT INTO asj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Se nuuŋ le, li nto jiŋ li fiee fi ɔ bee ɔ bii li, ɔ kii bɛnchi bɛ tiiti le, ‘Kiiŋ ɔ ni giiŋ bɛ kwɛɛ wi kɛ, kiiŋ ɔ ni wo wi kɛ, kiiŋ ɔ ni ɔ yi-i biee kɛ, kiiŋ ɔ ni leŋ lɛ nsa wu binsɛɛ li lɛjiŋ kɛ’, mɔɔ wu tiiti le, ‘Ɔ guundi chaa bee na ni’?” ");
INSERT INTO asj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mwɛ tuu le, “Bɛnchi bani bɛchu ntɛ̀ mbɛchi kii be fɛ ntɛ̀ mɛɛŋ sɔnɛwi.” ");
INSERT INTO asj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Le Jiso woo lɛ, tee li wuu le, “Fiee shɛ fiɛɛ fimumkpaŋ fi ɔ mɛɛŋɔ le ɔ fɛ. Gɛnɛ ɔ kabɛ biee bio bichu, ɔ gachɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ, ɔ se kɛmɛ bulofu liboo, ɔɔ fɛ lɛ, ɔ se biee mi.” ");
INSERT INTO asj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Le mwɛ woo lɛ, yi bee wu, kifɛ tɛ kɛmi biee ŋge. ");
INSERT INTO asj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jiso bichɛ wu, tee le, “Fi tɛɛmi ŋge fɛ wi wu biee nuuŋ lɛ lɛ bumfɔŋ bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Fi fiɛɛ tsɛkɛ fɛ kikuŋ nuuŋ ki lɛ lɛ fiooŋ yi nsara-a yɛki fɛ wi wu kwa nuuŋ lɛ li bumfɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Le bɛniiŋ bɛ gii be nuuŋ fe woo lɛ, be biee be bii laa, “Ɛ fi nuuŋ lɛ, noo se naa bo lu?” ");
INSERT INTO asj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jiso se tuu le, “Fiee fi yɛki bɛniiŋ le be fɛ, fi nuuŋ tɛ yaa Nyɔ mfɛru kɛ”. ");
INSERT INTO asj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita tee li wuu le, “Bichɛ ɔ ŋɛŋ, tɛ chinɛ baa biee bisɛŋ, tɛ biki wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jiso tuu li bee le, “Ntee beŋ chɛɛŋ le wi lu kɛ wu chinɛ la we, kɛ kwɛsi, kɛ bɛŋwaani, kɛ tee bee ni, kɛ bɔɔŋ bee kii bumfɔŋ bu Nyɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wu nuuŋ tɛ kɛmɛ bɛniiŋ bɛ biee ŋge li ntsɛ wuni, yaa bi wu shɛ kɛ. Ke fɛ nuuŋ li mfi wu bɛɛ li, gii kɛmɛ ntsɛ wu kimakɛ.” ");
INSERT INTO asj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jiso dza dzɔ bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ bɛfɛ baa bee be waaki yi. Tee li bee le, “Yikɛ yɛɛŋ nɛ woo, tɛ yɛki baa Jɛrosalɛŋ, ke tɛ yɛɛ tɛ bo fe, fiee fichu fi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛki kii Ŋwanɛwi bɛ fi kɔchɛ. ");
INSERT INTO asj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Fi fiɛɛ le bɛ gii bɛ nyɛ wu li tsaŋ yi mfo-oŋ, be ni be yɛndi wu, be ni be gaashi wu, be kwiyi wu bɛ budii li bushi-i. ");
INSERT INTO asj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Be gii be fiaaŋ wu bɛ muŋwaaŋ, be wo wu, ke bo jo taa, bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jiso tee lɛ, fi fuumi be, be mɛɛŋ ki kɛɛ kɛ laa wu tee le la le kɛ, kifɛ fiee fimu tɛ gii fi feti le kiiŋ be ni kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Le Jiso ni fɛɛshi kitoŋ li ki Jɛriko-o, ɛ kinyɛɛ kimu tɛ̀ shee li ŋgemɛ yi dze-e ki lɛki biee. ");
INSERT INTO asj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ki woo si kintutu ki bɛniiŋ lɛ kimu kɛti, ki bii laa, “Ɛ la fi kɛti le?” ");
INSERT INTO asj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bɛ se tuu li ki-i le ɛ Jiso wu Nasarɛ wu kɛti. ");
INSERT INTO asj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ki se bɛchi ki wɛndi le, “Jiso, ŋwanɛ kini ki mfɔŋ Daafi-i, kɔɔ nɛɛ nshiiŋ bɛ mi.” ");
INSERT INTO asj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bɛniiŋ bɛ tɛ̀ giiŋgi limfwe waŋ ki be tee le makɛ. Se nuuŋ le ki tɛ̀ tuu ki mɛɛshi ki waŋ lɛwe ŋge le, “Ŋwanɛ kini ki mfɔŋ Daafi-i, kɔɔ nɛɛ nshiiŋ bɛ mi.” ");
INSERT INTO asj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jiso woo leŋ, tee le bɛ yɛɛŋ bɛ ki. Be bɛ bɛ ki, Jiso bii li ki-i laa, ");
INSERT INTO asj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ɔ wɛki le mfɛ la li wɛ-ɛ?” Mwɛ tuu le, “Taa, fɛrɛ le ŋɛŋ biee.” ");
INSERT INTO asj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jiso se tee li ki-i le, “Ɔ ŋiŋgi biee lɛ. Shéŋ ya yɔɔ gɛɛ li mi-i fɛ yɛɛ lii ya gwiyɛ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mfwaa mumkpaŋ, nɛɛ lɛ mwɛ bɛchi ŋiŋgi biee. Dza biee Jiso guumɛ lɛki li Nyɔ-ɔ. Bɛniiŋ bɛchu bɛ tɛ̀ nuuŋ fe ŋɛŋ lɛ, be nyɛ kiyɔɔni li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jiso gɛɛŋ lɛ li kitoŋ ki Jɛriko-o kɛti. ");
INSERT INTO asj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wumu tɛ̀ nuuŋ fe bukooŋ le Sakiɔ, nuuŋ te kikoo wu bɛniiŋ bɛ tɛ̀ kundi kiŋwaati, nuuŋ tɛ wi wu biee. ");
INSERT INTO asj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tɛ̀ gii wɛki le ŋɛŋ Jiso si tɛ̀ kɛti. Se nuuŋ le, fi tɛ̀ yaa wu, kifɛ tɛ̀ kuuŋ, ɛ ki kintutu ki bɛniiŋ lɛ tɛ̀ baanyi wu. ");
INSERT INTO asj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Se letɛ gɛɛŋ limfwe, gɛɛŋ miri li kiti kimu-u, le ŋɛŋ Jiso si kɛti, kifɛ tɛ̀ nuuŋ le gii ka kimbɛ kilu. ");
INSERT INTO asj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Le Jiso gɛɛŋ bo fe, lɔŋ lii ŋɛŋ wu liwe, teeŋ le, “Sakiɔ, shee li kiti kɛɛ tsɛkɛ, kifɛ ŋkɛmɔɔ le ntsi li wɛ-ɛ yi bɛŋ.” ");
INSERT INTO asj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Biee shee li kiti kilu, fi Jiso bɛ kinɛɛtinɛ. ");
INSERT INTO asj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Le bɛniiŋ bɛchu tuu be ŋɛŋ si Jiso giiŋgi bee wu lɛ, be bɛchi be ŋuŋini be tiiti le, “Wi wuni giiŋgɔ le gɛɛŋ tsi bee wi wu bifi.” ");
INSERT INTO asj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Le be gɛɛŋ be ni be nuuŋ, Sakiɔ dza leŋ we tee li Jiso le, “Taa, bichɛ ɔ ŋɛŋ, ŋgii ŋgatɛ biee bieŋ kintikinti nyɛ li bɛniiŋ bɛ kifoo lɛ. Ɛ fi nuuŋ le ntɛ̀ mfi fiee fi wi-i lɛ kimfi-i, kɛ ŋgii ŋkaari ntuu kiŋga kinɛɛ li mwɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Le Jiso woo lɛ, tee li wuu le, “Bɛŋ yani kinsofu bɛ kɛɛ luuŋ yih, si te la wuni nuuŋ tɛ ŋwanɛ Abrahaŋ. ");
INSERT INTO asj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ŋwanɛwi tɛ̀ bɛ nuuŋ le gɔɔŋ, bɛ le soo bɛniiŋ bɛ tɛ̀ la.” ");
INSERT INTO asj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Si bɛniiŋ tɛ̀ yiki si Jiso tiiti biee bini, dza gɛɛŋ limfwe wa ŋgaŋgaa chimu li bee, ɛ tɛ tsɛkɛ nlɛ Jɛrosalɛŋ ɛ bɛniiŋ tɛ̀ beechi le semukɛ Nyɔ bɛɛchi yɛ le yi ni sɛki bumfɔŋ bwee. ");
INSERT INTO asj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tee le, “Tɛ̀ nuuŋ mfi wumu, ŋwanɛ mfɔŋ wumu tɛ̀ dza li kwɛɛŋ wee li giiŋgi li kwɛɛŋ wumu mfiiŋ, le bɛ gɛɛŋ bɛ kokɛ wu li mfɔŋ, se kaari bɛ ni sɛki bumfɔŋ bwee. ");
INSERT INTO asj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Si tɛ̀ dzɛti lɛ, teeŋ bɔɔŋ bee bɛ nimɛ-ɛ yoofi, gachɛ be kwa, mumkpaŋ mumkpaŋ bɛnchuki gwii, gwii, se tee li bee le, ‘Kɔ yɛɛŋ nɛ shɛ nɛ ni nɛ feti waŋ lu fɛ mbɛɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Se biee dza, bɛniiŋ bɛ kwɛɛŋ wee lɛ tɛ̀ baanini wu ŋge. Be se shɛ be toŋ bɛniiŋ lɛ wuu jiŋ le be gɛɛŋ be tee le, be wɛki yɛ le wi wulu nuuŋ mfɔŋ wu be kɛ. ");
INSERT INTO asj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bɛ, tɛ̀ gɛɛŋ bɛ biiŋgi wu, kaari to lijiŋ, teeŋ bɔɔŋ bee bɛ nimɛ-ɛ bɛ tɛ̀ gachɛ kwa li bee baa, le ŋɛŋ laa be ji baa mbeŋ kimɛ le. ");
INSERT INTO asj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ŋwaŋ wu nimɛ wu ŋkosi bɛ tee le, ‘Te Kikoo, bɛnchuki bo bɛ gwii bɛɛɔ tɛ̀ nyɛ mi baa, ntɛ̀ nshɛ nji mbeŋ le kiŋga yoofi.’ ");
INSERT INTO asj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Woo bujɔŋ, yɔŋgi wu tee le, ‘Ɛ wɛ ŋwaŋ wu nimɛ wu dzeeŋ. Siɔ tuu ɔ shɛ ɔ kɛɛ mbichɛ lɛ fiee fi niiŋ li bujɔŋ ni, ŋgii ŋgɛɛ wɛ ɔ ni ɔ sɛki bitoŋ yoofi.’ ");
INSERT INTO asj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wumu se bɛ tee le, ‘Te Kikoo, bɛnchuki bo bɛ gwii bɛɛɔ tɛ̀ nyɛ mi baa ntuu nshɛ mi nji mbeŋ le kiŋga kitiinɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tee li wuu le, ‘Ŋgii ŋgɛɛ wɛ ɔ ni ɔ sɛki bitoŋ bitiinu.’ ");
INSERT INTO asj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ŋwaŋ wu nimɛ wumu bɛ tee fiee le, ‘Te Kikoo, baaŋ bɛnchuki bo bɛ gwii baa fɛni, ntɛ̀ shɛ mi ŋkochɛ fɛ nshɛŋgɛ yi ndu mi ŋkiri. ");
INSERT INTO asj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ntɛ̀ ŋkiri kifɛ nti ŋkii le ɔ ti tɛɛmi lɛ dzaa, nse nchɛndi wɛ. Ɔ ti fii biee bi ɔ mɛɛŋ ki kiri kɛ, ɔ ti wechi biee bi ɔ mɛɛŋ ki tɔyɛ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Se te kikoo we tee li wuu le, ‘Ɔ wɛ ŋwaŋ wu nimɛ wu bifi. Ŋgii ndzɔɔ tefɛ chi bo lɛ wɛɛ wa, nse nsaa wɛ lu. Ɔ ti kii le nti ntɛɛmi lɛ dzaa, le nti mfi-i biee bi mɛɛŋ ŋkiri kɛ, ntuu ŋ'wechi biee bi mɛɛŋ ki ntɔyɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ɔ tɛ̀ kii lɛ, ɛ la fi tɛ̀ ge lɔɔ kiri kwa wɛŋ li yih yi kwa-a, le ke mfi wu mi ŋkaari mfi bɛ mbeŋ?’ ");
INSERT INTO asj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Se biee tee li bɛniiŋ bɛ tɛ̀ lemi li wuu lichiŋ baa le, ‘Fi yɛɛŋ kwa wulu li wuu, nɛ nyɛ li wi wu bee kɛmɛ mbeŋ kiŋga yoofi wɛɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Be faaŋ be tee li wuu le, ‘Te Kikoo, kɛmɔɔ bɛbabi bɛ kwa-a yoofi kituŋ.’ ");
INSERT INTO asj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Se tuu le, ‘Ntee beŋ le, wi wu kɛmi biee ŋge, bɛ gii bɛ tondɛ wu bimu. Se nuuŋ le wi wu kɛmi yɛ fiee kɛ, mɔɔ nuuŋ fi niiŋ fi kɛmi, bɛ gii bɛ fi fi li wuu. ");
INSERT INTO asj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dɛɛni, li bɛniiŋ bɛ tɛ̀ baanini mi, be fɛŋgi le kiiŋ ni nuuŋ mfɔŋ wu be kɛ, gɛnɛ yɛɛŋ nɛ bɛ bɛ be nɛ woyɛ be li mi-i lii.’” ");
INSERT INTO asj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lɛjiŋ lɛlu si Jiso tɛ̀ tee biee bini ni, tuu dza too mbaaŋ yɛki giiŋgi Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Le ni fɛɛshi li kitoŋ ki Bɛtfaj bɛ ki Bɛtani-i bi nuuŋ li ŋkumɛ wu Biti bi Oli-if lichiŋ, tuu tsaa bɔɔŋ bee bɛ kintutu bamu bɛfɛ toŋ be, ");
INSERT INTO asj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tee le, “Gɛnɛ yɛɛŋ li kitoŋ ki nuuŋ limfwe kɛɛ. Mfi wu nɛ fɛsi fe, nɛ gii nɛ ŋɛŋ ŋwanɛ sɔmbwaa ɛ bɛ kaŋ wu, wi ti mɛɛŋɔ saa kɛ le beeŋ le lɛwe kɛ, nɛ fanchɛ wu nɛ bɛ bɛ wu fɛni. ");
INSERT INTO asj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɛ nɛ gɛɛŋ, nɛ fanchi, wumu bii laa nɛ fanchi kii la le? Nɛ tuu li wuu le, te kikoo wɛkɔɔ wu.” ");
INSERT INTO asj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bɔɔŋ bɛ kintutu baa tɛ̀ gɛɛŋ be ŋɛŋ fiee fichu nɛɛ si Jiso tɛ tee li bee. ");
INSERT INTO asj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Si be tɛ̀ fanchi ŋwanɛ Sɔmbwaa wulu lɛ, bɛniiŋ bɛ tɛ̀ kɛmi sɔmbwaa wulu bii li bee laa, “Nɛ fanchi ŋwanɛ sɔmbwaa wɛɛ kii la?” ");
INSERT INTO asj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Be tuu le, “Te Kikoo wɛkɔɔ wu.” ");
INSERT INTO asj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Be se dzɔ wu be bɛ bɛ wu fɛ Jiso, be dɛŋ ndú yibe li sɔmbwaa wulu, be biee be miiki Jiso le lɛwe. ");
INSERT INTO asj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Le ni giiŋgi, bɛniiŋ tɛ gikisi ndú yibe lɛ dze, se deŋgi li yi-i liwe. ");
INSERT INTO asj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Le gɛɛŋ ni fɛɛshi li dze yi beki li ŋkumɛ wu Biti bi Oli-if lichiŋ, kimbanchɛ ki bɔɔŋ bee bɛ kintutu kichu bɛchi ki wuuyi, ki piɛti Nyɔ lɛwe ŋge kii bintɛwa bi biee lɛ bichu bi be tɛ̀ ŋɛŋ. ");
INSERT INTO asj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Be tɛ̀ wuuyi be tiiti le, “Nyɔ lɔŋ yɛ kimbɔnɛ li Mfɔŋ wu bɛɛ li bukooŋ bu Taa lɛ. Mbɛɛŋgii nuuŋ liboo, bunɔŋa se nuuŋ bu Nyɔ yi nuuŋ liboo li.” ");
INSERT INTO asj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bɛfarasii bamu bɛ tɛ̀ nuuŋ li kintutu kilu-u linti be dza be tee li Jiso le, “Wi wu ntiifɛ, tee li bɛniiŋ bo bɛ kintutu bani le be chikɛ nshiiŋ.” ");
INSERT INTO asj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jiso tuu li bee le, “Ntee beŋ le, ɛ be chikɛ nshiiŋ, kɛ ta yini kibɛɛ gii yi ni yi wuuyi.” ");
INSERT INTO asj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jiso bɛ le ni fɛɛshi Jɛrosalɛŋ le bichɛ ni, waŋ kwe, ");
INSERT INTO asj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","fayi le, “Hebee Jɛrosalɛŋ bee nuuŋ le nɛ kɛɛ fiee fi bɛɛ bɛ mbɛɛŋgii li jobɛ chi bɛŋ chini-i! Se nuuŋ le nɛ mɛɛŋ baa ki kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Fi fiɛɛ le, nɛ kɛɛ le mfi bɛɛɔ wu bɛniiŋ bɛnɛ bɛ mbani gii be toŋ mbaŋ be kɛnɛ beŋ, be baaŋ beŋ bimbɛ bichu. ");
INSERT INTO asj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Be gii be lɛ be mɛɛshi bɛ beŋ mɔɔ bɔɔŋ bɛnɛ dududu, be kɛsi yíh yinɛ, tɛtɛ tɛ shɛ li chimu-u liwe kɛ. Fi gii fi ka lɛ, kifɛ nɛ ti mɛɛŋ ki kɛɛ kɛ mfi wu Nyɔ tɛ̀ bɛɛ lɛ be-eŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jiso dza gɛɛŋ fɛ yih yi muntofi-i, bɛchi kuŋgi bɛniiŋ bɛ tɛ̀ kabini biee fe, ");
INSERT INTO asj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","tiiti li bee le, “Fi fiɛɛ ɛ bɛ tsɛɛ le, Nyɔ tee yɛ le, ‘Yih yɛŋ gii yi ni yi nuuŋ yih yi nlɛkɛ li Nyɔ-ɔ.’ Se nuuŋ le nɛ fiiki baa yi to ‘Ntuuŋ wu bɛyi.’” ");
INSERT INTO asj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jiso tɛ̀ shiiŋ tiifi bɛniiŋ li yih yi muntofi-i jo chichi. Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ mɔɔ bɛniiŋ bɛ nɔŋa bɛ nɔŋa bɛ fe be se tuu be gwenini le be wo wu. ");
INSERT INTO asj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Se nuuŋ le be ti mɛɛŋ ki kɛmɛ kɛ dze kɛ, kifɛ bɛniiŋ bɛchu tɛ̀ shiiŋ li Jiso-o lichiŋ be wɛki yɛ le be lɛɛ fiee fi mumkpaŋ li biee bi tɛ̀ tiifi kɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jobɛ chimu le Jiso ni tiifi bɛniiŋ fenjisi ntoŋ wu dzeeŋ wu Nyɔ li yih yi muntofi. Bɛte muntofi-i bɛ nɔŋa bɛ nɔŋa, bɛ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ mɔɔ bɛkaaŋ bɛ kwɛɛŋ lɛ, ");
INSERT INTO asj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","se bii li wuu laa, “Tee nɛɛ bee wi wu nyɛɔ buŋga le ɔ ni ɔ feti biee bini. Ɛ noo wu nyɛɔ buŋga bulu?” ");
INSERT INTO asj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jiso tuu li bee le, “Ŋgii mbii tɛ fiee li be-eŋ. Nɛ tee mi dɛɛni. ");
INSERT INTO asj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Buŋga bu Jɔɔŋ tɛ̀ lisi bɛniiŋ lu lidzɔɔ, ɛ Nyɔ yi liboo yi tɛ̀ nyɛ wu mɔɔ wiwoŋ le?” ");
INSERT INTO asj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Be se biee be kɔɔ ntsooŋ bebe le, “Ɛ tɛ tuu le ɛ Nyɔ yi liboo yi tɛ̀ nyɛ, gii bii li bee li laa ɛ la fi tɛ̀ fɛ le tɛ beŋ kɛ li Jɔɔŋ li kɛ le? ");
INSERT INTO asj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Se nuuŋ le ɛ tɛ tuu le ɛ wiwoŋ wu tɛ̀ nyɛ, kɛ bɛniiŋ gii be tomɛ bee bɛ ta, kifɛ be beenchi chɛɛŋ chɛɛŋ le Jɔɔŋ tɛ̀ nuuŋ ntomfɔŋ wu Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bɛdɛɛni be se tuu le, “Tɛ kii yɛ wi wu tɛ̀ nyɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jiso se tuu tee li bee le, “Kɛ nuuŋ ntɛ ntee tɛ beŋ wi wu nyɛ mi buŋga le ni mfeti biee bini kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jiso se dza wa ŋgaŋgaa chimu li bɛniiŋ li le, “Wi wumu tɛ̀ niŋ wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu. Tɛ̀ gɛɛ wɛ wulu li bɛniiŋ li, tuu dza gɛɛŋ li kitoŋ kimu-u, gɛɛŋ tsi le ŋge. ");
INSERT INTO asj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Le mfi wu bɛ ti kee bɛ kɔchɛ, toŋ ŋwani wu nimɛ wumu le gɛɛŋ li wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu wɛɛ, fi mwee muntaaŋ. Le ŋwaŋ wulu gɛɛŋ, bɛniiŋ bɛ tɛ̀ gɛɛ wɛ li bee baa, tuu be too wu, be kooŋ bɛ wu kaari bɔ kilɛrɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wi wulu tuu toŋ ŋwani wu nimɛ wumu, be ka be too wu, be nyɛ wu buya, be kooŋ bɛ wu to lijiŋ bɔ kilɛrɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mwɛ tuu toŋ wumu bo bɛtɛɛtu, be too wu, be nyɛ wu bibaa, be lɔŋ wu lɛkuuŋ. ");
INSERT INTO asj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wi wu wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu wulu se beechɛ laa, ‘Ŋgii ŋge la le? Dɛɛni ŋgii ntoŋ nuuŋ ŋwanɛŋ wu nuuŋ shéŋ yɛŋ. Semukɛ be gii be guuŋ wu.’ ");
INSERT INTO asj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Le ŋwaŋ wɛ dza gɛɛŋ lɛ liwɛ, bɛniiŋ bɛ tɛ̀ gɛɛ wɛ li bee baa ŋɛŋ wu, be bɛchi be tsuundi li yi yi bee le, ‘Kini nuuŋ kinjila ki wi wu wɛ wuni. Tɛ wo ki, wɛ wuni se to wusɛŋ.’ ");
INSERT INTO asj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Se be biee be kɔɔ wu, be bo bɛ wu li wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu-u, be wo wu.” Le Jiso tee lɛ, se bii laa, “Nɛ beechi le wi wu wɛ wulu gii bɛ ge la bɛ bɛniiŋ baa le? ");
INSERT INTO asj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ntee beŋ le, gii bɛ woyɛ bɛniiŋ bɛlu, gɛɛ wɛ wu muntaaŋ mu bɛ feti mbiiŋ lu wulu li bɛniiŋ bamu-u.” Le bɛniiŋ bɛlu woo lɛ, be kasi yi le, “Nyɔ nuuŋ tɛ beŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jiso bichɛ be, bii laa, “Fiee fi bɛ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ kini tiiti le la, fi nuuŋ le, ‘Tɛtɛ chi bɛniiŋ bɛ ŋgwanu tɛ̀ faaŋ chɛɛ, chi tɛ̀ kaari nɛɛ chi to tɛtɛ chi fɛ boo chi yi-i ni?’ ");
INSERT INTO asj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tɛtɛ chilu chini chɛɛ, ɛ wi we lu chi-i, kɛ mwɛ gii kpɔɔshɛ, ɛ chi we li wi-i, kɛ chi gii chi gɔɔri mwɛ li biŋkɛ-ɛ”. ");
INSERT INTO asj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Si Jiso tɛ̀ wa ŋgaŋgaa chilu lɛ, bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ, bɛ bɛ te muntofi bɛ nɔŋa bɛ nɔŋa bɛchi be wɛki le be kɔɔ wu nɛɛ fe. Be tɛ̀ wɛki le be kɔɔ wu kifɛ be tɛ̀ kɛɛ le tɛ̀ wa ŋgaŋgaa chilu nuuŋ li bee, se nuuŋ le be tɛ̀ chɛndi bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Be se bɛchi be biki bikaa biee lɛjiŋ lɛjiŋ, be waaŋ bɛtoŋkii, be toŋ le be gɛɛŋ be toŋ ŋkii be ni be feti si bɛniiŋ bɛ nuuŋ tsaaŋ. Be tɛ̀ feti lɛ le be se woo fiee lɛ wuu wa, be se kɔɔ wu be nyɛ li tsaŋ yi ŋgɔmina wu Lom wu tɛ̀ sɛki kimbɛ kɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bɛntoŋkii bɛlu dza be bii li wuu laa, “Wi wu ntiifɛ, tɛ kii le biee bi ɔ tiiti mɔɔ bi ɔ tiifi nuuŋ bi tsaaŋ, ɔ ti bichi yɛ bɛniiŋ li lii kɛ. Ɔ ti tiifi chɛɛŋ nuuŋ fiee fi Nyɔ wɛki le bɛniiŋ ni be feti. ");
INSERT INTO asj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tɛ se biiti baa laa nchi beenchi le tɛ ni tɛ suuti kiŋwaati li Kaisa Mfɔŋ wu Lo-om le?” ");
INSERT INTO asj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jiso se kɛɛ fiee fi be gwenini bɛ fi, tee le, ");
INSERT INTO asj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bɛ yɛɛŋ bɛ danali mumkpaŋ ŋɛŋ.” Be bɛ bɛ wu se bii li bee laa, “Kikoo kini nuuŋ ki noo lɛ, bukooŋ buni se nuuŋ bu noo lɛ?” Be tuu le, “Ɛ ki Kaisa.” ");
INSERT INTO asj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jiso se tee le, “Nɛ nyɛɛ yɛɛŋ li Kaisa fiee fi nuuŋ fi Kaisa, nɛɛ nyɛɛ li Nyɔ-ɔ fi nuuŋ fi Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Le bɛniiŋ baa woo fi yaa be, be baa nshiiŋ be mɛɛŋ ki kɛmɛ kɛ fiee fi be nuuŋ be kɔɔ wu lu kɛ wa tɛ be bɛ ntusu wulu be ba nshiiŋ. ");
INSERT INTO asj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bɛniiŋ bamu li kintutu ki Bɛsadusii tɛ̀ dza be bɛ le be bii fiee li Jiso. Bɛsadusii bani tɛ̀ nuuŋ bɛniiŋ bɛ tɛ̀ tiiti le bɛniiŋ nuuŋ tɛ̀ kaari le be bo li kwe-e kɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Be se bɛ be bii li wuu laa, “Wi wu ntiifɛ, Mɔɔsɛ tɛ̀ tsɛɛ lɛ nchi wusɛŋ le, ‘Ɛ wi kɛmi kwɛɛŋ, mwɛ kwi bee wu mbiɛ ŋwaŋ nsiŋ, kɛ ŋwaani kɛmi le dzɔɔ kwɛɛŋ wulu bee wu biɛ bɔɔŋ li bukooŋ bu ŋku ŋwaani.’ ");
INSERT INTO asj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dɛɛni, bɔɔŋ bɛ wi wumu tɛ̀ nuuŋ mfomɛnyaaŋ, le wu kaaŋ wɛ kɛmɛ kwɛɛŋ kwi, bee wu kɛmi yɛ ŋwaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wu biki wɛ tuu dzɔ kwɛɛŋ wulu, kwi tɛ ŋwaŋ siŋ. ");
INSERT INTO asj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wu biki wumu tuu dzɔ kwɛɛŋ wulu, kwi tɛ ŋwaŋ siŋ. Fi tɛ̀ ka nɛɛ lɛ bɛ bɔɔŋ bɛ mfomɛnyaaŋ baa bɛchu, wu be wumu ti mɛɛŋ ki biɛ kɛ ŋwaŋ bɛ kwɛɛŋ wulu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Li mɛrisɛ kwɛɛŋ wulu kwi tɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Si bɛniiŋ bɛ mfomɛnyaaŋ bani tɛ̀ dzɔ kwɛɛŋ wulu bɛchu lɛ, mfi wu bɛniiŋ gii be bo li kwe-e, kwɛɛŋ wulu gii ni nuuŋ kwɛɛ noo?” ");
INSERT INTO asj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jiso tuu li bee le, “Li mfi wu dɛɛni wuni, buniŋ bee bukɛɛŋ feti baa bugoo, bɛniiŋ nyɛɛ bɔɔŋ li ba-a. ");
INSERT INTO asj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Se nuuŋ le, bɛniiŋ bɛ kɔchɛ le ke be kɛmɛ kintsii li mfi wu bɛɛ li, mfi wu be kaari be bo li kwe-e, be nuuŋ tɛ tuu le be fɛ bugoo kɛ, bɛniiŋ mɛɛŋ yɛ le be nyɛ bɔɔŋ li ba-a kɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Be mɛɛŋ yɛ be kwi kɛ, kifɛ be gii be ni be nuuŋ si bɛnchindaa bɛ Nyɔ-ɔ kituŋ. Be gii be nuuŋ bɔɔŋ bɛ Nyɔ-ɔ, kifɛ be kaari baa be bo li kwe-e kituŋ. ");
INSERT INTO asj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Chɛɛŋ wulu nuuŋ le Mɔɔsɛ kibɛɛ tɛ̀ naanyɛ le bɛniiŋ gii be kaari be bo li kwe-e si tɛ̀ tsɛɛ kii kiti ki tɛ̀ ŋɛŋ ki duti. Tɛ̀ teeŋ Taa lɛ kintsii ki kiŋwaati kilu le Nyɔ yi Abrahaŋ, Nyɔ yi Adzi mɔɔ Nyɔ yi Yakɔ. ");
INSERT INTO asj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɛ tɛ̀ teenyi lɛ, kɛ tiitɔɔ le biŋkwi bini mɛɛŋ biɛɛ we, Nyɔ ti nuuŋ yɛ Nyɔ yi biŋkwi kɛ, Nyɔ ti nuuŋ nuuŋ Nyɔ yi bɛniiŋ bɛ nuuŋ lu, kifɛ li Nyɔ-ɔ, bɛniiŋ bɛchu mɛɛŋ bɛyoŋ.” ");
INSERT INTO asj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Si Jiso tɛ̀ yɔ lɛ, bɛniiŋ bɛ tɛ̀ doonchi bɛnchi bɛ Nyɔ-ɔ baa tee le, “Wi wu ntiifɛ, ɔ bɔsɔɔ yi ɔ tuu bujɔŋ.” ");
INSERT INTO asj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nɛɛ lɛ, wi ti mɛɛŋ ki tuu kɛ le bii fiee li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jiso se dza bii fiee li bee laa, “Bɛniiŋ geeŋ bɛ tiiti le Kinsofu ki Nyɔ tɛ̀ kaachɛ nuuŋ ŋwanɛ Mfɔŋ Daafi? ");
INSERT INTO asj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nɛ kii yɛ le Daafi kibɛɛ tɛ̀ tsɛɛ lɛ kiŋwaati kin'yɔɔnchɛ le, ‘Taa Nyɔ tɛ̀ tee li Taa li le Shee lɛ kibɛnɛ keŋ ki kigɔŋɛ-ɛ, ");
INSERT INTO asj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gɛɛŋ bo mfi wu ŋgii ŋgiiki bɛniiŋ bo bɛ mbani-i le ɔ tɔmi bikaa bio li bee si kiga ko.’ ");
INSERT INTO asj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɛ Daafi teenyi wu le Taa, fi geeŋ se tuu ni nuuŋ ŋwani?” ");
INSERT INTO asj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jiso tuu dza yeti li bɔɔŋ bee bɛ kintutu-u, bɛniiŋ bɛchu wuki. Tiiti li bee le, ");
INSERT INTO asj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Dzɔɔ yɛɛŋ mfi, bɛ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ. Be ti kɔŋgisi nchuminɛ ndú yi nyɔŋa yi nyɔŋa be deŋgi li bintsii bi bɛ kabini biee li, be kɔŋgisi bintindu bi shaaŋ li yíh yi lɛkɛ li Nyɔ-ɔ bɛ bintsii bi bi kin'yokisɛ-ɛ fɛ tsɔnɔ-ɔ. Fɛ be gɛɛŋ li yíh yi nlɛkɛ li Nyɔ-ɔ, kɛ fɛ tsɔnɔ-ɔ, be tsaa nɛɛ nuuŋ bintindu bi nɔŋa bi nɔŋa, be se shee li bi-i liwe. ");
INSERT INTO asj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɛ nɛɛ be bɛ tusi bukɛɛŋ bɛɛŋku-u lijiŋ, be yɛŋgi be fii biee bi bee, be tuu be feti nlɛkɛ li Nyɔ-ɔ wu deendi le be ni be doonchi yi. Ŋwaani bani bɛniiŋ, wu be wu ŋgɛ gii naa bee ŋge.” ");
INSERT INTO asj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jiso dza lɔŋ lii, ŋɛŋ si bɛniiŋ bɛ biee be giki nya yibe lɛ fiŋkaa fi nya-a, li yih yi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ŋɛŋ tɛ̀ kwɛɛ ŋku wumu wu tɛ̀ nuuŋ wi wu kifoo, ɛ wu bɛ wu gɛɛ munini mumfɛɛŋ lɛ fiŋkaa filu-u. ");
INSERT INTO asj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jiso se tee le, “Ntee beŋ chɛɛŋ le, kwɛɛ ŋku wuni wu nuuŋ fiee bɛ kifoo, nyɛɔ wu yaa bɛniiŋ bani bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bɛniiŋ bɛchu bɛ nyɛ, nyɛ baa nuuŋ tsuu yi biee bi bee bi yisɛ nsiŋ bi shooshi likwiiŋ. Se nuuŋ le kwɛɛŋ wu nuuŋ bɛ kifoo wuni nyɛɔ fiee fichu fi yemi li fi-i.” ");
INSERT INTO asj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bɔɔŋ bɛ Jiso bɛ kintutu bamu tɛ dza be wuuyi kii yih yi muntofi, be piɛti ta yi dzeeŋ yi bɛ tɛ̀ gwaŋ lu bɛ biee bi bɛniiŋ tɛ̀ nyɛɛ le bɛ nachɛ yi lu. Jiso se tee li bee le, ");
INSERT INTO asj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nɛ ŋiŋgi baa biee bini ni? Jobɛ bɛɛ chɛɛ chi tɛtɛ chimumkpaŋ nuuŋ tɛ leŋ li chimu-u liwe bɛ mɛɛŋ ki bachɛ kɛ chi fɛkwiiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Be bii laa, “Wi wu ntiifɛ, fini gii fi ka buŋ? Ɛ la fi gii fi doonchɛ le mfi kɔchɔɔ wu fi gii fi dzɔɔ kintsii?” ");
INSERT INTO asj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jiso tuu le, “Dzɔɔ yɛɛŋ mfi le kiiŋ wi ni yɛɛŋ bɛ beŋ le nɛ taŋ dze kɛ. Bɛniiŋ gii be bɛ ŋge, be dzɔɔ bukooŋ bweŋ be tɛɛki fɛ lii, be ni be kweŋgi le, ‘Ɛ mi Kinsofu!’ Mfi wulu bɛɛɔ tsɛkɛtsɛkɛ. Ɛ be kweŋgi lɛ, kiiŋ nɛ ni yikɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mfi wu nɛ woo le, bɛ tundi baa dziŋ li bintsii li, li bintsii li, ŋgɛ nuuŋ li nshɛ-ɛ, nɛ chɛŋ kɛ yɛɛŋ kɛ. Biee bini kɛmi biɛɛ nɛɛ le bi saa bi ka. Se nuuŋ le, bi doonchi yɛ le nshɛ ma yɛ li mfi wulu-u kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jiso se tee li bee le, “Tɛɛŋ gii yi ni yi tundi dziŋ bɛ yimi, bumfɔŋ bumu gii bu ni bu tundi dziŋ bɛ bumu. ");
INSERT INTO asj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Biee bi koofi yi gii bi ni bi doonchi li bintsii li li bintsii li. Nshɛ gii yi ni yi sɛɛsi bɛ buŋga. Dzeeŋ gii yi kɔɔ, chigɔŋ gii chi nuuŋ li bintsii bichu-u. Bɛŋkiki bɛ biee bi koofi yi gii be nuuŋ liboo, be nyɛ chɛnɛ li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nɛ kɛɛ le fɛ biee bini gii bi ni bi kɛti, gii ni nuuŋ ɛ bɛ kɔɔ beŋ, bɛ ŋwɛki bɛ beŋ. Bɛ gii bɛ gɛɛŋ bɛ beŋ, bɛ saa beŋ li yíh yi kintaashɛ, bɛ toŋ beŋ li ncha-a. Bɛ tuu bɛ dzɔɔ beŋ kii bukooŋ bweŋ bɛ gɛɛŋ bɛ beŋ li bɛmfɔŋ bɛ bɛniiŋ bɛ sɛki kwɛɛŋ li limfwe, ");
INSERT INTO asj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","wɛɛ mfi wunɛ wu nɛ gii nɛ kɛmɛ dze le nɛ tee li bee kii mi. ");
INSERT INTO asj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mfi wu bɛ dzɔ beŋ lɛ, nɛ boo kɛ yi yinɛ laa, nɛ gii nɛ yɔ le la le kɛ, ");
INSERT INTO asj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kifɛ ŋgii nnyɛ n'yɔru li bimfimu binɛ-ɛ, mɔɔ bufii li be-eŋ, bu bɛniiŋ bɛnɛ bɛ mbani-i nuuŋ tɛ leŋ le be tɛchɛ bɛ beŋ kɛ dududu. ");
INSERT INTO asj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bɛniiŋ bɛ gii be kabɛ beŋ, gii ni nuuŋ nɛɛ bɛchaa bɛnɛ, bee bɛ na bɛnɛ, mɔɔ bɛ ŋwaana bɛnɛ, mɔɔ kini kinɛ, bɛ nsáŋ yinɛ. Ɛ nɛɛ be bɛ gii be nyɛ beŋ bɛ se woyɛ beŋ bamu. ");
INSERT INTO asj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bɛniiŋ bɛchu gii be ni be baanini beŋ, kii bukooŋ bweŋ. ");
INSERT INTO asj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Se nuuŋ le, mɔɔ nuuŋ yi mumkpaŋ nuuŋ tɛ la beŋ li fa kɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kanɛ yɛɛŋ shéŋ yinɛ, nɛ se kɛmɛ ntsɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mfi wu nɛ ŋɛŋ bɛniiŋ bɛ dzi-iŋ kɛnɛ kitoŋ ki Jɛrosalɛŋ lɛnti, nɛ kɛɛ le mfi kɔchinɔɔ wu bɛ gii bɛ siisɛ ki. ");
INSERT INTO asj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ɛ fi kɛti lɛ, bɛniiŋ bɛ nuuŋ Judiya biee be kifi be miri li bɛŋkumɛ, bɛniiŋ bɛ nuuŋ fɛ kitoŋ kilu-u bochɛ. Kiiŋ wi wu nuuŋ li buka tuu ni bɛɛ le lɛ fe kɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jo yi yɛɛ nuuŋ yi Nyɔ gii yi lɔŋ ŋgɛ li Jɛrosalɛŋ kii kiŋge kee, le fɛ fiee fichu bɛ fi kɔchɛ si bɛ tsɛɛ lɛ kiŋwaati kee li. ");
INSERT INTO asj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋgɛ wu nyɔŋa gii nuuŋ li jo yɛɛ li bukɛɛŋ bɛ fe-e, mɔɔ bɛ kisi bɔɔŋ. Shéŋ gii yi bee Nyɔ bɛ bɛniiŋ bani, yi lɔŋ ŋgɛ wu nyɔŋa li kwɛɛŋ wuni. ");
INSERT INTO asj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɛ gii bɛ wachɛ bɛniiŋ bamu bɛ nyɔ́, bɛ kɔɔyɛ bamu bɛ gɛɛŋ bɛ be li tɛɛŋ yimi-i chi be ni be nuuŋ bɛmfa. Bɛniiŋ bɛ ti kii yɛ Nyɔ kɛ gii be beeŋ lɛ Jɛrosalɛŋ lɛwe, nsiiŋ gɛɛŋ bo fɛ mfi wu be kɔchɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Bɛŋkiki bɛ koofi yi gii be yenɛ li jobɛ-ɛ, bɛ li kwii li mɔɔ li muntsɔŋ. Li nshɛ-ɛ, tɛɛŋ gii yi nuuŋ li ntɔnyɛ, bɛ ŋgɛ mɔɔ dzɔ́ɔ yi nyɔŋa gii yi ni nduŋgi yi yeti. ");
INSERT INTO asj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chɛnɛ gii chi fɛ le bɛniiŋ ni be kɛɛti ni kikikiki, be gii be ni beechi kii biee bi koofiyi bi gii bi ka li nshɛ-ɛ kifɛ biee bi liwe bichu bi kɛmi buŋga gii bi sɛɛsɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bɛdɛɛni bɛniiŋ gii be ŋɛŋ si Ŋwanɛwi shiiti bɛɛ li kiku-uŋ linti bɛ buŋga mɔɔ bunɔŋa bu ŋge. ");
INSERT INTO asj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ke mfi wu biee bini bɛchi bi kɛti ni, nɛ leŋ we, nɛ tsaaki bikoo liwe, kifɛ mfi wu Nyɔ gii yi soo beŋ wɛ tsɛkɛtsɛkɛ.” ");
INSERT INTO asj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Si Jiso tɛ̀ yɔ lɛ, tuu maa le, “Laanchɛ yɛŋ fiee li kigumɛ bɛ biti bimu bichu. ");
INSERT INTO asj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bi ti bɛɛchi mbɔchɛ, nɛ biee nɛ kɛɛ le ndzɛɛŋ yɛ kituŋ tsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nɛɛ lɛ, ɛ nɛ ŋɛŋ biee bini kɛti, nɛ kɛɛ le bumfɔŋ bu Nyɔ-ɔ bwɛɛ tsɛkɛtsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ntee beŋ chɛɛŋ le kiŋgɔkɛ ki dɛɛni kini nuuŋ tɛ naa ma fuki fɛ biee bini bichu ka nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kiboo bee nshɛ gii bi ka, se nuuŋ le jɛ yɛŋ nuuŋ tɛ naa ka kɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Dzɔɔ yɛɛŋ mfi fɛ nɛ deŋgi nɛ jii kikuuŋ, nɛ wundi biee nɛ jeti, nɛ giki bufii nuuŋ li ntsɛ wu laaŋkwiiŋ li, jobɛ chilu gii chi taa chi kɔɔ beŋ si kintasi. ");
INSERT INTO asj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Fiee fi li jobɛ chilu chini gii fi bɛ li bɛniiŋ bɛchu bɛ nuuŋ li kikoo ki nshɛ. ");
INSERT INTO asj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Se nuuŋ le nɛ lemi yɛɛŋ nɛ tɛɛmi, nɛ lɛki li Nyɔ-ɔ mfi kwi, le ɛ bini biee kɛtɔɔ, yi nyɛ beŋ dze le nɛ wɛɛŋ nɛ ka le nɛ se leŋ limfwe li Ŋwanɛwi-i.” ");
INSERT INTO asj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jiso tuu shiiŋ tiifi bɛniiŋ li yih yi muntofi jo yɛɛ chichi. Ɛ bo lɛ fɛ mfoo, yɛɛ gɛɛŋ tsi li ŋkumɛ wu biti bi Oli-if. ");
INSERT INTO asj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bɛniiŋ bɛchu se bɛɛ fɛŋwɛɛŋ fɛchu li yih yi muntofi le be ni be yiki ntiifɛ we. ");
INSERT INTO asj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mfi tɛ̀ bɛɛ tsɛkɛtsɛkɛ li tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ kishee le kɛ, chi bɛ teenyi le tsɔnɔ chi N'yafuwee. ");
INSERT INTO asj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bɛte muntofi bɛ nɔŋa bɛ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ, tɛ̀ wɛki dzé yibe gii be wo Jiso le lɛ munyiikɔɔ li, kifɛ be tɛ̀ chɛndi bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sataŋ se lɛ li shéŋ yi Judas, wu bɛ tɛ̀ teenyi le Iskaliyɔ, wu tɛ̀ nuuŋ wi wu li kintutu ki bɔɔŋ bɛ Jiso bɛ yoofi ntsɔ bɛfɛ baa. ");
INSERT INTO asj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Se dza gɛɛŋ fɛ bɛte muntofi bɛnɔŋa mɔɔ bɛte bikoo bi nchi bi tɛ̀ kiichi yih yi muntofi. Bee be se tuu be nachɛ si gii kabɛ Jiso li bee. ");
INSERT INTO asj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Be tɛ̀ woo bujɔŋ bɛ wu, be se nachɛ le be gii be sooŋ wu kwa. ");
INSERT INTO asj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tɛ̀ beŋ, se gɛɛŋ bɛchi wɛki dzé yi gii nyɛ Jiso li tsaŋ yi bee mfi wu kintutu ki bɛniiŋ lɛ nuuŋ yɛ fe kɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jobɛ chi tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ kishee le kɛ, chi bɛ ti sɛɛti ŋwaanɛ kiŋkɔ li tsɔnɔ chi N'yafuwee chini tɛ̀ bɛ chi kɔchɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jiso se biee toŋ Pita bee Jɔɔŋ tee le, “Gɛnɛ yɛɛŋ nɛ nachɛ biee bi tɛ gii tɛ ji tsɔnɔ chini lu.” ");
INSERT INTO asj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Be bii li wu laa, “Ɔ wɛki le tɛ gɛɛŋ tɛ nachɛ nuuŋ fɛŋ?” ");
INSERT INTO asj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tuu le, “Woo yɛɛŋ, mfi wu nɛ giiŋgi nɛ lii li kito-oŋ, nɛ gii nɛ ŋɛŋ wumu ɛ wu too dzɔɔ lɛ tɛnɛ-ɛ, nɛ biee wu li yih yi gii gɛɛŋ lɛ lu-u. ");
INSERT INTO asj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nɛ biee nɛ tee li te yih wulu le, Wi wu ntiifɛ biitɔɔ laa lo-oŋ wu bɛniiŋ bɛ ndɛndɛ wu bee bɔɔŋ bee bɛ kintutu gii be ji Tsɔnɔ chi N'yafuwee lu nuuŋ fɛŋ le? ");
INSERT INTO asj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Gii doonchɛ beŋ loŋ wu nyɔŋa lɛ yih yi lɛwe-e ɛ bɛ bɔsɛyi bɛ nachɛ, nɛ se nachɛ biee bijɛ bilu lu.” ");
INSERT INTO asj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Be tɛ̀ gɛɛŋ be ŋɛŋ biee nɛɛ yɛɛŋ si Jiso tɛ̀ tee be. Be se biee be nachɛ biee bijɛ bi Tsɔnɔ chi N'yafuwee lu. ");
INSERT INTO asj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Le mfi bɛ kɔchɛ, Jiso bee bɔɔŋ bee bɛ ntoŋ bɛ be shee be jii biee. ");
INSERT INTO asj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dza tee li bee le, “Ntuu ŋkɔŋgisi ŋge le nji Tsɔnɔ chi N'yafuwee chini bɛ beŋ nse ŋɛŋ ŋgɛ wu bɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɛ kɛɛ le, mɛɛŋ yɛ nji Tsɔnɔ chini kɛ nsiiŋ fi bɛ fi kɔchɛ mfi wu Nyɔ gii yi ni yi sɛki bumfɔŋ bwee.” ");
INSERT INTO asj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dzɔ fika, nyɛ kiyɔɔni li Nyɔ-ɔ tee le, “Kɔ yɛɛŋ nɛ woŋ beŋ bɛchu nɛ tasɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ntee beŋ le, mbɛɛchɛ li dɛɛni ŋgɛnu limfwe, mɛɛŋ yɛ ntuu ŋ'woŋ mbiiŋ mɛ gwɛɛŋ wu kiti ki lɛɛndi-i mani kɛ, nsiiŋ gɛɛŋ bo mfi wu bumfɔŋ bu Nyɔ-ɔ naa bu bɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dzɔ kibele, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ nyɛ li bee tee le, “Yiiŋ yi yɛŋ yi mi nyɛ kii beŋ. Nɛ feti yɛɛŋ ni, nɛ se ni nɛ kiimi mi.” ");
INSERT INTO asj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Se nuuŋ le, si be tɛ̀ mɛɛshi njɛ, dzɔ fika kweeŋ le, “Fika fini nuuŋ leh wu fwɛŋ wu Nyɔ ji bɛ ŋgɔŋ meŋ mɛ bo kii beŋ. ");
INSERT INTO asj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Se nuuŋ le, yikɛ yɛɛŋ nɛ woo! Wi wu gii kabɛ mi njiiɔ biee fɛni tɛɛ wu! ");
INSERT INTO asj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nɛ kɛɛ le, Ŋwanɛwi gii gɛɛŋ nɛɛ si Nyɔ tɛ̀ nachɛ. Se nuuŋ le, ŋgɛ wu nyɔŋa wɛ wu wi wu kabɛ wu.” ");
INSERT INTO asj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Be se bɛchi be biiti li yi yi bee laa, wi wu nuuŋ fɛ ŋwaani fini fiee lɛ bee lɛnti nuuŋ noo le? ");
INSERT INTO asj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Be tɛ̀ dza be bɛchi bitɛchinɛ li yi yi bee laa, ɛ noo wu nuuŋ wi wu nyɔŋa lɛ bee lɛnti le? ");
INSERT INTO asj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jiso se tee li bee le, “Bɛmfɔŋ bɛ laaŋkwiiŋ kɛmi buŋga lɛ bɛniiŋ bɛ bee lɛwe, bɛniiŋ bɛ sɛki kwɛɛŋ se tiiti le bɛ ni bɛ teenyi be le bintɔɔŋ bi bɛniiŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Se nuuŋ le, nuuŋ fi tɛ nuuŋ lɛ bɛ beŋ kɛ. Wi wu nyɔŋa lɛ be-eŋ lɛnti ni dzeti le ɛ wu ŋwaŋ wu bwi, wi wu nuuŋ kikoo ni nuuŋ si wi wu nindi li beŋ bɛchu-u. ");
INSERT INTO asj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wi wu nyɔŋa nuuŋ wu la, ɛ wi wu yemi jii biee mɔɔ, wi wu deeki le? Ɛ nɛɛ wi wu yemi jii biee ni? Se nuuŋ le, mi wɛ lɛ be-eŋ lɛnti si wi wu nindi li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Si nshiiŋ ŋiŋgi bumfa mfi kwi ni, ɛ nɛɛ beŋ bani bɛ ti nuuŋ bɛ mi. ");
INSERT INTO asj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Fi fiɛɛ le, nɛɛ si Baa wɛŋ nyɛ mi bumfɔŋ le ni nsɛki, mi nyɛɔ tɛ bumfɔŋ li be-eŋ le nɛ ni nɛ sɛki. ");
INSERT INTO asj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mi nyɛɔ le ke nɛ ni nɛ jii, nɛ wundi biee kintsii kimumkpaŋ lɛ ntɔ wɛŋ, nɛ se shee li bɛkabara, nɛ ni nɛ sɛki Bini bi Isɛlɛɛ bi yoofi ntsɔ bifɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jiso dza teeŋ Pita le, “Simu, Simu, bichɛ ɔ ŋɛŋ, Sataŋ fiɔ buŋga buchɛkinɛ beŋ bɛchu le buu bamu nɛɛ si wi ti fɛɛti giiŋ buu mumfɛɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Se nuuŋ le, nlɛkɔɔ Nyɔ li wɛɛ le, kiiŋ shéŋ ya ni bo li mi-i kɛ; Mfi wɔɔ kaari ɔ teeŋ bufii bwo, ɔ nyɛ buŋga li bɛŋwaana-a.” ");
INSERT INTO asj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita tee le, “Taa, ɛ fi nuuŋ le ŋgɛɛŋ ncha kɛ le ŋkwi, kɛ mi wɛ nɛɛ tɛɛ wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jiso tee li wuu le, “Pita, woo ntee wɛ, Nyinɛshee gii ke yi teŋgi bɛŋ, nuuŋ ɔɔ faaŋ mi kiŋga kitɛɛtɛ le ɔ kii yɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jiso dza bii li bee laa, “Nɛ kiimi mfi wu ntɛ̀ ntoŋ beŋ babi wu kwa nsiŋ, bɛbabi bɛ bikpɔ nsiŋ, si nɛ tɛ deŋgi lɛ, nɛ tɛ foo fiee ni?” Be tuu le, “Wohoo, tɛ tɛ̀ fuki yɛ fiee kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Se tee li bee le, “Li dɛɛni, ɛ wi kɛmi babi wu kwa, kɛ babi, mwɛ dzɔ. Ɛ wi kɛmi yɛ nyɔ yi dziŋ kɛ, mwɛ kabɛ ndu ye go nyɔ. ");
INSERT INTO asj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ntiitɔɔ fini ni kifɛ fiee fi bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ le, ‘Bɛ tɛ̀ fa wu bɛ bɛniiŋ bɛ bifi’, fi kɛmi le fi ka bɛ mi dɛɛni. Nɛ kɛɛ le biee bi bɛ tɛ̀ tsɛɛ kii mi, bi bɛɛ biɛɛ bi kɔchɛ bichu.” ");
INSERT INTO asj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Be biee be dzakɛ be tee le, “Taa bichɛ ɔ ŋɛŋ, tɛ̀ kɛmi baa nyɔ́ yi dziŋ fiɛtu.” Tuu le, “Gɛɛ yɛŋ lɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jiso dza bo li kitoŋ kilu bee bɔɔŋ bee bɛ kintutu be bɛchi be yɛki li ŋkumɛ wu Biti bi Oli-if, nɛɛ si tɛ̀ shiiŋ feti. ");
INSERT INTO asj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Le be yɛɛ be bo fɛ be tɛ̀ giiŋgi, tee li bee le, “Nɛ lɛki yɛɛŋ li Nyɔ-ɔ le kiiŋ mɔnchɛ ni bɛ lɛ be-eŋ, yaa beŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Si tɛ̀ tee lɛ, tuu kiiŋgi gɛɛŋ bo nɛɛ si nuuŋ wi lɔŋ tɛtɛ chi gɛɛŋ chi bo lɛ, se toŋ núŋ fɛkwiiŋ lɛki li Nyɔ-ɔ le, ");
INSERT INTO asj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baa wɛŋ, ɔɔ kɔŋgisi lɔ, ɔ tsaaki fika fi ŋgɛ fini li mi-i. Se nuuŋ le, fɛrɛ nɛɛ si ɔ kɔŋgisi, ɔ fɛ kɛ si ŋkɔŋgisi kɛ.”  ");
INSERT INTO asj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Le lɛkɛ lɛ, nchindaa wu Nyɔ shee liboo bɛ li wuu, nyɛ wu buŋga. ");
INSERT INTO asj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jiso tɛ̀ nuuŋ, ɛ shéŋ yee tɛ̀ bee ŋge. Tɛ tuu lɛki li Nyɔ-ɔ bɛ buŋga, liŋgisi, kiyubɛ kee sɛyi fɛkwiiŋ si bitetee bi ŋgɔ-ɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Le lɛkɛ li Nyɔ-ɔ mɛɛshi, to lijiŋ fɛ bɔɔŋ bee bɛ kintutu, ŋɛŋ si nshiiŋ fɛ be fiɔɔŋ be liiti. ");
INSERT INTO asj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Se bii li bee laa, “Nɛ tuu liiti lɔɔ ni? Dzatsɛ yɛɛŋ we nɛ lɛkɛ li Nyɔ-ɔ kii mɔnchɛ ni bɛ lɛ be-eŋ, yaa beŋ.” ");
INSERT INTO asj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nɛɛ si tɛ̀ mɛɛŋ yeti lɛ, kintutu ki bɛniiŋ lɛ busɛ ɛ tɛ̀ nuuŋ Judas wu wi kintutu ki bɔɔŋ bɛ Jiso bɛ yoofi ntsɔ bɛfɛ baa wu tɛ̀ tuuti mbaaŋ. Gɛɛŋ li Jiso lichiŋ le kokɛ wu. ");
INSERT INTO asj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Se nuuŋ le, Jiso bii li Judas laa, “Ɔ wɛki le ɔ kokɛ Ŋwanɛwi, le ɔ doonchɛ le bɛ kɔɔ wu ni?” ");
INSERT INTO asj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bɔɔŋ bee bɛ kintutu-u bɛ tɛ nuuŋ li wuu lichiŋ ŋɛŋ fiee fi tɛ̀ kɛti, be tuu be bii laa, “Taa, tɛ wachɛ bɛniiŋ bani ni?” ");
INSERT INTO asj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wumu lɛ bee lɛnti, kɛri kintooŋ ki kigɔŋɛ ki mfwa wu kikoo ki bɛte muntofi. ");
INSERT INTO asj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jiso waŋ le, “Kiiŋ wi ni tuu mɔŋ kɛ,” biee koŋ li kintooŋ ki wi wulu ki biee ki kobɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bɛniiŋ bɛ tɛ̀ bɛɛ le be kɔɔ Jiso tɛ̀ nuuŋ bɛte muntofi bɛ nɔŋa bɛ nɔŋa, bɛ bikoo bi bɛniiŋ nchi bɛ tɛ̀ kiichi yih yi muntofi mɔɔ bɛniiŋ bɛ sɛki kwɛɛŋ. Bii li bee laa, “Nɛ bɛ le nɛ kɔɔ mi nɛ bɛɛ bɛ nyɔ́ mɔɔ bimboki kɛɛ nɛ bɛɛ le nɛ kɔɔ nuuŋ wih ni? ");
INSERT INTO asj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ntuu nuuŋ tɛɛbeŋ li jo li jo fɛ yih yi muntofi nɛ tɛ koŋ li mi-i kɛ kii la? Se nuuŋ le, wuuŋ mfi wu nuuŋ nɛ fɛ fiee fimu, mfi wu buŋga bu kijibɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bɛniiŋ bɛlu biee be kɔɔ Jiso be giiŋgi bɛ wu fɛ la wu kikoo ki te muntofi-i, Pita se biki lɛjiŋ mfiiŋ. ");
INSERT INTO asj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Be gɛɛŋ be kukɛ wi la kintikinti be shee be wɔɔnsi. Pita se bɛ shee tɛ bee be. ");
INSERT INTO asj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Si wi tɛ̀ duti lɛ, ŋwaŋ wu nimɛ wu kwɛɛŋ wumu wu tɛ̀ nindi fɛ la wulu-u dza ŋɛŋ Pita ɛ wu shee. Bichɛ wu li lii bujɔŋ tee le, “Wi wuni bee nuuŋ tɛ bee wi wulu.” ");
INSERT INTO asj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita biee faaŋ tee le, “Kwɛɛŋ wuni, ŋkii yɛ wi wulu kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Le mfi tuu kiiŋgi niiŋ, wi wumu tuu ŋɛŋ wu, tuu tee le, “Ɔ nuuŋ tɛ wumu li kintutu ki bee.” Se nuuŋ le Pita tee le, “Nyuŋ, nuuŋ yɛ wi wu be kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Le mfi tuu gɛɛŋ bo si ntaŋ mumkpaŋ lɛ, wi wumu tuu sɔnɛ le, “Chɛɛŋ, chɛɛŋ wi wuni bee nuuŋ bee wu, kifɛ nuuŋ tɛ wi wu Galilii.” ");
INSERT INTO asj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita tuu faaŋ tee le, “Nyuŋ wuni, ŋkii yɛ fiee fiɔɔ tiiti kɛ.” Si tɛ̀ mɛɛŋ yeti lɛ, mfwaa mumkpaŋ nyinɛshee biee yi tɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Le Taa fiiki yi, lii yee bikɛ bɛ yi Pita. Pita kimi n'yɔru wu Taa bee yɔ li wuu le, “Fɛ nyinɛshee gii yi tɔɔŋ bɛŋ, nuuŋ ɔɔ faaŋ mi kiŋga kitɛɛtɛ le ɔ kii yɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dza fe bo lɛkuuŋ, de kwe ŋge. ");
INSERT INTO asj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɛniiŋ bɛ tɛ̀ kɛmi li Jiso-o se bɛchi be yɛndi, be tuki wu, ");
INSERT INTO asj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Be kaŋ wu ndu li bushi, be tee li wuu le, “Dɛɛni doonchɛ kintomfɔŋ ki Nyɔ-ɔ ko. Ɔ tee wi wu sooŋ wɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Be tuu be tsuki wu bɛ ntsooŋ ŋge be bifisi wu. ");
INSERT INTO asj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Le butuu woo, bɛniiŋ bɛ sɛki kwɛɛŋ bɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa, mɔɔ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ banchɛ yi bɛchu. Si be tɛ̀ banchɛ lɛ, be biee be dzɔ Jiso be gɛɛŋ bɛ wu fɛ be tɛ̀ shiiŋ be sɛki bɛnsa fe. ");
INSERT INTO asj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Le be gɛɛŋ bɛ wu lɛ, be tee li wuu le, “Ɔɔ nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛɛ, ɔ tee bee.” Tuu li bee le, “Ɛ mi ntee beŋ, nɛ tɛ beŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɛ mi mbii fiee li be-eŋ, nɛ tɛ tuu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Se nuuŋ le, mbɛɛchɛ li dɛɛni Ŋwanɛwi gii shee lɛ kibɛnɛ ki kigɔŋɛ ki Nyɔ yi buŋga-a.” ");
INSERT INTO asj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Be dzakɛ be bɛchu be bii laa, “Ɛ wɛ wu nuuŋ Ŋwanɛ Nyɔ ni?” Tuu li bee le, “Fi fiɛɛ si nɛ tee lɛ.” ");
INSERT INTO asj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Be se tee le, “Tɛ tuu tɛ geendi wumu le bɛ tee bee la. Tɛ woo baa fiee fi wu kweeŋ kituŋ bɛ kimfimɛ kee.” ");
INSERT INTO asj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Si kintutu ki bɛniiŋ bɛ tɛ̀ sɛki bɛnsa tɛ̀ tee lɛ, be se dza be bɛchu be dzɔ Jiso be giiŋgi bɛ wu fɛ Pailɛt. ");
INSERT INTO asj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Le be gɛɛŋ be bo fe, be bɛchi be kayi biee kii wu, be tiiti le, “Wi wuni deŋgɔɔ bifisi kwɛɛŋ wusɛŋ, fɛŋgɔɔ le kiiŋ bɛniiŋ ni be suuti kiŋwaati li Kaisa Mfɔŋ wu Lom kɛ, tuu tiiti le nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ, fi doonchi le ɛ wu mfɔŋ wumu.” ");
INSERT INTO asj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailɛt bii li Jiso laa, “Ɛ wɛ Mfɔŋ wu Bɛjuu ni?” Jiso tuu li wuu le, “Fi fiɛɛ si ɔ tee.” ");
INSERT INTO asj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailɛt dza kweeŋ li bɛte muntofi bɛnɔŋa bɛnɔŋa bɛ kintutu ki bɛniiŋ lɛ ki tɛ̀ nuuŋ fe le, “Mɛɛŋɔ ki ŋɛŋ bubiɛɛ bu wi wuni-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Be bɛchu tuu be kunyi wu le, “Wi wuni deŋgɔɔ tiifi bɛniiŋ li kwɛɛŋ kwikwi wu Judiya feti le be ni be tɛɛmi bikoo. Tɛ bɛchi Galilii, dɛɛni yani wɛ fɛni.” ");
INSERT INTO asj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Le Pailɛt woo fini lɛ, se bii laa, “Wi wuni nuuŋ wi wu Galilii ni?” ");
INSERT INTO asj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Be beŋ, se tuumi Jiso fɛ Mfɔŋ Hɛrɔ, kifɛ ɛ wu, wu tɛ̀ sɛki kimbɛ ki kwɛɛŋ lɛ kilu, ɛ tɛ̀ nuuŋ Jɛrosalɛŋ li mfi wulu. ");
INSERT INTO asj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Be gɛɛŋ bɛ Jiso, le Mfɔŋ Hɛrɔ ŋɛŋ wu, yi dzɔɔŋ wu ŋge, kifɛ tɛ̀ shiiŋ wuki kii wu, se bichi limfwe le gii naa ŋɛŋ wu, tuu nɛki tɛ le semukɛ Jiso nuuŋ fɛ fiee fi doonchi buŋga bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Se bɔsɛyi bii biee li Jiso-o bujɔŋ, le fi nuuŋ lɛ, Jiso ba nshiiŋ. ");
INSERT INTO asj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Fɛ tɛ̀ biiti lɛ, bɛte muntofi bɛnɔŋa bɛnɔŋa, bɛ bɛniiŋ bɛ tiifi bɛnchi bɛ Nyɔ-ɔ lemi tɛ fe be kayi binsɛɛ kii Jiso. ");
INSERT INTO asj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mfɔŋ Hɛrɔ bee bɛniiŋ bee bɛ nchi-i se dza be bɛchi be yɛndi be gaashi wu, be chuumɛ wu ndu yi dzeeŋ li bwiŋ, be too wu be tuumi wu lijiŋ fɛ Pailɛt. ");
INSERT INTO asj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Si fi tɛ̀ nuuŋ lɛ, Pailɛt bee Mfɔŋ Hɛrɔ tɛ̀ kɛmi mbani, le tuu boo yɛlu be to nsaŋ. ");
INSERT INTO asj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Si bɛ tɛ̀ tuu Jiso lijiŋ lɛ, Pailɛt konchɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ, tuu konchɛ bɛniiŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Be banchɛ, tee li bee le, “Nɛ bee nɛ bɛ bɛ wi wuni fɛni le fetɔɔ bɛniiŋ tɛɛmi bikoo, mi ntaaɔ lɛ biee bini-i lɛnti li lii yinɛ-ɛ, bichɛ yɛɛŋ nɛ ŋɛŋ, mɛɛŋɔ ki ŋɛŋ li biee bi nɛ kayi kii wu bini le wu fɛɔ fimu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mfɔŋ Hɛrɔ mɛɛŋɔ ki ŋɛɛŋ tɛ kɛ. Fiɛɛ fiee fi fɛ le kaari tuumi wi wuni li bee li. Ŋɛŋ yɛɛŋ le fiee nuuŋ yɛ lu fi wi wuni fɛ fi nuuŋ bɛ wo wu buwo kɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Si fi nuuŋ ni ŋgii mfiaamfiɛ wu bu mfiaamfiɛ nchinɛ li wuu gɛɛŋ.” ");
INSERT INTO asj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Si fi ti shiiŋ fi nuuŋ le mfi wu Tsɔnɔ chi N'yafuwee, Pailɛt kɛmi le buu wi mumkpaŋ li yih ncha-a, nyɛ li bɛniiŋ li si nchi wu be tɛ̀ gbɛŋgi tiiti. ");
INSERT INTO asj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bɛniiŋ bɛchu se dza be waŋ lɛwe ŋge le, “Mɛɛshi bɛ wi wuni! Ɔ buu nuuŋ Baraba li yih yi ncha-a ɔ nyɛ li bee li!” ");
INSERT INTO asj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba wuni tɛ̀ nuuŋ li yih yi ncha-a kifɛ tɛ̀ bɛchi kpɛ li kitoŋ kilu-u tuu wo wi. ");
INSERT INTO asj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailɛt woo lɛ se yɔ li bɛniiŋ bɛchu-u, kifɛ tɛ̀ wɛki le chinɛ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Se nuuŋ le, be tɛ̀ tuu be wɛndi nɛɛ le, “Taaŋ wu li kintaaŋ li! Taaŋ wu li kintaaŋ li!” ");
INSERT INTO asj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailɛt se tuu kweeŋ li bee kiŋga kitɛɛtɛ le, “Bɛ taaŋ wu kii la? Bubiɛɛ bu wu fɛ nuuŋ la? Mmɛɛŋɔ ki ŋɛŋ kɛ fiee fi bibifi fi wu fɛ fi nuuŋ bɛ wo wu kɛ! Ŋgii mfiaaŋ wu nchinɛ li wuu.” ");
INSERT INTO asj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Be ba be wɛndi lɛwe ŋge le bɛ taaŋ wu li kitaaŋ li, ŋ'wanu wu be yaa Pailɛt. ");
INSERT INTO asj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bɛdɛɛni, Pailɛt sondɛ nsa wulu, chinɛ li wuu, le be fɛ bɛ wu li ŋkɔŋgisɛ wu be-e. ");
INSERT INTO asj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Se tuu buu Baraba li yih yi ncha-a, nuuŋ wu wu be tɛ̀ biiti, ɛ tɛ̀ bɛchi kpɛ li kitoŋ kilu-u wo mɔɔ wi. Se buu Jiso nyɛ li bee si be tɛ̀ wɛki. ");
INSERT INTO asj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Be biee be dzɔ Jiso be giiŋgi bɛ wu. Si be tɛ̀ giiŋgi lɛ, be bikɛ bɛ wumu kuuki litɔɔ bukooŋ bwee nuuŋ le Simu, ɛ tɛ̀ nuuŋ wi wu Sɛliŋ. Be kɔɔ wu be gɛɛ kintaaŋ ki Jiso-o wu fɛ ŋgeŋge too biki Jiso. ");
INSERT INTO asj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bee be se giiŋgi, kintutu ki bɛniiŋ lɛ ŋge biki wu. Lɛ bee lɛnti tɛ̀ nuuŋ bukɛɛŋ bamu bɛ tɛ̀ dii be fayi bɛ ŋgɛ bee. ");
INSERT INTO asj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jiso se dza fiiki yi tee li bee le, “Bukɛɛŋ bɛ Jɛrosalɛŋ kiiŋ nɛ ni nɛ dii kii mi kɛ. Nɛ dii yɛɛŋ nuuŋ kii bikoo binɛ, mɔɔ bi bɔɔŋ bɛnɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nɛ kɛɛ le jo bɛɛ yɛɛ limfwe yi bɛniiŋ gii be ni be tiiti le, ‘Kinɛɛtinɛ kinɔŋa kɛɛ ki bukɛɛŋ bɛ nuuŋ kaa bɛ mɛɛŋ saa ki biɛ kɛ bɔɔŋ kɛ, mɔɔ bɛ mɛɛŋ saa ki nyɛ kɛ bɔɔŋ mbeeŋ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Li mfi wu wɛɛ, bɛniiŋ gii be ni be dzɛŋgi li bɛŋkumɛ bɛ nɔŋa-a le, ‘Weyɛ yɛɛŋ li bee li’, li bɛ ntɛ-ɛŋ le, ‘Baanyɛ yɛɛŋ bee’. ");
INSERT INTO asj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Be gii be ni be dzɛŋgi lɛ, kifɛ ɛ bɛ feti ŋwaani bini biee bɛ kiti ki mɛɛŋ tsɔɔŋ, be se fɛ niŋ bɛ kiti ki wondɛ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Si be tɛ̀ giiŋgi bɛ Jiso lɛ, be tɛ̀ giiŋgi tɛ bɛ bɛniiŋ bɛ ncha bamu bɛfɛ, le be gɛɛŋ be wo tɛ be. ");
INSERT INTO asj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Be se gɛɛŋ bɛ be, be bo kintsii kimu ki bɛ teenyi le, Kiŋgefi, be biee be taaŋ Jiso fe li kintaaŋ li, be taaŋ tɛ mɔɔ bɛniiŋ bɛ ncha bɛ bɛfɛ baa li bintaaŋ li mumkpaŋ lɛ kibɛnɛ ki Jiso ki kigɔŋɛ, wumu lɛ kibɛnɛ kee ki kimɛsɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jiso tuu dza tee le, “Taa, feeki bibifi bi bɛniiŋ bani, kifɛ be kii yɛ fiee fi be feti kɛ.” Bɛniiŋ bɛlu se dzɔ ndú yi Jiso be toŋ kaŋ lu le be gachɛ li yi yi bee. ");
INSERT INTO asj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Si biee bini bichu tɛ̀ kɛti bɛ Jiso lɛ, bɛniiŋ tɛ̀ lemi fe be bichi. Bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ tuu be bɛchi be chɔrisi wu, be kweŋgi le, “Tɛ fii bɛniiŋ bamu, fi tɛ yi yee dɛɛni. Ɛ ti nuuŋ kinsofu ki Nyɔ tɛ̀ kaachɛ yi tsaa!” ");
INSERT INTO asj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bɛniiŋ bɛ nchi-i tɛ̀ bɛ, be yɛndi wu, be nyɛɛ wu mɔɔ mbiiŋ mɛ mgbanyi, ");
INSERT INTO asj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","be tiiti le, “Ɔɔ ti nuuŋ Mfɔŋ wu Bɛjuu, ɔ fi yi ya.” ");
INSERT INTO asj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Be tɛ̀ tsɛɛ kiŋwaati be ta lɛ kikoo ki Jiso-o lɛwe le, “Wuni nuuŋ Mfɔŋ wu Bɛjuu.” ");
INSERT INTO asj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wumu li bɛniiŋ bɛ ncha-a bɛ bɛ tɛ̀ shiŋɛ li kintaaŋ li fe baa, dza bɛchi gaashi Jiso, tiiti le, “Ɛ nɛɛ wɛ ɔ ti nuuŋ kinsofu ki Nyɔ tɛ̀ kaachɛ ni? Fi yi ya lɛ, ɔ fi tɛ bee.” ");
INSERT INTO asj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wumu wɛ se woo fiee fi wumu wɛ kweeŋ, wamɛ wu, bii li wu laa, “Ɔ chɛndi yɛ Nyɔ kɛ ni? Ɔ wɛ li ŋgɛ-ɛ tɛ nɛɛ si wu. ");
INSERT INTO asj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tɛɛ wɛ kwi-i baa chɛɛŋ nuuŋ kinsomfu ki biee bibifi bi tɛ tɛ̀ fɛ-ɛ. Wi wuni kwiiɔ fiee mɛɛŋ ki fɛ kɛ fiee fi bifi kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wi wu ncha wulu se tuu tee le, “Jiso, ke ɔ ni ɔ kiimi mi mfi wu ɔ gii ɔ ni ɔ sɛki bumfɔŋ bwo.” ");
INSERT INTO asj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jiso tuu li wuu le, “Ntee wɛ chɛɛŋ le bɛŋ yani tɛɛ wɛ gii tɛ ni tɛ nuuŋ kintsii ki Bujɔɔŋ bu Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Le ni giiŋgi si jobɛ bikaa yoofi ntsɔ bifɛ, wiiŋ nyiŋ, lɛkuuŋ dza le jiŋ kwɛɛŋ kwikwi, gɛɛŋ bo si jobɛ bikaa bitɛɛtu lɛ fɛmfo-o, ");
INSERT INTO asj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ndu yi ti gatini yih yi muntofi lɛnti biee yi batɛ kintikinti yi to biŋkɛ bifɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Le Jiso ni nuuŋ li kintaaŋ li, dza waŋ lɛwe ŋge le, “Taa, mi nyɛɔ fiana yɛŋ li tsaŋ ya-a.” Le tee lɛ, biee yindɛ n'yindinɛ wu kimɛrisɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te Kikoo wu bɛniiŋ bɛ nchi-i wu tɛ̀ lemi fe wɛ ŋɛŋ fiee fi ka, nyɛ kiyɔɔni li Nyɔ-ɔ tee le, “Chɛɛŋ, chɛɛŋ, wi wuni bee nuuŋ findzɔŋ siŋ.” ");
INSERT INTO asj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bɛniiŋ bɛchu bɛ tɛ̀ turi fe le be ŋɛŋ fiee fi ka, be dza be kuuki li bɛla bɛ bee ɛ be ta tsaŋ lifa. ");
INSERT INTO asj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nsáŋ yi Jiso chichi tɛ̀ bɛ yi leŋ fi yi-i nuuŋ mfiiŋ yi se bichi fiee fi tɛ̀ kɛti. Bamu tɛ̀ nuuŋ bukɛɛŋ bɛ tɛ̀ dzɛti Galilii be biki wu. ");
INSERT INTO asj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wumu tɛ̀ nuuŋ li mfi wɛɛ bɛ teenyi wu le Jɔsɛ, ɛ tɛ̀ nuuŋ wi wu li kitoŋ ki Bɛjuu lɛ kimu ki bɛ tɛ̀ teenyi le Arimatia. Tɛ̀ nuuŋ wi wu dzeeŋ mɔɔ wi wu tsaaŋ lɛ Nyɔ lii, gii tɛŋgi mfi wu Nyɔ gii yi bɛ yi ni yi sɛki bumfɔŋ bu bwee. Tɛ̀ nuuŋ tɛ wi wu kintutu ki bɛniiŋ bɛ tɛ̀ sɛki bɛnsa-a. Se nuuŋ le, tɛ̀ mɛɛŋ ki beŋ kɛ fiee fi bɛ tɛ̀ seesɛ le bɛ fɛ bɛ Jiso kɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Gɛɛŋ fɛ Pailɛt, lɛkɛ gwini chi Jiso-o. ");
INSERT INTO asj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pailɛt beŋ, gɛɛŋ se shiiki gwini chilu, fiɛɛmɛ fɛ ndu-u, gɛɛŋ giiki lɛ dziŋ yi bɛ tɛ̀ chɔ lɛ kimba-aŋ, yi bɛ ti mɛɛŋ saa wi le ki gɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɛ tɛ̀ nuuŋ jobɛ chi nachɛ le bɛ lɛ li Jobɛ chi bɛshiinshi, ɛ tɛ̀ shɛ nɛɛ niiŋ le jobɛ chi bɛshiinshi chilu bɛchi. ");
INSERT INTO asj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bukɛɛŋ bɛ tɛ̀ dzɛti Galilii be biki Jiso baa, biee Jɔsɛ lɛ dziŋ, be ŋɛŋ si bɛ giki gwini chi Jiso lɛ dziŋ. ");
INSERT INTO asj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Be dza fe, be to li bɛla bɛ bee, be gɛɛŋ be fɛ mɛɛŋ mɛ dzeeŋ mɛ sɛɛndi mɛ bɛ tɛ̀ shiiŋ bɛ fwɛti gooŋ lu. Ɛ tɛ̀ nuuŋ jobɛ chi bɛshiinshi, be shi fe, si nchi wu be wɛki. ");
INSERT INTO asj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jobɛ chi bɛshiinshi bɛ chi ka, mɛɛŋ lɛ ŋ'wori li jobɛ chi ŋkosi li fuu li. Bukɛɛŋ baa, dzɔ mɛɛŋ mɛ be tɛ̀ nachɛ be gɛɛŋ fɛ dziŋ fɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Le be gɛɛŋ be bo fe, be ŋɛŋ ɛ bɛ biiŋgi tɛtɛ chi bɛ tɛ̀ baŋɛ fweeŋ wu dziŋ yɛ lu. ");
INSERT INTO asj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Be lɛ be gɛɛŋ lɛ dziŋ lɛ lu. Be ti mɛɛŋ ki ŋɛŋ kɛ gwini chi Taa Jiso-o le kɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Be leŋ fe be tɛti maa. Fi ka le buniŋ bamu bɛfɛ tɛ̀ leŋ li bee lichiŋ, ɛ be chuumɛ ndú yi ncherere yi miɛŋini. ");
INSERT INTO asj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bukɛɛŋ bɛlu tɛ̀ chɛŋ ŋge, be biee be toŋ bikoo bi bee fɛkwiiŋ. Buniŋ baa bii li bee laa, “Ɛ la fi nɛ wɛki wi wu mɛɛŋ yoŋ li biŋkwi-i linti? ");
INSERT INTO asj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wu fɛni kɛ, wu bo wɛ li kwe-e. Nɛ kimi fiee fi tɛ̀ tee beŋ mfi wu nɛ tɛ̀ mɛɛŋ Galilii. ");
INSERT INTO asj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tɛ tee le, ‘Bɛ kɛmi baa le bɛ nyɛ Ŋwanɛwi li tsaŋ yi bɛniiŋ bɛ bifi-i, be taaŋ wu li kintaaŋ li, ke bo jo taa, bo li kwe-e.’” ");
INSERT INTO asj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Be kimi fiee fi Jiso tɛ̀ tee li bee. ");
INSERT INTO asj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Be dza fɛ dziŋ, be kaari be to lijiŋ be gɛɛŋ be tee biee bini bichu li bɔɔŋ bee bɛ kintutu bɛ yoofi ntsɔ mumkpaŋ mɔɔ bɛniiŋ bɛchu bɛ tɛ̀ biki wu. ");
INSERT INTO asj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bukɛɛŋ bɛ tɛ̀ tee fiee fi tɛ ka filu li bɔɔŋ bɛ nto-oŋ bɛ Jiso baa tɛ̀ nuuŋ Maariya Madaliŋ, Joana mɔɔ Maariya wu ni Jeeŋ bɛ bukɛɛŋ bamu. ");
INSERT INTO asj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Be woo tefɛ chilu lamfaa, be faaŋ mbeenchɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Se nuuŋ le, Pita tɛ̀ dza nɛɛ we, letɛ gɛɛŋ bo fɛ dziŋ fɛlu, guumɛ bichɛ lɛ dziŋ lɛlu, ŋɛŋ nuuŋ ndú yi miɛɛfii yi bɛ tɛ̀ fiɛɛmɛ Jiso fe yɛ. Se biee dza karisi tuu lijiŋ bɛ chɛnɛ kii fiee fi ka. ");
INSERT INTO asj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Fi tɛ̀ dza fi ka le, booyaa bɛniiŋ bamu bɛfɛ bɛ tɛ̀ biki Jiso tɛ̀ dza Jɛrosalɛŋ be giiŋgi li kitoŋ kimu ki bɛ teenyi le Ɛmayɔ, ki tɛ̀ nuuŋ si bɛma mfomɛnyaaŋ mbochu fe. ");
INSERT INTO asj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Be tɛ̀ giiŋgi be tiiti li yi yi bee kii biee bi tɛ̀ ka bini bichu. ");
INSERT INTO asj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Si be tɛ̀ tiiti biee bini be tuu fe lɛ, Jiso kibɛɛ tɛ̀ bɛ deŋgi bee be. ");
INSERT INTO asj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Fiee fimu fɛ le be kɛɛ kɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jiso se dza bii li bee laa, “Ɛ la fi nɛ tiiti kii fi li yi yinɛ si nɛ giiŋgi ni?” Si tɛ̀ bii lɛ, be tuu be leŋ bɛ nshiiŋ li mɛnshi mɛ bee. ");
INSERT INTO asj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wumu lɛ bee lɛnti wu bukooŋ bwee tɛ̀ nuuŋ le Klofas bii li wuu laa, “Ɛ wɛ kwaa wu nuuŋ kilɔ Jɛrosalɛŋ fɛni wu mɛɛŋ ki woo kɛ biee bi ka li jo yini kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bii laa, “Biee bi la?” Be tuu le, “Biee bi tuu bi ka bɛ Jiso wu Nasarɛ. Wi wuni tɛ̀ nuuŋ ntomfɔŋ wu Nyɔ, biee bi tɛ̀ feti mɔɔ bi tɛ̀ tiiti tɛ̀ nuuŋ bintɛwa bi biee lɛ. Tɛ nuuŋ wi wu nyɔŋa li Nyɔ-ɔ limfwe bɛ li bɛniiŋ bɛchu-u. ");
INSERT INTO asj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bɛte muntofi bɛnɔŋa bɛnɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ wusɛŋ tuu be nyɛ wu le bɛ wo. Bɛ se taaŋ wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tɛ tɛ̀ bichi limfwe li wuu le, ɛ wu wu gii buu bɛniiŋ bɛ Isɛlɛɛ li tsaŋ yi ŋgɛ-ɛ. Se nuuŋ le, bɛŋ yaa jo taa si biee bini tuu bi ka. ");
INSERT INTO asj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Fimu fiɛɛ le bukɛɛŋ bamu li kintutu kisɛŋ be be tee fiee fi fieeŋgi bee, le be tuu be bo be gɛɛŋ fɛ dziŋ taantaaŋ, ");
INSERT INTO asj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","be mɛɛŋ ki ŋɛŋ kɛ gwini chee le kɛ. Le be kaari be to lijiŋ, be tee le be ŋɛŋ baa bɛnchindaa bɛ Nyɔ-ɔ si kifiee, be tee be le Jiso wɛ we. ");
INSERT INTO asj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bɛniiŋ bamu li kintutu kisɛ-ɛŋ gɛɛŋ fɛ dziŋ fɛlu be ŋɛŋ nɛɛ si bukɛɛŋ baa be be tiiti, se nuuŋ le, be se mɛɛŋ baa ki ŋɛŋ Jiso kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jiso kweeŋ li bee le, “Yeee, bibere bini, shéŋ yinɛ yɛɛ wɛɛ ŋge le nɛ beŋ biee bi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tiiti. ");
INSERT INTO asj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nɛ kii yɛ le Kinsofu ki Nyɔ tɛ̀ kaachɛ tɛ̀ kɛmi le ki ŋɛŋ bɛŋgɛ bani, ki se lɛ li bunɔŋa bu kii ni?” ");
INSERT INTO asj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jiso se bɛchi naanyi li bee biee bichu bi bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ kii wu, mbɛɛchɛ li bi Mɔɔsɛ tɛ̀ tsɛki, gɛɛŋ bo fɛ bi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Le be bɛ be bo li kitoŋ ki be tɛ̀ giiŋgi fe kɛɛ lichiŋ, Jiso fɛ kɛɛ kɛtɔɔ fe. ");
INSERT INTO asj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Be lɛkɛ wu ŋge be tee le, “Tɛ gɛɛŋ tɛ tsi. Lɛkuuŋ jiŋ laa ŋge, mfi gɛɛŋɔ ŋge,” Se beŋ le gɛɛŋ tsi bee be. ");
INSERT INTO asj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Be se gɛɛŋ, le be ni be jii biee, dzɔ tsee yi kibele, nyɛ kiyɔɔni li Nyɔ-ɔ, booyɛ nyɛ li bee. ");
INSERT INTO asj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mfwaa mumkpaŋ nɛɛlɛ, lii yibe gwiyɛ, be se biee be kɛɛ wu. Jiso la be lɛ lii. ");
INSERT INTO asj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Be shɛ be tiiti li yi yi bee le, “Mɔɔ shéŋ yisɛŋ bee yi yuusɛ mfi wu bee tiiti li bee li lɛ dze, fɛ bee naanyi biee bi lɛ Kiŋwaati ki Nyɔ-ɔ li bee li ni?” ");
INSERT INTO asj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Be se biee be dza mfwaa mumkpaŋ li mfi wulu-u be to Jɛrosalɛŋ. Le be gɛɛŋ, be ŋɛŋ bɔɔŋ bɛ Jiso bɛ kintutu bɛ yoofi ntsɔ mumkpaŋ baa ɛ be banchɛ kintsii kimumkpaŋ bɛ bɛniiŋ bamu bɛ gii be shiiŋ be biki wu. ");
INSERT INTO asj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Be tee le, “Chɛɛŋ, Taa wusɛŋ boɔ li kwe-e. Bee taa wu busɛ lɛ Simu lii.” ");
INSERT INTO asj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Be tuu be tee tɛ be fiee fi tɛ̀ ka bɛ be lɛ dze, be naanyɛ mɔɔ si be be kɛɛ wu mfi wu bee booyi kibele. ");
INSERT INTO asj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nɛɛ si be tɛ̀ mɛɛŋ be tiiti lɛ, Jiso kibɛɛ dza busɛ lɛ bee lɛnti yɛsi be le, “Kimbɔnɛ nuuŋ bɛ beŋ.” ");
INSERT INTO asj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Be dzakɛ be kɛɛti, be tɛ̀ chɛŋ, be beechi le be ŋɛŋ baa nuuŋ ŋkuubee. ");
INSERT INTO asj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Se bii li bee laa, “Nɛ chɛndi la? Fi geeŋ fi nɛ mɛŋɛ mi? ");
INSERT INTO asj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bichɛ yɛɛŋ nɛ ŋɛŋ tsaŋ yɛɛŋ bɛ bikaa bieŋ nɛ se kɛɛ le ɛ mi kibɛɛ. Mɔnchɛ yɛɛŋ yi yɛɛŋ nɛ kɛɛ, kifɛ ŋkuubee ti kɛmi yɛ nyaŋ bɛ biŋkomfu si nɛ ŋɛŋ mi kɛmi ni kɛ.” ");
INSERT INTO asj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Le tee lɛ, biee doonchɛ tsaŋ yee bɛ bikaa biee li bee. ");
INSERT INTO asj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Be bichɛ Jiso, be woo bujɔŋ, be ta maa. Fi yaa be mbeenchɛ le ɛ wu. Dza bii li bee laa, “Nɛ kɛmi baa fiee fijɛ fɛni ni?” ");
INSERT INTO asj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Be dzɔ kiŋkɛ ki nsuuŋ yi bɛ kuni, be nyɛ wu. ");
INSERT INTO asj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Fi ji lɛ be lii. ");
INSERT INTO asj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Se tee li bee le, “Biee bi nɛ ŋɛŋ bɛŋ bini nuuŋ bi ntɛ ntiiti beŋ kii bi mɛɛŋ tɛɛbeŋ. Ntɛ̀ ntee le, biee bichu bi bɛ tɛ̀ tsɛɛ kii mi lɛ bɛnchi bɛ Mɔɔsɛ-ɛ, bɛ lɛ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ mɔɔ lɛ kiŋwaati ki n'yɔɔnchɛ, kɛmi le bi bɛ bi kɔchɛ.” ");
INSERT INTO asj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Se gwiyɛ bufii bubee, be kɛɛ biee bi nuuŋ lɛ Kiŋwaati ki Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Se tee le, “Bɛ tɛ̀ tsɛɛ le, Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛmi le ki ŋɛŋ ŋgɛ ki kwi, ke bo jo taa, ki bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Fi se fiɛɛ tɛ le, bɛ gii bɛ bɛchi Jɛrosalɛŋ bɛ ni bɛ fenjisi li bitoŋ bichu-u kii bukooŋ bwee, le bɛniiŋ bɛchu fiiki shéŋ yibe, Nyɔ feeki bifi bi bee. ");
INSERT INTO asj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɛ beŋ bani nɛ gii nɛ ni nɛ tiifi biee bini bi nɛ ŋɛŋ baa bɛ lii yinɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yikɛ yɛɛŋ nɛ woo, ŋgii ntuumi nya yi Taa tɛ̀ kaachɛ beŋ lu. Si fi nuuŋ lɛ, ba yɛɛŋ fɛ kitoŋ kini nɛ ni nɛ tɛngi buŋga bu gii bu shee liboo bu bɛ li be-eŋ.” ");
INSERT INTO asj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dzɔ be bo bɛ be fɛ kitoŋ kilu-u, le bee be gɛɛŋ be bo li kitoŋ ki Bɛtani lichiŋ, tsaaki bibɛnu biee liwe, tiiŋ mwɛ li bee. ");
INSERT INTO asj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Si tɛ̀ mɛɛŋ tiŋgi mwɛ li bee lɛ, biee dza yɛki liboo, se yɛɛ layɛ. ");
INSERT INTO asj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Be se nyɛ kiyɔɔni ki nɔŋa li wuu, be se dza fe be to Jɛrosalɛŋ bɛ kinɛɛtinɛ ki kinɔŋa li shéŋ yi be-e. ");
INSERT INTO asj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Be tɛ̀ giiŋgi be shiiti li yih yi muntofi, be yɔɔnchi Nyɔ mfi kwi.");
INSERT INTO asj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fɛ mbɛɛchɛ-ɛ Jɛ tɛ̀ nuuŋ lu. Jɛ yilu tɛ̀ nuuŋ bɛ Nyɔ, Jɛ yilu tɛ̀ nuuŋ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yi tɛ̀ nuuŋ lu fɛmbɛɛchɛ-ɛ bɛ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nyɔ tɛ̀ tɔŋ biee bichu kɛti li tsaŋ yee li. Fiee fimu nuuŋ yɛ lu mɔɔ nuuŋ fimumkpaŋ fi bɛ tɛ̀ tɔŋ fuki yi siŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kɛmɔɔ ntsɛ li yi yee li, ntsɛ wulu se nuuŋ kiŋ'wofu li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kiŋ'wofu kilu bɛndi kɛɛ li kijibɛ-ɛ, kijibɛ kilu se nuuŋ tɛ nyiimi kiŋ'wofu kilu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wumu tɛ̀ nuuŋ lu wu Nyɔ tɛ̀ toŋ bukooŋ bwee nuuŋ le Jɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tɛ̀ bɛ le tee kii kiŋ'wofu kilu, le leŋ lɛ nsa wu ki-i lɛjiŋ, le ke se fɛ bɛniiŋ bɛchu gɛɛ shéŋ li kiŋ'wofu kilu-u. ");
INSERT INTO asj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wu wu Jɔɔŋ kibɛɛ tɛ̀ nuuŋ yɛ kiŋ'wofu kilu kɛ. Tɛ̀ bɛ nɛɛ le leŋ nuuŋ lɛ nsa wu kiŋ'wofu kilu-u lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kiŋ'wofu ki chɛɛŋ ki doonchi kiŋ'wofu li bɛniiŋ bɛchu bɛ tɛ̀ bɛ li nshɛ yini-i. ");
INSERT INTO asj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tɛ nuuŋ li nshɛ yini-i, nshɛ yini nuuŋ yi Nyɔ tɛ̀ tɔŋ kɛti li tsaŋ yee li, se nuuŋ le, bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i se ti mɛɛŋ wu ki kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tɛ̀ bɛ li nshɛ ye-e, bɛniiŋ bee se ba wu ki fi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Se nuuŋ le, li bɛniiŋ bɛchu bɛ tɛ̀ fi wu, be gɛɛ shéŋ li wuu, nyɛ buŋga li bee le be ni be nuuŋ bɔɔŋ bɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bɔɔŋ bɛ Nyɔ-ɔ bani nuuŋ yɛ bɛ bɛ biɛ be biki ŋgɔŋ mɛ kini-i, kɛ bɛ kiŋkɔŋgisɛ ki wi-i, kɛ biɛrɔ chi wiwoŋ kɛ. Bɛ biɛ baa be biki nuuŋ biɛrɔ chi nuuŋ chi Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jɛ yilu tɛ̀ to wiwoŋ se tsiiŋ lɛ bee li lɛnti, tɛ̀ yisɛ bɛ kiŋkɔŋgisɛ ki Nyɔ-ɔ bɛ chɛɛŋ. Tɛ tɛ̀ ŋɛŋ bunɔŋa bwee. Bunɔŋa bu nuuŋ bu Ŋwaŋ wu dza fɛ Tee li kwaa. ");
INSERT INTO asj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔɔŋ tɛ̀ leŋ lɛ nsa lɛjiŋ kii wu se dzɛŋgi tiiti le, “Wuni nuuŋ wi wu ntɛ̀ ntiiti kii wu ŋkweŋgi le, ‘Wi wu bɛɛ lɛ mi jiŋ kuuɔ yɛki mi, kifɛ tɛ̀ saa wu nuuŋ lu, nse naa nuuŋ lu.’” ");
INSERT INTO asj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Si wu yisɛ bɛ kiŋkɔŋgisɛ ki Nyɔ-ɔ lɛ, se nyɛɛɔ bee bɛchu kiŋkɔŋgisɛ li kiŋkɔŋgisɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tɛ kii baa le Nyɔ tɛ̀ nyɛ bɛnchi kɛti li tsaŋ yi Mɔɔsɛ-ɛ. Se nuuŋ le, kiŋkɔŋgisɛ ki Nyɔ-ɔ bɛ chɛɛŋ bɛ biɛɛ bi kɛti li tsaŋ yi Jiso Krai. ");
INSERT INTO asj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wi nuuŋ yɛ lu wu saa wu ŋɛŋ Nyɔ kɛ. Ɛ nɛɛ Ŋwani kwaa wu ba nɛɛ wu wu nuuŋ li Tee li lichiŋ wu fɛɔ tɛɛbeŋ se kɛɛ yi. ");
INSERT INTO asj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Fini nuuŋ fiee fi Jɔɔŋ tɛ̀ tee mfi wu bikoo bi Bɛjuu bi Jɛrosalɛŋ tɛ̀ toŋ bɛte muntofi bɛ bɛniiŋ bɛ kini ki Lebi-i le be bii li Jɔɔŋ li laa, ɛ wu noo le. ");
INSERT INTO asj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jɔɔŋ tɛ̀ mɛɛŋ ki faaŋ kɛ ntusu mbifu wu be kɛ. Tɛ̀ yɔ bɛ kimfimɛ kee le, “Ɛ mi wu nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Be se bii li wuu laa, “Ɔ se nuuŋ noo? Ɔ nuuŋ Ɛlaja ni?” Se tuu li bee le, “Ɛ mi Ɛlaja kɛ.” Be se tuu be bii li wuu laa, “Ɛ wɛ Ntomfɔŋ wu Nyɔ wɛ ni?” Se faaŋ. ");
INSERT INTO asj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Be se tuu be bii li wuu laa, “Ɔ se nuuŋ noo? Ɔ tee le la kii kikoo ko? Tee nɛɛ bee, tɛ kɛmɛ fiee fi tɛ karisi baa tɛ gɛɛŋ tɛ laŋɛ li bɛniiŋ bɛ bee be toŋ bee.” ");
INSERT INTO asj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔɔŋ se tuu li bee si Ɛsaya wu ntomfɔŋ wu Nyɔ tɛ̀ tee le, “Ɛ mi jɛ yi dzɛŋgi libuka le, ‘Bɛ leeki dze yi Taa yi ni yi nuuŋ tsaaŋ.’” ");
INSERT INTO asj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bɛniiŋ bani tɛ̀ nuuŋ Bɛfarasii bɛ tɛ̀ toŋ be. ");
INSERT INTO asj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Be bii li Jɔɔŋ li laa, “Ɔɔ nuuŋ yɛ Kinsofu ki Nyɔ tɛ̀ kaachɛ, kɛ Ɛlaja, kɛ Ntomfɔŋ wu Nyɔ wɛɛ kɛ, ɔ se tɛ̀ lisi bɛniiŋ li dzɔɔ kii la?” ");
INSERT INTO asj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔɔŋ se tuu li bee le, “Nlisɔɔ fieŋ bɛniiŋ nuuŋ li dzɔɔ kwaa, se nuuŋ le wumu wɛ lu li be-eŋ linti, nɛ se tɛ kɛɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ɛ wu wu bɛɛɔ lɛ mi-i jiŋ, mmɛɛŋɔ ki kɔchɛ kɛ le mfanchɛ kikpɔ kee kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Fiee fini fichu tɛ̀ kɛti nuuŋ Bɛtani Dzɔɔ yi Joodaaŋ liwiŋ fɛ Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Le butuu woo, Jɔɔŋ ŋɛŋ si Jiso bɛɛ, se tee le, “Bichɛ yɛɛŋ nɛ ŋɛŋ, wuni nuuŋ Ŋwanɛ Nshɔɔŋ wu Nyɔ yi tsakisi bibifi bi li nshɛ-ɛ! ");
INSERT INTO asj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɛ wu wu ntuu ntiiti kii wu ŋkweŋgi le, ‘Wi wumu bɛɛɔ lɛ mi-i jiŋ wu ko wu yaa mi, kifɛ tɛ̀ saa wu nuuŋ lu ŋkosi, nse naa ntuu nuuŋ lu.’ ");
INSERT INTO asj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mi kibɛɛ ntɛ̀ ŋkii yɛ mɔɔ wu kɛ. Se nuuŋ le, ntɛ̀ mbɛ nlisi bɛniiŋ li dzɔɔ le ke bɛniiŋ bɛ Isɛlɛɛ se kɛɛ wu.” ");
INSERT INTO asj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jɔɔŋ tɛ̀ tuu kweeŋ le gii leŋ lɛ nsa wu Jiso lɛjiŋ tee le, “Ntuu ŋɛŋ si Fiana shiiti yi bɛɛ liboo si kibimɛ lɛ, yi bɛ yi geri li wuu. ");
INSERT INTO asj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi kibɛɛ ntɛ̀ ŋkii yɛ mɔɔ fieŋ wu kɛ. Se nuuŋ le, wi wu tɛ̀ toŋ mi le mbɛ ni nlisi bɛniiŋ li dzɔɔ tɛ̀ tee li mi-i le, ‘Wi wu ɔ gii ɔ ŋɛŋ si Fiana shee liboo yi bɛ yi geri li wuu, ɛ wu wu gii ni lisi bɛniiŋ nuuŋ li tsaŋ yi Fiana yi Waaŋ li.’ ");
INSERT INTO asj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Fini nuuŋ fiee fi ntɛ̀ ŋɛŋ, nse ntuu nlemi lɛ nsa wulu lɛjiŋ ntiiti le wi wuni nuuŋ Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Le butuu woo, Jɔɔŋ tɛ̀ tuu leŋ fɛ tɛ̀ lemi bɛ bɔɔŋ bee bɛ kintutu-u bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dza ŋɛŋ si Jiso deŋgi kɛti, tee le, “Bichɛ yɛɛŋ nɛ ŋɛŋ, wuni nuuŋ Ŋwaaŋ Nshɔɔŋ wu Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Le bɔɔŋ bee bɛ kintutu-u bɛ bɛfɛ baa woo si wu tee lɛ, be se dza be biki Jiso. ");
INSERT INTO asj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jiso fiiki yi ŋɛŋ si be biki wu, bii li bee laa, “Nɛ wɛki nuuŋ la?” Be bii li wuu laa, “Labai, ɔ tsiiŋ fɛŋ?” (Bukooŋ bu Labai buni nuuŋ le, “Wi wu Ntiifɛ wu Nyɔŋa.”) ");
INSERT INTO asj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jiso se tuu li bee le, “Bɛ yɛɛŋ nɛ ŋɛŋ.” Be gɛɛŋ be ŋɛŋ fɛ tɛ̀ tsiiŋ. Bee be shi nsiiŋ lɛkuuŋ jiŋ. Mfi wu be tɛ̀ biki wu tɛ̀ nuuŋ nɛɛ si jobɛ bikaa binɛɛ lɛ fɛmfo-o. ");
INSERT INTO asj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wi mumkpaŋ li bɛniiŋ bɛ bɛfɛ bɛ tɛ̀ woo si Jɔɔŋ yɔ be se dza be biee Jiso tɛ̀ nuuŋ Andolo ŋwaani Simu Pita. ");
INSERT INTO asj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andolo wulu gɛɛŋ mfwaa mumkpaŋ gɔɔŋ ŋwaani wu Simu, tee li wuu le, “Tɛ ŋɛŋ baa Kinsofu ki Nyɔ tɛ̀ kaachɛ kituŋ” (ki nuuŋ le Krai). ");
INSERT INTO asj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Se nuuŋ le, se dzɔ Simu gɛɛŋ bɛ wu lɛ Jiso-o. Jiso bichɛ wu ni fwiiŋ, tee le, “Ɛ wɛ Simu wu ŋwanɛ Jɔɔŋ. Bɛ gii bɛ ni bɛ teenyɔ wɛ le Sɛfa.” (Bukooŋ bu Sɛfa buni nuuŋ le Pita). ");
INSERT INTO asj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Le butuu woo, Jiso se ŋɛŋ le gii gɛɛŋ kimbɛ ki Galilii. Gɛɛŋ ŋɛŋ Fili, tee li wuu le, “Ɔ biki mi.” ");
INSERT INTO asj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fili wuni tɛ̀ nuuŋ wi wu li kitoŋ ki Besaida-a. Kitoŋ kini tɛ̀ nuuŋ ki Andolo bee Pita. ");
INSERT INTO asj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fili se gɛɛŋ gɔɔŋ Natanya tee li wuu le, “Tɛ ŋɛŋ baa wi wu Mɔɔsɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki bɛnchi kii wu bɛ ki bɛntomfɔŋ bɛ Nyɔ tɛ̀ tsɛɛ tɛ kii wu wɛ kituŋ. Wi wuni nuuŋ Jiso wu Nasarɛ wu ŋwanɛ Jɔsɛ.” ");
INSERT INTO asj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanya tuu li wuu laa, “Fiee fi dzeeŋ nuuŋ naa fi bo Nasarɛ ni?” Fili tee li wuu le, “Bɛ ɔ ŋɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jiso dza ŋɛŋ si Natanya bɛɛ, tee kii wuu le, “Bichɛ yɛɛŋ nɛ ŋɛŋ, wi wuni wɛ nuuŋ wi wu Isɛlɛɛ kibɛɛ. Ntsɛ wu kimfi nuuŋ yɛ li wuu bwiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanya se bii li Jiso laa, “Ɔ geeŋ ɔ se kɛɛ mi?” Jiso tee li wuu le, “Fɛ Fili bee bɛɛ le teeŋ wɛ, nuuŋ ɛ mbee saa mi ŋɛŋ wɛ lɛ kinyi ki kiti ki fig lɛ kɛɛ.” ");
INSERT INTO asj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanya tuu li wuu le, “Labai, ɛ wɛ Ŋwanɛ Nyɔ! Ɛ wɛ Mfɔŋ wu Isɛlɛɛ!” ");
INSERT INTO asj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jiso se tee li wuu le, “Ɔ se beŋɔ dɛɛni kifɛ mi nteeɔ li wɛ-ɛ le mbee nsaa mi ŋɛŋ wɛ lɛ kinyi ki kiti kɛɛ ni? Ɔ gii ɔ ŋɛŋ biee bi kuu bi yɛki bini.” ");
INSERT INTO asj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jiso se tuu tee li wuu le, “Ntiitɔɔ beŋ chɛɛŋ chɛɛŋ le nɛ gii nɛ ŋɛŋ si kiboo gwiyɛ, bɛnchindaa bɛ Nyɔ-ɔ yɛki, be shiiti li Ŋwanɛwi-i.” ");
INSERT INTO asj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Le jo bo taa, bɛ tɛ̀ gii bɛ feti tsɔnɔ chi bugoo lɛ li kitoŋ ki Kana-a kimbɛ ki Galilii, ni Jiso nuuŋ fe. ");
INSERT INTO asj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bɛ tɛ̀ teeŋ tɛ mɔɔ Jiso bee bɔɔŋ bee bɛ kintutu-u fɛ tsɔnɔ chilu-u. ");
INSERT INTO asj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mbiiŋ tɛ̀ dza me ma, ni Jiso ku li wu tee li wuu le, “Be mɛɛŋ yɛ be kɛmi mbiiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jiso tuu li wu le, “Kwɛɛŋ, ɔ kuti li mi kii la? Mfi wɛŋ mɛɛŋɔ saa ki kɔchɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ni tee li bɛniiŋ bɛ gabi baa le, “Fiee fichu fi wu tee le nɛ fɛ, nɛ fɛ.” ");
INSERT INTO asj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tɛɛŋ tɛ̀ gii yi nuuŋ fe busɔɔ yi bɛ tɛ̀ fɛ bɛ ta. Tɛɛŋ yini nuuŋ yi Bɛjuu tɛ̀ shiiŋ be giki dzɔɔ le, be tsootsi bikoo bi bee lu, le be ni be wuuti lɛ Nyɔ lii. Tɛnɛ chi mumkpaŋ tɛ̀ dzeti bɛ tasa bɛ dzɔɔ lɛ si gwii mfomɛnyaaŋ ntsɔ bɛtiinu (75) Mbochu bɛ tasa gwii bɛ yoofi ntsɔ bɛtiinu (115). ");
INSERT INTO asj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jiso dza tee li bɛniiŋ bɛ gabi-i bɛlu le, “Kwɛ yɛɛŋ dzɔɔ nɛ yiiki tɛɛŋ yini lu.” Be se kwɛ dzɔɔ be yiiki lɛ tɛɛŋ yilu-u, yi yisɛ. ");
INSERT INTO asj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Se biee tee li bee le, “Kɔbi yɛɛŋ yimi dɛɛni nɛ gɛɛŋ bɛ yi fɛ te gabi-i.” Be se kɔbi be gɛɛŋ bɛ yi. ");
INSERT INTO asj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te gabi fi dzɔɔ yilu mɔŋ, woo ɛ yi to mbiiŋ. Mɛŋɛ laa mani mbiiŋ buti fɛŋ le. (Se nuuŋ le, bɛniiŋ bɛ gabi bɛ tɛ̀ kwɛ dzɔɔ yilu tɛ kii fɛ me buti fe.) Te gabi teeŋ nyuŋ wutso, ");
INSERT INTO asj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","bii li wuu laa, “Bɛniiŋ ti bɛɛ be saa be gachɛ nuuŋ mbiiŋ mɛ dzeeŋ fɛ tsɔnɔ-ɔ, fɛ bɛniiŋ woŋ be fukɛ kituŋ, be se gachɛ mɛ ti dzeeŋ yɛ kɛ maa. Ɔ tuu ɔ gɛɛ fio mbiiŋ mɛ dzeeŋ ɔ bɛ bɛ me nuuŋ dɛɛni ni?” ");
INSERT INTO asj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Fini tɛ̀ nuuŋ fiee fi ŋkosi fi doonchi bunɔŋa bu Jiso fi tɛ̀ fɛ lɛ biee bi doonchi bunɔŋa bwee li. Tɛ̀ fɛ fiee fini li kitoŋ ki Kana-a ki kimbɛ ki Galilii. Si tɛ̀ fɛ lɛ, fi se doonchɛ bunɔŋa bwee, bɔɔŋ bee bɛ kintutu gɛɛ shéŋ li wuu. ");
INSERT INTO asj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lɛjiŋ lɛ lu, Jiso dza bɔɔ Kapanuŋ bee ni mɔɔ bɛŋwaani bɛ buniŋ bɛ bɔɔŋ bee bɛ kintutu-u, bee be tsi le jo niiŋ. ");
INSERT INTO asj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jobɛ chi Tsɔnɔ chi Bɛjuu chi bɛ teenyi le N'yafuwe tɛ̀ bɛɛ tsɛkɛtsɛkɛ, Jiso dza yɛɛ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Le gɛɛŋ bo li yih yi muntofi-i, ŋɛŋ bɛniiŋ bɛ tɛ kabini bɛnaŋ bɛ nshɔ́ɔŋ mɔɔ bibimu mɔɔ bɛ tɛ̀ fikisi kwa ɛ be sheeyɛ. ");
INSERT INTO asj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dzɔ bɛkuu nachɛ seh lu, kooŋ be bɛchu bɛ wu, kooŋ mɔɔ nshɔ́ɔŋ bɛ bɛnaŋ buu li yih yi muntofi-i. Se tuu taashɛ kwa wu bɛniiŋ bɛ tɛ̀ fikisi kwa baa, bachɛ bideŋ bi bee, ");
INSERT INTO asj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","tee li bɛniiŋ bɛ tɛ̀ kabini bibimu baa le, “Dzɔɔ yɛɛŋ biee bini nɛ dza bɛ bi fɛni. Kiiŋ nɛ ni dzɔɔ yih yi Taa nɛ tuu yi to yih yi waŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Si tɛ̀ tee lɛ, bɔɔŋ bee bɛ kintutu-u biee be kimi fiee fi bɛ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ le, “Kiŋkɔŋgisɛ ki nɔŋa ki ŋkɛmi li yih ya-a gii ki wo mi buwo.” ");
INSERT INTO asj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bikoo bi Bɛjuu lɛ se bii li wuu laa, “Fiee fi doonchi bunɔŋa bwo fi ɔ nuuŋ ɔ fɛ le ɔ doonchɛ li bee li le bɛ nyɛ baa wɛ buŋga bufɛrɛ fini nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jiso tuu li bee le, “Shaanshɛ yɛɛŋ yih yi muntofi yini, ŋgii ntuu ndzɔɔ jo taa kwaa ŋkari nleeki yi we.” ");
INSERT INTO asj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bɛjuu bɛlu se bii li wuu laa, “Fi tɛ̀ dzɔ biya mbaanyɛɛ ntsɔ busɔɔ ŋgwanu yih yi muntofi yini, ɔ se gii ɔ dzɔɔ fio nuuŋ jo taa ɔ leeki yi we ni?” ");
INSERT INTO asj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Se nuuŋ le, Jiso tɛ tiiti kii yih yi muntofi yini lɛ nuuŋ yi yee. ");
INSERT INTO asj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bɛdɛɛni, mfi wu tɛ̀ bo li kwe-e, bɔɔŋ bee bɛ kintutu-u tuu be kimi le fini nuuŋ fiee fi tɛ̀ tiiti fiɛɛ. Be se beŋ fiee fi nuuŋ lɛ Kiŋwaati ki Nyɔ-ɔ, be beŋ tɛ mɔɔ n'yɔru wu Jiso tɛ̀ yeti. ");
INSERT INTO asj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Si Jiso tɛ̀ nuuŋ Jɛrosalɛŋ fɛ Tsɔnɔ chi N'yafuwee chini ni, bɛniiŋ ŋge tɛ̀ gɛɛ shéŋ li wuu kii biee bi doonchi bunɔŋa bwee bi tɛ̀ feti. ");
INSERT INTO asj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Se nuuŋ le, Jiso tɛ̀ mɛɛŋ ki gɛɛ kɛ fiee bufii bwee lɛ bee kɛ, kifɛ tɛ̀ kii bɛniiŋ bɛchu si be nuuŋ. ");
INSERT INTO asj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tɛ̀ mɛɛŋ ki waaŋ kɛ le wi wumu shee tee wu kii wumu kɛ, kifɛ wu kibɛɛ tɛ̀ gii kii fiee fi wiwoŋ kɛmi lɛ mwɛ shéŋ. ");
INSERT INTO asj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wi wu kintutu ki Bɛfarasii wumu tɛ̀ nuuŋ lu bɛ teenyi wu le Nikodɛmu, ɛ tɛ̀ nuuŋ wi wu kintutu ki bikoo bi kwɛɛŋ wu Bɛjuu lɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wi wuni dza bɛ lɛ Jiso butuu teeŋ wu le, “Labai, tɛ kii le ɔ nuuŋ Wi wu Ntiifɛ wu dza fɛ Nyɔ-ɔ, kifɛ wi nuuŋ yɛ lu wu nuuŋ ni feti ŋwaani bini biee bi doonchi bunɔŋa bu Nyɔ-ɔ bi ɔ feti bini fuki le Nyɔ yɛ bɛ wu nsiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jiso tuu li wuu le, “Ntiitɔɔ wɛ chɛɛŋ chɛɛŋ le, ɛ bɛ mɛɛŋ ki biɛ kɛ wi li biɛrɔ chi fɛŋ kɛ, mwɛ tɛ̀ naa ŋɛŋ bumfɔŋ bu Nyɔ-ɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛmu bii li Jiso laa, “Bɛ nuuŋ bɛ geeŋ bɛ se tuu bɛ kaari bɛ biɛ wi wu ta kituŋ le? Mwɛ nuuŋ tuu kaari to lɛ ni shéŋ le tuu ka biɛ wu ni?” ");
INSERT INTO asj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jiso tuu li wuu le, “Ntiitɔɔ wɛ chɛɛŋ chɛɛŋ le, ɛ wi mɛɛŋ ki kɛmɛ kɛ biɛrɔ chi dzɔɔ lɛ mɔɔ chi Fiana kɛ, kɛ nuuŋ tɛ lɛ lɛ bumfɔŋ bu Nyɔ-ɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wiwoŋ ti bii wiwoŋ, Fiana bii fiana. ");
INSERT INTO asj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kiiŋ wa ni tɛ wɛ le mi nteeɔ li wɛ-ɛ le bɛ kɛmi le bɛ kaari bɛ biɛ bɛniiŋ bɛchu li biɛrɔ chi fɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mfiee ti kɛti si yi kɔŋgisi, ɔɔ wuki si yi kɛti, se nuuŋ le, ɔ nuuŋ tɛ tee laa yi buti fɛŋ, kɛ laa yi giiŋgi fɛŋ le kɛ. Ɛ lɛ si fi fiɛɛ bɛ wi wu kɛmɛ biɛrɔ chi fiana yi waaŋ lɛ.” ");
INSERT INTO asj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛmu se ta maa laa, “Fini nuuŋ fi ka niŋ le?” ");
INSERT INTO asj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jiso tuu li wuu le, “Ɔ nuuŋ wi wu tiifi bɛniiŋ bɛ Isɛlɛɛ, ɔ se tɛ kɛɛ fini ni? ");
INSERT INTO asj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ntiitɔɔ li wɛ chɛɛŋ chɛɛŋ le, tɛ tiiti nuuŋ fiee fi tɛ kii, tɛ lemi lɛ nsa lɛjiŋ nuuŋ li fiee fi tɛ ŋɛŋ, se nuuŋ le nɛ se beenchi yɛ li fiee fi tɛ tiiti kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ɛ ntiiti biee li be-eŋ bi li nshɛ yini nɛ tɛ beŋ kɛ, nɛ se naa nɛ geeŋ nɛ se beŋ fɛ mi ntee nuuŋ bi li kwɛɛŋ wu Nyɔ-ɔ? ");
INSERT INTO asj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wi nuuŋ yɛ lu wu tɛ̀ saa wu yɛɛ liboo kɛ. Ɛ nɛɛ wi wu tɛ̀ bo lu wu bɛ laaŋkwiiŋ, wu nuuŋ Ŋwanɛwi. ");
INSERT INTO asj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Si Mɔɔsɛ tɛ̀ shiŋɛ yɔ yi bɛ tɛ̀ fɛ bɛ kikwa li kiti libuka, ɛ lɛ si bɛ kɛmi le bɛ shiŋɛ Ŋwanɛwi lɛ, ");
INSERT INTO asj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","le ke mɔɔ nuuŋ noo wu gɛɛ shéŋ li wuu le, mwɛ gii naa kɛmɛ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nyɔ tɛ̀ gbɛɛŋ yi kɔɔŋgi nshɛ yini ŋge, yi se toŋ Ŋwani wu mumkpaŋ, le ke mɔɔ nuuŋ noo wu gɛɛ shéŋ li wuu le, mwɛ tɛ la kɛ, mwɛ kɛmɛ nuuŋ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyɔ ti mɛɛŋ ki toŋ kɛ Ŋwani li nshɛ yini le bɛ saa bɛniiŋ le be we nsa kɛ. Tɛ̀ toŋ wu nuuŋ le, bɛ buu be bu busu. ");
INSERT INTO asj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wi wu gɛɛ shéŋ li wuu nuuŋ tɛ we nsa kɛ. Se nuuŋ le wi wu mɛɛŋ ki gɛɛ kɛ shéŋ li wuu kɛ, kɛ mwɛ weɔ nsa kituŋ, kifɛ mɛɛŋɔ gɛɛ kɛ shéŋ li bukooŋ bu Ŋwanɛ Nyɔ-ɔ wu nuuŋ wu kwaa kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bɛ gii bɛ sondɛ nsa lɛ yini dze, kifɛ kiŋ'wofu bɛ kɛɛ li nshɛ, bɛniiŋ se tuu be kɔɔŋgi fi bee nuuŋ kijibɛ yɛki kiŋ'wofu. Be kɔŋgisi lɛ kifɛ biŋge bi bee nuuŋ bibifi. ");
INSERT INTO asj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wi kwikwi wu feti kiŋge ki bifi ti baanini kiŋ'wofu, tɛ bo fɛ kiŋ'wofu nuuŋ kɛ, le kiiŋ kiŋge kee tuu ki yenɛ fɛ waaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Se nuuŋ le wi wu feti biee bi chɛɛŋ ti bɛɛ li kiŋ'wofu, le kiŋge kee ni ki yeŋgi si ki wi wu nuuŋ bɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lɛjiŋ lɛlu, Jiso bee bɔɔŋ bee bɛ kintutu-u dza be gɛɛŋ kimbɛ kimu ki Judiya. Bee be se gɛɛŋ be nuuŋ fe, lisi bɛniiŋ li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔɔŋ tɛ̀ lisi tɛ bɛniiŋ li dzɔɔ li kitoŋ ki Ɛnɔŋ li Saliŋ lichiŋ kifɛ dzɔɔ tɛ nuuŋ fe ŋge. Bɛniiŋ tɛ̀ bɛɛ lisi be li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Fini tɛ̀ nuuŋ bɛ mɛɛŋ saa wu li yih yi ncha-a ki lii kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bɔɔŋ bɛ Jɔɔŋ lɛ bɛ kintutu-u bamu bɛ wi wu Juu wumu tɛ̀ dza be bɛchi bitɛchinɛ kii yi yibe tsootsi le be ni be wuuti lɛ Nyɔ lii. ");
INSERT INTO asj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bɔɔŋ bɛ kintutu-u bɛ Jɔɔŋ lɛ dza be gɛɛŋ fɛ Jɔɔŋ li, be tee li wuu le, “Labai, wi wu nɛɛ wu nɛ tuu nɛ nuuŋ li Dzɔɔ yi Joodaaŋ luwiŋ lɔɔ, wɔɔ tɛ̀ tiiti ŋge kii wu wɛ, wi wulu lisɔɔ tɛ bɛniiŋ li dzɔɔ, bɛniiŋ bɛchu se giiŋgi baa nuuŋ fɛ wuu.” ");
INSERT INTO asj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔɔŋ tuu li bee le, “Wi nuuŋ tɛ nuuŋ fiee fimu fuki fɛ Nyɔ fɛ le ni nuuŋ fi nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Beŋ kibɛɛ nɛ nuuŋ nɛ leŋ lɛ nsa wɛŋ lɛjiŋ le ntɛ̀ ntee le ɛ mi wu nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ kɛ. Se nuuŋ le, bɛ tɛ̀ toŋ mi le nsaa ntoo mbaaŋ li ki-i. ");
INSERT INTO asj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nyuŋ wutso nuuŋ wi wu kɛmi kwɛɛtso. Nsaŋ yi nyuŋ wutso yi lemi li nyuŋ wutso wulu lichiŋ yi wuki jɛ yi nyuŋ wutso, ti wuki bujɔŋ si yi wuki jɛ ye lɛ. Ɛ lɛ si mi ŋ'wɛ tɛ dɛɛni ɛ mi n'yisɛ bɛ kinɛɛtinɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ŋkɛmi nɛɛ le ni ŋkuu ŋgiiŋgi nuuŋ limfwe, nse ntuu lɛjiŋ.” ");
INSERT INTO asj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wi wu dza liboo kuu yɛki bɛniiŋ bɛchu. Wi wu li nshɛ yini-i, nuuŋ wi wu li nshɛ yini-i tiiti kii biee bi li nshɛ yini-i. Wi wu dza li kwɛɛŋ wu liboo li yɛki wi kwi, ");
INSERT INTO asj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","mwɛ lemi lɛ nsa wu biee bi wu ŋɛŋ bɛ bi wu woo lɛjiŋ. Se nuuŋ le wi nuuŋ yɛ lu wu beenchi fiee fi tiiti kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wi kwi wu beenchi fiee fi tiiti nuuŋ wi wu doonchi le teendɔɔ fiee filu le Nyɔ tiiti yɛ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wi wu Nyɔ toŋ ti yeti nuuŋ jɛ yi Nyɔ, kifɛ Nyɔ nyɛ yɛ wu Fiana, yi bɛ nyɛ tɛ fichɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Te Ŋwaŋ kɔɔŋgɔɔ Ŋwaŋ, wu se nyɛ biee bichu li tsaŋ yee li. ");
INSERT INTO asj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wi wu gɛɛ shéŋ li Ŋwaŋ, kɛ mwɛ kɛmɔɔ ntsɛ wu kimakɛ. Wi wu mɛɛŋ ki woo kɛ li wuu kɛ, nuuŋ tɛ kɛmɛ ntsɛ kɛ. Wɛɛ wi, sheŋ fuuti yɛɛ Nyɔ bɛ wu kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jiso tɛ̀ dza kɛɛ le Bɛfarasii woo baa kituŋ le fetɔɔ tuu lisi bɛniiŋ bɛ kintutu-u li dzɔɔ ŋge, yɛki Jɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Se nuuŋ le, ɛ mɔɔ Jiso kibɛɛ wu gii lisi bɛniiŋ li dzɔɔ kɛ, ɛ bɔɔŋ bee bɛ kintutu-u kwaa bɛ tɛ̀ lisi bɛniiŋ li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Le kɛɛ lɛ, dza lɛ kimbɛ ki kwɛɛŋ wu Judiya wulu, tuu karisi tuu lijiŋ lɛ ki Galilii. ");
INSERT INTO asj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tɛ̀ kɛmi le ka dze yi kimbɛ ki Samaaria. ");
INSERT INTO asj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Gɛɛŋ bo li kitoŋ ki Samaaria kimu ki bɛ teenyi le Sika, ɛ ki tɛ̀ nuuŋ li wɛ wu Yakɔ tɛ̀ nyɛ li ŋwani wu Jɔsɛ-ɛ lichiŋ. ");
INSERT INTO asj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kitoo ki dzɔɔ yi Yakɔ tɛ̀ chiŋ tɛ̀ nuuŋ fe. Si Jiso tɛ̀ dɛndɛ fiɔɔŋ lɛ, se shee li kitoo ki dzɔɔ yilu-u lichiŋ. Mfi tɛ̀ nuuŋ si jobɛ bikaa yoofi ntsɔ bifɛ fɛnshaaŋ. ");
INSERT INTO asj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kwɛɛŋ wumu wu li kwɛɛŋ wu Samaaria wulu dza bɛ le chee dzɔɔ fe, Jiso se tee li wuu le, “Nyɛ mi dzɔɔ ŋ'woŋ.” ");
INSERT INTO asj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tɛ nuuŋ ɛ bɔɔŋ bɛ kintutu-u bɛ Jiso-o tɛ̀ gɛɛŋ fɛ la nyɔŋa le be go biee bijɛ. ");
INSERT INTO asj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kwɛɛŋ wulu bii li Jiso-o laa, “Ɔ nuuŋ wi wu Juu, nnuuŋ wi wu Samaaria, fi geeŋ fiɔɔ tuu lɛki dzɔɔ li mi-i?” Kwɛɛŋ wulu tɛ̀ tiiti lɛ, kifɛ Bɛjuu tɛ̀ nyamisi bɛniiŋ bɛ Samaaria. ");
INSERT INTO asj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jiso tuu li wuu le, “Bee nuuŋ le ɔ ni ɔ kii nya yi nuuŋ yi Nyɔ, mɔɔ wi wu tiiti li wɛ-ɛ le ɔ nyɛ wu dzɔɔ, bee nuuŋ ɔ lɛkɛ wu, wu nyɛ wɛ dzɔɔ yi beki mfi kwi.” ");
INSERT INTO asj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kwɛɛŋ wulu se kaari bii li Jiso-o laa, “Baa, ɔ kɛmi yɛ ŋkaa wu kwɛ dzɔɔ le kɛ, si kitoo kini seri ni, ɔ gii ɔ dzɔɔ yini dzɔɔ fɛŋ yi beki mfi kwi? ");
INSERT INTO asj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fi nuuŋ le ɔ ko ɔ yaa taa wusɛŋ wu Yakɔ wu tɛ̀ chiŋ kitoo kini gɛɛ li bee li ni, yi wu kibɛɛ tɛ̀ woŋ fɛ dzɔɔ yilu, bɔɔŋ bee woŋ tɛ fe, nyáŋ yee woŋ tɛ fe ni?” ");
INSERT INTO asj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jiso tuu li wuu le, “Wi kwi wu woŋ dzɔɔ yini ndɔɔŋ mɛɛŋɔ wu wondɛ li mwɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Se nuuŋ le, mɔɔ nuuŋ noo wu woŋ dzɔɔ yi ŋgii nnyɛ yini le, ndɔɔŋ nuuŋ tɛ naa wondɛ li wu-u kɛ. Dzɔɔ yi ŋgii nnyɛ li wuu yi gii yi dza yi to ntuuŋ wu dzɔɔ yi buti li wu-u mfi kwi, yi gii yi dɛndɛ yi nyɛ wu ntsɛ wu kimakɛ.” ");
INSERT INTO asj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kwɛɛŋ wulu se tee li Jiso-o le, “Baa, nyɛ mi ŋwaani yini dzɔɔ ke ndɔɔŋ tɛ naa tuu le wondɛ li mi-i le ni mbɛɛ fɛni ntuuti dzɔɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jiso tee li wuu le, “Gɛnɛ ɔ teeŋ nyuma nɛɛ wu bɛ.” ");
INSERT INTO asj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kwɛɛŋ wulu tuu li wuu le, “Ŋkɛmi yɛ nyuŋ kɛ.” Jiso se tee li wuu le, “Ɔ teeɔ chɛɛŋ si ɔ tee le ɔ kɛmi yɛ nyuŋ kɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ɔ kɛmɔ buniŋ bɛtiinu, wu ɔ nuuŋ bɛ wu dɛɛni nuuŋ yɛ mɔɔ wa kɛ. Fiee fi ɔ tee fiɛɛ chɛɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kwɛɛŋ wulu tee li Jiso le, “Baa, mi ŋɛŋgɔɔ dɛɛni le ɛ wɛ ntomfɔŋ. ");
INSERT INTO asj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bɛte taa bɛsɛŋ tɛ̀ shiiŋ be lɛki Nyɔ li ŋkumɛ wuni, beŋ Bɛjuu se kweŋgi finɛ le bɛniiŋ kɛmi le be ni be lɛki li Nyɔ-ɔ nuuŋ Jɛrosalɛŋ kwaa.” ");
INSERT INTO asj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jiso tuu li wuu le, “Kwɛɛŋ, beŋ fiee fi ntiiti fini. Mfi bɛɛɔ wu nɛ gii nɛ ni nɛ lɛki li Taa Nyɔ nuuŋ yɛ li ŋkumɛ wuni mɔɔ nuuŋ Jɛrosalɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Beŋ bɛniiŋ bɛ Samaaria lɛki li Nyɔ-ɔ nɛ kii yɛ fiee fi nɛ lɛki li fi-i kɛ, bee Bɛjuu tɛ lɛki li Nyɔ-ɔ, tɛ kii wi wu tɛ lɛki lu, kifɛ kinsofu kɛti nuuŋ li Bɛjuu li. ");
INSERT INTO asj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Se nuuŋ le, mfi bɛɛɔ, wu se bɛɛɔ kituŋ wu bɛniiŋ bɛ lɛki li Nyɔ-ɔ chɛɛŋ chɛɛŋ gii be ni be lɛki li Taa Nyɔ li fiana-a bɛ li chɛɛŋ li. Baaŋ ŋwaani bɛniiŋ bɛ Taa Nyɔ wɛki le be ni be lɛki li wuu. ");
INSERT INTO asj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyɔ nuuŋ Fiana, bɛniiŋ bɛ lɛki li yi-i se kɛmi le be ni be lɛki li yi-i li fiana bɛ li chɛɛŋ li.” ");
INSERT INTO asj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kwɛɛŋ wulu se tee li Jiso le, “Ŋkiiɔ le Kinsofu ki Nyɔ tɛ̀ kaachɛ bɛɛ kɛɛ, ki bɛ teenyi le Krai. Mfi wu ki naa ki bɛ, ki gii ki naanyɛ biee bichu li bee li.” ");
INSERT INTO asj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jiso tee li wuu le, “Mi wu n'yeti li wɛ-ɛ wuni ɛ mi ki.” ");
INSERT INTO asj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nɛɛ li mfi wulu, bɔɔŋ bɛ Jiso bɛ kintutu-u tuu karisi be bɛɛ. Bimfimu wondɛ be le yetɔɔ bɛ kwɛɛŋ. Se nuuŋ le, wu be wumu ti mɛɛŋ ki bii kɛ li wu-u laa, wɛki la le, kɛ laa Jiso yeti bee kwɛɛŋ wulu kii la le? ");
INSERT INTO asj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kwɛɛŋ wulu se shɛ shaŋ ye yi dzɔɔ fe, kaari gɛɛŋ fɛ kitoŋ, gɛɛŋ tee li bɛniiŋ li le, ");
INSERT INTO asj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Bɛ yɛɛŋ nɛ ŋɛŋ wumu wu bee tee mi fiee fichu fi ntɛ̀ nsaa mi mfɛ. Wi wuni nuuŋ bo Kinsofu ki Nyɔ tɛ̀ kaachɛ kilu ni?” ");
INSERT INTO asj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bɛniiŋ bo li kitoŋ kilu be bɛ fɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nuuŋ ɛ bɔɔŋ bɛ kintutu-u bɛ Jiso-o tɛ shɛ be lɛki Jiso be tiiti li wuu le, “Labai, ji fiee.” ");
INSERT INTO asj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Se nuuŋ le, Jiso tɛ̀ tuu li bee le, “Ŋkɛmɔɔ biee bijɛ bi ŋgii nji nɛ se kii yɛ bi kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bɔɔŋ bee bɛ kintutu-u se ta maa li yi yi bee laa, “Wumu bee shɛ wu bɛ bɛ biee bijɛ wu nyɛ wu ni?” ");
INSERT INTO asj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jiso se tee li bee le, “Bijɛ bieŋ nuuŋ le mfɛ fiee fi wi wu toŋ mi wɛki, mɔɔ le mɛɛshi nimɛ chee chichu. ");
INSERT INTO asj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mɔɔ nɛ tee baa finɛ le shɛɔ kii nɛɛ, le mfi wu ŋ'wechɛ bɛ nɛɛ ni? Ntee beŋ le, tsaaki yɛɛŋ lii liwe nɛ bichɛ nɛ ŋɛŋ si biee yɛri biɛɛ li wɛ le bɛ weri. ");
INSERT INTO asj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wi wu wechi kɛmi kinsomfu kee, banchi bijinɛ giki li ntsɛ wu kimakɛ, wi wu ntɔyɛ bee wi wu ŋ'wechɛ se gii be ni be nɛki li fiee fi mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Fini tiifi le ŋgaŋgaa chini nuuŋ chɛɛŋ chi tiiti le, ‘Wumu ti tɔyi, wumu se weri.’ ");
INSERT INTO asj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi ntoŋɔ beŋ le nɛ gɛɛŋ nɛ ni nɛ wechi biee bi nɛ ti mɛɛŋ ki niŋ kɛ. Bɛniiŋ bamu tɛ̀ niŋ, nɛ se lɛ baa li bujɔŋ bu nimɛ chi bee.” ");
INSERT INTO asj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bɛniiŋ bɛ Samaaria ŋge li kitoŋ kilu tɛ̀ gɛɛ shéŋ li Jiso kii fiee fi kwɛɛŋ wulu tɛ̀ tee li bee le Jiso bee tee fiee fichu li wuu fi tɛ̀ saa wu fɛ. ");
INSERT INTO asj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bɛdɛɛni, fɛ be tɛ̀ bɛ be ŋɛŋ Jiso, be lɛkɛ le tsi bee be. Se beŋ, bee be tsi jo faa. ");
INSERT INTO asj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bɛniiŋ ŋge tuu be gɛɛ shéŋ li Jiso-o kii tefɛ chee. ");
INSERT INTO asj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bɛniiŋ bɛlu se tee li kwɛɛŋ wɛ-ɛ le, “Tɛ gɛɛ baa shéŋ li wuu nuuŋ yɛ kii n'yɔru wa kɛ. Tɛ woo baa bɛ bintooŋ bisɛŋ, tɛ se kɛɛ le wi wuni wɛ Kinsofu ki nshɛ yini chɛɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jo yi faa yilu ka, Jiso dza giiŋgi Galilii. ");
INSERT INTO asj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wu kibɛɛ tɛ nuuŋ ɛ wu saa wu tee le bɛ ti guundi yɛ ntomfɔŋ wu Nyɔ li kwɛɛŋ we-e li kɛ. ");
INSERT INTO asj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Le gɛɛŋ fɛsi Galilii, bɛniiŋ bɛ fe fii wu kifɛ be tɛ̀ ŋɛŋ biee bi tɛ fɛ fɛ tsɔnɔ-ɔ Jɛrosalɛŋ kifɛ be tɛ̀ nuuŋ tɛ fɛ tsɔnɔ chilu. ");
INSERT INTO asj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jiso tɛ̀ tuu kaari gɛɛŋ Kana wu kimbɛ ki Galilii fɛ tɛ̀ fiiki dzɔɔ yi to mbiiŋ fɛɛ. Tɛ̀ nuuŋ ɛ wi wu nyɔŋa wumu tɛ̀ nuuŋ li kitoŋ ki Kapanu-uŋ, ŋwani wu nyuŋ gendi. ");
INSERT INTO asj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Le wi wu nyɔŋa wulu woo le Jiso bee dza Judiya wu bɛ Galilii, se gɛɛŋ fɛ wu-u, sooŋ bɔ li wuu le bɔɔ bɛ wonchɛ ŋwani, le wɛ lɛ kwe wa. ");
INSERT INTO asj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jiso se tee li wuu le, “Fuki fɛ nɛ ŋɛŋ biee bi doonchi bunɔŋa bu Nyɔ-ɔ, bɛ bintɛ wa bi biee siŋ, nɛ tɛ gɛɛ shéŋ li mi-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wi wu nyɔŋa wulu tee li wuu le, “Baa, bɛ nɛɛ tɛ ni tɛ beki, ŋwanɛŋ ni kwi.” ");
INSERT INTO asj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jiso tuu li wuu le, “Ɔ giiŋgi, ŋwana gii tɛmi.” Wi wulu tɛ̀ beŋ fiee fi Jiso tee li wuu, biee dza giiŋgi. ");
INSERT INTO asj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Si tɛ̀ beki lɛ, bee bɔɔŋ bee bɛ nimɛ bikɛ, be tee wuu le ŋwani tɛmɔɔ. ");
INSERT INTO asj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Se tuu bii li bee mfi wu be bɛchi ntɛɛmɛ. Be se tee li wuu le, “Tuu nuuŋ mfo si jobɛ kikaa kimumkpaŋ lɛ fɛnshaaŋ li, kiŋkɛŋkɛ kilu chinɛ li wu-u.” ");
INSERT INTO asj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Te ŋwaŋ wulu se tuu kimi le ɛ nɛɛ mfi wulu wu Jiso tuu tee li wu-u le, “Ŋwana gii tɛmi.” Wu mɔɔ yih ye chichi gɛɛ shéŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Fiiŋ fiee fi doonchi bunɔŋa bu Jiso-o fi kiŋga kifɛ fi tɛ̀ fɛ mfi wu tɛ̀ dza Judiya bɛɛ Galilii. ");
INSERT INTO asj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lɛjiŋ lɛlu tsɔnɔ chi Bɛjuu lɛ chimu tɛ̀ nuuŋ Jɛrosalɛŋ, Jiso se yɛɛ fe. ");
INSERT INTO asj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kitoo ki dzɔɔ lɛ kimu tɛ̀ nuuŋ fe bɛ teenyi lɛ jɛ́ yi Hiburu le Bɛsaida, ki tɛ̀ nuuŋ li Fweeŋ wu Mbaŋ wu Nshɔ́ɔŋ li lichiŋ. Ɛ bɛ tɛ̀ gwaŋ biji fe bitiinu, ");
INSERT INTO asj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","bɛniiŋ bɛ chigɔ-ɔŋ tɛ̀ turi fe ŋgɔɔkwe-e be, binyɛɛ, bɛ biŋkɛrɛ mɔɔ bɛ ŋgwɛ kɔɔ be. Be tɛ̀ shiiŋ be gimi fe be tɛŋgi mfi wu dzɔɔ gii naa yi dza yi ni yi sɛɛsi. ");
INSERT INTO asj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nchindaa wu Taa wumu tɛ̀ shiiŋ bɛɛ fe li mfi-i li mfi-i, lii sɛɛsi dzɔɔ yilu. Wi wu ŋkosi wu saa wu lɛ le mfi wu nchindaa wulu sɛɛsɛ dzɔɔ yilu, kɛ mwɛ gii tɛmi li chigɔŋ chee li mɔɔ chi nuuŋ niŋ le. ");
INSERT INTO asj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wi wumu tɛ̀ nuuŋ fe ɛ wu gɔŋ biya mbaanshɛɛ ntsɔ nyaaŋ. ");
INSERT INTO asj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Le Jiso bɛ fe ŋɛŋ wu, kɛɛ le mwɛ tɛ̀ gimi fe lindɛɛri, se bii li wuu laa, “Ɔ kɔŋgisi le ɔ tɛmi ni?” ");
INSERT INTO asj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wi wu tɛ̀ gendi wulu se tuu le, “Baa, ŋkɛmi yɛ wi wu nuuŋ lii mi li dzɔɔ yini li mfi wu yi sɛɛsi-i kɛ. Bɛɛ fɛ nuuŋ mfi wu yi sɛɛsi, ɛ ŋgiiŋgi le nlɛ lu, nuuŋ ɛ wumu saa wu lɛ.” ");
INSERT INTO asj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jiso tee li wu-u le, “Dzatsɛ we, dzɔɔ kiga ko, ɔ ni ɔ ŋgiiŋgi!” ");
INSERT INTO asj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mfwaa mumkpaŋ, wi wulu se biee tɛmi, dzɔ kiga kee giiŋgi. Boo yɛlu tɛ̀ nuuŋ jobɛ chi bɛshiinshi. ");
INSERT INTO asj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bɛjuu se tee li wi wu bɛ tɛ̀ wɔnchɛ wɛɛ le, “Bɛŋ yaa jobɛ chi bɛshiinshi chi nchi mɛɛŋ ki beŋ kɛ le ɔ too kiga ko kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tuu li bee le, “Wi wu bee wɔnchɛ mi bee tee le ndzɔɔ kiga keŋ ni ŋgiiŋgi.” ");
INSERT INTO asj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Be bii li wuu laa, “Ɛ noo wu bee tee li wɛ-ɛ le ɔ dzɔɔ kiga ko ɔ gɛɛŋ?” ");
INSERT INTO asj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wi wu bɛ bee bɛ wɔnchɛ wulu tɛ̀ kii yɛ mɔɔ wi wu tɛ̀ wɔnchɛ wu kɛ, kifɛ Jiso tɛ̀ dza kituŋ gɛɛŋ lɛ li kintutu ki bɛniiŋ lɛ ki tɛ̀ nuuŋ fe. ");
INSERT INTO asj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Le ni nuuŋ lɛjiŋ lɛlu, Jiso se ŋɛŋ wi wulu fɛ yih yi muntofi-i, tee li wuu le, “Bichɛ ɔ ŋɛŋ si ɔ tɛmi kituŋ. Kiiŋ ɔ ni tuu ɔ fɛ biee bibifi kɛ. Ɔɔ tuu ɔ fɛ lɛ, kɛ fiee fi gii fi nuuŋ bɛ wɛ gii fi bee fi yaa fini.” ");
INSERT INTO asj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wi wulu dza gɛɛŋ tee li Bɛjuu li le ɛ Jiso wu bee wɔnchɛ wu. ");
INSERT INTO asj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bɛjuu se bɛchi be biindi bikaa lɛ Jiso jiŋ, kifɛ tɛ̀ wɔnchɛ wi wulu nuuŋ jobɛ chi bɛshiinshi. ");
INSERT INTO asj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jiso tee li bee le, “Baa wɛŋ ti nindi mfi kwi, nse nindi nɛɛ tɛ lɛ.” ");
INSERT INTO asj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","N'yɔru wuni fɛ Bɛjuu mɛɛshi be waaŋ dzé chichi yi nuuŋ be wo wu, kifɛ tɛ̀ mɛɛŋ ki ba kɛ nchi wuni wu tɛ̀ bondɛ kwaa kɛ. Tɛ̀ teenyi tɛ Nyɔ le Tee, fichini yi yee le nuuŋ yɛɛŋ bɛ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jiso dza tee li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le mi Ŋwaŋ, nnuuŋ ntɛ̀ fɛ fiee li buŋga bu bwe-eŋ kɛ. Nti mfeti nuuŋ fiee fi ŋiŋgi Baa wɛŋ feti. Fiee fi Baa wu Ŋwaŋ feti, ɛ nɛɛ fi fi Ŋwaŋ nuuŋ fɛ tɛ, ");
INSERT INTO asj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","kifɛ Baa wu Ŋwaŋ wulu kɔŋgisi Ŋwani se doonchi Ŋwaŋ biee bichu bi wu wu Baa wu Ŋwaŋ feti. Se gii tuu doonchɛ biee bi yɛki bini li wuu, ni feti nɛ ŋiŋgi, bimfimu ni bi wondini beŋ. ");
INSERT INTO asj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Si Baa wu Ŋwaŋ busi bɛniiŋ li kwe-e nyɛɛ ntsɛ li bee lɛ, ɛ lɛ si Ŋwaŋ nyɛ tɛ̀ ntsɛ mɔɔ nuuŋ li noo wu kɔŋgisi le. ");
INSERT INTO asj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Li ntawu fe-e nuuŋ le, Baa wu Ŋwaŋ ti sɛki yɛ wumu kɛ. Wu nyɛɔ nsawu kwikwi nuuŋ li tsaŋ yi Ŋwani-i, ");
INSERT INTO asj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","le bɛniiŋ bɛchu se ni be guundi Ŋwaŋ nɛɛ yɛɛŋ si be guundi Baa we. Ɛ wi guundi yɛ Ŋwaŋ kɛ, kɛ mwɛ guundi yɛ Baa we wu toŋ wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ntee beŋ chɛɛŋ chɛɛŋ le wi wu woo jɛ yɛŋ, wu beŋ li wi wu toŋ mi-i, kɛ mwɛ kɛmɔɔ ntsɛ wu kimakɛ. Mwɛ mɛɛŋ yɛ tuu kɛmi nsa kɛ. Wɛɛ wi boɔ li tsaŋ yi kwe-e kituŋ, wu lɛ li ntsɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ntee beŋ chɛɛŋ chɛɛŋ le mfi bɛɛɔ, wu se bɛɛɔ kituŋ wu bɛniiŋ bɛ tɛ̀ kwiyɛ gii be woo jɛ yi Ŋwanɛ Nyɔ, ke be woo be kɛmɛ ntsɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fi se fiɛɛ lɛ, kifɛ si ntsɛ dzɛti li Baa wu Ŋwa-aŋ, ɛ lɛ si wu nyɛɔ buŋga li Ŋwa-aŋ le ntsɛ ni dzɛti tɛ nuuŋ li Ŋwaŋ wulu-u. ");
INSERT INTO asj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wu nyɛɔ tɛ buŋga li Ŋwa-aŋ le ni sondini bɛnsa, kifɛ ɛ Ŋwaŋ wulu wu nuuŋ Ŋwanɛwi. ");
INSERT INTO asj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kiiŋ bimfimu ni bi wondini beŋ li fini kɛ. Mfi bɛɛɔ wu bɛniiŋ bɛchu bɛ nuuŋ lɛ dzíŋ gii be woo jɛ ye, ");
INSERT INTO asj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","be se bochɛ lɛ dzíŋ yilu-u, bɛ tɛ̀ feti biee bi dzeeŋ be bo be lɛ li ntsɛ wu kimakɛ, bɛniiŋ bɛ tɛ̀ feti biee bibifi baa bɛ saa be, be we nsa. ");
INSERT INTO asj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Fiee nuuŋ yɛ lu fi nuuŋ mfɛ li buŋga bwe-eŋ kɛ. Nsɛki nsa mbiki si ŋ'wuki, dze yi nsondini le nuuŋ yi tsaaŋ, kifɛ ŋ'wɛki yɛ le ni mfeti nuuŋ fiee fi ŋkɔŋgisi kɛ. Mfeti nuuŋ fiee fi wi wu toŋ mi kɔŋgisi. ");
INSERT INTO asj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ɛ nlemi lɛjiŋ lɛ nsa wɛ-ɛŋ, kɛ fiee fi ntiiti kɔchini-i kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Se nuuŋ le, wi wɛ lu wu lemi lɛ nsa wɛ-ɛŋ lɛjiŋ, ŋkii nɛɛ le fiee fi tiiti kii mi nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nɛ tɛ̀ toŋ bɛniiŋ lɛ Jɔɔŋ li, gɛɛŋ leŋ lɛjiŋ lɛ nsa kii chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Fi nuuŋ yɛ le ŋkɔŋgisɔɔ le wiwoŋ ni tiiti wi wu nuuŋ mi kɛ. Se nuuŋ le, n'yetɔɔ ni le nɛ se kɛmɛ kinsofu. ");
INSERT INTO asj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔɔŋ tɛ̀ nuuŋ si kiŋ'wofu ki bɛ tɔŋ ki duti ki nyɛɛ kiŋ'wofu, nɛ se kɔɔŋgi le nɛ ni nɛ nuuŋ li kiŋ'wofu kee li, li mfi niiŋ li, nɛ nɛki. ");
INSERT INTO asj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Fiee fimu fiɛɛ lu fi doonchi wi wu nnuuŋ fi yɛki Jɔɔŋ. Fi nuuŋ le, nimɛ chi Baa wɛŋ nyɛ le niŋ mɛɛshi chini, ɛ biee bi mfeti bini, bi doonchi le ɛ Baa wɛŋ wu toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Baa wɛŋ wu toŋ mi ɛ wu kibɛɛ wu lemi tɛ lɛ nsa wɛ-ɛŋ lɛjiŋ. Nɛ mɛɛŋ baa saa ki woo kɛ jɛ ye kɛ, nɛ se mɛɛŋ baa saa ki ŋɛŋ kɛ tɛ si nuuŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nɛ kɛmi yɛ tɛ jɛ ye li shéŋ yinɛ kɛ, kifɛ nɛ mɛɛŋ baa ki gɛɛ kɛ shéŋ yinɛ li wi wu wu toŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nɛ tɛɛti baa Kiŋwaati ki Nyɔ-ɔ kifɛ nɛ beechi le ɛ le lɛ nɛ nuuŋ nɛ kɛmɛ fiee fi gii fi fɛ nɛ se kɛmɛ ntsɛ wu kimakɛ. Fiee fi nuuŋ lɛ Kiŋwaati kini, fi tiiti fiɛɛ nuuŋ kii mi. ");
INSERT INTO asj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Se nuuŋ le, nɛ se tuu baa nɛ fɛŋgi mbɛ lɛ mi-i le nɛ kɛmɛ ntsɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ŋwɛki yɛ mpiaru wu buti li wiwo-oŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Se nuuŋ le ŋkiiɔ beŋ. Ŋkii nɛɛ le nɛ kɛmi yɛ kiŋkɔŋgisɛ ki Nyɔ-ɔ li shéŋ yinɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi mbɛɛɔ li bukooŋ bu Baa wɛ-ɛŋ, nɛ mɛɛŋ ki fii mi kɛ. Bee le bɛ nuuŋ wi wumu wu bɛ li bukooŋ bwee li, kɛ wɛɛ wi wu bee nuuŋ nɛ fi. ");
INSERT INTO asj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɛ gii nɛ geeŋ nɛ se beŋ li mi-i, fɛ nɛ wɛki baa nuuŋ mpiaru wu dzɛti fɛ yi yinɛ, nɛ wɛkiyɛ mpiaru wu dzɛti fɛ Nyɔ yi nuuŋ yi kwaa kɛ. ");
INSERT INTO asj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kiiŋ nɛ ni nɛ beechi le ɛ mi wu ŋgii naa ntɔchɛ biŋge binɛ bibifi li Baa wɛ-ɛŋ li kɛ. Ɛ Mɔɔsɛ wu nɛ leeki bufii li wu-u, wu tɔchɔɔ biŋge bini li Baa wɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ɛ nɛ tɛ̀ beŋ li Mɔɔsɛ chɛɛŋ chɛɛŋ, nɛ se beŋ tɛ li mi-i, kifɛ tɛ̀ tsɛɛ kii mi. ");
INSERT INTO asj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Se nuuŋ le si nɛ mɛɛŋ mɔɔ ki beŋ kɛ li biee bi tɛ̀ tsɛki kɛ, nɛ gii nɛ geeŋ nɛ se beŋ li fiee fi ntiiti?” ");
INSERT INTO asj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lɛjiŋ lɛlu, Jiso dza gɛɛŋ lenchi Libɛ chi Galilii, gɛɛŋ luwiŋ lɔɔ. Libɛ chini bɛ teenyi chi le chi Tibɛria. ");
INSERT INTO asj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kintutu ki bɛniiŋ lɛ banchɛ lɛ wu jiŋ kifɛ be tɛ̀ ŋɛŋ biee bi doonchi bunɔŋa bwee bi tɛ̀ gii feti li bɛniiŋ bɛ chigɔŋ si tɛ̀ wɔnchi be. ");
INSERT INTO asj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jiso bee bɔɔŋ bee bɛ kintutu-u dza be yɛɛ be gɛɛŋ be shee li ŋkumɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tɛ nuuŋ li mfi wulu Tsɔnɔ chi Bɛjuu lɛ chi N'yafuwee tɛ̀ nuuŋ tsɛkɛtsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jiso dza lɔŋ lii, ŋɛŋ si kintutu ki bɛniiŋ lɛ bɛɛ lɛ wuu, bii li Fili laa, “Tɛ gii tɛ geeŋ tɛ se go bijɛ le bɛniiŋ bani ji?” ");
INSERT INTO asj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tɛ̀ gii biiti lɛ, mɔnchi Fili bu mɔnchɛ kifɛ wu kibɛɛ tɛ̀ kii fiee fi gii fɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fili tuu li wuu le, “Bɛnchuki gii fɛɛ nuuŋ tɛ kɔchɛ wu bɛ nuuŋ bɛ go bijɛ bi wi mumkpaŋ mumkpaŋ nuuŋ kɛmɛ niiŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ŋwani wu kintutu wumu wu bukooŋ bwee tɛ̀ nuuŋ le Andolo wu tɛ̀ nuuŋ ŋwaani Simu Pita se tee li wu-u le, ");
INSERT INTO asj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ŋwaŋ wu nyuŋ wumu wɛ fɛni bɛ tsée yi bibele bitiinu bɛ nsúuŋ fiɛɛtu, se nuuŋ le fini nuuŋ fi ge la bɛ kintutu ki bani bɛniiŋ ŋge ni?” ");
INSERT INTO asj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jiso se tee le, “Tee yɛɛŋ li bɛniiŋ bɛlu le be shee yɛ fɛkwiiŋ.” Kitɔɔ gii ki nuuŋ fe ŋge, be tee le be shee yɛ, buniŋ kwaa tɛ̀ nuuŋ si bɛnchuki bɛtiinu. ");
INSERT INTO asj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jiso se fi tsée yi bibele yɛɛ, nyɛ kiyɔɔni li Nyɔ-ɔ, gachɛ li bɛniiŋ bɛ tɛ̀ shee yɛ baa li. Tuu fɛ tɛ lɛ bɛ nsúuŋ yɛɛ. Wi kwikwi tɛ̀ kɛmɛ si mwɛ tɛ̀ kɔŋgisi. ");
INSERT INTO asj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Be tɛ̀ ji be fukɛ, tee li bɔɔŋ bee bɛ kintutu-u le, “Banchɛ yɛɛŋ biŋkɛ bilu kiiŋ fiee fimu ni la li yee li kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bɛdɛɛni, be banchɛ biŋkɛ bi tsée yi bibele bi bitiinu bi tɛ̀ shɛ biɛɛ, bi yisɛ bɛŋkaa yoofi ntsɔ bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Le bɛniiŋ bɛlu ŋɛŋ fiee fi doonchi bunɔŋa bwee fi tɛ̀ fɛ fini, be tee le, “Wi wuni gbɛŋgɔɔ nuuŋ Ntomfɔŋ wu Nyɔ chɛɛŋ wu tɛ̀ nuuŋ le gii bɛ li nshɛ yini wɛ.” ");
INSERT INTO asj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Le Jiso ŋɛŋ le bɛniiŋ bɛlu wɛki baa le be kɔɔ wu bɛ buŋga be kokɛ wu li Mfɔŋ wu bee, cheekiyi kaari miri li ŋkumɛ-ɛ nuuŋ fe wuu mbiiŋ. ");
INSERT INTO asj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Le ni nuuŋ lɛ fɛmfo-o, bɔɔŋ bee bɛ kintutu-u bɔɔ be gɛɛŋ fɛ libɛ-ɛ, ");
INSERT INTO asj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","be lɛ lɛ ŋgo-o be bɛchi be lenchi be giiŋgi Kapanuŋ. Li mfi wɛɛ, lɛkuuŋ tɛ̀ jiŋ kituŋ Jiso mɛɛŋ ki bɛ kɛ fɛ be tɛ nuuŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dzɔɔ bɛchi yi duŋgi, kifɛ mfiee yi tɛɛmi tɛ̀ gii yi kɛti. ");
INSERT INTO asj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Be tɛ̀ kundi ŋgo be lenchi, le be gɛɛŋ be bo nɛɛ si bɛma bɛtɛɛtu kɛ bɛnɛɛ, be dza be ŋɛŋ Jiso si deŋgi li dzɔɔ li liwe bɛɛ li ŋgo-o lichiŋ. Jaaŋ kɔɔ be. ");
INSERT INTO asj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Se nuuŋ le, tɛ̀ tee li bee le, “Kiiŋ nɛ ni nɛ chɛndi kɛ. Ɛ mi.” ");
INSERT INTO asj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Le be woo lɛ, be kɔɔŋgi le be dzɔ wu lɛ ŋgo-o. Le be dza, be taa be ŋɛŋ ɛ ŋgo fɛsi kituŋ li ŋgemɛ yi dzɔɔ li fɛ be tɛ̀ giiŋgi. ");
INSERT INTO asj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Le butuu bo bu woo, bɛniiŋ bɛ tɛ̀ shɛ li libɛ luwiŋ baa kimi le ɛ ŋgo mumkpaŋ wu tuu nuuŋ fe, se Jiso ti mɛɛŋ ki lɛ lɛ ŋgo-o bɛ bɔɔŋ bee bɛ kintutu-u kɛ, bɔɔŋ bee bɛ kintutu-u dza be gɛɛŋ be bɛ mbiiŋ. ");
INSERT INTO asj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Se nuuŋ le, bɛŋgo bamu tɛ̀ dza kimbɛ ki Tibɛria, be lenchi be bɛ fɛ kintsii ki bɛniiŋ tɛ̀ ji kibele ki Taa tɛ̀ dzɔ nyɛ kiyɔɔni li Nyɔ-ɔ kɛɛ lichiŋ. ");
INSERT INTO asj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Si bɛniiŋ bɛlu tɛ̀ ŋɛŋ le Jiso tɛ̀ nuuŋ yɛ fe kɛ lɛ, kɛ bɔɔŋ bee bɛ kintutu-u, be lɛ be bɔɔ lɛ bɛŋgo bɛlu, be lenchi be gɛɛŋ Kapanuŋ le be gɛɛŋ be gɔɔŋ Jiso. ");
INSERT INTO asj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Le be gɛɛŋ be ŋɛŋ wu luwiŋ lɔɔ, be bii li wuu laa, “Labi, ɔ bɛ fɛni mfi wu la?” ");
INSERT INTO asj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jiso tuu li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le nɛ wɛki yɛ mi nuuŋ kii biee bi doonchi bunɔŋa bweŋ bi nɛ ŋɛŋ mfeti kɛ. Nɛ wɛki mi nuuŋ kifɛ nɛ tuu nɛ ji tsée yi bi bibele biɛɛ nɛ fukɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kiiŋ nɛ ni nɛ nindi le nɛ kɛmɛ nuuŋ bijinɛ bi nuuŋ bi bee kɛ. Nimɛ yɛɛŋ nuuŋ le nɛ kɛmɛ bijinɛ bi nuuŋ bi ba bi ni bi nuuŋ lu gɛɛŋ bo bu ntsɛ wu kimakɛ-ɛ. Bini nuuŋ biee bi Ŋwanɛwi gii nyɛ li be-eŋ. Ɛ wu, wu Nyɔ yi Baa we gɛɛɔ ŋkiki we li wuu le fi doonchɛ le wu beŋɔ wu.” ");
INSERT INTO asj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Be se bii li wuu laa, “Biee bi tɛ̀ kɛmi le tɛ ni tɛ feti bi se nuuŋ le tɛ feti baa nimɛ chi Nyɔ nuuŋ bi la?” ");
INSERT INTO asj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jiso tuu li bee le, “nimɛ chi Nyɔ chɛɛ chini, nɛ gɛɛ shéŋ li wi wu wu to-oŋ.” ");
INSERT INTO asj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bɛdɛɛni be tuu be bii li wuu laa, “Fiee fi doonchi bunɔŋa bwo fi ɔ nuuŋ ɔ fɛ, le tɛ ŋɛŋ se tɛ tuu tɛ̀ gɛɛ shéŋ li wɛ-ɛ nuuŋ la? Fiee fi ɔ nuuŋ ɔ fɛ nuuŋ fi la? ");
INSERT INTO asj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bɛtaa bɛsɛŋ tɛ̀ ji mana li buka, fi se nuuŋ si bɛ tsɛɛ le, ‘Tɛ̀ nyɛ be bijinɛ bi dzɛti liboo be ji.’” ");
INSERT INTO asj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Le be tee lɛ, Jiso se tuu tee li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le tɛ̀ nuuŋ yɛ Mɔɔsɛ wu tɛ̀ nyɛ beŋ bijinɛ bi dzɛti liboo kɛ. Ɛ Baa wɛŋ wu nyɛɛ bijinɛ bi chɛɛŋ bi dzɛti liboo. ");
INSERT INTO asj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nɛ ni nɛ kii le bijinɛ bi Nyɔ-ɔ nuuŋ bi shiiti liboo bi nyɛɛ ntsɛ li bɛniiŋ bɛ li nshɛ yini-i.” ");
INSERT INTO asj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Be se tee li wuu le, “Taa, ɔ nyɛɛ bee bijinɛ bini mfi kwi.” ");
INSERT INTO asj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jiso se tee li bee le, “Ɛ mi bijinɛ bilu bi nyɛɛ ntsɛ. Wi wu bɛɛ lɛ mi mwɛ mɛɛŋ yɛ woo dzeeŋ kɛ. Wi wu gɛɛ shéŋ li mi-i, ndɔɔŋ we nuuŋ tɛ naa wondɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Se nuuŋ le mi nteeɔ beŋ le nɛ ŋɛŋ baa mi, nɛ faaŋ ŋgɛɛwu shéŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bɛniiŋ bɛchu bɛ Baa wɛŋ nyɛ li mi-i, be gii be ni be bɛɛ lɛ mi-i. Wi wu bɛɛ lɛ mi nuuŋ ntɛ̀ ŋkooŋ bɛ mwɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kifɛ mi dza liboo mi mbɛ laaŋkwiiŋ. Mɛɛŋ ki mbɛ kɛ le mfɛ nuuŋ fiee fi ŋkɔŋgisi kɛ. Mi mbɛ le mfɛ nuuŋ fiee fi wi wu toŋ mi Kɔŋgisi ");
INSERT INTO asj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Se fiee fi wi wu toŋ mi kɔŋgisi nuuŋ fini le, kiiŋ ni nlɛɛ mɔɔ nuuŋ wi mumkpaŋ li bɛniiŋ bɛ wu nyɛ li mi-i kɛ, se nuuŋ le ke naa mbuu be li kwe-e li jobɛ chi kimɛrisɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nɛ kɛɛ le fiee fi Baa wɛŋ kɔŋgisi nuuŋ fini, le wi kwikwi wu ŋɛŋ Ŋwani, wu gɛɛ shéŋ li wu-u, gii kɛmɛ ntsɛ wu kimakɛ, ŋgii nse mbuu mwɛ tɛ li kwe-e li jobɛ chi kimɛrisɛ.” ");
INSERT INTO asj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bɛjuu se bɛchi be ŋuŋini kii wu, kifɛ tɛ̀ tee le, ɛ wu bijinɛ bi dza liboo bi bɛ laaŋkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Be tɛ̀ ŋuŋini be biiti laa, “Wuni nuuŋ nɛɛ Jiso wu ŋwanɛ Jɔsɛ ni? Wu tɛ̀ kii nɛɛ tee bee ni ni? Fi geeŋ dɛɛni fi kweŋgi le wu dza nuuŋ liboo?” ");
INSERT INTO asj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jiso se tuu li bee le, “Kiiŋ nɛ ni nɛ ŋuŋini beŋ beŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wi nuuŋ tɛ bɛ lɛ mi-i, fuki fɛ Baa wɛŋ wu toŋ mi chee mwɛ le bɛ nsiŋ kɛ. Ŋgii mbuu mwɛ tɛ li kwe-e li jobɛ chi kimɛrisɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛɛ le, ‘Nyɔ gii yi tifi be bɛchu.’ Bɛdɛɛni wi kwikwi wu woo fiee fi Baa wɛŋ tiifi wu kɛɛ, gii bɛ lɛ mi-i. ");
INSERT INTO asj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ntiiti yɛ ni le wi wɛ lu wu saa wu ŋɛŋ Baa wɛŋ kɛ. Ɛ nɛɛ wu wɛ wu dza fɛ Nyɔ-ɔ kwaa wu saa wu ŋɛŋ Baa we. ");
INSERT INTO asj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ntee beŋ chɛɛŋ chɛɛŋ le, wi wu beŋ kɛmɔɔ ntsɛ wu kimakɛ kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɛ mi bijinɛ bi nyɛɛ ntsɛ li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bɛchaa bɛnɛ tɛ̀ ji mana libuka, se nuuŋ le be kwiyɛ nɛɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bijinɛ bini nuuŋ bi dza liboo bi bɛ le, ɛ wi ji bi tɛ kwi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɛ mi wu nuuŋ bijinɛ bi dzɛti liboo bi nyɛɛ ntsɛ li bɛniiŋ li. Ɛ wi ji bijinɛ bini, mwɛ ba ni nuuŋ lu mfi kwikwi. Se bijinɛ bi ŋgii nyɛ li bɛniiŋ bɛ li nshɛ-ɛ le be kɛmɛ ntsɛ bini nuuŋ yi yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bɛjuu se bɛchi be waanini be be, be biiti laa, “Wi wuni gii geeŋ se nyɛ yi yee le tɛɛbeŋ se ji le?” ");
INSERT INTO asj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jiso se kweeŋ li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le ɛ nɛ mɛɛŋ ki ji yi yi Ŋwanɛwi kɛ, ŋ'wonu mɔɔ ŋgɔŋ mee nsiŋ, nɛ tɛ kɛmɛ ntsɛ li yi yi nɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wi wu jii nyaŋ yɛɛŋ wu tuu wu woŋ ŋgɔŋ meŋ kɛmɔɔ ntsɛ wu kimakɛ. Ŋgii naa mbuu wu li kwe-e jobɛ chi kimɛrisɛ, ");
INSERT INTO asj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","kifɛ nyaŋ yɛɛŋ gbɛŋgi yi nuuŋ nɛɛ bijinɛ, se ŋgɔŋ meŋ gbɛŋgi me nuuŋ fiee fi wonɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wi wu ji nyaŋ yɛɛŋ tuu wundi ŋgɔŋ meŋ tsiiŋɔ li yi yɛɛŋ ntsiiŋ tɛ li yi yee li. ");
INSERT INTO asj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baa wɛŋ wu toŋ mi kɛmi ntsɛ, nse ŋkɛmi ntsɛ kii Baa wɛŋ. Bɛdɛɛni wi wu jii nyaŋ yɛɛŋ gii kɛmɛ tɛ ntsɛ kii mi. ");
INSERT INTO asj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bijinɛ bini nuuŋ bi dza liboo bi bɛ. Bi nuuŋ yɛ si bi bɛchaa tɛ̀ ji be tuu be kwiyɛ biɛɛ kɛ. Wi wu jii bijinɛ bini gii ba ni nuuŋ lu mfi kwi.” ");
INSERT INTO asj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Biee bini nuuŋ bi Jiso tɛ̀ tiiti mfi wu tɛ̀ tiifi bɛniiŋ li yih yi nlɛkɛ li Nyɔ-ɔ Kapanuŋ. ");
INSERT INTO asj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Le bɛniiŋ bɛ Jiso-o bɛ kintutu ŋge woo ntiifɛ wuni ni be tee le, “Wuni n'yɔru tɛmɔɔ ŋge! Ɛ noo wu nuuŋ beŋ wuni n'yɔru?” ");
INSERT INTO asj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jiso kɛɛ le bɛniiŋ bee bɛ kintutu-u ŋuŋini baa bebe kii n'yɔru wulu, biee bii li bee laa, “Fiee fi mi n'yɔ fini sɛɛsɛ shéŋ yinɛ ni? ");
INSERT INTO asj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ɛ fi nuuŋ lɛ, nɛ gii nɛ geeŋ mfi wu nɛ ŋɛŋ Ŋwanɛwi wu karisi yɛki fɛ tɛ̀ saa nuuŋ ŋkosi? ");
INSERT INTO asj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Fiana yi Nyɔ nuuŋ fiee fi nyɛɛ ntsɛ. Nyaŋ yi bwiŋ kɛmi yɛ fiee fi yi gii kɛ. Tefɛ chi mi n'yɔ li be-eŋ nuuŋ Fiana, tuu nuuŋ ntsɛ. ");
INSERT INTO asj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Se nuuŋ le beŋ bamu baa lu bɛ mɛɛŋ ki beeŋ tefɛ chilu kɛ.” Jiso tɛ̀ yeti ni kifɛ tɛ̀ kii kituŋ fɛ mbɛɛchɛ bɛniiŋ bɛ mɛɛŋ ki gɛɛ kɛ shéŋ li wu-u kɛ, kii tɛ wi wu gii kabɛ wu. ");
INSERT INTO asj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tuu tee li bee le, “Ɛ nɛɛ fiee fi mbee nsaa mi ntee kituŋ li be-eŋ le, nuuŋ wi tɛ bɛ li mi-i fuki fɛ Baa wɛŋ nyɛ dze li wu siŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lɛjiŋ lɛlu, bɛniiŋ bee bɛ kintutu kinɔŋa se tuu be gooŋ lijiŋ, be faaŋ ndɛndɛ bɛ wu. ");
INSERT INTO asj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jiso se dza bii li bɔɔŋ bee bɛ kintutu-u bɛ yoofi ntsɔ bɛfɛ baa laa, “Beŋ tɛ nɛ kɔŋgisi le nɛ gɛɛŋ ni?” ");
INSERT INTO asj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simu Pita tuu li wuu le, “Taa, tɛ giiŋgi lɛ noo li. Ɛ wɛ wu kɛmi n'yɔru wu nyɛɛ ntsɛ wu kimakɛ, ");
INSERT INTO asj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","tɛ beŋ tɛ tuu tɛ kii le ɛ wɛ wi wu Wuuti wu dza fɛ Nyɔ wɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jiso tee li bee le, “Ɛ nɛɛ mi wu ntsaa beŋ bɛ yoofi ntsɔ bɛfɛ bani ni? Se nuuŋ le, wumu li be-eŋ linti wɛ kiŋkundi.” ");
INSERT INTO asj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jiso tɛ̀ tiiti lɛ nuuŋ kii Judas wu ŋwanɛ Simu Iskaliyɔ. Tɛ̀ nuuŋ li kintutu ki bɔɔŋ bee bɛ yoofi ntsɔ bɛfɛ baa, se tɛ gii nuuŋ wu, wu tɛ̀ nuuŋ le gii dɛndɛ kabɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lɛjiŋ lɛlu Jiso ba tuu deŋgi nɛɛ nuuŋ kimbɛ ki Galilii. Tɛ̀ mɛɛŋ ki tuu kɛ le gɛɛŋ Judiya kɛ, kifɛ Bɛjuu tɛ̀ wɛki le be wo wu. ");
INSERT INTO asj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mfi wu Tsɔnɔ chi Bɛjuu lɛ chi be tɛ̀ teenyi le Tsɔnɔ chi Bigɔɔnu-u tɛ̀ bɛɛ tsɛkɛtsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bɛŋwaani Jiso se tee li wuu le, “Dzatsɛ fɛni ɔ gɛɛŋ Judiya ke bɛniiŋ bo bɛ kintutu-u se ŋɛŋ nimɛ chi ɔ nindi. ");
INSERT INTO asj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɛ wi nindi nimɛ wɛki le bɛniiŋ kɛɛ wu, tɛ tuu le ni nindi nyimi bu nyimɛ kɛ. Si ɔ feti biee bini ni, gɛnɛ ɔ doonchɛ yi ya li kwɛɛŋ li.” ");
INSERT INTO asj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bɛŋwaani bɛlu tɛ̀ tiiti lɛ kifɛ be tɛ mɛɛŋ mɔɔ ki gɛɛ kɛ fibee shéŋ li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jiso se tuu li bee le, “Mfi wɛŋ mɛɛŋɔ saa ki kɔchɛ kɛ. Li be-eŋ, mfi wunɛ wɛ ɛ wu kɔchɛ kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bɛniiŋ bɛ li nshɛ yini nuuŋ tɛ baanɛ beŋ kɛ. Se nuuŋ le, be baanini baa mi kifɛ ntiitɔɔ li bee le biŋge bi bee biɛɛ bibifi. ");
INSERT INTO asj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yɛɛ yɛɛŋ finɛ nɛ gɛɛŋ fɛ Tsɔnɔ-ɔ. Nuuŋ ntɛ n'yɛɛ fe kɛ, kifɛ mfi wɛŋ mɛɛŋɔ saa ki bɛ kɛ le kɔchɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Si tɛ̀ tee lɛ, shɛ fiee Galilii. ");
INSERT INTO asj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Se nuuŋ le, mfi wu bɛŋwaani tɛ̀ yɛɛ fɛ Tsɔnɔ chilu-u, se shɛ yɛɛ tɛ fe. Si tɛ̀ yɛki lɛ, tɛ̀ mɛɛŋ ki yɛɛ kɛ le bɛniiŋ ni be ŋiŋgi wu kɛ, tɛ̀ yɛɛ fiee nuuŋ lɛ munyiikɔɔ li. ");
INSERT INTO asj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tɛ̀ nuuŋ ɛ Bɛjuu tɛ̀ bɛchi be wɛki wu fɛ Tsɔnɔ chilu-u be biiti laa, “Gbɛŋgi nuuŋ fɛŋ le?” ");
INSERT INTO asj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bɛniiŋ dza be tuu be tsuundi kii wu ŋge. Bamu se piɛti le, “Ɛ wu wi wu dzeeŋ.” Bamu kaasi yi le, “Yɛŋgi bɛ bɛniiŋ bu yɛŋu.” ");
INSERT INTO asj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Se nuuŋ le wi tɛ̀ nuuŋ yɛ lu wu tiiti kii wu gbanaa kɛ, kifɛ be tɛ̀ chɛndi bikoo bi Bɛjuu lɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Le jo yi tsɔnɔ tuu yi gatɛ kintikinti, Jiso se gɛɛŋ lɛ li yih yi muntofi-i bɛchi tiifi bɛniiŋ. ");
INSERT INTO asj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Le bikoo bi Bɛjuu lɛ tuu bi woo be kɛmɛ chɛnɛ, be tamaa laa, “Wi wuni geeŋ wu kii biee ni, nlaanchɛ wuu saa wu laanchɛ Kiŋwaati ki Nyɔ-ɔ nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jiso se tuu dza tee le, “Ntiifɛ wu ntiifi wuni nuuŋ yɛ wɛŋ kɛ. Ɛ wu wi wu toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɛ wi wɛki le ni feti nuuŋ fiee fi Nyɔ kɔŋgisi, mwɛ gii kɛɛ laa ntiifɛ wuni dzɛti nuuŋ fɛ Nyɔ-ɔ, mɔɔ ntiifi li buŋga bweŋ le. ");
INSERT INTO asj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wi wu yeti li buŋga bwee li ti wɛki bukooŋ bu nɔŋa nuuŋ li yi yee li. Se nuuŋ le, wi wu wɛki bukooŋ bu nɔŋa nuuŋ bu wi wu toŋ wu ti nuuŋ wi wu chɛɛŋ, binsɛɛ se tɛ nuuŋ li yi yee li kɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mɔɔsɛ tɛ mɛɛŋ ki nyɛ kɛ bɛnchi li be-eŋ ni? Se nuuŋ le, wi wumu nuuŋ yɛ li be-eŋ linti wu kichi bɛnchi bɛlu kɛ! Nɛ wɛki le nɛ wo mi kii la?” ");
INSERT INTO asj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bɛniiŋ bɛlu se tuu li wuu le, “Ɔ kɛmɔɔ bɛnchindaa bɛ Kiŋkundi-i li wɛ-ɛ bwiŋ. Wi wu wɛki le wo wɛ nuuŋ noo?” ");
INSERT INTO asj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jiso se tee li bee le, “Ntɛ̀ mfɛ nimɛ chimumkpaŋ, nɛ tɛwa li chi-i. ");
INSERT INTO asj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mɔɔsɛ tɛ̀ nyɛ nchi le nɛ ni nɛ sɛɛti dzoo. Ɛ nchi wuni tɛ̀ butiyɛ mɔɔ li Mɔɔsɛ-ɛ kɛ. Tɛ̀ bo nuuŋ li bɛchaa bɛnɛ. Nɛ se biee nɛ sɛɛti bɔɔŋ dzoo mɔɔ nuuŋ jobɛ chi bɛshiinshi. ");
INSERT INTO asj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ɛ bɛ ti sɛɛti wi dzoo jobɛ chi bɛshiinshi kii bɛ ni biifi nchi wu Mɔɔsɛ, nɛ se lochi bɛ mi le ntuu mfɛ wi wu tɛmi jobɛ chi bɛshiinshi ni? ");
INSERT INTO asj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kiiŋ nɛ ni nɛ sɛki nsa nɛ sondini ntawu le lɛnti le nɛ ŋɛŋ nsiŋ kɛ. Nɛ sɛki lɛ dze yi tsaaŋ li.” ");
INSERT INTO asj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bɛniiŋ bɛ Jɛrosalɛŋ bamu se tuu be dza be biiti laa, “Wuni nuuŋ nɛɛ wi wu bɛ wɛki le bɛ wo wɛ ni? ");
INSERT INTO asj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bichɛ yɛɛŋ nɛ ŋɛŋ wuuŋ wu fɛni, yetɔɔ gbanaa, wi ntusu fiee li wuu nsiŋ. Fi nuuŋ le bikoo bi kwɛɛŋ lɛ bee bi kɛɛ le wi wuni nuuŋ nɛɛ Kinsofu ki Nyɔ tɛ̀ kaachɛ ni? ");
INSERT INTO asj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Se nuuŋ le, tɛ̀ kii baa fɛ wi wuni dza fe. Mfi wu Kinsofu ki Nyɔ tɛ̀ kaachɛ gii ki bɛ nuuŋ wi tɛ naa kɛɛ fɛ ki dza fe kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Se nuuŋ le Jiso tuu tifi bɛniiŋ li yih yi muntofi-i, dzɛŋgi lɛwe ŋge le, “Nɛ kii baa mi, nɛ kii tɛ fɛ mi dza fe? Se nuuŋ le, mɛɛŋɔ ki mbɛ kɛ fɛni li buŋga bwe-eŋ kɛ. Wi wu toŋ mi nuuŋ wi wu chɛɛŋ, nɛ se kii yɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ŋkiiɔ wu kifɛ ntɛ̀ ndza fɛ wu-u, ɛ wu wu se tɛ toŋ mi.” ");
INSERT INTO asj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Si tɛ̀ yɔ lɛ, bɛniiŋ bamu se tuu be wɛki le be kɔɔ wu. Se nuuŋ le, wi tɛ̀ mɛɛŋ ki ko-oŋ li wuu kɛ, kifɛ mfi we tɛ mɛɛŋ ki kɔchɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Se nuuŋ le, bɛniiŋ bɛ ŋge se gɛɛ shéŋ li wuu be tuu be biiti laa, “Mfi wu Kinsofu ki Nyɔ tɛ̀ kaachɛ naa bɛɛ lɔɔ, ki gii naa ki fɛ biee bi doonchi bunɔŋa bu Nyɔ-ɔ yɛki bi wi wuni fɛ kituŋ bini ni?” ");
INSERT INTO asj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Le Bɛfarasii tuu be woo si kintutu ki bɛniiŋ lɛ tsuundi kii Jiso, bɛte muntofi bɛ nɔŋa bɛ nɔŋa toŋ bɛniiŋ bɛ nchi-i le be gɛɛŋ be kɔɔ wu. ");
INSERT INTO asj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Le be gɛɛŋ, Jiso se tee le, “Ŋgii nuuŋ tɛɛbeŋ nɛɛ li mfi niiŋ li, se ntuu ŋkaari nto lijiŋ fɛ wi wu tɛ toŋ mi-i. ");
INSERT INTO asj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɛ gii nɛ shɛ nɛ gɔɔŋ mi ni, nɛ tɛ ŋɛŋ mi kɛ. Fɛ ŋgiiŋgi nuuŋ nɛ tɛ naa bɛ fe kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bɛjuu yɔ li yih yi bee laa, “Wi wuni wɛki le gɛɛŋ nuuŋ fɛŋ fɛ tɛɛbeŋ gii tɛ naa tɛ gɔɔŋ wu, tɛ tɛ̀ ŋɛŋ wu kɛ? Wɛki le gɛɛŋ li bitoŋ bi bɛniiŋ bɛsɛŋ tɛ̀ saaŋgɛ be gɛɛŋ be tsiiŋ le gɛɛŋ ni tiifi bɛniiŋ bɛ bitoŋ bilu ni? ");
INSERT INTO asj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Fiee fi tiiti le, ‘Nɛ gii naa nɛ gɔɔŋ mi nɛ tɛ ŋɛŋ mi kɛ, mɔɔ fɛ ŋgiiŋgi nuuŋ nɛ tɛ naa le nɛ bɛ fe kɛ,’ tiiti lɛ fi nuuŋ le la?” ");
INSERT INTO asj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tɛ nuuŋ jobɛ chi Tsɔnɔ chi kimɛrisɛ-ɛ chi tɛ̀ nuuŋ jobɛ chi Tsɔnɔ-ɔ chilu chi nɔŋa, Jiso dza leŋ we dzaŋ lɛwe ŋge le, “Ɛ ndɔɔŋ wondɛ li wi-i, mwɛ bɛ fɛ mi-i woŋ fiee. ");
INSERT INTO asj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wi wu gɛɛ shéŋ li mi-i mwɛ gii ni nuuŋ nɛ si Kiŋwaati ki Nyɔ-ɔ ki tiiti le, ‘Dzɔɔ yi nyɛɛ ntsɛ gii naa yi ni yi buti li shéŋ yee li yi beki ni kukukuku.’” ");
INSERT INTO asj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Fini nuuŋ fiee fi Jiso tɛ̀ tiiti nuuŋ kii Fiana yi bɛniiŋ bɛ tɛ̀ gɛɛ shéŋ li wuu gii naa be kɛmɛ. Tɛ̀ nuuŋ li mfi wuni bɛ mɛɛŋ saa ki nyɛɛ Fiana yilu li bee kɛ, kifɛ Jiso tɛ̀ nuuŋ bɛ mɛɛŋ saa ki yɛɛki kɛ wu le lɛ li bunɔŋa bwee li kɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bɛniiŋ woo fiee fi Jiso tɛ̀ tee fini, bamu tee le, “Wi wuni gbɛŋgɔɔ nuuŋ Ntomfɔŋ wu Nyɔ-ɔ wɛ.” ");
INSERT INTO asj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bamu tee le, “Wuni nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ.” Se nuuŋ le, bamu bii fibee laa, “Kinsofu ki Nyɔ tɛ̀ kaachɛ tɛ kɛmi le ki bo nuuŋ Galilii ni? ");
INSERT INTO asj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mɔɔ Kiŋwaati ki Nyɔ-ɔ tee nɛɛ le Kinsofu kilu gii naa ki bo tɛ nuuŋ lɛ kini ki Mfɔŋ Daafi-i, li kitoŋ ki Bɛtɛlɛhɛŋ, ki nuuŋ kitoŋ ki Daafi-i ni?” ");
INSERT INTO asj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Si bɛniiŋ tɛ̀ tee lɛ, buga se biee bu bɛ lɛ bee lɛnti kii Jiso. ");
INSERT INTO asj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bɛniiŋ bamu se tuu be wɛki le be kɔɔ wu, bɛdɛɛni, wi se ti mɛɛŋ ki koŋ li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bɛniiŋ bɛ nchi-i baa dza be kaari be to lijiŋ fɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ Bɛfarasii baa, be se bii li bɛniiŋ bɛ nchi-i bɛlu laa, “Nɛ mɛɛŋ ki bɛ kɛ bɛ wu kɛ kii la?” ");
INSERT INTO asj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bɛniiŋ bɛ nchi-i bɛlu se tuu li bee le, “Wi mɛɛŋɔ saa kɛ le ni yeti si wi wuni kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bɛfarasii bii li bee laa, “Wu gɛɛŋɔ tɛ wu yɛɛŋ mɔɔ bɛ beŋ tɛ ni? ");
INSERT INTO asj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nɛ ŋɛŋ bikoo bi kwɛɛŋ lɛ, kɛ Bɛfarasii be gɛɛ shéŋ li wu ni? ");
INSERT INTO asj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɛ kintutu kini kwaa ki kii yɛ nchi wu Nyɔ-ɔ kɛ. Bubiɛɛ bwɛɛ fɛ be fa.” ");
INSERT INTO asj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛmu wu tɛ̀ nuuŋ wi wu kintutu ki Bɛfarasii, wu tɛ̀ gɛɛŋ jobɛ chimu ŋɛŋ Jiso wɛ tɛ̀ nuuŋ fe. Bii li bee laa, ");
INSERT INTO asj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nchi wusɛŋ beŋɔ le bɛ sondɛ nsa wu wi fuki fɛ bɛ saa bɛ yikɛ bɛ woo fiee fi wu kweeŋ nsiŋ ni?” ");
INSERT INTO asj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Be se bii li wuu laa, “Ɔ dza tɛ Galilii ni? Bichɛ lɛ Kiŋwaati ki Nyɔ-ɔ bujɔŋ ɔ gii ɔ ŋɛŋ le, nuuŋ ntomfɔŋ wu Nyɔ-ɔ wumu tɛ̀ naa bo Galilii kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Be dza mumkpaŋ mumkpaŋ be giiŋgi li bɛla bɛ bee. ");
INSERT INTO asj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jiso dza yɛɛ fiee nuuŋ li Ŋkumɛ wu Biti bi Oli-if. ");
INSERT INTO asj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Butuu bo bu woo, se tuu kaari gɛɛŋ fɛ yih yi muntofi-i. Bɛniiŋ bɛchu banchɛ li wuu lichiŋ, se shee fɛkwiiŋ tiifi be. ");
INSERT INTO asj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bɛniiŋ bɛ tiifi bɛnchi mɔɔ Bɛfarasii dza be bɛ bɛ kwɛɛŋ wumu ɛ bɛ tɛ̀ kɔɔ wu gimi bɛ nyumɛ wumu. Si be tɛ̀ bɛ bɛ wu lɛ, be leeki wu limfwe, ");
INSERT INTO asj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","be tee li Jiso-o le, “Wi wu ntiifɛ, kwɛɛŋ wuni wɛ ɛ bɛ kɔɔ wu gimi bɛ nyumɛ wumu. ");
INSERT INTO asj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lɛ bɛnchi-i, Mɔɔsɛ tɛ̀ tee le wuni kwɛɛŋ bɛ gii bɛ tomɛ wu bɛ ta butomɛ kwi. Ɔ tee fio le la?” ");
INSERT INTO asj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Be tɛ̀ feti lɛ be teeki Jiso bu teekɛ le fiimfɛ bɛ jɛ be se kɛmɛ fiee fi be gii be kɔɔ wu li fi-i. Se nuuŋ le, Jiso tɛ guumɛ tsɛki fiee fɛkwiiŋ bɛ kwaŋ. ");
INSERT INTO asj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Be ba nɛɛ be lemi fe be fieŋgisi wu. Se dza leŋ we tee li bee le, “Ɛ wi nuuŋ lu li be-eŋ linti wu kɛmi yɛ bubiɛɛ kɛ, saa nuuŋ wi wu ŋkosi wu gii toŋ kwɛɛŋ wuni bɛ tɛtɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Si Jiso tɛ̀ tee lɛ, tuu kaari guumɛ tsɛki fiee fɛkwiiŋ bɛ kwaŋ. ");
INSERT INTO asj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Le be woo fiee fi Jiso tee, be bɛchi be saaŋgini mumkpaŋ mumkpaŋ mbɛɛchɛ li bɛkaaŋ li. Be saaŋgɛ, se shɛ nɛɛ kwɛɛŋ wɛ kwaa lemi fe bee Jiso. ");
INSERT INTO asj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jiso kaari leŋ we, bii li kwɛɛŋ wɛɛ laa, “Kwɛɛŋ, be fɛŋ? Wi mɛɛŋ ki nuuŋ kɛ lu wu tee le ɔ kɛmi nɛɛ le ɔ kwi kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Se tuu le, “Wi mɛɛŋɔ ki nuuŋ kɛ lu kɛ, Taa.” Jiso biee tee le, “Nuuŋ ntɛ ntee tɛ le ɔ kɛmi le ɔ kwi kɛ. Ɔ giiŋgi, bɛdɛɛni kiiŋ ɔ ni tuu ɔ fɛ bibifi kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jiso tuu kweeŋ li bɛniiŋ bɛlu-u le, “Ɛ mi kiŋ'wofu ki li nshɛ yini-i. Mɔɔ nuuŋ noo wu biki mi le, nuuŋ tɛ̀ naa le ni deŋgi li kijibɛ-ɛ kɛ. Gii ni kɛmi kiŋ'wofu ki nyɛɛ ntsɛ li bɛniiŋ li.” ");
INSERT INTO asj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bɛfarasii se tee li wuu le, “Ɔ lemɔɔ lɛ nsa lɛjiŋ kii kikoo ko. Fiee fi ɔ tiiti kɔchini yɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jiso tuu li bee le, “Mɔɔ nuuŋ le nlemɔɔ lɛjiŋ lɛ nsa-a fɛ kikoo ke-eŋ, kɛ fiee fi ntiiti kɔchini fiɛɛ, kifɛ ŋkii fɛ mi ndza fe, ŋkii tɛ fɛ ŋgiiŋgi fe. Se nuuŋ le nɛ kii yɛ fɛ mi ndza mɔɔ fɛ ŋgiiŋgi fe kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nɛ sɛki baa bɛniiŋ si bɛniiŋ bɛ bɔ. Nti nsɛki yɛ fieŋ wi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Se nuuŋ le, ɛ nuuŋ le nsɛkɔɔ wi, kɛ nsɛkɔɔ lɛ dze yi tsaaŋ li, kifɛ nsɛki yɛ mi mbiiŋ kɛ. Nsɛkɔɔ tɛɛ Baa wɛŋ wu toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lɛ kiŋwaati kinɛ ki bɛnchi-i, bɛ tsɛɛ baa le, ɛ bɛniiŋ lemi lɛ nsa jiŋ bɛfɛ, kɛ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nlemi lɛ nsa jiŋ kii kikoo keŋ, Baa wɛŋ wu toŋ mi lemi tɛ lɛ nsa wɛ-ɛŋ lɛjiŋ.” ");
INSERT INTO asj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Be se bii li wuu laa, “Baa wa nuuŋ fɛŋ?” Jiso tuu le, “Nɛ kii yɛ mi, kɛ Baa wɛŋ kɛ. Bee le nɛ ni nɛ kii mi, bee nɛ kii tɛ Baa wɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jiso tɛ̀ tiiti biee bini ɛ tɛ̀ tiifi bɛniiŋ li yih yi muntofi-i lichiŋ fɛ kintsii ki bɛ tɛ̀ shiiŋ bɛ nyɛɛ kwa fe li yih yi muntofi-i. Se nuuŋ le, wi ti mɛɛŋ wu ki kɔɔ kɛ, kifɛ mfi we ti mɛɛŋ ki kɔchɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jiso tuu tee li bee le, “Ŋgiiŋgɔɔ, nɛ gii nɛ shɛ nɛ gɔɔŋ mi nɛ kwiyɛ li bibifi binɛ-ɛ. Fɛ ŋgiiŋgi fe, nuuŋ nɛ tɛ bɛ fe kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bɛjuu se bii laa, “Gii wo yi yee ni, se tiiti le fɛ giiŋgi nuuŋ tɛɛbeŋ tɛ tɛ̀ bɛ fe kɛ?” ");
INSERT INTO asj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jiso tee li bee le, “Nɛ dza laaŋkwiiŋ, mi dza fieŋ liboo. Nɛ nuuŋ bɛniiŋ bɛ li kwɛɛŋ wuni-i. Nnuuŋ yɛ wi wu li kwɛɛŋ wuni-i kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mi nteeɔ beŋ le nɛ gii nɛ kwiyɛ li bibifi binɛ-ɛ linti. Nɛ kɛɛ le nɛ gii nɛ kwiyɛ li bibifi binɛ-ɛ fɛ nɛ mɛɛŋ ki beŋ kɛ le ɛ mi wulu kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Be se bii li wuu laa, “Ɛ wɛ noo?” Jiso tuu le, “Nnuuŋ wi wu ntuu tiiti kii wu li be-eŋ fɛ mbɛɛchɛ wɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ŋkɛmɔɔ biee ŋge bi nuuŋ ntee kii beŋ mɔɔ biee ŋge bi nuuŋ nsaa beŋ lu. Se nuuŋ le, nnuuŋ ntɛ mfɛ lɛ kɛ, wi wu toŋ mi, nuuŋ wi wu chɛɛŋ. Fiee fi ntiiti li nshɛ yini-i nuuŋ fi mi ŋ'woo li wuu.” ");
INSERT INTO asj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Si tɛ̀ tee lɛ, be ti mɛɛŋ ki kɛɛ kɛ le tiiti li bee nuuŋ kii Baa we kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nɛɛ lɛ, Jiso se tee li bee le, “Mfi wu nɛ shiŋɛ Ŋwanɛwi liwe, nɛ se kɛɛ le ɛ mi wulu, mɔɔ le mfeti yɛ fiee fimu li buŋga bwe-eŋ kɛ, le ntiiti ni nuuŋ si Baa wɛŋ tifi mi. ");
INSERT INTO asj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wi wu toŋ mi wɛ bɛ mi. Mɛɛŋɔ ki chinɛ kɛ mi le ni nuuŋ mi mbiiŋ kɛ, kifɛ nti mfeti biee mfi kwi nuuŋ bi dzeeŋ fɛ wu-u.” ");
INSERT INTO asj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Si Jiso tɛ̀ tee biee bini ni, bɛniiŋ ŋge gɛɛ shéŋ li wu-u. ");
INSERT INTO asj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jiso se tee nuuŋ li Bɛjuu bɛ tɛ̀ gɛɛ shéŋ li wuu le, “Ɛ nɛ ba nɛ lemi li jɛ yɛ-ɛŋ, nɛ ni nɛ nuuŋ bɛniiŋ beŋ bɛ chɛɛŋ bɛ kintutu-u, ");
INSERT INTO asj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","nɛ gii nɛ kɛɛ chɛɛŋ, chɛɛŋ wulu wu se fɛ nɛ bo li bumfa-a.” ");
INSERT INTO asj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Be tuu li wuu le, “Tɛ nuuŋ kini ki Abraha-aŋ, tɛ ti mɛɛŋ baa mɔɔ saa ki nuuŋ kɛ bɛmfa li tsaŋ yi wumu-u kɛ. Fi geeŋ fi ɔ tuu tiiti le tɛ gii tɛ bo li bumfa-a?” ");
INSERT INTO asj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jiso tuu li bee le, “Ntiitɔɔ beŋ chɛɛŋ chɛɛŋ le wi kwikwi wu feti bibifi nuuŋ mfwa wu bibifi. ");
INSERT INTO asj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mfwa nuuŋ tɛ ba le ni nuuŋ ŋwanɛ yih yi nuuŋ lu mfi kwi kɛ. Ɛ ŋwanɛ yih kwaa wu ti bɛɛ ba ŋwanɛ yih mfi kwi. ");
INSERT INTO asj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bɛdɛɛni, ɛ Ŋwaŋ buu beŋ li bumfa-a, kɛ nɛ gbɛɛŋ baa nɛ bo li buu chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋkiiɔ nɛɛ le nɛ nuuŋ kini ki Abraha-aŋ, se nuuŋ le, nɛ wɛki baa nɛɛ le nɛ wo mi kifɛ jɛ yɛŋ kɛmi yɛ kintsii li yi yinɛ-ɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ntiitɔɔ nuuŋ fiee fi ŋiŋgi li Baa wɛ-ɛŋ, nɛ se feti finɛ tɛ nuuŋ fiee fi nɛ woo li chaa wunɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Be se tuu li wuu le, “Baa wusɛŋ nuuŋ Abrahaŋ.” Jiso tee li bee le, “Ɛ nɛ tɛ̀ nuuŋ bɔɔŋ bɛ Abraha-aŋ, kɛ bee nuuŋ nɛ feti fiee fi Abrahaŋ tɛ̀ feti. ");
INSERT INTO asj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nnuuŋ wi wu teeɔ beŋ chɛɛŋ wu mi ŋ'woo li Nyɔ-ɔ. Se nuuŋ le, nɛ se wɛki baa le nɛ wo mi dɛɛni, fini nuuŋ yɛ fiee fi Abrahaŋ tɛ̀ feti kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nɛ feti baa nuuŋ fiee fi baa wunɛ feti.” Be tee li wuu le, “Tɛ̀ nuuŋ yɛ bɔɔŋ bɛ bɛ biɛ kwiiŋ kɛ. Tɛ kɛmi Baa wusɛŋ mumkpaŋ, wu nuuŋ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jiso tee li bee le, “Ɛ Nyɔ bee yi nuuŋ baa wunɛ, bee nɛ kɔŋgisi mi, kifɛ mi ndza nuuŋ fɛ Nyɔ-ɔ mi nse mbɛ. Mɛɛŋɔ ki mbɛ kɛ fɛni li buŋga bwe-eŋ kɛ. Ɛ yi yi toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Fi geeŋ fi nɛ mɛɛŋ ki woo kɛ fiee fi ntiiti kɛ? Fi fiɛɛ nɛɛ kifɛ nɛ kɔŋgisi yɛ le nɛ woo jɛ yɛŋ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nɛ nuuŋ bɔɔŋ bɛ chaa wunɛ wu Kiŋkundi-i, fiee fi nɛ kɔŋgisi nuuŋ le nɛ fɛ fiee fi chaa wunɛ wɛki. Tɛ̀ nuuŋ wi wu woyi bɛniiŋ fɛ mbɛɛchɛ. Kɛmi yɛ fiee fi fɛrɛ bɛ chɛɛŋ kɛ, kifɛ chɛɛŋ nuuŋ yɛ li wuu kɛ dududu. Mfi wu yɛŋgi binsɛɛ tiiti nɛɛ si kiŋge kee ti nuuŋ, kifɛ ti nuuŋ wi wu binsɛɛ tuu nuuŋ te binsɛɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Se nuuŋ le, ntiitɔɔ fieŋ nuuŋ chɛɛŋ, fiɛɛ fiee fi nɛ mɛɛŋ baa ki beŋ kɛ mi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ɛ noo li be-eŋ linti wu nuuŋ doonchɛ bibifi bi mi mfɛ? Si fiee fi ntiiti li be-eŋ nuuŋ chɛɛŋ, fi ge la fi nɛ mɛɛŋ ki beŋ kɛ mi kɛ? ");
INSERT INTO asj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wi wu nuuŋ wi wu Nyɔ ti wuki jɛ yi Nyɔ. Fiee fi nɛ ti wuki yɛ jɛ yi Nyɔ nuuŋ kifɛ nɛ nuuŋ yɛ bɛniiŋ bɛ Nyɔ-ɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bɛjuu se tee li Jiso le, “Tɛ bee tɛ mɛɛŋ ki tee kɛ chɛɛŋ le ɔ nuuŋ wi wu Samaaria bɔɔŋ bɛ Kiŋkundi-i se nuuŋ li wɛ-ɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jiso tuu li bee le, “Nchindaa wu Kiŋkundi nuuŋ yɛ li mi-i kɛ. Ŋguundi fieŋ nuuŋ Baa wɛŋ, bɛdɛɛni nɛ se guundi yɛ mi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Fi nuuŋ yɛ le ŋ'wɛkɔɔ bukooŋ bu nɔŋa li yi yɛŋ. Wi wɛ lu mumkpaŋ wu wɛki bu, ɛ wu wu sondini bɛnsa. ");
INSERT INTO asj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ntiitɔɔ beŋ chɛɛŋ chɛɛŋ le ɛ wi wuki jɛ yɛɛŋ, tɛ naa woo kintsi ki kwe-e kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bɛjuu tee li wuu le, “Tɛ kɛɛ baa dɛɛni le bɔɔŋ bɛ Kiŋkundi-i baa li wɛ-ɛ. Abrahaŋ tɛ̀ kwi, bɛntomfɔŋ bɛ Nyɔ-ɔ kwiyɛ tɛ, ɔ se kweŋgi le wi wu wuki jɛ ya, tɛ naa woo kintsi ki kwe-e kɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ɔ yɛki taa wusɛŋ wu Abrahaŋ wu tɛ̀ kwi, ɔ yɛki bɛntomfɔŋ bɛ Nyɔ-ɔ bɛ tɛ̀ kwiyɛ tɛ ni? Ɔ gbɛŋgi ɔ beechi le ɔ nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jiso tuu le, “Ɛ ntsakisi yi yɛɛŋ, kɛ fi fiɛɛ nuuŋ yee. Ɛ Baa wɛŋ wu tsakisi mi, se nuuŋ wu wu nɛ kweŋgi le ɛ wu Nyɔ-ɔ yinɛ. ");
INSERT INTO asj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Se nuuŋ le, nɛ kii yɛ yi kɛ. Ɛ nɛɛ mi kwaa wu ŋkii yi. Ɛ mi ndza mi ntee le ŋkii yɛ yi kɛ, kɛ mi wɛ nuuŋ wi wu binsɛɛ si beŋ. Se nuuŋ le, si fi nuuŋ ni, ŋkii yi, ŋ'wuki jɛ ye. ");
INSERT INTO asj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baa wunɛ wu Abrahaŋ tɛ̀ nɛki le gii ŋɛŋ jo yɛŋ. Tɛ̀ ŋɛŋ, se nɛɛtɛ.” ");
INSERT INTO asj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bɛjuu se dzakɛ be bɛchi be tiiti le, “Ɔ mɛɛŋɔ ki bo kɛ biya mbaanshiŋ kɛ, ɔ se tiiti le ɔ tɛ̀ ŋɛŋ Abrahaŋ ni?” ");
INSERT INTO asj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jiso tuu li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le, fɛ Abrahaŋ tɛ̀ nuuŋ, nnuuŋ.” ");
INSERT INTO asj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Le be woo lɛ, be se kwachɛ ta le be tomɛ Jiso lu. Jiso wɛŋ bo li yih yi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Le Jiso tuu dza ni deŋgi, ŋɛŋ nyuŋ wumu ɛ bɛ tɛ̀ biɛ wu nuuŋ kinyɛɛ. ");
INSERT INTO asj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bɔɔŋ bee bɛ kintutu-u bii li wuu laa, “Labai, ɛ noo wu tɛ̀ fɛ bubiɛɛ wi wuni se nuuŋ kinyɛɛ? Ɛ wu wu tɛ̀ fɛ, mɔɔ tee bee ni le?” ");
INSERT INTO asj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jiso se tuu li bee le, “Fi nuuŋ yɛ le wi wuni tɛ̀ fɛ bubiɛɛ kɛ ni bee tee kɛ. Bɛ tɛ̀ biɛ wu lɛ le nimɛ chi Nyɔ-ɔ doonchɛ yi yi chi li wuu bwiŋ. ");
INSERT INTO asj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tɛɛbeŋ kɛmi le tɛ niŋ nimɛ chi wi wu toŋ mi mɛɛŋ fɛnshaaŋ. Kijibɛ bɛɛ kɛɛ nuuŋ mfi wu wi nuuŋ tɛ niŋ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ŋgɛnu mbochu mɔɔ nuuŋ li mfi wu la le si nuuŋ si li nshɛ yini-i, ɛ mi kiŋ'wofu ki li nshɛ yini-i.” ");
INSERT INTO asj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Si Jiso tɛ̀ yɔ n'yɔru wuni ni, kwiyɛ budii fɛkwiiŋ, tɔ bɛ nshɛ kusɛ wi wulu li lii, ");
INSERT INTO asj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","se tee li wuu le, “Gɛnɛ ɔ tsootsɛ lɛ Kindundu ki Siloŋ.” (Bukooŋ bu Siloŋ nuuŋ le, “Bɛ toŋ.”) Se gɛɛŋ tsootsɛ, kaarisi bɛɛ ŋiŋgi biee kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bɛniiŋ bɛ tɛ̀ tsiiŋ li wuu lichiŋ mɔɔ bɛniiŋ bɛ tɛ̀ shiiŋ be ŋiŋgi wu si wi wu munlɛɛkɔɔ be tɛ̀ tamaa laa, “Wuni nuuŋ nɛɛ wi wu tuu shiiŋ shiiti lɛki biee wɛ nɛɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bamu tɛ̀ tiiti le, “Ɛ wu.” Bamu le, “Aay, bosinɔɔ bu bosinɛ.” Wi wulu kibɛɛ se tee le, “Ɛ mi wulu.” ");
INSERT INTO asj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Se nuuŋ le, be se bii li wu laa, “Lii ya se geeŋ yi gwiyɛ?” ");
INSERT INTO asj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tuu le, “Wi wu bɛ teenyi le Jiso bee wu tɔ nshɛ wu kusɛ mi li lii li, wu tee li mi-i le, ŋgɛɛŋ ntsootsɛ lɛ dzɔɔ yi Silo-oŋ. Mi nse ŋgɛɛŋ mi ntsootsɛ, lii yɛɛŋ se gwiyɛ.” ");
INSERT INTO asj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Be bii li wuu laa, “Nuuŋ fɛŋ?” Se tuu le, “Ŋkii yɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Be tɛ̀ dza be dzɔ wi wu tɛ̀ shiiŋ nuuŋ kinyɛɛ wɛ, be gɛɛŋ bɛ wu fɛ Bɛfarasii. ");
INSERT INTO asj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jiso tɛ̀ tɔ nshɛ tuu gwiyɛ lii yi wi wɛ nuuŋ jobɛ chi bɛshiinshi. ");
INSERT INTO asj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bɛfarasii baa tuu be bii li wi wulu-u si fi bee fi ka lii yee se gwiyɛ. Se tee li bee le, “Bee kusɛ lii yɛŋ bɛ nshɛ, mi ŋgɛɛŋ mi ntsootsɛ mi nse mbɛchi ŋiŋgi biee.” ");
INSERT INTO asj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bɛfarasii bamu tee le, “Wi wuni mɛɛŋɔ ki dza kɛ fɛ Nyɔ-ɔ kɛ, kifɛ nindɔɔ jobɛ chi bɛshiinshi.” Bamu tee fibee le, “Ɛ nuuŋ le wi feti biee bibifi, geeŋ se ni feti ŋwaani biee bi doonchi bunɔŋa bu Nyɔ-ɔ bini?” Buga se bɛ lɛ bee lɛnti. ");
INSERT INTO asj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Be tuu be kaari be bii li wi wɛ laa, “Ɔ tee fio le la kii wi wulu si bee gwiyɛ lii ya lɛ?” Tuu le, “Wi wulu nuuŋ ntomfɔŋ wu Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bɛjuu ti mɛɛŋ ki beŋ kɛ le wi wulu tɛ̀ shiiŋ nuuŋ kinyɛɛ bɛ se gwiyɛ lii yee kɛ, be dɛndɛ be teeŋ ni bee tee, be bɛ. ");
INSERT INTO asj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Be se bii li bee laa, “Wuni nuuŋ nɛɛ ŋwanɛ nɛ wu nɛ kweŋgi le nɛ tɛ̀ biɛ wu bo kinyɛɛ wɛ ni? Fi geeŋ se tuu ŋiŋgi biee dɛɛni?” ");
INSERT INTO asj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ni bee tee tuu le, “Tɛ kii baa bujɔŋ le wuni nuuŋ ŋwanɛ sɛŋ wu tɛ tɛ̀ biɛ nuuŋ kinyɛɛ wɛ. ");
INSERT INTO asj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Se nuuŋ le, si fi dɛndɛ se ŋiŋgi biee dɛɛni, tɛ kii yɛ kɛ. Tɛ kii yɛ tɛ wi wu gwiyɛ lii yee kɛ. Bii yɛɛŋ nuuŋ li wuu. Wɛ wi wu kaaŋ, nuuŋ tee bɛ kimfimɛ kee.” ");
INSERT INTO asj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ni bee tee tɛ̀ tee lɛ kifɛ be tɛ chɛndi Bɛjuu, fi se nuuŋ le Bɛjuu tɛ̀ kɔɔ be gɛɛ le ɛ wi mɔŋ wu tee bɛ kimfimɛ kee le Jiso nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ, be kooŋ bɛ mwɛ li yih yibe yi lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Fiɛɛ fiee fi ni bee tee tɛ tiiti le, ɛ wu wi wu kaaŋ, le be bii nuuŋ li wuu. ");
INSERT INTO asj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Li kiŋga kifɛ-ɛ, be tuu be teeŋ wi wu tɛ̀ saa nuuŋ kinyɛɛ wɛ, be tee li wuu le, “Tee chɛɛŋ wa, n'yɔɔnchɛ gɛɛŋ li Nyɔ-ɔ, tɛ kii baa fisɛŋ le wi wuni nuuŋ wi wu feti bibifi.” ");
INSERT INTO asj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tuu le, “Dɛɛŋ feti bibifi lee, ŋkii yɛ kɛ. Fiee fi ŋkii fimumkpaŋ nuuŋ le ntuu nshiiŋ nnuuŋ kinyɛɛ, dɛɛni ŋŋiŋgɔɔ biee.” ");
INSERT INTO asj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Be se tuu be bii li wuu laa, “Ɛ la fi bee fɛ bɛ wɛ? Be fɛ niŋ wu se gwiyɛ lii ya?” ");
INSERT INTO asj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tuu li bee le, “Mbee nsaa mi ntee li be-eŋ, nɛ mɛɛŋ ki kɔɔŋgi kɛ le nɛ woo kɛ. Nɛ tuu wɛki le nɛ woo nuuŋ la? Nɛ wɛki le nɛ nuuŋ tɛ bɛniiŋ bee bɛ kintutu-u ni?” ");
INSERT INTO asj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Be gaashɛ wu bugaashɛ be tiiti le, “Ɛ wɛ wi we wu kintutu. Tɛ nuuŋ fisɛŋ bɛniiŋ bɛ kintutu ki Mɔɔsɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tɛ kii Mɔɔsɛ nuuŋ wi wu Nyɔ tɛ̀ shiiŋ yi tiiti biee bɛ wu. Se nuuŋ le, wi wuni, tɛ̀ kii yɛ fɛ wu bo fe kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wi wulu tuu le, “Hebee, fiiŋ fiee fi tɛɛmi! Nɛ kweŋgi le nɛ kii yɛ fɛ wi wuni bo fe kɛ ni? Se nuuŋ le wu gwiyɔɔ lii yɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nɛ ni kii le Nyɔ ti wuki yɛ nlɛkɛ wu wi wu feti bibifi kɛ. Se nuuŋ le, ɛ wi guundi li Nyɔ-ɔ feti biee bi yi kɔŋgisi, kɛ Nyɔ gii ni yi wuki nlɛkɛ li Nyɔ-ɔ we. ");
INSERT INTO asj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Si nshɛ yini tɛ̀ bɛchi bɛ mɛɛŋ baa saa ki woo kɛ le wi gwiyɔɔ lii yi wi wu bɛ tɛ̀ biɛ mwɛ nuuŋ kinyɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bee le wi wuni ni mɛɛŋ ki bo fɛ Nyɔ-ɔ kɛ, wu kɛmi yɛ buŋga bu fɛrɛ fiee kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Be tuu li wuu le, wɛ wu bɛ tɛ̀ biɛ li bibifi linti dududu, ɔ se wɛkɔɔ le ɔ tifi bee ni? Si be tɛ̀ tee lɛ, be kooŋ wu lɛ bee lɛnti. ");
INSERT INTO asj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jiso woo le be kooŋ baa bɛ wi wulu lɛ bee lɛnti, gwenɛ gɔɔŋ ŋɛŋ wu, bii li wuu laa, “Ɔ gɛɛɔ shéŋ li Ŋwanɛwi-i ni?” ");
INSERT INTO asj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Se tuu le, “Wi wulu nuuŋ noo baa wɛŋ? Tee nɛɛ mi, nse ŋgɛɛ shéŋ yɛɛŋ li wuu.” ");
INSERT INTO asj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jiso tee li wuu le, “Ɔ ŋɛŋgɔɔ wu kituŋ. Ɛ wu wɔɔ yeti nɛɛ wu dɛɛni.” ");
INSERT INTO asj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wi wulu se biee tee le, “Taa, mi ŋgɛɛɔ.” Le tee lɛ, se toŋ núŋ wu limfwe boŋ wu. ");
INSERT INTO asj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jiso se tee le, “Mi mbɛɛɔ li nshɛ yini le bɛ saa bɛniiŋ, le bɛniiŋ bɛ ŋiŋgi yɛ biee kɛ, ŋɛŋ biee, bɛniiŋ bɛ ŋiŋgi biee, to binyɛɛ.” ");
INSERT INTO asj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Le Jiso kweeŋ lɛ, Bɛfarasii bɛ tɛ̀ nuuŋ li wuu lichiŋ woo, be se bii li wuu laa, “Tɛ nuuŋ tɛ binyɛɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jiso tee li bee le, “Bee nuuŋ le nɛ nyɛɛ, bee nuuŋ tsaŋ yinɛ yi nuuŋ waaŋ li bibifi. Se nuuŋ le si nɛ kweŋgi dɛɛni le nɛ ŋiŋgi baa biee, bibifi binɛ gii bi ba bɛ beŋ.” ");
INSERT INTO asj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ntee beŋ chɛɛŋ chɛɛŋ le, ɛ wi lii lɛ mbaŋ wu nshɔ́ɔŋ li, wu nlɛ lɛ fweeŋ wu mbaŋ nsiŋ, wu tuu wu beeŋ nuuŋ li mbaŋ wu se lɛ, kɛ mwɛ wɛ wih, tuu nuuŋ wi wu lɔchi biee lɛ buŋga-a. ");
INSERT INTO asj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Se nuuŋ le wi wu nuuŋ le kiichi nshɔ́ɔŋ ti bɛɛ lii fiee nuuŋ lɛ fweeŋ wu mba-aŋ. ");
INSERT INTO asj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wɛɛ wi nuuŋ ɛ wi wu kiichi fweeŋ wu mbaŋ wulu bɛɛ gwiyi mbaŋ wulu li wuu, se lɛ teeŋ nshɔ́ɔŋ yi nuuŋ yee li bukooŋ li, yi woo jɛ ye, se dzɔ yi bo bɛ yí. ");
INSERT INTO asj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mfi wuu buu nshɔ́ɔŋ yee chichi lɛkuuŋ, se giiŋgi limfwe teenyi nshɔ́ɔŋ yilu yí biki wu, kifɛ yí kii jɛ ye. ");
INSERT INTO asj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bɛɛ ɛ nuuŋ wi wu gwe, yi tɛ biee wu kɛ. Yi kiifi wu, kifɛ yí kii yɛ jɛ yí wi wulu kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Le Jiso wa ŋgaŋgaa chini li bee ni, be tɛ mɛɛŋ ki kɛɛ kɛ fiee fi tiiti li bee lɛ ŋgaŋgaa chilu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Se nuuŋ le, Jiso se tɛ tuu tee li bee le, “Ntee beŋ chɛɛŋ chɛɛŋ le, ɛ mi wu nuuŋ fweeŋ wu mbaŋ wu nshɔ́ɔŋ kɛti le. ");
INSERT INTO asj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bɛniiŋ bɛchu bɛ tɛ̀ saa be bɛ mi limfwe nuuŋ bɛyi mɔɔ bɛniiŋ bɛ lɔchi biee lɛ buŋga-a. Se nuuŋ le, nshɔ́ɔŋ tɛ mɛɛŋ ki yikɛ fiee fi be tɛ̀ tiiti kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɛ mi fweeŋ wu mbaŋ. Ɛ wi ka li mi-i, mwɛ se lɛ, kɛ gii kɛmɛ kinsofu. Mwɛ gii ni nuuŋ si nshɔ́ɔŋ yi ti buti yi gɛɛŋ yi ji biee, yi kaari yi to lɛjiŋ yi lɛ lɛ mba-aŋ. ");
INSERT INTO asj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wih ti bɛɛ nuuŋ le yi, le wo, mɔɔ le biifi biee. Mi mbɛɛɔ fieŋ le bɛniiŋ kɛmɛ nuuŋ ntsɛ, ntsɛ wu gbɛɛŋ wu yisɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ɛ mi kiŋkiichɛ ki nshɔ́ɔŋ lɛ ki dzeeŋ. Kiŋkiichɛ ki nshɔ́ɔŋ lɛ ki dzeeŋ ti nyɛɛ ntsɛ wu ki le ki kwi kii nshɔ́ɔŋ yí ki. ");
INSERT INTO asj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wi wu bɛ dzɔ si wi wu nimɛ, wu nuuŋ yɛ kiŋkiichɛ ki nshɔ́ɔŋ lɛ kɛ, wu nshɔ́ɔŋ nuuŋ yɛ yee kɛ, bɛɛ ɛ wu ŋɛŋ mbɔɔŋku bɛɛ, tuu chinɛ li nshɔ́ɔŋ yilu kifi, mbɔɔŋku shɛ kɔɔ nshɔ́ɔŋ yimi, yimi se saaŋgɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ti kiifi kifɛ bɛ dzɔ baa wu bu dzɔtsu si wi wu nimɛ, mɛɛŋ ki kwi kɛ fiee fɛ nshɔ́ɔŋ yilu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ɛ mi kiŋkiichɛ ki nshɔ́ɔŋ lɛ ki dzeeŋ. Se nuuŋ le, ŋkii nshɔ́ɔŋ yi nuuŋ yɛŋ, nshɔ́ɔŋ yɛŋ se kii tɛ mi, ");
INSERT INTO asj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nɛɛ si Taa kii mi, nse ŋkii tɛ Taa, mi nyɛɔ ntsɛ wɛŋ le ŋkwi kii nshɔ́ɔŋ yɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ŋkɛmɔɔ nshɔ́ɔŋ yimi yi nuuŋ yɛ li kintutu kini-i kɛ. Nse ŋkɛmɔɔ le mbɛ bɛ yi tɛ, yi ni yi wuki jɛ yɛŋ, kintutu ki nshɔ́ɔŋ lɛ to kimumkpaŋ se kiŋkiichɛ ki nshɔ́ɔŋ lɛ ni ki nuuŋ kimumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mi nyɛɔ ntsɛ wɛŋ le ŋkwi, le nuuŋ nɛɛ ŋkaari mfi ntsɛ wɛŋ lɛjiŋ. Fini nuuŋ fiee fi Baa wɛŋ kɔŋgisi mi. ");
INSERT INTO asj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wi nuuŋ yɛ lu wu dzeti ntsɛ wɛŋ kɛ. Ɛ mi wu nyɛ ntsɛ wɛŋ li ŋkɔŋgisɛ wɛ-ɛŋ. Ŋkɛmɔɔ buŋga le nyɛ ntsɛ wɛŋ le ŋkwi, ŋkɛmi buŋga le ŋkaari mfi ntsɛ wɛŋ lɛjiŋ. Fiiŋ fiee fi Baa wɛŋ tee le mfɛ.” ");
INSERT INTO asj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Le Jiso tee biee bini ni, buga se ka bu bɛ li Bɛjuu li linti. ");
INSERT INTO asj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Be bɛ ŋge se tuu be tiiti le, “Kɛmɔɔ bɛnchindaa bɛ kiŋkundi-i, jetɔɔ. Nɛ yiki la li wu-u?” ");
INSERT INTO asj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Se nuuŋ le bamu se tiiti le, “Ŋwaani chini tefɛ nuuŋ yɛ chi wi wu kɛmi bɔɔŋ bɛ kiŋkundi-i kɛ. Nchindaa wu kiŋkundi nuuŋ gwiyɛ lii yi kinyɛɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tɛ̀ nuuŋ mfi wu Tsɔnɔ chimu chi nuuŋ le be kimi si be tɛ̀ kaari be gwiyɛ yih yi muntofi Jɛrosalɛŋ ");
INSERT INTO asj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jiso gɛɛŋ kanyi fɛ yih yi muntofi-i, fɛ kiji ki Salimu-u. Mfi wɛɛ tɛ̀ nuuŋ mfi wu fokpɔŋ. ");
INSERT INTO asj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bɛjuu dza be kɛnɛ wu lɛnti, be bii li wuu laa, “Ɔ gii ɔ gɛɛ bee tɛ ba li mɛŋinɛ ni nsiiŋ gɛɛŋ bo buŋ? Ɛ nuuŋ wɛ ɔ nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ, ɔ tee bee waaŋ.” ");
INSERT INTO asj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jiso se tuu li bee le, “Mi nteeɔ beŋ, nɛ mɛɛŋ ki beŋ kɛ. Niŋ yi nindi li bukooŋ bu Baa wɛŋ doonchi wi wu nuuŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Se nuuŋ le, nɛ nuuŋ tɛ beŋ kɛ, kifɛ nɛ nuuŋ yɛ li kintutu keŋ ki nshɔ́ɔŋ lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nshɔ́ɔŋ yɛŋ ti wuki jɛ yɛŋ. Ŋkii yi, yi se biki mi, ");
INSERT INTO asj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","nyɛɛ ntsɛ wu kimakɛ li yi. Yi nuuŋ tɛ naa layɛ kɛ. Wi nuuŋ yɛ lu wu nuuŋ naa lɔ yí li tsaŋ yɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baa wɛŋ wu nyɛ nshɔ́ɔŋ yilu li mi-i yɛkɔɔ wi kwi, wi nuuŋ yɛ lu, wu nuuŋ lɔ yi li tsaŋ yee li kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tɛɛ Baa wɛŋ tɛ baa fiee fimumkpaŋ.” ");
INSERT INTO asj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bɛjuu ka be kwachɛ ta le be tomɛ wu lu. ");
INSERT INTO asj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jiso se bii li bee laa, “Nɛ ŋɛŋ baa nimɛ chi dzeeŋ ŋge chi Baa wɛŋ tee le ni mfeti. Ɛ kii chi la chi nɛ wɛki le nɛ tomɛ mi kii chi?” ");
INSERT INTO asj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Be se tuu li wuu le, “Tɛ tomi yɛ wɛ nuuŋ kii nimɛ chi dzeeŋ chi ɔ fɛ kɛ. Tɛ tomi baa wɛ nuuŋ kifɛ ɔ bifisɔɔ bukooŋ bu Nyɔ-ɔ. Ɛ wɛ wiwoŋ, ɔ se tuu ɔ kweŋgi le ɔ nuuŋ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jiso tuu li bee le, “Mɔɔ bɛ tsɛɛ baa lɛ Kiŋwaati kinɛ ki bɛnchi-i, Nyɔ tiiti le, ‘Mi ntee nɛɛ le ɛ beŋ bɛnyɔ ni’? ");
INSERT INTO asj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nyɔ teenyi bɛniiŋ bɛlu le bɛnyɔ, ɛ be bɛlu bɛ jɛ ye tɛ̀ bɛɛ li bee, tɛ kii baa le fiee fi nuuŋ lɛ Kiŋwaati ki Nyɔ nuuŋ tɛ fiiki kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Si fi nuuŋ ni, ɛ kii la fi nɛ tiiti li wi wu Tee tsaa wu wu toŋ li kwɛɛŋ wuni le bifisɔɔ bukooŋ bu Nyɔ-ɔ, kifɛ wu tee kwaa le ɛ wu Ŋwanɛ Nyɔ? ");
INSERT INTO asj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ɛ mfeti yɛ nuuŋ niŋ yi Baa wɛŋ kɛ, kiiŋ nɛ ni beŋ li mi-i kɛ. ");
INSERT INTO asj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Se nuuŋ le, ɛ mfeti nuuŋ yí, ɛ nɛ mɛɛŋ ki beŋ kɛ li mi-i kɛ, nɛ beŋ li yi-i, nɛ bɔsɛyi nɛ kɛɛ le Baa wɛŋ nuuŋ li mi-i, nuuŋ tɛ li wu-u.” ");
INSERT INTO asj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bɛjuu tuu be wɛki le be kɔɔ wu, bɛdɛɛni se dimɛ li tsaŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jiso tuu gɛɛŋ lenchi to Dzɔɔ yi Joodaaŋ luwiŋ fɛ Jɔɔŋ tɛ̀ saa lisi bɛniiŋ li dzɔɔ, se nuuŋ fe. ");
INSERT INTO asj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bɛniiŋ ŋge bɛɛ be ŋiŋgi wu. Be dza be tee le, “Jɔɔŋ tɛ̀ mɛɛŋ ki fɛ kɛ fiee fimu fi doonchi bunɔŋa bu Nyɔ-ɔ kɛ. Se nuuŋ le fiee fichu fi tɛ̀ yeti kii wi wuni nuuŋ nɛɛ chɛɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bɛdɛɛni, bɛniiŋ ŋge se gɛɛ shéŋ li Jiso-o fe. ");
INSERT INTO asj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wumu wu bukooŋ bwee tɛ̀ nuuŋ le Lasɔrɔ tɛ̀ dza gendi. Tɛ̀ nuuŋ wi wu kitoŋ ki Bɛtani, tsiiŋ fe bee dzɛ́mi yee yi tɛ̀ nuuŋ Maariya bee Maata. ");
INSERT INTO asj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maariya wuni wu ŋwaani wu Lasɔrɔ tɛ̀ gendi, ɛ wu wu tɛ̀ fwa bikaa bi Taa lɛ bɛ mɛɛŋ mɛ sɛɛndi ni shuuŋŋ, wɔɔyɛ bɛ yi ye yi lifa. ");
INSERT INTO asj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Si tɛ̀ gendi lɛ, dzɛ́mi yee yilu biee yi tuumi ntoŋ li Jiso-o le, “Taa, wi wuɔ ti kɔŋgisi wɛ gendɔɔ.” ");
INSERT INTO asj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Le Jiso woo ntoŋ wulu, tee le, “Chigɔŋ chini nuuŋ yɛ chi kwe-e kɛ. Chi chɛɛ le chi doonchɛ bunɔŋa bu nuuŋ bu Nyɔ-ɔ, ke Ŋwanɛ Nyɔ se naa kɛmɛ bukooŋ bu nɔŋa kii chi.” ");
INSERT INTO asj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jiso tɛ̀ kɔŋgisi Maata bee ŋwaani wu Maariya mɔɔ Lasɔrɔ ŋge. ");
INSERT INTO asj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Se nuuŋ le, mfi wu tɛ̀ woo le Lasɔrɔ gendɔɔ, tuu tsi fɛ tɛ̀ nuuŋ fɛɛ jo faa. ");
INSERT INTO asj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lɛjiŋ lɛlu, tee li bɔɔŋ bee bɛ kintutu-u le, “Tɛ kaari tɛ to Judiya.” ");
INSERT INTO asj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Be bii li wuu laa, “Labai, ɛ nɛɛ mfo mfo fɛ Bɛjuu tuu be wɛki le be tomɛ wɛ bɛ ta le ɔ kwi, ɔ se tuu ɔ karisi ɔ tuu fe ni?” ");
INSERT INTO asj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jiso tuu li bee le, “Ɛ nɛɛ bikaa bi mfi yoofi ntsɔ bɛfɛ bi nuuŋ li jobɛ ni? Ɛ wi deŋgi fɛnshaaŋ, kɛ mwɛ nuuŋ tɛ̀ kɔtɛ li fiee li kɛ, kifɛ kiŋ'wofu ki li nshɛ yini-i wuuti kɛɛ. ");
INSERT INTO asj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Se nuuŋ le, ɛ wi deŋgi butuu, kɛ mwɛ nuuŋ kɔtɛ, kifɛ ŋiŋgi yɛ kiŋ'wofu kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Si tɛ̀ kweeŋ lɛ, tuu tee li bee le, “Nsaŋ yisɛŋ yi Lasɔrɔ lee yɛ, bɛdɛɛni, ŋgii ŋgɛɛŋ ŋkaaŋgi wu li chilefɛ chilu-u.” ");
INSERT INTO asj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bɔɔŋ bee bɛ kintutu-u se tee li wuu le, “Taa, ɛ fi nuuŋ le wu leeɔ, kɛ gii kaaŋgi.” ");
INSERT INTO asj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jiso tɛ̀ tiiti nuuŋ kii kwe yi Lasɔrɔ, bɛdɛɛni be wuki le liitɔɔ nuuŋ chilefɛ chi chilefɛ. ");
INSERT INTO asj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jiso se tee li bee tsaaŋ le, “Lasɔrɔ kwiɔ kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Se nuuŋ le, ŋ'wukɔɔ bujɔŋ kii beŋ le ntɛ̀ nuuŋ yɛ fe kɛ, ke nɛ se gɛɛ shéŋ li mi-i. Tɛ ni tɛ giiŋgi fe.” ");
INSERT INTO asj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomɛ wu bukooŋ bwee bumu tɛ̀ nuuŋ le Maŋ, tee li bɔɔŋ bamu bɛ kintutu-u baa le, “Tɛ gɛɛŋ tɛ laa tɛɛbeŋ nuuŋ tɛ kwi tɛ bɛ wu le.” ");
INSERT INTO asj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jiso fɛsi fe, woo le Lasɔrɔ tsiɔ lɛ dziŋ jo naa. ");
INSERT INTO asj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani wuni tɛ nuuŋ nɛɛ li Jɛrosalɛŋ lichiŋ si bɛma bɛfɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bɛjuu ŋge tɛ̀ bɛ lɛ Maata bee Maariya le be gachɛ nshiiŋ bɛ be kii kwe yi ŋwaani wu be. ");
INSERT INTO asj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Le Maata woo le Jiso bɛɛɔ, biee bo le gɛɛŋ le bee wu bikɛ, se nuuŋ le, Maariya tɛ̀ ba li yih. ");
INSERT INTO asj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata gɛɛŋ tee li Jiso-o le, “Taa, tuu nuuŋ le ɔ ni ɔ nuuŋ fɛni, ŋwaanɛŋ wu kwiyɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Se nuuŋ le, ŋkiiɔ le mɔɔ nuuŋ dɛɛni, mɔɔ nuuŋ la fi ɔ lɛkɛ li Nyɔ-ɔ le, kɛ yi gii yi nyɛɔ.” ");
INSERT INTO asj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jiso tee li wuu le “Ŋwaana gii bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata tee li wuu le, “Ŋkiiɔ nɛɛ le gii kaari bo jobɛ chi kimɛrisɛ chi bɛniiŋ gii naa be ni be buti li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jiso tee li wu-u le, “Ɛ mi wu mbusi bɛniiŋ li kwe-e, ɛ mi wu nyɛ ntsɛ li bɛniiŋ li. Wi wu gɛɛ shéŋ li mi-i mɔɔ kwi, kɛ mwɛ gii ni nuuŋ lu, ");
INSERT INTO asj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","mɔɔ nuuŋ noo wu mɛɛŋ lu dɛɛni wu gɛɛ shéŋ li mi-i nuuŋ tɛ naa kwi kɛ. Ɔ beŋɔ fini ni?” ");
INSERT INTO asj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Se beŋ le, “Iiŋ Taa, mi mbeŋɔ le ɔ nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ. Ɛ wɛ Ŋwanɛ Nyɔ wu tɛ̀ nuuŋ le gii naa bɛ li nshɛ yini-i.” ");
INSERT INTO asj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Le Maata tee lɛ, se gɛɛŋ teeŋ Maariya wu ŋwaani, yɔ li wuu fɛkwiiŋ fɛkwiiŋ le, “Wi wu Ntiifɛ wɛ fɛni kituŋ, teenyɔ wɛ.” ");
INSERT INTO asj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Si tɛ̀ woo lɛ, se dzakɛ gɛɛŋ ŋɛŋ wu. ");
INSERT INTO asj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tɛ̀ nuuŋ ɛ Jiso mɛɛŋ saa ki lɛ kɛ li kitoŋ kilu-u kɛ. Tɛ̀ gii mɛɛŋ nɛɛ fɛ Maata tɛ̀ gɛɛŋ ŋɛŋ wu fe. ");
INSERT INTO asj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bɛjuu bɛ tɛ̀ nuuŋ bɛ Maariya be gachi nshiiŋ, bɛ wu baa ŋɛŋ si wu dzakɛ wu bo li yih, be dza be biki wu be beechi le giiŋgɔ fɛ dziŋ le gɛɛŋ ni dii fe. ");
INSERT INTO asj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Le Maariya gɛɛŋ fɛsi fɛ Jiso tɛh nuuŋ, ŋɛŋ wu, se we li bikaa biee li tee le, “Taa, tuu le ɔ ni ɔ nuuŋ fɛni, tuu nuuŋ ŋwaanɛ wu kwiyɛɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Le Jiso tuu ŋɛŋ si dii, Bɛjuu bɛ tɛ̀ biee wu dii tɛ, fiee filu koŋ wu li shéŋ ŋge, yi bee wu. ");
INSERT INTO asj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Se dza bii laa, “Nɛ tuu nɛ diiyɛ wu fɛŋ?” Be tee li wuu le, “Taa, bɛ ɔ ŋɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jiso de. ");
INSERT INTO asj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Le Bɛjuu ŋɛŋ lɛ, be tee le, “Bichɛ yɛɛŋ nɛ ŋɛŋ si tuu kɔŋgisi wu.” ");
INSERT INTO asj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Se nuuŋ le, bamu se tuu be tee le, “Ɛ wu wu tɛ̀ gwiyɛ lii yi kinyɛɛ, tuu lee ki baŋgɛ kɛ wi wuni le wu kwi kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Shéŋ yee tuu yi sɛɛsɛ ŋge. Dza gɛɛŋ fɛsi fɛ dziŋ yilu-u. Dziŋ yini tɛ̀ nuuŋ tuuŋ wu bɛ tɛ̀ bɛŋɛ mfweeŋ wulu bɛ tɛtɛ chi nɔŋa. ");
INSERT INTO asj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jiso tee le, “Tsaaki yɛɛŋ tɛtɛ chini.” Maata wu tɛ̀ nuuŋ dzɛmi yi wi wu tɛ̀ kwi wɛ tee li Jiso-o le, “Taa, dɛɛni yani wu saŋɔ kituŋ. Wɛ jo naa si tuu kwi.” ");
INSERT INTO asj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jiso bii li wu-u laa, “Mbee mɛɛŋ ki ntee kɛ li wɛ-ɛ le ɔ gɛɛ shéŋ li mi-i, ɔ se ŋɛŋ bunɔŋa bu Nyɔ-ɔ ni?” ");
INSERT INTO asj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Se nuuŋ le, be se tɛ̀ tsaaki tɛtɛ chilu. Jiso tsaaki lii liwe tee le, “Baa wɛŋ, nyɛɛɔ kiyɔɔni li wɛ-ɛ le ɔ wooɔ nlɛkɛ li Nyɔ-ɔ wɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ŋkii ɔ le ɔ ti wuki nlɛkɛ li Nyɔ-ɔ wɛŋ mfi kwi. Se nuuŋ le, ntiitɔɔ fini dɛɛni le bɛniiŋ bɛ lemi fɛni bani se beŋ le ɛ wɛ wu toŋ mi.” ");
INSERT INTO asj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Le ni kweŋgi lɛ, waŋ lɛwe le, “Lasɔrɔ, bochɛ!” ");
INSERT INTO asj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wi wu tɛ̀ kwi kituŋ wɛ se biee bo, bibɛnu biee mɔɔ bikaa biee nuuŋ ɛ bɛ liiŋ bɛ nshɛŋgɛ yi ndú bɛ liiŋ tɛ̀ bushi bwee bɛ nshɛŋgɛ yi ndú. Jiso tee li bee le, “Fanchɛ yɛɛŋ wu, nɛ gɛɛ ni giiŋgi.” ");
INSERT INTO asj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bɛjuu ŋge bɛ tɛ̀ bɛɛ lɛ Maariya, le be ŋɛŋ fiee fi Jiso fɛ, be gɛɛ shéŋ li wu-u. ");
INSERT INTO asj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Se nuuŋ le, bamu tɛ gɛɛŋ fibee nuuŋ lɛ Bɛfarasii, be tee be fiee fi Jiso fɛ. ");
INSERT INTO asj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ Bɛfarasii tuu be konchɛ bikoo bi kwɛɛŋ lɛ, be kweŋ le, “Ɛ la fi tɛ gii tɛ ge? Wi wuni fetɔɔ biee ŋge bi doonchi bunɔŋa bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ɛ tɛ chinɛ le ba ni giiŋgi bɛ fi limfwe, kɛ bɛniiŋ bɛchu gii be gɛɛ shéŋ li wu-u, bɛniiŋ bɛ Lom bɛ sɛki bee gii be dza be bɛ be kɛsi kintsii kisɛŋ ki wuuti mɔɔ kitoŋ kisɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Se nuuŋ le, wi wu be wumu wu bukooŋ bwee tɛ̀ nuuŋ le Kaifas, wu tɛ̀ nuuŋ kikoo ki bɛte muntofi-i li kiya kɛɛ dza tee fiee li bee le, “Nɛ kii yɛ fiee kɛ dududu. ");
INSERT INTO asj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nɛ kii yɛ le fi dzɔɔŋ le wi mumkpaŋ kwi li bɛniiŋ bɛchu-u yɛki fɛ kitoŋ kichu nuuŋ ki la bu la kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaifas tɛ̀ tiiti yɛ fiee fini bɛ bufii bu nuuŋ bwee kɛ. Wu si kikoo ki bɛte muntofi-i li kiya kɛɛ tɛ̀ tiiti fini laŋini nuuŋ ntoŋ wu Nyɔ le Jiso tɛ̀ kɛmi le kwi kii kitoŋ ki Bɛjuu. ");
INSERT INTO asj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tɛ̀ nuuŋ yɛ nɛɛ kii kitoŋ kilu kwaa kɛ, tɛ̀ kɛmi le kwi le banchɛ bɔɔŋ bɛ nuuŋ bɛ Nyɔ-ɔ bɛchu bɛ li bitoŋ bimu, be nuuŋ li fiee fi mumkpa-aŋ. ");
INSERT INTO asj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mbɛɛchɛ booyaa, bikoo bi kwɛɛŋ lɛ se bɛchi bi dzeti ntaŋ si bi gii bi fɛ bi se wo Jiso. ");
INSERT INTO asj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nɛɛ lɛ, Jiso tɛ mɛɛŋ yɛ deŋgi gbanaa lɛ Bɛjuu li lɛnti kɛ. Dza fiee fe gɛɛŋ li kitoŋ kimu ki nuuŋ li kitoŋ ki li bukaka lichiŋ bee bɔɔŋ bee bɛ kintutu-u, be tɛ̀ tsiiŋ fɛ kitoŋ kimu ki bɛ tɛ̀ teenyi le Ɛfelɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tsɔnɔ chi Bɛjuu lɛ chi N'yafuwee tɛ̀ bɛɛ kituŋ tsɛkɛtsɛkɛ, bɛniiŋ tɛ̀ dzɛti li bintsii bichu-u be yɛki Jɛrosalɛŋ jobɛ chini mɛɛŋ chi bɛɛ le be tsootsɛ bikoo bi bee kii be ni lɛ li tsɔnɔ chilu bɛ kinjirɛ. ");
INSERT INTO asj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Be se gɛɛŋ be bɛchi be wɛki Jiso be biiti li yi yi bee si be tɛ̀ lemi fɛ yih yi muntofi-i be tiiti laa, “Nɛ beechi le la? Jiso gii bɛ fɛ tsɔnɔ chini-i ni?” ");
INSERT INTO asj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tɛ̀ nuuŋ ɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ Bɛfarasii tɛ̀ nyɛ nchi kituŋ le wi wu kii fɛ Jiso nuuŋ fe, mwɛ fɛ be kɛɛ, ke be se kɔɔ wu. ");
INSERT INTO asj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Fɛ tɛ̀ shɛ jo busɔɔ le nuuŋ mfi wu Tsɔnɔ chi N'yafuwee, Jiso dza gɛɛŋ li kitoŋ ki Bɛtani fɛ Lasɔrɔ wu tɛ̀ buu li kwe-e wɛ tɛ̀ nuuŋ. ");
INSERT INTO asj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Le gɛɛŋ le, be fɛ biee bijɛ be tɛɛ wu lu. Maata tɛ̀ nuuŋ wi wu gabi, Lasɔrɔ se nuuŋ wumu li kintutu ki bɛniiŋ bɛ tɛ̀ shee be jii biee bee bɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maariya se dza dzɔ fikoo fi mɛɛŋ mamu mɛ sɛɛndi ni shuuŋŋ, tumi li bikaa bi Jiso-o, wɔɔyɛ bɛ yi ye yi lifa. Mɛɛŋ mani tɛ̀ tɛɛmi kwa ŋge, ɛ bɛ tɛ̀ fɛ bɛ fiee fimu fifi fi bɛ teenyi le naad wuwu. Si tɛ̀ tsi wu lɛ, li yih lɔɔ saaŋ kichu ni shuuŋŋ. ");
INSERT INTO asj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Se nuuŋ le Judas Iskaliyɔ wu tɛ̀ nuuŋ wi kintutu ki bɔɔŋ bɛ Jiso-o wumu, (wu tɛ̀ dza kabini wu) dza kweeŋ le, ");
INSERT INTO asj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ɛ la fi be fi ge le bɛ kabɛ mɛɛŋ mani bɛnchuki gii tɛɛ, bɛ nyɛ kwa wulu li bɛniiŋ bɛ kifoo lɛ?” ");
INSERT INTO asj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas tɛ̀ gii tiiti ni kɛmi yɛ mbeechɛ fɛ bɛniiŋ bɛ kifoo lɛ baa kɛ. Tɛ̀ nuuŋ wi wube wu babi, tɛ̀ shiiŋ lisi tsaŋ le fii yi yee lu. ");
INSERT INTO asj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jiso tee le, “Gɛɛ wu lɛ. Tɛ̀ kiri mɛɛŋ mani ni le nachɛ nuuŋ ndiyɛ wɛŋ lu. ");
INSERT INTO asj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bɛniiŋ bɛ kifoo lɛ gii be ni be nuuŋ bɛ beŋ mfi kwi, bɛdɛɛni nuuŋ ntɛ nuuŋ tɛɛbeŋ mfi kwi kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kintutu ki Bɛjuu lɛ woo le Jiso wɛ fe, be bɛ fe. Be tɛ̀ mɛɛŋ ki bɛ kɛ kii Jiso kwaa kɛ. Be tɛ̀ bɛ tɛ le be ŋɛŋ Lasɔrɔ wu Jiso tɛ̀ buu li kwe-e wɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Se nuuŋ le, bɛte muntofi bɛ nɔŋa bɛ nɔŋa tɛ̀ kaachɛ le be wo tɛ Lasɔrɔ, ");
INSERT INTO asj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kifɛ tɛ̀ nuuŋ kii wu, wu Bɛjuu ŋge, tɛ̀ gɛɛ shéŋ nuuŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Le butuu bo bu woo, kintutu ki bɛniiŋ lɛ ki tɛ̀ bɛ fɛ tsɔnɔ-ɔ woo le Jiso wɛ lɛ dze bɛɛ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Be se dzɔ biaatɛ be bo le, be gɛɛŋ be fi wu lɛ dze. Be gɛɛŋ be wuuyi be tiiti le, “Yiyi-i yiyi-i yiyi-i, kin'yokisɛ ni ki nuuŋ li Nyɔ-ɔ looo! Nyɔ tiiŋ yɛ mwɛ li wi wu bɛɛ li bukooŋ bu Taa lɛ looo! Ɛ wu wu nuuŋ Mfɔŋ wu Isɛlɛɛ looo!” ");
INSERT INTO asj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jiso se gɔɔŋ sɔmbwaa wu sɔɔŋ miri le. Fi se nuuŋ si bɛ tɛ̀ tsɛɛ le, ");
INSERT INTO asj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bɛniiŋ bɛ Sayɔŋ, kiiŋ nɛ ni nɛ chɛndi kɛ. Bichɛ yɛɛŋ nɛ ŋɛŋ, Mfɔŋ wunɛ bɛɛɔ, wu mirɔɔ lɛ sɔmbwaa wu sɔɔŋ li.” ");
INSERT INTO asj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Si fi tɛ̀ nuuŋ ni bɔɔŋ bɛ Jiso bɛ kintutu tɛ̀ kii yɛ si fiee fini tɛ doonchi fɛ mbɛɛchɛ kɛ. Le Jiso lɛ li bunɔŋa bwee li, be se tuu be kimi le bɛ tɛ̀ tsɛɛ fiee fini nuuŋ kii wu, fi se ka fiɛɛ bɛ wu nɛɛ si bɛ tɛ̀ tsɛɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kintutu ki tɛ̀ nuuŋ bɛ Jiso jobɛ chi tɛ̀ teeŋ Lasɔrɔ lɛ dziŋ buu wu li kwe-e kɛɛ tɛ̀ gɛɛŋ bɛ ntewu si be tɛ̀ ŋɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Fiee fi kintutu kilu tɛ̀ bo le ki gɛɛŋ ki fi wu lɛ dze tɛ̀ nuuŋ kifɛ be tɛ̀ woo le tɛ̀ fɛ fiee fini fi doonchi bunɔŋa bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bɛfarasii ŋɛŋ ni be tuu be tiiti li yi yi bee le, “Nɛ mɛɛŋ baa ki ŋɛŋ kɛ ni? Fiee lu kɛ fi nuuŋ nɛ fɛ. Kwɛɛŋ kwikwi banchɛ wɛɛ kituŋ wu biki wu.” ");
INSERT INTO asj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bɛniiŋ bamu tɛ̀ nuuŋ li kintutu ki bɛniiŋ bɛ tɛ̀ yɛɛ Jɛrosalɛŋ le be lɛkɛ li Nyɔ-ɔ mfi wu tsɔnɔ chini, be tɛ̀ nuuŋ Bɛgrik. ");
INSERT INTO asj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bɛgrik bani gɛɛŋ be ŋɛŋ Fili wu tɛ̀ dzɛti li kitoŋ ki Besaida-a lɛ kimbɛ ki Galilii, be tee li wuu le, “Wi wu nyɔŋa, tɛ wɛki baa le tɛ ŋɛŋ Jiso.” ");
INSERT INTO asj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fili se gɛɛŋ tee li Andolo, bee wu gɛɛŋ be tee li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jiso tuu li bee le, “Mfi kɔchɔɔ kituŋ wu Ŋwanɛwi gii kɛmɛ bukooŋ bu nɔŋa. ");
INSERT INTO asj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ntee beŋ chɛɛŋ chɛɛŋ le, ɛ ŋgɔ yi fiee mɛɛŋ ki we kɛ li nshɛ-ɛ le yi kwi kɛ, kɛ yi ba yɛ nɛɛ yi yi-i mbiiŋ. Se nuuŋ le ɛ yi kwi, yi se yiŋ yi woŋ muntaaŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wi wu kɔŋgisi ntsɛ we ŋge kɛ gii lɛɛ ntsɛ wulu, wi wu baanini ntsɛ we li nshɛ yini, kɛ mwɛ gikɔɔ bu gɛwu le ke naa kɛmɛ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɛ wi nindi li mi-i, kɛ mwɛ kɛmi le ni biki mi, mɔɔ nuuŋ fɛŋ fɛ nnuuŋ le, wi wɛŋ wu nimɛ ni nuuŋ tɛ fe. Wi wu nindi li mi-i, kɛ Baa wɛŋ gii naa tsaaki mwɛ liwe.” ");
INSERT INTO asj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jiso se dza tee le, “Dɛɛni shéŋ yɛŋ wɛsini yɛɛ. Ɛ la fi nnuuŋ mɔɔ ntee? Le Taa buu mi lɛ mfi wu ŋgɛ wuni lɛnti ni? Aay, ɛ kii mfi wulu wuni wu ntɛ̀ mbɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baa wɛŋ, fɛrɛ bukooŋ bwo ni bu kuu.” Le yɔ lɛ, jɛ shee liboo le, “Mi mfɛɔ bu ko kituŋ, nse mmɛɛŋɔ ntuu ŋka mfɛ.” ");
INSERT INTO asj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Le kintutu ki tɛ̀ lemi fe woo jɛ yilu lɛ, ki tee fi ki-i le, “Ɛ dzaaŋ yi kumini.” Bamu se tee le, “Ɛ Nchindaa wu Nyɔ wu yeti li wu-u.” ");
INSERT INTO asj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jiso tuu le, “Jɛ yini bɛ yɛ kii beŋ. Yi mɛɛŋ yɛ ki bɛ kɛ kii mi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dɛɛni yaa mfi wu bɛ gii bɛ saa nshɛ yini. Dɛɛni bɛ gii bɛ shɔni bɛ kooŋ bɛ mfɔŋ bɛ sɛki nshɛ yini. ");
INSERT INTO asj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Se nuuŋ le fieŋ fiɛɛ le mfi wu bɛ shiŋɛ mi li we, ŋgii nchee bɛniiŋ bɛchu be ni be bɛɛ lɛ mi-i.” ");
INSERT INTO asj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jiso tɛ̀ tiiti lɛ doonchi nuuŋ ŋwaani kwe yi gii kwi. ");
INSERT INTO asj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kintutu ki bɛniiŋ lɛ kɛɛ se tuu li wuu le, “Tɛ wuki baa lɛ Kiŋwaati ki bɛnchi-i le Kinsofu ki Nyɔ tɛ̀ kaachɛ gii ki booshɛ. Ɔ geeŋ ɔ se kweŋgi le bɛ gii bɛ shiŋɛ Ŋwanɛwi li we? Ŋwanɛwi wulu nuuŋ noo?” ");
INSERT INTO asj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jiso se tee li bee le, “Kiŋ'wofu gii ki ni ki nuuŋ bɛ beŋ li mfi niiŋ li. Nɛ deŋgi yɛɛŋ lɛ, si nɛ kɛmi kiŋ'wofu bɛ beŋ lɛ, kiiŋ kijibɛ ni dza ki jiŋ li be-eŋ kɛ. Wi wu deŋgi li kijibɛ-ɛ ti kii yɛ fɛ giiŋgi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Si nɛ kɛmi baa kiŋ'wofu bɛ beŋ lɛ, beŋ yɛɛŋ li kiŋ'wofu kilu, nɛ se ni nɛ nuuŋ bɔɔŋ bɛ kiŋ'wofu-u.” Le Jiso tee biee bini ni, se dza gɛɛŋ nyiŋ. ");
INSERT INTO asj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mɔɔ si tɛ̀ fɛ biee ŋge bi doonchɛ bunɔŋa bwee be ŋɛŋ ni, be ti mɛɛŋ nɛɛ ki gɛɛ kɛ shéŋ li wu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Fi tɛ̀ nuuŋ lɛ le fi bɛ fi kɔchɛ si Ɛsaya wu ntomfɔŋ wu Nyɔ tɛ̀ tee le, “Taa, ɛ noo wu wɛ lu wu beŋ fiee fi tɛ tiiti? Ɛ li ba-aŋ li bɛ doonchɛ buŋga bu kibɛnɛ Taa lɛ?” ");
INSERT INTO asj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Se nuuŋ le, be se tɛ̀ ba ŋgɛwu shéŋ li wuu nsiŋ, kifɛ Ɛsaya tɛ̀ tuu kweeŋ kintsii kimu le, ");
INSERT INTO asj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wu nyɛɛkɔɔ lii yi be, wu fɛ mɔɔ le shéŋ yi be ni yi dendi, le kiiŋ be ni be ŋiŋgi biee bɛ lii yi be, be ni be kii biee bɛ shéŋ yi be, be se kaari be to lijiŋ lɛ mi-i le ŋ'wɔnchɛ be kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ɛsaya tɛ̀ tiiti biee bini ni kifɛ tɛ̀ saa wu ŋɛŋ bunɔŋa bu Jiso-o, se tiiti kii wu. ");
INSERT INTO asj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mɔɔ si bɛniiŋ tɛ̀ nuuŋ yɛ le be gɛɛ shéŋ li Jiso-o lɛ kɛ, bɛniiŋ ŋge bɛ tɛ̀ nuuŋ bikoo bi kwɛɛŋ lɛ tɛ̀ gɛɛ tɛ shéŋ li wu-u, bɛdɛɛni, be se tɛ̀ mɛɛŋ ki tee kɛ bɛ bimfimu bi bee kɛ, kifɛ be tɛ̀ chɛndi Bɛfarasii le kii be ni kooŋ be li yih yi nlɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Be tɛ̀ chɛndi lɛ kifɛ be tɛ̀ kɔŋgisi le be kɛmɛ mpiaru nuuŋ wu dzɛti fɛ bɛniiŋ li, yɛki le be kɛmɛ nuuŋ mpiaru wu dzɛti fɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jiso se dza dzaaŋ lɛwe ŋge tee le, “Wi wu gɛɛ shéŋ li mi-i, mɛɛŋɔ ki gɛɛ kɛ nuuŋ li mi-i kɛ. Wu gɛɛɔ nuuŋ li wi wu toŋ mi-i. ");
INSERT INTO asj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɛ wi ŋɛŋ mi, kɛ mwɛ ŋɛŋgɔɔ nuuŋ wi wu toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi mbɛɛɔ li nshɛ yini-i si kiŋ'wofu le mɔɔ nuuŋ noo wu gɛɛ shéŋ li mi-i le mwɛ tɛ ba li kijibɛ-ɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɛ wi wu woo jɛ yɛŋ, mɛɛŋ yi ki gɛɛ kɛ, ntɛ̀ nsaa wu kɛ, kifɛ nti mɛɛŋ ki mbɛ kɛ le nsaa bɛniiŋ bɛ li nshɛ yini le be we nsa kɛ. Ntɛ̀ mbɛ nuuŋ le nsoo be. ");
INSERT INTO asj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wi wu faaŋ mi mɛɛŋ ki fi jɛ yɛŋ kɛ kɛmɔɔ fiee fi gii fi saa wu. Jɛ yi mi n'yɔ li wu-u ɛ yi yi gii yi saa wu we nsa jobɛ chi kimɛrisɛ. ");
INSERT INTO asj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Fi fiɛɛ lɛ kifɛ n'yeti yɛ nuuŋ li buŋga bwe-eŋ kɛ. Baa wɛŋ wu toŋ mi, ɛ wu wu tee le ni ntiiti, ɛ wu wu nyɛ mi fiee fi ŋgii ni ntiiti, wu tee mi si ŋgii ni ntiiti. ");
INSERT INTO asj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ŋkii le fiee fi wu tee le ni ntiiti nuuŋ fiee fi nyɛɛ ntsɛ wu kimakɛ. Se nuuŋ le fiee fi ntiiti nuuŋ fi Baa wɛŋ bee tee le ni ntiiti.” ");
INSERT INTO asj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Le ni nuuŋ le bu gii bu woo se nuuŋ jobɛ chi Tsɔnɔ chi N'yafuwee, Jiso kɛɛ le mfi wu gii chinɛ li nshɛ yini-i, kaari gɛɛŋ fɛ Tee li kɔchɔɔ kituŋ. Si tɛ̀ kɔŋgisi bɛniiŋ bɛ tɛ̀ nuuŋ bee li nshɛ yini-i, se kɔɔŋgi be gɛɛŋ mɛɛshi. ");
INSERT INTO asj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Le be ni be jii biee fɛmfo, ɛ kiŋkundi tɛ̀ saa ki lii mbeechɛ li shéŋ yi Judas wu ŋwanɛ Simu Iskaliyɔ le kabɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Si Jiso tɛ̀ kii kituŋ le Tee nyɛɔ biee bichu li tsaŋ yee li, bɛ le tɛ̀ dza fɛ Nyɔ-ɔ, mɔɔ le karisɔɔ tuu lijiŋ fɛ Nyɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","dza lɛ bijɛ lɛwe, buushɛ biŋkoŋ biee, dzɔ ndu yi bɛ wɔɔyi bwiŋ lu, kaŋ litiŋ, ");
INSERT INTO asj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tumi dzɔɔ lɛ shoo, bɛchi tsootsi bikaa bi bɔɔŋ bee bɛ kintutu-u lu, wɔɔyi bɛ ndu yi tɛ̀ kaŋ li litiŋ yɛ. ");
INSERT INTO asj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Le tsootsɛ bo fɛ Simu Pita, Simu bii li wuu laa, “Taa, ɔ gii ɔ tsootsɛ bikaa bieŋ ni?” ");
INSERT INTO asj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jiso tuu li wuu le, “Fiee fi mfeti ɔ nuuŋ tɛ kɛɛ fi dɛɛni kɛ. Ɔ gii ɔ kɛɛ nuuŋ lɛjiŋ.” ");
INSERT INTO asj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita tee li Jiso-o le, “Ɔ nuuŋ tɛ naa tsootsɛ bikaa bieŋ kɛ.” Jiso se tuu li wuu le, “Ɛ mɛɛŋ ki ntsootsɛ kɛ bikaa bio kɛ, ɔ tɛ kɛmɛ fiee tɛɛ wɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simu Pita se tee li Jiso-o le, “Taa, ɛ fi nuuŋ lɛ, kɛ ɔ nuuŋ tɛ tsootsɛ bikaa bieŋ kwaa kɛ. Ɔ gii ɔ tsootsɛ tɛ tsaŋ yɛŋ mɔɔ kikoo keŋ tɛ.” ");
INSERT INTO asj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jiso tee li wuu le, “Wi wu bee saa wu tsootsɛ bwiŋ wɛ waaŋ kituŋ bwiŋ kichu, kɛmi yɛ le tuu tsootsɛ bwiŋ fuki bikaa kwaa nsiŋ kɛ. Nɛ baa finɛ waaŋ kituŋ, se nuuŋ le ɛ beŋ bɛchu bɛ wuuti baa kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jiso tɛ̀ tiiti lɛ kifɛ tɛ̀ kɔɔ wu kɛɛ wi wu gii kabɛ wu. Fiɛɛ fiee fi tɛ̀ tiiti le, “Ɛ Beŋ bɛchu bɛ wuuti kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Le Jiso mɛɛshi tsootsɛ bikaa bi bee, liishɛ ndú yee, kaari gɛɛŋ to fɛ kintsii kee li, se bii li bee laa, “Nɛ kɛɛ baa fiee fi mi mfɛ li be-eŋ fini ni? ");
INSERT INTO asj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nɛ teenyi mi le Wi wu Ntiifɛ nɛ tuu nɛ teenyi tɛ mi le Taa, nɛ teenyi baa nuuŋ bujɔŋ, kifɛ ɛ fiee fi nnuuŋ. ");
INSERT INTO asj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ɛ mi wu nuuŋ Taa wunɛ mɔɔ Wi wunɛ wu Ntiifɛ mi tsootsɛ bikaa binɛ, kɛ nɛ kɛmi baa le nɛ ni nɛ tsootsi tɛ bikaa bi wi bee wi-i. ");
INSERT INTO asj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mi mfɛɔ fini le ndoonchɛ li be-eŋ le nɛ ni nɛ feti nɛɛ tɛ si mi mfɛ li be-eŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ntee beŋ chɛɛŋ chɛɛŋ le ŋwaŋ wu nimɛ nuuŋ tɛ ko le yaa te kikoo we kɛ, kɛ le wi wu bɛ toŋ ko yaa wi wu toŋ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ɛ nɛ kii biee bini, nɛ feti bi, kɛ kinɛɛtinɛ kiŋge kɛɛ kinɛ. ");
INSERT INTO asj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ntiiti yɛ nuuŋ kii beŋ bɛchu kɛ. Ŋkiiɔ bɛniiŋ bɛ mbee ntsaa. Se nuuŋ le, fi se fiɛɛ le fiee fi nuuŋ lɛ Kiŋwaati ki Nyɔ-ɔ kɛmi le fi bɛ fi kɔchɛ si bɛ tsɛɛ le, ‘Wi wu jii biee bieŋ wu dzaɔ biki bikaa bieŋ.’ ");
INSERT INTO asj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ntiitɔɔ fiee fini li be-eŋ dɛɛni fi mɛɛŋ fi se naa fi ka, le ke fi tuu fi ka, nɛ se tuu nɛ beŋ le ɛ mi wulu. ");
INSERT INTO asj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ntee beŋ chɛɛŋ chɛɛŋ le wi wu fii mɔɔ nuuŋ noo wu mi ntoŋ le, wu fiɔ nuuŋ mi. Wi wu fi mi, fiɔ nuuŋ wi wu toŋ mi.” ");
INSERT INTO asj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Si Jiso tee biee bini ni, shéŋ dza yi wɛsini wu. Dza tee gbanaa le, “Ntee beŋ chɛɛŋ chɛɛŋ le wumu li be-eŋ linti gii kabɛ mi.” ");
INSERT INTO asj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bɔɔŋ bee bɛ kintutu-u dza be bichi yi yi bee, be mɛŋini laa tiiti nuuŋ wi wu la le. ");
INSERT INTO asj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wi wu kintutu ki bɔɔŋ bɛ Jiso wumu wu Jiso tɛ̀ gii kɔŋgisi tɛ̀ yemi jii biee nɛɛ li wu-u lichiŋ. ");
INSERT INTO asj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simu Pita kwafi wu tee le bii li Jiso-o laa tiiti nuuŋ noo le. ");
INSERT INTO asj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Se nuuŋ le, se yeŋ gɛɛŋ li Jiso bii li wuu laa, “Taa, ɛ noo?” ");
INSERT INTO asj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jiso tuu li wuu le, “Ɛ wi wu ŋgii bootɛ kibele nlii li kitsubi ki mbasi nyɛ li wuu.” Bɛdɛɛni, tuu lii kibele kilu li kitsubi ki mbasi nyɛ li Judas wu ŋwanɛ Simu Iskaliyɔ. ");
INSERT INTO asj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nɛɛ si Judas tɛ̀ fi kibele kilu lɛ, Sataŋ biee lɛ li yi yee li. Jiso tee li wuu le, “Fɛrɛ fiee fiɔ wɛki le ɔ fɛ tsɛkɛ.” ");
INSERT INTO asj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wi wumu li kintutu ki bee tɛ̀ mɛɛŋ ki kɛɛ kɛ fiee fi wu tee li wuu lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bamu tɛ̀ beechi le si Judas tɛ̀ nuuŋ wi wu kichi babi wu kwa lɛ, le Jiso tiitɔɔ li wuu le gɛɛŋ go biee bi be ti kɔŋgisi njɛ Tsɔnɔ lu, kɛ le gɛɛŋ nyɛ fiee li bɛniiŋ bɛ kifoo lɛ. ");
INSERT INTO asj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Si Judas tɛ̀ fi kibele kilu lɛ ji, biee bo mfwa mumkpaŋ gɛɛŋ. Mfi wu wɛɛ tɛ̀ nuuŋ butuu. ");
INSERT INTO asj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Si Judas tɛ̀ bo gɛɛŋ lɛ, Jiso shɛ tee le, “Dɛɛni bɛ gii bɛ bɛchi bɛ ni bɛ ŋiŋgi bunɔŋa bu Ŋwanɛwi-i, bɛ tuu bɛ ni bɛ ŋiŋgi tɛ bunɔŋa bu nuuŋ bu Nyɔ-ɔ li yi yee li. ");
INSERT INTO asj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɛ be ŋɛŋ bunɔŋa bu Nyɔ li yi yee li, kɛ Nyɔ gii yi doonchɛ tɛ bunɔŋa bu Ŋwani li yíh yi Nyɔ-ɔ. Kɛ gii doonchɛ mfwa mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bɔɔŋ beŋ, ŋgii nuuŋ tɛɛbeŋ li mfi niiŋ li. Nɛ gii nɛ shɛ nɛ gɔɔŋ mi nɛ tɛ ŋɛŋ kɛ. Si ntɛ̀ ntiiti li Bɛjuu li lɛ, ɛ nɛɛ lɛ si ntiitɔɔ li be-eŋ dɛɛni le, ‘Fɛ ŋgiiŋgi nuuŋ nɛ tɛ bɛ fe kɛ.’ ");
INSERT INTO asj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nyɛɛɔ nchi li be-eŋ, nuuŋ nchi wu fwɛŋ, le mfi wu nɛ shɛ nɛ ni nɛ nuuŋ bɛ kiŋkɔŋgisɛ. Nɛ ni nɛ kɔŋgisi nɛɛ tsaaŋ si ntuu kɔŋgisi beŋ. ");
INSERT INTO asj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ɛ nɛ shɛ nɛ nuuŋ bɛ kiŋkɔŋgisɛ, fini fɛ bɛniiŋ bɛchu se kɛɛ le nɛ baa bɔɔŋ beŋ bɛ kintutu-u.” ");
INSERT INTO asj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simu Pita se bii li Jiso-o laa, “Taa, ɔ giiŋgi nuuŋ fɛŋ?” Jiso tuu le, “Fɛ ŋgiiŋgi fe nuuŋ ɔ tɛ biee mi fe dɛɛni kɛ. Ɔ gii ɔ shɛ ɔ se biee.” ");
INSERT INTO asj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita kaari bii li wu-u laa, “Taa, nuuŋ ntɛ mbiee wɛ dɛɛni kɛ kii la? Ŋgii nyɛ ntsɛ wɛŋ le ŋkwi kii wɛ.” ");
INSERT INTO asj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jiso bii li wu-u laa, “Ɔ nuuŋ ɔ nyɛ ntsɛ wa le ɔ kwi kii mi ni? Nteeɔ chɛɛŋ chɛɛŋ le nyinɛshee nuuŋ tɛ̀ tɔɔŋ kiŋga kitɛɛtɛ ɔ mɛɛŋ ki faaŋ kɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jiso tuu kweeŋ li bɔɔŋ bee bɛ kintutu-u le, “Kiiŋ nɛ ni gɛɛ le shéŋ yinɛ ni yi wɛsini kɛ. Gɛɛ yɛɛŋ shéŋ li Nyɔ-ɔ, nɛ gɛɛ tɛ shéŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Li Baa wɛŋ yih, bɛloŋ baa lu ŋge. Bee le fi ni fi nuuŋ yɛ lɛ kɛ, be mi ntefɛɛ le ŋgiiŋgɔɔ nachɛ kintsii li be-eŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nse ŋgiiŋgɔɔ ke mi nachɛ kintsii li be-eŋ, ŋkaari mbɛ ndzɔɔ beŋ tɛ ni tɛ nuuŋ, le fɛ nnuuŋ fe, nɛ ni nɛ nuuŋ fe tɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nɛ kii baa kituŋ dze yi giiŋgi fɛ ŋgiiŋgi fe.” ");
INSERT INTO asj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomɛ se tee li wuu le, “Taa, tɛ kii yɛ fɛɔ giiŋgi fe kɛ. Tɛ gii tɛ geeŋ tɛ se kɛɛ dze yilu?” ");
INSERT INTO asj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jiso tuu li wuu le, “Ɛ mi wu nnuuŋ dze, nnuuŋ chɛɛŋ, nnuuŋ tɛ ntsɛ wulu. Wi nuuŋ tɛ gɛɛŋ fɛ Baa wɛ-ɛŋ fuki fɛ wu ka li mi-i nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bee le nɛ ni nɛ kii mi, bee nuuŋ nɛ kɛɛ tɛ Baa wɛŋ. Mbɛɛchɛ dɛɛni, nɛ kɛɛ baa wu nɛ tuu nɛ ŋɛŋ tɛ wu tɛ.” ");
INSERT INTO asj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fili tee li wuu le, “Taa, doonchɛ Baa wa li bee li, tɛ ŋɛŋ wu tɛ se fukɛ.” ");
INSERT INTO asj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jiso tuu li wuu le, “Fili, tɛɛbeŋ tsi baa ŋge ni ɔ se tɛ kɛɛ mi kɛ ni? Wi wu ŋɛŋ mi, kɛ mwɛ ŋɛŋgɔɔ Baa wɛŋ kituŋ. Fi geeŋ ɔ se tuu ɔ tiiti le ndoonchɛ Baa wɛŋ li be-eŋ? ");
INSERT INTO asj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɔ mɛɛŋɔ ki beŋ kɛ le nnuuŋ li Baa wɛ-ɛŋ, Baa wɛŋ se nuuŋ tɛ li mi-i kɛ ni? Tefɛ chi ntiiti li be-eŋ chini nuuŋ yɛ li buŋga bwe-eŋ kɛ. Ɛ Baa wɛŋ wu nuuŋ li mi-i wu nindi niiŋ yee. ");
INSERT INTO asj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Beŋ yɛɛŋ li mi-i le mi ŋ'we li Baa wɛ-ɛŋ, se Baa wɛŋ nuuŋ li mi-i. Ɛ nɛ mɛɛŋ ki beŋ kɛ li mi-i kii fiee fi ntiiti kɛ, nɛ beŋ li mi-i kii niiŋ yi nnindi. ");
INSERT INTO asj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ntee beŋ chɛɛŋ chɛɛŋ le wi wu gɛɛ shéŋ yee li mi-i, gii ni feti tɛ niiŋ yi mfeti. Gii niŋ yaa mɔɔ yi mi niŋ, kifɛ ŋgiiŋgɔɔ kituŋ lɛ Baa wɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mɔɔ nuuŋ la fi nɛ bii li bukooŋ bwe-eŋ le, ŋgii mfɛ fi, ke se Baa wu Ŋwaŋ kɛmɛ bukooŋ bu nɔŋa nuuŋ kii Ŋwaŋ. ");
INSERT INTO asj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ɛ nɛ bii mɔɔ nuuŋ la li bukooŋ bwe-eŋ le, ŋgii mfɛ fi. ");
INSERT INTO asj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ɛ nɛ kɔŋgisi mi, nɛ ni nɛ kichi bɛnchi beŋ. ");
INSERT INTO asj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ŋgii nlɛkɛ Baa wɛŋ se nyɛ beŋ Wi wu Mfiɛ wumu wu gii ni nuuŋ bɛ beŋ mfi kwi. ");
INSERT INTO asj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wi wuni wɛ nuuŋ Fiana yi chɛɛŋ. Nuuŋ yɛ wi wu bɛniiŋ bɛ nuuŋ li nshɛ yini-i nuuŋ be fi wu kɛ, kifɛ be ŋiŋgi yɛ wu kɛ, be kii yɛ mɔɔ wu kɛ. Nɛ baa finɛ nɛ kii wu, kifɛ tsiiŋɔ bɛ beŋ, se gii ni nuuŋ li yi yinɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nnuuŋ ntɛ nshɛ beŋ le nɛ ni nɛ nuuŋ si bɔɔŋ bɛɛŋku-u kɛ. Ŋgii ŋkaari mbɛ nni nnuuŋ tɛɛbeŋ. ");
INSERT INTO asj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Shɛɔ niiŋ le bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i tɛ tuu le be ŋɛŋ mi kɛ. Se nuuŋ le, nɛ gii nɛ ni nɛ ŋiŋgi mi. Si ŋgii ni nnuuŋ lu lɛ, nɛ gii nɛ ni nɛ nuuŋ tɛ lu. ");
INSERT INTO asj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naa nuuŋ boo yɛlu, nɛ kɛɛ le mi ŋ'we li Baa wɛ-ɛŋ, se nɛ nuuŋ li mi-i, nse nnuuŋ tɛ li yi yinɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wi wu kii bɛnchi beŋ kichi be, wɛ wi wu kɔŋgisi mi. Wi wu kɔŋgisi mi, kɛ Baa wɛŋ gii kɔɔŋgi tɛ mwɛ. Ŋkɔɔŋgi mwɛ tɛ, nse ndoonchɛ yi yɛŋ li mwɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas wumu (nuuŋ yɛ wu bɛ teenyi le Iskaliyɔ wɛ kɛ) bii li wuu laa, “Taa, fi geeŋ fi ɔ gii ɔ doonchɛ yi ya nuuŋ li bee li kwaa, ɔ tɛ doonchɛ li bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i kɛ?” ");
INSERT INTO asj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jiso tuu li wuu le, “Ɛ wi kɔŋgisi mi, kɛ gii ni kichi n'yɔru wɛŋ, kɛ Baa wɛŋ gii kɔɔŋgi wu, tɛɛ Baa wɛŋ gii tɛ bɛ li wuu, ni tsiiŋ tɛ bɛ bee. ");
INSERT INTO asj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wi wu kɔŋgisi yɛ mi kɛ, ti kichi yɛ jɛ yɛŋ kɛ. N'yɔru wu nɛ wuki wuni nuuŋ yɛ wɛŋ kɛ. Ɛ wu Baa wɛŋ wu toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Biee bini ntiitɔɔ bi li be-eŋ mɛɛŋ tɛɛbeŋ. ");
INSERT INTO asj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Se nuuŋ le, Wi wu Mfiɛ wu nuuŋ Fiana yi Waaŋ wu Baa wɛŋ gii tuumi li bukooŋ bwe-eŋ gii tifi beŋ biee bichu tuu ni feti nɛ kiimi biee bichu bi ntɛ̀ ntee li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi nshɛɔ mbɛɛŋgii le ni nuuŋ bɛ beŋ. Mi nnyɛɔ mbɛɛŋgii wu nuuŋ wɛŋ li be-eŋ. Se nuuŋ le nnyɛɛ yɛ mbɛɛŋgii wuni li be-eŋ si bɛniiŋ bɛ nuuŋ li nshɛ yini-i ti nyɛɛ kɛ. Kiiŋ nɛ ni gɛɛ le shéŋ yinɛ ni yi wɛsini, kɛ le nɛ ni nɛ kɛmi jaaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nɛ woo baa si mi ntee le ŋgiiŋgɔɔ, nse ntuu ŋkaari mbɛ nni nnuuŋ tɛɛbeŋ. Bee le nɛ ni nɛ kɔŋgisi mi, bee nuuŋ nɛ nɛɛtini bunɛɛtinɛ, kifɛ ŋgiiŋgɔɔ nuuŋ fɛ Baa wɛ-ɛŋ, kifɛ Baa wɛŋ ko wu yaa mi. ");
INSERT INTO asj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dɛɛni mi nteeɔ fiee fini li be-eŋ kituŋ fi mɛɛŋ fi se naa fi ka, le ke fi naa kɛtɔɔ, nɛ se beŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mɛɛŋ yɛ ntuu nshee nni n'yeti li beŋ ŋge kɛ, kifɛ mfɔŋ wu sɛki nshɛ yini bɛɛɔ kituŋ. Nuuŋ yɛ le kɛmɔɔ buŋga lɛ mi-i lɛwe kɛ. ");
INSERT INTO asj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Se nuuŋ le, mfetɔɔ tɛ nuuŋ si Baa wɛŋ tee le ni mfeti le ke bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i naa kɛɛ le ŋkɔŋgisi Baa wɛŋ. Dza yɛɛŋ we, tɛ gɛɛŋ bu limfwe-e.” ");
INSERT INTO asj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ɛ mi kigiitɛ ki kiti ki muntaaŋ lɛ ki chɛɛŋ, Baa wɛŋ se nuuŋ wi wu nachi kigiitɛ kilu. ");
INSERT INTO asj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yɛ́ŋɛ yɛŋ chichi yi wundi yɛ muntaaŋ kɛ, nti mbɛɛ ŋkaanshɛ mbuu, yí wundi muntaaŋ yɛɛ nachɛ yi ŋkɛɛyɛ yi le yi ni yi wuuti yi se wundi muntaaŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tefɛ chi mi ntee li be-eŋ, fɛ chɛɛ nɛ to waaŋ kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ba yɛɛŋ lɛ nɛ ni nɛ nuuŋ li mi-i, nse mba tɛ ni nnuuŋ li be-eŋ. Yɛŋɛ nuuŋ tɛ woŋ muntaaŋ yi yi, fuki fɛ yi nuuŋ li kiti-i nsiŋ kɛ. Ɛ nɛɛ lɛ si nuuŋ nɛ tɛ fɛ fiee fuki fɛ nɛ ba li mi-i nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ɛ mi kigiitɛ ki kiti ki muntaaŋ lɛ nɛ se nuuŋ yɛ́ŋɛ yilu. Wi wu ba nuuŋ li mi-i, mba tɛ ni nnuuŋ li mwɛ-ɛ, wɛɛ wi wɛ si yɛŋɛ yi nuuŋ yi woŋ muntaaŋ ŋge, kifɛ ɛ foo mi nsiŋ, wi tɛ fɛ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wi wu mɛɛŋ ki ba le ni nuuŋ li mi-i kɛ, wɛ si yɛŋɛ yi bɛ nuuŋ bɛ wa bɛ lɔŋ bu lɔmu, yi wondɛ. Ŋwaani yɛɛ yɛ́ŋɛ bɛ ti bɛɛ bɛ banchɛ bɛ lɔŋ yi fɛ wi yi do. ");
INSERT INTO asj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ɛ nɛ ba nɛ nuuŋ li mi-i, jɛ yɛŋ se ba yi ni yi nuuŋ li be-eŋ, ɛ nɛ bii mɔɔ nuuŋ fi la fi nɛ wɛki le, kɛ bɛ gii bɛ fɛ fi li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ɛ nɛ nuuŋ si yɛ́ŋɛ yi wundi muntaaŋ ŋge, fini nyɛ bukooŋ bunɔŋa li Baa wɛ-ɛŋ, fi se tuu fi doonchɛ le nɛ nuuŋ bɛniiŋ beŋ bɛ kintutu-u. ");
INSERT INTO asj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Si Baa wɛŋ kɔŋgisi mi lɛ, ɛ nɛɛ lɛ si ŋkɔŋgisi beŋ. Ba yɛɛŋ nɛ ni nɛ nuuŋ li kiŋkɔŋgisɛ ke-eŋ lɛnti. ");
INSERT INTO asj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ɛ nɛ kichi bɛnchi beŋ, nɛ ba nɛ ni nɛ nuuŋ li kiŋkɔŋgisɛ ke-eŋ linti, nɛɛ si mi ŋkiri bɛnchi bɛ Baa wɛ-ɛŋ mi nse mba li kiŋkɔŋgisɛ kee li. ");
INSERT INTO asj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Biee bi ntiiti li be-eŋ bini biɛɛ le kinɛɛtinɛ keŋ ni ki nuuŋ li be-eŋ, nɛ se tuu nɛ kɛmɛ kinɛɛtinɛ ki yisɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nchi wɛŋ nuuŋ wuni, wu nuuŋ le nɛ ni nɛ kɔŋgisi nɛɛ wi bee wi nɛɛ si ŋkɔŋgisi beŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kiŋkɔŋgisɛ kimu nuuŋ yɛ lu ki ko ki yaa ki nuuŋ le wi nyɛ ntsɛ we le kwi kii nsáŋ yee kɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɛ nɛ feti fiee fi ntiiti le nɛ ni nɛ feti, kɛ nɛ ba baa nsáŋ yɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mɛɛŋ yɛ ntuu ni nteenyi beŋ le bɔɔŋ bɛ nimɛ-ɛ kɛ, kifɛ ŋwaŋ wu nimɛ ti kii yɛ fiee fichu fi te kikoo we feti kɛ. Nteenyɔɔ beŋ le nsáŋ yɛŋ kifɛ fiee fichu fi mi ŋ'woo li Baa wɛ-ɛŋ, mi mfɛɔ nɛ kɛɛ fi. ");
INSERT INTO asj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɛ beŋ nɛ tɛ̀ tsaa mi kɛ. Ɛ mi wu ntɛ̀ tsaa beŋ, mi mbuu mi gɛɛ le nɛ gɛɛŋ nɛ ni nɛ nuuŋ si yɛ́ŋɛ yi wundi muntaaŋ, muntaaŋ mu gii mu ba mu ni mu nuuŋ lu. Ɛ nɛ feti lɛ, mɔɔ nuuŋ la fi nɛ bii li Baa wɛŋ, li bukooŋ bwe-eŋ le, kɛ gii nyɛ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nchi wu nnyɛɛ li be-eŋ wɛ nuuŋ wuni le, nɛ ni nɛ kɔŋgisi yi yinɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ɛ nshɛ yini baanini beŋ, nɛ kɛɛ le yi tɛ̀ saa yi bɛchi yi baanini mi, yi se baanini beŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bee nuuŋ le nɛ ni nɛ nuuŋ bɛniiŋ bɛ li nshɛ yini-i, nshɛ yini yi kɔŋgisi beŋ si bɛniiŋ bee. Se nuuŋ le, nɛ nuuŋ yɛ bɛniiŋ bɛ li nshɛ yini-i kɛ. Mi ntsaaɔ beŋ li nshɛ yini-i. Fiɛɛ fiee fi nshɛ yini baanini beŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kimi yɛɛŋ tefɛ chi mbee ntiiti li be-eŋ le ŋwaŋ wu nimɛ ti kuu yɛ yɛki te kikoo we kɛ. Ɛ be tɛ̀ biindi bikaa lɛ mi-i jiŋ, kɛ be gii be ni be biindi tɛ lɛ benɛ jiŋ. Ɛ nuuŋ le be tɛ̀ woo jɛ yɛŋ, kɛ be gii be woo yinɛ tɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Biee bini bichu, be gii be ni be feti bɛ beŋ kii mi, kifɛ be kii yɛ wi wu toŋ mi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bee le nni mmɛɛŋ ki mbɛ kɛ le n'yɔ li bee kɛ, be kɛmi yɛ findzɔŋ kɛ. Se nuuŋ le, be kɛmi yɛ fiee fi be nuuŋ be makɛ bimfimu bibifi bi bee lu dɛɛni kɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wi wu baanini mi, kɛ mwɛ baaninɔɔ Baa wɛŋ tɛ. ");
INSERT INTO asj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bee le ni mɛɛŋ ki niiŋ kɛ ŋwaani nimɛ chi wi mɛɛŋɔ saa ki niiŋ kɛ lɛ bee lɛnti chini kɛ, bee nuuŋ be kɛmi yɛ chɔ kɛ. Se nuuŋ le be ŋɛŋ baa mfiŋ, be se tuu be baanini mi mɔɔ Baa wɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Fini nuuŋ le fi bɛ fi fɛ jɛ bɛ yi kɔchɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki bɛnchi bɛ bee le, ‘Bɛ baanini mi li yee li.’ ");
INSERT INTO asj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Se nuuŋ le, Wi wu Mfiɛ wu ŋgii ntuumi nuuŋ wu dzɛti fɛ Baa wɛ-ɛŋ. Wi wu Mfiɛ wuni nuuŋ Fiana yi chɛɛŋ yi dzɛti fɛ Baa wɛ-ɛŋ. Mfi wu yi bɛ, yi gii yi leŋ lɛ nsa wɛŋ lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nɛ gii nɛ leŋ tɛ lɛ nsa wɛŋ lɛjiŋ, kifɛ tɛɛbeŋ tɛ tɛ̀ nuuŋ fɛmbɛɛchɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ntiitɔɔ biee bini bichu li be-eŋ le kiiŋ nɛ ni we li kimbeenchɛ kinɛ-ɛ lijiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bɛ gii bɛ kooŋ beŋ li yíh yi be yi kintaashɛ kii chɛɛŋ, mfi bɛɛɔ wu ke wi wu wuu beŋ, ni beechi le fetɔɔ nuuŋ nimɛ chi dzeeŋ li Nyɔ-ɔ lɛnti. ");
INSERT INTO asj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Be gii be ni be feti lɛ, kifɛ be mɛɛŋ baa saa ki kɛɛ kɛ Baa wɛŋ mɔɔ mi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ntiitɔɔ beŋ biee bini bichu lɛ le ke mfi wulu kɔchɛ, nɛ kimi le ntɛ̀ nsaa mi ntee beŋ kii bi. Nti mɛɛŋ ki ntee kɛ beŋ biee bini fɛmbɛɛchɛ-ɛ kɛ, kifɛ ntɛ̀ nuuŋ tɛɛbeŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dɛɛni ntuuɔ lijiŋ lɛ wi wu tɛ̀ toŋ mi-i. Se nuuŋ le, wunɛ wumu mɛɛŋɔ mɔɔ ki bii kɛ li mi-i laa ŋgiiŋgi fɛŋ le kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nɛ baa nshiiŋ nshiiŋ kifɛ mbee ŋkɔɔ mi ntee biee bini li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mɔɔ nuuŋ si fi nuuŋ lɛ, ntee beŋ chɛɛŋ le, ɛ fiee fi dzeeŋ li be-eŋ le ŋgɛɛŋ. Ɛ mɛɛŋ ki gɛɛŋ kɛ, Wi wu Mfiɛ wɛ tɛ̀ bɛ lɛ be-eŋ kɛ. Se nuuŋ le, ɛ mi ŋgɛɛŋ, nse ntuumi wu li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ke wu bɛ, gii tɔchɛ bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i, fɛ be ŋɛŋ bibifi bibee, fɛ be ŋɛŋ fiee fi nuuŋ ntsɛ wu tsaaŋ, fɛ tɛ be ŋɛŋ fi nuuŋ nsawu wu nuuŋ wu Nyɔ. ");
INSERT INTO asj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gii fɛ be ŋɛŋ bibifi bi bee si be mɛɛŋ ki gɛɛ kɛ shéŋ li mi-i kɛ, ");
INSERT INTO asj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","fɛ be ŋɛŋ fiee fi nuuŋ ntsɛ wu tsaaŋ, si ŋgiiŋgi lɛ Baa wɛ-ɛŋ lɛ, nɛ mɛɛŋ yɛ nɛ tuu nɛ ŋɛŋ mi kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gii fɛ be ŋɛŋ fiee fi nuuŋ nsawu wu Nyɔ kifɛ mfɔŋ wu sɛki nshɛ yini, nsa kɔɔ wɛ wu kituŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mmɛɛŋɔ ŋkɛmi nɛɛ biee ŋge bi tefɛ li be-eŋ, se nuuŋ le bi nuuŋ tɛ lɛ li bintooŋ binɛ-ɛ dɛɛni bujɔŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mfi wu Fiana yi chɛɛŋ gii yi bɛ, yi gii yi fɛ nɛ se kɛɛ chɛɛŋ wulu kwikwi. Yi nuuŋ tɛ tuu le yi ni yi yeti li buŋga bu yi-i kɛ. Fiee fichu fi yi woo ɛ fi fi yi gii ni yi tiiti, yi se tuu yi tee beŋ biee bi gii bi bɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yi gii yi doonchɛ bunɔŋa bweŋ, si yi gii yi ni yi dzeti nuuŋ fiee fi nuuŋ fieŋ yi tiiti li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fiee fi Baa wɛŋ fichu nuuŋ fieŋ. Ɛ nɛɛ fi fi ntiiti le yi gii yi ni yi dzeti nuuŋ fiee fi nuuŋ fieŋ yi tiiti li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Shɛɔ niiŋ nɛ tɛ tuu le nɛ ŋɛŋ mi kɛ, ke tuu ŋɔɔnɛ niiŋ nɛ kaari nɛ ŋɛŋ mi.” ");
INSERT INTO asj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Si Jiso tɛ̀ tee lɛ, bɔɔŋ bee bɛ kintutu-u bamu yɔ li yi yi bee le, “Fini nuuŋ la fi tiiti li bee li le, shɛɔ niiŋ tɛɛbeŋ tɛ tɛ̀ ŋɛŋ wu kɛ, ke tuu ŋɔɔnɛ niiŋ tɛ ŋɛŋ wu, bɛ le giiŋgɔɔ lɛ Tee li? ");
INSERT INTO asj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Fiee fi kweŋgi le shɛɔ nɛɛ niiŋ nuuŋ le la? Tɛɛbeŋ mɛɛŋ baa ki kɛɛ kɛ fiee fi tiiti lɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jiso kɛɛ le be wɛki baa le be bii wu fiee fi tiiti, se bii li bee laa, “Nɛ yeti beŋ beŋ kii fiee fi mi ntee le, ‘Shɛɔ niiŋ nɛ tɛ ŋɛŋ mi kɛ, ke tuu ŋɔɔnɛ niiŋ nɛ tuu nɛ kaari nɛ ŋɛŋ mi ni’? ");
INSERT INTO asj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ntee beŋ chɛɛŋ chɛɛŋ le, nɛ gii nɛ ni nɛ dii kwe, nɛ shiŋini bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini ni be nɛki fi bee bunɛwu. Nɛ gii nɛ ni nɛ nuuŋ li nshiiŋ li, se nuuŋ le nshiiŋ yinɛ yini gii yi dza yi to kinɛɛtinɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kwɛɛŋ bɛɛ fɛ tundi, wuki ntɔnyɛ, kifɛ mfi we wu biɛrɔ kɔchɔɔ. Mfi wu wu biɛ ŋwaŋ, tɛ tuu le kimi ntɔnyɛ wulu kɛ, kifɛ wukɔɔ nuuŋ bujɔŋ le wiwoŋ tuuɔ wu bɛ li nshɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ɛ lɛ si fi fiɛɛ bɛ beŋ dɛɛni. Nɛ baa nshiiŋ nshiiŋ lɛ ke mi ŋkaari, mi ŋɛŋ beŋ, nɛ se kɛmɛ nuuŋ kinɛɛtinɛ li shéŋ yinɛ-ɛ, ŋwaani kinɛɛtinɛ ki kɛɛ kɛɛ ki wi nuuŋ tɛ naa fi li be-eŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Gii ni nuuŋ li mfi wɛɛ, nɛ tɛ tuu le nɛ bii mi fiee fimu kɛ. Ntee beŋ chɛɛŋ chɛɛŋ le, ɛ nɛ bii mɔɔ nuuŋ la li Baa wɛ-ɛŋ li bukooŋ bwe-eŋ, kɛ gii nyɛ beŋ fiee filu. ");
INSERT INTO asj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fɛ mbɛɛchɛ mbɛ mbochu dɛɛni, nɛ mɛɛŋ baa ki bii kɛ fiee li Baa wɛ-ɛŋ, li bukooŋ bwe-eŋ kɛ. Bii yɛɛŋ, nɛ gii nɛ kɛmɛ, ke kinɛɛtinɛ kinɛ se yisɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","N'yetɔɔ n'yɔru wuni nuuŋ lɛ ŋkuŋ lɛ ŋkuŋ, se nuuŋ le mfi bɛɛɔ wu nnuuŋ ntɛ ntuu le n'yɔ li be-eŋ lɛ ŋgaŋgaa li kɛ. Ŋgii n'yɔ li be-eŋ gbanaa lɛ kii Baa wɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Gii ni nuuŋ li mfi wɛɛ nɛ bii fiee li Baa wɛ-ɛŋ li bukooŋ bwe-eŋ. Ntiiti yɛ li be-eŋ le ŋgii nlɛkɛ fiee li Baa wɛ-ɛŋ li kii be-eŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Baa wɛŋ kibɛɛ kɔŋgisɔɔ beŋ, kifɛ nɛ kɔɔŋgi baa mi nɛ beenchi tɛ le mi ndza fɛ Baa wɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ntɛ̀ dza fɛ Baa wɛ-ɛŋ mbɛ li nshɛ yini-i, nse ntuuɔ ndzɛti li nshɛ yini-i ntuu lɛ Baa wɛ-ɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Si Jiso tɛ̀ yɔ lɛ, bɔɔŋ bee bɛ kintutu-u pia bu piaru, be tee le, “Ɛŋhɛɛŋ! Ɔ yetɔɔ dɛɛni, gbanaa nuuŋ yɛ lɛ ŋkuŋ lɛ ŋkuŋ kɛ! ");
INSERT INTO asj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dɛɛni tɛ ŋɛŋ baa le ɔ kii biee bichu ɔ tɛŋgi yɛ le wi ni biiti fiee li wɛ-ɛ bu bifu kɛ. Fini fɛ fiɛɛ tɛ se beŋ le ɔ dza fɛ Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jiso tuu li bee le, “Nɛ se beŋ baa dɛɛni ni? ");
INSERT INTO asj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mfi bɛɛɔ, wu se bɛɛɔ kituŋ, wu nɛ gii nɛ saaŋgɛ mumkpaŋ mumkpaŋ wi ni giiŋgi li wu-u yih, nɛ shɛ mi mbiiŋ. Se nuuŋ le nnuuŋ yɛ mi mbiiŋ kɛ, kifɛ Baa wɛ-ɛŋ wɛ bɛ mi. ");
INSERT INTO asj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ntiitɔɔ biee bini li be-eŋ le ke, si nɛ nuuŋ li mi-i ni, nuuŋ nɛ ni nɛ kɛmi mbɛɛŋgii. Li nshɛ yini-i nɛ ŋiŋgi baa ŋgɛ, se nuuŋ le nɛ ni nɛ kɛndi shéŋ. Mi n'yaaɔ nshɛ yini kituŋ.” ");
INSERT INTO asj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Le Jiso yɔ n'yɔru wuni mɛɛshi, dza tsaaki lii bichɛ liwe lɛkɛ li Nyɔ-ɔ le, “Baa wɛŋ, mfi kɔchɔɔ kituŋ. Doonchɛ bunɔŋa bu Ŋwana ke Ŋwaŋ doonchɛ tɛ bunuŋa bwo. ");
INSERT INTO asj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nuuŋ doonchɛ kifɛ ɔ nyɛɔ buŋga li wuu lɛ wi kwikwi-i lɛwe le nyɛ ntsɛ wu kimakɛ li be bɛchu bɛ ɔ tuu ɔ nyɛ li wu-u. ");
INSERT INTO asj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ntsɛ wu kimakɛ wuni wɛ nuuŋ le be ni be kii wɛ wu nuuŋ Nyɔ yi chɛɛŋ kwaa, mɔɔ le be kɛɛ tɛ mi wu Jiso Krai wuɔ tɛ̀ toŋ. ");
INSERT INTO asj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi ndoonchɔɔ bunɔŋa bwo li nshɛ-ɛ, si mi mɛɛshi nimɛ chi ɔ tɛ̀ nyɛ le niŋ. ");
INSERT INTO asj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Li dɛɛni Baa wɛŋ, kaari ɔ nyɛ mi bunɔŋa li wɛɛ mfwe bu ntɛ̀ nsaa ŋkɛmi ŋkosi nshɛ bee kiboo mɛɛŋ se naa bɛchi. ");
INSERT INTO asj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mi ndoonchɔɔ wɛ li bɛniiŋ bɛ ɔ tɛ̀ tsaa li nshɛ yini ɔ nyɛ li mi-i baa. Bɛniiŋ bani tɛ nuuŋ bo, ɔ se tuu ɔ nyɛ be li mi-i. Be woo baa li jɛ ya-a. ");
INSERT INTO asj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Be kii baa dɛɛni kituŋ le fiee fichu fi ŋkɛmi dzɛti nuuŋ fɛ wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ntiitɔɔ ni kifɛ mi nyɛɔ jɛ yi ɔ tɛ nyɛ li mi-i yɛ li bee, be fi, be se kii baa chɛɛŋ le ntɛ̀ dza nuuŋ fɛ wɛ-ɛ, be beŋ baa tɛ le ɛ wɛ wu tɛ̀ toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nlɛkɔɔ li Nyɔ-ɔ ni, nuuŋ li bani-i. Nlɛki yɛ nuuŋ li baa bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini kɛ. Nlɛkɔɔ li Nyɔ-ɔ ni nuuŋ li bɛ ɔ tɛ̀ nyɛ li mi-i bani, kifɛ ɛ bɛniiŋ bo. ");
INSERT INTO asj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Biee bichu bi ŋkɛmi nuuŋ bio, se biee bichu bi ɔ kɛmi nuuŋ tɛ bieŋ. Ɛ li bɛniiŋ bani-i li bunɔŋa bweŋ yeŋgi. ");
INSERT INTO asj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dɛɛni, mɛɛŋ yɛ ntuu nnuuŋ li nshɛ yini-i kɛ. Se nuuŋ le, be mɛɛŋ baa li nshɛ yini-i, ŋkarisɔɔ mbɛɛ lɛ wɛ-ɛ. Baa wu wuuti, gɛɛ be li bukooŋ bwo bu ɔ tɛ̀ nyɛ li mi-i, ke be se ni be nuuŋ li fiee fi mumkpa-aŋ nɛɛ si tɛɛ wɛ tɛ nuuŋ li fiee fi mumkpa-aŋ. ");
INSERT INTO asj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mfi wu ntɛ̀ nuuŋ tɛɛ be, ntɛ̀ ŋgɛɛ be li bukooŋ bwo bu ɔ tɛ̀ nyɛ li mi-i. Ntɛ̀ ŋkiichɛ be, wi wumu li bee linti ti mɛɛŋ ki la kɛ, fuki nɛɛ wi wu nuuŋ le gii la wɛ nsiŋ. Fini tɛ̀ nuuŋ le fiee fi bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ bɛ fi kɔchɛ. ");
INSERT INTO asj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dɛɛni ŋkarisɔɔ mbɛɛ lɛ wɛ-ɛ, se biee bini ntiitɔɔ mɛɛŋ li nshɛ yini-i ke bɛniiŋ beŋ se kɛmɛ kinɛɛtinɛ keŋ ki yisɛ li bee. ");
INSERT INTO asj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ntɛ̀ nyɛ jɛ ya li tsaŋ yi bee, bɛniiŋ bɛ li nshɛ yini-i se baanini be kifɛ be nuuŋ yɛ bɛniiŋ bɛ li nshɛ yini-i kɛ, nɛɛ si nuuŋ yɛ tɛ wi wu li nshɛ yini-i kɛ. ");
INSERT INTO asj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nlɛki yɛ nuuŋ le ɔ buu be li nshɛ yini-i kɛ. Nlɛkɔɔ nuuŋ le ɔ ni ɔ kiichi be le be lɛ kɛ li tsaŋ yi wi wu bifi wɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Be nuuŋ yɛ bɛniiŋ bɛ li nshɛ yini-i kɛ, nɛɛ si nuuŋ yɛ tɛ wi wu li nshɛ yini kɛ. ");
INSERT INTO asj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nachɛ be ɔ gɛɛ chichi be ni be wuuti lɛ chɛɛŋ li lɛnti. Jɛ ya nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Si ɔ tɛ̀ toŋ mi li nshɛ yini-i, ɛ nɛɛ lɛ si mi ntoŋɔ tɛ be li nshɛ yini-i. ");
INSERT INTO asj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Si mi nachɔɔ yi yɛŋ mi ŋkiri chichi kii be, le nuuŋ be nachɛ tɛ yi yi be, be gɛɛ chichi li chɛɛŋ li. ");
INSERT INTO asj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nlɛki yɛ li Nyɔ-ɔ nuuŋ li bɛniiŋ bani-i kwaa kɛ. Nlɛkɔɔ tɛ li bɛniiŋ bɛchu bɛ gii be woo jɛ yibe, be gɛɛ shéŋ li mi-i. ");
INSERT INTO asj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nlɛkɔɔ le be bɛchu ni be nuuŋ li fiee fimumkpa-aŋ nɛɛ si wɛ wu Baa wɛ-ɛŋ nuuŋ li mi-i, nse nuuŋ tɛ li wɛ-ɛ. Nlɛkɔɔ tɛ le be ni be nuuŋ li tɛɛ wɛ ke bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i se beŋ le ɛ wɛ wu tɛ̀ toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bunɔŋa bu ɔ tɛ̀ yooki mi lu, mi nyɛɔ li bee kituŋ ke be se ni be nuuŋ li fiee fimumkpa-aŋ, nɛɛ si tɛ tɛ̀ nuuŋ li fiee fimumkpa-aŋ, ");
INSERT INTO asj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mi ŋ'wɛ li bee, ɔ se nuuŋ tɛ li mi-i. Le be ni be gbɛŋgi be nuuŋ li fiee fimumkpa-aŋ, bɛdɛɛni bɛniiŋ bɛ nuuŋ li nshɛ yini-i se kɛɛ le ɛ wɛ wu tɛ toŋ mi, ɔ se kɔŋgisɔɔ be nɛɛ si ɔ kɔŋgisi mi. ");
INSERT INTO asj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baa wɛŋ, ŋ'wɛkɔɔ le be bɛ ɔ tɛ̀ nyɛ li mi-i baa be naa nuuŋ tɛ fɛ nnuuŋ, ke be se ŋɛŋ bunɔŋa bu ɔ tɛ nyɛ li mi-i kii kiŋkɔŋgisɛ ko li mi-i fɛ nshɛ bee kiboo tɛ̀ bɛchi. ");
INSERT INTO asj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Hooo Baa wɛŋ wu nuuŋ tsaaŋ, bɛniiŋ bɛ nuuŋ bɛ li nshɛ yini-i kii yɛ wɛ kɛ, bɛdɛɛni ŋkiiɔ wɛ, bɛniiŋ beŋ bani kɛɛ baa tɛ le ɛ wɛ wu tɛ̀ toŋ mi. ");
INSERT INTO asj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi mfɛɔ be kɛɛ wɛ kituŋ, nse mmɛɛŋɔ ni mfeti be ni be kii wɛ, ke kiŋkɔŋgisɛ ki ɔ kɔɔŋgi mi lu ni ki nuuŋ li bee, nse ni nnuuŋ tɛ li bee.” ");
INSERT INTO asj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Le Jiso lɛkɛ li Nyɔ-ɔ mɛɛshi, bee bɔɔŋ bee bɛ kintutu-u dza fe, be gɛɛŋ be lenchi kinɛɛŋ ki bɛ teenyi le Kidrɔŋ, be bo liwiŋ lɛ wɛ wu biti bi muntaaŋ bimu-u, be lɛ lu. ");
INSERT INTO asj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ɛ Judas wu tɛ̀ kabɛ Jiso wɛ tɛ̀ kii tɛ kintsii kilu, kifɛ Jiso bee bɔɔŋ bee bɛ kintutu-u tɛ̀ shiiŋ be giiŋgi be taashi fe mfi kwi. ");
INSERT INTO asj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas se gɛɛŋ fe bɛ kintutu ki bɛniiŋ bɛ nchi-i mɔɔ bɛniiŋ bamu bɛ tɛ̀ kiichi yi yi muntofi. Bɛniiŋ bani tɛ̀ nuuŋ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ Bɛfarasii. Be tɛ̀ giiŋgi be kɛmi bitesinɛ bi wi-i bɛ bitesinɛ bi bɛ tɔŋ mɔɔ biee bi dziiŋ. ");
INSERT INTO asj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Si Jiso tɛ̀ kii fiee fi tɛ̀ nuuŋ le fi gii fi ka bɛ wu lɛ, kiiŋgi bɛ be limfwe, bii li bee laa, “Nɛ wɛki nuuŋ noo?” ");
INSERT INTO asj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Be tuu li wuu le, “Jiso wu Nasarɛ.” Jiso tee li bee le, “Ɛ mi wu wu.” Tɛ nuuŋ ɛ Judas wu tɛ̀ kabɛ wu wɛ tɛ̀ lemi bee bɛniiŋ bɛlu. ");
INSERT INTO asj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Si Jiso tɛ̀ tee li bee le ɛ wu lɛ, be kaari be to lijiŋ lijiŋ, be weyɛ fɛkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tuu bii li bee laa, “Nɛ wɛki nuuŋ noo?” Be tuu le, “Jiso wu Nasarɛ.” ");
INSERT INTO asj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jiso tee li bee le, “Mi nteeɔ beŋ le ɛ mi wulu. Ɛ nɛ wɛki nuuŋ mi, nɛ gɛɛ bɛniiŋ bani be ni be giiŋgi.” ");
INSERT INTO asj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tɛ̀ yɔ le fi bɛ fi kɔchɛ bɛ jɛ yi tɛ̀ saa wu tee li Nyɔ-ɔ le tɛ̀ mɛɛŋ ki lɛɛ kɛ wi mumkpaŋ li bɛniiŋ bɛ tɛ̀ nyɛ li wuu baa kɛ. ");
INSERT INTO asj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simu Pita tɛ̀ kɛmi nyɔ yi dziŋ. Biee buu lɛ mbwa-a, kɛri kintooŋ ki mfwa wu kikoo ki bɛte muntofi ki kigɔŋɛ lu, sondɛ. Bukooŋ bu mfwa wulu tɛ̀ nuuŋ le Malku. ");
INSERT INTO asj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jiso tee li Pita le, “Kaari tuu nyɔ ya lɛ mbwa-a. Mi ŋ'woŋ kɛ fika fi ŋgɛ-ɛ fi Baa wɛŋ nyɛ li mi-i fini ni?” ");
INSERT INTO asj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kikoo ki bɛniiŋ bɛ nchi-i bɛ kintutu ki bɛniiŋ bɛ nchi-i mɔɔ bɛniiŋ bɛ tɛ̀ kiichi yih yi muntofi yi Bɛjuu se cha Jiso, be kaŋ wu bɛ bɛkuu. ");
INSERT INTO asj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Be saa be dzɔ wu be gɛɛŋ bɛ wu fɛ Anas, kifɛ Anas tɛ̀ gii nuuŋ gwenɛ Kaifas wu tɛ̀ nuuŋ kikoo ki bɛ te muntofi-i li kiya kilu-u. ");
INSERT INTO asj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifas wuni nuuŋ wu tɛ̀ saa wu tifi Bɛjuu le fi dzɔɔŋ le wi mumkpaŋ kwi kii bɛniiŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si be tɛ̀ giiŋgi bɛ Jiso lɛ, Simu Pita bɛ ŋwanɛ kintutu ki Jiso wumu tɛ̀ biki wu. Ŋwanɛ kintutu wu Jiso wuni tɛ̀ nuuŋ kikoo ki bɛte muntofi-i tɛ̀ kii wu, tuu biee Jiso gɛɛŋ lɛ kintikinti ki la wu kikoo ki bɛte muntofi-i. ");
INSERT INTO asj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita shɛ lemi lɛkuuŋ li fweeŋ wu mbaŋ lichiŋ. Ŋwanɛ kintutu wu Jiso wulu wu kikoo ki bɛte muntofi tɛ̀ kii wɛ, kaari bo bɛ yɔ bɛ ŋwaakwɛɛŋ wu tɛ̀ kiichi fweeŋ wu mbaŋ wɛ, dzɔɔ Pita ɔ lɛ bɛ wu. ");
INSERT INTO asj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ŋwaŋ wu kwɛɛŋ wulu bii li Pita laa, “Mɔɔ ɔ nuuŋ tɛ wi wu kintutu ki wi wuni?” Pita tuu le, “Nuuŋ yɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tɛ̀ nuuŋ ɛ lɛkuuŋ tɛ̀ dendi, bɔɔŋ bɛ nimɛ-ɛ bɛ bɛniiŋ bɛ tɛ̀ kiichi yih yi muntofi baa kukɛ wi be lemi fe be wɔɔnsi. Pita se ka, gɛɛŋ leŋ bee be wɔɔnsi tɛ. ");
INSERT INTO asj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kikoo ki bɛte muntofi-i se biiti biee li Jiso-o kii bɔɔŋ bee bɛ kintutu mɔɔ kii ntiifɛ we. ");
INSERT INTO asj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jiso tuu li wuu le, “Nti n'yeti li nshɛ chichi-i gbanaa. Nti ntiifi tɛ bɛniiŋ li yih yi nlɛkɛ li Nyɔ-ɔ mɔɔ li yih yi muntofi-i yi Bɛjuu bɛchu banchi. Nti ntiiti yɛ fiee lɛ munyiikɔɔ li kɛ. ");
INSERT INTO asj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ɔ biiti biee bini nuuŋ li mi kii la? Ɔ biiti nuuŋ li bɛniiŋ bɛ ti wuki si ntiifi. Be kii baa fiee fi nti ntiiti.” ");
INSERT INTO asj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Si Jiso tɛ̀ yɔ lɛ, wi wumu wu kintutu ki bɛniiŋ bɛ tɛ̀ kiichi yih yi muntofi wu tɛ̀ lemi fɛ wu-u fɛchiŋ sooŋ wu bɛ kibɛnɛ lɛ ntooŋ, bii li wu-u laa, “Yini nuuŋ dze yi ɔ tusi fiee li kikoo ki bɛte muntofi-i ni?” ");
INSERT INTO asj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jiso bii li wu-u laa, “Ɛ nuuŋ le mi n'yɔ bubiɛɛ, ɔ doonchɛ bubiɛɛ bulu. Ɛ ntiiti nuuŋ chɛɛŋ, ɔ se tuu ɔ sooŋ mi kii la?” ");
INSERT INTO asj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas se dza tuumi Jiso lɛ Kaifas wu kikoo ki bɛte muntofi. Jiso mɛɛŋ nɛɛ kiŋkaŋ bɛ bɛkuu. ");
INSERT INTO asj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Simu Pita tɛ̀ mɛɛŋ lemi wɔɔnsi wi lɛ, bɛniiŋ bii li wu-u laa, “Ɔ nuuŋ nɛɛ wi wumu li kintutu ki bɛniiŋ bee li ni?” Se nuuŋ le, Pita tɛ faaŋ tee le, “Nnuuŋ yɛ wube wumu kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ŋwanɛ nimɛ wu kikoo ki bɛte muntofi-i wumu tuu bii li Pita laa, “Mbee ŋɛŋ nɛɛ wɛ nɛɛ wu lɛ wɛ wu mbaŋ wɛɛ ni?” Ŋwanɛ nimɛ wulu tɛ̀ nuuŋ kini ki wi wu Pita tɛ̀ sondɛ kintooŋ kee wɛ. ");
INSERT INTO asj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita tuu ka faaŋ. Nɛɛ li mfi wulu, nyinɛshee se tɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bɛniiŋ bɛlu se dzɔ Jiso fɛ yih yi Kaifas be giiŋgi bɛ wu lɛ ntɔ wu Mfɔŋ wu Lo-om wu tɛ gii sɛki le. Ɛ tɛ̀ mɛɛŋ taantaaŋ. Be gɛɛŋ be ba nlɛ lɛ ntɔ nsiŋ, kifɛ ɛ be lɛ le be liibi bikoo bi bee, si be tɛ̀ nuuŋ le be gii be ji Tsɔnɔ chi N'yafuwee lɛ. ");
INSERT INTO asj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Se nuuŋ le Pailɛt se bo ŋɛŋ be bii li bee laa, “Fiee fi nɛ ŋɛŋ le wi wuni bee chɔ nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Be tuu li wu le, “Ɛ wi wuni bee mɛɛŋ ki chɔɔ fiee kɛ, bee nuuŋ tɛ bɛɛ bɛ wu le tɛ̀ nyɛ li wɛɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailɛt tuu li bee le, “Dzɔɔ yɛŋ wu nɛ saa biki si nchi wunɛ wɛki.” Bɛjuu tee li wu-u le, “Tɛ kɛmi yɛ buŋga bu wo wi kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","N'yɔru wuni se bɛ kɔchɛ bɛ n'yɔru wu Jiso tɛ̀ saa tiiti doonchi ŋwaani kwe yi gii kwi. ");
INSERT INTO asj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailɛt kaari gɛɛŋ lɛ lɛ ntɔ we-e, teeŋ be, bɛ bɛ Jiso, bii li wu-u laa, “Ɛ wɛ mfɔŋ wu Bɛjuu ni?” ");
INSERT INTO asj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jiso bii li wuu laa, “Ɔ tiiti fini nuuŋ mbeechɛ wu wa, mɔɔ bɛniiŋ bamu bɛ tee wɛ kii mi le?” ");
INSERT INTO asj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailɛt bii li wu-u laa, “Ɛ mi wi wu Bɛjuu ni? Ɛ bɛniiŋ bo bɛ kwɛɛŋ lɛ bɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛ wɛ be nyɛ li mi-i. Ɔ chɔ nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jiso tuu li wu-u le, “Bumfɔŋ bweŋ nuuŋ yɛ si bu li nshɛ yini-i kɛ. Bee le bumfɔŋ bweŋ ni bu nuuŋ si bu li nshɛ yini-i, bee nuuŋ bɛniiŋ beŋ bɛ nimɛ-ɛ be gwii le kiiŋ bɛ ni nyɛ mi li tsaŋ yi Bɛjuu li kɛ. Se nuuŋ le bumfɔŋ bweŋ nuuŋ yɛ bu dza li nshɛ yini-i kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailɛt se bii li wu-u laa, “Ɛ wɛ mfɔŋ ni?” Jiso tuu li wuu le, “Fi fiɛɛ si ɔ tee le ɛ mi mfɔŋ. Bɛ tɛ̀ biɛ mi, mbɛ li nshɛ yini-i kii fini le mbɛ ntee kii chɛɛŋ. Wi kwikwi wu biki chɛɛŋ ti wuki jɛ yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailɛt bii laa, “Chɛɛŋ nuuŋ la?” Si tɛ̀ bii lɛ, tuu kaari bo gɛɛŋ ŋɛŋ Bɛjuu baa, tee li bee le, “Mmɛɛŋɔ ki ŋɛŋ fiee fi wu chɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Se nuuŋ le nɛ kɛmi ntsɛ wunɛ wumu le ɛ nuuŋ mfi wu Tsɔnɔ chi N'yafuwee, mbuu wi wu ncha mumkpaŋ li yih yi ncha-a. Nɛ wɛki le mbuu nuuŋ Mfɔŋ wunɛ wu Bɛjuu ni?” ");
INSERT INTO asj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bɛjuu bɛlu waŋ lɛwe ŋge le, “Aay, tɛ wɛki yɛ wi wuni kɛ, buu nuuŋ Baraba!” Baraba wuni tɛ̀ nuuŋ wi wu kintutu ki bɛniiŋ bɛ tɛ̀ gwii bɛ bara wu Lom. ");
INSERT INTO asj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailɛt se dzɔ Jiso nyɛ le bɛ lichɛ wu. ");
INSERT INTO asj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bɛniiŋ bɛ nchi-i lo kifɔ ki bumfɔŋ ki nuuŋ biaŋ biaŋ be beeŋ wu lifa, be dzɔ ndu yi bumfɔŋ yi gaa, be chuumɛ wu li bwiŋ. ");
INSERT INTO asj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Be se bɛɛ fɛ wuu, be bundi wu, be tiiti le, “Buri! Mfɔŋ wu Bɛjuu!” Si be feti lɛ be maami wu bɛ bibɛnu. ");
INSERT INTO asj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailɛt se tuu bo lɛkuuŋ tee li bee le, “Bichɛ yɛɛŋ, ŋgii mbuu wi wuni nyɛ li be-eŋ, nɛ se kɛɛ le mmɛɛŋɔ ki ŋɛŋ fiee fi wu chɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jiso se bo bɛɛ bɛ kifɔ ki bíaŋ lifa mɔɔ ndu yi bumfɔŋ yɛ li wu-u bwiŋ. Pailɛt se tee li bee le, “Bichɛ yɛɛŋ nɛ ŋɛŋ wuuŋ wi wulu!” ");
INSERT INTO asj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ tɛ̀ kiichi yih yi muntofi ŋɛŋ wu lɛ, be se wɛndi le, “Ta wu li kintaaŋ li, ta wu li kintaaŋ li!” Pailɛt tee li bee le, “Dzɔɔ yɛɛŋ wu bɛ tsaŋ yinɛ nɛ taaŋ wu li kintaaŋ li, kifɛ mɛɛŋɔ ki ŋɛŋ chɔ ye kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bɛjuu bɛlu tuu li wuu le, “Tɛ kɛmi baa nchi wusɛŋ, ɛ nchi wulu wu doonchi le kɛmi le kwi, kifɛ wu fɛɔ yi yee le, ɛ wu Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Le Pailɛt woo n'yɔru wuni lɛ, se tuu kɛmɛ chɛnɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bee Jiso tuu be to lɛjiŋ lɛ ntɔ, bii li Jiso laa, “Ɔ dza fɛŋ?” Se nuuŋ le Jiso ti mɛɛŋ ki tuu kɛ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailɛt bii li Jiso-o laa, “Ɔ nuuŋ tɛ yɔ li mi kɛ ni? Ɔ kii yɛ le ŋkɛmi buŋga bu chiiŋgɛ li wɛ-ɛ, ntuu ŋkɛmi buŋga bu tefɛ le bɛ taaŋ wɛ li kintaaŋ li ni?” ");
INSERT INTO asj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jiso tuu li wuu le, “Nuuŋ ɔ tɛ kɛmɛ buŋga lɛ mi lɛwe, fuki fɛ bɛ nyɛ buŋga bulu li wɛ-ɛ liboo nsiŋ kɛ. Se nuuŋ le kii fini, wi wu nyɛ mi li tsaŋ ya ɛ wi wu kɛmi bubiɛɛ bu kuu bu yɛki bwo.” ");
INSERT INTO asj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Le Pailɛt woo n'yɔru wuni ni, se bɛchi wɛki dze le chinɛ li wuu. Se nuuŋ le Bɛjuu tɛ̀ waŋ lɛwe ŋge le, “Ɔɔ mɔŋ ɔ chinɛ li wi wuni, kɛ ɔ nuuŋ yɛ nsaŋ yi Kaisa wu Mfɔŋ wu nyɔŋa wu Lom kɛ. Wi kwi wu yɛkisi yi yee le mwɛ nuuŋ mfɔŋ kɛ mwɛ wɛ wi wu mbani wu Kaisa.” ");
INSERT INTO asj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Le Pailɛt tuu woo ŋwani wuni n'yɔru, se bo bee Jiso, shee li kintindɛ ki nsa-a fɛ be tɛ̀ teenyi le, Kintsii ki bɛ gwaŋ bɛ Ta, ki bɛ teenyi lɛ jɛ́ yi Hiburu le Gabata. ");
INSERT INTO asj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tɛ̀ nuuŋ Jobɛ chi Nachɛ kii Tsɔnɔ chi N'yafuwee, ɛ mfi tɛ̀ nuuŋ si jobɛ bikaa yoofi ntsɔ bifɛɛtu. Pailɛt tee li Bɛjuu li le, “Bichɛ yɛɛŋ nɛ ŋɛŋ, wuuŋ Mfɔŋ wunɛ!” ");
INSERT INTO asj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bɛjuu bɛlu bɛchi be dzɛŋgi le, “Gɛnɛ bɛ wu, gɛnɛ bɛ wu, ta wu li kintaaŋ li!” Pailɛt bii li bee laa, “Ntaaŋ Mfɔŋ wunɛ li kintaaŋ li ni?” Bɛte muntofi bɛ nɔŋa bɛ nɔŋa baa tuu li wuu le, “Tɛ kɛmi yɛ Mfɔŋ wumu kɛ fuki Kaisa nsiŋ.” ");
INSERT INTO asj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pailɛt se nyɛ Jiso li bee le be gɛɛŋ be taaŋ wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Be se dzɔ Jiso, be bo bɛ wu. Too kintaaŋ kee giiŋgi fɛ kintsii ki bɛ teenyi le Kiŋgefi, bɛ teenyi lɛ jɛ́ yi Hiburu li le Gɔɔgɔɔta. ");
INSERT INTO asj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Be se gɛɛŋ be ta wu fe li kintaaŋ li, be ta tɛ bɛniiŋ bamu bɛfɛ li bintaaŋ li wumu lɛ kigɔŋɛ, wumu lɛ kimɛsɛ, Jiso nuuŋ kintikinti. ");
INSERT INTO asj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailɛt tsɛɛ fiee fimu bɛ ta li kintaaŋ ki Jiso-o. Fiee fi tɛ̀ tsɛɛ filu tɛ̀ nuuŋ le, “Jiso wu Nasarɛ, Mfɔŋ wu Bɛjuu.” ");
INSERT INTO asj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bɛjuu ŋge tɛ̀ teeŋ fiee fi tɛ̀ tsɛɛ filu, kifɛ fɛ be tɛ̀ ta Jiso li kintaaŋ li tɛ̀ nuuŋ tsɛkɛtsɛkɛ li kitoŋ kilu lichiŋ, tɛ̀ tsɛɛ fiee fini lɛ jɛ́ yi Hiburu bɛ yi Latin mɔɔ yi Grik. ");
INSERT INTO asj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ Bɛjuu gɛɛŋ be tee li Pailɛt le, “Kiiŋ ɔ ni tsɛɛ le, ‘Mfɔŋ wu Bɛjuu kɛ.’ Tsɛɛ nuuŋ le, ‘Wi wuni kweŋgɔɔ le nuuŋ Mfɔŋ wu Bɛjuu.’” ");
INSERT INTO asj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailɛt tuu li bee le, “Fiee fi mi ntsɛɛ mi ntsɛɛɔ kituŋ.” ");
INSERT INTO asj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Si bɛniiŋ bɛ nchi-i baa tɛ̀ ta Jiso li kintaaŋ li lɛ, be dzɔ ndú yee be gachɛ li yi yibe bintsii binɛɛ si be tɛ̀ nuuŋ. Be tuu be dzɔ mɔɔ kiŋkoŋ kee. Se nuuŋ le kiŋkoŋ kini bɛ tɛ̀ toŋ ki mbaru nsiŋ mbɛɛchɛ li kimi mbɔɔwu mbochu li bikaa li. ");
INSERT INTO asj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bɛdɛɛni be se tee li yi yi bee le, “Kiiŋ tɛ ni gaamɛ kiŋkoŋ kini kɛ. Tɛɛbeŋ toŋ kaŋ, tɛ ŋɛŋ wi wu gii kɛmɛ ki.” Fini tɛ kɛti le fi bɛ fi kɔchɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ le, “Be tɛ̀ gachɛ ndú yɛŋ li yi yi bee, be toŋ kaŋ bɛ kiŋkoŋ ŋkeŋ.” Se nuuŋ le bɛniiŋ bɛ nchi bɛlu tɛ̀ fɛ nɛɛ fini fiee. ");
INSERT INTO asj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bukɛɛŋ bamu tɛ̀ gii be lemi fe, li kintaaŋ ki Jiso-o lichiŋ. Bukɛɛŋ bani tɛ̀ nuuŋ ni Jiso bɛ bɛŋwaani ni Jiso wu kwɛɛŋ mɔɔ Maariya wu kwɛɛ Klofas mɔɔ Maariya Madaliŋ ");
INSERT INTO asj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Le Jiso dza ŋɛŋ ni mɔɔ ŋwani wu kintutu wu tɛ̀ kɔŋgisi wɛ si be lemi li wuu lichiŋ, tee li ni-i le, “Kwɛɛŋ, bichɛ ɔ ŋɛŋ, wuni to wɛ ŋwana.” ");
INSERT INTO asj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Si tɛ̀ tee lɛ, kaari tee tɛ li ŋwani wu kintutu wɛɛ le, “Bichɛ ɔ ŋɛŋ, wuni to wɛ na.” Mbɛɛchɛ li mfi wɛ ŋwani wu kintutu wɛ se dzɔ ni Jiso gɛɛŋ tsiiŋ nuuŋ li wu-u yih. ");
INSERT INTO asj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lɛjiŋ lɛlu, Jiso tɛ̀ kɛɛ kituŋ le fiee fichu ma fiɛɛ, le fɛ fi bɛ fi kɔchɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ, se dza tee le, “Ndɔɔŋ wondinɔɔ mi.” ");
INSERT INTO asj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tɛnɛ chimu tɛ̀ nuuŋ fe bɛ mbiiŋ mɛ mgbanyi le tɛɛ. Bɛniiŋ bɛ nchi-i baa tuu be lii kifiiŋ li mee be shiŋgɛ li kiti ki iso-ob be nɛɛki lɛ wuu wa. ");
INSERT INTO asj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Le Jiso fi mbiiŋ mɛlu se tee le, “Fi ma fiɛɛ.” Si tɛ̀ tee lɛ, bɛɛki kikoo kee, kwi. ");
INSERT INTO asj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Si boo yɛlu tɛ̀ nuuŋ Jobɛ chi Nachɛ le bɛ lɛ li jobɛ chi bɛshiinshi-i lɛ, Bɛjuu tɛ̀ wɛki le be fɛ le kiiŋ gooŋ yilu ba li bintaaŋ li jobɛ chi bɛshiinshi kɛ, (teege si jobɛ chi bɛshiinshi chilu tɛ̀ nuuŋ chi nɔŋa lɛ). Be se gɛɛŋ be ŋɛŋ Pailɛt be lɛkɛ wu be tee le be gɛɛŋ be bonyɛ bikaa bi bɛniiŋ bɛ tɛ̀ nuuŋ li bintaaŋ bilu-u, be se kwiyɛ tsɛkɛ bɛ shiiki bɛ tsaaki be. ");
INSERT INTO asj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bɛdɛɛni bɛniiŋ bɛ nchi baa bonyɛ bikaa bi wi wu ŋkosi, be bonyɛ tɛ̀ bi wu biki. ");
INSERT INTO asj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Se nuuŋ le, le be bo fɛ Jiso, be ŋɛŋ ɛ wu kwi kituŋ, be ti mɛɛŋ ki bonyɛ kɛ bikaa biee kɛ. ");
INSERT INTO asj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wumu wu li kintutu ki bɛniiŋ bɛ nchi-i baa beeŋ Jiso lɛfufu bɛ gɔŋɛ. Le beeŋ lɛ, mfwaa mumkpaŋ ŋgɔŋ mɔɔ dzɔɔ tasi fe. ");
INSERT INTO asj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wi wu tɛ̀ ŋɛŋ biee bini tɛ̀ leŋ lɛjiŋ lɛ nsa wulu-u le, n'yɔru we nuuŋ chɛɛŋ, se kii tɛ le wuni n'yɔru tɛ̀ nuuŋ wu chɛɛŋ, wu nɛ nuuŋ nɛ beŋ. ");
INSERT INTO asj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Biee bini tɛ̀ kɛti ni le fiee fi bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki Nyɔ-ɔ bɛ fi kɔchɛ si be tsɛɛ le, “Kiŋkomfɛ kee kimumkpaŋ nuuŋ tɛ̀ naa bondɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Fi se tuu fi nuuŋ ɛ bɛ tsɛɛ lɛ kintsii kimu-u lɛ Kiŋwaati ki Nyɔ-ɔ le, “Bɛniiŋ gii be ni be bichi wi wu bɛ beeŋ wulu.” ");
INSERT INTO asj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lɛjiŋ lɛlu Jɔsɛ wu Arimatia dza gɛɛŋ ŋɛŋ Pailɛt lɛkɛ wu le beŋ gɛɛŋ tsaaki gwini chi Jiso-o. Jɔsɛ wuni tɛ̀ nuuŋ wi wu kintutu ki Jiso-o, se nuuŋ le tɛ̀ nuuŋ lijiŋ lijiŋ kifɛ tɛ̀ chɛndi Bɛjuu. Pailɛt beŋ, se gɛɛŋ shiiki gwini chilu. ");
INSERT INTO asj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmu wu tɛ̀ saa gɛɛŋ ŋɛŋ Jiso butuu bumu wɛ, tɛ̀ bɛ tɛ bɛ mɛɛŋ mamu mɛ sɛɛndi ni shuuŋŋ mɛ bɛ fiinsɛ bɛ mɛɛr mɔɔ alos, me luuti si bɛ kilo mbaanshɛɛ ntsɔ bɛtɛɛtu. ");
INSERT INTO asj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bee wu se shiiki gwini chi Jiso-o be fiɛɛmɛ bɛ ndú be fwa bɛ mɛɛŋ maa be diyɛ wu li ntsɛ Bɛjuu. ");
INSERT INTO asj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mbaŋ wu wɛ wumu tɛ nuuŋ fe fɛ chiŋ fɛ bɛ tɛ̀ ta Jiso li kintaaŋ li fɛɛ. Li wɛ wulu dziŋ yi fiɛŋ yimi tɛ̀ nuuŋ fe ɛ bɛ ti mɛɛŋ saa ki diyɛ kɛ wi le kɛ. ");
INSERT INTO asj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Se nuuŋ le si booyaa tɛ̀ nuuŋ Jobɛ chi Bɛjuu lɛ chi Nachɛ wu jobɛ chi Bɛshiinshi lɛ, ɛ dziŋ yilu tɛ̀ nuuŋ tɛ tsɛkɛtsɛkɛ, be se giiki Jiso le. ");
INSERT INTO asj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Le ni nuuŋ jobɛ chi ŋkosi li fuu li, Maariya Madaliŋ bo lɛ ŋ'wori gɛɛŋ fɛ dziŋ fɛɛ, ŋɛŋ ɛ bɛ bachɛ tɛtɛ chi bɛ tɛ baŋɛ fweeŋ wu dziŋ yɛɛ lu. ");
INSERT INTO asj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Se nuuŋ le, se biee letɛ gɛɛŋ ŋɛŋ Simu Pita bɛ ŋwanɛ kintutu ki Jiso-o wumu wu Jiso tɛ̀ kɔŋgisi wɛ, tee li bee le, “Bɛ buu baa Taa lɛ dziŋ, tɛ kii yɛ laa bɛ gɛɛ wu fɛŋ le kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pita bee ŋwaŋ wu kintutu ki Jiso wulu biee be bo be giiŋgi fɛ dziŋ yilu-u. ");
INSERT INTO asj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Be tɛ̀ giiŋgi be letini bu letinɛ, bɛdɛɛni, ŋwaŋ wu kintutu ki Jiso wɛ letɛ yaa Pita saa fɛsi fɛ dziŋ fɛlu. ");
INSERT INTO asj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Le fɛsi fe, guumɛ bichɛ, ŋɛŋ ɛ ndú yi bɛ tɛ̀ fiɛɛmɛ Jiso lu yɛ gimi le. Le bichɛ lɛ, ba le ki lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simu Pita biee wu be fɛsi fe, se lɛ gɛɛŋ lɛ dziŋ lɛlu. Le lɛ, ŋɛŋ nɛɛ nuuŋ ndú yɛɛ kwaa si yi gimi fe, ");
INSERT INTO asj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mɔɔ finshɛŋgɛ fi ndu fi bɛ tɛ̀ liiŋ kikoo ki Jiso-o lu, fi tɛ̀ gimi yɛ bɛ ndú yimi yɛɛ kɛ. Ɛ bɛ tɛ̀ kɛnchi bɛ giiki fɛ kintsii kee li fi gimi fi fimbiiŋ. ");
INSERT INTO asj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ŋwaŋ wu kintutu wu Jiso wu tɛ̀ saa wu fɛsi fɛ dziŋ wɛ se lɛ tɛ gɛɛŋ lɛ dziŋ ŋɛŋ fiee fini se beŋ. ");
INSERT INTO asj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Fi tɛ̀ nuuŋ ɛ be ti mɛɛŋ ki kɛɛ kɛ kinyi ki fiee fi nuuŋ lɛ Kiŋwaati ki Nyɔ-ɔ le Jiso tɛ̀ kɛmi le bo li kwe-e kɛ. ");
INSERT INTO asj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bɔɔŋ bɛ kintutu-u bɛ Jiso-o baa kaari be koo fɛkuuŋ. ");
INSERT INTO asj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Se nuuŋ le, Maariya shɛ lemi dii fɛ dziŋ fɛlu. Si tɛ̀ dii lɛ dza guumɛ bichɛ lɛ dziŋ, ");
INSERT INTO asj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ŋɛŋ bɛnchindaa bɛ Nyɔ-ɔ bɛfɛ ɛ be chuumɛ ndú yi ncherere be shee fɛ bɛ tɛ giiki gwini chi Jiso-o fɛɛ, wumu fɛ kintsii ki kikoo ki Jiso-o tɛ̀ nuuŋ, wumu fɛ kintsii ki bikaa biee tɛ̀ nuuŋ. ");
INSERT INTO asj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bɛnchindaa bɛ Nyɔ-ɔ baa se bii li wuu laa, “Kwɛɛŋ, ɔ dii kii la?” Tuu le, “Ndiiɔ kifɛ bɛ tsaaki baa Taa bɛ dza bɛ wu, ŋkii yɛ fɛ bɛ gɛɛ wu kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Le tee lɛ, le fikisi yi ŋɛŋ Jiso lemi. Se nuuŋ le, ti mɛɛŋ ki kɛɛ kɛ le ɛ Jiso kɛ. ");
INSERT INTO asj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jiso bii li wuu laa, “Kwɛɛŋ, ɔ dii kii la? Ɛ noo wɔɔ wɛki?” Maariya se tɛ̀ beechɛ le ɛ wi wu bichi lɛ mbaŋ wu wɛ wulu-u. Se tee li wuu le, “Baa wɛŋ, ɛ nuuŋ wɛ wu tsaaki wu, ɔ dza bɛ wu, ɔ tee fɛɔ gɛɛ wu fe, ŋgɛɛŋ ndzɔ wu, ndza bɛ wu.” ");
INSERT INTO asj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jiso dza teeŋ wu le, “Maariya.” Se kaari teeŋ wu lɛ jɛ́ yibee yi Hiburu le, “Laboni,” fi nuuŋ le, “Wi wu Ntiifɛ.” ");
INSERT INTO asj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jiso tee li wuu le, “Kiiŋ ɔ ni koŋ li mi-i kɛ, kifɛ mmɛɛŋɔ nsaa ki n'yɛɛ kɛ fɛ Baa wɛ-ɛŋ kɛ. Gɛnɛ nuuŋ lɛ bɛŋwaanɛŋ ɔ tee li bee le, n'yɛkɔɔ fɛ Baa wɛŋ wu nuuŋ tɛ Baa wunɛ, mɔɔ fɛ Nyɔ yɛŋ yi nuuŋ tɛ Nyɔ yinɛ.” ");
INSERT INTO asj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maariya Madaliŋ se dza gɛɛŋ tee li bɔɔŋ bɛ Jiso-o bɛ kintutu-u le wu ŋɛŋgɔɔ Taa, tuu tee li bee le, wu teeɔ biee bini li wu-u. ");
INSERT INTO asj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Le ni nuuŋ lɛ fɛmfo-o booyaa ɛ tɛ̀ nuuŋ jobɛ chi ŋkosi li fuu li, bɔɔŋ bɛ kintutu-u bɛ Jiso-o nuuŋ li yih ɛ be bɛɛnyɛ bigoo, kifɛ be tɛ̀ chɛndi Bɛjuu. Jiso dza busɛ leŋ lɛ bee lɛnti, tee li bee le, “Mbɛɛŋgii ni nuuŋ bɛ beŋ.” ");
INSERT INTO asj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Le tee li bee lɛ, se doonchɛ tsaŋ yee mɔɔ lɛfufu lee li bee. Bɔɔŋ bɛ Jiso-o bɛ kintutu-u baa tɛ̀ nɛɛtɛ ŋge fɛ be tɛ̀ ŋɛŋ Taa. ");
INSERT INTO asj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jiso se tuu kaari tee li bee le, “Mbɛɛŋgii ni nuuŋ bɛ beŋ. Si Baa wɛŋ tɛ̀ toŋ mi, ɛ lɛ si ntundɔɔ beŋ dɛɛni.” ");
INSERT INTO asj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Le tee lɛ, se yindɛ li bee, tee li bee le, “Fi yɛŋ Fiana yi Waaŋ. ");
INSERT INTO asj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɛ nɛ feeki bibifi bi wi-i, kɛ Nyɔ feeki yɛ tɛ kituŋ. Ɛ nɛ ba mfekisɛ nsiŋ, kɛ bi gii bi ba lɛ.” ");
INSERT INTO asj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mfi wu Jiso tɛ̀ bɛ fɛ bɔɔŋ bee bɛ kintutu-u, Tomɛ wu tɛ̀ nuuŋ wi kintutu ki bɔɔŋ bɛ yoofi ntsɔ bɛfɛ wu bɛ tɛ̀ teenyi bukooŋ bwee bumu le Maŋ wɛɛ, tɛ̀ nuuŋ yɛ bee be kɛ. ");
INSERT INTO asj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kiŋkɛ ki kintutu ki bɔɔŋ bɛ Jiso-o kɛɛ se biee ki tee li wuu le, “Tɛ̀ bee tɛ̀ ŋɛŋ Taa.” Se nuuŋ le, tɛ tee fiee li bee le, “Ɛ mɛɛŋ ki ŋɛŋ kɛ bibaa bi biɛni yɛɛ li bibɛnu biee li nse nlii kwaŋ weŋ le kɛ, nse ntuu nlii kibɛnɛ keŋ lɛfufu lee kɛ, ntɛ̀ mbeŋ kɛ dududu.” ");
INSERT INTO asj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Le fuu ka bɛ tasɛ, le bɔɔŋ bɛ Jiso-o bɛ kintutu-u tuu be ni be nuuŋ li yih, Tomɛ nuuŋ tɛ bee be, bigoo nuuŋ bimbɛŋɛ. Jiso se dza busɛ lɛ bee lɛnti, tee li bee le, “Mbɛɛŋgii ni nuuŋ bɛ beŋ.” ");
INSERT INTO asj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Le tee li bee lɛ, se tee li Tomɛ-ɛ le, “Gɛɛ kwaŋ wa li kibɛnɛ keŋ, ɔ ŋɛŋ si ki nuuŋ, ɔ tuu ɔ lii tɛ kibɛnɛ ko lɛfufu leŋ. Kiiŋ ɔ ni mɛŋɛ kɛ, beŋ.” ");
INSERT INTO asj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomɛ se tuu le, “Taa wɛŋ, mɔɔ Nyɔ yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jiso tee li wuu le, “Ɔ beŋɔ dɛɛni kifɛ ɔ ŋɛŋgɔɔ mi ni? Kinɛɛtinɛ ki nɔŋa kɛɛ li bɛniiŋ bɛ mɛɛŋ ki ŋɛŋ kɛ mi kɛ, be se beŋ baa nɛɛ.” ");
INSERT INTO asj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jiso tɛ̀ fɛ biee ŋge bi doonchi buŋga bu Nyɔ-ɔ li bɔɔŋ bee bɛ kintutu-u be ŋɛŋ, bɛ se mɛɛŋ baa ki tsɛɛ kɛ lɛ Kiŋwaati kini kɛ. ");
INSERT INTO asj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Se nuuŋ le bini bi bɛ tɛ̀ tsɛɛ biɛɛ le bi fɛ le nɛ beŋ le Jiso nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ, mɔɔ le nuuŋ Ŋwanɛ Nyɔ. Ɛ nɛ beŋ dɛɛni, nɛ se kɛmɛ ntsɛ wu kimakɛ kii bukooŋ bwee. ");
INSERT INTO asj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lɛjiŋ lɛlu, Jiso tuu ka doonchɛ yi yee li bɔɔŋ bee bɛ kintutu-u fɛ Libɛ chi Tibɛria lichiŋ. Fi tɛ̀ ka lɛ yini dze-e: ");
INSERT INTO asj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simu Pita bee Tomɛ wu bɛ tɛ̀ teenyi le Maŋ, mɔɔ Natanya wu Kana wu kimbɛ ki Galilii, mɔɔ bɔɔŋ bɛ Dzɛbɛdii, bɛ bɔɔŋ bɛ kintutu-u bɛ Jiso-o bamu bɛfɛ tɛ̀ nuuŋ fɛ kintsii kimumkpa-aŋ. ");
INSERT INTO asj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simu Pita dza tee li bee le, “Ŋgii nla nsuuŋ.” Be tee li wuu le, “Tɛ gii tɛ la bɛ wɛ tɛ.” Bee be bo, be gɛɛŋ, be lɛ lɛ ŋgo-o. Se nuuŋ le, be tɛ̀ dɛndɛ be tsi li dzɔɔ be ti mɛɛŋ ki kɔɔ kɛ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Le lɛkuuŋ ni le wuuti le bɛɛ, Jiso bɛ leŋ li ŋgemɛ yi dzɔɔ li, bɔɔŋ bee bɛ kintutu-u tɛ̀ mɛɛŋ ki kɛɛ kɛ le ɛ wu kɛ. ");
INSERT INTO asj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jiso bii li bee laa, “Bɔɔŋ beŋ, nɛ kɔɔ baa nɛɛ nsúuŋ ni?” Be tuu le, “Wohoo.” ");
INSERT INTO asj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tee li bee le, “Lɔmɛ yɛɛŋ gwii dze lɛ kibɛnɛ ki kigɔŋɛ ki ŋgo-o, nɛ gii nɛ kɔɔ fiee.” Be se lɔŋ, wu tɛ̀ tuu wu yaa be nchewu, kifɛ be tɛ̀ gbɛɛŋ be kɔɔ nsúuŋ le ŋge. ");
INSERT INTO asj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Le ŋwaŋ wu kintutu ki Jiso-o wu Jiso tɛ̀ kɔŋgisi wɛ ŋɛŋ lɛ, tee li Pita le, “Ɛ Taa.” Le Simu Pita woo le ɛ Taa lɛ, biee liishɛ ndú yee kifɛ tɛ̀ nuuŋ bwiŋ kilɛrɛ. Le liishɛ lɛ, jiiŋ seri li dzɔɔ giiŋgi lɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bɔɔŋ bɛ kintutu-u bamu baa biki lɛ ŋgo-o, be chiiti gwii wɛɛ ɛ wu yisɛ bɛ nsúuŋ. Be tɛ̀ nuuŋ yɛ mfiiŋ li mbochu li buka-a kɛ. Bɛntaŋ tɛ̀ shɛ si mbaanshiŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Be gɛɛŋ be fɛsi li bukaka be ŋɛŋ bikaa bi wi-i si bi keeti, nsúuŋ nuuŋ fe, kibele nuuŋ tɛ fe. ");
INSERT INTO asj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jiso tee li bee le, “Bɛ yɛɛŋ bɛ nsúuŋ yimi yi nɛ kɔɔ.” ");
INSERT INTO asj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bɛdɛɛni, Simu Pita gɛɛŋ miri lɛ ŋgo-o, chee gwii wu bo li buka ɛ wu tɛ̀ yisɛ bɛ nsúuŋ yi nyɔŋa gwii bɛ kitsɔ mbaanshiŋ ntsɔ shɛɛ (153). Mɔɔ si yi tɛ̀ yisɛ ŋge lɛ, gwii tɛ̀ mɛɛŋ ki gaamɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jiso tee li bee le, “Bɛ yɛɛŋ nɛ ji biee.” Wi mumkpaŋ li bɔɔŋ bee bɛ kintutu-u ti mɛɛŋ mɔɔ ki mɔɔŋ kɛ le bii li wuu laa ɛ wu noo le kɛ. Be tɛ̀ kɛɛ nɛɛ le ɛ Taa. ");
INSERT INTO asj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jiso se gɛɛŋ dzɔ kibele kɛɛ nyɛ be, mɔɔ nsúuŋ yɛɛ. ");
INSERT INTO asj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Fini tɛ̀ bo kiŋga kitɛɛtɛ si Jiso tɛ̀ doonchɛ yi yee li bɔɔŋ bee bɛ kintutu-u mbɛɛchɛ fɛ tɛ̀ bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Le be ji biee be mɛɛshi, Jiso teeŋ Pita bii li wuu laa, “Simu ŋwanɛ Jɔɔŋ, ɔ kɔŋgisi mi ɔ yɛki bani ni?” Tuu le, “Iiŋ Taa, ɔ kiiɔ le ŋkɔŋgisi wɛ.” Jiso tee li wuu le, “Ɔ nyɛki bɔɔŋ beŋ bɛ nshɔ́ɔŋ lɛ.” ");
INSERT INTO asj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jiso tuu teeŋ wu kiŋga kifɛ bii li wuu laa, “Simu ŋwanɛ Jɔɔŋ, ɔ kɔŋgisi mi ni?” Tuu le, “Iiŋ Taa, ɔ kiiɔ le ŋkɔŋgisi wɛ.” Tee li wuu le, “Ɔ bichi lɛ nshɔ́ɔŋ yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jiso tuu teeŋ wu bo kiŋga kitɛɛtɛ bii li wuu laa, “Simu ŋwanɛ Jɔɔŋ, ɔ kɔŋgisi mi ni?” Le Pita woo si Jiso bii li wuu bo kiŋga kitɛɛtɛ laa kɔŋgisi wu le, fi fuumi wu. Tee li Jiso le, “Taa, ɔ kiiɔ fiee fichu, ɔ kiiɔ le ŋkɔŋgisi wɛ.” Jiso tee li wuu le, “Ɔ nyɛki nshɔ́ɔŋ yɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ntee wɛ chɛɛŋ chɛɛŋ le, mfi wuɔ tɛ̀ mɛɛŋ sɔɔnɛ wi, ɔ tɛ̀ kiichi yi ya ɔ lisi ndú ya ɔ giiŋgi fɛ ɔ kɔŋgisi. Se nuuŋ le, mfi wuɔ gii ɔ doŋ ɔ gii ɔ nɛɛmi bibɛnu bio le wumu lii li wɛ-ɛ, dzɔɔ wɛ gɛɛŋ bɛ wɛ fɛ kintsii ki ɔ ti kɔŋgisi yɛ ŋgɛnu kɛ.” ");
INSERT INTO asj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jiso tɛ̀ tiiti fini doonchi nuuŋ ŋwaani kwe yi Pita tɛ̀ nuuŋ le gii kwi yi se bɛ bɛ bukooŋ bu nɔŋa li Nyɔ-ɔ. Le Jiso yɔ lɛ, se tee li wuu le, “Ɔ biki mi.” ");
INSERT INTO asj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Le Pita tuu fikisi yi, ŋɛŋ si ŋwanɛ kintutu wu Jiso tɛ̀ kɔŋgisi ŋge wɛ biki li bee. Ŋwanɛ kintutu wuni nuuŋ wu tɛ̀ yeŋ gɛɛŋ li Jiso mfi wu be tɛ̀ jii biee lɛ fɛmfo-o fɛ kimɛrisɛ bii li wuu laa, “Taa, ɛ noo wu gii kabɛ wɛ?” ");
INSERT INTO asj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Si Pita tɛ̀ ŋɛŋ ŋwanɛ kintutu wulu biki be lɛ, bii li Jiso laa, “Taa, fi wi wuni nuuŋ le la?” ");
INSERT INTO asj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jiso tuu li wuu le, “Ɛ nuuŋ ŋkɔgisɛ weŋ le ba ni nuuŋ nsiiŋ gɛɛŋ bo fɛ mi ŋkaari mi mbɛ, fiɛɛ kɛmɛ la fi fɛrɛ bɛ wɛ? Ɔ biki mi lɛ.” ");
INSERT INTO asj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Si Jiso tɛ̀ tiiti lɛ, tefɛ chilu se saaŋgini chi giiŋgi li bɛniiŋ bɛ kimbeenchɛ-ɛ lɛnti le ŋwanɛ kintutu wu Jiso wuni nuuŋ tɛ̀ kwi kɛ. Se nuuŋ le, Jiso tɛ̀ mɛɛŋ ki tee kɛ le gii kwi kɛ. Tɛ̀ tee nuuŋ nɛɛ le, “Ɛ mbee kɔŋgisi le ba ni nuuŋ nsiiŋ gɛɛŋ bo fɛ mi ŋkaari mi mbɛ, fiɛɛ kɛmi la le fi fɛrɛ bɛ wɛ?” ");
INSERT INTO asj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ŋwaŋ wu kintutu wulu wuni nuuŋ wu, wu tiiti kii biee bini, ɛ wu, wu tɛ̀ tsɛɛ biee bilu, tɛ̀ kɛɛ baa le fiee fi tiiti kii fi nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Se nuuŋ le biee bimu biɛɛ tɛ lu ŋge bi Jiso tɛ̀ fɛ, bee nuuŋ le bɛ tsɛɛ bi bichu, ŋiŋgi le nshɛ chi kɛmi yɛ kintsii ki bɛ nuuŋ bɛ kiri biŋwaati bilu fe kɛ.");
INSERT INTO asj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Te la Tiofilos, lɛ kiŋwaati keŋ ki ŋkosi ki ntɛ̀ ntsɛɛ li wɛɛ, ntɛ̀ ntsɛɛ le kii biee bichu bi Jiso tɛ̀ feti mɔɔ bi tɛ̀ fenjisi li bɛniiŋ li, mbɛɛchɛ si tɛ̀ bɛchi nimɛ chee, ");
INSERT INTO asj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","gɛɛŋ bo jobɛ chi Nyɔ tɛ̀ dzɔ wu yi yɛɛ bɛ wu liboo. Fɛ Nyɔ tɛ̀ gii yi dzeti wu le yi yɛɛ bɛ wu liboo lɛ, tɛ̀ ka li buŋga bu Fiana yi Waaŋ li tifi bɔɔŋ bee bɛ ntoŋ bɛ tɛ̀ tsaa. ");
INSERT INTO asj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mfi wu tɛ̀ bo li kwe-e, tɛ̀ tuu doonchɛ yi yee li bee, li jo mbaanyɛɛ li, lɛ dzé ŋge li, le doonchɛ le wɛ yoŋ. Tɛ̀ tuu tiiti be kii bumfɔŋ bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Si bee be tɛ̀ nuuŋ lɛ, tee li bee le, “Kiiŋ nɛ ni dza Jɛrosalɛŋ kɛ. Nɛ tɛŋgi yɛɛŋ kinderi ki Taa tɛ̀ kaachɛ beŋ lu, ki nɛ tɛ̀ woo ntiiti kii ki kɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nɛ kɛɛ le Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ, se nuuŋ le li jo niiŋ li, Nyɔ gii yi lii beŋ nuuŋ li yi Fiana yi Waaŋ li.” ");
INSERT INTO asj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jiso bee bɔɔŋ bee bɛ ntoŋ tɛ̀ nuuŋ li mfi wumu-u, be dza be bii li wuu laa, “Taa, mfi kɔchɔɔ kituŋ wuɔ gii ɔ fɛ le bɛniiŋ bɛsɛŋ bɛ Isɛlɛɛ kaari be ni be sɛki bumfɔŋ bu bee ni?” ");
INSERT INTO asj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tuu li bee le, “Mfi mɔɔ jobɛ chi fi gii fi yenɛ wɛ nuuŋ ɛ Taa nachɛ bɛ buŋga bwee, fi nuuŋ yɛ kintsii kinɛ le nɛ kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Fi nɛ nuuŋ nɛ kɛɛ nuuŋ le, Fiana yi Waaŋ gii yi bɛ yi yisɛ li yih yinɛ, nɛ se kɛmɛ buŋga, nɛ bɛchi nɛ ni nɛ tiiti kii mi mbɛɛchɛ Jɛrosalɛŋ mɔɔ bimbe bi Judiya bɛ bi Samaaria bichu, ŋgɛnu mbochu fɛ tɛɛŋ luushi.” ");
INSERT INTO asj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nɛɛ si tɛ̀ tiiti lɛ, Nyɔ dzɔ wu yi yɛki bɛ wu liboo, be bichi si yɛki, gɛɛŋ kikuŋ baanyɛ wu, la be lɛ lii. ");
INSERT INTO asj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Si be tɛ̀ toŋ lii be bichi si yɛki lɛ, fi ka le buniŋ bɛfɛ tɛ̀ dza be taa be busɛ ɛ be chuumɛ ndú yi ncherere, be leŋ li bee lichiŋ, ");
INSERT INTO asj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","be bii li bee laa, “Buniŋ bɛ Galilii, ɛ la fi nɛ lemi nɛ bichi liwe? Jiso wuni wu Nyɔ-ɔ dzɔ li be-eŋ linti wu yɛɛ bɛ wu liboo, gii naa kaari bɛ nɛɛ si nɛ bee nɛ ŋɛŋ wu yɛki lɛ.” ");
INSERT INTO asj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bɔɔŋ bɛ ntoŋ bɛ Jiso se dza li Ŋkumɛ wu Biti bi Oli-if be tuu lijiŋ Jɛrosalɛŋ ɛ tɛ̀ nuuŋ si kiŋgatɛ ki ma ŋgɛnu mbochu fe. ");
INSERT INTO asj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Le be lɛ fe, be yɛɛ be gɛɛŋ lɛ loŋ wu yih yi lɛwe fɛ be tɛ̀ shiiŋ be fufini. Bɛniiŋ bani tɛ̀ nuuŋ Pita, Jɔɔŋ, Jeeŋ mɔɔ Andolo, Fili bɛ Tomɛ, Batolomu bɛ Maacho, Jeeŋ wu ŋwanɛ Afiyus, Simu wu tɛ̀ nuuŋ wi kintutu ki Bɛsilɔ-ɔ mɔɔ Judas wu ŋwanɛ Jeeŋ. ");
INSERT INTO asj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Be bɛchu mɔɔ bukɛɛŋ bamu mɔɔ Maariya wu ni Jiso bɛ bɛŋwaani Jiso tɛ̀ banchi li fiee fimumkpaŋ, le be ni be lɛki li Nyɔ-ɔ mfi kwi. ");
INSERT INTO asj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Le ni nuuŋ li jo yɛɛ, bɔɔŋ bɛ kintutu-u bɛ Jiso taashɛ. Be tɛ̀ nuuŋ fe giiŋgi gwii bɛ kitsɔ mbaamfiɛɛ (120). Pita dza we tee li bee le, ");
INSERT INTO asj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bɛŋwaanɛŋ, fiee fi Kiŋwaati ki Nyɔ-ɔ tɛ̀ tee kɛmi le fi ka. Fiɛɛ fiee fi Fiana yi Waaŋ tɛ̀ fɛ Daafi se kweeŋ ŋkosi kii Judas wu tɛ̀ too mbaaŋ bɛ se kɔɔ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nɛɛ lɛ Judas wuni tɛ̀ nuuŋ wumu li kintutu kisɛ-ɛŋ, kɛmi chee chi nimɛ li bee li linti.” ");
INSERT INTO asj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Fɛ Pita tɛ̀ yeti lɛ nuuŋ ɛ Judas tɛ̀ dzɔ kwa wu bɛ tɛ̀ nyɛ li wuu kii fiee fi tɛ̀ fɛ, go kintsii lu. Ɛ fɛ kintsii kilu-u fɛ tɛ̀ we bushi likwiiŋ tee chee bukɛ, bulɛ buchu se bo. ");
INSERT INTO asj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bɛniiŋ bɛ Jɛrosalɛŋ bɛchu woo lɛ, be se teenyi kintsii kilu lɛ jɛ́ yi bee le Akedama, fi nuuŋ le, “Kintsii ki Ŋgɔŋ.”) ");
INSERT INTO asj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita tuu tee le, “Daafi tɛ̀ tsɛɛ lɛ Kiŋwaati kin'yɔɔnchɛ le, ‘Bɛ chinɛ la we to kichiiyɛ, wi tɛ tuu le ni tsiiŋ fe kɛ.’ Tɛ̀ tuu tsɛɛ le, ‘Wumu kɛmi le dzɔɔ kintsii kee ki nimɛ-ɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Si fi nuuŋ ni, wumu kɛmi le taa li bee li, wu tɛ gii tɛ ni tɛ tiifi le Taa Jiso tɛ̀ bo li kwe-e. Wɛɛ wi kɛmi le ni nuuŋ wi wu tɛ̀ deŋgi bɛ bee mfi kwi fɛ Jiso tɛ̀ deŋgi bɛ bee mbɛɛchɛ li mfi wu Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ, ŋgɛnu mbochu jobɛ chi Nyɔ tɛ̀ dzɔ Jiso lɛ bee lɛnti yɛɛ liboo.” ");
INSERT INTO asj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Le tee lɛ, be tsaa bɛniiŋ bɛfɛ. Wumu tɛ̀ nuuŋ Jɔsɛ wu bɛ tɛ̀ teenyi le Basaba bɛ tuu bɛ teenyi wu le Justu, se wumu nuuŋ Matiya. ");
INSERT INTO asj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Le be tsaa be lɛ, be biee be lɛkɛ li Nyɔ-ɔ le, “Taa, ɔ kii shéŋ yi bɛniiŋ bɛchu. Se nuuŋ le, doonchɛ li bee li wi wu tɛ gii tɛ buu lɛ bɛniiŋ bɛ bɛfɛ bani-i lɛnti, ");
INSERT INTO asj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","le ni nuuŋ ŋwanɛ ntoŋ wu Jiso wu gii dzɔɔ kintsii ki Judas ki nimɛ-ɛ, ki tɛ̀ chinɛ gɛɛŋ fɛ kee kintsii li.” ");
INSERT INTO asj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Si be tɛ̀ lɛkɛ li Nyɔ-ɔ lɛ, be se tsɛɛ mɛŋkooŋ mɛ bee, be sɛɛsɛ bu Matiya bo bu we. Be taa wu li kintutu ki bɔɔŋ bɛ nto-oŋ bɛ Jiso-o bɛ yoofi ntsɔ mumkpaŋ baa. ");
INSERT INTO asj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Le jobɛ chi Tsɔnɔ chimu chi bɛ tɛ̀ teenyi le Pɛntɛkɔ bɛ chi kɔchɛ, ɛ bɛniiŋ bɛchu bɛ tɛ̀ gɛɛ shéŋ li Jiso-o banchɛ kintsii Kimumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Be dza be taa be woo si fiee fimu nduŋgi fi shiiti liwe si kiŋkuŋku. Fi shee, fi yisɛ li yih yi be tɛ̀ nuuŋ lu chichi. ");
INSERT INTO asj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Le be bichi lɔɔ, be ŋɛŋ fiee fimu si níŋ yi wi lɛ, yi se saaŋgɛ yi gɛɛŋ yi nuuŋ li bee, wi mumkpaŋ mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Fiana yi Waaŋ se biee yi yisɛ li be bɛchu, yi fɛ le be to be ni be yeti jɛ́ yi bitoŋ chichi chichi. ");
INSERT INTO asj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tɛ nuuŋ li mfi wɛɛ, Bɛjuu bɛ tɛ̀ bɔsɛyi be gɛɛ shéŋ li Nyɔ-ɔ tɛ̀ nuuŋ Jɛrosalɛŋ, ɛ be tɛ̀ dza li bitoŋ bichu bi li kikoo ki nshɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Le be woo nduŋu wɛ lɛ, be se banchi be bɛɛ ŋge fɛ bɛniiŋ bɛ tɛ̀ gɛɛ shéŋ li Jiso-o tɛ̀ nuuŋ. Bɛniiŋ bɛ tɛ̀ gɛɛ shéŋ li Jiso-o bɛlu tɛ̀ yeti, wi mumkpaŋ mumkpaŋ be wuki tɛ jɛ́ yibe. Fi fuumi be. ");
INSERT INTO asj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bimfimu wondɛ be, be ta maa, be tiiti laa, “Bɛniiŋ bɛ yeti bani bɛchu nuuŋ nɛɛ bɛniiŋ bɛ Galilii ni? ");
INSERT INTO asj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Fi geeŋ fi wi mumkpaŋ mumkpaŋ wuki be yeti lɛ jɛ́ yi bitoŋ bi bee ni? ");
INSERT INTO asj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bee bamu dza Paatia, bamu dza Meda bɛ Ɛlam, bamu dza Misopotemia bɛ Judiya mɔɔ Kapadosia, bamu dza Pontu bɛ Eesha. ");
INSERT INTO asj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Bee bamu dza Flija bɛ Pamfila, bamu Ijip bɛ bimbe bi Libia, bi nuuŋ li kitoŋ ki Sɛli-iŋ lichiŋ. Bee bamu se dza Lom, se nuuŋ Bɛjuu bɛ bɛniiŋ bɛ fiiki be to bɛniiŋ bɛ kimbeenchɛ-ɛ ki Bɛjuu. ");
INSERT INTO asj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bee bamu se dza Klɛt bɛ Alabia. Tɛ se wuki li jɛ́ yi bitoŋ bisɛŋ chichi chichi si bɛniiŋ bani yeti biee bi koofiyi bi Nyɔ fɛ.” ");
INSERT INTO asj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bimfimu wondɛ be, be njanjɛ bebe laa fini fiee se tiifi le la le. ");
INSERT INTO asj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bɛniiŋ bamu tɛ̀ choosi fibee bu choosɛ, be tiiti le, “Bɛniiŋ bani baa ɛ mbiiŋ kɔɔ be.” ");
INSERT INTO asj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bɛdɛɛni, Pita bee bɔɔŋ bɛ nto-oŋ bɛ Jiso-o bɛ yoofi ntsɔ mumkpaŋ baa leŋ fe. Pita se bɛchi yeti li kintutu ki bɛniiŋ lɛ, lɛwe ŋge le, “Bɛjuu beŋ mɔɔ bɛniiŋ bɛchu bɛ tsiiŋ Jɛrosalɛŋ ŋwɛkɔɔ le nɛ kɛɛ fini bujɔŋ. Yikɛ yɛŋ bujɔŋ li fiee fi ŋgii ntee li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mbiiŋ mɛɛŋ maa ki kɔɔ kɛ bɛniiŋ bani si nɛ beechi lɛ kɛ. Dɛɛni mɛɛŋ yaa jobɛ bikaa mfomɛyoofi fɛŋwɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Fiee fi kɛti dɛɛni fini nuuŋ fi Juɛl wu ntomfɔŋ wu Nyɔ-ɔ tɛ tee le, ");
INSERT INTO asj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nyɔ tiiti yɛ le, fɛ gii ni nuuŋ li jo yí kimɛrisɛ, yi gii yi shooshɛ Fiana yee li bɛniiŋ bɛchu-u. Se nuuŋ le, bɔɔŋ bɛnɛ bɛ buniŋ mɔɔ bɛ bukɛɛŋ be gii be ni be wuki biee bi ntiiti be tiiti li bɛniiŋ li, biee si bifiee gii bi ni bi bɛɛ lɛ bɛsɔɔŋ bɛnɛ-ɛ, bifiee se ni bi tendi bɛkaaŋ bɛnɛ, ");
INSERT INTO asj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Fɛ gii ni nuuŋ li jo yɛɛ, se shooshɛ Fiana yee li bɛniiŋ bee bɛ nimɛ-ɛ bɛchu, buniŋ bɛ bukɛɛŋ, be ni be wuki biee bi ntiiti, be tiiti li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yi gii yi fɛ biee bi bimfimu wondini liwe, tuu fɛ biee bi doonchi buŋga bwee li nshɛ-ɛ. Ŋgɔŋ bɛ wi mɔɔ njiŋ mɛ koofiyi gii mɛ nuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jobɛ gii chi to kijibɛ, kwii se dza wu yɛri si ŋgɔŋ, jobɛ chi nɔŋa chi Taa lɛ chi tɛɛmi se naa chi bɛ. ");
INSERT INTO asj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Se nuuŋ le, mɔɔ nuuŋ noo le wu gii naa teeŋ bukooŋ bu Taa lɛ, gii naa bɔnɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita tuu tee le, “Bɛniiŋ bɛ Isɛlɛɛ, yikɛ yɛŋ nɛ woo bujɔŋ fiee fi ntiiti. Jiso wu Nasarɛ tɛ̀ nuuŋ wi wu Nyɔ tɛ̀ bɔsɛyi yi doonchɛ li be-eŋ le ɛ yi yi tɛ̀ toŋ wu, si yi tɛ̀ fɛ Jiso feti biee bi doonchi buŋga bu Nyɔ-ɔ, bɛ bi bimfimu bi wondini mɔɔ bintɛ wa bi biee lɛ, lɛ be-eŋ lɛnti. Nɛ kii baa biee bini bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jiso wuni nuuŋ wi wu bɛ tɛ̀ nyɛ li be-eŋ, nuuŋ nɛɛ Nyɔ yi tɛ̀ nachɛ, si fi tɛ̀ kɛti lɛ nuuŋ ɛ yi tɛ̀ kɛɛ kituŋ. Nɛ se wo wu si nɛ tɛ̀ nyɛ wu li tsaŋ yi bɛniiŋ bɛ bifi-i, be ta wu li kintaaŋ li. ");
INSERT INTO asj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Se nuuŋ le, Nyɔ fɛ kaari yi buu wu li kwe-e, se bo li tsaŋ yi kwe-e, kifɛ kwe tɛ̀ nuuŋ yɛ le yi gii yi ba yi ni yi kɛmi li wuu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daafi tɛ̀ tee kii Jiso wuni le, ‘Ŋiŋgɔɔ Taa nuuŋ bɛ mi mfi kwi lɛ kibɛnɛ keŋ ki kigɔŋɛ-ɛ, ke fiee fimu se tɛ̀ sɛɛsɛ mi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Se nuuŋ le, shéŋ yɛŋ se wuki yɛ bujɔŋ, nse n'yeti bɛ kinɛɛtinɛ. Nnuuŋ nɛɛ si wi wu gii kwi, se nuuŋ le mbichɔɔ nɛɛ nuuŋ limfwe, ");
INSERT INTO asj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kifɛ wɛ wi wu Nyɔ nuuŋ tɛ chinɛ fiana yee li kwɛɛŋ wu bɛŋku-u kɛ. Se ɔ nuuŋ tɛ naa chinɛ ŋwana wu nimɛ wu Wuuti le fɔ lɛ dziŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɔ doonchɔɔ mi dze yi ŋgii ŋka le nse mbo. Ŋgii naa ni nɛɛtini si nuuŋ li wɛɛ limfwe.’” ");
INSERT INTO asj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita se tuu tee le, “Bɛŋwaanɛŋ, nnuuŋ nɛɛ ntee li be-eŋ mɛŋinɛ nsiŋ le te bɛtaa bɛsɛŋ wu Mfɔŋ Daafi tɛ̀ kwi, bɛ diyɛ wu, dziŋ ye se nuuŋ fɛni nsiŋ bo bɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tɛ̀ nuuŋ ntomfɔŋ wu Nyɔ, tuu kii ŋkaachɛ wu Nyɔ tɛ̀ kaachɛ yi chini le yi gii naa yi gɛɛ ŋwaŋ wu kini kee li li kabara we-e. ");
INSERT INTO asj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Se biee ŋɛŋ fiee fi Nyɔ tɛ̀ nuuŋ le yi gii naa yi fɛ, se kweeŋ le Kinsofu ki Nyɔ tɛ̀ kaachɛ gii naa ki bo li kwe-e. Fiɛɛ fiee fi tɛ̀ tee le, ‘Tɛ̀ mɛɛŋ ki ba li kwɛɛŋ wu bɛŋku-u kɛ, yi yee tɛ̀ mɛɛŋ ki fɔ kɛ lɛ dziŋ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jiso wuni wɛ ɛ Nyɔ tɛ̀ buu wu li kwe-e, wu bee bɛchu bɛ nuuŋ bɛniiŋ bee bɛ kintutu tɛ̀ ŋɛŋ wu. ");
INSERT INTO asj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyɔ yɛɛki wu yi shiiki wu lɛ kibɛnɛ kee ki kigɔŋɛ-ɛ, yi nyɛ Fiana yi Waaŋ li wuu si yi tɛ̀ kaachɛ. Fiee fi nɛ ŋiŋgi nɛ wuki dɛɛni fini nuuŋ Fiana yilu yi Jiso nyɛɔ li bee li. ");
INSERT INTO asj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ɛ Daafi wu tɛ̀ yɛɛ liboo kɛ. Daafi kibɛɛ tɛ̀ tee fiee le, ‘Taa Nyɔ tɛ̀ tee li Taa wɛŋ le, shee lɛ kibɛnɛ keŋ ki kigɔŋɛ-ɛ, ");
INSERT INTO asj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","gɛɛŋ bo mfi wu ŋgii ŋgiiki bɛniiŋ bo bɛ mbani le ɔ tɔmi bikaa bio li bee si kiga ko.’ ");
INSERT INTO asj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Se nuuŋ le, bɛniiŋ bɛchu bɛ Isɛlɛɛ se kɛɛ tɛ bujɔŋ le Jiso wuni wu nɛ tɛ̀ ta li kintaaŋ li nuuŋ wu wu Nyɔ gɛɛ le ɛ wu Taa tuu nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ.” ");
INSERT INTO asj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Le bɛniiŋ bɛlu woo lɛ, n'yɔru wulu se we be li shé-eŋ. Be se tuu be bii li Pita bee bɔɔŋ bamu bɛ nto-oŋ bɛ Jiso-o laa, “Bɛŋwaanɛŋ, tɛ gii tɛ geeŋ dɛɛni?” ");
INSERT INTO asj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita tuu li bee le, “Wi mumkpaŋ mumkpaŋ fiiki shéŋ yee, bɛ lii wu li dzɔɔ li bukooŋ bu Jiso Krai Nyɔ se feeki bibifi biee yi tuu yi nyɛ wu nya ye yi ti nuuŋ Fiana yi Waaŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ŋkaachɛ wuni wɛ li be-eŋ, mɔɔ li bɔɔŋ bɛnɛ-ɛ, mɔɔ li bɛniiŋ bɛchu bɛ nuuŋ mfiiŋ. Wu nuuŋ li bɛniiŋ bɛchu bɛ Taa wu Nyɔ-ɔ yisɛŋ teenyi be bɛɛ lɛ wuu.” ");
INSERT INTO asj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita tuu tee biee ŋge, tifi be, lɛkɛ le be fi bikoo bi bee li ŋgɛ wu gii naa bɛ li kiŋgɔkɛ ki bifi kini-i. ");
INSERT INTO asj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bɛniiŋ woo n'yɔru wu Pita wuni, bɛ ŋge beŋ, bɛ se biee bɛ lii be li dzɔɔ. Boo yɛlu bɛniiŋ taa li kintutu ki bɛniiŋ bɛ Jiso-o si bɛnchuki bɛtɛɛtu (3,000) lɛ. ");
INSERT INTO asj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Be se biee be nyɛ yi yi bee, be wuki biee nuuŋ bi bɔɔŋ bɛ nto-oŋ bɛ Jiso tɛ̀ tiifi. Bee be nuuŋ li kintutu-u, be bootini kibele, be lɛki li Nyɔ-ɔ li kintutu-u. ");
INSERT INTO asj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bɔɔŋ bɛ nto-oŋ bɛ Jiso tɛ̀ feti biee bi bimfimu bi wondini bɛ biee ŋge bi doonchi buŋga bu Nyɔ-ɔ, bɛniiŋ ŋiŋgi lɛ, fi yɛki be. ");
INSERT INTO asj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ kichu nuuŋ li fiee fi mumkpa-aŋ, be kɛmi fiee fibee fimumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Be tɛ̀ dzɛti be kabini bintsii bi bee bɛ biee bi bee, be gachi kwa wulu li yi yi bee si ŋgɛ wu wi nuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Be shiiŋ be banchi fɛ yih yi muntofi-i jo chi, be jii biee li kintutu-u li bɛla bɛ kinɛɛtinɛ li shéŋ yi bee, be tɛ̀ yɛri lii kɛ, ");
INSERT INTO asj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","be yɔɔnchi Nyɔ, bɛniiŋ bɛchu se kɔŋgisi be. Taa se suuti bɛniiŋ jo chi, tɛɛti li kintutu kibee. ");
INSERT INTO asj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Le ni nuuŋ jobɛ chimu, Pita bee Jɔɔŋ dza be yɛki fɛ yih yi muntofi-i fɛnshaaŋ jobɛ bikaa bitɛɛtu, ɛ tɛ̀ nuuŋ mfi wu li yih yibe yi lɛkɛ li Nyɔ-ɔ ");
INSERT INTO asj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nɛɛ li mfi wulu-u, ɛ bɛniiŋ too wi wumu be bɛɛ bɛ wu, be bɛ be shiiki wu fɛ fweeŋ wu mbaŋ wu bɛ tɛ̀ teenyi le fweeŋ wu Dzeeŋ, wu tɛ̀ lii li yih yi muntofi-i. Wi wulu nuuŋ ɛ bɛ tɛ̀ biɛ wu, nuuŋ kiŋkɛrɛ, bɛniiŋ bɛlu tɛ̀ shiiŋ be tuuti wu jo chi be bɛɛ be shiikisi wu fe lɛki kwa li bɛniiŋ bɛ kɛti be lii yih yi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ŋɛŋ si Pita bee Jɔɔŋ kɛti le be lɛ lu, lɛkɛ kwa li bee. ");
INSERT INTO asj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Be toŋ lii li wuu fwiiŋ. Pita se tee li wuu le, “Bichɛ bee!” ");
INSERT INTO asj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Biee bichɛ be, beechi le be gii be nyɛ wu fiee. ");
INSERT INTO asj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita tee li wuu le, “Ŋkɛmi yɛ kwa kɛ dududu, bɛdɛɛni ŋgii nyɛ wɛ fiee fi ŋkɛmi. Ntiitɔɔ li wɛɛ li bukooŋ bu Jiso Krai wu Nasarɛ, dza we ɔ dɛndɛ!” ");
INSERT INTO asj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Le tee lɛ, kɛmɛ wu li kibɛnɛ ki kigɔŋɛ-ɛ, tsaaki wu liwe. Mfwaa mumkpaŋ, bikaa bɛ muŋkɔkɔ mu wi wulu tɛmi. ");
INSERT INTO asj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jiiŋ liwe leŋ, bɛchi deŋgi. Bee be gɛɛŋ be lɛ li yih yi muntofi, deŋgi fe, jiindi liwe, yɔɔnchi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Le bɛniiŋ bɛchu bɛ tɛ̀ ŋɛŋ si tɛ deŋgi yɔɔnchi Nyɔ lɛ, ");
INSERT INTO asj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","be kɛɛ le ɛ wi wu tɛ̀ shiiŋ lɛki biee lɛ fweeŋ wu mbaŋ wɛɛ wu bɛ teenyi le Fweeŋ wu Dzeeŋ wu lii li yih yi muntofi-i. Be tɛ̀ ta maa be njanjɛ bɛ fiee fi tɛ ka bɛ wu. ");
INSERT INTO asj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wi wulu bɛnchi li Pita bee Jɔɔŋ li. Bɛniiŋ ŋɛŋ bimfimu wondɛ be, be letini be giiŋgi be chiindi be fɛ kintsii ki bɛ tɛ̀ teenyi le kiji ki Salimu-u. ");
INSERT INTO asj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Le Pita ŋɛŋ si bɛniiŋ banchi be bɛɛ lɛ, se tee li bee le, “Bɛniiŋ bɛ Isɛlɛɛ, ɛ la fi nɛ ya wa kii fiee fini, nɛ se bichi bee ni? Nɛ beechi finɛ le tɛ fɛ bɛ buŋga busɛŋ wi wuni se tuu deŋgi ni? Mɔɔ nɛ beechi le tɛ fɛ bɛ ntsɛ wusɛŋ wu wuuti le? Fi nuuŋ yɛ lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Fi nuuŋ le Nyɔ ɛ yi Abrahaŋ bee yi Adzi mɔɔ yi Yakɔ, yi nuuŋ Nyɔ yi bɛte taa bɛsɛŋ bɛchu yi tɛ̀ yɛɛki Jiso wi we wu nimɛ yi gɛɛ li wu-u lichiŋ. Jiso wuni nuuŋ wu nɛ tɛ̀ faaŋ nɛ dzɔ nɛ nyɛ li bɛniiŋ bɛ nsa-a, Pailɛt tɛ̀ wɛki le chinɛ li wuu, nɛ faaŋ. ");
INSERT INTO asj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jiso tɛ̀ nuuŋ wi wu wuuti, nuuŋ tsaaŋ, nɛ faaŋ wu, nɛ tee le bɛ buu nuuŋ wi wu tɛ̀ woyi bɛniiŋ, bɛ nyɛ li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Le nɛ fɛ lɛ nɛ se wo wi wu nyɛɛ ntsɛ li bɛniiŋ li, se nuuŋ le, Nyɔ tɛ kaari yi buu wu li kwe-e, tɛ tɛ̀ ŋɛŋ wu, tɛ̀ se tiiti baa kii wu. ");
INSERT INTO asj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ɛ li buŋga bu bukooŋ bu Jiso wuni bu fɛ kiŋkɛrɛ ki nɛ gii nɛ kii, ki se deŋgi beŋ limfwe. Fi ka lɛ kifɛ tɛ gɛɛ baa shéŋ li Jiso-o, shéŋ yi tɛ gɛɛ li Jiso-o se fɛ yɛɛ wi wuni se tɛmi bujɔŋ si nɛ ŋiŋgi ni. ");
INSERT INTO asj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Dɛɛni yani, bɛŋwaanɛ, fiee fi beŋ bɛ bikoo binɛ bi kwɛɛŋ lɛ tɛ̀ fɛ li Jiso-o nuuŋ nɛ tɛ̀ fɛ ŋkɛɛ nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Fi tɛ̀ ka lɛ yini dze-e le fi bɛ fi kɔchɛ si Nyɔ tɛ̀ fɛ bɛntomfɔŋ bɛ tiiti mɛɛŋ lindɛɛri le, Kinsofu kee ki tɛ̀ kaachɛ gii naa ki ŋɛŋ ŋgɛ. ");
INSERT INTO asj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Se nuuŋ le, nɛ fiiki shéŋ yinɛ nɛ kaari nɛ to bɛ Nyɔ, yi se feeki bibifi binɛ, ");
INSERT INTO asj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","tuu fɛ shéŋ ni yi dendi li be-eŋ yi se tuumi Krai Jiso wu Kinsofu ki tɛ̀ saa wu tsaa li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jiso wuni kɛmi le ba liboo nsiŋ gɛɛŋ bo mfi wu Nyɔ nachɛ biee bichu bi kaari bi to bifɛŋ, si tɛ̀ tee li bimfimu bi bɛntomfɔŋ bee bɛ wuuti bɛ lindɛɛri. ");
INSERT INTO asj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mɔɔsɛ tɛ̀ saa wu tee le, ‘Taa Nyɔ gii naa buu wi we wu ntoŋ wumu lɛ bɛŋwaana lɛnti, tuumi li be-eŋ nɛɛ si tɛ̀ tuumi mi, nɛ kɛmi le nɛ ni nɛ wuki fiee fichu fi tiiti li be-eŋ. ");
INSERT INTO asj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wi wu nuuŋ tɛ woo li ntomfɔŋ wulu-u kɛ, wɛ nuuŋ wu bɛ gii bɛ buu wu li kintutu ki bɛniiŋ bɛ Nyɔ-ɔ, bɛ mɛɛshi bɛ wu.’ ");
INSERT INTO asj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bɛntomfɔŋ bɛchu bɛ tɛ̀ bɛ, mbɛɛchɛ fɛ Samwɛ-ɛ mɔɔ bɛ tɛ̀ bɛ lɛ wu-u jiŋ, be tɛ̀ tee tɛ kii biee bi tɛ̀ kɛti li jo yini-i. ");
INSERT INTO asj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Biee bichu bi Nyɔ tɛ̀ kaachɛ lɛ bimfimu bi bɛntomfɔŋ bee bani biɛɛ nɛ, leh wu Nyɔ tɛ̀ ji bɛ bɛte chaa bɛnɛ. Fi fiɛɛ si Nyɔ tɛ̀ tee li Abrahaŋ le, ‘Ŋgii ntiiŋ mwɛ li bɛniiŋ bɛchu-u li kikoo ki nshɛ-ɛ lɛ dze yi ŋwana wu li wɛ-ɛ yi-ih.’ ");
INSERT INTO asj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyɔ se tsaa wi we wu nimɛ yi saa yi tuumi li be-eŋ le bɛ tiiŋ beŋ mwɛ, fɛ nɛ se chinɛ lɛ dze yinɛ yi bifi-i.” ");
INSERT INTO asj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nɛɛ si Pita bee Jɔɔŋ tɛ̀ mɛɛŋ be yeti li bɛniiŋ li lɛ, bɛte muntofi bamu bɛ kikoo ki bɛniiŋ bɛ nchi wu tɛ̀ kiichi yih yi muntofi mɔɔ Bɛsadusii bamu fɛsi fe. ");
INSERT INTO asj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Shéŋ tɛ̀ tɔnyi be kifɛ Pita bee Jɔɔŋ tɛ̀ tiifi bɛniiŋ, be tiiti le, si Jiso tɛ̀ bo li kwe-e lɛ, biŋkwi gii bi bo li kwe-e tɛ. ");
INSERT INTO asj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Be kɔɔ be, be gɛɛŋ be fa be li yih yi ncha-a, kifɛ tɛ̀ nuuŋ lɛ fɛmfo-o, nsiiŋ bu woo. ");
INSERT INTO asj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Se nuuŋ le, bɛniiŋ ŋge bɛ tɛ woo ntiifɛ wu Pita bee Jɔɔŋ tɛ̀ beŋ, kintutu ki bee se yaŋ, buniŋ tɛ̀ nuuŋ si bɛnchuki bɛtiinu (5,000). ");
INSERT INTO asj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Le bu woo, bɛkaaŋ bɛ bɛniiŋ bɛ sɛki kwɛɛŋ mɔɔ bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ, banchɛ kintsii Kimumkpaŋ Jɛrosalɛŋ ");
INSERT INTO asj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ɛ Anas wu kikoo ki bɛte muntofi-i bɛ Kaifas mɔɔ Jɔɔŋ bɛ Alɛkɛsanda mɔɔ bɛniiŋ bamu bɛ tɛ̀ nuuŋ tɛ li kini ki kikoo ki bɛte muntofi-i tɛ̀ nuuŋ fe. ");
INSERT INTO asj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Be se leeki Pita bee Jɔɔŋ li bee limfwe, be bii li bee laa, “Nɛ tuu nɛ dzɔ buŋga bu nɛ wɔnchɛ wi wuni lu fɛŋ? Nɛ tuu nɛ wɔnchɛ li bukooŋ bu noo lɛ?” ");
INSERT INTO asj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Fiana yi Waaŋ se yisɛ li Pita yi fɛ se tuu li bee le, “Bɛte kwɛɛŋ bɛ bɛniiŋ bɛ sɛki kwɛɛŋ, ");
INSERT INTO asj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nuuŋ nɛ ni nɛ biiti li bee kii nimɛ chi dzeeŋ chi tɛ tɛ̀ niŋ li kiŋkɛrɛ kini, nɛ se wɛki le nɛ kɛɛ si fi tɛ̀ ka se deŋgi ");
INSERT INTO asj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","beŋ bɛ bɛniiŋ bɛchu bɛ Isɛlɛɛ nɛ kɛɛ le wi wuni wu lemi fɛni lɛ benɛ lii dɛɛni tɛmi ni li bukooŋ bu Jiso Krai wu Nasarɛ-ɛ. Jiso wuni, ɛ wu wu nɛ tɛ̀ dzɔ nɛ ta li kintaaŋ li se kwi, se nuuŋ le, Nyɔ tɛ̀ kaari yi buu wu li kwe-e, ɛ kii wu wu wi wu lemi beŋ limfwe wuni tɛmi. ");
INSERT INTO asj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɛ Wu tɛtɛ chi Kiŋwaati ki Nyɔ-ɔ tiiti kii chi le, ‘Tɛtɛ chi beŋ bɛniiŋ bɛ ŋgwanu tɛ̀ faaŋ, ɛ chi chi dza chɛɛ chi to tɛtɛ chi fɛboo chi yi-ih.’ ");
INSERT INTO asj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wumu lu kɛ wu nuuŋ bɛ bɛ Kinsofu fuki Jiso nsiŋ. Bukooŋ bumu nuuŋ yɛ lu laaŋkwiiŋ bu Nyɔ nyɛ lɛ bɛniiŋ li linti bu nuuŋ bu soo bee kɛ”. ");
INSERT INTO asj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Le bɛniiŋ bɛ sɛki kwɛɛŋ baa woo si Pita bee Jɔɔŋ yeti nchɛnu nsiŋ lɛ, be tuu be ŋɛŋ tɛ le be baa bɛniiŋ bɛ yee, bɛ tɛ̀ mɛɛŋ ki gɛɛŋ kɛ kiŋwaati bujɔŋ kɛ, bimfimu wondɛ be. Be se kɛɛ le fi fiɛɛ lɛ, kifɛ ɛ bɛniiŋ bɛ tɛ̀ deŋgi bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Si be tɛ̀ ŋiŋgi wi wu Pita bee Jɔɔŋ tɛ̀ wɔnchɛ wɛ si lemi bee be lɛ, be foo fiee fi be nuuŋ be tee kii be. ");
INSERT INTO asj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bɛniiŋ bɛ sɛki kwɛɛŋ baa saa be buu be lɛkuuŋ, be shɛ be chuti bɛntaŋ bebe le, ");
INSERT INTO asj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ɛ la fi tɛ̀ gii tɛ̀ fɛ bɛ bɛniiŋ bani? Bɛniiŋ bɛchu bɛ Jɛrosalɛŋ kɛɛ baa kii fiee fini fi doonchi buŋga bu Nyɔ-ɔ gbanaa fi be fɛ, nuuŋ tɛ tɛ faaŋ fi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Se nuuŋ le, le tɛ fɛ le kiiŋ ntoŋ wuni ni saaŋgɛ wu gɛɛŋ limfwe kɛ, tɛ̀ nchiinsɛ li bɛniiŋ bani le kiiŋ be ni mɔŋ ntefu fiee li wi-i kii bukooŋ bu Jiso-o buni kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Be teeŋ Pita bee Jɔɔŋ be kaari be lɛ. Be se chee be bintooŋ le kiiŋ be ni naa tuu be mɔŋ ntefu mɔɔ nuuŋ ntiifɛ wi kii bukooŋ bu Jiso-o kɛ. ");
INSERT INTO asj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita bee Jɔɔŋ tuu fi bee le, “Beechɛ yɛŋ laa fiee fi nuuŋ tsaaŋ lɛ Nyɔ lii nuuŋ le tɛ woo li be-eŋ mɔɔ li Nyɔ-ɔ le? ");
INSERT INTO asj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tɛ nuuŋ tɛ tɛ chikɛ ntefu kii biee bi tɛ tɛ̀ ŋɛŋ bɛ bi tɛ tɛ̀ woo bini kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bɛniiŋ bɛ sɛki kwɛɛŋ baa se bɔsɛyi be chee be bintooŋ ŋge, be chinɛ li bee be giiŋgi. Ɛ be tɛ̀ foo fiee fi nuuŋ be lii be li ŋgɛ-ɛ, kifɛ bɛniiŋ bɛchu tɛ̀ yɔɔnchi Nyɔ li fiee fi tɛ̀ ka-a, ");
INSERT INTO asj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","fi ŋge tɛ̀ nuuŋ le wi wu bɛ tɛ̀ fɛ fiee fi doonchi buŋga bu Nyɔ-ɔ, yi wɔnchɛ wu wɛɛ tɛ̀ yaa biya mbaanyɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Si be tɛ̀ chinɛ li Pita bee Jɔɔŋ li lɛ, be kaari be to lijiŋ fɛ bɛniiŋ bɛ bee bɛ kintutu-u, be tee be fiee fi bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ tee li bee. ");
INSERT INTO asj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Le be woo lɛ, be banchɛ yih yi be, be lɛkɛ li Nyɔ-ɔ li fiee fi mumkpaŋ le, “Taa wu Te Kikoo, ɛ wɛ wu tɛ̀ fɛ kiboo bee nshɛ bɛ dzɔ́ɔ mɔɔ biee bichu bi nuuŋ li bintsii bini-i. ");
INSERT INTO asj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɔ tɛ̀ fɛ te bɛtaa bɛsɛŋ wu Daafi, wu tɛ̀ nuuŋ ŋwana wu nimɛ kweeŋ li buŋga bu Fiana yi Waaŋ li le, ‘Ɛ kii la fi bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ fuuti bɛ fiee li shéŋ yi bee, bɛniiŋ chuti bɛntaŋ bɛ nuuŋ tɛ niŋ kɛ? ");
INSERT INTO asj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bɛmfɔŋ bɛ laaŋkwiiŋ nachi baa yi yibee li dzi-iŋ, bɛniiŋ bɛ sɛki kwɛɛŋ banchi yi yibee le be gwe bɛ Taa bɛ wi we wu tsi le ni nuuŋ Kinsofu.’ ");
INSERT INTO asj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ɛ nɛɛ chɛɛŋ li fiee fi tɛ̀ ka fɛ kintsii kini-i. Mfɔŋ Hɛrɔ bee Pontu Pailɛt tɛ̀ banchɛ bɛ bitoŋ mɔɔ bɛniiŋ bɛ Isɛlɛɛ be bɛ bɛ kimfiɛ lɛ Jiso jiŋ wu Ŋwana wu nimɛ wu wuuti wu ɔ tɛ̀ tsi le ni nuuŋ Kinsofu. ");
INSERT INTO asj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Be tɛ̀ banchi le be fɛ nuuŋ biee bi ɔ tɛ̀ nachɛ kituŋ lindɛɛri bɛ buŋga bwo le ɔ wɛki le bi bɛ bi ka. ");
INSERT INTO asj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dɛɛni yani Taa, bichɛ ɔ ŋɛŋ dze yi bɛniiŋ bani chɛnisi bee. Nyɛ bee bɛniiŋ bo bɛ nimɛ shéŋ yi tɛɛmi le be ni be tiifi jɛ ya nchɛnu nsiŋ dududu. ");
INSERT INTO asj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nyɛ bee buŋga bwo bu wɔnchɛ bɛniiŋ tɛ tuu tɛ ni tɛ feti biee bi doonchi buŋga bwo mɔɔ biee bi bimfimu wondini li bukooŋ bu Jiso wu Ŋwana wu nimɛ wu wuuti.” ");
INSERT INTO asj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Le be mɛɛshi nlɛkɛ li Nyɔ-ɔ lɛ, nshɛ sɛɛsɛ fɛ be tɛ̀ nuuŋ. Fiana yi Waaŋ yisɛ li bee, be tiifi jɛ yi Nyɔ nchɛnu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ kichu tɛ̀ nuuŋ li mbeechɛ mumkpa-aŋ, mɔɔ li fiee fi mumkpa-aŋ, wi teenyi yɛ fiee fimu le ɛ fiee fiee wuu mbiiŋ kɛ. Fiee fi wi nuuŋ fiee fi wi kwikwi. ");
INSERT INTO asj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nyɔ nyɛ buŋga bunɔŋa li bɔɔŋ bɛ nto-oŋ bɛ Jiso-o, be tuu be tiifi nɛɛ bɛniiŋ ŋge le Taa Jiso boɔ li kwe-e. Be nuuŋ ɛ mfiɛ wu Nyɔ nuuŋ li bee bɛchu-u ŋge. ");
INSERT INTO asj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wi tɛ̀ nuuŋ yɛ li bee linti wu fuki fiee kɛ, kifɛ bɛniiŋ bɛ tɛ̀ kɛmi yíh tɛ̀ kabini, be bɛɛ bɛ kwa wulu, ");
INSERT INTO asj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","be nyɛɛ li tsaŋ yi bɔɔŋ bɛ nto-oŋ bɛ Jiso-o, be se gachi li bɛniiŋ bɛchu si ŋgɛ wu wi tɛ̀ nuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Wi wumu tɛ̀ nuuŋ lu bɛ teenyi wu le Jɔsɛ, bɔɔŋ bɛ nto-oŋ bɛ Jiso-o tɛ̀ nyɛ wu bukooŋ bwee bumu le Banaba, (bu nuuŋ le, wi wu Kaŋgisi Shéŋ yi bɛniiŋ). Tɛ̀ nuuŋ wi wu li kini ki Lebi, ɛ bɛ tɛ̀ biɛ wu Saaplu. ");
INSERT INTO asj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tuu gɛɛŋ tɛ kabɛ wɛ wee, bɛ nyɛ kwa wulu li tsaŋ yi bɔɔŋ bɛ nto-oŋ bɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wumu wu bɛ tɛ̀ teenyi le Ananiya bee kwɛsi wu Safira tɛ̀ kabɛ tɛ kimbɛ ki kintsii lɛ. ");
INSERT INTO asj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tɛ̀ gatɛ fɛ kwa wulu kiri, kwɛsi kii fe. Se dzɔ kiŋkɛ gɛɛŋ nyɛ li tsaŋ yi bɔɔŋ bɛ nto-oŋ bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Le nyɛ lɛ, Pita se bii li wu laa, “Ananiya, ɛ la fi ge ɔ se gɛɛ le Sataŋ lɛ li shéŋ ya le fɛ le ɔ yɛɛŋ binsɛɛ li tsaŋ yi Fiana yi Waaŋ li, ɔ se tuu ɔ tsɔɔ fɛ kwa wuɔ bee ɔ kabɛ kintsii lu wɛɛ? ");
INSERT INTO asj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fɛ ɔ bee ɔ kabini kintsii kini bee nuuŋ nɛɛ ko ni? Fɛ ɔ bee ɔ kabɛ, kwa wulu bee nuuŋ nɛɛ wa ni? Ɔ geeŋ ɔ se fɛ ŋwaani fini fiee ni? Ɔ mɛɛŋɔ ki yɛɛŋ kɛ nuuŋ bɛ bɛniiŋ kɛ, ɔ yɛɛŋɔ nuuŋ bɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mfwa mumkpaŋ si Ananiya tɛ̀ woo n'yɔru wuni lɛ, we fɛkwiiŋ kwi. Bɛniiŋ bɛchu bɛ tɛ̀ woo fiee filu tɛ̀ chɛŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bɛsɔɔŋ bɛ buniŋ lɛ, bɛ be fiɛɛmɛ wu fɛ ndu-u, be dzɔ wu be bo bɛ wu be gɛɛŋ be diyɛ. ");
INSERT INTO asj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Le gɛɛŋ bo bikaa bi mfi si bɛtɛɛtu lɛ, kwɛsi biee lɛ, kii yɛ fiee fi bee fi ka bɛ nyumi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita bii li wuu laa, “Tee nɛɛ mi, wuni nuuŋ kwa kwikwi wu nɛɛ nyuma bee nɛ kabɛ wɛ lu ni?” Tuu le, “Iiŋ ɛ wu lɛ kwikwi.” ");
INSERT INTO asj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita tuu bii li wuu laa, “Nɛɛ nyuma nɛ ge niŋ nɛ nachɛ le nɛ mɔnchɛ Fiana yi Taa? Yikɛ ɔ woo, nchiiŋ yi bɛniiŋ bɛ bee be gɛɛŋ be diyɛ nyuma yɛɛ fweeŋ kituŋ, be gii be lɛ be too tɛ wɛ be bo bɛ wɛ be gɛɛŋ be diyɛ.” ");
INSERT INTO asj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Le Pita yɔ lɛ, mfwaa mumkpaŋ Safira biee we lɛ wu-u lii kwi. Le bɛsɔɔŋ baa tuu be lɛ be ŋɛŋ ɛ wu kwi kituŋ, be se too wu be bo bɛ wu be gɛɛŋ be diyɛ li nyumi-i li lichiŋ. ");
INSERT INTO asj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ kichu mɔɔ bɛniiŋ bɛchu bɛ tɛ̀ woo fiee filu chɛŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bɔɔŋ bɛ ntoŋ bɛ Jiso fɛ biee bi doonchi buŋga bu Nyɔ-ɔ bɛ bintɛwa bi biee lɛ ŋge li bɛniiŋ li linti. Bɛniiŋ bɛ kimbeenchɛ-ɛ bɛchu tɛ̀ shiiŋ be banchi fɛ kiji ki Salimu ki li yih yi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bɛniiŋ bɛ yee tɛ̀ mendi yɛ ntaashɛ bɛ be kɛ. Se nuuŋ le bɛniiŋ tɛ̀ shiiŋ be piɛti be ŋge. ");
INSERT INTO asj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Buniŋ bɛ bukɛɛŋ ŋge bɛ tɛ̀ gɛɛ shéŋ li Taa li bɛɛ be tɛɛti li kintutu ki bee. ");
INSERT INTO asj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Biee bi bɔɔŋ bɛ nto-oŋ bɛ Jiso tɛ̀ feti, tɛ̀ fɛ bɛniiŋ tuuti bɛniiŋ bɛ chigɔ-ɔŋ be gikisi li dzé lichiŋ li bida-aŋ mɔɔ li biga-a le ke Pita kɛtɔɔ, mɔɔ nuuŋ kinjiinjii kee ki we li bee. ");
INSERT INTO asj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bintutu bi bɛniiŋ lɛ bilu tɛ dzɛti li bintsii bi li Jɛrosalɛŋ lichiŋ bi bɛɛ bɛ bɛniiŋ bɛ chigɔ-ɔŋ mɔɔ bɛ kɛmi fiana yi tii lɛ bee, be wɔnchi be bɛchu. ");
INSERT INTO asj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kikoo ki bɛte muntofi bɛ kintutu kee ki Bɛsadusii tɛ̀ dza be bɛchi be yɛɛti shéŋ bɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o, ");
INSERT INTO asj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","be tuu be toŋ bɛniiŋ be gɛɛŋ be kɔɔ be, be bɛŋɛ be li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Se nuuŋ le, le ni nuuŋ butuu nchindaa wu Taa gwiyɛ bigoo bi yih yi ncha-a buu be. Si tɛ̀ buu be lɛ, tuu tee le, ");
INSERT INTO asj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Gɛnɛ yɛŋ li yih yi muntofi-i kibɛɛ, nɛ gɛɛŋ nɛ ni nɛ tiifi fiee fichu li bɛniiŋ li kii ntsɛ wu fwɛŋ wuni.” ");
INSERT INTO asj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Si be tɛ̀ woo lɛ, be se gɛɛŋ. Le lɛkuuŋ bɛchi ŋ'wofu, be lɛ li yih yi muntofi, be bɛchi be tiifi bɛniiŋ. Nɛɛ li mfi wulu, kikoo ki bɛte muntofi-i bɛ bɛniiŋ bee bɛ kintutu, se konchɛ bɛniiŋ bɛ Isɛlɛɛ bɛ sɛki kwɛɛŋ bɛchu le bee be shee, se toŋ bɛniiŋ bɛ nchi-i le be gɛɛŋ li yih yi ncha-a, be bɛ bɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Be gɛɛŋ be bo fe, be gɔɔŋ be nsiŋ be to lijiŋ be tee le, ");
INSERT INTO asj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tɛ gɛɛŋ baa tɛ bo li yih yi ncha-a, tɛ ŋɛŋ si bigoo nuuŋ ɛ bɛ bɔsɛyi bɛ bɛŋɛ, bɛniiŋ bɛ nchi-i lemi fe be kiichi. Le tɛ ni tɛ gwiyi yih yilu tɛ mɛɛŋ ki ŋɛɛŋ wi lu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Le kikoo ki bɛniiŋ bɛ nchi bɛ tɛ̀ kiichi yih yi muntofi bɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa, woo lɛ, fi fieeŋgi be, be bɛchi be tɛti maa laa be gii be to fɛŋ bɛ fini fiee le. ");
INSERT INTO asj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wi dza lɛ tee li bee le, “Woo yɛŋ, bɛniiŋ bɛ nɛ tuu nɛ fa li yih yi ncha baa, be baa kituŋ li yih yi muntofi be tiifi bɛniiŋ.” ");
INSERT INTO asj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Le be woo lɛ, kikoo ki bɛniiŋ bɛ nchi-i bee kintutu kee biee be bo be gɛɛŋ be dzɔ be, be bɛ bɛ be. Se nuuŋ le, be tɛ̀ kɛndi yɛ be bu kanu kɛ, kifɛ bɛniiŋ bɛ nchi-i bɛlu tɛ̀ chɛndi le nuuŋ bɛniiŋ tomɛ be bɛ ta. ");
INSERT INTO asj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Le be bɛ bɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso baa, be lɛ bɛ be, be leeki limfwe li bɛniiŋ bɛ sɛki kwɛɛŋ li. Kikoo ki bɛte muntofi kilu se biiti biee li bee ki tiiti le, ");
INSERT INTO asj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tɛ tuu tɛ gbɛɛŋ tɛ loosɛ le kiiŋ nɛ ni tuu nɛ mɔŋ ntiifɛ wi kii bukooŋ bu wi wuni kɛ. Se nuuŋ le, ŋɛŋ yɛŋ fiee fi nɛ mɔŋ! Nɛ fɛ baa ntiifɛ wunɛ tuu wu saaŋgɛ wu gɛɛŋ Jɛrosalɛŋ kwikwi. Nɛ wɛki le nɛ fɛ le fi doonchɛ le tɛ kii baa fiee fɛ kwe ye.” ");
INSERT INTO asj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita bee kintutu ki bɔɔŋ bɛ nto-oŋ bɛ Jiso tuu le, “Tɛ kɛmi le tɛ ni tɛ wuki nuuŋ li Nyɔ-ɔ, yɛki fɛ tɛ nuuŋ tɛ woo li wi-i. ");
INSERT INTO asj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nɛ tɛ̀ ta Jiso li kintaaŋ li kwi. Nyɔ yi bɛte taa bɛsɛŋ buu wu li kwe-e, ");
INSERT INTO asj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nyɔ tɛ̀ yɛɛki wu, yi shiiki wu lɛ kibɛnɛ kee ki kigɔŋɛ le ni nuuŋ Te Kikoo mɔɔ Kinsofu, le ke bɛniiŋ bɛ Isɛlɛɛ fiiki shéŋ yi bee, yi yi Nyɔ feeki bibifi bi bee. ");
INSERT INTO asj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tɛ ŋɛŋ baa biee bini tɛ se tiiti li bɛniiŋ li ki Fiana yi Waaŋ yi Nyɔ nyɛɛ li bɛniiŋ bɛ wuki yi-i, be beenchi yɛ tɛ le bi biɛɛ chɛɛŋ.” ");
INSERT INTO asj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Si bɛniiŋ bɛ tɛ sɛki kwɛɛŋ baa woo n'yɔru wuni ni, sheŋ tɛ̀ yɛɛ be ŋge. Be wɛki le be woyɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Se nuuŋ le, wumu li kintutu ki bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ wu bukooŋ bwee tɛ̀ nuuŋ le Gamaliya, nuuŋ tɛ wi Bɛfarasii mɔɔ wi wu tiifi bɛnchi bɛ Nyɔ-ɔ, wu bɛniiŋ bɛchu tɛ̀ guundi wu ŋge, dza we, tee le be saa be buu bɔɔŋ bɛ nto-oŋ bɛ Jiso lɛkuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Shɛ kweeŋ li bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ baa le, “Bɛniiŋ bɛ Isɛlɛɛ, dzɔɔ yɛŋ mfi bɛ fiee fi nɛ wɛki le nɛ fɛ bɛ bɛniiŋ bani fini. ");
INSERT INTO asj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nɛ kimi le tɛ̀ nuuŋ li mfi wumu, wi wumu tɛ̀ dza fɛni bɛ teenyi wu le Teoda, doonchi le ɛ wu wi wu nyɔŋa. Bɛniiŋ se tɛ̀ suuki lɛ wuu jiŋ be nuuŋ si gii nɛɛ. Bɛ tɛ̀ wo wu kintutu kee shaanshɛ, fiee fi tɛ̀ bɛɛ bɛ fi laayɛ li yee li. ");
INSERT INTO asj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lɛ jiŋ lɛlu, wumu tuu dza li mfi wu bɛ tɛ̀ fɛɛ bɛniiŋ li bɛ teenyi wu le Judas, ɛ tɛ̀ nuuŋ wi wu Galilii. Tɛ chee tɛ bɛniiŋ ŋge lɛ wu-u jiŋ. Bɛ tɛ̀ wo wu, kintutu kee shaanshɛ. ");
INSERT INTO asj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Li nsa wuni, ntiifɔɔ beŋ le kiiŋ nɛ ni fɛ fiee bɛ bɛniiŋ bani kɛ. Nɛ chinɛ li dze yi bee. Kifɛ, ɛ nuuŋ le fiee fini fi be bɛɛ bɛ fi, be se tuu be tiifi bɛniiŋ lu ɛ wi wu bɔ wu bɛchi, kɛ fi gii fi la li yee li. ");
INSERT INTO asj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Se nuuŋ le, ɛ fiee filu nuuŋ mbeechɛ wu Nyɔ-ɔ, kɛ nɛ nuuŋ tɛ̀ naa yaa be kɛ. Ɛ nɛ dzeti yɛ mfi kɛ, fi dza fi nuuŋ le nɛ gwii baa nuuŋ bɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Si Gamaliya tɛ̀ kweeŋ lɛ, bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ baa woo ntifi yee, be kaari be teeŋ bɔɔŋ bɛ nto-oŋ bɛ Jiso le be lɛ. Le be lɛ lɛ, be fiaaŋ be, be chiinsɛ le kiiŋ be ni tuu be mɔŋ ntiifɛ wi kii bukooŋ bu Jiso-o kɛ, be se chinɛ li bee be gɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Le be bo lu be giiŋgi fibee bɛ kinɛɛtinɛ le be kɔchɛ baa bɛniiŋ bɛ fii buya kii bukooŋ bu Jiso. ");
INSERT INTO asj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Be gɛɛŋ lɛ, be tuu be tiifi nɛɛ bɛniiŋ jo chichi li yih yi muntofi-i mɔɔ li bɛla, be tiifi ntoŋ wu dzeeŋ wu nuuŋ le Jiso nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ. ");
INSERT INTO asj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Le ni nuuŋ mfi wumu, si kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ tɛ̀ kuu ki giiŋgi limfwe lɛ, Bɛjuu bɛ tɛ̀ yeti jɛ́ yi Grik dza be bɛchi be ŋunyi Bɛjuu bɛ tɛ̀ yeti jɛ́ yi kwɛɛŋ le be gachi baa biee li bukɛɛŋ bɛɛŋku-u jo chichi be tɛ̀ bichɛ lɛ bɛ bee kɛ. ");
INSERT INTO asj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Se nuuŋ le, bɔɔŋ bɛ nto-oŋ bɛ Jiso-o bɛ yoofi ntsɔ bɛfɛ baa se konchɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ kichu be tee li bee le, “Fi mɛɛŋ ki dzɔɔŋ kɛ le tɛ chinɛ jɛ yi Nyɔ tɛ gɛɛŋ tɛ shee tɛ ni tɛ gachi nuuŋ biee bijɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bɛŋwaanɛŋ, fi dzɔɔŋ le nɛ buu bɛniiŋ mfomɛnyaaŋ li be-eŋ linti, tɛ nyɛ nimɛ chini li tsaŋ yi bee. Ɛ nɛ busi lɔɔ, nɛ bichi nuuŋ bɛniiŋ bɛ kɛmi ntsɛ wu dzeeŋ, bɛ yisɛ bɛ Fiana yi Waaŋ be kɛmi tɛ bufii. ");
INSERT INTO asj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tɛ se nyɛ yi yisɛŋ nuuŋ li nlɛkɛ li Nyɔ-ɔ bɛ nimɛ chi jɛ yi Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bɛniiŋ bɛchu woo ntaŋ wulu, wu dzɔɔŋ fɛ bee, be se buu Fitifiŋ wu tɛ̀ nuuŋ wi wu kimbeenchɛ wu tɛ̀ gbɛɛŋ wu yisɛ bɛ Fiana yi Waaŋ. Bamu tɛ̀ nuuŋ Fili bee Prukolu, Nikano bee Timɔŋ, Pamɛna bee Nikola wu tɛ̀ nuuŋ wi wu Antiɔk wu tɛ̀ fiiki bufikisɛ wu to wi wu kimbeenchɛ wu Bɛjuu. ");
INSERT INTO asj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Be se dzɔ bɛniiŋ bani be leeki limfwe li bɔɔŋ bɛ nto-oŋ bɛ Jiso-o, be gɛɛ tsaŋ li bee, be lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jɛ yi Nyɔ se saaŋgini yi giiŋgi. Kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Jɛrosalɛŋ se kuu ki giiŋgi limfwe. Bɛte muntofi ŋge se giki shéŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Fitifiŋ tɛ̀ nuuŋ ɛ wu yisɛ bɛ kimbɔnɛ ki Nyɔ-ɔ mɔɔ buŋga, feti biee bi bɛniiŋ tɛti maa bɛ biee bi doonchi buŋga bu Nyɔ-ɔ li bɛniiŋ li linti. ");
INSERT INTO asj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bɛniiŋ bamu dza be bɛchi bitɛchinɛ bɛ Fitifiŋ. Bɛniiŋ bɛlu tɛ̀ nuuŋ Bɛjuu bɛ tɛ̀ dzɛti Sɛli-iŋ bɛ Alɛkɛsanda mɔɔ Silisha bɛ Eesha. Be tɛ̀ nuuŋ bɛniiŋ bɛ li yih yi nlɛkɛ li Nyɔ-ɔ, yi bɛ teenyi le Bɛmfa bɛ Bo li Bumfa-a. ");
INSERT INTO asj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Si be tɛ̀ tɛchini lɛ, Fiana yi Waaŋ nyɛ Fitifiŋ bufii wi tɛ̀ nuuŋ lu wu nuuŋ yaa wu li fiee fi tiiti kɛ. ");
INSERT INTO asj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Be se dza be kunyɛ bɛniiŋ bamu lɛjiŋ lɛjiŋ be bɛchi be yɛŋgi le be woo baa Fitifiŋ tiiti jɛ́ yi bifi kii Mɔɔsɛ bee Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Si be tɛ̀ fɛ lɛ, be se sɛɛsɛ shéŋ yi bɛniiŋ, mɔɔ yi bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ, mɔɔ yi bɛniiŋ bɛ tɛ̀ tiifi bɛnchi bɛ Nyɔ-ɔ. Be se biee be lɛ li Fitifiŋ, be dzɔ wu be gɛɛŋ bɛ wu li bɛniiŋ bɛ sɛki kwɛɛŋ li mɔɔ bɛniiŋ bɛ doonchi bɛnchi bɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bɛniiŋ baa tuu be bɛ bɛ bɛniiŋ bamu le be leŋ lɛ nsa wu binsɛɛ lɛ lɛjiŋ, be ni be kayi biee li Fitifiŋ, be tiiti le, “Wi wuni ti naa nuuŋ yɛ ntefu jɛ́ fuki yi bifi kii yih yi muntofi yini bɛ bɛnchi bɛ Mɔɔsɛ nsiŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tɛ woo baa tiiti le Jiso wu Nasarɛ wɛ gii naa kɛsi yih yi muntofi yini, tuu fiiki ntsɛ wu kwɛɛŋ wusɛŋ wu Mɔɔsɛ tɛ̀ nyɛ li bee li wuni.” ");
INSERT INTO asj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bɛniiŋ bɛchu bɛ tɛ̀ nuuŋ li yih yi nsa-a yɛ luuŋgi lii li Fitifiŋ, be dza be ŋɛŋ ɛ bushi bwee fiiki bu bosini bu nchindaa wu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kikoo ki bɛte muntofi-i bii li Fitifiŋ laa, “Biee bi bɛ tiiti bini nuuŋ chɛɛŋ ni?” ");
INSERT INTO asj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Fitifiŋ tuu le, “Bɛtaa mɔɔ bɛŋwaanɛŋ, yikɛ yɛɛŋ nɛ woo. Nyɔ yi bunɔŋa tɛ̀ busɛ li taa wusɛŋ wu Abrahaŋ fɛ tɛ̀ mɛɛŋ tsiiŋ Misopotemia, se naa dza gɛɛŋ tuu ni tsiiŋ Halaŋ, ");
INSERT INTO asj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","yi tee li wuu le, ‘Chinɛ kini ko, ɔ bo li kwɛɛŋ wuni-i, ɔ gɛɛŋ li kwɛɛŋ wu ŋgii ndoonchɛ li wɛ-ɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Se nuuŋ le, tɛ̀ dza li nshɛ yi Kaaldia-a, gɛɛŋ tsiiŋ Halaŋ. Si tee tɛ̀ kwi, Nyɔ fɛ se dza bɛ fɛ nɛ tsiiŋ dɛɛni fɛni. ");
INSERT INTO asj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Le ni nuuŋ fɛni, Nyɔ ti mɛɛŋ ki nyɛ kɛ wu fi kintsii kɛ, se nuuŋ le, yi tɛ̀ kaachɛ wu nuuŋ le yi gii yi nyɛ wu kwɛɛŋ wuni, wu ni wu nuuŋ wee bee kiŋgɔkɛ kee. Nyɔ tɛ̀ kaachi lɛ, Abrahaŋ mɛɛŋ mɔɔ saa kɛ le kɛmɛ ŋwaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nyɔ se tuu yi tee li wuu le, ‘Kiŋgɔkɛ ko gii ki ni ki nuuŋ mfoŋ yi kwɛɛŋ wumu, ki ni ki nindi bumfa le, bɛ ni bɛ ŋwɛki bɛ ki li biya gii nɛɛ li (400). ");
INSERT INTO asj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ŋgii nlɔŋ ŋgɛ li kwɛɛŋ wulu-u, kiŋgɔkɛ ko bo le ki bɛ ki ni ki guundi mi lani.’ ");
INSERT INTO asj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nyɔ tuu yi ji Leh bɛ Abrahaŋ, ndoonchɛ wu Leh wulu tɛ̀ nuuŋ le Abrahaŋ gii ni sɛɛti bɔɔŋ bee dzóo. Le Abrahaŋ biɛ Adzi, le bo jo nyaaŋ sɛɛ wu dzoo. Le Adzi tuu biɛ Yakɔ sɛɛ tɛ wu dzoo. Yakɔ tɛ̀ sɛɛ bɔɔŋ bee bɛ yoofi ntsɔ bɛfɛ baa dzóo bɛ nuuŋ bɛte taa bɛsɛŋ fɛ kini kisɛŋ tɛ̀ bo. ");
INSERT INTO asj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bɛte taa bɛsɛŋ bɛlu tɛ̀ dza be yɛɛti shéŋ bɛ Jɔsɛ wu ŋwaani wu be, be se kabɛ wu, gɛɛŋ nuuŋ mfwa li kwɛɛŋ wu Iji-ip. Se nuuŋ le, Nyɔ se bichi lɛ wuu, ");
INSERT INTO asj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yi fii wu li bɛŋgɛ bee li bɛchu. Nyɔ se tuu yi nyɛ wu bufii yi fɛ Fɛrɔ Mfɔŋ wu Ijip kɔŋgisi wu, se gɛɛ wu li njii we-e, tuu nuuŋ wi wu bichi lɛ kini kee le. ");
INSERT INTO asj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dzeeŋ tɛ̀ dza yi kɔɔ Ijip kwikwi mɔɔ Kana, bɛniiŋ ŋɛŋ ŋgɛ ŋge. Bɛte taa bɛsɛŋ tɛ̀ kɛmi yɛ fiee fijɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Le Yakɔ woo le biee bijɛ biɛɛ Ijip, se toŋ bɔɔŋ bee bɛ tɛ̀ nuuŋ bɛte taa bɛsɛŋ, be gɛɛŋ le li kiŋga ki ŋkosi-i. ");
INSERT INTO asj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Le be gɛɛŋ le li kiŋga kifɛ-ɛ, Jɔsɛ se fɛ bɛŋwaani kɛɛ wu, doonchɛ tɛ be li Fɛrɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jɔsɛ tuumi ntoŋ li Yakɔ wu tee li le, bee kini kee kichu bɛ Ijip. Kini ki Yakɔ tɛ̀ nuuŋ mfi wulu bɛniiŋ gwii mfomɛnyaaŋ ntsɔ bɛtiinu (75). ");
INSERT INTO asj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Le Yakɔ woo lɛ, se dzɔ kini kee kichu bɔɔ Ijip. Wu bee bɛte taa bɛsɛŋ se tɛ̀ kwiyɛ le bɛchu. ");
INSERT INTO asj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bɛ tɛ̀ too yɛ gooŋ yi be bɛ kaari bɛ bɛ yi lani, bɛ diyɛ be Shɛkeŋ lɛ dziŋ yi Abrahaŋ tɛ̀ go li bɔɔŋ bɛ Hamɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Mfi tɛ̀ gii kɔchini wu Nyɔ tɛ̀ nuuŋ le yi gii yi fɛ fiee fi yi tɛ kaachɛ Abrahaŋ lu, bɛniiŋ bɛsɛŋ tɛ̀ yaŋ Ijip ŋge. ");
INSERT INTO asj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bɛniiŋ bɛ le tɛ̀ kokɛ mfɔŋ wumu wu tɛ̀ kii yɛ Jɔsɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mfɔŋ wulu bɛchi ŋwɛki bɛ bɛniiŋ bɛsɛŋ lɛ bufii li, kɛndi bɛte taa bɛsɛŋ le be toofɛ bɔɔŋ bɛ bwi lɛkuuŋ be kwiyɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Li mfi wulu-u bɛ tɛ̀ biɛ Mɔɔsɛ, tɛ̀ gii nuuŋ ŋwaŋ wu dzeeŋ ŋge li Nyɔ-ɔ. Bɛ kɛmɛ wu li yih kii tɛɛ, ");
INSERT INTO asj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","be se dzɔ wu bɛ gɛɛ lɛkuuŋ. Ŋwanɛ Mfɔŋ Fɛrɔ wu kwɛɛŋ se gɛɛŋ bɔɔŋ wu, kii wu si ŋwani. ");
INSERT INTO asj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bɛ se tiifi Mɔɔsɛ bufii bu Ijip buchu, tɛ̀ nuuŋ wi wu kii n'yɔru mɔɔ biee bi fɛrɛ bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Le ni nuuŋ biya mbaanyɛɛ, tɛ̀ dza beechɛ le gii la ŋka lɛ bɛŋwaani bɛ tɛ̀ nuuŋ bɛniiŋ bɛ Isɛlɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Le ni giiŋgi ŋɛŋ si wi wu Ijip nusini wi wu Isɛlɛɛ wumu. Lɛ fe le tuu nsooŋkibaa, tuu wo wu buwo. ");
INSERT INTO asj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Beechi le bɛŋwaani gii be kɛɛ le ɛ Nyɔ yi toŋ yɛ wu le bɛ buu be li ŋgɛ-ɛ. Se nuuŋ le, be ti mɛɛŋ ki kɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Le butuu woo, Mɔɔsɛ bo giiŋgi, mbundɛ li bɛniiŋ bɛ Isɛlɛɛ bɛfɛ be gwii. Lɛ fe le gatɛ bugwe bulu, bii li bee laa, ‘Bɛŋwaanɛŋ, nɛ baa wi bee ŋwaani, fi ge la fi nɛ tuu gwii li yi yinɛ?’ ");
INSERT INTO asj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wi wu tɛ̀ nusini ŋwaani wɛ bachɛ wu bu bachɛ, bii li wuu laa, ‘Ɛ noo wu gɛɛ wɛ le ɔ ni ɔ sɛki bee, ɔ sondini mɔɔ bɛnsa bɛsɛŋ? ");
INSERT INTO asj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɔ wɛki le ɔ wo mi si wi wu Ijip wo ɔ tuu ɔ wo mfo wɛ ni?’ ");
INSERT INTO asj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Le Mɔɔsɛ woo lɛ, tuu chɛŋ dza li kwɛɛŋ wu Iji-ip, kifi gɛɛŋ nuuŋ li kwɛɛŋ wu Midia, fɛ tɛ̀ biɛ bɔɔŋ bɛ buniŋ fe bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Le biya mbaanyɛɛ ka, nchindaa wu Nyɔ busɛ li Mɔɔsɛ si wi, wu duti li kiti ki li buka li ŋkumɛ wu Sina-a lichiŋ. ");
INSERT INTO asj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Le Mɔɔsɛ ŋɛŋ fi yaa wu, kiiŋgi lu lichiŋ le bichɛ bujɔŋ. Le kiiŋgi woo si Taa Nyɔ kweŋ li wuu le, ");
INSERT INTO asj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ɛ mi wu nuuŋ Nyɔ yi bɛte chaa bɛnɛ, Nyɔ yi Abrahaŋ bɛ yi Adzi mɔɔ yi Yakɔ.’ Le Mɔɔsɛ woo lɛ, kaa bɛ chɛnɛ, mɛɛŋ tuu kɛ le mɔŋ mbichɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Taa Nyɔ tuu yɔ li wuu le, ‘Buushɛ bikpɔ bio, kifɛ fɛ ɔ lemi fɛɛ ɛ kintsii ki wuuti. ");
INSERT INTO asj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi gbɛɛŋɔɔ mi ŋɛŋ si bɛ ŋwɛki bɛ bɛniiŋ beŋ Ijip, mi ntuu mi ŋwoo si be chendi, mi se sheeɔ mi mbɛ le mbuu be li ŋgɛ wulu-u. Yikɛ ɔ woo, ŋgii ntoŋ wɛ Ijip dɛɛni.’ ");
INSERT INTO asj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mɔɔsɛ wuni nuuŋ wu be tɛ̀ saa be faaŋ wu, be biiti li wuu laa, ‘Ɛ noo wu gɛɛ wɛ le ɔ ni ɔ sɛki bee, ɔ sondini mɔɔ bɛnsa bɛsɛŋ le?’ Ɛ yi yi Nyɔ yi tɛ̀ toŋ le gɛɛŋ ni nuuŋ wi wu sɛki be, se buu be li ŋgɛ-ɛ. Nyɔ tɛ̀ toŋ nuuŋ nchindaa we, bɛ li kiti ki tɛ̀ duti kɛɛ le tee ntoŋ wulu li wuu. ");
INSERT INTO asj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mɔɔsɛ se gɛɛŋ Ijip, fɛ biee bi bimfimu wondini bɛ biee bi koofiyi, buu be le. Fɛ bimu fɛ Dzɔɔ yi Nyɔŋa yi Yɛchi, tuu fɛ bimu libuka lɛ be tɛ̀ deŋgi li biya mbaanyɛɛ li. ");
INSERT INTO asj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ɛ Mɔɔsɛ wuni wu tɛ̀ tiiti li bɛniiŋ bɛ Isɛlɛɛ li le, ‘Nyɔ gii yi buu Ntomfɔŋ we wumu li bɛŋwaana linti, tuumi li be-eŋ nɛɛ si yi tɛ̀ buu mi.’ ");
INSERT INTO asj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tɛ̀ nuuŋ nɛɛ Mɔɔsɛ wuni, wu nchindaa wu Nyɔ tɛ̀ yɔ li wuu libuka li ŋkumɛ wu Sina-a, mfi wu kintutu ki bɛniiŋ lɛ ki Isɛlɛɛ tɛ̀ nuuŋ li buka bɛ bɛte taa bɛsɛŋ, Nyɔ nyɛ jɛ́ yi nyɛɛ ntsɛ le laŋɛ li bee. ");
INSERT INTO asj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Se nuuŋ le, bɛte taa bɛsɛŋ tɛ̀ tuu be faaŋ le be wuki yɛ li wuu kɛ, be baa dzáa yibe li wuu, be tuu be kɔŋgisi le bee be kaari be to Ijip. ");
INSERT INTO asj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Be tuu be tee li Ɛrɔ-ɔŋ le, ‘Fɛrɛ bee bɛnyɔ bɛ gii be ni be tuuti bee mbaaŋ, kifɛ tɛ kii yɛ fiee fi ka bɛ Mɔɔsɛ wɛ wu tɛ̀ buu bee li kwɛɛŋ wu Iji-ip kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Be se nachɛ finyɔkinɛ fimu fi bosini ŋwaaŋ naŋ, be fɛ muntofi li fi-i, be se nɛki li fiee fi be nachɛ bɛ tsaŋ yibe. ");
INSERT INTO asj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Le be fɛ lɛ, Nyɔ se baa dzaa li bee, be se guundi nuuŋ li jobɛ bɛ kwii mɔɔ muntsɔŋ. Fi se fiɛɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati ki bɛntomfɔŋ bɛ Nyɔ-ɔ, Nyɔ tiiti le, ‘Bɛniiŋ bɛ Isɛlɛɛ, nɛ tɛ̀ sɛɛti nyáŋ li bukaka li biya mbaanyɛɛ li, nɛ feti muntofi nuuŋ li mi-i ni? ");
INSERT INTO asj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nɛ tɛ̀ deŋgi nɛ tuuti kigɔɔnɛ nuuŋ ki nyɔ yi bɛ teenyi le Molok, nɛ tuu nɛ tuuti tɛ fintsɔŋ fi bɛ tɛ̀ fɛ le fi ni fi nuuŋ finyɔ yi bukooŋ nuuŋ le Lefaŋ, ɛ munyɔkinɛ mu nɛ tɛ̀ tɔŋ le nɛ ni nɛ lɛki li mu-u. Kii fini, ŋgii buu beŋ nɛ gɛɛŋ nɛ ka Babilɔŋ bu karu.’ ");
INSERT INTO asj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bɛte taa bɛsɛŋ tɛ̀ deŋgi li bukaka be kɛmi kigɔɔnɛ ki tɛ̀ doonchi le Nyɔ yɛ bɛ be, be tɛ̀ fɛ kigɔɔnɛ kilu biki nɛɛ yɛɛŋ si Nyɔ tɛ̀ doonchɛ li Mɔɔsɛ le ki nuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bɔɔŋ bɛ bɛte taa bɛsɛŋ tɛ̀ fi, be se dza be too be bɛ bɛ ki lani mfi wu bee bɛ Joshwa tɛ̀ lɔchi nshɛ li tɛɛŋ yi tɛ̀ nuuŋ lani, ɛ Nyɔ yi tɛ̀ giiŋgi bee limfwe yi kuŋgi bɛ tɛɛŋ yilu. Kigɔɔnɛ kilu tɛ̀ nuuŋ lani mbɛ Mbochu mfi wu mfɔŋ Daafi tɛ̀ sɛki kwɛɛŋ wuni. ");
INSERT INTO asj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Se ŋɛŋ le Nyɔ tɛ̀ kɔɔŋgi wu ŋge, se lɛkɛ le Nyɔ beŋ le gwaŋ yi nyɛ li yih yi Nyɔ yi Yakɔ le yi ni yi tsiiŋ lu. ");
INSERT INTO asj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Fi bɛ fi ka le ɛ Salimu wu tɛ̀ gwaŋ yih yi Nyɔ yilu. ");
INSERT INTO asj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Se nuuŋ le, Taa Nyɔ yi nuuŋ Kikoo ki Biee Bichu ti tsiiŋ yɛ li yih yi bɛniiŋ gwaŋ kɛ-ɛ. Bɛdɛɛni si ntomfɔŋ wu Nyɔ wumu tɛ̀ saa wu tsɛɛ Nyɔ tiiti le, ");
INSERT INTO asj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Liboo nuuŋ kabara wɛŋ, nshɛ nuuŋ kilaanda ki bikaa bieŋ. Yih yi wi nuuŋ gwaŋ le yi nuuŋ yɛŋ nuuŋ naa yi nuuŋ niŋ? Ŋwaani kintsii kimu kɛɛ lu si keeyɛ ki nnuuŋ nnaa nshee fe ni? ");
INSERT INTO asj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ɛ nɛɛ mi wu mfɛ biee bini bichu ni?’” ");
INSERT INTO asj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Fitifiŋ se dza tee le, “Nɛ tɛɛmi baa bikoo ŋge, shéŋ yinɛ bɛ bintooŋ binɛ gbɛɛŋ biɛɛ bi chiinyɛ. Beŋ bɛ bɛ chaa bɛnɛ baa nɛɛ yɛɛŋ. Nɛ fɛŋgi mfi kwi le nɛ wuki yɛ li tsaŋ yi Fiana yi Waaŋ li kɛ. ");
INSERT INTO asj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ntomfɔŋ wu Nyɔ wumu wɛ lu wu bɛte chaa bɛnɛ ti mɛɛŋ ki beeŋ kɛ bikaa lɛ wuu jiŋ ni? Be tɛ̀ woyɛ bɛntomfɔŋ bɛ Nyɔ-ɔ bɛ tɛ̀ tiiti le Wi wu nimɛ wu Nyɔ wu Tsaaŋ gii bɛ. Le bɛ, nɛ kabɛ wu, nɛ tuu nɛ wo wu. ");
INSERT INTO asj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Se nuuŋ nɛɛ beŋ bɛ Nyɔ tɛ̀ toŋ bɛnchindaa bee le be nyɛ bɛnchi bee li be-eŋ, nɛ se faaŋ mbiewu be.” ");
INSERT INTO asj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Le bɛniiŋ bɛ tɛ̀ sɛki kwɛɛŋ woo fiee fi Fitifiŋ tɛ̀ kweeŋ, shéŋ tɔŋ be bu tɔnyɛ, be ji ŋgesi kii wu. ");
INSERT INTO asj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Fitifiŋ yisɛ bɛ Fiana yi Waaŋ, bɛchi bichi fiee nuuŋ liwe, dza ŋɛŋ kiŋ'wofu ki nuuŋ ki Nyɔ-ɔ, ŋɛŋ tɛ si Jiso lemi lɛ kibɛnɛ ki kigɔŋɛ ki Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Fitifiŋ wulu dza tee le, “Bichɛ yɛɛŋ nɛ ŋɛŋ, mi ŋɛŋgɔɔ si kiboo gwiyɛ, se Ŋwanɛwi lemi lɛ kibɛnɛ ki kigɔŋɛ ki Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Le be woo fiee filu, be jinyɛɛ bintooŋ bɛ tsaŋ, be wɛndi lɛwe ŋge, be biee be dza be bɛchu wooo be we li wu-u, ");
INSERT INTO asj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","be chee wu be bo bɛ wu lɛkuuŋ li kitoŋ kilu-u, be gɛɛŋ be tomi wu bɛ ta. Bɛniiŋ bɛ tɛ̀ lemi lɛ nsaa wulu lɛjiŋ buushɛ ndú yi bee, be nyɛ li sɔɔnɛ wi wumu wu bɛ tɛ̀ teenyi le Sɔɔ be se tomi. ");
INSERT INTO asj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Si be tɛ̀ tomi Fitifiŋ lɛ, lɛki li Nyɔ-ɔ, tiiti le, “Taa Jiso, fi fiana yɛŋ.” ");
INSERT INTO asj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Se tuu toŋ núŋ fɛkwiiŋ, dzɛŋgi lɛwe ŋge le, “Taa, kiiŋ ɔ ni kimi lɛ bibifi bi bɛniiŋ bani feti kɛ!” Le tee lɛ, biee kwi. ");
INSERT INTO asj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Si bɛ tɛ̀ wo Fitifiŋ lɛ, Sɔɔ fɛfi. Nɛɛ booyaa, be bɛchi be nyɛɛ ŋgɛ wu tɛɛmi li kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Jɛrosalɛŋ Ki se saaŋgɛ kichu ki bo le, ki gɛɛŋ bimbe bi Judiya mɔɔ Samaaria, tɛ̀ shɛ nɛɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o kwaa. ");
INSERT INTO asj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Buniŋ bamu bɛ tɛ̀ bɔsɛyi be gɛɛ shéŋ li Nyɔ-ɔ, be bɛ be dzɔ gwini chi Fitifiŋ be diyɛ, be de wu ŋge. ");
INSERT INTO asj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔɔ tɛ̀ giiŋgi nɛɛ fiee limfwe bɛ bifisɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, lɛyi li yíh, li yíh keeti be, buniŋ mɔɔ bukɛɛŋ tumisi be li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bɛniiŋ bɛ tɛ̀ saaŋgɛ baa tuu be giiŋgi li bintsii bichu be tiiti jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fili bɔɔ fiee gɛɛŋ lɛ kitoŋ ki Samaaria, se tiifi ntoŋ wu kii Kinsofu ki Nyɔ tɛ̀ kaachɛ le. ");
INSERT INTO asj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bɛniiŋ ŋge tɛ̀ woo, be tuu be ŋɛŋ biee bi doonchi buŋga bu Nyɔ-ɔ bi yi tɛ̀ feti, be se nyɛ bintooŋ li wuu ŋge. ");
INSERT INTO asj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Fiana yi bifi tɛ̀ buti li bɛniiŋ li, yi wɛndi lɛwe ŋge, bɛniiŋ ŋge bɛ tɛ̀ nuuŋ ɛ ŋgwɛ kɔɔ be mɔɔ biŋkɛrɛ tɛɛmi tɛ. ");
INSERT INTO asj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Se nuuŋ le, kinɛɛtinɛ ki nɔŋa tɛ̀ nuuŋ li kitoŋ kilu-u. ");
INSERT INTO asj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wi wumu tɛ̀ nuuŋ li kitoŋ kilu-u bukooŋ bwee nuuŋ le Simu, ɛ tɛ̀ saa doonchi mfiŋ yee lindɛɛri bɛniiŋ bɛ Samaaria bɛchu se ŋiŋgi bimfimu wondini be. Tɛ̀ tuu kweŋgi tɛ le ɛ wu wi wu nyɔŋa wumu. ");
INSERT INTO asj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bɛniiŋ bɛchu bɛ li kitoŋ kilu mbɛɛchɛ li bɛntɛŋ bɛntɛŋ mbochu li bɛ nɔŋa bɛ nɔŋa, nyɛ bintooŋ li wuu be tiiti le, “Wi wuni nuuŋ buŋga bu Nyɔ bu bɛ teenyi le Buŋga bu Nɔŋa.” ");
INSERT INTO asj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Be tɛ̀ nyɛɛ bintooŋ li wuu lɛ, kifɛ tɛ̀ shiiŋ doonchi mfiŋ yee mɛɛŋ lindɛɛri bɛniiŋ ŋiŋgi bimfimu se wondini be. ");
INSERT INTO asj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Se nuuŋ le, le Fili bɛ ni tiiti ntoŋ wu dzeeŋ wu kii bumfɔŋ bu Nyɔ-ɔ mɔɔ kii bukooŋ bu Jiso Krai lɛ, bukɛɛŋ bɛ buniŋ beŋ ntoŋ wulu se lii be li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simu wɛ kibɛɛ beŋ tɛ bɛ lii wu li dzɔɔ. Se ba nuuŋ li Fili lichiŋ ŋiŋgi biee bi koofiyi bi nɔŋa bi nɔŋa bɛ biee bi doonchi buŋga bu Nyɔ-ɔ bi yi tɛ̀ feti, kimfimɛ wondini wu. ");
INSERT INTO asj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Le bɔɔŋ bɛ nto-oŋ bɛ Jiso tuu be woo Jɛrosalɛŋ le bɛniiŋ bɛ Samaaria fi baa jɛ yi Nyɔ kituŋ, be se toŋ Pita bee Jɔɔŋ le. ");
INSERT INTO asj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Le be gɛɛŋ be bo fe, be lɛkɛ li Nyɔ-ɔ kii bɛniiŋ bɛ kimbeenchɛ-ɛ bɛlu le be kɛmɛ Fiana yi Waaŋ, ");
INSERT INTO asj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kifɛ Fiana yi Waaŋ tɛ̀ mɛɛŋ saa ki bɛ kɛ li wube wumu kɛ. Bɛ tɛ̀ lii be nuuŋ bɛ dzɔɔ kwaa li bukooŋ bu Taa Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pita bee Jɔɔŋ lɛkɛ li Nyɔ-ɔ, be gɛɛ tsaŋ li bee, be se kɛmɛ Fiana yi Waaŋ. ");
INSERT INTO asj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Le Simu tuu ŋɛŋ si bɔɔŋ bɛ nto-oŋ bɛ Jiso giki tsaŋ li bɛniiŋ li Fiana yi Waaŋ se bɛɛ li bee, se bɛchi nyɛɛ kwa li Pita bee Jɔɔŋ li, ");
INSERT INTO asj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","tiiti le, “Nyɛ yɛɛŋ mi fɛ buŋga buni tɛ, le ke mɔɔ nuuŋ noo wu mi ŋgɛɛ tɛ tsaŋ yɛŋ li wuu le, mwɛ kɛmɛ tɛ Fiana yi Waaŋ.” ");
INSERT INTO asj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita se tuu li wuu le, “Nɛɛ kwaa wa wulu la bula. Ɔ geeŋ ɔ se beechi le nuuŋ bɛ go nya yi nuuŋ yi Nyɔ bɛ kwa? ");
INSERT INTO asj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɔ kɛmi yɛ mɔɔ le ɔ ni ɔ deŋgi lɛ nimɛ chini-i lɛnti kɛ, kifɛ shéŋ ya wuuti yɛ bɛ Nyɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fiiki shéŋ ya li fiee fi bifi fi ɔ wɛki le ɔ fɛ fini, ɔ lɛkɛ li Nyɔ-ɔ laa nuuŋ nɛɛ tɛ Taa Nyɔ feeki bɛmbeechɛ bɛ bifi bɛ ɔ kɛmi li shéŋ ya bani le. ");
INSERT INTO asj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ŋiŋgɔɔ le ɔ yisɔɔ kituŋ bɛ ki nyɛrisɛ lii, ɔ to mfwa wu bibifi.” ");
INSERT INTO asj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simu se lɛkɛ Pita bee Jɔɔŋ le, “Mintemii, lɛkɛ yɛŋ li Taa Nyɔ le kiiŋ fiee fimu lɛ biee bi nɛ tiiti bini lɛnti ka bɛ mi kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Le Pita bee Jɔɔŋ tuu be mɛɛshi ntiifɛ jɛ yi Nyɔ, be tee biee bi be kii, kii Jiso, be se dza be tuu lijiŋ Jɛrosalɛŋ si be tɛ̀ tuu lijiŋ lɛ, be kɛti li bitoŋ bi Samaaria ŋge, be tiifi ntoŋ wu dzeeŋ wu Nyɔ le. ");
INSERT INTO asj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nchindaa wu Taa dza tee li Fili le, “Dzatsɛ ɔ bɔɔ dze kwiiŋkwiiŋ, ɔ gɛɛŋ lɛ dze yi dzɛti Jɛrosalɛŋ yi kɛti libuka yi giiŋgi Gasa-a.” ");
INSERT INTO asj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Fili se dza mbɔwu. Wi wu nyɔŋa wumu wu Itoopia tɛ̀ nuuŋ lɛ dze yilu. Tɛ̀ nuuŋ wi wu bɛ tɛ̀ chɔɔchɛ, tɛ̀ gii nuuŋ wi wu tɛ̀ bichi fɛ bulofu bu Yaa wu Kanda wu tɛ̀ sɛki kwɛɛŋ wu Itoopia. Wi wulu tɛ̀ dza Jɛrosalɛŋ fɛ tɛ̀ gɛɛŋ le lɛkɛ li Nyɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","tɛ̀ tuu lijiŋ li kwɛɛŋ wee li lɛ kikpɔtɔ kimu ki nyáŋ chiiti, ɛ tɛ̀ shee le, teenyi fiee lɛ Kiŋwaati ki Ɛsaya wu ntomfɔŋ wu Nyɔ tɛ̀ tsɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Fiana yi Waaŋ tee li Fili le, “Kiiŋgi ɔ gɛɛŋ li kikpɔtɔ kɛɛ lichiŋ.” ");
INSERT INTO asj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fili letɛ gɛɛŋ li ki-i lichiŋ, woo si wi wulu teenyi lɛ Kiŋwaati ki Ɛsaya. Bii li wuu laa, “Ɔ teenyi ni ɔ wuki fiee fi ki tiiti ni?” ");
INSERT INTO asj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tuu le, “Ŋgii ŋgeeŋ nse ŋwoo fuki fɛ wi tuu wu naanyɛ li mi-i nsiŋ?” Se tee le Fili miri shee bee wu lɛ kikpɔtɔ. ");
INSERT INTO asj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kintsii ki tɛ̀ teenyi lɛ Kiŋwaati kilu tɛ̀ tiiti le, “Tɛ̀ nuuŋ si nshɔɔŋ yi bɛ giiŋgi le bɛ sɛɛ, tuu nuuŋ nɛɛ si ŋwanɛ nshɔɔŋ ti nuuŋ fɛ bɛ keendi dzúŋ yee, tɛ de kɛ. Tɛ̀ nuuŋ nshiiŋ. ");
INSERT INTO asj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bɛ tɛ̀ nyɛ wu buya, bɛ faaŋ le bɛ sɛki yɛ nsa we tsaaŋ kɛ. Ɛ noo wu gii se naa tee kii kini kee, fɛ bɛ tɛ̀ sondɛ ntsɛ we laaŋkwiiŋ.” ");
INSERT INTO asj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wi wu nyɔŋa wulu se sooŋ bɔ li Fili le, “Mintemi-i, tee nɛɛ mi, ntomfɔŋ wu Nyɔ wuni tiiti nuuŋ kii noo? Tiiti nuuŋ kii yi yee mɔɔ kii wi wumu le?” ");
INSERT INTO asj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fili se bɛchi nɛɛ fɛ kintsii ki Kiŋwaati kilu-u, naanyi ntoŋ wu dzeeŋ wu kii Jiso li wuu. ");
INSERT INTO asj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bee wu se giiŋgi lɛ dze, be gɛɛŋ be bo fɛ kintsii kimu ki dzɔɔ tɛ̀ nuuŋ fe. Wi wu nyɔŋa wulu tee le, “Bichɛ ɔ ŋɛŋ, dzɔɔ yɛ fɛni, ɛ la fi nuuŋ fi tuu fi loosɛ le ɔ lii kɛ mi li dzɔɔ kɛ?”  ");
INSERT INTO asj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fili tuu li wuu le, “Ɔ beŋ li Jiso Krai li bɛ shéŋ ya chi, nse nlii wɛ li dzɔɔ.” Tuu le, “Mi mbeŋɔ le Jiso Krai nuuŋ Ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wi wu nyɔŋa wulu tuu tee le be geri kikpɔtɔ kilu. Bee Fili se shee, be lɛ be gɛɛŋ li dzɔɔ, Fili lii wu lidzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Le be bo lidzɔɔ lɔɔ, Fiana yi Taa chofi Fili fe, wi wu nyɔŋa wɛ ti mɛɛŋ wu ki ŋɛŋ kɛ, bɛdɛɛni ba giiŋgi fiee bɛ kinɛɛtinɛ. ");
INSERT INTO asj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fili se taa busɛ nuuŋ Asoto, se giiŋgi kɛti li bitoŋ bichu fenjisi ntoŋ wu dzeeŋ wu Nyɔ nsiiŋ gɛɛŋ bo li kitoŋ ki Kasaria. ");
INSERT INTO asj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tɛ nuuŋ li mfi wɛɛ, Sɔɔ mɛɛŋ giiŋgi limfwe bɛ nduŋu, chɛnisi bɛniiŋ bɛ kintutu bɛ Taa lɛ le gii ni woyi be. Se dza gɛɛŋ fɛ kikoo ki bɛte muntofi-i, ");
INSERT INTO asj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","le bii biŋwaati le gɛɛŋ bɛ bi li yih yi nlɛkɛ li Nyɔ-ɔ yi Damako, bi doonchi le ɛ wu ŋɛŋ bɛniiŋ bɛ biki Dze yi Taa le, mɔɔ nuuŋ bukɛɛŋ, mɔɔ nuuŋ buniŋ, kɔɔ be kaŋ, bɛ bɛ be Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nyɛ wu, Sɔɔ se dza ŋgɛnu Damako, le ni nuuŋ tsɛkɛ li mbochu li kitoŋ kilu-u, kiŋ'wofu kimu taa ki dza ki lɛbi liboo, ki shee li wuu bwiŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","We fɛkwiiŋ, woo si jɛ kweŋgi li wuu le, “Sɔɔ, Sɔɔ, ɔ biindi bikaa lɛ mi-i jiŋ kii la?” ");
INSERT INTO asj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Se bii laa, “Taa, ɛ wɛ noo?” Jɛ yilu tuu le, “Ɛ mi Jiso, wuɔ biindi bikaa lɛ wuu jiŋ wulu. ");
INSERT INTO asj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Dɛɛni yani, dza we, ɔ lɛ li kito-oŋ, bɛ gii bɛ tee wɛ fiee fi ɔ kɛmi le ɔ fɛ.” ");
INSERT INTO asj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bɛniiŋ bɛ tɛ̀ deŋgi bɛ Sɔɔ baa leŋ fe, be ŋgɛsi si be tɛ̀ wuki jɛ yilu be tɛ̀ ŋɛŋ wi kɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔ dza fɛkwiiŋ, le ni wɛki le gwiyɛ lii, mɛɛŋ tuu kɛ le ŋɛŋ biee kɛ. Be kɛmɛ wu li kibɛnɛ-ɛ, be tsɛtsi wu be giiŋgi bɛ wu Damako. ");
INSERT INTO asj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Gɛɛŋ nuuŋ fe jo taa ŋɛnu biee nsiŋ. Tɛ̀ nuuŋ lɛ, jiiyɛ fiee kɛ, wundi yɛ fiee kɛ. ");
INSERT INTO asj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wi wu kimbeenchɛ wumu tɛ̀ nuuŋ Damako wulu bukooŋ le Ananiya. Taa Jiso dza tee li wuu lɛ fiee fimu si kifiee lɛ le, “Ananiya.” Beŋ le, “Taa, wuŋ mi fɛni.” ");
INSERT INTO asj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Taa tee li wuu le, “Dzatsɛ, ɔ ni ɔ giiŋgi lɛ dze yi bɛ teenyi le Tsaaŋ li, ke ɔ bo fɛ yih yi Judas, ɔ bii wi wumu wu Taasu wu bɛ teenyi le Sɔɔ. Yikɛ ɔ woo, wɛ fe lɛki li Nyɔ-ɔ, ");
INSERT INTO asj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","bee ŋɛŋ wi lɛ fiee fimu si kifiee wu bɛ teenyi le Ananiya, ɛ wu bɛ wu gɛɛ tsaŋ li wuu bwiŋ, le kaari ni ŋiŋgi biee.” ");
INSERT INTO asj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Se nuuŋ le, Ananiya tee le, “Taa, mi ŋ'woɔ li bɛniiŋ li ŋge kii wi wuni si fetɔɔ biee bibifi li bɛniiŋ bɛ Nyɔ-ɔ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bɛɛɔ ni nuuŋ ɛ wu fi buŋga li bɛte muntofi bɛ nɔŋa bɛ nɔŋa, le bɛ kɔɔyɛ bɛniiŋ bɛchu fɛni bɛ lɛki li Nyɔ-ɔ be teenyi bukooŋ bwo.” ");
INSERT INTO asj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Taa tuu li wuu le, “Gɛnɛ lɛ! Mi ntsaaɔ wi wulu kituŋ li wi wɛŋ wu nimɛ-ɛ, le ni tiifi bukooŋ bweŋ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ bɛ bɛmfɔŋ bɛ bee, mɔɔ li bɛniiŋ bɛ Isɛlɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi kibɛɛ ŋgii ndoonchɛ wu si kɛmi le ŋɛŋ ŋgɛ kii bukooŋ bweŋ.” ");
INSERT INTO asj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiya se gɛɛŋ, lɛ li yih yilu-u, gɛɛ tsaŋ yee li Sɔɔ li, tee le, “Sɔɔ ŋwaanɛŋ, ɛ Taa Jiso wu toŋ mi. Ɛ Jiso wu ɔ tuu ɔ ŋɛŋ lɛ dze mfi wu ɔ tuu bɛɛ fɛni wɛ. Wu toŋɔ mi le mbɛ mfɛ ɔ kaari ɔ ni ɔ ŋiŋgi biee, Fiana yi Waaŋ se bɛ yi yisɛ li wɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nɛɛ si tɛ̀ kweŋgi lɛ, fiee fimu fi nuuŋ si bifabu lɛ dza bi bo Sɔɔ lɛ lii bi weyɛ fɛkwiiŋ, se bɛchi ŋiŋgi biee. Dza we, bɛ se lii wu li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Le dza ji biee, buŋga kaari bu to wu li bwiŋ. Sɔɔ tsi Damako bɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ jo niiŋ, ");
INSERT INTO asj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","bɛchi mfwa mumkpaŋ deŋgi li yih yi nlɛkɛ li Nyɔ-ɔ, tiiti le, “Jiso nuuŋ ŋwanɛ Nyɔ.” ");
INSERT INTO asj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bɛniiŋ bɛchu bɛ tɛ̀ wuki mɛŋɛ laa, “Wi wuni nuuŋ nɛɛ wi wu tuu deŋgi bifisi bɛniiŋ bɛ lɛki li Nyɔ-ɔ be teenyi bukooŋ buni Jɛrosalɛŋ ni? Mɔɔ wu bɛɛɔ fɛni ni nuuŋ le kɔɔ bɛ nuuŋ fɛni, kaari gɛɛŋ bɛ be, nyɛ li tsaŋ yi bɛte muntofi bɛ nɔŋa bɛ nɔŋa nɛɛ ni?” ");
INSERT INTO asj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sɔɔ tuu nɛɛ tiiti fiee kii Jiso giiŋgi nuuŋ limfwe, doonchi le Jiso nuuŋ Kinsofu ki Nyɔ tɛ̀ kaachɛ. Bɛjuu bɛ tɛ̀ nuuŋ Damako waaŋ fiee fi be nuuŋ be tuu li wuu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Le jo ka ŋge, Bɛjuu bɛlu shee, be cho ntaŋ le be wo Sɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Be se shiiŋ, be tɛŋgi wu fɛ fweeŋ wu mbaŋ wu Damako-o, le ke kɛti lɔɔ, mɔɔ nuuŋ butuu mɔɔ nuuŋ fɛnshaaŋ, be wo wu. Se nuuŋ le, Sɔɔ kɛɛ ntaŋ wube. ");
INSERT INTO asj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bɛniiŋ bee bɛ kintutu dza be dzɔ wu butuu, be gɛɛ wu lɛ ŋkaa li, be buu wu fɛ fwii wu mbaŋ, be shiiki wu fɛkwiiŋ nuuŋ lɛkuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Le Sɔɔ to lijiŋ Jɛrosalɛŋ, tɛ̀ wɛki le taa li kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, be se chɛndi wu bu chɛnu, kifɛ be tɛ̀ beenchi yɛ le gbɛŋgi nuuŋ wi wu be wu kintutu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Se nuuŋ le, Banaba tɛ̀ dzɔ wu, bee wu gɛɛŋ fɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o. Se tee be si Sɔɔ tɛ̀ ŋɛŋ Taa lɛ dze Taa yɔ li wuu, se tuu tee tɛ be si tɛ̀ tiiti kii Jiso Damako nchɛnu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Se nuuŋ le, Sɔɔ tuu nuuŋ le deŋgi bee be li bintsii bichu bi Jɛrosalɛŋ tiiti kii Jiso, nchɛnu nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tɛ̀ tiiti tɛ li Bɛjuu bɛ tɛ yeti jɛ́ yi Grik, tɛchini biee bee be, be se dza be wɛki le be wo wu. ");
INSERT INTO asj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bɛniiŋ bɛ kimbeenchɛ-ɛ kɛɛ le bɛ wɛki baa le bɛ wo wu, be se dzɔ wu be bɔɔ bɛ wu li kitoŋ ki Kasaria, be tuumi wu gɛɛŋ Taasu. ");
INSERT INTO asj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Li mfi wulu, kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ fufɛ li ŋgɛ-ɛ bimbe bi kwɛɛŋ lɛ bi Judiya bɛ Galilii mɔɔ Samaaria. Fiana yi Waaŋ se fɛ le kintutu kilu tɛmi, ki tuu ki tɛɛti li kintutu ki kuu. Ki se tsiiŋ, ki guundi nuuŋ Taa. ");
INSERT INTO asj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita tɛ̀ deŋgi giiŋgi lɛ bɛniiŋ bɛ nuuŋ bɛ Nyɔ-ɔ li bintsii bichu, dɛndɛ gɛɛŋ bo fɛ bɛ nuuŋ Lida-a. ");
INSERT INTO asj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Si tɛ̀ nuuŋ fe lɛ, ŋɛŋ wumu ɛ ŋgwɛ tɛ kɔɔ wu, bukooŋ bwee nuuŋ le Eenia, ɛ wu ŋgeeŋ wu tsi fɛntaa biya nyaaŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Si Pita tɛ̀ ŋɛŋ wu lɛ, tee li wuu le, “Eenia, Jiso Krai wɔnchɔɔ wɛ kituŋ. Dza we ɔ nachɛ kintaa ko.” Mfwa mumkpaŋ Eenia dza we. ");
INSERT INTO asj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bɛniiŋ bɛ Lida mɔɔ bɛ li kinɛɛŋ ki Shalɔ-ɔŋ bɛchu ŋɛŋ si wi wulu tɛmi kituŋ, be gɛɛ shéŋ li Taa Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Fi tɛ̀ nuuŋ ɛ kwɛɛŋ wumu nuuŋ li kitoŋ ki Jopa, ɛ tɛ̀ nuuŋ wi wu kimbeenchɛ-ɛ, bukooŋ bwee nuuŋ le Tabita, bukooŋ buni nuuŋ lɛ jɛ́ yi Grik le Dooka. Tɛ̀ shiiŋ feti biee bi dzeeŋ mfi kwi, fii bɛniiŋ bɛ kifoo lɛ. ");
INSERT INTO asj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Le ni nuuŋ li jo yɛɛ, kwɛɛŋ wulu we chigɔŋ, kwi. Bɛ tsootsɛ gwini chee, bɛ miri bɛ gɛɛ wu lɛ lo-oŋ wu yih wu lɛwe. ");
INSERT INTO asj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Si Jopa tɛ̀ nuuŋ li Lida-a lichiŋ lɛ, kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ dza ki woo le Pita wɛ Lida, ki se toŋ buniŋ bɛfɛ lɛ wuu. Be gɛɛŋ be lɛkɛ wu le, Mintemii, le bɛ li bikaa li liwe. ");
INSERT INTO asj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita se dza bee be giiŋgi. Le gɛɛŋ bo fe, be dzɔ wu be miri bɛ wu lɛ lo-oŋ wu yih wu lɛwe wɛɛ. Ɛ bukɛɛŋ bɛɛŋku-u bɛ fe bɛchu kɛnɛ wu be tasɛ be dii, be yiŋgisi wu ndú yi Dooka tɛ̀ feti mfi wu tɛ̀ mɛɛŋ we. ");
INSERT INTO asj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita buu be bɛchu lɛkuuŋ, toŋ núŋ fɛkwiiŋ lɛki li Nyɔ-ɔ, dza fiiki yi tee li gwini chilu-u le, “Tabita dza we.” Se biee gwiyɛ lii, bichɛ ŋɛŋ Pita, se dza shee we. ");
INSERT INTO asj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita kɛmɛ wu li kibɛnɛ-ɛ, leŋ we. Pita kaari teeŋ bɛniiŋ bɛ nuuŋ bɛ Nyɔ-ɔ bɛ bukɛɛŋ bɛɛŋku-u baa, doonchɛ wu li bee, ɛ wu kaari wu yiŋ. ");
INSERT INTO asj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ntoŋ wulu se saaŋgɛ wu gɛɛŋ Jopa kwikwi. Bɛniiŋ ŋge se gɛɛ shéŋ li Taa li. ");
INSERT INTO asj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita tɛ̀ tsi Jopa li jo ŋgee li, tsiiŋ bee wumu wu tɛ̀ nachi dzí bukooŋ bwee nuuŋ le Simu. ");
INSERT INTO asj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Wi wumu tɛ̀ nuuŋ li kitoŋ ki Kasaria bɛ teenyi wu le Kɔniyu, tɛ̀ nuuŋ kikoo ki kintutu kimu ki bɛniiŋ bɛ nchi-i bɛ Lo-om, ki bɛ tɛ̀ teenyi le ki Itali. ");
INSERT INTO asj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wu, bee kini kee kichu tɛ bɔsɛyi be gɛɛ shéŋ li Nyɔ-ɔ. Tɛ̀ gii guundi tuu lɛki li Nyɔ-ɔ mfi kwi, nyɛɛ nya ŋge li Bɛjuu li bɛ bɛniiŋ bɛ kifoo lɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Le ni nuuŋ jobɛ chimu nɛɛ si jobɛ bikaa bitɛɛtu lɛ fɛnshaaŋ li, fiee fimu si kifiee dza fi bɛ lɛ wuu gbɛɛŋ ŋɛŋ nchindaa wu Nyɔ lɛ fiee filu. Nchindaa wulu bɛ lɛ teeŋ wu le, “Kɔniyu.” ");
INSERT INTO asj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔniyu chɛŋ toŋ lii li wu, bii le, “Te, kikoo ɛ la?” Nchindaa wulu tuu le, “Nyɔ kɔɔyɛ yi woo nlɛkɛ li Nyɔ-ɔ wa, yi se tuu yi ŋɛŋ tɛ nya yɔɔ nyɛɛ li bɛniiŋ bɛ kifoo lɛ, yi se kimi wɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Dɛɛni, tomɛ bɛniiŋ Jopa be gɛɛŋ be teeŋ wi wumu wu bukooŋ bwee nuuŋ le Simu, bumu se nuuŋ le Pita. ");
INSERT INTO asj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wu bɛɛɔ tsiiŋ bee Simu wumu wu ti nachi dzí wu la we nuuŋ li dzɔɔ yi nyɔŋa-a lichiŋ.” ");
INSERT INTO asj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Le nchindaa wu Nyɔ wulu yɔ lɛ dza. Kɔniyu shɛ teeŋ bɛniiŋ bee bɛ nimɛ-ɛ bɛfɛ, teeŋ tɛ wi nchi wumu wu tɛ̀ kiichi wu, tɛ̀ nuuŋ wi wu tɛ̀ bɔsɛyi wu gɛɛ tɛ shéŋ yee li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Be bɛ, tee be fiee fichu fi bee fi ka, se toŋ be Jopa. ");
INSERT INTO asj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Le butuu woo, nɛɛ si fɛnshaaŋ kintikinti, si be tɛ̀ fɛɛshi li kitoŋ kilu lɛ, Pita dza miri lɛ yi lɛwe le lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dzeeŋ dza yi bɛchi yi wuu wu, wɛki le ji biee, ɛ bɛ tɛ̀ mɛɛŋ bɛ deeki biee bijɛ. Fiee fimu si kifiee dza fi bɛ lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ŋɛŋ lɛ fiee filu ɛ kiboo gwiyɛ, fiee fimu shiiti liwe fi nuuŋ si ndu yi nyɔŋa ɛ bɛ kɛmɛ li yooŋ naa li. ");
INSERT INTO asj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Li ndu yilu, nyáŋ chichi nuuŋ lu, nyáŋ yi deŋgi, mɔɔ yi kɛɛndi bɛ muniiŋ mu jiindi li we. ");
INSERT INTO asj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jɛ dza yi tee li wuu le, “Pita, dzatsɛ we ɔ sɛɛyɛ ɔ ji.” ");
INSERT INTO asj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita tuu le, “Taa, nuuŋ ntɛ mɔŋ kɛ, kifɛ nti mɛɛŋɔ saa ki nji kɛ fiee fi lɔɔlɔɔ, kɛ fi wuuti yɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jɛ yilu tuu yi yɔ li wuu le, “Kiiŋ ɔ ni nyaami fiee fi Nyɔ fɛ fi wuuti kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Fi ka lɛ kiŋga kitɛɛtɛ, bɛ kaari bɛ chee fi liboo. ");
INSERT INTO asj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Fiee fi tɛ̀ bɛ si kifiee fiɛɛ fuumi Pita se mɛŋɛ laa fi doonchi nuuŋ la le. Nɛɛ li mfi wulu bɛniiŋ bɛ Kɔniyu tɛ̀ toŋ baa bɛ be biiti fɛ la wu Simu wu nachɛ dzi wɛ nuuŋ, be lemi fɛ fweeŋ wu mbaŋ wɛ-ɛ, ");
INSERT INTO asj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","be teenyi, be biiti laa, “Mfondɛ wumu wɛ fɛni bukooŋ le Simu Pita ni?” ");
INSERT INTO asj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Si Pita tɛ̀ mɛɛŋ beechi kii fiee fi tɛ̀ bɛ lɛ wu filu, Fiana yi Waaŋ dza yi tee li wuu le, “Bichɛ ɔ ŋɛŋ, bɛniiŋ bɛtɛɛtu wɛki baa wɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dzatsɛ we ɔ shee nɛɛ be nɛ ni nɛ giiŋgi kikaa mumkpaŋ. Kiiŋ ɔ ni laaŋ kɛ, ɛ mi wu toŋ be.” ");
INSERT INTO asj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Se nuuŋ le Pita tɛ̀ dza shee, tee li bɛniiŋ bɛlu le, “Ɛ mi wu nɛ wɛki. Nɛ bɛ le la?” ");
INSERT INTO asj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Be tuu le, “Kɔniyu wu nuuŋ kikoo ki kintutu kimu ki bɛniiŋ bɛ nchi-i bɛ Lom toŋɔ bee. Nuuŋ wi wu tsaaŋ, chɛndi Nyɔ, Bɛjuu bɛchu se piɛti wu. Nchindaa wu Nyɔ wumu wu wuuti tuu tee li wuu le tuumi ntoŋ le ɔ bɛ li wuu yi, le woo fiee fi ɔ gii ɔ tee wu.” ");
INSERT INTO asj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Le be tuu lɛ, Pita se tee le be lɛ bee be tsi. Le butuu woo, dza bee be giiŋgi. Bɛniiŋ bɛ kimbeenchɛ-ɛ bamu bɛ Jopa biee wu. ");
INSERT INTO asj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Be dɛndɛ siiŋ be tsi dze, le bu woo be fɛsi Kasaria. Kɔniyu bee bɛniiŋ bee bɛ kini mɔɔ nsáŋ yee yi shéŋ yi tɛ̀ teeŋ tɛ̀ tɛŋgi be. ");
INSERT INTO asj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Le Pita ni lii giiŋgi li yi, bee Kɔniyu bikɛ. Kɔniyu we wu lii bundi wu. ");
INSERT INTO asj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Se nuuŋ le, Pita tɛ̀ tsaaki wu liwe tee le, “Dzatsɛ we, miɔ tɛ wiwoŋ si wɛ.” ");
INSERT INTO asj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bee Kɔniyu tiiti biee be lii be giiŋgi li yih, le be lii lɔɔ, be ŋɛŋ si kintutu ki bɛniiŋ lɛ turi lu. ");
INSERT INTO asj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Se kweeŋ li bee le, “Nɛ kii bujɔŋ le nchi wusɛŋ mɛɛŋ ki beŋ kɛ le wi wu Juu la ŋka, kɛ le kɔɔ nsaŋ bɛ wi wu nuuŋ yɛ wi wu Juu kɛ. Se nuuŋ le, Nyɔ doonchɛ yɛ mi le ŋkɛmi yɛ le ni nteenyi wumu ntiiti le ɛ wi wu yee, kɛ le mwɛ wuuti yɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Bɛdɛɛni, le nɛ tuumi ntoŋ le mbɛ, mi mbɛɛɔ mɛɛŋɔ ki chee kɛ yi kɛ. Nse mbiitɔɔ li be-eŋ laa, nɛ teeŋ mi kii la?” ");
INSERT INTO asj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔniyu tuu le, “Beŋ yaa jo naa si ntuu nuuŋ li yi, si jobɛ bikaa bitɛɛtu fɛnshaaŋ nlɛki li Nyɔ-ɔ. Wumu se taa wu dza wu busɛ mi lii ɛ mwɛ chuumɛ ndú yi miɛŋini. ");
INSERT INTO asj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wu tee li mi-i le, ‘Kɔniyu, Nyɔ kɔɔyɛ yi woo nlɛkɛ li Nyɔ-ɔ wa yi se ŋɛŋ nya yi ɔ nyɛɛ li bɛniiŋ bɛ kifoo lɛ, yi se kimi wɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Se nuuŋ le tomɛ bɛniiŋ Jopa be gɛɛŋ be teeŋ wumu wu bukooŋ bwee nuuŋ le Simu, bumu se nuuŋ le Pita. Wu bɛɛɔ tsiiŋ bee Simu wu nachi dzí wu la we nuuŋ li dzɔɔ yi nyɔŋa lichiŋ.’ ");
INSERT INTO asj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mfwa mumkpaŋ lɛ, mi se mbiee mi ntuumi ntoŋ le ɔ bɛ. Si ɔ bɛ ni, fi dzɔɔŋ fiɛɛ ŋge. Tɛ se baa fɛni lɛ Nyɔ lii le tɛ̀ woo fiee fi Taa toŋ wɛ le ɔ bɛ ɔ tee li bee li.” ");
INSERT INTO asj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita se bɛchi n'yɔru tiiti le, “Bɛ chɛɛŋ, mi ŋɛŋ le Nyɔ ti doonchi yɛ chichi chichi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wi kwikwi wu chɛndi yi tuu feti fiee fi tsaaŋ, kɛ yi gii yi fi wu yi tɛ̀ bichɛ laa mwɛ buti fɛŋ le kɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nɛ kii baa ntoŋ wu Nyɔ tɛ tuumi li bɛniiŋ bɛ Isɛlɛɛ, fenjisi ntoŋ wu dzeeŋ le Jiso Krai tɛ̀ bɛ le mbɛɛŋgii se nuuŋ lu. Jiso Krai wuni nuuŋ Te Kikoo wu bɛniiŋ bɛchu. ");
INSERT INTO asj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nɛ kii baa fiee fi tɛ̀ ka li kwɛɛŋ wu Judiya kwikwi, mbɛɛchɛ Galilii lɛjiŋ lɛ mfi wu Jɔɔŋ tɛ̀ fenjisi lisi bɛniiŋ lidzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nɛ kii baa tɛ si Nyɔ tɛ̀ shoohɛ Fiana yi Waaŋ shooshɛ li Jiso wu Nasarɛ, tuu nyɛ buŋga li wuu, nuuŋ bɛ wu. Si Nyɔ tɛ̀ nuuŋ bɛ wu lɛ, se deŋgi li bitsii bichu feti nimɛ chi dzeeŋ tuu wɔnchi mɔɔ bɛniiŋ bɛ kiŋkundi ŋwɛki bɛ be. ");
INSERT INTO asj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɛ bee tɛ tɛ̀ ŋɛŋ biee bichuchu bi tɛ̀ feti li kwɛɛŋ wu Bɛjuu li kwikwi, mɔɔ bi tɛ̀ feti li kitoŋ ki Jɛrosalɛŋ. Bɛ tɛ̀ ta wu li kintaaŋ li kwi. ");
INSERT INTO asj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Se nuuŋ le, le bo jo taa, Nyɔ buu wu li kwe-e, yi fɛ bɛniiŋ ŋɛŋ wu. ");
INSERT INTO asj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ɛ bɛniiŋ bɛchu bɛ tɛ̀ ŋɛŋ wu kɛ. Ɛ bee, bɛ yi yi Nyɔ tɛ̀ tsaa le tɛ ni tɛ tiiti kii Jiso kwaa. Tɛ tɛ̀ ji biee tɛ wundi biee bɛ Jiso mfi wu tɛ̀ bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tɛ tee li bee li le tɛ ni tɛ tiiti jɛ yi Nyɔ li bɛniiŋ li, tɛ tuu tɛ tiiti li bee le, ɛ wu wu Nyɔ tɛ̀ tsaa le ni sɛki bɛniiŋ bɛ mɛɛŋ lu mɔɔ bɛ kwiyɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jiso wuni nuuŋ wu bɛntomfɔŋ bɛ Nyɔ-ɔ bɛchu tiiti kii wu le wi kwikwi wu gɛɛ shéŋ li wuu, Nyɔ gii yi feeki bibifi bi mwɛ li bukooŋ bwee li.” ");
INSERT INTO asj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nɛɛ si Pita tɛ̀ mɛɛŋ tiiti biee bini ni, Fiana yi Waaŋ dza yi shee yi bɛ li wi kwikwi wu tɛ̀ yiki n'yɔru wulu. ");
INSERT INTO asj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bimfimu wondɛ bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ nuuŋ Bɛjuu bɛ tɛ̀ biki Pita, be se ŋɛŋ le Nyɔ nyɛ yɛ tɛ nya ye yi nuuŋ Fiana yi Waaŋ li bɛniiŋ bɛ tɛ̀ nuuŋ yɛ Bɛjuu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bɛjuu baa wuki si be yeti jɛ́ yibe tɛ̀ kiyɛ kɛ, be yɔɔnchi Nyɔ. Pita se bii laa, ");
INSERT INTO asj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Si Fiana yi Waaŋ bɛ yɛ li bɛniiŋ bani kituŋ ni, nɛɛ si yi tɛ̀ bɛ li bee li lɛ, wi nuuŋ tuu ni fɛŋgi le bɛ lii kɛ be li dzɔɔ kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Si Pita tɛ̀ bii lɛ, biee tee le bɛ lii be li dzɔɔ li bukooŋ bu Jiso Krai. Lɛjiŋ lɛlu, bɛniiŋ bɛlu lɛkɛ le tsi bee be li jo niiŋ li se dza. ");
INSERT INTO asj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bɔɔŋ bɛ nto-oŋ bɛ Jiso mɔɔ bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Judiya bɛchuchu woo le bɛniiŋ bɛ ti nuuŋ yɛ Bɛjuu kɛ fi baa tɛ jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Le Pita tuu kaari yɛɛ Jɛrosalɛŋ bɛniiŋ bɛ kimbeenchɛ-ɛ bamu bɛchi be gundi wu. Bɛniiŋ bani nuuŋ bɛ tɛ̀ lemi le bɛ kɛmi le bɛ sɛɛ wi wu nuuŋ yɛ wi Juu kɛ dzoo se mwɛ nuuŋ wi wu Nyɔ! ");
INSERT INTO asj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Be tɛ̀ gundi wu be biiti laa, “Ɔ geeŋ ɔ la ŋka lɛ bɛniiŋ bɛ mɛɛŋ bintɔrɔ, ɔ jii mɔɔ biee bɛ be?” ");
INSERT INTO asj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita se bɔsɛyi naanyɛ be fiee fichu fi tɛ̀ ka li n'yooŋ li li n'yooŋ li, tee li bee le, ");
INSERT INTO asj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ntuu nuuŋ li kitoŋ ki Jopa-a nlɛki li Nyɔ-ɔ, fiee si kifiee dza fi bɛ lɛ mi-i. Mi ŋɛŋ lɛ fiee filu ɛ kiboo gwiyɛ, fiee fimu shiiti liwe fi nuuŋ si ndu yi nyɔŋa ɛ bɛ kɛmɛ li yooŋ naa li. Fi shee fi leŋ mi lii. ");
INSERT INTO asj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Le ntuu mbichɛ lɔ, mi ŋɛŋ nyáŋ li bini li bini, yimi nuuŋ yi fɛkuuŋ, yimi yi libuka bɛ yi kɛɛndi, mɔɔ muniiŋ mu jiindi liwe. ");
INSERT INTO asj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mi ndza mi ŋwoo jɛ tee li mi le, ‘Pita, dzatsɛ we ɔ sɛɛyɛ ɔ ji!’ ");
INSERT INTO asj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nse mi ntuu le, ‘Taa, nuuŋ ntɛ mɔɔŋ kɛ. Fiee fi lɔɔlɔɔ bɛ fi wuuti yɛ kɛ mɛɛŋ fiɛɛ saa ki lɛ-ɛ, lɛ mi wa kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jɛ yilu tuu yi kweeŋ liboo le, ‘Kiiŋ ɔ ni nyaami fiee fi Nyɔ fɛ, fi wuuti kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Fi ka lɛ kiŋga kitɛɛtɛ se bɛ kaari bɛ chee fiee filu fichu fi yɛɛ fi to liboo. ");
INSERT INTO asj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nɛɛ li mfi wulu, bɛniiŋ bɛtɛɛtu fɛsi fɛ yih yi ntɛ̀ ntsiiŋ fe-e, ɛ be dza Kasaria, ɛ bɛ toŋ be le be bɛ be teeŋ mi. ");
INSERT INTO asj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Fiana yi Waaŋ tee li mi-i le kiiŋ ni nyaami ŋgɛnu tɛɛ bɛniiŋ bɛlu kɛ. Bɛŋwaanɛŋ bɛ Jopa bɛ busɔɔ bani biee mi, tɛɛ be bɛchu tɛ̀ gɛɛŋ tɛ̀ lɛ li yih yi wi wulu. ");
INSERT INTO asj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Si tɛ tɛ̀ lɛ lɛ, mwɛ tee bee si bee ŋɛŋ nchindaa wu Nyɔ li wu-u yih, wu se tee le, ntoŋ wi Jopa mwɛ gɛɛŋ teeŋ wi wumu wu bɛ teenyi le Simu Pita. ");
INSERT INTO asj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wi wulu gii bɛ wɛ bɛ ntoŋ wu bɛniiŋ bɛchu bɛ li wɛɛ yih gii be kɛmɛ kinsofu. ");
INSERT INTO asj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Le ntuu mbɛchi le ni n'yeti, Fiana yi Waaŋ dza yi shee yi bɛ li bɛniiŋ bɛlu nɛɛ si yi tɛ̀ bɛ li tɛɛbeŋ fɛmbɛɛchɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Le ŋɛŋ lɛ, mbiee ŋkimi fiee fi Taa tɛ̀ tee le, ‘Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ, bɛdɛɛni, Nyɔ gii yi lii beŋ tɛ nuuŋ bɛ tsaŋ yi Fiana yi Waaŋ.’ ");
INSERT INTO asj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɛ Nyɔ tɛ̀ nyɛ bɛniiŋ bɛlu nya yi nuuŋ yi tɛ̀ nyɛ li tɛɛbeŋ mfi wu tɛ tɛ̀ gɛɛ shéŋ li Taa Jiso Krai, ntɛ̀ nnuuŋ noo wu gii nuuŋ wu nloosɛ fiee fi Nyɔ feti?” ");
INSERT INTO asj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Le bɛniiŋ bɛlu woo si Pita kweeŋ lɛ, be ti mɛɛŋ ki tuu kɛ le be guŋ wu kɛ. Be dza be tuu be yɔɔnchi bu Bujɔŋ bu Nyɔ-ɔ be tiiti le, “Ɛ fi nuuŋ lɛ, kɛ Nyɔ nyɛ yɛ tɛ dze li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ le be fiiki shéŋ yibe, be kɛmɛ ntsɛ wu kimakɛ.” ");
INSERT INTO asj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bɛniiŋ bɛ tɛ̀ saaŋgɛ si ŋgɛ tɛ̀ bɛchi mfi wu bɛ tɛ̀ wo Fitifiŋ wɛ be gɛɛŋ li bintsii, li bintsii li, be gɛɛŋ be bo Fonisha, bamu gɛɛŋ Saaplu, bamu se gɛɛŋ Antiɔk. Si be tɛ̀ giiŋgi lɛ, be tɛ̀ fenjisi jɛ yi Nyɔ nuuŋ li Bɛjuu li kwaa. ");
INSERT INTO asj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Se nuuŋ le, bɛniiŋ bamu bɛ kimbeenchɛ-ɛ bɛ tɛ̀ dzɛti Saaplu mɔɔ Sɛli-iŋ, be giiŋgi Antiɔk be fenjisi tɛ ntoŋ wu dzeeŋ wu kii Taa Jiso li bɛniiŋ bɛ tɛ̀ nuuŋ yɛ Bɛjuu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Li buŋga bu Taa Nyɔ-ɔ, be fɛ bɛniiŋ ŋge gɛɛ shéŋ li Taa Jiso-o, be fiiki be to bɛ wu. ");
INSERT INTO asj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ntoŋ wuni tɛ̀ lɛ li bintooŋ bi kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Jɛrosalɛŋ. Be se toŋ Banaba Antiɔk wudoonchɛ lu. ");
INSERT INTO asj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Le gɛɛŋ bo le, ŋɛŋ si Nyɔ shéŋ yee yi dzeeŋ li bee, woo bujɔŋ, se tifi be le be ni be biki li Taa li, bɛ shéŋ yibe chi. ");
INSERT INTO asj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba wuni tɛ̀ nuuŋ wi wu dzeeŋ, tɛ̀ yisɛ bɛ Fiana yi Waaŋ tuu kɛmi kimbeenchɛ ŋge. Bɛdɛɛni se fɛ bɛniiŋ ŋge gɛɛ shéŋ li Taa li le. ");
INSERT INTO asj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banaba se dza gɛɛŋ Taasu le gɔɔŋ Sɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Le gɔɔŋ ŋɛŋ wu, dzɔ wu, bee wu to lijiŋ Antiɔk. Be tɛ̀ nuuŋ fe kiya kimbiri bɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, be tiifi bɛniiŋ ŋge. Ɛ Antiɔk wulu wu bɛ tɛ̀ bɛchi bɛ teenyi kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ le bɛniiŋ bɛ Krai lɛ. ");
INSERT INTO asj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Le ni nuuŋ li mfi wulu, bɛniiŋ bamu bɛ tɛ̀ laŋini biee bi be wuki Nyɔ tiiti, tɛ̀ dza Jɛrosalɛŋ be bɔɔ Antiɔk. ");
INSERT INTO asj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Fiana yi Waaŋ fɛ se wi wumu li bee linti wu bukooŋ bwee tɛ̀ nuuŋ le Agabu, dza leŋ we dzaaŋ le, dzeeŋ yi tɛɛmi gii yi kɔɔ kwɛɛŋ wuni kwikwi. Dzeeŋ yilu se bɛ yi kɔɔ mfi wu Klawdu tɛ̀ nuuŋ Mfɔŋ wu Lom. ");
INSERT INTO asj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Le kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Antiɔk woo lɛ, be nachɛ le wi kwikwi cho kwa wu mwɛ kɛmi, be fi bɛŋwaani bɛ bee bɛ nuuŋ Judiya lu. ");
INSERT INTO asj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Be se cho, be toŋ Banaba bee Sɔɔ lu le be gɛɛŋ be nyɛ li bɛte kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Le ni nuuŋ li mfi wulu-u, Mfɔŋ Hɛrɔ bɛchi ŋwɛki bɛ bɛniiŋ bamu bɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kweeŋ bɛ wachɛ Jeeŋ wu ŋwaani Jɔɔŋ kwi. ");
INSERT INTO asj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Le ŋɛŋ le fi dzɔɔŋ fiɛɛ fɛ Bɛjuu li, se gɛɛŋ limfwe tee le be kɔɔ tɛ Pita. Bɛ tɛ̀ kɔɔ wu nuuŋ li jo yi Tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ Kishee le kɛ. ");
INSERT INTO asj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Le be kɔɔ wu lɛ, be se bɛŋɛ wu li yih yi ncha-a, be gɛɛ bintutu bi bɛniiŋ bɛ nchi-i binɛɛ le bi ni bi kiichi wu bɛniiŋ bɛnɛɛ, bɛnɛɛ. Hɛrɔ tɛ̀ giki Pita lɛ le ke Tsɔnɔ chi N'yafuwee tuu chi ka, se buu wu leeki limfwe li bɛniiŋ li be saa wu. ");
INSERT INTO asj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita se nuuŋ nɛɛ li yih yi ncha-a. Se nuuŋ le, kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ tɛ̀ lɛki li Nyɔ-ɔ mkpaaŋ kii wu. ");
INSERT INTO asj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Le ni nuuŋ butuu bu tɛ̀ wuuti le Hɛrɔ buu Pita le be saa wu, Pita tɛ̀ liiti kintikinti ki bɛniiŋ bɛ nchi-i bɛfɛ ɛ be kaŋ wu bɛ bɛncha bɛfɛ, be se kiichi wu. Bɛniiŋ bɛ nchi-i bamu kiichi lɛ yi-i yi ncha-a mfweeŋ. ");
INSERT INTO asj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Fi se ka le nchindaa wu Taa tɛ̀ dza taa busɛ, kiŋ'wofu baŋ li yih yi ncha-a yilu-u. Nchindaa wulu koŋ Pita li bwɛɛŋ li, kaaŋgi. Tee li wuu le, “Dza we tsɛkɛ.” Si wu tee lɛ, bɛncha baa biee be fanchɛ li bibɛnu bi Pita be weyɛ fɛkwiiŋ. ");
INSERT INTO asj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tuu tee li wuu le, “Lii ndu ya, ɔ lii bikpɔ bio.” Pita fɛ lɛ. Nchindaa wulu se tuu tee le, “Foochɛ ndu ya ɔ biee mi!” ");
INSERT INTO asj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita se bo, biki wu lɛkuuŋ. Tɛ mɛɛŋ nɛɛ ki kɛɛ kɛ le fiee fi nchindaa wulu feti nuuŋ chɛɛŋ kɛ. Tɛ̀ beechi le ɛ fiee si kifiee ki bɛɛ lɛ wu-u. ");
INSERT INTO asj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Be tɛ̀ dɛndɛ be ka kintsii ki limfwe fɛ bɛniiŋ bɛ nchi-i tɛ̀ kiichi, be tuu be ka ki lɛjiŋ, be biee be fɛsi fɛ fweeŋ wu mbaŋ wu muŋkɔŋ wu busini li kitoŋ ki fe-e. Fweeŋ wu mbaŋ wulu gwiyɛ lɛ wu bɔ, be se bo. Le be bo lɛ, be deŋgi be beki dze dze, nchindaa wu Taa Nyɔ wulu se dza la lɛ wu-u lii. ");
INSERT INTO asj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Le Pita shɛ, bufii to wu fe, tee le, “Dɛɛni mi ŋkɛɛɔ chɛɛŋ chɛɛŋ le ɛ Taa wu bee toŋ nchindaa we le bɛ buu mi li tsaŋ yi Hɛrɔ-ɔ, mi nse mbo li ŋgɛ wu Bɛjuu tɛ̀ tɛŋgi le be gii be nyɛ mi.” ");
INSERT INTO asj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Le kɛɛ lɛ, se dza giiŋgi li Maariya yih wu ni Jɔɔŋ Mak, ɛ bɛniiŋ tɛ banchɛ fe ŋge be lɛki li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Gɛɛŋ bo fe, koŋ fweeŋ wu mbaŋ, ŋwaakwɛɛŋ wumu wu bukooŋ bwee tɛ̀ nuuŋ le Loda wu tɛ̀ nindi li yih lɔɔ bɛ le gwiyɛ. ");
INSERT INTO asj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Le tuu woo nuuŋ jɛ yi Pita, nɛɛtɛ ŋge, tɛ̀ mɛɛŋ ki gwiyɛ kɛ mbaŋ kɛ, tuu dza letɛ kaari gɛɛŋ lɛ li yi, tee li bɛniiŋ li le, “Pita wɛ fɛ mfweeŋ wu mbaŋ.” ");
INSERT INTO asj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Be tuu li wuu le, “Ɔ jetɔɔ.” Se nyiitini nɛɛ le ɛ Pita. Be dza be tee le “Nuuŋ ni nuuŋ nchindaa wu Nyɔ-ɔ ye.” ");
INSERT INTO asj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Si be tɛ̀ tiiti lɛ, Pita ba bɛ ŋkonu. Be gwiiyi lɔ, be ŋɛŋ chɛɛŋ le ɛ wu, wa tɛ be. ");
INSERT INTO asj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Maa be bɛ tsaŋ le be chikɛ bɛ ŋkweŋɛ, se tee be si Taa bee buu wu li yih yi ncha-a, tuu tee le be tee Jeeŋ mɔɔ bɛniiŋ bɛ kimbeenchɛ-ɛ bɛchu. Si tɛ̀ tee lɛ, se dza gɛɛŋ kimbɛ kimu. ");
INSERT INTO asj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Le butuu woo, bufii shaanshɛ li bɛniiŋ bɛ nchi baa bushaanshɛ laa fi ka niŋ bɛ Pita le. ");
INSERT INTO asj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɛrɔ buu bɛniiŋ le be dɛndɛ be gɔɔŋ wu. Be gɔɔŋ, be gɔɔŋ nsiŋ. Se teeŋ bɛniiŋ bɛ nchi-i bɛ tɛ̀ kiichi Pita baa, bii biee li bee, se dza tee le bɛ dzɔɔ be, bɛ gɛɛŋ bɛ mɛɛshi bɛ be. Lɛjiŋ lɛlu, Hɛrɔ dza kimbɛ ki kwɛɛŋ lɛ ki Judiya, bɔɔ gɛɛŋ nuuŋ li kitoŋ ki Kasaria. ");
INSERT INTO asj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Li mfi wulu shéŋ tɛ̀ tɔnyi Mfɔŋ Hɛrɔ bɛ bɛniiŋ bɛ Tayɛ mɔɔ bɛ Sidɔŋ. Bɛniiŋ bɛlu se banchɛ yi le be gɛɛŋ be sooŋ bɔ le mbɛɛŋgii ni nuuŋ lu, kifɛ kwɛɛŋ wube tɛ̀ kɛmi biee bijɛ nuuŋ li kwɛɛŋ wee li. Be gɛɛŋ, be saa be kɔɔ nsaŋ bɛ Blastus wu tɛ̀ nuuŋ te ntɔ. ");
INSERT INTO asj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Le jobɛ bɛ chi kɔchɛ, Mfɔŋ Hɛrɔ chuumɛ ndú yi buŋkuŋ, shee li kabara, nyɛ tefɛ li bɛniiŋ bɛlu. ");
INSERT INTO asj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Be dza be wuuyi, be yɔɔnchi wu be tiiti le, “Chini tefɛ nuuŋ chi nyɔ, nuuŋ yɛ chi wi wu bɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mfwaa mumkpaŋ, nchindaa wu Taa biee toŋ chigɔŋ li Mfɔŋ Hɛrɔ, kifɛ ti mɛɛŋ ki nyɛɛ mpiaru wulu li Nyɔ-ɔ kɛ. Muntsoŋ biee mu ji wu, kwi. ");
INSERT INTO asj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Se nuuŋ le, jɛ yi Nyɔ se lii li shéŋ yi bɛniiŋ li, yi saaŋgini yi giiŋgi limfwe limfwe. ");
INSERT INTO asj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba bee Sɔɔ mɛɛshi fiee fi bɛ tɛ̀ toŋ be Jɛrosalɛŋ lu, be se kaari be to lɛjiŋ Antiɔk. Fɛ be tɛ̀ tuu lijiŋ, be dzɔ Jɔɔŋ Mak. ");
INSERT INTO asj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bɛniiŋ bamu tɛ nuuŋ li kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ ki Antiɔk, nuuŋ bɛ tɛ̀ tiiti biee bi be wuki Nyɔ yeti, be tuu be tiifi bɛniiŋ. Bɛniiŋ bɛlu tɛ̀ nuuŋ Banaba bee Simiɔŋ wu bɛ tɛ̀ teenyi le wu Tii, mɔɔ Lushus wu Sɛli-iŋ bɛ Sɔɔ mɔɔ Manɛɛŋ wu tɛ̀ ta bɛ Hɛrɔ wu wi wu nsawu. ");
INSERT INTO asj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Be tɛ̀ shiiŋ be fɛŋgi biee bijɛ be lɛki li Nyɔ-ɔ, Fiana yi Waaŋ dza yi tee li bee le, “Buu yɛɛŋ Banaba bɛ Sɔɔ nɛ gɛɛ chichi be ni be nindi nimɛ chi mi nteeŋ be le be ni be nindi.” ");
INSERT INTO asj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Le be woo lɛ, be ba nɛɛ be fɛŋgi biee bijɛ be lɛki li Nyɔ-ɔ, be dza be gɛɛ tsaŋ li bee, be chinɛ be, be tuumi be le be ni be giiŋgi. ");
INSERT INTO asj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banaba bee Sɔɔ se dza ŋgɛnu si Fiana yi Waaŋ tɛ̀ toŋ be. Be dza be bɔɔ li kitoŋ ki Sɛlusa-a, be lɛ lɛ yih yi li dzɔɔ li, be lenchi, be giiŋgi li kwɛɛŋ wu Saaplu-u. ");
INSERT INTO asj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Le be lenchi be bo li kitoŋ ki Salami-i, be tuu be deŋgi be tiiti jɛ yi Nyɔ li yíh yi nlɛkɛ li Nyɔ-ɔ yi Bɛjuu, Jɔɔŋ Mak tɛ̀ deŋgi bee be, fii be. ");
INSERT INTO asj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Be dɛndɛ li kwɛɛŋ wu dzɔɔ kintikinti wulu-u, be se lenchi be gɛɛŋ be busɛ li kitoŋ ki Pafo-o kibɛɛ. Le be gɛɛŋ be mbundɛ li wi wu Bɛjuu wumu fe-e, ɛ tɛ̀ nuuŋ wi wu mfiŋ bukooŋ bwee nuuŋ le Bal Jiso, ɛ tɛ̀ shiiŋ yɛŋgi le ti nuuŋ wi wu tiiti biee bi ti wuki Nyɔ tiiti. ");
INSERT INTO asj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tɛ̀ shiiŋ bee Sɛgus Pɔlus wu tɛ̀ nuuŋ wi wu nsawu li kwɛɛŋ wulu-u. Wi wu nsawu wulu tɛ̀ kɛmi bufii ŋge. Se dza teeŋ Banaba bee Sɔɔ kifɛ tɛ̀ wɛki le woo jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Le be bɛ, bɛdɛɛni se Ɛlima wu wi wu mfiŋ wɛ si bukooŋ bwee tɛ̀ nuuŋ lɛ jɛ́ yi Grik, se loosi be, gwenini le fɛ le kiiŋ wi wu nsawu wulu ni gɛɛ shéŋ li Jiso-o kɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Fiana yi Waaŋ yisɛ li Sɔɔ li, wu bukooŋ bwee bumu tɛ̀ nuuŋ le Pɔɔ, luuŋgi lii li wi wu mfiŋ wulu-u, ");
INSERT INTO asj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","tee li wu le, “Ɛ wɛ ŋwanɛ kiŋkundi, ɛ wɛ wi wu baanini fiee fichu fi nuuŋ tsaaŋ. Kimfi bɛ binsɛɛ yisɛ biɛɛ li shéŋ ya-a. Nuuŋ ɔ tɛ̀ nuuŋ yee mfikisɛ chɛɛŋ wu Nyɔ le wu to binsɛɛ kɛ ni? ");
INSERT INTO asj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yikɛ ɔ woo, dɛɛni yani kibɛnɛ ki Nyɔ-ɔ gii ki we li wɛ-ɛ ɔ nyɛɛ, fi gii fi dzɔɔ mfi se ɔ tuu ɔ ŋɛŋ mɔɔ jobɛ.” Mfwaa mumkpaŋ nɛɛ lɛ, fiee fimu shee nɛɛ si kikuŋ, fi baanyɛ lii yi Ɛlima. Se dza tuu mɔnchi bintsii, wɛki wi wu nuuŋ ni tsɛtsi wu. ");
INSERT INTO asj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Le wi wu nsawu wɛ ŋɛŋ lɛ, se gɛɛ shéŋ li Jiso-o, kɛmɛ chɛnɛ li biee bi bɛ tɛ tiifi kii Taa Jiso. ");
INSERT INTO asj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔ bee kintutu kee lɛ lɛ yih yi li dzɔɔ yi Pafo-o, be lenchi dzɔɔ yi nyɔŋa be bo li kitoŋ ki Pɛrga-a li kwɛɛŋ wu Pamfila-a. Le be bo fe, Jɔɔŋ Mak shɛ be, to lijiŋ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Be dza fe, be ka be gɛɛŋ li kitoŋ ki Antiɔk wu Pisidia. Le ni nuuŋ jobɛ chi bɛshiinshi, be gɛɛŋ be lɛ be shee li yih yibe yi lɛkɛ li Nyɔ-ɔ ");
INSERT INTO asj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bɛniiŋ dza be teeŋ Kiŋwaati ki bɛnchi bɛ Mɔɔsɛ-ɛ mɔɔ ki bɛntomfɔŋ bɛ Nyɔ-ɔ be mɛɛshi, bɛte kikoo bɛ li yih yi nlɛkɛ li Nyɔ-ɔ yilu biee be toŋ ntoŋ li Pɔɔ li le, “Bɛŋwaanɛŋ bɛsɛŋ, ɛ nɛ kɛmi ntifi le nɛ tifi bɛniiŋ lu, nɛ tee kituŋ.” ");
INSERT INTO asj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔɔ se dza we, chi bɛniiŋ bɛ kibɛnɛ bɛchi tiiti le, “Bɛniiŋ bɛ Isɛlɛɛ mɔɔ bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ bɛ guundi tɛ Nyɔ, yikɛ yɛɛŋ nɛ woo. ");
INSERT INTO asj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nyɔ yi bɛniiŋ bɛ Isɛlɛɛ tɛ̀ tsaa bɛte taa bɛsɛŋ, yi fɛ le kini kibee ko li mfi wu be tɛ̀ nuuŋ mfoŋ li kwɛɛŋ wu Iji-ip. Yi bɛ yi buu be le bɛ buŋga bwee. ");
INSERT INTO asj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Yi kɔɔ nshiiŋ bɛ be, se yi bichi nɛɛ fɛ bee li buka li biya mbaanyɛɛ li. ");
INSERT INTO asj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Yi fɛ be shiiki bitoŋ bi mfomɛnyaaŋ bi li kwɛɛŋ wu Kana-a, yi se nyɛ kwɛɛŋ wulu wu to wu bee. ");
INSERT INTO asj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Biee bini bichu tɛ̀ dzɔ kintsii si biya gii nɛɛ bɛ kitsɔ mbaanshiŋ (450). Si yi tɛ̀ nyɛ kwɛɛŋ wulu li bee lɛ, yi se gɛɛ bɛniiŋ bɛ sɛki be. Be saa be gɛɛŋ bo li mfi wu ntomfɔŋ we wu Samwɛ tɛ̀ sɛki. ");
INSERT INTO asj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɛɛ li mfi wɛɛ be dza be lɛkɛ le be kɛmɛ nuuŋ mfɔŋ, Nyɔ se nyɛ be Sɔɔ, ŋwanɛ Kish wu li kini ki Bɛnjamɛ-ɛŋ. Se saa bumfɔŋ bulu biya mbaanyɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nyɔ se shiiki wu, yi gɛɛ Daafi li Mfɔŋ wu bee. Nyɔ tɛ̀ tee kii Daafi wuni le, ‘Mi ŋɛŋgɔɔ Daafi wu ŋwanɛ Jɛɛsi wɛ nuuŋ shéŋ yɛŋ. Gii naa ni feti fiee fichu fi ŋ'wɛki.’ ");
INSERT INTO asj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ɛ li kini ki Mfɔŋ Daafi-i wuni li Nyɔ tɛ̀ buu Kinsofu, yi nyɛ li bɛniiŋ bɛ Isɛlɛɛ si yi tɛ̀ kaachɛ. Kinsofu kini nuuŋ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fɛ Jiso wuni tɛ̀ mɛɛŋ se naa bɛchi nimɛ chee nuuŋ ɛ Jɔɔŋ tɛ̀ tiiti le bɛniiŋ bɛchu bɛ Isɛlɛɛ fiiki shéŋ yibe le lii be li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Le Jɔɔŋ ni tuu nuuŋ lɛ kimɛrisɛ ki nimɛ chee lɛ, tuu dza bii li bɛniiŋ li laa, ‘Nɛ beechi le nnuuŋ noo? Nnuuŋ yɛ wi wu nɛ tɛŋgi kɛ. Wi wulu bɛɛɔ lɛ mi jiŋ, mmɛɛŋɔ mɔɔ ŋki kɔchɛ kɛ le ŋguumɛ mfanchɛ bɛkuu bɛ bikpɔ biee li kɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pɔɔ gɛɛŋ limfwe kweeŋ le, “Bɛŋwaanɛŋ bɛ nuuŋ kini ki Abraha-aŋ mɔɔ beŋ bɛniiŋ bɛchu bɛ nuuŋ yɛ Bɛjuu kɛ bɛ guundi tɛ li Nyɔ-ɔ, Nyɔ tɛ̀ tuumi ntoŋ wuni wu nuuŋ le bɛniiŋ bo lu li tɛɛbeŋ. ");
INSERT INTO asj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Se nuuŋ le, bɛniiŋ bɛ Jɛrosalɛŋ bɛ bɛniiŋ bɛ bee bɛ sɛki kwɛɛŋ, faaŋ le be dzeti yɛ Jiso si Kinsofu kɛ. Be tuu be faaŋ le be kii yɛ kinyi ki biee bi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛɛ kii wu kɛ. Ɛ nɛɛ bi bi be tɛ̀ shiiŋ be teenyi li jo yi bɛshiinshi chichi. Si be tɛ̀ tee le bɛ wo wu lɛ, fini fɛ fi se bɛ fi kɔchɛ si bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tee. ");
INSERT INTO asj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mɔɔ si be ti mɛɛŋ ki ŋɛŋ chɔ yi nuuŋ be wo wu kii yi kɛ, be gɛɛŋ nɛɛ limfwe be tee li Pailɛt le bɛ wo wu. ");
INSERT INTO asj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Be fɛ fiee fichu si Kiŋwaati ki Nyɔ-ɔ tɛ̀ tee kii Jiso, be shiiki wu li kintaaŋ li be gɛɛŋ be gɛɛ wu lɛ dziŋ. ");
INSERT INTO asj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Se nuuŋ le, Nyɔ tɛ̀ kaari yi buu wu li kwe-e. ");
INSERT INTO asj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tɛ̀ doonchɛ yi yee li jo ŋge, li bɛniiŋ bɛ bee be tɛ̀ dza Galilii be gɛɛŋ Jɛrosalɛŋ. Ɛ be bɛ tiiti kii wu dɛɛni li bɛniiŋ bɛ Isɛlɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Se nuuŋ le, tɛ se baa fɛni dɛɛni tɛ le tɛ ni tɛ tiiti ntoŋ wu dzeeŋ wulu li be-eŋ. Ntoŋ wulu nuuŋ le, fiee fi Nyɔ tɛ̀ kaachɛ bɛte te bɛniiŋ bɛ Isɛlɛɛ lu, ");
INSERT INTO asj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","wu fɛɔ fi bɛ fi kɔchɛ dɛɛni li mfi wu tɛɛbeŋ wuni-i, tɛɛbeŋ tɛ nuuŋ bɔɔŋ bɛ bee. Fini tɛ̀ ka si Nyɔ tɛ̀ buu Jiso li kwe-e. Bɛ tɛ̀ saa bɛ tsɛɛ kii fiee fini lɛ Kiŋwaati ki N'yɔɔnchɛ bintsii bifɛ, ɛ Nyɔ tiiti le, ‘Ɔ wɛ Ŋwanɛŋ, nse numi Chaa bɛŋ.’ ");
INSERT INTO asj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kii mbusu wu Nyɔ tɛ̀ buu Jiso li kwe-e le kiiŋ ni fɔ kɛ, Nyɔ tɛ̀ tee lɛ yini dze-e le, ‘Ŋgii nyɛ beŋ kimbɔnɛ ki nuuŋ keŋ, ki ntɛ̀ ŋkaachɛ Daafi lu, nchini.’ ");
INSERT INTO asj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Fi fiɛɛ ɛ bɛ tɛ̀ tuu bɛ tsɛɛ fɛ kintsii kimu lɛ Kiŋwaati ki N'yɔɔnchɛ-ɛ Daafi tiiti le, ‘Ɔ nuuŋ tɛ̀ naa chinɛ Ŋwana wu nimɛ wu Wuuti, le fɔ lɛ dziŋ kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Fi Daafi nuuŋ le tɛ̀ niŋ nimɛ chee chi Nyɔ tɛ̀ nyɛ li wu li mfi we-e, le kwi bɛ se diiyɛ wu li bɛtee li lichiŋ fɔ. ");
INSERT INTO asj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Se nuuŋ le, wi wuni wu Nyɔ tɛ̀ buu wu li kwe-e tɛ̀ mɛɛŋ ki fɔ-ɔ lɛ dziŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bɛdɛɛni, bɛŋwaanɛŋ, nɛ kɛɛ bujɔŋ le ntoŋ wuni wu be fenjisi le Nyɔ fekisi bibifi bi bɛniiŋ lɛ nuuŋ le yi fekisi kii Jiso wuni. ");
INSERT INTO asj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Wi kwikwi wu gɛɛ shéŋ yee li Jiso-o, wɛ ɛ wu bo li bibifi biee li bichu, se nuuŋ fiee fi nchi wu Mɔɔsɛ nuuŋ tɛ fɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Se nuuŋ le, ŋɛŋgɛ yɛŋ le, kiiŋ fiee fi bɛ tsɛɛ lɛ Kiŋwaati ki bɛntomfɔŋ bɛ Nyɔ-ɔ ni kɔɔ beŋ kɛ. Bɛ tiiti baa le le, ");
INSERT INTO asj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Yikɛ yɛŋ nɛ woo, beŋ bɛ choosi Nyɔ. Bimfimu gii bi wondɛ beŋ, nɛ kwiyɛ. Ŋgii mɔŋ fiee li mfi wunɛ, nuuŋ fi wi bee tee li beŋ, nɛ tɛ beŋ kɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Le Pɔɔ bee Banaba ni be buti li yih yi nlɛkɛ li Nyɔ-ɔ yilu, bɛniiŋ bɛlu se lɛki le ke be tuu be bɛ bwɛɛshiinshi bu bɛɛ le be bɛ be tee be biee bini. ");
INSERT INTO asj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Le bɛniiŋ bɛlu bo li yih yi nlɛkɛ li Nyɔ-ɔ, bɛniiŋ ŋge bɛ tɛ̀ nuuŋ Bɛjuu mɔɔ bɛniiŋ bɛ tɛ̀ fiiki bufikisɛ be to Bɛjuu, be biki Pɔɔ bee Banaba. Be deŋgi be tiiti li bɛniiŋ le be ba be ni be nuuŋ lɛnti lɛ mfiɛ wu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Le ni nuuŋ bwɛɛshiinshi bu biki bwɛɛ, kitoŋ kilu kichu se tuu ki leki le ki bo ki bɛ ki yikɛ jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Le Bɛjuu ŋɛŋ si kimbaanchɛ ki bɛniiŋ lɛ banchɛ lɛ, be se bɛchi be yɛɛti shéŋ be fɛŋgi biee bi Pɔɔ tɛ tiiti, be gaashi wu. ");
INSERT INTO asj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔɔ bee Banaba se yeti nɛɛ nchɛnu nsiŋ, be tiiti le, “Fi dzɔɔŋ le tɛ saa tɛ tee jɛ yi Nyɔ nuuŋ li beŋ Bɛjuu li. Si nɛ ŋwɛsi baa buŋ'wɛshɛ nɛ dzɔ yi yinɛ le nɛ mɛɛŋ baa ki kɔchɛ kɛ le nɛ nuuŋ tɛ kɛmɛ ntsɛ wu kimakɛ lɛ, kɛ tɛ gii tɛ fiiki fisɛŋ tɛ ni tɛ tiiti fisɛŋ nuuŋ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Fi fiɛɛ si Nyɔ tɛ̀ tee li bee li, mfi wu tɛ̀ tee le ‘Mi nleekɔɔ wɛ le ɔ nuuŋ kiŋ'wofu li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, ɔ fɛ se bɛniiŋ bɛ nuuŋ li nshɛ yini chichi be bɔnɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ woo lɛ, be nɛɛtɛ, be piɛti jɛ yi Taa. Bɛniiŋ ŋge beŋ ntoŋ wulu, nuuŋ bɛ Nyɔ bee saa yi tsaa le be gii be kɛmɛ ntsɛ wu kimakɛ. ");
INSERT INTO asj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jɛ yi Taa se dɛndɛ li kwɛɛŋ wulu kwikwi. ");
INSERT INTO asj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Se nuuŋ le, Bɛjuu tɛ dza be ŋkunsɛ bɛte kitoŋ bɛ bukɛɛŋ bɛ nɔŋa bɛ nɔŋa bamu, bukɛɛŋ bani nuuŋ bɛ tɛ̀ shiiŋ be bɛɛ li yih yi nlɛkɛ li Nyɔ-ɔ, be baanini Pɔɔ bee Banaba, be se kooŋ be le be dza fe. ");
INSERT INTO asj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Le be ni be dzɛti lɛ, be kachɛ kiboŋ ki li bikaa bi bee, le fi ni fi nuuŋ doonchɛ wu fiee fi be mɔŋ, be se gɛɛŋ li kitoŋ ki Ikonyɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ shɛ ki nuuŋ ki fi ki wuki bujɔŋ ŋge Fiana yi Waaŋ yisɛ li bee. ");
INSERT INTO asj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Le Pɔɔ bee Banaba gɛɛŋ Ikonyɔŋ, be fɛ nɛɛ si be tɛ̀ feti Antiɔk, be lɛ li yih yi nlɛkɛ li Nyɔ-ɔ yi bɛ Bɛjuu yi fe-e, be tee ntoŋ wu dzeeŋ lu. Be bɔsɛyi be tiiti, Bɛjuu mɔɔ bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ se beŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Se nuuŋ le, Bɛjuu bɛ tɛ̀ fɛŋgi le be beenchi yɛ kɛ baa dza be kunsɛ bɛniiŋ bamu bɛ tɛ nuuŋ yɛ Bɛjuu kɛ, be biifi shéŋ yibe, le shéŋ ni yi tɔnyi be bɛ bɛniiŋ bɛ kimbeenchɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔ bee Banaba ba nɛɛ fe mfi dɛɛŋ, be fenjisi nchɛnu nsiŋ kii Taa. Taa nyɛ be buŋga le be ni be feti biee bi doonchi buŋga bu Nyɔ-ɔ bɛ biee bi bimfimu wondini bi doonchi le fiee fi be tiiti kii Taa si wu doonchɛ shéŋ yee yi dzeeŋ li bɛniiŋ li nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bɛniiŋ bɛ li kitoŋ kilu-u gatɛ. Bamu to kimbɛ ki Bɛjuu bɛ tɛ̀ fɛŋgi mbeenchɛ baa, bamu se to lɛ kimbɛ ki bɔɔŋ bɛ nto-oŋ bɛ Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bɛjuu baa, bɛ bɛniiŋ bɛ tɛ̀ nuuŋ yɛ Bɛjuu kɛ mɔɔ bikoo bi kwɛɛŋ lɛ se banchɛ, be dzɔ ntaŋ le be ŋwɛɛ bɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o, be tomɛ be bɛ ta le be kwiyɛ. ");
INSERT INTO asj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Be kɛɛ ntaŋ wulu, be se kifi be gɛɛŋ li kwɛɛŋ wu Likonia-a, be tuu be deŋgi li bitoŋ bi Listra bɛ Dɛlbi mɔɔ li bitoŋ bi nuuŋ lu lichiŋ, ");
INSERT INTO asj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","be tiiti ntoŋ wu dzeeŋ le. ");
INSERT INTO asj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Wi wumu tɛ̀ nuuŋ Listra, tɛ̀ shiiŋ nɛɛ fɛkwiiŋ, tɛ̀ gii deŋgi yɛ kɛ, kifɛ bɛ tɛ̀ biɛ wu nuuŋ kiŋkɛrɛ. Le ni nuuŋ jobɛ chimu, ");
INSERT INTO asj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","shee yiki fiee fi Pɔɔ tɛ̀ tiifi. Pɔɔ lɔŋ lii li wu-u, ŋɛŋ wi wulu kɛmi kimbeenchɛ le Nyɔ nuuŋ yi wɔnchi wu, ");
INSERT INTO asj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","se tee li wu-u lɛwe ŋge le, “Dza ɔ leŋ we.” Mwɛ se jiiŋ liwe, bɛchi deŋgi. ");
INSERT INTO asj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kimbaanchɛ ki bɛniiŋ lɛ ŋɛŋ fiee fi Pɔɔ fɛ, be bɛchi be tundi bitatu, be tiiti lɛ jɛ́ yi Likonia-a le, “Bɛnyɔ to baa bɛniiŋ, be shee be bɛ li tɛɛbeŋ.” ");
INSERT INTO asj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Be bɛchi be teenyi Banaba le Siyus, be teenyi Pɔɔ le Ɛmi kifɛ Pɔɔ tɛ̀ shiiŋ yeti ŋge. ");
INSERT INTO asj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tɛ̀ nuuŋ yih yi muntofi yi nyɔ yimi yi bɛ teenyi le Siyus yi nuuŋ li kitoŋ kilu lichiŋ. Te muntofi wu fe se dzɔ bɛnaŋ bɛ buniŋ mɔɔ bɛ flaaba bɛ bɛ be fɛ fweeŋ wu mbaaŋ le bee bɛniiŋ fɛ muntofi lu li Banaba bee Pɔɔ li. ");
INSERT INTO asj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bɔɔŋ bɛ ntoŋ bɛ Jiso bani, kɛɛ fiee fi bɛniiŋ bɛlu tɛ̀ wɛki le be fɛ, be gaamɛ ndú yi bee, be letɛ be lɛ li bɛniiŋ bɛlu linti, be wɛndi le ");
INSERT INTO asj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bɛniiŋ bani, ɛ la fi nɛ feti fini? Tɛ nuuŋ nɛɛ bɛniiŋ si beŋ, tɛ bɛ baa fɛni le tɛ tee ntoŋ wu dzeeŋ wu dzɛti fɛ Nyɔ-ɔ le nɛ chinɛ li bɛnyɔ bɛ yee bani-i, nɛ ni nɛ biki nuuŋ Nyɔ yi Nyɔ. Nyɔ yini nuuŋ yi tɛ̀ tɔŋ kiboo bɛ nshɛ mɔɔ dzɔ́ɔ yi nyɔŋa yi nyɔŋa bɛ biee bichu bi nuuŋ li bintsii bini-i. ");
INSERT INTO asj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tɛ̀ gii nuuŋ ŋkosi, yi chinɛ bɛniiŋ li tɛɛŋ chi, le be ni be feti si be Kɔŋgisi ");
INSERT INTO asj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Se nuuŋ le, yi tɛ̀ feti nɛɛ biee bi dzeeŋ li bɛniiŋ li le yi doonchɛ le yi yɛɛ lu. Yi nyɛ be dzaaŋ, be kɛmi bijinɛ li mfi wu dzɛɛŋ li, be jii be wuki bujɔŋ.” ");
INSERT INTO asj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mɔɔ si Banaba bee Pɔɔ tɛ̀ tee biee bini li bee ni, be faaŋ fintofi, bɛniiŋ bɛlu se ba mfɛru muntofi li bee nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bɛjuu bamu tɛ̀ dza be bɛ fe, bɛ tɛ̀ dza Antiɔk bɛ Ikonyɔŋ, be bɛ be kunsini bɛniiŋ ŋge le be tomɛ Pɔɔ bɛ ta. Be tomɛ, be chee wu be bo bɛ wu fɛ kitoŋ kilu-u be beechi le wu kwiɔ kituŋ. ");
INSERT INTO asj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Se nuuŋ le, kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ ki banchɛ lɛ wu-u lɛwe, kaari dza we, to fɛ kitoŋ kilu-u. Le bu woo, bee Banaba dza fe, be giiŋgi li kitoŋ ki Dɛlbi-i. ");
INSERT INTO asj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Si Pɔɔ bee Banaba tɛ̀ lɛ Dɛlbi lɛ, be tee ntoŋ wu dzeeŋ kii Jiso, be kɛmɛ bɛniiŋ bɛ kimbeenchɛ-ɛ le ŋge. Be se dza fe be kaari be tuu lijiŋ, be kɛti bitoŋ bi Listra bɛ Ikonyɔŋ mɔɔ Antiɔk wu Pisidia. ");
INSERT INTO asj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Si be kɛti lɛ, be kaŋgisi shéŋ yi bɛniiŋ bɛ kimbeenchɛ-ɛ, be nyɛɛ be ntifi le be ba nɛɛ be ni be lemi mkpaaŋ bɛ kimbeenchɛ kibee, le be kɛmi le be ŋɛŋ bumfa ŋge be se lɛ li bumfɔŋ bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Be tsɛki tɛ̀ bɛte bintaashɛ bi bɛniiŋ bɛ kimbeenchɛ-ɛ, be giki li bintaashɛ bi bɛniiŋ bɛ kimbeenchɛ-ɛ bichu-u. Mfi wu bɛ giki be, be fɛŋgi biee bijɛ be lɛki li Nyɔ-ɔ be se nyɛɛ be li tsaŋ yi Taa Jiso wu be beenchi li wu-u. ");
INSERT INTO asj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pɔɔ bee Banaba ka li kwɛɛŋ wu Pisidia-a, be dansɛ be gɛɛŋ li wu Pamfila-a, ");
INSERT INTO asj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","be tiiti jɛ yi Nyɔ li kitoŋ ki Pɛrga-a, be se bɔɔ be gɛɛŋ li kitoŋ ki Atalia-a. ");
INSERT INTO asj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Le be bɔɔ le, be lɛ lɛ yih yi li dzɔɔ li, be kaari be giiŋgi Antiɔk. Antiɔk wuni nuuŋ fɛ bɛ tɛ̀ nyɛ be li tsaŋ yi Nyɔ-ɔ bɔɔni be bɛ mfiɛ we le be ni be deŋgi be nindi nimɛ chini chi be mɛɛshi. ");
INSERT INTO asj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Le be fɛsi fe, be banchɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, be tee fiee fichu li bee si Nyɔ tuu nindi bee be, bɛ si yi tuu yi gwiyɛ shéŋ yi bɛniiŋ bɛ tɛ̀ nuuŋ yɛ Bɛjuu kɛ, be gɛɛ shéŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔɔ bee Banaba se tsi bɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛlu mfi dɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bɛniiŋ bamu tɛ̀ dza Judiya, be bɔɔ be bɛ Antiɔk, be se tiifi bɛniiŋ bɛ kimbeenchɛ-ɛ le, fuki fɛ bɛ sɛɛ wi dzoo si nchi wu Mɔɔsɛ tiifi nsiŋ, kɛ Nyɔ nuuŋ tɛ soo mwɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔɔ bee Banaba faaŋ ntiifɛ wulu, bee bɛniiŋ bɛlu shi bɛ bitɛchinɛ li fiee filu-u, nuuŋ yɛ bi didi kɛ. Le fi yaa be, kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Antiɔk, buu Pɔɔ bee Banaba mɔɔ bɛniiŋ bɛ kimbeenchɛ bamu, be toŋ be le be yɛɛ Jɛrosalɛŋ be ŋɛŋ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o mɔɔ bɛte kintaashɛ ki bɛniiŋ bɛ kimbeenchɛ-ɛ ki le, le be bendɛ fɛ fiee filu. ");
INSERT INTO asj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Se nuuŋ le, kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ ki Antiɔk se chinɛ be, be se giiŋgi be kɛti bimbe bi Fonisha bɛ bi Samaaria be tiiti li bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ le le, bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ fiiki baa shéŋ yibe. Bɛniiŋ bɛchu wuki lɛ, be nɛɛtini ŋge. ");
INSERT INTO asj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Be yɛɛ be gɛɛŋ be fɛsi Jɛrosalɛŋ kintaashɛ ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o mɔɔ bɛte kintaashɛ ki le, fi be. Be se tee fiee fichu li bee, si Nyɔ tuu yi niŋ kɛti li tsaŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Se nuuŋ le, bɛniiŋ bɛ kimbeenchɛ-ɛ bamu bɛ tɛ̀ nuuŋ tɛ li kintutu ki Bɛfarasii lɛ, dza we be tee le, “Bɛ kɛmi baa le bɛ ni bɛ sɛɛti bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ dzóo, bɛ tiiti tɛ be le be ni be kichi bɛnchi bɛ Mɔɔsɛ.” ");
INSERT INTO asj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Le be tee lɛ, bɔɔŋ bɛ nto-oŋ bɛ Jiso mɔɔ bɛkaaŋ tuu be shee le be ŋɛŋ lɛ fiee filu lɛnti. ");
INSERT INTO asj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Be shi be tiiti kii fi, mfi gɛɛŋ. Pita se dza leŋ we tee le, “Bɛŋwaanɛŋ, ɛ nɛɛ lɛ si ŋkosi Nyɔ tɛ̀ buu mi lɛ be-eŋ lɛnti, le ɛ li kimfimɛ keŋ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ gii be ni be wuki ntoŋ we wu dzeeŋ, be se ni be beenchi li ntoŋ wulu-u. ");
INSERT INTO asj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nyɔ yi kii shéŋ yi bɛniiŋ, doonchɛ le yi fi yɛ bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, yi nyɛ be Fiana yi Waaŋ nɛɛ si yi tɛ̀ nyɛ li tɛɛbeŋ. ");
INSERT INTO asj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yi ti mɛɛŋ ki doonchɛ kɛ chichi li tɛɛbeŋ bɛ bɛniiŋ bɛlu kɛ. Yi tɛ̀ fɛ shéŋ yibe yi wuuti kifɛ be tɛ̀ gɛɛ shéŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Si fi nuuŋ lɛ, fi geeŋ fi nɛ wɛki le nɛ ni nɛ sɛɛsi shéŋ yi Nyɔ, nɛ dzeti bɛntɛ nɛ giki li bimi bi bɛniiŋ bɛ kimbeenchɛ-ɛ, ɛ bɛntɛ bani bɛ tɛ̀ yaa nɛɛ tɛɛbeŋ mɔɔ bɛte taa bɛsɛŋ ni? ");
INSERT INTO asj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Fi mɛɛŋ ki dzɔɔŋ kɛ! Tɛɛbeŋ beŋ baa le Nyɔ suuti bee nuuŋ kii shéŋ yi dzeeŋ yi Taa Jiso doonchɛ li bee li yi fɛ. Ɛ nɛɛ tɛ lɛ si yi bee yi soo bɛniiŋ bɛ nuuŋ yɛ bɛ Juu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Le Pita yɔ mɛɛshi, bɛniiŋ bɛchu chikɛ nshiiŋ, be yiki biee bi Banaba bee Pɔɔ tɛ̀ tiiti si be tuu be deŋgi be giiŋgi li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, Nyɔ nyɛɛ be buŋga le be ni be feti biee bi doonchi buŋga bu Nyɔ-ɔ bɛ biee bi bimfimu wondini. ");
INSERT INTO asj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Le be yɔ be mɛɛshi, Jeeŋ se tee le, “Bɛŋwaanɛŋ, yikɛ yɛɛŋ nɛ woo fiee fi ŋgii ntee. ");
INSERT INTO asj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simu teeɔ tɛɛbeŋ si Nyɔ tɛ̀ bɛchi yi doonchi tɛ kiŋkɔŋgisɛ kee li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, yi tsaa bamu li bee linti le be ni be nuuŋ bɛniiŋ bee. ");
INSERT INTO asj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Fiee fi bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tsɛɛ dɛndɛ fiɛɛ yɛɛŋ bɛ fi Nyɔ tɛ̀ fɛ. Be tɛ̀ tsɛɛ le, ");
INSERT INTO asj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mfi bɛɛɔ wu ŋgii ntuu ŋkaari mbɛ, nachɛ yih yi Daafi yi tɛ̀ we. Ŋgii gwaŋ bimfoo bilu, se yi kaari yi leŋ we. ");
INSERT INTO asj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Se nuuŋ le, kiŋkɛ ki bɛniiŋ lɛ se ni ki geendi Taa, bɛniiŋ bani bɛchu bɛ nuuŋ yɛ Bɛjuu kɛ bɛ mbee ntsaa le be ni be nuuŋ bɛniiŋ beŋ. ");
INSERT INTO asj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Fini ɛ Nyɔ yi tiiti, yi tɛ̀ fɛ bɛniiŋ kɛɛ mɛɛŋ lindɛɛri.’ ");
INSERT INTO asj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mi ŋɛŋgɔɔ fieŋ le tɛ nyɛ kɛ ŋgɛ nuuŋ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ bɛ gɛɛ shéŋ li Nyɔ-ɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tɛ̀ tsɛɛ nuuŋ Kiŋwaati kwaa li bee, tɛ̀ tee le kiiŋ be ni be jii biee bi bɛniiŋ fɛ bɛntanjɛ lu li bɛnyɔ-ɔ kɛ, kifɛ ɛ biee bi nyɛ-ɛŋ, le kiiŋ be ni be kɛmi fiee fi fɛrɛ bɛ bukwɛɛ kɛ, le kiiŋ be ni be jii nyaŋ yi bɛ sɛɛ fuki le ŋgɔŋ bo nsiŋ kɛ, kiiŋ be ni be jii ŋgɔŋ mɛ nyaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bɛ tsɛɛ baa lɛ, kifɛ bɛnchi bɛ Mɔɔsɛ bani bɛ tɛ̀ tifi be mɛɛŋ lindɛɛri li bintsii bichu-u bɛniiŋ wuki, ɛ nɛɛ be bɛ bɛ teenyi baa bɛŋ li yí yi nlɛkɛ li Nyɔ-ɔ jo yi bɛshiinshi chichi.” ");
INSERT INTO asj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Se nuuŋ le, bɔɔŋ bɛ nto-oŋ bɛ Jiso-o bee bɛte kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛchu se beŋ fiee fini, be se ŋɛŋ le fi dzɔɔŋ le be tsaa bɛniiŋ li bee li linti bɛ toŋ le be bɛ Banaba mɔɔ Pɔɔ be gɛɛŋ Antiɔk. Be se biee be tsaa Judas wu bukooŋ bwee bumu tɛ̀ nuuŋ le Basaba, be tuu be tsaa tɛ Sila. Bɛniiŋ bɛ bɛfɛ bani tɛ̀ nuuŋ bikoo lɛnti lɛ bɛniiŋ bɛ kimbeenchɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Be se tsɛɛ Kiŋwaati be toŋ be bɛ ki, ki nuuŋ le: “Bee bɛŋwaana bɛ nuuŋ bɔɔŋ bɛntoŋ bɛ Jiso-o, bɛ bɛte kintutu yɛɛshi baa beŋ bɛniiŋ bɛ kimbeenchɛ-ɛ bɛchu bɛ nuuŋ yɛ Bɛjuu kɛ, bɛ nuuŋ li kitoŋ ki Antiɔk mɔɔ bɛ nuuŋ kimbɛ ki Silia mɔɔ bɛ li ki Silisha. ");
INSERT INTO asj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tɛ woo baa le bɛniiŋ bamu bo baa lɛ bee li lɛnti, be bɛ be fieŋgisi beŋ, be bifisi bufii bunɛ bɛ ntiifɛ wumu, nuuŋ yɛ bee tɛ toŋ be kɛ. ");
INSERT INTO asj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Se nuuŋ le, tɛ se shee baa bee bɛchu tɛ beŋ le tɛ buu bɛniiŋ bamu tɛ toŋ be lɛ be-eŋ, be se bɛɛ baa, be bɛ Banaba mɔɔ Pɔɔ bɛ nuuŋ nsáŋ yisɛŋ yi shéŋ. ");
INSERT INTO asj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bɛniiŋ bani baa bɛniiŋ bɛ nyɛ yi yibe le nuuŋ be kwi kii nimɛ chi Taa wusɛŋ wu Jiso Krai. ");
INSERT INTO asj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tɛ se toŋ baa Judas bee Sila le be bɛ be tee beŋ bɛ kimfimɛ tɛ, fiee fi nuuŋ lɛ Kiŋwaati kini. ");
INSERT INTO asj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bee bɛ Fiana yi Waaŋ tɛ ŋɛŋ baa le fi mɛɛŋ dzɔɔŋ kɛ le tɛ yikɛ beŋ bɛ bɛntɛ bamu, yɛki bɛnchi bɛ shaaŋ bani bɛ nuuŋ le: ");
INSERT INTO asj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kiiŋ nɛ ni nɛ jii biee bijɛ bi bɛ fɛ bɛntaanchɛ lu li bɛnyɔ-ɔ kɛ. Kiiŋ nɛ ni nɛ jii ŋgɔŋ mɛ nyaŋ kɛ. Kiiŋ nɛ ni nɛ jii nyaŋ yi bɛ mɛɛŋ ki sɛɛ kɛ le ŋgɔŋ bo kɛ. Kiiŋ nɛ ni nɛ kɛmi fiee fi fɛrɛ bɛ bukwɛɛ kɛ. Ɛ nɛ kifi biee bini, kɛ nɛ fɛ baa bujɔŋ. Bɛ shɛ baa.” ");
INSERT INTO asj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Le be tsɛɛ lɛ, be se toŋ bɛniiŋ baa bɛ ki be bɔɔ bɛ ki Antiɔk. Be gɛɛŋ be konchɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ fe kichu, be nyɛ Kiŋwaati kilu li bee. ");
INSERT INTO asj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Be teeŋ Kiŋwaati kilu, ntoŋ wulu deeni shéŋ yibe, be woo bujɔŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Se Judas bee Sila bɛ tɛ̀ nuuŋ bɛniiŋ bɛ tiiti biee bi be wuki Nyɔ tiiti, nyɛ ntifi ŋge li bɛniiŋ bɛ kimbeenchɛ-ɛ, fi fɛ be se kɛmɛ buŋga li shéŋ yibe. ");
INSERT INTO asj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Be se ŋɔɔnɛ be tsi le. Bɛniiŋ bɛ kimbeenchɛ-ɛ dza be chinɛ be, be kaari bɛ mbɛɛŋgii be tuu lijiŋ lɛ bɛniiŋ bɛ tɛ̀ toŋ bee. ");
INSERT INTO asj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔɔ bee Banaba tɛ̀ bɔsɛyi be tsi Antiɔk weseeŋ, bee bɛniiŋ bamu be fenjisi be tiiti jɛ yi Taa. ");
INSERT INTO asj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Le mfi tuu kiiŋgi, Pɔɔ tee li Banaba le, “Tɛɛ wɛ tɛ kaari tɛ to lijiŋ tɛ dɛndɛ li bintsii bi tɛ tɛ̀ fenjisi jɛ yi Taa li bi biɛɛ, tɛ ŋɛŋ laa bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ le ge niŋ le.” ");
INSERT INTO asj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba tuu wɛki le dzɔɔ Jɔɔŋ Mak le ni deŋgi bee be. ");
INSERT INTO asj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Se nuuŋ le, Pɔɔ tɛ̀ kɔŋgisi yɛ le be dzɔɔ wu kɛ, kifɛ tɛ̀ shɛ be Pamfila, ba ki mɛɛshi kɛ ndɛndɛ wu bee be tɛ̀ kɛmi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pɔɔ bee Banaba se shi bɛ bisɛɛninɛ bi tɛɛmi, be se gatɛ. Banaba dzɔ Mak be lɛ lɛ yih yi li dzɔɔ li, be gɛɛŋ Saaplu ");
INSERT INTO asj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔɔ se tsaa fiee nuuŋ Sila. Le be ni be dzɛti, bɛniiŋ bɛ kimbeenchɛ-ɛ nyɛ be li tsaŋ yi mfiɛ wu Taa li. ");
INSERT INTO asj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Be se gɛɛŋ dze bimbɛ bi Silia bɛ bi Silisha, be deŋgi be kaŋgisi shéŋ yi bintutu bi bɛniiŋ bɛ kimbeenchɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔ dɛndɛ gɛɛŋ bo li kitoŋ ki Dɛlbi, dza gɛɛŋ lɛ Listra. Wi wu kintutu ki Jiso-o wumu tɛ nuuŋ Listra wulu bukooŋ bwee nuuŋ le Timɔti, ni tɛ̀ nuuŋ wi wu Juu, nuuŋ tɛ̀ wi wu kimbeenchɛ, bɛdɛɛni tee tɛ nuuŋ wi wu Grik. ");
INSERT INTO asj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timɔti wuni tɛ̀ nuuŋ wi wu bɛniiŋ bɛ kimbeenchɛ-ɛ bɛchu bɛ Listra mɔɔ bɛ Ikonyɔŋ tɛ̀ piɛti wu. ");
INSERT INTO asj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔ gii wɛki le dzɔɔ wu bee wu ni be deŋgi, biee sɛɛ wu dzoo. Tɛ̀ sɛɛ wu dzoo lɛ, kifɛ Bɛjuu bɛchu bɛ tɛ̀ tsiiŋ bimbe bilu tɛ kii le te Timɔti tɛ̀ nuuŋ wi wu Grik. ");
INSERT INTO asj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Be se deŋgi be giiŋgi li bito-oŋ, be giiŋgi be tiiti bɛniiŋ bɛ kimbeenchɛ-ɛ bɛnchi bɛ bɔɔŋ bɛ nto-oŋ bɛ Jiso-o mɔɔ bɛkaaŋ bɛ lɛkɛ li Nyɔ-ɔ bɛ Jɛrosalɛŋ tɛ̀ gɛɛ le be ni be biki. ");
INSERT INTO asj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Se nuuŋ le, se bintaashɛ bi bɛniiŋ bɛ kimbeenchɛ-ɛ bilu se tɛɛmi bi giiŋgi limfwe limfwe bɛ mbeenchɛ. Bɛniiŋ se tɛɛti li bee jo chichi. ");
INSERT INTO asj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔɔ bee kintutu kee dza le be gɛɛŋ be feenji jɛ yi Nyɔ li kwɛɛŋ wu Eesha, Fiana yi Waaŋ faaŋ. Se be dza be ka nuuŋ dze yi kimbɛ ki Flija bɛ ki Galashaŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Le be gɛɛŋ be bo li kwɛɛŋ wu Misa lichiŋ be tɛ̀ wɛki le be lɛ be gɛɛŋ kimbɛ ki Bitina, Fiana yi Jiso tuu yi faaŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Se nuuŋ le, be se ka kwɛɛŋ wu Misa, be dansɛ be gɛɛŋ li kitoŋ ki Towa-a. ");
INSERT INTO asj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Le ni nuuŋ butuu, fiee fimu si kifiee dza fi bɛ lɛ Pɔɔ li. Ŋɛŋ lɛ fiee filu wi wumu wu Masadonya lemi lɛki wu le, “Mintemii, lenchi ɔ bɛ Masadonya fɛni ɔ fi bee.” ");
INSERT INTO asj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Si fiee filu tɛ̀ bɛ lɛ Pɔɔ li lɛ, tɛ se ŋɛŋ le Nyɔ doonchɛ yɛ bee le tɛ gɛɛŋ tɛ ni tɛ fenjisi ntoŋ we wu dzeeŋ li kwɛɛŋ wu Masadonya. Mfwaa mumkpaŋ, tɛ se nachɛ ŋgɛnu le. ");
INSERT INTO asj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tɛ dza Towa, tɛ lenchi tsaaŋ lɛ yih yi li dzɔɔ li, tɛ busɛ Samotɛ. Le bu woo tɛ gɛɛŋ limfwe tɛ bo Niapoli. ");
INSERT INTO asj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tɛ dza fe tɛ dɛndɛ tɛ gɛɛŋ Filipi, wu nuuŋ kitoŋ ki li kimbɛ ki ŋkosi ki Masadonyaa. Kitoŋ kilu tɛ̀ nuuŋ ki bara wu Lo-om. Se tɛ tsi fe li jo. ");
INSERT INTO asj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Le ni nuuŋ jobɛ chi bɛshiinshi, tɛ bo li kitoŋ kilu-u tɛ gɛɛŋ li ŋgemɛ yi dzɔɔ li fɛ tɛ tɛ̀ seki le ɛ kintsii ki Bɛjuu lɛ ki be lɛki li Nyɔ-ɔ nuuŋ. Le tɛ gɛɛŋ, nuuŋ ɛ bukɛɛŋ bamu tɛ̀ banchɛ fe kituŋ, tɛ se tɛ̀ shee fe tɛ yeti li bee. ");
INSERT INTO asj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kwɛɛŋ wumu tɛ̀ nuuŋ fe yiki tɛ, bukooŋ bwee nuuŋ le Liija, tɛ̀ shiiŋ guundi Nyɔ. Tɛ bo lɛ kitoŋ ki Tayatira-a, tɛ̀ shiiŋ kabini ndú yimi, yi nuuŋ kɛɛ yi yɛchi lɔ, yi tɛɛmi kwa. Taa gwiyɛ shéŋ yee, beŋ fiee fi Pɔɔ tɛ̀ tiiti. ");
INSERT INTO asj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bɛ lii wu bee bɛniiŋ bɛ li wu yih li dzɔɔ, se lɛkɛ bee tee le, “Mintemii yɛɛŋ, ɛ nɛ ŋɛŋ le mi ŋgɛɛɔ shéŋ yɛŋ chi li Taa li, bɛ yɛɛŋ tɛ gɛɛŋ tɛ tsi li mi yih.” Le ba ni lɛki lɛ, tɛ dza tɛ beŋ tɛ gɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tɛ̀ nuuŋ jobɛ chimu tɛ giiŋgi fɛ kintsii ki nlɛkɛ li Nyɔ-ɔ, tɛ bikɛ bɛ ŋwaakwɛɛŋ wumu wu tɛ̀ nuuŋ mfwa. Tɛ̀ gii kɛmi fiana yimi li wu bwiiŋ, yi ti feti wi nuuŋ wi yɛɛŋ. Bɛniiŋ bɛ tɛ̀ kɛmi ŋwaakwɛɛŋ wulu tɛ̀ banchi kwa kii wu ŋge, kifɛ tɛ̀ gii tiiti biee bi nuuŋ bi ka. ");
INSERT INTO asj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Le ŋwaakwɛɛŋ wulu tuu ŋɛŋ tɛɛ Pɔɔ, se biki bee dzɛŋgi, tiiti le, “Bɛniiŋ bani nuuŋ bɛniiŋ bɛ nimɛ chi Nyɔ yi nuuŋ Kikoo ki Biee Bichu-u, be doonchi dze yi nuuŋ nɛ ka lɛ yi se nɛ bo.” ");
INSERT INTO asj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tɛ̀ fɛ lɛ li jo ŋge, fi dza fi tɔŋ Pɔɔ, fiiki yi waŋ fiana yi tii yilu, tee le, “Ntiitɔɔ li wɛ li bukooŋ bu Jiso Krai, bochɛ li ŋwaŋ wuni.” Yi se bo li wu bwiŋ mfi wulu. ");
INSERT INTO asj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bɛniiŋ bɛ tɛ̀ kɛmi mfwa wulu ŋɛŋ le dze yibe yi kwa ma yɛ, be kɔɔ Pɔɔ bee Sila be chee be, be gɛɛŋ bɛ be limfwe li bɛte kwɛɛŋ li fɛ waaŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Le be gɛɛŋ bɛ be, be leeki be limfwe li bara wu Lo-om wu tɛ̀ sɛki bɛnsa, be tee le, “Bɛniiŋ bani ɛ Bɛjuu, be nyɛɛ baa ŋgɛ li kitoŋ kisɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Be tiifi bɛniiŋ ntsɛ wu nchi wu tɛɛbeŋ mɛɛŋ ki beŋ kɛ. Tɛ̀ nuuŋ bɛniiŋ bɛ Lom, ɛ bɛ nyɛ tɛ tɛ̀ biee ntsɛ wulu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kintutu ki bɛniiŋ lɛ ki tɛ̀ nuuŋ fe biee ki fɛfi be, be we li Pɔɔ bee Sila-a. Bɛniiŋ bɛ tɛ̀ sɛki bɛnsa baa se gaamɛ ndú yi Pɔɔ bee Sila, be tee le bɛ fiaaŋ be. ");
INSERT INTO asj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bɛ bɔsɛyi bɛ fiaamfiɛ be ŋge, bɛ dzɔ be bɛ gɛɛŋ bɛ bɛŋɛ li yih yi ncha-a, be tee li wi wu tɛ̀ kiichi yih yi ncha wɛ le ni kiichi be bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Le woo lɛ, se dzɔ be gɛɛŋ bɛŋɛ lɛ loŋ wu lɛnti li yih yi ncha-a ta be bikaa li mfaŋgɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Le ni nuuŋ si butuu kintikinti, Pɔɔ bee Sila lɛki li Nyɔ-ɔ be yuuti juuŋ yi mpiaru be yɔɔnchi Nyɔ, bɛniiŋ bɛ ncha-a bamu yiki, ");
INSERT INTO asj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","nshɛ dza yi taa yi sɛɛsɛ bɛ buŋga, yih yi ncha yilu sɛɛsɛ gɛɛŋ bo li kimfoo li. Mfwaa mumkpaŋ, bigoo bichu gwiyɛ, bɛncha fanchɛ li bɛniiŋ bɛ ncha-a bɛchu. ");
INSERT INTO asj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Le wi wu tɛ̀ kiichi yih yi ncha yilu kaaŋgi, le bichi lɔ, ŋɛŋ si bigoo nuuŋ mkpeeŋ, se beechɛ le bɛniiŋ bɛ ncha-a kifi baa. Se buu nyɔ lɛ mbwa li le wo yi yee lu. ");
INSERT INTO asj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɔɔ se waŋ lɛwe, tee le, “Kiiŋ ɔ ni wo yi ya kɛ. Tɛ baa fɛni bee bɛchu.” ");
INSERT INTO asj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Wi wu tɛ̀ kiichi yih yi ncha wulu teeŋ le wi bɛ wu bɛ wi, letɛ lɛ li yih, gɛɛŋ toŋ núŋ limfwe li Pɔɔ bee Sila kɛɛti bɛ chɛnɛ. ");
INSERT INTO asj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Se dza dzɔ be, bo bɛ be lɛkuuŋ, bii li bee laa, “Bɛtaa, ŋgii ŋgeeŋ nse mbo.” ");
INSERT INTO asj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Be se tuu li wu-u le, “Gɛɛ shéŋ ya li Taa Jiso, nɛɛ bɛniiŋ bɛ li wɛɛ yih se nɛ tuu nɛ bo.” ");
INSERT INTO asj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Be tee ntoŋ wu kii Taa li wu bɛ bɛniiŋ bɛ li wu yih bɛchu. ");
INSERT INTO asj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Se dzɔ be butuu bulu, tsootsɛ bibaa bi bee. Mfwaa mumkpaŋ, be se lii wu bɛ bɛniiŋ bɛchu bɛ li wuu yih li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Se dzɔ be, bee be yɛɛ li wu-u yih, nyɛ be biee bijɛ be ji. Wu bee bɛniiŋ bɛchu bɛ li wu-u yih se be nɛɛtɛ le be gɛɛ baa shéŋ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Butuu bo bu woo, bara wu Lom wɛ wu tɛ̀ sɛki bɛnsa toŋ bɛniiŋ bɛ nchi-i le be gɛɛŋ be tee li wi wu kiichi yih yi ncha-a wɛ le buu bɛniiŋ baa le be ni be giiŋgi. ");
INSERT INTO asj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Se wi wu tɛ̀ kiichi yih yi ncha wulu biee gɛɛŋ ŋɛŋ Pɔɔ, tee li wu-u le, “Bara tuumɔɔ ntoŋ le mbuu beŋ, gɛnɛ yɛɛŋ bɛ mbɛɛŋgii.” ");
INSERT INTO asj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Se nuuŋ le, Pɔɔ tɛ tee li bɛniiŋ bɛ nchi-i baa le, “Bɛ tuu be fiaamfiɛ bee fɛ waaŋ be mɛɛŋ saa ki saa kɛ bee kɛ, tɛ nuuŋ tɛ nuuŋ bɛniiŋ bɛ Lom, be tuu be bɛŋɛ bee li yih, be se kweŋgi baa dɛɛni le bɛ buu bee lɛjiŋ lɛjiŋ ni? Fi nuuŋ tɛ̀ ka lɛ kɛ. Ɛ nɛɛ bara wulu wu gii bɛ fɛni se buu bee.” ");
INSERT INTO asj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bɛniiŋ bɛ nchi-i baa se kaari be to lijiŋ be tee li bara wu Lom wɛɛ fiee fi Pɔɔ tee. Le be woo le Pɔɔ bee Sila nuuŋ tɛ bɛniiŋ bɛ Lom, be se chɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Be se bɛ be sooŋ bɔ li bee, be buu be li yih yi ncha-a, be chinɛ be, be lɛkɛ be le be dza fɛ kitoŋ kilu. ");
INSERT INTO asj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔɔ bee Sila bo li yih yi ncha-a, be gɛɛŋ li Liija yi, ɛ bɛniiŋ bɛ kimbeenchɛ-ɛ tɛ nuuŋ lu, be tifi be, be se dza fe. ");
INSERT INTO asj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔɔ bee Sila se dza ŋgɛnu, be ka Amfipoli bɛ Apolona, be dansɛ be gɛɛŋ be bo Tɛsalonya. Yih yi nlɛkɛ li Nyɔ-ɔ yi Bɛjuu tɛ nuuŋ fe. ");
INSERT INTO asj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔɔ se gɛɛŋ lɛ li yih yi nlɛkɛ li Nyɔ-ɔ nɛɛ si ntsɛ we tɛ̀ shiiŋ nuuŋ, tɛ̀ bɛɛ yeti li bɛniiŋ lu, li jo yi bɛshiinshi taa, doonchi be fiee fichu fi nuuŋ lɛ Kiŋwaati ki Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tɛ̀ tiifi be, tɔchi le Kinsofu ki Nyɔ tɛ̀ kaachɛ tɛ̀ kɛmi le ki ŋɛŋ ŋgɛ ki kaari ki bo li kwe-e. Jiso wu ntiiti kii wu wuni nuuŋ kinsofu kilu. ");
INSERT INTO asj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Le bɛniiŋ bamu woo lɛ, be beŋ be taa li Pɔɔ bee Sila. Bɛgrik bamu bɛ tɛ̀ guundi Nyɔ mɔɔ bukɛɛŋ bɛ nɔŋa bɛ nɔŋa bamu beŋ tɛ ŋge. ");
INSERT INTO asj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Se nuuŋ le, Bɛjuu bamu se bɛchi be yɛɛti shéŋ bɛ Pɔɔ bee Sila, be konchɛ bɛniiŋ bamu bɛ tɛ̀ mbweŋgi fe yee, bee be banchɛ li kintutu, be bɛchi be fieŋgisi kitoŋ. Se be biee be dza be gɛɛŋ be bondɛ yih yi Jasɔŋ le be wɛki baa Pɔɔ bee Sila le bɛ buu be bɛ nyɛ li bɛniiŋ li lɛkuuŋ. ");
INSERT INTO asj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Le be gɔɔŋ nsiŋ, be se chee Jasɔŋ bɛ bɛniiŋ bɛ kimbeenchɛ-ɛ bamu be gɛɛŋ bɛ be limfwe li bɛte kito-oŋ, be dzɛŋgi be tiiti le, “Bɛniiŋ bani nuuŋ bɛ deŋgi be fikisi kwɛɛŋ wu tuu kimbasaje, be bɛ baa be bo fɛni, ");
INSERT INTO asj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasɔŋ fi be wu gɛɛ li wu-u yih. Be bɛchu bondini baa bɛnchi bɛ Mfɔŋ wu Lo-om, be kweŋgi le Mfɔŋ wumu wɛ lu bukooŋ bwee nuuŋ le Jiso.” ");
INSERT INTO asj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Le bɛte kitoŋ bee bɛniiŋ woo lɛ, be dza be wɛsɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Be se kunyɛ Jasɔŋ bɛ bɛniiŋ bɛ kimbeenchɛ-ɛ, be nyɛ kwa le ɛ fi ka fi nuuŋ lɛ, be tɛ̀ tuu kwa wulu li bee kɛ. Be se chinɛ li bee be ni be giiŋgi. ");
INSERT INTO asj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Butuu jiŋ, bɛniiŋ bɛ kimbeenchɛ-ɛ dzɔ Pɔɔ bee Sila be tuumi le be gɛɛŋ li kitoŋ ki Beria. Le be lɛ fe, be gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ yi Bɛjuu. ");
INSERT INTO asj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bɛjuu bɛ fe tɛ̀ nuuŋ bɛniiŋ bɛ kii biee be yɛki bɛ Tɛsalonya, kifɛ be tɛ̀ bɔsɛyi be fi ntiifɛ bɛ kiŋkɔŋgisɛ, be se tɛɛti Kiŋwaati ki Nyɔ-ɔ jo chichi le be ŋɛŋ laa biee bi Pɔɔ tiifi be bini nuuŋ bi chɛɛŋ le. ");
INSERT INTO asj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Be bɛ ŋge se beŋ jɛ yi Nyɔ. Bukɛɛŋ bɛ nɔŋa bɛ nɔŋa ŋge bɛ tɛ̀ nuuŋ Bɛgrik mɔɔ buniŋ ŋge bɛ tɛ̀ nuuŋ Bɛgrik beŋ tɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Se nuuŋ le, Bɛjuu bɛ Tɛsalonya tɛ̀ woo le Pɔɔ kɔɔ wu gɛɛŋ tiifi jɛ yi Nyɔ li kitoŋ ki Beria, be biee be gɛɛŋ tɛ le, be kunsɛ kintutu ki bɛniiŋ lɛ le ki bɛchi kpɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bɛniiŋ bɛ kimbeenchɛ-ɛ se toŋ Pɔɔ lɛ mfwaa mumkpaŋ gɛɛŋ li ŋgemɛ yi dzɔɔ yi nyɔŋa-a. Se nuuŋ le, Sila bee Timɔti shɛ Beria. ");
INSERT INTO asj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bɛniiŋ bɛ tɛ̀ giiŋgi le be chinɛ Pɔɔ baa be gɛɛŋ be bo Atɛŋ be biee be chinɛ wu. Be tuu lijiŋ, Pɔɔ toŋ be le be gɛɛŋ be tee li Sila bee Timɔti le be gwenɛ be biee wu tsɛkɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔɔ se tɛŋgi Sila bee Timɔti Atɛŋ. Le ni tuu deŋgi fe, ŋɛŋ ɛ kitoŋ kilu yisɛ bɛ bɛnyɔ. Fi se tɔnyɛ wu shéŋ. ");
INSERT INTO asj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Se tuu gɛɛŋ li yih yi nlɛkɛ li Nyɔ-ɔ yi Bɛjuu, yɔ bee be mɔɔ bɛniiŋ bɛ tɛ̀ nuuŋ yɛ Bɛjuu kɛ bɛ tɛ̀ lɛki tɛ li Nyɔ-ɔ fe. Tɛ̀ tuu yeti tɛ jo chichi fɛ waaŋ li bɛniiŋ bɛ tɛ̀ dza be bɛ fe. ");
INSERT INTO asj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bɛniiŋ bɛ ntiifɛ bamu bɛ bɛ tɛ̀ teenyi le Ɛpikoliaŋ mɔɔ bɛ be tɛ̀ teenyi le Sitoyik tɛ̀ dza be bɛ le be tɛchɛ biee bɛ Pɔɔ. Si Pɔɔ tɛ̀ tiifi kii Jiso mɔɔ mbochu li kwe-e, bamu se biiti laa, “Kibere kini fɛti kimfimɛ le la le?” Bamu se kweŋgi fi bee le, “Yeŋgɔɔ kɛɛ tiifɔɔ kii bɛnyɔ bɛ bɛniiŋ bamu.” ");
INSERT INTO asj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Se nuuŋ le, be tuu be dzɔ Pɔɔ bee be gɛɛŋ li kinshewu ki bɛ teenyi le Aleopagu, be tee li wuu le, “Tɛ wɛki baa le tɛ tuu tɛ woo kii ntiifɛ wu fwɛŋ wuni wɔɔ bɛɛ bɛ wu laa wu nuuŋ le la le. ");
INSERT INTO asj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ɔ tiitɔɔ biee bimu bi tɛ̀ ti mɛɛŋ saa ki woo kɛ. Se nuuŋ le, tɛ se wɛki baa le tɛ kɛɛ kinyi kilu.” ");
INSERT INTO asj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Bɛniiŋ bɛ Atɛŋ mɔɔ mfoŋ yi fe tɛ̀ shiiŋ fi bee le be ni be wuki nuuŋ biee bi fɛŋ, be se tiiti kii bi.) ");
INSERT INTO asj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔɔ se leŋ limfwe li kinshewu ki Aleopagu kilu, tee le, “Bɛniiŋ bɛ Atɛŋ, mi ŋɛŋgɔɔ lɛ dzé chichi le nɛ guundi baa bɛnyɔ ŋge. ");
INSERT INTO asj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ntiitɔɔ ni, kifɛ ntuu ndeŋgi li kitoŋ kinɛ-ɛ, mbichi li bintsii bi nɛ lɛki li bɛnyɔ-ɔ mi ŋɛŋ taantaa chi muntofi chimu ɛ bɛ tsɛɛ li chi le, ‘Li nyɔ yi bɛ kii yɛ kɛɛ.’ Nyɔ yilu yi nɛ lɛki, yi bɛ kii yɛ kɛ, ɛ yi yi ŋgii nlaŋɛ li beŋ dɛɛni. ");
INSERT INTO asj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nyɔ yilu yini nuuŋ yi tɛ̀ tɔŋ nshɛ yini bɛ biee bichu bi nuuŋ lu. Ɛ yi Mfɔŋ wu kiboo bɛ nshɛ, yi ti tsiiŋ yɛ li yí yi muntofi yi bɛniiŋ gwaŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yi fuki yɛ fiee fimu fi yi wɛki yi bichi le wi niŋ li yi kɛ, kifɛ ɛ yi yi feti bɛniiŋ bɛchu be se yindini, be nuuŋ lu, be kɛmi fiee fichu fi be wɛki. ");
INSERT INTO asj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Yi tɛ̀ fɛ bini bi bɛniiŋ lɛ bichuchu bi bo li wi mumkpaŋ bi nuuŋ li kikoo ki nshɛ-ɛ. Fɛ yi tɛ̀ feti lɛ, yi saa yi nachɛ mfi wu bɛ gii bɛ ni bɛ nuuŋ lu, mɔɔ dii yi bintsii bi bɛ gii bɛ ni bɛ tsiiŋ. ");
INSERT INTO asj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yi tɛ̀ fɛ lɛ, le bɛniiŋ ni be tɛɛti, be wɛki yi laa be gii naa be ŋɛŋ yi le. Se nuuŋ le, Nyɔ nuuŋ yɛ mɔɔ mfiiŋ li wusɛŋ wumu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Fini fiɛɛ nɛɛ si wumu tɛ̀ kɔɔ wu tee le, ‘Ɛ yi yi feti se tɛɛbeŋ tɛ̀ tsiiŋ, tɛ deŋgi, tɛ̀ tuu tɛ nuuŋ si tɛ nuuŋ lɛ.’ Si wi wunɛ wu kimfɛ wumu tɛ̀ kweeŋ tɛ le, ‘Ɛ bee bɔɔŋ bee kibɛɛ’. ");
INSERT INTO asj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Si tɛɛbeŋ nuuŋ bɔɔŋ bɛ Nyɔ-ɔ, kiiŋ tɛ ni tɛ beechi le Nyɔ bosini fiee fi wi nachɛ bɛ bufii bwee kɛ, kɛ le wu tɔŋ bɛ kitu ki kwa-a, kɛ le bɛ nachɛ bɛ ta kɛ. ");
INSERT INTO asj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gii nuuŋ li mfi wu bɛniiŋ tɛ̀ mɛɛŋ li kijibɛ-ɛ, be feti biee bibifi bini, Nyɔ bichi nɛɛ shiiŋ. Se nuuŋ le, dɛɛni yi tiiti yɛ le bɛniiŋ bɛchu fiiki shéŋ yibe. ");
INSERT INTO asj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Be fiiki kifɛ yi gɛɛ yɛ jobɛ chi yi gii naa yi saa kwɛɛŋ kwikwi yi ni yi biki chɛɛŋ wulu. Yi tsaa yɛ wi we kituŋ wu gii ni sɛki. Fini nuuŋ fi yi kɔɔ yi doonchɛ li bɛniiŋ bɛchu le ɛ chɛɛŋ si tɛ̀ buu wi wulu li kwe-e”. ");
INSERT INTO asj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Si Pɔɔ tɛ̀ kweeŋ lɛ, be woo si wu tee kii mbochu li kwe-e, bɛniiŋ bamu dza be kiiti wu bukefu. Bamu tee fi bee le, “Tɛ wɛki baa le tɛ tuu tɛ woo kii fiee fiɔɔ tiiti fini.” ");
INSERT INTO asj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Se nuuŋ le, Pɔɔ se dza shɛ be. ");
INSERT INTO asj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bɛdɛɛni, bɛniiŋ bamu bɛ tɛ̀ beŋ fiee fi tiiti, be biee wu. Wumu li bee tɛ̀ nuuŋ Dionisu wu tɛ̀ nuuŋ wi kinshewu ki Aleopagu, wumu nuuŋ kwɛɛŋ wu bukooŋ bwee tɛ̀ nuuŋ le Damali mɔɔ bɛniiŋ bamu tɛ. ");
INSERT INTO asj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lɛjiŋ lɛlu, Pɔɔ dza Atɛŋ gɛɛŋ li kitoŋ ki Kɔrɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Si tɛ̀ gɛɛŋ le, bee wi wu Juu wumu bikɛ bukooŋ bwee nuuŋ le Akwila ɛ bɛ tɛ̀ biɛ wu Pontu. Akwila bɛ Prisilia wu kwɛsi tɛ mɛɛŋ nɛɛ fɛ be dza Itali, kifɛ Klawdu wu Mfɔŋ wu Lom tɛ̀ buu nchi le Bɛjuu bɛchu bo le. Ɛ Pɔɔ tɛ̀ la ŋka lɛ bee, ");
INSERT INTO asj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tuu ŋɛŋ be nachi dzi yi bɛ yuumfi bigɔɔnu lu, ɛ tɛ̀ nuuŋ nɛɛ tɛ nimɛ chi wu wu Pɔɔ tɛ̀ tsiiŋ kii chi, tuu tsiiŋ bee be, bee be nindi. ");
INSERT INTO asj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ɛ nuuŋ jo yi bɛshiinshi chichi, giiŋgi li yih yi nlɛkɛ li Nyɔ-ɔ, tiifi Bɛjuu mɔɔ Bɛgrik lu, gwenini le fɛ le be beŋ fiee fi tɛ̀ tiifi. ");
INSERT INTO asj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila bee Timɔti se dza Masadonya be bɛ, Pɔɔ se dzɔ mfi we kwikwi tuu tiiti tɛ nuuŋ jɛ yi Nyɔ, doonchi li Bɛjuu li le Kinsofu ki Nyɔ tɛ̀ kaachɛ tɛ̀ nuuŋ Jiso. ");
INSERT INTO asj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Se nuuŋ le, Bɛjuu bɛlu tɛ̀ dza be tuu be fɛŋgi fiee fi tɛ̀ tiiti, be gaashi wu. Se sɛɛsɛ ndú yee tee li bee le, “Kwe yinɛ yɛ li tsaŋ yinɛ-ɛ. Ŋkɛmi yɛ tsaŋ fe kɛ. Mbɛɛchɛ li dɛɛni, ŋgii ni ŋgiiŋgi nuuŋ lɛ bɛniiŋ bɛ ti nuuŋ yɛ Bɛjuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Se shɛ be, bo gɛɛŋ tsiiŋ tɛ nuuŋ bee wi wumu wu tɛ̀ nuuŋ yɛ wi wu Juu kɛ, ɛ wi wulu tɛ̀ shiiŋ guundi Nyɔ. Bukooŋ bwee tɛ̀ nuuŋ le Tishu Justu, la we nuuŋ li yih yi nlɛkɛ li Nyɔ-ɔ lichiŋ. ");
INSERT INTO asj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispu wu te kikoo ki yih yi nlɛkɛ li Nyɔ-ɔ bɛ bɛniiŋ bɛchu bɛ li wu-u yih tɛ gɛɛ shéŋ li Taa li. Bɛniiŋ bɛ Kɔrɛŋ ŋge tuu be wuki si Pɔɔ tiiti kii Jiso, be beenchi, se tuu lisi be li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Le ni nuuŋ butuu bumu, Taa se yɔ li Pɔɔ li lɛ fiee fimu si kifiee li le, “Kiiŋ ɔ ni ɔ chɛndi kɛ, ɔ tiifi nɛɛ jɛ yɛŋ ɔ giiŋgi bɛ yi. Kiiŋ ɔ ni chikɛ kɛ, ");
INSERT INTO asj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kifɛ miɔ bɛ wɛ, wi nuuŋ yɛ lu wu nuuŋ fɛ fiee bɛ wɛ kɛ. Bɛniiŋ beŋ baa li kitoŋ kini ŋge.” ");
INSERT INTO asj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nɛɛ lɛ, Pɔɔ se tsi fe kiya kimbiri bɛ kiŋkɛ, tiifi bɛniiŋ jɛ yi Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Si Pɔɔ tɛ̀ nuuŋ le lɛ, le Galio ni nuuŋ wi wu sɛki kimbɛ ki Akeya, Bɛjuu banchɛ yi yibe be kɔɔ Pɔɔ be gɛɛŋ bɛ wu li yih yi nsa-a, ");
INSERT INTO asj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","be tee li Galio le, “Wi wuni gweninɔ le fiiki bɛniiŋ le be ni be lɛki li Nyɔ-ɔ lɛ dze yimi yi chichi yi nuuŋ yɛ si nchi wɛki kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔ dza le yɔ, Galio dza kweeŋ li Bɛjuu baa le, “Bɛjuu woo yɛŋ, bee le fiee fini ni fi nuuŋ fiee fi bifi fi wi wuni fɛ, mɔɔ nuuŋ nchi wumu wu wu bondɛ, kɛ bee mi ŋkaŋ shéŋ le n'yikɛ fiee fi nɛ tiiti. ");
INSERT INTO asj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Se nuuŋ le, si fiee fini fiɛɛ nɛɛ nuuŋ bitɛchinɛ kii jɛ́ bɛ bukooŋ mɔɔ bɛnchi bɛnɛ, nachɛ yɛŋ beŋ beŋ. Ɛ bɛ nyɛ ntɛ nsaa fini fiee kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Si wu kweeŋ lɛ, se kooŋ bɛ be be bo li yih yi nsa-a. ");
INSERT INTO asj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Se be bɛchu dza be lɛ li Sostɛne wu tɛ nuuŋ te kikoo ki yih yi nlɛkɛ li Nyɔ-ɔ, be too wu li yih yi nsa-a limfwe. Galio se ti mɛɛŋ ki kwi fiee fe kɛ. ");
INSERT INTO asj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Lɛjiŋ lɛlu, Pɔɔ se tuu tsi Kɔrɛŋ bee bɛniiŋ bɛ kimbeenchɛ-ɛ li jo ŋgee li, tuu dza shɛ be, se bee bɛ Prisilia mɔɔ Akwila lɛ lɛ yih yi li dzɔɔ le be gɛɛŋ Silia. Fɛ be tɛ̀ dzɛti Sɛŋkriya fɛ be tɛ̀ lɛ lɛ yih yi li dzɔɔ li, Pɔɔ mu kikoo kii chini wu tɛ̀ gɛɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Le be ni be giiŋgi, be buti Ɛfishɛŋ, Pɔɔ shɛ Prisilia bee Akwila fe, gɛɛŋ fiee nuuŋ li yih yi nlɛkɛ li Nyɔ-ɔ yi Bɛjuu li, yɔ li Bɛjuu li lu. ");
INSERT INTO asj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Be lɛkɛ le tuu tsi bɛ be jo ŋge, faaŋ. ");
INSERT INTO asj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Se nuuŋ le, le ni dzɛti, tee li bee le, “Ŋgii ŋkaari mbɛ lɛ beŋ fɛ Nyɔ fi.” Le tee lɛ, se lɛ lɛ yih yi li dzɔɔ li dza Ɛfishɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Le yih yi li dzɔɔ gɛɛŋ bo Kasaria, Pɔɔ bo, yɛɛ gɛɛŋ yɛsi kintaashɛ ki bɛniiŋ bɛ kimbeenchɛ-ɛ Jɛrosalɛŋ se dza bɔɔ Antiɔk. ");
INSERT INTO asj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tsi fe, mfi kiiŋgi, kaari dza deŋgi kɛti li bimbe bi Galashaŋ bɛ Flija, kaŋgisi shéŋ yi bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ le. ");
INSERT INTO asj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Wi wu Juu wumu tɛ̀ dza bɛ Ɛfishɛŋ bukooŋ bwee nuuŋ le Apolo, bɛ tɛ̀ biɛ wu Alɛkɛsanda. Tɛ̀ nuuŋ wi wu tɛ̀ kii n'yɔru, kii tɛ Kiŋwaati ki Nyɔ-ɔ bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bɛ tɛ̀ tifi wu bɛ Dze yi Taa tiifi, se yuusi bɛ ntiifɛ kii Jiso, tiifi bɛniiŋ tsaaŋ. Se nuuŋ le, tɛ kii nɛɛ nuuŋ fiee fi Jɔɔŋ tɛ̀ tiiti lisi bɛniiŋ li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Si tɛ̀ bɛ Ɛfishɛŋ, bɛchi tiifi bɛniiŋ li yih yi nlɛkɛ li Nyɔ-ɔ nchɛnu siŋ. Prisilia bee Akwila woo si tiifi lɛ, be se dzɔ wu, be gɛɛŋ be naanyɛ li wuu bujɔŋ si Dze yi Nyɔ doonchi. ");
INSERT INTO asj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo dza beechɛ le gii lenchi gɛɛŋ kimbɛ ki Akeya. Bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Ɛfishɛŋ se fi wu, be tsɛɛ Kiŋwaati li kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Akeya be lɛki le ke wu fɛsi be fi wu. Gɛɛŋ bo fe, fi bɛniiŋ bɛ kimbeenchɛ-ɛ bujɔŋ, bɛniiŋ bani nuuŋ bɛ Nyɔ tɛ̀ doonchɛ shéŋ yi dzeeŋ li bee yi fɛ be gɛɛ shéŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tɛ̀ tɛchini bɛ Bɛjuu yeti li bee gbanaa, nuuŋ yɛ bitɛchinɛ bi didi kɛ, yɛki be, doonchi be lɛ Kiŋwaati ki Nyɔ-ɔ le Jiso nuuŋ kinsofu ki Nyɔ tɛ̀ kaachɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tɛ̀ nuuŋ mfi wu Apolo tɛ̀ nuuŋ Kɔrɛŋ, Pɔɔ tɛ̀ dzɔ dze yi lɛnti lɛnti lɛ bimbe bi tɛ̀ deŋgi le-e, fɛsi Ɛfishɛŋ. Le fɛsi fe, ŋɛŋ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bamu, ");
INSERT INTO asj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","bii li bee laa, “Fiana yi Waaŋ tɛ̀ bɛ li be-eŋ mfi wu nɛ tɛ̀ gɛɛ shéŋ li Jiso-o ni?” Be tuu le, “Tɛ mɛɛŋ baa saa ki woo kɛ le fiee fimu nuuŋ le Fiana yi Waaŋ li kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔɔ bii laa, “Ɛ fi nuuŋ lɛ, bɛ se tɛ̀ lii beŋ li dzɔɔ kii la?” Be se tuu le, “Bɛ tɛ̀ lii bee li dzɔɔ biki si Jɔɔŋ tɛ̀ tiiti.” ");
INSERT INTO asj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔɔ se tee li bee le, “Jɔɔŋ tɛ̀ lisi bɛniiŋ li dzɔɔ, le fi doonchɛ le be fiiki baa shéŋ yibe, tɛ̀ tiiti le be beŋ nuuŋ li wi wu bɛɛ lɛ wuu jiŋ wi wu tɛ̀ tiiti ki wu wulu tɛ̀ nuuŋ Jiso.” ");
INSERT INTO asj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bɛniiŋ bɛlu woo si Pɔɔ tee lɛ, bɛ se lii be li dzɔɔ nuuŋ li bukooŋ bu Taa Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔɔ gɛɛ tsaŋ li bee, Fiana yi Waaŋ se bɛ li bee. Be se dza be yeti jɛ́ yibe tɛ̀ kii yɛ kɛ, be tuu be tiiti li bɛniiŋ li biee bi be wuki Nyɔ tiiti. ");
INSERT INTO asj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bɛniiŋ bɛlu tɛ̀ nuuŋ wi si yoofi ntsɔ bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔɔ nuuŋ nɛɛ Ɛfishɛŋ, giiŋgi li yih yi nlɛkɛ li Nyɔ-ɔ, li kii tɛɛ li, yeti li bɛniiŋ li lu nchɛnu nsiŋ. Bee be tɛchini biee, gwenini le fɛ le be beŋ fiee fi tiiti kii bumfɔŋ bu Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bɛniiŋ bamu se tɛmi bikoo be faaŋ mbeenchɛ, be se yeti jɛ́ yi bifi lɛ bɛniiŋ lii kii Dze yi Taa. Pɔɔ se shɛ be, dzɔ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, bee be gɛɛŋ nuuŋ li yih yi nlaanchɛ yi Tiranu-u, se yeti li bee lu jo chi. ");
INSERT INTO asj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pɔɔ tɛ̀ fɛ lɛ li biya bifɛ. Se nuuŋ le, Bɛjuu mɔɔ Bɛgrik bɛchu bɛ li kwɛɛŋ wu Eesha wulu se woo jɛ yi Taa. ");
INSERT INTO asj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pɔɔ tɛ̀ nuuŋ, ɛ Nyɔ feti wu le ni feti bintɛwa bi biee lɛ, nuuŋ biee bi wondini bimfimu. ");
INSERT INTO asj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Be tɛ̀ dzeti nɛɛ mɔɔ nuuŋ fiee fiee fi li wu-u bwiŋ si fi nshɛŋgɛ fi ndu-u, mɔɔ nuuŋ ndu ye yi nimɛ, ɛ be gɛɛŋ be koŋ wi wu chigɔŋ lu, mwɛ se tɛmi, ɛ nuuŋ wi wu kɛmi Fiana yi tii li wu-u bwiŋ, yi bo. ");
INSERT INTO asj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bɛjuu bamu bɛ tɛ̀ shiiŋ be deŋgi be busi mfíee yi bifi li bɛniiŋ li, be tuu be dza be gwenini nteenyɛ bukooŋ bu Taa Jiso-o li mbusu fiana yilu-u. Ɛ wi dza tuu tee li Fiana yi tii le, “Mbusɔɔ wɛ li bukooŋ bu Jiso wu Pɔɔ tiiti.” ");
INSERT INTO asj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bɛniiŋ bɛ tɛ̀ mɔnchi fiee filu tɛ̀ nuuŋ mfomɛnyaaŋ, be tɛ̀ nuuŋ bɔɔŋ bɛ Skɛfa wu kikoo ki bɛte muntofi ki Bɛjuu lɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Fiana yi bifi dza yi bii li bee laa, “Ŋkii Jiso, ŋkii tɛ̀ Pɔɔ, ɛ beŋ baŋ?” ");
INSERT INTO asj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wi wu Fiana yi tii yilu tɛ nuuŋ li wu-u bwiŋ se jiiŋ we li bɛniiŋ bɛlu-u, gɔɔri be fɛkwiiŋ, be ta ŋgwɛti be bo li yih yi wi wulu-u, tiŋ bilɛlu bɛ bibaa bwiŋ kichu. ");
INSERT INTO asj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bɛjuu bɛ Bɛgrik bɛchu bɛ tɛ̀ tsiiŋ Ɛfishɛŋ woo kii fiee filu, be chɛŋ. Bɛniiŋ se guundi bukooŋ bu Taa Jiso-o be giiŋgi limfwe. ");
INSERT INTO asj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bɛniiŋ ŋge bɛ tɛ̀ saa be nuuŋ bɛniiŋ bɛ kimbeenchɛ-ɛ tɛ̀ bɛɛ be tiiti biee be tɔchi mɔɔ biee bi li kijibɛ-ɛ bi be tɛ̀ feti. ");
INSERT INTO asj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bamu ŋge bɛ tɛ̀ feti mfiŋ, banchɛ biŋwaati bi bee bi mfiŋ, be bɛ bɛ bi, bɛ tɔŋ lɛ bɛniiŋ lii. Be fa kwa wu biŋwaati bilu kwikwi, wu bo munini mu ncherere bɛnchuki mbaanshiŋ (50,000). ");
INSERT INTO asj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Se nuuŋ le, biee bini fɛ le jɛ yi Taa lɛ li shéŋ yi bɛniiŋ li bɛ buŋga, yi saaŋgɛ yi gɛɛŋ limfwe limfwe. ");
INSERT INTO asj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Le ni tuu nuuŋ lɛjiŋ lɛlu, Pɔɔ ŋɛŋ le gii gɛɛŋ Jɛrosalɛŋ le ɛ giiŋgi lɔɔ, ka dze bimbe bi Masadonya bɛ Akeya. Tɛ̀ tuu tiiti le, “Ŋgiiŋgɔɔ ke mi ŋgɛɛŋ mi mbo Jɛrosalɛŋ nni ŋkɛmi tɛ le ŋgɛɛŋ mbo Lom.” ");
INSERT INTO asj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Se tuu saa toŋ bɛniiŋ bɛfɛ, Timɔti bee Ɛrastu bɛ tɛ̀ fii wu, be gɛɛŋ limfwe Masadonya. Se shɛ tuu tsi Eesha niiŋ. ");
INSERT INTO asj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Le ni nuuŋ nɛɛ li mfi wulu, kpɛ dza bɛchi Ɛfishɛŋ kii Dze yi Taa nuuŋ yɛ wu didi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wi wu tendi gwɛ wumu tɛ̀ nuuŋ fe, bukooŋ bwee nuuŋ le Dɛmɛtrus, tɛ̀ shiiŋ tendi biee bi bosini yih yi muntofi yi nyɔ yi bɛ teenyi le Atɛmi. Nimɛ chini tɛ̀ shiiŋ chi bɛɛ bɛ kwa li li bɛniiŋ bɛ tendi gwɛ-ɛ nuuŋ yɛ wu didi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dɛmɛtrus se biee konchɛ bɛniiŋ bɛ tɛ̀ tendi gwɛ bɛchu mɔɔ bɛniiŋ bɛ ti nindi ŋwaani chini nimɛ, be taashɛ. Se tee li bee le, “Bɛŋwaanɛŋ, nɛ kɛɛ le nimɛ chini tɛ ŋɛti baa kwa li chi-i ŋge. ");
INSERT INTO asj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nɛ ŋiŋgi baa nɛ tuu nɛ wuki fiee fi fibwɛɛ fi Pɔɔ fini feti. Deŋgɔɔ tiiti le bɛnyɔ bɛ bɛ feti bɛ tsaŋ ti nuuŋ yɛ bɛ nyɔ kɛ. Wu fɛɔ lɛ, wu fiiki bufii bu bɛniiŋ lɛ fɛni Ɛfishɛŋ ŋge, se tusɔɔ fikisi bu bɛniiŋ bɛ Eesha bɛchu be beenchi li wu-u. ");
INSERT INTO asj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ŋiŋgɔɔ le nimɛ chi sɛŋ chini gii chi kɛmɛ bukooŋ bu bifi. Se tɛ ba lɛ kwaa siŋ, yih yi muntofi yi nyɔ yi nyɔŋa yi chɛɛŋ yi Atɛmi gii yi to fiee fi yee. Ɛ fi ka lɛ, kɛ bɛ nyɛ baa buya li nyɔ yi nyɔŋa yi bɛ bundi Eesha kwikwi, kikoo ki nshɛ kichu bundi tɛ yi.” ");
INSERT INTO asj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Si bɛniiŋ bɛlu tɛ̀ woo lɛ, shéŋ tɔŋ be. Be bɛchi be dzɛŋgi, be tiiti le, “Atɛmi wu Ɛfishɛŋ nuuŋ nyɔ yi nyɔŋa.” ");
INSERT INTO asj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kitoŋ kilu kichu se saaŋgɛ. Kimbanchɛ ki bɛniiŋ lɛ ki tɛ̀ taashɛ ki se lɛ li yih yi Gayɔŋ bɛ yi Aristaku, ɛ tɛ̀ nuuŋ bɛniiŋ bɛ Masadonya bɛ tɛ̀ deŋgi bee bɛ Pɔɔ, be chee be, be gɛɛŋ bɛ be li yih yi bɛ ti kɛmi nshewu fe bɛ feti mɔɔ sɔɔŋ fe. ");
INSERT INTO asj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔɔ wɛki le lɛ gɛɛŋ limfwe li kintutu kilu, bɛniiŋ bɛ kimbeenchɛ-ɛ faaŋ. ");
INSERT INTO asj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bɛniiŋ bamu bɛ nɔŋa bɛ nɔŋa bɛ fe bɛ kɛmi kwɛɛŋ bɛ tɛ̀ nuuŋ nsáŋ yee, be tuu be tuumi ntoŋ li wuu, be sooŋ bɔ le kiiŋ ni mɔŋ tɔmi kikaa lu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kintutu ki tɛ̀ banchɛ fe kɛɛ se dza ki lakɛ. Bani dzɛŋgi fini fiee, baa dzɛŋgi fiɛɛ fiee. Bɛniiŋ ŋge tɛ̀ mɛɛŋ mɔɔ kikɛɛ kɛ fiee fi bɛ tɛ̀ banchɛ fe kii fi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bɛjuu se dzɔ Alɛkɛsanda be bɛ bɛ wu li kintutu ki bɛniiŋ lɛ limfwe, bɛniiŋ bamu ŋɛŋ be se beechi le kiiɔ fiee fe. Se tuu chiti bɛniiŋ bɛ kibɛnɛ le ku bɛ kimfimɛ kee. ");
INSERT INTO asj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bɛniiŋ bɛlu kɛɛ le Alɛkɛsanda nuuŋ wi wu Juu, be tuu be mɛɛshi be dzɛŋgi be giiŋgi limfwe jɛ mumkpaŋ, be tiiti le, “Atɛmi wu Ɛfishɛŋ nuuŋ nyɔ yi nyɔŋa.” Be tɛ̀ waŋ lɛ, gɛɛŋ bo bɛntaŋ bɛ mfi bɛfɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Le wi wu ntsɛwu wu fɛ kintsii kilu-u tuu dza chi be, be se chikɛ bɛ n'yɔru. Se bii li be laa, “Bɛniiŋ bɛ Ɛfishɛŋ, wi wɛ lu wu kii yɛ le ɛ bee bɛ Ɛfishɛŋ fɛni bɛ kɛmi yih yi muntofi yi nyɔ yi Atɛmi mɔɔ tɛtɛ chi nyɔ chi tɛ̀ we liwe ni? ");
INSERT INTO asj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Si wi nuuŋ yɛ lu wu nuuŋ tɛchɛ fini fiee kɛ ni, bee nuuŋ nɛ shee finɛ nshiiŋ, nɛ yoomfi yɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nɛ bɛ baa bɛ bɛniiŋ bani fɛni be mɛɛŋ ki yi-i fiee li yíh yi bɛnyɔ kɛ, kɛ le be yɔ jɛ́ yi bifi kii nyɔ yisɛŋ yi chɛɛŋ yini nsiŋ. ");
INSERT INTO asj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ɛ Dɛmɛtrus bɛ bɛniiŋ bee kɛmi nsa bɛ wi, kɛ jo yi nsa yɛɛ lu yibe nuuŋ be gɛɛŋ be ŋɛŋ bɛniiŋ bɛ sɛki bɛnsa bee be saa. ");
INSERT INTO asj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɛ fiee fimu nuuŋ lu fi yɛki fini fi nɛ wɛki, kɛ bɛ gii bɛ bichɛ lɛ fi-i lɛnti fɛ kinshewu ki bɛte kitoŋ. ");
INSERT INTO asj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ntiitɔɔ ni kifɛ ŋiŋgɔɔ le fiee fini gii fi lii bee li ŋkweŋɛ le tɛɛbeŋ bɛchi baa kpɛ. Ɛ fi ka lɛ, tɛ tɛ kɛmɛ fiee fi shaaŋ fi bɛ nuuŋ bɛ tuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Le yɔ lɛ, se tee kintutu kilu saaŋgɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Le kpɛ wu tɛ̀ nuuŋ Ɛfishɛŋ wɛ ma, Pɔɔ se teeŋ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, tifi be, yɛsi be se dza ŋgɛnu Masadonya. ");
INSERT INTO asj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Le gɛɛŋ, dɛndɛ bimbe bi le bichu, kaaŋgi shéŋ yi bɛniiŋ bɛ kimbeenchɛ-ɛ bujɔŋ, se dansɛ gɛɛŋ Griis, ");
INSERT INTO asj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tsi fe kii tɛɛ. Le dza le gii gɛɛŋ lɛ lɛ yih yi li dzɔɔ li gɛɛŋ Silia, se woo le Bɛjuu nyi baa kii wu lɛ dze, se ŋɛŋ le fi dzɔɔŋ le kaari to lijiŋ dze Masadonya. ");
INSERT INTO asj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tɛ̀ deŋgi bee bɛ Sopata ŋwanɛ pilu wu Beera, mɔɔ Aristaku bɛ Sɛkundu bɛ tɛ̀ bo Tɛsalonya, mɔɔ Gayɔŋ wu Dɛlbi, mɔɔ Timɔti, mɔɔ Tichiku bɛ Tufimu bɛ tɛ̀ nuuŋ bɛniiŋ bɛ Eesha. ");
INSERT INTO asj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bɛniiŋ bani se gɛɛŋ limfwe be tɛŋgi tɛɛ Pɔɔ Towa. ");
INSERT INTO asj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tsɔnɔ chi Kibele ki bɛ mɛɛŋ ki gɛɛ kɛ kishee le kɛ tɛ̀ ka, tɛ lɛ lɛ yih yi li dzɔɔ Filipi, le jo ka tiŋ, tɛ chiindɛ be Towa, fɛ tɛ tɛ̀ tsi fe jo mfomɛnyaaŋ. ");
INSERT INTO asj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Le ni nuuŋ jobɛ chi ŋkosi chi li fuu li, tɛɛ kintutu kilu tɛ̀ banchɛ yih yisɛŋ lɛ fɛmfo-o le tɛ boyɛ kibele. Si Pɔɔ tɛ̀ nuuŋ le gii bo dza fɛ buwoo, se bɛchi yeti li bee, dɛɛmi tefɛ chee chi gɛɛŋ chi bo butuu kintikinti. ");
INSERT INTO asj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tɛ tɛ̀ nuuŋ lɛnti lɛ kiji ki yih yi lɛwe, fɛ biŋ'wofu tɛ bɛndi le ŋge. ");
INSERT INTO asj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Sɔɔnɛ wi wumu wu bukooŋ tɛ̀ nuuŋ le Yutiku tɛ̀ shee lɛ fwii wu yi-ih. Tɛ̀ dza bɛchi liiti si Pɔɔ tɛ giiŋgi nɛɛ limfwe bɛ n'yɔru lɛ. Chilefɛ tɛ̀ kɔɔ wu, se dza fe we lɛkwiiŋ, fe tɛ̀ nuuŋ biji bi yi-ih bitɛɛtu mbɛɛchɛ fɛkwiiŋ, be shee be dzɔ wu, ɛ wu kwi kituŋ. ");
INSERT INTO asj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔɔ shee gɛɛŋ guumɛ lɛ wu-u lɛwe, kokɛ wu tee li bɛniiŋ li le, “Nɛ boo kɛ yi kɛ, mɛɛŋ ɔ lu.” ");
INSERT INTO asj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Le Pɔɔ kaari miri lɛ kiji ki lɛwe kɛɛ, bootɛ kibele ji, se tuu bɛchi biee bi tefɛ bɛ be nsiiŋ butuu woo, se dza. ");
INSERT INTO asj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bɛniiŋ se dzɔ sɔɔnɛ wi wɛ be koo bɛ wu fɛkuuŋ mɛɛŋ yoŋ, shéŋ se dɛŋ be tsɔɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tɛ tɛ̀ dza tɛ lɛ yih yi li dzɔɔ, tɛ gɛɛŋ Aso, si Pɔɔ tɛ̀ seesɛ le ɛ le lɛ tɛ gii tɛ dzɔɔ wu. Tɛ̀ tee lɛ, kifɛ tɛ̀ wɛki le dɛndɛ nuuŋ kwiiŋ. ");
INSERT INTO asj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Le tɛ taa li bee li Aso, tɛ dzɔ wu lɛ yih yi li dzɔɔ, tɛɛ be se gɛɛŋ tɛ bo Mitilɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tɛ dza fe lɛ yih yi li dzɔɔ, butuu bo buwoo, tɛ fɛsi li Kios lichiŋ tɛ ka, le bu tuu bo buwoo, tɛ fɛsi Samo, tɛ tuu tɛ ka, le bu wuutɔɔ, tɛ lɛ Militu. ");
INSERT INTO asj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tɛ tɛ̀ dɛndɛ ni, tɛ wɛɛŋ dze Ɛfishɛŋ kifɛ Pɔɔ tɛ̀ wɛki yɛ le lɛɛ mfi Eesha kɛ. Tɛ giiŋgi tsɛkɛ tsɛkɛ laa nuuŋ nɛɛ nuuŋ Jɛrosalɛŋ jobɛ chi Tsɔnɔ chi Pɛntɛkɔ-ɔ le. ");
INSERT INTO asj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Le tɛ lɛ Militu, Pɔɔ tuumi ntoŋ li bɛte kintaashɛ ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Ɛfishɛŋ le be bɛ be ŋɛŋ wu. ");
INSERT INTO asj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Le be bɛ, tee li be le, “Nɛ kii si ntsɛ wɛŋ tɛ̀ nuuŋ tɛɛbeŋ mbɛɛchɛ jobɛ chi ŋkosi chi ntɛ̀ ntɔmi bikaa li nshɛ yi Eesha-a. ");
INSERT INTO asj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ntɛ̀ shiiki yi yɛŋ, nindi li Nyɔ-ɔ bɛ musu lɛ lii. Nse ntuu ŋɛŋ bɛŋgɛ lɛ dzé ŋge li si Bɛjuu tɛ biindi bikaa lɛ mi jiŋ. ");
INSERT INTO asj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nɛ kii baa nɛɛ si ntɛ̀ ntiifi beŋ gbanaa, ntuu ndeŋgi ntiifi li yi-ih li yi-ih. Ntɛ̀ mɛɛŋ ki nyikɛ kɛ fiee fimu fi nuuŋ fi fi beŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ntɛ̀ ntee nɛɛ nuuŋ fiee fimumkpaŋ li Bɛjuu li, mɔɔ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, ŋkweŋgi le be fiiki shéŋ yibe, be to bɛ Nyɔ, be gɛɛ shéŋ li Taa wusɛŋ wu Jiso Krai. ");
INSERT INTO asj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Dɛɛni, yikɛ yɛŋ nɛ woo, ŋgiiŋgɔɔ Jɛrosalɛŋ nuuŋ nɛɛ si Fiana yi Waaŋ tee li mi, ŋkii yɛ laa ɛ la fi gii fi ka bɛ mi le kɛ le. ");
INSERT INTO asj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Fiee fi ŋkii kwaa nuuŋ le, bitsii bichu bi mi ŋka li bi-i, Fiana yi Waaŋ tiiti nɛɛ li mi le ncha bɛ ŋgɛ tɛŋgɔɔ mi limfwe. ");
INSERT INTO asj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Se nuuŋ le, ŋiŋgi yɛ ntsɛ wɛŋ le wɛ fiee kɛ, fuki le mɛɛshi nimɛ chi Taa Jiso tɛ̀ nyɛ li mi, chi nuuŋ le ni fenjisi ntoŋ wu dzeeŋ kii shéŋ yi dzeeŋ yi Nyɔ doonchɛ li bɛniiŋ li. ");
INSERT INTO asj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Li dɛɛni, yikɛ yɛɛŋ nɛ woo, ŋkiiɔ le wi lu li be-eŋ linti wu tɛɛ be tuu tɛ̀ tiiti kii bumfɔŋ bu Nyɔ-ɔ mɛɛŋɔ naa ŋɛŋ bushi bweŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nse mgbɛŋgɔɔ ntiiti li be-eŋ bɛŋ le, ɛ wumu li be-eŋ linti la dɛɛni, kɛ ŋkɛmi yɛ tsaŋ fɛ wu-u kɛ, ");
INSERT INTO asj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kifɛ ntuu mɛɛŋ ki nyikɛ kɛ ntefu beŋ fiee fichu fi Nyɔ wɛki kɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɛ nɛ shɛ, nɛ bichi fɛ bikoo binɛ mɔɔ fɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ nuuŋ si nshɔ́ɔŋ, bɛ Fiana yi Waaŋ gɛɛ le nɛ ni nɛ bichi. Nɛ nuuŋ biŋkiichɛ nshɔ́ɔŋ bi kintutu ki bɛniiŋ bɛ Nyɔ-ɔ ki tɛ̀ go bɛ ŋgɔŋ mɛ Ŋwani-i. ");
INSERT INTO asj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ŋkiiɔ le mfi wu mi ntsɔɔ bikaa li be-eŋ, bɛmbɔɔŋku bɛ tɛɛmi gii be lɛ li kintutu kinɛ-ɛ linti, be tɛ̀ tsaa wi wu be gii be kɔɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bɛniiŋ bamu gii be bo nɛɛ li beŋ linti, be ni be yɛŋgi bɛ kintutu ki bɛniiŋ bɛ kimbeenchɛ-ɛ, be chiiti, be tusi li kintutu kibee. ");
INSERT INTO asj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Se nuuŋ le, nɛɛ bichi yɛŋ nɛ kiimi le, li biya bi bitɛɛtu, mi ntifɔɔ beŋ bɛchu butuu mɔɔ fɛnshaaŋ bɛ dzɔɔ lɛ lii. ");
INSERT INTO asj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nse nyɛɔ beŋ dɛɛni li tsaŋ yi Nyɔ-ɔ mɔɔ li jɛ yee yi nuuŋ kii mfiɛ wu Nyɔ li bɛniiŋ li. Jɛ yini yɛ yi nuuŋ yi fɛ se nɛ ni nɛ kuu, ke se nɛ kɛmɛ kimbɛ fɛ kintsii ki Nyɔ gɛɛ li bɛniiŋ bɛ yi fɛ le ɛ bee kibɛtɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nti mɛɛŋɔ saa ki ndzeŋ kɛ kwa wu wi mɔɔ nuuŋ ndú yi wi kɛ. ");
INSERT INTO asj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nɛ kii baa bujɔŋ le ɛ tsaŋ yɛŋ yini yi ntɛ̀ nindi fiee fichu fi tɛɛ kintutu keŋ tɛ tɛ̀ Kɔŋgisi ");
INSERT INTO asj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Li biee bichu ntɛ̀ ndoonchi beŋ le wi kɛmi le ni nindi bujɔŋ se fii bɛniiŋ bɛ ŋgɛ, ŋkiimi si Taa Jiso tɛ̀ tee le, ‘Kinɛɛtinɛ ki ŋge nuuŋ ki wi wu nyɛɛ bunyɛɛ, yɛki wi wu fii bufiɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Le Pɔɔ mɛɛshi n'yɔru lɛ, bee be se toŋ núŋ fɛkwiiŋ bɛchu, be lɛkɛ li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Be dza be waŋ kwe be dii, be kokɛ Pɔɔ be nyɔchɛ wu be tee le bɛ shɛ baa. ");
INSERT INTO asj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Fiee fi tɛ̀ ge le be ni be dii ŋge ni, tɛ̀ nuuŋ jɛ yi Pɔɔ tɛ̀ yɔ le be mɛɛŋ yɛ be tuu be ŋɛŋ bushi bwee kɛ. Be se chinɛ wu be gɛɛŋ be bo fɛ gii lɛ lɛ yih yi li dzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tɛɛ bɛ Pɔɔ tɛ̀ yɛsi be, tɛ se dza fe tɛ̀ lenchi lɛ yih yi li dzɔɔ li tsaaŋ, tɛ fɛsi Kos. Le bu woo, tɛ gɛɛŋ Lodɛs, le tɛ̀ dza fe, tɛ gɛɛŋ Patara. ");
INSERT INTO asj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Le tɛ bo fe, tɛ ŋɛŋ yih yi li dzɔɔ yimi yi tɛ̀ giiŋgi Fonisha, tɛ se lɛ le tɛ gɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Le tɛ ŋɛŋ Saaplu, tɛ shɛ wu lɛ kibɛnɛ ki kimɛsɛ-ɛ, tɛ se ka tɛ gɛɛŋ tɛ bo Tayɛ, kwɛɛŋ wu Silia fɛ yih yi li dzɔɔ yilu tɛ̀ nuuŋ le yi gii yi buu biee. ");
INSERT INTO asj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tɛ gɔɔŋ bɛniiŋ bɛ kimbeenchɛ-ɛ, tɛɛ be tsi jo mfomɛnyaaŋ. Fiana yi Waaŋ fɛ, be tifi Pɔɔ le kiiŋ ni mɔŋ ŋgɛnu Jɛrosalɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Le tɛɛ be tɛ tsi, jobɛ bɛ chi kɔchɛ chi tɛ dzɛti, tɛ se dzɔ dze. Be bɛchu mɔɔ bukɛɛŋ bɛ bee mɔɔ bɔɔŋ, chinɛ bee be bo li kitoŋ kilu be gɛɛŋ be busɛ li ŋgemi yi dzɔɔ yi nyɔŋa-a, tɛɛ be toŋ núŋ fɛkwiiŋ, tɛ lɛkɛ li Nyɔ-ɔ, tɛ yɛɛshɛ yi. ");
INSERT INTO asj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Se tɛ lɛ lɛ yih yi li dzɔɔ li, be to lijiŋ li bɛla bɛ bee. ");
INSERT INTO asj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tɛ se dza Tayɛ, tɛ dzɔ dze, tɛ gɛɛŋ tɛ bo Tolɛmay. Tɛɛ bɛŋwaanɛŋ bɛ kimbeenchɛ-ɛ yɛsi yi, tɛ tsi jobɛ chimumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Le bu woo, tɛ dza, tɛ gɛɛŋ tɛ fɛsi Kasaria, tɛ gɛɛŋ li yih yi Fili wu tɛ̀ deŋgi tiiti jɛ yi Nyɔ, se tɛɛ be tsi. Fili wuni tɛ̀ nuuŋ wi mumkpaŋ li kintutu ki bɛniiŋ bɛ mfomɛnyaaŋ bɛ bɛ tɛ̀ buu baa. ");
INSERT INTO asj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tɛ̀ kɛmi bɔɔŋ bɛ bukɛɛŋ bɛnɛɛ, be ti mɛɛŋ saa ki kɛɛ kɛ buniŋ kɛ, be tɛ̀ shiiŋ be tiiti bɛniiŋ biee bi be wuki Nyɔ tiiti. ");
INSERT INTO asj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tɛ tɛ̀ nuuŋ fe jo ŋge, wi wumu wu tɛ̀ shiiŋ tiiti biee bi wuki Nyɔ tiiti tɛ̀ dza Judiya bɔɔ bɛ fe bukooŋ bwee nuuŋ le Agabu. ");
INSERT INTO asj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Le bɛ ŋɛŋ bee, dzɔ kitsaa ki Pɔɔ lɛ, kaŋ bikaa biee bi wu wu Agabu mɔɔ bibɛnu biee lu, se tee le, “Fiana yi Waaŋ tiiti yɛ le ɛ nɛɛ ni si Bɛjuu bɛ Jɛrosalɛŋ gii be kaŋ wi wu kɛmi kitsaa kini ni, be nyɛ wu li tsaŋ yi bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Le tɛ woo lɛ, bee bɛ bɛniiŋ bɛchu bɛ tɛ̀ nuuŋ fe lɛkɛ Pɔɔ le kiiŋ ni gɛɛŋ Jɛrosalɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Se tuu le, “Ɛ fi la fi nɛ gii lɛ? Nɛ kii yɛ le nɛ dii baa ni shéŋ yɛŋ sɛɛsi ni? Mɛɛŋɔ ki nachɛ kɛ kwaa le nlɛ li yih yi ncha-a Jɛrosalɛŋ kɛ. Mi nachɔɔ tɛ le ŋkwi le kii bukooŋ bu Taa Jiso-o.” ");
INSERT INTO asj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Si dze tɛ̀ mɛɛŋ ki nuuŋ lu le tɛ fɛ le fiiki mbeechɛ we kɛ lɛ, tɛ chikɛ, tɛ tee nɛɛ le, “Fi nuuŋ si Taa wɛki.” ");
INSERT INTO asj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Le jo ka, tɛ banchɛ biee bisɛŋ, se tɛ yɛki Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bɛniiŋ bɛ kimbeenchɛ-ɛ bamu bɛ Kasaria se yɛɛ tɛ bɛ bee, be dzɔ bee tɛɛ be tɛ gɛɛŋ li Menasɔŋ yih fɛ tɛ tɛ̀ nuuŋ le tɛ gii tɛ tsi. Menasɔŋ wuni tɛ̀ nuuŋ wi wu Saaplu, tɛ̀ nuuŋ wumu lɛnti lɛ bɛniiŋ bɛ tɛ̀ saa be gɛɛ shéŋ li Jiso-o. ");
INSERT INTO asj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Le tɛ fɛsi Jɛrosalɛŋ bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ fe fi bee bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Le bu woo, tɛɛ bɛ Pɔɔ la ŋka lɛ Jeeŋ li, bɛte kintaashɛ tɛ̀ nuuŋ tɛ fe bɛchu. ");
INSERT INTO asj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔ yɛsi be, se naanyɛ fiee fichu li bee fi Nyɔ fɛ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ kɛti li nimɛ chee chi tɛ nindi. ");
INSERT INTO asj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Le be woo lɛ, be bɛchi be yɔɔnchi Nyɔ. Se nuuŋ le, be dza be tee li Pɔɔ li le, “Ŋwaanɛŋ, bichɛ ɔ ŋɛŋ si Bɛjuu gɛɛ shéŋ li Jiso li bɛnchuki li bɛnchuki. Se nuuŋ le, be baa lɛ, be mɛɛŋ be lemi li bɛnchi bɛ Mɔɔsɛ mkpaaŋ, ");
INSERT INTO asj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","be tee baa bee kii wɛ le ɔ deŋgɔɔ ɔ tiifi Bɛjuu bɛ tsiiŋ li tɛɛŋ yimi le be chinɛ li bɛnchi bɛ Mɔɔsɛ-ɛ, ɔ tiiti le kiiŋ be ni be sɛɛti bɔɔŋ dzóo kɛ, bɛ le kiiŋ be ni be biki ntsɛ wu li kwɛɛŋ wusɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Si fi fiɛɛ le be gii be kɛɛ nɛɛ le ɔ bɛɛɔ lɛ, tɛ gii tɛ geeŋ dɛɛni? ");
INSERT INTO asj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Tɛ gii tɛ tee wɛ fiee fi ɔ gii ɔ fɛ. Tɛ kɛmi baa bɛniiŋ fɛni bɛnɛɛ bɛ fɛ baa nchini bɛ Nyɔ. ");
INSERT INTO asj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Dzɔɔ be, nɛɛ be nɛ gɛɛŋ nɛ tsootsɛ bikoo binɛ, ɔ sooŋ fiee fichu fi be kɛmi le be sooŋ le be gɛɛŋ be mu bikoo bi bee. Ɔɔ fɛ lɛ, bɛniiŋ bɛchu kɛɛ le ɔ kichɔɔ bɛnchi bɛ Mɔɔsɛ, kɛ biee bichu bi be tiiti kii wɛ tɛ̀ nuuŋ yɛ chɛɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Fi kii bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ nuuŋ yɛ Bɛjuu kɛ, tɛ dzɔ baa ntaŋ tɛ tsɛɛ Kiŋwaati tɛ tuumi li bee le kiiŋ be ni be jii biee bijɛ bi bɛ fɛ muntofi lu li bɛnyɔ-ɔ kɛ. Kiiŋ be ni be jii ŋgɔŋ mɛ nya-aŋ kɛ. Kiiŋ be ni be jii nyaŋ fuki yi bɛ sɛɛ ŋgɔŋ bo siŋ kɛ. Kiiŋ be ni be kɛmi fiee fi fɛrɛ bɛ bukwɛɛ kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bɛdɛɛni, Pɔɔ se dzɔ bɛniiŋ bɛlu, le butuu woo bee be gɛɛŋ be tsootsɛ bikoo bi bee. Pɔɔ se gɛɛŋ li yih yi muntofi, tee jobɛ chi jo yi ntsootsɛ bikoo gii yi ma, be se fɛ muntofi li bee wi mumkpaŋ mumkpaŋ. ");
INSERT INTO asj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Le jo yilu ni yi mɛɛ, ɛ yi tɛ̀ nuuŋ mfomɛnyaaŋ, Bɛjuu bamu bɛ tɛ̀ dzɛti Eesha be ŋɛŋ Pɔɔ li yih yi muntofi-i, be kunsɛ kintutu ki bɛniiŋ lɛ le be kɔɔ wu, ");
INSERT INTO asj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","be tundi kitata be tiiti le, “Bɛniiŋ bɛ Isɛlɛɛ, fi yɛɛŋ bee. Ɛ wi wuni wu deŋgi tiifi biee bibifi li bɛniiŋ li, li bintsii bichu-u kii kwɛɛŋ wusɛŋ bɛ bɛnchi bɛ Mɔɔsɛɛ mɔɔ kii yih yi muntofi yini. Wu se mɛɛshɔɔ wu dzɔ bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, wu bɛ bɛ be li yih yi muntofi fɛni, wu biifi bintsii bi wuuti bini.” ");
INSERT INTO asj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Be tɛ̀ tiiti lɛ, kifɛ be tɛ̀ ŋɛŋ si Pɔɔ deŋgi fɛ kintsii li bee Tufimu wu wi wu Ɛfishɛŋ. Be se tɛ̀ beechi le Pɔɔ lɛɔ bɛ wu li yih yi muntofi-i. ");
INSERT INTO asj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kitata kilu tɛ̀ fɛ kitoŋ kichu sɛɛsɛ, bɛniiŋ letini be bɛɛ fe. Be cha Pɔɔ, be chee wu be bo bɛ wu li yih yi muntofi-i, mfwaa mumkpaŋ, be se fa bigoo. ");
INSERT INTO asj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Be wɛki le bɛ wo Pɔɔ, ntoŋ wulu lɛ lɛ bintooŋ bi bɛte bikoo bi bɛniiŋ bɛ nchi-i bɛ Lom le Jɛrosalɛŋ kwikwi shanshɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Se dza mfwaa mumkpaŋ, dzɔ bɛniiŋ bɛ nchi-i bɛ bikoo bimu bi bintutu bi bɛniiŋ bɛ nchi-i, bee be letɛ be bɔɔ le. Le bɛniiŋ ŋɛŋ bɛniiŋ bɛ nchi-i ɛ te kikoo wu bɛniiŋ bɛ nchi-i nuuŋ fe, be se chikɛ nsoŋu Pɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Te Kikoo wu nchi wulu se bɛ kɔɔ Pɔɔ, tee le bɛ kaŋ wu bɛ bɛncha bɛfɛ. Se bii li be laa, “Wuni nuuŋ noo? Wu chɔ nuuŋ la?” ");
INSERT INTO asj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Fe bɛchi nduŋu, bani wɛndi fini, baa wɛndi fiɛɛ. Tɛ̀ mɛɛŋ ki gbɛɛŋ kɛ le woo fiee fi ka kɛ. Se dza tee le be dzɔ Pɔɔ be yɛɛ bɛ wu fɛ la wu bɛniiŋ bɛ nchi-i. ");
INSERT INTO asj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bɛniiŋ bɛ nchi-i baa se dzɔ wu, le be ni be yɛki fɛ dze yi bɛ tɛ̀ wa bitoo li be too Pɔɔ bu towu, kifɛ kintutu kilu tɛ fuuti lɛjiŋ. ");
INSERT INTO asj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ki tɛ̀ biki lɛ ki wɛndi le, “Bɛ mɛɛshi bɛ wu.” ");
INSERT INTO asj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Si be tɛ̀ lii bɛ Pɔɔ fɛ la wu bɛniiŋ bɛ nchi lɛ, lɛkɛ te kikoo wu bɛniiŋ bɛ nchi wɛ le, “Nnuuŋ ntee fiee li wɛ ni?” Le woo ni, bii li Pɔɔ li laa, “Fi nuuŋ le ɔ kii jɛ yi Grik ni? ");
INSERT INTO asj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ɛ nɛɛ wɛ wi wu Ijip wu tɛ̀ bɛ bɛchi kpɛ bɛ bikoo bi kwɛɛŋ lɛ mfi wumu, banchɛ kintutu ki bɛniiŋ lɛ bɛnchuki bɛnɛɛ (4,000) bɛ tɛ̀ woyɛ bɛniiŋ bee be gɛɛŋ be nuuŋ litɔɔ ni?” ");
INSERT INTO asj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔɔ tuu le, “Nuuŋ wi wu Juu, bɛ tɛ̀ biɛ mi Taasu kwɛɛŋ wu Silisha, Taasu nuuŋ yɛ kitoŋ ki yee kɛ. Mintemii, nyɛ nɛɛ mi dze n'yɔ li bɛniiŋ bani-i.” ");
INSERT INTO asj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Se te kikoo wu bɛniiŋ bɛ nchi wulu tuu nyɛ wu dze le yɔ. Pɔɔ se leŋ fɛ bɛ tɛ̀ wa bitoo bi dze fɛɛ, chi bɛniiŋ bɛ kibɛnɛ. Be chikɛ bɛ n'yɔru, yɔ li bee lɛ jɛ́ yi Hiburu li le. ");
INSERT INTO asj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bɛtaa mɔɔ bɛŋwaanɛŋ, yikɛ yɛɛŋ ntaŋ kikoo keŋ li be-eŋ limfwe.” ");
INSERT INTO asj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Le be woo si tuu yeti nuuŋ lɛ jɛ́ yibe yi Hiburu li, be mɛshi be chiŋ ni nshiiŋ. Pɔɔ tee le, ");
INSERT INTO asj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nnuuŋ wi Juu, bɛ tɛ̀ biɛ mi Taasu kwɛɛŋ wu Silisha, bɛdɛɛni bɛ se kii baa mi Jɛrosalɛŋ fɛni, ntɛ̀ nlaanchɛ Kiŋwaati li tsaŋ yi Gamaliya. Tɛ̀ bɔsɛyi wu tiifi mi bɛnchi bɛ bɛtaa bɛsɛŋ, nse nlemɔɔ tɛ li fiee fi Nyɔ-ɔ mkpaaŋ nɛɛ si beŋ bɛchu bɛ nuuŋ fɛni bɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ntɛ̀ shiiŋ mbiindi bikaa lɛ bɛniiŋ bɛ biki Dze yi Taa li, mfeti le bɛ woyɛ be, ŋkeeti bukɛɛŋ bɛ buniŋ ntumisi li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Fini nuuŋ fiee fi kikoo ki bɛte muntofi bɛ bɛniiŋ bɛ sɛki kwɛɛŋ kii waaŋ. Ɛ be bɛ tɛ̀ nyɛ mi biŋwaati le ŋgɛɛŋ lɛ bɛŋwaanɛŋ bɛsɛŋ bɛ nuuŋ Damako. Se ŋgiiŋgi le ŋkɔɔ bɛniiŋ bɛ biki Dze yi Taa, ŋkaŋ be, mbɛ bɛ be Jɛrosalɛŋ bɛ nyɛ be ŋgɛ. ");
INSERT INTO asj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Si ntɛ̀ ndeŋgi mbɛɛ ntsɛkɛ nlɛ Damako si lɛ fɛnshaaŋ li kintikinti, kiŋ'wofu kimu ki nɔŋa dza ki lɛbi liboo, ki shee li mi-i bwiŋ. ");
INSERT INTO asj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ŋ'we fɛkwiiŋ, ŋ'woo si jɛ yɔ li mi-i le, ‘Sɔɔ, Sɔɔ, ɔ biindi bikaa lɛ mi-i jiŋ kii la?’ ");
INSERT INTO asj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mbii le, ‘Taa, ɛ wɛ noo?’ Jɛ yilu tuu le, ‘Ɛ mi Jiso wu Nasarɛ, ɛ mi wu ɔ biindi bikaa lɛ wu jiŋ.’ ");
INSERT INTO asj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bɛniiŋ bɛ ntɛ̀ nuuŋ tɛɛ be ŋɛŋ kiŋ'wofu kilu, bɛdɛɛni, be tɛ̀ mɛɛŋ ki woo kɛ jɛ yi wi wu tɛɛ wu yeti wɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ntuu mbii le, ‘Taa, ɛ la fi ŋgii mfɛ?’ Yi tuu li mi-i le, ‘Dzatsɛ we, ɔ lɛ ɔ gɛɛŋ Damako, bɛ gii bɛ tee wɛ le nimɛ chichu chi Nyɔ nachɛ le ɔ niŋ.’ ");
INSERT INTO asj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ntɛ̀ ndza fe, ɛ kiŋ'wofu kɛɛ fɛ mi nyɛɛ, bɛniiŋ bɛ tɛɛ be tɛ gii tɛ deŋgi baa se tsɛtsi mi butsɛtsɛ, be lɛ be gɛɛŋ bɛ mi Damako. ");
INSERT INTO asj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Wi wumu tɛ̀ nuuŋ Damako wulu, bukooŋ bwee nuuŋ le Ananiya, ɛ tɛ̀ gbɛŋgi guundi Nyɔ, giki bɛnchi bɛsɛŋ, Bɛjuu bɛchu bɛ tɛ̀ nuuŋ le piɛti wu. ");
INSERT INTO asj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Dza bɛ ŋɛŋ mi, leŋ li mi lichiŋ tee li mi-i le, ‘Sɔɔ ŋwaanɛŋ, kaari ɔ ni ɔ ŋiŋgi biee.’ Nɛɛ li mfi wulu lɛ, nse ŋkaari ŋiŋgi biee, nse ŋɛŋ tɛ wu wu Ananiya. ");
INSERT INTO asj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tee li mi-i le, ‘Nyɔ yi bɛtaa bɛsɛŋ tsaa yɛ wɛ kituŋ le ɔ kɛɛ fiee fi yi kɔŋgisi, bɛ le ɔ ŋɛŋ Wi we wu nimɛ wu Tsaaŋ, ɔ woo n'yɔru wu buti li kimfimɛ kee li. ");
INSERT INTO asj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ɔ gii ɔ naa ɔ nuuŋ wi wu tiifi kii wu, ɔ ni ɔ tiiti li bɛniiŋ bɛchu-u fiee fi ɔ ŋɛŋ bɛ fi ɔ woo. ");
INSERT INTO asj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Si fi fiɛɛ dɛɛni ni, ɔ mɛɛŋ ɔ tuu ɔ tɛŋgi nuuŋ la? Dzatsɛ we bɛ lii wɛ li dzɔɔ, bɛ tsootsɛ bibifi bio, si ɔ lɛki li Taa li lɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ntuu nto lijiŋ Jɛrosalɛŋ le ntuu ni nlɛki li yih yi muntofi-i, fiee fimu si kifiee dza fi bɛ lɛ mi-i. ");
INSERT INTO asj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nse ŋɛŋ Taa lɛ fiee filu, tee li mi-i le, ‘Bakɛ ɔ dza Jɛrosalɛŋ fɛni tsɛkɛ kifɛ bɛniiŋ bɛ fɛni nuuŋ tɛ beŋ fiee fi ɔ tiifi kii mi kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ntuu li wuu le, ‘Taa, bɛ kii baa bujɔŋ le ntɛ̀ nshiiŋ nlɛyi li yí yi nlɛkɛ li Nyɔ-ɔ, ŋkɔɔyi bɛniiŋ bɛ gɛɛ shéŋ li wɛ, ntuki be. ");
INSERT INTO asj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mfi wu be tɛ̀ wuu Fitifiŋ wu tɛ̀ tiifi bɛniiŋ kii wɛ, ntɛ̀ mbgɛŋgi nuuŋ fe mfɛɛfi. Ɛ mi wu bɛniiŋ bɛ tɛ̀ wuu wu tɛ̀ buushɛ ndú yibe, be nyɛ li mi ŋkɛmi.’ ");
INSERT INTO asj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Taa tuu tee li mi le, ‘Dzatsɛ fɛni, kifɛ ntundɔɔ wɛ nuuŋ mfiiŋ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Si Pɔɔ tɛ̀ gii tiiti bɛniiŋ yiki, si n'yɔru wuni tɛ̀ buti lɛ wu-u wa ni, be se bɛchi be wɛndi lɛwe ŋge, be tiiti le, “Bɛ lɛɛ ŋwaani fini finiiŋ bulɛsu li nshɛ yini-i. Ɛ wi wu nuuŋ ni nuuŋ we kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Si be tɛ̀ dzɛŋgi lɛ, be sɛɛsi ndú yibe, be lendi kiboŋ liwe. ");
INSERT INTO asj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Se te kikoo wu bikoo bi bɛniiŋ bɛ nchi tuu dza we tee li bɛniiŋ bɛ nchi baa le be dzɔɔ Pɔɔ be gɛɛŋ bɛ wu fɛ la wu be, le be gɛɛŋ be fiaamfiɛ wu, be bii biee li wu, se tee fiee fi fɛ Bɛjuu se tuu be wɛndi wu ni. ");
INSERT INTO asj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Be se gɛɛŋ bɛ wu be kaŋ wu, be dza le be fiaamfiɛ wu, Pɔɔ bii li kikoo ki kintutu ki bɛniiŋ bɛ nchi kimu ki tɛ̀ lemi fe laa, “Nchi beenchi le bɛ fiaaŋ wi wu Lom bɛ mɛɛŋ ki saa kɛ nsa we kɛ ni?” ");
INSERT INTO asj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kikoo ki kintutu ki bɛniiŋ bɛ nchi wulu woo lɛ, dza gɛɛŋ ŋɛŋ te kikoo wu be, tee li wuu le, “Ɔ wɛki le mɔnchɛ nuuŋ la ni? Ɔ kɛɛ le wi wuni nuuŋ wi wu Lom.” ");
INSERT INTO asj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Le te kikoo wulu woo lɛ, se gɛɛŋ ŋɛŋ Pɔɔ bii li wuu laa, “Tee nɛɛ mi, ɔ nuuŋ wi wu Lom ni?” Se beŋ. ");
INSERT INTO asj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Te Kikoo wulu tee li wuu le, “Ntɛ̀ ŋgo bɛ kwa ŋge, nse nto wi wu Lom.” Pɔɔ se tuu li wuu le, “Nnuuŋ fieŋ wi wu Lom kibɛɛ.” ");
INSERT INTO asj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bɛniiŋ bɛ tɛ nuuŋ le be ni biiti biee li wuu baa se cheeki bikaa lijiŋ mfwaa mumkpaŋ. Te Kikoo wu be wɛ chɛŋ tɛ, kifɛ tɛ̀ tee le be kaŋ Pɔɔ, nuuŋ wi wu Lom. ");
INSERT INTO asj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Te Kikoo wulu tɛ̀ wɛki le gbɛɛŋ kɛɛ fiee fi Bɛjuu tɛ̀ kayi li Pɔɔ li. Le bu woo, tee bɛ fanchɛ Pɔɔ, teeŋ bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bɛniiŋ bɛchu bɛ sɛki kwɛɛŋ, be bɛ, se leeki Pɔɔ be limfwe. ");
INSERT INTO asj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔ toŋ lii li bɛniiŋ bɛ sɛki kwɛɛŋ baa fwiiŋ, tee le, “Bɛŋwaanɛŋ, li ntsɛ wɛ-ɛŋ siiŋ bɛ bo bɛŋ, nti mfeti nuuŋ biee bi ŋkii le bi biɛɛ tsaaŋ lɛ Nyɔ lii, fiee nuuŋ yɛ lu fi sɛki shéŋ yɛŋ kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananiya wu tɛ̀ nuuŋ kikoo ki bɛte muntofi tee li bɛniiŋ bɛ tɛ̀ lemi li Pɔɔ li lichiŋ le be ju wu li kimfimɛ kee li. ");
INSERT INTO asj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔɔ tuu li wu le, “Nyɔ gii yi ju tɛ wɛ. Ɔ bosini kimbe ki yi-ih ki bɛ fwa ki nɛŋgi nuuŋ bwiŋ. Ɔ sheeɔ fɛɛ le ɔ ni ɔ sɛki mi ɔ biki nchi, ɔ se tuu ɔ bondini nchi wulu ɔ tiiti le bɛ ju mi ni?” ");
INSERT INTO asj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bɛniiŋ bɛ tɛ̀ lemi li Pɔɔ li lichiŋ bii li wuu laa, “Ɔ gaashi kikoo ki bɛte muntofi ki Nyɔ-ɔ ni?” ");
INSERT INTO asj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔɔ tuu le, “Bɛŋwaanɛŋ, mbee ŋkii yɛ le nuuŋ kikoo ki bɛte muntofi kɛ. Bɛ tsɛɛ baa le, ‘Kiiŋ wi ni tee jɛ yi bifi kii wi wu sɛki bɛniiŋ kɛ.’” ");
INSERT INTO asj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Le Pɔɔ bichɛ ŋɛŋ le bɛniiŋ bɛ tɛ̀ nuuŋ fe tɛ̀ nuuŋ bamu nuuŋ Bɛsadusii bamu Bɛfarasii, se yɔ bɛ jɛ yi tɛɛmi kintikinti ki bɛniiŋ bɛ sɛki kwɛɛŋ baa le, “Bɛŋwaanɛŋ, ɛ mi wi wu Bɛfarasii, nuuŋ ŋwaŋ wu Bɛfarasii. Mi wɛ fɛni li nsa kifɛ mbichi limfwe, ŋkii le biŋkwi gii bi bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Si tɛ̀ yɔ lɛ, Bɛsadusii bɛ Bɛfarasii dza be bɛchi ntsooŋ, kinshewu kilu gatɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Be tɛ̀ tsuki lɛ, kifɛ Bɛsadusii tɛ̀ shiiŋ be kweŋgi le biŋkwi nuuŋ tɛ naa bo li kwe-e kɛ, be tuu be kweŋgi le fiee fimu nuuŋ yɛ lu si bɛnchindaa bɛ Nyɔ-ɔ mɔɔ nuuŋ fiana kɛ. Se nuuŋ le, Bɛfarasii se beenchi le bini bichu nuuŋ lu. ");
INSERT INTO asj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ntsooŋ yi tɛɛmi tɛ̀ dza yi yɛɛ liwe. Se bɛniiŋ bɛ tiifi bɛnchi bamu bɛ tɛ̀ nuuŋ li kintutu ki Bɛfarasii lɛ dza be leŋ be yɔ bu n'yɔru mkpaaŋ le, “Tɛ mɛɛŋ baa ki ŋɛŋ fiee fi bifi bɛ wi wuni kɛ.” Nuuŋ ni nuuŋ fiana yimi, kɛ nchindaa wu Nyɔ-ɔ wu bee wu yɔ li wuu. ");
INSERT INTO asj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kweŋɛ chilu se dza, chi wɛki le chi to bugwe, se te kikoo wu bikoo bi bɛniiŋ bɛ nchi wɛ tɛ̀ chɛndi le semukɛ be dza be nshaanshɛ Pɔɔ bu nshaanshɛ li biŋkɛ. Se tee le bɛniiŋ bɛ nchi-i bɔɔ fe, be lɔ Pɔɔ li tsaŋ yi bee, be kaari be yɛɛ bɛ wu fɛ la wu nchi-i. ");
INSERT INTO asj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Le ni nuuŋ butuu, Taa bɛ leŋ li Pɔɔ li lichiŋ, tee li wuu le, “Kanɛ shéŋ. Si ɔ teeɔ li bɛniiŋ li kii mi Jɛrosalɛŋ ɛ nɛɛ lɛ si ɔ gii ɔ tee tɛ kii mi Lom.” ");
INSERT INTO asj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Le butuu woo, Bɛjuu bamu kɔɔ ntsooŋ, be chini le be nuuŋ tɛ̀ ji fiee mɔɔ nuuŋ le be woŋ fiee fuki fɛ be wo Pɔɔ siŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bɛniiŋ bɛ tɛ̀ kɔɔ ntsooŋ, be chini tɛ̀ yɛki wi mbaanyɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Be se gɛɛŋ fɛ bɛte muntofi-i bɛ nɔŋa bɛ nɔŋa, mɔɔ bɛniiŋ bɛ sɛki kwɛɛŋ, be tee li bee le, “Tɛ bɔsɛ baa yi tɛ chini le tɛ nuuŋ tɛ lii fiee lɛwa fuki fɛ tɛ wo Pɔɔ siŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Li dɛɛni, beŋ bɛ bɛniiŋ bɛchu bɛ sɛki kwɛɛŋ tuumi ntoŋ li te kikoo wu bikoo bi bɛniiŋ bɛ nchi-i, nɛ yɛɛŋ bɛ wu le tuu tuumi Pɔɔ le bɛ beŋ limfwe, le nɛ wɛki baa le nɛ tuu nɛ bichɛ lɛ nsa we-e bujɔŋ. Ke fi nuuŋ lɛ, tɛ se tɛɛ wu lɛ dze, ke bɛ beki bɛ wu, tɛ se wo wu mɛɛŋ lɛ dze.” ");
INSERT INTO asj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Si be tɛ̀ kɔɔ ntsooŋ wulu lɛ, ŋwanɛ dzɛmi yi Pɔɔ wu nyuŋ woo, se gɛɛŋ fɛ la wu bɛniiŋ bɛ nchi-i, tee li Pɔɔ li. ");
INSERT INTO asj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Se teeŋ kikoo ki kintutu ki bɛniiŋ bɛ nchi-i kimu tee li ki le, “Dzɔɔ sɔɔnɛ wi wuni ɔ gɛɛŋ bɛ wu fɛ te kikoo wu bikoo bi bɛniiŋ bɛ nchi, kɛmɔɔ fiee le tee li wuu.” ");
INSERT INTO asj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Se dzɔ wu gɛɛŋ bɛ wu fɛ te kikoo wu bikoo bi nchi, tee li wuu le, “Pɔɔ wu wi wu ncha teeŋɔ mi, wu tee le ndzɔɔ sɔɔnɛ wi wuni mbɛ bɛ wu lɛ wɛ-ɛ, le kɛmɔɔ fiee le tee li wɛ-ɛ.” ");
INSERT INTO asj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Se te kikoo wulu tuu kɛmɛ wu li kibɛnɛ, bee wu cheekiyi, bii li wuu laa, “Ɛ la fi ɔ wɛki lɔɔ tee mi?” ");
INSERT INTO asj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Sɔɔnɛ wi wulu tuu le, “Bɛjuu bamu dzɔ baa ntaŋ be tee le, be gii be tee le ɔ beeki Pɔɔ bɛ limfwe li bɛniiŋ bɛ sɛki kwɛɛŋ li fwaa, le bɛ wɛki baa le bɛ bichɛ lɛ nsa we bujɔŋ, be feti baa lɛ, be yɛŋgi bɛ wɛ bu yɛŋu. ");
INSERT INTO asj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kiiŋ ɔ ni beŋ kɛ, kifɛ bɛniiŋ baa lu yɛki wi mbaanyɛɛ bɛ tɛɛ baa wu lɛ dze, be chini baa le be nuuŋ tɛ̀ ji fiee mɔɔ nuuŋ le be woŋ fiee fuki fɛ be wo Pɔɔ nsiŋ kɛ. Be baa dɛɛni ɛ be nachɛ yi kituŋ, be tɛŋgi baa nuuŋ fiee fi ɔ gii ɔ tee.” ");
INSERT INTO asj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Se te kikoo wu bikoo bi bɛniiŋ bɛ nchi-i wulu se tee le sɔɔnɛ wi wulu ni giiŋgi, chinsɛ li wuu le, si giiŋgi ni kiiŋ ni fɛ wi kɛɛ le wu teeɔ fiee filu li wu-u kɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Te Kikoo wu bikoo bi bɛniiŋ bɛ nchi wulu se teeŋ bikoo bi bintutu bi bɛniiŋ bɛ nchi bifɛ tee li bi-i le, “Nachɛ yɛɛŋ bɛniiŋ bɛ nchi gii fɛɛ (200), bɛ bikuŋ gwii mfomɛnyaaŋ (70), mɔɔ bɛ gɔɔŋ lɛ gii fɛɛ (200), ke nuuŋ jobɛ bikaa mfomɛyoofi butuu, be gɛɛŋ Kasaria. ");
INSERT INTO asj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Nɛ nachɛ tɛ bikuŋ li Pɔɔ li, nɛ dzɔɔ wu nɛ gɛɛŋ bɛ wu fɛ Fɛli-i wi wu sɛki fiee mɛɛŋ ki kooŋ li wuu lɛ dze kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Si wu tee lɛ, se tsɛɛ kiŋwaati li wu-u ki tiiti le. ");
INSERT INTO asj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ɛ mi Klawdu Lisia. Ntsɛkɔɔ kiŋwaati kini li wɛ wu Fɛli ŋgɔmina. N'yɛɛshɔɔ li wɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bɛjuu tuu be kɔɔ wi wuni be tuu be wɛki le be wo. Mi ŋwoo le nuuŋ wi wu Lom, tɛɛ bɛniiŋ beŋ bɛ nchi tuu tɛ lɛ fe, tɛ lɔ wu li tsaŋ yi bee. ");
INSERT INTO asj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ntuu ŋ'wɛki le ŋ'woo fiee fi be sɛyi kii wu, nse mbɔɔ bɛ wu fɛ bɛniiŋ bɛ bee bɛ sɛki kwɛɛŋ li. ");
INSERT INTO asj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Le be bichi lɔ, mi ŋɛŋ le biee bi bɛ sɛyi kii wu biɛɛ nuuŋ bitɛchinɛ kii bɛnchi bɛ bee, se mɛɛŋɔ fɛ kɛ fiee fi nuuŋ be wo wu buwo kɛ le bɛ lii wu li yih yi ncha-a kɛ. ");
INSERT INTO asj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Wumu tuu tee mi le Bɛjuu bamu kɔɔ baa ntsooŋ le be wo wi wuni, mi se ntuumi wu li wɛ mfwaa mumkpaŋ. Mi nteeɔ tɛ li bɛniiŋ bɛ sɛyi biee li wu le be bɛ be ŋɛŋ nuuŋ wɛ, be tee fiee fi be kɛmi bɛ wu.” ");
INSERT INTO asj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bɛniiŋ bɛ nchi-i baa se dza be fɛ si te kikoo wu be tɛ̀ tiiti, be dzɔ Pɔɔ butuu, bee be gɛɛŋ be bo Antipati. ");
INSERT INTO asj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Le butuu woo, bɛniiŋ bɛ nchi bɛ tɛ̀ deŋgi bɛ bikaa chinɛ Pɔɔ li tsaŋ yi bɛ tɛ̀ deŋgi lɛ bikuŋ le be ni be giiŋgi bɛ wu limfwe, se be kaari be to lijiŋ fɛ la wu be. ");
INSERT INTO asj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Be gɛɛŋ be fɛsi Kasaria, be nyɛ kiŋwaati kɛɛ li ŋgɔmina, be nyɛ tɛ Pɔɔ li tsaŋ yee li. ");
INSERT INTO asj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Se fi kiŋwaati kilu teeŋ, bii li Pɔɔ li laa wu bo kimbɛ ki la le. Le woo le Pɔɔ nuuŋ wi wu Silisha, ");
INSERT INTO asj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","se tee li wuu le, “Ŋgii n'yikɛ nsa wa mfi wu bɛniiŋ bo bɛ nɛɛ be kɛmi nsa fɛsi fɛni.” Se tee bɛ dzɔ Pɔɔ bɛ gɛɛŋ bɛ gɛɛ wu lɛ ntɔ wu Hɛrɔ, bɛ kiichi wu. ");
INSERT INTO asj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Le jo bo tiŋ, Ananiya wu kikoo ki bɛte muntofi bɛ bɛniiŋ bamu bɛ sɛki kwɛɛŋ, mɔɔ Tɛtulu wu tɛ̀ gbɛɛŋ wu laanchɛ nchi, be bɔɔ be gɛɛŋ Kasaria. Be gɛɛŋ be ŋɛŋ Fɛli wi wu sɛki, be gɛɛ nsa wube kii Pɔɔ li wu mfwe. ");
INSERT INTO asj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Be teeŋ Pɔɔ, Tɛtulu bɛchi kayi biee kii Pɔɔ, tee li Fɛli-i le, “Wi wu nyɔŋa, mbɛɛŋgii wɛ li kwɛɛŋ wuni mbɛ mbochu bɛŋ, nuuŋ kii nsawu wa wu dzeeŋ, biee fiiki biɛɛ ŋge li kwɛɛŋ wuni nuuŋ li tsaŋ ya-a. ");
INSERT INTO asj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bɛniiŋ bɛchu wuki baa bujɔŋ ŋge be tuu be fii bumfɔŋ bwo li bintsii bichu-u mfi kwi. ");
INSERT INTO asj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ŋ'wɛki yɛ le mbiifi mfi wa ŋge kɛ, nlɛkɔɔ le ɔ yikɛ nɛɛ niiŋ, ɔ woo fiee fi tɛ gii tɛ tee. ");
INSERT INTO asj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tɛ ŋɛŋ baa le wi wuni wɛ wi wu fiee. Deŋgɔɔ shiishi kpɛ li Bɛjuu li, li kikoo ki nshɛ kichu. Se nuuŋ tɛ te kikoo wu kintutu ki bɛ teenyi le ki Nasarɛ. ");
INSERT INTO asj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Tɛ wɛki tɛ le biifi yih yi muntofi se tɛ kɔɔ wu. ");
INSERT INTO asj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ɔɔ bii biee bini li wi wuni, ɔ woo li wu biee bichu bi tɛ̀ tiiti kii wu bini.” ");
INSERT INTO asj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Si Tɛtulu tɛ̀ tee lɛ, Bɛjuu bɛchu beŋ be kurisi le biee bini bichu biɛɛ nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Se ŋgɔmina maa li Pɔɔ li le yɔ. Se kweeŋ le, “Ŋkiiɔ le ɔ saa wɛ bɛnsa li kwɛɛŋ wuni li biya ŋge. Nse ŋ'wukɔɔ bujɔŋ le nleŋ taaŋ bɛ kikoo keŋ li wɛ lii. ");
INSERT INTO asj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɔɔ dza ɔ biiti, ɔ gii ɔ woo le jo mɛɛŋ yɛ ka yoofi ntsɔ faa si ntuu n'yɛɛ Jɛrosalɛŋ lɛ li yih yibe yi kintaashɛ ");
INSERT INTO asj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bɛjuu tɛ̀ mɛɛŋ ki ŋɛŋ ntɛchini biee tɛɛ wi kɛ, be tɛ̀ mɛɛŋ ki ŋɛŋ tɛ le ntɛ̀ ŋkosini bɛniiŋ li yih yi muntofi, kɛ li yih yi nlɛkɛ li Nyɔ-ɔ, kɛ li bintsii bimu li kito-oŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Be kɛmi yɛ fiee dududu fi nuuŋ fi doonchɛ le ntɛ̀ fɛ biee bini bi be kayi kii mi bini kɛ. ");
INSERT INTO asj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mi mbeŋɔ fini li wɛ-ɛ lii, le nlɛki li Nyɔ-ɔ yi bɛtaa bɛsɛŋ mbiki Dze yibe teenyi le yi bifi. Mbeenchɔɔ nuuŋ li biee bichu bi nuuŋ lɛ Kiŋwaati ki bɛnchi bɛ Mɔɔsɛ-ɛ mɔɔ bi nuuŋ lɛ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mbichɔɔ limfwe li Nyɔ-ɔ nɛɛ si bɛniiŋ bani bichi, le bɛniiŋ bɛchu, bɛ dzeeŋ mɔɔ bɛ bifi gii be bo li kwe-e. ");
INSERT INTO asj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nɛɛ lɛ, nse ŋgwɛninɔɔ mfi kwi le ni ntsiiŋ ntsɛ wu tsaaŋ bɛ Nyɔ mɔɔ bɛ bɛniiŋ, le kiiŋ fiee nuuŋ lu fi nuuŋ fi ni fi sɛki mi li shéŋ yɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Fi fiɛɛ biya ŋge si ntɛ̀ ndza Jɛrosalɛŋ nse ntuu ŋkaari le nyɛ kwa li bɛniiŋ beŋ bɛ kwɛɛŋ lɛ, mɔɔ le mfɛ muntofi. ");
INSERT INTO asj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Fiiŋ fiee fi be tuu be ŋɛŋ mi li yih yi muntofi mfeti, nuuŋ ɛ ntuu ŋkɔɔ mi ntsootsɛ kikoo keŋ. Kiyaŋ ki bɛniiŋ lɛ tɛ̀ nuuŋ yɛ fe kɛ. ");
INSERT INTO asj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bɛjuu bamu bɛ Eesha tuu be nuuŋ fe, ɛ be bɛ kɛmi le be ni be nuuŋ fɛni le be tee wɛ fiee fi be kii kii mi, ɛ nuuŋ le fiee fiɛɛ lu. ");
INSERT INTO asj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ɛ nuuŋ yɛ lɛ kɛ, bɛniiŋ bani tee wɛ fiee fi be tuu be ŋɛŋ le mi nachɔɔ, mfi wu ntuu nleŋ limfwe li bɛniiŋ bɛ sɛki kwɛɛŋ li, ");
INSERT INTO asj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","fuki fiee fi ntuu ntee bɛ jɛ yi tɛɛmi li bee le, mi ŋ'wɛ li bee limfwe li mfi wu wɛɛ li nsa, kifɛ mbeenchɔɔ le biŋkwi gii bi bo li kwe-e.” ");
INSERT INTO asj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Le Pɔɔ yɔ lɛ, Fɛli yikɛ nɛɛ ni, ɛ tɛ̀ nuuŋ wi wu gbɛŋgi kii Dze yi Taa, se kiri nsa wulu tee le, “Mfi wu Lisia wu te kikoo wu bikoo bi bɛniiŋ bɛ nchi bɔɔ wu bɛ, nse nsondɛ nsa wunɛ.” ");
INSERT INTO asj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Se tee li kikoo ki kintutu ki bɛniiŋ bɛ nchi kimu le ki dzɔɔ Pɔɔ ki gɛɛŋ ki lii wu li yi, ki ni ki kiichi. Se nuuŋ le, le bɛ nyɛ wu dze, bɛ gɛɛ nsáŋ yee ni yi bɛɛ yi fii wu. ");
INSERT INTO asj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Le jo tuu yi kiiŋgi, Fɛli bee Drusila wu kwɛsi wu tɛ̀ nuuŋ wi Juu be bɛ. Fɛli gɛɛŋ teeŋ Pɔɔ bɛ, be se yiki fiee fi tiiti kii ŋgɛɛwu shéŋ li Krai Jiso. ");
INSERT INTO asj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Tiiti si wi nuuŋ ni nuuŋ wi wu dzeeŋ, bɛ si wi nuuŋ ni kiichi yi yee, mɔɔ si Nyɔ gii yi saa bɛniiŋ. Le Fɛli woo lɛ, fi chɛɛni wu ŋge. Se tee li Pɔɔ li le, “Nuuŋ ɔ gɛɛŋ dɛɛni, ke mi ŋkɛmɛ mfi nse ntuu nteeŋ wɛ.” ");
INSERT INTO asj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tɛ̀ tee lɛ, beechi le semukɛ Pɔɔ gii go wu bɛ kwa. Kii fini, se shiiŋ teenyi Pɔɔ mfi kwi bee wu mbuŋgi biee. ");
INSERT INTO asj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Se nuuŋ le, biya sooŋ bifɛ. Le bɛ tuu bɛ gɛɛ Pɔshu Fɛstu li kintindɛ ki Fɛli, se Fɛli tɛ̀ wɛki le fɛ se Bɛjuu ni be kɔŋgisi wu, se shɛ Pɔɔ li yih yi ncha-a. ");
INSERT INTO asj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Le bo jo taa si Fɛstu tɛ̀ bɛchi le ni sɛki kimbɛ ki kwɛɛŋ lɛ ki Judiya, dza Kasaria yɛɛ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bɛte muntofi bɛ nɔŋa bɛ nɔŋa mɔɔ bikoo bi Bɛjuu lɛ bi kwɛɛŋ lɛ se bɛ le bi ŋɛŋ wu, be se gɛɛ nsa wu be kɛmi bɛ Pɔɔ li wu-u mfwe, be sooŋ bɔ li Fɛstu, ");
INSERT INTO asj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","le doonchɛ shéŋ yi dzeeŋ li be-e, fɛ le bɛ tuumi Pɔɔ Jɛrosalɛŋ. Be tɛ̀ feti lɛ ɛ be saa be kɔɔ ntsooŋ le be tɛɛ Pɔɔ dzetsi. ");
INSERT INTO asj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛstu tuu li bee le, “Pɔɔ wɛ li yih yi ncha-a Kasaria, mi kibɛɛ ŋgii ni ŋkarisi ntuu le li jo yini. ");
INSERT INTO asj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bɛniiŋ bɛ kɛmi buŋga bu nsawu bamu biee mi Kasaria, be tee fiee fi wu chɔ nuuŋ le, ɛ nuuŋ le fiee fiɛɛ lu.” ");
INSERT INTO asj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Le Fɛstu tsi bee be gɛɛŋ bo si jo nyaaŋ kɛ jo yoofi, se kaari bɔɔ Kasaria. Le bu woo, gɛɛŋ shee li yih yi nsa-a, tee le be bɛ bɛ Pɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Le Pɔɔ fɛsi, Bɛjuu bɛ tɛ̀ dza Jɛrosalɛŋ be bɔɔ fe, be leŋ be kɛnɛ wu, be bɛchi be kayi biee ŋge kii wu nuuŋ yɛ bi didi kɛ, bɛdɛɛni, fiee nuuŋ yɛ lu fi nuuŋ be tee le fi doonchɛ le wu fɛɔ fiee fimu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔɔ taaŋ bɛ kikoo kee tee le, “Mmɛɛŋɔ ki mbondɛ kɛ nchi wu Bɛjuu kɛ dududu, kɛ wu li yih yi muntofi-i, mɔɔ nuuŋ wu Mfɔŋ wu Lom kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Se nuuŋ le, Fɛstu tɛ̀ wɛki le fɛ se Bɛjuu ni be kɔŋgisi wu, se bii li Pɔɔ li laa, “Ɔ kɔŋgisi lɔ le ɔ yɛɛ Jɛrosalɛŋ le mi kibɛɛ ŋgɛɛŋ nsaa nsa wa fe kii biee bini bichu ni?” ");
INSERT INTO asj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔɔ tuu le, “Nlemɔɔ fɛni kituŋ lɛ ŋko wu nsa wu Mfɔŋ wu Lom, ɛ nuuŋ le fɛni fɛ bɛ kɛmi le bɛ saa nsa wɛŋ. Wɛ kibɛɛ ɔ kiiɔ bujɔŋ le mmɛɛŋɔ ki nchɔ-ɔ fiee tɛɛ Bɛjuu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ɛ nuuŋ le mi mbondɛ nchi, mi mfɛ tɛ bubiɛɛ bumu bu nuuŋ bɛ wo mi nuuŋ buwo, nuuŋ ntɛ mfaaŋ kwe kɛ. Se nuuŋ le, ɛ fi nuuŋ le biee bi bɛ sɛyɛ li yi yɛɛŋ bini nuuŋ binsɛɛ, kɛ wi nuuŋ yɛ lu wu nuuŋ nyɛ mi li tsaŋ yi Bɛjuu bani kɛ. Nlɛkɔɔ le nsa wɛŋ gɛɛŋ limfwe fɛ Mfɔŋ wu Lo-om.” ");
INSERT INTO asj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Le Fɛstu woo lɛ, bee bɛniiŋ bɛ bee bɛ tɛ̀ sɛki bɛnsa baa kɔɔ ntsooŋ. Se tee li Pɔɔ li le, “Si ɔ lɛkɔɔ le nsa wa gɛɛŋ fɛ Mfɔŋ wu Lom lɛ, kɛ wu gii wu gɛɛŋ fe.” ");
INSERT INTO asj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Le ni nuuŋ li mfi wumu lɛjiŋ lɛlu, Mfɔŋ Agripa bee Bɛni la ŋka lɛ Fɛli Kasaria le be yɛsi Fɛstu. ");
INSERT INTO asj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Le be tsi fe jo ŋge, Fɛstu beh nsa wu Pɔɔ li Mfɔŋ tee le, “Wumu wɛ fɛni wu Fɛli tɛ̀ shɛ li yih yi ncha-a, ");
INSERT INTO asj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","fɛ ntɛ̀ ŋgɛɛŋ Jɛrosalɛŋ bɛte muntofi bɛ nɔŋa bɛ nɔŋa bɛ bɛniiŋ bɛ sɛki kwɛɛŋ wu Bɛjuu tɛ̀ bɛ bɛ nsa we be gɛɛ mi limfwe be tee le ntee le wu weɔ nsa. ");
INSERT INTO asj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ntɛ̀ ntee li bee le, ntsɛ wu bɛniiŋ bɛ Lom mɛɛŋɔ ki beŋ le bɛ sondɛ nsa wu wi, le wu weɔ nsa, ɛ be mɛɛŋ saa ki nyɛ wu dze, le leŋ lɛ ŋko wu nsa, limfwe li bɛniiŋ bɛ bee be kɛmi nsa taaŋ bɛ kikoo kee li biee bi bɛ kayi li wu. ");
INSERT INTO asj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mfi wu be bɛchu tɛ̀ bɛ fɛni, ntuu mɛɛŋ ki ŋɔɔnɛ kɛ. Le bu woo, ŋgɛɛŋ nshee li yih yi nsa ntee bɛ bɛ wi wulu. ");
INSERT INTO asj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Le bɛniiŋ bɛ bee be tɛ̀ kɛmi nsa baa dza be leŋ we, be ti mɛɛŋ ki doonchɛ kɛ chɔ yi ntɛ̀ mbeechi le be nuuŋ be tee kii wu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Be tɛ̀ tuu be tiiti nuuŋ biee bi bitɛchinɛ li wu kii dze yibe lɛki li Nyɔ-ɔ fe, mɔɔ kii wi wumu wu bɛ teenyi le Jiso wu tɛ̀ kɔɔ wu kwi, bɛdɛɛni se Pɔɔ lemi nɛɛ le mɛɛŋɔ we. ");
INSERT INTO asj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Si ntɛ̀ mɛɛŋ ki ŋkɛɛ kɛ si nuuŋ lɛ lɛ biee bini lɛnti, nse mbii li Pɔɔ li laa, kɔŋgisɔɔ le yɛɛ Jɛrosalɛŋ se bɛ saa nsa we fe kii biee bini le. ");
INSERT INTO asj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Se tuu le gii ba li yih yi ncha-a, le ɛ Mfɔŋ wu gii sondɛ nsa we. Nse ntee le be gɛɛ wu li yi, bɛ ni bɛ kiichi wu nsiiŋ gɛɛŋ bo mfi wu ŋgii ntuumi wu li Mfɔŋ wu Lom.” ");
INSERT INTO asj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Le Agripa yikɛ ni, tee li Fɛstu le, “Mi kibɛɛ ŋkɔŋgisɔɔ nlee ŋ'woo biee bini lɛ kifimɛ ki wi wulu.” Fɛstu tuu le, “Ɔ gii ɔ bo ɔ woo fwaa.” ");
INSERT INTO asj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Le bu woo, Agripa bee Bɛni deŋgi be bɛɛ bɛ buchuuŋ bu nɔŋa. Bee bɛte bikoo bi bɛniiŋ bɛ nchi mɔɔ bɛniiŋ bɛ nɔŋa bɛ nɔŋa bɛ bi bito-oŋ be dɛndɛ be bɛ be lɛ li yih yi nlɛkɛ li Nyɔ-ɔ. Se Fɛstu tee le be bɛ bɛ Pɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Si be tɛ̀ bɛ bɛ wu, Fɛstu tee le, “Mfɔŋ Agripa, bɛniiŋ bɛchu bɛ nuuŋ fɛni, nɛ ŋɛŋ baa wi wuni. Ɛ wi wu Bɛjuu bɛchu bɛɛ be fieŋgisi mi fɛni mɔɔ Jɛrosalɛŋ kii wu, be dzɛŋgi be tiiti le ɛ wi wu bɛ nuuŋ bɛ gɛɛ le ni nuuŋ lu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nse mmɛɛŋɔ ki ŋɛŋ le wu fɛɔ fiee fi bɛ nuuŋ bɛ wo wu kɛ. Si tuu saa wu lɛkɛ le nsa we gɛɛŋ limfwe nuuŋ li Mfɔŋ wu Lom, mi nse ŋɛŋgɔɔ le ŋgii ntuumi wu lɛ wuu. ");
INSERT INTO asj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Se nuuŋ le, mgbɛŋgi yɛ ŋkii fiee fi nuuŋ ntsɛɛ li Mfɔŋ wu te kikoo keŋ kii wi wuni kɛ. Se nuuŋ le, nse nleekɔɔ wu li benɛ lii dɛɛni, teege li wɛ-ɛ lii kibɛtɛɛ Mfɔŋ Agripa, le nɛ taashɛ lɛ nsa we-e, ke se ŋkɛmɛ fiee fi nuuŋ ntsɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mi ŋɛŋgɔɔ fi nuuŋ yɛ bujɔŋ le ntuumi wi wu ncha li Mfɔŋ mɛɛŋ ki ndoonchɛ kɛ fiee fi bɛ tee le wu fɛɔ kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mfɔŋ Agripa se tee li Pɔɔ li le, “Ɛ kintsii ko dɛɛni le yɔ bɛ kimfimɛ ko.” Pɔɔ se tsaaki kibɛnɛ kee liwe, bɛchi tɛɛndi bɛ kikoo kee, tee le, ");
INSERT INTO asj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Buri, mi ŋɛŋgɔɔ le ŋkɛmɔɔ kishi ŋge bɛŋ yani le nleŋ ntaaŋ kikoo keŋ li bushi bwo-o, li biee bichu bi Bɛjuu kayi kii mi. ");
INSERT INTO asj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ntiiti nɛɛ lɛ, kifɛ mgbɛŋgɔɔ kii ntsɛ wu kwɛɛŋ wu Bɛjuu mɔɔ bitɛchinɛ bi be shiiŋ be kɛmi. Se nuuŋ le, nse nlɛkɔɔ le be yikɛ nyɛɛkii, be woo fiee fi ŋgii ntee. ");
INSERT INTO asj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Bɛjuu bɛchu kii baa ntsɛ wɛŋ mbɛɛchɛ fɛ ntɛ̀ mɛɛŋ sɔɔnɛ wi. Be kii baa si ntɛ̀ tsiiŋ li kwɛɛŋ wɛŋ mɔɔ Jɛrosalɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Be kii baa bujɔŋ mbɛɛchɛ lindɛɛri le nuuŋ wi wu kintutu ki Bɛfarasii, kintutu ki gbɛŋgi ki tɛɛmi li fiee fi Nyɔ-ɔ ki yɛki bintutu bimu bichu. Fini nuuŋ fiee fi ɛ be kɔŋgisi le be tee, be beŋ le ɛ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nse nlemɔɔ fɛni dɛɛni li nsa kifɛ mbichɔɔ limfwe, ŋkii ŋkaachɛ wu Nyɔ tɛ̀ kaachɛ bɛtaa bɛsɛŋ lu. ");
INSERT INTO asj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ŋkaachɛ wuni nuuŋ wu bini bisɛŋ bi yoofi ntsɔ bifɛ tɛŋgi biɛɛ, si bi lɛki li Nyɔ-ɔ butuu mɔɔ fɛnshaaŋ. Buri, ɛ kii ŋkaachɛ wuni wu Bɛjuu kɛmi nsa tɛɛ be. ");
INSERT INTO asj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nse mbiitɔɔ li bee mɔɔ li bɛniiŋ bɛchu laa, fi ge la fi nɛ ŋiŋgi fi tɛɛmi le nɛ beŋ le Nyɔ nuuŋ yi buu wi li kwe-e le? ");
INSERT INTO asj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mi kibɛɛ ntɛ̀ gbɛŋgi mbeechi le ŋkɛmi le mfɛ fiee fichu le nlɛɛshɛ bukooŋ bu Jiso wu Nasarɛ. ");
INSERT INTO asj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Fini gbɛŋgi fi nuuŋ fiee fi ntɛ̀ mfeti Jɛrosalɛŋ. Ntɛ̀ fi buŋga li bɛte muntofi-i bɛ nɔŋa bɛ nɔŋa ŋkɔɔyi bɛniiŋ bɛ nuuŋ bɛ Nyɔ-ɔ ŋge, mfɛti be li yih yi ncha-a. Se nuuŋ le, tɛ̀ nuuŋ yɛ fini kwaa kɛ. Fɛ bɛ nuuŋ le bɛ gii bɛ woyɛ be, kɛ ŋgii mfɛfi. ");
INSERT INTO asj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ntɛ̀ nyɛɛ ŋgɛ li bee li mfi li mfi li yí yi nlɛkɛ li Nyɔ-ɔ chichi, ŋgwɛnini le be ni be yeti n'yɔru wu bifi kii wi wu Jiso. Shéŋ fuuti mi bɛ be ŋge, nse mbiindi bikaa lɛ be jiŋ, ŋgiiŋgi mbuti li bitoŋ bi tɛɛŋ yimi. ");
INSERT INTO asj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ntɛ̀ ndza le giiŋgɔ Damako, ɛ bɛte muntofi bɛ nɔŋa bɛ nɔŋa tɛ̀ tsɛɛ kiŋwaati, be nyɛ mi buŋga. ");
INSERT INTO asj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Buri, le ni ŋgiiŋgi tɛ̀ nuuŋ fɛnshaaŋ kintikinti, ntaa ndza ŋɛŋ si kiŋ'wofu kimu dza ki lɛbi liboo ki wuuti ki yɛki jobɛ, ki shee li tɛɛ bɛniiŋ bɛ tɛɛ be tɛ tɛ̀ deŋgi. ");
INSERT INTO asj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tɛ dza tɛ weyɛ fɛkwiiŋ bee bɛchu, ŋ'woo si jɛ bii li mi lɛ jɛ́ yi Hiburu le, ‘Sɔɔ, Sɔɔ, ɔ biindi bikaa lɛ mi jiŋ kii la? Ɔ fetɔɔ ni, ɔ juti nuuŋ yi ya, si sɔmbwaa wu nimɛ wu juti yi li kimbaaŋ ki tee lɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nse mbii laa, ‘Ɛ wɛ noo Taa?’ Tuu le, ‘Ɛ mi Jiso, wɔɔ biindi bikaa lɛ wu jiŋ. ");
INSERT INTO asj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Dza ɔ leŋ we. Fiee fi fɛ se mi mbusɛ lɛ wɛ lii nuuŋ le ntsaa wɛ si wi wɛŋ wu nimɛ, se ɔ ni ɔ tiifi biee bi ɔ ŋɛŋ bɛŋ bɛ bi mɛɛŋ nse doonchɛ li wɛɛ. ");
INSERT INTO asj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ŋgii mfi wɛ li tsaŋ yi Bɛjuu mɔɔ bɛniiŋ li bɛ nuuŋ yɛ Bɛjuu kɛ, nuuŋ be bɛ ŋgii ntoŋ wɛ lɛ bee. ");
INSERT INTO asj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ɔ gii ɔ gɛɛŋ ɔ gwiyɛ lii yibe, ɔ buu be li kijibɛ-ɛ, ɔ leeki be li kiŋ'wofu, be se bo li tsaŋ yi Sataŋ, be to bɛ Nyɔ, be gɛɛ shéŋ li mi, Nyɔ feeki bibifi bi bee. Be se kɛmɛ kimbɛ fɛ kintsii ki bɛniiŋ bɛ wu fɛ le ɛ bee.’ ");
INSERT INTO asj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Buri, si fi tɛ̀ kɛti nɛɛ ni, nse mfɛ nɛɛ si tɛ̀ tee li mi liboo. ");
INSERT INTO asj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nse mbɛchi ntiifi Damako, nse ndza ŋgɛɛŋ Jɛrosalɛŋ. Mbɛchi ndeŋgi li nshɛ yi Judiya chichi mɔɔ tɛɛŋ chichi yi tɛ̀ nuuŋ yɛ yi Bɛjuu kɛ, ntiifi be le be fiiki shéŋ yibe, be to bɛniiŋ bɛ Nyɔ-ɔ, be ni be feti tɛ nuuŋ biee bi doonchi le be fiiki baa shéŋ yibe kituŋ. ");
INSERT INTO asj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Fiɛɛ fiee fi tɛ̀ fɛ Bɛjuu kɔɔ mi li yih yi muntofi-i be wɛki le be wo mi. ");
INSERT INTO asj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Se nuuŋ le, Nyɔ se fii mi nsiiŋ bɛ bo bɛŋ. Se nlemɔɔ fɛni ntiifi li bɛniiŋ bɛ nɔŋa-a mɔɔ bɛ ntɛŋ. Se fiee fi ntiifi nuuŋ nɛɛ fi Mɔɔsɛ bɛ bɛntomfɔŋ bɛ Nyɔ-ɔ tɛ̀ tiifi le fi nuuŋ fi ka. ");
INSERT INTO asj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Be tɛ̀ tiiti le, kinsofu ki Nyɔ tɛ̀ kaachɛ kɛmi le ki bɛ ki ŋɛŋ ŋgɛ ŋge, se ki nuuŋ wi wu ŋkosi li mbochu li kwe-e, ki doonchɛ kiŋ'wofu li Bɛjuu li mɔɔ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Si Pɔɔ tɛ̀ gii tɛɛndi bɛ ki kikoo kee giiŋgi limfwe lɛ, Fɛstu dza waŋ lɛwe ŋge le, “Pɔɔ jetɔɔ bu jeru. Laanchɛ wa wu ŋge wɛɛ dza wɛ wu fɛ ɔ jeti nuuŋ bu jeru.” ");
INSERT INTO asj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pɔɔ tuu li Fɛstu le, “Njeti yɛ kɛ wi wu nyɔŋa. Fiee fi ntiiti nuuŋ chɛɛŋ, nse ntiitɔɔ bɛ bufii bweŋ fe. ");
INSERT INTO asj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ntiitɔɔ li Mfɔŋ gbanaa ni, kifɛ be kii baa le biee bini tɛ kɛti yɛ lɛ munyiikɔɔ li kɛ, fimu nuuŋ yɛ lu fi be tɛ kii yɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Buri, mɔɔ be beŋ baa li biee bi lɛ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ? Ŋkiiɔ le be beŋ baa.” ");
INSERT INTO asj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Mfɔŋ Agripa bii li Pɔɔ li laa, “Ɔ beechi le ɔ nuuŋ ɔ fiiki mi nto wi wu Krai li mfi niiŋ li ni?” ");
INSERT INTO asj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔɔ tuu le, “Dɛɛŋ li mfi fi niiŋ li, kɛ li mfi wu ŋge lee, nlɛkɛ wɛŋ li Nyɔ-ɔ nuuŋ yɛ li wɛ kwaa kɛ. Wi kwikwi wu nuuŋ fɛni bɛŋ wuki si ntiiti, fiiki tɛ to si mi, fuki nɛɛ bɛncha bani kwaa siŋ.” ");
INSERT INTO asj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mfɔŋ dza we, bee ŋgɔmina mɔɔ Bɛni bee bɛniiŋ bɛ bee be tɛ̀ shee fe baa dza we tɛ. ");
INSERT INTO asj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Be bo, be yeti be be le, “Wi wuni mɛɛŋɔ ki fɛ fiee fi bɛ nuuŋ bɛ wo wu buwo kɛ, kɛ le bɛ gɛɛ wu li yih yi ncha-a kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Mfɔŋ Agripa se tee li Fɛstu le, “Bee nuuŋ yɛ le wi wuni ni mɛɛŋ ki lɛkɛ kɛ kituŋ le nsa we gɛɛŋ fɛ Mfɔŋ wu Lo-om kɛ, bee bɛ chinɛ li wu-u.” ");
INSERT INTO asj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bɛ tɛ̀ nachɛ le tɛɛ Pɔɔ lɛ yih yi li dzɔɔ tɛ̀ gɛɛŋ Itali, se bɛ tuu bɛ nyɛ Pɔɔ bee bɛniiŋ bɛ ncha bamu li tsaŋ yi Julɔ wu tɛ̀ nuuŋ kikoo ki kintutu kimu ki bɛniiŋ bɛ nchi bɛ Mfɔŋ wu Lo-om. ");
INSERT INTO asj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tɛɛ be lɛ lɛ yih yi li dzɔɔ yi dzɛti Adamitum yi tɛ̀ nuuŋ le yi gii yi ni yi giiŋgi yi geeyi li bintsii bi li ŋgemɛ yi dzɔɔ li, kimbɛ ki Eesha. Aristaku wi wu Tɛsalonya, kwɛɛŋ wu Masadonya tɛ̀ nuuŋ tɛ bɛ bee. Tɛɛ be se dza ŋgɛnu. ");
INSERT INTO asj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Butuu woo, tɛ̀ fɛsi Sidɔŋ, se Julɔ doonchɛ kiŋkɔŋgisɛ li Pɔɔ li, chinɛ wu le gɛɛŋ lɛ nsáŋ yee yi li kitoŋ li, le yi ni yi fii wu bɛ fiee fi wɛki. ");
INSERT INTO asj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Se tɛ kaari tɛ lɛ lɛ yih yi li dzɔɔ fe, tɛ dza ŋgɛnu, mbaandze tɛ̀ bɛ tusi bee lijiŋ, se tɛ wɛɛŋ dze yi kwɛɛŋ wu Saaplu wu dzɔɔ kintikinti, wu se baŋgi mfiee yilu. ");
INSERT INTO asj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tɛ gɛɛŋ tɛ lenchi dzɔɔ yi nyɔŋa yi nuuŋ li kwɛɛŋ wu Silisha bɛ kwɛɛŋ wu Pamfila lichiŋ, se tɛ fɛsi li kitoŋ ki Mila-a, ki li kwɛɛŋ wu Lisa-a. ");
INSERT INTO asj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Se kikoo ki kintutu ki bɛniiŋ bɛ nchi-i kɛɛ ŋɛŋ yih yi li dzɔɔ fe yi tɛ̀ dza Alɛkɛsanda yi giiŋgi Itali, biee buu bee, gɛɛ lɛ yɛɛ li. ");
INSERT INTO asj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tɛ dza fe, tɛ deŋgi wɛɛ li jo ŋge li, tɛ liiŋgi se tɛ fɛsi li kitoŋ ki Sinidu lichiŋ. Si mbaandze wɛ ti mɛɛŋ ki be-eŋ le tɛ gɛɛŋ limfwe tsaaŋ kɛ lɛ, tɛ se ya tɛ baanshi dze yi Klɛt kwɛɛŋ wu dzɔɔ kintikinti, wu baŋgi mbaandze wɛ, tɛ se ka Samoni kintsii ki tɛ tɛ̀ gɛɛŋ tɛ lɛ dzɔɔ yi li kwɛɛŋ wulu. ");
INSERT INTO asj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Se tɛ ba nɛɛ tɛ baanshi tɛ tuu li ŋgemɛ yi dzɔɔ li, tɛ tɛ̀ bɛ tɛ liiŋgi bu liiŋgisɛ se tɛ gɛɛŋ tɛ bo bintsii bi bɛ teenyi le Wooŋ wu Dzɔɔ yi Shiiŋ, ɛ wu tɛ̀ nuuŋ li kitoŋ ki Lasa lichiŋ. ");
INSERT INTO asj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Si tɛ tɛ̀ saa tɛ biifi mfi lɛ dze ŋge lɛ, Jobɛ chi Nɔŋa chi Mfekisɛ Bibifi tɛ̀ ka kituŋ, nuuŋ mfi wu mfiee yi tɛɛmi, Pɔɔ se nyɛ ntifi li bɛniiŋ bɛ li yih yi li dzɔɔ baa le, ");
INSERT INTO asj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Bɛtaa, ŋiŋgɔɔ le mbɛɛchɛ fɛni ŋgɛnu limfwe, ndɛndɛ wu tɛɛbeŋ gii bee, kinla gii ki nuuŋ lu, ki nuuŋ tɛ nuuŋ nɛɛ ki biee bi lɛ yih yi li dzɔɔ li kwaa kɛ, bɛniiŋ gii be kwiyɛ nɛɛ tɛ.” ");
INSERT INTO asj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Se nuuŋ le, kikoo ki bɛniiŋ bɛ nchi tɛ̀ mɛɛŋ ki beŋ ntifi yi Pɔɔ kɛ, woo fiee nuuŋ li te kikoo wu yih yi li dzɔɔ bɛ te yih yi li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Si ŋgemɛ yi dzɔɔ yilu tɛ̀ mɛɛŋ ki dzɔɔŋ kɛ le be ni be nuuŋ fe li mfi wu mfiee yi tɛɛmi wɛɛ kɛ, bɛniiŋ ŋge se fɛfi le fi dzɔɔŋ le bɛ gɛɛŋ limfwe, bɛ mɔŋ laa nuuŋ bɛ fɛsi li ŋgemɛ yi dzɔɔ yi Fonik le, yi nuuŋ li kwɛɛŋ wu Klɛt wulu, le tɛ lɛ mfi wulu fe. Wooŋ wu dzɔɔ yilu tɛ bichi dze yi wewe wu tuu wu bichi tɛ dze yi kwiiŋkwiiŋ lɛ jobɛ sechi. ");
INSERT INTO asj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mfiee yimi tɛ̀ dza yi yɛki dze litɛ ni wɛɛ, bɛniiŋ bɛ yih yi li dzɔɔ lɛ baa bɛɛchi be beechi le be kɛmɛ baa fiee fi be wɛki. Be se buu kifasɛ ki yih yi li dzɔɔ, be se ŋgiiŋgi li dzɔɔ, be tuu nɛɛ li ŋgemɛ li ŋgemɛ Klɛt wulu. ");
INSERT INTO asj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kiŋkuŋku ki tɛɛmi ki bɛ teenyi le, “Ki kimbɛ ki kibɛnɛ ki kimɛsɛ lɛ jobɛ tɛti,” ki dza li kwɛɛŋ wulu, ki shee li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Si ki shee lɛ, ki ju yih yi li dzɔɔ se dze ti mɛɛŋ ki nuuŋ lu yi gɛnɛ li ki kɛ, be se chinɛ li yih yi li dzɔɔ yilu-u, kiŋkuŋku kilu too ki giiŋgi bɛ yi. ");
INSERT INTO asj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tɛ ba tɛ giiŋgi lɛ, tɛ gɛɛŋ tɛ ka kwiiŋkwiiŋ li kwɛɛŋ wumu wu ŋkwɛŋ, dzɔɔ kintikinti wu bɛ teenyi le Kawda. Kwɛɛŋ wulu tɛ̀ baŋɛ bee mfiee yilu, tɛ se bɛchi tɛ gwenini le tɛ yɛɛki ŋgo lɛ yih yi li dzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Le tɛ yɛki wu, tɛ kaŋ ŋgo wulu bɛ bɛkuu kii ni shaanshɛ, tɛ giiŋgi tɛ chɛndi le yih yi li dzɔɔ gii yi taa yi gɛɛŋ yi ju yi li kwɛɛŋ wu Saatis, li bikumu bi mfwɛɛ bi nuuŋ li dzɔɔ. Be se shiiki ndu yi mfiee, be chinɛ le yih yi li dzɔɔ li yi giiŋgi lɛ yi-i bɔ. ");
INSERT INTO asj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Si kiŋkuŋku kilu tɛ̀ tɛɛmi nɛɛ ki giiŋgi lɛ, le butuu woo, be se bɛchi be buushi biee lɛ yih yi li dzɔɔ li, be lendi li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Le butuu bo buwoo, se bɛniiŋ bɛ yih yi li dzɔɔ li baa buushɛ biee bi li yih yi li dzɔɔ li be lɔnyɛ li dzɔɔ lɛ be bɔ. ");
INSERT INTO asj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Jo tɛ̀ ka ŋge yi tɛ tɛ̀ mɛɛŋ ki ŋɛŋ jobɛ kɛ muntsɔŋ kɛ, kiŋkuŋku buki nɛɛ nuuŋ yɛ ki wɛɛ kɛ, se tɛ kɛɛ le fisɛŋ ma fiɛɛ le mbochu lu mɛɛŋ yɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Si bɛniiŋ tɛ̀ tsi jo ŋge njɛ fiee siŋ lɛ, Pɔɔ dza kiiŋgi leŋ limfwe, tee le, “Bɛtaa, tuu nuuŋ le nɛ woo li mi le tɛ ba Klɛt, bee tɛ kɛmɛ-ɛ ŋgɛ wuni bɛ kinla kini ni kɛ. ");
INSERT INTO asj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Se nuuŋ le, nlɛkɔɔ le nɛ kɛmɛ shéŋ, kifɛ wi wumu li beŋ li nuuŋ tɛ la kɛ, ɛ nɛɛ yih yi li dzɔɔ kwaa yi gii yi la. ");
INSERT INTO asj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ntiitɔɔ ni kifɛ Nyɔ yi kɛmi mi, yi nlɛki li yi, bee yi toŋ nchindaa we butuu bu bɛŋ wu bɛ wu leŋ li mi lichiŋ, ");
INSERT INTO asj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Wu tee li mi le, ‘Pɔɔ, kiiŋ ɔ ni chɛŋ kɛ. Ɔ kɛmi lɔɔ leŋ limfwe li Mfɔŋ wu Lom. Bichɛ ɔ ŋɛŋ, Nyɔ doonchɛ yɛ kiŋkɔŋgisɛ li wɛ kituŋ, yi fɛ le wumu li kintutu ki bɛniiŋ bɛ nɛɛ be nuuŋ lɛ yih yi li dzɔɔ li bani nuuŋ tɛ la kɛ.’ ");
INSERT INTO asj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Se nuuŋ le, bɛtaa, kanɛ yɛŋ shéŋ. Mi ŋgɛɛɔ shéŋ li Nyɔ-ɔ le fiee fi yi tee li mi gii fi ka nɛɛ si yi tee. ");
INSERT INTO asj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Si fi nuuŋ lɛ, yih yi li dzɔɔ kɛmi yɛ le ju yi li kwɛɛŋ wumu wu dzɔɔ kintikinti.” ");
INSERT INTO asj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Le bɛ bo jo yoofi ntsɔ naa, kiŋkuŋku mɛɛŋ nɛɛ ki nduŋgi bɛ bee li dzɔɔ yi nyɔŋa yi Adaya. Le ni nuuŋ si butuu kintikinti lɛ, bɛniiŋ bɛ nindi lɛ yih yi li dzɔɔ li dza be beechɛ le semukɛ be buti baa li nshɛ lichiŋ. ");
INSERT INTO asj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Le be fichɛ dzɔɔ si yi sechi bɛ kuu wu be tɛ shiŋɛ fiee lu, be ŋɛŋ le yi yɛ bɛntaŋ mbaamfiɛɛ. Le be kiiŋgi limfwe niiŋ, be tuu be fichɛ, be ŋɛŋ le yi to yɛ kituŋ bɛntaŋ yoofi ntsɔ bɛtiinu. ");
INSERT INTO asj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Be se bɛchi be chɛndi le nuuŋ yih yi li dzɔɔ ju yi li bimba-aŋ, be se shiiki bifasu binɛɛ li dzɔɔ lɛjiŋ lɛ yih yi li dzɔɔ li, be se lɛki le butuu woo kwaa. ");
INSERT INTO asj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bɛniiŋ bɛ nindi li yih yi li dzɔɔ li baa tɛ̀ dza be wɛki le be letɛ be bo lɛ yih yi li dzɔɔ li, be se shiiki ŋgo wɛ li dzɔɔ, be bɛchi be yɛŋgi le be wɛki baa le be shiiki bifasu limfwe li yih yi li dzɔɔ li, li dzɔɔ. ");
INSERT INTO asj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pɔɔ se tee li kikoo ki bɛniiŋ bɛ nchi mɔɔ li bɛniiŋ bee li le, “Ɛ bɛniiŋ bani mɔŋ le be bo lɛ yih yi li dzɔɔ yini-i, kɛ mɔɔ nuuŋ wi mumkpaŋ li beŋ nuuŋ tɛ bo lu kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Se bɛniiŋ bɛ nchi-i baa soomɛ bɛkuu bɛ be tɛ̀ sootɛ ŋgo baa, be se chinɛ le ni deŋgi li dzɔɔ li liwe giiŋgi. ");
INSERT INTO asj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Le butuu bɛchi ŋ'wofu, Pɔɔ lɛkɛ bɛniiŋ bɛchu le be ji biee, tee le, “Bɛŋ yaa jo yoofi ntsɔ naa yi nɛ baa li chɛnɛ, fiee mɛɛŋ ki lɛ-ɛ lɛ benɛ wa kɛ. ");
INSERT INTO asj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nse nlɛkɔɔ le nɛ ji fiee, se yih yinɛ to beŋ fe. Nuuŋ yi mumkpaŋ tɛ̀ la li wi fa kɛ.” ");
INSERT INTO asj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Si wu tee lɛ, dzɔ kibele, nyɛ kiyɔɔni li Nyɔ-ɔ, bootɛ bɛchi jii lɛ bɛniiŋ bɛchu lii. ");
INSERT INTO asj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Be se kaŋ shéŋ be bɛchu be ji biee. ");
INSERT INTO asj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bee bɛchu bɛ tɛ̀ nuuŋ lɛ yih yi li dzɔɔ li tɛ nuuŋ wi gii fɛɛ kitsɔ gwii mfomɛnyaaŋ ntsɔ busɔɔ (276). ");
INSERT INTO asj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bɛniiŋ bɛchu tɛ ji biee be fukɛ, be se buu giiŋ yi tɛ̀ nuuŋ lɛ yih yi li dzɔɔ li, be lɔŋ li dzɔɔ le be fɛ le wu fuutɛ. ");
INSERT INTO asj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Le butuu woo, lɛ bukaka yenɛ, bɛniiŋ bɛ nindi li yih yi li dzɔɔ li tɛ̀ kii yɛ kintsii kilu kɛ. Se nuuŋ le, be se ŋɛŋ kibwaŋ, ɛ ki gɛɛŋ nsiiŋ ki bo li mfwɛɛ, be ŋɛŋ le be mɔnchɛ yih yi li dzɔɔ le yi lɛ yi gɛɛŋ yi tsi li mfwɛɛ mɛlu li ŋgemɛ yi dzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Be se soomɛ bifasu bi shee bi gɛɛŋ li dzɔɔ, be tuu be kaari be fanchɛ bɛkuu bɛ be tɛ̀ sooyɛ biti bi bɛ ti fiki yih yi li dzɔɔ lu, be yɛɛki tɛ ndu yi mfiee limfwe se mfiee lɛ le, yi tuu yi kiiŋgi yih yi li dzɔɔ yi gɛɛŋ lɛ kibwa-aŋ kilu. ");
INSERT INTO asj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Se nuuŋ le, le giiŋgɔ, ju yi li kikumɛ ki mfwɛɛ li dzɔɔ. Se kimbɛ ki yih yi li dzɔɔ ki limfwe lɛ ki findɛ limfwe ki ba ki tɛ̀ tuu le ki sɛɛsɛ kɛ. Se dzɔɔ juti kimbɛ ki lɛjiŋ ki shaanshi. ");
INSERT INTO asj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bɛniiŋ bɛ nchi se dza be wɛki le be woyɛ bɛniiŋ bɛ ncha-a bɛchu le kiiŋ wumu li bee ni dza tandɛ dzɔɔ bo letɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Se nuuŋ le, kikoo ki bɛniiŋ bɛ nchi tɛ̀ wɛki le ki soo Pɔɔ, se faaŋ le kiiŋ be ni fɛ lɛ kɛ, tee fiee le bɛniiŋ bɛ kii tandinɛ dzɔɔ saa be seri li dzɔɔ, be tandɛ be bo li bukaka kwɛ, ");
INSERT INTO asj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","se kiŋkɛ ki bɛniiŋ lɛ ni ki biki li biŋkɛ bi bimbachɛ, kɛ li binshaanshɛ bi yih yi li dzɔɔ li. Bɛdɛɛni se tɛ dɛndɛ tɛ fɛsi li bukaka wi mɛɛŋ ki la kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Si tɛ tɛ̀ fɛsi wi mɛɛŋ ki laa kɛ lɛ, tɛ woo le bɛ teenyi kintsii kilu le Maata, kwɛɛŋ wulu nuuŋ dzɔɔ kintikinti. ");
INSERT INTO asj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bɛniiŋ bɛ li kwɛɛŋ wulu doonchɛ kiŋkɔŋgisɛ li bee li, nuuŋ yɛ ki didi kɛ, be fi bee, be kukɛ wi tɛ wɔɔnsi, kifɛ dzaaŋ tɛ̀ bɛchi yi bɛɛ mfiee guti bee. ");
INSERT INTO asj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔɔ dza banchɛ ŋgaŋ le kukɛ, ɛ fifaa tɛ̀ nuuŋ li ŋgaŋ yilu linti, wi yuusɛ wu fɛ fi se bo, fi núŋ kibɛnɛ kee fi shiŋɛ lu. ");
INSERT INTO asj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bɛniiŋ bɛ li kwɛɛŋ wulu ŋɛŋ si fi shiŋɛ li kibɛnɛ kee li lɛ, be bɛchi be tiiti li yih yibe le, “Wi wuni wɛ nuuŋ wi wu woyi bɛniiŋ. Wu kifɔɔ wu bo li dzɔɔ, bɛdɛɛni, nyɔ yisɛŋ kɔɔ yɛ wu, gii kwi.” ");
INSERT INTO asj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Se nuuŋ le, Pɔɔ se sɛɛsɛ fifaa filu fi we fɛ wi, fiee fimu mɛɛŋ wu ki ge kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bɛniiŋ bɛlu se tɛŋgi, be beechi le yih yi Pɔɔ gii yi bɛchi yi ni yi muchi, kɛ le gii taa dza we kwi. Be se taaŋ be taaŋ nsiŋ, be ŋɛŋgɛ le fiee mɛɛŋ fiɛɛ ki ge wu kɛ, be dza be fiiki mbeechɛ wu be, be dza be kweŋgi nuuŋ le, “Wi wuni wɛ nuuŋ nyɔ yimi.” ");
INSERT INTO asj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Wi wu sɛki fe tɛ̀ kɛmi yɛh yee nɛɛ tsɛkɛ fɛ tɛ tɛ̀ nuuŋ. Bukooŋ bu wi wulu tɛ̀ nuuŋ le Publu. Fi bee, tɛɛ tsi bɛ wu jo taa, bichi lɛ bee li bujɔŋ. ");
INSERT INTO asj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Fi ka le te Publu wulu tɛ̀ gimi bɛ chigɔŋ chi kiŋkɛŋkɛ mɔɔ mfwamfu ŋgɔŋ. Pɔɔ se tuu gɛɛŋ fɛ tɛ̀ gimi, lɛkɛ li Nyɔ-ɔ, gɛɛ tsaŋ li wu bwiiŋ wɔnchɛ wu. ");
INSERT INTO asj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Le fi ka lɛ, bɛniiŋ bɛ li kwɛɛŋ wulu bɛchu bɛ tɛ̀ kɛmi chigɔŋ bɛchi be bɛɛ Pɔɔ se wɔnchi be tɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Be se bɛchi be nyɛɛ bee biee ŋge. Le tɛ ni tɛ dzɛti fe, be tuu be bɛ bɛ biee bichu bi tɛ tɛ̀ wɛki be gɛɛ lɛ yih yi li dzɔɔ li. ");
INSERT INTO asj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tɛ lɛ lɛ yih yi li dzɔɔ li tɛ giiŋgi, ɛ tɛ tɛ̀ tsi Maata kwɛɛŋ wu dzɔɔ kintikinti wɛɛ, kii tɛɛ. Yi yi li dzɔɔ yilu tɛ nuuŋ yi Alɛkɛsanda bɛ teenyi yi le Bɛnyɔ bɛ Maaŋ, ɛ yi tɛ̀ nuuŋ li kwɛɛŋ wulu yi tɛŋgi le mfi wu mfiee yi tɛɛmi yilu ka. ");
INSERT INTO asj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tɛ se gɛɛŋ tɛ bo li ŋgemɛ yi dzɔɔ yi li kitoŋ ki Silaku, tɛ tsi fe jo taa. ");
INSERT INTO asj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Le tɛ dza fe, tɛ gɛɛŋ tɛ fɛsi li ŋgemɛ yi dzɔɔ yi li kitoŋ ki Lɛgium tɛ tsi fe. Butuu woo, mfiee bɛchi yi yɛki dze litɛ, tɛ dza tɛ giiŋgi, le bo jo faa, tɛ fɛsi li ŋgemɛ yi dzɔɔ yi Potoli-i. ");
INSERT INTO asj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Si tɛ tɛ̀ fɛsi fe lɛ, tɛ ŋɛŋ bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ fe, be lɛkɛ bee le tɛ gɛɛŋ tɛ tsi bɛ be jo mfomɛnyaaŋ. Tɛɛ be tɛ tsi, se tɛ dza tɛ gɛɛŋ tɛ fɛsi Lom. ");
INSERT INTO asj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Si tɛ tɛ̀ giiŋgi lɛ, bɛniiŋ bɛ kimbeenchɛ-ɛ bɛ Lom tɛ̀ woo le tɛ bɛɛ baa, be bo be deŋgi be bɛɛ le tɛɛ be tɛ bikɛ. Be bɛ siiŋ be bo fɛ Waŋ wu Apiyu, mɔɔ fɛ Yi yi Bɛniiŋ bɛ Ndɛndɛ-ɛ fufini fe. Pɔɔ ŋɛŋ be, shéŋ yee dɛŋ, nyɛ kiyɔɔni li Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tɛ bɛ tɛ fɛsi Lom, bɛ gɛɛ le Pɔɔ ni tsiiŋ wuu mbiiŋ, wi wu nchi kiichi wu. ");
INSERT INTO asj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Le jo ka taa, Pɔɔ teeŋ bikoo bi Bɛjuu bi fe. Bi bɛ, tee li bi le, “Bɛŋwaanɛŋ, mi ŋ'wɛ li ncha ni ɛ bɛ tɛ̀ kɔɔ mi Jɛrosalɛŋ bɛ nyɛ mi li tsaŋ yi bɛniiŋ bɛ Lom, mmɛɛŋ ki nchɔ-ɔ mɔɔ fiee li bɛniiŋ bɛsɛŋ mɔɔ li ntsɛ wu bɛtaa bɛsɛŋ wumu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bɛniiŋ bɛ Lom bɛlu tɛ̀ bichɛ lɛ nsa wɛŋ, be ti mɛɛŋ ki ŋɛŋ fiee fi nuuŋ be wo mi kii fi kɛ. Be se tɛ̀ wɛki le be chinɛ li mi, ");
INSERT INTO asj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","bɛdɛɛni, Bɛjuu faaŋ bu faaŋu. Nse ntɛ̀ ŋkɛmi le nlɛkɛ le nsa wɛŋ gɛɛŋ limfwe fɛ Mfɔŋ wu Lom. Ntɛ̀ mfeti yɛ ni le ŋkɛmɔɔ fiee fi nuuŋ nɛ ŋkɔɔ bɛniiŋ beŋ lu kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Fiɛɛ fiee fi fɛ mi nse nteeŋ beŋ le tɛɛbeŋ tɛ tee biee. Mi ŋ'we li bɛncha bani ni nuuŋ kii wi wu bee bɛniiŋ bɛ Isɛlɛɛ tuu tɛ tɛŋgi.” ");
INSERT INTO asj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bɛniiŋ bɛlu tuu li wuu le, “Tɛ mɛɛŋ baa ki kɛmɛ kɛ Kiŋwaati ki dza Judiya kii wɛ kɛ, wi wumu li bɛŋwaanɛŋ bɛsɛŋ bɛ dzɛti fe be bɛɛ fɛni mɔɔŋ ki jisi kɛ fiee kii wɛ, kɛ le tee fiee fi bifi kii wɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Se nuuŋ le, tɛ gii tɛ kɔɔŋgi le tɛ woo wa mbeechɛ. Fi tɛ̀ ka ni nuuŋ nɛɛ kii kintutu kini ki ɔ nuuŋ li ki kini nuuŋ ki bɛniiŋ bɛnisi yi bɛ ki bintsii bichu kii ki.” ");
INSERT INTO asj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Be se gɛɛ jobɛ chi be gii be bɛ Pɔɔ yɔ li bee. Le ni nuuŋ booyaa, bɛniiŋ ŋge banchɛ fɛ tɛ̀ gii tsiiŋ, bɛchi taantaaŋ gɛɛŋ bo lɛ fɛ mfoo, kuti fiee fichu li bee, tiiti kii bumfɔŋ bu Nyɔ-ɔ. Se tuu yeti doonchi biee bi nuuŋ lɛ Kiŋwaati ki bɛnchi bɛ Mɔɔsɛ bɛ lɛ Biŋwaati bi bɛntomfɔŋ bɛ Nyɔ-ɔ kii Jiso, gwenini le fɛ le be beŋ le fiee fi tiiti fini fiɛɛ nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bɛniiŋ bamu beŋ fiee fi tɛ̀ tiiti, bamu faaŋ mbeenchɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Be dza be saaŋgini bebe be buti si Pɔɔ tɛ tuu lɔŋ jɛ le, “Fiee fi Fiana yi Waaŋ tɛ̀ tee li bɛchaa bɛnɛ lɛ kimfimɛ ki ntomfɔŋ wu Nyɔ-ɔ wu Ɛsaya fiɛɛ tɛ̀ gbɛŋgi fi nuuŋ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Yi tɛ̀ kweeŋ le, ‘Gɛnɛ ɔ tee li bɛniiŋ bɛlu le, nɛ gii nɛ ni nɛ yiki biee bujɔŋ bɛdɛɛni nɛ tɛ woo kɛ, nɛ ni nɛ bichi biee bujɔŋ bɛdɛɛni nɛ tɛ ŋɛŋ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Fi fiɛɛ lɛ, kifɛ shéŋ yi bɛniiŋ bɛlu dɛŋ yɛɛ. Be jiinyɛ baa bintooŋ bi bee, be baanyɛ lii yi be. Be fɛ nɛɛ lɛ le kiiŋ lii yibe ni yi ŋiŋgi biee kɛ, bintooŋ bi bee bi woo kɛ biee kɛ, shéŋ yibe ni yi yuusi, be to lijiŋ lɛ mi, nse ŋ'wɔnchɛ be.’” ");
INSERT INTO asj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔɔ se mɛɛshi le, “Nɛ kɛɛ le ntoŋ wuni wu kii si Nyɔ suuti bɛniiŋ wɛ nuuŋ ɛ wu tuumi li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu li kɛ, be gii be woo.” ");
INSERT INTO asj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Si tɛ̀ kweeŋ lɛ, Bɛjuu bɛlu se dza be buti, be tɛchini bi tɛchinɛ li yɔru wulu nuuŋ yɛ wɛɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔ tsiiŋ nɛɛ li yi, yi tɛ suundi bu somfu biya bifɛ, fii bɛniiŋ bɛchu bɛ tɛ̀ bɛɛ lɛ wu. ");
INSERT INTO asj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Fenjisi kii bumfɔŋ bu Nyɔ, tuu tiifi bɛniiŋ kii Taa Jiso Krai, tiiti nchɛnu nsiŋ, wi tɛ baŋɛ wu dze kɛ.");
INSERT INTO asj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ɛ mi Pɔɔ wu ŋwanɛ nimɛ wu Krai Jiso. Nyɔ tɛ̀ teeŋ mi le ni nnuuŋ ŋwanɛ Jiso wu ntoŋ, yi tɛ̀ gɛɛ mi le ni mfenjisi ntoŋ wu yi wu dzeeŋ. ");
INSERT INTO asj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ntoŋ wu dzeeŋ wuni nuuŋ wu Nyɔ tɛ̀ kaachɛ bɛniiŋ lu kɛti li bɛntomfɔŋ bee li, fi fiɛɛ si bɛ tɛ̀ tsɛɛ lɛ Kiŋwaati kee ki waaŋ li. ");
INSERT INTO asj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ntoŋ wulu nuuŋ kii Ŋwani wu tɛ̀ to wiwoŋ, bɛ biɛ wu li kini ki Mfɔŋ Daafi-i. ");
INSERT INTO asj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Jiso Krai nuuŋ wi wu Nyɔ tɛ̀ doonchɛ buŋga bu yi-i li wu-u kɛti li tsaŋ yi Fiana yi Waaŋ li le ɛ wu Ŋwani si yi tɛ̀ buu wu li kwe-e. ");
INSERT INTO asj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ɛ Jiso wu tɛ̀ fɛ, Nyɔ se tsaa mi le ni nnuuŋ ŋwani wu ntoŋ, le nse mfɛ bɛniiŋ bɛ li bitoŋ bichu-u bɛ nuuŋ yɛ Bɛjuu kɛ gɛɛ shéŋ li wu-u, be ni be wuki nuuŋ li wu-u be yɔɔnchi bukooŋ bwee. ");
INSERT INTO asj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nɛ baa tɛ li kintutu ki bɛniiŋ bɛ Nyɔ teeŋ le be ni be nuuŋ bɛniiŋ bɛ Jiso Krai lɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ntsɛkɔɔ kiŋwaati kini li beŋ bɛchu bɛ nuuŋ shéŋ yi Nyɔ bɛ nuuŋ Lom, yi teeŋ yɛ beŋ le nɛ ni nɛ nuuŋ bɛniiŋ bee. Nyɔ Baa wusɛŋ bɛ Taa Jiso Krai doonchɛ beŋ shéŋ yi dzeeŋ be tuu be nyɛ beŋ shéŋ yi mbɛɛŋgii. ");
INSERT INTO asj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ŋ'wɛkɔɔ le nsaa nyɛ kiyɔɔni li Nyɔ yɛɛŋ kii beŋ bɛchu li bukooŋ bu Jiso Krai, kifɛ nshɛ yini chichi tiiti yɛ kii shéŋ yi nɛ gɛɛ li wu-u. ");
INSERT INTO asj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nyɔ yi nnindi li yi-i bɛ shéŋ yɛŋ chi kii mfenjisɛ ntoŋ wu dzeeŋ wu kii Ŋwani lemi yɛ lɛjiŋ lɛ nsa wɛ-ɛŋ le ŋkiimi lɛ be-eŋ mfi kwi li nlɛkɛ li Nyɔ-ɔ wɛ-ɛŋ. ");
INSERT INTO asj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mfi wu nlɛki ntuu nlɛki le ɛ dze nuuŋ yi bo lu, nuuŋ mbɛ lɛ be-eŋ dɛɛni fɛ Nyɔ beŋ, ");
INSERT INTO asj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","kifɛ ŋkɔŋgisɔɔ ŋge le ŋɛŋ beŋ le nyɛ beŋ nya yi fiana, yi fɛ nɛ se ni nɛ tɛɛmi. ");
INSERT INTO asj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Fi fiɛɛ le, tɛ kaaŋgi shéŋ yisɛŋ, shéŋ yi nɛ gɛɛ li Nyɔ-ɔ kaaŋgi yɛŋ se yɛŋ kaaŋgi yinɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bɛŋwaanɛŋ, ŋ'wɛkɔɔ le nɛ kɛɛ le mi nnachɔɔ li kiŋga-a li kiŋga-a le ŋgii mbɛ lɛ be-eŋ, ɛ mi nnachɛ fiee fimu se baŋgi nɛɛ nachɛ wulu. Ŋ'wɛkɔɔ le mbɛ se ŋkɛmɛ ŋ'wechɛ li be-eŋ nɛɛ si ntɛ̀ ŋkɛmɛ li bɛniiŋ bamu bɛ tɛ̀ nuuŋ yɛ Bɛjuu kɛ lɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nimɛ chini chi bɛniiŋ bɛchu chɛɛ mi lɛwe, mɔɔ nuuŋ bɛniiŋ bɛ nuuŋ li kwɛɛŋ wu woo kitu-uŋ, mɔɔ nuuŋ bɛ mɛɛŋ li kijibɛ-ɛ, mɔɔ nuuŋ bɛniiŋ bɛ kɛmi bufii, mɔɔ nuuŋ bɛ mɛɛŋ bibere. ");
INSERT INTO asj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Fiɛɛ nɛɛ fiee fi shéŋ yɛŋ yuusi ŋge le ntifi tɛ ntoŋ wu dzeeŋ li beŋ bɛ nuuŋ Lo-om. ");
INSERT INTO asj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nɛ ni nɛ kii le nnuuŋ yɛ bɛ buya li fiee fi kii ntoŋ wu dzeeŋ wu wu Nyɔ-ɔ kɛ, kifɛ ɛ fe fɛ buŋga bu Nyɔ-ɔ bu suuti wi kwikwi wu gɛɛ shéŋ li yi-i nuuŋ. Ntoŋ wu dzeeŋ wuni saaɔ wu gɛɛŋ nuuŋ li Bɛjuu li wu se tuu wu gɛɛŋ li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Fi fiɛɛ le ntoŋ wu dzeeŋ wuni doonchi dze yi Nyɔ dzeti le wi wɛ tsaaŋ le lɛ yi-i lii. Fini se bɛchi nsiiŋ fi gɛɛŋ fi ma li shéŋ yi mwɛ tɛ̀ gɛɛ li yi-i. Fiɛɛ fiee fi bɛ tsɛɛ le, “Wi wu tsaaŋ gii naa ni tsiiŋ kii shéŋ yi wu gɛɛ li Nyɔ-ɔ.” ");
INSERT INTO asj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ntiiti ni, kifɛ sheŋ yi Nyɔ ti fuuti liboo bɛ bɛniiŋ bɛ faaŋ yi be feti biee bi nuuŋ yɛ tsaaŋ kɛ, kiŋge kibee ki bifi lɛɛshi chɛɛŋ wu kii biee bi Nyɔ-ɔ. ");
INSERT INTO asj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Yi fuuti ni kifɛ fiee fi bɛniiŋ nuuŋ be kɛɛ kii Nyɔ fiɛɛ gbanaa, kifɛ yih yi Nyɔ doonchɛ yɛ li bee. ");
INSERT INTO asj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Fɛ mbɛɛchɛ, si Nyɔ tɛ̀ tɔŋ nshɛ, bɛniiŋ ŋɛŋ baa biee bi yi tɔŋ, be se kii buŋga bu yi-i bu ti mɛɛ yɛ kɛ, be kii tɛ si yih yi Nyɔ nuuŋ, mɔɔ nuuŋ si be ŋiŋgi yɛ yi bɛ lii kɛ lɛ. Bɛdɛɛni dze yimi nuuŋ yɛ lu yi nuuŋ be ŋgɔnɛ le, le be kii yɛ Nyɔ kɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Mɔɔ si be kii Nyɔ lɛ, be guundi yɛ yi si Nyɔ kɛ le be ni be nyɛɛ kiyɔɔni li yi-i kɛ. Nɛɛ lɛ bɛ mbeechɛ bɛ bee dza baa be to bɛ yee. Bikoo bi bee bi kilɛrɛ yisɛ biɛɛ nuuŋ bɛ kijibɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Be kweŋgi le be kɛmi baa bufii, be se to baa nuuŋ bibere. ");
INSERT INTO asj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Be shɛ baa mbonu Nyɔ yi bunɔŋa yi nuuŋ tɛ kwi kɛ, be tuu be ka be bundi nuuŋ bɛnyɔ bɛ be nachɛ bɛ tsaŋ bɛ bosini bɛniiŋ bɛ nuuŋ be kwi, bɛ muniiŋ mɔɔ nyáŋ yi deŋgi liwe, bɛ yi kɛɛndi kwiiŋ. ");
INSERT INTO asj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Si fi nuuŋ lɛ Nyɔ se chinɛ yɛ be le be ni be feti biee bi shéŋ yibe kɔŋgisi bi nuuŋ biee bi nyɛ-ɛŋ, be feti lɛ bɛ yi yibe wi bee wi, be chɔrisi yi yibe. ");
INSERT INTO asj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Be shɛ baa chɛɛŋ wu Nyɔ be biki nuuŋ binsɛɛ, be guundi yɛ Nyɔ kɛ, be guundi be nindi nuuŋ li biee bi Nyɔ tɔŋ yuti fɛ bee be guundi be nindi-i li yi-i yi nuuŋ Kintɔmu-u. Nuuŋ yi yi be kɛmi le be ni be guundi mfi kwi ma nsiŋ. Fi nuuŋ lɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Si be feti lɛ, Nyɔ se chinɛ be, yi yuusɛ be le be ni be feti nuuŋ biee bi buya-a. Se Bukɛɛŋ gimi bɛ bukɛɛŋ, nuuŋ ɛ Nyɔ ti mɛɛŋ ki tɔŋ kɛ bukɛɛŋ le be ni be feti lɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ɛ nɛɛ lɛ si buniŋ tɛ̀ chinɛ dze yi Nyɔ tɛ̀ gɛɛ le be ni be gimi bɛ bukɛɛŋ le, yi yuusi be le be ni be gimi nuuŋ bɛ buniŋ bamu. Se buniŋ feti biee bi buya-a bɛ buniŋ bamu. Si be feti lɛ be tuu be dzeti ŋgɛ fɛ bikoo bi bee wu nuuŋ kinsomfu ki biŋge bi bee bibifi-i. ");
INSERT INTO asj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Si bɛniiŋ bɛlu tɛ̀ mɛɛŋ ki ŋɛŋ kɛ le fi dzɔɔŋ le be kɛɛ Nyɔ kɛ lɛ, Nyɔ se tuu yɛ yi chinɛ be le be ni be kɛmi bufii bu lɔɔlɔɔ be se ni be feti biee bi be kɛmi yɛ le be fɛ kɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Shéŋ yibe se nuuŋ ɛ yi yisɛ bɛ biee bibifi chichi chichi. Be biiti teeh, lii yɛchi be, be kɛmi shéŋ yi bifi, be fuumi bimi bɛ bɛniiŋ, be woyi bɛniiŋ, be gwii bugwe, be feti kimfi, be seendi biee, be konsini bɛniiŋ, ");
INSERT INTO asj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","be bifisi mɛŋkooŋ mɛ bɛniiŋ lɛ, be baanini Nyɔ, be sɛɛnini biee, be tɛɛmi bikoo, be tsakisi yi, be mɔnchi biee, be tɛɛmi bikoo bɛ bɛtee bɛ bee mɔɔ bɛni bɛ bee. ");
INSERT INTO asj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Be nuuŋ bibere be tɛ leŋ li jɛ yi bee kɛ. Be ŋwɛki bɛ bɛniiŋ bamu, be keeti yɛ nshiiŋ li bɛniiŋ li kɛ. ");
INSERT INTO asj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Be feti lɛ be kii nɛɛ le Nyɔ kɔɔ yɛ yi leeki le wi wu feti bini biee kɛmi le kwi kɛ. Se nuuŋ le, be tuu be feti nɛɛ be giiŋgi limfwe limfwe, be tuu be piɛti bɛniiŋ bɛ feti ŋwaani biee bilu tɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Bɛdɛɛni, wɛ wu sɛki kiŋge ki wi wumu mɔɔ ɔ nuuŋ noo le, ɔ kɛɛ le ɔ fuki yɛ tɛ chɔ kɛ, ɔ ni ɔ kii le si ɔ sɛki kiŋge kee lɛ, kɛ ɔ wuuɔ nuuŋ yi ya, kifɛ wɛ wu sɛki ɔ fetɔɔ tɛ fiee fi feti. ");
INSERT INTO asj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tɛ kii le ɛ Nyɔ lendi ŋgɛ li bɛniiŋ bɛ feti biee bini-i, kɛ yi lendi yɛ lɛ yi biki chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nɛɛlɛ wɛ wu sɛki kiŋge ki bɛniiŋ bɛ feti ŋwaani biee bini-i, se nuuŋ le wɛ kibɛɛ ɔ feti tɛ bi, ɔ beechi le ɔ nuuŋ ɔ bo li tsaŋ yi nsa wu Nyɔ-ɔ ni? ");
INSERT INTO asj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kɛ ɔ ŋiŋgi yɛ le Nyɔ doonchi shéŋ yee yi dzeeŋ li bɛniiŋ li ŋge, yi keeti nshiiŋ ŋge, yi nuuŋ tɛ nyɛɛkii ŋge kɛ ni? Ɔ ŋiŋgi lɛ ɔ beechi le ɛ fiee fi lɔɔlɔɔ ni? Ɔ kii yɛ le shéŋ yi dzeeŋ yi Nyɔ li wɛɛ doonchi le ɔ fiiki shéŋ ya kɛ ni? ");
INSERT INTO asj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Se nuuŋ le, si ɔ faaŋ mfikisɛ shéŋ ya ni, ɔ fetɔɔ nɛɛ fi tɛɛmi fi giiŋgi bu limfwe-e, fi fiɛɛ le ɔ tondinɔɔ nuuŋ ŋgɛ li kikoo ko-o. Ŋgɛ wulu gii naa kɔɔ wɛ bu jobɛ chi Nyɔ gii yi ni yi doonchi sheŋ ye yi fuuti mfi wu yi sɛki bɛniiŋ bɛchu lɛ dze ye yi tsaaŋ li. ");
INSERT INTO asj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Nyɔ gii yi sooŋ wi mumkpaŋ mumkpaŋ biki li fiee fi mwɛ fɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bɛniiŋ bɛ kɛndi shéŋ, li nimɛ chi dzeeŋ li, wɛki nuuŋ le be kɛmɛ bunɔŋa bɛ ŋguŋu mɔɔ ntsɛ wu nuuŋ tɛ naa ma kɛ, yi gii yi nyɛ ntsɛ wu kimakɛ li bee. ");
INSERT INTO asj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Se nuuŋ le bɛniiŋ bɛ bichi nuuŋ lɛ yih yi bee, be fɛŋgi le be wuki yɛ chɛɛŋ kɛ, be feti nuuŋ biee bibifi, be gii be ŋɛŋ shéŋ yi Nyɔ yi tɔnyi bɛ ŋgɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ŋgɛ wu nyɔŋa bɛ ntɔnyɛ gii naa nuuŋ li wi kwi wu feti bubiɛɛ li mbɛɛchɛ li Bɛjuu li ŋgɛnu mbochu li bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Se nuuŋ le, bunɔŋa bɛ ŋguŋu mɔɔ mbɛɛŋgii gii naa nuuŋ li bɛniiŋ bɛ feti kiŋge ki dzeeŋ li mbɛɛchɛ li ki Bɛjuu li ŋgɛnu mbochu li ki bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ-ɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Fi gii fi nuuŋ lɛ kifɛ Nyɔ ti doonchi yɛ chichi kɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bɛniiŋ bɛchu bɛ feti bubiɛɛ bɛ kɛmi yɛ bɛnchi bɛ Mɔɔsɛ-ɛ kɛ, be gii be lɛ li ŋgɛ mɔɔ nuuŋ le be kɛmi yɛ bɛnchi kɛ. Bɛniiŋ bɛchu bɛ feti biee bibifi be nuuŋ lɛ bɛnchi lɛkwiiŋ, bɛ naa sɛki be biki si bɛnchi bɛlu tiiti. ");
INSERT INTO asj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Fi fiɛɛ lɛ kifɛ Nyɔ nuuŋ tɛ dzɔ wi le mwɛ wɛ tsaaŋ lɛ yi-i lii kifɛ wukɔɔ fiee fi bɛnchi tiiti kɛ. Yi gii yi dzɔɔ wi le wɛ tsaaŋ nuuŋ mfi wu mwɛ feti fiee fi nchi wɛki. ");
INSERT INTO asj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ɛ bɛniiŋ bɛ nuuŋ yɛ Bɛjuu kɛ, bɛ nuuŋ bɛnchi nsiŋ, be dza be feti biee bɛ mbeechɛ wube nuuŋ biee bi nchi wɛki, kɛ be baa bɛ nchi li yih yibe mɔɔ nuuŋ le be kɛmi yɛ bɛnchi bɛ Nyɔ nyɛ li Bɛjuu li kɛ. ");
INSERT INTO asj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Fiɛɛ fiee fi doonchi le fiee fi bɛnchi wɛki Nyɔ tsɛɛ yɛ li shéŋ yibe-e. Shéŋ yibe teendi be lɛ. Ɛ be feti fiee fi bifi, shéŋ yibe sɛki be. Ɛ be feti fiee fi dzeeŋ, shéŋ yibe teendi be. ");
INSERT INTO asj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Biee bini gii bi naa bi ka jobɛ chi Nyɔ gii yi saa biee bi bɛniiŋ bɛchu feti lɛ munyiikɔɔ li kɛti li Krai Jiso-o. Ɛ lɛ si ntoŋ wu dzeeŋ wu mfenjisi doonchi. ");
INSERT INTO asj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Wɛ wu teenyi yi ya le ɔ wɛ wi wu bɛ Juu, ɔ giki yi ya li bɛnchi bɛ Mɔɔsɛ-ɛ, ɔ wuki yi le ɔ wɛ wi wu Nyɔ, ");
INSERT INTO asj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","bɛ tifi baa wɛ bɛnchi kituŋ bɛ ɔ kii fiee fi Nyɔ kɔŋgisi, ɔ kii tɛ fiee fi gbɛŋgi fi dzeeŋ ŋge. ");
INSERT INTO asj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ɔ dzeti yi ya le ɛ wɛ ɔ doonchi dze li binyɛɛ li, ɔ nuuŋ lambo li bɛniiŋ bɛ nuuŋ li kijibɛ-ɛ, ");
INSERT INTO asj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ɔ nachi bibere, nuuŋ wɛ wu tiifi bɛniiŋ bɛ kii yɛ biee kɛ si bɔɔŋ bɛ bwi. Ɔ feti lɛ kifɛ bɛnchi nyɛ baa wɛ bufii buchu mɔɔ chɛɛŋ. ");
INSERT INTO asj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Wɛ wu tiifi bɛniiŋ lɛ, ɔ tifɔɔ tɛ yi ya ni? Wɛ wu tiifi le kiiŋ wi ni yi buyi kɛ, ɔ fetɔɔ tɛ lɛ ni? ");
INSERT INTO asj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wɛ wu wami le kiiŋ nyumɛ wi kɛ kwɛɛ wi ni giiŋ bɛ wumu kɛ, ɔ feti tɛ lɛ ni? Wɛ wu banini bɛnyɔ, ɔ ti yi-i nɛɛ fiee li yíh yi muntofi yi bee ni? ");
INSERT INTO asj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wɛ wu tsakisi yi bɛ bɛnchi bɛ Nyɔ-ɔ, ɔ ti bondini nɛɛ bɛnchi, ɔ chɔrisi Nyɔ ni? ");
INSERT INTO asj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Fiɛɛ fiee fi bɛ tɛ̀ tsɛɛ l