﻿USE sofia;
DROP TABLE IF EXISTS sofia.asg_vpl;
CREATE TABLE asg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES asg_vpl WRITE;
INSERT INTO asg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","A ayin a̱ ugiti, Ka̱shile ka yaꞋan ta̱ gaɗi n iɗika. ");
INSERT INTO asg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ana u yaꞋin iɗika, ta i ɗa yi nannai babu ili, ka̱yimbi kaꞋa ka palai mala dem. Ɗa Ayinviki a̱ Ka̱shile a̱ ka̱na̱i kuka̱ra̱Ꞌa̱sa̱ punu a gaɗi vu mini va. ");
INSERT INTO asg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ɗa Ka̱shile ka danai, <<YaꞋan ubuta̱ dem wa akana.>> Ɗa ta na ubuta̱ wa akanai. ");
INSERT INTO asg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ana Ka̱shile ke enei kutashi ku gaꞋan ta̱, ɗa u pecei ka̱yimbi n kutashi. ");
INSERT INTO asg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ɗa Ka̱shile ke ɗekei kutashi ka Kanna, ka̱yimbi kpamu Kayin. U yaꞋan ta̱ ili i nampa ya a kanna ka iyain. Kulivi ki ta̱ lo, usana wi ta̱ lo, ele dem kanna ke te kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ɗa Ka̱shile ka danai, <<N zuwa ta̱ ka̱ba̱nga̱ ke pece mini ugboku u re, mini ma gaɗi m mini ma ɗaka.>> ");
INSERT INTO asg_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ɗa ta na ili yo okpoi nannai. Ka̱shile ka yaꞋin nannai adama a na u pecuku mini ma na mi gaɗi m mini ma na mi ɗaka. ");
INSERT INTO asg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ɗa Ka̱shile ke ɗekei ka̱ba̱nga̱ ka, <<Gaɗi.>> U yaꞋan ta̱ ili i nampa ya a kanna ke ire. Kulivi ki ta̱ lo, usana wi ta̱ lo: ele dem kanna ke ire kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ɗa Ka̱shile ka danai, <<Ka̱sukpa̱ mini ma na mi ɗaka mo ɓolongu a̱ ubuta̱ u te, adama a na iɗika i ɗekpu yu uta̱ kau.>> Ɗa ta na ili yo okpoi nannai. ");
INSERT INTO asg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ɗa Ka̱shile ke ɗekei ubuta̱ u ɗekpu wa, <<Iɗika,>> ubuta̱ u mini kpamu, <<Mala.>> Ɗa Ka̱shile ke enei ili i na u yaꞋin va yi ta̱ n ugaꞋin. ");
INSERT INTO asg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ɗaɗa Ka̱shile ka danai, <<YaꞋan iɗika dem yu uta̱ka̱ n yutishi, mi ta̱ ma na ma kumatsa icuꞋu i le, ilya i matsa ilya, nɗanga kpamu mu uta̱ka̱ n icuꞋu i na i kumatsa otoku e le nɗanga.>> Ɗa ta na ili yo okpoi nannai. ");
INSERT INTO asg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ɗa iɗika dem i ka̱na̱i kuta̱ka̱ n ica̱Ꞌa̱shi kakau. IcuꞋu i ka̱na̱i kumatsasa icuꞋu uteku ci le kakau. Ɗa ta na Ka̱shile ke enei ili i na u yaꞋin va i gaꞋan ta̱. ");
INSERT INTO asg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kulivi ki ta̱ lo, usana wi ta̱ lo: ele dem kanna ka tatsu kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ɗa Ka̱shile ka danai, <<YaꞋan kutashi kakau gaɗi ka akana, adama a na u pece kanna n kayin. A zuwa le ta̱ o okpo urotu u na u kupece ayin, ayin a̱ lyushi, n ayin a irana, n a̱ya̱. ");
INSERT INTO asg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ka̱sukpa̱ kutashi kakau gaɗi kpamu ka akana a̱ ubuta̱ dem.>> Ɗa ta na ili yo okpoi nannai dem. ");
INSERT INTO asg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ka̱shile ka yaꞋan ta̱ kutashi ku gbagbaꞋin ku re. Kutashi ku gbayin ku ɗaɗa. Kanna ka lyaꞋa tsugono n kanna, wotoi kpamu n kayin. Ɗa u doku u yaꞋin azangata kpamu. ");
INSERT INTO asg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ka̱shile ka zuwa ta̱ ili i kutashi ya i yongo gaɗi, adama a na a akana a iɗika, ");
INSERT INTO asg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ciya̱ a lyaꞋa tsugono n kanna n kayin e pece kpamu kutashi n ka̱yimbi. Ɗa Ka̱shile ke enei ili i nanlo ya i gaꞋan ta̱. ");
INSERT INTO asg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kulivi ki ta̱ lo, usana wi ta̱ lo: na lo dem a kanna ka̱ na̱shi kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ɗa Ka̱shile ka danai, <<YaꞋan mini ma shana n adan n ili i wuma dem, ka̱ta̱ gaɗi kpamu u shana n icuꞋu yi nnu kakau.>> ");
INSERT INTO asg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ɗa Ka̱shile ka yaꞋin ili i gbagbaꞋin i mala n icuꞋu ya adan kakau, nu nnu kakau kpamu nannai. Ɗa Ka̱shile ke enei ili i nanlo dem i ɗa i gaꞋan ta̱. ");
INSERT INTO asg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ɗa Ka̱shile ka zuwakai le una̱singai, u danai, <<Matsai ka̱ta̱ i shatangu mala, nnu kpamu i yimkpa ka̱ta̱ i shatangu iɗika.>> ");
INSERT INTO asg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kulivi ki ta̱ lo, usana wi ta̱ lo: na lo dem a kanna ka tawun kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ɗa Ka̱shile ka danai, <<YaꞋan iɗika yu uta̱ka̱ n ili i wuma yaba dem n vicuꞋu vi ni, nnama ra̱ka̱, nu nnama m kpaꞋa koɓolo n aza a na i o kurono a̱tsuma̱ a iɗika.>> Ɗa ta na ili yo okpoi nannai. ");
INSERT INTO asg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ka̱shile ka yaꞋin icuꞋu yi nnama m kpaꞋa nu n kakamba dem, aza a wawaꞋa n aza a̱ gba̱ra̱-gba̱ra̱ yaba dem a kumatsa icuꞋu i ni. Ɗa Ka̱shile ke enei ili i nanlo dem i gaꞋan ta̱. ");
INSERT INTO asg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ɗa Ka̱shile ka danai, <<YaꞋan ci yaꞋan vuma n iyotsonoi i tsu, ka̱ta̱ a yaꞋan kpamu tsu tsu. Ele ɗa aza a na a kulyaꞋaka adan a na i a mala tsugono, nnu n na mi gaɗi, nu nnama m kpaꞋa nu n kakamba, nu nnama n wawaꞋa n na mi o kurono a̱tsuma̱ a iɗika dem.>> ");
INSERT INTO asg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nannai ɗa Ka̱shile ka yaꞋin vuma uteku tsu na a̱yi wi, n iyoci i Ka̱shile i ɗa u yaꞋin ni, u yaꞋan le ta̱ vuka n vali. ");
INSERT INTO asg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ɗa Ka̱shile ka zuwakai le una̱singai, ɗa u danai, <<Yimkpai, ka̱ta̱ i shatangu aduniyan, i ka̱na̱ i ɗa ka̱ta̱ i lyaꞋa tsugono tsa adan a na i a mala, nu nnu n gaɗi koɓolo nu nnama n na mi o kurono a̱tsuma̱ a iɗika dem.>> ");
INSERT INTO asg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ɗa Ka̱shile ka danai, <<La̱na̱, n neke ɗa̱ ta̱ mita̱ dem ma na mi a iɗika ma na ma kumatsa icuꞋu, nu nɗanga dem n umaci u le u na wi n icuꞋu punu, adama a na o okpo ilikulya wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","N neke ta̱ nnama n na mi a iɗika dem, nu nnu, nu nnama n na kpamu mi o kurono a̱tsuma̱ e le a iɗika, n ili i na yi a kuyinvika dem ica̱Ꞌa̱shi dem, adama a na yo okpo ilikulyaꞋa i le.>> Ta ta na ili yo okpoi nannai. ");
INSERT INTO asg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ɗa Ka̱shile ka̱ la̱na̱i ili i na u yaꞋin dem, ɗa we enei i ɗa i gaꞋan ta̱ ka̱u. Kulivi ki ta̱ lo, usana wi ta̱ lo: na lo dem a kanna ka̱ ta̱li kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ɗaɗa kuyaꞋan ku gaɗi n iɗika koɓolo n ili i na yi punu dem ku kotsoi. ");
INSERT INTO asg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","A kanna ke cindere ɗa Ka̱shile ko kotsoi ulinga u na u yaꞋin, ɗa wu uvukai a kanna ke cindere ka adama a ulinga u na u yaꞋin va. ");
INSERT INTO asg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ɗa Ka̱shile ka zuwakai kanna ke cindere ka una̱singai ɗa u bonokoi kaꞋa kanna ka ciɗa, adama a na a kanna ka nanlo kaꞋa Ka̱shile ku uvukai. ");
INSERT INTO asg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Na va ɗaɗa arabali a tsu na a yaꞋin gaɗi n iɗika. Ana Ka̱shile Vuzavaguɗu u yaꞋin gaɗi n iɗika, ");
INSERT INTO asg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","babu mita̱ ko yutishi i yoku i na yu uta̱i a iɗika. Adama a na a ayin a nanlo Ka̱shile Vuzavaguɗu babu na u gita̱i kuyoꞋo mini. Babu vuza na kpamu u kucimba iɗika ya, ");
INSERT INTO asg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ama ayin a nanlo iɗika i ɗa i ci jemgbe ka̱ta̱ i ta̱na̱ta̱ngu ubuta̱ dem. ");
INSERT INTO asg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ɗa Ka̱shile Vuzavaguɗu u maꞋin ikyamba i vuma n kubuta̱ ki iɗika. Ɗa wu uvula̱ka̱ yi ni ayinviki a wuma a̱ vunu vi ni, ɗa vuma wo okpoi n wuma. ");
INSERT INTO asg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ɗa Ka̱shile Vuzavaguɗu u yaꞋin kashina ka nɗanga Adini a kasana, ta ɗe u zuwai vuma vu na u yaꞋin va. ");
INSERT INTO asg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ɗa Ka̱shile Vuzavaguɗu u zuwai icuꞋu yi nɗanga kakau m gbonguroi punu a kashina ka. Ɗa u zuwai nɗanga n na mi n ugaꞋin u kinda punu n na n kumatsa umaci u singai e mere ma kashina ma, ɗa u zuwai kpamu punu nɗanga n re, me te ma na me kuneke wuma, me te kpamu ma na me kuneke vuza kuyeve ki ili i singai n i gbani-gbani dem. ");
INSERT INTO asg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kuyene kuta̱i a Adini, ɗa ku neꞋi kashina ka mini ɗa ku peciki ali ugboku u na̱shi. ");
INSERT INTO asg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kula ku kuyene ku iyain ku ɗaɗa Pishon, ku ɗaɗa ku ci yene a kubana a iɗika i Havila gbende a̱ ubuta̱ u na azanariya i. ");
INSERT INTO asg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Azanariya a iɗika i nanlo i ta̱ ciɗa, a̱ta̱mba̱ n atali a singai i ta̱ ɗe feu a̱ ubuta̱ wa. ");
INSERT INTO asg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kuyene ku ire ku ɗaɗa e ci ɗeke Gihon, ku ci yene ta̱ a iɗika i Kushi dem. ");
INSERT INTO asg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kula ku kuyene ku tatsu ku ɗaɗa Tigirisu, ku ci yene ta̱ a kuwala a uɓon u kasana u Asiriya. Kuɗolu ku na̱shi tamkpamu ku ɗaɗa e ci ɗeke Yufiretu. ");
INSERT INTO asg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ɗa Ka̱shile Vuzavaguɗu u zuwai vuma va punu a Kashina ka Adini ka. Adama a na wi inda ka̱ta̱ u cimba kaꞋa mayin. ");
INSERT INTO asg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ɗa Ka̱shile Vuzavaguɗu u danai ni, <<Vi ta̱ a kufuɗa va lyaꞋa nɗanga n na mi punu a kashina ka dem, ");
INSERT INTO asg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","sai maɗanga ma na ma kuzuwa vuza u yaꞋan n kuyeve ki ili i singai n i gbani-gbani ma ɗaɗa va kulyaꞋa ba. Kanna ka na baci vi lyaꞋi maꞋa, vi ta̱ a̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ɗa Ka̱shile Vuzavaguɗu u danai, <<U gaꞋan vuma u yongo endeꞋen ni ba. Mi ta̱ a kuyaꞋanka yi ka̱ɓa̱nki ka singai.>> ");
INSERT INTO asg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","N kayala ki iɗika kaꞋa Ka̱shile Vuzavaguɗu u yaꞋin nnama n kakamba koɓolo nu nnu n gaɗi dem. Ɗa u tuka̱i le a̱ ubuta̱ u vuma adama a na we ene ko nini ɗai u kuɗeke le, tsu na baci de dem u ɗekei manama ɗa ta na u kokpo kula ku ni. ");
INSERT INTO asg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ɗa vuma va u neꞋi nnama nu nnu n gaɗi ra̱ka̱ ula. Ama A̱da̱mu u ciya̱ punu ka̱ɓa̱nki ka na ka yaꞋin ni ba. ");
INSERT INTO asg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ɗa Ka̱shile Vuzavaguɗu u zuwai vuma va alavu a na a̱ kuwa̱i ni. Ayin a na wi alavu, ɗa u talai ketele ka kakambu ka vali ka, ɗa u bonoi u palai ubuta̱ wa n inyama. ");
INSERT INTO asg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ɗa Ka̱shile Vuzavaguɗu u yaꞋin vuka n ketele ka na u talai va, ɗa u bankai vuma va. ");
INSERT INTO asg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ɗa vuma va vu danai, <<Na va ɗaɗa ketele ka na kuta̱i wa̱ va̱, n inyama i na yu uta̱i wa̱ va̱. Kula ku ni ku ɗa <vuka> adama a na ta punu a̱ uta̱ka̱i ni u vali.>> ");
INSERT INTO asg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","I ɗaɗa i zuwai ɗa vuma u kuka̱sukpa̱ a̱na̱ku a̱ ni n esheku, adama a na u ɓolongu ka̱ci ka̱ ni a̱ ubuta̱ u te n vuka vi ni, ka̱ta̱ o okpo ikyamba i te. ");
INSERT INTO asg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Vali va n vuka vi ni dem oshomboɗi a ɗa i, ama babu vuza na u panai wono u vutoku. ");
INSERT INTO asg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Koko ka laꞋa ta̱ nnama n na Ka̱shile Vuzavaguɗu u yaꞋin dem n ugboji. Ɗa ke ecei vuka va, <<Mayu ɗa Ka̱shile ka danai, <Ka̱ta̱ i lyaꞋa umaci wu nɗanga u na wi punu a kashina ka ba?> >> ");
INSERT INTO asg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɗa vuka va vu danai koko kaꞋa, <<Ci ta̱ a kufuɗa tsa lyaꞋa umaci wu nɗanga dem n na mi punu a kashina ka, ");
INSERT INTO asg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ama Ka̱shile ka dana ta̱, <Ka̱ta̱ i lyaꞋa maɗanga ma na mi punu e mere ma kashina ma ba. Ko kusaꞋwa ka̱ta̱ i saꞋwa ba. Kanna ka na baci i saꞋwai maꞋa, yi ta̱ a̱ kukuwa̱.> >> ");
INSERT INTO asg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ama ɗa koko ka danai vuka va, <<Mayun ɗa i kukuwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ka̱shile ka ke yeve ta̱ kanna ka na baci i lyaꞋi maɗanga ma, a̱shi a̱ ɗa̱ i ta̱ a ku paɗukpa, ka̱ta̱ kpamu yo okpo uteku tsu Ka̱shile. Yi ta̱ e kuyeve ili i gbanigbani n ili i singai.>> ");
INSERT INTO asg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ana vuka va ve enei umaci u maɗanga wa wi ta̱ n ugaꞋin u kulyaꞋa, n ugaꞋin u kinda. U ciga ta̱ kpamu u ciya̱ cicoꞋo tsu na ci punu, ɗa u taꞋi umaci u maɗanga wa ɗa u lyaꞋi. Ɗa u neꞋi vali va, ɗaɗa u lyaꞋi feu. ");
INSERT INTO asg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ɗa dem vi le a̱shi e le a paɗukpai, ɗa e enei ka̱ci ke le oshomboɗi. Ɗa a̱ jilya̱i a̱vuku a maɗanga ma̱ ma̱biri, ɗa a yaꞋankai ka̱ci ke le ciyampa. ");
INSERT INTO asg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","N kulivi, ɗa a panai izumgbi i Ka̱shile Vuzavaguɗu a̱ kuka̱ra̱Ꞌa̱ a kashina ka, ɗa a sumai e sheɗeki punu a nɗanga n kashina ma. ");
INSERT INTO asg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ama ɗa Ka̱shile Vuzavaguɗu ke ɗekei vuma va, u danai, <<Te ɗai vi?>> ");
INSERT INTO asg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ɗa vuma va wu ushuki, <<M panaka wu ta̱ a̱ kuka̱ra̱Ꞌa̱ a kashina ɗaɗa m panai wovon, adama a na mi ta̱ koshomboɗi ɗa n sheɗeki.>> ");
INSERT INTO asg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ɗa Ka̱shile Vuzavaguɗu we ecei ni, <<Yayi u danai koshomboɗi kaꞋa vi? Ko vi lyaꞋa ta̱ maɗanga ma na n danai ka̱ta̱ vi lyaꞋa ba va?>> ");
INSERT INTO asg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ɗa vuma va u danai, <<Vuka vu na vu nekei mu u yongo nu mpa, a̱yi ɗa u taꞋi maɗanga ma ɗa u neꞋi mu ɗa n lyaꞋi.>> ");
INSERT INTO asg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ka̱shile Vuzavaguɗu ke ecei vuka va, <<Yiɗa̱i i zuwai ɗa vi yaꞋin nannai?>> Ɗa wu ushuki, <<Koko kaꞋa ka̱ ya̱nsa̱i mu, ɗa n lyaꞋi.>> ");
INSERT INTO asg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ɗa Ka̱shile Vuzavaguɗu u danai koko ka, <<An vi yaꞋin nannai, una̱ u na mi a kuyaꞋanka wu, u laꞋa ta̱ wu nnama m kpaꞋa koɓolo nu n kakamba dem ali nu nnu feu. Vi ta̱ a kuyaꞋan nwalu n ka̱tsuma̱ ka̱ nu o kurono a iɗika. Kubuta̱ ku ɗa vi kulyaꞋa a ayin a wuma a̱ nu ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mi ta̱ a kuzuwaka ɗa̱ tsurala avu n vuka va, a̱ ka̱tsuma̱ ka ntsukaya n nu koɓolo nu ntsukaya n vuka ma. Wi ta̱ o kuɓoso wu a kaci, ama avu vi ta̱ a kuluma yi a̱ ka̱civa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ɗa u danai vuka va, <<Vi ta̱ e kene atakaci n a̱bunda̱i a na n kuneke wu a̱ ubuta̱ u limata. Nu mɓa̱la̱ n ɗa va kumatsa muku. Ka̱ɗu ka̱ nu ki ta̱ o kuyongo a̱ ubuta̱ u vali nu, a̱yi ɗa ta na u kulyaꞋa tsugono wa̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ɗa Ka̱shile Vuzavaguɗu u danai A̱da̱mu, <<Adama a na vu pana ta̱ kadanshi ka vuka vu nu, ɗa vi lyaꞋi maɗanga ma na n danai nu <Ka̱ta̱ vi lyaꞋa ba,> adama a̱ nu n yaꞋanka ta̱ iɗika dem una̱, sai vi yaꞋan atakaci kafu vi lyaꞋa, ali kanna ka na vu kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Iɗika yi ta̱ a kumatsa awana m mita̱ ma gbani-gbani, imacishi i kakamba i ɗa kpamu va kulyaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Vi ta̱ e kulemgbe kafu vi lyaꞋa ilikulya, ali kanna ka na vu bonoi punu a iɗika ya, adama a na ta punu vu uta̱i. Avu kubuta̱ ku ɗa, a̱ kubuta̱ ku ɗa kpamu vo kubono.>> ");
INSERT INTO asg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ɗa A̱da̱mu u neꞋi vuka vi ni kula Hawa, adama a na a̱yi ɗa u kokpo akaya a uma ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ɗa Ka̱shile Vuzavaguɗu u yaꞋankai A̱da̱mu n vuka vi ni aminya a ukpan. ");
INSERT INTO asg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ɗa Vuzavaguɗu u danai, <<Gogo na vuma wo okpo ta̱ tsu tsu, u yeve ta̱ kasingai n kawuya. Ka̱ta̱ a̱ ka̱sukpa̱ yi u taꞋa ali u lyaꞋa a̱ ka̱tsuma̱ ka nɗanga n kuneke wuma n kasingai ba, ta lo wo yongo n wuma kowanai>> ");
INSERT INTO asg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ɗa Ka̱shile Vuzavaguɗu u lokoi vuma va punu a Kashina ka Adini ka. Adama a na u bana u yaꞋan vicimba a̱ ubuta̱ u na a̱ uta̱ka̱i ni. ");
INSERT INTO asg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ana u lokoi vuma va, ɗa u zuwai ɗe corobi a̱ na̱shi punu a kashina ka a uɓon u kasana, n otokobi a akina a kulyaꞋa una̱ u re dem adama a na a̱ sa̱nka̱ vuma va kuꞋuwa a kashina ka. ");
INSERT INTO asg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ɗa A̱da̱mu u vaki n vuka vi ni Hawa, ɗa u yaꞋin ka̱tsuma̱, ɗa u matsai Kayinu. Ɗa u danai, <<Vuzavaguɗu u ɓa̱nka̱ mu ta̱, ɗa n ciya̱i kolobo.>> ");
INSERT INTO asg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ayin a na i lo, ɗa u matsakai ni vangu ɗa u neꞋi ni kula Habila. Ana u gbonguroi ɗa wo okpoi maguɓi, a̱yi Kayinu tamkpamu wo okpoi kacimbi. ");
INSERT INTO asg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","A ayin a vukyaꞋa, ɗa Kayinu u bankai Vuzavaguɗu n kuneꞋe ki ili i kashina i ni. ");
INSERT INTO asg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ama a̱yi Habila u zagbai mokyon ma singai ma na a̱ gita̱i kumatsa. Ɗa u kiɗai, ɗa u bankai Vuzavaguɗu nu mɓurusa. Ɗa ta na Vuzavaguɗu wi isai alyuka a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ama u pana uyoꞋo u Kayinu n alyuka a̱ ni ba. Ɗa Kayinu u yaꞋin wupa, ka̱ɗu ka̱ ni ka̱ na̱mgba̱i. ");
INSERT INTO asg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ɗa Vuzavaguɗu we ecei ni, <<Yiɗa̱i i zuwai ɗa vi yaꞋin wupa? Yiɗa̱i i zuwai ɗa asuvu a̱ nu a̱ na̱mgba̱i? ");
INSERT INTO asg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ashe vi yaꞋan baci ili i singai a kisa i ɗa ba? Vu lapula baci ba, unushi u ɗa lo a̱ utsutsu a kuvana wu, adama a na u lyaꞋa utsura u nu. Ama u gaꞋan ta̱ vu laꞋa u ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ɗa Kayinu u danai vangu vi ni Habila, <<YaꞋan tsu bana a kakamba.>> Ele ɗe a kakamba, ɗa Kayinu u ga̱la̱i Habila. ");
INSERT INTO asg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ayin a na i lo, ɗa Vuzavaguɗu we ecei Kayinu, <<Te ɗai ambu wi?>> Ɗa Kayinu wu ushuki, <<Mpa n yeve ba. Mpa ɗa kindi ka vangu va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ɗa Vuzavaguɗu u danai, <<Yiɗa̱i i zuwai ɗa vi yaꞋin nannai? Adama a na mpasa n ambu mi ta̱ a malapa mu una̱ punu a iɗika a̱ kuta̱wa̱ wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Gogo na iɗika i na i ɓa̱yuwa̱i adama a na yi isa mpasa n ambu e ekiye a̱ nu, i yaꞋanka wu ta̱ una̱. ");
INSERT INTO asg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ubuta̱ u na vu banai dem, ko vi yaꞋan ulinga nini, iɗika ya yo kudoku ya matsa ili ba. Uteku n anana vo okpo ta̱ vuza vu ka̱ka̱ra̱sa̱ punu a iɗika.>> ");
INSERT INTO asg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ɗa Kayinu u danai Vuzavaguɗu, <<Atakaci a̱ va̱ a laꞋa ta̱ utsura u va̱. ");
INSERT INTO asg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Gogo na vu loko mu ta̱ a iɗika ya, mi ta̱ o kokpo usokongi a̱ ubuta̱ u nu, ka̱ta̱ mo okpo ka̱ka̱ra̱shi punu a aduniyan, vuza na we enei mu dem wi ta̱ a kuna mu.>> ");
INSERT INTO asg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ɗa Vuzavaguɗu wu ushuki u danai, <<Ta nannai ba! Vuza na baci dem wu unai Kayinu mi ta̱ feu a kutakacika yi ali kucindere.>> Ɗa Vuzavaguɗu u zuwakai ni urotu adama a na vuza na de dem u cinai ni ka̱ta̱ wu una yi ba. ");
INSERT INTO asg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ɗa Kayinu u ka̱sukpa̱i kelime ka Vuzavaguɗu ɗa u lazai u banai u da̱sa̱ngi a iɗika i Nodu a Kasana ka Adini. ");
INSERT INTO asg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ɗaɗa Kayinu u vaki n vuka vi ni ɗa u yaꞋin ka̱tsuma̱ u matsai maku ɗa u neꞋi ni kula Anuhu. Ayin a nanlo a̱yi a kumaꞋa likuci ɗa u nekei likuci ya n kula ku maku ma̱ ni Anuhu. ");
INSERT INTO asg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ɗa a matsakai Anuhu maku ɗa u nekei ni kula Iradu, ɗa Iradu u matsai Mehaluja ɗa Mehaluja u matsai Metusela esheku a Lameji. ");
INSERT INTO asg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameji u zuwai a̱ma̱ci e re vuza te kula ku ni ku ɗa Ada kula ku vuza te Zila. ");
INSERT INTO asg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ɗa Ada u matsai Jabalu, a̱yi ɗa esheku a aza a na o kuyongo a̱ a̱pa̱m n a guɓai kuzuwa ku le. ");
INSERT INTO asg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Vuza ni ɗa Jabalu vuza na wi esheku a awaꞋi a umolu n a̱liki a ishari. ");
INSERT INTO asg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ɗa Zila u matsai Tubula-kayinu vuza na u ci yima ila̱nga̱ n iyum. Taku vu Tubala-kayinu a̱yi ɗa Nama. ");
INSERT INTO asg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kanna ke te Lameji u danai a̱ma̱ci e re a̱ ni, <<Ada n Zila, panakai mu, a̱ɗa̱ a̱ma̱ci a Lameji, n saꞋwa ta̱ kuna kolobo ko yoku adama a na u uka mu ta̱ muna. ");
INSERT INTO asg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","I baci a kuna uma e cindere adama a vuza na wu unai Kayinu, I ta̱ a kuna uma amangatatsunkupa n uma e cindere adama a vuza na baci wu unai Lameji.>> ");
INSERT INTO asg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ɗa A̱da̱mu u doku u vaki n vuka vi ni, ɗa u yaꞋin ka̱tsuma̱. Ɗa u matsai maku mo yoku, ɗa vuka vi neꞋi ni kula Shitu. U danai, <<Ka̱shile ke neke mu ta̱ maku mo yoku, adama a na Habila u buwa lo ba, Kayinu wu una yi ta̱.>> ");
INSERT INTO asg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Shitu feu u matsai maku mo kolobo, ɗa u neꞋi ni kula Enos. A ayin a nanlo a ɗa uma a̱ ka̱na̱i kuɗeke kula ku Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Na va ɗaɗa tsumani tsu muku ma̱ A̱da̱mu. A ayin a na Ka̱shile ka yaꞋin vuma u yaꞋan yi ta̱ n iyoci i Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","U yaꞋin le vuka n vali, ɗa u zuwakai le una̱singai. Ana u yaꞋin le u ɗekei le <<Uma.>> ");
INSERT INTO asg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ayin a na A̱da̱mu wi n a̱ya̱ amanga̱ta̱linkupa (130), ɗa u matsai maku ma na mo yotsoi ni, ɗa u neꞋi ni kula Shitu. ");
INSERT INTO asg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ana A̱da̱mu u matsai Shitu ɗa u yongoi a̱ya̱ amangatawunkunla̱i (800) kpamu, ɗa ayin a nanlo, u doku u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A̱da̱mu u yaꞋan ta̱ a̱ya̱ amangatawunkuci n kamangankupa (930), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Shitu wi ta̱ n a̱ya̱ amangatawun n a tawun (105), ɗa u matsai Enos. ");
INSERT INTO asg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ana u matsai Enos, ɗa u doku u yaꞋin a̱ya̱ amangatawunkunla̱i n e cindere (807) ɗa ayin a nanlo, u doku u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Shitu u yaꞋan ta̱ a̱ya̱ amangatawunkuci n kupa n e re (912), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos wi ta̱ n a̱ya̱ amanga̱na̱shinkupa (90), ɗa u matsai Kenan. ");
INSERT INTO asg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ana u matsai Kenan, ɗa Enos u doku ɗa u yaꞋin a̱ya̱ amangatawunkunla̱i n gendu (815). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mo olobo ni nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos u yaꞋan ta̱ a̱ya̱ amangatawunkuci n a tawun (905), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ana Kenan u yawai a̱ya̱ amangatatsunkupa (70), ɗa u matsai Mahalale. ");
INSERT INTO asg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ana a matsai Mahalale, ɗa u doku yaꞋin a̱ya̱ amangatawunkunla̱i n amangere (840). A̱ ka̱tsuma̱ ka ayin a nanlo, u doku u matsai muku mo olobo ni nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan u yaꞋan ta̱ a̱ya̱ amangatawunkuci n kupa (910), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ana Mahalale u yawai a̱ya̱ amangatatsu n a tawun (65), ɗa u matsai Jaredu. ");
INSERT INTO asg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ana u matsai Jaredu, ɗa Mahalale u doku u yaꞋin a̱ya̱ amangatawunkunla̱i n kamangankupa (830). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mo olobo nu nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalale u yaꞋan ta̱ a̱ya̱ amangatawunkunla̱i n amanga̱na̱shinkupa n a tawun (895), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ana Jaredu wi n a̱ya̱ amankunla̱i n e re (162), ɗa u matsai Anuhu. ");
INSERT INTO asg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ana u matsai Anuhu, ɗa u doku u yaꞋin a̱ya̱ amangatawunkunla̱i (800). A̱ ka̱tsuma̱ ka ayin a nanlo, u doku ɗa u matsai muku mo olobo ni nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jaredu u yaꞋan ta̱ a̱ya̱ amangatawunkuci n amangatatsu n e re (962), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ana Anuhu u yawai a̱ya̱ amangatatsu n a tawun (65), ɗa a matsakai ni Metusela. ");
INSERT INTO asg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ana a matsai Metusela, ɗa Anuhu u doku u yaꞋin a̱ya̱ amangatawantatsu (300). A ayin a nanlo, u doku ɗa u matsai muku mo olobo ni nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Anuhu u yaꞋan ta̱ a̱ya̱ amangatawantatsu n amangatatsu n a tawun (365). ");
INSERT INTO asg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Anuhu u yongo ta̱ o kutono Ka̱shile, ɗa u lazai adama a na Ka̱shile ka ɗika yi ta̱ a kubana gaɗi. ");
INSERT INTO asg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ayin a na Metusela wi n a̱ya̱ amangatawun n amanga̱na̱shi n e cindere kuci n e cindere (187), ɗa a matsakai ni Lameji. ");
INSERT INTO asg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ana a matsai Lameji, Metusela u doku u yaꞋin a̱ya̱ amangatawencindere n amanga̱na̱shi n e re (782) ɗa u doku u matsai muku mo olobo ni nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela u yaꞋan ta̱ a̱ya̱ amangatawunkuci n amangatatsu n kuci (969), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ana Lameji u yawai a̱ya̱ amankuci n e re (182), ɗa a matsakai ni kolobo. ");
INSERT INTO asg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","U neꞋi maku ma̱ ni kula Nufu. U danai, <<Adama a na a̱yi ɗa u kutuka̱ n wuvuki wu ulinga u na ci a kuyaꞋansa, adama a na Vuzavaguɗu u yaꞋanka ta̱ iɗika ya una̱.>> ");
INSERT INTO asg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ana a matsai Nufu, ɗa Lameji u doku u yaꞋin a̱ya̱ amangatawantawun n amanga̱na̱shinkupa n a tawun (595), wi ta̱ kpamu m muku mo olobo ni nkere. ");
INSERT INTO asg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameji u yaꞋan ta̱ a̱ya̱ amangatawencindere n amangatatsunkupa n e cindere (777), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ayin a na Nufu u yawai a̱ya̱ amangatawantawun (500) ɗa u matsai muku n tatsu, Shem, Ham n Jafe. ");
INSERT INTO asg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ana uma a̱ gita̱i kuyimkpa punu a aduniyan, ɗa kpamu a matsakai le nkere punu. ");
INSERT INTO asg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Muku n Ka̱shile me enei nkere n vuma mi ta̱ n ugaꞋin ka̱u, ɗa a zagbakai ka̱ci ke le aza a na a luwai le ɗa a zuwai. ");
INSERT INTO asg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ɗa Vuzavaguɗu u danai, <<Mi a kufuɗa kugbama asuvu adama a na vuma u yongo ali a kubana ayin uteku n uteku ba, wi ta̱ a̱ kukuwa̱. A̱ya̱ a̱ ni a kulaza amangatawun n kamanga ba.>> ");
INSERT INTO asg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Aza a Nefilim o yongo ta̱ a iɗika ya kafu ayin a nanlo a, ali n ayin e kelime dem. Ana muku n Ka̱shile n vaki ni nkere n uma ma, ɗa a matsai muku, muku n nanlo ele ɗa okpoi aza a utsura a uma dem. ");
INSERT INTO asg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ɗa Vuzavaguɗu we enei kawuya ka ka yimkpa ta̱ a aduniyan, kusheshe ku vuma ayin dem ku wuyana ta̱ feu ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Vuzavaguɗu u ɓa̱la̱i ka̱tsuma̱ a na u yaꞋin vuma a aduniyan, ɗa ka̱ɗu ka̱ ni ka̱ na̱mgba̱i ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ɗa Vuzavaguɗu u danai, <<Mi ta̱ a kutakpa vuma vu na n yaꞋin punu a aduniyan, uma koɓolo nu nnama dem, koɓolo n ili i wuma i na yi o kurono a̱tsuma̱ e le a iɗika, koɓolo nu nnu n gaɗi adama a na ka̱ɗu ka̱ va̱ ka̱ na̱mgba̱ ta̱ a na n yaꞋin le.>> ");
INSERT INTO asg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ama Nufu u ciya̱i mapasa ma singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Na ɗa tsumani tsu Nufu. Nufu vuza vu usuɓi ɗa, ɗa kpamu wi babu unushi a̱ ubuta̱ u uma a ayin a̱ ni, u yaꞋan ta̱ kpamu nwalu n Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nufu wi ta̱ m muku n tatsu, ele ɗa Shem, Ham n Jafe. ");
INSERT INTO asg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Gogo na uma a aduniyan a̱ na̱mgba̱ ta̱ a̱ ka̱sukpa̱i Ka̱shile ɗa kpamu i tukpa n kawuya. ");
INSERT INTO asg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ka̱shile kenei tsu na uma a aduniyan a shanai n kawuya, adama a na uma a aduniyan ra̱ka̱ a̱ la̱nga̱sa̱ ta̱ uye u le n kawuya. ");
INSERT INTO asg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ka̱shile ka danai Nufu, <<N sheshe ta̱ ɗe kuna uma a aduniyan a nampa ra̱ka̱, adama a na iɗika i nampa i shana ta̱ n kawuya. Mayun n kuna ta̱ uma dem n iɗika ya feu. ");
INSERT INTO asg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Adama a nannai vi yaꞋanka ka̱ci ka̱ nu kpantsu nu nɗanga n kakawu, vi yaꞋan ku ɗa unu-unu ka̱ta̱ kpamu vu paɗara ku ɗa n cirupa̱ asuvu m pulai dem. ");
INSERT INTO asg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Na ɗa uteku u na va kusheꞋwe ku ɗa, ugaɗi u yawa udashi amangatawenre n amangere n kupa (450) wanshi kpamu udashi amangatatsu n kupa n u tawun, ka̱ta̱ kpamu kashani ka̱ ni ka yawa udashi amangere n u tawun. ");
INSERT INTO asg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Vi yaꞋanka kpantsu ka n kukpa̱Ꞌa̱, ka̱ta̱ vu buka ka̱ba̱nga̱ gaɗi ka na ka lazai udashi u te n kagimi ba. Vu zuwa utsutsu a kakambu ka̱ ni ka̱ta̱ vu zuwa kpamu punu kirukpa a ɗaka m mere, koɓolo kpamu n gaɗi dem. ");
INSERT INTO asg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mi ta̱ a̱ kutuka̱ m mini ma na n kuna uma n ili i na i buwai dem a aduniyan a nampa. Ili i na yi n ayinviki dem, Ili ya aduniyan dem yi ta̱ a̱ kukuwa̱. ");
INSERT INTO asg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ama mpa mi ta̱ a kinda uzuwakpani u na tsu zuwakpanai, ka̱ta̱ vu uwa a kpantsu ka avu m muku n nu n vuka vu nu n a̱ma̱ci a̱ muku n nu. ");
INSERT INTO asg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Vu uka punu a kpantsu ka ili i wuma i re i re, vali n vuka koɓolo n avu adama a na vi isa wuma u le. ");
INSERT INTO asg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Vi ɗika nnu icuꞋu kakau feu aza e re e re nu nnama n na m buwai aza a na i o kurono a̱tsuma̱ e le a iɗika, vu uka le punu adama a na a isa wuma u le. ");
INSERT INTO asg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Vi ɗika ili kulyaꞋa i na yi kulyaꞋa dem ka̱ta̱ vu foɓo punu adama a̱ ɗa̱ koɓolo nu nnama ma.>> ");
INSERT INTO asg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nufu u yaꞋan ta̱ ili dem derere uteku u na Ka̱shile ka danai ni. ");
INSERT INTO asg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ɗa Vuzavaguɗu u danai Nufu, <<Uwa a kpantsu avu n limata i nu dem adama a na me ene ta̱ avu vuza ciɗa ɗa a̱ kuta̱wa̱ wa̱ va̱ a̱ ka̱tsuma̱ ka aduniyan dem. ");
INSERT INTO asg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ɗika nnama n cindere n cindere a̱ ka̱tsuma̱ ka nnama n ciɗa vuka n vali. Nnama mu unata vi ɗika n re n re vuka n vali koci. ");
INSERT INTO asg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nnu n gaɗi kpamu nannai ugboku u cindere u cindere vuka n vali, adama a na icuꞋu yu nnama dem nu nnu i ciya̱ aza a wuma punu a aduniyan. ");
INSERT INTO asg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Adama a na gogo na ayin e cindere a ɗa o okpoi a na mo kuyoꞋo mini, ayin a amangere kanna n kayin adama a na mu una ili i wuma dem m mini, ili i wuma i na n yaꞋin mi ta̱ a kutakpa i ɗa ra̱ka̱.>> ");
INSERT INTO asg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ɗa Nufu u yaꞋin ili dem ra̱ka̱ uteku u na Vuzavaguɗu u danai ni. ");
INSERT INTO asg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nufu wi ta̱ n a̱ya̱ amangatawa̱nta̱li (600), ayin a na mini ma lyaꞋi iɗika. ");
INSERT INTO asg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nufu n vuka vi ni, m muku n ni, n a̱ma̱ci e le, ɗa a uwai a kpantsu ka. Adama a na a laꞋaka n wuma u le. ");
INSERT INTO asg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Koɓolo nu nnama n kutakuma nu n na a̱ kukpa̱ɗa̱ kutakuma, nu nnu, n ili i na yi o kurono a̱tsuma̱ a iɗika dem. ");
INSERT INTO asg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Aza e re e re vuka n vali a banai u Nufu. Ɗa a uwai a kpantsu ka, uteku tsu na Ka̱shile ka danai Nufu. ");
INSERT INTO asg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ana ayin e cindere a lazai ɗa mini ma na ma lyaꞋi aduniyan ma̱ ta̱wa̱i. ");
INSERT INTO asg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","A kanna ka kupa n ke cindere n wotoi u ire a̱ ka̱ya̱ ka amangatawa̱nta̱li ka ayin a wuma u Nufu, ɗa mini mo ɓosoi ma̱ ka̱na̱i kuwa̱ n u yoꞋi ɗa atusu a gaɗi dem a̱ ɓa̱yuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ɗa u ka̱na̱i kuyoꞋo mini a aduniyan ali ayin amangere kanna n kayin. ");
INSERT INTO asg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","A kanna ka nanlo ka ɗa Nufu n vuka vi ni a uwai a kpantsu ka koɓolo m muku n tatsu n ni Shem, n Ham, koɓolo n Jafe, n a̱ma̱ci e le. ");
INSERT INTO asg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","I ta̱ Punu a kpantsu ka koɓolo nu nnama n kakamba nu nnama m kpaꞋa icuꞋu kakau, aza a na o kurono a̱tsuma̱ a iɗika feu nu nnu kakau n ili ye evelyu i na i buwai. ");
INSERT INTO asg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Aza e re e re ili i na yi n ikyamba a kuyinvika de dem, i uwai punu a kpantsu ka n Nufu. ");
INSERT INTO asg_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nnama n na n uwai a kpantsu vuka ɗa n vali icuꞋu kakau uteku u na Ka̱shile ka danai Nufu, ɗa Vuzavaguɗu u ɓa̱ya̱ngi utsutsu wa. ");
INSERT INTO asg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","U ka̱na̱i kuyoꞋo mini a aduniyan ali ayin amangere. Uteku tsu na mini ma̱ ka̱na̱i kushana, ɗa kpantsu ku ka̱na̱i kuta̱ɗukpa̱ gaɗi nannai. ");
INSERT INTO asg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ɗa mini mo doku ma yinkpasakai aduniyan n a̱bunda̱i, ɗa kpantsu ka ku ta̱ɗukpa̱i a gaɗi vu mini va. ");
INSERT INTO asg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ɗa mini mo doku ma yinkpasakai aduniyan n a̱bunda̱i, ali kusan ku gbagbaꞋin a iɗika dem ku liɓai. ");
INSERT INTO asg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ɗa mini mo doku ma̱ ɗa̱nga̱i gaɗi ka̱u ali ma palai nsasan m gbagbaꞋin kakau n na n lazai ubapi kamanga. ");
INSERT INTO asg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ili i na i tsu zumgba̱ punu a aduniyan n wuma dem i ɗa i kuwa̱i a̱ mini, nnu nu nnama, nu nnama n kakamba ali n uma a na i aduniyan dem ɗa mini mu unai le. ");
INSERT INTO asg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ili i wuma i na yi n ayinviki dem a iɗika i kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ili i na yi punu a aduniyan dem a̱ pura̱ngu ta̱ i ɗa. Uma nu nnama n ili i na yi o kurono a̱tsuma̱ a iɗika dem, nnu n ili i na i buwai. Nufu ɗa koci u buwai n wuma n aza a na a uwai a kpantsu ka n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mini ma ma pala ta̱ aduniyan ali ayin amangecindere n kupa (150). ");
INSERT INTO asg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ama Ka̱shile ka ciɓai n Nufu nu nnama m kpaꞋa nu n kakamba aza a na i punu a kpantsu dem. Ɗa u suki wunla̱i a aduniyan, ɗa mini ma me jebei. ");
INSERT INTO asg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ubuta̱ u na wi a̱ kuwa̱ mini dem n atusu a gaɗi dem ɗa a̱ biniki, ɗa mini ma̱ ka̱sukpa̱i kuɗa̱kpa̱ a iɗika. ");
INSERT INTO asg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ɗa mini ma̱ gita̱i ku kukpa sawu, ana ma yawai ayin amangatawun n amangerenkupa (150) ɗa me jebei gbende, ");
INSERT INTO asg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","a kanna ka kupa n e cindere o wotoi u cindere, ɗa kpantsu ka ku cipa̱i a kusan ku Arara. ");
INSERT INTO asg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ɗa mini ma ma lyaꞋi kelime n kujebe ali a kubana o wotoi u kupa. A kanna ka iyain o wotoi u nanlo wa ɗa gaɗi vu nsasan va vu gita̱i kuta̱ e keteshe. ");
INSERT INTO asg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ana ayin amangere a yaꞋin ɗa Nufu u ɓa̱yuwa̱i katusu ka na u yaꞋin a kpantsu ka, ");
INSERT INTO asg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ɗa u ka̱sukpa̱i kagawun. Ɗa kagawun ka̱ ka̱na̱i ciɗinkpi n u bonoi ali ayin a na mini mo kotsoi a iɗika. ");
INSERT INTO asg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Megeshe kenu ɗa Nufu u doku ɗa u ka̱sukpa̱i moɗoi mo kondo ko mini me ɗekpe ta̱ a iɗika. ");
INSERT INTO asg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ama moɗoi ma ma̱ ciya̱ ubuta̱ u na u kuyikpa̱ ba, adama a na mini ma buwa ta̱ a̱ ubuta̱ dem a iɗika; ɗa mo bonoi a kpantsu a̱ ubuta̱ u Nufu. Wu uta̱ka̱i kukiye ku ni ɗa u ka̱na̱i maꞋa ɗa u bonokoi maꞋa a kpantsu. ");
INSERT INTO asg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","U doku u vanai ali ayin e cindere ɗa u suki moɗoi mu uta̱ kpamu pulai. ");
INSERT INTO asg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ana moɗoi ma mo bonoi wa̱ ni n kulivi, ɗa u kasai ka̱vuku ka̱ ta̱ku ka maɗanga ma̱ ma̱biri a̱ una̱ u ni! Ɗa Nufu u yevei a na mini ma kukpa ta̱ ka̱u punu a aduniyan a. ");
INSERT INTO asg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","U doku u vanai ali ayin e cindere ɗa u doki u suki moɗoi ma kpamu, ama u nampa mo doku mo bono wa̱ ni kpamu ba. ");
INSERT INTO asg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","A kanna ka iyain, n wotoi u iyain, ana Nufu u yawai a̱ya̱ amangatawa̱nta̱li n ke te (601), ɗa mini ma lazai a iɗika. Ɗa u talukpai kukpa̱Ꞌa̱ ku kpantsu ka. Ɗa we enei iɗika ya e kuɗekpe. ");
INSERT INTO asg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A kanna ka kamanga n e cindere (27) n wotoi u ire, ɗa iɗika ya i ɗekpei dem. ");
INSERT INTO asg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ɗa Ka̱shile ka danai Nufu, ");
INSERT INTO asg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","<<Uta̱ punu a kpantsu ka, avu n vuka vu nu, m muku n nu n a̱ma̱ci e le. ");
INSERT INTO asg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Uta̱ka̱ ili i wuma dem, i na yi punu a kpantsu ka: nnu, nnama, n ili i na yi o kurono a̱tsuma̱ a iɗika dem. Adama a na a shatangu aduniyan, ka̱ta̱ a yimkpa kpamu.>> ");
INSERT INTO asg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ɗa Nufu wu uta̱i, koɓolo m muku n ni, n vuka vi ni, n ejene a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nnama gbende n ili i wuma i na yi o kurono a̱tsuma̱ a iɗika, koɓolo nu nnu dem a̱ uta̱i a kpantsu ka o ku tononoi, yaba dem n icuꞋu i ni. ");
INSERT INTO asg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ɗa Nufu u shikpa̱i katalikalyuka adama a Vuzavaguɗu. Ɗa u la̱nsa̱i nnama n kutakuma n yoku nu nnu n kutakuma kpamu. Ɗa u lyukai alyuka o kusongu a̱ ubuta̱ wa. ");
INSERT INTO asg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ana Vuzavaguɗu u tsumgbai ma̱gula̱ni ma singai ma alyuka ma, ɗa u danai n ka̱ɗu ka̱ ni, <<Mi o kudoku kuyaꞋanka iɗika una̱wuya adama a vuma ba, adama a na kusheshe ku ka̱ɗu ku vuma ki ta̱ tukpa n kawuya ali n ayin a na a̱yi biꞋi kenu. Mi o kudoku kuna ili i wuma ra̱ka̱ tsu na n yaꞋin ɗe ba. ");
INSERT INTO asg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","<<Aduniyan a buwa baci de lo n wuma, a ayin a̱ vica̱Ꞌa̱ n ayin a vikyaꞋa, ayin a̱ usuɗukpi n ayin a̱ uta̱ni, ayin a kawun n ayin a kpandari, kanna n kayin o kukotso ba.>> ");
INSERT INTO asg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ɗa Ka̱shile ka zuwakai Nufu m muku mo olobo n ni una̱singai. Ɗa u danai le, <<Matsai ka̱ta̱ i yimkpa, i shatangu iɗika. ");
INSERT INTO asg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nnama ra̱ka̱ ali n aza a na i o kurono a̱tsuma̱ a iɗika, nu nnu n adan i ta̱ o kuyongo a kupana wovon u nu. Ra̱ka̱ vi le a zuwa le ta̱ a ɗaka vi idasakpatsu i nu. ");
INSERT INTO asg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ili i na yi n wuma ɗa yi a̱ kuzumgba̱ dem yi ta̱ o kokpo ilikulyaꞋa i nu. Uteku u na n nekei nu yutishi, gogo na n neke wu ta̱ ili dem. ");
INSERT INTO asg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","<<Ama ka̱ta̱ i takuma ili i na i kuwa̱i nu mpasa n ni babu ukiɗi ba. ");
INSERT INTO asg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nu mpasa n nu n ɗa a kutsupaka vuza na vu lolotongi mpasa n ni. Mi ta̱ feu a kuna manama dem ma na mu unai vuma. Mi ta̱ feu a kuna vuma na wu unai toku vi ni vuma. ");
INSERT INTO asg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Vuza na baci u lolotongi mpasa n vuma, vuma ɗa feu u kulolotongu mpasa n vuma vu nanlo, adama a na Ka̱shile ka yaꞋan ta̱ vuma n iyoci i ni. ");
INSERT INTO asg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A̱ɗa̱ tamkpamu matsai ka̱ta̱ i yimkpa n a̱bunda̱i, i yaꞋan a̱bunda̱i a iɗika ka̱ta̱ i shatangu i ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ka̱shile ka danai Nufu n olobo a̱ ni, ");
INSERT INTO asg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","<<Mpa gogo na n yaꞋan ta̱ uzuwakpani n a̱ɗa̱ koɓolo nu ntsukaya n na n kuta̱wa̱ ka̱ca̱pa̱ ka̱ a̱ɗa̱ ");
INSERT INTO asg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","koɓolo n ili i wuma ra̱ka̱ i na yi n avu, nu nnu ra̱ka̱ nu nnama m kpaꞋa koɓolo n kakamba ra̱ka̱, ili ra̱ka̱ i na yu uta̱i a kpantsu ka koɓolo n avu. ");
INSERT INTO asg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Gogo na, n zuwa ta̱ uzuwakpani u va̱ n a̱ɗa̱, mi o kudoku ma kuna ili i wuma dem m mini ba. Mini kpamu mi o kudoku ma lyaꞋa aduniyan ba.>> ");
INSERT INTO asg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ɗa Ka̱shile ka danai, <<Na va ɗaɗa urotu wu uzuwakpani u na n kuyaꞋan n a̱ɗa̱, koɓolo n ili i wuma dem i na yi n avu. Uzuwakpani wa kpamu u kutono ta̱ ntsukaya n na n kuta̱wa̱ dem. ");
INSERT INTO asg_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","N zuwa ta̱ vukambu vu va̱ gaɗi a̱ ubuta̱ we eleshu. Ɗa u kokpo urotu wu uzuwakpani u va̱ n aduniyan. ");
INSERT INTO asg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ayin a na baci de dem mu uta̱ka̱i n eleshu a uguyi ɗa vukambu vu uta̱i punu e eleshu a, ");
INSERT INTO asg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mi ta̱ a kuciɓa n uzuwakpani u na n yaꞋin n a̱ɗa̱ koɓolo n ili i wuma ra̱ka̱ kakau. Mini mo kudoku kpamu ma kuna wuma ra̱ka̱ nannai ba. ");
INSERT INTO asg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Me ene baci vukamba vu uta̱i punu e eleshu, mi ta̱ e kene ka̱ta̱ n ciɓa uzuwakpani wu babu uteku u Ka̱shile n ili i wuma kakau dem punu na a iɗika.>> ");
INSERT INTO asg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ɗa Ka̱shile ka danai Nufu, <<Na ɗa urotu wu uzuwakpani u na n yaꞋin n ili i wuma ra̱ka̱ punu na a iɗika.>> ");
INSERT INTO asg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Muku n Nufu n na mu uta̱i punu a kpantsu ka ele ɗa Shem, Ham n Jafe. (Ham a̱yi ɗa esheku a KanaꞋana.) ");
INSERT INTO asg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ele na ɗa muku n tatsu n Nufu, e le ɗa okpoi uma a na a wacuwai a iɗika dem. ");
INSERT INTO asg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nufu kacimbi, a̱yi ɗa u gita̱i kuyaꞋan kashina ki itacishi yi nɗanga n na n tsu matsa tsa̱ a̱ɗimbi. ");
INSERT INTO asg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ana u soꞋi ma̱ra̱ ma nɗanga n kashina n ni n yoku, ɗa ma makai ni ɗa u vaki koshomboɗi a̱ ka̱va̱li ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, esheku a KanaꞋana, we enei ciyampa ce esheku e le ɗa u danai aza a̱ ni e re a na a buwai va ele ɗe pulai. ");
INSERT INTO asg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ama Shem n Jafe a ɗikai ogbodo ɗa a̱ ɓa̱na̱i a ɗa a lazakai avangatsu e le; ɗa a walai n kucina̱ sai a̱ ubuta̱ u na esheku e le i ɗa a palai ni na ɗa. A kpatalai a̱shi e le adama a na ka̱ta̱ e ene ciyampa ce esheku e le ba. ");
INSERT INTO asg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ayin a na Nufu u jimgbai a̱ ka̱tsuma̱ ko kusoꞋo ka̱ ni, ɗa u yevei ili i na maku ma ukocishi ma̱ ni ma yaꞋankai ni, ");
INSERT INTO asg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ɗa u danai, <<Una̱ u tono KanaꞋana! Sai wo okpo kagbashi ku ukocishi wa̱ aza a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","U danai kpamu, <<Una̱singai u ɗa u Vuzavaguɗu, Ka̱shile ke Shem! YaꞋan KanaꞋana wo okpo kagbashi ke Shem. ");
INSERT INTO asg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","YaꞋan Ka̱shile ko doku Jafe ekiye a kuyaꞋan a iɗika i ni n uma punu, yaꞋan Jafe u yongo a̱ a̱va̱li e Shem, yaꞋan KanaꞋana wo okpo kagbashi ka̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ana mini mo kotsoi, ɗa Nufu u doku u yaꞋin a̱ya̱ amangatawantatsu n amangerenkupa (350). ");
INSERT INTO asg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","A̱ya̱ a na Nufu u yaꞋin aduniyan a ɗaɗa amangatawunkuci n amangerenkupa (950), ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ele na ɗa ntsukaya n Shem, Ham, n Jafe muku n Nufu. Muku n tatsu n nampa a matsa ta̱ feu muku ayin a na mini ma na ma lyaꞋi uma a iɗika ra̱ka̱ mo kotsoi. ");
INSERT INTO asg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Muku n Jafe ele ɗa Gomaru, Mogogu, Madai, Javan, Tubalu, Mesheku, n Tirasu. ");
INSERT INTO asg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Muku n Goma ele ɗa Ashekenaza, Rifata, n Togaruma. ");
INSERT INTO asg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Muku n Javan ele ɗa Elishahu, Tarishi, Kitimu, n Dodanimu. ");
INSERT INTO asg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","A̱ ubuta̱ u le u ɗa uma a na o yongoi o kotogu a̱ ka̱kina̱ ka mala a̱ uta̱i. Ele ɗa muku n Jafe o kuyongo umaci kakau, kelentsu kakau, n iɗika kakau feu. ");
INSERT INTO asg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Muku n Ham, ele ɗa Kush, Masar, Putu, n KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Muku n Kush ele ɗa Sheba, Havila, Sabotu, Rama, Sabateka. Muku n Rama ele ɗa Seba n Dedanu. ");
INSERT INTO asg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush u matsai maku ɗa u neꞋi ni kula Namura, vuza na wo okpoi kovonshi vu utsura vi iyain va aduniyan. ");
INSERT INTO asg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wo okpoi katain ka gbayin a̱ ubuta̱ u Vuzavaguɗu, i ɗaɗa i zuwai ɗa uma a danai, <<YaꞋan Vuzavaguɗu u bonoko wu katain ka gbayin tsu Namura!>> ");
INSERT INTO asg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Tsugono ci iyain ci ni ci gita̱ ta̱ n likuci i Babila, Ereci, n Akadu, n Kaline dem vi le a iɗika i Shina. ");
INSERT INTO asg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","U gita̱i punu a iɗika i nanlo, ɗa u banai a Asiriya a̱ ubuta̱ u na u maꞋi likuci i Niniva, Rehobotu-iri, n Kalashi ");
INSERT INTO asg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","n Reshena, i na yi e mere ma Niniva n likuci i gbayin i Kalashi. ");
INSERT INTO asg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Masar ɗa esheku a Ludu, Anama, Lehabu, Nafutu, ");
INSERT INTO asg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Paturusu, Kasulu, n Karita, aza a na a matsai aza a Filisitiya. ");
INSERT INTO asg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","KanaꞋana ɗa esheku a Sida maku ma iyain ma̱ ni, n Hiti, ");
INSERT INTO asg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","koɓolo kpamu n aza a Jebusiya, Amoriya, Girigeshiya, ");
INSERT INTO asg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","n aza a Hiviya, n Akita, n aza a Siniya, ");
INSERT INTO asg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ali n aza a Avadi, n Zamarita, n aza a Hamo. Umaci kakau wa aza a KanaꞋana e pecekushi daꞋin kakau, ");
INSERT INTO asg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ali sai a na uteku wa aza a KanaꞋana u yawai uɓon u gaɗi vu Sida a kubana a uɓon u ɗaka vu Gera ɗevu n Geza, n Sodom, n Gomora, n Aduma, koɓolo n Zeboyim ɗevu n Lasha. ");
INSERT INTO asg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Na ɗa muku n Ham, o kuyongo umaci kakau, kelentsu kakau, n iɗika kakau feu. ");
INSERT INTO asg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A matsaka ta̱ Shem, Jafe mokoshi ma̱ ni muku, a̱yi ɗa tsukaya tsu muku n Eberu ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Muku n Shem ele ɗa Elim, Ashuru, Afakasha, Luda, n Aram. ");
INSERT INTO asg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Muku n Aram ele ɗa Uzu, Hulu, Getaru, m Mesheku. ");
INSERT INTO asg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afakasha a̱yi ɗa esheku a Shela, Shela esheku a Eberu. ");
INSERT INTO asg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberu wi ta̱ m muku n re: vuza te kula ku ni ku ɗa Pelegu, adama a na a ayin a̱ ni a ɗa uma a aduniyan e pecuki, ɗa vuza te va e neꞋi ni kula Jokuta. ");
INSERT INTO asg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokuta ɗa esheku a Alamodadu, Shela, Hazamavetu, Jera, ");
INSERT INTO asg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzala, Dikila ");
INSERT INTO asg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimale n Sheba ");
INSERT INTO asg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","koɓolo n Ofiri, n Havila, n Jobabu. Ra̱ka̱ vi le muku n ɗa n na mu uta̱i u Jokuta. ");
INSERT INTO asg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Iɗika i na o yongoi i ɗa i gita̱ ta̱ a Mesha ali a kubana Sefa a uɓon wu nsasan a kasana. ");
INSERT INTO asg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ele na ɗa muku n Shem, o kuyongo umaci kakau, kelentsu kakau, n iɗika kakau feu. ");
INSERT INTO asg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Na ɗa umaci wu muku n Nufu, iɗika kakau, uteku u na kefeku ke le ki. Ana mini ma na ma lyaꞋi aduniyan mo kotsoi, iɗika dem yu uduniyan i ciya̱i tsukaya a̱ ubuta̱ wu muku n Nufu. ");
INSERT INTO asg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ayin o yoku, uma ishi ta̱ a tsu dansa kelentsu ke te n ukuna u te feu. ");
INSERT INTO asg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ana e sheruwengi kenu a uɓon u kasana, ɗa a̱ ciya̱i ka̱ba̱nga̱ ka singai a iɗika i Shina, ɗa a shamgbai ɗe. ");
INSERT INTO asg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ɗa dananai <<Ta̱wa̱i. Ci yaꞋin iputa̱ n a̱bunda̱i ka̱ta̱ tsu songu ci ɗekpetengi i ɗa.>> Ɗa kucikpa a yaꞋin ulinga n iputa̱ a na a yaꞋan n atali. Cirupa̱ kpamu ci ciꞋin. ");
INSERT INTO asg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ɗa a danai kpamu, <<Ta̱wa̱i. Tsu maꞋakai ka̱ci ka̱ tsu likuci n mashilya mu ugaɗi ma gbangam punu ma na ma kuyaꞋan ugaɗi sai a̱ Ka̱shile. Adama a na ci yaꞋan kula, ci ciya̱ tsu pecukusu punu a iɗika ya ba.>> ");
INSERT INTO asg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ama Vuzavaguɗu u cipa̱ ta̱ adama a na u kondo likuci n kumaꞋa ka, ku na uma a yaꞋin va. ");
INSERT INTO asg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ɗa Vuzavaguɗu u danai, <<Uma e kelentsu ke te ka nampa, a fuɗa baci a yaꞋan ili i nampa. Babu ili i na e kusheshe kuyaꞋan dem, ka̱ta̱ a̱ kpa̱ɗa̱ kufuɗa kuyaꞋan i ɗa. ");
INSERT INTO asg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","YaꞋan ci cipa̱ adama a na tsu shulyuku kadanshi ke le, ka̱ta̱ a̱ ciya̱ o doku a dansa ili i te ba.>> ");
INSERT INTO asg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Vuzavaguɗu u gba̱ra̱i le u pecuki le punu a aduniyan ra̱ka̱, ɗa a̱ ka̱sukpa̱i kumaꞋa ku likuci ka. ");
INSERT INTO asg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","I ɗaɗa i zuwai ɗa e ɗekei ubuta̱ wa Babila, adama a na ta ɗe Vuzavaguɗu u shulyuki kadanshi ka uma ra̱ka̱. Ta ɗe Vuzavaguɗu u gba̱ra̱i le u pecuki le punu a aduniyan. ");
INSERT INTO asg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Na ɗa ntsukaya n Shem. Ayin a na a̱ya̱ e re a lazai a̱ mini ma̱ a̱bunda̱i ma na mu unai uma, ayin a na Shem wi n a̱ya̱ amangatawun (100), ɗa u matsai Afakasha. ");
INSERT INTO asg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ana Shem wo okpoi esheku a Afakasha ɗa u doku u yaꞋin a̱ya̱ amangatawantawun (500). A̱ ka̱tsuma̱ ka ayin a nanlo, u doku u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ana Afakasha u yaꞋin a̱ya̱ kamangankupa n a tawun (35), ɗa u matsai Shela. ");
INSERT INTO asg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ɗa Afakasha u yaꞋin kpamu a̱ya̱ amangatawa̱na̱shi n a tatsu (403). A̱ ka̱tsuma̱ ka ayin a nanlo, u doku u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ana Shela u yaꞋin a̱ya̱ kamangankupa (30), ɗa u matsai Eberu. ");
INSERT INTO asg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ana u matsai Eberu ɗa u yaꞋin kpamu a̱ya̱ amangatawa̱na̱shi n a tatsu (403). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ana Eberu u yaꞋin a̱ya̱ kamangankupa n a̱ na̱shi (34), ɗa u matsai Fele. ");
INSERT INTO asg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ana Eberu u matsai Pelegu, ɗa kpamu u yaꞋin a̱ya̱ amangatawa̱na̱shi n kamangankupa (430). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ana Fele u yaꞋin a̱ya̱ kamangankupa (30), ɗa u matsai Reyu. ");
INSERT INTO asg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ayin a nanlo, ɗa u yaꞋin kpamu a̱ya̱ amangatawenre n kuci (209). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reyu u yaꞋin a̱ya̱ kamangankupa n e re (32), ɗa u matsai Seru. ");
INSERT INTO asg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","U doku u yaꞋin kpamu a̱ya̱ amangatawenre n e cindere (207). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ana Seru u yaꞋin a̱ya̱ kamangankupa (30), ɗa u matsai Nahoru. ");
INSERT INTO asg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","U doku u yaꞋin kpamu a̱ya̱ amangatawenre (200). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ana Nahoru u yaꞋin a̱ya̱ kamanga n kuci, ɗa u matsai Tera. ");
INSERT INTO asg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","U doku u yaꞋin a̱ya̱ amangatawun n kupa n kuci (119). A̱ ka̱tsuma̱ ka ayin a nanlo, u matsai muku mu nkere n olobo. ");
INSERT INTO asg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ana Tera u yaꞋin a̱ya̱ amangatatsunkupa (70), ɗa u matsai Iburam, n Nahoru, n Haran. ");
INSERT INTO asg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Na ɗaɗa ntsukaya n Tera, vuza na u matsai Iburam, Nahoru n Haran. Haram tamkpamu u matsai Lotu. ");
INSERT INTO asg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ɗa Haran u kuwa̱i a̱ likuci i ni i Ur punu a Kaldiya, esheku tamkpamu biꞋi n wuma. ");
INSERT INTO asg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Iburam n Nahoru a zuwai a̱ma̱ci, kula ku vuka ku Iburam ku ɗaɗa Saraya, kula ku vuka vu Nahoru tamkpamu ku ɗaɗa Milika. A̱yi Milika n Isikaya muku n Haran n ɗa. ");
INSERT INTO asg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraya u ciya̱ kucina̱ ba. ");
INSERT INTO asg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera u ɗikai maku ma̱ ni Iburam, m matsukaya ma̱ ni Lotu (maku ma Haram), n kejene ka̱ ni kpamu Saraya (vuka va Iburam), ɗa a̱ ka̱sukpa̱i Ur vu Kaldiya, a kubana a KanaꞋana. A banai ɗa a̱ da̱sa̱ngi a Haran, a shamgbai ɗe. ");
INSERT INTO asg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera u yaꞋan ta̱ a̱ya̱ amangatawenre n a tawun (205), ɗa u kuwa̱i ɗe a Haran. ");
INSERT INTO asg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Vuzavaguɗu u danai Iburam, <<Ka̱sukpa̱ iɗika i nu, nu mmaci n nu, n uma a kpaꞋa ke esheku a̱ nu, vu bana a̱ ubuta̱ u na n kuyotsongu wu. ");
INSERT INTO asg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mi ta̱ a kuzuwa wu vo okpo iɗika i gbayin dem. Mi ta̱ a kuzuwaka wu una̱singai ka̱ta̱ kula ku nu ko okpo ku gbayin, ka̱ta̱ vo okpo vuma vu una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mi ta̱ a kuzuwaka aza a na a zuwakai nu una̱singai. Vuza na baci u yaꞋankai nu una̱, mi ta̱ feu a kuyaꞋanka yi. Uma a aduniyan dem i ta̱ a̱ kuciya̱ una̱singai adama a̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ɗa Iburam u lazai, uteku u na Vuzavaguɗu u danai ni, ɗa Lotu u tonoi ni. Ayin a nanlo Iburam wi ta̱ n a̱ya̱ amangatatsunkupa n a tawun (75), ana wu uta̱i Haran. ");
INSERT INTO asg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ɗa Iburam u ɗikai vuka vi ni Saraya, n Lotu maku ma vangu vi ni, n uciyi u na o ɓolongi dem ali n agbashi e le feu a na a̱ ciya̱i a Haran. Ɗa a̱ ka̱na̱i uye a kubana a KanaꞋana, ɗa ta na a yawai ɗe. ");
INSERT INTO asg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Iburam u walai punu a iɗika ya ali ɗa u yawai a maɗanga ma gbayin ma More, a̱ likuci i Shekem. (A ayin a nanlo aza a KanaꞋana biꞋi o kuyongo ɗe a iɗika ya.) ");
INSERT INTO asg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ɗa Vuzavaguɗu u danai Iburam, <<Wu ntsukaya n nu n ɗa n kuneke iɗika i nampa ya.>> Ɗa u shikpa̱i katalikalyuka ɗe adama a Vuzavaguɗu, vuza na u ta̱wa̱i wa̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ana wu uta̱i ɗe ɗa u tonoi a kubana a uɓon wu nsasan a kasana ke Betelu ɗa u zuwai ka̱va̱li ka̱ ni ɗe, Betelu wo okpoi ni a̱ ka̱livi ɗa kpamu Ai wo okpoi ni a kasana. Ta ɗe u shikpa̱ka̱i Vuzavaguɗu katalikalyuka ɗa u ɗekei kula ku Vuzavaguɗu ɗe. ");
INSERT INTO asg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ɗa Iburam u ɗa̱nga̱i u lyaꞋi kelime nu nwalu n ni, a kubana a uɓon u ɗaka u KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kambulu ka̱ yikpa̱ ta̱ a iɗika ya, ɗa Iburam u banai limoci a Masar adama a na kambulu ka ko gbonguro ta̱. ");
INSERT INTO asg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ana wi ɗevu a na wa yawa a Masar, ɗa u danai vuka vi ni Saraya, <<N yeve ta̱ vuka ɗa vi n tsuloboi ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Aza a Masar e ene wu baci, i ta̱ a kudana, <Vuka vi ni ɗa na.> Ka̱ta̱ a una mu ama i ta̱ a̱ kuka̱sukpa̱ wu n wuma. ");
INSERT INTO asg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dana avu taku vu va̱ ɗa vi, ka̱ta̱ a̱ ciya̱ a̱ la̱na̱ mu mayin adama a̱ nu ka̱ta̱ wuma u va̱ u kpa̱ɗa̱ kupuwa̱nka̱.>> ");
INSERT INTO asg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ana Iburam u uwai a Masar, ɗa aza a Masar e enei vuka va vi ta̱ n tsuloboi ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ana aza gbagbaꞋin a FiriꞋauna e enei vuka va, a yaꞋin kadanshi n FiriꞋauna adama a ugaꞋin u vuka wa, ɗa a ɗikai ni sai e kefeku ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","U la̱na̱i Iburam mayin adama a vuka a, ɗa u nekei Iburam nkyon n anaka, njaki a̱na̱ku n ali, agbashi ali n a̱ma̱ci, koɓolo n arakuma. ");
INSERT INTO asg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ama ɗa Vuzavaguɗu u takacikai FiriꞋauna n aza a kpaꞋa a̱ ni nu ndukpa̱ kakau adama a Saraya vuka vu Iburam. ");
INSERT INTO asg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ɗaɗa FiriꞋauna u ɗekei Iburam. U danai, <<Yiɗa̱i vi yaꞋankai mu nannai? Yiɗa̱i i zuwai vu kpa̱ɗa̱i kudana mu a na vuka vu nu ɗa? ");
INSERT INTO asg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Yiɗa̱i ɗa vu danai, <Taku vu va̱ ɗa,> ɗa n ɗikai ni wo okpoi vuka vu va̱? Gogo na, vuka vu nu ɗa na. Ɗika yi vu wala!>> ");
INSERT INTO asg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ɗa FiriꞋauna u nekei abara a̱ ni kadanshi adama a Iburam, ɗa o lokoi ni u ka̱sukpa̱ iɗika ya, n vuka vi ni koɓolo n ili i na wi n i ɗa dem. ");
INSERT INTO asg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Iburam u ka̱sukpa̱i Masar a kubana a ɗaka vu uɓon u KanaꞋana n vuka vi ni koɓolo n ili i na wi n i ɗa dem, ɗa Lotu u banai koɓolo n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ɗa Iburam wo okpoi vuza vu uciyi n a̱bunda̱i, n ilikuzuwa n azanariya koɓolo n Azurufa. ");
INSERT INTO asg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","U ka̱sukpa̱i ubuta̱ u nanlo ɗa u tonoi n ubuta̱ kakau ali u yawai e Betelu. U yawai a̱ ubuta̱ u na wi e mere me Betelu n Ai a̱ ubuta̱ u na wi ishi u vaki n ayin o yoku. ");
INSERT INTO asg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A̱ ubuta̱ u ɗaɗa u gita̱i kushikpa̱ katalikalyuka. Ta ɗe kpamu Iburam u ɗekei kula ku Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lotu vuza na wishi o kutono Iburam, wi ta̱ n kuzuwa ushiga wu nlala n anaka n a̱bunda̱i, n a̱pa̱m a uma. ");
INSERT INTO asg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ama iɗika ya i yawa le a vaku lo aza e re e le ba. Adama a kuzuwa ku na i n ku ɗa ku ɗa ki ta̱ n a̱bunda̱i, ali a̱ kpa̱ɗa̱i kufuɗa kushamgba a̱ ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ɗa kanananai ka uwai e mere me le, a̱ ubuta̱ wu nguɓi ma Iburam nu n Lotu. Aza a KanaꞋana n aza a Periziya feu, i ta̱ lo ida̱shi lo a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ɗa Iburam u danai Lotu, <<U gaꞋan ci yaꞋan kanananai uteku u tsu ko nguɓi n tsu ba, adama a na a̱ tsu vuza ɗa m maku ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ashe iɗika ya yi e ekiye a̱ nu ba? YaꞋan tsu pece. Vu zagba baci ugula̱, mpa n ɗika usingai. Vu bana baci ta na usingai, mpa m bana ugula̱.>> ");
INSERT INTO asg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lotu u la̱nuki ɗa we enei kuta̱nu a̱ ka̱ra̱ dem ka̱ Urudu, a kubana a uɓon u Zora. Iɗika i nampa yi ta̱ tsu kashina ka Vuzavaguɗu, an iɗika i Masar. (Na va ɗaɗa kafu Vuzavaguɗu wu una Sodom n Gomora.) ");
INSERT INTO asg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ɗa Lotu u zagbai ubuta̱ u ka̱ba̱nga̱ n a̱bunda̱i a uɓon u Kuyene ku Urudu, ɗa u tonoi a kubana a kasana. Ele aza e re e le ɗa e pecei. ");
INSERT INTO asg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iburam u da̱sa̱ngi a iɗika i KanaꞋana, ama Lotu u da̱sa̱ngi a uɓon u likuci i yoku ya̱ a̱ra̱Ꞌa̱ ɗevu n Sodom, ɗa u yaꞋin ɗe a̱pa̱m. ");
INSERT INTO asg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Uma o Sodom uma a gbani-gbani a ɗa, i ta̱ kpamu a kuyaꞋanka Vuzavaguɗu unushi u gbangam. ");
INSERT INTO asg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ɗa Vuzavaguɗu u danai Iburam, wana ɗai Lotu u pece, <<Ɗengusa̱ a̱shi a̱ nu. Vu la̱na̱ a kubana a uɓon u gaɗi n ɗaka n kasana n ka̱livi. ");
INSERT INTO asg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Iɗika i na ve enei na, mi ta̱ e kuneke wu i ɗa dem, nu ntsukaya n nu dem, ali ko wanai. ");
INSERT INTO asg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mi ta̱ a kuzuwa muku n nu mo okpo n a̱bunda̱i an kayala ka aduniyan. Vuza na baci wi a kufuɗa we kece kayala, wi ta̱ a kufuɗa we kece ntsukaya n nu. ");
INSERT INTO asg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bana vu la̱na̱ ugaɗi n wanshi wi iɗika ya, mi ta̱ e kuneke wu i ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ɗa Iburam u muɗa̱i a̱pa̱m a̱ ni, ɗa u lazai a kubana kuyongo ɗevu nu nɗanga m gbagbaꞋin m Mamure e Heburon, a̱ ubuta̱ u na u shikpa̱i katalikalyuka adama a Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ayin a na ngono n na̱shi n nampa m banai kuvon: Amurafe mogono ma Shina, n Ariyo mogono me Elesa, n Kedaloma mogono me Elim, koɓolo n Tida mogono mo Goyim, ");
INSERT INTO asg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","A banai kuvon adama a na a lyaꞋa ngono n yoku: Bera mogono mo Sodom, m Bisha mogono mo Gomora, n Shinabu mogono ma Aduma, n Shemeba mogono ma Zeboyim, m mogono me Bela (ɗaɗa Zora). ");
INSERT INTO asg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ngono n nampa n foɓusoi ɗa o ɓolongi una̱ n aza o kuvon e le a̱ ka̱ra̱Ꞌa̱ ka Sidim, ubuta̱ u na gogo na wo okpoi Mala ma mkpaɗi. ");
INSERT INTO asg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ali a̱ya̱ kupa n e re ele o kutono kadanshi ka Kedaloma, ama a̱ ka̱ya̱ ka kupa n a tatsu ɗa a̱ kpa̱ɗa̱i kudoku kutono yi. ");
INSERT INTO asg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A̱ ka̱ya̱ ka kupa n a̱ na̱shi, Kedaloma nu ngono ma o ɓolongi una̱ n a̱yi ɗa a banai a lyaꞋi aza a Refimu punu a̱ likuci i Ashatara Karanayim, aza a Zuzim a Ham, aza a Emimu a Shava Keritiya ");
INSERT INTO asg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","n aza o Horitu a nsasan n Siyaru, na lo va kpamu likuci i le i ɗa, ali sai ɗe El-param ɗevu n kakamba. ");
INSERT INTO asg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","A kpatalai ɗa o bonoi a En-mishafata (ɗaɗa Kadeshi), ɗa a lyaꞋi uɓon wa aza a Emeleki ra̱ka̱ n kuvon, koɓolo n aza a Amoriya ele na i o kuyongo a Hazazon-tamaru. ");
INSERT INTO asg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ɗaɗa mogono mo Sodom, m mogono mo Gomora, m mogono ma Aduma, m mogono ma Zeboyim m mogono ma Bela (ɗaɗa Zora) a̱ uta̱i ɗa a shamkpai ubuta̱ u kuvon u le a̱ ka̱ra̱Ꞌa̱ ka̱ Sidim ");
INSERT INTO asg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","adama a Kedaloma mogono ma Elim, Tidala mogono mo Goyim, Amurafe mogono ma Shina n Ariyo mogono ma Elesa. Ngono n na̱shi a̱ kushilika̱ nu ngono n tawun. ");
INSERT INTO asg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ka̱ra̱Ꞌa̱ ka̱ Sidim ki ta̱ n enle n a̱bunda̱i tukpa n kayala ka mapaɗaka ulima̱ an kopoti. Ana mogono mo Sodom n Gomora i a ilaɗi a̱ kuka̱sukpa̱ ubuta̱ u kuvon, uma o yoku a̱ yikpa̱i punu aza o yoku a sumai a banai a nsasan. ");
INSERT INTO asg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ngono n na̱shi n nanlo a isai ucanuku u Sodom n Gomora dem n ilikulyaꞋa i le dem, ɗaɗa a lazai. ");
INSERT INTO asg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ɗaɗa feu a ɗikai Lotu (maku ma vangu vi ni) Iburam, n ili i na wi n i ɗa dem, adama a na wi ta̱ ida̱shi o Sodom. ");
INSERT INTO asg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ama vuza na u fa̱ta̱tsa̱i u banai u danai Iburam vuza va aza a Ibirahi a̱yi na wi o kuyongo ɗevu nu nɗanga m gbagbaꞋin m Mamure va aza Amoriya. Mamure n aza a̱ ni Eshikolu n Aneru, o ɓolongi una̱ n Iburam ciya̱ a̱ ɓa̱nka̱na̱i. ");
INSERT INTO asg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ana Iburam u panai a ɗika ta̱ vuza ni Lotu a kubana ugbashi, ɗa u ɗikai uma o kuvon a̱ ni amangatawantatsu n kupa n kunla̱i (318), aza a na kpamu ta punu a matsai le a kpaꞋa. Ɗa a banai ɗa o tonoi le ali a kubana Dan. ");
INSERT INTO asg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","N kayin Iburam u pecuki uma a̱ ni ɗa u lyaꞋi le utsura ɗa wu unai le, a kiyangi le ali sai Hoba, gaɗi vu Dimaska. ");
INSERT INTO asg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ɗa wi isai ucanuku wa ra̱ka̱, u na a ɗikai va. Ɗa u bonoi n vuza ni Lotu, n vuka vi ni, n ili i na i buwai. ");
INSERT INTO asg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ana Iburam u bonoi a̱ ubuta̱ u kuvon, a̱ ubuta̱ u na a lyaꞋi anan Kedaloma nu ngono n na mi ɗe dem, ɗa mogono mo Sodom wu uta̱i adama a na u cina yi a̱ Ka̱ra̱Ꞌa̱ ka Shava (ɗaɗa Ka̱ra̱Ꞌa̱ ko Mogono.) ");
INSERT INTO asg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ɗa Malikisada mogono ma Salem wu uta̱ka̱i m boroji koɓolo m ma̱kya̱n. A̱yi ta na vuma vu nanlo ganu vu Ka̱shile MalaꞋimili dem. ");
INSERT INTO asg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ɗa u zuwakai Iburam una̱singai, u danai, <<Ka̱shile MalaꞋimili, u zuwaka ta̱ Iburam una̱singai, Vuza na u yaꞋin gaɗi n iɗika, u zuwaka wu ta̱ Iburam una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Cikpa Ka̱shile MalaꞋimili, vuza na kpamu u ka̱sukpa̱i irala i nu i uwai ekiye a̱ nu.>> Ɗa Iburam u neꞋi ni ili i te a̱ ka̱tsuma̱ ki ili kupa. ");
INSERT INTO asg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mogono mo Sodom ma danai Iburam, <<Bonoko mu n uma a̱ va̱, avu ɗika ucanuku wa wo okpo u nu.>> ");
INSERT INTO asg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ama Iburam u danai mogono mo Sodom, <<N ɗengusa̱ ta̱ kukiye a kubana a̱ ubuta̱ u Vuzavaguɗu, Ka̱shile MalaꞋimili, vuza na u yaꞋin gaɗi n iɗika, n yaꞋan ta̱ kpamu akucina ");
INSERT INTO asg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mi a kisa ili i nu ba, ko tsugbere ko kashiyatsu ka ataka, adama a na vu kpa̱ɗa̱ kufuɗa kudana, <Mpa ɗa n zuwai Iburam wo okpoi vuza vu uciyi.> ");
INSERT INTO asg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ma kuɗika ili adama a̱ ka̱ci ka̱ va̱ ba, ama sai ili i na uma a̱ va̱ a lyaꞋi ɗe koci. Ama ka̱sukpa̱ aza a̱ tsu a na o ɓolongi una̱, Ana, Eshikolu, m Mamure, a ɗika ugboku u le.>> ");
INSERT INTO asg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ana nannai u lazai, ɗa kadanshi ka Vuzavaguɗu ka̱ ta̱wa̱i u Iburam tsa alatani, <<Ka̱ta̱ vu pana wovon ba. Mi ta̱ o kokpo ma̱ra̱ga̱ ma̱ nu, adama a na ka̱ta̱ kpamu n yaꞋanka wu katsupu ka̱ gba̱ra̱.>> ");
INSERT INTO asg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ama Iburam wu ushuki, u danai, <<Ka̱shile Vuzavaguɗu, yiɗa̱i katsupu ka̱ nu ka kuyaꞋanka mu? Mpa ɗa na, mi m muku ba. Eliyaza vi Dimaska kabara ka̱ va̱ a̱yi ɗa vuza na u kulyaꞋa tsugono tsu kpaꞋa tsu va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Iburam u danai, <<Ɗanna, vu neke mu maku ba, adama a nannai kagbashi ka na a matsai a kpaꞋa ku va̱ wi ta̱ a kulyaꞋa uka̱ni u va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ɗa u panai Vuzavaguɗu u yaꞋin kadanshi n a̱yi kpamu. U danai, <<Kabara ka̱ nu ka nampa Eliyaza wo kokpo mogono mi ili i kpaꞋa i nu ba. Maku mu umaci ma̱ nu maꞋa mo kokpo mogono.>> ");
INSERT INTO asg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ka̱shile ka bankai ni pulai ɗa u danai, <<Inda gaɗi, ka̱ta̱ vi kece azangata a, ta muku n nu, nu ntsukaya n nu n kuyaꞋan a̱bunda̱i nannai.>> ");
INSERT INTO asg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iburam u nekei ka̱ɗu ka̱ ni u Vuzavaguɗu. Adama a nannai ɗa ta na Ka̱shile ke kecei ni a̱ ka̱tsuma̱ ka aza a usuɓi. ");
INSERT INTO asg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ɗa kpamu u danai ni, <<Mpa ɗa Vuzavaguɗu, vuza na wu uta̱ka̱i ɗa̱ a Ur vu na vi punu a Babila adama a na n neke ɗa̱ iɗika i nampa yo okpo ubuta̱ u ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ama ɗa Iburam u danai, <<Vuzavaguɗu Uba̱nga̱ri, nini ɗai n kuyeve a na ubuta̱ u nampa u kokpo u va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ɗaɗa Vuzavaguɗu u danai ni, <<Tuka̱ mu n kanaka, m maraɗika n ka̱giri, dem vi le a yawa a̱ya̱ a tatsu a tatsu, koɓolo m moɗoi m maku ma matapambara.>> ");
INSERT INTO asg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iburam u tuka̱i ni n ili i nampa ra̱ka̱, kiɗa ka̱ta̱ vu pece le akiɗi e re e re ka̱ta̱ vu zuwa akiɗi a a mindanai; ama u kiɗa nnu, akiɗi e re e re ba. ");
INSERT INTO asg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Asakali a̱ yikpa̱i a̱ ubuta̱ wu nnama n na a kiɗai va, ama Iburam u lokoi le. ");
INSERT INTO asg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ana kanna ki a̱ kuyikpa̱, Iburam u latai ka̱u, ɗa ka̱yimbi ko wovon ku utsura ka̱ ta̱wa̱i wa̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ɗa Vuzavaguɗu u danai ni, <<Yeve mayun a na ntsukaya n nu n kokpo omoci a iɗika i na yi i le ba, i ta̱ a kuyaꞋan ɗe tsugbashi ka̱ta̱ kpamu a takacika ɗe ali a̱ya̱ amangatawa̱na̱shi (400). ");
INSERT INTO asg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ama mi ta̱ a kutakacika iɗika i na i bonokoi le agbashi, i baci a̱ kuka̱sukpa̱ iɗika i na ishi o limoci ya, i ta̱ a kulaza n uciyi wa̱ a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ama avu, vi ta̱ a̱ kukuwa̱ m ma̱ta̱na̱ ka̱ta̱ a̱ ciɗa̱ngu wu a ayin a singai. ");
INSERT INTO asg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tsukaya ci ta̱ a kuyawa tsu na̱shi kafu ntsukaya n nu m bono na, adama a na mi o kuloko aza a Amoriya ba, sai ayin a na a̱ gita̱i kuyaꞋan kawuya ka na ka yawai o soꞋo atakaci.>> ");
INSERT INTO asg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ana kanna ka̱ yikpa̱i ɗa ka̱yimbi ka yaꞋin, ka̱nga̱ ka akina o mogbodo n ka̱va̱sa̱ ka̱ ma̱kuni ka yawai ɗa ka walai e mere ma akiɗi a inyama yi nnama ya. ");
INSERT INTO asg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","A kanna ka nanlo ka Vuzavaguɗu u yaꞋin uzuwakpani n Iburam u danai, <<N neke ta̱ ntsukaya n nu iɗika i nampa ya, ili i na i gita̱i e kuyene ka aza a Masar ali a kubana e kuyene ku gbayin Yufiretu, ");
INSERT INTO asg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","koɓolo n iɗika ya aza e Kenetu, iɗika ya aza e Kenezu, n iɗika ya aza a Kadamoniya, ");
INSERT INTO asg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ya aza a Hitiya, aza a Periziya, n ya aza Refimu ");
INSERT INTO asg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ya aza a Amoriya, ya aza a KanaꞋana, ya aza a Girigeshiya, koɓolo n ya aza a Jebusiya.>> ");
INSERT INTO asg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Vuka vu Iburam, Saraya, u matsaka yi muku ba. Ama vuka va wi ta̱ n kabara ka maku ma vuka, vuza va aza a Masar, kula ku ni ku ɗa Hajara. ");
INSERT INTO asg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ɗa Saraya u danai vali vi ni, <<Vuzavaguɗu u neꞋe mu limata ba. Yiɗa̱i i zuwai ɗa va kuvaku m maku mu usuki ma̱ va̱ ba? U gaꞋan ba, wi ta̱ a̱ kuciya̱ka̱ mu maku.>> Iburam wu ushuki n ili i na Saraya u danai. ");
INSERT INTO asg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ana Iburam u yongoi a KanaꞋana ali a̱ya̱ kupa. Ɗa Saraya vuka vu Iburam u nekei ni kabara ka̱ ni Hajara u yaꞋan vuka vi ni vu gbani. ");
INSERT INTO asg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Wa asai n Hajara, ɗa ta na u yaꞋin ka̱tsuma̱. Ana u yevei u ka̱na̱ ta̱ ka̱tsuma̱, ɗa u gita̱i kugoyo Saraya a̱na̱ku a kanna a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ɗaɗa Saraya u danai Iburam, <<Avu ɗa vu zuwai mu atakaci a na mi o kusoꞋo na. N zuwakai nu kagbashi ka̱ va̱ a̱ nkuta̱ n nu, gogo na a na u yevei u ka̱na̱ ta̱ ka̱tsuma̱, ɗa u goyoi mu. YaꞋan Vuzavaguɗu u yaꞋanka tsu afada a̱ tsu n avu.>> ");
INSERT INTO asg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iburam u danai, <<Maku mu usuki ma̱ nu mi ta̱ e ekiye a̱ nu. YaꞋanka yi ili i na ve enei i gaꞋin nu.>> Ɗaɗa Saraya u takacikai Hajara, ɗa ta na u sumai u ka̱sukpa̱i ni. ");
INSERT INTO asg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ɗa kalingata ka Vuzavaguɗu ka cinai Hajara ɗevu n kuyene a kakamba, kuyene ku na ki ɗevu n uye u na u banai Shuru. ");
INSERT INTO asg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ɗa kalingata ka danai, <<Hajara, kagbashi ka Saraya, te ɗai vu uta̱i, te ɗai kpamu vi a kubana?>> Wu ushuki, <<Mi ta̱ a kusuma a̱ ubuta̱ u vuza gbayin vu kunu vu va̱ Saraya.>> ");
INSERT INTO asg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ɗaɗa kalingata ka Vuzavaguɗu ka danai ni, <<Bono a̱ ubuta̱ u vuza gbayin vu kunu vu nu ka̱ta̱ kpamu vu tono yi.>> ");
INSERT INTO asg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ɗa kalingata ka ko doku ka danai kpamu, <<Mi ta̱ a kuzuwa ntsukaya n nu n yimkpa ali n laza kukece.>> ");
INSERT INTO asg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kalingata ka Vuzavaguɗu ka danai ni kpamu, <<Gogo na vi ta̱ n ka̱tsuma̱ ka maku, vi ta̱ a kumatsa maku mo kolobo. Ka̱ta̱ vi neꞋi kula IsumaꞋilu, adama a na Vuzavaguɗu u pana ta̱ una̱mgbi u ka̱tsuma̱ u nu. ");
INSERT INTO asg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wi ta̱ o kokpo majaki ma kakamba ma uma, wi ta̱ a kuyaꞋan tsurala n yaba dem ka̱ta̱ feu yaba dem u yaꞋan tsurala n a̱yi, wi ta̱ o kuyongo endeꞋen kau n aza a̱ ni ra̱ka̱.>> ");
INSERT INTO asg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","U neꞋi Vuzavaguɗu vu na u yaꞋin kadanshi n a̱yi kula ku nampa, <<Avu ɗa Ka̱shile ka na ke ci ene mu,>> adama a na u dana ta̱, <<Gogo na me ene ta̱ Ka̱shile ka na ke ci ene mu.>> ");
INSERT INTO asg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","I ɗaɗa i zuwai ɗa uma e ci ɗeke kayinva ka na ki e mere me Kadeshi m Biya-lahi-royi, <<Kayinva ka Vuza Wuma vu na u ce ene Mu.>> ");
INSERT INTO asg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajara u matsakai Iburam maku, ɗa u neꞋi ni kula IsumaꞋilu. ");
INSERT INTO asg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Iburam wi ta̱ n a̱ya̱ amanga̱na̱shi n a̱ ta̱li ana Hajara u matsakai ni IsumaꞋilu. ");
INSERT INTO asg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ana Iburam u yaꞋin a̱ya̱ amanga̱na̱shinkupa n kuci, ɗa Vuzavaguɗu u ta̱wa̱i wa̱ ni. U danai, <<Mpa ɗa Ka̱shile Uba̱nga̱ri. Tono kadanshi ka̱ va̱ ka̱ta̱ kpamu vi yaꞋan ili i singai ayin tutu. ");
INSERT INTO asg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","N kuzuwa ta̱ uzuwakpani n avu, ka̱ta̱ n neke wu ntsukaya n a̱bunda̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iburam u kuɗa̱ngi sapu u lyaꞋi kayala, ɗa Ka̱shile ka danai ni, ");
INSERT INTO asg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","<<N zuwa ta̱ uzuwakpani u nampa n avu, va kuyaꞋan ta̱ akaya a uma kakau a̱ likuci n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kula ku nu ku buwa Iburam ba, gogo na e kuɗeke wu ta̱ Ibirahi. Adama a na mi ta̱ a kuzuwa wu vo okpo akaya a uma a̱ likuci n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mi ta̱ e kuneke wu ntsukaya n a̱bunda̱i, yeve kpamu m bonoko wu iɗika i gbayin ka̱ta̱ a̱ ciya̱ punu ngono a̱ ka̱tsuma̱ ke le. ");
INSERT INTO asg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","N kuzuwa ta̱ uzuwakpani u nampa n avu nu ntsukaya n nu kpamu, adama a limata i le i na i kuta̱wa̱ sai uteku n uteku. Mpa ɗa Ka̱shile ka̱ nu, nu ntsukaya n nu dem. ");
INSERT INTO asg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mi ta̱ e kuneke wu nu ntsukaya n nu iɗika i KanaꞋana ra̱ka̱ i na yi o limoci na, yo okpo i nu, nu ntsukaya n na n kuta̱wa̱ kelime ali uteku n uteku. Mpa tamkpamu n kokpo ta̱ Ka̱shile ke le.>> ");
INSERT INTO asg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ɗa Ka̱shile ka danai Ibirahi, <<Avu feu, vu ka̱na̱ uzuwakpani wa nu mpa nu ntsukaya n nu koɓolo nu ntsukaya n kelime kpamu ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Na ɗa uzuwakpani u na va̱ kuɓa̱na̱ avu nu ntsukaya n nu ali nu ntsukaya n na n kuta̱wa̱ ka̱ca̱pa̱ dem. Uzuwakpani u ɗaɗa yu ushuku kukiɗa muku n ali n ɗa̱ avaja ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","I gita̱ kukiɗa avaja adama a na wo okpo urotu wu uzuwakpani u va̱ n a̱ɗa̱. A umaci u ɗa̱ ra̱ka̱ i kiɗa muku n ali n ɗa̱ avaja ayin a na baci a yawai ayin kunla̱i. M muku ma agbashi n na a matsai punu a kpaꞋa ku ɗa̱ nu n na i tsulai n ikebe a̱ ubuta̱ wo omoci ra̱ka̱, ko aza a na yi umaci u te ba. ");
INSERT INTO asg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ko kagbashi ka na a matsai punu a kpaꞋa ku nu ko vu tsulai, dem vi le sai a kiɗa yi ukpan u tsali, na ɗaɗa u kokpo urotu wi ikyamba u na u kuyotsongu an uzuwakpani u tsu n avu u ɗa wi ta̱ babu uteku. ");
INSERT INTO asg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Maku ma vali ma na baci u yawai a kiɗa yi ɗaɗa u ciya̱i ukiɗi wu ukpan u tsali ba, i ta̱ e kupece yi n uma a̱ ni, u koɗo ta̱ uzuwakpani u va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ɗa Ka̱shile ka danai Ibirahi kpamu, <<Vu doku vi ɗeke vuka vu nu kula Saraya ba, ama vi ɗekushe yi Saratu. ");
INSERT INTO asg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","N kuzuwaka yi ta̱ una̱singai. Ka̱ta̱ n neke yi kpamu maku ma na ma kuyaꞋan ma̱ nu. N kuzuwaka yi ta̱ una̱singai, a̱yi tamkpamu u kokpo ta̱ a̱na̱ku a uma kakau a̱ likuci-likuci n a̱bunda̱i, a̱ kuciya̱ ta̱ punu ngono a̱ ka̱tsuma̱ ka ntsukaya n ni.>> ");
INSERT INTO asg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibirahi u kuɗa̱ngi sapu u lyaꞋi kayala, ɗa u zosoi, ɗa u gita̱i kusheshe n ka̱ɗu ka̱ ni, <<Vuza u kudoku ta̱ wa matsa ayin a na baci u yaꞋin a̱ya̱ amangatawun (100)? Saratu u kumatsa ta̱ wana ɗai u yaꞋan a̱ya̱ amanga̱na̱shinkupa?>> ");
INSERT INTO asg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ɗa Ibirahi u danai Ka̱shile, <<Vi ta̱ a kufuɗa kuka̱sukpa̱ IsumaꞋilu wo okpo vuza na u kuɗika ili i nanlo dem.>> ");
INSERT INTO asg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ama, Ka̱shile ka danai, <<A̱Ꞌa̱, vuka vu nu Saratu wi ta̱ a kumatsaka wu maku. Ka̱ta̱ vi neꞋe yi kula Ishaku. N kuzuwaka yi ta̱ uzuwakpani a kubana wu ntsukaya n ni koɓolo nu ntsukaya n na n kuta̱wa̱ ka̱ca̱pa̱ ka̱ ni ali a kubana uteku n uteku. ");
INSERT INTO asg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","M pana ta̱ ufolu u nu adama a IsumaꞋilu. N kuzuwaka yi ta̱ una̱singai. Ka̱ta̱ u ciya̱ muku nu ntsukaya dem. A̱yi ɗa u kokpo esheku o ngono kupa nu n re. Ka̱ta̱ kpamu ntsukaya n ni n yaꞋan a iɗika n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ama n kuɓa̱na̱ ta̱ uzuwakpani n Ishaku maku ma na vuka vu nu Saratu u kumatsa ka̱ya̱ ko bono.>> ");
INSERT INTO asg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ana Ka̱shile ko kotsoi kudansa n Ibirahi, ɗa u ka̱sukpa̱i ni. ");
INSERT INTO asg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","A kanna ka nanlo Ibirahi u ɗikai maku ma̱ ni IsumaꞋilu m muku mo olobo n na m buwai ra̱ka̱. Koɓolo m muku ma agbashi n na a matsai punu a kpaꞋa ku ni n aza a na u tsulai dem, ɗa u kiɗai le avaja tsu na Ka̱shile ka danai ni. ");
INSERT INTO asg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibirahi u yawa ta̱ a̱ya̱ amanga̱na̱shinkupa n kuci (99), u yevei u kiɗai kavaja, ");
INSERT INTO asg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","a̱yin maku ma̱ ni IsumaꞋilu biꞋi a̱ya̱ kupa n tatsu. ");
INSERT INTO asg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ibirahi m maku ma̱ ni IsumaꞋilu a kiɗai le avaja a kanna ke te. ");
INSERT INTO asg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Muku n ali dem n na mi a kpaꞋa ki Ibirahi, koɓolo n aza a na a matsai punu a kpaꞋa ku ni ka ko a tsulai n ikebe a̱ ubuta̱ wo omoci, a kiɗai le avaja feu koɓolo n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Vuzavaguɗu u yotsongi ka̱ci ka̱ ni kpamu wi Ibirahi ɗevu nu nɗanga m gbagbaꞋin m Mamure ayin a na wi ida̱shi a̱ utsutsu u ka̱pa̱m ka̱ ni n kanna usuɗukpi. ");
INSERT INTO asg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ana u ɗengusa̱i a̱shi a̱ ni ɗa we enei uma a tatsu kashani ɗevu n a̱yi. Ana we enei le ɗa wu uta̱i a̱ utsutsu u ka̱pa̱m ka̱ ni n kafura adama a na u gasa n ele. Ɗa u kuɗa̱ngi ali kuca̱n ku ni a kusaꞋwa iɗika. ");
INSERT INTO asg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","U danai, <<Aza a gbagbaꞋin, mi baci a̱ kuciya̱ mapasa ma singai wa̱ ɗa̱, mi a kuciga i laza kpaꞋa ku kagbashi ku ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","YaꞋan a̱ tuka̱ m mini i saꞋa ene a̱ ɗa̱ ka̱ta̱ yu uvuka a̱ kulu ku maɗanga ku nampa. ");
INSERT INTO asg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mpa yaꞋan kpamu m bana n tuka̱ ɗa̱ n ilikulyaꞋa, ka̱ta̱ i ciya̱ utsura wu nwalu, adama a na i ta̱wa̱ ta̱ a kpaꞋa ku kagbashi ku ɗa̱.>> Ɗa ta na a̱ ushuki, <<YaꞋan tsu na vu danai.>> ");
INSERT INTO asg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ɗa Ibirahi u yaꞋin moloko, ɗa u uwai a̱ ka̱pa̱m ka̱ ni ɗa u danai Saratu. <<Saratu yaꞋan gogoꞋo, ɗika kiya ku singai adama a na vi yaꞋanka uma a nanlo emeshe.>> ");
INSERT INTO asg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ɗa Ibirahi u sumai ɗa u uwai ushiga u ni ɗa u ɗikai medendem ma singai, ɗa u nekei kagbashi ka̱ ni ka kiɗaka uma a. ");
INSERT INTO asg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ɗa u tuka̱i m maniꞋin, m mani n inyama i na u suꞋwain va, ɗa u nekei omoci a̱ ni. A̱yi a̱ ka̱ci ka̱ ni ɗa u nekei le ilikulyaꞋa ya ɗa u shamgbai lo a̱ kulu ku yoku e le tamkpamu a kulyaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ɗa we ecei ni, <<Te ɗai tamkpamu Saratu vuka vu nu?>> Ɗa wu ushuki <<Wi ta̱ ɗe a̱ ka̱pa̱m.>> ");
INSERT INTO asg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","A̱ ka̱tsuma̱ ke le vuza te u danai, <<Mayun na a kubana ka̱ya̱ vuka vu nu Saratu wi ta̱ a̱ kuciya̱ maku mo kolobo.>> Saratu lo ta na a̱ kucina̱ ki Ibirahi a kupana a ayin a na u shamgbai lo a̱ utsutsu u ka̱pa̱m. ");
INSERT INTO asg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","A ayin a nanlo ta na Ibirahi n Saratu a kutsa ta̱, a̱yi Saratu kpamu u buwa o kudoku kene kusumbu ba. ");
INSERT INTO asg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ɗa Saratu u zosoi ma̱ɗuku ɗa u danai, <<Mpa ɗa na n kutsa ta̱, mi ta̱ o kudoku ma pana uyoꞋo u vali kpamu? Ko n nannai ba vali vu va̱ vu kutsa ta̱.>> ");
INSERT INTO asg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ɗa Vuzavaguɗu u danai Ibirahi, <<Yiɗa̱i i zuwai ɗa Saratu u zosoi ɗa u danai. Nini ɗai n kuciya̱ maku n tsukutsa tsu va̱>>? ");
INSERT INTO asg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","<<Ili yi ta̱ lo i na i laꞋi Vuzavaguɗu utsura? Tsu na n danai na wotoi kuci Saratu wi ta̱ a̱ kuciya̱ maku.>> ");
INSERT INTO asg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Adama a na Saratu wi a kupana wovon ɗa u nannai kaꞋa u danai, <<N zoso ba>> ama u danai, <<Vu zoso ta̱.>> ");
INSERT INTO asg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ana uma a a̱ ɗa̱nga̱i kulaza ɗa a indanai a kubana ɗaka a uɓon u Sodom. Ɗa ta na Ibirahi u soki le adama a na a̱ ka̱na̱ uye. ");
INSERT INTO asg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ɗa Vuzavaguɗu u danai, <<Mi o kusokonku Ibirahi i na mi a kuciga kuyaꞋan ba, ");
INSERT INTO asg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ibirahi wi ta̱ o kokpo iɗika i gbayin n iɗika yu utsura kpamu, ka̱ta̱ iɗika kakau i na yi a̱ kucina̱ ku ni i ciya̱ una̱singai a̱ ubuta̱ u ni. ");
INSERT INTO asg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","N zagba yi ta̱ adama a na u zuwa muku m kpaꞋa n ni nu ntsukaya n ni o tono uye u Vuzavaguɗu a̱ ubuta̱ u kuyaꞋan kasingai m ma̱riki, nannai ɗa Vuzavaguɗu u kuneke Ibirahi ili i na u yaꞋankai ni uzuwakpani dem.>> ");
INSERT INTO asg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ɗa Vuzavaguɗu u danai Ibirahi, <<M pana ta̱ ili i gbani-gbani i na a dansai adama aza o Sodom n Gomora. Unushi u le u wuyana ta̱ ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mi ta̱ a̱ kucipa̱ n ka̱ci ka̱ va̱ me ene ko ili i na i a kudansa adama a uma a mayun ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ɗa uma a a kpatalai a lazai o kubono Sodom, ama ɗa Ibirahi wo okpoi lo kashani e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ɗa Ibirahi u yawai ɗevu ɗa we ecei Vuzavaguɗu va, <<Vi ta̱ a kuna aza a ciɗa koɓolo n aza a unushi dem>>? ");
INSERT INTO asg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Uma amangerenkupa i baci ciɗa punu a̱ likuci ya vi ta̱ a kuna likuci ya dem? Va̱ kuka̱sukpa̱ likuci ya adama a na vi isa uma amangerenkupa ba? ");
INSERT INTO asg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","U jebeshe vu yaꞋan ili tsu nanlo, va kuna uma a singai adama aza a unushi ba, aza a singai a kutakacika n aza a unushi ba. Avu ɗa vuza va afada va aduniyan. U jebeshe va kuna uma ra̱ka̱ ba. ");
INSERT INTO asg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ɗa Vuzavaguɗu u danai, <<N ciya̱ baci uma amangerenkupa a singai o Sodom, mi ta̱ a̱ kuka̱sukpa̱ likuci ya adama e le.>> ");
INSERT INTO asg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ɗa Ibirahi u danai, <<Ka̱sukpa̱ n doku n yaꞋan kadanshi n avu Vuzavaguɗu, ko a na wo okpoi mpa vuma ɗa mi koci vu na a yaꞋin n kayala. ");
INSERT INTO asg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Uma amangere n a tawun i baci ta na punu uma a singai vi ta̱ a̱ kuka̱sukpa̱ likuci ya? Vi ta̱ a kuna likuci ya adama a na vu namba ta̱ uma tawun a ciɗa?>> Ɗa Vuzavaguɗu u danai, <<N cina baci uma amangere n tawun aza a singai mi ta̱ a̱ kuka̱sukpa̱ likuci ya.>> ");
INSERT INTO asg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ɗa u doku u danai, <<A̱ ciya̱ baci ta na uma amangere punu a̱ likuci ya>>? Ɗa Vuzavaguɗu wu ushuki, <<Adama a uma amangere a nanlo ma kuna likuci ya ba.>> ");
INSERT INTO asg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ɗa u danai, <<Ka̱ta̱ avu Vuzavaguɗu vi yaꞋan wupa nu mpa ba, ama yaꞋan n doku n dansa. Vi ciya̱ baci ta na uma kamangankupa koci, vi ta̱ a kuna likuci ya?>> Ɗa wu ushuki, <<N ciya̱ baci punu uma kamangankupa aza a singai, ma kuna likuci ya ba.>> ");
INSERT INTO asg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ɗa u danai, <<Ka̱ta̱ avu Vuzavaguɗu vi yaꞋan wupa nu mpa ba, ama yaꞋan n doku n dansa, a̱ ciya̱ baci uma kamanga punu a̱ likuci ya ta na?>> U danai, <<Adama a uma kamanga a nanlo, ma kuna likuci ya ba.>> ");
INSERT INTO asg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ɗa Ibirahi u doku u danai, <<Ka̱ta̱ avu Vuzavaguɗu vi yaꞋan wupa nu mpa ba, ama yaꞋan n doku n dansa ku te. A̱ ciya̱ baci punu uma kupa ta na?>> Ɗa Vuzavaguɗu wu ushuki, <<Ma a kuna likuci ya ba n ciya̱ baci aza a singai kupa punu.>> ");
INSERT INTO asg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ayin a na u kotsoi kadanshi n Ibirahi, ɗa Vuzavaguɗu u lazai ɗa Ibirahi u lazai o kubono a kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Alingata e re a nanlo a yawai Sodom n kulivi, a̱yi Lotu ida̱shi a̱ utsutsu u likuci wa. Ana we enei le, ɗa u ɗa̱nga̱i u banai kugasa n ele. U rabasai le ali ɗa u kuɗa̱ngi ɗa u lyaꞋakai le kayala. ");
INSERT INTO asg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","U danai, <<Aza gbagbaꞋin a̱ va̱ mpa ɗa na adama a̱ ɗa̱. Ta̱wa̱i a kpaꞋa ku va̱, i sumba̱ ka̱ta̱ kpamu ya asa. Kayin ka asa baci n usana i yeve i laza.>> Ama a̱ ushuki, <<A̱Ꞌa̱, ci ta̱ a kubana tsa ka asa pulai punu a asuvu a̱ likuci.>> ");
INSERT INTO asg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","U folonoi le n utsura, ali ta na o tonoi ni a kubana a kpaꞋa ku ni. U yaꞋankai le ka̱ɗiva̱ ɗa u doku u kangalaka yi le boroji vu na vi babu yisiti, ɗa ta na a lyaꞋi. ");
INSERT INTO asg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kafu omoci a a uwa ubuta̱ wa alavu, uma a̱ likuci i Sodom ushan wawaꞋa nu nkoshi dem a̱ ta̱wa̱i a kambuki kpaꞋa ka. ");
INSERT INTO asg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ɗa e ecei Lotu, <<Te uma a na a̱ ta̱wa̱i wa̱ nu n kayin ka? Uta̱ka̱ le na wa̱ tsu, ci ciga ta̱ kuvaku n ele.>> ");
INSERT INTO asg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lotu wu uta̱i u banai we le, ɗa u ɓa̱ya̱ngi utsutsu wa. ");
INSERT INTO asg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ɗa u danai, <<N folono ɗa̱ ta̱ aza a̱ va̱, ka̱ta̱ i yaꞋan ili i gbani-gbani ba. ");
INSERT INTO asg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","La̱na̱i mi ta̱ nkere n re n na ka̱ta̱ a saꞋwai kuvaku n ali ba, yaꞋan mu uta̱ka̱ le n tuka̱ ɗa̱, ka̱ta̱ i yaꞋan n ele tsu na i cigai; ama ka̱ta̱ i saꞋwa uma a nanlo ba, a kpaꞋa ku va̱ ku ɗa a̱ ta̱wa̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ama ɗa a danai, <<Ɗenga̱ lo, vuma vu nampa va komoci kaꞋa wi biꞋi wa̱ tsu, ɗa u cigai kushesheke tsu ili i na tsa kuyaꞋan. Gogo na ci ta̱ a kuyaꞋanka wu ili i gbani-gbani i na i laꞋi i uma a nanlo.>> Ɗaɗa e tecengi Lotu, ɗa ta na a banai a̱ utsutsu wa adama a na o ɓoso u ɗa. ");
INSERT INTO asg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ama ɗa omoci a a̱ uta̱ka̱i ekiye pulai ɗa o ronoi Lotu o bonokoi a asuvu a kpaꞋa, ɗa a̱ ɓa̱ya̱ngi utsutsu wa. ");
INSERT INTO asg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A zuwakai uma a̱ likuci a na i lo utsutsu u kpaꞋa wa uyimba̱, dem vi le maku n vuza gbayin feu, ali ɗa a̱ kpa̱ɗa̱i kufuɗa ke ene ubuta̱ u na utsutsu wa wi. ");
INSERT INTO asg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ɗa alingata a e ecei Lotu kpamu, <<Vi ta̱ lo n uma o yoku kpamu ototo, muku, nkere, ko kumaci ku yoku punu a̱ likuci ya? Uta̱ka̱ le na. ");
INSERT INTO asg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Adama a na ci ciga ta̱ kuna ubuta̱ u nampa, ka̱sa̱la̱ ka uma punu a̱ ubuta̱ u nampa ka yimkpa ta̱, ɗa ka yawai u Ka̱shile, Vuzavaguɗu u suku tsu ta̱ tsu una likuci ya.>> ");
INSERT INTO asg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lotu wu uta̱i u banai u danai ototo a̱ ni a na a kuzuwa nkere n ni, <<Ɗenga̱i, uta̱i punu a̱ likuci i nampa; Vuzavaguɗu u ciga ta̱ ku una likuci ya.>> Ama ototo a̱ ni a sheshe ta̱ majari maꞋa wi a kuyaꞋanka le. ");
INSERT INTO asg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ana kayin ka asai, alingata a a gutsakai Lotu, a danai, <<Ɗenga̱, ɗika vuka vu nu ni nkere n re n nu n na mi na, ta baci nannai ba, atakaci a̱ likuci a nampa i ta̱ o kukotso n a̱ɗa̱ punu dem.>> ");
INSERT INTO asg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ana e enei ni a kuyaꞋan a gbama, ɗa a̱ ka̱na̱i ni kukiye n ku vuka vi ni nu nkere ma. Ɗa a̱ uta̱ka̱i le punu a̱ likuci ya. Adama a na Vuzavaguɗu u pana ta̱ asuvayali e le. ");
INSERT INTO asg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ana a̱ ciya̱i a̱ uta̱ka̱i le, ɗa vuza yoku a̱ ka̱tsuma̱ ka uma e re a nanlo u danai, <<Sumai, adama a wuma u ɗa̱, ka̱ta̱ i la̱na̱ kucina̱ ba, ka̱ta̱ kpamu i shamgba a̱ ubuta̱ ba. Sumai a kubana a nsasan, ko a̱ɗa̱ feu i kuwa̱ n ele.>> ");
INSERT INTO asg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ɗa Lotu u danai le, A̱Ꞌa̱ aza a gbayin a̱ va̱ ");
INSERT INTO asg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","kagbashi ka̱ ɗa̱ ka̱ ciya̱ ta̱ mapasa wa̱ ɗa̱, i neke mu ta̱ ugaꞋin u gbayin a na yi isai wuma u va̱; ama ma kusuma a kubana a nsasan adama o wovon u na kawuya ka kucina mu ali n kuwa̱ ɗe ba. ");
INSERT INTO asg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Indana, likuci i nanlo i yawa ta̱ uma a suma a kubana ɗe, i kenu i ɗa ta na. YaꞋan n suma m bana ɗe, ko yi kenu ba? Ka̱ta̱ wuma u va̱ u ciya̱ wishi! ");
INSERT INTO asg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","U danai ni, <<U gaꞋan ta̱, n neke wu ta̱ kasingai ka nampa, i a kuna likuci i na vi yaꞋin kadanshi ka ba. ");
INSERT INTO asg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","YaꞋin moloko i suma, ka̱ta̱ n kuyaꞋan ili ba, sai ayin a na i yawai ɗe.>> Ɗaɗa e ɗekei likuci ya Zora. ");
INSERT INTO asg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ayin a na Lotu u yawai a Zora ɗaɗa kanna kuta̱i. ");
INSERT INTO asg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ɗa Vuzavaguɗu u cipa̱ka̱i n akina n ka̱nga̱ ko tsukono o Sodom n Gomora. Akina a̱ uta̱ ta̱ a̱ ubuta̱ u Vuzavaguɗu ɗa a̱ cipa̱i ɗe. ");
INSERT INTO asg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ɗa wu unai likuci i nanlo n uma a na i punu ida̱shi a̱ ubuta̱ u nanlo dem, n ili i na i tsu uta̱ ka̱ta̱ i gbonguro a iɗika dem. ");
INSERT INTO asg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ɗa vuka vu Lotu vu la̱na̱i kucina̱, ɗa wo okpoi katali ka mkpaɗi. ");
INSERT INTO asg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ibirahi u ɗa̱nga̱i n usana ɗa u banai a̱ ubuta̱ u na wi ishi u shamgbai cau e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ɗa wi indanai a uɓon u Sodom n Gomora n iɗika i gbani dem, ɗa we enei ka̱nga̱ ki iɗika ka a kubana gaɗi an mini mo kokocilili. ");
INSERT INTO asg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ta nannai ana Ka̱shile ka unai iɗika ya̱ a̱ra̱Ꞌa̱ ya, Ka̱shile ka ciɓai n Ibirahi, ɗa wu uta̱ka̱i Lotu punu e mere ma aza a na a unai, ana wu unai iɗika i na Lotu u yongoi va. ");
INSERT INTO asg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ana ka nampa ko kotsoi, ɗa Lotu ni nkere n re n ni a̱ ka̱sukpa̱i Zora ɗa o bonoi a vaki a uɓon wu nsasan, adama a na u pana ta̱ wovon u shamgba a Zora. A̱yi ni nkere n re n ni o yongoi a kaɓatsu. ");
INSERT INTO asg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kanna ke te mekere ma gbayin ma ma danai vangu vi ni, <<Esheku a̱ tsu a kutsa ta̱, vali vi lo uɓon u nampa a na wa̱ ta̱wa̱ wa̱ tsu ba, tsu na wila̱ u danai. ");
INSERT INTO asg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","YaꞋan tsu zuwa esheku a̱ tsu u soꞋo ma̱ra̱ ma maka yi ka̱ta̱ u vaku n a̱ tsu, ka̱ta̱ ci ciya̱ kumaci n esheku a̱ tsu ali kulyaꞋa kelime.>> ");
INSERT INTO asg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","N kayin ka nanlo a zuwai esheku e le o soꞋi ma̱ra̱ ma makai ni, ɗa mekere ma gbayin ma banai ma vaki n a̱yi. Esheku e yeve ayin a na u vaki m mekere ma̱ ni ko mekere ma vaki n a̱yi ali u ɗa̱nga̱i ba. ");
INSERT INTO asg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kanna ke ire ɗa mekere ma gbayin ma ma danai vangu va, <<Na̱yin n vaku ta̱ n dada vu va̱. YaꞋan tsu zuwa yi u soꞋo ma̱ra̱ ma maka yi kpamu n kayin, ka̱ta̱ avu vu bana vu vaku n a̱yi adama a na ci ciya̱ kumaci n esheku a̱ tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","N kayin ka nanlo ɗa a zuwai esheku e le u soꞋi ma̱ra̱ ma makai ni kpamu, ɗa mekere me kenu ma, ma banai ɗa ma vaki n a̱yi. Nannai kpamu Esheku e yeve ayin a na u vaki m mekere ma̱ ni ko mekere ma vaki n a̱yi ali u ɗa̱nga̱i ba. ");
INSERT INTO asg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nkere n Lotu gbende n yaꞋin a̱tsuma̱ n esheku e le. ");
INSERT INTO asg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mekere ma gbayin ma matsai maku mo kolobo, ɗa u neꞋi kula Mowabu, a̱yi ɗa esheku a aza a Mowabu anana. ");
INSERT INTO asg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Vangu va feu u matsai maku mo kolobo, ɗa u neꞋi ni kula Ben-ami; a̱yi ɗa ta na esheku a aza a Amona anana. ");
INSERT INTO asg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ana Ibirahi u ka̱sukpa̱i uɓon u nanlo ɗa u lazai a kubana a uɓon u ɗaka vu KanaꞋana ɗa u yongoi e mere me Kadeshi n Shuru. U yongoi ɗe ali ayin ukeci an komoci a Gera, ");
INSERT INTO asg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ɗa Ibirahi u danai le ukuna u vuka vi ni Saratu, <<Taku vu va̱ ɗa.>> Ɗa Abimeleki mogono ma Gera u danai a banka yi n Saratu. ");
INSERT INTO asg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ama n kayin ko yoku, Vuzavaguɗu u yotsongi ka̱ci ka̱ ni u mogono Abimeleki tsa alatani ɗa u danai ni, <<Vi ta̱ a̱ kukuwa̱ adama a na vi ɗika ta̱ vuka vu nampa, vu na vi yaꞋin ɗe yolo.>> ");
INSERT INTO asg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ama a̱yi Abimeleki ka̱ta̱ u saꞋwa kuyawa ɗevu n Saratu ba. Ɗa u danai, <<Vuzavaguɗu mi n unushi punu na ba! Vi ta̱ a kuna mu n uma a̱ va̱ dem? ");
INSERT INTO asg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ibirahi n ka̱ci ka̱ ni u danai, na va taku vi ni ɗa. Ɗa vuka va feu vu danai nannai. N yaꞋan ta̱ ili i nampa ya n ka̱ɗu ke te mpa n nusa ba.>> ");
INSERT INTO asg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ɗa Vuzavaguɗu u danai ni punu a̱ ubuta̱ wa alatani wa, <<E n yeve ta̱ vi yaꞋan ta̱ nannai n ka̱ɗu ke te, n sa̱nka̱ wu ta̱ kuyaꞋan unushi a kubana wa̱ va̱, n ka̱sukpa̱ wu vu saꞋwa yi ba. ");
INSERT INTO asg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ama gogo na bonoko n vuka va u vali vi ni. A̱yi keneki kaꞋa, wi ta̱ a kuyaꞋanka wu avasa adama a na vi yongo n wuma. Ama mi ta̱ a kudana wu vu bonoko yi baci ba, vi ta̱ a̱ kukuwa̱ avu n uma a̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ana kayin kasai ɗa Abimeleki u ɗekei aza gbagbaꞋin a̱ ni dem a bana, ɗa u danai le ili i na i yaꞋin dem ɗa ra̱ka̱ vi le ɗa a panai wovon. ");
INSERT INTO asg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ɗa Abimeleki u ɗekei Ibirahi ɗa we ecei ni, <<Yiɗa̱i i zuwai ɗa vi yaꞋankai tsu nahannai? Unushi we ne u ɗai n yaꞋankai nu ɗa vi a kuyaꞋanka mu atakaci a nampa, mpa n ubuta̱ u tsugono u va̱ dem? Vi yaꞋanka mu ta̱ ili i na i kpa̱ɗa̱i kugaꞋan vi yaꞋanka mu.>> ");
INSERT INTO asg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ɗa Abimeleki we ecei ni, <<Yiɗa̱i i zuwai ɗa vi yaꞋin nannai?>> ");
INSERT INTO asg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ɗa Ibirahi wu ushuki u danai, <<N yaꞋan ta̱ nannai adama a na n zuwa ta̱ uma a nampa a i n wovon u Ka̱shile ba, ta lo a kuna mu ka̱ta̱ a isa mu Saratu vuka vu va̱. ");
INSERT INTO asg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ko n nannai taku vu va̱ ɗa mayun, adama a na mekere me esheku a̱ va̱ maꞋa mma ɗa de vi tsu vi te ba, ɗa n ɗikai ni yolo. ");
INSERT INTO asg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","A ayin a na Ka̱shile ka zuwai mu n ka̱sukpa̱ kpaꞋa ke esheku a̱ va̱ a kubana a iɗika i yoku, ɗa n danai ni, <Uteku u na vo kuyotsongu ucigi u nu a kubana wa̱ va̱ u ɗaɗa na, ubuta̱ u na baci tsu banai dem, vu dana, <<A̱yi taku vu va̱ ɗa.>> > >> ");
INSERT INTO asg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ɗa Abimeleki u bonokoi Ibirahi n vuka vi ni Saratu, ɗa u nekei ni anaka, nlala koɓolo n agbashi a ali n a̱ma̱ci. ");
INSERT INTO asg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ɗa Abimeleki u danai ni, <<La̱na̱ na iɗika i va̱ i ɗa ra̱ka̱ zagba ubuta̱ u na u gaꞋin nu kuyongo ka̱ta̱ vi yongo ɗe.>> ");
INSERT INTO asg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ɗa Abimeleki u danai Saratu, <<Mi ta̱ e kuneke tavu Ibirahi Azurufa ka̱kpa̱n adama a na wo okpo urotu mpa n yaꞋan ili n avu ba, e kelime ka uma dem. Babu vuza na kpamu u kinda wu adanshi vi yaꞋan ta̱ unushi.>> ");
INSERT INTO asg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ɗa Ibirahi u yaꞋankai Abimeleki kavasa ɗa Ka̱shile ko potsokpoi ni n a̱ma̱ci a̱ ni n agbashi a̱ a̱ma̱ci a̱ ni dem adama a na a matsa muku kpamu. ");
INSERT INTO asg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Adama a na Vuzavaguɗu u ɓa̱ya̱ngu ta̱ amatsatsu dem a kpaꞋa ku Abimeleki adama a vuka vi Ibirahi Saratu. ");
INSERT INTO asg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Vuzavaguɗu u yaꞋanka ta̱ Saratu ili i singai tsu na u danai. Ɗa u yaꞋankai ni tsu na u yaꞋin uzuwakpani. ");
INSERT INTO asg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ɗa Saratu u yaꞋin ka̱tsuma̱, ɗa u matsakai Ibirahi maku mo kolobo n tsukutsa ci ni. Derere a ayin a na Ka̱shile ka yaꞋankai ni uzuwakpani. ");
INSERT INTO asg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ɗa Ibirahi u neꞋi maku ma na Saratu u matsakai ni va kula Ishaku. ");
INSERT INTO asg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ana maku ma̱ ni Ishaku u yawai ayin kunla̱i, ɗa Ibirahi u kiɗai ni kavaja, uteku u na Ka̱shile ka danai ni. ");
INSERT INTO asg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibirahi wi ta̱ n a̱ya̱ amangatawun (100), ana a matsakai ni Ishaku. ");
INSERT INTO asg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ɗa Saratu u danai, <<Ka̱shile ka̱ tuka̱ mu ta̱ n izoshi. Adama a na vuza na baci u panai nannai, wi ta̱ o kuzoso nu mpa.>> ");
INSERT INTO asg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ɗa u doku u danai, <<Yayi u saꞋwai kudana Saratu u kumatsaka ta̱ Ibirahi maku? Ama m matsaka yi ta̱ n tsukutsa ci ni.>> ");
INSERT INTO asg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ɗa maku ma mo gbonguroi ali ɗa a kasai ni mani. A kanna ka na a kasai ni mani, ɗa Ibirahi u yaꞋin ka̱ɗiva̱ ka gbayin. ");
INSERT INTO asg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ana Saratu we enei IshimaꞋilu maku ma na Hajara va aza a Masar u matsakai Ibirahi a kuyaꞋanka Ishaku ulami, ");
INSERT INTO asg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ɗa u danai Ibirahi, <<Uta̱ka̱ n kabara ke mekere ka a kpaꞋa ku nampa m maku ma̱ ni. Adama a na maku ma nanlo me kupece ili yi uka̱ni a kpaꞋa a nampa m maku ma̱ va̱ Ishaku ba.>> ");
INSERT INTO asg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ili ya i la̱nga̱sa̱ ta̱ Ibirahi ka̱ɗu wuya-wuya, adama a na ili i ya i saꞋwa ta̱ maku ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ama ɗa Ka̱shile ka danai ni <<Ka̱ta̱ ka̱ɗu ka̱ nu ka̱ na̱mgba̱ adama a maku ma n kabara ka nanlo ba. Pana ili i na Saratu u kudana wu dem. Adama a na a̱ ubuta̱ wi Ishaku ta lo e kuyeve ntsukaya n nu. ");
INSERT INTO asg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mi ta̱ o kubonoko muku n kabara ke mekere ka, o okpo ngono mu utsura n uma feu a̱ gba̱ra̱-gba̱ra̱. Adama a na a̱yi feu maku ma̱ nu maꞋa.>> ");
INSERT INTO asg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","N usana ɗa Ibirahi u nekei Hajara ilikulyaꞋa n kedele ku ukpan tukpa m mini, u woꞋokoi ni kaꞋa a kavangatsu ɗa u lokoi ni m maku ma. U lazai ɗa u yongoi a̱ kuka̱ra̱Ꞌa̱sa̱ punu a kakamba ka Biyasheba. ");
INSERT INTO asg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ana mini ma mo kotsoi punu e kedele ka ra̱ka̱, u ka̱sukpa̱i maku ma a̱ kumiꞋi ku ka̱vuku. ");
INSERT INTO asg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","U da̱sa̱ngi daꞋin a agisana udashi amangatawun. U danai ka̱ci ka̱ ni, <<Mi a kufuɗa ma kinda maku ma̱ va̱ ma̱ kuwa̱ ba.>> A̱yi lo ida̱shi ɗa u ɓosoi ka̱da̱wuri u gita̱ngi ma̱shi. ");
INSERT INTO asg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ka̱shile ka panai maku ma a̱ ma̱shi, ɗa kalingata ka̱ Ka̱shile na ɗe gaɗi ka yaꞋin kadanshi n Hajara, <<Yiɗa̱i i ɓa̱la̱i nu, Hajara? Ka̱ta̱ vu pana wovon ba. Ka̱shile ka pana ta̱ ma̱shi ma maku mo kolobo ma. ");
INSERT INTO asg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ɗenga̱, bana vu ɗika maku ma̱ nu ka̱ta̱ vu ɓa̱na̱ e kukiye. Mi ta̱ a kuzuwa ntsukaya n ni mo okpo likuci i gbayin.>> ");
INSERT INTO asg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ɗa Ka̱shile ka̱ ɓa̱yuwa̱i a̱shi a vuka a, ɗa we enei kayinva. U banai u shatangi kedele ku ukpan ka m mini ɗa u banai u neꞋi maku ma. ");
INSERT INTO asg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ka̱shile ko yongo ta̱ koɓolo m maku ma ali u gbonguroi, u yongoi a kakamba ka Param, ɗa kpamu wo okpoi katain ku usuɓi. ");
INSERT INTO asg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ayin a na a̱yi ɗe ida̱shi a kakamba ka Param ɗa a̱na̱ku a̱ ni a zamakai ni vuka mekere ma aza a Masar. ");
INSERT INTO asg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","A ayin a nanlo Abimeleki n Fikolu, kovonshi vo osoji a̱ ni, ɗa u danai Ibirahi, <<Ka̱shile ki ta̱ koɓolo n avu a̱ ubuta̱ wi ili dem i na vi a kuyaꞋan. ");
INSERT INTO asg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kucinaka mu n Ka̱shile na, vu dana vo kudoro mu ba, muku n va̱, ko ntsukaya n va̱. Mi ta̱ kutono kadanshi ka̱ nu mayin, yaꞋan uzuwakpani vi ta̱ o kutono kadanshi ka̱ va̱, koɓolo n iɗika i na vi o kuyongo na.>> ");
INSERT INTO asg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibirahi u danai, <<N yaꞋan ta̱ uzuwakpani wa.>> ");
INSERT INTO asg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ibirahi u tuka̱i m mavura ma̱ ni u Abimeleki adama a ukuna u kayinva u na agbashi a Abimeleki a isai. ");
INSERT INTO asg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki u danai, <<N yeve vuza na u yaꞋin kaꞋa ba. Vu dana mu feu ba, anana ɗa n gita̱i kupana kaꞋa.>> ");
INSERT INTO asg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ɗa Ibirahi u nekei Abimeleki nkyon n anaka o yoku, ɗaɗa ele aza e re le a yaꞋankpanai uzuwakpani. ");
INSERT INTO asg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibirahi wu uta̱ka̱i nshan mi nkyon ali n cindere a̱ ubuta̱ wu ushiga u ni, ");
INSERT INTO asg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ɗa Abimeleki we ecei ni, <<Yiɗa̱i tamkpamu nshan n cindere n nampa mi a kadanshi?>> ");
INSERT INTO asg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibirahi wu ushuki, <<Isa nkyon n cindere n nampa ma. Nannai va wi ta̱ a kuzuwa vu ushuku a na mpa ɗa n ga̱va̱i kayinva ka nampa ka.>> ");
INSERT INTO asg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ɗaɗa e ɗekei ubuta̱ wa Biyasheba, adama a na ta ɗe ele aza e re e le a yaꞋankpanai akucina. ");
INSERT INTO asg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ana o kotsoi kuyaꞋan uzuwakpani u nampa a Biyasheba, ɗa Abimeleki n Fikolu kovonshi vo osoji a̱ ni o bonoi a iɗika i a Filisitiya. ");
INSERT INTO asg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ɗaɗa Ibirahi u shikpa̱i maɗanga ma matana a Biyasheba ɗa u cikpai Vuzavaguɗu lo, Ka̱shile MalaꞋimili. ");
INSERT INTO asg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibirahi u yongoi a iɗika i a Filisitiya ali ayin n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","A yaꞋin megeshe kenu, ɗa Ka̱shile ko kondoi Ibirahi. U danai ni, <<Ibirahi.>> Ɗa wu ushuki, <<Mpa ɗa na.>> ");
INSERT INTO asg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ɗa Ka̱shile ka danai ni, <<Ɗika maku ma̱ nu me te ma na vi m maꞋa Ishaku, vuza na kpamu vi a kuciga, vi ɗika a kubana a uɓon u Moriya. Vu bana vi lyuka yi tsa alyuka o kusongu a̱ ubuta̱ u masasan mo yoku ma na mi ɗe a̱ ubuta̱ u na n kuyotsongu wu.>> ");
INSERT INTO asg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ana kayin ka asai n usana, ɗa Ibirahi u ɗa̱nga̱i u lapulai majaki ma̱ ni. Ɗa u ɗikai abara a̱ ni e re m maku ma̱ ni Ishaku. Ɗa u zamai nɗanga kpamu n na u kuyaꞋanka alyuka o kusongu. Ɗa u lazai a kubana a̱ ubuta̱ u na Ka̱shile ka danai ni. ");
INSERT INTO asg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","A kanna ka tatsu ka̱ ka̱tsuma̱ ka nwalu ke le, ɗa Ibirahi u la̱na̱i, ɗa we enei ubuta̱ wa daꞋin. ");
INSERT INTO asg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ɗa u danai abara a̱ ni, <<Shamgbai na m majaki. Mpa n kolobo ka̱ va̱, ci ta̱ a kubana na ɗe. Ci ta̱ a kubana tsa cikpa Ka̱shile, ka̱ta̱ tsu bono.>> ");
INSERT INTO asg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ɗa Ibirahi u ɗikai nɗanga n na u kuyaꞋanka alyuka o kusongu a, ɗa u zuwakai Ishaku maku ma̱ ni u canuku. Ɗa u ɗikai akina m mawun. Ana a kulaza aza e re e le, ");
INSERT INTO asg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ɗa Ishaku u ɗekei esheku Ibirahi, <<Dada.>> Ɗa Ibirahi wu ushuki, <<Yiɗa̱i, maku ma̱ va̱?>> Ɗa Ishaku we ecei ni, <<Nɗanga n ɗa na n akina, te ɗai malala mi adama a alyuka o kusongu?>> ");
INSERT INTO asg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ɗa Ibirahi u danai ni, <<Ka̱shile ki ta̱ e kuneꞋe tsu malala ma na tsa kuyaꞋanka alyuka o kusongu, maku ma̱ va̱.>> Ɗa a lazai aza e re e le. ");
INSERT INTO asg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ɗa u yawai a̱ ubuta̱ u na Ka̱shile ko yotsongi ni u bana va, ɗa Ibirahi u shikpa̱i katalikalyuka, ɗa u recei nɗanga gaɗi. Ɗa u shiyai maku ma̱ ni Ishaku, ɗa u kiyangi gaɗi vu nɗanga va. ");
INSERT INTO asg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ɗa u ba̱ra̱kpa̱i kukiye, ɗa u ɗikai mawun adama a na u kiɗa maku ma̱ ni Ishaku. ");
INSERT INTO asg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ɗa kalingata ka Vuzavaguɗu ke ɗekei ni gaɗi, <<Ibirahi, Ibirahi.>> Ɗa wu ushuki, <<Mpa ɗa na.>> ");
INSERT INTO asg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ɗa u danai ni, <<Ka̱ta̱ vu gbatyangu mawun e kuɗeku ku maku ma ba. Ka̱ta̱ vi yaꞋanka yi muna ba. N yeve ta̱ gogo na vi ta̱ a kupana wovon u Ka̱shile. Adama a na vu sa̱nga̱ mu maku me te ma na vi n maꞋa ba.>> ");
INSERT INTO asg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ɗa Ibirahi u ganukpai kaci, ɗa we enei ka̱giri n avana a̱ ni a̱ kumiꞋi ku koworo usaɓatangi. Ɗa u banai, ɗa u ɗikai kaꞋa. Ɗa u lyukai kaꞋa a̱ ubuta̱ u Ka̱shile ɗa u ka̱sukpa̱i maku ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ɗa Ibirahi u ɗekei ubuta̱ u nanlo wa, <<Vuzavaguɗu wi ta̱ a̱ kutuka̱.>> A uteku n kanna ka nanlo ɗa a danai, <<Punu a kusan ku Vuzavaguɗu, wi ta̱ a̱ kutuka̱.>> ");
INSERT INTO asg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ɗa kalingata ka Vuzavaguɗu na ɗe gaɗi ke ɗekei Ibirahi uɗeki u ire. ");
INSERT INTO asg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ɗa u danai ni, <<Vuzavaguɗu u danai, <N kucina ta̱ n ka̱ci ka̱ va̱, ali vu fuɗai vi yaꞋin nannai, vu sa̱nga̱ mu maku me te ma̱ nu ba. ");
INSERT INTO asg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Mi ta̱ a kuzuwaka wu una̱singai. Mi ta̱ a kuzuwa ntsukaya n nu n yimkpa mo okpo an azangata a gaɗi. I ta̱ a kuyimkpa kpamu o okpo an kayala ka mala. Ntsukaya n nu mi ta̱ a kisa likuci yi irala i le. ");
INSERT INTO asg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","A̱ ubuta̱ wu ntsukaya n nu n ɗa uma a aduniyan dem a̱ kuciya̱ ili i singai. Adama a na avu vu tono mu ta̱ mayin.> >> ");
INSERT INTO asg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ɗa Ibirahi u bonoi a̱ ubuta̱ wa agbashi a̱ ni, ɗa a lazai koɓolo a kubana Biyasheba. Ɗa Ibirahi u shamgbai ta na ɗe a Biyasheba va. ");
INSERT INTO asg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","A kubana megeshe ɗe ɗa a danai Ibirahi, <<Milika feu u matsaka ta̱ vuza nu muku. ");
INSERT INTO asg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uzu ɗa magaji, Buzu ɗa vangu vi ni, Kemuwe tamkpamu esheku a Aram, ");
INSERT INTO asg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseda, n Hazo, m Pilidasha, n Jidilafa, koɓolo m Betuwe.>> ");
INSERT INTO asg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwe ɗa esheku e Rebeka. Milika u matsakai Nahoru Ibirahi vuza ni muku kunla̱i n nampa. ");
INSERT INTO asg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Vuka vu gbani vi ni vu na vi n kula Reyuma, u matsakai ni muku feu, ula e le a ɗa Teba, n Gaham, n Tahasha, koɓolo m MaꞋaka. ");
INSERT INTO asg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saratu u yaꞋan ta̱ a̱ya̱ amangatawun n kamanga n e cindere (127) kafu u kuwa̱. ");
INSERT INTO asg_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","U kuwa̱ ta̱ a Kiriyatu (ɗaɗa Heburon) a iɗika i KanaꞋana, ɗa Ibirahi u shika̱i ɗa kpamu u yaꞋin kpalu ku ni. ");
INSERT INTO asg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ɗa Ibirahi u ɗa̱nga̱i lo kashani ɗevu n keven ki ikyamba ka vuka vi ni, ɗa u yaꞋin kadanshi n aza a Hitiya u danai, ");
INSERT INTO asg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","<<Mpa komoci kaꞋa mi na o kuyongo n a̱ɗa̱, denke mu iɗika uɓon u yoku adama a na n ciɗa̱ngu keven ka ka̱ta̱ mu uvuka.>> ");
INSERT INTO asg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ɗa aza a Ahitiya a̱ ushuki Ibirahi, ");
INSERT INTO asg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","<<Panaka tsu, vuzagbayin. Avu mogono ma gbayin maꞋa wa̱ tsu. Ciɗa̱ngu vuka vu nu a̱ ubuta̱ u singai u na u luwai nu, babu vuza na u kusa̱nka̱ wu ubuta̱ u kuciɗa̱ngu vuka vu nu.>> ");
INSERT INTO asg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ɗa Ibirahi u kuɗa̱ngi e kelime ka aza a Ahitiya, uma a iɗika a. ");
INSERT INTO asg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ɗa u danai le, <<Yi baci a̱ kuka̱sukpa̱ mu n ciɗa̱ngu vuka vu va̱ na, to panakai mu ka̱ta̱ i folonoko mu Iforono kolobo ko Zahoru, ");
INSERT INTO asg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","u neke mu kaɓatsu ka Makapele ka na ki ka̱ ni a uteku wu ubuta̱ u ni. Danai ni u denke mu uteku u na ikebe i ni yi, e kelime ka̱ ɗa̱ na, adama a na wo okpo mu ubuta̱ u ka̱ciɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ɗa Iforono vu a Hitiya lo a̱ ubuta̱ wo oɓolo wa a̱ utsutsu u likuci wa: ɗa wu ushuki e kelime ka yaba dem a kupana, ");
INSERT INTO asg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ta nannai ba vuzagbayin, <<Panaka mu, ubuta̱ wa n kaɓatsu ka dem n kuneꞋe wu ta̱. Na e kelime ka uma a̱ va̱ dem, mi ta̱ e kuneke wu adama a na vu ciɗa̱ngu vuka vu nu.>> ");
INSERT INTO asg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ɗa Ibirahi u kuɗa̱nki uma a iɗika a, ");
INSERT INTO asg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ɗa u danai Iforono, adama a na yaba dem u pana, <<Vu ushuku baci yaꞋan n tsupa wu ikebe yu ubuta̱ wa dem. Isa ikebe ya, adama a na n ciɗa̱ngu vuka vu va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Iforono va wu ushuki Ibirahi, ");
INSERT INTO asg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","<<Vuzagbayin panaka mu, ubuta̱ wa u yawa ta̱ Azurufa amangatawa̱na̱shi. Yiɗa̱i yi punu e mere ma̱ tsu? Ciɗa̱ngu punu vuka vu nu.>> ");
INSERT INTO asg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ɗa Ibirahi wu ushuki ɗa u tsupai ni e kelime ka aza a Ahitiya lo dem Azurufa amangatawa̱na̱shi (400) uteku na u danai va. Ɗa u tsupai tsu na aza a tsulaga a ci gisanku. ");
INSERT INTO asg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ta ubuta̱ u na wi ishi wi Iforono a Makapele a kasana ka Mamure wo okpoi wi Ibirahi nannai. Ka̱ba̱nga̱ ka n kaɓatsu, nu nɗanga dem. ");
INSERT INTO asg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Aza Ahitiya a na i a kuꞋuwa n utsutsu u likuci wa e yeve ta̱ ubuta̱ wa wo okpo ta̱ wi Ibirahi. ");
INSERT INTO asg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ana ka nanlo ko kotsoi ɗa Ibirahi u ciɗa̱ngi vuka vi ni Saratu punu a kaɓatsu ka̱ ka̱ba̱nga̱ ka Makapele ɗevu m Mamure ɗaɗa kpamu Heburon a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ka̱ba̱nga̱ ka na ki wa aza Ahitiya n kaɓatsu ka dem ɗa wo okpoi ubuta̱ u ka̱ciɗa̱ wi Ibirahi. ");
INSERT INTO asg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Gogo na Ibirahi u kutsa ta̱, a̱ya̱ a̱ ni kpamu a yimkpa ta̱. Ɗa Vuzavaguɗu u zuwakai ni una̱singai a ili i na u yaꞋin dem. ");
INSERT INTO asg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibirahi u danai kagbashi kagbayin ka̱ ni vuza na u laꞋi n kugeshe a kpaꞋa ka, vuza na kpamu wi a kindaka yi ili i na wi n i ɗa dem a kpaꞋa. <<Zuwa ekiye a̱ nu e mere ma̱ nkuta̱ n va̱, ");
INSERT INTO asg_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","mi ta̱ a kuciga wu vu kucinaka mu n Kula ku Vuzavaguɗu, Ka̱shile ka gaɗi n ki iɗika, va kuzamaka maku ma̱ va̱ vuka punu a uma a KanaꞋana a̱ ubuta̱ u na mi o kuyongo na ba. ");
INSERT INTO asg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ama vu bono ɗe a iɗika i na a matsai mu a umaci u va̱ adama a na vu zamaka maku ma̱ va̱ Ishaku vuka a̱ ka̱tsuma̱ ku umaci u va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ɗa Kagbashi ka ke ecei, <<Maku ma vuka ma ma iwan baci ta na kuka̱sukpa̱ likuci i ni ɗa u danai u kutono mu ba? N ɗika maku ma̱ nu o kubono a iɗika i na vu uta̱i?>> ");
INSERT INTO asg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ɗa Ibirahi wu ushuki, <<Ka̱ta̱ vu bonoko maku ma̱ va̱ ɗe a̱ ubuta̱ u na mu uta̱i ba! ");
INSERT INTO asg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Vuzavaguɗu Ka̱shile ka na ki gaɗi vuza na wu uta̱ka̱i mu a iɗika yi mmaci n va̱, ɗa kpamu u yaꞋankai mu uzuwakpani u gbayin u kuneke mu ta̱ iɗika i nampa mpa nu ntsukaya n va̱. Wi ta̱ a̱ kusuku kalingata ka̱ ni kelime ka̱ nu kafu vi yawa, adama a na vi ciya̱ka̱ maku ma̱ va̱ vuka ɗe. ");
INSERT INTO asg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Maku mavuka ma mi baci a kuciga kuta̱wa̱ n avu ba, akucina a̱ va̱ o kutono wu ba, avu de ka̱ta̱ vu bonoko m maku ma̱ va̱ ɗe ba>> ");
INSERT INTO asg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ɗa kagbashi ka zuwai ekiye a̱ ni a ɗaka vu nkuta̱ mi Ibirahi ɗa u kucinai n ili i na Ibirahi u danai ni. ");
INSERT INTO asg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ɗa kagbashi ka u ɗikai arakuma kupa a vuzagbayin vi ni, ɗa u ɗikai ili i singai i kuneꞋe yi ikebe kakau a u vuzagbayin vi ni. Ɗa u banai a̱ likuci i na Nahoru wi ida̱shi gaɗi vu Mesopotamiya ");
INSERT INTO asg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ana u yawai ɗa u zuwai arakuma a dem a̱ kuɗa̱ngi ɗevu n kayinva ka na ki pulai vi likuci. N kulivi ku ɗa ta na, ayin a na a̱ma̱ci a̱ tsu uta̱ a kubana o kuɗolu. ");
INSERT INTO asg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ɗa u yaꞋin avasa, <<Vuzavaguɗu Ka̱shile ka vuzagbayin vu va̱ Ibirahi neke mu uye anana, yotsongu vuzagbayin vu va̱ ucigi u na wi a kusaꞋwa kusabaꞋa ba. ");
INSERT INTO asg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mpa ɗa na a kashani ɗevu n kayinva ka̱ mini a̱ ubuta̱ u na muku ma̱ a̱ma̱ci n likuci mi a̱ kuta̱ kukenuku mini. ");
INSERT INTO asg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","YaꞋan n fuɗa n dana mekere mo yoku, <Mi ta̱ ufolu u nu neꞋe mu mini mo kusoꞋo,> u dana baci soꞋo, mi ta̱ feu e kuneꞋe arakuma a̱ nu mini o soꞋo wo okpo vuza na vu zagbakai kagbashi ka̱ nu Ishaku, Ili i nampa ya i yaꞋan baci nannai, mi ta̱ e kuyeve vi yotsongu ta̱ vuzagbayin vu va̱ ucigi u na u kusabaꞋa ba.>> ");
INSERT INTO asg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kafu u kotso kadanshi, Ɗa Rebeka u yawai m ma̱diki ma̱ mini ma̱ ni ucaniki a kavangatsu ka̱ ni. A̱yi mekere me Betuwe maꞋa, maku ma Milika vuka vu Nahoru Ibirahi vuza ni. ");
INSERT INTO asg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Maku ma vuka ma mi ta̱ n tsuloboi, ka̱ta̱ ta na u yeve mavali ba. U banai a kayinva ɗa u shatangi ma̱diki ma̱ ni m mini ɗa u bonoi kpamu. ");
INSERT INTO asg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ɗa kagbashi ka ka sumai, ɗa ka banai wa̱ ni ka danai, <<N folono wu ta̱, neꞋe mu mini mo kusoꞋo punu a̱ ma̱diki ma̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ɗa mekere ma ma danai, <<SoꞋo vuzagbayin vu va̱,>> ɗa u zuwai ni ma̱diki ma gogoꞋo a kavangatsu ka̱ ni, ɗa u neꞋi ni u soꞋo. ");
INSERT INTO asg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ana u kotsoi kuneꞋe yi mini ma ɗa u danai, <<Mi ta̱ o kuronoko arakuma a̱ nu feu ali sai ayin a na o kotsoi kusoꞋo.>> ");
INSERT INTO asg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ɗa u yaꞋin moloko u tsuwa̱in mini ma na mi a̱ ma̱diki ma̱ ni punu a̱ ubuta̱ u na nnama n tsu soꞋo, ɗa u sumai u banai a kayinva adama a na u doku mini, ali ɗa u neꞋi arakuma a ra̱ka̱ mini ");
INSERT INTO asg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ɗa vuma va u ka̱na̱i kinda mekere ma babu kudansa ili adama a na u yeve ko Vuzavaguɗu u pana ta̱ avasa a̱ ni, ɗa nwalu n ni n yaꞋin mayin ba. ");
INSERT INTO asg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ana arakuma a o kotsoi kusoꞋo mini ma ɗa vuma va u ɗikai makawani ma azanariya ma na a̱miki a̱ ni a yawai kagimi ka shekelu, ɗa u ukai ni a̱ vunu ɗa u la̱nsa̱i nshingi n re m gbagbaꞋin ɗa u ukai ni e kukiye. ");
INSERT INTO asg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ɗa kabara ka danai, <<N folono wu ta̱ dana mu ko yayi eshevu. Yi ta̱ ɗe n kunu ku na tsa kasa mpa n uma a̱ va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ɗa mekere ma mu ushuki, <<Esheku a̱ va̱ a ɗa Betuwe maku ma na Milika u matsakai Nahoru.>> ");
INSERT INTO asg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ɗa u doku wu ushuki, <<Ci ta̱ ɗe n ijanu n a̱bunda̱i a kpaꞋa ku tsu, ci ta̱ ɗe kpamu n unu a ivaꞋin adama a̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ɗa vuma va u kuɗa̱ngi ɗa u cikpai Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ɗa u danai, <<Una̱singai wo okpo u Vuzavaguɗu Ka̱shile ka vuzagbayin vu va̱ Ibirahi, vuza na u zuwai ucigi u ni u na u kusabaꞋa ba, a kubana u vuzakpa vu va̱ Ibirahi. N tsu va̱ na, Vuzavaguɗu u tono ta̱ nu mpa a kubanka a kpaꞋa ku vuzagbayin vu va̱ aza a̱ ni babu kadama.>> ");
INSERT INTO asg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ɗa maku ma vuka ma ma sumai a kubana a kpaꞋa wa̱ a̱na̱ku, ɗa u danai ni arabali a dem tsu na ili ya i yaꞋin. ");
INSERT INTO asg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka wi ta̱ n taku vu na e ci ɗeke Laban, ɗa u sumai a kubana a kayinva ka a̱ ubuta̱ u na kagbashi ki Ibirahi ka ki. ");
INSERT INTO asg_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ana we enei makawani a̱ vunu ni nshingi o kubolu ku taku, ɗa kpamu u panai kadanshi ka a̱ una̱ u taku vi ni Rebeka <<Ili i na vuma va u danai mu i ɗa na.>> Ɗa u banai u kagbashi ki Ibirahi ka, vuza na wi a kashani a̱ ubuta̱ wa arakuma wa a kayinva, ");
INSERT INTO asg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ɗa u danai ni, <<Ta̱wa̱i na, avu vuma vu na Vuzavaguɗu u zuwakai una̱singai. Yiɗa̱i i zuwai ɗa vi a kashani pulai? Mi ta̱ punu n kunu ku na n foɓusokoi ɗa̱, n ubuta̱ adama a arakuma a̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ɗa vuma va u uwai a kpaꞋa ka, ɗa Laban u cipa̱ka̱i n ucanuku wa arakuma wa ɗa u nekei le kalu n ijanu i yoku. U bankai n vuma va m mini u saꞋa ene, koɓolo n uma a na u walakai a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ana a̱ tuka̱i n ilikulyaꞋa, ɗa vuma va u danai, <<Mi a kulyaꞋa ka̱ta̱ ba, sai n dansa ili i na mi a kuciga kudansa.>> Ɗa Laban u danai, <<LyaꞋa kelime n kadanshi.>> ");
INSERT INTO asg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ɗa u danai, <<Mpa kagbashi ki Ibirahi kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Vuzavaguɗu u zuwaka ta̱ vuzakpa vu va̱ una̱singai ka̱u ɗa u bonokoi ni vuza vu uciyi. U nekei ni ushiga wa anaka n wu nlala koɓolo ni nkyon, n azanariya n Azurufa, n agbashi a ali n a̱ma̱ci dem, n arakuma, ni njaki. ");
INSERT INTO asg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ɗa Saratu vuka vu vuzakpa vu va̱, u matsakai ni maku n tsukutsa ci ni, ɗa u nekei ni ili i na wi n i ɗa dem. ");
INSERT INTO asg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Vuzakpa vu va̱ u zuwai mu n yaꞋan uzuwakpani n akucina u danai, <Ka̱ta̱ vu zamaka maku ma̱ va̱ vuka punu a̱ ka̱tsuma̱ ke nkere ka aza a KanaꞋana a̱ ubuta̱ u na mi ida̱shi na ba. ");
INSERT INTO asg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ama vu bana a̱ ubuta̱ wu umaci u va̱ n isheku i va̱, ka̱ta̱ vu zamaka maku ma̱ va̱ vuka.> ");
INSERT INTO asg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","<<Ɗa me ecei vuzagbayin vu va̱, <Vuka va vi iwan baci ta na kutono mu a̱ kuta̱wa̱?> ");
INSERT INTO asg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ama ɗa u danai mu, <Vuzavaguɗu, a̱yi na mi o kutono ayin tutu mayin, wi ta̱ a̱ kusuku kalingata ka̱ ni ka bana n avu ka̱ta̱ ka zuwa vi ciya̱ ili i na n danai. Adama a na vi ciya̱ka̱ maku ma̱ va̱ vuka a̱ ubuta̱ wu umaci u va̱, n ubuta̱ u kpaꞋa ke esheku a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Vi ta̱ a kufuɗa kupece ka̱ci ka̱ nu n akucina a̱ va̱, vu bana baci a̱ ubuta̱ wu umaci u va̱ ɗa a iwain kuneke wu mekere ma, nannai vu buwa m ma̱shinda̱ ba.> ");
INSERT INTO asg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","<<Ana m banai a kayinva ka anana, ɗa n vasai, <Vuzavaguɗu, Ka̱shile ka vuzakpa vu va̱ Ibirahi, adama a̱ Ka̱shile neke mu uye n ciya̱ ili i na n ta̱wa̱i kula̱nsa̱. ");
INSERT INTO asg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mpa ɗa na kashani a kayinva. Mekere ma̱ ta̱wa̱ baci kunuku mini, mi ta̱ o kufolono yi u neꞋe mu mini mo kusoꞋo kenu e ma̱diki ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Wu ushuku baci ali u danai, <<SoꞋo, mi ta̱ feu e kuneꞋe arakuma a̱ nu,>> YaꞋan wo okpo mekere ma na Vuzavaguɗu u zagbakai maku ma vuzakpa vu va̱.> ");
INSERT INTO asg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","<<Babu n kotso avasa a̱ va̱ punu n ka̱bini, Ɗa Rebeka u ta̱wa̱i n ma̱diki m mini ucaniki a kavangatsu ka̱ ni ɗa u banai a kayinva kunuku mini. Ɗa n danai ni, <Adama a̱ Ka̱shile neꞋe mu mini mo kusoꞋo.> ");
INSERT INTO asg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","<<Ɗa u yaꞋin gogo u cipa̱ka̱i n ma̱diki ma̱ ni a kavangatsu ɗa u danai, <SoꞋo, mi ta̱ feu e kuneꞋe arakuma a̱ nu o soꞋo.> N soꞋi ɗa kpamu u neꞋi arakuma a. ");
INSERT INTO asg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","<<Ɗa me ecei ni, <Yayi tamkpamu eshevu?> <<Ɗa wu ushuki, <Esheku a̱ va̱ a ɗa Betuwe maku ma Nahoru vuza na Milika u matsakai ni.> <<Ɗa n ukai ni makawani a̱ vunu vi ni koɓolo ni nshingi o obolu a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","N kuɗa̱ngi ɗa n cikpai Vuzavaguɗu. N cikpai Vuzavaguɗu, Ka̱shile ka vuzakpa vu va̱ Ibirahi, a̱yi na u tonoi nu mpa derere sai a̱ ubuta̱ wu umaci u vuzakpa vu va̱ adama a na n zamaka yi kejene ko okpo vuka vu maku ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Gogo na vi baci a kushatangu kasingai n uneki u ka̱ɗu a kubana u vuzakpa vu va̱, adama a̱ Ka̱shile dana mu, ko vi baci a kuyaꞋan, ko vi a kuyaꞋan ba, ka̱ta̱ n ciya̱ n yeve uye u kutono.>> ");
INSERT INTO asg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban koɓolo n Betuwe a̱ ushuki, <<Ili i nampa ta yu uta̱i a̱ ubuta̱ u Vuzavaguɗu, a̱ tsu ci n ili i na tsa kudana ba. ");
INSERT INTO asg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ɗa na lo kelime ka̱ nu, ɗika yi i wala u bana wo okpo vuka vu maku ma vuzakpa vu nu, tsu na Vuzavaguɗu n ka̱ci ka̱ ni u danai.>> ");
INSERT INTO asg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","A ayin a na kagbashi ki Ibirahi ka panai ili i na a danai ɗa u kuɗa̱ngi sai iɗika ɗa u cikpai Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ɗa kagbashi ka uta̱ka̱i n ucanuku wa azanariya n Azurufa koɓolo nu ntogu ɗa u nekei Rebeka, ɗa kpamu u neꞋi a̱na̱ku n taku kuneꞋe ki ikebe ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ɗa a̱yi n aza a na i a nwalu koɓolo ɗa lyaꞋi ɗa o soꞋi ɗa a asai lo. Ɗa u danai, ayin a na baci a jimgbai n usana, <<Ka̱sukpa̱i mu m bono u vuzakpa vu va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ama ɗa taku vu Rebeka n a̱na̱ku a Rebeka a danai, <<YaꞋan mekere ma mo doku mo yongo n a̱ tsu ali ayin kupa ka̱ta̱ u yeve u tono ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ɗa u danai le, <<Ka̱ta̱ i la̱nga̱sa̱ mu ayin o kubono ba a̱ ubuta̱ u vuzavaguɗu vu va̱ ba, a na Ka̱shile ka zuwai nwalu n va̱ n lyaꞋi agaꞋin, ka̱sukpa̱i mu n bono u vuzagbayin vu va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ɗa a danai, <<YaꞋan ci ɗeke mekere ma ci ece yi n una̱ u ni.>> ");
INSERT INTO asg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ɗa e ɗekei Rebeka ɗa e ecei ni, <<Vi ta̱ a kufuɗa vo tono vuma vu nampa va?>> Ɗa wu ushuki, <<Eyeu mi ta̱ o kutono yi.>> ");
INSERT INTO asg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ɗaɗa a̱ ushuki Rebeka u tono le n vuka vu na vu woꞋi ni ayin a na a̱yi maku, ele n kagbashi ki Ibirahi n aza na i n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ɗa dem vi le a zuwakai Rebeka una̱singai tsu nampa, <<Taku vu tsu yaꞋan vu matsa ali a̱kpa̱n-a̱kpa̱n n a̱bunda̱i, yaꞋan ntsukaya n nu a isa utsutsu kakau wi irala i le.>> ");
INSERT INTO asg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ɗa Rebeka n a̱ɓa̱nki a̱ ni a̱ma̱ci ɗa a̱ ɗa̱nga̱i o foɓusoi ɗa a kumbai arakuma a ɗa o tonoi kagbashi ki Ibirahi ka n aza a̱ ni, ɗa kagbashi ka ɗikai Rebeka ɗa a lazai. ");
INSERT INTO asg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Gogo na Ishaku wu uta̱ ta̱ a Biya-lahi-royi, wi ishi ta̱ ida̱shi a iɗika i Negebu. ");
INSERT INTO asg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wu uta̱i pulai adama a na u lapa wunla̱i n kulivi ɗa u ɗengusa̱i a̱shi ɗa we enei arakuma a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ana Rebeka u ɗengusa̱i a̱shi ɗa we enei Ishaku. Ɗa u cipa̱i gaɗi vu karakuma ka na wi ukumbi. ");
INSERT INTO asg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ɗa we ecei kagbashi ki Ibirahi, <<Yayi tamkpamu vuma vu nan ɗe, a nwalu adama a na u gasa n a̱ tsu?>> Ɗa kagbashi ka ku ushuki ni, <<Ai vuzakpa vu va̱ ɗa.>> Ɗa u ɗikai ka̱ka̱la̱bi ka̱ ni ɗa u palai ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ɗa kagbashi ka ka danai Ishaku ili i na u yaꞋin ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ɗa Ishaku u ɗikai Rebeka ɗa u uwakai ni a̱ ka̱pa̱m ka̱ a̱na̱ku a̱ ni Saratu, ɗa wo okpoi vuka vi ni. Ishaku kpamu ɗa u cigai vuka vi ni ka̱u. Ɗa u ciya̱i uremi u ka̱ɗu ana a̱na̱ku a̱ ni a̱ kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ɗa Ibirahi u zuwai vuka vi yoku kula ku ni ku ɗa Ketura. ");
INSERT INTO asg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ɗa u matsakai ni Zimiran n Jokashan m Medan m Medan n Ishibaku koɓolo n Shuwa. ");
INSERT INTO asg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokashan a̱yi ɗa esheku e Sheba n Dedanu. Muku n Dedanu ele ɗa aza a Ashurim n aza a Letushim n aza a LeꞋumim. ");
INSERT INTO asg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Muku m Midiya ele ɗa anan Efa n Eferu n Hanoku, n Abida n Eleda. Dem vi le ntsukaya n Ketura n ɗa. ");
INSERT INTO asg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibirahi u nekei Ishaku ili yu uka̱ni i ni i na wi n i ɗa dem. ");
INSERT INTO asg_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ama muku n ali ma̱ a̱ma̱ci a na u zuwasai, ɗa u nekei le kuneꞋe, ali a̱yi biꞋi n wuma adama a na a̱ ka̱sukpa̱ Ishaku, ɗa o tonoi a kubana a iɗika i kasana. ");
INSERT INTO asg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibirahi u yaꞋan ta̱ a̱ya̱ amangatawun n amangatatsunkupa n a tawun (175). Ɗa u kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ibirahi u yinvikai ayinviki a ukocishi ɗa u kuwa̱i a̱ ka̱tsuma̱ ka̱ a̱ya̱ a singai. A̱ya̱ a̱ ni a yimkpa ta̱ ɗa u yongoi kpamu gbaga tsu na u gaꞋin. Ɗa u banai u cinai ikaya i ni. ");
INSERT INTO asg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Muku n ni Ishaku n IsumaꞋilu a̱ ciɗa̱ngi ni a kaɓatsu ka Makapele kasana m Mamure a̱ ubuta̱ u Iforono maku ma Zoharu vuza va aza Hitiya. ");
INSERT INTO asg_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ubuta̱ u na Ibirahi u tsulai wa aza a Hitiya, ta punu a̱ ciɗa̱ngi ni ubuta̱ u te n vuka vi ni. ");
INSERT INTO asg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ana Ibirahi u kuwa̱i, ɗa Ka̱shile ka zuwakai maku ma̱ ni Ishaku una̱singai. Vuza na u yongoi ɗevu m Biya-lahi-royi. ");
INSERT INTO asg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Na va ɗaɗa arabali a̱ muku mi IsumaꞋilu, maku ma na maku mu usuki ma Saratu Hajara vuza va aza a Masar u matsakai Ibirahi. ");
INSERT INTO asg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Na va ɗaɗa ula a̱ muku mi IsumaꞋilu, a ɗanai a ɗa uteku u na a matsai le, Nebatu a̱yi ɗa maku ma iyain ma IsumaꞋilu n Kedaru n Adabelu, m Mibisam kpamu, ");
INSERT INTO asg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","m Mishima n Duma koɓolo m Masa, ");
INSERT INTO asg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","n Hadadu koɓolo n Tema, n Jeturu, Nafishi n Kedema. ");
INSERT INTO asg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Na va ɗaɗa muku mi IsumaꞋilu n ula e le, yaba dem n likuci n ka̱tsura̱ ka na wi a kulyaꞋa tsugono, ele ngono kupa ni n re n ɗa tsu na umaci u le wi. ");
INSERT INTO asg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","A̱yi IsumaꞋilu u yaꞋan ta̱ a̱ya̱ amangatawun n kamangankupa n e cindere (137) ɗa kpamu u yaꞋin ayinviki a ukocishi a̱ ni, ɗa wu uvukai n ikaya i ni. ");
INSERT INTO asg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ntsukaya n ni a̱ da̱sa̱ngi ta̱ a uɓon u Havila a kubana a Shuru a uɓon wu uteku m Masar, vu tono baci a kubana Asiriya. Ɗa o yongoi a tsurala n otoku i le. ");
INSERT INTO asg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Na va ɗaɗa arabali a Ishaku maku mi Ibirahi. Ibirahi ɗa esheku a Ishaku. ");
INSERT INTO asg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ayin a na Ishaku u yawai a̱ya̱ a amangere, ɗa a yaꞋin yolo n Rebeka, mekere ma Betuwe (vuza va aza a Aramiyan vu na wu uta̱i a Fada-aram). Rebeka kpamu taku vu Laban vuza va Aram ɗa. ");
INSERT INTO asg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ama Rebeka madari maꞋa, ɗa Ishaku u yaꞋankai ni kavasa. Vuzavaguɗu wi isai avasa a nanlo, ɗa Rebeka u ciya̱i ka̱tsuma̱. ");
INSERT INTO asg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Muku n gita̱i punu kunekenei atakaci punu a̱ ka̱tsuma̱ ka uteku u le, ɗa u danai, <<Yiɗa̱i nannai a̱ kuciya̱ mu?>> U banai u Vuzavaguɗu n avasa adama a na u ciya̱ wu ushuki. ");
INSERT INTO asg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ɗa Vuzavaguɗu u danai ni, <<Iɗika i re yi ta̱ punu a̱ ka̱tsuma̱ ka̱ nu, mpeshe n na mi punu wa̱ nu va i ta̱ a kuyaꞋan tsurala. Vuza te u kulaꞋa ta̱ vuza ni, vuzagbayin va u kubono ta̱ o kutono vangu.>> ");
INSERT INTO asg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ana ayin a kumatsa a yawai, ɗa u matsai mpeshe olobo koci. ");
INSERT INTO asg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Vuza na u gita̱i kuta̱ wu uta̱i ushili, ikyamba i ni adanshi motogu me cileme maꞋa u ukai. Ɗa e neꞋi ni kula Isuwa. ");
INSERT INTO asg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ɗaɗa yeve vuza ni u tonoi, n kukiye ku ni uka̱ni a̱ ka̱civa̱ ka Isuwa. Ɗa e neꞋi ni kula Yakubu. Ishaku wi ta̱ n a̱ya̱ amangatatsu ayin a na a matsai muku n nanlo. ");
INSERT INTO asg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ana olobo a o gbonguroi, ɗa Isuwa wo okpoi katain ku utsura, vuma vu ucigi u kakamba. Ama, Yakubu vuma vu ka̱bini ɗa n ucigi u kpaꞋa kpamu. ");
INSERT INTO asg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishaku u laꞋa ta̱ n kuciga Isuwa, adama a inyama i na u tsu una ka̱ta̱ u bonoko a kpaꞋa. Ama, Rebeka u laꞋa ta̱ n kuciga Yakubu. ");
INSERT INTO asg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kanna ke te, ana Yakubu wi a ku suꞋwan kpayan, ɗa Isuwa u yawai wana ɗai wu uta̱ a kutambu. Wi ta̱ ta na a kupana kambulu. ");
INSERT INTO asg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ɗa u danai Yakubu, <<NeꞋe mu ilikulyaꞋa m kpayan ku shili, n lyaꞋa mi ta̱ a kupana kambulu.>> (Ɗaɗa i zuwai ɗa e ɗekei ni Edom.) ");
INSERT INTO asg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ɗa Yakubu wu ushuki, <<Mi ta̱ e kuneke wu, vi denke mu baci tsugbayin tsu nu, mo okpo vuza kelime vu nu.>> ");
INSERT INTO asg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isuwa u danai, <<U gaꞋan ta̱! Mi ta̱ ɗevu n ukpa̱, yi ɗa̱i tsugbayin tsa kuyaꞋanka mu?>> ");
INSERT INTO asg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ɗa Yakubu u danai, <<Kucina biꞋi, ve kudenke mu baci tsugbayin tsa.>> Ɗa Isuwa u kucinai, ɗa u denke vangu va tsugbayin tsa. ");
INSERT INTO asg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ɗa Yakubu u nekei Isuwa boroji m kpayan. U lyaꞋi ɗa u soꞋi, yeve u ɗa̱nga̱i u lazai. Ta Isuwa u yaꞋin nannai ɗa u goyoi tsugbayin ci ni. ");
INSERT INTO asg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Gogo na kambulu ka̱ yikpa̱ ta̱ a iɗika, ko yoku kpamu n ka na ka yaꞋin a ayin a Ibirahi. Ɗa Ishaku u banai u Abimeleki mogono ma Gera ma a Filisitiya. ");
INSERT INTO asg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ɗa Vuzavaguɗu u ta̱wa̱i wi Ishaku ɗa u danai, <<Ka̱ta̱ vu bana a Masar ba, shamgba a iɗika i na n danai nu vi yongo. ");
INSERT INTO asg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Shamgba biꞋi a iɗika i nampa ayin kenu, mi ta̱ koɓolo n avu mi ta̱ kpamu a kuzuwaka wu una̱singai. Avu nu ntsukaya n nu n ɗa mi e kuneke iɗika i nampa ra̱ka̱ ka̱ta̱ n shatangu uzuwakpani n akucina a na n yaꞋin n eshevu Ibirahi. ");
INSERT INTO asg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mi ta̱ a kuzuwa ntsukaya n nu mo okpo n ka̱bunda̱i a na azangata a gaɗi, mi ta̱ kpamu e kuneke ntsukaya ma iɗika i nampa ra̱ka̱, uma aduniyan dem i ta̱ a̱ kuciya̱ una̱singai a̱ ubuta̱ u le, ");
INSERT INTO asg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","adama a na Ibirahi u tono ta̱ kadanshi ka̱ va̱ ɗa kpamu u ka̱na̱i i na n cigai koɓolo n uye u va̱ n wila̱ u va̱ feu.>> ");
INSERT INTO asg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ɗa Ishaku u da̱sa̱ngi a Gera. ");
INSERT INTO asg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ana uma a nanlo e ecei ni ukuna u vuka vi ni, ɗa u danai le, <<Taku vu va̱ ɗa,>> adama a na wi ta̱ o wovon a na wa dana, <<Vuka vu va̱ ɗa,>> u sheshe ta̱, <<Uma a̱ ubuta̱ a a kuna mu ta̱ adama a Rebeka, adama a na wi ta̱ n tsuloboi n a̱bunda̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ana Ishaku wi ɗe ali m megeshe ɗa mogono Abimeleki mogono ma aza a̱ a Filisitiya u la̱na̱i n katusu ɗa we enei Ishaku o ku oɓongusu Rebeka vuka vi ni. ");
INSERT INTO asg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ɗa Abimeleki u ɗekei Ishaku ɗa we ecei ni, <<Yiɗa̱i i zuwai ɗa vu kpa̱ɗa̱i kudana mu a̱yi vuka vu nu ɗa? Ama ɗa vu danai <Taku vu va̱ ɗa?> >> Ɗa Ishaku u danai ni, <<Adama a na me ene ta̱ i ta̱ a kufuɗa a kuna mu adama a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ɗa Abimeleki u danai, <<Yiɗa̱i i zuwai ɗa vi yaꞋankai tsu nahannai? A̱ ka̱tsuma̱ ka̱ tsu vuza yoku wi ishi a kuvaku n vuka vu nu gbani ka̱ta̱ ta na u tuka̱ tsu n una̱ u wuya.>> ");
INSERT INTO asg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ɗa Abimeleki u dansukai uma dem ɗa u danai, <<Vuza na baci de dem u saꞋwai vuma vu nampa ko vuka vi ni i ta̱ a kuna yi.>> ");
INSERT INTO asg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","A̱ ka̱ya̱ ka nanlo Ishaku u yaꞋin vica̱Ꞌa̱ ɗa u kyaꞋi ili n a̱bunda̱i adama a na Vuzavaguɗu u zuwakai ta̱ una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ɗa Ishaku wo okpoi vuza vu uciyi, ɗa uciyi u ni u ka̱na̱i kutatsa ali ɗa wo okpoi vuza vu uciyi ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Wi ta̱ n ushiga wu nlala ni nkyon n agbashi n a̱bunda̱i ali ɗa aza Filisitiya a̱ ka̱na̱i tsurala n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ɗa aza a Filisitiya a̱ ciɗa̱ngi ra̱ka̱ ayinva a na agbashi e esheku a̱ ni a̱ ga̱va̱i a ayin a Ibirahi wi ishi n wuma. ");
INSERT INTO asg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ɗa Abimeleki u danai Ishaku, <<Ɗenga̱ vu ka̱sukpa̱ka̱ tsu iɗika i tsu adama a na vu laꞋa ta̱ utsura u tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ɗa Ishaku u ka̱sukpa̱i ubuta̱ wa ɗa u banai u zuwai ka̱pa̱m ka̱ ni a iɗika i Gera ɗa u yongoi ɗe. ");
INSERT INTO asg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ɗa Ishaku u doku ɗa u ga̱va̱sa̱ka̱i ayinva a na ishi uga̱vi a ayin a esheku a̱ ni Ibirahi, adama a na aza a̱ Filisitiya a̱ sa̱nka̱ le ta̱ ana esheku a̱ ni a̱ kuwa̱i, ɗa u neꞋi le kpamu ula a na esheku a̱ ni ishi e neꞋi le. ");
INSERT INTO asg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ɗa nguɓi mi Ishaku n ga̱va̱i kayinva a̱ ka̱ra̱Ꞌa̱ ɗa a̱ ciya̱i ka̱shi ka̱ mini ka singai. ");
INSERT INTO asg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ɗa nguɓi n Gera n yaꞋin kanananai nu nguɓi mi Ishaku ɗa a danai, <<Mini ma ma̱ tsu maꞋa>> Ɗa u ɗekei ubuta̱ wa Eseke, ɗaɗa <<Kanananai>> adama a na ta lo a yaꞋin kanananai. ");
INSERT INTO asg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ɗa a̱ ga̱va̱i kayinva ko yoku ɗa o doku a yaꞋin kanananai kpamu, Ɗa Ishaku u ɗekei kayinva ka Sitina, ɗaɗa Tsurala. ");
INSERT INTO asg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ɗa u ɗa̱nga̱i ɗa u banai u ga̱va̱i ko yoku, na lo o doku a yaꞋan kanananai ba, ɗa u ɗekei kayinva ka n kula Rehobotu. Ɗaɗa <<Gogo na Vuzavaguɗu u neke tsu ta̱ uba̱ruwi ka̱ta̱ tsu matsa ci yimkpa punu a iɗika ya.>> ");
INSERT INTO asg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Lo a ubuta̱ wa ɗa Ishaku u lazai a kubana a Biyasheba. ");
INSERT INTO asg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","N kayin ka nanlo ɗa Vuzavaguɗu u yotsongi ka̱ ci ka̱ ni wa̱ ni ɗa u danai, <<Mpa ɗa Ka̱shile ke eshevu Ibirahi. Ka̱ta̱ vu pana wovon ba, adama a na mi ta̱ koɓolo n avu, mi ta̱ a kuzuwaka wu una̱singai ka̱ta̱ n zuwa ntsukaya n nu n yimkpa adama a kagbashi ka̱ va̱ Ibirahi.>> ");
INSERT INTO asg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ɗa Ishaku u maꞋi katalikalyuka lo a̱ ubuta̱ wa ɗa u cikpai Vuzavaguɗu. Ɗa feu u ka̱nza̱i lo ka̱pa̱m ka̱ ni, ɗa nguɓi i ni n ga̱va̱i lo kayinva. ");
INSERT INTO asg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","A̱yi mogono Abimeleki wu uta̱i Gera ɗa u ta̱wa̱i wa̱ ni koɓolo n Ahuzatu vuza na u ci neke yi odoki n Fikolu kovonshi vo osoji. ");
INSERT INTO asg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ɗa Ishaku we ecei le, <<Yiɗa̱i i zuwai ɗa i ta̱wa̱i wa̱ va̱, adama a na i iwan mu ta̱ n ayin a ɗe ɗa i lokoi mu wa̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ɗa a̱ ushuki, <<Ce ene ta̱ hawun a na Vuzavaguɗu wi koɓolo n avu, i ɗaɗa i zuwai ɗa tsu danai yaꞋan ci yaꞋan uzuwakpani n avu ka̱ta̱ tsu kucinukpanai kpamu tsu dana, ");
INSERT INTO asg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","va kusaꞋwa vuma vi te a̱ ka̱tsuma̱ ka̱ tsu ba, tsu na a̱ tsu ci ci yongo a kuyaꞋanka wu kasingai ka̱ta̱ kpamu tsu loko wu a kulaza m ma̱ta̱na̱. Gogo na avu ɗa vuza na Vuzavaguɗu u zuwakai una̱singai.>> ");
INSERT INTO asg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ɗa Ishaku u foɓusokoi le ka̱ɗiva̱ ɗa a lyaꞋi ɗa o soꞋi. ");
INSERT INTO asg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ana kayin ka asai n usana ɗa dem vi le a yaꞋankpanai uzuwakpani n akucina. Ana o kotsoi ɗa Ishaku wu uta̱ka̱i le ɗa a̱ ka̱na̱i uye, ɗa e pecemgbenei m ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kanna ka nanlo ka kpamu nguɓi mi Ishaku m banai ɗa n danai ni ukuna u kayinva u na a̱ ga̱va̱i va. A danai, <<Ci cinaka ta̱ mini!>> ");
INSERT INTO asg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ɗa Ishaku u ɗekei kayinva ka Sheba, adama a nannai kula ku likuci ka ku ɗaɗa Biyasheba ali a̱ kuta̱wa̱ anana. ");
INSERT INTO asg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ana Isuwa u yawai a̱ya̱ amangere, ɗa u zuwai vuka kula ku ni ku ɗa Juditi mekere ma Beri vuza va aza Hitiya, m Basematu mekere me Elon vuza va aza Hitiya. ");
INSERT INTO asg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ɗa a zuwai Ishaku n vuka vi ni Rebeka a̱ kpa̱ɗa̱i kupananai uyoꞋo. ");
INSERT INTO asg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","A ayin a na Ishaku u kutsai ali ɗa a̱shi a̱ ni a̱ gita̱i kuyimba̱na̱. U ɗekei maku ma̱ ni ma gbayin Isuwa, u danai, <<Maku ma̱ va̱.>> Ɗa wu ushuki, <<Mpa ɗa na.>> ");
INSERT INTO asg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ishaku u danai, <<Ye ene ta̱ n kutsa ta̱, ukpa̱ kpamu u buwa mu m megeshe ba. ");
INSERT INTO asg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ɗika ucanuku u kutambu u nu, utan m majiki ma̱ nu, ka̱ta̱ vu bana a kakamba, vu una ka mu manama. ");
INSERT INTO asg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","YaꞋan ilikulyaꞋa i na n cigai ka̱u, ka̱ta̱ vu tuka̱ mu. Ayin a na baci n lyaꞋi i ɗa, mi ta̱ a kuzuwaka wu una̱singai u va̱, kafu n kuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ayin a na Ishaku wi a kadanshi n Isuwa, Rebeka lo a kupana. Ana Isuwa u banai kuyaꞋan kutambu ka, ");
INSERT INTO asg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ɗa Rebeka u danai Yakubu, <<Gogo na ɗa n kotsoi kupana eshevu a kudana Isuwa, ");
INSERT INTO asg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","<Tuka̱ mu n vinyama vu kakamba, ka̱ta̱ vu suꞋwanka mu kusaꞋan ku singai. Ayin a na baci n lyaꞋi ka̱ta̱ n zuwaka wu una̱singai a̱ ubuta̱ u Vuzavaguɗu, kafu n kuwa̱.> >> ");
INSERT INTO asg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rebeka u lyaꞋi kelime, <<Maku ma̱ va̱, panaka mu, ka̱ta̱ kpamu vi yaꞋan ili i na n danai nu. ");
INSERT INTO asg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Bana a ushiga wu nlala, ka̱ta̱ vi ɗika muku mu nga̱ji n re n singai, adama a na n yaꞋanka eshevu kusaꞋan ku singai ku na u cigai va. ");
INSERT INTO asg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ka̱ta̱ vu ɗika vu banka yi u lyaꞋa, adama a na u zuwaka wu una̱singai, kafu u kuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ama ɗa Yakubu u danai a̱na̱ku a̱ ni Rebeka, <<La̱na̱ vuza va̱ wi ta̱ n cileme n a̱bunda̱i a ikyamba i ni, mpa ta na ukpan wi ikyamba u va̱ wi ta̱ molu-molu. ");
INSERT INTO asg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ta̱wa̱ baci dada u papurasa mu ɗa u yevei a na mi a kuciga kudoro yi, wi ta̱ a̱ kuka̱sukpa̱ kuzuwaka mu una̱singai ka̱ta̱ u kucikpa u zuwaka mu u gbani-gbani.>> ");
INSERT INTO asg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ɗa a̱na̱ku a a danai, <<Ka̱sukpa̱ una̱ wa u tono mu maku ma̱ va̱, avu de tono kadanshi ka̱ va̱ ka̱ta̱ vu bana vi ciya̱ka̱ mu i na n danai.>> ");
INSERT INTO asg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","U banai u tuka̱i muku mu nga̱ji ma wa̱ a̱na̱ku wa, ɗa u suꞋwain kusaꞋan ku na esheku a a laꞋi n kuciga va. ");
INSERT INTO asg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ɗa Rebeka u ɗikai motogu ma singai mo kolobo ka gbayin ka̱ ni Isuwa, ma na u laꞋi n kuciga ma na u zuwai a kpaꞋa. Ɗa u ukai maꞋa kolobo ke kenu ka̱ ni Yakubu. ");
INSERT INTO asg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","U ukai ni ukpan u malala ma e ekiye, ɗa u palai kpamu uɓon u kuɗeku u na wi babu cileme. ");
INSERT INTO asg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ɗa u nekei maku ma̱ ni Yakubu ilikulyaꞋa i na esheku a cigai va m boroji vu na u kangalai. ");
INSERT INTO asg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakubu u banai we esheku. Ɗa u danai, <<Dada.>> Ɗa wu ushuki u danai, <<Nini ɗai maku ma̱ va̱, Avu ɗa maku ma̱ va̱ me ne?>> ");
INSERT INTO asg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakubu wu ushuki, <<Mpa ɗa maku ma̱ nu ma gbayin ma iyain, Isuwa. N yaꞋan ta̱ ili i na vu danai mu. Ɗenga̱ vu da̱sa̱ngu, vi lyaꞋa ilikulyaꞋa i na n tuka̱i nu, ka̱ta̱ vi zuwaka mu una̱singai u nu.>> ");
INSERT INTO asg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ishaku we ecei maku ma̱ ni, <<Nini ɗai vi yaꞋin ɗa vi ciya̱i gogoꞋo nahannai?>> Ɗa wu ushuki, <<Adama a na Ka̱shile Vuzavaguɗu u neke mu ta̱ agaꞋin a singai.>> ");
INSERT INTO asg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ɗa Ishaku u danai Yakubu, <<Ta̱wa̱ na adama a na n saꞋwa wu, maku ma̱ va̱ adama a na n yeve ko mayun avu ɗa Isuwa vu va̱ va ko avu ɗa ba.>> ");
INSERT INTO asg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakubu u yawai ɗevu n esheku a̱ ni. Ana Ishaku u saꞋwai ni ɗa u danai, <<Ka̱la̱ka̱tsu ka̱ nu ko yotso ta̱ ka Yakubu, ama ekiye a̱ nu n cileme ci Isuwa.>> ");
INSERT INTO asg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","U yeve an Yakubu ɗa ba, adama a na ekiye a̱ ni i ta̱ n cileme ci Isuwa. Adama a nannai ɗa u zuwakai ni una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ɗa u danai, <<Avu ɗa gaji maku ma̱ va̱ ma?>> Ɗa wu ushuki u danai <<Mpa ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","<<Tuka̱ mu n inyama i na vi ciya̱i va adama a na n takuma, ka̱ta̱ n zuwaka wu una̱singai.>> Ɗa u bankai ni ɗa u takumai; ɗa u bankai ni m ma̱kya̱n ɗa u soꞋi. ");
INSERT INTO asg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ɗa Ishaku u danai ni, <<Ta̱wa̱ ɗevu vu papura mu, maku ma̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ɗa Yakubu u yawai ɗevu ɗa wo oɓongi ni, Ɗa Ishaku u tsumgbai ni ɗa u tsumgbai ma̱gula̱ni mo ntogu ma̱ ni, ɗa u zuwakai ni una̱singai. U danai, <<M ma̱gula̱ni ma maku ma̱ va̱ mi ta̱ a na ma̱gula̱ni ma kakamba ma na Vuzavaguɗu u zuwakai una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","YaꞋan Ka̱shile ke neke wu ciza tsu gaɗi n uciyi wa aduniyan dem, koɓolo n ilikulya n i kusoꞋo n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","YaꞋan aduniyan kakau a yaꞋanka wu tsugbashi, uma a̱ kuɗa̱nku a lyaꞋaka wu kayala. Vo okpo vuzagbayin a̱ ubuta̱ wa aza a̱ nu, yaꞋan muku ma̱ a̱na̱vu n kuɗa̱nku n lyaꞋaka wu kayala. YaꞋan aza a na a yaꞋankai nu una̱ u gbanigbani u bono we le, aza a na a zuwakai nu una̱singai u ɗa feu u tono le.>> ");
INSERT INTO asg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ishaku u kotsoi kuzuwaka Yakubu una̱singai. Ana u lazai, ɗa mokoshi ma̱ ni Isuwa wu uta̱i a̱ ubuta̱ u kutambu u yawai. ");
INSERT INTO asg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A̱yi kpamu u yaꞋin ilikulyaꞋa i ni, i na esheku a cigai va, ɗa u tuka̱i esheku a̱ ni. U danai ni, <<Dada, ɗa̱nga̱ vu da̱sa̱ngu, adama a na vi lyaꞋa ilikulyaꞋa n inyama i na n tuka̱i nu va, ka̱ta̱ vu zuwaka mu una̱singai u nu.>> ");
INSERT INTO asg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ishaku we ecei ni, <<Avu ɗa ya?>> Isuwa wu ushuki, <<Mpa ɗa maku ma̱ nu ma gbayin ma iyain, Isuwa.>> ");
INSERT INTO asg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ishaku u ka̱na̱i kuyaꞋan mereve ka̱u. Ɗa u danai, <<Yayi tamkpamu wu unai inyama ya, ɗa u tuka̱i mu va? N lyaꞋa ta̱ gogo na, kafu vu ta̱wa̱. N zuwaka yi ta̱ ɗe una̱singai u va̱ gbende, u ɗa ta na uteku nannai.>> ");
INSERT INTO asg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ana Isuwa u panai nannai, ɗa u shika̱i n utsura. U doku u danai, <<Zuwaka mu feu una̱singai u nu, Dada.>> ");
INSERT INTO asg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ishaku u danai ni, <<Vangu vu nu vu ta̱wa̱ ta̱, ɗa u doroi mu. U ɗika ta̱ ɗe una̱singai u nu ra̱ka̱.>> ");
INSERT INTO asg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ɗa Isuwa u danai, <<Mayun ɗa kula ku ni Yakubu, adama a na ire ɗa na u doki kudoro mu. I iyain i ɗaɗa u ɗika ta̱ tsugbayin tsu va̱, i ire kpamu ɗa wi isai una̱singai u va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ɗa Ishaku u danai Isuwa, <<M bonokoi ta̱ ɗe vuzagbayin vu nu, aza a̱ ni kpamu o okpo aza a na o kutono yi, n neke yi ta̱ ilya n ili i kusoꞋo dem. Yiɗa̱i i buwai i na n kufuɗa kuyaꞋanka wu gogo na, maku ma̱ va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ɗa Isuwa we ecei esheku, <<Dada una̱singai u te u ɗa vi n u ɗa koci?>> Ɗa Isuwa u ɗengusa̱i ka̱la̱ka̱tsu ka̱ ni ɗa u shika̱i. ");
INSERT INTO asg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ɗa esheku a a dansai ɗa u danai ni <<KpaꞋa ku nu ka kuyaꞋan ta̱ daꞋin n uciyi wa aduniyan u nampa, ugaꞋin u ciza tsu gaɗi wa kuyawa ɗevu n avu ba.>> ");
INSERT INTO asg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ukpa̱ u kotokobi u ɗa va kubanka, ka̱ta̱ vo okpo kagbashi ka̱ vuza nu. Ama a ayin a na baci vi yaꞋin ugbamukaci vi ta̱ a̱ kukpa̱ɗa̱ kupanaka yi ka̱ta̱ vu takpa a̱miki a nanlo e kuɗeku ku nu. ");
INSERT INTO asg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ɗa Isuwa u ka̱na̱i tsurala n Yakubu adama a una̱singai u na esheku e nekei ni. Ɗa Isuwa u sheshei n ka̱ɗu ka̱ ni, ɗa u danai, <<Ayin a kpalu m ma̱shi e esheku a̱ va̱ a yawa ta̱, yaꞋan mu una̱ Yakubu.>> ");
INSERT INTO asg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ana a danai Rebeka ili i na Isuwa u sheshei kuyaꞋan ɗa u suki e ɗeke Yakubu, ɗa u danai ni, <<Yakubu, vuza nu wi ta̱ ɗe e kusheshe uteku u na u kuna wu. ");
INSERT INTO asg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Gogo na maku ma̱ va̱ pana kadanshi ka̱ va̱ ka̱ta̱ vu tono kaꞋa, suma vu bana u taku vu va̱ Laban na ɗe a Haran, ");
INSERT INTO asg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","vu da̱sa̱ngu ɗe sai ayin a na ka̱ɗu ko mokoshi ma̱ nu ka vaki. ");
INSERT INTO asg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ayin a na baci wupa u mokoshi ma̱ nu u kotsoi. Mi ta̱ a̱ kusuku vuza yoku u bana u dana wu vu bono. Nini ɗai n kunamba ɗa̱ aza e re dem a kanna ke te?>> ");
INSERT INTO asg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ɗa Rebeka u danai Ishaku, <<Mpa moꞋuta̱ n ukuna wa̱ a̱ma̱ci aza Ahitiya. Yakubu u ɗika baci vuka a̱ ka̱tsuma̱ ka uma a nampa, u kulaꞋa ta̱ n kugaꞋan wuma u va̱ u laza.>> ");
INSERT INTO asg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ɗa Ishaku u ɗekei Yakubu ɗa u zuwakai ni una̱singai. Ɗa u danai ni, <<Ka̱ta̱ vi yaꞋan yolo n aza a KanaꞋana ba. ");
INSERT INTO asg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Wala gogo na a kubana Fada-aram, ɗe we eshevu a Betuwe. Ta ɗe va kubana va yaꞋan yolo. Ɗika punu a̱ ka̱tsuma̱ ke nkere n Laban, taku va̱ a̱na̱vu. ");
INSERT INTO asg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ka̱shile Uba̱nga̱ri ka zuwaka wu ta̱ una̱singai vu matsa kpamu muku n a̱bunda̱i, ka̱ta̱ i yimkpa ali yo okpo umaci n a̱bunda̱i u ka̱ci ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ka̱shile kpamu ka zuwaka ɗa̱ una̱singai u na u zuwakai akaya a̱ ɗa̱ Ibirahi. Adama a na u neke ɗa̱ kpamu iɗika yi ida̱shi i na yi o limoci na, iɗika i na Ka̱shile ke nekei Ibirahi.>> ");
INSERT INTO asg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ishaku u ka̱sukpa̱i Yakubu u wala, ɗa u lazai a kubana a Fada-aram, u Laban maku me Betuwe vuza va aza a Aramiyan, taku vu Rebeka, a̱na̱ku a Yakubu n Isuwa. ");
INSERT INTO asg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Gogo na Isuwa we enei Ishaku u zuwaka ta̱ Yakubu una̱singai ali ɗa u zuwai ni u laza a kubana Fada-aram adama a na u ɗika ɗe vuka, ali wu oɓongi ni u danai, <<Ka̱ta̱ vu ɗika vuka a KanaꞋana ba.>> ");
INSERT INTO asg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ɗa kpamu u yevei a na Yakubu u panakai esheku a̱ ni n a̱na̱ku a̱ ni ɗa u banai a Fada-aram. ");
INSERT INTO asg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ana Isuwa we enei muku ma̱ a̱ma̱ci n KanaꞋana n uwa esheku a̱ ni Ishaku a̱ ka̱ɗu ba, ");
INSERT INTO asg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ɗa u banai u IsumaꞋilu u zuwai Mahalatu mekere ma maku mi Ibirahi IsumaꞋilu, taku vu Nebatu, adama a na u doku u yaꞋan vuka vi ni koɓolo n a̱ma̱ci a na wi n a ɗa. ");
INSERT INTO asg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ɗa Yakubu u ka̱sukpa̱i Biyasheba, ɗa u lazai a kubana a Haran. ");
INSERT INTO asg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ana u yawai a̱ ubuta̱ u yoku adama a na kanna ka̱ yikpa̱ ta̱, ɗa u ɗikai katali ko yoku, ɗa u zuwakai kaꞋa kaci, ɗa u latai. ");
INSERT INTO asg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ɗa u yaꞋin alatani a na we enei idasakpatsu uzuwi gaɗi ali a̱ kuta̱wa̱ a iɗika. Ɗa alingata a̱ Ka̱shile a̱ ka̱na̱i kulivanku n a̱ cipa̱i. ");
INSERT INTO asg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Gaɗi vi idasakpatsu ya kpamu ɗa Vuzavaguɗu u shamgbai kashani, ɗa u danai, <<Mpa ɗa Vuzavaguɗu, Ka̱shile ki Ibirahi, n Ka̱shile ki Ishaku. Mi ta̱ e kuneke wu nu ntsukaya n nu dem iɗika i na vi ivaꞋin na gogo na. ");
INSERT INTO asg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ntsukaya n nu mi ta̱ o kokpo an kubuta̱ ki iɗika. Yi ta̱ a kuyimkpa ka̱ta̱ i yawa a kubana a̱ ka̱livi n kasana, n gaɗi a kubana kpamu ɗaka. Uma a aduniyan dem i ta̱ a̱ kuciya̱ kasingai adama a̱ ɗa̱, avu nu ntsukaya n nu. ");
INSERT INTO asg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mi ta̱ koɓolo n avu, mi ta̱ kpamu a kinda wu, ka̱ta̱ m bonoko wu kpamu a iɗika i nampa. Mi a̱ kuka̱sukpa̱ wu ba, sai n yaꞋanka wu ili i na n yaꞋankai nu uzuwakpani.>> ");
INSERT INTO asg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ana Yakubu u ɗa̱nga̱i alavu, ɗa u ciɓasai. Ɗa u danai, <<Mayun ɗa Vuzavaguɗu wi a̱ ubuta̱ u nampa, ama ta na mi ishi n yeve ba!>> ");
INSERT INTO asg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ɗa u panai wovon ɗa u danai, <<Nini ɗai ubuta̱ u nampa wi? Na ubuta̱ u Ka̱shile u ɗa, ɗa kpamu utsutsu u gaɗi u ni.>> ");
INSERT INTO asg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ana kayin ka asai n usana ka̱li-ka̱li ɗa Yakubu u ɗikai katali ka na u zuwakai kaci ka ɗa u ɗengusa̱i kaꞋa adama a na ko okpo ka kuciɓasa, ɗa u tsungi kaꞋa maniꞋin ma zaitu a gaɗi vi ni. ");
INSERT INTO asg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","U ɗekei ubuta̱ u nanlo wa Betelu ɗaɗa <<kpaꞋa ku Ka̱shile>> ama kula ku ubuta̱ ka ku ɗaɗa ki ishi Luzu. ");
INSERT INTO asg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakubu u kucinai u danai, <<Ka̱shile ki baci koɓolo nu mpa, ɗa wi a kinda mu a̱ ka̱tsuma̱ ka nwalu ka nampa, ka̱ta̱ kpamu u neke mu boroji n takuma koɓolo n akashi a ku uka, ");
INSERT INTO asg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ali m bono a kpaꞋa ku dada vu va̱ m ma̱ta̱na̱, Vuzavaguɗu wi ta̱ o kokpo Ka̱shile ka̱ va̱ mayun, ");
INSERT INTO asg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","katali ka nampa, ka na n zuwai tsu ma̱shikpu na, ubuta̱ wa wi ta̱ o kokpo kpaꞋa ku Ka̱shile, ili i na vi nekei mu va dem mi ta̱ e kuneke wu ugboku u te a̱ ka̱tsuma̱ ka kupa punu.>> ");
INSERT INTO asg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ɗa Yakubu u lyaꞋi kelime nu nwalu n ni a iɗika ya aza a kasana. ");
INSERT INTO asg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ɗa we enei kayinva e keteshe n ushiga u tatsu wu nlala ivaꞋin lo, adama a na ta punu o tsu soꞋo a kayinva ka. Katali ka na a̱ ɓa̱ya̱ngi ki kayinva ka, ka ki ta̱ ka gbangam. ");
INSERT INTO asg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ayin a na baci ushiga wa kakau u gasai a̱ ubuta̱ wa, nguɓi ma a̱ tsu gida̱la̱kpa̱ ta̱ katali ka a̱ una̱ u kayinva wa, adama a na e neꞋe ushiga u le mini. O kotso baci, ka̱ta̱ o bonoko katali ka punu a̱ una̱ u kayinva wa. ");
INSERT INTO asg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ɗa Yakubu we ecei nguɓi ma, <<Aza a̱ va̱, te ɗai i yu uta̱i?>> Ɗa a̱ ushuki, <<A̱ tsu tsu uta̱ ta̱ a Haran.>> ");
INSERT INTO asg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ɗa we ecei le, <<I yeve ta̱ Laban, matsukaya ma Nahoru?>> Ɗa a̱ ushuki, <<Eyeu, ci yeve yi ta̱.>> ");
INSERT INTO asg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ɗa Yakubu u doku we ecei le, <<Wi ta̱ ɗe m ma̱ta̱na̱?>> Ɗa a danai, <<Eyeu, wi ɗe n kadanshi ba. Mekere ma̱ ni ma na Rahila a̱ kuta̱wa̱ n ushiga wu nlala u ni.>> ");
INSERT INTO asg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ɗa Yakubu u danai, <<Kanna de ka buwa ta̱ biꞋi, ayin o kubonoko nlala a kpaꞋa ka̱ta̱ a yawa ba, neꞋi le mini ka̱ta̱ i lyaꞋa kelime n kalina.>> ");
INSERT INTO asg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","A̱ ushuki a danai, <<Tsa kuyaꞋan nannai ba, sai ayin a na ushiga wa u gasai na ra̱ka̱ ɗa a̱ gida̱la̱kpa̱i katali ka kpamu; ka̱ta̱ yeve ci neꞋe nlala ma mini.>> ");
INSERT INTO asg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","A̱yi lo a kadanshi n ele ɗa Rahila u yawai nu nlala me esheku, adama a na a̱yi maguɓi maꞋa. ");
INSERT INTO asg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ana Yakubu we enei Rahila mekere ma Laban, taku va̱ a̱na̱ku, nlala kpamu n ni, ɗa u banai ɗa u gida̱la̱kpa̱i katali a̱ una̱ u kayinva wa. Ɗa u neꞋi nlala me esheku a mashani a mini. ");
INSERT INTO asg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ɗa Yakubu wo oɓongi Rahila ɗa u shika̱i n ka̱la̱ka̱tsu ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Adama a na u dana ta̱ Rahila a̱yi vashi ve esheku ɗa, Rebeka ɗa kpamu a̱na̱ku. Ɗa Rahila u sumai ɗa u banai u danai esheku. ");
INSERT INTO asg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ana a danai Laban, Yakubu ɗa maku ma taku, ɗa u yaꞋin moloko adama a na u cina yi. Ɗa wo oɓongi ni. Ɗa u ɗikai ni a kubana a kpaꞋa ku ni. Ana Yakubu u tonukoi Laban ili dem, ");
INSERT INTO asg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ɗa Laban u danai ni, <<Mayun avu kujini ku te ku ɗa tsu nu mpasa n te kpamu!>> Ɗa u da̱sa̱ngi n Laban va ali wotoi u te. ");
INSERT INTO asg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ɗa Laban u danai ni, <<Adama a na vi vuza va̱ ɗa va kuyaꞋanka mu tsugbashi gbani? Dana mu ko yaꞋin ɗai n kutsupa wu.>> ");
INSERT INTO asg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ta na wi ta̱ nu nkere n re, vuzagbayin vu ɗa Liyatu, vuza kenu kpamu Rahila. ");
INSERT INTO asg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liyatu wi ta̱ n ugaꞋin u a̱shi koci, ama Rahila a̱shi a gaꞋan yi ta̱ koɓolo n ikyamba i tsuloboi dem. ");
INSERT INTO asg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","A̱yi Yakubu wi ta̱ a kuciga Rahila, ɗa u danai, <<Mpa mi ta̱ a kuyaꞋanka wu ulinga ali a̱ya̱ e cindere, adama a na vi neke mu Rahila.>> ");
INSERT INTO asg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban wu ushuki u danai, <<U laꞋa ta̱ n kugaꞋan n neke wu a̱yi a na me neke vuza yoku kau. Adama a nannai, da̱sa̱ngu nu mpa.>> ");
INSERT INTO asg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ɗa Yakubu u yaꞋankai ni ulinga ali a̱ya̱ e cindere adama a na e neke yi Rahila. Ama a̱yi we ene ayin a nanlo ka̱u ba, adama a na wi ta̱ a kuciga Rahila n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ɗa Yakubu u danai Laban, <<Neke mu vuka vu va̱, ayin a na vi nekei mu a shana ta̱. Mi ta̱ a kuciga ma ɗika yi yolo.>> ");
INSERT INTO asg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ɗa Laban u ɗekei uma a̱ ubuta̱ wa n a̱bunda̱i, ɗa u yaꞋin ka̱ɗiva̱. ");
INSERT INTO asg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ama ana kulivi ku yawai, ɗa u ɗikai Liyatu. Ɗa u nekei Yakubu, ɗa Yakubu u vaki n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban u neke ta̱ Liyatu maku mu usuki, kula ku ni Zilifa, adama a na u ciya̱ vuza na u kuɓa̱nka̱ yi. ");
INSERT INTO asg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ana kayin ka asai, ɗa Yakubu u yaꞋin mereve ana we enei Liyatu. Ɗa we ecei Laban, <<Yiɗa̱i i zuwai ɗa vi yaꞋankai mu nannai, ɗa vi nekei mu Liyatu? N yaꞋanka wu tsugbashi adama a Rahila ba? Yiɗa̱i i zuwai ɗa vu doroi mu?>> ");
INSERT INTO asg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ɗa Laban u danai ni, <<A̱ tsu tsa̱ kugita̱ kuta̱ka̱ mekere vuza kenu a cau n vuza gbayin ba. ");
INSERT INTO asg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kotso biꞋi n ayin e cindere o yolo a nampa a, ka̱ta̱ n yeve n neke wu vangu vi ni. Ama sai vu doku vi yaꞋanka mu ulinga ali a̱ya̱ e cindere.>> ");
INSERT INTO asg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ɗa ta na Yakubu u yaꞋin nannai. Ana kuden ku te ku kotsoi, ɗa Laban u nekei ni Rahila yolo, adama a na wo okpo vuka vi ni. ");
INSERT INTO asg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban u doku ta̱ u neke yi kabara ke mekere ko yoku kula ku ni Biliha, adama a Rahila. ");
INSERT INTO asg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ɗa Yakubu u vaki n Rahila. U laꞋa ta̱ n kuciga Rahila a na wa ciga Liyatu. U doku u yaꞋankai Laban tsugbashi ali a̱ya̱ e cindere. ");
INSERT INTO asg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ana Vuzavaguɗu we enei Yakubu u ciga Liyatu ka̱u ba, ɗa u ɓa̱yuwa̱i kamatsatsu ka̱ ni, u bonoi u ɓa̱ya̱ngi ka Rahila, wo okpoi madari. ");
INSERT INTO asg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liyatu ta na u ka̱na̱i ka̱tsuma̱ ɗa u matsai maku mo kolobo ali ɗa u neꞋi ni kula Ruben. Ɗa u danai, <<Ili i na i zuwai i ɗaɗa Vuzavaguɗu u pana ta̱ asuvayali a̱ va̱ ɗa u nekei mu maku. Mayun gogo na vali vu va̱ u kuciga mu ta̱ ka̱u.>> ");
INSERT INTO asg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","U doku u ciya̱i ka̱tsuma̱ ɗa u matsai maku mo kolobo kpamu. Ɗa u danai, <<Adama a na Vuzavaguɗu u yeve ta̱ a na a iwain mu, i ɗaɗa i zuwai ɗa u doku u nekei mu maku.>> U neꞋi maku ma kula Simiyon. ");
INSERT INTO asg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","U doku u yaꞋin ka̱tsuma̱ kpamu ɗa u matsai maku mo kolobo. Ɗa u danai, <<Gogo na vali u kuciga mu ta̱ mayin, adama a na m matsaka yi ta̱ olobo a tatsu.>> Ɗa u neꞋi maku ma kula Levi. ");
INSERT INTO asg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ali n gogo na u doku u ka̱na̱i ka̱tsuma̱ ɗa u matsai maku mo kolobo. Ɗa u danai, <<Ayin a nampa n kucikpa ta̱ Vuzavaguɗu.>> Adama a nannai ɗa u neꞋi maku ma kula feu Yahuza. Ɗa ta na wu uvukai n limata. ");
INSERT INTO asg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ana Rahila we enei u matsaka Yakubu muku ba, ɗa u ka̱na̱i cisheꞋe m mokoshi ma̱ ni. Ɗa u danai Yakubu va, <<Neke mu muku ko n kuwa̱!>> ");
INSERT INTO asg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakubu u yaꞋin wupa n Rahila ɗa u danai, <<Mpa Ka̱shile kaꞋa, vuza na u sa̱nka̱i nu kuciya̱ limata?>> ");
INSERT INTO asg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ɗa Rahila u danai ni, <<Kagbashi ka̱ va̱ ka na Biliha, vaku n a̱yi adama a na u matsaka mu maku. A̱ ubuta̱ u ni u ɗa mpa n kuciya̱ muku.>> ");
INSERT INTO asg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ɗaɗa u nekei ni kagbashi ka̱ ni Biliha, wo okpoi vuka vi ni, ɗa Yakubu ta na u vaki n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha u ciya̱i ka̱tsuma̱ ɗa u matsakai Yakubu maku. ");
INSERT INTO asg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahila u danai, <<Ka̱shile ka kiɗaka mu ta̱ afada a singai, u panai ka̱la̱ka̱tsu ka̱ va̱.>> Ɗa u neꞋi ni kula Dan. ");
INSERT INTO asg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha kagbashi ka Rahila u doku u ciya̱i ka̱tsuma̱ ɗa u matsakai Yakubu maku me ire. ");
INSERT INTO asg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ɗa Rahila u danai, <<N yaꞋan ta̱ vishili n utsura m mokoshi ma̱ va̱, n lyaꞋa ta̱ ta na>> Adama a nannai ɗa u neꞋi ni kula Nafutali. ");
INSERT INTO asg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ayin a na Liyatu we enei u buwa a kumatsa ba, ɗa u ɗikai kagbashi ka̱ ni Zilifa u nekei Yakubu ko okpo yi vuka. ");
INSERT INTO asg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ɗa Zilifa kagbashi ka Liyatu ka matsakai Yakubu maku mo kolobo. ");
INSERT INTO asg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ɗa Liyatu u danai, <<N gaꞋaka ta̱!>> Ɗa u neꞋi ni kula Gadu. ");
INSERT INTO asg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilifa kagbashi ka Liyatu ka matsakai Yakubu kpamu maku me ire. ");
INSERT INTO asg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ɗa Liyatu u danai, <<Mi ta̱ m ma̱za̱nga̱! A̱ma̱ci i ta̱ e kuɗeke mu vuza vu ma̱za̱nga̱.>> Ɗa Liyatu u neꞋi maku ma kula Ashera. ");
INSERT INTO asg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","A ayin a vikya vi itabi, Ruben u banai a kakamba u ga̱va̱i aralu a na a kuzuwa vuka u ɗika ka̱tsuma̱, u tuka̱i Liyatu a̱na̱ku a̱ ni a kpaꞋa. Ɗa Rahila u danai Liyatu, <<N folono wu ta̱ neꞋe mu aralu a kuɗika ka̱tsuma̱ a a na maku ma̱ nu ma̱ tuka̱i va.>> ");
INSERT INTO asg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liyatu u danai ni, <<U yawa wu ba, a na vi isai mu vali? Gogo na vi a kuciga kufa̱ba̱na̱ mu aralu a kuɗika ka̱tsuma̱ a na maku ma̱ va̱ ma̱ tuka̱i mu?>> Ɗa Rahila u danai, <<Vali vu tsu wi ta̱ a kasa n avu anana, vi baci e kuneke mu aralu a kuɗika ka̱tsuma̱ a na maku ma̱ nu ma̱ tuka̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ana Yakubu wu uta̱i a kakamba u bonoi n kulivi ku nanlo, Liyatu u banai kugasa n a̱yi. U danai ni, <<Mayun anana vi ta̱ a ku asa nu mpa, adama a na vo okpo ta̱ una̱ wa aralu a kuɗika ka̱tsuma̱ a na maku ma̱ va̱ ma̱ tuka̱i.>> Ɗa ta na wa asai n a̱yi kayin ka nanlo. ");
INSERT INTO asg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ka̱shile ta na ka panai avasa a Liyatu, u ɗikai ka̱tsuma̱ u matsakai Yakubu maku ma tawun. ");
INSERT INTO asg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liyatu u danai, <<Ka̱shile ke neke mu ta̱ katsupu ka̱ va̱, adama a na n nekei vali vu va̱ kagbashi ka̱ va̱.>> U neꞋi maku ma̱ ni kula Isaka. ");
INSERT INTO asg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ɗa Liyatu u ka̱na̱i ka̱tsuma̱ kpamu ɗa u matsakai Yakubu maku ma̱ ta̱li. ");
INSERT INTO asg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ɗaɗa Liyatu u danai, <<Ka̱shile ke neke mu ta̱ kuneꞋe ku singai. Gogo na vali vu va̱ u kucikpa mu ta̱, adama a na m matsaka yi ta̱ muku mo olobo ali n ta̱li.>> Ɗa u neꞋi ma kula Zabalun. ");
INSERT INTO asg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ɗaɗa u yevei u matsai maku me mekere, ɗa u neꞋi kula Dina. ");
INSERT INTO asg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ta lo Ka̱shile ka ciɓai n Rahila, u panai avasa a̱ ni, u ɓa̱yuwa̱i kamatsatsu ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","U ka̱na̱i ka̱tsuma̱ u matsai maku mo kolobo. U danai, <<Gogo na Ka̱shile ko lokoko mu ta̱ ili i wono.>> ");
INSERT INTO asg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","U neꞋi maku ma kula Isufu. Adama a na u dana ta̱ n ka̱ɗu ka̱ ni, <<Ka̱sukpa̱ Vuzavaguɗu u doku mu maku.>> ");
INSERT INTO asg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ana Rahila u matsai Isufu, ɗa Yakubu u danai Laban, <<Ka̱sukpa̱ mu m bono a kpaꞋa ku va̱ na ɗe a iɗika i va̱. ");
INSERT INTO asg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Neke mu a̱ma̱ci a̱ va̱ m muku n va̱ n na n ciya̱i adama a tsugbashi tsu na n yaꞋankai nu, ka̱ta̱ n wala. Vi yeve ta̱ tsu na n yaꞋankai nu tsugbashi mayin.>> ");
INSERT INTO asg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ama Laban u danai ni, <<Vu ushuku baci n dansa tsu nampa, n yeve ta̱ a̱ ubuta̱ u kindana a na Vuzavaguɗu u zuwakai mu una̱singai adama a̱ nu. ");
INSERT INTO asg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Vu dana mu ta̱ katsupu ka̱ nu, mi ta̱ a kutsupa wu.>> ");
INSERT INTO asg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ɗa Yakubu wu ushuki ni u danai, <<Vi yeve ta̱ tsu na n yaꞋankai nu tsugbashi, n tsu na kuzuwa ku nu ku lyaꞋi kelime adama a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kafu n ta̱wa̱ wa̱ nu kuzuwa ku nu ki ishi gbayin ba, ama gogo na ku ɗa ku yimkpa ta̱ ka̱u. Vuzavaguɗu u zuwakai nu una̱singai a ili i na de dem n saꞋwai n ekiye a̱ va̱. Ama gogo na, wana ɗai n kufuɗa kuɓa̱nka̱ kpaꞋa ku va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","U danai, <<Yiɗa̱i n kuneke wu?>> Yakubu u danai, <<Mi a kuciga ili ba. Mi ta̱ a kulyaꞋa kelime n kinda ushiga u nu, vi baci a̱ kushuku n kadanshi ka na n kuneke wu. ");
INSERT INTO asg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Anana ka̱sukpa̱ n tono ushiga u nu ra̱ka̱ m pece a̱giri n a̱na̱ku aza a ajaku, n a̱giri a̱ lima̱ dem, ni nraɗika koɓolo nu nga̱ji aza a na i n ajaku. Ka̱sukpa̱ icuꞋu yi ili i nanlo yo okpo katsupu ka̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Na kelime vi ta̱ a kufuɗa kuyeve ko mi ta̱ m ma̱riki. Ayin a na baci vi a̱ kuta̱wa̱ adama a na vu goɗumo ili i na m ɓolongi, mi baci m maraɗika ma na mi babu ajaku, ko ma̱giri ma na mi ulima̱ ba, vi yeve a na o bokoi maꞋa.>> ");
INSERT INTO asg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban wu ushuki u danai, <<U gaꞋan ta̱, ka̱sukpa̱ ili yo okpo uteku u na vu danai.>> ");
INSERT INTO asg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ama a kanna ka nanlo Laban u pecei nga̱ji n na mi n ikari ko n ajaku. U pecei a̱na̱ku o nkyon a na i n ajaku, ka̱na̱ku ka na ka saꞋwai ɗe kumatsa kute dem, koɓolo m ma̱giri ma na mi ulima̱ dem, u pecei le u nekei muku mo olobo n ni n guɓa. ");
INSERT INTO asg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ɗa Laban u foɓusoi u yaꞋin nwalu ali ayin a tatsu n ushiga u nanlo wa koɓolo m muku n ni, u ka̱sukpa̱i Yakubu daꞋin. Yakubu ta na u lyaꞋi kelime n kinda ushiga u Laban u na u buwai va. ");
INSERT INTO asg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakubu u la̱nsa̱i acaka a̱ ta̱ku a nɗanga n kantan, m ma̱ɗimbi, koɓolo n o modobi u sheꞋwei a̱va̱ e le adama a na a yaꞋan n ajaku a̱ a̱ri a ikyamba i le. ");
INSERT INTO asg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","U zuwai a̱va̱ a nɗanga a nanlo a̱ mini a̱ ubuta̱ u na ushiga wi ilikuzuwa ya i tsu soꞋo mini. U zuwai a̱ ubuta̱ u na a ci yaꞋan mazama a̱ ta̱wa̱ baci kusoꞋo mini ma. ");
INSERT INTO asg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","A ayin a na nlala ma a yaꞋin mazama a uɓon u na u zuwai acaka a̱ ta̱ku a nɗanga a nanlo, ɗa matsai muku n na mi n ikari koɓolo n ajaku a ikyamba i le. ");
INSERT INTO asg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakubu u pecei nkyon nu nraɗika. U zuwai a̱na̱ku o nkyon a a̱ ubuta̱ u na i a kindanai n nlala n Laban n na mi n ikari n aza a̱ lima̱. Ta u yaꞋin nannai ɗa u ciya̱ka̱i ka̱ci ka̱ ni ushiga ɗa u zuwai u ɗa kau n ushiga u Laban. ");
INSERT INTO asg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ayin a na baci de dem kuzuwa ku na ki m ma̱ta̱na̱ i a kuyaꞋan mazama, Yakubu u tsu zuwaka le ta̱ acaka a nɗanga a ele e kene a̱ ubuta̱ u na e ci neꞋe le mini mo kusoꞋo, adama a na a yaꞋan mazama ma a uɓon wa acaka wa. ");
INSERT INTO asg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ama u zuwaka kuzuwa ku na ki babu ma̱ta̱na̱ acaka a nɗanga a a̱ ubuta̱ u kusoꞋo mini ba. Adama a nannai, kuzuwa ku na ki m ma̱ta̱na̱ n ikari koɓolo n aza a ajaku ku ɗa kokpoi ku Yakubu. Ama ku na ki babu ma̱ta̱na̱ ku ɗa kokpoi ku Laban. ");
INSERT INTO asg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ta nannai ɗa Yakubu wo okpoi vuza vu uciyi vu gbayin, wi ta̱ n ushiga u kuzuwa kakau n a̱bunda̱i, koɓolo n agbashi a̱ma̱ci n ali, n arakuma koɓolo ni njaki. ");
INSERT INTO asg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Gogo na Yakubu u pana ta̱ muku n Laban a kudana, <<Yakubu u ɗika ta̱ ili i na esheku a̱ tsu i n i ɗa dem, uciyi u na wi n u ɗa na u ciya̱ ta̱ u ɗa a̱ ubuta̱ we esheku a̱ tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakubu feu u zuka ta̱ Laban u doku u ɗika yi tsu ka̱ja̱Ꞌa̱ ka̱ ni tsu na ishi ba. ");
INSERT INTO asg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ɗa Vuzavaguɗu u danai Yakubu, <<Bono a iɗika yi ikaya i nu, a̱ ubuta̱ wa aza a̱ nu. Mpa mi ta̱ koɓolo n avu.>> ");
INSERT INTO asg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakubu u suki e ɗekeke yi Rahila n Liyatu a̱ ubuta̱ u na ushiga u ni wi ishi, ");
INSERT INTO asg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ɗa u danai le, <<Me ene ta̱ esheku a̱ ɗa̱ o doku a ɗika mu n a̱miki tsu na wi ishi n ayin a ɗe ba. Ama Ka̱shile ke esheku a̱ va̱ ki ta̱ koɓolo nu mpa. ");
INSERT INTO asg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","I yeve ta̱ n yaꞋanka ta̱ esheku a̱ ɗa̱ tsugbashi n utsura u va̱ dem, ");
INSERT INTO asg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ama n nannai dem esheku a̱ ɗa̱ o doro mu ta̱ ɗa u sabaꞋi ili i na i gaꞋin i yaꞋan katsupu ka̱ va̱ ali kupa, ama Ka̱shile ke neke yi utsura u uka mu muna ba. ");
INSERT INTO asg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","U dana baci, <Nlala n na mi n ajaku ele ɗa katsupu ka̱ nu,> ka̱ta̱ nlala ma dem vi le a̱ ka̱na̱ kumatsa aza a ajaku. U dana baci kpamu, <Aza a ikari a ɗa o kokpo katsupu ka̱ nu,> ka̱ta̱ nlala ma ra̱ka̱ a̱ ka̱na̱ kumatsa aza a ikari. ");
INSERT INTO asg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ta nannai ɗa Ka̱shile ka ɗika nlala me esheku a̱ ɗa̱ ɗa u nekei mu. ");
INSERT INTO asg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","<<A ayin a na nlala ma a kuɗika a̱tsuma̱ ɗa n yaꞋin alatani, me enei nga̱ji n na mi a kuyaꞋan mazama ma n ajaku aza o yoku n ikari. ");
INSERT INTO asg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kalingata ka̱ Ka̱shile ka yaꞋin kadanshi nu mpa a̱ ubuta̱ wa alatani u danai, <Yakubu,> ɗa mu ushuki, <Mpa ɗa na.> ");
INSERT INTO asg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ɗa u danai mu, <Indana, nga̱ji n na mi a kuyaꞋan mazama dem i ta̱ n ajaku koɓolo n ikari. N zuwa ta̱ ili i nanlo i yaꞋan nannai adama a na me ene ta̱ ili i na Laban wi a kuyaꞋanka wu. ");
INSERT INTO asg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mpa ɗa Ka̱shile ka na ka̱ ta̱wa̱i wa̱ nu e Betelu, a̱ ubuta̱ u na vi keɗei katali ka kuciɓasa n kutsungusu kaꞋa mani ma Zaitu, ta ɗe kpamu vu kucinakai mu. Gogo na foɓuso adama a na vu bono a̱ ubuta̱ u na a matsai nu.> >> ");
INSERT INTO asg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ɗaɗa Rahila n Liyatu a̱ ushuki ni a danai, <<Ili yi ta̱ lo ko ili yi uka̱ni i na vu ka̱sukpa̱ka̱i tsu a iɗika ye esheku a̱ tsu? ");
INSERT INTO asg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","A̱yi u ɗika tsu tso omoci ba? U denge tsu ta̱, gogo na wu una ta̱ ikebe i na e nekei ni adama a̱ tsu. ");
INSERT INTO asg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Uciyi u na Ka̱shile kisai we esheku a̱ tsu u tsu u ɗa koɓolo n u muku n tsu. Gogo na yaꞋan ili i na Ka̱shile ka danai nu.>> ");
INSERT INTO asg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakubu u ɗa̱nga̱i u kumbakai muku n ni n a̱ma̱ci a̱ ni a arakuma; ");
INSERT INTO asg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","U pura̱i nlala n ni ra̱ka̱, n ucanuku u na u ciya̱i dem a Fada-aram adama a na o bono a̱ ubuta̱ we esheku a̱ ni Ishaku a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Gogo na Laban u bana ta̱ kupuna cileme tsu nkyon n ni, Rahila tamkpamu u uwai ɗa u bokoi ka̱ma̱li ke esheku a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakubu u doroi Laban vuza va aza a Aramiyan, u kpa̱ɗa̱i kuta̱ yi e keteshe a na wi a kusuma. ");
INSERT INTO asg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","U ɗikai ili i na wi n i ɗa dem ɗa u lazai n kafura. U pasai Kuɗolu ku Yufiretu, u lazai wi indanai a uɓon wu nsasan u Giliyadu. ");
INSERT INTO asg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","A kanna ka tatsu a danai Laban a na Yakubu u sumai. ");
INSERT INTO asg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","U pura̱i uma a̱ ni ɗa u kiyangi Yakubu. A kanna ke cindere ɗa a cinai ni a uɓon wu nsasan n Giliyadu. ");
INSERT INTO asg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ama ɗa Ka̱shile ka danai Laban vu Aramiyan a̱ ubuta̱ wa alatani n kayin, <<Suma ka̱ta̱ vu dana Yakubu va kakuna ba, ko i singai ko i gbani-gbani.>> ");
INSERT INTO asg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban u lyaꞋi kaci ka Yakubu. Yakubu u vaki a uɓon wu nsasan. A̱yi Laban u vaki tamkpamu a uɓon wu nsasan u Giliyadu. ");
INSERT INTO asg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban u danai Yakubu, <<Nini ɗai vu doroi mu ɗa vu ɗikai nkere n va̱ tsu a̱ma̱ci a na a̱ tsu ka̱na̱ a̱ ubuta̱ u kuvon? ");
INSERT INTO asg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Yiɗa̱i i zuwai ɗa vu doroi mu ɗa vu sumai n ka̱bini babu na vu danai mu? Vi ishi baci vu dana mu, mi ishi ta̱ a̱ kuka̱sukpa̱ vu laza m ma̱za̱nga̱ n ishipa, a kukucuwa medele, koɓolo n tsuwaꞋi tsu umolu. ");
INSERT INTO asg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yiɗa̱i i zuwai ɗa vu kpa̱ɗa̱i kuka̱sukpa̱ mu mo oɓongu ka̱ta̱ n salama ntsukaya n va̱ m muku mi nkere n va̱? Ili i na vi yaꞋin va tsulau tsu ɗa. ");
INSERT INTO asg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mi ta̱ n utsura n uwaka wu muna, ama Ka̱shile ke esheku a̱ va ka yaꞋin kadanshi nu mpa na̱yi n kayin, <Mi indana kadanshi ka na n kuyaꞋan n avu, ko i singai ko i gbani-gbani.> ");
INSERT INTO asg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ko a na vu sumai adama a na vi ta̱ a̱ ma̱za̱nga̱ ma na ve ene kpaꞋa ke eshevu, ama yiɗa̱i i zuwai ɗa vu bokoi a̱ma̱li a̱ va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ɗa Yakubu wu ushuki Laban u danai, <<Adama o wovon a ɗa, adama a na n sheshe ta̱ vi ta̱ a̱ kufa̱ba̱na̱ muku mi nkere n nu e ekiye a̱ va̱ n utsura. ");
INSERT INTO asg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ama vuza na baci de dem vi cinai n ka̱ma̱li ka̱ nu i ta̱ a kuna yi. E kelime ka uma a̱ tsu, vu utuka̱ mu n ili i na yi i nu dem, ka̱ta̱ vi ɗika.>> Yakubu ta na u yeve a na Rahila u bokoi ka̱ma̱li ka ba. ");
INSERT INTO asg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ɗa Laban u uwai a̱ ka̱pa̱m ka Yakubu kugoɗumo, wu uta̱i ɗa u uwai a ka Liyatu, wu uta̱i ɗa kpamu u uwai a̱ a̱pa̱m a̱ muku mu usuki ma, ama we ene punu ili ba. Ana wu uta̱i a̱ ka̱pa̱m ka Liyatu, ɗa u uwai a̱ ka̱pa̱m ka Rahila ");
INSERT INTO asg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahila u boko ta̱ ka̱ma̱li ka kpaꞋa ka Laban ɗa u zuwai kaꞋa a ɗaka vi ida̱sa̱mkpa̱tsu i karakuma, ɗa u da̱sa̱nki. Laban u goɗumoi ubuta̱ dem a̱ ka̱pa̱m ka̱ ni, ama we ene ka̱ma̱li ka ba. ");
INSERT INTO asg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahila u danai esheku a̱ ni, <<Dada ka̱ta̱ vi yaꞋan wupa nu mpa a na m kpa̱ɗa̱i kuɗa̱nga̱ ba, adama a na mi ta̱ n kusumbu.>> U la̱na̱i kpamu, ama we ene punu ka̱ma̱li a kpaꞋa ku ba. ");
INSERT INTO asg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ɗa Yakubu u yaꞋin wupa ɗa u ka̱na̱i kutsunku Laban kadanshi. U danai, <<Yiɗa̱i unushi u va̱? Wila̱ we ne u ɗai n koɗoi, ɗa vi kiyangi mu nannai? ");
INSERT INTO asg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","A na vu la̱na̱i ucanuku u va̱ ra̱ka̱, yiɗa̱i vi ciya̱i punu a̱ ubuta̱ wu ucanuku wa, i na yi i kpaꞋa i nu? E keteshe na kelime ka uma a̱ va̱ n uma a̱ nu, adama a na a kiɗaka tsu afada a̱ tsu aza e re. ");
INSERT INTO asg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","A̱ ka̱tsuma̱ ka̱ a̱ya̱ kamanga a na n yaꞋin n avu, ka̱na̱ku ka malala ka̱ a̱ri ka̱ nu ko ka̱na̱ku ka maraɗika, a̱tsuma̱ a saꞋa kulolo le ba. N takuma ka̱giri ku ushiga u nu ba. ");
INSERT INTO asg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kuzuwa ku na baci nnama n kakamba mu unai, n tsu tuka̱ wu ba, mpa ɗa n ci ɗika mɓa̱la̱ n nanlo n ka̱ci ka̱ va̱. Vu tsu la̱nsa̱ ta̱ ili i na o bokoi dem e ekiye a̱ va̱, ko n kanna ko n kayin. ");
INSERT INTO asg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ayin n a̱bunda̱i n tsu soꞋo ta̱ usuɗukpi u kanna n kanna, uta̱ni kpamu n kayin, ali m kpa̱ɗa̱ kufuɗa kulata. ");
INSERT INTO asg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ta ukuna u yaꞋin nannai nu mpa a̱ ka̱tsuma̱ ka̱ a̱ya̱ kamanga a na n yongoi a kpaꞋa ku nu. N yaꞋanka wu ta̱ ulinga ali a̱ya̱ kupa n a̱ na̱shi adama a na n ɗika nkere n re n nu yolo. N yaꞋan ta̱ a̱ya̱ a̱ ta̱li adama a kuzuwa ku nu. Vi yongoi a kusabaꞋa sa katsupu ka̱ va̱ ali a kubana kupa. ");
INSERT INTO asg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ishi baci Ka̱shile ke esheku a̱ va̱, Ka̱shile ki Ibirahi, Ka̱shile ka na ke ci neke Ili i wovon ki Ishaku ki koɓolo nu mpa ba, vi ishi ta̱ o kuloko mu n ayin a ɗe ekiye agaɗa. Ama Ka̱shile ke enei atakaci a̱ va̱ n ulinga wa ekiye a̱ va̱, ɗa ta na u dansukai nu na̱yi n kayin.>> ");
INSERT INTO asg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ɗa Laban wu ushuki u danai Yakubu, <<A̱ma̱ci a nkere n va̱ n ɗa, muku ma feu ntsukaya n va̱ n ɗa, kuzuwa ku va̱ ku ɗa, ili i na vi e kene dem i va̱ i ɗa. Ama yiɗa̱i n kuyaꞋan anana ni nkere n va̱ n nampa, ko muku n le n na a matsai? ");
INSERT INTO asg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Gogo na ta̱wa̱ ci yaꞋan uzuwakpani a̱ tsu aza e re. Ka̱ta̱ ta na u ɗa wo okpo nga koɓolo nu mpa n avu.>> ");
INSERT INTO asg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ɗa Yakubu u ɗikai katali u shikpa̱i, adama a ili i kuciɓasa. ");
INSERT INTO asg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakubu u danai uma a̱ ni o ɓolongu atali kaginga. Ɗa a lyaꞋi ilikulyaꞋa lo ɗevu n kaginga ka atali ka. ");
INSERT INTO asg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ɗa Laban u ɗekei ubuta̱ wa Jegaru-sahaduta ama Yakubu u ɗekei ubuta̱ wa Giliyadu, ɗaɗa kazana ka magan. ");
INSERT INTO asg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban u danai Yakubu, <<Kaginga ka atali ka nampa ki ta̱ a kuciɓasa ka tsu dem.>> I ɗaɗa i zuwai ɗa e neꞋi ubuta̱ wa kula Giliyadu. ");
INSERT INTO asg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","E neꞋi kpamu kaginga ka atali ka kula Mizipa, Adama a na Laban u dana ta̱, <<YaꞋan MalaꞋimili wi indana mpa n avu, a na ci e kenenei ba.>> ");
INSERT INTO asg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban u lyaꞋi kelime n kadanshi u danai, <<Vu bonoko baci nkere n va̱ ukuna u gbani ko vi yaꞋin yolo n a̱ma̱ci o yoku, ko a na n yevei ili i na yi a nwalu ba, vi yeve Ka̱shile ki ta̱ a kinda tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","U doku u danai Yakubu kpamu, <<Inda biꞋi kaginga ka atali ka nanlo, inda kpamu katali ka kuciɓasa ka nanlo ka na n shikpa̱i adama a̱ va̱ n avu ");
INSERT INTO asg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kaginga ka atali ka nanlo ki ta̱ tsu nga, katali ka kuciɓasa ka nanlo feu magan maꞋa, ma kupasa kaginga ka atali ka nanlo a kubana a̱ ubuta̱ u nu adama a na n yaꞋanka wu kawuya ba. Avu feu va kupasa kaginga ka atali ka nanlo n katali ka kuciɓasa a̱ kuta̱wa̱ a̱ ubuta̱ u va̱ adama a na vi yaꞋanka mu kawuya ba. ");
INSERT INTO asg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","YaꞋan Ka̱shile ki Ibirahi, n ka Nahoru, n Ka̱shile ke esheku e le, ka kiɗaka tsu afada.>> Ɗa Yakubu u kucinai n Kula ku Ka̱shile ka na ke ci neke ili i wovon ke esheku a̱ ni Ishaku. ");
INSERT INTO asg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakubu u kiɗai ili i te i kuzuwa i ni u yaꞋankai kaginga ka gbayin ka alyuka, u ɗekei uma a̱ ni a̱ ta̱wa̱ a lyaꞋa ilikulya. Ana o kotsoi kulyaꞋa, ɗa a asai a kaginga ka gbayin ka. ");
INSERT INTO asg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ana kayin ka asai n usana ɗa Laban u ɗa̱nga̱i wo oɓongi ntsukaya n ni m muku mi nkere n ni, u zuwakai le una̱singai. Ɗaɗa u salamai le ɗa u lazai o kubono a kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ayin a na Yakubu wi a nwalu ɗa alingata a̱ Ka̱shile o yoku a gasai n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ana Yakubu we enei le ɗa u danai, <<Na ka̱tsura̱ ka̱ Ka̱shile kaꞋa>>, ɗaɗa u neꞋi ubuta̱ wa kula Mahanayim. ");
INSERT INTO asg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakubu u suki alingata a kubana u vuza ni Isuwa a iɗika i Edom, ");
INSERT INTO asg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","u danai le: <<Na ɗa ili i na i kudana vuzakpa vu va̱ Isuwa, kagbashi ka̱ nu Yakubu ka danai, ta ɗe mi o kuyongo n Laban ali m megeshe ma ɗe sai gogo na ta na. ");
INSERT INTO asg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mi ta̱ n anaka, ni njaki, ni nkyon, ni nraɗika, n agbashi. N suku ta̱ akaka a nampa ciya̱ a dana vuzakpa vu va̱ a na mi a̱ kuta̱wa̱, adama a na n ciya̱ wu ushuki u ni.>> ");
INSERT INTO asg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ana Alingata a o bonoi u Yakubu ɗa a danai, <<Tsu bana ta̱ u vuza nu Isuwa, wi ta̱ lo a̱ kuta̱wa̱ kucina wu, wi ta̱ a kuwala n uma amangatawa̱na̱shi (400).>> ");
INSERT INTO asg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ɗa Yakubu u dagazai n wovon. Ɗa u peciki uma a na i koɓolo n a̱yi ali ugboku u re, u yaꞋin nannai ni nkyon n ni, nraɗika, anaka n arakuma dem. ");
INSERT INTO asg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kusheshe ku ni ku ɗaɗa, <<Isuwa u ta̱wa̱ baci ɗa u niꞋwa̱nta̱ngi ugboku u iyain, ka̱ta̱ ugboku u ire tamkpamu u laꞋaka.>> ");
INSERT INTO asg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ɗa Yakubu u danai, <<O Ka̱shile ka Dada vu va̱ Ibirahi n Ka̱shile ka Dada vu va̱ Ishaku, panaka mu. Avu Vuzavaguɗu vu danai mu, <Bono a iɗika i nu a̱ ubuta̱ wu umaci u nu, mi ta̱ a kuzuwa ili i yaꞋan derere a kubana wa̱ nu dem.> ");
INSERT INTO asg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mpa n yawa vi yotsongu mu kenu gbani a ucigi u nu u na u kukpa̱ɗa̱ kusabaꞋa ba, koɓolo kpamu n wu ushuki u nu u na vi yotsongi mu mpa kagbashi ka̱ nu. N kalangu ka nwalu kaꞋa koci m pasai Kuyene ku Urudu, ama mpa ɗa na mo okpoi ka̱tsura̱ ke re. ");
INSERT INTO asg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","N folono wu ta̱ isa mu a̱ ubuta̱ u vuza va̱ Isuwa. Mi ta̱ a kupana wovon u ni u na u kuta̱wa̱ wa kuna tsu ra̱ka̱, ali m muku n ina̱ku i le dem. ");
INSERT INTO asg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","N nannai dem, ɗa vu danai mu sai vi yaꞋanka mu kasingai, ka̱ta̱ kpamu vi neke mu ntsukaya n a̱bunda̱i n na n lazai kukece an kayala ka mala.>> ");
INSERT INTO asg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakubu wa asai ɗe, ɗaɗa a̱ ka̱tsuma̱ ki ili i na wi n i ɗa, ɗa u zagbai punu kuneꞋe ɗa u nekei vuza ni Isuwa, ");
INSERT INTO asg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","a̱na̱ku a nraɗika amangatawenre (200) nu nga̱ji kamanga, koɓolo kpamu n a̱na̱ku a nkyon amangatawenre (200) n a̱giri kamanga, ");
INSERT INTO asg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","a̱na̱ku a arakuma kamangankupa m muku n le, koɓolo n a̱na̱ku a anaka amangere n obomburom kupa, n a̱na̱ku a njaki kamanga n kogono kupa e le. ");
INSERT INTO asg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","U peciki le ushiga-ushiga ɗa u zuwai agbashi a̱ ni vuza te te a ushiga dem. Ɗa u danai le, <<Walai kelime ka̱ va̱, ka̱ta̱ i ka̱sukpa̱ ka̱ba̱nga̱ e mere mu ushiga u kelime n u ka̱ca̱pa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","U danai kagbashi ka iyain, <<Ayin a na baci vuza vu Isuwa u gasai n a̱ɗa̱ ɗa we ecei, <Yayi vuzagbayin vu ɗa̱? Te ɗai yi a kubana? Yayi n kuzuwa ku na ki kelime ka̱ ɗa̱ na?> ");
INSERT INTO asg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ka̱ta̱ vu ushuku yi, <A Yakubu a ɗa kagbashi ka̱ nu. KuneꞋe ku ɗa u suki a kubana u vuzagbayin vi ni Isuwa. A̱yi Yakubu a̱ ka̱ci ka̱ ni wi ta̱ lo ka̱ca̱pa̱ ka̱ tsu.> >> ");
INSERT INTO asg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","U danai kagbashi ke ire ka yaꞋan feu nannai, n ka tatsu, koɓolo n aza a na a buwai i n ushiga u na a kinda feu: <<I dana Isuwa feu nannai ayin a na baci i gasai n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mayun ɗa i dana, <Kagbashi ka̱ nu Yakubu ki ta̱ lo ka̱ca̱pa̱ ka̱ tsu.> >> Yakubu wi ta̱ e kusheshe, <<Mi ta̱ a kulyaꞋa utsura u ni n kuneꞋe kakau ka, n cina yi baci u gaꞋan ba wi ta̱ a ki isa mu.>> ");
INSERT INTO asg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","U suki kuneꞋe ka kelime ka̱ ni ɗa a̱yi tamkpamu wa asai punu a̱ ka̱tsura̱ ka. ");
INSERT INTO asg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","N kayin ka nanlo Yakubu u ɗikai a̱ma̱ci e re a̱ ni, koɓolo n agbashi a̱ a̱ma̱ci e re a nanlo a m muku n ni kupa n vuza te, ɗa u pasai kuyene ku Jaboku. ");
INSERT INTO asg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ana u zuwai le a pasa kuyene ka koɓolo n ili i na wi n i ɗa dem. ");
INSERT INTO asg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakubu wo okpoi endeꞋen; ɗa vuza u yongoi a kuyaꞋan mpolo n a̱yi ali sai kayin washi. ");
INSERT INTO asg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ana vuza va we enei wi a kufuɗa kulaꞋa utsura u ni ba, ɗa u gbashai Yakubu va a̱ ma̱kuta̱, ɗa ta na ugasatangi u ketele wa u sulamgbanai. ");
INSERT INTO asg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ɗaɗa u danai, <<YaꞋan m bana, kayin ki ta̱ a kasa.>> Ama ɗa Yakubu u danai, <<Mi a̱ kuka̱sukpa̱ wu vu laza ba, sai vu zuwaka mu una̱singai.>> ");
INSERT INTO asg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ɗa vuza va we ecei, <<Yayi kula ku nu.>> Ɗa wu ushuki, <<Mpa ɗa Yakubu.>> ");
INSERT INTO asg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ɗa vuza va u danai ni, <<Ili i na i ɗikai anana, kula ku nu ku buwa Yakubu ba. E kuɗeke wu ta̱ Isaraila, n tsa aza a Ibirahi kula ka ki ta̱ a kudana, vi yaꞋan ta̱ mpolo n Ka̱shile koɓolo kpamu n uma.>> ");
INSERT INTO asg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakubu u danai vuza va, <<Mi ta̱ ufolu u nu dana mu kula ku nu.>> Ama wu ushuki, <<Yiɗa̱i ɗa vi ecei kula ku va̱?>> Ɗa ta na u zuwakai ni ɗe una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Adama a nannai Yakubu u neꞋi ubuta̱ wa kula Peniyelu. U danai, <<Me ene ta̱ Ka̱shile a̱shi n a̱shi ama m buwa ta̱ ta na n wuma.>> ");
INSERT INTO asg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakubu a̱ kuka̱sukpa̱ Peniyelu kanna ta na a kuɓatsa, a kuwala nu nsa̱ga̱ɗu adama a na ketele ka̱ ma̱kuta̱ ka̱ ni ka sulamgbanai ta̱. ");
INSERT INTO asg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ali a̱ kuta̱wa̱ anana, ntsukaya mi Isaraila a tsu takuma akawa e etele a na i punu a̱ ma̱kuta̱ ba, adama a na ta punu a gbashai Yakubu a akawa a nanlo a. ");
INSERT INTO asg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakubu we enei Isuwa a̱ kuta̱wa̱ n uma amangatawun a̱ na̱shi. Ɗa u pecekei Liyatu n Rahila muku ma koɓolo n agbashi e nkere e re a. ");
INSERT INTO asg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","U zuwai agbashi e nkere e re a koɓolo m muku n le kelime, ɗa o tonoi n Liyatu m muku n ni, ɗa yevei Rahila n Isufu o kotsosoi. ");
INSERT INTO asg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakubu u lazai kelime ke le ɗa u kuɗa̱ngi u lyaꞋakai mokoshi ma̱ ni kayala a̱yi a kuyawa ɗevu n a̱yi ali kucindere. ");
INSERT INTO asg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ama ɗa Isuwa u sumai u banai u gasai n a̱yi, u ba̱ra̱kpa̱i ekiye a̱ ni ɗa wo oɓongi ni, ɗa a̱ shika̱i gbende vi le. ");
INSERT INTO asg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ana Isuwa u la̱na̱ki ɗa we enei a̱ma̱ci m muku, ɗa we ecei, <<Ana yayi koɓolo n avu na?>> Ɗa Yakubu wu ushuki, <<Ele na, ele ɗa muku n na Ka̱shile ke nekei mu.>> ");
INSERT INTO asg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ɗa muku usuki n le a yawai ɗevu ɗa a̱ kuɗa̱ngi a lyaꞋi kayala feu; ");
INSERT INTO asg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ɗa Liyatu m muku n ni a̱ ta̱wa̱i a̱ kuɗa̱ngi a lyaꞋi kayala, ɗa kpamu Isufu n Rahila o kotsosoi kuta̱wa̱ kukuɗa̱ngu kulyaꞋa kayala feu. ");
INSERT INTO asg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isuwa u danai, <<Yiɗa̱i ugboku-ugboku u uma u na me enei na wi a kudansa?>> Ɗa Yakubu wu ushuki u danai, <<Adama a na n ciya̱ kasingai wa̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ɗa Isuwa u danai, <<Ili i na mi n i ɗa i yawa mu ta̱, vuza za̱; wala n ili i na vi n i ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakubu u danai, <<A̱Ꞌa̱, n ciya̱ baci mapasa ma singai wa̱ nu, isa kuneꞋe ku va̱ ku na n tuka̱i. We ene u na me enei nu wi ta̱ adanshi Ka̱shile kaꞋa me enei, an vi isai mu tsu ka̱ja̱Ꞌa̱ ka̱ nu. ");
INSERT INTO asg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Adama a̱ Ka̱shile isa kuneꞋe ku na n tuka̱i nu na, Ka̱shile ka ciga mu ta̱ ɗa ki e kunekeshe mu ili i na n cigai dem.>> Yakubu u lyaꞋi kelime n kugutsuka yi ali u ta̱wa̱i wi isai. ");
INSERT INTO asg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ɗa Isuwa u danai, <<Tsu foɓusoi tsu walai. Mi ta̱ a kuwala kelime ka̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakubu u danai ni, <<Vi yeve ta̱ muku ma, n kuzuwa nu nlala dem ali m muku n le oꞋwo ta̱. A̱ ka̱na̱ baci kuloko le ali kanna ke te, i ta̱ a̱ kukuwa̱ ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Wala kelime ka̱ va̱, ka̱ta̱ mpa n tono sawu, ali n dakaka tsu na n kufuɗa koɓolo n kuzuwa ka m muku ali a kubana a̱ ubuta̱ u na n kucina wu a Edom.>> ");
INSERT INTO asg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ɗa Isuwa u danai, <<YaꞋan n ka̱sukpa̱ka̱ wu uma a̱ va̱ o yoku.>> Ama ɗa Yakubu wu ushuki, <<Na lo wi n kakuna ba, mpa de n ciga ta̱ n ciya̱ kasingai wa̱ nu, wi ta̱ a kuyawa mu.>> ");
INSERT INTO asg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","A kanna ka nanlo Isuwa u gosoi o kubono a Edom. ");
INSERT INTO asg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ama Yakubu u banai o Sukotu, a̱ ubuta̱ u na u maꞋakai ka̱ci ka̱ ni kpaꞋa koɓolo n ubuta̱ u kuzuwa u ni. I ɗaɗa i zuwai ɗa e neꞋi ubuta̱ wa kula Sukotu. ");
INSERT INTO asg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ana Yakubu wu uta̱i FadaꞋaram ɗa u yawai Shekem m ma̱ta̱na̱ a iɗika i KanaꞋana, ɗa u shikpa̱i ka̱pa̱m ka̱ ni lo ɗevu n likuci ya. ");
INSERT INTO asg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A̱ muku n Hamo, esheku e Shekem, Yakubu u tsulai ubuta̱ u na u zuwai kpaꞋa ku ni ali Azurufa amangatawun. ");
INSERT INTO asg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ta ɗe u maꞋi katalikalyuka ɗa u neꞋi kaꞋa kula El-elohe vi Isaraila, ɗaɗa Ka̱shile ki Isaraila. ");
INSERT INTO asg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","A̱yi Dina mekere ma na Liyatu u matsakai Yakubu, wu uta̱i u banai kene a̱ma̱ci a aza a KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ana Shekem kolobo ka Hamo vuza va aza a Hiviya, vuza kelime vu uɓon u nanlo wa, we enei ni, ɗa u remei ni u yaꞋin tsugbani n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ɗa ka̱ɗu ka̱ ni ka banai u Dina mekere ma Yakubu, ali ɗa u cigai ni ka̱u ɗa u yaꞋankai ni kadanshi ka mazama. ");
INSERT INTO asg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ɗa Shekem u danai esheku a̱ ni Hamo, <<Ka̱na̱ka̱ mu mekere ma nampa ma u yaꞋan vuka vu va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ana Yakubu u panai e reme ta̱ mekere ma̱ ni Dina ɗa a vaki n a̱yi, muku mo olobo n ni ɗe a kaguɓa a kakamba, ɗa u paɗai bini ali sai ayin a na o bonoi. ");
INSERT INTO asg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ɗaɗa Hamo esheku e Shekem a banai kuyaꞋanka Yakubu kadanshi. ");
INSERT INTO asg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Gogo na muku n Yakubu ele wana ɗai o bono usavu a̱ ubuta̱ u kaguɓa, ana a panai ili i a na yi lo a nwalu. Wupa u ka̱na̱i le ka̱u adama a na Shekem u yaꞋan ta̱ ili i wono wu Isaraila ana u vaki m mekere ma Yakubu, ili i na i gaꞋin kuyaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ama Hamo u danai le, <<Kolobo ka̱ va̱ Shekem u ciga ta̱ mekere ma̱ nu. Neke yi wo okpo vuka vi ni. ");
INSERT INTO asg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ci nekpenei yolo, nekei tsu nkere n ɗa̱ ka̱ta̱ a̱ tsu tamkpamu ci neke ɗa̱ nkere n tsu yolo. ");
INSERT INTO asg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Yi ta̱ a kufuɗa kuyongo n a̱ tsu, iɗika i tsu i ɗa lo adama a̱ ɗa̱. Yongoi punu, i yaꞋan punu tsulaga ba̱ri, ka̱ta̱ i ciya̱ ucanuku kakau.>> ");
INSERT INTO asg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ɗa Shekem u danai esheku a Dina n ataku, <<YaꞋan n ciya̱ wi ishi a kubana wa̱ ɗa̱, mi ta̱ a kufuɗa kuneke ɗa̱ ili i na baci de dem i cigai wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Zuwakai mu ucanuku u mazama wa n kuneꞋe ka dem kuyaꞋan n a̱bunda̱i tsu na i cigai, mi ta̱ a kutsupa ili i na i danai mu n tsupa ɗa̱ dem. A̱ɗa̱ de i neke mu mekere ma mo okpo vuka vu va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Adama a na taku vi le Dina e reme yi ta̱ ɗa a yaꞋin tsugbani n a̱yi, olobo a Yakubu a̱ ushuki Shekem n esheku a̱ ni Hamo n una̱mgbi u ka̱tsuma̱. ");
INSERT INTO asg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","A danai le, <<Ili i nanlo ya kuyaꞋan wa̱ tsu ba, ci e kuneke taku vu tsu u vuza na wi babu ukiɗi u kavaja ba. Wi ta̱ o kokpo ili i wono wa̱ tsu. ");
INSERT INTO asg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ci ta̱ a̱ kushuku n ukuna u nanlo ama ili i te i ɗa na, i kiɗa muku mo olobo n ɗa̱ avaja ra̱ka̱ ka̱ta̱ yo okpo uteku tsu tsu. ");
INSERT INTO asg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nannai ɗa tsa kufuɗa ce neke ɗa̱ nkere n tsu ka̱ta̱ a̱ tsu feu tsu zuwa nkere n ɗa̱. Ka̱ta̱ ci da̱sa̱ngi n a̱ɗa̱ ali tso okpo vite n a̱ɗa̱ kpamu. ");
INSERT INTO asg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ama yu ushuku baci kukiɗa avaja ba, ci ta̱ a kuɗika mekere ma̱ tsu ka̱ta̱ tsu lazaka.>> ");
INSERT INTO asg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kadanshi ke le ka yaꞋin Hamo uyo n kolobo ka̱ ni Shekem. ");
INSERT INTO asg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kolobo ka̱ la̱nga̱sa̱ ayin ba, esheku feu i ta̱ a kupana uyo u ni ɗa u yaꞋin ili i na a zuwai ni u yaꞋan dem, adama a na u ciga ta̱ mekere ma Yakubu. ");
INSERT INTO asg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamo n kolobo ka̱ ni Shekem o bonoi a̱ utsutsu u likuci u le ɗa a yaꞋin kadanshi n uma a̱ likuci i le, a danai. ");
INSERT INTO asg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","<<Uma a nampa a̱ja̱Ꞌa̱ a̱ tsu a ɗa, yaꞋan tsu ka̱sukpa̱ le o yongo punu a iɗika i tsu ka̱ta̱ a yaꞋan punu tsulaga. Iɗika ya yi ta̱ n ka̱ba̱nga̱ n a̱bunda̱i ka na ka kuyawa le. I ta̱ a kufuɗa a ɗika nkere n tsu yolo ka̱ta̱ a̱ tsu kpamu tsu zuwa n le. ");
INSERT INTO asg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ama uma a i ta̱ a̱ kushuku kuyongo n a̱ tsu ci yaꞋanka le baci ili i te, ci kiɗa baci avaja, tsu na ele i. ");
INSERT INTO asg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nannai u kuzuwa ilikuzuwa i le, ucanuku u le nu nnama n le n na m buwai dem mo okpo n tsu ba? YaꞋain tsu ushuku n ele, ka̱ta̱ o yongo n a̱ tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Uma ra̱ka̱ a na banai ɗe a̱ utsutsu u likuci wa a̱ ushuki n ili i na Hamo n kolobo ka̱ ni a dansai, ɗa ta na a kiɗai muku mo olobo n na mi a̱ likuci ya dem ukpan u tsali. ");
INSERT INTO asg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ana ayin a tatsu a lazai, ele aza a̱ usa̱n biꞋi a kupana mɓa̱la̱, muku n Yakubu n re, Saminu n Levi, ataku a cika a Dina, a ɗikai otokobi e le a uwai a̱ likuci ya babu vuza na u yevei, ɗa a unai muku n ali ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","A unai Hamo n kolobo ka̱ ni Shekem ɗa a ɗikai Dina a kpaꞋa ku Shekem ɗa a lazakai. ");
INSERT INTO asg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ɗa muku n Yakubu n na n buwai a yawai ɗa a cinai uma a na a unai va, o ɓosoi likuci i nanlo adama a na ta ɗe e remei taku vi le ɗa a vaki n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","A ɗikai ushiga wu nlala u le n wa anaka u le koɓolo ni njaki n ili i na i buwai i le dem punu a̱ likuci ya ɗa a̱ uta̱i. ");
INSERT INTO asg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","A ɗikai uciyi u le ra̱ka̱ koɓolo n a̱ma̱ci m muku ra̱ka̱ feu, n ili i na yi punu a iꞋuwa kakau dem. ");
INSERT INTO asg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ɗaɗa Yakubu u danai Saminu n Levi, <<I tuka̱ mu ta̱ n atakaci, i bonokoi mu vuza wuya a̱ ubuta̱ wa aza a KanaꞋana, n aza a Purizita a na i ida̱shi a iɗika i nampa ya. A̱ tsu ci gbayin ba, o ɓolongu baci aza a̱ vishili a̱ kuta̱wa̱ wa̱ va̱ n vishili, mpa m kpaꞋa ku va̱ i ta̱ a kuna tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ama ɗa a̱ ushuki, <<Nini ɗai u kubonoko taku vu tsu an kashakanlai?>> ");
INSERT INTO asg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ka̱shile ka danai Yakubu, <<Ɗenga̱, vu bana e Betelu, vu da̱sa̱ngi ɗe. Vu maꞋaka Ka̱shile ɗe katalikalyuka a ayin a na vu sumai vu ka̱sukpa̱i vuza nu Isuwa.>> ");
INSERT INTO asg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ɗa Yakubu u danai aza a kpaꞋa a̱ ni koɓolo n uma a na i n a̱yi, <<Vakangi a̱ma̱li a pulai a na yi n aɗa, ka̱ta̱ i takpa nshinda̱ ali i sabaꞋa akashi dem. ");
INSERT INTO asg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ka̱ta̱ tsu ɗa̱nga̱, tsu laza a kubana Betelu, a̱ ubuta̱ u na n kumaꞋaka Ka̱shile ka na ka̱ ɓa̱nka̱i mu a ayin a atakaci koɓolo n ubuta̱ u na n tonoi dem katalikalyuka.>> ");
INSERT INTO asg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","E nekei Yakubu a̱ma̱li a pulai a na i n aɗa, koɓolo n ili ya atsuvu i na ishi a ukai. Yakubu u ciɗa̱ngi i ɗa dem a̱ kumi ku maɗanga ma mandai ma na mi ɗevu n Shekem. ");
INSERT INTO asg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ayin a na i a kulaza, ɗa wovon u gbayin u ta̱wa̱i wa aza a̱ likuci i na yi ɗeɗevu lo dem, a kiyangu le ta na ba. ");
INSERT INTO asg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ana Yakubu n uma a̱ ni a yawai a Luzu, ubuta̱ u na gogo na e ci ɗeke Betelu, a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","U maꞋi ɗe katalikalyuka ɗa u neꞋi ubuta̱ wa kula El Betelu, ɗaɗa Ka̱shile ke Betelu, adama a na ta ɗe Ka̱shile ka̱ ta̱wa̱i wa̱ ni a ayin a na wi a kusuma vuza ni. ");
INSERT INTO asg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ana Debora vuza na u woꞋi Rebeka u kuwa̱i, ɗa a̱ ciɗa̱ngi ni a̱ kumi ku maɗanga ma mandai a gaɗi vu Betelu. Ɗa e neꞋi ubuta̱ wa kula <<Mandai ma̱ ma̱shi.>> ");
INSERT INTO asg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ana Yakubu wu uta̱i ɗe Fada-aram o kubono KanaꞋana, ɗa Ka̱shile ko doku ko yotsongi ka̱ci ka̱ ni wa̱ ni. Ɗa u zuwakai ni una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ɗa Ka̱shile ka danai ni, <<Kula ku nu ku ɗa Yakubu. Ama, o kudoku e ɗeke wu Yakubu ba. Avu ɗa Isaraila.>> Ɗa u ɗekei ni ta na kula ka. ");
INSERT INTO asg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ɗa Ka̱shile ka danai ni, <<Mpa ɗa Ka̱shile Uba̱nga̱ri, matsai ka̱ta̱ i doku ka̱bunda̱i. Punu wa̱ ɗa̱ likuci-likuci yi ta̱ a kuta̱, nu ngono kpamu punu wa̱ ɗa̱, punu kpamu ikyamba i ɗa̱. ");
INSERT INTO asg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Iɗika i na n nekei Ibirahi n Ishaku, n neke wu ta̱ i ɗa avu, m muku n nu, nu ntsukaya n nu.>> ");
INSERT INTO asg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ɗa Ka̱shile ka lazai ka̱ ka̱sukpa̱i ni a̱ ubuta̱ u na u yaꞋin kadanshi n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakubu u shikpa̱i lo kashamkpatsu ka katali ka kuciɓasa a̱ ubuta̱ u na Ka̱shile ka yaꞋin kadanshi n a̱yi. U tsuwa̱nka̱i kaꞋa alyuka a ili i kusoꞋo, koɓolo m mani. ");
INSERT INTO asg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakubu u ɗekei ubuta̱ u na Ka̱shile ka yaꞋin kadanshi n a̱yi va Betelu. ");
INSERT INTO asg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakubu n aza a kpaꞋa a̱ ni a̱ ka̱sukpa̱i Betelu ɗa a lazai. Ana u buwai daꞋin a na a yawa Efarata, ɗa Rahila u ka̱na̱i a̱ga̱nda̱ a limata a̱ ni. Ɗa ta na u soꞋi atakaci a̱ ubuta̱ u limata wa. ");
INSERT INTO asg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ana a̱ga̱nda̱ a limata a̱ ni a suɗukpai ka̱u, vuza na u tsu ka̱na̱ limata u danai ni, <<Ka̱ta̱ vu pana wovon ba; gogo na vi ta̱ a kumatsa maku mo yoku.>> ");
INSERT INTO asg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ayin a na wuma u ni wi a̱ kuta̱, kafu u kuwa̱, ɗa u nekei ni Ben-oni. Ama Esheku tamkpamu ɗa e ɗekei kula ku ni Bayami. ");
INSERT INTO asg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ɗa Rahila u kuwa̱i, a̱ ciɗa̱ngi ni a̱ ka̱kina̱ ku uye u kubana Efarata, a̱ ubuta̱ u na gogo na e ci ɗeke Batalami. ");
INSERT INTO asg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakubu u shikpa̱i ɗe katali ka kuciɓasa, na lo ɗaɗa katali ka kuciɓasa n kasaun ka Rahila, tsu na ki ɗe nannai ali n gogo na. ");
INSERT INTO asg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ɗa Yakubu u lyaꞋi kelime, u zuwai ka̱pa̱m ka̱ ni a upashi u kumaꞋa ku ugaɗi ku Eda. ");
INSERT INTO asg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ana Isaraila wi o kuyongo a uɓon u nanlo, Ruben u uwai ɗa u vaki n Biliha vuka vu gbani ve esheku, ɗa ta na Isaraila u panai kaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Na ɗaɗa muku n Liyatu: Ruben, a̱yi ɗa maku ma gbayin ma Yakubu, Saminu, Levi, Yahuza, Isaka, n Zabalun. ");
INSERT INTO asg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Na tamkpamu muku n Rahila: Isufu n Bayami. ");
INSERT INTO asg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Na ɗa muku n kabara ka Rahila, Biliha: Dan n Nafutali. ");
INSERT INTO asg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Na feu ɗaɗa muku n Zilifa, kabara ke mekere ka Liyatu: Gadu n Ashera. Na va ɗaɗa muku n Yakubu n na a matsakai ni a Fada-aram. ");
INSERT INTO asg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakubu u banai we esheku a̱ ni Ishaku a Mamure, ɗevu n Heburon, a̱ ubuta̱ u na Ibirahi n Ishaku o yongoi. ");
INSERT INTO asg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ishaku u yaꞋan ta̱ a̱ya̱ amangatawun na amanga̱na̱shi (180) aduniyan kafu u kuwa̱, ");
INSERT INTO asg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ɗa u kuwa̱i a ayin a singai; muku ni ali, Yakubu n Isuwa a̱ ciɗa̱ngi ni. ");
INSERT INTO asg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ele na ɗa ntsukaya n Isuwa, ko Edom. ");
INSERT INTO asg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isuwa ta na u ɗikai a̱ma̱ci a̱ ni a̱ ubuta̱ wa aza a KanaꞋana, Ada a̱yi ɗa mekere mo Elon va aza a Hitiya, Oholibama mekere ma Ana maku ma Zibiyon vuza va aza a Hiviya, ");
INSERT INTO asg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","m Basematu mekere ma IsumaꞋilu taku vu Nebatu. ");
INSERT INTO asg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada u matsakai Isuwa Elifaza, Basematu u matsakai ni tamkpamu Reyuwelu. ");
INSERT INTO asg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama feu u matsakai ni Jewushi, n Jalam, n Kora. Ele nanlo ɗa muku n Isuwa n na a matsakai ni a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ɗaɗa Isuwa u ɗikai a̱ma̱ci a̱ ni, olobo a̱ ni, nkere n ni, koɓolo n uma a na i a kpaꞋa ku ni dem, n ilikuzuwa i ni ra̱ka̱, n anaka a̱ ni ra̱ka̱, koɓolo n ucanuku u na u ciya̱i ra̱ka̱ a iɗika i KanaꞋana; ɗa u bonoi a iɗika i yoku daꞋin n vuza ni Yakubu. ");
INSERT INTO asg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","U laza ta̱ adama a na ubuta̱ u na a̱yi wi n Yakubu u ɗika le ba; iɗika i na i o kuyongo i ɗika le ba, adama a kuzuwa ku le. ");
INSERT INTO asg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Adama a nannai Isuwa u da̱sa̱ngi a uɓon wu nsasan n Siyaru, Isuwa a̱yi ɗa ta na feu Edom. ");
INSERT INTO asg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ele na ɗa ntsukaya n Isuwa, tsukaya tsa aza e Edom. ");
INSERT INTO asg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ele na ɗa ula a̱ muku n Isuwa: Elifaza maku ma Ada vuka vu Isuwa, Reyuwelu maku ma Basematu vuka vu Isuwa feu. ");
INSERT INTO asg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Muku mo olobo n Elifaza ele ɗa, Timan, Omaru, Zefo, Gatamu, n Kenazu. ");
INSERT INTO asg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaza kolobo ka Isuwa u zuwa ta̱ vuka vi yoku vu na vi n kula Timan ali u matsakai ni maku ma na mi n kula Ameleki. Ele nanlo ɗa muku mo olobo n Isuwa n na Ada u matsakai ni. ");
INSERT INTO asg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ele na ɗa muku mo olobo n Reyuwelu; Nahatu, Zera, Shama, n Miza. Ele na ɗa kpamu muku mo olobo n Isuwa n na vuka vi ni Basematu u matsakai ni. ");
INSERT INTO asg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Muku mo olobo n Oholibama vuka vi Isuwa mekere ma Ana vu Zibiyon. Ele ɗa Jewushi, n Jalam, n Kora. ");
INSERT INTO asg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Na ɗa umaci u tsukaya tsu na tsu uta̱i a̱ ubuta̱ u Isuwa. Kolobo ka iyain ka Isuwa Elifaza a̱yi ɗa wi ishi akaya a umaci u nampa: Teman, Omaru, Zefo, Kenazu, ");
INSERT INTO asg_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","n Kora, Gatamu n Ameleki. Ele ra̱ka̱ aza a gbagbaꞋin a Elifaza a ɗa a Edom, ntsukaya n Ada vuka vi Isuwa ɗa. ");
INSERT INTO asg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Reyuwelu maku ma Isuwa a̱yi ɗa akaya a umaci u nampa a Edom: Nahatu, Zera, Shama, m Miza. Ele ra̱ka̱ ntsukaya m Basematu vuka vi Isuwa ɗa. ");
INSERT INTO asg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Na ɗa umaci u tsukaya tsu na tsu uta̱i a̱ ubuta̱ u Isuwa n vuka vi ni Oholibama, mekere ma Ana: Jewushi, Jalam, n Kora. ");
INSERT INTO asg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Umaci u na mpa ra̱ka̱ ele ɗa ntsukaya n na mu uta̱i a̱ ubuta̱ u Isuwa, ɗaɗa Edom. ");
INSERT INTO asg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ele na ɗa olobo e Siyaru vuza va aza o Horitu, ele na i ida̱shi a iɗika ya: Lotan, n Shobalu, n Zibiyon, koɓolo n Ana, ");
INSERT INTO asg_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","n Dishon, n Eza, n Dishan feu. Ele na ɗa umaci wa aza o Horitu muku n Siyaru aza a iɗika i Edom. ");
INSERT INTO asg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Muku mo olobo n Lotan ele ɗa Hori n Heman. A̱yi Lotu wi ta̱ n vuza ni vuza kula Timina. ");
INSERT INTO asg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Muku mo olobo n Shobalu ele ɗa Alavan, n Manahatu, n Ebalu, n Shefo, koɓolo n Onamu. ");
INSERT INTO asg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ele na ɗa feu muku mo olobo n Zibiyon: Ayiya n Ana. Ana vu nanlo va a̱yi ɗa we enei meyenike mu usuɗukpi na ɗe a kakamba, a ayin a na wi a kuguɓa njaki me esheku. ");
INSERT INTO asg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Muku n Ana n ɗa na: Dishon, n Oholibama mekere ma Ana. ");
INSERT INTO asg_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Muku mo olobo n Dishon ele ɗa na: Hemadan, Esheban, Itiran, n Keran. ");
INSERT INTO asg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Muku n Eza ele ɗa Bilihan, Zavan, n Akan. ");
INSERT INTO asg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Muku n Dishan ele ɗa Uzu n Aran. ");
INSERT INTO asg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ele na ɗa ngono n Horitu: Lotan, n Shobalu, n Zibiyon n Ana, ");
INSERT INTO asg_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","n Dishon, n Eza, n Dishan. Ele ɗa ngono n Horitu, a uteku u na e pecuki a iɗika i Siyaru. ");
INSERT INTO asg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ele na ɗa ngono n na n lyaꞋi tsugono a Edom kafu ngono ma aza a Isaraila a lyaꞋa tsugono ci le ɗe. ");
INSERT INTO asg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela maku ma Beyo u lyaꞋi tsugono a Edom. Kula ku likuci ku ni ku ɗa Dinahaba. ");
INSERT INTO asg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela u kuwa̱i, ɗa Jobabu maku ma Zera vu Boza u lyaꞋi kelime n tsugono. ");
INSERT INTO asg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ana Jobabu u kuwa̱i feu, ɗa Husham a iɗika ya aza a Tema wo okpoi mogono. ");
INSERT INTO asg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham feu u kuwa̱i, ɗa Hadadu maku ma Bedadu vuza na u lyaꞋi aza a Midiya n kuvon a̱ likuci i Mowabu, wo okpoi mogono. Kula ki iɗika i ni ku ɗaɗa Avitu. ");
INSERT INTO asg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadu u kuwa̱i, ɗa Samula vu Masareka wo okpoi mogono. ");
INSERT INTO asg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ana Samula feu u kuwa̱i, Shawu vu Rehobotu vu uɓon u kuyene ku Yufiretus wo okpoi mogono. ");
INSERT INTO asg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shawu u kuwa̱i, ɗa Balu-hanan maku ma Akubo wo okpoi mogono. ");
INSERT INTO asg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balu-hanan maku ma Akubo feu u kuwa̱i, ɗa Hadaru wo okpoi mogono. Kula ku likuci ku ni ku ɗaɗa Pawu. Kula ku vuka vi ni ku ɗaɗa Mehetabelu mekere ma Materedu a̱yi feu mekere ma Mezahabu maꞋa. ");
INSERT INTO asg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ele na ɗa ngono ma aza e Edom a uteku u na umaci u le wi n uteku wu ubuta̱ u na i. Ele ntsukaya n Isuwa n ɗa. Ula e le a ɗa, Timina, n Aliva, n Jetetu, ");
INSERT INTO asg_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, n Ela, n Pinon, ");
INSERT INTO asg_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","n Kenezu, n Teman, m Mibizaru, ");
INSERT INTO asg_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","m Magadiyelu, n Iram. Ele na ɗa ishi ngono ma aza a Edom, n ubuta̱ u na o yongoi n uteku wi iɗika i na a̱ ka̱na̱i. A̱yi na ɗa Isuwa esheku a aza e Edom. ");
INSERT INTO asg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakubu u da̱sa̱ngi ta̱ a̱ ubuta̱ u na isheku i ni i da̱sa̱ngi a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Na va wi ta̱ a kudana tsu tsumani tsu muku n Yakubu. Isufu wi ta̱ n a̱ya̱ kupa n e cindere (17), ɗa u ka̱na̱i kuyaꞋan kaguɓa nu nkoshi n ni, muku n Biliha nu muku n Zilifa, a̱ma̱ci e esheku a ɗa. U banai u yaꞋankai esheku vuɗaka vi yoku vu na nkoshi n ni i a kuyaꞋansa. ");
INSERT INTO asg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ama, a̱yi Yakubu u laꞋa ta̱ n kuciga Isufu a̱ ka̱tsuma̱ ka̱ muku n ni dem, adama a na a̱yi ɗa a matsakai ni ukocishi. Ɗa u tsulakai ni kuminya ku singai ki ikebe. ");
INSERT INTO asg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ana aza a̱ ni e enei esheku e le a laꞋa ta̱ n kuciga Isufu, ɗa a̱ ka̱na̱i wupa n a̱yi, ali a iwain kuyaꞋanka yi kadanshi ka singai. ");
INSERT INTO asg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kanna ke te, Isufu u yaꞋin alatani, ɗa u danai aza a̱ ni. Ele ta na ɗa o doku ɗa a iwain ni. ");
INSERT INTO asg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","U danai le, <<Panai alatani a na n yaꞋin. ");
INSERT INTO asg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ci ta̱ a kushiya mkpakulu a kashina. Ɗa makpakulu ma̱ va̱ ma ɗa̱nga̱i, ɗa ma shamgbai. Ɗa mkpakulu n ɗa̱ feu n ɗa̱nga̱i, ɗa a kanzai ma̱ va̱. Ɗa a̱ kuɗa̱nki maꞋa.>> ");
INSERT INTO asg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ɗa nkoshi n ni me ecei ni, <<Vi ta̱ a kuciga vo kokpo mogono ma̱ tsu? Mayun ɗa wo ta na vi a kuciga va lyaꞋa kelime ka̱ tsu?>> Ɗa o doku ɗa a iwain ni, adama a alatani a na u yaꞋin, ɗa u danai le. ");
INSERT INTO asg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ɗa Isufu u doku ɗa u yaꞋin alatani o yoku. Ɗa u doku ɗa u danai le. Ɗa u danai, <<N yaꞋan ta̱ alatani o yoku. Me ene ta̱ kanna n wotoi na azangata kupa n ke te. A̱ kuɗa̱ngi a kulyaꞋaka mu kayala.>> ");
INSERT INTO asg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ana u danai esheku koɓolo nu nkoshi n ni, ɗa esheku a dansukai ni. Ɗa u danai ni, <<Alatani a̱ yi ɗa̱i nannai? Mayun ɗa a̱na̱vu nu mpa n aza a̱ nu, ɗa tsa kubana tsa̱ kuɗa̱nku wu?>> ");
INSERT INTO asg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ɗa nkoshi n ni n ka̱na̱i tsurala a̱yi. Ɗa esheku kpamu a ɗikai kadanshi ka nanlo a̱ ka̱ɗu ka̱ ni, ɗa u ka̱na̱i kuciɓasa kaꞋa mayin. ");
INSERT INTO asg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ana nkoshi n ni a banai kaguɓa ka nlala me esheku n le ɗevu n Shekem. ");
INSERT INTO asg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ɗa Yakubu u danai Isufu, <<Nkoshi n nu a bana ta̱ kaguɓa na ɗe ɗevu n Shekem. Vi yeve ta̱ ubuta̱. Ta̱wa̱ n suku wu ɗe we le.>> Ɗa Isufu danai, <<To, m pana ta̱.>> ");
INSERT INTO asg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ɗa u danai ni, <<Bana ve ene ma̱ta̱na̱ me le, ko nini ɗai i ɗe n kuzuwa ku le dem. Ka̱ta̱ vu bono vu dana mu.>> Ɗa u suki ni u wala n uɓon u Ka̱ra̱Ꞌa̱ ke Heburon. Ana Isufu u yawai e Shekem, ");
INSERT INTO asg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ɗa u ka̱na̱i kuka̱ra̱sa̱ a kakamba ali vuza yoku u cinai ni ɗa we ecei ni, <<Yiɗa̱i vi a̱ kula̱nsa̱?>> ");
INSERT INTO asg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ɗa wu ushuki, <<Mi ta̱ a̱ kula̱nsa̱ aza a̱ va̱. Dana mu, te ɗai i a kaguɓa ka.>> ");
INSERT INTO asg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ɗa vuma va wu ushuki, <<A̱ ka̱sukpa̱ ta̱ ɗe ubuta̱ u nampa. M panaka le ta̱ a kudana, <Tsu walai a kubana a Dotan.> >> Ɗa Isufu u lazai a kubana wu nkoshi n ni. Ɗa u banai ɗa u cinai le a Dotan. ");
INSERT INTO asg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ama ele e ene yi ta̱ ali a̱yi daꞋin. Ɗa e sheshei uteku u na a kuna yi. ");
INSERT INTO asg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ɗa a danai, <<Vuza va alatani ɗa na ɗe a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ta̱wa̱i tsu una yi, ka̱ta̱ tsu vakangi punu a kayinva ke te ka nampa ka. Ka̱ta̱ tsu bana tsu dana, <Manama mo yoku maꞋa mu unai ni.> Ce ene uteku u na u kuyaꞋan n alatani a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ana Ruben u panai nannai, u ciga ta̱ ta na kisa yi. Ɗa u danai, <<A̱Ꞌa̱. Tsu una yi ba. ");
INSERT INTO asg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tsu vakangi ni punu a kayinva ka nampa ka. Ka̱ta̱ tsu ka̱sukpa̱ yi punu a kakamba ka. Ama, ka̱ta̱ tsu saꞋwai ni ba.>> Ruben wi ta̱ a kuyaꞋan nannai, adama a na u yaꞋan baci ka̱ta̱ u bono u ɗikai yi, ka̱ta̱ u banka yi we esheku. ");
INSERT INTO asg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ana Isufu u yawai a̱ ubuta̱ wu nkoshi n ni, ɗa a̱ ka̱na̱i ni. Ɗa o foɗoi ni kuminya ku singai ku na wi n ku ɗa u uki. ");
INSERT INTO asg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ɗa a̱ ka̱na̱i ni, ɗa a vakangi ni a kayinva ka na ki babu mini. ");
INSERT INTO asg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ana a̱ da̱sa̱ngi kulyaꞋa ilikulyaꞋa, ɗa a̱ la̱na̱i. Ɗa e enei aza a tsulaga a Ishimaila a iɗika i Midiya a̱ kuta̱wa̱ a̱ uta̱ ta̱ ta na Giliyadu. Arakuma e le kpamu n ucanuku kakau wi ili i kusaꞋan, maniꞋin ma̱ kusukuya̱, n ili i ma̱gula̱ni i singai dem. Ele ta na ta ɗe i a kubanka n u ɗa Masar. ");
INSERT INTO asg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ɗa Yahuza u danai, <<Yiɗa̱i tsa kuciya̱ tsu una baci vuza tsu, ɗa ci ciɗa̱ngi ni na, ka̱ta̱ uma a̱ kpa̱ɗa̱ kuyeve? ");
INSERT INTO asg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ta̱wa̱i. Tsu bana tsu uta̱ka̱i ni ci ɗenkei aza a tsulaga a, ama ka̱ta̱ tsu una yi ba. Adama a na a̱yi vuza tsu ɗa mpasa n tsu kpamu.>> Ɗa aza a na a buwai ɗa a̱ ushuki n kadanshi ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ana aza a tsulaga a, a yawai, ɗa aza a̱ ni a̱ uta̱ka̱i Isufu punu a kayinva ka, ɗa e dengei ni n ikebe ya Azurufa kamanga wa aza a tsulaga a. Ɗa a ɗikai ni a kubanka yi Masar. ");
INSERT INTO asg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ana Ruben u banai a kayinva ka, u cina Isufu ba. Ɗa u ka̱na̱i ntogu n ni ɗa u karai adama a̱ una̱mgbi u ka̱tsuma̱. ");
INSERT INTO asg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ɗa u banai a̱ ubuta̱ wa aza a̱ ni. Ɗa u danai, <<Maku ma mi ɗe ba. Te ɗai mpa ma ɗamgba ma uwa?>> ");
INSERT INTO asg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ɗa a ɗikai kuminya ku Isufu, ɗa a kiɗai malala, ɗa a putalakai ku ɗa nu mpasa. ");
INSERT INTO asg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ɗa a ɗikai kakashi ka kuminya ka, ɗa a bankai esheku e le. Ɗa a danai, <<Ci cina ta̱ kuminya ku nampa ka a uye. La̱na̱. Vi yeve ta̱ ku ɗa ko ku maku ma̱ nu ku ɗa?>> ");
INSERT INTO asg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","U yeve ta̱ ku ɗa. Ɗa u danai, <<E, ku maku ma̱ va̱ ku ɗa. Manama ma gbanigbani maꞋa mu unai ni. Mayun ɗa, manama ma me wejeleshei ni wuya-wuya.>> ");
INSERT INTO asg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ɗa Yakubu u karai ntogu n ni. Ɗa u shika̱i adama a na u yaꞋan kpalu ku Isufu. U yaꞋan ta̱ nannai ali ayin n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ɗa muku n ni nu nkere dem a banai, adama a na a̱ ɓa̱nka̱ yi. Ka̱ta̱ kpamu e neꞋi kadanshi ku ugbamiwasuvu. Ama u iwain kupana. Ɗa u danai, <<Mi a kucinukpa ba, sai m bana ɗe a̱ ubuta̱ wa̱ a̱kpisa̱ n a̱yi.>> Ɗa u ka̱na̱i ma̱shi adama a maku mu ucigi ma̱ ni, Isufu. ");
INSERT INTO asg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ele ta na aza a tsulaga a ɗa a banai ɗa e dengei Isufu a Masar, a̱ ubuta̱ u Potifa, o kovonshi vu FiriꞋauna (mogono ma gbayin ma Masar). ");
INSERT INTO asg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A ayin a nanlo Yahuda u lazai u ka̱sukpa̱i aza a̱ ni u banai u yongoi n vuma vi yoku vuza va aza Adulam. Kula ku vuza ka ku ɗaɗa Hira. ");
INSERT INTO asg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","A̱ ubuta̱ wa ɗe ɗa Yahuda we enei Shuwa mekere ma aza a KanaꞋana. U ɗikai ni yolo ɗa ta na u vaki n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","U yaꞋin ka̱tsuma̱ ɗa u matsai maku, ɗa u neꞋi ni kula Eri. ");
INSERT INTO asg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","U doku u yaꞋin ka̱tsuma̱ kpamu ɗa u matsai maku mo kolobo ɗa u neꞋi ni kula Ona. ");
INSERT INTO asg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","U doku u matsai maku mo kolobo mo yoku ɗa u neꞋi ni kula Shela. Yahuda wi ta̱ e Keziba a ayin a na u matsai Shela va. ");
INSERT INTO asg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahuda u zamakai maku ma iyain ma̱ ni Eri vuka, kula ku vuka ka ku ɗaɗa Tamaru. ");
INSERT INTO asg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ama Eri maku ma Yahuda wi n ka̱ɗu ka singai a̱ ubuta̱ u Vuzavaguɗu ba, ɗa Vuzavaguɗu ta na wu unai ni. ");
INSERT INTO asg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ɗa Yahuda u danai Ona, <<Vaku n vuka vu vuza nu, ka̱ta̱ vi shatangu ulinga u kososo. Nannai ɗa vuza nu u kuciya̱ limata.>> ");
INSERT INTO asg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ama Ona u yeve ta̱ muku ma n kuyaꞋan n ni ba. Adama a nannai u vaku baci n vuka va ka̱ta̱ u tsuwa̱n ugapu ni pulai a iɗika, ta lo wa matsaka vuza ni muku. ");
INSERT INTO asg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ili i na u yaꞋin va Vuzavaguɗu u pana uyoꞋo ba, ɗa ta na wu unai ni feu. ");
INSERT INTO asg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ɗaɗa Yahuda u danai kejene ka̱ ni Tamaru, <<Bono a kpaꞋa ke eshevu vi yongo ɗe tsu vuka vu na vali vi ni vu kuwa̱i ali sai ayin a na maku ma̱ va̱ Shela u yawai vali.>> Adama a na u sheshe ta̱, <<Wi ta̱ a̱ kuta̱wa̱ wa̱ kuwa̱ feu tsu nkoshi n ni.>> Ɗa Tamaru u bonoi a kpaꞋa ke esheku a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A kubana megeshe ɗe ɗa vuka vu Yahuda, mekere ma Shuwa u kuwa̱i. Ana Yahuda u kotsoi kpalu ku nanlo, ɗa u banai a Timna a̱ ubuta̱ wa aza a kupuna cileme tsu nlala n ni, ka̱ja̱Ꞌa̱ ka̱ ni Hira vuza va aza Adulam feu u banai n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Vuza yoku u danai Tamaru a na esheku a vali a̱ ni a lazai a kubana a Timna a̱ ubuta̱ wa aza a kupuna cileme tsu nlala. ");
INSERT INTO asg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","U foɗoi motogu ma na a̱ma̱ci a na ali e le a̱ kuwa̱i a tsu uka, u palai ka̱ ci ka̱ ni n ka̱ka̱la̱bi, u palai mayin, u da̱sa̱ngi a̱ utsutsu u likuci u Enayim, u na wi a uye u kubana Timna. Adama a na we ene ta̱ Shela u gbonguro ta̱ ali n gogo na a zuwa yi ta na wo okpo vuka vi ni ba. ");
INSERT INTO asg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ana Yahuda we enei ni u sheshe ta̱ kashakanlai kaꞋa, adama a na u pala ta̱ a̱shi a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","U yeve a na kejene ka̱ ni kaꞋa ba, u banai wa̱ ni a uɓon wu uye wa ɗa u danai, <<Ta̱wa̱ n vaku n avu.>> Ɗa a̱yi tamkpamu we ecei, <<Yiɗa̱i vi e kuneke mu n vaku n avu?>> ");
INSERT INTO asg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ɗa Yahuda u danai, <<Mi ta̱ a̱ kusuꞋuku wu m maku ma malala a ushiga u va̱.>> Tamaru u danai, <<Ko vi ta̱ n ili i na ve kuneke tsu kaguta ali sai ayin a na malala ma ma̱ ta̱wa̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","U danai, <<Yiɗa̱i n kuneke wu tsu kaguta?>> Ɗa wu ushuki u danai, <<Urotu u ka̱ta̱mba̱ri u na wi e kuɗeku ku nu n kalangu ka nwalu ka̱ nu.>> U nekei ni ra̱ka̱, ɗa ta na u vaki n a̱yi, ali ɗa u ciya̱i ka̱tsuma̱ ");
INSERT INTO asg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","U ɗa̱nga̱i ɗa u lazai, u takpai ka̱ka̱la̱bi ka̱ ni ɗa kpamu u ukai motogu ma̱ a̱ma̱ci ma na ali e le a̱ kuwa̱ baci a tsu uka. ");
INSERT INTO asg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ana Yahuda u nekei maku ma malala ka̱ja̱Ꞌa̱ ka̱ ni vuza va aza Adulam u banka, adama a na wi isa ili i na u nekei tsu kaguta ka a̱ ubuta̱ u vuka wa, we enei ta na ba. ");
INSERT INTO asg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","We ecei uma a na i lo va, <<Teɗai kashakanlai ka na ki ishi na a Enayim ɗevu n uye wa?>> Ama ɗa a danai, <<Kashakanlai ki ishi lo na ba.>> ");
INSERT INTO asg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ɗa u bonoi u Yahuda, u danai, <<Me ene yi ba, ɗa feu aza a̱ likuci a a danai, <Kashakanlai ki ishi lo a̱ ubuta̱ wa ba.> >> ");
INSERT INTO asg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda u danai, <<Ka̱sukpa̱i ni u reme ili i na wi n i ɗa e ekiye a̱ ni, ta baci nannai ba, i ta̱ o kuzoꞋosoko tsu. N suꞋuku yi ta̱ maku ma malala, ɗa vu kpa̱ɗa̱i ku ene yi.>> ");
INSERT INTO asg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ana a yaꞋin wotoi u tatsu, ɗa a danai Yahuda, <<Kejene ka̱ nu Tamaru u ka̱na̱ ta̱ ukuna u tsugbani, ali ta na gogo na u ciya̱i ka̱tsuma̱.>> ");
INSERT INTO asg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ayin a na i a̱ kuta̱ n a̱yi pulai, u suki kadanshi a kubana we esheku a vali a̱ ni, <<Vuza vu ucanuku u nampa ɗa u yaꞋin mu ka̱tsuma̱.>> Ɗa u danai kpamu, <<Indanai, yayi n ka̱ta̱mba̱ri koɓolo n kalangu ka.>> ");
INSERT INTO asg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ɗa Yahuda u yevei ucanuku wa. U danai, <<U laꞋa mu ta̱ n ukuna u mayun, adama a na n zuwai wo olo maku ma̱ va̱ Shela ba.>> U doku u vaku n a̱yi ta na ba. ");
INSERT INTO asg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ana ayin a limata a yawai ni, mpeshe mo olobo n ɗa ta na mi ni punu a̱ ka̱tsuma̱ ka. ");
INSERT INTO asg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ayin a na wi a̱ ka̱tsuma̱ ka̱ a̱ga̱nda̱ a limata ya, ɗa vuza te wu uta̱ka̱i n kukiye ku ni pulai. Ɗa vuza kuka̱na̱ limata u shiyai kukiye ka n tsugbere ci shili n u danai, <<A̱yi na ɗa u gita̱i ku uta̱.>> ");
INSERT INTO asg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","U bonokoi n kukiye ku ni, ɗa vuza ni wu uta̱ka̱i n ku ni. Ɗa vuza kuka̱na̱ limata u danai, <<Nahannai ɗa vu ɓatsai?>> Ɗa e neꞋi ni kula Pereza, ɗaɗa uɓatsuki. ");
INSERT INTO asg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ɗaɗa vuza ni u ta̱wa̱i wu uta̱i n tsugbere ci shili ci ni e kukiye ku ni. Ɗa e neꞋi ni kula Zera. ");
INSERT INTO asg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Gogo na a ɗika ta̱ Isufu a kubana a Masar, ɗa Potifa, vuzagbayin vu kpaꞋa ku FiriꞋauna, vuza kelime va aza a kindi, vuza va aza a Masar u tsulai ni a̱ ubuta̱ wa aza Ishimaila a na a banai n a̱yi ɗe. ");
INSERT INTO asg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Vuzavaguɗu wi ta̱ koɓolo n Isufu, ali u ciya̱i una̱singai, u yongoi a kpaꞋa ku vuzagbayin vi ni vuza va aza a Masar. ");
INSERT INTO asg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifa u sakai we enei Vuzavaguɗu wi ta̱ koɓolo n Isufu, ɗa ta na Vuzavaguɗu u zuwakai ni una̱singai a ili i na u yaꞋin dem. ");
INSERT INTO asg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Isufu u ciya̱i mapasa ma singai a̱ ubuta̱ u vuzagbayin vi ni, u ka̱na̱i kutono n a̱yi. Potifa u zuwai ni wo okpo vuza kelime vu kpaꞋa vi ni, ili i na wi n i ɗa dem u nekei ni wi inda i ɗa. ");
INSERT INTO asg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","N ayin a na u zuwai ni wo okpo vuza kelime vu kpaꞋa ku ni n vuza na u kinda ucanuku u ni feu, Vuzavaguɗu u zuwakai kpaꞋa ku Potifa una̱singai adama a Isufu. Una̱singai u Vuzavaguɗu u tonoi ili i na wi n i ɗa ra̱ka̱, i kpaꞋa koɓolo n i pulai dem. ");
INSERT INTO asg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","U nekei Isufu ili i na wi n i ɗa ra̱ka̱ wi inda; a̱yi ili i doku i burai n ili i yoku ba, sai tsuwaꞋa tsu na u kulyaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","A kubana megeshe ɗa vuka vu Potifa u gita̱i kucikala yi, ɗa u banuki ni u vaku n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ama Isufu u iwain ɗa u danai vuka vu vuzagbayin vi ni, <<Inda, uteku u na vi e kene mu na vuzagbayin vu va̱ ili i burai n ili i na yi a kpaꞋa na ba, u ka̱sukpa̱ ta̱ ili i na wi n i ɗa dem e ekiye a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Babu vuza na u laꞋi mu n tsugbayin a kpaꞋa ku nampa. Vuzagbayin vu va̱ u sa̱nka̱ mu ili ba, sai avu koci adama a na avu vuka vi ni ɗa vi. Nini ɗai n kuyaꞋan ili i gbani-gbani i nanlo, ka̱ta̱ n yaꞋan unushi u gbayin a kubana a̱ ubuta̱ u Ka̱shile?>> ");
INSERT INTO asg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ko a na u yaꞋankai Isufu kadanshi a kanna dem, u iwain ta na kuvaku n a̱yi, ko kuyawa ɗevu n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kanna ke te ana u uwai a kpaꞋa kuyaꞋan ulinga u ni, babu ta na lo vuza yoku a kpaꞋa ka, ");
INSERT INTO asg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ɗa vuka va vu ka̱na̱i ni motogu, u danai, <<Vaku nu mpa!>> Ama u fa̱ta̱tsa̱i u ka̱sukpa̱ka̱i ni motogu ma e ekiye, ɗa u sumai a kubana pulai. ");
INSERT INTO asg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ana we enei u ciya̱ ta̱ wi isa yi motogu ɗa kpamu u sumai, ");
INSERT INTO asg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","u ɗekei aza a kpaꞋa a̱ ni a na a buwai ɗa u danai le, <<Indai, vali vu va̱ vu tuka̱ ta̱ vuza va aza a Ibirahi adama a na u tsuwa̱nka̱ mu n ishikushi! U uwai adama a na u vaku nu mpa, ɗa n lapai una̱ n ka̱la̱ka̱tsu ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ana u panakai mu mo worokpoi ka̱u, ɗa u ka̱sukpa̱i motogu ma̱ ni nu mpa, ɗa u sumai a kubana pulai.>> ");
INSERT INTO asg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","U ɓa̱na̱i motogu ma nanlo ali sai ayin a na vuza kpaꞋa vi ni u bonoi, ");
INSERT INTO asg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ɗa u danai ni arabali a kpamu derere, u danai, <<Kagbashi ka aza a Ibirahi, ka na vu tuka̱i tsu, u uwai adama u tsuwa̱nka̱ mu ni ili i wono; ");
INSERT INTO asg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ana n lapai una̱ n ka̱la̱ka̱tsu ka̱u, u sumai a kubana pulai u ka̱sukpa̱i motogu ma̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ana u kotsoi kupana arabali a vuka vi ni, ɗa Potifa u yaꞋin wupa ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","U ɗikai Isufu ɗa u zuwai ni a̱ kunu ku ugbashi a̱ ubuta̱ u na aza ugbashi o mogono i ushiyi. Ama a ayin a na Isufu wi a̱ ubuta̱ wu ugbashi, ");
INSERT INTO asg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Vuzavaguɗu wi ta̱ koɓolo n a̱yi, u yotsongi ni kpamu ucigi u ni n kasingai a̱ a̱shi a vuzagbayin vu na vi ci inda agbashi a. ");
INSERT INTO asg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Vuzagbayin vu na u ci inda agbashi a u nekei agbashi a na a buwai va dem e ekiye a̱ Isufu adama a na wi inda le feu, koɓolo n ukuna u na buwai punu dem. ");
INSERT INTO asg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Vuzagbayin vu na wi a kinda agbashi a u keɓece n ukuna u yoku ba, adama a na Isufu ɗa wi a kinda ili i na i buwai dem. Vuzavaguɗu u yongo ta̱ koɓolo n Isufu, ili i na baci u yaꞋin dem sai i ɗa i lyaꞋa kelime. ");
INSERT INTO asg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ayin o yoku ɗe ɗa vuza kelime vi kuneke mogono ili i kusoꞋo n vuza na u tsu kangala boroji a yaꞋankai vuza kpaꞋa vi le mogono ma Masar unushi. ");
INSERT INTO asg_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ɗa mogono FiriꞋauna u yaꞋin wupa n ele ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","U ɓa̱ya̱ngi le a kpaꞋa ku vuza kelime vu kinda mogono ma, a ubuta̱ wu ugbashi u na a̱ ɓa̱ya̱ngi Isufu. ");
INSERT INTO asg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Vuza kelime vi kinda agbashi va u zuwai Isufu kelime ke le, u vanai le; ɗa o yongoi ɗe ali sai ayin o yoku kenu. ");
INSERT INTO asg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kayin ko yoku ɗe a̱ kunu ku ugbashi ka, vuza na u ci neke mogono ili i kusoꞋo n vuza na u tsu kangala boroji vu mogono ma aza a Masar va a yaꞋin alatani, alatani a ta na a kudansa ili kakau. ");
INSERT INTO asg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ana Isufu u ta̱wa̱i we le n usana, ɗa we enei i punu m ma̱za̱nga̱ ba. ");
INSERT INTO asg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","We ecei aza a ulinga u gbagbaꞋin a FiriꞋauna, aza a na i koɓolo n a̱yi a kpaꞋa ku vuzagbayin vi ni, <<Yiɗa̱i i la̱nga̱sa̱i a̱shi anana nannai?>> ");
INSERT INTO asg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","A danai ni, <<Ci yaꞋan ta̱ alatani, babu vuza na u kudana tsu ili i na i a kudana.>> Ɗa Isufu u danai le, <<Kuyeve ili i na alatani i a kudansa ta ki a̱ ubuta̱ u Ka̱shile ba? Danai mu a ɗa.>> ");
INSERT INTO asg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ɗa vuzagbayin vu kuneke mogono ili i kusoꞋo u danai Isufu alatani a̱ ni, u danai, <<A̱ ubuta̱ wa alatani u va̱ me enei ma̱ɗimbi ma Ayahudawa, ");
INSERT INTO asg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","A̱ ma̱ɗimbi ma acaka a tatsu i ta̱ ɗe. Ana o kotsoi kutopo, a̱pa̱lu a yaꞋin a kubana megeshe kenu ɗa u gita̱i kumatsa. ");
INSERT INTO asg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Matan ma FiriꞋauna punu e ekiye a̱ va̱, ɗa n taꞋai umaci u mambulu n ka̱na̱i kupisha punu a matan ma FiriꞋauna ma, ɗa n nekei matan ma e ekiye a FiriꞋauna.>> ");
INSERT INTO asg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Isufu u danai, <<Ili i na ili i nampa yi a kudana i ɗa na: acaka a tatsu a nanlo i ta̱ a kadanshi ka ayin a tatsu. ");
INSERT INTO asg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","A̱ ka̱tsuma̱ ka ayin a tatsu FiriꞋauna wi ta̱ kudengusa wu ka̱ta̱ u bonoko wu a̱ ubuta̱ u vuzagbayin vu nu; ka̱ta̱ avu vi neke FiriꞋauna matan ma̱ ni e ekiye, tsu na vi ishi vi ci yaꞋan ayin a na vi ci neke yi ili i kusoꞋo. ");
INSERT INTO asg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ama ayin a na baci ukuna u gaꞋin nu vi ciɓa nu mpa; yaꞋanka mu kasingai ka̱ta̱ vu dansa ukuna u va̱ a̱ ubuta̱ u FiriꞋauna, adama a na a̱ uta̱ka̱ mu punu a̱ ubuta̱ u nampa. ");
INSERT INTO asg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Adama a na o boko mu ta̱ a iɗika ya aza a Ibirahi; ko punu na a Masar n yaꞋan ili i na i yawai a zuwa mu a ugbashi ba.>> ");
INSERT INTO asg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ana vuza kelime vu kukangala boroji we enei ili i na alatani a i a kudansa i gaꞋan ta̱, u danai Isufu, <<Mpa feu n yaꞋan ta̱ alatani: me enei mbana ma akala n tatsu a kaci ka̱ va̱, ");
INSERT INTO asg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","punu a mabana ma gaɗi ili yi ukangali yi ta̱ ɗe kakau i singai-singai i na a yaꞋankai FiriꞋauna, ama nnu a kulyaꞋa i ɗa a gaɗi vu kaci ka̱ va̱ ka ɗe.>> ");
INSERT INTO asg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Isufu wu ushuki u danai, <<Ili i na i a kudana i ɗa na: mbana n tatsu ma ayin a tatsu a ɗa. ");
INSERT INTO asg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","A̱ ka̱tsuma̱ ka ayin a tatsu a nanlo FiriꞋauna wi ta̱ a kugbatya kaci ka̱ nu, ka̱ta̱ u saku keven ki ikyamba ka̱ nu a maɗanga; nnu n takuma keven ki ikyamba ka̱ nu ka.>> ");
INSERT INTO asg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A kanna ka tatsu, ɗa kpamu kanna ka na a matsai FiriꞋauna, u yaꞋin ka̱ɗiva̱ adama a agbashi a̱ ni ra̱ka̱, ɗa u ɗengusa̱i vuza na u ci neke yi ili i kusoꞋo koɓolo n ka vuza na u tsu kangalaka yi boroji e mere ma agbashi a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","U bonokoi vuza kelime vu na u ci neke mogono ili i kusoꞋo a̱ ubuta̱ u na wi ishi, ɗa u nekei FiriꞋauna matan e ekiye, ");
INSERT INTO asg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ama ɗa u saki vuza kelime vu kukangala boroji, derere tsu na Isufu u danai le. ");
INSERT INTO asg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ama vuza kelime vu kuneke mogono ili i kusoꞋo u ciɓa biꞋi n Isufu ba, u cinukpai n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ana a̱ya̱ e re a lazai ɗa Mogono FiriꞋauna ma yaꞋin alatani a na wi a kashani o kuɗolu ku Nilu, ");
INSERT INTO asg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ɗa anaka a singai e cindere a̱ uta̱i punu o kuɗolu ku Nilu ka ɗa a̱ ka̱na̱i kalina. ");
INSERT INTO asg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ɗa kpamu anaka e cindere a gbanigbani ayambishi ɗa a̱ uta̱i punu e kuyene ku Nilu ɗa a shamgbai lo a̱ kucina ka aza a singai a. ");
INSERT INTO asg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Anaka a gbani-gbani n ayambishi a takumai aza a gbaga n ikyamba. Ɗa FiriꞋauna u jimgbai. ");
INSERT INTO asg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ɗa u doku u latai kpamu, ɗa u doku u yaꞋansai alatani o yoku. Arata ilya kpamu a kakungu ke te, arata kpamu e cindere a singai uta̱ kpamu punu a̱ ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Lo kpamu a̱ kucina̱ ka ɗa arata e cindere a̱ uta̱i avavau aza ana wunla̱i u kasana warai le. ");
INSERT INTO asg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ɗa avavau a o soɗongi arata a singai a. Ɗa FiriꞋauna u rikpa̱i, ashe alatani a ɗa yi. ");
INSERT INTO asg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","N usana ɗa ka̱ɗu ko mogono ka̱ na̱mgba̱i, ɗa u suki e ɗeke yi oboci n aza ugboji a Masar. Adama a na a dana yi alatani a ama babu vuza na u fuɗai u danai ni a ɗa. ");
INSERT INTO asg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ɗa kagbashi ko mogono ka ka danai ni, <<N ciɓa ta̱ n unushi u va̱ anana. ");
INSERT INTO asg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","FiriꞋauna vu saꞋwa ta̱ kuyaꞋan wupa n kagbashi ka̱ nu vuza na u ci yaꞋanka wu boroji punu a kpaꞋa ku ugbashi. ");
INSERT INTO asg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","A̱ tsu aza e re a̱ tsu ci yaꞋin alatani, alatani a̱ tsu kpamu i ta̱ a kudansa ili kakau. ");
INSERT INTO asg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Punu a ugbashi wa vuza va aza a Ibirahi wi ta̱ punu n a̱ tsu, kagbashi ko kosoji ka gbayin ki ta̱ punu feu. Ɗa tsu danai ni alatani a̱ tsu, ɗa u danai tsu ko yi ɗa̱i alatani a i a kudana. ");
INSERT INTO asg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Uteku u na u danai tsu, ta tana ili ya yo okpoi nannai. Mpa ɗa o bonokoi mu a̱ ubuta̱ wu ulinga u va̱, vuza te kpamu vuza na u tsu kangalaka mogono boroji ɗa a unai ni.>> ");
INSERT INTO asg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ɗa mogono ma zuwai ɗa a̱ utuka̱i n Isufu a̱ kunu ku ugbashi uta̱ka̱i ni ubuta̱ ma lo. Ana a punai ni ɗa a sabaꞋi ni ntogu, ɗa u banai e kelime ka FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ɗa FiriꞋauna u danai Isufu, <<N yaꞋan ta̱ alatani. Babu vuza na kpamu u fuɗai u danai mu a ɗa. Ama m pana ta̱ a dana vu tsu dana ta̱ uma alatani e le. I ɗa i zuwai ɗa n ɗekei nu.>> ");
INSERT INTO asg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ɗa Isufu u danai ni, <<Mpa mi a kufuɗa ba. Ama Ka̱shile ki ta̱ e kuneke FiriꞋauna wu ushuki u singai.>> ");
INSERT INTO asg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ɗa FiriꞋauna u danai Isufu, <<Alatani a ɗa na: Mpa, mi ta̱ a kashani a̱ ka̱kina̱ ke Kuyene ku Nilu. ");
INSERT INTO asg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Punu a̱ mini ma, ɗa anaka e cindere a̱ uta̱i punu a̱ mini ma. Aza a ikyamba molu-molu, ɗa a̱ ka̱na̱i lo kalina a̱ ubuta̱ wi ijanu, i na yi lo va. ");
INSERT INTO asg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ana i lo kpamu, ɗa anaka e cindere o yoku o doku ɗa a̱ uta̱i ayambishi, babu kpamu tsuloboi. Mpa ta na ka̱ta̱ n saꞋwa kene icuꞋu ya anaka i nanlo punu na Masar ba. ");
INSERT INTO asg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ɗaɗa ayambishi a anaka a gbani-gbani a, ɗa a takumai anaka a ikyamba a dem. ");
INSERT INTO asg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ko a na a takumai aza a ikyamba a okpoi adanshi a takuma ili ba, i ta̱ lo n una̱mgbi u le tsu na ishi cau. Ɗaɗa n jimgbai. ");
INSERT INTO asg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Punu a alatani a̱ va̱ a kpamu me ene ta̱ arata a ilya e cindere a singai. Ɗa kpamu i a kakungu ke te. ");
INSERT INTO asg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ɗa kpamu arata a ilya o yoku e cindere a̱ uta̱i. Avavau a alumbushi kpamu, aza a na wunla̱i u kasana wi ɗe o koꞋuso. ");
INSERT INTO asg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ɗa avavau a o soɗongi arata a ilya a singai a. N danai oboci ukuna u nampa, ama babu vuza na u fuɗai u yevekei mu ukuna wa.>> ");
INSERT INTO asg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ɗa Isufu u danai FiriꞋauna, <<Alatani a̱ nu icuꞋu i te ɗa ra̱ka̱. Ka̱shile kaꞋa ko yotsongi nu ili i na yi lo a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Anaka a ikyamba a singai a ɗaɗa a̱ya̱ e cindere a singai arata e cindere kpamu ɗaɗa a̱ya̱ a singai e cindere kpamu. Alatani a i ta̱ a kadanshi ki ili i te dem. ");
INSERT INTO asg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ayambishi a anaka e cindere kpamu an na uta̱i punu e kuyene ka n avavau e cindere a na wunla̱i u kasana warai ita̱ a kadanshi ka̱ a̱ya̱ e cindere feu a kambulu. ");
INSERT INTO asg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ta kaꞋa ki nannai Ka̱shile ko yotsongu ta̱ FiriꞋauna i na yi lo a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","A̱ya̱ e cindere i ta̱ lo a̱ kuta̱wa̱, a na yaba dem u kuciya̱ ili i kulyaꞋa na Masar. ");
INSERT INTO asg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ama feu a̱ya̱ e cindere a kambulu i ta̱ lo a̱ kuta̱wa̱. Uma kpamu i ta̱ a kucinukpa n uciyi u na wishi lo dem. Punu na Masar, kambulu kpamu ki ta̱ a̱ kuka̱ra̱Ꞌa̱ iɗika ya dem. ");
INSERT INTO asg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Wi ta̱ o kokpo adanshi ka̱ta̱ ishi a saꞋwa kuciya̱ ilikulyaꞋa ba, adama a na kambulu ka ki ta̱ a kuyimkpa ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ili i na i zuwai ɗa alatani a uta̱i ku re ɗaɗa, kadanshi ka̱ Ka̱shile kaꞋa ko foɓusoi kaꞋa n ka̱ci ka̱ ni, Ka̱shile kpamu ki ta̱ a kuyaꞋan kaꞋa m megeshe ba. ");
INSERT INTO asg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","<<Gogo na u gaꞋan ta̱ FiriꞋauna u la̱nsa̱ vuza vu ugboji n cicoꞋo, vuza na u yevei ka lyalyaꞋi, ka̱ta̱ u zuwa yi u la̱na̱ iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","YaꞋan FiriꞋauna u zuwa aza a na a kinda iɗika. A ɗika kpamu ili i re a̱ ka̱tsuma̱ ki ili kupa i na uma a Masar a kyaꞋi dem a̱ ka̱tsuma̱ ka̱ a̱ya̱ e cindere a nanlo adama a na o foɓo. ");
INSERT INTO asg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","YaꞋan uma o ɓolongu ilikulyaꞋa a̱ ka̱tsuma̱ ka̱ a̱ya̱ e cindere a singai a nampa a na i lo a̱ kuta̱wa̱, ka̱ta̱ o foɓo ilikulyaꞋa ya nu utsura u mogono FiriꞋauna, a zuwa i ɗa a̱ likuci i gbagbaꞋin yi iɗika ya. ");
INSERT INTO asg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","IlikulyaꞋa i nanlo kpamu a zuwa i ɗa adama a iɗika i Masar. Adama a na uma e pece ka̱ta̱ kambulu ka̱ a̱ya̱ e cindere ka kuna le dem ba.>> ");
INSERT INTO asg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kadanshi ka nanlo kpamu ka zuwa ta̱ FiriꞋauna n abara a̱ ni a̱ ushuku n kadanshi ka. ");
INSERT INTO asg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ɗa we ecei le, <<Ci ta̱ a kufuɗa tsa̱ ciya̱ vuza tsu nampa vuza na kpamu u laꞋi ni? Vuma vu nampa kpamu wi ta̱ n ayinviki a̱ Ka̱shile.>> ");
INSERT INTO asg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ɗa mogono FiriꞋauna u danai Isufu, <<Ci ta̱ a kufuɗa tsa̱ ciya̱ vuma vu na ayinviki a̱ Ka̱shile ki n a̱ya̱ nahannai? Babu vuza na u yawai nu ugboji n cicoꞋo tsu nu. ");
INSERT INTO asg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Avu ɗa vo kokpo vuzagbayin vu kefeku ko tsugono ka̱ va̱, uma a̱ va̱ kpamu i ta̱ e kuneke wu tsugbayin. Ili i na n kulaꞋaka wu i ɗaɗa kakuba ku tsugono ka̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ɗa FiriꞋauna u danai Isufu, <<Gogo na n zuwa wu ta̱ vo okpo vuza na u kula̱na̱ iɗika i Masar.>> ");
INSERT INTO asg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ɗa FiriꞋauna u foɗoi makawani a̱ ka̱jivu ka̱ ni ɗa u ukai a̱ ka̱jivu ka̱ Isufu. Ɗa u ukai ni aminya a na a yaꞋin n arikinla a singai ɗa u ukai ni idolu ya azanariya e kuɗeku ku ni. ");
INSERT INTO asg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ɗa FiriꞋauna u zuwai Isufu u kumba keke vo odoku vi ni wo okpoi an mogono me i re a iɗika i Masar Ɗa a̱duga̱ri o mogono a̱ ka̱na̱i kusala, <<Nekei uye.>> Ta a zuwai Isufu wo okpoi gomuna vu Masar nannai. ");
INSERT INTO asg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ɗa FiriꞋauna u danai Isufu, <<Mpa ɗa mogono, ama koɓolo n kadanshi ka̱ nu kaꞋa baci ba babu vuza na u kuɗa̱ngusa̱ kukiye ka̱ta̱ u yaꞋan ili na a iɗika i Masar.>> ");
INSERT INTO asg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ɗa FiriꞋauna u neꞋi Isufu kula Zafinatu Peniya ɗa u nekei ni Asenatu mekere ma Potifera ganu vu Onu wo okpo yi vuka. Isufu ta na wo okpoi vuza vu utsura a iɗika i Masar dem. ");
INSERT INTO asg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ayin a nanlo Isufu wi ta̱ n a̱ya̱ kamangankupa (30), ana u uwai ulinga n FiriꞋauna a iɗika i Masar. Ɗa Isufu wu uta̱i u FiriꞋauna, ɗa u ka̱ra̱Ꞌi iɗika i Masar dem. ");
INSERT INTO asg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","A̱ ka̱tsuma̱ ka̱ya̱ e cindere a nanlo ɗa ubuta̱ dem u matsai ili n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ɗa Isufu u ka̱na̱i ki isa ilikulya n u zuwai a̱ ka̱tsuma̱ ka̱ a̱ya̱ e cindere a nanlo a̱ likuci i gbagbaꞋin i Masar. Likuci dem ɗa u zuwa a zuwai ilikulyaꞋa ya a ashina a na i uka̱ra̱Ꞌi u likuci ya. ");
INSERT INTO asg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ta Isufu u zuwai ilikulyaꞋa nannai n a̱bunda̱i i ɗa i yimkpa ta̱ ali ɗa u ta̱wa̱i u ka̱sukpa̱i kukuzuku i ɗa adama a na i laꞋa ta̱ kukunzuku. ");
INSERT INTO asg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kafu a̱ya̱ e cindere a nanlo a yawa a matsaka ta̱ Isufu muku mo olobo n re aza a na Asenatu mekere ma Potifera ganu vu Onu u matsakai ni. ");
INSERT INTO asg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ɗa Isufu u neꞋi maku ma̱ ni kula Manasa (Ncinukpa) adama a na u dansa ta̱ n ka̱ɗu ka̱ ni, <<Ka̱shile ka zuwa mu ta̱ ɗa n cinukpai n atakaci a̱va̱ dem n a kpaꞋa ke esheku a̱va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Maku me ire u neꞋi ni kula Ifirayimu adama a na u dana ta̱ a̱ ka̱ɗu ka̱ ni <<Ka̱shile ke neke mu ta̱ muku a iɗika i na n takacikai.>> (Akungusan). ");
INSERT INTO asg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ayin a̱ ucuwi a iɗika i Masar o kotsoi. ");
INSERT INTO asg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ɗa a̱ya̱ a kambulu a̱ gita̱i kuꞋuwa uteku tsu na Isufu u danai va. A̱ ubuta̱ u na u buwai dem, u ɗa wi ta̱ n kambulu ka gbayin. Ama a iɗika i Masar utalu wi ta̱ ɗe. ");
INSERT INTO asg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ana kambulu ka̱ yikpa̱i a iɗika ɗa uma a̱ shiꞋika̱i FiriꞋauna. Ɗa FiriꞋauna u danai le a bana u Isufu i na baci u danai le dem a yaꞋan. ");
INSERT INTO asg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ana kambulu ka̱ ka̱ra̱Ꞌi iɗika dem ɗa Isufu u zuwai a̱ ɓa̱yuwa̱ mpon ma adama a na e denke aza Masar ilikulya. ");
INSERT INTO asg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Uma n a̱bunda̱i a aduniyan a banai Masar adama ana a tsula ilikulyaꞋa e ekiye a̱ Isufu, adama a na kambulu ka ka yimkpa ta̱ a aduniyan. ");
INSERT INTO asg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ana Yakubu u panai a danai ilikulyaꞋa yi ta̱ ɗe a Masar, ɗa u danai muku n ni, <<Yiɗa̱i ɗa yi a mindanai uteku u ɗa̱?>> ");
INSERT INTO asg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","M pana ta̱ <<Utalu wi ta̱ ɗe Masar. Banai, i tsula adama a na ci ciya̱ ilikulyaꞋa ta lo tsa̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Isufu nkoshi n ni uma kupa a banai Masar adama a na a tsula ilikulyaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ama Yakubu u suku Bayami ba, adama a na wi ta o wovon talo ili i yoku ya̱ ciya̱ le i muna. ");
INSERT INTO asg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Muku n Yakubu i ta̱ a̱ ka̱tsuma̱ ka aza na a banai kutsula ilikulyaꞋa, adama a na kambulu ka̱ yikpa̱ ta̱ feu a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ayin a nanlo ta na, a zuwa ta̱ Isufu wo okpo gomuna vi iɗika i Masar. A̱yi ɗa kpamu vuza na u kudenge utalu ya a̱ ubuta̱ u uma. Ana Isufu aza a̱ ni a banai wa̱ ni, ɗa a̱ kuɗa̱nki ni, ali ɗa a̱ ka̱na̱i kulyaꞋa kayala. ");
INSERT INTO asg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ana Isufu we enei aza a̱ ni, ɗa ta na u yevei le. Ama ɗa u yaꞋin adanshi u yeve le ba. Ɗa u ka̱na̱i kuyaꞋanka le kadanshi ka wuya. Ɗa we ecei le, <<Te ɗai tamkpamu yu uta̱i?>> Ɗa a̱ ushuki, <<Tsu uta̱ ta̱ a iɗika i KanaꞋana. Tsu ta̱wa̱ ta̱ adama a na tsu tsula utalu.>> ");
INSERT INTO asg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Isufu u yeve le ta̱, ama ele e yeve yi ba. ");
INSERT INTO asg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ɗa u ciɓai n alatani a̱ ni. Ɗa u danai le, <<A̱ɗa̱ omoci a ɗa, aza a na a tsu saka ubuta̱, adama a na a banka n kuvon. I ta̱wa̱ ta̱ adama a na i la̱na̱ ubuta̱ u na wi babu utsura ka̱u.>> ");
INSERT INTO asg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ɗa a danai ni, <<A̱ a̱ vuzagbayin tsu ta̱wa̱ ta̱ adama a na tsu tsula ilikulyaꞋa ");
INSERT INTO asg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","A̱ tsu muku n vuza te n ɗa; a̱ tsu aza usuɓi a ɗa kpamu ci; agbashi a̱ nu ka̱ta̱ a saꞋwa kubana tsusaki ba.>> ");
INSERT INTO asg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","<<A̱ a̱>> ɗa u danai le. <<I ta̱wa̱ ta̱ adama a na ye ene tsu na iɗika i tsu yi.>> ");
INSERT INTO asg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ɗa a danai ni, <<A̱ tsu a agbashi a̱ nu a ɗa, ci ta̱ uma kupa n aza e re. Esheku e te a ɗa kpamu, vuza na kpamu wi ida̱shi a iɗika i KanaꞋana. Auta vu tsu wi ta̱ ɗe n esheku a̱ tsu, vuza te kpamu u buwa lo ba.>> ");
INSERT INTO asg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ɗa Isufu u danai le, <<Ɗaɗa i zuwai ɗa n danai, <A̱ɗa̱ aza a tsusaki ki iɗika a ɗa adama o kuvon.> >> ");
INSERT INTO asg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tsu na n kukondo ɗa̱ ɗa na. FiriꞋauna wi baci lo de n wuma, ya̱ kuka̱sukpa̱ ubuta̱ u nampa ba, sai i tuka̱ n vangu vu ɗa̱ na. ");
INSERT INTO asg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Suki vuza te a̱ ka̱tsuma̱ ka̱ ɗa̱, aza a na a buwai a shamgba na a na agbashi, ta o kukondo kadanshi ka̱ ɗa̱ nannai ci yeve ko mayun ɗa yi a kudansa. Mayun ɗa baci ta na ba, n kucina ta̱ n FiriꞋauna a̱ɗa̱ aza a tsusaki a ɗa yi. ");
INSERT INTO asg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ɗa u remei le. Ɗa u zuwai le ali ayin a tatsu. ");
INSERT INTO asg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A kanna ka tatsu ɗa Isufu u danai le, <<Ili i na i kuyaꞋan ka̱ta̱ i yaꞋan wuma i ɗa na mpa mi ta̱ o wovon u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","A̱ɗa̱ aza a mayun a ɗa baci yi ka̱sukpa̱ vuza te vu ɗa vu shamgba na a ugbashi, aza a na a buwai a ɗika ilikulyaꞋa a banka a kpaꞋa aza na i ɗe n kambulu. ");
INSERT INTO asg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ka̱ta̱ i tuka̱ mu n Auta vu ɗa̱ i yaꞋan baci nannai ta n kushuku n a̱ɗa̱ babu vuza na u kuna ɗa̱.>> Ɗa Isufu aza a̱ ni a̱ ushuki kuyaꞋan nannai. ");
INSERT INTO asg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ɗa a danai uteku u le n kelentsu ke le, <<Mayun mpasa n vangu vu tsu n ɗa mi o kutono tsu adama a na ce ene ta̱ atakaci a̱ ni a ayin a na wi o kufolono tsu tsu ɓa̱nka̱ yi, ama ɗa ci iwain kupanaka yi. Adama a nannai mpasa n ni ɗa mi o kutono tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ɗa Ruben u danai, <<N dana ɗa̱ ba ka̱ta̱ i yaꞋanka maku ma nannai ba? Ɗa i iwain kupanaka mu. Anana mpasa n ni a ɗa mi o kutono tsu.>> ");
INSERT INTO asg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","E yeve a na Isufu u yeve ta̱ kelentsu ke le ba, adama a na wi ta̱ a kuyaꞋanka le kadanshi n u danai ni ili i na i a kudansa. ");
INSERT INTO asg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ɗa Isufu u kpatalai a̱ ubuta̱ u yoku ɗa u ɓa̱ruwa̱i ma̱shi. Ɗa u doku ɗa u bonoi we le kpamu ɗa u yaꞋankai le kadanshi. A ɗikai Simiyon ɗa a shiyai ni lo e kelime ke le. ");
INSERT INTO asg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ɗa Isufu u zuwai a shatangu a̱bufu e le nu utalu ka̱ta̱ kpamu o bonoko n yaba dem n ikebe i ni a̱ ta̱nki vi ni. Ta u yaꞋankai ni nannai. ");
INSERT INTO asg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ɗa a zuwakai njaki le ucanuku ɗa a lazai. ");
INSERT INTO asg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","A̱ ubuta̱ u na a shamgbai adama ana asa, ɗa vuza te u ɓa̱yuwa̱i ucanuku u ni ana we neke majaki ma̱ ni ilikulya, ɗa u cinai azanariya punu a ucanuku u ni. ");
INSERT INTO asg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ɗa u danai aza a̱ ni, <<O bonoko ta̱ n azanariya a̱ va̱,>> U danai. <<A ɗa na punu ucanuku u va̱.>> Ɗa a̱ɗu e le a̱ muɗa̱i le ɗa a dagazai ɗa a dananai, <<Yiɗa̱i Ka̱shile ka yaꞋankai tsu nahannai?>> ");
INSERT INTO asg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ana a yawai we esheku e le Yakubu a KanaꞋana ɗa a danai ni ili i na i ciya̱i le dem. ");
INSERT INTO asg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","<<Vuma vu na a zuwai vuzagbayin vi iɗika ya u yaꞋanka tsu ta̱ kadanshi n wupa u neke tsu ta̱ kpamu atakaci ali u danai a̱ tsu va aza tsusaki a ɗa ci. ");
INSERT INTO asg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ama ɗa tsu danai ni, <A̱ tsu aza usuɓi a ɗa ci; aza tsusaki ki iɗika kaꞋa ci ba. ");
INSERT INTO asg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ci ta̱ uma kupa n aza e re muku me esheku e te. Ama vuza te vu tsu u buwa lo n wuma ba vuza kene vu tu kpamu wi ta̱ ɗe KanaꞋana n esheku a̱ tsu.> ");
INSERT INTO asg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","<<Ɗa kpamu vuzagbayin va u danai tsu kpamu, <Tsu nampa tsu ɗa kpamu n kuyeve ko aza a mayun a ɗa yi: ka̱sukpa̱i vuza te ɗa̱ na nu mpa ama ɗikai ilikulyaꞋa i banka aza a kambulu a kpaꞋa ku ɗa̱. ");
INSERT INTO asg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tuka̱i mu n vuza vu ukocishi vu ɗa̱ ta n kuyeve nannai a na a̱ɗa̱ aza a tsusaki ki iɗika kaꞋa yi ba, mi ta̱ o kubonoko ɗa̱ n vuma ɗa̱ ka̱ta̱ i lyaꞋa kelime n tsulaga a iɗika ya.> >> ");
INSERT INTO asg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ana yaba dem u tsuwa̱in ilya i ni o mopon ɗa yaba dem vi le u cinai ikebe i ni punu. Ana ele n esheku e le e enei ikebe ya ɗa a panai wovon. ");
INSERT INTO asg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ɗa Yakubu u danai le, <<A̱ɗa̱ ɗa i sa̱nka̱i muku n va̱. Isufu wi lo ba Simiyon kpamu wi lo ba, gogo na kpamu Bayami ɗa yi a kuciga ya ɗika. Ili dem adanshi i ɗa yi ta̱ a kuꞋiwan mu.>> ");
INSERT INTO asg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ɗa Ruben u danai esheku, <<Vi ta̱ a kufuɗa va kuna muku n re n va̱ m bono baci n a̱yi ba. Ka̱sukpa̱ka̱ mu a̱yi wa̱ va̱, mi ta̱ o kubonoko yi na.>> ");
INSERT INTO asg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ama ɗa Yakubu u danai ni, <<Maku ma̱ va̱ mo kutono wu a kubana na ɗe ba; vuza ni u kuwa̱ ta̱ ɗe a̱yi ɗa u buwai mu n wuma. Ili i yoku i ciya̱ ɗa baci a uye a̱ ka̱tsuma̱ ka nwalu, yi ta̱ a kuzuwa mu n kuwa̱ n ka̱tsuma̱ ka̱ lima̱,>> ");
INSERT INTO asg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ana kambulu ko doku ka yinkpasakai ka̱u a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ana o kotsoi kulyaꞋa utalu u na a banai a tsulai a Masar, ɗa esheku e le a danai le, <<Banai i doku i tsulaka tsu utalu kenu.>> ");
INSERT INTO asg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ama ɗa Yahuda u danai le, <<Vuma va u dana ta̱, <Yo kudoku ye kene a̱shi a̱ va̱ ba, sai i tuka̱ mu n vuza vu ukocishi vu ɗa̱ na.> ");
INSERT INTO asg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Vu ka̱sukpa̱ tsu baci tsu bana n vangu vu tsu ci ta̱ a kubana tsa tsulaka wu utalu. ");
INSERT INTO asg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ama vi baci a̱ kuka̱sukpa̱ yi u bana ba, a̱ tsu feu ci a kubana ɗe ba, adama a na vuma va u dana tsu ta̱, <Yi o kudoku ye kene a̱shi a̱ va̱ ba, sai yi koɓolo n vuza ɗa̱.> >> ");
INSERT INTO asg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ɗa Isaraila we ecei le, <<Yiɗa̱i i zuwai ɗa yi a̱ kutuka̱ mu n atakaci ali ɗa i danai ni yi ta̱ n vangu vu ɗa̱ vi yoku?>> ");
INSERT INTO asg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A̱ ushuki, <<Vuma va u ɗeke tsu ta̱ ɗa u ka̱na̱i kece tsu mayin uteku u na kpaꞋa ku tsu ki. <Esheku a̱ ɗa̱ i ta̱ n wuma? Yi ta̱ n vangu vu ɗa̱ vi yoku?> Ɗa tsu ushuki keci ku ni. Nini ɗai tsu kuyeve wi ta̱ a kudana tsu sai tsu tuka̱ n vangu vu tsu?>> ");
INSERT INTO asg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ɗa Yahuda u danai esheku a̱ ni Isaraila, <<Zuwa maku ma ma bana n a̱ tsu ci ta̱ a kulaza gogo na, adama a na avu m muku n tsu tsa̱ kukuwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mpa a̱ ka̱ci ka̱ va̱ mi ta̱ a kinda ma̱ta̱na̱ ma̱ ni, ve ece mu u bono baci ba. Ɗa baci m bonoi n a̱yi ba, mi ta̱ a̱ kushuku ili i na baci de dem i ciya̱i mu. ");
INSERT INTO asg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ishi baci tsu la̱nga̱sa̱ ayin ba an tsu bana ta̱ ɗe tsu bono kure.>> ");
INSERT INTO asg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ɗa esheku a a danai, <<Ta baci de nannai sai i yaꞋan ili i nam ba, ɗikai ili i singai i yoku yi iɗika i nampa ka̱ta̱ i zuwa a ajika n ɗa̱, ka̱ta̱ i banka vuza va tsu kuneꞋe, maniꞋin, n ishigi, n ili i ma̱gula̱ni, n umaci u maɗanga u Pisatashiyo, n alumo. ");
INSERT INTO asg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ɗikai ikebe n a̱bunda̱i i na i laꞋi i cau ya i bonoko n ikebe i na a zuwakai ɗa̱ a ajika a̱ ɗa̱ a, u gaꞋan ba ucunukpi u ɗa le. ");
INSERT INTO asg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ɗikai vangu vu ɗa̱ i laza a kubana a̱ ubuta̱ u na vuma va wi. ");
INSERT INTO asg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ka̱sukpa̱ Ka̱shile ka na ki n utsura dem ka zuwa vuza va u pana asuvayali a̱ ɗa̱, ali ka̱ta̱ u bonoko ɗa̱ n vuza ɗa̱ koɓolo m Bayami ka̱ta̱ i bono koɓolo. Ama mpa unambi u ta̱wa̱ mu baci u ta̱wa̱ mu ta̱ ta na.>> ");
INSERT INTO asg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ɗa uma a ɗikai kuneꞋe ka ali ɗa kulaꞋi ku cau ka, ɗa feu a banai m Bayami. Ɗa a dakakai a lazai a kubana a Masar adama a na o yotsongu ka̱ci ke le u Isufu. ");
INSERT INTO asg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ana Isufu we enei Bayami n ele ɗa u danai agbashi a kpaꞋa a̱ ni, <<Ɗikai uma a na mpa a kubana a kpaꞋa ku va̱, kiɗakai le manama mo yoku ka̱ta̱ i suꞋwanka le, i ta̱ a kulyaꞋa anana nu mpa.>> ");
INSERT INTO asg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ɗa kagbashi ka ka yaꞋin tsu na a danai ni ɗa u ɗikai uma a kubana a kpaꞋa ku Isufu. ");
INSERT INTO asg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Uma a panai wovon n a̱bunda̱i a na a ɗikai le a kubana a kpaꞋa ku Isufu. ");
INSERT INTO asg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ɗa a banai u kagbashi ka̱ Isufu ɗa a yaꞋin kadanshi n a̱yi a̱ utsutsu u kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ɗa a danai, <<Ka̱na̱ ka̱ɗu vuzagbayin, cau tsu ta̱wa̱ ta̱ na kutsula utalu. ");
INSERT INTO asg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ama ubuta̱ u na ci shamgbai kasa ɗa tsu ɓa̱yuwa̱i ucanuku u tsu ɗa ci cina ikebe i tsu punu i ɗa ta na tsu bonokoi na. ");
INSERT INTO asg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tsu tuka̱ ta̱ kpamu n ikebe i yoku adama a na tsu tsula utalu kpamu ci yeve vuza na u zuwai ikebe punu a utalu wa ba a ayin a na tsu ta̱wa̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ɗa kagbashi ka ka danai, <<Ka̱ta̱ i dagaza ba. Ka̱ta̱ kpamu i pana wovon ba. Ka̱shile ka̱ ɗa̱ Ka̱shile ke esheku a̱ ɗa̱ u gaꞋan ba a̱yi ɗa u zuwakai ɗa̱ ikebe ya.>> Ɗa wu uta̱ka̱i le n Simiyon. ");
INSERT INTO asg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ɗa kagbashi ka ka ɗikai aza a̱ ni u uwakai a kpaꞋa. Ɗa u nekei le mini adama a na a saꞋa ene, ɗa kpamu u nekei njaki n le ilikulyaꞋa ");
INSERT INTO asg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ɗa u foɓusoi kuneꞋe ku le ku na e kuneke Isufu a gasa baci n kanna ka, adama a na a dana le ta̱ i ta̱ a kulyaꞋa ili n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ana Isufu u uwai a kpaꞋa ka ɗa a ɗikai kuneꞋe ku na i n kuɗa ɗa a̱ kuɗa̱ngi kelime ka̱ ni ɗa e nekei ni ku ɗa. ");
INSERT INTO asg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ɗa we ecei ma̱ta̱na̱ me le u danai, <<I yaꞋanka mu ta̱ kadanshi ko mokoshi me esheku a̱ ɗa̱, nini ɗai wi ɗe, u buwa ta̱ n wuma?>> ");
INSERT INTO asg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ɗa a̱ ushuki, <<Esheku a̱ tsu kagbashi ka̱ nu u buwa ta̱ n wuma wi ta̱ ɗe kpamu m ma̱ta̱na̱.>> Ɗa a̱ kuɗa̱ngi kelime ka̱ ni ɗa e nekei ni tsugbayin. ");
INSERT INTO asg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ana Isufu we enei vuza ni Bayami ɗa u danai, <<A̱yi na ɗa vangu vu ɗa̱ vi kenu, vuza na i yaꞋankai mu kadanshi ka? Ka̱shile ka zuwaka wu una̱singai maku ma̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ɗa Isufu u ɗa̱nga̱i fa̱ra̱ka̱ci adama a na ka̱ɗu ka̱ ni ka̱ ɗa̱nga̱ ta̱ adanshi u shika̱ a na we enei aza a̱ ni ɗa u uwai a̱ kunu ɗa u shika̱i. ");
INSERT INTO asg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ana u kotsoi ɗa u saꞋi a̱shi a̱ ni, ɗa u danai e pecuku ilikulyaꞋa ya. ");
INSERT INTO asg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","A zuwakai Isufu va tsuwaꞋa ci ni ubuta̱ u ni kau n aza a̱ ni, Aza a Masar a na i kulyaꞋa lo dem e le kpamu n ubuta̱ u le kau, adama a na ili yu unata u ɗa vuza va aza a Masar u lyaꞋa ilikulya n vuza va aza a Ibirahi. ");
INSERT INTO asg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ɗa a̱ da̱sa̱nki Isufu aza a̱ ni e kelime ka̱ ni, uteku u na umaci u le wi vuzagbayin a kubana u vuza kenu. ");
INSERT INTO asg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kirukpa ku na ki e kelime ka̱ Isufu a̱ ka̱na̱i kubanka ɗe n ilikulyaꞋa ama upecu u Bayami u laꞋa ta̱ wa̱ aza a̱ ni ali kutawun. Ɗa a lyaꞋi o soꞋi koɓolo n Isufu ɗa a panakai wuma u le uyoꞋo. ");
INSERT INTO asg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ɗa Isufu u danai kagbashi ka na ki a kinda kpaꞋa ku ni; <<Shatangu a̱ta̱nki e le tukpa-tukpa n utalu tsu na a kufuɗa kuɗika, ka̱ta̱ vu zuwaka yaba dem mokoko ma azanariya a̱ una̱ u ta̱nki u ni. ");
INSERT INTO asg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ka̱ta̱ vu zuwa mokoko ma azanariya a̱ ta̱nki vu vuza vu ukocishi vi le n ikebe ya punu.>> Ɗa u yaꞋin tsu na Isufu u danai ni. ");
INSERT INTO asg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kayin a kasa ɗa u uta̱ka̱i uma a ni njaki n le. ");
INSERT INTO asg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ana a lazai a bana daꞋin ka̱u ba, ɗa Isufu u danai kagbashi ka kpaꞋa ka̱ ni, <<YaꞋan gogoꞋo i tono uma a nanlo a, i cina le baci ka̱ta̱ ye ece le. <Yiɗa̱i i zuwai ɗa i tsupai kasingai n kawuya? ");
INSERT INTO asg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yiɗa̱i i zuwai ɗa i bokoi mokoko ma azanariya ma vuzagbayin vu va̱? Ma ɗa kpamu u ci yaꞋanka kutakpa ku uteku. Na va unushi u gbani-gbani u ɗa i yaꞋin.> >> ");
INSERT INTO asg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ana u cinai le ɗa u dansai derere tsu na a danai ni. ");
INSERT INTO asg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ɗa a̱ ushuki ni, <<Yiɗa̱i vi a kudana vuzagbayin? Ka̱shile ke jebeshe agbashi a̱ nu a yaꞋan ili tsu nanlo. ");
INSERT INTO asg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ikebe i na ci cinai a̱ a̱ta̱nki a̱ tsu tsu bonoko ta̱ i ɗa. Yiɗa̱i kpamu i kuzuwa ɗa tso kuboko mokoko ma azanariya ma vuzagbayin vu nu? ");
INSERT INTO asg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Vuzagbayin, a cina baci vuza te a̱ ka̱tsuma̱ ka̱ tsu m mokoko ma nanlo yaꞋan a una yi a̱ tsu vu na tsu buwai tsu okpo agbashi a̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ɗa vuma u danai, <<To u gaꞋan ta̱ wo okpo tsu na i danai ama vuza na a cinai mokoko ma wa̱ ni, a̱yi ɗa u kokpo kagbashi aza a na a buwai i ta̱ a kulaza.>> ");
INSERT INTO asg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ɗa ra̱ka̱ vi le a̱ cipa̱ka̱i n ucanuku wu njaki n le, ɗa a̱ ɓa̱yuwa̱sa̱i ucanuku u le. ");
INSERT INTO asg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ɗa u gita̱i u vuzagbayin a kubana u vuza kenu, ɗa a̱ ciya̱i mokoko ma a̱ ta̱nki vu Bayami. ");
INSERT INTO asg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ɗa nkoshi n ni dem a karai ntogu n le adama a una̱mgbi u ka̱tsuma̱, ɗa a̱ cipa̱ka̱i ucanuku wu njaki u le ɗa a lazai o kubono a̱ likuci. ");
INSERT INTO asg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ana Yahuda n aza a̱ ni a uwai a kpaꞋa ku Isufu ɗa a cinai ni punu, ɗa ra̱ka̱ vi le a̱ kuɗa̱ngi kelime ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ɗa Isufu u danai, <<Yiɗa̱i i zuwai ɗa i yaꞋin nahannai? I yeve ta̱ mpa vuma tsu va̱ mi ta̱ a kufuɗa me ke ece ɗa̱ a ubuta̱ u tsuboci u va̱?>> ");
INSERT INTO asg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","<<Yiɗa̱i tsa kudana wu vuzagbayin?>> Tsu na Yahuda wu ushuki, <<Nini ɗai tsa kunana? Ka̱shile kuta̱ka̱ ta̱ unushi u tsu e keteshe. Ra̱ka̱ vu tsu gogo na agbashi a̱ nu a ɗa ci, a̱ tsu n vuza na a cinai mokoko ma azanariya wa̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ɗa Isufu u danai, <<Ka̱shile ka takpaka mu n yaꞋan ili tsu nanlo! Vuza na a cinai mokoko ma wa̱ ni a̱yi ɗa u kokpo kagbashi ka̱ va̱. Aza a na a buwai i ta̱ a kufuɗa a laza i bana we esheku a̱ ɗa̱ m ma̱ta̱na̱.>> ");
INSERT INTO asg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ɗa Yahuda u banai u Isufu ɗa u danai, <<Vuzagbayin ka̱na̱ ka̱ɗu ka̱sukpa̱ mu n yaꞋan kadanshi n avu ba̱ri. YaꞋan wupa nu mpa ba; avu vi ta̱ tsu mogono a̱ ka̱ci ka̱ nu. ");
INSERT INTO asg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Vuzagbayin ve ece tsu ta̱, <Yi ta̱ n vuza ɗa̱ ko esheku a̱ ɗa̱?> ");
INSERT INTO asg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ɗa tsu ushuki, <Tsu buwa ta̱ lo m mokoshi me esheku a̱ tsu n vangu vu tsu kpamu vu na a matsakai ni a̱yi wana ɗai u kutsa. vuza vu ukocishi va mokoshi ma̱ ni ma̱ kuwa̱ ta̱ ɗe a̱yi ɗa wo okpoi koci n wuma a̱ ka̱tsuma̱ ka̱ muku ma̱ a̱na̱ku, esheku kpamu i ta̱ a kuciga yi n a̱bunda̱i.> ");
INSERT INTO asg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","<<Vuzagbayin ɗa vu danai tsu <Ta̱wa̱ n a̱yi adama a na n yeve yi. ");
INSERT INTO asg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Vuzagbayin tsu fuɗa ta̱ tsu dana wu maku ma ma kufuɗa wa̱ ka̱sukpa̱ esheku ba, u laza baci esheku a i ta̱ a̱ kukuwa̱.> ");
INSERT INTO asg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ɗa vu danai agbashi a̱ nu, <Sai i ta̱wa̱ n vuza vu ukocishi vu ɗa̱ ta baci nannai ba yi a̱ kuta̱wa̱ yo kudoku ye kene a̱shi a̱va̱ ba.> ");
INSERT INTO asg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ana tsu bonoi u kagbashi ka̱ nu esheku a̱ tsu ɗa tsu danai ni ili i na vu danai, ");
INSERT INTO asg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","<<Ɗa u suki tsu tsu doku tsu ta̱wa̱ tsu tsula utalu. ");
INSERT INTO asg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ama ɗa tsu danai, <Tsa kubana ba. Tsa kene a̱shi a̱ ni ba, sai tsu bana n vangu vu tsu.> ");
INSERT INTO asg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","<<Ɗa kagbashi ka̱ nu esheku a̱ tsu u danai, <I yeve ta̱ Rahila muku n re n ɗa u matsakai mu koci. ");
INSERT INTO asg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Vuza te vi le kpamu u ka̱sukpa̱ mu ta̱ ɗe, ɗa n danai, <<Mi ta̱ a kindana nnama n kakamba n wejeleshe yi ta̱ ɗe.>> N doku m me ene yi ba, n ayin a na u lazai. ");
INSERT INTO asg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","I ɗika baci a̱yi na gogo na ɗa ili i yoku i ciya̱i ni, una̱mgbi u ka̱tsuma̱ u na i kuzuwaka mu wi ta̱ a kufuɗa wa kuna mu, tsu na mi n tsukutsa na.> ");
INSERT INTO asg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","<<Vuzagbayin, adama a nannai mi a kufuɗa mo bono a̱ ubuta̱ u kagbashi ka̱ nu esheku a̱ va̱ babu maku ma ba. Dada wi ta̱ a kuciga maku ma tsu wuma u ni, ");
INSERT INTO asg_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","dada we ene mu baci babu maku ma, wi ta̱ a̱ kukuwa̱. A̱ tsu kpamu agbashi a̱ nu ci ta̱ o kusoku esheku a̱ tsu a kubana a̱ ubuta̱ wa̱ a̱kpisa̱ babu ma̱za̱nga̱. ");
INSERT INTO asg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nannai ɗa koci ba, mpa kagbashi ka̱ nu n kucinaka ta̱ dada n danai mi ta̱ a kindaka yi maku ma mayin. N danai ni, <M bono baci m maku ma ba, ka̱sukpa̱ mpasa n ni n tono mu ko wannai.> ");
INSERT INTO asg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","<<Adama a nannai mi ta̱ o kufolono wu vuzagbayin yaꞋan mo okpo kagbashi ka̱ nu una̱ u maku wa, ka̱ta̱ maku ma mo bono n aza a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nini ɗai n kubana u dada babu maku ma nanlo? Mi a kuciga me ene ili i gbani-gbani i na i kuciya̱ dada ba.>> ");
INSERT INTO asg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Isufu u doku u fuɗa u ka̱na̱ asuvu a̱ ni ba, lo e kelime ka aza a̱ ni, ɗa u ɓosoi ka̱da̱wuri, ɗa u danai, <<Yaba dem u neke tsu uye.>> A ayin a na Isufu u danai aza a̱ ni ko a̱yi ɗa ya uma o yoku i lo ba. ");
INSERT INTO asg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ka̱da̱wuri ka na u ɓosoi va ka yaꞋan ta̱ kacaꞋa ka̱u ali ɗa aza a Masar a panai, ɗa a ɗikai kadanshi ka a kubana u mogono FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ɗa Isufu u danai aza a̱ ni, <<Mpa ɗa Isufu. Dada u buwa ta̱ ɗe n wuma?>> Ana aza a̱ ni a panai nannai aɗa a panasakai wovon ka̱u a fuɗa o doku a dansa ili ba. ");
INSERT INTO asg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ɗa Isufu u danai aza a̱ ni a, <<Yawai wo ɗevu nu mpa.>> Ana a yawai, ɗa u danai le, <<Mpa ɗa vangu vu ɗa̱ Isufu, vuza na i dengei. Ɗa a ɗikai a kubanka Masar. ");
INSERT INTO asg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ama gogo na ka̱ta̱ i pana wovon ba. Ka̱ta̱ kpamu i pana wupa u ka̱ci ka̱ ɗa̱ ba, adama a na i dengei mu ta̱. Adama a na kpamu mi isa wuma i ɗa i zuwai ɗa Ka̱shile ka̱ suki mu na kelime ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Gogo na a̱ya̱ e re a ɗa na a na kambulu ka uwai a iɗika. Gogo na a kubana a̱ya̱ a tawun a kambulu ki ta̱ lo, adama a na vicimba vi lo ba. ");
INSERT INTO asg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ama Ka̱shile ka̱ suku mu ta̱ adama a na n lapula uye adama a wuma u ɗa̱ kpamu, ali nu ntsukaya n ɗa̱ dem. ");
INSERT INTO asg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","<<A̱ɗa̱ ɗa i zuwai n ta̱wa̱i na ba, ama Ka̱shile. U zuwa mu ta̱ mo okpoi vuza na u kuneke FiriꞋauna odoki, n vuzagbayin vu kpaꞋa ku ni ra̱ka̱ n gomuna vi iɗika i Masar ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","<<Gogo na, yaꞋin gogoꞋo a kubana we esheku a̱ tsu. I dana yi, <Ili i na Isufu, maku ma ni ma danai i ɗa na: Ka̱shile ko bonoko mu ta̱ vuzagbayin a Masar. Ta̱wa̱i na gogo na ka̱ta̱ i la̱nga̱sa̱ ayin ba. ");
INSERT INTO asg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Vi ta̱ kpamu o kuyongo a uɓon u Goshen a Masar i da̱sa̱ngi ɗevu nu mpa. Avu m muku n nu, nu ntsukaya n nu, nu nlala n ɗa̱ n ushiga dem n ili i na yi ni ɗa dem. ");
INSERT INTO asg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mi ta̱ kpamu e kuneke ɗa̱ ili dem. Adama a na a̱ya̱ a tawun a kambulu a buwa ta̱ lo a̱ kuta̱wa̱. Ta baci nannai ba, avu m muku n nu n ili i na i buwai dem, yi ta̱ o kokpo asuvayali.> ");
INSERT INTO asg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","<<Ɗa na ye ene ta̱ n a̱shi a̱ɗa̱, avu Bayami vangu vu va̱ ve ene ta̱ n ka̱ci ka̱ nu mpa ɗa Isufu va. ");
INSERT INTO asg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Vu bana baci vu dana dada uteku u na mi punu n utsura a iɗika ya, dana yi kpamu i na ve enei. Dakakai i bana i ta̱wa̱ n a̱yi gogoꞋo.>> ");
INSERT INTO asg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ɗa u foɗo aminya a̱ ni ɗa u yikpa̱i ɗa u shika̱i, ɗa Bayami wo oɓongi ni ɗa u ka̱na̱i ma̱shi feu. ");
INSERT INTO asg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ɗa wo oɓongi aza a̱ ni dem ɗa u ɗoroi ma̱shi kpamu. Ana o kotsoi ɗa aza a̱ ni a̱ ka̱na̱i kadanshi n a̱yi. ");
INSERT INTO asg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ana arabali a yawai u mogono Isufu aza a̱ ni a̱ ta̱wa̱ ta̱, ɗa FiriꞋauna aza ulinga a ni a yaꞋin ma̱za̱nga̱ ka̱u. ");
INSERT INTO asg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ɗa u danai Isufu, <<Dana aza a̱ nu a ɗika ucanuku u le ni njaki n le a laza o kubono a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ka̱sukpa̱ a bana a ɗika limata i le ya o kubono na Masar. Mi ta̱ e kuneke ubuta̱ u singai na a Masar i ta̱ kpamu a̱ kuciya̱ ili dem i na i kuyawa le. ");
INSERT INTO asg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Dana le kpamu a ɗika ekeke a anaka punu a iɗika i Masar adama a na a ɗikaka muku n le n wawaꞋa n a̱ma̱ci e le, i ɗika kpamu esheku a̱ ɗa̱ a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ka̱ta̱ o oꞋuso ka̱ci ke le kuɗika kuzuwa ku yoku ba, ama ili i singai yi iɗika i Masar yi ta̱ lo e kuneke le.>> ");
INSERT INTO asg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ta ta na muku mi Isaraila n yaꞋin nannai tsu na mogono ma ma danai le. A̱yi Isufu kpamu u nekei le keke va anaka tsu na mogono ma danai, n ilikulyaꞋa yi nwalu. ");
INSERT INTO asg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ra̱ka̱ vi le kpamu ɗa u nekei le ntogu n savu n singai, ama ɗa u nekei Bayami Azurufa amangatawun a tatsu n ntogu kpamu n tawun n tawun (500). ");
INSERT INTO asg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ɗa u suꞋuki n esheku ili i nampa, njaki kupa n na n ɗikai ucanuku u singai wa aza a Masar: n a̱na̱ku a njaki kupa a ɗikai ilikulyaꞋa m boroji n ili i na a kuwala n a lyaꞋi a uye. ");
INSERT INTO asg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ana wu tuka̱i le ɗa a lazai ɗa u danai le, <<Ka̱ta̱ i yaꞋan kanananai a uye ba.>> ");
INSERT INTO asg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ɗa a̱ ka̱sukpa̱i Masar ɗa a lazai a kubana we esheku e le a KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ɗa a danai, <<Isufu u buwa ta̱ n wuma! A̱yi ɗa kpamu wi ɗe a kulyaꞋa tsugono a iɗika i Masar dem>> A̱yi Yakubu u fuɗa u dana ili ba, adam a na we ene ta̱ adanshi mayun ɗa ba. ");
INSERT INTO asg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ana a danai ni ili i na Isufu u danai le, ana kpamu we enei ekeke a anaka a na Isufu u suki adama a na a ɗika yi a kubana a Masar, ɗa u ta̱na̱i a mɓa̱la̱ n na wi ishi nu n ɗa. ");
INSERT INTO asg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ɗa u danai, <<Maku ma̱ va̱ Isufu u buwa ta̱ n wuma? Mi ta̱ a kubana adam a na me ene yi kafu n kuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakubu u ɗikai ili i na wi n i ɗa ra̱ka̱ ɗa u lazai a kubana Biyasheba, ɗa u yaꞋin alyuka a kubana u Ka̱shile ke esheku a̱ ni Ishaku. ");
INSERT INTO asg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ka̱shile ka yaꞋin kadanshi n Yakubu a̱ ka̱tsuma̱ ka alatani n kayin u danai, <<Yakubu, Yakubu>> Wushuki, <<Mpa ɗa na.>> ");
INSERT INTO asg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ɗa u danai ni, <<Mpa ɗa Ka̱shile, Ka̱shile ke eshevu, ka̱ta̱ vu pana wovon u kubana a Masar ba, adama a na mi ta̱ o kubonoko wu ɗe iɗika i gbayin. ");
INSERT INTO asg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mi ta̱ a kubana ɗe a Masar koɓolo n avu, ka̱ta̱ n tuka̱ wu kpamu. A ayin a̱ ukpa̱ u nu kpamu ekiye a̱ Isufu a ɗaɗa a kupala a̱shi a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ɗa Yakubu u ka̱sukpa̱i Biyasheba. Muku n ni n zuwai ni, m muku n wawaꞋa n le, n a̱ma̱ci e le e keke va anaka vu na mogono ma Masar ma̱ suki a ɗikaka yi. ");
INSERT INTO asg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","A ɗikai ilikuzuwa i le koɓolo n uciyi u na a̱ ciya̱i a ayin a na i a KanaꞋana, ɗa Yakubu n i limata i ni ra̱ka̱ a banai a Masar va. ");
INSERT INTO asg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Muku n ni, m muku m muku n ni koɓolo n a̱yi, nkere n ni, ni nkere mi nkere n ni; limata i ni dem u banai n ele a Masar. ");
INSERT INTO asg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ele na ɗa ula a aza a Isaraila, Yakubu n limata i ni, aza a na a̱ ta̱wa̱i a Masar. Ruben, maku ma iyain ma Yakubu. ");
INSERT INTO asg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Muku mo olobo n Ruben: Enoku, Palu, Hezuron, n Kami. ");
INSERT INTO asg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Muku mo olobo n Simiyon ele ɗa: Jemuwelu, Jamin, Ohadu, Jaki, Zoha, n Shawu, maku ma na mekere ma KanaꞋana ma matsai ");
INSERT INTO asg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Muku mo olobo n Levi ele ɗa: Geshon, Kohatu, m Merari. ");
INSERT INTO asg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Muku mo olobo n Yahuda ele ɗa: Eri, Ona, Shela, Pereza, n Zera. Ama Eri n Ona a̱ kuwa̱ ta̱ a iɗika i KanaꞋana. Muku mo olobo n Pereza ele ɗa: Hezuron n Hamulu. ");
INSERT INTO asg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Muku mo olobo mi Isaka ele ɗa: Tola, Puwa, Jashubu, n Shimiron. ");
INSERT INTO asg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Muku mo olobo n Zabalun ele ɗa: Seredu, Elon, n Jalelu. ");
INSERT INTO asg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ele na ɗa muku n Liyatu n na u matsakai Yakubu a Fada-aram, koɓolo m mekere ma̱ ni Dina. Muku n ni ra̱ka̱ olobo ni nkere i ta̱ uma kamangankupa n aza a tatsu. ");
INSERT INTO asg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Muku mo olobo n Gadu ele ɗa: Zifiyon, Hagi, Shuni, Ezibon, Eri, Arodu, n Areli. ");
INSERT INTO asg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Muku mo olobo n Ashera ele ɗa: Imuna, Ishiva, Ishivi, m Beriya. Taku vi le mekere a̱yi ɗa Shera. Muku mo olobo m Beriya ele ɗa: Heberu m Malikiyelu. ");
INSERT INTO asg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ele na ɗa muku n na Zilifa u matsakai Yakubu. Zilifa a̱yi ɗa maku mu usuki ma na Laban u nekei mekere ma̱ ni Liyatu a ayin o yolo a̱ ni. Muku n ni ra̱ka̱ ele ɗa uma kupa n aza a̱ ta̱li. ");
INSERT INTO asg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Muku n Rahila vuka vi Yakubu ele ɗa Isufu m Bayami. ");
INSERT INTO asg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Muku n Isufu n na a matsakai ni a iɗika i Masar ele ɗa Manasa n Ifirayimu. A̱na̱ku e le a ɗa Asenatu mekere ma Potifera, ganu vu Onu. ");
INSERT INTO asg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Muku mo olobo m Bayami ele ɗa: Bela, Beka, Ashibelu, Gera, NaꞋama, Ehi, Roshi, Mupim, Hupim, n Arudu. ");
INSERT INTO asg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Muku kupa n aza a̱ na̱shi a nampa ntsukaya n Yakubu n ɗa n na Rahila u matsakai ni. ");
INSERT INTO asg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Maku ma Dan a̱yi ɗa Hushim. ");
INSERT INTO asg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Muku mo olobo n Nafutali ele ɗa: Jazilu, Guni, Jeza, n Shilema. ");
INSERT INTO asg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Muku mo olobo m Biliha vu na Laban u nekei mekere ma̱ ni Rahila u matsakai Yakubu ele ɗa uma e cindere. ");
INSERT INTO asg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Uma a Yakubu ra̱ka̱ a na a̱ ta̱wa̱i a Masar, aza a na i limata i ni, babu punu a̱ma̱ci a̱ muku n ni, ele ɗa uma amangatatsu n uma a̱ ta̱li. ");
INSERT INTO asg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Muku n Isufu, n na a matsakai ni a Masar, n re n ɗa koci; uma a kpaꞋa ku Isufu a na a̱ ta̱wa̱i a Masar gbende i ta̱ uma amangatatsu n kupa. ");
INSERT INTO asg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakubu u suki Yahuda u walaka yi kelime ciya̱ u dana Isufu u cina le a Goshen. Ana a yawai, ");
INSERT INTO asg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Isufu u kumbai keke va anaka a̱ ni ɗa u lazai a kubana Goshen adama a na u gasa n esheku. Ana a gasai ɗa Isufu wo oɓongi esheku n ekiye e kuɗeku, ɗa u shika̱i ali megeshe. ");
INSERT INTO asg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ɗa Yakubu u danai Isufu, <<Mi ta̱ a kufuɗa kukuwa̱ gogo na, a na me enei nu n wuma n a̱shi a̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Isufu u danai vuza ni n aza a kpaꞋa ke esheku a̱ ni a na a buwai, <<Mi ta̱ a kubana ma dana FiriꞋauna, n dana yi, <Aza a̱ va̱ n aza a kpaꞋa ke esheku a̱ va̱, ele na i a iɗika i KanaꞋana, a̱ ta̱wa̱ ta̱ wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Uma a nguɓi n ɗa, ele nguɓi n ɗa mi ilikuzuwa, a̱ ta̱wa̱ ta̱ n ushiga wu nlala koɓolo n wa anaka e le, n ili i na i n i ɗa dem.> ");
INSERT INTO asg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ayin a na baci FiriꞋauna u ɗekei ɗa̱ ɗa we ecei, <Yiɗa̱i ulinga u ɗa̱?> ");
INSERT INTO asg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","I dana, <Agbashi a̱ nu nguɓi mi ilikuzuwa i ɗa ali a̱ tsu biꞋi muku ali ta na gogo na, tsu na ikaya i nu i yaꞋansai.> Nannai ɗa u kuka̱sukpa̱ wu vi yongo a uɓon u Goshen, adama a na aza a Masar i ta̱ e kene nguɓi ili yi unata.>> ");
INSERT INTO asg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Isufu u banai u danai FiriꞋauna, <<Aza a̱ va̱ n esheku a̱ va̱, n ushiga wu nlala u le n wa anaka koɓolo n ili i na i n i ɗa dem, uta̱i a iɗika i KanaꞋana; gogo na i ta̱ a iɗika i Goshen.>> ");
INSERT INTO asg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","U ɗikai aza a̱ ni uma a tawun ɗa u bankai le e kelime ka FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","FiriꞋauna we ecei uma a, <<Yiɗa̱i ulinga u ɗa̱?>> Ɗa a danai FiriꞋauna, <<Agbashi a̱ nu nguɓi n ɗa, tsu na ikaya i tsu ishi.>> ");
INSERT INTO asg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","O doku a danai FiriꞋauna, <<Tsu ta̱wa̱ ta̱ kuyongo na adama a na kambulu ka gbayin ka̱ yikpa̱ ta̱ a iɗika i KanaꞋana, babu ilikulya adama a kuzuwa ka agbashi a̱ nu. Gogo na tsu folono wu ta̱, ka̱sukpa̱ agbashi a̱ nu a̱ da̱sa̱ngu a iɗika i Goshen.>> ");
INSERT INTO asg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ɗaɗa FiriꞋauna u danai Isufu, <<Eshevu n aza a̱ nu a̱ ta̱wa̱ ta̱ wa̱ nu. ");
INSERT INTO asg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Iɗika i Masar yi ta̱ e ekiye a̱ nu; zuwa eshevu n aza a̱ nu a uɓon u na u laꞋi n ugaꞋin a iɗika ya, ka̱sukpa̱ le o yongo punu a iɗika i Goshen. Vi yeve baci i ta̱ punu n aza a utsura a̱ ka̱tsuma̱ ke le, zuwa le a inda ilikuzuwa i va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ɗa Isufu u tuka̱i n esheku a̱ ni Yakubu ɗa u bankai ni a̱ ubuta̱ u FiriꞋauna, ɗa Yakubu u zuwakai FiriꞋauna una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","FiriꞋauna we ecei Yakubu, <<A̱ya̱ a yaꞋin a ɗai nu?>> ");
INSERT INTO asg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ɗa Yakubu u danai FiriꞋauna, <<A̱ya̱ a̱ va̱ a aduniyan i ta̱ amangatawun n kamangankupa (130). A̱ya̱ a̱ va̱ kenu ɗa a ɗa yi n atakaci kpamu, i kugisangu n a̱ya̱ a aduniyan a̱ a̱bunda̱i a ikaya i va̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakubu u zuwakai FiriꞋauna una̱singai, ɗa u lazai lo a̱ ubuta̱ u FiriꞋauna wa. ");
INSERT INTO asg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Isufu u zuwai esheku a̱ ni n aza a̱ ni lo, ɗa u nekei le ubuta̱ wu ida̱shi u singai punu a iɗika i Masar, a uɓon u Ramase, tsu na FiriꞋauna u danai. ");
INSERT INTO asg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Isufu u ciya̱ka̱i esheku, aza a̱ ni, koɓolo n aza a kpaꞋa ke esheku ra̱ka̱ ilikulya, tsu na ka̱bunda̱i ki limata i le ki. ");
INSERT INTO asg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Gogo na a iɗika ya ra̱ka̱ tsuwa ci ishi lo ba, adama a na kambulu ka ko gbonguro ta̱. Iɗika i Masar koɓolo n iɗika i KanaꞋana i na̱mgba̱i adama a kambulu ka. ");
INSERT INTO asg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Uma a KanaꞋana koɓolo n uma a Masar a unai ikebe i le a̱ ubuta̱ u kutsula ilikulya e ekiye a̱ Isufu. Ɗa Isufu wi isai ikebe i nanlo ra̱ka̱ u bankai i ɗa a kpaꞋa ku FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ana a unai ikebe yi iɗika i Masar koɓolo n iɗika i KanaꞋana, aza a Masar ra̱ka̱ a̱ ta̱wa̱i u Isufu ɗa a danai, <<Neke tsu ilikulya! Nini ɗai tsa kukuwa̱ avu e kene? Ikebe i tsu i kotso ta̱?>> ");
INSERT INTO asg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ɗa Isufu u wu ushuki, <<Ikebe i ɗa̱ i kotso baci, nekei mu ilikuzuwa i ɗa̱, ka̱ta̱ n yaꞋanka ɗa̱ kasabaꞋa ki ilikulya n ilikuzuwa ya.>> ");
INSERT INTO asg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ɗaɗa a̱ tuka̱i n ilikuzuwa i le u Isufu; ɗa Isufu u sabaꞋakai le ilikulya ya n odoku, ushiga wu nlala, wa anaka, koɓolo ni njaki. A̱ ka̱ya̱ ka nanlo a̱ ciya̱ka̱i le ilikulya i na a sabaꞋi n ilikuzuwa i le ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ana ka̱ya̱ ka nanlo ka lazai, a̱ ta̱wa̱i kpamu wa̱ ni ka̱ya̱ ke ire, a danai ni, <<Ci o kusokonku vuzagbayin vu va̱ a na tsu unai ikebe i tsu ra̱ka̱ ba, ushiga wa anaka u vuzagbayin vu va̱ u ɗa. Babu ili i na i buwai tsu sai ikyamba i tsu n iɗika i tsu, vuzagbayin vu va̱. ");
INSERT INTO asg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nini ɗai tsa̱ kukuwa̱ gbani avu e kene n ashina a̱ tsu feu? Tsula tsu n ashina a̱ tsu vu sabaꞋa n ilikulya. A̱ tsu n ashina a̱ tsu ci ta̱ o kokpo agbashi a FiriꞋauna; neke icuꞋu de koci adama a na tsu kuwa̱ ba, ka̱ta̱ iɗika i tsu i na̱mgba̱ gbani ba.>> ");
INSERT INTO asg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ɗa Isufu u tsulakai mogono iɗika kakau i na yi a Masar ra̱ka̱. A gutsakai yaba dem a Masar u denge uɓon wi iɗika i ni, adama a na kambulu ka ko gbonguro ta̱, ɗa iɗika kakau i nanlo yo okpoi iɗika i mogono ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Isufu u bonokoi uma a agbashi ili i na i ɗikai a uteku u nampa sai a kubana uteku u nan ɗe u Masar. ");
INSERT INTO asg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Uɓon wi iɗika u na u kpa̱ɗa̱i kutsula koci, ɗaɗa uɓon wi iɗika u na wi u anan ganu. Ele sai e denge uɓon wi iɗika u le ba, adama a na mogono me ci neke le ta̱ ili i na a ci lyaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Isufu u danai uma a, <<Ana wi gogo na n tsula ɗa̱ ta̱ n iɗika i ɗa̱ dem n nekei FiriꞋauna, icuꞋu i ɗa na; ca̱Ꞌi a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ayin a vikyaꞋa a yawa baci ka̱ta̱ i neke FiriꞋauna ili i te a̱ ka̱tsuma̱ ki i tawun, ka̱ta̱ i na̱shi a̱ ka̱tsuma̱ ki i tawun yo okpo i ɗa̱ adama a na i ciya̱ punu i na i kuca̱Ꞌa̱, i na i kulyaꞋa, koɓolo n iꞋuwa i ɗa̱, n limata i wawaꞋa i ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ɗa a danai, <<Vi isa ta̱ wuma u tsu, yaꞋan ili yo okpo tsu na vu danai, vuzagbayin, ci ta̱ o kokpo agbashi a FiriꞋauna.>> ");
INSERT INTO asg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Isufu u bonokoi ukuna wu iɗika i Masar ya ili i wila̱, ali ta na a̱ kuta̱wa̱ anana ta i ɗa yi nannai. I te a̱ ka̱tsuma̱ ki i tawun ili i kashina i FiriꞋauna i ɗa. Ashina a anan ganu a ɗa koci o kokpo a FiriꞋauna ba. ");
INSERT INTO asg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ta nannai ɗa aza a Isaraila a̱ da̱sa̱ngi a iɗika i Masar a uɓon u Goshen. A̱ ciya̱i uciyi a̱ ubuta̱ wa ɗe, a matsai ka̱u ali ɗa a yimkpai. ");
INSERT INTO asg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakubu u yongoi a iɗika i Masar ali a̱ya̱ kupa n e cindere, a̱ya̱ a Yakubu a wuma a̱ ni a ɗaɗa amangatawun n amangere n e cindere, (147). ");
INSERT INTO asg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ana ayin a̱ ukpa̱ a̱ ni i a kuyawa, u ɗekei maku ma̱ ni Isufu ɗa u danai ni, <<Vu pana baci uyo nu mpa, zuwa kukiye ku nu a̱ nkuta̱ n va̱ vu kucina mayun mi ta̱ a̱ kushuku ko yi ɗa̱i. Ufolu u ire u ɗaɗa dana mu ka̱ta̱ vi kucina kpamu vi a̱ kuciɗa̱ngu mu a iɗika i Masar ba. ");
INSERT INTO asg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ayin a na baci n kuwa̱i, ɗika mu vu uta̱ka̱ mu punu a Masar ka̱ta̱ vu bana vi ciɗa̱ngu mu a̱ ubuta̱ u ka̱ciɗa̱ u le.>> Wushuki, <<Mi ta̱ a kuyaꞋan ili i na vu danai.>> ");
INSERT INTO asg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ɗa u danai kpamu, <<Kucinaka mu,>> ɗa ta na u kucinakai ni. Ɗa Isaraila u kuɗa̱ngi u za̱lika̱i kaci a uɓon u kaci u kajiba u ni. ");
INSERT INTO asg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","A ayin o yoku a danai Isufu esheku i ta̱ ɗe nu mbanaki, ɗa u pura̱i muku n ni n re Manasa n Ifirayimu ɗa u banai ɗe. ");
INSERT INTO asg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ana a danai Yakubu, <<Maku ma̱ nu Isufu ma̱ ta̱wa̱ ta̱ kene wu.>> Ɗa Yakubu u ɗa̱nga̱i ɗa u da̱sa̱ngi a kajiba ka̱ ni ama dikyai. ");
INSERT INTO asg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ana o kotsoi ikya̱shi, ɗa Yakubu u danai Isufu, <<Ka̱shile MalaꞋimili ra̱ka̱ u yotsongu ta̱ ka̱ci ka̱ ni a̱ Luzu a iɗika i KanaꞋana ɗa kpamu u zuwakai mu una̱singai. ");
INSERT INTO asg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ɗa u danai mu, <Mi ta̱ e kuneke wu muku n a̱bunda̱i adama a na ntsukaya n nu mo okpo umaci n neke kpamu iɗika i nampa yo okpo i le ko wannai.> ");
INSERT INTO asg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ɗa Yakubu u lyaꞋi kelime u danai, Isufu muku n nu n na vu matsai Masar kafu n ta̱wa̱ okpo ta̱ n va̱, Ifirayimu Manasa mokpo ta̱ aza a̱ va̱ tsu na Ruben n Simiyon i vu va̱. ");
INSERT INTO asg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Muku n na baci a matsai a̱ kucina̱ ku le n nu n ɗa; ili yi uka̱ni i na baci de dem a̱ ciya̱i i ta̱ a̱ kuciya̱ i ɗa a̱ ubuta̱ wi Ifirayimu m Manasa. ");
INSERT INTO asg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ana mu uta̱i Pada-aram ɗa Rahila u kuwa̱i a iɗika i KanaꞋana, ɗa u ka̱sukpa̱i mu n una̱mgbi u ka̱tsuma̱ ali babu na ci yawa Efarata, ɗa n ciɗa̱ngi ni lo a uye u Efarata>> (ɗaɗa feu Batalami). ");
INSERT INTO asg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ana Yakubu we enei muku n Isufu ɗa u danai, <<Ana yayi olobo a nan ɗe?>> ");
INSERT INTO asg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ɗa Isufu wu ushuki, <<Na va ɗa muku n ali n na Ka̱shile ke nekei mu punu na.>> Ɗa Yakubu u danai, <<Tuka̱ le na wa̱ va̱ adama ana n zuwaka le una̱singai.>> ");
INSERT INTO asg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Gogo na a̱shi a Isaraila a̱ gita̱ ta̱ kuyimba̱na̱ adama a tsukutsa. Ɗa Isufu u bankai le ɗevu n a̱yi. Ɗa Isaraila wo oɓongi le ɗa u papurasai le. ");
INSERT INTO asg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ɗa Isaraila u danai Isufu, <<N yeve a na mi o kudoku kene wu ba. Ɗa ta na Ka̱shile ka zuwai me enei a̱shi a̱ nu ali m muku n nu.>> ");
INSERT INTO asg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ɗa Isufu u ɗikai le a nkuta̱ me esheku ɗa u kuɗa̱ngi ɗa u lyaꞋi kayala lo e kelime ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ɗa Isufu u ɗikai aza e re dem, ɗa u zuwai Ifirayimu e kukiye ku usingai ku ni e kukiye ku ugula̱ kpamu ɗa u zuwai vuza kenu. Ɗa u zuwai Manasa a̱ ugula̱ u ni ɗa u bankai le wi Isaraila. ");
INSERT INTO asg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ɗa Yakubu u pasamgbanai ekiye a̱ ni, u zuwakai kukiye ku usingai a kaci ka vuza kenu Ifirayimu, ugula̱ kpamu a kaci ka Manasa. ");
INSERT INTO asg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ɗa u zuwakai Isufu una̱singai ɗa u danai, <<Ka̱shile ka na Ikaya i va̱ Ibirahi n Ishaku o tonoi, Ka̱shile ka na kpamu kokpoi maguɓi ma̱ va̱ a wuma u va̱ ali a̱ kuta̱wa̱ anana, ");
INSERT INTO asg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","kalingata ka na ki isai mu, a̱ ubuta̱ u uma a gbani-gbani u zuwaka olobo a nampa una̱singai. Ka̱sukpa̱ e ɗeke le n kula ku va̱, n kula ku ikaya i va̱ Ibirahi n Ishaku. YaꞋan a lyaꞋa kelime n kumatsa n a̱bunda̱i a yimkpa a aduniyan.>> ");
INSERT INTO asg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ana Isufu we enei esheku a a zuwa ta̱ kukiye ku usingai ku ni a kaci ka Ifirayimu, ka̱ɗu ka̱ ni ka ciga ba, ɗa u takpai kukiye ku ni a kaci ka Ifirayimu u zuwai ku ɗa u Manasa. ");
INSERT INTO asg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ɗa Isufu u danai esheku a̱ ni, <<Ta nannai ba dada! A̱yi ɗa magaji. Zuwa kukiye ku usingai ku nu a kaci ka̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ama ɗa esheku a a iwain ɗa a danai, <<N yeve ta̱ maku ma̱ va̱. A̱yi ɗa u kokpo esheku a uma n a̱bunda̱i, wi ta̱ kokpo vuma vu gbayin. Ko n nannai ntsukaya n vangu ma mi ta̱ a kulaꞋa n a̱bunda̱i, ntsukaya n ni kpamu mi ta̱ o kopko kumaci n a̱bunda̱i.>> ");
INSERT INTO asg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ta Isaraila u zuwakai le una̱singai a kanna ka nanlo n u danai, <<N kula ku nu ku ɗa aza a Isaraila a kuyaꞋan kadanshi ku una̱singai u nampa, i ta̱ a kudana, <Ka̱sukpa̱ Ka̱shile ka zuwa ɗa̱ yo okpo tsu Ifirayimu m Manasa.> >> Ta u zuwai Ifirayimu e kelime ka Manasa nannai. ");
INSERT INTO asg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ɗa Isaraila u danai Isufu, <<Mpa ɗa na n yaꞋan ta̱ ɗevu n ukpa̱, ama Ka̱shile ki ta̱ o kuyongo n avu, wi ta̱ kpamu o kubonoko wu a iɗika yi ikaya i nu. ");
INSERT INTO asg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mpa mi ta̱ e kuneke wu uɓon u Shekem, ugboku u te u na u laꞋi wa aza a̱ nu, ubuta̱ u na mi isai a ekiye aza Amoriya n kotokobi ka ikaya i va̱.>> ");
INSERT INTO asg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ɗa Yakubu u ɗekei muku n ni ɗa u danai, <<Ɓolongi na, ka̱ta̱ n dana ɗa̱ i na i kuciya̱ ɗa̱ a ayin a na a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","<<Ɓolongi ka̱ta̱ i pana, a̱ɗa̱ muku n Yakubu, Panakai esheku a̱ ɗa̱ Isaraila. ");
INSERT INTO asg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","<<Ruben avu ɗa magaji ma̱ va̱, utsura u na wi urotu wu utsura u va̱ n tsugbayin tsa̱ a̱miki, koɓolo n utsura kpamu. ");
INSERT INTO asg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Vu tsu ka̱na̱ kaci ba, vi ta̱ an mala, vo kudoku vo kokpo vuza gbayin kpamu ba. Adama a na vu goyo ta̱ kajiba ke eshevu, vu ukai kaꞋa unata. ");
INSERT INTO asg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","<<Simiyon n Levi vuza ɗa n vuza ni, otokobi e le ucanuku u vishili u ɗa. ");
INSERT INTO asg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Wuma u va̱ ka̱ta̱ vu uwa e kusheshe ku le ba ka̱ta̱ n uwa o kuyongo ku le ba, adama a na ele una ta̱ uma n wupa u le, usuɗukpi wa̱ a̱ɗu e le u zuwai le a unai aza utsura. ");
INSERT INTO asg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","O okpo wasasa adama a wupa u le, wupa u le u na̱mgba̱ ta̱ ka̱u ta u kupece le nannai a iɗika yi Isaraila. ");
INSERT INTO asg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","<<Avu Yahuda aza a̱ nu i ta̱ a kucikpa wu. Kukiye ku nu ki ta̱ a̱ kuka̱na̱ irala i nu. Muku mo olobo me eshevu mi ta̱ a̱ kukuɗa̱nku wu. ");
INSERT INTO asg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Avu Yahuda kawu ɗa vi, maku ma̱ va̱ vu unai manama ɗa vu bonoi a kakagu, vu vaku vu ba̱rukpa̱i tsu kawu, tsu kawu babu vuza na u koꞋuso wu. ");
INSERT INTO asg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Avu Yahuda tsugono tsa̱ kuka̱sukpa̱ kpaꞋa ku nu ba, ko kalangu ko tsugono ka̱ kuka̱sukpa̱ ntsukaya n nu ba, ali ayin a na vuza na u gaꞋin u ta̱wa̱ u yawa, ka̱ta̱ aduniyan dem o okpo a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wi ta̱ a kushiya majaki ma̱ ni a maɗanga mi itacishi. U shiya maꞋa a kacaka ka na ka laꞋi n kugaꞋan, ka̱ta̱ u za̱Ꞌa̱ ntogu n ni m mini mu umaci wu nɗanga, u za̱Ꞌa̱ kashiyatsu ka̱ ni feu n umaci u na u shilyamgbai. ");
INSERT INTO asg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A̱shi a̱ ni i ta̱ a kulaꞋa ma̱ra̱ ushili, ka̱ta̱ anga a̱ ni a laꞋa mani wa̱ri. ");
INSERT INTO asg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","<<Avu Zabalun, a̱ ka̱kina̱ ka̱ mini kaꞋa va̱ kuda̱sa̱ngu, vo okpo ubuta̱ u kuzuwa antsu uteku u ni wi ta̱ a kuyawa ali a kubana uɓon u Sidon. ");
INSERT INTO asg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","<<Avu Isaka majaki maꞋa mu utsura, vi ta̱ ivaꞋin e mere ma mbana mu ucanuku. ");
INSERT INTO asg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","We ene ta̱ ubuta̱ u kuvuka u gaꞋan ta̱, iɗika i ni yi ta̱ n uyoꞋo wi ida̱shi; ɗa u kuɗa̱ngi adama a na u zuwaka avangatsu a̱ ni ucanuku, wo okpoi kagbashi ku ulinga. ");
INSERT INTO asg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","<<Dan wi ta̱ o kokpo mogono ma̱ aza ni. Tsu umaci u yoku a Isaraila. ");
INSERT INTO asg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wi ta̱ an koko ka na ka shamgbai ɗevu n uye, koko ko tsukono paki n uye, ka na ka tsu kapa kodoku a̱ ka̱civa̱ adama a na kakumbi ka̱ ni ka̱ yikpa̱ melene. ");
INSERT INTO asg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Mi ta̱ a kuvana wishi u nu Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","<<Avu Gadu aza a̱ ma̱ga̱la̱ka̱ i ta̱ a kubana a̱ shilika̱ n avu, ama a̱yi feu wi ta̱ a kutsupa le. ");
INSERT INTO asg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","<<Avu Ashera vi ta̱ o kokpo vuza vu uciyi n a̱bunda̱i, ali vu neꞋe ngono ilikulyaꞋa. ");
INSERT INTO asg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","<<Avu Nafutali vi ta̱ a na mereꞋe ma na a̱ ka̱sukpa̱i ba̱ri ma na ma matsai muku n singai. ");
INSERT INTO asg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","<<Avu Isufu avu ɗa maku ma̱ va̱ ma na ma tsu matsa muku, a na uyaꞋan u na wi ɗevu n kuyene ka̱ta̱ u tatsa u kumba mashilya ali u matsa ba̱ri. ");
INSERT INTO asg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Atain a bankai ni n vishili, a tawai ni magaba. ");
INSERT INTO asg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ama utan u ni u shamgbai n utsura gbam-gbam, ɗa ekiye a̱ ni a̱ ciya̱i katsura, adama e kukiye ku utsura ku Ka̱shile ka Yakubu. N adama a Maguɓi mi Isaraila, ");
INSERT INTO asg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ka̱shile ke eshevu kaꞋa vuza na u ɓa̱nka̱i nu Ka̱shile Uba̱nga̱ri vuza na u zuwakai nu una̱singai, una̱singai u mini ma gaɗi, koɓolo m mini n a̱bunda̱i ma na mi punu iɗika, una̱singai wi ilikuzuwa m muku n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Una̱singai we eshevu u laꞋa ta̱ una̱singai wu nsasan u na mi ko wannai, u laꞋi kpamu tsuloboi tsu nsasan n ko wannai. YaꞋan ili i nampa i yongo u Isufu, a̱ kuca̱n ku vuza na a zagbai a ka̱tsuma̱ ka̱ aza ni. ");
INSERT INTO asg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","<<Bayami vi ta̱ tsu kanama ka na ki n kambulu n a̱bunda̱i. N usana vi ta̱ n kutsa̱n ka̱ta̱ vu tamba inyama, n kulivi vu tsu pece ta̱ i na vi ciya̱i gbani.>> ");
INSERT INTO asg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Na va ɗaɗa muku kupa nu nre wu umaci wi Isaraila, ili i na esheku e le a danai le i ɗa na a ayin a na u zuwakai le una̱singai, u zuwakai yaba dem vi le una̱singai tsu na u gaꞋin. ");
INSERT INTO asg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ɗa Yakubu u nekei le kadanshi ka nampa u danai, <<Gogo na mi ta̱ a kuciga ma bana ma cina ikaya i va̱. Ciɗa̱ngi mu n ikaya i va̱ a aɓatsu a̱ uba̱nga̱ u Iforono ka vuza vu Hitiya, ");
INSERT INTO asg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","a kaɓatsu a̱ ka̱ba̱nga̱ ka Makapele, ɗevu m Mamure a iɗika i KanaꞋana. Ubuta̱ u na Ibirahi u tsulai a Iforono a̱ ubuta̱ u ka̱ciɗa̱ u ka vuza vu Hitiya. ");
INSERT INTO asg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ta ɗe a̱ ciɗa̱ngi Ibirahi n vuka vi ni Saratu, ta ɗe a̱ ciɗa̱ngi kpamu Ishaku n Rebeka, ta ɗe kpamu n ciɗa̱ngi Liyatu. ");
INSERT INTO asg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ciɗa̱ngi mu a kaɓatsu ka na ki a̱ ubuta̱ u na a tsulai wa aza a Hitiya.>> ");
INSERT INTO asg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ana Yakubu u kotsoi kuneke muku n ni kadanshi, ɗa u doku u vakushiki a ivaꞋantsu i ni, ɗa u yivikai ayinviki a ukocishi a̱ ni, u banai a̱ ubuta̱ wi ikaya i ni. ");
INSERT INTO asg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Isufu u yikpa̱i e keven ki ikyamba ye esheku ɗa wo oɓongi kaꞋa ɗa u ka̱na̱i ma̱shi. ");
INSERT INTO asg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ɗa Isufu u yaꞋin kadanshi n aza ulinga wa̱ a̱guma̱ a lapula keven ke esheku, ta lo ka kushama. ");
INSERT INTO asg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ɗa keven ka ka yaꞋin ayin amangere (40), adama a na ta a̱guma̱ aza a Masar a̱ kusa̱nka̱ ili kushama i nannai. Ɗa a yaꞋin kpalu ku ni ali ayin amangatatsunkupa (70). ");
INSERT INTO asg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","A ayin a na ayin a̱ ma̱shi a shanai, ɗa Isufu u danai kpaꞋa ku mogono ma FiriꞋauna, <<YaꞋankai mu ili i singai i nampa i danaka mu FiriꞋauna adama e esheku a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","<Kafu esheku a̱ va̱ a̱ kuwa̱ u folono mu ta̱ n yaꞋanka yi uzuwakpani, mi ta̱ a kubana kuciɗa̱ngu yi a kasaun ka na u foɓusoi na ɗe a iɗika i KanaꞋana. Mi ta̱ ufolu u nu ka̱sukpa̱ mu m bana n ciɗa̱ngu esheku a̱ va̱ ka̱ta̱ m bono.> >> ");
INSERT INTO asg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ɗa mogono mu ushuki, <<Wala vu bana vi ciɗa̱ngu eshevu tsu na vi yaꞋankai ni uzuwakpani.>> ");
INSERT INTO asg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ɗa Isufu u lazai adama a na u bana u ciɗa̱ngu esheku. Ayin a na u banai ɗa aza a̱ gba̱ra̱-gba̱ra̱ a FiriꞋauna m Masar o soki ni, ");
INSERT INTO asg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","n aza a kpaꞋa a̱ ni n aza ni dem a bansai. Sai muku n kuzuwa ku le ku ɗa a̱ ka̱sukpa̱i ɗe o Goshen. ");
INSERT INTO asg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Aza o yoku a kumbai keke va anaka, aza o yoku odoku ɗa a banai ɗe koɓolo, uma n a̱bunda̱i ɗa a banai. ");
INSERT INTO asg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ana a yawai a ulanga u kulapa utalu u Ata a kasana n Kuyene ku Urudu ɗa a̱ shika̱i lo ka̱u. Ɗa a yaꞋin lo ayin e cindere a kuyaꞋan kpalu ke esheku a̱ Isufu. ");
INSERT INTO asg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","A ayin a na aza a KanaꞋana e enei tsu na a yaꞋin kpalu ka a̱ ubuta̱ u kulapa utalu u Ata, ɗa a danai, <<Kpalu ku nampa ku suɗukpa ta̱ ka̱u a̱ ubuta̱ wa aza a Masar.>> Adama a nannai ɗa e neꞋi kula ku ubuta̱ wa, Ebelu-mizarim, ɗaɗa kpalu ka aza a Masar. Ta ɗe wi a upashi u Urudu. ");
INSERT INTO asg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ɗa muku n ali n Yakubu n yaꞋankai esheku e le i na u danai le a yaꞋan ");
INSERT INTO asg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","A ɗikai keven ki ikyamba ka̱ ni ɗa a̱ ciɗa̱ngi kaꞋa a ubuta̱ wa asaun a Makapele a kasana ka Mamure a̱ ka̱ba̱nga̱ ka̱ ka̱ciɗa̱ ka na Ibirahi u tsulai a ekiye a Ifirayimu vuza va aza a Hitiya ");
INSERT INTO asg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ana Isufu u kotsoi ka̱ciɗa̱ ke esheku ɗa u lazai o kubono a Masar n aza a̱ ni dem n aza a na o tonoi ni a kubana a̱ ubuta̱ u ka̱ciɗa̱ wa. ");
INSERT INTO asg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ana esheku e le a̱ kuwa̱i, ɗa Isufu nu nkoshi n ni n danai, <<Gogo na Isufu u dana baci yaꞋan u tsupa kawuya ka na ci yaꞋankai ni?>> ");
INSERT INTO asg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ɗa a̱ suꞋuki Isufu n kadanshi a danai, <<Kafu esheku a̱ tsu a̱ kuwa̱ u dana ta̱, ");
INSERT INTO asg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ci ece wu, <Cinukpa n unushi u na aza a̱ nu a yaꞋankai nu tsu na cau a takacikai nu.> Gogo na reme ka̱ɗu cinukpaka tsu unushi u na a̱ tsu agbashi a̱ Ka̱shile ke eshevu ci yaꞋankai nu.>> Isufu u shika̱i ka̱u ana u panai kadanshi ka nampa. ");
INSERT INTO asg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ɗa aza a̱ ni a banai ɗa a̱ kuɗa̱ngi kelime ka̱ ni ɗa a danai, <<A̱ tsu ɗa na kelime ka̱ nu agbashi a̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ama ɗa Isufu u danai, <<Panai wovon ba! Mpa Ka̱shile kaꞋa? ");
INSERT INTO asg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ko a na i sheshekei mu kawuya, ama Ka̱shile ko bonoko ta̱ kaꞋa ka singai, adama a na wi isa wuma wa aza a̱bunda̱i a na yi e kene anana. ");
INSERT INTO asg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Adama a nannai ka̱ta̱ i pana wovon ba. Mi ta̱ a kinda ɗa̱ m muku n ɗa̱,>> ");
INSERT INTO asg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ta ɗe Isufu m kpaꞋa ke esheku o yongoi a Masar. Isufu u yaꞋan ta̱ a̱ya̱ amangatawun n kupa (110) aduniyan. ");
INSERT INTO asg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","U yongo ta̱ ali ɗa we enei muku mi Ifirayimu m muku mu ntsukaya n ni. U yongo ta̱ n wuma ali ɗa wi isai muku m Makiri m Manasa u woꞋi le e ekiye a̱ ni. ");
INSERT INTO asg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ɗa Isufu u danai aza a̱ ni, <<Mi ta̱ ɗevu n ukpa̱, ama Ka̱shile ki ta̱ a kinda ɗa̱ ka̱ta̱ wu uta̱ka̱ ɗa̱ a iɗika i nampa, ka̱ta̱ u banka ɗa̱ a iɗika i na u yaꞋankai Ibirahi n Ishaku n Yakubu uzuwakpani.>> ");
INSERT INTO asg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ɗa Isufu u zuwai aza a̱ ni a yaꞋanka yi akucina. <<Ayin a na baci Ka̱shile ka̱ ta̱wa̱i wa̱ ɗa̱ yi ta̱ a̱ kupura̱ etele a̱ va̱ i walaka.>> ");
INSERT INTO asg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ɗa Isufu u kuwa̱i a Masar. Wi ta̱ n a̱ya̱ amangatawun n kupa (110). Ɗa a̱ tsungi keven ka̱ Isufu a̱guma̱ a na a̱ kusa̱nka̱ kushama, ɗa a zuwa kaꞋa akpati vu kuzuwa keven.");
INSERT INTO asg_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Na va ɗaɗa ula a̱ muku mo olobo n Yakubu aza na a banai a iɗika i Masar n esheku e le, yaba dem n aza a kpaꞋa ku ni. ");
INSERT INTO asg_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ele ɗa Ruben, n Saminu, n Levi, koɓolo n Yahuza, ");
INSERT INTO asg_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","n Isaka, n Zabalun, koɓolo m Bayami, ");
INSERT INTO asg_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","n Dan, n Nafutali, n Gadu, koɓolo n Ashera. ");
INSERT INTO asg_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Dem vu le ele ɗa tsukaya amangatatsunkupa, koɓolo n Isufu vuza na ta ɗe wi ida̱shi a Masar va. ");
INSERT INTO asg_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","M megeshe ɗe ɗa Isufu n aza a̱ ni n uma a na o yongoi a ayin a nanlo dem a̱ kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ama ɗa aza a Isaraila a̱ ka̱na̱i kumatsansanai ali ɗa a yimkpai n a̱bunda̱i. Ɗa iɗika dem i shanai n ele, ɗa o okpoi aza a utsura a na va kucina a̱ ubuta̱ dem. ");
INSERT INTO asg_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","A̱ya̱ n a̱bunda̱i a lazai ɗa mogono ma savu ma lyaꞋi tsugono a Masar vuza na u saꞋwai kuyeve Isufu n ili i na u yaꞋin ba. ");
INSERT INTO asg_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ɗa u danai uma a̱ ni, <<La̱na̱i, aza a Isaraila a yimkpa ta̱ n a̱bunda̱i, ali i a kuciga ku laꞋa tsu utsura. ");
INSERT INTO asg_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ta̱wa̱i tsu la̱nsa̱i uye u na tsa kushamkpa le, ɗa baci ba i ta̱ a ku laꞋa tsu a̱ ka̱bunda̱i. Ta̱wa̱ baci kuvon kuɗa̱nga̱, i ta̱ a kufuɗa o ɓolongu una̱ n irala i tsu ka̱ta̱ a̱ shilika̱ n a̱ tsu ali a suma a̱ Ka̱sukpa̱ka̱ tsu iɗika ya.>> ");
INSERT INTO asg_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","A ayin a nanlo ɗa aza a Masar, a zuwai aza a̱ kula̱na̱ agbashi e neke aza a Isaraila ulinga wu utsura. Ɗa a zuwai le a maꞋakai FiriꞋauna likuci i Pitom n Ramase, ubuta̱ u na u kuzuwa ucanuku. ");
INSERT INTO asg_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ama tsu na i o kudoku le atakaci a ulinga ɗa ta na feu ele i o kudoku kuyimkpasaka n ka̱bunda̱i nannai. Adama a ili i nanlo, ɗa aza a Masar o doku a panasakai wovon wa aza a Isaraila ka̱u. ");
INSERT INTO asg_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ɗa aza a Masar o doku e nekei le ulinga n a̱bunda̱i babu asuvayali. ");
INSERT INTO asg_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","A zuwai wuma u le wo okpoi n atakaci ka̱u, a̱ ubuta̱ u kuna̱na̱ ciꞋin n kuyaꞋan ki iputa̱ n ulinga wa ashina e le u na u buwai dem. A pana asuvayali e le ba, ko kenu. ");
INSERT INTO asg_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ɗa mogono ma Masar ma danai Sifira m Puwa, aza a na a̱ tsu ka̱na̱ limata ya a̱ma̱ci ya aza a Ibirahi, ");
INSERT INTO asg_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","<<Yi baci a̱ kuka̱na̱ limata i vuka va aza a Ibirahi i zuka mekere ma baci i ka̱sukpa̱ yi n wuma, kolobo ka baci ta na yu una.>> ");
INSERT INTO asg_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ama a̱ma̱ci e re a nampa a panai wovon u Ka̱shile, o tono kadanshi ko mogono ba, ɗa a̱ ka̱sukpa̱i olobo a n wuma. ");
INSERT INTO asg_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ɗa mogono ma Masar ma me ɗekei aza a̱ kuka̱na̱ limata a ɗa we ecei le. <<Yiɗa̱i i zuwai ɗa i yaꞋin nannai, i ka̱sukpa̱i muku n ali ma n wuma?>> ");
INSERT INTO asg_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ɗa a̱ ushuki, <<Vuzagbayin, a̱ma̱ci aza Ibirahi i tsa a̱ma̱ci a aza a Masar ba, i ta̱ n ugbamiwasuvu, a tsu matsa ta̱ kpamu muku n le kafu ci yawa.>> ");
INSERT INTO asg_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Adama a nanlo ɗa Ka̱shile ka zuwakai aza a̱ kuka̱na̱ limata ya una̱singai, ɗa aza a Isaraila o doki n ka̱bunda̱i n utsura kpamu. ");
INSERT INTO asg_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Adama a na aza a kula̱na̱ limata a pana ta̱ wovon u Ka̱shile, ɗa Ka̱shile ke nekei le limata i ka̱ci ke le. ");
INSERT INTO asg_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ɗa FiriꞋauna u nekei aza a̱ ni dem kadanshi ka nampa, <<Maku mo kolobo ma aza a Ibirahi ma na baci a matsai dem a vakangu maꞋa o Kuyene ku Nilu, ama a̱ ka̱sukpa̱ muku mi nkere n wuma.>> ");
INSERT INTO asg_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","A̱ ka̱tsuma̱ ka ayin a nampa, vuza va aza e Levi vi yoku u zuwai mekere ma aza e Levi. ");
INSERT INTO asg_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ɗa vuka va vi yaꞋin ka̱tsuma̱ ɗa u matsai maku mo kolobo. Ana we enei maku ma mi ta̱ n tsuloboi, ɗa u sokongi maꞋa ali wotoi u tatsu. ");
INSERT INTO asg_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ama ana we enei wa kufuɗa wo doku wo foɓo yi ba, ɗa u la̱nsa̱i mabana mi ikiku, ɗaɗa u paɗarai maꞋa n cirupa̱ tsu kacimba n cirupa̱ tsu nɗanga. Ɗa u zuwai maku ma punu, ɗa u bankai maꞋa a̱ ka̱kina̱ ko Kuyene ku Nilu ɗa u zura̱ngi maꞋa a kajanu. ");
INSERT INTO asg_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ɗa taku u shamgbai daꞋangi adama a na we ene ko yiɗa̱i i kulyaꞋa maku ma. ");
INSERT INTO asg_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ɗa mekere ma FiriꞋauna ma banai kusumbu ɗe o Kuɗolu ku Nilu. Ana agbashi e nkere n ni i a̱ kuka̱ra̱Ꞌa̱sa̱ punu a̱ ka̱kina̱ ko kuɗolu ka, ɗa we enei mabana punu uzura̱ngi a̱ mita̱. Ɗa u suki kagbashi kete ka bana ka ɗikaka yi maꞋa. ");
INSERT INTO asg_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ana u ɓa̱yuwa̱i maꞋa ɗa we enei mereɓu a̱ ma̱shi, ɗa u panai asuvayali a̱ ni, ɗa u danai, <<Na va maku ma aza a Ibirahi maꞋa.>> ");
INSERT INTO asg_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ɗa taku va u yawai, ɗa we ecei ni, <<M bana n la̱nsa̱ka̱ wu vuka va aza a Ibirahi, vuza na u ku woꞋoko wu maku ma?>> ");
INSERT INTO asg_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ɗa wu ushuki, <<E, bana.>> Ɗa u banai gogo lo, ɗa u la̱nsa̱i a̱na̱ku a maku a. ");
INSERT INTO asg_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ana a̱na̱ku a maku a yawai, ɗa mekere ma FiriꞋauna ma danai ni, <<Ɗika mereɓu ma ka̱ta̱ vu woꞋoko mu maꞋa, ka̱ta̱ n tsupa wu.>> Ɗa ta na a̱na̱ku a a ɗikai maku ma ɗa o woꞋokoi ni maꞋa. ");
INSERT INTO asg_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ana maku ma mo gbonguroi, ɗa u ɗikai ni u bankai mekere ma FiriꞋauna, ɗa wo okpoi maku ma̱ ni. Ɗa u neꞋi ni kula Musa, u danai, <<Adama a na mu uta̱ka̱ yi ta̱ a̱ mini.>> ");
INSERT INTO asg_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ana Musa u shanai utsura, kanna ke te wu uta̱i adama a na u bana we ene aza a̱ ni aza a Ibirahi. Ɗa u cinai le a kuyaꞋan ulinga wu utsura u tsugbashi. Ɗa kpamu we enei vuza va aza a Masar a kulapa vuza ni vuza va aza a Ibirahi. ");
INSERT INTO asg_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ana Musa u la̱na̱i dem we ene lo vuza a kinda yi ba, ɗa wu unai vuza va aza a Masar va, ɗa u ciɗa̱ngi ni lo. ");
INSERT INTO asg_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ana kayin ka asai, ɗa wu uta̱i kpamu, ɗa u banai ɗe, ɗa we enei aza a Ibirahi a̱ vishili a uteku u le. Ɗa we ecei vuza na ka̱ ni ka gaꞋin ba, <<Yiɗa̱i i zuwai ɗa vi a kulapa vuza nu?>> ");
INSERT INTO asg_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ɗa u danai, <<Yayi u zuwai nu vo okpo mogono ma̱ tsu n kayaꞋin ka afada ka̱ tsu? Ko vi ta̱ a kuciga va kuna mu uteku tsu na vu unai vuza va aza a Masar na̱yin?>> Ɗa wovon u ka̱na̱i Musa, ɗa u danai, <<Ashe uma e yeve ta̱ ili i na n yaꞋin va.>> ");
INSERT INTO asg_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ana FiriꞋauna u panai nannai, ɗa u la̱nsa̱i an wa kuna Musa. Ɗa Musa u sumai ɗa u banai ɗa u da̱sa̱ngi a iɗika i Midiya. Ana u yawai ɗe, ɗa u da̱sa̱ngi a̱ una̱ u kayinva. ");
INSERT INTO asg_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ganu va aza a Midiya wi ta̱ ni nkere n cindere. Ɗa a banai kukenuku mini adama a na a shatangu okotsu a na e ci neꞋe ushiga we eshekpu e le mini. ");
INSERT INTO asg_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ɗa nguɓi n yoku n yawai, ɗa o lokoi le. Ama ɗa Musa u ɗa̱nga̱i ɗa u ɓa̱nka̱i nkere ma, ɗa u ronoi mini u shatangi okotsu a, ɗa u neꞋi ushiga u le. ");
INSERT INTO asg_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ana nkere ma m bonoi we eshekpu e le Reyuwe, ɗa we ecei le, <<Yiɗa̱i ɗa i bonoi gogoꞋo nannai anana?>> ");
INSERT INTO asg_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ɗa a̱ ushuki, <<Vuza va aza a Masar vi yoku ɗa u ɓa̱nka̱i tsu e ekiye a nguɓi n nanlo ma. Ali ɗa u ronokoi tsu mini ma na ci neꞋi ushiga u tsu.>> ");
INSERT INTO asg_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ɗa we ecei nkere n ni, <<Te ɗai vuza va wi? Yiɗa̱i i zuwai ɗa i ka̱sukpa̱i ni ɗe? Banai i ɗeke yi u ta̱wa̱ u lyaꞋa ilikulyaꞋa.>> ");
INSERT INTO asg_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ɗa Musa wu ushuki kuyongo n vuma va. Ɗa ta na vuza va u nekei ni mekere Zipura ciya̱ wo okpo yi vuka. ");
INSERT INTO asg_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ɗa Zipura u matsai maku mo kolobo, ɗa Musa u neꞋi ni kula Goshum, ɗaɗa, <<N yaꞋan ta̱ limoci a iɗika i pulai.>> ");
INSERT INTO asg_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A̱ya̱ n a̱bunda̱i a lazai, ɗa mogono ma Masar ma̱ kuwa̱i. Ama aza a Isaraila a buwa ta̱ a̱ yura̱ adama a atakaci a ugbashi e le, ɗa a lapai una̱. Ɗa malapa mu una̱ me le adama a̱ uɓa̱nki, ma banai a̱ Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ɗa Ka̱shile ka panai yura̱ i le, adama a na u ciɓa ta̱ n uzuwakpani u ni n Ibirahi n Ishaku n Yakubu. ");
INSERT INTO asg_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ɗa Ka̱shile ke enei atakaci a aza Isaraila, ɗa u panai asuvayali e le. ");
INSERT INTO asg_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Kanna ke te, Musa a̱yi a kaguɓa ku ushiga wa akaya a̱ ni Jeturo, ganu vu Midiya. Ɗa u banai kaguɓa ka a uɓon u meremune, ɗa u banai a kusan ku Ka̱shile ku na e ci ɗeke Horebu. ");
INSERT INTO asg_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ta ɗe kalingata ka Vuzavaguɗu kuta̱i punu wa̱ ni a ma̱vuku ma na ma̱ ka̱na̱i akina a. Ana Musa we enei nannai ɗa u yaꞋin mereve adama a na maɗanga ma ma̱ ka̱na̱ ta̱ akina ama ma̱ kula̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ɗa u sheshei, <<Nini ɗai maɗanga ma ma̱ kpa̱ɗa̱i kukula̱? Ili i mereve i ɗa, yaꞋan m bana ɗevu me ene.>> ");
INSERT INTO asg_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ana Vuzavaguɗu we enei u bana ta̱ kula̱na̱ maɗanga ma, ɗa Ka̱shile ke ɗekei ni punu a maɗanga ma, <<Musa! Musa!>> Ɗa Musa wu ushuki, <<Mpa ɗa na.>> ");
INSERT INTO asg_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ɗa Ka̱shile ka danai, <<Ka̱ta̱ vu yawa ɗevu ba. Foɗo ataka a̱ nu, adama a na ubuta̱ u na vi a kashani na lo va, ubuta̱ u ciɗa u ɗa. ");
INSERT INTO asg_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ɗa u doku u danai, mpa ɗa Ka̱shile ke eshevu, Ka̱shile ki Ibirahi, Ka̱shile ki Ishaku n Ka̱shile ka Yakubu.>> Ɗa Musa u za̱lika̱i kaci ka̱ ni, adama a na wi ta̱ a kupana wovon u kugasa a̱shi n Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ɗa Vuzavaguɗu u danai ni, <<Me ene ta̱ atakaci a uma a̱ va̱ na ɗe a Masar. M pana ta̱ malapa mu una̱ me le, adama a atakaci a na i o kusoꞋo e ekiye a aza a̱ kula̱na̱ agbashi a Masar. Mi ta̱ ta na e kukeɓece adama e le. ");
INSERT INTO asg_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tsu nanlo n ta̱wa̱ ta̱ adama na mi isa le e ekiye aza a Masar. Ka̱ta̱ mu uta̱ka̱ le a̱ ubuta̱ u nampa, m banka le a iɗika i na i laꞋi n ugaꞋin n a̱bunda̱i, iɗika i na yi m maniꞋin n tsuta̱ iɗika ya aza a KanaꞋana, n aza a Hitiya, n aza a Amoriya, n aza a Periziya, n aza a Hiviya, n aza a Jebusiya. ");
INSERT INTO asg_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Gogo na ma̱shi ma aza a Isaraila ma̱ ta̱wa̱ ta̱ wa̱ va̱, me ene ta̱ kpamu uteku u na aza a Masar i a kutakacika le. ");
INSERT INTO asg_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Gogo na, mi ta̱ a̱ kusuku wu u FiriꞋauna, adama a na vu bana vu uta̱ka̱ n uma a̱ va̱ aza a Isaraila punu a Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ama ɗa Musa u danai Ka̱shile, <<Mpa ɗa tamkpamu ya, an ma kubana u FiriꞋauna adama a na mu utuka̱ aza a Isaraila punu a Masar?>> ");
INSERT INTO asg_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ɗa Ka̱shile ka danai, <<Mi ta̱ koɓolo n avu. Na ɗa urotu u na u kokpo wa̱ nu, a kudana mpa ɗa n suki nu, vu uta̱ka̱ baci n uma a̱ va̱ a Masar, yi ta̱ e kuneke Ka̱shile tsugbayin a kusan ku nampa.>> ");
INSERT INTO asg_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ɗa Musa wu ushuki Ka̱shile, <<Gogo na ta̱wa̱ baci m bana wa aza a Isaraila, ɗa n danai le, <Ka̱shile ki ikaya ka̱ ɗa̱ ka̱ suku mu ta̱ n ta̱wa̱ wa̱ ɗa̱.> E ece mu baci, <Yayi kula ku ni?> Yiɗa̱i tamkpamu ma kudana le?>> ");
INSERT INTO asg_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ɗa Ka̱shile ku ushuki Musa <<MPA ƊA N CI YAꞋAN MPA. Ɗaɗa ili i na va kudana aza a Isaraila, <MPA ƊA u suku mu ta̱ wa̱ ɗa̱.> >> ");
INSERT INTO asg_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ka̱shile ka danai Musa kpamu, <<Dana aza a Isaraila, <Vuzavaguɗu Ka̱shile ki ikaya i ɗa̱, Ka̱shile ki Ibirahi, n Ka̱shile ki Ishaku, n Ka̱shile ka Yakubu a̱yi ɗa u suki mu wa̱ ɗa̱.> Na va ɗaɗa kula ku va̱ ayin dem a kubana ko wannai, kula ku na uma a kuciɓa nu mpa ali nu ntsukaya dem. ");
INSERT INTO asg_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","<<Gogo na bana vu ɓolongu aza a̱ gba̱ra̱-gba̱ra̱ a aza a Isaraila a̱ ubuta̱ u te ka̱ta̱ vu dana le, <Vuzavaguɗu Ka̱shile ki ikaya i ɗa̱, Ka̱shile ki Ibirahi, n ki Ishaku, n ka Yakubu ko yotsongi ka̱ci ka̱ ni wa̱ va̱ ɗa u danai mu, mpa me ene ta̱ ra̱ka̱, ili i na aza a Masar i a kuyaꞋanka ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","N yaꞋan ta̱ uzuwakpani mi ta̱ a̱ ku utuka̱ ɗa̱ a̱ ka̱tsuma̱ ka atakaci ka̱ ɗa̱ punu na a Masar a kubana a iɗika ya aza a KanaꞋana, n aza a̱ Hitiya, n aza Amoriya, n aza a Piritiza, n aza a Heviya, n Jebusiya, a iɗika i na yi m maniꞋin n tsuta̱.> ");
INSERT INTO asg_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","<<Uma a i ta̱ a kupanaka wu. Ka̱ta̱ avu nu nkoshi m gba̱ra̱-gba̱ra̱ i bana u mogono ma aza a Masar i dana yi, <Vuzavaguɗu Ka̱shile ka aza a Ibirahi ko yotsongu ta̱ ka̱ci ka̱ ni wa̱ tsu. Adama a nannai, ka̱sukpa̱ ci yaꞋan nwalu e meremune ali ayin a tatsu, adama a na ci yaꞋanka Ka̱shile Vuzavaguɗu vu tsu alyuka.> ");
INSERT INTO asg_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ama n yeve ta̱ mogono ma Masar ma̱ kuka̱sukpa̱ ɗa̱ i laza ba, sai n gutsuka yi nu utsura u va̱. ");
INSERT INTO asg_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mi ta̱ a kuyaꞋan ulinga n utsura u va̱ ka̱ta̱ n takacika aza a Masar, n yaꞋan ili i mereve kakau ra̱ka̱. Ka̱ta̱ mogono ma me yeve kuka̱sukpa̱ ɗa̱ i wala. ");
INSERT INTO asg_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","<<Mi ta̱ a kuzuwa aza a Masar a yaꞋanka uma a̱ va̱ ili i singai. I ta̱ a kuyaꞋanka ɗa̱ kuneꞋe, yi baci a kulaza ya kulaza e ekiye agaɗa ba. ");
INSERT INTO asg_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Vuka dem vi ta̱ a kubana u vuka va aza a Masar vu na vi ɗevu m kpaꞋa ku ni n vuka dem vu na vi ida̱shi wa̱ ni, ka̱ta̱ we ece yi ili ya azanariya ko ya azurufa ko akashi a kuꞋuka. A na i kuꞋuka muku mo olobo m muku mu nkere n ɗa̱, nannai ɗa i kulaza n uciyi wa aza a Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ɗa Musa wu ushuki, <<A̱ ushuku baci nu mpa tamkpamu ba, ko ɗa a iwain kupanaka mu. A dana baci, <Vuzavaguɗu u ta̱wa̱ wa̱ nu ba.> >> ");
INSERT INTO asg_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ɗa Vuzavaguɗu we ecei ni, <<Yiɗa̱i vi n i ɗa e ekiye a̱ nu na lo va?>> Ɗa Musa u danai, <<Kalangu kaꞋa.>> ");
INSERT INTO asg_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ɗa Vuzavaguɗu u danai, <<Vakangu kaꞋa a iɗika.>> Ɗa Musa u vakangi kaꞋa a iɗika, ɗa ka vazai koko! Ɗa u docoi n ka̱ca̱pa̱ u ka̱sukpa̱i kaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ɗa Vuzavaguɗu u danai ni, <<Banka n kukiye ku nu vu ka̱na̱ winja u koko wa.>> Ɗa Musa u bankai n kukiye ku ni, ɗa u ka̱na̱i koko ka, ɗa koko ka ko bonoi kalangu e ekiye a̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ɗa Vuzavaguɗu u danai ni, <<YaꞋan ili i mereve i nampa, adama a na a̱ ushuku n Vuzavaguɗu Ka̱shile ki ikaya i le, Ka̱shile ki Ibirahi, n Ka̱shile ki Ishaku, n Ka̱shile Yakubu ko yotsongu ta̱ ka̱ci ka̱ ni wa̱ nu.>> ");
INSERT INTO asg_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ɗaɗa kpamu Vuzavaguɗu u danai, <<Uka kukiye ku nu o motogu ma̱ nu.>> Ɗa Musa u ukai kukiye ku ni punu, ɗa wu uta̱ka̱i kukiye ka ɗa kokpoi wa̱ri n ukutu. ");
INSERT INTO asg_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ɗa Vuzavaguɗu u danai, <<Gogo na bonoko ku ɗa punu o motogu ma.>> Ana u bonokoi n ku ɗa punu, ɗa wu uta̱ka̱i, ɗa ku bonoi ciɗa ci ikyamba i na i buwai. ");
INSERT INTO asg_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ɗa Vuzavaguɗu u danai, <<A iwan baci kushuku n avu, ko kushuku n ili i mereve yu ugiti, i ta̱ a̱ kushuku n ili i mereve i ire ya. ");
INSERT INTO asg_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ɗa baci a iwain kushuku n ili i mereve ire i nampa ya, ko kupana ka̱la̱ka̱tsu ka̱ nu, kenuku mini punu o Kuyene ku Nilu, ka̱ta̱ vu tsungu a iɗika i ɗekpu. Mini ma na vi kenuki va, mi ta̱ o kokpo mpasa lo a iɗika i ɗekpu ya.>> ");
INSERT INTO asg_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ama ɗa Musa u danai Vuzavaguɗu, <<Vuzavaguɗu vu va̱, n ci yaꞋan kadanshi ka̱ta̱ kaꞋa ku uta̱ mayin ba, ali n ayin a ɗe ko n gogo na ana vi yaꞋin kadanshi nu mpa. N ci yaꞋan ta̱ kadanshi sawu koɓolo n cikeku kpamu.>> ");
INSERT INTO asg_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ɗaɗa Vuzavaguɗu u danai ni, <<Yayi u nekei vuma una̱? Yayi kpamu u bonokoi ni kebebe ko kagulani? Yayi u nekei ni a̱shi ko uyimba̱? Mpa ɗa Vuzavaguɗu ba? ");
INSERT INTO asg_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Gogo na bana, mi ta̱ a̱ kuɓa̱nka̱ wu tsu na va kuyaꞋan kadanshi ka̱ta̱ n dana wu ili i na va kudansa.>> ");
INSERT INTO asg_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ama ɗa Musa u danai, <<Vuzavaguɗu yaꞋan wupa ba, suku vuza yoku u bana.>> ");
INSERT INTO asg_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ɗa Vuzavaguɗu u yaꞋin wupa m Musa, ɗa u danai, <<Haruna mokoshi ma̱ nu tamkpamu vuza va aza e Levi? N yeve ta̱ u tsu dansa ta̱ mayin. Wi ta̱ lo a uye adama a na i gasa, wi ta̱ feu a kuyaꞋan ma̱za̱nga̱, we ene wu baci. ");
INSERT INTO asg_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Vi yaꞋan kadanshi n a̱yi, ka̱ta̱ vu tonuko yi i na u kudana. N kuɓa̱nka̱ ɗa̱ ta̱ n i na i kudansa n i na i kuyaꞋan.>> ");
INSERT INTO asg_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A̱yi ɗa u kokpo vuza na u kuyaꞋanka uma kadanshi n una̱ u nu. Avu vi ta̱ o kokpo an Ka̱shile wa̱ ni, vu dana yi ili i na u kudansa. ");
INSERT INTO asg_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ama ka̱ta̱ vu ɗika kalangu ka nampa vu walaka, adama a na ka ɗaɗa va kuyaꞋanka ili i mereve. ");
INSERT INTO asg_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ɗa Musa u bonoi wa akaya a̱ ni Jeturo ɗa u danai ni, <<YaꞋan m bono biꞋi me ene aza a̱ va̱ na ɗe a Masar ko a buwa ta̱ ɗe n wuma.>> Ɗa Jeturo wu ushuki, <<Bana vu bono m ma̱ta̱na̱.>> ");
INSERT INTO asg_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa a̱yi biꞋi a Midiya Vuzavaguɗu u dana yi ta̱, <<Laza vu bono a Masar adama a na aza a na i a kuciga a kuna wu va a̱ kuwa̱ ta̱ ɗe ra̱ka̱.>> ");
INSERT INTO asg_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ɗa Musa u ɗikai muku mo olobo n ni n vuka vi ni ɗa u kumbakai le a majaki, ɗa u ka̱na̱i uye o kubono a iɗika i Masar. Ɗa u ɗikai kalangu ka̱ ni e ekiye a̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ɗa Ka̱shile ka danai Musa kpamu, <<Vi yawa baci a Masar vi yaꞋan ili i mereve i na n nekei nu utsura u kuyaꞋan e kelime ka FiriꞋauna. Ama mi ta̱ a kuzuwa yi wo okpo n ugbamukaci, wa̱ kuka̱sukpa̱ uma a̱ va̱ a laza ba. ");
INSERT INTO asg_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ka̱ta̱ vu dana FiriꞋauna, <Ili i na Vuzavaguɗu n danai i ɗaɗa na, uma a Isaraila i ta̱ tsu maku mo kolobo ma iyain ma̱ va̱, ");
INSERT INTO asg_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","N dana wu ta̱, <<Ka̱sukpa̱ yi u laza adama a na u yaꞋanka mu a̱ga̱nda̱.>> Ama vi iwan baci kuka̱sukpa̱ yi u laza, gogo na mi ta̱ a kuna maku ma iyain ma̱ nu.> >> ");
INSERT INTO asg_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ana Musa u shamgbai a kasa a̱ ubuta̱ u yoku n limata i ni, a ayin a na i a̱ ka̱tsuma̱ ka nwalu ke le, ɗa Ka̱shile ka cinai ni ɗa u ɗa̱nga̱i kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ɗa Zipura vuka Musa u la̱nsa̱i katali ka alyu ɗa u kiɗai kavaja ka maku ma̱ ni, ɗa u saꞋwakai ene a Musa, ɗa u danai, <<Mpasa n nampa mo okpo ta̱ urotu wu ushiyi u yolo u tsu mayun ɗa.>> ");
INSERT INTO asg_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ana u danai, <<Vali vu savu vu na a shiyai yolo n urotu wu mpasa,>> wi ta̱ a kuyaꞋan kadanshi ku ukiɗi u kavaja. Ɗaɗa Vuzavaguɗu u ka̱sukpa̱i Musa n wuma. ");
INSERT INTO asg_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ama kafu ayin a nanlo, Vuzavaguɗu u danai Haruna, <<Bana e meremune vi cina Musa.>> Ana u banai ɗa u gasai m Musa a kusan ku Ka̱shile, ɗa u rabasai ni ɗa wo oɓongi ni. ");
INSERT INTO asg_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ɗa Musa u danai Haruna ili i na Vuzavaguɗu u danai ni dem u bana u dana. Ɗa kpamu u yotsongi ni ili i mereve i na Ka̱shile ka zuwai ni u yaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ɗa Musa n Haruna a banai a Masar, ɗa o ɓolongi nkoshi m gba̱ra̱-gba̱ra̱ mi Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ɗa Haruna u danai le ra̱ka̱ ili i na Vuzavaguɗu u danai Musa, ɗa ta na Musa u yaꞋin lo ili i mereve ya a̱ a̱shi e le. ");
INSERT INTO asg_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ɗa ta na a̱ ushuki. Ana a panai Vuzavaguɗu wi ta̱ a kuciɓa n ele koɓolo n atakaci a na i kpamu o kusoꞋo, ɗa a̱ ɗa̱nga̱i ɗa a̱ kuɗa̱ngi, ɗa a cikpai Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ana o kotsoi kudansa nu nkoshi ma aza Isaraila, ɗa Musa n Haruna a banai u FiriꞋauna ɗa a danai ni, <<Ili i na Vuzavaguɗu Ka̱shile ka aza a Isaraila u danai i ɗa na, <Ka̱sukpa̱ uma a̱ va̱ a bana a yaꞋanka mu ka̱ɗiva̱ ɗe e meremune.> >> ");
INSERT INTO asg_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ɗa FiriꞋauna we ecei <<Yayi Vuzavaguɗu vu nanlo, vuza na n kupana kadanshi ka̱ ni ali ka̱ta̱ n ka̱sukpa̱ aza a Isaraila a laza? Mpa n yeve Vuzavaguɗu vu nanlo ba. Ma̱ a̱ kuka̱sukpa̱ ɗa̱ i laza ba.>> ");
INSERT INTO asg_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ama ɗa Musa n Haruna a̱ ushuki a danai, <<Ka̱shile ka aza Ibirahi u yotsongu ta̱ ka̱ci ka̱ ni wa̱ tsu. Tsu folono wu ta̱ yaꞋan ci yaꞋan nwalu ali ayin a tatsu a kakamba adama a na tsu bana ci yaꞋanka Ka̱shile Vuzavaguɗu vu tsu alyuka. Ci yaꞋan baci nannai ba, wi ta̱ a kuna tsu m ma̱dukpa̱ ko n kotokobi.>> ");
INSERT INTO asg_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ama ɗa mogono ma Masar me ecei Musa n Haruna, <<Adama a̱ yiɗa̱i yi a̱ kusa̱nka̱ uma kuyaꞋan ulinga u le? Kai! Bonoi ubuta̱ wu ulinga!>> ");
INSERT INTO asg_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ɗa FiriꞋauna u lyaꞋi kelime n kadanshi, <<Gogo na aza a Isaraila a yimkpa ta̱ ali a laꞋi aza a Masar n ka̱bunda̱i, ɗa yi a kuciga kusa̱nka̱ le ulinga.>> ");
INSERT INTO asg_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","A kanna ka nanlo ka, ɗa FiriꞋauna u danai aza e kelime a kinda agbashi a Masar, n aza kinda ulinga u tsugbashi wi Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","<<Ka̱sukpa̱i kuneke uma a nampa ciꞋiwa̱ adama a na a yaꞋanka iputa̱ tsu na a kiwanai. Ka̱sukpa̱i le a bana a̱ la̱nsa̱ n ka̱ci ke le. ");
INSERT INTO asg_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Zuwai le a yaꞋan ka̱bunda̱i ki iputa̱ ka tsu na a kiwanai, ka̱ta̱ i jebeke le ka̱bunda̱i ki iputa̱ ka ba. Wonvoli u ɗa le, i ɗaɗa i zuwai ɗa i a kuyaꞋanka mu ma̱shi n ka̱sukpa̱ le a bana a kakamba a yaꞋanka Ka̱shile ke le alyuka. ");
INSERT INTO asg_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nekei le ulinga wa atakaci ka̱ta̱ a lyaꞋa kelime n kuyaꞋan, nannai wi ta̱ a kuzuwa le a̱ kpa̱ɗa̱ kuciya̱ kofon ka na a kupana aꞋuwa a nampa.>> ");
INSERT INTO asg_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ɗa aza a kinda ulinga u tsugbashi n aza a kinda agbashi a banai ɗa a danai uma ili i na FiriꞋauna u danai. <<Mi o kudoku me neke ɗa̱ ciꞋiwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Banai i la̱nsa̱ tsu ɗa n ka̱ci ka̱ ɗa̱ a̱ ubuta̱ u na baci de dem i kuciya̱ tsu ɗa. Ama i lyaꞋa kelime n kuyaꞋan ka̱bunda̱i ki iputa̱ tsu na cau yi ishi a kuyaꞋansa.>> ");
INSERT INTO asg_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ɗa uma a a wacuwai a kubana a̱ ubuta̱ dem punu a iɗika i Masar a̱ kula̱nsa̱ ili i na a ci yaꞋanka ciꞋiwa̱. ");
INSERT INTO asg_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ama aza a kinda ulinga u tsugbashi wa o doku a gbarai le ka̱u, ɗa a̱ ka̱na̱i kudana le. <<Kanna de dem i yaꞋan iputa̱ tsu ka̱bunda̱i ka na yi ishi i ci yaꞋansa tsu ayin a na e ci neke ɗa̱ ciꞋiwa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ɗa aza e kelime a kinda agbashi a Masar a fabai aza Isaraila aza a na i a kinda aza ulinga u tsugbashi wa, ɗa e ecei. <<Yiɗa̱i i zuwai ɗa i kpa̱ɗa̱i kuzuwa agbashi a a yaꞋan iputa̱ na̱yin ko anana a shatangu tsu na ishi a kuyaꞋansa?>> ");
INSERT INTO asg_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ɗa aza a kinda ulinga u tsugbashi a Isaraila a banai u FiriꞋauna ɗa a̱ sa̱la̱ka̱i ni. <<Yiɗa̱i i zuwai ɗa vi yaꞋankai agbashi a̱ nu nannai? ");
INSERT INTO asg_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Babu vuza na u nekei tsu ciꞋiwa̱, ɗa kpamu a danai tsu <YaꞋin iputa̱ tsu na cau yi ishi a kuyaꞋansa.> A̱ ka̱na̱i kulapasa tsu gbani na lo ta na unushi u tsu u ɗa ba, unushi u uma a̱ nu a ɗa.>> ");
INSERT INTO asg_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ɗa FiriꞋauna wu ushuki, <<Na lo dem i yoku i ɗa ba, wonvoli u ɗa. Ɗaɗa yi a kudanasa, <YaꞋan tsu bana ci yaꞋanka Vuzavaguɗu alyuka.> ");
INSERT INTO asg_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Walai i bono a̱ ubuta̱ wu ulinga. Babu vuza na u kuneke ɗa̱ ciꞋiwa̱, ama mayun ɗa sai i yaꞋan ka̱bunda̱i ki iputa̱ tsu na yi ishi i ci yaꞋansa.>> ");
INSERT INTO asg_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Aza a kinda aza ugbashi a Isaraila e yeve ta̱ gogo na a uwa ta̱ a̱ ka̱tsuma̱ ka atakaci a gbayin, ana a danai le, <<Ka̱ta̱ i jebe ka̱bunda̱i ki iputa̱, i kpa̱ɗa̱ kuyawa tsu na cau yi ishi i ci yaꞋansa a kanna dem ba.>> ");
INSERT INTO asg_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ana a̱ uta̱i a̱ ka̱sukpa̱i FiriꞋauna, ɗa a gasai m Musa n Haruna aza a na ishi ɗe a kuvana le. ");
INSERT INTO asg_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ɗa a danai Musa n Haruna va, <<YaꞋan Vuzavaguɗu we ene ili i na i yaꞋin ka̱ta̱ u yaꞋanka ɗa̱ afada. I zuwai tso okpoi nu mpasa m gbani-gbani u FiriꞋauna nu nkoshi m gba̱ra̱-gba̱ra̱ n ni feu. Gogo na i ɗikai kotokobi ɗa i nekei le e ekiye adama a na a una tsu.>> ");
INSERT INTO asg_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ɗa Musa u bonoi u Vuzavaguɗu ɗa u danai, <<Vuzavaguɗu, yiɗa̱i i zuwai ɗa vi nekei uma a̱ nu atakakaci nannai? Yiɗa̱i i zuwai ɗa vu suki mu? ");
INSERT INTO asg_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ali n ayin a na m banai u FiriꞋauna n kula ku nu adama a na n yaꞋanka yi kadanshi, u doku ta̱ u zuwaka uma a̱ nu atakaci n a̱bunda̱i. Ko ili vi keɓece adama a na vi isa le ba.>> ");
INSERT INTO asg_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ɗa Vuzavaguɗu u danai Musa, <<Gogo na ve kene ta̱ ili i na n kuyaꞋanka FiriꞋauna. N kukiye ku utsura ku va̱ wi ta̱ a̱ kuka̱sukpa̱ le a wala, n utsura u va̱ wi ta̱ a̱ kuta̱ka̱ le punu a iɗika ya.>> ");
INSERT INTO asg_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ka̱shile ka danai Musa, <<Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","N yotsongu ta̱ ka̱ci ka̱ va̱ wi Ibirahim, n Ishaku, n Yakubu, tsu Ka̱shile MalaꞋimili. Ama n ka̱sukpa̱ e yeve mu n utsura u kula ku va̱ ku Vuzavaguɗu ba. ");
INSERT INTO asg_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","N YaꞋan ta̱ uzuwakpani n ele n kuneke le iɗika i KanaꞋana, i na a̱ da̱sa̱ngi a kuyaꞋan limoci. ");
INSERT INTO asg_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Gogo na m pana ta̱ yura̱ ya aza a Isaraila, aza na aza a Masar a zuwai a ugbashi, ɗa n ciɓai nu uzuwakpani u va̱. ");
INSERT INTO asg_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Adama a nannai, dana aza a Isaraila, <Mpa ɗa Vuzavaguɗu, mi ta̱ a̱ kuta̱ka̱ ɗa̱ a̱ ka̱tsuma̱ ka atakaci ka aza a Masar, ka̱ta̱ n neke ɗa̱ uba̱ruwi a̱ ubuta̱ u tsugbashi wa, ka̱ta̱ mi isa ɗa̱ n utsura we ekiye a̱ va̱, ka̱ta̱ n neke le atakaci a gbayin. ");
INSERT INTO asg_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ka̱ta̱ m bonoko ɗa̱ uma a̱ va̱, ka̱ta̱ mpa tamkpamu mo okpo Ka̱shile ka̱ ɗa̱. Ɗaɗa i kuyeve a na mpa ɗa Vuzavaguɗu vu ɗa̱ n Ka̱shile ka̱ ɗa̱, vuza na wu utuka̱i ɗa̱ a̱ ka̱tsuma̱ ka atakaci ka aza a Masar. ");
INSERT INTO asg_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mi ta̱ a kubanka ɗa̱ a iɗika i na n yaꞋin akucina n kuneke Ibirahim, n Ishaku n Yakubu. Mi ta̱ e kuneke ɗa̱ i ɗa yo okpo ya ili yi uka̱ni i ɗa̱. Mpa ɗa Vuzavaguɗu.> >> ");
INSERT INTO asg_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa u danai aza a Isaraila kadanshi ka nampa, ama ɗa a iwain kupanaka yi adama a una̱mgbi u ka̱tsuma̱ n atakaci a na i o kusoꞋo a̱ ubuta̱ wu ugbashi. ");
INSERT INTO asg_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","<<Bana vu dana FiriꞋauna mogono ma Masar u ka̱sukpa̱ uma a Isaraila a̱ uta̱ punu a iɗika i ni.>> ");
INSERT INTO asg_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ama ɗa Musa wu ushuki Vuzavaguɗu, <<Uma a Isaraila a panaka mu baci ba, nini ɗai tamkpamu FiriꞋauna u kupanaka mu, mpa na mi a kadanshi n cikeku?>> ");
INSERT INTO asg_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ama ɗa Vuzavaguɗu u danai Musa n Haruna kakuna adama a aza a Isaraila n FiriꞋauna mogono ma Masar. U danai le a̱ uta̱ka̱ n aza a Isaraila punu a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Na va ɗaɗa nkoshi m gba̱ra̱-gba̱ra̱ mi iꞋuwa ya aza a Isaraila. Muku mo olobo n Ruben, maku ma iyain mi Isaraila ele ɗa, Enoku m Palu, n Hezuron, n Karimi. Ele na ɗa okpoi mogbodo mo Ruben. ");
INSERT INTO asg_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Muku mo olobo n Simiyon ele ɗa Jemuwelu, n Jamin, n Ohadu, n Jaki, n Zoharu, n Shawu, vuza na vuka va aza a KanaꞋana vu matsai, na va ɗaɗa mogbodo ma Simiyon. ");
INSERT INTO asg_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Na va ɗaɗa ula a̱ muku mo olobo n Levi, yaba dem n tsumani ci ni, ele ɗa Geshon, n Kohatu, m Merari. Levi wi ta̱ n a̱ya̱ amangatawun n kamangankupa n e cindere (137) kafu u kuwa̱. ");
INSERT INTO asg_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Muku mo olobo n Geshon yaba dem m mogbodo ma̱ ni ele ɗa Libini n Shime. ");
INSERT INTO asg_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Muku mo olobo n Kohatu ele ɗa Amuram n Iziharu n Heburon n Uziyelu. Kohatu u yaꞋan ta̱ a̱ya̱ amangatawun n kamangankupa n tatsu (133), kafu u kuwa̱. ");
INSERT INTO asg_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Muku mo olobo m Merari, ele ɗa Mahali m Mushi. Ele ɗa umaci u Levi, yaba dem m mogbodo ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuram u zuwai Jokabe taku ve esheku a̱ ni, ɗa u matsakai ni Haruna m Musa. Amuram wi ta̱ n a̱ya̱ amangatawun n kamangankupa n e cindere (137) kafu u kuwa̱. ");
INSERT INTO asg_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Muku mo olobo n Iziharu ele ɗa Kora, n Nefeku, n Zikiri. ");
INSERT INTO asg_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Muku mo olobo n Uziyelu ele ɗa Mishayel, n Elizafan, n Sitiri. ");
INSERT INTO asg_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna u zuwai Elisheba mekere ma Aminadabu vangu vu Nashon, ɗa u matsakai ni Nadabu, n Abihu, n Eliyaza, n Itama. ");
INSERT INTO asg_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Muku mo olobo n Kora ele ɗa Asiru, n Elikana, n Abiyasafa. Na va ɗaɗa mogbodo ma Kora. ");
INSERT INTO asg_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliyaza maku ma Haruna u zuwai mekere me Putiyelu, ɗa u matsakai ni Finihasu. Aza na okpoi aza a̱ gba̱ra̱-gba̱ra̱ a iꞋuwa i Levi m mogbodo me le. ");
INSERT INTO asg_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Haruna vu nampa va m Musa va, ele ɗa aza a na Vuzavaguɗu u yaꞋankai kadanshi, <<Uta̱ka̱i n aza a Isaraila a iɗika i Masar ka̱tsura̱-ka̱tsura̱.>> ");
INSERT INTO asg_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa n Haruna ele ɗa a yaꞋin kadanshi n FiriꞋauna mogono adama a na u ka̱sukpa̱ a̱ uta̱ka̱ n aza a Isaraila a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","A kanna ka na Vuzavaguɗu u yaꞋin kadanshi m Musa a iɗika i Masar, ");
INSERT INTO asg_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","u danai ni, <<Mpa ɗa Vuzavaguɗu, dana FiriꞋauna mogono ma Masar ili i na n danai nu dem.>> ");
INSERT INTO asg_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ama Musa u danai Vuzavaguɗu, <<A na wo okpoi mpa mi ta̱ a kadanshi n cikeku, nini ɗai FiriꞋauna u kupanaka mu?>> ");
INSERT INTO asg_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ɗa Vuzavaguɗu u danai Musa, <<Pana, mi ta̱ o kubonoko wu an Ka̱shile u FiriꞋauna. Mokoshi ma̱ nu Haruna wi ta̱ o kokpo an keneki ka na ka kuyaꞋan kadanshi n una̱ u nu. ");
INSERT INTO asg_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Vu dana yi ili i na n tonokoi nu dem. Ka̱ta̱ a̱yi Haruna u dana FiriꞋauna u ka̱sukpa̱ aza a Isaraila a̱ uta̱ punu a iɗika i ni. ");
INSERT INTO asg_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ama mi ta̱ a kuzuwa FiriꞋauna ugbamukaci. Ka̱ta̱ n doku kpamu urotu wi ili i mereve i va̱, a iɗika i Masar, ");
INSERT INTO asg_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ko n nannai FiriꞋauna wi ta na a kupanaka ɗa̱ ba. Ka̱ta̱ mpa n neke aza a Masar atakaci n a̱bunda̱i, ka̱ta̱ mu uta̱ka̱ uma a̱ va̱ aza a Isaraila kakau. ");
INSERT INTO asg_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ayin a na baci m ba̱ra̱kpa̱i kukiye ku va̱ wa aza a Masar, ciya̱ mu utuka̱ n aza a Isaraila a̱ ka̱tsuma̱ ke le, i ta̱ e kuyeve a na mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa n Haruna a yaꞋin tsu na Vuzavaguɗu u danai le. ");
INSERT INTO asg_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","A ayin a na a banai a yaꞋankai FiriꞋauna kadanshi, Musa wi ta̱ n a̱ya̱ amanga̱na̱shi. A̱yi Haruna tamkpamu wi ta̱ n a̱ya̱ amanga̱na̱shi n a tatsu. ");
INSERT INTO asg_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ɗa Vuzavaguɗu u danai Musa n Haruna, ");
INSERT INTO asg_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","<<FiriꞋauna u dana baci, <YaꞋin ili i mereve,> vu dana Haruna, <Ɗika kalangu ka̱ nu, vu vakangu kaꞋa a iɗika e kelime ka FiriꞋauna.> kaꞋa ki ta̱ a kuvaza koko.>> ");
INSERT INTO asg_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ɗa Musa n Haruna a banai u FiriꞋauna a yaꞋin ili i na Vuzavaguɗu u danai le. Ana a yawai, ɗa Haruna u vakangi kalangu ka̱ ni lo a̱ ubuta̱ u FiriꞋauna n anan taji a̱ ni, ɗa ta na ka vazai koko. ");
INSERT INTO asg_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ɗa FiriꞋauna u ɗekei aza e kuyeve n aza a̱ kula̱na̱ a̱ ni, n oboci a aza a Masar, ɗaɗa a̱ ka̱na̱i kuyaꞋan ili i mereve i nanlo feu derere. ");
INSERT INTO asg_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yaba dem vi le feu ɗa u vakangi kalangu ka̱ ni a iɗika ɗa ta na a vazai oko. Ama ɗa kalangu ka Haruna ko soɗongi alangu e le ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ko n nannai, ɗa FiriꞋauna u doku ɗa u yaꞋin ugbamukaci, ɗa u kpa̱ɗa̱i kupanaka le, uteku u na Vuzavaguɗu u danai ɗe. ");
INSERT INTO asg_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ɗa Vuzavaguɗu u danai Musa, <<FiriꞋauna wi ta̱ n ugbamukaci n a̱bunda̱i, u iwain kuka̱sukpa̱ uma a̱ va̱ a laza. ");
INSERT INTO asg_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Bana u FiriꞋauna n usana, ayin a na wi a̱ kuta̱ a kubana e kuyene ku Nilu. Ka̱ta̱ vu vana yi ɗe a̱ ka̱ga̱Ꞌin ka̱ kuyene ka, vi ɗika kalangu ka na ka vazai koko ka. ");
INSERT INTO asg_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ka̱ta̱ vu dana yi, <Vuzavaguɗu Ka̱shile ka aza a Ibirahim, u suku mu ta̱ wa̱ nu u danai vu ka̱sukpa̱ uma a̱ va̱ a wala a bana a cikpa mu na ɗe e meremune, ama ali n gogo na vu iwain kushuku. ");
INSERT INTO asg_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Pana ili i na Vuzavaguɗu u danai, nannai ɗa ve kuyeve a na mpa ɗa Vuzavaguɗu. N kalangu ka na ki e kukiye ku va̱ na, mi ta̱ a kulapa mini ma̱ Nilu ka̱ta̱ mo bono mpasa. ");
INSERT INTO asg_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Adan a na i punu a̱ mini ma i ta̱ a̱ kukuwa̱, mini kpamu mi ta̱ o kokpo n ushami tsu na aza Masar a kufuɗa o doku o soꞋo mini ma ba.> >> ");
INSERT INTO asg_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ɗaɗa Vuzavaguɗu u danai Musa, <<Dana Haruna <U ɗika kalangu ka̱ ni, ka̱ta̱ u shamgba u sapangu nɗolu m Masar ni nyeneke n adaɓa n ayinva a na o koꞋi dem. I ta̱ o kokpo mpasa, ali m mini ma na mi lo a̱ ndiki n okotsu koɓolo n ogbodo a iɗika i Masar dem.> >> ");
INSERT INTO asg_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ɗa Musa n Haruna a yaꞋin tsu na Vuzavaguɗu u danai le a yaꞋan. Ɗa Haruna u ɗengusa̱i kalangu ka̱ ni lo e kelime ka FiriꞋauna n anan taji a̱ ni dem lo a kinda. Ɗa u lapai Kuyene ku Nilu, ɗa ko okpoi mpasa. ");
INSERT INTO asg_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Adan a na i punu a̱ mini ma a̱ kuwa̱i. Ɗa mini ma shamai ka̱u, ali aza a Masar a fuɗa o doku soꞋo ba. Ɗa mini dem a iɗika i Masar mo okpoi mpasa. ");
INSERT INTO asg_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ama oboci a Masar a̱ ka̱na̱i kuyaꞋan ili i tsuboci i le, ɗa feu o bonokoi mini ma mpasa. Ɗa ka̱ɗu ka FiriꞋauna ko doku ka gbamasakai, u ciga kupanaka Musa ele n Haruna ba, tsu na Vuzavaguɗu u danai. ");
INSERT INTO asg_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ɗa FiriꞋauna u lazai o kubono e kefeku ka̱ ni, ko ka̱ɗu ka̱ ni ka̱ muɗa̱ adama a ili i nampa ya ba. ");
INSERT INTO asg_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ɗa aza a Masar dem a̱ ga̱va̱i ayinva a̱ ka̱ga̱Ꞌin ke kuyene ku Nilu a̱ kula̱nsa̱ mini mo kusoꞋo adama a na o doku a fuɗa o soꞋo mini me kuyene ma ba. ");
INSERT INTO asg_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ayin e cindere a lazai ana Vuzavaguɗu u la̱nga̱sa̱i Kuyene ku Nilu. ");
INSERT INTO asg_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ɗa Vuzavaguɗu u danai Musa, <<Bana u FiriꞋauna ka̱ta̱ vu dana yi, <Ili i na Vuzavaguɗu u danai i ɗaɗa na, ka̱sukpa̱ uma a̱ va̱ a wala adama a na a̱ ciya̱ a bana a cikpa mu. ");
INSERT INTO asg_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ama vu sa̱nka̱ le baci kulaza, mi ta̱ a̱ kutuka̱ m ma̱dukpa̱ mo opoɗo punu a iɗika i nu dem. ");
INSERT INTO asg_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kuyene ku Nilu ki ta̱ a kushana n opoɗo. I ta̱ a̱ kuta̱ ka̱ta̱ a uwa e kefeku ka̱ nu, n kunu ku kasa ku nu ali a gaɗi vu kajiba ka̱ nu, n iꞋuwa ya aza a̱ gba̱ra̱-gba̱ra̱ a ulinga a̱ nu, n uma a̱ nu ra̱ka̱. I ta̱ kpamu a kuꞋuwa e kenle ka̱ kuya̱na̱ koɓolo m masasu ma kulapaka kiya ka akala dem. ");
INSERT INTO asg_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Opoɗo a i ta̱ a kuɗikpangusu n a carai nu n uma a̱ nu dem, koɓolo n aza a̱ gba̱ra̱-gba̱ra̱ a̱ nu feu.> >> ");
INSERT INTO asg_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ɗa Vuzavaguɗu u danai Musa, <<Dana Haruna, <Ɗengusa̱ kalangu ka na ki e kukiye ku nu vu sapangu nɗolu dem, ni nyeneke, n adaɓa. Opoɗo i ta̱ a̱ kuta̱ a Masar, ka̱ta̱ a pala iɗika ya.> >> ");
INSERT INTO asg_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ɗa Haruna u ɗengusa̱i kukiye ku ni, ɗa u sapangi nɗolu m Masar dem, ɗa a̱ uta̱ka̱i n opoɗo a na a palai ubuta̱ dem. ");
INSERT INTO asg_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ɗa oboci e le feu ɗa a yaꞋin nannai n utsura u le, a zuwai opoɗo a̱ uta̱i punu a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ɗa FiriꞋauna u ɗekei Musa n Haruna ɗa u danai le, <<Folonokoi mu Vuzavaguɗu adama a na u takpaka mu ma̱dukpa̱ mo opoɗo ma mpa n uma a̱ va̱, mi ta̱ a̱ kuka̱sukpa̱ uma a̱ nu a wala a bana a yaꞋanka Vuzavaguɗu alyuka.>> ");
INSERT INTO asg_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ɗa Musa u danai FiriꞋauna, <<N neke wu ta̱ tsugbayin. Zagba ayin a na vi cigai n folono Vuzavaguɗu adama a̱ nu n uma a̱ nu, ciya̱ avu m kpaꞋa ku nu yu uvuka m ma̱dukpa̱ mo opoɗo ma, ka̱ta̱ a̱ ka̱sukpa̱ a na i o Kuyene ku Nilu koci.>> ");
INSERT INTO asg_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ɗa FiriꞋauna u danai, <<Mkpa vu nampa.>> Ɗa Musa u danai, <<M pana ta̱, mi ta̱ a kuyaꞋan tsu na vu danai, adama a na vu yeve ta̱ babu vuza na wi lo tsu Vuzavaguɗu Ka̱shile ka̱ tsu. ");
INSERT INTO asg_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Opoɗo a i ta̱ a̱ kuka̱sukpa̱ wu m kpaꞋa ku nu, n aza a̱ gba̱ra̱-gba̱ra̱ a̱ nu, n uma a̱ nu, a na o kokpo koci a ɗaɗa a na i o Kuyene ku Nilu.>> ");
INSERT INTO asg_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ana Musa n Haruna a̱ uta̱i ɗa a̱ ka̱sukpa̱i FiriꞋauna, ɗa Musa u yaꞋin kavasa a kubana u Vuzavaguɗu ciya̱ u takpa ma̱dukpa̱ mo opoɗo ma na u tuka̱i FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ɗa Ka̱shile ka yaꞋin tsu na Musa u folonoi, ɗa opoɗo a na i a kpaꞋa n a na i o oyonto n ashina dem a̱ kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ɗaɗa o ɓolongi opoɗo a otoro-otoro, ali ɗa iɗika ya yo okpoi n ushami. ");
INSERT INTO asg_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ama ana FiriꞋauna we enei ukuna wo opoɗo wa u jebe ta̱, ɗa u doku u yaꞋin ugbamukaci. U panaka Musa n Haruna ba, uteku tsu na Vuzavaguɗu u danai ɗe. ");
INSERT INTO asg_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ɗa Vuzavaguɗu u danai Musa, <<Dana Haruna, <Ɗengusa̱ kalangu ka̱ nu ka̱ta̱ vu lapa iɗika. Kubuta̱ ki iɗika ku na ku ɗa̱nga̱i ki ta̱ o kokpo ikurukpatai a iɗika i Masar ra̱ka̱.> >> ");
INSERT INTO asg_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ɗa ta na a yaꞋin nannai, ana Haruna u ɗengusa̱i kalangu ka̱ ni, ɗa u lapai iɗika ɗa kubuta̱ ku ɗa̱nga̱i. Ɗa ta na ko okpoi ikurukpatai, ɗa ikurukpatai ya i ka̱na̱i kutakacika uma a Masar ra̱ka̱, ali nu nnama n le dem. Ɗa kubuta̱ ki iɗika ka dem ko okpoi ikurukpatai. ");
INSERT INTO asg_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ama ana oboci e le a cigai kuyaꞋan nannai n ciboci ci le, a fuɗa ba. Ko n nannai dem, ɗa ikurukpatai i ka̱na̱i kutakacika uma nu nnama. ");
INSERT INTO asg_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ɗa oboci a danai FiriꞋauna, <<Na va gbani ɗa ba, kukiye ku Ka̱shile ku ɗa.>> Ama ka̱ɗu ka FiriꞋauna ko doku ka gbamasakai, ali ɗa u iwain kupana. Uteku u na Vuzavaguɗu u danai ɗe. ");
INSERT INTO asg_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ɗa Vuzavaguɗu u danai Musa, <<Ɗenga̱ mkpaꞋa n usana, vu gasa n FiriꞋauna ayin a na wi a kubana e kuyene ka, ka̱ta̱ vu dana yi, <Ili i na Vuzavaguɗu u danai i ɗaɗa na, ka̱sukpa̱ uma a̱ va̱ a laza a bana a yaꞋanka mu a̱ga̱nda̱. ");
INSERT INTO asg_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Vu ka̱sukpa̱ baci uma a̱ va̱ a lazai ba, mi ta̱ a̱ kusuꞋuku ɗa̱ n ka̱kuma̱ ka ayun, avu n aza a̱ nu, n aza a̱ gba̱ra̱-gba̱ra̱ a̱ nu dem, n iꞋuwa i le. Punu a iꞋuwa ya aza a Masar yi ta̱ a kushana n ayun, ali a̱ kimba̱i iɗika dem. ");
INSERT INTO asg_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","<<<Ama a kanna ka nanlo, mi ta̱ a kukanza iɗika i Goshon a̱ ubuta̱ u na uma a̱ va̱ i, ayun a kusaꞋwa ɗe ba. Adama a na vi yeve a na mpa Vuzavaguɗu mi ta̱ kpamu punu a iɗika i nampa. ");
INSERT INTO asg_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mi ta̱ a kuzuwa urotu u na u kupecuku uma a̱ va̱ n uma a̱ nu, urotu wi ili i mereve i nampa yi ta̱ a̱ kuta̱wa̱ makpaꞋa.> >> ");
INSERT INTO asg_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ɗa ta na Vuzavaguɗu u yaꞋin nannai. U suꞋuki m ma̱dukpa̱ ma ayun a kubana e kefeku ka FiriꞋauna, n iꞋuwa ya aza a̱ gba̱ra̱-gba̱ra̱ a̱ ni a Masar dem, ɗa iɗika ya kpamu i ka̱na̱i kuna̱mgba̱ n ka̱kuma̱ ka ayun ka. ");
INSERT INTO asg_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ɗa FiriꞋauna u ɗekei Musa n Haruna u danai, <<Banai i yaꞋanka Ka̱shile ka̱ ɗa̱ ka alyuka punu na a iɗika ya.>> ");
INSERT INTO asg_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ɗaɗa Musa u danai, <<Nannai va u yaꞋan ba. Alyuka a na tsa kuyaꞋanka Ka̱shile Vuzavaguɗu vu tsu i ta̱ o kokpo ili yu unata a kubana wa aza a Masar. E ene tsu baci a kuyaꞋan alyuka a ili yu unata n a̱shi e le, i a kuvara tsu n atali ba? ");
INSERT INTO asg_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","U gaꞋan ta̱ ci yaꞋan nwalu n ayin a tatsu e meremune, ci yeve ci yaꞋanka Vuzavaguɗu Ka̱shile ka̱ tsu alyuka tsu na u danai.>> ");
INSERT INTO asg_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ɗa FiriꞋauna u danai, <<N kuka̱sukpa̱ ɗa̱ ta̱ i bana i yaꞋanka Vuzavaguɗu Ka̱shile ka̱ ɗa̱ alyuka e meremune. Ama ka̱ta̱ i bana daꞋin ba, gogo na yaꞋankai mu kavasa biꞋi feu.>> ");
INSERT INTO asg_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ɗa Musa u danai, <<N ka̱sukpa̱ baci na mi ta̱ a kuvasa u Vuzavaguɗu ka̱ta̱ mkpaꞋa u takpa ma̱dukpa̱ ma ayun ma u FiriꞋauna, n aza a̱ gba̱ra̱-gba̱ra̱ a̱ nu, n uma a̱ nu dem. Ama mi ta̱ a kuɓarangu wu, ka̱ta̱ vu doku vi ya̱nsa̱ tsu ba, vu doku vu sa̱nka̱ uma kubana kuyaꞋanka Ka̱shile ke le alyuka ba.>> ");
INSERT INTO asg_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ɗa Musa u ka̱sukpa̱i FiriꞋauna, u banai u yaꞋin kavasa a kubana u Vuzavaguɗu ciya̱ u takpa ma̱dukpa̱ ma. ");
INSERT INTO asg_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Vuzavaguɗu u yaꞋin tsu na Musa u folonoi, ɗa u takpai ma̱dukpa̱ ma ayun ma u FiriꞋauna, n aza a̱ gba̱ra̱-gba̱ra̱ a̱ ni, n uma a̱ ni dem ko kayun ke te ka buwa ba. ");
INSERT INTO asg_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ama FiriꞋauna u doku u yaꞋin ugbamukaci, u ka̱sukpa̱ uma a a laza ba. ");
INSERT INTO asg_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ɗa Vuzavaguɗu u danai Musa, <<Bana u FiriꞋauna vu dana yi ili i na Vuzavaguɗu u danai, <Ili i na Vuzavaguɗu Ka̱shile ka aza Ibirahi ka danai i ɗaɗa na, <<Ka̱sukpa̱ uma a̱ va̱ a laza adama a na a bana a cikpa mu.>> ");
INSERT INTO asg_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ama vi iwan baci kuka̱sukpa̱ le, ɗa vi lyaꞋi kelime n kuka̱na̱ le, ");
INSERT INTO asg_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Vuzavaguɗu wi ta̱ a̱ kusuku m ma̱dukpa̱ a̱ ubuta̱ wi ilikuzuwa i ɗa̱ i na i tsu guɓa, nraɗika, ni njaki, n odoku, n arakuma, n anaka koɓolo ni nkyon. ");
INSERT INTO asg_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ama Vuzavaguɗu wi ta̱ a kukanza kuzuwa ka aza a Isaraila ka̱ta̱ u ka̱sukpa̱ ka aza a Masar, adama a na ko kuzuwa ku te ka aza a Isaraila ki lo a̱ kukuwa̱ ba.> >> ");
INSERT INTO asg_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Vuzavaguɗu u zuwai ayin ɗa u danai, <<MkpaꞋa mi ta̱ a kuyaꞋan ili i nampa punu a iɗika ya.>> ");
INSERT INTO asg_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ana kayin ka asai, ɗa ta na Vuzavaguɗu u yaꞋin nannai. Ɗa kuzuwa ka aza a Masar ra̱ka̱ ku kuwa̱i, ama ko winja u te u kuzuwa wa aza Isaraila u kuwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ɗa FiriꞋauna u zuwai uma adama a na o goɗumo, ɗa a cinai mayun ɗa, ko manama me te ma aza a Isaraila ma̱ kuwa̱ ba. Ama FiriꞋauna u buwa ta̱ n ugbamukaci, u iwain kuka̱sukpa̱ uma a a laza. ");
INSERT INTO asg_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ɗa Vuzavaguɗu u danai Musa n Haruna, <<Shatangi ekiye a̱ ɗa̱ n kokomo ka na ki lo e kenle, ka̱ta̱ Musa u bula̱ngu kaꞋa lo a̱ wunla̱i a̱ a̱shi a FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Kubuta̱ ku kokomo ka ki ta̱ a̱ kuka̱ra̱Ꞌa̱ a iɗika i Masar dem. Ayin a nanlo mɓa̱la̱ ma amici mi ta̱ a̱ kuka̱na̱ ikyamba i uma nu nnama dem, punu a iɗika i Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ɗa e kenuki kokomo e kenle ɗa a lazai a banai a̱ ubuta̱ u FiriꞋauna, ɗa Musa u vishangi kokomo ka a̱ wunla̱i e kelime ka FiriꞋauna, ɗa gogo lo amici a̱ ka̱na̱i yaba dem a̱ ubuta̱ wa ali nu nnama dem. ");
INSERT INTO asg_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ali n oboci a feu a fuɗa a shamgba kelime ka Musa ba, adama a na ele feu amici a̱ ka̱na̱ le ta̱ koɓolo n aza a Masar a na a buwai dem. ");
INSERT INTO asg_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ama ɗa Vuzavaguɗu u doku u zuwai FiriꞋauna u yaꞋin ugbamukaci ɗa u iwain kupanaka le, uteku tsu na Vuzavaguɗu u danai Musa ɗe. ");
INSERT INTO asg_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ɗa Vuzavaguɗu u danai Musa, <<Ɗa̱nga̱ mkpaꞋa n usana vu bana u FiriꞋauna vu dana yi, <Ili i na Vuzavaguɗu u danai i ɗaɗa na, <<Ka̱sukpa̱ uma a̱ va̱ a laza a bana a cikpa mu. ");
INSERT INTO asg_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ko kpamu n gogo na mi ta̱ a̱ kusuꞋuku wu m ma̱dukpa̱, avu n aza gba̱ra̱-gba̱ra̱ a̱ nu, n uma a̱ nu dem. Adama a na vi yeve babu vuza na wi tsu va̱ punu a aduniyan dem. ");
INSERT INTO asg_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Mi ishi baci de m faba wu ɗe n uma a̱ nu m ma̱dukpa̱, vi ishi a kubuwa lo n wuma a aduniyan a nampa ba. ");
INSERT INTO asg_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ama n ka̱sukpa̱ wu ta̱ n wuma adama a na n yotsongu wu utsura u va̱. Ka̱ta̱ uma a sala kula ku va̱ aduniyan ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ama ali n gogo na vu buwai a kucikpa ka̱ci ka̱ nu, ɗa vi iwain kuka̱sukpa̱ le a laza. ");
INSERT INTO asg_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","MkpaꞋa nahannai mi ta̱ o kuyoꞋo mini ma atali ma wuya-wuya ma na ka̱ta̱ a saꞋwai kuyoꞋo ba, ali n ayin a na a yaꞋin iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Dana uma o bonoko n ilikuzuwa i nu n ili i na vi ni ɗa pulai dem a kpaꞋa, adama a na vuza na baci ko manama ma na mi pulai ma na mini ma atali ma saꞋwai mi ta̱ a̱ kukuwa̱.>> > >> ");
INSERT INTO asg_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Aza a gba̱ra̱-gba̱ra̱ a FiriꞋauna o yoku a na i a kupana wovon wi ili i na Vuzavaguɗu u danai, ɗa a yaꞋin gogoꞋo o bonokoi agbashi e le n kuzuwa ku le asuvu a kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ama aza a na a̱ kpa̱ɗa̱i kukeɓece n kadanshi ka Vuzavaguɗu a̱ ka̱sukpa̱i kuzuwa ku le n agbashi e le feu pulai. ");
INSERT INTO asg_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ɗa Vuzavaguɗu u danai Musa, <<Ɗengusa̱ kukiye ku nu a kubana gaɗi adama a na mini ma atali ma̱ yikpa̱ u uma dem nu nnama n ica̱Ꞌa̱shi ya ashina a Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ɗa Musa u ɗengusa̱i kalangu ka̱ ni gaɗi, ɗa Vuzavaguɗu u yaꞋin ulaɗi u gbangam u na u tsu akana ali a̱ kuta̱wa̱ a iɗika, ɗa u lapai akpanga ɗa u yoꞋi mini ma atali a iɗika i Masar dem. ");
INSERT INTO asg_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mini ma atali n ulaɗi ka̱u nannai, u saꞋwa kuyaꞋan a iɗika i Masar ba. Nava ɗaɗa mini ma atali ma gbani-gbani ma na a saꞋwai kuyaꞋan a iɗika i Masar ali n ayin a na e yevei ubuta̱ u nanlo n kula Masar. ");
INSERT INTO asg_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","A iɗika i Masar dem mini ma atali ma̱ la̱nga̱sa̱i ili i na yi e keteshe ra̱ka̱, uma nu nnama dem. Ma̱ la̱nga̱sa̱i ica̱Ꞌa̱shi dem, ali mo koɗosoi nɗanga ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ama ubuta̱ u na u kpa̱ɗa̱i kuyoꞋo mini ma atali ma koci u ɗaɗa Goshon, ubuta̱ u na aza a Isaraila i. ");
INSERT INTO asg_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ɗa FiriꞋauna u suki a bana e ɗeke Musa n Haruna, ɗa u danai, <<Gogo na n yaꞋan ta̱ unushi, Vuzavaguɗu mayun ɗa wi, ama mpa n uma a̱ va̱ ci n ukuna u mayun ba. ");
INSERT INTO asg_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tsu folono wu ta̱ folonoko tsu Vuzavaguɗu, akpanga m mini ma atali ma na Ka̱shile ka̱ suꞋuki tsu va ma yawa tsu ta̱. Mi ta̱ a̱ kuka̱sukpa̱ ɗa̱ i laza gogo na, yo kudoku ya shamgba na ba.>> ");
INSERT INTO asg_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ɗa Musa wu ushuki, <<Gogo na mu uta̱ baci pulai vi likuci mi ta̱ a̱ kuɗa̱ngusa̱ ekiye a̱ va̱ gaɗi n vasa. Ayin a na baci mini ma atali n akpanga a shamgbai vi ta̱ e kuyeve iɗika ya yi ta̱ ekiye a Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ama n yeve ta̱ avu n aza gba̱ra̱-gba̱ra̱ a̱ nu ya kupana wovon u Ka̱shile Vuzavaguɗu ba.>> ");
INSERT INTO asg_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","A ayin a na lo falas m bali a̱ na̱mgba̱ ta̱ ra̱ka̱ adama a̱ mini ma atali ma, bali a̱ kupusa̱ falas tamkpamu a kuyaꞋan a̱pa̱lu. ");
INSERT INTO asg_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ama alkama n ityawan i na̱mgba̱ ba adama a na ayin e kugeꞋwe e le a yawa ba. ");
INSERT INTO asg_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ana Musa u ka̱sukpa̱i ubuta̱ u FiriꞋauna a pulai vi likuci ɗa u ɗengusa̱i ekiye a̱ ni gaɗi, ɗa u ka̱na̱i avasa u Vuzavaguɗu. Ɗaɗa mini ma atali n akpanga a shamgbai, ɗa mini ma̱ ka̱sukpa̱i kuyoꞋo a iɗika ya dem. ");
INSERT INTO asg_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ana FiriꞋauna we ene mini, m mini ma atali n akpanga a ma laza ta̱, ɗa u yaꞋin unushi kpamu. A̱yi n aza a̱ gba̱ra̱-gba̱ra̱ a̱ ni a kpanduki a̱ɗu e le. ");
INSERT INTO asg_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ɗa FiriꞋauna u doku u kpanduki ka̱ɗu ka̱ ni, ɗa u sa̱nka̱i aza a Isaraila ku laza, uteku u na Vuzavaguɗu u danai Musa ɗe. ");
INSERT INTO asg_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ɗa Vuzavaguɗu u danai Musa, <<Bana u FiriꞋauna adama a na mpa m kpanduku ta̱ ka̱ɗu ka̱ ni n aza a̱ gba̱ra̱-gba̱ra̱ a̱ ni, adama a na n yaꞋan ili i mereve i nampa e mere me le, ");
INSERT INTO asg_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","adama a ili i nampa, yi ta̱ a kufuɗa ya dana muku n ɗa̱ nu ntsukaya n ɗa̱ nu n tsu na n yaꞋin wuya-wuya n aza a Masar n tsu na n yaꞋin ili i mereve i va̱. A̱ɗa̱ kpamu ta i kuyeve nannai a na mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ɗa Musa n Haruna a banai u FiriꞋauna ɗa a danai ni, <<Ili i na Vuzavaguɗu Ka̱shile ka aza Ibirahi ka danai i ɗaɗa na, <Ali wannai ɗai va̱ kuka̱sukpa̱ kuyaꞋan a̱ra̱ɗi a kubana a̱ va̱? Ka̱sukpa̱ uma a̱ va̱ a laza, adama a na a bana a cikpa mu. ");
INSERT INTO asg_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Vi iwan baci kuka̱sukpa̱ uma a̱ va̱ a laza, mkpaꞋa mi ta̱ a̱ kutuka̱ n akyuꞋun a iɗika i nu. ");
INSERT INTO asg_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","I ta̱ a kuyimkpa ali a pala iɗika dem ali babu vuza na u kufuɗa we kene iɗika ya, ka̱ta̱ a takuma ilikulyaꞋa i na yi ishi lo i na mini ma atali ma nusai, nu nɗanga n na mi o kugbomguro a ashina a̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","I ta̱ a kushana a iꞋuwa i nu n iꞋuwa ya aza a gba̱ra̱-gba̱ra̱ koɓolo n iꞋuwa ya aza a Masar dem. Ili i nampa ko ikaya i nu ko anan dada a̱ nu n ayin a na a̱ ta̱wa̱i a iɗika i nampa ali a̱ kuta̱wa̱ anana, ka̱ta̱ a saꞋwa kene i ɗa ba.> >> Ɗa Musa u lazai u ka̱sukpa̱i FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ɗa nkoshi m gba̱ra̱-gba̱ra̱ n FiriꞋauna a danai ni, <<Wana ɗai vuma vu nampa u kuka̱sukpa̱ kuzuwaka tsu maza? Ka̱sukpa̱i aza Isaraila a bana a cikpa Ka̱shile Vuzavaguɗu vi le. Gogo na i yeve a na iɗika i Masar i na̱mgba̱i ba?>> ");
INSERT INTO asg_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ɗa o bonokoi Musa n Haruna u FiriꞋauna, ɗa u danai le, <<Yi ta̱ a ku fuɗa ya bana ya cikpa Ka̱shile Vuzavaguɗu vu ɗa̱.>> Ama danai mu, anan yayi a kubana n a̱ɗa̱? ");
INSERT INTO asg_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ɗa Musa wu ushuki, <<Ci ta̱ a kubana ra̱ka̱ vu tsu mma̱ci nu nkoshi m muku mo olobo ni nkere n tsu dem. Ci ta̱ a kuɗika nkyon n tsu nu nraɗika, n anaka adama a na ci ta̱ a kuyaꞋan ka̱ɗiva̱ ka na tsa kucikpa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ɗa FiriꞋauna u danai, <<Vuzavaguɗu ɗa koci u kuɓa̱nka̱ ɗa̱ n ka̱sukpa̱ ɗa̱ baci i bana n a̱ma̱ci a̱ ɗa̱ koɓolo m muku dem, wi ta̱ a kuyaꞋan yi ta̱ n kusheshe ku gbani-gbani. ");
INSERT INTO asg_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","A̱Ꞌa̱ ta nannai ba. Ali a ɗa koci a kubana a yaꞋanka Vuzavaguɗu a̱ga̱nda̱, adama a na ɗaɗa ili i na i folonoi.>> Ɗa o lokoi Musa n Haruna punu a̱ ubuta̱ u FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ɗa Vuzavaguɗu u danai Musa, <<Ɗengusa̱ kukiye ku nu vu sapangu iɗika i Masar adama a na ka̱kuma̱ ka akyuꞋun ka ka pala iɗika ya dem, ka̱ta̱ kpamu a takuma ili i na yi punu a iɗika i Masar dem i na mini ma atali ma nusai.>> ");
INSERT INTO asg_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ɗa Musa u ɗengusa̱i kalangu ka̱ ni a uɓon wi iɗika i Masar, ɗa Ka̱shile ka̱ suki wunla̱i a kasana u ta̱wa̱i punu a iɗika ya n kanna ka nanlo ka n kayin ka̱ ni dem. A kubana usana ɗa wunla̱i u kasana wa u tuka̱i n akyuꞋun. ");
INSERT INTO asg_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ɗaɗa a̱ ka̱ra̱Ꞌi a iɗika i Masar dem a shatangi iɗika ya palili. Ka̱ta̱ a saꞋwa kene icuꞋu i ma̱dukpa̱ i nanlo ba, ili i nanlo kpamu yo kudoku ya̱ ta̱wa̱ a iɗika i nanlo ba. ");
INSERT INTO asg_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ɗa akyuꞋun a a palai ubuta̱ dem ali iɗika i lima̱na̱i adama akyuꞋun. A takumai ica̱Ꞌa̱shi dem n umaci wu nɗanga n na mini ma atali ma nusai. Babu ka̱vuku ka̱ ta̱ku ka̱ mita̱ ko ka maɗanga ka na ka buwai punu a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ɗa FiriꞋauna u yaꞋin gogoꞋo u ɗekei Musa n Haruna ɗa u danai le, <<N nusaka ta̱ Ka̱shile Vuzavaguɗu vu ɗa̱ n a̱ɗa̱ dem. ");
INSERT INTO asg_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Gogo na cinukpakai mu unushi u nampa, ka̱ta̱ i vasa a kubana u Ka̱shile Vuzavaguɗu vu ɗa̱ u takpa atakaci a̱ ukpa̱ a nampa.>> ");
INSERT INTO asg_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ɗa Musa u ka̱sukpa̱i kefeku ka FiriꞋauna ɗa u banai u vasai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ɗa Vuzavaguɗu u sabaꞋi wunla̱i wa u bonokoi u ɗa wunla̱i u ka̱livi wu utsura, u na u pura̱ngi akyuꞋun a a kubana a Mala ma Shili. Ko kakyuꞋun ke te ka buwa a iɗika i Masar ba. ");
INSERT INTO asg_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ama ɗa Vuzavaguɗu u kpandusuki ka̱ɗu ka FiriꞋauna ka kpamu, ali ɗa u sa̱nka̱i aza a Isaraila a kulaza. ");
INSERT INTO asg_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ɗa Vuzavaguɗu u doku u danai Musa, <<Ɗengusa̱ kukiye vu sapangu gaɗi adama a na ka̱yimbi ka kpaɓam ka pala iɗika i Masar dem, ka̱yimbi ka na kpamu ka̱ mikina̱i ali adanshi uma i ta̱ a kufuɗa a saꞋwa kaꞋa.>> ");
INSERT INTO asg_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ɗa ta na Musa u ɗengusa̱i kukiye ku ni u sapangi gaɗi, ɗa ka̱yimbi ka palai Masar kpaɓam, ali ayin a tatsu. ");
INSERT INTO asg_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","A̱ ka̱tsuma̱ ka ayin a nanlo babu vuza na u kene toku ko u bana ubuta̱ u yoku. Ama aza a Isaraila i ta̱ ɗe n kutashi a̱ ubuta̱ u na i dem. ");
INSERT INTO asg_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ɗaɗa FiriꞋauna u suki e ɗekeke yi Musa, ɗa u danai ni, <<Banai i cikpa Vuzavaguɗu. Ko a̱ma̱ci a̱ ɗa̱ m muku n ɗa̱ i ta̱ a kufuɗa a bana n a̱ɗa̱, kuzuwa ku ɗa̱ ku ɗa koci i kuka̱sukpa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ama ɗa Musa u danai, <<Mayun ɗa vu ka̱sukpa̱ tsu tsu bana ci yaꞋan alyuka koɓolo n kuneꞋe ku kusongu u Vuzavaguɗu Ka̱shile ka̱ tsu. ");
INSERT INTO asg_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kuzuwa ku tsu dem ki ta̱ a kubana n a̱ tsu. Babu winja u na u kokpo. Tsa kuyaꞋan ta̱ ulinga n ku yoku a̱ ubuta̱ u kucikpa Vuzavaguɗu Ka̱shile ka̱ tsu. Sai ayin a na ci yawai ɗe, ɗa ce kuyeve ili i na tsa ku cikpaka Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ama ɗa Vuzavaguɗu u doku u zuwai FiriꞋauna u yaꞋin ugbamukaci kpamu, ɗa u sa̱nka̱i le ku laza. ");
INSERT INTO asg_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ɗaɗa FiriꞋauna u danai Musa, <<Ɗenga̱ mu lo! Ka̱ta̱ vu doku vi yawa ɗevu nu mpa kpamu ba! Kanna ka na baci n gasai muku n a̱shi n avu, vi ta̱ a̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ɗa Musa wu ushuki ɗa u danai, <<Tsu na vu danai dem derere ɗa, mpa ma o kudoku ma yawa ɗevu n avu ba.>> ");
INSERT INTO asg_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Gogo na Vuzavaguɗu u danai Musa, <<N kutuka̱ ta̱ ma̱dukpa̱ mo yoku u FiriꞋauna n uma a Masar. Ayin a nanlo, wi ta̱ a̱ kushuku ɗa̱ i laza. U ka̱sukpa̱ ɗa̱ baci i laza, wi ta̱ o kuloko ɗa̱ gbende-gbende. ");
INSERT INTO asg_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Dana uma a Isaraila, ali n a̱ma̱ci dem, o folono aza a Masar a na i ida̱shi koɓolo e neke le ili i na a yaꞋin n azurufa n azanariya.>> ");
INSERT INTO asg_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ɗa Vuzavaguɗu u zuwai aza a Isaraila a̱ ciya̱i wishi e ekiye a aza a Masar. Musa feu n ka̱ci ka̱ ni u ciya̱i tsugbayin ka̱u e ekiye a aza gba̱ra̱-gba̱ra̱ a FiriꞋauna n aza a Masar a na a buwai dem. ");
INSERT INTO asg_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ɗa Musa u danai FiriꞋauna, <<Ili i na Vuzavaguɗu u danai i ɗaɗa na, kayin ke pece baci, mi ta̱ a̱ kuka̱ra̱Ꞌa̱ iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Maku ma iyain me le dem mi ta̱ a̱ kukuwa̱, a̱ gita̱ a maku ma FiriꞋauna, vuza na wi o tsugono, a kubana a maku ma iyain ma kagbashi ka maku ma vuka ma na ma yawai kiya. Ali m maku ma iyain mi ilikuzuwa i na a̱ gita̱i kumatsa dem. ");
INSERT INTO asg_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Uma a Masar ra̱ka̱ i ta̱ a̱ kushika̱ n yoroli u laꞋa tsu na ka̱ta̱ a saꞋwai kuyaꞋan ba. Ili i nanlo yo kudoku ya̱ ta̱wa̱ kpamu ba. ");
INSERT INTO asg_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ama a̱ ka̱tsuma̱ ka aza a Isaraila mesheꞋe ma kuyaꞋanka vuma ko manama wali ba. Ta lo i kuyeve a na Vuzavaguɗu wi a kinda aza a Isaraila kau n aza a Masar. ");
INSERT INTO asg_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Anan taji a̱ nu a nampa ra̱ka̱ i ta̱ a̱ kuta̱wa̱ wa̱ va̱, ka̱ta̱ a̱ kuɗa̱nku mu a dana, <Wala! Laza n uma a̱ nu ra̱ka̱,> Ayin a nanlo, n yeve n laza.>> Ɗa Musa u yaꞋin wupa ka̱u, ɗa u ka̱sukpa̱i FiriꞋauna. ");
INSERT INTO asg_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ɗa Vuzavaguɗu u danai Musa, <<FiriꞋauna wa kupanaka wu ba, adama a na ili i mereve i va̱ i yimkpa n a̱bunda̱i a iɗika i Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa n Haruna a yaꞋin ili i mereve i gbagbaꞋin i nampa dem e kelime ka FiriꞋauna. Ama Vuzavaguɗu u zuwai FiriꞋauna u yaꞋin ugbamukaci. FiriꞋauna u ka̱sukpa̱ aza a Isaraila a laza a̱ ka̱sukpa̱ iɗika i ni ba. ");
INSERT INTO asg_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ele lo biꞋi a Masar va, ɗa Vuzavaguɗu u danai Musa n Haruna, ");
INSERT INTO asg_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ili i na i ɗikai anana, wotoi u nampa u ɗaɗa ɗa̱ wotoi u iyain u ka̱ya̱. ");
INSERT INTO asg_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Salaka aza a Isaraila ra̱ka̱, dana le a kanna ka kupa ko wotoi u nampa, vuma dem u la̱nsa̱ ma̱giri ma na mi ushan u kenu, adama a aza a kpaꞋa a̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","KpaꞋa ku na baci ke enei ka kufuɗa kukotso ma̱giri ma uteku u ni ba, u ɓolongu m kpaꞋa ku na ki ɗevu n a̱yi, e pecuku maꞋa uteku u ka̱bunda̱i ka uma ka na ka kutakuma inyama ya. ");
INSERT INTO asg_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ma̱giri ma na i kuzagba mo okpo ma̱ ka̱ya̱ me te kpamu babu usa̱n, ama wi ta̱ a kufuɗa kokpo maraɗika ko mokyon. ");
INSERT INTO asg_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","I yaꞋan ka̱ɓa̱na̱ ka nlala n nanlo mayin, sai a̱ kulivi ku kanna ka kupa n ka̱ na̱shi o wotoi u iyain u nampa. Ka̱ta̱ yaba dem a Isaraila u kiɗa malala ma̱ ni a kpaꞋa ku ni kafu ubuta̱ u lima̱na̱. ");
INSERT INTO asg_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ka̱ta̱ e kenuku mpasa ma a ɗarukpa akambu n gaɗi vu urotu wu utsutsu u kefeku wi iꞋuwa i le, a̱ ubuta̱ u na a kutakuma inyama ya. ");
INSERT INTO asg_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","N kayin ka nanlo, i zungu nlala ma, ka̱ta̱ i takuma n a̱vuku a na i n okono, m boroji vu babu yisiti kpamu. ");
INSERT INTO asg_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ka̱ta̱ i takuma inyama ya ta̱ku ko usa̱kpi ba, ama i zungu inyama ya ra̱ka̱ koɓolo n kaci n ekpete m ma̱la̱ki dem. ");
INSERT INTO asg_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ka̱ta̱ kagimi ka buwa ali a kubana usana ba. Kagimi ka buwa baci, i songu kaꞋa kafu usana. ");
INSERT INTO asg_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Nannai ɗa ya kutakuma i ɗa, nu ntogu n ɗa̱ u uki, n ataka u uki e ene a̱ ɗa̱, n alangu e ekiye a̱ ɗa̱. Yi ta̱ a kutakuma i ɗa m moloko, adama a na Ka̱ɗiva̱ ka Kupasamgbanai ka Vuzavaguɗu kaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","N kayin ka nanlo, mi ta̱ a̱ kuka̱ra̱Ꞌa̱ ubuta̱ wa aza a Masar, ka̱ta̱ mu una maku ma iyain dem ma aza a Masar, muku n ali n iyain nu nnama n na a̱ gita̱i kumatsa dem. Mi ta̱ a kuyaꞋanka a̱ma̱li a aza a Masar afada. Adama a na mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mpasa n ɗaɗa n kokpo urotu a iꞋuwa i na yi dem. Me ene baci mpasa n nanlo, mi ta̱ a kupasa ɗa̱. Babu ma̱dukpa̱ mu ukpa̱ ma na ma̱ kuciya̱ ɗa̱ a ayin a na baci n tuka̱i aza a Masar n atakaci. ");
INSERT INTO asg_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","<<I kuyongo ta̱ a kuciɓasa n kanna ka nampa a̱ ka̱ya̱ dem. I yaꞋansa ka̱ɗiva̱ ka nampa ka u Vuzavaguɗu, ali a kubana wu ntsukaya n na i kuta̱wa̱ ya matsa ka̱ta̱ wo okpo ɗa̱ wila̱ u na i kutono ayin dem. ");
INSERT INTO asg_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ali ayin e cindere a̱ɗa̱ a kutakuma boroji vu na vi n yisiti ba. Kanna ka iyain, yu uta̱ka̱ n yisiti a iꞋuwa i ɗa̱. Vuza na baci u takumai boroji vu yisiti a̱ ka̱tsuma̱ ka ayin e cindere a nanlo i ta̱ o kuloko yi a̱ ka̱tsuma̱ ka aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A kanna ka iyain ka̱ ka̱ɗiva̱ ka, n kanna ke cindere i yaꞋan oɓolo a ciɗa. Ka̱ta̱ i yaꞋan ulinga a̱ ka̱tsuma̱ ka ayin a nanlo ba, sai de i foɓuso ili i na i ku lyaꞋa koci yi ɗa ya kuyaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ka̱ta̱ i ciɓasa n kanna ka̱ ka̱ɗiva̱ ko boroji vu babu yisiti ka nampa, adama a na a kanna ka nanlo kaꞋa mu uta̱ka̱i ɗa̱ a iɗika i Masar kumaci-kumaci. A̱ kugita̱ anana ali m muku n ɗa̱ nu ntsukaya n ɗa̱ dem, yi ta̱ a kuciɓasa n kanna ka nampa wo okpo ɗa̱ wila̱. ");
INSERT INTO asg_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","O wotoi u iyain a kanna ka ayin kupa n a̱ na̱shi n kulivi i takuma boroji vu babu yisiti, ali a kubana n kulivi ku kanna ka kamanga n ke te. ");
INSERT INTO asg_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","A̱ ka̱tsuma̱ ka ayin e cindere a nanlo, ka̱ta̱ a cina yisiti a iꞋuwa i ɗa̱ ba. Vuza na baci a cinai a kutakuma ili i na yi n yisiti, ko komoci ko a̱ ka̱tsuma̱ ka uma a Isaraila, lokoi ni punu a̱ ka̱tsuma̱ ka uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","A̱ ka̱tsuma̱ ka ayin nanlo a̱ ubuta̱ u na yi ida̱shi dem, ka̱ta̱ i takuma ili i na yi n yisiti ba, i takuma boroji vu na vi babu yisiti.>> ");
INSERT INTO asg_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ɗa Musa u ɗekei nkoshi m gba̱ra̱-gba̱ra̱ mi Isaraila dem, ɗa u danai le, banai i zagba nlala n na i kukiɗa n limata i kpaꞋa i ɗa̱ ma̱ ka̱ɗiva̱ ma Kupasamgbanai. ");
INSERT INTO asg_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Yaba dem u tsuwa̱n mpasa m malala ma̱ ni a masasu. Ka̱ta̱ u pitiku una̱ u izobu punu a mpasa ma. U yeve u vishangu a̱ utsutsu u kefeku, gaɗi n akambu dem. Ka̱ta̱ vuza wu uta̱ utsutsu u kefeku u kpaꞋa u ni ba, ali a kubana usana. ");
INSERT INTO asg_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ayin a na baci Vuzavaguɗu wi a̱ kuka̱ra̱Ꞌa̱ adama a na wu una aza a Masar, wi ta̱ e kene mpasa gaɗi n akambu a̱ utsutsu u kefeku u ɗa̱, ka̱ta̱ u pasa u ka̱sukpa̱ ɗa̱. U kuka̱sukpa̱ kuni ka ka uwa a iꞋuwa i ɗa̱ ka̱ta̱ wu una ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","I tono ili i nampa adama a na yo okpo ili i kutono i ɗa̱ nu ntsukaya n ɗa̱, ayin dem. ");
INSERT INTO asg_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ayin a na baci i yawai a iɗika i na Vuzavaguɗu u yaꞋankai ɗa̱ uzuwakpani u kuneke ɗa̱, ka̱ta̱ i lyaꞋa kelime n kuciɓasa n ka̱ɗiva̱ ka nampa. ");
INSERT INTO asg_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Muku n ɗa̱ me ece ɗa̱ baci, <<Yiɗa̱i ka̱ɗiva̱ ka nampa ka ki o kuyotsongusu?>> ");
INSERT INTO asg_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ka̱ta̱ i dana le, na va ka̱ɗiva̱ ka kupasamgbanai ka alyuka ka na Vuzavaguɗu wu uta̱ka̱i tsu a iɗika i Masar. Ɗa wu unai aza a Masar ama ɗa u ka̱sukpa̱i iꞋuwa i tsu. Ɗa uma a̱ kuɗa̱ngi ɗa a cikpai ni. ");
INSERT INTO asg_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ɗa aza a Isaraila a yaꞋin derere tsu na Vuzavaguɗu u danai Musa n Haruna. ");
INSERT INTO asg_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","N kayin ka gbayin, ɗa Vuzavaguɗu wu unai ngaji ma aza a Masar ra̱ka̱. U gita̱i m magaji ma FiriꞋauna vuza na wi ida̱shi a kakuba ko tsugono, ali a kubana a magaji ma vuza na wi ɗe ushiyi a̱ kunu ku ugbashi, koɓolo m muku n iyain mi ilikuzuwa ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","FiriꞋauna n anan taji a̱ ni koɓolo n aza a Masar ra̱ka̱ a̱ ɗa̱nga̱i n kayin, ɗa a̱ ka̱na̱i ma̱shi n yoroli a iɗika i Masar ra̱ka̱, adama a na ukpa̱ u kawuriya u ɗa. ");
INSERT INTO asg_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","FiriꞋauna u suki a bana e ɗeke Musa n Haruna n kayin ka nanlo, u danai, <<Ɗenga̱i i Ka̱sukpa̱ka̱ mu uma a̱ va̱, a̱ɗa̱ n uma a̱ ɗa̱ aza a Isaraila yaꞋin tsu na i danai va, banai i cikpa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ɗikai kuzuwa ku ɗa̱ n ushiga wu nlala n anaka tsu na vu danai. Ama ka̱ta̱ i zuwaka mu una̱singai biꞋi, ka̱ta̱ i laza.>> ");
INSERT INTO asg_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ɗa ta na aza a Masar a gbagbalai uma a a yaꞋan moloko a̱ uta̱ punu a iɗika, ɗa a danai, <<Ta baci nannai ba, ci ta̱ a̱ kukuwa̱ ra̱ka̱.>> ");
INSERT INTO asg_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Uma a Isaraila a ɗikai kiya ku na ki uzuɓuki n yisiti ba, ɗa a̱ tsungi ku ɗa nvene n le ɗa a̱ ka̱ta̱la̱i punu a ucanuku u le, ɗa o woki a avangatsu e le. ");
INSERT INTO asg_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ɗa aza a Isaraila a yaꞋin tsu na Musa u danai le a yaꞋan. Ɗaɗa e ecei aza a Masar ili ya azurufa, koɓolo n azanariya, koɓolo n aminya. ");
INSERT INTO asg_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Vuzavaguɗu u zuwai aza a Isaraila a̱ ciya̱i wishi a̱ ubuta̱ wa aza a Masar. Ɗa e nekei le ili i na e ecei le dem. Ta aza a Isaraila a̱ pura̱i uciyi n a̱bunda̱i wa aza a Masar nannai. ");
INSERT INTO asg_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ɗa uma a Isaraila a̱ ɗa̱nga̱i a̱ ka̱sukpa̱i Ramase, a̱ ka̱na̱i uye a kubana o Sukotu. Ka̱bunda̱i ka uma ka na a walai e ene ele ɗa a̱kpa̱n amangatawa̱nta̱li (600,000) ali biꞋi koci, babu a̱ma̱ci m muku. ");
INSERT INTO asg_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ka̱bunda̱i ka uma ka aza na i aza a Isaraila ba, ɗa o tonoi le, ushiga wa anaka nu nlala u tonoi le feu. ");
INSERT INTO asg_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ɗa a yaꞋin boroji vu na vi yisiti ba n kiya ku na a̱ uta̱ka̱i a iɗika i Masar. Boroji vu babu yisiti, adama na uta̱ka̱ le ta̱ m moloko a iɗika i Masar, a̱ ciya̱ o foɓusoko ka̱ci ke le ilikulyaꞋa ko boroji ba. ");
INSERT INTO asg_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Muku mi Isaraila a̱ da̱sa̱ngu ta̱ a iɗika i Masar, ali a̱ya̱ amangatawa̱na̱shi n kamangankupa (430). ");
INSERT INTO asg_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A kanna ku ukocishi ka̱ a̱ya̱ amangatawa̱na̱shi n kamangankupa (430) ka nanlo, ɗaɗa Vuzavaguɗu wu uta̱ka̱i n uma a̱ ni a iɗika i Masar ka̱tsura̱-ka̱tsura̱. ");
INSERT INTO asg_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","N kayin ka nanlo ka ɗa Vuzavaguɗu u zuwai a̱shi adama a na wu uta̱ka̱ le a iɗika i Masar. Kayin ka nampa, ka Vuzavaguɗu kaꞋa, adama a nannai aza a Isaraila ra̱ka̱ i ta̱ a kuzuwaka kayin ka nanlo ka a̱shi ali a kubana wu ntsukaya n na n kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ɗa Vuzavaguɗu u danai Musa n Haruna, na va ɗaɗa wila̱ u ka̱ɗiva̱ ka kupasamgbanai, Ka̱ta̱ i ka̱sukpa̱ komoci ka lyaꞋa ilikulyaꞋa ya ba. ");
INSERT INTO asg_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ama kagbashi dem ka na i tsulai wi ta̱ a kufuɗa wa lyaꞋa ilikulyaꞋa ya, wi baci n ukiɗi u kavaja. ");
INSERT INTO asg_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Komoci ka na baci ka̱ cipa̱i wa̱ ɗa̱ ko vuza zamalinga, wa kulyaꞋa ilikulyaꞋa ya ba. ");
INSERT INTO asg_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","<<I takuma inyama ya punu a asuvu a kpaꞋa ku te, ka̱ta̱ a̱ uta̱ka̱ n i ɗa pulai ba, ka̱ta̱ kpamu i takuma inyama ya i ɓoso etele a ba. ");
INSERT INTO asg_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Uma a Isaraila ra̱ka̱ a yaꞋansa ka̱ɗiva̱ ka nampa. ");
INSERT INTO asg_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Komoci ka na baci ki punu ida̱shi n a̱ɗa̱ ɗa u cigai kuyaꞋan feu ka̱ɗiva̱ ka kupasamgbanai ka Vuzavaguɗu, mayun ɗa maku ma vali ma na mi a kpaꞋa ku ni dem u ciya̱ ukiɗi u kavaja. Ka̱ta̱ ayin a nanlo u yeve u uwa a̱ ubuta̱ u ka̱ɗiva̱ wa koɓolo n a̱ɗa̱, wo okpo ta̱ vuza likuci feu. Mavali dem ma na a kiɗai kavaja ba, ka̱ta̱ u lyaꞋa ilikulyaꞋa ya ba. ");
INSERT INTO asg_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Wila̱ u ka̱na̱ ta̱ yaba dem ko vuza likuci ko komoci ka na ki punu ida̱shi n a̱ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ɗa muku mi Isaraila n yaꞋin tsu na Vuzavaguɗu u danai Musa n Haruna. ");
INSERT INTO asg_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","A kanna ka nanlo ka ɗa Vuzavaguɗu wu uta̱ka̱i m muku mi Isaraila a iɗika i Masar, ka̱tsura̱-ka̱tsura̱. ");
INSERT INTO asg_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","<<Maku ma iyain ma vuma ma aza a Isaraila, ko vuma ko manama, ma̱ va̱ maꞋa, vu neke maꞋa a kubana wa̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ɗa Musa u danai uma a, <<Ciɓasai n kanna ka nampa ka na yu uta̱i a iɗika i Masar, a̱ ubuta̱ wu ugbashi, n utsura u Vuzavaguɗu wu uta̱ka̱i ɗa̱, ɗa u tuka̱i ɗa̱ na. Ka̱ta̱ i takuma boroji vu na vi n yisiti ba. ");
INSERT INTO asg_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","A kanna ka nampa ko wotoi u Abibu ka ɗaɗa yu uta̱i a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","A ayin a na baci Vuzavaguɗu u bankai ɗa̱ a iɗika i uma i KanaꞋana, n Hitiya n Amoriya n Hiviya n Jebusiya, i na u kucinakai ikaya i nu u kuneke wu i ɗa. Iɗika i na yi m maniꞋin n tsuta̱, ka̱ta̱ vi yaꞋan ka̱ɗiva̱ vu ciɓasa n kanna ko wotoi ka nampa ka a̱ ka̱ya̱ dem. ");
INSERT INTO asg_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","I takuma boroji vu na a yaꞋin n yisiti ba ali ayin e cindere, a kanna ke cindere, i yaꞋan ka̱ɗiva̱ ka u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Yi ta̱ a kutakuma boroji vu babu yisiti va ali ayin e cindere, a̱ ka̱tsuma̱ ka ayin a nanlo, ka̱ta̱ a cina ili i na yi n yisiti a̱ ka̱tsuma̱ ka̱ ɗa̱, ko punu a̱ ubuta̱ u na yi dem ba. ");
INSERT INTO asg_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","A kanna ka nanlo ka ɗa va kudana maku ma̱ nu, <Ili i na i zuwai ɗa mi kuyaꞋan ka̱ɗiva̱ ka nampa ka, ka ɗaɗa adama a ili i na Vuzavaguɗu u yaꞋankai mu, wu utuka̱i mu a iɗika i Masar.> ");
INSERT INTO asg_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ka̱ɗiva̱ ka nampa ki ta̱ o kokpo an urotu e kukiye ku nu, n ili i kuciɓasa kpamu a̱ kuca̱n ku nu adama a na wila̱ u Vuzavaguɗu u yongo punu a̱ ka̱ɗu ka̱ nu, ka̱ta̱ vu dansa n una̱ u nu. Adama a na Vuzavaguɗu ɗa wu utuka̱i nu a iɗika i Masar n utsura u gbayin. ");
INSERT INTO asg_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Yi ta̱ a kuciɓasa n kanna ka̱ ka̱ɗiva̱ ka nampa ka a ayin a na a zuwai, a̱ ka̱ya̱ lakam. ");
INSERT INTO asg_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","<<Ayin a na baci Vuzavaguɗu u tuka̱i ɗa̱ a iɗika i KanaꞋana, ɗa u nekei ɗa̱ i ɗa, uteku tsu na u yaꞋin uzuwakpani n a̱ɗa̱ n ikaya i ɗa̱ u kuneke ɗa̱ ta̱ iɗika ya, ");
INSERT INTO asg_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ka̱ta̱ i neke Vuzavaguɗu umaci u iyain u muku n ali n vuma, koɓolo n umaci u iyain u muku n ali wu nnama adama a na n Vuzavaguɗu n ɗa. ");
INSERT INTO asg_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kogono ka majaki dem ka na a̱ gita̱i kumatsa vi ta̱ a kufuɗa va tsupa m maku ma malala. Ama vi ciga baci kuyaꞋan nannai ba, vu koɗo majaki ma kuɗeku. Ama maku ma vuma dem vi ta̱ a kufuɗa va tsupa maꞋa. ");
INSERT INTO asg_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","<<A kubana a ayin o yoku maku ma̱ nu me ece wu baci, <Yiɗa̱i na va?> U shuku yi, <N utsura u Vuzavaguɗu u ɗa wu uta̱ka̱i tsu a iɗika i Masar, a̱ ubuta̱ u na ci ishi a tsugbashi. ");
INSERT INTO asg_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ana FiriꞋauna u yaꞋin ugbamukaci, ɗa u iwain kuka̱sukpa̱ tsu tsu laza. Ɗa Vuzavaguɗu wu unai muku n ali n na a̱ gita̱i kumatsa n vuma nu nnama dem a Masar. I ɗaɗa i zuwai ɗa ci a kuyaꞋanka muku n iyain mu nnama alyuka u Vuzavaguɗu. Ka̱ta̱ tsu tsupaka maku ma iyain ma vuma dem a̱ ubuta̱ u Vuzavaguɗu.> ");
INSERT INTO asg_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Na va wi ta̱ o kokpo an urotu e kukiye ku nu n ili i kuciɓasa a̱ kuca̱n ku nu, a na Vuzavaguɗu wu uta̱ka̱i tsu a iɗika i Masar n utsura u gbayin u kukiye ku ni.>> ");
INSERT INTO asg_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ana FiriꞋauna u ka̱sukpa̱i uma a lazai, Ka̱shile ka̱ ka̱sukpa̱ le o tono n uye wa asuvu ba, u na u walai a iɗika ya aza a̱ Filisitiya. Adama a na Ka̱shile ka dana ta̱, <<I ta̱ a kufuɗa kusabaꞋa a̱ɗu e le ka̱ta̱ a suma o kubono a Masar ayin a na baci e enei kuvon.>> ");
INSERT INTO asg_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ɗa Ka̱shile ko tonoi n ele a uye u na u tonoi m meremune u na u walai a Mala ma Shili. Ayin a na aza a Isaraila a̱ ka̱sukpa̱i Masar i ta̱ ufoɓushi a na osoji o kuvon. ");
INSERT INTO asg_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ɗa Musa u ɗikai etele a̱ Isufu, adama a na a̱yi Isufu u zuwa ta̱ ɗe muku mi Isaraila a kucina u danai, <<Mayun Vuzavaguɗu wi ta̱ a̱ kuta̱wa̱ wa̱ ɓa̱nka̱ ɗa̱, ka̱ta̱ i ɗika etele a̱ va̱ ayin a na baci yi a kulaza kuka̱sukpa̱ ubuta̱ u nampa.>> ");
INSERT INTO asg_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ɗa muku mi Isaraila n ka̱sukpa̱i Sukotu, ɗa a banai a̱ da̱sa̱ngi e Etam a̱ ka̱kina̱ kafu a uwa e meremune. ");
INSERT INTO asg_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","N kanna Vuzavaguɗu u tsu wala ta̱ kelime ke le n kabashi ke keleshu adama a na u yotsongu le uye, n kayin tamkpamu u wala n ele n kabashi ke keleshu ka kutashi ka akina. Adama a na e ene ubuta̱, ciya̱ a fuɗa a yaꞋan nwalu n le n kanna n kayin dem. ");
INSERT INTO asg_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Vuzavaguɗu u takpa kabashi ke keleshu n kanna ko ka kutashi ka akina n kayin a̱ ubuta̱ u uma a̱ ni ba. ");
INSERT INTO asg_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ɗaɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","<<Dana aza a Isaraila a kpatala o bono ka̱ca̱pa̱ a vaku a Pi-hahiro ɗevu n likuci i Bal-zefon. Ubuta̱ wa wi ta̱ e mere ma̱ likuci i Magidolu m mala. ");
INSERT INTO asg_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","FiriꞋauna u sheshe ta̱, <Uma a Isaraila i ta̱ ɗe a̱ kuka̱ra̱Ꞌa̱sa̱ keberiketi a iɗika ya, meremune ma̱ ka̱na̱i le ta̱.> ");
INSERT INTO asg_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mi ta̱ a kuzuwa FiriꞋauna u yaꞋan ugbamukaci, wi ta̱ a kuguva le, utsura u na n kulyaꞋa FiriꞋauna n osoji a̱ ni wi ta̱ o kokpo ukuna u tsugbayin a kubana wa̱ va̱. Nannai ɗa aza a Masar e kuyeve a na mpa ɗa Vuzavaguɗu.>> Ɗa aza Isaraila a yaꞋin tsu na a danai le. ");
INSERT INTO asg_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ana a danai mogono ma Masar uma a a laza ta̱, a̱yi n aza a̱ gba̱ra̱-gba̱ra̱ a̱ ni a yaꞋansakai a̱ɗu e le ɗa a danai. <<Yiɗa̱i i zuwai ɗa ci yaꞋin ili i tsulau nannai, ɗa tsu ka̱sukpa̱i aza a Isaraila a lazai? Ɗa tso okpoi na babu aza a na a kuyaꞋanka tsu tsugbashi!>> ");
INSERT INTO asg_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ɗa FiriꞋauna u zuwai o foɓusoi ekeke o odoku o kuvon a̱ ni n osoji a̱ ni kpamu. ");
INSERT INTO asg_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ɗa u ɗikai ekeke o odoku o kuvon amangatawa̱nta̱li (600) a singai, koɓolo n ekeke o odoku a Masar a na a buwai dem. Yaba dem n kovonshi vi ni. ");
INSERT INTO asg_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ɗa Vuzavaguɗu u doku u zuwai FiriꞋauna mogono ma Masar ma yaꞋin ugbamukaci, adama a nannai, ɗa u ka̱na̱i kukiyangu aza a Isaraila a na i a kulaza n ka̱ɗu ke le ida̱shi. ");
INSERT INTO asg_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ɗaɗa aza a Masar n ekeke o odoku o kuvon a FiriꞋauna ra̱ka̱, n aza a na a tsu kumba odoku a. A kiyangi aza a Isaraila ɗa a cinai le a vaki a̱ ka̱kina̱ ka Mala ma Shili ɗevu m Pi-hahiro a kapashi ko yoku ka Bal-zefon. ");
INSERT INTO asg_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ana FiriꞋauna wi a kuyawa ɗevu, ɗa aza a Isaraila a kpatalai a̱shi ɗa enei aza a Masar a̱ kuta̱wa̱ a̱ ka̱ca̱pa̱ ke le. Ɗa wovon u ka̱na̱i le n a̱bunda̱i, ɗa a lapai una̱ a kubana u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ɗa aza a Isaraila a danai Musa, <<Yiɗa̱i i zuwai ɗa vi yaꞋankai tsu nannai, vu uta̱ka̱i tsu a iɗika i Masar, vu tuka̱i tsu na adama a na tsu kuwa̱ e meremune? Asaun i ɗe a Masar a na a̱ kuciɗa̱ngu tsu ba? Yiɗa̱i i zuwai ɗa vu zuwai tsu tsu ka̱sukpa̱i iɗika i Masar? ");
INSERT INTO asg_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tsu dana wu ukuna u nampa a̱ tsu biꞋi na ɗe a Masar ba? Wi ishi ta̱ a kulaꞋa n kugaꞋan vu ka̱sukpa̱ tsu ci yaꞋanka aza a Masar tsugbashi, an tsa̱ kuwa̱ na e meremune.>> ");
INSERT INTO asg_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ama Musa u danai uma a, <<Ka̱ta̱ i pana wovon ba. Shamgbai de bini a̱ ubuta̱ u na yi de dem, Vuzavaguɗu wi ta̱ a kisa ɗa̱ anana. Uteku n anana yo kudoku ye kene aza a Masar a nampa ba. ");
INSERT INTO asg_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Vuzavaguɗu n ka̱ci ka̱ ni wi ta̱ a̱ kushilika̱ka̱ ɗa̱, a̱ɗa̱ ka̱ta̱ i yaꞋan ili i yoku ba.>> ");
INSERT INTO asg_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ɗaɗa Vuzavaguɗu u danai Musa, <<Yiɗa̱i i zuwai ɗa vi a̱ kushiꞋa̱ka̱ mu? Dana uma a lyaꞋa kelime nu nwalu. ");
INSERT INTO asg_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ka̱ta̱ vu ɗengusa̱ kalangu ka̱ nu vu sapangu mala ma, ma mi ta̱ e kupece adama a na aza Isaraila a wala punu e mere a iɗika yu uɗekpu. ");
INSERT INTO asg_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mi ta̱ a kuzuwa aza a Masar o okpo n ugbamukaci ka̱u ali ka̱ta̱ a̱ ɗa̱nga̱ adama a na o tono le. A ayin a nanlo ɗa ma̱ kuciya̱ tsugbayin a̱ ubuta̱ u FiriꞋauna n osoji a̱ ni dem n ekeke o odoku a̱ ni n akumbi e ekeke o odoku a feu. ");
INSERT INTO asg_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","A ayin a na baci n ciya̱i tsugbayin u FiriꞋauna n ekeke o odoku a̱ ni ali n akumbi e le, ɗaɗa aza a Masar e kuyeve a na mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kalingata ka̱ Ka̱shile ka na ka tsu wala kelime ka aza o kuvon a Isaraila, ɗa u bonoi ka̱ca̱pa̱ ke le. Ɗa feu kabashi ke keleshu ka na ki o kutono le va feu ke sheruwengi ko bonoi ka̱ca̱pa̱ ke le. ");
INSERT INTO asg_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ɗa keleshu ka ka shamgbai e mere ma aza a Masar n aza a Isaraila. E kuneke ka̱yimbi a kakambu ka aza a Masar, kutashi tamkpamu a kakambu ka aza a Isaraila. Ta keleshu ke pecei uma a nannai n kayin babu uteku u na a kuyawanai ɗeɗevu. ");
INSERT INTO asg_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ɗa Musa u tsu ɗengusa̱ kukiye ku ni a gaɗi vu mala. Ɗa Vuzavaguɗu u suki n wunla̱i wu utsura u kasana u na u gita̱i kulapa a̱ ka̱tsuma̱ ka kayin ka nanlo dem, ali ɗa mini ma me pecei ugboku u re. Ɗa mere ma mo okpoi uɗekpu. ");
INSERT INTO asg_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ɗa aza a Isaraila a walai punu e mere a mala ma a iɗika i ɗekpu m mashilya ma̱ mini a kakambu ku usingai n ku ugula̱ dem. ");
INSERT INTO asg_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ɗa aza a Masar a kiyangi le, koɓolo n odoku a FiriꞋauna, koɓolo n ekeke o odoku o kuvon n akumbi a, ɗa o tonoi le a kuꞋuwa punu e mere ma mala ma. ");
INSERT INTO asg_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ama n usana ka̱u kafu kayin ka asa, ɗa Vuzavaguɗu ɗe gaɗi vi keleshu ka akina ɗa u la̱na̱ki osoji a aza a Masar, ɗa u ka̱na̱i kuzuwa wovon a̱ a̱ɗu e le, ɗa a̱ ripula̱i. ");
INSERT INTO asg_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ɗa anci e ekeke e le a̱ ka̱na̱i kuliɓa o kolyoꞋo, o doku a fuɗa a wala ba. Adama a nannai, ɗa aza a Masar a̱ ka̱na̱i ku dananai, <<YaꞋan tsu suma tsu ka̱sukpa̱ uma a nanlo nannai, adama a na Vuzavaguɗu wi ta̱ a̱ vishili n a̱ tsu adama e le.>> ");
INSERT INTO asg_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ɗaɗa Vuzavaguɗu u danai Musa, <<Ɗengusa̱ kukiye ku nu a gaɗi vu mini va adama a na mo bono ma pala aza a Masar ra̱ka̱ n ekeke o odoku e le koɓolo n akumbi o odoku a dem.>> ");
INSERT INTO asg_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ubuta̱ biꞋi ka̱li-ka̱li ɗa Musa u ɗengusa̱i kukiye ku ni ɗa u sapangi mala, gogo lo ɗa mini mo bonoi uteku u na ma mi ishi. Aza a Masar a gbagbalai adama a na a isa ka̱ci ke le, ɗa Vuzavaguɗu u niꞋwa̱nta̱ngi le punu ra̱ka̱ a mala ma. ");
INSERT INTO asg_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ɗa mini ma mo bonoi ɗa ma palai ekeke o odoku a FiriꞋauna n akumbi a dem koɓolo n osoji a FiriꞋauna a na o tonoi aza a Isaraila a kuꞋuwa a mala ma. Ko vuza te u laꞋa ba. ");
INSERT INTO asg_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ama aza a Isaraila a walai a iɗika i ɗekpu, ɗa mini ma ma yaꞋin nshilya n re me te a̱ ugula̱ me te a usingai. ");
INSERT INTO asg_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","A kanna ka nanlo, ɗa Vuzavaguɗu wi isai aza a Isaraila e ekiye aza a Masar. Ɗa aza a Isaraila e enei even a ikyamba ya aza a Masar a̱ ka̱kina̱ ka mala ka. ");
INSERT INTO asg_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ana aza a Isaraila e enei utsura u gbangam u na Vuzavaguɗu u yotsongi aza a Masar, ɗa a panai wovon u Vuzavaguɗu. Ɗa o doku ɗa e nekei a̱ɗu e le u Vuzavaguɗu m Musa kagbashi ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ɗa Musa n aza a Isaraila a yaꞋin vishipa vu nampa va a kubana a̱ ubuta̱ u Vuzavaguɗu, mi ta̱ a kuyaꞋan vishipa vu kucikpa Vuzavaguɗu, adama a na a̱yi ɗa u ciya̱i ulyaꞋi u gbayin. U vakangi kodoku n kakumbi ka̱ ni dem a mala. ");
INSERT INTO asg_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Vuzavaguɗu ɗa katsura ka̱ va̱ a̱yi ɗa kpamu vishipa vu va̱, a̱yi ɗa wishi u va̱. A̱yi ɗa Ka̱shile ka̱ va̱, mi ta̱ a kucikpa yi, Ka̱shile ke esheku a̱ va̱, n kucikpa yi ta̱. ");
INSERT INTO asg_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Vuzavaguɗu kovonshi kaꞋa, kula ku ni ku ɗa feu Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ekeke o odoku a FiriꞋauna n osoji a̱ ni, u vakangi le a mala. Aza a̱ gba̱ra̱-gba̱ra̱ a uzagbi a FiriꞋauna u niꞋwa̱nta̱ngi le a Mala ma Shili. ");
INSERT INTO asg_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ɗa mini mu uga̱vi ma palai le, ɗa a liɓai sai ɗaka tsu katali. ");
INSERT INTO asg_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Kukiye ku singai ku nu Vuzavaguɗu ki ta̱ n tsugbayin n utsura, n kukiye ku singai ku nu ku ɗaɗa vu la̱nga̱sa̱i irala. ");
INSERT INTO asg_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","N tsugbayin tsu utsura tsu nu tsu ɗa vu poloi aza a na i a tsurala n avu. Ɗa vu tsunki le wupa u nu, vu songi le n akina a̱ nu tsu mita̱ me ɗekpu. ");
INSERT INTO asg_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","N utsura wa ayinviki a na a̱ uta̱i a̱ vunu vu nu, ɗa mala mo ɓolongi a̱ ubuta̱ u te. Mini ma̱ a̱bunda̱i mo bonoi ma yaꞋin mashilya, mala ma̱ kutsa̱i an katali e mere ma mala ma. ");
INSERT INTO asg_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","<<Vurala vi le vu danai, <N kusaɓa le ta̱, n kulyaꞋa le ta̱, n ku pecuku ta̱ ucanuku wa, n kuɗika ta̱ ili i na mi a kuciga, n kutala ta̱ kotokobi ka̱ va̱ ka̱ta̱ ekiye a̱ va̱ a una le.> ");
INSERT INTO asg_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ama ɗa vu uvula̱i n ayinviki a̱ nu, ɗa mala ma palai le, ɗa a liɓai tsu ka̱ta̱mba̱ punu a̱ mini ma gbayin. ");
INSERT INTO asg_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","<<Yayi a̱ ka̱tsuma̱ ka̱ a̱ma̱li wi uteku tsu nu Vuzavaguɗu? Yayi wi uteku tsu nu a̱ ka̱tsuma̱ ka tsugbayin n ciɗa, n utsura n tsugbayin a kuyaꞋan ili i mereve? ");
INSERT INTO asg_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Vu ba̱ra̱kpa̱i kukiye ku usingai ku nu ɗa iɗika i soɗongi le. ");
INSERT INTO asg_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","<<N ucigi u gbayin u nu u ɗa vu ci yaꞋan kaguɓa ka uma a̱ nu a na vi isai. A̱ ka̱tsuma̱ ku utsura u nu u ɗa va kuguɓa le a kubana ubuta̱ wi ida̱shi u ciɗa u nu. ");
INSERT INTO asg_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Iɗika kakau yi ta̱ a kupana ka̱ta̱ i dagaza, una̱mgbi u ka̱tsuma̱ u ka̱na̱ ta̱ aza a Filisitiya. ");
INSERT INTO asg_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ngono n Edom mi ta̱ a kudagaza, aza a̱ gba̱ra̱-gba̱ra̱ a Mowabu i ta̱ a̱ kulima̱ adama atakaci, aza KanaꞋana i ta̱ a̱ kuniꞋwa̱n, ");
INSERT INTO asg_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","wovon n udagaji wi ta̱ a kuka̱na̱ le. Ama adama a utsura u kukiye ku nu, i ta̱ a kushamgba n utsura an katali, ali sai ayin a na uma a̱ nu a lazai, Vuzavaguɗu, ali sai ayin a na uma a na vu uta̱ka̱i a lazai. ");
INSERT INTO asg_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Vi ta̱ a̱ kuɗika le ka̱ta̱ vu shikpa̱ le, a kusan ku nu, ubuta̱ u na avu Vuzavaguɗu vu lapulukai ka̱ci ka̱ nu, A̱ A̱Ꞌisa̱ a na avu Vuzavaguɗu, vu lapulukai ka̱ci ka̱ nu. ");
INSERT INTO asg_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Vuzavaguɗu wi ta̱ a kulyaꞋa tsugono, ali ayin babu uteku.>> ");
INSERT INTO asg_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ana odoku a FiriꞋauna n ekeke o odoku n akumbi e le a uwai a mala ma, ɗa Vuzavaguɗu u bonokoi m mini ma, u palai le m maꞋa, ama aza a Isaraila a walai a iɗika i ɗekpu punu e mere ma mala ma. ");
INSERT INTO asg_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ɗa taku vu Haruna Miriyamu keneki, u ɗikai ma̱ka̱nlu e ekiye a̱ ni ɗa ta na a̱ma̱ci n a̱bunda̱i o tonoi ni, a̱ ka̱na̱i tsuwaꞋi n e jeꞋi. ");
INSERT INTO asg_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ɗa Miriyamu u yaꞋin vishipa vu nampa, <<Ci yaꞋankai Vuzavaguɗu vishipa, adama a na a̱yi ɗa u ciya̱i ulyaꞋi u gbayin. A̱yi ɗa u niꞋwa̱nta̱ngi odoku n akumbi e le dem a mala.>> ");
INSERT INTO asg_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ɗaɗa Musa u tonoi n aza a Isaraila, ana a̱ ka̱sukpa̱i Mala ma Shili, ɗa u zuwai le a wala e meremune ma na e ci ɗeke Shuru. A yaꞋan ta̱ ayin a tatsu, ele a kuwala e meremune ma nanlo ama e ene mini ba. ");
INSERT INTO asg_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ana a yawai a Mara a fuɗa o soꞋo mini ma ba, adama a na mini ma mi ta̱ n okono. (I ɗaɗa i zuwai ɗa e ɗekei ubuta̱ wa Mara.) ");
INSERT INTO asg_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ɗa uma a yaꞋankai Musa mololo, a danai, <<Yiɗa̱i tsa ɗamgba tso soꞋo?>> ");
INSERT INTO asg_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ɗa Musa u shiꞋika̱i Vuzavaguɗu, ɗa Vuzavaguɗu u yotsongi ni kacaka ka maɗanga. Ɗa u ɗikai u vakangi kaꞋa punu a̱ mini ma, ɗa mini ma mo bonoi uyoꞋo. A̱ ubuta̱ wa ɗe ɗa Vuzavaguɗu u nekei le kupiꞋisa n wila̱, ɗa kpamu u kondoi le. ");
INSERT INTO asg_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ɗa u danai, <<I pana baci ka̱la̱ka̱tsu ka Vuzavaguɗu Ka̱shile ka̱ ɗa̱ mayin, ɗa i yaꞋin ili i na i gaꞋin ni kpamu, ɗa i tonoi ili i na u danai derere. Ɗa kpamu i tonoi wila̱ u ni ra̱ka̱, mpa mi a̱ kutuka̱ ɗa̱ n ila̱nishi tsu na n suꞋuki aza a Masar ba, adama a na mpa ɗa Vuzavaguɗu vu na u tsu potsotongu ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ɗaɗa uma a a yawai e Elim, a̱ ubuta̱ u na wi n a̱shi a̱ mini kupa n e re ni nshuwa amangatatsunkupa. Ɗa a vaki lo ɗevu n ubuta̱ u mini wa. ");
INSERT INTO asg_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Aza a Isaraila ra̱ka̱ a̱ ka̱sukpa̱i Elim, ɗa a banai e meremune ma na e ci ɗeke Sin. Wi ta̱ e mere me Elim n Sinai. Ili i nanlo i yaꞋan ta̱ a kanna ke gendu ko wotoi u ire ana a̱ uta̱i a Masar. ");
INSERT INTO asg_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","E meremune ma ɗe, ɗa aza a Isaraila ra̱ka̱ a yaꞋankai Haruna m Musa mololo. ");
INSERT INTO asg_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Aza a Isaraila a danai le, <<Wi ishi ta̱ a kulaꞋa n kugaꞋan Vuzavaguɗu wu una tsu ɗe a Masar. Adama a na a Masar ɗe ci ci lyaꞋa ta̱ ili i na ci cigai n inyama dem ayin tutu. Ama vu tuka̱i tsu na e meremune, adama a na vu una tsu n kambulu.>> ");
INSERT INTO asg_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ɗa Vuzavaguɗu u danai Musa, <<Mi ta̱ a kuzuwa ilikulya i yikpa̱ a iɗika tsu na o ci yoꞋo mini, kanna dem vuza wu uta̱ u ciya̱ ilikulyaꞋa i na i kuyawa yi a kanna. Tsu nampa tsu ɗa n kukondo le ko a kufuɗa o tono kadanshi ka̱ va̱ ko a kufuɗa ba. ");
INSERT INTO asg_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A kanna ka̱ ta̱li o ɓolongu ilikulya i na i kuyawa una̱ u kulyaꞋa kure, i laꞋa uteku tsu na i ishi a ci yaꞋansa, ka̱ta̱ a lapula i ɗa.>> ");
INSERT INTO asg_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ɗa Musa n Haruna a danai uma a, <<Anana n kulivi ku nampa yi ta̱ e kuyeve an Vuzavaguɗu a̱yi ɗa vuza na wu uta̱ka̱i ɗa̱ a iɗika i Masar, ");
INSERT INTO asg_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","n usana yi ta̱ e kene tsugbayin tsu Vuzavaguɗu, adama a na a̱yi u pana ta̱ ka̱sa̱la̱ ka na yi a kuyaꞋansa ayin dem. A̱ tsu ɗa anan ya, ali ɗa yi a kuyaꞋanka tsu mololo?>> ");
INSERT INTO asg_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ɗa Musa u danai kpamu, <<Yi ta̱ e kuyeve a na a̱yi ɗa Vuzavaguɗu ayin a na baci u nekei ɗa̱ boroji vu na yi a kuciga dem n usana ɗa kpamu u nekei ɗa̱ inyama n kulivi. Adama a na u pana ta̱ mololo ma na i yaꞋankai ni. A̱ tsu ɗa anan ya? Vuzavaguɗu ɗa yi a kuyaꞋanka mololo, a̱ tsu ɗa ba.>> ");
INSERT INTO asg_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ɗa Musa u danai Haruna, <<Dana umaci wa aza a Isaraila ra̱ka̱, <Ta̱wa̱i u Vuzavaguɗu gbende vu ɗa̱, adama a na u pana ta̱ mololo ma̱ ɗa̱.> >> ");
INSERT INTO asg_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ana Haruna wi a kadanshi n uma a Isaraila ra̱ka̱, ɗa a̱ la̱na̱i uɓon u meremune, ɗa e enei tsugbayin tsu Vuzavaguɗu e eleshu. ");
INSERT INTO asg_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","<<M pana ta̱ ka̱sa̱la̱ ka aza a Isaraila ka. Dana le, <N kulivi, yi ta̱ a̱ kuciya̱ inyama i kutakuma, n usana dem yi ta̱ a̱ kuciya̱ ilikulya. Ta lo i kuyeve a na mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱.> >> ");
INSERT INTO asg_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","N kulivi ku nanlo, ɗa nroni n ta̱wa̱i n kimba̱i le ra̱ka̱. Ɗa n usana, ciza tsu matsai n a̱bunda̱i tsu ka̱ra̱Ꞌi ubuta̱ u na i va. ");
INSERT INTO asg_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ana ciza tsu sa̱ruwa̱i tsu kotsoi, ɗa ili i yoku wa̱ri tsu egele yo okpoi lo a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ana aza a Isaraila e enei nannai, ɗa e ecenei, <<Yiɗa̱i tamkpamu nannai?>> Adama a na ishi e yeve ili ya ba. Ɗa Musa u danai le, <<Ilikulya i ɗa Vuzavaguɗu u nekei ɗa̱ i lyaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ili i na Vuzavaguɗu u danai i ɗaɗa na, <Yaba dem u ɓolongu tsu na u kuyawa yi kulyaꞋa. Kenuki mokoko me te adama a uteku u ka̱bunda̱i ka na ki punu a̱ ka̱pa̱m ka.> >> ");
INSERT INTO asg_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ɗa aza a Isaraila a yaꞋin tsu na a danai le, aza o yoku o ɓolongi n a̱bunda̱i aza o yoku kpamu kenkeꞋen. ");
INSERT INTO asg_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ana a gisangushi i ɗa n kakpanu, ɗa yaba dem u ciya̱i tsu na u kuyawa yi. Aza a na o ɓolongi n a̱bunda̱i a buwa n ili ba, aza a na o ɓolongi kenu ɗa a buwai n i na i kuyawa le. KpaꞋa dem kuciya̱i tsu na ki a kuciga. ");
INSERT INTO asg_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ɗa Musa u danai le, <<Ka̱ta̱ vuza u lyaꞋa u buwaka adama a mkpaꞋa ba.>> ");
INSERT INTO asg_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ama aza o yoku a iwan ta̱ kupana, ɗa o foɓoi i yoku ali a kubana usana. Azun a shanai punu ali i ɗa i gita̱i kuta̱ ushami u gbani-gbani, ɗa ta na Musa u yaꞋin wupa n ele. ");
INSERT INTO asg_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Usana dem yaba dem u tsu ɓolongu ta̱ i na u cigai, ama i na i buwai kanna ka suɗukpa baci ka̱ta̱ i derikpe. ");
INSERT INTO asg_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A kanna ka̱ ta̱li yaba dem u ɓolongi ali ugboku u re wu nkokoꞋo n re tsu na ishi o tsu ɓolongu, ɗa nkoshi m gba̱ra̱-gba̱ra̱ m banai u Musa ɗa a danai ni. ");
INSERT INTO asg_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ɗa u danai le, <<Ili i na Vuzavaguɗu u danai i ɗaɗa na, mkpaꞋa kanna ka Ashibi kaꞋa ka ciɗa kanna ka kuvuka, kangalai ili i na i kukangala ka̱ta̱ kpamu i laluku i na kpamu i kulaluku, zuwai ili i na i buwai dem a kubana usana u yoku.>> ");
INSERT INTO asg_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","O foɓoi ilikulya ya tsu na Musa u danai le, ana kayin ka asai ilikulya ya i shama ba, i uwa feu azuꞋun ba. ");
INSERT INTO asg_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ɗa Musa u danai le, <<LyaꞋi i ɗa anana, adama a na anana kanna ka Ashibi kaꞋa kanna ka kuvuka ka na kpamu e nekei Vuzavaguɗu, ye kene ilikulya lo pulai a iɗika ba. ");
INSERT INTO asg_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Yi ta̱ a kufuɗa ye kene ilikulya pulai ali ayin a̱ ta̱li ama a kanna ka Ashibi i kene ili ba.>> ");
INSERT INTO asg_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","A kanna ke cindere aza o yoku a banai adama a na o ɓolongu ilikulya ama e ene ili ba. ");
INSERT INTO asg_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ɗa Vuzavaguɗu u danai Musa, <<Wannai ɗai uma a̱ va̱ a̱ kuka̱sukpa̱ kuꞋiwan kadanshi ka̱ va̱ n kuyotsongusu ku va̱? ");
INSERT INTO asg_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ciɓai a na Vuzavaguɗu ɗa u nekei ɗa̱ Ashibi. I ɗaɗa i zuwai ɗa u nekei ɗa̱ ilikulya i na i kuyawa ɗa̱ ali ayin e re. Yaba dem vu ɗa̱ u da̱sa̱ngu a kpaꞋa a kanna ke cindere ka nanlo ka̱ta̱ wu uvuka u bana a̱ ubuta̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ɗa uma a a uvukai a kanna ke cindere. ");
INSERT INTO asg_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ɗaɗa uma a Isaraila e ɗekei ilikulya ya mana, I ɗa yi ta̱ kenkeꞋen wa̱ri ci igeɓetsu, uyoꞋo ce emeshe a̱ ishigi. ");
INSERT INTO asg_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ɗa Musa u danai uma, ili i na Vuzavaguɗu u danai i ɗaɗa na, <<Vuzavaguɗu u danai, <Foɓoi mokoko me te ma mana, adama a na mi ta̱ a kuciga ntsukaya n na n kuta̱wa̱ me ene, e yeve icuꞋu yi ilikulya i na n nekei ɗa̱ a ayin a na yi e meremune a na mu uta̱ka̱i ɗa̱ a Masar.> >> ");
INSERT INTO asg_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ɗa Musa u danai Haruna, <<Kenuku mana vi yoku vu zuwa e kedele a̱ ubuta̱ u na ci ci yaꞋanka Ka̱shile a̱ga̱nda̱ adama a ntsukaya n na mi lo a̱ kuta̱wa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tsu na Vuzavaguɗu u danai, ɗa Haruna u zuwai vu ɗa e kelime ka Akpati vu Uzuwakpani, adama a na vi yaꞋan wadani. ");
INSERT INTO asg_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Aza a Isaraila a yaꞋan ta̱ a̱ya̱ amangere ele a kulyaꞋasa mana, sai ayin a na a yawai a̱ likuci i na uma i ida̱shi. A lyaꞋasa ta̱ mana ali sai ayin a na a yawai a̱ ka̱kina̱ ka KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mokoko mi ta̱ derere n ugboku u te u ifa. ");
INSERT INTO asg_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Uma a Isaraila ra̱ka̱ a̱ ka̱sukpa̱i une u Sin, ɗa a̱ ka̱na̱i uye a kubana a̱ ubuta̱ kakau tsu na Vuzavaguɗu u danai le. Ɗa a vaki lo kpamu e Refidim, ama mini mi lo a na uma o kusoꞋo ba. ");
INSERT INTO asg_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ɗa uma a yaꞋankai Musa mololo. A danai, <<Neke tsu mini mo kusoꞋo.>> Ɗa Musa wu ushuki, <<Yiɗa̱i ɗa yi a̱ kuyaꞋanka mu mololo? Yiɗa̱i kpamu i zuwai ɗa yi o kukondo Vuzavaguɗu vu ɗa̱?>> ");
INSERT INTO asg_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Adama a na i ta̱ a kupana kakuli a̱ ubuta̱ u nanlo, ɗa a yaꞋankai Musa mololo. A danai, <<Yiɗa̱i i zuwai ɗa vu uta̱ka̱i tsu a Masar adama a na a̱ tsu m muku n tsu, n kuzuwa ku tsu, tsu kuwa̱ na n kakuli?>> ");
INSERT INTO asg_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ɗa Musa u sa̱la̱ka̱i Vuzavaguɗu, u danai, <<Nini ɗai n kuyaꞋan n uma a nampa? I ta̱ ɗevu a na a vara mu a una.>> ");
INSERT INTO asg_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ɗa Vuzavaguɗu wu ushuki Musa, <<Bana e kelime ka uma ka kenu. Vu ɗika nkoshi m gba̱ra̱-gba̱ra̱ n yoku i walaka n kalangu ka̱ nu e kukiye ka na vu lapakai Kuyene ku Nilu ka. ");
INSERT INTO asg_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","N kuyongo ta̱ n avu a kakpanlai ka Kusan ko Horebu. Lapa kakpanlai ka, mini mi ta̱ a̱ kuta̱ adama a na i soꞋo n uma a̱ nu.>> Ɗa ta na Musa u yaꞋin nannai a̱ a̱shi o nkoshi m gba̱ra̱-gba̱ra̱ mi Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ɗa u ɗekei ubuta̱ wa Masaha m Mariba, adama a na ta ɗe aza a Isaraila a yaꞋin mololo, ɗa kpamu o kondoi Vuzavaguɗu, a danai, <<Vuzavaguɗu wi ta̱ n a̱ tsu ko ta nannai ba?>> ");
INSERT INTO asg_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Aza e Emeleki a banai wa aza a Isaraila e Refidim adama a na a yaꞋan kuvon. ");
INSERT INTO asg_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ɗa Musa u danai vuza yoku vuza na e ci ɗeke Jesuwa, <<Zagba uma a̱ tsu o yoku a na a kubana vishili n aza e Emeleki. MkpaꞋa mi ta̱ a kushamgba gaɗi vu masasan a kinda ɗa̱ n kalangu ka̱ Ka̱shile e ekiye a̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ɗaɗa Jesuwa u shilika̱i n aza e Emeleki tsu na Musa u danai ni. Ɗa Musa n Haruna n Horu a banai gaɗi vu masasan. ");
INSERT INTO asg_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Uteku u na Musa u ɗengusa̱i ekiye a̱ ni ta ta na nannai aza a Isaraila a̱ ka̱na̱i kulyaꞋa aza e Emeleki n kuvon. Ama u cipa̱ka̱ baci ekiye a̱ ni, ayin a nanlo a ɗa aza e Emeleki a̱ kuka̱na̱ kulyaꞋa le tamkpamu. ");
INSERT INTO asg_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ana ekiye a Musa o oꞋoi, ɗa a̱ la̱nsa̱i katali ɗa a zuwakai ni u da̱sa̱ngi. Ɗa Haruna n Horu e keɓei ni ekiye ku te ku te adama a na ekiye a o yongo uɗengushi ali kanna ka̱ yikpa̱i. ");
INSERT INTO asg_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nannai ɗa Jesuwa u lyaꞋi aza e Emeleki n kuvon. ");
INSERT INTO asg_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ɗa Vuzavaguɗu u danai Musa, <<Ɗana arabali a nampa tsu na vi lyaꞋi aza Emeleki, ka̱ta̱ vi keceke Jesuwa adama a na a ciɓa ka̱ta̱ a cinukpa n aza Emeleki ra̱ka̱-ra̱ka̱ aduniyan ko wannai.>> ");
INSERT INTO asg_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ɗa Musa u maꞋi katalikalyuka ɗa u neꞋi ubuta̱ wa kula, <<Vuzavaguɗu ɗa urotu u keleje u va̱.>> ");
INSERT INTO asg_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ɗa u danai, <<A̱ ɗengusa̱ ta̱ urotu u keleje u Vuzavaguɗu gaɗi, Vuzavaguɗu wi ta̱ a kulyaꞋa kelime n kushilika̱ n aza a Emeleki tsukaya kakau a kubana.>> ");
INSERT INTO asg_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","A̱yi Jeturo ganu va aza a Midiya akaya a Musa, u pana ta̱ ili i na Ka̱shile ka yaꞋankai Musa n aza Isaraila, tsu na wu uta̱ka̱i le a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ana Musa u danai vuka vi ni Zipura u bana we ene esheku, ɗa Jeturo akaya a̱ ni a rabasai ni, ");
INSERT INTO asg_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","m muku n ni n re. Maku me te kula ku ni ku ɗa Goshum adama a na Musa u dana ta̱, <<Mo okpo ta̱ komoci a iɗika i na yi i va̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ɗa u neꞋi maku me te ma feu kula Eliyaza, ɗa u danai adama a na, <<Ka̱shile ke esheku a̱ va̱ a̱yi ɗa ka̱ɓa̱nki ka̱ va̱ wi isa mu ta̱ a̱ ubuta̱ u kotokobi ka FiriꞋauna.>> ");
INSERT INTO asg_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ayin a nanlo, a̱yi Jeturo akaya a Musa n vuka vu Musa va m muku dem a̱ ta̱wa̱i kene yi e meremune a̱ ubuta̱ u na u vaki ɗevu n kusan ku Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jeturo u suku ta̱ akaka u Musa u danai, <<Mpa, akavu mi ta̱ lo a̱ kuta̱wa̱ n vuka vu nu m muku n re n nu feu.>> ");
INSERT INTO asg_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ana a yawai ɗa Musa u banai e kelime ka akaya a̱ ni, ɗa u kuɗa̱ngi ɗa wo oɓongi ni. Ana o kotsoi ikya̱shi ɗa a lazai a uwai a̱ ka̱pa̱m ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ɗaɗa u danai akaya a ra̱ka̱ ili i na Vuzavaguɗu u yaꞋin n FiriꞋauna koɓolo n aza a Masar ra̱ka̱ adama a aza a Isaraila, n atakaci a na e enei a uye, n tsu na Ka̱shile ki isai le. ");
INSERT INTO asg_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","A̱yi Jeturo u yaꞋan ta̱ ma̱za̱nga̱ ka̱u a na u panai ili i singai i na Vuzavaguɗu u yaꞋankai aza a Isaraila, a na wi isai le e ekiye a aza a Masar. ");
INSERT INTO asg_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ɗa u danai, <<Cikpai Vuzavaguɗu, vuza na wi isai nu e ekiye aza a Masar koɓolo n ekiye a FiriꞋauna. Koɓolo n vuza na wi isai aza a Isaraila e ekiye aza a Masar. ");
INSERT INTO asg_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Gogo na n yeve ta̱ Vuzavaguɗu u laꞋa ta̱ a̱ma̱li a na a buwai dem, adama a na wi isa le ta̱ e ekiye a aza a na a takacikai le n tsugoyi.>> ");
INSERT INTO asg_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ɗa Jeturo, akaya a Musa u tuka̱i n alyuka o kusongu koɓolo n kuneꞋe u Ka̱shile. Ɗa Haruna nu nkoshi m gba̱ra̱-gba̱ra̱ ma aza a Isaraila a banai adama a na a lyaꞋa ilikulya ɗe n Jeturo akaya a Musa, e kelime ka̱ Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kanna ke ire, ɗa Musa wo okpoi vuza va afada vu uma, ɗa uma a shamgbai n usana sai kulivi dem adama a afada. ");
INSERT INTO asg_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ana akaya a Musa e enei ili i na Musa wi a kuyaꞋanka uma, ɗa u danai, <<Yiɗa̱i va kuyaꞋan n uma a nampa? Nini ɗai avu endeꞋen va̱ kuda̱sa̱ngu a kuyaꞋanka uma a nampa afada, uma a na i kashani ili i na i ɗikai usana ali a kubana kulivi?>> ");
INSERT INTO asg_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ɗa Musa wu ushuki, <<A̱ ta̱wa̱ ta̱ wa̱ va̱ adama a na e yeve ili i na Ka̱shile ki a kuciga a yaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ayin a na baci de dem a yaꞋin mawansa ɗa a̱ ta̱wa̱i wa̱ va̱, n tsu uwa ta̱ e mere me le ka̱ta̱ n tonuko le ili i na wila̱ u Ka̱shile u dansai.>> ");
INSERT INTO asg_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ɗa akaya a Musa a danai ni, ili i na vi a kuyaꞋan i ɗa i gaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Avu n uma a na i a̱ kuta̱wa̱ a̱ nu gbani ɗa yi o koꞋwuso ka̱ci ka̱ ɗa̱. Avu ulinga u laꞋa wu ta̱ a̱bunda̱i, vi a kufuɗa u ɗa avu endeꞋen nu ba. ");
INSERT INTO asg_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Panaka mu gogo na, n kuneke wu ta̱ odoki ka̱ta̱ kpamu Ka̱shile ka̱ ɓa̱nka̱ wu. Vi ta̱ o kokpo ka̱suki ka uma a̱ ubuta̱ u Ka̱shile, ka̱ta̱ vu dana yi ma̱shi me le, ");
INSERT INTO asg_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ka̱ta̱ avu vi yotsongu le wila̱ u Ka̱shile, ka̱ta̱ vi yaꞋanka le kuyotsongusu adama a uteku u na a kuwala, n ili i na i gaꞋin a yaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ama zagba uma a̱ usuɓi punu a̱ ka̱tsuma̱ ka uma ka. Ali a na i a kupana n wovon u Ka̱shile, i kpamu a kuyaꞋan ukuna u mayun, a ci ciga kulyaꞋa uma ba. Ka̱ta̱ vu zuwa le o okpo aza e kelime a ugboku uma ka̱kpa̱n ke te ke te (1,000), n uma amangatawun a tawun (100), n uma amangerenkupa n kupa koɓolo n uma ugboku kupa-kupa kpamu. ");
INSERT INTO asg_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Vu zuwa le o okpo aza a afada a uma ayin tutu, ama kadanshi ka na baci ka laꞋi le dem a̱ tuka̱ wu n kaꞋa. Kadanshi ka na ka laꞋi utsura u le ba a yaꞋan kaꞋa, na lo va ɗaɗa u kuzuwa ulinga u nu u jebe adama a na i ta̱ a̱ kuɓa̱nka̱ wu. ");
INSERT INTO asg_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Vu tono baci ukuna u nampa, ɗa Ka̱shile ka zuwai nu kpamu vi yaꞋin nannai, a̱ɗa̱ yo koꞋo ba, uma a nampa dem i ta̱ o kubono a kpaꞋa n kadama ke le ukoci. ");
INSERT INTO asg_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ɗa Musa va u panakai akaya a̱ ni, ɗa u yaꞋin ili i na u danai ni ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ɗa u zagbai uma a usuɓi a̱ ka̱tsuma̱ ka umaci wa aza Isaraila dem ɗa u zuwai le aza e kelime. U zuwai le o okpo aza o kutono n ugboku uma ka̱kpa̱n ke te ke te (1,000), n uma amangatawun a tawun (100), n uma amangerenkupa n kupa koɓolo n uma ugboku kupa-kupa kpamu. ");
INSERT INTO asg_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ɗa o okpoi tsa a aza a afada a kubana ubuta̱ u uma ayin dem, ili i na baci i laꞋi le a banka Musa ama kadanshi ka wawaꞋa a dansa kaꞋa we le. ");
INSERT INTO asg_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ana Musa n akaya a̱ ni Jeturo e pecemgbenei ɗa Jeturo va u ka̱na̱i uye o kubono a kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","A wotoi u tatsu ana aza a Isaraila a̱ ka̱sukpa̱i Masar, a kanna ka nanlo ɗa a yawai e meremune ma Sinai. ");
INSERT INTO asg_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ayin a na a̱ ka̱sukpa̱i Refidim, ɗa a yawai e meremune ma Sinai ɗa a vaki lo ɗevu n kusan. ");
INSERT INTO asg_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ɗa Musa u kumbai ɗe adama a na u cina Ka̱shile Vuzavaguɗu, ɗa Vuzavaguɗu u ɗekushei ni punu a kusan ka, ɗa u danai ni, <<Ili i na va kubana va dana ntsukaya n Yakubu i ɗaɗa na, koɓolo n ili i na va kudana aza a Isaraila: ");
INSERT INTO asg_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","<Avu a̱ ka̱ci ka̱ nu ve ene ta̱ ili i na n yaꞋankai aza a Masar. Uteku u na kajimba ka ci ɗika muku n ni e evelyu a̱ ni, ta feu n ɗikai ɗa̱ nannai ɗa n tuka̱i ɗa̱ na wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Gogo na yu ushuku baci kupanaka mu ka̱ta̱ kpamu i tono uzuwakpani u va̱, yi ta̱ o kokpo uma a̱ va̱ a na a laꞋi n kusuɓa̱ a̱ ka̱tsuma̱ ka aduniyan ra̱ka̱, n nannai dem aduniyan gbende a̱ va̱ a ɗa. ");
INSERT INTO asg_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Yi ta̱ o kokpo tsugono tsu anan ganu tsu va̱, n iɗika i ciɗa i va̱.> Na ɗaɗa akaka a na va kudana aza a Isaraila.>> ");
INSERT INTO asg_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ana Musa u cipa̱i a kusan ka, ɗa u bonoi u ɗekei nkoshi m gba̱ra̱-gba̱ra̱, ɗa u tonokoi le ra̱ka̱ ili i na Vuzavaguɗu u danai ni. ");
INSERT INTO asg_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ɗa uma a gbende a̱ ushuki, a danai, <<Ci ta̱ a kuyaꞋan ili dem i na Vuzavaguɗu u danai.>> Ɗa Musa u bonokoi Vuzavaguɗu ili i na uma a a danai. ");
INSERT INTO asg_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ɗa Vuzavaguɗu u danai Musa, <<Mi ta̱ a̱ kucipa̱ wa̱ nu tsu keleshu ku uguyi ka̱ a̱miki, ka̱ta̱ uma a panaka mu a kadanshi n avu, ciya̱ a̱ ushuku n avu.>> Ɗa Musa u doku u danai Vuzavaguɗu kpamu ili i na uma a danai. ");
INSERT INTO asg_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ɗa Vuzavaguɗu u danai Musa, <<Bana a̱ ubuta̱ u uma a̱ nu ka̱ta̱ vu takpa le nshinda̱ dem anana nu mkpaꞋa. Vu zuwa le a̱ za̱Ꞌa̱ aminya e le, ");
INSERT INTO asg_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ka̱ta̱ o foɓuso a kanna ka tatsu, adama a na a kanna ka nanlo kaꞋa Vuzavaguɗu u kucipa̱ gaɗi vu Kusan ku Sinai a̱ a̱shi a uma. ");
INSERT INTO asg_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Vu zuwaka le uteku n kusan ku nanlo ka vu ka̱ra̱Ꞌa̱ka̱, ka̱ta̱ vu dana le, <YaꞋin mayin ka̱ta̱ i yawa ɗevu ko i saꞋwa kusan ka ba. Vuza na u banai u saꞋwai, i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mayun vuma vu nanlo i ta̱ a kuvara yi n atali ko a tawa yi n aya, ka̱ta̱ a saꞋwa yi n kukiye ba. Ko vuma ɗa baci ko manama a̱ kuka̱sukpa̱ yi n wuma ba.> I ta̱ a kufuɗa kubana a kusan ka a ayin a na baci a panai a̱ lika̱i kavana ka̱ ka̱giri.>> ");
INSERT INTO asg_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ana Musa u cipa̱i a kusan ka ɗa u takpai yaba dem nshinda̱, ɗa a̱ za̱Ꞌi aminya e le. ");
INSERT INTO asg_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","U danai le, <<Foɓusoi ka̱ci ka̱ ɗa̱ adama a kanna ka tatsu, ka̱ta̱ kpamu i vaku n a̱ma̱ci a̱ ɗa̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","N usana a kanna ka tatsu, ɗa akpanga nu mkpayayan n ulaɗi a̱ cipa̱i lo. Ɗa keleshu ka̱ a̱miki ka̱ kimba̱i gaɗi vu kusan va. Ɗa uma a panai ciliki tsu kavana n kacaꞋa ka̱u. Ana uma ra̱ka̱ a panai ili i nanlo dem, ɗa e jeꞋekei ikyamba. ");
INSERT INTO asg_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ɗa Musa wu uta̱ka̱i le a̱ a̱pa̱m e le, adama a na a gasa n Ka̱shile, ɗa a shamgbai lo ɗaka vu kusan va. ");
INSERT INTO asg_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ɗa ka̱nga̱ ka palai Kusan ku Sinai adama a na Vuzavaguɗu u cipa̱ ta̱ lo uteku tsa akina. Ka̱nga̱ kpamu adanshi i ta̱ o kusongu kumaꞋa ɗa ka̱ ɗa̱nga̱i gaɗi. Ɗa kusan ka ku gba̱ɗa̱i. ");
INSERT INTO asg_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ɗa izumgbi i ciliki i kavana i doki ka̱u. Ɗa Musa u yaꞋin kadanshi, ɗa Ka̱shile ku ushuki ni an kakpanga. ");
INSERT INTO asg_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ɗa Vuzavaguɗu u cipa̱i a Kusan ku Sinai, ɗa u ɗekei Musa u kumba a gaɗi vu Kusan va. Ɗa Musa u kumbai kusan ka. ");
INSERT INTO asg_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ɗa Vuzavaguɗu u danai ni, <<Cipa̱ vu bana vu ɓarangu uma a mayin ka̱ta̱ a pasa uteku wa adama a na a dana yaꞋan e ene mu ba, a yaꞋan baci nannai uma n a̱bunda̱i i ta̱ a̱ kukuwa̱. ");
INSERT INTO asg_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ko anan ganu a na a kiwanai kuyawasa ɗevu n Vuzavaguɗu u gaꞋan ta̱ takpaka biꞋi ka̱ci ke le nshinda̱, ko Vuzavaguɗu u yaꞋan wupa n ele ka̱ta̱ wu una le.>> ");
INSERT INTO asg_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ɗa Musa wu ushuki Vuzavaguɗu, <<Ko vuza u kukumba a Kusan ku Sinai ka ba, adama a na vu ɓarangu tsu ta̱ ɗe, vu danai <I zuwa uteku i ka̱ra̱ka̱ Kusan ka ka̱ta̱ i la̱na̱ ku ɗa ciya̱ ku yaꞋan ciɗa.> >> ");
INSERT INTO asg_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ɗa Vuzavaguɗu u danai Musa, <<Cipa̱ vu bana vu ta̱wa̱ n Haruna na u shamgba n avu. Ama anan ganu n aza a na a buwai ka̱ta̱ a dana i ta̱ a kuciga kupasa uteku wa adama a na a̱ ta̱wa̱ na ba, ta baci nannai ba mi ta̱ a kuyaꞋan wupa ka̱ta̱ mu una le.>> ");
INSERT INTO asg_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ɗaɗa Musa u cipa̱i, ɗa u danai uma ili i na Vuzavaguɗu u danai. ");
INSERT INTO asg_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ɗa Ka̱shile ka yaꞋin kadanshi ka nampa ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","<<Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱, vuza na wu uta̱ka̱i ɗa̱ a Masar a iɗika i na yi ishi a ugbashi. ");
INSERT INTO asg_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","<<Ka̱ta̱ vu tono ka̱ma̱li ba, sai mpa Ka̱shile endeꞋen. ");
INSERT INTO asg_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","<<Ka̱ta̱ vi yaꞋanka ka̱ci ka̱ nu a̱ma̱li o yoku a na o yotsoi ili i na yi gaɗi ko iɗika ko i na yi a̱ mini ba. ");
INSERT INTO asg_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ka̱ta̱ vu kuɗa̱nku le ko vu cikpa le ba. Mpa ɗa Vuzavaguɗu Ka̱shile endeꞋen, Ka̱shile ka na ka̱ tsu kpa̱ɗa̱ kuciga cisheꞋe. Vuza na u kutakacika muku adama a̱ unushi wu isheku i le, ali ntsukaya n tatsu ali a kubana n na̱shi ele na a iwain mu, ");
INSERT INTO asg_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ama a̱ɗa̱ na i cigai mu ɗa i tonoi wila̱ u va̱, mi ta̱ o kuyotsongu ucigi a kubana u muku ali a ntsukaya nu ntsukaya. ");
INSERT INTO asg_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","<<Ka̱ta̱ vu ka̱na̱ kuɗeke kula ku Vuzavaguɗu gbani ba. Adama a na mpa Vuzavaguɗu mi ta̱ a kutakacika vuza na u yaꞋin nannai. ");
INSERT INTO asg_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","<<Zuka n kanna ka Ashibi, ka̱ta̱ vu ka̱na̱ kaꞋa ciɗa mayin. ");
INSERT INTO asg_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ayin a̱ ta̱li i ta̱ lo, a na avu va kuyaꞋan ulinga. ");
INSERT INTO asg_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ama kanna ke cindere dem ka Vuzavaguɗu Ka̱shile ka̱ nu kaꞋa, adama a nannai ka̱ta̱ vi yaꞋan ulinga ba, ko avu, ko maku ma̱ nu kolobo ko mekere, ko kagbashi ka̱ nu kolobo ko mekere, ko kuzuwa ku nu, ko komoci ka kpaꞋa ka̱ nu dem. ");
INSERT INTO asg_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","A ayin a̱ ta̱li a ɗaɗa Vuzavaguɗu u yaꞋin ili i nampa gaɗi n iɗika m mala n ili dem, ɗa wu uvukai a kanna ke cindere. Ɗa Vuzavaguɗu u zuwakai kaꞋa una̱singai ɗa kanna ka Ashibi ko okpoi kanna ka ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","<<Cikpa eshevu n a̱na̱vu, adama a na vi yongo ayin n a̱bunda̱i a iɗika i na Vuzavaguɗu Ka̱shile ka̱ nu ki e kuneke wu. ");
INSERT INTO asg_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","<<Ka̱ta̱ vu una vuza ba. ");
INSERT INTO asg_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","<<Ka̱ta̱ vi yaꞋan tsugbani n vuka vu vuza ba. ");
INSERT INTO asg_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","<<Ka̱ta̱ vi yaꞋan uboki ba. ");
INSERT INTO asg_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","<<Ka̱ta̱ vu dana vuza kakuna ka aꞋuwa ba. ");
INSERT INTO asg_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","<<Ka̱ta̱ vu cikala kisa kpaꞋa ku vuza nu ba. Ka̱ta̱ vi yaꞋan a̱shi a wuya n vuka vu vuza nu ba, ko kagbashi ka̱ ni, ko anaka a̱ ni, ko majaki ma̱ ni, ko ili i yoku i ni ba.>> ");
INSERT INTO asg_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ana uma a panai akpanga n ulaɗi nu mkpanyanya n ciliki tsa avana, ɗa e enei ka̱nga̱ ka̱ kimba̱i kusan ka, ɗaɗa uma a panai wovon ali e jeꞋekei ikyamba ɗa a shamgbai daꞋin. ");
INSERT INTO asg_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ɗa uma a a danai Musa <<Avu yaꞋan kadanshi n a̱ tsu, a̱ tsu ta na tsa kupanaka wu ta̱, ama ka̱ta̱ vu ka̱sukpa̱ Ka̱shile ka yaꞋan kadanshi n a̱ tsu ba, talo tsa̱ kuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ɗa Musa u danai uma a <<Ka̱ta̱ i pana wovon ba, Ka̱shile ka̱ ta̱wa̱ ta̱ adama a na u kondo ɗa̱, ka̱ta̱ kpamu i pana wovon u ni talo ya yaꞋan unushi.>> ");
INSERT INTO asg_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ɗa uma a a shamgbai daꞋin Musa tamkpamu u doki u yawai ɗevu n keleshu ka na ki n ka̱yimbi kpaɓam a̱ ubuta̱ u na Ka̱shile ki. ");
INSERT INTO asg_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ɗa Vuzavaguɗu u danai Musa, <<Dana aza a Isaraila ili i nampa, <Ye ene ta̱ n ka̱ci ka̱ ɗa̱ ana n yaꞋin kadanshi n a̱ɗa̱ na ɗe gaɗi. ");
INSERT INTO asg_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ka̱ta̱ i yaꞋanka ka̱ci ka̱ ɗa̱ ka̱ma̱li ka azurufa ko ka azanariya adama a na i cikpa le ba, sai mpa koci. ");
INSERT INTO asg_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","I maꞋaka mu katalikalyuka ka n ciꞋin ta ɗe i kuyaꞋanka mu alyuka o kusongu n alyuka a na a̱ kutuka̱ m ma̱ta̱na̱, maraɗika ko mokyon ko kanaka a̱ ubuta̱ u na mpa n zagbai i ciɓasa n kula ku va̱, mi ta̱ a̱ kuta̱wa̱ wa̱ ɗa̱ ka̱ta̱ n zuwaka ɗa̱ una̱singai. ");
INSERT INTO asg_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Yi baci a kumaꞋaka mu katalikalyuka ka, ka̱ta̱ i maꞋaka n atali a na e sheꞋwei ba. I sheꞋwe baci n ili i kusheꞋweke, ki ta̱ o kokpo ili yu unata wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ka̱ta̱ i maꞋaka mu katalikalyuka ki idasakpatsu ba, adama na ka̱ta̱ i ka̱sukpa̱ ciyampa tsu ɗa̱ e keteshe a ayin a na yi a kukumba ba.> ");
INSERT INTO asg_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","<<Na va ɗaɗa wila̱ u na ve kuneke uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Vu tsula baci kagbashi ka mavali ka aza a Ibirahi, wi ta̱ a kuyaꞋan tsugbashi a̱ya̱ a̱ ta̱li, a̱ ka̱ya̱ ke cindere vi ta̱ e kuneke yi uba̱ruwi, u kutsupa kpamu ili i yoku ba. ");
INSERT INTO asg_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","U ta̱wa̱ baci endeꞋen ni, wi ta̱ a kufuɗa wa laza endeꞋen ni, ama u ta̱wa̱ baci n vuka vi ni, wi ta̱ kpamu a kufuɗa wa laza n vu ɗa. ");
INSERT INTO asg_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Vuzakpa vi ni vu ɗa baci u yaꞋankai ni yolo, ɗa u matsakai ni muku mo olobo ko nkere, vuka va m muku n ni i ta̱ o kokpo n vuzakpa vi ni, a̱yi vuza va wi ta̱ a kufuɗa wa laza endeꞋen ni. ");
INSERT INTO asg_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ama a̱yi kagbashi ka kuta̱ baci e keteshe ɗa u danai mpa mi ta̱ a kuciga Vuzakpa vu va̱, n vuka va m muku ma, n kulyaꞋa ta̱ kelime n kuyaꞋanka wu tsugbashi, ");
INSERT INTO asg_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ka̱ta̱ Vuzakpa vi ni u banka yi a̱ ubuta̱ u kucikpa Ka̱shile. Ka̱ta̱ u banka yi a̱ utsutsu ko a muntsa mu utsutsu, a̱yi vuzakpa va ka̱ta̱ u ta̱sa̱ yi atsuvu n vubele. Kagbashi ka wi ta̱ a kulyaꞋa kelime n kuyaꞋanka yi tsugbashi ali sai ukpa̱ u ni. ");
INSERT INTO asg_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","<<Vuza u denge baci mekere ma̱ ni ɗa mo okpoi kagbashi, e kuneke maꞋa uba̱ruwi tsu na a ci yaꞋanka maku mavali ba. ");
INSERT INTO asg_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Mekere mo doku baci ma luwa vuzakpa vi ni vu na u tsulai ni va ba, wi ta̱ a kufuɗa kuka̱sukpa̱ e neke yi katsupu ka̱ ni, wi n kofon ka na wo kudoku we denge yi a iɗika i limoci ba, adama a na u koɗo ta̱ uzuwakpani u ni. ");
INSERT INTO asg_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Vuzakpa va u tsula baci mekere ma ta na adama o kolobo ka̱ ni, u kucikpa u ɗika yi adanshi mekere ma̱ ni maꞋa ma na u matsai. ");
INSERT INTO asg_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","U zuwa baci vuka vi yoku ta na, ka̱ta̱ u sa̱nka̱ kagbashi ka vuka ka ilikulya, ko akashi a kuꞋuka, ko ugaꞋin wu ida̱shi i yolo ba. ");
INSERT INTO asg_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","U fuɗa baci ta na u yaꞋanka yi ili i tatsu i nampa ya ba, wi ta̱ a kufuɗa wa laza tsa agisana a vuza vu uba̱ruwi babu kutsupa ki ili i yoku. ");
INSERT INTO asg_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","<<Vuza na baci u lapai vuza ali sai ukpa̱, a̱yi feu i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ama n kusheshe ku ni ku ɗa baci wu unai ni ba, ɗa Ka̱shile ka zuwai ili ya yo okpoi nannai, mi ta̱ o kuyotsongu wu ubuta̱ u na vuza va u kubana u ciya̱ u laꞋaka n wuma u ni. ");
INSERT INTO asg_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ama vuza va wu una baci vuza va n kuyeve ku ni, ka̱ta̱ i takpa yi punu a̱ ubuta̱ u katalikalyuka ka̱ va̱, ka̱ta̱ yu una yi. ");
INSERT INTO asg_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","<<Vuza na baci u lapai esheku ko a̱na̱ku i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Vuza na baci u bokoi vuza, ko a cinai ni n vuma va e ekiye a̱ ni ko wana ɗai u denge vuza va, a̱yi vuza na u yaꞋin uboki wa ka̱ta̱ yu una yi. ");
INSERT INTO asg_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Vuza na baci kpamu u shikai esheku ko a̱na̱ku i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","<<Ali i baci a̱ vishili ɗa vuza te va u varai toku n katali ko u lapai ni n ka̱kuꞋun, vuza va ta na u kuwa̱ ba, ama ɗa u vaki adama a ulapi. ");
INSERT INTO asg_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Vuza va u ɗa̱nga̱ baci ali ɗa u gita̱i kuwala n kalangu, vuza na u lapai ni va wi ta̱ a kulaꞋaka, ama wi ta̱ a kutsupa vuza na u ukai muna ma adama a ayin a na u la̱nga̱sa̱i ni, ka̱ta̱ kpamu u lyaꞋa kelime n kuyaꞋan ciba ci ni sai ayin a na u potsoi ra̱ka̱-ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","<<Vuza u lapa baci kagbashi ka mavali ko ka mavuka n kalangu sai ukpa̱ i ta̱ a kutakacika yi. ");
INSERT INTO asg_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kagbashi ka kuwa̱ baci ba, ɗa kucikpa u potsoi a kanna ke te ko a̱ ka̱tsuma̱ ka ayin e re, a ku kiɗaka vuzakpa va afada ba, adama a na kagbashi ka̱ ni kaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","<<Ali i baci a̱ vishili ɗa a ukai vuka vu na vi n ka̱tsuma̱ muna ɗa ali ka̱tsuma̱ ka kuta̱i, ama a uka yi baci muna ma kau ba, vali vu ni vu ɗa u kudana ili na a kutsupa yi, ka̱ta̱ kayaꞋinkafada u yeve u kiɗa ili na i gaꞋin a tsupa. ");
INSERT INTO asg_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ama a̱yi vuka va u ciya̱ baci muna mo yoku wuya-wuya, i ta̱ a kutakacika vuza va tsu na muna ma ma yaꞋin wuma n wuma. ");
INSERT INTO asg_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ka̱shi a tsupa n ka̱shi, kanga a tsupa n kanga, kukiye a tsupa n kukiye, kune a tsupa n kune feu, ");
INSERT INTO asg_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Vu uka baci vuza muna avu feu i ta̱ a ku yaꞋanka wu muna, vu songu baci vuza avu feu ta a kuyaꞋanka wu nannai, vu lapa baci vuza feu a lapa wu. ");
INSERT INTO asg_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","<<Vuza u dukpa̱ baci kagbashi ka mavali ko ka mavuka a̱ ka̱shi, ali ɗa ka̱ na̱mgba̱i wi ta̱ e kuneke yi uba̱ruwi adama a̱ ka̱shi ka. ");
INSERT INTO asg_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ta kpamu nannai u fa̱da̱ baci kanga ka kagbashi ka mavali ko mavuka, wi ta̱ e kuneke yi uba̱ruwi adama a kanga ka. ");
INSERT INTO asg_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","<<Kanaka ka̱ sunwa̱n baci mavali ko vuka ali sai ukpa̱, ka̱ta̱ a vara kanaka ka n atali sai ukpa̱, ama ka̱ta̱ a takuma i nyama i ni ba, ka̱ta̱ kpamu a takacika vuza vu kanaka va ba. ");
INSERT INTO asg_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kanaka ka kiwana baci ta na m ma̱sunka̱, ali ɗa a danai vuza va, a̱yi tana u yaꞋan ili i yoku ba, ali ɗa kanaka ka kunai mavali ko mavuka, i ta̱ a kuvara kanaka ka a una, ka̱ta̱ a una feu vuza va. ");
INSERT INTO asg_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","A dana baci ta na a tsupa le ikebe, ta ta na nannai u kutsupa le ta̱ ili na a danai ni dem adama a na u ciya̱ wi isa wuma u ni ");
INSERT INTO asg_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ta kpamu a kuyaꞋan nannai kanaka kuna baci kolobo ko mekere. ");
INSERT INTO asg_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kanaka kuna baci kagbashi ka mavali ko mavuka, a̱yi vuza kanaka va u kutsupa ta̱ vuzakpa vu kagbashi va ikebe ya azurufa kamangankupa, ka̱ta̱ kpamu a vara kanaka n atali sai ukpa̱. ");
INSERT INTO asg_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","<<Vuza u ga̱va̱ baci kpenle ɗa u ka̱sukpa̱i ku ɗa babu u ciɗa̱ngi ali ɗa kanaka ka walai lo ko majaki, ɗa ke derecei ka̱ yikpa̱i punu, ");
INSERT INTO asg_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","vuza na u ga̱va̱i kpenle ka wi ta̱ a kutsupa vuza vu kanaka va ili na baci de dem a kiɗakai ni u tsupa, ama vuza na u ga̱va̱i kpenle ka a̱yi ɗa u ku ɗika keven ki ikyamba ka. ");
INSERT INTO asg_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","<<Kanaka ka̱ sunwa̱n baci vutoku ali sai ukpa̱ i ta̱ e kudenge yi, vuza na wi n wuma wa ka̱ta̱ e pece ikebe ya derere, ta kpamu a kuyaꞋan n inyama i kanaka ka na ka̱ kuwa̱i va nannai e pece i ɗa derere. ");
INSERT INTO asg_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","E yeve baci ta na kanaka ka ka kiwana ta̱ n kusuwa̱nsa̱ otoku, vuza kanaka va ta na u yaꞋan ili i yoku ba, wi ta̱ a kutsupa. A̱yi vuza na wu unai kanaka wi ta̱ a kuɗika keven ki ikyamba i kanaka ya yo okpo i ni.>> ");
INSERT INTO asg_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","<<Vuza u boko baci kanaka ko malala, ɗa u kiɗai ko u dengei, wi ta̱ a kutsupa anaka a tawun a̱ una̱ u kanaka ke te ka na u bokoi va, malala ma baci kpamu, wi ta̱ a kutsupa n na̱shi a̱ una̱ u malala me te ma na u bokoi va. ");
INSERT INTO asg_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","A̱ ka̱na̱ baci koboki a̱yi a kuciga kuꞋuwa kuyaꞋan uboki ɗa a lapai ni ali ɗa u kuwa̱i, vuza na wu unai ni va, u yaꞋan unushi u munuka ba, ");
INSERT INTO asg_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ili ya i yaꞋan baci nannai n kanna, vuza na wu unai koboki ka, u yaꞋan ta̱ unushi u munuka. A̱ ka̱na̱ baci koboki wi ta̱ a kutsupa ili na u bokoi va ra̱ka̱. Wi baci ta na n ili na u kutsupaka ba, a kucikpa e denge yi an kagbashi adama a na ciya̱ u tsupa. ");
INSERT INTO asg_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","A̱ ciya̱ baci ta na manama ma na u bokoi va ko kanaka ko majaki ko malala e ekiye a̱ ni n wuma, u kutsupa ta̱ ili na u bokoi va ali kure. ");
INSERT INTO asg_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","<<Vuza u banka baci n kuzuwa ku ni kalina ɗa u ka̱sukpa̱i ku ɗa ku yaꞋin koli a kashina ko kashina ki itacishi ka vuza. A̱yi vuza vi ilikuzuwa ya, sai u ɗika ili i singai a̱ ka̱tsuma̱ ki ili kashina ko i kashina ka nɗanga ka̱ ni adama a na u tsupa ili na kuzuwa ku ni ka ku la̱nga̱sa̱i. ");
INSERT INTO asg_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","<<Vuza u zuwa baci akina a kashina ka̱ ni ɗa a lalai a kubana a kashina ko vutoku, ali ɗa ma̱ga̱n ma̱ ya̱nji ko ilya i kashani ko kashina ka ra̱ka̱ ka̱ kula̱i, a̱yi vuza na u zuwai akina a u kutsupa ta̱ ili i na i kula̱i va. ");
INSERT INTO asg_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","<<Vuza u neke baci vuza ni vu na i ida̱shi ɗeɗevu koɓolo ikebe ko ucanuku u foɓuko yi, ɗa o bokoi ili ya, koboki ka a̱ ka̱na̱ yi baci sai u tsupa ili ya ali kure. ");
INSERT INTO asg_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","A̱ ka̱na̱ baci ta na koboki ka ba, a̱yi vuza kpaꞋa vu na e nekei u foɓo ili ya, sai u bana u yotsongu ka̱ci ka̱ ni a̱ ubuta̱ u kayaꞋinkafada, adama a na o goɗumo yi ko kukiye ku ni ki ta̱ punu a uboki wa ko ki punu ba. ");
INSERT INTO asg_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Aza e re i baci a kanananai ki ili i te, ko kanaka, ko majaki, ko malala, ko motogu ko ili na i puwa̱nka̱i, ɗa vuza te u danai, <I ɗaɗa na> U gaꞋan ta̱ a bana e kayaꞋinkafada u goɗumo, vuza na baci ta na a̱ ka̱na̱i n unushi wi ta̱ a kutsupa vuza ni va ali kure. ");
INSERT INTO asg_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","<<Vuza u neke baci vuza ni na i ida̱shi ɗevu koɓolo ka̱ɓa̱na̱ ka majaki ko kanaka ko malala ɗa ma̱ kuwa̱i ko ma̱ ciya̱i usa̱n ko ma̱ puwa̱nka̱i babu ta na vuza na we enei, ");
INSERT INTO asg_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ele aza e re e le i ta̱ a kubana e kelime ka Vuzavaguɗu, ka̱ta̱ vuza na e nekei ka̱ɓa̱na̱ ka u yaꞋan akucina, a na o kuyotsongu wi punu n kukiye a ili i vuza ni ya ba. A̱yi vuza vi ili va mayun ɗa wu ushuku n akucina a, i o kudoku kpamu a tsupa yi ili ba. ");
INSERT INTO asg_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Vuza na e nekei ka̱ɓa̱na̱ ka ɗa baci ta na o bokoi e ekiye a̱ ni, wi ta̱ a kutsupa vuza vi ili va. ");
INSERT INTO asg_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Manama ma kakamba ma baci ta na mu unai kanaka ka ko malala ma, ka̱ta̱ vu tuka̱ n keven ki ikyamba ka adama a na a vuza vi ili va u ciya̱ we ene. A kutsupa yi kanaka ko malala ma na manama ma kakamba ma mu unai va ba. ");
INSERT INTO asg_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","<<Vuza u kopuku baci ili kuzuwa u vutoku vu na i ida̱shi ɗeɗevu koɓolo ɗa ili ya i ciya̱i usa̱n ko i kuwa̱i, a ayin a na vuza vi ili va wi lo ba. Vuza na u kopuki va wi ta̱ a kutsupa ugana u na a kiɗakai ni ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ama vuza vi ili ya wi baci ta na lo, wa̱ kuciya̱ katsupu ba. Ama u tsupa baci ikebe adama a na u yaꞋan ulinga n ilikuzuwa ya, ikebe i nanlo i ɗa i kokpo una̱ u katsupu wa. ");
INSERT INTO asg_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","<<Mavali ma̱ ya̱nsa̱ baci mavuka ma na mi n tsukere ci ni ɗa mi babu kamana kpamu ali u vaki n a̱yi, sai ta na u tsupa yi ikebe i mazama i ni, a̱yi ɗa kpamu u kuzuwa yi wo okpo vuka vu ni. ");
INSERT INTO asg_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ama esheku ta na a̱ sa̱nka̱ baci, ikebe i yolo i na u la̱nga̱sa̱i ni i ɗaɗa u kutsupa koci. ");
INSERT INTO asg_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","<<Ka̱ta̱ i ka̱sukpa̱ vuka vu na vi nu nkunu n wuma ba. ");
INSERT INTO asg_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","<<Vuza na baci u yaꞋin tsugbani m manama i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","<<Vuza na baci u yaꞋin alyuka u ka̱ma̱li, ba a̱ ubuta̱ u Vuzavaguɗu ba, a una yi. ");
INSERT INTO asg_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","<<Ka̱ta̱ vu takacika komoci ko vu doro yi ba, ama vu ciɓa avu feu vi yaꞋan ta̱ ida̱shi i limoci a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ka̱ta̱ vu takacika a̱ma̱ci a na ali e le a̱ kuwa̱i ko muku n na mmaci n le n kuwa̱i ba. ");
INSERT INTO asg_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Vi yaꞋan baci ta na nannai a̱ shika̱ baci a kubana wa̱ va̱ mi ta̱ a kupanaka le. ");
INSERT INTO asg_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Wupa u va̱ wi ta̱ a̱ kuɗa̱nga̱, ka̱ta̱ mu una ɗa̱ n kotokobi. A̱ma̱ci a̱ ɗa̱ i ta̱ o kokpo agapa. Muku n ɗa̱ kpamu i ta̱ o kokpo mkpan. ");
INSERT INTO asg_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","<<Vu neke baci Vuza okopu a ikebe a̱ ka̱tsuma̱ ka uma a̱ va̱ a̱ ubuta̱ wa aza a unambi a na i punu a̱ ka̱tsuma̱ ka̱ ɗa̱, ka̱ta̱ vu la̱nsa̱ punu kodokpotsu a ili na vu kopuki va ba. ");
INSERT INTO asg_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Vi isa baci ogbodo a kupalaka uta̱ni u vuza nu tsu uzuwi u kaguta, u gaꞋan ta̱ vu bonoko n aɗa kafu kanna ka̱ yikpa̱, ");
INSERT INTO asg_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","adama a na ɗaɗa u kupalaka ka̱ci ka̱ ni, vu bonoko baci ta na n aɗa ba, yiɗa̱i u tsusaki? Ɗa baci u lapai una̱ a kubana wa̱ va̱. Mi ta̱ a kupanuka yi adama a na mpa vuza va asuvayali ɗa. ");
INSERT INTO asg_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","<<Ka̱ta̱ vi yaꞋan kadanshi ki ishikushi u Ka̱shile ka̱ nu, ko vi shika vuza na wi a kulyaꞋa tsugono a̱ ka̱tsuma̱ ka̱ ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","<<Ka̱ta̱ vu sa̱nka̱ mu kuneꞋe ki ili i kashina i nu m ma̱kya̱n ma na vi ciya̱i feu ba. Mayun ɗa vi neke mu maku ma iyain ma̱ nu ma na a̱ gita̱i kumatsa. ");
INSERT INTO asg_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ta kpamu nannai vu tuka̱ m medendem ma na a̱ gita̱i kumatsa, m mokyon ma̱ nu. Vu ka̱sukpa̱ maku ma na a matsai va ma yaꞋan ayin e cindere a̱yi biꞋi koɓolo n a̱na̱ku, a kanna ka̱ kunla̱i i tuka̱ mu. ");
INSERT INTO asg_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","<<Yi ta̱ o kokpo uma a ciɗa a̱ va̱. Ka̱ta̱ i takuma inyama i na manama ma kakamba mu unai ba, na lo va u gaꞋan ta̱ i taɗuku nsheꞋe. ");
INSERT INTO asg_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","<<Ka̱ta̱ vi yaꞋan utonu n kadanshi ka aꞋuwa ba, ka̱ta̱ kpamu vu ɓolongu una̱ n uma a gbani-gbani adama a na vu ushuku n kadanshi ka aꞋuwa ba. ");
INSERT INTO asg_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ka̱ta̱ vu ushuku kutono ka̱bunda̱i ka uma adama a na i yaꞋan ili i gbani-gbani ba. Vi baci kpamu e kuneke ngan a̱ ubuta̱ u kayaꞋinkafada, ka̱ta̱ vu sabaꞋa kadanshi ka mayun adama a na vu tono i na ka̱bunda̱i ka cigai ba. ");
INSERT INTO asg_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ka̱ta̱ vu laꞋa n kuciga vuza vu unambi a̱ ubuta̱ u kadanshi ka afada a̱ ni ba. ");
INSERT INTO asg_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","<<Vu cina baci kanaka ko majaki ma vurala vu nu a kuciga kupuwa̱nka̱ yi, ɗika vu banka yi. ");
INSERT INTO asg_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ve ene baci majaki ma vuza na u iwain nu ma̱ yikpa̱i n ucanuku ali ɗa u tsugbai ni, ka̱ta̱ vu ka̱sukpa̱ maꞋa ba. Vu bana vu ɓa̱nka̱ yi m maꞋa. ");
INSERT INTO asg_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","<<Ka̱ta̱ vu sabaꞋa ukuna u mayun a̱ ubuta̱ wa aza a unambi a̱ nu a̱ ubuta̱ wa afada ba. ");
INSERT INTO asg_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","YaꞋan daꞋin n kadanshi ka nsata ma aꞋuwa, ka̱ta̱ vu una vuza na wi babu unushi ko vuza vu usuɓi ba. Adama a na mpa mi ta̱ a̱ kilukpa̱ vuza na u yaꞋin unushi u nanlo dem. ");
INSERT INTO asg_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ka̱ta̱ vi yaꞋan n kalyaꞋa ba, adama a na kalyaꞋa ka tsu zuwa wu ta̱ vi yimba̱na̱ vu kpa̱ɗa̱ kene ili i na yi derere mayin. KalyaꞋa ka tsu zuwa ta̱ vuma vu usuɓi u kpa̱ɗa̱ ku uta̱ka̱ ili i mayun e keteshe. ");
INSERT INTO asg_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","<<Ka̱ta̱ vu takacika komoci ba, adama a na a̱ɗa̱ a̱ ka̱ci ka̱ ɗa̱ i yeve ta̱ tsu na limoci yi, yi ishi ta̱ a̱ limoci a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","<<A̱ya̱ a̱ ta̱li a ɗa va kuyaꞋan avu a̱ kuca̱Ꞌa̱ kashina ka̱ nu n vi kyaꞋi ili i na vi ca̱Ꞌi va, ");
INSERT INTO asg_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ama a̱ ka̱ya̱ ke cindere vu ka̱sukpa̱ ubuta̱ wa wu uvuka. Ka̱ta̱ aza a unambi a̱ ka̱tsuma̱ ka̱ ɗa̱ a̱ ciya̱ feu ili i na a kulyaꞋa punu. Ili i na baci tamkpamu i buwai nnama n kakamba n ciya̱ feu a takuma. Ta feu va kuyaꞋan n kashina ki itacishi n kashina ka Zaitu ka̱ nu nannai. ");
INSERT INTO asg_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","<<Ayin a̱ ta̱li a ɗa va kuyaꞋan ulinga, a kanna ke cindere ka ɗaɗa va kuvuka, adama a na anaka, ni njaki n nu a̱ ciya̱ feu a uvuka. Ka̱ta̱ muku ma agbashi a na a matsakai ɗa̱ n omoci a na i punu ida̱shi wa̱ ɗa̱ ele feu a ciya̱ a uvuka. ");
INSERT INTO asg_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","<<Zuwai atsuvu i pana mayin n ili i na n danai. Ka̱ta̱ i ɗeke ula a̱ a̱ma̱li o yoku ba, ka̱ta̱ kpamu yu ula le punu a̱ una̱ u ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","<<Ka̱ya̱ lakam yi ta̱ a kuyaꞋan ka̱ɗiva̱ ka nampa ali kutatsu, adama a na i neke mu tsugbayin. ");
INSERT INTO asg_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","I yaꞋan ka̱ɗiva̱ ka nampa ko boroji vu na vi n yisiti ba, i ta̱kuma boroji vu babu yisiti va ali ayin e cindere, tsu na n danai ɗa̱. I yaꞋan ka̱ɗiva̱ ka nampa a ayin a na i zuwai a̱ ka̱ya̱ lakam a̱ ka̱tsuma̱ ko wotoi u Abibu, adama a na a wotoi u nanlo u ɗaɗa yu uta̱i a iɗika i Masar. Ka̱ta̱ vuza u ta̱wa̱ wa̱ va̱ ekiye agaɗa ba. ");
INSERT INTO asg_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","I yaꞋansa ka̱ɗiva̱ ka ayin a vukyaꞋa, n avaꞋinka a iyain a̱ ica̱shi i kashina i ɗa̱. Ka̱ta̱ a uteku, i ciɓasa kpamu n ka̱ɗiva̱ ka libani i vutara a ayin a na baci i ɓolongushi ili i kashina i ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","A̱ ka̱ya̱ dem mavali mi ta̱ a̱ kuta̱wa̱ a̱ ubuta̱ u Vuzavaguɗu Uba̱nga̱ri kutatsu. ");
INSERT INTO asg_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","<<Ka̱ta̱ i yaꞋanka mu alyuka a mpasa koɓolo n ili i na a yaꞋin n yisiti ba. Ka̱ta̱ feu i ka̱sukpa̱ ushuma punu a inyama ya alyuka, ya asa ali a kubana a usana ba. ");
INSERT INTO asg_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","<<Vu tuka̱ n avaꞋinka a na a laꞋi n kugaꞋan a ili i kashina i na i gita̱i kugeꞋwe i nu a kpaꞋa ku Vuzavaguɗu Ka̱shile ka̱ nu. <<Ka̱ta̱ kpamu vu suꞋwan maku ma maraɗika ma na mi a kapa mani ma̱ a̱na̱ku a̱ ni ba. ");
INSERT INTO asg_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","<<La̱na̱, mpa n kusuku ta̱ kalingata kelime ka̱ nu adama a na wi indana wu a̱ ubuta̱ u na vi a nwalu dem, ciya̱ vi yawa m ma̱ta̱na̱ a̱ ubuta̱ u na n foɓusokoi nu. ");
INSERT INTO asg_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ka̱ta̱ vu zuwa atsuvu kpamu vu pana mayin n ili i na u kudana. Ka̱ta̱ i shilika̱ n kadanshi ka̱ ni ba, adama a na a̱yi wa kucinukpaka ɗa̱ n ugbamukaci u nanlo ba. Adama a na kula ku va̱ ki ta̱ punu wa̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","<<Vu panaka yi baci mayin ɗa vi yaꞋin i na n danai, mi ta̱ o kokpo vurala a̱ ubuta̱ wi irala i nu, mi ta̱ kpamu a kuꞋiwan aza a na a iwain nu. ");
INSERT INTO asg_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","<<Kalingata ka̱ va̱ ki ta̱ a kuwala kelime ka̱ ɗa̱, ka̱ta̱ u tono n a̱ɗa̱ u tuka̱ ɗa̱ a iɗika ya aza Amoriya, n aza a Hitiya, n aza a Periziya, n aza a KanaꞋana n aza a Hiwiya n Jebusiya. Mi ta̱ a kuna le ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ka̱ta̱ i kuɗa̱nku a̱ma̱li e le ko i cikpa le ba, ka̱ta̱ i tono ili i gbani-gbani i na i a kuyaꞋan ba. I fa̱da̱ a̱ma̱li a ka̱ta̱ i ɓoso atali a na a tsu lyuka kpamu miri-miri. ");
INSERT INTO asg_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","I cikpa Vuzavaguɗu Ka̱shile ka̱ ɗa̱ koci, i yaꞋan baci nannai mi ta̱ a kuzuwaka ɗa̱ una̱singai wi ili kulyaꞋa m mini. Mi ta̱ a kuraɗa iɓa̱lishi i na i kuta̱wa̱ wa̱ ɗa̱ dem. ");
INSERT INTO asg_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Babu vuka vu na ka̱tsuma̱ ka̱ ni ka̱ kuta̱ a̱ ka̱tsuma̱ ka̱ ɗa̱, a̱ kuciya̱ punu kpamu madari a iɗika i ɗa̱ ba. Mi ta̱ a kuzuwa ɗa̱ i yongo n a̱ya̱ kau. ");
INSERT INTO asg_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mi ta̱ a̱ kusuku ili i na i kuneke wovon a iɗika i na i kureme dem kafu i yawa ɗe, ka̱ta̱ a̱ ripula̱. Mi ta̱ a kuzuwa irala i ɗa̱ ra̱ka̱ a kpatala ka̱ta̱ a suma. ");
INSERT INTO asg_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mi ta̱ a̱ kusuku itata e kelime ka̱ ɗa̱, adama a na i loko aza a Hiwiya n aza a KanaꞋana n aza a Hitiya. ");
INSERT INTO asg_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ama a̱ ka̱ya̱ ke te kaꞋa n kuloko le ba, ta lo iɗika ya yo kokpo an agali, ka̱ta̱ nnama n kakamba ma n yimkpa ali n lyaꞋa utsura u ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Kenu-kenu ɗa mi o kuloko le, ali i yimkpa tsu na i kufuɗa ya lyaꞋa utsura wi iɗika ya, ka̱ta̱ i ɗa yo okpo i ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mi ta̱ a kuzuwa uteku wa u gita̱ a mala ma shili a kubana a mala ma aza a̱ Filisitiya̱, a kubana gaɗi vu meremune a kubana e kuyene ku Yufiretu. Mi ta̱ e kuneke ɗa̱ uma a na i ida̱shi a iɗika ya e ekiye a̱ ɗa̱, ka̱ta̱ i loko le punu kelime ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ka̱ta̱ i yaꞋan uzuwakpani n ele ko n a̱ma̱li e le ba. ");
INSERT INTO asg_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ka̱ta̱ i ka̱sukpa̱ a̱ da̱sa̱ngu punu a iɗika ya ba, i ka̱sukpa̱ baci ta na i ta̱ a kuzuwa ɗa̱ i yaꞋanka mu unushi. Adama a na i ta̱ a kuzuwa ɗa̱ i yaꞋanka a̱ma̱li e le tsugbashi, i ta̱ o kokpo kpamu an maza wa̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ɗaɗa Vuzavaguɗu u danai Musa, <<Ta̱wa̱ i kumba na gaɗi avu n Haruna, n Nadabu n Abihu n aza a̱ gba̱ra̱-gba̱ra̱ amangatatsunkupa a aza a Isaraila, i shamgba daꞋin ka̱ta̱ i cikpa mu. ");
INSERT INTO asg_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa endeꞋen a̱yi ɗa u kuyawa ɗevu nu mpa, aza a na a buwai ka̱ta̱ a gbaga ɗevu ba, ka̱ta̱ kpamu aza a Isaraila a na a buwai feu a kumba kusan ka n a̱yi ba.>> ");
INSERT INTO asg_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ana Musa u banai u danai uma ukuna u wila̱ n udani u Vuzavaguɗu, ɗa uma a ushiki n ka̱la̱ka̱tsu ke te ɗa a danai, <<Ci ta̱ a kuyaꞋan ili i na Vuzavaguɗu u danai dem.>> ");
INSERT INTO asg_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ɗa Musa u ɗanai ili i na Vuzavaguɗu u danai ni ra̱ka̱. Ɗa u ɗa̱nga̱i n usana ka̱li-ka̱li ɗa u maꞋi katalikalyuka ɗaka vu kusan va. Ɗa u darai atali kupanere o okpoi agisana a kumaci kupanure ka aza i Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ɗa u suki olobo o yoku a aza i Isaraila a yaꞋan alyuka o kusongu, ka̱ta̱ kpamu a lyuka obomburon tsa alyuka a̱ ma̱ta̱na̱ a kubana a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ɗa Musa u pecei mpasa mu nnama n na a kiɗai va ku re, n te u tsungi e nvene, n te kpamu ɗa u vishangushi n ɗa a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ɗaɗa u ɗikai Katagarda ku Uzuwakpani ɗa u kecekei uma a. Ɗaɗa a̱ ushuki, <<E, ci ta̱ a kuyaꞋan ra̱ka̱ ili i na Vuzavaguɗu u danai tsu ci yaꞋan, ka̱ta̱ kpamu tsu tono i ɗa.>> ");
INSERT INTO asg_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ɗa Musa u ɗikai mpasa ma ɗa u vishanki uma ɗa u danai, <<Mpasa n nampa ma n ɗaɗa n na n kuyotsongu uzuwakpani u na Vuzavaguɗu u yaꞋin n a̱ɗa̱ a na u nekei ɗa̱ wila̱ wa.>> ");
INSERT INTO asg_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa n Haruna n Nadabu n Abihu, n aza a̱ gba̱ra̱-gba̱ra̱ a Isaraila amangatatsunkupa a kumbai a kusan ka. ");
INSERT INTO asg_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ɗa e enei Ka̱shile ki Isaraila. A ɗaka va adasukpatsu a̱ ni va adanshi wingingi wa atali u na e ci ɗeke safaya a kutasa kelyu-keylu uteku tsu mindatsu ma na mi a kakana kanna. ");
INSERT INTO asg_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Aza a̱ gba̱ra̱-gba̱ra̱ a Isaraila e enei Ka̱shile, ama kukiye ku Ka̱shile ku saꞋwa le ba, ɗa a lyaꞋi n o soꞋi a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ɗa Vuzavaguɗu u danai Musa, <<Ta̱wa̱ vi cina mu gaɗi vu kusan na, ka̱ta̱ vi shamgba punu, mi ta̱ e kuneke wu nshemberu ma atali n na mi uɗani n wila̱ u na n ɗanai, adama a na i yotsongusu uma.>> ");
INSERT INTO asg_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ɗa Musa n ka̱ɓa̱nki ka̱ ni Jesuwa o foɓusoi, ɗa Musa u kumbai kusan ku Ka̱shile ka. ");
INSERT INTO asg_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ɗa u danai nkoshi m gba̱ra̱-gba̱ra̱, <<Vanai tsu na, sai ayin a na tsu bonoi. Haruna n Horu i ta̱ o kokpo n a̱ɗa̱, vuza na baci wi n kadanshi u bana we le.>> ");
INSERT INTO asg_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ana Musa u kumbai kusan ka, ɗa eleshu a palai kusan ka. ");
INSERT INTO asg_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ɗa tsugbayin tsu Vuzavaguɗu ci cipa̱i lo a Kusan ku Sinai. Ali ayin a̱ ta̱li eleshu a palai kusan ka, ɗa a kanna ke cindere, ɗa Vuzavaguɗu punu e eleshu a u ɗekei Musa. ");
INSERT INTO asg_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","A̱ ubuta̱ wi Isaraila wa lo, ɗa e enei tsugbayin tsu Vuzavaguɗu ci yotsoi akina a na i a kulyaꞋa gaɗi vu kusan. ");
INSERT INTO asg_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ɗa eleshu a palai Musa a ayin a na wi a kukumba gaɗi ka̱u a kusan ka. Ɗaɗa u shamgbai ɗe, ali ayin amangere kanna n kayin. ");
INSERT INTO asg_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","<<Dana aza a Isaraila a̱ tuka̱ mu n kuneꞋe ku le. Avu ɗa va kisaka mu kuneꞋe ka u yaba dem vu na ka̱ɗu ka̱ ni ku ushuki kuneke. ");
INSERT INTO asg_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Na va ɗaɗa kuneꞋe ku na i kisa we le, azanariya, azurufa koɓolo n iyum i shili, ");
INSERT INTO asg_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","mini mu usuni, mini ma̱ ma̱ɗiya̱, m mini ma̱ ma̱jigi, n arikinla a singai, n cileme tsu nraɗika, ");
INSERT INTO asg_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","n ukpan wu nkyon u na a̱ rumbuki n garula, n ukpan wu nraɗika u singai, m maɗanga me megele, ");
INSERT INTO asg_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","m maniꞋin ma̱ ka̱la̱nji adama a̱ ma̱kuni, n icita adama a maniꞋin me kerengu, n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","n atali o onis, n atali a na a buwai a singai a singai adama a na a paɗara efodu m mabambata ma̱ ma̱ka̱nga̱ ma efodu ma. ");
INSERT INTO asg_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Vu zuwa le a maꞋaka mu ubuta̱ wi ida̱shi u ciɗa, ka̱ta̱ mpa n da̱sa̱ngu punu n ele. ");
INSERT INTO asg_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Vi yaꞋan Ma̱va̱li ma Kuciɓa n Ka̱shile ma nampa n ili i na i buwai dem derere ci iyoci tsu na n kuyotsongu wu. ");
INSERT INTO asg_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","<<Vu zuwa uma a yaꞋan Akpati va, m maɗanga me megele. Ugaɗi u ni u yawa udashi u tatsu n udyawi amangatatsu n kupa n u tawun, wanshi u ni kpamu udashi u re n udyawi kamanga n u tawun, kashani ka̱ ni ka yawa udashi u re n udyawi kamanga n u tawun. ");
INSERT INTO asg_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Vu kuma kucina̱ ku ni n suvu a̱ ni dem n azanariya koci, ka̱ta̱ vu gece ka̱ga̱Ꞌin ku una̱ u ni wa kpamu n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ka̱ta̱ vu luwa̱ nkawani ma azanariya n na̱shi, ka̱ta̱ vu uka n ɗa e ene a akpati va. Nkawani n re a kakambu ka nampa n re a kakambu ka nan ɗe. ");
INSERT INTO asg_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ka̱ta̱ i yaꞋan kpamu alangu nu nɗanga mi ngele, ka̱ta̱ i kuma a ɗa n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I uka alangu a punu a asuvu a nkawani ma Akpati ma, adama a ika̱na̱tsu i kuɗika. ");
INSERT INTO asg_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Alangu a nampa ta punu o kuyongo u uki a nkawani ma akpati ma, ka̱ta̱ vuza u toɗo a ɗa ba. ");
INSERT INTO asg_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ka̱ta̱ i zuwa punu nshemberu ma atali n re n na mi n kadanshi ku ukuna u wila̱ wa, n na n kuneke wu. ");
INSERT INTO asg_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","<<Vi yaꞋan ka̱kuya̱mkpa̱tsu ka kutsupa unushi ka n azanariya koci, ugaɗi u ni u yawa udashi u tatsu n udyawi amangatatsunkupa n u tawun, wanshi u ni kpamu udashi u re n udyawi kamanga n u tawun. ");
INSERT INTO asg_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Vi yaꞋan Corobi vu re n azanariya a na a yimai, ka̱ta̱ vu zuwa i ɗa a akambu e re dem a̱ ka̱kuya̱mkpa̱tsu ka Akpati ka. ");
INSERT INTO asg_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ka̱ta̱ a yaꞋan i ɗa, i te a kakambu ka nampa i te kpamu a kakambu ka nan ɗe, i yaꞋan i ɗa u matyangi punu n ka̱kuya̱mkpa̱tsu ka akpati ka. ");
INSERT INTO asg_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","I zuwa ili ya a mindanai a kinda ka̱kuya̱mkpa̱tsu ka, i zuwa evelyu e le ubapi uɗengushi adama a na a pala ka̱kuya̱mkpa̱tsu ka. ");
INSERT INTO asg_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ka̱ta̱ vu zuwa punu nshemberu ma atali n na mi uɗani n kadanshi ka ukuna u wila̱ wa, u na mpa n kuneke ɗa̱, ka̱ta̱ vu kuya̱ngu n ka̱kuya̱mkpa̱tsu ka Akpati ka. ");
INSERT INTO asg_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","A gaɗi vu ka̱kuya̱mkpa̱tsu ka e mere me Corobi vi re vu na vi gaɗi va akpati vu wila̱ va, mi ta̱ a kugasa n avu ɗe ka̱ta̱ n neke wu wila̱ u va̱ ra̱ka̱ adama a uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","<<Ka̱ta̱ vi yaꞋan kirukpa ku maɗanga me megele, ugaɗi u ni u yawa udashi u tatsu, wanshi u ni u yawa udashi u te n kagimi. Ka̱ta̱ kashani ka̱ ni ka yawa udashi u re n udyawi kamanga n u tawun. ");
INSERT INTO asg_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ka̱ta̱ vu paɗara vu ɗa n azanariya koci, vu maꞋa ka̱ga̱Ꞌin ku una̱ ka n azanariya a̱ kuka̱ra̱Ꞌa̱. ");
INSERT INTO asg_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ka̱ta̱ vu sheꞋwe ili tsu makawani a̱ kuka̱ra̱ka̱, ka̱ta̱ wanshi u ni u laza kataka ke kukiye ba. Ka̱ta̱ vu tono ka̱ga̱Ꞌin ka vu maꞋa kaꞋa n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Luwa̱ nkawani n na̱shi ma azanariya, ka̱ta̱ vu uka n ɗa ɗe a ngon n na̱shi n kirukpa ma dem. ");
INSERT INTO asg_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","I koɓo nkawani ma ɗevu n nshikpu ma, adama a na a̱ ɓa̱na̱ alangu a na a ci ɗikaka kirukpa ka. ");
INSERT INTO asg_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Vi yaꞋan ashamkpatsu a m maɗanga me megele, ka̱ta̱ vu paɗara n azanariya, a ɗaɗa a kuɗika kirukpa ka. ");
INSERT INTO asg_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ka̱ta̱ vi yaꞋan apara ni nvene n atan a na a yaꞋin n azanariya koci, koɓolo kpamu nu nsasu n a̱ka̱na̱tsu n na a tsu yaꞋanka ulinga a̱ ubuta̱ u kutsungu ili i kuɗarukpa alyuka o kusoꞋo. ");
INSERT INTO asg_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ayin tutu vi ta̱ a kuzuwa punu Boroji vu na o foɓusoi adama va̱. ");
INSERT INTO asg_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","<<Vi yaꞋan kashamkpatsu ka̱ ma̱kuni ka n azanariya koci a na a yimai, kashamkpatsu ka n anci a̱ ni, iyoci ya̱ a̱pa̱lu a̱ ni, mɓom n ni n uba̱zukpi u ni wokpo ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","YaꞋan acaka a̱ ta̱li a uta̱ ɗe a kakambu ka̱ ni, acaka a tatsu a kashamkpatsu ka̱ ma̱kuni ka a̱ uta̱ a kakambu ke te, acaka a tatsu kpamu a kakambu ka na ka buwai. ");
INSERT INTO asg_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","AtaꞋan, a tatsu a na a yaꞋin n iyoci ya̱ a̱pa̱lu a alumo, nu mɓom, nu uba̱zukpi, okpo a kacaka ke te, a tatsu a kacaka ka nan ɗe, ta u kuyaꞋan nannai ra̱ka̱ na acaka a̱ a̱ta̱li a na uta̱i a kashamkpatsu ka. ");
INSERT INTO asg_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ɗe a kashamkpatsu ka i ta̱ a kuyaꞋan atan a̱ na̱shi n iyoci ya̱ a̱pa̱lu a alumo nu uɓomi koɓolo nu uba̱zukpi u ni. ");
INSERT INTO asg_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Moɓom me te mi ta̱ a kuyaꞋan a ɗaka vu kacaka ku ugiti, ka na ku uta̱i a kashamkpatsu ka̱ ma̱ ma̱kuni, moɓom me ire a ɗaka vu kacaka ke ire, moɓom ma tatsu kpamu a kacaka ka tatsu, dem vi le acaka a̱ ta̱li. ");
INSERT INTO asg_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Moɓom ma n acaka a i ta̱ umatyangbani n kashamkpatsu ka na a yimai n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","MaꞋan nkuni n cindere ka̱ta̱ vu zuwa le gaɗi adama a na akana ubuta̱ e kelime ke le. ");
INSERT INTO asg_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ikaɓatsu i kukima̱ka̱ akina a, n a̱mbu a, a yaꞋan a ɗa n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ka̱ta̱ vi yaꞋan ashamkpatsu a̱ nkuni a̱ ni n ikoɓomgushi i le n azanariya koci a na a̱miki e le a yawai kilo kamangankupa n vu na̱shi. ");
INSERT INTO asg_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Vu fuɗa vi yaꞋan ili ya uteku ci iyoci i na n yotsongi nu ɗe a kusan ka. ");
INSERT INTO asg_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","<<Ka̱ta̱ vu maꞋa Ma̱va̱li ma̱ Ka̱shile ma n akashi a̱ utsutsu a singai kupa a na a yaꞋin n arikinla n tsugbere tsa akaɗa tsu mini mu usuni n tsu mini ma̱ ma̱ɗiya̱ n tsu mini ma garula. Ka̱ta̱ kacaꞋi ka yaꞋan akashi a n tsuzogu ci Corobi. ");
INSERT INTO asg_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Akashi a a yaꞋan ushan dem derere, ugaɗi udashi amangere n u re wanshi kpamu udashi u ta̱li. ");
INSERT INTO asg_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ka̱ta̱ i jilya̱ akashi a̱ utsutsu a tawun a̱ ubuta̱ u te, i yaꞋan kpamu nannai n aza a tawun a na a buwai va. ");
INSERT INTO asg_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Avu yaꞋanka akashi a̱ utsutsu a nroki n kusaku m mini mu usuni a̱ ka̱ga̱in ku uteku, a zuwa n ɗa a akashi a̱ utsutsu a na a̱ jilya̱i a̱ ubuta̱ u te wa ali n ugboku u ire wa dem. ");
INSERT INTO asg_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Vi jilya̱ka̱ kakashi ku utsutsu ku uɓolongi ka nroki n kusaku amangerenkupa. Nannai ɗa kpamu va kuyaꞋan n kakashi ka na ka buwai va nu nroki amangerenkupa feu, nroki n kakambu ka nan ɗe a kindasanai nu nroki n kakambu ka nampa. ");
INSERT INTO asg_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Vi yaꞋan ika̱na̱tsu n azanariya ali amangerenkupa, vu ɓolongu ugboku u re wa n ashiyatsu a, adama a na Ma̱va̱li ma Kuciɓa n Ka̱shile ma yaꞋan me te kpukuru. ");
INSERT INTO asg_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","<<Ka̱ta̱ kpamu vu lapula akashi a̱ utsutsu n cileme tsu nraɗika, adama a̱ Ma̱va̱li mo Oɓolo ma na a kupalaka gaɗi vu Ma̱va̱li ma Vuzavaguɗu ma, akashi kupa n ke te ɗa va kuyaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Akashi a̱ utsutsu kupa n ke te a nampa dem a yaꞋan derere, ugaɗi u yaꞋan udashi amangere n u tawun, ka̱ta̱ wanshi u yawa udashi u ta̱li. ");
INSERT INTO asg_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Vu ɓolongu akashi a̱ utsutsu a tawun a nanlo a dem a̱ ubuta̱ u te, ka̱ta̱ o okpo kakashi ke te. Ka̱ta̱ akashi a̱ ta̱li a na a buwai na lo va feu vu ɓolongu le ubuta̱ u te tsu kakashi ke te ko yoku. Vu gosomgbonoi kakashi ka̱ ta̱li ka kure e kelime ka̱ Ma̱va̱li ka. ");
INSERT INTO asg_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Vu jilika̱ akashi a na o ɓolongi tsu una̱ u te wa dem nroki n kusaku a uteku, ali amangerenkupa, nannai ɗa kpamu va kuyaꞋan n ugboku u na u buwai. ");
INSERT INTO asg_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","<<Vi ta̱ a kuyaꞋan ika̱na̱tsu n viyum vi shili ali amangerenkupa vu zuwa moroki dem a̱ ubuta̱ u kushiya u ni. N uye u nampa, ma̱va̱li ma mi ta̱ o kokpo n uye u te koci o ɓolongu ka̱ta̱ o okpo ma̱va̱li me te. ");
INSERT INTO asg_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kagimi ka kakashi ka na baci ka pasai ko ka buwai, i ta̱ a kusaku kaꞋa a̱ kucina̱ ku ma̱va̱li ka. ");
INSERT INTO asg_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Vi ta̱ a̱ kuka̱sukpa̱ udashi u te n kagimi u ta̱lukpa̱ u ka̱na̱ ka̱ta̱la̱la̱ adama a na u pala ma̱va̱li ma ra̱ka̱-ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Vi yaꞋan ka̱ɓa̱ya̱mkpa̱tsu ka̱ ma̱va̱li ma n ukpan wu nkyon u na a̱ rumbuki m mini ma garula. Vi yaꞋan kpamu ka̱ɓa̱ya̱mkpa̱tsu ko yoku ka singai n ukpan wu nraɗika. ");
INSERT INTO asg_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","<<Vi yaꞋan muntsa mu utsutsu u ma̱va̱li wa m maɗanga me megele, vi shikpa̱ le kashani. ");
INSERT INTO asg_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Muntsa mu utsutsu dem ma yawa udashi gendu, wanshi kpamu u yawa udashi u re n udyawi kamanga n u tawun, ");
INSERT INTO asg_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","n aguta ere uzuwi derere n vutoku. Ta va kuyaꞋan muntsa mu utsutsu u ma̱va̱li ma̱ Ka̱shile ma nannai. ");
INSERT INTO asg_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Vi yaꞋan muntsa mu utsutsu kamanga adama a na a̱ ka̱na̱ akashi a a uɓon u ɗaka u ma̱va̱li wa. ");
INSERT INTO asg_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ka̱ta̱ vi yaꞋan kpamu ida̱sa̱mkpa̱tsu n azurufa ali amangere, ebelyu e re a ɗaka va̱ a̱ga̱Ꞌin a̱ utsutsu dem, yaba dem vi le n kokoɓotsu ka na ka̱ kuka̱na̱ le mayin. ");
INSERT INTO asg_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A uɓon u gaɗi u ma̱va̱li ma̱ Ka̱shile ma, vi yaꞋan kpamu iga̱Ꞌin a̱ utsutsu kamanga, ");
INSERT INTO asg_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","n ubuta̱ wi ida̱sa̱mkpa̱tsu wa azurufa ali amangere, aza e re a̱ kumiꞋi ku ka̱ga̱Ꞌin ku utsutsu dem. ");
INSERT INTO asg_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Vi yaꞋan iga̱Ꞌin a̱ utsutsu a̱ ta̱li, a̱ kucina̱ a̱ ka̱livi ka̱ Ma̱va̱li ka. ");
INSERT INTO asg_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Vi yaꞋan kpamu muntsa mu utsutsu n re adama a na a̱ ka̱na̱ uɓon wu ngon a̱ kucina̱ ku Ma̱va̱li ka. ");
INSERT INTO asg_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Iga̱Ꞌin a̱ utsutsu o ngon a nanlo a, o ɓolongu a ɗa kure, ili i na i gita̱i punu ɗaka ali a kubana gaɗi, a gasa ɗe gaɗi a̱ ubuta̱ u makawani me te, ka̱ta̱ o okpo mogon me te. Ta vo kuɓolongu ngon ma mo okpo nannai. ");
INSERT INTO asg_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ka̱ta̱ iga̱Ꞌin a̱ utsutsu a a̱ ɗa̱nga̱ kunla̱i n ida̱sa̱mkpa̱tsu ya azurufa a̱ ida̱shi e le gendu n ke te. Ida̱sa̱mkpa̱tsu i re i re a ɗaka va̱ iga̱Ꞌin a̱ utsutsu dem. ");
INSERT INTO asg_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","<<Ka̱ta̱ vi yaꞋan aburakpatsu a tawun m maɗanga ma a megele, adama iga̱Ꞌin a̱ utsutsu a na a yaꞋin va a kakambu ka̱ ma̱va̱li ka, ");
INSERT INTO asg_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","a tawun kpamu adama a kakambu ke te ka na ki a uɓon u ɗaka, a tawun o yoku kpamu a kakambu ku uteku ka nan ɗe, ka na ki a̱ ka̱livi. ");
INSERT INTO asg_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kaburakpatsu ka na ki e mere ma̱ iga̱Ꞌin a̱ utsutsu a, i ta̱ a kupasamgbanai a̱ kugita̱ uteku u nampa ali a kubana a uteku u nan ɗe. ");
INSERT INTO asg_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Vu kuma iga̱Ꞌin a̱ utsutsu a n azanariya, vu zuwa nkawani ma azanariya n na n kuka̱na̱ aburakpatsu a. Ka̱ta̱ kpamu vu kuma aburakpatsu a n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ta va kuyaꞋan Ma̱va̱li ma̱ Ka̱shile ma nannai ci iyoci i na n yotsongi nu a kusan ka. ");
INSERT INTO asg_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","<<Vi yaꞋan kakashi ku tsutsu n arikinla n tsugbere tsu mini mu usuni, n tsugbere tsu na ci a na mini ma̱ ma̱ɗiya̱ n tsugbere tsu mini ma garula n tsugbere tsa akaɗa, ka̱ta̱ i yaꞋan ci Corobi n tsuzogu tsu na kacaꞋi ku uyevi ka yaꞋin. ");
INSERT INTO asg_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ka̱ta̱ vu saku ɗe kakashi ku utsutsu ka gbayin ka a̱ nshikpu n na̱shi m maɗanga ma megele n na a kumai n azanariya, ɗa kpamu a zuwai le a ida̱sa̱mkpa̱tsu i na a yaꞋin n azurufa. ");
INSERT INTO asg_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Vu saku kakashi ku utsutsu ka a ɗaka vu nroki n na a darai adama a kupalaka ma̱va̱li ma. Ka̱ta̱ vu zuwa punu akpati vu wila̱ va, a̱ kucina̱ ku kakashi ku utsutsu ka. Kakashi ku utsutsu ka ɗaɗa ke kupece ubuta̱ u ciɗa n ubuta̱ u na u laꞋi n ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Vu zuwa ka̱kuya̱mkpa̱tsu ka ku tsupaka unushi ka a akpati vu wila̱ punu a̱ ubuta̱ u na u laꞋi n ciɗa va. ");
INSERT INTO asg_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Vu zuwa kirukpa n tsupulai tsu kakashi ku utsutsu a uɓon u gaɗi u Ma̱va̱li wa, ka̱ta̱ vu zuwa kashamkpatsu ka̱ ma̱kuni vu pasamgbanai ma̱va̱li ma a uɓon u ɗaka. ");
INSERT INTO asg_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","<<Vi yaꞋan kakashi ku utsutsu u kuꞋuwa a̱ ka̱pa̱m wa nannai n arikinla n tsugbere tsu na ci an mini mu usuni, n tsu na ci yotsoi an mini ma̱ ma̱ɗiya̱ n tsugbere tsu mini ma garula, n tsugbere tsa akaɗa tsu singai. Ka̱ta̱ kacaꞋi ka kala kakashi ka. ");
INSERT INTO asg_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Vi ta̱ a kuyaꞋanka kakashi ka nshikpu m maɗanga ma megele, ka̱ta̱ vu kuma n azanariya. Ka̱ta̱ vu saku kakashi ka nu nroki ma azanariya, n ida̱sa̱mkpa̱tsu i tawun i le i na a yaꞋin n iyum i shili. ");
INSERT INTO asg_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","<<Vi yaꞋan katalikalyuka ka m maɗanga ma megele, ugaɗi u ni u yawa udashi u cindere n kagimi, wanshi kpamu nannai udashi u cindere n kagimi. Uɗa̱ngi u ni u yaꞋan udashi u na̱shi n kagimi, wanshi n ugaɗi u katalikalyuka ka u yaꞋan feu derere. ");
INSERT INTO asg_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Vi yaꞋan avana a ngon n na̱shi n ni dem, adama a na avana a o okpo umatyangbani ubuta̱ u te punu n katalikalyuka ka, ka̱ta̱ vu kuma kaꞋa n vuyum vi shili. ");
INSERT INTO asg_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Vu maꞋa mgbodo n na a̱ ku tsuwa̱nsa̱ka̱ kokomo ka katalikalyuka ka, n ikenekpetsu ya akina, n apara, n ikaɓatsu, n a̱mbu a̱ kupura̱ka̱ cikina, ili i nampa ya a yaꞋan i ɗa n iyum i shili. ");
INSERT INTO asg_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ka̱ta̱ vi yaꞋan katalikalyuka n kazatsu n viyum vi shili, ɗe atusu a ka̱ta̱ vu uka nkawani mi iyum i shili n na̱shi adama a ngon n na̱shi n katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Vu zuwa kazatsu ɗaka, adama a na u pala katalikalyuka ka kagimi. ");
INSERT INTO asg_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Vi yaꞋan alangu a̱ kuɓa̱na̱ka̱ katalikalyuka ka m maɗanga ma megele vu kuma maꞋa n viyum vi shili. ");
INSERT INTO asg_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Vu uka alangu a punu a nkawani ma, akambu e re dem adama a na a̱ ciya̱ a yaꞋanka ulinga a ayin a na baci i a kuɗika katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Vi yaꞋan katalikalyuka ka n kungu nu nɗanga n na e sheꞋwei n na mi wanshi, ka̱ta̱ vu yaꞋan tsa akpati vu na vi n ka̱ɓa̱ya̱mkpa̱tsu ba, tsu na n yotsonki nu a kusan ka. ");
INSERT INTO asg_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","<<Ka̱ta̱ vi yaꞋan Ulanga u Ma̱va̱li ma kuciɓa n Ka̱shile ma, a saku ɗe kakashi ka na a yaꞋin n arikinlai n tsugbere tsu singai tsa. A uɓon u ɗaka kpamu ugaɗi u kakashi wa u yawa udashi amangatawun (100), ");
INSERT INTO asg_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ka̱ta̱ a saku ɗe akashi a a̱ nshikpu mi iyum i shili kamanga, aza a na a zuwai a anci e le a na a yaꞋin n iyum i shili a na i kamanga feu. Vu saku akashi a̱ utsutsu a nu nroki n na a yaꞋin n azurufa koɓolo nu nkawani. ");
INSERT INTO asg_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ta kpamu i kuyaꞋan nannai n tsu gaɗi a kakashi ka na a kusaku va, ka yaꞋan udashi amangatawun n amangerenkupa (150), nu nshikpu kamanga, ida̱sa̱mkpa̱tsu i le a yaꞋan i ɗa n iyum i shili kamanga feu. Nkawani n awin, a yaꞋan a ɗa n azurufa. ");
INSERT INTO asg_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","<<N tsu ukocishi u ka̱livi u kakashi wa wanshi u ni u yaꞋan udashi amangatatsunkupa n u tawun n nshikpu kupa n ida̱sa̱mkpa̱tsu kupa feu a yaꞋan a ɗa n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","N uɓon u kasana a̱ ubuta̱ u na utsutsu wi, udashi u yawa amangatatsunkupa n u tawun. ");
INSERT INTO asg_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Akashi a kakambu ke te ku utsutsu ka ugaɗi u ni u yawa udashi kamanga n u re n kagimi, ka̱ta̱ i saku ɗe kaꞋa a ashamkpatsu a tatsu ka̱ta̱ i kiyangu le a̱ ida̱sa̱mkpa̱tsu i tatsu ya. ");
INSERT INTO asg_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ta kpamu nannai n kakambu ka nan ɗe. Ukambu u re wu utsutsu wa, a saku ɗe akashi a na i n ugaɗi u na u yawai udashi kamanga n u re n kagimi koɓolo n ashamkpatsu a tatsu n ida̱sa̱mkpa̱tsu a tatsu feu. ");
INSERT INTO asg_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","A utsutsu u kuꞋuwa a ulanga u Ma̱va̱li ma kuciɓa n Ka̱shile ma, ugaɗi u ni u yawa udashi kamangankupa. Ka̱ta̱ a yaꞋan kakashi n arikinla n tsugbere tsu na ci tsu mini mu usuni, n tsu na ci yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, n tsugbere tsa akaɗa. Ka̱ta̱ a caꞋa n igani, ka̱ta̱ a saku ɗe kaꞋa a yaꞋanka le ashamkpatsu a̱ na̱shi n ida̱sa̱mkpa̱tsu i na̱shi. ");
INSERT INTO asg_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ashamkpatsu ra̱ka̱ a na a̱ ka̱ra̱Ꞌi a ulanga u Ma̱va̱li ma kuciɓa n Ka̱shile ma, ka̱ta̱ a shiya le n awin a azurufa. Okoɓotsu e le o okpo a na a yaꞋan n azurufa feu, ida̱sa̱mkpa̱tsu yo okpo i na a yaꞋin n iyum i shili. ");
INSERT INTO asg_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ugaɗi wu ulanga wu uteku u Ma̱va̱li wa ra̱ka̱ u yawa udashi amangatawun n amangerenkupa (150), wanshi u ni u yaꞋan udashi amangatatsunkupa n u tawun, kashani ka̱ ni ka yawa ubapi u cindere n kagimi. Ka̱ta̱ a̱ ka̱ra̱ka̱ uteku wu uba̱nga̱ wa n kakashi ka na a yaꞋin n arikinla a singai, n anci a̱ iyum e le. ");
INSERT INTO asg_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ucanuku u na a kuyaꞋanka ulinga u Ma̱va̱li wa dem, n aguta a na a̱ kushukpa̱ka̱ Ma̱va̱li ma, a uteku wu ulanga u Ma̱va̱li wa feu a yaꞋan i ɗa n iyum i shili. ");
INSERT INTO asg_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","<<Vu dana muku mi Isaraila a̱ tuka̱ m maniꞋin ma zaitu ma na a pishai mayin adama a kutasukusu ma̱kuni ma ayin tutu. ");
INSERT INTO asg_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ka̱ta̱ i zuwa kashamkpatsu ka̱ ma̱kuni a̱ ubuta̱ u Ma̱va̱li mo Oɓolo wa n tsu pulai tsu kakashi ka na a palakai Akpati vu Uzuwakpani vu na vi a̱ ubuta̱ u ciɗa wa. Haruna m muku mo olobo n ni, ele ɗa a̱ kula̱na̱ ma̱kuni ma akina ma kanna n kayin dem, adama a na mo yongo a kakana e kelime ka Vuzavaguɗu. Na va ɗaɗa wila̱ u uma Isaraila, i tono u ɗa ali nu ntsukaya n na i kumatsa. ");
INSERT INTO asg_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","<<Ɗeke vuza nu Haruna m muku molobo n ni, Nadabu n Abihu n Eliyaza n Itama. Vu zagbaka mu ele, ka̱ta̱ vu uta̱ka̱ le a̱ ka̱tsuma̱ ka̱ muku mi Isaraila, adama a na o okpo anan ganu aza na a kuyaꞋanka mu ulinga. ");
INSERT INTO asg_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ka̱ta̱ vu jilya̱ka̱ mokoshi ma̱ nu Haruna ntogu n singai n tsugbayin, n na n kuyotsongu uzagbi u ni. ");
INSERT INTO asg_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","YaꞋan kadanshi n eyevi dem aza a na n nekei kuyeve a̱ ubuta̱ u kujilya̱, a yaꞋanka Haruna motogu adama a kavasa ke kerengu, adama a na wo okpo ganu vu na u kuyaꞋanka mu ulinga. ");
INSERT INTO asg_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Na va ɗaɗa ntogu n na a̱ kujilya̱ka̱ yi, ma na mi n mabanbata n efodu, n eleje, m motogu ma gbayin mu ugaɗi m motogu ma gbati mi igani ma na a caꞋi n ekiye, m ma̱kuꞋun ma tsuganu n kashiyatsu. A̱ jilya̱ka̱ mokoshi ma̱ nu Haruna ntogu n kavasa ke kerengu ka nampa, m muku n ni adama a na a yaꞋanka mu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Aza na a̱ kujilya̱ ntogu ma a yaꞋan ulinga n tsugbere tsu na a ci yaꞋanka kucaꞋa tsa azanariya tsu na ci an mini mu usuni, n tsu na ci yotsoi mini ma garula n tsu mini ma̱ ma̱ɗiya̱, n arikinla a singai. ");
INSERT INTO asg_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","<<Ka̱ta̱ a̱ jilya̱ efodu va n tsugbere tsu kucaꞋa tsa azanariya, tsu na ci an mini mu usuni n tsu na ci yotsoi an mini ma̱ ma̱ɗiya̱ m mini ma garula n arikinla a singai, ulinga u ka̱jili ku usuɓi. ");
INSERT INTO asg_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ma yaꞋan n eleje a avangatsu e re ugasatangbani wu ngon n re adama a kushiya. ");
INSERT INTO asg_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ogoni a na a yaꞋankai kaɗambura ku ucaꞋi ko tsuzogu ka, ko yotso kujilya̱ ku motogu ku efodu ka, ka̱ta̱ ka yaꞋan umatyangbani ɗe n efodu va, tsa a azanariya, m mini mu usuni, n tsu mini ma garula, koɓolo n arikinla a singai. ");
INSERT INTO asg_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Vu ɗika atali o onis e re, ka̱ta̱ vu ka̱ra̱ ɗe ula a̱ muku mi Isaraila, ");
INSERT INTO asg_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","vu ka̱ra̱ ula a̱ ta̱li e le ɗe a katali ke te m motonosonoi tsu na a matsai le, ula a̱ ta̱li a na a buwai ka̱ra̱ le feu a katali ka na ka buwai. ");
INSERT INTO asg_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Vu ka̱ra̱ ɗe ula a̱ muku mi Isaraila a atali e re a, tsu na kesheꞋwi ka tsu ɗana a̱ ka̱ta̱mba̱ri. Vi ta̱ a kuzuwa katali dem ka na a yaꞋin n tsuzogu tsa azanariya a̱ kuka̱ra̱Ꞌa̱. ");
INSERT INTO asg_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ka̱ta̱ a shiya a ɗa a avangatsu a efodu a adama a na o okpo atali a kuciɓasa a̱ muku mi Isaraila. Haruna wi ta̱ a kuɗika ula a nampa a avangatsu a̱ ni ka̱ta̱ mpa Vuzavaguɗu n ciɓa ayin a na baci u banai e kelime ka̱ va̱. ");
INSERT INTO asg_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Vi ta̱ a kuzuwa katali dem ka na a yaꞋin n tsuzogu tsa azanariya a̱ kuka̱ra̱Ꞌa̱ ");
INSERT INTO asg_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","n ikani ya azanariya i re, uɓishi an kawin ka̱ta̱ vu ɓolongu le punu m muntsa mu utsutsu ka. ");
INSERT INTO asg_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","<<Vi yaꞋan mabambata ma afada, ulinga u keyevi n tso ogoni e efodu, ka̱ta̱ vu yaꞋan maꞋa n azanariya, tsu mini mu usuni, m mini ma̱ ma̱ɗiya̱ n arikinla a na a yaꞋin n tsugbere. ");
INSERT INTO asg_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kakashi ka na a ku caꞋa va, akambu a i ta̱ a kuyaꞋan derere n aza na a buwai, wanshi udyawi kuci ka̱ta̱ vu ka̱ta̱la̱ kaꞋa kure. ");
INSERT INTO asg_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ka̱ta̱ vu dara ɗe atali a singai a singai akariki a̱ na̱shi. A kakariki ka iyain vu dara ɗe, karneliyan, n tofa, n zumurudu, ");
INSERT INTO asg_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","a kakariki ke ire a dara ɗe kirisola, n safaya n daimon, ");
INSERT INTO asg_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","a kakariki ka tatsu ɗa a dara ɗe Jesinta, n agata, n amati, ");
INSERT INTO asg_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","a kakariki ka na̱shi ɗa a dara ɗe, berila, n onika, n yasfa. Katali dem ka̱ta̱ a zuwa kaꞋa punu a̱ ka̱ga̱Ꞌin ku utsutsu u kenu u na a yaꞋin a azanariya a. ");
INSERT INTO asg_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","I ta̱ a kuzama atali kupa n e re, ka̱ta̱ a ka̱ra̱ ɗe ula a umaci a̱ muku mi Isaraila a katali ke te ke te dem. Ula a nampa i ta̱ o kokpo urotu. ");
INSERT INTO asg_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ka̱ta̱ vi yaꞋanka mabambata ma ikani yu ucaꞋi i tsu tsuzogu tsa awin, a na a yaꞋin n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Vi yaꞋan nkawani n re ma azanariya n na o kukoɓo ɗe a̱ iga̱Ꞌin e re a mabambata ma. ");
INSERT INTO asg_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ka̱ta̱ vu shiya ɗe awin e re a azanariya a ɗe a nkawani n re m mabambata ma. ");
INSERT INTO asg_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ugasatangbani u re wu uteku wi ikani u re wa, vi shiya u ɗa ɗe a̱ ubuta̱ u re wa, ka̱ta̱ vu koɓo le n tsu kelime a̱ ubuta̱ u te n efodu va. ");
INSERT INTO asg_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ka̱ta̱ vi yaꞋan nkawani n re ma azanariya, ka̱ta̱ vu koɓo ɗe n ɗa ɗe uteku u re u mabanbata ma, n asuvu a ukoci ɗevu n efodu va. ");
INSERT INTO asg_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Vi yaꞋan nkawani n re ma azanariya ka̱ta̱ vu koɓo le n kelime ka efodu va, a uɓon u ɗaka wa avangatsu, derere a ubuta̱ u na nroki n kaɗambura ko tsuzogu ka efodu ka ki. ");
INSERT INTO asg_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ka̱ta̱ i shiya ɗe mabanbata nu nkawani n ni ɗe a nkawani n efodu koɓolo n awin a̱ mini mu usuni, adama a na wo okpo ulinga u keyevi ka kucaꞋa ka awin ke efodu, adama a na ka̱ta̱ mabambata ma ma̱ ta̱wa̱ ma̱ ba̱ɗa̱ a efodu va ba. ");
INSERT INTO asg_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ayin a na baci Haruna wi a kuꞋuwa a̱ ubuta̱ u na u laꞋi n ciɗa, ka̱ta̱ Vuzavaguɗu u ciɓa n ula a̱ muku mi Isaraila a̱ ka̱ɗu ka̱ ni. Adama a na wo okpo ili i kuciɓasa ko wanai. ");
INSERT INTO asg_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ka̱ta̱ vu zuwa punu feu Yurim n Tumi punu a mabanbata, adama a na o yongo punu a̱ ka̱ɗu ka Haruna a ayin a na baci u banai e kelime ka Vuzavaguɗu. Nannai ɗa Haruna u kuyongo n ili i na i kusheshe ukuna u na Vuzavaguɗu u cigai a̱ kuka̱ra̱ka̱ punu a̱ ka̱ɗu ka̱ ni, a ayin a na baci de dem wi e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","<<Ka̱ta̱ vi yaꞋan motogu mu caꞋi mu ugaɗi ma efodu ma, m mini mu usuni ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ka̱ta̱ a yaꞋan kuɗeku ku motogu ka, ucaꞋi u ni u yaꞋan ka̱gba̱ta̱ra̱, ta lo wa̱ ta̱wa̱ wa kara. ");
INSERT INTO asg_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ɗe a̱ iga̱Ꞌin o motogu ma, n tsu ɗaka, vi cindala ɗe tsuzogu tsu umaci u maɗanga ma na a tsu ɗeke ruman, n tsu mini mu usuni, n tsu ma̱ɗiya̱, n tsu mini ma garula, n tsugbere tsu ucaꞋi n tsuzogu tsu singai. ");
INSERT INTO asg_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","E gere ɗe alingi n umaci u ruman o motonosonoi a̱ kuka̱ra̱Ꞌa̱ ugupi u motogu wa. ");
INSERT INTO asg_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ka̱ta̱ Haruna u uka motogu ma nampa ma ayin a na baci wi a kuyaꞋan ulinga e kelime ka Vuzavaguɗu. Ka̱ta̱ a pana ma̱shi ma alingi ma a ayin a na baci wi a kuꞋuwa, n ayin a na baci wi a̱ kuta̱ a̱ ubuta̱ u ciɗa e kelime ka Vuzavaguɗu ta lo wa̱ kuwa̱. ");
INSERT INTO asg_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","<<Vi yaꞋan maganda ma kaci n azanariya koci, ka̱ta̱ vu ka̱ra̱ ɗe iɗani i nampa, uteku tsu uzuwi u kukiye u ka̱ta̱mba̱ri tsu nampa, <ILI I CIƊA U VUZAVAGUƊU.> ");
INSERT INTO asg_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ka̱ta̱mba̱ri ka azanariya ka, a shiya kaꞋa n kawin ka na ki tsu mini mu usuni a gaɗi vo oroli a. ");
INSERT INTO asg_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ta ta na nannai Haruna u kapa baci oroli a, ta ɗe e kene iɗani ya a̱ kuca̱n ku ni. Ta kpamu nannai u kuɗika a̱miki a̱ unushi u uma a Isaraila ayin a na i e kuneke kuneꞋe ku le ku ciɗa. Ta ɗe iɗani i kuyongoso ɗe a̱ kuca̱n ku Haruna adama a na Vuzavaguɗu u ciya̱ wi isa kuneꞋe ku le. ");
INSERT INTO asg_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","<<Vi yaꞋan motogu me kenu ma, n arikinla a singai, ka̱ta̱ vi yaꞋan kpamu oroli n arikinla a singai feu, ka̱ta̱ vi yaꞋan kaɗambura ko tsuzogu tsu ucaꞋi we ekiye. ");
INSERT INTO asg_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","<<Yi ta̱ a kuyaꞋanka muku n Haruna ntogu n kenkeꞋen, n ashiyatsu, nu nkunkuꞋun, nu ntogu n na n kuneke le tsugbayin n tsuloboi. ");
INSERT INTO asg_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Vu uka Haruna m muku n ni ucanuku u nampa wa, ka̱ta̱ vu sukumaka le maniꞋin vu zuwa le o okpo ciɗa ka̱ta̱ vu erengu le ciya̱ a yaꞋanka mu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Vi yaꞋanka le acaka a gbati-gbati n arikinla a na a kuyawa a̱ka̱nga̱tsu a̱ ciya̱ a yaꞋanka ciyampa. ");
INSERT INTO asg_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruna m muku n ni a uka ucanuku wa a ayin a na baci i a kuꞋuwa a̱ Ma̱va̱li mo Oɓolo ko a ayin a na i a kuyawa ɗevu n katalikalyuka adama a na a yaꞋan ulinga a̱ ubuta̱ u Ciɗa, ta lo o ronoko ka̱ci ke le unushi u na u kutuka̱ le n ukpa̱. Na lo va wi ta̱ o kokpo wila̱ u ko wanai u Haruna nu ntsukaya n na n kuta̱wa̱ ka̱ca̱pa̱ ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","<<Ili i na va kuyaꞋanka Haruna m muku n ni a̱ ubuta̱ u kavasa ke kerengu i ɗaɗa na, adama a na a yaꞋanka mu ulinga u tsuganu. Vu ɗika maku mo kobomburon ni ngiri e re n na mi babu uꞋiwin u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ka̱ta̱ vi yaꞋan ulinga n kiya ku alkama ku na ku geꞋwei neruru babu yisiti, ka̱ta̱ a yaꞋan boroji, n akala a na a̱ zuɓuki n kiya ku maniꞋin ma zaitu, n emeshe a na i ujaꞋangi m maniꞋin. ");
INSERT INTO asg_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ka̱ta̱ vu zuwa punu ili ya a mabana vu banka, koɓolo n kobomburon n ngiri ma a̱ ubuta̱ u ciɗa wa. ");
INSERT INTO asg_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ka̱ta̱ vu tuka̱ Haruna m muku n ni a utsutsu u Ma̱va̱li wa ka̱ta̱ vu sumba̱ le m mini. ");
INSERT INTO asg_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ka̱ta̱ vu uka Haruna ntogu ma. Vi gita̱ m motogu ma asuvu mu ugaɗi, ka̱ta̱ vu tono m motogu ma gaɗi ma gbati, ka̱ta̱ vu tono n efodu m mabambata ka̱ta̱ vu shiya n ashiyatsu a na a caꞋi n igani ya. ");
INSERT INTO asg_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ka̱ta̱ a kapaka yi oroli a kaci, ka̱ta̱ a shiyaka yi ɗe a ashiyatsu a azanariya m maganda a kaci. ");
INSERT INTO asg_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ka̱ta̱ vu ɗika maniꞋin me kerengu vu sukuya̱ka̱ yi a kaci. ");
INSERT INTO asg_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Vu tuka̱ m muku ma ka̱ta̱ vu uka le ntogu ma asuvu ma, ");
INSERT INTO asg_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ka̱ta̱ vu shiyaka yaba dem kashiyatsu ka kaɗambura, vu kapaka le nkunkuꞋun ma. Ta va kuzagba Haruna m muku n ni nannai. Ulinga u tsuganu wi ta̱ o kokpo u le a̱ wila̱ kowanai. Nannai ɗa va kuyaꞋanka Haruna m muku n ni kavasa ke kerengu. ");
INSERT INTO asg_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","<<Vu tuka̱ m maku mo kobomburon ka a̱ ubuta̱ u Ma̱va̱li mo Oɓolo, Haruna m muku n ni i ta̱ a kukiyangu ɗe ekiye a gaɗi vu maku mo kobomburon ka. ");
INSERT INTO asg_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ka̱ta̱ vu kiɗa kobomburon ka e kelime ka Vuzavaguɗu a̱ utsutsu u Ma̱va̱li mo Oɓolo ma, ");
INSERT INTO asg_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Vu dyaɓa mpasa n kobomburon ma a̱ ka̱jivu ka̱ta̱ vu sura ɗe n ɗa a avana a katalikalyuka ka, n na tamkpamu m buwai a̱ tsungu punu a ɗaka vu kumiꞋi ku katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ka̱ta̱ vu takpa ushuma u na u palai ciꞋin tsu ka̱tsuma̱ tsa, n ubuta̱ u singai wa asuvu, n ukambu wa asuvu, n muku n ka̱tsuma̱ n re ma koɓolo n ushuma u le, i songu a gaɗi vu katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ama inyama i na i buwai i kobomburon ya koɓolo n ukpan, n a̱wiya̱n dem, vu banka i ɗa pulai vu likuci ka̱ta̱ vu songu ɗe i ɗa, ɗaɗa alyuka a̱ unushi. ");
INSERT INTO asg_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","<<Vu ɗika ka̱giri ke te, ka̱ta̱ Haruna m muku n ni a kiyangu ɗe ekiye e le. ");
INSERT INTO asg_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Vu kiɗa ka̱giri ka, ka̱ta̱ vu keɗengu mpasa ma vu vishangu a akambu dem a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ka̱ta̱ vu kiɗa ka̱giri ka akiɗi-akiɗi, vu za̱Ꞌa̱ ili i ka̱tsuma̱ koɓolo n ekpete, ka̱ta̱ vu zuwa kaci ka ubuta̱ u te koɓolo n akiɗi a na a buwai. ");
INSERT INTO asg_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Vu songu ka̱giri ka ra̱ka̱ a katalikalyuka, alyuka o kusongu a ɗa a Vuzavaguɗu, a̱ ma̱gula̱ni, alyuka a na o songi n akina adama a Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","<<Ɗika ka̱giri ka na ka buwai va, Haruna m muku n ni a kiyangu ɗe ekiye e le a kaci ka ka̱giri ka. ");
INSERT INTO asg_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ka̱ta̱ vu kiɗa ka̱giri ka vu keɗengu mpasa n ni ma, vu kenuku mpasa ma vu tsungu iga̱Ꞌin melegu ma kutsuvu ku singai ku Haruna. A dyaɓaka muku n ni mpasa ma kpamu a̱ a̱jivu a gbagbaꞋin a usingai e ekiye e le n a̱jivu a gbagbaꞋin e ene a usingai e le. Ka̱ta̱ ayin a nanlo vu vishangu n na m buwai a akambu dem a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Vu kenuku ɗe mpasa ma a gaɗi vu katalikalyuka ka ka̱ta̱ vu na̱na̱ n ɗa m maniꞋin me kerengu. Ka̱ta̱ vu vishanku Haruna nu ntogu n ni, ka̱ta̱ vu vishanku muku n ni nu ntogu n le, ta o kokpo ciɗa nannai nu ntogu n le. ");
INSERT INTO asg_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","<<Vu takpa ushuma u ka̱giri wa, n ushuma u winja, n ushuma u na u palai ili i ka̱suma̱, n u na u palai asuvu, m muku n ka̱tsuma̱ n re dem n ushuma u le, koɓolo m ma̱kuta̱. (Na va ɗaɗa ka̱giri ka adama a kavasa ke kerengu.) ");
INSERT INTO asg_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ka̱ta̱ vu ɗika ka̱kutsu ko boroji ke te n emeshe a na a putalai m maniꞋin, n kakala ke te punu a mabana ma na mi m boroji vu na vi n yisiti ba, vu na a zuwai e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vu zuwa ili i nampa ya dem e kukiye ku Haruna m muku n ni, ele tamkpamu a yaꞋan alyuka a̱ ɗengusa̱ gaɗi tsa alyuka a̱ kuɗa̱ngusa̱ e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ka̱ta̱ vi isa i ɗa e ekiye le kpamu, ka̱ta̱ vu songu le a katalikalyuka ɗe gaɗi va alyuka o kusongu ci ili i ma̱gula̱ni a̱ ubuta̱ u Vuzavaguɗu. Na va alyuka akina ɗa u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","<<Vi ɗika ma̱ka̱nga̱ ma malala ma na a kiɗai adama a kavasa ka kerengu ku Haruna ka, ka̱ta̱ vu ɗengusa̱ gaɗi adama a na wo okpo alyuka e kelime ka Vuzavaguɗu. Ma̱ka̱nga̱ ma nampa ma mi ta̱ o kokpo ma̱ nu. ");
INSERT INTO asg_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ka̱ta̱ vu zuwa i ɗa adama a kavasa ke kerengu ka Haruna m muku n ni. Ɗaɗa ma̱ka̱nga̱ ma malala ma m ma̱kuta̱ ma na a yaꞋankai alyuka a̱ ɗengusa̱i u Vuzavaguɗu wa. ");
INSERT INTO asg_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Na va wi ta̱ o kokpo upecu u Haruna m muku ni u ayin dem a na baci aza Isaraila a̱ ta̱wa̱i kuyaꞋan alyuka a̱ ma̱ta̱na̱ e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","<<Ntogu n ciɗa n Haruna mi ta̱ o kokpo ili yi uka̱ni, a̱ kugita̱ a̱ muku n ni ali a kubana ntsukaya n ni. Ntogu n nanlo n ɗa a kuyaꞋanka ulinga a kubana u vuza na baci dem a zagbai. ");
INSERT INTO asg_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Maku ma na baci de dem ma ɗikai uka̱ni a ulinga u tsuganu i ta̱ a kuꞋuka ntogu n nampa ali ayin e cindere, a ayin a na baci de i a kuyaꞋanka mu ulinga a̱ ubuta̱ u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","<<Ka̱ta̱ vu ɗika ka̱giri ka na a kuyaꞋanka kavasa ke kerengu, ka̱ta̱ vu suꞋwan inyama ya a̱ ubuta̱ u ciɗa wa. ");
INSERT INTO asg_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruna ɗa koci m muku n ni a kutakuma i nyama ya, koɓolo m boroji vu na vi a mabana a̱ utsutsu u Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ele ɗa koci a kutakuma inyama ya m boroji vu na a̱ tuka̱i adama a kutakpa ku unushi, n kavasa kerengu ku le. Babu vuza pulai vu na u kutakuma ili i nampa adama a na ili i ciɗa i ɗa. ");
INSERT INTO asg_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Inyama ya ko boroji va vu buwa baci ali a kubana usana, ka̱ta̱ o songu i ɗa. O kudoku a takuma i ɗa ba, adama a na ili i ciɗa i ɗa. ");
INSERT INTO asg_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","<<Tsu nampa tsu ɗa va kuyaꞋanka Haruna m muku n ni kavasa ke kerengu, derere tsu na n danai nu. Ka̱ɗiva̱ ke kerengu ka nampa ka ki ta̱ a kuyaꞋan ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","A̱ ka̱tsuma̱ ka ayin e cindere a nampa a kanna dem yi ta̱ a kuyaꞋan alyuka a kutakpa unushi n kobomburon. Vu zuwa katalikalyuka ka kokpo ciɗa nannai, vu putala kaꞋa m maniꞋin ma zaitu. ");
INSERT INTO asg_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ayin e cindere avu a kuyaꞋan nannai, avu a kuyaꞋansa alyuka a kutakpa unushi wa adama a na katalikalyuka ka kokpo ciɗa. Katalikalyuka ka kokpo ili i na i laꞋi n ciɗa, ili i na baci de dem i saꞋwai kaꞋa i ɗa yi ta̱ o kokpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","<<Na va ɗaɗa ili i na va kulyuka katalikalyuka ayin tutu. A kanna dem vu lyuka muku mu ngiri n re aza a na i n ka̱ya̱ kete-kete. ");
INSERT INTO asg_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Vi lyuka me te n usana, me te kpamu n kulivi. ");
INSERT INTO asg_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","N ka̱giri ka iyain dem, vu neke kakpanu ke te ka kiya ku alkama ku na ku geꞋwei neruru a̱ zuɓuki m maniꞋin ma zaitu kedele ke te. Ka̱ta̱ kpamu vu tsungu kedele ke te ka̱ ma̱kya̱n adama a alyuka a ili i kusoꞋo. ");
INSERT INTO asg_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ma̱giri ma na ma buwai ma na va ku lyuka n kulivi ka, vi ta̱ a kulyuka maꞋa n ishina, koɓolo n alyuka a ili i kusoꞋo, uteku tsu na a yaꞋin n usana. I ta̱ o kokpo ili i ma̱gula̱ni n uyoꞋo a kubana a̱ ubuta̱ u Vuzavaguɗu. Na va ɗaɗa kuneꞋe ka alyuka ka akina ku Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Alyuka o kusongu a nampa i ta̱ a kulyaꞋa kelime ali nu ntsukaya n na i kumatsa. I yaꞋan a ɗa a̱ ubuta̱ u Vuzavaguɗu a̱ utsutsu u Ma̱va̱li mo Oɓolo ma, ta lo n kugasa n a̱ɗa̱ ka̱ta̱ n yaꞋan kadanshi kpamu n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ta ɗe n kugasa n uma a Isaraila, kutashi ku tsugbayin ku va̱ ki ta̱ a kakana a̱ ubuta̱ wa ka̱ta̱ u ɗa wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mi ta̱ a kuzuwa Ma̱va̱li mo Oɓolo n katalikalyuka ka ko okpo ubuta̱ u ciɗa. Ka̱ta̱ n zuwa Haruna m muku n ni okpo aza ciɗa a na a kuyaꞋanka mu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mi ta̱ a̱ kuda̱sa̱ngu koɓolo n uma a Isaraila adama a na mo okpo Ka̱shile ke le. ");
INSERT INTO asg_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","I ta̱ e kuyeve a na mpa ɗa Vuzavaguɗu Ka̱shile ke le. Mpa ɗa kpamu mu uta̱ka̱i le a iɗika i Masar adama a na n ciya̱ n da̱sa̱ngu punu we le. Mpa ɗa Vuzavaguɗu Ka̱shile ke le. ");
INSERT INTO asg_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","<<Vi yaꞋan katalikalyuka ka na o kusonku ili i ma̱gula̱ni m maɗanga me megele. ");
INSERT INTO asg_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ugaɗi u ni u yawa udashi u te n kagimi, wanshi u ni kpamu udashi u te n kagimi, ugaɗi u ni n wanshi u ni u yaꞋan derere. Uɗa̱ngi u ni u yawa ubapi u tatsu. Ngon n na̱shi n katalikalyuka ka ka̱ta̱ vi yaꞋan ɗe avana umatyangbani punu. ");
INSERT INTO asg_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ka̱ta̱ vu paɗara gaɗi n akambu dem n avana n azanariya koci, ka̱ta̱ vu lapula ka̱ga̱Ꞌin ku una̱ u ni n azanariya a̱ ku ka̱ra̱Ꞌa̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ka̱ta̱ vi yaꞋan nkawani n re ma azanariya adama a katalikalyuka ɗaka va̱ ka̱ga̱Ꞌin, akambu e re dem a na a̱ ka̱na̱i nshikpu n na a ci ɗikaka katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","I yaꞋan ashamkpatsu a nu nɗanga m megele ka̱ta̱ i paɗara a ɗa n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ka̱ta̱ vu zuwa katalikalyuka ko kusonku ili i ma̱gula̱ni e kelime ka kakashi ka na ka kpadai akpati vu wila̱ va, ɗevu n ka̱kuyenkpa̱tsu ka kutsupa unushi ubuta̱ u na n kugasa n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Usana lakam Haruna u uwa baci adama a na u lapulasaka nkuni ma, wi ta̱ o kusongu ili ma̱gula̱ni a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","N kulivi dem ayin a na wi a kutasuku nkuni ma ka̱ta̱ u songu ili i ma̱gula̱ni ya kpamu. Na va wi ta̱ o kokpo ili ma̱gula̱ni i na yo kuyongo a̱ kukula̱ ayin dem a kubana a̱ ubuta̱ u Vuzavaguɗu ali a kubana n tsukaya n na n kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ka̱ta̱ vi yaꞋan kuneꞋe ki ili i ma̱gula̱ni i gbani-gbani ba, ko alyuka o kusongu ko alyuka a ili i kashina ko ta na alyuka a ili i kusoꞋo ba. ");
INSERT INTO asg_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ku te a̱ ka̱ya̱ dem Haruna u bonoko katalikalyuka ciɗa nu mpasa n na u kutsungu punu a avana a̱ na̱shi a. Vi ta̱ a kuyaꞋan ili i nampa ya nu mpasa mo obomburom n na a yaꞋankai alyuka a kucinukpaka unushi, i yaꞋansa ili i nampa ya ali a kubana ntsukaya n ɗa̱, na va ɗaɗa katalikalyuka ka ciɗa a̱ ubuta̱ u Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ɗaɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Ayin a na baci vi e kukece uma a Isaraila, vuza na baci e kecei dem wi ta̱ a kutsupa katsupu ku unushi a̱ ubuta̱ u Vuzavaguɗu adama a wuma u ni. Nannai babu ma̱dukpa̱ ma na ma̱ kuta̱wa̱ we le a ayin a na baci a̱ ciya̱i ukeci. ");
INSERT INTO asg_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Yaba dem vuna e kecei e mekecu wi ta̱ a̱ kutsupa ili nampa, kagimi ka kagisamkpatsu ka azurufa, ka̱ta̱ a̱ kunzuku m mokokoꞋo ma na mi a̱ ubuta̱ u ciɗa ma na a̱miki a̱ ni a yawai kamanga. Yaba dem wi ta̱ a̱ kutuka̱ n kuneꞋe ku nampa a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Vuza na baci de e kecei e meketsu, ɗa u yawai a̱ya̱ kamanga a kubana gaɗi, wi ta̱ a kuyaꞋanka Vuzavaguɗu kuneꞋe. ");
INSERT INTO asg_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","I baci a kuyaꞋan kuneꞋe ku nampa, vuza vu uciyi u tsupa u pasatangu tsu na a gisanki ba, vuza vu unambi feu u tsupa u gusa̱ tsu na a gisanki va ba. ");
INSERT INTO asg_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Vi isa ikebe i katsupu ka adama a̱ unushi u nanlo a̱ ubuta̱ wa aza a Isaraila, adama a na i ɗa va kuyaꞋanka ulinga u kulapula Ma̱va̱li mo Oɓolo. Wo okpo ili na Vuzavaguɗu u kuciɓasa n aza a Isaraila, adama na u bonoko wuma u ɗa̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","<<Vi yaꞋan kasasu ki iyum i shili n kashamkpatsu ka̱ ni feu n iyum i shili adama a̱ kuza̱Ꞌa̱. Vu zuwa kaꞋa e mere ma̱ Ma̱va̱li mo Oɓolo n katalikalyuka, ka̱ta̱ vu tsungu punu mini. ");
INSERT INTO asg_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna m muku n ni ta lo a kusaꞋa ekiye n ene e le. ");
INSERT INTO asg_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kafu a uwa a̱ Ma̱va̱li mo Oɓolo sai a saꞋasa biꞋi ka̱ci ke le m mini ta lo a̱ kuwa̱. Ko kpamu kafu a yawa ɗevu n katalikalyuka ka adama a na a yaꞋan alyuka o kusongu u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ka̱ta̱ a saꞋa ekiye n ene e le, ta lo a̱ kukuwa̱. Na va ɗaɗa wila̱ u ayin dem a̱ kugita̱ u Haruna ali a̱ kuta̱wa̱ ntsukaya n na n kuta̱wa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","<<La̱nsa̱ ili i wali i nampa, kilo vu ta̱li vi mini ma̱ mur, kilo vu tatsu vu sinamon vu ma̱gula̱ni, n kilo vu tatsu vu mita̱ ma̱ ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","n kilo vu ta̱li vu kasiya vu ma̱gula̱ni, n ka̱kunzukpa̱tsu ka azurufa ka na i a kuyaꞋanka ulinga a̱ ubuta̱ u ma̱va̱li, koɓolo n edele a̱ na̱shi a maniꞋin ma zaitu. ");
INSERT INTO asg_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Vi yaꞋan ili i nampa ya yo okpo maniꞋin me kerengu ciɗa, usatari n ili i ma̱gula̱ni. ");
INSERT INTO asg_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","M maniꞋin ma nampa ma ɗaɗa va̱ kutsunku Ma̱va̱li ma, n akpati vu wila̱ va. ");
INSERT INTO asg_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Kirukpa ka n ucanuku wu ulinga u ni, n kashamkpatsu ka̱ ma̱kuni ka n ikoɓomgushi i ni, n katalikalyuka ko kusongu maniꞋin ma̱ ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","katalikalyuka ko kusongu alyuka n ucanuku wu ulinga u ni ra̱ka̱, n kasasu n kashamkpatsu ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ka̱ta̱ vi erengu le adama a na o okpo aza a na a laꞋi n ciɗa, adama a na ili i na baci i saꞋwa le dem yi ta̱ o kokpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","<<Vu putalaka Haruna m muku n ni maniꞋin me kerengu, ka̱ta̱ vi erengu le o okpo aza a an a kuyaꞋanka mu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Vu dana muku mi Isaraila ili i nampa ya, <Na va ɗaɗa maniꞋin me kerengu ma ciɗa, a̱ kugita̱ anana ali a kubana ntsukaya n ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ka̱ta̱ a̱ tsunku ikyamba i vuma gbani ba, ka̱ta̱ kpamu vuza u yaꞋan maniꞋin mo yoku tsu nanlo ba. Adama na maniꞋin ma ciɗa maꞋa, ka̱ta̱ yi indana i ɗa ci ili i ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Vuza na baci u yaꞋin maniꞋin tsu nanlo ko a̱ tsunki vuza na wi ganu ba, i ta̱ a kutakpa yi a̱ ubuta̱ u uma.> >> ");
INSERT INTO asg_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ɗaɗa Vuzavaguɗu u danai Musa, <<Ɗika ili i wali i ma̱gula̱ni, cirupa̱, n onika, n galbanum, ka̱ta̱ vu satara n ili i wali i ma̱gula̱ni ya koɓolo n ili ma̱gula̱ni i aluban, vu kunzuku maꞋa derere, ");
INSERT INTO asg_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","n ili i nanlo i ɗa va kuyaꞋanka ili ma̱gula̱ni ya, tsu na vuza na u ci yaꞋan ili i ma̱gula̱ni u ci yaꞋan, ka̱ta̱ u bula̱ngu punu mkpaɗi. Ka̱ta̱ yo okpo ili ma̱gula̱ni i ciɗa i na a pishai. ");
INSERT INTO asg_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Vu kenuku punu kenu ka̱ta̱ vu soyo luɓa̱-luɓa̱, vu vishanku akpati vu uzuwakpani vu na vi punu a̱ Ma̱va̱li mo Oɓolo ma na mi a̱ ubuta̱ u na n kugasa n avu. Ili i ma̱gula̱ni i nampa ya yi ta̱ o kokpo ili na i laꞋi n ciɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ka̱ta̱ i yaꞋanka ka̱ci ka̱ ɗa̱ ili i ma̱gula̱ni tsu nanlo ba, ili i ma̱gula̱ni i nampa ili i ciɗa i ɗa a kubana a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Vuza na baci u yaꞋankai maꞋa ulinga tsu maniꞋin ma̱ kusukuya̱, i ta̱ a kutakpa yi a̱ ka̱tsuma̱ ka uma.>> ");
INSERT INTO asg_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ɗaɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","<<N zagba ta̱ Bezale maku ma Uri vashi vu Horu a kumaci ku Yahuda. ");
INSERT INTO asg_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","N shatangu yi ta̱ n ayinviki a̱ va̱, n ugboji n kuyeve ku ulinga, n kuyeve ku ulinga we ekiye dem, ");
INSERT INTO asg_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","adama a na u yaꞋan ili n igani kakau, u yaꞋan kpamu ili ya azanariya, n azurufa, n iyum i shili, ");
INSERT INTO asg_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","u sheꞋwe atali a singai a singai a na va kuzuwa, nu nɗanga, wo okpo kpamu ulinga u vuza na u yevei ulinga we ekiye mayin. ");
INSERT INTO asg_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","N zagba ta̱ Oholiya maku ma Ahisamaka kumaci ku Dan adama a na wo okpo ka̱ɓa̱nki ka̱ ni. N neke wu ta̱ kpamu ugboji a̱ ubuta̱ wa aza e kuyeve ku ulinga we ekiye a yaꞋan ili i na n danai nu va. ");
INSERT INTO asg_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ma̱va̱li mo Oɓolo, n akpati vu wila̱ n ka̱kuyenkpa̱tsu ka kutsupa unushi, ka na a kuɗikaka unushi n ucanuku u na wi punu a̱ Ma̱va̱li mo Oɓolo, ");
INSERT INTO asg_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","kirukpa ka n ucanuku u ni, n kashamkpatsu ka azanariya ka na ka̱ ka̱na̱i ma̱kuni n ili yu ulinga i le, n katalikalyuka ko kusongu ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","katalikalyuka ko kusonku alyuka o kusongu, ali n ucanuku wu ulinga u ni n kasasu koɓolo n kashamkpatsu ka̱ ni, ");
INSERT INTO asg_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","nu ntogu mu ucaꞋi n na a yaꞋankai igani, nu ntogu n ciɗa adama Haruna Ganu, nu ntogu m muku n ni adama a ulinga u tsuganu, ");
INSERT INTO asg_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","m maniꞋin me kerengu, koɓolo n ili i ma̱gula̱ni adama a̱ ubuta̱ u ciɗa. Ka̱ta̱ i yaꞋan i ɗa derere tsu na n danai nu.>> ");
INSERT INTO asg_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","<<Dana aza Isaraila, ka̱ta̱ yi indana kanna ka Ashibi ka nampa, kanna ka nampa ka ɗaɗa urotu wu uzuwakpani mpa n a̱ɗa̱ ali nu ntsukaya n ɗa̱ yi ta̱ e kuyeve a na mpa ɗa Vuzavaguɗu vu na m bonokoi ɗa̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","<< <Yi indana kanna ka Ashibi ka mayin adama a na kanna ka nanlo ka ki ta̱ ciɗa wa̱ ɗa̱, vuza na baci u goyoi kanna ka i ta̱ a kuna yi. Vuza na baci kpamu u yaꞋin ulinga a kanna ka nanlo ka i ta̱ e kupece yi n uma a na a buwai. ");
INSERT INTO asg_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ayin a̱ ta̱li a ɗaɗa va kuyaꞋan ulinga, ama kanna ke cindere ka ɗaɗa ka kuvuka, kanna ka ciɗa kaꞋa a̱ ubuta̱ u Vuzavaguɗu. Vuza na baci u yaꞋin ulinga a kanna ka nanlo i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Adama nannai uma Isaraila ka̱ta̱ yi indana kanna ka Ashibi ka nampa ka, n ka̱ɗiva̱ ali a kubana ntsukaya n ɗa̱, na va ɗaɗa uzuwakpani u ayin dem. ");
INSERT INTO asg_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Na va urotu ɗa u ko wannai a̱ kuta̱wa̱ wa̱ va̱ n uma a Isaraila adama a na a̱ ka̱tsuma̱ ka ayin a̱ta̱li ka ɗaɗa Vuzavaguɗu u yaꞋin gaɗi n iɗika, ama a kanna ke cindere ɗa wu uvukai.> >> ");
INSERT INTO asg_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ana Vuzavaguɗu u kotsoi kuyaꞋan kadanshi m Musa a Kusan ku Sinai, ɗa u nekei ni nshemberu ma atali n re n wila̱ uɗani n kukiye ku Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ana Musa va u kpa̱ɗa̱i kucipa̱ a kusan ka gogoꞋo, ɗa uma a Isaraila ra̱ka̱ a banai a gasai u Haruna, ɗa a danai Haruna va, <<Pana, yaꞋanka tsu a̱ma̱li a na o kutono n a̱ tsu. Vuma vu nampa Musa, vuma na wu uta̱ka̱i tsu Masar, ci yeve ili i na i yaꞋin ni ba.>> ");
INSERT INTO asg_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ɗaɗa Haruna u danai le, <<Tuka̱i n iliyatsuvu ya azanariya ya̱ a̱ma̱ci a̱ ɗa̱, n olobo a̱ ɗa̱, n nkere n ɗa̱ i na i a kuꞋukasa.>> ");
INSERT INTO asg_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ɗa uma a̱ la̱nsa̱i iliyatsuvu ra̱ka̱ ɗa a̱ tuka̱i ni. ");
INSERT INTO asg_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","U ɗikai ili i na e nekei ni va, ɗa u luwa̱i i ɗa, ɗa u maꞋi ka̱ma̱li an medendem. Ɗa uma ra̱ka̱ a dananai, <<A̱ɗa̱ aza a Isaraila ka̱ma̱li ka̱ ɗa̱ kaꞋa na, ka na ku uta̱ka̱i ɗa̱ a Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ana Haruna we enei nannai, ɗa u maꞋi katalikalyuka e kelime ka̱ ka̱ma̱li ke medendem ka, ɗa u danai, <<A kubana mkpaꞋa ka̱ɗiva̱ ki ta̱ lo adama a Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kanna ke ire, uma a̱ ɗa̱nga̱i n usana ka̱li-ka̱li, ɗa a lyukai alyuka o kusongu, ɗa kpamu o doku ɗa a yaꞋin alyuka a̱ ma̱ta̱na̱. Ana o kotsoi nannai ɗa a̱ da̱sa̱ngi, a̱ ka̱na̱i kulyaꞋa n o soꞋi, ɗa a̱ ka̱na̱i kuyaꞋan tsugbani. ");
INSERT INTO asg_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ɗa Vuzavaguɗu u danai Musa, <<Cipa̱ gogoꞋo, adama a na uma a̱ nu a na vu uta̱ka̱i a Masar va, a̱ na̱mgba̱ ta̱ n tsugbani. ");
INSERT INTO asg_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","A̱ ka̱sukpa̱ ta̱ kutono mu, ɗa kpamu i ɗe a yaꞋankai ka̱ci ke le ka̱ma̱li an medendem. A̱ kuɗa̱nku yi ta̱, ali ɗa a yaꞋankai ni alyuka. Ɗa uma a i kpamu a kudana ka̱ma̱li ke le kaꞋa na, ka na ku uta̱ka̱i aza a Isaraila a Masar.>> ");
INSERT INTO asg_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ɗa Vuzavaguɗu u danai Musa, <<Mpa me ene ta̱ uma a nampa,>> uma ugbamukaci ɗa. ");
INSERT INTO asg_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Gogo na ka̱sukpa̱ wupa u va̱ u cipa̱ we le ka̱ta̱ mu una le, ka̱ta̱ kpamu n zuwa wu vo okpo kumaci ku gbayin. ");
INSERT INTO asg_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ama ɗa Musa u folonoi Vuzavaguɗu u danai, <<Vuzavaguɗu yiɗa̱i i zuwai ɗa va kuyaꞋan wupa n uma a̱ nu a na vu utukai a iɗika i Masar n utsura u gbayin n kukiye ku utsura ku nu? ");
INSERT INTO asg_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Yiɗa̱i i zuwai ɗa va kuzuwa aza a Masar a dana vu uta̱ka̱ le ta̱ n kusheshe ku gbani-gbani adama a na vuna le a kusan ka̱ta̱ vu niꞋwa̱ta̱ngu le aduniyan? N folono ta̱ ka̱ta̱ vu ka̱sukpa̱ wupa u nu wa, kucukpa vu ka̱sukpa̱ mita ma na vi sheshei kusuꞋuku uma a̱ nu. ");
INSERT INTO asg_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ciɓa n kagbashi ka̱ nu Ibirahi n Ishaku n Yakubu, aza na vu kucinakai n ka̱ci ka̱ nu, vu danai mi ta̱ a kuzuwa ntsukaya n ɗa̱ n yimkpa uteku tsa azangata a gaɗi, ka̱ta̱ n neke le iɗika i na vi yaꞋin uzuwakpani an va kuneke le, ka̱ta̱ yo okpo ili yi uka̱ni i le ayin dem.>> ");
INSERT INTO asg_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ɗaɗa Vuzavaguɗu u sabaꞋi kusheshe ku ni, ɗa u kpa̱ɗa̱i kutuka̱ le n kawuya ka na wi ishi a̱ kutuka̱ uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ana Musa u panai nannai, ɗa u cipa̱i a kusan ka n nshemberu ma atali n wila̱ n ni e ekiye. I ta̱ uɗani pulai n asuvu dem. ");
INSERT INTO asg_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Nshemberu ma atali ma ulinga u Ka̱shile u ɗa, iɗani ya kpamu Ka̱shile kaꞋa ka ɗanai n ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ana Jesuwa u panai uma a kuyaꞋan yoroli ɗa u danai Musa, <<Yoroli i nampa ya i yaꞋan ta̱ adanshi kuvon ki ta̱ ɗe a̱ ubuta̱ u koɓolo wa.>> ");
INSERT INTO asg_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ɗa Musa wu ushuki, <<Na va yoroli yu ulyaꞋi u kuvon u ɗa ba, kpamu yoroli ya aza o kusoꞋo atakaci i ɗa ta na ba, Ama yoroli yi ishipa i ɗa mi a kupana.>> ");
INSERT INTO asg_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ana u yawai ɗevu n ubuta̱ u na i va, ɗa we enei le e kujeꞋe n ka̱ma̱li ke medendem ka na a yaꞋin va. Ɗa u yaꞋin wupa n a̱bunda̱i, ali ɗa u variki nshemberu ma atali n wila̱ n na mi e ekiye a̱ ni, ɗa ta na o ɓosoi miri-miri a ɗaka vu kusan va. ");
INSERT INTO asg_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ɗa u ɗikai ka̱ma̱li ke medendem ka na a yaꞋin va ɗa u songi kaꞋa, ɗa wi iruwai ɗa kokpoi kokomo. Ɗa u bula̱ngi kaꞋa a̱ mini, ɗa u zuwai aza a Isaraila o soꞋo. ");
INSERT INTO asg_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ɗa u danai Haruna, <<Yiɗa̱i uma a nampa a yaꞋankai nu, ɗa vu zuwai a yaꞋin ili i gbani-gbani i gbayin nannai?>> ");
INSERT INTO asg_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ɗa Haruna u danai, <<Vuzagbayin, ka̱ta̱ vu ka̱sukpa̱ ka̱ɗu ka̱ nu ka̱ kula̱ ba. Vi yeve ta̱ uteku u na uma a nampa o ci yongo a kuciga kuyaꞋan ka gbani-gbani. ");
INSERT INTO asg_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","A danai mu, <YaꞋanka tsu a̱ma̱li a na tso kutono. Vuma vu nampa Musa wu uta̱ka̱ tsu ta̱ a Masar, ama ci yeve ili i na i yaꞋin ni ba.> ");
INSERT INTO asg_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ɗa n danai le, <Vuza na baci wi n iliyatsuvu ya azanariya u tuka̱.> Ɗa a̱ tuka̱i mu ta na, ana n zuwai akina ɗa i derikpei, ɗa i bonoi tsu medendem.>> ");
INSERT INTO asg_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ana Musa we enei Haruna va u ka̱sukpa̱ ta̱ uma a yaꞋan ili i kavama ali ɗa okpoi ili yi izoshi a̱ ubuta̱ wi irala i le, ");
INSERT INTO asg_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ɗa u shamgbai a̱ utsutsu u ka̱tsura̱ wa, u ɗengusa̱i ka̱la̱ka̱tsu, <<A̱ɗa̱ na yi a̱ ubuta̱ u Vuzavaguɗu, ta̱wa̱i na wa̱ va̱.>> Ɗaɗa aza e Levi ra̱ka̱ a̱ shida̱i a kubana wa̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ɗa Musa va u danai le, <<Ili i na Vuzavaguɗu Ka̱shile ki Isaraila ka danai i ɗaɗa na, yaba dem u woku kotokobi ka̱ ni ka̱ta̱ i ka̱na̱ kubana n u bonoi punu ubuta̱ u ka̱tsura̱ wa, a̱ kugita̱ a kakambu ka nampa sai a kakambu ka nan ɗe. Ka̱ta̱ yu una uma a, ko vuza nu ko ka̱ja̱Ꞌa̱ ka̱ nu ko vuza na yi ida̱shi koɓolo.>> ");
INSERT INTO asg_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ɗa aza a Levi o tonoi ili i na Musa u danai le a kanna ka nanlo ka, ɗa uma ɗevu n a̱kpa̱n a tatsu (3,000) a̱ kuwa̱i a kanna ka nanlo. ");
INSERT INTO asg_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ɗa Musa u danai aza e Levi a, <<Anana ye erengu ta̱ ka̱ci ka̱ ɗa̱ adama a ulinga u Vuzavaguɗu, n tsu na yu unai muku n ɗa̱ n aza ɗa̱ dem, n nannai ɗa i ciya̱i una̱singai anana.>> ");
INSERT INTO asg_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ana kayin kasai ɗa Musa u danai uma a, <<I yaꞋan ta̱ ili i gbani-gbani i gbayin. Ama mi ta̱ o kubono a̱ ubuta̱ u Vuzavaguɗu ko mi ta̱ a kufuɗa kufolono yi, ka̱ta̱ u cinukpaka ɗa̱ unushi u ɗa̱ wa.>> ");
INSERT INTO asg_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ɗa Musa u bonoi a̱ ubuta̱ u Vuzavaguɗu ɗa u danai, <<Ɓoɓou! Ili i gbani-gbani i gbayin i yiɗa̱i ta na uma a nampa a yaꞋin nannai! A yaꞋanka ɗe ka̱ci ke le a̱ma̱li a azanariya. ");
INSERT INTO asg_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ama gogo na n folono wu ta̱ cinukpaka le unushi wa, ama ki baci a kuyaꞋan nannai ba, mayun ura kula ku va̱ punu a katagarda ka na vu ɗanai va.>> ");
INSERT INTO asg_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ɗa Vuzavaguɗu wu ushuki Musa, <<Vuza na baci de dem u nusakai mu a̱yi ɗa n kutakpa kula ku ni a katagarda ka. ");
INSERT INTO asg_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Gogo na ɗa̱nga̱ vu bana vu tono n uma a a kubana a̱ ubuta̱ u na n danai nu va, kalingata ka̱ va̱ ki ta̱ a kuwala kelime ka̱ ɗa̱. Ama ayin a na n kutakacika uma a a yawa baci, mi ta̱ a kuyaꞋan adama a̱ unushi u le.>> ");
INSERT INTO asg_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ɗa Vuzavaguɗu u tuka̱i uma a m ma̱dukpa̱ adama a ili i na a yaꞋin n ka̱ma̱li ke medendem ka na Haruna u yaꞋankai le va. ");
INSERT INTO asg_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ɗa Vuzavaguɗu u danai Musa, <<Ka̱sukpa̱ ubuta̱ u nampa n uma a na vu uta̱ka̱i a iɗika i Masar dem, i bana a iɗika i na n kucinai kuneke Ibirahi, n Ishaku n Yakubu, ɗa u danai, <Mpa n kuneke ta̱ i ɗa ntsukaya n nu.> ");
INSERT INTO asg_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mi ta̱ a̱ kusuku n Kalingata kelime ka̱ ɗa̱, ka̱ta̱ n loko aza a KanaꞋana, n aza Amoriya, n aza a Hitiya, n aza a Periziya, n Jebusiya. ");
INSERT INTO asg_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Walai a kubana a iɗika i na yi m maniꞋin n tsuta̱. Ama mpa mi a kubana n a̱ɗa̱ ba, adama a na a̱ɗa̱ uma a ugbamukaci a ɗa yi, ta lo ma kuna ɗa̱ a uye.>> ");
INSERT INTO asg_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ana uma a a panai kadanshi ka gbani-gbani ka nampa, ɗa a uwai una̱mgbi wa̱ a̱tsuma̱ ali ɗa a̱ ka̱sukpa̱i kuꞋuka aminya a singai n ili yi kalishi i le. ");
INSERT INTO asg_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Adama a na Vuzavaguɗu u dana ta̱ Musa, <<Dana aza a Isaraila, <A̱ɗa̱ uma a ugbamukaci a ɗa yi, aza uzami u kadama. N dana baci yaꞋan n wala n a̱ɗa̱ megeshe kenu, mi ta̱ a kuna ɗa̱ gogo lo. Gogo na, foɗosoi ucanuku u tsuzogu u ɗa̱, ali sai ayin a na n sheshei ili i na n kuyaꞋan n a̱ɗa̱.> >> ");
INSERT INTO asg_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Adama a nannai ɗa uma a Isaraila o foɗoi aminya o tsuzogu e le, a ayin a na a̱ ɗa̱nga̱i a kusan ku Horebu. ");
INSERT INTO asg_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa ɗa vuza na u tsu ɗika ma̱va̱li ma ka̱ta̱ wu uta̱ka̱ m maꞋa u zuwa pulai daꞋangi n ubuta̱ u na a vaki, e ci ɗeke ta̱ maꞋa <<Ma̱va̱li mo Oɓolo.>> Vuza na baci u cigai kuyeve ili i na Vuzavaguɗu wi a kuciga ka̱ta̱ u bana a̱ ubuta̱ u Ma̱va̱li mo Oɓolo ma, ma na mi pulai va̱ a̱pa̱m va. ");
INSERT INTO asg_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","A ayin a na baci Musa wu uta̱i a̱ Ma̱va̱li mo Oɓolo ma, uma a̱ ci ɗa̱nga̱ ta̱ kashani ra̱ka̱, yaba dem u tsu shangba ta̱ kashani a̱ utsutsu u ka̱pa̱m ka̱ ni, ka̱ta̱ a̱ ka̱na̱ kinda Musa ali sai ayin a na u uwai asuvu a̱ Ma̱va̱li a. ");
INSERT INTO asg_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa u uwa baci a̱ Ma̱va̱li mo Oɓolo ma, kabashi ke keleshu ka̱ tsu cipa̱ ta̱ lo ka̱ta̱ ka shangba a̱ utsutsu u Ma̱va̱li wa, ayin a nanlo a ɗa Vuzavaguɗu u kuyaꞋan kadanshi n Musa. ");
INSERT INTO asg_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Uma e ene baci kabashi ke keleshu ka ka̱ cipa̱i ɗa ka shamgbai a̱ utsutsu u Ma̱va̱li wa, ka̱ta̱ yaba dem u ɗa̱nga̱ kashani a̱ utsutsu u ka̱pa̱m ka̱ ni ka̱ta̱ a cikpa yi. ");
INSERT INTO asg_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Vuzavaguɗu u ci yaꞋan ta̱ kadanshi m Musa a̱shi n a̱shi uteku tsu na vuza u ci yaꞋan kadanshi n ka̱ja̱ ka̱ ni. Ka̱ta̱ ayin a nanlo Musa u bono a̱ ubuta̱ u ka̱tsura̱ wa, ama ka̱ɓa̱nki ka̱ ni Jesuwa maku ma̱ Nun u tsu ka̱sukpa̱ ubuta̱ u Ma̱va̱li ma ba. ");
INSERT INTO asg_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ɗa kanna ke te Musa u danai Vuzavaguɗu, <<Vu tsu dana mu ta̱, <Tono n uma a nampa,> ama vu ka̱sukpa̱ mu n yeve vuza na va̱ kusuku koɓolo nu mpa ba. Vu dana ta̱, <N yeve ta̱ kula ku nu, kpamu vu ciya̱ ta̱ uɓa̱nki wa̱ va̱.> ");
INSERT INTO asg_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Mayun ɗa baci va a kupana asuvayali a̱ va̱, ka̱sukpa̱ mu n yeve uye u nu adama a na kpamu n doku n yevesheke wu mayin ka̱ta̱ kpamu n lyaꞋa kelime n kupana uyoꞋo u kasingai a̱ ubuta̱ u nu. Ciɓa a na aduniyan a nampa, a uma a̱ nu a ɗa.>> ");
INSERT INTO asg_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ɗa Vuzavaguɗu wu ushuki, <<Mpa mi ta̱ a kubana n avu, ka̱ta̱ n neke wu ka̱ɗu ki ida̱shi.>> ");
INSERT INTO asg_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ɗa Musa u danai, vi baci a kubana n a̱ tsu ba, ka̱ta̱ vu ka̱sukpa̱ tsu tsu ka̱sukpa̱ ubuta̱ u nampa wa ba. ");
INSERT INTO asg_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nini ɗai e kuyeve a na vi a kupana uyoꞋo u va̱ n uma a̱ nu kpamu, vu bana baci n a̱ tsu ba? Yiɗa̱i i kupecemgbenei mpa n uma a̱ nu n uma aduniyan a na a buwai? ");
INSERT INTO asg_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ɗa Vuzavaguɗu u danai Musa, <<Mi ta̱ a kuyaꞋan ili i na vu folonoi, adama a na m pana ta̱ uyoꞋo u nu, n yeve wu ta̱ kpamu n kula ku nu.>> ");
INSERT INTO asg_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ɗa Musa u danai, <<Gogo na yotsongu mu tsugbayin tsu nu.>> ");
INSERT INTO asg_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ɗa Vuzavaguɗu u danai, <<Mi ta̱ a kuzuwa kasingai ka̱ va̱ ra̱ka̱ ka pasamgbanai kelime ka̱ nu, ka̱ta̱ n sala kula ku va̱ <Vuzavaguɗu> e kelime ka̱ nu. Mi ta̱ a kupana asuvayali u vuza na n cikalai n kupana asuvayali, n yotsongu ucigi u va̱ kpamu u vuza na n cikalai. ");
INSERT INTO asg_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ama,>> ɗa u danai, <<Ve kene a̱shi a̱ va̱ ba, adama a na babu vuza na u kene mu ka̱ta̱ u yongo n wuma.>> ");
INSERT INTO asg_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ɗa Vuzavaguɗu u danai, <<Ubuta̱ wi ta̱ na ɗevu nu mpa u na va kushamgba a kakpanlai. ");
INSERT INTO asg_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tsugbayin tsu va̱ ci baci a kupasamgbanai, mi ta̱ o kusokongu wu a kaɓatsu ka kakpanlai ka, ka̱ta̱ m pala wu n kukiye ku va̱ ali sai ayin a na m pasamgbanai. ");
INSERT INTO asg_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mi ta̱ a kutakpa kukiye ku va̱, ka̱ta̱ n ka̱sukpa̱ ve ene kucina̱ ku va̱, ama ve kene a̱shi a̱ va̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ɗa kpamu Vuzavaguɗu u danai Musa, <<Gogo na sheꞋwe nshemberu ma atali n yoku n re tsu na ishi cau ɗa vu ɓosoi va, mi ta̱ o kudoku ma ɗana ili i na yi ishi punu uɗani. ");
INSERT INTO asg_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Foɓuso mkpaꞋa n usana, ka̱ta̱ vu ta̱wa̱ a Kusan ku Sinai vi yotsongu ka̱ci ka̱ nu wa̱ va̱ ɗe a gaɗi vu kusan va. ");
INSERT INTO asg_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Babu vuza na u kuta̱wa̱ koɓolo n avu ko e ene yi a uɓon u kusan u nanlo, ko ushiga wu nlala ko anaka a kuyaꞋan kalina a ukambu u nanlo ba.>> ");
INSERT INTO asg_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ɗa Musa u sheꞋwei nshemberu ma atali n re tsu na Ka̱shile ka danai uteku tsu na a cau a ishi. Ɗa u foɓusoi n usana, ɗa u banai a kusan ka. Ɗa u ɗikai nshemberu ma atali n re e ekiye a̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ɗa Vuzavaguɗu u cipa̱i a̱ ka̱tsuma̱ ke keleshu ɗa u shamgbai koɓolo m Musa, ɗa u ɗekei kula ku ciɗa ku ni, Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ɗa u walai e kelime ka Musa ɗa u ɗekei ka̱ci ka̱ ni kula, Vuzavaguɗu, Vuzavaguɗu. Mpa ɗa vuza na u tsu pana asuvayali, mi ta̱ kpamu n uremi u ka̱ɗu. N yotsongu le ta̱ ucigi u va̱ u gbayin, n ci yaꞋan ta̱ ili derere, ");
INSERT INTO asg_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","n ci yaꞋan ta̱ uzuwakpani wu ucigi a kubana wu ntsukaya a̱kpa̱n-a̱kpa̱n, u tsu cinukpaka ta̱ aza a na a yaꞋin kagbanigbani, n unushi, ko ili i kavama i yoku. N nannai dem u tsu kpa̱ɗa̱ kutakacika vuza na u yaꞋin unushi ba, u tsu takacika ta̱ muku adama a unushi wu mmaci n le kutatsu ali kuna̱shi feu. ");
INSERT INTO asg_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ɗa Musa u yaꞋin moloko ɗa u kuɗa̱ngi u lyaꞋi kayala ɗa u cikpai ni. ");
INSERT INTO asg_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","U danai <<Vuzavaguɗu n ciya̱ baci mapasa ma singai wa̱ nu, yaꞋan Vuzavaguɗu u bana n a̱ tsu. Ko n tsu nannai uma a i ta̱ n ugbamukaci, n folono wu ta̱ cinukpaka tsu ka gbani-gbani n unushi u na ci yaꞋankai nu, bonoko tsu uma a̱ nu a mayun.>> ");
INSERT INTO asg_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ɗa Vuzavaguɗu u danai, Mpa n kuyaꞋan ta̱ uzuwakpani n avu. E kelime ka uma a̱ nu ra̱ka̱ mi ta̱ a kuyaꞋan ili mereve i na n saꞋwai kuyaꞋan a̱ ubuta̱ u uma aduniyan ba. Uma a na yi ida̱shi koɓolo e kene ta̱ ili i mereve i Vuzavaguɗu, i na n kuyaꞋanka ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tonoi ili i na n danai ɗa̱ anana mayin na. Mi ta̱ o kuloko aza Amoriya, n aza KanaꞋana, n aza Hitiya, n aza Periziya, n aza Hiwiya, n Jebusiya. ");
INSERT INTO asg_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","YaꞋin mayin ka̱ta̱ i yaꞋan uzuwakpani n uma a na yi a kubana kucina a iɗika i na i kuda̱sa̱ngu va ba, adama a na i ta̱ o kokpo an maza wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ka̱ta̱ i fa̱da̱ atalialyuka e le, nva̱li n le, ka̱ta̱ i kapa ka̱ma̱li ka ashara. ");
INSERT INTO asg_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ka̱ta̱ i cikpa a̱ma̱li o yoku ba, sai mpa endeꞋin, Vuzavaguɗu vu na kula ku ni ku ɗa cisheꞋe, a̱yi Ka̱shile ke cisheꞋe kaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ka̱ta̱ i yaꞋan uzuwakpani n uma a na i punu ida̱shi a iɗika ya ba, ayin a na baci a yaꞋin tsugbani a̱ ubuta̱ wa̱ a̱ma̱li u le n alyuka, i ta̱ a kubanuku ɗa̱ ka̱ta̱ i lyaꞋa ili ya lyuka ya. ");
INSERT INTO asg_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","I zamaka baci olobo a̱ ɗa̱ nkere n le adama a na o okpo le a̱ma̱ci, nkere n le n nanlo mi ta̱ a kuzuwa olobo a̱ ɗa̱ a nanlo o bono o tono a̱ma̱li e le a. Nannai ɗa a kuzuwa muku n ɗa̱ n yaꞋan feu nannai. ");
INSERT INTO asg_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","<<Ka̱ta̱ i maꞋaka ka̱ci ka̱ ɗa̱ a̱ma̱li n iyum ba. ");
INSERT INTO asg_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","<<Ka̱ta̱ i ciɓasa n ka̱ɗiva̱ ko Boroji vu babu yisiti. A̱ ka̱tsuma̱ ka ayin e cindere ka ɗaɗa va kutakuma Boroji va, uteku tsu na n danai nu. YaꞋan ka̱ɗiva̱ ka nampa ka a̱ ka̱tsuma̱ ka ayin derere ko wotoi u Abibu, a̱ ka̱tsuma̱ ko wotoi u nampa ɗaɗa yu uta̱i a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Maku ma iyain dem ma̱ va̱ maꞋa, koɓolo n maku ma iyain mo kogono mi ilikuzuwa ko wa anaka ko ka nlala. ");
INSERT INTO asg_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Shiba̱ majaki ma na a̱ gita̱i kumatsa m mokyon, vu fuɗa baci vu shiba̱ ma ba, ka̱ta̱ vu koɗo kuɗeku ku majaki ka. Shiba̱i ngaji n ɗa̱ ra̱ka̱. Babu vuza na u kuta̱wa̱ wa̱ va̱ n ekiye agaɗa. ");
INSERT INTO asg_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","<<A̱ ka̱tsuma̱ ka ayin a̱ ta̱li ka ɗaɗa va kuyaꞋan ulinga, kanna ke cindere ka ɗaɗa va kuvuka, ko ayin a vicimba ko ayin a vukyaꞋa ka̱ta̱ vu uvuka. ");
INSERT INTO asg_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ka̱ta̱ vu ciɓa n ka̱ɗiva̱ ka vukyaꞋa, n ka̱ɗiva̱ ku umaci wu giti u alkama, n ka̱ɗiva̱ ko kukotsoso vukyaꞋa, a ukocishi u ka̱ya̱. ");
INSERT INTO asg_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","A̱ ka̱ya̱ dem muku n ali i ta̱ a̱ kuta̱wa̱ u Vuzavaguɗu kutatsu, Vuzavaguɗu Ka̱shile ki Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mi ta̱ o kuloko uma a na i na punu ka̱ta̱ n doku wanshi wi ɗika i nu. Babu Vuza na u kucikala kisa iɗika i nu a ayin a na baci vu banai e kelime ka Vuzavaguɗu kutatsu. ");
INSERT INTO asg_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","<<Ka̱ta̱ vi yaꞋanka mu alyuka a mpasa n yisiti punu ba, ka̱ta̱ vu ka̱sukpa̱ inyama i na a yaꞋankai alyuka a̱ ka̱ɗiva̱ ka kupasamgbanai ali a kubana usana ba. ");
INSERT INTO asg_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Tuka̱ n i na i gita̱i kugeꞋwe i na i laꞋi n kugaꞋan a̱ ka̱tsuma̱ ki ica̱shi i kashina i nu a kpaꞋa ku Ka̱shile Vuzavaguɗu. Ka̱ta̱ kpamu vu suꞋwan maku ma maraɗika ma na ma kapa mani ma̱ a̱na̱ku a̱ ni ba.>> ");
INSERT INTO asg_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ɗa Vuzavaguɗu u danai Musa, <<Ka̱ta̱ vu ɗana ili i na n danai nu, n udani u nampa u ɗaɗa n kuyaꞋan uzuwakpani n avu m muku mi Isaraila.>> ");
INSERT INTO asg_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa u yongoi ɗe a kusan ka n Vuzavaguɗu ali ayin amangere kanna n kayin. Ayin a nanlo dem u lyaꞋa ili ba, u soꞋo mini kpamu ba. Ɗa u ɗanai punu a nshemberu ma atali ma ukuna wu uzuwakpani n Wila̱ Kupa. ");
INSERT INTO asg_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ana Musa u cipa̱i a Kusan ku Sinai ka n Wila̱ Kupa wa e ekiye a̱ ni, ɗa a̱shi a̱ ni a̱ ka̱na̱i kutasa an akina adama a na Vuzavaguɗu u yaꞋan ta̱ kadanshi n a̱yi. Ama Musa u yeve a na uɓon u a̱shi a̱ ni i a kutasa ba. ");
INSERT INTO asg_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ana Haruna n uma a Isaraila e enei Musa uɓon u a̱shi a̱ ni a kutasa, ɗa a panai wovon u kuyawa ɗevu n a̱yi. ");
INSERT INTO asg_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ama ɗa Musa u ɗekei le, ɗa Haruna nu nkoshi m gba̱ra̱-gba̱ra̱ n likuci n ta̱wa̱i wa̱ ni, ɗa u yaꞋin kadanshi n le. ");
INSERT INTO asg_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ana nannai u yaꞋin ɗa uma a Isaraila a yawai ɗevu n a̱yi ɗa u nekei le wila̱ u na Vuzavaguɗu u nekei ni a Kusan ku Sinai. ");
INSERT INTO asg_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ana Musa u kotsoi kuyaꞋanka le kadanshi, ɗa u palai a̱shi a̱ ni n kakashi. ");
INSERT INTO asg_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ama a ayin a na baci u banai e kelime ka Vuzavaguɗu adama a na u yaꞋan kadanshi n a̱yi u tsu takpa ta̱ kakashi ka, ali sai ayin a na wu uta̱i u danai aza a Isaraila ili i na Ka̱shile ka danai ni. ");
INSERT INTO asg_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Uma a Isaraila e ce ene ta̱ a̱shi a Musa a kutasa. Ɗaɗa i zuwai Musa u tsu pala a̱shi a̱ ni ali sai ayin a na u banai a̱ ubuta̱ u na Vuzavaguɗu u ci yaꞋan kadanshi n a̱yi. ");
INSERT INTO asg_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ɗa Musa u ɓolongi aza a Isaraila ɗa u danai, ili i na Vuzavaguɗu u danai ɗa̱ i yaꞋan i ɗa na. ");
INSERT INTO asg_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ayin a̱ ta̱li a ɗa i kuyaꞋan ulinga, ama a kanna ke cindere kanna ka kuvuka kaꞋa adama Ashibi, kana ka ciɗa ka Vuzavaguɗu kaꞋa. Vuza na baci de dem u yaꞋin ulinga a kanna ka nanlo i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ka̱ta̱ i tasuku akina a iꞋuwa i ɗa̱ a kanna ka Ashibi ba. ");
INSERT INTO asg_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ɗa Musa u danai aza a Isaraila dem, <<I na Vuzavaguɗu u danai i ɗa na. ");
INSERT INTO asg_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Banka Vuzavaguɗu kuneꞋe ku ciɗa, yaba dem vu na wi n ka̱ɗu ke kuneꞋe, yaꞋan u tuka̱ n kuneꞋe ku nampa u Vuzavaguɗu, azanariya, n azurufa, n iyum shili. ");
INSERT INTO asg_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","N tsu mini mu usuni, n tsu na ci yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, n arikinla a singai, n cileme tsu nraɗika, ");
INSERT INTO asg_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","n ukpan wu nlala m ma̱ri u na a lapulai mayin, n ukpan u singai u singai, m maɗanga me megele, ");
INSERT INTO asg_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","m maniꞋin ma zaitu adama a̱ nkuni, n ucanuku u wali adama a maniꞋin me kerengu, m maniꞋin ma̱ ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","n atali o onis, n atali a na a buwai a singai a singai adama a na a paɗa a ɗa a efodu m mabambata. ");
INSERT INTO asg_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Aza a na i n kuyeve a̱ ka̱tsuma̱ ka̱ ɗa̱ a̱ ta̱wa̱, adama a na a yaꞋan ili i na Vuzavaguɗu u danai tsu ci yaꞋan, ");
INSERT INTO asg_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ma̱va̱li ma Kuciɓa n Ka̱shile n ka̱pa̱m n ili i na a kupalaka yi n ashiyatsu a̱ ni, m muntsa mu utsutsu ma̱ ni, n alangu, nu nshikpu, n anci e le, ");
INSERT INTO asg_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","n akpati vu uzuwakpani va n alangu a̱ ni, n ka̱kuya̱mkpa̱tsu ka kutakpaka unushi, n kakashi ku utsutsu ka na a tsu palaka akpati va, ");
INSERT INTO asg_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","kirukpa ka n alangu a̱ ni, n ucanuku wu ulinga u ni ra̱ka̱ m boroji vu ciɗa, ");
INSERT INTO asg_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","n kashamkpatsu ka na ka̱ ka̱na̱i nkuni ma adama a kutashi, n ucanuku wu ulinga u le, nu nkuni ma, m maniꞋin ma̱ nkuni ma adama a kutashi, ");
INSERT INTO asg_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","n katalikalyuka o kusongu ili ma̱gula̱ni n alangu a̱ ni, m maniꞋin me kerengu, ni ili ma̱gula̱ni, n ka kashi ku utsutsu ka̱ ma̱va̱li ma kuciɓa n Ka̱shile, ");
INSERT INTO asg_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","katalikalyuka o kusongu, m majaun mi iyum i shili, n alangu a̱ ni, n ucanuku wu ulinga u le, n kakpanu ki iyum i shili n kanci ka̱ ni, ");
INSERT INTO asg_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","n kakashi ka nshilya ku ulanga u ma̱va̱li wa, nu nshikpu n anci e le, n kakashi ku utsutsu u gbayin u ma̱va̱li wa, ");
INSERT INTO asg_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","aguta a̱ kushukpa̱ka̱ ma̱va̱li ma kuciɓa n Ka̱shile ma, n aguta a nshilya mu ulanga u ma̱va̱li wa n awin e le, ");
INSERT INTO asg_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","m motogu mu ucaꞋi ma kuꞋuka adama a ulinga a̱ ubuta̱ u ciɗa nu ntogu n ciɗa mu ulinga u tsuganu n Haruna, nu ntogu m muku ni, adama a ulinga u tsuganu.>> ");
INSERT INTO asg_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ɗa uma a Isaraila ra̱ka̱ a̱ ka̱sukpa̱i ubuta̱ u na Musa va wi. ");
INSERT INTO asg_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Aza a na a cigai kuneke, ɗa a̱ɗu e le a̱ ushuki kuneke a̱ tuka̱ n kuneꞋe ku le u Vuzavaguɗu, adama ulinga u Ma̱va̱li mo Oɓolo, nu ulinga u na u buwai dem, nu ntogu n ciɗa n tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ɗa ali n a̱ma̱ci aza na ushuki kuneke, ɗa a̱ tuka̱i n kuneꞋe ku le, ili ya atsuvu ya azanariya, n nkawani ma̱ a̱jivu, n ila̱nga̱, n ili i kuɗeku, n ucanuku u tsuloboi kakau, yaba dem u nekei kuneꞋen ku kuɗa̱ngusa̱ ka azanariya ku ni u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Vuza na baci de dem wi n tsugbere tsu mini mu usuni, n tsu na ci yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱ n arikinla a singai a na a yaꞋin, ko cileme tsu nraɗika, ko ukpan wu nlala ma̱ri u na a lapulai ko ukpan u na a lapulai mayin. ");
INSERT INTO asg_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Vuza na baci u tuka̱i n kuneꞋe ka azurufa ko iyum ishili, u tuka̱ n kuneꞋe ka u Vuzavaguɗu. Vuza na baci kpamu wi m maɗanga me megele ma na a ku yaꞋanka ulinga, ka̱ta̱ vuza va u tuka̱. ");
INSERT INTO asg_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","A̱ma̱ci a na e yevei kuyaꞋan tsugbere n ekiye e le a̱ tuka̱ n tsu ɗa, tsugbere tsu mini mu usuni, n tsu mini ma na mo yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, n arikinla a singai a na a caꞋi. ");
INSERT INTO asg_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","A̱ma̱ci a na e nekei a̱ɗu e le ɗa a cigai kuyaꞋan ulinga n kuyeve ku na i n ku ɗa, ɗa a yaꞋin tsugbere n cileme tsu nraɗika. ");
INSERT INTO asg_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Aza e kelime a̱ tuka̱ n atali o onis n atali a na a buwai a singai a singai adama a na a paɗa le a efodu m mabambata ma. ");
INSERT INTO asg_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ɗa kpamu a̱ tuka̱i n ucanuku u wali m maniꞋin ma zaitu adama a̱ ma̱kuni, m maniꞋin me kerengu n ili i ma̱gula̱ni. ");
INSERT INTO asg_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Uma a Isaraila ra̱ka̱ ali n a̱ma̱ci aza na i n ka̱ɗu ke kuneke ba̱ri ubuta̱ wu linga u Vuzavaguɗu ɗa a̱ tuka̱i n kuneꞋe ku le ku na ka̱ kuɓa̱nka̱ kuyaꞋan ulinga u Vuzavaguɗu tsu na Musa u danai le a yaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ɗa Musa u danai aza a Isaraila, <<Indanai, Vuzavaguɗu u zagba ta̱ Bezale maku ma̱ Uri vashi vu Horu a kumaci ku Yahuda, ");
INSERT INTO asg_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ɗa u shatangi ni n ayinviki a̱ Ka̱shile, n kuyeve n ugboji wu ulinga ra̱ka̱, ");
INSERT INTO asg_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","adama a na u yaꞋan ili n tsuzogu n tsuzogu, u yima kpamu ili ya azanariya, n azurufa, n iyum i shili, ");
INSERT INTO asg_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ka̱ta̱ u sheꞋwe atali a na a kuzuwa a urotu wu utsutsu u kenu, u sheꞋwe kpamu maɗanga, wo okpo kpamu Vuza na u yevei ulinga we ekiye. ");
INSERT INTO asg_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Vuzavaguɗu u neke yi ta̱ Oholiya maku ma Ahisamaka, kumaci ku Dan, adama a na u yotsongusu aza o yoku. ");
INSERT INTO asg_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ɗa u shatangi le n kuyeve ku ulinga kakau we ekiye, n kuyaꞋan tsuzogu kpamu kakau, n kucaꞋa, n igani i kucaꞋa ke ekiye n tsugbere tsu mini mu usuni, n tsu na ci yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, n arikinla a ucaꞋi a singai. I ta̱ n kuyeve ku ulinga we ekiye.>> ");
INSERT INTO asg_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","<<Bezale n Oholiyabu n Vuza na de wi n kuyeve ku na Vuzavaguɗu u nekei ni, u yaꞋan ulinga n ku ɗa, adama a kumaꞋa ku ubuta̱ u ciɗa ka̱ta̱ a yaꞋan tsu na Vuzavaguɗu u danai le a yaꞋan.>> ");
INSERT INTO asg_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ɗa Musa u ɗekei Bezale, n Oholiyabu, n aza a na Vuzavaguɗu u nekei ugboji u kuyeve ulinga n aza a na kpamu ushuki kuta̱wa̱ kuyaꞋan ulinga wa. ");
INSERT INTO asg_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ɗa Musa u nekei le kuneꞋe ku na aza a Isaraila a̱ tuka̱i adama a ulinga u kuyaꞋan Ma̱va̱li ma kuciɓa n Ka̱shile. Ɗa uma a̱ ka̱na̱i kutusa̱ka̱ n kuneꞋe ku ucanuku n usana dem uteku u na a̱ɗu e le a cigai. ");
INSERT INTO asg_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Aza a ulinga we ekiye ra̱ka̱ aza na i a kuyaꞋan ulinga a̱ ubuta̱ u ciɗa, a̱ ka̱sukpa̱i biꞋi ulinga wa. ");
INSERT INTO asg_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Ɗa a banai u Musa ɗa a danai, <<Uma i ta̱ a̱ kutuka̱ n ili n a̱bunda̱i i na i laꞋi i na a zuwai a yaꞋanka ulinga u na Vuzavaguɗu u danai ci yaꞋan.>> ");
INSERT INTO asg_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musa u nekei le kadanshi, ɗa ta na a banai a salakai le a̱ ubuta̱ u na uma i ka̱tsura̱-ka̱tsura̱ dem, <<Babu vali ko vuka vu na wo kudoku kutuka̱ n kuneꞋe kpamu adama a̱ Ma̱va̱li ma kuciɓa n Ka̱shile.>> Ɗa uma a̱ ka̱sukpa̱i kutusa̱ka̱, ");
INSERT INTO asg_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","adama ili i na a̱ ciya̱i ɗe i yimkpa ta̱ n a̱bunda̱i i na i laꞋi kuyaꞋanka ulinga wa ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Eyevi a ulinga a̱ ka̱tsuma̱ ka aza a ulinga wa ɗa a yaꞋin Ma̱va̱li ma kuciɓa n Ka̱shile ma n akashi kupa, a na a caꞋi n tsugbere tsu ucaꞋi tsu singai, tsu mini mu usuni, n tsu na ci yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱. Akashi a nanlo a ɗa a yaꞋankai tsuzogu tsu na a palakai Corobi va, i na keyevi ku ulinga ka yaꞋin. ");
INSERT INTO asg_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ugaɗi u kakashi dem u yaꞋan udashi amangere n u re, wanshi u ni kpamu udashi u ta̱li. Kakashi ka yaꞋan ugisanki derere. ");
INSERT INTO asg_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ɗaɗa o ɓolongi akashi a tawun a nampa a a̱ ubuta̱ u te ɗa o okpoi kakashi ka gbayin ke te, ta kpamu a yaꞋin n akashi a tawun a na a buwai va kpamu nannai. ");
INSERT INTO asg_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ɗa a yaꞋankai kakashi dem nroki n kusaku n na mi tsu mini mu usuni, ka na a̱ jilya̱i a̱ una̱ u kakashi ka iyain ka na o ɓolomgbonoi, ta kpamu a yaꞋankai ke i re ka nannai. ");
INSERT INTO asg_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ɗa a̱ jilya̱ka̱i kakashi ke te nroki amangerenkupa, nroki amangerenkupa kpamu a ukoci u kakambu ku uteku ka na ɗe, nroki ma okpo derere a mindansanai. ");
INSERT INTO asg_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ɗa a yaꞋin ashiyatsu azanariya amangerenkupa, ɗa a gasatamgbanai kakashi ka koɓolo a̱ ubuta̱ wa ashiyatsu wa, adama a na Ma̱va̱li ma kuciɓa n Ka̱shile ma mo okpo ili i te. ");
INSERT INTO asg_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ɗa a yaꞋin akashi kupa n ke te n cileme tsu nraɗika tsu na a̱ kuɓa̱ya̱nku Ma̱va̱li ma kuciɓa n Ka̱shile ma. ");
INSERT INTO asg_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Akashi kupa n kete dem ugaɗi u ni u yawa ta̱ udashi amangere n a tawun wanshi u ni kpamu udashi u ta̱li. ");
INSERT INTO asg_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ɗa Bezale u ɓolongi akashi a tawun ɗa a̱ jilya̱i a ɗa ubuta̱ u te, ɗa okpoi ke te. Ugboku u ta̱li u na ɗe kpamu nannai. ");
INSERT INTO asg_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ɗa a̱ jilya̱i nroki amangerenkupa a̱ ka̱kina̱ ku teku u kakashi ku ugboku u te, n kakambu ku uteku ku ugboku ke te ka na ka buwai feu nannai. ");
INSERT INTO asg_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ɗa kpamu a yaꞋin ashiyatsu a̱ iyum i shili amangerenkupa adama a na o ɓolongu n ili i kusaku ya, ciya̱ Ma̱va̱li ma ma mo okpo ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ɗa a yaꞋankai Ma̱va̱li ma ka̱ɓa̱ya̱ntsu ku ukpan u ka̱giri ɗa a̱ shina̱i m mini ma garula. Ɗa kpamu a yaꞋin ili i yoku i kupalaka ukpan wa, nu ukpan u manama ma̱ mini. ");
INSERT INTO asg_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ɗa a yaꞋin nshikpu mu utsutsu ma m maɗanga me megele adama a̱ Ma̱va̱li ma kuciɓa n Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Nshikpu mu utsutsu dem, uɗa̱ngi u ni u yawa ubapi kupa n u tawun, wanshi u ni kpamu udyawi kamanga n u cindere, ");
INSERT INTO asg_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","n aguta ere uzuwi derere n vutoku. Ta a yaꞋin nshikpu mu utsutsu u Ma̱va̱li ma kuciɓa n Ka̱shile ma nannai. ");
INSERT INTO asg_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ɗa a yaꞋin nshikpu mu utsutsu kamanga u Ma̱va̱li ma kuciɓa n Ka̱shile ma na mi a kindana uɓon u ɗaka. ");
INSERT INTO asg_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ɗa a yaꞋin anci amangere ya azurufa, adama a na a zuwa le ɗaka vu nshikpu n nan ɗe ma, ka̱ta̱ a zuwa anci e re ɗaka vu ma̱shikpu dem, adama na a̱ ka̱na̱ aguta e re a mayin. ");
INSERT INTO asg_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","N kakambu ka na ɗe, n tsu gaɗi tsu Ma̱va̱li ma kuciɓa n Ka̱shile ma, ɗa a yaꞋin nshikpu mu utsutsu kamanga. ");
INSERT INTO asg_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ɗa a yaꞋin anci a azurufa amangere, anci e re a ɗaka vu nshikpu mu utsutsu wa dem. ");
INSERT INTO asg_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ɗa a yaꞋin nshikpu mu utsutsu n ta̱li adama a̱ kucina̱ ku ma̱va̱li ma n tsu kakambu ka̱ ka̱livi. ");
INSERT INTO asg_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","A yaꞋin kpamu nshikpu mu utsutsu n re adama o ngo m Ma̱va̱li ma kuciɓa n Ka̱shile ma, n tsu kucina̱ ku ni. ");
INSERT INTO asg_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Nshikpu mu utsutsu ngo n na o ɓolongi n tsu gaɗi tsu nshikpu mu utsutsu u iyain. Ama n tsu ɗaka a̱ ka̱sukpa̱i ni upecemgbenei. Ta kpamu nshikpu n re n na a yaꞋin a ngo n re ma nannai. ");
INSERT INTO asg_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nshikpu kunla̱i ɗa i, n anci kupa n a̱ ta̱li a azurufa, n anci e re ɗaka vu nshikpu n le dem. ");
INSERT INTO asg_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","A yaꞋan aburakpatsu a maɗanga me megele, aza tawun adama a nshikpu n kakambu ke te ka̱ Ma̱va̱li ma kuciɓa n Ka̱shile ma. ");
INSERT INTO asg_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Aburakpatsu a tawun a kakambu ka nan ɗe, aza a tawun kpamu adama a̱ nshikpu n kakambu ku uɓon u ka̱livi, daꞋangi ɗe a̱ kucina̱ ku ukocishi ku Ma̱va̱li ma kuciɓa n Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ɗa a yaꞋin kaburakpatsu ke mere, adama a na ka̱ ka̱na̱ uteku n uteku e mere mu nshikpu ma. ");
INSERT INTO asg_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ɗa a paɗarai nshikpu mu utsutsu wa n azanariya, ɗa a yaꞋankai le kpamu nkawani ma azanariya, adama a na a̱ ka̱na̱ alangu a. A paɗarai alangu a n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","A yaꞋin kakashi ku utsutsu ka na ki n tsugbere tsu mini mu usuni, n tsu na ci yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, n tsugbere tsu ucaꞋi tsu singai. Ɗa aza a na e yevei kuzuwa tsuzogu a yaꞋankai le iɗani yi igani tsu Corobi. ");
INSERT INTO asg_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ɗa a saki ɗe kakashi ka a nshikpu n na̱shi m maɗanga me megele ɗa a paɗarai ikyamba i le n azanariya, aza na i n okoɓotsu. Ɗa a̱ shikpa̱i le a anci e le a̱ na̱shi a azurufa. ");
INSERT INTO asg_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","A yaꞋin kakashi adama a̱ utsutsu u kuꞋuwa Ma̱va̱li ma kuciɓa n Ka̱shile ma n tsugbere tsu mini mu usuni, n tsu na ci yotsoi mini ma garula n tsu mini ma̱ ma̱ɗiya̱ n tsugbere tsa akaɗa. Ɗa a yaꞋankai kakashi ka igani i kucaꞋa ke ekiye. ");
INSERT INTO asg_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ɗa a yaꞋin nshikpu n tawun n ikoɓotsu i le. Ɗa a paɗarai nshikpu ma a uɓon u gaɗi u le wa n azanariya, ama anci a tawun e le a, a yaꞋin le n iyum i shili. ");
INSERT INTO asg_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezale u yaꞋin akpati vu uzuwakpani m maɗanga me megele. Ugaɗi u ni u yawa ta̱ udashi u tatsu n udyawi kuci, wanshi u ni kpamu u yawa ta̱ udashi u re n udyawi u tatsu Uɗa̱ngi u ni u yawa ta̱ ubapi u re n udyawi u tatsu. ");
INSERT INTO asg_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","U paɗarai ikyamba i ni pulai n asuvu a̱ ni n azanariya ɗa u lapulai kpamu akambu a̱ ni n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ɗa ukai akpati va nkawani ma azanariya n na̱shi, n a̱ luwa̱i ɗa u zuwai n ɗa punu e ene a akpati va, kakambu dem nkawani n re. ");
INSERT INTO asg_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ɗa u yaꞋin nshikpu mu nɗanga me megele, u paɗarai n ɗa n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ɗaɗa u ukai punu alangu a una̱ wu nkawani n re ma akpati ma, adama a na a ɗikaka. ");
INSERT INTO asg_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ɗa u yaꞋin ka̱kuya̱mkpa̱tsu ka kutakpa unushi, n azanariya koci. Ugaɗi u ni u yawa ta̱ udashi u tatsu n udyawi kuci, wanshi u ni udashi u re n udyawi u tatsu. ");
INSERT INTO asg_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ɗa u yaꞋin Corobi vi re n azanariya a na a yimai a̱ uteku u ka̱kuya̱mkpa̱tsu ka. ");
INSERT INTO asg_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","U yaꞋin Corobi vi te a uteku u nampa, Corobi vu te kpamu a uteku u nan ɗe, ɗe a uteku wa, ɗa u yaꞋin le punu ugasatangbani n ka̱kuya̱mkpa̱tsu ka ɗe a̱ ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Corobin va wi ta̱ n evelyu a̱ ni ubapi zuva, a palai ka̱kuya̱mkpa̱tsu ka. Corobin va vi ta̱ a mindansanai, a kinda ka̱kuya̱mkpa̱tsu ka. ");
INSERT INTO asg_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ɗa kpamu u yaꞋin kirukpa m maɗanga me megele, ugaɗi u ni udashi u tatsu, wanshi u ni udyawi u ta̱li. Uɗa̱ngi u ni ubapi u re n udyawi u tatsu. ");
INSERT INTO asg_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","U paɗarai ku ɗa n azanariya koci, ɗa kpamu u lapulai iga̱Ꞌin i ni ya n azanariya a̱ kuka̱ra̱Ꞌa̱. ");
INSERT INTO asg_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ɗa u sheꞋwei i li tsu makawani a̱ kuka̱ra̱ka̱, ka̱ta̱ wanshi u ni u laza kataka ke kukiye ba. Ka̱ta̱ vu tono ka̱ga̱Ꞌin ka vu paɗara n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ɗa a̱ luwa̱i nkawani n na̱shi ma azanariya, ɗa a ukai n ɗa ɗe a ngo n na̱shi n kirukpa ma. ");
INSERT INTO asg_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nkawani ma a zuwa ta̱ n ɗa ɗevu, m mashigi ma na ma̱ ka̱na̱i ashamkpatsu a na a ci ɗikaka kirukpa ka. ");
INSERT INTO asg_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ɗa u yaꞋin ashamkpatsu a maɗanga me megele, ɗa u paɗarai le n azanariya. A ɗaɗa a ci ɗikaka kirukpa ka. ");
INSERT INTO asg_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ɗa u yaꞋin apara ni nvene n atan a na a yaꞋin n azanariya koci, koɓolo kpamu nu nsasu n a̱ka̱na̱tsu n na a ci yaꞋanka ulinga a̱ ubuta̱ u kutsungu ili i kuɗarukpa alyuka o kusoꞋo. ");
INSERT INTO asg_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ɗa u yaꞋin kashamkpatsu ka̱ ma̱kuni ka n azanariya koci a na a yimai, kashamkpatsu ka n anci a̱ ni, iyoci ya̱ a̱pa̱lu a̱ ni, mɓom n ni, n uba̱zukpi u ni, wo okpo ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","A kacaka ka̱ ta̱li a̱ uta̱i ɗe a kashamkpatsu ke te, a kakambu ka nampa acaka a tatsu a kakambu ka nan ɗe feu acaka a tatsu. ");
INSERT INTO asg_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Atan a tatsu a na a yaꞋin n iyoci ya̱ a̱pa̱lu a alumo, nu mɓom, n uba̱zukpi, okpo a kacaka ke te, a tatsu a kacaka ka nan ɗe, ta u kuyaꞋan nannai ra̱ka̱ n acaka a̱ a̱ta̱li a na a̱ uta̱i a kashamkpatsu ka. ");
INSERT INTO asg_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ɗe a kashamkpatsu ka ɗa a yaꞋin atan a̱ na̱shi n iyoci ya̱ a̱pa̱lu a alumo nu mɓom koɓolo n uba̱zukpi u ni. ");
INSERT INTO asg_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Uɓomi u te wi ta̱ a kacaka ku ugiti ka na kuta̱i ɗe a kashamkpatsu ka̱ ma̱kuni ka, moɓom me ire mi ta̱ ɗaka vu kacaka ke ire, moɓom ma tatsu, mi ta̱ ɗaka vu kacaka ka tatsu, dem vu le acaka a̱ta̱li a ɗa. ");
INSERT INTO asg_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mɓom ma n acaka a, i ta̱ umatyangbani n kashamkpatsu ka na a yimai n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ɗa a yaꞋin nkuni n cindere n ikima̱tsu n ebelyu a̱ ni feu, n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kashamkpatsu ka na ka̱ ka̱na̱i nkuni ma n ucanuku wu ulinga u le, ɗa u yaꞋin le n azanariya koci ali n a̱miki a na a yawai kamangankupa n vu tawun. ");
INSERT INTO asg_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ɗa a yaꞋin katalikalyuka ko kusonku ki ili i ma̱gula̱ni m maɗanga me megele. Ugaɗi wu ngo n ni u yawa ta̱ udashi u te n kagimi, wanshi u ni kpamu udashi u te n kagimi, uɗa̱ngi u ni ubapi u tatsu n wanshi u ni ugaɗi derere ɗa i, ɗa u yaꞋin avana punu umatyangbani. ");
INSERT INTO asg_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A paɗara gaɗi n akambu a̱ ni dem koɓolo n vana a̱ ni n azanariya koci, ɗa u lapulai a̱ ka̱ga̱Ꞌin ku una̱ ka̱ ni a̱ ka̱ra̱ka̱i n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ɗa a yaꞋin nkawani n re ma azanariya adama a katalikalyuka a ɗaka vu ka̱ga̱Ꞌin, akambu e re dem a na a̱ ka̱na̱i nshikpu n na a ci ɗikaka katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ɗa a yaꞋin ashamkpatsu a nu nɗanga me megele ɗa a paɗarai n ɗa n azanariya. ");
INSERT INTO asg_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ɗa kpamu a yaꞋin maniꞋin me kerengu ma ciɗa, n ili ma̱gula̱ni, tsu na kayaꞋin ki ili ma̱gula̱ni u ci yaꞋan. ");
INSERT INTO asg_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ɗa a yaꞋin katalikalyuka o kusongu m maɗanga me megele, ugaɗi u ni u yawa ta̱ udashi u cindere n kagimi, wanshi u ni udashi u cindere n kagimi. Uɗa̱ngi u ni udashi u na̱shi n kagimi, wanshi n ugaɗi u katalikalyuka ka derere ɗa. ");
INSERT INTO asg_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ɗa a yaꞋin avana a ngo n na̱shi dem, adama na avana a n katalikalyuka ka okpo umatyangbani punu ubuta̱ u te, ɗa a paɗarai katalikalyuka n vuyum vi shili. ");
INSERT INTO asg_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A maꞋi mgbodo mi iyum adama a na a̱ tsungusu punu kokomo ka katalikalyuka ka, n sheburu, n a̱mbu, n aya a̱ njuvu, n a̱mbu a̱ kupura̱ka̱ a̱ga̱ruwa̱shi. Ucanuku wu ulinga u nampa a yaꞋan ta̱ u ɗa n vuyum vi shili. ");
INSERT INTO asg_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ɗa u yaꞋankai katalikalyuka ka kazatsu ka̱ viyum vi shili, ɗa a ukai kaꞋa e mere-mere. ");
INSERT INTO asg_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ɗa a ukai nkawani n na̱shi, a ngon n na̱shi n kazatsu ka na a yaꞋin n iyum i shili, o okpo tsa̱ a̱ka̱na̱tsu ashamkpatsu a. ");
INSERT INTO asg_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ɗa u yaꞋin a̱ka̱na̱tsu a, m maɗanga me megele. Ɗa u paɗarai le n vuyum vu shili. ");
INSERT INTO asg_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ɗa a ukai a̱ka̱na̱tsu a punu a nkawani n na mi a ka a akambu ka katalikalyuka ka. Katalikalyuka ka ki ta̱ n kungu, ku na a yaꞋankai ni. ");
INSERT INTO asg_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","U yaꞋin kasasu ka gbayin n kashamkpatsu n iyum i shili, m mindatsu ma na a̱ma̱ci a na a ci yaꞋan ulinga a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ɗa u kira̱i ulanga. N tsuɗaka, a kakashi ku usaki ka, a caꞋa ta̱ kaꞋa n tsugbere tsu singai tsu tsuzogu tsu arikinla, udashi amangatawun n amangerenkupa (150), ");
INSERT INTO asg_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","koɓolo kpamu n ashamkpatsu kamanga n anci kamanga o okpo a na a yaꞋin n iyum i shili, ama okoɓotsu a ashamkpatsu n awin a, o okpo a azurufa. ");
INSERT INTO asg_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Akashi a na a saki a uɓon u gaɗi wa, washin u le u yawa ta̱ amangatawun n amangerenkupa (150), ashamkpatsu kamanga e le, n anci kamanga, a yaꞋan ta̱ n iyum ishili, ama okoɓotsu n ashamkpatsu, n awin e le, a yaꞋan le ta̱ n azurufa. ");
INSERT INTO asg_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","N uteku u ka̱livi wanshi u ni u yawa ta̱ udashi amangatatsunkupa n u tawun, n nshikpu kupa n anci e le kupa. Ikoɓotsu a nshikpu ma, n awin e le, a yaꞋin a ɗa n azurufa. ");
INSERT INTO asg_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","N uɓon u kelime u kasana udashi amangatatsunkupa n u tawun. ");
INSERT INTO asg_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Akashi a̱ utsutsu a na a saki a kakambu ke te ku utsutsu ka, ugaɗi u ni udashi kamanga n u re n kagimi, koɓolo n ashamkpatsu a tatsu n anci a tatsu feu, ");
INSERT INTO asg_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ta kpamu nannai n kakambu ka nan ɗe. A saku ɗe akashi, a yaꞋan ugaɗi u na u yawai udashi kamanga n u re n kagimi, koɓolo n ashamkpatsu tatsu n anci a tatsu feu. ");
INSERT INTO asg_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Akashi a ulanga a ra̱ka̱ a yaꞋan ta̱ le n tsugbere tsu ucaꞋi tsu tsuzogu tsu arikinla. ");
INSERT INTO asg_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Anci a ashamkpatsu a, a yaꞋin le n iyum i shili. Ama ikoɓotsu, n ashamkpatsu, n awin a, a yaꞋan le ta̱ n azurufa, ɗa kpamu a paɗarai gaɗi va ashamkpatsu va n azurufa, ikoɓotsu n awin a, a yaꞋan le ta̱ n azurufa. ");
INSERT INTO asg_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ɗa u yaꞋin kakashi ku utsutsu ku ulanga ka, n ucaꞋi u tsugbere tsu singai, u mini mu usuni, m mini ma̱ ma̱ɗiya̱, m mini ma garula n tsugbere tsu ucaꞋi tsu singai tsu tsuzogu. Wanshi u ni u yawa ta̱ udashi kamangankupa, uɗa̱ngi u ni udashi u cindere n kagimi, derere n akashi a usaki a ulanga a, ");
INSERT INTO asg_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ashamkpatsu e le a̱ na̱shi a ɗa, n anci e le a̱ na̱shi a na a yaꞋin n iyum i shili, ikoɓotsu i le azurufa a ɗa, ikoɓotsu n awin a, a yaꞋin le ta̱ n azurufa. ");
INSERT INTO asg_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Aguta a̱ ma̱va̱li ma kuciɓa n Ka̱shile ma ra̱ka̱, koɓolo n aguta a ulanga a dem, a yaꞋan le ta̱ n iyum i shili. ");
INSERT INTO asg_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Nava ɗaɗa ucanuku u na a yaꞋankai ulinga u kumaꞋa ku Ma̱va̱li ma kuciɓa n Ka̱shile, mu uzuwakpani. Ubuta̱ u na a zuwai nshemberu ma atali n na mi n wila̱ kupa u na Musa u nekei aza e Levi kadanshi a̱ pura̱, n uyevi u Itama maku ma Haruna Ganu. ");
INSERT INTO asg_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezale maku ma̱ Uri vashi vu Huru a kumaci ku Yahuda u yaꞋin ili derere tsu na Vuzavaguɗu u danai Musa u yaꞋan, ");
INSERT INTO asg_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","koɓolo n Oholiyabu maku ma Ahisamaka a kumaci ku Dan, a̱yi keyevi kaꞋa ku ulinga u kuyaꞋan tsuzogu ce ekiye n igani, ka̱ta̱ u rumbuku m mini mu usuni, m ma na mo yotsoi mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, n tsugbere tsu arikinla tsu singai. ");
INSERT INTO asg_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Azanariya a na a̱ tuka̱i ra̱ka̱ adama alyuka a̱ kuɗa̱ngusa̱ a na a kuyaꞋanka ulinga u kumaꞋa Ma̱va̱li mo Oɓolo ma, a yawa ta̱ a̱miki a kagisamkpatsu amangatawunkuci n amanga̱na̱shinkupa n i cindere (997) n agisamkpatsu i na a ci yaꞋanka ulinga a̱ ubuta̱ u ma̱va̱li ma ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Zurfa a na a isai a̱ ubuta̱ u uma a na e kecei, a yawa ta̱ a a̱miki a kagisamkpatsu a̱kpa̱n a tatsu n amangatawa̱na̱shi n kamangankupa (3, 430), uteku tsu na a gisanki n kagisamkpatsu ku ubuta̱ u Ma̱va̱li ma ciɗa, ");
INSERT INTO asg_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","vuma lakam vu na e kecei, aza a na a̱ya̱ e le a yawai kamanga a kubana gaɗi, u tsupa ta̱ kagimi ka agisana ka azurufa, agisana a na i a kuyaꞋanka ulinga a̱ ubuta̱ u Ma̱va̱li mo Oɓolo. Uma a a yawa ta̱ a̱kpa̱n amangatawa̱nta̱li n a̱kpa̱n a tatsu n amangatawantawun n amangerenkupa (603, 550). ");
INSERT INTO asg_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","A yaꞋan ta̱ ulinga n kilo kamangankupa n vu na̱shi va azurufa, a̱ ubuta̱ u kumaꞋa ku anci amangatawun a̱ Ma̱va̱li mo Oɓolo, ɗa a yaꞋin kpamu ulinga n azurufa kamangankupa n a̱ na̱shi a kanci dem adama a kakashi ku utsutsu ka feu. ");
INSERT INTO asg_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A kilo kamangankupa va azurufa vu na vu buwai, vu ɗa a yaꞋankai ikoɓotsu n awin a na a paɗarakai gaɗi va ashamkpatsu va. ");
INSERT INTO asg_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","KuneꞋe ki iyum i shili i na uma a̱ tuka̱i, ku yawa ta̱ a̱miki a kagisamkpatsu a̱kpa̱n e re n amangatawa̱na̱shi n kamanga n tawun (2, 425). ");
INSERT INTO asg_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","A yaꞋankai ulinga n i ɗa, a yaꞋin anci a̱ utsutsu u Ma̱va̱li mo Oɓolo, n katalikalyuka kpamu n kazatsu ki iyum i shili, n ili yu ulinga i ni dem, ");
INSERT INTO asg_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ali n anci a na a̱ ka̱ra̱ka̱i ulanga u ma̱va̱li wa, n aza na i utsutsu, koɓolo n aguta ra̱ka̱ a̱ Ma̱va̱li ma kuciɓa n Ka̱shile ma, n aza na kpamu a̱ ka̱ra̱Ꞌi ulanga wa. ");
INSERT INTO asg_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","A̱ jilya̱i aminya a tsuganu a na a kuyaꞋanka ulinga a̱ Ma̱va̱li ma kuciɓa n Ka̱shile m mini mu usuni, m mini ma garula, koɓolo kpamu m mini ma̱ ma̱ɗiya̱. O doku a̱ jilya̱ka̱i feu Haruna aminya a ciɗa, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","A yaꞋin ka̱bun ka̱ kuka̱ɓa̱ngu ka tsuganu n kakashi ka̱ mini mu usuni, m mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, koɓolo n tsugbere tsu singai tsa akaɗa. ");
INSERT INTO asg_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","A yimai azanariya ɗa okpoi a̱bun-a̱bun, ɗa a kiɗasai a ɗa adama a na o ɓolongu n tsugbere tsu kucaꞋa tsu na ci an mini mu usuni, m mini ma garula, m mini ma̱ ma̱ɗiya̱, koɓolo n tsugbere tsu singai tsu tsuzogu, ulinga u keyevi. ");
INSERT INTO asg_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ɗa yaꞋankai ka̱bun ka̱ kuka̱ɓa̱ngu ka eleje avangatsu, ɗa a gasatamgbanai ngo n re n ni, adama a kushiya. ");
INSERT INTO asg_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kaɗambura ku ucaꞋi ko tsuzogu ki ta̱ u umatyangbani n ka̱bun ka, kana a yaꞋin n ci iyoci tsu ni, tsa a azanariya, m mini mu usuni, n tsu mini ma garula, koɓolo mini ma̱ ma̱ɗiya̱, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","A̱ la̱nsa̱i atali o onis e re ɗa a lapulai a ɗa, a ukai a ɗa a mashingi ma azanariya, ɗa a̱ ka̱ra̱i ɗe ula a̱ muku mi Isaraila a katali ka tsu na a tsu paɗa ka̱ta̱mba̱ri. ");
INSERT INTO asg_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ɗa a saɓangi le avangatsu a efodu a adama na okpo atali a kuciɓasa m muku ma a za Isaraila, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","A yaꞋin mabambata ma n ulinga u keyevi, n tso ogoni a efodu va azanariya, tsu mini mu usuni, m mini ma garula, m mini ma̱ ma̱ɗiya̱. Ali n tsugbere tsu ucaꞋi tsu singai tsu tsuzogu. ");
INSERT INTO asg_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Wi ta̱ nu ngon na̱shi. Ɗa a yaꞋin mabambata ma ugoshi ku re, ugaɗi uba̱rukpi u kataka ke kukiye, n washi kpamu uba̱rukpi u kataka ke kukiye, uka̱ta̱li ku re. ");
INSERT INTO asg_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ɗaɗa a darai ɗe atali a singai ali akariki a̱ na̱shi. A kakariki ka iyain, a darai ɗe kaneliya, n tofa, koɓolo n zumurudu, ");
INSERT INTO asg_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","a kakariki ke ire a darai ɗe kirisola, n safaya, n daimo, ");
INSERT INTO asg_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","a kakariki ka tatsu a darai ɗe yasin, n agat, n amati, ");
INSERT INTO asg_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","a kakariki ka̱ na̱shi a darai ɗe beril, n onis, n yasfa. A zuwai katali dem u uki m mashingi ma azanariya. ");
INSERT INTO asg_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Atali kupa n e re i ta̱ ɗe n ula e le, tsu ula a̱ muku mi Isaraila. Okpoi tsu uzuwi u kukiye, katali dem ki ta̱ uka̱ri n kula ku ni, adama a kumaci kupa n ku re ku uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ɗa a yaꞋin ɗe a mabambata n ikani yu ucaꞋi i tsu tsuzogu tsa awin, a na a yaꞋin n azanariya koci. ");
INSERT INTO asg_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ɗa a yaꞋin ɗe nkawani n re ma azanariya, ɗa o koɓoi ɗe nkawani n re ma a iga̱Ꞌin e re a mabambata a. ");
INSERT INTO asg_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ɗa a shiyai ɗe awin e re a azanariya, ɗe a nkawani ma̱ iga̱Ꞌin a mabambata ma. ");
INSERT INTO asg_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ɗa o koɓoi ɗe ugasatangbani u re wu uteku wu nkawani ma, n awin e re a. Ama ɗa o koɓoi le n tsu kelime a̱ ubuta̱ u te wa avangatsu a efodu a. ");
INSERT INTO asg_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ɗa a yaꞋin nkawani n re ma azanariya, ɗa o koɓoi le a uteku u re u mabambata ma, n asuvu ɗevu n efodu va. ");
INSERT INTO asg_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ɗa a yaꞋin nkawani n re ma azanariya, ɗa o koɓoi le kelime n tsu ɗaka tsa avangatsu a̱ ubuta̱ u efodu va. Ɗevu n uɓon ugaɗi u magasatai ma kaɗambura ko tsuzogu ka efodu va. ");
INSERT INTO asg_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ɗa a shiyai mabanbata ma nu nkawani n ni, ɗe a nkawani n efodu n kawin ka̱ mini mu usuni, adama a na wo okpo ulinga u keyevi ka kucaꞋa ka awin ka efodu, adama a na ka̱ta̱ mabambata ma ma̱ ta̱wa̱ ma̱ ba̱ɗa̱ a efodu va ba, uteku tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ɗa kpamu u yaꞋin motogu mu ucaꞋi mu ugaɗi ma efodu ma, m mini mu usuni ra̱ka̱, ");
INSERT INTO asg_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","kuɗeku ku motogu ka, ki ta̱ ucaꞋi n a̱guruzu uka̱ra̱ki adama a na u sa̱nka̱ kukara. ");
INSERT INTO asg_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Iga̱Ꞌin o motogu a, a yaꞋan ta̱ a ɗa n tsuzogu tsu umaci u maɗanga ma na e ci ɗeke ruman, n tsu mini m usuni, n tsu mini ma̱ ma̱ɗiya̱, n tsu mini magarula, n tsugbere tsu caꞋi u tsuzogu tsu singai. ");
INSERT INTO asg_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ɗa kpamu a yaꞋin alingi n azanariya koci, ɗa a ukai a ɗa ɗe iga̱Ꞌin o motogu ma a̱ kuka̱ra̱ka̱ ra̱ka̱. A̱ mere mu umaci ma ruman dem, a zuwa kalingi dem. ");
INSERT INTO asg_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kalingi n umaci u ruman a̱ kuka̱ra̱ ugupi u motogu ma tsuganu ma, uteku tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ɗa kpamu a yaꞋankai Haruna m muku n ni ntogu n kenkeꞋen mu ucaꞋi we ekiye n tsugbere tsu singai. ");
INSERT INTO asg_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","N oroli o tsuzogu a singai, n nkuꞋun n tsuzogu n singai, m motogu mu ucaꞋi ma asuvu ma singai. ");
INSERT INTO asg_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","A yaꞋin kaɗambura ku ucaꞋi u tsuzogu ce ekiye n tsugbere tsu singai, n tsugbere tsu mini ma̱ usuni, n tsu mini ma garula, n tsu mini ma̱ ma̱ɗiya̱, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ɗa a yaꞋin kebelyu ko oroli a ciɗa n azanariya koci, ɗa a̱ ka̱ra̱i ɗe iɗani, uteku tsu uka̱ri wu uzuwi u kukiye u ka̱ta̱mba̱ri tsu nampa, <<CIƊA U VUZAVAGUƊU.>> ");
INSERT INTO asg_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ɗa a shiyakai ɗe kawin ka na ki tsu mini mu usuni, adama a na ka shiya gaɗi vo oroli va, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ulinga u Ma̱va̱li ma kuciɓa n Ka̱shile m Ma̱va̱li mo Oɓolo ma yaꞋan ta̱ ukoci, Aza a Isaraila a yaꞋan ta̱ ili ra̱ka̱ derere tsu na Vuzavaguɗu u danai Musa, ta ta na a yaꞋin nannai. ");
INSERT INTO asg_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ɗa a̱ tuka̱i m Ma̱va̱li ma kuciɓa n Ka̱shile ma u Musa, m ma̱va̱li n ucanuku wu ulinga u ni ra̱ka̱, ikoɓotsu i ni, n urotu wu utsutsu, n alangu a̱ ni, n ashamkpatsu a̱ ni, koɓolo n anci a̱ ni, ");
INSERT INTO asg_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","n ipalatsu yu ukpan u ka̱giri n ukpan wu nraɗika, n kakashi ka kupalaka, ");
INSERT INTO asg_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","n akpati vu wila̱ n alangu a̱ ni, n ka̱kuya̱mkpa̱tsu ka kutakpa unushi, ");
INSERT INTO asg_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","kirukpa n ucanuku wu ulinga u ni, m boroji vu ciɗa, ");
INSERT INTO asg_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kashamkpatsu ka̱ nkuni ka azanariya koci, nu nkuni n ni ɗe udari, n ucanuku wu ulinga u ni ra̱ka̱ n ka̱la̱nji adama a kutashi, ");
INSERT INTO asg_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","katalikalyuka ka azanariya, m maniꞋin me kerengu, n ili i ma̱gula̱ni i wali, n kakashi ku utsutsu u ma̱va̱li ma, ");
INSERT INTO asg_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","katalikalyuka ki iyum i shili, n ubuta̱ u kazatsu u ni, n alangu a̱ ni, koɓolo n ucanuku wu ulinga u ni ra̱ka̱, n kapara n kanci ka̱ ni, ");
INSERT INTO asg_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","kakashi ku utsutsu ku ulanga u Ma̱va̱li ma, ashamkpatsu a̱ ni, koɓolo n anci e le, n kakashi ku utsutsu ku ulanga u Ma̱va̱li wa, awin a̱ ni koɓolo n aguta a̱ ni, n ucanuku wu ulinga u Ma̱va̱li ma kuciɓa n Ka̱shile, m Ma̱va̱li mo Oɓolo, ");
INSERT INTO asg_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ntogu mu ucaꞋi n kuꞋuka a̱ ubuta̱ wu ulinga wu ubuta̱ u ciɗa, ntogu n ciɗa n tsuganu n Haruna nu ntogu n tsuganu mu muku n ni, a̱ ubuta̱ wu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ɗa aza a Isaraila a yaꞋin ili ya nannai ra̱ka̱ uteku tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa u la̱na̱i ulinga wa ra̱ka̱, ɗa we enei a yaꞋan ta̱ u ɗa derere tsu na Vuzavaguɗu u danai. Ɗaɗa Musa u zuwakai le una̱singai. ");
INSERT INTO asg_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","<<A kanna ka iyain ko wotoi u iyain ka̱ta̱ vu shikpa̱ Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ka̱ta̱ vu zuwa punu akpati vu wila̱, ka̱ta̱ vu keɗe akpati va n akashi. ");
INSERT INTO asg_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ka̱ta̱ vu uka kirukpa ka asuvu, vu dara ɗe ucanuku u ni, ka̱ta̱ kpamu vu uka n kashamkpatsu ka̱ ma̱kuni ka, vu dara ɗe nkuni ma. ");
INSERT INTO asg_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ka̱ta̱ vu shikpa̱ katalikalyuka ka azanariya ki ili i ma̱gula̱ni, e kelime ka akpati vu wila̱ va, vu shiya kakashi ku utsutsu u Ma̱va̱li ma kuciɓa n Ka̱shile ma. ");
INSERT INTO asg_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ka̱ta̱ vu shikpa̱ katalikalyuka o kusongu, e kelime ku utsutsu u Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Vu zuwa kasasu e mere ma̱ Ma̱va̱li mo Oɓolo n katalikalyuka ka, ka̱ta̱ vu tsungu punu mini. ");
INSERT INTO asg_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ka̱ta̱ vu shikpa̱ vu ka̱ra̱ka̱ ulanga wa, vu shiya ɗe kakashi ku utsutsu u kuꞋuwa ulanga wa. ");
INSERT INTO asg_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","<<Ka̱ta̱ vu ɗika maniꞋin me kerengu, ka̱ta̱ vu ɗarakpaka ma̱va̱li ma kuciɓa n Ka̱shile ma n ili i na yi punu ra̱ka̱, ka̱ta̱ ve erengu ucanuku wa ra̱ka̱, adama na wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ka̱ta̱ kpamu vu ɗarakpaka katalikalyuka o kusongu, koɓolo n ucanuku wu ulinga u ni ra̱ka̱, ka̱ta̱ ve erengu katalikalyuka, adama a na katalikalyuka ka kokpo ciɗa ka̱u. ");
INSERT INTO asg_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ka̱ta̱ kpamu vu ɗarakpaka kasasu ka n kashamkpatsu ka̱ ni, ka̱ta̱ ve erengu le. ");
INSERT INTO asg_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","<<Ka̱ta̱ vu tuka̱ n Haruna koɓolo m muku a̱ utsutsu u Ma̱va̱li mo Oɓolo ma, ka̱ta̱ vu sumba̱ le m mini. ");
INSERT INTO asg_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ka̱ta̱ i uka Haruna ntogu n ciɗa, vu putalaka yi maniꞋin ka̱ta̱ ve erengu yi, adama a na u yaꞋanka mu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ka̱ta̱ vu tuka̱ m muku n ni vu uka le ntogu n wawaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ka̱ta̱ vu putalaka le m maniꞋin a kaci, tsu na i yaꞋankai esheku e le, adama a na a yaꞋanka mu ulinga u tsuganu. Kerengu ku na a yaꞋankai le va, kubonoko le ta̱ anan ganu, ali ntsukaya le n na ma̱ kuta̱wa̱.>> ");
INSERT INTO asg_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ɗa Musa u yaꞋin ili i nampa derere tsu na Vuzavaguɗu u danai ni. ");
INSERT INTO asg_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","O wotoi u iyain u ka̱ya̱ ka̱ i re, a kanna ka iyain ko wotoi ka, ɗa a̱ shikpa̱i Ma̱va̱li ma kuciɓa n Ka̱shile ma. ");
INSERT INTO asg_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ɗa Musa u shikpa̱i Ma̱va̱li. Ɗa u zuwai ɗe anci a̱ ni, ɗa u yaꞋin urotu wu utsutsu, ɗa u ukai alangu a̱ ni, ɗa kpamu u ɗengusa̱i ashamkpatsu a̱ ni. ");
INSERT INTO asg_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ɗa u ba̱rukpa̱i ɗe kakashi ka kupalaka ka a gaɗi vu ma̱va̱li ma kuciɓa n Ka̱shile, ɗa u doku u ba̱rukpa̱i ɗe kapalatsu ka kakashi ka gaɗi, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ɗa u ɗikai nshemberu m atali n wila̱ ma, ɗa u zuwai le punu asuvu a akpati va, ɗa u zuwai alangu ɗe a akpati va, ɗa u zuwai ka̱kuya̱mkpa̱tsu ka kutakpa unushi gaɗi va akpati va. ");
INSERT INTO asg_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ɗa u ukai akpati va a asuvu a̱ Ma̱va̱li ma kuciɓa n Ka̱shile, ɗa u saki kakashi ku utsutsu ka, ɗa ke keɗei Akpati vu Uzuwakpani va, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ɗa u ukai kirukpa ka punu a̱ Ma̱va̱li mo Oɓolo ma, a uɓon u gaɗi u Ma̱va̱li ma kuciɓa n Ka̱shile ma, n tsu pulai tsu kakashi ku utsutsu ka, ");
INSERT INTO asg_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ɗa u darai ɗe boroji, e kelime ka Vuzavaguɗu, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ɗa u zuwai kashamkpatsu ka̱ ma̱kuni, punu asuvu a̱ Ma̱va̱li mo Oɓolo ma, a upashi u kirukpa wa n uɓon u ɗaka, a mindansanai m Ma̱va̱li ma kuciɓa n Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ɗa u zuwai ɗe nkuni ma a kashamkpatsu ka, e kelime ka Vuzavaguɗu, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ɗa a ukai katalikalyuka ka azanariya punu asuvu a̱ Ma̱va̱li mo Oɓolo ma, e kelime ka kakashi ka. ");
INSERT INTO asg_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","U songi ili i ma̱gula̱ni i wali ɗe gaɗi vu ni, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ɗa u saki kakashi ku utsutsu u ma̱va̱li ma Vuzavaguɗu ma. ");
INSERT INTO asg_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ɗa u shikpa̱i katalikalyuka ko kusongu, ɗe a̱ utsutsu u Ma̱va̱li ma kuciɓa n Ka̱shile m Ma̱va̱li mo Oɓolo ma, ɗa u lyukai ɗe alyuka o kusongu koɓolo n alyuka a ili kashina, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ɗa u zuwai kasasu e mere ma̱ Ma̱va̱li mo Oɓolo ma, n katalikalyuka ka, ɗa u tsungi punu mini adama a kusaꞋasa, ");
INSERT INTO asg_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ka na Musa n Haruna koɓolon m muku n ni, a kusaꞋasa ekiye n ene e le. ");
INSERT INTO asg_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ayin a na baci a uwai asuvu a̱ Ma̱va̱li mo Oɓolo ma, ɗa baci a yawai ɗevu n katalikalyuka ka, ka̱ta̱ saꞋasa, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ɗa u kira̱i ulanga u Ma̱va̱li ma kuciɓa n Ka̱shile ma, n katalikalyuka ka, ɗa u saki kakashi ku utsutsu u kuꞋuwa ulanga wa. Ta Musa u kotsoi ulinga wa nannai. ");
INSERT INTO asg_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ɗaɗa keleshu ka palai Ma̱va̱li mo Oɓolo ma, ɗa tsugbayin tsu Vuzavaguɗu ci shanai punu a̱ Ma̱va̱li ma kuciɓa n Ka̱shile ma. ");
INSERT INTO asg_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ama Musa u fuɗa u uwa a̱ Ma̱va̱li mo Oɓolo ma ba, adama a na keleshu ka pala ta̱ maꞋa, ɗa kpamu tsugbayin tsu Vuzavaguɗu ci shanai punu a̱ Ma̱va̱li ma kuciɓa n Ka̱shile ma. ");
INSERT INTO asg_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","A̱ ka̱tsuma̱ ka nwalu n le ra̱ka̱, a ayin a na baci dem e enei keleshu ka ke sheruwengi a kulaza Ma̱va̱li ma kuciɓa n Ka̱shile ma, ka̱ta̱ aza a Isaraila o tono kaꞋa. ");
INSERT INTO asg_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ama keleshu ka ke sheruwengu baci ba, i a kubana ubuta̱ ba, sai kanna ka na ka lazai. ");
INSERT INTO asg_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Adama a na keleshu ka Vuzavaguɗu ko ci yongo ta̱ gaɗi vu Ma̱va̱li ma kuciɓa n Ka̱shile ma n kanna, n kayin kpamu ka̱ta̱ kaꞋa ko yongo n akina, adama na kpaꞋa ka aza a Isaraila ra̱ka̱ kuciya̱ kene keleshu ka, a̱ ka̱tsuma̱ ka nwalu n le.");
INSERT INTO asg_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Vuzavaguɗu u ɗekei Musa ɗa u yaꞋin kadanshi n a̱yi a̱ Ma̱va̱li mo Oɓolo, ɗa u danai, ");
INSERT INTO asg_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","YaꞋan kadanshi n aza a Isaraila ka̱ta̱ vu dana le, yaba dem vu ɗa̱ vu na baci u kutuka̱ n kuneꞋe u Vuzavaguɗu, sai u tuka̱ n kuneꞋe ku ni ki ilikuzuwa adama a alyuka o kusongu a̱ ubuta̱ wu ushiga wa anaka ko wu nkyon ko wu nraɗika. ");
INSERT INTO asg_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","<<KuneꞋe ku ni adama a alyuka o kusongu ta punu baci wu utuka̱i ku ɗa a ushiga, ka̱ta̱ ku yaꞋan ka̱na̱ku ba, wo okpo n uꞋiwin u Ka̱shile ba. Wi ta̱ a̱ kutuka̱ n ku ɗa a̱ utsutsu u Ma̱va̱li mo Oɓolo adama a na u ciya̱ wishi a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Vuza kuneꞋe va wi ta̱ a kukiyangu kukiye ku ni a kaci ka alyuka o kusongu a, Vuzavaguɗu wi ta̱ a kisa ukpa̱ u manama wa wo okpo una̱ u ni, tsu kutakpa ku unushi u ni. ");
INSERT INTO asg_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Wi ta̱ a kukiɗa kabomburo ka a̱ ubuta̱ u Vuzavaguɗu, ka̱ta̱ anan ganu muku n Haruna a̱ tuka̱ nu mpasa ma. Adama a na a vishangu n ɗa a akambu dem a katalikalyuka a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Wi ta̱ a kuminya manama ma alyuka o kusongu a, ka̱ta̱ u kiɗasa maꞋa akiɗi-akiɗi. ");
INSERT INTO asg_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ka̱ta̱ muku n Haruna ganu a dyaɓa akina a katalikalyuka, ka̱ta̱ a gbatyangu nɗanga gaɗi va akina va. ");
INSERT INTO asg_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ka̱ta̱ anan ganu muku n Haruna a rece akiɗi a, koɓolo n kaci n ushuma a gaɗi vu nɗanga n na mi a̱ kukula̱ a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Wi ta̱ a̱ kuza̱Ꞌa̱ ili i ka̱tsuma̱ n ene dem m mini, ka̱ta̱ a̱ ka̱tsuma̱ ka anan ganu ka vuza yoku u songu i ɗa ra̱ka̱ a katalikalyuka. Ɗaɗa alyuka o kusongu, alyuka a na o songi n akina, m ma̱gula̱ni ma singai ma na Vuzavaguɗu u kupana uyo. ");
INSERT INTO asg_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","<<KuneꞋe ku kusongu ku ni ta punu baci u ɗikai a ushiga, ko nkyon ko nraɗika, ma yaꞋan ma̱giri ko ma̱ga̱ji ma na mi n uꞋiwin u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Wi ta̱ a kukiɗa maꞋa a uɓon u gaɗi u katalikalyuka a̱ ubuta̱ u Vuzavaguɗu, ka̱ta̱ anan ganu muku n Haruna a vishangu mpasa ma a̱ ka̱ra̱ka̱ akambu dem a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ka̱ta̱ u kiɗa maꞋa akiɗi-akiɗi, ka̱ta̱ anan ganu e rece a ɗa ali n kaci n ushuma dem, ɗe a gaɗi vu nɗanga n na a gbatyangi ɗa mi a̱ kukula̱ a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Wi ta̱ a̱ kuza̱Ꞌa̱ ili i ka̱tsuma̱ n ene dem m mini, ka̱ta̱ ganu u songu i ɗa ra̱ka̱ a katalikalyuka. Ɗaɗa alyuka o kusongu, alyuka a na o songi n akina, m ma̱gula̱ni ma singai ma na Vuzavaguɗu u kupana uyo. ");
INSERT INTO asg_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","<<KuneꞋe ku ni u Vuzavaguɗu kuneꞋe ku kusongu ku nnu ku ɗa baci, u yaꞋan ku ɗa m moɗoi ko muku mu ntapambara. ");
INSERT INTO asg_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ganu wi ta̱ a̱ kutuka̱ maꞋa a̱ ubuta̱ u katalikalyuka, ka̱ta̱ u pinda̱ra̱ ali u taɓa maꞋa kaci ka̱ta̱ u songu kaꞋa a katalikalyuka. Ka̱ta̱ u zaza mpasa ma a kakambu ka katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Wu utuka̱ n kobiyo ka n ashin a̱ ni ka̱ta̱ u taɗuku le a uɓon u kasana u katalikalyuka a̱ ubuta̱ u na a̱ tsu va̱ma̱ kokomo. ");
INSERT INTO asg_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Wi ta̱ a̱ kuka̱na̱ maꞋa e evelyu ka̱ta̱ u kara maꞋa, ama akari-akari ba. Ka̱ta̱ ganu u songu maꞋa ɗe a katalikalyuka gaɗi vu nɗanga n na mi ugbatyangi a akina. Alyuka o kusongu a ɗa, kuneꞋe ka akina, ku ma̱gula̱ni ma singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","<<Ayin a na baci vuza u tuka̱i n kuneꞋe ki ishina u Vuzavaguɗu, kuneꞋe ku ni ko okpo kuneꞋe ku kiya ku singai. U tsungu ku ɗa maniꞋin koɓolo n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ka̱ta̱ u banka ku ɗa a̱ ubuta̱ u anan ganu muku n Haruna. Ka̱ta̱ u kenuku kiya ku singai ku singai ku na ki usatari m maniꞋin koɓolo n ili i ma̱gula̱ni ya ka̱kun ku te, ka̱ta̱ u songu na va wo okpo ili i kuciɓasa a katalikalyuka. Alyuka a na a yaꞋin n akina, a na Vuzavaguɗu wi a kupana uyo u ma̱gula̱ni ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Alyuka a ishina i na i buwai i ta̱ o kokpo a Haruna koɓolo m muku n ali n ni. Ɗaɗa alyuka a na a laꞋi n ciɗa dem, a na a yaꞋin n akina ɗa e nekei Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","<<Vuza u tuka̱ baci n kuneꞋe ki ishina, i na a̱ zungi n akina, i ɗa i yaꞋan a kiya ku singai. U tuka̱ m boroji vu na a yaꞋin n kiya ku na a satarai m maniꞋin babu yisiti. Ko emeshe a na i babu yisiti. ");
INSERT INTO asg_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","KuneꞋe ku nu ki ishina i ɗa baci ku na a kangalai e kebelyu, a yaꞋan ku ɗa n kiya ku singai usatari m maniꞋin ama babu yisiti. ");
INSERT INTO asg_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Vi ta̱ o kukoɗoso a ɗa ka̱ta̱ vu tsungu maniꞋin, ɗaɗa kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","KuneꞋe ki ishina i nu ki baci ukangali e kebelyu, a yaꞋan ku ɗa n kiya ku singai m maniꞋin. ");
INSERT INTO asg_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tuka̱ n kuneꞋe ki ishina i na a yaꞋin n ili i nampa ya a̱ ubuta̱ u Vuzavaguɗu. Vi neke ganu vuza na u kuɗika wa banka a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ka̱ta̱ ganu u ɗika punu ugboku u kuciɓasa u kuneꞋe ki ishina ka̱ta̱ u songu i ɗa a katalikalyuka, kuneꞋe ki ilikulya ku ma̱gula̱ni ma singai a kubana u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ama kagimi ke kuneꞋe ki ishina ki ta̱ o kokpo ka Haruna m muku n ali n ni. Ɗaɗa alyuka a na a laꞋi n ciɗa dem, a na a yaꞋin n akina ɗa e nekei Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","<<KuneꞋe ki ishina ku na vu tuka̱i u Vuzavaguɗu dem ku ɗa ku yaꞋan babu yisiti, adama a na o tsu songu yisiti ko maniꞋin mi ishigi me kuneꞋe u Vuzavaguɗu ba. ");
INSERT INTO asg_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Yi ta̱ a kufuɗa ya̱ tuka̱ Vuzavaguɗu kuneꞋe ki ishina i na i gita̱i kugeꞋwe, ama e kuneke a ɗa a katalikalyuka ci ili i ma̱gula̱ni ma singai ba. ");
INSERT INTO asg_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","I tsungu mkpaɗi punu e kuneꞋe ki ishina dem adama a na mkpaɗi mi ta̱ tsu una̱ wu uzuwakpani n Ka̱shile n a̱ɗa̱. I tsungu kuneꞋe ku ɗa̱ gbende mkpaɗi. ");
INSERT INTO asg_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","<<Yi baci a kuyaꞋan kuneꞋe a kubana u Vuzavaguɗu n ili i kashina i na i gita̱i kugeꞋwe, yi ta̱ e kuneke kuneꞋe ki ishina i na i gita̱i kugeꞋwe, i na a zatsuki ɗa a iyai. ");
INSERT INTO asg_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Vu tsungu maniꞋin n ili i ma̱gula̱ni, adama a na kuneꞋe ki ishina i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ka̱ta̱ ganu u songu tsu ugboku u kuciɓasa u kiya ku savu, ki ili i kashina ku yoku koɓolo m maniꞋin mo yoku n ili i ma̱gula̱ni dem. KuneꞋe ki ishina ku ɗa u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","<<Vuza wi baci a kuyaꞋan kuneꞋe ku ma̱ta̱na̱, u yaꞋan kuneꞋe ka m manama ma na mi kogono ko mashan punu a ushiga u ni, u neke Vuzavaguɗu kuneꞋe ka m manama ma na mi babu uꞋiwin u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ka̱ta̱ u kiyangu kukiye ku ni a kaci ka manama me kuneꞋe ma̱ ni ma, ka̱ta̱ u kiɗa maꞋa a̱ utsutsu u Ma̱va̱li mo Oɓolo. Anan ganu muku n Haruna i ta̱ a kuvishangu mpasa ma a katalikalyuka a akambu dem. ");
INSERT INTO asg_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","A̱ ka̱tsuma̱ ka alyuka e kuneꞋe ku ma̱ta̱na̱ ka, ili i na ganu u kuneke alyuka a na o songi n akina a ɗa na. Ushuma u na u palai ili i ka̱tsuma̱ n u na ili i ka̱tsuma̱ i palai feu, ");
INSERT INTO asg_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","koɓolo m muku n ka̱tsuma̱ n re n ushuma u le dem, n uɓon wa asuvu dem. Na va ra̱ka̱ i ta̱ a̱ kuta̱ka̱ le. ");
INSERT INTO asg_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Muku n Haruna mi ta̱ o kusongu le zuva a katalikalyuka a gaɗi vu kuneꞋe ku kusongu, a na i ɗe zuva vu nɗanga n na mi ɗe akina. Na va kuneꞋe ku ɗa ku na a yaꞋin n akina ku singai, ku ma̱gula̱ni u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","<<Vi yaꞋan baci kuneꞋe ku ma̱ta̱na̱ m manama ma na vu uta̱ka̱i a ushiga tsu kuneꞋe u Vuzavaguɗu, vi ta̱ e kuneke ka̱giri ko mashan, ma na mi babu uꞋiwin u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Vi baci e kuneke ma̱giri adama e kuneꞋe ku nu, vi neke maꞋa u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Vi ta̱ a kukiyangu kukiye ku nu gaɗi vu kaci ka manama me kuneꞋe ku nu, ka̱ta̱ vu kiɗa maꞋa e kelime ka̱ Ma̱va̱li mo Oɓolo. Ka̱ta̱ muku mo olobo n Haruna n vishangu mpasa ma a akambu a katalikalyuka dem. ");
INSERT INTO asg_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","A̱ ka̱tsuma̱ ke kuneꞋe ku ma̱ta̱na̱, ka̱ta̱ u neke a ɗa a̱ ubuta̱ u Vuzavaguɗu tsu kuneꞋe ki ilikulya. Ili i na u kuneke i ɗaɗa na: ushuma u ni, n ushuma wu uɓon u kagun u na a gbatyai ɗevu n ketele ko kokondo, n ili i ka̱tsuma̱, n ushuma u na wi a uɓon wi ili i ka̱tsuma̱ dem, ");
INSERT INTO asg_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Koɓolo m muku n ka̱tsuma̱ n re n ushuma u le dem, ɗevu n uɓon wa asuvu. Na va ra̱ka̱ i ta̱ a̱ kuta̱ka̱ le. ");
INSERT INTO asg_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ka̱ta̱ ganu u songu le a katalikalyuka tsu kuneꞋe ki ilikulya i na o songi u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","<<KuneꞋe ku nu m maraɗika ma baci, vu tuka̱ m maꞋa a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Vi ta̱ a kukiyangu kukiye ku nu gaɗi vu kaci ka manama me kuneꞋe ku nu, ka̱ta̱ vu kiɗa maꞋa e kelime ka̱ Ma̱va̱li mo Oɓolo ma. Ka̱ta̱ muku n Haruna n vishangu mpasa ma a akambu a katalikalyuka dem. ");
INSERT INTO asg_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Punu a̱ ka̱tsuma̱ ki na vi nekei va, i na ve kuneke kuneꞋe ki ilikulya u Vuzavaguɗu i ɗa na: ushuma u na u palai ili i ka̱tsuma̱ n ushuma u na wi uɓon wi ili i ka̱tsuma̱ dem, ");
INSERT INTO asg_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","koɓolo m muku n ka̱tsuma̱ n re n ushuma u le dem, koɓolo n uɓon wa asuvu dem. Na va ra̱ka̱ i ta̱ a̱ kuta̱ka̱ le. ");
INSERT INTO asg_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ka̱ta̱ ganu u songu le a gaɗi vu katalikalyuka, uteku tsu kuneꞋe ki ilikulya. KuneꞋe ku ɗa ku na a yaꞋin n akina i ma̱gula̱ni i singai u Vuzavaguɗu. Ushuma dem u Vuzavaguɗu u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Na va wi ta̱ o kokpo wila̱ u ko wannai ali a kubana wu ntsukaya n na n kuta̱wa̱ a̱ ubuta̱ u na yi dem, yi baci de n wuma, i takuma mpasa ko n ushuma ba.>> ");
INSERT INTO asg_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","<<Dana aza a Isaraila, vuza u yaꞋan baci unushi n ucikali u ni ba, u yaꞋin i na Vuzavaguɗu u sa̱nka̱i le a̱ ka̱tsuma̱ ka̱ wila̱ u ni, ");
INSERT INTO asg_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ganu vu gbayin ɗa baci u yaꞋin unushi, unushi u ni wa wi ta̱ o kuronoko uma unushi, mayun ɗa u yaꞋan kuneꞋe adama a̱ unushi a kubana u Vuzavaguɗu n kobomburon ka na ki babu usa̱n, adama a̱ unushi u na u yaꞋin va. ");
INSERT INTO asg_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U tuka̱ n kobomburon ka a̱ utsutsu u Ma̱va̱li mo Oɓolo u Vuzavaguɗu, ka̱ta̱ u zuwa kukiye ku ni a gaɗi vu kaci ko kobomburon ka, ka̱ta̱ u kiɗa kaꞋa u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ka̱ta̱ ganu vu gbayin u kenuku mpasa n kobomburon ma, ka̱ta̱ u uka n ɗa a̱ Ma̱va̱li ma. ");
INSERT INTO asg_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Wi ta̱ a kudyaɓa mpasa ma n ka̱jivu, ka̱ta̱ u vishangu n ɗa kucindere e kelime ka kakashi ko Mololo ma na ma laꞋi n Ciɗa a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ganu wi ta̱ a̱ kutsungu mpasa n yoku a avana a na i gaɗi vu katalikalyuka ka na o tsu songu ili i ma̱gula̱ni i singai, ka na ki a̱ ubuta̱ u Vuzavaguɗu a̱ Ma̱va̱li mo Oɓolo. Mpasa n na m buwai wi ta̱ a̱ kutsungu n ɗa a̱ kumi ku katalikalyuka ke kuneꞋe ku kusongu lo a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Wi ta̱ a kutakpa ushuma u na wi punu dem o kobomburon ka na u kuyaꞋanka kuneꞋe ku unushi ka, koɓolo n ushuma ra̱ka̱ u na u palai ili i ka̱tsuma̱ ya n u na ili i ka̱tsuma̱ ya i palai, ");
INSERT INTO asg_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","koɓolo m muku n ka̱tsuma̱ n re n ushuma u le dem, ɗevu n uɓon wa asuvu. Na va ra̱ka̱ i ta̱ a̱ kuta̱ka̱ le. ");
INSERT INTO asg_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ganu va wi ta̱ kutakpa ushuma u kobomburon wa uteku u na u takpai a̱ ubuta̱ wa alyuka a̱ ma̱ta̱na̱ a. Ka̱ta̱ ganu u songu le dem a katalikalyuka ko kusongu ili i kuneꞋe. ");
INSERT INTO asg_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ama ukpan, n inyama, n ene, n kaci, n ciꞋin n a̱wiya̱n a̱ ni dem, ");
INSERT INTO asg_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ɗaɗa kagimi ka na ka buwai ko kobomburon ka, u ɗika wu uta̱ka̱ pulai a kubanka a̱ ubuta̱ u na a raɗai ciɗa, a̱ ubuta̱ u ka̱kiza̱ ko kokomo. Ta ɗe o kusongu inyama i na i buwai va a̱ ka̱kiza̱ ka ɗe n akina o ogboli. ");
INSERT INTO asg_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","<<Aza a Isaraila ra̱ka̱ ɗa baci a yaꞋin unushi u na wi n ucikali u le ba, a yaꞋin i na Vuzavaguɗu u sa̱nka̱i le a̱ ka̱tsuma̱ ka̱ wila̱ u ni, ko a na wo okpoi e yeve n unushi wa ba, a nusa ta̱. ");
INSERT INTO asg_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","A̱ ta̱wa̱ baci e yeve unushi u na a yaꞋin, uteku u na i ka̱tsura̱ ke le a̱ tuka̱ m mobomburon ma na a̱ utuka̱i a ushiga adama e kuneꞋe ku kushika̱ unushi, ka̱ta̱ a banka m maꞋa a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Nkoshi m gba̱ra̱-gba̱ra̱ n likuci ma, a kiyangu ekiye e le a kaci ko kobomburon ka ka̱ta̱ a kiɗa kaꞋa e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ganu vu gbayin, wi ta̱ e kukenuku mpasa n yoku n kobomburon ma ka̱ta̱ u uka n ɗa a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Wi ta̱ a kudyaɓa n ka̱jivu ka̱ ni punu a mpasa ma, ka̱ta̱ u vishangu n ɗa ali kucindere e kelime ka kakashi ku utsutsu ka u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ka̱ta̱ u ɗarukpa mpasa n yoku zuva va avana a na i gaɗi vu katalikalyuka a̱ ubuta̱ u Vuzavaguɗu a̱ Ma̱va̱li ma. Mpasa n na m buwai wi ta̱ a̱ kuva̱ma̱ n ɗa a̱ kumiꞋi ku katalikalyuka ko kusongu ili i kuneꞋe a̱ utsutsu u Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Wi ta̱ a kutakpa ushuma wa dem, ka̱ta̱ u songu u ɗa a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ta wa kuyaꞋan n kobomburon ka nannai, uteku tsu na u yaꞋin n kobomburon ke kuneꞋe ku kutakpa ku unushi. Nannai ɗa ganu u kutakpaka le unushi u le, ka̱ta̱ a cinukpaka le n u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ka̱ta̱ u ɗika kobomburon ka wu uta̱ka̱ a pulai vu ka̱tsura̱ ka̱ta̱ u songu uteku tsu na u songi kobomburon ka iyain ka. Na va kuneꞋe ka adama a̱ unushi ku ɗa adama a uma dem. ");
INSERT INTO asg_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","<<Vuza kelime u nusa baci babu ucikali u ni, ali ɗa u yaꞋin ili i gbani-gbani i te a̱ ka̱tsuma̱ ki ili i na Ka̱shila̱ Vuzavaguɗu u sa̱nka̱i, mayun u nusa ta̱. ");
INSERT INTO asg_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ayin a na baci u zukai n unushi u ni, u tuka̱ n kuneꞋe ku ma̱ga̱ji ma na mi babu uꞋiwin u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Wi ta̱ a kukiyangu kukiye ku ni zuva a kaci ka̱ ma̱ga̱ji ka, ka̱ta̱ u kiɗa maꞋa a̱ ubuta̱ u na o tsu songu kuneꞋe ku kusongu a̱ ubuta̱ u Vuzavaguɗu. Na va kuneꞋe ka adama a̱ unushi ku ɗa. ");
INSERT INTO asg_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ganu wi ta̱ a kudyaɓa mpasa n kuneꞋe ka adama a̱ unushi ka n ka̱jivu, ka̱ta̱ u vishangu n ɗa ɗe zuva a avana a katalikalyuka ko kusongu kuneꞋe. Ka̱ta̱ u va̱ma̱ mpasa n na m buwai ɗe a̱ kumiꞋi ku katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","U songu ushuma dem a katalikalyuka, tsu na u songi u nan ɗe a̱ ubuta̱ wa alyuka a̱ ma̱ta̱na̱. Nannai ɗa ganu u kutakpa yi unushi, ka̱ta̱ ta na a cinukpaka yi n u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","<<Ɗa baci vuza te a̱ ka̱tsuma̱ ka̱ ɗa̱ u nusai babu na u cikalai, ɗa u yaꞋin ili i te a̱ ka̱tsuma̱ ka̱ wila̱ i na Vuzavaguɗu u sa̱nka̱i, mayun u nusa ta̱. ");
INSERT INTO asg_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ɗa baci u ta̱wa̱i u zukai n unushi u ni, u tuka̱ n ka̱na̱ku ka maraɗika ma na mi babu uꞋiwin u Ka̱shile tsu kuneꞋe adama a̱ unushi u na u yaꞋin. ");
INSERT INTO asg_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","U kiyangu kukiye ku ni zuva vu kuneꞋe ka adama a̱ unushi wa, ka̱ta̱ u kiɗa maꞋa a̱ ubuta̱ u na o tsu songu kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ganu wi ta̱ kudyaɓa mpasa a̱ ka̱jivu ka̱ ni ka̱ta̱ u vishangu ɗe a avana a katalikalyuka ko kusongu ili i kuneꞋe, ka̱ta̱ u va̱ma̱ mpasa n na m buwai ɗe a̱ kumiꞋi ku katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Wi ta̱ a kutakpa ushuma wa ra̱ka̱, tsu na u takpai ushuma u na u yaꞋankai kuneꞋe ku ma̱ta̱na̱ ka, ka̱ta̱ ganu u songu ku ɗa a katalikalyuka ci ili i ma̱gula̱ni i singai u Vuzavaguɗu. Nannai ɗa ganu u kutakpaka yi unushi u ni, ka̱ta̱ a cinukpaka yi n u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","<<U tuka̱ baci m mokyon adama e kuneꞋe ku unushi u ni, ka̱ta̱ ma yaꞋan mashan ma na mi babu uꞋiwin u Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Wi ta̱ a kukiyangu kukiye ku ni zuva a kaci, ka̱ta̱ u kiɗa maꞋa adama e kuneꞋe ku unushi, a̱ ubuta̱ u na a tsu kiɗa nlala n kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ganu wi ta̱ a kudyaɓa mpasa ma n ka̱jivu ka̱ta̱ u vishangu n ɗa avana a katalikalyuka ko kusonku kuneꞋe ka, ka̱ta̱ mpasa n na m buwai u va̱ma̱ n ɗa a̱ kumiꞋi ku katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","U takpa ushuma wa dem, tsu na u yaꞋin m malala ma alyuka e kuneꞋe ku ma̱ta̱na̱, ka̱ta̱ ganu u songu maꞋa a katalikalyuka, a gaɗi vu kuneꞋe ki ilikulya i Vuzavaguɗu. Nannai ɗa ganu u kutakpaka yi unushi adama a̱ unushi u na u yaꞋin, ka̱ta̱ a cinukpaka yi n unushi u ni. ");
INSERT INTO asg_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","<<Vuza u kpa̱ɗa̱ baci kudansa a̱ ubuta̱ wa afada ukuna wu ili i na we enei, ko i na u yevei ɗa u kpa̱ɗa̱i kudansa, wo okpo ta̱ vuza vu unushi adama a ili i na u yevei, ");
INSERT INTO asg_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ko kpamu ɗa baci vuza yoku u saꞋwai ili i na yi m ma̱shinda̱ babu na u yevei, ko manama ma kakamba ma na mi ni nshinda̱ ɗa ma̱ kuwa̱i, ko ilikuzuwa ko ili i wuma i na yi o kurono a̱tsuma̱ a iɗika ɗa yi ni nshinda̱ feu. A̱yi feu u ka̱na̱ ta̱ nshinda̱ ɗa kpamu u yaꞋin unushi. ");
INSERT INTO asg_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ko vu saꞋwa baci ili i na i tsu zuwa vuma wo okpo ni nshinda̱ babu na vi yevei. Ɗa vu ta̱wa̱i vu zukai ili i na vi yaꞋin va i gaꞋan ba, vo okpo ta̱ vuza vu unushi. ");
INSERT INTO asg_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ko kpamu vuma u yaꞋan baci akucina a na u kuyaꞋan ili i yoku babu na u sheshei mayin, ko i singai ko i gbani-gbani. Ɗa u ta̱wa̱i u zukai nannai va u gaꞋan ba, wo okpo ta̱ vuza vu unushi. ");
INSERT INTO asg_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ɗa baci vuza u zukai a na u yaꞋin unushi a̱ ka̱tsuma̱ ki ili i nampa, mayun ɗa u dansa e keteshe unushi u na u yaꞋin. ");
INSERT INTO asg_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ugana u na a kiɗakai ni adama a̱ unushi u na u yaꞋin u ɗaɗa, wi ta̱ a̱ kutuka̱ m mashan mo mokyon ko maraɗika a̱ ka̱tsuma̱ ku ushiga ka̱ta̱ u neke Vuzavaguɗu. Na ɗaɗa kuneꞋe ku unushi ku na ganu u kutakpaka yi unushi adama a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","<<Vi baci a̱ kuciya̱ ma̱giri ba, vi ta̱ a kufuɗa va̱ tuka̱ nu ntapambara n re ko moɗoi n re u Vuzavaguɗu a agisana a ugana a̱ unushi u nu. Manu me te ma ɗaɗa adama e kuneꞋe ku unushi, me te tamkpamu adama e kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Vi ta̱ a̱ kutuka̱ n ele a̱ ubuta̱ u ganu, a̱yi ɗa vuza na u kuneke manu ma iyain adama e kuneꞋe ku unushi. Ka̱ta̱ u pinda̱ra̱ kuɗeku, ama ka̱ta̱ u taɓa ku ɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ka̱ta̱ u vishangu mpasa n yoku n kuneꞋe ku unushi a akambu a katalikalyuka. Mpasa n na m buwai wi ta̱ a̱ kutsungu n ɗa a̱ kumiꞋi ku katalikalyuka ka. Na va ɗaɗa kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Manu me ire wi ta̱ kuneke maꞋa kuneꞋe ku kusongu, uteku tsu na a ci yaꞋansa. Ta ganu u kutono nannai ka̱ta̱ u takpaka yi unushi u ni, ka̱ta̱ a cinukpaka yi n u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","<<Wi baci an wa̱ kuciya̱ moɗoi n re ko ntapambara n re n na we kuneke ba, u tuka̱ n kiya ku na ku yawai ifa vi te u neke ku ɗa tsu kuneꞋe adama a̱ unushi u ni. Wi a̱ kutsungu maniꞋin ko ili i ma̱gula̱ni ba, adama a na kuneꞋe ku unushi ku ɗa. ");
INSERT INTO asg_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","U banka n kiya ka a̱ ubuta̱ u ganu, ka̱ta̱ a̱yi tamkpamu u kenuku ka̱kun ku te ka na ko kokpo ili i kuciɓasa. Ka̱ta̱ u songu ɗe a katalikalyuka tsu kuneꞋe ki ilikulya u Vuzavaguɗu. Ɗaɗa kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nannai ɗa ganu u kufolonoko yi a takpaka yi unushi u na u yaꞋin dem. Ka̱ta̱ a cinukpaka yi u ɗa. Kagimi ke kuneꞋe ka na ko okpoi ka ganu kaꞋa, uteku u na a ci yaꞋan n kuneꞋe ki ishina.>> ");
INSERT INTO asg_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ɗaɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","<<Vuza u pasa baci wila̱ ɗa u yaꞋin unushi babu na u yevei, u na u la̱nga̱sa̱i ili i ciɗa i Vuzavaguɗu, mayun ɗa u tuka̱ n ka̱giri ka na u kuɗika a ushiga u ni tsa alyuka e kuneꞋe u Vuzavaguɗu. Ka̱giri ka nanlo ka yaꞋan babu uꞋiwin u Ka̱shile, ka̱ta̱ a kiɗaka kaꞋa ikebe i ni yu uta̱ derere n azurufa i na a tsu yaꞋanka ulinga a̱ kunu ka avasa. Na va ɗaɗa kuneꞋe ku kuna unushi. ");
INSERT INTO asg_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mayun ɗa u tsupa ili i na u la̱nga̱sa̱i a̱ ka̱tsuma̱ ku ucanuku u ciɗa u nanlo. Ka̱ta̱ kpamu u doku ili i te a̱ ka̱tsuma̱ ki ili i tawun u neke ganu. Ka̱ta̱ ganu tamkpamu u folonoko yi a takpaka yi unushi u ni n ka̱giri ke kuneꞋe adama a kutakpa ku unushi, ka̱ta̱ Vuzavaguɗu u cinukpaka yi unushi u ni. ");
INSERT INTO asg_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","<<Vuza u yaꞋan baci unushi u na u pasai wila̱ u Vuzavaguɗu. Ko n uyevi u ni u ɗa baci u yaꞋin u ɗa ba, u nusa ta̱, wo okpo ta̱ kpamu vuza vu unushi. Wi ta na a kutakacika adama a̱ unushi u ni. ");
INSERT INTO asg_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Wi ta̱ a̱ kutuka̱ ganu n ka̱giri ka na wu utuka̱i a ushiga ka na ki babu uꞋiwin u Ka̱shile, ko i na yu untsai derere n kuneꞋe adama a katsupu ku unushi. Ka̱ta̱ ganu u folonoko yi a takpaka yi unushi u na u yaꞋin n ucikali u ni ba, ka̱ta̱ a cinukpaka yi n u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Na va ɗaɗa kuneꞋe adama a̱ unushi, adama a na mayun ɗa vu nusakai Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","<<Vuza yoku u yaꞋan baci unushi ɗa u pasai wila̱ u Vuzavaguɗu, ali ɗa u doroi vuza ni na i ida̱shi ɗeɗevu n ili i na e nekei ni u ɓa̱na̱ ko wi inda, ɗa u bonoi u bokoi i ɗa, ko ɗa u yaꞋankai ni kalyaꞋa. ");
INSERT INTO asg_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","A cina baci kpamu ucanuku wa u puwa̱nka̱i ɗa u yaꞋin aꞋuwa, ko u yaꞋin akucina a aꞋuwa, a̱ ka̱tsuma̱ ku unushi u na uma a yaꞋin ra̱ka̱, ");
INSERT INTO asg_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","u nusa baci ali ɗa unushi u ka̱na̱i ni, mayun ɗa u bonoko n ili i na u ɗikai ko u bokoi va, ko wi isai n utsura, ko i na e nekei ni kuɓa̱na̱, ko ili i na i puwa̱nka̱i ɗa u ciya̱i va, ");
INSERT INTO asg_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ko kpamu i na baci de dem u yaꞋankai akucina a aꞋuwa. Wi ta̱ a kutsupa i ɗa ra̱ka̱, ka̱ta̱ kpamu u doku ugboku u te a̱ ka̱tsuma̱ ki ili i tawun u vuza na u doroi va. A Kanna ka nanlo ka ɗa feu u kuneke kuneꞋe ku ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Wi ta̱ a̱ kutuka̱ ganu n kuneꞋe ku ka̱giri ka na ki babu uꞋiwin u Ka̱shile a ushiga u ni, tsu kuneꞋe ku kuna ku unushi a̱ ubuta̱ u Vuzavaguɗu, ko kpamu i na yu untsai n ikebe derere. ");
INSERT INTO asg_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","N tsu nampa tsu ɗa ganu u kufolonoko yi a cinukpaka yi unushi a̱ ubuta̱ u Vuzavaguɗu, ka̱ta̱ a cinukpaka yi n ili i nampa i na u yaꞋin dem, i na i bonokoi ni vuza vu unushi.>> ");
INSERT INTO asg_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","<<Neke Haruna m muku n ni wila̱ u nampa. Na ɗa wila̱ adama e kuneꞋe ku kusongu. I ta̱ kuka̱sukpa̱ kuneꞋe ku kusongu ka asa ɗe zuva vu katalikalyuka ali sai usana u yoku, ka̱ta̱ feu akina a katalikalyuka ka o yongo utasiki. ");
INSERT INTO asg_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Yeve n usana ganu u uka aminya a tsuganu koɓolo m motogu ma asuvu ma na mi punu a ikyamba i ni, ka̱ta̱ u pura̱ kokomo ke kuneꞋe ku kusongu ka na ka asai a̱ kukula̱ a katalikalyuka ka, ka̱ta̱ u tsungu kaꞋa a kakambu ka katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Wi ta̱ o kufoɗo aminya a̱ ni ka̱ta̱ u uka o yoku, ka̱ta̱ u pura̱ kokomo ka wu utuka̱ pulai daꞋangi n ka̱tsura̱ ka a̱ ubuta̱ u singai u na wi ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Akina a katalikalyuka ka o kuyongo ta̱ udyaɓi, ka̱ta̱ a kima̱sa̱ a ɗa ba. Usana dem ganu wi ta̱ o kudoku nɗanga ka̱ta̱ u rece kuneꞋe ku kusongu ɗe gaɗi, yeve u songu maniꞋin me kuneꞋe ku ma̱ta̱na̱ ɗe. ");
INSERT INTO asg_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Akina o yongo a̱ kukula̱ a katalikalyuka ka babu kukima̱sa̱. ");
INSERT INTO asg_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","<<Na va ele ɗa wila̱ u kuneꞋe ki ishina. Muku n Haruna mi ta̱ a̱ kutuka̱ n i ɗa a̱ ubuta̱ u Vuzavaguɗu, e kelime ka katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Vuza te a̱ ka̱tsuma̱ ke le u kenuku kiya ku singai ka tukpa a̱ ka̱kun m maniꞋin, koɓolo n ili i ma̱gula̱ni i na a zuwai zuva vi ili i kashina vi kuneꞋe ya, ka̱ta̱ o songu i ɗa zuva a katalikalyuka wi ta̱ o kokpo ugboku wi ili i kuciɓasa a katalikalyuka, ili i ma̱gula̱ni i singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Haruna m muku n ni ele ɗa aza na a kulyaꞋa i na i buwai. Ama i ta̱ a kulyaꞋa i ɗa babu yisiti a̱ ubuta̱ u ciɗa a ulanga u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ka̱ta̱ a yaꞋan i ɗa babu yisiti. N neke le ta̱ u ɗa wo okpo ugboku u kuneꞋe ki ilikulya i va̱. Ili i ɗa i na i laꞋi n ciɗa, uteku tsu kuneꞋe ku unushi n kuneꞋe adama a kuna ku unushi. ");
INSERT INTO asg_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mavali dem a̱ ka̱tsuma̱ ka ntsukaya n Haruna mi ta̱ a kulyaꞋa i ɗa ka̱ta̱ wo okpo ugboku wi ilikulya i le i na e nekei Vuzavaguɗu tsu kuneꞋe ali a kubana ntsukaya n na n kuta̱wa̱. I na baci de dem i saꞋwai le, i ɗa yi ta̱ o kokpo ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ɗa kpamu Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","<<Na ɗa kuneꞋe ku na Haruna m muku n ni e kuneke Vuzavaguɗu a kanna ka na e erengi le, yaba dem u neke kilo vi te vu ifa vu kiya ku singai uteku tsu kuneꞋe ki ishina ku ayin dem, kagimi ke te n usana, kagimi ke te kpamu n kulivi. ");
INSERT INTO asg_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A kangala i ɗa mayin m maniꞋin e kebelyu. Ka̱ta̱ i tuka̱ i ɗa usatari mayin, ukangali a̱kutsu-a̱kutsu tsu kuneꞋe ki ishina, ka̱ta̱ e neke ku ɗa ci ili i ma̱gula̱ni i singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Maku ma na ma̱ kuta̱wa̱ ma kisaka yi ulinga u tsuganu dem, u neke ili i nanlo ya u Vuzavaguɗu tsu wila̱ u ko wanai. I ta̱ kpamu o kusongu i ɗa ra̱ka̱-ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","KuneꞋe ki ishina dem ku ganu o songu ku ɗa ra̱ka̱-ra̱ka̱, ka̱ta̱ vuza u lyaꞋa ba.>> ");
INSERT INTO asg_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","<<Dana Haruna m muku n ni, na ɗa wila̱ u kuneꞋe adama a̱ unushi. A̱ ubuta̱ u na a tsu kiɗa kuneꞋe ku kusongu, ta ɗe feu a kukiɗa kuneꞋe ka adama a̱ unushi a̱ ubuta̱ u Vuzavaguɗu, ili i ɗa i na i laꞋi n ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ganu vu na u nekei ku ɗa adama a̱ unushi wi ta a kulyaꞋa ku ɗa. A̱ ubuta̱ u ciɗa u ɗa u kulyaꞋa ku ɗa a ulanga u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ili i na baci de dem i saꞋwai inyama ya, yi ta̱ o kokpo ciɗa. Ɗa baci ta na mpasa ma n saꞋwai kuminya, vi ta̱ a̱ kuza̱Ꞌa̱ ubuta̱ wa a̱ ubuta̱ u ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Mogbodo ma̱ ciꞋin ma baci a suꞋwankai inyama ya, i ta̱ o kuɓoso maꞋa. Ama o mogbodo ma̱ vuyum vi shili ma baci a suꞋwain i ɗa, i ta̱ o kukongoro maꞋa ka̱ta̱ a̱ za̱Ꞌa̱ m mini. ");
INSERT INTO asg_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mavali dem a̱ ka̱tsuma̱ ka kpaꞋa ku na ganu, wi ta̱ a kulyaꞋa i ɗa, ili i ciɗa i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ama kuneꞋe ku unushi dem ku na baci a̱ tuka̱i nu mpasa n le punu adama a na takpa unushi a̱ Ubuta̱ u Ciɗa, n ɗa mi kulyaꞋa ba, i ta̱ o kusongu n ɗa n akina. ");
INSERT INTO asg_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","<<Na ɗa wila̱ u kuneꞋe ku kuna ku unushi, ku ɗaɗa ta na ku na ku laꞋi n ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Manama ma na a kuyaꞋanka kuneꞋe ku kuna ku unushi a kiɗa maꞋa a̱ ubuta̱ u na a tsu kiɗa manama me kuneꞋe ku kusongu, ka̱ta̱ a vishangu mpasa ma a katalikalyuka n akambu a̱ ni dem. ");
INSERT INTO asg_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ganu wi ta̱ e kuneke ushuma u manama ma nanlo ra̱ka̱ a katalikalyuka, ushuma u na u kuyaꞋanka nannai u ɗaɗa u winja koɓolo n u na u palai ili i ka̱tsuma̱, ");
INSERT INTO asg_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","muku n ka̱tsuma̱ n re n nanlo koɓolo n ushuma u na wi akambu e le, n ukpan wa asuvu, i ta̱ a kutakpa le koɓolo m muku n ka̱tsuma̱ ma. ");
INSERT INTO asg_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ganu wi ta̱ o kusongu le a katalikalyuka tsu kuneꞋe ki ilikulya u Vuzavaguɗu, kuneꞋe ku kuna ku unushi ku ɗa. ");
INSERT INTO asg_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mavali de dem ma na mi punu a kpaꞋa ku ganu mi ta̱ a kufuɗa kutakuma i ɗa, ama i ta̱ a kutakuma i ɗa a̱ ubuta̱ u ciɗa, ɗaɗa ili i na i laꞋi n ciɗa dem. ");
INSERT INTO asg_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Wila̱ u kuna ku unushi u nampa wi ta̱ derere n wila̱ u kuneꞋe ku unushi, dem vi le wila̱ u te ɗa. U ɗa dem wi ta̱ o kokpo u ganu a̱yi na u kuyaꞋan ulinga n u ɗa, u na u bonoko vuza ciɗa a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ganu vu na u yaꞋankai vuza yoku kuneꞋe ku kusongu, a̱yi ɗa u kuɗika ukpan u manama ma nanlo ma wo okpo u ni. ");
INSERT INTO asg_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","KuneꞋe dem ki ili i kashina ku na a kangalai e kebelyu ka̱ viyum ko ka̱ ciꞋin, ko a katali, yi ta̱ o kokpo i ganu vu na u nekei i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","KuneꞋe ki ishina dem ko usatari m maniꞋin ko babu usatari, i ta̱ e kupeceke muku n Haruna derere. ");
INSERT INTO asg_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","<<Na ɗa wila̱ wa alyuka u kuneꞋe ki ida̱shi i singai ku na vuza u kuneke Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","U neke baci a ɗa u Vuzavaguɗu tsa agisana a ucikpi, ka̱ta̱ u neke a ɗa koɓolo n akala m boroji vu babu yisiti usatari m maniꞋin, koɓolo n emeshe a babu yisiti usatari m maniꞋin, n akala a kiya ku singai a na a satarai m maniꞋin mayin. ");
INSERT INTO asg_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Koɓolo kpamu n alyuka a̱ ma̱ta̱na̱ a ucikpi a̱ ni a, ka̱ta̱ u neke a ɗa koɓolo m boroji vu na vi n yisiti. ");
INSERT INTO asg_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A̱ ka̱tsuma̱ ke kuneꞋe ku nampa, wi ta̱ e kuneke ka̱kutsu ko boroji ke te, wo okpo tsu kuneꞋe u Vuzavaguɗu. Yi ta̱ o kokpo i ganu vu na u tsu vishangu mpasa n kuneꞋe ku ma̱ta̱na̱, a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Inyama ya alyuka i kuneꞋe ki ida̱shi i singai adama a ucikpi, a takuma i ɗa ra̱ka̱ a kanna ka na a yaꞋin kuneꞋe ka. Ka̱ta̱ a buwaka i yoku ali kayin ka asa ba. ");
INSERT INTO asg_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ama kuneꞋe ku ni adama a kushatangu akucina a ɗa baci ko kuneꞋe ku ucigi u ka̱ɗu, a kutakuma i ɗa a kanna ka na u yaꞋin alyuka a, kagimi ka na baci ka buwai kpamu i ta̱ a kufuɗa kutakuma i ɗa kayin ka asa baci. ");
INSERT INTO asg_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ama inyama ya alyuka i na baci i buwai ali a kanna ka tatsu, i ta̱ o kusongu i ɗa n akina. ");
INSERT INTO asg_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ɗa baci a takumai inyama ya alyuka i ma̱ta̱na̱ a kanna ka tatsu, vuza na u nekei a ɗa, Vuzavaguɗu wa̱ ku ushuku n a̱yi ba, ko keceke yi a ɗa a̱ ka̱tsuma̱ ka a singai. A ɗa i ta̱ o kokpo ili yu unata, vuza na baci u takumai i ɗa ko kenu gbani u ronoko ta̱ ka̱ci ka̱ ni unushi. ");
INSERT INTO asg_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","<<Inyama i na baci de dem i saꞋwai ili i na yi n nshinda̱, ka̱ta̱ i takuma i ɗa ba, i songi i ɗa a akina. Ama vuza na baci wi babu nshinda̱ wi ta̱ a kufuɗa kutakuma i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ama ɗa baci vuza yoku vuza na wi ni nshinda̱ u takumai inyama i kuneꞋe ki ida̱shi i singai i na e nekei Vuzavaguɗu, i ta̱ o kuloko yi punu a̱ ka̱tsuma̱ ka uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ɗa baci kpamu vuza yoku u saꞋwai ili yi ni nshinda̱, ko vuma, ko manama, ko kpamu ili i gbani-gbani i yoku, ko u lyaꞋi ili i kuneꞋe ki ida̱shi i singai i na e nekei Vuzavaguɗu, vuma nanlo va i ta̱ o kuloko yi punu a̱ ka̱tsuma̱ ka uma a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","<<Dana uma a Isaraila, ka̱ta̱ i takuma ushuma u kobomburon ba, ko wu nkyon ko kpamu wu nraɗika ba. ");
INSERT INTO asg_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ya kutakuma ushuma u manama ma na ma̱ kuwa̱i agifa ba, ko kpamu manama ma na ili i kakamba yu unai ba, ama yi ta̱ a kufuɗa kuyaꞋanka ushuma wa ili i yoku kau. Ko kenu i takuma i ɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Vuza na baci de dem u takumai ushuma u manama ma na a yaꞋankai kuneꞋe ki ilikulya a̱ ubuta̱ u Vuzavaguɗu, i ta̱ o kuloko yi punu a̱ ka̱tsuma̱ ka uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ubuta̱ u na baci de dem i da̱sa̱ngi, ka̱ta̱ i takuma mapasa ma manu ko m manama ba. ");
INSERT INTO asg_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Vuza na baci de dem u takumai mpasa, i ta̱ o kuloko yi punu a̱ ka̱tsuma̱ ka uma a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","<<Dana uma a Isaraila wila̱ u nampa, vuza na baci de dem u kuneke Vuzavaguɗu alyuka e kuneꞋe ki ida̱shi i singai, wi ta̱ kpamu e kuneke punu kuneꞋe ku ma̱ta̱na̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","N ka̱ci ka̱ ni u tuka̱ n kuneꞋe ku na o kusongu a̱ ubuta̱ u Vuzavaguɗu. U tuka̱ n ushuma m ma̱ka̱nga̱ ma, ka̱ta̱ a̱ ɗengusa̱ ma̱ka̱nga̱ ma tsu kuneꞋe ku kuɗa̱ngusa̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ganu wi ta̱ o kusongu ushuma wa zuva a katalikalyuka, ama ma̱ka̱nga̱ tamkpamu mi ta̱ o kokpo ma Haruna m muku n ni. ");
INSERT INTO asg_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Neke ma̱kuta̱ mu usingai me kuneꞋe ku ma̱ta̱na̱ u ganu, tsu kuneꞋe ku nu. ");
INSERT INTO asg_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Maku mo kolobo ma Haruna ma na me nekei mpasa n kuneꞋe ku ma̱ta̱na̱ koɓolo n ushuma wa, a̱yi ɗa vuza na u kuɗika ma̱kuta̱ me kune ku singai mo okpo upecu u ni. ");
INSERT INTO asg_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Punu a̱ ka̱tsuma̱ ke kuneꞋe ku ma̱ta̱na̱ ka aza a Isaraila, n ɗika ta̱ ma̱ka̱nga̱ ma na a̱ ɗengusa̱i m ma̱kuta̱ ma na a yaꞋankai kuneꞋe ka, ɗa n nekei Haruna ganu m muku n ni, wo okpo upecu u le u na wu uta̱i wa aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Na va ɗaɗa upecu u kuneꞋe ki ilikulya ku na a yaꞋankai Haruna m muku n ni, ku na e nekei Vuzavaguɗu a kanna ka na e erengi le o okpo anan ganu. ");
INSERT INTO asg_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","A kanna ka na e erengi le va, ɗa Vuzavaguɗu u danai uma a Isaraila e neke le ili i nampa ya yo okpo upecu u le ali n tsukaya tsu na tsa̱ kuta̱wa̱.>> ");
INSERT INTO asg_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Na va ɗaɗa wila̱ u kuneꞋe ku kusongu, n kuneꞋe ki ishina, n kuneꞋe ku unushi, n kuneꞋe ku kuna ku unushi, n kuneꞋe ku kerengu, koɓolo n kuneꞋe ku ma̱ta̱na̱, ");
INSERT INTO asg_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","u na Vuzavaguɗu u nekei Musa a Kusan ku Sinai. A kanna ka nanlo ka ɗaɗa u danai uma a Isaraila a̱ tuka̱ n kuneꞋe ku le ɗe u Vuzavaguɗu a kusan ku Sinai. ");
INSERT INTO asg_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","<<Tuka̱ n Haruna m muku mo olobo n ni, koɓolo nu ntogu n tsuganu n le, m maniꞋin ma kuɗarukpa a kaci, n kobomburon adama e kuneꞋe ka alyuka a̱ unushi, a̱giri e re koɓolo m mabana ma na mi m boroji vu babu yisiti. ");
INSERT INTO asg_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ka̱ta̱ vu ɓolongu uma a Isaraila ra̱ka̱ a̱ ubuta̱ u te a̱ utsutsu u Ma̱va̱li mo Oɓolo.>> ");
INSERT INTO asg_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa u yaꞋin uteku tsu na Vuzavaguɗu u tonokoi ni, ɗa uma a Isaraila a gasai a̱ utsutsu wa. ");
INSERT INTO asg_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ɗa Musa u danai le, <<Na ɗa ili i na Vuzavaguɗu u danai ci yaꞋan.>> ");
INSERT INTO asg_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ɗa Musa u tuka̱i n Haruna m muku n ni, ɗa a̱ sumba̱i le m mini. ");
INSERT INTO asg_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ɗa u ukai Haruna motogu mu ugaɗi ɗa u shiyai maganda a̱ kukyun, ɗa u ukai ni motogu mu ugaɗi ma tsuganu, koɓolo n efodu vu na u shiyai n ili i kaɗambura i na a yaꞋankai tsuzogu tsu kucaꞋa ke ekiye adama a na u reme yi mayin. ");
INSERT INTO asg_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ɗa Musa u zukai ni mosolo ma efodu a̱ ma̱ka̱nga̱, punu o mosolo ma ɗa u zukai ni Yurim n Tumi. ");
INSERT INTO asg_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ɗa u ukai Haruna oroli a tsuganu a kaci. Ɗa u varai a ɗa keleje ka kaci ka azanariya a̱ kuca̱n, ɗaɗa urotu u na wo okpoi vuza ciɗa, derere uteku tsu na Vuzavaguɗu u tonokoi Musa. ");
INSERT INTO asg_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Tsu nanlo ɗa Musa u ɗikai maniꞋin me kerengu ɗa we erengi Ma̱va̱li ma̱ Ka̱shile koɓolo n ili i na yi punu dem, adama a na i ɗa yo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ɗa u vishangi maniꞋin me kerengu mo yoku ɗe zuva vu katalikalyuka ali kucindere, ɗa we erengi kaꞋa, n ucanuku wu ulinga u ni dem, koɓolo n kasasu n kashamkpatsu ka̱ ni, adama a na u bonoko le ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ɗa u tsunki Haruna maniꞋin me kerengu mo yoku a kaci, u yaꞋin nannai adama a na u bonoko yi ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ɗa Musa u tuka̱i m muku mo olobo n Haruna. U ukai le aminya nu nganda e le dem koɓolo n oroliko, uteku tsu na Vuzavaguɗu u tonokoi Musa. ");
INSERT INTO asg_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ɗaɗa Musa u zuwai a̱ tuka̱ n kobomburon ke kuneꞋe adama a̱ unushi. Haruna m muku mo olobo n ni a kiyangi ekiye e le zuva a kaci ko kobomburon ka. ");
INSERT INTO asg_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ɗa Musa u kiɗai kaꞋa, ɗa u dyaɓai mpasa ma n ka̱jivu ka̱ ni ɗa u surai n ɗa ɗe a avana a katalikalyuka dem adama a na u bonoko ka ciɗa. Mpasa n na m buwai ka̱ta̱ u tsungu n ɗa ɗe a̱ kumiꞋi ku katalikalyuka ka. Nannai ɗa u kubonoko katalikalyuka ka ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ɗa Musa u takpai ushuma u na wi a uɓon wi ili i ka̱tsuma̱ ra̱ka̱, n ubuta̱ u singai wa asuvu m muku n ka̱tsuma̱ n re ma, koɓolo n ushuma u le, ɗa u songi ɗe a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ama kobomburon ka n ukpan u ni, n inyama i ni, n a̱wiya̱n a̱ ni, u songu le ta̱ n akina a pulai vu ka̱tsura̱ ka na uma i, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ɗa Musa va u tuka̱i n ka̱giri ke kuneꞋe ko kusongu, ɗa Haruna m muku n ni a kiyangi ekiye e le a kaci ka̱ ka̱giri ka. ");
INSERT INTO asg_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ɗa ta na Musa u kiɗai kaꞋa, ɗa u vishangi mpasa a akambu a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ɗa u kiɗai kaꞋa akiɗi-akiɗi, ɗa u songi kaci ka, n akiɗi a, koɓolo n ushuma wa dem. ");
INSERT INTO asg_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","U za̱Ꞌi ili i ka̱tsuma̱ n ene a m mini, ɗa Musa u songi ka̱giri ka ra̱ka̱ a katalikalyuka. KuneꞋe ku kusongu ku ɗa ku ma̱gula̱ni ma singai. KuneꞋe ki ilikulya ku ɗa u Vuzavaguɗu, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ɗaɗa u tuka̱i n ka̱giri ke ire, ke kerengu. Ɗa Haruna m muku n ni a kiyangi ekiye e le a kaci ka̱ ka̱giri ka. ");
INSERT INTO asg_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ɗaɗa Musa u kiɗai kaꞋa, ɗa u kenuki mpasa n yoku ɗa u dyaɓakai Haruna e melebu ma̱ kutsuvu ku usingai u ni, koɓolo n ka̱jivu ka gbayin ke kukiye ku usingai, n ka̱jivu ka gbayin ke kune ku usingai. ");
INSERT INTO asg_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ɗa Musa wu uta̱ka̱i m muku mo olobo n Haruna, ɗa u dyaɓakai le mpasa ma an nlebu ma atsuvu a usingai, koɓolo n a̱jivu a gbagbaꞋin e ekiye a usingai n gbagbaꞋin e ene a usingai feu. Ɗa kpamu u vishangi mpasa n na m buwai a akambu a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ɗa wu uta̱ka̱i ushuma n ushuma u winja, n u na wi punu a̱ ili i ka̱tsuma̱ dem, n kapalatsu ka asuvu, koɓolo m muku n ka̱tsuma n re n ushuma u le, koɓolo m ma̱kuta̱ mu usingai. ");
INSERT INTO asg_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Punu a asuvu a mabana mo boroji ma na a yaꞋin babu yisiti ɗa a̱ tuka̱i u Vuzavaguɗu, ɗa wu uta̱ka̱i ka̱kutsu ko boroji ka babu yisiti ke te n ka̱kutsu ko boroji ke te ka na a yaꞋin m maniꞋin n kemeshe ke te, ɗa u zuwai le a gaɗi vu ushuma a gaɗi vu ma̱kuta̱ mu usingai. ");
INSERT INTO asg_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","U zuwai ili i nampa ra̱ka̱ e ekiye a Haruna m muku n ni, ɗa a̱ ɗengusa̱i zuva tsu kuneꞋe ku kuɗa̱ngusa̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ɗaɗa Musa ta na wi isai kuneꞋe ka e ekiye e le, ɗa u songi ku ɗa a katalikalyuka koɓolo n kuneꞋe ku kusongu. Na va ɗaɗa kuneꞋe ku na e ci erengu ganu. Ili i ma̱gula̱ni i singai, kuneꞋe ki ilikulya ku Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ɗa Musa u ɗikai ma̱ka̱nga̱ ma malala ma, ma na mo okpoi upeci u ni, ɗa u nekei maꞋa kuneꞋe ku kuɗa̱ngusa̱ a̱ ubuta̱ u Vuzavaguɗu, uteku tsu na Vuzavaguɗu u tonokoi ni. ");
INSERT INTO asg_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ɗa Musa u kenuki maniꞋin me kerengu mo yoku koɓolo nu mpasa n na mi gaɗi vu katalikalyuka, ɗa u vishanki Haruna nu ntogu u ni, kpamu n olobo a̱ ni koɓolo nu ntogu n le dem. Nannai ɗa u bonokoi Haruna nu ntogu n ni ciɗa, koɓolo m muku n ni n aminya e le dem. ");
INSERT INTO asg_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ɗa Musa u danai Haruna n olobo a̱ ni, <<SuꞋwain inyama ya a̱ utsutsu u Ma̱va̱li mo Oɓolo, ka̱ta̱ i takuma i ɗa m boroji vu na vi a mabana me kuneꞋe ku kerengu tsu na n tonokoi nu, n danai, <Haruna n olobo a̱ ni ele ɗa a̱ kutakuma i ɗa.> ");
INSERT INTO asg_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ka̱ta̱ i songu kagimi ki inyama n ko boroji ka na ka buwai. ");
INSERT INTO asg_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ka̱ta̱ yu uta̱ punu a̱ utsutsu u Ma̱va̱li mo Oɓolo ma ba, ali ayin e cindere, sai kanna ke kerengu anan ganu ko kotso, adama a na ka̱ɗiva̱ ke kerengu ka ki ta̱ a kuyawa ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ili i na a yaꞋin anana, Vuzavaguɗu ɗa u zuwai a yaꞋan i ɗa, adama a na a takpaka ɗa̱ unushi. ");
INSERT INTO asg_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","A̱ utsutsu u Ma̱va̱li mo Oɓolo ta lo i kuyongo kanna n kayin ali ayin e cindere, a̱ɗa̱ a kuyaꞋan i na Vuzavaguɗu u danai, adama a na ka̱ta̱ i kuwa̱ ba, adama a na ta u tonokoi mu nannai.>> ");
INSERT INTO asg_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ɗa Haruna m muku mo olobo n ni a yaꞋin ili i na dem Vuzavaguɗu u tonokoi le a̱ ubuta̱ u Musa. ");
INSERT INTO asg_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","A kanna ka̱ kunla̱i ɗa Musa u ɗekei Haruna n olobo a̱ ni, koɓolo nu nkoshi m gba̱ra̱-gba̱ra̱ ma aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ɗa u danai Haruna, <<Ɗika maku mo kobomburon adama e kuneꞋe ku unushi, ka̱giri tamkpamu adama e kuneꞋe ku kusongu, dem vu le okpo babu uꞋiwin u Ka̱shile, ka̱ta̱ vi neke le a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ka̱ta̱ vu dana aza a Isaraila, <Ɗikai ma̱ga̱ji adama e kuneꞋe ku unushi, maku mo kobomburon m ma̱giri dem okpo aza a̱ ka̱ya̱ ke te ke te babu uꞋiwin u Ka̱shile kpamu adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ka̱ta̱ kpamu i doku i ɗika kobomburon n ka̱giri adama e kuneꞋe ku ma̱ta̱na̱, adama a na i lyuka a ɗa u Vuzavaguɗu. N kuneꞋe ki ishina ku na ki usatari m maniꞋin, adama a na anana Vuzavaguɗu wi ta̱ a̱ kuta̱wa̱ wa̱ ɗa̱.> >> ");
INSERT INTO asg_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ɗaɗa a̱ tuka̱i n ili i na Musa u danai le e kelime ka̱ Ma̱va̱li mo Oɓolo, ɗa ka̱bunda̱i ka uma ka ka yawai ɗevu, ɗa a shamgbai kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ɗa Musa u danai, <<Na ɗa ili i na Vuzavaguɗu u danai ɗa̱ i yaꞋan, ciya̱ tsugbayin tsu Vuzavaguɗu tsu ta̱wa̱ wa̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ɗa Musa u danai Haruna, <<Yawa ɗevu n katalikalyuka ka̱ta̱ vi neke kuneꞋe ku unushi ku nu n kuneꞋe ku kusongu adama a kutakpaka ka̱ci ka̱ nu unushi koɓolo n u uma, vu lyuka kuneꞋe ku uma ka ka̱ta̱ vu takpaka le unushi tsu na Vuzavaguɗu u danai.>> ");
INSERT INTO asg_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ɗa Haruna u yawai ɗevu n katalikalyuka ka, ɗa u kiɗai maku mo mobomburon me kuneꞋe ku unushi, ma na mi ma̱ ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ɗa olobo a̱ ni a̱ tuka̱i ni nu mpasa ma, ɗa u dyaɓai mpasa ma n ka̱jivu ka̱ ni ɗa u surakai avana a a na i a katalikalyuka ka. N na m buwai tamkpamu u tsungi n ɗa a̱ kumiꞋi ku katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ama ushuma, m muku n ka̱tsuma̱ n re ma koɓolo n ubuta̱ u singai wa asuvu, i na a takpai a̱ ka̱tsuma̱ ke kuneꞋe ku unushi, ɗa u songi i ɗa a katalikalyuka uteku tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ama inyama ya n ukpan wa, u songi le pulai a̱ ka̱tsura̱ ka na i. ");
INSERT INTO asg_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ɗa kpamu Haruna u kiɗai manama me kuneꞋe mo kusongu ma. Ɗa muku n ni n nekei ni mpasa ma, ɗa u vishangi n ɗa a akambu a katalikalyuka ka. ");
INSERT INTO asg_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ɗa e nekei ni kuneꞋe ku kusongu ka akiɗi-akiɗi, koɓolo n kaci, ɗa u songi le gaɗi vu katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ɗa u za̱Ꞌi ili i ka̱tsuma̱ koɓolo n ene, ɗa u songi i ɗa koɓolo n kuneꞋe ku kusongu ɗe a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ɗa kpamu Haruna u lyukai kuneꞋe ku uma ka. U ɗikai ma̱ga̱ji adama e kuneꞋe ku unushi ku uma ɗa u kiɗai maꞋa, ɗa u nekei maꞋa adama e kuneꞋe ku unushi tsu na u yaꞋin n mu ugiti. ");
INSERT INTO asg_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ɗa u tuka̱i n kuneꞋe ku kusongu, ɗa u nekei ku ɗa uteku u na wila̱ u danai. ");
INSERT INTO asg_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ɗa kpamu u tuka̱i n kuneꞋe ku kiya ki ishina, ɗa u kenuki ka̱kuꞋun tukpa ɗa u songi ku ɗa a gaɗi vu katalikalyuka, ɗevu n kuneꞋe ku kusongu ku usana. ");
INSERT INTO asg_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ɗa Haruna u kiɗai kobomburon ka n ka̱giri ka adama a alyuka e kuneꞋe ku ma̱ta̱na̱ a uma. Ɗa muku n Haruna n nekei ni mpasa ma, ɗa u vishangi n ɗa a akambu a katalikalyuka ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ama ushuma u kobomburon n u ka̱giri wa, n ushuma u winja koɓolo n uɓon n ushuma u na u palai ili i ka̱tsuma̱, m muku n ka̱tsuma̱ n re koɓolo kpamu n ubuta̱ u singai wa asuvu wa, ");
INSERT INTO asg_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ɗa a kiyangi ushuma wa gaɗi vu nka̱nga̱ vu nnama, ɗa u songi le a gaɗi vu katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haruna ta na u ɗengusa̱i nka̱nga̱ ma koɓolo nu nkuta̱ mu usingai u Vuzavaguɗu, tsu kuneꞋe ku kuɗa̱ngusa̱, tsu na Musa u danai. ");
INSERT INTO asg_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ɗa Haruna u ɗengusa̱i ekiye a̱ ni gaɗi a uɓon u uma ɗa u zuwakai le una̱singai. Ana u kotsoi kuneke alyuka e kuneꞋe ku unushi, n kuneꞋe ku kusongu, n kuneꞋe ku ma̱ta̱na̱, ɗa u cipa̱i u ka̱sukpa̱i katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ɗaɗa Musa ele n Haruna a uwai a̱ Ma̱va̱li mo Oɓolo, ana a̱ uta̱i ɗa a zuwakai uma una̱singai kpamu, ɗa tsugbayin tsu Vuzavaguɗu tsu ta̱wa̱i u yaba dem. ");
INSERT INTO asg_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ɗa akina a̱ uta̱i a̱ ubuta̱ u Vuzavaguɗu ɗa e leɓecei kuneꞋe ku kusongu ka, n uɓon wu ushuma dem u na wi a katalikalyuka. Ana uma ra̱ka̱ e enei nannai ɗa a yaꞋin yoroli i ma̱za̱nga̱, ɗa a̱ kuɗa̱ngi sapu a lyaꞋi kayala a cikpai Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ana i lo ɗa olobo a Haruna, Nadabu n Abihu a ɗikai a̱mbu e le ɗa e kenuki punu akina ɗa kpamu o doki a̱ tsungi ili i ma̱gula̱ni. Ɗa e nekei akina a na o yotsoi ba e kelime ka Vuzavaguɗu, tsu na u danai a yaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ɗaɗa akina a̱ uta̱i u Vuzavaguɗu ɗa a unai le, ɗa a̱ kuwa̱i a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ɗa Musa u danai Haruna, <<Na ɗa ili i na Vuzavaguɗu u danai, <A̱ ka̱tsuma̱ ka aza a na i a kuyaꞋanka mu a̱ga̱nda̱ mayun ɗa o tono ukuna u ciɗa u va̱, ka̱ta̱ o yotsongu tsugbayin tsu va̱, u uma a̱ va̱.> >> Ɗa Haruna u paɗai bini. ");
INSERT INTO asg_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ɗa Musa u ɗekei Mishalu n Elzapanu, muku n Uziyelu esheku e keꞋen a Haruna, ɗa u danai le, <<Ta̱wa̱i ɗevu, ɗikai even a ikyamba a uma a̱ ɗa̱ i banka daꞋangi vu ka̱tsura̱ ka na yi, daꞋin m Ma̱va̱li ma̱ Ka̱shile.>> ");
INSERT INTO asg_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ɗa a yawai ɗevu ɗa a ɗikai le nu ntogu n le a̱ uta̱ka̱i le pulai vu ka̱tsura̱ ka na i, uteku tsu na Musa u tonokoi le. ");
INSERT INTO asg_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ɗa Musa u danai Haruna koɓolo m muku mo olobo n ni Eliyaza n Itama, <<Ka̱ta̱ i ka̱sukpa̱ a̱nji a̱ ɗa̱ babu uza̱ɗukpi ba, ka̱ta̱ kpamu i karasa ntogu n ɗa̱ ba, ta baci nannai ba yi ta̱ a̱ kukuwa̱, ka̱ta̱ Vuzavaguɗu u yaꞋan wupa ra̱ka̱ n uma. Ama kumaci ku ɗa̱ n aza a Isaraila ra̱ka̱ i ta̱ a kuyaꞋan kpalu ku ukpa̱ ka aza a na Vuzavaguɗu wu unai n akina. ");
INSERT INTO asg_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ka̱ta̱ yu uta̱ punu a̱ utsutsu u Ma̱va̱li mo Oɓolo ma ba, ta baci nannai ba yi ta̱ a̱ kukuwa̱, adama a na maniꞋin me kerengu ma Vuzavaguɗu mi ta̱ a kaci ka̱ ɗa̱.>> Ɗa tana a̱ yaꞋin uteku u na Musa u danai. ");
INSERT INTO asg_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ɗa Vuzavaguɗu u yaꞋin kadanshi n Haruna u danai, ");
INSERT INTO asg_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","<<Avu n olobo a̱ nu ka̱ta̱ i soꞋo ma̱ra̱ ko ili i na i kuzuwa a̱shi a̱ ɗa̱ a̱ puwa̱nka̱ ba, a ayin a na baci de dem yi a kuꞋuwa a̱ Ma̱va̱li mo Oɓolo, ta baci de nannai ba yi ta̱ a̱ kukuwa̱. Wi ta̱ o kokpo wila̱ u ayin dem ali n tsukaya tsu na tsa̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Yi ta̱ a kuzagba ka̱ta̱ i pece i na yi ciɗa n ili yu unata, koɓolo kpamu n aza a nshinda̱ n aza a singai, ");
INSERT INTO asg_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mayu ɗa i yotsongu uma a Isaraila wila̱ u na Vuzavaguɗu u danai Musa u dana le.>> ");
INSERT INTO asg_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ɗa Musa u yaꞋin kadanshi n Haruna koɓolo Eliyaza n Itama, muku n ni n na m buwai, <<Ɗikai kagimi ke kuneꞋe ki ishina, ke kuneꞋe ki ilikulya i Vuzavaguɗu, ka̱ta̱ i lyaꞋa i ɗa babu usatari n yisiti a kakambu ka katalikalyuka. Adama a na i ɗaɗa i laꞋi n ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Yi ta̱ a̱ kulyaꞋa i ɗa a̱ ubuta̱ u ciɗa, adama a na upecu u nu u ɗa m muku n nu, a̱ ka̱tsuma̱ ke kuneꞋe ku na a yaꞋankai Vuzavaguɗu n akina. Adama a na ta o tonokoi mu nannai. ");
INSERT INTO asg_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ama Ma̱ka̱nga̱ ma na a̱ ɗengusa̱i va m ma̱kuta̱ ma na e nekei va, yi ta̱ a kutakuma maꞋa a̱ ubuta̱ u ciɗa. Avu n olobo a̱ nu ni nkere n nu, adama a na e neke ta̱ i ɗa yo okpo upecu u nu n upecu u muku n nu, a̱ ka̱tsuma̱ ka alyuka e kuneꞋe ku ma̱ta̱na̱ ka aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ma̱kuta̱ ma na e nekei va m ma̱ka̱nga̱ ma na a̱ ɗengusa̱i va i ta̱ a̱ kuta̱ka̱ koɓolo n kuneꞋe ki ilikulya ku uɓon wu ushuma u na a̱ ɗengusa̱i adama e kuneꞋe ku kuɗa̱ngusa̱ ku Vuzavaguɗu, ka̱ta̱ yo okpo upecu u nu n upecu wu muku n nu ayin dem tsu na Vuzavaguɗu u danai.>> ");
INSERT INTO asg_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ana Musa we ecei uteku tsu na a yaꞋansai m ma̱ga̱ji me kuneꞋe mu unushi ma, ɗa u cinai wana ɗai o songu maꞋa. Ɗaɗa u yaꞋin wupa n Eliyaza koɓolo n Itama, muku n Haruna n na m buwai. Ɗa we ecei, ");
INSERT INTO asg_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","<<Yiɗa̱i i zuwai ɗa i kpa̱ɗa̱i kutakuma kuneꞋe ka adama a̱ unushi ka a̱ Ma̱va̱li ma̱ Ka̱shile? Ili i ɗa i na i laꞋi n ciɗa, e neke ɗa̱ ta̱ i ɗa adama a na i folonoko uma unushi, ka̱ta̱ a takpaka le u ɗa u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","An wo okpoi ka̱ta̱ a uka nu mpasa ma a̱ ubuta̱ u ciɗa ba, wi ishi ta̱ u laꞋa n kugaꞋan i takuma inyama ya a̱ ubuta̱ u Ma̱va̱li ma̱ Ka̱shile, uteku tsu na n danai ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ɗa Haruna wu ushuki Musa, <<Anana ɗa muku n va̱ n nekei kuneꞋe ku unushi ku le koɓolo n kuneꞋe ku kusongu u Vuzavaguɗu. N nannai dem ɗa ili tsu nampa i ciya̱i mu. Mi ishi baci n takuma kuneꞋe ku unushi ku uma ku nampa anana, Vuzavaguɗu u kupana ta̱ uyoꞋo?>> ");
INSERT INTO asg_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ana Musa u panai nannai ɗa wu ushuki n kadanshi ka. ");
INSERT INTO asg_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa koɓolo n Haruna, ");
INSERT INTO asg_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","<<Dana uma a Isaraila. Na ɗa nnama n na i kufuɗa kutakuma a̱ ka̱tsuma ka nnama ra̱ka̱ n na mi punu a aduniyan. ");
INSERT INTO asg_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Manama dem ma na mi n okotsu uɓaci, ɗa kpamu u tsu ga̱ra̱ n u takumasakai n ɗa i kufuɗa kutakuma. ");
INSERT INTO asg_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nnama n yoku mi ta̱ lo n na n tsu ga̱ra̱ n a takumai, ko i ta̱ feu n okotsu uɓaci, ka̱ta̱ i takuma le ba: Ko a na karakuma ki a kutakuma n u ga̱ra̱i, wi n okotsu uɓaci ba, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Manama ma na e ci ɗeke kosoꞋo u tsu ga̱ra̱ ta̱ n u takumai, ama wi n uɓaci wo okotsu ba, ili yu unata i ɗa a kubana wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Kyalu ku tsu ga̱ra̱ ta̱ n u takumai, ama wi n okotsu ba, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ma̱gurusunu mi ta̱ n okotsu uɓaci u tsu ga̱ra̱ n u takumai ba, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ya kutakuma inyama i le ba. Yi kpamu a kusaꞋwa agifa e le ba, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","<<Ili i wuma i na yi punu o kuyongo a̱ mini ra̱ka̱, nu nɗolu, yi ta̱ a kufuɗa kutakuma i na yi n a̱fa̱ɓu n ugiza̱. ");
INSERT INTO asg_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ama ili i wuma i na yi punu a mala ko nɗolu ɗa yi n a̱fa̱ɓu ko ugiza̱ ba, ko a̱ ka̱tsuma̱ ki ili i na i tsu da̱sa̱ dem ko a̱ ka̱tsuma̱ ki ili i wuma i na yi punu a̱ mini, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","I bonoko le ili yu unata wa̱ ɗa̱, ka̱ta̱ i takuma inyama i le ba. Yi kpamu a kusaꞋwa agifa e le ba. ");
INSERT INTO asg_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ili i wuma i mini dem i na yi babu a̱fa̱ɓu n ugiza̱, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","<<Na va ɗaɗa nnu mu unata wa̱ ɗa̱, a kutakuma le ba, ili yu unata i ɗa, ele ɗa kajimba, n kasakali koɓolo n kagawun, ");
INSERT INTO asg_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","mashangi m maraɗagbede dem, ");
INSERT INTO asg_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","koɓolo n agawun n ashi e le ra̱ka̱, ");
INSERT INTO asg_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","koɓolo m manu ma na e ci ɗeke koborou m ma̱kpa̱tuwa̱n, m papadan, koɓolo n ashi a nshangi dem, ");
INSERT INTO asg_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","m mokpoyonlo n kagbagba ka̱ mini m ma̱kpa̱tuwa̱n, ");
INSERT INTO asg_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","m motokutoku ma̱ mini m ma̱kpa̱tuwa̱n m mashangi, ");
INSERT INTO asg_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","m maraɗagbede n kobobili, n kapaɗanga n kagan. ");
INSERT INTO asg_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","<<Ili i ciɗinkpi ra̱ka̱ i na yi nwalu n ene a̱ na̱shi dem, yi ta̱ o kokpo ili yu unata wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ama ko n tsu nannai ili i ciɗinkpi i yoku yi ta̱ lo i na i tsu wala n ene a̱ na̱shi a iɗika i na i kufuɗa ya takuma, aza a na i n ene a utsura a na a kufuɗa kuɗikpangu. ");
INSERT INTO asg_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Punu a̱ ka̱tsuma̱ ke le yi ta̱ a kufuɗa kutakuma icuꞋu ya akyuꞋun kakau, ijaun, ishangaɗi, koɓolo n icuꞋu ya akyuꞋun i yoku dem. ");
INSERT INTO asg_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ama ili i ciɗinkpi dem i na yi n ene a̱ na̱shi, ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","<<Ɗa baci vuza u saꞋwai agifa a ili i nampa, wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Vuza na baci de u saꞋwai agifa e le, u za̱Ꞌa̱ ntogu n ni, ka̱ta̱ wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Manama ma na de dem okotsu a̱ ni i uɓaci ba, wi kpamu a kutakuma n u ga̱ra̱i ba, ili yu unata i ɗa wa̱ ɗa̱. Vuza na baci de dem u saꞋwai agifa e le wi ta̱ o kokpo n unata. ");
INSERT INTO asg_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nnama dem n na n tsu wala n ataka e ene, a̱ ka̱tsuma̱ ka aza a na a tsu wala n ene a̱ na̱shi, aza a unata a ɗa wa̱ ɗa̱. Vuza na baci de dem u saꞋwai agifa e le wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Vuza na baci u saꞋwai agifa e le sai u za̱Ꞌa̱ ntogu n ni, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","<<A̱ ka̱tsuma̱ ka nnama n na mi n ene o kurono a̱tsuma̱ a iɗika ele ɗa aza a unata wa̱ ɗa̱, kashan n kabana, n kalagadau n icuꞋu i le dem, ");
INSERT INTO asg_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","mapalyau, n kakanlai, m mosoriya, m maɓatsagovu. ");
INSERT INTO asg_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Nnama n nampa ra̱ka̱ ili yu unata i ɗa wa̱ ɗa̱, vuza na baci u saꞋwai agifa e le wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ɗa baci agifa e le a̱ yikpa̱ka̱i ili i yoku, ili i nanlo ya ko yiɗa̱i baci a ci yaꞋanka i ɗa, yi ta̱ o kokpo n unata. Ko ili ya a yaꞋan baci i ɗa m maɗanga ko n kuminya, ko n ukpan, ko n kakashi kpamu. Vu zuwa i ɗa a̱ mini, i ɗa ta na yi ta̱ kokpo n unata ali a kubana kulivi, ka̱ta̱ i yeve yo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ɗa baci a̱ ka̱tsuma̱ ke le vuza te u yikpa̱i punu o mogbodo ma̱ ciꞋin, ili i na yi punu dem yi ta̱ o kokpo n unata, ka̱ta̱ i ɓoso mogbodo ma. ");
INSERT INTO asg_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","IlikulyaꞋa i na baci de mini mo mogbodo ma nanlo ma saꞋwai dem, i ɗa yo okpo ta̱ n unata. Mini mo kusoꞋo ma na baci e kenuki punu o mogbodo ma, mo okpo ta̱ mu unata. ");
INSERT INTO asg_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ili i na baci de dem agifa e le a̱ yikpa̱ka̱i, yo okpo ta̱ yu unata, kenle ka baci ko mogbodo ma̱ kuya̱na̱ i ta̱ o kuɓoso le miri-miri. Ili yu unata i ɗa wa̱ ɗa̱, a lyaꞋa kelime n kokpo ili yu unata wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ama, agifa a nnama n nanlo a̱ yikpa̱ baci o kuɗolu ko a kayinva ka na ki a̱ kuwwa̱, mini ma ma̱ na̱mgba̱ ba, ama vuza na baci u saꞋwai agifa a wi ta̱ o kokpo n unata. ");
INSERT INTO asg_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ɗa baci uɓon wa agifa u yoku u yikpa̱i a icuꞋu i vica̱Ꞌa̱, icuꞋu ya yo okpo n unata ba. ");
INSERT INTO asg_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ama icuꞋu ya yi baci uyeki m mini ɗa agifa a̱ yikpa̱i punu, yo okpo ta̱ n unata wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","<<Ɗa baci manama ma na a̱ ushuki ɗa̱ i takuma ɗa ma̱ kuwa̱i, vuza na baci de u saꞋwai agifa a̱ ni wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ɗa baci vuza u takumai agifa a̱ ni, wi ta̱ a̱ kuza̱Ꞌa̱ aminya a̱ ni ka̱ta̱ wo okpo n unata ali a kubana kulivi, vuza na baci kpamu u ɗikai agifa a̱ ni wi ta̱ a̱ kuza̱Ꞌa̱ aminya a̱ ni ka̱ta̱ wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","<<Ili i wuma dem i na yi n ene o kurono a̱tsuma̱ a iɗika, ili yu unata i ɗa wa̱ ɗa̱, ka̱ta̱ i takuma le ba. ");
INSERT INTO asg_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ili i na baci de dem yi o kurono a̱tsuma̱ a iɗika, n ili i na i tsu wala n ene a̱ na̱shi, ko i na yi n ene n a̱bunda̱i. Na lo va feu ili yu unata i ɗa wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ka̱ta̱ i uka ka̱ci ka̱ ɗa̱ nshinda̱ a̱ ubuta̱ u kutakuma ili i nampa ba, ka̱ta̱ i bonoko ka̱ci ka̱ ɗa̱ ili yu unata adama a ili i nanlo ba. ");
INSERT INTO asg_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","A dama a na mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱, bonokoi ka̱ci ka̱ ɗa̱ ciɗa, adama a na mpa ciɗa ɗa mi. Ka̱ta̱ i bonoko ka̱ci ka̱ ɗa̱ ili yu unata adama a ili i na i tsu wala n ene ka̱ta̱ o rono a̱tsuma̱ a iɗika ba. ");
INSERT INTO asg_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Adama a na mpa ɗa Vuzavaguɗu vu na wu uta̱ka̱i a iɗika i Masar, adama a na mo okpo Ka̱shile ka̱ ɗa̱. Adama a nannai bonokoi ka̱ci ka̱ ɗa̱ ciɗa, adama a na mpa vuza ciɗa ɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Nava ɗaɗa wila̱ u na wi adama a nnama nu nnu, n ili i wuma ra̱ka̱ i na yi a̱ mini koɓolo n ili i wuma i na yi n ene o kurono a̱tsuma̱ a iɗika. ");
INSERT INTO asg_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","N wila̱ u nampa, yi ta̱ a kufuɗa kupece ili yu unata n ili i ciɗa, n ili i wuma i na yi kutakuma koɓolo n i na yi kutakuma ba. ");
INSERT INTO asg_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","<<Dana aza a Isaraila, ɗa baci vuka vu ɗikai ka̱tsuma̱ ɗa u matsai maku mo kolobo, wi ta̱ o kokpo ni nshinda̱ ali ayin e cindere. Tsu na u tsu yongo ni nshinda̱ a ayin a̱ kusumbu ku ni. ");
INSERT INTO asg_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","A kanna ka̱ kunla̱i a kiɗa maku ma kavaja. ");
INSERT INTO asg_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Vuka va wi ta̱ o kuyongo nu mpasa ma ali ayin kamangankupa n a tatsu. Wi kpamu a kusaꞋwa ili i ciɗa ba, ko u bana u uwa a̱ Ma̱va̱li ma̱ Ka̱shile, ali sai ayin a na nshinda̱ n ni ma n kotsoi. ");
INSERT INTO asg_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ama mekere maꞋa baci u matsai, vuka va wi ta̱ o kokpo ni nshinda̱ ali kuden ku re, Tsu na u tsu yongo ni nshinda̱ a ayin a̱ kusumbu a̱ ni. Ka̱ta̱ u yongo n ku ɗa ali ayin amangatatsu n a̱ ta̱li, kafu a takpaka yi n ɗa. ");
INSERT INTO asg_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","<<Ayin a̱ mila̱ a̱ ni a shana baci, ko a maku me mekere ko mo kolobo, ka̱ta̱ u tuka̱ ganu m ma̱giri ma̱ ka̱ya̱ ke te a utsutsu adama e kuneꞋe ku kusongu, koɓolo m matapambara ko moɗoi adama e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ganu wi ta̱ e kuneke maꞋa tsu kuneꞋe u Vuzavaguɗu adama a na u takpaka vuka va unushi ciya̱ u bono ciɗa adama a̱ kusumbu ku ni. Na ɗa wila̱ u vuka vu na vu matsai maku ma vali ko ma vuka. ");
INSERT INTO asg_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Vuka va vi baci an wa fuɗa wa̱ tuka̱ m ma̱giri ba, u kucikpa u tuka̱ m moɗoi n re ko muku mu ntapambara n re, me te adama e kuneꞋe ku kusongu, n na m buwai kpamu adama e kuneꞋe ku unushi. N tsu nampa tsu ɗa ganu u kufolonoko vuka va a takpaka yi unushi, ka̱ta̱ ta na wo okpo ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Vuzavaguɗu u yaꞋin kadanshi m Musa n Haruna, u danai, ");
INSERT INTO asg_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","<<Vuza wi baci n kashita ko ka̱ra̱ga̱ji ko kubalu a ikyamba i ni ka na ka̱ kuta̱wa̱ ko kokpo yi mɓa̱la̱ mu ukutu, sai a banka yi u Haruna ganu ko u maku ma̱ ni me te ma na mi ganu. ");
INSERT INTO asg_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ganu va wi ta̱ a kindana ubuta̱ wu mɓa̱la̱ wu ukpan wa mayin. Ɗa baci cileme tsu ubuta̱ wa tso okpoi wa̱ri ɗa ubuta̱ wa u lyaꞋi kelime n kukongoɗo, na lo va mɓa̱la̱ mu ukutu n ɗa. Ɗa baci u goɗumoi ni, wi ta̱ a kudana uma wi ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ama ɗa baci ubuta̱ u kubalu wa wo okpoi wa̱ri koci, kpamu u lyaꞋa kelime n kukongoɗo ba, kpamu cileme tsu ubuta̱ wa̱ tso okpo wa̱ri ba. Ganu wi ta̱ a kuzuwa vuza va u yongo endeꞋen ni ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A kanna ke cindere ganu wi ta̱ o kudoku wo goɗumo yi, ɗa baci we enei ubuta̱ wu mɓa̱la̱ wa u yaꞋansaka ba, kpamu u lyaꞋa kelime n kulyaꞋa ikyamba ba, ganu wi ta̱ o kudoku wa zuwa yi u yongo endeꞋen ni ali ayin e cindere kpamu. ");
INSERT INTO asg_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","A kanna ke cindere ganu wi ta̱ o kudoku wa goɗumo vuma va mayin. Ɗa baci we enei ubuta̱ wu mɓa̱la̱ wa u lyaꞋa kelime n kulyaꞋa ikyamba ba, kpamu ɗa ubuta̱ wa u gita̱i kupotso, ganu wi ta̱ a kudana uma wi ta̱ ciɗa. Ka̱ra̱ga̱ji kaꞋa koci wi n kaꞋa, vuma va wi ta̱ a̱ kuza̱Ꞌa̱ aminya a̱ ni ka̱ta̱ wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ama ɗa baci ubuta̱ wa u lyaꞋi kelime n kukongoɗo, wana ɗai ta na ganu va u goɗumo ubuta̱ wa ɗa u danai vuma va wi ta̱ ciɗa, wi ta̱ o kudoku wo bono ɗe u ganu wa kpamu. ");
INSERT INTO asg_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ganu wi ta̱ o kudoku wo goɗumosuko yi, ɗa baci we enei ubuta̱ wa u lyaꞋa ta̱ kelime n kulyaꞋa ukpan wi ikyamba, ganu wi ta̱ a kudana uma wi ciɗa ba, mɓa̱la̱ mu ukutu n ɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","<<Ɗa baci vuza wi nu mɓa̱la̱ mu ukutu, a̱ ta̱wa̱ n a̱yi u ganu. ");
INSERT INTO asg_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ganu wi ta̱ a kindana ubuta̱ wa, ɗa baci ubuta̱ wu ushiti wa cileme tsu ukpan ci ni tsu bonoi wa̱ri, ɗa ubuta̱ wa u yaꞋin kpamu kuntsu, ");
INSERT INTO asg_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","mɓa̱la̱ mu ukutu n gbani-gbani n ɗa. Ganu wi ta̱ a kudana uma wi ciɗa ba. Ka̱ta̱ u zuwa yi u yongo endeꞋen ni ba, ko an wo okpoi wi ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ɗa baci ukutu wa wu uta̱i e keteshe a ukpan wi ikyamba ra̱ka̱, tsu na ganu u kufuɗa we kene ali u palai ukpan wi ikyamba i vuza ya u gita̱i a kaci ali a kubana e ene, ");
INSERT INTO asg_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ganu wi ta̱ o kudoku wo goɗumo yi mayin, ɗa baci mɓa̱la̱ ma m palai ikyamba i ni ra̱ka̱, u dana vuma vu nanlo wi ta̱ ciɗa. Adama a na ubuta̱ wa u bono ta̱ wa̱ri ra̱ka̱, nannai ta na wo okpo ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ama ɗa baci kuntsu ku savu kuta̱i a̱ ubuta̱ wa, vuza va u buwa kpamu ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ganu wi ta̱ o kugoɗumo kuntsu ku savu ka, ka̱ta̱ u dana yi wi ciɗa ba, kuntsu ka ili yu unata i ɗa kpamu mɓa̱la̱ mu ukutu n ɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ama ɗa baci kuntsu ka ku ta̱na̱i ɗa ku bonoi wa̱ri kpamu, wi ta̱ o kubono u ganu kpamu. ");
INSERT INTO asg_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ganu wi ta̱ o kugoɗumo yi mayin, ubuta̱ u kuntsu wa u bono baci wa̱ri, ganu wi ta̱ a kudana uma a wi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","<<Ɗa baci vuza wi n kamici a ikyamba i ni ɗa ka̱ ta̱na̱i, ");
INSERT INTO asg_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ama ubuta̱ u kamici wa u shita baci ɗa kpamu wa̱ a̱ruma̱i, ko kpamu ɗa u shilyamgbai, u bana u yotsongu ganu. ");
INSERT INTO asg_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ganu wi ta̱ a̱ kindana ubuta̱ wa mayin, ɗa baci we enei ubuta̱ wa u laꞋasaka ta̱ kukongoɗo, ɗa cileme kpamu tsu bonoi wa̱ri, ganu wi ta̱ a kudana yi wi ciɗa ba. Mɓa̱la̱ mu ukutu n ɗa n na mu uta̱i a kamici ka. ");
INSERT INTO asg_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ama ɗa baci ganu we enei cileme tsu ubuta̱ tsa tsu bono wa̱ri ba, kpamu mɓa̱la̱ ma n lyaꞋa kelime n kukongoɗo a ikyamba ba, u ka̱na̱ ta̱ kpamu kuta̱na̱, ganu wi ta̱ e kupece yi a̱ ka̱tsuma̱ ka uma a̱ ni ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mɓa̱la̱ ma n lyaꞋa baci kelime n kulyaꞋa ikyamba, ganu wi ta̱ a kudana uma wi ciɗa ba, n ɗa n tsu ka̱ra̱Ꞌa̱ ta̱. ");
INSERT INTO asg_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ama ubuta̱ wa u laꞋasaka baci ba, u lyaꞋa kelime kpamu ba, kalana ka kamici kaꞋa koci, ganu wi ta̱ a kudana yi wi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","<<Ɗa baci vuza u kula̱i ɗa ukpan u ushilyangbi ko ɗa ka̱ra̱ga̱ji kuta̱i kparasha wa̱ri a̱ ubuta̱ wu ukuli wa, ");
INSERT INTO asg_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ganu wi ta̱ a kindana ubuta̱ wa mayin, ɗa baci u cinai cileme tsu ubuta̱ wa tso okpoi wa̱ri, ɗa u kongoɗoi ikyamba ya, na lo va mɓa̱la̱ mu ukutu n ɗa. N ɗa mu uta̱ a̱ ubuta̱ wu ukuli wa, ka̱ta̱ ganu u dana vuza va wi ciɗa ba, mɓa̱la̱ mu ukutu n ɗa yi. ");
INSERT INTO asg_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ama ɗa baci ganu wi indanai ubuta̱ wa, ɗa u kpa̱ɗa̱i kene cileme tsu a̱ri a̱ ubuta̱ wa, kpamu u lyaꞋa kelime n kukongoɗo ikyamba ba, ɗa u gita̱i kufa̱ɓa̱, ganu wi ta̱ e kupece yi n uma ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A kanna ke cindere ganu wi ta̱ o kudoku wo goɗumo yi, mɓa̱la̱ ma mi baci a kulyaꞋa kelime n kulyaꞋa ukpan wi kyamba, ganu wi ta̱ a kudana vuma va wi ciɗa ba, mɓa̱la̱ mu ukutu n ɗa yi. ");
INSERT INTO asg_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ama kalana ka yaꞋansaka baci ba, kpamu ka lyaꞋa ukpan wi ikyamba ba, ɗa kpamu ka̱ fa̱ɓa̱i, na lo va ushiti u ɗa koci wu ukuli. Ganu wi ta̱ a̱ kudana vuma va wi ta̱ ciɗa, kalana kaꞋa koci ku ukuli. ");
INSERT INTO asg_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","<<Ɗa baci mavali ko mavuka mi n kuntsu a kaci ko a̱ ma̱tsa̱ka̱, ");
INSERT INTO asg_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ganu wi ta̱ a kindana mɓa̱la̱ ma mayin, n ɗa n kongoɗo baci ukpan wi ikyamba ya n a̱bunda̱i, ɗa kpamu cileme tsu ubuta̱ tsa tso okpoi shawu m mini mo tsulo, ganu wi ta a kudana uma wi ciɗa ba, una̱wuntoku u ɗa, ukutu u ɗa u na u tsu ka̱na̱ kaci ko ma̱tsa̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ama ɗa baci ganu la̱na̱sa̱ka̱i una̱wuntoku wa mayin, ɗa we enei u lyaꞋa kelime n kukongoɗo ukpan wi ikyamba wa ba, babu kpamu cileme tsu ulima̱ a̱ ubuta̱ wa, ka̱ta̱ u pece vuza vu mɓa̱la̱ vu una̱wuntoku wa ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A kanna ke cindere ganu wi ta̱ o kudoku kula̱na̱sa̱ka̱ mɓa̱la̱. Una̱wuntoku wa u lyaꞋa baci kelime, ubuta̱ wa kpamu wi baci n cileme tsu mini mo tsulo ba, ɗa kpamu una̱wuntoku wa u kpa̱ɗa̱i kulyaꞋa kelime n kukongoɗo ukpan wi ikyamba, ");
INSERT INTO asg_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ka̱ta̱ u puna, ama u kupuna ubuta̱ wu una̱wuntoku wa ba, ganu wi ta̱ e kupece vuza vu mɓa̱la̱ vu una̱wuntoku wa n uma ali ayin e cindere kpamu. ");
INSERT INTO asg_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","A kanna ke cindere ganu wi ta̱ o kudoku wa goɗumo una̱wuntoku wa, una̱wuntoku wa u lyaꞋa baci kelime n kuka̱ra̱Ꞌa̱ ukpan wi ikyamba wa ba, ɗa kpamu u kpa̱ɗa̱i kukongoɗo ukpan wi ikyamba wa, ganu wi ta̱ a kudana uma vuza va wi ta̱ ciɗa. Ka̱ta̱ u za̱Ꞌa̱ aminya a̱ ni ciya̱ wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ama ɗa baci una̱wuntoku wa kucukpai u ka̱ra̱Ꞌi ukpan wi ikyamba, wana ɗai a dana yi wi ta̱ ciɗa, ");
INSERT INTO asg_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ganu wi ta̱ o kudoku wo goɗumoi mayin, ɗa baci we enei una̱wuntoku wa u lyaꞋa ta̱ kelime n kuka̱ra̱Ꞌa̱ ukpan wi ikyamba, ganu wa kuvana we ene cileme tsu mini mo tsulo ba, vuma va wi ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ama ɗa baci n kindana ku ganu we enei una̱wuntoku wa u sabaꞋa ba, ɗa cileme ci lima̱ tsu uta̱i a̱ ubuta̱ wa, una̱wuntoku wa u ta̱na̱ ta̱, wo okpo ta̱ ciɗa. Ka̱ta̱ ganu u dana vuma va wi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","<<Ɗa baci mavali ko mavuka mi n kubalu ka̱ri a ukpan wi ikyamba, ");
INSERT INTO asg_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ganu wi ta̱ a̱ kindana yi, ɗa baci kubalu ku ukpan wi ikyamba ka ki kparasha wa̱ri, na lo va a̱biꞋin a gbani a ɗa a̱ uta̱i a ukpan wi ikyamba wa, vuza za wi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","<<Ɗa baci ka̱nji ka vuma ko omoi a kaci, ɗa wo okpoi n kukpani, vuza va wi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ɗa baci ka̱nji ka vuma ko omoi a uɓon u kuca̱n, wi ta̱ n kukpani ku uɓon u kuca̱, vuza va wi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ama ɗa baci a̱ra̱ga̱ji a shili ko a̱ a̱ri uta̱i punu a kukpani ka ko a̱ kuca̱n, na lo va mɓa̱la̱ mu ukutu n ɗa n na ma̱ a̱ kuta̱ yi a kaci. ");
INSERT INTO asg_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ganu wi ta̱ a kindana yi mayin, ɗa baci u cinai ubuta̱ wu ushiti a kukpani ku kaci ko ku uɓon u kuca̱n wa u shilyamgbai ɗa kpamu u a̱ruma̱i, uteku tsu mɓa̱la̱ mu ukutu a ukpan wi ikyamba, ");
INSERT INTO asg_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","vuma va wi ta̱ n mɓa̱la̱ mu ukutu, wi kpamu ciɗa ba. Ganu wi ta̱ a kudana wi ciɗa ba, adama a̱ra̱ga̱ji a na wi n a ɗa a kaci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","<<Vuma vu na wi nu mɓa̱la̱ n nanlo, wi ta̱ a kuꞋuka akashi ka̱ta̱ kpamu u ka̱sukpa̱ ka̱nji ka̱ ni babu uza̱ɗukpi. U pala una̱ u ni ka̱ta̱ u ka̱na̱ kusala, <Mpa vuza vu unata ɗa! Mpa vuza vu unata ɗa!> ");
INSERT INTO asg_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Wi ta̱ o kokpo vuza vu unata, wi baci de nu mɓa̱la̱ n nampa a ikyamba i ni. Mayun u yongo endeꞋen ni, mayun ɗa kpamu u da̱sa̱ngi daꞋangi n ka̱tsura̱ ka uma. ");
INSERT INTO asg_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","<<Ɗa baci a cinai kakashi ki ta̱ nu mɓa̱la̱ mu ukutu, ko kakashi ku ukpan ko ku ucaꞋi, ");
INSERT INTO asg_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ili yi ucaꞋi dem, ko yu ujili i na a yaꞋankai n arikinlai ko tsukongoi ko n ukpan ko n ili i na a yaꞋankai n ukpan wa, ");
INSERT INTO asg_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ɗa baci a̱pa̱lu a i punu a kakashi ka, ko a ukpan wa, ko a tsugbere tsu kucaꞋa tsa, ko a ili i na a tsu yaꞋanka kucaꞋa ka, ko ili i na a yaꞋankai n ukpan dem, ɗa yi tsu mini ma̱ a̱vuku ko yi tsu mini ma garula, na lo va u yotso ta̱ mɓa̱la̱ mu ukutu, a bana o yotsongu ganu. ");
INSERT INTO asg_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ganu wi ta̱ a̱ kula̱na̱ a̱pa̱lu a mayin, ka̱ta̱ wu utuka̱ ili i na yi n a̱pa̱lu a kau ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A kanna ke cindere ganu wi ta̱ o kugoɗumo a̱pa̱lu a. U cina baci a̱pa̱lu a a̱ ka̱ra̱Ꞌi kakashi ka, ko tsugbere ko ili i na a ci yaꞋanka kucaꞋa ko ukpan, ko yiɗa̱i baci ishi a ci yaꞋanka n ukpan, i ɗa i ka̱na̱ ta̱ mɓa̱la̱ mu ukutu, ili ya i buwa ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ganu wi ta̱ o kusongu kakashi ka, ko tsugbere tsa, ko ili i kucaꞋaka ya, ko tsukongoi, ko ili i na a tsu yaꞋanka arikinla, ko ili i na yi yu ukpan ɗa a̱pa̱lu a a̱ la̱nga̱sa̱i, adama a na a̱pa̱lu a̱ mɓa̱la̱ mu ukutu a̱ la̱nga̱sa̱ ta̱. U gaꞋan ta̱ o songu ili ya. ");
INSERT INTO asg_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","<<Ama ɗa baci ganu u la̱na̱i, ɗa u cinai a̱pa̱lu a̱ mɓa̱la̱ mu ukutu a a̱ ka̱ra̱Ꞌa̱ kakashi ka ba, ko tsugbere tsa ko ili i kucaꞋa ya, ko ili i na a yaꞋin n ukpan, ");
INSERT INTO asg_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ganu wi ta̱ a kuzuwa a̱ za̱Ꞌa̱ ili i na a̱pa̱lu a̱ ka̱na̱i va, ka̱ta̱ kpamu u doku wu utuka̱ ili ya kau ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ganu wi ta̱ o kudoku wa̱ la̱na̱sa̱ka̱ ili i na i pa̱lukpa̱i va. Ɗa baci ubuta̱ u na wi ishi n a̱pa̱lu a u sabaꞋi ba, ɗa kpamu a̱pa̱lu a a̱ ka̱ra̱Ꞌi a̱ ubuta̱ wa ba, i ɗa yi ciɗa ba. I songu i ɗa a akina, ko a̱pa̱lu a̱ ka̱na̱ baci n tsupulai ko n asuvu. ");
INSERT INTO asg_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","<<Ɗa baci ganu u goɗumoi, ɗa ubuta̱ wa̱ a̱pa̱lu u puwa̱nka̱i a ayin a na a̱ za̱Ꞌi i ɗa, wi ta̱ a kukara ubuta̱ wa a kuminya ka, ko a ukpan wa, ko tsugbere, ko a̱ ubuta̱ wi ili yu ucaꞋi wa. ");
INSERT INTO asg_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ama ɗa baci o doku uta̱sa̱ka̱i a kakashi ka, ko e tsugbere, ko a ili yu ucaꞋi wa, ko a ili i na a yaꞋin n ukpan, i ɗa yi ta̱ a̱ kuka̱ra̱Ꞌa̱. Ka̱ta̱ i na baci de dem yi n a̱pa̱lu a̱ mɓa̱la̱ mu ukutu o songu i ɗa a akina. ");
INSERT INTO asg_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ama kakashi ka, ko tsugbere tsa, ko ili yu ucaꞋi ya, ko i na a yaꞋin n ukpan, ɗa a̱ za̱Ꞌi ali ɗa a̱ utuka̱i n a̱pa̱lu a̱ mɓa̱la̱ mu ukutu ma, o doku a̱ za̱Ꞌa̱sa̱ka̱ i ɗa kpamu ka̱ta̱ i ɗa yo okpo ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Na va ɗaɗa wila̱ adama a̱ a̱pa̱lu a̱ mɓa̱la̱ mu ukutu n na n ka̱na̱i akashi a na a yaꞋin n tsukongoi, ko n i na a yaꞋankai arikinlai, ko ili yu ucaꞋi, ko tsugbere, ko i na a yaꞋin n ukpan adama a na a dana ko i ɗa yi ta̱ ciɗa ko i ɗa yi ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","<<Na wi ta̱ o kokpo wila̱ wa aza a̱ mɓa̱la̱ mu ukutu a kanna ka na a kutakpa le nshinda̱. I ta̱ a̱ kutuka̱ yi u ganu. ");
INSERT INTO asg_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Ganu wi ta̱ a̱ kuta̱ pulai vu ka̱tsura̱ va, ka̱ta̱ u la̱na̱ vuma vu mɓa̱la̱ vu ukutu ma mayin. Ɗa baci u cinai vuma va wana ɗai u ta̱na̱, ");
INSERT INTO asg_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ganu wi ta̱ a kuzuwa a̱ tuka̱ nu nnu n ciɗa n re koɓolo nu ncaka n sidan tsugbere ci shili tsu kucaꞋa, koɓolo n izobu adama a vuza na a kutakpaka nshinda̱ ma. ");
INSERT INTO asg_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ka̱ta̱ ganu u zuwa a kiɗa manunu me te gaɗi vu mogbodo ma̱ ciꞋin, ma na mi m mini ma na mi e kuyene ma singai. ");
INSERT INTO asg_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ka̱ta̱ u ɗika manu ma wuma ma koɓolo m macaka ma sida, n tsugbere tsu shili, n izobu ka̱ta̱ u pitiku punu a mpasa m manu ma na a kiɗai o mogbodo ma̱ ciꞋin ma na mi m mini ma singai ma. ");
INSERT INTO asg_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ka̱ta̱ u vishanku vuza na a kutakpaka nshinda̱ mu ukutu ma ali kucindere, ka̱ta̱ u dana vuma va wi ta̱ ciɗa. Ka̱ta̱ u ka̱sukpa̱ manu ma wuma ma ma laza. ");
INSERT INTO asg_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ka̱ta̱ vuza na a kutakpaka nshinda̱ ma u za̱Ꞌa̱ aminya a̱ ni, u puna ka̱nji ka̱ ni ra̱ka̱, ka̱ta̱ u sumba̱ ka̱ci ka̱ ni m mini, wo okpo ciɗa. Ka̱ta̱ ayin a nanlo u yeve u bono a asuvu a̱ ka̱tsura̱ ka, ama wi ta̱ a̱ kuda̱sa̱ngu pulai vu ulanga u ma̱va̱li ma ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A kanna ke cindere wi ta̱ a kupuna ka̱nji ka kaci ka̱ ni ra̱ka̱, nu ntsa̱ka̱ n ni, n a̱ga̱la̱ a̱ a̱shi a̱ ni, koɓolo n ubuta̱ u na u buwai n cileme dem. Ka̱ta̱ u za̱Ꞌa̱ aminya a̱ ni, ka̱ta̱ kpamu u doku u sumba̱ m mini ka̱ta̱ wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","<<A kanna ka̱ kunla̱i ka̱ta̱ u tuka̱ ni ngiri n re koɓolo m mashan mo mokyon ma̱ ka̱ya̱ me te ele na i babu uꞋiwin u Ka̱shile, n kuneꞋe ki ishina, n ifa vu tatsu vu kiya ku singai ku na ki usatari m maniꞋin ma zaitu. ");
INSERT INTO asg_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ganu vu na u danai vuma va wi ta̱ ciɗa va, wi ta̱ a kubanka n vuza na a kutakpaka nshinda̱ ma koɓolo n kuneꞋe ku ni u Vuzavaguɗu, a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ka̱ta̱ ganu u ɗika ma̱giri me te, u neke maꞋa tsu kuneꞋe ku kuna ku unushi, koɓolo m maniꞋin ma zaitu, ka̱ta̱ u ɗengusa̱ le gaɗi u Vuzavaguɗu tsu kuneꞋe ku kuɗa̱ngusa̱. ");
INSERT INTO asg_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ka̱ta̱ u kiɗa ma̱giri ma a̱ ubuta̱ ciɗa u na a tsu kiɗa alyuka e kuneꞋe ku unushi koɓolo n kuneꞋe ku kusongu. Adama a na kuneꞋe ku unushi ku ganu ku ɗa ku na ku laꞋi n ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ganu wi ta̱ e kukenuku mpasa n kuneꞋe ku kuna ku unushi n yoku, ka̱ta̱ u dyaɓa n ɗa e melebu ma kutsuvu ku usingai ma vuza na a kutakpaka nshinda̱ ma, n ka̱jivu ka gbayin ke kukiye ku usingai, n ka̱jivu ka gbayin ke kune ku usingai feu. ");
INSERT INTO asg_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ganu wi ta̱ kpamu e kukenuku maniꞋin ma zaitu mo yoku, ka̱ta̱ u tsungu maꞋa a kataka ke kukiye ku ugula̱ ka̱ ni, ");
INSERT INTO asg_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ka̱ta̱ u dyaɓasa maniꞋin n ka̱jivu ku usingai ka̱ ni ma na mi e kukiye ku ugula̱ ku ni ka, ka̱ta̱ u vishangu n yoku ali kucindere u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kagimi ka maniꞋin ka na ka buwai e kukiye ku ni, ganu wi ta̱ a ku dyaɓaka vuma na i a kutakpaka nshinda̱ ma e melebu ma kutsuvu ku usingai ku ni, n ka̱jivu ka gbayin ke kukiye ku usingai, koɓolo n ka̱jivu ka gbayin ke kune ku usingai ɗe a gaɗi vu mpasa vu kuneꞋe ku kuna ku unushi. ");
INSERT INTO asg_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kagimi ka maniꞋin ka na ka buwai e kukiye ku ganu ka, wi ta̱ a kuputala maꞋa a kaci ka vuza na a kutakpaka nshinda̱ ma. Ka̱ta̱ ganu u takpaka yi unushi u ni a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ka̱ta̱ ganu u neke alyuka e kuneꞋe ku unushi, adama a na u takpaka vuza na a kutakpaka nshinda̱ ma nshinda̱ n ni. Ka̱ta̱ ayin a nanlo u yeve u kiɗa manama me kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ka̱ta̱ u neke a ɗa a gaɗi vu katalikalyuka, koɓolo n kuneꞋe ki ishina, ka̱ta̱ u takpaka yi unushi u ni, u bonoko yi ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","<<Ama vuma va wi baci n uciyi ba, wi ta na feu a kufuɗa kutuka̱ n ili i makara ba, ka̱ta̱ u tuka̱ m ma̱giri me te adama e kuneꞋe ku kuna ku unushi ku na a̱ kuɗa̱ngusa̱. Adama a na a takpaka yi unushi u ni. Koɓolo n ifa vi te vu kiya ku singai usatari m maniꞋin adama e kuneꞋe ki ishina m maniꞋin ma zaitu, ");
INSERT INTO asg_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","koɓolo kpamu m moɗoi n re ko muku mu ntapambara n re, n na u kufuɗa wa̱ tuka̱. Me te ma yaꞋan me kuneꞋe ku unushi, me te kpamu adama e kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","A kanna ka̱ kunla̱i wi ta̱ a̱ kutuka̱ le u ganu adama a kutakpa ku nshinda̱ ku ni a̱ utsutsu u Ma̱va̱li mo Oɓolo a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ganu va wi ta̱ a kuɗika ma̱giri me kuneꞋe ku kuna ku unushi ka, koɓolo m maniꞋin ma zaitu ka̱ta̱ u ɗengusa̱ le a̱ ubuta̱ u Vuzavaguɗu tsu kuneꞋe ku kuɗa̱ngusa̱. ");
INSERT INTO asg_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ganu wi ta̱ a kukiɗa ma̱giri me kuneꞋe ku kuna ku unushi ka, ka̱ta̱ u kenuku mpasa n kuneꞋe ku kuna ku unushi ka ka̱ta̱ u dyaɓaka vuza na a kutakpaka nshinda̱ ma e melebu ma kutsuvu ku usingai ku ni, n ka̱jivu ka gbayin ke kukiye ku usingai ka̱ ni, koɓolo n ka̱jivu ka gbayin ke kune ku usingai ka̱ ni feu. ");
INSERT INTO asg_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ganu va wi ta̱ a̱ kutsungu maniꞋin mo yoku a kataka ke kukiye ku ugula̱ ka̱ ni, ");
INSERT INTO asg_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","n ka̱jivu ke kukiye ku usingai ka̱ ni, u vishangu maniꞋin ma na mi e kukiye ku ugula̱ ku ni ali kucindere u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kagimi ka maniꞋin ka na ka buwai a kataka ke kukiye ku ni, ganu wi ta̱ a̱ kutsungu n ɗa ɗe a̱ ubuta̱ u na a̱ tsungi mpasa n kuneꞋe ku unushi ka, ɗe e melebu ma kutsuvu ku usingai ku vuza na a kutakpaka nshinda̱ ma, a̱ ka̱jivu ka gbayin ke kukiye ku usingai ka̱ ni koɓolo n ka̱jivu ka gbayin ke kune ku usingai ka̱ ni feu. ");
INSERT INTO asg_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kagimi ka maniꞋin ka na ka buwai e kukiye ku ganu, wi ta̱ a̱ kutsungu maꞋa a kaci ka vuza na a kutakpaka nshinda̱ ma, ka̱ta̱ u takpaka yi unushi u ni a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ka̱ta̱ ganu u lyuka moɗoi n re ma ko muku mu ntapambara ma, n na u fuɗai u tuka̱i va, ");
INSERT INTO asg_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Me te mi ta̱ o kokpo me kuneꞋe ka adama a̱ unushi, me te kpamu adama e kuneꞋe ku kusongu, koɓolo n kuneꞋe ki ishina. N tsu nampa tsu ɗa ganu u kutakpaka vuma va unushi u ni u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Na ɗa wila̱ u vuza na wi nu mɓa̱la̱ mu ukutu, vuza na wa kufuɗa kutuka̱ n kuneꞋe ku kutakpa nshinda̱ n ni ba.>> ");
INSERT INTO asg_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa n Haruna u danai, ");
INSERT INTO asg_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","<<A ayin a na baci i uwai a iɗika i KanaꞋana, i na n nekei ɗa̱ yo okpo i ɗa̱, ɗaɗa n zuwai a̱pa̱lu a̱ mɓa̱la̱ mu ukutu a iꞋuwa i ɗa̱ ya, ");
INSERT INTO asg_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ka̱ta̱ vuza vu kpaꞋa va u bana u tonuko ganu, <Me ene ta̱ iyoci yi mɓa̱la̱ mu ukutu a kpaꞋa ku va̱.> ");
INSERT INTO asg_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ka̱ta̱ ganu u zuwa a̱ uta̱ka̱ n ili i na yi punu a kpaꞋa ka ra̱ka̱, yeve u uwa u goɗumo iyoci yi mɓa̱la̱ ma, Ta baci nannai ba, i na yi punu a kpaꞋa ka ra̱ka̱ i ta̱ a kudana i ɗa yi ta̱ ni nshinda̱. A makyan ma nanlo yeve ganu u uwa u la̱na̱ kpaꞋa ka. ");
INSERT INTO asg_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ka̱ta̱ u goɗumo iyoci yi mɓa̱la̱ ma, ɗa baci we enei iyoci yi mɓa̱la̱ ma udyabishi a nshilya m kpaꞋa ma u yotsoi mini ma̱ a̱vuku ko mini ma shili, ɗa baci we enei iyoci yi mɓa̱la̱ ya i uwa ta̱ a tsusaki ka, ");
INSERT INTO asg_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ka̱ta̱ ganu wu uta̱ punu a kpaꞋa ka, ka̱ta̱ u gbagura ku ɗa ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","A kanna ke cindere ganu wi ta̱ o kubono, ka̱ta̱ u doku u la̱na̱sa̱ka̱ ku ɗa. Ɗa baci we enei iyoci yi mɓa̱la̱ ya i ka̱ra̱Ꞌa̱ ta̱ kpaꞋa ka, ");
INSERT INTO asg_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ka̱ta̱ ganu u zuwa a takpasa atali a na i n iyoci yi mɓa̱la̱ ma, ka̱ta̱ a varuku a ɗa a̱ ubuta̱ u na wi n unata daꞋangi n likuci. ");
INSERT INTO asg_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Wi ta̱ a kuzuwa a̱ ka̱ga̱lukpa̱ kasaka ka kpaꞋa ka ra̱ka̱, alakpa a kasaka a na a̱ ka̱ga̱lukpa̱i va a̱ pura̱ a ɗa a bana a̱ va̱ma̱ a̱ ubuta̱ wu unata pulai vu likuci. ");
INSERT INTO asg_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ka̱ta̱ a̱ ɗika atali o yoku o bonoko a ɗa a̱ ubuta̱ u na a takpai aza a nan ɗe a, ka̱ta̱ a̱ na̱na̱ ciꞋin tsu savu a sura kpaꞋa ka. ");
INSERT INTO asg_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","<<Ɗa baci iyoci yi mɓa̱la̱ ma i doku yu uta̱i a kpaꞋa ka, wana ɗai a takpa atali a ɗa kpamu a surasakai kpaꞋa ka, ");
INSERT INTO asg_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ganu wi ta̱ a kubana ka̱ta̱ u la̱na̱sa̱ka̱ ku ɗa. Ɗa baci iyoci yi mɓa̱la̱ ya i ka̱ra̱Ꞌi kpaꞋa ka, mɓa̱la̱ m gbani-gbani mu ukutu n ɗa mi punu a kpaꞋa ka, ku ɗa ki ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","KpaꞋa ka ka kuyaꞋan ta̱ ufa̱di n atali a ni dem, nu nɗanga koɓolo n usuri u kpaꞋa wa dem, ka̱ta̱ a̱ pura̱ a bana a̱ va̱ma̱ a pulai vi likuci a̱ ubuta̱ wu unata. ");
INSERT INTO asg_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Vuma na baci u uwai a kpaꞋa ka, a ayin a na kpaꞋa ka ki ugbaguri, wi ta̱ o kokpo n unata ali kulivi. ");
INSERT INTO asg_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Vuza na baci wa asai punu ko u lyaꞋi ilikulyaꞋa punu a kpaꞋa ka, mayun ɗa u za̱Ꞌa̱ aminya a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","<<Ama ɗa baci ganu u ta̱wa̱i u la̱na̱sa̱ka̱i kpaꞋa ka, ɗa kpamu we enei iyoci yi mɓa̱la̱ ya i ka̱ra̱Ꞌa̱ punu ba, cina ɗe a surasaka ku ɗa ta na, ganu wi ta̱ a kudana uma kpaꞋa ka ki ta̱ ciɗa adama a na iyoci yi mɓa̱la̱ ya i puwa̱nka̱ ta̱. ");
INSERT INTO asg_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Adama a kutakpa nshinda̱ m kpaꞋa ma, ganu wi ta̱ a kuɗika nnu n re, m macaka ma sida, koɓolo n tsugbere ci shili n izobu. ");
INSERT INTO asg_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ka̱ta̱ u kiɗa manu me te a gaɗi vu mogbodo ma̱ ciꞋin ma na mi tukpa m mini ma na e kenuki e kuyene. ");
INSERT INTO asg_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ka̱ta̱ u ɗika macaka ma sida, n izobu, n tsugbere ci shili koɓolo m manu ma wuma ma, ka̱ta̱ u pitiku le punu a mpasa m manu ma na a kiɗai gaɗi vu mini me kuyene ma, ka̱ta̱ u vishanku kpaꞋa ka ali kucindere. ");
INSERT INTO asg_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","N tsu nampa tsu ɗa u kutakpa nshinda̱ m kpaꞋa ma nu mpasa m manu, m mini me kuyene, m manu ma wuma, koɓolo m macaka ma sida, n izobu, koɓolo n tsugbere ci shili. ");
INSERT INTO asg_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ka̱ta̱ u ka̱sukpa̱ manu ma wuma ma ma laza a kakamba. N tsu nanlo tsu ɗa u kutakpaka kpaꞋa ka unushi ka̱ta̱ ko okpo ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Na ɗa wila̱ wu mɓa̱la̱ mu ukutu dem u na u yotsoi una̱wuntoku, ");
INSERT INTO asg_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","adama a̱ mɓa̱la̱ mu ukutu a kuminya ko a kpaꞋa, ");
INSERT INTO asg_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","n kashita, n kalana, ko kubalu. ");
INSERT INTO asg_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","A dama a na u yotsongu ayin a na wi n unata n ayin a na wi ciɗa. Na ɗa wila̱ wu mɓa̱la̱ mu ukutu. ");
INSERT INTO asg_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa koɓolo n Haruna u danai, ");
INSERT INTO asg_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","<<YaꞋan kadanshi n uma a Isaraila vu dana le, ɗa baci vuza wi m mali a tsali ci ni wo okpo ta̱ vuza vu unata. ");
INSERT INTO asg_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Na ɗa wila̱ wu unambi u ciɗa u ni adama a mali ma tsali, ko tsali ci ni ci ta̱ a̱ kuta̱ka̱ m mali ko tsu votsuku ta̱, na lo va wo okpo ta̱ vuza vu unata. ");
INSERT INTO asg_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","IvaꞋantsu i na baci de dem vuza vu mali ma tsali u vaꞋanki yo okpo ta̱ yu unata, i na baci kpamu u desa̱nki dem i ɗa yo okpo ta̱ yu unata. ");
INSERT INTO asg_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Vuza na baci u saꞋwai ivaꞋantsu i ni, sai u za̱Ꞌa̱ aminya a̱ ni, ka̱ta̱ u sumba̱ m mini, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Vuza na baci u da̱sa̱ngi n ida̱sa̱mkpa̱tsu i na vuza vu mali ma tsali u da̱sa̱nki, sai u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ wo okpo kpamu n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Vuza na baci de dem u saꞋwai vuma na wi m mali ma tsali sai u sumba̱ m mini, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ɗa baci vuza na wi m mali ma tsali ɗa u jirakai vuza na wi ciɗa ntsa̱n, vuma vu nanlo wi ta̱ a̱ kuza̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ugalu u na baci de dem vuza vu mali ma tsali va u kumbai, i ɗa yi ta̱ o kokpo n unata, ");
INSERT INTO asg_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","kpamu vuza na baci de dem u saꞋwai ugalu u na vuma vu mali ma tsali va u da̱sa̱nki wi ta̱ o kokpo n unata ali a kubana kulivi, vuza na baci kpamu u ɗikai ili i nanlo ya sai u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Vuza na baci de dem vuza vu mali ma tsali u saꞋwai babu u saꞋa ekiye a̱ ni m mini, sai u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, kpamu wi ta̱ o kokpo n unata ali kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Mogbodo ma̱ ciꞋin ma na vuza vu mali ma tsali u saꞋwai dem, i ta̱ o kuɓoso maꞋa, kpamu ili yu ulinga i na a yaꞋin nu nɗanga dem a̱ za̱Ꞌa̱ i ɗa m mini. ");
INSERT INTO asg_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","<<Ɗa baci vuza vu mali ma tsali va u ta̱na̱i, ka̱ta̱ u keceke ka̱ci ka̱ ni ayin e cindere adama a upoci u ni, ka̱ta̱ u za̱Ꞌa̱ aminya a̱ ni, u sumba̱ m mini me kuyene, ka̱ta̱ wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","A kanna ka̱ kunla̱i wi ta̱ a̱ kutuka̱ m moɗoi n re, ko muku mu ntapambara n re, ka̱ta̱ u tuka̱ a̱ ubuta̱ u Vuzavaguɗu, a̱ utsutsu u Ma̱va̱li mo Oɓolo ka̱ta̱ u neke ganu. ");
INSERT INTO asg_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ka̱ta̱ ganu u lyuka le, me te adama e kuneꞋe ku unushi, me te kpamu adama e kuneꞋe ku kusongu. N tsu nampa tsu ɗa a kutakpaka yi unushi u ni a̱ ubuta̱ u Vuzavaguɗu a dama a mali ma tsali ma̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","<<Ɗa baci ugapa u loloi vuma, mayun ɗa u sumba̱ ikyamba i ni dem m mini, kpamu wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kuminya n ukpan dem u na ugapa wa u saꞋwai, a̱ za̱Ꞌa̱ u ɗa m mini, kpamu wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ɗa baci vuza u vaki n vuka ali ɗa ugapa u loloi ni, dem vi le a̱ sumba̱ m mini, kpamu i ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","<<Ɗa baci vuka ve enei kusumbu ku ni, wi ta̱ kokpo ni nshinda̱ ali ayin e cindere, vuza na baci kpamu u saꞋwai ni wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","IvaꞋantsu n ida̱sa̱mkpa̱tsu i na de dem u vaꞋankai ko u da̱sa̱nki a ayin a̱ kusumbu a̱ ni, i ɗa yi ta̱ o kokpo n unata. ");
INSERT INTO asg_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Vuza na baci de dem u saꞋwai ivaꞋantsu i vuka ya, sai u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, wi ta̱ kpamu o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Vuza na baci de dem u saꞋwai i na u da̱sa̱nki, mayun ɗa sai u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ko ivaꞋantsu ko ili i na baci de dem u da̱sa̱nki, ɗa baci vuza u saꞋwai i ɗa, wi ta̱ o kokpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ɗa baci vali vu vaki n vuka, ali ɗa kusumbu ka ku saꞋwai ni, wi ta̱ o kokpo n unata ali ayin e cindere, ivaꞋantsu i na kpamu u vaꞋankai va yi ta̱ o kokpo n unata. ");
INSERT INTO asg_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","<<Ɗa baci vuka ve enei mpasa n na n geshei ni ama ba a ayin a̱ kusumbu a̱ ni ba, wi ta̱ kokpo n unata a̱ ka̱tsuma̱ ka ayin nanlo dem, derere n uteku tsu ayin a̱ kusumbu a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","IvaꞋantsu dem i na u vaꞋanki a̱ ka̱tsuma̱ ka ayin a nanlo, yi ta̱ o kokpo yi ci ivaꞋantsu a ayin a̱ kusumbu a̱ ni. Ili i na baci kpamu dem u da̱sa̱nki yi ta̱ o kokpo n unata, uteku tsu ayin a̱ kusumbu a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Vuza na baci de dem u saꞋwai ili i nanlo wi ta̱ o kokpo n unata. Mayun ɗa u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ kpamu wo okpo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","A ayin a na baci kuta̱ ku mpasa ka ku kotsoi, wi ta̱ e kukece ka̱ci ka̱ ni ayin e cindere. Ka̱ta̱ yeve wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A kanna ka̱ kunla̱i wi ta̱ a̱ kutuka̱ m moɗoi n re ko ntapambara n re, ka̱ta̱ u banka ganu a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ganu wi ta̱ a kulyuka me te adama e kuneꞋe ku unushi, me te kpamu adama e kuneꞋe ku kusongu. Uteku tsu nampa tsu ɗa u kutakpaka yi unushi u kuta̱ ku mpasa ku ni a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","<<Mayun ɗa i pece aza a Isaraila koɓolo n ili i na i kuzuwa le o okpo n unata. Ta baci nannai ba, i ta̱ a̱ kukuwa̱ adama a unata u le u la̱nga̱sa̱ ta̱ Ma̱va̱li ma̱ Ka̱shile ma̱ va̱ ma na mi e mere me le.>> ");
INSERT INTO asg_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Nava ɗaɗa wila̱ u vuma vu na wi m mali ma tsali, n vuza na ugapa wi o kulolo yi ɗa wo okpoi vuza vu unata, ");
INSERT INTO asg_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ko kpamu u vuka vu na vi a̱ kusumbu, ko kpamu mavali ko mavuka ma na mi m mali ma tsali, ko kpamu vuza n na u vaki n vuka vu na vi n kusumbu. ");
INSERT INTO asg_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ana muku mo olobo n re n Haruna n kuwa̱i adama e kuneꞋe ku gbani-gbani ku na e nekei Vuzavaguɗu, ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa. ");
INSERT INTO asg_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, <<Dana Haruna vuza nu ka̱ta̱ u uwa a̱ ubuta̱ u ciɗa nannai a ayin tutu a kakashi ku utsutsu ka ba, e kelime ka̱ ka̱kuya̱mkpa̱tsu ka na ki gaɗi va akpati vu uzuwakpani va, adama a na ka̱ta̱ u kuwa̱ ba. Adama a na mi ta̱ a̱ kuta̱ a asuvu e eleshu a̱ kuta̱wa̱ gaɗi vu ka̱kuya̱mkpa̱tsu va. ");
INSERT INTO asg_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Na ɗa uteku tsu na Haruna u kuꞋuwa ubuta̱ u ciɗa. Wi ta̱ a kuꞋuwa m medendem adama e kuneꞋe ku unushi m ma̱giri kpamu adama e kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Mayun ɗa u sumba̱ m mini yeve u uka motogu ma na a yaꞋin n arikinlai m motogu ma asuvu ma na ma yaꞋin paɗi n ikyamba i ni. Ka̱ta̱ u shiya maganda ma tsuganu a̱ kukyun ku ni m ma̱kun ma tsuganu feu a kaci ka̱ ni. Na va aminya a ciɗa a ɗa. ");
INSERT INTO asg_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Uma a Isaraila kpamu i ta̱ e kuneke Haruna nga̱ji n re adama e kuneꞋe ku unushi, n ka̱giri ke te adama e kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","<<Haruna wi ta̱ e kuneke kobomburon tsu kuneꞋe ku unushi adama a̱ ka̱ci ka̱ ni. Uteku tsu nampa tsu ɗa u kutakpa unushi u ni n u kpaꞋa u ni. ");
INSERT INTO asg_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ka̱ta̱ u ɗika nga̱ji n re ma u neke n ɗa u Vuzavaguɗu a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Wi ta̱ a kuyaꞋan kazagba a̱ nga̱ji n re ma, kazagba ke te ka Vuzavaguɗu, ka na ka buwai tamkpamu ka Azazelu. ");
INSERT INTO asg_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haruna wi ta̱ a kuɗika ma̱ga̱ji ma na kazagba ka̱ ka̱na̱i va, ka̱ta̱ u neke ma alyuka e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ama ma̱ga̱ji ma na ma lyaꞋi kazagba ka Azazel, i ta̱ a̱ kutuka̱ m maꞋa n wuma a̱ ubuta̱ u Vuzavaguɗu. Ayin a na baci o lokoi maꞋa a kubana e meremune u Azazel, nshinda̱ n uma mi ta̱ a kuyaꞋan utakpi ka̱ta̱ uma o bono derere u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","<<Haruna wi ta̱ a̱ kutuka̱ n kobomburon adama e kuneꞋe ku unushi ku ka̱ci ka̱ ni, u na u kutakpa unushi adama a̱ ka̱ci ka̱ ni n aza a kpaꞋa a̱ ni. Ka̱ta̱ u kiɗa kobomburon ka adama e kuneꞋe ku unushi ku ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ka̱ta̱ u ɗika ka̱mbu tukpa n a̱ga̱ruwa̱shi akina a na u kenuki a katalikalyuka a̱ ubuta̱ u Vuzavaguɗu. Ka̱ta̱ u kenuku a̱kuꞋun e re tukpa a̱ a̱va̱ a̱ ma̱gula̱ni a na i wiyi mayin, ka̱ta̱ u zuwa le a̱ kucina̱ ku kakashi ku utsutsu ka. ");
INSERT INTO asg_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Wi ta̱ a̱ kutsungu a̱vu a̱ ma̱gula̱ni a akina a̱ a̱ga̱ruwa̱shi a̱ ubuta̱ u Vuzavaguɗu, ka̱ta̱ ka̱nga̱ ka̱ a̱vu a̱ ma̱gula̱ni a ka̱ kimba̱ ubuta̱ u ka̱kuya̱mkpa̱tsu ka kutakpa unushi ka, adama a na u kuwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ka̱ta̱ u kenuku mpasa n kobomburon ma ka̱ta̱ u uka punu ka̱jivu ka̱ ni u vishangu e kelime ka̱ ka̱kuya̱mkpa̱tsu a uɓon u kasana va akpati va, ka̱ta̱ kpamu u vishangu n yoku n ka̱jivu ka̱ ni ali kucindere a̱ ubuta̱ u ka̱kuya̱mkpa̱tsu ka kutakpa unushi ka. ");
INSERT INTO asg_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","<<Ka̱ta̱ u kiɗa ma̱ga̱ji adama e kuneꞋe ku unushi u uma, ka̱ta̱ u uka nu mpasa punu a asuvu a kakashi ku utsutsu ka, tsu na u yaꞋin nu mpasa n kobomburon ma. U vishangu n ɗa e kelime ka gaɗi vu ka̱kuya̱mkpa̱tsu ka Akpati vu Uzuwakpani. ");
INSERT INTO asg_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Nannai ɗa u kutakpa unushi wu Ubuta̱ u na u laꞋi n Ciɗa adama a unata u uma a Isaraila n unushi u le. U doku u yaꞋan kpamu nannai m Ma̱va̱li mo Oɓolo, ma na mi koɓolo n ele a̱ ka̱tsuma̱ ku unata u le. ");
INSERT INTO asg_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Babu vuza n na u kuꞋuwa punu a̱ Ma̱va̱li ma a ayin a na Haruna u uwai punu kuyaꞋan kutakpa ku unushi a̱ Ubuta̱ u na u laꞋi n Ciɗa, ali sai ayin a na wu uta̱i pulai, wana ɗai u kotso kutakpa unushi u ni, n u kpaꞋa u ni koɓolo n wa aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ka̱ta̱ wu uta̱ lo a̱ ubuta̱ u katalikalyuka ka Vuzavaguɗu ka̱ta̱ u yaꞋanka kaꞋa kutakpa ku unushi. Wi ta̱ e kukenuku mpasa n kobomburon nu mpasa m ma̱ga̱ji ma, ka̱ta̱ u tsungu a gaɗi va avana a katalikalyuka dem. ");
INSERT INTO asg_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ka̱ta̱ u vishangu mpasa n yoku ɗe n ka̱jivu ka̱ ni ali kucindere, adama a na u bonoko katalikalyuka ka ciɗa ka̱ta̱ we erengu kaꞋa adama a unata u uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","<<A ayin a na baci Haruna u kotsoi kuyaꞋan kutakpa ku unushi o Mololo ma na ma laꞋi n Ciɗa m Ma̱va̱li mo Oɓolo n katalikalyuka, mayun ɗa u tuka̱ m ma̱ga̱ji ma wuma ma. ");
INSERT INTO asg_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Wi ta̱ a kukiyangu ekiye a̱ ni zuva a kaci ka̱ ma̱ga̱ji ka wuma ma. Ka̱ta̱ u dansa e keteshe ra̱ka̱ unushi n ka gbani-gbani ka uma a Isaraila, m menderu me le ra̱ka̱ n ka wasasa feu. Ka̱ta̱ u zuwaka u ɗa ma̱ga̱ji ma a kaci ra̱ka̱, yeve u loko maꞋa a kubana e meremune, n utsura we ekiye u vuza na wi a kuyaꞋan ulinga wa. ");
INSERT INTO asg_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ma̱ga̱ji ma mi ta̱ a kuɗika unushi u uma a Isaraila ra̱ka̱, ka̱ta̱ a̱ ka̱sukpa̱ yi u laza a kubana e meremune, a̱ ubuta̱ u na vuza wi ɗe ba. ");
INSERT INTO asg_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","<<Ka̱ta̱ Haruna u uwa punu a̱ Ma̱va̱li ma, ka̱ta̱ u foɗo aminya a tsuganu a na a yaꞋin n arikinlai kafu u uwa a̱ ubuta̱ u na u LaꞋi n Ciɗa wa, ta ɗe kpamu u kuka̱sukpa̱ a ɗa. ");
INSERT INTO asg_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ka̱ta̱ u sumba̱ m mini ɗe a̱ ubuta̱ u ciɗa wa, ka̱ta̱ u uka aminya a̱ ni. Ka̱ta̱ wu uta̱ pulai u yaꞋan alyuka o kusongu adama a̱ ka̱ci ka̱ ni, n alyuka o kusongu a uma feu, adama a na u takpa unushi u ni n u uma dem. ");
INSERT INTO asg_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Wi ta̱ ta na ke o kusongu ushuma u kuneꞋe ku unushi ka zuva a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Vuma na u ka̱sukpa̱i ma̱ga̱ji ma lazai e meremune a̱ ubuta̱ u Azazel va, mayun ɗa u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini. Ka̱ta̱ u bono a̱ ka̱tsura̱ ka. ");
INSERT INTO asg_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kobomburon m ma̱ga̱ji me kuneꞋe ku unushi ka, n na a̱ tuka̱i nu mpasa n le punu a̱ ubuta̱ u ciɗa adama a kutakpa ku unushi ka, mayun ɗa a̱ uta̱ka̱ le pulai vu ka̱tsura̱ va. I ta̱ o kusongu ukpan u le, n inyama n a̱wiya̱n dem ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Vuma na u songi le va wi ta̱ a̱ kuza̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini kafu u bono punu a̱ ka̱tsura̱ ka. ");
INSERT INTO asg_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","<<Nava wi ta̱ o kokpo ɗa̱ wila̱ u na u kukotso ba. A kanna ka kupa ko wotoi u cindere dem ya kuyaꞋan ta̱ kakuli, ya kuyaꞋan ulinga kpamu ba, ko avu vuza likuci ko komoci ka na ki ida̱shi n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Adama a na a kanna ka nanlo ganu wi ta̱ a kutakpaka ɗa̱ unushi, adama a na o bonoko ɗa̱ ciɗa. Ka̱ta̱ yo okpo aza a babu unata u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Wi ta̱ o kokpo ɗa̱ kanna ka kuvuka tsu kanna ka Ashibi, yi ta̱ feu a kuyaꞋan kakuli. Wila̱ u nampa wi ta̱ o kokpo u na u kukpa̱ɗa̱ kukotso wa̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ganu vu na a zagbai ɗa kpamu a̱ tsunki ni maniꞋin me kerengu adama a na u ka̱na̱ka̱ esheku a̱ ni wo okpo ganu vu gbayin, a̱yi ɗa u kuyaꞋansa kavasa ka kutakpa ku unushi. Wi ta̱ a kuꞋuka aminya a tsuganu. ");
INSERT INTO asg_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Wi ta̱ a kutakpa unushi adama a̱ ubuta̱ u ciɗa, n ubuta̱ u Ma̱va̱li mo Oɓolo n katalikalyuka feu, u yaꞋanka kpamu anan ganu n uma ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Na va wi ta̱ o kokpo ɗa̱ wila̱ u babu uteku, u na i kuyaꞋansa adama a kutakpa ku unushi ku uma a Isaraila a̱ ka̱ya̱ dem.>> Ɗa ta na Musa u yaꞋin nannai derere tsu na Vuzavaguɗu u tonukoi ni. ");
INSERT INTO asg_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","<<YaꞋan kadanshi n Haruna n olobo a̱ ni n uma a Isaraila dem ka̱ta̱ vu dana le. Na ɗa ili i na Vuzavaguɗu u danai. ");
INSERT INTO asg_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Vuma vi Isaraila na baci dem u nekei alyuka a kanaka, ko ka̱giri ko ma̱ga̱ji punu a asuvu a̱ ka̱tsura̱ ka uma ko pulai, ");
INSERT INTO asg_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a na wa̱ tuka̱i a̱ utsutsu u Ma̱va̱li mo Oɓolo tsu kuneꞋe a kubana u Vuzavaguɗu. Vuma vu nanlo wo okpo ta̱ ka uni ka uma, vuza na u tsu lolotongu mpasa. U gaꞋan ta̱ feu e pece yi n uma. ");
INSERT INTO asg_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","I na i zuwai wila̱ u nampa i ɗaɗa, adama a na uma a Isaraila a̱ ka̱sukpa̱ kuyaꞋan alyuka a nnama pulai. U kuzuwa ta̱ uma a̱ tuka̱ n alyuka e le a̱ ubuta̱ u ganu a̱ utsutsu u Ma̱va̱li mo Oɓolo, adama na u neke a ɗa a̱ ubuta̱ u Vuzavaguɗu tsu kuneꞋe ku ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ganu wi ta̱ a kuvishangu mpasa a katalikalyuka ka Vuzavaguɗu a̱ utsutsu u Ma̱va̱li mo Oɓolo, ka̱ta̱ kpamu u songu ushuma wo okpo ma̱gula̱ni mu uyoꞋo a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Uma o kudoku e kuneke alyuka a̱ ubuta̱ wa̱ a̱ma̱li a na a yaꞋin tsu malala ba, ele na uma a ci yaꞋan tsugbani a̱ ubuta̱ u kutono le. Wila̱ u nampa mayun ɗa, u ɗaɗa u na o kutono ali a kubana a tsukaya tsu na tsa̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","<<Dana le, vuma vi Isaraila dem ko komoci ka na ki ida̱shi n ele, ɗa baci u yaꞋin kuneꞋe ku kusongu ko alyuka, ");
INSERT INTO asg_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ɗa u kpamu u kpa̱ɗa̱i kutuka̱ a ɗa a̱ utsutsu u Ma̱va̱li mo Oɓolo adama a na u lyuka u Vuzavaguɗu. Vuma nanlo u gaꞋan ta̱ e pece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","<<Ɗa baci vuma vi Isaraila dem ko komoci ka na ki punu ida̱shi n ele u takumai mpasa n na a laluki, mpa Vuzavaguɗu mi ta̱ a kuyaꞋan tsurala n a̱yi, ka̱ta̱ kpamu m pece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Adama a na wuma wi ili ra̱ka̱ wi ta̱ a mpasa, ɗa kpamu n nekei n ɗa wa̱ ɗa̱ adama a na n ɗa m bonoko ɗa̱ ciɗa a̱ ubuta̱ u Vuzavaguɗu a katalikalyuka, adama a na mpasa n ɗaɗa n kutuka̱ n wuma. ");
INSERT INTO asg_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","I ɗaɗa i zuwai ɗa n danai uma a Isaraila, Ka̱ta̱ i takuma mpasa n na a laluki ba, ko a̱ɗa̱ ko komoci ka na ki ida̱shi n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","<<Ɗa baci kpamu vuza vi Isaraila ko komoci kana ki ida̱shi punu wa̱ ɗa̱ u banai kutambu ɗa wu unai manama ko manunu ma kutakuma, sai u kiɗa maꞋa u va̱ma̱ mpasa ma ka̱ta̱ u ciɗa̱ngu n ɗa n kayala, ");
INSERT INTO asg_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","adama a na wuma wi ili dem ta punu wi a mpasa. I ɗaɗa i zuwai ɗa n danai uma a Isaraila, Ka̱ta̱ i takuma mpasa ba, adama a na wuma wi ili i wuma ra̱ka̱ ta punu wi a mpasa. vuza na baci de dem u yaꞋin nannai i ta̱ e kupece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Yaba dem vu na wi vuza va aza a Isaraila ko komoci ka na baci dem ka takumai ili na i kuwa̱i, ko manama ma na toku wu unai. Mayun ɗa u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini. Ko n nannai wi ta̱ o kokpo n unata ali a kubana kulivi, kafu wo okpo vuza ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ama ɗa baci u iwain kuza̱Ꞌa̱ aminya a̱ ni, ko kpamu u iwain kusumba̱, wi ta̱ a kutakacika adama a̱ unushi u ni.>> ");
INSERT INTO asg_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","<<YaꞋan kadanshi n uma a Isaraila ka̱ta̱ vu dana le, Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ka̱ta̱ i yaꞋan uteku tsu na aza a Masar a ci yaꞋan ba, a̱ ubuta̱ u na yi ishi n ida̱shi. Ka̱ta̱ kpamu i yaꞋan tsu na a ci yaꞋan ɗe a iɗika i KanaꞋana ba, a̱ ubuta̱ u na n kubanka ɗa̱. Ka̱ta̱ i ɗika kuyongo ku le ba. ");
INSERT INTO asg_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","I tono wila̱ u va̱ n kadanshi ka̱ va̱ mayin, mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Tonoi kadanshi ka̱ va̱ n wila̱ u va̱, adama a na vuma na baci u tonoi u ɗa wi ta̱ a̱ kuciya̱ wuma. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","<<Ka̱ta̱ vuza u yaꞋan tsugbani n vuza na i kumaci kute ba. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ka̱ta̱ vu goyo eshevu a̱ ubuta̱ u kuyaꞋan tsugbani n a̱na̱vu ba. A̱na̱vu a ɗa, ka̱ta̱ vu yaꞋan tsugbani n a̱yi ba. ");
INSERT INTO asg_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ka̱ta̱ vi yaꞋan tsugbani n sheku va̱ a̱na̱ku a̱ nu ba. Adama a na nannai wi ta̱ a̱ kutuka̱ n kugoyi we eshevu. ");
INSERT INTO asg_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ka̱ta̱ vi yaꞋan tsugbani n tavu ba, ko mekere me eshevu ko kpamu mekere ma̱ a̱na̱vu, ko a matsa ɗa̱ a kpaꞋa ku te ko a kpaꞋa ku yoku kau. ");
INSERT INTO asg_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ka̱ta̱ vi yaꞋan tsugbani m matsukaya ma̱ nu ko vashi vu nu ba. Nannai wi ta̱ a̱ kutuka̱ wu n kugoyi. ");
INSERT INTO asg_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ka̱ta̱ vi yaꞋan tsugbani m mekere ma na yi tsuna̱ku kakau ba, adama a na tavu ɗa wi feu. ");
INSERT INTO asg_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ka̱ta̱ vi yaꞋan tsugbani n a̱na̱vu e keꞋen ba, adama a na a̱yi feu a̱na̱vu a ɗa. ");
INSERT INTO asg_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ka̱ta̱ vi yaꞋan tsugbani n a̱na̱vu e keꞋen ko mokoshi ma̱ ni ba, adama a na a̱yi va feu a̱na̱vu a ɗa. ");
INSERT INTO asg_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ka̱ta̱ vu goyo eshevu e keꞋen a̱ nu, a̱ ubuta̱ u kuyaꞋan tsugbani n vuka vi ni ba. Adama a na a̱yi feu a̱na̱vu e keꞋen a ɗa wu. ");
INSERT INTO asg_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ka̱ta̱ vi yaꞋan tsugbani n kejene ka̱ nu ba, adama a na a̱yi vuka vu kolobo vu nu ɗa, vi yaꞋan tsugbani n a̱yi ba. ");
INSERT INTO asg_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ka̱ta̱ vi yaꞋan tsugbani n vuka vu mokoshi ma̱ nu ko vangu vu nu ba, nannai wi ta̱ a kuzuwa o okpo n kugoyi. ");
INSERT INTO asg_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ka̱ta̱ vi yaꞋan tsugbani n vuka m mekere ma̱ ni ba. Ka̱ta̱ kpamu vi yaꞋan tsugbani n vashi ni ba, ko ma na mekere ma̱ ni ma matsai ko matsukaya. Dem vi le umaci u te u ɗa yi, kuyaꞋan nannai va ukuna u gbani u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ka̱ta̱ vi ɗika vangu vu vuka vu nu, ali vi yaꞋan tsugbani n a̱yi ba, nannai wi ta̱ a kuzuwa o okpo vuza n sheku vi ni. ");
INSERT INTO asg_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","<<Ka̱ta̱ vu vaku n vuka a ayin a na wi e kene kusumbu ba, adama a na wi ta̱ nu nshinda̱. ");
INSERT INTO asg_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ka̱ta̱ vi yaꞋan tsugbani n vuka vu vuza na yi ida̱shi ɗeɗevu ba. Nannai wi ta̱ a kuzuwa wu vo okpo n nshinda̱. ");
INSERT INTO asg_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ka̱ta̱ vi neke muku n nu tsa alyuka a̱ ubuta̱ u ka̱ma̱li ka na e ci ɗeke Moleka ba, adama a na u gaꞋan vi neke kula ku Ka̱shile ka̱ nu wono ba. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ka̱ta̱ vi yaꞋan tsugbani n tovu vali, tsu na va kuvaku m mavuka ba. Nannai va ili yu unata i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ka̱ta̱ vi yaꞋan tsugbani m manama ba, ta lo va̱ kila̱kpa̱ ka̱ci ka̱ nu. Mavuka feu, ma kuyaꞋan tsugbani m manama ba, nannai va ili yu unata i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","<<Ka̱ta̱ yi ila̱kpa̱ ka̱ci ka̱ ɗa̱ tsu nampa ba, adama a na ta uma a iɗika i na mi o kuloko adama a̱ ɗa̱ i la̱nga̱sa̱i ka̱ci ke le nannai. ");
INSERT INTO asg_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ɗaɗa iɗika ya ra̱ka̱ yo okpoi n unata, ɗa n takacikai i ɗa adama a̱ unushi u ni, ali ta na i lokoi aza a na i punu ida̱shi wa̱ ni ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ama a̱ɗa̱ mayun ɗa i tono wila̱ u va̱ n kadanshi ka̱ va̱. Ka̱ta̱ i yaꞋan ko ili i te a̱ ka̱tsuma̱ ki ili yu unata ya ba, nannai ɗa feu n komoci ka na ki ida̱shi n a̱ɗa̱ ko vuza vu umaci. ");
INSERT INTO asg_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Adama a na aza a na o yongoi iɗika i nanlo n cau a yaꞋansa ta̱ ili i nanlo ya, ɗa iɗika ya yo okpoi n unata. ");
INSERT INTO asg_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ɗa baci yi ila̱kpa̱i iɗika ya, i ɗa yi ta̱ a kuꞋiwan ɗa̱ tsu na i ɗa i iwain aza a na ishi punu kafu a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Vuza na baci u yaꞋin ili yu unata i te a̱ ka̱tsuma̱ ki i ɗa, mayun ɗa vuma nanlo i ta̱ o kuloko yi punu a̱ ka̱tsuma̱ ka uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Tonoi wila̱ u va̱ u na n zuwakai ɗa̱, ka̱ta̱ i yaꞋan ili yu unata i yoku a̱ ka̱tsuma̱ ki ili i na uma a na o yongoi a iɗika ya kafu a̱ɗa̱ a yaꞋansai ba. Ka̱ta̱ yi ila̱kpa̱ ka̱ci ka̱ ɗa̱ a̱ ubuta̱ u kuyaꞋan ki ili yu unata ba. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","<<YaꞋan kadanshi n uma a Isaraila ka̱ta̱ vu dana le, yongoi ciɗa adama a na Mpa Vuzavaguɗu Ka̱shile ka̱ ɗa̱ mi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Yaba dem u cikpa a̱na̱ku a̱ ni n esheku a̱ ni, ka̱ta̱ kpamu u ciɓa n kanna ka Ashibi ka̱ va̱. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ka̱ta̱ i bono kutono a̱ma̱li ko i yimaka ka̱ci ka̱ ɗa̱ a̱ma̱li a̱ iyum ba. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","<<Ayin a na baci yi e kuneke alyuka a ida̱shi i singai u Vuzavaguɗu, nekei a ɗa tsu na a ɗa a̱ kuciya̱ wishi adama a̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","I ta̱ a kutakuma inyama ya a kanna ka na i lyukai i ɗa ko kpamu kayin ka asa baci, i na baci i buwai ali a kanna ka tatsu, i ta̱ o kusongu i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ɗa baci a lyaꞋi a ɗa a kanna ka tatsu, o okpo ta̱ unata, alyuka a i kisa ba. ");
INSERT INTO asg_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Vuza na baci de dem u lyaꞋi a ɗa, atakaci i ta̱ o kokpo a kaci ka̱ ni, adama a na u la̱nga̱sa̱ ta̱ ili i ciɗa i Vuzavaguɗu, Vuma nanlo i ta̱ e kupece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","<<Yi baci a kukyaꞋa ili i na i cimbai, ka̱ta̱ i kyaꞋa ali a kubanka iga̱Ꞌin a ashina a̱ ɗa̱ ba, ko kpamu i tono i ɗaya i na i buwai ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ka̱ta̱ kpamu i bana kuɗayu ka ashina a itacishi a̱ ɗa̱ ba, ko kpamu i ta̱ɗa̱ umaci wu nɗanga u na u yikpa̱i a iɗika ba. ka̱sukpa̱ka̱i aza a unambi n omoci. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","<<Ka̱ta̱ i yaꞋan uboki ba. Ka̱ta̱ i yaꞋan aꞋuwa ba. Ka̱ta̱ i doronoi ba. ");
INSERT INTO asg_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ka̱ta̱ i yaꞋan akucina a aꞋuwa n kula ku va̱ ba, nannai va ɗa i kugoyo kula ku Ka̱shile ka̱ ɗa̱. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","<<Ka̱ta̱ i ya̱nsa̱ vuza na yi ida̱shi koɓolo i fa̱ba̱na̱ ili i ni ba. Ka̱ta̱ i ka̱na̱ katsupu ka vuza na u yaꞋankai ɗa̱ ulinga ali a kubana a kanna ko yoku ba. ");
INSERT INTO asg_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ka̱ta̱ i shika kagulani ko kpamu i shikpa̱ka̱ ka̱yimba̱ kaguta adama a na u ta̱ɗa̱tsa̱ ba, ama pana wovon u Ka̱shile ka̱ ɗa̱. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","<<Ka̱ta̱ i yaꞋansaka kasingai ba, ka̱ta̱ i iwan aza a unambi i kucikpa i ciga aza a̱ uciyi ba. Ama kiɗa afada derere n tovu. ");
INSERT INTO asg_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ka̱ta̱ i ka̱na̱ kuka̱ra̱Ꞌa̱ n i la̱nga̱sa̱i otoku a̱ ɗa̱ n kadanshi ka aꞋuwa ba. Ka̱ta̱ vu dansa kagbanigbani ka na ka kutakacika wuma u tovu ba. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","<<Ka̱ta̱ vu iwan toku nu a̱ ka̱ɗu ba. Ama dansuka tovu mejege adama a na ka̱ta̱ avu feu vi yaꞋan unushi adama a̱ ni ba. ");
INSERT INTO asg_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ka̱ta̱ vu la̱nsa̱ uye u kutsupa ko vu ka̱na̱ tovu a̱ ka̱ɗu ba, ama ciga tovu tsu ka̱ci ka̱ nu. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","<<Tonoi wila̱ u va̱. Ka̱ta̱ i ka̱sukpa̱ ilikuzuwa kakau i zamansanai ba. Ka̱ta̱ i ca̱Ꞌa̱ icuꞋu kakau ali ugboku u re a kashina ke te ba. Ka̱ta̱ i uka motogu ma na a caꞋi n tsugbere kakau ba. ");
INSERT INTO asg_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","<<Ɗa baci vuza u yaꞋin tsugbani n kagbashi ke mekere ka na a̱ ka̱na̱ka̱i ɗe vuza yoku, ama ka̱ta̱ ta na a tsupa a na a̱ uta̱ka̱ yi a ugbashi wa ba. Dem n nannai u gaꞋan ta̱ a takacika le ama ka̱ta̱ a una le ba, adama a na ka̱ta̱ u kotso tsugbashi tsa ba. ");
INSERT INTO asg_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mayun ɗa vuza va u tuka̱ n ka̱giri tsu kuneꞋe adama a katsupu ku unushi, ka̱ta̱ e neke Vuzavaguɗu a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","N ka̱giri ke kuneꞋe adama a katsupu ku unushi ka ɗaɗa ganu u kuyaꞋanka yi kavasa ka kutakpa unushi u Vuzavaguɗu adama a̱ unushi u na u yaꞋin ka̱ta̱ a cinukpaka yi u ɗa. ");
INSERT INTO asg_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","<<Ayin a na baci i uwai a iɗika i KanaꞋana ya ɗa i shikpa̱i nɗanga n kulyaꞋa, i ɗika umaci u le wo okpo ɗa̱ ili yu unata, ali a̱ya̱ a tatsu. A̱ ka̱tsuma̱ ka̱ a̱ya̱ a nanlo a, ka̱ta̱ vuza u lyaꞋa ba. ");
INSERT INTO asg_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A̱ ka̱ya̱ ka̱ na̱shi umaci wa ra̱ka̱ wi ta̱ o kokpo ciɗa, kuneꞋe ku ucikpi u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ama a̱ ka̱ya̱ ka tawun yi ta̱ a kufuɗa kulyaꞋa umaci u le wa. I yaꞋan baci nannai nɗanga n ɗa̱ mi ta̱ a kumatsa n a̱bunda̱i. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","<<Ka̱ta̱ i takuma inyama nu mpasa ba. Ka̱ta̱ i yaꞋan kula̱na̱ ko tsuboci ba. ");
INSERT INTO asg_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ka̱ta̱ i puna a̱nji a na i iga̱Ꞌin ya aci a̱ ɗa̱ ko kpamu ntsa̱ka̱ n ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ka̱ta̱ i ɗana ikyamba i ɗa̱ a ayin a na yi a kpalu ka aza a na a̱ kuwa̱i ɗe ba, ko kpamu i ɗana ikpoko a ikyamba i ɗa̱ ba. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","<<Ka̱ta̱ vu la̱nga̱sa̱ mekere ma̱ nu vu zuwa yi kuyaꞋan tsugbani a̱ ubuta̱ u kutono wa̱ a̱ma̱li ba, ɗa baci vi yaꞋin nannai vu bono ta̱ kutono a̱ma̱li, iɗika ya ra̱ka̱ yi ta̱ a kushana n kawuya. ");
INSERT INTO asg_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ciɓai n kanna ka Ashibi ka̱ va̱, ka̱ta̱ i neke A̱Ꞌisa̱ a̱ va̱ tsugbayin. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","<<Ka̱ta̱ i bono kutono ko oboci ko i la̱nsa̱ a̱ma̱li ba, ta lo a̱ kula̱nga̱sa̱ ɗa̱ n unata. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","<<Cikpai aza e kelime, nekei aza a̱ gba̱ra̱-gba̱ra̱ tsugbayin, ka̱ta̱ kpamu i neke Ka̱shile ka̱ ɗa̱ tsugbayin. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","<<Ɗa baci komoci ka̱ da̱sa̱ngi koɓolo n a̱ɗa̱ a̱ likuci, ka̱ta̱ i takacika yi ba. ");
INSERT INTO asg_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","YaꞋankai ni derere tsu vuza na yi umaci u te. Cigai ni tsu na i kuciga ka̱ci ka̱ ɗa̱, adama a na a̱ɗa̱ feu yi ishi ta̱ o limoci a iɗika i Masar. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","<<Ka̱ta̱ i yaꞋan ulinga n kagisamkpatsu ka aꞋuwa, a̱ ubuta̱ u kugisanku ugaɗi, a̱miki ko ka̱bunda̱i ba. ");
INSERT INTO asg_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kagisamkpatsu ka̱ a̱miki n ku ugaɗi, n ki ili ya̱ a̱bunda̱i, ali n ka̱kunzukpa̱tsu ki ili i na yi mini-mini n ifa dem a yaꞋan ili i mayun. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱ ka na ka̱ uta̱ka̱i ɗa̱ a iɗika i Masar. ");
INSERT INTO asg_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ɓa̱na̱i wila̱ u va̱ koɓolo n kadanshi ka̱ va̱ ra̱ka̱ ka̱ta̱ i tono kaꞋa. Mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","<<Dana aza a Isaraila, vuza vi Isaraila dem ko komoci ka baci ki ida̱shi punu a Isaraila, ɗa baci u nekei maku ma̱ ni alyuka u ka̱ma̱li ka na e ci ɗeke Moleka i ta̱ a kuna yi. Aza a̱ likuci a i ta̱ a kuvara yi n atali ali u kuwa̱. ");
INSERT INTO asg_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mi ta̱ a kuzuwaka vuma nanlo va a̱shi, ka̱ta̱ m pece yi n uma a̱ ni, adama a na u neke ta̱ maku ma̱ ni a̱ ka̱ma̱li ka Moleka, u la̱nga̱sa̱ ta̱ kula ku ciɗa ku va̱ ɗa wi ila̱kpa̱i A̱Ꞌisa̱ a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ɗa baci uma a̱ likuci a a takpai a̱shi e le, a ayin a na vuza va wi e kuneke maku ma̱ ni alyuka a̱ ka̱ma̱li ka Moleka ka, ɗa a̱ kpa̱ɗa̱i kuna yi, ");
INSERT INTO asg_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","mpa mi ta̱ a kutakacika vuma nanlo va n limata i kpaꞋa i ni, ka̱ta̱ m pece yi n uma a̱ ni koɓolo n aza a na o tonoi ni a̱ la̱nga̱sa̱i ka̱ci ke le a̱ ubuta̱ u kutono ku ka̱ma̱li ka Moleka. ");
INSERT INTO asg_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","<<Mi ta̱ a kuyaꞋan tsurala n vuza na dem u bonoi a̱ ubuta̱ u kutono ko oboci n a̱ma̱li, mi ta̱ kpamu e kupece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ka̱na̱i ka̱ci ka̱ ɗa̱ mayin ka̱ta̱ yo okpo ciɗa, adama a na mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ka̱na̱i wila̱ u va̱, ka̱ta̱ i tono u ɗa. Mpa ɗa Vuzavaguɗu na n kubonoko ɗa̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ɗa baci vuza u shikai esheku a̱ ni ko a̱na̱ku a̱ ni, i ta̱ a kuna yi. Adama a na u shika ta̱ esheku a̱ ni n a̱na̱ku a̱ ni, mpasa n ni tana mi ta̱ o kutono yi. ");
INSERT INTO asg_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","<<Ɗa baci vuza u yaꞋin tsugbani n vuka vu vutoku ni, vuza va koɓolo n vuka va dem i ta̱ a kuna le. ");
INSERT INTO asg_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ɗa baci vuza u yaꞋin tsugbani n vuka ve esheku, u goyo ta̱ esheku ta na. Vuza va koɓolo n vuka va i ta̱ a kuna le dem, mpasa mu ukpa̱ n le mi ta̱ o kokpo a kaci ke le. ");
INSERT INTO asg_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ɗa baci vuza u yaꞋin tsugbani n kejene ka̱ ni, dem vu le i ta̱ a kuna le. Adama a na i na a yaꞋin va ili yu unata i ɗa, mpasa mu ukpa̱ n le mi ta̱ o kokpo a kaci ke le. ");
INSERT INTO asg_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ɗa baci vali u yaꞋin tsugbani n toku vali uteku tsu maku ma vuka, dem vu le a yaꞋan ta̱ ili yu unata. Ra̱ka̱ vu le i ta̱ a kuna le, mpasa mu ukpa̱ n le mi ta̱ o kokpo a kaci ke le. ");
INSERT INTO asg_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ɗa baci vuza u zuwai mekere n a̱na̱ku a̱ ni, a yaꞋan ta̱ kagbanigbani. Vuza va koɓolo n a̱ma̱ci a ra̱ka̱ mayun ɗa o songu le n akina ali a̱ kuwa̱, adama a na ka̱ta̱ ka gbani-gbani ka yimkpa a̱ ka̱tsuma̱ ka̱ ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ɗa baci vuza u yaꞋin tsugbani m manama, i ta̱ a kuna yi, ka̱ta̱ feu a una manama ma. ");
INSERT INTO asg_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ɗa baci vuka vu gbagai manama adama a na u yaꞋan tsugbani m maꞋa, vuka va koɓolo m manama i ta̱ a kuna le. Mayun ɗa a una le, mpasa mu ukpa̱ n le mi ta̱ o kokpo a kaci ke le. ");
INSERT INTO asg_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","<<Ɗa baci vuza u zuwai taku ni, mekere me esheku ko ma̱ a̱na̱ku, ali ɗa tana a asai koɓolo, a yaꞋan ta̱ ili i wono. I ta̱ o kuloko le a̱ a̱shi a uma. U neke ta̱ taku ni wono, i ta̱ a kutakacika yi. ");
INSERT INTO asg_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ɗa baci vuza u vaki n vuka a ayin a̱ kusumbu a̱ ni, nannai va u la̱nga̱sa̱ ta̱ tsu na kusumbu ki a nwalu, wu uta̱ka̱ ta̱ kpamu ukuna u kusumbu u ni e keteshe. Dem vu le i ta̱ e kupece le n uma e le. ");
INSERT INTO asg_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Ka̱ta̱ vi yaꞋan tsugbani n vangu va̱ a̱na̱vu ko taku ve eshevu ba, adama a na nannai va wi ta̱ a̱ kutuka̱ n ili i wono a̱ ubuta̱ u kumaci, ra̱ka̱ vi le i ta̱ a kutakacika le. ");
INSERT INTO asg_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ɗa baci vuza u yaꞋin tsugbani n vila̱ku ni, u goyo ta̱ esheku e keꞋen a. Unushi u nanlo wi ta̱ o kutono le, i ta̱ a̱ kukuwa̱ nannai babu limata. ");
INSERT INTO asg_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ɗa baci vuza u zuwai vuka vu mokoshi ma̱ ni a̱yi biꞋi lo n wuma, u yaꞋan ta̱ ili yu unata. U neke ta̱ mokoshi ma̱ ni ma ili i wono, i ta̱ a̱ kukuwa̱ babu muku. ");
INSERT INTO asg_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","<<Ɓa̱na̱i wila̱ u va̱ n kadanshi ka̱ va̱ ra̱ka̱ ka̱ta̱ i tono kaꞋa, adama a na a iɗika i na mi a kubanka ɗa̱ va, ka̱ta̱ i iwan ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ka̱ta̱ i yaꞋan ida̱shi uteku tsu uma a na mi o kuloko a̱ ubuta̱ u na yi a kubana va ba. Adama a na ele va a yaꞋansa ta̱ ili i nampa ya ra̱ka̱, i ɗaɗa i zuwai ɗa n iwain le. ");
INSERT INTO asg_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ama mpa n dana ɗa̱ ta̱ <Yi ta̱ a kisa iɗika i le, mi ta̱ e kuneke ɗa̱ i ɗa yo okpo i ka̱ci ka̱ ɗa̱, iɗika i na yi m maniꞋin n tsuta̱ ka̱u.> Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱, vuza na u zagbai ɗa̱ kau a̱ ka̱tsuma̱ ki iɗika. ");
INSERT INTO asg_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Mayun ɗa i yeve kupece nnama n ciɗa koɓolo n aza a unata, nnu n ciɗa kpamu koɓolo n aza a unata. Ka̱ta̱ yi ilukpa̱ ka̱ci ka̱ ɗa̱ a̱ ubuta̱ u kutakuma nnama mu unata ko nnu, ko ili yu unata i na yi kurono a̱tsuma̱ e le a iɗika, i na mu utuka̱i ɗe kau ba. ");
INSERT INTO asg_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Yi ta̱ a̱ kokpo ciɗa wa̱ va̱, adama a na mpa Vuzavaguɗu mi ta̱ ciɗa, ɗa n zagbai ɗa̱ a̱ ka̱tsuma̱ ka aduniyan yo okpo uma a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","<<Ɗa baci vali ko vuka vi a kuyaꞋan tsuboci nu nkunu a̱ ka̱tsuma̱ ka̱ ɗa̱, i ta̱ a̱ kuna yi. A̱ɗa̱ ɗa ya kuvara yi n atali, mpasa mu ukpa̱ n ni mi ta̱ o kokpo a kaci ka̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Vuzavaguɗu u danai Musa, <<YaꞋan kadanshi n anan ganu, olobo a Haruna, ka̱ta̱ vu dana le ka̱ta̱ ganu u uka ka̱ci ka̱ ni nshinda̱ adama a kusaꞋwa vuma vi ni vi yoku vu na vu kuwa̱i ba, ");
INSERT INTO asg_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","sai ka̱kpisa̱ ka na ki vuza gbagu ni, a̱na̱ku ko esheku a̱ ni, kolobo ko mekere ma̱ ni, ko vuza ni, ");
INSERT INTO asg_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ko taku ni vu na ka̱ta̱ u yevei vali ba, ɗa kpamu katsura ka̱ ni ki wa̱ ni adama a na ka̱ta̱ wi n vali ba. ");
INSERT INTO asg_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ka̱ta̱ wi ilukpa̱ ka̱ci ka̱ ni n vuma vu na wi vuza ni adama a kumaci ku yolo ku na ku ɓolongi le ba. ");
INSERT INTO asg_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ka̱ta̱ anan ganu a puna a̱nji a aci e le, ko a lapula iga̱Ꞌin yi ntsa̱ka̱ n le, ko a ɗana ikyamba i le ba. ");
INSERT INTO asg_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Mayun ɗa o okpo ciɗa u Ka̱shila̱ ke le, kpamu ka̱ta̱ a̱ la̱nga̱sa̱ kula ku Ka̱shila̱ ku le ba. Adama a na ele ɗa e ci neke Vuzavaguɗu kuneꞋe ku na a kuyaꞋan n akina, ilikulya i Ka̱shile ke le. ");
INSERT INTO asg_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ka̱ta̱ a zuwa a̱ma̱ci a na a̱ la̱nga̱shi ka̱ci ke le n tsugbani ba, ko kpamu a̱ ɗa̱nga̱i a̱ ubuta̱ u na ishi o yolo ba, adama a na anan ganu i ta̱ ciɗa a̱ ubuta̱ u Ka̱shile ke le. ");
INSERT INTO asg_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ɗikai le aza ciɗa, adama a na a tsu lyuka ta̱ ilikulya u Ka̱shile ka̱ ɗa̱. Ɗikai le uma a ciɗa, adama a na mpa Vuzavaguɗu mi ta̱ ciɗa. Mpa ɗa vuza na u yaꞋin ɗa̱ ciɗa, vuza na u lyukai ɗa̱ ɗa u zagbai ɗa̱ kau, ci ili i ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ɗa baci mekere ma ganu ma la̱nga̱shi ka̱ci ka̱ ni ɗa wo okpoi kashakanlai, u neke ta̱ dada vi ni wono, I ta̱ o kusongu yi a kina. ");
INSERT INTO asg_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","<<Ganu gbayin, a̱yi na wi kelime n anan ganu a na a buwai, ali ɗa a sukumakai ni maniꞋin me kerengu a kaci, ɗa kpamu u ciya̱i utsura u kuꞋuka motogu ma tsuganu. Ka̱ta̱ u ka̱sukpa̱ ka̱nji ka̱ ni babu uza̱ɗukpi ba, ko kpamu u kara motogu ma̱ ni adama a̱ una̱mgbuka̱tsuma̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ka̱ta̱ u uwa ubuta̱ u na ka̱kpisa̱ ki ba. Ka̱ta̱ u uka ka̱ci ka̱ ni nshinda̱ ba, ko esheku a̱ ni ko a̱na̱ku a ɗa baci a̱ kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ka̱ta̱ u ka̱sukpa̱ A̱Ꞌisa̱ a̱ Ka̱shile u bana u la̱nga̱sa̱ ka̱ci ka̱ ni a̱ ubuta̱ u ka̱kpisa̱ ba, a̱yi wi ta̱ ciɗa adama a maniꞋin me kerengu ma̱ Ka̱shile ka̱ ni, ma na a sukumakai ni a kaci. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Vuka vu na ganu u kuzuwa, wo okpo mekere ma na ka̱ta̱ me yevei vali ba. ");
INSERT INTO asg_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ka̱ta̱ u zuwa vuka vu na vali ni vu kuwa̱i ba, ko vuka vu na vu ɗa̱nga̱i o yolo, ko kpamu vuka vu na vu na̱mgba̱i n tsugbani ba. Ama mekere ma na me yevei vali ba, punu a kumaci ku ni ta na, ");
INSERT INTO asg_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","adama a na ka̱ta̱ u la̱nga̱sa̱ ntsukaya n ni a̱ ka̱tsuma̱ ka kumaci ku ni ba. Mpa ɗa Vuzavaguɗu, vuza na u yaꞋin ni ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Vuzavaguɗu u yaꞋin kadanshi m Musa, ");
INSERT INTO asg_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","<<Dana Haruna adama a ntsukaya n na n kuta̱wa̱, ka̱ta̱ vuza vu usa̱n u yawa ɗevu ka̱ta̱ u neke ilikulya u Ka̱shile ka̱ ni ba. ");
INSERT INTO asg_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Babu vuza vu usa̱n vu na u kuyawa ɗevu n alyuka ka̱ta̱ u lyuka, ko ka̱yimba̱, ko ma̱kutu, ko vuza vu nsa̱ga̱ɗu ko ma̱kutsuma̱. ");
INSERT INTO asg_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Babu vuza vu kune upinda̱ri ko kukiye feu, ");
INSERT INTO asg_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ko vuza vu kokondo, ko megejere kute, ko vuza vu mɓa̱la̱ n a̱shi, ko vuza na wi n iciri, ko n kajakata, ko vuza na a̱ uta̱ka̱i arawa. ");
INSERT INTO asg_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Babu kumaci ka aza a Haruna ganu ku na u kuyaꞋan n usa̱n u yawa ɗevu ali u neke kuneꞋe ku kusongu u Vuzavaguɗu. Adama a na wi ta̱ n usa̱n, ka̱ta̱ u yawa ɗevu u neke ilikulya u Ka̱shile ka̱ ni ba. ");
INSERT INTO asg_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Wi ta̱ a kufuɗa kulyaꞋa ilikulya i na i laꞋi n ciɗa i Ka̱shile ka̱ ni, koɓolo n kuneꞋe ku ciɗa ka feu, ");
INSERT INTO asg_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ko n nannai dem, adama a̱ usa̱n u na wi n u ɗa, ka̱ta̱ u yawa ɗevu n kakashi ku ubuta̱ u ciɗa, ko katalikalyuka ba, adama a na ka̱ta̱ wi ilukpa̱ ubuta̱ u ciɗa u va̱ ba. Mpa ɗa Vuzavaguɗu vuza na u bonokoi le ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ɗa ta na Musa u danai Haruna n olobo ni koɓolo n aza a Isaraila ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","<<Dana Haruna m muku mo olobo n ni e reme kuneꞋe ku na aza a Isaraila e nekei mu va n ekiye e re, adama a na ta lo a̱ kula̱nga̱sa̱ kula ku ciɗa ku va̱. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Dana le, ili i na i ɗikai gogo na ali a kubana ntsukaya n na n kuta̱wa̱, ɗa baci yaba dem a kumaci ku ɗa̱ wi n unata ɗa kpamu u yawai ɗevu n alyuka a ciɗa a na uma a Isaraila i e kuneke Vuzavaguɗu, vuma nanlo wo kudoku kuyawa ɗevu nu mpa ba. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ɗa baci vuza a kumaci ku Haruna wi n ila̱ga̱jishi i gbani-gbani ko mali ma tsali, wi a kulyaꞋa ilikulya i ciɗa ba, sai ayin a na wo okpoi ciɗa. U saꞋwa baci ili i na i kuwa̱i, ko ugapu u loloi ni, wi ta̱ feu o kokpo n unata. ");
INSERT INTO asg_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ko ɗa baci u saꞋwai ili i wuma i na i tsu rono a̱tsuma̱ a iɗika i na yi n unata, ko vuza yoku na wi n unata, ko we ne u ɗa baci, ");
INSERT INTO asg_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","vuza na baci u saꞋwai ili tsu nanlo dem, wi ta̱ o kokpo n unata ali a kubana kulivi. Wa kulyaꞋa kuneꞋe ku ciɗa ba, sai ayin a na u sumba̱i m mini. ");
INSERT INTO asg_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ama kanna ka̱ yikpa̱ baci, wi ta̱ o kubono ciɗa, a ayin a nanlo a ɗa u kufuɗa wa lyaꞋa kuneꞋe ku ciɗa ka, adama a na ilikulyaꞋa i ni i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ka̱ta̱ u takuma agifa ba, ko kpamu ili i na toku manama wu unai ba. Nannai wi ta̱ a kuzuwa yi wo okpo n unata. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Mayun ɗa anan ganu o tono wila̱ u va̱, adama a na ta lo a yaꞋan unushi ka̱ta̱ a̱ kuwa̱ a na a iwain kutono wila̱ u va̱. Mpa ɗa Vuzavaguɗu vuza na u bonokoi ɗa̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","<<Ka̱ta̱ vuza gbani na wi ganu ba u lyaꞋa kuneꞋe ku ciɗa ba, ka̱ta̱ feu komoci ko vuza vu zamalinga vi ni feu a lyaꞋa ba. ");
INSERT INTO asg_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ama ɗa baci ganu u tsulai kagbashi n ikebe i ni, kagbashi ka ki ta̱ a kufuɗa ka lyaꞋa, n yaba dem vu na a matsai a kpaꞋa ku ni wi ta̱ a ku fuɗa ku lyaꞋa. ");
INSERT INTO asg_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ɗa baci mekere ma ganu mo oloi vuza gbani na wi ganu ba, wi a kulyaꞋa ilikulyaꞋa i ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ama ɗa baci mekere ma ganu mo okpoi kagapa, ko wu uta̱i a kpaꞋa ku yolo, ka̱ta̱ kpamu u matsa maku ba, ɗa u bonoi u da̱sa̱ngi a kpaꞋa ku dada ni, uteku tsu na wi ishi mekere ɗe, wi ta̱ a kufuɗa kulyaꞋa ilikulyaꞋa i ciɗa. Ama vuza gbani na wi ganu ba, ka̱ta̱ u lyaꞋa ba. ");
INSERT INTO asg_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Ɗa baci vuza na wi ganu ba u lyaꞋi kuneꞋe ku ciɗa babu u yeve, mayun ɗa u bono u tsupa ganu derere i na u lyaꞋi va, koɓolo n ugana u na u yawai i te a̱ ka̱tsuma̱ ki ili i tawun. ");
INSERT INTO asg_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ka̱ta̱ anan ganu a̱ la̱nga̱sa̱ kuneꞋe ku ciɗa ku na uma a Isaraila a̱ tsu tuka̱ a̱ ubuta̱ u Vuzavaguɗu ba, ");
INSERT INTO asg_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","kuka̱sukpa̱ le a lyaꞋa ilikulya ya, nannai va wi ta̱ a kuzuwa le o ronoko ka̱ci ke le unushi u na a takacika le. Mpa ɗa Vuzavaguɗu, Mpa vu na m bonokoi le ciɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, ");
INSERT INTO asg_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","<<Dana Haruna n olobo a̱ ni koɓolo n uma a Isaraila ra̱ka̱ kadanshi ka nampa. Ɗa baci vuza a̱ ka̱tsuma̱ ka̱ ɗa̱ ko vuza vi Isaraila ko komoci ka na ki punu ida̱shi, ke nekei kuneꞋe adama e kuneꞋe ku kusongu u Vuzavaguɗu, ko adama a na u shatangu akucina ko kuneꞋe ku ucikali, ");
INSERT INTO asg_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","mayun ɗa u neke kobomburon ko ka̱giri ko ma̱ga̱ji, ma babu uꞋiwin u Ka̱shile, adama a na kuneꞋe ku ni ku ciya̱ wishi adama a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ka̱ta̱ i tuka̱ n ili yu usa̱n ba, adama a na Vuzavaguɗu wa kisa a ɗa adama a̱ ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ɗa baci vuza u tuka̱i n ili i kuneꞋe ku ma̱ta̱na̱ u Vuzavaguɗu a ushiga adama a na u shatangu akucina ko kuneꞋe ku ucikali, mayun ɗa vi neke ili i na yi babu uꞋiwin u Ka̱shile adama a na ku ɗa kuciya̱ wishi. ");
INSERT INTO asg_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ka̱ta̱ i neke Vuzavaguɗu manama ma na ma̱ yimba̱na̱i ba, ko ma na mo koɗoi, ko ma na ma uwakai muna, ko ma na mi n kuntsu a ikyamba, ko ila̱nishi, ko a̱ra̱ga̱ji ba, ka̱ta̱ i kiyangu ili i nampa a katalikalyuka uteku tsu kuneꞋe ka akina u Vuzavaguɗu ba. ");
INSERT INTO asg_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Yi ta̱ a kufuɗa kuneke kobomburon ko ka̱giri ka na kune ku na̱mgba̱i tsu kuneꞋe ku ucikali, ama a kisa a ɗa adama e kuneꞋe ku kushatangu akucina ba. ");
INSERT INTO asg_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ka̱ta̱ i neke Vuzavaguɗu manama ma na o ɓosoi arawa ba, ka̱ta̱ i yaꞋan ili i nampa a iɗika i ɗa̱ ba, ");
INSERT INTO asg_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ka̱ta̱ kpamu yi isa icuꞋu yi nnama n nampa e ekiye omoci ka̱ta̱ i yaꞋanka alyuka u Ka̱shile ka̱ ɗa̱ ba. icuꞋu yi nnama i nanlo, a kisa n ɗa adama a̱ ɗa̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ɗaɗa Vuzavaguɗu u danai Musa kpamu, ");
INSERT INTO asg_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","<<A matsa baci medendem, ko maku mo mokyon, ko maku ma maraɗika, mayun ɗa a̱ ka̱sukpa̱ yi n a̱na̱ku a̱ ni ali ayin e cindere, ama ili i na i ɗikai a kanna ka̱ kunla̱i, alyuka a na a yaꞋin n ili i nanlo ya dem yo okpo ta̱ kuneꞋe ku singai ka akina u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ka̱ta̱ i kiɗa ka̱na̱ku m maku ma̱ ni a kanna ke te ba. ");
INSERT INTO asg_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Vi baci a kulyuka kuneꞋe ku ucikpi u Vuzavaguɗu, ka̱ta̱ vi yaꞋan a ɗa mayin uteku tsu na a ɗa a̱ kuciya̱ wishi adama nu. ");
INSERT INTO asg_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","A kanna ka nanlo ka ɗaɗa a kutakuma inyama ya ra̱ka̱, ka̱ta̱ i ka̱sukpa̱ kagimi ali kayin washi ba. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","<<Mayun ɗa i ka̱na̱ wila̱ u va̱ n ka̱ɗu ke te, ka̱ta̱ i tono u ɗa. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ka̱ta̱ i la̱nga̱sa̱ kula ku ciɗa ku va̱ ba, nannai ɗa aza a Isaraila e kuyeve mu a na mi ciɗa. Mpa ɗa Vuzavaguɗu na u bonokoi ɗa̱ ciɗa, ");
INSERT INTO asg_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","vuza na kpamu wu uta̱ka̱i ɗa̱ a iɗika i Masar adama a na mo okpo Ka̱shile ka̱ ɗa̱. Mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, ");
INSERT INTO asg_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","<<YaꞋan kadanshi n uma a Isaraila ka̱ta̱ vu dana le, na ɗa ka̱ɗiva̱ ku uzagbi ka̱ va̱, ka̱ɗiva̱ ku uzagbi ka Vuzavaguɗu, ka na i kuɗika ko okpo kanna ka gbayin, adama o oɓolo a ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","<<Yi ta̱ n ayin a̱ ta̱li a na ya kuyaꞋan ulinga, ama kanna ke cindere kanna ka Ashibi kaꞋa ka kuvuka mayin, kanna ka ciɗa ka na i kuyaꞋan oɓolo. Ka̱ta̱ i yaꞋan ulinga ba, a̱ ubuta̱ u na baci de dem yi, kanna ka Ashibi ka Vuzavaguɗu kaꞋa. ");
INSERT INTO asg_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","<<Nava ele ɗa ka̱ɗiva̱ kakau ka na Vuzavaguɗu u zagbai, ka̱ɗiva̱ ka ciɗa ka na ya kusala a ayin a na a zuwai a yaꞋansa kaꞋa. ");
INSERT INTO asg_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","A kanna ka kupa n ka̱ na̱shi ko wotoi u iyain n kulivi, ɗaɗa kanna ka na a̱ kugita̱ ka̱ɗiva̱ ka Kupasamgbanai ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ka̱ta̱ a kanna ke gendu ko wotoi ka, ka ɗaɗa kanna ka na a̱ kugita̱ Ka̱ɗiva̱ ko Boroji vu babu yisiti. Ka̱ɗiva̱ ka nampa ka Vuzavaguɗu ki ta̱ a kuyaꞋan ali ayin e cindere, ka̱ta̱ a̱ ka̱tsuma̱ ka ayin a nanlo boroji vu na i kutakuma dem vi yaꞋan babu yisiti. ");
INSERT INTO asg_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","A kanna ka iyain ka̱ ka̱ɗiva̱ ka, uma ra̱ka̱ a yaꞋan oɓolo a ciɗa, ka̱ta̱ a̱ ka̱sukpa̱ ulinga u na a kiwanai kuyaꞋansa. ");
INSERT INTO asg_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ama i neke kuneꞋe ku kusongu u Vuzavaguɗu ali ayin e cindere. Ka̱ta̱ a kanna ke cindere i yaꞋan oɓolo a ciɗa, i yaꞋan ulinga u na i kiwanai ba.>> ");
INSERT INTO asg_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","<<YaꞋan kadanshi n aza a Isaraila, ka̱ta̱ vu dana le, ayin a na baci i uwai a iɗika i na mi a kuciga me neke ɗa̱, ɗa i kyaꞋi ili ya ashina, ka̱ta̱ i tuka̱ ganu m makatalu ma na i gita̱i kushiya va. ");
INSERT INTO asg_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ashibi a laza baci a kanna ke ire, ganu u ɗengusa̱ makatalu ma zuva a̱ ubuta̱ u Vuzavaguɗu adama a na ma̱ ciya̱ wishi adama a̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A kanna ka na i ɗengusa̱i makatalu ma, yi ta̱ a kulyuka ka̱giri ka̱ ka̱ya̱ ke te ka na ki babu uꞋiwin u Ka̱shile tsa alyuka o kusongu u Vuzavaguɗu, ");
INSERT INTO asg_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","koɓolo n kuneꞋe ki ishina i ifa vi re vi kiya ku singai ku na a satarai m maniꞋin ma zaitu, alyuka a ɗa a na a yaꞋin n akina u Vuzavaguɗu, ili i ma̱gula̱ni i singai a kubana u Vuzavaguɗu. I ta̱ kpamu e kuneke alyuka a ili i kusoꞋo a̱ ma̱diki me te ma̱ ma̱kya̱n. ");
INSERT INTO asg_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ka̱ta̱ i takuma boroji vu na a yaꞋin n ishina i savu, ko yu uzungi ba, sai a kanna ka na i tuka̱i biꞋi n kuneꞋe ku ɗa̱ ku nampa a̱ ubuta̱ u Ka̱shile ka̱ ɗa̱. Na va wila̱ u ɗa u na u kukotso ba ali a kubana wu ntsukaya n ɗa̱, ko te ɗai yi ida̱shi. ");
INSERT INTO asg_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","<<Ana kanna ka Ashibi ka kuvuka ka lazai, a kanna ke ire ka na vu tuka̱i m makatalu ma na a̱ ɗengusa̱i adama e kuneꞋe, i ta̱ kukece kuden ku cindere derere. ");
INSERT INTO asg_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","I kece ayin amangerenkupa, a kanna ke ire ka Ashibi e cindere, i neke Vuzavaguɗu kuneꞋe ki ishina i savu kpamu. ");
INSERT INTO asg_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ko te ɗai yi o kuyongo i tuka̱ n a̱kutsu ere o boroji adama a na e neke Vuzavaguɗu tsu kuneꞋe ku singai ku kuɗa̱ngusa̱. Ka̱kutsu ko boroji dem yi ta̱ a kuyaꞋan kaꞋa n kiya ku singai ku ifa vi re usatari n yisiti, ka̱ta̱ a yaꞋanka alyuka a ili i na i vaꞋinkai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Koɓolo m boroji va, i neke a̱giri e cindere yaba dem u yawa ka̱ya̱ ke te, ka̱ta̱ kpamu ka yaꞋan babu uꞋiwin u Ka̱shile, n kobomburon ushan u kenu ke te n a̱giri ere. A yaꞋanka a ɗa kuneꞋen ku kusongu u Vuzavaguɗu, koɓolo n kuneꞋen ki ishina, n ki ili i kusoꞋo, m ma̱gula̱ni ma singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ka̱ta̱ i neke kuneꞋe ku ma̱ga̱ji me te adama e kuneꞋe ku unushi, koɓolo n a̱giri e re a na a yawai ka̱ya̱ kete-kete tsu kuneꞋe ku ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ka̱ta̱ ganu u ɗengusa̱ a̱giri ere a tsu kuneꞋe u Vuzavaguɗu koɓolo m boroji vi ili i na i gita̱i kugeꞋwe va. KuneꞋe ku ɗa ku ciɗa ku ganu a kubana u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","A kanna ka nanlo ka ka̱ta̱ i sala koɓolo ka ciɗa ka̱ta̱ kpamu i yaꞋan ulinga u na i kiwanai ba. Na va wi ta̱ o kokpo ɗa̱ wila̱ ali nu ntsukaya n na n kuta̱wa̱, n ubuta̱ dem u na i da̱sa̱ngi. ");
INSERT INTO asg_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","<<A ayin a na baci i kyaꞋi ili ya ashina i ɗa̱, ka̱ta̱ i kyaꞋa ali a kubana iga̱Ꞌin ya ashina a̱ ɗa̱ ko i ɗaya ba. Ka̱sukpa̱ka̱i aza a unambi n omoci. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, ");
INSERT INTO asg_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","<<Dana uma a Isaraila a kanna ka iyain ko wotoi u cindere, yi ta̱ a kuvuka, ɗa baci i panai a̱ lika̱i ishari, ka̱ta̱ i yaꞋan oɓolo a ciɗa i neke kuneꞋe a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ka̱ta̱ i yaꞋan ulinga uteku tsu na i kiwanai ba, ama i neke kuneꞋe ku kusongu u Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","<<A kanna ka kupa ko wotoi u cindere wa ki ta̱ o kokpo kanna ka kutakpa unushi, ki ta̱ o kokpo ɗa̱ kanna ko oɓolo ka singai. Yi ta̱ a kuyaꞋan kakuli ka̱ta̱ i neke kuneꞋe ku na o kusongu n akina a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ka̱ta̱ i yaꞋan ulinga a kanna ka nanlo ka ba, adama a na kanna ka kanna ka kutakpa unushi kaꞋa, kanna ka na a kutakpaka ɗa̱ unushi u ɗa̱ a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Vuza na baci dem u kpa̱ɗa̱i kuyaꞋan kakuli a kanna ka nanlo ka, i ta̱ e kupece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mi ta̱ a kuna vuza na de dem u yaꞋin ulinga a kanna ka nanlo. ");
INSERT INTO asg_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ka̱ta̱ i yaꞋan ulinga ba ko kenu. Na va wi ta̱ o kokpo ɗa̱ wila̱ u gbayin u na i kutono ali a kubana ntsukaya n na n kuta̱wa̱ kelime, ko te ɗai baci i da̱sa̱ngi dem. ");
INSERT INTO asg_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kanna ka Ashibi kaꞋa ka kuvuka ka̱ ɗa̱, ka̱ta̱ i yaꞋan kakuli. I gita̱ngu n kulivi ka kanna ka̱ kuci ko wotoi ka, ali a kubana a̱ kulivi ku yoku.>> ");
INSERT INTO asg_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ɗaɗa Vuzavaguɗu u danai Musa kpamu, ");
INSERT INTO asg_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","<<Dana uma a Isaraila, A kanna ke gendu ko wotoi u cindere ɗaɗa a̱ kugita̱ Ka̱ɗiva̱ ka̱ Ma̱va̱li ma̱ Ka̱shile, i ta̱ a kuyaꞋan kaꞋa ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","A kanna ka iyain, ɗaɗa i kuyaꞋan oɓolo a ciɗa. Ka̱ta̱ i yaꞋan ulinga u na i kiwanai kuyaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ali ayin e cindere a̱ɗa̱ e kuneke kuneꞋe ku na a kuyaꞋan n akina u Vuzavaguɗu. A kanna ka̱ kunla̱i yi ta̱ a kuyaꞋan oɓolo a ciɗa, ka̱ta̱ i yaꞋan kuneꞋe ku na a yaꞋin n akina u Vuzavaguɗu. Na va wi ta̱ o kokpo oɓolo a singai a na i kuyaꞋan kucikpa, yi a kuyaꞋan ulinga u ɗa̱ u na i kiwanai ba. ");
INSERT INTO asg_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","<<Na va ele ɗa ka̱ɗiva̱ kakau ka Vuzavaguɗu ka na u zagbai kokpo ka̱ɗiva̱ ka ciɗa ka̱ kutusa̱ka̱ n kuneꞋe ku na a yaꞋin n akina u Vuzavaguɗu, kuneꞋe ku kusongu, n kuneꞋe ki ishina, koɓolo kpamu n alyuka n kuneꞋe ki ili i kusoꞋo ku na ku gaꞋin a yaꞋan a kanna dem. ");
INSERT INTO asg_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","KuneꞋe ku nampa ili i ɗa i na o doki punu a̱ ka̱tsuma̱ ka̱ ka̱ɗiva̱ kakau ka kanna ka Ashibi. Koɓolo kpamu n kuneꞋe ku ɗa̱ n i na dem i yaꞋin uzuwakpani, koɓolo n kuneꞋe ku ma̱ta̱na̱ ku na i kuneke Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","<<Ili i na i gita̱i a kanna ke gendu ko wotoi u cindere wana ɗai i kotso kuɓolongu ili ya ashina i ɗa̱, yaꞋin ka̱ɗiva̱ ka adama a Vuzavaguɗu ali ayin e cindere. Kanna ka iyain kanna ka Ashibi ka kuvuka kaꞋa, a kanna ka̱ kunla̱i ka̱ ka̱ɗiva̱ ka, kanna ka kuvuka kaꞋa. ");
INSERT INTO asg_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A kanna ka iyain i taɓa umaci wu nɗanga n singai, koɓolo n ekeme a maɗanga ma mashuwa, koɓolo kpamu n acaka a nɗanga a na i n a̱vuku n a̱bunda̱i, n acaka a nɗanga n na mi a̱ ka̱kina̱ ke kuyene, ka̱ta̱ i ka̱na̱ kuyaꞋan ma̱za̱nga̱ a̱ ubuta̱ u Vuzavaguɗu ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","I yaꞋan ka̱ɗiva̱ ka nampa u Vuzavaguɗu ali ayin e cindere a̱ ka̱ya̱ dem. Na va wi ta̱ o kokpo wila̱ u na u kukotso ba ali sai ntsukaya n na n kuta̱wa̱ kelime, i yaꞋan ka̱ɗiva̱ ka nampa o wotoi u cindere. ");
INSERT INTO asg_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","A̱ ka̱tsuma̱ ka ayin e cindere a̱ ka̱ɗiva̱ ka nanlo, ele na i muku mi Isaraila ra̱ka̱ i ta̱ a̱ kuda̱sa̱ngu a̱ nva̱li. ");
INSERT INTO asg_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Na wi ta̱ a kuzuwa ntsukaya ma aza a Isaraila n na n kuta̱wa̱ dem n ciɓa, a na mpa ɗa n zuwai ikaya i le i yongoi a̱ nva̱li, a ayin a na mu uta̱ka̱i le a iɗika i Masar. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ɗa Musa u salakai aza a Isaraila ka̱ɗiva̱ kakau ka na Vuzavaguɗu u zuwai. ");
INSERT INTO asg_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","<<Dana uma a Isaraila a̱ tuka̱ wu m maniꞋin ma singai ma zaitu ma na a lapulai adama a̱ nkuni mu ubuta̱ u Ma̱va̱li ma ciɗa, ciya̱ a tasuku n ɗa ka̱ta̱ n lyaꞋa kelime n kuka̱na̱. ");
INSERT INTO asg_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","N kulivi lakam Haruna u kuyongo ta̱ a kutasuku nkuni ma a̱ ubuta̱ u Vuzavaguɗu ali a kubana kayin washi, e kelime ko mololo ma asuvu ma na ma kpadai Akpati vu Uzuwakpani va, ma na mi a̱ ubuta̱ u na u LaꞋi n Ciɗa. Na va wila̱ u ɗa u na u kukotso ba, ali a kubana ntsukaya n na n kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Makyan dem u yongo a̱ kula̱na̱ nkuni n na mi ukiyangi a kashamkpatsu ka azanariya a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","<<Ɗika kiya ku singai, ka̱ta̱ vu yaꞋan a̱kutsu o boroji kupa n ere, ka̱kutsu dem ki ta̱ a kuɗika kiya ku na a̱bunda̱i a̱ ni a yawai ifa vi re. ");
INSERT INTO asg_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ka̱ta̱ vu gere le adaru e re, a̱kutsu a̱ ta̱li a̱ ta̱li a gaɗi vu kirukpa ku na a yaꞋin n azanariya, a zuwa e kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","A kadaru dem vu zuwa ili i ma̱gula̱ni i singai i na i kokpo ili i kuciɓasa a una̱ u boroji va tsu kuneꞋe ku na a yaꞋin n akina u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Boroji vu nampa ganu wi ta̱ a̱ kutuka̱ n vu ɗa a̱ ubuta̱ u Vuzavaguɗu a kanna ka Ashibi dem, adama a uma a Isaraila, ɗaɗa u kokpo wila̱ u na u kukotso ba. ");
INSERT INTO asg_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Vu ɗa vi ta̱ o kokpo vu Haruna n olobo a̱ ni, i ta̱ a kutakuma vu ɗa a̱ ubuta̱ u ciɗa, adama a na ugboku u nanlo u ɗaɗa u laꞋi n ciɗa wu upecu u le u ayin dem. KuneꞋe ku ɗa feu ku na a yaꞋin n akina ɗa e nekei Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Kanna ke te, vuma vi yoku vu na a̱na̱ku a̱ ni vuza va aza a Isaraila, esheku tamkpamu vuza va aza a Masar, u banai wa aza a Isaraila ɗa vishili vu ɗa̱nga̱i n a̱yi n aza a Isaraila a̱ ka̱tsura̱ ka ɗe. ");
INSERT INTO asg_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ɗa kolobo ka vuka va aza a Isaraila ka yaꞋin kadanshi ki ishikushi u Kula ku Vuzavaguɗu, ɗa a̱ tuka̱i n a̱yi a̱ ubuta̱ u Musa. Kula ka̱ a̱na̱ku ku ɗaɗa Shilomitu, mekere ma Dibiri a umaci u Dan. ");
INSERT INTO asg_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ɗa a gbagurai ni a kuvana ili i na Vuzavaguɗu u kudana le a yaꞋan adama a̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","<<Ɗikai vuma na u yaꞋin kadanshi ki ishikushi ka i banka oyonto. Ka̱ta̱ aza a na a panakai ni a kuyaꞋan ishikushi ya a kiyangu ekiye e le a kaci ka̱ ni adama a na pana ta̱ unushi u na u yaꞋin, yeve koɓolo ka uma ka ra̱ka̱ a vara yi n atali. ");
INSERT INTO asg_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Dana uma a Isaraila, vuza na baci u yaꞋin kadanshi ki ishikushi a kubana u Ka̱shile ka̱ ni, i ta̱ a kutakacika yi adama a̱ unushi u ni. ");
INSERT INTO asg_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Vuza na baci kpamu u yaꞋin kadanshi ki ishikushi a̱ ubuta̱ u Vuzavaguɗu, mayun ɗa a una yi. Uma ra̱ka̱ a vara yi n atali. Ko komoci, ko vuza likuci, u yaꞋan baci de kadanshi ki ishikushi u kula ku Vuzavaguɗu i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","<<Vuza na kpamu wu unai vuma, a̱yi feu i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Vuza na kpamu dem wu unai ilikuzuwa i vuza, wi ta̱ o kubonoko n ilikuzuwa i yoku i wuma. ");
INSERT INTO asg_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ɗa baci vuza u ukai toku m muna, ili i na u yaꞋin va a̱yi feu a yaꞋanka yi nannai, ");
INSERT INTO asg_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ukoɗi a tsupa n ukoɗi, ka̱shi feu a tsupa n ka̱shi, kanga a tsupa n kanga. Uteku u na u ukai toku muna, a̱yi feu ta a ku uka yi nannai. ");
INSERT INTO asg_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Vuza na kpamu dem wu unai ilikuzuwa i vuza, wi ta̱ o kubonoko n ilikuzuwa i yoku. Ama vuza na baci wu unai toku a̱yi feu i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Wila̱ u te u ɗa u kuka̱na̱ omoci n aza a̱ likuci dem, adama a na mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa.>> ");
INSERT INTO asg_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ana Musa u kotsoi kuyaꞋan kadanshi n uma a Isaraila, ɗa a ɗikai vuza na u yaꞋin kadanshi ki ishikushi ka a̱ ka̱ra̱ka̱i oyonto, ɗa a varai ni n atali ali u kuwa̱i. Aza a Isaraila a yaꞋin derere tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ɗaɗa Vuzavaguɗu u danai Musa a Kusan ku Sinai, ");
INSERT INTO asg_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","<<YaꞋan kadanshi n uma a Isaraila, ka̱ta̱ vu dana le, a ayin a na baci i uwai a iɗika i na mi e kuneke ɗa̱ va, mayun i ka̱sukpa̱ iɗika ya yu uvuka a̱ ka̱ya̱ ke cindere dem, adama a na e neke Vuzavaguɗu tsugbayin. ");
INSERT INTO asg_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","A̱ya̱ a̱ ta̱li a̱ɗa̱ a kucimba ashina a̱ ɗa̱, a̱ya̱ a̱ ta̱li punu feu a̱ɗa̱ a kulapula ashina a nɗanga mi itacishi n ɗa̱, ka̱ta̱ i kyaꞋa a ɗa. ");
INSERT INTO asg_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ama a̱ ka̱ya̱ ke cindere, i ka̱sukpa̱ iɗika ya yu uvuka, adama a na i neke mu tsugbayin mpa Vuzavaguɗu vu ɗa̱. Ka̱ta̱ i cimba ashina a̱ ɗa̱ ko kpamu i lapula ashina a nɗanga mi itacishi a̱ ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ka̱ta̱ i kyaꞋa uta̱ci ko kpamu i taꞋa mambulu a nɗanga n na i kpa̱ɗa̱i kulapula ba, adama a na ka̱ya̱ ka na iɗika i kuvuka mayun ka ɗaɗa. ");
INSERT INTO asg_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","I na de dem iɗika ya i matsai a̱ ka̱ya̱ ka kuvuka ka Ashibi, i kokpo ta̱ ilikulya i nu, n agbashi a̱ nu a̱ma̱ci n ali, koɓolo n aza a zamalinga, n omoci a na i punu ida̱shi n avu, ");
INSERT INTO asg_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","koɓolo n ilikuzuwa i nu, nu nnama n kakamba dem. Ili i na baci de dem iɗika ya i matsai i ɗa yi ta̱ a kuyaꞋan kulyaꞋa. ");
INSERT INTO asg_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","<<Vuzavaguɗu u danai, yi ta̱ e kukece a̱ya̱ a kuvuka e cindere, o kudokusu kucindere ali kucindere, ɗaɗa a̱ya̱ amangere n kuci derere. ");
INSERT INTO asg_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","A kanna ka kupa, ko wotoi u cindere, kanna ka kucinukpa n unushi kaꞋa, yi ta̱ a̱ kulika̱ kavana ka̱u ko te ɗai punu a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","I ɗika ka̱ya̱ ka amangerenkupa ka nampa kokpo ka ciɗa. Ka̱ta̱ i sala uba̱ruwi a iɗika ya dem n aza a na i punu ida̱shi feu. Wi ta̱ o kokpo ka̱ya̱ ka̱ ma̱za̱nga̱ wa̱ ɗa̱ dem. Yaba dem wi ta̱ o kubono a iɗika i na yi i ka̱ci ka̱ ni yi ikaya i ni, n ubuta̱ u kumaci u ni. ");
INSERT INTO asg_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ka̱ya̱ ka nampa ki ta̱ o kokpo ɗa̱ ka̱ya̱ ku uciyi uba̱ruwi wa̱ ɗa̱. A̱ ka̱ya̱ ka nampa ka ka̱ta̱ i yaꞋan vica̱Ꞌa̱, ko i kyaꞋa kpamu uta̱ci ba, ko kpamu i ɓolongu mambulu a nɗanga n na i kpa̱ɗa̱i kulapula ba. ");
INSERT INTO asg_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Adama a na ka̱ya̱ ku uba̱ruwi ka̱ ɗa̱ kaꞋa, yi ta̱ a kuciɓa n kaꞋa mayin. Ama yi ta̱ a kulya uta̱ci a na ashina a̱ ɗa̱ a matsai koci. ");
INSERT INTO asg_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","<<A ka̱ya̱ ku uba̱ruwi ka nampa, yaba dem u bono a iɗika i ni. ");
INSERT INTO asg_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ɗa baci vuza u tsulai, ko kpamu u denkei vuza ni vuza va aza a Isaraila ubuta̱, ka̱ta̱ a lyaꞋanai ba. ");
INSERT INTO asg_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ɗa baci vuza wa kutsula ubuta̱ u vuza na i ida̱shi ɗeɗevu, vu zuka n ka̱bunda̱i ka̱ a̱ya̱ ka na va kuyaꞋanka ulinga n iɗika ya kafu ka̱ya̱ ku uba̱ruwi ka ko bono. ");
INSERT INTO asg_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ɗa baci a̱ya̱ a na a buwai kafu ka̱ya̱ ku uba̱ruwi ko bono i gbayin ba, i ta̱ e kujebe ikebe ya, adama a na i ta̱ e kudenke wu derere n a̱ya̱ a na va kuyaꞋan ulinga punu va. ");
INSERT INTO asg_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ka̱ta̱ i lyaꞋanai ba, ama panai wovon u Ka̱shile ka̱ ɗa̱, adama a na Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","<<Ɗa baci i tonoi kadanshi ka̱ va̱ m wila̱ u va̱, yi ta̱ a̱ kuda̱sa̱ngu m ma̱ta̱na̱ a iɗika ya. ");
INSERT INTO asg_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ka̱ta̱ iɗika i matsa ka̱u, yi ta̱ a kulyaꞋa i cuwa̱ mayin, ka̱ta̱ i da̱sa̱ngi m ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ama yi ta̱ a kufuɗa kece, <Yiɗa̱i tsa kulyaꞋa a̱ ka̱ya̱ ke cindere ka kuvuka, ci cimba baci ba ɗa kpamu ci kyaꞋi ba?> ");
INSERT INTO asg_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mpa mi ta̱ a kuzuwaka ɗa̱ una̱singai a̱ ka̱ya̱ ka̱ ta̱li, tsu na iɗika ya i kumatsa ka̱u ka̱ta̱ i lyaꞋatangu ɗa̱ ali a̱ya̱ a tatsu. ");
INSERT INTO asg_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","A ayin a na baci i cimbai a̱ ka̱ya̱ ka̱ kunla̱i ka, yi ta̱ o kuyongo a kulyaꞋa i ɗa ali sai ayin a na i savu i ka̱ya̱ ka̱ kuci i yawai. ");
INSERT INTO asg_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","<<Ka̱ta̱ i denge iɗika ya ra̱ka̱-ra̱ka̱ ba, adama a na iɗika ya i va̱ i ɗa. A̱ɗa̱ kpamu omoci a ɗa yi wa̱ va̱, aza a na i ida̱shi a kucimbasa ubuta̱ wa. ");
INSERT INTO asg_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Iɗika i na de dem i ka̱na̱i yo okpoi i ɗa̱, yi baci e kudenge i ɗa ye ece aza a̱ ubuta̱ a ko i ta̱ a̱ kushiba̱ i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","<<Ɗa baci vuza yoku a̱ ka̱tsuma̱ ka̱ ɗa̱ wo okpoi n unambi, ali ɗa u pecei iɗika i ni ɗa u dengei, to vuza yoku a̱ ka̱tsuma̱ ka uma a̱ ni u tsulasaka i na u dengei va. ");
INSERT INTO asg_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ɗa baci vuza na u dengei iɗika ya wi babu vuza ni vu na u kushiba̱ iɗika ya, ama ɗa u ta̱wa̱i u ciya̱i utsura u na wa kufuɗa wa̱ shiba̱ iɗika ya n ka̱ci ka̱ ni, ");
INSERT INTO asg_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","sai u kece ka̱bunda̱i ka̱ a̱ya̱ a na a yaꞋin, ka̱ta̱ u bonoko n kagimi ki ikebe ka na ka buwai u vuza na u denkei ubuta̱ wa, ka̱ta̱ u bono u ka̱na̱ ubuta̱ u ni. ");
INSERT INTO asg_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ama ɗa baci u ciya̱i ikebe i na wa kutsupaka ba, to vuza na u tsulai iɗika ya wi ta̱ a kulyaꞋa kelime n kucimba iɗika ya, ali sai ka̱ya̱ ka amangerenkupa ka ku uba̱ruwi ka yawa. A̱ ka̱ya̱ ka nampa ka ɗaɗa o kubonoko vuma va n iɗika i ni. ");
INSERT INTO asg_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","<<Ɗa baci vuza u dengei kpaꞋa a̱ ka̱tsuma̱ ka̱ likuci i na yi ukanji m mashilya, wi ta̱ a kufuɗa wa̱ tsulasaka ku ɗa a̱ ka̱ya̱ ku uboni ka na u dengei ku ɗa punu a̱ ka̱ya̱ ka nanlo ka, wi ta̱ n utsura u tsulasaka ku ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ama ɗa baci ka̱ya̱ ka shanai ali ka pasai babu na u fuɗai u tsulasakai kpaꞋa ka, kpaꞋa ku ukanji m mashilya ka ki ta̱ o kokpo ku vuza n na u tsulai ku ɗa va nu ntsukaya n ni. O kubonoko yi kpaꞋa ka a̱ ka̱ya̱ ka amangerenkupa ka ba. ");
INSERT INTO asg_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ama iꞋuwa i wawaꞋa a̱ likuci i kenkeꞋen babu ukanji ni nshilya, na lo okpo ta̱ likuci ya abali. I ta̱ a kufuɗa ku tsulasaka kpamu i ɗa, ka̱ta̱ o bonoko i ɗa a̱ ka̱ya̱ ka amangerenkupa ku uciyi wu uba̱ruwi. ");
INSERT INTO asg_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Aza e Levi i ta̱ n utsura u na a tsulasaka iꞋuwa i le a̱ likuci i le, a ayin dem. ");
INSERT INTO asg_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Vuza va aza e Levi vi yoku u denge baci kpaꞋa punu a̱ likuci i nampa ya, ɗa a fuɗai a tsulasakai ku ɗa ba, mayun ɗa o bonoko n ku ɗa a̱ ka̱ya̱ ku uciyi uba̱ruwi, adama a na iꞋuwa i na aza e Levi i n i ɗa i ka̱ci ke le i ɗa a̱ ubuta̱ wa aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ama ubuta̱ u kalina u na wi punu a̱ likuci i le ya dem, e kudenge u ɗa ba, adama a na ubuta̱ u le u ɗa u na wi u ka̱ci ke le. ");
INSERT INTO asg_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","<<Ɗa baci vuza yoku vu ɗa̱ vuza va aza a Isaraila wi n unambi ali ɗa u kpa̱ɗa̱i kpamu kufuɗa kuɓa̱nka̱ ka̱ci ka̱ ni, ɓa̱nka̱i ni tsu na i kuyaꞋan n komoci ko vuza na u ta̱wa̱i babu kushamgba ka̱u, adama a na u lyaꞋa kelime n kuyongo n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ka̱ta̱ i la̱nsa̱ kodokpotsu ko ili i na i kuꞋuwa ɗa̱ punu adama a̱ ni ba. Ama panai wovon u Ka̱shile u ɗa̱, adama a na vuza vu likuci i ɗa̱ u lyaꞋa kelime n kuyongo n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ka̱ta̱ i neke yi okopu e ikebe n kodokpotsu punu ba, ko i denke yi ilikulya n i na i kuꞋuwa ɗa̱ punu ba. ");
INSERT INTO asg_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱, vuza na wu uta̱ka̱i ɗa̱ a iɗika i Masar, ka̱ta̱ n neke ɗa̱ iɗika ya aza a KanaꞋana, ka̱ta̱ kpamu mo okpo Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","<<Ɗa baci vuma te a̱ ka̱tsuma̱ ka aza a̱ ɗa̱ wo okpoi vuza vu unambi, ali ɗa u dengei ka̱ci ka̱ ni wa̱ nu, ka̱ta̱ vu takacika yi u yaꞋan ulinga tsu kagbashi ba. ");
INSERT INTO asg_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Vi ta̱ a kuɗika yi wo okpo an vuza zamalinga wa̱ nu, ko kpamu vuza na wi ida̱shi n avu makyan kenu. Wi ta̱ a kuyaꞋanka wu ulinga ali a̱ya̱ amangerenkupa ku uciyi wu uba̱ruwi. ");
INSERT INTO asg_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","A ayin a nanlo a̱yi va m muku n ni i ta̱ a̱ kuka̱sukpa̱ le, ka̱ta̱ a laza a kubana a̱ ubuta̱ wu umaci u ni, a̱ ubuta̱ u na ikaya i ni i yongoi. ");
INSERT INTO asg_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Adama a na uma a Isaraila agbashi a̱ va̱ a ɗa, aza a na mu uta̱ka̱i a iɗika i Masar, ka̱ta̱ e denge le tsa agbashi ba. ");
INSERT INTO asg_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ka̱ta̱ vu lyaꞋaka yi tsugono tsu na va kutakacika yi ba, ama vu pana wovon u Ka̱shile ka̱ nu. ");
INSERT INTO asg_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ɗa baci vu cigai kutsula agbashi ali n a̱ma̱ci, vi ta̱ a kufuɗa kutsula le a̱ likuci kakau i na yi uka̱ra̱Ꞌi u nu dem. ");
INSERT INTO asg_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Vi ta̱ a kufuɗa kutsula agbashi o omoci a na i ida̱shi n a̱ɗa̱, koɓolo m muku n na ele a matsai a iɗika i nu. I ta̱ o kokpo uma a̱ nu. ");
INSERT INTO asg_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Vi ta̱ a kufuɗa vu bonoko le okpo uma a̱ ka̱ci ka̱ nu n uma a̱ muku n nu, adama a na okpo ucanuku u muku n nu. I ta̱ o kokpo ɗa̱ agbashi ali sai uteku u wuma u le. Ama uma a̱ ɗa̱ aza a Isaraila, vuza wa kulyaꞋaka toku tsugono tsu na a kutakacikanai ba. ");
INSERT INTO asg_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","<<Ɗa baci komoci ka na ki ida̱shi wa̱ ɗa̱ kokpoi vuza vu uciyi, ɗa toku ɗa̱, vuza va aza a Isaraila wo okpoi vuza vu unambi ali ɗa u dengei ka̱ci ka̱ ni a̱ ubuta̱ u komoci ka nanlo, ko ubuta̱ u uma o komoci a, ");
INSERT INTO asg_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","i ta̱ n utsura u ku tsulasaka vuma vi Isaraila va wana ɗai baci u denge ka̱ci ka̱ ni. Kumaci ku ni ku te ki ta̱ a kufuɗa ku tsulasaka yi. ");
INSERT INTO asg_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ko esheku e keꞋen ko vashi vi ni, ko vuza ni yoku vu na i e kefeku ke te, wi ta̱ a kufuɗa ku tsulasaka yi. A̱yi n ka̱ci ka̱ ni u tsurakpa baci ta na, wi ta̱ a kufuɗa ku tsulasaka ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","A̱yi va n vuza na u tsulai ni va i ta̱ e kukece ka̱bunda̱i ka̱ a̱ya̱ ka na u tsulakai ni va, ka̱ta̱ a̱yi n vuza na u tsulai ni e kece ka̱bunda̱i ka̱ ka̱ya̱ ka na u dengei ka̱ci ka̱ ni wa̱ ni va ali a kubana a̱ ka̱ya̱ ku uba̱ruwi, ikebe i tsulaga i na a tsulakai ni va yu uta̱ kau n ka̱bunda̱i ka̱ a̱ya̱ ka. Makyan ma na wi ishi u vuza na u tsulai ni va wo okpo derere n katsupu ka vuza zamalinga. ");
INSERT INTO asg_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","A̱ya̱ a buwa baci n a̱bunda̱i, wi ta̱ a ku tsulasaka ka̱ci ka̱ ni derere n ka̱bunda̱i ki ikebe i na wi isai a ayin a na u dengei ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ama kenu ɗa baci a̱ya̱ a a buwai kafu ka̱ɗiva̱ ka amangerenkupa ka̱ kuciya̱ uba̱ruwi ka, u kotso u tsupa ikebe i kenu adama a na u tsulasaka ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","A̱ ka̱tsuma̱ ka̱ a̱ya̱ a na wi a kuyaꞋanka komoci ka na ka tsulai ni ulinga, u yaꞋanka yi tsu na u ci yaꞋanka vuza vu zamalinga. Ka̱ta̱ ra̱ka̱ vu ɗa̱ i ka̱sukpa̱ u takacika yi n ka gbani-gbani ba. ");
INSERT INTO asg_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ama ɗa baci u ciya̱i utsulusuki n uye kakau u nanlo ba, vuma va m muku n ni a ka̱sukpa̱ le a̱ ka̱ya̱ ka amangerenkupa ku uba̱ruwi. ");
INSERT INTO asg_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Adama a na uma a Isaraila agbashi a̱ va̱ a ɗa, ele agbashi a ɗa a na mu utuka̱i a iɗika i Masar. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","<<Vuzavaguɗu u danai, ka̱ta̱ i yaꞋanka ka̱ci ka̱ ɗa̱ ka̱ma̱li ko katali ka na i kuyaꞋanka kavasa ba, ko kpamu i sheꞋwe atali adama a na okpo ɗa̱ a̱ma̱li a na i kutono ba, adama a na Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mayun ɗa i ciɓa n kanna ka Ashibi ka kuvuka ka̱ va̱, ka̱ta̱ kpamu i neke A̱Ꞌisa̱ a̱ va̱ tsugbayin. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","<<Ɗa baci i tonoi wila̱ u va̱, ɗa kpamu i ɓa̱na̱i u ɗa, ɗa i yaꞋin ulinga n u ɗa, ");
INSERT INTO asg_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","mi ta̱ a̱ kutuka̱ ɗa̱ n lyushi a ayin a na o yotsoi, iɗika yi ta̱ a kumatsa ili n a̱bunda̱i, nɗanga feu mi ta̱ a kumatsa umaci u le. ");
INSERT INTO asg_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ashina a̱ ɗa̱ i ta̱ a kumatsa ili n a̱bunda̱i, ka̱ta̱ i yongo a vikyaꞋa ali i cina ayin a na i kutaꞋa umaci wu nɗanga u ɗa̱, ka̱ta̱ kpamu i yongo a kutaꞋa umaci wu nɗanga ali a kubana a ayin a̱ vica̱Ꞌa̱. Yi ta̱ a kulyaꞋa ilikulya i na i cikalai, Ka̱ta̱ i da̱sa̱ngi a iɗika i ɗa̱ m ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Mi ta̱ e kuneke ɗa̱ ma̱ta̱na̱ a iɗika ya, a̱ɗa̱ yi ta̱ a kuvaku babu wovon wi ili i yoku. Mi ta̱ o kuloko nnama n kakamba n na n kuzuwa ɗa̱ wovon a iɗika ya, kuvon kpamu ka kusaꞋwa likuci i ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","A̱ɗa̱ yi ta̱ a kuna irala i ɗa̱ n a̱bunda̱i a̱ ubuta̱ u kuvon. ");
INSERT INTO asg_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","A̱ɗa̱ uma a tawun yi ta̱ a kukiyangu uma amangatawun, ka̱ta̱ a̱ɗa̱ uma amangatawun i kiyangu uma a̱kpa̱n kupa. Ka̱ta̱ yu una irala i ɗa̱ n kotokobi. ");
INSERT INTO asg_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Mpa mi ta̱ a̱ kinda ɗa̱ n tsuloboi, ka̱ta̱ n zuwa ɗa̱ i matsasaka i yimkpa n ka̱bunda̱i. Ka̱ta̱ Mpa ta na n shatangu uzuwakpani u va̱ n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I kuyongo ta̱ a kulyaꞋa ili i ɓaluꞋu i na i kyaꞋi, ali i la̱nsa̱ ubuta̱ u na i kutakpa ya zuwa adama a na i ciya̱ ubuta̱ u na i kuzuwa i savu ya. ");
INSERT INTO asg_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Mpa mi ta̱ o kuyongo wa̱ ɗa̱ a̱ Ma̱va̱li ma ciɗa ma̱ va̱, mpa ma kupana unata u ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mpa mi ta̱ a kuwala punu a̱ ka̱tsuma̱ ka̱ ɗa̱ ka̱ta̱ mo okpo Ka̱shile ka̱ ɗa̱, ka̱ta̱ a̱ɗa̱ kpamu yo okpo uma a̱ va̱ ");
INSERT INTO asg_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱, ka na ka̱ uta̱ka̱i ɗa̱ a iɗika i Masar, adama a na ka̱ta̱ i doku yo okpo agbashi a uma a Masar ba. Mpa m gbatya ta̱ kogboli ka tsugbashi e eɗeku a̱ ɗa̱ adama a na yo okpo ba̱ri. ");
INSERT INTO asg_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","<<Ɗaɗa Vuzavaguɗu u danai, ama ɗa baci i kpa̱ɗa̱i kupana ka̱ va̱, ɗa kpamu i kpa̱ɗa̱i kutono wila̱ u nampa dem, ");
INSERT INTO asg_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ɗa i iwain wila̱ u va̱ ɗa i goyoi u ɗa, ali ɗa i kpa̱ɗa̱i kutono u ɗa, ɗa kpamu i pasai uzuwakpani u va̱, ");
INSERT INTO asg_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","to na ɗa atakaci a na n kuneke ɗa̱. Mi ta̱ a̱ kusuꞋuku ɗa̱ n wunla̱i u gbani-gbani, mɓa̱la̱ kakau m ma̱vuna̱ ma na ma̱ kula̱nga̱sa̱ ɗa̱ a̱shi, ka̱ta̱ i ka̱na̱ kuyamba. Gbani ɗa ya kuyaꞋan vica̱Ꞌa̱, adama a na irala i ɗa̱ i ɗa i kulyaꞋaka ɗa̱ i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mpa mi ta̱ a kuzuwa tsurala n a̱ɗa̱ adama a na ka̱ta̱ irala i ɗa̱ i lyaꞋa ɗa̱ n kuvon, irala i ɗa̱ yi ta̱ a kulyaꞋaka ɗa̱ tsugono, ka̱ta̱ i ka̱na̱ ilaɗi babu vuza u saɓa ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ɗa baci ili i nampa ra̱ka̱ i lazai ɗa i kpa̱ɗa̱i kupanaka mu, ka̱ta̱ n doku atakaci a̱ ɗa̱ ali kucindere. ");
INSERT INTO asg_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mpa mi ta̱ a kutakpa ugbamukaci u ɗa̱ ka̱ta̱ m kpa̱ɗa̱ kuyoꞋoko ɗa̱ mini, ashina a̱ ɗa̱ a na yi a kucimba kpamu i ta̱ e kuɗekpe ka̱ta̱ iɗika i gbama tsu kakpanlai. ");
INSERT INTO asg_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Yi ta̱ a kutakacika ka̱ci ka̱ ɗa̱ n ulinga gbani, adama a na ashina a̱ ɗa̱ a kumatsa ili i makara kpamu ba, nɗanga kpamu ma ashina a̱ ɗa̱ n kumatsa imacishi yi nɗanga ba. ");
INSERT INTO asg_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","<<Ɗa baci i lyaꞋi kelime n kuyaꞋanka mu ugbamukaci ɗa i kpa̱ɗa̱i kupana ka̱ va̱, Mpa mi ta̱ o kudoku ɗa̱ atakaci ali kucindere adama a̱ unushi u ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mpa mi ta̱ a̱ kusuꞋuku ɗa̱ nu nnama n kakamba m gbani-gbani, aza a na a kuyaꞋan koli ka̱ muku n ɗa̱, ka̱ta̱ a una ilikuzuwa i ɗa̱, ka̱ta̱ e jebe ɗa̱ ka̱bunda̱i ali tsu na a̱ kukpa̱ɗa̱ kene uma a uye wu nwalu u ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","<<Ɗa baci ali n gogo na i kpa̱ɗa̱i kupana ka̱ va̱, ama ɗa i lyaꞋi kelime n kuyaꞋanka mu ugbamukaci, ");
INSERT INTO asg_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Mpa feu mi ta̱ o kokpo a tsurala n a̱ɗa̱. Mpa n ka̱ci ka̱ va̱ mi ta̱ e kuneke ɗa̱ atakaci a na a laꞋi a cau ali kucindere adama a̱ unushi u ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mi ta̱ a̱ kutuka̱ ɗa̱ n kuvon ku na ka kuyaꞋanka mu katsupu adama a na i iwan ta̱ uzuwakpani u va̱. Ɗa baci i sumai o kubono n ka̱ca̱pa̱ a kuꞋuwa a̱ likuci i gbayin i ɗa̱ adama a na i sheɗeku, mi ta̱ a̱ kusuꞋuku ɗa̱ m ma̱dukpa̱ ma gbani-gbani ma na ma kuzuwa ɗa̱ i neke utan a̱ ubuta̱ wa irala a̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ɗa baci m kpanduki uye u kuciya̱ wi ilikulya u ɗa̱, a̱ma̱ci kupa i ta̱ a̱ kuya̱na̱ka̱ ɗa̱ e kenle ke te, ka̱ta̱ a̱ peceke ɗa̱ ugisanki. Yi ta̱ a kulyaꞋa i ɗa ama ya̱ kucuwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","<<Ɗa baci kpamu i kpa̱ɗa̱i kupana ka̱ va̱, ɗa i lyaꞋi kelime n kuyaꞋanka mu ugbamukaci, ");
INSERT INTO asg_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mpa a̱ ka̱tsuma̱ ku una̱mgbuka̱tsuma̱ ka̱ va̱ mi ta̱ a kuzuwa tsurala n a̱ɗa̱, ka̱ta̱ n neke ɗa̱ atakaci adama a̱ unushi u ɗa̱ ali kucindere u laꞋa ci cau. ");
INSERT INTO asg_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ka̱ta̱ ta na i ka̱na̱ kutakuma inyama i muku mo olobo ni nkere n ɗa̱ adama a kambulu. ");
INSERT INTO asg_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ka̱ta̱ Mpa m ɓoso ubuta̱ u kutoni u ɗa̱, n la̱nga̱sa̱ atalialyuka a ili i ma̱gula̱ni n ɗa̱, n kingira even a ikyamba a̱ ɗa̱ zuva va̱ a̱ma̱li a̱ ɗa̱ a babu wuma. Ka̱ta̱ yo okpo ili yu unata wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mpa mi ta̱ o kubonoko likuci i gbagbaꞋin i ɗa̱ agali, n la̱nga̱sa̱ nva̱li n ɗa̱, ka̱ta̱ m kpa̱ɗa̱ kuciga ma̱gula̱ni me kuneꞋe ma̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ka̱ta̱ n la̱nga̱sa̱ iɗika i ɗa̱, ciya̱ irala i ɗa̱ i na i ta̱wa̱i kuda̱sa̱ngu punu i ɗa, a namba i na a kudansa adama a una̱mgbi wi iɗika ya. ");
INSERT INTO asg_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Mpa mi ta̱ a kuwacuwa ɗa̱ a iɗika kakau, ka̱ta̱ n tala kotokobi ka̱ va̱ n guva ɗa̱. Ka̱ta̱ n zuwa iɗika i ɗa̱ yo okpo agali, likuci i gbagbaꞋin i ɗa̱ yo okpo lekeɗi. ");
INSERT INTO asg_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","<<Ka̱ta̱ iɗika i ɗa̱ i ciya̱ a̱ya̱ a̱ ni a wuvuki a ayin a na yi ishi yo okpoi agali, a ayin a na yi ishi ida̱shi a̱ likuci yi irala i ɗa̱. Ka̱ta̱ iɗika ya yu uvuka mayin. ");
INSERT INTO asg_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ayin a na baci iɗika ya yo okpoi agali, i ɗa yi ta̱ a̱ kuciya̱ wuvuki u ni u na ishi a̱ sa̱nka̱i ni a̱ a̱ya̱ a kuvuka a na i yongoi punu a i ɗa. ");
INSERT INTO asg_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ama a̱ɗa̱ vu na i buwai, ka̱ta̱ n zuwa a̱ɗu a̱ ɗa̱ okpo n wovon punu a̱ likuci yi irala i ɗa̱ ali izumgbi i wunla̱i ya̱ a̱vuku koci i zuwa ɗa̱ ilaɗi. Ka̱ta̱ i suma uteku tsa aza na i o kutono n kotokobi, ka̱ta̱ i ka̱na̱ kuta̱ɗa̱tsa̱ n i yikpa̱i a iɗika gbani, ashe babu ta na vuza na wi o kutono ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Yi ta̱ a̱ kuka̱na̱ magamanai uteku tsa aza a na i a kusuma ukpa̱ u kotokobi, babu ta na vuza na wi lo a kusaɓa ɗa̱. Yi a kufuɗa kushilika̱ n irala i ɗa̱ ba. ");
INSERT INTO asg_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","A kuta̱wa̱ a ukocishi, yi ta̱ a̱ kukuwa̱ a iɗika kakau, iɗika yi irala i ɗa̱ yi ta̱ o kusoɗongu ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A̱ɗa̱ vu na i buwai ta ya̱ kuka̱na̱ kukotso nannai a̱ likuci yi irala i ɗa̱ adama a̱ unushi u ɗa̱ koɓolo n unushi wi ikaya i ɗa̱. ");
INSERT INTO asg_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","<<Ama a̱ ushuku baci n unushi u le koɓolo n unushi wi ikaya i le, tsu na a̱ ka̱sukpa̱i mu ɗa kpamu a yaꞋankai mu ugbamukaci, ");
INSERT INTO asg_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","i ɗa i zuwai ɗa n yaꞋin feu wupa a kubana we le ali ɗa n lokoi le a kubana a iɗika yi irala i le, a ayin a na baci a̱ɗu a ugbami e le o bonoi a uye ɗa a̱ shika̱i unushi u le, ɗa a̱ ka̱sukpa̱i ka gbani-gbani ke le, ");
INSERT INTO asg_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","mi ta̱ a kuciɓa n uzuwakpani u va̱ n Yakubu, n Ishaku, n Ibirahi ka̱ta̱ n ciɓa n iɗika ya. ");
INSERT INTO asg_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Kafu i nanlo i gita̱, uma a̱ va̱ i ta̱ a kuzuwa uma a̱ ka̱sukpa̱ iɗika i le, ka̱ta̱ i ɗa i pana uyoꞋo u wuvuki u ni a ayin a na yi ishi agali. I ta̱ a kutakacika adama a̱ unushi u na a yaꞋin adama a na a iwan ta̱ wila̱ u va̱ n kadanshi ka̱ va̱. ");
INSERT INTO asg_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ko n nannai dem, a ayin a na i a iɗika yi irala i le mi a kuꞋiwan le ba, ko n yaꞋan wupa n ele ciya̱ mu una le ra̱ka̱ ko n koɗo uzuwakpani u na n yaꞋin n ele. Mpa ɗa Vuzavaguɗu Ka̱shile ke le. ");
INSERT INTO asg_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ama adama e le, mi ta̱ a kuciɓa n uzuwakpani u va̱ n ikaya i le i na mu uta̱ka̱i a iɗika i Masar aduniyan e kene adama a na mo okpo Ka̱shile ke le. Mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Na ɗa wila̱ n kadanshi n ili i kutono i na Vuzavaguɗu u yaꞋin n aza a Isaraila a̱ ubuta̱ u Musa a Kusan ku Sinai. ");
INSERT INTO asg_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","<<YaꞋan kadanshi n uma a Isaraila ka̱ta̱ vu dana le, ɗa baci vuza u yaꞋin akucina a na u kuneke vuma u yaꞋanka mu ulinga, vuza na e nekei mu va i ta̱ a kufuɗa kushiba̱ yi n ikebe i na vuza yoku u kutsupa ganu n vuma va. ");
INSERT INTO asg_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Zuwai katsupu ka mavali vuza va̱ a̱ya̱ kamanga a kubana a̱ya̱ amangatatsu derere n ikebe i shekelu amangerenkupa, uteku tsa agisana agisamkpatsu ya̱ A̱Ꞌisa̱, ");
INSERT INTO asg_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ama mavuka ma baci ma na mi n a̱ya̱ tsu nanlo feu, zuwai katsupu ka̱ ni derere n ikebe i shekelu kamangankupa. ");
INSERT INTO asg_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ama maku mo kolobo ma baci ma̱ a̱ya̱ a tawun a kubana kamanga, zuwai katsupu ka̱ ni derere n ikebe i shekelu kamanga, maku ma vuka tamkpamu a zuwaka yi ikebe i shekelu kupa. ");
INSERT INTO asg_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ama maku mo wotoi u te ma baci a kubana a̱ya̱ a tawun, zuwai katsupu ka mavali derere n ikebe i shekelu vu tawun, mavuka tamkpamu derere n ikebe i shekelu vu tatsu. ");
INSERT INTO asg_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ama vuma va̱ a̱ya̱ amangatatsu ɗa baci ko ulaji, zuwai katsupu ka vali derere n ikebe i shekelu gendu, vuka tamkpamu ikebe i shekelu kupa. ");
INSERT INTO asg_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ɗa baci vuma na u yaꞋin akucina wo okpoi vuza vu unambi u na wi a kufuɗa kutsupa ikebe i na a zuwakai ni ba, sai u banka n vuma va a̱ ubuta̱ u ganu, a̱yi ɗa vuza na u kufuɗa kujebeke yi ugana wa uteku tsu na wa kufuɗa kutsupa. ");
INSERT INTO asg_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","<<Ili i na u yaꞋankai akucina a ilikuzuwa i ɗa baci i na a kufuɗa kuyaꞋanka Vuzavaguɗu kuneꞋe, to ilikuzuwa i nanlo i na e nekei va yo okpo ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ka̱ta̱ u sabaꞋa ma ba ko kpamu u yaꞋansaka ma singai ma m ma gbani-gbani ba. Ɗa baci u sabaꞋi nannai, dem vu le i ta̱ o kokpo ciɗa, ka̱ta̱ kpamu a lyuka le a̱va̱ ");
INSERT INTO asg_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ama ɗa baci akucina a okpoi a manama ma na mi ciɗa ba, ma na mi kuyaꞋanka kuneꞋe a̱ ubuta̱ u Vuzavaguɗu ba, mayun ɗa a ɗika e neke ma ganu, ");
INSERT INTO asg_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","vuza na u kukondo maꞋa, ko ma singai maꞋa ko ma singai maꞋa ba. Ikebe i na baci de dem ganu u kiɗakai maꞋa, wo kokpo nannai. ");
INSERT INTO asg_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ama vuza va akucina va u ciga baci wa tsulasaka manama ma, to sai u doku u gboku u te a̱ ka̱tsuma̱ ku u tawun ki ikebe i na a zuwai. ");
INSERT INTO asg_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","<<Ɗa baci vuza u nekei kpaꞋa ku ni tsu kuneꞋe ki ili i ciɗa a̱ ubuta̱ u Vuzavaguɗu, ka̱ta̱ ganu u kiɗaka yi ikebe derere n tsu ugaꞋin ko una̱mgbi u kpaꞋa wa. Ikebe i na baci de dem ganu u kiɗai ta tana wo kokpo nannai. ");
INSERT INTO asg_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ɗa baci vuza na u nekei kpaꞋa ka u cikalai ku tsulasaka ku ɗa, to sai u doku ugboku u te a̱ ka̱tsuma̱ ku u tawun ki ikebe i na a tsupai ni, ka̱ta̱ kpaꞋa ka kokpo ku ni kpamu. ");
INSERT INTO asg_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","<<Ɗa baci vuza u nekei Vuzavaguɗu upecu u iɗika i ni, u gaꞋan ta̱ a zuwa ikebe i ni yo okpo derere n icuꞋu i na i gaꞋin a̱ ca̱Ꞌa̱ a kashina ka. I ta̱ e kukece ikebe ya yo okpo azurufa kupa a nca̱tsu kamanga dem vi ili i kashina. ");
INSERT INTO asg_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ɗa baci u nekei kashina ka a ayin a̱ ka̱ya̱ ka̱ ma̱za̱nga̱ ka amangerenkupa, ikebe i na e kecei ɗe va o kudoku a sabaꞋa i ɗa ba. ");
INSERT INTO asg_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ama ɗa baci u nekei kashina ka wana ɗai a̱ya̱ amangerenkupa a̱ uba̱ruwi a laza, to sai ganu wi indana derere wu untsukpa a̱ya̱ a na a buwai a kubana a̱ ka̱ya̱ ka amangerenkupa ka. Ka̱ta̱ e jebe ka̱bunda̱i ki ikebe ka na a kutsupa. ");
INSERT INTO asg_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ɗa baci vuza na u nekei kashina ka u cikalai kubono ku tsulasaka kaꞋa, to sai u doku ugboku u te a̱ ka̱tsuma̱ ku u tawun wi ikebe i na yi derere, ka̱ta̱ kashina ka kpamu ko okpo ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ama u tsulasaka baci kashina ka ba, ko ta na u denke baci vuza yoku kau, kashina ka ka buwa ku tsulasaka ba. ");
INSERT INTO asg_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ɗa baci e nekei kashina ka a ka̱ya̱ ku uba̱ruwi, ki ta̱ o kokpo kuneꞋe ku ciɗa u Vuzavaguɗu, ka̱ta̱ kokpo ucanuku u anan ganu. ");
INSERT INTO asg_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ɗa baci vuza u nekei Vuzavaguɗu kashina ka na u tsulai, ka na kokpoi ili i ka̱ci ka̱ ni m kpaꞋa ku ni koci ba, ");
INSERT INTO asg_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ganu wi ta̱ a kuzuwaka kaꞋa ikebe derere n a̱ya̱ a na a buwai a̱ ka̱ya̱ ka amangerenkupa ku uba̱ruwi, ka̱ta̱ vuma va ta na u tsupa i na i kuyaꞋan derere a kanna ka nanlo ka, ci ili i na yi ciɗa a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","A ka̱ya̱ ka amangerenkupa ku uba̱ruwi, kashina ka ki ta̱ o kubono e ekiye a vuza na u denkei ni, vuza na kashina ka kishi ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Katsupu ka na a zuwai dem i ta̱ e kukece kaꞋa kokpo derere n kagisamkpatsu ka̱ A̱Ꞌisa̱. ");
INSERT INTO asg_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","<<Ɗa Vuzavaguɗu u danai, babu vuza na u kuneke maku mu ugiti ma manama, adama a na maku mu ugiti dem ma Vuzavaguɗu maꞋa, ko kanaka ko malala. ");
INSERT INTO asg_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ama manama ma na mi ciɗa ba, wi ta̱ a kufuɗa kushiba̱ maꞋa derere n katsupu ka na a zuwakai ni ka̱ta̱ u doku ugboku u te a̱ ka̱tsuma̱ ka tawun ki ili i na yi derere va. U tsulasaka baci ma ba, sai e denge maꞋa derere n katsupu ka na ko yotsoi ni. ");
INSERT INTO asg_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","<<Ama ili i na baci de dem vuma u kuzuwa adama a Vuzavaguɗu, ko vuma ko manama, ko kashina ka kpaꞋa, o doku a shiba̱ i ɗa ba, adama a na ili i na a kanzakai Vuzavaguɗu yi ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Babu vuma na e kuneke adama a kuna, ka̱ta̱ o doku a tsulasaka yi kpamu. Mayun vuma vu nanlo a una yi. ");
INSERT INTO asg_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","<<Ili i te a̱ ka̱tsuma̱ ka kupa ki ili i kashina dem, ko ili i na a̱ ca̱Ꞌi ɗa a kyaꞋi ko umaci wu nɗanga, dem i Vuzavaguɗu i ɗa. I ɗa yi ta̱ ciɗa u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Vuza u ciga baci u tsulasaka ili i te a̱ ka̱tsuma̱ ka kupa ki na wu uta̱ka̱i, mayun ɗa u doku ugboku u te a̱ ka̱tsuma̱ ka tawun ki ili i na e kecei. ");
INSERT INTO asg_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ili i te a̱ ka̱tsuma̱ ka kupa yu ushiga wa anaka, wu nraɗika ko nkyon, i Vuzavaguɗu i ɗa. Ayin a na e kukece nnama ma, ma kupa dem ma Vuzavaguɗu maꞋa. ");
INSERT INTO asg_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ka̱ta̱ u yaꞋan kazagba u ɗika vuza singai u ka̱sukpa̱ vuza gbani-gbani ba. Ko kasabaꞋa ka̱ta̱ vi yaꞋan ba. Ɗa baci vi yaꞋin kasabaꞋa, to dem vu le i ta̱ o kokpo ciɗa. I ta na a kufuɗa ku tsulasaka le ba.>> ");
INSERT INTO asg_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Nava ɗaɗa wila̱ u na Vuzavaguɗu u nekei Musa a Kusan ku Sinai adama a uma a Isaraila.");
INSERT INTO asg_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","A kanna ka iyain ko wotoi u ire, a̱ ka̱ya̱ ke ire ka ayin a na aza a Isaraila a ka̱sukpa̱i Masar, ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa a Kusan ku Sinai e meremune, a̱ Ma̱va̱li mo Oɓolo. Ɗa u danai, ");
INSERT INTO asg_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","<<Avu n Haruna a̱ɗa̱ ɗa i kukece uma a Isaraila kumaci-kumaci m kpaꞋa-kpaꞋa, ka̱ta̱ i ɗana kula ku mavali dem, ");
INSERT INTO asg_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","aza a na a yawai a̱ya̱ kamanga ko vuza gbayin dem vuza na u kufuɗa ulinga u tsusoji. ");
INSERT INTO asg_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","I folono vuza te a̱ ka̱tsuma̱ ku umaci dem a̱yi na wi kesheku ka kpaꞋa, a̱ ɓa̱nka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ula a ali a na a̱ kuɓa̱nka̱ ɗa̱ a ɗaɗa na. A kumaci ku Ruben, Elizu kolobo ka Shedeyu. ");
INSERT INTO asg_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","A kumaci ku Simiyon, Shelumiye kolobo ka Zurishada. ");
INSERT INTO asg_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","A kumaci ku Yahuda, Nashon kolobo ka Aminadabu. ");
INSERT INTO asg_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","A kumaci ku Isaka, Nataniya kolobo ka Zuwaru. ");
INSERT INTO asg_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","A kumaci ku Zabalun, Eliyabu kolobo ka Helon. ");
INSERT INTO asg_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","A kumaci ko olobo a̱ Isufu, n ku Ifirayimu, n ku Elishama kolobo ka Amihudu, n kumaci ka aza a Manasa, Gamaliya kolobo ka Pedazuru. ");
INSERT INTO asg_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","A kumaci ku Bayami, Abidan kolobo ka Gidiyon. ");
INSERT INTO asg_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","A kumaci ku Dan, Ahiyeza kolobo ka Amishada. ");
INSERT INTO asg_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","A kumaci ku Ashera, Pagiyelu kolobo ka Okiran. ");
INSERT INTO asg_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","A kumaci ku Gadu, Eliyasafa kolobo ka Dewuyelu. ");
INSERT INTO asg_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","A kumaci ku Nafutali, Ahira kolobo ka Enanu.>> ");
INSERT INTO asg_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Nava ɗaɗa ali a na a zagbai a̱ ka̱tsuma ka̱ ka̱tsura̱ dem, aza e kelime e kelentsu ku umaci dem, ele ɗa aza e kelime a kumaci ka a aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ɗa Musa n Haruna e ɗekei uma a, aza na e nekei ula e le, ");
INSERT INTO asg_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ɗa e ɗekei uma a̱ likuci ra̱ka̱ a kanna ku ugiti o wotoi u ire. Ɗa e kecei mavali dem kpaꞋa-kpaꞋa n kumaci-kumaci, ula a aza na a yawai a̱ya̱ kamanga n kapashi. A ɗana le ta̱ ɗa e kecei le. ");
INSERT INTO asg_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Uteku tsu na Vuzavaguɗu u danai Musa, ta u kecei le nannai ɗe e meremune ma Sinai. ");
INSERT INTO asg_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","I na i ɗikai a kumaci ku Ruben kolobo ku ugiti ki Isaraila. Ali dem aza na a yawai a̱ya̱ kamanga n kapashi, aza na a yawai kuɗika ulinga u tsusoji a kecei le n ula e le, vuza te-te, u teku tsu na i kumaci-kumaci n kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ka̱bunda̱i ka uma ka na e kecei a kumaci ku Ruben ka yawa ta̱ a̱kpa̱n amangere n a̱ ta̱li n amangatawantawun (46, 500). ");
INSERT INTO asg_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","A kumaci ku Simiyon, ali ra̱ka̱ a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te dem, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ka̱bunda̱i ka uma ka na e kecei a kumaci ku Simiyon, a yawa ta̱ a̱kpa̱n amangerenkupa n kuci n amangatawantatsu (59, 300). ");
INSERT INTO asg_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","A kumaci ku Gadu, ali ra̱ka̱ a na a yawai a̱ya̱ kamanga n kapashi, aza na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Kabunda̱i ka uma ka na e kecei a kumaci ku Gadu, a yawa ta̱, a̱kpa̱n amangere n a tawun n amangatawa̱nta̱li n amangerenkupa. (45, 650). ");
INSERT INTO asg_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","A kumaci ku Yahuda, ali a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ka̱bunda̱i ka uma ka na e kecei a kumaci ku Yahuda, a yawa ta̱ a̱kpa̱n amangatatsunkupa n a̱na̱shi, n amangatawa̱nta̱li (74, 600). ");
INSERT INTO asg_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","A kumaci ku Isaka, ali a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ka̱bunda̱i ka uma ka na e kecei a kumaci ku Isaka, a yawa ta̱ a̱kpa̱n amangerenkupa n a̱na̱shi, n amangatawa̱na̱shi (54, 400). ");
INSERT INTO asg_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","A kumaci ku Zabalun, ali a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ku Zabalun, a yawa ta̱ a̱kpa̱n amangerenkupa n e cindere, n amangatawa̱na̱shi (57, 400). ");
INSERT INTO asg_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","A kumaci ku Ifirayimu, ali a na a yawai a̱ya̱ kamanga n kapashi, aza na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ka Ifirayimu, a yawa ta̱ a̱kpa̱n amangere n amangatawantawun (40, 500). ");
INSERT INTO asg_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","A kumaci ku Manasa, ali a na a yawai a̱ya̱ kamanga n kapashi, aza na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ka Manasa, a yawa ta̱ a̱kpa̱n kamangankupa n e re n amangatawenre (32, 200). ");
INSERT INTO asg_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","A kumaci ku Bayami, ali a na a yawai a̱ya̱ kamanga n kapashi, aza na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ku Bayami, a yawa ta̱ a̱kpa̱n kamangankupa n a tawun n amangatawa̱na̱shi (35, 400). ");
INSERT INTO asg_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","A kumaci ku Dan, ali a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ku Dan, a yawa ta̱ a̱kpa̱n amangatatsu n re n amangatawencindere (62, 700). ");
INSERT INTO asg_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","A kumaci ku Ashera, ali a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ku Ashera, a yawa ta̱ a̱kpa̱n amangere n kete n amangatawantawun (41, 500). ");
INSERT INTO asg_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","A kumaci ku Nafutali, ali a na a yawai a̱ya̱ kamanga n kapashi, aza na a yawai kubana tsusoji ra̱ka̱, e kece le ta̱ ɗa a ɗanai ula e le vuza te-te, uteku tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ka̱bunda̱i ka uma ka na e kecei ka kumaci ku Nafutali, a yawa ta̱ a̱kpa̱n amangerenkupa n a tatsu n amangatawa̱na̱shi (53, 400). ");
INSERT INTO asg_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Nava ele ɗa ali a na Musa n Haruna e kecei koɓolo n aza e kelime kupa n ere a Isaraila, yaba dem wi ta̱ a kashani ka kpaꞋa ku ni. ");
INSERT INTO asg_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Nannai ɗa e kecei ali ra̱ka̱ a Isaraila a na a yawai a̱ya̱ kamanga n kapashi, aza a na a yawai kubana tsusoji, e kece le ta̱ kumaci-kumaci. ");
INSERT INTO asg_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Uɓolongi u mekecu wa ra̱ka̱-ra̱ka̱ u ɗaɗa a̱kpa̱n amangatawa̱nta̱li n a̱kpa̱n a tatsu n amangatawantawun n amangerenkupa, (603, 550). ");
INSERT INTO asg_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ama e kece kumaci ka aza e Levi koɓolo n kumaci ku na ku buwai ba. ");
INSERT INTO asg_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Adama a na Vuzavaguɗu u dana ta̱ Musa. ");
INSERT INTO asg_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","<<Ka̱ta̱ i kece kumaci ka aza e Levi, ko kpamu i ɓolongu le e mekecu n aza a Isaraila a na a buwai ba. ");
INSERT INTO asg_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","N tsu nanlo, yi ta̱ a kufuɗa ya zagba aza e Levi okpo aza a na a̱ kula̱na̱ Ma̱va̱li ma̱ Ka̱shile n ucanuku u na wi punu ra̱ka̱ koɓolo n ili ra̱ka̱ i na yi punu. Ele ɗa a kuɗika Ma̱li ma̱ Ka̱shile ka n ucanuku u na wi punu koɓolo n ili ra̱ka̱ i na yi punu, ele ɗa a̱ kula̱na̱ ka̱ta̱ a̱ da̱sa̱ngu uka̱ra̱Ꞌi n kaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ayin a na baci de dem i cigai kuyaꞋansaka ubuta̱ u na a cigai kubana n Ma̱va̱li ma̱ Ka̱shile ma, aza e Levi a ɗa a kubanka n kaꞋa, ele ɗa kpamu a̱ kushikpa̱ kaꞋa. Yaba dem vu na u yawai ɗevu i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Aza Isaraila a na a buwai i ta̱ a̱ kushikpa̱ a̱pa̱m e le ka̱tsura̱-ka̱tsura̱, yaba dem n ka̱pa̱m ka̱ ni, a uteku u tsugbayin tsu ni. ");
INSERT INTO asg_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ka̱ta̱ aza e Levi a a̱ shikpa̱ a̱pa̱m e le uka̱ra̱Ꞌi n Ma̱va̱li ma̱ Ka̱shile ka. Adama a na ka̱ta̱ Vuzavaguɗu u ɗa̱ngusa̱ wupa u ni wa aza a Isaraila ba. Ulinga wa aza e Levi u ɗa a̱ la̱na̱ Ma̱va̱li ma̱ Ka̱shile.>> ");
INSERT INTO asg_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ɗa aza a Isaraila a yaꞋin ili dem derere tsu na Vuzavaguɗu u danai Musa u yaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa n Haruna, u danai. ");
INSERT INTO asg_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","<<A ayin a na baci de dem aza a Isaraila a̱ kuda̱sa̱ngu, yaba dem u shamgba n kakashi ka kumaci ka kpaꞋa ka̱ ni a̱ ka̱tsura̱ ka̱ ni uka̱ra̱Ꞌi m Ma̱va̱li mo Oɓolo daꞋangi m maꞋa. ");
INSERT INTO asg_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Aza a na a̱ kuda̱sa̱ngu a uɓon u kasana, ele ɗa kumaci ka aza a Yahuda. I ta̱ a kushamgba n kakashi ka kpaꞋa ke le, uteku tsu na e peciki le kefeku-kefeku. Vuza kelime va aza a Yahuda a̱yi ɗa Nashon kolobo ka Aminadabu. ");
INSERT INTO asg_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ka̱bunda̱i ka uma a̱ ni, ka yawa ta̱ a̱kpa̱n amangatatsunkupa n na̱shi n amangatawa̱nta̱li (74, 600). ");
INSERT INTO asg_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ka̱ta̱ kumaci ka aza a Isaka ku tono ɗevu n ele. Vuza kelime va aza a Isaka a̱yi ɗa Nataniya kolobo ka Zuwaru. ");
INSERT INTO asg_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ka̱bunda̱i ka uma a̱ ni, ka yawa ta̱ a̱kpa̱n amangerenkupa n a̱ na̱shi n amangatawa̱na̱shi (54, 400). ");
INSERT INTO asg_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ka̱ta̱ kumaci ka aza e Zabalun ku tono. Vuza kelime va aza e Zabalun a̱yi ɗa Eliyabu kolobo ke Helon. ");
INSERT INTO asg_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ka̱bunda̱i ka uma a̱ ni, ka yawa ta̱ a̱kpa̱n amangatawenre n kupa n e cindere n amangatawa̱na̱shi (57, 400). ");
INSERT INTO asg_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ka̱bunda̱i ka uma a Yahuda a na i punu a̱ ka̱tsura̱ ka ra̱ka̱ a yawa ta̱ uma a̱kpa̱n amangatawun n amangatawunkunla̱i n a̱ ta̱li n amangatawa̱na̱shi (186, 400). Ele ɗa aza a na a̱ kugita̱ kuɗa̱nga̱. ");
INSERT INTO asg_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","<<N uɓon u ɗaka tamkpamu, kumaci ka aza Ruben ku ɗa a kushamgba ɗe n kakashi ka kpaꞋa ku le, uteku tsu na i kefeku-kefeku. Vuza kelime va aza Ruben a̱yi ɗa Elizu kolobo ka Shedeyu. ");
INSERT INTO asg_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ka̱bunda̱i ka uma a̱ ni ka yawa ta̱ uma a̱kpa̱n amangatawun a̱na̱shi n a̱ ta̱li n amangatawantawun (46, 500). ");
INSERT INTO asg_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Aza a na o kutono kumaci ku Ruben ka ele ɗa kumaci ku Simiyon. Vuza kelime vu kumaci ku Simiyon va a̱yi ɗa Shelumiye maku ma Zurishada. ");
INSERT INTO asg_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ka̱bunda̱i ka uma a̱ ni a yawa ta̱ a̱kpa̱n amangerenkupa n kuci n amangatawantatsu (59, 300). ");
INSERT INTO asg_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kumaci ku Gadu ele ɗa aza na o kutono. Vuza kelime vu kumaci ku Gadu va a̱yi ɗa Eliyasafa maku ma Dewuyelu. ");
INSERT INTO asg_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ka̱bunda̱i ka uma a̱ ni ka yawa ta̱ a̱kpa̱n amangere n a tawun n amangatawa̱nta̱li n amangerenkupa (45, 650). ");
INSERT INTO asg_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ka̱bunda̱i ka ra̱ka̱-ra̱ka̱ ka kumaci ku Ruben ka yawa ta̱ uma a̱kpa̱n amangatawun n amangerenkupa n kete, n amangatawa̱na̱shi n amangerenkupa (151, 450). Ele ɗa aza a na o kokpo ugboku u ire a makyan ma na baci aza a Isaraila a cigai kuta̱ kuyaꞋan nwalu. ");
INSERT INTO asg_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","<<Kumaci ku na ko kutono ku ɗaɗa, kumaci ka aza e Levi, i ta̱ a̱ kuta̱ a̱ kuɗa̱nga̱ punu e mere ma̱ ka̱tsura̱ ma, uɗiki m Ma̱va̱li mo Oɓolo ma. Kumaci kakau i ta̱ a kuwala tsu na o tonukoi le o yongo punu a̱ ka̱tsura̱ ka, yaba dem n kakashi ka kumaci ku ni. ");
INSERT INTO asg_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","<<Ɗe a̱ ka̱livi, ka̱tsura̱ ka kumaci ku Ifirayimu ele ɗa a kushamgba ɗe. Vuza kelime vu kumaci va a̱yi ɗa Elishama maku ma Amihudu. ");
INSERT INTO asg_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ka̱bunda̱i ka uma a̱ ni ka yawa ta̱ a̱kpa̱n amangere n amangatawantawun (40, 500). ");
INSERT INTO asg_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Kumaci ku na ku tonoi Ifirayimu ku ɗaɗa kumaci ku Manasa. Vuza kelime vu kumaci vu Manasa va a̱yi ɗa Gamaliya maku ma Pedazuru. ");
INSERT INTO asg_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ka̱bunda̱i ka uma a̱ ni ka yawa ta̱ a̱kpa̱n kamangankupa n e re n amangatawenre (32, 200). ");
INSERT INTO asg_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Kumaci ku Bayami ele ɗa aza a na i o kutono. Vuza kelime vu kumaci va a̱yi ɗa Abidan maku ma Gidiyon. ");
INSERT INTO asg_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Bayami n Abidan maku ma Gidiyon i ta̱ uma a̱kpa̱n kamangankupa n uma a tawun n amangatawa̱na̱shi (35, 400). ");
INSERT INTO asg_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Aza a na e kecei a̱ ka̱tsuma̱ ka kumaci ki Ifirayimu a̱ ka̱tsura̱ ke le ka, i ta̱ uma a̱kpa̱n amangatawun n kunla̱i n amangatawun (108, 100). Ele ɗa aza a na o kokpo ugboku u tatsu a makyan ma na baci aza a Isaraila a cigai kuta̱ kuyaꞋan nwalu. ");
INSERT INTO asg_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","<<Aza a na a̱ kushikpa̱ a̱pa̱m e le a uɓon u gaɗi ele ɗa kumaci ku Dan, ka̱ta̱ a shamgba a̱ ubuta̱ u kakashi ka kpaꞋa ke le uteku u kefeku ke le. Vuza kelime vu kumaci ku Dan va a̱yi ɗa Ahiyeza maku ma Amishada. ");
INSERT INTO asg_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ka̱bunda̱i ka uma a̱ ni a ka yawa ta̱ uma a̱kpa̱n amangatatsu n ere n amangatawencindere (62, 700). ");
INSERT INTO asg_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Kumaci ku Ashera ele ɗa a kuvaku o tono le. Vuza kelime vu kumaci ku Ashera ka a̱yi ɗa Pagiyelu maku ma Okiran. ");
INSERT INTO asg_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ka̱bunda̱i ka uma a̱ ni ka yawa ta̱ uma a̱kpa̱n amangere n kete n amangatawantawun (41, 500). ");
INSERT INTO asg_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kumaci ku Nafutali ku ɗa ko kutono le ka̱ca̱pa̱. Vuza kelime vu kumaci ku Nafutali va a̱yi ɗa Ahira maku ma Enanu. ");
INSERT INTO asg_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ka̱bunda̱i ka uma a̱ ni ka yawa ta̱ uma a̱kpa̱n amangerenkupa n a tatsu n amangatawa̱na̱shi (53, 400). ");
INSERT INTO asg_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ka̱bunda̱i ra̱ka̱-ra̱ka̱ ka uma a Dan a, ka yawa ta̱ uma a̱kpa̱n amangatawun n amangerenkupa n e cindere n amangatawa̱nta̱li (157, 600). Ele ɗa aza a na o ko okpo a ukocishi a makyan ma na a̱ kuɗa̱nga̱ a̱ ka̱sukpa̱ ka̱tsura̱ n kakashi ke le.>> ");
INSERT INTO asg_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Nava ɗaɗa aza a Isaraila, aza a na e kecei va, yaba dem m kpaꞋa ku ni. N ikaya i le n kumaci ku le a yawa ta̱ uma a̱kpa̱n amangatawa̱nta̱li n a tatsu n amangatawantawun n amangerenkupa (603, 550). ");
INSERT INTO asg_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ama Vuzavaguɗu u yaꞋan ta̱ ɗe kadanshi m Musa u danai, ka̱ta̱ e kece aza e Levi ubuta̱ u te n aza a Isaraila ba. ");
INSERT INTO asg_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ɗa aza a Isaraila a yaꞋin ra̱ka̱ i na Vuzavaguɗu u danai Musa. Ɗa yaba dem u da̱sa̱ngi a̱ ubuta̱ u kakashi ka kpaꞋa ka̱ ni, tsu nanlo tsu ɗa kpamu a̱ uta̱i, yaba dem n kefeku ka̱ ni m kpaꞋa ku ni. ");
INSERT INTO asg_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Nava ɗaɗa ka̱bunda̱i ka limata ka Haruna m Musa a makyan ma na Vuzavaguɗu u yaꞋin kadanshi m Musa a Kusan ku Sinai. ");
INSERT INTO asg_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ula a̱ muku n ali n Haruna ma ele ɗa Nadabu maku ma iyain koɓolo n Abihu, n Eliyaza n Itama. ");
INSERT INTO asg_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Na lo va ɗaɗa ula a̱ muku n ali n Haruna, aza na e erengi adama a na a yaꞋan ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ama Nadabu n Abihu a̱ kuwa̱i e kelime ka Vuzavaguɗu ɗe e meremune ma Sinai, a makyan ma na a yaꞋin alyuka n ili i ma̱gula̱ni a akina tsu na u kpa̱ɗa̱i kugaꞋan. Ɗa a̱ kuwa̱i babu vicuꞋu, adama a nannai Eliyaza n Itama ele ɗa a yaꞋin ulinga u tsuganu koɓolo n esheku e le Haruna. ");
INSERT INTO asg_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, ");
INSERT INTO asg_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","<<Tuka̱ n kumaci ka aza e Levi ka̱ta̱ vu zuwa le okpo a̱ɓa̱nki a Haruna a̱ ubuta̱ wu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ka̱ta̱ kpamu a yaꞋanka Haruna a̱ga̱nda̱ koɓolo n likuci ka̱ɓa̱la̱, punu m pulai vu Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","I ta̱ kpamu o kokpo aza a na a kinda ucanuku wu ulinga u Ma̱va̱li mo Oɓolo ma, a kuyaꞋanka aza a Isaraila ulinga punu a asuvu a̱ Ma̱va̱li ma. ");
INSERT INTO asg_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ili i na aza e Levi a kuyaꞋan i ɗaɗa a̱ ɓa̱nka̱ Haruna m muku n ali n ni ulinga. ");
INSERT INTO asg_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Zagba Haruna m muku n ali n ni a yaꞋan ulinga u tsuganu, vuma na baci wi uzagbi ba ɗa u yawai ɗevu m Ma̱va̱li ma i ta̱ a kuna yi.>> ");
INSERT INTO asg_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ɗa Vuzavaguɗu u doku u danai Musa. ");
INSERT INTO asg_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","<<La̱na̱, n zagba ta̱ aza e Levi a̱ ka̱tsuma̱ ka aza a Isaraila a̱ una̱ u maku ma iyain ma na a̱na̱ku a̱ ni a̱ gita̱i kumatsa. Aza e Levi ra̱ka̱ i ta̱ o kokpo uma a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Muku n iyain dem n va̱ n ɗa. Ili i na i ɗikai a makyan ma na mu unai muku n iyain ma aza a Masar, ɗa kpamu n kanzakai ka̱ci ka̱ va̱ muku n iyain ma aza a Isaraila, ko maku ma vuma ko ma manama. Mi ta̱ o kokpo ma̱ va̱. Mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa ɗe e meremune ma Sinai, u danai, ");
INSERT INTO asg_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","<<Vu kece muku n ali ma aza e Levi a̱ ka̱tsuma̱ ki iꞋuwa i le n kumaci ku le. Ka̱ta̱ vu kece mavali lakam ma na wuma u ni u yawai wotoi ute n umaci a kubana gaɗi.>> ");
INSERT INTO asg_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ɗa Musa u kecei le tsu na kadanshi ka Vuzavaguɗu ka danai u yaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Nava ɗaɗa ula a̱ muku n ali ma aza e Levi. Geshon, n Kohatu, koɓolo m Merari. ");
INSERT INTO asg_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Nava tamkpamu ɗaɗa ula a̱ muku n ali n Geshon, Libini n Shime. ");
INSERT INTO asg_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Na tamkpamu ɗaɗa muku n ali n Kohatu a̱ ka̱tsuma̱ ka̱ muku mu umaci n le, Amuram, n Iziharu, koɓolo n Heburon, n Uziyelu. ");
INSERT INTO asg_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Muku n ali m Merari ele ɗa Mahali m Mushi. Ele ɗa kumaci ka aza e Levi a̱ ka̱tsuma̱ ki iꞋuwa ki ikaya i le. ");
INSERT INTO asg_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","A̱ ka̱tsuma̱ ko mogbodo me Geshon maꞋa a̱ ciya̱i kumaci ku Libini n ku Shime. Na lo va ɗaɗa mogbodo me Geshon. ");
INSERT INTO asg_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","A kumaci ku re ku nanlo, e kece ta̱ muku n ali aza a na a yawai wotoi a kubana gaɗi, i ta̱ uma a̱kpa̱n e cindere n amangatawantawun (7, 500). ");
INSERT INTO asg_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Kumaci ku Geshon ele ɗa aza a na a kuda̱sa̱ngu a̱ ka̱livi a̱ ka̱ca̱pa̱ ka̱ Ma̱va̱li ma̱ Ka̱shile ka. ");
INSERT INTO asg_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliyasafa maku ma Laye a̱yi ɗa vuza kelime vu kpaꞋa ku tsukaya ku Geshon. ");
INSERT INTO asg_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Punu a̱ Ma̱va̱li mo Oɓolo ma, ele ɗa a̱ kula̱na̱ Ma̱va̱li ma̱ Ka̱shile n ili i na a tsu palaka kaꞋa, n kakashi ku utsutsu u Ma̱va̱li mo Oɓolo ma dem, ");
INSERT INTO asg_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","n akashi a ulanga a na i uka̱ra̱Ꞌi m Ka̱pa̱m ka n katalikalyuka, n kakashi ku utsutsu ku ulanga ka feu n ashiyatsu e le. Ele ɗa a kuyaꞋan ulinga u kula̱na̱ akashi a na i punu dem. ");
INSERT INTO asg_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","A̱ ka̱tsuma̱ ko mogbodo ma Kohatu ɗaɗa a̱ ciya̱i kumaci ku Amuram, n Iziharu, koɓolo n Heburon, n Uziyelu. Na lo va ɗaɗa mogbodo ma Kohatu. ");
INSERT INTO asg_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Mekecu ma̱ muku n ali aza a na a yawai wotoi u te n umaci a kubana gaɗi, i ta̱ uma a̱kpa̱n kunla̱i n amangatawa̱nta̱li (8, 600). Aza a Kohatu tamkpamu ele ɗa a̱ kula̱na̱ Ubuta̱ u Ciɗa. ");
INSERT INTO asg_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kumaci ku Kohatu ele ɗa aza a na a kuda̱sa̱ngu a uɓon u ɗaka u Ka̱pa̱m wa. ");
INSERT INTO asg_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Vuza kelime vu kumaci ku Kohatu va a̱yi ɗa Elizafan maku ma Uziyelu. ");
INSERT INTO asg_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ulinga u le u ɗaɗa kula̱na̱ akpati vu uzuwakpani, n kirukpa, n kashamkpatsu, n katalikalyuka, n ucanuku wu ulinga wu ubuta̱ u ciɗa, u na anan ganu a ci yaꞋanka ulinga n kakashi ku utsutsu n ulinga u na u buwai adama a nanlo dem. ");
INSERT INTO asg_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eliyaza, maku ma Haruna ganu a̱yi ɗa vuza kelime vu kumaci ka aza e Levi, ka̱ta̱ kpamu u la̱na̱ aza na a kuyaꞋan ulinga a̱ ubuta̱ u ciɗa. ");
INSERT INTO asg_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","A̱ ka̱tsuma̱ ko mogbodo ma Merari ɗaɗa a̱ ciya̱i kumaci ka aza Mahali n ku Mushi. Nava ele ɗa kumaci ku Merari. ");
INSERT INTO asg_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Mekecu ma̱ muku n ali aza na a yawai wotoi u te n umaci a kubana gaɗi i ta̱ uma a̱kpa̱n a̱ ta̱li n amangatawenre (6, 200). ");
INSERT INTO asg_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Vuza kelime vu kumaci ku Merari a̱yi ɗa Zuriye kolobo ka Abihayi. Ele ɗa a̱ kuda̱sa̱ngu a uɓon u gaɗi u Ma̱va̱li ma̱ Ka̱shile ka. ");
INSERT INTO asg_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ulinga u na e nekei muku n ali m Merari ɗaɗa kula̱na̱ nshikpu n ka̱pa̱m a, n aburakpatsu a̱ ni, nu nshikpu, n kumi, n ucanuku wu ulinga u ni dem, n ulinga u na u buwai adama a nanlo dem, ");
INSERT INTO asg_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","koɓolo n kula̱na̱ ku nshikpu mu ulanga wa n kumi ku ni, n aguta ali n awin e le dem. ");
INSERT INTO asg_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa n Haruna m muku n ali n ni ele ɗa a̱ kuda̱sa̱ngu a uɓon u kasana u ka̱pa̱m ka, e kelime ka̱ Ma̱va̱li mo Oɓolo. Ele ɗa a̱ kula̱na̱ ubuta̱ u ciɗa adama a aza a Isaraila. Vuma vi yoku kau vu na baci u yawai ɗevu n ubuta̱ u ciɗa wa, i ta̱ a kuna yi. ");
INSERT INTO asg_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ɗa Musa n Haruna e kecei ka̱bunda̱i ka aza e Levi tsu na Vuzavaguɗu u danai le a yaꞋan. Tsu na e kecei le mogbodo-mogbodo dem, ali ra̱ka̱ aza a na ayin e le a yawai wotoi u te n umaci a kubana gaɗi, a yawa ta̱ a̱kpa̱n kamanga n e re (22,000). ");
INSERT INTO asg_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ɗa Vuzavaguɗu u danai Musa, <<Kece muku n ali n iyain ma aza a Isaraila, muku n na n yawai wotoi u te n umaci a kubana gaɗi, ka̱ta̱ vu ɗana ula e le. ");
INSERT INTO asg_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ka̱ta̱ i zagbaka mu aza e Levi okpo una̱ u muku n ali n iyain ma aza a Isaraila, koɓolo n ilikuzuwa ya aza e Levi a̱ una̱ wi ili i iyain yi ilikuzuwa ya aza a Isaraila. Mpa ɗa Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ɗa Musa u kecei muku n ali n iyain ma aza a Isaraila tsu na Vuzavaguɗu u danai ni. ");
INSERT INTO asg_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ka̱bunda̱i ka̱ muku n ali n iyain n na e kecei ula e le, aza na kpamu a yawai wotoi u te n umaci a kubana gaɗi, a yawa ta̱ uma a̱kpa̱n amangatawenre n e re n amangatawenre n amangatatsunkupa n a tatsu (22, 273). ");
INSERT INTO asg_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, ");
INSERT INTO asg_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","<<Zagba aza e Levi a̱ una̱ u muku n iyain ma aza a Isaraila. Ka̱ta̱ kpamu vu zagba ilikuzuwa i iyain ya aza e Levi a̱ una̱ wi ili i iyain yi ilikuzuwa ya aza a Isaraila. Aza e Levi i ta̱ kokpo uma a̱ va̱. Mpa ɗa Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A na wo okpoi ka̱bunda̱i ka̱ muku n ali n iyain ma aza a Isaraila ka laꞋa ta̱ ka aza e Levi n uma amangatawenre n amangatatsunkupa n aza a tatsu (273), mayun ɗa u bono u shiba̱ muku n na m pasai va. ");
INSERT INTO asg_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ka̱ta̱ vi isa azurufa a tawun adama a vuma vi te lakam, tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ka na a̱miki a̱ ni a yawai gera kamanga. ");
INSERT INTO asg_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Vi neke ikebe i na vi shiba̱ka̱i muku n na m pasai va u Haruna m muku n ali n ni.>> ");
INSERT INTO asg_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ɗa Musa wi isai ikebe i na a̱ shiba̱ka̱i muku mi Isaraila n na m pasai va n na n laꞋi ka̱bunda̱i ka̱ muku ma aza e Levi. ");
INSERT INTO asg_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","A maku ma iyain ma aza a Isaraila, ɗa wi isai azurufa a na a̱miki a̱ ni a yawai ka̱kpa̱n ke te n amangatawantatsu n amangatatsu n i tawun (1, 365), tsu kagisamkpatsu ka̱ a̱Ꞌisa̱. ");
INSERT INTO asg_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ɗa Musa u nekei Haruna m muku n ali n ni ikebe yu ushibi ya, tsu na vuzavaguɗu u danai ni. ");
INSERT INTO asg_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa koɓolo n Haruna u danai, ");
INSERT INTO asg_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","<<Kecei muku n ali n Kohatu kau a kumaci ka aza e Levi, tsu na i n limata i le n iꞋuwa yi ikaya i le. ");
INSERT INTO asg_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Kecei muku n ali dem aza a na a yawai a̱ya̱ kamangankupa a kubana amangerenkupa, aza a na kpamu a yawai a yaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","<<Nava ɗaɗa ulinga u muku n ali n Kohatu a̱ Ma̱va̱li mo Oɓolo, a̱ la̱na̱ ucanuku u na u laꞋi n ciɗa dem. ");
INSERT INTO asg_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","A makyan ma na yi a kuciga kuɗa̱nga̱ kusabaꞋa ubuta̱, avu Haruna m muku n nu a̱ɗa̱ ɗa ya̱ kugita̱ ku uwa punu a̱ Ka̱pa̱m ka, ka̱ta̱ i shikpa kakashi ka na ki a̱ ubuta̱ u na u laꞋi n ciɗa ka̱ta̱ i palaka akpati vu Uzuwakpani va. ");
INSERT INTO asg_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ka̱ta̱ kpamu o doku a palaka n ukpan u maraɗika u singai, ka̱ta̱ o polo a mayaga ma na mi an mini mu usuni. Yeve a zuwaka akpati vu Uzuwakpani va aburakpatsu a na a̱ kuɓa̱na̱ka̱ yi. ");
INSERT INTO asg_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","<<A gaɗi vu kirukpa ku na a kuzuwa boroji vu na a zagbai va, o polo mayaga ma na mi tsu mini mu usuni ma, a kiyangu ɗe feu ebelyu, ni nvene, n apara, koɓolo n edele, adama e kuneꞋe ki ili i kusoꞋo ka̱ta̱ a kiyangu ɗe boroji vu na a zagbai va. ");
INSERT INTO asg_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ka̱ta̱ kpamu i pala ucanuku wa m mayaga ma shili, ka̱ta̱ i pala le n ukpan u maraɗika u singai. Yi ta̱ kpamu a kuzuwaka yi aburakpatsu a na a̱ kuɓa̱na̱ka̱ yi. ");
INSERT INTO asg_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","A ɗika kpamu kakashi ka̱ mini mu usuni ko yoku a pala kashamkpatsu ka̱ ma̱kuni nu nkuni n ni dem, n ili i kukima̱ka̱ akina, n a̱mbu a̱ ni koɓolo n edele a na a̱ tsu tsunku maniꞋin ma na a tasuku akina a. ");
INSERT INTO asg_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ka̱ta̱ kpamu a kuma kaꞋa n ucanuku wu ulinga u ni dem n ukpan u maraɗika u singai, ka̱ta̱ kpamu a zuwa yi a aburakpatsu a na a̱ kuɓa̱na̱ka̱ yi. ");
INSERT INTO asg_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ka̱ta̱ a pala katalikalyuka ka azanariya ka m mayaga ma na mi tsu mini mu usuni, i kuma kpamu n ukpan u maraɗika u singai, yeve a zuwaka yi aburakpatsu a kuɓa̱na̱ka̱ yi. ");
INSERT INTO asg_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","I ta̱ kpamu a kuɗika ucanuku wu ulinga u na a ci yaꞋanka ulinga a̱ ubuta̱ u ciɗa, ka̱ta̱ a̱ ka̱ta̱la̱ le m mayaga ma̱ mini mu usuni ma, a kuma n ukpan u maraɗika u singai, ka̱ta̱ a zuwa le a aburakpatsu a̱ kuɓa̱na̱ka̱ yi. ");
INSERT INTO asg_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","I ta̱ a̱ kupura̱ kokomo ka na ki asuvu a katalikalyuka ka, ka̱ta̱ a pala kaꞋa m mayaga ma̱ mini ma̱ ma̱ɗiya̱. ");
INSERT INTO asg_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Gaɗi vu ni va ka̱ta̱ a zuwa ucanuku u na a ci yaꞋan ulinga n u ɗa a katalikalyuka ka, ili i ɗaɗa a̱mbu a na a̱ tsu pura̱ka̱ akina, n aya a na i n a̱jivu, n ili i kupura̱ka̱ kayala, n apara a̱ gba̱ra̱-gba̱ra̱, n ucanuku u na a ci yaꞋanka ulinga a̱ ubuta̱ u katalikalyuka ka, ka̱ta̱ kpamu a kuma le n ukpan u maraɗika u singai. I ta̱ kpamu a kuzuwaka katalikalyuka ka aburakpatsu a̱ kuɓa̱na̱ka̱. ");
INSERT INTO asg_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","A ayin a na baci Haruna m muku n ali n ni o kotsoi kufoɓuso ubuta̱ u ciɗa n ili yu ulinga i ni dem, ɗaɗa o foɓusoi kuɗa̱nga̱ a kubana a̱ ubuta̱ u yoku, ka̱ta̱ muku n ali n Kohatu a̱ ta̱wa̱ a ɗika ili ya. Ama ka̱ta̱ a saꞋwa ili i ciɗa ya ba, a yaꞋan baci nannai i ta̱ a̱ kukuwa̱. Nava ɗaɗa ulinga u muku n ali n Kohatu a makyan ma na baci de i a̱ kuka̱ta̱la̱ Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","<<Eliyaza maku ma Haruna, ganu, a̱yi ɗa vuza na wa̱ kula̱na̱ maniꞋin ma kutasuku akina, n ili i ma̱gula̱ni, n kuneꞋe ki ishina ku na a kiwanai, koɓolo m maniꞋin me kerengu. Ka̱ta̱ kpamu u la̱na̱ Ma̱va̱li ma̱ Ka̱shile koɓolo n ili i na yi punu dem, n ubuta̱ u ciɗa wa koɓolo n ili yu ulinga i ni.>> ");
INSERT INTO asg_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ɗa Vuzavaguɗu u danai Musa n Haruna, ");
INSERT INTO asg_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","<<Ka̱ta̱ i ka̱sukpa̱ kumaci ku Kohatu ku kotso a̱ ka̱tsuma̱ ka aza e Levi ba. ");
INSERT INTO asg_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","YaꞋin nannai n ele adama a na o yongo lo n wuma ka̱ta̱ a̱ kuwa̱ ba. A ayin a na baci a yawai ɗevu n ubuta̱ u ciɗa, Haruna m muku n ni n ɗa a kuꞋuwa punu a̱ ubuta̱ u ciɗa wa, ka̱ta̱ e neke yaba dem ulinga u na u kuyaꞋan n ucanuku u na u kuɗika. ");
INSERT INTO asg_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ama muku n Kohatu n uwa baci ubuta̱ u ciɗa wa a̱ ubuta̱ u na kpamu ucanuku u ciɗa wi, ali enei ili i ciɗa na yi punu asuvu ko kenu ɗa baci, i ta̱ a̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","<<Kece muku n ali n Geshon tsu na i o mogbodo me le n kumaci ku le. ");
INSERT INTO asg_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Vu kece aza a na a yawai a̱ya̱ kamangankupa n umaci a kubana amangerenkupa, n aza a na a yawai a yaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Na va ɗaɗa ulinga u kumaci ku Geshon, ili i na o kuyongo a kuyaꞋan i ɗaɗa ulinga n kuɗika ku ucanuku. ");
INSERT INTO asg_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ele ɗa aza a na a kuɗika kakashi ku utsutsu ka̱ Ma̱va̱li ma̱ Ka̱shile, m Ma̱va̱li mo Oɓolo, koɓolo n ka̱ɓa̱ya̱mkpa̱tsu ka̱ ni ku ukpan u maraɗika, n kakashi ku utsutsu u Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","I ta̱ kpamu a kuɗika kakashi ka nshilya mu ulanga u ka̱pa̱m wa, ma na ma̱ ka̱ra̱Ꞌi Ma̱va̱li ma̱ Ka̱shile ka n katalikalyuka feu, n kakashi ka na ka pasamgbanai ulanga u ka̱pa̱m wa dem, n ashiyatsu koɓolo n ili ra̱ka̱ yu ulinga. Aza e Geshon i ta̱ a kuyaꞋan ulinga tsu na u gaꞋin a yaꞋan n ili i nampa dem. ");
INSERT INTO asg_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ulinga ra̱ka̱ u na muku n Geshon n kuyaꞋan, wi ta̱ a kuwala n uzuwi u a̱shi u Haruna m muku n ni. Vu peceke yaba dem n i na u kuyaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Na lo va ɗaɗa ulinga u kumaci ku Geshon a̱ Ma̱va̱li mo Oɓolo. Itama maku ma Haruna, ganu, a̱yi ɗa u kutono n ele tsu na a kuwalaka n ulinga wa. ");
INSERT INTO asg_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","<<Vuzavaguɗu u doku u danai Musa, kece muku n ali m Merari tsu na i o mogbodo me le n kumaci ku le. ");
INSERT INTO asg_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Vu kece aza na a yawai a̱ya̱ kamangankupa n umaci a kubana amangerenkupa, aza a na o yotsoi a yaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Na va ɗaɗa ulinga u na a kuyaꞋan a makyan ma na i a kuyaꞋan ulinga punu a̱ Ma̱va̱li mo Oɓolo ma. Ulinga u ɗaɗa: kuɗika ku nshikpu mu utsutsu u Ma̱va̱li ma̱ Ka̱shile, n aburakpatsu a̱ ni, nu nshikpu koɓolo n ashamkpatsu e le, ");
INSERT INTO asg_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","koɓolo kpamu nu nshikpu n na a̱ kuka̱ra̱ka̱ mashilya mu ulanga n a̱mi e le, n aguta, n awin koɓolo n ucanuku wu ulinga u nanlo dem. Vu peceke yaba dem i na u kuyaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Na lo va ɗaɗa ulinga u kumaci ku muku n ali m Merari a̱ Ma̱va̱li mo Oɓolo. Itama kolobo ka Haruna, ganu, a̱yi ɗa vuza na u kula̱na̱ le.>> ");
INSERT INTO asg_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ɗa Musa n Haruna koɓolo n aza e kelime a uma e kecei olobo a Kohatu tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ali ra̱ka̱ a na a yawai a̱ya̱ kamangankupa n umaci a kubana amangerenkupa, aza na a yawai kuyaꞋan ulinga u Ma̱va̱li mo Oɓolo, ");
INSERT INTO asg_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","tsu na e kecei le kumaci-kumaci ra̱ka̱ a yawa ta̱ a̱kpa̱n e re n amangatawencindere n amangerenkupa (2, 750). ");
INSERT INTO asg_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Na va ɗaɗa ka̱bunda̱i ka kumaci ka Kohatu, ra̱ka̱ vi le vu na a yaꞋin ulinga a̱ Ma̱va̱li mo Oɓolo, ɗa Musa n Haruna e kecei tsu na Vuzavaguɗu u danai ni u yaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ɗa kpamu e kecei kumaci ku Geshon, tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Ɗa e kecei muku n ali aza a na a yawai a̱ya̱ kamangankupa n umaci a kubana amangerenkupa, ele na a kufuɗa kuyaꞋan ulinga punu a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Ka̱bunda̱i ke le ka yawa ta̱ uma a̱kpa̱n e re, n amangatawa̱nta̱li n kamangankupa (2, 630). ");
INSERT INTO asg_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Na va ɗaɗa mekecu ma kumaci ku Geshon, aza na a yawai kuyaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo, ele na Musa n Haruna e kecei tsu na Vuzavaguɗu u yaꞋankai Musa kadanshi. ");
INSERT INTO asg_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ɗa kpamu e kecei kumaci ku Merari, tsu na i kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Ali ra̱ka̱ a na a yawai a̱ya̱ kamangankupa n umaci a kubana amangerenkupa, aza a na a yawai kuyaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Ka̱bunda̱i ke le ki ta̱ a̱kpa̱n a tatsu, n amangatawenre (3, 200). ");
INSERT INTO asg_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Na lo va ɗaɗa ka̱bunda̱i ka kumaci ka Merari, ele na Musa n Haruna e kecei tsu na Vuzavaguɗu u danai ni. ");
INSERT INTO asg_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ɗa Musa koɓolo n Haruna n aza e kelime a uma a Isaraila e kecei ka̱bunda̱i ka aza e Levi tsu na i a kumaci-kumaci m kpaꞋa-kpaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ɗa e kecei muku n ali ra̱ka̱ aza a na a yawai a̱ya̱ kamangankupa n umaci a kubana a̱ya̱ amangerenkupa, aza a na a yawai kuyaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Ka̱bunda̱i ke le ka yawa ta̱ a̱kpa̱n kunla̱i n amangatawantawun n amanga̱na̱shi (8, 580). ");
INSERT INTO asg_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ɗa e pecekei yaba dem n ulinga u na u kuyaꞋan n ucanuku u na kpamu u kuɗika, tsu na Vuzavaguɗu u danai Musa. Tsu nanlo tsu ɗa e kecei uma ra̱ka̱ derere tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa ɗa u danai, ");
INSERT INTO asg_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","<<Dana aza Isaraila a̱ uta̱ka̱ vuza na wi nu mɓa̱la̱ mu ukutu ko mali ma tsali ko unata u yoku u na u ciya̱i a̱ ubuta̱ u kusaꞋwa keven ki ikyamba ka vuma punu a̱ ka̱tsura̱. ");
INSERT INTO asg_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Uta̱ka̱i vali ko vuka punu a̱ ka̱tsura̱ ka, adama a na talo wa uka ka̱tsura̱ ke le unata, a̱ ubuta̱ u na mpa n kuda̱sa̱ngu n ele.>> ");
INSERT INTO asg_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ɗa aza a Isaraila a̱ uta̱ka̱i le punu a̱ ka̱tsura̱ ka, tsu na Vuzavaguɗu u danai le a yaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","<<YaꞋan kadanshi n uma a Isaraila. A ayin a na baci vali ko vuka vu nusakai toku, u yaꞋanka ta̱ Vuzavaguɗu unushi, vuma vu nanlo u ronoko ta̱ ka̱ci ka̱ ni unushi, ");
INSERT INTO asg_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","vuza va wi ta̱ a̱ kushika̱ unushi u na u yaꞋin va. Ka̱ta̱ kpamu u bonoko ili i na wi ishi u la̱nga̱sa̱i va, yeve kpamu u doku ugboku u te a̱ ka̱tsuma̱ ku u tawun. ");
INSERT INTO asg_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ɗa baci vuza na a nusakai va u kuwa̱i, wi baci n vuza na e kuneke katsupu ka ba, katsupu ka e neke Vuzavaguɗu a kubana u ganu ka̱ta̱ kpamu u neke malala adama a̱ kushika̱ ku unushi u ni. ");
INSERT INTO asg_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","KuneꞋe ku ciɗa ku na a yaꞋin dem e neke ku ɗa a kubana u ganu, ku ɗa kokpo ku ni. ");
INSERT INTO asg_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ganu dem wi ta̱ e kureme kuneꞋe ku na a̱ tuka̱i ni dem ku ɗa kokpo ku ni.>> ");
INSERT INTO asg_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","<<YaꞋan kadanshi n aza a Isaraila, vuka vu vuza vu kpa̱ɗa̱ baci kuka̱na̱ kaci ali ɗa uneki u ka̱ɗu n vali ni va u kotsoi, ");
INSERT INTO asg_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ali ɗa u vaki n vali vu yoku, ama vali vi ni va vi yeve ba, babu kpamu vuza na we enei a na wa dana, adama a na a saꞋwa kucina yi a kuyaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ɗa baci vali vu ka̱na̱i kene nwalu n vuka vi ni m kpa̱ɗa̱i kugaꞋan, ko a na u na̱mgba̱i ɗe, ko kusheshe ku ni kuta̱ magaba ba, ");
INSERT INTO asg_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","u ɗika vuka vi ni a kubana u ganu, u ɗika kpamu ugboku u te u ifa a̱ ka̱tsuma̱ ka kupa ka kiya ki ishina. U kutsungu maniꞋin ko ili i ma̱gula̱ni ba, adama a na kuneꞋe ku ɗa ciya̱ u yeve ko vuka va vi ta̱ n unushi ko wi n u ɗa ba. ");
INSERT INTO asg_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","<<Ganu wi ta̱ a̱ kuta̱wa̱ka̱ n vuka vu nanlo ka̱ta̱ u zuwa yi u shamgba kelime ka Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Wi ta̱ e kukenuku mini ma ciɗa a̱ ma̱diki, ka̱ta̱ u kenuku kubuta̱ ku kayala ku ubuta̱ u ma̱va̱li u tsungu punu a̱ mini ma. ");
INSERT INTO asg_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ka̱ta̱ ganu u zuwa vuka va vu shamgba e kelime ka Vuzavaguɗu, yeve ganu u shikpa ka̱nji ka vuka ka ka̱ta̱ u kiyanku vuka va alyuka a ili i kashina e ekiye a̱ ni wo okpo yi ili i kuciɓa, a̱yi tamkpamu u ka̱na̱ ma̱diki ma̱ mini mo okono e ekiye a̱ ni ma na a ci yaꞋanka vuza una̱. ");
INSERT INTO asg_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","U zuwa vuka va akucina ka̱ta̱ u dana yi, <Ɗa baci vali vi yoku vu vaki n avu ba, ka̱sukpa̱ vu laꞋaka m mini mo okono ma nampa ma na ma tsu zuwa una̱ u wuya. ");
INSERT INTO asg_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ama vi baci a ku vakusu n vali vi yoku vu na vi vu nu ba, ");
INSERT INTO asg_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","yaꞋan Vuzavaguɗu u zuwaka wu una̱ u wuya a̱ ka̱tsuma̱ ka uma a̱ nu a̱ ubuta̱ u kubonoko wu madari, vo kudoku va matsa ba, ka̱tsuma̱ ka̱ nu ki ta̱ a kushita. ");
INSERT INTO asg_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","YaꞋan mini mu una̱ u wuya ma nampa ma uwa a̱ ka̱tsuma̱ ka̱ nu, ka̱ta̱ ma zuwa kaꞋa ka shita ali kamatsatsu ka̱ nu ka paɗara.> Ka̱ta̱ vuka va wu ushuku, <Ta nannai, ta nannai.> ");
INSERT INTO asg_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","<<Ka̱ta̱ ganu va u ɗana una̱ u wuya u nampa wa a magbaganla, ka̱ta̱ u za̱Ꞌa̱ iɗani ya gbende m mini mo okono. ");
INSERT INTO asg_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ka̱ta̱ u zuwa vuka va vu soꞋo mini mo okono ma, ma na ma̱ tsu tuka̱ n ukuna wu una̱ u wuya wa. Mini ma nampa ma mi ta̱ a kuꞋuwa yi a̱ ka̱tsuma̱ ka̱ta̱ me neke yi mɓa̱la̱ n ka̱tsuma̱ m gbani-gbani. ");
INSERT INTO asg_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","A̱yi ganu wi ta̱ a kuɗika kuneꞋe ki ishina ka adama e cisheꞋe tsa e ekiye a vuka a, ka̱ta̱ u ɗa̱ngusa̱ka̱ Vuzavaguɗu, yeve u tuka̱ a katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","A̱yi ganu va ka̱ta̱ u shatangu kukiye ku ni n kiya adama e kuneꞋe ka alyuka a kuciɓasa, ka̱ta̱ u songu a ɗa a katalikalyuka, u kotso baci u zuwa vuka va u soꞋo mini ma. ");
INSERT INTO asg_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","U la̱nga̱sa̱ baci ka̱ci ka̱ ni, u shiya kpamu kaci a̱ ubuta̱ u vali vi ni ba, ɗa baci a zuwai ni u soꞋi mini ma na a ci yaꞋanka una̱, mi ta̱ e kuneke yi mɓa̱la̱ ka̱u. Ka̱ta̱ ka̱tsuma̱ ka̱ ni ka shita, ka̱ta̱ ta na u yamba, wi ta̱ ta na o kokpo vuza na a yaꞋankai una̱ a̱ ka̱tsuma̱ ka uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ama vuka va u la̱nga̱sa̱ baci ka̱ci ka̱ ni ba wi kpamu n unata ba, wi ta̱ o kokpo vuza babu unushi wi ta̱ a kufuɗa wa̱ ciya̱ maku. ");
INSERT INTO asg_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","<<Na ɗaɗa wila̱ adama e cisheꞋe, a ayin a na baci vuka vu la̱nga̱sa̱i ka̱ci ka̱ ni a̱ ubuta̱ u kuyaꞋan tsugbani n vali vi yoku, ");
INSERT INTO asg_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ko ɗa baci vali u ciya̱i ka̱ɗu ke cisheꞋe adama a na wi ta̱ e kusheshe vuka vi ni n tsugbani. U zuwa vuka va e ekiye a Vuzavaguɗu, ka̱ta̱ ganu u zuwa yi u tono wila̱ u nampa dem, ");
INSERT INTO asg_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Vali vi ta̱ o kokpo babu unushi a̱ ka̱tsuma̱ ki ili i na u yaꞋin dem, ama vuka wi ta̱ a kuɗika atakaci a̱ ili i na yi punu dem.>> ");
INSERT INTO asg_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","<<YaꞋan kadanshi n aza a Isaraila ka̱ta̱ vu dana le, ayin a na baci vuka ko vali vi a kuciga kuyaꞋan akucina, a na u kutono Vuzavaguɗu vi ni tsu vuza na a zagbai, ");
INSERT INTO asg_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","u gaꞋan ta̱ u ka̱sukpa̱ kusoꞋo ku ma̱ra̱ ko ili i kusoꞋo yu utsura. Ka̱ ta̱ kpamu u soꞋo ili i kalam ba ko ma̱ra̱ ma na a yaꞋin n umaci wu nɗanga ba, kpamu ka̱ ta̱ u soꞋo ma̱kya̱n ma savu ba, ka̱ta̱ kpamu u lyaꞋa mambulu ma̱ ta̱ku ko u takuma me ɗekpu. ");
INSERT INTO asg_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Wi baci de o kuyongo tsu vuza na a zagbai, ka̱ta̱ u soꞋo ma̱kya̱n ma na a yaꞋin n a̱vu ko n icuꞋu i maɗanga mi inabi ba. ");
INSERT INTO asg_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","<<A makyan ma na wi a̱ ka̱tsuma̱ ka kukucina a uzagbi a̱ ni, ka̱ta̱ u ka̱sukpa̱ kutanu ku saꞋwa kaci ka̱ ni ba, sai ayin a na u yaꞋin akucina n Vuzavaguɗu va o kotsoi ra̱ka̱-ra̱ka̱. U gaꞋan ta̱ u yongo ciɗa, ka̱ta̱ u ka̱sukpa̱ ka̱nji ka kaci ka̱ ni ka yaꞋan ugaɗi. ");
INSERT INTO asg_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","<<A̱ ka̱tsuma̱ ka ayin a na u pecei ka̱ci ka̱ ni adama a Vuzavaguɗu, ka̱ta̱ u bana ɗevu n keven ki ikyamba ba. ");
INSERT INTO asg_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ko a̱na̱ku ko esheku ko vuza ni vi yoku ɗa baci u kuwa̱i, ka̱ta̱ u yawa ɗevu ba ta lo wa natukpa ka̱ci ka̱ ni. Adama a na u pece ka̱ci ka̱ ni adama a̱ Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A ayin a na u pecei ka̱ci ka̱ ni dem, wo okpo ta̱ ciɗa a kubana u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","<<Vuza u yikpa̱ baci ɗa u kuwa̱i gogo lo ɗevu n a̱yi, na lo u natukpa ta̱ ka̱ci ka̱ ni, adama a nannai u puna ka̱nji ka a kanna ke cindere ka na a kutakpaka yi nshinda̱. ");
INSERT INTO asg_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A kanna ka̱ kunla̱i u tuka̱ m moɗoi n re ko ntapambara n re aza wawaꞋa a kubana u ganu lo a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ganu u lyuka me te tsu alyuka a̱ unushi, me te kpamu adama a alyuka o kusongu, adama a na u takpaka ka̱ci ka̱ ni unushi. Adama a na u nusa ta̱ a na u ka̱sukpa̱i keven ki ikyamba ka̱ yikpa̱i ɗevu n a̱yi. Ka̱ta̱ a kanna ka nanlo kpamu u doku u pece ka̱ci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","U gaꞋan ta̱ u doku u pece ka̱ci ka̱ ni u Vuzavaguɗu derere tsu na u yaꞋin ɗe a ayin a na a lazai. U ta̱wa̱ m ma̱giri ma na ma yawai ka̱ya̱ ke te, u neke adama a alyuka a̱ unushi. Ayin a na a lazai e kukece a ɗa ba, adama a na wi ishi ta̱ u natukpa ka̱ci ka̱ ni a ayin a nanlo a. ");
INSERT INTO asg_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","<<Gogo na wila̱ u ɗa na a kubana u vuza na a zagbai, a ayin a na baci ayin a upeci a̱ ni o kotsoi. A̱ tuka̱ n vuza va a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ta ɗe u kuyaꞋan kuneꞋe ku ni a kubana u Vuzavaguɗu, u lyuka ma̱giri ma na ma yawai ka̱ya̱ ke te ɗa mi babu uꞋiwin u Ka̱shile adama alyuka o kusongu. M mashan ma̱ ka̱ya̱ ke te feu ma na mi babu uꞋiwin u Ka̱shile adama e kuneꞋe ku unushi, n ka̱giri kpamu ka babu uꞋiwin u Ka̱shile adama e kuneꞋe ki ida̱shi i ma̱ta̱na̱, ");
INSERT INTO asg_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","koɓolo n kuneꞋe ki ishina n ki ili i kusoꞋo, m mabana mo boroji vu na vi n yisiti ba, n akala a na a yaꞋin n kiya ku singai usatari m maniꞋin, n emeshe a na kpamu a putalai m maniꞋin. ");
INSERT INTO asg_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Ka̱ta̱ ganu u tuka̱ u Vuzavaguɗu, yeve e neke kuneꞋe ku unushi ku ni n kuneꞋe ku kusongu ku ni. ");
INSERT INTO asg_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Wi ta̱ e kuneke mabana mo boroji vu na vi n yisiti ba, ka̱ta̱ u lyuka ka̱giri tsu kuneꞋe ku ma̱ta̱na̱ u Vuzavaguɗu, koɓolo n kuneꞋe ki ishina n ki ili i kusoꞋo dem. ");
INSERT INTO asg_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Lo a̱ utsutsu u Ma̱va̱li mo Oɓolo ma, a̱yi vuma vu na e pecei va u puna ka̱nji ka̱ ni ka na u nekei ka̱ci ka̱ ni ka. Ka̱ta̱ u ɗika ka̱nji ka u zuwa kaꞋa akina lo a ɗaka vu katalikalyuka ka, punu a̱ ubuta̱ wa alyuka a̱ ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ana vuma va u kotsoi kupuna ka̱nji ka̱ ni, a̱yi ganu wi ta̱ a kuɗika mavatsu ma̱ ka̱giri ka na a suꞋwain va, n kemeshe ke te n kakala feu ke te a na i punu a mabana ma dem vi le a yaꞋan babu yisiti. Ka̱ta̱ u zuwa le e ekiye a vuza na u pecei ka̱ci ka̱ ni va. ");
INSERT INTO asg_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","A̱yi ganu va ka̱ta̱ u ɗengusa̱ le e kelime ka Vuzavaguɗu tsu kuneꞋe ku kuɗa̱ngusa̱, ku ɗa ki ta̱ ciɗa kpamu ku ganu ku ɗa, koɓolo m ma̱ka̱nga̱ ma na a̱ ɗengusa̱i m ma̱kuta̱ ma na e nekei. O kotso baci ka̱ta̱ vuza na e pecei va wi ta̱ a kufuɗa wo soꞋo ma̱kya̱n. ");
INSERT INTO asg_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","<<Na va ɗaɗa wila̱ u vuza na u ɗikai uzuwakpani u kupece ka̱ci ka̱ ni adama a Vuzavaguɗu. KuneꞋe ku ni a kubana u Vuzavaguɗu n tsu na u pecei ka̱ci ka̱ ni, n ili i na baci de dem wa kufuɗa we neke. U shatangu akucina a na u yaꞋin dem tsu na wila̱ u vuza na e pecei ka̱ci ka̱ ni u danai.>> ");
INSERT INTO asg_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","<<Dana Haruna m muku n ali n ni, tsu nampa tsu ɗa va kuzuwaka aza a Isaraila una̱singai. Dana le, ");
INSERT INTO asg_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","<<Vuzavaguɗu u zuwaka ɗa̱ una̱singai ka̱ta̱ kpamu wi inda ɗa̱, ");
INSERT INTO asg_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","a̱yi Vuzavaguɗu u zuwa a̱shi a̱ ni akana ɗa̱, ka̱ta̱ u pana asuvayali a̱ ɗa̱ kpamu, ");
INSERT INTO asg_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","a̱yi Vuzavaguɗu u la̱na̱ ɗa̱, ka̱ta̱ u neke ɗa̱ ma̱ta̱na̱. ");
INSERT INTO asg_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","<<Ta a kuzuwa a pana kula ku va̱ wa aza a Isaraila nannai, ka̱ta̱ ta na n zuwaka le una̱singai.>> ");
INSERT INTO asg_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ana Musa u kotsoi kushikpa̱ ka̱pa̱m, ɗa we erengi kaꞋa ɗa u ciɗatangi kaꞋa n i na yi punu dem. Ɗa kpamu we erengi katalikalyuka ɗa u ciɗatangi kaꞋa n ucanuku u ni dem. ");
INSERT INTO asg_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ɗa aza a gbagbaꞋin a Isaraila, umaci u kpaꞋa dem aza a na i aza e kelime a kpaꞋa, uma a na a̱ ɓa̱nka̱i a̱ ubuta̱ u mekecu, a̱ ta̱wa̱i a̱ ka̱pa̱m ka̱ Ka̱shile, ");
INSERT INTO asg_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ɗa a̱ tuka̱i kuneꞋe ku le a̱ ubuta̱ u Vuzavaguɗu. Ili i nampa i ɗa e nekei: ekeke a anaka a̱ ta̱li n obomburon kupanere, aza kelime e re a̱ tuka̱i n keke vu te, kobomburon dem adama a vuza kelime vi te. A̱ tuka̱i le lo a̱ ka̱pa̱m ka. ");
INSERT INTO asg_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","<<Isa ili nampa ya we le, i ɗa a kuyaꞋanka ulinga a̱ ubuta̱ u Ma̱va̱li mo Oɓolo ma. Neke aza e Levi tsu na yaba dem ulinga u ni wi.>> ");
INSERT INTO asg_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ɗa Musa u ɗikai ekeke a anaka a n obomburon a, ɗa u nekei aza e Levi. ");
INSERT INTO asg_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ɗa u nekei ekeke a anaka e re n obomburom a̱ na̱shi a kubana u muku n ali n Geshon, tsu na ulinga u le wi. ");
INSERT INTO asg_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ɗa feu u nekei ekeke a anaka a̱ na̱shi n obomburon kunla̱i a kubana muku ali m Merari, tsu na ulinga u le u wi. Dem vi le i ta̱ o kutono Itama, kolobo ka Haruna, ganu. ");
INSERT INTO asg_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ama Musa u neke ili a kubana u muku n ali n Kohatu ba, adama a na i ta̱ a kuɗika a̱miki a ukuna wi ili i ciɗa i na a tsu canuku a avangatsu e le. ");
INSERT INTO asg_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ana e erengi katalikalyuka ka m maniꞋin me kerengu, ɗa aza e kelime a a̱ tuka̱i n kuneꞋe ku le adama a na ele feu e neke, ɗa e nekei ku ɗa e kelime ka katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Adama a na Vuzavaguɗu u dana ta̱ Musa, <<Kanna lakam vuza kelime vu kumaci ku te ki ta̱ a̱ kutuka̱ n kuneꞋe adama kerengu ku katalikalyuka.>> ");
INSERT INTO asg_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Vuza na u nekei kuneꞋe ku ni a kanna ka iyain a̱yi ɗa Nashon kolobo ka Aminadabu a̱ ka̱tsuma̱ ka kumaci ka Yahuda. ");
INSERT INTO asg_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","KuneꞋe ku ni ku ɗaɗa: kebelyu ka azurufa ke te, ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n azurufa e kebelyu ke te kpamu ka kuvishangu ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa. Ra̱ka̱ tsu na ka̱kunzukpa̱tsu ke shekelu va̱ a̱Ꞌisa̱ ki, dem vi le ushatangi n kiya ku singai usatari m maniꞋin tsu kuneꞋe ki ishina, ");
INSERT INTO asg_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","azanariya kpamu kebelyu ke te, ka yawa ta̱ kagisamkpatsu ka̱ a̱miki kupa ushatangi n ili i ma̱gula̱ni. ");
INSERT INTO asg_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Ɗa kpamu u tuka̱i n kobomburon ke kenu ke te, n ka̱giri, m ma̱giri kpamu vuza na u yawai ka̱ya̱ ke te adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","n obomburon e re, a̱giri a tawun, nga̱ji n tawun, ni ngiri n tawun feu, aza a̱ ka̱ya̱ ke te ke te a lyuka le tsu alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Nashon kolobo ka Aminadabu. ");
INSERT INTO asg_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","A kanna ke ire Nataniya kolobo ka Zuwaru, vuza kelime a̱ ka̱tsuma̱ ku umaci u Isaka, ɗa u tuka̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","KuneꞋe ku na u tuka̱i ku ɗaɗa: azurufa kebelyu ku te a na a yawai kagisamkpatsu ka̱ a̱miki ke shekelu amangatawun n kamangankupa (130), n azurufa kasasu kpamu tukpa ka na kagisamkpatsu ka̱ ni ka yawai a̱miki amangatatsunkupa. Dem vi le derere n kagisamkpatsu ka̱ a̱Ꞌisa̱, kagisamkpatsu dem ushatangi n kiya ku singai ku na a satarai m maniꞋin tsu kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Kebelyu ke te ka azanariya ka na a̱miki a̱ ni a yawai shekelu kupa, ki feu tukpa n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","m mobomburon me te, ka̱giri ke te m ma̱giri ma na ma yawai ka̱ya̱ ke te adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","n obomburon e re, a̱giri a tawun, nga̱ji n tawun, ni ngiri kpamu n tawun n na n yawai ka̱ya̱ ke te, e neke kuneꞋe tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Nataniya kolobo ka Zuwaru. ");
INSERT INTO asg_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","A kanna ka tatsu, Eliyabu kolobo ka Helon, vuza kelime vu kumaci ku Zabalun, u tuka̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","KuneꞋe ku ni ku ɗaɗa: kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130) n kebelyu ke te ushatangi n azurufa a kuvishangu a̱miki e le a yawai shekelu amangatatsunkupa, ra̱ka̱ tsu na ka̱kunzukpa̱tsu ka̱ a̱Ꞌisa̱ ki, ra̱ka̱ vi le a shatangi n kiya ku singai tsu kuneꞋe ki ili i kashina, ");
INSERT INTO asg_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","kebelyu ka azanariya ke te ka yawa ta̱ kagisamkpatsu ka̱ a̱miki e shekelu kupa, ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","mobomburon, n ka̱giri, m ma̱giri me te ma na ma yawai ka̱ya̱ ke te, dem adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","n obomburon e re, n a̱giri n tawun, nga̱ji n tawun feu ni ngiri n tawun n na n yawai ka̱ya̱ ke te, e neke alyuka tsu kuneꞋe ku ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Eliyabu kolobo ke Helon. ");
INSERT INTO asg_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","A kanna ka̱ na̱shi Elizu kolobo ka Shedeyu, vuza kelime vu kpaꞋa vu Ruben u tuka̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","KuneꞋe ku ni ki ta̱ kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ke te ka azanariya ki ili i kuvishangu ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa. Derere n kagisamkpatsu ka̱ a̱Ꞌisa̱, ra̱ka̱ ushani n kiya ku singai usatari m maniꞋin tsu kuneꞋe ki ishina, ");
INSERT INTO asg_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","n azanariya kebelyu ke te ka na a̱miki a̱ ni yawai shekelu kupa, n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","n kobomburon ke te, n ka̱giri ke te m ma̱giri me te feu ma na ma yawai ka̱ya̱ ke te adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","m ma̱ga̱ji me te adama e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Obomburon e re n a̱giri a tawun, nga̱ji kpamu n tawun ni ngiri kpamu n tawun n na n yawai ka̱ya̱ ke te, adama a alyuka e kuneꞋe ku ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Elizu kolobo ke Shedeyu. ");
INSERT INTO asg_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","A kanna ka tawun, Shelumiye maku ma Zurishada, vuza kelime vu uma a Simiyon u ta̱wa̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","KuneꞋe ku ni ku ɗaɗa: azurufa kebelyu ke te ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu amangatatsukupa, derere n kagisamkpatsu ka̱ a̱Ꞌisa̱, dem vi le ushani n kiya ku singai usatari m maniꞋin adama e kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","U tuka̱i feu n kebelyu ka azanariya ke te ka na a̱miki a̱ ni a yawai shekelu kupa, ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","n kobomburon ke te, n ka̱giri ke te, m ma̱giri me te ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","n obomburon e re n a̱giri a tawun koɓolo kpamu nu nga̱ji n tawun feu, ni ngiri n tawun kpamu, n na n yawai ka̱ya̱ ke te, tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Shelumiye kolobo a Zurishada. ");
INSERT INTO asg_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","A kanna ka̱ ta̱li, Eliyasafa kolobo ka Dewuyelu vuza kelime vu kumaci ku Gadu, u tuka̱ n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","KuneꞋe ku ni ku ɗaɗa: kebelyu ke te ka azanariya ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ke te ka azanariya ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa, derere n tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki. Dem vi le ushatangi n kiya ku singai ku na ki usatari m maniꞋin adama e kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu kupa, ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","mobomburon me te n ka̱giri ke te, m ma̱giri me te feu ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","n obomburon e re n a̱giri a tawun, nga̱ji n tawun ni ngiri n tawun feu aza a na a yawai ka̱ya̱ ke te, tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Eliyasafa kolobo ka Dewuyelu. ");
INSERT INTO asg_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","A kanna ke cindere Elishama kolobo ka Amihudu vuza kelime vu kumaci ku Ifirayimu, u tuka̱i n kuneꞋe ku ni, ");
INSERT INTO asg_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","kuneꞋe ku ni ku ɗaɗa: kebelyu ke te ka azurufa ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ka azurufa ke te ki ili i kuvishangu ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa, derere n tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki, dem vi le ushatangi n kiya ku singai usatari m maniꞋin adama e kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","N Kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu kupa, ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","m mobomburon me te, n ka̱giri ke te m ma̱giri me te ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu. ");
INSERT INTO asg_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","n obomburon e re n a̱giri a̱ tawun, nga̱ji n tawun koɓolo ni ngiri n tawun feu ele na a yawai ka̱ya̱ ke te, tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Elishama kolobo ka Amihudu. ");
INSERT INTO asg_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","A kanna ka̱ kunla̱i, Gamaliya kolobo ka Pedazuru, vuza kelime vu kumaci ku Manasa, u tuka̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","KuneꞋe ku ni ku ɗaɗa: kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ke te ka azurufa ka na a̱miki a̱ ni feu a yawai shekelu amangatatsunkupa, derere tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki ushatangi n kiya ku singai usatari m maniꞋin adama e kuneꞋe ki ishina, ");
INSERT INTO asg_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","n azurufa kebelyu ke te ka na a̱miki a̱ ni a yawai shekelu kupa, ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","m mobomburon me te, n ka̱giri ke te koɓolo m ma̱giri me te, ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","n obomburon e re, n a̱giri a tawun, nga̱ji n tawun feu koɓolo ni ngiri n tawun n na n yawai ka̱ya̱ ke te, tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Gamaliya kolobo ka Pedazuru. ");
INSERT INTO asg_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","A kanna ka̱ kuci Abidan kolobo ko Gidiyon, vuza kelime vu kumaci ku Bayami, ");
INSERT INTO asg_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","kuneꞋe ku ni ku ɗaɗa: kebelyu ke te ka azurufa ka na a̱miki a̱ ni a yawai kagisamkpatsu ke shekelu amangatawun n kamangankupa, (130), n kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa, derere n tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki. Dem vi le ushatangi n kiya ku singai ku na ki usatari m maniꞋin adama e kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu kupa, ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","m mobomburon me te, n ka̱giri ke te, m ma̱giri me te feu ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","m ma̱ga̱ji me te adama e kuneꞋe ku unushi ");
INSERT INTO asg_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","n obomburon e re n a̱giri a tawun, nu nga̱ji n tawun koɓolo ni ngiri n tawun feu n na n yawai ka̱ya̱ ke te tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Abidan kolobo ka Gidiyon. ");
INSERT INTO asg_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","A kanna ka kupa ɗa Ahiyeza kolobo ka Amishada, vuza kelime vu kumaci ku Dan, u tuka̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","KuneꞋe ku ni ku ɗaɗa: kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ke te ka azurufa ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa, derere n kagisamkpatsu ka̱ a̱Ꞌisa̱, ");
INSERT INTO asg_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","n kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu kupa ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","m mobomburon me te, n ka̱giri ke te m ma̱giri me te kpamu, ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","n obomburon e re, n a̱giri a tawun, nu nga̱ji n tawun feu, koɓolo ni ngiri n tawun, n na n yawai ka̱ya̱ ke te tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Ahiyeza kolobo ka Amishada. ");
INSERT INTO asg_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","A kanna ka kupa n ke te, Pagiyelu kolobo ko Okiran, vuza kelime vu kumaci wa aza a Ashera u tuka̱i n kuneꞋe ku ni, ");
INSERT INTO asg_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","kuneꞋe ku ni ku ɗaɗa: kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu amangatatsunkupa, derere n tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki, dem vi le ushatangi n kiya ku singai usatari m maniꞋin adama e kuneꞋe ki ishina. ");
INSERT INTO asg_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Kebelyu ka azurufa ka na a̱miki a̱ ni a yawai shekelu kupa ushatangi n ili i ma̱gula̱ni, ");
INSERT INTO asg_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","m mobomburon me te, n ka̱giri ke te feu, m ma̱giri me te ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","n obomburon e re, n a̱giri a tawun, nu nga̱ji n tawun feu, koɓolo ni ngiri n tawun, n na n yawai ka̱ya̱ ke te tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Pagiyelu kolobo ka Okiran. ");
INSERT INTO asg_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","A kanna ka kupa n e re, ɗa Ahira kolobo ka Enanu vuza kelime vu kumaci wa aza a Nafutali u tuka̱i n kuneꞋe ku ni. ");
INSERT INTO asg_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","KuneꞋe ku ni ku ɗaɗa: kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu amangatawun n kamangankupa (130), n kebelyu ke te ka azurufa a na a̱miki a̱ ni feu a yawai shekelu amangatatsunkupa, derere tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki, dem vi le ushatangi n kiya ku singai ku na ki usatari m maniꞋin adama e kuneꞋe ki ishina, ");
INSERT INTO asg_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","n kebelyu ka azurufa ke te ka na a̱miki a̱ ni a yawai shekelu kupa, ");
INSERT INTO asg_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","m mobomburon me te, n ka̱giri ke te feu, m ma̱giri me te ma na ma yawai ka̱ya̱ ke te, adama e kuneꞋe ku kusongu, ");
INSERT INTO asg_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","m ma̱ga̱ji me te adama e kuneꞋe ku unushi, ");
INSERT INTO asg_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","n obomburon e re, n a̱giri a tawun, nu nga̱ji n tawun feu, koɓolo ni ngiri n tawun kpamu n na n yawai ka̱ya̱ ke te tsa alyuka a̱ ma̱ta̱na̱. Na va ɗaɗa kuneꞋe ku Ahira kolobo ka Enanu. ");
INSERT INTO asg_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Na ɗa kuneꞋe ka aza e kelime a Isaraila adama e kerengu ku katalikalyuka, a kanna ka na a̱ tsungi kaꞋa maniꞋin: ebelyu kupa n e re a azurufa, n ebelyu kupa n e re a azurufa a ili i kuvishangu, koɓolo n ebelyu kupa n e re kpamu a azanariya. ");
INSERT INTO asg_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Kebelyu dem ka azurufa a̱miki a̱ ni a yawa ta̱ shekelu amangatawun n kamangankupa (130), kebelyu dem ka azurufa a̱miki a̱ ni a yawa ta̱ shekelu amangatatsunkupa. Azanariya a ulinga a dem a̱miki e le a yawa ta̱ shekelu a̱kpa̱n e re n amangatawa̱na̱shi (2, 400), derere n tsu na kagisamkpatsu ka̱ a̱Ꞌisa̱ ki. ");
INSERT INTO asg_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ebelyu kupa n e re a azanariya a na i n a̱miki e shekelu kupa e kebelyu dem, ushatangi n ili i ma̱gula̱ni ya tsu kagisamkpatsu ka̱ a̱Ꞌisa̱, azanariya a dem a̱miki e shekelu e le a yawa ta̱ amangatawun n kamanga (120). ");
INSERT INTO asg_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","M bomburon a na a yaꞋankai kuneꞋe ku kusongu ka dem a ɗaɗa kupa n e re, n a̱giri kupa n e re feu, ni ngiri kupa n i re kpamu, aza a na a yawai ka̱ya̱ ke te, koɓolo n kuneꞋe ki ishina ku le, nu nga̱ji kupa n u re adama e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Obomburon a alyuka e kuneꞋe ku ma̱ta̱na̱ ra̱ka̱ a ɗaɗa kamanga n a̱ na̱shi, a̱giri amangatatsu, nga̱ji amangatatsu, ngiri n ka̱ya̱ ke te ke te amangatatsu feu. Na ɗa kuneꞋe ku kerengu ku katalikalyuka. ");
INSERT INTO asg_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ana Musa u uwai a̱ Ma̱va̱li mo Oɓolo adama a na u yaꞋan kadanshi n Vuzavaguɗu, ɗa u panai ka̱la̱ka̱tsu a kadanshi n a̱yi e mere mi icorobi i re ya, i na yi a gaɗi vu ka̱kuya̱mkpa̱tsu ka akpati vu Uzuwakpani va. Ɗa Vuzavaguɗu u yaꞋin kadanshi n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","<<YaꞋan kadanshi n Haruna vu dana yi, makyan ma na baci vi a kuzuwa nkuni n cindere, nkuni ma mi ta̱ e kuneke kutashi a uɓon u kashamkpatsu ka̱ ma̱kuni ka dem.>> ");
INSERT INTO asg_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ɗa Haruna u yaꞋin tsu na o tonokoi ni, u zuwai nkuni adama a na a inda kelime ka kashamkpatsu ka, tsu na Vuzavaguɗu u tonokoi Musa. ");
INSERT INTO asg_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Tsu nampa tsu ɗa a yimai kashamkpatsu ka̱ ma̱kuni ka, a yima ta̱ kaꞋa n azanariya, ili i na i ɗikai ɗaka ali a kubana a uɓon u gaɗi, derere tsu na Vuzavaguɗu u tonokoi Musa u yaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","<<Uta̱ka̱ aza e Levi a̱ ka̱tsuma̱ ka aza a Isaraila ka̱ta̱ vu takpaka le nshinda̱. ");
INSERT INTO asg_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Tsu na va kuyaꞋanka le u ɗa na, vu vishanku le mini ma kutakpaka nshinda̱, ka̱ta̱ vu zuwa le a puna cileme ci ikyamba i le gbende, a̱ za̱Ꞌa̱ akashi e le ka̱ta̱ kpamu a̱ sumba̱. ");
INSERT INTO asg_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Yeve vu zuwa le a ɗika mobomburon, n kuneꞋe ki ishina, usatari m maniꞋin, ka̱ta̱ avu vi ɗika mobomburon mo yoku adama e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ka̱ta̱ vu tuka̱ n aza e Levi a e kelime ka̱ Ma̱va̱li mo Oɓolo, ka̱ta̱ vu ɓolongu aza a Isaraila ra̱ka̱ a̱ ubuta̱ u te. ");
INSERT INTO asg_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ayin a na baci vu tuka̱i n aza e Levi a̱ ubuta̱ u Vuzavaguɗu, ka̱ta̱ uma a Isaraila a zuwaka aza e Levi a ekiye e le a aci, ");
INSERT INTO asg_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ka̱ta̱ Haruna u neke aza e Levi a a̱ ubuta̱ u Vuzavaguɗu tsu kuneꞋe ku kuɗa̱ngusa̱ ku na kuta̱i wa aza a Isaraila, adama a na a yaꞋan ulinga u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Aza e Levi tamkpamu a kiyangu ekiye e le a gaɗi va aci o mbomburon a, ka̱ta̱ vi lyuka ka na ki adama e kuneꞋe ku unushi, ka na ka buwai tamkpamu adama e kuneꞋe ku kusongu u Vuzavaguɗu, adama kutakpaka aza e Levi unushi u le. ");
INSERT INTO asg_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Vu zuwa aza e Levi a a shamgba e kelime ka Haruna m muku n ni, ka̱ta̱ vu neke le u Vuzavaguɗu tsu kuneꞋe ku kuɗa̱ngusa̱. ");
INSERT INTO asg_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","N tsu nampa tsu ɗa, ve kupece aza e Levi kau n uma a Isaraila, ka̱ta̱ ta na o okpo uma a̱ va̱. ");
INSERT INTO asg_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","<<A ayin a na baci vu kotsoi kutakpaka aza e Levi nshinda̱ ɗa vu nekei le u Vuzavaguɗu tsu kuneꞋe ku kuɗa̱ngusa̱, ka̱ta̱ aza e Levi a uwa punu a̱ Ma̱va̱li mo Oɓolo ma a yaꞋan punu ulinga. ");
INSERT INTO asg_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","A̱ ka̱tsuma̱ ka uma a Isaraila ra̱ka̱, anan Levi a ɗa a zagbai adama a na okpo uma a̱ va̱ koci. N ka̱na̱ le ta̱ n ka̱ci ka̱ va̱ a̱ una̱ u muku n iyain mi Isaraila, aza e Levi okpo ta̱ una̱ u le. ");
INSERT INTO asg_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Muku n ali n iyain ma aza a Isaraila ra̱ka̱, n va̱ n ɗa, vuma m manama dem. A kanna ka na mu unai muku n iyain a iɗika i Masar, ɗaɗa n kanzakai ka̱ci ka̱ va̱ n ɗa. ");
INSERT INTO asg_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ɗa n ɗikai aza e Levi o okpoi una̱ u muku n iyain ma aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ele aza e Levi tamkpamu, n neke le ta̱ u Haruna m muku n ni tsu kuneꞋe ku na kuta̱i wa aza a Isaraila, adama a na a yaꞋanka uma a Isaraila ulinga punu a̱ Ma̱va̱li mo Oɓolo, a takpaka le unushi. Nannai babu kpamu ma̱dukpa̱ ma na ma̱ kuta̱wa̱ wa aza a Isaraila, a ayin a na baci a yawai ɗevu n ubuta̱ wa̱ a̱Ꞌisa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ɗa Musa, n Haruna koɓolo n uma a Isaraila ra̱ka̱, a yaꞋin n aza e Levi tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Aza e Levi a a takpakai ka̱ci ke le nshinda̱, ɗa kpamu a̱ za̱Ꞌi akashi e le. Ɗa Haruna u nekei le tsu kuneꞋe ku kuɗa̱ngusa̱ u Vuzavaguɗu, ɗa u takpakai le unushi ciya̱ o okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ana nannai u kotsoi ɗa aza e Levi a a̱ ta̱wa̱i kuyaꞋan ulinga u le punu a̱ Ma̱va̱li mo Oɓolo n utsura u Haruna m muku n ni. O tonoi n anan Levi a tsu na Vuzavaguɗu u tonokoi Musa. ");
INSERT INTO asg_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","<<Ili i nampa yi ta̱ a̱ kuyikpa̱ wa aza e Levi feu, vali vu na vi yawai a̱ya̱ kamanga n tawun a kubana gaɗi, u yawa ta̱ u ta̱wa̱ u yaꞋan ulinga punu a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ama vuza na u yawai a̱ya̱ amangerenkupa, wu uvuka n ulinga u na u kuyaꞋan punu a̱ Ma̱va̱li ma, u doku u saꞋwa ili ba. ");
INSERT INTO asg_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","I ta̱ a kufuɗa kuɓa̱nka̱ aza e le adama a na a fuɗa a yaꞋan ulinga punu a̱ Ma̱va̱li mo Oɓolo ma, ama ele a̱ ka̱ci ke le ka̱ta̱ a saꞋwa ili punu ba. Tsu nampa tsu ɗa uteku u na ve kupeceke aza e Levi ulinga u le.>> ");
INSERT INTO asg_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Vuzavaguɗu u yaꞋin kadanshi m Musa a kakamba ka Sinai, o wotoi u iyain a̱ ka̱ya̱ ke ire, ana a̱ uta̱i a iɗika i Masar, u danai, ");
INSERT INTO asg_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","<<Zuwa aza a Isaraila a yaꞋan Ka̱ɗiva̱ ka Kupasamgbanai ka nampa, a ayin a na o yotsoi. ");
INSERT INTO asg_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","A kanna ka kupa n ka̱ na̱shi ko wotoi u nampa, n kulivi, a yaꞋan ka̱ɗiva̱ ka kupasamgbanai tsu na wila̱ u danai.>> ");
INSERT INTO asg_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ɗa Musa u danai aza a Isaraila a yaꞋan Ka̱ɗiva̱ ka Kupasamgbanai. ");
INSERT INTO asg_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ɗa ta na a yaꞋin Ka̱ɗiva̱ ka Kupasamgbanai ka a kanna ka kupa n ka̱ na̱shi ko wotoi ka n kulivi, a kakamba ka Sinai. Aza a Isaraila a yaꞋin derere tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ama aza o yoku e le a kuyaꞋan Ka̱ɗiva̱ ka Kupasamgbanai ka a kanna ka nanlo ka ba, adama a na ka̱ta̱ a ciɗatangu ka̱ci ke le ba, ana wo okpoi a saꞋwa ta̱ keven ki ikyamba ka vuma. Ɗaɗa a̱ ta̱wa̱i u Musa n Haruna a kanna ka nanlo ka, ");
INSERT INTO asg_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ɗa a danai Musa va, <<Tsu saꞋwa ta̱ keven ki ikyamba ɗa tsu ukai ka̱ci ka̱ tsu nshinda̱. Ama yiɗa̱i i kusa̱nka̱ tsu kuneke kuneꞋe ku tsu u Vuzavaguɗu a kanna ka nanlo feu, koɓolo n aza a Isaraila a na a buwai?>> ");
INSERT INTO asg_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ɗaɗa Musa wu ushuki le, <<YaꞋin biꞋi n yeve i na Vuzavaguɗu u kudana adama a̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, ");
INSERT INTO asg_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","<<YaꞋan kadanshi n aza a Isaraila vu dana le, ɗa baci vuza yoku a̱ ka̱tsuma̱ ka̱ ɗa̱, ko a̱ ka̱tsuma̱ ka ntsukaya n ɗa̱ u saꞋwai keven ki ikyamba ko u banai nwalu n daꞋin, wi ta̱ a kufuɗa kuyaꞋan ka̱ɗiva̱ ka kupasamgbanai ka. ");
INSERT INTO asg_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","A yaꞋan ka̱ɗiva̱ ka a kanna ka kupa n ka̱ na̱shi o wotoi u ire n kulivi. A takuma ma̱giri koɓolo m boroji vu na vi n yisiti ba, n a̱vuku o okono kpamu. ");
INSERT INTO asg_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ka̱ta̱ a̱ ka̱sukpa̱ ili i nanlo ya asa ali a kubana usana u yoku ba, ko kpamu o ɓoso etele a̱ ni ba. I baci a kuyaꞋan Ka̱ɗiva̱ ka Kupasamgbanai ka, u gaꞋan ta̱ o tono wila̱ u ni ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ama ɗa baci vuza yoku vu na vi ciɗa, u yaꞋan kpamu nwalu ba ɗa u kpa̱ɗa̱i kuyaꞋan Ka̱ɗiva̱ ka Kupasamgbanai ka. Mayun ɗa e pece vuma vu nanlo n uma a̱ ni, adama a na u tuka̱ n kuneꞋe ku Vuzavaguɗu a ayin a na o yotsoi ba, mayun ɗa unushi u ni wo okpo a kaci ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Komoci ki baci ida̱shi n a̱ɗa̱ ɗa u cigai kuyaꞋan Ka̱ɗiva̱ ka Kupasamgbanai ka Vuzavaguɗu ka, mayun ɗa u tono wila̱ u kuyaꞋan. Mayun ɗa wila̱ u vuza likuci n komoci feu wo okpo u te.>> ");
INSERT INTO asg_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","A kanna ka na a̱ shikpa̱i Ma̱va̱li ma̱ Ka̱shile ka, ɗa keleshu ka palai kaꞋa. N kulivi ali a kubana usana, ka̱ta̱ keleshu ka ko bono tsa akina. ");
INSERT INTO asg_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ta ka lyaꞋi kelime n kuyaꞋan nannai ayin tutu, ka pala kaꞋa n kanna, ka̱ta̱ n kayin kokpo tsa akina. ");
INSERT INTO asg_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","A ayin a na baci keleshu ka ka̱ ka̱sukpa̱i uɓon u Ka̱pa̱m wa, ka̱ta̱ aza a Isaraila o foɓuso kulaza, a̱ ubuta̱ u na baci ka shamgbai, ka̱ta̱ ele feu a̱ da̱sa̱ngu lo. ");
INSERT INTO asg_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nannai ɗa a̱ tsu ɗa̱nga̱ ka̱ta̱ a bana a̱ da̱sa̱ngu a̱ ubuta̱ u yoku tsu na Vuzavaguɗu u tsu zuwa le. Keleshu ka ka laza baci ka̱ ka̱sukpa̱ Ka̱pa̱m ka ba, ta lo ele feu o kuyongo a̱ ubuta̱ u na a̱ da̱sa̱ngi va. ");
INSERT INTO asg_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Keleshu ka shamgba baci a gaɗi vu Ka̱pa̱m va ali ka yaꞋin ayin e re, aza a Isaraila i ta̱ o kuyongo lo ka̱ta̱ a yaꞋan i na i gaꞋin a yaꞋan a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","A makyan mo yoku keleshu ka ke ci geshe a gaɗi vu Ka̱pa̱m ba, ele feu i ta̱ a kushamgba lo a̱ ubuta̱ wa tsu na Vuzavaguɗu u zuwai a yaꞋan. Ka̱ta̱ a̱ ta̱wa̱ a laza kpamu tsu na u danai le. ");
INSERT INTO asg_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","A makyan mo yoku kpamu keleshu ka ci shamgba ta̱ a̱ ubuta̱ u te n kulivi ali a kubana usana, ayin a na baci ka lazai n usana, ka̱ta̱ aza a Isaraila feu a laza. Ko n kayin ko n kanna, keleshu ka̱ ɗa̱nga̱ baci de dem, ele aza a Isaraila feu a̱ tsu ɗa̱nga̱ ta̱. ");
INSERT INTO asg_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ko keleshu ka ka shamgba baci a gaɗi vu Ka̱pa̱m va ali ayin e re ko wotoi, ko ka̱ya̱, ele aza a Isaraila feu i ta̱ o kuyongo a̱ ubuta̱ u na a̱ da̱sa̱ngi va babu kubana ubuta̱ u yoku. Ama ayin a na baci ka lazai, ele feu i ta̱ o kutono kaꞋa. ");
INSERT INTO asg_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Tsu na Vuzavaguɗu u danai, ta a kulaza nannai, tsu na kpamu u danai a shamgba, ta a kushamgba nannai. O tonoi wila̱ u Vuzavaguɗu n kadanshi ka̱ ni nannai, tsu na a panai kaꞋa a̱ una̱ u Musa. ");
INSERT INTO asg_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, ");
INSERT INTO asg_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","<<YaꞋan ishiyaun i re, i na a yimai n azurufa, vi ta̱ a kuyaꞋan ulinga n ele adama e kuɗeke koɓolo ka uma, n kuzuwa uma a̱ ɗenga̱ a wala. ");
INSERT INTO asg_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ɗa baci a̱ lika̱i le ra̱ka̱, ka̱ta̱ uma ra̱ka̱ o ɓolongu wa̱ nu a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ama ɗa baci a̱ lika̱i vi te, aza a gbagbaꞋin, n aza kelime a Isaraila, i ta̱ o kuɓolongu ka̱ci ke le wa̱ nu. ");
INSERT INTO asg_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ɗa baci ta na a̱ lika̱i kavana vu urotu wu nwalu, ka̱ta̱ ka̱tsura̱ ka kumaci kakau ka na ki a uɓon u kasana ka̱ Ka̱pa̱m ka̱ Ka̱shile ka̱ ka̱na̱ nwalu. ");
INSERT INTO asg_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ɗa baci kpamu a̱ lika̱i vi ire va, ka̱tsura̱ ka kumaci kakau ka na ki a uɓon u ɗaka ka̱ Ka̱pa̱m ka̱ Ka̱shile ka̱ ka̱na̱ nwalu. Ciliki tsu nanlo tsa tsu ɗaɗa urotu u kuɗa̱nga̱. ");
INSERT INTO asg_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ama ɗa baci yi a kuciga kuɓolongu uma, ka̱ta̱ i yaꞋan ciliki tsu kavana tsa kau n tsu na tsu buwai va. ");
INSERT INTO asg_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Muku n ali n Haruna, anan ganu, ele ɗa a̱ kulika̱ ishiyaun ya. Na wi ta̱ o kokpo ɗa̱ wila̱ u ko wanai, ali a kubana wu ntsukaya n ɗa̱ n na n kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","I yawa baci a iɗika i ɗa̱ ɗa i banai kuvon a̱ ubuta̱ wi irala i ɗa̱ i na i a kutakacika ɗa̱, ka̱ta̱ i yaꞋan urotu n ciliki tsu ishiyaun tsa. Nannai ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱ u kuciɓa n a̱ɗa̱, ka̱ta̱ wi isa ɗa̱ e ekiye a irala i ɗa̱. ");
INSERT INTO asg_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","I lika̱ kavana a kanna ka̱ ma̱za̱nga̱ ka̱ ɗa̱ feu, n kanna ka̱ ka̱ɗiva̱ ka na a zuwakai ɗa̱, n ka̱ɗiva̱ ku ugiti u wotoi, yi ta̱ a̱ kulika̱ ishiyaun ya a makyan ma na ya kuyaꞋan kuneꞋe ku kusongu n kuneꞋe ku ma̱ta̱na̱. N nannai ɗa Ka̱shile ka kuciɓa n uzuwakpani u na u yaꞋin n a̱ɗa̱. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","A kanna ka kamanga, ko wotoi u ire, a̱ ka̱ya̱ ke ire ka na a̱ ka̱sukpa̱i Masar, ɗa keleshu ka ka̱ ɗa̱nga̱i a̱ Ka̱pa̱m ka. ");
INSERT INTO asg_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ɗa aza a Isaraila a̱ uta̱i ka̱tsura̱-ka̱tsura̱ e meremune ma Sinai n a yawai a̱ ubuta̱ kakau, ali sai ayin a na keleshu ka ka shamgbai e meremune ma Paran. ");
INSERT INTO asg_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Na lo ɗa ugiti u kuɗa̱nga̱ u le, tsu na Vuzavaguɗu u danai le a̱ una̱ u Musa. ");
INSERT INTO asg_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ka̱tsura̱ ka aza a Yahuda kaꞋa ka̱ gita̱i kulaza, tsu na i udari. Nashon maku ma Aminadabu a̱yi ɗa vuza kelime vi le. ");
INSERT INTO asg_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ɗa ka̱tsura̱ ka kumaci ki Isaka ko tonoi, Nataniya maku ma Zuwaru, a̱yi ɗa vuza kelime vi le. ");
INSERT INTO asg_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliyabu maku ma Helon, a̱yi ɗa tamkpamu vuza kelime vu kumaci ku Zabalun. ");
INSERT INTO asg_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ana a̱ muɗa̱i Ka̱pa̱m ka, ɗa muku n ali n Geshon koɓolo m muku n ali m Merari, a ɗikai Ka̱pa̱m ka ɗa a lazai. ");
INSERT INTO asg_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ɗa ka̱tsura̱ ka kumaci ku Ruben ko tonoi tsu na i udari. Vuza kelime vi le a̱yi ɗa Elizu maku me Shedeyu. ");
INSERT INTO asg_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Koɓolo n ka̱tsura̱ ka kumaci ka Simiyon o kutono, vuza kelime vi le a̱yi ɗa Shelumiye maku ma Zurishada. ");
INSERT INTO asg_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ɗa ka̱tsura̱ ka kumaci ka Gadu ko tonoi, vuza kelime vi le a̱yi ɗa Eliyasafa maku ma Dewuyelu. ");
INSERT INTO asg_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Aza a na o tonoi ele ɗa ka̱tsura̱ ka kumaci ka aza a Kohatu uma e Levi, aza na i ucaniki n ili i ciɗa, a̱ tsu shikpa̱ka̱ le ta̱ Ka̱pa̱m ka ɗe kafu a yawa. ");
INSERT INTO asg_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ɗa ka̱tsura̱ ka Ifirayimu ko tonoi, vuza kelime vi le a̱yi ɗa Elishama maku ma Amihudu. ");
INSERT INTO asg_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","A̱yi Gamaliya maku ma Pedazuru, a̱yi ɗa vuza kelime vu kumaci ka aza a Manasa. ");
INSERT INTO asg_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ka̱tsura̱ ka kumaci ka aza a Bayami ele ɗa o tonoi, ɗa Abidan maku ma Gidiyon mo okpoi vuza kelime vi le. ");
INSERT INTO asg_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Aza a na o kotsosoi kugeɓengu uma a, ele ɗa kumaci ku Dan, tsu na i udari. Ahiyeza maku ma Amishada a̱yi ɗa vuza kelime vi le. ");
INSERT INTO asg_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","A kumaci ka aza a Ashera, Okiran ɗa vuza kelime vi le. ");
INSERT INTO asg_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","A kumaci ka aza a Nafutali, Ahira ɗa vuza kelime vi le feu. ");
INSERT INTO asg_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Na va ɗaɗa tsu na aza a Isaraila a darai ka̱tsura̱-ka̱tsura̱ ele a̱ kuta̱. ");
INSERT INTO asg_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ɗaɗa Musa u danai Hobabu kolobo ka Reyuwe va aza a Midiya, akaya a Musa, <<Tsu ɗa̱nga̱ ta̱ a kubana a̱ ubuta̱ u na Vuzavaguɗu u danai, <Mi ta̱ e kuneke ɗa̱ u ɗa.> Bana n a̱ tsu, ci ta̱ a kuyaꞋanka wu ili i singai, adama a na Vuzavaguɗu u yaꞋanka ta̱ aza a Isaraila uzuwakpani u singai.>> ");
INSERT INTO asg_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ɗa wu ushuki ni, <<Mpa ma kubana ba. Mi ta̱ a kulaza a kubana a iɗika i va̱, a̱ ubuta̱ u uma a̱ va̱.>> ");
INSERT INTO asg_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ɗaɗa Musa u danai, <<N folono wu ta̱ ka̱ta̱ vu ka̱sukpa̱ tsu ba, adama a na vi yeve ta̱ ubuta̱ u na tsa kubana tsa̱ da̱sa̱ngu e meremune ma, vi ta̱ ta na o kokpo vuza na u kuꞋuwaka tsu kelime. ");
INSERT INTO asg_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Vu bana baci n a̱ tsu, ci ta̱ e kupece koɓolo ili i singai i na de dem Vuzavaguɗu u kuneke tsu.>> ");
INSERT INTO asg_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ɗa o foɓusoi a̱ ka̱sukpa̱i kusan ku Vuzavaguɗu, ɗa a yaꞋin nwalu n ayin a tatsu. A lazakai n Akpati vu Uzuwakpani vu Vuzavaguɗu va kelime a̱ ka̱tsuma̱ ka ayin a tatsu a nampa, adama a na vu la̱nsa̱ka̱ le ubuta̱ u na a kuvaku. ");
INSERT INTO asg_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Keleshu ka Vuzavaguɗu ko ci yongo ta̱ gaɗi vi le n kanna, a ayin a na baci a̱ ka̱sukpa̱i ka̱tsura̱ ke le. ");
INSERT INTO asg_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","A ayin a na baci de dem akpati vu uzuwakpani vu ɗa̱nga̱i kulaza, ka̱ta̱ Musa u dana, <<Ɗenga̱ kashani, avu Vuzavaguɗu, ka̱ta̱ vu zuwa irala i nu i wacuwa, ka̱ta̱ aza a na a iwain nu a suma a bana daꞋin a̱ ka̱sukpa̱ wu.>> ");
INSERT INTO asg_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ayin a na baci akpati va vu yawai a̱ ubuta̱ u na u kuvuka, ka̱ta̱ u dana, <<Bono, avu Vuzavaguɗu a̱ ubuta̱ u ka̱bunda̱i ka gbayin ka aza a Isaraila.>> ");
INSERT INTO asg_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Kanna ke te ɗa aza a Isaraila a̱ ka̱na̱i mololo adama atakaci e le. Ana Vuzavaguɗu u panai i na i a kudansa, ɗa u yaꞋin wupa. Ɗa u suki n akina ɗa o songi uma a na i a̱ ka̱kina̱ ka̱ a̱pa̱m e le. ");
INSERT INTO asg_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ɗa uma a bankai m ma̱shi me le u Musa, yeve u vasai u Vuzavaguɗu ɗa akina a a̱ kima̱i. ");
INSERT INTO asg_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ɗa e ɗekei ubuta̱ wa n kula Tabera, adama a na akina a Vuzavaguɗu a̱ kula̱ ta̱ a̱ ka̱tsuma̱ ke le. ");
INSERT INTO asg_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ɗa ka̱tsura̱ ka uma a kavama ko yoku ka na ka̱ ɗa̱nga̱i nwalu koɓolo n aza a Isaraila, a̱ ɗa̱nga̱i kazagba ki ili kulyaꞋa. A na a̱ gita̱i mololo ɗa aza Isaraila feu a̱ ɗengusa̱i mololo, a danai, <<Yayi u kuneke tsu inyama tsu takuma? ");
INSERT INTO asg_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ci ciɓa ta̱ n adan a na tsu takumai gbani a Masar gbani koɓolo n kokumba, n guna, n a̱luwa̱shi arambasa koɓolo n arambasagawan. ");
INSERT INTO asg_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ama gogo na a̱ tsu ɗa na a kambulu, utsura u tsu u kotso ta̱, babu ilikulya sai mana koci.>> ");
INSERT INTO asg_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana ili yoku i ɗa i na i yotsoi igeɓetsu wa̱ri n usumbi tsu mini mo tsulo. ");
INSERT INTO asg_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Uma a̱ tsu uta̱ ta̱ ka̱ta̱ o ɓolongu, ka̱ta̱ a iya le a kutali ko o soyo le a̱ ma̱suku. Ka̱ta̱ a̱ ya̱na̱ le o mogbodo ko ta na a yaꞋanka emeshe. Ka̱ta̱ o yokpo an ili i na a kangalai m maniꞋin ma zaitu. ");
INSERT INTO asg_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ayin a na baci de dem ciza tsu matsai lo a̱ ubuta̱ wa̱ a̱pa̱m n kayin, ka̱ta̱ mana feu vu uta̱. ");
INSERT INTO asg_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ɗa Musa u panai uma ra̱ka̱ a̱ ma̱shi, yaba dem a kashani a̱ utsutsu u ka̱pa̱m ka̱ ni. Ɗa Vuzavaguɗu u yaꞋin wupa ka̱u, ɗa Musa u na̱mgba̱i ka̱tsuma̱. ");
INSERT INTO asg_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ɗa Musa u danai Vuzavaguɗu, <<Yiɗa̱i i zuwai ɗa vi a kutakacika kagbashi ka̱ nu? Yiɗa̱i n yaꞋin i na i na̱mgba̱i nu ka̱tsuma̱ ali ɗa vu ka̱sukpa̱i a̱miki a uma a nampa ra̱ka̱ wa̱ va̱? ");
INSERT INTO asg_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mpa ɗa n ɗikai ka̱tsuma̱ ka uma a nampa ra̱ka̱? Mpa ɗa m matsai le? Yiɗa̱i i zuwai ɗa vu danai mu n ɗika le ekiye a̱ va̱, uteku tsu na kowoꞋi ka maku ke ci keɓe mereɓu, a kubanka iɗika i na vu kucinai va kuneke ikaya i le? ");
INSERT INTO asg_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Te ɗai ma̱ kuciya̱ inyama i na me kuneke ka̱bunda̱i ka uma a nampa ra̱ka̱? Ele na a dakakai kushiꞋika̱ mu, a kudana, <Neke tsu inyama, tsu takuma.> ");
INSERT INTO asg_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mpa n kufuɗa kuɗika a̱miki a uma a nampa ra̱ka̱ endeꞋen va̱ ba, a yaꞋan mu ta̱ a̱miki n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tsu nampa tsu ɗa baci vu sheshei kuyaꞋan nu mpa, una mu gogo na, ɗa baci n ciya̱i mapasa ma singai wa̱ nu, jebeke mu atakaci a nampa.>> ");
INSERT INTO asg_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ɗa Vuzavuguɗu u danai Musa, <<Ɓolonku mu nkoshi m gba̱ra̱-gba̱ra̱ amangatatsunkupa ma aza a Isaraila, aza na vu yevei ele ɗa aza e kelime a uma, n aza a gbagbaꞋin kpamu, ka̱ta̱ vu tuka̱ le a̱ Ma̱va̱li mo Oɓolo, a shamgba ɗe koɓolo n avu. ");
INSERT INTO asg_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mpa mi ta̱ a̱ kucipa̱ n yaꞋan kadanshi n avu ɗe, ka̱ta̱ n jaꞋwan utsura wa ayinviki a̱ nu n neke le. I ta̱ a̱ kuɓanka̱ wu kuɗika a̱miki a uma, adama a na ka̱ta̱ vu ɗika a̱miki a endeꞋen nu ba. ");
INSERT INTO asg_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ka̱ta̱ vu dana uma a, ciɗatangi ka̱ci ka̱ ɗa̱, makpaꞋa yi ta̱ a kutakuma inyama, adama a na Vuzavaguɗu u pana ta̱ ma̱shi ma̱ ɗa̱, ma na i danai, <Yayi u kuneke tsu inyama i kutakuma? U laꞋa ta̱ n kugaꞋan tsu bono a Masar.> Vuzavaguɗu wi ta̱ e kuneke ɗa̱ inyama i kutakuma, ka̱ta̱ i takuma. ");
INSERT INTO asg_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Yi a kutakuma i ɗa a kanna kete, ko ayin e re, ko ayin a tawun, ko ayin kupa, ko ayin kamanga ba. ");
INSERT INTO asg_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ama o wotoi ka̱ɓula̱, yi ta̱ a kumaka i ɗa ali i yo okpo ɗa̱ ili yu unata. Adama a na i iwan ta̱ Vuzavaguɗu vu na wi a̱ ka̱tsuma̱ ka̱ ɗa̱ n vuza na i shiꞋika̱i, i danai, <Yiɗa̱i ɗa vu uta̱ka̱i tsu a Masar?> >> ");
INSERT INTO asg_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ɗa Musa u danai, <<Mpa ɗa a̱ ka̱tsuma̱ ka uma a̱kpa̱n amangatawa̱nta̱li (600,000) a nwalu e ene. Vu dana ta̱ kpamu, <Mi ta̱ e kuneke le inyama, i na a kutakuma wotoi ka̱ɓula̱.> ");
INSERT INTO asg_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ko ɗa baci a kiɗai ushiga wa anaka n ushiga wu nlala yi ta̱ a kuyawa le? Ko o ɓolongu baci adan a mala ra̱ka̱ ɗa e nekei le, i ta̱ a kuyawa le?>> ");
INSERT INTO asg_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ɗa Vuzavaguɗu u danai Musa, <<Vu sheshe ta̱ kukiye ku Vuzavaguɗu ki ta̱ gbati? Gogo na ve kene ta̱, ko i na n dansai yi ta̱ a kushana ko ya kushana ba.>> ");
INSERT INTO asg_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa wu uta̱i u danai uma kadanshi ka na Vuzavaguɗu u danai. Ɗa u ɓolongi nkoshi m gba̱ra̱-gba̱ra̱ amangatatsunkupa aza a Isaraila, u zuwai le uka̱ra̱Ꞌi n ka̱pa̱m ka. ");
INSERT INTO asg_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ɗa Vuzavaguɗu u cipa̱i punu e eleshu ɗa u yaꞋin kadanshi n a̱yi, ɗa u nekei le utsura wa ayinviki a na i u Musa ɗa u zuwakai nkoshi m gba̱ra̱-gba̱ra̱ ma. Ana ayinviki a a̱ cipa̱i we le, a yaꞋin kene. Ama a lyaꞋa kelime n kene ba. ");
INSERT INTO asg_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Uma e re a̱ ka̱tsuma̱ ko nkoshi m gba̱ra̱-gba̱ra̱ ma, okpoi a̱ ubuta̱ u ka̱tsura̱ wa, kula ku vuza te ku ɗaɗa Elidadu, vuza ire ɗa Medadu, ɗa ayinviki a̱ cipa̱i we le. I ta̱ a̱ ka̱tsuma̱ ka aza na e kecei, ama a bana a̱ ma̱va̱li ba, ɗa a yaꞋin kene ubuta̱ u na o ɓolongi. ");
INSERT INTO asg_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ɗa kolobo ko yoku ka sumai ka banai ka danai Musa, <<Elidadu m Medadu i ta̱ ɗe a kuyaꞋan kene a̱ ubuta̱ u na i a̱ ka̱tsura̱ ka.>> ");
INSERT INTO asg_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jesuwa maku ma̱ Nun, ka̱ɓa̱nki ka Musa ali a̱yi maku, u danai, <<Vuzagbayin vu va̱ Musa, sa̱nka̱ le.>> ");
INSERT INTO asg_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ama Musa u danai, <<Vi ta̱ e cisheꞋe adama a̱ va̱? N kuciga ku va̱, wi ishi a kugaꞋan a dana uma a̱ Ka̱shile ra̱ka̱ eneki a ɗa. Ufolu u va̱ u ɗa, Vuzavaguɗu u zuwa utsura wa ayinviki a̱ ni u uma dem.>> ");
INSERT INTO asg_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ɗa Musa nu nkoshi m gba̱ra̱-gba̱ra̱ ma aza Isaraila o bonoi a̱ ka̱tsura̱ e le. ");
INSERT INTO asg_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ɗa Vuzavaguɗu u zuwai wunla̱i wu uta̱i a mala ɗa u tuka̱i nu nroni, ɗa a̱ yikpa̱i uka̱ra̱Ꞌi wa̱ a̱pa̱m e le dem. A kakambu ka̱ a̱pa̱m dem i ta̱ a kufuɗa kene le daꞋin ali u yawa tsu na vuza u kuliva̱ a nwalu. Kashani ku imkpi u le kpamu a kubana gaɗi ka laꞋa udashi u tatsu n iɗika ba. ");
INSERT INTO asg_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ɗa ta na uma a̱ ɗa̱nga̱i n kanna ka nanlo n kayin ka̱ ni dem, ɗa kpamu o doki an kayin kasai a̱ ka̱na̱i kureme nroni ma. Aza na o ɓolongi kenu ele ɗa o ɓolongi homa kupa. Ɗa e ecikpei le uka̱ra̱Ꞌi wa̱ a̱pa̱m e le. ");
INSERT INTO asg_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ele biꞋi a kutakuma inyama ya ɗa Vuzavaguɗu u yotsongi wupa u ni we le. Ɗa u suꞋuki le m ma̱dukpa̱ ma gbani-gbani, ma na mu unai uma n a̱bunda̱i. ");
INSERT INTO asg_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Adama a nannai ɗa e neꞋi ubuta̱ wa kula Kiburotu-hatava, ɗaɗa asaun a aza kutsa̱n. ");
INSERT INTO asg_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ɗe a Kiburotu-hatava va, ɗa aza a Isaraila a lazai a kubana a Hazerotu ubuta̱ u na a̱ da̱sa̱ngi. ");
INSERT INTO asg_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ele ɗe ɗa Miriyamu n Haruna a̱ kpa̱ɗa̱i kushuku m Musa adama a na u zuwa ta̱ vuka a kumaci ka aza a Kush. ");
INSERT INTO asg_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ɗa a̱ ka̱na̱i kudana, <<U Musa u ɗa Vuzavaguɗu u ci yaꞋan kadanshi koci? A̱ tsu tamkpamu? U ci yaꞋan kadanshi n a̱ tsu ba?>> Ɗa Vuzavaguɗu ta na u panai i na a dansai. ");
INSERT INTO asg_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","A̱yi Musa ta na u laꞋa ta̱ uma a aduniyan a na a buwai dem a̱ ma̱riki. ");
INSERT INTO asg_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gogo lo ɗa Vuzavaguɗu u danai Musa, n Haruna koɓolo m Miriyamu, <<Uta̱i i ta̱wa̱ tsu gasai na a̱ Ma̱va̱li mo Oɓolo a̱ɗa̱ uma a tatsu a̱ ɗa̱ dem.>> Ɗa ele uma a tatsu e le a̱ uta̱i. ");
INSERT INTO asg_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ɗa Vuzavaguɗu u cipa̱i a kabashi ke keleshu, ɗa u shamgbai a̱ utsutsu u Ma̱va̱li ma, ɗa u ɗekei Haruna koɓolo m Miriyamu. Ana a yawai ɗe a̱ ma̱va̱li ma, ");
INSERT INTO asg_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ɗa u danai, <<Panai kadanshi ka̱ va̱, Ayin a na baci keneki ka Vuzavaguɗu ki koɓolo n a̱ɗa̱, n tsu yotsongu ta̱ ka̱ci ka̱ va̱ wa̱ ni n tsalatani, n ci yaꞋan ta̱ kadanshi n a̱yi n alatani. ");
INSERT INTO asg_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ama ta n ci yaꞋan kadanshi nannai n kagbashi ka̱ va̱ Musa ba, mu ushuku ta̱ n a̱yi a̱ ubuta̱ u uma a̱ va̱ aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","N a̱yi ɗa n yaꞋin kadanshi a̱shi n a̱shi, hawun ba n iteꞋe ba, we ene ta̱ Vuzavaguɗu tsu na wi, yiɗa̱i i zuwai ɗa i kpa̱ɗa̱i kupana wovon u kuyaꞋan kadanshi ka wuya u kagbashi ka̱ va̱ Musa?>> ");
INSERT INTO asg_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ɗa Vuzavaguɗu u yaꞋin wupa n ele ka̱u ɗa u lazai ɗa u ka̱sukpa̱i le. ");
INSERT INTO asg_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ana keleshu ka̱ ka̱sukpa̱i ma̱va̱li ma, ɗa Miriyamu wa̱ a̱ruma̱i n ukutu pushe-pushe. Ana Haruna u kpatalai wi indai ni ɗa we enei ni n ukutu. ");
INSERT INTO asg_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ɗa Haruna va u danai Musa, <<Vuzagbayin, ka̱ta̱ vu takacika tsu adama a̱ unushi u nampa n tsulau tsu na ci yaꞋin ba. ");
INSERT INTO asg_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ka̱ta̱ vu ka̱sukpa̱ yi wo okpo tsu mereɓu ma na ma̱ kuwa̱i a ayin a limata n ikyamba kashami kakambu ke te ba.>> ");
INSERT INTO asg_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ɗa Musa u folonoi Vuzavaguɗu, u danai, <<Ka̱shile, n folono wu ta̱, potsotongu yi.>> ");
INSERT INTO asg_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ama ɗa Vuzavaguɗu wu ushuki Musa, u danai, <<Ishi baci esheku a̱ ni, a jiraka yi ntsa̱n a̱ a̱shi, wi ishi o kokpo n wono ali ayin e cindere ba? Zuwai ni u yongo a pulai vu ka̱tsura̱ ali ayin e cindere, yeve ka̱ta̱ vu bonoko n a̱yi asuvu.>> ");
INSERT INTO asg_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ɗa a̱ uta̱ka̱i Miriyamu a pulai vu ka̱tsura̱ ali ayin e cindere, ama ɗa uma a̱ kpa̱ɗa̱i kulaza ali sai ayin a na o bonokoi n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ana ka nanlo ka ko kotsoi, ɗa uma a̱ ka̱sukpa̱i Hazerotu, ɗa a banai a̱ da̱sa̱ngi a kakamba ka aza a Paran. ");
INSERT INTO asg_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","<<Suku uma a bana a saka iɗika i KanaꞋana, i na mi a kuciga me neke aza a Isaraila a. Suku vuza kelime vi te a̱ ka̱tsuma̱ ka kumaci dem.>> ");
INSERT INTO asg_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ɗa Musa u yaꞋin uteku tsu na Ka̱shile ka danai ni u yaꞋan ɗa u suki uma kupa n ere aza a Isaraila, dem vu le aza e kelime a kumaci a ɗa. Ɗa u suki le a̱ uta̱i ɗe a kakamba ka Paran. ");
INSERT INTO asg_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ula a uma a na a zagbai a ɗa na. A kumaci ka aza a Ruben, Shamuwa kolobo ka Zakuru, ");
INSERT INTO asg_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","a kumaci ka aza a Simiyon, Shafatu kolobo ko Hori, ");
INSERT INTO asg_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","a kumaci ka aza a Yahuda, Kelepu kolobo ka Jefune, ");
INSERT INTO asg_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","a kumaci ka aza a Isaka, Igalu kolobo ka̱ Isufu, ");
INSERT INTO asg_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","a kumaci ka aza a Ifirayimu, Hosiya kolobo ka Nun, ");
INSERT INTO asg_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","a kumaci ka aza a Bayami, Paliti kolobo ka Rafu, ");
INSERT INTO asg_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","a kumaci ka aza a Zabalun, Gadiyelu kolobo ko Sodi, ");
INSERT INTO asg_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","a kumaci ka aza a Manasa, Gadi kolobo ka̱ Susi, ");
INSERT INTO asg_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","a kumaci ka aza a Dan, Amiyelu kolobo ka Gemali, ");
INSERT INTO asg_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","a kumaci ka aza a Ashera, Seturu kolobo ka Makelu, ");
INSERT INTO asg_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","a kumaci ka aza a Nafutali, Nabi kolobo ko Vopusi, ");
INSERT INTO asg_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","a kumaci ka aza Gadu, Geyuwelu kolobo ka Maci ");
INSERT INTO asg_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Na ɗa ula a uma a na Musa u suki a bana a yaꞋan tsusaki ki iɗika ka. Ɗa Musa u neꞋi Hosiya kolobo ka Nun kula, Jesuwa. ");
INSERT INTO asg_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ana Musa u suki le a bana a saka iɗika i KanaꞋana, ɗa u danai le, <<Ɗa baci yi a kubana, ka̱ta̱ i tonoko n Negebu n uɓon wu nsasan u likuci wa. ");
INSERT INTO asg_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ka̱ta̱ i la̱na̱ yene tsu na iɗika ya yi, ko uma a na i punu ida̱shi a̱ likuci ya aza a utsura a ɗa ko babu utsura n a̱bunda̱i ko kenu. ");
INSERT INTO asg_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","IcuꞋu yi iɗika ye ne i ɗai i ida̱shi? I singai ko i gbani-gbani? IcuꞋu i likuci ye ne i ɗai i ida̱shi? Ukanji ko babu ukanji? ");
INSERT INTO asg_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Nini ɗai iɗika ya yi? N tsuta̱ ko babu tsuta̱? Iɗika ya yi ta̱ nu nɗanga ko babu? YaꞋin tsu na i kufuɗa, ka̱ta̱ i taꞋa umaci u mambulu wi iɗika ya i bonoko.>> Ayin a nanlo a ɗaɗa ayin a na umaci wu nɗanga u tsu kugita̱ kugeꞋwe. ");
INSERT INTO asg_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ɗa a banai a sakai iɗika ya, ili i na i gita̱i e meremune ma Zinu ali a kubana a Rehobu a uɓon u Lebo-hamata. ");
INSERT INTO asg_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ɗa o tonoi n Negebu, a yawai Heburon, a̱ ubuta̱ u na Ahiman, n Shishayi, n Talimayi, ntsukaya n Anaku i n ida̱shi. (A maꞋa ta̱ Heburon a̱ya̱ e cindere a na a lazai kafu Zowa a iɗika i Masar.) ");
INSERT INTO asg_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ana a yawai a̱ ka̱ra̱Ꞌa̱ ka Eshikolu, ɗa o koɗoi kacaka ka mambulu ka na ki n a̱miki ali sai a na uma e re a ɗikai kaꞋa n kalangu, koɓolo n umaci wu nɗanga m ruman m ma̱biri. ");
INSERT INTO asg_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ubuta̱ u nanlo e ci ɗeke ta̱ u ɗa Ka̱ra̱Ꞌa̱ ke Eshikolu adama a na ta ɗe aza a Isaraila o koɗoi kacaka ku umaci wi itacishi yi inabi. ");
INSERT INTO asg_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","A ukocishi u ayin amangere ɗa o kotsoi tsusaki, ɗa o bonoi. ");
INSERT INTO asg_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ɗa o bonoi u Musa n Haruna koɓolo n aza a Isaraila ra̱ka̱ a na i e Kadeshi vu kakamba ka Paran. Ɗa o tonokoi le n aza a Isaraila ukuna wi ili ra̱ka̱ u na a̱ ciya̱i a̱ ubuta̱ u tsusaki wa, ɗa kpamu o yotsongi le umaci wu nɗanga wi iɗika wa. ");
INSERT INTO asg_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ɗa a danai Musa ukuna u nampa, <<Tsu bana ta̱ a iɗika i na vu suki tsu va, iɗika ya yi ta̱ m maniꞋin n tsuta̱, umaci wu nɗanga wi iɗika u ɗa na. ");
INSERT INTO asg_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ama uma a na i ɗe a iɗika ya i ta̱ n utsura, likuci ya feu i gbagbaꞋin i ɗa n ukanji mayin. Ali ce ene ta̱ ɗe kumaci ka aza Anaku. ");
INSERT INTO asg_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Aza a Emeleki i ta̱ punu ɗe ida̱shi a iɗika i Negebu, aza a Hitiya, n aza a Jebusiya koɓolo n aza a Amoriya i ta̱ ida̱shi a akambu a nsasan. Aza a KanaꞋana tamkpamu i ta̱ ida̱shi a̱ ka̱kina̱ ka mala, ɗevu n Kuyene ku Urudu.>> ");
INSERT INTO asg_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ɗa Kelepu u danai uma a paɗa bini e kelime ka Musa ɗa u danai, <<Tsu bana ci isa iɗika ya, adama a na ci ta̱ a kufuɗa.>> ");
INSERT INTO asg_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ama aza a na a banai koɓolo n a̱yi va a danai, <<Tsa kufuɗa kurono n uma a nanlo ba, adama a na a laꞋa tsu ta̱ utsura.>> ");
INSERT INTO asg_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ɗa a lyaꞋi kelime n kuka̱ra̱ka̱ aza a Isaraila n kadanshi ka gbani-gbani adama a ukuna wi iɗika i na a banai a sakai va. A danai, <<Iɗika i na tsu banai tsu sakai va, yu una ta̱ aza na ishi punu ida̱shi ɗe. Kpamu uma a na ce enei ɗe aza a gbagbaꞋin a ɗa. ");
INSERT INTO asg_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Kpamu ce ene ta̱ ɗe aza e Nefilim kumaci ka aza Anaku aza na uta̱i Nefilim. Ɗa ce enei ka̱ci ka̱ tsu tso okpoi tsa akyun a̱ a̱shi e le, ta ta na ci nannai we le.>> ");
INSERT INTO asg_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","N kayin ka nanlo ɗa aza a Isaraila ra̱ka̱ a lapasai una̱ ka̱u adama atakaci. ");
INSERT INTO asg_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ɗa a yaꞋankai Musa n Haruna mololo, a danai, <<Wi ishi u laꞋa n kugaꞋan tsu kuwa̱ a Masar, ko kpamu e meremune ma nampa. ");
INSERT INTO asg_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Yiɗa̱i i zuwai ɗa Vuzavaguɗu u tuka̱i tsu iɗika i nampa adama na tsu bana ukpa̱ u kotokobi? I ta̱ a̱ kupura̱ a̱ma̱ci a̱ tsu m muku n tsu gbani. Wishi a kulaꞋa n kugaꞋan tsu bono a Masar ba?>> ");
INSERT INTO asg_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ɗa a dananai, <<Ka̱sukpa̱i tsu zagba vuza kelime ka̱ta̱ tsu bono a Masar.>> ");
INSERT INTO asg_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ɗa Musa n Haruna a̱ kuɗa̱ngi sapu a lyaꞋi kayala e kelime ka̱ ka̱bunda̱i ka aza a Isaraila ka na ko ɓolongi lo va ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ɗa Jesuwa kolobo ka Nun koɓolo n Kelepu kolobo ka Jefune, ele na i a̱ ka̱tsuma̱ ka aza a na a banai tsusaki ki iɗika ka, a karai ntogu n le adama a̱ una̱mgbuka̱tsuma̱, ");
INSERT INTO asg_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ɗa a danai koɓolo ka aza a Isaraila ka na ka buwai, <<Iɗika i na tsu banai tsu sakai va, i ɗa i gaꞋan ta̱ ka̱u. ");
INSERT INTO asg_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Vuzavaguɗu wi baci a kupana uyo u tsu, wi ta̱ a kubanka tsu a iɗika i nanlo ka̱ta̱ u neke tsu i ɗa, iɗika i na yi m maniꞋin n tsuta̱. ");
INSERT INTO asg_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Adama a nannai ka̱ta̱ i yaꞋanka Vuzavaguɗu ugbamukaci ba. Kpamu ka̱ta̱ i pana wovon u uma a iɗika a ba, adama a na ci ta̱ a kulyaꞋa le. Ka̱ɓa̱nki ke le ka buwa lo ba, ama Vuzavaguɗu wi ta̱ koɓolo n a̱ tsu. Ka̱ta̱ i pana wovon u le ba.>> ");
INSERT INTO asg_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ɗa ka̱bunda̱i ka uma ra̱ka̱ a yaꞋin kadanshi adama a na a vara le. Ama ɗa tsugbayin tsu Vuzavaguɗu tsu ta̱wa̱i lo a̱ Ma̱va̱li mo Oɓolo ma e kelime ka aza a Isaraila ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ɗa Vuzavaguɗu u danai Musa, <<Ali wanai ɗai uma a nampa a kulyaꞋa kelime n kugoyo mu? Ali wanai ɗai a̱ kukpa̱ɗa̱ kushuku nu mpa, n ili i mereve i na n yaꞋansakai le a̱ ubuta̱ dem? ");
INSERT INTO asg_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mi ta̱ a kulapa le m ma̱dukpa̱ ka̱ta̱ m pece le n ili yu uka̱ni i le, ama ka̱ta̱ m bonoko wu iɗika ya aduniyan i na i laꞋi le m gbayin n utsura.>> ");
INSERT INTO asg_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ama ɗa Musa u danai Vuzavaguɗu, <<Aza a Masar i ta̱ a kupana ukuna u nampa, adama a na avu ɗa vu uta̱ka̱i le we le n utsura u nu. ");
INSERT INTO asg_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ka̱ta̱ a dana aza a na i punu ida̱shi a iɗika i nampa ukuna wa. Ele na a panai ɗe an avu Vuzavaguɗu vi ta̱ koɓolo n uma a nampa, n tsu na kpamu vu yotsongi ka̱ci ka̱ nu we le a̱shi n a̱shi, n tsu na vu tonoi n ele n keleshu ka̱ nu ka na ka shamgbai gaɗi vi le. E yeve ta̱ vu tono ta̱ n ele n kabashi ke keleshu n kanna, n kayin tamkpamu n kabashi ke keleshu ka akina. ");
INSERT INTO asg_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ɗa baci vu unai uma a nampa ra̱ka̱ a makyan me te, aduniyan a na a panai ukuna u nampa i ta̱ a kudana, ");
INSERT INTO asg_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","<Vuzavaguɗu u fuɗa u banka n uma a iɗika i na u yaꞋankai le uzuwakpani u na u kucinai ba, ɗa wu unai le e meremune.> ");
INSERT INTO asg_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Gogo na yaꞋan Vuzavaguɗu u yotsongu utsura u ni tsu na u yaꞋin uzuwakpani, adama a na u dana ta̱, ");
INSERT INTO asg_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","<Vuzavaguɗu u ci yaꞋan wupa gogo ba, wi ta̱ kpamu tukpa n ucigi u na u tsu kpa̱ɗa̱ kujebe, a̱yi na u tsu cinukpaka vuza vu unushi n vuza vu ka gbani-gbani. N nannai dem u tsu ka̱sukpa̱ vuza vu unushi babu u takacikai ba, u tsu takacika ta̱ muku adama a̱ unushi wi isheku i le ali a kubana a tsukaya tsu tatsu n tsu na̱shi dem.> ");
INSERT INTO asg_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","N utsura wu ucigi u gbayin u nu, cinukpaka uma a nampa unushi u le, tsu na vu cinukpakai le a ayin a na a̱ ka̱sukpa̱i iɗika i Masar ali a̱ kuta̱wa̱ gogo na.>> ");
INSERT INTO asg_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ɗa Vuzavaguɗu u danai, <<N cinukpaka le ta̱ unushi u le, tsu na vu folonoi. ");
INSERT INTO asg_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Dem n nannai, n kucina ta̱ n wuma u va̱, tsu na tsugbayin tsu Vuzavaguɗu ci a kushana aduniyan dem, ");
INSERT INTO asg_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","babu vuza te a ka̱tsuma̱ ka uma ka nampa ka kuꞋuwa iɗika i na n kucinai me kuneke le. Ko an enei tsugbayin tsu va̱, n ili mereve i na n yaꞋin a Masar m meremune, dem n nannai ɗa a̱ ka̱na̱i kukondo mu babu uteku, ");
INSERT INTO asg_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","babu vuza te vi le vu na u kene iɗika i na n kucinai kuneke ikaya i le. Babu vuza te vi le vu na u goyoi mu wa kene i ɗa. ");
INSERT INTO asg_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ama kagbashi ka̱ va̱ Kelepu, adama a na ka̱ɗu ka̱ ni ki kau kpamu, u tonoi mu n ka̱ɗu ke te, a̱yi ɗa n kubanka a iɗika i na u banai va, ka̱ta̱ ntsukaya n ni n ka̱na̱ i ɗa yo okpo yi uka̱ni i le. ");
INSERT INTO asg_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","A na wo okpoi aza a Emeleki n aza a KanaꞋana i ta̱ ɗe ida̱shi a̱ ka̱ra̱Ꞌa̱, mkpa vu kpatala ka̱ta̱ vu tono a kubana e meremune a uye u na u walai m Mala ma Shili.>> ");
INSERT INTO asg_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa koɓolo n Haruna u danai, ");
INSERT INTO asg_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","<<Ali wanai ɗai uma a gbani-gbani a nampa a kulyaꞋa kelime n kuyaꞋan mololo adama a̱ va̱? M pana ta̱ mololo ma aza a Isaraila ma nampa. ");
INSERT INTO asg_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Gogo na dana le, <Vuzavaguɗu u dana ta̱, n kucina ta̱ n wuma u va̱, n kuyaꞋanka ɗa̱ ta̱ ili dem derere tsu na m panai ɗa̱ i dansai. ");
INSERT INTO asg_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ra̱ka̱ vu ɗa̱ yi ta̱ a̱ kukuwa̱ punu e meremune ma nampa, a̱ɗa̱ na e kecei a̱ ubuta̱ u mekecu, a̱ɗa̱ na i yawai a̱ya̱ kamanga a kubana gaɗi, aza a na a yaꞋankai mu mololo. ");
INSERT INTO asg_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Babu vuza na u kuꞋuwa iɗika i na n kucinai kuneke ɗa̱ adama a na yo okpo kpaꞋa ku ɗa̱, sai Kelepu kolobo ka Jefune n Jesuwa kolobo ka̱ Nun koci. ");
INSERT INTO asg_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ama adama a̱ muku n ɗa̱ tamkpamu n na i danai i ta̱ a̱ kupura̱ le gbani, mi ta̱ a̱ kutuka̱ le punu a pana uyo wi iɗika i na i iwain va. ");
INSERT INTO asg_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ama a̱ɗa̱ tamkpamu, even a ikyamba a̱ ɗa̱ i ta̱ o kokpo e meremune ma nampa. ");
INSERT INTO asg_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Muku n ɗa̱ mi ta̱ a̱ kuka̱na̱ ka̱ ka̱ra̱sa̱ e meremune ali a̱ya̱ amangere, ka̱ta̱ a takacika adama a unambi u kuneke wa̱ a̱ɗu u ɗa̱, ali sai ayin a na vuza na u buwai n wuma u kotsoi u kuwa̱i punu e meremune ma nampa. ");
INSERT INTO asg_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Yi ta̱ a kutakacika adama a̱ unushi u ɗa̱ ali a̱ya̱ amangere, ka̱ya̱ ke te a una̱ u kanna ke te dem, ka ayin amangere a na i sakai i ɗika ya. Nannai ɗa i kuɗika a̱miki a̱ unushi u ɗa̱, ka̱ta̱ kpamu i yeve a na ili i kenu i ɗa ba, wupa u va̱ u tsuwa̱n u vuza.> ");
INSERT INTO asg_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mpa Vuzavaguɗu n dansa ta̱, mayun mi ta̱ a kuyaꞋan ili i nampa u uma a gbani-gbani a nampa ra̱ka̱ a na o ɓolongi ka̱ci ke le adama a na a iwain mu. E meremune ma nampa maꞋa o kukotso ra̱ka̱, ta punu a̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Uma a na Musa u suki a bana a saka iɗika ya, aza na o bonoi ɗa a zuwai uma ra̱ka̱ a yaꞋankai Vuzavaguɗu mololo ma, a̱ ubuta̱ u kudansa ukuna wa aꞋuwa adama a iɗika ya, ");
INSERT INTO asg_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ele ɗa aza na Vuzavaguɗu u zuwai ma̱dukpa̱ mu unai le e kelime ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","A̱ ka̱tsuma̱ ka aza a na a banai tsusaki ki iɗika ka, Jesuwa kolobo ka Nun n Kelepu kolobo ka Jefune ele ɗa koci a laꞋi n wuma. ");
INSERT INTO asg_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ana Musa u danai aza a Isaraila ukuna u na Vuzavaguɗu u danai ra̱ka̱, ɗa uma a a̱ na̱mgba̱i ka̱tsuma̱ ka̱u. ");
INSERT INTO asg_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ɗa a̱ ɗa̱nga̱i n usana ka̱li-ka̱li a banai a kusan ku na ku laꞋi n ugaɗi ka̱u a iɗika ya, ɗa a danai, <<Tsu nusa ta̱, ci ta̱ a kubana a̱ ubuta̱ u na Vuzavaguɗu u yaꞋankai tsu uzuwakpani.>> ");
INSERT INTO asg_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ama ɗa Musa u danai, <<Yiɗa̱i i zuwai ɗa yi a̱ kukpa̱ɗa̱ kutono kadanshi ka Vuzavaguɗu? Nannai wa kuyaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ka̱ta̱ i bana ubuta̱ ba, adama a na Vuzavaguɗu wi koɓolo n a̱ɗa̱ ba. Irala i ɗa̱ yi ta̱ a kulyaꞋa kaci ka̱ ɗa̱, ");
INSERT INTO asg_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","adama a na aza a Emeleki n aza a KanaꞋana i ta̱ a kuzuwa ɗa̱ kelime ɗe. Adama a na i ka̱sukpa̱ ta̱ Vuzavaguɗu, wi o kuyongo n a̱ɗa̱ ba, yi ta̱ a kubana ukpa̱ u kotokobi.>> ");
INSERT INTO asg_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","N nannai dem, ɗa e sheshei kubana a kusan ki iɗika ku na ku laꞋi n ugaɗi wa, ama ko akpati vu uzuwakpani u Vuzavaguɗu, ko Musa u ka̱sukpa̱ ka̱tsura̱ ka ba. ");
INSERT INTO asg_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ɗaɗa aza a Emeleki n aza a KanaꞋana a na i ida̱shi ɗe a nsasan mi iɗika ma, a̱ cipa̱i ɗa a lyaꞋi le n kuvon, ali o lokoi le sai a kubana a̱ likuci i Horuma. ");
INSERT INTO asg_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","<<YaꞋan kadanshi n aza a Isaraila vu dana le, ayin a na baci i uwai iɗika i na mi e kuneke ɗa̱ yo okpo iꞋuwa i ɗa̱, ");
INSERT INTO asg_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ɗa i nekei Vuzavaguɗu alyuka a na a ci yaꞋan n akina a̱ ka̱tsuma̱ ki ili yu ushiga, ko anaka ko wu nlala, tsa alyuka a ili i ma̱gula̱ni u Vuzavaguɗu, ko kuneꞋe ku kusongu, ko kuneꞋe ka kushatangu akucina, ko kuneꞋe ka alyuka ba̱ri, ko kuneꞋe ka̱ a̱ɗiva̱ a na i ci yaꞋansa a̱ ka̱ya̱ lakam, ");
INSERT INTO asg_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","vuza na baci de dem u kutuka̱ n kuneꞋe ku ni, u neke Vuzavaguɗu ifa vi te a̱ ka̱tsuma̱ ka kupa ka kiya ku singai uteku tsu kuneꞋe ki ishina, usatari n kagimi ka maniꞋin ma zaitu. ");
INSERT INTO asg_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","A̱ ma̱giri me te dem ma na i kuyaꞋanka kuneꞋe ku kusongu ko alyuka a, i ɓolongu n kagimi ke kedele ka̱ ma̱kya̱n tsu kuneꞋe ku kusoꞋo. ");
INSERT INTO asg_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ka̱giri kaꞋa baci vu nekei adama alyuka a, mayun ɗa vu tuka̱ n agimi e re a ifa a̱ ka̱tsuma̱ ka kupa ka kiya ku singai usatari n edele a tatsu a maniꞋin ma zaitu, ");
INSERT INTO asg_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","koɓolo n edele a tatsu a̱ ma̱kya̱n adama e kuneꞋe ku kusoꞋo. Nekei a ɗa ci ili i ma̱gula̱ni u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Yi baci a kuyaꞋan kuneꞋe ku kusongu n kobomburon tsa alyuka o kusongu ko kuneꞋe adama a kushatangu a kucina, ko kuneꞋe ku ma̱ta̱na̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Ka̱ta̱ vuza u neke kobomburon ka koɓolo n kuneꞋe ki ishina ku kiya ku singai ku ifa vu tatsu a̱ ka̱tsuma̱ ka kupa, usatari n kagimi ke kedele ka maniꞋin ma zaitu. ");
INSERT INTO asg_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Ka̱ta̱ kpamu vu neke kagimi ke kedele ka̱ ma̱kya̱n tsu kuneꞋe ki ili i kusoꞋo, ili i ma̱gula̱ni i singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","<<Nannai ɗa a kuyaꞋan n kobomburon, ko ka̱giri, ko maraɗika dem a̱ ubuta̱ wa alyuka. ");
INSERT INTO asg_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ta ya kuyaꞋan nannai n kuneꞋe ku na ye kuneke dem. ");
INSERT INTO asg_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Yaba dem va aza a Isaraila wi ta̱ a kuyaꞋan ili tsu nampa, a ayin a na u kuyaꞋan kuneꞋe ki ilikulya i ma̱gula̱ni i singai u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ama komoci ka̱ ta̱wa̱ baci ka̱ da̱sa̱ngi koɓolo n a̱ɗa̱, ko ta na wi punu n ida̱shi n a̱ɗa̱, ɗa u cikalai kuneke kuneꞋe ki ilikulya i ma̱gula̱ni i singai u Vuzavaguɗu, mayun ɗa u yaꞋan derere tsu na i ci yaꞋan. ");
INSERT INTO asg_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Aza a̱ ubuta̱ a i ta̱ a̱ kuka̱na̱ wila̱ u te, wila̱ u te u ɗa i kuyonko a̱ɗa̱ n omoci a̱ ɗa̱. Ka̱ta̱ wo okpo ɗa̱ wila̱ u ko wannai nu ntsukaya n ɗa̱ feu ra̱ka̱ n na n kuta̱wa̱, a̱ɗa̱ n omoci a̱ ɗa̱ yi ta̱ o kokpo vi te a̱ ubuta̱ u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Wila̱ u te u ɗa ɗa̱ n i na feu i kutono a̱ɗa̱ n omoci a na i ida̱shi koɓolo n a̱ɗa̱ va.>> ");
INSERT INTO asg_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Vuzavaguɗu u doku u yaꞋin kadanshi m Musa kpamu, u danai, ");
INSERT INTO asg_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","<<YaꞋan kadanshi n aza a Isaraila vu dana le, Ayin a na baci i uwai a iɗika i na mi a kubanka ɗa̱ va, ");
INSERT INTO asg_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ɗa baci i lyaꞋi ilikulya yi iɗika ya, mayun ɗa i foɓo i yoku a kakambu adama a na i neke Vuzavaguɗu tsa alyuka a̱ kuɗa̱ngusa̱. ");
INSERT INTO asg_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ka̱ya̱ dem i foɓo paki ishina yu ugiti i yoku i na i lapai. Ka̱ta̱ i yaꞋan ilikulya n kiya ku ugiti ku na yi iyai, ka̱ta̱ i tuka̱ mu ku na ku kokpo kuneꞋe ku kuɗa̱ngusa̱. ");
INSERT INTO asg_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ka̱ya̱ lakam a̱ɗa̱ n ntsukaya n ɗa̱, mayun ɗa i lyaꞋa kelime n kutuka̱ n ilikulya i na a yaꞋin n kiya ki ishina yu ugiti tsa alyuka a̱ kuɗa̱ngusa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","<<Ama ɗa baci i yaꞋin unushi wu unambi u kuyeve, ɗa i kpa̱ɗa̱i kutono wila̱ u na Vuzavaguɗu u tonokoi Musa na, ");
INSERT INTO asg_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","i na ra̱ka̱ Vuzavaguɗu u danai ɗa̱ a̱ ubuta̱ u Musa, ili i na i ɗikai a kanna ka na Vuzavaguɗu u nekei ɗa̱ wila̱, ali a kubana ntsukaya n ɗa̱ n na n kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Ɗa baci uma a a yaꞋin unushi u na e yevei n u ɗa ba, ra̱ka̱ vi le e neke mobomburon me te ma na a̱ utuka̱i ushiga tsu kuneꞋe ku kusongu, ili i ma̱gula̱ni i singai u Vuzavaguɗu, koɓolo n kuneꞋe ki ishina n ki ili i kusoꞋo, koɓolo m ma̱ga̱ji adama e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ka̱ta̱ ganu u takpaka aza a Isaraila unushi u le ra̱ka̱, ka̱ta̱ ta na a cinukpaka le u ɗa, adama a na n uyevi u le u ɗa a yaꞋin u ɗa ba, kpamu a̱ tuka̱ ta̱ n kuneꞋe adama a̱ unushi u le, n kuneꞋe ki ili i kulyaꞋa u Vuzavaguɗu, n kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ka̱ta̱ a cinukpaka aza a Isaraila ra̱ka̱ unushi u le, koɓolo n unushi wo omoci a na i punu ida̱shi n ele, adama a na uma ra̱ka̱ ɗa a nusai. ");
INSERT INTO asg_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","<<Ama vuma te ɗa baci u nusai babu u yeve, wi ta̱ e kuneke maraɗika ma̱ ka̱ya̱ ke te, adama e kuneꞋe ku unushi. ");
INSERT INTO asg_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ka̱ta̱ ganu u takpaka vuza na u nusai babu na u yevei va unushi u ni u Vuzavaguɗu, a takpaka yi baci unushi wa, ka̱ta̱ ta na a cinukpaka yi u ɗa. ");
INSERT INTO asg_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ka̱ta̱ i yongo n wila̱ u te ra̱ka̱, ɗa baci vuza u nusai babu u yeve, ko vuza vi iɗika, ko komoci ka na ki punu ida̱shi n ele. ");
INSERT INTO asg_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ama vuza na baci u yaꞋin unushi n uyevi u ni, ko vuza vi iɗika ko komoci, ali ɗa u yaꞋankai Vuzavaguɗu kadanshi ki ishikushi, vuma vu nanlo va mayun ɗa e pece yi n uma a̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Adama a na u goyo ta̱ kadanshi ka Vuzavaguɗu ɗa kpamu u koɗoi wila̱ u ni, mayun ɗa e pece vuma nanlo n uma a̱ ni, kpamu unushi u ni wi ta̱ o kokpo a kaci ka̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Kanna ke te, ayin a na aza a Isaraila i ɗe e meremune, a̱ ka̱na̱ ta̱ vuma a kuzama nɗanga a kanna ka Ashibi. ");
INSERT INTO asg_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Aza na a cinai ni a kuzama nɗanga ma, ɗa a̱ tuka̱i ni u Musa n Haruna n ubuta̱ u uma a Isaraila a na a buwai, ");
INSERT INTO asg_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ɗa a gbaguri ni a̱ kunu, adama a na ka̱ta̱ e yeve uteku tsu na a kuyaꞋan n a̱yi ka̱ta̱ ba. ");
INSERT INTO asg_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ɗa Vuzavaguɗu u danai Musa, <<Mayun ɗa vuza va u kuwa̱. Dem vu ɗa̱ ɗa ya kuvara yi n atali ka̱ta̱ u kuwa̱ a pulai vu ka̱tsura̱.>> ");
INSERT INTO asg_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ɗa ra̱ka̱ vu le a ɗikai vuma va a bankai pulai vu ka̱tsura̱ ɗa a varai ni n atali ɗa u kuwa̱i, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","<<Dana aza a Isaraila ukuna u nampa. A̱ɗa̱ nu ntsukaya n ɗa̱ dem, mayun ɗa i caꞋa tsugbere ubuta̱ u te i yaꞋan ita̱za̱, ka̱ta̱ i koɓo i ɗa n awin a̱ mini mu usuni a̱ vuta̱za̱ dem. ");
INSERT INTO asg_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ayin a na baci ye enei ita̱za̱ ya, yi ta̱ a kuciɓa n wila̱ u na n nekei ɗa̱ ra̱ka̱, ka̱ta̱ i tono u ɗa, an ya kuyaꞋan i na i cikalai ka̱ta̱ nannai u zuwa ɗa̱ yo okpo ili yu unata wa̱ va̱. ");
INSERT INTO asg_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ayin a na baci dem ye enei ita̱za̱ i nanlo, yi ta̱ a̱ kuɓa̱nka̱ ɗa̱ i ciɓa an mayun ɗa i tono wila̱ u va̱ ra̱ka̱, ka̱ta̱ kpamu yo okpo uma a ciɗa a̱ ubuta̱ u Ka̱shile ka̱ ɗa̱. ");
INSERT INTO asg_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱, a̱yi na wu uta̱ka̱i ɗa̱ a iɗika i Masar adama a na wo okpo Ka̱shile ka̱ ɗa̱. Mpa ɗa Vuzavaguɗu Ka̱shile ka̱ ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kanna ke te Kora, kolobo ka Izaharu, matsukaya ma Kohatu, kumaci ka aza Levi, u ɓolongi una̱ n Datan koɓolo n Abiram, muku n ali n Eliyabu, n Onu kolobo ke Peletu. Uma a tatsu a nampa uta̱ ta̱ a kumaci ku Ruben. ");
INSERT INTO asg_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Uma a̱ na̱shi a nampa o ɓolongi una̱ n aza e kelime a aza a Isaraila o yoku amangatawenre n amangerenkupa (250), a̱ ɓa̱nka̱ le adama a na a yaꞋanka Musa ugbamukaci. ");
INSERT INTO asg_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ɗa o ɓolongi ka̱ci ke le ɗa a̱ ta̱wa̱i u Musa n Haruna. Ɗa a danai le, <<A̱ɗa̱ uma ere a nampa, yi ta̱ a kulyaꞋa kakamba. Ka̱shile ka zagba tsu ta̱ ra̱ka̱ a̱ tsu aza a Isaraila, kpamu wi ta̱ koɓolo n a̱ tsu. Ama yiɗa̱i i zuwai ɗa i ci yaꞋan ili adanshi a̱ɗa̱ ɗa i laꞋi uma ra̱ka̱ ugaꞋin u Vuzavaguɗu?>> ");
INSERT INTO asg_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ana Musa u panai ka na a dansai, ɗa u kuɗa̱ngi sapu u lyaꞋi kayala. ");
INSERT INTO asg_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ɗa u danai Kora n aza na i koɓolo n a̱yi, <<Makpa n usana Vuzavaguɗu wi ta̱ o kuyotsongu uma yayi u zagbai wo okpo ganu vu ni, n vuza na wi ciɗa ɗa kpamu u ka̱sukpa̱i ni u yawa ɗevu n a̱yi. Vuza na u zagbai va wi ta̱ a kuzuwa yi u yawa ɗevu n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Adama a nannai, avu Kora n uma a̱ nu ra̱ka̱ mayun ɗa makpa i foɓuso a̱mbu a̱ ɗa̱ adama o kusongu ili i ma̱gula̱ni. ");
INSERT INTO asg_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Mayun ɗa i kenuku akina punu ka̱ta̱ i songu ili i ma̱gula̱ni e kelime ka Vuzavaguɗu. Ka̱ta̱ ce ene yayi a̱ ka̱tsuma̱ ka̱ tsu Vuzavaguɗu u zagbai wo okpo kagbashi ka ciɗa ka̱ ni. A̱ɗa̱ kumaci ka aza e Levi, a̱ɗa̱ ɗa aza na i lyaꞋi kakamba.>> ");
INSERT INTO asg_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ɗa Musa u doku u danai Kora, <<A̱ɗa̱ kumaci ka a aza e Levi, panai. ");
INSERT INTO asg_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ka̱shile ka̱ tsu ka aza a Isaraila ka zagba ɗa̱ ta̱ ra̱ka̱ adama na i yawa ɗevu n a̱yi adama na i yaꞋanka yi ulinga a̱ ma̱va̱li ma ciɗa, ka̱ta̱ kpamu i ga̱nda̱ka̱ uma. Nannai va ugaꞋin u ɗa ba? Ashe na lo va ili i gbani i ɗa wa̱ ɗa̱? ");
INSERT INTO asg_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kora avu n uma a̱ nu aza e Levi Vuzavaguɗu u tuka̱ ɗa̱ ta̱ ɗevu n a̱yi. Gogo na avu vu cikala ta̱ vo okpo ganu feu? ");
INSERT INTO asg_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Mayun ɗa avu n uma a̱ nu yi ta̱ o mololo adama a Haruna, yayi Haruna, ali ɗa yi a kuyaꞋanka yi mololo? Vuzavaguɗu ɗa yi a kuyaꞋanka ugbamukaci.>> ");
INSERT INTO asg_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ɗa Musa u suki e ɗeke Datan koɓolo n Abiram muku n ali n Eliyabu. Ama ɗa a danai, <<Ci a̱ kuta̱wa̱ ba. ");
INSERT INTO asg_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","U yawa ba ana vu uta̱ka̱i tsu a iɗika i Masar, iɗika i na yi m maniꞋin n tsuta̱, adama a na tsu kuwa̱ a kakamba ka nampa? Ɗa kpamu gogo na vi cigai vo okpo mogono ma̱ tsu? ");
INSERT INTO asg_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ɗa na ka̱ta̱ vu banka tsu a iɗika i na yi n ilikulya ba̱ri ba, vi neke tsu ta na ashina ko ashina a itacishi adama a na yo okpo yu uka̱ni i tsu ba. Kudoro ku ɗa koci vi o kudoro uma. A̱tsu tsa̱ kuta̱wa̱ wa̱ nu ba!>> ");
INSERT INTO asg_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ɗa Musa u yaꞋin wupa ka̱u ɗa u danai Vuzavaguɗu, <<Ka̱ta̱ vi isa kuneꞋe ku le ba. N saꞋwa kisa majaki we le ba, n saꞋwa feu kunusaka vuza te vi le ba.>> ");
INSERT INTO asg_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ɗa Musa u danai Kora, <<Avu n otoni a̱ nu ra̱ka̱ i ta̱wa̱ u Vuzavaguɗu mkpaꞋa. Haruna feu wi ta̱ a̱ kuta̱wa̱. ");
INSERT INTO asg_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Avu koɓolo n uma amangatawenre n amangerenkupa (250) va, yaba dem u ɗika ka̱mbu ko kusonku ili i ma̱gula̱ni ka na u kusonku ili i ma̱gula̱ni, ka̱ta̱ u tsungu ili i ma̱gula̱ni punu adama a na u songu i ɗa, yo okpo kuneꞋen u Vuzavaguɗu. Haruna feu u yaꞋan nannai.>> ");
INSERT INTO asg_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ɗa yaba dem u ɗikai ka̱mbu ka̱ ni, u kenuki akina ɗa a̱ tsungi ili i ma̱gula̱ni, ɗa a shamgbai a̱ utsutsu u Ma̱va̱li mo Oɓolo koɓolo m Musa n Haruna. ");
INSERT INTO asg_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ɗa Kora u ɓolongi uma a ra̱ka̱ ubuta̱ u te, ɗa u zuwai le a yaꞋanka Musa n Haruna ugbamukaci, a̱ utsutsu u Ma̱va̱li mo Oɓolo ma. Ɗa tsugbayin tsu Vuzavaguɗu tsu ta̱wa̱i u yaba dem. ");
INSERT INTO asg_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa n Haruna, u danai, ");
INSERT INTO asg_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","<<Pece ka̱ci ka̱ ɗa̱ n uma a nampa, adama a na mu una le gogo na.>> ");
INSERT INTO asg_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ama ɗa Musa koɓolo n Haruna a̱ kuɗa̱ngi sapu a lyaꞋi kayala, ɗa a danai, <<Avu Ka̱shile, Ka̱shile kaꞋa, avu ɗa vu zuwai uma ra̱ka̱ o yongo n wuma, vuma te wi ta̱ a kunusa ka̱ta̱ vo okpo a wupa n uma dem?>> ");
INSERT INTO asg_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","<<Dana uma ra̱ka̱ a̱ ka̱sukpa̱ ubuta̱ wa̱ a̱pa̱m anan Kora n Datan koɓolo n Abiram i.>> ");
INSERT INTO asg_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ɗa Musa u ɗa̱nga̱i u banai u Datan koɓolo n Abiram, ɗa nkoshi m gba̱ra̱-gba̱ra̱ ma aza a Isaraila n tonoi ni. ");
INSERT INTO asg_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ɗa u danai koɓolo ka uma ka, <<Ka̱sukpa̱i ubuta̱ wa̱ a̱pa̱m a uma a gbani-gbani a nampa. Kpamu ka̱ta̱ i saꞋwa ko ili i te i le ba, ta lo ya̱ kuwa̱ adama a̱ unushi u le.>> ");
INSERT INTO asg_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ɗa uma ra̱ka̱ a̱ ka̱sukpa̱i ubuta̱ u ka̱pa̱m ka Kora, n ka Datan, koɓolo n ka Abiram. Ɗa Datan n Abiram a̱ uta̱i pulai va̱ a̱pa̱m e le a shamgbai utsutsu koɓolo n a̱ma̱ci e le, m muku n le ali ni nreɓu n le dem. ");
INSERT INTO asg_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ɗa Musa u danai, <<Nannai ɗa i kuyeve a na Vuzavaguɗu ɗa u suki mu n ta̱wa̱ n yaꞋan ili i nampa dem, kpamu n uyevi u ka̱ci ka̱ va̱ u ɗa mi a kuyaꞋan i ɗa ba. ");
INSERT INTO asg_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ɗa baci uma a nampa a̱ kuwa̱i a̱ ukpa̱ u na a kiwanai, kpamu ili i na i ci ciya̱ ɗaɗa feu i ciya̱i le, u ko okpo ta̱ an mayun ɗa Vuzavaguɗu u suki mu ba. ");
INSERT INTO asg_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ama Vuzavaguɗu u yaꞋan baci ili i savu i yoku, ɗa iɗika i ɓa̱yuwa̱i una̱ ali ɗa i soɗongi le koɓolo n ili i na i n i ɗa dem, ɗa a lazai punu a asuvu a iɗika n wuma, nannai ɗa i kuyeve a na uma a nampa o goyo ta̱ Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ana Musa u kotsoi kuyaꞋan kadanshi ka nampa, ɗa iɗika i na i kashani i ɓa̱yuwa̱i una̱, ");
INSERT INTO asg_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ɗa i soɗongi le n limata i le koɓolo n otoni o Kora dem, n i na i n i ɗa feu. ");
INSERT INTO asg_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","A lazai punu a iɗika nannai n wuma u le koɓolo n i na i n i ɗa ra̱ka̱. Ɗa iɗika i ɓa̱ya̱ngi, ɗa a̱ kuwa̱i a̱ a̱shi a uma. ");
INSERT INTO asg_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ana aza a Isaraila a na i lo ra̱ka̱ a panai yoroli i uma ya ɗa a sumai, a kudana, <<Iɗika ya yi ta̱ o kusoɗongu tsu feu.>> ");
INSERT INTO asg_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ɗa akina uta̱i u Vuzavaguɗu ɗa e leɓecei uma amangatawenre n amangerenkupa (250), a na i e kuneke ili i ma̱gula̱ni ya. ");
INSERT INTO asg_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","<<Dana Eliyaza kolobo ka Haruna ganu, u takpa a̱mbu a na i n ili a̱ kukula̱ n ili i ma̱gula̱ni ya ra̱ka̱. Ka̱ta̱ u vishuwa̱ even a ikyamba a daꞋangi ka̱u, adama a na i ta̱ ciɗa. ");
INSERT INTO asg_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ama a̱mbu a uma a nampa tamkpamu aza na a yaꞋan unushi ali ɗa a̱ kuwa̱i va, ɗikai a ɗa ka̱ta̱ i jara okpo apalatsu a katalikalyuka, adama a na e neke ta̱ a ɗa u Vuzavaguɗu, okpo ta̱ ili i ciɗa. Nannai ɗa u kokpo urotu wu uɓarangi a̱ ubuta̱ wa aza a Isaraila.>> ");
INSERT INTO asg_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ɗa Eliyaza ganu u ɗikai a̱mbu a uma a na a̱ kula̱i ɗa u jarai le ɗa u yaꞋin kapalatsu ka katalikalyuka, ");
INSERT INTO asg_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","adama a na wo okpo ili i kuciɓasa ya aza a Isaraila, ciya̱ komoci ka na ki kumaci ku Haruna ba, ka̱ ta̱wa̱ ɗevu kusongu kuneꞋe ki ili i ma̱gula̱ni u Vuzavaguɗu ba, ta lo yo kokpo tsu Kora n uma a̱ ni, tsu na Vuzavaguɗu u danai Musa. ");
INSERT INTO asg_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ama a na kayin ka asai ɗa uma a aza a Isaraila ra̱ka̱ a yaꞋankai Musa n Haruna mololo, a danai, <<Yu una ta̱ uma a Vuzavaguɗu.>> ");
INSERT INTO asg_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ama a na uma a o ɓolongi a kuyaꞋanka Musa n Haruna mololo, ɗa anan Musa a a kpatalai a kinda uɓon u Ma̱va̱li mo Oɓolo, ɗa enei keleshu ka palai kaꞋa, ɗa tsugbayin tsu Vuzavaguɗu tsu ta̱wa̱i. ");
INSERT INTO asg_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ɗa Musa koɓolo n Haruna a banai kelime ku utsutsu u Ma̱va̱li wa. ");
INSERT INTO asg_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","<<Pecei ka̱ci ka̱ ɗa̱ n uma a nampa a, adama a na mu una le gogo na.>> Ɗa Musa n Haruna a̱ kuɗa̱ngi sapu ɗa a lyaꞋi kayala. ");
INSERT INTO asg_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ɗa Musa u danai Haruna, <<Ɗika ka̱mbu vu kenuku tsikina a katalikalyuka vu tsungu ili i ma̱gula̱ni, yeve vi yaꞋan moloko vu bana a̱ ubuta̱ u uma a, vu takpaka le nshinda̱, adama a na wupa u Vuzavaguɗu u ɗa̱nga̱ ta̱, kpamu ma̱dukpa̱ ta na feu ma̱ gita̱ ta̱ ɗe.>> ");
INSERT INTO asg_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ɗa Haruna u yaꞋin tsu na Musa u danai ni, u sumai u banai u uwai e mere ma uma ma, ma̱dukpa̱ ta na ma̱ gita̱ ta̱ ɗe, ama ana Haruna u songi ili i ma̱gula̱ni ya ɗa u takpakai le unushi wa. ");
INSERT INTO asg_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ɗa u shamgbai e mere ma aza a wuma n aza na a̱ kuwa̱i, ɗa ta na ma̱dukpa̱ ma̱ ka̱sukpa̱i. ");
INSERT INTO asg_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Uma a na ma̱dukpa̱ ma mu unai, a yawa ta̱ uma a̱kpa̱n kupa n a na̱shi n amangatawencindere (14, 700), babu ta na aza na a̱ kuwa̱i koɓolo n Kora. ");
INSERT INTO asg_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ɗa Haruna u bonoi a̱ ubuta̱ u Musa, a̱ utsutsu u Ma̱va̱li wa, adama a na ma̱dukpa̱ ma mo kotsoi. ");
INSERT INTO asg_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","<<YaꞋan kadanshi n aza a Isaraila ka̱ta̱ vi ciya̱ alangu kupa n ere a̱ ubuta̱ u le, ke te dem u vuza kelime vu umaci dem. Vu ɗana kula ku yaba dem a kalangu ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","A kalangu ka aza e Levi, vu ɗana ɗe kula ku Haruna, mayun ɗa vuza kelime a kumaci dem u yaꞋan n kalangu ke te. ");
INSERT INTO asg_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Vu zuwa le a̱ Ma̱va̱li mo Oɓolo, e kelime ka Akpati vu Uzuwakpani, a̱ ubuta̱ u na n tsu gasa n a̱ɗa̱. ");
INSERT INTO asg_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kalangu ka na baci ki ka vuza na n zagbai, ki ta̱ o kutopo, ɗaɗa n kuyawaka uteku u mololo ma na aza Isaraila i a kuyaꞋanka wu na.>> ");
INSERT INTO asg_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ɗa Musa u yaꞋin kadanshi n aza a Isaraila, ɗa ta na aza e kelime e le e nekei ni alangu kupa n ere, ke te ka vuza kelime vu umaci dem, n kalangu ka Haruna feu. ");
INSERT INTO asg_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ɗa Musa u zuwai alangu a e kelime ka Vuzavaguɗu a̱ Ma̱va̱li ma̱ Ka̱shile. ");
INSERT INTO asg_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","An kayin kasai ɗa Musa u uwai a̱ Ma̱va̱li mo Oɓolo ma ɗa u cinai kalangu ka Haruna ka na a zuwai a̱ una̱ u kpaꞋa ku Levi ko topoi ɗe, ali ka yaꞋin a̱pa̱lu ka matsai umaci u alumo u na u geꞋwei. ");
INSERT INTO asg_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ɗa Musa wu uta̱ka̱i n alangu a na i punu uzuwi e kelime ka Vuzavaguɗu ka ra̱ka̱, ɗa u tuka̱i ubuta̱ wa aza a Isaraila. Ana a indanai a ɗa, ɗa vuza kelime dem u ɗikai kalangu ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ɗa Vuzavaguɗu u danai Musa, <<Bonoko n kalangu ka Haruna ka e kelime ka Akpati vu Uzuwakpani va, a zuwa lo kaꞋa kokpo urotu u kanananai ka aza a ugbamukaci. Nannai va wi ta̱ a kuzuwaka mololo ma na i a kuyaꞋanka wu va uteku, ciya̱ a̱ kuwa̱ ba.>> ");
INSERT INTO asg_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ɗa Musa u yaꞋin derere tsu na Vuzavaguɗu u tonokoi ni. ");
INSERT INTO asg_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ɗa aza a Isaraila a danai Musa, <<Ci ta̱ a̱ kukuwa̱.Tsu puwa̱nka̱ ta̱. Dem vu tsu, tsu puwa̱nka̱ ta̱. ");
INSERT INTO asg_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Vuza na baci de dem u yawai ɗevu n Ka̱pa̱m ka Vuzavaguɗu ka, wi ta̱ a̱ kukuwa̱. Ci ta̱ a̱ kukuwa̱ ra̱ka̱ vu tsu?>> ");
INSERT INTO asg_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Vuzavaguɗu u danai Haruna, <<Avu, m muku n ali n nu, n aza a̱ ɗa̱ a na yu uta̱i a kumaci ke esheku a̱ nu, a̱ɗa̱ ɗa i kuɗika a̱miki a̱ unushi u na u saꞋwai a̱Ꞌisa̱. Ama avu m muku n ali n nu koci, a̱ɗa̱ ɗa i kuɗika a̱miki a̱ unushi dem a na a saꞋwai ubuta̱ wu ulinga u tsuganu. ");
INSERT INTO asg_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ka̱ta̱ vu tuka̱ n aza a̱ nu, aza e Levi, aza na yi kumaci ku te, adama a na o ɓolongu ekiye n avu, m muku n nu, ka̱ta̱ a̱ ɓa̱nka̱ ɗa̱ a ayin a na yi a kuyaꞋan a̱ga̱nda̱ punu a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ulinga u le u ɗa a̱ ɓa̱nka̱ ɗa̱, ka̱ta̱ kpamu a yaꞋansa ulinga u na wi punu a̱ Ma̱va̱li dem. Ama ka̱ta̱ a yawa ɗevu n ili yu ulinga i Ma̱va̱li ya ba, ko katalikalyuka ba, ta lo dem vu ɗa̱ ya̱ kuwa̱. ");
INSERT INTO asg_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","I ta̱ o kuɓolongu ekiye n avu ka̱ta̱ a̱ la̱na̱ Ma̱va̱li mo Oɓolo ma, ka̱ta̱ a yaꞋan ulinga dem, ama ka̱ta̱ vuza yoku kau u yawa ɗevu n ubuta̱ u na yi ulinga ba. ");
INSERT INTO asg_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","<<Avu m muku n ali n nu n ɗa i kuɗika a̱miki a ulinga u kula̱na̱ Ma̱va̱li ma̱ Ka̱shile koɓolo n katalikalyuka, adama a na ka̱ta̱ wupa u Vuzavaguɗu u doku u cipa̱ wa aza a Isaraila kpamu ba. ");
INSERT INTO asg_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mpa n ka̱ci ka̱ va̱ n zagbaka ɗa̱ ta̱ aza a̱ɗa̱ aza e Levi a̱ ka̱tsuma̱ ka aza a Isaraila, o okpo ta̱ tsu kuneꞋe wa̱ ɗa̱, e nekei le u Vuzavaguɗu adama a na a yaꞋan ulinga u na wi punu a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ama avu ɗa koci m muku n nu i kuyaꞋan ulinga u tsuganu, koɓolo n ili i na i buwai i na a kuyaꞋan a katalikalyuka dem n asuvu a kakashi ku utsutsu ka. N neke ɗa̱ ta̱ ulinga u tsuganu tsu kuneꞋe ku gbani. Ɗa baci vuza yoku kau u yawai ɗevu m Ma̱va̱li ma, wi ta̱ a̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ɗa Vuzavaguɗu u danai Haruna, <<Mpa a̱ ka̱ci ka̱ va̱ n zuwa wu ta̱ vo okpo vuza na u kula̱na̱ kuneꞋe ku na a̱ kutuka̱sa̱ wa̱ va̱. KuneꞋe ku ciɗa ku na aza a Isaraila a̱ kutusa̱ka̱ dem, mi ta̱ e kuneke wu ku ɗa avu m muku n nu ciya̱ wo okpo upecu u ɗa̱ u ayin dem. ");
INSERT INTO asg_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Mayun ɗa vo okpo n ugboku u kuneꞋe ku na ku laꞋi n ciɗa, ku na a̱ kpa̱ɗa̱i kusongu. A̱ ka̱tsuma̱ ke kuneꞋe ra̱ka̱ ku na a̱ tuka̱i mu ku na kulaꞋi n ciɗa, ko ki ishina, ko kuneꞋe ku unushi, ko ku kutakpa ku unushi, ugboku u nanlo wi ta̱ o kokpo u nu m muku n nu. ");
INSERT INTO asg_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","LyaꞋa i ɗa ci ili i na i laꞋi n ciɗa, mavali dem u lyaꞋa i ɗa. Ɗikai i ɗa yo okpo ɗa̱ ili i na i laꞋi n ciɗa. ");
INSERT INTO asg_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Na va feu ku ɗa̱ ku ɗa, kuneꞋe dem ku na baci a̱ tuka̱i mu, a ayin a na aza a Isaraila a̱ ɗengusa̱i ku ɗa gaɗi a katalikalyuka. N neke wu ta̱ ku ɗa avu n olobo a̱ nu ni nkere n nu feu, wo okpo ɗa̱ ta̱ upecu u ayin tutu. Yaba dem a kpaꞋa ku nu, vuza na nshinda̱ n ni n yaꞋin utakpi wi ta̱ a kulyaꞋa i ɗa. ");
INSERT INTO asg_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","N neke wu ta̱ maniꞋin ma zaitu ma na ma laꞋi n kugaꞋan, m ma̱kya̱n ma na ma laꞋi n kugaꞋan, koɓolo n ishina i na a̱ tsu gita̱ kuneke Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Imacishi i kashina yi iɗika i na i gita̱i kugeꞋwe, i na uma a̱ kutuka̱ u Vuzavaguɗu yi ta̱ o kokpo i nu. Yaba dem vu na wi babu nshinda̱ a kpaꞋa ku nu, wi ta̱ a kufuɗa kulyaꞋa i ɗa. ");
INSERT INTO asg_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","<<Ili ra̱ka̱ i na yi punu a Isaraila ɗa e nekei i ɗa u Vuzavaguɗu, i nu i ɗa. ");
INSERT INTO asg_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Maku ma na a̱ gita̱i kumatsa, vuma ko manama, ɗa e nekei maꞋa u Vuzavaguɗu, mo okpo ta̱ ma̱ nu. Ama mayun ɗa ayin dem vi shiba̱ maku ma vali ma vuma ma na a̱ gita̱i kumatsa, ko manama ma na a̱ gita̱i kumatsa ɗa mi n unata. ");
INSERT INTO asg_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ayin a na baci i wotoi u te n umaci, katsupu ka̱ kushiba̱ ka ka yaꞋan azurufa a tawun. U wala derere n kagisamkpatsu ka̱ a̱Ꞌisa̱ ka. ");
INSERT INTO asg_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","<<Ama ka̱ta̱ vu shiba̱ maku ma kanaka, ko mokyon, ko maraɗika ma na a̱ gita̱i kumatsa ba, adama na i ta̱ ciɗa. Vu vishangu mpasa n le a katalikalyuka, ka̱ta̱ kpamu i songu ushuma u le wo okpo ili i kuneꞋe ku na a yaꞋin n akina, ci ili i ma̱gula̱ni a kubana u Vuzavaguɗu. ");
INSERT INTO asg_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Inyama yi nnama n nanlo yi ta̱ o kokpo i nu, tsu na kpamu uɓon u ma̱ka̱nga̱ koɓolo m ma̱kuta̱ mu usingai ma na e nekei tsu kuneꞋe ku kuɗa̱ngusa̱ yo okpoi i nu. ");
INSERT INTO asg_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","KuneꞋe ku ciɗa dem ku na aza a Isaraila e kuneke Vuzavaguɗu, n neke wu ta̱ ku ɗa n olobo a̱ nu koɓolo ni nkere n nu dem, tsu ugboku u nu u ayin dem. Uzuwakpani wa akucina, a kubana u Vuzavaguɗu adama a̱ nu m muku n nu.>> ");
INSERT INTO asg_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ɗa Vuzavaguɗu u danai Haruna, <<Va kuciya̱ punu ili yu uka̱ni i nu a iɗika ya ba, ko vi ciya̱ ugboku punu we le ba. Mpa ɗa ugboku u nu n upecu u nu a̱ ka̱tsuma̱ ka aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","<<N neke ta̱ anan Levi i te dem a̱ ka̱tsuma̱ ka kupa punu a Isaraila wo okpo ili i ka̱ci ke le, tsu katsupu ku ulinga u na a yaꞋin, a ayin a na i a kuyaꞋan ulinga a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ili i na i ɗikai gogo na, aza a Isaraila o kudoku kuyawa ɗevu m Ma̱va̱li mo Oɓolo ba, a yaꞋan baci nannai i ta̱ a kuɗika a̱miki a̱ unushi u le ka̱ta̱ a̱ kuwa̱. ");
INSERT INTO asg_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Aza e Levi a ɗa a kuyaꞋan ulinga u Ma̱va̱li mo Oɓolo, ka̱ta̱ kpamu a ɗika a̱miki a̱ unushi a̱ ubuta̱ u nanlo. Na va uzuwakpani u ɗa u na u kukotso ba, ali a kubana ntsukaya n ntsukaya n na n kuta̱wa̱. A̱ kuciya̱ ili i ka̱ci ke le a̱ ubuta̱ wa aza a Isaraila ba. ");
INSERT INTO asg_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Adama a na n neke ta̱ aza e Levi i te a̱ ka̱tsuma̱ ka kupa i na aza a Isaraila a̱ tsu tuka̱, adama a na wo okpo upecu u le wi ili i te a̱ ka̱tsuma̱ ka kupa i na aza a Isaraila e nekei ci ili i kuneꞋe u Vuzavaguɗu. I ɗaɗa i zuwai ɗa n danai, ele a̱ kuciya̱ ili i ka̱ci ke le a̱ ubuta̱ wa aza a Isaraila ba.>> ");
INSERT INTO asg_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, ");
INSERT INTO asg_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","<<YaꞋan kadanshi n aza e Levi vu dana le, <Yi isa baci ili i te a̱ ka̱tsuma̱ ka kupa i na aza a Isaraila a̱ tuka̱i, n neke ɗa̱ ta̱ i ɗa yo okpo i ɗa̱, mayun ɗa i neke ili i te a̱ ka̱tsuma̱ ka kupa ki ili i nanlo ya u Vuzavaguɗu tsu kuneꞋe. ");
INSERT INTO asg_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","KuneꞋe ku nanlo i ta̱ e kukece ku ɗa tsu kuneꞋe ku na kacimbi ka yaꞋin, ɗaɗa kuneꞋe ki ishina i na i gita̱i kugeꞋwe, m ma̱kya̱n ma savu feu. ");
INSERT INTO asg_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ta feu a̱ɗa̱ i kuyaꞋan nannai i neke kuneꞋe u Vuzavaguɗu a̱ ubuta̱ wi ili i te a̱ ka̱tsuma̱ ka kupa i na i ciya̱i a̱ ubuta̱ wa aza a Isaraila. Punu a̱ ka̱tsuma̱ ki ili i te i nampa, mayun ɗa i neke ugboku u Vuzavaguɗu u Haruna ganu. ");
INSERT INTO asg_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","A̱ ka̱tsuma̱ ke kuneꞋe ku na e nekei ɗa̱ ra̱ka̱, i neke ku na ku laꞋi n kugaꞋan u Vuzavaguɗu.> ");
INSERT INTO asg_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","<<Dana aza e Levi, <Ɗa baci e nekei ugboku u na u laꞋi n kugaꞋan, i ta̱ e kukeceke ɗa̱ u ɗa tsu kuneꞋe ki ishina koɓolo n ku ma̱kya̱n ma savu. ");
INSERT INTO asg_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","A̱ɗa̱ n aza a kpaꞋa a̱ ɗa̱ yi ta̱ a kulyaꞋa i na i buwai va a̱ ubuta̱ dem, adama a na i ɗaɗa katsupu ka̱ ɗa̱ ku ulinga u na i yaꞋin a̱ Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Nannai wi ta̱ a kuzuwa yo okpo babu unushi, i neke baci ugboku u na u laꞋi n kugaꞋan. Yi feu a kuꞋuka kuneꞋe ku ciɗa ka aza a Isaraila nshinda̱ ba, yi feu a̱ kukuwa̱ ba.> >> ");
INSERT INTO asg_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa koɓolo n Haruna, u danai. ");
INSERT INTO asg_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","<<Na va ɗaɗa wila̱ u na Vuzavaguɗu u zuwai. Uma a Isaraila i ta̱ a̱ kutuka̱ Musa n kobomburon ka shili ka na ki babu uꞋiwin u Ka̱shile, n ka na ka̱ta̱ a yaꞋankai kunima ba. ");
INSERT INTO asg_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Wi ta̱ e kuneke kaꞋa Eliyaza, ganu, ka̱ta̱ a ɗika kaꞋa a̱ uta̱ka̱ kaꞋa a pulai vu ka̱tsura̱ va, ka̱ta̱ a kiɗa kaꞋa a̱yi e kene. ");
INSERT INTO asg_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ka̱ta̱ Eliyaza, ganu va u dyaɓasa mpasa ma n ka̱jivu ka̱ta̱ u vishangu n ɗa kucindere a̱ Ma̱va̱li mo Oɓolo ma. ");
INSERT INTO asg_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Yeve o songu kobomburon ka n ukpan u ni, ni nyama i ni, nu mpasa koɓolo n a̱wiya̱n a̱ ni dem a̱yi e kene. ");
INSERT INTO asg_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ka̱ta̱ ganu u ɗika nɗanga n sida, n izobu, n tsugbere ci shili ka̱ta̱ a taɗuku punu a akina a na o kusongu kobomburon ka. ");
INSERT INTO asg_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ayin a na baci o kotsoi ka̱ta̱ ganu u za̱Ꞌa̱ akashi a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ u bono a̱ ka̱pa̱m. Ama wi ta̱ o kuyongo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Vuza na u songi kobomburon ka feu wi ta̱ a̱ kuza̱Ꞌa̱ akashi a̱ ni m mini, ka̱ta̱ u sumba̱. Ama a̱yi feu wi ta̱ o kuyongo n unata ali a kubana kulivi. ");
INSERT INTO asg_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","<<Vuma vu na wi babu nshinda̱ a̱yi ɗa u kupura̱ kokomo ko kobomburon ka u foɓo kaꞋa a̱ ubuta̱ u ciɗa a pulai vu ka̱pa̱m. Aza a Isaraila i ta̱ o kufoɓo kokomo ka adama a ulinga u mini ma kutakpaka nshinda̱. Na lo ɗa wila̱ u kutakpa nshinda̱. ");
INSERT INTO asg_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Vuza na u pura̱i kokomo ka kobomburon ka wi ta̱ a̱ kuza̱Ꞌa̱ akashi a̱ ni ka̱ta̱ u yongo n unata ali a kubana kulivi. N nannai ɗa wo kokpo wila̱ u makyan dem wa aza a Isaraila, n omoci a na i punu ida̱shi we le. ");
INSERT INTO asg_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","<<Vuza na baci de dem u saꞋwai keven ka vuma, wi ta̱ o kuyongo n unata ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Mayun ɗa u takpaka ka̱ci ka̱ ni nshinda̱ m mini a kanna ka tatsu n ke cindere, ka̱ta̱ wo okpo ciɗa. Ama ɗa baci u takpakai ka̱ci ka̱ ni nshinda̱ a kanna ka tatsu, n kanna ke cindere ba, wi o kokpo ciɗa ba. ");
INSERT INTO asg_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Vuza na baci de dem u saꞋwai keven ka vuma na u kuwa̱i, ɗa u kpa̱ɗa̱i kutakpaka ka̱ci ka̱ ni nshinda̱, u la̱nga̱sa̱ ta̱ ka̱pa̱m ka Vuzavaguɗu. Vuma nanlo va mayun ɗa a takpa yi a̱ ka̱tsuma̱ ka aza a Isaraila, adama a na ka̱ta̱ a vishangu yi m mini ma kutakpaka nshinda̱ ba, wi ciɗa ba. Nshinda̱ n ni m buwa ta̱ koɓolo n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","<<Na ɗa wila̱ u na wi punu, ɗa baci vuma u kuwa̱i a̱ ma̱va̱li. Vuza na baci u ta̱wa̱i a̱ ma̱va̱li n vuza na wi punu a̱ ma̱va̱li ma dem a ayin a na vuza va u kuwa̱i, wi ta̱ o kokpo n unata ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Kpamu apara a na i punu a̱ ka̱pa̱m ka dem a na i babu a̱kuya̱mkpa̱tsu i ta̱ o kokpo n unata. ");
INSERT INTO asg_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","<<Vuza na baci de dem wi e keteshe ɗa u saꞋwai vuma na a unai n kotokobi, ko u kuwa̱i nannai, ko u saꞋwai ketele ka vuma ko kasaun, wi ta̱ o kokpo n unata ali ayin e cindere. ");
INSERT INTO asg_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","<<Adama a na a takpaka uma nshinda̱, yi ta̱ e kukenuku kokomo ko kobomburon ka shili ka na o songi va ka̱ta̱ a̱ tsungu o mogbodo, ka̱ta̱ a̱ tsungu mini ma singai punu. ");
INSERT INTO asg_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Vuza na wi babu unata a̱yi ɗa u kuɗika izobu va ka̱ta̱ u rumbuku punu a̱ mini ma, ka̱ta̱ u vishanku ma̱va̱li ma n i ili i na yi punu n uma a na i punu dem, n vuza na u saꞋwai ketele ka, ko vuma na a unai ko vuza na u kuwa̱i ko kasaun ka. ");
INSERT INTO asg_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Vuza ciɗa a̱yi ɗa u kuvishangu aza a unata a kanna ka tatsu n kanna ke cindere, ka̱ta̱ a kanna ke cindere ka, u ciɗatangu yi. Vuza na a ciɗatangu yi va mayun ɗa u za̱Ꞌa̱ aminya a̱ ni ka̱ta̱ u sumba̱ m mini, ka̱ta̱ yeve a kubana kulivi ku nanlo ka wo okpo ciɗa. ");
INSERT INTO asg_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","<<Ama ɗa baci vuza vu unata u iwain kubonoko ka̱ci ka̱ ni ciɗa, i ta̱ a kutakpa yi a̱ ka̱tsuma̱ ka uma, adama a na u la̱nga̱sa̱ ta̱ a̱Ꞌisa̱ a Vuzavaguɗu n unata. Ka̱ta̱ a vishanku yi mini ma kutakpa nshinda̱ ba, kpamu wi ta̱ n unata. ");
INSERT INTO asg_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Na va ɗaɗa le wila̱ u na u kukotso ba. Vuma na u vishangi mini ma kutakpa nshinda̱ ma, mayun ɗa feu u za̱Ꞌa̱ aminya a̱ ni, ɗa baci vuza u saꞋwai mini ma kutakpa nshinda̱ ma wi ta̱ o kokpo n unata ali kulivi. ");
INSERT INTO asg_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ili i na baci de dem vuza vu unata va u saꞋwai, yi ta̱ o kokpo n unata, kpamu ɗa baci vuza u saꞋwai ili ya, wi ta̱ feu o kokpo n unata ali a kubana kulivi.>> ");
INSERT INTO asg_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","O wotoi u iyain u ka̱ya̱ ka na aza a Isaraila ra̱ka̱ a̱ yawai e meremune ma Zinu, ɗa a̱ cipa̱i a Kadeshi. Ta ɗe Miriyamu u kuwa̱i ɗa a̱ ciɗa̱ngi ni. ");
INSERT INTO asg_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","A̱ ubuta̱ wa, mini mi lo ma na uma o kusoꞋo ba, ɗa o ɓolongi ka̱ci ke le ubuta̱ u te a kuyaꞋanka Musa n Haruna mololo. ");
INSERT INTO asg_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ɗa a yaꞋankai Musa mololo, a danai, <<Wi ishi u laꞋa n kugaꞋan tsu kuwa̱ tsu na aza a̱ tsu a̱ kuwa̱i a̱ a̱shi a Vuzavuguɗu. ");
INSERT INTO asg_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Yiɗa̱i i zuwai ɗa vu tuka̱i uma a Vuzavaguɗu a kakamba ka nampa, adama a na tsu kuwa̱, a̱ tsu n ilikuzuwa i tsu dem? ");
INSERT INTO asg_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Yiɗa̱i ɗa vu uta̱ka̱i tsu a Masar vu tuka̱i tsu tsu kuwa̱ a̱ ubuta̱ u gbani-gbani u nampa? Ubuta̱ u na wi babu ishina, a̱ mbiri, n itacishi yi ina̱bi, ko umaci u ruman. Kpamu babu mini mo kusoꞋo.>> ");
INSERT INTO asg_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ɗa Musa n Haruna a̱ ka̱sukpa̱i uma a banai a utsutsu u Ma̱va̱li mo oɓolo ɗa a̱ kuɗa̱ngi sapu a lyaꞋi kayala. Ɗa tsugbayin tsu Vuzavaguɗu tsu ta̱wa̱i we le. ");
INSERT INTO asg_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","<<Ɗika kalangu ka, avu koɓolo m mokoshi ma̱ nu Haruna ka̱ta̱ vu ɓolongu uma a̱ ubuta̱ u te, ka̱ta̱ vi yaꞋan kadanshi n katali ka nanlo ka ele e kene, mini mi ta̱ a̱ kuta̱. Vi ta̱ a̱ ku uta̱ka̱ m mini a katali adama na uma n ilikuzuwa i le o soꞋo.>> ");
INSERT INTO asg_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ɗa Musa u takpai kalangu ka e kelime ka Vuzavaguɗu, tsu na u danai ni. ");
INSERT INTO asg_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ɗa Musa n Haruna o ɓolongi uma a katali ka, ɗa u danai le, <<Gogo na panai, a̱ɗa̱ aza a ugbamukaci, i ciga ta̱ tsu neke ɗa̱ mini a katali ka nampa?>> ");
INSERT INTO asg_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ɗa Musa u ɗa̱ngusa̱i kukiye ku ni ɗa u lapai katali ka n kalangu kure, ɗa mini mu uta̱i a katali ka n a̱bunda̱i, ɗa uma n ilikuzuwa i le o soꞋi. ");
INSERT INTO asg_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ama ɗa Vuzavaguɗu u danai Musa n Haruna, <<A na wo okpoi i iwan ta̱ kuneke a̱ɗu a̱ ɗa̱ mayin adama a na i cikpa mu an mi ciɗa e kelime ka aza a Isaraila, adama a nannai a̱ɗa̱ ɗa ya kubanka uma a nampa a iɗika i na n nekei le ba.>> ");
INSERT INTO asg_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Na va ɗaɗa mini ma Mariba, ubuta̱ u na uma a Isaraila a yaꞋankai Vuzavaguɗu mololo, ɗa u yotsonki le an wi ciɗa a̱ ka̱tsuma̱ ke le. ");
INSERT INTO asg_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa u suki alingata n akaka a̱ uta̱i a Kadeshi a kubanka mogono ma aza a Edom, a danai, <<Ili i na vuza nu Isaraila u danai i ɗa na. Vu yeve ta̱ atakaci dem a na ci o kusoꞋo. ");
INSERT INTO asg_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ikaya i tsu i bana ta̱ Masar, ɗa ci da̱sa̱ngi ɗe a̱ya̱ n a̱bunda̱i. Ama ɗa aza a Masar a takacikai tsu ka̱u n ikaya i tsu dem. ");
INSERT INTO asg_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ana tsu shika̱i u Vuzavaguɗu, ɗa u panai ma̱shi ma̱ tsu ɗa u suꞋuki kalingata ka̱ Ka̱shile kuta̱ka̱ tsu a Masar. Gogo na a̱ tsu ɗa na a Kadeshi, a̱ likuci i na yi e kureꞋe ki iɗika i nu. ");
INSERT INTO asg_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tsu folono wu ta̱, vu ka̱sukpa̱ tsu tsu tono n iɗika i nu. Tso kutono a ashina a̱ nu ko a ashina a nɗanga mi itacishi a̱ nu ba, ko tsu soꞋo mini ma kayinva ka̱ nu ba. Ci ta̱ o kutono uye u gbayin koci. Ci ta na a kuɓatsa ugula̱ ko usingai ba, ali tsu uta̱ uteku u nu.>> ");
INSERT INTO asg_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ɗa mogono ma Edom mu ushuki, <<A̱Ꞌa̱, ma̱ kuka̱sukpa̱ ɗa̱ i tono n iɗika i va̱ ba, ɗa baci i kondoi, ci ta̱ a̱ kuta̱ tsu lyaꞋa ɗa̱ n kuvon.>> ");
INSERT INTO asg_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ɗa aza a Isaraila a danai ni, <<Ci ta̱ o kutono uye u gbayin, ɗa baci vuza te u soꞋi mini ma̱ nu, ko ilikuzuwa i tsu, ci ta̱ a kutsupa. YaꞋan tsu tono n ene koci, ɗaɗa i na tsa kuyaꞋan.>> ");
INSERT INTO asg_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ɗa kpamu o doku a danai, <<Ka̱ta̱ i tono punu ba.>> Ɗa aza a Edom uta̱i n ka̱bunda̱i ko osoji n aza a utsura adama a na a̱ shilika̱ n ele. ");
INSERT INTO asg_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ana aza a Edom a̱ sa̱nka̱i le uye wu nwalu punu a iɗika i le, ɗa a kpatalai o tonoi uye u yoku. ");
INSERT INTO asg_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ɗa aza a Isaraila a̱ ka̱sukpa̱i Kadeshi, ɗa a banai a Kusan ku Horu. ");
INSERT INTO asg_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ɗe a Kusan ku Horu ka, ku na ki ɗevu n kureꞋe ku Edom, ɗa Vuzavaguɗu u danai Musa n Haruna, ");
INSERT INTO asg_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","<<Ayin a yawa ta̱ a na avu Haruna va̱ kukuwa̱. A̱yi wa kuꞋuwa a iɗika i na me kuneke aza a Isaraila ba, adama a na ra̱ka̱ vu ɗa̱ i yaꞋanka mu ta̱ ugbamukaci a̱ ubuta̱ u mini ma Mariba, ");
INSERT INTO asg_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ɗika Haruna m maku ma̱ ni Eliyaza vu kumba gaɗi na a Kusan ku Horu. ");
INSERT INTO asg_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ta ɗe va kufoɗo kuminya ku Haruna ka̱ta̱ vu uka maku ma̱ ni Eliyaza. Adama a na Haruna wi ta̱ a̱ kukuwa̱ ɗe.>> ");
INSERT INTO asg_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ɗa Musa u yaꞋin uteku tsu na Vuzavaguɗu u danai. Ɗa a kumbai a Kusan ku Horu a̱ a̱shi o koɓolo ka uma. ");
INSERT INTO asg_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ɗa Musa u foɗoi aminya a Haruna ɗa u ukai maku ma̱ ni Eliyaza. Ɗa Haruna u kuwa̱i ɗe a gaɗi vu Kusan va. Ɗa Musa n Eliyaza a̱ cipa̱i a Kusan ka, ");
INSERT INTO asg_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ana uma a panai a danai Haruna u kuwa̱ ta̱, ɗa a yaꞋin kpalu ku ni ali ayin kamangankupa. ");
INSERT INTO asg_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ana vuza va aza a KanaꞋana, mogono ma Aradu ma na mi ida̱shi a iɗika i Negebu, u panai aza a Isaraila i ta̱ lo a̱ kuta̱wa̱ n uye u Atarimu, ɗa wu uta̱i u shilika̱i n ele, u remei aza o yoku a kubana ugbashi. ");
INSERT INTO asg_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ɗa aza a Isaraila a kucinai n Vuzavaguɗu a danai, <<Vi baci e kuneke uma a nampa e ekiye a̱ tsu, ci ta̱ a kuna likuci i le ra̱ka̱.>> ");
INSERT INTO asg_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ɗa Vuzavaguɗu u panai ufolu wa aza a Isaraila ɗa u nekei le aza a KanaꞋana e ekiye le, ɗa a unai le n likuci i le ra̱ka̱. Ɗa e neꞋi ubuta̱ wa kula Horuma. ");
INSERT INTO asg_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ɗaɗa aza a Isaraila a̱ ɗa̱nga̱i a Kusan ku Horu, o tonoi n uye u mala ma shili, a̱ ka̱ra̱Ꞌa̱ n iɗika i Edom. Ana i a nwalu ɗa a̱ kpa̱ɗa̱i kugbama asuvu. ");
INSERT INTO asg_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Uma a yaꞋankai Ka̱shile mololo m Musa, a danai, <<Yiɗa̱i i zuwai vu utuka̱i tsu a Masar tsu kuwa̱ punu a kakamba? Ubuta̱ u na ko ilikulya ko mini, mana ilikulya i gbani i nampa, tso oꞋwo ta̱ n vu ɗa!>> ");
INSERT INTO asg_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ɗa Vuzavaguɗu u suki n oko o tsukono a̱ ka̱tsuma̱ ka aza a Isaraila, a kapai le, uma a̱ a̱bunda̱i a aza a Isaraila a̱ kuwa̱i. ");
INSERT INTO asg_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Uma a̱ ta̱wa̱i u Musa a danai, <<Tsu nusa ta̱, adama a na ci yaꞋanka ta̱ Vuzavaguɗu mololo n avu. Folono Vuzavaguɗu, u takpaka tsu oko a.>> Ɗa Musa u yaꞋin avasa adama a uma. ");
INSERT INTO asg_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa u danai, <<Yima koko ka̱ viyum ka na ki n tsukono ka̱ta̱ vu shiya kaꞋa a gaɗi vu maɗanga, vuza na baci koko ka kapai dem, ɗa wi indanai koko ka̱ nu, wi ta̱ a kulaꞋa.>> ");
INSERT INTO asg_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ɗaɗa Musa u yaꞋin koko n iyum i shili, ɗa u saki gaɗi vu maɗanga. Koko ka luma baci vuza, vuza va wi ta̱ a̱ kula̱nuku koko ka ka̱ta̱ ta na u laꞋaka n wuma. ");
INSERT INTO asg_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ɗa aza Isaraila a̱ ɗa̱nga̱i a̱ ka̱na̱i uye a banai a̱ da̱sa̱ngi a Obatu. ");
INSERT INTO asg_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ɗa a̱ ɗa̱nga̱i a Obatu, a banai a̱ da̱sa̱ngi agali a Abarim, a kakamba ka na ki a kinda Mowabu, a kubana gaɗi vu uɓon u na kanna ka̱ tsu uta̱. ");
INSERT INTO asg_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","A̱ ubuta̱ wa ɗe ɗa a̱ ɗa̱nga̱i a banai a̱ da̱sa̱ngi a̱ ka̱ɗa̱ki ka Zaredu. ");
INSERT INTO asg_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ɗe kpamu a̱ ɗa̱nga̱i a banai a̱ da̱sa̱ngi u ukambu u Aruno, u na wi a kakamba ka na ka yawai e kureꞋe ka aza a Amoriya, kuyene ku Aruno ɗa kureꞋe ka aza a Mowabu, uteku wi iɗika i Mowabu n iɗika i Amoriya, ");
INSERT INTO asg_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Adama a nannai i ɗaɗa i zuwai ɗa Katagarda ka Arabali o kuvon ku Vuzavaguɗu, ka danai, <<Likuci i Wehabu i na yi a uɓon u Sufa, a̱ ka̱ra̱Ꞌa̱ ke kuyene ku Aruno, ");
INSERT INTO asg_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ka̱gida̱la̱u ka̱ a̱ra̱Ꞌa̱ a na a banai e kuyene ku Aru, a na o tonoi e kureꞋe ku likuci i Mowabu.>> ");
INSERT INTO asg_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","A̱ ubuta̱ wa lo ɗa a lyaꞋi kelime a kubana a Biya, kayinva ka na Vuzavaguɗu u danai Musa, <<Ɓolongu uma a̱ ubuta̱ u te mi ta̱ e kuneke le mini.>> ");
INSERT INTO asg_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ɗa aza a Isaraila a cananai vishipa vu nampa, <<Avu kayinva, tuka̱ m mini, a̱ tsu ci ta̱ a kucanana ka yi vishipa, ");
INSERT INTO asg_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","kayinva ka na anan ganu a̱ ga̱va̱i, ka na aza a gbagbaꞋin a̱ ga̱va̱i Ka na aza a gbagbaꞋin a̱ ga̱va̱i n alangu o tsugono e le n alangu a nwalu e le.>> A̱ ubuta̱ wa lo a kakamba ka, a lazai a kubana a kakamba ka Matana, ");
INSERT INTO asg_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Ɗa a lazai a Matana a kubana Nahaliyelu, a̱ ka̱sukpa̱i kpamu Nahaliyelu a kubana a Bamotu, ");
INSERT INTO asg_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","a lazai a Bamotu a kubana a̱ ka̱ɗa̱ki ka Mowabu a̱ ubuta̱ u na a kufuɗa kene gaɗi ka̱u vu kaginda ka Pisiga ka na ki a kinda keteshe. ");
INSERT INTO asg_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Aza a Isaraila a̱ suki alingata a kubana u Sihon mogono ma Amoriya, a danai, ");
INSERT INTO asg_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","<<Tsu folono wu ta̱, vu ka̱sukpa̱ tsu tsu tono n iɗika i nu. Tso kutono a ashina a̱ nu ko a ashina a nɗanga mi itacishi a̱ nu ba, ko tsu soꞋo mini ma kayinva ka̱ nu ba. Ci ta̱ o kutono uye u gbayin koci.>> ");
INSERT INTO asg_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ama Sihon wi a̱ kuka̱sukpa̱ o tono n iɗika i ni ba. Ɗa u ɓolongi uma a̱ ni ra̱ka̱ u banai kuyaꞋan vishili n aza a Isaraila a kakamba, ɗa u cinai le a Jahaza ɗa u kumbai le n kuvon. ");
INSERT INTO asg_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ɗa aza a Isaraila a lyaꞋi ni n kuvon nu utsura u kotokobi, ɗa a isai ubuta̱ wu uka̱ni u ni, ili i na i ɗikai e kuyene ku Aruno a kubana e kuyene ku Jaboku, ɗa a shamgbai uteku wi iɗika i Amona, adama a na a kpada ta̱ uteku wa aza a Amona n utsura mayin. ");
INSERT INTO asg_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Aza a Isaraila a lyaꞋi likuci ya aza a Amoriya ra̱ka̱, ɗa a̱ da̱sa̱ngi punu a̱ likuci ya, a Heshibon, n likuci i kenkeꞋen i ni ra̱ka̱. ");
INSERT INTO asg_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Adama a na Heshibon ɗa likuci I mogono ma aza a Amoriya, vuza na u yaꞋin vishili m mogono ma cau ma Mowabu ɗa wi isai iɗika i ni ra̱ka̱ e ekiye a̱ ni, ali a kubana e kuyene ku Aruno. ");
INSERT INTO asg_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","N nannai ɗa nzuɓi mi ishipa n danai, <<ta̱wa̱i a Heshibon, tsu maꞋasakai, yaꞋan tsu ɗa̱ngusa̱ likuci i Sihon ");
INSERT INTO asg_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Adama a na akina uta̱ ta̱ a Heshibon, kelentsu ka akina kuta̱i a̱ likuci i Sihon, ɗa ka lyaꞋi likuci i Aru i Mowabu, u lyaꞋi aza o tsugono tsu Aruno. ");
INSERT INTO asg_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ili ya atakaci i ɗa a kubana wa̱ ɗa̱, aza Mowabu ka̱ ɗa̱ ka buwa ba, a̱ɗa̱ uma a̱ ka̱ma̱li ka Kemoshi, u bonoko ta̱ muku n ni aza a ilaɗi a laꞋaka n wuma u le, m muku mu nkere feu, aza na wi isai ubuta̱ u kuvon cau, a̱yi Sihon mogono ma aza Amoriya. ");
INSERT INTO asg_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Gogo na tsu una le ta̱, Heshibon u yaꞋan ta̱ wuni ali a kubana Dibon, Tsu una ta̱ Nofa ali a kubana a Medeba.>> ");
INSERT INTO asg_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Aza a Isaraila o yongoi a iɗika ya aza a Amoriya. ");
INSERT INTO asg_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ɗa Musa u suki aza a tsusaki a kubana Jaza, a banai ɗa a lyaꞋi likuci i wawaꞋa i ni n kuvon, ɗa o lokoi aza a Amoriya a na i ɗe a̱ ubuta̱ wa. ");
INSERT INTO asg_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ɗa o bonoi o tonoi n uye u na u banai Bashan, ɗa Ogu mogono ma Bashan wu uta̱i n uma a̱ ni ra̱ka̱ a banai kuyaꞋan kuvon n ele a Edire. ");
INSERT INTO asg_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ɗa Vuzavaguɗu u yaꞋin kadanshi m Musa, <<Ka̱ta̱ vu pana wovon u ni ba, adama na n neke yi ta̱ ekiye a̱ nu, n uma a̱ ni dem, n iɗika i ni. Vi ta̱ a kuyaꞋanka yi tsu na vi yaꞋankai Sihon mogono ma aza a Amoriya, vuza na wi a Heshibon.>> ");
INSERT INTO asg_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ɗa a unai ni m muku n ni n uma a̱ ni dem, babu vuza na u buwai n wuma. Aza Isaraila a isai iɗika i le ya. ");
INSERT INTO asg_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Aza a Isaraila a lazai a kubana e keteshe ka Mowabu a̱ da̱sa̱ngi a uɓon u kuyene ku Urudu n tsu upashi u Jeriko. ");
INSERT INTO asg_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ana Balaku maku ma Ziporu we enei ili i na aza a Isaraila a yaꞋankai aza a Amoriya. ");
INSERT INTO asg_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ɗa aza a Mowabu a̱ rikpa̱i ka̱u adama a̱ ka̱bunda̱i ka uma ka. Ɗa a panai wovon wa aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Aza a Mowabu a danai nkoshi m gba̱ra̱-gba̱ra̱ m Midiya, <<Ka̱bunda̱i ka uma ka nampa ki ta̱ e kupeɗe tsu n iɗika i na yi uka̱ra̱Ꞌi n a̱ tsu, tsu na kobomburon ke tsu peɗe mita̱ e keteshe.>> Ɗa Balaku maku ma Zipo, vuza na wi mogono ma Mowabu a makyan ma nanlo, ");
INSERT INTO asg_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","u suki alingata a kubana u Balam maku ma Biyo e Peto, vuza na wi ɗevu n kuyene a iɗika i uma a Amawu, e ɗekei ɗa a danai, <<Pana, ka̱bunda̱i ka uma ka̱ ta̱wa̱ ta̱ a Masar. A palai ubuta̱ ra̱ka̱ a iɗika ya, ɗa kpamu a̱ da̱sa̱ngi ɗevu nu mpa. ");
INSERT INTO asg_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ta̱wa̱ gogo na, vu yaꞋanka uma a nampa una̱, adama na a laꞋa ta̱ utsura u va̱. U gaꞋan ba mi ta̱ a kufuɗa kulyaꞋa le ka̱ta̱ n loko le a iɗika ya. Adama na n yeve ta̱ vuza na baci vu zuwakai una̱singai wi ta̱ o kokpo nannai, vuza na baci kpamu vi yaꞋankai una̱ ta wo kokpo nannai.>> ");
INSERT INTO asg_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ɗa nkoshi m Mowabu nu nkoshi m Midiya a̱ ɗa̱nga̱i a kubana u Balam n ikebe i kula̱na̱ e ekiye le. Ɗa a danai ni akaka a Balaku. ");
INSERT INTO asg_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ɗa u danai le, <<Asai punu na, mi ta̱ a̱ kushuku, tsu na Vuzavaguɗu u kudana mu.>> Ɗa nkoshi m Mowabu n shamgbai n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","N kayin ka nanlo ɗa Ka̱shile ka̱ ta̱wa̱i u Balam u danai, <<Anan yayi vi koɓolo n ele na lo va?>> ");
INSERT INTO asg_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balam wu ushuki Ka̱shile, <<Balaku maku ma Ziporu, mogono ma Mowabu maꞋa, ma̱ suki le wa̱ va̱ u danai, ");
INSERT INTO asg_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","<Pana, uma a ɗa lo a̱ ta̱wa̱i a̱ uta̱i a Masar, ɗa a palai iɗika ra̱ka̱. Ta̱wa̱ gogo na, vi yaꞋanka le una̱. U gaꞋan ba mi ta̱ a kufuɗa kuyaꞋan vishili n ele ali n loko le a iɗika ya.> >> ");
INSERT INTO asg_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ka̱shile ka danai Balam, <<Vi a kubana koɓolo n ele ba. Vi ta na a kuyaꞋanka uma una̱ ba, adama na i ta̱ n una̱singai.>> ");
INSERT INTO asg_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ana Balam u ɗa̱nga̱i nu usana ɗa u danai nkoshi m gba̱ra̱-gba̱ra̱ m Balaku, <<Bonoi iɗika i ɗa̱, adama a na Vuzavaguɗu u sa̱nka̱ mu ta̱ kulaza n a̱ɗa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ɗa nkoshi m gba̱ra̱-gba̱ra̱ m Mowabu n ɗa̱nga̱i n lazai a kubana u Balaku a danai, <<Balam u iwan ta̱ kuta̱wa̱ n a̱ tsu.>> ");
INSERT INTO asg_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ɗa Balaku u doku u suki nkoshi m gba̱ra̱-gba̱ra̱ n a̱bunda̱i aza na a laꞋi aza a̱ ugiti n tsugbayin. ");
INSERT INTO asg_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","A̱ ta̱wa̱i u Balam a danai ni, <<Balaku maku ma Ziporu u danai, <Ka̱ta̱ ili i yoku i kpada wu kuta̱wa̱ wa̱ va̱ ba. ");
INSERT INTO asg_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Adama a na mi ta̱ e kuneke wu tsugbayin ka̱u, ka̱ta̱ kpamu n yaꞋan ili i na baci vu danai dem. Ta̱wa̱, vu yaꞋanka mu uma a nampa una̱.> >> ");
INSERT INTO asg_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ama ɗa Balam wu ushuki u danai kagbashi ka Balaku, <<Ko ɗa baci Balaku wi e kuneke mu kpaꞋa ku ni tukpa n azurufa n azanariya, mi a kuyaꞋan ili i kenu ko i gbayin i na Vuzavaguɗu Ka̱shile ka̱ va̱ u sa̱nka̱i mu kuyaꞋan ba. ");
INSERT INTO asg_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","A̱ɗa̱ feu, asai punu tsu na aza o yoku a yaꞋin, adama a na n doku m pana ili i na Vuzavaguɗu u kudana mu.>> ");
INSERT INTO asg_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ɗa Ka̱shile ka̱ ta̱wa̱i u Balam n kayin u danai ni, <<A na wo okpoi uma a a̱ ta̱wa̱ ta̱ kuɗeke wu, ɗa̱nga̱, bana koɓolo n ele, ama vi yaꞋan ili i na n danai nu koci.>> ");
INSERT INTO asg_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balam u ɗa̱nga̱i n usana, u foɓusoi majaki ma̱ ni a walakai nu nkoshi ma a kubana a Mowabu. ");
INSERT INTO asg_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ɗa Ka̱shile ka yaꞋin wupa ka̱u a na u banai n ele, ɗa kalingata ka Vuzavaguɗu ka kpadai ni uye, a̱yi a nwalu a majaki ma̱ ni n agbashi ere a na i koɓolo n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ɗa majaki me enei kalingata ka Vuzavaguɗu kashani a uye, n kotokobi utali. Ɗa majaki ma katsukpai uye, u uwai ubuta̱ u teshe. Ɗa Balam u lapai maꞋa u bonokoi a uye. ");
INSERT INTO asg_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ɗa kalingata ka Vuzavaguɗu ka banai ka shamgbai e mere a̱ ubuta̱ u na uye wa u ɓoroi, e mere mu ukanji wa ashina a nɗanga mi itacishi. ");
INSERT INTO asg_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ana majaki me enei kalingata ka Vuzavaguɗu, ɗa u gbaɓarangi kune ku Balam n ukanji wa. Ɗa kpamu u doku lapai ni. ");
INSERT INTO asg_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Kalingata ka Vuzavaguɗu ko doki n kelime u shamgbai a̱ ubuta̱ u na wi ugbaɓarangi, a uɓon u na wi babu ubuta̱ u kukatsukpa a usingai ko a ugula̱. ");
INSERT INTO asg_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ana majaki me enei kalingata ka Vuzavaguɗu, ɗa u vaki. Ɗa wupa u Balam u kula̱i ka̱u, ɗa u lapai majaki ma n kalangu ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ɗa Vuzavaguɗu u ɓa̱yuwa̱i una̱ u majaki wa, u danai Balam, <<Yiɗa̱i n yaꞋankai nu, ali ɗa vu lapai mu kutatsu?>> ");
INSERT INTO asg_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balam u danai majaki, <<Adama a na vu bonokoi mu kalau, ishi baci mi ta̱ n kotokobi e kukiye ku va̱, mi ishi a kuna wu.>> ");
INSERT INTO asg_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ɗa majaki ma danai Balam, <<Mpa majaki ma̱ nu ma ba, ma na vi a kukumbasa ali a̱ kuta̱wa̱ anana ba? N saꞋwa ta̱ ɗe kuyaꞋanka wu nannai?>> Ɗa wu ushuki, <<A̱Ꞌa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ɗa Vuzavaguɗu u ɓa̱yuwa̱i a̱shi a Balam, ɗa we enei kalingata ka Vuzavaguɗu kisani a uye, n kotokobi utali e kukiye ku ni. Ɗa Balam u kuɗa̱ngi sapu u lyaꞋi kayala. ");
INSERT INTO asg_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ɗa kalingata ka Vuzavaguɗu ka danai ni, <<Yiɗa̱i ɗa vu lapai majaki ma̱ nu ali kutatsu? Pana, n ta̱wa̱ ta̱ na adama a na n sa̱nka̱ wu n ka na vi a kuciga kuyaꞋan, ka gaꞋan wa̱ va̱ ba. ");
INSERT INTO asg_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ana majaki ma me enei mu ɗa u katsukpai mu ali kutatsu. Ishi baci u katsukpa mu ba, ana gogo na mu una wu ta̱ ɗe n ka̱sukpa̱ yi n wuma.>> ");
INSERT INTO asg_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ɗa Balam u danai kalingata ka Vuzavaguɗu, <<N nusa ta̱, n yeve an avu ɗa vu kpadai mu uye ba. Gogo na, ka gbani-gbani kaꞋa baci wa̱ nu, mi ta̱ a ku kpatala m bono.>> ");
INSERT INTO asg_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Kalingata ka Vuzavaguɗu ka danai Balam, <<Wala koɓolo n uma a, ama vu dansa ili i na n kudana wu koci.>> Ɗa Balam u lazai nu nkoshi ma a kubana u Balaku. ");
INSERT INTO asg_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ana Balaku u panai Balam wi ta̱ lo uye a̱ kuta̱wa̱, ɗa wu uta̱i kugasa n a̱yi a̱ likuci i Mowabu, a̱ ka̱kina̱ ke kuyene ku Aruno, ɗevu n kureꞋe. ");
INSERT INTO asg_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ɗa Balaku u danai Balam, <<Ashe n suku e ɗeke wu ba? Yiɗa̱i ɗa vu kpa̱ɗa̱i kuta̱wa̱ wa̱ va̱ m makyan ma nanlo? Mi a kufuɗa me neke wu tsugbayin ba?>> ");
INSERT INTO asg_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balam u danai Balaku, <<Pana, n ta̱wa̱ ta̱ wa̱ nu gogo na, mi ta̱ n utsura n dana ili i na n kudana ra̱ka̱? Ama kadanshi ka na Ka̱shile ka zuwai a̱ una̱ u va̱, ka ɗaɗa n kudansa.>> ");
INSERT INTO asg_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ɗa Balam u lazai koɓolo m Balaku, a̱ ta̱wa̱i a̱ likuci i Kiriyatu-huzotu. ");
INSERT INTO asg_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ta ɗe Balaku u yaꞋin alyuka e kuneꞋe ku kanaka m mokyon, u suꞋuki Balam nu nkoshi m gba̱ra̱-gba̱ra̱ n na mi koɓolo n a̱yi. ");
INSERT INTO asg_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","N usana ɗa Balaku u ɗikai Balam u tuka̱i ni a Bamotu-baꞋalu, a̱ ubuta̱ wa ɗe ɗa we enei uɓon u uma a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ɗa Balam u danai Balaku, <<MaꞋaka mu atali alyuka e cindere na, ka̱ta̱ vu tuka̱ mu mbomburon n cindere n a̱giri e cindere feu.>> ");
INSERT INTO asg_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaku u yaꞋin tsu na Balam u danai. Ɗa Balaku m Balam a yaꞋin alyuka a katalikalyuka dem n kobomburon n ka̱giri. ");
INSERT INTO asg_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ɗa Balam u danai Balaku, <<Shamgba ɗevu n ubuta̱ u kuneꞋe ku kusongu ku nu, mpa kpamu mi ta̱ a kulaza, yoku Vuzavaguɗu wi ta̱ a̱ kuta̱wa̱ u gasa nu mpa. Ili i na baci u yotsonki mu mi ta̱ a kudana wu.>> Ɗa u lazai u banai a̱ ubuta̱ u kaginda. ");
INSERT INTO asg_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ka̱shile ka cinai Balam, ɗa Balam u danai ni, <<N gere ta̱ atali alyuka e cindere ɗa n yaꞋankai le kuneꞋe ku kobomburon n ku ka̱giri a katalikalyuka dem.>> ");
INSERT INTO asg_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ɗa Vuzavaguɗu u zuwakai Balam kadanshi una̱ u ni u danai, <<Bono u Balaku, ka̱ta̱ vu dana yi.>> ");
INSERT INTO asg_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ɗa u bonoi wa̱ ni, u cinai ni kisani a̱yi nu nkoshi m gba̱ra̱-gba̱ra̱ m Mowabu dem a̱ ubuta̱ u kuneꞋe ku kusongu ku ni. ");
INSERT INTO asg_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balam ta na u danai ni kadanshi ke kene ka̱ ni, u danai, <<Balaku mogono ma Mowabu wu uta̱ ta̱ nu mpa a Aram ɗa u tuka̱i mu na, na ɗe a nsansa n kasana u danai, <Ta̱wa̱, vi yaꞋanka mu Yakubu una̱, ta̱wa̱, vi yaꞋanka mu aza a Isaraila una̱.> ");
INSERT INTO asg_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nini ɗai n kuyaꞋanka vuza una̱, a na Ka̱shile ka yaꞋankai ni ba? Nini ɗai kpamu n kuyaꞋanka, vuza na Vuzavaguɗu u yaꞋankai una̱ ba? ");
INSERT INTO asg_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","E, na ɗe gaɗi vu katali me ene le ta̱, na ɗe gaɗi vu nsansa me ene le ta̱, aduniyan a ɗa a na i ida̱shi endeꞋen ni, e yeve ta̱ a̱ ciya̱ ta̱ una̱singai u na u laꞋi aduniyan dem. ");
INSERT INTO asg_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yayi u kufuɗa kukece kumaci ku Yakubu? Ka̱bunda̱i ke le an kubuta̱ ki iɗika, ka̱bunda̱i ke le ka laꞋa ta̱ kukece. YaꞋan ukpa̱ u va̱ wo okpo ukpa̱ u mejege, YaꞋan ukocishi u va̱ wo okpo tsu le.>> ");
INSERT INTO asg_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ɗa Balaku u danai Balam, <<Yiɗa̱i vi yaꞋankai mu na? N ɗika wu ta̱ adama a na vi yaꞋanka irala a̱ va̱ una̱, ɗa na, vi yaꞋan ili ba, ɗa kucikpa vu zuwakai le una̱singai.>> ");
INSERT INTO asg_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ɗa wu ushuku ni u danai, <<Kadanshi ka na Vuzavaguɗu u zuwai una̱ u va̱ ka ɗaɗa n kudansa koci ba?>> ");
INSERT INTO asg_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaku u danai ni, <<N folono wu ta̱ ta̱wa̱ tsu bana ubuta̱ u yoku, ubuta̱ u na ve kene le. Vi ta̱ e kene kagimi, ama ve kene le dem ba, ka̱ta̱ vi yaꞋanka mu ele una̱.>> ");
INSERT INTO asg_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ɗa u ɗikai ni a kubana e keteshe ka Zofim, a gaɗi vu Pisiga. U maꞋi atali alyuka e cindere, ɗa u yaꞋin kuneꞋe n kobomburon n ka̱giri a katalikalyuka dem. ");
INSERT INTO asg_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balam u danai Balaku, <<Shamgba punu na a uɓon u kuneꞋe ku kusongu ku nu, mi ta̱ a kubana kucina Vuzavaguɗu na ɗe.>> ");
INSERT INTO asg_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ɗa Vuzavaguɗu u gasai m Balam ɗa u zuwai kadanshi una̱ u ni u danai, <<Bono u Balaku, vu dana yi ili i na n danai nu.>> ");
INSERT INTO asg_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ana Balam u bonoi u Balaku, u cinai ni kisani a uɓon u kuneꞋe ku kusongu, nu nkoshi m gba̱ra̱-gba̱ra̱ m Mowabu koɓolo n a̱yi. Ɗa Balaku we ecei ni, <<Yiɗa̱i Vuzavaguɗu u dansai?>> ");
INSERT INTO asg_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balam u ɗikai kadanshi u tonoi, <<Ɗa̱nga̱, Balaku, vu panaka mu, panaka mu maku ma Ziporu. ");
INSERT INTO asg_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ka̱shile vuma ɗa ba, a na wa yaꞋan aꞋuwa, ko maku ma vuma, a na wa sabaꞋa ka̱ɗu ka̱ ni. U ci yaꞋan ta̱ kadanshi ka̱ta̱ u kpa̱ɗa̱ kushatangu? Ko u yaꞋan uzuwakpani, ka̱ta̱ u kpa̱ɗa̱ ku kushatangu? ");
INSERT INTO asg_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Pana, a dana mu ta̱ n zuwa una̱singai, u vuza na u zuwakai una̱singai, mi ta na a kusabaꞋa ili i na u danai ba. ");
INSERT INTO asg_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","We ene unushi a̱ ubuta̱ u Yakubu ba, we ene atakaci a̱ ubuta̱ wa aza a Isaraila ba. Vuzavaguɗu Ka̱shile ke le wi ta̱ koɓolo n ele, i ta̱ a kudansa n kacaꞋa adama a na a̱yi mogono me le maꞋa. ");
INSERT INTO asg_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ka̱shile ka̱ uta̱ka̱ le ta̱ a Masar, ɗa kpamu wi a̱ kushilika̱ adama e le an kujima. ");
INSERT INTO asg_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Babu tsuboci tsu na tso kudoro Yakubu, babu kpamu nkunu n na n kuyaꞋan tsurala n aza a Isaraila, gogo na uma i ta̱ a kuyaꞋan kadanshi ka aza a Isaraila a dana, <La̱na̱ ili i na Ka̱shile ka yaꞋin!> ");
INSERT INTO asg_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Uma a Isaraila i ta̱ an kawu vu gbayin. A tsu uvuka ba ali a̱ ciya̱ ili i na e remei ɗa unai, ka̱ta̱ o soꞋo mpasa mi ili i na a unai.>> ");
INSERT INTO asg_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaku u danai Balam, <<Ka̱ta̱ vu yaꞋanka le una̱ ba, ka̱ta̱ kpamu vu yaꞋanka le una̱singai ba.>> ");
INSERT INTO asg_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ama ɗa Balam wu ushuki Balaku, <<N dana wu ba, ili na Vuzavaguɗu u danai, I ɗaɗa n kuyaꞋan?>> ");
INSERT INTO asg_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ɗa Balaku mogono u danai Balam, <<Ta̱wa̱ gogo na, mi ta̱ a kuɗika wu a kubana a̱ ubuta̱ u yoku. Yoku ta ɗe Ka̱shile ka kupana uyoꞋo ali u zuwa vi yaꞋanka mu ele una̱.>> ");
INSERT INTO asg_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaku u ɗikai Balam a kubana gaɗi vu kusan ku Piyo, ku na ki a kinda keteshe. ");
INSERT INTO asg_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ɗa Balam u danai Balaku, <<MaꞋaka mu atalilyuka e cindere na ka̱ta̱ vu tuka̱ obomburon e cindere n a̱giri e cindere.>> ");
INSERT INTO asg_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaku u yaꞋin tsu na Balam u danai, u yaꞋin alyuka n kobomburon n ka̱giri a katalikalyuka dem. ");
INSERT INTO asg_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ana Balam we enei u yokpo ta̱ Vuzavaguɗu u zuwaka aza a Isaraila una̱singai, ɗa u kpa̱ɗa̱i kubana kula̱nsa̱ aza o tsuboci, tsu na wi ishi u tsu bana, ɗa u vadalukpai a kinda kakamba. ");
INSERT INTO asg_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ana Balam u ɗa̱ngusa̱i a̱shi a̱ ni ɗa we enei aza a Isaraila a̱ da̱sa̱ngi kumaci-kumaci. Ɗa Ayinviki a̱ Ka̱shile a̱ cipa̱i wa̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ɗa Balam u danai kadanshi ka na wi n kaꞋa. <<Kene ku Balam maku ma Biyo, Kene ku vuza na a̱shi a̱ ni i uɓa̱yuwi, ");
INSERT INTO asg_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Kene ku vuza na u tsu pana kadanshi ka̱ Ka̱shile, vuza na u ci yaꞋan kene ku tsalatani u MalaꞋimili, vuza na wi u kuɗa̱ngi n a̱shi a̱ ni uɓa̱yuwi. ");
INSERT INTO asg_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","A̱ɗa̱ kumaci ku Yakubu a̱pa̱m a̱ ɗa̱ a gaꞋan ta̱, ubuta̱ wi ida̱shi u ɗa̱, wi ta̱ n ugaꞋin. ");
INSERT INTO asg_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","I ta̱ kisani tsu nshuwa, an kashina a̱ ka̱kina̱ ka̱ mini, a na nɗanga n na Vuzavaguɗu u ca̱Ꞌi, a na nɗanga n sida a̱ ka̱kina̱ ka̱ mini. ");
INSERT INTO asg_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","I ta̱ a̱ kuciya̱ mini ma̱ Ka̱shile n a̱bunda̱i, ka̱ta̱ a̱ ca̱Ꞌa̱ icuꞋu i le a̱ ubuta̱ u na mini mi gbani, mogono me le mi ta̱ o kokpo vuza gbayin n Agagu, tsugono ci le ci ta̱ a̱ kuciya̱ tsugbayin. ");
INSERT INTO asg_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ka̱shile ka na ka̱ uta̱ka̱i le a Masar, u tsu shilika̱ ta̱ adama e le tsu kujima, wi ta̱ a kuna uma a na i a tsurala n ele, ka̱ta̱ u koɗoso etele e le miri-miri, ɗa kpamu u tawai le n aya e le. ");
INSERT INTO asg_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Aza a Isaraila i ta̱ tsu kawu vu utsura, wi baci alavu babu vuza na u yawai u ɗa̱ngusa̱ yi. Vuza na u zuwakai Isaraila una̱singai dem, a̱yi feu i ta̱ a kuzuwaka yi, Vuza na baci u yaꞋankai ni una̱ a̱yi feu i ta̱ a kuyaꞋanka yi.>> ");
INSERT INTO asg_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ɗa Balaku u yaꞋin wupa ka̱u adama Balam, ɗa u ɓasai ekiye a̱ ni. Balaku u danai Balam, <<N ɗeke wu ta̱ kutatsu adama na vi yaꞋanka irala a̱ va̱ una̱, ama ɗa vu zuwakai le una̱singai ali kutatsu. ");
INSERT INTO asg_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Adama nannai puwa̱nka̱ punu na vu bono a kpaꞋa, n dana wu ta̱, mi ta̱ e kuneke wu tsugbayin, Ama Vuzavaguɗu u sa̱nka̱ wu ta̱ kuciya̱ tsu ɗa.>> ");
INSERT INTO asg_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balam u danai Balaku, <<Mpa n dana alingata a na vu suki wa̱ va̱ ba? ");
INSERT INTO asg_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","<Ko Balaku wi baci e kuneke mu kpaꞋa ku ni tukpa n azurufa koɓolo n azanariya, mi a kufuɗa kupasa kadanshi ka Vuzavaguɗu ba, ko n yaꞋan kasingai ko ka gbani-gbani n tsu va̱ ba. Ili i na Vuzavaguɗu u danai, i ɗaɗa n kudana.> ");
INSERT INTO asg_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Gogo na, mi ta̱ o kubono ubuta̱ u uma a̱ va̱, ama ka̱ta̱ vu ta̱wa̱ n dana wu ili i na uma a kuyaꞋanka wu a ayin a̱ kuta̱wa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balam u ɗikai kadanshi u danai, <<Kadanshi ke kene ka Balam maku ma Biyo, kene ku vuma vu na a̱shi a̱ ni i uɓa̱yuwi, ");
INSERT INTO asg_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Kene ku vuma vu na u tsu pana kadanshi ka̱ Ka̱shile, a̱yi na wi n kuyeve ku MalaꞋimili, n kuyaꞋan kene tsalatani ku MalaꞋimili, vuza na u tsu kuɗa̱ngu, ka̱ta̱ wi isa akaka a̱shi a̱ ni uɓa̱yuwi. ");
INSERT INTO asg_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mi ta̱ e kene yi, ama gogo na ba, Mi ta̱ e kene yi, ama ɗevu ɗa ba, Kazangata ki ta̱ a̱ kuta̱ a kumaci ku Yakubu. Kalangu ko tsugono ki ta̱ a̱ kuta̱ wa aza a Isaraila, ka̱ta̱ u lapa aza Mowabu, ka̱ta̱ kpamu u koɗoso muku n Shitu. ");
INSERT INTO asg_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","I ta̱ a kulya Edom, Siyaru feu, irala yi Isaraila i ta̱ a kuyaꞋan ulyaꞋi. Ama aza Isaraila i ta̱ a kulyaꞋa kelime n kuyaꞋan utsura. ");
INSERT INTO asg_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","A kumaci ku Yakubu ku ɗa tsugono tsa̱ kuta̱, ka̱ta̱ wu una aza a na a laꞋakai n wuma a̱ likuci i Iru.>> ");
INSERT INTO asg_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ɗa Balam wu indanai aza Ameleki, u yaꞋin kadanshi ke kene u danai, <<Ameleki iɗika i ɗa yi utsura a aduniyan, ama o kukotsoso ku ni ukpa̱ u ɗa.>> ");
INSERT INTO asg_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ɗa wu indanai aza e Kenetu, ɗa u yaꞋin kadanshi ke kene u danai, <<Ubuta̱ wi idashi u ɗa̱ u tsurakpa ta̱, iꞋuwa i ɗa̱ yi ta̱ umaꞋi a kakpanlai. ");
INSERT INTO asg_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","N nannai dem kumaci ku Kenetu ki ta̱ a kuyaꞋan wuni ayin a na baci aza a Asiriya a ɗikai ɗa̱ yo okpoi agbashi e le.>> ");
INSERT INTO asg_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ɗa kpamu u doku u yaꞋin kadanshi ke kene u danai, <<Ili ya atakaci i ɗa, yayi u kulaꞋa ayin a na baci Ka̱shile ka yaꞋin ka nanlo? ");
INSERT INTO asg_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Antsu i ta̱ a̱ kuta̱ a̱ Kitimu, i ta̱ a kutakacika aza Asiriya n Eberu, ele n ka̱ci ke le i ta̱ a̱ kukuwa̱.>> ");
INSERT INTO asg_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ɗa Balam u ɗa̱nga̱i u bonoi a̱ likuci i ni, Balaku tamkpamu u yaꞋin nwalu n ni. ");
INSERT INTO asg_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ana aza Isaraila i ida̱shi a̱ Shitim, ɗa a̱ ka̱na̱i tsugbani nu nkere ma aza a Mowabu. ");
INSERT INTO asg_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Nkere ma a banuki aza a Isaraila a kubana a̱ ubuta̱ u ka̱ɗiva̱ ka alyuka wa̱ a̱ma̱li e le, ɗa uma a Isaraila a̱ kuɗa̱nki a̱ma̱li a. ");
INSERT INTO asg_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ta aza a Isaraila e nekei ka̱ci ke le o kutono a̱ma̱li a Balu vu Piyo. Ɗa Vuzavaguɗu u yaꞋin wupa ka̱u adama aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ɗa Vuzavaguɗu u danai Musa, <<Ɗika aza e kelime a uma a nampa, vu saku le a nɗanga n kanna, a̱ a̱shi a Vuzavaguɗu, adama a na wupa u Vuzavaguɗu wu uta̱ wa aza a Isaraila.>> ");
INSERT INTO asg_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa u danai azafada a Isaraila, <<Mayun ɗa vuza dem wu una uma a̱ ni a na e nekei ka̱ci ke le wa̱ a̱ma̱li a Balu vu Piyo.>> ");
INSERT INTO asg_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ana i lo, ɗa vuza te va aza a Isaraila wu uta̱ka̱i n vuka a Midiya u tuka̱i a̱ ka̱pa̱m ka̱ ni, a̱ a̱shi a Musa n a̱shi a uma a Isaraila ra̱ka̱, a makyan ma na i a̱ ma̱shi a̱ utsutsu u Ma̱va̱li mo Oɓolo. ");
INSERT INTO asg_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ana Finihasu maku ma Eliyaza, matsukaya ma Haruna ganu, we enei nannai, ɗa u ɗa̱nga̱i u ka̱sukpa̱i uma a, u ɗikai masara e kukiye ku ni. ");
INSERT INTO asg_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","U tonoi vuma vi Isaraila va punu a̱ ka̱pa̱m ka, ɗa u sapai aza e re le dem m masara ma, masara ma uwai a̱ ka̱tsuma̱ ka vuza ka ali a kubana ka vuka ka. Ta ukuna u ma̱dukpa̱ u uma a Isaraila u kotsoi nannai. ");
INSERT INTO asg_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","N nannai dem wana ɗai ma̱dukpa̱ ma mu una uma a̱kpa̱n kamanga n a̱na̱shi (24,000). ");
INSERT INTO asg_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","<<Finihasu maku ma Eliyaza, matsukaya ma Haruna ganu, u takpa ta̱ wupa u va̱ u uma a Isaraila, wi ta̱ n cisheꞋe tsu na mpa mi, adama a tsugbayin tsu va̱ we le, i ɗaɗa i zuwai n takpai aza a Isaraila a̱ a̱shi aduniyan a̱ ka̱tsuma̱ ka wupa u va̱ ba. ");
INSERT INTO asg_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Adama a nannai, dana yi mi ta̱ a kuyaꞋanka yi uzuwakpani u ma̱ta̱na̱ ");
INSERT INTO asg_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Uzuwakpani wa wi ta̱ o kokpo a̱yi nu ntsukaya n ni, ɗaɗa uzuwakpani u tsuganu a kubana a makyan dem, adama a na u yaꞋan ta̱ cisheꞋe tsu ucigi u Ka̱shile ka̱ ni ali u takpakai aza a Isaraila unushi le.>> ");
INSERT INTO asg_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Kula ku vuza vi Isaraila vu na a unai koɓolo n vuka vu Midiya va, a̱yi ɗa Zimiri maku ma Salu, vuza kelime a kumaci ku Simiyon. ");
INSERT INTO asg_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Kula ku vuka va aza a Midiya vu na a unai, a̱yi ɗa Kozibi mekere ma Zura, vuza kelime vu kumaci ku yoku a Midiya. ");
INSERT INTO asg_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Vuzavaguɗu u yaꞋin kadanshi m Musa, u danai, ");
INSERT INTO asg_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","<<Banka aza Midiya n kuvon ali vu una le, ");
INSERT INTO asg_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Adama a ili i gbani-gbani i na a yaꞋankai ɗa̱, ana o doroi ɗa̱ a Piyo, n ukuna u Kozibi, mekere ma vuza kelime a Midiya, vuza na a unai a kanna ka̱ ma̱dukpa̱ o Piyo.>> ");
INSERT INTO asg_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ana ma̱dukpa̱ mo kotsoi, Vuzavaguɗu u danai Musa n Eliyaza maku ma Haruna, ganu. ");
INSERT INTO asg_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","<<Kece uma a Isaraila aza na a̱ya̱ e le a yawai kamanga n kapashi, tsu na i e cisheku ci le dem, aza na a kufuɗa kubana kuvon.>> ");
INSERT INTO asg_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ɗa Musa n Eliyaza ganu a yaꞋin kadanshi n uma a Isaraila e meremune ma Mowabu a uɓon u kuyene ku Urudu a upashi u Jeriko, a danai, ");
INSERT INTO asg_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","<<Kece ali aza a na a̱ya̱ e le a yawai kamanga n kapashi, tsu na Vuzavaguɗu u danai Musa.>> Uma a Isaraila a na a̱ uta̱i a Masar ele ɗa: ");
INSERT INTO asg_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, maku mu ugiti ma Yakubu, muku n ali n ni ele ɗa Hanoku, m Palu, ");
INSERT INTO asg_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","n Hezuron n Karimi. ");
INSERT INTO asg_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Na ɗa kumaci ku Ruben. Ka̱bunda̱i ke le ka yawa ta̱ a̱kpa̱n amangere n a tatsu n amangatawencindere n kamangankupa (43, 730). ");
INSERT INTO asg_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Maku ma Palu a̱yi ɗa Eliyabu. ");
INSERT INTO asg_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Muku n Eliyabu ele ɗa, Nemuwelu, Datan, n Abiram. Datan n Abiram va ele ɗa aza a gbagbaꞋin a Isaraila a na a yaꞋankai Musa n Haruna ugbamukaci, i ta̱ a̱ ka̱tsuma̱ ko otoni a Kora, a na a yaꞋankai Vuzavaguɗu ugbamukaci. ");
INSERT INTO asg_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ɗa iɗika i ɓa̱yuwa̱i una̱ ɗa i soɗongi le koɓolo n Kora, koɓolo ka nanlo ka ka̱ kuwa̱ ta̱, ana akina o songi uma amangatawenre n amangerenkupa (250), ɗa o okpoi urotu a̱ ubuta̱ u uma a na a buwai. ");
INSERT INTO asg_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ama muku n Kora a̱ kuwa̱ ba. ");
INSERT INTO asg_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Muku n ali n Simiyon ele ɗa, Nemuwelu, n Jamin n Jaki, ");
INSERT INTO asg_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","n Zera n Shawu, ele ɗa kumaci ku Simiyon. ");
INSERT INTO asg_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Na ɗa ka̱bunda̱i ka kumaci ka aza a Simiyon, ele a̱kpa̱n kamanga n ere n amangatawenre (22, 200) ");
INSERT INTO asg_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Muku n ali n Gadu kumaci ku le ku ɗa, Zefon, n Hagi, n Shuni, ");
INSERT INTO asg_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","koɓolo n Ozini, n Eri, ");
INSERT INTO asg_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","n Arodu n Areli. ");
INSERT INTO asg_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Na ɗa kumaci ku muku n ali n Gadu. Ka̱bunda̱i ke le ka yawa ta̱ a̱kpa̱n amangere n amangatawantawun (40, 500). ");
INSERT INTO asg_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Muku n ali n Yahuza ele ɗa Eri n Ona, a̱yi Eri n Ona a̱ kuwa̱ ta̱ a iɗika i KanaꞋana. ");
INSERT INTO asg_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Kagimi ka̱ muku n ali n Yahuza kumaci ku le ku ɗa, Shela, m Pereza, koɓolo n Zera. ");
INSERT INTO asg_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Muku n ali m Pereza ele ɗa, Hezuron, n Hamulu. ");
INSERT INTO asg_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Na ɗa kumaci ku Yahuza tsu na i ukeci, ele ɗa a̱kpa̱n amangatatsunkupa n a̱ ta̱li n amangatawantawun, (76, 500). ");
INSERT INTO asg_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Muku n ali n Isaka kumaci ku le ku ɗa, Tola, m Puwa, ");
INSERT INTO asg_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","n Jashubu koɓolo n Shimiron. ");
INSERT INTO asg_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Na ɗa kumaci ku Isaka tsu na i ukeci, ka̱bunda̱i ke le kaꞋa a̱kpa̱n amangatatsu n a̱ na̱shi n amangatawantatsu (64, 300). ");
INSERT INTO asg_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Muku n ali n Zabalun, kumaci ku le ku ɗa, Seredu, n Elon koɓolo n Jahile. ");
INSERT INTO asg_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Na ɗa kumaci ka aza a Zabalun tsu na i ukeci, ka̱bunda̱i ka ɗaɗa a̱kpa̱n amangatatsu n amangatawantawun (60, 500). ");
INSERT INTO asg_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Muku n ali n Isufu kumaci ku le ku ɗa, Manasa n Ifirayimu. ");
INSERT INTO asg_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Muku n ali m Manasa ele ɗa Makiri, Makiri ɗa esheku a Giliyadu a̱yi na wo okpoi akaya a kumaci ku Giliyadu, ");
INSERT INTO asg_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Muku n ali n Giliyadu ele ɗa, Izaru, n Heleki, ");
INSERT INTO asg_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","n Asiriyelu, koɓolon n Shekem, ");
INSERT INTO asg_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","n Shemida koɓolo n Hefa. ");
INSERT INTO asg_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofahadu maku ma Hefa wi m muku mo olobo ba, ama wi ta̱ ni nkere. Ula a nkere n Zelofahadu a ɗaɗa Mahala, Nowa, Hogula, Milika, koɓolon n Tiraza. ");
INSERT INTO asg_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Na ɗa kumaci ku Manasa. Ka̱bunda̱i ke le ka yawa ta̱ a̱kpa̱n amangerenkupa n ere n amangatawencindere (52, 700). ");
INSERT INTO asg_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Na ɗa muku n ali n Ifirayimu tsu na kumaci ku le ki, ele ɗa Shutela, m Beka, koɓolo n Tahan. ");
INSERT INTO asg_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Eran ɗa maku ma Shutela. ");
INSERT INTO asg_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Na ɗa kumaci ku Ifirayimu, tsu na i ukeci, ele ɗa a̱kpa̱n kamangankupa n e re n amangatawantawun (32, 500). Na ɗa kumaci ku Isufu. ");
INSERT INTO asg_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Muku m Bayami, tsu na i a kumaci ku le, ele ɗa Bela, n Ashibelu, koɓolo n Ahiram, ");
INSERT INTO asg_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","n Shufam n Hufam. ");
INSERT INTO asg_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Na ɗa muku m Bela n kumaci ku le, Arudu n NaꞋaman. ");
INSERT INTO asg_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Na ɗa tamkpamu muku n Bayami n kumaci ku le, i ta̱ ukeci uma a̱kpa̱n amangere n a tawun n amangatawa̱nta̱li (45, 600). ");
INSERT INTO asg_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ele na ɗa kumaci ku Dan m muku n le: Shuham, ele ɗa kumaci ku Dan. ");
INSERT INTO asg_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ka̱bunda̱i ke le ka yawa ta̱ a̱kpa̱n amangatatsu n a̱ na̱shi n amangatawa̱na̱shi (64, 400). ");
INSERT INTO asg_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Kumaci ku Ashera tsu na i e kefeku ke le ele ɗa, Imuna n Ishivi, koɓolo n Beriya. ");
INSERT INTO asg_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Muku n ali m Beriya ele ɗa Heberu m Malikiyelu. ");
INSERT INTO asg_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ashera wi ta̱ m mekere kula ku ni Shera ");
INSERT INTO asg_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Na ɗa kumaci ku Ashera tsu na i ukeci, ka̱bunda̱i ke le ka yawa ta̱ uma a̱kpa̱n amangerenkupa n a tatsu n amangatawa̱na̱shi (53, 400). ");
INSERT INTO asg_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Kumaci ku Nafutali ku ɗa na tsu na i m muku n le, Jazilu n Guni, ");
INSERT INTO asg_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","n Jeza, n Shilem. ");
INSERT INTO asg_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Na ɗa uteku u kumaci ku Nafutali. Ka̱bunda̱i ke le ka yawa ta̱ uma a̱kpa̱n amangere n a tawun n amangatawa̱na̱shi (45, 400). ");
INSERT INTO asg_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ka̱bunda̱i ka uma a Isaraila aza na e kecei, uma a̱kpa̱n amangatawa̱nta̱li n ke te n amangatawencindere n kamangankupa (601, 730). ");
INSERT INTO asg_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ka̱shile ka danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","e peceke uma a iɗika ya tsu ili yi uka̱ni tsu ka̱bunda̱i ka kumaci ke le. ");
INSERT INTO asg_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Vi ta̱ e kuneke kumaci ka̱ a̱bunda̱i upecu u gbayin, kumaci ku kenu e neke yi upecu u kenu. Kumaci dem i ta̱ e kuneke yi tsu ka̱bunda̱i ka̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ama e kupecuku le ta̱ iɗika ya n kazagba a kumaci dem. ");
INSERT INTO asg_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","N kazagba kaꞋa e kupecuku iɗika yi uka̱ni ya a̱ ka̱tsuma̱ ka kumaci ku gbagbaꞋin n ku kenkeꞋen. ");
INSERT INTO asg_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Na ɗa aza e Levi a na e kecei tsu kumaci ku le, Geshon; n Kohatu, m Merari. ");
INSERT INTO asg_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Muku ma aza e Levi n na m buwai a kumaci ka aza a Libini ele ɗa, Heburon, m Mahali, m Mushi, n Kora. Kohatu ɗa u matsai Amuram, ");
INSERT INTO asg_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","vuza na u zuwai Jocebe mekere ma Levi vuza na a matsakai ni a Masar. Jocebe u matsakai Amuram Haruna, Musa, n Miriyamu taku vu le. ");
INSERT INTO asg_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haruna wi ta̱ m muku m ali n na̱shi, Nadabu, n Abihu, n Eliza, n Itama. ");
INSERT INTO asg_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ama Nadabu n Abihu a̱ kuwa̱ ta̱ adama na a yaꞋanka ta̱ Vuzavaguɗu kuneꞋe ka akina ku na ku gaꞋin ba. ");
INSERT INTO asg_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ali a na e kecei a̱ kugita̱ vuza na wi wotoi u te n umaci a kubana gaɗi, a yawa ta̱ a̱kpa̱n kamanga n a tatsu (23,000). O ɓolongu le ra̱ka̱ n aza a Isaraila ba, a na wo okpoi e neke le upecu wu uka̱ni u le ba. ");
INSERT INTO asg_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Na ɗa ali a na Musa n Eliza ganu e kecei a makyan ma na a yaꞋin mekecu ma aza a Isaraila e keteshe ka Mowabu, a kasana ke Kuyene ku Urudu n tsu upashi u Jeriko. ");
INSERT INTO asg_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ama a̱ ka̱tsuma̱ ka aza na e kecei, babu vuza na wi a̱ ka̱tsuma̱ ke mekecu mu ugiti ma na Musa n Haruna ganu a yaꞋin, ana e kecei aza a Isaraila a kakamba ka Sinai. ");
INSERT INTO asg_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Adama na Vuzavaguɗu u yaꞋan ta̱ ɗe kadanshi ke le, <<U danai a kakamba kaꞋa a̱ kukuwa̱.>> Babu vuza te vu na u buwai a̱ ka̱tsuma̱ ke le, Kelepu ɗa maku ma Jefune, n Jesuwa maku ma Nun. ");
INSERT INTO asg_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Kanna ke te ɗa nkere n Zelofahadu maku ma Hefa, Hefa maku ma Giliyadu, Giliyadu maku ma Makiri, Makiri maku ma Manasa vuza na wu uta̱i a kumaci ku Isufu, a banai ufolu. Ula a nkere a ɗaɗa Mahala, Nowa, Hogula, Milika, koɓolo n Tiraza. ");
INSERT INTO asg_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Nkere ma, a banai a shamgbai e kelime ka Musa n Eliyaza, ganu, nu nkoshi m gba̱ra̱-gba̱ra̱ n koɓolo ka uma ra̱ka̱, a̱ utsutsu u Ma̱va̱li mo Oɓolo, a danai, ");
INSERT INTO asg_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","<<Esheku a̱ tsu a̱ kuwa̱ ta̱ a kakamba, ko a na wo okpoi wi punu a̱ ka̱tsuma̱ ka aza na a yaꞋankai Vuzavaguɗu ugbamukaci a Kora ba, ama u kuwa̱ ta̱ adama a̱ unushi u ni. Wi ta na m muku n ali ba. ");
INSERT INTO asg_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nini ɗai a̱ kuka̱sukpa̱ kula ke esheku a̱ tsu kukuwa̱ adama na wi n muku n ali ba? Nekei tsu upecu wi ili yu uka̱ni ya̱ esheku a̱ tsu a̱ ka̱tsuma̱ ka̱ aza a̱ ni.>> ");
INSERT INTO asg_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa u tonokoi Vuzavaguɗu ma̱shi me le. ");
INSERT INTO asg_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ɗa Vuzavaguɗu u danai Musa, ");
INSERT INTO asg_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","<<Kadanshi ka nkere n Zelofahadu derere ɗa kaꞋa ki, neke le ili upecu wi ili yu uka̱ni ye esheku e le a̱ ka̱tsuma̱ ka̱ aza a̱ ni, ka̱ta̱ vu saꞋwaka le upecu wa ekiye e le. ");
INSERT INTO asg_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Vi ta̱ tana a kuyaꞋan kadanshi n aza a Isaraila, vu dana, <Ɗa baci vuza u kuwa̱i wi ta na m maku ma vali ba, yi ta̱ e kuneke mekere ma upecu wi ili yu uka̱ni ye esheku e le. ");
INSERT INTO asg_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ɗa baci ta na wi m mekere ba, yi ta̱ e kuneke upecu wu uka̱ni u ni wa wa aza a wawaꞋa a̱ ni. ");
INSERT INTO asg_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Wi baci ta na n aza a wawaꞋa ba, ka̱ta̱ i neke isheku i ni i keꞋen upecu wu uka̱ni i ni ya. ");
INSERT INTO asg_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ɗa baci kpamu wi n isheku i keꞋen ba, ka̱ta̱ i neke kumaci ku ɗeɗevu n a̱yi upecu wi ili yu uka̱ni i ni ya. N nannai wi ta̱ o kokpo wila̱ wa aza a Isaraila, tsu na Vuzavaguɗu u danai Musa.> >> ");
INSERT INTO asg_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ɗaɗa Vuzavaguɗu u danai Musa, <<Bana gaɗi a kusan ku Abarim ve ene iɗika i na n nekei aza a Isaraila. ");
INSERT INTO asg_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ɗa baci ve enei i ɗa, vi ta̱ a̱ kukuwa̱ tsu vangu vu nu Haruna, ");
INSERT INTO asg_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","adama na vi yaꞋanka mu ta̱ ugbamukaci a kakamba ka Zinu, ana uma a yaꞋin mololo a Mariba, vu kpa̱ɗa̱i ku