﻿USE sofia;
DROP TABLE IF EXISTS sofia.arq_vpl;
CREATE TABLE arq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arq_vpl WRITE;
INSERT INTO arq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","كْتاب آصَل يَسوع المَسيح بَن داوَد بَن إبراهيم. ");
INSERT INTO arq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","إبراهيم جاب إسحاق وإِسحاق جاب يَعقوب ويَعقوب جاب يَهودا وخاوتو، ");
INSERT INTO arq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","يَهودا جاب فارَص وزارَح من تامار وفارَص جاب حَصرون وحَصرون جاب أَرام، ");
INSERT INTO arq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","أَرام جاب عَمّيناداب وعَمّيناداب جاب نَحشون ونَحشون جاب سَلمون، ");
INSERT INTO arq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","سَلمون جاب بوعَز من راحاب وبوعَز جاب عوبيد من راعوت وعوبيد جاب يَسّى، ");
INSERT INTO arq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","يَسّى جاب السَلطان داوَد والسَلطان داوَد جاب سُلَيمان من مَرت أورِيّا، ");
INSERT INTO arq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","سُلَيمان جاب رَحَبعام ورَحَبعام جاب أَبِيّا وأَبِيّا جاب آسا، ");
INSERT INTO arq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","آسا جاب يَهوشافاط ويَهوشافاط جاب يورام ويورام جاب عُزيّا، ");
INSERT INTO arq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","عُزيّا جاب يوتام ويوتام جاب أَحاز وأَحاز جاب حِزقيّا، ");
INSERT INTO arq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","حِزقيّا جاب مَنَسّى ومَنَسّى جاب آمون وآمون جاب يوشَيّا، ");
INSERT INTO arq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","يوشَيّا جاب يَكُنيا وخاوتو في وَقت النَفية لبابَل. ");
INSERT INTO arq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","بَعد النَفية لبابَل، جاب يَكُنيا شَأَلتِئيل وشَأَلتِئيل جاب زَرُبّابَل، ");
INSERT INTO arq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","زَرُبّابَل جاب أَبيهود وأَبيهود جاب أَلياقيم وأَلياقيم جاب عازور، ");
INSERT INTO arq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","عازور جاب صادوق وصادوق جاب أَخيم وأَخيم جاب أَليود، ");
INSERT INTO arq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","أَليود جاب أَليعازَر وأَليعازَر جاب مَتّان ومَتّان جاب يَعقوب، ");
INSERT INTO arq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","يَعقوب جاب يوسَف راجل مَريَم اللي وَلدَت يَسوع اللي يَتسَمّا المَسيح. ");
INSERT INTO arq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","كايَن رْبَعطاشَن جيل من إِبراهيم لداوَد ورْبَعطاشَن جيل من داوَد للنَفية لبابَل، ورْبَعطاشَن جيل من النَفية لبابَل للمَسيح. ");
INSERT INTO arq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","زْيادة يَسوع المَسيح هَكدا كانَت: مَريَم يَمّاه كانَت مخَطوبة ليوسَف. قْبَل ما يْعيشو كيف كيف، لْقات روحها بالجوف بالروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","وكان راجَلها يوسَف راجَل صالَح وما حَبش يَفضَحها، هِمّالا حَب يْبَطَّل معاها فالسَر. ");
INSERT INTO arq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","وكي كان يْخَمَّم في هاد الشي، هاو وين مْلاك من الرَب ضْهَرلو فالمْنام وقاللو: \"يا يوسَف بَن داوَد، ما تْخافْش تاخُد مَريَم مَرتَك خاطَر اللي راهي رافدة بيه الجوف من الروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","رايحة تْزَيَّد وْلَد وأَنتَ تْسَمّيه يَسوع، خاطَر هُوَ اللي يْسَلَّك شَعبو من دْنوبهُم\". ");
INSERT INTO arq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","هاد الشي كامَل صْرا باش يْتَم كْلام الرَب اللي قالو النَبي: ");
INSERT INTO arq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","\"هايلِك العاتَق تَرفَد الجوف وتْزَيَّد وْلَد ويْسَمّيوَه \"عَمّانوئيل\"\"، اللي مَعنَاه \"الله مْعانا\"\". ");
INSERT INTO arq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","كي فْطَن يوسَف من الرْقاد، دار كيما قاللو مْلاك الرَب وأَدّا معاه مَرتو، ");
INSERT INTO arq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","بَصَّح ما دْخَلش عليها حَتّى زَيّدَت وْلَد وسَمّاه يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","بَعد ما زاد يَسوع في بيت لَحم اليَهودِيّة في يامات هيرودَس السَلطان، هام مَجوس من المَشرَق وَصلو لأورشَليم، ");
INSERT INTO arq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","يْقولو: \"وين راه سَلطان اليْهود اللي زاد؟ خاطَر شَفنا النَجمة مْتاعو فالمَشرَق وجينا نَسَّجدولو\". ");
INSERT INTO arq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","كي سْمَع السَلطان هيرودَس، تْقَلَّق، هُوَ وكامَل أورشَليم، ");
INSERT INTO arq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ولَم كامَل رِيّاس رْجال الدين وكُتّاب الشَعب، باش يَعرَف منهُم وين يْزيد المَسيح. ");
INSERT INTO arq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","جاوبوه: \"في بيت لَحم اليَهودِيّة، خاطَر كْتَب عليه النَبي: ");
INSERT INTO arq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","\"وأَنتِ يا بيت لَحم، بْلاد من اليَهودِيّة، ما راكيش كامَل مَهيونة ما بين الرِيّاس مْتاع اليَهودِيّة، خاطَر مَنَّك يَخرُج قايَد، هُوَ اللي يَرعا شَعبي إِسرائيل\"\". ");
INSERT INTO arq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","هِمّالا، عَيَّط هيرودَس للمَجوس فالسَر وتَبَّت مَنهُم على الوَقت الصْحيح اللي بانَت فيه النَجمة، ");
INSERT INTO arq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","وبْعَتهُم لبيت لَحم وقال: \"روحو، وتَبّتو الخْبَر على الصْغير مْليح، وكي تَلقاوَه، قولولي باش أَنا تاني نْروح نَسجَدلو\". ");
INSERT INTO arq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","بَعدما سَمعو واش قال السَلطان، راحو، وهاي وين النَجمة اللي شافوها فالمَشرَق جات تَتمَشا سابقَتهُم حَتّى وَصلَت وحَبسَت فوق المْكان اللي كان فيه الصْغير. ");
INSERT INTO arq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","كي شافو النَجمة، فَرحو المَجوس بَزّاف بَزّاف، ");
INSERT INTO arq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","وكي دَخلو للدار، شافو الصْغير مع مَريَم يَمّاه ورَكعو ساجدينلو، وحَلّو رْزايَمهُم وعْطاولو هْديّات: دْهَب وبْخور وريحة. ");
INSERT INTO arq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ورَجعو لبْلادهُم من طْريق واحَدُخرى بَعدما عَرفو فالمْنام باللي ما لازَمش يْوَلّيو عَند هيرودَس. ");
INSERT INTO arq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","بَعدما راحو المَجوس، ضْهَر مْلاك الرَب ليوسَف فالمْنام يْقول: \"نوض وأَدّي الصْغير ويَمّاه وأَهرَب لمَصَر وأَبْقا تَمّة حَتّى وين نْقولَك، خاطَر هيرودَس رايَح يْحَوَّس على الوْلَد الصْغير باش يَقُّتلو\". ");
INSERT INTO arq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ناض يوسَف وأَدّا الوْلَد الصْغير ويَمّاه فالليل وراح لمَصَر، ");
INSERT INTO arq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","وقْعَد تَمّة حَتّى مات هيرودَس، باش يْتَم كْلام الرَب اللي قالو النَبي: \"عَيَّطت لوْليدي بَرّا من مَصَر\". ");
INSERT INTO arq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","هِمّالا، كي عْرَف هيرودَس باللي المَجوس تْمَسخرو بيه، تْغَشَّش بَزّاف وبْعَت يُقتَل كامَل الدْراري اللي في بيت لَحم وجْوايَهها من عامين للتَحت، على حْساب الوَقت اللي تَبّتو من المَجوس. ");
INSERT INTO arq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","داك الوَقت تْحَقَّق كْلام النَبي إرميا اللي يْقول: ");
INSERT INTO arq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","\"صوت اتَّسمَع فالرامة، بْكا وشَكاية بَزّاف، راحيل تَبكي على وْلادها وما حَبَّتش تَتعَزّا خاطَر ما وَلاّوش كاينين\". ");
INSERT INTO arq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","كي مات هيرودَس، ضْهَر مْلاك الرَب فالمْنام ليوسَف في مَصَر، ");
INSERT INTO arq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","يْقول: \"نوض وأَدّي الوْلَد الصْغير ويَمّاه وروح لبْلاد إِسرائيل خاطَر هَدوك اللي كانو يْحَوّسو يَقُّتلو الوْلَد الصْغير ماتو\". ");
INSERT INTO arq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ناض يوسَف وأَدّا الوْلَد ويَمّاه ودْخَل لبْلاد إِسرائيل. ");
INSERT INTO arq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","بَصَّح كي سْمَع باللي أَرخيلاوَس وَلاّ سَلطان اليَهودِيّة في مْكان باباه هيرودَس، خاف يْروح لتَمّة، وراح لجْوايَه الجْليل على حْساب ما أَتَّوحالو فالمْنام، ");
INSERT INTO arq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","وجا يَسكُن في مْدينة يْسَمّيوها الناصرة، وهَكدا تَم كْلام الأَنبيا: \"رايَح يَتسَمّا ناصري\". ");
INSERT INTO arq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","في هَدوك اليامات، ضْهَر يوحَنّا المَعمَدان يْبَشَّر فالخْلا مْتاع اليَهوديّة، ");
INSERT INTO arq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ويْقول: \"توبو، خاطَر قَرَّب مَلَكوت السْما\" ");
INSERT INTO arq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","يوحَنّا هُوَ اللي هْدَر عليه النَبي إِشعِيا يْقول: \"صوت يْعَيَّط فالخْلا: \"وَجّدو طْريق الرَب، سَلّسو طُرقانو\"\" ");
INSERT INTO arq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","يوحَنّا كانَت عَندو لَبسة مْتاع هْبَر الجْمَل ويْحَزَّم الكْلاوي مْتاعو بسَبتة مْتاع الجَلد، ياكُل الجْراد والعْسَل الحُر. ");
INSERT INTO arq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","كانو يَخُّرجو ليه ناس أورشَليم وكامَل اليَهودِيّة وجْوايَه واد الأُردُن، ");
INSERT INTO arq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","وكان يْعَمَّدهُم في واد الأُردُن وهومَ يْستَعرفو بدْنوبهُم. ");
INSERT INTO arq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","كي شاف فَرّيسيّين وصَدّوقيّين بَزّاف يْجيو باش يْعَمَّدهُم قالَلهُم: \"يا وْلاد اللْفاعي، شْكون وَرّالكُم تَهَّربو من الزْعاف اللي جاي؟ ");
INSERT INTO arq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","بَيّنو فْعال تْليق بالتوبة، ");
INSERT INTO arq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","وما تَحَّسبوش تْقولو في قْلوبكُم: \"عَندنا بابانا إِبراهيم\"، خاطَر نْقولَلكُم باللي الله يَقدَر مَن هاد الحْجَر يْخَرَّج وْلاد لإِبراهيم. ");
INSERT INTO arq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","الفاس راهو نْحَط عَند عْروق السْجَر، كُل سَجرة ما تْجيبش غَلّة مْليحة تْنَقطَع وتَتَّرما فالنار، ");
INSERT INTO arq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","أَنا نْعَمَّدكُم فالما للتوبة، بَصَّح اللي يْجي مورايَ، قْوي عْليَّ وأَنا ما نَستاهَلش نَرفَد سَبّاطو. هُوَ يْعَمَّدكُم فالروح القُدّوس وفالنار، ");
INSERT INTO arq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","شايَد المَدرة في يَدّو، يَفرَز النادَر مْتاعو، ويْلَم القَمح مْتاعو فالمَخزَن، بَصَّح التْبَن يَحَّرقو في نار ما تَطفاش.\" ");
INSERT INTO arq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","داك الساع، جا يَسوع من الجْليل لواد الأَردُن عَند يوحَنّا باش يْعَمّدو، ");
INSERT INTO arq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","يوحَنّا ما قْبَلش وقال: \"أَنا اللي نَسحَق تْعَمَّدني وأَنتَ جيت لعَندي؟\" ");
INSERT INTO arq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","جاوَب يَسوع وقاللو: \"خَلّي دُرك، خاطَر هَكدا اللي يْليق بينا نْديرو بالتْمام كُل صْلاح\" ويوحَنّا خَلاّه. ");
INSERT INTO arq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","كي تْعَمَّد يَسوع، طْلَع تَم تَم من الما، وهاو وين نْحَلَّت على جالو السْما وشاف روح الله هابَط كي الحْمامة وجاي عليه، ");
INSERT INTO arq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","وصوت جاي من السْما يْقول: \"هَدا هُوَ وْليدي الحْبيب اللي هُوَ فَرحتي\". ");
INSERT INTO arq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","أومبَعد، تْڤَوَّد يَسوع بالروح القُدّوس للخْلا باش يْجَرّبو إِبليس. ");
INSERT INTO arq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","وبَعدما صام رَبعين نْهار ورَبعين ليل، مْعَ الأَخَّر جاع. ");
INSERT INTO arq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","أَتدَنّا ليه الغاوي وقاللو: \"إيلا كُنت بْن الله، قول لهاد الحْجَر يْوَلّيو خُبز\" ");
INSERT INTO arq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","جاوبو يَسوع: \"مَكتوب: \"الإِنسان ما يْعيشش بالخُبز بَرك، بَصَّح بكُل كَلمة تُخرَج مَن فُم الله.\"\" ");
INSERT INTO arq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","أومبَعد، أَدّاه إِبليس للمْدينة المْقَدّسة، وحَطّو فوق العْلو مْتاع المَعبَد، ");
INSERT INTO arq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","وقاللو: \"إيلا كُنت بْن الله، أَرمي روحَك للتَحت خاطَر مَكتوب: \"يْوَصّي المَلايكة مْتاعو عليك، ويَرَّفدوك على يَدّيهُم تْعود تَزدَم رَجلَك في حَجرة.\"\" ");
INSERT INTO arq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","قاللو يَسوع: \"مَكتوب تاني: \"ما تْجَرَّبَش الرَب إِلَهَك\"\" ");
INSERT INTO arq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","زاد أَدّاه إِبليس فوق جْبَل عالي بَزّاف ووَرّالو كامَل مَملَكات الدَنيا والمَجد مْتاعهُم، ");
INSERT INTO arq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","وقاللو: \"هاد الحاجات كامَل نَعطيهُملَك لو كان تَركَع ساجَد قُدّامي.\" ");
INSERT INTO arq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","هِمّالا قاللو يَسوع: \"بَعَّد يا شيطان! خاطَر مَكتوب: \"تَسجَد للرَب إِلَهَك وتَعَّبدو غير هُوَ.\"\" ");
INSERT INTO arq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","داك الساع، خَلاّه إِبليس، وجاو مَلايكة عَندو وبْداو يَخَّدموه. ");
INSERT INTO arq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","كي سْمَع يَسوع باللي أَدّاو يوحَنّا المَعمَدان للحَبس، راح للجْليل. ");
INSERT INTO arq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","خَلاّ الناصرة وسْكَن في كَفرناحوم اللي جايّة عَند البْحَر في بْلاد زَبولون ونَفتاليم، ");
INSERT INTO arq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","باش يْتَم كْلام النَبي إِشعِيا اللي قال: ");
INSERT INTO arq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","\"بْلاد زَبولون وبْلاد نَفتاليم، طْريق البْحَر، البْلاد اللي مور واد الأُردُن، الجْليل اللي يَسَّكنوها اللي ماشي يْهود، ");
INSERT INTO arq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","الشَعب القاعَد فالضَلمة شاف نور كْبير، والقاعدين في بْلاد الموت وضَلّها، شْرَق عْليهم نور.\" ");
INSERT INTO arq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","من داك الوَقت، بْدا يَسوع يْبَرَّح ويْقول: \"توبو خاطَر مَلَكوت السْما قَرَّب.\" ");
INSERT INTO arq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","كي كان يَسوع ماشي على شَط بْحَر الجْليل، شاف زوج خاوة، سَمعان اللي يْعَيّطولو بُطرُس وخوه أَندراوَس، يَرميو شَبكة فالبْحَر خاطَر كانو صِيّادين، ");
INSERT INTO arq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","وقالَلهُم: \"تَبّعوني ونْرَجَّعكُم تْصَيّدو الناس\" ");
INSERT INTO arq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","تَم تَم، خَلاّو الشْبَك وتَبّعوه. ");
INSERT INTO arq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","زاد بَعَّد من تَم وشاف زوج خاوة واحَدُخرين، يَعقوب بَن زَبَدي وخوه يوحَنّا، فالفْلوكة مع باباهُم زَبَدي يْرَقّعو فالشْبَك مْتاعهُم وعَيَّطَلهُم. ");
INSERT INTO arq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","تَم تَم خَلاّو الفْلوكة وباباهُم وتَبّعوه. ");
INSERT INTO arq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","أومبَعد، راح يَسوع يْطَوَّف كامَل الجْليل، يْدَرَّس في مْجامَعهُم ويْبَرَّح ببْشارة المَلَكوت ويَشفي كُل مَرض وكُل عيب فالشَعب. ");
INSERT INTO arq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","وْصَل خَبرو لكامَل سورِية، وجابولو كامَل المَرضى اللي عَندهُم مَرض وَلاّ وْجاع مَن كُل نوع، المَسكونين، واللي عَندهُم الصْريع والمَشلولين وشفاهُم. ");
INSERT INTO arq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","وراح معاه غاشي كْبير جاي من الجْليل والعَشرمدايَن وأورشَليم واليَهودِيّة ومور واد الأُردُن. ");
INSERT INTO arq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","كي شاف يَسوع الغاشي، طْلَع للجْبَل. وكي قْعَد، أَدَّناو ليه التابعين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","وبَدا يْدَرَّس فيهُم وقال: ");
INSERT INTO arq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","\"يا سَعد الڤْلالين فالروح خاطَر مَلَكوت السْما ليهُم. ");
INSERT INTO arq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","يا سَعد الحْزانى خاطَر رايحين يَتعَزّاو. ");
INSERT INTO arq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","يا سَعد الحْنان خاطَر رايحين يَوَّرتو الأَرض. ");
INSERT INTO arq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","يا سَعد الجيعانين والعَطشانين للصْلاح، خاطَر رايحين يَشَّبعو، ");
INSERT INTO arq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","يا سَعد الرُحَما خاطَر رايحين يْنالو الرَحمة، ");
INSERT INTO arq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","يا سَعد اللي قَلبهُم صافي خاطَر رايحين يْشوفو الله، ");
INSERT INTO arq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","يا سَعد اللي يْسَبّبو السْلام خاطَر رايحين يَتسَمّاو \"وْلاد الله\"، ");
INSERT INTO arq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","يا سَعد اللي راهُم مَحڤورين على جال الصْلاح، خاطَر مَلكوت السْما ليهُم، ");
INSERT INTO arq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","يا سَعدكُم كُل ما يْعايروكُم ويَحَّڤروكُم، ويْقولو عليكُم بالكْدَب كُل دوني على جالي، ");
INSERT INTO arq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","أَفَّرحو وأَسَّعدو خاطَر آجَركُم كْبير فالسْما، خاطَر هَكدا حَڤرو الأَنبيا اللي كانو قْبَلكُم. ");
INSERT INTO arq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","أَنتومَ المَلح مْتاع الأَرض، لو كان المَلح يْوَلّي بلا بَنّة، باش يَتمَلَّح؟ ما يْزيد يَصلَح لحَتّى شي، غير يَتَّرما بَرّا ويَعَّفسوه الناس. ");
INSERT INTO arq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","أَنتومَ نور الدَنيا. مْدينة جايّة فوق جْبَل ما تَقدَرش تَتخَبّا، ");
INSERT INTO arq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ما يَشَّعلوش شَمعة ويْحَطّوها تَحت ماعون، يْحَطّوها فالشَندال وتْضَوّي على كامَل اللي فالدار. ");
INSERT INTO arq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","هَكدا لازَم يْضَوّي نوركُم قُدّام الناس، باش يْشوفو فْعالكُم المْلاح ويْسَبّحو باباكُم اللي فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ما تَحَّسبوش باللي جيت باش نْهَد الشَريعة وَلاّ كْلام الأَنبيا. ما جيتش نْهَد، جيت نْكَمّل. ");
INSERT INTO arq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","خاطَر نْقولَلكُم الصَح، قْبَل ما تْزول السْما والأَرض، ما رايَح يْزول حَتّى حَرف وَلاّ نُقطة من الشَريعة، حَتّى يَصرا كُل شي. ");
INSERT INTO arq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","على هَدا، لو كان واحَد يْنَحّي واحدة من هاد الفْرايَض الصْغار ويْعَلَّم الناس يْديرو هَكدا، رايَح يَتسَمّا الصْغير في مَلَكوت السْما، بَصَّح اللي يْطَبَّق ويْعَلَّم، هَداك رايَح يَتسَمّا كْبير في مَلَكوت السْما. ");
INSERT INTO arq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","راني نْقولَلكُم باللي، لو كان ما يْزيدش صْلاحكُم على صْلاح الكُتّاب والفَرّيسِيّين، ما تَدُّخلوش لمَلَكوت السْما. ");
INSERT INTO arq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","سْمَعتو باللي تْقال للقْدَم: \"ما تُقتَلش، واللي يُقتَل يَستاهَل يْجوز فالشْرَع\" ");
INSERT INTO arq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","بَصَّح أَنا نْقولَلكُم، كُل واحَد يَتغَشَّش على خوه يَستاهَل يْجوز فالشْرَع، واللي يْقول لخوه: \"يا الجايَح\"، يَستاهَل يْجوز فالمَجلَس الديني، واللي يْقول: \"مَهبول\"، يَستاهَل نار جَهنَّمة. ");
INSERT INTO arq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","هِمّالا، إيلا جيت تْمَد الهِبة مْتاعَك على المَدبَح وتْفَكَّرت باللي خوك يْسال حاجة عَندَك، ");
INSERT INTO arq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","خَلّي تَمّة الهِبة مْتاعَك قُدَّام المَدبَح، وروح قْبَل أَتصالَح مع خوك، داك الساع أَرواح وقَدَّم الهِبة مْتاعَك. ");
INSERT INTO arq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","أَتصالَح بالخَف مع عْدوك، كي تْكون مازالَك معاه فالطْريق، يْعود يْسَلّمَك العْدو للقاضي، والقاضي يْسَلّمَك للشُرطي وتَتَّرما فالحَبس. ");
INSERT INTO arq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","نْقولَك الصَح، ما تُخرَجش من تَمّة حَتّى تْخَلَّص الصوردي الأَخّراني. ");
INSERT INTO arq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","سْمَعتو باللي تْقال: \"ما تَزنيش\"، ");
INSERT INTO arq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","بَصَّح أَنا نقولَلكُم: كُل واحَد يْشوف مْرا باش يْتشَهّاها، راهو زْنا معاها في قَلبو. ");
INSERT INTO arq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","وَلاّ كانَت عينَك اليْمنى تْعَتّرَك، قَلَّعها وأَرميها بْعيد عليك، خاطَر تَنهلَك حاجة من داتَك خير لَك من اللي تَتَّرما داتَك كامَلة في جَهَنَّمة. ");
INSERT INTO arq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","وَلاّ كانَت يَدَّك اليْمنى تْعَتّرَك، قَطَّعها وأَرميها بْعيد عليك، خاطَر تْنَهلَك حاجة من داتَك خير لَك من اللي تْروح داتَك كامَلة لجَهَنَّمة. ");
INSERT INTO arq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","وتْقال: \"اللي يْحَاوَز مَرتو، لازَم يَعطيها وَرقة الطْلاق\". ");
INSERT INTO arq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","بَصَّح أَنا نْقولَلكُم باللي كُل واحَد يْحَاوَز مَرتو على سَبّة من غير الفَسق، يَتسَبَّبلها باش تَزني، واللي يَتزَوَّج بواحدة مْطَلّقة، راه يَزني. ");
INSERT INTO arq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","وسْمَعتو تاني باللي تْقال للقْدَم: \"ما تَحنَتش اليْمين، ولازَم تْوَفّي بيْمينَك للرَب\"، ");
INSERT INTO arq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","بَصَّح أَنا نْقولَلكُم: ما تَحَّلفوش كامَل، لا بالسْما خاطَر هيَّ عَرش الله، ");
INSERT INTO arq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","لا بالأَرض خاطَر عليها يْحَطّ رَجليه، لا بأورشَليم، خاطَر هيَّ مْدينة السَلطان الكْبير. ");
INSERT INTO arq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ما تَحلَفش براسَك خاطَر ما تَقدَرش تْرَجَّع شَعرة واحدة بيضة ولاَّ كَحلة. ");
INSERT INTO arq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","لازَم يْكون كْلامكُم إيه، إيه، لالا، لالا، الزْيادة على هَدا من الدوني. ");
INSERT INTO arq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","سْمَعتو باللي تْقال: \"عين بعين وسَنّة بسَنّة\"، ");
INSERT INTO arq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","بَصَّح أَنا نْقولَلكُم ما تْقاوموش المَشرار، بَصَّح اللي يْسَقّلَك على خَدَّك اليْمين، وَرّيلو الخَد الآخُر تاني. ");
INSERT INTO arq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","اللي يْحَب يَدّيك للشْرَع باش يَدّيلَك جَلاّبتَك، خَلّيلو البَرنوس تاني، ");
INSERT INTO arq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","واللي يَطلَب منَّك تَمشي معاه مْية مِترة، أَمشي معاه ميتين، ");
INSERT INTO arq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","اللي يَطلَب منَّك أَعطيه،وما تْرَدش اللي يْحَب يْسَلَّف مَنَّك. ");
INSERT INTO arq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","سْمَعتو باللي تْقال: \"تْحَب قْريبَك وتَكرَه عْدوك\"، ");
INSERT INTO arq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","بَصَّح أَنا نْقولَلكُم: حَبُّو عَديانكُم، وصَلّيو للي يَحَّڤروكُم، ");
INSERT INTO arq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","باش تْكونو وْلاد باباكُم اللي فالسْما، خاطَر هُوَ يْطَلَّع شَمسو على المَشرارين والمْلاح، ويْطَيَّح الشْتا على الصالحين واللي ماشي صالحين. ");
INSERT INTO arq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","خاطَر وَلاّ تْحَبّو اللي يْحَبّوكُم، واش من الآجَر عَندكُم؟ المَكّاسين ماشي هومَ تاني يْديرو هَكدا؟ ");
INSERT INTO arq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","وَلاّ تْسَلّمو غير على خاوَتكُم، واش من الخير راكُم تْديرو؟ الكُفّار ماشي هومَ تاني يْديرو هَكدا؟ ");
INSERT INTO arq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","هِمَّالا كونو كاملين كيما باباكُم السْماوي كامَل. ");
INSERT INTO arq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","بَلاكو تْبَيّنو صْلاحكُم قُدّام الناس باش يْشوفوكُم، وَلاّ ماكاش ما يْكونش عَندكُم آجَر عَند باباكُم اللي فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","كي تْصَدَّق ما تْبَوَّقش قُدّامَك كيما يْديرو المُنافقين فالمْجامَع وفالزْنَق باش يَشُّكروهُم الناس. نْقولَلكُم الصَح: راهُم أَدّاو الآجَر مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","أَنتَ كي تْصَدَّق، ما لازَمش تَعرَف يَدَّك اليْسرى واش تْدير اليْمنى، ");
INSERT INTO arq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","باش تْكون الصَدَقة مْتاعَك فالسَر وباباك اللي يْشوف فالسَر يْجازيك. ");
INSERT INTO arq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","وكي تْصَلّيو، ما تْكونوش كيما المُنافقين، خاطَر يْحَبّو يَوَّقفو يْصَلّيو فالمْجامَع وفالشْوَك مْتاع الزْنَق باش يْبانو للناس، نْقولَلكُم الصَح: راهُم أَدّاو الآجَر مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","بَصَّح أَنتَ كي تْصَلّي، أَدخُل للبيت الدَخلانِيّة مْتاعَك، وأَغلَق الباب، وصَلّي لباباك اللي راهو فالسَر، وباباك اللي يْشوف فالسَر يْجازيك. ");
INSERT INTO arq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","وكي تْصَلّيو، ما تَبقاوش تْعاودو فالكْلام باطَل كيما يْديرو الكُفّار. خاطَر يَحَّسبو باللي من كَترة كْلامهُم، يُستَجابَلهُم. ");
INSERT INTO arq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ما تْكونوش كيما هومَ، خاطَر باباكُم يَعرَف واش تَسَّحقو قْبَل ما تَطَّلبو مَنُّو. ");
INSERT INTO arq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","هِمّالا أَنتومَ صَلّيو هَكدا: \"بابانا اللي فالسْما، يْتقَدَّس آسمَك، ");
INSERT INTO arq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","يْجي مَلَكوتَك، يَندار مُرادَك كيما راهو فالسْما، هَكداك تاني على الأَرض. ");
INSERT INTO arq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","خُبزنا مْتاع اليوم أَعطيلنا اليوم، ");
INSERT INTO arq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","أَغفَرَّلنا دْنوبنا كيما حْنا تاني نَغَّفرو للي يَغَّلطو فينا، ");
INSERT INTO arq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","وما تَدّيناش للغْواية، بَصَّح نَجّينا من الحيلي\". ");
INSERT INTO arq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","خاطَر وَلاّ سْمَحتو للناس الغَلطات مْتاعهُم، باباكُم السْماوي يَسمَحَّلكُم تاني، ");
INSERT INTO arq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","بَصَّح لو كان ما تَسَّمحوش للناس، باباكُم تاني ما يَسمَحَّلكُمش الغَلطات مْتاعكُم. ");
INSERT INTO arq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","كي تْصومو ما تْكونوش كيما المُنافقين، مَغمومين، خاطَر يْبَدّلو وْجوههُم باش يْبانو للناس صايمين. نْقولَلكُم الصَح، راهُم أَدَّاو الآجَر مْتاعهُم، ");
INSERT INTO arq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","بَصَّح أَنتَ كي تْصوم، أَدهَن راسَك وأَغسَل وَجهَك، ");
INSERT INTO arq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","باش ما تْبانش للناس صايَم، بَصَّح لباباك اللي راه فالسَر، وباباك اللي راه يْشوف فالسَر يْجازيك. ");
INSERT INTO arq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ما تْلَمّوش لروحكُم كْنوز فالأَرض وين العَتّة والصْديد يْفَسّدو، ووين السَرّاقين يَتُّقبو ويَسَّرقو، ");
INSERT INTO arq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","بَصَّح، لَمّو كْنوز فالسْما وين لا عَتّة وَلا صْديد يْفَسّدو، ووين السَرّاقين ما يَتَّقبو ما يَسَّرقو، ");
INSERT INTO arq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","خاطَر وين يْكون الكَنز مْتاعَك، تَم تاني يْكون قَلبَك. ");
INSERT INTO arq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","قَنديل الدات هيَ العين. وَلاّ كانَت عينَك صْحيحة، داتَك كامَل تْكون ضاوية، ");
INSERT INTO arq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","وَلاّ كانَت عينَك ماشي صْحيحة، داتَك كامَل تْكون مَضلامة. وَلاّ كان النور اللي فيك ضْلام، شْحال يْكون كْبير هَداك الضْلام! ");
INSERT INTO arq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","حَتّى واحَد ما يَقدَر يَخدَم زوج سْياد، خاطَر يا يَكرَه واحَد ويْحَب الآخُر، يا يَتعَلَّق بواحَد ويَحڤَر الآخُر. ما تَقَّدروش تَخَّدمو الله والمال. ");
INSERT INTO arq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","على هَدا نْقولَلكُم: ما تْخَمّموش على حْياتكُم واش تاكلو وَلاّ واش تَشَّربو، وَلاّ على داتكُم واش تَلَّبسو. الحْياة ماشي كْتَر من الماكلة والدات كْتَر من اللَبسة؟ ");
INSERT INTO arq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","مَيّزو طْيور السْما، ما يَزَّرعو، ما يَحَّصدو، ما يْلَمّو فالمْخازَن، وباباكُم اللي فالسْما يْطَعَّمهُم. أَنتومَ ما تَسواوش كْتَر مَنهُم؟ ");
INSERT INTO arq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","شْكون فيكُم يَقدَر يْزيد بالتَخمام مْتاعو ساعة في عَمرو؟ ");
INSERT INTO arq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ووَعلاش تْخَمّمو على اللَبسة؟ أَتّعَلّمو من السيسان مْتاع الحْواش كيفاش يْنوض؟ ما يَخدَم ما يَنسَج، ");
INSERT INTO arq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","بَصَّح نْقولَلكُم: سُلَيمان في كامَل عَزّو ما لْبَسش كيما واحَد فيهُم. ");
INSERT INTO arq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","وَلاّ الحْشيش مْتاع الحْواش اللي اليوم راهو كايَن وغُدوة يَتَّرما فالكوشة، الله يْلَبّسو هَكدا، ماشي أَنتومَ كْتَر، يا قْلال الإيمان؟ ");
INSERT INTO arq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","هِمّالا ما تْخَمّموش وتْقولو: \"واش ناكلو؟ وَلاَّ واش نَشَّربو؟ وَلاَّ واش نَلَّبسو؟ ");
INSERT INTO arq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","خاطَر هاد الشي كامَل، الكُفّار هومَ اللي يْحَوّسو عليه. خاطَر باباكُم السْماوي يَعرَف باللي تَسَّحقو هاد الشي كامَل. ");
INSERT INTO arq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","حَوّسو قْبَل على مَلَكوت الله والصْلاح مْتاعو، وهاد الشي كامَل يَنزادَلكُم. ");
INSERT INTO arq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","هِمَّالا ما تْخَمّموش على غُدوة، خاطَر غُدوة يْخَمَّم على روحو. كُل يوم يَكفيه هَمّو\". ");
INSERT INTO arq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ما تَحَّكموش باش ما يَتَّحكَمش عليكُم، ");
INSERT INTO arq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","خاطَر يَتَّحكَم عليكُم بالحُكم اللي تَحَّكمو بيه، ويَتكَيَّلَلكُم بالكيلة اللي تْكَّيّلو بيها. ");
INSERT INTO arq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","وَعلاش تْشوف التَخشة اللي في عين خوك بَصَّح ما تْفيقش للحَطبة اللي في عينَك؟ ");
INSERT INTO arq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","وَلاّ كيفاش تْقول لخوك: \"خَلّيني، رايَح نْخَرَّج التَخشة من عينَك وأَنتَ عَندَك حَطبة في عينَك\" ");
INSERT INTO arq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","مُنافَق، خَرَّج قْبَل الحَطبة من عينَك، داك الساع تْشوف مْليح باش تْخَرَّج التَخشة من عين خوك. ");
INSERT INTO arq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ما تَعطيوش المْقَدّس للكْلاب يْعودو يْدورو يْقَطّعوكُم، وما تَرميوش جوهَركُم قُدّام الحْلالَف يْعودو يَعَّفسوه برَجليهُم. ");
INSERT INTO arq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","أَطَّلبو يَتمَدَّلكُم، حَوّسو تَلقاو، طَبطبو يَتَّفتَحَّلكُم، ");
INSERT INTO arq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","خاطَر كُل واحَد يَطلَب يْنال، واللي يْحَوَّس يَلقا واللي يْطَبطَب يَتَّفتَحلو. ");
INSERT INTO arq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","شْكون فيكُم يا بْني آدَم، اللي لو كان يَطلَب منّو وْليدو خُبز يَعطيلو حَجرة؟ ");
INSERT INTO arq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ولو كان يَطلَب منّو حوتة يَعطيلو حْنَش؟ ");
INSERT INTO arq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","وَلاّ أَنتومَ اللي مَشرارين تَعَّرفو تْمَدّو حاجات مْلاح لوْلادكُم، شْحال هِمّالا باباكُم اللي فالسْما يْمَد حاجات مْلاح للي يَطَّلبو منّو؟ ");
INSERT INTO arq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","هِمّالا، كامَل واش تْحَبّو يْديرولكُم الناس، هَكداك أَنتومَ تاني ديرولهُم، خاطَر هَدي هيَ الشَريعة وتَعليم الأَنبيا. ");
INSERT INTO arq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","أَدَّخلو من الباب الضِيّقة، خاطَر عْريضة الباب وواسعة الطْريق اللي يَدّيو للهْلاك وبَزّاف اللي يَدَّخلو منها، ");
INSERT INTO arq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","شْحال ضِيّقة الباب ومْزِيّرة الطْريق اللي يَدّيو للحْياة، وقْلال اللي يْلقاوها! ");
INSERT INTO arq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","رَدُّو بالكُم من الأَنبيا الكَدّابين، يْجيوكُم بلَبسة النْعاج، بَصَّح هومَ من الداخَل دْيوبة خَطّافين. ");
INSERT INTO arq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","من فْعالهُم تَعَّرفوهُم. العْنَب يَتَّقطَف من الشوك؟ وَلاّ الكَرموس من العَلاّيَڤ؟ ");
INSERT INTO arq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","هَكدا، كُل سَجرة مْليحة تَعطي فاكية مْليحة بَصَّح السَجرة الفاسدة تَعطي فاكية فاسدة. ");
INSERT INTO arq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","سَجرة مْليحة ما تَقدَرش تَعطيٍ فاكية فاسدة وَلا سَجرة فاسدة فاكية مْليحة. ");
INSERT INTO arq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","كُل سَجرة ما تَعطيش فاكية مْليحة، تَنقطَع وتَتَّرما فالنار، ");
INSERT INTO arq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","هِمّالا، من فْعالهُم تَعَّرفوهُم. ");
INSERT INTO arq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ماشي كُل من يْقوللي: \"يا رَب، يا رَب\" يَدخُل لمَلَكوت السْما، يَدخُل غير اللي يْدير مُراد بابا اللي فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","بَزّاف اللي يْقولولي في هَداك النْهار: \"يا رَب، يا رَب، ماشي بآسمَك تْنَبّأنا، وبآسمَك خَرَّجنا شْياطَن، وبآسمَك دَرنا مُعجِزات بَزّاف؟\" ");
INSERT INTO arq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","داك الساع نْخَبَّرهُم: \"عَمري ما عْرَفتكُم، بَعّدو علِيَّ يا خَدّامين الباطَل\" ");
INSERT INTO arq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","على هَدا، كُل من يَسمَع كْلامي هَدا ويَطَبّقو، يْشَبَّه لراجَل عاقَل، بْنا دارو على الحْجَر، ");
INSERT INTO arq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","صَبَّت الشْتا، وفاضو الويدان وناضو الأَرياح وطاحو على هَديك الدار، وما طاحَتش خاطَر أَتَّبنا لْساسها على الحْجَر. ");
INSERT INTO arq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","وكُل من يَسمَع كْلامي هَدا وما يَطَبّقوش، يْشَبَّه لراجَل جايَح، بْنا دارو على الرْمَل، ");
INSERT INTO arq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","صَبَّت الشْتا، وفاضو الويدان وناضو الأَرياح وضَربو هَديك الدار، وطاحَت وكانَت الوَخدة مْتاعها كْبيرة\" ");
INSERT INTO arq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","بَعد ما كَمَّل يَسوع هاد الكْلام، سْتَعجَب الغاشي فالتَعليم مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","خاطَر كان يْدَرَّسهُم كي اللي عَندو الحُكمة وماشي كيما الكُتّاب مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","كي هْبَط يَسوع من الجْبَل، تَبّعو غاشي كْبير. ");
INSERT INTO arq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","وجا ليه واحَد عَندو البْرَص، سْجَدلو وقال: \"يا رَب، وَلاّ حَبّيت، تَقدَر تْرَدّني طاهَر\" ");
INSERT INTO arq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","مَد يَسوع يَدّو، مَسّو وقال: \"نْحَب، كون طاهَر\". تَم تَم، طْهَر الراجَل من البْرَص مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","وقاللو يَسوع: \"شوف، ما تْقول لحَتّى واحَد، بَصَّح روح وَرّي روحَك لراجَل الدين وأَدّي الهِبة اللي آمَر بيها موسى، شْهادة ليهُم\" ");
INSERT INTO arq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","كي دْخَل يَسوع لكَفرناحوم، جا لعَندو واحَد قايَد المْية يَحَلَّل فيه، ");
INSERT INTO arq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ويْقول: \"يا رَب، الخْديم مْتاعي راه راقَد فالدار، مَشلول ويَتعَدَّب بَزّاف\"، ");
INSERT INTO arq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","قاللو يَسوع: \"نْجي أَنا ونَشفيه\" ");
INSERT INTO arq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","جاوَب قايَد المْية وقال: \"يا رَب، أَنا ما نَستاهَلش باش تَدخُل تَحت السْقَف مْتاع داري، بَصَّح قول كَلمة بَرك ويَبرا الخْديم مْتاعي، ");
INSERT INTO arq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","خاطَر أَنا بْنادَم عَندي اللي يَحكُم فِيَّ، وعَندي عَسكَر تَحت يَدّي، نْقول لهَدا: أَمشي، يَمشي، ولواحَدآخُر: أَرواح، يْجي، وللعَبد مْتاعي: دير هَدا، يْدير\" ");
INSERT INTO arq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","كي سَمعو يَسوع سْتَعجَب وقال للي كانو معاه: \"نْقولَلكُم الصَح، حَتّى واحَد ما لْقيت عَندو إيمان قَد هَدا في إِسرائيل، ");
INSERT INTO arq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","نْقولَلكُم: بَزّاف يْجيو من المَشرَق والمَغرَب ويَقَّعدو على الميدة مع إِبراهيم وإِسحاق ويَعقوب في مَلَكوت السْما، ");
INSERT INTO arq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","بَصَّح وْلاد المَلَكوت يَتَّرماو بَرَّا فالضْلام مْتاع بَرَّا وين يْكون البْكا وغَز السْنان\" ");
INSERT INTO arq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","وقال يَسوع للقايَد: \"روح، يْكون لَك على حْساب إيمانَك\". في هَديك الساعة بالدات، بْرا الخْديم مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","وكي راح يَسوع لدار بُطرُس، شاف نْسيبتو راقدة بالحَمّة. ");
INSERT INTO arq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","مَس يَدها وراحَتَّلها الحَمّة، وناضَت وبْدات تَخدَمهُم. ");
INSERT INTO arq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","كي جات العْشِيّة، جابولو ناس مَسكونين بَزّاف، خَرَّج الأَرواح منهُم بكَلمة وشْفا كامَل اللي كان عَندهُم المَرض، ");
INSERT INTO arq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","باش يْتَم الكْلام اللي قالو إِشعِيا النَبي: \"خْدا عْيوبنا ورْفَد مْراضنا.\" ");
INSERT INTO arq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","كي شاف يَسوع غاشي دايَر بيه، آمَر باش يْبَعّدو للشَط الآخُر. ");
INSERT INTO arq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","جا عَندو واحَد الكاتَب وقاللو: \"يا سيدي، نْتَبّعَك وين تْروح\". ");
INSERT INTO arq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","جاوبو يَسوع: \"التْعالَب عَندهُم غيران، وطْيور السْما عْشوش، بَصَّح أَنا بْن الإِنسان ما عَنديش وين نْتَكّي راسي.\" ");
INSERT INTO arq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","واحَدآخُر، من التابعين مْتاعو، قاللو: \"يا رَب، أَسمَحلي نْروح قْبَل نَدفَن بابا\"، ");
INSERT INTO arq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","يَسوع قاللو: \"تَبَّعني وخَلّي الموتى يَدَّفنو الموتى مْتاعهُم!\" ");
INSERT INTO arq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","وكي طْلَع يَسوع فالفْلوكة، تَبّعوه التابعين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","وهاو وين ضْرَب ريح قْوي بَزّاف فالبْحر، حَتّى تْغَطّات الفْلوكة بالموجات، وهُوَ كان راقَد. ");
INSERT INTO arq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","جاو ليه التابعين، نَوضوه وقالو: \"يا رَب، سَلَّكنا رانا نْموتو\"، ");
INSERT INTO arq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","قالَلهُم: \"وَعلاش راكُم خايفين يا قْلال الإيمان؟\" داك الساع ناض، وهَدَّد الأَرياح والبْحَر وتْهَدنَت الحالة. ");
INSERT INTO arq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","سْتَعجبو الناس وقالو: \"واش يْكون هَدا، خاطر حَتّى الأَرياح والبْحَر يْطيعوه؟\" ");
INSERT INTO arq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","وكي راح للشَط الآخُر، في بْلاد الجَدَريّين، لاقاوَه زوج مَسكونين كانو خارجين من المْدافَن، كانو واعرين بَزّاف وعلى جالهُم حَتّى واحَد ما كان يَقدَر يْجوز من هَديك الطْريق. ");
INSERT INTO arq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","بْداو يْعَيّطو ويْقولو: \"واش بيننا وبينَك يا بْن الله؟ جيت اللَهنا قْبَل الوَقت باش تْعَدَّبنا؟\" ");
INSERT INTO arq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","وكان كايَن بْعيد عليهُم قْطيع كْبير مْتاع الحْلالَف يَرعاو. ");
INSERT INTO arq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","الشْياطَن طَلبو مَنّو وقالو: \"وَلاّ تْخَرَّجنا، أَبعَتنا لهاد الحْلالَف\"، ");
INSERT INTO arq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","قالَلهُم: \"روحو!\" خَرجو هَدوك الشْياطَن وراحو للحْلالَف، وهَدوك الحْلالَف كامَل أَتَّرماو من حَرف الجْبَل للبْحَر وماتو فالما. ");
INSERT INTO arq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","هَربو الرَعيان مْتاع الحْلالَف وراحو للمْدينة يَحكيو كُل شي ويْخَبّرو بالشي اللي صْرا للمَسكونين. ");
INSERT INTO arq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","خَرجت كامَل المْدينة تْلاقي يَسوع وكي شافوه طَلبو مَنُّو باش يْروح من بْلادهُم. ");
INSERT INTO arq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","طْلَع يَسوع في فْلوكة، قْطَع البْحَر وجا لمْدينتو. ");
INSERT INTO arq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","جابولو واحَد مَشلول مْكَسَّل على فْراش. كي شاف يَسوع الإيمان مْتاعهُم، قال للمَشلول: \"أَتسَجَّع يا وْليدي، دْنوبَك مَغفورين\". ");
INSERT INTO arq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","جْماعة من الكُتّاب قالو في قْلوبهُم: \"هَدا راهو يَكفَر\"، ");
INSERT INTO arq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","عْرَف يَسوع تَخمامهُم وقال: \"وَعلاش عَندكُم تَخمام دوني في قْلوبكُم؟ ");
INSERT INTO arq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","أَما سَاهل باش يَتقال: \"دْنوبَك مَغفورين\"، وَلاّ يَتقال: \"نوض وأَمشي؟\" ");
INSERT INTO arq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","بَصَّح باش تَعَّرفو باللي بْن الإِنسان عَندو على الأَرض القُدرة باش يَغفَر الدْنوب، داك الوَقت قال للمَشلول: \"نوض، أَرفَد فْراشَك وروح لدارَك!\"\" ");
INSERT INTO arq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ناض المَشلول وراح لدارو. ");
INSERT INTO arq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","كي شاف الغاشي هاد الشي، خافو وسَبّحو الله اللي عْطا قُدرة كيما هَدي للناس. ");
INSERT INTO arq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","وكي كان يَسوع جايَز من تَمّة، شاف واحَد الراجَل قاعَد وين يْخَلّصو الغْرامة واسمو مَتّى. قاللو: \"تَبَّعني\"، ناض هَداك الراجَل وتَبّعو. ");
INSERT INTO arq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","وكي كان يَسوع على الميدة فالدار، جاو بَزّاف المَكّاسين والخاطيين وقَعدو على الميدة معاه هُوَ والتابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","كي شافو الفَرّيسِيّين هَداك الشي، قالو للتابعين مْتاع يَسوع: \"وَعلاش ياكُل شيخكُم مع هاد المَكّاسين والخاطيين؟\" ");
INSERT INTO arq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","كي سْمَع يَسوع قال: \"ماشي الصْحاح اللي يَسَّحقو طْبيب، المَرضى هومَ اللي يَسَّحقوه، ");
INSERT INTO arq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","روحو أَتعَلّمو المَعنى مْتاع \"نَحَب الرَحمة ماشي الضْحِيّة\"، خاطَر ما جيتش نْعَيَّط للصالحين، جيت نْعَيَّط للخاطيين.\" ");
INSERT INTO arq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","داك الساع، جاو ليه تابعين يوحَنّا يْقولو: \"وَعلاش حْنا والفَرّيسِيّين نْصومو بَزّاف والتابعين مْتاعَك ما يْصوموش؟\" ");
INSERT INTO arq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","قالَلهُم يَسوع: \"يَقَّدرو مْوالين العَرس يَحَّزنو كي يْكون العْريس معاهُم؟ يْجيو يامات وين يَتَّرفَع العْريس من عَندهُم، وداك الوَقت يْصومو. ");
INSERT INTO arq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","حَتّى واحَد ما يْبَقَّط طَرف قْماش جْديد في لَبسة قْديمة، خاطَر الطَرف الجْديد يْفَزَّر القْماش القْديم وتْوَلّي التُقبة كْتَر من اللي كانَت، ");
INSERT INTO arq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","وما يْحَطّوش شْراب جْديد في ڤَربات قْدَم، وَلاّ ما كانش يَتقَطّعو الڤَربات ويْسيل الشْراب ويْروحو الڤَربات، بَصَّح يْحَطّو الشْراب الجْديد في ڤَربات جْدَد وهَكدا يَبقاو في زوج. ");
INSERT INTO arq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","كي كان يَسوع يَهدَرَّلهُم على هاد الحاجات، جا ليه واحَد الرايَس، سْجَدلو وقال: \"بَنتي هَدا وين ماتَت، بَصَّح أَرواح، وحَط يَدَّك عليها وهيَ تَحيا\". ");
INSERT INTO arq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ناض يَسوع وتَبّعو هُوَ والتابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","وكانَت واحَد المْرا يْسيل منها الدَم من طْناشَن سْنة، جاتو من اللور ومَسَّت الجْلال مْتاع لْباسو، ");
INSERT INTO arq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","خاطَر كانَت تْقول في قَلبها: \"لو كان بَرك نْمَس لْباسو نَسلَك\". ");
INSERT INTO arq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","دار يَسوع وشافها وقال: \"أَتسَجّعي يا بَنتي، إيمانَك سَلكَك\". وبْرات المْرا من هَديك الساعة. ");
INSERT INTO arq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","كي راح يَسوع لدار الرايَس، وشاف الجَوّاقين والغاشي دايرين حالة، ");
INSERT INTO arq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","قالَلهُم: \"بَعّدو، خاطَر الطَفلة ما ماتَتش، راهي راقدة\". تْمَسخرو بيه. ");
INSERT INTO arq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","كي خَرّجو الغاشي، دْخَل يَسوع، شَد يَد الطَفلة وناضَت، ");
INSERT INTO arq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","وشاع هاد الخْبَر في كامَل هَديك البْلاد. ");
INSERT INTO arq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","كي كان يَسوع رايَح من تَمّة، تَبّعوه زوج عَميين وهومَ يْعَيّطو ويْقولو: \"حَن علينا يا وْليد داوَد\" ");
INSERT INTO arq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","وكي دْخَل للدار، جاو ليه العَميين، ويَسوع قالَلهُم: \"تامنو باللي نَقدَر نْدير هاد الشي؟\" قالو: \"إيه يا رَب.\" ");
INSERT INTO arq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","داك الساع، مَس يَسوع عينيهُم وقال: \"على حْساب إيمانكُم يَصرالكُم\"، ");
INSERT INTO arq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ونْحَلّو عينيهُم. قالَلهُم يَسوع بالوْعارة: \"رَدّو بالكُم، حَتّى واحَد ما لازَم يَعرَف.\" ");
INSERT INTO arq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","وهومَ كي خَرجو شَيعو بيه في كامَل هَديك الجيهة. ");
INSERT INTO arq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","كي خَرجو، جابولو واحَد المَسكون عَڤّون وطْرَش، ");
INSERT INTO arq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","وكي خْرَج الشيطان من الأَطرش العَڤّون، هدَر وسْتَعجَب الغاشي وقال: \"هاد الشي عَمرو ما نْشاف في إِسرائيل\". ");
INSERT INTO arq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","والفَرّيسِيّين قالو: \"راهو يْخَرَّج الشْياطَن برايَس الشْياطَن\". ");
INSERT INTO arq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","كان يَسوع يْطَوَّف المْدايَن كامَل والدْشور، يْدَرَّس في مْجامَعهُم ويْبَرَّح ببْشارة المَلَكوت ويَشفي من كُل مَرض وكُل عيب، ");
INSERT INTO arq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","وكي شاف الغاشي، حَن عليهُم، خاطَر كانو مَهمومين ومَغبونين كي الغْنَم بْلا راعي. ");
INSERT INTO arq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","داك الساع، قال للتابعين مْتاعو: \"الحْصاد كاتَر بَصَّح الخَدّامين قْلال، ");
INSERT INTO arq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","هِمّالا، أَطَّلبو من مول الحْصاد باش يَبعَت خَدّامين للحْصاد\". ");
INSERT INTO arq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","عَيَّط يَسوع للتابعين الطْناش مْتاعو، عْطالهُم القُدرة على الأَرواح الناجسين باش يْخَرّجوهُم وباش يَشفيو من كُل مَرض وكُل عيب. ");
INSERT INTO arq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","هَدو هومَ أَسمَوات الرُسُل الطْناش: الأَوَّل سَمعان المْسَمّي بُطرُس وخوه أَندراوَس، يَعقوب وْليد زَبَدي وخوه يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","فيلِبّس وبَرتُلماوَس، توما ومَتّى المَكّاس، يَعقوب وْليد حَلفى، وتَدّاوَس، ");
INSERT INTO arq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","سَمعان القانَوي ويَهودا الإِسخَريوطي اللي سَلَّم يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","هَدو هومَ الطْناش اللي بْعَتهُم يَسوع بَعد ما وَصّاهُم وقالَلهُم: \"ما تَدّيوش الطْريق لعَند الأُمّات الأخرين وما تَدُّخلوش لمْدينة السامرِيّين، ");
INSERT INTO arq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","روحو عَند الخَرفان الضَايعين مْتاع دار إِسرائيل. ");
INSERT INTO arq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","روحو، بَرّحو وقولو باللي مَلَكوت السْما قَرَّب، ");
INSERT INTO arq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","أَشفيو المَرضى، أَحييو الموتى، رَدّو اللي عَندهُم البْرَص طاهرين، وخَرّجو الشْياطَن. أَدّيتو باطَل، مَدّو باطَل، ");
INSERT INTO arq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ما تَدّيو معاكُم لا دْهَب لا فَضَّة لا دْراهَم، ");
INSERT INTO arq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","لا رَزمة للطْريق لا زوج لَبسات، لا صَبَّاط لا عْصا، خاطَر الخَدّام يَستاهَل قوتو. ");
INSERT INTO arq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","المْدينة وَلاّ الدَشرة اللي تَدَّخلولها، حَوّسو فيها على واحَد يَستاهَل باش تَدُّخلو عَندو وأَقَّعدو عَندو حَتّى تْروحو. ");
INSERT INTO arq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","وكي تَدُّخلو للدار سَلّمو عليها، ");
INSERT INTO arq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","وَلاّ كانَت الدار تَستاهَل، سْلامكُم يْجي عْليها، وَلاّ ما كانَتش تَستاهَل، سْلامكُم يَرجَع ليكُم. ");
INSERT INTO arq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","لوكان ما يَسْتَقبلوكُمش وما يَسَّمعوش كْلامكُم، أَخُّرجو من هَديك الدار وَلاّ المْدينة وأَنَّفضو الغْبار من رَجليكُم. ");
INSERT INTO arq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","نْقولَلكُم الصَح، يوم الحْساب، حالَة بْلاد سَدوم وعَمّورة ما تْكونش واعرة قَد حالة هَديك البْلاد. ");
INSERT INTO arq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","راني نَبعَتكُم كي الخَرفان في وَسط الدْيوبة، كونو حيلِيّين كي الحْنوشة ونْوايا كي الحْمام. ");
INSERT INTO arq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","رَدّو بالكُم من الناس، خاطَر رايحين يْسَلّموكُم لمْجالَس الدين، ويَجَّلدوكُم في مْجامَعهُم، ");
INSERT INTO arq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","على جالي يَدّيوكُم عَند حُكّام وسْلاطَن باش تَشَّهدو قُدّامهُم وقُدّام الكُفّار. ");
INSERT INTO arq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","كي يْسَلّموكُم، ما تَتحَيّروش كيفاش وواش تَهَّدرو، خاطَر يَتَّعطالكُم في هَديك الساعة واش تْقولو، ");
INSERT INTO arq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","خاطَر ماشي أنتومَ اللي رايحين تَهَّدرو، الروح مْتاع باباكُم هُوَ اللي رايَح يَهدَر فيكُم. ");
INSERT INTO arq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","الخو يْسَلَّم خوه للموت والباباة وْليدو، يَوَّقفو الدْراري ضَد مْواليهُم ويَقُّتلوهُم. ");
INSERT INTO arq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","تْكونو مَكروهين من الناس كامَل على جال آسمي، بَصَّح اللي يَبقا تابَت حَتّى للأَخَّر، هَداك يَسلَك. ");
INSERT INTO arq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","كي يَحَّڤروكُم في هاد المْدينة، أَهَّربو للأُخرى، خاطر نْقولَلكُم الصَح، ما تْكَمّلوش مْدايَن إسرائيل حَتّى يْجي بْن الإنسان. ");
INSERT INTO arq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","التابَع ماشي خير من الشيخ مْتاعو وَلا العَبد خير من سيدو، ");
INSERT INTO arq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","لازَم بَرك التابَع يْوَلّي كيما الشيخ مْتاعو، والخْديم كيما سيدو. وَلاّ يْسَمّيو مول الدار بَعلزَبول، كيفاش ما يْسَمّيوش هَكدا ناس دارو؟ ");
INSERT INTO arq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","هِمّالا ما تْخافوهُمش، خاطَر ما كانش حاجة مْدَرّقة ما تْنَكشَفش وَلاّ مْخَبّية ما تْنَعرَفش، ");
INSERT INTO arq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","اللي نْقولهولكُم فالضْلام، قولوه فالضو، واللي تَسَّمعوه فالوْدَن، بَرّحو بيه فوق السْطوح. ");
INSERT INTO arq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ما تْخافوش من اللي يَقُّتلو الدات وما يَقَّدروش يَقُّتلو النَفس، بَصَّح خافو من اللي يَقدَر يَهلَك النَفس والدات في جَهَنَّمة. ");
INSERT INTO arq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ماشي زوج زْواوَش يَنباعو بصوردي؟ وهَكداك واحَد فيهُم ما يْطيح فالأَرض بلا غَرض باباكُم. ");
INSERT INTO arq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","حَتّى شْعَر راسكُم كامَل مَحسوب، ");
INSERT INTO arq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","هِمّالا ما تْخافوش، تَسواس كْتَر من زْواوَش بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","على هَدا، اللي يَستَعرَف بيَّ قُدّام الناس، نَستَعرَف بيه أنا تاني قُدّام بابا اللي فالسْما، ");
INSERT INTO arq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","بَصَّح اللي يَنكُرني قُدّام الناس، نَنُّكرو أنا تاني قُدّام بابا اللي فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ما تَحَّسبوش باللي جيت نْجيب السْلام على الأَرض، ما جيتش نْجيب السْلام، جيت نْجيب السيف. ");
INSERT INTO arq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","خاطَر جيت نْفَرَّق بين الإِنسان وباباه وبين الطَفلة ويَمّاها، وبين العْروسة وعْجوزَتها، ");
INSERT INTO arq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ويْكونو عَديان بْنادَم هومَ ناس دارو. ");
INSERT INTO arq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","اللي يْحَب باباه وَلاّ يَمّاه كْتَر مَنّي، ما يَستاهَلنيش، واللي يْحَب وْليدو وَلاّ بَنتو كْتَر مَنّي، ما يَستاهَلنيش، ");
INSERT INTO arq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","واللي ما يَرفَدش الصْليب مْتاعو ويَتَبَّعني، ما يَستاهَلنيش. ");
INSERT INTO arq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","اللي يْحادَر على حْياتو، يَخسَرها، واللي يَخسَر حْياتو على جالي، يَلقاها. ");
INSERT INTO arq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","اللي يَستَقبَلكُم يَستَقبَلني، واللي يَستَقبَلني يَستَقبَل اللي بْعَتني. ");
INSERT INTO arq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","اللي يَستَقبَل نَبي خاطَر نَبي، يْنال الآجَر مْتاع نَبي، واللي يَستَقبَل راجَل صالَح خاطَر صالَح، يْنال الآجَر مْتاع واحَد صالَح. ");
INSERT INTO arq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","واللي يَعطي كاس ما بارَد لواحَد من هاد الصْغار خاطَر هُوَ التابَع مْتاعي، نْقولَلكُم الصَح، الآجَر مْتاعو ما يْضيعش\". ");
INSERT INTO arq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","كي كَمَّل يَسوع يْوَصّي التابعين مْتاعو الطْناش، بَعَّد من تَمَّة باش يْدَرَّس ويْبَرَّح في مْدايَنهُم. ");
INSERT INTO arq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","بَصَّح يوحَنّا المَعمَدان كي سْمَع فالحَبس بفْعال المَسيح، بْعَت التابعين مْتاعو ");
INSERT INTO arq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","يْقوللو: \"أَنتَ هُوَ اللي رايَح يْجي، وَلاّ نَستَنّاو واحَدآخُر؟\" ");
INSERT INTO arq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","جاوَب يَسوع وقالَلهُم: \"روحو خَبّرو يوحَنّا واش راكُم تَسَّمعو وتْشوفو: ");
INSERT INTO arq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","العَميين راهُم يْعاودو يْشوفو، الكَعوانين يَمشيو مْسَڤَّم، المْراض بالبْرَص يَطَّهرو، الطْروشى يَسَّمعو، الموتى يَحياو والبْشارة تَوصَل للڤْلالين. ");
INSERT INTO arq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","يا سَعد اللي ما يَعتَرش فيَّ\". ");
INSERT INTO arq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","وكي راحو، بْدا يَسوع يْقول للغاشي على يوحَنّا: \"واش خْرَجتو تْشوفو فالخْلا؟ قَصبة يْهَزّها الريح؟ ");
INSERT INTO arq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","بَصَّح، واش خْرَجتو تْشوفو؟ بْنادَم لابَس لَبسة غالية؟ اللي يَلَّبسو اللْباس الغالي راهُم في دْيار السْلاطَن. ");
INSERT INTO arq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","بَصَّح واش خْرَجتو تْشوفو؟ نَبي؟ إيه، نْقولَلكُم، وكْتَر من نَبي. ");
INSERT INTO arq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","هُوَ اللي مَكتوب عليه: \"نَبعَت المَرسول مْتاعي قَبلَك، هُوَ اللي يْوَجَّد الطْريق قُدّامَك\"، ");
INSERT INTO arq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","نْقولَلكُم الصَح، ما كانش فاللي وَلدوهُم النْسا واحَد كْبير على يوحَنّا المَعمَدان، بَصَّح الصْغير في مَلَكوت السْما كْبير عليه. ");
INSERT INTO arq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","من وَقت يوحَنّا المَعمَدان حَتّى لليوم ومَلَكوت السْما يَدّيوَه بالقُوّة، وصْحاب القُوّة هومَ اللي يَخَّطفوه، ");
INSERT INTO arq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","خاطَر كامَل الأَنبيا والشَريعة تْنَبّأو حَتّى ليوحَنّا، ");
INSERT INTO arq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","وَلاّ حَبّيتو تَفَّهمو، هُوَ إيليّا اللي كان لازَم يْجي، ");
INSERT INTO arq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","اللي عَندو وَدنين، غير يَسمَع. ");
INSERT INTO arq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ليمَن نْشَبَّه هاد الجيل؟ يْشَبَّه لدْراري قاعدين فالأَسْواق يْكَلّمو واحَدُخرين ");
INSERT INTO arq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ويْقولو: \"جَوَّقنالكُم وما شْطَحتوش، نَوَّحنالكُم وما بْكيتوش، ");
INSERT INTO arq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","خاطَر جا يوحَنّا، ما ياكُل، ما يَشرُب وقالو: \"فيه شيطان\"، ");
INSERT INTO arq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","جا بْن الإنسان ياكُل ويَشرُب وقالو: \"إِنسان مَلهوف وسوكارجي، صاحَب المَكّاسين والخاطيين\"، بَصَّح العْقَل يْبان بفْعالو\". ");
INSERT INTO arq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","داك الساع بْدا يَسوع يْلوم فالمْدايَن اللي نْدارو فيهُم بَزّاف من المُعجِزات مْتاعو، خاطَر ما تابوش: ");
INSERT INTO arq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","\"يا ويلَك يا كورَزين، يا ويلَك يا بيت صَيدا، خاطَر لو كان جاو في صور وصَيدا المُعجِزات اللي صْراو عَندكُم، لو كان راهُم تابو من زْمان بالخيشة والرْماد. ");
INSERT INTO arq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","على هَدا نْقولَلكُم، يوم الحْساب، حالة صور وصَيدا ما تْكونش واعرة كيما حالَتكُم. ");
INSERT INTO arq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","وأنتِ يا كَفرناحوم، رايحة تَطَّلعي للسْما؟ لالا، تَهَّبطي حَتّى لمَسكَن الموتى. خاطَر لو كان جاو في سَدوم المُعجِزات اللي صْراو فيك، لو كان بْقات لليوم. ");
INSERT INTO arq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","بَصَّح نْقولَلكُم باللي يوم الحْساب، حالة سَدوم ما تْكونش واعرة كيما حالتَك. ");
INSERT INTO arq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","في داك الوَقت، تْكَلَّم يَسوع وقال: \"نْسَبّحَك يا بابا، رَب السْما والأرض، خاطَر خَبّيت هاد الشي على الحُكَما والفاطنين وكْشَفتو للدْراري الصْغار، ");
INSERT INTO arq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","إيه يا بابا، خاطَر هَكدا حَبّيت. ");
INSERT INTO arq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","كُل شي أتّعْطالي من عَند بابا، وواحَد ما يَعرَف الإِبن من غير الآب وَلا واحَد يَعرَف الآب من غير الإبن واللي حَب الإبن يْوَرّيهولو. ");
INSERT INTO arq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","أَرواحو لِيَّ يا كامَل العَيّانين والمْحَمّلين، وأنا نْعطيلكُم الراحة، ");
INSERT INTO arq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","أَرَّفدو المَضمَض مْتاعي عليكُم، وأتعَلّمو مَنّي خاطَر أنا مْليح وقَلبي مَتواضَع، وتَلقاو الراحة لنْفوسكُم، ");
INSERT INTO arq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","خاطَر المَضمَض مْتاعي ساهَل وحْمالتي خْفيفة\". ");
INSERT INTO arq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","في هَداك الوَقت، جاز يَسوع على حْواش مَغروسين نْهار السَبت، جاعو التابعين مْتاعو وبْداو يَقَّطفو فالسْبول وياكلو. ");
INSERT INTO arq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","شافوهُم الفَرّيسِيّين، وقالو ليَسوع: \"التابعين مْتاعَك راهُم يْديرو الشي اللي ماشي جايَز يَندار فالسَبت\"، ");
INSERT INTO arq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","قالَلهُم هُوَ: \"ما قْريتوش واش دار داوَد كي جاع هُوَ واللي معاه؟ ");
INSERT INTO arq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","كيفاش دْخَل لدار الله وكْلاو الخُبز المْكَرَّس اللي ما كان جايَز ياكُلو لا هُوَ وَلا اللي معاه من غير رْجال الدين بَرك. ");
INSERT INTO arq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","وَلاّ ما قْريتوش فالشَريعة باللي رْجال الدين فالمَعبَد يْكَسّرو السَبت بلا ما يْكونو خاطيين؟ ");
INSERT INTO arq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","نْقولَلكُم، كايَن هْنا اللي كْتَر من المَعبَد. ");
INSERT INTO arq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","لو كان عْرَفتو المَعنى مْتاع \"نْحَب الرَحمة ماشي الضْحيّة\"، ما كنتوش تَحُّكمو على ناس ماشي خاطيين، ");
INSERT INTO arq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","خاطَر بْن الإنسان هُوَ سيد السَبت.\" ");
INSERT INTO arq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","وبَعَّد يَسوع من تَمَّة وراح لمَجمَعهُم، ");
INSERT INTO arq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","وكان تَمَّة إنسان يَدّو مَشلولة. باش يَتَّهمو يَسوع سَقساوَه وقالو: \"يْجوز نَشفيو المَرضى فالسَبت؟\" ");
INSERT INTO arq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","جاوَبهُم: \"شْكون فيكُم الإنسان اللي لو كان تْكون عَندو غير نَعجة واحَدة وتْطيح في حُفرة نْهار السَبت، ما يَشَدهاش ويَجبَدها؟ ");
INSERT INTO arq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","شْحال يَسوا بْنادَم كْتَر من نَعجة. هِمّالا، يْجوز يَندار الخير فالسَبت.\" ");
INSERT INTO arq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","داك الساع قال للراجَل: \"كَسَّل يَدَّك\"، كَسَّلها الراجَل وبْرات صْحيحة كيما الأُخرى. ");
INSERT INTO arq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","كي خَرجو الفَرّيسِيّين، بْداو يَتشاورو بيناتهُم على يَسوع كيفاش يَقُّتلوه. ");
INSERT INTO arq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","عْرَف يَسوع بهاد الشي وبَعَّد من تَمّة وتَبّعو غاشي كْبير وشْفاهُم كامَل، ");
INSERT INTO arq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ووَصّاهُم ووَكَّد عليهُم باش ما يْشَيّعوش بيه، ");
INSERT INTO arq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","باش هَكدا يْتَم كْلام إشعِيا النَبي اللي يْقول: ");
INSERT INTO arq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","\"هاوليك الخْديم مْتاعي اللي خَيَّرتو، حْبيبي اللي سَعدَت نَفسي بيه، نْحَط روحي عليه، ويْخَبَّر الأُمّات بالحَق. ");
INSERT INTO arq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ما يْغالَب، ما يْعَيَّط، وَلا واحَد يَسمَع صوتو فالزْنَق، ");
INSERT INTO arq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ما يْكَسَّرش القَصبة المْدَڤدڤة، وما يَطَفّيش الفْتيلة اللي تْكون تْدَخَّن حَتّى يَنصَر الحَق، ");
INSERT INTO arq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","وكامَل الأُمّات يَرجاو في آسمو.\" ");
INSERT INTO arq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","داك الساع، جابولو واحَد ساكنو شيطان، عْمى وطْرَش وعَڤّون، وشْفاه ورْجَع الأَطرَش العَڤّون يَهدَر ويْشوف. ");
INSERT INTO arq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","كامَل الغاشي دْهَش وقال: \"ما يْكونش هَدا وْليد داوَد؟\" ");
INSERT INTO arq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","كي الفَرّيسِيّين سَمعو هاد الشي قالو: \"هَدا ما راهو يْخَرَّج الشْياطَن غير ببَعلزَبول رايَس الشْياطَن\". ");
INSERT INTO arq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","عْرَف يَسوع تَخمامهُم وقالَلهُم: \"كُل مَملَكة مَقسومة وفيها اللي خارجين ضَدّها تْنَهلَك، وكُل مْدينة وَلاّ دار مَقسومة وفيها اللي خارجين ضَدّها ما تَتبَتش، ");
INSERT INTO arq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","وَلاّ كان الشيطان يْخَرَّج الشيطان، راهو خارَج ضَد روحو، كيفاش هِمّالا تَتبَت مَملَكتو؟ ");
INSERT INTO arq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","وَلاّ أنا راني نْخَرَّج الشْياطَن ببَعلزَبول، وْلادكُم بشْكون يْخَرّجوهُم؟ على هَدا هومَ اللي يَحَّكمو عليكُم. ");
INSERT INTO arq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","وَلاّ بروح الله اللي راني نْخَرَّج الشْياطَن، هِمّالا مَلَكوت الله وْصَل لعَندكُم. ");
INSERT INTO arq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","وَلاّ كيفاش يَقدَر واحَد يَدخُل لدار واحَد قْوي ويَسرَق مْلاكو لو كان ما يَسبَقش قْبَل يَربَط هاد الراجَل القْوي؟ وداك الوَقت يَسرَق واش كايَن في دارو؟ ");
INSERT INTO arq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","اللي ما راهوش معايَ راهو ضَدّي، واللي ما يْلَمش معايَ يْفَرَّق. ");
INSERT INTO arq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","على هَدا نْقولَلكُم: كُل خْطِيّة وكُفر يَتغَفرو للناس، بَصَّح الكُفر ضَد الروح القُدّوس ما يَتَّغفَرش. ");
INSERT INTO arq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","اللي يْقول كَلمة ضَد بْن الإنسان يَتَّغفَرلو، بَصَّح اللي يَهدَر ضَد الروح القُدّوس ما يَتَّغفَرلو لا في هاد الزْمان لا فالزْمان الجاي. ");
INSERT INTO arq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ديرو السَجرة مْليحة والغَلّة مْتاعها مْليحة، وَلاّ ديرو السَجرة فاسدة والغَلّة مْتاعها فاسدة، خاطَر من الغَلّة تَتَّعرَف السَجرة. ");
INSERT INTO arq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","يا وْلاد اللْفاعي، كيفاش تَقَّدرو تْقولو حاجات مْلاح وأنتومَ مَشرارين؟ خاطَر الفَم يَهدَر بالشي اللي يَخرُج من القَلب. ");
INSERT INTO arq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","البْنادَم المْليح يْخَرَّج حاجات مْلاح من كَنزو المْليح والبْنادَم الدوني يْخَرَّج من كَنزو الدوني حاجات دونِيّين. ");
INSERT INTO arq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","نْقولَلكُم، كُل كَلمة باطلة يْقولوها الناس يَتحاسبو عليها نْهار الحْساب، ");
INSERT INTO arq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","خاطَر بكْلامَك تْبَيَّن صْلاحَك وبكْلامَك يَتَّحكَم عليك. ");
INSERT INTO arq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","داك الساع واجبوه شي كُتّاب وفَرّيسِيّين وقالو: \"شيخ، حابّين نْشوفو مارة مَنَّك\". ");
INSERT INTO arq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","جاوَبهُم وقالَلهُم: \"جيل دوني وخايَن يْحَوَّس مارة، ما تَتَّعطالو حَتّى مارة من غير مارة يونان النَبي. ");
INSERT INTO arq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","خاطَر كيما كان يونان في كَرش حوتة كْبيرة تَلت أيّام وتَلت لْيالي، هَكداك يْكون بْن الإنسان في قَلب الأرض تَلت أيّام وتَلت لْيالي. ");
INSERT INTO arq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","رْجال نينَوى رايحين يْنوضو في وَقت الحْساب مع هاد الجيل ويَحَّكمو عليه خاطَر هومَ تابو كي بَرَّحَلهُم يونان، وهاو هْنا اللي كْتَر من يونان. ");
INSERT INTO arq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","سَلطانة الجَنوب تْنوض في وَقت الحْساب مع هاد الجيل وتَحكُم عليه، خاطَر هيَ جات من طَرف الدَنيا باش تْشوف العْقَل مْتاع سُلَيمان، وهاو هْنا اللي كْتَر من سُلَيمان. ");
INSERT INTO arq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","كي يَخرُج الروح الناجَس من بْنادَم، يْجوز في مْضارَب الخْلا اللي ما فيهُمش الما، يْحَوَّس على الراحة وما يَلقاش، ");
INSERT INTO arq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","هِمّالا يْقول: \"نَرجَع لداري اللي خْرَجت مَنها\". وكي يْجي، يَلقاها فارغة ومَكنوسة ومْسَڤّمة، ");
INSERT INTO arq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","داك الساع يْروح ويْجيب معاه سَبَع أرواح واحَدُخرين مَشرارين كْتَر مَنّو، ويَدُّخلو ويَسُّكنو تَمّة، وتْوَلّي الحالة الأخّرانِيّة مْتاع هَداك الإنسان كْتَر من اللي كانَت مع الأَوَّل. وهَكدا يَصرا تاني لهاد الجيل الدوني. ");
INSERT INTO arq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","وكي كان يَسوع مازالو يَهدَر مع الغاشي، هاو وين يَمّاه وخاوتو وَقفو بَرّا يْحَوّسو يَهَّدرو مْعاه. ");
INSERT INTO arq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","قاللو واحَد: \"هامليك يَمّاك وخاوتَك راهُم واقفين بَرّا يْحَوّسو يَهَّدرو معاك\"، ");
INSERT INTO arq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","جاوَب هُوَ وقال للي هْدَر معاه: \"شْكون هيَ يَمّا وشْكون هومَ خاوتي؟\" ");
INSERT INTO arq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ومَد يَدّو للتابعين مْتاعو وقال: \"هامليك يَمّا وخاوتي، ");
INSERT INTO arq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","خاطَر اللي يْدير مُراد بابا اللي فالسْما، هَداك هُوَ خويَ وخْتي ويَمّا\". ");
INSERT INTO arq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","في هَداك اليوم، خْرَج يَسوع من الدار وقْعَد قُدّام البْحَر، ");
INSERT INTO arq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","وتْلَم عليه غاشي كْبير حَتّى طْلَع لفْلوكة وقْعَد. والغاشي كامَل بْقا على الشَط. ");
INSERT INTO arq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","هْدَر معاهُم بَزّاف بالمْتال وقال: \"واحَد الفَلاّح خْرَج باش يَزْرَع، ");
INSERT INTO arq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","وكي كان يَزْرَع، طاحَت شْويّة زَرّيعة على الطْريق، وجاو الزْواوَش وكْلاوها؛ ");
INSERT INTO arq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","وطاحَت شْويّة على مْدارَب فيهُم الحْجَر، وين ما كانش تْراب بَزّاف، وبالخَف ناضَت خاطَر ما لْقاتش الأَرض غامقة، ");
INSERT INTO arq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","كي طَلعَت الشَمس، نْحَرقَت، ويَبسَت خاطَر ما كانش عَندها العْروق؛ ");
INSERT INTO arq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","وطاحَت شْويّة منها فالشوك، طْلَع الشوك وخْنَقها؛ ");
INSERT INTO arq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","وشْويّة منها طاحَت فالأَرض المْليحة، وعْطات غَلّة، وكايَن اللي عْطات مْية، واحَدُخرى سَتّين وواحَدُخرى تْلاتين. ");
INSERT INTO arq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","اللي عَندو وَدنين، غير يَسمَع\". ");
INSERT INTO arq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","جاو ليه التابعين وقالولو: \"وَعلاش تَهدَر معاهُم بالمْتال؟\" ");
INSERT INTO arq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","جاوَب هُوَ وقالَلهُم: \"خاطَر أنتومَ أتَّعطالكُم باش تَعَّرفو سْرار مَلَكوت السْما، بَصَّح هومَ ما أتَّعطالهُمش. ");
INSERT INTO arq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","خاطَر اللي عَندو، يَتمَدّلو ويَنزادلو، بَصَّح اللي ما عَندوش، حَتّى اللي عَندو يَتنَحّالو. ");
INSERT INTO arq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","على هَدا نَهدَر معاهُم بالمْتال، خاطَر شايفين ما يْشوفوش، وسامعين ما يَسَّمعوش وما يَفَّهموش. ");
INSERT INTO arq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","وفيهُم تَمَّت النُبُوّة مْتاع إشعِيا اللي تْقول: \"قَد ما تَسَّمعو ما تَفَّهموش، وقَد ما تَخَّزرو ما تْشوفوش. ");
INSERT INTO arq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","خاطَر قَلب هاد الشَعب قْسا، سَدّو وَدنيهُم، وغَمّضو عينيهُم، يْعودو يْشوفو بعينيهُم، ويَسَّمعو بوَدنيهُم، ويَفَّهمو بقْلوبهُم، ويْتوبو ونَشفيهُم.\" ");
INSERT INTO arq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","بَصَّح يا سَعد عينيكُم، خاطَر يْشوفو، ووَدنيكُم خاطَر يَسَّمعو. ");
INSERT INTO arq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","خاطر نْقولَلكُم الصَح، أَنبيا وصالحين بَزّاف تْشَهّاو يْشوفو واش راكُم تْشوفو وما شافوش، ويَسَّمعو واش راكُم تَسَّمعو وما سَمعوش. ");
INSERT INTO arq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","هِمّالا أَسَّمعو أنتومَ المْتَل مْتاع الفَلاّح: ");
INSERT INTO arq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","كُل مَن يَسمَع كَلمة المَلَكوت وما يَفهَمش، يْجي الدوني ويَخطَف الشي اللي تْنَزرَع في قَلبو، هَدا هُوَ المَزروع على الطْريق؛ ");
INSERT INTO arq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","والمَزروع فالمْدارَب اللي فيهُم الحْجَر، هُوَ اللي يَسمَع الكَلمة وبالخَف يَقبَلها بالفَرحة، ");
INSERT INTO arq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","بَصَّح ما عَندوش فيه العْروق، وما يَتبَتش، وغير تْجي الشَدّة وَلاّ الحُڤرة على جال الكَلمة، يَعتَر؛ ");
INSERT INTO arq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","بَصَّح المَزروع فالشوك، هُوَ اللي يَسمَع الكَلمة، وهَم هاد الدَنيا وغْواية خيرها يَخَّنقو الكَلمة وما تَعطيش الغَلّة؛ ");
INSERT INTO arq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","بَصَّح المَزروع فالأَرض المْليحة، هُوَ اللي يَسمَع الكَلمة ويَفهَم، هُوَ اللي يْجيب الغَلّة، واحَد مْية، واحَدآخُر سَتّين وواحَدآخُر تْلاتين\". ");
INSERT INTO arq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","وزاد عْطالهُم مْتَل واحَدآخُر وقال: \"مَلَكوت السْما يْشَبَّه لواحَد زْرَع زَرع مْليح فالحوش مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","وكي كانو الناس راقدين، جا العْدو مْتاعو وزْرَع الزْوال في وَسط القَمح وراح. ");
INSERT INTO arq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","كي ناضَت الحْشيشة، وجابَت غَلّة، داك الوَقت بان الزْوال تاني. ");
INSERT INTO arq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","جاو الخَدّامين مْتاع مول الدار وقالولو: \"يا سيدي، ماشي زْرَعت فالحوش مْتاعَك زَرع مْليح؟ كيفاش هِمّالا كايَن فيه الزْوال؟\" ");
INSERT INTO arq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","جاوَبهُم: \"عْدو اللي دار هاد الشي\"، قالولو الخَدّامين: \"تْحَب نْروحو نْلَمّوه؟\" ");
INSERT INTO arq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","جاوَبهُم: \"لالا، تْعودو وأنتومَ تْلمّو فالزْوال، تْقَلّعو القَمح معاه تاني، ");
INSERT INTO arq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","خَلّيوهُم يَكَّبرو في زوج كيف كيف حَتّى للحْصاد، وفي وَقت الحْصاد، نْقول للحَصّادين: \"لَمّو قْبَل الزْوال وأَرَّبطوه رْباطي رْباطي باش يَتَّحرَق، بَصَّح القَمح لَمّوه فالمَخزَن مْتاعي.\"\" ");
INSERT INTO arq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","وعْطالهُم مْتَل واحَدآخُر وقال: \"مَلَكوت السْما يْشَبَّه لحَبّة مْتاع الخَردَل، أَدّاها بْنادَم وزْرَعها فالحوش مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","هيَ الصْغيرة فالزَرّيعة كامَل، بَصَّح كي تْنوض، هيَ الكْبيرة فالحْشاوَش، وتْوَلّي سَجرة حَتّى طْيور السْما يْجيو يْديرو عْشوش في غْصانها.\" ");
INSERT INTO arq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","قالَلهُم مْتَل واحَدآخُر: \"مَلَكوت السْما يْشَبَّه لخْميرة، أَدّاتها مْرا ودارَتها في تَلت كيلات دْقيق حَتّى خْمَر كُل شي.\" ");
INSERT INTO arq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","قال يَسوع هاد الشي كامَل للغاشي بالمْتال، وما كانش يَهدَر معاهُم بلا مْتال، ");
INSERT INTO arq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","باش يْتَم كْلام النَبي اللي قال: \"نْحَل فَمّي بمْتال، ونْخَبَّر بحاجات كانو مْخَبّيين من اللي تْخَلقَت الدَنيا.\" ");
INSERT INTO arq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","داك الساع، خَلاّ يَسوع الغاشي وراح للدار. قَرّبو ليه التابعين مْتاعو وقالو: \"فَسَّرلنا المْتَل مْتاع زْوال الحوش.\" ");
INSERT INTO arq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","جاوَب وقال: \"اللي يَزرَع الزَرع المْليح هُوَ بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","الحوش هُوَ الدَنيا، الزَرع المْليح هومَ وْلاد المَلَكوت، الزْوال هومَ وْلاد الحيلي، ");
INSERT INTO arq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","العْدو اللي زَرعو هُوَ إبليس. والحْصاد هُوَ الآخرة، والحَصّادين هومَ المَلايكة، ");
INSERT INTO arq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","وكيما يَتلَم الزْوال بالدات ويَتَّحرَق كامَل فالنار، هَكدا يْكون في الآخرة، ");
INSERT INTO arq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","بْن الإنسان يَبعَت المَلايكة مْتاعو ويْنَحّيو من المَلَكوت مْتاعو كامَل سْبايَب العَترة واللي يْديرو الشَر، ");
INSERT INTO arq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ويَرميهُم في نار لاهبة قاوية وين يْكون البْكا وغَز السْنان. ");
INSERT INTO arq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","داك الوَقت، الصالحين يَبَّرقو كي الشَمس في مَلَكوت باباهُم. اللي عَندو وَدنين، غير يَسمَع.\" ");
INSERT INTO arq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","مَلَكوت الله يْشَبَّه لكَنز مْخَبّي في حوش، لْقاه بْنادَم، خبَّاه، ومن الفَرحة مْتاعو راح وباع كامَل واش عَندو وشْرا هَداك الحوش. ");
INSERT INTO arq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","مَلَكوت الله يْشَبَّه تاني لتاجَر، كان يْحَوَّس على الجوهَر الشْباب، ");
INSERT INTO arq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","كي لْقا جوهرة غالية، راح باع كامَل واش كان عَندو وشْراها. ");
INSERT INTO arq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","مَلَكوت السْما يْشَبَّه تاني لشَبكة مَرمِيّة فالبْحَر، رَفدَت الحوت من كُل نوع، ");
INSERT INTO arq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","كي تْعَمّرَت، طَلّعوها للشَط وقَعدو يْلَمّو الحوت المْليح فالقْفَف والفاسَد يَرميوَه. ");
INSERT INTO arq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","هَكدا يْكون في الآخرة، يَخُّرجو المَلايكة ويْفَرّقو المَشرارين على الصالحين، ");
INSERT INTO arq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ويَرميوهُم في نار لاهبة قاوية وين يْكون البْكا وغَز السْنان. ");
INSERT INTO arq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","فْهَمتو هاد الشي كامَل؟\" جاوبوه: \"إيه\". ");
INSERT INTO arq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","قالَلهُم: \"على هَدا، كُل كاتَب يْولّي تابَع يَتعَلَّم الشي اللي يْخَص مَلَكوت السْما يْشَبَّه لواحَد مولى دار، يَجْبَد من الكَنز مْتاعو حاجات جْدَد وحاجات قْدَم.\" ");
INSERT INTO arq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","كي كَمَّل يَسوع هاد المْتال، راح من تَم. ");
INSERT INTO arq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","وراح لبْلادو، وكان يْدَرَّسهُم في مْجامَعهُم، حَتّى دَهشو وقالو: \"مْنين جاه هاد العْقَل وهاد المُعجِزات؟ ");
INSERT INTO arq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ماشي هَدا وْليد النَجّار؟ وماشي يَمّاه واسَمها مَريَم وخاوتو يَعقوب ويوسَف وسَمعان ويَهودا؟ ");
INSERT INTO arq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","وماشي خْواتاتو كامَل راهُم عَندنا؟ هِمَّالا مْنين جاه هاد الشي كامَل؟\" ");
INSERT INTO arq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","وكان ليهُم سْبَب عَترة. يَسوع قالَلهُم: \"ما يْكون النَبي مَحڤور غير في بْلادو وفي دارو\"، ");
INSERT INTO arq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","وما دارش تَمّة مُعجِزات بَزّاف على جال قَلّة إيمانهُم. ");
INSERT INTO arq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","في داك الوَقت، سْمَع هيرودَس حاكَم الرُبع بخْبَر يَسوع، ");
INSERT INTO arq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","وقال للخَدّامين مْتاعو: \"هَدا يوحَنّا المَعمَدان، راهو قام من بين الموتى، على هَدا راهُم يَندارو على يَدّو المُعجِزات. ");
INSERT INTO arq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","خاطَر هيرودَس كان حْكَم يوحَنّا وكَتّفو وحَطّو فالحَبس على جال هيرودِيّا مَرت خوه فيلِبّس، ");
INSERT INTO arq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","خاطَر يوحَنّا كان يْقوللو: \"ما يْجوزلَكش باش تْكون مَرتَك.\" ");
INSERT INTO arq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","حَب هيرودَس يَقُّتلو بَصَّح خاف من الغاشي خاطَر كانو يْشوفو يوحَنّا نَبي. ");
INSERT INTO arq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","في عيد ميلاد هيرودَس، شَطحَت بَنت هيرودِيّا وَسط الضْياف وعَجبَت هيرودَس، ");
INSERT INTO arq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","على هَدا حْلَفَّلها باليْمين باللي يَعطيلها واش تَطلَب. ");
INSERT INTO arq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","هيَ بَعد ما قَرّاتها يَمّاها قالَتلو: \"أَعطيني دُرك في طَبسي راس يوحَنّا المَعمَدان.\" ");
INSERT INTO arq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","حْزَن السَلطان، بَصَّح على جال اليْمين مْتاعو والضْياف، آمَر باش يَعطيوَلها واش طَلبَت، ");
INSERT INTO arq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","وبْعَت يْقَطَّع راس يوحَنّا فالحَبس. ");
INSERT INTO arq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","جابو راسو في طَبسي وعْطاوَه للطَفلة وهيَ أَدّاتو ليَمّاها. ");
INSERT INTO arq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","جاو التابعين مْتاعو، أَدّاو داتو ودَفنوه، وراحو يْخَبّرو يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","كي سْمَع يَسوع، بَعَّد من تَمّة في فْلوكة في مْكان خالي على جيه، وكي سْمَع بيه الغاشي، تَبّعوه على رَجليهُم من المْدايَن. ");
INSERT INTO arq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","وكي خْرَج، شاف غاشي كْبير وشْفَق عليهُم وشْفا المَرضى مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","كي جات العْشيّة، جاو ليه التابعين مْتاعو وقالو: \"هاد المْكان خالي وراح الحال، سَرَّح الغاشي باش يْروحو للدْشور يَشريو الماكلة لرْواحهُم\"، ");
INSERT INTO arq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","قالَلهُم يَسوع: \"ما يَسَّحقوش يْروحو، أَعطيوَلهُم أَنتومَ ياكلو\"، ");
INSERT INTO arq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","قالولو: \"ما عَندنا هْنا غير خَمس خُبزات وزوج حوتات\"، ");
INSERT INTO arq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","قالَلهُم: \"جيبوهُملي اللَهنا\". ");
INSERT INTO arq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","آمَر يَسوع الغاشي باش يَقُّعدو على الحْشيش، وخْدا الخَمس خُبزات والزوج حوتات وطَلَّع عينيه للسْما، بارَك وقْسَم وعْطا الخُبز للتابعين والتابعين عْطاوهُم للغاشي. ");
INSERT INTO arq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","كْلاو كامَل وشَبعو، ورَفدو الطْراف اللي بْقاو: طْناشَن سَلّة مْعَمّرة. ");
INSERT INTO arq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","الناس اللي كْلاو كانو واحَد الخَمس آلاف راجَل بْلا النْسا والدْراري. ");
INSERT INTO arq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","تَم تَم، سَيَّف يَسوع على التابعين باش يَطَّلعو فالفْلوكة ويَسَّبقوه للجيهة الأُخرى بيدما هُوَ يْسَرَّح الغاشي. ");
INSERT INTO arq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","بَعدما سَرَّح الغاشي، طْلَع للجْبَل باش يْصَلّي على جيه. كي طاح الليل، كان وَحدو تَمّة. ");
INSERT INTO arq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","كانَت الفْلوكة بَعّدَت بَزّاف على الأَرض، والأمواج يَضَّربو فيها، خاطَر كانَت مْعاكسة للريح. ");
INSERT INTO arq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","وقْبَل ما يْطلَع الفْجَر، وْصَل يَسوع ليهُم وهُوَ يَمشي على البْحَر. ");
INSERT INTO arq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","كي شافوه التابعين يَمشي على البْحَر، تْهَوّلو وقالو باللي هَدا روحاني، ومن الخوف، بْداو يْعَيّطو. ");
INSERT INTO arq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","تَم تَم كَلَّمهُم يَسوع وقال: \"تيقو، أنا هُوَ، ما تْخافوش.\" ");
INSERT INTO arq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","جاوبو بُطرُس وقال: \"يا رَب، وَلاّ أَنتَ هوَ، آمَرني باش نْجي لعَندَك على الما\". ");
INSERT INTO arq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","قاللو يَسوع: \"أَرواح\". هْبَط بُطرُس من الفْلوكة ومْشا على الما وراح عَند يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","كي شاف الريح قْوي، خاف وغير بْدا يَغرَق عَيَّط وقال: \"يا رَب، سَلَّكني\"، ");
INSERT INTO arq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","تَم تَم، مَد يَسوع يَدّو، شَدّو وقاللو: \"يا قْليل الإيمان، وَعلاش شَكّيت؟\" ");
INSERT INTO arq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","وكي طَلعو للفْلوكة، هْدَن الريح، ");
INSERT INTO arq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","واللي كانو فالفْلوكة سَجدو ليَسوع وقالو: \"صَح أَنتَ بْن الله.\" ");
INSERT INTO arq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","وكي قَطعو البْحَر، جاو لأَرض جَنِّسارَت. ");
INSERT INTO arq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","كي عَرفو رْجال هَداك المْكان يَسوع، بَعتو لكامَل الجْوايَه اللي دايرين بتَمّة وجابولو كامَل المَرضى، ");
INSERT INTO arq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","وطَلبو مَنّو باش يْمَسّو غير الجْلال مْتاع لْباسو وكامَل اللي مَسّوه بْراو كيما لازَم. ");
INSERT INTO arq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ديك الساعة، جاو ليَسوع فَرّيسِيّين وكُتّاب من أورشَليم وقالو: ");
INSERT INTO arq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"وَعلاش التابعين مْتاعَك يَتعَدّاو على عادة القْدَم، خاطَر ما يَغَّسلوش يَدّيهُم قْبَل ما ياكلو؟\" ");
INSERT INTO arq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","جاوَب يَسوع وقالَلهُم: \"وَعلاش أَنتومَ تاني تَتعَدّاو على وْصيّة الله على جال عادَتكُم؟ ");
INSERT INTO arq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","خاطَر الله قال: \"كَرَّم باباك ويَمّاك، واللي يْسَب باباه وَلاّ يَمّاه يَتعاقَب بالموت\"، ");
INSERT INTO arq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","بَصَّح أنتومَ تْقولو: \"اللي يْقول لباباه وَلاّ ليَمّاه: \"اللي كُنت قادَر نْعاونَك بيه نْمدّو هِبة للرَب\"، ");
INSERT INTO arq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ماشي مَلزوم باش يْكَرَّم باباه ولاّ يَمّاه\"، وبَطَّلتو كَلمة الله على جال عادَتكُم. ");
INSERT INTO arq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","مُنافقين، إشعِيا تْنَبَّأ عليكُم مْليح كي قال: ");
INSERT INTO arq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","\"هاد الشَعب يْكَرَّمني بالفُم، بَصَّح قَلبهُم بْعيد عليَّ بَزّاف، ");
INSERT INTO arq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","يَعَّبدوني في باطَل وهومَ يْعَلّمو حاجات من حْكام بْني آدَم ماشي من حْكام الله.\"\" ");
INSERT INTO arq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","وعَيَّط يَسوع للغاشي وقالَلهُم: \"أَسَّمعو وأَفَّهمو، ");
INSERT INTO arq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ماشي اللي يَدخُل فالفَم اللي يْنَجَّس بْنادَم، اللي يَخرُج من الفَم، هَدا اللي يْنَجَّس بْنادَم\"، ");
INSERT INTO arq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","داك الوَقت أَدَّناو التابعين وقالولو: \"راك عارَف باللي الفَرّيسِيّين كي سَمعو كْلامك، ما عْجَبهُمش الحال؟\" ");
INSERT INTO arq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","جاوَبهُم: \"كُل نَبتة ما غْرَسهاش بابا السْماوي تَتقَلَّع، ");
INSERT INTO arq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","خَلّيوهُم، عَميين يْڤَوّدو عَميين. لوكان عْمى يْڤَوَّد عْمى، في زوج يْطيحو في حُفرة\". ");
INSERT INTO arq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","قاللو بُطرُس: \"فَسَّرلنا هاد المْتَل\"، ");
INSERT INTO arq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","قال يَسوع: \"أَنتومَ تاني حَتّى لدُرك ما فْهَمتوش؟ ");
INSERT INTO arq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ما تَفَّهموش باللي كُل شي يَدخُل فالفَم يَهبَط للكَرش أومبَعد يَتَّرما لبَرّا؟ ");
INSERT INTO arq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","بَصَّح اللي يَخرُج من الفَم، يْجي من القَلب وهَدا اللي يْنَجَّس بْنادَم. ");
INSERT INTO arq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","خاطَر من القَلب اللي يْجيو الفْكايَر الدونِيّين، القْتَل، الزِنا، الفَسق، السَرقة، شْهادة الزور والنَميمة. ");
INSERT INTO arq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","هاو واش يْنَجَّس بْنادَم، بَصَّح الماكلة بيَدّين ماشي مَغسولين ما تْنَجَّسش بْنادَم\". ");
INSERT INTO arq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","خْرَج يَسوع من تَمّة وجا لجْوايَه صور وصَيدا، ");
INSERT INTO arq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","وهاي وين مْرا كَنعانيّة خَرجَت من هَدوك الجْوايَه تْعَيَّط وتْقول: \"أَرحَمني يا رَب، يا وْليد داوَد، بَنتي مَسكونة بشيطان يْعَدَّبها بَزّاف\"، ");
INSERT INTO arq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","بَصَّح هُوَ ما جاوَبها بحَتّى كَلمة. أَدَّنّاو ليه التابعين مْتاعو وطَلبو مَنّو وقالو: \"سَرَّحها خاطَر راهي غير تْعَيَّط مورانا\"، ");
INSERT INTO arq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","جاوَب يَسوع وقال: \"أنا ما جيت مَبعوت غير للخَرفان الضايعين مْتاع دار إسرائيل\"، ");
INSERT INTO arq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","وهيَ جات، سَجدَتلو وقالَت: \"يا رَب، عاوَنّي\"، ");
INSERT INTO arq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","جاوَب هُوَ وقالَلها: \"ماشي مْليح ناخدو الخُبز مْتاع الدراري ونَرميوَه للكْلاب الصْغار\"، ");
INSERT INTO arq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","قالَتلو: \"إيه يا رَب، بَصَّح الكْلاب الصْغار ياكلو من الفْتات اللي يْطيح من ميدة سْيادهُم\"، ");
INSERT INTO arq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","هِمّالا جاوَب يَسوع وقالَلها: \"آه يا مْرا، إيمانَك كْبير، يَندارلَك الشي اللي حَبّيتيه\"، وشْفا بَنتها في هَديك الساعة. ");
INSERT INTO arq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","راح يَسوع من تَمّة وجا لشَط بْحَر الجْليل وطْلَع للجْبَل وقْعَد تَمّة. ");
INSERT INTO arq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","وجا ليه غاشي كْبير ومعاهُم كَعوانين وعَميين ومَشلولين وعْڤاڤنة ومَرضى واحَدُخرين بَزّاف، حَطّوهُم عَند رَجليه وهُوَ شْفاهُم، ");
INSERT INTO arq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","حَتّى سْتَعجَب الغاشي بَزّاف وهومَ يْشوفو العْڤاڤنة يَهَّدرو، المَشلولين يَبراو، والكَعوانين يَمشيو مْسَڤَّم والعَميين يْشوفو وسَبّحو إلَه إِسرائيل. ");
INSERT INTO arq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","عَيَّط يَسوع للتابعين مْتاعو وقالَلهُم: \"غاضني هاد الغاشي بَزّاف خاطَر عَندهُم تَلت أيّام وهومَ باقيين معايَ وما عَندهُمش واش ياكلو، وما رانيش حاب نْخَلّيهُم يْروحو صايمين يْعودو يْطيحو فالطْريق\"، ");
INSERT INTO arq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","قالولو التابعين: \"وين نَلقاو في هاد الخْلا خُبز يَكفي باش يْشَبَّع غاشي كيما هَدا؟\" ");
INSERT INTO arq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","قالَلهُم يَسوع: \"شْحال من خُبزة عَندكُم؟\" قالولو: \"سَبعة وشْويّة حوت صْغير\". ");
INSERT INTO arq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","وآمَر يَسوع الغاشي باش يَقَّعدو فالأَرض. ");
INSERT INTO arq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","شَد السْبَع خُبزات والحوت، وبَعدما حْمَد، قْسَم الخُبز وعْطاه للتابعين وهومَ فَرّقوه للغاشي. ");
INSERT INTO arq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","كامَل كْلاو وشَبعو، ورَفدو التابعين سَبع سْلَل مْعَمّرين بطْراف الخُبز اللي بْقا. ");
INSERT INTO arq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","اللي كْلاو كانو رَبع آلاف راجَل بلا النْسا والدْراري. ");
INSERT INTO arq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","وبَعد ما سَرَّح الغاشي، طْلَع يَسوع فالفْلوكة وراح لجْوايَه مَجدان. ");
INSERT INTO arq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","جاو الفَرّيسِيّين والصَدّوقِيّين لعَند يَسوع باش يْجَربوه وطَلبو مَنّو يْوَرّيلهُم مارة من السْما. ");
INSERT INTO arq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","جاوَب يَسوع وقالَلهُم: \"كي تَوصَل العْشية تْقولو، الحال رايَح يْكون شْباب خاطَر السْما راهي حَمرة، ");
INSERT INTO arq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","والصْباح، اليوم تْصَب الشْتا خاطَر لون السْما حْمَر غامَق. من جيهة تَعَّرفو تْمَيّزو حال السْما ومن جيهة أخرى ما تَعَّرفوش تْمَيّزو مارات الزْمان، ");
INSERT INTO arq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","جيل دوني وخايَن يْحَوَّس على مارة، ما تَتَّعطالو حَتّى مارة من غير مارة يونان النَبي\"، أومبَعد خَلاّهُم وراح. ");
INSERT INTO arq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","وكي قَطعو التابعين للجيهة الأخرى مْتاع الواد، نْساو يَدّيو معاهُم الخُبز. ");
INSERT INTO arq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","قالَلهُم يَسوع: \"حَلّو عينكُم ورَدّو بالكُم من الخْميرة مْتاع الفَرّيسِيّين والصَدّوقِيّين\"، ");
INSERT INTO arq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","التابعين خَمّمو في قْلوبهُم وقالو: \"خاطَر ما أَدّيناش الخُبز\". ");
INSERT INTO arq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","عْرَف يَسوع واش كانو يْخَمّمو وقال: \"وَعلاش راكُم تْخَمّمو في قْلوبكُم يا قْلال الإيمان، باللي ما عَندكُمش الخُبز؟ ");
INSERT INTO arq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","مازال ما تَفَّهموش وما تَشفاوش الخَمس خُبزات مْتاع الخَمس آلاف راجَل وشْحال من سَلّة أَدّيتو، ");
INSERT INTO arq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","وَلاّ السْبَع خُبزات مْتاع الرَبع آلاف وشْحال من سَلّة أَدّيتو؟ ");
INSERT INTO arq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","كيفاش ما تَفَّهموش باللي ماشي على الخُبز اللي قُلتَلكُم رَدّو بالكُم من الخْميرة مْتاع الفَرّيسِيّين والصَدّوقِيّين؟\" ");
INSERT INTO arq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","داك الساع فَهمو باللي ماشي على الخْميرة مْتاع الخُبز اللي قال رَدّو بالكُم بَصَّح من التَعليم مْتاع الفَرّيسِيّين والصَدّوقِيّين. ");
INSERT INTO arq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","كي راح يَسوع لجْوايَه قَيصريّة فيليبُّس، سَقسا التابعين مْتاعو وقال: \"على حْساب الناس، واش يْكون بْن الإنسان؟\" ");
INSERT INTO arq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","جاوبوه: \"كايَن اللي يْقولو يوحَنّا المَعمَدان، واحَدُخرين إيليّا، وواحَدُخرين إرميا وَلاّ واحَد من الأَنبيا\"، ");
INSERT INTO arq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","قالَلهُم: \"وأنتومَ، شْكون تْقولو باللي أنا؟\" ");
INSERT INTO arq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","جاوَب سَمعان بُطرُس وقال: \"أنتَ المَسيح بْن الله الحَيّ\"، ");
INSERT INTO arq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","جاوَب يَسوع وقاللو: \"يا سَعدَك يا سَمعان بَن يونا، خاطَر ماشي اللْحَم والدَم اللي بَيَّنولَك هاد الشي بَصَّح بابا اللي فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","وأنا نْقوللَك باللي أنتَ بُطرُس (بُطرُس مَعنَتها حَجرة) وعلى هاد الحَجرة نَبني كَنيستي وبيبان جَهَنَّمة ما يَقَّدروش عليها. ");
INSERT INTO arq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","نَعطيلَك مْفاتَح مَلَكوت السْما، اللي تَرَّبطو على الأرض يْكون مَربوط فالسْما، واللي تْحَلّو على الأرض يْكون مَحلول فالسْما.\" ");
INSERT INTO arq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","داك الساع آمَر التابعين مْتاعو ما يْقولو لحَتّى واحَد باللي هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ومن هَداك الوَقت بْدا يَسوع يْدَرَّس التابعين مْتاعو باللي لازَم يْروح لأورشَليم ويَتعَدَّب بَزّاف على يَد الشْيوخ ورِيّاس رْجال الدين والكُتّاب، ويْنَقتَل وفاليوم التالَت يْقوم. ");
INSERT INTO arq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","جَبدو بُطرُس على جيه وبْدا يْلوم فيه ويْقول: \"يا رَب، حاشا ما يَصرالَك هاد الشي\"، ");
INSERT INTO arq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","دار يَسوع وقال لبُطرُس: \"روح عليَّ يا شيطان، أنتَ تْعَتَّرني، خاطَر تَخمامَك ماشي تَخمام الله، تَخمامَك تَخمام بْني آدَم\". ");
INSERT INTO arq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","داك الوَقت قال يَسوع للتابعين مْتاعو: \"إيلا حَب واحَد يْجي يْتَبَّعني، لازَم يَنكُر نَفسو، يَرفَد صْليبو ويْتَبَّعني، ");
INSERT INTO arq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","إيه، خاطَر اللي يْحَب يْسَلَّك حْياتو يَخسَرها، بَصَّح اللي يَخسَر حْياتو على جالي يَلقاها. ");
INSERT INTO arq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","واش يَستفاد بْنادَم لو كان يَربَح الدَنيا كامَل ويَخسَر نَفسو؟ وَلاّ واش يَقدَر يْمَد بْنادَم باش يَربَح نَفسو؟ ");
INSERT INTO arq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","خاطَر بْن الإنسان رايَح يْجي في مَجد باباه مع المَلايكة مْتاعو، وداك الوَقت يْجازي كُل واحَد على حْساب فْعالو. ");
INSERT INTO arq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","نْقولَلكُم الصَح، من اللي راهُم هْنا، كايَن اللي ما يْدوقوش الموت قْبَل ما يْشوفو بْن الإنسان جاي فالمَلَكوت مْتاعو.\" ");
INSERT INTO arq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","سَت أيّام من بَعد، أدّا يَسوع معاه بُطرُس ويَعقوب ويوحَنّا خوه وطَلَّعهُم وَحَّدهُم لجْبَل عالي. ");
INSERT INTO arq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","وتْبَدَّل قُدّامهُم، وضْوا وَجهو كي الشَمس ووَلاّو حْوايجو بْيوضا كي النور. ");
INSERT INTO arq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","وهام وين ضَهرولهُم موسى وإيليّا يَهَّدرو مع يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","نْطَق بُطرُس وقال ليَسوع: \"يا رَب، مْليح لو كان نْكونو هْنا، وَلاّ حَبّيت، نْدير هْنا تَلت خْيَم، واحدة ليك، واحدة لموسى وواحدة لإيلِيّا.\" ");
INSERT INTO arq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ومابيد كان هُوَ يَهدَر، هاو وين سْحابة ضاوية ضَلّلَت عليهُم وصوت من السْحابة يْقول: \"هَدا وْليدي الحْبيب اللي هُوَ فَرحتي، أَسَّمعولو.\" ");
INSERT INTO arq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","كي سَمعو التابعين، طاحو ساجدين وخافو بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","أدَّنّا يَسوع، مَسّهُم وقال: \"نوضو وما تْخافوش\"، ");
INSERT INTO arq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","طَلّعو عينيهُم وما شافو حَتّى واحَد من غير يَسوع وَحدو. ");
INSERT INTO arq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","كي كانو هابطين من الجْبَل، آمَرهُم يَسوع وقال: \"ما تْقولو لحَتّى واحَد على اللي شَفتوه حَتّى يْقوم بْن الإنسان من بين الموتى\". ");
INSERT INTO arq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","سَقساوَه التابعين: \"وَعلاش هِمّالا يْقولو الكُتّاب باللي إيليّا هُوَ اللي يْجي الأَوَّل؟\" ");
INSERT INTO arq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","جاوَب يَسوع وقال: \"صَح إيليّا يْجي ويْسَڤَّم كُل شي، ");
INSERT INTO arq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","بَصَّح نْقولَلكُم، إيلِيّا جا وما عَرفوهش ودارو فيه واش حَبّو، هَكدا تاني بْن الإنسان رايَح يَتعَدَّب على يَدّهُم.\" ");
INSERT INTO arq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","هِمّالا فَهمو التابعين باللي كان يَهدَرَّلهُم على يوحَنّا المَعمَدان. ");
INSERT INTO arq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","كي جا ليه الغاشي، جا واحَد الراجَل عَند يَسوع ورْكَعلو، ");
INSERT INTO arq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","وقال: \"سيدي، أَشفَق على وْليدي، عَندو الصْريع ويَتعَدَّب بَزّاف، شْحال من مَرّة يْطيح فالنار وشْحال من مَرّة فالما، ");
INSERT INTO arq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","جَبتو للتابعين مْتاعَك بَصَّح ما قَدروش يَشفيوَه\". ");
INSERT INTO arq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","جاوَب يَسوع وقال: \"جيل بْلا إيمان ومْعَوَّج، لوَقتاش نَبقا معاكُم؟ لوَقتاش نَرفَدكُم؟ جيبولي الوْلَد اللَهنا\". ");
INSERT INTO arq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","هَدَّد يَسوع الشيطان وخْرَج الشيطان من الوْلَد، وبْرا الوْلَد في هَديك الساعة بالدات. ");
INSERT INTO arq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","أومبَعد راحو التابعين عَند يَسوع وقالولو على جيه: \"وَعلاش ما قْدَرناش حْنا نْخَرّجو الشيطان؟\" ");
INSERT INTO arq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","قالَلهُم يَسوع: \"على جال قَلّة إيمانكُم. نْقولَلكُم الصَح، لو كان عَندكُم إيمان قيس حَبّة الخَردَل، لو كان تْقولو لهاد الجْبَل، روح من هْنا للهيه يْروح، وحاجة ما تْكون مُحال عَندكُم. ");
INSERT INTO arq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","كي تْلَمّو التابعين فالجْليل، قالَلهُم يَسوع: \"راهو قْريب يَتسَلَّم بْن الإنسان ليَدّين بْني آدَم، ");
INSERT INTO arq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ويَقَّتلوه بَصَّح فاليوم التالَت يْقوم\". والتابعين حَزنو بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","كي راحو لكَفرناحوم، جاو المَكّاسين لبُطرُس وقالولو: \"سيدكُم ما يْخَلَّصش الغْرامة؟\" ");
INSERT INTO arq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","قال: \"إيه\". وكي راح للدار، سَبقو يَسوع وقال: \"واش رايَك يا سَمعان؟ سْلاطَن الأَرض، من عَند من يَدّيو الغْرامة وَلاّ الجَزية؟ من وْلادهُم وَلاّ من البْراويّة؟\" ");
INSERT INTO arq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","جاوبو بُطرُس: \"من البْراويّة\". قاللو يَسوع: \"هِمّالا وْلاد البْلاد ماشي مَلزومين بيها. ");
INSERT INTO arq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","بَصَّح باش ما نْعَتّروهُمش، روح للبْحَر وأَرمي الصَنّارة، والحوتة اللي تَطلَع الأولى أَجبَدها، وغير تْحَلَّلها فَمّها، تَلقا دْراهَم قيس ما نْخَلّصو الغْرامة أنا ويّاك. أَدّيهُم وأعطيهُمَّلهُم قيسي وقيسَك\" ");
INSERT INTO arq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","في هَديك الساعة، جاو التابعين ليَسوع وقالو: \"شْكون هُوَ الكْبير في مَلَكوت السْما؟\" ");
INSERT INTO arq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","عَيَّط يَسوع لواحَد الوْلَد الصْغير، حَطّو في وَسطهُم، ");
INSERT INTO arq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","وقال: \"نْقولَلكُم الصَح، لو كان ما تَتبَدّلوش وتْوَلّيو كيما الدْراري الصْغار، ما تَدُّخلوش لمَلَكوت السْما، ");
INSERT INTO arq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","خاطَر اللي يْصَغَّر روحو كيما هاد الوْليَّد يْكون هُوَ الكْبير في مَلَكوت السْما، ");
INSERT INTO arq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","واللي يَستَقبَل وْلَد صْغير كيما هَدا على جال آسمي، يَستَقبَلني أنا، ");
INSERT INTO arq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","بَصَّح اللي يْطَيَّح واحَد من هاد الصْغار اللي يامنو بيَّ فالخْطِيّة، خيرلو لو كان عَلّقولو في رَقَّبتو حَجرة الرْحى وغَرّقوه في قاع البْحَر. ");
INSERT INTO arq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","يا ويل الدَنيا من العَترات، خاطَر لازَم يْكونو العَترات بَصَّح يا ويلو الإِنسان اللي يْكون السَبّة فالعَترة. ");
INSERT INTO arq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","وَلاّ كانَت يَدَّك وَلاّ رَجلَك تْعَتّرَك يَعني تْطَيّحَك فالخْطِيّة، قَطَّعها وأَرميها بْعيد عْليك، خاطَر خيرلَك تَدخُل للحْياة بيَد وَلاّ رْجَل مْقَطّعة وَلا تْكون بزوج يَدّين وَلاّ زوج رَجلين وتَتَّرما فالنار الدايمة. ");
INSERT INTO arq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","وَلاّ كانَت عينَك تْعَتّرَك، قَلَّعها وأَرميها بْعيد عْليك، خاطَر خيرلَك تَدخُل للحْياة بعين واحدة، وَلا يْكونو عَندَك زوج عينين وتَتَّرما في نار جَهنَّمة. ");
INSERT INTO arq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","رَدّو بالكُم تَحَّڤرو واحَد من هاد الصْغار، خاطَر نْقولَلكُم المَلايكة مْتاعهُم فالسْما يْشوفو دايمًا وَجه بابا اللي فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","واش رايكُم، لو كان يْكون عَند راجَل مْيةن خْروف، ويَتبَحَّر واحَد مَنهُم، ما يْخَلّيش التَسعة وتَسعين الأُخرين فالجْبال ويْروح يْحَوَّس على اللي تْبَحَّر؟ ");
INSERT INTO arq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ولو كان يَلقاه، نْقولَلكُم الصَح، يَفرَح بيه كْتَر من فَرحتو بالتَسعة وتَسعين اللي ما تْبَحّروش. ");
INSERT INTO arq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","وهَكدا تاني، ماشي مُراد باباكم اللي فالسْما باش يْضيع واحَد من هاد الصْغار. ");
INSERT INTO arq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","وَلاّ غْلَط فيك خوك، روح ولومو بينَك وبينو هُوَ بَرك، وَلاّ سْمَعلَك راك رْبَحت خوك، ");
INSERT INTO arq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","بَصَّح وَلاّ ما سْمَعلَكش، أَدّي معاك واحَد وَلاّ زوج باش تْكون الدَعوة بشْهادة زوج شْهود وَلاّ تْلاتة. ");
INSERT INTO arq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","وَلا ما حَبش يَسمَعَّلهُم، قول للكَنيسة، ولوكان ما يْحَبش يَسمَع للكَنيسة تاني، يْوَلّي عَندَك كي الكافَر وَلاّ المَكّاس. ");
INSERT INTO arq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","نْقولَلكُم الصَح، اللي تَرَّبطوه على الأَرض يْكون مَربوط فالسْما واللي تْحَلّوه على الأرض يْكون مَحلول فالسْما، ");
INSERT INTO arq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ونْزيد نْقولَلكُم الصَح، إيلا تْفاهمو زوج منكُم على الأَرض باش يَطَّلبو حاجة، اللي يَطَّلبوه، يَوصَلَّلهُم من عَند بابا اللي فالسْما، ");
INSERT INTO arq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","خاطَر وين يَتلَمّو زوج وَلاّ تْلاتة بآسمي، نْكون في وَسطهُم\". ");
INSERT INTO arq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","داك الوَقت، جا ليه بُطرُس وقال: \"رَبّي، شْحال من مَرّة يَغلَط فِيَّ خويَ ونَسمَحلو؟ حَتّى لسْبَع مَرّات؟\" ");
INSERT INTO arq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","قاللو يَسوع: \"ما نْقوللَكش حَتّى لسْبَع مَرّات، بَصَّح حَتّى لسَبعين مَرّة سْبع مَرّات، ");
INSERT INTO arq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","على هَدا مَلَكوت السْما يْشَبَّه لسَلطان حَب يْحاسَب الخَدّامين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","وكي بْدا يْدير فالحْسابات، جابولو واحَد مَديون بعَشر آلاف ويزة، ");
INSERT INTO arq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","وكي ما كانش عَندو باش يْرَد الدين مْتاعو، آمَر سيدو باش يْبيعوه هُوَ ومَرتو ووْلادو وكامَل واش يَملَك باش يَترَد الدين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","رْكَع الخْديم وسْجَدلو وقال: \"أَصبَر علِيَّ ونْرَدّلَك كُل شي\". ");
INSERT INTO arq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","شْفَق سيد هاد الخْديم وطَلقو وسْمَحلو الدين. ");
INSERT INTO arq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","وكي خْرَج هاد الخْديم، تْلاقا مع واحَد من الخَدّامين اللي يَخَّدمو معاه وكان يْساللو مْيةن دينار. شَدّو وخَنقو وقاللو: \"رَدّلي واش نْساللَك\"، ");
INSERT INTO arq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","رْكَع الخْديم اللي يَخدَم معاه وحَلّلو وقال: \"أَصبَر عليَّ ونْرَدلَك كُل شي\". ");
INSERT INTO arq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","بَصَّح هُوَ ما حَبش وراح رْماه فالحَبس حَتّى يْرَد الدين. ");
INSERT INTO arq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","وكي شافو الخَدّامين اللي يَخَّدمو معاه واش صار، حَزنو بَزّاف وراحو حْكاو لسيدهُم كامَل واش صْرا، ");
INSERT INTO arq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","داك الساع عَيَّطلو سيدو وقاللو: \"يا الخْديم الدوني، سْمَحتلَك كامَل دينَك كي حَلَّلتني، ");
INSERT INTO arq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ماكانش لازَم عليك أَنتَ تاني تَشفَق على صاحبَك كيما شْفَقت عليك أَنا؟\" ");
INSERT INTO arq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","تْغَشَّش سيدو وسَلّمو للي يْعَدّبو حَتّى يْرَجَّع كامَل الدين اللي كان عليه. ");
INSERT INTO arq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","وهَكدا تاني يْديرَلكُم بابا السْماوي لو كان كُل واحَد فيكُم ما يَسمَحش من كُل قَلبو لخوه\". ");
INSERT INTO arq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","وكي كَمَّل يَسوع هاد الكْلام، راح من الجْليل وجا لجْوايَه اليَهوديّة مور واد الأُردُن. ");
INSERT INTO arq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","تَبّعو غاشي كْبير وشْفاهُم تَمّة. ");
INSERT INTO arq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","وجاو ليه الفَرّيسِيّين باش يْجَرّبوه وقالو: \"يْجوز للراجَل باش يْطَلَّق مَرتو على كاش سَبّة؟\" ");
INSERT INTO arq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","جاوَبهُم هُوَ وقال: \"ما قْريتوش باللي الخالَق فالبَدية دار الراجَل والمْرا؟ ");
INSERT INTO arq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","وقال: \"على هَدا، يْخَلّي الراجَل باباه ويَمّاه ويَلصَق في مَرتو والزوج يْوَلّيو دات واحدة\" ");
INSERT INTO arq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","وهَكدا ما يزيدوش يْكونو زوج بَصَّح دات واحدة، هِمّالا اللي لاقاه الله مالازَمش يْفَرّقو بْنادَم\". ");
INSERT INTO arq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","قالولو: \"هِمّالا وَعلاش آمَر موسى باش يَتمَد للمْرا وَرقة طْلاق وتَطَّلَّق؟\" ");
INSERT INTO arq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","قالَلهُم: \"على جال قْساوة قْلوبكُم اللي سْمَحَّلكُم موسى باش تْطَلّقو نْساكُم، بَصَّح فالأَصَل ما كانش هَكدا، ");
INSERT INTO arq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ونْقولَلكُم، اللي يْطَلَّق مَرتو من غير سَبّة الزِنا ويَتزَوَّج بواحَدُخرى راه يَزني\". ");
INSERT INTO arq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","قالولو التابعين مْتاعو: \"إيلا كان هَكدا آمَر الراجَل مع المْرا، هِمّالا خيرلو الواحَد ما يَتزَوَّجش\" ");
INSERT INTO arq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","قالَلهُم: \"ماشي كامَل يَقَّدرو يَفَّهمو هاد الكْلام، غير اللي مَعطَيَّتَّلهُم اللي يَفَّهموه، ");
INSERT INTO arq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","خاطَر كايَن المَخصِيّين اللي زادو هَكدا من كَرش يَمّاهُم، وكايَن اللي رَدّوهُم الناس مَخصِيّين وكايَن اللي رَدّو روحهُم مَخصِيّين على جال مَلَكوت السْما. اللي يَقدَر يَفهَم غير يَفهَم\". ");
INSERT INTO arq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","داك الوَقت جابولو دْراري صْغار باش يْدير يَدّيه عليهُم ويْصَلّيلهُم بَصَّح التابعين زْڤاو عليهُم. ");
INSERT INTO arq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","بَصَّح يَسوع قال: \"خَلّيو الدْراري الصْغار وما تَمَّنعوهُمش يْجيو لعَندي خاطَر مَلَكوت السْما للي بحالهُم\"، ");
INSERT INTO arq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ودار يَدّيه عليهُم وراح من تَمّة. ");
INSERT INTO arq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","وجا ليه واحَد وقال: \"شيخ، واشَن هُوَ المْليح اللي نْديرو باش تْكون لِيَّ الحْياة الدايمة؟\" ");
INSERT INTO arq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","قاللو: \"وَعلاش تْسَقسيني على المْليح؟ المْليح واحَد بَرك، وَلاّ حَبّيت تَدخُل للحْياة، طَبَّق الفْرايَض\"، ");
INSERT INTO arq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","قاللو: \"واش من الفْرايَض؟\" قال يَسوع: \"ما تُقتَلش، ما تَزنيش، ما تَسرَقش، ما تَشهَدش شْهادة الزور، ");
INSERT INTO arq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","كَرَّم باباك ويَمّاك وحَب قْريبَك كيما نَفسَك\". ");
INSERT INTO arq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","قاللو الراجَل: \"هَدو كامَل عْمَلتهُم، واش مازال يْخَصّني؟\" ");
INSERT INTO arq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","قاللو يَسوع: \"إيلا حَبّيت تْكون كامَل، روح وبيع مْلاكَك وأَعطي للڤْلالين ويْكون عَندَك كَنز فالسْما، وأرواح تَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","كي سْمَع الراجَل هاد الكْلام راح حْزين خاطَر كان عَندو مْلاك بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","وقال يَسوع للتابعين مْتاعو: \"نْقولَلكُم الصَح، صْعيب على المْرَفَّه باش يَدخُل لمَلَكوت السْما. ");
INSERT INTO arq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ونْقولَلكُم تاني، ساهَل على الجْمَل باش يْجوز من التُقبة مْتاع بْرة كْتَر من المْرَفَّه باش يَدخُل لمَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","وكي سَمعو التابعين هاد الشي، سْتَغربو بَزّاف وقالو: \"هِمّالا شْكون اللي يَقدَر يَسلَك؟\" ");
INSERT INTO arq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","شاف فيهُم يَسوع وقالَلهُم: \"هاد الشي مُحال عَند الناس بَصَّح عَند الله حَتّى حاجة ماهي مُحال\". ");
INSERT INTO arq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","داك الوَقت جاوَب بُطرُس وقاللو: \"هانا حْنا خَلّينا كُل شي وتَبَّعناك، واش تْكون دَعوَتنا؟\" ");
INSERT INTO arq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","قالَلهُم يَسوع: \"نْقولَلكُم الصَح، فالوَقت وين يَتجَدَّد كُل شي، كي يْكون بْن الإنسان قاعَد على عَرش المَجد مْتاعو، أنتومَ اللي تَبَّعتوني تْكونو تاني قاعدين على طْناشَن عَرش تْحاكمو العْشايَر الطْناش مْتاع إسرائيل. ");
INSERT INTO arq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","وكُل من خَلاّ على جال آسمي دْيار وَلاّ خاوة وَلاّ خْواتات وَلاّ بابات وَلاّ يَمّات وَلاّ دْراري وَلاّ حْواش، يْنال قيسهُم مْية مَرّة ويَورَت الحْياة الدايمة، ");
INSERT INTO arq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","بَزّاف الأوّلانِيّين اللي يْوَلّيو الأخّرانِيّين والأخّرانِيّين اللي يْوَلّيو الأوّلانِيّين.\" ");
INSERT INTO arq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","خاطَر مَلَكوت السْما يْشَبَّه لمولى دار، خْرَج من الصْباح باش يْجيب خَدّامين للدالية مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","تْفاهَم معاهُم على دينار فالنْهار، وبْعَتهُم للدالية مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","أومبَعد خْرَج جْوايَه التَسعة مْتاع الصْباح، ولْقا واحَدُخرين فالطَحطاحة بلا خَدمة، ");
INSERT INTO arq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","قالَلهُم: \"روحو أنتومَ تاني للدالية مْتاعي ونَعطيلكُم حَقّكُم\"، ");
INSERT INTO arq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","وراحو. وزاد خْرَج جْوايَه الطْناش وجْوايَه التْلاتة مْتاع العْشيّة ودار كيف كيف. ");
INSERT INTO arq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","خْرَج جْوايَه الخَمسة مْتاع العْشيّة ولْقا واحَدُخرين قاعدين وقالَلهُم: \"وَعلاش راكُم قاعدين هْنا نْهار كامَل بلا خَدمة؟\" ");
INSERT INTO arq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","قالولو: \"خاطَر حَتّى واحَد ما خَدَّمنا\". قالَلهُم: \"روحو أنتومَ تاني للدالية مْتاعي\". ");
INSERT INTO arq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","وكي طاح الليل، قال مول الدالية للوْكيل مْتاعو: \"عَيَّط للخَدّامين وأَعطيلهُم الخْلاص مْتاعهُم، أَبدا من الأخّرانِيّين حَتّى للأوّلانِيّين\". ");
INSERT INTO arq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","جاو مْتاع الخَمسة مْتاع العْشيّة وأدّاو كُل واحَد دينار، ");
INSERT INTO arq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","وجاو الأوّلانِيّين حاسبين يَدّيو كْتَر، بَصَّح أدّاو هومَ تاني كُل واحَد دينار. ");
INSERT INTO arq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","وكي كانو يَدّيو فالدْراهَم، كانو يْدَمدمو على مول الدار، ");
INSERT INTO arq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ويْقولو: \"هَدوك الأخّرانِيّين خَدمو غير ساعة واحدة وساويتهُم بينا حْنا اللي حْمَلنا القَسوة مْتاع النْهار والسْخانة.\" ");
INSERT INTO arq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","جاوَب مول الدار وقال لواحَد فيهُم: \"صاحبي، أنا ما ضْلَمتَكش، ماشي تْفاهَمت معايَ على دينار؟ ");
INSERT INTO arq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","أَدّي شَيَّك وروح، راني حاب نْمَد لهاد الأخّراني كيما أنتَ، ");
INSERT INTO arq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","وَلاّ ما يْجوزليش نْدير بشَيّي واش نْحَب؟ وَلاّ ما عَجبَكش الحال اللي أنا مْليح؟\" ");
INSERT INTO arq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","هَكدا الأخّرانِيّين يْولّيو الأوّلانِيّين والأوّلانِيّين يْولّيو الأخّرانِيّين.\" ");
INSERT INTO arq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","كي كان يَسوع طالَع لأورشَليم، أدّا التابعين مْتاعو في طْناش على جيه وقالَلهُم فالطْريق: ");
INSERT INTO arq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","\"رانا طالعين لأورشَليم، وبْن الإنسان رايَح يَتسَلَّم لرِيّاس رْجال الدين والكُتّاب، ويَحَّكمو عليه بالموت، ");
INSERT INTO arq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ويْسَلّموه للكُفّار باش يَتمَسخرو بيه ويَجَّلدوه ويَصَّلبوه، وفاليوم التالَت يْقوم\" ");
INSERT INTO arq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","داك الوَقت، قَرّبَت لعَندو يَمّاة وْلاد زَبَدي مع وْلادها وسَجدَت تَطلَب مَنّو حاجة. ");
INSERT INTO arq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","قالَلها: \"واش تْحَبّي؟\" قالَتلو: \"آمَر باش يَقُّعدو وْلادي هَدو في زوج فالمَلَكوت مْتاعَك، واحَد على اليْمنى مْتاعَك والآخُر على اليْسرى.\" ");
INSERT INTO arq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","جاوَب يَسوع وقال: \"ما راكُمش عارفين واش راكُم تَطَّلبو، تَقَّدرو تَشُّربو الكاس اللي راني رايَح نَشَّربو؟\" قالولو: \"نَقَّدرو.\" ");
INSERT INTO arq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","قالَلهُم: \"صَح رايحين تَشَّربو كاسي، بَصَّح القْعاد على يْميني وَلاّ على يْساري، ماشي أنا اللي نَقدَر نْمَدّو، وما يَتمَد غير للي بابا وَجَّدهولو.\" ");
INSERT INTO arq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","كي سَمعو التابعين العَشرة، تْغَشّشو من الخاوة الزوج. ");
INSERT INTO arq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","عَيَّطَّلهُم يَسوع وقال: \"راكُم عارفين باللي رِيّاس الأمّات يَتسَلّطو عليهُم والكْبار يْسيطرو عليهُم، ");
INSERT INTO arq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ما لازَمش يْكون هَكدا عَندكُم، بَصَّح اللي يْحَب يْوَلّي الكْبير فيكُم، لازَم يْكون خْديمكُم، ");
INSERT INTO arq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","واللي يْحَب يْكون الأوَّل فيكُم، لازَم يْكون عَبدكُم. ");
INSERT INTO arq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","كيما جا بْن الإنسان ماشي باش يَخَّدموه بَصَّح باش هُوَ يَخدَم ويَعطي حْياتو فَدية لبَزّاف.\" ");
INSERT INTO arq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","كي كان يَسوع والتابعين مْتاعو خارجين من أَريحا، تَبّعو غاشي كْبير، ");
INSERT INTO arq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","وهام وين زوج عَميين كانو قاعدين على طَرف الطْريق، سَمعو باللي يَسوع كان جايَز وبْداو يْعَيّطو ويْقولو: \"سيدنا، يا وْليد داوَد، أَشفَق علينا\" ");
INSERT INTO arq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","زْڤا عليهُم الغاشي باش يَسُّكتو، بَصَّح هومَ بْداو يْعَيّطو كْتَر ويْقولو: \"سيدنا، يا وْليد داوَد، أَشفَق علينا\" ");
INSERT INTO arq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","حْبَس يَسوع، عَيَّطَّلهُم وقال: \"واش حَبّيتو نْديرَلكُم؟\" ");
INSERT INTO arq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","قالولو: \"سيدنا، يَنحَلّو عينينا\"، ");
INSERT INTO arq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","شْفَق يَسوع، مَس عينيهُم وتَم تَم شافو وتَبّعوه. ");
INSERT INTO arq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","وكي قَرّبو لأورشَليم وجاو لبيت فاجي عَند جْبَل الزيتون، بْعَت يَسوع زوج تابعين، ");
INSERT INTO arq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","وقالَلهُم: \"أَدُّخلو للدَشرة اللي مْقابلَتكُم وتَم تَم تَلقاو حْمارة مَربوطة ومعاها حْمار صْغير، حَلّولهُم الرْباط وجيبوهُملي. ");
INSERT INTO arq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","وَلاّ كاش واحَد قالَلكُم حاجة، قولو باللي الرَب يَسحَقهُم، وتَم تَم يَبعَتهُم.\" ");
INSERT INTO arq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","هاد الشي صْرا باش يَتحَقَّق كْلام النَبي اللي قال: ");
INSERT INTO arq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","\"قولو لبَنت صَهيون: هاوليك سَلطانَك جاي ليك، مَتواضَع، راكَب على حْمارة، وحْمار صْغير وْليد حْمارة.\" ");
INSERT INTO arq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","راحو التابعين ودارو واش آمَرهُم يَسوع، ");
INSERT INTO arq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","وجابو الحْمارة والحْمار الصْغير وحَطّو عليهُم حْوايَجهُم ورَكّبو يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","الكُترة من الغاشي كانو يْفَرّشو حْوايَجهُم على الطْريق، وواحَدُخرين كانو يْقَطّعو غْصان من السْجَر ويْفَرّشوهُم. ");
INSERT INTO arq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","الغاشي اللي كانو سابقين واللي كانو يْتَبّعو في يَسوع كانو يْعَيّطو ويْقولو: \"أوصَّنا لوْليد داوَد، مْبارَك الجاي بآسَم الرَب، أوصَّنا فالعْلالي\" ");
INSERT INTO arq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","وكي دْخَل يَسوع لأورشَليم، كامَل المْدينة تْهَوّلَت وكانو يْقولو: \"شْكون هَدا؟\" ");
INSERT INTO arq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","والغاشي كان يْقول: \"هَدا يَسوع النَبي، من الناصرة فالجْليل\". ");
INSERT INTO arq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","دْخَل يَسوع للمَعبَد، وحاوَز كامَل اللي كانو يْبيعو ويَشريو تَمّة، وقَلَّب الميدات مْتاع اللي يْبَدّلو الدْراهَم والكْراسا مْتاع اللي يْبيعو الحْمام، ");
INSERT INTO arq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","وقالَلهُم: \"مَكتوب: داري رايحة تَتسَمّا دار الصْلاة، وأنتومَ رَدّيتوها غار للسَرّاقين.\" ");
INSERT INTO arq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","جاو ليه عَميين وكَعوانين فالمَعبَد وشْفاهُم. ");
INSERT INTO arq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","كي شافو رِيّاس رْجال الدين والكُتّاب العْجايَب اللي دارهُم والدْراري اللي كانو يْعَيّطو فالمَعبَد ويْقولو: \"أوصَّنا لوْليد داوَد\"، ما عْجَبهُمش الحال، ");
INSERT INTO arq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","وقالولو: \"راك تَسمَع واش راهُم يْقولو؟\" قاللَهُم يَسوع: \"إيه، عْمَركُم ما قْريتو باللي: خَرَّجت تَسبيح من فَم الدْراري واللي يَرَّضعو؟\" ");
INSERT INTO arq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","وخَلاّهُم وخْرَج من المْدينة لبيت عَنيا وبات تَمّة. ");
INSERT INTO arq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","الصْباح، كي كان يَسوع راجَع للمْدينة، جاع. ");
INSERT INTO arq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","شاف كَرمة واحدة فالطْريق، راح ليها بَصَّح لْقا فيها غير الوْرَق وقالَلها: \"حَتّى غَلّة ما تْزيد تُخرُج مَنَّك للدْوام\"، وتَم تَم يَبسَت الكَرمة. ");
INSERT INTO arq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","كي شافو التابعين هَداك الشي، سْتَعجبو وقالو: \"كيفاش يَبسَت السَجرة تَم تَم؟\" ");
INSERT INTO arq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","جاوَب يَسوع وقالَلهُم: \"نْقولَلكُم الصَح، لو كان عَندكُم إيمان وما تْشَكّوش، ماشي بَرك تْديرو واش نْدار لهاد الكَرمة، بَصَّح لو كان تْقولو لهاد الجْبَل، أَتقَلَّع وأتَّرما فالبْحَر، هاد الشي يَصرا، ");
INSERT INTO arq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","وكامَل واش تَطَّلبو فالصْلاة بالإيمان، تْنالوه\". ");
INSERT INTO arq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","راح يَسوع للمَعبَد، وكي كان يْدَرَّس جاو ليه رِيّاس رْجال الدين وشْيوخ الشَعب وقالو: \"بواش من الحُكمة راك تْدير هاد الشي، وشْكون عْطالَك هاد الحُكمة؟\" ");
INSERT INTO arq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","جاوَب يَسوع وقالَلهُم: \"وأنا تاني نْسَقسيكُم حاجة واحدة، وَلاّ قُلتولي عليها نْقولَلكُم أنا تاني بواش من الحُكمة نْدير هاد الشي، ");
INSERT INTO arq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","مَعمودِيّة يوحَنّا، منين جات؟ من السْما وَلاّ من الناس؟\" تْشاورو بيناتهُم وقالو: \"لو كان نْقولو من السْما، يْقولَلنا: وَعلاش هِمّالا ما آمَنتوش بيه؟ ");
INSERT INTO arq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","بَصَّح لو كان نْقولو من الناس، نْخافو من الغاشي خاطَر كامَل يَحَّسبو يوحَنّا نَبي\". ");
INSERT INTO arq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","وجاوبو يَسوع وقالو: \"ما راناش عارفين\". قالَلهُم هُوَ تاني: \"أنا تاني ما نْقولَلكُمش بواش من الحُكمة نْدير هاد الشي\". ");
INSERT INTO arq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","\"واش رايكُم، واحَد الراجَل كان عَندو زوج وْلاد، راح للأوّلاني وقاللو: \"يا وْليدي، روح أَخدَم اليوم فالدالية\"، ");
INSERT INTO arq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","جاوَب الوْلَد وقال: \"ما رانيش حاب\"، بَصَّح أومبَعد نْدَم وراح. ");
INSERT INTO arq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","وراح للتاني وقاللو كيما قال للأوّلاني، بَصَّح هَدا جاوَب وقال: \"ماعليه يا سيدي\"، بَصَّح ما راحش. ");
INSERT INTO arq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","شْكون فيهُم في زوج دار مُراد الباباة؟\" قالو: \"الأوّلاني\". قالَلهُم يَسوع: \"نْقولَلكُم الصَح، المَكّاسين والزانيات يَسَّبقوكُم لمَلَكوت الله، ");
INSERT INTO arq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","خاطَر جا ليكُم يوحَنّا في طْريق الصْلاح وما آمَنتوش بيه، بَصَّح المَكّاسين والزانيات آمنو بيه، وأنتومَ كي شَفتو هاد الشي، ما تَبتوش من بَعد وآمَنتو بيه. ");
INSERT INTO arq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","أَسَّمعو مْتَل واحَدآخُر: كان واحَد الراجَل مولى دار، غْرَس دالية ودار زَرب سايَر دايَر عليها، وحَفَر فيها مَعصرة وبْنا بُرج وخَلاّها لفَلاّحين وسافَر. ");
INSERT INTO arq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","كي قَرَّب وَقت الغَلّة، بْعَت الخَدّامين مْتاعو للفَلاّحين باش يَدّيو غَلّة الدالية. ");
INSERT INTO arq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","الفَلاّحين حَكمو الخَدّامين، واحَد ضَربوه، الآخُر قَتلوه والتالَت رَجموه. ");
INSERT INTO arq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","زاد بْعَت خَدّامين واحَدُخرين كْتَر من الأوّلانِيّين، ودارولهُم كيف كيف. ");
INSERT INTO arq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","من بَعد، بْعَتَّلهُم وْليدو وقال: \"وْليدي يْقادروه\"، ");
INSERT INTO arq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","بَصَّح الفَلاّحين كي شافو الوْلَد قالو بيناتهُم: \"هَدا هُوَ اللي يَورَت، هَيّا نَقُّتلوه ونَدّيو الوَرت مْتاعو\"، ");
INSERT INTO arq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","وحَكموه ورْماوَه بَرّا من الدالية وقَتلوه. ");
INSERT INTO arq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","كي يْوَلّي مول الدالية، واش يْدير لهَدوك الفَلاّحين؟\" ");
INSERT INTO arq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","قالولو: \"رايَح يَقتَل هَدوك المَشرارين قْتيلة شينة ويْخَلّي الدالية لفَلاّحين واحَدُخرين يَعطيولو الغَلّة في وَقتها.\" ");
INSERT INTO arq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","قالَلهُم يَسوع: \"عْمَركُم ما قْريتو فالكْتوب: \"الحَجرة اللي ما قَبلوهاش البَنّايين هيَ اللي وَلاّت حَجرة الوْصَل، هاد الشي جا من عَند الرَب وهُوَ شي عْجيب عَندنا\" ");
INSERT INTO arq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","على هَدا نْقولَلكُم باللي مَلَكوت الله رايَح يَتنَحّالكُم ويَتمَد لأُمّة تْجيب الغَلّة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","اللي يْطيح على هاد الحَجرة يَتدَڤدَڤ واللي تْطيح عليه تَدَّرسو.\" ");
INSERT INTO arq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","كي سَمعو رِيّاس رْجال الدين والفَرّيسِيّين المْتال مْتاعو، عَرفو باللي كان يَهدَر عليهُم، ");
INSERT INTO arq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","وكانو يْحَوّسو يَحَّكموه بَصَّح خافو من الغاشي خاطَر كانو حاسبينو نَبي. ");
INSERT INTO arq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","زاد يَسوع هْدَرَّلهُم بالمْتال وقال: ");
INSERT INTO arq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","\"مَلَكوت السْما يْشَبَّه لسَلطان دار عَرس لوْليدو، ");
INSERT INTO arq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","وبْعَت الخَدّامين مْتاعو يْعَيّطو للي كانو مَعروضين للعَرس وهومَ ما حَبّوش يْجيو. ");
INSERT INTO arq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","زاد بْعَت خَدّامين واحَدُخرين وقال: \"قولو للمَعروضين: \"الوَليمة مْتاعي راني وَجَّدتها والفْراد والزْوايَل السْمان مْتاعي نْدَبحو وكُل شي راهو واجَد، أَرواحو للعَرس\"\". ");
INSERT INTO arq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","بَصَّح المَعروضين ما عْباوش بالعَرضة وراحو، واحَد للحوش مْتاعو والآخُر للتِجارة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","والباقيين حَكمو الخَدّامين مْتاع السَلطان، هانوهُم وقَتلوهُم. ");
INSERT INTO arq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","زْعَف السَلطان وبْعَت العَسكَر مْتاعو وقْتَل هَدوك القَتّالين وحْرَق مْدينَتهُم. ");
INSERT INTO arq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","أومبَعد قال للخَدّامين مْتاعو: \"العَرس راهو واجَد بَصَّح اللي كانو مَعروضين ما سْتاهلوهش. ");
INSERT INTO arq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","هِمّالا روحو للطُرقان، وكامَل اللي تَلقاوهُم أَعَّرضوهُم للعَرس\". ");
INSERT INTO arq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","خَرجو هَدوك الخَدّامين للطُرقان ولَمّو كامَل اللي لْقاوهُم، مَشرارين ومْلاح، وتْعَمّر العَرس بالضْياف. ");
INSERT INTO arq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","كي دْخَل السَلطان يْشوف الضْياف، شاف تَمّة واحَد الراجَل ماشي لابَس لْباس العَرس، ");
INSERT INTO arq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","قاللو: \"صاحبي، كيفاش دْخَلت اللَهنا بْلا ما تْكون بلْباس العَرس؟\" بْقا الراجَل ساكَت. ");
INSERT INTO arq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","داك الساع قال السَلطان للخَدّامين: \"أَرَّبطولو رَجليه ويَدّيه وأرميوَه فالضْلام بَرّا وين يْكون البْكا وغَز السْنان\". ");
INSERT INTO arq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","خاطَر المَعروضين بَزّاف بَصَّح المُختارين قْلال.\" ");
INSERT INTO arq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","داك الساع راحو الفَرّيسِيّين يَتشاورو ما بيناتهُم كيفاش يْزَلّقو يَسوع بكَلمة، ");
INSERT INTO arq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","وبَعتولو التابعين مْتاعهُم مع الهيرودوسِيّين يْقولو: \"شيخ، رانا عارفين باللي أنتَ حَقّاني، وتْعَلَّم طْريق الله على حْساب الحَق، ما تْخاف حَتّى واحَد وما تْديرش الوْجوه. ");
INSERT INTO arq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","قولَلنا هِمّالا، واش رايَك. يْجوز نْخَلّصو الجَزية لقَيصَر وَلاّ لالا؟\" ");
INSERT INTO arq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","عْرَف يَسوع شَرّهُم وقال: \"وَعلاش راكُم تْجَرّبو فِيَّ يا مُنافقين؟ ");
INSERT INTO arq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","وَرّيولي الدْراهَم اللي يْخَلّصو بيهُم الجَزية\". أَعطاولو دينار. ");
INSERT INTO arq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","وقالَلهُم: \"مْتاع من هاد التَصويرة وهاد الكْتيبة؟\" ");
INSERT INTO arq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","قالولو: \"مْتاع قَيصَر\"، داك الساع قالَلهُم: \"هِمّالا، أَعطيو لقَيصَر شِيّ قَيصَر، ولله شِيّ الله\". ");
INSERT INTO arq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","كي سَمعو سْتَعجبو، وخَلاّوَه وراحو. ");
INSERT INTO arq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","في هَداك النْهار، جاو ليه الصَدّوقِيّين اللي يْقولو باللي ما كانش القِيامة وسَقساوَه، ");
INSERT INTO arq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","وقالو: \"شيخ، موسى قال: لوكان يْموت واحَد ما عَندوش الدْراري، لازَم على خوه يَتزَوَّج بمَرتو ويْدير دَرِيّة لخوه. ");
INSERT INTO arq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","كانو عَندنا سْبَع خاوة، وتْزَوَّج الأَوَّل ومات: وكي ما عَندوش الدْراري خَلاّ مَرتو لخوه، ");
INSERT INTO arq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","وهَكدا صْرا للتاني، والتالَت حَتّى للسابَع. ");
INSERT INTO arq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","بَعدهُم كامَل ماتَت المْرا. ");
INSERT INTO arq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","فالقِيامة، شْكون فالسَبعة اللي تْكون هَديك المْرا مَرتو؟ خاطَر كامَل أَدّاوها\". ");
INSERT INTO arq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","جاوَب يَسوع وقالَلهُم: \"راهي تالفَتَّلكُم خاطَر ما تَعَّرفو لا الكْتوب وَلا قُدرة الله. ");
INSERT INTO arq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","خاطَر فالقِيامة، ما يَتزَوّجو ما يَتزَوّجو بيهُم، بَصَّح يْكونو كي المَلايكة فالسْما. ");
INSERT INTO arq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","وعلى قِيامة الموتى، ما قْريتوش كْلام الله ليكُم اللي يْقول: ");
INSERT INTO arq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"أنا إلَه إبراهيم وإلَه إسحاق وإلَه يَعقوب؟ الله ماشي إلَه الموتى، الله إلَه الحَيّين.\" ");
INSERT INTO arq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","كي سْمَع الغاشي، دَهش فالتَعليم مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","الفَرّيسِيّين كي سَمعو باللي يَسوع بَكَّم الصَدّوقِيّين، تْلايمو في مَدرَب واحَد. ");
INSERT INTO arq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","وواحَد فيهُم، شيخ مْتاع الشَريعة سَقساه باش يْجَرّبو: ");
INSERT INTO arq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","\"شيخ، أَما هُوَ الفَرض الكْبير فالشَريعة؟\" ");
INSERT INTO arq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","جاوبو يَسوع: \"تْحَب الرَب إلَهَك من كُل قَلبَك ومن كُل نَفسَك ومن كُل تَخمامَك. ");
INSERT INTO arq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","هَدا هُوَ الفَرض الكْبير والأوَّل. ");
INSERT INTO arq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","بَصَّح كايَن التاني كيما هُوَ: تْحَب قْريبَك كيما نَفسَك. ");
INSERT INTO arq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","كامَل الشَريعة والأنبيا مَبنِيّين على هاد الزوج فْرايَض.\" ");
INSERT INTO arq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","كي كانو الفَرّيسِيّين مَتلايمين، سَقساهُم يَسوع، ");
INSERT INTO arq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","وقال: \"واش رايكُم فالمَسيح؟ وْليد مَن هُوَ؟\" قالولو: \"وْليد داوَد.\" ");
INSERT INTO arq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","قالَلهُم: \"هِمّالا كيفاش داوَد بالروح يْعَيَّطلو \"رَبّي\" ويْقول: ");
INSERT INTO arq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","\"قال الرَب لرَبّي: \"أَقعُد على يْميني حَتّى نْحَط عَديانَك تَحت رَجليك؟\" ");
INSERT INTO arq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","إيلا كان داوَد يْعَيَّطلو رَبّي، كيفاش هِمّالا يْكون وْليدو؟\" ");
INSERT INTO arq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","وحَتّى واحَد ما قْدَر يْجاوبو بكَلمة. ومن هَداك اليوم، واحَد ما زاد قْدَر يْسَقسيه في حاجة. ");
INSERT INTO arq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","أومبَعد، كَلَّم يَسوع الغاشي والتابعين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","وقال: \"الكُتّاب والفَرّيسِيّين قَعدو على كُرسي موسى، ");
INSERT INTO arq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","هِمّالا ديرو وطَبّقو كُل شي يْقولوهولكُم، بَصَّح ما تْديروش واش يْديرو. خاطَر يْقولو وما يْطَبّقوش. ");
INSERT INTO arq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","يْحَزّمو حْمال تْقال وواعرين للرْفود ويْحَطّوهُم على كْتاف الناس وهومَ ما يْحَبّوش يْزَغّدوهُم بصْبَعهُم، ");
INSERT INTO arq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","وكامَل فْعالهُم، يْديروهُم باش يْشوفوهُم الناس. يْديرو عْصاصَب عْراض ويْطَوّلو جْلال لْباسهُم، ");
INSERT INTO arq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ويْحَبّو يَقُّعدو مع الأوّلين فالوَليمات وفالكْراسا الأوّلين فالمْجامَع، ");
INSERT INTO arq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ويْحَبو يْسَلّمو عليهُم فالأَسواق، ويْعَيّطولهُم الناس: \"شيخ، شيخ\"، ");
INSERT INTO arq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","بَصَّح أنتومَ ما تْخَلّيوش الناس يْعَيّطولكُم: شيخ، خاطَر عَندكُم شيخ واحَد وأنتومَ كامَل خاوة. ");
INSERT INTO arq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","وما تْعَيّطو لحَتّى واحَد على الأَرض بابا خاطَر باباكُم واحَد بَرك، السْماوي. ");
INSERT INTO arq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","وما تْخلّيوش الناس يْعَيّطولكُم رُؤَسا خاطَر رايَسكُم واحَد، هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","الكْبير فيكُم يْكون خْديمكُم، ");
INSERT INTO arq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","خاطَر اللي يَحسَب روحو تْطيح قيمتو واللي ما يَحسَبش روحو تَندارلو القيمة. ");
INSERT INTO arq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","يا ويلكُم يا الكُتّاب والفَرّيسِيّين المُنافقين، خاطَر تَغَّلقو مَلَكوت السْما في وَجه الناس، ما تَدَّخلو أنتومَ، ما تْخَلّيو اللي يْحَبّو يَدُّخلو يَدُّخلو. ");
INSERT INTO arq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","يا ويلكُم يا الكُتّاب والفَرّيسِيّين المُنافقين، خاطَر تْطَوّفو البْحَر والبَر باش تَرَّبحو واحَد يَدخُل فالدين، وكي يَدخُل فالدين، تَرَدّوه وْليد جَهَنَّمة زوج مَرّات كْتَر مَنكُم. ");
INSERT INTO arq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","يا ويلكُم يا الڤَوّادين العَميين، اللي تْقولو: \"اللي يَحلَف ببيت المَقدَس ماشي مَلزوم باليْمين مْتاعو بَصَّح اللي يَحلَف بالدْهَب مْتاع بيت المَقدَس مَلزوم بيه\". ");
INSERT INTO arq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","يا الجاهلين والعَميين، أَما هُوَ الكْبير؟ الدْهَب وَلاّ بيت المَقدَس اللي يْقَدَّس الدْهَب؟ ");
INSERT INTO arq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","و: \"اللي يَحلَف بالمَدبَح ماشي مَلزوم باليْمين مْتاعو، بَصَّح اللي يَحلَف بالهِبة اللي على المَدبَح مَلزوم\"، ");
INSERT INTO arq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","يا العَميين، أَما هُوَ الكْبير؟ الهِبة وَلاّ المَدبَح اللي يْقَدَّس الهِبة؟ ");
INSERT INTO arq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","اللي يَحلَف بالمَدبَح يَحلَف بيه وبكامَل الحاجات اللي عليه، ");
INSERT INTO arq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","واللي يَحلَف ببيت المَقدَس يَحلَف بيه وباللي ساكَن فيه، ");
INSERT INTO arq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","واللي يَحلَف بالسْما يَحلَف بعَرش الله وباللي قاعَد عليه. ");
INSERT INTO arq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","يا ويلكُم يا الكُتّاب والفَرّيسِيّين المُنافقين، خاطَر تْعَشّرو على النَعناع والبَسباس والكَمّون وخَلّيتو الصَح فالشَريعة: الحَق والرَحمة والإيمان. كان لازَم تَعَّملو هاد الحاجات بْلا ما تْخَلّيو الحاجات الأُخرين. ");
INSERT INTO arq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","يا الڤَوّادين العَميين، تْصَفّيو باش تْنَحّيو ناموسة بَصَّح تَبَّلعو جْمَل. ");
INSERT INTO arq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","يا ويلكُم يا الكُتّاب والفَرّيسِيّين المُنافقين خاطَر تْنَقّيو الكاس والطَبسي من بَرّا بَصَّح من الداخَل مْعَمّرين بالسْريقة والطْمَع. ");
INSERT INTO arq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","يا الفَرّيسي العْمى، نَقّي الكاس قْبَل من الداخَل باش يْوَلّي من بَرّا تاني نْقي. ");
INSERT INTO arq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","يا ويلكُم يا الكُتّاب والفَرّيسِيّين المُنافقين خاطَر تْشَبّهو للقْبور المْبَيّضين، اللي يْبانو شَبّان من بَرّا ومن الداخَل مْعَمّرين بعْضام الموتى وكُل نْجاسة. ");
INSERT INTO arq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","أنتومَ تاني، من بَرّا تْبانو صالحين للناس بَصَّح من الداخَل مْعَمّرين بالتْنوفيق والشَر. ");
INSERT INTO arq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","يا ويلكُم يا الكُتّاب والفَرّيسِيّين المُنافقين، خاطَر تْبنيو قْبور الأنبيا وتْسَڤّمو مْدافَن الصالحين، ");
INSERT INTO arq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","وتْقولو: \"لوكان عَشنا في يامات جْدودنا، ما كُنّاش نَتشاركو مْعاهُم باش نْسَيّلو دَم الأَنبيا\". ");
INSERT INTO arq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","هَكدا راكُم تَشَّهدو على روحكُم باللي أنتومَ وْلاد اللي قَتلو الأَنبيا. ");
INSERT INTO arq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","وعَمَّرتو الكيل مْتاع جْدودكُم، ");
INSERT INTO arq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","يا الحْنوشة، يا وْلاد اللْفاعي، كيفاش تَهَّربو من حُكم جَهَنَّمة؟ ");
INSERT INTO arq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","على هَدا، راني نَبعَتَّلكُم أَنبيا وحُكَما وكُتّاب، كايَن اللي تَقُّتلوهُم وتَصَّلبوهُم وكايَن اللي تَجَّلدوهُم في مْجامَعكُم، تَشَّحنو عليهُم وتْتَبّعوهُم من مْدينة لمْدينة. ");
INSERT INTO arq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","باش يْجي على رَقبَتكُم كامَل الدَم الصالَح اللي سال على الأرض، مَن دَم هابيل الصالَح حَتّى لدَم زَكَريّا بَن بَرَخِيّا اللي قْتَلتوه بين بيت المَقدَس والمَدبَح. ");
INSERT INTO arq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","نْقولَلكُم الصَح، هَدا كامَل يَصرا في هاد الجيل. ");
INSERT INTO arq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","يا أورشَليم يا أورشَليم، اللي تُقتَل الأَنبيا وتَرجَم المَبعوتبن ليها، شْحال من مَرّة حَبّيت نْلَم وْلادَك كيما تْلَم الجاجة فْلالَسها تَحت جْناحتيها وما حَبّيتوش، ");
INSERT INTO arq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","هاوليك المَعبَد مْتاعكُم يَتخَلاّلكُم خَالي. ");
INSERT INTO arq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","خاطَر نْقولَلكُم، من دُرك ما تْشوفونيش حَتّى وين تْقولو: \"مْبارَك الجاي بآسَم الرَب.\"\" ");
INSERT INTO arq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","خْرَج يَسوع من المَعبَد وكي كان رايَح، أدَنّاو ليه التابعين مْتاعو باش يْوَرّيولو البَنيان مْتاع المَعبَد. ");
INSERT INTO arq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","جاوَب هُوَ وقالَلهُم: \"راكُم تْشوفو هَدا كامَل؟ نْقولَلكُم الصَح، ما تَقعُد هْنا حَتّى حَجرة فوق حَجرة ما تَترَيَّبش\". ");
INSERT INTO arq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","وكي كان قاعَد على جْبَل الزيتون، جاو ليه التابعين مْتاعو وقالولو على جيه: \"قولَلنا، وَقتاش يَصرا هاد الشي، وواشَن هيَ المارة مْتاع رْجوعَك وآخَر الزْمان؟\" ");
INSERT INTO arq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","جاوَب هُوَ وقالَلهُم: \"رَدّو بالكُم يْعود يَغويكُم كاش واحَد، ");
INSERT INTO arq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","خاطَر كايَن بَزّاف اللي رايحين يْجيو بآسمي ويْقولو: \"أنا هُوَ المَسيح\"، ويْغَرّو بَزّاف من الناس، ");
INSERT INTO arq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","رايحين تَسَّمعو بحْروب وبخْبار مْتاع حْروب، رَدّو بالكُم تْخافو، خاطَر لازَم يَصرا هاد الشي، بَصَّح مازال ما تْكونش الآخرة. ");
INSERT INTO arq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","رايحة تْنوض أُمّة ضَد أُمّة، ومَملَكة ضَد مَملَكة، ويْكونو مَجاعات وزْنازَل في مْضارَب بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","وهَدا كامَل يْكون غير البَدية مْتاع وْجاع الوْلادة. ");
INSERT INTO arq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","داك الوَقت يْسَلّموكُم للعْداب، ويَقُّتلوكُم وتْكونو مَكروهين من كامَل الأُمّات على جال آسمي، ");
INSERT INTO arq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","داك الوَقت، كايَن بَزّاف اللي يَعَّترو، ويْبَيّعو بَعضهُم بَعض ويَكَّرهو بَعضهُم بَعض. ");
INSERT INTO arq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ويْنوضو بَزّاف أَنبيا كَدّابين ويْغَرّو ناس بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","وعلى جال اللي يَكتَر الشَر، تَبرَد المْحَبّة مْتاع ناس بَزّاف، ");
INSERT INTO arq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","اللي يَتبَت حَتّى الأخَّر، هَداك يَسلَك. ");
INSERT INTO arq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","هاد البْشارة مْتاع المَلَكوت، رايَح يَتبَرَّح بيها في كامَل الدَنيا، وتْكون شْهادة لكامَل الأُمّات وداك الساع تْجي الآخرة. ");
INSERT INTO arq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","على هَدا كي تْشوفو نْجاسة الوَخدة اللي هْدَر عليها النَبي دانيال، واقفة فالمْكان المْقَدَّس، -اللي يَقرا غير يَفهَم-، ");
INSERT INTO arq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","هِمّالا اللي يْكونو فاليَهوديّة، غير يَهَّربو للجْبال، ");
INSERT INTO arq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","واللي يْكون فالسْطَح، غير ما يَهبَطش يَدّي الحاجات مْتاع دارو، ");
INSERT INTO arq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","واللي يْكون فالحوش، غير ما يَرجَعش للور يَدّي لْباسو. ");
INSERT INTO arq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","يا ويلهُم النْسا اللي يْكونو بالجوف واللي يْكونو يْرَضّعو في هَدوك اليامات. ");
INSERT INTO arq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","صَلّيو باش الهَربة مْتاعكُم ما تْجيش فالشْتا وَلاّ فالسَبت، ");
INSERT INTO arq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","خاطَر في هَداك الوَقت، تْكون شَدّة كْبيرة، ما صْراتش من اللي بْدات الدَنيا حَتّى لدُرك، وَلا رايحة تَصرا، ");
INSERT INTO arq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ولو كان الله ما قَصَّرش هَدوك اليامات، لو كان واحَد ما يَسلَك. بَصَّح على جال المُختارين، رايحين يَقصارو. ");
INSERT INTO arq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","داك الوَقت، لوكان يْقولَلكُم واحَد: \"هاو هْنا المَسيح وَلاّ لْهيك\"، ما تامنوهش، ");
INSERT INTO arq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","خاطَر رايحين يْجيو اللي يَدَّعاو باللي هومَ المَسيح، وأَنبيا كَدّابين، ويْمَدّو مارات كْبار وعْجايَب باش يْغُرّو لو كان يَقَّدرو حَتّى المُختارين. ");
INSERT INTO arq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","راني خَبَّرتكُم من قْبَل. ");
INSERT INTO arq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","هِمّالا لوكان يْقولولكُم: \"راهو فالخْلا\"، ما تْروحوش، وَلاّ \"فالبْيوت\"، ما تامنوش، ");
INSERT INTO arq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","خاطَر كيما يَخرُج البْرَق من الشَرق ويْضَوّي حَتّى للغَرب، هَكدا يْكون مْجي بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","وين تْكون الميتة، تَمّة يَتلَمّو العُڤبان. ");
INSERT INTO arq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","وتَم تَم بَعد هَدوك اليامات مْتاع الشَدّة، تَضلام الشَمس، والقْمَر ما يْزيدش يْضَوّي، والنْجوم يْطيحو من السْما، وقُدرات السْما يَتزَعزعو. ");
INSERT INTO arq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","داك الساع، تْبان مارة بْن الإنسان فالسْما، وكامَل عْشايَر الدَنيا يَخَّبطو في صْدورهُم، ويْشوفو بْن الإنسان جاي على سْحابات السْما بقُدرة ومَجد كْبير، ");
INSERT INTO arq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ويَبعَت المَلايكة مْتاعو يْبَوّقو بالزور، ويْلَمّو المُختارين مْتاعو من الرَبع رْياح من طْراف السْما لطْراف السْما. ");
INSERT INTO arq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","خودو المْتَل من الكَرمة، اللي كي يَرطاب الغْصن مْتاعها، ويْنوضو وْراقها، تَعَّرفو باللي الصيف راهو قْريب، ");
INSERT INTO arq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","هَكدا أنتومَ تاني، كي تْشوفو هاد الشي كامَل، تَعَّرفو باللي بْن الإنسان راهو قْريب، فالباب. ");
INSERT INTO arq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","نْقولَلكُم الصَح باللي هاد الجيل ما يْجوزش حَتّى وين يَصرا هاد الشي كامَل. ");
INSERT INTO arq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","السْما والأَرض يْزولو بَصَّح كْلامي ما يْزولش. ");
INSERT INTO arq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","هَداك اليوم والساعة، واحَد ما يَعلَم بيهُم، لا مَلايكة السْما، لا الإِبن، غير الآب اللي يَعلَم. ");
INSERT INTO arq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","كيما كان في يامات نوح، كيف كيف يْكون مْجي بْن الإنسان. ");
INSERT INTO arq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","كيما كانو في هَدوك اليامات اللي قْبَل الطوفان، ياكلو ويَشُّربو، يَتزَوّجو ويْزَوّجو حَتّى لليوم اللي دْخَل نوح للفْلَك، ");
INSERT INTO arq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","وما عَرفوش حَتّى جا الطوفان وأَدّاهُم كامَل. هَكدا يْكون تاني مْجي بْن الإنسان. ");
INSERT INTO arq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","داك الوَقت يْكونو زوج فالحوش، واحَد يَتَّرفَد وواحَد يَتخَلاّ، ");
INSERT INTO arq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","وزوج نْسا يَرحيو فالرْحى، واحدة تَتَّرفَد وواحدة تَتخَلاّ. ");
INSERT INTO arq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","هِمّالا رَدّو بالكُم، خاطَر ما تَعَّرفوش اليوم اللي يْجي فيه رَبّكُم. ");
INSERT INTO arq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","تَعَّرفو هاد الشي، باللي لو كان يَعرَف مول الدار واش من الساعة فالليل يْجي السَرّاق، لو كان يَسهَر وما يْخَلّيش دارو تَنسرَق. ");
INSERT INTO arq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","على هَدا، أنتومَ تاني كونو واجدين، خاطَر فالساعة اللي ما تْجيش في بالكُم، يْجي بْن الإنسان. ");
INSERT INTO arq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","شْكون هُوَ هِمّالا الخْديم الحْلالي والفايَق اللي دارو سيدو وْكيل على الخَدّامين مْتاع دارو؟ اللي يَعطيلهُم الماكلة في وَقتها. ");
INSERT INTO arq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","يا سَعدو هَداك الخْديم، اللي كي يْجي سيدو يَلقاه يْدير هَكدا. ");
INSERT INTO arq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","نْقولَلكُم الصَح، يْوَكّلو على كامَل مْلاكو. ");
INSERT INTO arq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","بَصَّح لو كان يْقول هَداك الخْديم الدوني في قَلبو: \"سيدي يَبطا\"، ");
INSERT INTO arq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ويَبدا يَضرَب فالخَدّامين اللي يَخَّدمو مْعاه، وياكُل ويَشرُب مع السوكَرجيّة، ");
INSERT INTO arq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","يْجي سيد هَداك الخْديم فاليوم اللي ما يْكونش يَستَنّا فيه وفالساعة اللي ما يْكونش عارَفها، ");
INSERT INTO arq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","يْعاقبو ويْحَط حَقّو مع المُنافقين. تَمّة يْكون البْكا وغَز السْنان. ");
INSERT INTO arq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ومَلَكوت السْما يْكون يْشَبَّه لعَشر عْواتَق، اللي أَدّاو كانكِيّاتهُم وخَرجو يْلاقيو العْريس. ");
INSERT INTO arq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","خَمسة مَنهُم كانو مْهابَل وخَمسة عاقلين. ");
INSERT INTO arq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","المْهابَل أَدّاو كانكِيّاتهُم وما أَدّاوش معاهُم الزيت، ");
INSERT INTO arq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","بَصَّح العاقلين أَدّاو الزيت في قْرَع مع الكانكِيّات مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","كي بْطا العْريس، نَعسو كامَل ورَقدو. ");
INSERT INTO arq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","وفي نَص الليل، واحَد عَيَّط: \"هاو العْريس، أَخُّرجو تْلاقيوَه\". ");
INSERT INTO arq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","داك الوَقت، فَطنو كامَل هَدوك العْواتَق ووَجّدو كانكِيّاتهُم. ");
INSERT INTO arq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","المْهابَل قالو للعاقلين: \"أَعطيولنا من الزيت مْتاعكُم، خاطَر كانكِيّاتنا راهُم يَطفاو\"، ");
INSERT INTO arq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","جاوبو العاقلين وقالو: \"لالا، ما تَكفيش قيسنا وقيسكُم، روحو عَند اللي يْبيعو وأَشريو\"، ");
INSERT INTO arq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","وكي راحو يَشريو، جا العْريس، واللي كانو واجدين دَخلو معاه للعَرس ونْغَلقَت الباب. ");
INSERT INTO arq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","من بَعد، جاو العْواتَق الأُخرين يْقولو: \"سيدي، سيدي، حَلَّنّا\"، ");
INSERT INTO arq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","جاوَب هُوَ وقال: \"فالصَح، ما نَعرَفكُمش\"، ");
INSERT INTO arq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","رَدّو بالكُم هِمّالا، خاطَر ما تَعَرّفو لا اليوم وَلا الساعة\". ");
INSERT INTO arq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","كيما واحَد كان مْسافَر، عَيَّط للخَدّامين مْتاعو وخَلاّلهُم مْلاكو، ");
INSERT INTO arq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","عْطا لواحَد خَمس ويزات، ولواحَدآخُر زوج ويزات، وللآخُر ويزة، لكُل واحَد على حْساب مَقدورو وسافَر. ");
INSERT INTO arq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","راح اللي أدّا خَمس ويزات، خْدم بيهُم ورْبَح خَمسة واحَدُخرين. ");
INSERT INTO arq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","كيف كيف اللي أدّا زوج، رْبَح زوج واحَدُخرين. ");
INSERT INTO arq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","بَصَّح اللي أدّا واحدة، راح حْفَر فالأَرض وخَبّاها. ");
INSERT INTO arq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","وبَعد مُدّة طْويلة، جا المْعَلَّم مْتاع هَدوك الخَدّامين وتْحاسَب معاهُم. ");
INSERT INTO arq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","تْقَدَّم اللي أدّا خَمس ويزات، جاب خَمس ويزات واحَدُخرين وقال: \"سيدي، خَلّيتلي خَمس ويزات، هامليك خَمس ويزات واحَدُخرين زَدت رْبَحتهُم\". ");
INSERT INTO arq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","قاللو المْعَلَّم مْتاعو: \"مْليح يا الخْديم الصالَح والحْلالي، كُنت حْلالي فالقْليل، نْكَلّفَك على الكْتير، أَدخُل في فَرح سيدَك\". ");
INSERT INTO arq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","تْقَدَّم تاني اللي أدّا زوج ويزات وقال: \"سيدي، خَلّيتلي زوج ويزات وهامليك زوج ويزات واحَدُخرين زَدت رْبَحتهُم\". ");
INSERT INTO arq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","قاللو المْعَلَّم مْتاعو: \"مْليح يا الخْديم الصالَح والحْلالي، كُنت حْلالي فالقْليل، نْكَلّفَك على الكْتير، أَدخُل في فَرح سيدَك\". ");
INSERT INTO arq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","بَصَّح زاد تْقَدَّم اللي أدّا ويزة واحدة وقال: \"عْرَفت باللي أنتَ راجَل قاسي، تَحصَد وين ما زْرَعتش وتْلَم وين ما فْرَقتش، ");
INSERT INTO arq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","خَفت ورُحت خَبّيت الويزة مْتاعَك فالأرض، هاك أَدّي شَيَّك.\" ");
INSERT INTO arq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","جاوَب سيدو وقال: \"يا الخْديم المَشرار والفَنيان، كُنت عارَف باللي نَحصَد وين ما زْرَعتش ونْلَم وين ما فْرَقتش، ");
INSERT INTO arq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","هِمّالا كان لازَم تْحَط الويز مْتاعي فالبانكة، وكي نْجي، نْرَد شَيّي بالفايدة. ");
INSERT INTO arq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","نَحّيولو الويزة وأعطيوها للي عَندو عْشَر ويزات، ");
INSERT INTO arq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","خاطَر اللي عَندو بَزّاف يَتَّعطالو ويْفيض عليه الخير، بَصّح اللي ما عَندوش، حَتّى واش عَندو يَتنَحّالو. ");
INSERT INTO arq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","والخْديم اللي ما يَصلَحش، أَرميوَه بَرّا فالضْلام مْتاع بَرّا. تَمّة يْكون البْكا وغَز السْنان. ");
INSERT INTO arq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","كي يْجي بْن الإنسان في مَجدو وكامَل المَلايكة معاه، داك الوَقت يَقعُد على عَرش المَجد مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","يَتلَمّو قُدّامو كامَل الأُمّات، ويْفَرَّقهُم كيما يْفَرَّق الراعي الخَرفان على العْتارَس. ");
INSERT INTO arq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","يْحَط الخَرفان على اليْمنى مْتاعو والعْتارَس على اليْسرى. ");
INSERT INTO arq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","داك الساع، يْقول السَلطان للي على اليْمنى مْتاعو: \"أَرواحو يا المْباركين من عَند بابا، أَدّيو المَلَكوت اللي تْوَجَّدلكُم من اللي نْدارَت الدَنيا، ");
INSERT INTO arq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","خاطَر جَعت وعْطيتوني ناكُل، عْطَشت وعْطيتوني نَشرُب، كُنت غْريب وسَكَّنتوني، ");
INSERT INTO arq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","عَريان وكَسّيتوني، كُنت مْريض وزَرتوني، فالحَبس وجيتو لعَندي\". ");
INSERT INTO arq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","داك الساع يْجاوبوه الصالحين ويْقولو: \"يا رَب، وَقتاش شَفناك جيعان ووَكَّلناك، وَلاّ عَطشان وعْطيناك تَشرُب؟ ");
INSERT INTO arq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","وَقتاش شَفناك غْريب وسَكَّنّاك، وَلاّ عَريان وكَسّيناك؟ ");
INSERT INTO arq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","وَقتاش شَفناك مْريض وَلاّ فالحَبس وجينا لعَندَك؟\" ");
INSERT INTO arq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ويْجاوَبهُم السَلطان ويْقولَلهُم: \"نْقولَلكُم الصَح، كُل مَرّة دَرتو هاد الشي لواحَد من هَدو خاوتي الصْغار، كي شْغُل دَرتوهولي لِيَّ.\" ");
INSERT INTO arq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","داك الساع يْقول تاني للي على اليْسرى: \"روحو بْعيد عليَّ يا المَنعولين للنار الدايمة اللي تْوَجّدت لإبليس والمَلايكة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","خاطَر جَعت وما عْطيتونيش ناكُل، عْطَشت وما عْطيتونيش نَشرُب، ");
INSERT INTO arq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","كُنت غْريب وما سَكَّنتونيش، عَريان وما كَسّيتونيش، مْريض وفالحَبس وما زَرتونيش\". ");
INSERT INTO arq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","داك الساع يْجاوبوه هومَ تاني ويْقولو: \"يا رَب، وَقتاش شَفناك جيعان وَلاّ عَطشان وَلاّ غْريب وَلاّ عَريان وَلاّ مْريض وَلاّ فالحَبس وما خْدَمناكش؟\" ");
INSERT INTO arq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","يْجاوَبهُم ويْقول: \"نْقولَلكُم الصَح، كُل مَرّة ما دَرتوش هاد الشي لواحَد من هاد الصْغار كامَل، أنا تاني ما دَرتوليش\". ");
INSERT INTO arq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ويْروحو هَدوك للعِقاب الدايَم بَصَّح الصالحين للحْياة الدايمة\". ");
INSERT INTO arq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","وكي كَمَّل يَسوع كامَل هاد الكْلام، قال للتابعين مْتاعو: ");
INSERT INTO arq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","\"راكُم عارفين باللي بَعد يومين يْجي الفَصح، وبْن الإنسان يَتسَلَّم باش يَتَّصلَب\". ");
INSERT INTO arq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","داك الوَقت، تْلَمّو رِيّاس رْجال الدين وشْيوخ الشَعب في قْصَر رايَس رْجال الدين اللي واسمو قِيافا، ");
INSERT INTO arq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","وتْشاورو باش يَحَّكمو يَسوع بالحيلة ويَقُّتلوه. ");
INSERT INTO arq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","بَصَّح قالو: \"ماشي فالعيد باش ما يَصراش الهول في وَسط الشَعب.\" ");
INSERT INTO arq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","وكي جا يَسوع لبيت عَنيا في دار سَمعان البْرَص، ");
INSERT INTO arq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","جات ليه مْرا عَندها قَرعة ريحة غالية وكُبَّتها على راس يَسوع وهُوَ قاعَد على الميدة. ");
INSERT INTO arq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","كي شافو التابعين هَداك الشي، ما عْجَبهُمش الحال وقالو: \"وَعلاش هاد الخْسارة؟ ");
INSERT INTO arq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","هاد الريحة كانَت قادرة تَتباع بسومة غالية وتَتمَد للڤْلالين.\" ");
INSERT INTO arq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","عْرَف يَسوع وقالَلهُم: \"وَعلاش راكُم تْغَبّنو في هاد المْرا؟ دارَتلي حاجة مْليحة، ");
INSERT INTO arq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","خاطَر الڤْلالين راهُم دايمًا معاكُم، بَصَّح أَنا ما نْكونش معاكُم دايمًا. ");
INSERT INTO arq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","هيَ كي كُبَّت هاد الريحة على داتي، دارَت هَكداك لدْفينتي. ");
INSERT INTO arq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","نْقولَلكُم الصَح، وين يَتبَرَّح بهاد الإنجيل في كامَل الدَنيا، يَتَّهدَر تاني على واش دارَت هاد المْرا ويَتفَكّروها.\" ");
INSERT INTO arq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","داك الوَقت، راح واحَد من التابعين الطْناش واسمو يَهودا الإسخَريوطي عَند رِيّاس رْجال الدين، ");
INSERT INTO arq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","وقال: \"واش تْحَبّو تَعطيوني وأنا نْسَلَّمهولكُم؟\" أَعطاولو تْلاتين دينار مْتاع الفَضّة، ");
INSERT INTO arq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ومن تَم، بْدا يْحَوَّس على الوَقت اللي يْوالَم باش يْسَلَّمو. ");
INSERT INTO arq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","اليوم الأوَّل مْتاع عيد الفْطير، أدَّنّاو التابعين ليَسوع وقالو: \"وين تْحَب نْوَجّدولَك الماكلة مْتاع الفَصح؟\" ");
INSERT INTO arq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","قالَلهُم: \"روحو للمْدينة عَند فْلان، وقولولو: \"الشيخ راهو يْقول: قَرّبَت ساعتي، نْدير الفَصح عَندَك مع التابعين مْتاعي.\" ");
INSERT INTO arq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","دارو التابعين كيما آمَرهُم يَسوع ووَجّدو الفَصح. ");
INSERT INTO arq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","وكي طاح الليل، كان على الميدة مع التابعين الطْناش، ");
INSERT INTO arq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","وكي كانو ياكلو، قال: \"فالصَح، واحَد فيكُم يْسَلَّمني\"، ");
INSERT INTO arq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","حَزنو بَزّاف التابعين وبْدا كُل واحَد فيهُم يْقوللو: \"أنا سيدي؟\" ");
INSERT INTO arq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","جاوَب يَسوع وقال: \"اللي غَمَّس معايَ يَدّو فالطَبسي، هُوَ يْسَلَّمني. ");
INSERT INTO arq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","بْن الإنسان رايَح كيما راهو مَكتوب عليه، بَصَّح يا ويلو هَداك البْنادَم اللي يَتسَلَّم بْن الإنسان على يَدّو، خيرلو هَداك البْنادَم لو كان ما نْزادش.\" ");
INSERT INTO arq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","جاوَب يَهودا اللي كان رايَح يْسَلّمو وقال: \"أنا سيدي؟\" جاوبو: \"أنتَ قُلت\". ");
INSERT INTO arq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","كي كانو ياكلو، خْدا يَسوع الخُبز وبَعدما بارَك، قَسمو وعْطا للتابعين وقال: \"خودو، كولو، هَدي داتي.\" ");
INSERT INTO arq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","وخْدا كاس وبَعدما شْكَر، عْطالهُم وقال: \"أَشُّربو كامَل من هَدا، ");
INSERT INTO arq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","خاطَر هَدا دَمّي، دَم العَهَد اللي يْسيل على جال ناس بَزّاف لغُفران الدْنوب. ");
INSERT INTO arq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","نْقولَلكُم، من دُرك ما نْزيدش نَشرُب من هاد الغَلّة مْتاع الدالية حَتّى لهَداك اليوم اللي نَشَّربو جْديد معاكُم فالمَلَكوت مْتاع بابا.\" ");
INSERT INTO arq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","وبَعدما رَنّمو، خَرجو لجْبَل الزيتون. ");
INSERT INTO arq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","داك الساع قالَلهُم يَسوع: \"كامَل في هاد الليلة رايحين تَعَّترو على جالي، خاطَر مَكتوب: \"نَضرَب الراعي ويَتفَرّقو غْنَم القْطيع\"، ");
INSERT INTO arq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","وبَعد قْيامتي من الموت، نَسبَقكُم للجْليل.\" ");
INSERT INTO arq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","جاوَب بُطرُس وقاللو: \"لوكان كامَل يَعَّترو على جالَك، أنا عَمري ما نَعتَر\"، ");
INSERT INTO arq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","قاللو يَسوع: \"نْقوللَك الصَح باللي في هاد الليلة، قْبَل ما يْعوعَش السَردوك تَنْكُرتني تَلت مَرّات.\" ");
INSERT INTO arq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","قاللو بُطرُس: \"حَتّى لوكان يَلزَم عليَّ نْموت معاك، ما نَنكرَكش\"، وكامَل التابعين قالو كيما هُوَ. ");
INSERT INTO arq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","داك الساع، راح يَسوع معاهُم لواحَد المْكان وَسمو جَتسيماني وقال للتابعين: \"أَقُّعدو هْنا مابيد نْروح لْهيك نَصَلّي\"، ");
INSERT INTO arq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","وأدّا معاه بُطرُس ووْلاد زَبدي في زوج وبْدا يْحَس بالحْزَن والقْلَق. ");
INSERT INTO arq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","داك الساع قالَلهُم: \"نَفسي راهي حْزينة بَزّاف حَتّى للموت، أَبقاو هْنا وأسَّهرو معايَ\"، ");
INSERT INTO arq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","وأَدَّنّا شْويّة للقُدّام ورْكَع ساجَد يصَلّي ويْقول: \"بابا، وَلاَّ يَمكَن، بَعَّد عليَّ هاد الكاس، بَصَّح ماشي كيما نْحَب أنا، كيما تْحَب أنتَ.\" ");
INSERT INTO arq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","وجا للتابعين ولْقاهُم راقدين، وقال لبُطرُس: \"هَكدا ما كانَتش عَندكُم القُوّة باش تَسَّهرو ساعة واحدة معايَ؟ ");
INSERT INTO arq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","أَسَّهرو وصَلّيو باش ما تَدُّخلوش في غْواية، الروح مَتحَمَّس بَصَّح الدات ضْعيفة.\" ");
INSERT INTO arq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","وزاد بَعَّد المَرّة التانية، صَلاّ وقال: \"بابا، ولا ما يَمكَنش تْبَعَّد عليَّ هاد الكاس ولازَم نَشرَبها، خَلّي مُرادَك يْكون\"، ");
INSERT INTO arq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","وزاد راح للتابعين ولْقاهُم راقدين خاطَر تْقالو عينيهُم بالنْعاس. ");
INSERT INTO arq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","خَلاّهُم وزاد بَعَّد، صَلاّ المَرّة التالتة وعاوَد الكْلام اللي قالو. ");
INSERT INTO arq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","داك الساع جا للتابعين وقالَلهُم: \"مازالكُم راقدين ومْرَيّحين، وبْن الإنسان قَرّبَت الساعة اللي يَتسَلَّم فيها ليَدّين الخاطيين، ");
INSERT INTO arq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","نوضو نْروحو، هاو اللي يْسَلَّمني قْريب.\" ");
INSERT INTO arq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","كي كان يَهدر، جا يَهودا، واحَد من التابعين الطْناش، ومعاه غاشي كْبير بسْيوفة ومْطارَق، مَبعوتين من رِيّاس رْجال الدين وشْيوخ الشَعب. ");
INSERT INTO arq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","اللي سَلّمو عْطالهُم المارة وقال: \"اللي نْسَلَّم عليه، هَداك هُوَ، أَحَّكموه.\" ");
INSERT INTO arq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","وتَم تَم أدَّنّا عَند يَسوع وقاللو: \"سَلام شيخ\" وباسو. ");
INSERT INTO arq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","قاللو يَسوع: \"صاحبي، دير الشي اللي جيت عليه\". داك الساع، أدَّنّاو، حَطّو يَدّيهم على يَسوع وحَكموه، ");
INSERT INTO arq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","وواحَد من اللي كانو مع يَسوع مَد يَدّو وجْبَد السيف مْتاعو وضْرَب الخْديم مْتاع رايَس رْجال الدين ونَحّالو وَدنو. ");
INSERT INTO arq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","داك الساع قاللو يَسوع: \"رَد السيف مْتاعَك لمْكانو، خاطَر كامَل اللي يَرَّفدو السيف يْموتو بالسيف، ");
INSERT INTO arq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","عَند بالَك ما نَقدَرش نَطلَب دُرك من بابا ويْحَط معايَ تَم تَم كْتَر من طْناشَن جيش مْتاع المَلايكة؟ ");
INSERT INTO arq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","كيفاش هِمّالا يَتحَقَّق المَكتوب باللي لازَم يَصرا هَكدا؟\" ");
INSERT INTO arq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","في هَديك الساعة، قال يَسوع للغاشي: \"خْرَجتو تَحَّكموني بسْيوفة ومْطارَق كي شْغُل سَرّاق. كُنت كُل يوم قاعَد نْدَرَّس فالمَعبَد وما حْكَمتونيش. ");
INSERT INTO arq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","هَدا كامَل صْرا باش يَتحَقّقو كْتوب الأَنبيا\". داك الوَقت، كامَل التابعين خَلاّوَه وهَربو. ");
INSERT INTO arq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","هَدوك اللي حَكمو يَسوع أَدّاوَه عَند قْيافا رايَس رْجال الدين وين تْلايمو الكُتّاب والشْيوخ. ");
INSERT INTO arq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","بُطرُس تَبّعو من بْعيد حَتّى لوَسط دار رايَس رْجال الدين ودْخَل وقْعَد الداخَل مع العَسّاسين باش يْشوف كيفاش تَخلاص الدَعوة. ");
INSERT INTO arq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ريّاس رْجال الدين والمَجلَس الديني كامَل كانو يْحَوّسو شْهادة زور ضَد يَسوع باش يَقُّتلوه، ");
INSERT INTO arq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","بَصَّح ما لْقاوْش، والو جاو شْهود زور بَزّاف. من بَعد، جاو زوج، ");
INSERT INTO arq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","وقالو: \"هاد الراجَل قال: \"نَقدَر نْرَيَّب بيت مَقدَس الله ونَبنيه في تَلت أيّام.\" ");
INSERT INTO arq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ناض رايَس رْجال الدين وقال ليَسوع: \"ما تْجاوَب والو على واش راهُم هَدو يَشَّهدو ضَدَّك؟\" ");
INSERT INTO arq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","يَسوع كان ساكَت، ورايَس رْجال الدين قاللو: \"نَحَلّفَك بالله الحَي باش تْقولَلنا وَلاّ أنتَ هُوَ المَسيح بْن الله.\" ");
INSERT INTO arq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","قاللو يَسوع: \"راك قُلتها، ونْزيد نْقولَلكُم، من دُرك تْشوفو بْن الإنسان قاعَد على يْمين القُدرة وجاي على سْحابات السْما.\" ");
INSERT INTO arq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","داك الساع، قَطَّع رايَس رْجال الدين حْوايجو وقال: \"راهو يَكفَر، واش نْزيدو نَسَّحقو شْهود؟ راكُم دُرك سْمَعتو الكُفر مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","واش رايكُم؟\" جاوبوه: \"يَستاهَل الموت.\" ");
INSERT INTO arq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","داك الساع، بَزقو على وَجهو وضَربوه وصَقّلوه، ");
INSERT INTO arq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","وقالو: \"أتْنَبّأ علينا، يا المَسيح، شْكون اللي ضَربَك؟\" ");
INSERT INTO arq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","كان بُطرُس قاعَد بَرّا في وَسط الدار، وأدَّنات ليه واحَد الخْديمة وقالَت: \"أنتَ تاني كُنت مع يَسوع الجْليلي.\" ");
INSERT INTO arq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","بُطرُس نْكَر قُدّام كامَل الناس، وقال: \"ما رانيش عارَف علَمّاش راكي تَهَّدري\". ");
INSERT INTO arq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","خْرَج عَند الباب، شافتو خْديمة واحَدُخرى وقالَت للي كانو تَمّة: \"هَدا كان مع يَسوع الناصري\"، ");
INSERT INTO arq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","وزاد نْكَر وهُوَ يَحلَف: \"ما نَعرَفش هاد الراجَل.\" ");
INSERT INTO arq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ومن بَعد شْويّة، قَرّبو ليه اللي كانو تَمّة وقالولو: \"صَح أنتَ واحَد منهُم، بايَن من هَدَّرتَك.\" ");
INSERT INTO arq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","داك الساع، بْدا يَدعي ويَحلَف: \"ما نَعرَفش هاد الراجَل\"، وتَم تَم عوعَش السَردوك، ");
INSERT INTO arq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","وتْفَكَّر بُطرُس الكْلام اللي قالهولو يَسوع باللي \"قْبَل ما يْعوعَش السَردوك تَنْكُرتني تَلت مَرّات\"، وكي خْرَج بَرّا، بْكا بالمْرارة. ");
INSERT INTO arq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","كي طْلَع النْهار، تْشاورو كامَل رِيّاس رْجال الدين وشْيوخ الشَعب على يَسوع باش يَقَّتلوه، ");
INSERT INTO arq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","وبَعدما رَبطوه، أَدّاوَه وسَلّموه لبيلاطَس الحاكَم. ");
INSERT INTO arq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","داك الساع، كي شاف يَهودا اللي سَلّمو باللي أتَّحكَم عليه بالموت، نْدَم ورَد التْلاتين دينار مْتاع الفَضّة لريّاس رْجال الدين والشْيوخ، ");
INSERT INTO arq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","وقال: \"خْطيت كي سَلَّمت دَم واحَد فالباطَل\". قالولو: \"وحْنا عْلاه؟ شوف أنتَ.\" ");
INSERT INTO arq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ورْما دراهَم الفَضّة في بيت المَقدَس، وراح عَلَّق روحو. ");
INSERT INTO arq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","أَدّاو ريّاس رْجال الدين دراهَم الفَضّة وقالو: \"ما يْجوزش يَنحَطّو هَدو في صَندوق المَعبَد خاطَر هَدي سومة الدَم.\" ");
INSERT INTO arq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","وبَعدما تْشاورو، شْراو بيهُم حوش الفَخّارجي باش يَدَّفنو فيه البْراويّة، ");
INSERT INTO arq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","على هَدا تْسَمّا هَداك الحوش \"حوش الدَم\" حَتّى لليوم. ");
INSERT INTO arq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","داك الساع تْحَقَّق كْلام إرمِيا النَبي اللي يْقول: \"خْداو التْلاتين دينار مْتاع الفَضّة، سومة اللي دارولو بْني إسرائيل السومة، ");
INSERT INTO arq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","وعْطاوهُم لحوش الفَخّارجي كيما آمَرني الرَب.\" ");
INSERT INTO arq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","وْقَف يَسوع قُدّام الحاكَم اللي سَقساه وقال: \"أنتَ هُوَ سَلطان اليْهود؟\" جاوبو يَسوع: \"راك قُلتها.\" ");
INSERT INTO arq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","وكي كانو ريّاس رْجال الدين والشْيوخ يَتَّهمو فيه، ما جاوَب بحَتّى حاجة. ");
INSERT INTO arq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","داك الساع قاللو بيلاطَس: \"ما راكش تَسمَع واش راهُم يَشَّهدو ضَدَّك؟\" ");
INSERT INTO arq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","وما جاوبو على حَتّى كَلمة حَتّى سْتَعجَب الحاكَم بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","كان الحاكَم عَندو عادة، كان في كُل عيد يَطلَق للغاشي المْحابسي اللي يَطَّلبوه. ");
INSERT INTO arq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","وكان عَندهُم داك الوَقت مْحابسي مَشهور وَسمو باراباس. ");
INSERT INTO arq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","وكي كان الغاشي مَتلايَم سَقساهُم بيلاطَس: \"شْكون تَحَبّو نَطلَقَّلكُم، باراباس وَلاّ يَسوع اللي يَعيّطولو المَسيح؟\" ");
INSERT INTO arq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","خاطَر كان عارَف باللي سَلّموه غيرة. ");
INSERT INTO arq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","كي كان قاعَد على الكُرسي مْتاع الشْرَع، بْعتَتلو مَرتو تْقول: \"ما يْكون والو بينَك وبين هاد الصالَح خاطَر اليوم تْعَدَّبت بَزّاف فالمْنام على جالو.\" ");
INSERT INTO arq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","رِيّاس رْجال الدين والشْيوخ قَنّعو الغاشي باش يَطَّلبو باراباس ويْنَقتَل يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","جاوَب الحاكَم وقالَلهُم: \"شْكون فيهُم في زوج حَبّيتو نَطلَقَّلكُم؟\" قالو: \"باراباس\"، ");
INSERT INTO arq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","قالَلهُم بيلاطَس: \"واش نْدير مع يَسوع اللي يْعَيّطولو المَسيح؟\" قالو كامَل: \"يَتَّصلَب\"، ");
INSERT INTO arq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","سَقساهُم الحاكَم: \"واش من شَر دارو؟\" زادو عَيّطو كْتَر وقالو: \"يَتَّصلَب\". ");
INSERT INTO arq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","كي شاف بيلاطَس باللي ما كان يَستفاد والو، والهول زادَ كْتَر، خْدا الما، غْسَل يَدّيه قُدّام الغاشي وقال: \"راني مْبَرّي من دَم هاد الصالَح، دَبّرو راسكُم.\" ");
INSERT INTO arq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","جاوَب كامَل الشَعب وقال: \"دَمّو على رَقبَتنا وعلى رَقبة وْلادنا\". ");
INSERT INTO arq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","داك الوَقت، طْلَقَّلهُم بيلاطَس باراباس، ويَسوع جَلدو وسَلّمو باش يَتَّصلَب. ");
INSERT INTO arq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","داك الساع، أدّاو عَسكَر الحاكَم يَسوع لدار الحُكومة، ولَمّو عليه كامَل الكَتيبة، ");
INSERT INTO arq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","نَحّاولو حْوايجو ولَبّسولو لْباس حْمَر حامَق، ");
INSERT INTO arq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","وضَفرو تاج مْتاع الشوك وحَطّوه على راسو ودارولو قَصبة في يَدّو اليْمنى، وبْداو يَرَّكعولو، يَتمَسخرو بيه ويْقولو: \"يَحيا سَلطان اليْهود\"، ");
INSERT INTO arq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","وبَزقو عليه، خْداو القَصبة وضَربوه بيها على راسو. ");
INSERT INTO arq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","وبَعدما تْمَسخرو بيه، نَحّاولو اللْباس الحْمَر ولَبّسولو حْوايجو وأدّاوَه باش يَصَّلبوه. ");
INSERT INTO arq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","كي خَرجو، لْقاو واحَد الراجَل قيرواني وَسمو سَمعان، وسَيّفو عليه باش يَرفَد الصْليب مْتاع يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","وكي وَصلو لواحَد المْكان يْسَمّيوَه جُلجُتة، واللي مَعناه مْكان الجُمجُمة، ");
INSERT INTO arq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","عْطاو ليَسوع يَشرَب شْراب مْخَلَّط بالمْرار، وكي داقو ما حَبش يَشرُب. ");
INSERT INTO arq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","وبَعدما صَلبوه، تْقاسمو حْوايجو بالقُرعة، ");
INSERT INTO arq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","وقَعدو تَمّة يْعَسّوه، ");
INSERT INTO arq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ودارو فوق راسو لوحة كَتبو عليها السَبّة اللي نْصلَب على جالها: \"هَدا هُوَ يَسوع سَلطان اليْهود.\" ");
INSERT INTO arq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","صَلبو معاه داك الوقت زوج سَرّاقين، واحَد على اليْمنى وواحَد على اليْسرى. ");
INSERT INTO arq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","واللي كانو جايزين كانو يْسَبّو فيه وهومَ يْهَزّو في ريسانهُم، ");
INSERT INTO arq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ويْقولو: \"يا اللي تْهَد بيت المَقدَس وتَبنيه في تَلت أيّام، سَلَّك روحَك وَلاّ كُنت بْن الله، وأهبَط من الصْليب.\" ");
INSERT INTO arq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","رِيّاس رْجال الدين مع الكُتّاب والشْيوخ تاني كانو يَتمَسخرو بيه ويْقولو: ");
INSERT INTO arq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","\"سَلَّك الأخرين وما يَقدَرش يْسَلَّك روحو. وَلاّ كان هُوَ سَلطان إسرائيل، يَهبَط دُرك من الصْليب ونامنو بيه، ");
INSERT INTO arq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","تْكَل على الله، يْسَلّكو الله دُرك وَلاّ كان مُرادو خاطَر قال: \"أنا بْن الله\"\". ");
INSERT INTO arq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","السَرّاقين اللي كانو مَصلوبين معاه تاني كانو يْعايرو فيه هَكداك. ");
INSERT INTO arq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","وجا ضْلام على الأرض كامَل من الطْناش حَتّى للتْلاتة مْتاع العْشيّة، ");
INSERT INTO arq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","جْوايَه التْلاتة مْتاع العْشيّة، عَيَّط يَسوع بالزور وقال: \"إيلي، إيلي، لَما شَبَقتني؟\" مَعنَتها: \"إلَهي، إلَهي، وَعلاش خَلّيتني؟\" ");
INSERT INTO arq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","شْويّة من اللي كانو واقفين تَمّة، كي سَمعو قالو: \"راهو يْعَيَّط لإيلِيّا\". ");
INSERT INTO arq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","وتَم تَم، راح واحَد فيهُم يَجري، خْدا سْفَنجة، عَمَّرها بالخَل، لَوّاها على قَصبة وعْطالو يَشرُب. ");
INSERT INTO arq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","الأُخرين قالو: \"خَلّي، نْشوفو إيلا يْجي إيليّا يْسَلّكو\"، ");
INSERT INTO arq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","زاد يَسوع عَيَّط بالزور وسَلَّم الروح، ");
INSERT INTO arq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","وهاو وين تْقَطَّع حْجاب بيت المَقدَس على زوج من الفوق للتَحت، وتْزَعزعَت الأَرض، ونْشَقّ الحْجر، ");
INSERT INTO arq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ونْحَلّو القْبور، ودات بَزّاف من القَدّيسين اللي كانو راقدين تَمة قامو من الموت، ");
INSERT INTO arq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","وخَرجو من القْبور بعد قْيامة يَسوع، ودَخلو للمْدينة المْقَدسة وشافوهُم ناس بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","قايَد المْية واللي كانو يْعَسّو يَسوع معاه، كي شافو الزَنزلة والحاجات اللي صْراو خافو بَزّاف وقالو: \"صَح كان هَدا بْن الله\"، ");
INSERT INTO arq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","وكانو تَمّة بَزّاف النْسا اللي تَبّعو يَسوع من الجْليل وهومَ يَخَّدموه، يْشوفو من البْعيد، ");
INSERT INTO arq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","مَنهُم مَريَم المَجدليّة ومَريَم يَمّاة يَعقوب ويوسي ويَمّاة وْلاد زَبدي. ");
INSERT INTO arq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","وكي جات العْشيّة، جا راجَل مْرفَّه من الرامّة واسمو يوسَف، هُوَ تاني كان تابَع يَسوع. ");
INSERT INTO arq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","راح عَند بيلاطَس وطْلَب دات يَسوع، وآمَر بيلاطَس باش يَعطيوهالو. ");
INSERT INTO arq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","خْدا يوسَف الدات، وكَفّنو في كْفَن نْقي، ");
INSERT INTO arq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","وحَطّو في قْبَر جْديد، كان حَفرو ليه فالصْخَر وطَبَّع حَجرة كْبيرة على الدَخلة مْتاع القْبَر وراح. ");
INSERT INTO arq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","كانو تَمّة مَريَم المَجدلِيّة ومَريَم الأخرى قاعدين مْقابَل القْبَر. ");
INSERT INTO arq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","غَدوة من داك، كان اليوم اللي بَعد يوم التَوجاد، وتْلايمو رِيّاس رْجال الدين والفَرّيسِيّين عَند بيلاطَس، ");
INSERT INTO arq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","وقالو: \"سيدي، رانا شافيين باللي هَداك الخَدّاع قال كي كان حَي: \"بَعد تَلت أيّام نْقوم من الموت\"، ");
INSERT INTO arq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","آمَر هِمّالا باش يَبقا القْبَر تَحت العَسّة حَتّى لليوم التالَت يْعودو يْجيو التابعين مْتاعو يَسَّرقوه ويْقولو للشَعب: \"قام من بين الموتى\"، وتْكون الكَدبة الأخّرانِية كْتَر من الأوّلانِيّة.\" ");
INSERT INTO arq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","قالَلهُم بيلاطَس: \"هامليك عَسّاسين، روحو عَسّو القْبَر كيما تْحَبّو.\" ");
INSERT INTO arq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","وراحو حَطّو عَسّاسين على القْبَر بَعدما شَمّعو الحَجرة. ");
INSERT INTO arq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","بَعد السَبت، عَند فْجَر اليوم الأوَّل مْتاع الجَمعة، راحَت مَريَم المَجدَليّة ومَريَم الأخرى يْشوفو القْبَر، ");
INSERT INTO arq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","وهاي وين ضَربَت زَنزلة كْبيرة، خاطَر مْلاك الرَب هْبَط من السْما ودَنّا الحَجرة بجيه وقْعَد عليها. ");
INSERT INTO arq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","الصِفة مْتاعو كانَت كي البْرَق ولْباسو بْيَض كي التَلج. ");
INSERT INTO arq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","من الخوف مَنّو بْداو العَسّاسين يَتَّرعدو ووَلاّو كي الموتى، ");
INSERT INTO arq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","نْطَق المْلاك وقال للنْسا: \"ما تْخافوش أنتومَ، خاطَر راني عارَف باللي راكُم تْحَوّسو على يَسوع المَصلوب، ");
INSERT INTO arq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ما راهوش هْنا، قام من الموت كيما قال. أَرواحو تْشوفو المْكان اللي كان مْكَسَّل فيه، ");
INSERT INTO arq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","روحو بالخَف قولو للتابعين مْتاعو باللي قام من بين الموتى، وهاو يَسبَقكُم للجْليل وتَمّة اللي تْشوفوه، هاني قُلتَلكُم.\" ");
INSERT INTO arq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","بَعّدو النْسا بالخَف من القْبَر خايفين وفَرحانين بَزّاف وراحو يَجريو يْخَبّرو التابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","وهاو وين لاقاهُم يَسوع وقال: \"سَلام\". أدَّنّاو ليه، شَدّو رَجليه وسَجدولو. ");
INSERT INTO arq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","قالَلهُم: \"ما تْخافوش، روحو خَبّرو خاوتي باش يْروحو للجْليل وتَمّة يْشوفوني.\" ");
INSERT INTO arq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","كي كانو رايحين، شي عَسّاسين جاو للمْدينة وخَبّرو رِيّاس رْجال الدين بكامَل الشي اللي صْرا. ");
INSERT INTO arq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","تْلَمّو رِيّاس رْجال الدين مع الشْيوخ وتْشاورو وشَدّو دْراهَم بَزّاف عْطاوهُم للعَسكَر، ");
INSERT INTO arq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","وقالو: \"قولو باللي التابعين مْتاعو جاو فالليل سَرقوه كي كُنّا راقدين، ");
INSERT INTO arq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ولو كان يَسمَع الحاكَم بهاد الشي، نْقَنّعوه ونْبعّدو عليكُم المُشكِل\". ");
INSERT INTO arq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","أدّاو العَسكَر دْراهَم الفَضّة ودارو كيما قالولهُم، وشاع هاد الكْلام عَند اليْهود حَتّى لليوم. ");
INSERT INTO arq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","التابعين الحْداش راحو للجْليل للجْبَل اللي قالَلهُم عليه يَسوع، ");
INSERT INTO arq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","وكي شافوه سَجدو بَصَّح كايَن مَنهُم اللي شَكّو. ");
INSERT INTO arq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","أدَّنّا يَسوع، كَلَّمهُم وقال: \"كُل حُكمة أتَّعطاتلي فالسْما وعلى الأرض، ");
INSERT INTO arq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","روحو وديرو في كُل الأمّات تابعين وعَمدوهُم بآسَم الآب والإبن والروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","وعَلّموهُم يْطَبّقو كامَل واش آمَرتكُم بيه، وأنا راني معاكُم كُل يوم حَتّى لآخَر الزْمان\".");
INSERT INTO arq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","البَدية مْتاع إِنجيل يَسوع المَسيح بْن الله. ");
INSERT INTO arq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","على حْساب ما نَكتَب في كْتاب إِشعِيا النَبي: \"هاني نَبعَت قَبلَك مَرسولي اللي يْوَجَّدلَك الطْريق، ");
INSERT INTO arq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","هُوَ الصوت اللي يْعَيَّط فالخْلا: \"وَجّدو طْريق الرَب، سَلّسو طُرقانو\"\". ");
INSERT INTO arq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","هَكدا جا يوحَنّا المَعمَدان يْعَمَّد فالخْلا ويْبَرَّح بمَعموديّة التوبة لغُفران الدْنوب، ");
INSERT INTO arq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","وكانَت تْجي ليه كامَل جيهة اليَهودِيّة وكامَل ناس أورشَليم وكانو يَتعَمدو على يَدّو في واد الأردُن وهومَ يَستَعرفو بدْنوبهُم، ");
INSERT INTO arq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","وكان يوحَنّا يَلبَس هْبَر الجْمَل ويْحَزَّم بالجَلد، وياكُل الجْراد والعْسَل الحُر. ");
INSERT INTO arq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","وكان يْبَرَّح ويْقول: \"يْجي مورايَ اللي قْوِيّ علِيَّ، اللي ما نَستاهَلش نْطابَس ونْحَل رْباط سَبّاطو، ");
INSERT INTO arq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","أنا عَمَّدتكُم بالما، بَصَّح هُوَ يْعَمَّدكُم بالروح القُدّوس\". ");
INSERT INTO arq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","في هَدوك اليامات جا يَسوع من الناصرة من الجْليل وتْعَمَّد في واد الأردُن على يَد يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","وغير كان خارَج من الما، شاف السْماوات يَنحَلّو والروح يَهبَط عليه كي حْمامة، ");
INSERT INTO arq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","وجا صوت من السْماوات: \"أنتَ وْليدي الحْبيب، أنتَ هُوَ فَرحتي\". ");
INSERT INTO arq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","تَم تَم بَعتو الروح للخْلا، ");
INSERT INTO arq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","وبْقا فالخْلا رَبعين يوم والشيطان يْجَرَّب فيه، وكان مع الوْحوش والمَلايكة يَخَّدمو فيه. ");
INSERT INTO arq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","وبَعدما نَحكَم يوحَنّا، جا يَسوع للجْليل يْبَرَّح بإِنجيل الله، ");
INSERT INTO arq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ويْقول باللي وْصَل الوَقت وقَرَّب مَلَكوت الله، توبو وآمنو بالإِنجيل.\" ");
INSERT INTO arq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","وكي كان جايَز على بْحَر الجْليل، شاف سَمعان وأَندراوَس خوه يَرميو الشَبكة فالبْحَر، كانو صِيّادين، ");
INSERT INTO arq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","وقالَلهُم يَسوع: \"تَبّعوني ونْرَجَّعكُم تْصَيّدو بْني آدَم.\" ");
INSERT INTO arq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","تَم تَم خَلاّو الشْبَك وتَبّعوه. ");
INSERT INTO arq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","أَدَّنّا شْويّة وشاف يَعقوب بَن زَبَدي ويوحَنّا خوه وهومَ فالفْلوكة يْرَقّعو الشْبَك، ");
INSERT INTO arq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","وبالخَف عَيَّطَّلهُم، وخَلاّو باباهُم زَبَدي فالفْلوكة مع الخَدّامين وراحو تَبّعوه. ");
INSERT INTO arq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","وراحو لكَفرناحوم وتَم تَم، فالسَبت، دْخَل يَسوع لمَجمَع اليْهود وبْدا يْدَرَّس، ");
INSERT INTO arq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","وكانو داهشين فالتَعليم مْتاعو، خاطَر كان يْدَرَّسهُم كي اللي عَندو الحُكمة وماشي كيما الكُتّاب. ");
INSERT INTO arq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","وكان كايَن فالمَجمَع مْتاعهُم واحَد مَسكون بروح ناجَس، بْدا يْعَيَّط، ");
INSERT INTO arq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ويْقول: \"واش بيننا وبينَك يا يَسوع الناصري؟ جيت باش تْضَيَّعنا؟ راني عارَف شْكون أنتَ، أنتَ قُدّوس الله.\" ");
INSERT INTO arq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","هَدّدو يَسوع وقال: \"أَسكُت وأخرُج مَنّو\"، ");
INSERT INTO arq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","هَزّ الروح الناجَس الراجَل اللي كان ساكنو، عَيَّط بالزور وخْرَج مَنّو. ");
INSERT INTO arq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","وكامَل خافو حَتّى بْداو يْسَقسيو بَعضهُم بَعض ويْقولو: \"واشَن هَدا؟ تَعليم جْديد وبالحُكمة، ويامَر الأرواح الناجسين ويْطيعوه\". ");
INSERT INTO arq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","وبالخَف شاع خَبرو في كامَل جيهة الجْليل. ");
INSERT INTO arq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","وغير خَرجو من المَجمَع، راحو لدار سَمعان وأَندراوَس مع يَعقوب ويوحَنّا، ");
INSERT INTO arq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","وكانَت نْسيبة سَمعان راقدة بالحَمّة، وهَدرو ليَسوع عليها. ");
INSERT INTO arq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","قَرَّب، شَدّها من يَدّها ونَوَّضها، وراحَتلها الحَمّة وبْدات تَخدَمهُم. ");
INSERT INTO arq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","كي جات العْشِيّة، كي غَربَت الشَمس، جابولو كامَل اللي عَندهُم مَرض والمَسكونين بالشْياطَن، ");
INSERT INTO arq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","والمْدينة كانَت كامَل مَتلايمة عَند الباب. ");
INSERT INTO arq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","وشْفا بَزّاف اللي كانو يْعانيو من مْراض مَتنَوّعين، وخَرَّج شْياطَن بَزّاف وما خَلاّهُمش يَهَّدرو خاطَر كانو يَعَّرفوه. ");
INSERT INTO arq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","الصْباح، قْبَل ما يَخلاص الليل، ناض يَسوع وخْرَج وراح لمْكان خالي وبْدا يْصَلّي تَمّة. ");
INSERT INTO arq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","راح سَمعان واللي معاه يْحَوّسو عليه، ");
INSERT INTO arq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","لْقاوَه وقالولو: \"راهُم كامَل يْحَوّسو عليك\"، ");
INSERT INTO arq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","قالَلهُم: \"هَيّاو نْروحو لجيهة أخرى، للدْشور القْراب باش نْبَشَّر تَمّة تاني، خاطَر على هَدا اللي جيت.\" ");
INSERT INTO arq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","وراح يْبَشَّر فالمْجامَع مْتاع كامَل الجْليل ويْخَرَّج الشْياطَن. ");
INSERT INTO arq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","وجا ليه واحَد مْريض بالبْرَص يْحَلَّل فيه، رْكَع على رْكايبو وقاللو: \"وَلاّ حَبّيت، تَقدَر تْرَدّني طاهَر.\" ");
INSERT INTO arq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","حَن يَسوع ومَد يَدّو، مَسّو وقاللو: \"نْحَب، أَطهَر\"، ");
INSERT INTO arq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","تَم تَم راح عليه البْرَص ورْجَع طاهَر. ");
INSERT INTO arq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","سَرّحو يَسوع بَعدما وَصّاه، ");
INSERT INTO arq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","وقاللو: \"شوف، ما تْقول حَتّى حاجة لحَتّى واحَد، بَصَّح روح وَرّي روحَك لراجَل الدين ومَد على تَطهيرَك اللي آمَر بيه موسى، باش تْكون شْهادة ليهُم.\" ");
INSERT INTO arq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","وهُوَ كي خْرَج، بْدا يْبَوَّق ويْشَيَّع فالخْبَر، حَتّى ما وَلاّش يَسوع يَقدَر يَدخُل لمْدينة عيناني، وكان يَقعَد في مْضارَب خاليين وكانو يْجيو ليه من كُل جيهة. ");
INSERT INTO arq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","بَعد يامات، زاد دْخَل يَسوع لكَفرناحوم، وأتَّسمَع باللي كان فالدار، ");
INSERT INTO arq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","وتْلايمو عَندو ناس بَزّاف حَتّى ما بْقاش مْكان يا لوكان عَند الباب، وكان يْقولَلهُم كْلام الله. ");
INSERT INTO arq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","وجاو جابولو واحَد مَشلول رافدينو رَبع رْجال، ");
INSERT INTO arq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","وكي ما قَدروش يْجَوّزوه على جال الغاشي، عَرّاو السْقَف وين كان يَسوع، تَقبوه ودَلاّو مَنّو الفْراش اللي كان المَشلول مْكَسَّل فيه. ");
INSERT INTO arq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","وكي شاف يَسوع إيمانهُم، قال للمَشلول: \"وْليدي، دْنوبَك راهُم مَغفورين.\" ");
INSERT INTO arq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","وكانو شي كُتّاب قاعدين تَمّة ويْخَمّمو في قْلوبهُم: ");
INSERT INTO arq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"عْلاش هَدا راه يَهدَر هَكدا؟ راه يَكفَرٍ. شْكون يَقدَر يَغفَر الدْنوب من غير الله وَحدو؟\" ");
INSERT INTO arq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","تَم تَم، عْرَف يَسوع بالروح مْتاعو باللي كانو يْخَمّمو هَكدا في نْفوسهُم وقالَلهُم: \"وَعلاش راكُم تْخَمّمو هَكدا في قْلوبكُم؟ ");
INSERT INTO arq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","أما ساهَل؟ يَتقال للمَشلول: \"دْنوبَك مَغفورين\"، وَلاّ يَتقال: \"نوض، أَرفَد فْراشَك وأمشي؟\" ");
INSERT INTO arq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","باش تَعَّرفو باللي بْن الإنسان عَندو الحُكمة على الأَرض باش يَغفَر الدْنوب، وقال للمَشلول: ");
INSERT INTO arq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"ليك نْقول، نوض، أرفَد فْراشَك وروح لدارَك.\"\" ");
INSERT INTO arq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ناض وتَم تَم رْفَد الفْراش وخْرَج قُدّامهُم كامَل، حَتّى دَهشو وبْداو يْسَبّحو فالله ويْقولو باللي: \"عْمَرنا ما شَفنا شي كي هَدا.\" ");
INSERT INTO arq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","وزاد خْرَج يَسوع لشَط البْحَر وجا ليه الغاشي كامَل وبْدا يْدَرَّس فيهُم، ");
INSERT INTO arq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","وكي كان جايَز، شاف لاوي بَن حَلفى قاعَد وين يْخَلّصو الغْرامة وقاللو: \"تَبَّعني\". ناض لاوي وتَبّعو. ");
INSERT INTO arq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","وكان يَسوع قاعَد على الميدة عَند لاوي هُوَ والتابعين مْتاعو، وبَزّاف المَكّاسين والخاطيين قاعدين معاه، خاطَر كانو بَزّاف وكانو يْتَبّعوه، ");
INSERT INTO arq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","والكُتّاب مْتاع الفَرّيسِيّين شافو باللي كان ياكُل مع الخاطيين والمَكّاسين وقالو للتابعين مْتاعو: \"وَعلاش ياكُل مع المَكّاسين والخاطيين؟\" ");
INSERT INTO arq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","كي سْمَع يَسوع قالَلهُم باللي \"ماشي الصْحاح اللي يَسَّحقو طْبيب، المَرضى هومَ اللي يَسَّحقوه. أنا ما جيتش نْعَيَّط للصالحين، جيت نْعَيَّط للخاطيين.\" ");
INSERT INTO arq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","التابعين مْتاع يوحَنّا والفَرّيسِيّين كانو يْصومو، وجاو قالو ليَسوع: \"وَعلاش تابعين يوحَنّا وتابعين الفَرّيسِيّين يْصومو، والتابعين مْتاعك ما يْصوموش؟\" ");
INSERT INTO arq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","قالَلهُم يَسوع: \"يَقَّدرو حْباب العَرس يْصومو والعْريس معاهُم؟ ما دام العْريس معاهُم ما يَقَّدروش يْصومو، ");
INSERT INTO arq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","يْجيو يامات وين يَتَّرفَع العْريس من عَندهُم، داك الساع يْصومو في داك اليوم. ");
INSERT INTO arq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","واحَد ما يْرَقَّع لَبسة قْديمة بطَرف قْماش جْديد، وَلاّ ماكاش الطَرف الجْديد يْفَزَّر القْديم وتْوَلّي التُقبة كْتَر من اللي كانَت، ");
INSERT INTO arq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","وواحَد ما يْدير شْراب جْديد في ڤَربات قْدَم، وَلاّ ما كاش الشْراب يْقَطَّع الڤَربات، ويْضيع الشْراب والڤَربات، بَصَّح الشْراب الجْديد يَندار في ڤَربات جْدَد.\" ");
INSERT INTO arq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","جاز يَسوع في يوم سَبت على حْواش مْتاع القَمح، وبْداو التابعين مْتاعو يْنَحّيو فالسْبول وهومَ ماشيين، ");
INSERT INTO arq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","وقالولو الفَرّيسِيّين: \"شوف، وَعلاش راهُم يْديرو الشي اللي ماشي جايَز فالسَبت؟\" ");
INSERT INTO arq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","قالَلهُم: \"عْمَركُم ما قْريتو واش دار داوَد كي حْتاج وجاع هُوَ واللي كانو معاه؟ ");
INSERT INTO arq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","كيفاش دْخَل لدار الله في زْمان أبياتار رايَس رْجال الدين، وكْلا خُبز التَقدِمة اللي كان جايَز غير لرْجال الدين باش ياكلوه، وعْطا لَلي كانو معاه تاني؟\" ");
INSERT INTO arq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","وقالَلهُم: \"السَبت نْدار للإِنسان ماشي الإِنسان للسَبت، ");
INSERT INTO arq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","حَب يْقول بْن الإِنسان هُوَ سيد السَبت تاني\". ");
INSERT INTO arq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","وزاد دْخَل يَسوع لمَجمَع اليْهود وكان تَمّة راجَل يَدّو مَشلولة، ");
INSERT INTO arq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","وبْداو يْعَسّو في يَسوع، وَلاّ يَشفيه فالسَبت باش يَتَّهموه. ");
INSERT INTO arq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","قال يَسوع للراجَل اللي يَدّو مَشلولة: \"أوقَف فالوَسط\"، ");
INSERT INTO arq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","وقالَلهُم: \"يْجوز فالسَبت يَندار الخير وَلاّ يَندار الشَر؟ يْسَلّكو حْياة وَلاّ يَقُّتلوها؟\" هومَ سَكتو. ");
INSERT INTO arq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","شاف فيهُم كامَل وهُوَ مْغَشَّش وحْزين على جال قْساوة قَلبهُم وقال للراجَل: \"كَسَّل يَدَّك\". كَسَّل الراجَل يَدّو وبْرات. ");
INSERT INTO arq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","خَرجو الفَرّيسِيّين تَم تَم مع الهيرودُسِيّين وتْفاهمو عليه باش يَقُّتلوه. ");
INSERT INTO arq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ويَسوع مع التابعين مْتاعو راحو للبْحَر وغاشي كْبير تَبّعو من الجْليل ومن اليَهودِيّة، ");
INSERT INTO arq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ومن أورشَليم ومن أدومِيّة ومور واد الأُردُن وجْوايَه صور وصَيدا. غاشي كْبير، كي سَمعو كامَل واش كان يْدير جاو ليه. ");
INSERT INTO arq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","وقال للتابعين مْتاعو باش يْحَطّولو فْلوكة صْغيرة على اليَد، على جال الزْحام مْتاع الغاشي، ");
INSERT INTO arq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","خاطَر كان شْفا بَزّاف من الناس حَتّى وَلاّو كامَل اللي عَندهُم مَرض يَتَّرماو عليه باش يْمَسّوه، ");
INSERT INTO arq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","والأرواح الناجسين كانو كي يْشوفوه، يَسَّجدولو ويْعَيّطو ويْقولو: \"أنتَ هُوَ بْن الله\"، ");
INSERT INTO arq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","وكان آمَرهُم بَزّاف باش ما يَكَّشفوهش. ");
INSERT INTO arq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","طْلَع للجْبَل وعَيّط للي سْحَقهُم وراحو ليه. ");
INSERT INTO arq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","خَيَّر طْناش، باش يْكونو معاه وباش يَبعَتهُم يْبَرّحو بالإنجيل، ");
INSERT INTO arq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","وتْكون عَندهُم الحُكمة باش يْخَرّجو الشْياطَن. ");
INSERT INTO arq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","وخَيَّر طْناش: سَمعان اللي عْطاه آسَم بُطرُس، ");
INSERT INTO arq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ويَعقوب بَن زَبَدي ويوحَنّا خو يَعقوب، اللي عْطالهُم آسَم بُوانَرجِس، ومَعنَتها وْلاد الرَعد، ");
INSERT INTO arq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","وأَندراوَس وفيلِبس وبَرتُلماوَس ومَتّى وتوما ويَعقوب بَن حَلفى وتَدّاوَس وسَمعان القانَوي، ");
INSERT INTO arq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ويَهودا الإسخَريوطي اللي سَلّمو. ");
INSERT INTO arq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","جا يَسوع للدار وزاد تْلَم الغاشي حَتّى ما قْدَروش ياكلو كْسيرة. ");
INSERT INTO arq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","وكي سَمعو مْوالين يَسوع، راحو يَحَّكموه خاطَر كانو يْقولو: \"راهو مْخَلخَل\". ");
INSERT INTO arq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","الكُتّاب اللي هَبطو من أورشَليم، كانو يْقولو باللي راه مَسكون ببَعلزَبول، وباللي راهو يْخَرَّج الشْياطَن برايَس الشْياطَن. ");
INSERT INTO arq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","عَيَّطَّلهُم يَسوع وقالَلهُم بالمْتال: \"كيفاش يَقدَر شيطان يْخَرَّج شيطان؟ ");
INSERT INTO arq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","وَلاّ كانَت بْلاد مَقسومة وفيها اللي خارجين ضَدّها، هاد البْلاد ما تَقدَرش تَتبَت، ");
INSERT INTO arq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","وَلاّ كانَت دار مَقسومة وفيها اللي خارجين ضَدّها، هاد الدار ما تَقدَرش تَتبَت، ");
INSERT INTO arq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","وَلاّ ناض الشيطان ضَد نَفسو وخْرَج ضَد روحو، ما يَقدَرش يَتبَت، وخْلاص أَمرو. ");
INSERT INTO arq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","واحَد ما يَقدَر يَدخُل لدار راجَل قْوي ويَسرَقلو مْلاكو وَلاّ ما سْبَقش رْبَط هاد الراجَل القْوي، وداك الساع يَسَّرقو في دارو. ");
INSERT INTO arq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","نْقولَلكُم الصَح، كُل شي يَتَّغفَر لبْني آدَم، الدْنوب والسَبّان اللي يْسَبّوه، ");
INSERT INTO arq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","بَصَّح اللي يَكفَر ضَد الروح القُدّوس ما يْنالش الغُفران للدْوام، يَبقا مْخَطّي بدَنب للدْوام\". ");
INSERT INTO arq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","هْدَر هَكدا خاطَر قالو: \"راه مَسكون بروح ناجَس\". ");
INSERT INTO arq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","وجاو يَمّاة يَسوع وخاوتو وبْقاو بَرّا وبَعتو يْعَيّطولو. ");
INSERT INTO arq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","كان غاشي كْبير قاعَد دايَر بيه وقالولو: \"هام يَمّاك وخاوتَك بَرّا يْحَوّسو عليك\"، ");
INSERT INTO arq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","جاوَبهُم وقال: \"شْكون هِيَ يَمّا وخاوتي؟\" ");
INSERT INTO arq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","وجَوَّز عينيه على اللي كانو قاعدين دايرين بيه وقال: \"هامليك يَمّا وخاوتي، ");
INSERT INTO arq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","خاطَر، اللي يْدير مُراد الله، هُوَ خويَ وخْتي ويَمّا\". ");
INSERT INTO arq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","وزاد يَسوع بْدا يْدَرَّس على شَط البْحَر، وتْلَم عليه غاشي كْبير بَزّاف حَتّى طْلَع في فْلوكة وقْعَد، وكامَل الغاشي كان على الأرض عَند البْحَر. ");
INSERT INTO arq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","كان يْدَرَّسَّلهُم حاجات بَزّاف بالمْتال وقالَلهُم فالتَعليم مْتاعو: ");
INSERT INTO arq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"أَسَّمعو، واحَد الفَلاّح خْرَج باش يَزرَع، ");
INSERT INTO arq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","وكي كان يَزرَع، طاحَت شْويّة من الزَريعة على الطْريق، وجاو الزْواوَش وكْلاوها. ");
INSERT INTO arq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","وطاحَت شْويّة فالحْجَر، وين ماكانش بَزّاف التْراب، وتَم تَم ناضَت خاطَر ما لْقاتش الأرض غامقة، ");
INSERT INTO arq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","وكي طَلعَت الشَمس، نْحَرقَت ويَبسَت خاطَر ما كانش عَندها العْروق. ");
INSERT INTO arq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","وطاحَت شْويّة من الزَرّيعة فالشوك، وطْلَع الشوك وخْنَقها وما عْطاتش الغَلّة. ");
INSERT INTO arq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","وطاحَت شْويّة فالأرض المْليحة، ومَدّت غَلّة وهِيَ تْنوض وتَكبَر. كايَن من الزَرّيعة اللي مَدَّت تْلاتين واللي مَدَّت سَتّين واللي مَدَّت مْية\". ");
INSERT INTO arq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","وقال: \"اللي عَندو وَدنين باش يَسمَع، غير يَسمَع.\" ");
INSERT INTO arq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","وكي كان وَحدو، سَقساوَه اللي كانو دايرين بيه والتابعين الطْناش على المْتال. ");
INSERT INTO arq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","قالَلهُم: \"أنتومَ، تْنَعطالكُم سَر مَلَكوت الله، بَصَّح اللي راهُم بَرّا يَوصَلَّلهُم كُل شي بالمْتال، ");
INSERT INTO arq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","باش قَد ما يَخُّزرو، ما يْشوفوش، وقَد ما يَسَّمعو، ما يَفَّهموش، يْعودو يْتوبو ويَتَّغفَرَّلهُم.\" ");
INSERT INTO arq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","وقالَلهُم: \"ما فْهَمتوش هاد المْتَل؟ وكيفاش تَفَّهمو كامَل المْتال؟ ");
INSERT INTO arq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","الفَلاّح يَزرَع الكَلمة، ");
INSERT INTO arq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","هَدو راهُم على الطْريق، وين نْزَرعَت الكَلمة، وكي يَسَّمعو، تَم تَم يْجي الشيطان ويْنَحّي الكَلمة اللي نْزرعَت فيهُم. ");
INSERT INTO arq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","وهَدو اللي نْزَرعو فالحْجَر، اللي كي يَسَّمعو الكَلمة، يَقَّبلوها تَم تَم بالفَرحة، ");
INSERT INTO arq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ما عَندهُمش عْروق فيهُم، وما يَتَّبتوش، وكي تْجي الشَدّة وَلاّ الحُڤرة على جال الكَلمة، بالخَف يَعَّترو. ");
INSERT INTO arq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","وواحدُخرين يَنزَرعو فالشوك، هَدو اللي يَسَّمعو الكَلمة، ");
INSERT INTO arq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","وهْموم الزْمان وغْواية التَرفيه والشَهوات الأُخرين، يَخَّنقو الكَلمة وما تْجيبش الغَلّة. ");
INSERT INTO arq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","وهَدوك اللي نْزَرعو فالأرض المْليحة، اللي يَسَّمعو الكَلمة ويَقَّبلوها ويْجيبو الغَلّة، واحَد تْلاتين وواحَد سَتّين وواحَد مْية. ");
INSERT INTO arq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","وقالَلهُم: \"تْجي الشَمعة تَنْحَط تَحت ماعون وَلاّ تَحت سْرير؟ ماشي تَنْحَط على الشَندال؟ ");
INSERT INTO arq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","خاطَر حاجة ما تَبقا مْخَبّية وما تْبانش، وحاجة ما تَصرا فالسَر وما تْنَعرَفش؟ ");
INSERT INTO arq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","وَلاّ واحَد عَندو وَدنين باش يَسمَع، غير يَسمَع.\" ");
INSERT INTO arq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","وقالَلهُم: \"رَدّو بالكُم على واش تَسَّمعو، يَتكَيَّلَّلكُم بالكيلة اللي تْكَيّلو بيها ويَنزادَلكُم، ");
INSERT INTO arq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","خاطَر اللي عَندو يَتَّعطالو، واللي ما عَندوش، يَتنَحّالو حَتّى اللي عَندو.\" ");
INSERT INTO arq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","وقال: \"هَكدا مَلَكوت الله، كي بْنادَم اللي يَرمي الزَرّيعة فالأرض، ");
INSERT INTO arq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","يَرقُد ويْنوض ليل ونْهار، والزَرّيعة تْنوض وتَكبَر بلا ما يَعرَف كيفاش، ");
INSERT INTO arq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","الأَرض وَحَّدها تْجيب الغَلّة، مع الأوَّل الحْشيش، أومبَعد السْبول، أومبَعد القَمح مْعمَّر فالسْبول. ");
INSERT INTO arq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","وغير يَوصَل القَمح، يَنجبَد المَنجَل خاطَر جا وَقت الحْصاد.\" ");
INSERT INTO arq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","وزاد قال: \"بواش نْشَبّهو مَلَكوت الله؟ وبآما مْتَل نْمَتّلوه؟ ");
INSERT INTO arq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","كيما حَبّة الخَردَل، اللي كي تَنزرَع، هِيَ الزَرّيعة الصْغيرة اللي فالأرض، ");
INSERT INTO arq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","وكي تْنَزرَع، تْنوض وتْوَلّي هِيَ الكْبيرة كامَل فالخُضرة، وتْدير غْصان كْبار حَتّى يَقَّدرو طْيور السْما يْعَشّشو في ضَلّها.\" ");
INSERT INTO arq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","كان يَسوع يَهدَرَّلهُم كْلام الله بمْتال بَزّاف كيما هَدو على حْساب ما كانو يَقَّدرو يَسَّمعو، ");
INSERT INTO arq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","وما كانش يَهدَرَّلهُم بلا مْتال، وكي يْكون وَحدو مع التابعين مْتاعو، كان يْفَسَّرلهُم كُل شي. ");
INSERT INTO arq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","وفي هَداك اليوم، كي جات العْشِيّة، قالَلهُم: \"هَيّا نَقَّطعو للشَط اللي مْقابَل.\" ");
INSERT INTO arq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","وبَعد ما سَرّحو الغاشي، أدّاوَه فالفْلوكة اللي كان فيها، وكانو فْلايَك واحدُخرين معاه، ");
INSERT INTO arq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","وناضَت عَجّاجة كْبيرة وكانو الموجات يَتَّرماو على الفْلوكة حَتّى بْدات تَتعَمَّر، ");
INSERT INTO arq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","وكان يَسوع راقَد على المْخَدّة فالأخَّر مْتاع الفْلوكة. نَوّضوه وقالولو: \"شيخ، ماراحلَكش فينا لوكان نْموتو؟\" ");
INSERT INTO arq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ناض، هَدَّد الريح وقال للبْحَر: \"أَسكُت، أَتهَدَّن\". حْبَس الريح وتْهَدّنَت الحالة. ");
INSERT INTO arq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","وقالَلهُم: \"وَعلاش راكُم خايفين؟ مازال ما عَندكُمش الإيمان؟\" ");
INSERT INTO arq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","وخافو بَزّاف وقالو لبَعضهُم بَعض: \"شْكون يْكون هَدا؟ خاطَر حَتّى الريح والبْحَر يْطيعوه؟\" ");
INSERT INTO arq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","وراحو للشَط الآخُر مْتاع البْحَر في بْلاد الجَدَرِيّين، ");
INSERT INTO arq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","وكي خْرَج يَسوع من الفْلوكة، لاقاه واحَد جا من الجَبّانة كان مَسكون بروح ناجَس، ");
INSERT INTO arq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","وكان يَسكُن فالمْدافَن وواحَد ما كان يَقدَر يَرَّبطو حَتّى بالسْناسَل. ");
INSERT INTO arq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","خاطَر رَبطوه شْحال من مَرّة بالحْدايَد والسْناسَل وكان يْدَڤدَڤ السْناسَل ويْكَسَّر الحْدايَد وواحَد ما كانَت عَندو القُوّة باش يْطَوّعو، ");
INSERT INTO arq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","وكان دايمًا ليل ونْهار فالمَدافَن وفالجْبال، يْعَيَّط ويَجرَح في روحو بالحْجَر. ");
INSERT INTO arq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","وكي شاف يَسوع من البْعيد، راح يَجري سْجَدلو، ");
INSERT INTO arq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","وعَيَّط بالزور وقال: \"واش بيني وبينَك يا يَسوع بْن الله العالي؟ نْحَلّفَك بالله ما تْعَدَّبني\"، ");
INSERT INTO arq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","خاطَر يَسوع قاللو: \"أَخرُج من الراجَل يا الروح الناجَس\"، ");
INSERT INTO arq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","وسَقساه: \"واسمَك\"، قاللو: \"واسَمني جيش، خاطَر حْنا بَزّاف\"، ");
INSERT INTO arq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","وبْدا غير يْحَلَّل فيه باش ما يَبعَتهُمش خارَج البْلاد. ");
INSERT INTO arq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","وكان تَمّة عَند الجْبَل، قْطيع كْبير مْتاع الحْلالَف يَرعاو، ");
INSERT INTO arq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","حَلّلوه وقالو: \"أَبعَتنا فالحْلالَف باش نَدُّخلو فيهُم\". ");
INSERT INTO arq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","سْمَحَّلهُم، وخَرجو الأرواح الناجسين ودَخلو فالحْلالَف، وأتَّرما القْطيع من طَرف الجْبَل للبْحَر. كانو واحَد الألفين وغَرقو. ");
INSERT INTO arq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","واللي كانو يَرعاو فيهُم هَربو وشَيّعو الخْبَر فالمْدينة وفالحْواش، وجاو الناس يْشوفو واش صْرا، ");
INSERT INTO arq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","وجاو عَند يَسوع وشافو هَداك اللي كان مَسكون بجيش قاعَد، لابَس، في عَقلو وخافو. ");
INSERT INTO arq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","حْكاوَلهُم اللي شافو واش صْرا للمَسكون وللحْلالَف، ");
INSERT INTO arq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","وبْداو يْحَلّلو في يَسوع باش يْبَعَّد من بْلادهُم. ");
INSERT INTO arq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","طْلَع يَسوع فالفْلوكة، وحَلّلو اللي كان مَسكون باش يَبقا معاه، ");
INSERT INTO arq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","بَصَّح يَسوع ما خَلاّهش وقاللو: \"روح لدارَك ولمْواليك وخَبَّرهُم كامَل واش دارلَك الرَب وشْحال رَحمَك.\" ");
INSERT INTO arq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","راح الراجَل وبْدا يْبَرَّح فالعَشر مْدايَن بكامَل واش دارلو يَسوع وكامَل سْتَعجبو. ");
INSERT INTO arq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","وكي زاد قْطَع يَسوع فالفْلوكة للشَط الآخُر، تْلَم عليه غاشي كْبير وكان على شَط البْحَر، ");
INSERT INTO arq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","وجا واحَد من رِيّاس المَجمَع واسمو يايرُس، وكي شافو، رْما روحو عَند رَجليه، ");
INSERT INTO arq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","وحَلّلو وقاللو: \"بَنتي الصْغيرة راهي تْموت، لو كان تْجي وتْدير يَدّيك عليها باش تَسلَك وتْعيش.\" ");
INSERT INTO arq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","راح يَسوع معاه، وتَبّعو غاشي كْبير وبْداو يْزاحمو فيه من كُل جيهة. ");
INSERT INTO arq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","واحَد المْرا كان يْسيل منها الدَم من طْناشَن سْنة، ");
INSERT INTO arq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","شْحال تْعَدّبَت على يَد بَزّاف من لاطُبّة وصَرفَت كامَل واش عَندها بلا حَتّى فايدة وكانَت حالَتها تْزيد. ");
INSERT INTO arq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","كي سَمعَت بيَسوع جات في وَسط الغاشي ومَسَّت لْباسو من اللور، ");
INSERT INTO arq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","وقالَت: \"لو كان بَرك نْمَس حْوايجو نَبرا\". ");
INSERT INTO arq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","تَم تَم نْشَف الدَم اللي كان يْسيل منها، وعَرفَت في داتها باللي بْرات من مَرضها. ");
INSERT INTO arq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","بالخَف دار يَسوع للغاشي خاطَر حَس في نَفسو باللي قُوّة خَرجَت مَنّو وقال: \"شْكون مَس حْوايجي؟\" ");
INSERT INTO arq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","قالولو التابعين مْتاعو: \"راك تْشوف الغاشي اللي راهو يْزاحَم فيك وتْقول شْكون مَسّني؟\" ");
INSERT INTO arq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","وبْدا يُخزُر سايَر دايَر عليه باش يْشوف شْكون اللي دار هاد الشي. ");
INSERT INTO arq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","جات المْرا خايفة تَتَّرعَد، وعارفة واش صْرالها. رْمات روحها قُدّامو وقالَتلو الصَح كامَل. ");
INSERT INTO arq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","قالَلها هُوَ: \"بَنتي، إيمانَك سَلكَك، روحي هانية وكوني بارية من مَرضَك\". ");
INSERT INTO arq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","كان ما زال يَهْدَر كي جاو ناس من عَند رايَس المَجمَع يْقولو: \"بَنتَك ماتَت، وَعلاش تْزيد تْشَقّي الشيخ؟\" ");
INSERT INTO arq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","يَسوع كي سْمَع الكْلام اللي تْقال، قال لرايَس المَجمَع: \"ما تْخافش، آمَن بَرك\"، ");
INSERT INTO arq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","وما خَلاّ حَتّى واحَد يْجي معاه من غير بُطرُس ويَعقوب ويوحَنّا خو يَعقوب. ");
INSERT INTO arq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","راحو لدار رايَس المَجمَع وشاف يَسوع الهيلولة والناس يَبكيو ويْعَيّطو. ");
INSERT INTO arq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","دْخَل وقالَلهُم: \"وَعلاش تْديرو الهيلولة وتَبْكيو؟ الطَفلة ما ماتَتش، راهي راقدة.\" ");
INSERT INTO arq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","تْمسخرو بيه، بَصَّح هُوَ خَرَّجهُم كامَل وأدّا معاه باباة الطَفلة ويَمّاها واللي كانو معاه ودْخَل وين كانَت الطَفلة. ");
INSERT INTO arq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","شَدَّلها يَدّها وقالَلها: \"طاليتا، قوم\"، ومَعنَتها: \"يا طَفلة، نوضي\". ");
INSERT INTO arq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","تَم تَم ناضَت الطَفلة ومْشات. كان في عْمَرها طْناشن سْنة. وهاد الشي دَهَّشهُم بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","وَصّاهُم يَسوع ووَكَّد عليهُم باش واحَد ما يَعرَف بهاد الشي، وطْلَب منهُم يَعطيو للطَفلة تاكُل.\" ");
INSERT INTO arq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","وخْرَج من تَمّة وجا لبْلادو، وتَبّعوه التابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","في يوم السَبت، بْدا يْدَرَّس فالمَجمَع وبَزّاف اللي كانو يَسَّمعو فيه سْتَعجبو وقالو: \"مْنين جاه هاد الشي، وواشَن هاد العْقَل اللي أتَّعطاتلو وهاد المُعجِزات اللي راهُم يَندارو على يَدّو؟ ");
INSERT INTO arq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","هَدا ماشي النَجّار وْليد مَريَم وخو يَعقوب ويوسي ويَهودا وسَمعان؟ وخْواتاتو ماشي عايشين في وَسطنا؟\" وعَترو فيه. ");
INSERT INTO arq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","وقالَلهُم يَسوع: \"النَبي ما يْنَحڤَر غير في بْلادو وفي وَسط عايَلتو ودارو\"، ");
INSERT INTO arq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","وما قْدَر يْدير تَمّة حَتّى مُعجِزة من غير شي مَرضى دار يَدّيه عليهُم وشْفاهُم، ");
INSERT INTO arq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","وسْتَعجَّب على جال اللي ما آمنوش، وكان يْطوف على الدْشور اللي دايرين بتَمّة ويْدَرَّس. ");
INSERT INTO arq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","عَيَّط للرُسُل الطْناش وبْدا يَبعَت فيهُم زوج زوج وعْطالهُم الحُكمة على الأرواح الناجسين، ");
INSERT INTO arq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ووَصّاهُم باش ما يَدّيو والو للطْريق من غير عْصا بَرك. لا خُبز، لا رَزمة، لا دْراهَم فالجيب، ");
INSERT INTO arq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ويَلَّبسو سْبابَط وما يَلَّبسوش زوج كَسوات، ");
INSERT INTO arq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","وقالَلهُم: \"الدار اللي تَدُّخلولها، أَقُّعدو تَمّة حَتّى تْروحو مَنها، ");
INSERT INTO arq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","والمْكان اللي ما يَقَّبلوكُمش فيه وما يَسَّمعولكُمش، روحو من تَمّة وأنَّفضو التْراب من رَجليكُم شْهادة عليهُم\". ");
INSERT INTO arq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","وراحو يَبَرّحو باش الناس يْتوبو، ");
INSERT INTO arq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","وخَرّجو شْياطَن بَزّاف ودَهنو بالزيت بَزّاف من المَرضى وشْفاوهُم. ");
INSERT INTO arq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","سْمَع السَلطان هيرودَس خاطَر نَشهَر آسَم يَسوع وقال: \"يوحَنّا المَعمَدان قام من بين الموتى، على هَدا المُعجِزات راهُم يَندارو على يَدّو\". ");
INSERT INTO arq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","وواحَدُخرين قالو: \"هَدا إيليّا\"، وقالو واحَدُخرين: \"نَبي كيما واحَد من الأَنبيا.\" ");
INSERT INTO arq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","كي سْمَع هيرودَس قال: \"هَدا هُوَ يوحَنّا اللي أنا قَطَّعتلو راسو، هُوَ اللي قام\". ");
INSERT INTO arq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","خاطَر هيرودَس هُوَ بالدات بْعَت وحْكَم يوحَنّا وسَنسلو فالحَبس على جال هيرودِيّا مَرت خوه فيلِبّس خاطَر كان تْزَوَّج بيها، ");
INSERT INTO arq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","خاطَر يوحَنّا قال لهيرودَس: \"ما يْجوزلَكش تَتزَوَّج بمَرت خوك\". ");
INSERT INTO arq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","حَقدَت عليه هيرودِيّا وحَبَّت تَقُّتلو وما قْدَرتش، ");
INSERT INTO arq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","خاطَر هيرودَس كان يْخاف من يوحَنّا وعارفو راجَل صالَح وقُدّوس، وكان يْحامي عليه، وكان كي يَسمَعلو يَبقا حايَر بَصَّح يْحَب يَسمَعلو. ");
INSERT INTO arq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","لْحَق وَقت مْوالَم كي دار هيرودَس وَليمة في عيد ميلادو للكْبار، ورِيّاس الجيش واللي عَندهُم الشان فالجْليل. ");
INSERT INTO arq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ودَخلَت بَنت هيرودِيّا هَدي وشَطحَت وعَجبَت هيرودَس وضْيافو. قال السَلطان للطَفلة: \"أَطَّلبي مَنّي واش تْحَبّي ونَعطيهولَك\"، ");
INSERT INTO arq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","وحْلَفلها باللي \"اللي تَطَّلبيه مَنّي نَعطيهولَك حَتّى للنَص مْتاع مَملَكتَي\". ");
INSERT INTO arq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","خَرجَت وقالَت ليَمّاها: \"واش نَطلَب؟\" قالَتلها: \"راس يوحَنّا المَعمَدان.\" ");
INSERT INTO arq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","تَم تَم دَخلَت للسَلطان، طَلبَت وقالَت: \"نْحَب دُرك تَعطيني في طَبسي راس يوحَنّا المَعمَدان.\" ");
INSERT INTO arq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","حْزَن السَلطان بَزّاف، وعلى جال اليْمين مْتاعو وضْيافو ما حَبش يْرَدّها، ");
INSERT INTO arq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","وتَم تَم بْعَت عَسَّكري آمرو يْجيب راس يوحَنّا المَعمَدان. راح العَسَّكري، قَطَّع راس يوحَنّا فالحَبس، ");
INSERT INTO arq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","وجابو في طَبسي وعْطاه للطَفلة والطَفلة عْطاتو ليَمّاها. ");
INSERT INTO arq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","وكي سَمعو التابعين مْتاعو، راحو أَدّاو داتو وحَطّوها في قْبَر. ");
INSERT INTO arq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","تْلَمّو الرُسُل عَند يَسوع وخَبّروه بكامَل واش دارو وواش دَرّسو. ");
INSERT INTO arq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","قالَلهُم: \"أَرواحو أنتومَ، أجَّبدو روحكُم في مْكان خالي، ورَيّحو شْوِيّة\". خاطَر بَزّاف اللي كانو رايحين جايّين وما كانش عَندهُم الوَقت حَتّى باش ياكلو. ");
INSERT INTO arq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","بَعّدو في فْلوكة لمْكان خالي، ");
INSERT INTO arq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","وشافوهُم رايحين وبَزّاف اللي عَقلوهُم، وراحو بالخَف كيف كيف لتَمّة من كامَل المْدايَن على رَجليهُم وسَبقوهُم. ");
INSERT INTO arq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","وكي خْرَج يَسوع من الفْلوكة، شاف غاشي كْبير وحَن عليهُم خاطَر كانو كي الخَرفان بْلا راعي، وبْدا يْدَرَّسَّلهُم حاجات بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","جاز وَقت كْبير وجاو ليه التابعين مْتاعو يْقولو باللي \"المْكان خالي وراح الحال، ");
INSERT INTO arq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","سَرَّح هاد الناس يْروحو للحْواش والدْشور اللي فالجْوايَه ويَشرويو لروحهُم واش ياكلو\". ");
INSERT INTO arq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","جاوبهُم يَسوع: \"أَعطيوهُم أنتومَ ياكلو\"، قالولو: \"نْروحو نَشريوَلهُم خُبز بميتين دينار ونَعطيوهُم ياكلو؟\" ");
INSERT INTO arq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","قالَلهُم: \"شْحال عَندكُم من خُبزة؟ روحو شوفو\"، تَبّتو وقالو: \"خَمسة وزوج حوتات.\" ");
INSERT INTO arq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","آمَرهُم باش يْقَعّدو الغاشي كامَل جْماعات جْماعات على الحْشيش الأخضَر، ");
INSERT INTO arq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","وقَعدو في صْفوف مْتاع مْية ومْتاع خَمسين. ");
INSERT INTO arq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","خْدا يَسوع الخَمس خُبزات والزوج حوتات، رْفَد عينيه للسْما وبارَك وقْسَم الخُبز وعْطاه للتابعين باش يْفَرّقوه للغاشي وزاد قْسَمَّلهُم كامَل الزوج حوتات، ");
INSERT INTO arq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","وكامَل كْلاو وشَبعو، ");
INSERT INTO arq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ورَفدو التابعين طْناشَن قُفّة مْعَمّرين بطْراف الخُبز والحوت اللي بْقا، ");
INSERT INTO arq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","وكانو اللي كْلاو الخُبز خَمس آلاف راجَل. ");
INSERT INTO arq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","وتَم تَم سَيَّف يَسوع على التابعين مْتاعو باش يَطَّلعو فالفْلوكة ويَسَّبقوه للشَط الآخُر كيما بيت صيدا مابيد هُوَ يْسَرَّح الغاشي، ");
INSERT INTO arq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","وبَعدما سَرَّحهُم، راح للجْبَل يْصَلّي. ");
INSERT INTO arq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","كي طاح الليل، كانَت الفْلوكة في وَسط البْحَر وهُوَ وَحدو على الشَط، ");
INSERT INTO arq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","وشاف التابعين مْتاعو يَتعَدّبو فالقْديف خاطَر الريح كان مْعاكَسهُم، وقْبَل ما يَطلَع الفْجَر، راح لعَندهُم وهُوَ يَمشي على البْحَر وحَب يَسبَقهُم. ");
INSERT INTO arq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","هومَ كي شافوه يَمشي على البْحَر حَسبوه روحاني وبْداو يْعَيّطو بالزور، ");
INSERT INTO arq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","خاطَر كامَل شافوه ونْخَلعو. تَم تَم هْدَر مْعاهُم هُوَ وقالَلهُم: \"كونو هانيين، أنا هُوَ ما تْخافوش\"، ");
INSERT INTO arq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","وطْلَع لعَندهُم فالفْلوكة وهْدَن الريح. وهومَ سْتَعجبو في قْلوبهُم بَزّاف، ");
INSERT INTO arq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","خاطَر ما فَهموش آمَر الخُبز خاطَر قَلبهُم كان مَغلوق. ");
INSERT INTO arq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","وبَعدما قَطعو البْحَر، وَصلو لبْلاد جَنّيسارَت وحَبّسو الفْلوكة فالشَط مْتاعها. ");
INSERT INTO arq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","وكي خَرجو من الفْلوكة، تَم تَم الناس عَقلو يَسوع، ");
INSERT INTO arq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","طَوّفو كامَل هَدوك الجْوايَه وبْداو يْجيبو المَرضى فالفْراش لكامَل وين يَسَّمعو بيه باللي راهو تَمّاك، ");
INSERT INTO arq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ووين يَدخُل، فالدْشور وَلاّ فالمْدايَن وَلاّ فالحْواش، كانو يْحَطّو المَرضى فالأسواق ويْحَلّلوه باش يْمَسّو يا لوكان جْلال لْباسو، وكانو اللي يْمَسّوه يَبراو. ");
INSERT INTO arq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","تْلايمو عليه الفَرّيسِيّين وشي كُتّاب جاو من أورشَليم، ");
INSERT INTO arq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","وشافو شي تابعين مْتاعو ياكلو الخُبز بيَدّين ناجسين يَعني ماشي مَغسولين، ");
INSERT INTO arq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","خاطَر الفَرّيسِيّين وكامَل اليْهود لو كان ما يَغَّسلوش يَدّيهُم مْليح ما ياكلوش، حاكمين في عادة الجْدود. ");
INSERT INTO arq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","وكي يْجيو من الأسواق، لو كان ما يَغَّسلوش ما ياكلوش، وحَكمو من العْوايَد في حاجات واحَدُخرين بَزّاف: غْسيل الكيسان والطيصان والسْنيوات مْتاع النْحاس والبْناك. ");
INSERT INTO arq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","وسَقساوَه الفَرّيسِيّين والكُتّاب: \"وَعلاش التابعين مْتاعك ما يَمشيوش على حْساب عادة الجْدود وياكلو الخُبز بيَدّين ناجسين؟\" ");
INSERT INTO arq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","قالَلهُم: \"إِشعِيا تْنَبّأ عليكُم مْليح يا المُنافقين كيما راهو مَكتوب: \"هاد الشَعب يَكرَّمني بفَمّو بَصَّح قَلبهُم بْعيد عْلِيَّ، ");
INSERT INTO arq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","يَعَّبدوني في باطَل وهومَ يْدَرّسو فْرايَض مْتاع بْني آدَم\"، ");
INSERT INTO arq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","خَلّيتو فَرض الله وحْكَمتو في عْوايَد بْني آدَم\". ");
INSERT INTO arq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","وقالَلهُم: \"تَعَّرفو مْليح تْخَلّيو فَرض الله باش تْشَدّو في عادَتكُم، ");
INSERT INTO arq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","خاطَر موسى قال: \"كَرَّم باباك ويَمّاك\"، و: \"اللي يْسَب الباباة وَلاّ اليَمّاة لازَم يْموت\"، ");
INSERT INTO arq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","أنتومَ تْقولو: \"وَلاّ بْنادَم قال للباباة وَلاّ لليَمّاة: \"اللي كُنت قادَر نْعاونَك بيه نْمدّو هِبة للرَب\"، ");
INSERT INTO arq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ما تْزيدوش تَخَلّيوَه يْدير حاجة للباباة وَلاّ لليَمّاة. ");
INSERT INTO arq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","وتْبَطّلو كْلام الله بعادَتكُم اللي تْعَلّموها وتْديرو حاجات بَزّاف كيما هَدو\". ");
INSERT INTO arq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","وعاوَد عَيَّط للغاشي وقالَلهُم: \"أَسَّمعوني كامَل وأفَّهمو، ");
INSERT INTO arq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","حاجة ما تَدخُل من بَرّا لبْنادَم تَقدَر تْنَجّسو، بَصَّح اللي يَخرَج من بْنادَم هُوَ اللي يْنَجّسو.\" ");
INSERT INTO arq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","وكي خَلاّ الغاشي ودْخَل للدار، سَقساوَه التابعين مْتاعو على المْتَل. ");
INSERT INTO arq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","وقالَلهُم: \"أَنتومَ تاني راكُم بلا فْهامة؟ ما تَفَّهموش باللي كامَل اللي يَدخُل من بَرّا لبْنادَم ما يَقدَرش يْنَجّسو، ");
INSERT INTO arq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","خاطَر ما يَدخُلش لقَلبو، يَدخُل لكَرشو ويَخرَج لبَرّا\"، وهَكدا حَلَّل يَسوع كامَل المْواكَل. ");
INSERT INTO arq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","قال: \"اللي يَخرُج من بْنادَم هَدا اللي يْنَجَّس بْنادَم، ");
INSERT INTO arq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","خاطَر من داخَل قَلب الناس اللي يَخُّرجو الفْكايَر الدونِيّين: الفَسق، السَرقة، القْتَل، ");
INSERT INTO arq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","الزِنا، الطْمَع، القْباحة، الخْدَع، العار، العين، السَبّان، التَكَبُّر، الجْهولِيّة، ");
INSERT INTO arq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","كامَل هاد الحاجات الدونِيّين يَخَّرجو من الداخَل ويْنَجّسو بْنادَم\". ");
INSERT INTO arq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","من تَم ناض وراح لجْوايَه صور، ودْخَل لدار وما حَبّ حَتّى واحَد يَعَّرفو بَصَّح ما قْدَرش يْجوز بلا ما يَعَّرفوه. ");
INSERT INTO arq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","بَصَّح واحَد المْرا بَنتها مَسكونة بروح ناجَس، غير سَمعَت الهَدرة عليه، وَصلَت لعَندو وطاحَت عَند رَجليه. ");
INSERT INTO arq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","كانَت المْرا يونانِيّة، آصَلها فينيقي سوري، وطَلبَت مَنُّو باش يْخَرَّج الشيطان من بَنتها. ");
INSERT INTO arq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","قالَلها: \"خَلّي قْبَل الدْراري يَشَّبعو، خاطَر ماشي مْليح يَتّاخُد خُبز الدْراري ويَتمَد للكْلاب الصْغار\"، ");
INSERT INTO arq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","واجباتو هِيَ: \"سيدي، حَتّى الكْلاب الصْغار ياكلو تَحت الميدة من فْتات الدْراري\"، ");
INSERT INTO arq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","قالَلها: \"على جال هاد الكَلمة روحي، الشيطان راه خْرَج من بَنتَك\"، ");
INSERT INTO arq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","وكي راحَت لدارها، لْقات بَنتها فالفْراش والشيطان خْرَج منها. ");
INSERT INTO arq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","وزاد خْرَج من جْوايَه صور وراح من صَيدا لبْحَر الجْليل في وَسط بْلاد العَشر مْدايَن، ");
INSERT INTO arq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","وجابولو طْرش يَهدَر بالسيف، وحَلّلوه باش يْدير يَدّو عليه. ");
INSERT INTO arq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","أَدّاه يَسوع وَحدو على جيه بْعيد على الغاشي ودار صْباعتيه في وَدنين الراجَل وبْزَق ومَسّلو لْسانو، ");
INSERT INTO arq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ورْفَد عينيه للسْما وتْنَهَّد وقال: \"إِفَّتا\" يَعني \"أَنحَل\". ");
INSERT INTO arq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","تَم تَم نْحَلّو وَدنيه ونْحَل رْباط لْسانو وبْدا يَهدَر مْسَڤَّم. ");
INSERT INTO arq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","وَصّاهُم يَسوع باش ما يَهَّدرو لحَتّى واحَد، بَصَّح قَد ما كان يْوَصّيهُم، قَد ما كانو يْزيدو يْبَرّحو، ");
INSERT INTO arq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","وكانو مَدهوشين بَزّاف بَزّاف ويْقولو: \"كامَل واش يْدير مْليح، يَرَد الطْروشة يَسَّمعو والعْڤاڤَن يَهَّدرو\". ");
INSERT INTO arq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","في هَدوك اليامات، زاد كان غاشي كْبير بَزّاف وما كانش عَندهُم واش ياكلو. عَيَّط يَسوع للتابعين وقالَلهُم: ");
INSERT INTO arq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"غاضني هاد الغاشي اللي عَندهُم تَلت أَيّام وهومَ باقيين معايَ وما عَندهُمش واش ياكلو، ");
INSERT INTO arq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ولوكان نَبعَتهُم على الفْراغ لدارهُم، يَفَّشلو فالطْريق وكايَن منهُم اللي جاو من البْعيد\". ");
INSERT INTO arq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","جاوبوه التابعين مْتاعو: \"كيفاش يَقدَر واحَد في مَدرَب خالي كيما هَدا يْشَبَّع هاد الناس بالخُبز؟\" ");
INSERT INTO arq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","سَقساهُم: \"شْحال عَندكُم من خُبزة؟\" قالولو: \"سَبعة\". ");
INSERT INTO arq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","قال للغاشي يَقُّعدو على الأرض وخْدا السْبَع خُبزات، حْمَد، قْسَم الخُبز وعْطا للتابعين مْتاعو باش يْفَرّقوه ومَدّوه للغاشي، ");
INSERT INTO arq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","وكان عَندهُم شْوِيّة حوت صْغير، زاد يَسوع بارَكهُم وقال للتابعين يْزيدو يْمَدّوهُم. ");
INSERT INTO arq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","كْلاو وشَبعو، ورَفدو سْبَع قْفَف من الطْراف اللي بْقاو. ");
INSERT INTO arq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","كانو واحَد الرَبع آلاف نَفس وسَرَّحهُم يَسوع، ");
INSERT INTO arq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","وتَم تَم طْلَع في فْلوكة مع التابعين مْتاعو وراح لجْوايَه دَلمانوتة. ");
INSERT INTO arq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","خَرجو الفَرّيسِيّين وبْداو يَهَّدرو معاه ويْحَوّسو على مارة من السْما باش يْجَرّبوه. ");
INSERT INTO arq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","تْنَهَّد فالروح مْتاعو وقال: \"وَعلاش هاد الجيل يْحَوّس على مارة؟ نْقولَلكُم الصَح، ما يَتَّعطاش لهاد الجيل مارة\". ");
INSERT INTO arq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","وخَلاّهُم وزاد طْلَع في فْلوكة وبَعَّد للشَط الآخُر. ");
INSERT INTO arq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","نْساو التابعين يَدّيو الخُبز وما كان عَندهُم فالفْلوكة غير خُبزة واحدة. ");
INSERT INTO arq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","وَصّاهُم يَسوع وقال: \"شوفو، رَدّو بالكُم من خْميرة الفَرّيسِيّين وخْميرة هيرودَس.\" ");
INSERT INTO arq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","خَمّمو بيناتهُم باللي قالَلهُم هَكدا كي ما كانش عَندهُم الخُبز. ");
INSERT INTO arq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","عْرَف يَسوع تَخمامهُم وقالَلهُم: \"وَعلاش راكُم تْخَمّمو باللي ما عَندكُمش الخُبز؟ مازال ما فْهمتوش وما فَقتوش؟ قَلبكُم قاسي؟ ");
INSERT INTO arq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","عَندكُم عينين وما تْشوفوش ووَدنين وما تَسَّمعوش؟ وما تَشفاوش، ");
INSERT INTO arq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","كي قْسَمت الخَمس خُبزات للخَمس آلاف نَفس، شْحال من قُفّة مْعَمّرة بالطْراف رْفَدتو؟ قالولو: \"طْناش\"، ");
INSERT INTO arq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","وكي قْسَمت السْبَع خُبزات للرَبع آلاف نَفس، شْحال من قُفّة أَدّيتو من الطْراف اللي بْقاو؟ قالولو: \"سَبعة\"، ");
INSERT INTO arq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","قالَلهُم: \"ما زال ما فْهَمتوش؟\" ");
INSERT INTO arq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","وراحو لبيت صيدا، وجابولو عْمى حَلّلوه باش يْمَسّو. ");
INSERT INTO arq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","شَد يَد العْمى وأدّاه خارَج الدَشرة، بْزَق في عينيه، ودار يَدّيه عليه وسَقساه: \"كاش ما راك تْشوف؟\" ");
INSERT INTO arq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","رْفَد الراجل عينيه وقال: \"راني نْشوف ناس يَمشيو، شايَفهُم كي السْجر\"، ");
INSERT INTO arq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","أومبَعد زاد دار يَسوع يَدّيه على عينين الراجَل وكي حَقَّق وَلاّ يْشوف مْليح وبْرا، ");
INSERT INTO arq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","وبَعتو يَسوع لدارو وقال: \"ما تَدخُلش للدَشرة\". ");
INSERT INTO arq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","خْرَج يَسوع والتابعين مْتاعو للدْشور مْتاع قَيصَرِيّة فيليبس، وفالطْريق سَقسا التابعين مْتاعو وقالَلهُم: \"على حْساب الناس شْكون أَنا؟\" ");
INSERT INTO arq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","قالولو: \"يوحَنّا المَعمَدان، واحَدُخرين إيلِيّا، وواحَدُخرين واحَد من الأَنبيا\". ");
INSERT INTO arq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","سَقساهُم: \"بَصَّح أنتومَ، شْكون تْقولو أَنا؟\" جاوَب بُطرس وقاللو: \"أنتَ المَسيح\"، ");
INSERT INTO arq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ووَصّاهُم باش ما يْقولو لحَتّى واحَد عليه. ");
INSERT INTO arq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","وبْدا يْدَرَّس فيهُم: \"لازَم على بْن الإِنسان يَتعَدَّب بَزّاف، والشْيوخ ورِيّاس رْجال الدين والكُتّاب ما يَقَّبلوهش ويْنَقتَل وبَعد تَلت أَيّام يْقوم\"، ");
INSERT INTO arq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","وقال هاد الكْلام عيناني. جَبدو بُطرُس على جيه وبْدا يْلوم فيه. ");
INSERT INTO arq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","دار يَسوع، شاف فالتابعين مْتاعو وزْڤا على بُطرُس وقال: \"بَعَّد عْلِيَّ يا شيطان، خاطَر ما عَندَكش تَخمام الله، عَندَك تَخمام بْني آدَم\". ");
INSERT INTO arq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","وعَيَّط للغاشي مع التابعين مْتاعو وقالَلهُم: \"وَلاّ حَب واحَد يْتَبَّعني، لازَم يَنكُر روحو ويَرفَد صْليبو ويْتَبَّعني، ");
INSERT INTO arq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","خاطَر اللي حَب يْسَلَّك حْياتو يَخسَرها، بَصَّح اللي يَخسَر حْياتو على جالي وعلى جال الإِنجيل يْسَلَّكها. ");
INSERT INTO arq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","خاطَر واش يَستَنفَع بْنادَم لوكان يَربَح الدَنيا كاملة ويَخسَر حْياتو؟ ");
INSERT INTO arq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","وواش يَقدَر يْمَد بْنادَم باش يَربَح حْياتو؟ ");
INSERT INTO arq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","خاطَر اللي يَحشَم بِيَّ وبكْلامي في هاد الجيل الزاني والخاطي، بْن الإِنسان تاني يَحشَم بيه كي يْجي في مَجد باباه مع المَلايكة القَدّيسين\". ");
INSERT INTO arq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","وقالَلهُم: \"نْقولَلكُم الصَح، من اللي راهُم واقفين هنا، كايَن اللي ما يْدوقوش الموت حَتّى يْشوفو مَلَكوت الله جا بالقُدرة\". ");
INSERT INTO arq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","وبَعد سَت أيّام، أَدّا يَسوع بُطرُس ويَعقوب ويوحَنّا وطَلَّعهُم لجْبَل عالي، على جيه، وَحَّدهُم، وتْبَدَّل قُدّامهُم. ");
INSERT INTO arq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","وَلاّو حْوايجو يَبَّرقو، بْيوضا بَزّاف، حَتّى سَبّاغ فالأرض ما يَقدَر يْبَيَّضهُم هَكدا. ");
INSERT INTO arq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","وضْهَرَّلهُم إِيلِيّا وموسى يَهَّدرو مع يَسوع. ");
INSERT INTO arq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","نْطَق بُطرُس وقال ليَسوع: \"سيدي، مْليح لينا نْكونو هنا، هَيّا نْديرو تَلت خْيَم، واحدة ليك، واحدة لموسى وواحدة لإيلِيّا\"، ");
INSERT INTO arq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ما كانش عارَف واش كان يَهدَر، خاطَر كان حاكَمهُم الخوف. ");
INSERT INTO arq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","وجات سْحابة غَطّاتهُم بضَلّها، وجا منها صوت يْقول: \"هَدا وْليدي الحْبيب، أَسَّمعولو\". ");
INSERT INTO arq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","وتَم تَم، خَزرو التابعين مَنّا ومَنّا وما شافو حَتّى واحَد من غير يَسوع وَحدو معاهُم. ");
INSERT INTO arq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","وكي كانو هابطين من الجْبَل، وَصّاهُم يَسوع ما يَحكيو لحَتّى واحَد واش شافو حَتّى يْقوم بْن الإِنسان من الموت. ");
INSERT INTO arq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","وخَلاّو هاد الكْلام في قَلبهُم وهومَ يْسَقسيو بَعضهُم بَعض واش حَب يْقول القِيامة من بين الموتى؟ ");
INSERT INTO arq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","وسَقساوَه وقالو: \"وَعلاش يْقولو الكُتّاب باللي إيلِيّا يْجي الأَوَّل؟\" ");
INSERT INTO arq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","قالَلهُم: \"صَح إيليّا يْجي قْبَل ويْسَڤَّم كُل شي: وكيفاش مَكتوب تاني على بْن الإِنسان باللي يَتعَدَّب بَزّاف ويْنَحڤَر؟ ");
INSERT INTO arq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","بَصَّح نْقولَلكُم، إيلِيّا صَح جا ودارو فيه كامَل واش حَبّو، على حْساب ما مَكتوب عليه\". ");
INSERT INTO arq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","وكي كان يَسوع رايَح عَند التابعين، شاف غاشي كْبير دايَر عليهُم وكُتّاب يَهَّدرو معاهُم. ");
INSERT INTO arq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","تَم تَم، كامَل الغاشي كي شافوه، سْتَغربو وراحو يَجريو لعَندو وسَلّمو عليه. ");
INSERT INTO arq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","سَقساهُم: \"على واش راكُم تَهَّدرو معاهُم؟\" ");
INSERT INTO arq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","جاوبو واحَد من الغاشي: \"شيخ، جَبتلَك وْليدي المَسكون بروح عَڤّون، ");
INSERT INTO arq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ووين يَحَّكمو، يَرميه فالأرض، يْرَيَّڤ ويْتَرتَق سْنانو ويَيبَس. قُلت للتابعين مْتاعك باش يْخَرّجوه بَصَّح ما قَدروش\"، ");
INSERT INTO arq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","قالَلهُم: \"جيل بْلا إيمان، لوَقتاش نَبقا معاكُم؟ لوَقتاش نَرفَدكُم؟ جيبوهولي\"، ");
INSERT INTO arq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","جابوهولو. وغير شافو الروح، بْدا يْهَوَّل فالوْلَد وطاح الوْلَد على الأرض وبْدا يَتمَرَّغ ويْرَيَّڤ. ");
INSERT INTO arq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","سَقسا يَسوع باباة الوْلَد: \"شْحال عَندو من اللي راه يَصرالو هَكدا؟\" قاللو: \"من صُغرو، ");
INSERT INTO arq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","وشْحال من مَرّة رْماه الشيطان فالنار وفالما باش يَقُّتلو، بَصَّح وَلاّ كاش ما تَقدَر، عاوَننا وحَن علينا\". ");
INSERT INTO arq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","قاللو يَسوع: \"وَلاّ تَقدَرٍ! كُل شي مَقدور للي يامَن\". ");
INSERT INTO arq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","تَم تَم عَيَّط باباة الوْلَد وقال: \"نامَن، عاوَنّي في قَلّة إيماني\". ");
INSERT INTO arq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","كي شاف يَسوع الغاشي جاي يَجري، آمَر الروح الناجَس وقاللو: \"يا الروح العَڤّون والطْرش، نامرَك، أخرُج مَنّو وما تْزيدش تَدخُل فيه\". ");
INSERT INTO arq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","عَيَّط الروح وهَز الوْلَد هَزّة قْوِيّة وخْرَج، ورْجَع كي المِيَّت حَتّى بَزّاف من الناس حَسبوه مات. ");
INSERT INTO arq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","بَصَّح شَدّو يَسوع من يَدّو ونَوّضو ووْقَف. ");
INSERT INTO arq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","وكي دْخَل يَسوع للدار، سَقساوَه التابعين مْتاعو على جيه: \"وَعلاش حْنا ما قْدَرناش نْخَرّجوه؟\" ");
INSERT INTO arq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","قالَلهُم: \"هاد الجَنس ما يَخرُج غير بالصْلاة\". ");
INSERT INTO arq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","وخَرجو من تَمّة وجازو على الجْليل ويَسوع ما كان حاب حَتّى واحَد يَعرَف، ");
INSERT INTO arq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","خاطَر كان يْدَرَّس التابعين مْتاعو ويْقولَلهُم: \"بْن الإِنسان رايَح يَتسَلَّم ليَدّين الناس، ويَقُّتلوه، وبَعدما يْنَقتَل، يْقوم فاليوم التالَت\". ");
INSERT INTO arq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","بَصَّح هومَ ما فَهموش هاد الكْلام وخافو يْسَقسيوَه. ");
INSERT INTO arq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","وراحو لكَفرناحوم، وكي كان فالدار، سَقساهُم يَسوع: \"على ماش كُنتو تَهَّدرو فالطْريق؟\" ");
INSERT INTO arq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","هومَ سَكتو، خاطَر كانو يَهَّدرو مع بَعضهُم فالطْريق: شْكون هُوَ الكْبير؟ ");
INSERT INTO arq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","قْعَد يَسوع وعَيَّط للتابعين الطْناش وقالَلهُم: \"وَلاّ حَب واحَد يْكون هُوَ الأوَّل، لازَم يْكون الأَخراني فالكُل ويَخدَم الكُل\"، ");
INSERT INTO arq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","وخْدا وْلَد صْغير، حَطّو في وَسطهُم، وشَدّو بين دْراعتيه وقالَلهُم: ");
INSERT INTO arq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"اللي يَقبَل واحَد من الدْراري كيما هَدا بآسمي يَقبَلني أَنا، واللي يَقبَلني، ما يَقبلنيش أَنا، يَقبَل اللي بْعَتني\". ");
INSERT INTO arq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","قاللو يوحَنّا: \"شيخ، شَفنا واحَد يْخَرَّج الشْياطَن بآسمَك، ومْنَعناه خاطَر ما راهوش يْتَبَّعنا\". ");
INSERT INTO arq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","قال يَسوع: \"ما تَمَّنعوهش، خاطَر واحَد ما يَقدَر بَعد ما يْدير مُعجِزة بآسمي يْقول الشَر علِيَّ، ");
INSERT INTO arq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","اللي ماشي ضَدّنا معانا، ");
INSERT INTO arq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","واللي يْعطيلكُم كاس ما على جال اللي أنتومَ مْتاع المَسيح، نْقولَلكُم الصَح، ما يْضَيَّعش الآجَر مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","واللي يَعتَّر واحَد من هاد الصْغار اللي يامنو بِيَّ، خيرلو لوكان دارولو حَجرة الرْحا في رَقَّبتو وأتَّرما فالبْحَر. ");
INSERT INTO arq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","وَلاّ يَدَّك تْعَتّرَك، قَطَّعها خاطَر خيرلَك تَدخُل للحْياة بيَد واحدة وَلا تْكون بزوج يَدّين وتْروح لجَهَنَّمة، فالنار اللي ما تَطفاش، ");
INSERT INTO arq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","وَلاّ رَجلَك تَعتّرَك، قَطَّعها خاطَر خيرلَك تَدخُل للحْياة كَعوان، وَلا تْكون بزوج رَجلين وتَتَّرما في جَهَنَّمة، فالنار اللي ما تَطفاش. ");
INSERT INTO arq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","وَلاّ عينك تْعَتّرَك، قَلَّعها، خاطَر خيرلَك تَدخُل لمَلَكوت الله بعين واحدة وَلا تْكون بزوج عينين وتَتَّرما في جَهَنَّمة، ");
INSERT INTO arq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","وين دودهُم ما يْموتش والنار ما تَطفاش، ");
INSERT INTO arq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","خاطَر كُل واحَد يَتمَلَّح بالنار. ");
INSERT INTO arq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","المَلح مْليح، بَصَّح وَلاّ راحتلو البَنّة مْتاعو، باش نْمَلّحوه؟ لازَم يْكون عَندكُم المَلح في نْفوسكُم وعيشو هانيين مع بَعضكُم بَعض\". ");
INSERT INTO arq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ناض يَسوع من تَم وجا لجوايَه اليَهودِيّة ومور واد الأُردُن وزاد تْلايَم عَندو الغاشي وكي عادتو بْدا يْدَرَّس فيهُم. ");
INSERT INTO arq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","قَرّبو ليه الفَرّيسِيّين وسَقساوَه باش يْجَرّبوه: \"يْجوز للراجَل يْطَلَّق مَرتو؟\" ");
INSERT INTO arq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","جاوَب يَسوع وقالَلهُم: \"واش آمَركُم موسى؟\" ");
INSERT INTO arq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","قالولو: \"موسى سْمَح للراجَل باش يَكتَب وَرقة طْلاق ويْطَلَّق مَرتو\"، ");
INSERT INTO arq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","بَصَّح يَسوع قالَلهُم: \"على جال قْساوة قْلوبكُم اللي كْتَبَّلكُم موسى هاد الفَرض، ");
INSERT INTO arq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","بَصَّح فالبَدية مْتاع الخَلق، دارهُم الله دْكَر ونْتَى. ");
INSERT INTO arq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","على هَدا، الراجَل يْخَلّي باباه ويَمّاه ويَلصَق في مَرتو، ");
INSERT INTO arq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ويْوَلّيو في زوج دات واحدة، يَعني ما يْوَلّيوش زوج، يْوَلّيو دات واحدة. ");
INSERT INTO arq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","هِمّالا اللي لاقاه الله، ما يْفَرّقوش بْنادَم.\" ");
INSERT INTO arq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","وفالدار، زادو سَقساوَه التابعين في هاد الآمَر. ");
INSERT INTO arq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","قالَلهُم: \"اللي يْطَلَّق مَرتو ويَتزَوَّج بواحَدُخرى، راه يْخونها، ");
INSERT INTO arq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ولو كان هِيَ تْطَلَّق راجَلها وتَتزَوَّج بواحَدآخُر، راهي تَزني\". ");
INSERT INTO arq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","جابولو دْراري صْغار باش يْمَسّهُم، والتابعين زْڤاو عليهُم. ");
INSERT INTO arq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","كي شافهُم يَسوع، زْعَف وقالَلهُم: \"خَلّيو الدْراري الصْغار يْجيو لعَندي، ما تَمَّنعوهُمش، خاطر مَلَكوت الله للي بْحالهُم. ");
INSERT INTO arq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","نْقولَلكُم الصَح، اللي ما يَقبَلش مَلَكوت الله كي الوْلَد الصْغير، ما يَدَّخلوش\". ");
INSERT INTO arq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","وعَنَّق هَدوك الدْراري، بارَكهُم ودار يَدّيه عليهُم. ");
INSERT INTO arq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","وكي جا رايَح للطْريق، جا واحَد يَجري، رْكَعلو وسَقساه: \"يا الشيخ المْليح، واش نْدير باش نَورَت الحْياة الدايمة؟\" ");
INSERT INTO arq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","قاللو يَسوع: \"وَعلاش تْقوللي مْليح؟ واحَد ما مْليح من غير الله وَحدو.\" ");
INSERT INTO arq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","تَعرَف الفْرايَض: \"ما تُقتَلش، ما تَزنيش، ما تَسرَقش، ما تَشهَدش بالزور، ما تَضلَمش، كَرَّم باباك ويَمّاك.\" ");
INSERT INTO arq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","جاوبو: \"شيخ، هَدو كامَل طَبَّقتهُم من صُغري\"، ");
INSERT INTO arq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","خْزَر فيه يَسوع، حَبّو وقاللو: \"خَصّاتَك حاجة واحدة، روح بيع كامَل واش تَملَك وأعطيه للڤْلالين، ويْكونلَك كَنز فالسْما، وأرواح تَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","تْغَبَّن هَداك الراجَل كي سْمَع هاد الكَلمة وراح حْزين خاطَر كان مْرَفَّه بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","شاف يَسوع سايَر دايَر عليه وقال للتابعين مْتاعو: \"شْحال واعَر على المْرَفّهين باش يَدُّخلو لمَلَكوت الله\"، ");
INSERT INTO arq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","خافو التابعين من كْلامو. زاد نْطَق يَسوع وقال: \"يا وْلادي، شْحال واعَر باش يَدخُل واحَد لمَلَكوت الله، ");
INSERT INTO arq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ساهَل على الجْمَل باش يْجوز من العين مْتاع بْرة كْتَر من المْرَفَّه باش يَدخُل لمَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","دَهشو التابعين بَزّاف وقالو لبَعضهُم بَعض: \"وشْكون يَقدَر يَسلَك؟\" ");
INSERT INTO arq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","خْزَر فيهُم يَسوع وقالَلهُم: \"عَند الناس مُحال، بَصَّح ماشي مُحال عَند الله، خاطَر عَند الله حاجة ماهي مُحال\". ");
INSERT INTO arq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","بْدا بُطرُس يْقوللو: \"هانا حْنا خَلّينا كُل شي وتَبَّعناك.\" ");
INSERT INTO arq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","جاوبو يَسوع: \"نْقولَلكُم الصَح، كُل من خَلاّ دار وَلاّ خاوة وَلاّ خْواتات وَلاّ يَمّات وَلاّ بابات وَلاّ دْراري وَلاّ حْواش على جالي وعلى جال البْشارة، ");
INSERT INTO arq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","يْنال قيسهُم مْية مَرّة دُرك في هاد الزْمان دْيار وخاوة وخْواتات ويَمّات ودْراري وحْواش مع الحُڤرة وفالزْمان الجاي الحْياة الدايمة. ");
INSERT INTO arq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","بَزّاف الأوّلانِيّين اللي يْوَلّيو الأخّرانِيّين والأخّرانِيّين الأوّلانِيّين.\" ");
INSERT INTO arq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","كانو فالطْريق طالعين لأورشَليم، وكان يَسوع سابَقهُم. كانو مَخلوعين واللي كانو يْتَبّعو خايفين، ويَسوع زاد خْدا التابعين الطْناش وبْدا يَهدَرَّلهُم على الحاجات اللي رايحين يَصراولو: ");
INSERT INTO arq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","\"هانا طالعين لأورشَليم، وبْن الإِنسان رايَح يَتسَلَّم لرِيّاس رْجال الدين والكُتّاب ويَحَّكمو عليه بالموت، ويْسَلّموه للكُفّار، ");
INSERT INTO arq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","يَتمَسخرو بيه ويَبَّزقو عليه ويَجَّلدوه ويَقُّتلوه وبَعد تَلت أَيّام يْقوم.\" ");
INSERT INTO arq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","أَدّنّاو ليه يَعقوب ويوحَنّا وْلاد زَبَدي وقالولو: \"شيخ، حَبّينا تْديرلنا الشي اللي نَطَّلبوه مَنَّك\"، ");
INSERT INTO arq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","قالَلهُم: \"واش حَبّيتو نْديرلكُم؟\" ");
INSERT INTO arq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","قالولو: \"أعطينا باش فالمَجد مْتاعك نَقُّعدو واحَد على اليْمنى مْتاعك والآخُر على اليْسرى مْتاعك\"، ");
INSERT INTO arq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","قالَلهُم يَسوع: \"ما راكُمش عارفين واش راكُم تَطَّلبو. تَقَّدرو تَشُّربو الكاس اللي نَشرُب، وَلاّ تَتعَمدو بالمَعموديّة اللي راني رايَح نَتعَمَّد بيها؟\" ");
INSERT INTO arq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","قالولو: \"نَقَّدرو\". بَصَّح يَسوع قالَلهُم: \"صَح رايحين تَشُّربو الكاس اللي نَشرُب ورايحين تَتعَمدو بالمَعموديّة اللي راني رايَح نَتعَمَّد بيها، ");
INSERT INTO arq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","بَصَّح القْعاد على يْميني وَلاّ على يْساري، ماشي لِيَّ باش نَعطيه، ويْكون غير للي تْوَجَّدَّلهُم\". ");
INSERT INTO arq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","وكي سَمعو التابعين العَشرة، زَعفو من يَعقوب ويوحَنّا. ");
INSERT INTO arq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","عَيَّطَّلهُم يَسوع وقالَلهُم: \"راكُم عارفين باللي حُكّام الأُمّات يْسيطرو عليهُم والكْبار يَتسَلّطو عليهُم، ");
INSERT INTO arq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ما لازَمش يْكون هَكدا بيناتكُم، بَصَّح اللي حَب يْكون كْبير بينكُم، لازَم يْكون خْديمكُم، ");
INSERT INTO arq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","واللي يْحَب يْكون الأَوَّل بينكُم، يْكون عَبد الكُل، ");
INSERT INTO arq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","خاطَر بْن الإِنسان ماجاش باش يَخَّدموه، جا باش يَخدَم ويَعطي حْياتو فَدية لبَزّاف.\" ");
INSERT INTO arq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","راحو لأَريحا، وكي كان يَسوع خارَج من أريحا هُوَ والتابعين مْتاعو وغاشي كْبير، كان بَرتيماوَس وْليد تيماوَس، طَلاّب عْمى، قاعَد على طَرف الطْريق. ");
INSERT INTO arq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","وكي سْمَع باللي هَدا يَسوع الناصري، بْدا يْعَيَّط ويْقول: \"يا يَسوع بَن داوَد، حَن عْلِيَّ.\" ");
INSERT INTO arq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","بَزّاف زْڤاو عليه باش يَسكُت، وهُوَ زاد عَيَّط كْتَر: \"يا بَن داوَد، حَن عْلِيَّ.\" ");
INSERT INTO arq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","حْبَس يَسوع وقال: \"عَيّطولو\". عَيّطو للعْمى وقالولو: \"أَتسَجَّع، نوض، راهو يْعَيَّطلَك.\" ");
INSERT INTO arq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","رْما البَرنوس مْتاعو، نَڤَّز وجا ليَسوع. ");
INSERT INTO arq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","سَقساه يَسوع وقال: \"واش حَبّيتني نْديرلَك؟\" قاللو العْمى: \"سيدي، نْوَلّي نْشوف\"، ");
INSERT INTO arq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","قاللو يَسوع: \"روح،إيمانَك سَلّكَك\". تَم تَم وَلاّ يْشوف وتَبَّع يَسوع فالطْريق. ");
INSERT INTO arq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","وكي قَرّبو من أورشَليم ووَصلو لبيت فاجي وبيت عَنيا، عَند جْبَل الزيتون، بْعَت يَسوع زوج من التابعين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","وقالَلهُم: \"روحو للدَشرة اللي راهي مْقابلَتكُم، وغير تَدُّخلوها تَلقاو حْمار صْغير مَربوط، عَمرو ما رْكَب عليه واحَد. حَلّولو الرْباط وجيبوه، ");
INSERT INTO arq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","وَلاّ قالَلكُم كاش واحَد: \"وَعلاش راكُم تْديرو هَكدا؟\" قولو: \"مولاه يَسَّحقو\"، تَم تَم يَبَّعتو اللَهنا\". ");
INSERT INTO arq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","راحو ولْقاو الحْمار الصْغير مَربوط عَند واحَد الباب بَرّا فالزَنقة وحَلّولو الرْباط. ");
INSERT INTO arq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","شي ناس كانو تَمّة قالولهُم: \"واش راكُم تْديرو تْحَلّو في رْباط الحْمار؟\" ");
INSERT INTO arq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","قالولهُم كيما قال يَسوع وهَدوك الناس خَلاّوهُم. ");
INSERT INTO arq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","جابو الحْمار الصْغير ليَسوع وحَطّو عليه حْوايَجهُم وقْعَد يَسوع عليه، ");
INSERT INTO arq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","وبَزّاف اللي فَرّشو حْوايَجهُم على الطْريق، وواحَدُخرين غْصان قَطّعوهُم من الأَحواش. ");
INSERT INTO arq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","اللي كانو سابقين واللي كانو يْتَبّعو كانو يْعَيّطو: \"أوصَّنا، مْبارَك الجاي بآسَم الرَب، ");
INSERT INTO arq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ومْبارَك مَلَكوت بابانا داوَد الجاي، أوصَّنا فالعْلالي.\" ");
INSERT INTO arq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","دْخَل يَسوع لأورشَليم، للمَعبَد ودَوَّر راسو شاف كامَل تَمّة. كان راح الحال وراح لبيت عَنيا مع التابعين الطْناش. ");
INSERT INTO arq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","وغَدوة من داك، كي خَرجو من بيت عَنيا جاع يَسوع، ");
INSERT INTO arq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","وشاف من البْعيد كَرمة وَرّقَت، جا يْشوف كاش ما يَلقا فيها ولْقا فيها غير الوْرَق، خاطَر ماكانش وَقت الكَرموس. ");
INSERT INTO arq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","نْطَق يَسوع وقال: \"واحَد ما يَقدَر يْزيد ياكُل مَنَّك فاكية للدْوام.\" والتابعين مْتاعو سَمعوه. ");
INSERT INTO arq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","راحو لأورشَليم وكي دْخَل يَسوع للمَعبَد بْدا يْخَرَّج بَرّا اللي كانو يْبيعو ويَشريو فالمَعبَد ويْقَلَّب الميدات مْتاع اللي يْبَدّلو الدْراهَم والكْراسا مْتاع اللي يْبيعو الحْمام، ");
INSERT INTO arq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","وما خَلاّ حَتّى واحَد يْجَوَّز حاجة على المَعبَد. ");
INSERT INTO arq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","وبْدا يدَرَّس فيهُم ويْقول: \"ماشي مَكتوب: \"داري تَتسَمّا دار للصْلاة لكامَل الأُمّات؟\" وأنتومَ رَدّيتوها غار للسَرّاقين\". ");
INSERT INTO arq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","سَمعو رِيّاس رْجال الدين والكُتّاب وكانو يْحَوّسو كيفاش يَقُّتلوه، كانو يْخافوه خاطَر كامَل الغاشي كان مَستَعجَب فالتَعليم مْتاعو. ");
INSERT INTO arq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","وكي جات العْشِيّة، خْرَج يَسوع والتابعين مْتاعو من المْدينة. ");
INSERT INTO arq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","كي كانو جايزين مع الصْباح، شافو التابعين الكَرمة يابسة حَتّى للعْروق، ");
INSERT INTO arq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","وتْفَكَّر بُطرُس واش صْرا البارَح وقال ليَسوع: \"سيدي، شوف، الكَرمة اللي نْعَلتها البارَح يَبسَت.\" ");
INSERT INTO arq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","جاوَب يَسوع وقالَلهُم: \"آمنو بالله، ");
INSERT INTO arq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","نْقولَلكُم الصَح باللي اللي يْقول لهاد الجْبَل: أَتَّرفَد وأتَّرما فالبْحَر، وما يْشَكّش في قَلبو ويامَن باللي واش راهو يْقول يَصرا، يُستَجَبلو، ");
INSERT INTO arq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","على هَدا نْقولَلكُم، كامَل واش تْصَلّيو وتَطَّلبو، آمنو باللي نَلتوه ويْكونَلكُم. ");
INSERT INTO arq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","وكي تْكونو واقفين تْصَلّيو، أَغَّفرو وَلاّ كانَت عَندكُم حاجة ضَد واحَد، باش باباكُم اللي فالسْماوات يَغفَرَّلكُم تاني الغَلطات مْتاعكُم. ");
INSERT INTO arq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","بَصَّح لو كان ما تَسَّمحوش، باباكُم اللي فالسْموات تاني ما يَغْفَرَّلكُمش الغَلطات مْتاعكُم\". ");
INSERT INTO arq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","وزادو راحو لأورشَليم. وكي كان يَسوع يَمشي فالمَعبَد، جاو ليه رِيّاس رْجال الدين والكُتّاب والشْيوخ، ");
INSERT INTO arq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","وقالولو: \"بواش من الحُكمة راك تْدير هاد الشي؟ وشْكون عْطاك هاد الحُكمة باش تْدير هاد الشي؟\" ");
INSERT INTO arq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","بَصَّح يَسوع قالَلهُم: \"نْسَقسيكُم حاجة واحدة، وجاوبوني ونْقولَلكُم بواش من الحُكمة نْدير هاد الشي. ");
INSERT INTO arq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","مَعموديّة يوحَنّا من السْما وَلاّ من الناس؟ جاوبوني.\" ");
INSERT INTO arq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","خَمّمو بيناتهُم وقالو: \"لوكان نْقولو: \"من السْما\"، يْقول: \"وَعلاش هِمّالا ما آمَنتوش بيه؟\" ");
INSERT INTO arq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ولوكان نْقولو: \"من الناس؟\"\" وخافو من الغاشي خاطَر كانو كامَل شايفين باللي يوحَنّا كان صَح نَبي. ");
INSERT INTO arq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","جاوبو يَسوع وقالو: \"ما راناش عارفين\". ويَسوع قالَلهُم: \"أنا تاني ما نْقولَلكُمش بواش من الحُكمة نْدير هاد الشي.\" ");
INSERT INTO arq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","وبْدا يَسوع يَهدَر معاهُم بالمْتال: \"واحَد الراجَل غْرَس دالية ودَوَّر عليها الزَرب وحْفَر مَعصرة وبْنا بُرج وكْراها لفَلاّحين وسافَر، ");
INSERT INTO arq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","وكي وْصَل وَقت الغَلّة، بْعَت للفَلاّحين خَدّام باش يَدّي غَلّة الدالية، ");
INSERT INTO arq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","شَدّوه الفَلاّحين، ضَربوه وبَعتوه يَدّيه فارغين. ");
INSERT INTO arq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","وزاد مول الدالية بْعَتَّلهُم خَدّام واحَدآخُر، ضَربوه للراس وسَبّوه، ");
INSERT INTO arq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","وزاد بْعَت واحَدآخُر وقَتلوه، وواحَدُخرين بَزّاف، كايَن اللي ضَربوهُم وكايَن اللي قَتلوهُم. ");
INSERT INTO arq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","وكان عَندو تاني وْلَد عْزيز عليه بَزّاف، بَعتهولهُم هُوَ الأخراني، وقال: \"وْليدي يْقادروه\"، ");
INSERT INTO arq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","بَصَّح هَدوك الخَدّامين قالو بيناتهُم: \"هَدا هُوَ اللي يَورَت، هَيّاو نَقُّتلوه والوَرث يْكون لينا\". ");
INSERT INTO arq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","شَدّوه، قَتلوه ورْماوَه خارَج الدالية. ");
INSERT INTO arq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","واش يْدير هِمّالا مول الدالية؟ يْجي، يَقتَل الفَلاّحين ويَعطي الدالية لواحَدُخرين\". ");
INSERT INTO arq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","قالَلهُم يَسوع: \"ما قْريتوش هاد المَكتوب: \"الحَجرة اللي ما قَبلوهاش البَنّايين وَلاّت حَجرة الوْصَل\"، ");
INSERT INTO arq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","هاد الشي جا من الرَب وهاد الشي عْجَب عَندنا.\" ");
INSERT INTO arq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","فَهمو باللي قال المْتَل عليهُم وحَوّسو يَحَّكموه بَصَّح خافو من الغاشي، وخَلاّوَه وراحو. ");
INSERT INTO arq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","بَعتولو شي فَرِيسِيّين وهيرودوسِيّين باش يْطَيّحوه بكَلمة، ");
INSERT INTO arq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","وكي راحو قالولو: \"شيخ، رانا عارفين باللي أنتَ حَقّاني وما تْديرش الوْجوه، وتْعَلَّم طْريق الله بالحَق. يْجوز باش تَتمَد الغْرامة لقَيصَر وَلاّ لالا؟ نْمَدّو وَلاّ ما نْمَدّوش؟\" ");
INSERT INTO arq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","عْرَف يَسوع التْنوفيق مْتاعهُم وقالَلهُم: \"وَعلاش راكُم تْجَرّبو فِيَّ، أَعطيوني دينار نْشوفو.\" ");
INSERT INTO arq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","جابوهولو وقالَلهُم: \"مْتاع من هاد التَصويرة وهاد الكْتيبة؟\" قالولو: \"مْتاع قَيصر\"، ");
INSERT INTO arq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","هِمّالا قالَلهُم يَسوع: \"أعطيو لقَيصَر حاجة قَيصَر، ولله حاجة الله\". وسْتَعجبو فيه. ");
INSERT INTO arq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","وجاو ليه الصَدّوقِيّين اللي يْقولو باللي ما كانش القِيامة وسَقساوَه وقالو: ");
INSERT INTO arq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","\"شيخ، موسى كَتبَّلنا هاد الشي: \"لو كان يْموت خو كاش واحَد، ويْخَلّي مَرتو وما يْخَلّيش الدْراري، لازَم خوه يَتزَوَّج بمَرتو باش يْدير الدَرِّيّة لخوه\". ");
INSERT INTO arq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","كانو كاينين سَبعة خاوة، الأوَّل تْزَوَّج ومات وما خَلاّش دْراري، ");
INSERT INTO arq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","تْزَوَّج التاني بمَرت الأوَّل ومات وما خَلاّش دْراري، والتالَت كيف كيف. ");
INSERT INTO arq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","وفي سَبعة تْزَوّجو بيها وما خَلاّوش الدَرِّيّة، ومع الأخَّر فيهُم كامَل ماتَت هِيَ تاني. ");
INSERT INTO arq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","فالقِيامة، مَرت من فيهُم رايحة تْكون؟ خاطَر في سَبعة تْزَوّجو بيها.\" ");
INSERT INTO arq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","جاوَبهُم يَسوع: \"ما تَعَّرفو لا الكْتوب، لا قُدرة الله، على هَدا اللي راكُم غالطين. ");
INSERT INTO arq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","خاطَر كي يْقومو الموتى، لا الرْجال يَتزَوّجو ولا النْسا يَتزَوّجو بيهُم، بَصَّح يْكونو كي المَلايكة فالسْماوات. ");
INSERT INTO arq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","على آمَر الموتى وقْيامَتهُم، ما قْريتوش في كْتاب موسى، كيفاش قاللو الله فالعَلاّيَڤ: \"أَنا إِلَه إِبراهيم وإِلَه إِسحاق وإِلَه يَعقوب\"، ");
INSERT INTO arq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","الله ماشي إِلَه الموتى، الله إِلَه الحَيّين، راكُم غالطين بَزّاف.\" ");
INSERT INTO arq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","أَدَّنّا واحَد من الكُتّاب سْمَعهُم يَهَّدرو، وشاف باللي يَسوع جاوَبهُم مْليح، وسَقساه: \"أَما هُوَ الفَرض الكْبير فالفْرايَض كامَل؟\" ");
INSERT INTO arq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","جاوَب يَسوع باللي الكْبير هُوَ: \"أَسمَع، إِسرائيل، الرَب إِلَهنا رَب واحَد، ");
INSERT INTO arq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","وتْحَب الرَب إِلَهَك من كُل قَلبَك، ومن كُل نَفسَك، ومن كُل تَخمامَك ومن كُل قَوّتَك\"، ");
INSERT INTO arq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","وهَدا التاني: \"تْحَب قْريبَك كيما نَفسَك\". ما كانش فَرض كْبير على هاد الزوج.\" ");
INSERT INTO arq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","قاللو الكاتَب: \"مْليح شيخ، قُلت بالحَق باللي الله واحَد وما كانش إِلَه غيرو، ");
INSERT INTO arq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ويَتحَب من كُل القَلب، وكُل العْقَل، وكُل القُوّة، ومْحَبّة القْريب كيما نَفسَك خير بَزّاف من كامَل المَحروقات والدْبايَح.\" ");
INSERT INTO arq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","شاف يَسوع العْقَل في وْجاب الكاتَب وقاللو: \"ما راكش بْعيد على مَلَكوت الله\"، وواحَد ما زاد قْدَر يْسَقسيه. ");
INSERT INTO arq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","نْطَق يَسوع وقال وهُوَ يْدَرَّس فالمَعبَد: \"كيفاش يْقولو الكُتّاب باللي المَسيح وْليد داوَد؟ ");
INSERT INTO arq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","داوَد بالدات قال بالروح القُدّوس: \"قال الرَب لرَبّي، أَقعَد على يْميني حَتّى نْحَط عَديانَك تَحت رَجليك.\" ");
INSERT INTO arq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","داوَد بالدات يْقوللو رَبّي، كيفاش يْكون وْليدو؟\" والغاشي كان كاتَر وكانو يْحَبّو كي يَسَّمعولو. ");
INSERT INTO arq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","وفالتَعليم مْتاعو قال: \"رَدّو بالكُم من الكُتّاب اللي يْحَبّو يَمشيو بڤْنادَر طْوال، ويْسَلّمو عليهُم فالأسْواق، ");
INSERT INTO arq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ويْحبّو الكْراسا الأوّلين فالمْجامَع ويَقَّعدو مع اللأوّلين فالوَليمات، ");
INSERT INTO arq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","اللي ياكلو دْيار الهَجّالات ويْطَوّلو فالصْلاة باش يْبانو. هَدو يْنالو عِقاب كْبير\". ");
INSERT INTO arq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","وقْعَد يَسوع قُدّام الخَزنة، وبْدا يْمَيَّز كيفاش كان الغاشي يْحَط الدْراهَم فيها. كايَن بَزّاف من المْرَفّهين اللي حَطّو بَزّاف، ");
INSERT INTO arq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","وجات واحَد الهَجّالة ڤَلّيلة، حَطَّت زوج دْريهمات قيس زوج دورو. ");
INSERT INTO arq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","عَيَّط يَسوع للتابعين مْتاعو وقالَلهُم: \"نْقولَلكُم الصَح، هاد الهَجّالة الڤَلّيلة حَطَّت كْتَر منهُم كامَل اللي حَطّو فالخَزنة، ");
INSERT INTO arq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","خاطَر هومَ كامَل حَطّو من الشْياطة مْتاعهُم بَصَّح هِيَ حَطَّت كامَل واش عَندها، حَطَّت كامَل قوتها\". ");
INSERT INTO arq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","وكي كان يَسوع خارَج من المَعبَد، قاللو واحَد من التابعين مْتاعو: \"شيخ، شوف واش من الحْجَر، واش من البَنيان!\" ");
INSERT INTO arq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","قاللو يَسوع: \"راك تْشوف هاد البَنيان الكْبير؟ ما تَقعَد حَتّى حَجرة فوق حَجرة، كُل شي يَنهَد.\" ");
INSERT INTO arq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","قْعَد يَسوع على جْبَل الزيتون مْقابَل المَعبَد، سَقساوَه على جيه بُطرُس ويَعقوب ويوحَنّا وأَندراوَس: ");
INSERT INTO arq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"قوللنا، وَقتاش يْكون هاد الشي وواشَن هِيَ المارة باللي هاد الشي رايَح يَخلاص؟\" ");
INSERT INTO arq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","وبْدا يَسوع يْقولَلهُم: \"رَدّو بالكُم يْعود يْغَلَّطكُم كاش واحَد، ");
INSERT INTO arq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","بَزّاف اللي يْجيو بآسمي يْقولو: \"أَنا هُوَ\" ويْغَلّطو ناس بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","كي تَسَّمعو بحْروب وبخْبار مْتاع حْروب، ما تْخافوش، لازَم يَصرا هاد الشي، بَصَّح الآخرة مازال. ");
INSERT INTO arq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","خاطَر تْنوض أُمّة ضَد أُمّة، ومَملَكة ضَد مَملَكة، يْكونو زْنازَل في مْضارَب بَزّاف ومَجاعات. هاد الشي هُوَ البَدية مْتاع وْجاع الوْلادة. ");
INSERT INTO arq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","رَدّو بالكُم على روحكُم، يْسَلّموكُم للمْجالَس الدينِيّين وللمْجامَع ويْهينوكُم، تَوَّقفو قُدّام حُكّام وسْلاطَن على جالي باش تَشَّهدولهُم. ");
INSERT INTO arq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ولازَم قْبَل يَتبَرَّح بالإِنجيل لكامَل الأُمّات. ");
INSERT INTO arq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","وكي يَدّيوكُم يْسَلّموكُم، ما تَتحَيّروش من قْبَل على واش رايحين تْقولو، بَصَّح اللي يَتَّعطالكُم في هَديك الساعة قولوه، خاطَر ماشي أنتومَ اللي تْكونو تَهَّدرو، الروح القُدّوس هُوَ اللي يْكون يَهدَر. ");
INSERT INTO arq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","الخو يْسَلَّم خوه للموت، والباباة وْليدو. يْنوضو دْراري ضَد مْواليهُم ويَقُّتلوهُم، ");
INSERT INTO arq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","تْكونو مَكروهين من الكُل على جال آسمي. اللي يَتبَت حَتّى للأخَّر، هَداك يَسلَك. ");
INSERT INTO arq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","كي تْشوفو نْجاسة الوَخدة تْكون وين ما لازَمش، - اللي يَقرا لازَم يَفهَم - هِمّالا مْتاع اليَهودِيّة، غير يَهَّربو للجْبال، ");
INSERT INTO arq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","اللي يْكون فالسْطَح، غير ما يَهبَطش وما يَدخُلش يَدّي كاش حاجة من دارو، ");
INSERT INTO arq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","واللي يْكون فالحوش، غير ما يْوَلّيش للور باش يَدّي حْوايجو. ");
INSERT INTO arq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","يا ويلهُم اللي يْكونو بالجوف واللي يْرَضّعو في هَدوك اليامات. ");
INSERT INTO arq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","صَلّيو باش ما يْكونش هاد الشي فالشْتا، ");
INSERT INTO arq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","خاطَر هَدوك اليامات، تْكون شَدّة كْبيرة ما صْراتش بحالها من اللي بْدات الدَنيا اللي خْلَقها الله حَتّى لدُرك وماراهيش رايحة تَصرا. ");
INSERT INTO arq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ولو كان الرَب ما قَصَّرس اليامات، لو كان في هَديك الحالة دات ما تَسلَك، بَصَّح على جال المُختارين اللي خَيَّرهُم، قَصَّر اليامات. ");
INSERT INTO arq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","وداك الوَقت، وَلاّ كاش واحَد قالَلكُم: \"شوف، المَسيح راه هْنا، وَلاّ راه لْهيك\"، ما تامنوش، ");
INSERT INTO arq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","خاطَر رايحين يْنوضو بَزّاف اللي يَدَّعاو باللي هومَ المَسيح، وأَنبيا كَدّابين، ويْمَدّو مارات وعْجايَب باش يْغَرّو لو كان يَقَّدرو حَتّى المُختارين. ");
INSERT INTO arq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","أنتومَ، رَدّو بالكُم، راني سْبَقت قُلتَلكُم كُل شي. ");
INSERT INTO arq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","بَصَّح في هَدوك اليامات، بَعد هَديك الشَدّة، الشَمس تَضلام والقْمر ما يْزيدش يْضَوّي، ");
INSERT INTO arq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","والنْجوم يْطيحو من السْما وقُدرات السْما يَتزَعزعو. ");
INSERT INTO arq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","وداك الساع يْشوفو بْن الإِنسان جاي فالسْحابات بقُدرة كْبيرة ومَجد. ");
INSERT INTO arq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","وداك الوَقت يَبعَت المَلايكة، ويْلَم المُختارين مْتاعو من الرَبع رْياح ومن طَرف الأرض حَتّى لطَرف السْما. ");
INSERT INTO arq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","خودو المْتَل من الكَرمة: كي يَرطاب الغْصَن مْتاعها وتْوَرَّق، تَعَّرفو باللي الصيف قْريب. ");
INSERT INTO arq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","هَكدا أنتومَ تاني، كي تْشوفو هاد الشي يَصرا، تَعَّرفو باللي بْن الإِنسان راه قْريب، على البيبان. ");
INSERT INTO arq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","نْقولَلكُم الصَح، هاد الجيل ما يْكونش جاز حَتّى يَصرا هاد الشي كامَل. ");
INSERT INTO arq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","السْما والأرض يْزولو، بَصَّح كْلامي ما يْزولش. ");
INSERT INTO arq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","آمَر هَداك اليوم والساعة، واحَد ما يَعرَف، لا المَلايكة فالسْما، لا الإِبن، غير الآب اللي يَعرَف. ");
INSERT INTO arq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","رَدّو بالكُم، كونو فاطنين، خاطَر ما تَعَّرفوش وَقتاش يَوصَل هَداك الوَقت. ");
INSERT INTO arq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","كيما بْنادَم اللي يْسافَر، يْخَلّي دارو ويَعطي كَلافة للخَدّامين مْتاعو، كُل واحَد خَدَّمتو، ويْوَصّي العَسّاس مْتاع الباب باش يْرَد بالو. ");
INSERT INTO arq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","هِمّالا كونو فاطنين، خاطَر ما تَعَّرفوش وَقتاش يْجي مول الدار، فالعْشِيّة وَلاّ في نَص الليل وَلاّ كي يْعوعَش السَردوك وَلاّ الصْباح، ");
INSERT INTO arq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","يْعود يْجي على غَفلة ويَلقاكُم راقدين. ");
INSERT INTO arq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","الشي اللي نْقولهولكُم، نْقولو للكُل، كونو فاطنين\". ");
INSERT INTO arq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","عيد الفَصح وعيد الفْطير كانو رايحين يْجيو بَعد يومين، وكانو رِيّاس رْجال الدين والكُتّاب يْحَوّسو كيفاش يَحَّكمو يَسوع بالحيلة ويَقُّتلوه، ");
INSERT INTO arq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","خاطَر قالو: \"ماشي فالعيد، يْعود يَصرا الهول فالشَعب\". ");
INSERT INTO arq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","وكي كان يَسوع في بيت عَنيا قاعَد على الميدة في دار سَمعان البْرَص، جات مْرا عَندها قَرعة مْتاع المَرمَر فيها ريحة حُرّة وغالية بَزّاف، كَسَّرتها وفَرّغَت الريحة على راس يَسوع. ");
INSERT INTO arq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","جْماعة من اللي كانو تَمّة ما عْجَبهُمش الحال وقالو في قْلوبهُم: \"وَعلاش هاد الخْسارة؟ ");
INSERT INTO arq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","هاد الريحة كانَت قادرة تَتباع كْتَر من تَلت مْية دينار يَتمَدّو للڤْلالين.\" ولامو على المْرا. ");
INSERT INTO arq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","بَصَّح يَسوع قال: \"خَلّيوها، وَعلاش راكُم تْغَبّنو فيها؟ دارتلي حاجة مْليحة. ");
INSERT INTO arq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","خاطَر عَندكُم الڤْلالين دايمًا معاكُم، وتَقَّدرو تْديرولهُم الخير وَقت ما حَبّيتو، بَصَّح أنا ما نَبقاش دايمًا معاكُم. ");
INSERT INTO arq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","دارَت اللي قَدرَت عليه، سَبقَت دَهنَت داتي لدْفينتي. ");
INSERT INTO arq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","نْقولَلكُم الصَح، وين يَتبَرَّح بالإِنجيل في كامَل الدَنيا، يَتَّحكا تاني واش دارَت هاد المْرا تَفكيرة ليها\". ");
INSERT INTO arq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","يَهودا الإسخريوطي واحَد من التابعين الطْناش، راح لرِيّاس رْجال الدين باش يْسَلَّمَّلهُم يَسوع. ");
INSERT INTO arq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","هومَ كي سَمعو، فَرحو ووَعدوه يَعطيولو الدْراهَم، وكان يْحَوَّس وَقت مْوالَم باش يْسَلّمو. ");
INSERT INTO arq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","واليوم الأوَّل مْتاع عيد الفْطير كي كانو يَدَّبحو في خْروف الفَصح، قالولو التابعين مْتاعو: \"وين حَبّيتنا نْروحو نْوَجّدولَك باش تاكُل الفَصح؟\" ");
INSERT INTO arq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","بْعَت زوج من التابعين مْتاعو وقالَلهُم: \"روحو للمْدينة، تَتلاقاو بواحَد رافَد قُلّة مْتاع الما، تَبّعوه، ");
INSERT INTO arq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ووين يَدخُل، قولو لمول الدار: \"الشيخ راه يْقول: وين راهي البيت اللي ناكُل فيها الفَصح مع التابعين مْتاعي؟ ");
INSERT INTO arq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","وهُوَ يْوَرّيلكُم بيت فوقانِيّة كْبيرة مْفَرّشة وواجدة، تَمّة وَجّدولنا الفَصح\". ");
INSERT INTO arq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","خَرجو التابعين وراحو للمْدينة ولْقاو كُل شي كيما قالَلهُم يَسوع، ووَجّدو الفَصح. ");
INSERT INTO arq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","كي جات العْشِيّة، جا يَسوع مع التابعين الطْناش، ");
INSERT INTO arq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","وكي كانو قاعدين ياكلو على الميدة، قال يَسوع: \"نْقولَلكُم الصَح، واحَد فيكُم اللي راهو ياكُل معايَ، رايَح يْسَلَّمني\". ");
INSERT INTO arq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","بداو يَتغَبّنو ويْقولولو واحَد واحَد: \"أَنا؟\" ");
INSERT INTO arq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","قالَلهُم يَسوع: \"واحَد من الطْناش، اللي يْغَمَّس معايَ فالطَبسي، ");
INSERT INTO arq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","بْن الإِنسان رايَح يْروح على حْساب ماهو مَكتوب عليه، بَصَّح يا ويلو اللي يْسَلَّم بْن الإِنسان، خير لو هَداك البْنادَم لوكان ما نْزادش\". ");
INSERT INTO arq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","وكي كانو ياكلو، خْدا يَسوع الخُبز، بارَك، قْسَم وعْطالهُم وقال: \"خودو، هَدي داتي\"، ");
INSERT INTO arq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","وخْدا الكاس، حْمَد، عْطالهُم وشَربو مَنّو كامَل، ");
INSERT INTO arq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","وقالَلهُم: \"هَدا دَمّي، دَم العَهَد اللي يْسيل على جال ناس بَزّاف، ");
INSERT INTO arq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","نْقولَلكُم الصَح، ما نْزيدش نَشرُب من غَلّة الدالية حَتّى لهَداك اليوم كي نَشَّربو جْديد في مَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","وبَعد ما غَنّاو التَرانيم، خَرجو لجْبَل الزيتون. ");
INSERT INTO arq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","وقالَلهُم يَسوع: \"كامَل رايحين تَعَّترو خاطَر مَكتوب: \"نَضرَب الراعي والخَرفان يَتزَربعو\"، ");
INSERT INTO arq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","بَصَّح بَعد ما نْقوم، نَسبَقكُم للجْليل\". ");
INSERT INTO arq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","بَصَّح قاللو بُطرُس: \"حَتّى لو كان كامَل يَعَّترو، أَنا لالا.\" ");
INSERT INTO arq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","قاللو يَسوع: \"نْقوللَك الصَح، اليوم في هاد الليلة، قْبَل ما يْعوعَش السَردوك زوج مَرّات، أَنتَ تَنكُرني تَلت مَرّات.\" ");
INSERT INTO arq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","بَصَّح بُطرُس زاد وَكَّد كْتَر: \"لو كان يَلزَملي نْموت معاك، عَمري ما نَنكرَك\". وكامَل قالو كيف كيف. ");
INSERT INTO arq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","وراحو لواحَد المْكان واسمو جَتسيماني، وقال يَسوع للتابعين مْتاعو: \"أَقَّعدو هْنا بيدما نْصَلّي\". ");
INSERT INTO arq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","وأَدّا معاه بُطرُس ويَعقوب ويوحَنّا وبْدا يْحَس بالخوف وبالقْلَق، ");
INSERT INTO arq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","وقالَلهُم: \"نَفسي راهي حْزينة حَتّى للموت، أَقَّعدو هنا وأسَّهرو.\" ");
INSERT INTO arq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","وزاد أَدَّنَّا شْوِيّة، وطاح على الأرض وبْدا يْصَلّي باش وَلاّ يَمكَن تْبَعَّد عليه هاد الساعة، ");
INSERT INTO arq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","وقال: \"يا آبا الآب، كُل شي مَقدور عَندَك، بَعَّد علِيَّ هاد الكاس، بَصَّح يْكون ماشي واش نْحَب أَنا، واش تْحَب أنتَ\"، ");
INSERT INTO arq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","وجا لْقاهُم راقدين وقال لبُطرُس: \"سَمعان، راك راقَد؟ ما قْدَرتش تَسهَر ساعة معايَ؟ ");
INSERT INTO arq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","أَسَّهرو وصَلّيو باش ما تْطيحوش فالغْواية،الروح ناشَط بَصَّح الدات ضْعيفة\". ");
INSERT INTO arq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","وزاد بَعَّد وصَلاّ بكْلام واحَد كيما صَلاّ المَرَة الأولى. ");
INSERT INTO arq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","وزاد جا ولْقاهم راقدين، خاطَر كانو عينيهُم تْقال بالنْعاس وما عَرفوش واش يْجاوبوه. ");
INSERT INTO arq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","وجا المَرة التالتة وقالَلهُم: \"أَرُّقدو دُرك ورِيّحو. خْلاص، وَصلَت الساعة، بْن الإِنسان راه تْسَلَّم ليَدّين الخاطيين، ");
INSERT INTO arq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","نوضو نْروحو، هاو قَرَّب اللي يْسَلَّمني.\" ");
INSERT INTO arq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","وتَم تَم وهُوَ مازالو يَهدَر، جا يَهودا، واحَد من التابعين الطْناش ومعاه غاشي بالسْيوفة والمْطارَق مَبعوتين من رِيّاس رْجال الدين والكُتّاب والشْيوخ. ");
INSERT INTO arq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","اللي سَلّمو كان عْطالهُم مارة تْفاهمو عليها وقالَلهُم: \"اللي نْبوسو، هَداك هُوَ، أَحَّكموه وأدّيوَه بالعَسّة\". ");
INSERT INTO arq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","وغير جا، أدَّنّا ليَسوع وقال: \"سيدي\"، وباسو. ");
INSERT INTO arq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","شَدّوه وحَكموه، ");
INSERT INTO arq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","وواحَد من اللي كانو حاضرين، جْبَد السيف وضْرَب خَدّام رايَس رْجال الدين ونَحّالو وَدنو. ");
INSERT INTO arq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","نْطَق يَسوع وقالَلهُم: \"خْرَجتو تَحَّكموني بالسْيوفة والمْطارَق كي السَرّاق، ");
INSERT INTO arq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","كُنت كُل يوم معاكُم فالمَعبَد نْدَرَّس، وما حْكَمتونيش. بَصَّح هاد الشي باش يَتحَقّق الشي اللي فالكْتوب.\" ");
INSERT INTO arq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","وكامَل التابعين خَلاّوَه وهَربو، ");
INSERT INTO arq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","وكان واحَد الراجَل يْتَبَّع فيه، عَريان لابَس غير قْماش رْقيق وحَكموه، ");
INSERT INTO arq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","طْلَق هَداك الراجَل القْماش الرْقيق وهْرَب عَريان. ");
INSERT INTO arq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","أدّاو يَسوع عَند رايَس رْجال الدين، وتْلَمّو كامَل رِيّاس رْجال الدين والشْيوخ والكُتّاب. ");
INSERT INTO arq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","وبُطرُس كان تَبَّع من البْعيد حَتّى للداخَل في وَسط الدار مْتاع رايَس رْجال الدين، وقْعَد مع الخَدّامين يَتدَفّا قُدّام النار. ");
INSERT INTO arq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","رِيّاس رْجال الدين وكامَل المَجلَس الديني كانو يْحَوّسو على شْهادة زور على يَسوع باش يَقُّتلوه وما لْقاوش، ");
INSERT INTO arq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","خاطَر بَزّاف اللي شَهدو بالزور عليه بَصَّح الشْهادات مْتاعهُم ما كانوش كيف كيف. ");
INSERT INTO arq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","وكايَن اللي ناضو وجابو عليه شْهادات مْتاع الزور وقالو: ");
INSERT INTO arq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"سْمَعناه يْقول: \"أَنا نْهَد بيت المَقدَس هَدا المَخدوم بيَدّين بْني آدَم وفي تَلت أيّام نَبني واحَدآخُر ماشي مَخدوم بيَدّين الناس\"\". ");
INSERT INTO arq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","وحَتّى في هَدا، شْهاداتهُم ما كانوش كيف كيف. ");
INSERT INTO arq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ناض رايَس رْجال الدين فالوَسط، سَقسا يَسوع وقال: \"ما تْجاوَب والو هَدو اللي راهُم يَشَّهدو عْليك؟\" ");
INSERT INTO arq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","هُوَ سْكَت وما جاوَب والو. زاد رايَس رْجال الدين سَقساه وقاللو: \"أنتَ هُوَ المَسيح بْن الله المْبارَك؟\" ");
INSERT INTO arq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","داك الساع قاللو يَسوع: \"أنا هُوَ، ورايحين تْشوفو بْن الإنسان قاعَد على يْمين القُدرة وجاي مع سْحابات السْما\". ");
INSERT INTO arq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","بَصَّح رايَس رْجال الدين قَطَّع حْوايجو وقال: \"واش مازَلنا نَسَّحقو شْهود؟ ");
INSERT INTO arq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","راكُم سْمَعتو الكُفر، واش رايكُم؟\" كامَل حَكمو عليه باللي يَستاهَل الموت. ");
INSERT INTO arq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","وبْداو شْوِيّة مَنهُم يَبَّزقو عليه، ويْغَطّيولو في وَجهو، ويْصَقّلو فيه ويْقولولو: \"أَتنَبَّأ\" والعَسكَر لاقاوَه بالصْقالي. ");
INSERT INTO arq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","كي كان بُطرُس التَحت في وَسط الدار، جات واحدة من الخَدّامات مْتاع رايَس رْجال الدين، ");
INSERT INTO arq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","وكي شافَت بُطرُس يَتدَفّا، خَزرَت فيه وقالَت: \"أنتَ تاني كُنت مع الناصري يَسوع\"، ");
INSERT INTO arq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","هُوَ نْكَر وقال: \"ما نَعَّرفوش وما رانيش فاهَم واش راكي تْقولي\"، وخْرَج لبَرّا فالساحة وعوعَش السَردوك. ");
INSERT INTO arq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","وكي زادَت شافتو الخْديمة، بْدات تْقول للي كانو حاضرين باللي هَدا مَنهُم. ");
INSERT INTO arq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","زاد هُوَ نْكَر وشْوِيّة من بَعد زادو اللي كانو تَمّة قالولو: \"صَح أنتَ مَنهُم خاطَر أنتَ تاني جَليلي\". ");
INSERT INTO arq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","بْدا هُوَ يَنعَل ويَحلَف: \"ما نَعرَفش هاد الراجَل اللي راكُم تَهَّدرو عليه\". ");
INSERT INTO arq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","تَم تَم، عوعَش السَردوك المَرّة التانية. تْفَكَّر بُطرُس كْلام يَسوع كي قاللو باللي قْبَل ما يْعوعَش السَردوك زوج مَرّات، أنتَ تَنكُرني تَلت مَرّات. ودار وبْكا. ");
INSERT INTO arq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","غير طْلَع النْهار، تْشاورو رِيّاس رْجال الدين مع الشْيوخ والكُتّاب وكامَل المَجلَس الديني ورَبطو يَسوع وأدّاوَه وسَلّموه لبيلاطَس. ");
INSERT INTO arq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","وسَقساه بيلاطَس: \"أنتَ هُوَ سَلطان اليْهود؟\" جاوبو وقاللو: \"أنتَ قُلت\"، ");
INSERT INTO arq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ورِيّاس رْجال الدين تَهموه بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","زاد بيلاطَس سَقساه وقال: \"ما تْجاوب والو؟ شوف كامَل واش راهُم يَتَّهمو فيك؟\" ");
INSERT INTO arq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","يَسوع ما زاد جاوَب والو حَتّى بيلاطَس نَدهَش. ");
INSERT INTO arq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","في كُل عيد، كان بيلاطَس يَطلَق للشَعب المْحابسي اللي يَطَّلبوه، ");
INSERT INTO arq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","وكان كايَن فالحَبس واحَد واسمو باراباس مع صْحابو، على جال قْتيلة في واحَد الهول، ");
INSERT INTO arq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","وطْلَع الغاشي لبيلاطَس وبْدا يَطلَب باش يْديرلهُم كيما مْوالَف. ");
INSERT INTO arq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","جاوَبهُم بيلاطَس وقالَلهُم: \"تْحَبّو نَطلَقَّلكُم سَلطان اليْهود؟\" ");
INSERT INTO arq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","خاطَر كان عارَف باللي رِيّاس رْجال الدين سَلّمو يَسوع غيرة. ");
INSERT INTO arq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","رِيّاس رْجال الدين حَرّشو الغاشي باش يَطلَقَّلهُم باراباس خير، ");
INSERT INTO arq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","وزاد جاوَبهُم بيلاطَس وقالَلهُم: \"واش حَبّيتو نْدير للي تْسَمّيوَه سَلطان اليْهود؟\" ");
INSERT INTO arq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","هومَ زادو عَيّطو: \"أَصَّلبو\"، ");
INSERT INTO arq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","قالَلهُم بيلاطَس: \"واش من الشَر دارو؟\" هومَ زادو عَيّطو: \"أَصَّلبو\". ");
INSERT INTO arq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","حَب بيلاطَس يْرَضّي الغاشي وطْلَقَّلهُم باراباس وسَلَّم يَسوع بَعد ما جَلدوه باش يَتَّصلَب. ");
INSERT INTO arq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","العَسكَر أدّاوَه لداخَل وَسط الدار اللي هِيَ دار الحُكومة وعَيّطو لكامَل العَسكَر، ");
INSERT INTO arq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ولَبّسولو لَبسة لونها حْمَر حامَق وضَفرو تاج مْتاع الشوك وداروهولو، ");
INSERT INTO arq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","وبْداو يْسَلّمو عليه: \"سَلام يا سَلطان اليْهود\"، ");
INSERT INTO arq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","وكانو يَضَّربوه في راسو بقَصبة ويَبّزقو فيه ويَرَّكعو على رْكايَبهُم قُدّامو، ");
INSERT INTO arq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","وبَعدما تْمَسخرو بيه، نَحّاولو اللَبسة اللي لونها حْمَر حامَق وعاودو لَبّسولو حْوايجو وأدّاوَه بَرّا باش يَصَّلبوه. ");
INSERT INTO arq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","وسَيّفو على واحَد كان جاي من الحوش واسمو سَمعان القيرواني وباباة سْكَندَر وروفَس باش يَرفَد صْليب يَسوع. ");
INSERT INTO arq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","وأدّاوَه لمَدرَب واسمو جُلجُتة يَعني مْكان الجُمجمة، ");
INSERT INTO arq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","وعْطاولو شْراب مْخَلَّط بالمْرار وهُوَ ما خْداهش. ");
INSERT INTO arq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","صَلبوه وتْقاسمو حْوايجو بالقُرعة باش يْشوفو كُل واحَد واش يَدّي. ");
INSERT INTO arq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","كانَت التَسعة مْتاع الصْباح كي صَلبوه، ");
INSERT INTO arq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","وكانَت السَبّة اللي أتَّصلَب عليها مَكتوبة: \"سَلطان اليْهود\"، ");
INSERT INTO arq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","وصَلبو معاه زوج سَرّاقين، واحَد على اليْمنى مْتاعو والآخُر على اليْسرى. ");
INSERT INTO arq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","واللي كانو جايزين كانو يْسَبّو فيه وهومَ يْهَزّو في ريسانهُم ويْقولو: \"يا اللي تْهَد بيت المَقدَس وتَبنيه في تَلت أيّام، ");
INSERT INTO arq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","سَلَّك روحَك وأهبَط من الصْليب\". ");
INSERT INTO arq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","رِيّاس رْجال الدين تاني مع الكُتّاب كانو يَتمَسخرو بيه ويْقولو لبَعضهُم بَعض: \"سَلَّك واحَدُخرين وما قْدَرش يْسَلَّك روحو، ");
INSERT INTO arq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","المَسيح سَلطان إِسرائيل! يَهبَط دُرك من الصْليب باش نْشوفو ونامنو\". واللي نْصَلبو معاه تاني سَبّوه. ");
INSERT INTO arq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","كي جات الطْناش مْتاع النْهار، طاح الضْلام على كامَل الأرض حَتّى للتْلاتة مْتاع العْشِيّة. ");
INSERT INTO arq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","وعلى التْلاتة مْتاع العْشِيّة، عَيَّط يَسوع بالزور: \"إيلي إيلي، لَما شَبَقتني؟\" يَعني: \"إِلَهي، إِلَهي، وَعلاش خَلّيتني؟\" ");
INSERT INTO arq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","جْماعة من اللي كانو حاضرين سَمعوه وقالو: \"راهو يْعَيَّط لإيلِيّا\". ");
INSERT INTO arq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","جا واحَد يَجري، عَمَّر سْفَنجة بالخَل ولَوّاها على قَصبة وعْطا ليَسوع يَشرُب وقال: \"خَلّيو، نْشوفو وَلاّ يْجي إيلِيّا يَهَبّطو\". ");
INSERT INTO arq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","بَصَّح يَسوع عَيَّط عَيطة كْبيرة وسَلَّم الروح، ");
INSERT INTO arq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","وتْقَطَّع حْجاب بيت المَقدَس على زوج من الفوق حَتّى للتَحت. ");
INSERT INTO arq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","كي شافو قايَد المْية اللي كان مْقابلو سَلَّم الروح هَكدا قال: \"هاد الراجَل كان صَح بْن الله.\" ");
INSERT INTO arq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","وكانو تاني نْسا يْشوفو من البْعيد، ومنهُم مَريَم المَجدَلِيّة ومَريَم يَمّاة يَعقوب الصْغير ويوسي وسالومة، ");
INSERT INTO arq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","اللي كانو يْتَبّعو فيه ويَخَّدموه كي كان فالجْليل، وواحَدُخرين بَزّاف طَلعو معاه لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","وغير جات العْشِيّة، وكان التَوجاد ليلة السَبت، ");
INSERT INTO arq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","جا يوسَف، واحَد من الرامة، مُستَشار طالَع، وكان يَستَنّا مَلَكوت الله، قْدَر يَدخُل عَند بيلاطَس يَطلَب مَنّو دات يَسوع. ");
INSERT INTO arq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","نْدهَش بيلاطَس اللي بالخَف مات يَسوع وعَيَّط لقايَد المْية وسَقساه وَلاّ عَندو بَزّاف من اللي مات. ");
INSERT INTO arq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","كي أدّا الخْبَر من قايَد المْية، عْطا الدات ليوسَف. ");
INSERT INTO arq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","شْرا يوسَف كْفَن وهَبَّط دات يَسوع، كَفّنو وحَطّو في قْبَر مَحفور فالحْجَر، وكَركَر حَجرة باش يْسَد باب القْبَر. ");
INSERT INTO arq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","مَريَم المَجدَلِيّة ومَريَم يَمّاة يوسي كانو يْشوفو وين نْحَط. ");
INSERT INTO arq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","كي جاز السَبت، مَريَم المَجدَلِيّة ومَريَم يَمّاة يَعقوب وسالومة شْراو زْيوت مْعَطّرين باش يْروحو يَدَّهنو دات يَسوع، ");
INSERT INTO arq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","واليوم الأوَّل فالجَمعة، الصْباح بَكري، مع طْلوع الشَمس، جاو للقْبَر، ");
INSERT INTO arq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","وكانو يْقولو لبَعضهُم بَعض: \"شْكون يْكَركَرَّلنا الحَجرة من باب القْبَر؟\" ");
INSERT INTO arq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","طَلّعو عينيهُم وشافو الحَجرة مْكَركرة والو كانَت كْبيرة بَزّاف. ");
INSERT INTO arq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","وكي دَخلو للقْبَر، شافو راجَل قاعَد على اليْمنى ولابَس لَبسة بيضة ونْخَلعو. ");
INSERT INTO arq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","قالَلهُم المْلاك: \"ما تَنخَلعوش، راكُم تْحَوّسو على يَسوع الناصري المَصلوب. قام، ما راهوش هنا. هاو المْكان وين كان مَحطوط. ");
INSERT INTO arq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","بَصَّح روحو قولو للتابعين مْتاعو ولبُطرُس باللي رايَح يَسبَقكُم للجْليل وتَمّة تْشوفوه كيما قالَلكُم.\" ");
INSERT INTO arq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","خَرجو وهَربو من القْبَر خاطَر كانو بالرَجفة والخُلعة، وما قالو حَتّى حاجة لحَتّى واحَد خاطَر كانو خايفين. ");
INSERT INTO arq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","قام يَسوع الصْباح بَكري اليوم الأوَّل مْتاع الجَمعة، سْبَق ضْهَر لمَريَم المَجدَلِيّة، اللي كان خَرَّج منها سَبع شْياطَن. ");
INSERT INTO arq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","راحَت هِيَ وخَبّرَت اللي كانو معاه وكانو حْزانا ويَبكيو، ");
INSERT INTO arq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","وهومَ كي سَمعو باللي يَسوع راهو حَي وباللي شافتو ما آمنوش. ");
INSERT INTO arq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","بَعد هَدا، زاد ضْهَر في صِفة واحَدُخرى لزوج مَنهُم كانو يَمشيو رايحين للبْلاد. ");
INSERT INTO arq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","راحو هاد الزوج أدّاو البْشارة للأخرين وتاني ما آمنوهُمش. ");
INSERT INTO arq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","مع الأخَّر، كي كانو التابعين في حْداش على الميدة، ضْهَرَّلهُم ولامهُم على اللي ما آمنوش وعلى قْساوة قْلوبهُم خاطَر ما آمنوش اللي شافوه حَي، ");
INSERT INTO arq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","وقالَلهُم: \"روحو للدَنيا كامَل وبَرّحو بالإِنجيل لكامَل الخَلق، ");
INSERT INTO arq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","اللي يامَن ويَتعَمَّد يَسلَك، بَصَّح اللي ما يامَنش يَتَّحكَم عليه. ");
INSERT INTO arq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","وهاد المارات يْرافقو المومنين: بآسمي يْخَرّجو الشْياطَن، يَهَّدرو لُغات جْدَد، ");
INSERT INTO arq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","يْشَدّو الحْنوشة في يَدّيهُم، وَلاّ شَربو حاجة تُقتَل ما تْضَرّهُمش، ويْديرو يَدّيهُم على المَرضى ويْبراو\". ");
INSERT INTO arq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","بَعد ما هْدَرَّلهُم الرَب يَسوع، أتَّرفَع فالسْما، وقْعَد على يْمين الله. ");
INSERT INTO arq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","وهومَ راحو يْبَشّرو في كُل مْكان، والرَب كان يَخدَم معاهُم ويْتَبَّت كَلمتو بالمارات اللي يْوافقوها. آمين.");
INSERT INTO arq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","على حْساب اللي كايَن بَزّاف اللي دارو حْكاية على الحاجات اللي صْراو عَندنا، ");
INSERT INTO arq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","على حْساب واش قالولنا اللي كانو من البَدية شاهدين ووَلاّو خَدّامين للكَلمة، ");
INSERT INTO arq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","بانلي مْليح أنا تاني، بَعدما تَبَّعت كُل شي بالتَدقيق من الأوَّل لو كان نَكتَبلَك حْكاية مْرَتبة، يا العْزيز تاوفيلَس، ");
INSERT INTO arq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","باش تَعرَف الصَح فالشي اللي سْمَعت بيه. ");
INSERT INTO arq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","كان في زْمان هيرودَس سَلطان اليَهودِيّة، مُقَدَّم واسمو زَكَريّا، من جْماعة أبِيّا، مَرتو من بْنات هارون وواسمها أليصابات. ");
INSERT INTO arq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","كانو في زوج صالحين قُدّام الله، ويْتَبّعو كيما لازَم كامَل الفْرايَض والأحكام مْتاع الرَب، ");
INSERT INTO arq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","وما كانش عَندهُم الدْراري خاطَر أليصابات كانَت عاڤرة وكانو في زوج كْبار فالعْمَر. ");
INSERT INTO arq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","كي لَحقَت دالَة جْماعتو فالمَعبَد، كان زَكَريّا يَخدَم خَدَّمتو قُدّام الله، ");
INSERT INTO arq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","وطاحَت فيه القُرعة على حْساب عادة الكَهَنوت باش يَدخُل لمَعبَد الله ويْبَخَّر. ");
INSERT INTO arq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","كان كامَل الشَعب يْصَلّي بَرّا في وَقت البْخور. ");
INSERT INTO arq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ضْهَرلو مْلاك الرَب واقَف على يْمين مَدبَح البْخور، ");
INSERT INTO arq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","وكي شافو زَكَريّا نَخلَع وخاف. ");
INSERT INTO arq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","قاللو المْلاك: \"ما تْخافش يا زَكَريّا خاطَر الله سْتَجاب لصْلاتَك، ومَرتَك أليصابات رايحة تَولَدلَك وْلَد وتْسَمّيه يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","يْجيبلَك الفَرح والسَعد، وبَزّاف اللي يَفَّرحو بزْيادتو، ");
INSERT INTO arq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","خاطَر يْكون كْبير قُدّام الرَب، ما يَشرَب لا شْراب لا حاجة تْسَكَّر، ويَتعَمَّر بالروح القُدّوس وهُوَ مازالو في كَرش يَمّاه، ");
INSERT INTO arq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ويْرَجَّع بَزّاف من وْلاد إسرائيل للرَب إلَههُم، ");
INSERT INTO arq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","يَمشي قُدّام الرَب بروح وقُدرة النَبي إلِيّا، باش يَرَجَّع قْلوب الوالدين لوْلادهُم والعاصيين لعْقَل الصالحين، باش يْهَيّي للرَب شَعب واجَد\". ");
INSERT INTO arq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","قال زَكَريّا للمْلاك: \"كيفاش نَعرَف باللي يَصرا هاد الشي؟ خاطَر أنا شيخ ومَرتي كْبيرة فالعْمَر\"، ");
INSERT INTO arq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","جاوَب المْلاك وقاللو: \"أنا جَبرائيل الواقَف قُدّام الله، جيت مَبعوت باش نْكَلّمَك ونْجيبلَك هاد البْشايَر، ");
INSERT INTO arq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","رايَح تْتْبَكَّم، وما تَقدَرش تَهدَر حَتّى لليوم اللي يَصراو فيه هاد الحاجات خاطَر ما آمَنتش كْلامي اللي رايَح يَتحَقَّق في وَقتو.\" ");
INSERT INTO arq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","والشَعب كان يَستَنّا في زَكَريّا، وحارو كي بْطا فالمَعبَد. ");
INSERT INTO arq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","كي خْرَج، ما كانش قادَر يَهدَر مْعاهُم، وفَهمو باللي شاف رُؤيا فالمَقدَس، وهُوَ كان يْديرلهُم فالإشارات وبْقا مْبَكَّم. ");
INSERT INTO arq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","وكي خْلاصو يامات خَدَّمتو وَلاّ لدارو. ");
INSERT INTO arq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","بَعد هَدوك اليامات، رَفدَت أليصابات مَرتو الجوف وتْخَبّات خَمس شْهور وقالَت: ");
INSERT INTO arq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","\"هَكدا دارلي الرَب نْهار شاف لِيَّ باش يْنَحّي عاري ما بين الناس\" ");
INSERT INTO arq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","وكي كانَت في شْهَرها السادَس، بْعَت الرَب المْلاك جَبرائيل لواحَد المْدينة من الجْليل واسَمها الناصرة، ");
INSERT INTO arq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","عَند واحَد العاتَق مَخطوبة لراجَل من دار داوَد واسمو يوسَف. وآسَم العاتَق مَريَم. ");
INSERT INTO arq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","دْخَل ليها المْلاك وقال: \"السْلام ليك يا اللي الرَب نْعَم عليك، الرَب مْعاك.\" ");
INSERT INTO arq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","تْفَرفشَت من كْلامو وبْقات تْخَمَّم واش يْكون المَعنى مْتاع هاد السْلام. ");
INSERT INTO arq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","قالَلها المْلاك: \"ما تْخافيش يا مَريَم خاطَر راكي لْقيتي نَعمة عَند الرَب، ");
INSERT INTO arq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","رايْحة تَرَّفدي الجوف وتَوَّلدي وْلَد وتْسَمّيه يَسوع، ");
INSERT INTO arq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","هاد الوْلَد يْكون كْبير ويْسَمّيوَه بْن العالي، ويَعطيلو الرَب الإلَه عَرش داوَد باباه، ");
INSERT INTO arq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ويَملَك على دار يَعقوب للدْوام وما يْكونش للمَلك مْتاعو حَد\". ");
INSERT INTO arq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","قالَت مَريَم للمْلاك: \"كيفاش يْصير هاد الشي وأنا ما تْدَنّا لِيَّ حَتّى راجَل؟\" ");
INSERT INTO arq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","جاوَب المْلاك وقالَلها: \"يْجي عليك الروح القُدّوس وقُدرة العالي تْضَلَّل عليك، وعلى هَدا القُدّوس اللي يْزيد عَندَك يَتسَمّا بْن الله، ");
INSERT INTO arq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","وهاي أليصابات اللي تْكونلَك هِيَ تاني راهي رَفدَت الجوف بوْلَد في كْبُرها، واللي تْسَمّات عاڤرة راهي في شْهَرها السادَس، ");
INSERT INTO arq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","خاطَر حاجة ماهي مُحال عَند الله\". ");
INSERT INTO arq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","قالَت مَريَم: \"هاني أنا خْديمة الرَب، واللي قُلتو هَداك هُوَ اللي يْصيرلي\". وراح المْلاك من عَندها. ");
INSERT INTO arq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","في هَدوك اليامات، ناضَت مَريَم وراحَت بالخَف للجْبال، لواحَد المْدينة في يَهودا، ");
INSERT INTO arq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ودَخلَت لدار زَكَريّا، وسَلّمَت على أليصابات. ");
INSERT INTO arq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","كي سَمعَت أليصابات سْلام مَريَم، نَڤَّز الصْغير في كَرشها وتْعَمّرَت بالروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","وعَيّطَت بالزور: \"مْباركة أنتِ ما بين النْسا ومْبارَك الصْغير اللي يْزيد من كَرشَك، ");
INSERT INTO arq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","كيفاش حَتّى نَلت باش تْجيني يَمّاة رَبّي؟ ");
INSERT INTO arq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","كي جا صوت سْلامَك في وَدنيَّ، نَڤَّز الصْغير من الفَرحة في كَرشي. ");
INSERT INTO arq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","يا سَعدها اللي آمنَت خاطَر رايَح يَصرا كامَل واش تْقالَلها من عَند الرَب\". ");
INSERT INTO arq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","وقالَت مَريَم: ");
INSERT INTO arq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","\"نَفسي تْعَضَّم الرَب، وروحي تَفرَح بالله اللي يْسَلَّكني، ");
INSERT INTO arq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","خاطَر شاف لضَعف خْديمتو. ومن دُرك كامَل الجْيال يْقولو يا سَعدها. ");
INSERT INTO arq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","خاطَر القَادر دارلي حاجات كْبار، قُدّوس آسمو، ");
INSERT INTO arq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ورَحَّمتو للي يْخافوه من جيل لجيل. ");
INSERT INTO arq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","بَيَّن قُوّة دْراعو، زَربَع اللي عندهُم في قْلوبهُم تَخمام المَتكَبّرين، ");
INSERT INTO arq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","نَزَّل الحُكّام من عْروشهُم ورْفَع المَتواضعين، ");
INSERT INTO arq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","فَيَّض الخير على الجيعانين، ورَد المْرَفّهين بيَدّيهُم فارغين، ");
INSERT INTO arq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","سَلَّك إسرائيل خْديمو وتْفَكَّر رَحَّمتو، ");
INSERT INTO arq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","لإبراهيم ودَريّتو للدْوام، كيما قال لجْدودنا\". ");
INSERT INTO arq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","قَعدَت مَريَم واحَد التَلت شْهور عَند أَليصابات أومبَعد وَلاّت لدارها. ");
INSERT INTO arq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","وْصَل وَقت أَليصابات باش تْزَيَّد وجابَت وْلَد. ");
INSERT INTO arq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","سَمعو جيرانها ومْواليها باللي رَبّي فَيَّض عليها رَحَّمتو وفَرحو معاها. ");
INSERT INTO arq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","فاليوم التامَن جاو باش يْخَتّنو الصْغير وحَبّو يْسَمّيوَه \"زَكَريّا\" على آسَم باباه، ");
INSERT INTO arq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","بَصَّح جاوبَت يَمّاه وقالَت: \"لالا، يَتسَمّا يوحَنّا.\" ");
INSERT INTO arq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","قالولها: \"واحَد من مْواليك ما تْسَمٌّا بهاد الآسَم\"، ");
INSERT INTO arq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","سَقساو باباه بالإشارات كيفاش حَب الوْلَد يَتسَمّا، ");
INSERT INTO arq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","طْلَب لوحة وكْتَب يْقول: \"يَتسَمّا يوحَنّا\"، وكامَل نْدَهشو. ");
INSERT INTO arq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","تَم تَم، نْحَل فَمّو وتْسَرَّح لْسانو وتْكَلَّم وبارَك الله. ");
INSERT INTO arq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","طاح الخوف على كامَل جيرانهُم، ووْصَل هاد الشي لكامَل جْبال اليَهودِيّة. ");
INSERT INTO arq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","وكامَل اللي سَمعو بهاد الشي خَلاّوَه في قْلوبهُم وقالو: \"يا دْرا واش رايَح يْوَلّي هاد الوْلَد\"، وكانَت قُدرة الرَب معاه. ");
INSERT INTO arq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","تْعَمَّر زَكَريّا باباه بالروح القُدّوس وتْنَبَّأ وقال: ");
INSERT INTO arq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"مْبارَك الرَب إلَه إسرائيل خاطَر فاقَد شَعبو وفْداه، ");
INSERT INTO arq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","دارَلنا سَلاّك كْبير في دار داوَد خْديمو، ");
INSERT INTO arq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","على حْساب كْلامو اللي قالوهُلنا الأنبيا القَدّيسين مْتاع زْمان: ");
INSERT INTO arq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","سْلاك من عَدياننا ومن يَد كامَل اللي يَكَّرهونا. ");
INSERT INTO arq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","هَكدا بَيَّن رَبّي رَحَّمتو لجْدودنا وتْفَكَّر عَهدو المْقَدَّس، ");
INSERT INTO arq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","على حْساب اليْمين اللي حْلَف بيه لجَدنا إبراهيم، ");
INSERT INTO arq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","بَعدما يْسَلَّكنا من يَد عَدياننا، نَقَّدرو نَعَّبدوه بلا خوف، ");
INSERT INTO arq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ماشيين قُدّامو فالقَداسة والصْلاح طول حْياتنا. ");
INSERT INTO arq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","وأنتَ يا وْلَد، رايَح تَتسَمَّا نَبي العالي، خاطَر تْسير قُدّام الرَب باش تْوَجَّد طُرقانو، ");
INSERT INTO arq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","باش تْعَلَّم شَعبو باللي السْلاك يْكون بغُفران دْنوبهُم، ");
INSERT INTO arq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","على جال حْنان الرَحمة مْتاع إلَهنا اللي فاقَدنا بيها النور اللي شْرَق علينا من الفوق، ");
INSERT INTO arq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","باش يْضَوّي على اللي راهُم قاعدين فالضَلمة وضَل الموت، باش يَهدي خَطوَتنا لطْريق السْلام\". ");
INSERT INTO arq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","والصْغبر كان يَكبَر ويَتقَوّا بالروح وبْقا فالخْلا حَتّى لليوم اللي بان فيه لبْني إسرائيل. ");
INSERT INTO arq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","في هَدوك اليامات، خْرَج آمَر من عند أَغُسْطُسُ قَيصَر باش يَندار الحْساب مْتاع كامَل ناس الأَرض. ");
INSERT INTO arq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","هاد الحْساب الأوَّل نْدار كي كان كيرينيوس حاكَم في سورية، ");
INSERT INTO arq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","والناس كامَل راحو باش يَتسَجّلو، كُل واحَد في مْدينتو. ");
INSERT INTO arq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","يوسَف تاني طْلَع من الجْليل، من مْدينة الناصرة لمْدينة داوَد اللي يْسَمّيوها بيت لَحم فاليَهوديّة، خاطَر هُوَ من سْلالة داوَد ومن الدشرة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","باش يَتسَجَّل مع مَريَم خْطيبتو اللي كانَت بالجوف. ");
INSERT INTO arq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","كي كانو تَمّة، وْصَل وَقتها باش تَولَد، ");
INSERT INTO arq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","وزَيّدَت وْليدها البْكَر وقَمّطاتو وحَطّاتو فالمَدوَد خاطَر ما لْقاوش مْكان فالفَندَق. ");
INSERT INTO arq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","في هَداك المْكان كانو كاينين رَعيان عايشين فالأَحواش وكانو يَسَّهرو الليل يْعَسّو على غْنَمهُم، ");
INSERT INTO arq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","وهاو وين وْقَفَّلهُم مْلاك من الرَب ومَجد الرَب ضَوّا عليهُم وخافو بَزّاف. ");
INSERT INTO arq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","بَصَّح المْلاك قالَلهُم: \"ما تْخافوش، خاطَر راني نْخَبَّركُم ببْشارة، تْكون فَرحة كْبيرة لكامَل الشَعب، ");
INSERT INTO arq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","اليوم زاد عَندكُم في مْدينة داوَد سَلاّك هُوَ المَسيح، الرَب، ");
INSERT INTO arq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","وهَدي هيَ المارة: تَلقاو وْلِيَّد مْقَمَّط وراقَد في مَدوَد.\" ");
INSERT INTO arq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","وتَم تَم، ضَهرَت مع المْلاك جْماعة كْبيرة من عْساكَر السْما يْسَبّحو الله ويْقولو: ");
INSERT INTO arq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"المَجد لله فالعْلالي، السْلام على الأرض للناس العْزاز عليه\". ");
INSERT INTO arq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","وبَعدما راحو من عَندهُم المَلايكة للسْما قالو الرَعيان لبَعضهُم بَعض: \"هَيّاو نْروحو لبيت لَحم نْشوفو هاد الشي اللي صْرا واللي خَبَّرنا بيه الرَب\". ");
INSERT INTO arq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","جاو بالخَف ولْقاو مَريَم ويوسَف والوْلِيَّد راقَد فالمَدوَد. ");
INSERT INTO arq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","كي شافوه عاودو الكْلام اللي تْقالَلهُم على هاد الوْلَد، ");
INSERT INTO arq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","وكامَل اللي سَمعو سْتَعجبو من الشي اللي قالوهولهُم الرَعيان. ");
INSERT INTO arq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","مَريَم من جيهَتها، كانَت تَحفَض كامَل هاد الحاجات وتْخَمَّم فيهُم في قَلبها. ");
INSERT INTO arq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","أومبَعد، رَجعو الرَعيان وهومَ يْعَضمو ويْسَبّحو فالرَب على كامَل الشي اللي سَمعوه وشافوه واللي كان كيما تْقالَلهُم. ");
INSERT INTO arq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","كي جازو تَمن أيّام باش يْخَتّنو الصْغير سَمّاوَه يَسوع كيما سَمّاه المْلاك قْبَل ما تَرفَد بيه يَمّاه الجوف. ");
INSERT INTO arq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","وكي جازو يامات النْفاس على حْساب شَريعة موسى، طَلعو بيه لأورشَليم باش يْقَدّموه للرَب، ");
INSERT INTO arq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","على حْساب واش مَكتوب في شَريعة الرَب باللي كُل دْكَر بْكَر يَتكَرَّس للرَب، ");
INSERT INTO arq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","وباش يْقَدّمو ضْحيّة على حْساب ما تْقال في شَريعة الرَب: زوج يْمامات ولاّ زوج فْراخ حْمام. ");
INSERT INTO arq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","كان واحَد الراجَل في أورشَليم واسمو سَمعان وهاد الراجَل كان صالَح وتَقي يَستَنّا عْزا إسرائيل والروح القُدّوس كان عليه، ");
INSERT INTO arq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","وكان الروح القُدّوس وْحالو فالمْنام باللي ما يْموتش حَتّى يْشوف مَسيح الرَب. ");
INSERT INTO arq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","أدّاه الروح للمَعبَد وكي مْوالين الصْغير يَسوع جابوه باش يْديرولو على حْساب عْوايَد الشَريعة، ");
INSERT INTO arq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","رَفدو في دْراعتيه وبارَك الله وقال: ");
INSERT INTO arq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"دُرك يا سيدي تْخَلّي عَبدَك يْروح هاني على حْساب كْلامَك، ");
INSERT INTO arq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","خاطَر عينِيَّ شافو سْلاكَك، ");
INSERT INTO arq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","اللي وَجَّدتو لكامَل الشْعوب، ");
INSERT INTO arq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","نور يَهدي الأُمّات وشان لشَعبَك إسرائيل\". ");
INSERT INTO arq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","وكان باباة ويَمّاة يَسوع يَستَعجبو من الكْلام اللي يَتقال عليه. ");
INSERT INTO arq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","بارَكهُم سَمعان وقال لمَريَم يَمّاة يَسوع: \"هاد الصْغير رايَح يْكون السَبّة باش يْطيحو بَزّاف ويْنوضو بَزاف في إسرائيل ويْكون مارة يَتخالفو عليها الناس، ");
INSERT INTO arq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","وأنتِ، سيف يْجوز في نَفسَك باش يَنكَشفو فْكايَر قْلوب بَزّاف.\" ");
INSERT INTO arq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","وكانَت واحَد النَبيّة واسَمها حَنّة، بَنت فَنوئيل، من دَشرة أشير، كانَت كْبيرة فالعْمَر، عاشَت مع راجلها بَعدما كانَت عاتَق سَبع سْنين، ");
INSERT INTO arq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","وتْهَجّلَت. كان في عْمَرها رَبعة وتْمانيين سْنة وما كانَتش تْفارَق المَعبَد وهِيَ تَعبَد ليل ونْهار بالصْيام والصْلاة. ");
INSERT INTO arq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ووَصلَت هِيَ تاني في هَديك الساعة، وكانَت تْسَبَّح الله وتَهدَر على يَسوع لكامَل اللي كانو يَستَنّاو سْلاك أورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","كي كَمَّل يوسَف ومَريَم كُل شي على حْساب شَريعة الرَب، رَجعو للجْليل، لمْدينَتهُم الناصرة. ");
INSERT INTO arq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","الوْلَد كان يَكبَر ويَتقَوّا، ويْزيد فالعْقَل ونَعمة الله كانَت عليه. ");
INSERT INTO arq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","كانو مْوالين يَسوع يْروحو كُل عام لأورشَليم في عيد الفَصح، ");
INSERT INTO arq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","وكي كان في عَمرو طْناشن سْنة، طَلعو لأورشَليم كي العادة فالعيد. ");
INSERT INTO arq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","بَعدما كَمّلو يامات العيد رَجعو، وبْقا الوْلَد يَسوع في أورشَليم ومْواليه مافاقوش. ");
INSERT INTO arq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","كانو حاسبينو مع الناس اللي سافرو معاهُم، وبَعدما مْشاو قيس يوم كامَل، بْداو يْحَوّسو عليه عَند مْواليهُم ومْعارَفهُم، ");
INSERT INTO arq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","وكي ما لْقاوَهش، رَجعو لأورشَليم يْحَوّسو عليه. ");
INSERT INTO arq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","وبَعد تَلت أيّام، لْقاوَه فالمَعبَد قاعَد في وَسط الشْيوخ يَسمَعَّلهُم ويْسَقسيهُم. ");
INSERT INTO arq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","كامَل اللي سَمعوه، سْتَعجبو في فْهامتو ووْجابو. ");
INSERT INTO arq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","وكي شافوه مْواليه نْدَهشو، وقالَتلو يَمّاه: \"يا وْليدي، وَعلاش دَرت هَكدا معانا؟ أنا وباباك بْقينا نْحَوّسو عليك وحْنا مْقَلّقين\"، ");
INSERT INTO arq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","جاوَبهُم: \"وَعلاش كُنتو تْحَوّسو عليَّ؟ ما راكُمش عارفين باللي لازَمني نَستَكلَف بالشي مْتاع بابا؟\" ");
INSERT INTO arq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","بَصَّح ما فَهموش الكْلام اللي قالهولهُم. ");
INSERT INTO arq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","أومبَعد، هْبَط معاهُم وجا للناصرة، وكان ياخُدلهُم الراي. يَمّاه كانَت تْخَبّي كامَل هاد الشي في قَلبها، ");
INSERT INTO arq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ويَسوع كان يْزيد فالعْقَل والقَد والنَعمة عَند الله وعَند الناس. ");
INSERT INTO arq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","فالعام الخْمَسطاش من مَلك طيباريوس قَيصَر، كي كان بيلاطَس البُنطي والي على اليَهوديّة، وهيرودَس حاكَم رُبع على الجْليل، وفيلِبُس خوه حاكَم رُبع على إيطورية وأرض تْراخونيس، وليسانيوس حاكَم رُبع على الأبليّة، ");
INSERT INTO arq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","في زْمان رِيّاس رْجال الدين حَنّان وقْيافا، كَلَّم الله يُوحَنّا بَن زَكَريّا فالخْلا. ");
INSERT INTO arq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","وجا يوحَنّا لكامَل الجْوايَه اللي دايرين بواد الأُردُن يْبَرَّح بمَعموديّة التوبة لغُفران الدْنوب، ");
INSERT INTO arq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","على حْساب واش مَكتوب في كْتاب كْلام إشعِيا النَبي: \"صوت اللي يْعَيَّط فالخْلا، وَجّدو طْريق الرَب ورَدّو طُرقانو مْسَلّسين، ");
INSERT INTO arq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","كُل واد يَتعَمَّر، وكُل جْبَل وكُل كُدية يْوَلّيو نازلين، المْعَوَّج يَتسَڤَّم، والطُرقان المْحَجرسين يْوَلّيو مْسَتويّين، ");
INSERT INTO arq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","وكُل بْنادَم يْشوف سْلاك الله.\" ");
INSERT INTO arq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","وكان يْقول للي كانو يْجيو في غاشي يَتعَمّدو عَندو: \"يا زَرّيعة اللْفاعي، شْكون وَرّالكُم تَهَّربو من الزْعاف اللي جاي؟ ");
INSERT INTO arq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","أعَّملو الشي اللي يْليق بالتوبة، وما تَبداوش تْقولو في قْلوبكُم: \"عَندنا بابانا إبراهيم\"، خاطَر نْقولَلكُم باللي الله يَقدَر من هاد الحْجَر يْخَرَّج وْلاد لإبراهيم. ");
INSERT INTO arq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","دُرك، الفاس راهو نْحَط على عْروق السْجَر، وكُل سَجرة ما تْجيبش غَلّة مْليحة تْنَقطَع وتَتَّرما فالنار\". ");
INSERT INTO arq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","كان الغاشي يْسَقسيه: \"هِمّالا، واش لازَم نْديرو؟\" ");
INSERT INTO arq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","جاوَب وقالَلهُم: \"اللي عَندو زوج كَسوات، يَعطي للي ما عَندوش، واللي عَندو ماكلة، كيف كيف.\" ");
INSERT INTO arq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","جاو تاني المَكّاسين باش يَتعَمّدو وقالولو: \"شيخ، واش لازَم نْديرو؟\" ");
INSERT INTO arq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","قالَلهُم: \"ما تَطّلبوش كْتَر من الشي اللي مَفروض عليكم\"، ");
INSERT INTO arq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","العَسكَر تاني كانو يْسَقسيوَه: \"وواش لازَم نْديرو حْنا تاني؟\" قالَلهُم: \"ما تَضَّلمو حَتّى واحَد وما تَتَّهمو بالزور حَتّى واحَد وأقَّنعو بشَهرٍيّاتكُم\". ");
INSERT INTO arq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","وكي كان الشَعب يَستَنّا وكامَل يْخَمّمو في قْلوبهُم وَلاّ يوحَنّا ماشي هُوَ المَسيح، ");
INSERT INTO arq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","جاوَب يوحَنّا وقالَلهُم كامَل: \"أنا نْعَمَّدكُم بالما، بَصَّح يْجي اللي قْوي عْلِيَّ، واللي ما نَستاهَلش نْحَل حَتّى خْيوط سَبّاطو. هُوَ يْعَمَّدكُم فالروح القُدّوس والنار، ");
INSERT INTO arq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","في يَدّو مَدرة، باش يْنَقّي مْليح النادَر مْتاعو ويْلَم القَمح فالمَخزَن مْتاعو، بَصَّح التْبَن يَحَّرقو بنار ما تَطفاش\". ");
INSERT INTO arq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","هَكدا وبحاجات واحَدُخرين بَزّاف كان يوحَنّا يْسَجَّع الشَعب ويْبَشّرو. ");
INSERT INTO arq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","بَصَّح هيرودَس حاكَم الرُبع كي لامو يوحَنّا على جال هيرودِيّا مَرت فيلبس خوه وعلى كامَل الشَر اللي كان يْديرو، ");
INSERT INTO arq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","زاد على كُل هاد الشي كي دَخَّل يوحَنّا للحَبس. ");
INSERT INTO arq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","كي كان الشَعب كامَل يَتعَمَّد، تْعَمَّد يَسوع هُوَ تاني، وكي كان يْصَلّي نْحَلَّت السْما، ");
INSERT INTO arq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ونْزَل عليه الروح القُدّوس في صِفة دات كي الحْمامة، وجا صوت من السْما: \"أنتَ وْليدي الحْبيب، فيك فَرحتي\". ");
INSERT INTO arq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","كي بْدا يَسوع الخَدمة كان في عَمرو واحَد التْلاتين سْنة وكان على حْساب واش مَعروف عليه وْليد يوسَف بَن هالي، ");
INSERT INTO arq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","بَن مَتتات بَن لاوي، بَن مَلكي، بَن يَنّا، بَن يوسَف، ");
INSERT INTO arq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","بَن مَتّاتيا، بَن عاموص، بَن ناحوم، بَن حَسلي، بَن نَجّاي، ");
INSERT INTO arq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","بَن مَآت، بَن مَتّاتيا، بَن شِمعي، بَن يوسَف، بَن يَهودا، ");
INSERT INTO arq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","بَن يوحنّا، بَن ريسا، بَن زَرُبّابِل، بَن شَألتِئيل، بَن نيري، ");
INSERT INTO arq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","بَن مَلكي، بَن أدّي، بَن قُصَم، بَن ألمودام، بَن عير، ");
INSERT INTO arq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","بَن يوسي، بَن أليعازَر، بَن يوريم، بَن مَتتات، بَن لاوي، ");
INSERT INTO arq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","بَن شِمعون، بَن يَهودا، بَن يوسَف، بَن يونان، بَن ألياقيم، ");
INSERT INTO arq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","بَن مَليا، بن مينان، بَن مَتّاتا، بَن ناتان، بَن داوَد، ");
INSERT INTO arq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","بَن يَسّى، بَن عوبيد، بَن بوعَز، بَن سَلمون، بَن نَحشون، ");
INSERT INTO arq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","بَن عَمّيناداب، بَن أرام، بَن حَصرون، بَن فارِص، بَن يَهودا، ");
INSERT INTO arq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","بَن يَعقوب، بَن إسحاق، بَن إبراهيم، بَن تارَح، بَن ناحور، ");
INSERT INTO arq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","بَن سَروج، بَن رَعو، بَن فالَج، بَن عابَر، بَن شالَح، ");
INSERT INTO arq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","بَن قينان، بَن أرفَكشاد، بَن سام، بَن نوح، بَن لامَك، ");
INSERT INTO arq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","بَن مَتوشالَح، بَن أخنوخ، بَن يارَد، بَن مَهلَلئيل، بَن قينان، ");
INSERT INTO arq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","بَن أنوش، بَن شيت، بَن آدَم، بْن الله. ");
INSERT INTO arq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","رْجَع يَسوع من واد الأُردُن مْعَمَّر بالروح القُدّوس، وڤَوّدو الروح فالخْلا، ");
INSERT INTO arq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","وين بْقا إبليس يْجَرَّب فيه مُدّة رَبعين يوم. ما كْلا والو في هَدوك اليامات وكي جازو جاع. ");
INSERT INTO arq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","قاللو إبليس: \"إيلا راك بْن الله قول لهاد الحَجرة تْوَلّي خُبز\"، ");
INSERT INTO arq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","جاوَبو يَسوع: \"مَكتوب: \"ماشي بالخُبز وَحدو يَحيا الإنسان\"\". ");
INSERT INTO arq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","أومبَعد طَلّعو إبليس لمْكان عالي ووَرّالو في رَمشة عين كامَل مَملَكات الدَنيا، ");
INSERT INTO arq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","وقاللو: \"نَعطيلَك هاد السيطَرة كامَل وشان هاد المَملَكات خاطَر عْطاوهولي وأنا نَعطيه ليمَن نْحَب، ");
INSERT INTO arq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","لو كان تَسجَدلي يْكونو كامَل ليك\". ");
INSERT INTO arq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","جاوَب يَسوع وقاللو: \"مَكتوب : تَسجد للرَب إلَهَك وتَعَّبدو غير هُوَ\". ");
INSERT INTO arq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ڤَوّدو لأورشَليم ووَقّفو على حَرف سْطَح المَعبَد وقاللو: \"وَلاّ كُنت بْن الله أرمي روحَك من هْنا للتَحت، ");
INSERT INTO arq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","خاطَر مَكتوب: \"يْوَصّي المَلايكة مْتاعو عليك باش يَحَّفضوك\"، ");
INSERT INTO arq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ومَكتوب تاني: \"على يَدّيهُم يَرَّفدوك باش ما تَزدَمش رَجلَك في حَجرة\"\". ");
INSERT INTO arq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","جاوَب يَسوع وقاللو: \"تْقال: \"ما تْجَرَّبش الرَب إلَهَك\". ");
INSERT INTO arq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","كي كَمَّل إبليس يْجَرَّب فيه بكامَل هاد الحاجات بَعَّد عليه حَتّى لوَقت آخَر. ");
INSERT INTO arq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ورْجَع يَسوع بقُوّة الروح للجْليل، وشاع عليه الخْبَر فالجيهة كامَل، ");
INSERT INTO arq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","وكان يْدَرَّس في مْجامَعهُم، عاجَبهُم كامَل. ");
INSERT INTO arq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","أومبَعد جا للناصرة وين تْرَبّا، ودْخَل كي عادتو نْهار السَبت للمَجمَع، وناض باش يَقرا. ");
INSERT INTO arq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","عْطاولو كْتاب النَبي إشعِيا وكي حَل الكْتاب، طاح وين مَكتوب: ");
INSERT INTO arq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"روح الرَب علِيَّ، خاطَر دْهَنني باش نْبَشَّر الڤْلالين، بْعَتني باش نْبَرَّح للمَحبوسين بالسْراح وللعَميين بالشوفة، نَطلَق سْراح المغبونين، ");
INSERT INTO arq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ونْبَرَّح بعام النَعمة من عَند الرَب\". ");
INSERT INTO arq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","أومبَعد طْوا الكْتاب وعْطاه للخَدّام وقْعَد. وكامَل اللي كانو فالمَجمَع بْقاو يَخُّزرو فيه. ");
INSERT INTO arq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","هِمّالا بْدا يْقولَلهُم: \"اليوم هاد الكْلام المَكتوب اللي سْمَعتوه راه تْحَقَّق\". ");
INSERT INTO arq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","وكانو كامَل يَشَّهدولو وهومَ مَستَعجبين من كْلام النَعمة اللي كان يُخرَج من فَمّو، ويْقولو: \"هَدا ماشي وْليد يوسَف؟\" ");
INSERT INTO arq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","قالَلهُم: \"بْلا شَك رايحين تْقولولي هاد المْتل: \"يا طْبيب داوي روحَك، ودير هْنا في بْلادَك الشي اللي سْمَعنا باللي دَرتو في كَفرناحوم\"\". ");
INSERT INTO arq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","قال: \"نْقولَلكُم الصَح، حَتّى نَبي ماهو مَقبول في بْلادو، ");
INSERT INTO arq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ونْقولَلكُم، كانو كاينين هَجّالات بَزّاف في إسرائيل في زْمان إيلِيّا كي نْغَلقَت السْما تَلت سْنين وسَت شْهور، كي جات مَجاعة كْبيرة في كامَل الأرض، ");
INSERT INTO arq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","وما أتَّبعَت إيليّا لحَتّى واحدة مَنهُم من غير الهَجّالة اللي في صَرفة صيدا. ");
INSERT INTO arq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","وكانو كاينين بَزّاف اللي عَندهُم البْرَص في إسرائيل في زْمان أليشَع النَبي وواحَد فيهُم ما طْهَر من غير نَعمان السوري\". ");
INSERT INTO arq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","تْغَششو كامَل اللي كانو فالمَجمَع كي سَمعو هاد الشي، ");
INSERT INTO arq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","وناضو وخَرّجو يَسوع من المْدينة وأدّاوَه لحَرف الجْبَل اللي كانَت مْدينَتهُم مَبنيّة عليه باش يَرميوَه للتَحت، ");
INSERT INTO arq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","بَصَّح هُوَ جاز في وَسطهُم وراح. ");
INSERT INTO arq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","وهْبَط لكَفرَناحوم، مْدينة من الجْليل وكان يْدَرَّسهُم فالسَبت. ");
INSERT INTO arq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","وكانو مَدهوشين فالتَعليم مْتاعو خاطَر كْلامو كانَت فيه الهيبة. ");
INSERT INTO arq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","وكان فالمَجمَع واحَد الراجَل مَسكون بروح شيطان ناجَس. هاد الراجَل عَيَّط بالزور: ");
INSERT INTO arq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"آه، واش بيننا وبينَك يا يَسوع الناصري؟ جيت باش تْضَيَّعنا؟ نَعَّرفَك شْكون أنتَ، أنتَ قُدُّوس الله\"، ");
INSERT INTO arq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","زْڤا عليه يَسوع وقال: \"أسكُت وأخرُج من هاد الراجَل\". رْما الشيطان الراجَل اللي كان ساكَن فيه في وَسط الغاشي وخْرَج مَنّو بلا ما يْضَرّو. ");
INSERT INTO arq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","طاح الخوف على الناس كامَل وبْداو يْقولو لبَعضهُم بَعض: \"واش هاد الكَلمة اللي بهاد الهيبة وهاد القُدرة؟ يامَر الأرواح الناجسين ويَخُّرجو.\" ");
INSERT INTO arq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","وشاع الخْبَر على يَسوع في كُل مْكان في هَدوك الجْوايَه. ");
INSERT INTO arq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","كي ناض من المَجمَع، راح لدار سَمعان، وكانَت نْسيبة سَمعان بحَمّة قْويّة بَزّاف، وطَلبو مَنّو باش كاش ما يْديرلها. ");
INSERT INTO arq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","طَل عليها وغير هَدّد الحَمّة راحَت عليها، وتَم تَم ناضَت وبْدات تَخدَمهُم. ");
INSERT INTO arq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","وكي غَربَت الشَمس، كامَل اللي كانو عَندهُم ناس مْراض كُل واحَد باش، جابوهُملو وحَط يَدّيه على كُل واحَد فيهُم وشْفاهُم، ");
INSERT INTO arq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","وكانو الشْياطَن تاني يَخُّرجو من ناس بَزّاف وهومَ يْعَيٌطو ويْقولو: \"أنتَ بْن الله\". بَصَّح هُوَ كان يْهَدَّدهُم وما يْخَلّيهُمش يْقولو هاد الحاجات خاطَر كانو عارفين باللي هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","وكي طْلَع النْهار، خْرَج وراح لمَضرَب خالي. بْدا الغاشي يْحَوَّس عليه وجاو حَتّى لعَندو، حَكموه باش ما يْبَعَّدش عليهُم، ");
INSERT INTO arq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","بَصَّح قالَلهُم: \"لازَم عليَّ نْبَشَّر المْدايَن الأُخرين بمَلَكوت الله خاطَر على هاد الشي اللي نَبعَتت\". ");
INSERT INTO arq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","وكان يْبَرَّح في مْجامَع اليَهودِيّة. ");
INSERT INTO arq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","كان الغاشي يَتزادَم على يَسوع باش يَسمَع كَلمة الله، وكان هُوَ واقَف عَند واد جَنّيسارَت، ");
INSERT INTO arq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","وشاف زوج فْلايَك حابسين عَند الواد، الصِيّادين كانو خَرجو منهُم ويَغَّسلو فالشْبَك. ");
INSERT INTO arq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","طْلَع يَسوع في واحدة من الفْلايَك، اللي كانو مْتاع سَمعان وطْلَب منّو يْبَعَّد شْويّة على الشَط. أومبَعد قْعَد وبْدا يْدَرَّس فالغاشي من الفْلوكة. ");
INSERT INTO arq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","كي كَمَّل الهَدرة قال لسَمعان: \"أدَّنّا للغامَق وأرميو الشْبَك مْتاعكُم للصْيادة\"، ");
INSERT INTO arq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","جاوَب سَمعان وقال: \"سيدي، خْدَمنا ليل كامَل وما صَيَّدنا حَتّى حاجة، بَصَّح على كَلمتَك نَرمي الشْبَك.\" ");
INSERT INTO arq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","كي رْماوهُم، حَكمو حوت بَزّاف حَتّى قْريب تْقَطّعو الشْبَك مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","رَوّشو لصْحابهُم اللي كانو فالفْلوكة الأخرى باش يْجيو يْعاونوهُم، جاو وعَمّرو الفْلايَك في زوج حَتّى بْداو يَغَّرقو. ");
INSERT INTO arq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","كي شاف سَمعان بُطرُس هاد الشي، رْكَع عَند رْكايَب يَسوع وقاللو: \"رَبّي، بَعَّد علِيَّ خاطَر أنا إنسان خاطي\"، ");
INSERT INTO arq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","خاطَر حَكماتو الخُلعة هُوَ وكامَل اللي كانو معاه على جال الصْيادة اللي داروها. ");
INSERT INTO arq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","يَعقوب ويوحَنّا وْلاد زَبَدي اللي كانو شَركة مع سَمعان، هومَ تاني حَكمَتهُم الخُلعة. وقال يَسوع لسَمعان: \"ما تْخافش، من دُرك تْوَلّي تْصَيَّد الناس\". ");
INSERT INTO arq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","وكي رَجّعو الفْلايَك للشَط، خَلاّو كُل شي وتَبّعو يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","كي كان يَسوع في واحَد المْدينة، واحَد الراجَل مْعَمَّر بالبْرَص شافو، طاح ساجَد وطَلبو وقال: \"سيدي، لو كان تْحَب، تَقدَر تْرَدّني طاهَر\"، ");
INSERT INTO arq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","مَد يَسوع يَدّو، مَسّو وقال: \"نْحَب، أطهَر\"، وتَم تَم راح عليه البْرَص. ");
INSERT INTO arq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ووَصّاه يَسوع باش ما يْقول لحَتّى واحَد، بَصَّح قاللو: \"روح ووَرّي روحَك لراجَل الدين ومَد على طُهرَك اللي آمَر بيه موسى، شْهادة ليهُم\". ");
INSERT INTO arq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","شاع الكْلام عليه كْتَر وتْلَم عليه غاشي كْبير باش يَسَّمعو ويَبراو من مْراضهُم، ");
INSERT INTO arq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","بَصَّح هُوَ كان يَجبَد روحو لمْضارَب خاليين ويْصَلّي. ");
INSERT INTO arq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","مَرّة، كان يَسوع يْدَرَّس وكانو قاعدين تَمّة فَرّيسِيّين وشْيوخ شَريعة، جايّين من كُل دَشرة من الجْليل واليَهوديّة وأورشَليم. وكانَت قُدرة الرَب حاضرة باش تَشفي المَرضى على يَد يَسوع، ");
INSERT INTO arq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","وجاو رْجال رافدين فْراش عليه إنسان مَشلول وحَبّو يْدَخّلوه ويْحَطّوه قُدّام يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","وكي ما لْقاوش مْنين يْدَخّلوه على جال الغاشي، طَلعو فوق السْطَح ودَلاّوَه بفْراشو من واحَد التُقبة في وَسط الغاشي عَند يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","كي شاف يَسوع إيمانهُم قال: \"يا إنسان، دْنوبَك راهُم مَغفورين\". ");
INSERT INTO arq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","بْداو الكُتّاب والفَريسِيّين يْخَمّمو ويْقولو: \"شْكون هَدا اللي راه يَكفَر؟ شْكون اللي عَندو القُدرة باش يَغفَر الدْنوب من غير الله وَحدو؟\" ");
INSERT INTO arq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","عْرَف يَسوع تَخمامهُم، جاوَب وقالَلهُم: \"واش راكُم تَخَمّمو في قْلوبكُم؟ ");
INSERT INTO arq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","آما ساهَل باش يَتقال: \"دْنوبَك مَغفورين\" وَلاّ يَتقال: \"نوض وأمشي؟\" ");
INSERT INTO arq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","باش تَعَّرفو باللي بْن الإنسان عَندو القُدرة على الأرض باش يَغفَر الدْنوب\"، وقال للمَشلول: \"ليك نْقول: \"نوض، خود فْراشَك وروح لدارَك\"\". ");
INSERT INTO arq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","تَم تَم ناض الراجَل اللي كان مَشلول قُدّامهُم ورْفَد الفْراش اللي كان راقَد عليه وراح لدارو وهُوَ يْسَبَّح فالله. ");
INSERT INTO arq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","كامَل حارو وسَبّحو الله وخافو بَزّاف وقالو: \"اليوم شَفنا عَجايَب\". ");
INSERT INTO arq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","أومبَعد، بَعد هاد الشي، خْرَج يَسوع وشاف واحَد المَكّاس واسمو لاوي قاعَد وين يْخَلّصو الغْرامة وقاللو: \"تَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","خَلاّ المَكّاس كُل شي، ناض وتَبّعو. ");
INSERT INTO arq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","دارلو لاوي ضْيافة كْبيرة في دارو، وكانو معاه على الميدة مَكّاسين بَزّاف وناس واحَدُخرين. ");
INSERT INTO arq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","وبْداو الكُتّاب مْتاعهُم والفَريسِيّين يَشتكيو من التابعين مْتاع يَسوع ويْقولو: \"وَعلاش تاكلو وتَشَّربو مع المَكّاسين والخاطيين؟\" ");
INSERT INTO arq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","جاوَب يَسوع وقالَلهُم: \"ماشي اللي صْحاح اللي يَسَّحقو الطْبيب، المَرضى هومَ اللي يَسَّحقوه، ");
INSERT INTO arq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ما جيتش نْعَيَّط للصالحين، جيت نْعَيَّط للخاطيين باش يْتوبو\". ");
INSERT INTO arq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","وقالولو: \"تابعين يوحَنّا يْصومو بَزّاف ويْصَلّيو، تابعين الفَريسِيّين تاني، بَصَّح التابعين مْتاعك ياكلو ويَشَّربو؟\" ");
INSERT INTO arq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","قالَلهُم يَسوع: \"تَقَّدرو تْصَوّمو المَعروضين للعَرس ما دام العْريس معاهُم؟ ");
INSERT INTO arq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","يْجيو اليامات وين يَتَّرفَد من عَندهُم العْريس وداك الساع يْصومو في هَدوك اليامات\". ");
INSERT INTO arq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","وزاد قالَلهُم مْتَل: \"واحَد ما يْقَطَّع طَرف من لَبسة جْديدة ويْلَصّقو في لَبسة قْديمة خاطَر يْقَطَّع اللَبسة الجْديدة والطَرف اللي يَدّيه منها ما يْوالَمش فالقْديمة، ");
INSERT INTO arq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","وواحَد ما يْحَط شْراب جْديد في ڤَربات قْدَم، يْعود الشْراب الجْديد يْكَسَّر الڤَربات القْدَم ويَتدَفَّق الشْراب ويْضيعو الڤَربات، ");
INSERT INTO arq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","بَصَّح الشْراب الجْديد يَنحَط في ڤَربات جْدَد، ");
INSERT INTO arq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","وواحَد بَعدما يَشرَب القْديم ما يْحَوَّس على الجْديد خاطَر يْقول: \"القْديم مْليح\". ");
INSERT INTO arq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","في واحَد السَبت، كان يَسوع جايَز على واحَد الأحواش مْتاع القَمح، وكانو التابعين مْتاعو يْنَحّيو سْبول القَمح وياكلوهُم بَعد ما يْحَلّوهُم بيَدّيهُم. ");
INSERT INTO arq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","جْماعة من الفَريسِيّين قالولهُم: \"وَعلاش راكُم تْديرو الشي اللي ماشي جايَز فالسْبوت؟\" ");
INSERT INTO arq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","جاوَبهُم يَسوع وقال: \"ما قْريتوش واش دار داوَد كي جاع هُوَ واللي كانو معاه؟ ");
INSERT INTO arq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","كيفاش دْخَل لدار الله وأدّا الخُبز المْقَدَّس اللي تْجوز ماكَلتو غير لرْجال الدين وكْلا مَنّو هُوَ وعْطا لرْجالو؟\" ");
INSERT INTO arq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","وقالَلهُم: \"بْن الإنسان هُوَ رَب السَبت\". ");
INSERT INTO arq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","في سَبت وَحدآخُر دْخَل يَسوع للمَجمَع وبْدا يْدَرَّس، وكان تَمّة راجَل يَدّو اليْمنى مَشلولة. ");
INSERT INTO arq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","الكُتّاب والفَريسِيّين بْقاو يْڤَابرو في يَسوع باش يْشوفو ولا يْداوي فالسَبت باش يَلقاو باش يَتَّهموه. ");
INSERT INTO arq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","هُوَ كان يَعرَف تَخمامهُم وقال للراجَل اللي كانَت يَدّو مَشلولة: \"نوض وأوقَف فالوَسط\"، ناض الراجَل ووْقَف. ");
INSERT INTO arq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","وقالَلهُم يَسوع: \"نْسَقسيكُم: يْجوز فالسَبت باش يَندار الخير وَلاّ يَندار الشَر؟ الواحَد يْسَلَّك بْنادَم وَلاّ يْضَيّعو؟\" ");
INSERT INTO arq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","وشاف كامَل اللي كانو دايرين بيه وقال للراجَل: \"كَسَّل يَدَّك\"، دار الراجَل كيما قاللو يَسوع وبْرات يَدّو. ");
INSERT INTO arq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","كْلاهُم الزْعاف وبْداو يَتشاورو ما بيناتهُم واش يَقَّدرو يْديرو ليَسوع. ");
INSERT INTO arq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","في هَدوك اليامات، راح يَسوع للجْبَل باش يْصَلّي، وجَوَّز الليل كامَل فالصْلاة لله. ");
INSERT INTO arq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","كي طْلَع النْهار، عَيَّط للتابعين مْتاعو، وخَيَّر منهُم طْناش سَمّاهُم رُسُل. ");
INSERT INTO arq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","سَمعان اللي سَمّاه تاني بُطرُس وأندراوَس خوه، ويَعقوب ويوحَنّا، وفيلِبس وبَرتلَماوَس، ");
INSERT INTO arq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ومَتّى وتوما، ويَعقوب بَن حَلفى وسَمعان اللي يَسَمّيوَه الغَيّور، ");
INSERT INTO arq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","يَهودا بَن يَعقوب ويَهوداالإسخَريوطي اللي وَلاّ خايَن. ");
INSERT INTO arq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","وهْبَط معاهُم ووْقَف في مَضرَب نازَل هُوَ وجْماعة كْبيرة من التابعين مْتاعو وغاشي كْبير من شَعب اليَهوديّة كامَل وأورشَليم وشَط صور وصيدا، ");
INSERT INTO arq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","جاو باش يَسَّمعو ليَسوع ويَبراو من مْراضهُم، واللي كانو مْعَدبين بأرواح ناجسين بْراو، ");
INSERT INTO arq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","وكامَل الغاشي كانو يْحَوّسو يْمَسّوه خاطَر قُوّة كانَت تَخرُج مَنّو وتَشفيهُم كامَل. ");
INSERT INTO arq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","رْفَد يَسوع عينيه للتابعين مْتاعو وقال: \"يا سَعدكُم يا الڤْلالين خاطَر مَلَكوت الله مْتاعكُم، ");
INSERT INTO arq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","يا سَعدكُم يا اللي راكُم جيعانين خاطَر رايحين تَشَّبعو، يا سَعدكُم يا اللي راكُم تَبكيو خاطَر رايحين تَضَّحكو، ");
INSERT INTO arq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","يا سَعدكُم كي يَكَّرهوكُم الناس وكي يْحاوزوكُم ويْعايروكُم ويَنَّكرو آسَمكُم كي اللي مَنعول على جال بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","أفَّرحو في هَداك اليوم وأسَّعدو خاطَر آجَركُم كْبير فالسْما، خاطَر هَكدا كانو جْدودهُم يْديرو للأنبيا، ");
INSERT INTO arq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","بَصَّح يا ويلكُم يا المْرَفّهين خاطَر أدّيتو عْزاكُم، ");
INSERT INTO arq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","يا ويلكُم يا اللي راكُم شَبعانين خاطَر رايحين تْجوعو، يا ويلكُم يا اللي راكُم تَضَّحكُو خاطَر رايحين تَحَّزنو وتَبكيو، ");
INSERT INTO arq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","يا ويلكُم كي يَشَّكروكُم كامَل الناس خاطَر هَكدا كانو جْدودهُم يْديرو للأنبيا الكَدّابين. ");
INSERT INTO arq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","بَصَّح نْقولَلكُم أنتومَ يا اللي راكُم تَسَّمعو: \"حَبّو عَديانكُم وحاسنو اللي يَكَّرهوكُم، ");
INSERT INTO arq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","باركو اللي يَنَّعلوكُم وصَلّيو للي يْقَطّعو فيكُم، ");
INSERT INTO arq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","اللي يَضَّربَك على خَدَّك، زيد أعطيلو الخَد الآخُر تاني، واللي يَدّيلَك بَرنوسَك ما تَمَّنعوش باش يْزيد ياخُد ڤَندورتَك، ");
INSERT INTO arq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","اللي يَطَّلبَك أعطيلو، واللي يَدّيلَك حاجتَك ما تَطلَبهاش منّو، ");
INSERT INTO arq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","وكيما تْحَبّو يْديرولكُم الناس، ديرولهُم أنتومَ تاني. ");
INSERT INTO arq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","وَلاّ تْحَبّو غير اللي يْحَبّوكُم، واش من المْزيّة عَندكُم؟ الخاطيين تاني يْحَبّو اللي يْحَبّوهُم، ");
INSERT INTO arq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","وَلاّ تْحاسنو غير اللي يْحاسنوكُم، واش من المْزيّة عَندكُم؟ الخاطيين تاني يْديرو هَكدا، ");
INSERT INTO arq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","وَلاّ تْسَلّفو غير للي يْرَجَّعَلكُم واش من المْزيّة عَندكُم؟ الخاطيين تاني يْسَلّفو للخاطيين باش يْديرولهُم كيف كيف. ");
INSERT INTO arq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","بالعَكس، حَبّو عَديانكُم وحاسنو وسَلّفو بْلا ما تَستَنّاو حاجة. يْكون آجَركُم كْبير وتْكونو وْلاد العالي اللي يَنعَم على نَكّارين الخير والمَشرارين. ");
INSERT INTO arq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","كونو رُحَما كيما باباكُم تاني رْحيم. ");
INSERT INTO arq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ما تْحاسبوش باش ما تَتحاسبوش، ما تَحَّكموش باش ما يَتَّحكَمش عليكُم، أغَّفرو يَتَّغفَرَلكُم. ");
INSERT INTO arq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","مَدّو يَتمَدَّلكُم، تَتفَرَّغَلكُم في حْجَركُم كيلة مْليحة، مْعَمّرة، مَمخوضة وفايضة خاطَر يَتكَيَّلَلكُم بالكيل اللي تْكَيّلو بيه\". ");
INSERT INTO arq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","أومبَعد، زاد قالَلهُم مْتَل: \"يَقدَر عْمى يْڤَوَّد عْمى؟ ماشي يْطيحو في زوج في حُفرة؟ ");
INSERT INTO arq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","التابَع ماشي خير من الشيخ مْتاعو بَصَّح كُل واحَد يْكَمَّل التَعليم مْتاعو يْوَلّي كيما شيخو. ");
INSERT INTO arq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","كيفاش تْشوف التَخشة اللي في عين خوك والحَطبة اللي في عينك ما تْفيقَلهاش؟ ");
INSERT INTO arq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","كيفاش تَقدَر تْقول لخوك: \"خويَ، خَلّيني نْنَحّي التَخشة اللي في عينَك\"، وأنتَ ماشي شايَف الحَطبة اللي في عينَك؟ يا مُنافَق، نَحّي قْبَل الحَطبة اللي في عينَك وداك الوَقت تْشوف مْليح كيفاش باش تْخَرَّج التَخشة اللي في عين خوك. ");
INSERT INTO arq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","خاطَر حَتّى سَجرة مْليحة ما تْمَد غَلّة فاسدة وحَتّى سَجرة فاسدة ما تْمَد غَلّة مْليحة. ");
INSERT INTO arq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","خاطَر كُل سَجرة تْنَعرَف من غَلَّتها، ما يْنَحّيوش الكَرموس من الشوك وما يَقَّطفوش العْنَب من العَلاّيَڤ. ");
INSERT INTO arq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","الإنسان المْليح يْخَرَّج المْلاحة من كَنز قَلبو المْليح، والدوني يْخَرَّج الدوني من قَلبو الدوني خاطَر الفُم يَتكَلَّم على حْساب واش كايَن فالقَلب. ");
INSERT INTO arq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","وَعلاش تْعَيّطولي رَبّي، رَبّي وما تْديروش واش نْقول؟ ");
INSERT INTO arq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","كُل واحَد يْجي لعَندي ويَسمَع كْلامي ويَعمَل بيه، نْوَرّيلكُم ليمَن يْشَبَّه، ");
INSERT INTO arq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","يْشَبَّه لبْنادَم بْنا دار، حْفَر وعَمَّق ودار اللْساس على الحْجَر. كي جات الحَملة، حْمَل الواد على هَديك الدار، وما قْدَرش يْزَعزَعها خاطَر كانَت مَبنِيّة مْليح. ");
INSERT INTO arq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","بَصَّح اللي يَسمَع وما يَعمَلش، يْشَبَّه لبْنادَم بْنا دار على الأرض بْلا ساس، حْمَل عليها الواد وطاحَت تَم تَم وكانَت وَخدة هَديك الدار كْبيرة\". ");
INSERT INTO arq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","وبَعدما كَمَّل يَسوع كامَل كْلامو للشَعب اللي كان يَسمَع دْخَل لكَفرناحوم. ");
INSERT INTO arq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","واحَد قايَد المْية كان عَندو خْديم عْزيز عليه، وهاد الخْديم كان مْريض وفالمَماة. ");
INSERT INTO arq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","كي سْمَع بيَسوع، بْعَتلو شْيوخ اليْهود يَطلَب منّو يْجي باش يَشفي خْديمو، ");
INSERT INTO arq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","وكي وَصلو عَند يَسوع، حَلّلوه وقالو: \"هاد الراجَل يَستاهَل تْديرلو هاد الشي، ");
INSERT INTO arq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","خاطَر يْحَب الأُمّة مْتاعنا وهُوَ اللي بْنالنا المَجمَع.\" ");
INSERT INTO arq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","كان يَسوع معاهُم فالطْريق، وماشي بْعيد على الدار كي بْعَتلو قايَد المْية صْحابو يْقولولو: \"سيدي، ما تْشَقّيش روحَك، خاطَر أنا ما نَستاهَلش باش تَدخُل تَحت السْقَف مْتاع داري، ");
INSERT INTO arq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","على هَدا اللي ما جيتش أنا بداتي لعَندَك خاطَر شَفت روحي ما نَستاهَلش نْجي ليك، بَصَّح قول كَلمة والخْديم مْتاعي يَبرا، ");
INSERT INTO arq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","خاطَر أَنا اللي عَندي مْعَلّمين يَحَّكمو فِيَّ، عَندي عَسكَر تَحت يَدّيِ، ونْقول لهَدا روح، يْروح، وللآخُر أرواح، يْجِي، وللخْديم مْتاعي دير ويْدير\". ");
INSERT INTO arq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","كي سْمَع يَسوع هاد الشي، عَجبو ودار للغاشي اللي كان يْتَبَّع فيه وقال: \"نْقولَلكُم، حَتّى في إسرائيل ما لْقيتش إيمان قَد هَدا\". ");
INSERT INTO arq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","رَجعو المْراسَل مْتاع قايَد المْية للدار ولْقاو الخْديم اللي كان مْريض بْرا. ");
INSERT INTO arq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","من بَعد، راح يَسوع لواحَد المْدينة واسَمها نايين وراحو معاه التابعين مْتاعو وغاشي كْبير. ");
INSERT INTO arq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","كي قَرَّب لباب المْدينة، لْقا ناس كانو مَديّين مِيَّت باش يَدَّفنوه وكانَت يَمّاه هَجّالة وتَسعاه غير هُوَ وكان معاها غاشي من ناس المْدينة. ");
INSERT INTO arq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","كي شافها الرَب، حَن عليها وقالَلها: \"ما تَبكيش\"، ");
INSERT INTO arq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","وأدَنّا ومَس النْعاش. وَقفو اللي كانو رافدينو وقال يَسوع: \"يا مَصغَر، ليك نْقول، نوض\". ");
INSERT INTO arq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","تْقَعَّد المِيَّت وبْدا يَهدَر ورَدّو يَسوع ليَمّاه. ");
INSERT INTO arq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","طاح الخوف عليهُم كامَل وسَبحو الله وقالو: \"جا بيناتنا نَبي كْبير\"، وواحَدُخرين قالو: \"الله فاقَد شَعبو\". ");
INSERT INTO arq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","وشاع عليه هاد الكْلام في كامَل اليَهودِيّة وكامَل الجْوايَه اللي دايرين بيها. ");
INSERT INTO arq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","التابعين مْتاع يوحَنّا حْكاولو هاد الشي كامَل. عَيَّط لزوج منهُم، ");
INSERT INTO arq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","وبْعَتهُم للرَب يْقولولو: \"أنتَ هُوَ اللي كان لازَم يْجي وَلاّ نَستَناو واحَدآخُر؟\" ");
INSERT INTO arq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","كي جاو المْراسَل عَند يَسوع قالولو: \"بْعَتنا ليك يوحَنّا المَعمَدان يْقول: \"أنتَ هُوَ اللي كان لازَم يْجي وَلاّ نَستَنّاو واحَدآخُر؟\"\" ");
INSERT INTO arq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","في هَديك الساعة شْفا يَسوع بَزّاف من المَرضى والعايبين والمَسكونين ورَجَّع الشوفة لعَميين بَزّاف. ");
INSERT INTO arq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","جاوَب يَسوع وقالَلهُم: \"كي تْروحو، خَبّرو يوحَنّا باللي شَفتوه وسْمَعتوه: العَميين راهُم يْشوفو، المَشلولين يَمشيو، اللي عَندهُم البْرَص يَطَّهرو، الطْروشة يَسَّمعو، الموتى يْقومو والڤْلالين يَتبَشّرو، ");
INSERT INTO arq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","يا سَعد اللي ما يَعتَرش على جالي\". ");
INSERT INTO arq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","كي راحو المْراسَل مْتاع يوحَنّا، بْدا يَسوع يْقول عليه للغاشي: \"واش رُحتو تْشوفو فالخْلا؟ قَصبة يْهَزّها الريح؟ ");
INSERT INTO arq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","بَصَّح واش رُحتو تْشوفو؟ راجَل لابَس لَبسة العَز؟ اللي عَندهُم اللَبسة الحَطّة وبالطْبَع راهُم في قْصور السْلاطَن، ");
INSERT INTO arq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","واش رُحتو تْشوفو؟ نَبي؟ إيه نْقولَلكُم وكْتَر من نَبي، ");
INSERT INTO arq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","هُوَ اللي مَكتوب عليه: نَبعَت مَرسولي قَبلَك، باش يْوَجَّدلَك الطْريق\". ");
INSERT INTO arq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","نْقولَلكُم: \"ماكاش فاللي وَلدوهُم النْسا واحَد كْبير على يوحَنّا، بَصَّح الصْغير في مَلَكوت الله كْبير عليه\". ");
INSERT INTO arq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","وكامَل الشَعب كي سَمعو والمَكّاسين سْتَعرفو بصْلاح الله وتْعَمّدو بمَعمودِيّة يوحَنّا. ");
INSERT INTO arq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","بَصَّح الفَريسِيّين وشْيوخ الشَريعة على حْساب اللي ما تْعَمّدوش على يَد يوحَنّا، نَكرو مُراد الله ليهُم. ");
INSERT INTO arq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","وقال يَسوع: \"باش نْمَتَّل ناس هاد الجيل وباش نْشَبَّههُم؟ ");
INSERT INTO arq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","يْشَبّهو لدْراري قاعدين فالزَنقة يْعَيّطو لبَعضهُم بَعض ويْقولو: \"جَوَّقنالكُم وما شْطَحتوش، نَوَّحنالكُم وما بْكيتوش\"، ");
INSERT INTO arq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","خاطَر جا يوحَنّا المَعمَدان، ما ياكُل خُبز، ما يَشرُب شْراب وقُلتو: \"ساكنو شيطان\"، ");
INSERT INTO arq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","جا بْن الإنسان، ياكُل ويَشرُب وقُلتو: \"هاوليك إنسان يْحَب الماكلة والشْراب، حْبيب المَكّاسين والخاطيين\"، ");
INSERT INTO arq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","بَصَّح العْقَل بان صْلاحو عَند كامَل مْواليه.\" ");
INSERT INTO arq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","واحَد من الفَريسِيّين عْرَض يَسوع باش ياكُل معاه، وكي دْخَل يَسوع لعَندو أتَّكا على الميدة. ");
INSERT INTO arq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","كانَت فالمْدينة واحَد المْرا خاطِية، كي سَمعَت باللي يَسوع كان مْتَكّي على الميدة في دار الفَرّيسي، جابَت قَرعة مْتاع الريحة، ");
INSERT INTO arq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ووَقفَت مور رَجلين يَسوع وهِيَ تَبكي، وبْدات تْشَمَّخلو في رَجليه بالدْموع وتَمسَح فيهُم بشْعَرها وتْبوس فيهُم وتَدهَنهُم بالريحة. ");
INSERT INTO arq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","كي شاف الفَرّيسي اللي عَرضو هاد الشي قال في قَلبو: \"لو كان جا هاد الراجَل نَبي، كان يَعرَف هاد المْرا اللي راهي تْمَس فيه وواش تْكون، يَعرَفها باللي مْرا خاطية\". ");
INSERT INTO arq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","جاوَب يَسوع وقاللو: \"سَمعان، عَندي حاجة نْقولهالَك\"، قاللو سَمعان: \"قول شيخ\"، ");
INSERT INTO arq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","قال يَسوع: \"كان واحَد عَندو زوج يْسالَلهُم الدْراهَم، الأَوَّل يْساللو خَمس مْية دينار، والآخُر خَمسين، ");
INSERT INTO arq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","كي ما كانش عَندهُم باش يْرَدّولو، سْمَحَّلهُم الدين في زوج. شْكون فيهُم اللي يْحَبّو كْتَر؟\" ");
INSERT INTO arq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","جاوَب سَمعان وقال: \"نْضَن اللي سْمَحلو كْتَر\". قاللو يَسوع: \"حْكَمت بالصْواب\"، ");
INSERT INTO arq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ودار للمْرا وقال لسَمعان: \"راك تْشوف هاد المْرا؟ دْخَلت لدارَك والما ما عْطيتنيش لرَجليَّ بَصَّح هيَ شَمّخَت رَجليَّ بالدْموع ومَسحَتهُم بشْعَرها، ");
INSERT INTO arq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","أنتَ بوسة ما عْطيتنيش بَصَّح هِيَ من اللي دَخلَت ما حَبسَتش وهيَ تْبوس في رَجليَّ، ");
INSERT INTO arq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","أنتَ بزيت ما دْهَنتليش راسي، بَصَّح هِيَ دَهنَت رَجليَّ بالريحة. ");
INSERT INTO arq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","على هَدا نْقوللَك، دْنوبها اللي كانو بَزّاف تْغَفرو خاطَر حَبَّت بَزّاف، بَصَّح اللي يَتَّغفَرلو شْويّة يْحَب شْويّة\". ");
INSERT INTO arq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","أومبَعد قال للمْرا: \"دْنوبَك تْغَفرو\". ");
INSERT INTO arq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","وبْداو المَعروضين يْقولو في قْلوبهُم: \"شْكون هَدا اللي يَغفَر حَتّى الدْنوب؟\" ");
INSERT INTO arq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","وزاد قال يَسوع للمْرا: \"إيمانَك سَلّكَك، روحي هانية\". ");
INSERT INTO arq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","بَعد هَدا، كان يَسوع يْروح من مْدينة لمْدينة ومن دَشرة لدَشرة يْبَرَّح ويْبَشَّر بمَلَكوت الله ومعاه التابعين الطْناش، ");
INSERT INTO arq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","وشي نْسا كانو بْراو من الأرواح الدونِيّين ومن الأمراض: مَريَم اللي يْسَمّيوها المَجدَليّة واللي خَرجو منها سَبع شْياطَن، ");
INSERT INTO arq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ويوَنّا مَرت خوزي وْكيل هيرودَس، وسوسَنّة وواحَدُخرين بَزّاف كانو يْعاونو يَسوع والتابعين مْتاعو بمْلاكهُم. ");
INSERT INTO arq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","تْلَم عليه غاشي كْبير جاو من كُل مْدينة، وقال مْتَل: ");
INSERT INTO arq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"خْرَج فَلاّح يَزرَع الزَرّيعة مْتاعو، وكي كان يَزرَع طاحَتلو شْويّة على الطْريق، نْعَفسَت وكْلاوها طْيور السْما. ");
INSERT INTO arq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","وطاحَت شْويّة واحَدُخرى على الحْجَر، كي ناضَت يَبسَت، خاطَر ما لْقاتش النْدى. ");
INSERT INTO arq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","وطاحَت شْويّة في وَسط الشوك، ناض معاها الشوك وغَمّها، ");
INSERT INTO arq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","وطاحَت واحَدُخرى فالأرض المْليحة، وكي ناضَت عْطات غَلّة قيس مْية مَرّة من هَديك الزَرّيعة\". بَعد ما قال يَسوع هاد الشي، قال بالزور: \"اللي عَندو وَدنين باش يَسمَع، غير يَسمَع\". ");
INSERT INTO arq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","سَقساوَه التابعين مْتاعو واش مَعنَاه هاد المْتَل. ");
INSERT INTO arq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","قالَلهُم: \"أنتومَ أتَّعطالكُم باش تَعَّرفو سْرار مَلَكوت الله، بَصَّح الأُخرين نْكَلَّمهُم بالمْتال باش يَخَّزرو وما يْشوفوش ويَسَّمعو وما يَفَّهموش، ");
INSERT INTO arq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","هاد المْتَل يَعني: الزَرّيعة هِيَ كْلام الله، ");
INSERT INTO arq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","اللي على الطْريق هومَ اللي يَسَّمعو، أومبَعد يْجي إبليس ويْنَحّي الكَلمة من قْلوبهُم بلَاك يْعودو يامنو ويَسّلكو. ");
INSERT INTO arq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","اللي على الحْجَر هومَ اللي كي يَسَّمعو الكَلمة يَقَّبلوها بالفَرحة، بَصَّح ما عَندهُمش العْروق، يامنو واحَد الوَقت وكي تْجي التَجرُبة يَجَّبدو روحهُم. ");
INSERT INTO arq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","اللي طاح فالشوك هومَ اللي يَسَّمعو، بَصَّح هْموم الدَنيا وخيرها وشَهوَتها يْغَمّوهُم وما تَوصَلش غَلَّتهُم. ");
INSERT INTO arq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","اللي فالأرض المْليحة، هومَ اللي يَسَّمعو الكَلمة ويَحَّفضوها في قَلب مْليح وحْلالي ويْجيبو الغَلَّة بالصْبَر. ");
INSERT INTO arq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","واحَد ما يَشعَل شَمعة ويْغَطّيها بماعون وَلاّ يْحَطّها تَحت الفْراش. بالعَكس، يْحَطّها فالشانضال باش اللي يَدُّخلو يْشوفو الضو، ");
INSERT INTO arq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","خاطَر ما كانش حاجة مْخَبية ما تْبانش وَلاّ سَرّية ما تْنَعرَفش وما تْنَكشَفش، ");
INSERT INTO arq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","هِمّالا رَدّو بالكُم كيفاش تَسَّمعو، خاطَر اللي عَندو يَتمَدّلو واللي ما عَندوش يَتنَحّالو حَتّى الشي اللي يَحَّسبو مْتاعو\". ");
INSERT INTO arq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","جاو ليه يَمّاه وخاوتو بَصَّح ما قَدروش يَوَّصلو لعَندو على جال الغاشي. ");
INSERT INTO arq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","خَبّروه: \"يَمّاك وخاوتَك راهُم بَرّا حابّين يْشوفوك\"، ");
INSERT INTO arq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","جاوَب هُوَ وقالَلهُم: \"يَمّا وخاوتي هومَ اللي يَسَّمعو كَلمة الله ويَعَّملو بيها\". ");
INSERT INTO arq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","من بَعد، في واحَد النْهار، طْلَع يَسوع في فْلوكة هُوَ والتابعين مْتاعو وقالَلهُم: \"هَيّا نَقَّطعو للشَط الآخُر مْتاع البْحَر\"، وراحو للغامَق. ");
INSERT INTO arq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","كي كانو جايزين فالبْحَر، رْقَد يَسوع. وناض ريح قْوي على البْحَر وبْدات الفْلوكة تَتعَمَّر بالما وقْريب ماتو. ");
INSERT INTO arq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","تْدَنّاو ليه ونَوّضوه وقالو: \"سيدي، سيدي، رايحين نْموتو\". ناض يَسوع، وغير هَدَّد الريح والموجات، حَبسو وتْهَدنت الحالة. ");
INSERT INTO arq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","قالَلهُم: \"وين راهو إيمانكُم؟\" خافو وسْتَعجبو وقالو لبَعضهُم بَعض: \"شْكون هَدا اللي يامَر حَتّى الأرياح والما ويْطيعوه؟\" ");
INSERT INTO arq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ووَصلو لبْلاد الجِراسِيّين اللي جايّة مْقابَل الجْليل. ");
INSERT INTO arq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","كي هْبَط يَسوع للأرض لاقاه راجَل من المْدينة كان مَسكون بشْياطَن بَزّاف من مُدّة طْويلة وكان ما يَلبَس حْوايَج، ما يَسكُن في دار، وقاعَد غير فالجَبّانة. ");
INSERT INTO arq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","كي شاف يَسوع، عَيَّط ورْكَع قُدّامو وقال بالزور: \"واش بيني وبينَك يا يَسوع بْن الله العالي؟ نَترَجّاك، ما تْعَدَّبنيش\"، ");
INSERT INTO arq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","خاطَر يَسوع آمَر الروح الناجَس باش يَخرُج من الراجَل، خاطَر شْحال من مَرّة كان هاد الشيطان يَحَّكمو وكانو يَرَّبطوه بالسْناسَل والحْديد في رَجليه باش يَحَّبسوه بَصَّح هُوَ كان يْقَطَّعهُم ويَدّيه الشيطان اللي ساكنو للخْلا. ");
INSERT INTO arq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","سَقساه يَسوع: \"واسمَك؟\" قاللو: \"جيش\"، خاطَر شْياطَن بَزّاف كانو دَخلو فيه. ");
INSERT INTO arq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","هاد الشْياطَن بْداو يْحَلّلو في يَسوع باش ما يامَرهُمش يْروحو للزَرداب. ");
INSERT INTO arq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","وكان تَمّة قْطيع كْبير مْتاع الحْلالَف يَرعاو فالجْبَل، حَلّلوه الشْياطَن باش يْخَلّيهُم يَدُّخلو فيهُم، وخَلاّهُم. ");
INSERT INTO arq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","خَرجو الشْياطَن من الراجَل ودَخلو فالحْلالَف. الحْلالَف غير دَخلو فيهُم الشْياطَن راحو يَجريو من حَرف الجْبَل للواد وغَرقو. ");
INSERT INTO arq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","كي شافو الرَعيان مْتاع الحْلالَف واش صْرا، هَربو وراحو يَدّيو الخْبَر فالمْدينة والأحواش. ");
INSERT INTO arq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","خَرجو الناس يْشوفو الشي اللي صْرا، وجاو ليَسوع وكي شافو الراجَل اللي كان مَسكون قاعَد عَند رَجلين يَسوع لابَس وعاقَل، خافو. ");
INSERT INTO arq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","وزادو حْكاوَلهُم اللي شافو كيفاش بْرا المَسكون. ");
INSERT INTO arq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","كامَل ناس بْلاد الجِراسِيّين طَلبو من يَسوع واللي معاه باش يْروحو من عَندهُم خاطَر حْكَمهُم خوف كْبير. رْكَب يَسوع فالفْلوكة ورْجَع. ");
INSERT INTO arq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","الراجَل اللي خَرجو منّو الشْياطَن طْلَب من يَسوع باش يْخَلّيه يَبقا معاه، بَصَّح يَسوع رَدّو وقاللو: ");
INSERT INTO arq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","\"أرجَع لدارَك وأحكي كامَل واش دارلَك الله\". وراح الراجَل وبَرَّح في كامَل المْدينة بكامَل واش دارلو يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","كي رْجَع يَسوع، لاقاه الغاشي خاطَر كانو كامَل يَستَنّاو فيه. ");
INSERT INTO arq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","وجا لعَندو واحَد الراجَل واسمو يايرَس، وكان هاد الراجَل هُوَ رايَس المَجمَع. رْكَع عَند رَجلين يَسوع وطْلَب منّو باش يْروح لدارو، ");
INSERT INTO arq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","خاطَر كانَت عَندو طَفلة واحدة، عَندها واحَد الطْناشن سْنة وكانَت فالمَماة. وكي كان يَسوع رايَح لعَند هاد الراجَل، كْتَر عليه الزْحام مْتاع الغاشي. ");
INSERT INTO arq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","كانَت تَمّة واحَد المْرا مْريضة يْسيل منها الدَم من طْناشَن سْنة، صَرفَت كامَل واش تَسعا عَند لاطُبّة وواحَد ما قْدَر يَشفيها، ");
INSERT INTO arq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","تْدَنّات ليَسوع من اللور ومَسَّت الجْلال مْتاع لْباسو، وتَم تَم حْبَس الدَم اللي كان يْسيل منها. ");
INSERT INTO arq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","قال يَسوع: \"شْكون مَسّني؟ خاطَر حَسّيت بقُوّة خَرجَت مَنّي\". كي كامَل نَكرو، قال بُطرُس: \"سيدي، الغاشي راهو مَتزاحَم ومْضَيَّق عليك\"، ");
INSERT INTO arq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","قال يَسوع: \"واحَد مَسّني خاطَر حَسّيت بقُوّة خَرجَت منّي\"، ");
INSERT INTO arq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","شافَت المْرا باللي نْكَشفَت، وجات تَرجَف وأتَّرمات قُدّامو وخَبّراتو قُدّام كامَل الشَعب عْلاش مَسّاتو وكيفاش بْرات تَم تَم. ");
INSERT INTO arq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","قالَلها يَسوع: \"بَنتي، إيمانَك سَلّكَك، روحي هانية\". ");
INSERT INTO arq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","كان مازالو يَهدَر، كي جا واحَد من دار رايَس المَجمَع يْقول: \"بَنتَك ماتَت، ما تْشَقّيش الشيخ\"، ");
INSERT INTO arq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","كي سْمَع يَسوع قال لرايَس المَجمَع: \"ما تْخافش. آمَن بَرك وهِيَ تَبرا\"، ");
INSERT INTO arq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","كي وْصَل للدار، ما خَلاّ حَتّى واحَد يَدخُل معاه من غير بُطرُس ويوحَنّا ويَعقوب وباباة الطَفلة ويَمّاها. ");
INSERT INTO arq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","كانو كامَل يَبكيو عليها ويَندبو. قال يَسوع: \"ما تَبكيوش، ما ماتَتش، راهي راقدة\". ");
INSERT INTO arq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","سْتَهزاو بيه خاطَر كانو عارفين باللي ماتَت. ");
INSERT INTO arq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","هُوَ، شَدَّلها يَدها، عَيَّط وقال: \"يا طَفلة، نوضي\"، ");
INSERT INTO arq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","رَجعَتَّلها الروح مْتاعها وناضَت تَم تَم، ويَسوع آمَر باش يْمَدّولها تاكُل، ");
INSERT INTO arq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","سْتَعجبوا مْواليها، ووَصّاهُم يَسوع باش ما يْقولو لحَتّى واحَد واش صْرا. ");
INSERT INTO arq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","عَيَّط يَسوع للتابعين الطْناش وعْطالهُم القُوّة والحُكمة على كامَل الشْياطَن والقُدرة باش يَشفيو الأمراض، ");
INSERT INTO arq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","وبْعَتهُم باش يْبَرّحو بمَلَكوت الله وباش يَشفيو المَرضى، ");
INSERT INTO arq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","وقالَلهُم: \"ما تَدَّيو والو للطْريق، لا عْصا، لا رَزمة، لا خُبز وَلا دْراهَم، وما يْكونش عَند واحَد فيكُم زوج كَسوات، ");
INSERT INTO arq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","الدار اللي تَدَّخلولها، أقَّعدو فيها حَتّى نْهار تْروحو من هَداك المْكان، ");
INSERT INTO arq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ووين ما يَقَّبلوكُمش، أخُّرجو من هَديك المْدينة وأنَّفضو الغْبار من رَجليكُم شْهادة عليهم.\" ");
INSERT INTO arq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","كي راحو، جازو على الدْشور يْبَشّرو ويَشفيو المَرضى في كُل مْكان. ");
INSERT INTO arq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","كي سْمَع هيرودَس رايَس الرُبع بكامَل واش كان يَصرا حار، خاطَر كايَن اللي كانو يْقولو باللي يوحَنّا قام من بين الموتى، ");
INSERT INTO arq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","وواحَدُخرين يْقولو باللي إيليّا ضْهَر، وواحَدُخرين تاني باللي نَبي من الأنبيا القْدَم قام. ");
INSERT INTO arq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","قال هيرودَس: \"يوحَنّا، أنا قَطَّعت راسو، هِمّالا شْكون هَدا اللي راني نَسمَع عليه هاد الشي\"، وكان يْحَوَّس يْشوفو. ");
INSERT INTO arq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","كي رَجعو الرُسُل، خَبّرو يَسوع بكامَل الشي اللي داروه. أَدّاهُم معاه وراح على جيه في واحَد المْدينة واسَمها بيت صيدا. ");
INSERT INTO arq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","كي عْرَف الغاشي تَبّعو. لاقاهُم يَسوع وبْدا يْكَلَّمهُم على مَلَكوت الله وشْفا اللي كانو مَحتاجين باش يَشفاو. ");
INSERT INTO arq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","كي بْدا يْطيح الليل، جاو ليه التابعين الطْناش وقالولو: \"خَلّي الغاشي يْروح للدْشور والأحواش اللي فالجْوايَه، باش يْباتو وياكلو، خاطَر هْنا رانا فالخْلا\". ");
INSERT INTO arq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","قالَلهُم: \"أَعطيوهُم أنتومَ ياكلو\". قالولو: \"عَندنا غير خَمس خُبزات وزوج حوتات، غير إيلا رُحنا نَشريو ماكلة لكامَل هاد الشَعب.\" ");
INSERT INTO arq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","خاطَر كانو واحَد الخَمس آلاف راجَل. قال يَسوع للتابعين مْتاعو: \"قَعّدوهُم في صْفوف مْتاع خَمسين خَمسين\". ");
INSERT INTO arq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","دارو كيما قالَلهُم وقَعّدوهُم كامَل. ");
INSERT INTO arq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","شَد يَسوع الخَمس خُبزات والزوج حوتات ورْفَد عينيه للسْما، وبارَكهُم، أومبَعد قْسَم وعْطا للتابعين باش يْمَدّو للغاشي، ");
INSERT INTO arq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","كامَل كْلاو وشَبعو أومبَعد رَفدو طْناشَن قُفّة مْتاع الماكلة اللي بْقات. ");
INSERT INTO arq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","كان يَسوع واحَد المَرّة يْصَلّي واحدو وكانو التابعين مْتاعو مَتلايمين معاه. سَقساهُم وقال: \"على حْساب الغاشي، واش نْكون أنا؟\" ");
INSERT INTO arq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","جاوبوه وقالو: \"يوحَنّا المَعمَدان، واحَدُخرين يْقولو إيلِيّا وواحَدُخرين تاني: نَبي من الأنبيا القْدَم قام من الموت.\" ");
INSERT INTO arq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","قالَلهُم: \"وأنتومَ، شْكون تْقولو نْكون أنا؟\" جاوَب بُطرُس وقال: \"مَسيح الله\". ");
INSERT INTO arq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","وَصّاهُم يَسوع ووَكَّد عليهُم باش ما يْقولو هاد الشي لحَتّى واحَد، ");
INSERT INTO arq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","وقال باللي بْن الإنسان لازَم يَتعَدَّب بَزّاف وما يَقَّبلوهش الشْيوخ ورْجال الدين والكُتّاب ويْنَقتَل وفاليوم التالَت يْقوم. ");
INSERT INTO arq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","قالَلهُم كامَل: \"ولا حَب واحَد يْتَبَّعني، لازَم يَسمَح في روحو ويَرفَد صْليبو كُل يوم ويْتَبَّعني، ");
INSERT INTO arq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","خاطَر اللي يْحَب يْسَلَّك نَفسو يَخسَرها، بَصَّح اللي يَسمَح في نَفسو على جالي، هَداك يْسَلَّكها، ");
INSERT INTO arq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","خاطَر واش من فايدة عَندو بْنادَم لوكان يَربَح الدَنيا كامَل وهُوَ يْضيع وَلاّ يْروح للهْلاك؟ ");
INSERT INTO arq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","كُل من يَستحي بيَّ وبكْلامي، يَستحي بيه بْن الإنسان كي يْجي في هيبتو وهيبةالآب والمْلايكة القَدّيسين. ");
INSERT INTO arq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","نْقولَلكُم الصَح: كايَن من اللي راهُم هْنا اللي ما يْدوقوش الموت حَتّى يْشوفو مَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","واحَد التَمن أيّام بَعد هاد الكْلام، أدّا يَسوع معاه بُطرُس ويوحَنّا ويَعقوب وطْلَع للجْبَل باش يْصَلّي. ");
INSERT INTO arq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","وكي كان يْصَلّي، تْبَدلَت الصِفة مْتاع وَجهو ووَلاّ لْباسو بْيَض يَشعَل كي البْرَق، ");
INSERT INTO arq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","وهاو وين زوج رْجال كانو يَهَّدرو معاه هومَ موسى وإيلِيّا، ");
INSERT INTO arq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","اللي ضَهرو بالبْها وتْكَلّمو على مَرواحو اللي كان رايَح يْصير في أورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","بُطرُس واللي كانو معاه كانو مَصروعين بالنْعاس، بَصَّح شَدّو روحهُم باش يَبقاو فاطنين وشافو بْها يَسوع والزوج رْجال اللي كانو واقفين معاه. ");
INSERT INTO arq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","كي كانو هَدوك الزوج رْجال رايحين يْفارقو يَسوع، قال بُطرُس ليَسوع: \"سيدي، مْليح لو كان نَبقاو هنا، نْديرو تَلت خْيَم، واحدة ليك، واحدة لموسى وواحدة لإيلِيّا\"، وما كانش عارَف واش كان يْقول. ");
INSERT INTO arq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","وكي كان يْقول هاد الشي، جات سْحابة غَطّات يَسوع وموسى وإيلِيّا، وخافو التابعين كي شافوهُم يَدُّخلو فيها. ");
INSERT INTO arq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","وجا صوت من السْحابة يْقول: \"هَدا هُوَ وْليدي المُختار، أسَّمعولو\"، ");
INSERT INTO arq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","وكي أتَّسمَع الصوت، بْقا يَسوع وَحدو. التابعين سَكتو وما خَبّرو حَتّى واحَد في هَداك الوَقت بالشي اللي شافوه. ");
INSERT INTO arq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","غَدوة من داك، كي هَبطو من الجْبَل، غاشي كْبير لاقا يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","واحَد الراجَل من الغاشي عَيَّط وقال: \"شيخ، نَترَجّاك تْشوف لوْليدي، خاطَر ما نَسعاه غير هُوَ، ");
INSERT INTO arq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","روح يَحَّكمو، وتَم تَم يَبدا يْعَيَّط، ويَتخَبَّط ويَخُرّجو الرْغاوي من فَمّو وما يَطَّلقو الروح حَتّى يْفَشّلو. ");
INSERT INTO arq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","طْلَبت من التابعين مْتاعك باش يْخَرّجوه بَصَّح ما قَدروش\". ");
INSERT INTO arq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","جاوَب يَسوع وقال: \"جيل عْديم الإيمان ومْعَوَّج، لوَقتاش نْكون معاكُم ونَرفَدكُم. جيب وْليدَك اللَهنا\". ");
INSERT INTO arq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","كي كان جاي، صَرعو الشيطان ووَلاّ يَتخَبَّط. هَدَّد يَسوع الروح الناجَس وشْفا الوْلَد ورَجّعو لباباه. ");
INSERT INTO arq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","بَهتو كامَل في قُدرة الله الكْبيرة، وكي كانو كامَل مَستَعجبين في كامَل واش كان يْدير يَسوع قال هُوَ للتابعين مْتاعو: ");
INSERT INTO arq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"أنتومَ، أسَّمعو هاد الكْلام، بْن الإنسان رايَح يَتسَلَّم ليَدّين الناس\"، ");
INSERT INTO arq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","بَصَّح هومَ ما فَهموش هاد الهَدرة، خاطَر كانَت مَخفِيّة عليهُم باش ما يَفَّهموهاش، وخافو يْسَقسيوَه على هاد الآمَر. ");
INSERT INTO arq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","جاتهُم واحَد الفَكرة: شْكون هُوَ الكْبير فيهُم؟ ");
INSERT INTO arq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","كي عْرَف يَسوع واش كانو يْخَمّمو في قْلوبهُم، أدّا وْلَد صْغير وحَطّو قُدّامو، ");
INSERT INTO arq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","وقالَلهُم: \"اللي يَستَقبَل هاد الوْلَد بآسمي، سْتَقبَلني أنا واللي يَستَقبَلني، سْتَقبَل اللي بْعَتني، خاطَر الصْغير فيكُم كامَل، هَداك هُوَ الكْبير.\" ");
INSERT INTO arq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","جاوَب يوحَنّا وقال: \"سيدي، شَفنا واحَد يْخَرَّج الشْياطَن بآسمَك ومْنَعناه خاطَر ما راهوش يْتَبَّع فيك معانا\". ");
INSERT INTO arq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","قاللو يَسوع: \"ما تَمَّنعوهش خاطَر اللي ماشي ضَدنا، معانا.\" ");
INSERT INTO arq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","كي وْصَل الوَقت باش يَتَّرفَع يَسوع، عَوَّل يْروح لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","وبْعَت مْراسَل قْبَل منّو، حَكمو الطْريق ودَخلو لواحَد الدَشرة مْتاع السامرِيّين باش يْوَجّدولو مَضرَب. ");
INSERT INTO arq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","بَصَّح ما قَبلوهش تَمّة خاطَر كان رايَح لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","كي شافو التابعين مْتاعو يوحَنّا ويَعقوب هاد الشي قالولو: \"رَبّي، تَحّب نْقولو للنار تَنزَل من السْما وتاكُلهُم؟\" ");
INSERT INTO arq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","دار ليهُم وزْڤا عليهُم. ");
INSERT INTO arq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","وراحو لدَشرة واحَدوخرى. ");
INSERT INTO arq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","وكي كانو فالطْريق قاللو واحَد: \"نْتَبعَك وين تْروح\"، ");
INSERT INTO arq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","قاللو يَسوع: \"التْعالَب عَندهُم غيران وطْيور السْما عْشوش، بَصَّح بْن الإنسان ما عَندوش وين يْتَكّي راسو\". ");
INSERT INTO arq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","زاد قال لواحَدآخُر: \"تَبَّعني\"، قاللو: \"رَبّي، خَلّيني قْبَل نْروح نَدفَن بابا\"، ");
INSERT INTO arq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","قاللو يَسوع: \"خَلّي الموتى يَدَّفنو الموتى مْتاعهُم، أنتَ روح وخَبَّر بمَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","زاد قاللو واحَدآخُر: \"رَبّي، نْتَبعَك بَصَّح خَلّيني قْبَل نْروح نْوَدَّع مْوالِيَّ\". ");
INSERT INTO arq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","قاللو يَسوع: \"اللي يْحَط يَدّو على المَحرات ويْشوف للور ما يَصلَحش لمَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","من بَعد خَيَّر الرَب تْنين وسَبعين تابَع واحَدُخرين وبْعَتهُم زوج زوج باش يَسَّبقوه لكُل مْدينة وكُل مَضرَب كان مْعَوَّل يْروح ليه. ");
INSERT INTO arq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","قالَلهُم: \"الحْصاد راهو كاتَر بَصَّح الخَدّامين قْلال، أطَّلبو من مول الحْصاد باش يَبعَت خَدّامين لحْصادو. ");
INSERT INTO arq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","روحو، راني نَبعَتكُم كي الخَرفان في وَسط الدْيوبة، ");
INSERT INTO arq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ما تَدّيو لا دْراهَم، لا رَزمة، لا صَبّاط، وما تْسَلّمو على حَتّى واحَد فالطْريق. ");
INSERT INTO arq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","والدار اللي تَدُّخلولها قولو قْبَل: \"السْلام لهاد الدار\". ");
INSERT INTO arq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","وَلاّ كان فيها راجَل سْلام، السْلام مْتاعكُم يَبقا معاه، وَلاّ ما كانش، السْلام مْتاعكُم يَرجَعَّلكُم. ");
INSERT INTO arq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","أقَّعدو في هَديك الدار واكلين، شاربين من اللي كايَن عَندهُم خاطَر الخَدّام يَستاهَل الخْلاص مْتاعو، وما تْروحوش من دار لدار، ");
INSERT INTO arq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","والمْدينة اللي تَدَّخلولها ويَقَّبلوكُم ناسها، كولو واش يْمَدّولكُم، ");
INSERT INTO arq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","أشفيو المَرضى اللي فيها وقولولهُم: \"قَرَّب ليكُم مَلَكوت الله\". ");
INSERT INTO arq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","والمْدينة اللي تَدَّخلولها وما يَقَّبلوكُمش ناسها، أخَّرجو لطُرقانها وقولو: ");
INSERT INTO arq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"حَتّى غْبار مْدينَتكُم اللي لْصَق في رَجلينا نَنَّفضوه باش نْرَدّوهولكُم، بَصَّح أعَّرفو باللي مَلَكوت الله قَرَّب ليكُم\"، ");
INSERT INTO arq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","نْقولَلكُم باللي في يوم المْحاسبة، حالة سَدوم ما تْكونش واعرة قَد حالة هَديك المْدينة. ");
INSERT INTO arq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","يا ويلَك يا كورَزين! يا ويلَك يا بيت صيدا! خاطَر لو كان صْرات في صور وصيدا المُعجِزات اللي صْراو فيكُم، لو كان راهُم تابو من بَكري وهومَ قاعدين على الرْماد بالخيشة. ");
INSERT INTO arq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","على هَدا، في يوم المْحاسبة، تْكون حالَتهُم خْفيفة على حالَتكُم. ");
INSERT INTO arq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","وأنتِ يا كَفرَناحوم، رايحة تَعلاي للسْما؟ تَهَّبطي حَتّى لجَهَنَّم! ");
INSERT INTO arq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","اللي يَسمَعَّلكُم يَسمَعلي واللي ما يَقبَلكُمش ما يَقبَلنيش واللي ما يَقبَلنيش ما يَقبَلش اللي بْعَتني.\" ");
INSERT INTO arq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","رَجعو التْنين وسَبعين فَرحانين يْقولو: \"رَبّي، بآسمَك حَتّى الشْياطن يْطيعونا\". ");
INSERT INTO arq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","قالَلهُم: \"شَفت الشيطان يْطيح كي البْرَق من السْما، ");
INSERT INTO arq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","راني نَعطيلكُم الحُكمة باش تَعَّفسو على اللْفاعي والعْقارَب وعلى كامَل قُوّة العْدو وحَتّى حاجة ما تْضَرّكُم، ");
INSERT INTO arq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","بَصَّح ما تَفَّرحوش على جال اللي الشْياطَن طايعينكُم، أفَّرحو على جال اللي أسماواتكُم مَكتوبين فالسْماوات.\" ");
INSERT INTO arq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","في داك الوَقت بالدات، فْرَح يَسوع فالروح القُدّوس وقال: \"نْسَبّحَك يا بابا، رَب السْما والأرض، خاطَر خَبّيت هاد الشي على الحُكَما والفاهمين وكْشَفتو للدْراري الصْغار. إيه يا بابا، خاطَر هَكدا حَبّيت، ");
INSERT INTO arq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","كُل شي أتَّعطالي من عَند بابا، وما كانش واحَد يَعرَف شْكون هُوَ الإبن من غير الآب وَلا شْكون هُوَ الآب من غير الإبن واللي يْحَب الإبن يَكشَفهولو\". ");
INSERT INTO arq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ودار للتابعين مْتاعو وَحَّدهُم وقالَلهُم: \"يا سَعد العينين اللي يْشوفو واش راكُم تْشوفو، ");
INSERT INTO arq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","خاطَر نْقولَلكُم باللي أنبيا بَزّاف وسْلاطَن حَبّو يْشوفو واش راكُم تْشوفو وما شافوش، ويَسَّمعو واش راكُم تَسَّمعو وما سَمعوش\". ");
INSERT INTO arq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","واحَد الشيخ مْتاع الشَريعة ناض باش يْجَرَّب يَسوع وقال: \"سيدي، واش نْدير باش نَورَت الحْياة الدايمة؟\" ");
INSERT INTO arq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","قاللو يَسوع: \"واش تْقول الشَريعة؟ كيفاش تْفَسَّرها؟\" ");
INSERT INTO arq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","جاوَب وقال: \"تْحَب الرَب إلَهَك من كُل قَلبَك ومن كُل نَفسَك ومن كُل قُوّتَك ومن كُل عَقلَك وتْحَب قْريبَك كيما نَفسَك\". ");
INSERT INTO arq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","قاللو يَسوع: \"جاوَبت بالصْواب، دير هَكدا، تْعيش\". ");
INSERT INTO arq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","بَصَّح هُوَ حَب يْبَرّي نَفسو وقال ليَسوع: \"وشْكون هُوَ قْريبي؟\" ");
INSERT INTO arq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","جاوَب يَسوع وقال: \"كان واحَد الراجَل هابَط من أورشَليم لأَريحا، وطاح في يَد السَرّاقين، عَرّاوَه وضَربوه وراحو وخَلاّوَه ما بين الحْياة والموت. ");
INSERT INTO arq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","جاز راجَل دين على الزْهَر من هَديك الطْريق، شافو وجاز من جيهة أخرى، ");
INSERT INTO arq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","وواحَد اللاوي تاني وْصَل لهَداك المْكان، شافو وجاز من جيهة أخرى، ");
INSERT INTO arq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","بَصَّح واحَد السامري كان جايَز، جا لتَمّة وكي شافو حَن عليه. ");
INSERT INTO arq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","قَرَّب ليه وكَمَّدلو جْروحو وكَب عليهُم الزيت والشْراب ورَكّبو فوق الهايشة مْتاعو وأدّاه لفَندَق وقام بيه. ");
INSERT INTO arq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","غَدوة من داك، كي كان رايَح، خَرَّج زوج دينارات وعْطاهُم لمول الفَندَق وقاللو: \"أتهَلاّ فيه والشي اللي تْزيد تَصَّرفو عليه نْرَدّهولَك كي نَوَلِّي\". ");
INSERT INTO arq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","في ميزَك، شْكون في هاد التْلاتة يْكون قْريب لهَداك اللي طاح في يَد السَرّاقين؟\" ");
INSERT INTO arq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","قال شيخ الشَريعة: \"هَداك اللي حَن عليه\"، قاللو يَسوع: \"روح وأنتَ تاني دير كيف كيف\". ");
INSERT INTO arq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","كي كان يَسوع والتابعين مْتاعو فالطْريق، دَخلو لواحَد الدَشرة وسْتَقبلاتو واحَد المْرا واسَمها مَرتا في دارها، ");
INSERT INTO arq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","وكان عَندها خُت واسَمها مَريَم، قَعدَت عَند رَجلين يَسوع تَسمَع لكْلامو، ");
INSERT INTO arq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","بَصَّح مَرتا كانَت لاتية بشْغال بَزّاف مْتاع الدار، وجات وقالَت: \"رَبّي، يْرَضّيك خْتي تْخَلّيني نَخدَم وَحدي؟ قولَلها تْعاوَنني\"، ");
INSERT INTO arq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","جاوَب يَسوع وقالَلها: \"يا مَرتا، يا مَرتا، تَتحَيّري وتَتقَلّقي على حاجات بَزّاف، ");
INSERT INTO arq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","حاجة واحدة لازمة، مَريَم خَيرَت النْصيب المْليح اللي ما يَتنَحّالهاش\". ");
INSERT INTO arq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","كان يَسوع يْصَلّي في واحَد المْكان وكي كَمَّل قاللو واحَد من التابعين مْتاعو: \"رَبّي، عَلَّمنا نْصَلّيو كيما عَلَّم يوحَنّا التابعين مْتاعو\". ");
INSERT INTO arq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","قالَلهُم: \"كي تْصَلّيو قولو: يا بابانا، يَتقَدَّس آسمَك، يْجي مَلَكوتَك، ");
INSERT INTO arq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","أعطيلنا كُل يوم الخُبز اللي يَكفينا، ");
INSERT INTO arq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","وأغفَرَّلنا دْنوبنا خاطَر حْنا تاني نَغَّفرو لَلّي يْضَرنا. وما تْدَخَّلناش فالغْواية.\" ");
INSERT INTO arq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","وزاد قالَلهُم: \"شْكون مَنكُم يْكون عَندو صاحَب، يْروح ليه في نَص الليل ويْقوللو: \"صاحبي، سَلَّفلي تَلت خُبزات، ");
INSERT INTO arq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","خاطَر واحَد صاحبي جاني من السْفَر وما عَنديش واش نَعطيلو\"، ");
INSERT INTO arq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ويْجاوبو صاحبو من الداخَل ويْقول: \"ما تْقَلَّقنيش، الباب راهو دُرك مَغلوق ووْلادي راهُم مْعايَ فالفْراش، ما نَقدَرش نْنوض نَعطيلَك الخُبر؟\" ");
INSERT INTO arq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","نْقولَلكُم، وَلاّ ما ناضش يَعطيلو كي جا صاحبو، يْنوض ويَعطيلو كامَل واش يَسحَق على جال السْماطة مْتاعو. ");
INSERT INTO arq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","وأنا نقولَلكُم، أطَّلبو يَتمَدَّلكُم، حَوّسو تَلقاو، طَبطبو يَتَّفتَحَّلكُم، ");
INSERT INTO arq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","خاطَر اللي يَطلَب يَدّي واللي يْحَوَّس يَلقا واللي يْطَبطَب يَتَّفتَحلو، ");
INSERT INTO arq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","شْكون الباباة فيكُم اللي كي يَطلَب منّو وْليدو حوتة يَعطيلو حْنَش في عوض الحوتة؟ ");
INSERT INTO arq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","وَلاّ يَطلَب منّو بيضة يَعطيلو عَقرَب؟ ");
INSERT INTO arq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ولاّ كُنتو أنتومَ اللي دونِيّين تَعَّرفو تْمَدّو حاجات مْلاح لوْلادكُم، كيفاش الآب اللي فالسْما ما يَعطيش الروح القُدّوس للي يَطَّلبوه مَنّو\". ");
INSERT INTO arq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","خَرَّج يَسوع شيطان عَڤّون وكي خْرَج، هْدَر العَڤّون اللي كان مَسكون والغاشي سْتَعجَب. ");
INSERT INTO arq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","كايَن منهُم اللي قالو: \"راه يْخَرَّج الشْياطَن ببَعلَزَبول رايَس الشْياطَن\"، ");
INSERT INTO arq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","وواحَدُخرين طَلبو منّو مارة من السْما باش يْجَرّبوه. ");
INSERT INTO arq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","هُوَ عْرَف تَخمامهُم وقالَلهُم: \"كُل مَملَكة مَقسومة وماشي مَتَوحّدة تَخلا ودار واقفة ضَد نَفسها تْطيح، ");
INSERT INTO arq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","وَلاّ كان الشيطان عَندو اللي خارجين ضَدّو، كيفاش تَتبَت مَملَكتو؟ خاطَر راكُم تْقولو باللي راني نْخَرَّج الشْياطَن ببَعلَزَبول. ");
INSERT INTO arq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","وَلاّ كُنت أنا نْخَرَّج الشْياطَن ببَعلَزَبول، هِمّالا وْلادكُم باش يْخَرّجوهُم؟ على هَدا هومَ اللي يَحَّكمو عليكُم، ");
INSERT INTO arq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","بَصَّح وَلاّ راني نْخَرَّج الشْياطَن بقُدرة الله، مَعنَتها مَلَكوت الله جا لعَندكُم. ");
INSERT INTO arq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","كي يْعَس راجَل قْوي ومْسَلَّح دارو، يْكونو مْلاكو فالآمان، ");
INSERT INTO arq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","بَصَّح كي يْجي واحَد قْوي كْتَر منّو، رايَح يَغَّلبو ويْنَحّيلو سْلاحو اللي كان تاكَل عليه ويْفَرَّق الغْنايَم مْتاعو. ");
INSERT INTO arq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","اللي ماشي معاي ضَدّي، واللي ما يْلَمش معاي يْزَربَع. ");
INSERT INTO arq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","كي يَخرُج الروح الناجَس من بْنادَم، يْروح للمْدارَب اللي ما فيهُمش الما يْحَوَّس على الراحة، وكي ما يَلقاش يْقول: نْوَلّي لداري اللي خْرَجت منها، ");
INSERT INTO arq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","وكي يَرجَع ليها، يَلقاها مَكنوسة ومْخَمّلة، ");
INSERT INTO arq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","داك الساع يْروح يْجيب سَبع أرواح مَشرارين كْتَر منّو، يَدُّخلو لهَديك الدار ويَسُّكنو فيها، وتْوَلّي حالة هَداك الإنسان مع الأخَّر كْتَر من اللي كانَت مع الأوَّل\". ");
INSERT INTO arq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","كي كان هُوَ يَهدَر، عَيّطَت واحَد المْرا من وَسط الغاشي وقالَتلو: \"يا سَعد الكَرش اللي رَفداتَك والصْدَر اللي رَضعَك\"، ");
INSERT INTO arq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","بَصَّح هُوَ قال: \"أوّاه، يا سَعد اللي يَسَّمعو كْلام الله ويَعَّملو بيه.\" ");
INSERT INTO arq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","كي كان الغاشي يَتلايَم، بْدا يْقول: \"هاد الجيل جيل فاسَد، يَطلَب مارة وما تَتَّعطالو حَتّى مارة من غير مارة يونان النَبي، ");
INSERT INTO arq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","خاطَر كيما كان يونان مارة لناس نينَوى، هَكداك يْكون بن الإنسان تاني مارة لهاد الجيل. ");
INSERT INTO arq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","سَلطانة الجَنوب تْنوض في يوم الحْساب مع رْجال هاد الجيل وتَحكُم عليهُم خاطَر جات من طَرف الدَنيا باش تَسمَع حِكمة سُلَيمان وهاو هْنا اللي كْتَر من سُلَيمان. ");
INSERT INTO arq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","رْجال نينَوى يْنوضو فيوم الحْساب مع هاد الجيل ويَحَّكمو عليه خاطَر تابو ببْشارة يونان وهاو هْنا اللي كْتَر من يونان. ");
INSERT INTO arq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","حَتّى واحَد ما يَشعَل شَمعة ويْخَبّيها وَلاّ يْحَطها تَحت الكيل، يْحَطها على الشَنضال باش اللي يَدُّخلو يْشوفو الضو. ");
INSERT INTO arq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","نور الدات هِيَ العين. كي تْكون عينَك صْحيحة، داتَك كامَل تْكون مْنَّورة، بَصَّح كي تْكون عينَك مْريضة، داتَك تْكون مَضلامة. ");
INSERT INTO arq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","رَد بالَك يْعود يْكون الضو اللي فيك ضْلام. ");
INSERT INTO arq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","كي تْكون داتَك كامَل مْنَوّرة، ما فيها حَتّى جيهة مَضلامة، تْكون كامَل مْنَوّرة كيما كي تْضَوّي عليك الشَمعة بالضو مْتاعها\". ");
INSERT INTO arq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","كي كان يَهدَر، عَرضو واحَد الفَرّيسي باش ياكُل عَندو. دْخَل يَسوع وقْعَد على الميدة. ");
INSERT INTO arq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","بَصَّح الفَرّيسي سْتَغرَب كي شاف يَسوع ما غْسَلش قْبَل الماكلة. ");
INSERT INTO arq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","قاللو الرَب: \"أنتومَ الفَريسِيّين، تْنَقّيو الكاس والطَبسي من بَرّا بَصَّح من الداخَل راكُم مْعَمّرين بالطْمَع والشَر. ");
INSERT INTO arq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","يا الجايحين، اللي خْلَق بَرّا ما خْلَقش تاني الداخَل؟ ");
INSERT INTO arq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","صَدّقو واش عَندكُم، وكُل شي يْوَلّيلكُم نْقي. ");
INSERT INTO arq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","بَصَّح يا ويلكُم يا الفَريسِيّين، خاطَر تْعَشّرو على النَعناع والفيجلة وكامَل الخُضرة وتَنساو الحَق ومْحَبّة الله. كان لازَم تَعَّملو هاد الشي بلا ما تْخَلّيو الحاجات الأخرين. ");
INSERT INTO arq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","يا ويلكُم يا الفَريسِيّين خاطَر تْحَبّو الكْراسا الأوّلين فالمْجامَع والسْلام فالأَسواق، ");
INSERT INTO arq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","يا ويلكُم خاطَر أنتومَ كي القْبورة اللي ما يْبانوش واللي يَمشيو عليهُم الناس بلا ما يْفيقو\". ");
INSERT INTO arq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","جاوَب واحَد من شْيوخ الشَريعة وقاللو: \"شيخ، كي راك تْقول هاد الشي، حْنا تاني راك تْسَبّنا\"، ");
INSERT INTO arq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","قال يَسوع: \"يا ويلكُم أنتومَ تاني يا شْيوخ الشَريعة، خاطَر تْحَمّلو الناس حاجات واعرين للرْفود، وأنتومَ ما تْمَسّوهُمش بواحَد من صْباعتيكُم، ");
INSERT INTO arq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","يا ويلكُم، خاطَر تَبنيو قْبور الأَنبيا اللي قَتلوهُم جْدودكُم، ");
INSERT INTO arq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","وتَشَّهدو هَكدا لفْعال جْدودكُم وتَرضاو عليهُم خاطَر هومَ قَتلو الأَنبيا وأنتومَ تَبنيوَلهُم قْبورهُم، ");
INSERT INTO arq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","على هَدا تاني قالَت حِكمة الله: \"راني نَبعَتلهُم أنبيا ورُسُل، يَقَّتلو اللي يَقَّتلوهُم ويَحَّڤرو اللي يَحَّڤروهُم، ");
INSERT INTO arq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","باش نْحاسَب هاد الجيل على جال دَم كامَل الأَنبيا اللي سال من اللي نْخَلقَت الدَنيا، ");
INSERT INTO arq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","من دَم هابيل حَتّى لدَم زَكَريّا اللي نَقتَل بين المَدبَح وبيت المَقدَس. إيه، نْقولَلكُم، رايَح يَتحاسَب هاد الجيل. ");
INSERT INTO arq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","يا ويلكُم يا شْيوخ الشَريعة خاطَر أدّيتو مْفاتَح العَلم، أنتومَ ما دْخَلتوش واللي حَبّو يَدُّخلو، مْنَعتوهُم.\" ");
INSERT INTO arq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","كي خْرَج من تَمّة، بْداو الكُتّاب والفَريسِيّين يْضَيّقو عليه ويْهَدّروه على حاجات بَزّاف، ");
INSERT INTO arq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ويْديرولو الفَخّات باش يَحَّكمو عليه كاش كَلمة تَخرُج من فَمّو. ");
INSERT INTO arq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","في هَداك الوَقت، تْجَمَّع الغاشي بالأُلوف حَتّى وَلاّو هَدا يَعفَس على هَدا، وقال يَسوع للتابعين مْتاعو: \"قْبَل كُل شي، رَدّو بالكُم من خْميرة الفَريسِيّين اللي هِيَ التْنوفيق، ");
INSERT INTO arq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","خاطَر ما كانش حاجة مْخَبّية ما تْنَكشَفش وَلاّ سَرّية ما تْنَعرَفش، ");
INSERT INTO arq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","على هَدا، كامَل الشي اللي قُلتوه فالضَلمة رايَح يَنسمَع فالضو واللي قُلتوه فالوَدنين فالبْيوت رايَح يَتبَرَّح بيه فوق السْطوح، ");
INSERT INTO arq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","نْقولَلكُم ليكُم يا حْبابي، ما تْخافوش من اللي يَقَّتلو الدات ومن بَعد ما يَقَّدرو يْديرو حَتّى حاجة كْتَر، ");
INSERT INTO arq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","نْوَرّيلكُم شْكون لازَم تْخافو. خافو اللي بَعد ما يَقتَل، يَقدَر يَرمي في جَهَنَّم. إيه، نْقولَلكُم، هُوَ اللي لازَم تْخافوه. ");
INSERT INTO arq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ماشي خَمس زْواوَش يَتباعو بزوج صوردي؟ وواحَد فيهُم ماهو مَنسي عَند الله، ");
INSERT INTO arq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","وحَتّى شْعَر راسكُم مَحسوب كامَل. ما تْخافوش، تَسواو كْتَر من زْواوَش بَزّاف. ");
INSERT INTO arq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","نْقولَلكُم، كُل واحَد يَستَعرَف بيَّ قُدام الناس، يَستَعرَف بيه بْن الانسان قُدّام مْلايكة الله، ");
INSERT INTO arq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","واللي يَنكُرني قُدّام الناس، يَتَّنكَر قُدام مْلايكة الله، ");
INSERT INTO arq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","وكُل من يْقول كَلمة ضَد بْن الانسان يَتَّغفَرلو، بَصَّح اللي يَكفَر ضَد الروح القُدّوس ما يَتَّغفَرلوش. ");
INSERT INTO arq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","كي يَدّيوكُم للمْجامَع ولعَند الحُكّام والحُكومات ما تَتحَيّروش على كيفاش رايحين تْدافعو على روحكُم وَلاّ واش رايحين تْقولو، ");
INSERT INTO arq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","خاطَر الروح القُدّوس يْعَلَّمكُم في ديك الساعة واش لازَم تْقولو\". ");
INSERT INTO arq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","قال واحَد من الغاشي ليَسوع: \"شيخ، قول لخويَ يَقسَم معايَ الوَرت\"، ");
INSERT INTO arq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","جاوبو يَسوع: \"يا راجَل، شْكون حَطني عليكُم قاضي وَلاّ باش نَقسَمَّلكُم\"، ");
INSERT INTO arq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","وقالَلهُم: \"رَدّو بالكُم وعَسّو روحكُم من الطْمَع، خاطَر والو يْكون الواحَد مْرَفَّه، حْياتو ما تْكونلوش بشِيّو.\" ");
INSERT INTO arq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","وعْطالهُم هاد المْتَل وقال: \"كان واحَد الراجَل مْرَفَّه، جابَت الأَرض مْتاعو بَزّاف الغَلّة، ");
INSERT INTO arq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","بْقا يْخَمَّم في قَلبو: \"واش نْدير، خاطَر ما عَنديش مْكان نْلَم فيه الغَلّة مْتاعي؟\" ");
INSERT INTO arq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","أومبَعد قال: \"هاو واش نْدير: \"نْرَيَّب المْخازَن مْتاعي ونَبني واحَدُخرين كْبار عليهُم ونْلَم تَم كامَل القَمح وواش نَسعا، ");
INSERT INTO arq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ونْقول لنَفسي: \"يا نَفسي، عَندك خير كْبير مْخَبّي لعْوام طْوال، رَيّحي، كولي وأشَّربي وأفَّرحي.\"\" ");
INSERT INTO arq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","بَصَّح الله قاللو: \"يا الجايَح، هاد الليلة بالدات تَرجَع روحَك لعَند مولاها، والشي اللي وَجَّدتو، ليمَن يْوَلّي؟\" ");
INSERT INTO arq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","هَكدا اللي يْخَبّي الكْنوز لروحو وما يَتَّغناش عَند الله.\" ");
INSERT INTO arq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","وقال يَسوع للتابعين مْتاعو: \"على هَدا نْقولَلكُم: \"ما تَتحَيّروش على حْياتكُم واش تاكلو وَلاّ على داتكُم واش تَلَّبسو، ");
INSERT INTO arq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","خاطَر الحْياة ماشي غير الماكلة، والدات ماشي غير اللَبسة، ");
INSERT INTO arq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","شوفو الغَربان، ما يَزَّرعو، ما يَحَّصدو، وما عَندهُم لا مَخزَن لا سَدّة، والله يْطَعَّمهُم، وأنتومَ تَسواو كْتَر بَزّاف من الطْيور. ");
INSERT INTO arq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","شْكون فيكُم يَقدَر يْزيد بتَخمامو نَص ساعة لحْياتو؟ ");
INSERT INTO arq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","وَلاّ ما تَقَّدروش للحاجة الصْغيرة، عْلاش تَتحَيّرو على الباقي؟ ");
INSERT INTO arq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","شوفو كيفاش يْنوض السيسان، ما يَخدَم ما يَنسَج، ونْقولَلكُم باللي حَتّى سُلَيمان في كامَل شانو ما لْبَسش كيما واحَد فيهُم. ");
INSERT INTO arq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","وَلاّ الله يْكَسّي هَكدا الحْشيش اللي يْكون اليوم فالأحواش وغَدوة يَتَّرما فالكوشة، ماشي يْكَسّيكُم أنتومَ كْتَر يا قْلال الإيمان؟ ");
INSERT INTO arq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","أنتومَ ما تْخَمّموش على واش تاكلو وواش تَشَّربو وما تَتقَلقوش، ");
INSERT INTO arq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","خاطَر هاد الحاجات، ناس الدَنيا هومَ اللي يْحَوّسو عليهُم، بَصَّح أنتومَ، باباكُم راهو عارَف باللي تَسَّحقوهُم. ");
INSERT INTO arq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","حَوّسو على مَلَكوت الله وهاد الحاجات كامَل يَنزادولكُم. ");
INSERT INTO arq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ما تْخافش يا القْطيع الصْغير، خاطَر باباكُم حَب يَعطيلكُم المَلَكوت، ");
INSERT INTO arq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","بيعو واش عَندكُم وصَدقوه. ديرو لروحكُم مال ما يَقدامش وكَنز ما يَخلاصش فالسْماوات وين السَرّاق ما يَدَّنّاش والسوسة ما تاكُلش، ");
INSERT INTO arq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","خاطَر وين يْكون كَنزكُم، تَم يْكون قَلبكُم تاني. ");
INSERT INTO arq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","لازَم يْكونو كْلاويكُم مْحَزّمين وكانكيّاتكُم شاعلين، ");
INSERT INTO arq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","وأنتومَ كونو كيما الناس اللي يَستنّاو سيدهُم يَرجَع من العَرس باش غير يَوصَل ويْطَبطَب يْحَلّولو. ");
INSERT INTO arq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","يا سَعدهُم هَدوك الخَدّامين اللي كي يْجي سيدهُم يَلقاهُم سَهرانين، نْقولَلكُم الصَح، يَتحَزَّم ويْقَعَّدهُم على الميدة ويْجي يَخدَمهُم، ");
INSERT INTO arq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","يْجي بعد المَغرب وَلاّ في نَص الليل، يا سَعدهُم لو كان يَلقاهُم سَهرانين. ");
INSERT INTO arq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","أعَّرفو مْليح باللي لو كان مول الدار يَعرَف واش من الساعة يْجي السَرّاق، ما يْخَلّيهش يَدخُل لدارو. ");
INSERT INTO arq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","أنتومَ تاني، كونو واجدين، خاطَر فالوَقت اللي ما تْديروهش في بالكُم يْجي بْن الإنسان.\" ");
INSERT INTO arq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","قاللو بُطرُس: \"رَبّي، لينا تْقول هاد المْتَل وَلاّ للناس كامَل؟\" ");
INSERT INTO arq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","قال الرَب: \"شْكون هُوَ الوْكيل الحْلالي العاقَل اللي يْوَكّلو سيدو على ناسو باش يَعطيلهُم حَقهُم مْتاع الماكلة فالوَقت؟ ");
INSERT INTO arq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","يا سَعدو هَداك الخَدّام اللي كي يْجي سيدو يَلقاه يْدير هَكدا، ");
INSERT INTO arq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","نْقولَلكُم الصَح، رايَح يْوَكّلو على كامَل مْلاكو. ");
INSERT INTO arq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","بَصَّح لوكان هَداك الخَدّام يْقول في قَلبو: \"سيدي يَبطا باش يْجي، ويَبدا يَضرَب فالخَدّامين والخَدّامات، وياكُل ويَشرُب ويَسكَر، ");
INSERT INTO arq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","يْجي سيدو فاليوم اللي ما يْديروش في بالو، وفالساعة اللي ما يْكونش عارَفها، ويْحاوزو ويَعطيلو حَقّو مع الخاينين. ");
INSERT INTO arq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","هَداك الخَدّام اللي يَعرَف واش يْحَب سيدو وما يْوَجَّدش روحو وما يْديرش واش يْحَب سيدو، هَداك يَتَّضرَب بَزّاف، ");
INSERT INTO arq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","بَصَّح اللي ما يْكونش عارَف، ويْدير حاجة يَستاهَل عليها الضَرب، يَتَّضرَب شْويّة. اللي يَتَّعطالو بَزّاف، يَتَّطلَب منّو بَزّاف، واللي يَتوَكَّل على حاجة كْبيرة، يَتَّطلَب منّو كْتَر. ");
INSERT INTO arq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","جيت نَشعَل نار فوق الأَرض، وشْحال مادابيَّ لو كان تْكون شَعلَت، ");
INSERT INTO arq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","لازَم نَتعَمَّد بواحَد المَعمودِيّة وشْحال راني مْقَلَّق باش تَكمَل. ");
INSERT INTO arq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","تَحَّسبو باللي جيت نْجيب السْلام فوق الأَرض؟ لالا، نْقولَلكُم بالعَكس، جيت نْجيب الفْراق. ");
INSERT INTO arq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","خاطَر من اليوم، خَمسة في دار يْكونو مَقسومين: تْلاتة ضَد زوج وزوج ضَد تْلاتة، ");
INSERT INTO arq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","يَنقَسمو، الباباة ضَد الوْلَد والوْلَد ضَد الباباة، اليَمّاة ضَد البَنت والبَنت ضَد اليَمّاة، العْجوزة ضَد العْروسة والعْروسة ضَد العْجوزة.\" ");
INSERT INTO arq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","قال تاني للغاشي: \"كي تْشوفو سْحابة طالعة من الغَرب، تَم تَم تْقولو رايحة تْصَب الشْتا، والشْتا تْصَب، ");
INSERT INTO arq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","وكي تْشوفو الريح يْنوض من الجَنوب، تْقولو رايحة تْجي السْخانة، وتْجي السْخانة. ");
INSERT INTO arq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","مُنافقين، تَعَّرفو تْمَيّزو حال الأَرض والسْما، كيفاش هِمّالا ما تَعَّرفوش تْمَيّزو هاد الزْمان؟ ");
INSERT INTO arq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","وَعلاش ما تْمَيّزوش وَحَّدكُم وين راه الصْلاح؟ ");
INSERT INTO arq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","كي تْكون رايَح مع عْدوك لعَند الحاكَم، دير مَجهودَك وأنتَ فالطْريق معاه باش تَسلَك منّو، يْعود يْكَركرَك لعَند القاضي، والقاضي يْسَلّمَك للشُرطي والشُرطي يَرميك فالحَبس، ");
INSERT INTO arq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","نْقوللَك، راك ما تَخرُجش من تَم حَتّى تْرَد الصوردي الأخراني\". ");
INSERT INTO arq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","في هَداك الوَقت، وَصلو ناس خَبّرو يَسوع على واحَد الجْليلِيّين خَلَّط بيلاطَس دَمهُم مع دَم دْبايَحهُم. ");
INSERT INTO arq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","جاوَب يَسوع وقالَلهُم: \"راكُم حاسبين باللي هاد الجْليلِيّين كانو خاطيين كْتَر من كامَل الجْليلِيّين الأُخرين كي تْعَدبو هَكدا؟ ");
INSERT INTO arq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","لالا نْقولَلكُم، لو كان ما تْتوبوش، رايحين تْموتو كامَل كيما هومَ، ");
INSERT INTO arq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","وَلاّ هَدوك التْمَنطاش اللي طاح عليهُم البُرج في سَلوام وقْتَلهُم، راكُم حاسبين باللي دارو الدْنوب كْتَر من كامَل الناس اللي يَسُّكنو في أورشَليم؟ ");
INSERT INTO arq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","لالا نْقولَلكُم، بَصَّح لو كان ما تْتوبوش، رايحين تْموتو كامَل كيما هومَ.\" ");
INSERT INTO arq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","زاد قال هاد المْتَل: \"واحَد الراجَل كانَت عَندو كَرمة مَغروسة فالدالية مْتاعو، راح يْجيب منها فاكية بَصَّح ما لْقاش، ");
INSERT INTO arq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","قال للفَلاّح المَستَكلَف بالدالية: \"عَندي تَلت سْنين وأنا نْجي نَدّي الفاكية من هاد الكَرمة وما نَلقاش. قَطَّعها، وَعلاش راهي حاكمة الأَرض بلا فايدة؟\" ");
INSERT INTO arq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","جاوَب الفَلاّح: \"سيدي، زيد خَلّيها هاد العام تاني، نَحفَر سايَر دايَر عليها ونْحَطَّلها الغْبار، ");
INSERT INTO arq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","بَلاك تْجيب الفاكية منّا للفوق، وَلاّ ما كانش، قَطَّعها\"\". ");
INSERT INTO arq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","كان يَسوع يْدَرَّس في واحَد من المْجامَع فالسَبت، ");
INSERT INTO arq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","وكانَت تَمّة واحَد المْرا عندها روح معَيَّبها من تْمَنطاشَن سْنة. كانَت عَندها حَدبة وما تَقدَرش كامَل تَوقَف مْسَلّسة. ");
INSERT INTO arq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","كى شافها يَسوع عَيَّطلها وقالَلها: \"يا مْرا، راكي سالكة من العيب اللي فيك\"، ");
INSERT INTO arq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ودار يَدّيه عليها وتَم تَم تْسَلّسَت وسَبحَت الله. ");
INSERT INTO arq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","بَصَّح، رايَس المَجمَع مْغَشَّش كي داوا يَسوع فالسَبت، قال للغاشي: \"كايَن سَت أيَام للخَدمة، أرواحو تَتدّاواو فيهُم وماشي في يوم السَبت\". ");
INSERT INTO arq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","جاوبو الرَب وقال: \"مُنافقين، ماشي كُل واحَد فيكُم يْحَل الحْبيلة للفَرد وَلاّ للحْمار مْتاعو من المَدوَد ويَدّيهُم يَشُّربو، ");
INSERT INTO arq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","وهاد المْرا اللي هِيَ بَنت إبراهيم، واللي كان رابَطها الشيطان من تْمَنطاشَن سَنة، ما كانش لازَم تَنحَل من الرْباط في يوم السَبت؟\" ");
INSERT INTO arq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","كي هْدَر هَكدا، حَشمو كامَل اللي كانو ضَدّو، والغاشي كامَل فْرَح بالحاجات الكْبار اللي كان يْديرهُم. ");
INSERT INTO arq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","وقال يَسوع: \"لواش يْشَبَّه مَلَكوت الله وباش نْشَبّهو؟ ");
INSERT INTO arq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","يْشَبَّه لزَرّيعة خَردَل، أدّاها بْنادَم وغْرَسها في جْنانو، ناضَت ووَلاّت سَجرة كْبيرة وعَشّشو طْيور السْما في غْصانها.\" ");
INSERT INTO arq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","وزاد قال: \"باش نْشَبَّه مَلَكوت الله؟ ");
INSERT INTO arq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","يْشَبَّه لخْميرة أدّاتها مْرا ودارَتها في تَلت كيلات فَرينة حَتّى تَخمَر كامَل العْجينة.\" ");
INSERT INTO arq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","وكان يَسوع في طْريقو لأورشَليم يْجوز على المْدايَن والدْشور يْدَرَّس. ");
INSERT INTO arq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","قاللو واحَد: \"رَبّي، كايَن غير ناس قْلال اللي رايحين يَسَّلكو؟\" قالَلهُم: ");
INSERT INTO arq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","\"ديرو مَجهودكُم باش تَدُّخلو من الباب الضَيقة، خاطَر نْقولَلكُم كايَن بَزّاف اللي رايحين يْحَوسو يَدَّخلو وما يَقَّدروش، ");
INSERT INTO arq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","بَعد ما مول الدار يْنوض ويَغلَق الباب وتَبداو أنتومَ اللي واقفين بَرّا تْطَبطبو فالباب وتْقولو: \"رَبّي، حَل لنا\". يْجاوَب ويْقولَلكُم: \"ما نَعرَفكُمش منين أنتومَ\"، ");
INSERT INTO arq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","داك الوَقت تَبداو تْقولو: \"كْلينا وشْرَبنا قُدّامَك ودَرَّست في طُرقاننا\"، ");
INSERT INTO arq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","يْجاوَب: \"نْقولهالكُم، ما نَعرَفكُمش منين أنتومَ، بَعّدو علِيَّ يا فاعلين الشَر\"، ");
INSERT INTO arq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","تَم اللي يْكون البْكا وغَز السْنان. كي تْشوفو إبراهيم وإسحاق ويَعقوب وكامَل الأَنبيا في مَلَكوت الله وأنتومَ مَرميّين بَرّا. ");
INSERT INTO arq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ويْجيو من المَشرَق والمَغرَب، من الشَمال والجَنوب، ويَقَّعدو على الميدة في مَلَكوت الله، ");
INSERT INTO arq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ويْكون اللي الأخرانِيّين يْوَلّيو الأولانِيّين، والأولانِيّين يْوَلّيو الأخرانِيّين.\" ");
INSERT INTO arq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","في هَديك الساعة، جاو واحَد الفَريسِيّين يْقولولو: \"أخرُج وروح من هْنا، خاطَر هيرودَس راه حاب يَقُّتلَك\"، ");
INSERT INTO arq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","قالَلهُم: \"روحو وقولو لهَداك التَعلَب، راني نْخَرَّج الشْياطَن ونَشفي اليوم وغَدوة والنْهار التالَت نْكَمَّل، ");
INSERT INTO arq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","خاطَر لازَم نْكَمَّل طْريقي اليوم وغَدوة واليوم اللي من بَعد، خاطَر ما والمَتش يْموت نَبي بَرّا على أورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","يا أورشَليم، يا أورشَليم، يا قَتّالة الأَنبيا ورَجّامة المَرسولين ليها، شْحال من مَرّة حَبّيت نْلَم وْلادَك كيما تْلَم الجاجة فْلالَسها تَحت جْناحتيها وما حَبّيتوش. ");
INSERT INTO arq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","هايليك داركُم باقيَتَّلكُم، ونْقولهالكُم، ما تْزيدوش تْشوفوني حَتّى يْجي الوَقت وين تْقولو: \"مْبارَك اللي جاي بآسَم الرَب\". ");
INSERT INTO arq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","واحَد المَرّة، في يوم سَبت، دْخَل يَسوع لدار واحَد من رِيّاس الفَرّيسِيّبن باش ياكُل وكانو الفَريسِيّين يْعَسّو فيه، ");
INSERT INTO arq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","وكان قُدّامو واحَد الراجَل عَندو الما في داتو. ");
INSERT INTO arq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","نْطَق يَسوع وقال لشْيوخ الشَريعة والفَريسِيّين: \"يْجوز لواحَد يْداوي فالسَبت وَلاّ لالا؟\" ");
INSERT INTO arq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","بَصَّح هومَ بْقاو ساكتين، وشَد يَسوع هَداك الراجَل وشْفاه وخَلاّه يْروح. ");
INSERT INTO arq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","وقالَلهُم: \"شْكون فيكُم لو كان يْطيح وْليدو وَلاّ الفَرد مْتاعو فالبير، ما يَجَّبدوش بالخَف في يوم السَبت؟\" ");
INSERT INTO arq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ما قَدروش يْجاوبوه على هاد الشي. ");
INSERT INTO arq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ومَد للضْياف مْتَل كي شافهُم كيفاش يْخَيّرو الكْراسا الأوّلين وقالَلهُم: ");
INSERT INTO arq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"كي تْكون مَعروض من عَند كاش واحَد لعَرس، ما تْروحش تَقعَد فالكُرسي الأوَّل، يْعود يْكون فالناس اللي مَعروضين واحَد خير منَّك، ");
INSERT INTO arq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ويْجي اللي عْرضكُم في زوج ويْقولَك: \"خَلّيلو الكُرسي مْتاعك\". داك الوَقت، تْروح مَبخوص تَقعَد فالكُرسي الأخراني. ");
INSERT INTO arq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","بَصَّح، كي يَعَّرضوك، روح تَقعَد فالكُرسي الأخراني، باش كي يْجي اللي عَرضَك يْقولَك: \"صاحبي، روح للقُدّام\"، هاد الشي يْشَرفَك قُدّام كامَل اللي يْكونو معاك على الميدة. ");
INSERT INTO arq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","خاطَر اللي يَحسَب روحو تْطيح قيمتو، واللي ماشي حاسَب روحو، تَندارلو القيمة.\" ");
INSERT INTO arq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","وقال تاني للي عَرضو: \"كي تْدير فْطور وَلاّ عْشا، ما تَعرَضش صْحابَك وَلا خاوتَك وَلا مْواليك وَلا الجيران المْرَفّهين يْعودو يَعَّرضوك هومَ تاني ويْرَدّولَك خيرَك، ");
INSERT INTO arq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","بَصَّح كي تْدير الضْيافة، أعرَض الڤْلالين، العايبين، الكَعوانين والعَميين. ");
INSERT INTO arq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","يْكونلَك السَعد على جال اللي ما عَندهُمش باش يْرَدّولَك، خاطَر يَترَدلَك في قِيامة الصالحين.\" ");
INSERT INTO arq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","كي سْمَع واحَد من اللي كانو قاعدين على الميدة هاد الكْلام قال ليَسوع: \"يا سَعد اللي ياكُل لُقمة في مَلَكوت الله\"، ");
INSERT INTO arq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","قاللو يَسوع: \"واحَد الراجَل دار عْشا كْبير وعْرَض ناس بَزّاف، ");
INSERT INTO arq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","في وَقت العْشا، بْعَت الخْديم مْتاعو يْقول للمَعروضين: \"أرواحو، راه كُل شي واجَد\". ");
INSERT INTO arq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","بَصَّح، كامَل بْداو يَطَّلبو السْماح، الأوَّل قاللو: \"شْريت حوش ولازَم نْروح نْشوفو، غير أعفيني\"، ");
INSERT INTO arq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","واحَدآخُر قال: \"شْريت خَمس زْواج مْتاع الفْراد وراني رايَح نْجَرَّبهم، غير أعفيني\"، ");
INSERT INTO arq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","وواحَدآخُر قال: \"غير كيما تْزَوَّجت وعلى هَدا ما نَقدَرش نْجي\". ");
INSERT INTO arq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","كي رْجَع الخْديم وخَبَّر سيدو بهاد الشي، تْغَشَّش السِيَّد وقال لخْديمو: \"أَخرُج بالخَف للحْوَم مْتاع المْدينة وزْنايَقها وجيب اللَهنا الڤْلالين، العايبين، الكَعوانين والعَميين\". ");
INSERT INTO arq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","قال الخْديم: \"سيدي، الشي اللي آمَرت بيه نْدار، ومازال كايَن الوْسَع\". ");
INSERT INTO arq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","قال السِيَّد للخْديم: \"أخرُج للطُرقان ووين كايَن الزْرَب واللي تَلقاهُم وَكَّد عليهُم باش يَدُّخلو لعَندي حَتّى تَتعَمَّر داري، ");
INSERT INTO arq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","خاطَر نْقولَلكُم، حَتّى واحَد من اللي كانو مَعروضين ما يْدوق عْشايَ\"\". ");
INSERT INTO arq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","غاشي كْبير كان يَمشي مع يَسوع، دار وقالَلهُم: ");
INSERT INTO arq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"لو كان يْجي واحَد لعَندي وما يَكرَهش باباه ويَمّاه ومَرتو ووْلادو وخاوتو وخْواتاتو وحَتّى حْياتو، ما يَقدَرش يْكون التابَع مْتاعي، ");
INSERT INTO arq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","واللي ما يَرفَدش صْليبو ويْتَبَّعني ما يَقدَرش يْكون التابَع مْتاعي، ");
INSERT INTO arq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","خاطَر شْكون فيكُم، كي يْحَب يَبني بُرج، ما يَقعَدش قْبَل ويَحسَب شْحال يَستقاملو ويْشوف وَلاّ عَندو باش يْكَمّلو، ");
INSERT INTO arq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","يْعود بَعد ما يْدير اللْساس، ما يَقدَرش يْكَمَّل، ويَبداو كامَل اللي شافوه يَتمَسخرو بيه، ");
INSERT INTO arq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ويْقولو: \"هاد الإنسان بْدا يَبني وما قْدَرش يْكَمَّل\". ");
INSERT INTO arq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","وَلاّ واش من السَلطان، كي يْكون رايَح يْحارَب سَلطان واحَدآخُر، ما يَقعَدش قْبَل ويْشوف وَلاّ يَقدَر بعَشر آلاف راجَل يْقابَل اللي راهو جاي يَزدَم عليه بعَشرين أَلف؟ ");
INSERT INTO arq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","وَلاّ شاف روحو ما يَقدَرش، يَبعَت مْراسَل للسَلطان الآخُر بيدما راهو بْعيد، يَطلَب منّو الصُلح. ");
INSERT INTO arq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","هَكدا، كُل واحَد فيكُم ما يَسمَحش في كُل واش يَسعا ما يَقدَرش يْكون التابَع مْتاعي. ");
INSERT INTO arq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","المَلح مْليح، بَصَّح لو كان تْروحلو البَنّة مْتاعو، باش نْرَجّعولوهالو؟ ");
INSERT INTO arq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","يَرميوَه بَرّا خاطَر ما يْوَلّي يَصلَح لا للأَرض، لا للغْبار. اللي عَندو وَدنين باش يَسمَع، غير يَسمَع\". ");
INSERT INTO arq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","كانو كامَل المَكّاسين والخاطيين يْقَرّبو من يَسوع باش يَسَّمعولو. ");
INSERT INTO arq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","بْداو الفَريسِيّين والكُتّاب يْدَمدمو ويْقولو: \"هَدا يَستَقبَل الخاطيين وياكُل معاهُم\". ");
INSERT INTO arq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","مَدَّلهُم هاد المْتَل وقال: ");
INSERT INTO arq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"شْكون فيكُم، لو كان يْكونو عَندو مْية خْروف ويَتبَحَّرلو واحَد، ما يْخَلّيش التَسعة وتَسعين فالخْلا ويْروح يْحَوَّس على هَداك اللي تْبَحَّرلو حَتّى يَلقاه؟ ");
INSERT INTO arq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","وكي يَلقاه يْحَطّو على كْتافو وهُوَ فَرحان، ");
INSERT INTO arq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","وكي يْوَلّي لدارو، يْعَيَّط لصْحابو وجيرانو ويْقولَلهُم: \"أفَّرحو معايَ خاطَر راني لْقيت الخْروف اللي تْبَحَّرلي\". ");
INSERT INTO arq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","نْقولَلكُم باللي هَكدا تْكون الفَرحة فالسْما على جال واحَد خاطي يْتوب كْتَر من اللي تْكون لتَسعة وتَسعين صالحين ما يَسَّحقوش التوبة. ");
INSERT INTO arq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","وَلاّ واش من المْرا اللي يْكونو عَندها عَشر فْراكات ويَتبَحَّرلها فْراك واحَد ما تَشعَلش الضو وتُكنَس الدار وتْحَوَّس مْليح حَتّى تَلقاه؟ ");
INSERT INTO arq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","وكي تَلقاه، تْعَيَّط لحْباباتها وجاراتها وتْقول: \"أفَّرحو معايَ خاطَر راني لْقيت الفْراك اللي تْبَحَّرلي\". ");
INSERT INTO arq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","وهَكدا نْقولَلكُم تْكون الفَرحة قُدّام مَلايكة الله كي يْتوب واحَد خاطي.\" ");
INSERT INTO arq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","وزاد قال: \"واحَد الراجَل كان عَندو زوج وْلاد، ");
INSERT INTO arq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","قال الصْغير فيهُم لباباه: \"بابا، أعطيني نْصيبي اللي راني رايَح نَوَّرتو\". وقْسَمَّلهُم باباهُم المَلك مْتاعو. ");
INSERT INTO arq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","بَعد يامات قْلال، لَم الوْلَد الصْغير شَيّو كامَل وسافَر لبْلاد بْعيدة وين رْما دْراهمو وهُوَ عايَش بلا راي. ");
INSERT INTO arq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","بَعد ما صْرَف كُل شي، جات مَجاعة كْبيرة في هَديك البْلاد، وبْدا يَلقا روحو فالحوج. ");
INSERT INTO arq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","راح يَخدَم عَند واحَد من ناس هَديك البْلاد، بَعتو للأحواش مْتاعو يَرعا الحْلالَف. ");
INSERT INTO arq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","وكان يَتشَهّا يْعَمَّر كَرشو من الخَرّوب اللي كانو ياكلوه الحْلالَف بَصَّح حَتّى واحَد ما كان يَعطيلو منّو. ");
INSERT INTO arq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","تْكاكا مع روحو وقال: \"شْحال من خَدّام عَند بابا عَندو الخُبز بالشَبعة، وأنايَ راني نْموت بالجوع. ");
INSERT INTO arq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","نْنوض، نْروح عَند بابا ونْقوللو: \"يا بابا، راني غْلَطت في حَق السْما وفي حَقَّك، ");
INSERT INTO arq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","وما نَستاهَلش نْزيد نَتسَمّا وْليدك، ديرني كي واحَد من الخَدّامين مْتاعك\"\". ");
INSERT INTO arq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ناض وراح لعَند باباه. وكي كان مازالو بْعيد، شافو باباه وحَن عليه وراح يَجري، عَنّقو وباسو. ");
INSERT INTO arq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","قاللو وْليدو: \"بابا، غْلَطت في حَق السْما وفي حَقَّك، وما نَستاهَلش نْزيد نَتسَمّا وْليدَك\"، ");
INSERT INTO arq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","بَصَّح باباه قال للخَدّامين مْتاعو: \"غاولو، جيبو الڤَندورة المْخَيّرة ولَبّسوهالو، ديرولو خاتَم في صَبعو وصْبابَط في رَجليه، ");
INSERT INTO arq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","وجيبو الوَكريف السْمين وأدَّبحوه. هَيّا ناكلو ونَفَّرحو، ");
INSERT INTO arq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","خاطَر وْليدي هَدا كان مِيَّت وعاوَد حْيا، كان مْبَحَّر ولْقيناه\". وبْداو يَفَّرحو. ");
INSERT INTO arq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ووْليدو الكْبير كان فالحوش. كي رْجَع ووْصَل قْريب للدار، سْمَع الجوق والغْنا، ");
INSERT INTO arq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","وعَيَّط لواحَد من الخَدّامين وسَقساه واش كايَن. ");
INSERT INTO arq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","قاللو هَداك الخَدّام: \"خوك رْجَع وباباك دْبَح الوَكريف السْمين خاطَر عاوَد شافو بخير\". ");
INSERT INTO arq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","زْعَف الوْلَد وكي ما حَبش يَدخُل خْرَج باباه وحَب يْدَخّلو. ");
INSERT INTO arq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","جاوَب وقال لباباه: \"شْحال من عام وأنا نَخدَم فيك، عُمري ما عْصيتَك في حاجة، وعُمرَك ما عْطيتني حَتّى عَتروس باش نَزها مع صْحابي. ");
INSERT INTO arq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","بَصَّح، كي جا وْليدَك، هَداك اللي كْلا دْراهمَك مع الزانيات، ليه اللي دْبَحت الوَكريف السْمين\". ");
INSERT INTO arq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","قاللو باباه: \"يا وْليدي، أنتَ راك دايمًا معايَ، شِيّي هُوَ شِيَّك، ");
INSERT INTO arq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","بَصَّح، كان لازَم نَفَّرحو ونَزهاو خاطَر خوك هَدا كان مِيَّت وعاوَد حْيا، كان مْبَحَّر ولْقيناه.\" ");
INSERT INTO arq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","زاد قال يَسوع للتابعين: \"واحَد الراجَل مْرَفَّه، كان عَندو وْكيل، بَيّعوه باللي كان يْبَدَّرلو دْراهمو. ");
INSERT INTO arq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","عَيَّطلو وقاللو: \"واش هاد الشي اللي سْمَعتو عليك، جيب الحْساب مْتاع وْكالتَك، خاطَر ما تْزيدش تْكون وْكيل على شَيّي\". ");
INSERT INTO arq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","قال الوْكيل في قَلبو: \"واش نْدير كي نَحّالي المْعَلَّم مْتاعي الوْكالة؟ نَخدَم الأَرض؟ ما نَقدَرش، نَطلَب؟ نَحشَم. ");
INSERT INTO arq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","راني عارَف واش نْدير باش يَقَّبلوني الناس في دْيورهُم كي نَتحاوَز من خَدَّمتي\". ");
INSERT INTO arq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","عَيَّط لكامَل اللي كان المْعَلَّم مْتاعو يْسالَلهُم واحَد واحَد وقال للأوَّل: \"شْحال يْساللَك المْعَلَّم مْتاعي؟\" ");
INSERT INTO arq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","قاللو: \"مْية كيلة مْتاع الزيت\"، قاللو: \"شَد الوَرقة مْتاعك، أقعَد بالخَف وأكتَب خَمسين\"، ");
INSERT INTO arq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","وقال لواحَدآخُر: \"وأنتَ شْحال يْساللَك؟\" قاللو: \"مْية كيلة مْتاع القَمح\"، قاللو: \"شَد الوَرقة مْتاعك وأكتَب تْمانيين\". ");
INSERT INTO arq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","المْعَلَّم شْكَر الوْكيل الخايَن على شْطارتو، خاطَر ناس الدَنيا شاطرين مع اللي بْحالهُم كْتَر من وْلاد النور. ");
INSERT INTO arq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","وأنايَ نْقولَلكُم: ديرو الصْحاب بالمال الدوني باش لو كان تَنخَصّو، يَقَّبلوكُم فالدْيور الدايمين. ");
INSERT INTO arq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","اللي يْكون حْلالي فالقْليل، يْكون حْلالي فالكْتير، واللي يْخون فالقْليل، يْخون فالكْتير. ");
INSERT INTO arq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","وَلاّ ما كُنتوش حْلاليّين فالمال الدوني، شْكون يامَنكُم على المال الحَقّاني؟ ");
INSERT INTO arq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","وَلاّ ما كُنتوش حْلاليّين في حاجة غيركُم، شْكون يَعطيلكُم حاجَتكُم؟ ");
INSERT INTO arq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","حَتّى خَدّام ما يَقدَر يَخدَم زوج سْياد، خاطَر يا يَكرَه واحَد ويْحَب الآخُر، يا يَتعَلَّق بواحَد ويَسمَح في الآخُر. ما تَقَّدروش تَخَّدمو الله والدْراهَم\". ");
INSERT INTO arq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","الفَريسِيّين كانو يَسَّمعو هاد الشي كامَل وكانو يَتمَسخرو بيه خاطَر كانو يْحَبّو الدْراهَم. ");
INSERT INTO arq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","قالَلهُم يَسوع: \"أنتومَ، تْحَبّو تْبَيّنو روحكُم صالحين قُدّام الناس، بَصَّح الله يَعرَف قْلوبكُم، خاطَر اللي عَندو قيمة عَند الناس مَكروه عَند الله، ");
INSERT INTO arq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","الشَريعة والأَنبيا دامو حَتّى لزْمان يوحَنّا، من داك الوَقت بْدات البْشارة بمَلَكوت الله، وكُل واحَد يَستَعمل القُوّة باش يَدخُل ليه. ");
INSERT INTO arq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ساهَل كْتَر للسْما والأَرض باش يْزولو، من حَرف صْغير واحَد من الشَريعة باش يْطيح. ");
INSERT INTO arq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","كُل واحَد يْطَلَّق مَرتو ويَتزَوَّج بواحَدُخرى زاني، واللي يَتزَوَّج بمْرا مْطَلّقة من راجَلها زاني\". ");
INSERT INTO arq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","كان واحَد الراجَل مْرَفَّه، يَلبَس غير الحْوايَج الغاليين والحْرير، وكان كُل يوم يَتنَعَّم ويَزها. ");
INSERT INTO arq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","وكان واحَد الڤَلّيل، واسمو لِعازَر، مَرمي عَند بابو، مْعَمَّر بالقْروح. ");
INSERT INTO arq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","كان يَتشَهّا يْعَمَّر كَرشو بالفْتات اللي كان يْطيح من ميدة المْرَفَّه، وحَتّى الكْلاب كانو يْجيو يَلَّحسو القْروح مْتاعو. ");
INSERT INTO arq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","مات الڤَلّيل ورَفدوه المَلايكة لحُضن إبراهيم، المْرَفَّه تاني مات ونْدفَن. ");
INSERT INTO arq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","في مَسكَن الموتى، رْفَد المْرَفَّه عينيه وفالوَقت اللي كان هُوَ يَتعَدَّب شاف إبراهيم من البْعيد ولِعازَر في حُضنو. ");
INSERT INTO arq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","عَيَّط وقال: \"يا بابا إبراهيم، أرحَمني وأبعَت لِعازَر باش يْشَمَّخ طَرف صَبعو فالما ويْبَرَّدلي لْساني خاطَر راني نَتعَدَّب في هاد اللْهيب\". ");
INSERT INTO arq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","قاللو إبراهيم: \"يا وْليدي، أتفَكَّر باللي أنتَ أدّيت مْلاكَك في حْياتَك، ولِعازر أدّا الوْجاع في حْياتو، دُرك هُوَ راهو يَتهَنّا، وأنتَ راك تَتعَدَّب. ");
INSERT INTO arq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","وزيد بزْيادة، نْدار بيننا وبينكُم زَرداب كْبير، باش اللي يْحَبّو يْجوزو من هنا لعَندكُم ما يَقَّدروش، واللي يْحَبّو يَقَّطعو من عَندكُم لعَندنا ما يَقَّدروش\". ");
INSERT INTO arq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","قال المْرَفَّه: \"نَطلَب منَّك يا بابا إبراهيم تَبعَت لِعازَر لدار بابا، ");
INSERT INTO arq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","خاطَر عَندي خَمس خاوة، يْخَبَّرهُم باش ما يْجيوش لهاد المَضرَب مْتاع العْداب\". ");
INSERT INTO arq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","قاللو إبراهيم: \"عَندهُم موسى والأَنبيا، ما عليهُم غير يَسَّمعولهُم\". ");
INSERT INTO arq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","قال: \"لالا يا بابا إبراهيم، بَصَّح لو كان يْروح ليهُم واحَد من الموتى، يْتوبو\". ");
INSERT INTO arq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","قاللو إبراهيم: \"وَلاّ ما سَمعوش لموسى والأَنبيا، حَتّى لو كان يْنوض ليهُم واحَد من الموتى ما راهُمش رايحين يَتقَنّعو\"\". ");
INSERT INTO arq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","قال يَسوع للتابعين مْتاعو: \"مُحال ما يْكونوش العَترات، بَصَّح يا ويلو اللي يْكون سْبابهُم، ");
INSERT INTO arq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","لو كان يْحَطّولو حَجرة الرْحا في رَقَّبتو ويَرميوَه فالبْحَر، خيرلو من اللي يْعَتَّر واحَد من هَدوك الصْغار. ");
INSERT INTO arq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","رَدّو بالكُم على روحكُم: وَلاّ غْلَط معاك خوك، لومو، وَلاّ تاب سامحو، ");
INSERT INTO arq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","وَلاّ غْلَط معاك سْبَع مَرّات فالنْهار، ورْجَع ليك سْبَع مَرّات يْقول: راني تايَب، سامحو.\" ");
INSERT INTO arq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","قالو الرُسُل للرَب: \"قَوّي إيماننا\". ");
INSERT INTO arq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","قال الرَب: \"لو كان يْكون عَندكُم إيمان قَد زَرّيعة الخَردَل، تْقولو لهاد السَجرة مْتاع التوت: \"أتقَلّعي وأنغَرسي فالبْحَر\" تْطيعكُم. ");
INSERT INTO arq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","شْكون فيكُم يْكون عَندو خْديم، يَحرَت الأَرض وَلاّ يَرعا المال، يْقوللو كي يَرجَع من الحوش: أرواح بالخَف وأقعَد على الميدة، ");
INSERT INTO arq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ماشي يْقوللو: وَجَّدلي العْشا، أتحَزَّم وأخدَمني حَتّى ناكُل ونَشرَب، ومن بَعد تاكُل وتَشرَب أنتَ. ");
INSERT INTO arq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","هَداك الخْديم عَندو المْزِيّة كي يْدير الشي اللي مَلزوم عليه؟ ");
INSERT INTO arq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","أنتومَ تاني، كي تْديرو كامَل الشي اللي مَلزوم عليكُم، قولو: حْنا خَدّامين بلا فايدة، دَرنا غير اللي لازَم علينا\". ");
INSERT INTO arq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","كان يَسوع رايَح لأورشَليم، وجايز بين السامرة والجْليل. ");
INSERT INTO arq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","كي جا داخَل لواحَد الدَشرة، سْتقبلوه عَشر رْجال عَندهُم البْرَص. وَقفو من البْعيد، ");
INSERT INTO arq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","وعَيّطو وقالو: \"يَسوع، سيدي، حَن علينا\"، ");
INSERT INTO arq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","غير شافهُم، قالَلهُم: \"روحو وَرّيو روحكُم لرْجال الدين\". وكي كانو رايحين طَهرو. ");
INSERT INTO arq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","واحَد منهُم، كي شاف روحو بْرا، رْجَع وهُوَ يْسَبَّح فالله بالزور، ");
INSERT INTO arq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","سْجَد عَند رَجلين يَسوع وشَكرو. وكان هاد الراجَل سامري. ");
INSERT INTO arq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","تْكَلَّم يَسوع وقال: \"ماشي في عَشرة طَهرو؟ وين راهُم التَسعة الأخرين؟ ");
INSERT INTO arq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ما كانش فيهُم واحَد يَرجَع يْمَد التَسبيح لله من غير هاد البَرّاني؟\" ");
INSERT INTO arq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","أومبَعد قاللو: \"نوض وروح، إيمانَك سَلّكَك\". ");
INSERT INTO arq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","كي سَقساو الفَريسِيّين يَسوع وَقتاش يْجي مَلَكوت الله؟ جاوَبهُم وقال: \"مَلَكوت الله ما يْجيش بصِفة باينة، ");
INSERT INTO arq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ما يْقولوش: راهو هنا، وَلاّ راهو لهيك، خاطَر مَلَكوت الله راهو في وَسطكُم\". ");
INSERT INTO arq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","وقال للتابعين مْتاعو: \"يْجيو اليامات وين تَتشَهّاو تْشوفو يوم واحَد من يامات بْن الانسان وما تْشوفوهش، ");
INSERT INTO arq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","يْقولولكُم: راهو هنا وَلاّ راهو لهيك، ما تْروحوش وما تْتبّعوش، ");
INSERT INTO arq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","خاطَر، كيما البْرَق اللي يَشعَل من جيهة ويْضَوّي في جيهة أخرى فالسْما، هَكدا يْكون بْن الإنسان في نْهارو، ");
INSERT INTO arq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","بَصَّح لازَم فالأوَّل يَتعَدَّب بَزّاف وما يَقَّبلوش هاد الجيل. ");
INSERT INTO arq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","الشي اللي صْرا في وَقت نوح، يَصرا كيف كيف في يامات بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","الناس كانو ياكلو ويَشُّربو، يَتزَوّجو ويْزَوّجو وْلادهُم، حَتّى نْهار وين دْخَل نوح للفَلك، وجا الطوفان وفْناهُم كامَل. ");
INSERT INTO arq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","وكيما صْرا تاني في وَقت لوط، كانو الناس ياكلو ويَشَّربو، يَشريو ويْبيعو، ويَغَّرسو ويَبنيو، ");
INSERT INTO arq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","بَصَّح نْهار خْرَج لوط من سَدوم، طاحَت شْتا مْتاع النار والكَبريت من السْما وفَناتهُم كامَل. ");
INSERT INTO arq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","هَكدا يَصرا نْهار يَضهَر بْن الإنسان. ");
INSERT INTO arq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","داك النْهار، اللي يْكون فالسْطَح ودوزانو فالدار غير ما يَهبَطش باش يْجيبهُم، واللي يْكون فالحوش تاني غير ما يْوَلّيش للور، ");
INSERT INTO arq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","أتفَكّرو مَرت لوط، ");
INSERT INTO arq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","اللي يْحَوّس يْسَلَّك حْياتو يَخسَرها، واللي يَسمَح فيها يْسَلَّكها. ");
INSERT INTO arq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","نْقولَلكُم، في ديك الليلة، يْكونو زوج في فْراش واحَد، يَتّاخُد واحَد ويَبقا الآخُر، ");
INSERT INTO arq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","يْكونو زوج نْسا يَرحيو كيف كيف، تَتّاخَد واحدة وتَبقا الأخرى، ");
INSERT INTO arq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","جاوبوه التابعين مْتاعو وقالولو: \"وين يا رَبّي؟\" قالَلهُم: \"وين تْكون الجيفة، تَمّة يَنطَمّو العُڤبان\". ");
INSERT INTO arq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","عْطالهُم يَسوع مْتَل يْبَيَّن باللي الواحَد لازَم يْداوَم فالصْلاة وما يْمَلش. ");
INSERT INTO arq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","قال: \"كان في واحَد المْدينة، قاضي ما يْخاف الله، ما يْدير القْدَر لبْنادَم، ");
INSERT INTO arq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","وكانَت في هَديك المْدينة هَجّالة، تْجي ليه وتْقوللو: \"جيبلي حَقّي من عْدويَ\". ");
INSERT INTO arq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","شْحال وهُوَ ماشي قابَل، أومبَعد قال في قَلبو: \"والو ما نْخاف الله وما نْدير حْساب لبْنادَم، ");
INSERT INTO arq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","بَصَّح كي سَمّطَت عليَّ هاد الهَجّالة، نْجيبَلها حَقَّها باش ما تُقعَدش تْكَسَّرلي في راسي.\"\" ");
INSERT INTO arq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","قال الرَب: \"أسَّمعو واش قال القاضي الضالَم، ");
INSERT INTO arq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","وتَحَّسبو الله ما يْجيبش حَق عْبادو المُختارين اللي يَطَّلبوه ليل ونْهار ويَبطا باش يَستاجَبَلهُم؟ ");
INSERT INTO arq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","نْقولَلكُم، رايَح يْجيبَلهُم حَقّهُم بالخَف. بَصَّح كي يْجي بْن الإنسان، رايَح يَلقا الإيمان على الأرض؟\" ");
INSERT INTO arq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","وزاد قال هاد المْتَل لشي ناس شايفين روحهُم صالحين وحاسبين روحهُم على الأُخرين: ");
INSERT INTO arq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","\"زوج رْجال طَلعو للمَعبَد باش يْصَلّيو، واحَد فَرّيسي والآخُر مَكّاس، ");
INSERT INTO arq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","الفَرّيسي كان واقَف ويْصَلّي في قَلبو هَكدا: \"يا رَبّي، نَحَّمدَك اللي أنا ماشي كيما الناس الأُخرين، السَرّاقين، الضالمين، الزانيين، وَلاّ كيما هاد المَكّاس، ");
INSERT INTO arq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","نْصوم زوج مَرّات فالجَمعة، ونْعَشَّر على كامَل مَدخولي\". ");
INSERT INTO arq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","بَصَّح المَكّاس، كان واقَف من البْعيد، وماشي قادَر يَرفَد عينيه للسْما، وكان يَخبَط في صَدرو ويْقول: \"يا رَبّي، أرحَمني أنا الخاطي\". ");
INSERT INTO arq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","نْقولَلكُم، هاد المَكّاس هْبَط لدارو وهُوَ مْبَرّي والفَرّيسي لالا، خاطَر اللي يَحسَب روحو، قيمتو تَنقُص، واللي يَحڤَر روحو، تْزيد قيمتو\". ");
INSERT INTO arq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","جابولو تاني الدْراري الصْغار باش يْمَسّهُم، بَصَّح كي شافوهُم التابعين زْڤاو عليهُم، ");
INSERT INTO arq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","بَصَّح عَيَّطلهُم يَسوع وقال: \"خَلّيو الدْراري الصْغار يْجيو لعَندي وما تَمَّنعوهُمش، خاطَر مَلَكوت الله للي بْحالهُم. ");
INSERT INTO arq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","نْقولَلكُم الصَح، اللي ما يَقبَلش مَلَكوت الله كي الوْلَد الصْغير ما يَدَّخلوش\". ");
INSERT INTO arq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","سَقساه واحَد الرايَس: \"يا الشيخ المْليح، واش لازَم نْدير باش نَورَت الحْياة الدايمة؟\" ");
INSERT INTO arq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","قاللو يَسوع: \"عْلاش تْعَيَّطلي مْليح، ما كايَن حَتّى واحَد مْليح من غير الله وَحدو، ");
INSERT INTO arq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","تَعرَف الأحكام: ما تَزنيش، ما تَقتَلش، ما تَسرَقش وما تَشهَدش بالزور، كَرَّم باباك ويَمَّاك.\" ");
INSERT INTO arq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","قاللو: \"هَدو كامَل دَرتهُم من صُغري\" ");
INSERT INTO arq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","كي سْمَع يَسوع قاللو: \"تْخَصَّك حاجة واحدة، بيع كامَل واش عَندَك، وفَرّقو على الڤْلالين، ويْكون عَندَك كَنز فالسْماوات، وأرواح تَبَّعني.\" ");
INSERT INTO arq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","شْحال حْزَن الراجَل كي سْمَع هاد الشي خاطَر كان مْرَفَّه بَزّاف. ");
INSERT INTO arq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","كي شافو يَسوع حْزَن بَزّاف قال: \"شْحال واعَر على المْرَفّهين باش يَدَّخلو لمَلَكوت الله، ");
INSERT INTO arq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ساهَل على الجْمَل باش يْجوز من العين مْتاع البْرة كْتَر من المْرَفَّه باش يَدخُل لمَلَكوت الله.\" ");
INSERT INTO arq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","قالو اللي سَمعو: \"شْكون هِمّالا يَقدَر يَسلَك؟\" ");
INSERT INTO arq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","جاوَب يَسوع: \"اللي مُحال عَند الناس، ماشي مُحال عَند الله.\" ");
INSERT INTO arq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","قال بُطرُس: \"رانا حْنا خَلّينا شَيّنا وتَبَّعناك\"، ");
INSERT INTO arq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","قالَلهُم يَسوع: \"نْقولَلكُم الصَح، كُل واحَد خَلاّ دار وَلاّ مْرا وَلاّ خاوة وَلاّ مْوالين ولا دْراري على جال مَلَكوت الله، ");
INSERT INTO arq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","يَدّي في هاد الدَنيا كْتَر وفي الآخرة الحْياة الدايمة.\" ");
INSERT INTO arq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","أدّا يَسوع التابعين في طْناش وقالَلهُم: \"رانا طالعين لأورشَليم، ورايَح يَتحَقَّق كامَل الشي اللي كَتبوه الأَنبيا على بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","خاطَر رايَح يَتسَلَّم للكُفّار ويَتمَسخرو بيه ويْسَبّوه ويَبَّزقو عليه، ");
INSERT INTO arq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","وبَعد ما يَجَّلدوه، يَقَّتلوه وفاليوم التالَت يْقوم.\" ");
INSERT INTO arq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","بَصَّح التابعين ما فَهمو والو خاطَر هاد الكْلام كان مَخفي عليهُم وما فَهموش واش تْقال. ");
INSERT INTO arq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","كي قَرَّب يَسوع لأَريحا، كان واحَد العْمى قاعَد يَطلَب في طَرف الطْريق. ");
INSERT INTO arq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","كي سْمَع الغاشي جايَز، سَقسا واش كايَن؟ ");
INSERT INTO arq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","قالولو باللي يَسوع الناصري راهو جايَز، ");
INSERT INTO arq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","وبْدا يْعَيَّط ويْقول: \"يَسوع، يا بَن داوَد، أرحَمني.\" ");
INSERT INTO arq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","اللي كانو يَمشيو من القُدّام زْڤاو عليه باش يَسكُت، بَصَّح هُوَ زاد عَيَّط كْتَر: \"يا بَن داوَد، أرحَمني.\" ");
INSERT INTO arq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","حْبَس يَسوع وآمَر باش يْجيبوهولو، وكي قَرَّب سَقساه: ");
INSERT INTO arq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"واش تْحَب نْديرلَك؟\" قال: \"رَبّي، نْوَلّي نْشوف.\" ");
INSERT INTO arq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","قاللو يَسوع: \"وَلّي تْشوف، إيمانَك سَلّكَك.\" ");
INSERT INTO arq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","تَم تَم وَلاّ يْشوف وتَبَّع يَسوع وهُوَ يْسَبَّح فالله، وكامَل الشَعب كي شاف هاد الشي سَبَّح الله. ");
INSERT INTO arq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","أومبَعد دْخَل يَسوع وجاز على أريحا. ");
INSERT INTO arq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","كان واحَد الراجَل واسمو زَكّا، كان رايَس المَكّاسين وكان مْرَفَّه، ");
INSERT INTO arq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","كان حاب يْشوف شْكون هُوَ يَسوع بَصَّح ما قْدَرش على جال الغاشي خاطَر كان قْصير. ");
INSERT INTO arq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","راح يَجرى للقُدّام وطْلَع فوق واحَد السَجرة باش يْشوفو خاطَر يَسوع كان جايَز من تَم. ");
INSERT INTO arq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","كي وْصَل يَسوع لهَداك المَضرَب، طَلَّع عينيه وقال لزَكّا: \"زَكّا، غاوَل أهبَط، لازَم اليوم نْضيف عَندَك\"، ");
INSERT INTO arq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","زَكّا هْبَط يَجري وسْتَقبلو بالفَرح. ");
INSERT INTO arq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","كي شافو هاد الشي، كامَل الناس بْداو يْدَمدمو ويْقولو: \"راح يْضيف عَند راجَل خاطي\". ");
INSERT INTO arq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","بَصَّح زَكّا وْقَف وقال للرَب: \"رَبّي، هاني نَعطي نَص مْلاكي للڤْلالين، وَلاّ دْغُلت كاش واحَد، نْرَجَّعلو قيس رْبَع مَرّات واش أدّيتلو\"، ");
INSERT INTO arq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","قاللو يَسوع: \"اليوم جا السْلاك لهاد الدار خاطَر هَدا تاني وْليد إبراهيم، ");
INSERT INTO arq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","خاطَر بْن الإنسان جا باش يْحَوَّس على اللي كان ضايَع ويْسَلَّكو.\" ");
INSERT INTO arq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","كي سَمعو هاد الشي، زاد قالَلهُم مْتَل خاطَر كان قْريب لأورشَليم وكانو حاسبين باللي مَلَكوت الله دُرك يَضهَر. ");
INSERT INTO arq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","قالَلهُم: \"واحَد الراجَل من عايلة بالطْبَع راح لبْلاد بْعيدة باش يَدّي المُلك ويْوَلّي سَلطان ويَرجَع. ");
INSERT INTO arq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","عَيَّط لعْشَر خَدّامين وعْطالهُم عْشَر ويزات وقالَلهُم: \"تاجرو بيهُم حَتّى نَرجَع\". ");
INSERT INTO arq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ناس المْدينة كانو يَكَّرهوه وبَعتو موراه مْراسَل يْقولو: \"ما نْحَبّوش هاد الراجَل يْكون السَلطان مْتاعنا\". ");
INSERT INTO arq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","كي رْجَع بَعد ما أدَّا المُلك، آمَر باش يْعَيّطولو للخَدّامين اللي عْطالهُم الويز باش يَعرَف واش دارو بيهُم. ");
INSERT INTO arq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","جا الأوَّل وقال: \"سيدي، الويزة مْتاعك جابَت عْشَر ويزات\". ");
INSERT INTO arq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","قاللو: \"مْليح يا الخَدّام المْليح، خاطَر كُنت حْلالي فالحاجة القْليلة، رايَح تْوَلّي حاكَم على عَشر مْدايَن\". ");
INSERT INTO arq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","أومبَعد جا التاني وقال: \"سيدي، الويزة مْتاعك جابَت خَمس ويزات\". ");
INSERT INTO arq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","قاللو السَلطان: \"أنتَ تاني، كون حاكَم على خَمس مْدايَن\". ");
INSERT INTO arq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","أومبَعد جا واحَدآخُر وقال: \"سيدي، هايليك الويزة مْتاعك، خَبّيتها في طَرف قْماش، ");
INSERT INTO arq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","خاطَر كُنت خايَف منَّك، أنتَ بْنادَم قاسي، تاخُد اللي ما حَطّيتوش وتَحصَد اللي ما زْرَعتوش\". ");
INSERT INTO arq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","قاللو: \"نْحاسبَك بكْلامَك يا الخَدّام الدوني، كُنت عارَف باللي أنا بْنادَم قاسي، ناخُد اللي ما حَطّيتوش ونَحصَد اللي ما زْرَعتوش، ");
INSERT INTO arq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","هِمّالا وَعلاش ما حَطّيتش الويز مْتاعي فالبانكة؟ وأنا كي نَرجَع نْخَرَّجو بالفايدة\". ");
INSERT INTO arq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","وقال للي كانو حاضرين: \"نَحّيولو الويزة وعْطيوها للي عَندو عْشَرة\"، ");
INSERT INTO arq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","قالولو: \"سيدي، عَندو عْشَر ويزات\"، ");
INSERT INTO arq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","قالَلهُم: \"نْقولَلكُم، اللي عَندو، يَنزادلو، واللي ما عَندوش، يَتنَحّالو حَتّى اللي عَندو، ");
INSERT INTO arq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","وعَدياني اللي ما حَبّونيش نْكون السَلطان مْتاعهُم، جيبوهُم اللَهنا وأدَّبحوهُم قُدّامي.\" ");
INSERT INTO arq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","بَعد ما قال يَسوع هاد الشي، سْبَق وطْلَع لأورشَليم، ");
INSERT INTO arq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","وكي قَرَّب من بيت فاجي وبيت عَنيا عَند الجْبَل اللي يْسَمّيوَه جْبَل الزيتون، بْعَت زوج من التابعين، ");
INSERT INTO arq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","وقال: \"روحو للدَشرة المْقابلة، كي تَدَّخلو تَلقاو حْمار صْغير مَربوط، ما رْكَب عليه حَتّى بْنادَم، حَلّولو الرْباط وجيبوه، ");
INSERT INTO arq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","لو كان كاش واحَد يْسَقسيكُم: \"عْلاش راكُم تْحَلّولو الرْباط؟\" قولو: \"الرَب يَسَّحقو.\"\" ");
INSERT INTO arq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","راحو اللي كانو مَبعوتين ولْقاو كُل شي كيما قالَلهُم يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","كي كانو يْحَلّو فالرْباط للحْمار، قالولهُم مْواليه: \"وَعلاش راكُم تْحَلو فالرْباط للحْمار؟\" ");
INSERT INTO arq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","قالولهُم: \"الرَب يَسَّحقو.\" ");
INSERT INTO arq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","جابو الحْمار ليَسوع ورَكّبوه عليه بَعدما حَطّو حْوايَجهُم عليه، ");
INSERT INTO arq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","وكي كان ماشي كانو الناس يْفَرّشولو حْوايَجهُم على الطْريق، ");
INSERT INTO arq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","وكي قَرَّب لأورشَليم، عَند الهَبطة مْتاع جْبَل الزيتون، كامَل الغاشي مْتاع التابعين بْدا يْسَبَّح فالله بالزور من الفَرحة على جال كامَل المُعجِزات اللي شافوهُم، ");
INSERT INTO arq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","وكانو يْقولو: \"مْبارَك السَلطان الجاي بآسَم الرَب، سْلام فالسْما ومَجد فالعْلالي.\" ");
INSERT INTO arq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","وجْماعة من الفَريسِيّين من الغاشي قالولو: \"شيخ، سَكَّت التابعين مْتاعك.\" ");
INSERT INTO arq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","جاوَب وقال: \"نْقولَلكُم، لو كان يَسُّكتو هومَ، الحْجَر يْعَيَّطو.\" ");
INSERT INTO arq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","وكي كان قْريب من المْدينة، شافها وبْكا عليها، ");
INSERT INTO arq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","وقال: \"لو كان عْرَفتي أنتِ تاني في هاد اليوم الشي اللي فيه هْناك، بَصَّح دُرك راهو مَخفي على عينيك، ");
INSERT INTO arq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","خاطَر يْجيو عليك يامات وين يْدورو بيك عَديانَك بالخْنادَق ويَغَّلقو عليك ويْحاصروك من كُل جيهة، ");
INSERT INTO arq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ويْهَدّوك ووْلادَك فيك وما يْخَلّيوش فيك حَجرة فوق حَجرة خاطَر ما عْرَفتيش الزْمان اللي تْفاقَدتي فيه.\" ");
INSERT INTO arq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","وكي دْخَل للمَعبَد، بْدا يْحاوَز اللي كانو يْبيعو، ");
INSERT INTO arq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ويْقولَلهُم: \"مَكتوب: \"داري رايحة تْكون دار للصْلاة وأنتومَ رَدّيتوها غار مْتاع السَرّاقين\"\". ");
INSERT INTO arq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","كان كُل يوم يْدَرَّس فالمَعبَد وكانو رِيّاس رْجال الدين وشْيوخ الشَريعة مع رِيّاس الشَعب يْحَوّسو يَقَّتلوه، ");
INSERT INTO arq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","بَصَّح ما عَرفوش كيفاش يْديرو خاطَر الشَعب كامَل كان مَتعَلَّق بيه باش يَسمَعلو. ");
INSERT INTO arq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","في يوم من هَدوك اليامات، كي كان يَسوع يْدَرَّس الشَعب فالمَعبَد ويْبَشَّر، جاو رِيّاس رْجال الدين والكُتّاب مع الشْيوخ، ");
INSERT INTO arq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","هَدرو وقالولو: \"قولَلنا بآما حُكمة راك تْدير هاد الشي وَلاّ شْكون اللي عْطالَك هاد الحُكمة؟\" ");
INSERT INTO arq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","جاوَب وقالَلهُم: \"أنا تاني نْسَقسيكُم حاجة وقولولي، ");
INSERT INTO arq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","مَعمودِيّة يوحَنّا جات من السْما وَلاّ من عَند بْني آدَم؟\" ");
INSERT INTO arq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","تْشاورو ما بيناتهُم وقالو: \"لو كان نْقولو من السْما، يْقول عْلاش ما آمَنتوش بيه، ");
INSERT INTO arq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ولو كان نْقولو من بْني آدَم، كامَل الشَعب يَرجَمنا خاطَر راهُم مَقتَنعين باللي يوحَنّا نَبي.\" ");
INSERT INTO arq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","جاوبوه باللي ما يَعرفوش منين، ");
INSERT INTO arq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ويَسوع قالَلهُم: \"وأنا تاني ما نْقولَلكُمش بآما حُكمة نْدير هاد الشي.\" ");
INSERT INTO arq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","وبْدا يْقول للشَعب هاد المْتَل: \"واحَد الإنسان غْرَس دالية وخَلاّها لفَلاّحين يَستَكلفو بيها وسافَر لمُدّة طْويلة، ");
INSERT INTO arq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","كي لْحَق موسَم العْنَب، بْعَت خَدّام لهَدوك الفَلاّحين باش يْعطيولو نْصيب من غَلّة الدالية، بَصَّح هومَ ضَربوه وبَعتوه بلا ما يَعطيولو والو، ");
INSERT INTO arq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","زاد بْعَت خَدّام واحَدآخُر، وزادو ضَربوه وسَبّوه وبَعتوه بلا ما يَعطيولو والو. ");
INSERT INTO arq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","وزاد بْعَت خَدّام تالَت، جَرحوه وحاوزوه. ");
INSERT INTO arq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","هِمّالا قال مول الدالية: \"واش نْدير؟ نَبعَت وْليدي الحْبيب، بَلاك يْقادروه\". ");
INSERT INTO arq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","بَصَّح غير شافوه تْفاهمو ما بيناتهُم وقالو: \"هَدا هُوَ اللي يَورَت، هَيّا نَقَّتلوه باش يُقعَدَّلنا الوَرت\". ");
INSERT INTO arq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","خَرّجوه من الجْنان مْتاع الدالية وقَتلوه. دُرك واش يْديرلهُم مول الدالية؟ ");
INSERT INTO arq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","يْجي، يُقتَل هَدوك الفَلاّحين ويَعطي الجْنان مْتاع الدالية لواحَدُخرين\". كي سَمعو هاد الشي قالو: \"لَهلا يْصير هاد الشي\". ");
INSERT INTO arq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","خْزَر فيهُم يَسوع وقال: \"هِمّالا، واش مَعنَتها هَديك الآية اللي تْقول: \"الحَجرة اللي ما قَبلوهاش البَنايّين، هِيَ اللي وَلاّت حَجرة الوْصَل، ");
INSERT INTO arq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","اللي يْطيح عليها يَتكَسَّر، واللي تْطيح عليه تْكَسّرو؟\" ");
INSERT INTO arq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ف هَديك الساعة، حَبّو الكُتّاب ورِيّاس رْجال الدين يَحَّكموه خاطَر عَرفو باللي المْتَل كان عليهُم بَصَّح خافو من الشَعب. ");
INSERT INTO arq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","بْداو يْعَسّو فيه وبَعتو ناس رَدّو روحهُم صالحين باش يَحَّكمو عليه كَلمة يْقولها ويْسَلّموه للقاضي وللحاكَم. ");
INSERT INTO arq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","هاد الناس سَقساوَه وقالو: \"شيخ، رانا عارفين باللي أنتَ تَهدَر وتْدَرَّس الحَق وما تْديرش الوْجوه وتْعَلَّم طْريق الله على حْساب الصَح. ");
INSERT INTO arq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","يْجوزَلنا نْخَلّصو الغْرامة لقَيصَر وَلاّ لالا؟\" ");
INSERT INTO arq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","فاق يَسوع بالحيلة مْتاعهُم وقالَلهُم: ");
INSERT INTO arq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","\"وَرّيولي دينار. مْتاع من هاد التَصويرة وهاد الكْتيبة اللي فالدينار؟\" قالو: \"مْتاع قَيصَر\"، ");
INSERT INTO arq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","قالَلهُم: \"هِمّالا، أعطيو شِيّ قَيصَر لقَيصَر، وشِيّ الله لله.\" ");
INSERT INTO arq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","وما قَدروش يَحَّكمو عليه كَلمة قُدّام الشَعب، وسْتَعجبو من وْجابو وسَكتو. ");
INSERT INTO arq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","جات جْماعة من الصَدّوقِيّين اللي ما يامنوش بالقِيامة وسَقساوَه: ");
INSERT INTO arq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","\"شيخ، كْتَبَّلنا موسى باللي لو كان كاش واحَد يْموت خوه ويْكون هَدا اللي مات مَتزَوَّج وما عَندوش الدْراري، لازَم على خوه يَتزَوَّج بمَرتو وبْجيبلو الدَرّيّة. ");
INSERT INTO arq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","كانو كاينين سْبَع خاوة، الأوَّل تْزَوَّج ومات بلا ما يْخَلّي الدْراري، ");
INSERT INTO arq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","تْزَوَّج التاني، ");
INSERT INTO arq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","وبَعدو التالَت بالمْرا اللي خَلاّها هَجّالة وكَمّلو هَكدا في سَبعة، وماتو بلا ما يْخَلّيو الدَرّيّة. ");
INSERT INTO arq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ومع الأخَّر ماتَت المْرا تاني. ");
INSERT INTO arq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","فالقِيامة شْكون اللي تْكون هاد المْرا مَرتو؟ خاطَر في سَبعة تْزَوّجو بيها\". ");
INSERT INTO arq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","قالَلهُم يَسوع: \"وْلاد هاد الزْمان، الرْجال يَتزَوّجو والنْسا يَتزَوّجو بيهُم، ");
INSERT INTO arq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","بَصَّح اللي يَستاهلو يْنالو الحْياة الدايمة والقِيامة من الموتى، ما يَتزَوّجو ما يَتزَوّجو بيهُم، ");
INSERT INTO arq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","وما يَقَّدروش يْعاودو يْموتو خاطَر يْوَلّيو كي بْحال المَلايكة، ويْوَلّيو وْلاد الله على حْساب اللي هومَ وْلاد القِيامة، ");
INSERT INTO arq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","وعلى اللي الموتى يْقومو، هاد الشي هْدَر عليه موسى فالعَلايَڤ كي قال: \"الرَب إلَه إبراهيم وإلَه إسحاق وإلَه يَعقوب، ");
INSERT INTO arq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","الله إلَه الحَيّين ماشي إلَه الموتى، خاطَر عَندو كامَل راهُم حَيّين.\" ");
INSERT INTO arq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","جاوبوه جْماعة من الكُتّاب وقالو: \"شيخ، هْدَرت مْليح.\" ");
INSERT INTO arq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","وحَتّى واحَد ما زاد قْدَر يْسَقسيه على كاش حاجة. ");
INSERT INTO arq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","زاد قالَلهُم يَسوع: \"كيفاش يْقولو باللي المَسيح وْليد داوَد، ");
INSERT INTO arq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","وداوَد بداتو يْقول في كْتاب المَزامير: \"قال الرَب لرَبّي، أقعَد على يْميني، ");
INSERT INTO arq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","حَتّى نْحَط عَديانَك تَحت رَجليك\". ");
INSERT INTO arq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ولا داوَد يْعَيَّطلو رَبّي، كيفاش هِمّالا يْكون وْليدو؟\" ");
INSERT INTO arq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","وكي كان كامَل الشَعب يَسمعلو قال للتابعين مْتاعو: ");
INSERT INTO arq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"رَدّو بالكُم من الكُتّاب اللي يْحَبّو يَمشيو بڤَنادَر طْوال، والناس يْسَلّمو عليهُم فالأَسواق، ويْحَبّو الكْراسا الأوّلين فالمْجامَع والمْضارَب المْخَيّرين فالوَليمات، ");
INSERT INTO arq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ياكلو دْيار الهَجّالات وقُدّام الناس يْطَوّلو فالصْلاة. هَدوك عِقابهُم كْبير\". ");
INSERT INTO arq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","خْزَر يَسوع للفوق وشاف المَرَفّهين يْحَطّو الصَدقة فالخَزنة مْتاع المَعبَد، ");
INSERT INTO arq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","وشاف تاني واحَد الهَجّالة ڤَلّيلة حَطَّت تَمّة زوج صوردي، ");
INSERT INTO arq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","وقال: \"نْقولَلكُم الصَح، هاد الهَجّالة الڤَلّيلة حَطَّت كْتَر من الأُخرين كامَل، ");
INSERT INTO arq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","خاطَر هَدو حَطّو الصَدقة من الشْياطة مْتاعهُم، بَصَّح هِيَ من الڤَلّة مْتاعها حَطَّت كامَل واش عندها باش تْعيش.\" ");
INSERT INTO arq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","كايَن اللي كانو يْقولو على المَعبَد باللي مْزَيَّن بحْجَر شْباب ومْشَبَّح بالهْدِيات اللي وَهبوهُم الناس للمَعبَد، وقال يَسوع: ");
INSERT INTO arq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","\"يْجيو يامات وين من هاد الشي اللي راكُم تْشوفوه، ما تَبقاش حَجرة فوق حَجرة ما تَنهَدش\". ");
INSERT INTO arq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","سَقساوَه وقالو: \"رَبّي، وَقتاش يَصرا هاد الشي؟ وواش تْكون المارة كي يْكون رايَح يَصرا؟\" ");
INSERT INTO arq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","قال يَسوع: \"رَدّو بالكُم تَغَّلطو، خاطَر يْجيو بَزّاف بآسمي ويْقولو: \"أنا هُوَ، والوَقت راهو قْريب\". ما تْتَبّعوهُمش. ");
INSERT INTO arq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","وَلاّ سْمَعتو بالحَرب والتورة، ما تَنخَلعوش خاطَر هاد الشي لازَم يَسبَق مع الأوَّل، بَصَّح ما زال ما جاتش الآخرة\". ");
INSERT INTO arq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","أومبَعد قالَلهُم: \"تْنوض أُمّة ضَد أُمّة ومَملَكة ضَد مَملَكة، ");
INSERT INTO arq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ويْجيو زْنازَل كْبار في مْضارَب بَزّاف والأمراض والمَجاعات وحاجات يْخَوّفو وعَلامات كْبار من السْما، ");
INSERT INTO arq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","بَصَّح قْبَل هَدا كامَل، يَحَّكموكُم ويَحَّڤروكُم، يْسَلّموكُم للمْجامَع وللحْباس ويْكَركروكُم عَند سْلاطَن وحُكّام على جال آسمي، ");
INSERT INTO arq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","هاد الشي يَصرالكُم باش تَشَّهدولي. ");
INSERT INTO arq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ديرو في بالكُم باللي ما لازَمش تَتحيّرو من قْبَل كيفاش رايحين تْحاميو على روحكُم، ");
INSERT INTO arq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","خاطَر أنا نَعطيلكُم كْلام وعْقل ما يَقَّدروش عَديانكُم يْقاوموهُم وَلاّ يْواجبو عليهُم، ");
INSERT INTO arq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","يْسَلّموكُم حَتّى مْواليكُم وخاوَتكُم واللي قْراب ليكُم وصْحابكُم ويَقَّتلو شي ناس منكُم، ");
INSERT INTO arq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","وتْكونو مَكروهين من عَند كامَل الناس على جال آسمي، ");
INSERT INTO arq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","بَصَّح شَعرة من راسكُم ما تْضيع، ");
INSERT INTO arq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","بالصْبَر مْتاعكُم، تْسَلّكو نْفوسكُم. ");
INSERT INTO arq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","وكي تْشوفو الجْيوش يْحاصرو أورشَليم، أعَّرفو باللي وَخدَتها قَرّبَت. ");
INSERT INTO arq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","تَم، اللي يْكونو فاليَهودية، غير يَهَّربو للجْبال، واللي في أورشَليم، غير يْروحو منها، واللي يْكونو فالأحواش، غير ما يَدَّخلوش للمْدينة، ");
INSERT INTO arq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","خاطَر هَدوك يامات التار باش يَتحَقَّق كامَل الشي اللي مَكتوب. ");
INSERT INTO arq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","يا ويل النْسا اللي يْكونو بالجوف واللي يْكونو يْرَضّعو في هَدوك اليامات خاطَر رايحة تْكون شَدّة كْبيرة فالبْلاد والله يَزْعَف على هاد الشَعب. ");
INSERT INTO arq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","رايحين يْطيحو موتى بحَد السيف ويْروحو مَسبِيّين عَند كامَل الأُمّات وأورشَليم تْنَعفَس برَجلين الأُمّات حَتّى يَكمَل وَقتهُم. ");
INSERT INTO arq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ويْكونو مارات فالشَمس والقْمَر والنْجوم، وتْجي غُمّة فالأرض عَند الأُمّات وهومَ خايفين من صوت البْحَر والموجات، ");
INSERT INTO arq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","والناس يَفَّشلو مالخوف ن وهومَ يَستَنّاو واش رايَح يَصرا فالدَنيا، خاطَر قُوّات السْما يَتزَعزعو. ");
INSERT INTO arq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","داك الوَقت، يْشوفو بْن الإنسان جاي فوق سْحابة بقُوّة وهيبة كْبيرة. ");
INSERT INTO arq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","كي يَبدا هاد الشي يَصرا، سَلّسو روحكُم وأرَّفدو راسكُم خاطَر سْلاككُم يْكون قْريب.\" ");
INSERT INTO arq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","وقالَلهُم مْتَل: \"شوفو الكَرمة وكامَل السْجور، ");
INSERT INTO arq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","غير يْوَرّقو، تْشوفو وتَعَّرفو باللي الصيف راهو قْريب، ");
INSERT INTO arq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","هَكدا أنتومَ تاني، غير تْشوفو هاد الشي يَصرا، أعَّرفو باللي مَلَكوت الله راهو قْريب، ");
INSERT INTO arq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","نْقولَلكُم الصَح، ما يْزولش هاد الجيل حَتّى يَصرا كامَل هاد الشي. ");
INSERT INTO arq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","السْما والأرض يْزولو بَصَّح كْلامي ما يْزولش. ");
INSERT INTO arq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","رَدّو بالكُم على روحكُم تْعودو تْخَلّيو قْلوبكُم يَتقالو من الشْراب والسَكرة وهْموم الدَنيا حَتّى يْطيح عليكُم هَداك النْهار على غَفلة، ");
INSERT INTO arq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","خاطَر هَداك النْهار يْطيح كي الفَخّة على كامَل اللي يَسُّكنو فوق الأرض. ");
INSERT INTO arq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","هِمّالا رَدّو بالكُم وصَلّيو في كل وَقت باش تَقَّدرو تَسَّلكو من كامَل الشي اللي رايَح يَصرا وتَوَّقفو قُدّام بْن الإنسان.\" ");
INSERT INTO arq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","وكان يَسوع فالنْهار يْدَرَّس فالمَعبَد ويْجَوّز الليل فالجْبَل اللي يْسَمّيوَه \"جْبَل الزيتون\"، ");
INSERT INTO arq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","وكان الشَعب كامَل يْبَكَّر يْروح لعَندو فالمَعبَد باش يَسمَعلو. ");
INSERT INTO arq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","قَرَّب عيد الفْطير اللي يْسَمّيوَه عيد الفَصح، ");
INSERT INTO arq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","وكانو رِيّاس رْجال الدين والكُتّاب يْحَوّسو كيفاش يَقَّتلو يَسوع بَصَّح كانو خايفين من الشَعب. ");
INSERT INTO arq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ودْخَل إبليس في يَهودا، واحَد من الطْناش تابَع يْسَمّيوَه الإسخريوطي، ");
INSERT INTO arq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","وراح هْدَر مع رِيّاس رْجال الدين ورِيّاس العَسكَر مْتاع المَعبَد على كيفاش يْسَلَّمَّلهُم يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","فَرحو ووَعدوه باللي يَعطيولو الدْراهَم. ");
INSERT INTO arq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","هُوَ قْبَل وبْدا يْحَوَّس على الوَقت اللي يْوالَم باش يْسَلَّموهولهُم بالتْخَبية على الغاشي. ");
INSERT INTO arq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","لْحَق عيد الفْطير اللي يَدَّبحو فيه خْروف الفَصح، ");
INSERT INTO arq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","وبْعَت يَسوع بُطرُس ويوحَنّا وقال: \"روحو ووَجّدولنا الفَصح باش ناكلوه.\" ");
INSERT INTO arq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","قالولو: \"وين حَبّيتنا نْوَجّدوه؟\" ");
INSERT INTO arq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","قالَلهُم: \"كي تَدَّخلو للمْدينة، تَتلاقاو مع راجَل رافَد قُلّة مْتاع الما، تَبّعوه للدار اللي يَدخُل ليها، ");
INSERT INTO arq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","وقولو لمول الدار: \"الشيخ راهو يْقوللَك: \"وين راهي بيت الماكلة اللي ناكُل فيها الفَصح مع التابعين مْتاعي؟\"\" ");
INSERT INTO arq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ويْوَرّيلكُم بيت فوقانِيّة واسعة ومْفَرّشة وتَمّة اللي تْوَجّدو.\" ");
INSERT INTO arq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","راحو ولْقاو الشي كيما قالَلهُم ووَجّدو الفَصح. ");
INSERT INTO arq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","وكي وْصَل الوَقت، قْعَد يَسوع على الميدة مع الرُسُل. ");
INSERT INTO arq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","قالَلهُم: \"شْحال تْشَهّيت ناكُل هاد الفَصح معاكُم قْبَل ما نَتعَدَّب، ");
INSERT INTO arq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","خاطَر نْقولَلكُم، ما نْزيدش ناكلو حَتّى يَتحَقَّق في مَلَكوت الله.\" ");
INSERT INTO arq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","رْفَد كاس، حْمَد وقال: \"خودو هاد الكاس وأتقاسموه ما بيناتكُم، ");
INSERT INTO arq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","خاطَر نْقولَلكُم، ما نْزيدش نَشرُب من غَلّة الدالية حَتّى يْجى مَلَكوت الله.\" ");
INSERT INTO arq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","أومبَعد، رْفَد الخُبز، حْمَد، قْسَم وعْطالهُم وقال: \"هَدي داتي اللي تَتَّوهَبَّلكُم، ديرو هَكدا تَفكيرة لِيَّ.\" ");
INSERT INTO arq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","وزاد عْطالهُم الكاس بَعد العْشا وقال: \"هاد الكاس هُوَ العَهَد الجْديد بدَمّي اللي يْسيل على جالكُم، ");
INSERT INTO arq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","بَصَّح هاي يَد اللي يْسَلَّمني معايَ على الميدة. ");
INSERT INTO arq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","بْن الإنسان راهو رايَح كيما راهو مَلزوم، بَصَّح يا ويلو هَداك الإنسان اللي يْسَلّمو.\" ");
INSERT INTO arq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","وبْداو يْسَقسيو بَعضهُم بَعض شْكون فيهُم اللي رايَح يْدير هاد الشي. ");
INSERT INTO arq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","وصْرا بيناتهُم خْلاف على شْكون فيهُم اللي يَحَّسبوه الكْبير. ");
INSERT INTO arq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","قالَلهُم يَسوع: \"سْلاطَن الأُمّات هومَ اللي يْسيطرو عليهُم واللي يَحَّكمو فيهُم يْسَمّيوهُم ناس يْديرو الخير، ");
INSERT INTO arq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","بَصَّح أنتومَ، ماشي هَكدا. بالعَكس، لازَم الكْبير فيكُم يْكون كيما الصْغير، واللي يَحكُم كيما اللي يَخدَم، ");
INSERT INTO arq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","خاطَر شْكون هُوَ الكْبير؟ اللي يُقعَد على الميدة وَلاّ اللي يَخدَم؟ ماشي اللي يُقعَد على الميدة؟ وأنا راني في وَسطكُم كي اللي يَخدَم. ");
INSERT INTO arq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","أنتومَ اللي تْبَتتو معايَ في مْحايني، ");
INSERT INTO arq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","على هَدا، كيما عْطاني بابا المَلَكوت، أنا نَعطيلكُم، ");
INSERT INTO arq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","باش تاكلو وتَشُّربو على ميدتي فالمَلَكوت مْتاعي وتُقَّعدو على العْروش وتْحاكمو قْبايَل إسرائيل في طْناش. ");
INSERT INTO arq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","سَمعان، سَمعان، الشيطان طْلَب عليكُم باش يْغَربَلكُم كي القَمح، ");
INSERT INTO arq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","بَصَّح أنا صَلّيتلَك باش ما يَضعَفش إيمانَك، وأنتَ كي تْنَهدا، تَبَّت خاوتَك\". ");
INSERT INTO arq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","قاللو سَمعان: \"رَبّي، راني واجَد باش نْروح معاك للحَبس وحَتّى للموت\"، ");
INSERT INTO arq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","قال يَسوع: \"نْقوللَك يا بُطرُس، ما يْعوعَشش اليوم السَردوك حَتّى تَنكُر تَلت مَرّات باللي تَعرَفني\". ");
INSERT INTO arq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","أومبَعد قالَلهُم: \"كي بْعَتتكُم بلا رَزمة وَلا شْكارة وَلا صَبّاط، كاش ما خَصّكُم؟\" قالولو: \"حَتّى حاجة\". ");
INSERT INTO arq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","قالَلهُم: \"بَصَّح دُرك اللي عَندو رَزمة غير يَدّيها، واللي عَندو شْكارة يَدّيها، واللي ما عَندوش سيف، يْبيع بَرنوسو ويَشري سيف، ");
INSERT INTO arq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","نْقولَلكُم تاني باللي لازَم يَتحَقَّق فِيَّ الكْلام اللي نَكتَب: \"حَسبوه مع الخاطيين\"، والشي اللي يْخَصّني راهو قْريب يْصير\". ");
INSERT INTO arq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","قالولو: \"رَبّي، كايَن زوج سْيوفة\"، قالَلهُم: \"بَرَكات\". ");
INSERT INTO arq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","خْرَج يَسوع وراح كي العادة لجْبَل الزيتون، وتَبّعوه التابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","وكي وْصَل لهَداك المْكان قالَلهُم: \"صَلّيو باش ما تْطيحوش في تَجرُبة\"، ");
INSERT INTO arq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","بَعَّد عليهُم شْوِيّة، رْكَع وصَلاّ، ");
INSERT INTO arq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","وقال: \"بابا، وَلاّ حَبّيت بَعَّد علِيَّ هاد الكاس، بَصَّح مُرادَك هُوَ اللي لازَم يْكون ماشي مُرادي\". ");
INSERT INTO arq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","واحَد المْلاك ضْهَرلو من السْما باش يْقَوّيه، ");
INSERT INTO arq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","وكان في شَدّة كْبيرة وبْدا يْصَلّي كْتَر وكْتَر، حَتّى وَلاّ العْرَق مْتاعو يْطيح كي حَجرات مْتاع الدَم على الأرض. ");
INSERT INTO arq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","وبَعد ما صَلاّ، ناض وراح لعَند التابعين مْتاعو ولْقاهُم راقدين من الحْزَن. ");
INSERT INTO arq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","قالَلهُم: \"واش، راكُم راقدين؟ نوضو وصَلّيو باش ما تَدُّخلوش في تَجرُبة\". ");
INSERT INTO arq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","كان مازالو يَهدَر كي بانَت جْماعة، سابَقها اللي واسمو يَهودا، واحَد من التابعين الطْناش وقَرَّب لعَند يَسوع باش يْسَلَّم عليه. ");
INSERT INTO arq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","قاللو يَسوع: \"يَهودا، ببوسة تْسَلَّم بْن الإنسان؟\" ");
INSERT INTO arq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","اللي كانو مع يَسوع، كي شافو واش رايَح يَصرا قالو: \"رَبّي، نَضَّربو بالسيف؟\" ");
INSERT INTO arq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","واحَد منهُم ضْرَب الخْديم مْتاع رايَس رْجال الدين وقَطَّعلو وَدنو اليْمنى، ");
INSERT INTO arq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","بَصَّح يَسوع نْطَق وقال: \"حَبّسو، ما تْزيدوش\"، ومَس بيَدّو وْدَن الخْديم وشْفاه. ");
INSERT INTO arq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","أومبَعد قال يَسوع لرِيّاس رْجال الدين وريّاس العَسكَر مْتاع المَعبَد والشْيوخ اللي جاو ليه: \"جيتو لِيَّ بالسْيوفة والعْصي كي اللي جيتو لواحَد سَرّاق، ");
INSERT INTO arq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","كُنت كُل يوم معاكُم فالمَعبَد وما حَطّيتوش يَدكُم عليَّ، بَصَّح هاد الساعة ليكُم ولحُكم الضْلام\". ");
INSERT INTO arq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","حَكموه وأدّاوَه ودَخّلوه لدار رايَس رْجال الدين، وبُطرُس كان يْتَبَّع فيه من البْعيد. ");
INSERT INTO arq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","شَعلو النار في وَسط الدار وقَعدو كيف كيف وقْعَد بُطرُس معاهُم. ");
INSERT INTO arq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","شافتو واحَد الخْديمة قاعَد قُدّام الضو مْتاع النار، مَيّزاتو وقالَت: \"هَدا تاني كان معاه\"، ");
INSERT INTO arq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","نْكَر بُطرُس وقال: \"يا مْرا، ما نَعَّرفوش\". ");
INSERT INTO arq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","شْويّة من بَعد، شافو واحَدآخُر وقال: \"أنتَ تاني منهُم\"، قاللو بُطرُس: \"يا راجَل، أنا مارانيش منهُم\". ");
INSERT INTO arq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","واحَد الساعة من بَعد، بْدا واحَدآخُر يْوَكَّد ويْقول: \"بلا شَك هَدا تاني كان معاه خاطَر هُوَ تاني جْليلي\". ");
INSERT INTO arq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","قال بُطرُس: \"يا راجَل، مارانيش عارَف واش راك تْقول\"، وتَم تَم، كي كان ما زالو يَهدَر، عوعَش السَردوك. ");
INSERT INTO arq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ودار الرَب يَسوع وخْزَر في بُطرُس، وتْفَكَّر بُطرُس كْلام الرَب كي قاللو: \"قْبَل ما يْعوعَش السَردوك اليوم، تَنكُرني تَلت مَرّات\"، ");
INSERT INTO arq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","وخْرَج بُطرُس بَرّا وبْكا بالمْرارة. ");
INSERT INTO arq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","الرْجال اللي كانو حاكمين يَسوع كانو يَتمَسخرو بيه ويَضّربو فيه، ");
INSERT INTO arq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ويَغَطّيولو وَجهو ويْسَقسيوَه: \"أتْنَبَّأ، شْكون اللي ضَربَك؟\" ");
INSERT INTO arq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","وكانو يْسَبّو فيه بكْلام واحَدآخُر بَزّاف. ");
INSERT INTO arq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","وكي طْلَع النْهار، تْجَمّعو شْيوخ الشَعب، رِيّاس رْجال الدين والكُتّاب وجابو يَسوع للمَجلس الديني مْتاعهُم، ");
INSERT INTO arq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","وقالو: \"وَلاّ أنتَ هُوَ المَسيح قولَلنا\"، قالَلهُم: \"لو كان نْقولَلكُم، ما تامنوش، ");
INSERT INTO arq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ولو كان نْسَقسي، ما تْجاوبوش، ");
INSERT INTO arq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","من دُرك يْكون بْن الإنسان قاعَد على يْمين قُدرة الله\". ");
INSERT INTO arq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","وكامَل قالو: \"هِمّالا، أنتَ هُوَ بْن الله؟\" جاوَبهُم: \"أنتومَ قُلتو باللي أنا هُوَ\". ");
INSERT INTO arq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","قالو: \"واش مازَلنا نَسَّحقو فالشْهود؟ رانا حْنا بالدات سْمَعناه من فَمّو\". ");
INSERT INTO arq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","الصْباح، ناضو كامَل وأدّاو يَسوع عَند بيلاطَس، ");
INSERT INTO arq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","وبْداو يَتَّهمو فيه ويْقولو: \"لْقينا هاد الراجَل يْحَرَّش فالأُمّة ويَمنَعها باش تْخَلَّص الغْرامة لقَيصَر ويْقول باللي هُوَ يْكون مَسيح وسَلطان\". ");
INSERT INTO arq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","سَقساه بيلاطَس وقال: \"أنتَ هُوَ سَلطان اليْهود؟\" جاوبو يَسوع وقال: \"أنتَ قُلت\". ");
INSERT INTO arq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","قال بيلاطَس لرِيّاس رْجال الدين وللغاشي: \"ما لْقيت حَتّى سَبّة باش نَحكَم هاد الإنسان\"، ");
INSERT INTO arq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","هومَ وَكّدو وقالو: \"راهو يْهَيَّج فالشَعب وهُوَ يْدَرَّس في كامَل اليَهوديّة، من الجْليل وين بْدا حَتّى اللَهنا\". ");
INSERT INTO arq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","كي سْمَع بيلاطَس سَقسا وَلاّ هاد الراجَل جْليلي، ");
INSERT INTO arq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","وكي عْرَف باللي هُوَ من الجيهة اللي تَحت يَد هيرودَس بْعتهولو وكان هيرودَس في هَدوك اليامات في أورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","كي شاف هيرودَس يَسوع، فْرَح بَزّاف خاطَر كان حاب يْشوفو من زْمان على جال واش سْمَع عليه وكان مَتمَنّي يْشوفو يْدير كاش مُعجِزة. ");
INSERT INTO arq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","سَقساه على حاجات بَزّاف بَصَّح يَسوع ما جاوبو على والو. ");
INSERT INTO arq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","رِيّاس رْجال الدين والكُتّاب كانو تَمّة وكانو يَتَّهمو فيه بالقْساوة. ");
INSERT INTO arq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","هيرودَس والعَسكَر مْتاعو حَڤروه وسْتَهزاو بيه ولَبّسولو لَبسة تَبرَق ورَجّعوه لعَند بيلاطَس. ");
INSERT INTO arq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","في هَداك اليوم، رَجعو بيلاطَس وهيرودَس حْباب بَعد ما كانو عَديان من قْبَل. ");
INSERT INTO arq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","لَم بيلاطَس رِيّاس رْجال الدين والحُكّام والشَعب، ");
INSERT INTO arq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","وقالَلهم: \"جَبتولي هاد الراجَل وقُلتو باللي راهو يْحَرَّش فالشَعب، أنا راني بْحتتو قُدّامكُم وما لْقيتو دار حَتّى حاجة من اللي قُلتولي عليها، ");
INSERT INTO arq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","وهيرودَس كيف كيف، خاطَر عاوَد بَعتو لعَندنا. هاد الراجَل ما دار حَتّى حاجة يَستاهَل عليها الموت، ");
INSERT INTO arq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","هِمّالا نَجَّلدو أومبَعد نَطَّلقو\". ");
INSERT INTO arq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","وكان لازم عليه يطلق مسجون واحد كل عيد. ");
INSERT INTO arq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","بصَّح بْداو يْعَيّطو كامَل كيف كيف ويْقولو: \"أقتَل هاد الراجَل وأطلَقَّلنا باراباس\". ");
INSERT INTO arq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","هَدا باراباس كان دْخَل للحَبس على جال هول صْرا فالمْدينة وعلى جال قْتيلة. ");
INSERT INTO arq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","زاد هْدَر معاهُم بيلاطَس مَرّة أخرى خاطَر كان حاب يَطلَق يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","هومَ بْداو يْعَيّطو ويْقولو: \"أصَّلبو، أصَّلبو\"، ");
INSERT INTO arq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","قالَلهُم بيلاطَس المَرّة التالتة: \"واش من الشَر اللي دارو؟ ما لْقيت فيه حَتّى حاجة يَستاهَل عليها الموت، نَجَّلدو أومبَعد نَطَّلقو\". ");
INSERT INTO arq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","هومَ زادو وَكّدو بالعْياط بالزور وطَلبو باش يَتَّصلَب يَسوع وغَلبو بعْياطهُم، ");
INSERT INTO arq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","وقْبَل بيلاطَس واش طَلبو منّو. ");
INSERT INTO arq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","طْلَق الراجَل اللي طَلبوه واللي كان فالحَبس على جال هول وقْتيلة وسَلَّم يَسوع لمُرادهُم. ");
INSERT INTO arq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","وكي كانو مَديين يَسوع، حَكمو واحَد من مْدينة قيروان كان راجَع من الحوش واسمو سَمعان، وحَمّلولو الصْليب باش يَرَّفدو مور يَسوع، ");
INSERT INTO arq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","وكان يْتَبَّع في يَسوع غاشي كْبير من الشَعب ونْسا كانو يَخَّبطو في صْدورهُم ويْنَوّحو عليه. ");
INSERT INTO arq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","دار ليهُم يَسوع وقال: \"يا بْنات أورشَليم، ما تَبكيوش علِيَّ، أبكيو على روحكُم وعلى وْلادكُم، ");
INSERT INTO arq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","خاطَر يْجيو اليامات وين يَتقال: يا سَعد العاڤرات، يا سَعد الكْروش اللي ما وَلدوش والصْدور اللي ما رَضّعوش. ");
INSERT INTO arq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","داك الوَقت يَبداو الناس يْقولو للجْبال طيحو علينا وللكُديات خَبّيونا، ");
INSERT INTO arq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","خاطَر وَلاّ دارو هَكدا للحْطَب الخْضَر واش يْصرا هِمّالا لليابَس؟\" ");
INSERT INTO arq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","كانو جايبين تاني زوج مَجَرمين واحَدُخرين باش يَقُّتلوهُم مع يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","وكي وَصلو لواحَد المْكان يْسَمّيوَه \"الجُمجمة\"، صَلبوه تَمّة مع هَدوك المَجَرمين الزوج، واحَد على اليْمنى والآخُر على اليْسرى. ");
INSERT INTO arq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","قال يَسوع: \"بابا، أغفَرَّلهُم خاطَر ما راهُمش عارفين واش راهُم يْديرو\". ودارو القُرعة باش يَتقاسمو حْوايجو ما بيناتهُم. ");
INSERT INTO arq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","وكان الشَعب قاعَد تَمّة يْشوف. الرِيّاس تاني كانو يَتمَسخرو بيه ويْقولو: \"كيما سَلَّك الأُخرين يْسَلَّك روحو وَلاّ كان هُوَ المَسيح مُختار الله\". ");
INSERT INTO arq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","العَسكَر تاني تْمَسخرو بيه، أدَّناو ليه وعْطاولو الخَل، ");
INSERT INTO arq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","وكانو يْقولو: \"وَلاّ كُنت سَلطان اليْهود، سَلَّك روحَك\". ");
INSERT INTO arq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","وكانَت فوق منّو هاد الكْتيبة: \"هَدا سَلطان اليْهود\". ");
INSERT INTO arq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","واحَد من المَجَرمين اللي كانو مَصلوبين كان يْسَب فيه ويْقول: \"ماشي أنتَ هُوَ المَسيح؟ سَلَّك روحَك وسَلَّكنا\". ");
INSERT INTO arq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","زْڤا عليه الآخُر وقال: \"ما تْخافش الله، وأنتَ نَحكَم عليك كيما هُوَ؟ ");
INSERT INTO arq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","كيما حْنا نَحكَم علينا بالحَق، خاطَر رانا نْجَوّزو واش نَستاهلو على جال الشي اللي دَرناه، بَصَّح هَدا ما دار حَتّى حاجة دونِيّة\"، ");
INSERT INTO arq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","وقال: \"يَسوع، أتفَكَّرني كي تْجي في مَلَكوتَك\". ");
INSERT INTO arq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","قاللو يَسوع: \"نْقوللَك الصَح، اليوم تْكون معايَ فالجَنّة\". ");
INSERT INTO arq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","كانَت الساعة قْريب الطْناش، وطاحَت واحَد الضَلمة على كامَل الأرض حَتّى للتْلاتة مْتاع العْشيّة. ");
INSERT INTO arq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ضْلامَت الشَمس وتْقَطَّع الحْجاب مْتاع المَعبَد مالوَسط. ");
INSERT INTO arq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","عَيَّط يَسوع بالزور وقال: \"بابا، نْسَلَّم روحي بين يَدّيك\"، وكي قال هَكدا، مات. ");
INSERT INTO arq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","كي شاف رايَس المْية واش صْرا، سَبَّح الله وقال: \"بلا شَك، هاد الراجَل كان صالَح\"، ");
INSERT INTO arq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","وكامَل الغاشي اللي كان مَلموم باش يَحَّضرو كي يَنصَلبو المَحبوسين، بَعد ما شافو واش صْرا، رَجعو وهومَ يَخَّبطو في صْدورهُم. ");
INSERT INTO arq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","كامَل مْعارَف يَسوع والنْسا اللي تَبّعوه من الجْليل وَقفو يْشوفو من البْعيد. ");
INSERT INTO arq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","كان واحَد المُستشار فالمَجلَس الديني واسمو يوسَف، راجَل مْليح وصالَح، ");
INSERT INTO arq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ما كانش مْوافَق الأُخرين على رايهُم وعلى العَملة اللي داروها. كان من مْدينة مْتاع اليْهود واسَمها الرامة وكان يَستَنّا في مَلَكوت الله. ");
INSERT INTO arq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","راح عَند بيلاطَس وطْلَب منّو دات يَسوع، ");
INSERT INTO arq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","وهَبّطو من الصْليب وكَفّنو وحَطّو في قْبَر كان مَحفور فالحْجَر، حَتّى واحَد ما نَدفَن فيه من قْبَل. ");
INSERT INTO arq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","كان هَداك النْهار نْهار التَوجاد والسَبت رايَح يَبدا. ");
INSERT INTO arq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","النْسا اللي كانو جاو من الجْليل مع يَسوع، تَبّعو يوسَف وشافو القْبَر وكيفاش نْحَطَّت فيه دات يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","رَجعو، وَجّدو زْيوت ورْوايَح، ورِيّحو نْهار السَبت على حْساب الشَريعة. ");
INSERT INTO arq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","فاليوم الأَوَّل مْتاع الجَمعة، راحو النْسا صْباح بَكري للقْبَر وأدّاو معاهُم الزْيوت اللي كانو وَجّدوهُم. ");
INSERT INTO arq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","لْقاو الحَجرة مْنَحّية على القْبَر، ");
INSERT INTO arq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","دَخلو وما لْقاوش دات الرَب يَسوع. ");
INSERT INTO arq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","وفي حيرتهُم، وَقفولهُم زوج رْجال بلَبسة تَبرَق. ");
INSERT INTO arq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","خافو النْسا وهَبّطو وَجههُم للأَرض، وقالولهُم الزوج رْجال: \"وَعلاش راكُم تْحَوّسو على الحَيّ ما بين الموتى؟ ");
INSERT INTO arq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ما راهوش هْنا، قام. أتفَكّرو واش قالَلكُم كي كان مازالو فالجْليل، ");
INSERT INTO arq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","وقال باللي لازَم يَتسَلَّم بْن الإنسان ليَدّين الخاطيين ويَتَّصلَب وفاليوم التالَت يْقوم\". ");
INSERT INTO arq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","وتْفَكّرو النْسا كْلام يَسوع، ");
INSERT INTO arq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","وكي رَجعو من القْبَر، خَبّرو بهاد الشي كامَل الحْداش تابَع وكامَل الأُخرين. ");
INSERT INTO arq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","النْسا كانو: مَريَم المَجدَليّة ويوَنّا ومَريَم يَمّاة يَعقوب وواحَدُخرين معاهُم وهومَ اللي خَبّرو الرُسُل. ");
INSERT INTO arq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","بَصَّح الرُسُل حَسبو هاد الكْلام تْهَتريف وما آمنوهُمش. ");
INSERT INTO arq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ناض بُطرُس وراح يَجري للقْبَر، وكي طابَس شاف الكْفَن مَحطوط وَحدو، ورْجَع لدارو مَستَعجَب من اللي صْرا. ");
INSERT INTO arq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","وفي هَداك اليوم، كانو زوج تابعين رايحين لدَشرة بْعيدة على أورشَليم قيس واحَد العَشرة كيلومتر واسَمها عَمواس، ");
INSERT INTO arq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","وكانو يَهَّدرو بيناتهُم على كامَل الشي اللي صْرا. ");
INSERT INTO arq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","وكي كانو يَهَّدرو ويْڤَصّرو، قَرَّب لعَندهُم يَسوع بالدات وبْدا يَمشي معاهُم، ");
INSERT INTO arq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","بَصَّح عينيهُم ما كانوش قادرين يَعَّرفوه. ");
INSERT INTO arq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","قالَلهُم: \"واش هاد الكْلام اللي راكُم تَهَّدرو فيه وأنتومَ ماشيين حْزنانين؟\" حَبسو وكانو يْبانو مَهمومين. ");
INSERT INTO arq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","واحَد فيهُم واسمو كَليوباس جاوَب وقاللو: \"غير أنتَ اللي راك بَرّاني ساكَن في أورشَليم اللي ما عَرفتش بالشي اللي صْرا فيها هاد اليامات؟\" ");
INSERT INTO arq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","قالَلهُم: \"وواش صْرا؟\" قالولو: \"اللي صْرا ليَسوع الناصري، اللي كان راجَل نَبي قادَر فالفْعال والقْوال قُدّام الله والشَعب كامَل، ");
INSERT INTO arq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","وكيفاش رِيّاس رْجال الدين والحُكّام مْتاعنا سَلّموه باش يَتَّحكَم عليه بالموت وصَلبوه. ");
INSERT INTO arq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","كُنا نَتمَنّاو يْكون هُوَ اللي يْسَلَّك إسرائيل بَصَّح اليوم يْجوز النْهار التالَت من اللي صْرا هاد الشي. ");
INSERT INTO arq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","صَح، كايَن شي نْسا من عَندنا حَيّرونا، راحو اليوم صْباح بَكري للقْبَر، ");
INSERT INTO arq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","وكي ما لْقاوش الدات مْتاعو، جاو يْقولو باللي شافو رُؤيا مْتاع مَلايكة قالولهُم باللي راهو حَي، ");
INSERT INTO arq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","وراحَت جْماعة من اللي كانو معانا للقْبَر، ولْقاو الشي كيما قالو النْسا، بَصَّح هُوَ ما شافوهش\". ");
INSERT INTO arq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","قالَلهُم يَسوع: \"يا اللي ما عَندكُمش العْقَل وقْلوبكُم تْقال باش يامنو كامَل واش قالو الأنبيا، ");
INSERT INTO arq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ماشي كان لازَم على المَسيح يَتعَدَّب هَكدا ويَدخُل في مَجدو؟\" ");
INSERT INTO arq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","أومبَعد بْدا من موسى ومن كامَل الأنبيا وفَسَّرلهُم كامَل واش مَكتوب عليه. ");
INSERT INTO arq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","وَصلو قْريب للدَشرة اللي كانو رايحين ليها، وهُوَ بان كي اللي كان حاب يْزيد يْبَعَّد كْتَر. ");
INSERT INTO arq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","وَكّدو عليه وقالو: \"أُقعُد معانا خاطَر راهو قْريب الليل والنْهار جاز\"، ودْخَل يُقعَد معاهُم. ");
INSERT INTO arq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","وكي كان قاعَد معاهُم على الميدة، خْدا الخُبز، بارَك، قْسَم وعْطالهُم، ");
INSERT INTO arq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ونْحَلّو عينيهُم وعَقلوه بَصَّح تَم تَم هُوَ غاب عليهُم. ");
INSERT INTO arq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","وقالو لبَعضهُم بَعض: \"ماشي كان قَلبنا لاهَب فينا كي كان يَهدر معانا فالطْريق ويْفَسَّرنا فالكْتوب؟\" ");
INSERT INTO arq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","وناضو في هَديك الساعة ورَجعو لأورشَليم ولْقاو الحْداش واللي معاهُم مَتلايمين، ");
INSERT INTO arq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ويْقولو باللي صَح الرَب قام وضْهَر لسَمعان.\" ");
INSERT INTO arq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","وهومَ حْكاو واش صْرا فالطْريق وكيفاش حَتّى عَقلو يَسوع كي كان يَقسَم فالخُبز. ");
INSERT INTO arq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","وكي كانو يَهَّدرو في هاد الشي، وْقَف يَسوع في وَسطهُم وقال: \"السْلام ليكُم\". ");
INSERT INTO arq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","نْخَلعو وخافو وحَسبو روحهُم شافو روحاني. ");
INSERT INTO arq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","قالَلهُم: \"عْلاش راكُم مَخلوعين وعْلاش جا الشَك في قْلوبكُم؟ ");
INSERT INTO arq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","شوفو يَدِيَّ ورَجلِيَّ، أنا هُوَ، مَسّوني وشوفو، الروحاني ما عَندو لا لْحَم لا عْضام كيما راكُم تْشوفو باللي عَندي\". ");
INSERT INTO arq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","وكي كان يْقول هاد الشي وَرّالهُم يَدّيه ورَجليه. ");
INSERT INTO arq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","كانو ما زال ما آمنوش من الفَرحة ومَستَغربين. قالَلهم: \"عَندكُم هْنا ماكلة؟\" ");
INSERT INTO arq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","عْطاولو شْوِيّة حوت مَشوي، ");
INSERT INTO arq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","أدّا منّو وكْلا قُدّامهُم. ");
INSERT INTO arq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","قالَلهُم: \"هَدا هُوَ كْلامي اللي قُلتهولكُم كي كُنت مازالني معاكُم، باللي لازَم يَتحَقَّق كُل شي مَكتوب علِيَّ في شَريعة موسى وكْتوب الأنبيا والمَزامير\"، ");
INSERT INTO arq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","أومبَعد حَلَّلهُم عْقولهُم باش يَفَّهمو الكْتوب، ");
INSERT INTO arq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","وقالَلهُم: \"هَكدا مَكتوب باللي المَسيح لازَم يَتعَدَّب ويْقوم ما بين الموتى فاليوم التالَت، ");
INSERT INTO arq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ويَتبَرَّح في آسمو بالتوبة لغُفران الدْنوب في كامَل الأُمّات ويَبداو بأورشَليم. ");
INSERT INTO arq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","أنتومَ راكُم شْهود على هاد الشي، ");
INSERT INTO arq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","وأنا نَبعَتَّلكُم اللي وْعَد بيه بابا. بَصَّح أقَّعدو فالمْدينة حَتّى تَتلَبّسو بقُوّة مالفوق\". ");
INSERT INTO arq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","وخَرَّجهُم لبَرّا من المْدينة وأدّاهُم قْريب لبيت عَنيا ورْفَد يَدّيه وبارَكهُم. ");
INSERT INTO arq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","وكي كان يْبارَك فيهُم، نْفرَق عليهُم ونَرفَد للسْما. ");
INSERT INTO arq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","سَجدولو، ورَجعو لأورشَليم بفَرحة كْبيرة، ");
INSERT INTO arq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","وكانو دايمًا فالمَعبَد يْسَبّحو فالله.");
INSERT INTO arq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","فالبَدية كانَت الكَلمة، والكَلمة كانَت مع الله، والكَلمة كانَت الله. ");
INSERT INTO arq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","كانَت فالبَدية مع الله، ");
INSERT INTO arq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","كُل شي كان بِيها، وحَتّى شي من اللي كان ما كان بلا بيها، ");
INSERT INTO arq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","فيها كانَت الحْياة، والحْياة كانَت النور لبْني آدَم، ");
INSERT INTO arq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","النور يْضَوّي فالضْلام والضْلام ما حَكموش. ");
INSERT INTO arq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","كان راجَل مَبعوت من عَند الله، واسمو يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","جا باش يْكون شاهَد، باش يَشهَد للنور، باش كامَل يامنو على يَدّو. ");
INSERT INTO arq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ما كانش هُوَ النور، كان شاهَد للنور. ");
INSERT INTO arq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","هاد النور كان هُوَ النور الحَقّاني اللي جا للدَنيا يْنَوَّر كُل بْنادَم، ");
INSERT INTO arq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","كان فالدَنيا، وبيه اللي نْدارَت الدَنيا، والدَنيا ما عَرفاتوش. ");
INSERT INTO arq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","جا لمَلكو، وناسو ما قَبلوهش. ");
INSERT INTO arq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","بَصَّح كامَل اللي قَبلوه، اللي آمنو بآسمو، عْطالهُم القُدرة باش يْوَلّيو وْلاد الله، ");
INSERT INTO arq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","نْوَلدو من الله، ماشي من الدَم وَلاّ بمُراد الدات وَلاّ بمُراد بْنادَم. ");
INSERT INTO arq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","الكَلمة وَلاّت دات، وسَكنَت بيناتنا، وشَفنا المَجد مْتاعها، مَجد كيما المَجد مْتاع الوْحيد اللي من الآب، مْعَمَّر بالنَعمة والحَق. ");
INSERT INTO arq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","شْهَدَّلها يوحَنَّا وعَيَّط وقال: \"هَدا هُوَ اللي قُلت عليه، يْجي من بَعدي وهُوَ سْبَقني، خاطَر كان قْبَل مَنّي\"، ");
INSERT INTO arq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ومْتاع الصَح، كامَل نَلنا من كْمالو نَعمة فوق نَعمة، ");
INSERT INTO arq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","خاطَر الشَريعة نَعطات بموسى، النَعمة والحَق وَصلو بيَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","واحَد ما شاف الله، المَزيود الوْحيد، الله اللي في حُضن الآب، هُوَ اللي عَرّفو.\" ");
INSERT INTO arq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","وهَدي هِيَ شْهادة يوحَنّا كي بَعتولو اليْهود من أورشَليم رْجال الدين واللاوِيّين باش يْسَقسيوَه: \"شْكون أنتَ؟\" ");
INSERT INTO arq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","سْتَعرَف وما نْكَرش، سْتَعرَف: \"ماشي أنا المَسيح\"، ");
INSERT INTO arq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","سَقساوَه: \"واش؟ أنتَ إيلِيّا؟\" قال: \"ماشي أنا\"، \"أنتَ النَبي؟\" واجَب: \"لالا\"، ");
INSERT INTO arq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","هِمّالا قالولو: \"شْكون أنتَ؟ باش نْجاوبو اللي بَعتونا، واش تْقول على روحَك؟\" ");
INSERT INTO arq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","قال: \"أنا صوت اللي يْعَيَّط فالخْلا، سَڤّمو طْريق الرَب كيما قال إشعِيا النَبي\". ");
INSERT INTO arq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","المْراسَل كانو فَرّيسِيّين، ");
INSERT INTO arq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","سَقساوَه وقالولو: \"وَعلاش هِمّالا تْعَمَّد وَلاّ أنتَ ماشي المَسيح، وَلا إيلِيّا، وَلا النَبي؟\" ");
INSERT INTO arq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","جاوَبهُم يوحَنّا وقال: \"أنا نْعَمَّد فالما، في وَسطكُم كايَن واحَد ما تَعَّرفوهش، ");
INSERT INTO arq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","يْجي من بَعدي وأنا ما نَستاهَلش نْحَل حتى خْيوط سَبّاطو.\" ");
INSERT INTO arq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","هاد الشي صْرا في بيت عَنيا، مور واد الأُردُن، وين كان يوحَنّا يْعَمَّد. ");
INSERT INTO arq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","غَدوة من داك، شاف يوحَنّا يَسوع جاي ليه وقال: \"هاوليك خْروف الله اللي يْنَحّي الخْطِيّة من الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","هُوَ اللي قُلت عليه، يْجي من بَعدي راجَل، هُوَ سْبَقني، خاطَر كان قْبَل مَنّي، ");
INSERT INTO arq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","وما كُنتش نَعَّرفو، بَصَّح باش يَضهَر هُوَ لإسرائيل، على جال هَدا اللي جيت أنا نْعَمَّد فالما\". ");
INSERT INTO arq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","وشْهَد يوحَنّا وقال: \"شَفت الروح هابَط كي الحْمامة من السْما، وبْقا عليه، ");
INSERT INTO arq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ما كُنتش نَعَّرفو، بَصَّح اللي بْعَتني نْعَمَّد فالما، هُوَ قاللي، اللي تْشوف الروح هابَط وباقي فوق مَنّو، هُوَ اللي يْعَمَّد فالروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","وأنا شَفت وشْهَدت باللي هَدا هُوَ بْن الله\". ");
INSERT INTO arq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","غَدوة من داك تاني، كان يوحَنّا ومعاه زوج من التابعين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","وكي شاف يَسوع جايَز قال: \"هاوليك خْروف الله\". ");
INSERT INTO arq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","كي سَمعوه الزوج تابعين مْتاعو يَهدَر، تَبّعو يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","دار يَسوع، شافهُم يْتَبّعو فيه وقالَلهُم: \"واش راكُم تْحَوّسو؟\" قالولو: \"رَبّي، اللي معناه شيخ، وين تَسكُن؟\" ");
INSERT INTO arq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","قالَلهُم: \"أرواحو، تْشوفو\". راحو وشافو وين كان ساكَن وقَعدو معاه هَداك اليوم، وكانَت الساعة جْوايَه الرَبعة مْتاع العْشِيّة. ");
INSERT INTO arq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","أندراوَس خو سَمعان بُطرُس كان واحَد من الزوج اللي سَمعو كْلام يوحَنّا، واللي تَبّعو يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","أندراوَس لْقا قْبَل خوه سَمعان وقاللو: \"لْقينا المِسِيّا\" ومَعناه المَسيح، ");
INSERT INTO arq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","وأدّاه لعَند يَسوع. مَيَّز فيه يَسوع وقال: \"أنتَ سَمعان بن يَوَنّا، رايَح تَتسَمّا \"صَفا\" ومعناه بُطرُس. ");
INSERT INTO arq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","غَدوة من داك، حَب يَسوع يْروح للجْليل، ولْقا فيلِبُّس وقاللو: \"تَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","فيلِبُّس كان من بيت صيدا، من مْدينة أندراوَس وبُطرُس. ");
INSERT INTO arq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","تْلاقا فيلِبُّس بنَتَنائيل وقاللو: \"رانا لْقينا اللي كْتَب عليه موسى فالشَريعة وكَتبو عليه الأَنبيا، يَسوع بَن يوسَف مْتاع الناصرة\"، ");
INSERT INTO arq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","قاللو نَتَنائيل: \"تَقدَر تْكون حاجة مْليحة من الناصرة؟\" قاللو فيلِبُّس: \"أرواح وشوف\". ");
INSERT INTO arq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","شاف يَسوع نَتَنائيل جاي ليه، قال عليه: \"هاو صَح إسرائيلي ما فيه حَتّى دْغُل\"، ");
INSERT INTO arq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","قاللو نَتَنائيل: \"كيفاش تَعرَفني؟\" واجبو يَسوع: \"قْبَل ما يْعَيَّطلَك فيلِبُّس، كي كُنت تَحت الكَرمة، شَفتَك\"، ");
INSERT INTO arq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","جاوبو نَتَنائيل وقال: \"شيخ، أنتَ بْن الله، أنتَ سَلطان إسرائيل\". ");
INSERT INTO arq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","جاوبو يَسوع وقاللو: \"كي قُلتلَك باللي شَفتَك تَحت الكَرمة آمَنت؟ رايَح تْشوف كْتَر من هَكدا\"، ");
INSERT INTO arq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","وقاللو: \"نْقولَلكُم الصَح الصَح، رايحين تْشوفو السْما مَحلولة، ومَلايكة الله يَطَّلعو ويَهَّبطو على بْن الإنسان\". ");
INSERT INTO arq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","بَعد تَلت أيّام، كان كايَن عُرس في قانا فالجْليل، وكانَت تَمّة يَمّات يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","يَسوع والتابعين مْتاعو تاني كانو مَعروضين للعُرس، ");
INSERT INTO arq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","خَص الشْراب، وقالَتلو يَمّاه ليَسوع: \"ما عَندهُمش الشْراب\" ");
INSERT INTO arq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","قالَلها يَسوع: \"يا مْرا، واش كايَن بيني وبينَك؟ مازال ما جاتش ساعتي\" ");
INSERT INTO arq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","قالَت يَمّاه للخَدّامين: \"ديرو كامَل واش يْقولَلكُم\" ");
INSERT INTO arq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","داك الوَقت، كانو كاينين تَمّة سَت قْساط مْتاع الحْجَر، مْخَلّيينهُم لليْهود باش يَطَّهرو، كُل قَسط تَرفَد قيس زوج وَلاّ تَلت كيلات كْبار. ");
INSERT INTO arq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","قالَلهُم يَسوع: \"عَمّرو القْساط بالما\"، عَمّروهُم حَتّى للفُم. ");
INSERT INTO arq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","وقالَلهُم: \"عَمّرو دُرك وأدّيو للي مْوَكَّل باش يْقوم بالوَليمة\". دارو هَكدا ");
INSERT INTO arq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","كي داق المْوَكَّل عالوَليمة الما اللي وَلاّ شْراب، وهُوَ ماشي عارَف منين جا هاد الشْراب، بَصَّح الخَدّامين اللي عَمّرو الما كانو عارفين، عَيَّط للعْريس، ");
INSERT INTO arq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","وقاللو: \"كُل إنسان يَسبَق يْسَربي قْبَل الشْراب المْليح وبَعدما يَسَّكرو الشْراب اللي يْسَربيه ما يْكونش مْليح كيما الأوّلاني، وأنتَ خَلّيت الشْراب المْليح حَتّى لدُرك.\" ");
INSERT INTO arq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","هَدي كانَت في قانا فالجْليل البَدية مْتاع المارات مْتاع يَسوع، وبَيَّن مَجدو، وآمنو بيه التابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","بَعد هَدا، هْبَط لكفرناحوم مع يَمّاه وخاوتو، والتابعين مْتاعو، وقَعدو تَمّة غير يامات. ");
INSERT INTO arq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","عيد الفَصح مْتاع اليْهود كان قْريب، وطْلَع يَسوع لأورشَليم، ");
INSERT INTO arq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ولْقا فالمَعبَد اللي يْبيعو الفْراد والغْنَم والحْمام واللي يْبَدّلو الدْراهَم قاعدين عالميدات مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","خْدَم مَشحَط بالحْبيلة، وحاوَزهُم كامَل مالمَعبَد بالغْنَم والفْراد، وزَربَع الصَرف مْتاع اللي يْبَدّلو الدْراهَم وقْلَب الميدات، ");
INSERT INTO arq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","وقال للي يْبيعو الحْمام: \"نَحّيو هَدا من هنا، ما تْرَدّوش دار بابا دار للتِجارة\". ");
INSERT INTO arq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","تْفَكّرو التابعين مْتاعو باللي مَكتوب: \"تاكُلني الغيرة على دارَك\" ");
INSERT INTO arq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","جاوبو اليْهود وقالولو: \"واشَن هِيَ المارة اللي تْوَرّيلنا، باش تْدير هَكدا؟\" ");
INSERT INTO arq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","واجَب يَسوع وقالَلهُم: \"هَدّو هاد المَعبَد وفي تَلت أيّام نْعاوَد نْوَقّفو\" ");
INSERT INTO arq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","قالو اليْهود: \"أتَّبنا هاد المَعبَد في سَتّة ورَبعين سْنة، وأنتَ تْعاوَد تَبنيه في تَلت أيّام؟\" ");
INSERT INTO arq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","هُوَ كان يَهدَر عالمَعبَد مْتاع داتو. ");
INSERT INTO arq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","كي قام من بين الموتى، تْفَكّرو التابعين مْتاعو باللي قال هاد الشي، وآمنو بالكْتوب والكَلمة اللي قالها يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","وكي كان في أورشَليم في عيد الفَصح، بَزّاف آمنو بآسمو كي شافو المارات اللي كان يْديرهُم، ");
INSERT INTO arq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","بَصَّح يَسوع ما كانش مْآمَنهُم، خاطَر كان يَعرَفهُم كامَل، ");
INSERT INTO arq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","وماكانش يَسحَق باش واحَد يَشهَدلو على بْنادَم، كان يَعرَف هُوَ واش كايَن في بْنادَم. ");
INSERT INTO arq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","كان واحَد الراجَل مالفَرّيسِيّين واسمو نيقوديموس، كان رايَس اليْهود، ");
INSERT INTO arq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","جا لعَند يَسوع فالليل وقاللو: \"سيدي، رانا عارفين باللي أنتَ شيخ جاي من عَند الله، خاطَر واحَد ما يَقدَر يْدير هاد المارات اللي راك تْدير إيلا ماكانش الله معاه.\" ");
INSERT INTO arq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","واجَب يَسوع وقاللو: \"نْقولَك الصَح الصَح: لو كان الواحَد ما يَنزادش مالفوق، ما يَقدَرش يْشوف مَلكوت الله.\" ");
INSERT INTO arq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","قاللو نيقوديموس: \"كيفاش يَنزاد الراجَل وهُوَ كْبير فالعْمَر؟ يَقدَر يَدخُل مَرّة تانية لكَرش يَمّاه ويَنزاد؟\" ");
INSERT INTO arq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","واجَب يَسوع: \"نْقولَك الصَح الصَح: لو كان الواحَد ما يَنزادش مالما والروح ما يَقدَرش يَدخُل لمَلَكوت الله. ");
INSERT INTO arq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","اللي نْزاد مالدات هُوَ دات، واللي نْزاد مالروح هُوَ روح. ");
INSERT INTO arq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ما تَستَغرَبش كي قُلتلَك: \"لازَم أنتومَ تَنزادو مالفوق، ");
INSERT INTO arq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","الريح يْصَفَّر وين يْحَب، وتَسمَع الصوت مْتاعو، بَصَّح ما تَعرَفش منين يْجي وَلا وين يْروح، هَكدا كُل من يَنزاد مالروح\". ");
INSERT INTO arq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","جاوَب نيقوديموس وقاللو: \"كيفاش يَقدَر يْكون هاد الشي؟\" ");
INSERT INTO arq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","جاوَب يَسوع وقاللو: \"أنتَ شيخ إسرائيل وما تَعرَفش هاد الشي؟ ");
INSERT INTO arq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","نْقولَك الصَح الصَح، نَهَّدرو واش نَعَّرفو، ونَشَّهدو بواش نْشوفو، وما تَقَّبلوش شهادَتنا، ");
INSERT INTO arq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","نْقولَلكُم الحاجات مْتاع الأرض وما تامنوش، كيفاش رايحين تامنو لوكان نْقولَلكُم عالحاجات مْتاع السْما؟ ");
INSERT INTO arq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","واحَد ما طْلَع للسْما من غير اللي هْبَط مالسْما، بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","وكيما رْفَع موسى الحْنَش فالخْلا، هَكدا لازَم يَتَّرفَع بْن الإنسان، ");
INSERT INTO arq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","باش كُل من يامَن بيه يْنال الحْياة الدايمة. ");
INSERT INTO arq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","خاطَر هَكدا حَب الله الدَنيا، حَتّى عْطا بْنو الوْحيد، باش كُل من يامَن بيه ما يْضيعش، وتْكونلو الحْياة الدايمة. ");
INSERT INTO arq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","والله ما بْعَتش وْليدو للدَنيا باش يْحاكَم الدَنيا، بَعتو باش بيه تَسلَك الدَنيا. ");
INSERT INTO arq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","اللي يامَن بيه ما يَتَّحكَمش عليه، بَصَّح اللي ما يامَنش بيه راهو تْحاكَم، خاطَر ما آمَنش بآسَم بْن الله الوْحيد. ");
INSERT INTO arq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","وهَدا هُوَ الحُكم، النور جا للدَنيا، وبْني آدَم حَبّو الضْلام في عوض النور، خاطَر فْعالهُم كانو دونِيّين، ");
INSERT INTO arq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","خاطَر كُل من يْدير الشَر، يَكرَه النور، وما يْجيش للنور باش ما يَنكَشفوش فْعالو، ");
INSERT INTO arq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","بَصَّح اللي يْدير الحَق يْجي للنور، باش يْبانو فْعالو، خاطَر نْدارو فالله. ");
INSERT INTO arq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","بَعد هَدا، راح يَسوع والتابعين مْتاعو لأَرض اليَهودِيّة، وقْعَد تَمّة معاهُم وكان يْعَمَّد. ");
INSERT INTO arq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","وكان يوحَنّا تاني يْعَمَّد في عين نون، قْريب من ساليم، خاطَر كان بَزّاف الما تَمّة وكانو يْجيو يَتعَمّدو، ");
INSERT INTO arq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ويوحَنّا كان مازال ما نَحبَسش. ");
INSERT INTO arq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","صْرات هَدرة بين التابعين مْتاع يوحَنّا وواحَد يْهودي على آمَر التَطهير، ");
INSERT INTO arq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","وراحو لعَند يوحَنّا وقالولو: \"شيخ، هاو اللي كان معاك من الجيهة الأخرى مْتاع واد الأُردُن واللي شْهَدتلو، راهو يْعَمَّد وكامَل راهُم يْروحو ليه.\" ");
INSERT INTO arq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","جاوَب يوحَنّا وقال: \"ما يَقدَرش بْنادَم يَدّي حاجة وَلاّ ما نَعطاتلوش من السْما، ");
INSERT INTO arq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","أنتومَ بالدات تَشَّهدو باللي قُلت أنا ماشي المَسيح، أنا مَرسول قَبلو. ");
INSERT INTO arq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","اللي عَندو العْروسة هُوَ العْريس، بَصَّح حْبيب العْريس اللي يْكون هْنا ويَسمَعلو، يَفرَح بَزّاف وهُوَ يَسمَع صوت العْريس، وفَرحتي هَدي هِيَ وراهي كاملة، ");
INSERT INTO arq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","لازَم هُوَ يَكبَر وأنا نَنقُص. ");
INSERT INTO arq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","اللي جا من الفوق، هُوَ فوق الكُل، واللي من الأرض، هُوَ من الأرض ويَهدَر على حْساب الأرض. اللي جا من السْما، هُوَ فوق الكُل، ");
INSERT INTO arq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","يَشهَد بواش شاف وسْمَع، وواحَد ما يَقبَل شْهادتو، ");
INSERT INTO arq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","اللي يَقبَل شْهادتو، يَستَعرف باللي الله حَق، ");
INSERT INTO arq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","اللي بَعتو الله يْقول كْلام الله، خاطَر الله ما يْمَدش الروح بالحْساب، ");
INSERT INTO arq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","الآب يْحَب الإبن وعْطالو كُل شي في يَدّو، ");
INSERT INTO arq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","اللي يامَن بالإبن، عَندو حْياة دايمة، بَصَّح اللي ما يَقبَلش يامَن بالإبن، ما يْشوفش حْياة ويْكون عليه زْعاف الله\". ");
INSERT INTO arq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","كي عْرَف يَسوع باللي الفَرّيسِيّين سَمعو باللي راهُم يْوَلّيو عَندو تابعين وراهو يْعَمَّد كْتَر من يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","والو يَسوع ما كانش هُوَ اللي يْعَمَّد، التابعين مْتاعو هومَ اللي كانو يْعَمّدو، ");
INSERT INTO arq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","خَلاّ اليَهودِيّة وعاوَد وَلاّ للجْليل، ");
INSERT INTO arq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","وكان لازَم يْجوز على السامرة. ");
INSERT INTO arq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","وْصَل هِمّالا لواحَد المْدينة مْتاع السامرة واسَمها سوخار، قْريبة من الأرض اللي عْطاها يَعقوب ليوسَف وْليدو، ");
INSERT INTO arq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","وتَم كان كايَن البير مْتاع يَعقوب، وعلى حْساب اللي كان يَسوع عَيّان من السْفَر، قْعَد قُدّام البير، وكانَت جْوايَه الطْناش مْتاع النْهار. ");
INSERT INTO arq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","جات واحَد المْرا سامرِيّة تْعَمَّر الما، وقالَلها يَسوع: \"أعطيني نَشرُب\"، ");
INSERT INTO arq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","التابعين مْتاعو كانو راحو للمْدينة يَشريو الماكلة. ");
INSERT INTO arq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","قالَتلو المْرا السامرِيّة: \"كيفاش أنتَ اللي يْهودي تَطلَب منّي أنا مْرا سامرية نَعطيك تَشرُب؟\" خاطَر اليْهود ما كانش عَندهُم عَلاقات مع السامرِيّين. ");
INSERT INTO arq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","جاوَب يَسوع وقالَلها: \"لوكان تَعَّرفي هِبة الله وشْكون اللي راهو يْقولَك أعطيني نَشرُب، كُنتي طْلَبتي منّو وهُوَ يَعطيك ما حَيّ\"، ");
INSERT INTO arq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","قالَتلو المْرا: \"سيدي، ما عَندكش بيدون والبير غامَق، منين هِمّالا يْكون عَندك هاد الما الحَي؟ ");
INSERT INTO arq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","مَحسوب أنتَ كْبير على بابانا يَعقوب اللي عْطالنا هاد البير وشْرَب منّو هُوَ ووْلادو والقْطيع مْتاعو؟\" ");
INSERT INTO arq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","واجَب يَسوع وقالَلها: \"كُل من يَشرُب من هاد الما يْزيد يَعطَش، ");
INSERT INTO arq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","بَصَّح اللي يَشرُب من الما اللي أنا نَعطيهولو، ما يْزيدش يَعطَش على الدْوام، والما اللي نَعطيهولو يْوَلّي فيه عَنصَر تْفيض منو الحْياة الدايمة\". ");
INSERT INTO arq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","قالَتلو المْرا: \"سيدي، أعطيني هاد الما باش ما نْزيدش نَعطَش وما نْزيدش نْجي اللَهنا نْعَمَّر\". ");
INSERT INTO arq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","قالَلها: \"روحي عَيّطي لراجلَك وأرواحي اللَهنا\"، ");
INSERT INTO arq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","واجبَت المْرا وقالَتلو: \"ما عَنديش راجَل\"، قالَلها يَسوع: \"عْمَلتي مْليح كي قُلتي ما عَنديش راجَل، ");
INSERT INTO arq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","خاطَر تْزَوَّجتي بخَمس رْجال، ودُرك اللي راهو عَندك ماشي راجلَك. في هَدي قُلتي الصَح\". ");
INSERT INTO arq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","قالَتلو المْرا: \"سيدي، راني نْشوف باللي أنتَ نَبي، ");
INSERT INTO arq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","جْدودنا عَبدو فوق هاد الجْبَل، وأنتومَ تْقولو باللي أورشَليم هِيَ المْكان اللي لازَم نَعَّبدو فيه\". ");
INSERT INTO arq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","قالَلها يَسوع: \"صَدقيني يا مْرا، يْجي وَقت وين ما رايحين تَعَّبدو الآب لا على هاد الجْبَل وَلا في أورشَليم، ");
INSERT INTO arq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","أنتومَ ما تَعَّرفوش اللي راكُم تَعّبدو فيه، حْنا اليْهود نَعَّرفو اللي نَعَّبدوه، خاطَر السْلاك يْجي من اليْهود. ");
INSERT INTO arq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","بَصَّح يْجي الوَقت، وراهو وْصَل، وين العابدين الحَقّانِيّين يَعَّبدو الآب فالروح وفالحَق، خاطَر هَدو هومَ العابدين اللي الآب يْحَوَّس عليهُم. ");
INSERT INTO arq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","الله روح، واللي يَعَّبدوه لازَم يَعَّبدوه فالروح وفالحَق.\" ");
INSERT INTO arq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","قالَتلو المْرا: \"راني عارفة باللي المِسِيّا اللي يْعَيّطولو المَسيح رايَح يْجي، كي يْجي يْخَبَّرنا بكُل شي\"، ");
INSERT INTO arq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","قالَلها يَسوع: \"المَسيح هُوَ اللي راهو يَهدَر معاك\". ");
INSERT INTO arq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","داك الوَقت جاو التابعين مْتاعو وسْتَغربو كي كان يَسوع يَهدَر مع مْرا، بَصَّح واحَد ما قال: \"واش راك تْحَوَّس\"، وَلاّ \"واش راك تَهدَر معاها؟\" ");
INSERT INTO arq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","خَلاّت المْرا القُلّة مْتاعها، وراحَت للمْدينة وقالَت للناس: ");
INSERT INTO arq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","\"أرواحو تْشوفو واحَد الإنسان قاللي كامَل واش دَرت، بَلاك يْكون هُوَ المَسيح؟\" ");
INSERT INTO arq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","خَرجو من المْدينة وراحو لعَندو. ");
INSERT INTO arq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","في هَداك الوَقت، كانو التابعين يَطَّلبو من يَسوع ويْقولو: \"شيخ، كول\"، ");
INSERT INTO arq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","هُوَ قالَلهُم: \"أنا راني رايَح ناكُل ماكلة أنتومَ ما تَعَّرفوهاش\". ");
INSERT INTO arq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","بْداو التابعين يْقولو لبَعضهُم بَعض: \"يْكون كاش واحَد جابلو ياكُل؟\" ");
INSERT INTO arq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","قالَلهُم يَسوع: \"نْدير مُراد اللي بْعَتني ونْكَمَّل الخَدمة مْتاعو، هَدي هِيَ ماكَلتي، ");
INSERT INTO arq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ماشي تْقولو أنتومَ مازال رَبع شْهور ويْجي الحْصاد؟ هاني نْقولَلكُم: أرَّفدو عينيكُم وشوفو الحْصايَد، راهُم واجدين للحْصاد. ");
INSERT INTO arq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","الحَصّاد يَدّي خْلاصو، ويْلَم الغَلّة للحْياة الدايمة، باش اللي يَزرَع واللي يَحصَد يَفَّرحو كيف كيف، ");
INSERT INTO arq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","خاطَر في هاد الشي، صْحيح المْتَل اللي يْقول: \"واحَد يَزرَع وواحَد يَحصَد\"، ");
INSERT INTO arq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","أنا بْعَتتكُم أنتومَ تَحَّصدو في اللي ما تْعَبتوش فيه، واحَدُخرين تَعبو وأنتومَ دْخَلتو في خَدمَتهُم\". ");
INSERT INTO arq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","بَزّاف من السامرِيّين اللي آمنو بيه في هاد المْدينة على جال كْلام المْرا اللي شَهدَت: \"قاللي كامل واش دَرت\"، ");
INSERT INTO arq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","كي جاو ليه السامرِيّين، طَلبو منّو يَبقا عَندهُم وبْقا تَم يومين. ");
INSERT INTO arq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","بَزّاف زادو آمنو على جال كْلامو، ");
INSERT INTO arq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","وكانو يْقولو للمْرا: \"ماشي على حْكايتَك اللي آمننا، خاطَر حْنا بالدات سْمَعنا ورانا عارفين باللي صَح هَدا هُوَ سَلاّك الدَنيا\". ");
INSERT INTO arq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","بَعد اليومين، خْرَج يَسوع من تَم وراح للجْليل، ");
INSERT INTO arq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","هُوَ بالدات شْهَد باللي النَبي ما يَتكَرَّمش في بْلادو. ");
INSERT INTO arq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","كي وْصَل للجْليل، سْتَقبلوه الجْليلِيّين كي شافو كامَل واش دار في أورشَليم فالعيد، خاطَر هومَ بالدات راحو يَحَّضرو العيد. ");
INSERT INTO arq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","زاد راح لقانا مْتاع الجْليل وين رَد الما شْراب، وكان في كفرناحوم واحَد من العَسكَر مْتاع السَلطان وْليدو مْريض. ");
INSERT INTO arq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","سْمَع باللي يَسوع وْصَل من اليَهودِيّة للجْليل، وراح ليه يَطلَب منّو يَهبَط ويَشفي وْليدو خاطَر كان فالمَماة. ");
INSERT INTO arq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","هِمّالا قاللو يَسوع: \"لو كان ما تْشوفوش مارات وعْجايَب، ما تامنوش\"، ");
INSERT INTO arq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","قاللو العَسَّكري مْتاع السَلطان: \"سيدي، أهبَط قْبَل ما يْموت وْليدي\"، ");
INSERT INTO arq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","قاللو يَسوع: \"روح، وْليدَك راهو حَي\". آمَن الراجَل بالكْلام اللي قالهولو يَسوع وراح. ");
INSERT INTO arq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","كي كان هابَط، جاو لاقاوَه الخَدّامين مْتاعو يْقولو باللي وْليدو راهو حَي. ");
INSERT INTO arq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","سْتَخبَر منهُم واش من الساعة وَلاّ وْليدو خير من اللي كان، قالولو: \"البارَح على الواحدة مْتاع النْهار راحَتلو الحَمّى\". ");
INSERT INTO arq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","عْرَف الباباة باللي في هَديك الساعة اللي قاللو يَسوع: \"وْليدَك راهو حَي\"، وآمَن هُوَ وكامَل دارو. ");
INSERT INTO arq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","وزاد دار يَسوع هاد المُعجِزة التانية بَعد ما جا من اليَهودِيّة للجْليل. ");
INSERT INTO arq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","بَعد هَدا، كان كايَن عيد مْتاع اليْهود، وطْلَع يَسوع لأورشَليم، ");
INSERT INTO arq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","وكايَن في أورشَليم قُدّام باب الغْنَم واحَد الڤَلتة سَمّاوها بالعَبرِيّة بيت زاتا، كانو دايرين بيها خَمس سِطوانات، ");
INSERT INTO arq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","كانو مْكَسّلين فيهُم بَزّاف من المَرضى عَميين، كَعوانين ومَشلولين. ");
INSERT INTO arq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","وكان تَمّة واحَد الإنسان مْريض من تْمَنِية وتْلاتين سْنة. ");
INSERT INTO arq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","كي شافو يَسوع مْكَسَّل، وكان عارَف باللي طال عليه الوَقت، قاللو: \"راك حاب تَبرا؟\" ");
INSERT INTO arq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","واجبو المْريض: \"سيدي، ما كان حَتّى واحَد يَرميني للڤَلتة كي يَتحَرَّك الما، وكي نْكون رايَح نَهبَط، يَهبَط واحَد قْبَل منّي\". ");
INSERT INTO arq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","قاللو يَسوع: \"نوض، أرفَد فْراشَك وروح\". ");
INSERT INTO arq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","تَم تَم بْرا الراجَل، رْفَد فْراشو ومْشا، وداك اليوم كان سَبت. ");
INSERT INTO arq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","هِمّالا قالو اليْهود للي بْرا: \"اليوم السَبت، ما يْجوزلَكش تَرفَد فْراشَك\"، ");
INSERT INTO arq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","هُوَ جاوَبهُم: \"اللي شْفاني، هَداك قاللي أرفَد فْراشَك وأمشي\". ");
INSERT INTO arq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","سَقساوَه: \"شْكون هُوَ الإنسان اللي قالَك أرفَد وأمشي؟\" ");
INSERT INTO arq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","هَدا اللي بْرا ما كانش يَعرَف شْكون هُوَ خاطَر يَسوع غاب من الغاشي اللي كان في داك المْكان. ");
INSERT INTO arq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","بَعد هَدا لْقاه يَسوع فالمَعبَد وقاللو: \"هاك بْريت، ما تْزيدش تدنَب باش ما يَصرالَكش كْتَر من هَكدا\". ");
INSERT INTO arq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","بَعَّد الراجَل وخَبَّر اليْهود باللي يَسوع هُوَ اللي شْفاه. ");
INSERT INTO arq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","على هَدا، كانو اليْهود شاحنين على يَسوع خاطَر كان يْدير هاد الشي في يوم السَبت، ");
INSERT INTO arq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","بَصَّح يَسوع جاوَبهُم: \"بابا مازالو يَخدَم حَتّى لدُرك وأنا نَخدَم\". ");
INSERT INTO arq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","على هَدا، زادو اليْهود حَوّسو كْتَر باش يَقُّتلوه، خاطَر ماشي بَرك كان يْخالَف السَبت، وزاد كان يْقول على الله باللي باباه، وساوا روحو بالله. ");
INSERT INTO arq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","جاوَبهُم يَسوع وقالَلهُم: \"نْقولَلكُم الصَح الصَح، الإبن ما يَقدَر يْدير حَتّى حاجة من عَندو، من غير واش يْشوف الآب يْدير، واش يْدير هَداك، الإبن تاني يْديرو، ");
INSERT INTO arq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","خاطَر الآب يْحَب الإبن، ويْوَرّيلو كامَل واش يْدير هُوَ، ورايَح يْوَرّيلو عْمال كْبار على هَدو باش تَدَّهشو. ");
INSERT INTO arq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","كيما الآب يْنَوَّض الموتى ويَحييهُم، الإبن تاني يَحيي اللي يْحَب. ");
INSERT INTO arq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","الآب ما يْحاكَم حَتّى واحَد، عْطا للإبن باش يْحاكَم، ");
INSERT INTO arq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","باش كامَل يْكَرّمو الإبن كيما يْكَرّمو الآب، اللي ما يْكَرَّمش الإبن ما يْكَرَّمش الآب اللي بَعتو. ");
INSERT INTO arq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","نْقولَلكُم الصَح الصَح، باللي اللي يَسمَع كْلامي ويامَن باللي بْعَتني عَندو الحْياة الدايمة، وما يَتحاكَمش خاطَر جاز من الموت للحْياة. ");
INSERT INTO arq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","نْقولَلكُم الصَح الصَح، تْجي الساعة وراهي جات وين الموتى يَسَّمعو صوت بْن الله، واللي يَسَّمعوه يَحياو، ");
INSERT INTO arq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","خاطَر كيما الآب عَندو الحْياة فيه، هَكدا تاني عْطا للإبن باش تْكون عَندو الحْياة فيه، ");
INSERT INTO arq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","وعْطاه القُدرة باش يْحاكَم، خاطَر هُوَ بْن الإنسان. ");
INSERT INTO arq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ما تَستَغربوش من هاد الشي، خاطَر تْجي الساعة وين كامَل اللي راهُم فالقْبور يَسَّمعو صوتو، ");
INSERT INTO arq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ويْروحو اللي دارو الخير لقِيامة الحْياة، بَصَّح اللي دارو الشَر لقِيامة المْحاسبة. ");
INSERT INTO arq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","أنا ما نَقدَر نْدير حَتّى حاجة من عَندي، كيما نَسمَع نْحاسَب، والمْحاسبة مْتاعي حَقِّيّة، خاطَر ما نْحَوَّسش على مُرادي، نْحَوَّس على مُراد اللي بْعَتني. ");
INSERT INTO arq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","لوكان نَشهَد لروحي، شْهادتي ماشي صْحيحة، ");
INSERT INTO arq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","واحَدآخُر اللي يَشهَدلي، وراني عارَف باللي شْهادتو علِيَّ صْحيحة، ");
INSERT INTO arq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","أنتومَ بْعَتتو ليوحَنّا وشْهَد للحَق. ");
INSERT INTO arq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","أنا ما نَستَنّاش شْهادة بْنادَم، بَصَّح نْقول هاد الشي باش تَسَّلكو. ");
INSERT INTO arq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","يوحَنّا كان الشَمعة الشاعلة والضاوية، وحَبّيتو تَتمَتّعو ساعة فالنور مْتاعو، ");
INSERT INTO arq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","أنا عَندي شْهادة كْبيرة على شْهادة يوحَنّا، خاطَر الأَعمال اللي عْطاهُملي الآب باش نْكَمَّلهُم، هاد الأَعمال بالدات اللي نْديرهُم يَشَّهدولي باللي الآب بْعَتني، ");
INSERT INTO arq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","والآب اللي بْعَتني هُوَ يَشهَدلي، ما في عْمَركُم سْمَعتو صوتو، ما شَفتو وجهو، ");
INSERT INTO arq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","وما عَندكُمش الكَلمة مْتاعو تابتة فيكُم، خاطَر ما تامنوش اللي بَعتو هُوَ. ");
INSERT INTO arq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","تْدَقّقو فالكْتوب خاطَر حاسبين تْكون عَندكُم الحْياة الدايمة بيهُم، وهومَ يَشَّهدولي، ");
INSERT INTO arq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","بَصَّح ما تْحَبّوش تْجيو لِيَّ باش تْكون عَندكُم حْياة. ");
INSERT INTO arq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","أنا ما نْحَوَّسش المَجد من عَند الناس، ");
INSERT INTO arq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","وراني نَعرَفكُم باللي ما عَندكُمش مْحَبّة الله فيكُم، ");
INSERT INTO arq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","أنا جيت بآسَم بابا وما قْبَلتونيش، لوكان واحَدآخُر يْجي بآسمو، هُوَ تَقَّبلوه، ");
INSERT INTO arq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","كيفاش تَقَّدرو تامنو وأنتومَ تْحَّوسو تْنالو المَجد من بَعضكُم بَعض، والمَجد اللي من الله وَحدو ما تْحَوّسوش عليه. ");
INSERT INTO arq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","بَلاكو تَحَّسبو باللي أنا نَتهَمكُم قُدّام الآب، اللي يَتهَمكُم هُوَ موسى اللي رْجيتو فيه، ");
INSERT INTO arq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","خاطَر لوكان تامنو بموسى، تامنو بِيَّ، خاطَر هُوَ كْتَب علِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","بَصَّح وَلاّ ما تامنوش بواش كْتَب هُوَ، كيفاش تامنو بكْلامي؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","بَعد هَدا، بَعَّد يَسوع للجيهة الأخرى مْتاع بْحَر الجْليل، البْحَر مْتاع طَبَرِيّة، ");
INSERT INTO arq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","وتَبّعو غاشي كْبير خاطَر كانو يْشوفو المارات اللي كان يْديرهُم على المرضى. ");
INSERT INTO arq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","طْلَع يَسوع فوق الجْبَل وقْعَد تَمّة مع التابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","الفَصح، عيد اليْهود كان قْريب، ");
INSERT INTO arq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","وكي رْفَد عينيه، شاف يَسوع غاشي كْبير جاي ليه، وقال لفيلِبُّس: \"منين نَشريو الخُبز باش ياكلو هَدو؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","قال هاد الشي باش يْجَرّبو، خاطَر هُوَ كان عارَف واش رايَح يْدير. ");
INSERT INTO arq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","واجبو فيلِبُّس: \"حَتّى ميتين دينار مْتاع الخُبز ما يَكفيوش باش كُل واحَد يَدّي شْوِيّة\"، ");
INSERT INTO arq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","قاللو واحَد من التابعين مْتاعو، أندراوَس خو سَمعان بُطرُس: ");
INSERT INTO arq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"كايَن وْلَد صْغير هْنا عَندو خَمس خُبزات مْتاع الشْعير وزوج حوتات، بَصَّح واش يَكفي منهُم لهَدو كامَل؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","قال يَسوع: \"قَعّدو الناس\". كان بَزّاف الحْشيش في هَداك المْكان والناس قَعدو، كانو واحَد الخَمس آلاف. ");
INSERT INTO arq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","خْدا يَسوع الخُبز وبَعد ما حْمَد، فَرّقو للناس مع الحوت وعْطالهُم قَد ما حَبّو. ");
INSERT INTO arq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","وكي شَبعو، قال للتابعين مْتاعو: \"لَمّو واش فْضَل من الخُبز باش ما يْضيع والو\". ");
INSERT INTO arq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","لَمّو وعَمّرو طْناشَن قُفّة من الطْراف اللي فَضلو بَعد ما كْلاو من خَمس خُبزات مْتاع الشْعير. ");
INSERT INTO arq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","الناس كي شافو المارة اللي دارها قالو: \"هَدا صَح هُوَ النَبي اللي يْجي للدَنيا\"، ");
INSERT INTO arq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","عْرَف يَسوع باللي رايحين يْجيو يَخَّطفوه باش يْديروه سَلطان، وزاد جْبَد روحو وَحدو فالجْبَل. ");
INSERT INTO arq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","كي جات العْشِيّة، هَبطو التابعين مْتاعو للبْحَر، ");
INSERT INTO arq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","رَكبو في فْلوكة وراحو للجيهة الأخرى مْتاع البْحَر اللي في كَفرناحوم، وطاحَت الضَلمة ويَسوع كان ما زال ما لْحَقهُمش. ");
INSERT INTO arq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ناض ريح قْوي هَيَّج البْحَر، ");
INSERT INTO arq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","كانو بَعّدو قيس خَمسة وَلاّ سَتّة كيلومَتر كي شافو يَسوع يَمشي على البْحَر ويْقَرَّب للفْلوكة وخافو. ");
INSERT INTO arq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","قالَلهُم هُوَ: \"أنا هُوَ، ما تْخافوش\"، ");
INSERT INTO arq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","حَبّو يَدّيوَه فالفْلوكة بَصَّح تَم تَم وَصلو للأرض اللي كانو رايحين ليها. ");
INSERT INTO arq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","غَدوة من داك، الغاشي اللي كانو فالجيهة الأخرى مْتاع البْحَر، شافو باللي ما كانَتش كاينة فْلوكة واحَدوخرى، كانَت غير فْلوكة واحدة، وباللي يَسوع ما رْكَبش مع التابعين مْتاعو في هَديك الفْلوكة، والتابعين راحو وَحَّدهُم. ");
INSERT INTO arq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","فْلايَك واحَدُخرين جاو من طَبَرِيّة قْريب من المْكان اللي كْلاو فيه الخُبز بَعدما الرَب يَسوع شْكَر الله. ");
INSERT INTO arq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","هِمّالا كي شاف الغاشي باللي يَسوع ما كاشو تَمّة لا هُوَ، لا التابعين مْتاعو، طَلعو فالفْلايَك وراحو لكَفرناحوم يْحَوّسو عليه. ");
INSERT INTO arq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","وكي لْقاوَه فالجيهة الأخرى مْتاع البْحَر قالولو: \"شيخ، وَقتاش جيت اللَهنا؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","واجَبهُم يَسوع وقال: \"نْقولَلكُم الصَح الصَح، راكُم تْحَوّسو علِيَ ماشي على جال اللي شَفتو مارات، على جال اللي كْليتو الخُبز وشْبَعتو، ");
INSERT INTO arq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","أخَّدمو ماشي على جال القوت الفاني، أخَّدمو على جال القوت الباقي للحْياة الدايمة، اللي يَعطيهولكُم بْن الإنسان، خاطَر هَدا الله الآب طَبعو بالطابَع مْتاعو\". ");
INSERT INTO arq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","هِمّالا قالولو: \"واش نديرو باش نَخَّدمو في خَدمة الله؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","واجَب يَسوع وقالَلهُم: \"هَدي هِي الخَدمة مْتاع الله، كي تامنو باللي بَعتو هُوَ\"، ");
INSERT INTO arq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","قالولو: \"هِمّالا واشن هِيَ المارة اللي تْديرها باش نْشوفو ونامنو بيك؟ واش تْدير؟ ");
INSERT INTO arq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","جْدودنا كْلاو المَن فالخْلا على حْساب ماهو مَكتوب \"عْطالهُم ياكلو خُبز السْما\"، ");
INSERT INTO arq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","هِمّالا قالَلهُم يَسوع: \"نْقولَلكُم الصَح الصَح، ماشي موسى اللي عْطالكُم خُبز السْما، بابا يَعطيلكُم خُبز السْما الحَقّاني، ");
INSERT INTO arq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","خاطَر خُبز الله هُوَ اللي يَهبَط من السْما ويَعطي الحْياة للدَنيا\"، ");
INSERT INTO arq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","هِمّالا قالولو: \"سيدي، أعطيلنا دايمًا هاد الخُبز\"، ");
INSERT INTO arq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","قالَلهُم يَسوع: \"أنا هُوَ خُبز الحْياة، اللي يْجي لعَندي ما يْجوعش، واللي يامن بِيَّ عَمرو ما يَعطَش. ");
INSERT INTO arq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","بَصَّح قُلتهالكُم، شَفتوني وما آمَنتوش، ");
INSERT INTO arq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","اللي يَعطيهولي الآب كامَل يْجي لِيَّ، واللي يْجي لِيَّ ما نَرميهش بَرّا، ");
INSERT INTO arq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","خاطَر هْبَطت من السْما ماشي باش نْدير مُرادي، باش نْدير مُراد اللي بْعَتني، ");
INSERT INTO arq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","هَدا هُوَ المُراد مْتاع اللي بْعَتني: ما نْبَحَّر والو من كامَل واش عْطاني، بالعَكس نَحييه فاليوم الأَخَّر. ");
INSERT INTO arq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","هَدا هُوَ مُراد بابا: كُل من يْشوف الإبن ويامَن بيه يْنال الحْياة الدايمة، وأنا نَحييه فاليوم الأخَّر\". ");
INSERT INTO arq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","بْداو اليْهود يْدَمدمو عليه خاطَر قال: \"أنا هُوَ الخُبز اللي هْبَط من السْما\"، ");
INSERT INTO arq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","وكانو يْقولو: \"هَدا ماشي يَسوع وْليد يوسَف اللي نَعَّرفو باباه ويَمّاه؟ كيفاش دُرك يْقول: هْبَطت من السْما؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","واجَب يَسوع وقالَلهُم: \"ما تْدَمدموش مع بَعضكُم بَعض، ");
INSERT INTO arq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","واحَد ما يَقدَر يْجي لعَندي غير لو كان الآب اللي بْعَتني يَجَّبدو، وأنا نَحييه فاليوم الأخَّر. ");
INSERT INTO arq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","مَكتوب في كْتوب الأنبيا: \"كامَل يَتعَلّمو من الله، كُل من سْمَع وتْعَلَّم من الآب يْجي لِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","مانيش نْقول باللي كاش واحَد شاف الآب من غير اللي من الله، هُوَ شاف الآب. ");
INSERT INTO arq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","نْقولَلكُم الصَح الصَح، اللي يامَن عَندو الحْياة الدايمة، ");
INSERT INTO arq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","أنا خُبز الحْياة، ");
INSERT INTO arq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","جْدودكُم كْلاو المَن فالخْلا وماتو، ");
INSERT INTO arq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","هاو الخُبز اللي يَهبَط من السْما، باش اللي ياكُل منّو ما يْموتش، ");
INSERT INTO arq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","أنا الخُبز الحَي اللي هْبَط من السْما، لو كان واحَد ياكُل من هاد الخُبز يَحيا على الدْوام، والخُبز اللي نَعطيه أنا هُوَ داتي لحْياة الدَنيا\". ");
INSERT INTO arq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","بْداو اليْهود يَدّاوسو بيناتهُم ويْقولو: \"كيفاش يَقدَر هَدا يَعطينا داتو ناكلوها؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","هِمّالا قالَلهُم يَسوع: \"نْقولَلكُم الصَح الصَح، لو كان ما تاكلوش دات بْن الإنسان وما تَشَّربوش دَمّو، ما عَندكُمش الحْياة فيكُم، ");
INSERT INTO arq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","بَصَّح اللي ياكُل داتي ويَشرَب دَمّي عَندو الحْياة الدايمة وأنا نَحييه فاليوم الأخَّر، ");
INSERT INTO arq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","خاطَر داتي هِيَ القوت الحَقّاني، ودَمّي هُوَ المَشروب الحَقّاني، ");
INSERT INTO arq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","اللي ياكُل داتي ويَشرُب دَمّي يَبقا فِيَّ وأنا فيه، ");
INSERT INTO arq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","وكيما الآب الحَي بْعَتني كيما أنا نَحيا بالآب، هَكدا اللي ياكُلني هَداك تاني يَحيا بِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","هَدا هُوَ الخُبز اللي هْبَط من السْما، ماشي كيما المَن اللي كْلاوَه جْدودكُم وماتو، اللي ياكُل هاد الخُبز يَحيا على الدْوام\". ");
INSERT INTO arq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","قال هاد الكْلام فالمَجمَع وهُوَ يْدَرَّس في كَفرناحوم. ");
INSERT INTO arq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","كي سَمعوه، بَزّاف من التابعين مْتاعو اللي قالو: \"هاد الكْلام صْعيب، شْكون يَقدَر يَسَّمعو؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","عْرَف يَسوع في روحو واش كانو التابعين مْتاعو يْدَمدمو على هاد الشي وقالَلهُم: \"هاد الشي يْعَتَّركُم؟ ");
INSERT INTO arq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","هِمّالا لو كان تْشوفو بْن الإنسان طالَع وين كان من قْبَل؟ ");
INSERT INTO arq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","الروح هُوَ اللي يَحيي، الدات ما تَنفَع في والو، والكْلام اللي قُلتهولكُم روح وحْياة، ");
INSERT INTO arq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","بَصَّح كايَن فيكُم اللي ما يامنوش\". خاطَر يَسوع كان عارَف من الأوَّل شْكون هومَ اللي ما يامنوش وشْكون اللي رايَح يْسَلّمو، ");
INSERT INTO arq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","وقال: \"على هَدا قُلتَلكُم، واحَد ما يَقدَر يْجي لِيَّ غير وَلاّ أتَّعطالو هاد الشي من الآب\". ");
INSERT INTO arq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","من تَم، بَزّاف من التابعين مْتاعو جَبدو روحهُم وما وَلاّوش يَمشيو معاه. ");
INSERT INTO arq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","هِمّالا قال يَسوع للرُسُل الطْناش: \"ما راكُمش حابّين أنتومَ تاني تَجَّبدو روحكُم؟\" ");
INSERT INTO arq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","واجبو سَمعان بُطرُس: \"سيدي، لعَند من نْروحو؟ كْلام الحْياة الدايمة عَندك، ");
INSERT INTO arq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","حْنا آمَنّا وعْرَفنا باللي أنتَ قُدّوس الله.\" ");
INSERT INTO arq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","جاوَبهُم يَسوع: \"ماشي أنا خَيَّرتكُم أنتومَ الطْناش؟ وواحَد فيكُم شيطان\"، ");
INSERT INTO arq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","كان يَهدَر على يَهودا وْليد سَمعان الإسخريوطي، خاطَر هُوَ اللي كان رايَح يْسَلّمو، وهُوَ واحَد من الطْناش\". ");
INSERT INTO arq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","بَعد هَدا، كان يَسوع يَمشي فالجْليل خاطَر ما حَبش يَبقا فاليَهودِيّة، على جال اللي اليْهود كانو يْحَوّسو يَقُّتلوه. ");
INSERT INTO arq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","كان عيد الخْيَم، عيد اليْهود قْريب، ");
INSERT INTO arq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","هِمّالا قالولو خاوتو: \"بَعَّد من هْنا وروح لليَهودِيّة باش التابعين مْتاعك تاني يْشوفو عْمالَك اللي تْديرهُم، ");
INSERT INTO arq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","خاطَر واحَد ما يَخدَم بالتْخَبية وَلاّ حَب يْبان. وَلاّ تْدير هاد الحاجات، بَيَّن روحَك للناس\"، ");
INSERT INTO arq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","خاطَر حَتّى خاوتو وخْواتاتو ما كانوش يامنو بيه. ");
INSERT INTO arq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","هِمّالا قالَلهُم يَسوع: \"ما زال ما راهوش وَقتي، بَصَّح وَقتكُم دايمًا واجَد، ");
INSERT INTO arq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","الدَنيا ما تَقدَرش تَكرَهكُم، بَصَّح أنا تَكرَهني خاطَر نَشهَد عليها باللي عْمالها دونِيّين، ");
INSERT INTO arq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","أنتومَ، روحو أحضرو العيد، أنا ما نْروحش لهاد العيد، خاطَر ما وْصَلش وَقتي\". ");
INSERT INTO arq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","بَعد ما قال هَكدا بْقا فالجْليل. ");
INSERT INTO arq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","كي طَلعو خاوتو للعيد، داك الوَقت هُوَ تاني طْلَع ماشي عيناني، كي اللي بالتْخَبية. ");
INSERT INTO arq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","كانو اليْهود يْحَوّسو عليه فالعيد ويْقولو: \"وين راهو هَداك؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","وكان الغاشي يْدَمدَم عليه بَزّاف. كايَن اللي كانو يْقولو: \"هُوَ مْليح\"، واحَدُخرين كانو يْقولو: \"لالا، راهو يْضَيَّع فالغاشي\". ");
INSERT INTO arq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","واحَد ما كان يَهدَر عليه عيناني من الخوف من اليْهود. ");
INSERT INTO arq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","في نَص العيد، طْلَع يَسوع للمَعبَد وبْدا يْدَرَّس. ");
INSERT INTO arq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","سْتَغربو اليْهود وقالو: \"كيفاش هَدا يَعرَف الكْتوب وهُوَ ما قْراش؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","جاوَبهُم يَسوع وقال: \"التَعليم مْتاعي ماشي من عَندي، من اللي بْعَتني، ");
INSERT INTO arq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","وَلاّ واحَد حَب يْدير مْرادو، يَعرَف من هاد التَعليم وَلاّ من عَند الله وَلاّ راني نَهدَر من عَندي. ");
INSERT INTO arq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","اللي يَهدَر من عَندو، يْحَوَّس على المَجد مْتاعو، بَصَّح اللي يْحَوَّس على المَجد مْتاع اللي بَعتو، هَداك حَقّاني وما فيهش الدْغُل. ");
INSERT INTO arq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ماشي موسى عْطالكُم الشَريعة؟ وواحَد فيكُم ما راهو يْطَبَّق فالشَريعة، عْلاش راكُم تْحَوّسو تَقُّتلوني؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","واجبو الغاشي: \"فيك شيطان، شْكون يْحَوَّس يَقُّتلَك؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","واجَب يَسوع وقالَلهُم: \"دَرت خَدمة واحدة وكامَل راكُم داهشين، ");
INSERT INTO arq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","على جال اللي موسى عْطالكُم الخْتانة، والو ما جاتش من موسى، خاطَر جات من الجْدود، تْخَتّنو راجَل بالسَبت، ");
INSERT INTO arq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","وَلاّ كان راجَل يَتخَتَّن فالسَبت باش ما تْخالفوش شَريعة موسى، عْلاش زْعَفتو علِيَ كي شْفيت إنسان بكْمالو في يوم سَبت؟ ");
INSERT INTO arq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ما تَحَّكموش على حْساب الوْجوه، أحَّكمو بالحَق\". ");
INSERT INTO arq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","كانو شي ناس من أورشَليم يْقولو: \"ماشي هَدا اللي راهُم يْحَوّسو يَقُّتلوه؟ ");
INSERT INTO arq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","هاوليك يَهدَر عيناني وما قالولو والو، يْكونو الرِيّاس سْتَعرفو باللي صَح هُوَ المَسيح؟ ");
INSERT INTO arq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","هَدا نَعَّرفو منينو، بَصَّح المَسيح كي يْجي واحَد ما يَعرَف منين هُوَ\". ");
INSERT INTO arq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","عَيَّط يَسوع وهُوَ يْدَرَّس فالمَعبَد وقال: \"وأنا تَعَّرفوني وتَعَّرفو منين أنا، أنا ما جيتش من عَندي، بَصَّح اللي بْعَتني حَقّاني، وأنتومَ ما تَعَّرفوهش، ");
INSERT INTO arq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","أنا نَعَّرفو، خاطَر أنا من عَندو، وهُوَ اللي بْعَتني.\" ");
INSERT INTO arq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","كانو يْحَوّسو يَحَّكموه، بَصَّح واحَد ما رْما يَدّو عليه خاطَر كانَت مازال ما وَصلَتش ساعتو. ");
INSERT INTO arq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","بَزّاف من الغاشي اللي آمنو بيه وكانو يْقولو: \"المَسيح كي يْجي، رايَح يْدير مارات كْتَر من اللي دارهُم هَدا؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","سَمعو الفَرّيسِيّين الغاشي يْدَمدَم هَكدا عليه، وبَعتو رِيّاس رْجال الدين والفَرّيسِيّين خَدّامين باش يَحَّكموه. ");
INSERT INTO arq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","قال يَسوع: \"مازاللي وَقت قْصير معاكُم ونْروح للي بْعَتني، ");
INSERT INTO arq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","تْحَوّسو علِيَ وما تَلقاونيش، ووين نْكون ما تَقَّدروش تْجيو.\" ");
INSERT INTO arq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","قالو اليْهود بيناتهُم: \"وين راهو رايَح يْروح هَدا وين ما نَقَّدروش نَلقاوَه؟ ما يْكونش رايَح يْروح عَند اللي راهُم مْزَربعين عَند اليونانِيّين ويْدَرَّس عَندهُم؟ ");
INSERT INTO arq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","واش هاد الكْلام اللي قال، تْحَوّسو علِيَ وما تَلقاونيش، ووين نْكون أنتومَ ما تَقَّدروش تْجيو؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","فاليوم الأخَّر، اليوم الكْبير مْتاع العيد، وْقَف يَسوع وعَيَّط وقال: \"وَلاّ واحَد راهو عَطشان، غير يْجي لِيَّ ويَشرُب، ");
INSERT INTO arq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","اللي يامن بِيَّ، كيما يْقول الكْتاب، يْفيضو من صَدرو ويدان مْتاع الما الحي\". ");
INSERT INTO arq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","قال هاد الشي على الروح اللي كانو رايحين يْنالوه اللي يامنو بيه، خاطَر الروح كان مازال ما نَعطاش، على جال اللي يَسوع كان مازال ما دْخَلش فالمَجد مْتاعو. ");
INSERT INTO arq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","كايَن من الغاشي اللي سَمعو هاد الكْلام وقالو: \"صَح هَدا هُوَ النَبي\"، ");
INSERT INTO arq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","وواحَدُخرين قالو: \"هَدا المَسيح\". واحَدُخرين قالو: \"عْلاش، المَسيح يْجي من الجْليل؟ ");
INSERT INTO arq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ماشي الكْتاب يْقول باللي من دَرِّيَّة داوَد، من دَشرة بيت لَحم، منين كان داوَد، اللي يْجي المَسيح؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ونْقَسمو الغاشي بسْبابو. ");
INSERT INTO arq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","كايَن منهُم اللي حَبّو يَحَّكموه، بَصَّح واحَد ما رْما يَدّيه عليه. ");
INSERT INTO arq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","راحو الخَدّامين لرِيّاس رْجال الدين والفَرّيسِيّين وقالولهُم: \"وَعلاش ما جَبتوهش؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","واجبو العَسّاسين: \"عَمرو ما بْنادَم هْدَر هَكدا\"، ");
INSERT INTO arq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","واجبوهُم الفَرّيسِيّين: \"أنتومَ تاني نَخدَعتو؟ ");
INSERT INTO arq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","كايَن واحَد من الحُكّام وَلاّ من الفَرّيسِيّين اللي آمَن بيه؟ ");
INSERT INTO arq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","بَصَّح هَداك الغاشي اللي ما يَعرَفش الشَريعة مَنعولين\". ");
INSERT INTO arq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","قالَلهُم نيقوديموس اللي راح عَند يَسوع من قْبَل وكان واحَد منهُم، ");
INSERT INTO arq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","\"الشَريعة مْتاعنا تَحكُم على بْنادَم قْبَل ما تَسمَعلو وتَعرَفو واش دار؟\" ");
INSERT INTO arq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","واجبو وقالولو: \"أنتَ تاني من الجْليل؟ حَوَّس وشوف باللي من الجْليل ما يَخرُجش نَبي\". ");
INSERT INTO arq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","وكُل واحَد راح لدارو. ");
INSERT INTO arq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","راح يَسوع لجْبَل الزيتون، ");
INSERT INTO arq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","مع الفْجَر، زاد راح للمَعبَد، وكامَل الشَعب جا ليه. قْعَد وبْدا يَدَرَّس فيهُم. ");
INSERT INTO arq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","جابو الكُتّاب والفَرّيسِيّين مْرا حَكموها وهِيَ تَزني، وحَطّوها فالوَسط. ");
INSERT INTO arq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","قالولو: \"شيخ، هاد المْرا نْحَكمَت وهِيَ تَزني، ");
INSERT INTO arq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","كْتَب موسى فالشَريعة مْتاعو باللي اللي بْحالها يَترَجمو، وأنتَ واش تْقول؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","قالو هاد الشي باش يْجَرّبوه، باش يَقَّدرو يَتَّهموه. بَصَّح يَسوع طابَس للتَحت وكان يَكتَب بصْباعو على الأرض. ");
INSERT INTO arq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","وكي بْقاو غير يْسَقسيو فيه، ناض وقالَلهُم: \"اللي بلا دْنوب فيكُم يَرمي الأوّلاني الحجرة\"، ");
INSERT INTO arq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","وزاد طابَس وبْدا يَكتَب على الأرض. ");
INSERT INTO arq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","هومَ كي سَمعو، بْداو من الكْبير للصْغير يَخُّرجو واحَد واحَد وبْقا يَسوع وَحدو والمْرا فالوَسط. ");
INSERT INTO arq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","عاوَد يَسوع ناض وقالَلها: \"يا مْرا، وين راهُم؟ واحَد ما حْكَم عليك؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","قالَت هِيَ: \"حَتّى واحَد سيدي\". قال يَسوع: \"وأنا ما نَحكَمش عليك، روحي ومن دُرك ما تْزيديش تَدَنبي.\" ");
INSERT INTO arq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","زاد هْدَر معاهُم يَسوع وقال: \"أنا نور الدَنيا، اللي يْتَبَّعني ما يَمشيش فالضَلمة، يْكون عَندو نور الحْياة\"، ");
INSERT INTO arq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","قالولو الفَرّيسِيّين: \"أنتَ تَشهَد على روحَك، شْهادتَك ماشي صْحيحة\"، ");
INSERT INTO arq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","واجَب يَسوع وقالَلهُم: \"والو أنا نَشهَد لروحي، شْهادتي صْحيحة، خاطَر راني نَعرَف منين جيت ولوين نْروح، بَصَّح أنتومَ ما تَعَّرفوش منين جيت وَلا لوين نْروح. ");
INSERT INTO arq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","أنتومَ تَحَّكمو بعَقلِيّة بْنادَم، بَصَّح أنا ما نَحكُم على حَتّى واحَد. ");
INSERT INTO arq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","وَلاّ حْكَمت، الحُكم مْتاعي صْحيح خاطَر مارانيش وَحدي، راني مع الآب اللي بْعَتني. ");
INSERT INTO arq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","مَكتوب فالشَريعة مْتاعكُم باللي شْهادة زوج بْني آدَم صْحيحة، ");
INSERT INTO arq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","أنا نَشهَد لروحي والآب اللي بْعَتني يَشهَدلي\". ");
INSERT INTO arq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","قالولو: \"وين راه باباك؟\" واجَب يَسوع: \"ما تَعَّرفوني لا أنا لا بابا، لوكان جيتو تَعَّرفوني كُنتو تَعَّرفو بابا تاني\". ");
INSERT INTO arq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","قال يَسوع هاد الكْلام في بيت الخَزنة وهُوَ يْدَرَّس فالمَعبَد، وواحَد ما حَكمو خاطَر مازال ما كانَتش ساعتو. ");
INSERT INTO arq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","وزاد قالَلهُم: \"أنا راني رايَح، ورايحين تْحَوّسو علِيَ، وتْموتو في دْنوبكُم. ما تَقَّدروش تْجيو وين راني رايَح\"، ");
INSERT INTO arq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","وقالو اليْهود: \"رايَح يُقتَل روحو، خاطَر راهو يْقول، وين نْروح، أنتومَ ما تَقَّدروش تْجيو؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","قالَلهُم: \"أنتومَ من صْحاب التَحت، وأنا من صْحاب الفوق، أنتومَ من هاد الدَنيا، وأنا ماشي من هاد الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","على هَدا قُلتَلكُم، تْموتو في دْنوبكُم. خاطَر وَلاّ ما تامنوش باللي أنا هُوَ، تْموتو في دْنوبكُم\". ");
INSERT INTO arq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","قالولو: \"أنتَ شْكون؟\" قالَلهُم يَسوع: \"واش راني نْقولَلكُم من الأوَّل؟ ");
INSERT INTO arq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","عَندي بَزّاف واش نْقول عليكُم وواش نْحاكَم، بَصَّح اللي بْعَتني حَقّاني، وأنا اللي سْمَعتو منّو، هَداك اللي نْقول للدَنيا\". ");
INSERT INTO arq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ما عَرفوش باللي كان يَهدَرَّلهُم على الآب، ");
INSERT INTO arq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","على هَدا قالَلهُم يَسوع: \"كي تَرَّفعو بْن الإنسان، داك الساع تَعَّرفو باللي أنا هُوَ، وباللي ما نْدير حَتّى حاجة من عَندي، بَصَّح الشي اللي يْعَلَّمهولي الآب هَداك اللي نْقول، ");
INSERT INTO arq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","اللي بْعَتني راهو معايَ وما خَلاّنيش وَحدي، خاطَر نْدير دايمًا الحاجات اللي يَعَّجبوه\". ");
INSERT INTO arq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","كي قال هاد الشي، بَزّاف آمنو بيه. ");
INSERT INTO arq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","قال يَسوع لليْهود اللي آمنو بيه: \"لوكان تَبقاو في كْلامي، تْكونو صَح التابعين مْتاعي، ");
INSERT INTO arq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","وتَعَّرفو الحَق والحَق يْحَرَّركُم\". ");
INSERT INTO arq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","جاوبوه: \"حْنا دَرِّيّة إبراهيم، وعْمَرنا ما كُنّا عْبيد لحَتّى واحَد. كيفاش أنتَ تْقول باللي رايحين تْولّيو حْرار؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","واجَبهُم يَسوع: \"نْقولَلكُم الصَح الصَح، كُل من يْدير الدْنوب عَبد للدْنوب، ");
INSERT INTO arq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","العَبد ما يْدومش دايمًا فالدار، وْليد الدار يْدوم دايمًا، ");
INSERT INTO arq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","وَلاّ حَرَّركُم الإبن، تْوَلّيو حْرار مْتاع الصَح. ");
INSERT INTO arq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","راني عارَف باللي أنتومَ وْلاد إبراهيم، بَصَّح حَبّيتو تَقُّتلوني خاطَر كْلامي ما لْقاش مْكان فيكُم، ");
INSERT INTO arq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","نَهدَر بالشي اللي شَفتو عَند بابا، وأنتومَ تْديرو الشي اللي سْمَعتوه من عَند باباكُم\". ");
INSERT INTO arq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","جاوبو وقالولو: \"بابانا هُوَ إبراهيم\"، قالَلهُم يَسوع: \"لوكان كُنتو وْلاد إبراهيم لوكان دَرتو عْمال إبراهيم، ");
INSERT INTO arq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","دُرك راكُم تْحَوّسو تَقُّتلوني، وأنا راجَل يْقولَلكُم الصَح اللي سْمَعتو من عَند الله. هاد الشي إبراهيم ماداروش، ");
INSERT INTO arq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","أنتومَ تْديرو عْمال باباكُم\". قالولو: \"حْنا ما زَدناش من الزِنا، عَندنا باباة واحَد، الله\". ");
INSERT INTO arq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","قالَلهُم يَسوع: \"لو كان الله باباكم كُنتو تْحَبّوني، خاطَر أنا خْرَجت من الله وجيت، ما جيتش من راسي، هُوَ اللي بْعَتني. ");
INSERT INTO arq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","عْلاش ما تَعَّرفوش لُغتي؟ خاطَر ما تْقَدروش تَسَّمعو كْلامي، ");
INSERT INTO arq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","أنتومَ وْلاد باباكُم إبليس، وتْحَبّو تْديرو واش يْحَب باباكُم، هَداك كان قَتّال من الأوَّل وما تْبَتش فالحَق خاطَر ما كاش فيه حَق. كي يَكدَب، كْلامو يْجي منّو خاطَر هُوَ كَدّاب وباباة الكْدَب، ");
INSERT INTO arq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","بَصَّح أنا كي نْقول الصَح ما تامنونيش. ");
INSERT INTO arq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","شْكون فيكُم يَقدَر يْبَيَّن فِيَّ الدْنوب؟ وَلاّ نْقول الصَح، وَعلاش ما تامنونيش؟ ");
INSERT INTO arq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","اللي من الله يَسمَع كْلام الله، على هَدا أنتومَ ما تَسَّمعوش، خاطَر أنتومَ ماشي من الله؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","جاوبو اليْهود وقالولو: \"ماشي عَندنا الحَق كي نْقولو باللي أنتَ سامري وفيك شيطان؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","واجَب يَسوع: \"أنا ما فِيّاش شيطان، أنا نْكَرَّم بابا وأنتومَ هَنتوني، ");
INSERT INTO arq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","أنا ما نْحَوَّسش المَجد مْتاعي، كايَن اللي راهو يْحَوَّس عليه ويْحاسَب. ");
INSERT INTO arq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","نْقولَلكُم الصَح الصَح، وَلاّ واحَد حْفَض كْلامي، ما يْشوفش الموت للدْوام\". ");
INSERT INTO arq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","قالولو اليْهود: \"دُرك عْرَفنا باللي فيك شيطان، إبراهيم مات، والأَنبيا تاني، وأنتَ تْقول: وَلاّ واحَد حْفَض كْلامي، ما يْدوقش الموت للدْوام، ");
INSERT INTO arq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","أنتَ كْبير على بابانا إبراهيم اللي مات؟ والأَنبيا ماتو، واش راك حاسَب روحَك؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","واجَب يَسوع: \"وَلاّ كُنت أنا نَعطي المَجد لروحي، المَجد مْتاعي والو، بابا هُوَ اللي يَعطيني المَجد، هُوَ اللي راكُم تْقولو عليه إلَهنا. ");
INSERT INTO arq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","أنتومَ ما تَعَّرفوهش، بَصَّح أنا نَعَّرفو، وَلاّ قُلت ما نَعَّرفوش، نْكون كيما أنتومَ، كَدّاب، بَصَّح أنا نَعَّرفو ونَحفَض كْلامو، ");
INSERT INTO arq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","شْحال تْشَوَّق باباكُم إبراهيم باش يْشوف نْهاري وشافو وفْرَح\". ");
INSERT INTO arq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","قالولو اليْهود: \"مازال ما عَندكش خَمسين سْنة وشَفت إبراهيم؟\" ");
INSERT INTO arq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","قالَلهُم يَسوع: \"نْقولَلكُم الصَح الصَح، قْبَل ما كان إبراهيم، أنا راني\". ");
INSERT INTO arq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","رَفدو الحْجَر باش يَرَّجموه، ويَسوع تْخَبّا وخْرَج من المَعبَد. ");
INSERT INTO arq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","كان يَسوع جايَز وشاف واحَد عْمى من اللي نْزاد. ");
INSERT INTO arq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","سَقساوَه التابعين مْتاعو وقالو: \"شيخ، شْكون اللي دْنَب؟ هَدا وَلاّ مْواليه باش نْزاد عْمى؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","واجَب يَسوع: \"لا هَدا دْنَب وَلا مْواليه، بَصَّح نْزاد عْمى باش يْبانو عْمال الله فيه، ");
INSERT INTO arq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","لازَمنا نْديرو عْمال اللي بْعتني مادام النهار، يْجي الليل وين واحَد ما يَقدَر يَخدَم، ");
INSERT INTO arq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","مادامني فالدَنيا، أنا نور الدَنيا\". ");
INSERT INTO arq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","بَعد ما قال هَكدا، بْزَق فالتْراب، ودار طين بالبْزاق ودْهَن عينين العْمى بالطين، ");
INSERT INTO arq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","وقاللو: \"روح، أغسَل في ڤَلتة سَلوام (سَلوام مَعنَتها المَرسول)\". راح العْمى، غْسَل وجا يْشوف. ");
INSERT INTO arq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","الجيران واللي كانو يْشوفوه يَطلَب قالو: \"ماشي هَدا اللي كان يَقعُد يَطلَب؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","كايَن اللي قالو: \"هَدا هُوَ\"، وواحَدُخرين قالو: \"لالا، يْشَبَّهلو\"، وهُوَ كان يْقول: \"أنا هُوَ\". ");
INSERT INTO arq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","وكانو يْقولولو: \"كيفاش هِمّالا نْحَلّو عينيك؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","واجَب هُوَ: \"الإنسان اللي يْسَمّيوَه يَسوع دار الطين ودْهَنلي عينِيَّ وقاللي، روح لسَلوام وأغسَل، كي رُحت وغْسَلت وَلّيت نْشوف\"، ");
INSERT INTO arq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","قالولو: \"وين راهو هَدا؟\" قالَلهُم: \"ما رانيش عارَف\". ");
INSERT INTO arq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","أدّاو اللي كان عْمى عَند الفَرّيسِيّين، ");
INSERT INTO arq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","كان يوم سَبت نْهار دار يَسوع الطين وحَلّو عينينه. ");
INSERT INTO arq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","زادو سَقساوَه هاد المَرّة مع الفَرّيسِيّين كيفاش وَلاّ يْشوف، قالَلهُم هُوَ: \"حَط الطين على عينِيَّ وغْسَلت وراني نْشوف\". ");
INSERT INTO arq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","قالو شي فَرّيسِيّين: \"هاد الإنسان ماشي من عَند الله، خاطَر ما يْطَبَّقش السَبت\"، بَصَّح واحَدُخرين قالو: \"كيفاش يَقدَر بْنادَم خاطي يْدير مارات كي هَدو؟\" وتْخالفو ما بيناتهُم. ");
INSERT INTO arq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","زادو قالو للعْمى: \"واش تْقول أنتَ عليه، أنتَ اللي حَلَّك عينيك؟\" قالَلهُم باللي هُوَ نَبي. ");
INSERT INTO arq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ما آمنوش اليْهود باللي كان عْمى ووَلاّ يْشوف حَتّى عَيّطو لمْواليه، ");
INSERT INTO arq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","وسَقساوهُم وقالو: \"هَدا وْليدكُم اللي تْقولو باللي نْزاد عْمى؟ كيفاش دُرك راهو يْشوف؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","جاوبو مْواليه وقالو: \"رانا عارفين باللي هَدا وْليدنا وباللي نْزاد عْمى، ");
INSERT INTO arq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","كيفاش دُرك راهو يْشوف ما راناش عارفين، وشْكون حَلّو عينيه ما راناش عارفين، سَقسيوَه هُوَ، راهو كْبير، يَهدَر على روحو\". ");
INSERT INTO arq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","مْواليه قالو هاد الكْلام من الخوف من اليْهود، خاطَر اليْهود تْفاهمو باللي لو كان واحَد يَستَعرَف بيه باللي المَسيح يَتحاوَز من المَجمَع، ");
INSERT INTO arq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","على هَدا اللي قالو: \"راهو كْبير، سَقسيوَه\". ");
INSERT INTO arq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","هِمّالا زادو عَيّطو للراجَل اللي كان عْمى وقالولو: \"سَبَّح الله، رانا عارفين باللي هاد الإنسان خاطي\"، ");
INSERT INTO arq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","هِمّالا واجَبهُم هُوَ: \"وَلاّ هُوَ خاطي، أنا ما رانيش عارَف، نَعرَف حاجة واحدة، باللي كُنت عْمى ودُرك راني نْشوف\". ");
INSERT INTO arq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","قالولو: \"واش دارلَك؟ كيفاش حَلَّك عينيك؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","واجَبهُم: \"قُلتَلكُم وما سْمَعتوش. وَعلاش راكُم حابّين تْزيدو تَسَّمعو؟ أنتومَ تاني حابّين تْوَلّيو تابعين مْتاعو؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","سَبّوه وقالو: \"أنتَ التابَع مْتاع هَداك، حْنا التابعين مْتاع موسى، ");
INSERT INTO arq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","حْنا رانا عارفين باللي الله هْدَر مع موسى، بَصَّح هَدا ما نَعَّرفوش منينو\". ");
INSERT INTO arq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","واجَب الراجَل وقالَلهُم: \"هَدي موغريبة، ما تَعَّرفوش منينو وهُوَ حَلّلي عينِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","نَعَّرفو باللي الله ما يَسمَعش للخاطيين، بَصَّح لو كان يْكون واحَد تَقي، ويْدير مُرادو يَسمَعلو، ");
INSERT INTO arq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","عَمرو ما نَسمَع باللي كاش واحَد حَل عينين واحَد زاد عْمى، ");
INSERT INTO arq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","لوكان هاد الراجَل ما كانش من الله، ما يَقدَر يْدير والو\". ");
INSERT INTO arq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","جاوبو وقالولو: \"أنتَ بكْمالَك زَدت فالدْنوب وتْجي تْعَلَّمنا\"، ورْماوَه بَرّا. ");
INSERT INTO arq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","سْمَع يَسوع باللي رْماوَه بَرّا وكي لْقاه قاللو: \"تامَن بإبن الإنسان؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","واجَب هُوَ وقال: \"وشْكون هُوَ يا سيدي باش نامَن بيه؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","قاللو يَسوع: \"شَفتو، وهُوَ اللي راهو يَهدَر معاك\"، ");
INSERT INTO arq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","قال الراجَل: \"نامَن يا رَبّي\"، وسْجَدلو. ");
INSERT INTO arq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","قال يَسوع: \"باش نَفرَز اللي جيت أنا لهاد الدَنيا، باش العَميين يْشوفو، واللي يْشوفو يْوَلّيو عَميين\". ");
INSERT INTO arq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","شي فَرّيسِيّين اللي كانو معاه سَمعو وقالولو: \"وحْنا تاني عَميين؟\" ");
INSERT INTO arq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","قالَلهُم يَسوع: \"لوكان جيتو عَميين ما يْكونش عَندكُم دَنب، دُرك راكُم تْقولو باللي تْشوفو، على هَدا يَبقا الدَنب مْتاعكُم\". ");
INSERT INTO arq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","وقال: \"نْقولَلكُم الصَح الصَح، اللي ما يَدخُلش من باب المَرعى، ويَطلَع من جيهة أخرى، هَداك سَرّاق وخَطّاف، ");
INSERT INTO arq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","بَصَّح اللي يَدخُل من الباب هُوَ راعي الخَرفان. ");
INSERT INTO arq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","البَوّاب يَفتَحلو، والخَرفان يَسَّمعو صوتو، يْعَيَّط للخَرفان مْتاعو بآسَمهُم ويَدّيهُم بَرّا. ");
INSERT INTO arq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","كي يْخَرَّج كامَل الخَرفان مْتاعو، يَسبَق يَمشي قُدّامهُم وهومَ يْتَبّعوه خاطَر يَعَّرفو صوتو، ");
INSERT INTO arq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","بَصَّح البَرّاني ما يْتَبّعوهش، يَهَّربو منّو خاطَر ما يَعَّرفوش صوت البْراوِيّة\". ");
INSERT INTO arq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","قالَلهُم يَسوع هاد المْتَل بَصَّح هومَ ما فَهموش واش كان يْقولَلهُم. ");
INSERT INTO arq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","هِمّالا زاد قال يَسوع: \"نْقولَلكُم الصَح الصَح، أنا هُوَ باب الخَرفان، ");
INSERT INTO arq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","كامَل اللي جاو قْبَل منّي سَرّاقين وخَطّافين، بَصَّح الخَرفان ما سَمعولهُمش. ");
INSERT INTO arq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","أنا هُوَ الباب، اللي يَدخُل منّي يَسلَك، يَدخُل ويَخرُج ويَلقا وين يَرعا، ");
INSERT INTO arq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","السَرّاق يْجي غير باش يَسرَق ويَدبَح ويَهلَك، أنا جيت باش تْكون ليهُم حْياة، وتْكون ليهُم فايضة، ");
INSERT INTO arq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","أنا هُوَ الراعي المْليح، الراعي المْليح يْمَد حْياتو للخَرفان، ");
INSERT INTO arq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","الخَدّام اللي ماشي هُوَ الراعي واللي الخَرفان ماشي مْتاعو يْشوف الديب جاي، يْخَلّي الخَرفان ويَهرَب والديب يَخطَفهُم ويْزَربَعهُم، ");
INSERT INTO arq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","خاطَر هُوَ خَدّام وما يْهَمّوهش الخَرفان. ");
INSERT INTO arq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","أنا الراعي المْليح، نَعرَف الخَرفان مْتاعي وهومَ يَعَّرفوني، ");
INSERT INTO arq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","كيما يَعرَفني الآب وأنا نَعَّرفو، وحْياتي نْمَدّها على جال الخَرفان مْتاعي، ");
INSERT INTO arq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","عَندي خَرفان واحَدُخرين ما راهُمش من هاد المَرعى، وهَدوك لازَم نْجيبهُم ويَسَّمعو صوتي، ويْوَلّي قْطيع واحَد وراعي واحَد. ");
INSERT INTO arq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","على هَدا اللي الآب يْحَبّني، خاطَر أنا نْمَد حْياتي باش نْعاوَد نَدّيها، ");
INSERT INTO arq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","واحَد ما يْنَحّيهالي، أنا نْمَدّها بمْحَبّة خاطري، عَندي القُدرة باش نْمَدها وعَندي القُدرة باش نْعاوَد نَدّيها، هَدا هُوَ الفَرض اللي آمَرني بيه بابا\". ");
INSERT INTO arq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","زادو تْخالفو اليْهود على جال هاد الكْلام، ");
INSERT INTO arq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","بَزّاف منهُم قالو: \"فيه شيطان ومَهبول، وَعلاش تَسَّمعولو؟\" ");
INSERT INTO arq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","واحَدُخرين قالو: \"هاد الكْلام ماشي مْتاع واحَد ساكنو شيطان، الشيطان يَقدَر يْحَل عينيين العَميين؟\" ");
INSERT INTO arq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","وْصَل الوَقت باش يَحتَفلو بعيد المَعبَد الجْديد، كانو فالشْتا، ");
INSERT INTO arq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","وكان يَسوع يَمشي فالمَعبَد في سِطوان سُلَيمان. ");
INSERT INTO arq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","دارو بيه اليْهود وقالولو: \"لوَقتاش نَبقاو مْعَلّقين؟ وَلاّ كُنت أنتَ المَسيح، قولَلنا\"، ");
INSERT INTO arq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","واجَبهُم يَسوع: \"قُلتَلكُم وما آمَنتوش، والأَعمال اللي نْديرهُم بآسَم بابا هومَ يَشَّهدولي، ");
INSERT INTO arq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","بَصَّح أنتومَ ما تامنوش خاطَر ما راكُمش من الخَرفان مْتاعي. ");
INSERT INTO arq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","الخَرفان مْتاعي يَسَّمعو صوتي، أنا نَعرَفهُم وهومَ يْتَبَّعوني، ");
INSERT INTO arq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","وأنا نَعطيلهُم الحْياة الدايمة، للدْوام ما يْموتوش وواحَد ما يْنَحّيهُم من يَدّي. ");
INSERT INTO arq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","بابا اللي عْطاهُملي هُوَ الكْبير كامَل، وواحَد ما يَقدَر يْنَحّي حاجة من يَد الآب، ");
INSERT INTO arq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","أنا والآب واحَد\". ");
INSERT INTO arq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","زادو اليْهود رَفدو الحْجَر باش يَرَّجموه. ");
INSERT INTO arq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","جاوَبهُم يَسوع: \"وَرّيتَلكُم بَزّاف عْمال مْلاح من عَند الآب، على آما فيهُم تَرَّجموني؟\" ");
INSERT INTO arq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","واجبوه اليْهود: \"ما راناش نَرَّجمو فيك على جال خَدمة مْليحة، رانا نَرَّجمو فيك على جال الكُفر خاطَر أنتَ اللي بْنادَم دايَر روحَك الله\"، ");
INSERT INTO arq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","جاوَبهُم يَسوع: \"ماشي مَكتوب فالشَريعة مْتاعكُم، أنا قُلت أنتومَ آلِهة؟ ");
INSERT INTO arq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","وَلاّ صَح سَمّات آلِهة هَدوك اللي كان ليهُم كْلام الله، والكْتاب ما يَقدَرش يْبَطَل، ");
INSERT INTO arq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","أنتومَ تْقولو للي قَدّسو الآب وبَعتو للدَنيا، راك تَكفَر، خاطَر قُلت أنا بْن الله؟ ");
INSERT INTO arq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","لو كان ما نْديرش عْمال بابا، ما تامنونيش، ");
INSERT INTO arq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","بَصَّح لو كان نْدير عْمال بابا، حَتّى لو كان ما تامنونيش، آمنو هَدوك الأَعمال، باش تْكونو عْرَفتو وتَعَّرفو باللي الآب فِيَّ وأنا فيه\". ");
INSERT INTO arq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","زادو حَبّو يَحَّكموه وفْلَت من يَدّيهُم، ");
INSERT INTO arq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","وزاد بَعَّد للجيهة الأخرى مْتاع واد الأردُن فالمْكان اللي كان يوحَنّا يْعَمَّد فيه من قْبَل وبْقا تَمّة. ");
INSERT INTO arq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","بَزّاف جاو ليه وكانو يْقولو باللي يوحَنّا ما دار حَتّى مارة بَصَّح كامَل واش قال على هَدا كان صَح، ");
INSERT INTO arq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","وبَزّاف آمنو بيه تَمّة. ");
INSERT INTO arq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","كان واحَد المْريض واسمو لِعازَر من بيت عَنيا، من الدَشرة مْتاع مَريَم وخُتها مَرتا، ");
INSERT INTO arq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","مَريَم هِيَ اللي كانَت دَهنَت الرَب بالريحة ومَسحَتلو رَجليه بشْعَرها، وخوها لِعازَر كان مْريض، ");
INSERT INTO arq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","بَعتو الخْواتات ليَسوع وقالو: \"سيدي، شوف، هَداك اللي تْحَبّو راهو مْريض\". ");
INSERT INTO arq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","كي سْمَع يَسوع، قال: \"هاد المَرض ماشي للموت، هاد المَرض لمَجد الله، باش بْن الله يْنال بيه المَجد\". ");
INSERT INTO arq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","هِمّالا، والو كان يَسوع يْحَب مَرتا وخُتها ولِعازَر، ");
INSERT INTO arq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","كي سْمَع باللي لِعازَر كان مْريض، بْقا فالمْكان اللي كان فيه يومين. ");
INSERT INTO arq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","أومبَعد، بَعد هَدا قال للتابعين: \"هَيّا نْعادو نْروحو لليَهودِيّة\"، ");
INSERT INTO arq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","قالولو التابعين: \"رَبّي، غير كيما اليْهود كانو يْحَوّسو يَرَّجموك، وتْزيد تْروح لتَمّة؟\" ");
INSERT INTO arq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","قال يَسوع: \"ماشي كايَن طْناشَن ساعة فالنْهار؟ لو كان واحَد يَمشي فالنْهار ما يَعتَرش، خاطَر يْشوف النور مْتاع هاد الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","بَصَّح لو كان يَمشي فالليل يَعتَر، خاطَر ما فيهش النور\". ");
INSERT INTO arq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","قال هَكدا أومبَعد قالَلهُم: \"حْبيبنا لِعازَر رْقَد بَصَّح راني رايَح نْنَوّضو\"، ");
INSERT INTO arq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","قالولو التابعين مْتاعو: \"سيدي، وَلاّ راهو راقَد، يَسلَك\". ");
INSERT INTO arq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","يَسوع كان يَقصَد موتو بَصَّح هومَ حَسبوه يَهدَر على راحة الرْقاد. ");
INSERT INTO arq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","هِمّالا قالَلهُم يَسوع عيناني: \"لِعازَر مات، ");
INSERT INTO arq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","وعلى جالكُم راني فَرحان اللي ما كُنتش تَمّة باش تامنو، هَيّا نْروحو ليه\". ");
INSERT INTO arq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","قال توما اللي يْسَمّيوَه التومي للتابعين الأخرين: \"هَيّا نْروحو حْنا تاني باش نْموتو معاه\". ");
INSERT INTO arq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","كي راحو، لْقا يَسوع لِعازَر فالقْبَر من رَبع أيّام، ");
INSERT INTO arq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","كانَت بيت عَنيا قْريبة من أورشَليم بواحَد التَلت كيلومِترات، ");
INSERT INTO arq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","كانو جاو بَزّاف من اليْهود عَند مَرتا ومَريَم باش يْعَزّيوهُم في خوهُم. ");
INSERT INTO arq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","كي سَمعَت مَرتا باللي يَسوع راهو جاي، جات باش تْلاقيه، بَصَّح مَريَم كانَت قاعدة فالدار. ");
INSERT INTO arq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","قالَت مَرتا ليَسوع: \"سيدي، لو كان كُنت هنا، ما كانش خويَ يْموت، ");
INSERT INTO arq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","بَصَّح دُرك تاني راني عارفة باللي كامَل واش تَطلَب من الله، الله يَعطيهولَك\". ");
INSERT INTO arq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","قالَلها يَسوع: \"خوك رايَح يْقوم من الموت\"، ");
INSERT INTO arq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","قالَتلو مَرتا: \"راني عارفة باللي رايَح يْقوم من الموت فالقِيامة فاليوم الأخَّر\"، ");
INSERT INTO arq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","قالَلها يَسوع: \"أنا هُوَ القِيامة والحْياة، اللي يامَن بِيَّ حَتّى لو كان يْموت يَحيا، ");
INSERT INTO arq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","وكُل حَي يامَن بِيَّ ما يْموتش للدْوام، تامني بهاد الشي؟\" ");
INSERT INTO arq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","قالَتلو: \"إيه سيدي، نامَن باللي أنتَ هُوَ المَسيح بْن الله اللي يْجي للدَنيا\". ");
INSERT INTO arq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","بَعدما قالَت هَكدا، راحَت وعَيّطَت لمَريَم خُتها بالتْخَبية وقالَت: \"السِيَّد راهو هْنا وراهو يْعيَّطلَك\". ");
INSERT INTO arq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","مَريَم غير سَمعَت ناضَت بالخَف وجات لعَندو. ");
INSERT INTO arq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","يَسوع كان مازال ما جاش للدَشرة، كان فالمْكان اللي لاقاتو فيه مَرتا، ");
INSERT INTO arq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","واليْهود اللي كانو مع مَريَم فالدار وكانو يْعَزّيو فيها، كي شافوها ناضَت وخَرجَت بالخَف، راحو معاها حاسبينها رايحة تْروح للقْبَر باش تَبكي تَمّة. ");
INSERT INTO arq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","كي راحَت مَريَم للمْكان وين كان يَسوع، غير شافتو طاحَت عَند رَجليه وقالَتلو: \"سيدي، لو كان كُنت هْنا، خويَ ما كانش يْموت\". ");
INSERT INTO arq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","كي شافها يَسوع تَبكي واليْهود اللي جاو معاها يَبكيو، نْقاس بَزّاف فالروح وتْهَوَّل، ");
INSERT INTO arq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","وقال: \"وين حَطّيتوه؟\" قالولو: \"سيدي، أرواح وشوف\". ");
INSERT INTO arq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","بْكا يَسوع، ");
INSERT INTO arq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","وقالو اليْهود: \"شوفو شْحال كان يْحَبّو\". ");
INSERT INTO arq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","كايَن منهُم اللي قالو: \"هَدا اللي حَل عينين العْمى، ما كانش قادَر باش ما يْخَلّيهش يْموت؟\" ");
INSERT INTO arq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","زاد نْقاس يَسوع بَزّاف في روحو وجا للقْبَر، كان غار وكانَت مَحطوطة حَجرة فالدَخلة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","وقال يَسوع: \"نَحّيو الحَجرة\"، قالَتلو مَرتا خُت المِيَّت: \"سيدي، راهو يْريح، خاطَر عَندو رَبع أيّام\". ");
INSERT INTO arq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","قالَلها يَسوع: \"ماشي قُلتلَك باللي لو كان تامني تْشوفي مَجد الله؟\" ");
INSERT INTO arq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","نَحّاو الحَجرة ورْفَد يَسوع عينيه للفوق وقال: \"بابا، نَشُّكرَك كي سْمَعتلي، ");
INSERT INTO arq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","أنا راني عارَف باللي تَسمَعلي دايمًا، بَصَّح على جال الغاشي اللي راهو دايَر بِيَّ اللي هْدَرت، باش يامنو باللي أنتَ بْعَتتني\". ");
INSERT INTO arq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","وكي قال هَكدا، عَيَّط بالزور: \"لِعازَر، إيَّ لبَرّا\". ");
INSERT INTO arq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","خْرَج اللي كان مِيَّت وهُوَ مَربوط في يَدّيه ورَجليه بطْراف قْماش ووَجهو مْغَلَّف بمْحيرمة. قالَلهُم يَسوع: \"حَلّولو الرْباط وخَلّيوَه يْروح\". ");
INSERT INTO arq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","بَزّاف من اليْهود اللي جاو عَند مَريَم كي شافو واش دار داك الساع آمنو بيه. ");
INSERT INTO arq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","كايَن منهُم اللي راحو عَند الفَرّيسِيّين وقالولهُم واش دار يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","جَمّعو رِيّاس رْجال الدين والفَرّيسِيّين المَجلَس الديني وقالو: \"واش نْديرو خاطَر هاد الإنسان راهو يْدير مارات بَزّاف، ");
INSERT INTO arq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","لو كان نْخَلّيوَه هَكدا، كامَل يامنو بيه ويْجيو الرومان ويَفنيونا حْنا والمَعبَد والأُمّة\". ");
INSERT INTO arq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","قْيافا، واحَد منهُم، كان هَداك العام رايَس رْجال الدين، قالَلهُم: \"ما تَعَّرفو والو، ");
INSERT INTO arq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","وما راكُمش شايفين باللي خيرَلكُم لو كان يْموت إنسان واحَد على جال الشَعب وما تْنَهلَكش كامَل الأُمّة؟\" ");
INSERT INTO arq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","قْيافا ما قالش هاد الشي من عَندو، بَصَّح على حْساب اللي كان رايَس رْجال الدين داك العام، تْنَبَّأ باللي يَسوع كان رايَح يْموت على جال الأُمّة، ");
INSERT INTO arq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","وماشي بَرك على جال الأُمّة، بَصَّح باش يْلَم ويْوَحَّد وْلاد الله اللي كانو مْزَربعين. ");
INSERT INTO arq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","من هَداك النْهار، عَوّلو يُقُّتلو يَسوع، ");
INSERT INTO arq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ويَسوع ما وَلاّش يَمشي عيناني في وَسط اليْهود، وبَعَّد من تَمّة لواحَد الجيهة قْريبة للخْلا في مْدينة واسَمها أفرايَم، وقْعَد تَمّة مع التابعين. ");
INSERT INTO arq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","قَرَّب عيد الفَصح مْتاع اليْهود وبَزّاف طَلعو من الدْشور لأورشَليم قْبَل الفَصح باش يَتطَهّرو، ");
INSERT INTO arq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","وكانو يْحَوّسو على يَسوع ويْقولو لبَعضهُم بَعض فالمَعبَد: \"واش رايكُم، بلا شَك ما يْجيش فالعيد؟\" ");
INSERT INTO arq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","كانو رِيّاس رْجال الدين والفَرّيسِيّين آمرو باش اللي يَعرَف وين راهو يْبِيَّع باش يَحَّكموه. ");
INSERT INTO arq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","سَت أيّام قْبَل الفَصح، راح يَسوع لبيت عَنيا، وين كان لِعازَر اللي حْياه يَسوع من الموت، ");
INSERT INTO arq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ودارولو تَمّة عْشا. مَرتا كانَت تُقدَش ولِعازَر كان بين اللي كانو على الميدة مع يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","شَدَّت مَريَم نَص ريتلة مْتاع ريحة ناردين حُرّة وغالية بَزّاف، ودَهنَت رَجلين يَسوع ومَسحَتهُملو بشْعَرها حَتّى تْعَبّقَت الدار بالريحة. ");
INSERT INTO arq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","وقال يَهودا الإسخريوطي، واحَد من التابعين مْتاعو، اللي كان رايَح يْسَلّمو: ");
INSERT INTO arq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","\"وَعلاش هاد الريحة ما نْباعَتش بتَلت مْية دينار، وتْفَرّقو على الڤْلالين؟\" ");
INSERT INTO arq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","قال هاد الشي ماشي على جال اللي كان يْخَمَّم على الڤْلالين، بَصَّح كان سَرّاق وكان حاكَم صَندوق الدْراهَم ويَدّي واش فيه. ");
INSERT INTO arq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","قال يَسوع: \"خَلّيها، خَلاّت هاد الريحة ليوم دْفينتي، ");
INSERT INTO arq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","خاطَر الڤْلالين دايمًا عَندكُم، بَصَّح أنا ما نْكونش معاكُم دايمًا\". ");
INSERT INTO arq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","عْرَف غاشي كْبير من اليْهود باللي يَسوع كان تَمّة وجاو ماشي بَرك على جالو، بَصَّح تاني باش يْشوفو لِعازَر اللي حْياه يَسوع من الموت. ");
INSERT INTO arq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","عَوّلو رِيّاس رْجال الدين باش يَقُّتلو لِعازَر تاني، ");
INSERT INTO arq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","خاطَر بَزّاف من اليْهود كانو يْروحو ويامنو بيَسوع. ");
INSERT INTO arq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","غَدوة من داك، الغاشي الكْبير اللي جا للعيد سْمَع باللي يَسوع راهو جاي لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","هِمّالا، خْداو غْصان مْتاع النْخَل وخَرجو يْلاقيوَه وكانو يْعَيّطو: \"أوصَّنا! مْبارَك الجاي بآسَم الرَب، مْبارَك سَلطان إسرائيل\". ");
INSERT INTO arq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","لْقا يَسوع جَحش وقْعَد عليه كيما مَكتوب: ");
INSERT INTO arq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","\"ما تْخافيش يا بَنت صَهيون: هاوليك السَلطان مْتاعك جاي، قاعَد على جَحش وْليد حْمارة\". ");
INSERT INTO arq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","هاد الشي، التابعين مْتاعو ما فَهموهش مع الأوَّل، بَصَّح بَعد ما دْخَل يَسوع في مَجدو، تْفَكّرو باللي هاد الشي نَكتَب عليه، وباللي نْدارلو هاد الشي. ");
INSERT INTO arq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","شْهَدلو الغاشي اللي كان معاه كي عَيَّط للِعازَر يَخرُج من القْبَر وحْياه من الموت. ");
INSERT INTO arq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","على هَدا تاني اللي راح الغاشي يْلاقيه، خاطَر سَمعو هاد الشي، سَمعو باللي دار هاد المارة. ");
INSERT INTO arq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","هِمّالا قالو الفَرّيسِيّين بيناتهُم: \"شَفتو باللي ما عَندكُمش الفايدة، هاي الدَنيا راحَت تْتَبَّع فيه\". ");
INSERT INTO arq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","كانو شي يونانِيّين من اللي طَلعو لأورشَليم باش يَعَّبدو يامات العيد، ");
INSERT INTO arq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","هَدو راحو لفيلِبُّس مْتاع بيت صيدا فالجْليل، سَقساوَه وقالو: \"سيدي، حَبّينا نْشوفو يَسوع\"، ");
INSERT INTO arq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","جا فيلِبُّس وقال لأندراوَس، وجاو فيلِبُّس وأندراوَس وقالو ليَسوع. ");
INSERT INTO arq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","واجَب يَسوع وقال: \"جات الساعة اللي يْنال فيها بْن الإنسان المَجد، ");
INSERT INTO arq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","نْقولَلكُم الصَح الصَح، لو كان ما تْطيحش زَرّيعة القَمح فالأَرض وتْموت، تَبقا وَحَّدها، بَصَّح لو كان تْموت، تْجيب بَزّاف الغَلّة، ");
INSERT INTO arq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","اللي يْحَب حْياتو يَخسَرها، واللي يَكرَه حْياتو في هاد الدَنيا، يَحفَضها للحْياة الدايمة، ");
INSERT INTO arq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","اللي يَخدَمني، يْتَبَّعني، ووين نْكون تَمّة تاني يْكون الخَدّام مْتاعي. اللي يَخدَمني يْكَرّمو الآب. ");
INSERT INTO arq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","دُرك تْهَولَت نَفسي، وواش نْقول؟ بابا سَلَّكني من هاد الساعة؟ بَصَّح على هَدا اللي جيت، على هاد الساعة. ");
INSERT INTO arq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","بابا، مَجَّد آسمَك\". جا صوت من السْما: \"مَجَّدتو ونْزيد نْمَجّدو\". ");
INSERT INTO arq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","الغاشي اللي كان تَمّة وسْمَع قال: \"هَدا رَعد\"، وواحَدُخرين قالو: \"مْلاك هْدَر معاه\". ");
INSERT INTO arq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","جاوَب يَسوع وقال: \"ماشي على جالي اللي كان هاد الصوت، على جالكُم، ");
INSERT INTO arq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","دُرك وَقت المْحاسبة مْتاع هاد الدَنيا، دُرك يَتحاوَز سيد هاد الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","وأنا كي نَتَّرفَع من الأرض، نَجبَد الكُل لِيَّ.\" ");
INSERT INTO arq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","قال هَكدا يْمَعني على الموت اللي كان رايَح يْموتها. ");
INSERT INTO arq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","واجبو الغاشي: \"حْنا تْعَلَّمنا من الشَريعة باللي المَسيح يَبقا للدْوام، كيفاش تْقول أنتَ باللي بْن الانسان لازَم يَتَّرفَع؟ شْكون هَدا بْن الانسان؟\" ");
INSERT INTO arq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","قال يَسوع: \"مازالو النور معاكُم شْوِيّة، أمشيو مادام عَندكُم النور باش ما يْحَبَّسكُمش الضْلام، اللي يَمشي فالضَلمة ما يَعرَفش وين راهو رايَح، ");
INSERT INTO arq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ما دام عَندكُم النور، آمنو بالنور باش تْوَلّيو وْلاد النور\". قال يَسوع هَكدا وبَعَّد وتْخَبّا منهُم. ");
INSERT INTO arq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","كامَل المارات اللي دارهُم قُدّامهُم وما آمنوش بيه، ");
INSERT INTO arq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","باش يْتَم كْلام إشعِيا النَبي كي قال: \"يا رَب، شْكون آمَن بواش سْمَع منّا؟ وليمن بانَت قُدرة الرَب؟\" ");
INSERT INTO arq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","على هَدا اللي ما قَدروش يامنو، خاطَر إشعِيا زاد قال: ");
INSERT INTO arq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"عْما عينيهُم وقَسّا قْلوبهُم، باش ما يْشوفوش بعينيهُم وما يَفَّهموش بقْلوبهُم يْعودو يْتوبو ونَشفيهُم\". ");
INSERT INTO arq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","قال إشعِيا هَكدا خاطَر شاف المَجد مْتاعو وتْكَلَّم عليه. ");
INSERT INTO arq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","بَزّاف من الرِيّاس اللي آمنو بيه بَصَّح ما بَيّنو والُ على جال الفَرّيسِيّين، خاطَر خافو يَتحاوزو من المَجمَع، ");
INSERT INTO arq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","وحَبّو يْرَضّيو الناس كْتَر ما يْرَضّيو الله. ");
INSERT INTO arq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","عَيَّط يَسوع وقال: \"اللي يامن بِيَّ، ما يامَنش بِيَّ، يامَن باللي بْعَتني، ");
INSERT INTO arq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","واللي يْشوفني، يْشوف اللي بْعَتني، ");
INSERT INTO arq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","أنا جيت نور للدَنيا، باش كُل من يامَن بِيَّ، ما يَبقاش فالضَلمة، ");
INSERT INTO arq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","واللي يَسمَع كْلامي وما يَحَّفضوش، ماشي أنا نْحاسبو، خاطَر ما جيتش نْحاسَب الدَنيا، جيت نْسَلَّك الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","اللي ما يَقبَلنيش وما يَقبَلش كْلامي، عَندو اللي يْحاسبو، الكْلام اللي قُلتو، هُوَ اللي يْحاسبو فاليوم الآخَّر، ");
INSERT INTO arq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","خاطَر ما هْدَرتش من عَندي، بَصَّح اللي بْعَتني، الآب بالدات آمَرني بواش نْقول وعلى ماش نَهدَر، ");
INSERT INTO arq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","وراني عارَف باللي الآمَر مْتاعو حْياة دايمة، هِمّالا الشي اللي نْقولو، كيما قالهولي الآب نْقولو\". ");
INSERT INTO arq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","قْبَل عيد الفَصح، عْرَف يَسوع باللي وَصلَت ساعتو باش يْجوز من هاد الدَنيا للآب، وهُوَ اللي كان يْحَب ناسو اللي كانو فالدَنيا، زاد حَبّهُم حَتّى لتَم. ");
INSERT INTO arq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","مع العْشا، كي كان إبليس وَسوَس ليَهودا بَن سَمعان الإسخريوطي باش يْسَلَّم يَسوع، ");
INSERT INTO arq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ويَسوع اللي كان عارَف باللي الآب دارلو كُل شي في يَدّو، وباللي جا من عَند الله ويْروح لعَند الله، ");
INSERT INTO arq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ناض من الميدة، نَحّا حْوايجو الفوقانِيّين وخْدا فوطة تْحَزَّم بيها، ");
INSERT INTO arq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","وفَرَّغ الما في ماعون وبْدا يَغسَل في رَجلين التابعين ويَمسَحَّلهُم بالفوطة اللي تْحزَّم بيها. ");
INSERT INTO arq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","كي جا لسَمعان بُطرُس قاللو: \"رَبّي، أنتَ تَغسَلّي رَجلِيَّ؟\" ");
INSERT INTO arq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","واجَب يَسوع وقاللو: \"ماراكش عارَف واش راني نْدير دُرك، بَصَّح من بَعد رايَح تَفهَم\". ");
INSERT INTO arq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","قاللو بُطرُس: \"مُحال تَغسَلّي رَجلِيَّ\"، واجبو يَسوع: \"لوكان ما نَغسَلَّكش، ما عَندكش نْصيب معايَ\"، ");
INSERT INTO arq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","قاللو سَمعان بُطرُس: \"سيدي، ماشي بَرك رَجلِيَّ، حَتَّى يَدِّيَّ وراسي\"، ");
INSERT INTO arq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","قاللو يَسوع: \"اللي غْسَل، ما يَسحَق يْزيد يَغسَل غير رَجليه، خاطَر هُوَ كامَل طاهَر، وأنتومَ طاهرين بَصَّح ماشي كامَل\"، ");
INSERT INTO arq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","خاطَر كان عارَف اللي رايَح يْسَلّمو، على هَدا قال: \"ماشي كامَل طاهرين\". ");
INSERT INTO arq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","كي غْسَلّهُم رَجليهُم، عاوَد خْدا حْوايجو وقْعَد على الميدة وقالَلهُم: \"راكُم عارفين واش دَرتلكُم؟ ");
INSERT INTO arq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","أنتومَ تْعَيّطولي شيخ وسِيَّد وتَعَّملو مْليح خاطَر صَح أنا هَكداك، ");
INSERT INTO arq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","وَلاّ أنا اللي سِيَّد وشيخ غْسَلتَلكُم رَجليكُم، أنتومَ تاني لازَم تَغَّسلو رَجلين بَعضكُم بَعض، ");
INSERT INTO arq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","هَدا مْتَل اللي عْطيتَلكُم، باش كيما أنا دَرتَلكُم أنتومَ تاني تْديرو. ");
INSERT INTO arq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","نْقولَلكُم الصَح الصَح، العَبد ماشي خير من سيدو، وَلا المَبعوت خير من اللي بَعتو، ");
INSERT INTO arq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","وَلاّ عْرَفتو هاد الشي، يا سَعدكُم لو كان تَعَّملو بيه. ");
INSERT INTO arq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","مارانيش نَهدَر عليكُم كامَل، أنا نَعرَف اللي خَيَّرتهُم، بَصَّح باش يْتَم واش مَكتوب: \"اللي كْلا مَلحي، دار علِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","نْقولَلكُم من دُرك، قْبَل ما الشي يَصرا، باش كي يَصرا تامنو باللي أنا هُوَ، ");
INSERT INTO arq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","نْقولَلكُم الصَح الصَح، اللي يَقبَل اللي نَبَّعتو يَقبَلني أنا واللي قْبَلني يَقبَل اللي بْعَتني\". ");
INSERT INTO arq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","بَعد ما قال هَكدا، تْهَوَّل يَسوع فالروح وشْهَد وقال: \"نْقولَلكُم الصَح الصَح، واحَد فيكُم يْسَلَّمني\". ");
INSERT INTO arq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","بْداو التابعين هَدا يُخزَر في هَدا وهومَ ماشي عارفين عليمن كان يَهدَر. ");
INSERT INTO arq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","واحَد من التابعين، اللي يْحَبّو يَسوع، كان على الميدة مْتَكّي على صْدَر يَسوع، ");
INSERT INTO arq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","شَرّلو سَمعان بُطرُس باش يْسَقسيه عليمَن كان يَهدَر. ");
INSERT INTO arq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","دار التابَع على صْدَر يَسوع وسَقساه: \"سيدي، شْكون هُوَ؟\" ");
INSERT INTO arq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","واجَب يَسوع: \"اللي نْغَمَّس اللُقمة ونَعطيهالو\"، غَمَّس اللُقمة وعْطاها ليَهودا بَن سَمعان الإسخريوطي. ");
INSERT INTO arq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","غير كْلاها دْخَل فيه الشيطان وقاللو يَسوع: \"اللي مْعَوَّل تْديرو، ديرو بالخَف\". ");
INSERT INTO arq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","حَتّى واحَد من اللي كانو قاعدين على الميدة ما فْهَم وَعلاش قاللو يَسوع هَكدا، ");
INSERT INTO arq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","وكايَن اللي حَسبو باللي كي كان يَهودا شايَد صَندوق الدْراهَم، وَصّاه يَسوع باش يَشري واش يَسَّحقو للعيد وَلاّ كاش ما يَعطي للفُقَرا. ");
INSERT INTO arq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ويَهودا غير كْلا اللُقمة اللي عْطاهالو يَسوع، خْرَج وكان الليل. ");
INSERT INTO arq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","كي خْرَج قال يَسوع: \"دُرك، تْمَجَّد بْن الإنسان وتْمَجَّد الله فيه، ");
INSERT INTO arq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","وَلاّ الله تْمَجَّد فيه، الله تاني يْمَجّدو فيه، ويْمَجّدو بالخَف. ");
INSERT INTO arq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","يا الدْراري الصْغار، ما زَاللني شْوِيّة معاكُم أومبَعد تْحَوّسو علِيَّ وكيما قُلت لليْهود ما تَقَّدروش تْجيو وين نْروح، وأنتومَ تاني نْقولَلكُم دُرك، ");
INSERT INTO arq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","نَعطيلكُم فَرض جْديد، حَبّو بعضكُم بَعض، كيما حَبّيتكُم أنتومَ تاني حَبّو بَعضكُم بَعض، ");
INSERT INTO arq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","بهَدا كامَل يَعَّرفو باللي أنتومَ التابعين مْتاعي، وَلاّ عَندكُم المْحَبّة لبَعضكُم بَعض\". ");
INSERT INTO arq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","قاللو سَمعان بُطرُس: \"سيدي، وين راك رايَح؟\" واجبو يَسوع: \"وين راني رايَح، ما تَقدَرش تْتَبَّعني دُرك، بَصَّح من بَعد تْتَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","قاللو بُطرُس: \"وَعلاش ما نَقدَرش نْتَبّعَك دُرك؟ نْمَد حْياتي على جالَك\"، ");
INSERT INTO arq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","واجَب يَسوع: \"تْمَد حْياتَك على جالي؟ نْقولَك الصَح الصَح، ما يْعوعَشش السَردوك حَتّى تَنكُرني تَلت مَرّات\". ");
INSERT INTO arq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","\"ما لازَمش يَتهَوَّل قَلبكُم، آمنو بالله وآمنو بِيَّ تاني، ");
INSERT INTO arq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","في دار بابا كايَن بْيوت بَزّاف، لوكان ماشي هَكدا، كُنت نْقولَلكُم راني رايَح نْوَجَّدَّلكُم مْكان، ");
INSERT INTO arq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","وَلاّ نْروح، نْروح باش نْوَجَّدَّلكُم مْكان، نْعاوَد نْوَلّي ونَدّيكُم لعَندي، باش وين نْكون أنا تْكونو أنتومَ تاني، ");
INSERT INTO arq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","وتَعَّرفو وين نْروح وتَعَّرفو الطْريق\". ");
INSERT INTO arq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","قاللو توما: \"سيدي، ما راناش عارفين وين راك رايَح، كيفاش نَقَّدرو نَعَّرفو الطْريق؟\" ");
INSERT INTO arq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","قاللو يَسوع: \"أنا هُوَ الطْريق والحَق والحْياة، واحَد ما يْجي للآب غير بِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","وَلاّ عْرَفتوني تْكونو عْرَفتو بابا، ومن دُرك راكُم تَعَّرفوه وشَفتوه\". ");
INSERT INTO arq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","قاللو فيلِبُّس: \"سيدي، وَرّينا الآب وهَدا يَكفينا\". ");
INSERT INTO arq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","قاللو يَسوع: \"كامَل الوَقت اللي راني معاكُم وما زال ما عْرَفتنيش يا فيلِبُّس؟ اللي شافني شاف الآب، كيفاش أنتَ تْقول، وَرّينا الآب؟ ");
INSERT INTO arq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ما تامَنش باللي أنا فالآب والآب فِيَّ؟ الكْلام اللي نْقولهولكُم، ما نْقولوش من عَندي، الآب اللي ساكَن فِيَّ هُوَ اللي يْدير عْمالو، ");
INSERT INTO arq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","آمنوني باللي أنا فالآب والآب فِيَّ، وَلاّ ما كاش آمنوني على جال هاد الأَعمال، ");
INSERT INTO arq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","نْقولَلكُم الصَح الصَح، اللي يامَن بِيَّ، الأَعمال اللي نْديرهُم هُوَ تاني يْديرهُم ويْزيد يْدير كْتَر منهُم، خاطَر أنا راني رايَح للآب، ");
INSERT INTO arq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","واللي تَطَّلبوه بآسمي نْديرو، باش يَتمَجَّد الآب فالإبن، ");
INSERT INTO arq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","وَلاّ طْلَبتو حاجة بآسمي نْديرها. ");
INSERT INTO arq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","وَلاّ تْحَبّوني، تْطيعو فْرايضي، ");
INSERT INTO arq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","وأنا راني رايَح نَطلَب من الآب ويَعطيلكُم شْفيع واحَدآخُر باش يَبقا معاكُم للدْوام، ");
INSERT INTO arq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","روح الحَق اللي الدَنيا ما تَقدَرش تَقَّبلو خاطَر ما تْشوفو ما تَعَّرفو، أنتومَ تَعَّرفوه خاطَر يَبقا معاكُم وراهو فيكُم، ");
INSERT INTO arq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ما نْخَلّيكُمش يْتامى، نْجي ليكُم، ");
INSERT INTO arq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","مازال شْوِيّة والدَنيا ما تْزيدش تْشوفني بَصَّح أنتومَ تْشوفوني خاطَر أنا حَيّ وأنتومَ تَحياو، ");
INSERT INTO arq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","في هَداك النْهار، تَعَّرفو أنتومَ باللي أنا في بابا وأنتومَ فِيَّ وأنا فيكُم، ");
INSERT INTO arq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","اللي عَندو فْرايضي ويْطيعهُم، هَداك اللي يْحَبّني، اللي يْحَبّني يْحَبّو بابا وأنا نْحَبّو ونَعَّرفو بِيَّ\". ");
INSERT INTO arq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","قاللو يَهودا ماشي الإسخَريوطي: \"سيدي، كيفاش باش حْنا تْعَرَّفنا بيك والدَنيا لالا؟\" ");
INSERT INTO arq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","واجَب يَسوع وقاللو: \"وَلاّ كان واحَد يْحَبّني، يْطيع كْلامي ويْحَبّو بابا، نْروحو ليه ونَسُّكنو عَندو، ");
INSERT INTO arq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","واللي ما يْحَبّنيش، ما يْطيعش كْلامي والكْلام اللي تَسَّمعوه ماشي كْلامي، كْلام الآب اللي بْعَتني. ");
INSERT INTO arq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","قُلتَلكُم هاد الشي وأنا مازَلني معاكُم، ");
INSERT INTO arq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","الشْفيع، الروح القُدّوس اللي يَبَّعتو الآب بآسمي، هُوَ يْعَلَّمكُم كُل شي ويْفَكَّركُم بكامَل واش قُلتَلكُم، ");
INSERT INTO arq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","السْلام نْخَلّيلكُم، سْلامي أنا نَعطيلكُم، أنا ما نَعطيلكُمش كيما تَعطي الدَنيا، ما لازَمش يَتهَوَّل قَلبكُم وما لازَمش يْخاف، ");
INSERT INTO arq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","سْمَعتو باللي قُلتَلكُم، نْروح ونْجي ليكُم، وَلاّ جيتو تْحَبّوني تَفَّرحو اللي راني رايَح للآب، خاطَر الآب كْبير علِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","دُرك راني هْدَرتَلكُم قْبَل ما يَصرا الشي، باش كي يَصرا تامنو، ");
INSERT INTO arq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ما نْزيدش نَهدَر معاكُم بَزّاف، خاطَر راهو جاي أمير الدَنيا وما عَندو والو فِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","بَصَّح لازَم تَعرَف الدَنيا باللي نْحَب الآب وباللي نْدير كيما آمَرني الآب، نوضو، هَيّا نْروحو منّا\". ");
INSERT INTO arq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","\"أنا هُوَ الدالية الحَقّانِيّة وبابا هُوَ فَلاّح الدالية، ");
INSERT INTO arq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","كُل غْصَن فِيَّ ما يْجيبش الغَلّة يْنَحّيه، وكامَل اللي يْجيب الغَلّة يْنَقّيه باش يْجيب غَلّة كْتَر، ");
INSERT INTO arq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","أنتومَ راكُم نْقايا على جال الكْلام اللي قُلتهولكُم، ");
INSERT INTO arq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","أبقاو فِيَّ وأنا فيكُم. كيما الغْصَن ما يْجيبش الغَلّة من عَندو لوكان ما يَبقاش فالدالية، أنتومَ تاني لوكان ما تَبقاوش فِيَّ ما تْجيبوش الغَلّة، ");
INSERT INTO arq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","أنا الدالية وأنتومَ الأغصان، اللي يَبقا فِيَّ وأنا فيه يْجيب غَلّة فايضة خاطَر بلا بِيَّ ما تَقَّدرو تْديرو والو، ");
INSERT INTO arq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","لوكان الواحَد ما يَبقاش فِيَّ، يَتَّرما بَرّا كيما الغْصَن، ويَيبَس ويَنلَمّو الأغصان اليابسين ويَتَّرماو فالنار ويَنحَرقو. ");
INSERT INTO arq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","لوكان تَبقاو فِيَّ ويَبقا كْلامي فيكُم، واش تْحَبّو أطَّلبو ويْكون ليكُم. ");
INSERT INTO arq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","في هاد الشي اللي يَتمَجَّد بابا، باش تْجيبو غَلّة فايضة وتْوَلّيو لِيَّ تابعين، ");
INSERT INTO arq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","كيما حَبّني الآب أنا حَبّيتكُم، أبقاو في مْحَبّتي، ");
INSERT INTO arq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","وَلاّ طَعتو فْرايضي، تَبقاو في مْحَبّتي، كيما أنا طَعت فْرايَض بابا وبْقيت في مْحَبّتو. ");
INSERT INTO arq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","قُلتَلكُم هاد الشي باش يْكون فَرحي فيكُم وفَرحَتكُم تْكون كاملة. ");
INSERT INTO arq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","هَدا هُوَ الفَرض مْتاعي، حَبّو بَعضكُم بَعض كيما حَبّيتكُم أنا، ");
INSERT INTO arq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ماكاش مْحَبّة كْتَر من هَدي، اللي الواحَد يْمَد حْياتو على جال اللي يْحَبّهُم، ");
INSERT INTO arq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","تْكونو حْبابي لوكان تْديرو واش نامَركُم، ");
INSERT INTO arq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ما نْزيدش نْعَيَّطَّلكُم خَدّامين، خاطَر الخَدّام ما يَعرَفش واش يْدير سيدو، بَصَّح أنتومَ سَمّيتكُم حْبابي، خاطَر خَبَّرتكُم كامَل واش سْمَعت من عَند بابا، ");
INSERT INTO arq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ماشي أنتومَ اللي خَيَّرتوني، أنا اللي خَيَّرتكُم وكَلَّفتكُم باش تْروحو وتْجيبو غَلّة وتْدوم غَلَّتكُم، باش واش تَطَّلبو من الآب بآسمي، يَعطيهولكُم، ");
INSERT INTO arq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","هَدا واش نْوَصّيكُم، حَبّو بَعضكُم بَعض. ");
INSERT INTO arq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","وَلاّ كَرهَتكُم الدَنيا، أعَّرفو باللي كَرهَتني أنا الأوَّل، ");
INSERT INTO arq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","وَلاّ كُنتو من الدَنيا، الدَنيا تْحَب شِيّها، بَصَّح كي ما جيتوش من الدَنيا خاطَر أنا فْرَزتكُم من الدَنيا، على هَدا تَكرَهكُم الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","أتفَكّرو الكْلام اللي قُلتهولكُم، الخَدّام ماشي كْبير على سيدو. وَلاّ شَحنو علِيَّ، أنتومَ تاني يَشَّحنو عليكُم، وَلاّ طاعو كْلامي، يْطيعو كْلامكُم، ");
INSERT INTO arq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","بَصَّح يْديرولكُم هاد الشي كامَل على جال آسمي، خاطَر ما يَعَّرفوش اللي بْعَتني. ");
INSERT INTO arq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","لوكان ما جيتش وهْدَرت معاهُم، ما يْكونش عَندهُم دَنب، بَصَّح دُرك ماكاش واش يَعدَرهُم على دْنبهُم، ");
INSERT INTO arq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","اللي يَكرَهني يَكرَه بابا، ");
INSERT INTO arq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","لوكان ما دَرتش في وَسطهُم عْمال واحَد ما دْارهَم، لو كان ما عَندهُمش دْنب، بَصَّح دُرك شافو، وكَرهوني وكَرهو بابا، ");
INSERT INTO arq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","بَصَّح هاد الشي يْكون باش يْتَم الكْلام اللي مَكتوب في شَريعَتهُم \"كَرهوني بلا سَبّة\". ");
INSERT INTO arq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","كي يْجي الشْفيع اللي نَبعَتهولكُم من عَند الآب، روح الحَق اللي يْجي من عَند الآب، هُوَ يَشهَدلي، ");
INSERT INTO arq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","وأنتومَ شْهود خاطَر راكُم من الأوَّل معايَ. ");
INSERT INTO arq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","قُلتَلكُم هاد الشي باش ما تَعَّتروش، ");
INSERT INTO arq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ماشي بَرك يْحاوزوكُم من المْجامَع، تْجي الساعة وين اللي يَقتَلكُم يَحسَبها عْبادة لله، ");
INSERT INTO arq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ويْديرو هاد الشي خاطَر ما عَرفو لا الآب لا أنايَ، ");
INSERT INTO arq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","بَصَّح قُلتَلكُم هاد الشي باش كي يْجي وَقتهُم تَتفَكّرو باللي قُلتَلكُم هَكدا، ما قُلتَلكُمش هاد الشي من الأوَّل خاطَر كُنت معاكُم. ");
INSERT INTO arq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ودُرك راني رايَح لعَند اللي بْعَتني، وواحَد فيكُم ما يْسَقسيني وين راك رايَح؟ ");
INSERT INTO arq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","بَصَّح كي قُلتَلكُم هاد الشي تعَمَّر قَلبكُم بالحْزَن، ");
INSERT INTO arq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","بَصَّح نْقولَلكُم الصَح، خيرَلكُم لوكان نْروح، خاطَر لوكان ما نْروحش ما يْجيش الشْفيع لعَندكُم، بَصَّح لوكان نْروح نَبعَتهولكُم، ");
INSERT INTO arq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","وكي يْجي يْقَنَّع الدَنيا بالشي اللي يْخَص الخْطِيّة واللي يْخَص الصْلاح واللي يْخَص المْحاسبة، ");
INSERT INTO arq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","من جيهة فاللي يْخَص الخْطِيّة خاطَر ما يامنوش بِيَّ، ");
INSERT INTO arq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","من جيهة أخرى فاللي يْخَص الصْلاح خاطَر راني رايَح للآب وما تْزيدوش تْشوفوني، ");
INSERT INTO arq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","وفاللي يْخَص المْحاسبة خاطَر أمير هاد الدَنيا نَحكُم عليه. ");
INSERT INTO arq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ما زال عَندي حاجات بَزّاف نْقولهُمَّلكُم، بَصَّح دُرك ما تَقَّدروش تَرَّفدوهُم، ");
INSERT INTO arq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","كي يْجي هُوَ، روح الحَق، يْڤَوَّدكُم في كامَل الحَق، خاطَر ما يَهدَرش من عَندو، بَصَّح كامَل واش يَسمَع يَهدَر، ويْخَبَّركُم بواش رايَح يَصرا، ");
INSERT INTO arq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","هُوَ يْمَجَّدني خاطَر يَدّي منّي ويْخَبَّركُم، ");
INSERT INTO arq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","كامَل واش عَندو الآب مْتاعي، على هَدا قُلتَلكُم باللي يَدّي منّي ويْخَبَّركُم، ");
INSERT INTO arq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","مازال شْوِيّة وما تْزيدوش تْشوفوني، أومبَعد شْوِيّة تْشوفوني\". ");
INSERT INTO arq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","قالو شي تابعين مْتاعو لبَعضهُم بَعض: \"واش راهو يْقولَلنا، شْوِيّة وما تْزيدوش تْشوفوني، أومبَعد شْوِيّة وتْشوفوني؟\" و\"راني رايَح للآب؟\" ");
INSERT INTO arq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","قالو: \"واش مَعنَتها كي قال مازال شْوِيّة؟ ما راناش عارفين علَمّاش راهو يَهدَر\". ");
INSERT INTO arq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","عْرَف يَسوع باللي حَبّو يْسَقسيوَه وقالَلهُم: \"راكُم تْسَقسيو بَعضكُم بَعض واش قُلت: شْوِيّة وما تْزيدوش تْشوفوني، أومبَعد شْوِيّة وتْشوفوني؟\" ");
INSERT INTO arq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","نْقولَلكم الصَح الصَح، باللي تَبكيو وتْنَوّحو بَصَّح الدَنيا تَفرَح، رايحين تَحَّزنو بَصَّح حْزَنكُم يْوَلّي فَرح، ");
INSERT INTO arq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","المْرا كي تَولَد تَحزَن خاطَر وَصلَت ساعَتها باش تَولَد، بَصَّح كي تْجيب صْغير ما تْزيدش تَشفا على الشَدّة، على جال فَرحَتها باللي نْزاد بْنادَم فالدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","وأنتومَ دُرك راكُم حْزنانين، بَصَّح نْعاوَد نْشوفكُم ويَفرَح قَلبكُم، وفَرحَتكُم واحَد ما يْنَحّيهالكُم، ");
INSERT INTO arq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","وفي هَداك اليوم ما تْسَقسيوني على والو، نْقولَلكُم الصَح الصَح، الشي اللي تَطَّلبوه من الآب بآسمي يَعطيهولكُم، ");
INSERT INTO arq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","حَتّى لدُرك ما طْلَبتو حَتّى شي بآسمي، أطَّلبو تْنالو باش يَكمَل فَرحكُم. ");
INSERT INTO arq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","هاد الشي قُلتهولكُم بالمْتال، تْجي الساعة وين ما نْزيدش نَهدَر معاكُم بالمْتال ونْخَبَّركُم عيناني على الآب، ");
INSERT INTO arq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","في هَداك اليوم تَطَّلبو بآسمي وما نْقولَلكُمش باللي نْصَلّي للآب على جالكُم، ");
INSERT INTO arq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","خاطَر الآب هُوَ بالدات يْحَبّكُم، خاطَر حَبّيتوني وآمَنتو باللي خْرَجت من الله، ");
INSERT INTO arq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","خْرَجت من عَند الآب وجيت للدَنيا، نْعاوَد نْخَلّي الدَنيا ونْروح للآب\". ");
INSERT INTO arq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","قالو التابعين مْتاعو: \"هاك دُرك راك تَهدَر عيناني وما راك تْقول حَتّى مْتال، ");
INSERT INTO arq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","دُرك رانا عْرَفنا باللي تَعرَف كُل شي، وما تَسحَقش واحَد يْسَقسيك، على هَدا نامنو باللي خْرَجت من الله\". ");
INSERT INTO arq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","جاوَبهُم يَسوع: \"دُرك تامنو؟ ");
INSERT INTO arq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","تْجي الساعة وهاي جات وين تَتزَربعو كُل واحَد في دارو وتْخَلّيوني وَحدي، بَصَّح ما رانيش وَحدي خاطَر الآب راهو معايَ، ");
INSERT INTO arq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","قُلتَلكُم هاد الشي باش يْكونَلكُم السْلام فِيَّ، رايحين تْعانيو فالدَنيا بَصَّح أتسَجعو، راني غْلَبت الدَنيا\". ");
INSERT INTO arq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","قال يَسوع هاد الشي ورْفَد عينيه للسْما وقال: \"بابا، جات الساعة، مَجَّد الإبن باش يْمَجّدَك، ");
INSERT INTO arq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","على حْساب اللي عْطيتلو القُدرة على كُل دات باش يَعطي لكامَل اللي عْطيتهوملو الحْياة الدايمة، ");
INSERT INTO arq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","هَدي هِيَ الحْياة الدايمة، كي يَعَّرفوك أنتَ الإلَه الوَحيد الحَقّاني ويَسوع المَسيح اللي بْعَتتو. ");
INSERT INTO arq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","أنا مَجَّدتَك فالأرض كي كَمَّلت الخَدمة اللي عْطيتهالي باش نْديرها، ");
INSERT INTO arq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ودُرك، مَجَّدني أنتَ يا بابا قُدّامَك بالمَجد اللي كان عَندي قُدّامَك قْبَل ما تْكون الدَنيا. ");
INSERT INTO arq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","وَرّيت آسمَك لبْني آدَم اللي عْطيتهُملي من وَسط الدَنيا، كانو مْتاعك وعْطيتهُملي وطاعو كْلامَك، ");
INSERT INTO arq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","دُرك عَرفو باللي كامَل واش عْطيتني من عَندك، ");
INSERT INTO arq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","خاطَر عْطيتَلهُم الكْلام اللي عْطيتني وهومَ قَبلوه وعَرفو مْتاع الصَح باللي أنا خْرَجت منَّك وآمنو باللي أنتَ بْعَتّني، ");
INSERT INTO arq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","أنا نْصَلّي على جالهُم، ما نْصَلّيش على جال الدَنيا، نْصَلّي على جال اللي عْطيتهُملي خاطَر هومَ مْتاعك، ");
INSERT INTO arq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","كامَل شِيّي شِيَّك وشَيَّك شِيّي، وأنا تْمَجَّدت فيهُم، ");
INSERT INTO arq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","أنا ما نْزيدش نْكون فالدَنيا بَصَّح هومَ فالدَنيا، وأنا راني جاي لعَندك. يا بابا القُدّوس، أحفَضهُم في آسمَك اللي عْطيتهولي، باش يْكونو واحَد كيما حْنا واحَد، ");
INSERT INTO arq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","كي كُنت معاهُم حْفَضتهُم في آسمَك اللي عْطيتهولي، عَسّيت عليهُم وواحَد فيهُم ما ضاع من غير اللي حَب يْضيع وهَكدا يْتَم واش جا فالكْتوب، ");
INSERT INTO arq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","دُرك راني جاي لعَندك ونَهدَر هاد الشي فالدَنيا باش تْكون فَرحتي كاملة فيهُم، ");
INSERT INTO arq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","عْطيتلهُم كْلامَك والدَنيا كَرهَتهُم خاطَر هومَ ماشي من الدَنيا كيما أنا ماشي من الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","مارانيش نْصَلّي باش تْنَحّيهُم من الدَنيا، بَصَّح باش تَحفَضهُم من الدوني، ");
INSERT INTO arq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","هومَ ماشي من الدَنيا كيما أنا ماشي من الدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","قَدَّسهُم بالحَق، كْلامَك هُوَ الحَق، ");
INSERT INTO arq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","كيما بْعَتّني للدَنيا، أنا تاني بْعَتّهُم للدَنيا، ");
INSERT INTO arq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","وليهُم نَتقَدَّس باش يْكونو هومَ مَتقَدّسين بالحَق. ");
INSERT INTO arq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ماشي ليهُم بَرك اللي نْصَلّي، نْصَلّي تاني للي رايحين يامنو بِيَّ بكْلامهُم، ");
INSERT INTO arq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","باش يْكونو كامَل واحَد، كيما أنتَ يا بابا فِيَّ وأنا فيك، وهومَ تاني يْكونو فينا، باش تامَن الدَنيا باللي أنتَ بْعَتّني، ");
INSERT INTO arq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","وأنا المَجد اللي عْطيتهولي عْطيتهولهُم، باش يْكونو واحَد كيما حْنا واحَد، ");
INSERT INTO arq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","أنا فيهُم وأنتَ فِيَّ، باش يْكونو مَتوَحّدين مْليح، باش تَعرَف الدَنيا باللي أنتَ بْعَتّني وباللي تْحَبّهُم كيما تْحَبّني، ");
INSERT INTO arq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","بابا، هَدي هِيَ هِبتَك لِيَّ، مادابِيَّ وين نْكون يْكونو هَدو تاني معايَ، باش يْشوفو المَجد مْتاعي اللي عْطيتهولي خاطَر حَبّيتني قْبَل ما تَتأَسَّس الدَنيا. ");
INSERT INTO arq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","يا بابا الصالَح، الدَنيا ما عَرفاتَكش، بَصَّح أنا عْرَفتَك وهَدو عَرفو باللي أنتَ بْعَتّني، ");
INSERT INTO arq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","وأنا عَرَّفتَلهُم آسمَك ونْزيد نْعَرّفو باش تْكون المْحَبّة اللي حَبّيتني فيهُم وأنا فيهُم\". ");
INSERT INTO arq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","بَعد ما قال يَسوع هَكدا خْرَج مع التابعين مْتاعو، وراح للجيهة الأُخرى مْتاع واد قَدرون وين كانَت كاينة جْنينة دْخَلَّلها هُوَ والتابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","يَهودا اللي سَلّمو تاني كان يَعرَف هَداك المْكان، خاطَر يَسوع كان يَجتَمَع تَمّة بَزّاف مع التابعين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","أدّا يَهودا العَسكَر مع العَسّاسين مْتاع رِيّاس رْجال الدين والفَرّيسِيّين وجاو لتَمّة بالمْصابَح والمْشاعَل والسْلاح. ");
INSERT INTO arq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","يَسوع اللي كان عارَف واش رايَح يَصرالو، خْرَج وقالَلهُم: \"على من راكُم تْحَوّسو؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","واجبوه: \"يَسوع الناصري\"، قالَلهُم: \"أنا هُوَ\". يَهودا اللي سَلّمو تاني كان واقَف معاهُم، ");
INSERT INTO arq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","وكي قالَلهُم يَسوع \"أنا هُوَ\" رَجعو للور وطاحو على الأرض. ");
INSERT INTO arq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","زاد سَقساهُم: \"على من راكُم تْحَوّسو؟\" هومَ قالو: \"يَسوع الناصري\"، ");
INSERT INTO arq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","جاوَب يَسوع: \"قُلتَلكُم أنا هُوَ، هِمّالا وَلاّ راكُم تْحَوّسو علِيَّ، خَلّيو هَدو يْروحو\"، ");
INSERT INTO arq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","باش يْتَم الكْلام اللي قالو: \"ما ضَيَّعت حَتّى واحَد من اللي عْطيتهُملي\". ");
INSERT INTO arq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","كان عَند سَمعان بُطرُس سيف، جَبدو وضْرَب الخْديم مْتاع رايَس رْجال الدين وقَطَّعلو وَدنو اليْمنى، وكان آسَم الخْديم مَلخَس، ");
INSERT INTO arq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","قال يَسوع لبُطرُس: \"رَد السيف للغْمَد، ما نَشرَبش الكاس اللي عْطاهالي الآب؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","العَسكَر وقايَد الألف وخَدّامين اليْهود حَكمو يَسوع وكَتّفوه، ");
INSERT INTO arq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","وأدّاوَه قْبَل لعَند حَنّان، وكان حَنّان نْسيب قْيافا رايَس رْجال الدين في هَداك العام، ");
INSERT INTO arq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","وقْيافا هُوَ اللي كان نْصَح اليْهود باللي خير لو كان يْموت واحَد على جال كامَل الشَعب. ");
INSERT INTO arq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","وكان سَمعان بُطرُس وتابَع واحَدآخُر يْتَبَّعو في يَسوع، وكان هاد التابَع مَعروف عَند رايَس رْجال الدين، ودْخَل مع يَسوع لوَسط الدار مْتاع قْصَر رايَس رْجال الدين. ");
INSERT INTO arq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","بْقا بُطرُس بَرّا عَند الباب، هِمّالا خْرَج التابَع الآخُر اللي يَعَّرفو رايَس رْجال الدين وهْدَر مع العَسّاسة مْتاع الباب باش دْخّلَت بُطرُس، ");
INSERT INTO arq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","وقالَت العَسّاسة لبُطرُس: \"وأنتَ ماشي من التابعين مْتاع هاد الإنسان؟\" قال هُوَ: \"مارانيش منهُم\". ");
INSERT INTO arq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","الخَدّامين والعَسّاسين اللي كانو تَمّة شَعلو النار بالحْطَب باش يَدفاو خاطَر كان البَرد وكان معاهُم بُطرُس يَدفا. ");
INSERT INTO arq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","سَقسا رايَس رْجال الدين يَسوع على التابعين وعلى التَعليم مْتاعو، ");
INSERT INTO arq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","واجبو يَسوع: \"أنا هْدَرت للناس عيناني، وكُنت دايمًا نْدَرَّس عيناني فالمَجمَع وفالمَعبَد وين كامَل اليْهود يَتلَمّو، وما هْدَرت والو بالتْخَبِية، ");
INSERT INTO arq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","وَعلاش راك تْسَقسي فِيَّ؟ سَقسي اللي سَمعو واش قُلتَلهُم، هام هومَ عارفين واش قُلت\". ");
INSERT INTO arq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","كي قال هَكدا، واحَد من العَسّاسين عْطا صَقلة ليَسوع وقال: \"هَكدا تْجاوَب رايَس رْجال الدين؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","واجبو يَسوع: \"وَلاّ قُلت حاجة غْلاط، بَيَّن الغْلاط، بَصَّح وَلاّ هْدَرت مْليح، عْلاش تَضرَبني؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","بَعتو حَنّان مْكَتَّف لرايَس رْجال الدين قْيافا. ");
INSERT INTO arq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","كان سَمعان بُطرُس واقَف تَمّة يَدفا وقالولو: \"ماشي أنتَ تاني من التابعين مْتاعو؟\" نْكَر هُوَ وقال: \"مانيش منهُم\"، ");
INSERT INTO arq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","قال واحَد من الخَدّامين مْتاع رايَس رْجال الدين، وكان من العايلة مْتاع اللي قَطَّعلو بُطرُس وَدنو: \"ماشي شَفتَك معاه فالجْنان؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","وزاد نْكَر بُطرُس، وتَم تَم عوعَش السَردوك. ");
INSERT INTO arq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","أدّاو يَسوع من عَند قْيافا لقْصَر الحاكَم، وكان الصْباح وهومَ اليْهود ما حَبّوش يَدُّخلو للقْصَر باش ما يَتنَجّسوش وياكلو الفَصح. ");
INSERT INTO arq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","خْرَج ليهُم بيلاطَس بَرّا وقال: \"باش تَتَّهمو هاد الإنسان؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","واجبو وقالولو: \"لوكان ما كانش مَجرَم ما كُنّاش سَلَّمناهولَك\" ");
INSERT INTO arq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","قالَلهُم بيلاطَس: \"أدّيوَه أنتومَ وحاسبوه على حْساب الشَريعة مْتاعكُم\"، واجبوه: \"ما يْجوزَلناش نَحَّكمو على كاش واحَد بالموت\"، ");
INSERT INTO arq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","باش يْتَم الكْلام اللي قالو يَسوع باش يْبَيَّن بواش من الموت كان رايَح يْموت. ");
INSERT INTO arq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","عاوَد دْخَل بيلاطَس للقْصَر وعَيَّط ليَسوع وقاللو: \"أنتَ سَلطان اليْهود؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","واجَب يَسوع: \"راك تْقول هاد الشي من عَندك وَلاّ واحَدُخرين قالولَك علِيَّ هاد الشي؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","واجَب بيلاطَس: \"أنا يْهودي؟ الأُمّة مْتاعك ورِيّاس رْجال الدين سَلّموك لِيَّ. واش دَرت؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","واجَب يَسوع: \"المَملَكة مْتاعي ماشي من هاد الدَنيا، لوكان جات المَملَكة مْتاعي من هاد الدَنيا، لوكان الخَدّامين مْتاعي يْحاربو علِيَّ باش ما نَتسَلَّمش لليْهود، بَصَّح دُرك المَملَكة مْتاعي ماشي منّا.\" ");
INSERT INTO arq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","قاللو بيلاطَس: \"هِمّالا أنتَ سَلطان؟\" واجَب يَسوع: \"أنتَ قُلت باللي أنا سَلطان، أنا على هَدا اللي نْزَدت وعلى هدا اللي جيت للدَنيا، باش نَشهَد للحَق، اللي من الحَق يَسمَع صوتي\". ");
INSERT INTO arq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","قاللو بيلاطَس: \"واشَن هُوَ الحَق؟\" قال هَكدا وعاوَد خْرَج عَند اليْهود وقالَلهُم: \"ما لْقيت فيه حَتّى غَلطة، ");
INSERT INTO arq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","عَندكُم عادة، نَطلَقَّلكُم واحَد في عيد الفَصح، راكُم حابّين نَطلَقَّلكُم سَلطان اليْهود؟\" ");
INSERT INTO arq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","عَيّطو وهومَ يْقولو: \"ماشي هُوَ، أطلَقَّلنا باراباس\"، وباراباس كان سَرّاق. ");
INSERT INTO arq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","هِمّالا خْدا بيلاطَس يَسوع وآمَر باش يَجَّلدوه. ");
INSERT INTO arq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ضَفرو العَسكَر تاج بالشوك وحَطّوه على راسو ولَبّسولو لْباس حْمَر حامَق، ");
INSERT INTO arq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","وكانو يْجيو ليه ويْقولو: \"السْلام يا سَلطان اليْهود\"، ويْعطيولو فالصْقالي. ");
INSERT INTO arq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","زاد خْرَج بيلاطَس بَرّا وقالَلهُم: \"هاني نْخَرَّجهولكُم بَرّا باش تَعَّرفو باللي ما لْقيت فيه حَتّى غَلطة\". ");
INSERT INTO arq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","خْرَج يَسوع بَرّا وهُوَ رافَد تاج الشوك واللْباس الحْمَر وقالَلهُم بيلاطَس: \"هاو الراجَل\". ");
INSERT INTO arq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","كي شافوه رِيّاس رْجال الدين والعَسّاسين بْداو يْعَيّطو ويْقولو: \"أصَّلبو، أصَّلبو\". قالَلهُم بيلاطَس: \"أدّيوَه أنتومَ وأصَّلبوه خاطَر أنا ما لْقيت فيه حَتَّى غَلطة\". ");
INSERT INTO arq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","واجبوه اليْهود: \"حْنا عَندنا شَريعة، وعلى حْساب الشَريعة لازَم يْموت، خاطَر دار روحو بْن الله\"، ");
INSERT INTO arq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","كي سْمَع بيلاطَس هاد الكْلام زاد خاف كْتَر، ");
INSERT INTO arq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ودْخَل للقْصَر وقال ليَسوع: \"منين أنتَ؟\" بَصَّح يَسوع ما عْطالو حَتّى وْجاب. ");
INSERT INTO arq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","قاللو بيلاطَس: \"أنا ما تَهدَرش معايَ؟ ما راكش عارَف باللي عَندي القُدرة باش نَطَّلقَك وعَندي القُدرة باش نَصَّلبَك؟\" ");
INSERT INTO arq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","واجبو يَسوع: \"ما كانَت تْكون عَندك حَتّى قُدرة علِيَّ لوكان ما نَعطاتلَكش من الفوق، على هَدا اللي سَلَّمني ليك عليه دْنوب كْتَر\". ");
INSERT INTO arq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","من داك الوَقت، حَوَّس بيلاطَس باش يَطَّلقو، واليْهود عَيّطو وقالو: \"لوكان تَطلَق هَدا، ماراكش حْبيب قَيصَر، اللي يْدير روحو سَلطان يْكون عْدو لقَيصَر\". ");
INSERT INTO arq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","كي سْمَع بيلاطَس هاد الكْلام خَرَّج يَسوع لبَرّا وقْعَد على الكُرسي مْتاع القاضي فالمْكان اللي يَتسَمّا البْلاط وبالعَبرِيّة جَباتا. ");
INSERT INTO arq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","كان وَقت التَوجاد مْتاع الفَصح وكانَت جْوايَه الطْناش مْتاع النْهار وقال لليْهود: \"هاو السَلطان مْتاعكُم\"، ");
INSERT INTO arq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","هومَ عَيّطو: \"يْموت، يْموت، أصَّلبو\"، قالَلهُم بيلاطَس: \"نَصلَب السَلطان مْتاعكُم؟\" واجبو رِيّاس رْجال الدين: \"ما عَندنا حَتّى سَلطان من غير قَيصَر\"، ");
INSERT INTO arq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","سَلَّمهولهُم باش يَتَّصلَب. هِمّالا أدّاو يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","وخْرَج وهُوَ رافَد الصْليب للمْكان اللي يْسَمّيوَه الجُمجُمة واللي يْعَيّطولو بالعَبرِيّة الجُلجُتة. ");
INSERT INTO arq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","وتَمّة صَلبوه ومعاه زوج واحَدُخرين، واحَد من وواحَد من ويَسوع فالوَسط. ");
INSERT INTO arq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","كْتَب بيلاطَس لوحة وحَطّها على الصْليب وكان مَكتوب فيها: \"يَسوع الناصري سَلطان اليْهود\". ");
INSERT INTO arq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","بَزّاف من اليْهود اللي قْراو هاد اللوحة، خاطَر المْكان اللي نَصلَب فيه يَسوع كان قْريب من المْدينة وكانَت الكْتيبة بالعِبرِيّة واللاتينِيّة واليونانِيّة. ");
INSERT INTO arq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","قالو رِيّاس رْجال الدين لبيلاطَس: \"ما تَكتَبش سَلطان اليْهود، أكتَب هَدا قال أنا سَلطان اليْهود\"، ");
INSERT INTO arq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","واجَبهُم بيلاطَس: \"اللي كْتَبتو كْتَبتو\". ");
INSERT INTO arq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","العَسكَر كي صَلبو يَسوع خْداو حْوايجو وقَسموهُم على رَبعة، كُل واحَد أدّا رْبَع، وزادو الڤَندورة. والڤَندورة كانَت بلا خْياطة، قْماش واحَد على مَرّة. ");
INSERT INTO arq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","هِمّالا قالو لبَعضهُم بَعض: \"ما نْقَطّعوهاش، نْشوفو بالقُرعة ليمن تْكون\"، باش يْتَم واش تْقال فالكْتوب: \"تْقاسمو حْوايجي، ودارو القُرعة على ڤَندورتي\". وهَداك واش دارو العَسكَر. ");
INSERT INTO arq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","كانو قُدّام الصْليب يَمّاة يَسوع، وخُت يَمّاه ومَريَم مَرت كْلوبا ومَريَم المَجدَلِيّة، ");
INSERT INTO arq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","شاف يَسوع يَمّاه وقُدّامها التابَع اللي كان يْحَبّو، وقال ليَمّاه: \"يا مْرا، هاو وْليدَك\"، ");
INSERT INTO arq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","أومبَعد قال للتابَع: \"هاي يَمّاك\"، ومن هَديك الساعة، أدّاها التابَع لدارو. ");
INSERT INTO arq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","بَعد هَدا، يَسوع اللي كان عارَف باللي كُل شي تْحَقَّق قال باش يْتَم واش مَكتوب: \"راني عَطشان\"، ");
INSERT INTO arq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","كان تَمّة طاص مْعَمَّر بالخَل، عَمّرو سْفَنجة بالخَل وداروها على غْصَن مْتاع الزوف ودَنّاوهالو لفَمّو. ");
INSERT INTO arq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","كي خْدا يَسوع الخَل قال: \"راهو كْمَل\"، ومَيَّل راسو وسَلَّم الروح. ");
INSERT INTO arq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","على حْساب اللي كان التَوجاد للفَصح، وباش ما تَبقاش دات الموتى على الصْليب فالسَبت، خاطَر هَداك السَبت كان كْبير، طَلبو اليْهود من بيلاطَس باش يْكَسّرو رْكايَب المَصلوبين ويْنَحّيوهُم من الصْليب. ");
INSERT INTO arq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","راحو العَسكَر وكَسّرو رْكايَب الأوَّل، والتاني اللي نَصلَب معاه، ");
INSERT INTO arq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","كي وَصلو لعَند يَسوع لْقاوَه مِيَّت وما كَسّرولوش رْكايبو، ");
INSERT INTO arq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","بَصَّح واحَد من العَسكَر، تْقَبلو جَنبو بالرَمح مْتاعو، وتَم تَم خْرَج من جَنبو الدَم والما. ");
INSERT INTO arq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","اللي شاف شْهَد وشْهادتو صْحيحة، هُوَ راهو عارَف باللي راهو يْقول الصَح، باش أنتومَ تاني تامنو، ");
INSERT INTO arq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","خاطَر صْراو هاد الحاجات باش يْتَم واش مَكتوب: \"عْضَم ما يَتكَسَّر منّو\"، ");
INSERT INTO arq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ومَكتوب تاني: \"يْشوفو للّي تَقبوه\". ");
INSERT INTO arq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","بَعد هَدا، يوسَف الرامي اللي كان تابَع يَسوع بالتْخَبية على جال الخوف من اليْهود، طْلَب من بيلاطَس باش يَدّي دات يَسوع من الصْليب. خَلاّه بيلاطَس وراح نْحّاها. ");
INSERT INTO arq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","نيقوديموس تاني اللي كان جا ليه المَرّة الأولى فالليل، راح وجاب معاه واحَد التْلاتين كيلو مْتاع المَر والصْبَر مْخَلّطين، ");
INSERT INTO arq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","وأدّاو دات يَسوع ولَفّوه بالريحة فالكْفَن كيما كانَت عادة اليْهود للدْفينة. ");
INSERT INTO arq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","كان فالمْكان اللي نَصلَب فيه يَسوع جْنان وفالجْنان قْبَر جْديد ما نَدفَن فيه حَتّى واحَد، ");
INSERT INTO arq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","حَطّو يَسوع تَمّة على حْساب اللي كان قْريب على جال تَوجاد اليْهود للفَصح. ");
INSERT INTO arq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","اليوم الأوَّل مْتاع السْمانة، جات مَريَم المَجدَلِيّة للقْبَر الصْباح بَكري كي كان مازال الضْلام، وشافَت الحَجرة مْنَحية على القْبَر. ");
INSERT INTO arq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","جات تَجري عَند سَمعان بُطرُس والتابَع الآخُر اللي كان يَسوع يْحَبو وقالَتَّلهُم: \"أدّاو سيدنا من القْبَر وماراناش عارفين وين حَطّوه\"، ");
INSERT INTO arq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","خْرَج بُطرُس والتابَع الآخُر وجاو للقْبَر، ");
INSERT INTO arq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","كانو يَجريو بَصَّح التابَع الآخُر سْبَق بُطرُس ووْصَل الأولاني للقْبَر، ");
INSERT INTO arq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","طابَس وشاف الكْفَن مَحطوط بَصَّح ما دْخَلش. ");
INSERT INTO arq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","وْصَل سَمعان بُطرُس تاني ودْخَل للقْبَر وشاف الكْفَن مَحطوط تَمّة، ");
INSERT INTO arq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","والمْحيرمة اللي كانَت على راس يَسوع ماكانَتش مع الكْفَن، كانَت مَلفوفة ومَحطوطة على جيه، ");
INSERT INTO arq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","التابَع الآخُر اللي وْصَل الأولاني دْخَل تاني للقْبَر وشاف وآمَن، ");
INSERT INTO arq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","خاطَر كانو مازال ما فَهموش وين مَكتوب باللي يَسوع كان لازَم يْقوم مالموت، ");
INSERT INTO arq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","وعاودو راحو لدْيارهُم. ");
INSERT INTO arq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","مَريَم وَقفَت بَرّا عَند القْبَر تَبكي، وكي كانَت تَبكي طابسَت جيهة القْبَر، ");
INSERT INTO arq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","وشافَت زوج مَلايكة وهم لابسين الأبْيَض قاعدين وين كان يَسوع مَحطوط، واحَد عَند الراس والآخُر عَند الرَجلين. ");
INSERT INTO arq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","قالولها هومَ: \"يا مْرا، وَعلاش راكي تَبكي؟\" قالَتلهُم: \"سَرقو سيدي ومارانيش عارفة وين حَطّوه\"، ");
INSERT INTO arq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","كي قالَت هاد الشي، دارَت للور وشافَت يَسوع واقَف وما عَرفاتوش باللي هُوَ. ");
INSERT INTO arq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","قالَلها يَسوع: \"يا مْرا، وَعلاش راكي تَبكي؟ على من راكي تْحَوّسي؟\" حَسباتو الفَلاّح مْتاع الجْنان وقالَتلو: \"يا سِيَّد، وَلاّ كُنت أنتَ اللي أدّيتو، قوللي وين حَطّيتو وأنا نَدّيه.\" ");
INSERT INTO arq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","قالَلها يَسوع: \"مَريَم\"، دارَت هِيَ وقالَتلو بالعِبرِيّة: \"رَبّوني\"، ومَعنَتها شيخ، ");
INSERT INTO arq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","قالَلها يَسوع: \"ما تْمَسّينيش خاطَر مازال ما طْلَعتش للآب، بَصَّح روحي عَند خاوتي وقوليلهُم راني طالَع عَند بابا وباباكُم، عَند إلَهي وإلَهكُم\"، ");
INSERT INTO arq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","جات مَريَم المَجدلِيّة للتابعين وقالَتلهُم: \"شفَت الرَب\"، وخَبّرَتهُم بواش قالَلها. ");
INSERT INTO arq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","هَداك النْهار مع العْشِيّة، كان النْهار الأوَّل مْتاع السْمانة، كانو التابعين غالقين البيبان من الخوف من اليْهود، وجا يَسوع وْقَف فالوَسط وقالَلهُم: \"سْلام ليكُم\"، ");
INSERT INTO arq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","قال هاد الشي ووَرّالهُم يَدّيه وجَنبو وفَرحو التابعين بَزّاف كي شافو الرَب. ");
INSERT INTO arq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","زاد قالَلهُم: \"سْلام ليكُم، كيما بْعَتني الآب، أنا تاني نَبعَتكُم\"، ");
INSERT INTO arq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","وبَعد ما قال هاد الشي، نْسَف فيهُم وقالَلهُم: \"نالو الروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","اللي تَغَّفرولوهُم دْنوبهُم يَتغَفرولهُم، واللي تَحَّكمو عليهُم دْنوبهُم يَتحَكمو عليهُم\". ");
INSERT INTO arq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","وكان توما واحَد من الطْناش ويْعَيّطولو \"التومي\"، وماكانش معاهُم كي جا يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","قالولو التابعين الأُخرين: \"شَفنا الرَب\"، هُوَ قالَلهُم: \"لوكان ما نْشوفش في يَدّيه الشامة مْتاع المْسامَر ونْحَط فيها صَبعي، ونْحَط يَدّي في جَنبو ما نامَنش\". ");
INSERT INTO arq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","بَعد تَمن أيّام، زادو كانو التابعين فالدار وكان توما معاهُم. جا يَسوع وكانو البيبان مَغلوقين، وْقَف فالوَسط وقال: \"سْلام ليكُم\"، ");
INSERT INTO arq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","أومبَعد قال لتوما: \"جيب صَبعَك اللَهنا وشوف يَدِيَّ وجيب يَدَّك وحَطّها في جَنبي وما تْشَكش، آمَن\". ");
INSERT INTO arq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","واجَب توما وقاللو: \"رَبّي وإلَهي\"، ");
INSERT INTO arq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","قاللو يَسوع: \" كي شْفتني آمَنت؟ يا سَعد اللي ما شافوش وآمنو\". ");
INSERT INTO arq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","دار يَسوع قُدّام التابعين مْتاعو مارات واحَدُخرين بَزّاف ماراهُمش مَكتوبين في هاد الكْتاب، ");
INSERT INTO arq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","هَدو اللي راهُم مَكتوبين، نْكَتبو باش تامنو باللي يَسوع هُوَ المَسيح بْن الله، وباش كي تامنو تْنالو الحْياة بآسمو. ");
INSERT INTO arq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","أومبَعد زاد ضْهَر يَسوع للتابعين على شَط بْحَر طَبَرِيّة. ضْهَرَّلهُم هَكدا: ");
INSERT INTO arq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","كان سَمعان بُطرُس وتوما اللي يْعَيّطولو \"التومي\" ونَتَنائيل اللي آصلو من قانا مْتاع الجْليل ووْلاد زَبدي وزوج واحَدُخرين من التابعين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","وقالَلهُم سَمعان بُطرُس: \"راني رايَح نْصَيَّد\"، قالولو: \"حْنا تاني نْجيو معاك\". خَرجو وطَلعو فالفْلوكة وفي هَديك الليلة ما صَيّدو والو. ");
INSERT INTO arq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","كان طْلَع الفْجَر كي وْقَف يَسوع على الشَط بَصَّح التابعين ما عَرفوهش باللي هُوَ يَسوع. ");
INSERT INTO arq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","قالَلهُم يَسوع: \"يا دْراري، كاش ما عَندكم ماكلة؟\" جاوبوه: \"لالا\"، ");
INSERT INTO arq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","هُوَ قالَلهُم: \"أرميو الشَبكة من الجيهة اليْمنى مْتاع الفْلوكة تَلقاو\". أرماو الشَبكة وما قَدروش يَجَّبدوها من كَترة الحوت. ");
INSERT INTO arq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","قال التابَع اللي كان يَسوع يْحَبّو لبُطرُس: \"هَدا الرَب\". كي سْمَع سَمعان بُطرُس باللي هُوَ الرَب، لْبَس حْوايجو خاطَر كان عَريان ورْما روحو فالبْحَر. ");
INSERT INTO arq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","جاو التابعين الأخرين بالفْلوكة الصْغيرة يَجَّبدو الشَبكة مْتاع الحوت خاطَر ما كانوش بْعاد على الشَط، كانو على واحَد المية ميترة من الشَط، ");
INSERT INTO arq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","وكي هَبطو للشَط، لْقاو تَمّة نار مْتاع الجْمَر وفوقو حوت و خُبز. ");
INSERT INTO arq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","قالَلهُم يَسوع: \"جيبو شْوِيّة حوت من اللي صَيّدتوه دُرك\"، ");
INSERT INTO arq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","طْلَع سَمعان بُطرُس وجْبَد الشَبكة للشَط مْعَمّرة بمْية وتْلاتة وخَمسين حوتة كْبيرة، ووالو كان الحوت بَزّاف الشَبكة ما تْقَطّعَتش. ");
INSERT INTO arq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","قالَلهُم يَسوع: \"أرواحو تاكلو\". واحَد من التابعين ما قْدَر يْسَقسيه شْكون أنتَ وهومَ عارفين باللي هُوَ الرَب. ");
INSERT INTO arq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","جا يَسوع، أدّا الخُبز وعْطالهُم وزادلهُم الحوت. ");
INSERT INTO arq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","كانَت هَدي هِيَ المَرّة التالتة اللي يَضهَر فيها يَسوع للتابعين من اللي قام مالموت. ");
INSERT INTO arq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","كي كْلاو، قال يَسوع لسَمعان بُطرُس: \"سَمعان بَن يُوَنّا، تْحَبّني كْتَر من هَدو؟\" قاللو: \"إيه يا رَب، أنتَ تَعرَف باللي نْحَبَّك\"، قاللو يَسوع: \"أرعا الخَرفان مْتاعي\". ");
INSERT INTO arq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","زاد قاللو المَرّة التانية: \"سَمعان بَن يُوَنّا، تْحَبّني؟\" قاللو سَمعان: \"إيه يا رَب، أنتَ تَعرَف باللي نْحَبَّك\"، قاللو يَسوع: \"أرعا الكْباش مْتاعي\". ");
INSERT INTO arq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","قاللو المَرّة التالتة: \"سَمعان بَن يُوَنّا، تْحَبّني؟\" حْزَن بُطرُس كي قاللو يَسوع المَرّة التالتة \"وَلاّ تْحَبّني؟\" وقاللو: \"يا رَب، أنتَ تَعرَف كُل شي، وتَعرَف باللي نْحَبَّك\"، قاللو يَسوع: \"أرعا الكْباش مْتاعي، ");
INSERT INTO arq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","نْقولَك الصَح الصَح، كي كُنت صْغير، كُنت تْحَزَّم روحَك وتْروح وين تْحَب، بَصَّح كي تْوَلّي شيخ تْكَسَّل يَدّيك وواحَدآخُر يْحَزّمَك ويَدّيك وين ما تْحَبش\". ");
INSERT INTO arq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","قال هاد الشي باش يْبَيَّن بآما موت كان سَمعان رايَح يْمَجَّد الله، أومبَعد قاللو: \"تْبَّعني\". ");
INSERT INTO arq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","دار بُطرُس وشاف التابَع اللي كان يَسوع يْحَبّو يْتَبَّع فيهُم، وهُوَ اللي مال على صْدَر يَسوع وَقت العْشا وقال: \"سيدي، شْكون اللي رايَح يْسَلّمَك؟\" ");
INSERT INTO arq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","كي شافو بُطرُس قال ليَسوع: \"سيدي، وهَدا واشَن؟\" ");
INSERT INTO arq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","قاللو يَسوع: \"وَلاّ حَبّيتو يَبقا حَتّى نْوَلّي، واش عَندك؟ أنتَ تَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","خَرجَت هاد الكَلمة عَند الخاوة باللي هاد التابَع ما يْموتش. ما قاللوش يَسوع باللي ما يْموتش، قاللو: \"وَلاّ حَبّيتو يَبقا حَتّى نْوَلّي، واش عَندك؟\" ");
INSERT INTO arq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","هَدا هُوَ التابَع اللي يَشهَد بهاد الشي واللي كْتَب هاد الشي، ونَعَّرفو باللي شْهادتو صْحيحة. ");
INSERT INTO arq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","كايَن حاجات واحَدُخرين بَزّاف دارهُم يَسوع، لوكان نْكَتبو واحدة بواحدة، ما نْضَنش الدَنيا تَكفي باش تَرفَد الكْتوب اللي يَنكَتبو.");
INSERT INTO arq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","هْدَرت في كْتابي الأوَّل يا تاوفيلُس، على كُلّ واش بْدا يَسوع يْدير وواش يْعَلَّم تاني، ");
INSERT INTO arq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","حَتّى لليوم اللي نَرفَع فيه بَعدما وَصّا بالروح القُدّوس الرُسُل اللي خَيَّرهُم، ");
INSERT INTO arq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","واللي ضْهَرَّلهُم حَيّ بَعد عْدابو وعْطالهُم على هاد الشي مارات بَزّاف وبْقا يْضهَرَّلهُم مُدّة رَبعين يوم وهُوَ يْكَلَّم فيهُم على الحاجات مْتاع مَلَكوت الله. ");
INSERT INTO arq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ومَرّة، كانو مَلمومين وهُوَ مْعاهُم، ووَصّاهُم باش ما يْبَعّدوش على أورشَليم ويَستَنّاو وَعد الآب اللي قالَلهُم سْمَعتوه مَنّي، ");
INSERT INTO arq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","خاطَر يوحَنّا عَمَّد بالما، بَصَّح أنتومَ رايحين تْتعَمّدو بالروح القُدّوس، ماشي بَعد مُدّة طْويلة من هاد الوَقت. ");
INSERT INTO arq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","كي كانو كيف كيف، سَقساوَه الرُسُل وقالو: \"رَبّي، ماشي في هاد الوَقت اللي رايَح تْرَجَّع المُلك لإسرائيل؟\" ");
INSERT INTO arq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","قالَلهُم: \"خاطيكُم أنتومَ باش تَعَّرفو الوْقات والزْمانات اللي حَدَّدهُم الآب بالحُكمة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","بَصَّح رايحين تْنالو قُدرة كي يْجي عليكُم الروح القُدّوس، وتْكونو شْهودي في أورشَليم وفي كامَل اليَهوديّة والسامِرة وحَتّى لطَرف الدَنيا\". ");
INSERT INTO arq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","وكي قالَلهُم هاد الشي، نَرفَع وهومَ يْشوفو، وحَجباتو سْحابة على عينيهُم. ");
INSERT INTO arq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","وكي كانو يَخُّزرو فالسْما وهُوَ رايَح، وَقفولهُم زوج رْجال بلْباس بْيَض، ");
INSERT INTO arq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","وقالولهُم: \"يا ناس الجْليل، واش بيكُم حابسين تْشوفو للسْما؟ هَدا يَسوع اللي نَرفَع من بينكُم للسْما، رايَح يْوَلّي كيما شَفتوه يْروح للسْما\". ");
INSERT INTO arq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","داك الوَقت، رَجعو لأورشَليم من الجْبَل اللي يْسَمّيوَه \"جْبَل الزيتون\"، واللي جاي قْريب لأورشَليم وبيناتهُم قيس الطْريق المَسموح يَمشيوها فالسَبت. ");
INSERT INTO arq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","وكي وَصلو، طَلعو للبيت الفوقانِيّة وين مْوالفين يْكونو بُطرُس ويوحَنّا ويَعقوب وأَندَراوَس، فيلِبس وتوما، بَرتولَماوَس ومَتّى، يَعقوب بَن حَلفى وسَمعان الغَيّور ويَهودا بَن يَعقوب، ");
INSERT INTO arq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","وكانو كامَل تابتين بقَلب واحَد فالصْلاة ومْعاهُم نْسا ومَريَم يَمّاة يَسوع وخاوتو. ");
INSERT INTO arq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","وفي هَدوك اليامات، ناض بُطرُس في وَسط الخاوة وكان في هَداك المْكان غاشي مَتلايَم، واحَد المْية وعَشرين نَفس، وقال: ");
INSERT INTO arq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"يا الخاوة، كان لازَم يَتحَقَّق الشي اللي مَكتوب واللي سْبَق قالو الروح القُدّوس بلْسان داوَد على يَهودا اللي كان الڤَوّاد للّي حَكمو يَسوع، ");
INSERT INTO arq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","خاطَر كان واحَد منّا ونال النْصيب في هاد الخَدمة مْتاعنا، ");
INSERT INTO arq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","بَصَّح هُوَ شْرا حوش بدْراهَم الشَر، وطاح وتْكَسَّر من وَسط داتو وخَرجو كامَل مْصارنو. ");
INSERT INTO arq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","هاد الشي سَمعو بيه كامَل ناس أورشَليم، حَتّى تْسَمّا هَداك الحوش في لُغَتهُم \"حَقل دَمَخ\" يَعني \"حوش الدَم\". ");
INSERT INTO arq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","خاطَر مَكتوب في كْتاب المَزامير: \"تَخلا دارو وواحَد ما يَسكُن فيها، وواحَدآخُر يَدّي مْكانو\". ");
INSERT INTO arq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","لازَم هِمّالا، من الناس اللي كانو مْعانا كامَل الوَقت اللي عاش فيه يَسوع بيناتنا، ");
INSERT INTO arq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","من مَعموديّة يوحَنّا حَتّى لليوم اللي نَرفَع من بيناتنا، واحَد منهُم يْوَلّي شاهَد معانا على قْيامتو\". ");
INSERT INTO arq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","قَدّمو زوج: يوسَف اللي يَتسَمّا بَرسابا ويْكَنّيوَه يُستُس ومَتيّاس، ");
INSERT INTO arq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","وصَلاّو وقالو: \"أنتَ يا رَبّي اللي تَعرَف قْلوب الكُل، بَيَّن اللي خَيَّرتو في هاد الزوج، ");
INSERT INTO arq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","باش ياخُد النْصيب في هاد الخَدمة وهاد الرِسالة اللي خَلاّهُم يَهودا وراح لمَضَّربو\". ");
INSERT INTO arq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ودارو القُرعة وطاحَت في مَتيّاس، ودْخَل مَتيّاس مع الحْداش رْسول. ");
INSERT INTO arq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","كي جا يوم الخَمسين، كانو كامَل كيف كيف في مَدرَب واحَد، ");
INSERT INTO arq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","وتَم تَم، جا صوت من السْما كي الريح القْوي كي يَدرَب وعَمَّر كامَل الدار اللي كانو قاعدين فيها، ");
INSERT INTO arq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","وضَهرولهُم لْسانات كي اللي مْتاع النار، مْفَرّقين ونْحَطّو على كُل واحَد فيهُم، ");
INSERT INTO arq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","وتْعَمّرو كامَل بالروح القُدّوس وبْداو يَهَّدرو بلُغات واحَدُخرين على حْساب ما عْطالهُم الروح باش يَنطقو. ");
INSERT INTO arq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","وكانو ساكنين في أورشَليم يْهود تاقيين جايّين من كامَل الأُمّات اللي تَحت السْما، ");
INSERT INTO arq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","وكي كان الصوت، تْلَم الغاشي وحارو خاطَر كُل واحَد كان يَسمَعهُم يَهَّدرو بلُغتو. ");
INSERT INTO arq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","نْخَلعو وسْتَعجبو وقالو: \"هاد الناس اللي راهُم يَهَّدرو، ماشي كامَل جْليلِيّين؟ ");
INSERT INTO arq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","كيفاش رانا نَسَّمعو كُل واحَد فينا لُغتو اللي نْزاد بيها، ");
INSERT INTO arq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","فَرِتِيّين ومادِيّين وعيلامِيّين وناس مَسبوطَميا واليَهوديّة وكَبَدوكيّة وبُنتُس وآسيا، ");
INSERT INTO arq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","وفَريجيّة وبَمفيلِيّة ومَصَر وجْوايَه ليبيا اللي جاية كيما القيروان واللي يَسُّكنو في وَسط الرومانِيّين، ");
INSERT INTO arq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","من اليْهود واللي دَخلو في دين اليَهوديّة، كَرِتِيّين وعْرَب، رانا نَسَّمعو فيهُم يَهَّدرو بلُغاتنا على عْجايَب الله.\" ");
INSERT INTO arq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","كانو كامَل حايرين ومَستَغربين ويْقولو لبَعضهُم بَعض: \"واش حَب يْقول هاد الشي؟\" ");
INSERT INTO arq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","وكانو واحَدُخرين يَتمَسخرو ويْقولو: \"هادو راهُم سَكرانين\". ");
INSERT INTO arq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","وْقَف بُطرُس مع الحْداش رْسول، طَلَّع صوتو وقالَلهُم: \"يا رْجال اليْهود وأنتومَ كامَل اللي ساكنين في أورشَليم، أَعَّرفو هاد الشي وأَسَّمعو لكْلامي، ");
INSERT INTO arq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","هاد الناس ما راهُمش سَكرانين كيما راكُم حاسبين، خاطَر راهي غير التَسعة مْتاع الصْباح، ");
INSERT INTO arq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","بَصَّح هَدا هُوَ الشي اللي قالو النَبي يوئيل: ");
INSERT INTO arq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"يْقول الله: فاليامات الأَخرانِيّين، نْفَرَّغ من روحي على كُل بْنادَم، وْلادكُم وبْناتكُم يْتنَبّؤو، شُبّانكُم يْشوفو رُؤيات وشْيوخكُم يْنومو مْنامات، ");
INSERT INTO arq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","إيه، نْفَرَّغ على الخَدّامين والخَدّامات مْتاعي في هَدوك اليامات من الروح مْتاعي ويَتنَبّؤو، ");
INSERT INTO arq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ونْدير مُعجِزات الفوق فالسْما ومارات التَحت على الأرض، دَم ونار وفْوار مْتاع الدُخّان، ");
INSERT INTO arq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","الشَمس تْوَلّي ضَلمة والقْمَر يْوَلّي دَم قْبَل ما يْجي يوم الرَب، هَداك اليوم الكْبير والمَجيد، ");
INSERT INTO arq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ويْكون اللي كُل من يَدكُر آسَم الرَب يَسلَك\". ");
INSERT INTO arq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","يا الرْجال الإسرائيلِيّين، أَسَّمعو هاد الكْلام: يَسوع الناصري، هاد الراجَل اللي شْهَدلو الله قُدّامكُم بالمُعجِزات، والعْجايَب والمارات اللي دارهُم الله على يَدّو في وَسطكُم، كيما راكُم عارفين، ");
INSERT INTO arq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","هاد الراجل اللي سَلَّمتوه بْقَصد الله المْحَتًّم وبعَلمو السابَق، وصْلَبتوه وقْتَلتوه بيَدّين اللي هومَ ضَد الشَريعة، ");
INSERT INTO arq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","هُوَ اللي الله حْياه، وسَلّكو من وْجاع الموت خاطَر كان مُحال باش يَتَّحكَم برْباطها، ");
INSERT INTO arq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","خاطَر قال عليه داوَد: \"كُنت نْشوف الرَب قُدّامي في كُل وَقت، خاطَر هُوَ على يْميني باش ما نَتزَعزَعش، ");
INSERT INTO arq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","على هَدا فْرَح قَلبي وزْها لْساني وحَتّى داتي تْرِيَّح فالرْجا، ");
INSERT INTO arq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","خاطَر ما تْخَلّيش نَفسي في مَسكَن الموتى وما تْخَلّيش دات القُدّوس مْتاعك تَفسَد فالقْبَر، ");
INSERT INTO arq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","وَرّيتلي طُرقان الحْياة ورايَح تْعَمَّرني بالهْنا قُدّامَك\". ");
INSERT INTO arq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","يا الخاوة، أَسَّمحولي نْقولَلكُم عيناني باللي جَدنا داوَد مات ونَدفَن وقَبرو مازالو عَندنا حَتّى لليوم. ");
INSERT INTO arq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","على حْساب اللي كان نَبي، وعارَف باللي الله حْلَفلو باليْمين باللي يْقَعَّد واحَد من دَرِّيتو على عَرشو، ");
INSERT INTO arq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","سْبَق وهْدَر على قِيامة المَسيح، باللي ما تَتخَلاّش نَفسو في مَسكَن الموتى وما تَفسَدش داتو. ");
INSERT INTO arq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","يَسوع هَدا، حْياه الله ورانا كامَل شاهدين على هاد الشي، ");
INSERT INTO arq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","نَرفَع بيْمين الله ونال من عَند الآب الروح القُدّوس اللي كان مَوعود بيه، وفَرّغو كيما راكُم تْشوفو وتَسَّمعو. ");
INSERT INTO arq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","خاطَر داوَد ما طْلَعش للسْماوات، وهُوَ بداتو قال: \"قال الرَب لرَبّي، أَقعَد على يْميني، ");
INSERT INTO arq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","حَتّى نْحَط عَديانَك تَحت رَجليك.\" ");
INSERT INTO arq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","لازَم يَعَّرفو مْليح كامَل بْني إسرائيل ويَتيَقّنو باللي الله دار يَسوع هَدا اللي صْلَبتوه، رَب ومَسيح\". ");
INSERT INTO arq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","كي سَمعو هاد الكْلام، نْقاسو بَزّاف في قَلبهُم وقالو لبُطرُس ولكامَل الرُسُل: \"واش لازَم نْديرو يا الخاوة؟\" ");
INSERT INTO arq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","جاوَبهُم بُطرُس: \"توبو وكُل واحَد فيكُم يَتعَمَّد بآسَم يَسوع المَسيح لغُفران دْنوبكُم وتْنالو هِبة الروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","خاطَر الوَعد راهو ليكُم ولوْلادكُم ولكامَل اللي راهُم بْعاد، كامَل اللي يْعَيَّطَّلهُم الرَب إلَهنا\". ");
INSERT INTO arq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","وكان بُطرُس يَشهَدَّلهم ويْسَجَّعهُم بكْلام آخُر بَزّاف ويْقول: \"أسَّلكو من هاد الجيل المْعَوَّج.\" ");
INSERT INTO arq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","اللي قَبلو كْلامو، تْعَمّدو وداك اليوم زادو واحَد التَلت آلاف نَفس. ");
INSERT INTO arq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","كانو مْداومين على التَعليم مْتاع الرُسُل والشَرِكة وقَسمة الخُبز والصْلاة. ");
INSERT INTO arq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","طاح الخوف على كُل نَفس وكانو عْجايَب ومُعجِزات بَزّاف يَندارو على يَد الرُسُل، ");
INSERT INTO arq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","والمومنين كامَل كانو كيف كيف ومَتشاركين في كُل شي، ");
INSERT INTO arq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","وكانو يْبيعو مْلاكهُم ورْزاقهُم ويَتقاسمو السومة بيناتهُم كامَل على حْساب ما يَسحَق كُل واحَد، ");
INSERT INTO arq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","وكانو كُل يوم مْداومين براي واحَد فالمَعبَد، يَقَّسمو الخُبز فالدْيور وياكلو بالفَرحة والنيّة، ");
INSERT INTO arq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","يْسَبحو الله والشَعب كامَل راضي عليهُم. الرَب كان كُل يوم يْزيد للكَنيسة اللي كانو يَسَّلكو. ");
INSERT INTO arq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","بُطرُس ويوحَنّا طَلعو للمَعبَد في وَقت الصْلاة مْتاع التْلاتة مْتاع العْشيّة. ");
INSERT INTO arq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","وكانو ناس رافدين واحَد الراجَل كَعوان من اللي نْزاد، كانو يْجيبوه كُل يوم ويْحَطّوه قُدّام باب المَعبَد اللي يْسَمّيوها \"الباب الشابّة\" باش يَطلَب الصَدَقة من الناس اللي يَدُّخلو للمَعبَد، ");
INSERT INTO arq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","وكي شاف بُطرُس ويوحَنّا داخلين للمَعبَد، طْلَب مَنهُم الصَدَقة. ");
INSERT INTO arq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","خْزَر فيه بُطرُس ويوحَنّا مْليح وقال: \"شوف فينا\"، ");
INSERT INTO arq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","شاف فيهُم خاطَر كان يَستَنّا كاش ما يَعطيولو. ");
INSERT INTO arq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","قاللو بُطرُس: \"ما عَندي لا فَضّة لا دْهَب، بَصَّح اللي عَندي نَعطيهولَك، بِاسم يَسوع المَسيح الناصري، نوض وأمشي\". ");
INSERT INTO arq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","وشَدّو من يَدّو اليْمنى ونَوّضو وتَم تَم تْقَوّاو رَجليه والخْلاخَل مْتاعو، ");
INSERT INTO arq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ونَڤَّز ووْقَف وبْدا يَمشي ودْخَل معاهُم للمَعبَد وهُوَ يَمشي ويْنَڤَّز ويْسَبَّح فالله، ");
INSERT INTO arq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","وكامَل الشَعب شافوه يَمشي ويْسَبَّح فالله، ");
INSERT INTO arq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","وعَرفوه باللي هُوَ اللي كان يُقعَد يَطلَب عَند الباب الشابّة مْتاع المَعبَد وكانو مَدهوشين وحايرين فالشي اللي صْرا. ");
INSERT INTO arq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","وكي كان الكَعوان اللي بْرا لاصَق في بُطرُس ويوحَنّا، جْرا ليهُم الشَعب وهُوَ مَدهوش للسِطوان اللي يْقولولو سِطوان سُلَيمان. ");
INSERT INTO arq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","كي شاف بُطرُس هاد الشي، قال للشَعب: \"يا رْجال إسرائيل، وَعلاش راكُم مَستَعجبين في هاد الشي ووَعلاش راكُم تَخُّزرو فينا كي اللي بقُوَّتنا وبالتَقوى مْتاعنا اللي رَجَّعنا هاد الراجَل يَمشي؟ ");
INSERT INTO arq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","إلَه إبراهيم وإسحاق ويَعقوب، إلَه جْدودنا عَضَّم خْديمو يَسوع اللي سَلَّمتوه ونْكَرتوه قُدَّام بيلاطَس اللي كان حاب يَطَّلقو، ");
INSERT INTO arq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","بَصَّح أنتومَ نْكَرتو القُدّوس والصالَح وطْلَبتو باش يَعفيوَلكُم على راجَل قَتّال، ");
INSERT INTO arq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","وقْتَلتو رايَس الحْياة اللي حْياه الله مالموت وحْنا شاهدين. ");
INSERT INTO arq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","بالإيمان بآسمو، رَجَّع آسمو القُوّة لهَدا اللي راكُم تْشوفو فيه وتَعَّرفوه، الإيمان بيه هُوَ اللي رَد الصَحّة لهاد الراجَل قُدّامكُم كامَل. ");
INSERT INTO arq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ودُرك يا الخاوة، راني عارَف باللي دَرتو هاد الشي خاطَر كُنتو جاهلين كي أنتومَ كي رِيّاسكُم. ");
INSERT INTO arq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","الله حَقَّق الشي اللي سْبَق وخَبَّر بيه بفُم كامَل الأنبيا، باللي المَسيح رايَح يَتعَدَّب. ");
INSERT INTO arq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","هِمّالا توبو وأَرَّجعو باش يَتَّمحاو دْنوبكُم، ");
INSERT INTO arq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","باش يْجيو وْقات وين يْفَرَّج الرَب من عَندو، ويَبعَت يَسوع المَسيح اللي خَيَّرهولكُم من قْبَل، ");
INSERT INTO arq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","واللي لازَم يَبقا فالسْما حَتّى للوَقت اللي يَتسَڤَّم فيه كُل شي كيما قال الله من زْمان بفُم الأنبيا مْتاعو القَدّيسين. ");
INSERT INTO arq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","وقال موسى باللي الرَب إلَهكُم يْخَرَّج من بين خاوَتكُم نَبي كيما هُوَ، تَسَّمعولو في كُل شي يْقولهولكُم، ");
INSERT INTO arq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","وكُل واحَد ما يَسمَعش لهاد النَبي يَتَّمحا من الشَعب. ");
INSERT INTO arq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","وكامَل الأنبيا من صَموئيل واللي جاو موراه هَدرو وخَبّرو على هاد اليامات. ");
INSERT INTO arq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","أنتومَ وْلاد الأنبيا، والعَهد اللي عاهَد بيه الله جْدودنا وقال لإبراهيم: \"وفي دَريّتَك تَتبارَك كامَل عْشايَر الأرض\"، ");
INSERT INTO arq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ليكُم أنتومَ مع الأوَّل. الله حْيا وْليدو يَسوع وبَعتو باش يْبارَككُم كي يْرَد كُل واحَد من شَرو. ");
INSERT INTO arq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","وكي كانو يَهَّدرو مع الشَعب، جاو ليهُم رْجال الدين ورايَس المَعبَد والصَدّوقِيّين، ");
INSERT INTO arq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","وهومَ مْغَششين على جال اللي كانو يْعَلّمو فالشَعب ويْبَشّرو بقِيامة الموتى في يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","حَكموهُم وحَطّوهم فالحَبس حَتّى لغَدوة من داك خاطَر كانو مع العْشِيّة. ");
INSERT INTO arq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","كايَن بَزّاف من اللي كانو سَمعو الكَلمة، اللي آمنو ووَلاّو واحَد الخَمس آلاف راجَل. ");
INSERT INTO arq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","وغَدوة من داك، تْلَمّو رِيّاسهُم وشْيوخهُم والكُتّاب مْتاعهُم في أورشَليم، ");
INSERT INTO arq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","مع حَنّان رايَس رْجال الدين وقَيافا ويوحَنّا وسْكَندَر وكامَل اللي من سْلالة رِيّاس رْجال الدين. ");
INSERT INTO arq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","وبَعد ما حَطّو بُطرُس ويوحَنّا فالوَسط بْداو يْسَقسيو فيهُم: \"بواش من القُدرة وبآسَم شْكون دَرتو هاد الشي؟\" ");
INSERT INTO arq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","داك الوَقت، قالَلهُم بُطرُس وهُوَ مْعَمَّر بالروح القُدّوس: \"يا رِيّاس الشَعب ويا شْيوخ إسرائيل، ");
INSERT INTO arq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ولّا راكُم تَبَّحتو فينا على خير دَرناه لراجَل مْريض باش نْقولولكُم كيفاش بْرا؟ ");
INSERT INTO arq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","يْكون في مَعلومكُم أنتومَ كامَل وكامَل شَعب إسرائيل، باللي بآسَم يَسوع المَسيح الناصري اللي صْلَبتوه أنتومَ واللي حْياه الله من الموت، بيه وْقَف هاد الراجَل صْحيح. ");
INSERT INTO arq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","هُوَ الحَجرة اللي حْڤَرتوها أنتومَ البَنّايين واللي وَلاّت راس الزاوية. ");
INSERT INTO arq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ماكانش السْلاك بواحَدآخُر غيرو، خاطَر ماكانش آسَم آخُر تَحت السْما نَعطا بين الناس بيه نَسَّلكو.\" ");
INSERT INTO arq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","كي شافو التِقة مْتاعهُم، سْتَعجبو خاطَر كانو عارفين باللي بُطرُس ويوحَنّا ماشي قاريين وماشي مَتعلّمين، وعَقلوهُم باللي كانو مع يَسوع، ");
INSERT INTO arq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","وعلى حْساب اللي شافو الراجَل اللي بْرا واقَف معاهُم، ما لْقاوش واش يْقولو، ");
INSERT INTO arq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","وآمروهُم باش يُخَّرجو من المَجلَس الديني باش يَتشاورو عليهُم ما بيناتهُم، ");
INSERT INTO arq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","وقالو: \"واش نْديرو لهاد الناس؟ خاطَر شاع الخْبَر عند كامَل ناس أورشَليم باللي مُعجِزة مَعروفة نْدارَت على يَدّهُم وما نَقَّدروش نَنُّكرو، ");
INSERT INTO arq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","بَصَّح، باش هاد الشي ما يْزيدش يْشيع كْتَر عَند الشَعب، هَيّا نَحَّلفو فيهُم باش ما يْزيدو يَدُّكرو هاد الآسَم لحَتّى واحَد.\" ");
INSERT INTO arq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","وبَعد ما عَيّطولهُم، وَصَّاوهُم باش ما يْزيدوش يَهَّدرو وَلاّ يْعَلّمو بآسَم يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","بُطرُس ويوحَنّا جاوبو وقالولهُم: \"شوفو وَلاّ حَق قُدّام الله باش نَسَّمعولكُم أنتومَ ونْخَلّيو الله؟ ");
INSERT INTO arq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","خاطَر حْنا ما نَقَّدروش ما نَهَّدروش على الشي اللي شَفناه وسْمَعناه.\" ");
INSERT INTO arq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","وبَعد ما زادو حَلفو فيهُم، طَلقوهُم خاطَر ما لْقاوش سَبّة باش يْعاقبوهُم على جال الشَعب، خاطَر كانو كامَل يْعَضّمو فالله على اللي صْرا. ");
INSERT INTO arq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","والراجَل اللي صارَت فيه المُعجِزة وبْرا، كان عَندو كْتَر من رَبعين سْنة. ");
INSERT INTO arq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","كي خَرجو بُطرُس ويوحَنّا، راحو عَند صْحابهُم وحْكاوَلهُم كامَل واش قالولهُم رِيّاس رْجال الدين والشْيوخ. ");
INSERT INTO arq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","كي سَمعوهُم، رَفدو صوتهُم كامَل كيف كيف لله وقالو: \"سيدنا، أنتَ هُوَ اللي دَرت السْما والأرض والبْحَر وكُل ما فيهُم، ");
INSERT INTO arq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","وهَدا كْلامَك اللي قالو الروح القُدّوس بفَم جَدنا داوَد عَبدَك: \"وَعلاش تْهَوّلو الأُمّات ووَعلاش خَمّمو الشْعوب بالباطَل؟ ");
INSERT INTO arq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","سْلاطَن الأرض ناضو والرِيّاس تْحاماو على الرَب وعلى المَسيح مْتاعو، ");
INSERT INTO arq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","خاطَر صَح، هيرودَس وبيلاطَس البُنطيّ تْحاماو في هاد المْدينة مع الأُمّات، وشْعوب إسرائيل على خْديمَك القُدّوس يَسوع اللي دْهَنتو، ");
INSERT INTO arq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","باش يْديرو كامَل واش عَوَّلت بيَدَّك وقْصَدت من قْبَل باش يَصرا، ");
INSERT INTO arq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ودُرك، شوف يا رَب كيفاش راهُم يَحَّلفو فينا، وأعطي لعْبادَك باش يْهَّدرو بكْلامَك بتِقة كاملة، ");
INSERT INTO arq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ومَدّ يَدَّك باش يَبراو الناس ويَصراو مُعجِزات وعْجايَب بآسَم خْديمَك القُدّوس يَسوع\". ");
INSERT INTO arq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","وكي صَلاّو، تْزَعزَع المْكان اللي كانو مَتلَمّين فيه وتَعَمّرو كامَل بالروح القُدّوس وكانو يَهَّدرو بكْلام الله وهومَ واتقين. ");
INSERT INTO arq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","وكان عَند الجْماعة اللي آمَنت قَلب واحَد ونَفس واحدة، وحَتّى واحَد ما كان يْقول على رَزقو باللي مْتاعو وكانو مَتشاركين في كُل شي، ");
INSERT INTO arq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","وكانو الرُسُل يَشَّهدو لقِيامة الرَب يَسوع بقُدرة كْبيرة، وكانَت عليهُم كامَل نَعمة كْبيرة، ");
INSERT INTO arq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","وحَتّى واحَد فيهُم ما كان مَحتاج خاطَر كامَل اللي كانو عَندهُم تْراب وَلاّ دْيور، كانو يْبيعوهُم ويْجيبو سومَتهُم، ");
INSERT INTO arq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ويْحَطّوها عَند رَجلين الرُسُل، وكان هاد الشي يَتفَرَّق على حْساب ما يَسحَق كُل واحَد. ");
INSERT INTO arq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ويوسَف اللي سَمّاوَه الرُسُل بَرنابا ومَعنَتها \"وْليد العْزا\" لاوي من قُبرُص، ");
INSERT INTO arq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","كان عَندو تْراب، باعو وجاب الدْراهَم وحَطهُم عَند رَجلين الرُسُل. ");
INSERT INTO arq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","واحَد الراجَل واسمو حَنانِيّا مع مَرتو سَفّيرة باع مَلك، ");
INSERT INTO arq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ونَقَّص، وهُوَ مَتفاهَم مع مَرتو، من الدْراهَم اللي كْسَبهُم من البيع وجاب الباقي وحَطّو عَند رَجلين الرُسُل. ");
INSERT INTO arq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","قال بُطرُس: \"حَنانِيّا، عْلاش عَمَّر الشيطان قَلبَك باش تَخدَع الروح القُدّوس وتَدّي من سومة الحوش؟ ");
INSERT INTO arq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","قْبَل ما يَنباع، ماشي كانَ مْتاعك؟ وبَعد ما نْباع، سومتو ماشي كانَت عَندَك؟ كيفاش عَوَّلت في قَلبَك تْدير هاد الشي؟ ماشي على الناس اللي كْدَبت، كْدَبت على الله.\" ");
INSERT INTO arq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","غير سْمَع حَنانِيّا هاد الكْلام طاح ومات، وطاح خوف كْبير على كامَل اللي سَمعو بهاد الشي، ");
INSERT INTO arq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","وناضو مْصاغَر، كَفّنوه وأدّاوَه، دَفنوه. ");
INSERT INTO arq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","واحَد التَلت سْوايَع من بَعد، دَخلَت مَرتو وهِيَ ماشي عارفة واش صْرا. ");
INSERT INTO arq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","كَلَّمها بُطرُس: \"قوليلي، بَعتو الحوش بهاد السومة؟\" قالَت هِيَ: \"إيه، بهاد السومة\"، ");
INSERT INTO arq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","قالَلها بُطرُس: \"كيفاش تْفاهَمتو باش تْجَرّبو روح الرَب؟ هامليك، اللي دَفنو راجلَك عَند الباب، يَدّيوَك\". ");
INSERT INTO arq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","وتَم تَم طاحَت عَند رَجليه وماتَت. كي دَخلو المْصاغَر، لْقاوها مِيّتة، رَفدوها ودَفنوها قُدّام راجَلها. ");
INSERT INTO arq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","طاح خوف كْبير على كامَل الكَنيسة وعلى كامَل اللي سَمعو بهاد الشي. ");
INSERT INTO arq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","صْراو مُعجِزات وعْجايَب بَزّاف في وَسط الشَعب على يَد الرُسُل، وكانو كامَل كيف كيف عَند سِطوان سُلَيمان، ");
INSERT INTO arq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","وحَتّى واحَد من الأخرين ما كان يَقدَر يْخالَطهُم بَصَّح الشَعب كان يَستَعرَف بيهُم. ");
INSERT INTO arq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","اللي كانو يامنو بالرَب كانو يْزيدو كْتَر وكْتَر، غاشي من الرْجال والنْسا، ");
INSERT INTO arq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","حَتّى وَلاّو يَدّيو المَرضى للزْنَق ويْحَطّوهُم على فْراشات وبْناك باش كي يْجوز بُطرُس، يا لو كان الضَل مْتاعو يْغَطّي واحَد فيهُم. ");
INSERT INTO arq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","كان الغاشي يَتلَم من المْدايَن اللي في جْوايَه أورشَليم، يْجيبو المَرضى والناس المْعَدّبين بالأرواح الناجسين، وكانو كامَل يَبراو. ");
INSERT INTO arq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ناض رايَس رْجال الدين وكامَل اللي معاه من مَلّة الصَدّوقِيّين وهومَ مْعَمّرين بالغيرة، ");
INSERT INTO arq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","وحَكمو الرُسُل ورْماوهُم في حَبس الحُكومة. ");
INSERT INTO arq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","فالليل، حَل مْلاك من الرَب بيبان الحَبس وخَرَّجهُم وقال: ");
INSERT INTO arq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"روحو، أَوَّقفو وأَهَّدرو للشَعب فالمَعبَد كامَل كْلام هاد الحْياة.\" ");
INSERT INTO arq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","كي سَمعو هاد الشي، صَبّحو من الفْجَر فالمَعبَد وبْداو يْدَرّسو. وَصلو رايَس رْجال الدين واللي معاه وعَيّطو للمَجلَس الديني وشْيوخ بْني إسرائيل وبَعتو يْجيبو الرُسُل من الحَبس. ");
INSERT INTO arq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","كي وَصلو الخَدّامين ما لْقاوهُمش فالحَبس ورَجعو يْخَبّرو، ");
INSERT INTO arq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","وقالو باللي لْقاو الحَبس مَغلوق مْليح، العَسّاسين واقفين بَرّا قُدّام البيبان وكي حَلّينا ما لْقينا حَتّى واحَد الداخَل. ");
INSERT INTO arq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","كي رايَس عَسكَر المَعبَد ورِيّاس رْجال الدين سَمعو هاد الكْلام، حارو في هاد الشي واشن هُوَ. ");
INSERT INTO arq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","جا واحَد وخَبَّرهُم باللي الرْجال اللي حَطّيتوهُم فالحَبس، راهُم فالمَعبَد واقفين يْدَرّسو فالشَعب. ");
INSERT INTO arq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","داك الوَقت، راح رايَس العَسكَر مع الخَدّامين، وجابوهُم بلا ضَرب خاطَر خافو يْعود يَرجَمهُم الشَعب، ");
INSERT INTO arq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","وكي جابوهُم، وَقّفوهُم قُدّام المَجلَس الديني وسَقساهُم رايَس رْجال الدين ");
INSERT INTO arq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","وقال: \"ماشي آمَرناكُم ومْنعناكُم باش ما تْزيدوش تْدَرّسو بهاد الآسَم، وأنتومَ عَمَّرتو أورشَليم بالتَعليم مْتاعكُم وراكُم حابّين تْرَدّو موت هاد الراجَل على رَقبَتنا.\" ");
INSERT INTO arq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","جاوَب بُطرُس والرُسُل وقالو: \"لازَم نْطيعو الله ماشي الناس، ");
INSERT INTO arq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","إلَه جْدودنا حْيا يَسوع اللي قْتَلتوه بيَدّيكُم وعَلَّقتوه فالحْطَب، ");
INSERT INTO arq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","الله طَلّعو ليْمينو ودارو رايَس وسَلاّك باش يَعطي لإسرائيل التوبة وغُفران الدْنوب، ");
INSERT INTO arq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","وحْنا شْهودو في هاد الشي، حْنا والروح القُدّوس اللي عْطاه الله للي يْطيعوه.\" ");
INSERT INTO arq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","كي سَمعو هاد الكْلام، تْغَششو وحَبّو يَقُّتلوهُم، ");
INSERT INTO arq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","بَصَّح ناض فالمَجلَس الديني واحَد الفَرّيسي واسمو غَمالائيل، شيخ مْتاع الشَريعة ومَحبوب عَند كامَل الشَعب، وآمَر باش يَخُّرجو الرُسُل شْويّة، ");
INSERT INTO arq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","وقالَلهُم: \"يا رْجال إسرائيل، رَدّو بالكُم على روحكُم واش رايحين تْديرو لهاد الناس، ");
INSERT INTO arq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","خاطَر غير كيما، ناض توداس حاسَب روحو حاجة، وتَبّعوه واحَد الرَبع مْية راجَل. أتَّقتَل وكامَل اللي تَبّعوه تْزَربعو وما بْقا منهُم والو. ");
INSERT INTO arq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","من بَعد، زاد ناض يَهودا الجْليلي في وَقت الحْساب وجْبَد الشَعب لجيهتو. مات هُوَ تاني وتْزَربعو اللي تَبّعوه. ");
INSERT INTO arq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ودُرك نْقولَلكُم، بَعّدو على هاد الناس وخَلّيوهُم، وَلاّ جا هاد الآمَر وَلاّ هاد الخَدمة من عَند الناس، رايحة تَبطَل، ");
INSERT INTO arq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","بَصَّح وَلاّ جات من عَند الله، ما تَقَّدروش تْبَطّلوها، بَلاكو تَلقاو روحكُم تْحاربو فالله.\" تْقَنّعو بكْلامو، ");
INSERT INTO arq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","وعَيّطو للرُسُل، جَلدوهُم ومَنعوهُم يْزيدو يَهَّدرو بآسَم يَسوع وطَلقوهُم. ");
INSERT INTO arq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","راحو الرُسُل من المَجلَس الديني، وهومَ فَرحانين كي سْتاهلو يَنهانو على جال آسَم يَسوع، ");
INSERT INTO arq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","وبْقاو كُل يوم يْدَرّسو فالمَعبَد وفالدْيور ويْبَشّرو بيَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","في هَدوك اليامات، كانو التابعين يْزيدو، وشَتكاو اليونانِيّين من العِبرانيّين خاطَر كانو يَنساو الهَجّالات مْتاعهُم كي يْفَرّقو الصَدقة مْتاع كُل يوم. ");
INSERT INTO arq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","عَيّطو الرُسُل الطْناش لجْماعة التابعين وقالو: \"ما والمَتش نْخَلّيو حْنا كَلمة الله باش نْسَربيو فالمْيَد، ");
INSERT INTO arq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","يا الخاوة، شوفو بيناتكُم سَبع رْجال يَشَّهدولهُم الناس، يْكونو مْعَمّرين بالروح القُدّوس والعْقَل ونْكَلّفوهُم بهاد الخَدمة، ");
INSERT INTO arq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","وحْنا، نْداومو فالصْلاة وخَدمة الكَلمة.\" ");
INSERT INTO arq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","هاد الكْلام عْجَب الجْماعة كامَل وخَيّرو سْتِفانوس، راجَل مْعَمَّر بالإيمان والروح القُدّوس وفيلبُّس وبُروخورس ونيكانور وتيمون وبَرميناس ونيقولاوس الأنطاكي اللي وَلاّ يْهودي، ");
INSERT INTO arq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","وقَدّموهُم للرُسُل اللي بَعد ما صَلاّو، دارو يَدّيهُم عليهُم. ");
INSERT INTO arq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","كَلمة الله كانَت تْشيع والتابعين يَكَّترو بَزّاف في أورشَليم وغاشي كْبير من رْجال الدين نْطاعو للإيمان. ");
INSERT INTO arq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","سْتِفانوس كان مْعَمَّر بالنَعمة والقُوّة وكان يْدير عْجايَب ومُعجِزات كْبار ما بين الشَعب. ");
INSERT INTO arq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ناضو شي ناس من المَجمَع اللي يْقولولو مَجمَع الحْرار والقيروانِيّين والسْكَندرِيّين واللي من كيليكِيّا وآسيّا وبْداو يَتناقشو مع سْتِفانوس، ");
INSERT INTO arq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","وما قَدروش يْقاومو العْقَل والروح اللي كان يَهدَر بيه، ");
INSERT INTO arq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","هِمّالا، خَلّصو ناس باش يْقولو: \"سْمَعناه يْسَب موسى والله\". ");
INSERT INTO arq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","حَرّشو الشَعب والشْيوخ والكُتّاب وجاو حَكموه وأدّاوَه للمَجلَس الديني، ");
INSERT INTO arq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","وجابو شْهود زور يْقولو: \"هاد الراجَل ما يْحبَسش وهُوَ يْسَب فالمْكان المْقَدَّس وفالشَريعة، ");
INSERT INTO arq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","خاطَر سْمَعناه يْقول باللي يَسوع، هَداك الناصري، يْرَيَّب هاد المْكان ويْبَدَّل العْوايَد اللي خَلاّهُملنا موسى\". ");
INSERT INTO arq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","كامَل اللي كانو قاعدين فالمَجلَس الديني خَزرو فيه، وبانَلهُم وَجهو كي وَجه المْلاك. ");
INSERT INTO arq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","قال رايَس رْجال الدين: \"هاد الشي صَح؟\" ");
INSERT INTO arq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","قال سْتِفانوس: \"يا الخاوة ويا الوالدين، أَسَّمعو. إلَه المَجد ضْهَر لجَدّنا إبراهيم كي كان في مَسبوطميا، قْبَل ما يَسكُن في حاران، ");
INSERT INTO arq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","وقاللو: \"أَخرُج من بْلادَك ومن عَند مْواليك وروح للبْلاد اللي نْورّيهالَك\". ");
INSERT INTO arq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","خْرَج داك الوَقت إبراهيم من بْلاد الكَلدانِيّين وسْكَن في حاران، ومَن تَم، بَعد ما مات باباه، رَحّلو الله لهاد البْلاد اللي راكُم ساكنين فيها دُرك. ");
INSERT INTO arq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ما عْطالو فيها حَتّى مَلك، ما عْطالوش حَتّى وين تَعفَس رَجلو، بَصَّح وَعدو باش يْمَلَّكهالو ليه ولدَرّيتو من بَعدو والو ما سْعاش الدْراري. ");
INSERT INTO arq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","قاللو الله باللي دَريّتو رايحة تَسكُن فالغُربة، ويْوَلّيو عْبيد ويَنهانو مُدّة رَبع مْية سْنة، ");
INSERT INTO arq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","وقاللو باللي الأُمّة اللي رايحين يْكونو فيها عْبيد، أنا الله اللي نْحاسَبها، أومبَعد يَخُّرجو ويَعَّبدوني في هاد المْكان. ");
INSERT INTO arq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","وعْطالو عَهد الخْتانة وهَكدا جاب إسحاق وخَتّنو فاليوم التامَن، وإسحاق جاب يَعقوب وجاب يَعقوب الرِيّاس الجْدود في طْناش. ");
INSERT INTO arq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","غارو الجْدود الأوّلين من يوسَف وباعوه لمَصَر والله كان مْعاه، ");
INSERT INTO arq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","وسَلّكو من كامَل مْحاينو وعْطالو نَعمة وعْقَل قُدّام فَرعون سَلطان مَصَر اللي عْطالو الكَلافة على مَصَر وعلى دارو. ");
INSERT INTO arq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","وجات مَجاعة في بْلاد مَصَر كامَل، وفي كَنعان وكانَت المَحنة كْبيرة وجْدودنا ما لْقاوش واش ياكلو. ");
INSERT INTO arq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","كي سْمَع يَعقوب باللي كايَن الماكلة في مَصر، بْعَت جْدودنا المَرّة الأُولى، ");
INSERT INTO arq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","والمَرّة التانية، كْشَف يوسَف روحو لخاوتو وعْرَف فَرعون مْوالين يوسَف، ");
INSERT INTO arq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","وبْعَت يوسَف يْعَيَّط ليَعقوب باباه وكامَل مْواليه وكانو خَمسة وسَبعين نَفس. ");
INSERT INTO arq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","هْبَط يَعقوب لمَصر ومات هُوَ وجْدودنا. ");
INSERT INTO arq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","أَدّاوهُم لشَكيم وحَطّوهُم فالمَدفَن اللي شْراه إبراهيم بالدْراهَم من وْلاد حَمّور باباة شَكيم. ");
INSERT INTO arq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","كي قَرَّب الوَقت باش يَتحَقَّق الوَعد اللي حْلَف بيه الله لإبراهيم، كان الشَعب يَكتَر ويْزيد في مَصَر، ");
INSERT INTO arq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","حَتّى وين جا سَلطان واحَدآخُر في مَصَر ما كانش يَعرَف يوسَف. ");
INSERT INTO arq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","هاد السَلطان غْدَر بسْلالَتنا وهان جْدودنا وحَتَّم عليهُم يْسَلّمو وْلادهُم للموت. ");
INSERT INTO arq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","في هَداك الوَقت، زاد موسى وكان شْباب عَند الله. تْرَبّا مُدّة تَلت شْهور في دار باباه، ");
INSERT INTO arq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","وبَعد ما خَلاّوَه، أدّاتو بَنت فَرعون ورَبّاتو كي وْليدها. ");
INSERT INTO arq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","تْرَبّا موسى على كامَل العْقَل مْتاع المَصرِيّين وكان قادَر فالقْوال والفْعال. ");
INSERT INTO arq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","كي وَلاّ في عَمرو رَبعين سْنة، جا في بالو يْروح يْفاقَد خاوتو بْني إسرائيل. ");
INSERT INTO arq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","شاف واحَد مَضلوم، حاما عليه وجابلو حَقّو وقْتَل المَصري. ");
INSERT INTO arq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","حْسَب خاوتو يَفَّهمو باللي الله رايَح يْسَلَّكهُم على يَدّو بَصَّح هومَ ما فَهموش. ");
INSERT INTO arq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","فاليوم اللي من بَعد، زاد راح عَند خاوتو ولْقا زوج مَنهُم يَتضاربو، حَب يَصلَح بيناتهُم وقال: \"يا رْجال، ياخي أنتومَ خاوة، عْلاش تَضَّلمو بَعضكُم بَعض؟\" ");
INSERT INTO arq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","اللي كان يَضلَم في خوه دَفّعو وقاللو: \"شْكون حَطَّك رايَس وقاضي علينا؟ ");
INSERT INTO arq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","راك حاب تَقتَلني كيما قْتَلت المَصري البارَح؟\" ");
INSERT INTO arq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","على هاد الكَلمة، هْرَب موسى وتْغَرَّب في بْلاد مَديان وين سْعا زوج دْراري. ");
INSERT INTO arq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","رَبعين سْنة من بَعد، ضْهَرلو مْلاك الله فالصَحرا مْتاع جْبَل سينا في نار لاهبة فالعَلاّيَڤ. ");
INSERT INTO arq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","كي شاف موسى، سْتَعجَب فالشي اللي كان يْشوف فيه، وتْدَّنّا باش يْحَقَّق، وسْمَع صوت الرَب: ");
INSERT INTO arq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"أنا إلَه جْدودَك، إلَه إبراهيم وإسحاق ويَعقوب\". بْدا موسى يَتَّرعَد وما قْدَرش يُخزَر، ");
INSERT INTO arq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","قاللو الرَب: \"نَحّي سَبّاطَك من رَجليك خاطَر المْكان اللي راك واقَف عليه أرض مْقَدّسة، ");
INSERT INTO arq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","راني شَفت عْداب شَعبي اللي راهو في مَصر، وسْمَعت النْزاع مْتاعهُم، وهْبَطت باش نْسَلَّكهُم. هَيّا دُرك نَبَّعتَك لمَصر.\" ");
INSERT INTO arq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","هَدا موسى اللي نَكروه وقالو: \"شْكون حَطَّك رايَس وقاضي؟\" هُوَ اللي بَعتو الله رايَس وسَلاّك على يَد المْلاك اللي ضْهرلو فالعَلاّيَڤ، ");
INSERT INTO arq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","وهُوَ اللي خَرَّجهُم وهُوَ يْدير فالعْجايَب والمُعجِزات في بْلاد مَصر وفالبْحَر الحْمَر وفالصَحرا مُدّة رَبعين سْنة. ");
INSERT INTO arq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","هَدا موسى اللي قال لبْني إسرائيل: \"الله رايَح يْخَرَّج من خاوَتكُم نَبي كيما أنا\"، ");
INSERT INTO arq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","هُوَ اللي كان فالجْماعة فالصَحرا مع المْلاك اللي كان يْكَلّمو في جْبَل سينا ومع جْدودنا، هُوَ اللي جاب كْلام حَي باش يَعطيهولنا، ");
INSERT INTO arq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","هُوَ اللي ما حَبّوش جْدودنا يْطيعوه، وبَعّدوه ورَجعو بقْلوبهُم لمَصر، ");
INSERT INTO arq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","وقالو لهارون: \"أَخدَمَّلنا آلِهة تَمشي قُدّامنا، خاطَر موسى هَدا اللي خَرَّجنا من بْلاد مَصر ما راناش عارفين واش صْرالو.\" ");
INSERT INTO arq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","وخَدمو وَكريف في هَدوك اليامات ودَبحو للصَنَم وفَرحو بخَدمة يَدّيهُم. ");
INSERT INTO arq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","هِمّالا، دار عليهُم الله وسَلَّمهُم باش يَعَّبدو جيش السْما كيما راهو مَكتوب في كْتاب الأنبيا: \"يا بْني إسرائيل، وْهَبتولي ضْحِيّات ودْبايَح مُدّة رَبعين سْنة فالصَحرا؟ ");
INSERT INTO arq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","رْفَدتو الخيمة مْتاع مولوك، والنَجمة مْتاع إلَهكُم رَمفان، هَدوك الصْنام اللي خْدَمتوهُم باش تَعَّبدوهُم، وأنا نَنفيكُم بْعيد على بابَل\". ");
INSERT INTO arq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","خيمة الشْهادة كانَت عَند جْدودنا فالصَحرا كيما آمَر بيها اللي قال لموسى يَخدَمها على حْساب الصِفة اللي كان شافها، ");
INSERT INTO arq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","جْدودنا مَلكوها وأدّاوها مع يَشوع كي عَرّاو الأُمّات اللي خَرَّجهُم الله بَرّا قُدّام جْدودنا وبْقات حَتّى لزْمان داوَد، ");
INSERT INTO arq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","اللي لْقا نَعمة عَند الله وطْلَب يَلقا مَسكَن لإلَه يَعقوب. ");
INSERT INTO arq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","سُلَيمان هُوَ اللي بْنالو الدار، ");
INSERT INTO arq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","بَصَّح العالي ما يَسكُنش فاللي مَخدوم بيَدّين العْباد، كيما يْقول النَبي: ");
INSERT INTO arq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"السْما عَرشي والأرض وين نْحَط رَجلِيَّ. واش من دار تَبنيولي، يْقول الرَب، وواش من مَدرَب تْكون فيه راحتي؟ ");
INSERT INTO arq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ماشي يَدّي اللي دارَت هاد الشي كامَل؟\" ");
INSERT INTO arq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","يا خْشان الراس، يا اللي قْلوبكُم ووَدنيكُم ماشي مْخَتنين، أنتومَ دايمًا تْقاومو الروح القُدّوس. كيما كانو جْدودكُم، هَكدا أنتومَ. ");
INSERT INTO arq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","شْكون فالأنبيا اللي جْدودكُم ما حَڤروهش؟ قَتلو اللي خَبّرو من قْبَل بمْجي الصالَح اللي دُرك أنتومَ كُنتو الخَدّاعين والقَتّالين مْتاعو، ");
INSERT INTO arq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","أنتومَ اللي أدّيتو الشَريعة اللي وَصّلوهالكُم المَلايكة وما سْتَحفَضتوش عليها\". ");
INSERT INTO arq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","كي سَمعو هاد الشي، تْغَزّلو وبْداو يْغَزّو في سْنانهُم عليه. ");
INSERT INTO arq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","بَصَّح هُوَ خْزَر للسْما وهُوَ مْعَمَّر بالروح القُدّوس وشاف مَجد الله ويَسوع واقَف على يْمين الله، ");
INSERT INTO arq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","وقال: \"هاني نْشوف السْماوات مَحلولين وبْن الإنسان واقَف على يْمين الله\". ");
INSERT INTO arq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","كي قال هَكدا، عَيّطو بالزور وسَدّو وَدنيهُم وهَجمو عليه كامَل على مَرّة، ");
INSERT INTO arq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","وكَركروه لخارَج المْدينة ورَجموه، والشْهود حَطّو حْوايَجهُم عَند رَجلين واحَد الراجَل واسمو شاوَل، ");
INSERT INTO arq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","وكانو يَرَّجمو في سْتِفانوس، اللي كان يَدكُر ويْقول: \"رَبّي يَسوع، أدّي روحي\"، ");
INSERT INTO arq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ورْكَع على رْكايبو وعَيَّط بالزور: \"رَبّي، ما تَحسَبش عليهُم هاد السِيّة\". وغير قال هَكدا، رْقَد. ");
INSERT INTO arq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","شاوَل كان راضي على قْتيلتو. وصْرات في هَداك الزْمان حُڤرة كْبيرة ضَدّ كَنيسة أورشَليم وكامَل من غير الرُسُل تْزَربعو فاليَهوديّة والسامرة. ");
INSERT INTO arq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ناس تاقيين دَفنو سْتِفانوس ودارو عليه مْنوحة كْبيرة، ");
INSERT INTO arq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","بَصَّح شاوَل، كان يَحڤَر فالكَنيسة وكان يَدخُل للدْيور، يْكَركَر منهُم رْجال ونْسا ويَرميهُم فالحَبس. ");
INSERT INTO arq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","وهَدوك اللي تْزَربعو، كانو يْروحو من مَضرَب لمَضرَب وهومَ يْبَشّرو بالكَلمة، ");
INSERT INTO arq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","وهْبَط فيلِبُّس لواحَد المْدينة فالسامرة وكان يْبَشَّر بالمَسيح، ");
INSERT INTO arq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","كان الغاشي كامَل يَسمَع مْليح لكْلام فيلِبُّس كي عَرفو وشافو المُعجِزات اللي كان يْديرهُم، ");
INSERT INTO arq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","خاطَر بَزّاف من اللي كانو مَسكونين، خَرجو مَنهُم الأرواح الناجسين وهومَ يْعَيّطو بالزور، وبَزّاف من اللي كانو مَشلولين وكَعوانيين بْراو، ");
INSERT INTO arq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","وكانَت فَرحة كْبيرة في هَديك المْدينة. ");
INSERT INTO arq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","وكان من قْبَل فالمْدينة واحَد الراجَل واسمو سيمون، هاد الراجَل كان يْدير السْحَر، ويْدَهَّش شَعب السامرة وحاسَب روحو حاجة كْبيرة، ");
INSERT INTO arq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","وكانو كامَل من الصْغير للكْبير يَسَّمعولو مْليح ويْقولو: \"هَدا هُوَ قُدرة الله الكْبيرة\". ");
INSERT INTO arq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","وكانو يْتَبّعوه خاطَر زْمان طْويل وهومَ داهشين فالسْحَر مْتاعو، ");
INSERT INTO arq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","بَصَّح كي آمنو فيلِبُّس اللي كان يْبَشَّرهُم بالحاجات مْتاع مَلَكوت الله وبآسَم يَسوع المَسيح، تْعَمّدو رْجال ونْسا. ");
INSERT INTO arq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","سيمون بالدات آمَن تاني وبَعد ما تْعَمَّد، بْقا لاصَق في فيلِبُّس وكي شاف المارات والمُعجِزات اللي كانو يَندارو، دْهَش. ");
INSERT INTO arq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","كي سَمعو الرُسُل في أورشَليم باللي ناس السامرة قَبلو الكَلمة، بَعتولهُم بُطرُس ويوحَنّا. ");
INSERT INTO arq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","وكي وَصلو لعَندهُم، صَلاّولهُم باش يْنالو الروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","خاطَر كان مازال ما جا على حَتّى واحَد فيهُم، وكانو مَتعَمّدين غير بآسَم رَبّي يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","داك الوَقت، دارو بُطرُس ويوحَنّا يَدّيهُم عليهُم ونالو الروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","وكي شاف سيمون باللي الروح القُدّوس يْنَعطا للناس كي يْديرو عليهُم الرُسُل يَدّيهُم جابَلهُم الدْراهَم، ");
INSERT INTO arq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","وقال: \"أعطيوني أنا تاني هاد القُدرة باش اللي نْدير عليه يَدّيَّ يْنال الروح القُدّوس\". ");
INSERT INTO arq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","هِمّالا قاللو بُطرُس: \"أفنا بانتَ بدْراهمَك كي حْسَبت باللي هِبة الله تْنَكسَب بالدْراهَم، ");
INSERT INTO arq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ما عَندَك لا نْصيب لا قَسمة في هاد الآمَر خاطَر قَلبَك ما راهوش قْبالة قُدّام الله، ");
INSERT INTO arq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","توب على شَرَّك وأَطلَب من الله بَلاك يَغفَرلَك تَخمام قَلبَك، ");
INSERT INTO arq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","راني نْشوف فيك في مْرارة المُر ورْباط الضَلم\". ");
INSERT INTO arq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","جاوَب سيمون وقال: \"أَطَّلبو أنتومَ رَبّي على جالي باش ما يَصرالي حَتّى شي من اللي قُلتوه\". ");
INSERT INTO arq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","وبَعد ما شَهدو وهَدرو بكَلمة رَبّي، رَجعو لأورشَليم وبَشّرو في دْشور بَزّاف مْتاع السامرِيّين. ");
INSERT INTO arq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","كَلَّم مْلاك رَبّي فيلِبُّس وقال: \"نوض وروح من جيهة الجَنوب، على الطْريق الخالية اللي تْهَبَّط من أورشَليم لغَزّة\". ");
INSERT INTO arq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ناض فيلِبُّس وراح. واحَد الحَبَشي، مَخصي، وَزير عَند كَنداكة سَلطانة الحَبَشة ومْوَكَّل على كامَل مْوالها، كان جا لأورشَليم يْحَج، ");
INSERT INTO arq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","وكان راجَع لبْلادو، قاعَد على الكاليش. كان يَقرا في كْتاب النَبي إشعِيا. ");
INSERT INTO arq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","قال الروح لفيلِبُّس: \"أَدَّنا وأَلحَق هاد الكاليش\"، ");
INSERT INTO arq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","جْرا فيلِبُّس وسْمَع المَخصي يَقرا في كْتاب النَبي إشعِيا وقاللو: \"راك تَفهَم واش راك تَقرا؟\" ");
INSERT INTO arq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","جاوبو الحَبَشي: \"كيفاش نَفهَم بْلا ما كاش واحَد يْوَرّيلي؟\" وعْرَض فيلِبُّس باش يَطلَع يُقعَد معاه. ");
INSERT INTO arq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","الحَبَشي كان يَقرا وين مَكتوب: \"كَركروه كي الشاة للدْبيحة، وكي الكَبش الساكَت قُدّام اللي يَجَزّوه، هَكداك ما حَلش فَمّو، ");
INSERT INTO arq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","فالدَل مْتاعو، نْحّاولو حَقّو. شْكون يْخَبَّر على دَرِيّتو، خاطَر تْنَحّات حْياتو من الأرض\". ");
INSERT INTO arq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","جاوَب المَخصي فيلِبُّس وقال: \"نْسَقسيك، على من راهو النَبي يْقول هاد الشي؟ على روحو ولاّ على واحَدآخُر؟\" ");
INSERT INTO arq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","نْطَق فيلِبّس وبْدا من هاد الكْتاب وبَشّرو بيَسوع. ");
INSERT INTO arq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","وكي كانو يَمشيو فالطْريق، لْقاو الما. وقال المَخصي: \"هاو الما، واش يَمنَع باش نَتعَمَّد؟\" ");
INSERT INTO arq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","وآمَر باش يْحَبّسو الكاليش وهَبطو في زوج للما وعَمَّدو فيلِبُّس. ");
INSERT INTO arq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","وكي طَلعو من الما، روح الرَب خْطَف فيلِبُّس، وغاب على عينين المَخصي اللي راح في طْريقو فَرحان. ");
INSERT INTO arq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","وفيلِبّس، لْقا روحو في أَشدود وجاز يْبَشَّر في كامَل المْدايَن حَتّى وْصَل لقَيصَرِيّة. ");
INSERT INTO arq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","شاوَل كان مازالو شاحَن يَحلَف في تابعين الرَب ويَقتَل فيهُم، وراح لرايَس رْجال الدين، ");
INSERT INTO arq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","يَطلَب مَنّو بْراوات للمْجامَع مْتاع دِمَشق، باش لو كان يَلقا ناس، رْجال وَلاّ نْسا يْتَبّعو هاد الطْريق، يْجيبهُم مَكَتّفين لأورْشَليم. ");
INSERT INTO arq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","وفي طْريقو، كي وْصَل قْريب لدِمَشق، تَم تَم بْرَق سايَر دايَر عليه ضو من السْما. ");
INSERT INTO arq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","طاح على الارض وسْمَع صوت يْقوللو: \"شاوَل، شاوَل، عْلاش راك شاحَن علِيَّ؟\" ");
INSERT INTO arq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","قال شاوَل: \"شْكون أنتَ يا رَب؟\" قال الرَب: \"أنا يَسوع اللي راك شاحَن عليه، ");
INSERT INTO arq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","بَصَّح نوض وأَدخُل للمْدينة ويَتقاللَك واش لازَم تْدير\". ");
INSERT INTO arq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","الرْجال اللي كانو مْسافرين مع شاوَل وَقفو مْبَكّمين من الدَهشة، كانو يَسَّمعو الصوت بَصَّح ما شافو حَتّى واحَد. ");
INSERT INTO arq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ناض شاوَل من الأرض، ووالو عينيه كانو مَحلولين، ما كان يْشوف والو وڤَوّدوه من يَدّو ودَخّلوه لدِمَشق. ");
INSERT INTO arq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","بْقا تَلت أيّام بلا ما يْشوف وما ياكُل ما يَشرُب. ");
INSERT INTO arq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","كان في دِمَشق تابَع واسمو حَنانِيّا، قاللو الرَب في واحَد الرُؤيا: \"حَنانِيّا\"، قال حَنانِيّا: \"هاني يا رَب\"، ");
INSERT INTO arq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","قاللو الرَب: \"نوض وروح للزَنقة اللي يْقولولها المْسَلّسة، وسَقسي في دار يَهودا على واحَد واسمو شاوَل من طَرسوس، خاطَر راهو يْصَلّي، ");
INSERT INTO arq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","وشاف في رُؤيا راجَل واسمو حَنانِيّا يَدخُل ويْدير عليه يَدّيه باش يْوَلّي يْشوف\". ");
INSERT INTO arq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","جاوَب حَنانِيّا: \"رَبّي، سْمَعت من ناس بَزّاف على هاد الراجَل شْحال دار الشَر فالقَدّيسين مْتاعك في أورشَليم، ");
INSERT INTO arq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","وهْنا، عَندو التَسريح من عَند رِيّاس رْجال الدين باش يْكَتَّف كامَل اللي يَدُّكرو آسمَك\". ");
INSERT INTO arq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","قاللو الرَب: \"روح، خاطَر هاد الراجَل خَيَّرتو لِيَّ باش يْوَصَّل آسمي عَند أُمّات وسْلاطَن وعَند بْني إسرائيل، ");
INSERT INTO arq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ورايَح نْوَرّيلو شْحال لازَم يَتعَدَّب على جال آسمي\". ");
INSERT INTO arq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","راح حَنانِيّا ودْخَل للدار اللي كان فيها شاوَل ودار يَدّيه عليه وقال: \"خويَ شاوَل، الرَب يَسوع اللي ضْهَرلَك فالطْريق اللي جيت منها بْعَتني باش تْوَلّي تْشوف وتَتعَمَّر بالروح القُدّوس\". ");
INSERT INTO arq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","تَم تَم، طاحو من عينيه كي القْشور ووَلاّ يْشوف وناض وتْعَمَّد، ");
INSERT INTO arq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","وبَعد ما كْلا تْقَوّا. بْقا شاوَل يامات مع التابعين مْتاع دِمَشق، ");
INSERT INTO arq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","وبالخَف بْدا يْبَشَّر فالمْجامَع بيَسوع باللي هَداك هُوَ بْن الله. ");
INSERT INTO arq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","كامَل اللي سَمعوه حارو وكانو يْقولو: \"ماشي هَدا هُوَ اللي كان شاحَن على اللي كانو يَدَّكرو هاد الآسَم في أورشَليم، وجا اللَهنا باش يَدّيهُم مَكَتّفين لرِيّاس رْجال الدين؟\" ");
INSERT INTO arq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","وشاوَل كان يَقوا كْتَر وكْتَر وكان يْغالَب اليْهود اللي كانو ساكنين في دِمَشق وهُوَ يْتَبَّت باللي يَسوع هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","جازو يامات بَزّاف، أومبَعد عَوّلو اليْهود باش يَقَّتلوه. ");
INSERT INTO arq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","عْرَف شاوَل بالشَرية مْتاعهُم وكانو يْعَسّو حَتّى البيبان نْهار وليل باش يَقَّتلوه. ");
INSERT INTO arq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","وفي واحَد الليلة، أدّاوَه التابعين وهَبّطوه على الصور وهومَ مْدَلّيينو في قُفّة. ");
INSERT INTO arq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","كي جا لأورشَليم، حَبّ يْكون مع التابعين بَصَّح كامَل خافوه وما آمنوش باللي وَلاّ تابَع. ");
INSERT INTO arq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","هِمّالا، حَكمو بَرنابا، أدّاه للرُسُل وحْكالهُم كيفاش شاف شاوَل الرَب فالطْريق وهْدَر معاه الرَب وكيفاش بَشَّر عيناني في دِمَشق بآسَم يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","وَلاّ شاوَل يَدخُل ويُخرَج مع الرُسُل في أورشَليم ويَهدَر عيناني بآسَم الرَب. ");
INSERT INTO arq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","وكي كان يَهدَر ويَتناقَش مع اليونانِيّين، حَبّو يَقُّتلوه. ");
INSERT INTO arq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","كي سَمعو بيه الخاوة، هَبّطوه لقَيصَرِيّة وبَعتوه لطَرسوس. ");
INSERT INTO arq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","كانَت الكَنيسة هانية في كامَل اليَهوديّة والجْليل والسامرة، وكانَت تَتبَت وتَمشي فالخوف مْتاع الرَب وتَكتَر بمْعاونة الروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","كان بُطرُس يْروح لكُل مْكان، وهْبَط عَند القَدّيسين اللي كانو ساكنين في لَدّة، ");
INSERT INTO arq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","لْقا تَمّة راجَل واسمو إينياس، راقَد فالفْراش من تَمن سْنين وهُوَ مَشلول. ");
INSERT INTO arq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","قاللو بُطرُس: \"إينياس، يَسوع المَسيح يَشفيك، نوض وسَڤَّم فْراشَك\"، تَم تَم ناض. ");
INSERT INTO arq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","شافوه كامَل اللي كانو يَسُّكنو في لَدّة وفي شارون وتابو للرَب. ");
INSERT INTO arq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","وكان في يافا، من بين التابعين، مْرا واسَمها طابيتا ومَعنَتها غْزالة. كان عَندها بَزّاف فْعال الخير وتْصَدَّق بَزّاف. ");
INSERT INTO arq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","مَرضَت في هَدوك اليامات وماتَت، غَسّلوها وحَطّوها فالبيت الفوقانِيّة. ");
INSERT INTO arq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","لَدّة كانَت قْريبة من يافا، وكي سَمعو التابعين باللي بُطرُس كان تَمّة، بَعتولو زوج رْجال يَطَّلبو مَنّو يْجي ليهُم بْلا ما يْطَوَّل. ");
INSERT INTO arq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ناض بُطرُس وراح معاهُم، وكي وْصَل، أدّاوَه للبيت الفوقانِيّة ووَقفو عَندو كامَل الهَجّالات يَبكيو ويْوَرّيولو القْمايَج والبْرانَس اللي كانَت تْديرهُم غْزالة كي كانَت معاهُم. ");
INSERT INTO arq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","خَرَّجهُم بُطرُس كامَل، ورْكَع وصَلاّ، أومبَعد دار للدات وقال: \"طابيتا، نوضي\". حَلَّت طابيتا عينيها وكي شافَت بُطرُس تْقَعّدَت. ");
INSERT INTO arq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","عْطالها بُطرُس يَدّو ونَوَّضها، أومبَعد عَيَّط للقَدّيسين والهَجّالات وقَدَّمهالهُم حَيّة. ");
INSERT INTO arq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","نَعرَف هاد الشي في كامَل يافا وبَزّاف آمنو بالرَب، ");
INSERT INTO arq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","وقْعَد بُطرُس يامات بَزّاف في يافا عَند واحَد الدَبّاغ واسمو سَمعان. ");
INSERT INTO arq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","كان في قَيصَرِيّة واحَد الراجَل واسمو كَرنيليوس، قايَد المْية فالكَتيبة اللي يْسَمّيوها الطاليانِيّة. ");
INSERT INTO arq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","كان تَقي ويْخاف الله هُوَ وكامَل ناس دارو، يْصَدَّق بَزّاف للشَعب ويْصَلّي لله في كُل وَقت. ");
INSERT INTO arq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","جْوايَه التْلاتة مْتاع العْشيّة، شاف مْليح في واحَد الرُؤيا مْلاك مَن عَند الله داخَل عَندو يْقوللو: \"كَرنيليوس\"، ");
INSERT INTO arq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","خْزَر فيه كَرنيليوس وهُوَ خايَف وقال: \"واش يا رَبّي؟\" قاللو المْلاك: \"صَلَواتَك وصَدَقاتَك طَلعو تَفكيرة قُدّام الله، ");
INSERT INTO arq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ودُرك، أَبعَت رْجال ليافا وجيب واحَد واسمو سَمعان ويْعَيّطولو بُطرُس، ");
INSERT INTO arq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","راهو ساكَن عَند واحَد الدَبّاغ واسمو سَمعان، دارو جايّة عَند البْحَر\". ");
INSERT INTO arq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","غير راح المْلاك اللي كَلّمو، عَيَّط كَرنيليوس لزوج من الخَدّامين مْتاعو وواحَد العَسَّكري تَقي من اللي كانو يْضَلّو معاه، ");
INSERT INTO arq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","فَهَّمَّلهُم كُل شي وبْعَتهُم ليافا. ");
INSERT INTO arq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","غَدوة مَن داك، كانو هومَ فالطْريق، وقَرّبو للمْدينة، كي طْلَع بُطرُس للسْطَح باش يْصَلّي جْوايَه الطْناش مْتاع النْهار، ");
INSERT INTO arq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","وجاع بَزّاف وحَب ياكُل. بيدما كانو يْوَجّدولو الماكلة، غَيَّب، ");
INSERT INTO arq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","وشاف السْما مَحلولة، وحاجة هابَطة عليه كي شْغُل طَرف قْماش كْبير مَحكوم من رَبع طْراف ومْدَلّي على الأرض، ");
INSERT INTO arq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","وكان فيه كامَل هْوايَش الأرض والوْحوش والزْواحَف وطْيور السْما. ");
INSERT INTO arq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","وجا ليه صوت: \"نوض بُطرُس، أدبَح وكول\"، ");
INSERT INTO arq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","قال بُطرُس: \"لالا يا رَبّي، خاطَر عُمري ما كْليت حاجة خامجة وَلاّ ناجسة\"، ");
INSERT INTO arq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","جا ليه الصوت مَرّة تانية: \"اللي رَدّو الله طاهَر، ما تَحَّسبوش أنتَ خامَج\". ");
INSERT INTO arq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","تْعاوَد هاد الشي تَلت مَرّات أومبَعد نْرفَعت الحاجة للسْما. ");
INSERT INTO arq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","بْقا بُطرُس حايَر مع روحو واش مَعنَتها الرُؤيا اللي شافها، حَتّى هاو وين جاو الرْجال اللي بْعَتهُم كَرنيليوس. كانو سَقساو على دار سَمعان، ووَقفو عَند الباب، ");
INSERT INTO arq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","وعَيّطو يْسَقسيو وَلاّ سَمعان المْكَنّي بُطرُس ساكَن تَمّة. ");
INSERT INTO arq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","كان بُطرُس مازالو يْخَمَّم فالرُؤيا كي قاللو الروح: \"هام تَلت رْجال يْحَوّسو عليك، ");
INSERT INTO arq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","نوض، أَهبَط وروح معاهُم بلا ما تْشَك خاطَر أنا اللي بْعَتتهُم\". ");
INSERT INTO arq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","هْبَط بُطرُس للرْجال وقال: \"أنا هُوَ اللي راكُم تْحَوّسو عليه، واش من السَبّة اللي جيتو عليها؟\" ");
INSERT INTO arq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","قالو: \"قايَد المْية كَرنيليوس، راجَل صالَح ويْخاف الله، وكامَل أُمّة اليْهود تَشهَدلو، أتَّوحالو بمْلاك قُدّوس باش يَبعَت يْجيبَك لدارو ويَسمَع كْلام مَنَّك\". ");
INSERT INTO arq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","دَخَّلهُم بُطرُس وضَيَّفهُم. وغَدوة من داك، راح معاهُم وراحو معاه ناس من الخاوة اللي من يافا. ");
INSERT INTO arq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","غَدوة من داك، وَصلو لقَيصَريّة وكان كَرنيليوس يَستَنّا فيهُم وكان عْرَض مْواليه وحْبابو اللي قْراب ليه. ");
INSERT INTO arq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","وكي وْصَل بُطرُس، لاقاه كَرنيليوس وطاح ساجَد عَند رَجليه. ");
INSERT INTO arq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","نَوّضو بُطرُس وقال: \"نوض، أنا تاني بْنادَم\". ");
INSERT INTO arq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","أومبَعد دْخَل وهُوَ يَهدَر معاه، ولْقا ناس بَزّاف مَتلايمين، ");
INSERT INTO arq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","وقالَلهُم: \"راكُم عارفين باللي مْحَرَّم على اليْهودي باش يْخالَط البَرّاني وَلاّ يْجي لعَندو، بَصَّح أنا وَرّالي الله باش ما نْقول على حَتّى بْنادَم باللي خامَج وَلاّ ناجَس، ");
INSERT INTO arq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","على هَدا، كي بَعَتتولي جيت بْلا ما نْقول لالا، وراني حابكُم تْقولولي عْلاش بَعّتتو تْجيبوني\". ");
INSERT INTO arq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","قال كَرنيليوس: \"من رَبع أيّام، في هاد الساعة، كُنت نْصَلّي في داري على التْلاتة مْتاع العْشيّة، وهاو وين وْقَفلي راجَل بلَبسة تَبرَق، ");
INSERT INTO arq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","وقال: \"كَرنيليوس، صْلاتَك سْتُجابَت والله شْفا على الصَدقات مْتاعك، ");
INSERT INTO arq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","أَبعَت ليافا وعَيَّط لسَمعان المْكَنّي بُطرُس باش يْجي. راهو ساكَن في دار الدَبّاغ سَمعان عَند البْحَر\". ");
INSERT INTO arq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","تَم تَم بْعَتتلَك، وأنتَ عْمَلت مْليح كي جيت. دُرك هِمّالا، رانا كامَل حاضرين قُدّام الله باش نَسَّمعو كامَل واش آمرَك بيه الرَب\". ");
INSERT INTO arq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","حَل بُطرُس فَمّو وقال: \"فالصَح، نَستَعرَف باللي الله ما يْديرش الوْجوه، ");
INSERT INTO arq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","بَصَّح، في كُل أُمّة، يَرضا على اللي يْخافو ويْدير الصْلاح. ");
INSERT INTO arq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","بْعَت الكَلمة لبْني إسرائيل يْبَشَّر بالسْلام بيَسوع المَسيح، اللي هُوَ رَب الكُل، ");
INSERT INTO arq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","وراكُم عارفين بالشي اللي صْرا فاليَهودِيّة كُلها بَعد ما بْدا فالجْليل بَعد المَعموديّة اللي بَرَّح بيها يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","كيفاش الله دْهَن بالروح القُدّوس وبالقُدرة يَسوع الناصري، اللي كان يْروح من مَضرَب لمَضرَب يْدير الخير ويَشفي اللي كانو تَحت السيطَرة مْتاع إبليس خاطَر الله كان معاه، ");
INSERT INTO arq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","وحْنا شاهدين على كُل اللي دارو في اليَهوديّة وفي أورشَليم. هُوَ تاني اللي قَتلوه وهومَ مْعَلّقينو فالحْطَب، ");
INSERT INTO arq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","وحْياه الله فاليوم التالَت وسْمَح باش يَضهَر، ");
INSERT INTO arq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ماشي للشَعب كامَل، بَصَّح للشْهود اللي خَيَّرهُم الله من قْبَل، حْنا اللي كْلينا وشْرَبنا معاه بَعد قْيامتو من الموت، ");
INSERT INTO arq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ووَصّانا باش نْبَرّحو للشَعب ونَشَّهدو باللي هُوَ اللي دارو الله قاضي للحَيّين والموتى. ");
INSERT INTO arq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","كامَل الأنبيا يَشَّهدولو باللي اللي يامَن بيه يْنال بآسمو غُفران الدْنوب\". ");
INSERT INTO arq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","كي كان بُطرُس يَهدَر في هاد الكْلام، هْبَط الروح القُدّوس على كامَل اللي كانو يَسَّمعو فالكَلمة. ");
INSERT INTO arq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","دَهشو كامَل المومنين اللي راحو مع بُطرُس واللي كانو من صْحاب الخْتانة، خاطَر الروح القُدّوس تْفَرَّغ تاني على اللي ماشي يْهود، ");
INSERT INTO arq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","خاطَر كانو يَسَّمعو فيهُم يَهَّدرو بلُغات ويْعَضمو فالله. ");
INSERT INTO arq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","هِمّالا قال بُطرُس: \"قادَر واحَد يَمنَع باش يَتعَمّدو بالما هادو اللي نالو كيما حْنا تاني الروح القُدّوس؟\" ");
INSERT INTO arq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","وآمَر باش يَتعَمّدو بآسَم يَسوع المَسيح، وداك الوَقت، طَلبو منّو يْبقا يامات عَندهُم. ");
INSERT INTO arq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","سَمعو الرُسُل والخاوة اللي كانو فاليَهوديّة باللي اللي ماشي يْهود تاني قَبلو كَلمة الله، ");
INSERT INTO arq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","وكي طْلَع بُطرُس لأورشَليم، لاموه ناس الخْتانة، ");
INSERT INTO arq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","وقالو: \"دْخَلت عَند اللي ماشي مْخَتّنين وكْليت معاهُم\". ");
INSERT INTO arq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","بْدا بُطرُس يْفَهَّم فيهُم حاجة بحاجة وقال: ");
INSERT INTO arq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","\"كُنت في مْدينة يافا نْصَلّي، وغَيَّبت وشَفت رُؤيا: حاجة كي شْغَل طَرف قْماش كْبير مَحكوم من رَبع طْراف هْبَط من السْما وجا حَتّى لعَندي، ");
INSERT INTO arq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","بْقيت نُخزَر فيه ونْحَقَّق وشَفت هْوايَش الأرض والوْحوش والزْواحَف وطْيور السْما، ");
INSERT INTO arq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","وسْمَعت صوت يْقوللي: \"نوض بُطرُس، أدبَح وكول\". ");
INSERT INTO arq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","قُلت: \"لالا يا رَبّي، خاطَر عُمري ما دَخلَت في فَمّي حاجة خامجة وَلاّ ناجسة\". ");
INSERT INTO arq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","جاوَبني الصوت المَرّة التانية من السْما: \"اللي طَهّرو الله، ما تَحَّسبوش أنتَ خامَج\". ");
INSERT INTO arq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","صْرا هاد الشي تَلت مَرّات أومبَعد كُل شي نْجبَد للسْما. ");
INSERT INTO arq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","وتَم تَم، تَلت رْجال وَقفو عَند الدار وين كُنّا، كانو مَبعوتين لِيَّ من قَيصَرِيّة، ");
INSERT INTO arq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","وقاللي الروح نْروح معاهُم بلا ما نْشَك. جاو معايَ هاد الخاوة في سَتّة ودْخَلنا لدار الراجَل. ");
INSERT INTO arq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","حْكالنا كيفاش شاف المْلاك واقَف في دارو يْقول: \"أبعَت ليافا وجيب سَمعان المْكَنّي بُطرُس، ");
INSERT INTO arq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","وهُوَ يْقوللَك كْلام تَسلَك بيه أنتَ وكامَل دارَك\"، ");
INSERT INTO arq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","وكي بْديت نَهدَر، هْبَط الروح القُدّوس عليهُم كيما هْبَط علينا حْنا تاني فالبَدية، ");
INSERT INTO arq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","وتْفَكَّرت كْلام الرَب كي قال: \"يوحَنّا عَمَّد بالما، بَصَّح أنتومَ تَتعَمّدو فالروح القُدّوس\"، ");
INSERT INTO arq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","وَلاّ الله عْطالهُم الموهِبة اللي عْطاهالنا حْنا اللي آمَننا بالرَب يَسوع المَسيح، شْكون أنا باش نَمنَع الله؟\" ");
INSERT INTO arq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","كي سَمعو هاد الكْلام، سَكتو وعَضّمو الله وقالو: \"هِمّالا الله وْهَب التوبة للي ماشي يْهود تاني باش تْكونَلهُم الحْياة\". ");
INSERT INTO arq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","اللي تْزَربعو على جال المَحنة اللي صْرات بسْباب سْتِفانوس، راحو حَتّى لفينيقِيّة وقُبرُص وأنطاكية وما كانو يهَّدرو بالكَلمة لحَتّى واحَد من غير اليْهود. ");
INSERT INTO arq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","بَصَّح كان كايَن منهُم شي ناس، رْجال قُبرصِيّين وقيروانِيّين اللي كي جاو لأنطاكِية، كانو يَهَّدرو لليونانِيّين ويْبَشّرو بالرَب يَسوع، ");
INSERT INTO arq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","وكانَت يَد الرَب معاهُم وبَزّاف من الناس آمنو وسْترَجعو للرَب. ");
INSERT INTO arq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","وْصل خْبَرهُم لناس الكَنيسة اللي في أورشَليم، وبَعتو بَرنابا لأنطاكِية. ");
INSERT INTO arq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","كي وْصَل وشاف نَعمة الله، فْرَح وسَجَّعهُم كامَل باش يْشَدّو فالرَب بقَلب تابَت، ");
INSERT INTO arq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","خاطَر بَرنابا كان راجَل صالَح ومْعَمَّر بالروح القُدّوس والإيمان، وغاشي كْبير زاد آمَن بالرَب. ");
INSERT INTO arq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","أومبَعد راح بَرنابا لطَرطوس يْحَوَّس على شاوَل، وكي لْقاه، جابو لأنطاكية. ");
INSERT INTO arq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","عام كامَل وهومَ يَتلَمّو فالكَنيسة ودَرّسو غاشي كْبير، وفي أنطاكية اللي المَرّة الأُولى تْسَمّاو التابعين مَسيحِيّين. ");
INSERT INTO arq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","وفي هَدوك اليامات، هَبطو أنبيا من أورشَليم لأنطاكِية، ");
INSERT INTO arq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","وناض واحَد منهُم واسمو أغابوس، وعْلَمهُم بالروح باللي رايحة تْجي مَجاعة كْبيرة في كامَل الأرض، وجات في زْمان القَيصَر كْلوديوس. ");
INSERT INTO arq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","عَوّلو التابعين باش يَبَّعتو، كُل واحَد على حْساب مَقدورو، مْعاونة للخاوة اللي يَسُّكنو فاليَهوديّة، ");
INSERT INTO arq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ودارو هَكداد وبَعتو المْعاونة للشْيوخ مع بَرنابا وشاوَل. ");
INSERT INTO arq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","في هَداك الوَقت، كان السَلطان هيرودَس يَحڤَر ناس من الكَنيسة، ");
INSERT INTO arq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","وقْتَل بحَد السيف يَعقوب خو يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","وكي شاف هاد الشي عاجَب اليْهود، زاد حْكَم بُطرُس، وكانو يامات عيد الفْطير. ");
INSERT INTO arq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","وكي حَكمو وحَطّو فالحَبس، دارو تَحت العَسّة مْتاع رَبع رْباعات، كُل رْباعة فيها رَبع عْساكَر وكان مْعَوَّل يْحاكمو قُدّام الشَعب بَعد عيد الفَصح. ");
INSERT INTO arq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","هِمّالا، كان بُطرُس تَحت العَسّة فالحَبس، وكانَت صْلاة الكَنيسة لله حارّة على جالو. ");
INSERT INTO arq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ليلة قْبَل النْهار اللي كان مْعَوَّل هيرودَس يْحاكَم فيه بُطرُس، كان هُوَ راقَد بين زوج عْساكَر، مَربوط بزوج سْناسَل والعَسّاسين عَند الباب يْعَسّو فالحَبس. ");
INSERT INTO arq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","وهاو وين وْقَف مْلاك من الرَب وشْعَل ضو فالبيت. ضْرَب المْلاك بُطرُس في جَنبو ونَوّضو وقال: \"خَف نوض\". طاحو السْناسَل في زوج من يَدّيه، ");
INSERT INTO arq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","وقاللو المْلاك: \"أتْحَزَّم وأَلبَس صَبّاطَك\". دار بُطرُس هَكداد وزاد قاللو المْلاك: \"ألبَس عْبايتَك وتَبَّعني\". ");
INSERT INTO arq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","خْرَج بُطرُس يْتَبَّع فيه وما كانش عارَف باللي الشي اللي كان يْديرو المْلاك صَح وكان حاسَب روحو يْشوف في رُؤيا. ");
INSERT INTO arq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","بَعد ما جازو على العَسّاسين الأَوّلانِيّين والتانيين، وَصلو عَند باب الحْديد اللي تَدّي للمْدينة، ونْحَلَّتَّلهُم الباب وَحَّدها وخَرجو وكَمّلو لواحَد الزَنقة وتَم تَم فارقو المْلاك. ");
INSERT INTO arq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","فاق بُطرُس مع روحو وقال: \"دُرك عْرَفت بالتْبوت باللي الرَب بْعَت مْلاكو وسَلَّكني من يَد هيرودَس وكامَل الشي اللي كان يَستَنّا فيه شَعب اليْهود\". ");
INSERT INTO arq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","تَبَّت روحو وجا لدار مَريَم يَمّاة يوحَنّا المْكَنّي مَرقَس وين كانو بَزّاف مَتلايمين يْصَلّيو على جالو. ");
INSERT INTO arq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","كي طَبطَب في باب السْقيفة، جات خْديمة واسَمها رودا تَتصَنَّت، ");
INSERT INTO arq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","وكي عَرفَت صوت بُطرُس، من الفَرحة ما حَلَّتلوش الباب وراحَت تَجري للداخَل تْخَبَّر باللي بُطرُس راهو عَند الباب. ");
INSERT INTO arq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","قالولها: \"أنتِ مَهبولة\"، بَصَّح هِيَ بْقات تْوَكَّدَّلهُم باللي الشي كان هَكداك. قالو هومَ: \"هَداك المْلاك مْتاعو\". ");
INSERT INTO arq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","بْقا بُطرُس يْطَبطَب وكي حَلّو وشافوه نْدَهشو. ");
INSERT INTO arq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","شَرَّلهُم بيَدّو باش يَسُّكتو وحْكالهُم كيفاش خَرّجو الرَب من الحَبس وقال: \"خَبّرو يَعقوب والخاوة بهاد الشي\". أومبَعد خْرَج وراح لمَضرَب واحَدآخُر. ");
INSERT INTO arq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","كي طْلَع النْهار، صْرات هيلولة كْبيرة ما بين العَسكَر: \"يا دْرا واش صْرا لبُطرُس؟\" ");
INSERT INTO arq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","وهيرودَس، كي حَوَّس عليه وما لْقاهش، بْحَت العَسّاسين وآمَر باش يَدّيوهُم يَقُّتلوهُم، أومبَعد هْبَط من اليَهوديّة لقَيصَريّة وقْعَد تَمّة. ");
INSERT INTO arq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","كان هيرودَس مْغَشَّش على الصورِيّين والصيداوِيّين، هِمّالا جاو ليه براي واحَد ورَبحو من جيهَتهُم بْلاستَس الوْصيف المْكَلَّف بدارو وطَلبو يَتصالحو خاطَر بْلادهُم كانَت تْجيب القوت من بْلاد السَلطان. ");
INSERT INTO arq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","وفي يوم كانو مْحَدّدينو، لْبَس هيرودَس لْباس السْلاطَن وقْعَد على العَرش وخْطَبَّلهُم، ");
INSERT INTO arq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","وبْدا الشَعب يْعَيَّط: \"هَدا صوت إلَه ماشي صوت بْنادَم\". ");
INSERT INTO arq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","تَم تَم، ضْرَبو مْلاك الرَب خاطَر ما عْطاش المَجد لله، وبْدا الدود ياكُل فيه ومات. ");
INSERT INTO arq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","كَلمة رَبّي كانَت تَكبَر وتْزيد، ");
INSERT INTO arq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ووَلاّ بَرنابا وشاوَل من أورشَليم بَعدما كَمّلو خَدمَتهُم وأَدّاو معاهُم يوحَنّا المْكَنّي مَرقَس. ");
INSERT INTO arq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","كان فالكَنيسة في أنطاكية أَنبيا ورْجال يْعَلّمو: بَرنابا وسَمعان اللي يْسَمّيوَه الأَكحَل ولوكيوس القيرواني ومَنايَن اللي تْرَبّا مع هيرودَس رايَس الرُبع وشاوَل. ");
INSERT INTO arq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","وكي كانو يَخَّدمو فالرَب ويْصومو قال الروح القُدّوس: \"حَطّولي بجيهة بَرنابا وشاوَل للخَدمة اللي عَيَّطتَلهُم عليها\". ");
INSERT INTO arq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","داك الوَقت، صامو وصَلاّو ودارو يَدّيهُم عليهُم أومبَعد طَلقوهُم يْروحو. ");
INSERT INTO arq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","هومَ، كي بْعَتهُم الروح القُدّوس، هَبطو لسُلوكِيّة ومن تَم قَطعو البْحَر لقُبرُص. ");
INSERT INTO arq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","وكي وَصلو لسَلاميس، بْداو يْبَرّحو بكَلمة الله في مْجامَع اليْهود وكان معاهُم يوحَنّا يْعاوَن، ");
INSERT INTO arq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","وكي قَطعو الجَزيرة لبافوس، لْقاو واحَد الراجَل سَحّار، ونَبي كَدّاب يْهودي واسمو باريَشوع. ");
INSERT INTO arq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","كان مع الوالي سَرجيوس بولَس، راجَل فاطَن. عَيَّط هاد الراجَل لبَرنابا وشاوَل وطْلَب يَسمَع كَلمة الله، ");
INSERT INTO arq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","بَصَّح عَليم السَحّار، خاطَر هَدا هُوَ المَعنى مْتاع آسمو، بْدا يْغالَب فيهُم خاطَر كان حاب يْتَلَّف الإيمان للوالي. ");
INSERT INTO arq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","بَصَّح شاوَل اللي هُوَ بولَس، مْعَمَّر بالروح القُدّوس، خْزَر فيه، ");
INSERT INTO arq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","وقال: \"يا المْعَمَّر بكُل غَش وكُل خُبت، يا بْن إبليس، يا عْدو كُل صْلاح، ما تْحَبَّسش وأنتَ تْعَوَّج في طُرقان الله المْسَلّسين؟ ");
INSERT INTO arq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","دُرك، هاي يَد الرَب عليك، رايَح تْوَلّي عْمى وما تْشوفش الشَمس حَتّى لواحَد الوَقت\". تَم تَم، طاحَت عليه الضْبابة والضَلمة وبْدا يْحَوَّس وهوَ يْدَردَس على ناس يْڤَوّدوه. ");
INSERT INTO arq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","كي شاف الوالي داك الوَقت واش صْرا، آمَن وهُوَ داهَش في تَعليم الرَب. ");
INSERT INTO arq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","قَلَّع بولَس واللي معاه من بافوس وراحو لبَرجة في بَمفيلية، وتَمّة فارَقهُم يوحَنّا ورْجَع لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","هومَ راحو من بَرجة ووَصلو لأنطاكية بيسيدِيّة ودَخلو للمَجمَع في يوم السَبت وقَعدو. ");
INSERT INTO arq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","بَعد قْراية الشَريعة وكْتوب الأَنبيا، بَعتولهُم رِيّاس المَجمَع يْقولولهُم: \"يا الخاوة، وَلاّ كان عَندكُم كَلمة تْسَجَّع الشَعب، قولوها\". ");
INSERT INTO arq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ناض بولَس، رَوَّش بيَدّو وقال: \"يا بْني إسرائيل ويا اللي تْخافو الله، أَسَّمعو، ");
INSERT INTO arq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","إلَه شَعب إسرائيل هَدا خَيَّر جْدودنا وكَبَّر الشَعب كي كان ساكَن في بْلاد مَصر وخَرَّجهُم منها بقُوّة دْراعو، ");
INSERT INTO arq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","واحَد الرَبعين سْنة وهُوَ رافَدهُم فالصَحرا، ");
INSERT INTO arq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","أومبَعد فْنا سْبَع أُمّات في بْلاد كَنعان ووَرَّتهالهُم. ");
INSERT INTO arq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","دام هاد الشي واحَد الرَبع مْية وخَمسين سْنة. وبَعد هَدا، عْطالهُم قاضيين، حَتّى للنَبي صَموئيل الأخرّاني فيهُم، ");
INSERT INTO arq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","من تَم، طَلبو سَلطان وعْطالهُم الله شاوَل بَن قيس، راجَل من عْشيرة بَنيامين اللي كان سَلطان عليهُم مُدّة رَبعين سْنة، ");
INSERT INTO arq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","أومبَعد، عَزلو وعَيَّنَلهُم باش يْكون سَلطان داوَد اللي شْهَدلو وقال: \"لْقيت داوَد بَن يَسّى، راجَل على حْساب قَلبي، هُوَ اللي يْحَقَّق كُل مُرادي\"، ");
INSERT INTO arq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ومن دَرّيتو، على حْساب الوَعد، خَرَّج الله لإسرائيل السَلاّك يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","خاطَر قْبَل ما يْجي، سْبَق يوحَنّا وهْدَر على مَعموديّة التوبة لكامَل شَعب إسرائيل. ");
INSERT INTO arq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","وكي قَرَّب يوحَنّا يْكَمَّل طْريقو، قال: \"شْكون راكُم حاسبينني أنا؟ أنا ماشي هَداك اللي راكُم حاسبينو، بَصَّح رايَح يْجي مورايَ هَداك اللي ما نَستاهَلش نْحَل خْيوط سَبّاطو\". ");
INSERT INTO arq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","يا الخاوة، يا وْلاد سْلالة إبراهيم ويا اللي يْخافو الله فيكُم، لينا اللي نْبَعتَت هاد الكَلمة مْتاع السْلاك، ");
INSERT INTO arq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","خاطَر اللي يَسُّكنو في أورشَليم ورِيّاسهُم حَقّقو قْوال الأنبيا اللي يَتَّقراو كُل سَبت كي حَكمو على يَسوع خاطَر ما عَرفوهش، ");
INSERT INTO arq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ووالو ما لْقاو فيه حَتّى سَبّة يَستاهَل عليها الموت، طَلبو من بيلاطَس باش يَنَقتَل. ");
INSERT INTO arq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","وكي دارو كامَل الشي اللي نَكتَب عليه، هَبّطوه من الحْطَب وحَطّوه في قْبَر، ");
INSERT INTO arq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","بَصَّح الله حْياه من الموت، ");
INSERT INTO arq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","وضْهَر يامات بَزّاف للي طَلعو معاه من الجْليل لأورشَليم، واللي راهُم دُرك يَشَّهدولو عَند الشَعب. ");
INSERT INTO arq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","حْنا نْبَشّروكُم بالوَعد اللي نْدار لجْدودنا، ");
INSERT INTO arq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","واللي حَقَّقهولنا الله كامَل، حْنا وْلادهُم، كي حْيا يَسوع كيما راهو مَكتوب تاني فالمَزمور التاني: \"أنتَ وْليدي، أنا اليوم وْلَدتَك\". ");
INSERT INTO arq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","حْياه من الموت باش ما يْوَلّيش للفْساد، وهَدا هوَ الشي اللي خَبَّر بيه كي قال: \"نَعطيلكُم الحاجات المْقَدّسين والحَقّانِيّين مْتاع داوَد\"، ");
INSERT INTO arq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","وعلى هَدا، قال تاني في مَزمور آخُر: \"ما تْخَلّيش دات القُدّوس مْتاعك تَفسَد\"، ");
INSERT INTO arq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","خاطَر داوَد، بَعد ما خْدَم مُراد الله في وَقتو، رْقَد ولْحَق جْدودو وفَسدَت داتو، ");
INSERT INTO arq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","بَصَّح اللي حْياه الله ما وَصلوش الفْساد. ");
INSERT INTO arq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","يْكون في مَعلومكُم يا الخاوة، باللي بيه اللي يَتبَرَّحَّلكُم بغُفران الدْنوب، ");
INSERT INTO arq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","بيه يَنصلَح كل من يامَن من الشي اللي ما قْدَرتوش تَنصَلحو منّو بشَريعة موسى. ");
INSERT INTO arq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","هِمّالا، رَدّو بالكُم باش ما يْجيش عليكُم الشي اللي تْقال في كْتوب الأَنبيا: ");
INSERT INTO arq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"شوفو، أنتومَ يا اللي تَستَهزاو، أستَعجبو وأفناو، خاطَر راني نْدير خَدمة في ياماتكُم، خَدمة ما تامنوش لو كان يْخَبَّركُم بيها كاش واحَد.\"\" ");
INSERT INTO arq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","وكي خَرجو اليْهود، بْداو الناس يَطَّلبو منهُم باش يَهَّدرولهُم على هاد الكْلام فالسَبت الجاي. ");
INSERT INTO arq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","وكي تْفَرقَت الجْماعة، بَزّاف من اليْهود واللي دَخلو في دين اليْهود التاقيين تَبّعو بولَس وبَرنابا اللي كانو يَهَّدرو معاهُم ويْقَنّعو فيهُم باش يَتَّبتو في نَعمة الله. ");
INSERT INTO arq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","السَبت اللي من بَعد، قْريب كامَل المْدينة تْلايمَت باش تَسمَع كَلمة الرَب، ");
INSERT INTO arq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","وكي شافو اليْهود الغاشي، غارو بَزّاف بَزّاف وبْداو يْغالبو في كْلام بولَس ويْسَبّو فيه. ");
INSERT INTO arq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","بولَس وبَرنابا قالولهُم عيناني: \"أنتومَ الأوّلين اللي كان لازَم يَتبَرَّحَّلكُم بكَلمة الله، بَصَّح كي دَفَّعتوها وحْكَمتو باللي ما تَستاهلوش الحْياة الدايمة، رانا نْدورو للي ماشي يهْود، ");
INSERT INTO arq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","خاطَر هَكدا آمَرنا الرَب: \"دَرتَك نور للأُمّات باش تَدّي أنتَ السْلاك حَتّى لطَرف الدَنيا.\"\" ");
INSERT INTO arq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","اللي ماشي يْهود كانو يَفَّرحو كي يَسَّمعو هاد الشي وكانو يْعَضّمو كَلمة الرَب، وكامَل اللي كانو مُختارين للحْياة الدايمة آمنو. ");
INSERT INTO arq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","شاعَت كَلمة الرَب فالبْلاد كامَل، ");
INSERT INTO arq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","بَصَّح اليْهود حَرّشو النْسا المْدَيّنين اللي بالطْبَع والمَسؤولين مْتاع المْدينة ونَوّضو الشَحنة على بولَس وبَرنابا حَتّى حاوزوهُم من بْلادهُم. ");
INSERT INTO arq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","بولَس وبَرنابا نَفضو عليهُم غْبار رَجليهُم وراحو لإيقونِيّة، ");
INSERT INTO arq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","والتابعين كانو يَتعَمّرو بالفَرحة وبالروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","وفي إيقونية، دَخلو بولَس وبَرنابا لمَجمَع اليْهود وهَدرو حَتّى آمَن غاشي كْبير من اليْهود واليونانِيّين، ");
INSERT INTO arq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","بَصَّح اليْهود اللي ما آمنوش حَرّشو اللي ماشي يْهود وفَسّدولهُم نيَّتهُم من جيهة الخاوة. ");
INSERT INTO arq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","بولَس وبَرنابا بْقاو مُدّة طْويلة في إيقونية، يَهَّدرو وهومَ واتقين، تاكلين على الرَب اللي كان يَشهَد لكَلمة نَعَّمتو ويْخَلّي المارات والعْجايَب يَندارو على يَدّهُم. ");
INSERT INTO arq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","نْقَسمو ناس المْدينة، منهُم اللي كانو مع اليْهود والأخرين مع الرُسُل، ");
INSERT INTO arq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","وكي عَوّلو اللي ماشي يْهود واليْهود مع رِيّاسهُم باش يْهينو ويَرَّجمو بولَس وبَرنابا، ");
INSERT INTO arq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","وسَمعو بولَس وبَرنابا، هَربو لمْدايَن ليكأونية لِسترة ودَربة وجْوايَههُم، ");
INSERT INTO arq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","وكانو يْبَشّرو تَمّة. ");
INSERT INTO arq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","وكان يَقعُد في لِسترة راجَل عايَب من رَجليه، كَعوان من اللي نْزاد من كَرش يَمّاه، وعَمرو ما مْشا. ");
INSERT INTO arq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","هاد الراجَل كان يَسمَع بولَس يَهدَر، وخْزَر فيه بولَس وكي شاف عَندو الإيمان باش يَبرا، ");
INSERT INTO arq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","عَيَّط بالزور: \"نوض وأوقَف مْسَلَّس على رَجليك\"، ونَڤَّز الراجَل وبْدا يَمشي. ");
INSERT INTO arq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","كي شافو الناس واش دار بولَس، طَلّعو صوتهُم باللُغة الليكَأونيّة وقالو: \"الآلِهة هَبطو لينا في صِفة الناس\". ");
INSERT INTO arq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","كانو يْسَمّيو بَرنابا \"زَفس\" وبولَس \"هَرمَس\" خاطَر هُوَ اللي كان يَهدَر. ");
INSERT INTO arq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","كاهَن \"زَفس\" اللي كان المَعبَد مْتاعو فالدَخلة مْتاع المْدينة جاب فْراد وسْوالَف قُدّام بيبان المْدينة وحَب يَدبَح هُوَ والغاشي. ");
INSERT INTO arq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","كي سَمعو الرُسُل بَرنابا وبولَس، قَطّعو حْوايَجهُم وراحو يَجريو وهومَ يْعَيّطو، ");
INSERT INTO arq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ويْقولو: \"يا رْجال، عْلاش راكُم تْديرو هاد الشي؟ حْنا تاني عْباد كيما أنتومَ، رانا نْبَشّرو فيكُم باش تْخَلّيو هاد الحْوايَج الباطلين وتَستَرجعو لله الحَيّ اللي خْلَق السْما والأَرض والبْحَر وكُل ما فيهُم، ");
INSERT INTO arq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","اللي فالجْيال اللي جازو، خَلاّ كامَل الأُمّات يَمشيو في طُرقانهُم، ");
INSERT INTO arq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","والو ما حَبَّسش وهُوَ يَشهَد لروحو ويْدير الخير، ويَعطيلكُم من السْما الشْتا ومْواسَم الغَلّة، ويْمَدَّلكُم القوت زاكي ويْعَمَّر قْلوبكُم بالفَرحة\". ");
INSERT INTO arq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","وبالسيف باش بكْلامهُم هَدا مَنعو الغاشي باش يَدبَحَّلهُم. ");
INSERT INTO arq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","وجاو يْهود من أَنطاكية وإيقونيّة وقَنّعو الغاشي حَتّى رَجمو بولَس وكَركروه خارَج المْدينة وهومَ حاسبينو مِيَّت. ");
INSERT INTO arq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","بَصَّح كي دارو بيه التابعين، ناض ودْخَل للمْدينة. وغَدوة من داك راح مع بَرنابا لدَربة. ");
INSERT INTO arq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","وبَعد ما بَشّرو في هَديك المْدينة، ورَدّو ناس بَزّاف تابعين، وَلاّو للِسترة وإيقونِيّة وأَنطاكِية، ");
INSERT INTO arq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","يْقَوّيو نْفوس التابعين ويْسَجّعو فيهُم باش يَتَّبتو فالإيمان وباللي لازَم نْجوزو في شْدايَد بَزّاف باش نَدُّخلو لمَلَكوت الله. ");
INSERT INTO arq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","حَدّدولهُم في كُل كَنيسة شْيوخ، وبَعد ما صَلاّو وصامو خَلاّوهُم في يَد الرَب اللي آمنو بيه. ");
INSERT INTO arq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","وبَعد ما قَطعو على بيسيدِيّة، راحو لبَمفيلِيّة، ");
INSERT INTO arq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","وبَشّرو بالكَلمة في بَرجة وهَبطو لأَتّالِية. ");
INSERT INTO arq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ومن تَم، قَطعو البْحَر لأَنطاكية وين تْسَلمو لنَعمة الله للخَدمة اللي كَمّلوها. ");
INSERT INTO arq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","كي وَصلو، لَمّو الكَنيسة وحْكاو كامَل واش دار الله معاهُم وباللي حَل باب الإيمان للي ماشي يْهود، ");
INSERT INTO arq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","وقَعدو تَمّة مُدّة ماشي قْليلة مع التابعين. ");
INSERT INTO arq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","هَبطو ناس من اليَهوديّة وبْداو يْعَلّمو فالخاوة باللي لو كان ما تْتخَتّنوش على حْساب عادة موسى ما تَقَّدروش تَسَّلكو. ");
INSERT INTO arq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","كي تْحاكمو معاهُم بولَس وبَرنابا وصْرات شَقلالة كْبيرة بيناتهُم، شافو باللي بولَس وبَرنابا وناس واحَدُخرين مَنهُم يَطَّلعو للرُسُل والشْيوخ في أورشَليم على هاد الآمَر. ");
INSERT INTO arq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","بَعد ما بَعتَتهُم الكَنيسة، قَطعو على فينيقيّة والسامرة وهومَ يْخَبّرو باللي اللي ماشي يْهود آمنو. هاد الشي فَرَّح الخاوة كامَل فَرحة كْبيرة، ");
INSERT INTO arq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","وكي وَصلو لأورشَليم، لاقاتهُم الكَنيسة والرُسُل والشْيوخ وخَبّروهُم بولَس وبَرنابا بكامَل واش دار الله مْعاهُم. ");
INSERT INTO arq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","بَصَّح ناضو شي ناس من اللي آمنو واللي كانو من قْبَل على مَلَّة الفَرّيسِيّين، وقالو باللي اللي كانو ماشي يْهود لازَم يْتخَتّنو ونْسَيّفو عليهُم باش يْتبّعو شَريعة موسى. ");
INSERT INTO arq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","تْلَمّو الرُسُل والشْيوخ باش يْشوفو في هاد الآمَر، ");
INSERT INTO arq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","وبَعد ما كَتّرو وهومَ يْتشاورو، ناض بُطرُس وقال: \"يا الخاوة، راكُم عارفين باللي من بَكري الله خَيَّرني ما بيناتكُم باش اللي ماشي يْهود يَسَّمعو البْشارة من فَمّي ويامنو، ");
INSERT INTO arq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","والله اللي يَعرَف القْلوب شْهَدَّلهُم وعْطالهُم الروح القُدّوس كيما عْطالهولنا حْنا تاني، ");
INSERT INTO arq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","وما فَرَّق بيننا وبينهُم في حَتّى شي وصَفّا قْلوبهُم بالإيمان. ");
INSERT INTO arq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","دُرك، عْلاش راكُم تْجَرّبو فالله وتْحَطّو على رْقابي التابعين المَضماض اللي ما قَدرو لا جْدودنا وَلا حْنا نَرَّفدوه؟ ");
INSERT INTO arq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","بَصَّح نامنو باللي نَسَّلكو كيما هومَ بنَعمة الرَب يَسوع\". ");
INSERT INTO arq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","سَكتَت الجْماعة كامَل وكانو يَسَّمعو لبَرنابا وبولَس يَحكيو على كامَل المُعجِزات والعْجايَب اللي دارهُم الله عَند اللي ماشي يْهود على يَدّهُم. ");
INSERT INTO arq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","كي سَكتو، جاوَب يَعقوب وقال: \"أسَّمعوني يا الخاوة، ");
INSERT INTO arq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","حْكالنا سَمعان كيفاش مع الأوَّل فاقَد الله اللي ماشي يْهود باش يَدّي منهُم شَعب يَرفَد آسمو، ");
INSERT INTO arq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","وكْلام الأنبيا راهُم مع هاد الشي كيما راهو مَكتوب: ");
INSERT INTO arq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"بَعد هاد الشي، نْوَلّي ونْعاوَد نَبني خيمة داوَد الرايبة، نْرَقَّع اللي أتَّردَم منها ونْوَقَّفها من تارة وجْديد، ");
INSERT INTO arq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","باش الناس الباقيين يْحَوّسو على الرَب، هومَ وكامَل الأمّات اللي نَدكَر عليهُم آسمي، هَكدا يْقول الرَب اللي دار هاد الحاجات، ");
INSERT INTO arq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","المَعروفين من الدْوام.\" ");
INSERT INTO arq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","وعلى هاد الشي، راني نْشوف باللي ما لازَمش نْديرو مَشاكَل للي يَرَّجعو لله من اللي ما كانوش يْهود، ");
INSERT INTO arq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","بَصَّح نَكَّتبولهُم باش يْبَعّدو على نْجاسة الأصنام، والفَسق والجيفة والدَم. ");
INSERT INTO arq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","خاطَر موسى عَندو مَن بَكري في كُل مْدينة اللي يْبَشّرو بشَريعتو، على حْساب اللي يْقراوها فالمْجامَع كُل سَبت\". ");
INSERT INTO arq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","داك الوَقت، شافو الرُسُل والشْيوخ مع كامَل الكَنيسة باش يْخَيّرو رْجال مَنهُم ويَبَّعتوهُم لأنطاكية مع بولَس وبَرنابا وخَيّرو يَهودا اللي يْسَمّيوَه بَرسابا وسيلا وهاد الزوج كان شانهُم كْبير عَند الخاوة، ");
INSERT INTO arq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","وعْطاوَلهُم هاد البْرِيّة: \"من الرُسُل والشْيوخ والخاوة، للخاوة المومنين من غير اليْهود في أنطاكية وسورية وكيليكِيّة، سَلام، ");
INSERT INTO arq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","سْمَعنا باللي شي ناس من عَندنا، جاو قَلّقوكُم بكْلامهُم، وهَوّلو نْفوسكُم بلا ما نامروهُم، ");
INSERT INTO arq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","وتْفاهَمنا وحْنا على راي واحَد باش نْخَيّرو رْجال ونَبَّعتوهُمَّلكُم مع حْبابنا بَرنابا وبولَس. ");
INSERT INTO arq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","هاد الرْجال سَبّلو حْياتهُم على جال آسَم رَبّنا يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","بْعَتنالكُم يَهودا وسيلا وهومَ يْخَبّروكُم بهاد الحاجات بفَمّهُم. ");
INSERT INTO arq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","خاطَر، الروح القُدّوس وحْنا، بانَلنا مْليح لو كان ما نْحَمّلوكُمش كْتَر من هاد الحاجات اللازمين، ");
INSERT INTO arq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ما تاكلوش من الدْبايَح اللي يَندبحو للأصنام والدَم والجيفة وتْبَعّدو على الفَسق، هاد الحاجات تَعَّملو مْليح لو كان تَحَّفضو روحكُم منهُم. أنتهَلاّو في روحكُم\". ");
INSERT INTO arq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","الرُسُل بَعد ما راحو من الكَنيسة، هَبطو لأنطاكية ولَمّو الجْماعة وعْطاوَلهُم البْريّة. ");
INSERT INTO arq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","وكي قْراوها، فَرحو بيها خاطَر كانَت تْسَجَّع بَزّاف، ");
INSERT INTO arq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ويَهودا وسيلا على حْساب اللي كانو هومَ تاني أنبيا، سَجّعو الخاوة بكْلام بَزّاف وقَوّاوهُم. ");
INSERT INTO arq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","وبَعد ما جَوّزو وَقت، طَلقوهُم الخاوة باش يَرَّجعو للرُسُل بالسْلامة. ");
INSERT INTO arq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","بولَس وبَرنابا، بْقاو في أنطاكية يْدَرّسو ويْبَشّرو بكَلمة الرَب مع ناس واحَدُخرين بَزّاف. ");
INSERT INTO arq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","بَعد يامات، قال بولَس لبَرنابا: \"هَيّا نْوَلّيو ونْفاقدو خاوَتنا في كُل مْدينة بَشَّرنا فيها بكَلمة الرَب، نْشوفو كيفاش راهُم.\" ");
INSERT INTO arq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","حَب بَرنابا لو كان يَدّيو معاهُم تاني يوحَنّا اللي يْسَمّيوَه مَرقَس، ");
INSERT INTO arq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","بَصَّح بولَس شاف خير لو كان ما يَدّيوش معاهُم هَداك اللي خَلاّهُم في بَمفيلية وما راحش معاهُم للخَدمة. ");
INSERT INTO arq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","صْرا بيناتهُم دْواس حَتّى تْفارقو. بَرنابا أدّا مَرقَس وقْطَع البْحَر لقُبرُص، ");
INSERT INTO arq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","وبولَس خَيَّر سيلا وراح بَعد ما حَطّوه الخاوة في نَعمة الله، ");
INSERT INTO arq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","وجاز على سورية وكيليكِيّة يْقَوّي الكْنايَس. ");
INSERT INTO arq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ووْصَل بولَس لدَربة ولِسترة، وكان تَمّة تابَع واسمو تيموتاوَس، يَمّاه يْهوديّة مومنة بَصَّح باباه يوناني، ");
INSERT INTO arq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","وكانو يَشَّهدولو الخاوة اللي في لِسترة وإيقونية بالخير. ");
INSERT INTO arq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","حَب بولَس يَدّيه معاه، أدّاه وخَتّنو على جال اليْهود اللي كانو في هَدوك الجْوايَه، خاطَر كامَل كانو يَعَّرفو باللي باباه يوناني. ");
INSERT INTO arq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","وكانو يْجوزو فالمْدايَن يَعطيو للخاوة الأُمور اللي آمرو بيهُم الرُسُل والشْيوخ اللي في أورشَليم، ");
INSERT INTO arq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","وكانو الكْنايَس يَتقَوّاو فالإيمان ويْزيدو يوم بَعد يوم. ");
INSERT INTO arq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","جازو على فَريجيّة وبْلاد غَلاطيّة، ومنَعهُم الروح القُدّوس يْبَشّرو بالكَلمة في آسيا، ");
INSERT INTO arq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","وكي وَصلو لميسِيّا، حَبّو يْروحو لبتينِيّة بَصَّح روح يَسوع ما خَلاّهُمش. ");
INSERT INTO arq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","جازو على ميسِيّا وهَبطو لتَرواس. ");
INSERT INTO arq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","فالليل، شاف بولَس رُؤيا: وْقَفلو راجَل مَقدوني يَطلَب منّو ويْقول: \"جوز لمَقدونية، سَلَّكنا.\" ");
INSERT INTO arq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","كي شاف بولَس هاد الرُؤيا، تَم تَم حَوّسنا نْروحو لمَقدونية، خاطَر فْهَمنا باللي الله عَيَّطلنا باش نْبَشّرو المَقدونِيّين. ");
INSERT INTO arq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","من تَرواس، قْطَعنا البْحَر قْبالة لساموتراكي وغَدوة من داك لنيابوليس. ");
INSERT INTO arq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ومن تَم، رُحنا لفيليبّي وهِيَ المْدينة الأُولى في مَقدونية ومَستَعمرينها الرومان. جَوَّزنا يامات في هاد المْدينة، ");
INSERT INTO arq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","وفي يوم السَبت، خْرَجنا بَرّا على المْدينة عَند واحَد الواد وين كُنّا حاسبين نَلقاو مْكان للصْلاة، وقْعَدنا وبْدينا نَهَّدرو مع نْسا كانو مَتلايمين تَمّة. ");
INSERT INTO arq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","واحدة فيهُم واسَمها ليدِيّة، من مْدينة تياتيرا، كانَت تْبيع قْماش غالي، وتْخاف الله. وكانَت تَسمَع خاطَر الرَب حَلَّلها قَلبها باش تَتعَلَّق بكْلام بولَس. ");
INSERT INTO arq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","كي تْعَمّدَت هِيَ ومْواليها، طَلبَت منّا وقالَت: \"وَلاّ شَفتوني مومنة بالرَب، أدُّخلو لداري وبْقاو\"، ووَكّدَت علينا. ");
INSERT INTO arq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","واحَد المَرّة، كي كُنّا رايحين للصْلاة، لاقاتنا خْديمة صْغيرة مَسكونة بروح الڤْزانة وكانَت تَربَح دْراهَم كْبار لسْيادها كي تْڤَزَّن، ");
INSERT INTO arq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","وكانَت تْتَبَّع فينا حْنا وبولَس وهِيَ تْعَيَّط: \"هاد الناس هومَ خَدّامين الله العالي، هومَ اللي يْبَشّروكُم بطْريق السْلاك.\" ");
INSERT INTO arq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","يامات بَزّاف وهيَ تْدير هاد الشي، حَتّى كْرَه بولَس ودار وقال للروح: \"نامرَك باسَم يَسوع المَسيح تَخرُج منها\"، وفي ديك الساعة خْرَج منها الروح. ");
INSERT INTO arq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","وكي شافو سْيادها الشي اللي كان يْجيبَلهُم المال راح، حَكمو بولَس وسيلا وكَركروهُم للساحة الشَعبِيّة عَند القاضيين، ");
INSERT INTO arq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","وكي جابوهُم للقاضيين قالو: \"هاد الرْجال راهُم يْهَوّلو في مْدينَتنا. هومَ يْهود، ");
INSERT INTO arq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","وراهُم يْعَلّمو عْوايَد اللي ما يْجوزَلنا حْنا الرومان لا نَقَّبلوهُم وَلا نْتَبّعوهُم\"، ");
INSERT INTO arq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","وتْحاما عليهُم الغاشي وقَطّعولهُم القاضيين حْوايَجهُم وآمرو باش يَجَّلدوهُم. ");
INSERT INTO arq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","بَعد ما ضَربوهُم بَزّاف، رْماوهُم فالحَبس ووَصّاو العَسّاس باش يْعَسّهُم مْليح. ");
INSERT INTO arq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","العَسّاس كي سْمَع هاد الوْصاية، رْماهُم فالحَبس الدَخلاني وحَطّ رَجليهُم في قالَب مْتاع الحْطَب. ");
INSERT INTO arq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","في نَص الليل، كان بولَس وسيلا يْصَلّيو ويْسَبّحو فالله بالغْنا والمْحابسِيّة كانو يَسَّمعو فيهُم، ");
INSERT INTO arq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","وهاي وين، ضَربَت زْنزلة قْوِيّة حَتّى زَعزَت اللْساس مْتاع الحَبس وتَم تَم نْحَلّو كامَل البيبان والسْناسَل مْتاع كامَل المْحابسيّة. ");
INSERT INTO arq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","فْطَن العَسّاس وكي شاف بيبان الحَبس مَحلولين، جْبَد السيف باش يُقتَل روحو خاطَر حْسَب المْحابسِيّة هَربو. ");
INSERT INTO arq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","عَيَّط بولَس بالزور وقال: \"ما تْضَرش روحَك، رانا كامَل هْنا.\" ");
INSERT INTO arq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","طْلَب العَسّاس الضو، ودْخَل يَجري للداخَل ورْما روحو عَند بولَس وسيلا وهُوَ يَرعَش، ");
INSERT INTO arq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","وخَرَّجهُم وقال: \"يا سْيادي، واش لازَم نْدير باش نَسلَك؟\" ");
INSERT INTO arq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","قالولو :\"آمَن بالرَب يَسوع، تَسلَك أَنتَ وناس دارَك\"، ");
INSERT INTO arq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","وبَشّروه بكَلمة رَبّي هُوَ وكامَل اللي كانو في دارو، ");
INSERT INTO arq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","وأدّاهُم في هَديك الساعة مْتاع الليل، نَقّالهُم جْروحهُم، وتَم تَم تْعَمَّد هُوَ وكامَل ناسو. ");
INSERT INTO arq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","وكي طَلَّعهُم لدارو، عْطالهُم ياكلو وفْرَح مع كامَل ناس دارو كي آمَن بالله. ");
INSERT INTO arq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","كي طْلَع النْهار، بَعتو القاضيين مْراسَل يْقولو للعَسّاس: \"أَطلَق هَدوك الرْجال\". ");
INSERT INTO arq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","خَبَّر العَسّاس بولَس بهاد الكْلام، باللي القاضيين بَعتو باش نَطَّلقوكُم، \"أخُّرجو هِمّالا دُرك وروحو هانيين.\" ");
INSERT INTO arq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","قال بولَس للمْراسَل: \"بَعد ما جَلدونا قُدّام الناس بلا ما يْحاكمونا وحْنا رومانِيّين، ودَخّلونا للحَبس، دُرك يَطَّلقونا فالسَر؟ لالا، لازَم يْجيو هومَ بداتهُم يَطَّلقونا.\" ");
INSERT INTO arq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","كي أدّاو العَسكَر هاد الكْلام للقاضيين، خافو كي عَرفو باللي بولَس وسيلا رومانِيّين، ");
INSERT INTO arq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","وجاو يْحَلّلو فيهُم وطَلقوهُم وطَلبو منهُم يَخُّرجو من المْدينة. ");
INSERT INTO arq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","كي خَرجو من الحَبس، راحو عَند ليدِيّة، وبَعد ما شافو الخاوة وسَجّعوهُم، راحو. ");
INSERT INTO arq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","بَعد ما جازو على أمفيبوليس وأبولونِيّة، وَصلو لتيسالونيكي وين اليْهود كان عَندهُم مَجمَع، ");
INSERT INTO arq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ودْخَل بولَس عَندهُم كي عادتو، وتَلت سْبوت وهُوَ يَهدَر معاهُم على حْساب الكْتوب، ");
INSERT INTO arq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ويْفَهَّم ويْبَيَّن باللي المَسيح كان لازَم يْتعَدَّب ويْعاوَد يَحيا من الموت، وباللي يَسوع اللي راني نْبَشَّركُم بيه هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","قْتَنعو ناس منهُم وتَبّعو بولَس وسيلا ومعاهُم غاشي كْبير من اليونانيّين التاقيين وبَزّاف من النْسا اللي بالطْبَع. ");
INSERT INTO arq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","غارو اليْهود وجابو ناس مَشرارين من صْحاب الزَنقة وتْلايمو وهَيّجو المْدينة وراحو لدار ياسون يَطَّلبو بولَس وسيلا باش يَدّيوهُم للشَعب. ");
INSERT INTO arq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","وكي ما لْقاوهُمش، كَركرو ياسون وشي خاوة عَند الحُكّام وهومَ يْعَيّطو باللي هاد الناس اللي قَلّبو الدَنيا راهُم جاو اللَهنا تاني، ");
INSERT INTO arq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","وياسون ضَيَّفهُم. وهومَ كامَل يْخالفو القْوانَن مْتاع قَيصَر ويْقولو باللي كايَن سَلطان واحَدآخُر هُوَ يَسوع\". ");
INSERT INTO arq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","بهاد الكْلام هَوّلو الغاشي وحُكّام المْدينة، ");
INSERT INTO arq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","اللي حَتّى أدّاو كَفالة من عَند ياسون واللي مْعاه باش طَلقوهُم. ");
INSERT INTO arq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","تَم تَم، بَعتو الخاوة بولَس وسيلا فالليل لبيرِيّة، وكي وَصلو، راحو للمَجمَع. ");
INSERT INTO arq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","اليْهود مْتاع بيرِيّة كانو خير من اليْهود مْتاع تيسالونيكي، قَبلو كَلمة الله بالهَمّة وكانو كُل يوم يْقَلّبو الكْتوب باش يْشوفو وَلاّ الشي اللي كان يَتقالَلهُم صَح. ");
INSERT INTO arq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","بَزّاف مَنهُم آمنو، بَزّاف من النْسا اليونانِيّات اللي بالطْبَع ورْجال بَزّاف. ");
INSERT INTO arq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","كي عَرفو يْهود تيسالونيكي باللي في بيرِيّة تاني بولَس راهو يْبَشَّر بكَلمة الله، جاو لتَمّة وبْداو يْهَيّجو ويْحَرّشو فالغاشي. ");
INSERT INTO arq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","تَم تَم، بَعتو الخاوة بولَس باش يْروح على طْريق البْحَر بَصَّح سيلا وتيموتاوَس قَعدو تَمّة. ");
INSERT INTO arq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","اللي راحو مع بولَس وَصّلوه حَتّى لأَتينا، وَصّاهُم بولَس باش سيلا وتيموتاوَس يَلَّحقوه بالخَف وراحو. ");
INSERT INTO arq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","في أتينا، كي كان بولَس يَستَنّا فيهُم، حَس الروح يَتقَلَّق فيه كي شاف المْدينة مْعَمّرة بالأصنام. ");
INSERT INTO arq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","بْدا يَهدَر فالمَجمَع مع اليْهود ومع اللي يَعَّبدو الله، وكُل يوم مع اللي يْكونو فالساحة الشَعبِيّة. ");
INSERT INTO arq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","واحَد الفَلاسِفة الأبيقورِيّين والرِواقِيّين بْداو يَهَّدرو مْعاهم وكايَن اللي كانو يْقولو: \"واش حَبّ يْقول هاد الهَدّار؟\" وواحَدُخرين: \"على حْساب الشوفة، راهو يْبَرَّح بآلِهة غْريبة\"، خاطَر كان يْبَشَّر بيَسوع والقِيامة. ");
INSERT INTO arq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","حَكموه وأَدّاوَه لكُدية أَريوس باغوس وسَقساوَه: \"نَقَّدرو نَعَّرفو واش هاد المَدهَب الجْديد اللي راك تْعَلَّم فيه؟ ");
INSERT INTO arq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","خاطَر رانا نَسَّمعو فيك تْجيب حاجات موغريبة ومادابينا نَعَّرفو واش حَبّ يْقول هاد الشي.\" ");
INSERT INTO arq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","كامَل الأَتينِيّين والبْراوِيّة اللي يَسُّكنو في آتينا كانو يْجَوّزو وَقتهُم غير باش يَهَّدرو ويَسَّمعو حاجات جْدَد. ");
INSERT INTO arq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","وْقَف بولَس في وَسط أَريوس باغوس وقال: \"يا ناس أتينا، راني نْشوف فيكُم بَزّاف مْدَيّنين في كُل حاجة، ");
INSERT INTO arq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","وكي كُنت جايَز على مْدينَتكُم وشَفت المْقامات المْقَدسين مْتاعكُم، لْقيت تاني مَدبَح مَكتوب عليه: \"للإلَه اللي ماشي مَعروف\"، هاد الإلَه اللي راكُم تَعَّبدو فيه بْلا ما تَعَّرفوه، هَداك هُوَ اللي راني نْخَبَّر فيكُم بيه، ");
INSERT INTO arq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","الإلَه اللي خْلَق الدَنيا وكُل ما فيها، على حْساب اللي هُوَ رَب السْما والأَرض، ما يَسكُنش في مْعابَد مَبنِيّين بيَدّين الناس، ");
INSERT INTO arq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ماشي يَدّين الناس اللي يَخَّدموه، كي اللي راهو يَسحَق كاش حاجة، خاطَر هُوَ يَعطي لكامَل الخَلق الحْياة والنَفس وكُل شي، ");
INSERT INTO arq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","خْلَق كامَل الأُمّات من بْنادَم واحَد وسَكَّنهُم في كامَل الأَرض وحَدَّدلهُم الوْقات ودارلهُم حْدود للسُكنان، ");
INSERT INTO arq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","باش يْحَوّسو على الله وهومَ يْدَردسو بَلاك يَلقاوَه، هُوَ اللي فالصَح ما راهوش بْعيد على كُل واحَد فينا، ");
INSERT INTO arq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","خاطَر بيه نَحياو ونَتحَرّكو ونْكونو. كيما قالو شي شُعَرا منكُم: \"خاطَر حْنا تاني دَرّيّتو\". ");
INSERT INTO arq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","هِمّالا، كي رانا دَرّيّة الله، ما لازَمناش نَحَّسبو الأُلوهية تْشَبَّه لدْهَب وَلاّ لفَضّة وَلاّ لحْجَر، هاد الحاجات المَنقوشين بفَن وخَدمة بْنادَم، ");
INSERT INTO arq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","دُرك، الله بْلا ما يْدير على زْمان الجْهَل، يامَر كامَل الناس في كُل مْكان باش يْتوبو، ");
INSERT INTO arq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","خاطَر حَدَّد يوم وين عَوَّل يْحاكَم الدَنيا بالحَق، بالراجَل اللي خَيّرو، واللي عْطا عليه البَرهان للجْميع كي حْياه من الموت\". ");
INSERT INTO arq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","كي سَمعو بالقِيامة من الموت، كايَن اللي سْتَهزاو وكايَن اللي قالو: \"نَسَّمعوك على هاد الشي مَرّة أخرى\"، ");
INSERT INTO arq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","وهَكدا خْرَج بولَس من وَسطهُم. ");
INSERT INTO arq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","كايَن ناس شَدّو فيه وآمنو، منهُم ديونيسيوس الأريوباغي، ومْرا واسَمها دامارِيس وواحَدُخرين معاهُم. ");
INSERT INTO arq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","بَعد هاد الشي، راح بولَس من أتينا وجا لكورَنتوس. ");
INSERT INTO arq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","لْقا تَمّة واحَد اليْهودي واسمو أكيلا أصلو من بَنطَس، كان غير كيما وْصَل من الطاليان مع مَرتو بْريسكِلاّ، خاطَر القَيصَر كْلوديوس آمَر باش كامَل اليْهود يَخُّرجو من روما، وبولَس راح لعَندهُم. ");
INSERT INTO arq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","وعلى حْساب اللي كانَت عَندو صَنعة كيما مْتاعهُم، قْعَد يَخدَم معاهُم، كانو يَخَّدمو الخْيَم. ");
INSERT INTO arq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","وكان بولَس في كُل سَبت يَهدَر مع الناس فالمَجمَع ويْقَنَّع يْهود ويونانِيّين. ");
INSERT INTO arq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","وكي هَبطو سيلا وتيموتاوَس من مَقدونية، مَد بولَس وَقتو كامَل للتَبشير وبْقا يَشهَد لليْهود باللي يَسوع هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","بَصَّح كي بْقاو هومَ يْقاومو فيه ويْسَبّو، نْفَض بولَس حْوايجو وقالَلهُم: \"دَمّكُم على رَقبَتكُم، أنا راني مْبَرّي مَنّو، من دُرك نْروح للي ماشي يْهود\". ");
INSERT INTO arq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","وخْرَج من تَم وراح لدار واحَد الراجَل يَعبَد الله واسمو يوستَس وكانَت دارو لاصقة مع المَجمَع، ");
INSERT INTO arq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","وكْريسبَس رايَس المَجمَع آمَن بالرَب هُوَ وكامَل ناس دارو وبَزّاف من الكورَنتِيّين كي سَمعو لبولَس، آمنو وتْعَمّدو. ");
INSERT INTO arq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","قال الرَب في واحَد الليلة لبولَس في رُؤيا: \"ما تْخافش، أهدَر وما تَسكُتش، ");
INSERT INTO arq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","خاطَر راني معاك وواحَد ما يَقدَر يْضَرَّك، خاطَر عَندي شَعب كْبير في هاد المْدينة\". ");
INSERT INTO arq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","قْعَد بولَس عام وسَت شْهور يْدَرَّس عَندهُم في كَلمة الله. ");
INSERT INTO arq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","وكي كان غاليون حاكَم على بْلاد أخائية، تْفاهمو اليْهود براي واحَد على بولَس وأدّاوَه لدار الشْرَع، ");
INSERT INTO arq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","وقالو باللي هاد الراجَل راهو حاب يْقَنَّع الناس باش يَعَّبدو الله بسيرة مْخالفة للشَريعة\". ");
INSERT INTO arq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","وكي كان بولَس رايَح يَهدَر، قال غاليون لليْهود: \"يا اليْهود، وَلاّ كانَت حاجة مْتاع جْريمة وَلاّ عَملة دونِيّة، نَسمَعَّلكُم على حْساب المَنطَق، ");
INSERT INTO arq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","وَلاّ كانَت مُشكِلة على مَدهَب وأسماوات وعلى الشَريعة مْتاعكُم، شوفو أنتومَ، ما رانيش حاب نْكون قاضي في هاد الحْوايَج\"، ");
INSERT INTO arq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","وحاوَزهُم من دار الشْرَع. ");
INSERT INTO arq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","كامَل حَكمو سوستان رايَس المَجمَع وضَربوه قُدّام دار الشْرَع وما تْحَرواش غاليون في هاد الشي. ");
INSERT INTO arq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","بْقا بولَس يامات بَزّاف، أومبَعد وَدَّع الخاوة وقْطَع البْحَر لسورِيّة ومعاه بْريسكِلاّ وأكيلا بَعدما حَفَّف شَعرو كامَل في كَنخَريا خاطَر كان دار عَهَد. ");
INSERT INTO arq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","كي وَصلو لأَفسُس، خَلاّهُم بولَس فيها ودْخَل للمَجمَع وبْدا يَهدَر مع اليْهود. ");
INSERT INTO arq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","وطَلبو مَنّو باش يْزيد يْطَوَّل مْعاهُم في أفسُس، بَصَّح هُوَ ما قْبَلش، ");
INSERT INTO arq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ووَدَّعهُم وقال: \"راني نَرجَع ليكُم نْشا الله\"، وراح من أفسُس. ");
INSERT INTO arq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","كي وْصَل لقَيصَرِيّة، طْلَع وسَلَّم على الكَنيسة وهْبَط لأنطاكية، ");
INSERT INTO arq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","وقْعَد فيها شْوِيّة وراح لغَلاطِيّة وفَريجِيّة واحدة مور الأُخرى وهُوَ يْسَجَّع في كامَل التابعين. ");
INSERT INTO arq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","واحَد اليْهودي واسمو أبُلّوس من سْكَندرِيّة، راجَل يَعرَف يَهدَر ويَعرَف الكْتوب مْليح، جا لأفسُس، ");
INSERT INTO arq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","وكان عَندو عَلم كْبير على طْريق الرَب وكان يَهدَر على يَسوع وهُوَ مَتحَمَّس بالروح، وكان يَعرَف غير مَعمودِيّة يوحَنّا، ");
INSERT INTO arq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","وبْدا يَهدَر عيناني فالمَجمَع وكي سَمعوه أكيلا وبْريسكِلاّ أدّاوَه معاهُم وفَهّموه مْليح طْريق الرَب. ");
INSERT INTO arq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","وكي كان حاب يْروح لأخائيّة، كَتبو الخاوة للتابعين يْوَصّيوهُم يْرَحّبو بيه، وكي وْصَل عاوَن بَزّاف بنَعمة الله اللي كانو آمنو، ");
INSERT INTO arq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","خاطَر كان يْغالَب اليْهود عيناني ويْسَكَّتهُم بجواب صْحيح وهُوَ يْبَيّن بالكْتوب باللي يَسوع هُوَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","وكي كان أَبُلّوس في كورَنتوس، هْبَط بولَس لأفسُس بَعدما جاز على المْضارَب العاليين ولْقا واحَد التابعين، ");
INSERT INTO arq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","وقالَلهُم: \"نَلتو الروح القُدّوس كي آمَنتو؟\" واجبوه: \"ما سْمَعناش حَتّى باللي كايَن روح قُدّوس.\" ");
INSERT INTO arq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","قالَلهُم: \"هِمّالا، واش من المَعمودِيّة اللي تْعَمَّدتو بيها؟\" جاوبوه: \"بمَعمودِيّة يوحَنّا.\" ");
INSERT INTO arq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","قال بولَس: \"يوحَنّا عَمَّد بمَعموديّة التوبة وكان يْقول للشَعب باش يامَن باللي يْجي بَعدو، يَعني يَسوع.\" ");
INSERT INTO arq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","كي سَمعولو، تْعَمّدو بآسَم الرَب يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","وكي دار بولَس يَدّو عليهُم، جا الروح القُدّوس عليهُم، وبْداو يَهَّدرو بلُغات ويَتنَبّأو، ");
INSERT INTO arq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","وكانو كامَل واحَد الطْناشَن راجَل. ");
INSERT INTO arq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ودْخَل للمَجمَع وين بْقا تَلت شْهور وهُوَ يَهدَر عيناني ويْتَبَّت ويْقَنَّع فالناس بآمَر مَلكوت الله. ");
INSERT INTO arq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","بَصَّح كايَن فيهُم اللي قَسّاو روحهُم، وما حَبّوش يامنو وبْداو يْقولو الشَر على طْريق الرَب قُدّام الغاشي. هِمّالا، جْبَد بولَس روحو مَنهُم وفْرَز التابعين وكان يَهدَرَّلهُم كُل يوم في مْسيد مْتاع واحَد واسمو تيرانوس. ");
INSERT INTO arq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","دام هاد الشي مُدّة عامين حَتّى وَصلَت كَلمة الرَب لكامَل اللي كانو يَسَّكنو في آسيا، يْهود ويونانِيّين. ");
INSERT INTO arq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","وكان الله يْدير مُعجِزات هايلين على يَد بولَس، ");
INSERT INTO arq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","حَتّى وَلاّو الناس يْحَطّو على المَرضى الحْوايَج والمْشاوَر اللي مَسّو داتو ويَبراو ويَخُّرجو منهُم الأرواح الدونِيّين. ");
INSERT INTO arq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","وَلاّت جْماعة من اليْهود العَزّامين الجَوّالين يْسَمّيو على اللي كانو مَسكونين بالأرواح الدونِيّين بآسَم الرَب يَسوع ويْقولو: \"نَحَّلفو عليكُم بآسَم يَسوع اللي يْبَرَّح بيه بولَس.\" ");
INSERT INTO arq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","والناس اللي كانو يْديرو هاد الشي، كانو سَبع رْجال، وْلاد واحَد اليْهودي واسمو سْكاوا وهاد الراجَل كان رايَس الكاهنين. ");
INSERT INTO arq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","جاوَبهُم الروح الشَرّاني وقال: \"نَعرَف يَسوع ونَعرَف بولَس بَصَّح أنتومَ شْكون؟\" ");
INSERT INTO arq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","وهْجَم عليهُم الراجَل اللي فيه الروح الدوني، كان أقوى منهُم وغْلَبهُم حَتّى هَربو من الدار اللي كانو فيها عَريانين ومَجروحين. ");
INSERT INTO arq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","نَعرَف هاد الشي عَند كامَل اليْهود واليونانِيّين اللي يَسَّكنو في أفسُس وطاح الخوف عليهُم كامَل وكان آسَم الرَب يَسوع يْتعَضَّم. ");
INSERT INTO arq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","وكانو بَزّاف من اللي آمنو يْجيو يْقَرّو ويَستَعرفو بفْعالهُم. ");
INSERT INTO arq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","وبَزّاف من اللي كانو يْديرو السْحور، لَمّو كْتوبهُم وحَرقوهُم قُدّام الناس. وحَسبو سومَتهُم ولْقاوها قيس خَمسين ألف ويزة. ");
INSERT INTO arq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","وهَكدا بقُوّة الرَب، كانَت كَلمة الله تَكبَر وتَقوا. ");
INSERT INTO arq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","وكي صْرا هاد الشي، دار بولَس في بالو باش يْجوز على مَقدونِية وأخائيّة ويْروح لأورشَليم، وقال باللي بَعد ما نْكون تَمّة لازَم علِيَّ نْزيد نْشوف روما. ");
INSERT INTO arq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","بْعَت لمَقدونِية زوج من اللي كانو يْعاونوه، تيموتاوَس وأَرَسطوس وقْعَد مُدّة في آسيا. ");
INSERT INTO arq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","وفي هَداك الوَقت، صْرات هيلولة كْبيرة على جال طْريق الله. ");
INSERT INTO arq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","واحَد الصِيّاغ واسمو ديمِتريوس، كان يَخدَم مْعابَد مْتاع الفَضّة لأرطاميس وكان يَربَح دْراهَم كْبار هُوَ والخَدّامين مْتاعو. ");
INSERT INTO arq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","لَم الخَدّامين مْتاعو واللي كانَت صَنعَتهُم كيما هُوَ وقال: \"يا رْجال، راكُم عارفين باللي هاد الصَنعة هِيَ اللي رَفّهَتنا، ");
INSERT INTO arq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","وراكُم تْشوفو وتَسَّمعو باللي ماشي بَرك في أفسُس بَصَّح في قْريب كامَل آسيا، هَدا بولَس جْبَد ودَوَّر غاشي كْبير وهُوَ يْقول باللي الآلِهة اللي مَخدومين بيَدّين العْباد ماشي آلِهة مْتاع الصَح، ");
INSERT INTO arq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","وهاد الشي ما راهوش رايَح يْضَر صَنعَتنا بَرك، بَصَّح رايَح يْنَحّي الهيبة لمَعبَد إلَهَتنا الكْبيرة أرطاميس، ويْبَطَّل القيمة الكْبيرة مْتاعها، هِيَ اللي يَعَّبدوها في كامَل آسيّا وفي كامَل الدَنيا\". ");
INSERT INTO arq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","كي سَمعو هاد الكْلام، تْغَششو بَزّاف وبْداو يْعَيّطو ويْقولو: \"كْبيرة هِيَ أرطاميس إلَهة الأفسُسيّين\". ");
INSERT INTO arq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","تْهَولَت المْدينة وهَجمو براي واحَد للمَسرَح وكَركرو معاهُم غايوس وأرِستَرخُس المَقدونِيّين اللي كانو مْسافرين مع بولَس. ");
INSERT INTO arq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","حَب بولَس يْقابَل الشَعب بَصَّح التابعين ما خَلاّوَهش. ");
INSERT INTO arq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","شي ناس من المَسؤولين اللي في آسيا تاني كانو وَلاّو صْحابو، وبَعتولو يَطَّلبو منّو باش ما يْروحش للمَسرح. ");
INSERT INTO arq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","كاين اللي كانو يْعَيطو بحاجة، وواحَدُخرين بحاجة أخرى، خاطَر تْخَلَّط الغاشي وبَزّاف اللي ما كانوش عارفين عْلاش راهُم مَتلايمين. ");
INSERT INTO arq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","جَبدو من الغاشي سْكَندَر اللي كانو اليْهود يْطَبّعو فيه للقُدّام، ورَوَّشَلهُم سْكَندَر بيَدّو خاطَر كان حاب يَهدَر مع الشَعب، ");
INSERT INTO arq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","وكي عَرفوه باللي يْهودي، بْداو كامَل كيف كيف يْعَيّطو مُدّة ساعتين: \"كْبيرة هِيَ أرطاميس الأفسُسِيّين.\" ");
INSERT INTO arq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","هَدَّن كاتَب المْدينة الغاشي وقال: \"يا رْجال أفسُس، شْكون هُوَ اللي ما يَعرَفش باللي مْدينة أفسُس هِيَ عَسّاسة مَعبَد أرطاميس الإلَهة الكْبيرة والصَنَم اللي هْبَط من زَفس؟ ");
INSERT INTO arq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","على حْساب اللي ما كاش اللي يَنكُر هاد الشي، لازَم تَتهَدّنو وما تْديرو حَتّى حاجة بالزَربة، ");
INSERT INTO arq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","خاطَر جَبتو هاد الرْجال اللي ما سَرقو المْعابَد، ما سَبّو إلَهَتنا. ");
INSERT INTO arq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","وَلاّ كان عَند دِمِتريوس والصْنايعِيّة اللي معاه حاجة يَشتكيو عليها، كايَن يامات للشْرَع وحُكّام، يْروحو يَشتكيو من بَعضهُم بَعض. ");
INSERT INTO arq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","وَلاّ راكُم تْحَوّسو على حاجة أخرى، كُل شي يَفرا في جَلسة قانونِيّة. ");
INSERT INTO arq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","خاطَر دُرك، نَقَّدرو نْجوزو فالشْرَع على جال الهيلولة مْتاع اليوم وما عَندنا حَتّى سَبّة نْبَيّنو بيها عْلاش تْلايَمنا.\" ");
INSERT INTO arq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","وبَعد ما قال هَكدا، سَرَّح الغاشي. ");
INSERT INTO arq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","وكي تْهَدّنَت الحالة، عَيَّط بولَس للتابعين، سَجَّعهُم ووَدَّعهُم وحْكَم الطْريق لمَقدونية، ");
INSERT INTO arq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","وجاز على هَدوك الجْوايَه وهُوَ يْسَجَّع بكْلام بَزّاف، ووْصَل لليونان، ");
INSERT INTO arq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","وقْعَد فيها تَلت شْهور. وكي كان يْوجَّد في روحو باش يَقطَع البْحَر لسورِيّة، سْمَع باللي اليْهود دارولو فَخّة. هِمّالا، شاف باللي ياخُد الطْريق على مَقدونِيّة، ");
INSERT INTO arq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","وراحو معاه لآسيا سوباترُس بَن ِبِرُّس البيري وأرِستَرخوس وسُكوندُس من ناس تِسالونيكي، وغايوس الدَربي وتيموتاوَس وتيخيكَس وتْروفيمَس من آسيا. ");
INSERT INTO arq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","هَدو سَبقو وسْتَنّاونا في تَرواس، ");
INSERT INTO arq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","بَصَّح حْنا، قْطَعنا البْحَر بَعد يامات عيد الفْطير من فيليبّي ولْحَقناهُم لتَرواس بَعد خَمس أيّام وتَمّة جَوَّزنا سَبع أيّام. ");
INSERT INTO arq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","وفالنْهار الأوَّل مْتاع الجَمعة، كي كانو التابعين مَتلايمين باش يَقَّسمو الخُبز، هْدَر مْعاهُم بولَس وكان مْعَوَّل يْروح غَدوة من داك وطَوَّل معاهُم فالهَدرة حَتّى لنَص الليل. ");
INSERT INTO arq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","وكانو بَزّاف الكانكِيّات شاعلين فالبيت الفوقانِيّة اللي كُنّا مَتلايمين فيها، ");
INSERT INTO arq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","وكان واحَد المَصغَر واسمو أفتيخوس، قاعَد على الطاقة وطايَح عليه النْعاس، وكي طَوَّل بولَس فالهَدرة، غَلبو النْعاس وطاح من الطَبقة التالتة للتَحت ورَفدوه مِيَّت. ");
INSERT INTO arq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","هْبَط بولَس، وطابَس عليه وشَدّو بين دْراعتيه وقال: \"ما تَتحَيّروش، نَفسو مازالها فيه\". ");
INSERT INTO arq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","عاوَد طْلَع وقْسَم الخُبز وكْلا وهَدَر بَزّاف حَتّى للفْجَر، أومبَعد راح. ");
INSERT INTO arq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","جابو الوْلَد اللي طاح من الطاقة حَي وفَرَّحهُم هاد الشي بَزّاف. ");
INSERT INTO arq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","وحْنا سْبَقنا للبابور، وقَلَّعنا لأسّوس، مْعَوّلين نَدّيو بولَس معانا من تَمّة، خاطَر هَكدا تْفاهَم معانا وهُوَ راح يَمشي، ");
INSERT INTO arq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","وكي لْحَقنا لأسّوس، رْفَدناه ورَحنا لميتيليني. ");
INSERT INTO arq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ومن تَم، قْطَعنا البْحَر ولْحَقنا غَدوة من داك مْقابَل خِيّوس. فاليوم اللي بَعدو جَزنا على ساموس وفاليوم اللي من بَعد وْصَلنا لمالطا. ");
INSERT INTO arq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","عَوَّل بولَس يْجوز على أفسُس بْلا ما يَحبَس ويْضَيَّع الوَقت في آسيا، خاطَر كان يْغاوَل باش يْكون، وَلاّ قْدَر، في أورشَليم يوم الخَمسين. ");
INSERT INTO arq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ومن مالطا، بْعت بولَس يْعَيَّط لشْيوخ الكَنيسة، ");
INSERT INTO arq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","وكي وَصلو لعَندو، قالَلهُم: \"راكُم عارفين كيفاش كُنت معاكُم في كُل وَقت من اليوم الأولاني اللي حَطّيت فيه رَجلي في آسيا، ");
INSERT INTO arq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","نَخدَم فالرَب، وأنا مَتواضَع وبالدْموع والمحْايَن اللي صْراولي على جال الفْخَخ اللي داروهُملي اليْهود، ");
INSERT INTO arq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ما خَلّيت حَتّى حاجة تْفيد ما خَبَّرتكُمش بيها وعَلَّمتكُم عيناني وفي كُل دار، ");
INSERT INTO arq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","وشْهَدت لليْهود واليونانِيّين بالتوبة لله والإيمان برَبنا يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ودُرك راني رايَح لأورشَليم وأنا مَربوط بالروح، وماشي عارَف واش رايَح يَصرالي تَمّة، ");
INSERT INTO arq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","بَصَّح الروح القُدّوس، يَشهَدلي في كُل مْدينة ويْقول الحَبس والمْحايَن راهُم يَستَنّاو فِيَّ. ");
INSERT INTO arq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","بَصَّح أنا ما راني دايَر حْساب لحَتّى حاجة، ونَفسي ماراهيش غالية عَندي. هات بَرك نْكَمَّل الجري مْتاعي والخَدمة اللي كَلَّفني بيها الرَب يَسوع وهِيَ الشْهادة لإنجيل نَعمة الله. ");
INSERT INTO arq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","دُرك، راني عارَف باللي ما راكُمش رايحين تْزيدو تْشوفو وَجهي، أَنتومَ كامَل اللي جَزت في وَسطكُم وأنا نْبَرَّح بالمَلَكوت. ");
INSERT INTO arq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","وعلى هَدا، نْشَهَّدكُم اليوم باللي راني مْبَرّي من دَمكُم كامَل، ");
INSERT INTO arq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","خاطَر خَبَّرتكُم بكامَل مُراد الله بْلا ما نْخَبّي حاجة. ");
INSERT INTO arq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","رَدّو بالكُم على نْفوسكُم وعلى كامَل القْطيع اللي داركُم الروح القُدّوس مَسؤولين عليه، باش تَلَتهاو بكَنيسة الله اللي جابها بدَمّو. ");
INSERT INTO arq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","أنا راني عارَف باللي بَعدما نْروح، رايحين يَدُّخلو في وَسطكُم دْيوبة خَطّافين ما يَرَّحموش القْطيع، ");
INSERT INTO arq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ورايحين يَخُّرجو من وَسطكُم ناس يْعَلمو العْوَج باش يَجَّبدو التابعين ليهُم. ");
INSERT INTO arq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","على هَدا، رَدّو بالكُم وتْفَكّرو باللي مُدّة تَلت سْنين ما حْبَستش ليل ونْهار وأنا بالدْموع نْحَدَّر في كُل واحَد فيكُم. ");
INSERT INTO arq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ودُرك، نْخَلّيكُم يا خاوتي بين يَدّين الله وكَلمة نَعمتو، اللي قادرة تَبنيكُم وتَعطيلكُم وَرت مع كامَل القَدّيسين. ");
INSERT INTO arq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ما تْشَهّيت لا الفَضّة، لا الدَهَب وَلا اللَبسة مْتاع كاش واحَد، ");
INSERT INTO arq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","راكُم عارفين باللي هاد اليَدّين هومَ اللي خَدمو على الشي اللي نَسَّحقو أنا واللي معايَ، ");
INSERT INTO arq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","وفي كُل حاجة، بَيَّنتَلكُم باللي هَكدا لازَم تَتَّعبو وتْعاونو الڤْلالين، وتَتفَكّرو كْلام الرَب يَسوع اللي قال: \"سَعد اللي يْمَد كْتَر من سَعد اللي ياخُد.\"\" ");
INSERT INTO arq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","بَعد ما قال هاد الشي، رْكَع بولَس على رْكايبو وصَلاّ مْعاهُم كامَل، ");
INSERT INTO arq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","وكامَل بْكاو بَزّاف وهومَ مَرمِيّين على بولَس، يْعَنّقو ويْبوسو فيه، ");
INSERT INTO arq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","وكانو مَوجوعين بَزّاف، الكُترة على جال الكَلمة اللي قالها باللي ما يْزيدوش يْشوفو وَجهو. أومبَعد، وَصّلوه للبابور. ");
INSERT INTO arq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","وكي فارَقناهُم، قَلَّعنا ورُحنا قْبالة لكوس، وغَدوة من داك لرودَس ومن تَم لباتَرا، ");
INSERT INTO arq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","وكي لْقينا تَمّة بابور رايَح لفينيقِيّة، رْكَبنا فيه ورُحنا. ");
INSERT INTO arq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","بانَتَلنا قُبرُص، وخَلّيناها على اليسرى وكَمَّلنا طْريقنا لسورِيّة وحَبَّسنا صور خاطَر تَمّة اللي البابور يْفَرَّغ السَلعة مْتاعو. ");
INSERT INTO arq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","وكي لْقينا التابعين، قْعَدنا تَمّة سَبع أيّام. وكانو يْقولو لبولَس بالوَحي مْتاع الروح باش ما يَطلَعش لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","بَصَّح كي كَمَّلنا هَدوك اليامات، خْرَجنا باش نْكَمّلو طْريقنا، وهومَ كامَل وَصّلونا مع نْساهُم ووْلادهُم حَتّى لبَرّا من المْدينة، ورْكَعنا على شَط البْحَر وصَلّينا. ");
INSERT INTO arq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","أومبَعد، تْوادَعنا وطْلَعنا فالبابور وهومَ وَلاّو لدْيورهُم. ");
INSERT INTO arq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","كَمَّلنا الطْريق فالبْحَر، ورُحنا من صور لبُتولَمايَس، وسَلَّمنا على الخاوة تَمّة وجَوَّزنا معاهُم يوم واحَد. ");
INSERT INTO arq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","وغَدوة من داك، رُحنا لقَيصَرِيّة، ودْخَلنا لدار فيلِبُّس اللي يْبَشَّر، وكان هُوَ واحَد من السَبعة، وقْعَدنا عَندو، ");
INSERT INTO arq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","وكانو عَندو رَبع بْنات عْواتَق يَتنَبّأو. ");
INSERT INTO arq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","وكي بْقينا عَندو يامات بَزّاف، واحَد النَبي واسمو أغابوس هْبَط من اليَهودِيّة، ");
INSERT INTO arq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","وجا لعَندنا. شَد الحْزام مْتاع بولَس ورْبَط رَجليه ويَدّيه وقال: \"هاو واش يْقول الروح القُدّوس، مولى هاد الحْزام، هَكدا رايحين يَرَّبطوه اليْهود في أورشَليم ويْسَلّموه ليَدّين الكُفّار\". ");
INSERT INTO arq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","وكي سْمَعنا هاد الشي، حْنا والناس اللي من هَداك المَدرَب، طْلَبنا من بولَس باش ما يَطلَعش لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","وواجَب بولَس: \"واش راكُم تْديرو وأنتومَ تَبكيو وتَقَّسمولي في قَلبي؟ أنا، راني واجَد ماشي غير باش نَتكَتَّف بَرك، نْزيد نْموت في أورشَليم على جال آسَم الرَب يَسوع\". ");
INSERT INTO arq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","وكي ما تْقَنَّعش، سْكَتنا وقُلنا: \"مُراد الرَب هُوَ اللي يْكون.\" ");
INSERT INTO arq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","بَعد هَدوك اليامات، وَجَّدنا روحنا وطْلَعنا لأورشَليم، ");
INSERT INTO arq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","وجاو مْعانا تاني واحَد التابعين من قَيصَريّة وأدّاونا عَند مناسون القُبرُصي، واحَد التابَع قْديم، باش نُقَّعدو عَندو. ");
INSERT INTO arq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","وكي وْصَلنا لأورشَليم، سْتَقبلونا الخاوة بالفَرحة، ");
INSERT INTO arq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","وغَدوة من داك، راح مْعانا بولَس عَند يَعقوب وحَضرو كامَل الشْيوخ. ");
INSERT INTO arq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","وبَعد ما سَلَّم عليهُم، بْدا يْخَبَّر فيهُم حاجة بحاجة على كل واش دار الله بين اللي ماشي يْهود على يَدّو. ");
INSERT INTO arq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","وكي سَمعولو، سَبحو الله وقالولو: \"راك تْشوف يا خونا شْحال من آلَف ماليْهود اللي آمنو، وهومَ كامَل يْغيرو على الشَريعة، ");
INSERT INTO arq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","وراهُم سَمعو عليك باللي راك تْعَلَّم كامَل اليْهود اللي راهُم عايشين في وَسط اللي ماشي يْهود باش يُخُّرجو على طْريق موسى وتْقولَلهُم ما يْخَتّنوش وْلادهُم وما يَمشيوش على حْساب العْوايَد. ");
INSERT INTO arq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","واش نْديرو هِمّالا؟ بْلا شَك رايَحين يَسَّمعو باللي راك هْنا. ");
INSERT INTO arq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","هِمّالا دير واش نْقولولَك، عَندنا رْبَع رْجال عليهُم عَهَد، ");
INSERT INTO arq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","أَدّيهُم معاك، وطَهَّر روحَك معاهُم وخَلَّصَلهُم باش يْحَفّفو شْعَرهُم، وهَكدا كامَل يَعَّرفو باللي الشي اللي سَمعوه عليك ماشي صَح وباللي أنتَ تاني راك تَمشي على حْساب الشَريعة. ");
INSERT INTO arq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ومن جيهة، اللي ماشي يْهود اللي آمنو، رانا بْعَتنالهُم حْنايا بْريّة بالشي اللي حْكَمنا بيه: ما يَتدَنّاوش للْحَم المَدبوح للأصنام والدَم والجيفة والفَسق.\" ");
INSERT INTO arq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","هِمّالا، أدّا بولَس هَدوك الرْجال غَدوة من داك، وطَهَّر روحو معاهُم ودْخَل للمَعبَد باش يْسَجَّل وَقتاش يْخلاصو يامات التَطهير وتَتمَد تَقدِمة كل واحَد. ");
INSERT INTO arq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","وكي قَرّبو يَخلاصو السَبع أيّام، شافوه اليْهود مْتاع آسيا فالمَعبَد، وحَرّشو الغاشي وحَكموه، ");
INSERT INTO arq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","وهومَ يْعَيّطو: \"يا رْجال إسرائيل، عاونونا، هَدا هُوَ الراجَل اللي راهو يْعَلَّم الناس كامَل في كُل مَدرَب ضَد الشَعب، ضَد الشَريعة وضَد هاد المْكان، وزاد دَخَّل اليونانيّين للمَعبَد ونَجَّس هاد المْكان المْقَدَّس.\" ");
INSERT INTO arq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","خاطَر كانو شافو معاه فالمْدينة تْروفيمَس الأفسُسي وحَسبو باللي بولَس دَخّلو للمَعبَد. ");
INSERT INTO arq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","هاجَت المْدينة كامَل، وتْلَم الشَعب وحَكمو بولَس وخَرّجوه وهومَ يْكَركرو فيه مالمَعبَد وتَم تَم غَلقو البيبان مْتاع المَعبَد، ");
INSERT INTO arq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","وكي كانو حابّين يَقُّتلوه، وْصَل الخْبَر لقايَد الكَتيبة باللي أورشَليم كامَل تْهَوّلَت. ");
INSERT INTO arq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","تَم تَم، أدّا العَسكَر وقيّاد المْية وراح يَجري ليهُم، وكي شافو اليْهود القايَد والعَسكَر، حَبسو يَضَّربو في بولَس. ");
INSERT INTO arq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","هِمّالا، قَرَّب القايَد الألف وحَكمو وآمَر باش يَرَّبطوه بزوج سْناسَل وبْدا يْسَقسي عليه واش يْكون وواش دار. ");
INSERT INTO arq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","بَصَّح الغاشي، شْويّة كان يْعَيَّط يْقول حاجة وشْويّة حاجة أخرى، وكي ما قْدَرش يَعرَف الصَح على جال الشَقلالة، آمَر باش يَدّيوَه لبُرج العَسكَر. ");
INSERT INTO arq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","وكي وْصَل بولَس للدْروج، كان لازَم يَرَّفدوه العَسكَر على جال قْباحة الغاشي، ");
INSERT INTO arq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","خاطَر الشَعب كان يْتَبَّع فيه ويْقول: \"أقُّتلوه\". ");
INSERT INTO arq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","وكي كان بولَس قْريب يَدخُل لبُرج العَسكَر، قال لقايَد الألف: \"نَقدَر نْقولَك حاجة؟\" قاللو القايَد: \"تَعرَف اليونانيّة؟ ");
INSERT INTO arq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","هِمّالا، ماشي أنتَ هَداك المَصري اللي دار الهول فاليامات اللي فاتو وأدّا للخْلا رَبع آلاف راجَل مالقَتّالين؟\" ");
INSERT INTO arq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","قال بولَس: \"أنا راجَل يْهودي، طَرسوسي من مْدينة ماشي مَهيونة في كليكيّة. أَسمَحلي مَن فَضلَك نَهدَر مع الشَعب.\" ");
INSERT INTO arq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","كي سْمَحلو القايَد، وْقَف بولَس عالدْروج ورَوَّش بيَدّو للشَعب. طاح سْكات كْبير وهْدَر بولَس باللُغة العِبريّة وقال: ");
INSERT INTO arq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","\"يا الخاوة ويا الوالدين، أسَّمعو للشي اللي رايَح نْقولهولكُم دُرك باش نْدافَع على نَفسي\"، ");
INSERT INTO arq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","كي سَمعوه يَهدَر معاهُم باللُغة العِبريّة، زادو سَكتو وقال: ");
INSERT INTO arq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","\"أنا يْهودي، زَدت في طَرسوس، في كيليكيّة، وكْبَرت في هاد المْدينة، وتْرَبّيت عَند غَمالائيل اللي عَلَّمني مْليح شَريعة والدينا، وكُنت نْغير لله كيما راكُم أنتومَ كامَل اليوم، ");
INSERT INTO arq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","وشْحَنت على هاد الطْريق حَتّى للموت، وأنا نْسَنسَل ونَدّي للحْباس رْجال ونْسا، ");
INSERT INTO arq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","رايَس رْجال الدين ومَجلَس الشْيوخ تاني يَشَّهدولي. أَدّيت من عَندهُم بْراوات ضَد الخاوة مْتاع دِمَشق، وين رُحت باش نْجيب كامَل اللي نَلقاهُم تَمّة مْكَتّفين لأورشَليم ونْعاقَبهُم، ");
INSERT INTO arq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","وكي كُنت فالطْريق، قْريب نَلحَق لدِمَشق، تَم تَم وفي وَسط النْهار، بْرَق سايَر دايَر عليَّ ضو كْبير مالسْما، ");
INSERT INTO arq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","طَحت فالأرض، وسْمَعت صوت يْقوللي: \"شاوَل، شاوَل، عْلاش راك شاحَن عليَّ؟\" ");
INSERT INTO arq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","جاوَبتو: \"شْكون أنتَ يا رَب؟\" قاللي: \"أنا يَسوع الناصري اللي راك شاحَن عليه\" ");
INSERT INTO arq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","اللي كانو معايَ، شافو الضو بَصَّح ما سَمعوش صوت اللي كان يَهدَر معايَ. ");
INSERT INTO arq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","وقُلت: \"واش لازَم نْدير يا رَب؟\" قاللي الرَب: \"نوض وروح لدِمَشق وتَمّة يْقولولَك كامَل واش لازَم تْدير.\" ");
INSERT INTO arq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ووَلّيت ما نْشوفش على جال الشوع مْتاع الضو، حَتّى اللي كانو معايَ ڤَوّدوني من يَدّي ووَصلوني لدِمَشق. ");
INSERT INTO arq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","وواحَد واسمو حَنانِيّا، راجَل تَقي على حْساب الشَريعة، وكامَل اليْهود اللي ساكنين تَمّة، يَشَّهدولو بالخير، ");
INSERT INTO arq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","جا لِيَّ وقاللي: \"شاوَل خويَ، شوف\". في ديك الساعة رَجعَتلي الشوفة وشَفت فيه، ");
INSERT INTO arq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","وقاللي: \"إلَه جْدودنا خَيّرَك من قْبَل باش تَعرَف مُرادو وتْشوف الصالَح وتَسمَع كْلام من فَمّو، ");
INSERT INTO arq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","خاطَر رايَح تْكون شاهَد ليه قُدّام كامَل الناس على واش شَفت وسْمَعت. ");
INSERT INTO arq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ودُرك وَعلاش تْعَطَّل؟ نوض وأتعَمَّد وأغسَل روحَك من دْنوبَك وأنتَ تَدكُر في آسَم الرَب\". ");
INSERT INTO arq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","كي وَلّيت لأورشَليم، كُنت نْصَلّي فالمَعبَد حَتّى غَيَّبت، ");
INSERT INTO arq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","وشَفت الرَب يْقوللي: \"غاوَل، وأخرُج بالخَف من أورشَليم خاطَر ما راهُمش رايحين يَقَّبلو شْهادتَك ليَّ\"، ");
INSERT INTO arq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","قُلت: \"يا رَب، راهُم عارفين باللي كُنت نْدَخَّل للحَبس ونْعاقَب بالقْساوة اللي يامنو بيك في كامَل المْجامَع، ");
INSERT INTO arq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","وكي سال دَم سْتِفانوس الشَهيد مْتاعك، كُنت أنا واقَف وراضي على قْتيلتو وعَسّيت الحْوايَج مْتاع اللي قَتلوه\"، ");
INSERT INTO arq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","وقاللي: \"روح، راني نَبَّعتَك بْعيد للأُمّات\". ");
INSERT INTO arq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","سَمعولو حَتَّى لهاد الكَلمة، أومبَعد طَلّعو صوتهُم وهومَ يْقولو: \"نَحّيو هاد الإنسان من الأَرض، خاطَر ما يَستاهَلش يْعيش\"، ");
INSERT INTO arq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","وبْداو يْعَيّطو ويَرميو في حْوايَجهُم ويَطَّلقو الغْبار فالهْوا. ");
INSERT INTO arq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","آمَر قايَد الأَلف باش يْدَخّلو بولَس لبُرج العَسكَر ويَبَّحتوه بالضَرب باش يَعرَف واش من السَبَّة كانو يْعَيّطو عليه هَكدا. ");
INSERT INTO arq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","كي كَتّفوه العَسكَر باش يَجَّلدوه، قال بولَس لقايَد المْية اللي كان واقَف قُدّامو: \"يْجوزَلكُم تَجَّلدو إنسان روماني قْبَل ما يْجوز فالشْرَع؟\" ");
INSERT INTO arq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","كي سْمَع قايَد المْية هاد الكْلام، راح للقايَد الكْبير وخَبّرو وقال: \"واش رايَح تْدير؟ هاد الراجَل روماني\"، ");
INSERT INTO arq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","راح قايَد الأَلف لبولَس وسَقساه: \"قوللي، أنتَ روماني؟\" جاوَب بولَس: \"إيه\"، ");
INSERT INTO arq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","وقال قايَد الأَلف: \"أنا خَلَّصت دْراهَم كْبار باش كْسَبت هاد الجَنسِيّة\"، قال بولَس: \"وأنا زَدت بيها\". ");
INSERT INTO arq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","تَم تَم، اللي كانو رايحين يَبَّحتوه جَبدو روحهُم، وخاف قايَد الأَلف كي عْرَف باللي بولَس روماني وكي آمَر باش يْكَتّفوه. ");
INSERT INTO arq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","غَدوة من داك، حَبّ يَتحَقَّق على واش كانو اليْهود يَتَّهمو في بولَس، وطْلَب يْنَحّيولو السْناسَل وآمَر رِيّاس رْجال الدين والمَجلَس الديني باش يَتلايمو وهَبَّط بولَس باش يَوقَف في وَسطهُم. ");
INSERT INTO arq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","وخْزَر بولَس فالمَجلَس الديني وقال: \"يا الخاوة، حَتّى لليوم مْشيت بضَمير مْهَنّي قُدّام الله\"، ");
INSERT INTO arq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","رايَس رْجال الدين حَنانِيّا آمَر اللي كانو واقفين قُدّام بولَس باش يَضَّربوه على فَمّو. ");
INSERT INTO arq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","داك الساع، قاللو بولَس: \"الله يَضَّربَك يا الصور المْبَيَّض، راك قاعَد باش تْشارَعني على حْساب الشَريعة وأنتَ تْخالَف الشَريعة كونَك تآمَر باش يَضَّربوني؟\" ");
INSERT INTO arq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","اللي كانو حاضرين قالو: \"تْسَب رايَس رْجال دين الله؟\" ");
INSERT INTO arq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","قال بولَس: \"ما كُنتش عارَف يا الخاوة باللي هُوَ رايَس رْجال الدين، خاطَر مَكتوب: \"ما تْقولش كْلام دوني على رايَس شَعبَك\". ");
INSERT INTO arq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","وكي عْرَف بولَس باللي شْوِيّة من المَجلَس صَدوقِيّين والأُخرين فَرّيسِيّين، عَيَّط فالمَجلَس الديني: \"يا الخاوة، أنا فَرّيسي وْليد فَرّيسي، راني نَتشارَع على جال رْجايَ فالقِيامة من الموت\"، ");
INSERT INTO arq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","كي قال هاد الشي، ناضَت الشَقلالة بين الفَرّيسِيّين والصَدّوقِيّين ونْقَسمَت الجْماعة، ");
INSERT INTO arq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","خاطَر الصَدّوقِيّين يْقولو باللي ما كان لا قِيامة، لا مْلاك ولا روح بَصَّح الفَرّيسِيّين يامنو بهَداك الشي كامَل. ");
INSERT INTO arq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","قْوا العْياط وشي كُتّاب من اللي تابعين للفَرّيسِيّين ناضو وبْداو يْغالبو بالحْرارة وقالو: \"ما لْقينا حَتّى حاجة دونِيّة في هاد الراجَل، بَلاك هْدَر معاه روح وَلاّ مْلاك؟\" ");
INSERT INTO arq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","كي بْدات الشَقلالة تَكتَر، خاف قايَد الأَلف يْعودو هَدوك الناس يْقَطّعو بولَس طْراف طْراف، وآمَر العَسكَر باش يَهَّبطو يَخَّطفوه من يَدّهُم ويَدّيوَه لبُرج العَسكَر. ");
INSERT INTO arq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","الليلة اللي مَن بَعد، وْقَف الرَبّ لبولَس وقال: \"أَتسَجَّع، خاطَر كيما شْهَدتلي في أورشَليم، لازَم تْزيد تَشهَدلي في روما\". ");
INSERT INTO arq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","كي طْلَع النْهار، تْفاهمو شي يْهود وحَرّمو على روحهُم الماكلة والشْراب حَتّى يَقُّتلو بولَس، ");
INSERT INTO arq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","واللي تْفاهمو على هاد الشي كانو كْتَر من رَبعين، ");
INSERT INTO arq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","وراحو لرِيّاس رْجال الدين والشْيوخ وقالو: \"حَرَّمنا على روحنا الماكلة والشْراب حَتّى نَقُّتلو بولَس، ");
INSERT INTO arq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","هِمّالا، أَطَّلبو أنتومَ والمَجلَس الديني من قايَد المْية باش يْجيبَلكُم بولَس كي شْغُل باش تْزيدو تَبَّحتوه كْتَر، وحْنا رانا واجدين باش نَقُّتلوه قْبَل ما يْقَرَّب اللَهنا\". ");
INSERT INTO arq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","كي سْمَع وْليد خُت بولَس بالفَخّة، راح لبُرج العَسكَر وخَبَّر بولَس. ");
INSERT INTO arq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","عَيَّط بولَس لواحَد من قِيّاد المْية وقال: \"أَدّي هاد المَصغَر لقايَد الأَلف خاطَر عَندو حاجة يْخَبّرو بيها\". ");
INSERT INTO arq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","أَدّا المَصغَر ووَصّلو لقايَد الأَلف وقال: \"عَيَّطلي المَحبوس بولَس وطْلَب مَنّي نْجيبلَك هاد المَصغَر خاطَر عَندو حاجة يْقولهالَك\". ");
INSERT INTO arq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","شَد قايَد الأَلف المَصغَر من يَدّو، وجَبدو وَحدو على جيهة وسَقساه: \"واش حَبّيت تْخَبَّرني؟\" ");
INSERT INTO arq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","قال: \"اليْهود تْفاهمو يَطَّلبو مَنَّك تْهَبَّط بولَس غدوة للمَجلَس الديني كي شْغُل رايَح يْجوز فالبَحت كْتَر، ");
INSERT INTO arq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ما تَقبَلش، خاطَر كْتَر من رَبعين واحَد مَنهُم دارولو فَخّة وحَرّمو نْفوسهُم من الماكلة والشْراب حَتّى يَقُّتلوه ودُرك راهُم واجدين ويَستَنّاو غير باش تَقبَل.\" ");
INSERT INTO arq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","طْلَق قايَد الأَلف هَداك المَصغَر ووَصّاه: \"ما تْقول لحَتّى واحَد باللي راك عْلَمتني بهاد الشي\"، ");
INSERT INTO arq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","أومبَعد، عَيَّط لزوج من قِيّاد المْية وقال: \"وَجّدو من التَسعة مْتاع الليل ميتين عَسَّكري وسَبعين فارَس وميتين قُوّاس باش يْروحو لقَيصَريّة، ");
INSERT INTO arq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ووَجّدو زْوايَل باش تْرَكّبو بولَس وتْوَصّلوه بخير للوالي فيلِكس\"، ");
INSERT INTO arq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","وكْتَب بْريّة، هاو واش فيها: ");
INSERT INTO arq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","\"كْلوديوس ليسياس للعْزيز فيلِكس الوالي، سَلام: ");
INSERT INTO arq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","هاد الراجَل، حَكموه اليْهود وكانو مْعَوّلين يَقُّتلوه كي وْصَلت أنا مع العَسكَر وسَلَّكتو خاطَر عْرفت باللي هُوَ روماني، ");
INSERT INTO arq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","حَبّيب نَعرَف واش من السَبّة اللي تَهموه وهَبَّطتو للمَجلَس الديني مْتاعهُم، ");
INSERT INTO arq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","وتْبَيَّنلي باللي كان مَتهوم على جال حاجات مْتاع شَريعَتهُم، بَصَّح ما دار حَتّى شي يَستاهَل عليه الموت وَلاّ الحَبس. ");
INSERT INTO arq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","أومبَعد، كي عْرَفت باللي اليْهود دارولو فَخّة، بْعَتتهولَك تَم تَم وآمَرت اللي شْتكاو بيه يْجيو يَشتكيو بيه عَندَك.\" ");
INSERT INTO arq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","العَسكَر أَدّاو بولَس على حْساب الآمَر اللي جاهُم وراحو بيه فالليل لأَنتيباتريس. ");
INSERT INTO arq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","وغَدوة من داك، خَلاّو الفَرسان يْكَمّلو الطْريق مع بولَس ووَلاّو لبُرج العَسكَر، ");
INSERT INTO arq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","وكي وَصلو لقَيصَريّة، مَدّو الفَرسان البْرِيّة للوالي وسَلمولو بولَس. ");
INSERT INTO arq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","الوالي بَعد ما قْرا البْرِيّة، سَقسا من واش من الوِلاية بولَس، وكي عَرفو باللي من كيليكِيّة، ");
INSERT INTO arq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","قاللو: \"راني نَسمَعلَك كي يْجيو اللي شْتكاو بيك\"، وآمَر باش يَدّيو بولَس لقْصَر هيرودَس. ");
INSERT INTO arq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","بَعد خَمس أَيّام، هْبَط حَنانِيّا رايَس رْجال الدين مع الشْيوخ وواحَد المُحامي واسمو تَرتُلُّس وشْتكاو ببولَس عَند الوالي. ");
INSERT INTO arq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","عَيّطو لبولَس وبْدا تَرتُلُّس يَتهَم فيه ويْقول: \"الآمان الكْبير اللي رانا فيه بيك، والحاجات اللي تْبَدّلو للفايدة مْتاع هاد الأُمّة بالتَدبير مْتاعك، ");
INSERT INTO arq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","يا العْزيز فيلِكس، نَقَّبلوهُم وحْنا شاكرين في كُل زْمان وكُل مْكان، ");
INSERT INTO arq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","بَصَّح، باش ما نْطَوَّلش عليك، نَترَجّاك تَسمَع بخاطرَك الواسَع واش رانا حابّين نْقولولَك بالخَف. ");
INSERT INTO arq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","عْرَفنا باللي هاد الراجَل يْضَر ويْدير الفْراق بين كامَل اليْهود اللي فالأَرض، وهُوَ رايَس بَدعة الناصرِيّين، ");
INSERT INTO arq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","وكي لْحَق باش يْزيد يْنَجَّس المَعبَد، حْكَمناه. ");
INSERT INTO arq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","وأنتَ تَقدَر تَبَّحتو وتَعرَف مَنّو كامَل الشي اللي نَشتكيو بيه مَنّو\". ");
INSERT INTO arq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","اليْهود تاني جاو في صَف اللي كان يَتهَم في بولَس وقالو باللي هاد الشي صَح صْرا هَكداك. ");
INSERT INTO arq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","شَر الحاكَم لبولَس باش يَهدَر وقال بولَس: \"عْرَفت باللي من عْوام بَزّاف وأنتَ قاضي في هاد الأُمّة، على هَدا رايَح نْدافَع على نَفسي وأنا مْهَنّي، ");
INSERT INTO arq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","وأنتَ تَقدَر تَتحَقَّق باللي ما عَنديش كْتَر من طْناشَن يوم من اللي طْلَعت لأورشَليم باش نَعبَد، ");
INSERT INTO arq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ما شافوني لا فالمَعبَد، لا فالمْجامَع وَلا فالمْدينة نْناقَش في كاش واحَد وَلاّ نْلَم فالغاشي باش نْدير الهول، ");
INSERT INTO arq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","وما يَقَّدروش يْجيبو التْبوت على الشي اللي راهُم يَتَّهموني بيه. ");
INSERT INTO arq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","نَستَعرَفلَك بهاد الشي، نَعبَد إلَه جْدودنا على حْساب الطْريق اللي يْقولولها بَدعة ونامَن بكامَل واش مَكتوب فالشَريعة وكْتوب الأنبيا، ");
INSERT INTO arq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","وعَندي رْجايَ فالله كيما عَندهُم هومَ تاني، باللي تْكون قِيامة للصالحين والخاطيين. ");
INSERT INTO arq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","على هَدا، نْدير مَجهودي أنا تاني باش يْكون ضَميري دايمًا صافي قُدّام الله والناس. ");
INSERT INTO arq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","بَعد سْنين بَزّاف، جيت نْمَد صَدقة وتَقدِمات للشَعب مْتاعي، ");
INSERT INTO arq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","هَكدا اللي لْقاوني مَتطَهَّر فالمَعبَد، بلا غاشي وَلا هول، ");
INSERT INTO arq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","شي يْهود مْتاع آسيا وهومَ اللي لازَم يَوَّقفو قُدّامَك يَشتكيو بيَّ وَلاّ عَندهُم حاجة ضَدّي. ");
INSERT INTO arq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","وَلاّ ما كاش، يْقولو هَدو بالدات، واش من الفَعل الدوني اللي لْقاوَه فِيَّ كي وْقَفت قُدّام المَجلَس الديني، ");
INSERT INTO arq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","غير وَلاّ كان على جال الكْلام اللي سَغت بيه في وَسطهُم: \"على جال قِيامة الموتى اللي راني اليوم نَتشارَع قُدّامكُم؟\" ");
INSERT INTO arq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","فيلِكس اللي كان يَعرَف مْليح الشي اللي يْخُص هاد الطْريق، عَطَّلهُم وقال: \"كي يْجي قايَد الأَلف ليسياس، نَبحَت في دَعوَتكُم\"، ");
INSERT INTO arq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","وآمَر قايَد المْية باش يْديرو العَسّة على بولَس ويْسَهّلولو وما يَمَّنعو حَتّى واحَد من صْحابو باش يَخَّدمو. ");
INSERT INTO arq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","بَعد يامات، جا فيلِكس مع دْروسِلاّ مَرتو، اللي كانَت يْهوديّة وبْعَت يْجيب بولَس وسْمَع مَنّو على الإيمان بالمَسيح، ");
INSERT INTO arq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","بَصَّح كي كان بولَس يَهدَر على الصْلاح، وباللي واحَد لازَم يَتحَكَّم في نَفسو وعلى الحْساب مْتاع الله اللي جاي، خاف فيلِكس وقال لبولَس: \"روح دُرك وكي نَلقا الوَقت، نْعاوَد نْعَيَّطلَك\". ");
INSERT INTO arq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ومن جيهة أخرى، كان فيلِكس مَتمَنّي لو كان بولَس يَعطيلو الدْراهَم باش يطلقو، وعلى هَدا كان مَنّا اللَهنا يَبعَت يْجيبو ويَهدَر معاه. ");
INSERT INTO arq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","جازو عامين هَكدا، وخْلَف فيلِكس بوركيوس فَستوس. وباش يْرَضّي اليْهود، خَلاّ فيلِكس بولَس فالحَبس. ");
INSERT INTO arq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","بَعد تَلت أَيّام من اللي جا فَستوس للوِلاية، طْلَع من قَيصَريّة لأورشَليم. ");
INSERT INTO arq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","رِيّاس رْجال الدين والكْبار مْتاع اليْهود جاو يَشتكيو ضَد بولَس، وطَلبو مَنّو ");
INSERT INTO arq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","وحَلّلوه باش يْدير فيهُم مْزِيّة ويْجيب بولَس لأورشَليم خاطَر كانو مْوَجّدينلو فَخّة باش يَقُّتلوه فالطْريق. ");
INSERT INTO arq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","جاوَبهُم فَستوس باللي بولَس راهو تَحت العَسّة في قَيصَريّة وباللي هُوَ بالدات راهو قْريب يْروح لتَمّة، ");
INSERT INTO arq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","وقال: \"يَهَّبطو مْعايَ الكْبار منكُم وَلاّ كان في هاد الراجَل حاجة دونِيّة، يَشتكيو بيه.\" ");
INSERT INTO arq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","قْعَد فَستوس في أورشَليم مُدّة ما تْزيدش على تْمَنية وَلاّ عَشر أيّام، أومبَعد هْبَط لقَيصَريّة وغَدوة من داك، قْعَد على كُرسي الحُكم مْتاعو وآمَر باش يْجيبو بولَس. ");
INSERT INTO arq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","كي وْصَل، دارو بيه اليْهود اللي هَبطو من أورشَليم، وتَهموه بحاجات بَزّاف وكْبار ما يَقَّدروش يْجيبو عليهُم التْبوت. ");
INSERT INTO arq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","بْدا بولَس يْدافَع على نَفسو وقال: \"ما غْلَطت في حَتّى شي، لا في حَق شَريعة اليْهود، لا في حَق المَعبَد وَلاَ في حَق قَيصَر.\" ");
INSERT INTO arq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","فَستوس، باش يْرَضّي اليْهود، جاوَب بولَس وقال: \"تْحَب تَطلَع لأورشَليم تَتشارَع قُدّامي على هاد الحاجات؟\" ");
INSERT INTO arq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","جاوَب بولَس: \"أنا راني واقَف في دار الشْرَع مْتاع قَيصَر، وين لازَم نْجوز فالشْرَع. راك عارَف مْليح أنتَ تاني باللي ما ضْلَمت اليْهود في حَتّى حاجة، ");
INSERT INTO arq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","خاطَر، وَلاّ ضْلَمت وَلاّ دَرت حاجة نَستاهَل عليها الموت، ما نَهرَبش من الموت، بَصَّح وَلاّ الشي اللي تَهموني بيه كْدَب، حَتّى واحَد ما عَندو الحَق باش يْسَلَّمني ليهُم، نَطلَب نْجوز فالشْرَع قُدّام قَيصَر.\" ");
INSERT INTO arq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","فَستوس، بَعد ما شاوَر المُستَشارين اللي معاه، جاوَب: \"طْلَبت الشْرَع عَند قَيصَر، تْروح لقَيصَر.\" ");
INSERT INTO arq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","يامات من بَعد، جا السَلطان أغريباس وبَرنيكي لقَيصَرِيّة باش يْسَلّمو على فَستوس. ");
INSERT INTO arq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","كي بْقاو تَمّة يامات بَزّاف، هْدَر فَستوس للسَلطان على دَعوة بولَس وقال: \"فيلِكس خَلاّ واحَد الراجَل مَحبوس هْنا، ");
INSERT INTO arq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","وكي كُنت في أورشَليم، شْتكاولي بيه رِيّاس رْجال الدين وشْيوخ اليْهود وطَلبو مَنّي نَحكُم عليه. ");
INSERT INTO arq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","جاوَبتهُم باللي ماشي من عادة الرومان باش يَحَّكمو على واحَد قْبَل ما يْقابَل اللي شْتكاو بيه ويَقدَر يْدافَع على نَفسو من الشي اللي راهو مَتهوم بيه، ");
INSERT INTO arq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","وكي جاو اللَهنا، قْعَدت بْلا ما نْعَطَّل غَدوة من داك على كُرسي الحُكم وآمَرت باش يْجيبو هاد الراجَل، ");
INSERT INTO arq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","وكي قابلوه اللي شْتكاو بيه، ما قالو عليه حَتّى شي من اللي كان في بالي، ");
INSERT INTO arq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","كانو يْلومو فيه على حاجات مْتاع الدين مْتاعهُم وعلى واحَد الراجَل واسمو يَسوع، مات وكان بولَس يْقول باللي راهو حَي. ");
INSERT INTO arq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","وكي حَرت واش نْدير في هاد الدَعوة، سَقسيتو وَلاّ يْحب يْروح لأورشَليم ويْجوز تَمّة فالشْرَع على هاد الحاجات، ");
INSERT INTO arq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","بَصَّح بولَس كي طْلَب باش تْجوز دَعَّوتو عَند الإمبراطور، آمَرت باش تَندار عليه العَسّة حَتَّى نَبَّعتو لقَيصَر.\" ");
INSERT INTO arq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","قال أغريباس لفَستوس: \"راني حاب أنا تاني نَسمَع هاد الراجَل\"، جاوبو فَستوس: \"غَدوة تَسَّمعو.\" ");
INSERT INTO arq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","غَدوة من داك هِمّالا، جا أغريباس وبَرنيكي في حَطّة كْبيرة، ودَخلو لدار الشْرَع ومعاهُم قِيّاد الأَلف وكْبار المْدينة وآمَر فَستوس باش يْجيبو بولَس. ");
INSERT INTO arq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","قال فَستوس: \"السَلطان أغريباس، وكامَل اللي حاضرين معاكُم، راكُم تْشوفو هاد الراجَل اللي طَلبوني عليه كامَل اليْهود في أورشَليم وهْنايَ وهومَ يْعَيّطو باللي ما لازَمش يْزيد يْعيش، ");
INSERT INTO arq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","أنايَ، كي شَفت باللي ما دار حَتّى حاجة يَستاهَل عليها الموت وهُوَ زاد طْلَب باش تْجوز دَعَّوتو للإمبراطور، عَوَّلت نَبَّعتو، ");
INSERT INTO arq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","بَصَّح ما عَندي حَتّى حاجة باينة نَكتَبها عليه للقَيصَر. على هَدا جَبتهولكُم، وبخْصاص ليك أنتَ يا سَلطان أغريباس باش نَلقا واش نَكتَب بَعد ما يْجوز فالبَحت، ");
INSERT INTO arq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","خاطَر، نْشوف باللي ما جاتتش لو كان نَبعَت مَحبوس بلا ما نْبَيَّن باش راهو مَتهوم\". ");
INSERT INTO arq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","قال أغريباس لبولَس: \"مَسموحلَك تَهدَر باش تْدافَع على روحَك\". داك الوَقت، رْفَد بولَس يَدّو وبْدا يْدافَع على نَفسو: ");
INSERT INTO arq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","\"السَلطان أغريباس، راني فَرحان اليوم اللي راني نْدافَع على روحي قُدّامَك من كامَل الحاجات اللي تَهموني بيهُم اليْهود، ");
INSERT INTO arq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","خاطَر أنتَ تَعرَف مْليح كامَل عْوايَد اليْهود والحاجات اللي يَهَّدرو فيهُم، وعلى هَدا نَطلَب مَنَّك تَسمَعني بتَسِعة الخاطَر. ");
INSERT INTO arq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","كامَل اليْهود يَعَّرفو كيفاش كانَت حْياتي من بْداية صُغري في وَسط أُمتي وفي أورشَليم، ");
INSERT INTO arq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","راهُم عارفين من زْمان، وَلاّ حَبّو يْستَعرفو، باللي عَشت فَرّيسي على حْساب المَدهَب المَتشَدَّد كامَل فالدين مْتاعنا، ");
INSERT INTO arq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ودُرك، راني نْجوز فالشْرَع على جال رْجايَ فالوَعد اللي وْعَد الله بيه جْدودنا، ");
INSERT INTO arq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","واللي عْشايَرنا في طْناش راهُم يَرجاو يَوَّصلولو وهومَ دايرين كامَل مَجهودهُم عابدين الله ليل ونْهار. على جال هاد الرْجا يا سَلطان اللي راني مَتهوم من عَند اليْهود. ");
INSERT INTO arq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","بانَتَّلكُم حاجة ما تتّامَنش باللي الله يَحيي الموتى؟ ");
INSERT INTO arq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","أنا، كُنت شايَف باللي لازَم نْدير حاجات شينين ضَد آسَم يَسوع الناصري، ");
INSERT INTO arq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","وهَدا واش دَرت في أورشَليم، رْميت فالحَبس بَزّاف من القَدّيسين كي جَبت التَسريح من عَند رْجال الدين اللي يَعطيني الحَق في هاد الشي، وكي كانو يَحَّكمو عليهُم باللي يَقٌّتلوهُم، كُنت أنا نَدعَم هاد الشي. ");
INSERT INTO arq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","شْحال عاقَبتهُم في كامَل المْجامَع وكُنت نْحَتَّم عليهُم يَكُّفرو، وعلى حْساب حُقدي الزايَد عليهُم، كُنت نْتَبَّعهُم حَتّى للمْدايَن اللي خارَج البْلاد. ");
INSERT INTO arq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","على جال هاد الشي اللي أدّيت التَسريح والوْكالة من عَند رِيّاس رْجال الدين ورُحت لدِمَشق. ");
INSERT INTO arq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","في نَص النْهار، يا سَلطان، شَفت فالطْريق ضو من السْما قْوي على الشوع مْتاع الشَمس، بْرَق سايَر دايَر علينا أنا واللي راحو مْعايَ. ");
INSERT INTO arq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","طَحنا كامَل على الأرض وسْمَعت صوت يْقوللي باللُغة العِبريّة: \"شاوَل، شاوَل، عْلاش راك شاحَن عليَّ، صْعيب عليك باش تْرَكَّل المَهمَز\"، ");
INSERT INTO arq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","قُلت: \"شْكون أنتَ يا سيدي؟\" قال الرَب: \"أنا يَسوع اللي راك شاحَن عليه، ");
INSERT INTO arq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","نوض وأوقَف على رَجليك، خاطَر على هَدا اللي ضْهَرتلَك. خَيَّرتَك باش تْكون خَدّام لِيَّ وشاهَد بالشي اللي شَفتو واللي نْزيد نَضهَرلَك بيه، ");
INSERT INTO arq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","نْسَلّكَك من هاد الشَعب ومن اللي ماشي يْهود اللي أنا رايَح نَبَّعتَك ليهُم، ");
INSERT INTO arq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","باش تْحَلَّلهُم عينيهُم، ويَرَّجعو من الضْلام للضو ومن سيطَرة الشيطان لله، باش يْنالو بالإيمان بيَّ غُفران الدْنوب ونْصيب مع المْقَدّسين\". ");
INSERT INTO arq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","على هَدا، يا سَلطان أغريباس، ما عْصيتش الرُؤيا السْماوِيّة، ");
INSERT INTO arq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","بالعَكس، سْبَقت فاللي في دِمَشق وفي أورشَليم تاني أومبَعد في كامَل اليَهودِيّة وعَند اللي ماشي يْهود، بَرَّحتَلهُم باش يْتوبو ويَرَّجعو لله ويْديرو الفْعال اللي يْليقو بالتوبة. ");
INSERT INTO arq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","على جال هاد الشي اللي حَكموني اليْهود فالمَعبَد وحَبّو يَقُّتلوني، ");
INSERT INTO arq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","بَصَّح بمْعاونة الله، عَشت حَتّى لليوم وأنا نَشهَد للصْغير والكْبير وما نْقول حَتّى شي من غير الشي اللي قالو الأَنبيا وموسى باللي لازَم يْصير، ");
INSERT INTO arq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","باللي المَسيح يَتعَدَّب، يْكون الأوَّل اللي يْقوم من الموت، ويْبَرَّح بالنور للشَعب وللأُمّات.\" ");
INSERT INTO arq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","وكي كان بولَس يَهدَر هَكدا ويْدافَع على روحو، قال فَستوس بالزور: \"هْبَلت يا بولَس، قْريت حَتّى قْريب تْوَلّي مَهبول\"، ");
INSERT INTO arq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","قال بولَس: \"ما رانيش مَهبول يا العْزيز فَستوس، راني نْقول كْلام الحَق والصْواب، ");
INSERT INTO arq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","والسَلطان راهو يَعرَف هاد الحاجات، وراني نَهدَر عليهُم معاه عيناني. راني مَتيَقَّن باللي ما يَخفا عليه مَنهُم حَتّى شي خاطَر هاد الشي ما صْراش في شوكة بالتْخَبّية. ");
INSERT INTO arq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","تامَن بالأنبيا يا سَلطان أغريباس؟ راني عارَف باللي تامَن\"، ");
INSERT INTO arq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","قال أغريباس لبولَس: \"تْزيد شْوِيّة، تْقَنَّعني باش نْوَلّي واحَد تابَع للمَسيح\"، ");
INSERT INTO arq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","وقال بولَس: \"شْوِيّة وَلاّ بَزّاف، صْلاتي لله باش ماشي غير أنتَ، بَصَّح كامَل اللي راهُم يَسَّمعو فِيَّ اليوم يْوَلّيو كيما أنا من غير هاد السْناسَل\". ");
INSERT INTO arq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ناض السَلطان والحاكَم وبَرنيكي وكامَل اللي كانو قاعدين معاهُم، ");
INSERT INTO arq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","وراحو وهومَ يْقولو لبَعضهُم بَعض باللي هاد الراجَل ما دار حَتّى شي يَستاهَل عليه الموت وَلاّ السْناسَل، ");
INSERT INTO arq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","وقال أغريباس لفَستوس: \"هاد الراجَل كان قادَر يَخرُج من الحَبس لو كان ما طْلَبش تْروح دَعوتو لقَيصَر.\" ");
INSERT INTO arq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","وكي نَحكَم باش نْشَدّو البْحَر للطاليان، سَلّمو بولَس ومْحابسِيّة واحَدُخرين لواحَد قايَد المْية من كَتيبة أوغَسطَس واسمو يوليوس. ");
INSERT INTO arq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","طْلَعنا في واحَد البابور مْتاع أَدراميت، وقَلَّعنا وحْنا مْعَوّلين نْجوزو على المْدارَب اللي على شَط آسيا وكان مْعانا أرِستَرخُس، واحَد المَكدوني من تِسالونيكي. ");
INSERT INTO arq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","اليوم اللي من بَعد، وْصَلنا لصَيدا، وكان يوليوس يْدير المْليح مع بولَس وخَلاّه يْزور حْبابو باش يَتهَلاّو فيه. ");
INSERT INTO arq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","من تَم، قَلَّعنا وجَزنا على شَط قُبرُص خاطَر الريح كان يْجي مْعاكَس لينا، ");
INSERT INTO arq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","وبَعد ما جَزنا على البْحَر اللي قُدّام كيليكِيّة وبَمفيلِيّة، وْصَلنا لميرا في ليكِيّة، ");
INSERT INTO arq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","وكي لْقا تَمّة قايَد المْية بابور سْكَندراني رايَح للطاليان، رَكَّبنا فيه. ");
INSERT INTO arq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","يامات بَزّاف وحْنا نَمشيو بالعْقَل وما جينا نَوَّصلو قْريب لكْنيدس حَتّى بالسيف بَصَّح الريح ما خَلاّناش نَحَّبسو فيها وجُزنا على شَط كْريت قُدّام سَلموني، ");
INSERT INTO arq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","اللي جَوَّزناه بَعد مَجهود كْبير، ووْصَلنا لواحَد المْكان واسمو \"المَرسات الشَبّان\" قْريب من لِسائيّة. ");
INSERT INTO arq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","جاز وَقت كْبير ووَلاَّ السْفَر واعَر خاطَر حَتّى وَقت الصْيام كان فات، هِمّالا بْدا بولَس يْشور عليهُم، ");
INSERT INTO arq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","وقالَلهُم: \"يا رْجال، راني نْشوف باللي هاد السْفَر ما راهوش رايَح يْجوز بْلا ما يْضَر ويْجيب خْسارة كْبيرة ماشي غير للسَلعة والبابور، بَصَّح لحْياتنا حْنا تاني\"، ");
INSERT INTO arq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","بَصَّح قايَد المْية كان يَسمَع لكْلام البَحري ومول البابور كْتَر من بولَس. ");
INSERT INTO arq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","وعلى حْساب اللي المَرسى كان ما يَصلَحش باش يْجَوّزو فيه الشْتا، الكَترة مَنهُم حَبّو يْقَلّعو من تَم بَلاك يَقَّدرو يْوَّصلو لفينِكس، مَرسى في كْريت تْقابَل الجَنوب الغَربي والشَمال الغَربي ويْجَوّزو فيها الشْتا. ");
INSERT INTO arq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","كي ضْرَب ريح خْفيف من الجَنوب، حَسبو روحهُم نالو مُرادهُم، وطَلّعو المَخطاف ومْشاو على شَط كْريت. ");
INSERT INTO arq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","بَصَّح، شْوِيّة من بَعد، هاج على الجَزيرة ريح قْوي واسمو أوروكليدون. ");
INSERT INTO arq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","نَخطَف البابور وما قْدَرش يْقاوَم الريح، وحْنا خَلّينا الريح يَدّينا. ");
INSERT INTO arq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","جُزنا على جَزيرة صْغيرة يْقولولها كودا وبالسيف باش قْدَرنا نَلقاو فْلوكة السْلاك، ");
INSERT INTO arq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","وبَعد ما رَفدوها للبابور، شَدّو البابور بالحْبيلة باش يَضَّمنو سْلاكو وكي خافو نْعودو نَزَّدمو في شَط الرْمَل عَند سِرتَس، هَبطو القْلوع وخَلاّو الريح يَدي البابور. ");
INSERT INTO arq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","كي قْوا علينا الريح بَزّاف، غَدوة من داك بْداو يَرميو السَلعة للبْحَر، ");
INSERT INTO arq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","وفاليوم التالَت، رْماو بيَدّيهُم دوزان البابور. ");
INSERT INTO arq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","يامات بَزّاف والشَمس والنْجوم ما بانوش، وبْقا الريح قْوي حَتّى قْطَعنا لِيّاس باللي نَسَّلكو. ");
INSERT INTO arq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","كُنّا ما كْليناش من مُدّة، هِمّالا وْقَف بولَس في وَسطهُم وقال: \"يا رْجال، كان لازَم تَسَّمعوني وما تْروحوش من كْريت، باش تَسَّلكو من هاد الضَر والخْسارة، ");
INSERT INTO arq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","دُرك نْقولَلكُم، أَتسَجّعو خاطَر واحَد فيكُم ما يْضيع من غير البابور، ");
INSERT INTO arq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","خاطَر هاد الليلة، وْقَفلي مْلاك الله اللي أنا ليه واللي نَعَّبدو، ");
INSERT INTO arq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","وقال: \"ما تْخافش يا بولَس، يَلزمَك تَوقَف قُدّام قَيصَر، والله هاو وْهَبلَك حْياة كامَل اللي راهُم مْسافرين مْعاك\"، ");
INSERT INTO arq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","على هَدا، أتسَجّعو يا رْجال، خاطَر نامَن بالله باللي يْكون الشي كيما تْقاللي، ");
INSERT INTO arq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","بَصَّح، لازَم نْطيحو في كاش جَزيرة.\" ");
INSERT INTO arq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","في اليلة الرْبَعطاش، كي كُنّا ضايعين في بْحَر أَدرِيّا، شَكّو البَحرِيّة في نَص الليل باللي بْدينا نْقَرّبو للأَرض، ");
INSERT INTO arq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","قاسو الغامَق ولْقاو عَشرين قامة، بَعّدو شْوِيّة وزادو قاسو ولْقاو خْمَسطاشَن قامة، ");
INSERT INTO arq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","خافو يْعود البابور يْقيس الصْخور ورْماو من اللور رْبَع مْخاطَف وتْقَلّقو باش يَطلَع النْهار. ");
INSERT INTO arq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","حَبّو البَحريّة يَهَّربو من البابور وهَبّطو الفْلوكة مْتاع السْلاك للبْحَر ولْقاو السَبّة باللي يَرميو المْخاطَف من القُدّام، ");
INSERT INTO arq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","وقال بولَس لقايَد المْية والعَسكَر: \"وَلاّ هاد الرْجال ما بْقاوش فالبابور، ما تَقَّدروش تَسَّلكو\". ");
INSERT INTO arq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","هِمّالا، قَطّعو العَسكَر الحْبيلة مْتاع الفْلوكة وخَلاّوها تْطيح. ");
INSERT INTO arq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","وكي كان قْريب يَطلَع النْهار، طْلَب بولَس مَنهُم كامَل باش ياكلو وقال: \"عَندكُم رْبَعطاشَن يوم من اللي راكُم تَستَنَاو وأنتومَ صايمين وما تاكلوش، ");
INSERT INTO arq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","على هَدا، نْشور عليكُم باش تاكلو خاطَر هاد الشي لازَم ليكُم باش تَسَّلكو وشَعرة ما تْطيح من راس واحَد فيكُم\"، ");
INSERT INTO arq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","كي قال هاد الشي، خْدا خُبز، شْكَر الله قُدّامهُم كامَل، قَسمو وبْدا ياكُل، ");
INSERT INTO arq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","وكامَل تْسَجّعو وكْلاو تاني. ");
INSERT INTO arq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","كُنّا ميتين وسَتّة وسَبعين نَفس فالبابور. ");
INSERT INTO arq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","كي شَبعو من الماكلة، بْداو يَرميو القَمح فالبْحَر باش يَخفاف البابور، ");
INSERT INTO arq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","وكي طْلَع النْهار، ما عَرفوش الأَرض اللي وَصلو ليها بَصَّح شافو خَليج بالشَط وعَوّلو يْطَبّعو البابور ليه وَلاَّ قَدرو. ");
INSERT INTO arq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","قَطّعو المْخاطَف وطَلقوهُم يْروحو فالبْحَر وحَلّو الحْبال مْتاع الدْمانات، وطَلّعو القْلوع اللي من القُدّام للريح وراحو للشَط، ");
INSERT INTO arq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","بَصَّح طاحو في واحَد المَدرَب بين زوج بْحور، هِمّالا حَبّسو البابور فالشَط، وتْرَكَّز القُدّام مْتاعو وما وَلاّش يَزغُد ومن اللور بْدا يَتكَسَّر من قُوّة الموجات. ");
INSERT INTO arq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","العَسكَر حَبّو يَقُّتلو المْحابسِيّة يْعود كاش واحَد فيهُم يْروح يْعوم ويَهرَب. ");
INSERT INTO arq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","بَصَّح قايَد المْية، كي كان حاب يْسَلَّك بولَس ما خَلاّهُمش يْديرو رايهُم وآمَر اللي يَعَّرفو يْعومو يْنَڤزو للما هومَ الأولين باش يَوَّصلو للشَط، ");
INSERT INTO arq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","والأخرين يَطَّلعو على اللوح وَلاّ على الحْطَب اللي تْكَسَّر من البابور وهَكدا كامَل وَصلو للشَط بخير وعافية. ");
INSERT INTO arq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","بَعدما سْلَكنا، عْرَفنا باللي الجَزيرة واسَمها مالطة. ");
INSERT INTO arq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","دارو معانا ناسها واحَد المْلاحة ما كاش بْحالها، رَحّبو بينا وشَعلولنا النار خاطَر الشْتا كانَت تْصَب والحال بارَد. ");
INSERT INTO arq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","لايَم بولَس بَزّاف من الحْطَب ورْماه فالنار وخَرجَت لَفعة من السْخانة ولَصقَت في يَدو. ");
INSERT INTO arq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","كي شافو ناس مالطة الهايشة مْعَلّقة في يَدّو، قالو لبَعضهُم بَعض: \"هاد الراجَل ما يْكون غير قَتّال، خاطَر الحَق مْتاع رَبّي ما خَلاّهش يْعيش والو سْلَك من البْحَر.\" ");
INSERT INTO arq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","بولَس نْفَض اللَفعة فالنار وما نْضَر بحَتّى شي. ");
INSERT INTO arq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","هَدوك الناس بْقاو يَستَنّاو يْشوفوه يَتنَفَّخ وَلاّ يْطيح مِيَّت على غَفلة، بَصَّح بَعد ما سْتَنّاو بَزّاف، وشافو باللي ما صْراتلو حَتّى حاجة دونِيّة، بَدّلو رايهُم وقالو باللي هُوَ إلَه. ");
INSERT INTO arq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","كانو في هَدوك الجوايَه، حْواش مْتاع حاكَم الجَزيرة اللي واسمو بوبليوس، هاد الراجَل عْرَضنا وضَيَّفنا مُدّة تَلت أيّام وكان مْليح مْعانا، ");
INSERT INTO arq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","وكان باباة بوبليوس طايَح فالفْراش مْريض بالحَمّى والتَعصار. دْخَل ليه بولَس وصَلاّ ودار يَدّو عليه وشْفاه. ");
INSERT INTO arq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","بَعد هاد الشي، جاو ليه كامَل المَرضى الأخرين مْتاع الجَزيرة وبْراو. ");
INSERT INTO arq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","كَرمونا هَدوك الناس بهْديّات بَزّاف وكي كُنّا رايحين، عْطاوَلنا كامَل واش نَسَّحقو. ");
INSERT INTO arq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","بَعد تَلت شْهور، طْلَعنا في واحَد البابور سْكَندراني، كان جَوَّز الشْتا فالجْزيرة، وكان مَرسوم عليه الرَسم تع َ\"الزوج تْوام\"، ");
INSERT INTO arq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","وكي وْصَلنا لسَراكوسا، جَوَّزنا فيها تَلت أيّام، ");
INSERT INTO arq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","أومبَعد، تَبَّعنا الشَط حَتّى وْصَلنا لريغيون، وبَعد يوم واحَد، ناض ريح الجَنوب وجَوَّزنا يومين فالطْريق باش وْصَلنا لبوطيولي، ");
INSERT INTO arq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ولْقينا تَمّة خاوة عَرضونا نْجَوّزو معاهُم سَبع أيّام، وهَكدا رُحنا لروما. ");
INSERT INTO arq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","من روما، كي سَمعو بينا الخاوة جاو حَتّى لساحة أبيّوس والتَلت تْبَرنات باش يْلاقيونا وكي شافهُم بولَس شْكَر الله وتْسَجَّع. ");
INSERT INTO arq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","كي دْخَلنا لروما، أدّا بولَس التَسريح باش يَسكُن وَحدو ومعاه عَسَّكري يْعَسّو. ");
INSERT INTO arq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","وبَعد تَلت أيّام، عَيَّط للكْبار مْتاع اليْهود، وكي تْلايمو قالَلهُم: \"يا الخاوة، والو ما دَرت حَتّى شي ضَد الشَعب وَلاّ ضَد عْوايَد الجْدود، نْحَطّيت فالحَبس في أورشَليم ومن تَم نْحَطّيت في يَدّين الرومان، ");
INSERT INTO arq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","اللي بَعد ما بَحتوني، حَبّو يَطَّلقوني خاطَر ما لْقاو فِيَّ حَتّى شي نَستاهَل عليه الموت. ");
INSERT INTO arq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","بَصَّح اليْهود كان رايهُم ضَد هاد الشي وتْحَتَّم عليَّ باش نَطلَب تْروح دَعوتي لقَيصَر، ماشي باش نَشتكي مالأُمّة ن مْتاعي. ");
INSERT INTO arq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","هاو عْلاش طْلَبتكُم باش نْشوفكُم ونَهدَر معاكُم، خاطَر على جال الرْجا مْتاع إسرائيل اللي راني مْكَتَّف بهاد السَنسلة.\" ");
INSERT INTO arq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","قالولو: \"حْنا ما جاتنا حَتّى بْرِيّة عليك من اليَهوديّة، وحَتّى أخ ما جاب خْبَر وَلاّ قال حاجة دونِيّة عليك، ");
INSERT INTO arq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","بَصَّح، رانا حابّين نَعَّرفو مَنَّك واش تْخَمَّم، خاطَر عْرَفنا باللي هاد المَدهَب يْقاوموه في كُل مْكان.\" ");
INSERT INTO arq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","دارولو نْهار، وبَزّاف راحو لعَندو وين يَسكُن، وبْدا بولَس من الصْباح حَتّى للعْشِيّة وهُوَ يْخَبَّرهُم على مَلكوت الله ويَشهَد ويْحَوَّس بشَريعة موسى وبكْتوب الأنبيا يْقَنَّعهُم بالشي اللي يْخُص يَسوع. ");
INSERT INTO arq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","كايَن اللي قْتَنعو بكْلامو والأخرين ما آمنوش، ");
INSERT INTO arq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","وكي كانو رايحين وهومَ مَتخالفين بيناتهُم، زاد بولَس كَلمة واحدة: \"صْدق الروح القُدّوس كي قال لجْدودكُم بلْسان النَبي إشعِيا: ");
INSERT INTO arq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"روح لهاد الشَعب وقول: \"تَسَّمعو بوَدنيكُم وما تَفَّهموش، وتَخُّزرو بعينيكُم وما تْشوفوش، ");
INSERT INTO arq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","خاطَر قَلب هاد الشَعب قْساح، واعَر باش وَدنيهُم يَسَّمعو، وغَلقو عينيهُم، خايفين يْشوفو بعينيهُم ويَسَّمعو بوَدنيهُم ويَفَّهمو بقْلوبهُم ويْوَلّيو لِيَّ ونَشفيهُم\"، ");
INSERT INTO arq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","يْكون في مَعلومكُم باللي سْلاك الله نَبعَت للي ماشي يْهود ورايحين يَسَّمعولو.\" ");
INSERT INTO arq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","كي قال هدا الكلام خرجو اليهود من عنده وهم يتناقشو بقوة. ");
INSERT INTO arq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","قْعد بولَس عامين كاملين في دار كان كاريها، وكان يَستَقبَل كامَل اللي يْجيو ليه، ");
INSERT INTO arq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","وكان يْبَرَّح بمَلَكوت الله ويْدَرَّس الشي اللي يْخُص الرَب يَسوع المَسيح بتِقة كاملة وبْلا ما تَمَّنعو حاجة.");
INSERT INTO arq_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","بولَس خْديم يَسوع المَسيح، مَدعو باش نْكون رَسول ومْكَرَّس لإنجيل الله، ");
INSERT INTO arq_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","اللي وْعَد بيه من قْبَل على حْساب قول الأَنبيا فالكْتوب المْقَدّسين، ");
INSERT INTO arq_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","واللي يْخَص وْليدو اللي نْزاد على حْساب الدات من سْلالة داوَد، ");
INSERT INTO arq_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","وعلى حْساب روح القَداسة. تْبَيَّن بقُوّة باللي هُوَ بْن الله من اللي قام مالموت، يَسوع المَسيح رَبّنا. ");
INSERT INTO arq_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","بيه نَلنا نَعمة الرُسولِيّة باش، لمَجد آسمو، نْجيبو لطاعة الإيمان كامَل الأُمّات، ");
INSERT INTO arq_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","اللي أنتومَ تاني منهُم، أنتومَ اللي دْعاكُم يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","لكامَل حْباب الله اللي راكُم في روما، المَدعَوّين باش تْكونو قَدّيسين. نَعمة وسْلام ليكُم من عند الله بابانا والرَب يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","فالأوَّل نَشكُر إلَهي بيَسوع المَسيح على جالكُم كامَل، خاطَر إيمانكُم مَعروف في كامَل الدَنيا. ");
INSERT INTO arq_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ويَشهَد علِيَّ الله اللي نَعَّبدو بروحي في إنجيل وْليدو باللي دايمًا نَدكُركُم، ");
INSERT INTO arq_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ودايمًا نَطلَب في صْلاتي وَلاّ نَقدَر كاش مَرّة بمُراد الله نْجي لعَندكُم، ");
INSERT INTO arq_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","خاطَر راني حاب بَزّاف نْشوفكُم باش نَعطيلكُم كاش موهِبة تْقَوّيكُم، ");
INSERT INTO arq_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","وباش نَتسَجَّع معاكُم وعندكُم بالإيمان مْتاعنا أنا وأنتومَ. ");
INSERT INTO arq_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","وراني حابكُم تَعَّرفو يا الخاوة، باللي شْحال من مَرّة نْويت نْجيكُم، بَصَّح للآن ما تْوَفَّقتش. حَبّيتكُم تَستفادو مَنّي كيما سْتفادو الأمّات الأُخرين. ");
INSERT INTO arq_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","خاطَر أنا مَلزوم لليونانِيّين وللبَربَر، للعُلاما وللجُهالا، ");
INSERT INTO arq_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","وعلى هدا، راني حاب نْبَشَّركُم بالإنجيل، أنتومَ تاني اللي راكُم في روما، ");
INSERT INTO arq_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","خاطَر أنا ما نَحشَمش بإلإنجيل، قُوّة الله لسْلاك كُل مومَن، اليْهودي قْبَل واليوناني من بَعد. ");
INSERT INTO arq_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","بيه بان صْلاح الله بالإيمان وللإيمان، كيما راهو مَكتوب: \"الصالَح يَحيا بالإيمان.\" ");
INSERT INTO arq_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","وبان زْعاف الله من السْما على كُل كُفر وكُل ضَلم مْتاع بْني آدَم اللي حَبسو الحَق والصْلاح. ");
INSERT INTO arq_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","الشي اللي يَقدَر يَنعرَف على الله بايَن عَندهُم، والله بَيَّنهولهُم، ");
INSERT INTO arq_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","خاطَر، من اللي نْخَلقَت الدَنيا، وصِفات الله المَخفِيّين، يَعني قُدَّرتو الدايمة وأُلوهِيّتو، باينين في عْمالو، وعلى هدا اللي بْني آدَم ماشي مَعدورين. ");
INSERT INTO arq_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","خاطَر كي عَرفو الله ما سَبّحوهش وما شَكروهش كيما يَندار لله، وكان تَخمامهُم باطَل وقَلبهُم الجايَح طاح فالضْلام. ");
INSERT INTO arq_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","حَسبو روحهُم فاهمين وهومَ وَلاّو مْهابَل، ");
INSERT INTO arq_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","بَدّلو مَجد الله اللي ما يَفناش بصورة بْنادَم الفاني وصورة الطْيور والهْوايَش والزْواحَف، ");
INSERT INTO arq_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","وعلى هَدا، سَلَّمهُم الله للنْجاسة، على حْساب شَهوات قْلوبهُم، باش هومَ بالدات يْهينو داتهُم. ");
INSERT INTO arq_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","هومَ اللي بَدّلو حَق الله بالكْدَب وكَرّمو وعَبدو المَخلوق في عوض الخالَق المْبارَك للدْوام، آمين. ");
INSERT INTO arq_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","على هَدا، سَلَّمهُم الله للشَهوات الفاسدين، ونْساهُم بَدلو العَلاقة الطَبيعِيّة بعَلاقة ماشي طَبيعِيّة، ");
INSERT INTO arq_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","والرْجال تاني خَلاّو العَلاقة الطَبيعِيّة مع المْرا، وشَعلو في شَهوَتهُم لبَعضهُم بَعض، ودارو الفَسق رْجال مع رْجال ونالو في نْفوسهُم الشي اللي سْتاهلوه على جال ضْياعهُم، ");
INSERT INTO arq_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","وعلى حْساب اللي ما حَوّسوش يَعَّرفو الله، سَلَّمهُم لفْساد عْقولهُم باش يْديرو اللي ما يْليقش، ");
INSERT INTO arq_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","وهومَ مْعَمّرين بكُل دَنب، وفَسق، وطْمَع وشَر، مْعَمّرين بالحْسَد والقْتَل والدْواس والحيلة والفْساد والسَبّان، ");
INSERT INTO arq_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","نَمّامين، عَديان الله، عْدايسِيّين، مَتكَبرين، حاسبين روحهُم، شاطرين للشَر، عاصيين الوالدين، ");
INSERT INTO arq_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ما عندهُم لا فْهامة، لا وْفا، لا حْنانة، لا رَحمة، ");
INSERT INTO arq_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","والو يَعَّرفو باللي الله حْكَم بالموت على اللي يْديرو كيما هاد الفْعال، ماشي بَرك يْديروهُم، يْزيدو يَعطيو الحَق للي يْديروهُم. ");
INSERT INTO arq_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","على هَدا، أنتَ يا بْن آدَم، يا اللي تْحاسَب، مَهما تْكون ما راكش مَعدور، خاطَر كي تْحاسَب الأخرين راك تَحكُم على روحَك، خاطَر أنتَ تاني تْدير هَدوك الحاجات اللي تْحاسَب عليهُم. ");
INSERT INTO arq_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","رانا عارفين باللي الله يْحاسَب اللي يْديرو هاد الحاجات على حْساب الحَق. ");
INSERT INTO arq_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","واش عَند بالَك، وأنتَ تْحاسَب الناس على الشي اللي أنتَ تاني تْديرو، رايَح تَسلَك من حْساب الله؟ ");
INSERT INTO arq_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","وَلاّ كي شَفت الله مْليح بَزّاف وخاطرو واسَع وكْريم، حْڤَرت هاد الشي وما عْرَفتش باللي مْلاحة الله لازَم تَدّيك للتوبة؟ ");
INSERT INTO arq_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","بالقْساوة مْتاعك وقَلبَك اللي ما يْحَبش يْتوب، راك تْخَبّي لروحَك زْعاف الله ليوم زْعاف الله واليوم اللي يَضهَر فيه حْساب الله الحَق، ");
INSERT INTO arq_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","اللي يْجازي كُل واحَد على حْساب فْعالو. ");
INSERT INTO arq_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","الحْياة الدايمة للي صَبرو وهومَ يْديرو فالخير ويْحَوّسو على المَجد والكَرامة والدْوام، ");
INSERT INTO arq_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","والزْعاف والشَحنة على اللي كانو يْغالبو، يَعصيو الحَق، طايعين للباطَل، ");
INSERT INTO arq_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","الشَدّة والغُمّة لكُل نَفس إِنسان يْدير الشَر، اليْهودي قْبَل واليوناني من بَعد، ");
INSERT INTO arq_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","المَجد والكَرامة والسْلام للي يْدير الخير، اليْهودي قْبَل واليوناني من بَعد، ");
INSERT INTO arq_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","خاطر الله ما يْديرش الفْراق. ");
INSERT INTO arq_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","كامَل اللي دارو دْنوب وهومَ ماشي فالشَريعة يَهَّلكو بلا الشَريعة، وكامَل اللي دارو الدْنوب وهومَ فالشَريعة، يَتحاسبو بالشَريعة، ");
INSERT INTO arq_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","خاطَر ماشي اللي يَسَّمعو الشَريعة هومَ الصالحين عَند الله، بَصَّح اللي يْطَبّقوها يْنالو الصْلاح. ");
INSERT INTO arq_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","كي يْطَبّقو الأُمّات اللي ما عَندهُمش الشَريعة فْرايَض الشَريعة بالطْبيعة مْتاعهُم، على حْساب اللي ما عَندهُمش الشَريعة، يْكونو هومَ شَريعة لرْواحهُم، ");
INSERT INTO arq_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ويْبَيّنو باللي عَمَل الشَريعة مَكتوب في قْلوبهُم، ضَميرهُم يَشهَدَّلهُم وعْقولهُم من الداخَل يَتَّهموهُم كي يْديرو الغْلاط ويساندوهم كي يْديرو الصْواب، ");
INSERT INTO arq_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","فاليوم اللي يْحاسَب فيه الله بيَسوع المَسيح سْرار الناس على حْساب إِنجيلي. ");
INSERT INTO arq_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","وَلاّ أنتَ اللي تَتسَمّا يْهودي، وتَتكَل على الشَريعة، وتَفتَخَر بالله، ");
INSERT INTO arq_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","وتَعرَف مُرادو، وتْمَيَّز الصَح على حْساب ما تْعَلَّمت من الشَريعة، ");
INSERT INTO arq_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","وراك واتَق باللي أنتَ ڤَوّاد العَميين ونور للي راهُم فالضْلام، ");
INSERT INTO arq_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","تْعَلَّم الجاهلين، وتْقَرِّي الدْراري، خاطَر كْسَبت فالشَريعة صِفة المَعرِفة والحَق، ");
INSERT INTO arq_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","أنتَ اللي تْعَلَّم غيرَك، ما تْعَلَّمش روحَك؟ تْبَرَّح باللي ما لازَمش الواحَد يَسرَق وأنتَ تَسرَق؟ ");
INSERT INTO arq_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","تْقول باللي ما لازَمش الواحَد يَزني وأنتَ تَزني؟ تَكرَه الصْنام وتَسرَق المْعابَد؟ ");
INSERT INTO arq_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","تَفتَخَر بالشَريعة وتْهين الله بعَصيان الشَريعة، ");
INSERT INTO arq_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","خاطَر \"آسَم الله راهو يَتسَب ما بين الأمَات على جالكُم\" كيما راهو مَكتوب. ");
INSERT INTO arq_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","الخْتانة تَنفَع لوكان تْطَبَّق الشَريعة، بَصَّح لوكان تَعصي الشَريعة، خْتانتَك تْوَلّي ماشي خْتانة، ");
INSERT INTO arq_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ووَلاّ كان اللي ماشي مْخَتَّن يْطَبَّق فْرايَض الشَريعة، هُوَ اللي بلا خْتانة يَتَّحسَب مْخَتَّن، ");
INSERT INTO arq_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","والجيهة اللي ماشي مْخَتّنة في داتو واللي تْطيع الشَريعة، تْحاسبَك أنتَ اللي عندَك الكْتاب والخْتانة وتَعصي الشَريعة. ");
INSERT INTO arq_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","خاطَر اليْهودي ماشي اللي يْبان من بَرّا يْهودي، والخْتانة ماشي المارة اللي تْبان فالدات، ");
INSERT INTO arq_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","بَصَّح اليْهودي يْهودي من الداخَل، والخْتانة خْتانة القَلب، بالروح ماشي بالكْتاب، اللي يَشهَدَّلها الله ماشي بْني آدَم. ");
INSERT INTO arq_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","هِمّالا، واش قيمة اليْهودي، وواش فايدة الخْتانة؟ ");
INSERT INTO arq_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","كْبيرة في كُل حال. الأوَّل خاطَر الله آمَنهُم على قْوالو، ");
INSERT INTO arq_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","أومبَعد؟ وَلاّ كايَن اللي ما آمنوش؟ هاد الشي رايَح يْبَطَّل أَمانة الله؟ ");
INSERT INTO arq_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","حاشا، الله حَق وكُل إِنسان كَدّاب، كيما مَكتوب: \"باش تْكون صالَح في كْلامَك، وتَغلَب كي تَتحاسَب\". ");
INSERT INTO arq_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","بَصَّح وَلاّ كانَت خْطِيَّتنا تْبَيَّن صْلاح الله، واش نْقولو؟ باللي الله ضالَم كي يْخَرَّج زْعافو؟ راني نَهدَر بالمَنطَق مْتاع بْني آدَم. ");
INSERT INTO arq_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","حاشا، خاطَر كيفاش هِمّالا رايَح يْحاسَب الدَنيا؟ ");
INSERT INTO arq_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","إدا كان بالكْدَب مْتاعي يَضهَر حَق الله للمَجد مْتاعو، وَعلاش يْنَحكَم علِيَّ باللي أنا خاطي؟ ");
INSERT INTO arq_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ووَعلاش، كيما راهُم شي ناس يْجَرّمو علينا باللي رانا نْقولو، وَعلاش ما نْديروش الشَر باش يْجي الخير؟ هاد الناس يَستاهلو يْنَحكَم عليهُم. ");
INSERT INTO arq_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","كيفاش هِمّالا؟ حْنا خير؟ لالا، خاطَر سْبَق وقُلنا باللي كي اليْهود كي اليونانِيين، كامَل راهُم تَحت سيطرة الخْطِيّة، ");
INSERT INTO arq_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","كيما مَكتوب: \"واحَد ما راهو صالَح، حَتّى واحَد، ");
INSERT INTO arq_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","واحَد ماراهو عاقَل، واحَد ما راهو يْحَوَّس على الله، ");
INSERT INTO arq_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","كامَل بَعّدو وفَسدو كيف كيف. واحَد ما راهو يْدير المْليح، حَتّى واحَد. ");
INSERT INTO arq_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","الڤُرزي مْتاعهُم قْبَر مَحلول، لْسانهُم خَدّاع، سَم اللْفاعي تَحت شْوارَبهُم، ");
INSERT INTO arq_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","فَمهُم مْعَمَّر بالنَعلة والمْرار، ");
INSERT INTO arq_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","رَجليهُم مَزروبين باش يْسَيّلو الدَم، ");
INSERT INTO arq_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","الهْلاك والشَر في طُرقانهُم، ");
INSERT INTO arq_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","وما عَرفوش طْريق السْلام، ");
INSERT INTO arq_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","وقُدّام عينيهُم، ماكانش خوف الله.\" ");
INSERT INTO arq_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","رانا عارفين باللي كامَل واش تْقول الشَريعة، تْقولو للي راهُم تَحت الشَريعة، باش كُل فَم يْنَغلَق، ويْبان غْلاط كامَل الدَنيا قُدّام الله. ");
INSERT INTO arq_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","على هَدا، واحَد ما يْنال الصْلاح قُدّام الله بعْمال الشَريعة، خاطَر الشَريعة هِيَ اللي تْبَيَّن الخْطِيّة. ");
INSERT INTO arq_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","دُرك، بلا شَريعة بان صْلاح الله، اللي تَشهَدلو الشَريعة والأَنبيا، ");
INSERT INTO arq_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","صْلاح الله بالإيمان بيَسوع المَسيح لكامَل المومنين بلا فْراق. ");
INSERT INTO arq_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","خاطَر كامَل خْطاو ونْحَرمو من مَجد الله، ");
INSERT INTO arq_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ونالو الصْلاح بالنَعمة، بالسْلاك اللي في يَسوع المَسيح، ");
INSERT INTO arq_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","هُوَ اللي مَدّو الله ضْحِيّة يْكَفَّر على الدْنوب بدَمّو للي يآمنو، باش يْبَيَّن صْلاحو زْمان كي ما حاسَبش على الدْنوب، ");
INSERT INTO arq_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","وباش يْبَيَّن صْلاحو دُرك، على حْساب اللي هُوَ صالَح ويْشوف كُل مومَن بيَسوع صالَح. ");
INSERT INTO arq_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","واش من السَبّة بْقات باش الواحَد يَقدَر يَحسَب روحو؟ ماكاش. بآما شَريعة؟ شَريعة العْمال؟ لالا. بشَريعة الإيمان. ");
INSERT INTO arq_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","خاطَر رانا شايفين باللي الإنسان يْنال الصْلاح بالإيمان بلا عْمال الشَريعة. ");
INSERT INTO arq_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","وَلاّ الله إلَه اليْهود بَرك؟ ماشي إلَه اللي ماشي يْهود تاني؟ الله إلَه اليْهود واللي ماشي يْهود، ");
INSERT INTO arq_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","خاطَر الله واحَد، هُوَ اللي رايَح يْبَرّي المْخَتَّن بالإيمان واللي ماشي مْخَتَّن بالإيمان. ");
INSERT INTO arq_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","هِمّالا نْبَطّلو الشَريعة بالإيمان؟ بالعَكس، نْتَبّتو الشَريعة. ");
INSERT INTO arq_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","هِمّالا واش نْقولو في إبراهيم بابانا على حْساب الدات؟ واش لْقا؟ ");
INSERT INTO arq_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","إيه، وَلاّ إِبراهيم نال الصْلاح بالأفعال، يَقدَر يَفخَر بروحو، بَصَّح ماشي قُدّام الله، ");
INSERT INTO arq_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","خاطَر واش يْقول الكْتاب: \"آمَن إِبراهيم بالله، ونَحسَبلو هاد الشي صْلاح.\" ");
INSERT INTO arq_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","الخْلاص تاع الخَدّام حَق ماشي مْزِيّة، ");
INSERT INTO arq_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","بَصَّح اللي ما يَخدَمش ويامَن باللي يْبّرَي الخاطي، يَتَّحسَبلو إيمانو صْلاح. ");
INSERT INTO arq_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","وداوَد يْقول يا سَعدو الإنسان اللي يَحَّسبو الله صالَح بلا فْعال: ");
INSERT INTO arq_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","\"يا سَعد اللي نْغَفرو دْنوبهُم ونْسَترو غَلطاتهُم، ");
INSERT INTO arq_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","يا سَعد الإنسان اللي ما يْحاسبوش الله على دَنبو\". ");
INSERT INTO arq_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","وهاد السَعد غير للمْخَتّنين، وَلاّ اللي ماشي مْخَتّنين تاني؟ خاطَر رانا نْقولو: إيمان إبراهيم نَحسَبلو صْلاح. ");
INSERT INTO arq_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","كيفاش نَحسَبلو؟ بَعد وَلاّ قْبَل الخْتانة؟ لالا، ماشي بَعد الخْتانة، قْبَل. ");
INSERT INTO arq_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ونال المارة مْتاع الخْتانة باش يَتبَت الصْلاح بالإيمان اللي نالو قْبَل ما يَتخَتَّن، باش يْكون باباة المومنين، اللي ماشي مْخَتّنين، باش يْنالو الصْلاح هومَ تاني. ");
INSERT INTO arq_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","وباش يْكون تاني باباة المْخَتّنين، هَدوك اللي ماشي بَرك مْخَتّنين، هَدوك اللي يْسيرو على طْريق إيمان بابانا إبراهيم قْبَل ما يَتخَتَّن. ");
INSERT INTO arq_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","الوَعد اللي نْدار لإبراهيم ولدَرِيّتو باش يَورَت الكون ما جاش من الشَريعة، جا من صْلاح الإيمان. ");
INSERT INTO arq_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","إيه، وَلاّ اللي يَوَّرتو هومَ ناس الشَريعة، هِمّالا الإيمان بلا فايدة والوَعد باطَل. ");
INSERT INTO arq_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","إيه، الشَريعة تْجيب الزْعاف، وبلا شَريعة، ما كانش عَصيان. ");
INSERT INTO arq_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","على هَدا، الوَعد قايَم على الإيمان، باش يْكون بالنَعمة، ويْكون الوَعد مَضمون لكامَل الدَرِّيّة، ماشي غير لناس الشَريعة، يْكون تاني للي عَندهُم إيمان إبراهيم، هُوَ بابانا كامَل. ");
INSERT INTO arq_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","كيما مَكتوب: \"راني دَرتَك باباة لأُمّات بَزّاف\"، قُدّام اللي آمَن بيه، الله اللي يَحيي الموتى ويْسَمّي الحاجات اللي ماشي كاينين كي اللي كاينين. ");
INSERT INTO arq_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","هُوَ، اللي وين ما كانش الرْجا، آمَن بالرْجا باش يْوَلّي باباة لأُمّات بَزّاف، كيما يْقول الكْتاب: \"هَكدا تْكون دَرِّيّتَك\"، ");
INSERT INTO arq_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","إيمانو ما ضْعَفش، وما شافش داتو مِيّتة والو كان عَندو قْريب مْية سْنة وسارة عاڤرة. ");
INSERT INTO arq_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ما شَكش في وَعد الله وما قَلش إيمانو، تْقَوّا بالإيمان ومَجَّد الله، ");
INSERT INTO arq_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","وهُوَ واتَق باللي الشي اللي يَوعَد بيه الله، قادَر باش يْديرو، ");
INSERT INTO arq_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","على هَدا، نَحسَبلو هاد الشي صْلاح. ");
INSERT INTO arq_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ماشي غير ليه اللي نَكتَب: \"هاد الشي أنَحسَبلو\"، ");
INSERT INTO arq_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","حْنا تاني لازَم يَنَحسَبَّلنا، حْنا اللي نامنو باللي حْيا يَسوع رَبّنا مالموت، ");
INSERT INTO arq_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","سَلّمو على جال دْنوبنا وحْياه لصْلاحنا. ");
INSERT INTO arq_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","هِمّالا، كي نَلنا الصْلاح بالإيمان، عَندنا السْلام مع الله برَبّنا يَسوع المَسيح، ");
INSERT INTO arq_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","اللي بيه تاني نَقَّدرو نَوَّصلو بالإيمان لهاد النَعمة اللي رانا فيها، وحْنا نَفَّخرو بالرْجا مْتاع مَجد الله. ");
INSERT INTO arq_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ماشي بَرك هَكدا. نْزيدو نَفَّخرو بالشْدايَد، وحْنا عارفين باللي الشَدّة تْجيب الصْبَر، ");
INSERT INTO arq_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","والصْبَر يْجيب التْبات فالتَجرُبة والتْبات فالتَجرُبة يْجيب الرْجا، ");
INSERT INTO arq_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","الرْجا ما يَخليش بمولاه، خاطَر مْحَبّة الله تْفَرغَّت في قْلوبنا بالروح القُدّوس اللي نَعطالنا. ");
INSERT INTO arq_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","وزيد بزْيادة، كي كُنّا ضْعاف، فالوَقت اللازَم، مات المَسيح على جال الخاطيين. ");
INSERT INTO arq_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","الواحَد بالسيف باش يْموت على جال واحَد صالَح، بَلاك واحَد يْموت على جال إنسان مْليح. ");
INSERT INTO arq_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","بهاد الشي اللي الله بَيَّن مْحَبّتو لينا: كي كُنّا مازَلنا خاطيين، مات المَسيح على جالنا. ");
INSERT INTO arq_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","دُرك، كي نَلنا الصْلاح بدَمّو، رايحين نَسَّلكو بيه من الزْعاف. ");
INSERT INTO arq_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","خاطَر بَعد ما كُنّا عَديان، تْصالَحنا مع الله بموت وْليدو، وكي تْصالَحنا، رايحين نَسَّلكو بحْياتو. ");
INSERT INTO arq_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","وماشي بَرك هَكدا، نْزيدو نَفَّخرو فالله برَبّنا يَسوع المَسيح اللي بيه من دُرك نَلنا المُصالحة. ");
INSERT INTO arq_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","وكيما دَخلَت الخْطِيّة للدَنيا بإِنسان واحَد، آدَم، وبالخْطِيّة دَخلَت الموت، وقاسَت كامَل الناس خاطَر كامَل خْطاو، ");
INSERT INTO arq_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","إيه، خاطَر قْبَل الشَريعة، الخْطِيّة كانَت كاينة فالدَنيا، بَصَّح ماكانَتش تْنَحسَب كي ما كانَتش كاينة الشَريعة، ");
INSERT INTO arq_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","والو الموت كانَت مْسيطَر من آدَم لموسى، حَتّى على اللي ما غَلطوش كيما آدَم، اللي هُوَ صِفة اللي كان جاي. ");
INSERT INTO arq_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","بَصَّح هِبة الله ماشي كيما الخْطِيّة. خاطَر وَلاّ خْطِيّة واحَد أدّات بَزّاف للموت، نَعمة الله كْبيرة كْتَر، وفي واحَد اللي هُوَ يَسوع المَسيح فاضَت نَعمة الله وهِبتو لناس بَزّاف. ");
INSERT INTO arq_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ماشي كيف كيف بين الهِبة وخْطِيّة إنسان واحَد، خاطَر خْطِيّة واحَد تْجيب الحُكم بالموت على بَزّاف، والهِبة تْمَد الصْلاح بَعد دْنوب بَزّاف. ");
INSERT INTO arq_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","وَلاّ خْطِيّة واحَد جابَت سيطَرة الموت، اللي يْنالو النَعمة الفايضة وهِبة الصْلاح يَمّلكو فالحْياة بواحَد، يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","هَكدا هِمّالا، كيما بغَلطة واحَد، جاز الحُكم على كامَل الناس، كيف كيف، بخَدمة صالحة واحدة، جاز الصْلاح اللي يَحيي كامَل الناس. ");
INSERT INTO arq_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","خاطَر، عَصيان واحَد اللي هُوَ آدَم، رَد الكُل عاصي. هَكدا، طاعة واحَد رَدَّت الكُل صالَح. ");
INSERT INTO arq_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","الشَريعة دَخلَت باش بَيّنَت كُترة الدْنوب، بَصَّح وين كْتَر الدَنب فاضَت النَعمة. ");
INSERT INTO arq_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","باش كيما تْسيطَر الخْطِيّة بالموت، تْسيطَر النَعمة بالصْلاح للحْياة الدايمة بيَسوع المَسيح رَبّنا. ");
INSERT INTO arq_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","هَكدا هِمّالا، واش نْقولو؟ نَبقاو فالخْطِيّة باش تْفيض النَعمة؟ ");
INSERT INTO arq_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","لالا، حْنا اللي مَتنا للخْطِيّة، كيفاش نْزيدو نْعيشو فيها؟ ");
INSERT INTO arq_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ما راكُمش عارفين باللي حْنا كامَل اللي تْعَمَّدنا فالمَسيح يَسوع، تْعَمَّدنا في موتو؟ ");
INSERT INTO arq_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","يَعني نَدفَننا معاه بالمَعمودِيّة في موتو، باش كيما المَسيح قام مالموت بالمَجد مْتاع الآب، هَكدا حْنا تاني نَمشيو في حْياة جْديدة. ");
INSERT INTO arq_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","إيه، وَلاّ شْرَكنا معاه في موتو، رايحين تاني نَشَّركو معاه في قْيامتو، ");
INSERT INTO arq_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","عارفين باللي الإنسان القْديم فينا نَصلَب، باش تَفنا دات الخْطِيّة وباش ما نْزيدوش نْكونو عْبيد للخْطِيّة، ");
INSERT INTO arq_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","خاطَر المَيَّت تْبَرّا من الخْطِيّة. ");
INSERT INTO arq_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","وَلاَ مَتنا مع المَسيح، نامنو باللي نَحياو تاني معاه. ");
INSERT INTO arq_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","رانا عارفين باللي المَسيح بعد ما قام من الموت، ما راهوش رايَح يْزيد يْموت، الموت ما وَلاّتش تَقدَر عليه، ");
INSERT INTO arq_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","خاطَر كي مات، مات للخْطِيّة مَرّة واحدة، وكي حْيا، حْيا لله. ");
INSERT INTO arq_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","أنتومَ تاني، شوفو روحكُم مِيّتين للخْطِيّة، وحَيّين لله في يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","هِمّالا ما لازَمش تْزيد الخْطِيّة تْسيطَر على داتكُم الفانية وتْطَوَّعكُم لشَهواتكُم. ");
INSERT INTO arq_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ما تْسَلّموش طْرافكُم للخْطِيّة كي سْلاح الباطَل، بَصَّح أَوَّهبو روحكُم لله وأنتومَ جايّين من الموت للحْياة وخَدّمو طْرافكُم كي سْلاح الصْلاح لله. ");
INSERT INTO arq_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","الخْطِيّة ما تْزيدش تْسيطَر عليكُم، خاطَر ما راكُمش تَحت الشَريعة، راكُم تَحت النَعمة. ");
INSERT INTO arq_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","كيفاش هِمّالا؟ نْديرو دْنوب خاطَر ما راناش تَحت الشَريعة، بَصَّح تَحت النَعمة؟ حاشا! ");
INSERT INTO arq_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ما راكُمش عارفين باللي كي تَوَّهبو روحكُم لكاش واحَد باش تْطيعوه، تْوَلّيو عْبيد لهَداك اللي تْطيعوه، وياإما للخطية اللي تدّي للموت ولّا للطاعة اللي تدّي للصلاح. ");
INSERT INTO arq_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","الحَمد لله، خاطَر كُنتو عْبيد للخْطِيّة، ووَلّيتو طايعين من كُل قَلبكُم للمَدهَب اللي تْعَلَّمتوه، ");
INSERT INTO arq_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","وتَتحَرَّرتو من الخْطِيّة ووَلّيتو عْبيد للصْلاح. ");
INSERT INTO arq_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","راني نَهدَر معاكُم بمَنطَق بْني آدَم على جال ضَعفكُم، خاطَر كيما وْهَبتو طْرافكُم كي العْبيد للنَجاسة والخْطِيّة للخْطِيّة، أَوَّهبو دُرك طْرافكُم عْبيد الصْلاح للقَداسة، ");
INSERT INTO arq_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","خاطَر كي كُنتو عْبيد للخْطِيّة، كُنتو حُرّين من الصْلاح، ");
INSERT INTO arq_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","واش كانَت الغَلّة مْتاعكُم؟ هَديك اللي دُرك تَحَّشمو بيها، هَديك اللي تَدّي للموت. ");
INSERT INTO arq_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","بَصَّح دُرك، بعدما تْحَرَّرتو من الخْطِيّة، ووَلّيتو عْبيد لله، راكُم تْجيبو غَلّة للقَداسة، غَلّة تَدّي للحْياة الدايمة، ");
INSERT INTO arq_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","خاطَر آجَر الخْطِيّة هُوَ الموت، وهِبة الله هِيَ الحْياة الدايمة فالمَسيح يَسوع رَبّنا. ");
INSERT INTO arq_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ما راكُمش عارفين ياالخاوة، راني نَهدَر مع ناس يَعَّرفو الشَريعة، باللي الشَريعة تَتحَكَّم فالإنسان ما دامو حَي؟ ");
INSERT INTO arq_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","المْرا المْزَوّجة مَربوطة بالشَريعة لراجَلها مادامو حَي، بَصَّح لوكان يْموت، تَتحَرَّر من الشَريعة اللي تَربَطها ليه. ");
INSERT INTO arq_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","يَعني، مادامو حَي، تَتسَمّا زانية لوكان تْكون لراجَل واحَدآخُر، بَصَّح وَلاّ مات تَتحَرَّر من الشَريعة، وما تَتسَمّاش زانية لوكان تْكون لراجَل واحَدآخُر. ");
INSERT INTO arq_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","حَب يْقول، يا خاوتي، أنتومَ مَتّو للشَريعة في دات المَسيح، باش تْكونو لواحَدآخُر، للي قام مالموت، باش نْجيبو غَلّة لله. ");
INSERT INTO arq_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","خاطَر كي كُنّا فالدات، كانو شَهوات الخْطِيّة بالشَريعة يَخَّدمو في طْرافنا باش يْجيبو غَلّة للموت، ");
INSERT INTO arq_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","بَصَّح دُرك، رانا تْحَرَّرنا من الشَريعة، على حْساب اللي مَتنا للشي اللي كان حاكَمنا، باش مَنّا للفوق نَخَّدمو على حْساب الروح الجْديد، وماشي على حْساب الحَرف القْديم. ");
INSERT INTO arq_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","واش نْقولو هِمّالا؟ الشَريعة خْطِيّة؟ حاشا! بَصَّح ما عْرَفت الخْطِيّة غير بالشَريعة. ما كُنتش قادَر نَعرَف الشَهوة لوكان الشَريعة ما قالَتش: \"ما تْتشَهّاش\"، ");
INSERT INTO arq_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","والخْطِيّة، لِقاَت السَبّة بالفَرض وخَلقَت فِيَّ الشَهوة. خاطَر بلا الشَريعة، الخْطِيّة مِيّتة. ");
INSERT INTO arq_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","أنا بالدات، كُنت عايَش من قْبَل بلا شَريعة، وكي جا الفَرض، حْيات الخْطِيّة، ");
INSERT INTO arq_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ومَت أنا، والفَرض اللي نَعطا للحْياة، أدّاني للموت. ");
INSERT INTO arq_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","خاطَر الخْطِيّة لْقاَت السَبّة بالفَرض، غْواتني وقَتلَتني. ");
INSERT INTO arq_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","الشَريعة مْقَدّسة، والفَرض مْقَدَّس، صالَح ومْليح، ");
INSERT INTO arq_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","واش مَعنَتها؟ المْليح جابلي الموت؟ حاشا! بَصَّح باش تْبان الخْطِيّة باللي هِيَ خْطِيّة، جابَتلي الموت بالشي اللي مْليح، وبالفَرض بانَت الخْطِيّة شْحال خاطية. ");
INSERT INTO arq_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","رانا عارفين باللي الشَريعة روحِيّة، بَصَّح أنا دات مَبيوعة للخْطِيّة، ");
INSERT INTO arq_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","خاطَر ما نَعرَفش واش نْدير، وما نَقدَرش نْدير واش نْحَب، ونَكرَه واش نْدير. ");
INSERT INTO arq_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","وَلاّ نْدير الشي اللي ما نْحَبّوش، راني نَستَعرَف باللي الشَريعة مْليحة. ");
INSERT INTO arq_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ودُرك ماشي أنا اللي نْدير هاد الشي، بَصَّح الخْطِيّة اللي تَسكُن فِيَّ، ");
INSERT INTO arq_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","خاطَر راني عارَف باللي ماشي الخير اللي ساكَن فِيَّ، يَعني في داتي، خاطَر نْحَب الخير بَصَّح ما نْديرش الخير، ");
INSERT INTO arq_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","وما نْديرش الخير اللي نْحَبّو، ونْدير الشَر اللي ما نْحَبّوش. ");
INSERT INTO arq_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","وَلاّ الشي اللي ما نْحَبّوش، هَداك هُوَ اللي نْديرو، مَعنَتها ماشي أنا اللي راني نَتصَرَّف، الخْطِيّة اللي ساكنة فِيَّ هِيَ اللي راهي تَتصَرَّف. ");
INSERT INTO arq_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ونَلقا باللي نْحَب نْدير الخير بَصَّح الشَر هُوَ اللي حاضَر فِيَّ، ");
INSERT INTO arq_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","خاطَر نَفرَح بشَريعة الله اللي فِيَّ من الداخَل، ");
INSERT INTO arq_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","بَصَّح نَلقا في داتي شَريعة واحَدُخرى تْحارَب الشَريعة اللي في عَقلي، وتْطَوَّعني لشَريعة الخْطِيّة اللي ساكنة في داتي. ");
INSERT INTO arq_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","مَسكين أنا! شْكون يْسَلَّكني من دات الموت هَدي؟ ");
INSERT INTO arq_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","الحَمد لله بيَسوع المَسيح رَبّنا. أنا نَخدَم شَريعة الله بعَقلي، بَصَّح داتي تَخدَم شَريعة الخْطِيّة. ");
INSERT INTO arq_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ما كايَن دُرك هِمّالا حَتّى حُكم على اللي فالمَسيح يَسوع، ");
INSERT INTO arq_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","خاطَر شَريعة روح الحْياة اللي في يَسوع المَسيح حَرّراتَك من شَريعة الخْطِيّة والموت. ");
INSERT INTO arq_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","خاطَر اللي كان مُحال للشَريعة كي كانَت الدات كاسرَتَّلها قُوَّتها، الله دارو كي بْعَت وْليدو في دات تْشَبَّه لدات الخْطِيّة، وحْكَم على الخْطِيّة فالدات، ");
INSERT INTO arq_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","باش يْتَم فينا صْلاح الشَريعة، حْنا اللي نَمشيو على حْساب الروح ماشي على حْساب الدات. ");
INSERT INTO arq_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","اللي يْعيشو على حْساب الدات يْحَبّو حاجات الدات، بَصَّح اللي يْعيشو على حْساب الروح يْحَبّو حاجات الروح، ");
INSERT INTO arq_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","خاطَر تَخمام الدات يْوَصَّل للموت، بَصَّح تَخمام الروح يْوَصَّل للحْياة والسْلام، ");
INSERT INTO arq_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","تَخمام الدات عْداوة لله، الدات ماشي مَنطاعة لشَريعة الله، وما تَقدَرش تْكون. ");
INSERT INTO arq_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","هِمّالا اللي يْعيشو على حْساب الدات ما يَقَّدروش يَرضيو الله. ");
INSERT INTO arq_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","بَصَّح أنتومَ ما راكُمش فالدات، راكُم فالروح وَلاّ كان روح الله ساكَن فيكُم. اللي ما عَندوش روح المَسيح، ماشي مْتاع المَسيح. ");
INSERT INTO arq_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","بَصَّح وَلاّ كان المَسيح فيكُم، الدات مِيّتة بسْباب الخْطِيّة، والروح حْياة بسْباب الصْلاح. ");
INSERT INTO arq_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","وَلاّ كان الروح اللي حْيا يَسوع من الموت ساكَن فيكُم، اللي حْيا المَسيح من الموت رايَح يَحيي تاني داتكُم الفانية بروحو الساكَن فيكُم. ");
INSERT INTO arq_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","هِمّالا يا الخاوة، رانا مَلزومين ماشي للدات باش نْعيشو على حْساب الدات، ");
INSERT INTO arq_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","خاطَر وَلاّ تْعيشو على حْساب الدات، رايحين تْموتو، وَلاّ كُنتو بالروح تَقُّتلو عْمال الدات، راحيين تَحياو. ");
INSERT INTO arq_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","خاطَر كامَل اللي يْسَيَّرهُم روح الله، هومَ وْلاد الله، ");
INSERT INTO arq_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","خاطَر ما نَلتوش روح العُبودِيّة باش تْوَلّيو للخوف، نَلتو روح التَبَنّي اللي بيه نْعَيّطو: \"آبا، الآب\". ");
INSERT INTO arq_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","الروح بالدات يَشهَد لروحنا باللي حْنا وْلاد الله. ");
INSERT INTO arq_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","وَلاَ كُنّا وْلاد، يَعني حْنا وارتين، وارتين الله وشاركين في وَرت المَسيح وَلاّ تْعَدَّبنا معاه باش نَتمَجّدو تاني معاه. ");
INSERT INTO arq_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","وراني مَقتَنَع باللي العْداب مْتاع هاد الوَقت ما يَسوا والو قُدّام المَجد اللي رايَح يْبان فينا، ");
INSERT INTO arq_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","الخَلق راهو يَستَنّا وهُوَ مْقَلَّق وَقتاش يْبانو وْلاد الله، ");
INSERT INTO arq_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","خاطَر الخَلق نْطاع للباطَل، ماشي بمْحَبّة خاطرو، نْطاع بسْباب اللي طَوّعو. هاد الخَلق راه يَستَنّا بالرْجا، ");
INSERT INTO arq_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","باش يَتحَرَّر هُوَ تاني من عُبودِيّة الفْساد لحُرِيّة مَجد وْلاد الله. ");
INSERT INTO arq_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ورانا عارفين باللي الخَلق كامَل راهو دُرك يْنازَع ويَتعَدَّب بوْجاع الوْلادة، ");
INSERT INTO arq_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","وماشي بَرك الخَلق، حْنا تاني اللي عَندنا باكورة الروح، حْنا تاني رانا نْنازعو من الداخَل وحْنا نَستَنّاو التَبَنّي وسْلاك داتنا. ");
INSERT INTO arq_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","عَندنا الرْجا باللي نَسَّلكو، بَصَّح الرْجا اللي نْشوفوه ماشي رْجا، خاطَر اللي نْشوفوه، نَقَّدرو نْزيدو نَرجاوَه؟ ");
INSERT INTO arq_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","بَصَّح كي نَرجاو الشي اللي ما نْشوفوهش، نَستَنّاوَه وحْنا صابرين. ");
INSERT INTO arq_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ومن جيهة أخرى، الروح يْعاوننا في ضَعفنا، خاطَر ما نَعَّرفوش كيفاش نْصَلّيو كيما لازَم، بَصَّح الروح يَشفَعَّلنا بنْزاع ما يَتَّنطَقش بالكْلام، ");
INSERT INTO arq_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","واللي يَفحَص القْلوب يَعرف قَصد الروح، خاطَر الروح يَشفَع للقَدّيسين على حْساب مُراد الله. ");
INSERT INTO arq_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","رانا عارفين: الله يْسَيَّر كُل شي لخير اللي يْحَبّوه، اللي دْعاهُم على حْساب القَصد مْتاعو، ");
INSERT INTO arq_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","خاطَر اللي عْرَفهُم من قْبَل، سْبَق وخَيَّرهُم باش يْكونو في صِفة وْليدو، باش يْكون وْليدو هُوَ البْكَر بين خاوة بَزّاف. ");
INSERT INTO arq_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","وهَدوك اللي سْبَق خَيَّرهُم، دْعاهُم، واللي دْعاهُم، عْطالهُم الصْلاح، واللي عْطالهُم الصْلاح، نالو مَنّو المَجد تاني. ");
INSERT INTO arq_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","دُرك، واش نْزيدو نْقولو؟ ما دام الله معانا، شْكون يْكون ضَدنا؟ ");
INSERT INTO arq_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","هُوَ اللي سَبَّل وْليدو، وضَحّا بيه على جالنا كامَل، كيفاش ما يْزيدش يَعطيلنا كُل شي معاه؟ ");
INSERT INTO arq_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","شْكون يَتهَم مُختارين الله؟ الله هُوَ اللي يْبَرّيهُم، ");
INSERT INTO arq_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","وشْكون يَحكُم عليهُم؟ المَسيح يَسوع اللي مات، واللي زاد قام، واللي راهو على يْمين الله، هُوَ اللي يَشفَعَّلنا. ");
INSERT INTO arq_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","شْكون اللي يْفرَّقنا على مْحَبّة المَسيح؟ الشَدّة وَلاّ الغُمّة وَلاّ الحُڤرة وَلاّ الجوع وَلاّ العْرا وَلاّ الخَطَر وَلاّ السيف؟ ");
INSERT INTO arq_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","وكيما راهو مَكتوب: \"رانا على جالَك نْقاصيو الموت طول النْهار، حاسبيننا غْنَم مْتاع الدْبيحة.\" ");
INSERT INTO arq_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","بَصَّح، في هاد الشي كامَل، حْنا كْتَر من مَنصورين باللي حَبّنا. ");
INSERT INTO arq_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","وراني مَتيَقَّن باللي لا الموت وَلا الحْياة، لا المَلايكة وَلا الرِيّاس، لا الحاضَر وَلا الجاي، لا القُوّات، ");
INSERT INTO arq_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","لا اللي الفوق وَلا اللي التَحت، وَلا خْليقة واحَدُخرى يَقَّدرو يْفَرّقونا على مْحَبّة الله اللي فالمَسيح يَسوع رَبّنا. ");
INSERT INTO arq_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","نْقول الصَح فالمَسيح، ما نَكدَبش والضَمير مْتاعي يَشهَدلي فالروح القُدّوس، ");
INSERT INTO arq_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","عَندي حْزَن كْبير ووَجعة دايمة في قَلبي، ");
INSERT INTO arq_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","خاطَر تْمَنّيت لو كان كُنت أنا بالدات مَحروم من المَسيح على جال خاوتي، خاوتي اللي من زَرّيعتي على حْساب الدات، ");
INSERT INTO arq_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","اللي هومَ إسرائيلِيّين، وليهُم التَبَنّي والمَجد، والعْهود، وهِبة الشَريعة، والعِبادة والوْعود، ");
INSERT INTO arq_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","والجْدود ومَنهُم جا المَسيح على حْساب الدات، اللي هُوَ فوق كُل شي، إلَه مْبارَك للدْوام، آمين. ");
INSERT INTO arq_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ما رانيش حاب نْقول باللي كَلمة الله طاحَت، خاطَر ماشي كامَل دَرِيّة إسرائيل هومَ إسرائيل، ");
INSERT INTO arq_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","وماشي كي هومَ من سْلالة إبراهيم، كامَل وْلادو، خاطَر مَكتوب: \"من إسحاق تَتسَمّالَك الدَرِّيّة\"، ");
INSERT INTO arq_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","مَعنَتها وْلاد الدات ماشي هومَ وْلاد الله، بَصَّح وْلاد الوَعد هومَ اللي يَنحَسبو الدَرِّيّة مْتاعو، ");
INSERT INTO arq_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","خاطَر كَلمة الوَعد هَدي هِيَ: \"نْجي في هاد الوَقت ويْكون عَند سارة وْلَد\"، ");
INSERT INTO arq_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","وماشي هَكدا بَرك، بَصَّح رَفقة تاني، اللي رَفدَت من واحَد هُوَ إسحاق بابانا، ");
INSERT INTO arq_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","خاطَر، والو كانو الدْراري ما زال ما زادوش وما عَملو لا الخير لا الشَر، وباش تَتبَت خُطّة التَختيار مْتاع الله، ");
INSERT INTO arq_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ماشي على حْساب الفْعال، بَصَّح على حْساب دَعوة الله، تْقال لرَفقة: \"الكْبير يْكون خْديم الصْغير\"، ");
INSERT INTO arq_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","كيما راهو مَكتوب: \"حَبّيت يَعقوب وكْرَهت عيسو\". ");
INSERT INTO arq_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","واش نْقولو هِمّالا؟ كايَن الضُلم عَند الله؟ حاشا، ");
INSERT INTO arq_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","خاطَر يْقول لموسى: \"نَرحَم اللي نَرحَم ونَشفَق على اللي نَشفَق\"، ");
INSERT INTO arq_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","هِمّالا، الشي ما راهو لا على حْساب اللي يْحَب وَلا اللي يَسعا، بَصَّح على حْساب الله اللي يَرحَم. ");
INSERT INTO arq_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","خاطَر يْقول الكْتاب لفَرعون: \"على هاد الشي بالدات دَرتَك، باش نْبَيَّن فيك قَوّتي وباش يَتبَرَّح بآسمي في كامَل الأَرض.\" ");
INSERT INTO arq_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","هِمّالا يَرحَم اللي يْحَب ويْقَسّي اللي يْحَب. ");
INSERT INTO arq_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","تْقوللي: \"هِمّالا عْلاش يْلوم؟ خاطَر شْكون يَقدَر يْقاوَم مُرادو؟\" ");
INSERT INTO arq_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","شْكون أنتَ يا بْنادَم باش تْحاسَب الله؟ ماعون الطين يَقدَر يْقول للي خَدمو عْلاش خْدَمتني هَكدا؟ ");
INSERT INTO arq_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","الفَخّارجي ما يَحكُمش فالطين ويَخدَم من عْجينة واحدة ماعون للشان وماعون للمْهانة؟ ");
INSERT INTO arq_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","وَلاّ الله كي حَب يْوَرّي زْعافو ويْبَيَّن قَوّتو، حْمَل بصْبَر كْبير مْواعَن مْتاع الزْعاف رايحين للهْلاك، ");
INSERT INTO arq_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","وحَب يْبَيَّن غْنا المَجد مْتاعو لمْواعَن الرَحمة اللي وَجَّدهُم من قْبَل للمَجد؟ ");
INSERT INTO arq_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","وهَكدا دْعانا، ماشي بَرك حْنا اليْهود، بَصَّح حَتّى الشْعوب الأُخرين، ");
INSERT INTO arq_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","كيما يْقول في كْتاب هوشَع: \"نْسَمّي شَعبي اللي ما كانش شَعبي، ومَحبوبة اللي ما كانَتش مَحبوبة، ");
INSERT INTO arq_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ويْكون فالمْكان اللي تْقالَلهُم فيه أنتومَ ماشي شَعبي، تَم يْوَلّي يَتقالَلهُم وْلاد الله الحَي.\" ");
INSERT INTO arq_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","وإشعِيا يْقول في آمَر إسرائيل: \"كي يْكونو بْني إسرائيل كي رْمَل البْحَر، شْوِيّة منهُم بَرك اللي يَسَّلكو، ");
INSERT INTO arq_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","خاطَر الرَب يْحَقَّق بالتْمام وبالخَف كَلمتو على الأرض\". ");
INSERT INTO arq_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","وكيما قال إشعِيا من قْبَل: \"لو كان رَب الجْنود ما خَلاّنّاش دَرِّيّة، لو كان وَلّينا كيما سَدوم، مَتشابهين مع عَمورة.\" ");
INSERT INTO arq_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","واش نْقولو هِمّالا؟ باللي الكُفّار اللي ما كانوش يْحَوّسو على الصْلاح نالو الصْلاح، الصْلاح اللي يْجي من الإيمان، ");
INSERT INTO arq_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","وإسرائيل اللي كان يْحَوَّس على شَريعة الصْلاح ما وْصَلش لهاد الشَريعة. ");
INSERT INTO arq_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","وَعلاش؟ خاطَر إسرائيل ما حَوَّسش بالإيمان، وحَسبو روحهُم يَوَّصلو بعْمال الشَريعة وعلى هَدا زَدمو في حَجرة الزَدمة، ");
INSERT INTO arq_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","كيما راهو مَكتوب: \"نْحَط في صَهيون حَجرة زَدمة وصَخرة عَترة، وكُل من يامَن بيه ما يْخيبش.\" ");
INSERT INTO arq_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","يا الخاوة، الشي اللي يَتمَنّاه قَلبي واللي نَطَّلبو في صْلاتي لله هُو سْلاك بَني إسرائيل، ");
INSERT INTO arq_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","خاطَر نَشهَدَّلهُم باللي عَندهُم غيرة لله بَصَّح ماشي على حْساب عَلم مْتاع الصَح، ");
INSERT INTO arq_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","خاطَر ما عَرفوش صْلاح الله، وحَوّسو يْبَيّنو صْلاحهُم، وهومَ ماشي مَنطاعين لصْلاح الله. ");
INSERT INTO arq_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","خاطر المَسيح هُوَ اللي يْتَمَّم قَصد الشَريعة بصْلاح كامَل اللي يامنو. ");
INSERT INTO arq_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","موسى كْتَب على الصْلاح اللي بالشَريعة: \"الإنسان اللي يْطَبَّقها يْعيش بيها\"، ");
INSERT INTO arq_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","بَصَّح الصْلاح اللي بالإيمان يْقول: \"ما تْقولش في قَلبَك شْكون يَطلَع للسْما؟ خاطَر هَكدا راك تْهَبَّط المَسيح\"، ");
INSERT INTO arq_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","وَلاّ \"شْكون يَهبَط للزَرداب؟ خاطَر هَكدا راك تْعاوَد تْطَلَّع المَسيح من بين الموتى\"، ");
INSERT INTO arq_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","بَصَّح واش يْقول: \"الكَلمة راهي قْريبة ليك، في فَمَّك وفي قَلبَك\"، مَعنَتها كَلمة الإيمان اللي رانا نْبَرّحو بيها. ");
INSERT INTO arq_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","خاطَر لو كان تَستَعرَف بفُمَّك بالرَب يَسوع وتامَن في قَلبَك باللي الله حْياه مالموت، تَسلَك، ");
INSERT INTO arq_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","خاطَر نامنو بالقَلب باش نْنالو الصْلاح، ونَستَعرفو بالفُم باش نْنالو السْلاك، ");
INSERT INTO arq_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","خاطَر الكْتاب يْقول: \"اللي يامَن بيه ما يْخيبش\"، ");
INSERT INTO arq_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ما كاش فَرق بين اليْهودي واليوناني خاطَر رَبّهُم واحَد، كْريم مع كامَل اللي يَدُّكروه\"، ");
INSERT INTO arq_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","و \"كُل من يَدكُر آسَم الله يَسلَك\"، ");
INSERT INTO arq_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","بَصَّح كيفاش رايحين يَدُّكرو اللي ما آمنوش بيه؟ وكيفاش يامنو باللي ما سَمعوش بيه؟ وكيفاش يَسَّمعو لوكان ما يْكونش اللي يْبَرَّح؟ ");
INSERT INTO arq_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","وكيفاش يْبَرّحو لو كان ما يْكونوش مَبعوتين؟ كيما راهو مَكتوب: \"شْحال شابّين رَجلين اللي يْجيبو البْشايَر\"، ");
INSERT INTO arq_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","بَصَّح ماشي كامَل طاعو الإنجيل. يْقول إشعِيا: \"يا رَب، شْكون آمَن بْشارَتنا؟\" ");
INSERT INTO arq_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","هِمّالا، الإيمان يْجي بالبْشارة والبْشارة بكَلمة الله. ");
INSERT INTO arq_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","بَصَّح نْقول، بَلاك ما سَمعوش؟ بالعَكس، \"وْصَل صوتهُم لكامَل الأَرض وكْلامهُم لطَرف الدَنيا\"، ");
INSERT INTO arq_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ونْقول، بَلاك إسرائيل ما عْرَفش؟ موسى الأوَّل يْقول: \"نْغَيَّرهُم باللي ماشي أُمّة، وبأُمّة ما تْمَيَّزش نْغَزَّلهُم\"، ");
INSERT INTO arq_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ويْزيد يَوصَل إشعِيا في كْلامو ويْقول: \"خَلّيت اللي ما كانوش يْحَوّسو علِيَّ يَلقاوني، وضْهَرت للي ما طَلبونيش\"، ");
INSERT INTO arq_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ويْقول على إسرائيل: \"مَدّيت يَدّي نْهار كامَل لشَعب عاصي وراسُو خْشّين.\" ");
INSERT INTO arq_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","هِمّالا نْسَقسي: الله سْمَح في شَعبو؟ حاشا! خاطَر أنا تاني إسرائيلي، من دَرِيّة إبراهيم، من قْبيلة بَنيامين، ");
INSERT INTO arq_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","الله ما سْمَحش في شَعبو اللي عَرفو من قْبَل. ما راكُمش عارفين واش يْقول الكْتاب على إيلِيّا، كي شْكا لله من شَعب إسرائيل؟ ");
INSERT INTO arq_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","\"يا رَب، قَتلو الأنبيا مْتاعك، وكَسّرو مْدابحَك، وبْقيت أنا وَحدي وراهُم حابّين يَقُّتلوني؟\" ");
INSERT INTO arq_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","واش كان جواب الكْلام الرَبّاني؟: \"خَلّيت لِيَّ سَبع آلاف راجَل ما رَكعوش لبَعل.\" ");
INSERT INTO arq_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","في هاد الزْمان تاني، بْقا شْوِيّة مْخَيَّر بالنَعمة، ");
INSERT INTO arq_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","وَلاّ كان هاد الشي بالنَعمة، يَعني ماشي بالعْمال، وَلاّ ماكاش النَعمة ما تْوَلّيش نَعمة. ");
INSERT INTO arq_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","هِمّالا واش؟ اللي حَوَّس عليه إسرائيل ما نالوش، بَصَّح المُختارين نالوه والأخرين تْقَسّاو، ");
INSERT INTO arq_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","كيما راهو مَكتوب: \"عْطالهُم الله روح الرْقاد، عينين باش ما يْشوفوش ووَدنين باش ما يَسَّمعوش حَتّى لنْهار اليوم\"، ");
INSERT INTO arq_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","وداوَد يْقول: \"يَجعَل ميدَتهُم فَخّة وشَبكة، عَترة وعِقاب ليهم، ");
INSERT INTO arq_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","يَضلامو عينيهُم باش ما يْشوفوش ويَجعَل ضْهَرهُم دايمًا مَحني.\" ");
INSERT INTO arq_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","نْقول هِمّالا، بَلاك عَترو باش يْطيحو؟ حاشا! بَصَّح بالغَلطة مْتاعهُم وْصَل السْلاك للأمّات باش هومَ يْغيرو. ");
INSERT INTO arq_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","وَلاّ الغَلطة مْتاعهُم غْنات الدَنيا والنَقص مْتاعهُم غْنا الشْعوب، هِمّالا، واش يْدير إيمانهُم الكامَل؟ ");
INSERT INTO arq_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","نْقولَلكُم ليكُم أنتومَ الشْعوب اللي ماشي يْهود: طول ما راني رْسول ليكُم، نْمَجَّد الخَدمة مْتاعي، ");
INSERT INTO arq_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","بَلاك يْغيرو اليْهود اللي كيما أنايَ ونْسَلَّك شْوِيّة منهُم، ");
INSERT INTO arq_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","خاطَر وَلاّ كان السْماح فيهُم صالَح الدَنيا مع الله، واش يْكون قْبولهُم من غير حْياة من الموت؟ ");
INSERT INTO arq_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","وَلاّ كان الطَرف الأوّلاني مْتاع العْجين مْقَدَّس، العْجين كامَل يْكون مْقَدَّس. وَلاّ كانو العْروق مْقَدّسين، الأغصان تاني يْكونو مْقَدّسين، ");
INSERT INTO arq_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","وَلاّ كايَن غْصان نْزَبرو وأنتَ اللي من زيتونة بَرهوشة تْلَقَّمت في مْكانهُم ووَلّيت تْسال في عْروق الزيتونة المْرَبية، ");
INSERT INTO arq_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ما تَحسَبش روحَك على هاد الأغصان. وَلاّ حْسَبت روحَك، أعرَف باللي ماشي أنتَ اللي راك رافَد العْروق، العْروق هومَ اللي راهُم رافدينَك. ");
INSERT INTO arq_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","يَعني تْقول: \"الأغصان نْزَبرو باش نَتلَقَّم أنايَ\"، ");
INSERT INTO arq_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","صَحّة، هومَ نْزَبرو كي ما آمنوش وأنتَ حْكَمت بالإيمان. هِمّالا ما تَتكَبَّرش وخاف. ");
INSERT INTO arq_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","خاطَر كيما الله ما شْفَقش على الأغصان الحَقّانِيّين، بَلاك ما يَشفَقش عليك، ");
INSERT INTO arq_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","شوف المْلاحة والوْعارة مْتاع الله، واعَر مع اللي طاحو ومْليح معاك ما دامَك تابَت فالمْلاحة، وَلاّ ماكاش يَزَّبرَك، ");
INSERT INTO arq_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","وهومَ وَلاّ تابو، يَتلَقّمو خاطَر الله قادَر باش يْعاوَد يْلَقَّمهُم. ");
INSERT INTO arq_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","وَلاّ أنتَ نْزبَرت من زيتونة آصَلها بَرهوشة وتْلَقَّمت في زيتونة مْرَبية أنتَ ماشي من آصَلها، اللي من آصَلها سْبَق باش يَتلَقّمو على زيتونَتهُم. ");
INSERT INTO arq_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","راني حابكُم يا خاوتي تَعَّرفو هاد السَر باش ما تَحَّسبوش روحكُم فاهمين، باللي كايَن شْوِيّة من بْني إسرائيل طاحو فالقْساوة وهاد الشي يْدوم حَتَّى يَدُّخلو كامَل الشْعوب اللي ماشي يْهود للسْلاك، ");
INSERT INTO arq_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","وهَكدا كامَل بْني إسرائيل يَسَّلكو، كيما يْقول الكْتاب: \"يْجي السْلاك من صَهيون ويْنَحّي دْنوب بَني يَعقوب، ");
INSERT INTO arq_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ويْكون هَدا عَهدي معاهُم كي نَمحي دْنوبهُم.\" ");
INSERT INTO arq_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","من شوفة الإنجيل، هومَ عَديان على جالكُم، ومن شوفة التَخيار هومَ حْباب على جال جْدودهُم، ");
INSERT INTO arq_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","خاطَر الله ما يَندَمش على الهِبات مْتاعو وعلى دَعَّوتو، ");
INSERT INTO arq_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","وكيما أنتومَ عْصيتو الله من قْبل، ودُرك نَلتو الرَحمة على جال عَصيانهُم، ");
INSERT INTO arq_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","هكدا هومَ تاني عْصاو باش يْنالو الرَحمة هومَ تاني برَحمَتكُم، ");
INSERT INTO arq_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","خاطَر الله حْبَس كامَل الناس فالعَصيان باش يَرحَم كامَل الناس. ");
INSERT INTO arq_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","شْحال غامَق غْنا الله وحَكَّمتو وعَلمو، شْكون يَفهَم حْكامو وَلاَّ يَعرَف طُرقانو، ");
INSERT INTO arq_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","خاطَر شْكون عْرَف تَخمام الله؟ وشْكون دَبَّر عليه؟ ");
INSERT INTO arq_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","وشْكون سْبَق عْطالو باش الله يْرَدّلو؟\" ");
INSERT INTO arq_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","خاطَر منّو وبيه وليه كُل شي، ليه المَجد للأبَد. آمين. ");
INSERT INTO arq_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","على هَدا نْسَجَّعكُم يا الخاوة، برَحمة الله، أَوَّهبو داتكُم ضْحِيّة حَيّة، مْقَدّسة، تَرضي الله، وتْكون عِبادة تْليق من عَندكُم، ");
INSERT INTO arq_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ما تْتَبّعوش هاد الزْمان، أَتبَدّلو بتَجديد العْقول باش تْمَيّزو مُراد الله الخير، المْليح، والكامَل. ");
INSERT INTO arq_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","نْقول بآسَم النَعمة اللي نْوَهبَتلي، لكُل واحَد فيكُم باش ما يَحسَبش روحو فوق ما يَستهَل، بَصَّح يْكون عاقَل في تَخمامو على حْساب الإيمان اللي قَسمو الله لكُل واحَد. ");
INSERT INTO arq_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","وكيما عَندنا في دات واحدة طْراف بَزّاف، وماشي كامَل عَندهُم خَدمة واحدة، ");
INSERT INTO arq_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","هَكدا، حْنا بَزّاف بَصَّح دات واحدة فالمَسيح، نْسالو كُل واحَد في بَعضنا بَعض. ");
INSERT INTO arq_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","عَندنا هِبات ماشي كيف كيف على حْساب النَعمة اللي نَعطاتَلنا، اللي عَندو هِبة النُبُوّة، يَتنَبَّأ على حْساب إيمانو، ");
INSERT INTO arq_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","اللي عَندو دَعوة الخَدمة، يَتعَلَّق بالخَدمة، اللي يْعَلَّم يْشَد فالتَعليم، ");
INSERT INTO arq_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","اللي يْسَجَّع فالتَسجيع، اللي يْمَد يْكون كْريم كي يْمَد، اللي يْسَيَّر يْسَيَّر بالطْبَع واللي يَرحَم بالفَرح. ");
INSERT INTO arq_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","المْحَبّة لازَم تْكون بلا تْنوفيق، أَكَّرهو الشَر وأتعَلّقو بالخير، ");
INSERT INTO arq_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","حَنّو على بَعضكُم بَعض بمْحَبّة الخاوة. كُل واحَد يْقادَر خوه ويْقَدّمو على نَفسو. ");
INSERT INTO arq_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","كونو شاطرين وماشي فَنيانين، سْخونين فالروح، عابدين الرَب، ");
INSERT INTO arq_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","فَرحانين فالرْجا، صابرين فالشَدّة، مْداومين فالصْلاة، ");
INSERT INTO arq_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","مْعاونين للقَدّيسين، مسترحبين بالبرانيين. ");
INSERT INTO arq_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","باركو اللي يَحَّڤروكُم، باركو وما تَنَّعلوش، ");
INSERT INTO arq_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","أفَّرحو مع الفَرحانين وأبكيو مع الباكيين، ");
INSERT INTO arq_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","كونو مَتفاهمين بيناتكُم، ما تْحَوّسوش على الحاجات الكْبار، وشَدو فالحاجات الصْغار، وما تَحَّسبوش روحكُم فاهمين. ");
INSERT INTO arq_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ما تْرَدّو الشَر بالشَر لحَتّى واحَد، حَوّسو على الخير لكامَل الناس. ");
INSERT INTO arq_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ديرو مَجهودكُم باش يْكون السْلام بينكُم وبين كامَل الناس. ");
INSERT INTO arq_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ما تَنتَقموش لنْفوسكُم يا الحْباب وخَلّيو الزْعاف يْجوز، خاطَر مَكتوب: \"أنا اللي نَنتَقَم وأنا اللي نْجازي، يْقول الرَب.\" ");
INSERT INTO arq_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","بَصَّح \"وَلاّ جاع عْدوك وَكّلو، وَلاّ عْطَش أَرويه، خاطَر كي تْدير هَكدا راك تْلَم جْمَر النار فوق راسو\"، ");
INSERT INTO arq_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ما تْخَلّيش الشَر يَغَّلبَك وأغلَب الشَر بالخير. ");
INSERT INTO arq_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","كُل واحَد لازَم يَنطاع للي يَحُّكمو فيه، خاطَر ما كان حَتّى حاكَم ماشي من عَند الله والله هُوَ اللي دار الحُكّام اللي كاينين، ");
INSERT INTO arq_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","على هَدا، اللي يْقاوَم الحاكَم يْقاوَم آمَر الله، واللي يْقاومو، يَتعاقبو. ");
INSERT INTO arq_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","خاطَر الحاكَم يْخَوَّف اللي يْدير الدوني بَصَّح اللي يْدير المْليح ما عَندوش عْلاش يْخاف. حَبّيت ما تْخافش الحاكَم؟ دير المْليح يَرضا عليك. ");
INSERT INTO arq_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","خاطَر الحاكَم خَدّام الله لصْلاحَك، بَصَّح وَلاّ دَرت الشَر خاف، خاطَر ما راهوش شايَد السيف على والو. راهو يَخدَم الله، ويْعاقَب اللي يْدير الشَر، ");
INSERT INTO arq_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","على هَدا، طيع ماشي بَرك على جال العِقاب، على جال الضَمير. ");
INSERT INTO arq_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","على هَدا اللي تْخَلّصو الغْرامة، خاطَر الحُكّام خَدّامين عَند الله، قايمين على هاد الخَدمة. ");
INSERT INTO arq_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","أعطيو لكُل واحَد حَقّو: الغْرامة للي يْسال عَندكُم الغْرامة، الدِيّة للي يْسال الدِيّة، الخوف للي لازَم تْخافوه، القْدَر للي لازَم تْقادروه. ");
INSERT INTO arq_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ما تْكونو مَديونين لحَتّى واحَد من غير بالمْحَبّة، خاطَر اللي يْحَب كَمَّل الشَريعة، ");
INSERT INTO arq_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","والفْرايَض: \"ما تَزنيش، ما تُقتَلش، ما تَسرَقش، ما تَتشَهّاش،...\" وكامَل الفْرايَض الأخرين يَتلَخّصو في هاد الكَلمة: \"حَب قْريبَك كي نَفسَك\"، ");
INSERT INTO arq_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","المْحَبّة ما تْضَرش، يَعني المْحَبّة هِيَ اللي تْكَمَّل الشَريعة. ");
INSERT INTO arq_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","راكُم عارفين الوَقت اللي رانا فيه، هَدا هُوَ الوَقت باش تْنوضو من نْعاسُكم، خاطَر سْلاكنا راهو دُرك قْريب كْتَر من الوَقت اللي آمَّنا فيه. ");
INSERT INTO arq_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","جاز الليل وقْريب يَطلَع النْهار. هَيّا نْبَعّدو من عْمال الضْلام ونَلَّبسو سْلاح النور، ");
INSERT INTO arq_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","نَمشيو كيما يْليق باللي يَمشي فالضو، نْبَعّدو على كترة الماكلة، السَكرة، الفَسق، العيب، الدْواس والحْسَد. ");
INSERT INTO arq_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","إيه، ألَّبسو الرَب يَسوع المَسيح وما تْخَمّموش على الدات باش تَرضيو شَهواتها. ");
INSERT INTO arq_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","أقَّبلو الضْعيف فالإيمان بلا ما تْناقشوه فالتَخمام مْتاعو، ");
INSERT INTO arq_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","واحَد يامَن باللي يَقدَر ياكُل من كُل شي، واحَدآخُر ضْعيف ياكُل غير الخُضرة. ");
INSERT INTO arq_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","اللي ياكُل ما لازَمش يَحڤَر اللي ما ياكُلش، واللي ما ياكُلش ما لازَمش يَحكَم على اللي ياكُل خاطَر الله قَبلو، ");
INSERT INTO arq_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","شْكون أنتَ باش تَحكُم على خَدّام غيرَك؟ يَبقا تابَت وَلاّ يْطيح، هاد الشي يْخُص مولاه. بَصَّح يَبقا تابَت خاطَر الرَب قادَر باش يْتَبّتو. ");
INSERT INTO arq_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","كايَن اللي يْفَرَّق بين اليامات، وكايَن اللي شايَفهُم كامَل كيف كيف، لازَم كُل واحَد يْكون مَقتَنع في عَقلو. ");
INSERT INTO arq_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","اللي يْمَيَّز بين اليامات يْمَيَّزهُم للرَب، اللي ياكُل ياكُل للرَب خاطَر راه يَحَّمدو، واللي ما ياكُلش، ما ياكُلش للرَب وهُوَ تاني يَحمَد الله. ");
INSERT INTO arq_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","واحَد فينا ما يْعيش لروحو، وواحَد ما يْموت لروحو. ");
INSERT INTO arq_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","وَلاّ رانا عايشين، عايشين للرَب وَلاّ مَتنا نْموتو للرَب. نْعيشو وَلاّ نْموتو، حْنا مْتاع الرَب، ");
INSERT INTO arq_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","خاطَر المَسيح مات وحْيا، باش يْكون سيد الحَيّين والموتى. ");
INSERT INTO arq_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","وأنتَ، عْلاش تَحكُم على خوك؟ ووَعلاش أنتَ تَحڤَر خوك؟ ياخي كامَل رايحين نَوَّقفو فالشْرَع قُدام الله. ");
INSERT INTO arq_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","مَكتوب: \"أنا حَي، يْقول الرَب، كُل رُكبة تَركَع قُدّامي وكُل لْسان يَحمَد الله\"، ");
INSERT INTO arq_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","هَكدا، كُل واحَد فينا يَتحاسَب قُدّام الله. ");
INSERT INTO arq_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","يَعني، ما لازَمش نَحَّكمو على بَعضنا بَعض، بَصَّح رَدّو بالكُم باش حَتّى واحَد فيكُم ما يْكون سَبّة تْعَتَّر خوه وَلاّ تْطَيّحو. ");
INSERT INTO arq_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","راني عارَف ومَقتَنَع فالرَب يَسوع باللي ما كاش حاجة ناجسة في داتها، بَصَّح الحاجة تْكون ناجسة للي يْشوفها ناجسة. ");
INSERT INTO arq_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","وَلاّ على جال ماكلة تْضَر خوك، ما راكش تَمشي على حْساب المْحَبّة، ما تْخَلّيش ماكَلتَك تْضَيَّع هَداك اللي المَسيح مات على جالو. ");
INSERT INTO arq_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","الشي اللي تْشوفو مْليح، ما لازَمش يْسيب حَتّى يَتقال عليه الكْلام الدوني، ");
INSERT INTO arq_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","خاطَر مَلَكوت الله ماشي الماكلة والشُرب. مَلَكوت الله صْلاح، سْلام، وفَرح فالروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","اللي يَخدَم المَسيح هَكدا، يَرضا عليه الله ويَشُّكروه الناس. ");
INSERT INTO arq_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","هَيّا نْحَوّسو هِمّالا على الشي اللي يْوَصَّلنا للسْلام ويْوَصَّلنا باش نَبنيو بَعضنا بَعض. ");
INSERT INTO arq_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ما تْهَدش خَدمة الله على جال لُقمة، فالصَح، كُل شي طاهَر، بَصَّح ماشي مْليح لبْنادَم باش يْكون سْباب عَترة على جال الماكلة. ");
INSERT INTO arq_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","مْليح كي الواحَد ما ياكُلش اللْحَم، ما يَشرُبش الشْراب ويْبَعَّد على الشي اللي يْعَتَّر خوه. ");
INSERT INTO arq_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","إيمانَك أنتَ خَلّيه ليك وَحدَك قُدّام الله. يا سَعد اللي يْدير الشي اللي يْكون مَقتَنَع بيه بلا ما يَحكُم على نَفسو، ");
INSERT INTO arq_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","بَصَّح اللي يْشَك في ماكَلتو، يَتَّحكَم عليه خاطَر ما راهوش مَقتَنَع، وكُل حاجة ما تْجيش بالإيمان خْطِيّة. ");
INSERT INTO arq_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","حْنا اللي قْوِيّين فالإيمان، لازَم نَرَّفدو ضَعف اللي ماشي قْوِيّين، وما نْرَضّيوش روحنا بَرك. ");
INSERT INTO arq_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","كُل واحَد فينا لازَم يَرضي الآخُر، للخير، للبَنيان، ");
INSERT INTO arq_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","خاطَر المَسيح بالدات ما رَضّاش نَفسو، كيما يْقول الكْتاب: \"مْعايرات اللي يْعايروك طاحو عْلِيَّ\"، ");
INSERT INTO arq_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","خاطَر كُل شي نَكتَب من قْبَل، نَكتَب باش يْعَلَّمنا، باش بالصْبَر والعْزا مْتاع الكْتوب يْكون عَندنا الرْجا. ");
INSERT INTO arq_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","رَب الصْبَر والعْزا يَجعَلكُم مَتفاهمين باش تْعيشو مع بَعضكُم بَعض على حْساب المَسيح يَسوع، ");
INSERT INTO arq_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","باش بنَفس واحدة وفُم واحَد تْعَضّمو رَب وآب رَبّنا يَسوع المَسيح، ");
INSERT INTO arq_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","على هَدا، أقَّبلو بَعضكُم بَعض كيما قْبَلكُم المَسيح لمَجد الله. ");
INSERT INTO arq_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","نْقولَلكُم باللي المَسيح وَلاّ خَدّام للمْخَتّنين باش يْبَيَّن حَق الله ويْحَقَّق وْعودو للجْدود. ");
INSERT INTO arq_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","اللي ماشي يْهود يْعَضّمو الله على جال رَحَّمتو كيما يْقول الكْتاب: \"على هَدا نَحتَفل بيك ما بين الشْعوب ونْغَنّي لآسمَك\"، ");
INSERT INTO arq_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ويْقول: \"أفَّرحو يا أُمّات مع شَعبو\"، ");
INSERT INTO arq_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","وتاني: \"سَبّحو الرَب يا أُمّات كامَل، وأحَّمدوه يا شْعوب كامَل\". ");
INSERT INTO arq_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","إشعِيا تاني يْقول: \"يْجي وْليد يَسّى، ويْنوض باش يَحكُم الأُمّات والأُمّات يَرجاو فيه\". ");
INSERT INTO arq_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","رَب الرْجا يْعَمَّركُم بكُل فَرح وسْلام فالإيمان باش يْفيض رْجاكُم بقُدرة الروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","من جيهَتكُم، يا خاوتي، راني أنا مَتيَقَّن باللي قَلبكُم كْبير، تَعَّرفو مْليح كُل حاجة وقادرين تَنصحو بَعضكم بَعض. ");
INSERT INTO arq_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","بَصَّح، سْمَحت لنَفسي وكْتَبتَلكُم في شي حاجات باش نْفَكَّركُم فيهُم على جال النَعمة اللي تْوَهبَتلي، ");
INSERT INTO arq_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","باش نْكون خَدّام المَسيح عَند اللي ماشي يْهود، وأنا مْكَرَّس نَفسي لإنجيل الله باش تْكون هِبة اللي ماشي يْهود مَقبولة، على حْساب اللي تْقَدّسَت بالروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","نَفخَر فالمَسيح يَسوع بالخَدمة لله، ");
INSERT INTO arq_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","خاطَر ما نَقدَر نَدكُر حَتّى حاجة من غير الشي اللي عَملو المَسيح بِيَّ باش يْجيب اللي ماشي يْهود للطاعة بالكْلام وبالفْعال. ");
INSERT INTO arq_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","بقُوّة المارات والعْجايَب وبقُوّة روح الله كَمَّلت التَبشير بإنجيل المَسيح من أورشَليم والمْدارَب اللي دايرين بيها حَتّى لإيليريكون. ");
INSERT INTO arq_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","هَكدا حَبّيت نْبَشَّر وين ما تْبَرَّحش بالمَسيح باش ما نَبنيش على لْساس غيري. ");
INSERT INTO arq_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","على حْساب واش يْقول الكْتاب: \"اللي ما تْبَرَّحَّلهُمش بيه يْشوفو واللي ما سَمعوش بيه يَفَّهمو.\" ");
INSERT INTO arq_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","على هَدا، اللي شْحال من مَرّة ما قْدَرتش نْجي لعَندكُم. ");
INSERT INTO arq_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","بَصَّح دُرك، ما عَنديش خَدمة تْشَدّني في هاد المْدارَب وراني من سْنين حاب بَزّاف نْجيكُم، ");
INSERT INTO arq_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","كي نْروح لسْبانيا، نَتمَنّا نْجوز نْشوفكُم أومبَعد تْوَصّلوني لتَمّة وَلاّ شْبَعت شْوِيّة مَنكُم. ");
INSERT INTO arq_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","دُرك، راني رايَح لأورشَليم باش نَخدَم القَدّيسين، ");
INSERT INTO arq_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","خاطَر ناس مَقدونية وأخّائية حَبّو يْعاونو القَدّيسين الڤْلالين اللي في أورشَليم. ");
INSERT INTO arq_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","هَكدا حَبّو، وكانو مَديونينَلهُم. خاطَر وَلاّ شاركوهُم فالحاجات الروحِيّين، لازَم يْعاونوهُم فالحاجات الإنسانِيّين. ");
INSERT INTO arq_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","بَعد ما نْكَمَّل هاد الخَدمة ونْوَصَّل الأمانة، نْجوز عليكُم ونْروح لسْبانيا. ");
INSERT INTO arq_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","راني عارَف باللي كي نْجي لعَندكُم، نْجي ببَركة كاملة من المَسيح. ");
INSERT INTO arq_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","نْسَجَّعكُم يا الخاوة، برَبّنا يَسوع المَسيح، وبمْحَبّة الروح باش تْكافحو معايَ وتْصَلّيو لله على جالي، ");
INSERT INTO arq_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","باش نَسلَك من اللي ماشي مومنين فاليَهودِيّة وباش الأمانة اللي نَدّيها لأورشليم تْكون مَقبولة عَند القَدّيسين، ");
INSERT INTO arq_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","وباش نْجيكُم فَرحان وَلاّ هَدا مُراد الله ونْرَيَّح عَندكُم شْوِيّة. ");
INSERT INTO arq_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","رَب السْلام مْعاكُم كامَل. آمين. ");
INSERT INTO arq_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","نْوَصّيكُم على فيبي، خُتنا اللي راهي تَخدَم في كَنيسة كَنخَريا، ");
INSERT INTO arq_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","باش تَستَقبلوها فالرَب كيما يْليق بالقَدّيسين، وتْعاونوها في كُل شي تَسحَقكُم فيه، خاطَر هِيَ عاونَت ناس بَزّاف وأنا واحَد مَنهُم. ");
INSERT INTO arq_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","سَلّمو على بْرِسكا وأكيلا اللي عاونوني في خَدمة المَسيح، ");
INSERT INTO arq_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","وسَبّلو حْياتهُم على جال حْياتي. ماشي غير أنا اللي نَشكُرهُم، كامَل كْنايَس اللي ماشي يْهود يَشُّكروهُم، ");
INSERT INTO arq_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","سَلّمو تاني على الكَنيسة اللي راهي في دارهُم. سَلّمو على حْبيبي أبينتوس، أَوَّل مَسيحي في آسيا. ");
INSERT INTO arq_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","سَلّمو على مَريَم اللي تَعبَت بَزّاف على جالكُم، ");
INSERT INTO arq_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","سَلّمو على أندرونيكوس ويونياس، مْوالِيَّ وصْحابي فالحَبس. مَعروفين هومَ بين الرُسُل وآمنو بالمَسيح قْبَل مَنّي، ");
INSERT INTO arq_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","سَلّمو على أمبِلياس، حْبيبي فالرَب. ");
INSERT INTO arq_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","سَلّمو على أوربانوس اللي عاوَنّا في خَدمة المَسيح وعلى حْبيبي إستاخيس، ");
INSERT INTO arq_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","سَلّمو على أبُلُّس اللي بَرهَن على تْباتو فالمَسيح، سَلّمو على دار أرِستوبولوس، ");
INSERT INTO arq_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","سَلّمو على هيروديون اللي يْكونلي، سَلّمو على المومنين اللي في دار نَركيسوس، ");
INSERT INTO arq_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","سَلّمو على تْريفينا وتْريفوسا اللي تَعبو في خَدمة الرَب، سَلّمو على بَرسيس الحْبيبة اللي تَعبَت بَزّاف في خَدمة المَسيح، ");
INSERT INTO arq_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","سَلّمو على روفَس المُختار فالرَب وعلى يَمّاه ويَمّا أنا تاني، ");
INSERT INTO arq_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","سَلّمو على أسينكريتس، وفْليغون، وهَرمَس، وبَتروباس، وهَرماس والخاوة اللي مْعاهُم، ");
INSERT INTO arq_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","سَلّمو على فيلولوغوس وجوليا ونيريوس وخْتو وأولمباس والقَدّيسين اللي مْعاهُم، ");
INSERT INTO arq_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","سَلّمو على بَعضكُم بَعض ببوسة مْقَدّسة، كامَل كنايَس المَسيح يْسَلّمو عْليكُم. ");
INSERT INTO arq_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","نْوَصّيكُم يا الخاوة باش تْرَدّو بالكُم من اللي يْحَبّو يْدَخّلو العْداوة والعَترة ويَخَّلقو تَعليم مْخالَف للتَعليم اللي تْعَلَّمتوه. بَعّدو عْليهُم، ");
INSERT INTO arq_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","خاطَر هاد الناس ما يَخَّدموش رَبنا المَسيح، يَخَّدمو كْروشهُم وبكْلامهُم المْليح وهَدرَتهُم المْعَسّلة يَغويو قْلوب النْوايا. ");
INSERT INTO arq_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","كامَل سَمعو بطاعَتكُم، وأنا راني فَرحان بَزّاف بيكُم، نْحَبّكُم تْكونو شاطرين فالخير وصافيين من الشَر، ");
INSERT INTO arq_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","رَب السْلام قْريب يعفس الشيطان تَحت رَجليكُم، نَعمة رَبّكُم يَسوع معاكُم، آمين. ");
INSERT INTO arq_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","تيموتاوَس اللي راهو يَخدَم معايَ ولوكيوس وياسون وسوسيباترُس اللي يْكونولي راهُم يْسَلّمو عْليكُم. ");
INSERT INTO arq_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","وراني أنا تَرتيوس اللي كْتَبت هاد البْرِيّة، نْسَلَّم عْليكُم فالرَب، ");
INSERT INTO arq_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","يْسَلَّم عْليكُم غايوس اللي راهو مْضَيَّفني أنا والكَنيسة كامَل، أراستُس أمين صَندوق المْدينة والأخ كوارتُس يْسَلّمو عليكُم. ");
INSERT INTO arq_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","نَعمة رَبّنا يَسوع المَسيح مْعاكُم، آمين. ");
INSERT INTO arq_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","للي يَقدَر يْتَبَّتكُم على حْساب إنجيلي والبْشارة بيَسوع المَسيح، على حْساب مَعرِفة السَر اللي بْقا مْخَبّي زْمان طْويل، ");
INSERT INTO arq_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","واللي بان دُرك بكْتوب الأَنبِيا، على حْساب آمَر الله الأبَدي واللي نَعرَف عَند كامَل الأُمّات باش يْجيو لطاعة الإيمان، ");
INSERT INTO arq_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","الله الحْكيم وَحدو، ليه المَجد للأبَد بيَسوع المَسيح. آمين.");
INSERT INTO arq_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","بولَس، المَدعو باش نْكون رَسول يَسوع المَسيح، بمُراد الله، والأَخ سوستانيس، ");
INSERT INTO arq_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","لكَنيسة الله اللي في كورَنتوس، للّي تْقَدّسو فالمَسيح يَسوع، المَدعُوّين باش يْكونو قَدّيسين، ولكامَل اللي يَدُّكرو في كُل مْكان آسَم رَبّنا يَسوع المَسيح، رَبّهُم ورَبّنا. ");
INSERT INTO arq_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","نَعمة وسْلام ليكُم من الله بابانا والرَب يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","نَحمَد إلَهي دايمًا عليكُم على جال نَعمة الله اللي نَعطاتَلكُم فالمَسيح يَسوع، ");
INSERT INTO arq_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","خاطَر فيه نَغنيتو بكُل شي، بكُل كَلمة وكُل مَعرِفة، ");
INSERT INTO arq_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","على حْساب اللي تَبتَت فيكُم شْهادة المَسيح، ");
INSERT INTO arq_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","باش ما تْخَصّكُم حَتّى موهِبة، وأنتومَ تَستَنّاو رَبّنا يَسوع المَسيح يَنكشَف، ");
INSERT INTO arq_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","هُوَ اللي يْتَبَّتكُم حَتّى الأخَّر، باش ما تْكونوش ناقصين في يوم رَبّنا يَسوع المَسيح، ");
INSERT INTO arq_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","الله حْلالي اللي دْعاكُم للشَركة مع وْليدو يَسوع المَسيح رَبّنا. ");
INSERT INTO arq_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","نْسَّجعكُم يا الخاوة بآسَم رَبّنا يَسوع المَسيح باش تْكون هَدرَتكُم واحدة وما تَنقَسموش. كونو مَتوَحّدين، بعْقَل واحد وتَخمام واحَد، ");
INSERT INTO arq_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","خاطَر يا خاوتي، راني سْمَعت عليكُم من ناس دار خُلوي باللي كايَن الدْواس ما بيناتكُم، ");
INSERT INTO arq_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","يَعني نْقول هاد الشي، خاطَر كُل واحَد فيكُم يْقول \"أنا من بولَس\"، \"أنا من أبُلّوس\"، \"أنا من صَفا\"، \"أنا من المَسيح\"، ");
INSERT INTO arq_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","المَسيح نَقسَم؟ بولَس نَصلَب على جالكُم وَلاّ بآسَم بولَس اللي تْعَمَّدتو؟ ");
INSERT INTO arq_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","نَحمَد الله اللي ما عَمَّدت حَتّى واحَد فيكُم من غير كِريسبوس وغايوس، ");
INSERT INTO arq_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","باش واحَد ما يْقول باللي تْعَمَّدتو بآسمي. ");
INSERT INTO arq_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","عَمَّدت تاني عايلة أستِفاناس، ومن غيرهُم ما نَدكُرش اللي عَمَّدت كاش واحَد. ");
INSERT INTO arq_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","خاطَر المَسيح ما بْعَتنيش باش نْعَمَّد، بْعَتني باش نْبَشَّر، وماشي بالعْقَل اللي فالكْلام باش صْليب المَسيح ما يْكونش باطَل. ");
INSERT INTO arq_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","إيه، مَنطَق الصْليب ما عَندو حَتّى مَعنى للي رايحين في طْريق الهْلاك، بَصَّح لينا حْنا اللي ماشيين في طْريق السْلاك، هُوَ قُدرة الله، ");
INSERT INTO arq_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","خاطَر مَكتوب: \"نَمحي عْقَل الحُكما ونَرمي فْهامة الفاهمين\"، ");
INSERT INTO arq_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","وين راه الفاهَم؟ وين راه الكاتَب؟ وين راه اللي يْناقَش في هاد الزْمان؟ عْلاش؟ الله ما رَدش عْقَل هاد الدَنيا جْياحة؟ ");
INSERT INTO arq_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","كي الدَنيا بالعْقَل مْتاعها ما عَرفَتش الله بحِكمة الله، حَب الله يْسَلَّك المومنين بهْبال البْشارة، ");
INSERT INTO arq_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","اليْهود يَطَّلبو مارات، واليونانِيّين يْحَوّسو على الحِكمة، ");
INSERT INTO arq_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","حْنا نْبَرّحو بالمَسيح المَصلوب، عَترة لليْهود وهْبال عَند الكُفّار، ");
INSERT INTO arq_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","بَصَّح للمَدعُوّين، يْهود وَلاّ يونانِيّين، المَسيح هُوَ قُدرة الله وحِكمة الله، ");
INSERT INTO arq_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","خاطَر هْبال الله عاقَل على بْني آدَم وضَعف الله قْوي على بْني آدَم. ");
INSERT INTO arq_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","شوفو روحكُم يا الخاوة، أنتومَ اللي دْعاكُم الله، ما كانش فيكُم بَزّاف الحُكما بحِكمة بْني آدَم، وما كانش بَزّاف اللي عَندهُم القُوّة وما كانش بَزّاف اللي من العايلات الكْبار، ");
INSERT INTO arq_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","بالعَكس، الله خَيَّر الجْياحة فالدَنيا باش يْحَشَّم الحُكَما والضْعاف فالدَنيا باش يْحَشَّم اللي عَندهُم القُوّة، ");
INSERT INTO arq_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","وخَيَّر الصْغير والمَحڤور واللي ما عَندوش قيمة فالدَنيا، باش يْكَسَّر اللي عاطيَتلو الدَنيا قيمة، ");
INSERT INTO arq_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","باش حَتّى مَخلوق ما يَحسَب روحو قُدّام الله. ");
INSERT INTO arq_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","بيه اللي راكُم فالمَسيح يَسوع، اللي وَلاّ حِكمة لينا من عَند الله، وصْلاح وقَداسة وفْدا. ");
INSERT INTO arq_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","هِمّالا، كيما يْقول الكْتاب: \"اللي يَتباها، يَتباها فالرَب.\" ");
INSERT INTO arq_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","وأنا كي جيتكُم يا الخاوة، ما جيتكُمش بالكْلام الصْعيب والحِكمة نْخَبَّركُم بسَر الله، ");
INSERT INTO arq_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","وعَوَّلت ما نَعرَف وأنا عَندكُم حَتّى شي من غير يَسوع المَسيح، ويَسوع المَسيح مَصلوب، ");
INSERT INTO arq_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","وكُنت وأنا عَندكُم ضْعيف وخايَف نَتَّرعَد. ");
INSERT INTO arq_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","الخُطبة مْتاعي وبْشارتي ما كانوش يْقَنّعو بكْلايَم الحِكمة، كانو قايمين على بُرهان الروح والقُوّة، ");
INSERT INTO arq_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","باش يْكون إيمانكُم بقُدرة الله ماشي بحِكمة بْني آدَم. ");
INSERT INTO arq_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","وهَكداك، هَدي الحِكمة اللي نَهَّدروها للناس الراشدين، بَصَّح ماشي حِكمة هاد الدَنيا، وَلا سْياد هاد الدَنيا اللي رايحين للهْلاك. ");
INSERT INTO arq_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","نَهَّدرو بحِكمة الله المْخَبّية فالسَر، اللي نْحَجبَت، واللي سْبَق وَجَّدها الله قْبَل الزْمان لمَجدنا، ");
INSERT INTO arq_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","وما عْرَفها حَتّى واحَد من سْياد هاد الدَنيا، خاطَر لو كان عَرفوها ما كانوش صَلبو رَب المَجد، ");
INSERT INTO arq_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","كيما يْقول الكْتاب: \"اللي ما عين راتو، وَلا وْدَن سَمعاتو، وَلا جا في بال بْنادَم، هَداك اللي وَجّدو الله للّي يْحَبّوه.\" ");
INSERT INTO arq_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","لينا اللي كَشفو الله بالروح، خاطَر الروح يَفحَص كُل شي، حَتّى غْوامَق الله. ");
INSERT INTO arq_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","شْكون من الناس هِمّالا يَعرَف أُمور بْنادَم من غير روح بْنادَم اللي فيه؟ هَكداك واحَد ما يَعرَف ما فالله من غير روح الله. ");
INSERT INTO arq_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","حْنا ماشي روح الدَنيا اللي نَلنا، نَلنا الروح اللي جاي من الله باش نَعَّرفو الحاجات اللي وْهَبهُمَّلنا الله، ");
INSERT INTO arq_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","وما نَهَّدروش على هاد الشي بالكْلام اللي نَتعَلّموه من حِكمة بْني آدَم، نَهَّدرو عليه بالكْلام اللي يْعَلّمهولنا الروح، وهَكدا نَفَّسرو شيّ الروح بكْلام الروح. ");
INSERT INTO arq_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","بْنادَم بمَنطَق بْني آدَم ما يَقدَرش يَقبَل أُمور روح الله خاطَر يْشوفها جْهولِيّة، وما يَقدَرش يَفهَمهُم خاطَر الروح اللي يْمَيَّزهُم، ");
INSERT INTO arq_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","بَصَّح الروحي، يْمَيَّز كُل شي بَصَّح واحَد ما يَقدَر يْمَيّزو، ");
INSERT INTO arq_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","خاطَر \"شْكون عْرَف تَخمام الرَب؟ شْكون يَقدَر يْعَلّمو؟\" حْنا عَندنا عَقليّة المَسيح. ");
INSERT INTO arq_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","أنا يا الخاوة، ما قْدَرتش نْكَلَّمكُم كيما نْكَلَّم ناس روحِيّين، كَلَّمتكُم كيما نْكَلَّم ناس جَسَدِيّين، دْراري صْغار فالمَسيح، ");
INSERT INTO arq_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","شَرَّبتكُم حْليب، ماشي ماكلة صْحيحة، خاطَر ما كُنتوش تَقَّدرولها وللآن ما تَقَّدروش، ");
INSERT INTO arq_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","خاطَر مازالكُم جَسَدِيّين. كي كايَن بيناتكُم الغيرة والدْواس، ماشي جَسَدِيّين أنتومَ؟ وتْعيشو على حْساب الدات؟ ");
INSERT INTO arq_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","كي الواحَد يْقول: \"أنا من بولَس\"، والآخُر: \"أنا من أبُلّوس\"، ماشي آدَمِيّين أنتومَ؟ ");
INSERT INTO arq_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","واش يْكون أبُلّوس؟ واش يْكون بولَس؟ خَدّامين آمَنتو على يَدّهُم، كُل واحَد فيهُم على حْساب ما عْطاه الله. ");
INSERT INTO arq_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","أنا غْرَست، أبُلّوس سْقا، بَصَّح الله هُوَ اللي كَبَّر. ");
INSERT INTO arq_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","الصَح ماشي فاللي يَغرَس وَلاّ فاللي يَسقي، الصَح فالله اللي يْكَبَّر، ");
INSERT INTO arq_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","اللي يَغرَس واللي يَسقي كيف كيف وكُل واحَد يَدّي آجرو على حْساب خَدَّمتو. ");
INSERT INTO arq_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","حْنا نَخَّدمو سْواسوة عَند الله، أنتومَ بْحيرة الله، بَنيان الله، ");
INSERT INTO arq_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","على حْساب نَعمة الله اللي نْوَهبَتلي، كي البَنّاي الشاطَر حَطّيت اللْساس، وواحَدآخُر بْنا فوقو، بَصَّح لازَم الواحَد يْرَد بالو كيفاش يَبني، ");
INSERT INTO arq_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","خاطَر واحَد ما يَقدَر يْحَط لْساس واحَدآخُر من غير اللي راهو مَحطوط اللي هُوَ يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","الواحَد يَبني فوقو بالدْهَب، الفَضّة، الجوهَر، الحْطَب، الحْشيش وَلاّ الكْران، ");
INSERT INTO arq_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","خَدمة كُل واحَد تْبان، النْهار يْبَيَّنها. خَدمة كُل واحَد، كيما كان نوعها، النار تْجَرَّبها. ");
INSERT INTO arq_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","الواحَد اللي تَبقا الخَدمة اللي بْناها، يَدّي الآجَر. ");
INSERT INTO arq_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","اللي تْنَحرَق خَدَّمتو، يَخسَر الآجَر، هُوَ يَسلَك بَصَّح كي اللي يْجوز فالنار. ");
INSERT INTO arq_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ما راكُمش عارفين باللي أنتومَ مَعبَد الله وروح الله ساكَن فيكُم؟ ");
INSERT INTO arq_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","اللي يْهَد مَعبَد الله، الله يْهَدّو، خاطَر مَعبَد الله قُدّوس يَعني أنتومَ. ");
INSERT INTO arq_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","واحَد ما يْغَر نَفسو، وَلاّ واحَد فيكُم حْسَب روحو حْكيم في هاد الزْمان، غير يْكون جاهَل باش يْوَلّي حْكيم، ");
INSERT INTO arq_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","خاطَر حَكمة هاد الدَنيا جْهولِيّة عَند الله، خاطَر مَكتوب: \"اللي يَدّي الحُكَما في حيلَتهُم\"، ");
INSERT INTO arq_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","وتاني: \"الرَب يَعرَف تَخمام الحُكَما باللي باطَل\"، ");
INSERT INTO arq_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","هِمّالا ما يْغَركُم حَتّى واحَد، خاطَر كُل شي ليكُم. ");
INSERT INTO arq_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","بولَس، وَلاّ أبُلّوس، وَلاّ صَفا، وَلاّ الدَنيا، وَلاّ الحْياة، وَلاّ الموت، وَلاّ أُمور الحاضَر والجاي، كُل شي ليكُم، ");
INSERT INTO arq_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","وأنتومَ للمَسيح، والمَسيح لله. ");
INSERT INTO arq_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","هِمّالا، غير يَحَّسبونا خَدّامين ومْوَكّلين على سْرار الله، ");
INSERT INTO arq_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","المَطلوب من المْوَكّلين قْبَل كُل شي يْكونو حْلالِيّين. ");
INSERT INTO arq_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","أنا ما يْهَمّنيش كيفاش تَحَّكمو علِيَّ أنتومَ وَلاّ كيفاش يَحكَم علِيَّ الشْرَع مْتاع بْنادَم. أنا تاني ما نَحكُمش على نَفسي، ");
INSERT INTO arq_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","أنا ما عَندي في ضَميري حَتّى شي ضَد نَفسي، بَصَّح في هاد الشي اللي تْبَرَّرت. اللي يَحكُم عليَّ هُوَ الرَب، ");
INSERT INTO arq_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","هِمّالا ما تَحَّكموش قْبَل الوَقت، قْبَل ما يْجي الرَب ويْوَرّي فالضو الشي المْخَبّي فالضَلمة ويْبَيَّن نِيّات القْلوب. داك الوَقت الله يَمدَح كُل واحَد على حْساب ما يَستاهَل. ");
INSERT INTO arq_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","هاد الحاجات دُرك يا الخاوة، مَتَّلت بيهُم علِيَّ وعلى أبّولوس على جالكُم، باش تَتعَلّمو منّا \"ما تْجوزوش حْدود الكْتوب\"، وما تَتكَبّروش وأنتومَ دايرين الصَف مع واحَد ضَد الآخُر. ");
INSERT INTO arq_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","واش يْمَيّزَك على واحَدآخُر؟ واش عَندَك من عَندَك ما نَلتوش؟ وَلاّ نَلتو وَعلاش تَتباها كي اللي من عَندَك وما نَلتوش؟ ");
INSERT INTO arq_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","خْلاص شْبَعتو، خْلاص تْرَفَّهتو، وَلّيتو سْلاطَن بلا بينا. لو كان خير تْكونو سْلاطن باش حْنا تاني نْكونو معاكُم، ");
INSERT INTO arq_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","خاطَر راني نْشوف باللي الله حَطّنا حْنا الرُسل مع الأخَّر، كي اللي مَحكموم عليهُم بالموت، خاطَر بْقينا فُرجة للدَنيا، للمَلايكة وللناس. ");
INSERT INTO arq_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","حْنا جُهالا على جال المَسيح، وأنتومَ حُكَما فالمَسيح، حْنا ضْعاف وأنتومَ قْوايا، أنتومَ مْكَرّمين وحْنا مَنهانين، ");
INSERT INTO arq_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","لهاد الساعة ما زَلنا نْجوعو ونَعَّطشو ونَتعَرّاو ونَنضَربو ونَتشَرّدو، ");
INSERT INTO arq_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ونَتَّعبو وحْنا نَخَّدمو بيَدّينا. يْسَبّونا، نْباركو، يَحَّڤرونا، نَحَّملو، ");
INSERT INTO arq_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","يْهينونا، نْعَزّيو. وَلّينا كي الوْسَخ فالدَنيا، الزْبَل اللي يَرميوَه الناس للآن. ");
INSERT INTO arq_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ما رانيش نَكتَب هاد الشي باش نْحَشَّمكُم، حَبّيت نْوَلَّهكُم كي وْلادي العْزاز، ");
INSERT INTO arq_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","خاطَر كي يْكون عَندكُم أُلوف الشْيوخة فالمَسيح، ما عَندكُمش باباة غيري خاطَر أنا وْلَدتكُم فالمَسيح يَسوع بالإنجيل. ");
INSERT INTO arq_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","نْسَجَّعكُم هِمّالا تْديرو بحالي، ");
INSERT INTO arq_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","على هَدا، بْعَتَّلكُم تيموتاوَس وْليدي العْزيز، والأَمين فالرَب، هُوَ يْفَكَّركُم بسيرتي فالمَسيح يَسوع كيما نْعَلَّمها في كُل مْكان وفي كامَل الكْنايَس. ");
INSERT INTO arq_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","كايَن اللي تْكَبّرو وحَسبوني ماشي رايَح نْجي لعَندكُم، ");
INSERT INTO arq_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","قْريب نْجيكُم وَلاّ حَب الرَب ونَعرَف ماشي بَرك كْلام هَدو اللي تْكَبّرو، نَعرَف قَوَّتهُم، ");
INSERT INTO arq_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","خاطَر مَلكوت الله ماشي بالهَدرة، بالقُدرة. ");
INSERT INTO arq_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","واش تْحَبّو؟ نْجيكُم بالحَطبة وَلاّ بالمْحَبّة والروح والحْنانة؟ ");
INSERT INTO arq_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","الحَصون، يَتقال باللي عَندكُم الفَسق، وواحَد الفَسق عَند الكُفّار ما كانش. لحَد اللي الراجَل خادي مَرت باباه، ");
INSERT INTO arq_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","وهَكداك تْكَبَّرتو. في عوض ما تَحَّزنو حَتّى يَنقطَع منكُم اللي دار هاد العَملة؟ ");
INSERT INTO arq_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","أنا، راهي داتي غايبة عليكُم بَصَّح روحي حاضرة، وحْكَمت كي اللي راني معاكُم على اللي دار هاد الشي، ");
INSERT INTO arq_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","بآسَم رَبّنا يَسوع، وحْنا مَجتَمعين كيف كيف، أنتومَ وروحي مع قُدرة رَبّنا يَسوع المَسيح، ");
INSERT INTO arq_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","سَلّمو هاد الراجَل للشيطان لهْلاك الدات باش تَسلَك الروح في يوم الرَب. ");
INSERT INTO arq_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ما حَقّكُمش تَتكَبّرو، ما راكُمش عارفين باللي شْوِيّة خْميرة تْطَلَّع العْجينة كامَل؟ ");
INSERT INTO arq_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","أرميو عليكُم الخْميرة القْديمة باش تْكونو عْجينة جْديدة كيما راكُم، فْطير، خاطَر المَسيح، الفَصح مْتاعنا، نَدبَح. ");
INSERT INTO arq_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","هَكدا لازَم تْديرو الحَفلة، بفْطير الصْفا والحَق ماشي بخْميرة قْديمة، وَلاّ بخْميرة الحيلة والشَر. ");
INSERT INTO arq_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","كْتَبتَلكُم فالبْرِيّة باش ما تْعاشروش الفاسقين، ");
INSERT INTO arq_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ما قْصَدتش الفاسقين اللي في هاد الدَنيا والطَمّاعين والسَرّاقين واللي يَشَّركو بالله، خاطَر هَكدا لازَم تَخُّرجو من الدَنيا، ");
INSERT INTO arq_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","كْتَبتَلكُم دُرك باللي ما تْعاشروش واحَد مْسَمّي روحو مومَن وهُوَ فاسَق، وَلاّ طَمّاع، وَلاّ يَشرَك بالله، وَلاّ يْسَب وَلاّ يَسكَر وَلاّ يَسرَق، وحَتّى ما تاكلوش مع واحَد كيما هَدا. ");
INSERT INTO arq_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","واش عَندي فاللي خارَج الكَنيسة باش نَحكَم عليهُم؟ أنتومَ ماشي على اللي فالكَنيسة اللي تَحُّكمو؟ ");
INSERT INTO arq_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","اللي خارَج الكَنيسة، الله اللي يَحكَم عليهُم. نَحّيو المَشرار من وَسطكُم. ");
INSERT INTO arq_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","يَوصَل الواحَد فيكُم كي تْكون عَندو مُشكِلة مع واحَدآخُر، يْروح يْشارعو عَند الكُفّار وماشي عَند القَدّيسين؟ ");
INSERT INTO arq_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ما راكُمش عارفين باللي القَدّيسين رايحين يْحاكمو الدَنيا؟ وَلاّ رايحين تْحاكمو الدَنيا، ما تَقَّدروش تَحَّكمو في حاجات صْغار؟ ");
INSERT INTO arq_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ما راكُمش عارفين باللي رايحين نْحاكمو المَلايكة؟ سْبَق باش نَحَّكمو فالمَشاكَل مْتاع المْعيشة. ");
INSERT INTO arq_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","يَعني فالمَشاكل مْتاع المْعيشة، تْحَطّو ناس الكَنيسة ما عاطيَتَّلهُم حَتّى قيمة باش هومَ يَحَّكمو! ");
INSERT INTO arq_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","راني نْقول هاد الشي باش نْبَيَّن عاركُم. يَعني ما كان بيناتكُم حَتّى واحَد عاقَل يَقدَر يَفري مُشكِلة بين خاوتو؟ ");
INSERT INTO arq_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","الخو يْشارَع خوه، وعَند اللي ماشي مومنين؟ ");
INSERT INTO arq_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","فالأَصَل، راكُم خاسرين مادام كايَن بيناتكُم الشْرَع. ما تَقَّدروش تَحَّملو الضَلم؟ ما تَقَّدروش تْخَلّيو واحَد يَغلَط فيكُم؟ ");
INSERT INTO arq_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","بالعَكس. أنتومَ اللي تَضَّلمو وتَغَّلطو، وفي شْكون؟ الخاوة. ");
INSERT INTO arq_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","وَلاّ ما راكُمش عارفين باللي الضالمين ما يَوَّرتوش مَلَكوت الله؟ ما تَنغَرّوش: لا الفاسقين، لا اللي يَشَّركو بالله، لا الزانيين، لا الرْجال اللي يْشَبّهو روحهُم بالنْسا، لا الرْجال اللي يْعاشرو الرْجال، ");
INSERT INTO arq_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","لا السَرّاقين، لا الطَمّاعين، لا السوكارجِيّة، لا اللي يْسَبّو، لا الخَطّافين ما يَوَّرتو مَلَكوت الله. ");
INSERT INTO arq_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","كايَن فيكُم اللي كانو هَكدا، بَصَّح نَغسَلتو، تْقَدّستو وتْبَرَّرتو بآسَم الرَب يَسوع المَسيح وروح إلَهنا. ");
INSERT INTO arq_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","كُل شي يْجوزلي بَصَّح ماشي كُل شي يَصلَح لِيَّ، كُل شي يْجوزلي بَصَّح ما نْخَلّي حَتّى شي يَتحَكَّم فيَّ. ");
INSERT INTO arq_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","الماكلة للكَرش والكَرش للماكلة والله رايَح يَفنيهُم في زوج. بَصَّح الدات ماشي للفَسق، الدات للرَب، والرَب للدات. ");
INSERT INTO arq_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","الله اللي حْيا الرَب من الموت يَحيينا حْنا تاني من الموت بقُدَّرتو. ");
INSERT INTO arq_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ما راكُمش عارفين باللي داتكُم هومَ طْراف المَسيح؟ ناخُد طْراف المَسيح ونْرَدّهُم طْراف فاسقة؟ أبَدًا. ");
INSERT INTO arq_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","وَلاّ ما راكُمش عارفين باللي اللي يْقَرَّب لفاسقة يْكون دات واحدة معاها؟ خاطَر تْقال، \"زوج يْوَلّيو دات واحدة\"، ");
INSERT INTO arq_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","اللي يْقَرّب لله يْكون روح واحدة معاه، ");
INSERT INTO arq_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","بَعّدو على الفَسق. كُل خْطِيّة يْديرها بْنادَم هِيَ خارجة على داتو، بَصَّح الفاسَق يَخطي في داتو. ");
INSERT INTO arq_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","وَلاّ ما راكُمش عارفين باللي داتكُم هِيَ مَسكَن الروح القُدّوس اللي فيكُم واللي جايكُم من الله وباللي أنتومَ ماشي مَلك نَفسكُم؟ ");
INSERT INTO arq_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","خاطَر نَشريتو بسومة غالية، هِمّالا كَرّمو الله في داتكُم. ");
INSERT INTO arq_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","على الشي اللي كْتبتوه، مْليح للراجَل لو كان ما يْمَسش مْرا، ");
INSERT INTO arq_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","بَصَّح باش الواحَد ما يْطيحش فالفَسق، خير لو كان كُل راجَل تْكون عَندو مَرتو، وكُل مْرا عَندها راجَلها. ");
INSERT INTO arq_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","لازَم الراجَل يَعطي للمْرا واش تْساللو والمْرا تاني تَعطي للراجَل واش يْسالَلها، ");
INSERT INTO arq_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","المْرا ما عَندهاش الحُكمة على داتها، الحُكمة تْكون لراجَلها، ومن جيهة أخرى، الراجَل ما عَندوش الحُكمة على داتو، الحُكمة تْكون لمَرتو. ");
INSERT INTO arq_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","واحَد ما يَمنَع روحو على الآخُر، غير وَلاّ تْفاهَمتو لوَقت باش تْخَصّصو روحكُم للصْلاة. أومبَعد، وَلّيو كيف كيف يعْود يَغويكُم الشيطان كي ما تَقَّدروش تَتحَكّمو في نَفسكُم. ");
INSERT INTO arq_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","نْقول هاد الشي تَسريح، ماشي آمَر. ");
INSERT INTO arq_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","راني حاب كامَل الناس يْكونو كيما أنايَ، بَصَّح كُل واحَد كيفاش أدّا موهِبة من الله: واحَد موهِبتو طْبَع، الآخُر قَصّة. ");
INSERT INTO arq_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","نْقول للّي ماشي مْتزَوّجين وللهْجاجَل: خيرلهُم لوكان يَبقاو كيما أنايَ، ");
INSERT INTO arq_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","بَصَّح وَلاّ كانو ما يَتحَكّموش في نَفسهُم، يَتزَوّجو خير، خاطَر الواحَد يَتزَوَّج خير من اللي يْنَحرَق. ");
INSERT INTO arq_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","وللمْتزَوّجين، ماشي أنا اللي نْقول، الله يْقول: المْرا ما لازَمش تَنفرَق على راجَلها، ");
INSERT INTO arq_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","وَلاّ نْفَرقَت، تَبقا بلا زْواج وَلاّ تَتصالَح مع راجَلها، والراجَل ما يَنفرَقش على مَرتو. ");
INSERT INTO arq_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","للأُخرين، أنا نْقول ماشي الرَب: وَلاّ كان الخو المومَن مَتزَوَّج بمْرا ماشي مومنة، وهاد المْرا حابّة تَبقا معاه، خير لو كان ما يَنفرَقش عليها، ");
INSERT INTO arq_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","وَلاّ كانَت المْرا مْتزَوّجة براجَل ماشي مومَن، وهاد الراجَل حاب يَبقا معاها، خير لو كان ما تَنفرَقش على راجَلها، ");
INSERT INTO arq_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","خاطَر الراجَل اللي ماشي مومَن يَتقَدَّس بمَرتو، والمْرا اللي ماشي مومنة تَتقَدَّس براجَلها المومَن، خاطَر لو كان ماشي هَكدا، وْلادكُم يْكونو ناجسين. بالعَكس، وْلادكُم مْقَدّسين. ");
INSERT INTO arq_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","وَلاّ اللي ماشي مومَن حَب يْفارَق، غير يْفارَق. الخو المومَن وَلاّ الخُت المومنة يْكونو حْرار هَكدا. الله دْعاكُم باش تْعيشو فالسْلام. ");
INSERT INTO arq_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","وين راكي عارفة يا مْرا وَلاّ ما راكيش رايحة تْسَلّكي راجلَك؟ ووين راك عارَف يا راجَل وَلاّ ما راكش رايَح تْسَلَّك مَرتَك؟ ");
INSERT INTO arq_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","يَعني، كُل واحَد يْعيش فالحالة اللي قْسَمهالو الرَب، واللي كان فيها كي دْعاه الله، هَكدا نامَر في كامَل الكْنايَس. ");
INSERT INTO arq_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","جاتو الواحَد الدَعوة وهُوَ مْخَتَّن؟ ما يْنَحّيش خْتانتو. جاتو الدَعوة وهُوَ ماشي مْخَتَّن؟ ما يْحَوَّسش يَتخَتَّن. ");
INSERT INTO arq_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ماشي الخْتانة وَلاّ غير الخْتانة اللي تْهَم، المُهٍم طاعة حْكام الله. ");
INSERT INTO arq_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","كُل واحَد يَبقا فالحالة اللي كان فيها كي جاتو الدَعوة. ");
INSERT INTO arq_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","جاتَك الدَعوة وأنتَ عَبد، ما تَتقَلَّقش من هاد الشي، بَصَّح لو كان تَقدَر تْوَلّي حُر، خير. ");
INSERT INTO arq_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","خاطَر العَبد اللي جاتو الدَعوة فالرَب، مْحَرَّر من الرَب. كيف كيف، الحُر اللي جاتو الدَعوة عَبد للمَسيح. ");
INSERT INTO arq_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","نَشريتو بسومة غالية، ما تْكونوش عْبيد لبْني آدَم. ");
INSERT INTO arq_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","كُل واحَد، يا الخاوة، يَبقا مع الله فالحالة اللي كان فيها كي جاتو الدَعوة. ");
INSERT INTO arq_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","العْواتَق، ما عَنديش عليهُم آمَر من الرَب، بَصَّح نْمَد رايي على حْساب اللي راني برَحمة الله راجَل حْلالي. ");
INSERT INTO arq_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","هاو واش راني نْخَمَّم: على جال الشَدّة اللي راهي، مْليح لكُل واحَد لو كان يَبقا كيما راه. ");
INSERT INTO arq_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","مَتزَوَّج بمْرا، ما تْحَوَّسش على الفْراق. ماشي مَتزَوَّج بمْرا، ما تْحَوَّسش على مْرا. ");
INSERT INTO arq_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","وَلاّ تْزَوَّجت، ما راكش تْدير خْطِيّة، وَلاّ العاتَق تْزَوّجَت، ما راهيش تْدير خْطِيّة، بَصَّح ناس هَكدا، يْكونو عَندهُم مْحايَن فالدات، راني حاب نْبَعَّدهُم عليهُم. ");
INSERT INTO arq_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","هاو واش راني حاب نْقول، يا الخاوة، الوَقت ضَيَّق، من دُرك لازَم اللي عَندهُم نْسا يْكونو كي اللي ما عَندهُمش، ");
INSERT INTO arq_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","اللي راهُم يَبكيو كي اللي ما راهُمش يَبكيو، اللي يَفَّرحو كي اللي ما راهُمش يَفَّرحو، اللي يَشريو كي اللي ما عَندهُمش، ");
INSERT INTO arq_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","اللي راهُم يَستفادو من الدَنيا كي اللي ماراهُمش يَستفادو، خاطَر صِفة الدَنيا هَدي ما تْدومش. ");
INSERT INTO arq_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ما دابيَّ ما يْكونش عَندكُم الهَم. اللي ماشي مَتزَوَّج يْلَتها بشي الرَب، يْحَوَّس كيفاش يَعجَب الرَب، ");
INSERT INTO arq_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","المَتزَوَّج يْلَتها بشي الدَنيا، يْحَوَّس كيفاش يَعجَب مَرتو، ");
INSERT INTO arq_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ويْنَقسَم. كيف كيف، المْرا اللي بلا راجَل، كيما العاتَق، تْلَتها بشي الرَب، باش تْكون مْقَدّسة فالدات وفالروح. المَتزَوَّجة تْلَتها بشي الدَنيا، تْحَوَّش كيفاش تَعجَب راجَلها. ");
INSERT INTO arq_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","راني نْقول هاد الشي في فايدَتكُم، ماشي باش نْديرلكُم فَخّة، باش تْديرو اللازَم وتَتعَلّقو بالرَب وَحدو وما تْكونوش مَقسومين؟ ");
INSERT INTO arq_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","وَلاّ الواحَد شاف روحو بَلاك يَغلَط مع العاتَق مْتاعو، وَلاّ كان مَحروق، وشايَف باللي لازَم يَتزَوَّج، يْدير كيما حَب، هَدي ماشي خْطِيّة، غير يَتزَوّجو. ");
INSERT INTO arq_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","بَصَّح اللي تابَت مْليح في قَلبو، ماشي مَحتاج، ونَفسو ماشي مَتحَكّمة فيه، وعَوَّل في قَلبو يْحافَض عالعاتَق مْتاعو، يَعمَل مْليح. ");
INSERT INTO arq_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","هَكدا، اللي يْزَوَّج العاتَق مْتاعو يَعمَل مْليح واللي ما يَزَوَّجهاش يَعمَل خير. ");
INSERT INTO arq_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","المْرا تْكون مَربوطة ما دام راجَلها حَي، بَصَّح وَلاّ الراجَل مات، تْكون حُرّة باش تَتزَوَّج مع من تْحَب، هات بَرك يْكون على حْساب مُراد الله، ");
INSERT INTO arq_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","بَصَّح على حْسابي أنا، تْكون مْهَنّية كْتَر لو كان تَبقا كيما راهي. وأنا تاني نْشوف باللي عَندي روح الله. ");
INSERT INTO arq_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","على الشي اللي يْخَص الدْبايَح اللي للأصنام، رانا عارفين باللي كامَل نَعَّرِفو. العَلم يْنَفَّخ بالتَكَبَّر بَصَّح المْحَبَّة تَبني. ");
INSERT INTO arq_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","اللي شايَف روحو يَعرَف حاجة، ما يَعرَفش كيما لازَم يَعرَف، ");
INSERT INTO arq_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","بَصَّح اللي يْحَب الله، هَداك مَعروف من الله. ");
INSERT INTO arq_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","هِمّالا، على الشي اللي يْخَص ماكلة الدْبايَح اللي للأصنام، رانا عارفين باللي الصْنام ما كاش منهُم فالدَنيا، وما كايَن حَتّى إلَه من غير واحَد. ");
INSERT INTO arq_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","خاطَر، صَح كايَن اللي يْعَيّطولهُم آلِهة فالسْما وفالأرض، -حَتّى لو كان كايَن بَزّاف آلِهة ورْباب- ");
INSERT INTO arq_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","بَصَّح لينا، كايَن غير إلَه واحَد، الآب، اللي كُل شي جاي منّو وحْنا فيه. ورَب واحَد، يَسوع المَسيح، اللي بيه كُل شي وحْنا بيه. ");
INSERT INTO arq_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","بَصَّح ماشي كامَل يَعَّرفو هاد الشي، بَصَّح كايَن اللي ما زالهُم للآن مْوالفين الأصنام، وعلى حْساب اللي ياكلو الدْبايَح اللي للأصنام، ضَميرهُم الضْعيف يْتنَجَّس. ");
INSERT INTO arq_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","هِيَ ماشي ماكلة اللي رايحة تْقَرَّبنا من الله، وَلاّ ما كْليناش منها، ما يَنقُص فينا والو، وَلاّ كْلينا منها، ما يْزيد فينا والو. ");
INSERT INTO arq_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","بَصَّح رَدّو بالكُم يْعود حَقّكُم يْكون حَجرة تْعَتَّر الضْعاف فيكُم، ");
INSERT INTO arq_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","وَلاّ شافَك واحَد، أنتَ اللي تَعرَف، على الميدة في هَيكَل الأصنام، ضَميرو الضْعيف ما يْسَجّعوش باش ياكُل لْحَم مْضَحّي للأصنام؟ ");
INSERT INTO arq_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","هَكدا، الضْعيف يْضيع بمَعرِفتَك أنتَ، وهاد الضْعيف هُوَ الخو اللي مات عليه المَسيح. ");
INSERT INTO arq_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","كي تَغَّلطو هَكدا فالخاوة، وتَجَّرحو ضَميرهُم الضْعيف، راكُم تَغَّلطو فالمَسيح. ");
INSERT INTO arq_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","على هَدا، وَلاّ كانَت ماكلة تْطَيَّح خويَ، عَمري ما ناكُل اللْحَم، باش ما نْكونش سْباب طيحة خويَ. ");
INSERT INTO arq_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","أنا ماشي حُر؟ ماشي رَسول؟ ما شَفتش يَسوع رَبّنا؟ أنتومَ بالدات، ماشي خَدَّمتي فالرَب؟ ");
INSERT INTO arq_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","وَلاّ الأخرين ماشي شايفينني رَسول، أنتومَ بالقْليلة تَستَعرفو باللي أنا رَسول، خاطَر أنتومَ الطابَع مْتاع رُسولِيّتي فالرَب. ");
INSERT INTO arq_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","هاو كيفاش نْحامي على روحي قُدّام اللي يَتَّهموني: ");
INSERT INTO arq_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ما عَندناش الحَق ناكلو ونَشُّربو؟ ");
INSERT INTO arq_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ما عَندناش الحَق نَدّيو معانا خُت تْكون زوجة لينا، كيما يْديرو الرُسل الأخرين، خاوة الرَب وصَفا؟ ");
INSERT INTO arq_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","وَلاّ غير حْنا، أنا وبَرنابا، اللي ما عَندناش الحَق ما نَخَّدموش؟ ");
INSERT INTO arq_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","شْكون يْكون يْحارَب في جيش ويَصرَف من عَندو؟ شْكون يَغرَس دالية وما ياكُلش من غَلَّتها؟ شْكون يَرعا الغْنَم وما يَشرُبش من حْليبهُم وما ياكُلش منهُم؟ ");
INSERT INTO arq_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","راني نَهدَر غير بمَنطَق بْني آدَم وَلاّ الشَريعة تاني ما تْقولش كيف كيف؟ ");
INSERT INTO arq_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","إيه، مَكتوب في شَريعة موسى: \"ما تْحَطش الكْمامة على فُم الفَرد وهُوَ يَدرَس\". الله كان يْخَمَّم على الفْراد؟ ");
INSERT INTO arq_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ماشي على جالنا اللي قال هاد الشي؟ إيه، على جالنا اللي نَكتَب هاد الشي، خاطَر اللي يَحرَت لازَم يَحرَت وهُوَ راجي، واللي يَدرَس يَدرَس وهُوَ طامَع يَدّي. ");
INSERT INTO arq_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","وَلاّ زْرَعنا فيكُم الحاجات الروحِيّين، بَزّاف علينا لوكان نَحَّصدو منكُم الحاجات المادِيّين؟ ");
INSERT INTO arq_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","وَلاّ الأخرين عَندهُم هاد الحَق عليكُم باش يْشاركوكُم، حْنا ماشي سْبَق؟ وهَكداك، حْنا ما أدّيناش هاد الحَق. بالعَكس، نَحَّملو كُل شي باش ما نْصَعّبوش الطْريق لبْشارة المَسيح. ");
INSERT INTO arq_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ما راكُمش عارفين باللي اللي يَخَّدمو فالمَعبَد يَدّيو الماكلة من المَعبَد، واللي يَخَّدمو فالمَدبَح يَستَنّاو يَدّيو من اللي على المَدبَح؟ ");
INSERT INTO arq_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","كيف كيف، الرَب آمَر باش اللي يْبَشّرو بالإنجيل يْعيشو من الإنجيل. ");
INSERT INTO arq_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","بَصَّح أنا ما سْتفَدتش من هاد الشي كامَل، وأنا راني نَكتَب هاد الشي باش يَطَّبَّق علِيَّ. خير لي نْموت وَلا واحَد يْنَقَّص من القيمة اللي عَندي في هاد الشي، ");
INSERT INTO arq_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","خاطَر بْشارتي بالإنجيل ماشي للزوخ، هاد الآمَر مْحَتَّم علِيَّ، ويا ويلي لو كان ما نْبَشَّرش بالإنجيل. ");
INSERT INTO arq_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","لو كان خَيَّرت نْديرها، كان يْكون عَندي آجَر، بَصَّح كي نْفَرضَت علِيَّ، وَلاّت مَسؤوليّة تْآمَنت عليها. ");
INSERT INTO arq_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","واش هِمّالا يْكون آجري؟ كي نْبَشَّر بالإنجيل بلا ما نَدّي والو، وهَكدا ما نَستفادش من حَقّي فالإنجيل. ");
INSERT INTO arq_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","خاطَر والو أنا حُر من كُل واحَد، دَرت روحي عَبد لكُل واحَد باش نَكسَب قَد ما نَقدَر منهُم، ");
INSERT INTO arq_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","مع اليْهود، كُنت كي اليْهودي باش نَربَح اليْهود، مع اللي خاضعين للشَريعة، كي اللي خاضَع للشَريعة باش نَربَح الخاضعين للشَريعة، والو أنا ماشي خاضَع للشَريعة، ");
INSERT INTO arq_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","مع اللي ما عَندهُمش شَريعة كي اللي ما عَنديش شَريعة، باش نَربح اللي ما عَندهُمش الشَريعة، والو أنا عَند الله ما رانيش بلا شَريعة، أنا مَحكوم بشَريعة المَسيح، ");
INSERT INTO arq_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","كُنت ضْعيف مع الضُعَفا، باش نَربَح الضُعَفا، كُنت كُل شي لكُل واحَد، باش كيما كان الحال نْسَلَّك شي ناس. ");
INSERT INTO arq_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","وهَدا كامَل، نْديرو على جال الإنجيل، باش نْسال فيه. ");
INSERT INTO arq_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ما راكُمش عارفين باللي اللي يَجريو فالمَلعَب يَجريو كامَل بَصَّح واحَد بَرك اللي يَدّي الجايزة؟ أجريو هَكدا باش تَرَّبحو. ");
INSERT INTO arq_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","اللاعَب اللي يَتنافَس، يَتدَرَّب باش يَتحَكَّم في نَفسو في كُل شي. هاد الشي باش يْنالو تاج فاني، بَصَّح حْنا تاجنا ما يَفناش. ");
INSERT INTO arq_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","أنا نْجري ماشي بلا ما نَعرَف وين نْروح، نَضرَب بَصَّح ماشي كي اللي يَضرَب الريح، ");
INSERT INTO arq_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","بالعَكس، نَقسا على داتي ونْطَوَّعها نْعود بَعد ما بَرَّحت للأخرين، أنا ما نَنقبَلش. ");
INSERT INTO arq_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ما يَخفاش عليكُم يا الخاوة، جْدودنا كانو كامَل تَحت السْحاب، وكامَل قَطعو البْحَر، ");
INSERT INTO arq_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","كامَل تْعَمّدو لموسى فالسْحاب وفالبْحَر، ");
INSERT INTO arq_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","كامَل كْلاو ماكلة روحِيّة واحدة، ");
INSERT INTO arq_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","كامَل شَربو مَشروب روحي واحَد، خاطَر كانو يَشَّربو من صَخرة روحِيّة كانَت تْتَبعَّهُم، هاد الصَخرة هِيَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","بَصَّح على حْساب اللي الكُترة منهُم ما رَضّاوش الله، طاحو فالخْلا. ");
INSERT INTO arq_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","هَدو مْتال لينا، باش ما نَتشَهّاوش الشَر كيما تْشَهّاوَه هومَ، ");
INSERT INTO arq_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ما تَشَّركوش كيما دارو شي ناس منهُم، على حْساب ماهو مَكتوب: \"الشَعب قْعَد باش ياكُل ويَشرُب، أومبَعد ناضو باش يَزهاو\"، ");
INSERT INTO arq_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ما نْسَلّموش روحنا للفَسق كيما سَلّمو روحهُم للفَسق ناس منهُم وماتو منهُم تْلاتة وعَشرين ألف في يوم واحَد. ");
INSERT INTO arq_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ما نْجَرّبوش المَسيح كيما جَرّبوه ناس منهُم حَتّى قَتلوهُم الحْنوشة، ");
INSERT INTO arq_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ما تْدَمدموش كيما دَمدمو ناس منهُم حَتّى جاهُم الهْلاك، ");
INSERT INTO arq_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","هاد الشي صْرالهُم عَبرة، ونَكتَب باش يْقَرّينا، حْنا اللي لْحَق علينا آخَر الدَنيا. ");
INSERT INTO arq_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","هَكدا هِمّالا، اللي راهو شايَف روحو واقَف، يْرَد بالو يْعود يْطيح، ");
INSERT INTO arq_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","من جْميع تَجرُبة جاتكُم تَقدَر تْجي لكُل بْنادَم، بَصَّح تيقو فالله اللي ما يْخَلّي حَتّى تَجرُبة تْجيكُم تْكون فوق طاقَتكُم، ومع كُل تَجرُبة يَعطي الحَل والقُدرة باش تَحَّملو. ");
INSERT INTO arq_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","على هَدا يا حْبابي، بَعّدو من الشَرك، ");
INSERT INTO arq_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","راني نَهدَر مع ناس عاقلين، أحَّكمو أنتومَ بالدات على الشي اللي راني نْقول فيه، ");
INSERT INTO arq_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","كاس البَرَكة اللي نْباركوه، ما راهوش شَركة بدَم المَسيح؟ الخُبز اللي نَقَّسموه، ماشي شَركة بدات المَسيح؟ ");
INSERT INTO arq_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","على حْساب اللي كايَن خُبز واحَد، والو حْنا بَزّاف، حْنا دات واحدة خاطَر كامَل نَتقاسمو خُبز واحَد. ");
INSERT INTO arq_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","شوفو شَعب إسرائيل، اللي ياكلو الدْبايَح ماشي شاركين فالمَدبَح؟ ");
INSERT INTO arq_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","واش راني نْقول؟ باللي اللْحَم المْضَحّي حاجة والصَنَم حاجة أخرى؟ ");
INSERT INTO arq_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","لالا، بَصَّح الدْبيحة مْضَحية للشْياطَن ماشي لله، وأنا ما رانيش حابّكُم تْكونو في شَركة مع الشْياطَن. ");
INSERT INTO arq_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ما تَقَّدروش تَشُّربو كاس الرَب وكاس الشْياطَن، ما تَقَّدروش تَقَّعدو على ميدة الرَب وعلى ميدة الشْياطَن، ");
INSERT INTO arq_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","وَلاّ رانا حابّين نْغَيّرو الله؟ حْنا أقوى منّو؟ ");
INSERT INTO arq_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","كُل شي مَسموح بَصَّح ماشي كُل شي يْفيد. كُل شي مَسموح بَصَّح ماشي كُل شي يَصلَح للبَنيان. ");
INSERT INTO arq_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","واحَد ما لازَم يْحَوَّس على صْلاحو، الواحَد لازَم يْحَوَّس على صْلاح الأخرين. ");
INSERT INTO arq_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","كولو كُل شي يَنباع فالسوق، بلا ما تْسَقسيو باش تْرَضّيو الضَمير، ");
INSERT INTO arq_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","خاطَر الأرض وما فيها للرَب. ");
INSERT INTO arq_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","وَلاّ عْرَضكُم واحَد ماشي مومَن وحَبّيتو تْروحو، كولو واش يْسَربيلكُم بلا ما تْسَقسيو باش تْرَضّيو الضَمير، ");
INSERT INTO arq_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","بَصَّح وَلاّ واحَد قالَلكُم: \"هَدي ضْحيّة\"، ما تاكلوش، على جال اللي نَبَّهكُم وعلى جال الضَمير. ");
INSERT INTO arq_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","كي نْقول \"على جال الضَمير\"، نَقصَد ضَميرو هُوَ، ماشي ضَميركُم أنتومَ، خاطَر عْلاش نْخَلّي ضَمير واحَدآخُر يَحكُم على حُرٍيّتي؟ ");
INSERT INTO arq_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","وَلاّ كُنت نَحمَد وأنا ناكُل، وَعلاش نَتلام على الشي اللي نَحمَد عليه؟ ");
INSERT INTO arq_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","هِمّالا، تاكلو وَلاّ تَشُّربو وَلاّ تْديرو واش تْديرو، لازَم يْكون كُل شي لمَجد الله. ");
INSERT INTO arq_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ما تْكونو سْباب عَترة لا لليْهود، لا لليونانِيّين وَلا لكَنيسة الله. ");
INSERT INTO arq_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","كيما أنا، نْحَوَّس نَعجَب كُل واحَد في كُل شي، وما نْحَوَّسش على صْلاحي، نْحَوَّس على صْلاح الأخرين، باش يَسَّلكو. ");
INSERT INTO arq_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ديرو بْحالي كيما أنا نْدير بْحال المَسيح. ");
INSERT INTO arq_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","راني فَرحان بيكُم اللي تَدُّكروني في كُل شي، وشَدّيتو فالعْوايَد اللي عْطيتهُمَّلكُم، ");
INSERT INTO arq_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","بَصَّح راني حابّكُم تَعَّرفو باللي راس كُل إنسان هُوَ المَسيح، راس المْرا هُوَ الراجَل، وراس المَسيح هُوَ الله. ");
INSERT INTO arq_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","كُل راجَل يْصَلّي وَلاّ يَتنَبَّأ وراسو مْغَطّي، يْجيب العار لراسو، ");
INSERT INTO arq_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","كُل مْرا تْصَلّي وَلاّ تَتنَبَّأ وراسها مَكشوف، تْجيب العار لراسها، كي اللي راهي مْحَفّفة ڤَرعة. ");
INSERT INTO arq_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","وَلاّ المْرا ما غَطّاتش راسها، غير تْحَفَّف ڤَرعة، بَصَّح على حْساب اللي عار على المْرا تْقَطَّع شْعَرها وَلاّ تْحَفّفو ڤَرعة، لازَم تْغَطّي راسها. ");
INSERT INTO arq_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","الراجَل ما لازَمش يْغَطّي راسو، خاطَر هُوَ صِفة ومَجد الله، والمْرا هِيَ مَجد الراجَل. ");
INSERT INTO arq_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","خاطَر ماشي الراجَل اللي تْكَوَّن من المْرا، المْرا هِيَ اللي تْكَوّنَت منّو. ");
INSERT INTO arq_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","وماشي الراجَل اللي نَخلَق من المْرا، المْرا هِيَ اللي نْخَلقَت منّو. ");
INSERT INTO arq_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","على هَدا، المْرا لازَم تْكون عَندها على راسها مارة الحُكمة على جال المَلايكة، ");
INSERT INTO arq_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","والو فالرَب، المْرا ما تْكونش بلا الراجَل وَلا الراجَل بلا المْرا، ");
INSERT INTO arq_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","وكيما المْرا هِيَ من الراجَل، الراجَل هُوَ من المْرا، وكُل شي من الله. ");
INSERT INTO arq_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","أحَّكموا أنتومَ بداتكُم: يْليق بالمْرا تْصَلّي لله وهِيَ مَكشوفة؟ ");
INSERT INTO arq_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","الواحَد بطْبيعتو ما يْشوفش باللي عار على الراجَل يْطَوَّل شَعرو؟ ");
INSERT INTO arq_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","بَصَّح المْرا، لو كان تْكون مْكَسية بشْعَر طْويل، هَدا شان ليها. خاطَر الشْعَر الطْويل، نَعطالها في عوض اللْحاف. ");
INSERT INTO arq_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","وَلاّ واحَد حَب يْغالَب في هاد الشي، ما عَندناش عادة كي هَدي، لا حْنا وَلا كْنايَس الله. ");
INSERT INTO arq_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","رايَح نَعطيكُم هاد الفَرض، وأنا ماشي فَرحان بيكُم خاطَر كي راكُم تَتلَمّو، تَتلَمّو ماشي باش تْوَلّيو خير، باش تْوَلّيو عُر. ");
INSERT INTO arq_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","الأوَّل، كي تَتلَمّو، سْمَعت باللي كايَن فيكُم اللي مَقسومين، وهاد الشي راني شْوٍيّة مْآمنو، ");
INSERT INTO arq_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ولازَم يْكونو عَندكُم مْداهَب باش يْبانو المْخَيّرين فيكُم! ");
INSERT INTO arq_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","هِمّالا، كي تَتلَمّو في مْكان واحَد، ماشي باش تاكلو العْشا مْتاع الرَب، ");
INSERT INTO arq_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","خاطَر في وَقت الماكلة، كُل واحَد يْخَف ياكُل عْشاتو، وواحَد جيعان والآخُر سَكران. ");
INSERT INTO arq_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ما عَندكُمش دْيار باش تاكلو وتَشُّربو؟ وَلاّ حْڤَرتو كَنيسة الله وهَنتو اللي ما يَمَّلكو والو؟ واش نْقولَلكُم؟ نفرَح بيكُم؟ ما نَفرَحش بيكُم في هاد الشي. ");
INSERT INTO arq_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","خاطَر أنا نَلت من الرَب الشي اللي عْطيتهولكُم. الرَب يَسوع، فالليلة اللي تْسَلَّم فيها، خْدا خُبز، ");
INSERT INTO arq_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","وبَعد ما شْكَر، قَسمو وقال: \"هَدي داتي اللي ليكُم، ديرو هَكدا تَفكيرة لِيَّ\"، ");
INSERT INTO arq_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","كيف كيف، بَعد ما تْعَشّا، خْدا الكاس وقال: \"هاد الكاس هُوَ العَهَد الجْديد بدَمّي، ديرو هَكدا كُلّما تَشُّربوها تَفكيرة لِيَّ\"، ");
INSERT INTO arq_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","خاطَر كُل ما تاكلو هاد الخُبز وتَشُّربو هاد الكاس، تْخَبّرو بموت الرَب حَتّى وين يْجي، ");
INSERT INTO arq_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","على هَدا، اللي ياكُل الخُبز ويَشرُب كاس الرَب بلا قْدَر، يْكون خاطي في دات ودَم الرَب. ");
INSERT INTO arq_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","هِمّالا، كُل واحَد يْقَلَّب روحو أومبَعد ياكُل من الخُبز ويَشرُب من الكاس، ");
INSERT INTO arq_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","خاطَر اللي ياكُل ويَشرُب بلا ما يْمَيَّز الدات، ياكُل ويَشرُب حُكم على روحو. ");
INSERT INTO arq_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","على هَدا اللي كايَن في وَسطكُم بَزّاف من المَرضى والعايبين، وبَزّاف اللي ماتو. ");
INSERT INTO arq_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","لو كان نْقَلّبو روحنا، ما نَتحاكموش، ");
INSERT INTO arq_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","بَصَّح الله كي يَحكَم علينا، نَتنَضمو باش ما يْنَحكَمش علينا مع الدَنيا. ");
INSERT INTO arq_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","هِمّالا يا خاوتي، كي تْجيو كيف كيف باش تاكلو، أستَنّاو بَعضكُم بَعض، ");
INSERT INTO arq_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","وَلاّ كان واحَد جيعان، يَسبَق ياكُل في دارو، باش ما تْكونش لَمَّتكُم سْباب الحُكم عليكُم، المَشاكَل الأخرين، نْحَلّهُم كي نْجي. ");
INSERT INTO arq_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","على الهِبات الروحِيّين، ما رانيش حاب يَخفا عليكُم يا الخاوة. ");
INSERT INTO arq_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","راكُم عارفين باللي كي كُنتو كُفّار، كُنتو تَنجَبدو مَعمِيّين للأصنام العْڤاڤَن، ");
INSERT INTO arq_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","على هَدا، نَعلَمكُم باللي واحَد ما يَهدَر بالروح القُدّوس ويْقول: \"يَسوع مَنعول\"، وواحَد ما يَقدَر يْقول: \"يَسوع رَب\" من غير بالروح القُدّوس. ");
INSERT INTO arq_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","هِبات النَعمة بَزّاف بَصَّح الروح واحَد، ");
INSERT INTO arq_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","الخَدمات بَزّاف، بَصَّح الرَب واحَد، ");
INSERT INTO arq_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","الفْعال بَزّاف بَصَّح إلَه واحَد اللي يْشَغَّل كُل شي فالكُل. ");
INSERT INTO arq_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","كُل واحَد نَعطالو باش يْبان فيه الروح للفايدة، ");
INSERT INTO arq_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","واحَد مَعطِيَّتلو بالروح كْلام الحِكمة، واحَدآخُر كْلام المَعرِفة، على حْساب روح واحَد، ");
INSERT INTO arq_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","واحَدآخُر الإيمان في روح واحَد، واحَدآخُر هِبات الشْفا في روح واحَد، ");
INSERT INTO arq_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","لواحَدآخُر القُدرة باش يْدير العْجايَب، لواحَدآخُر النُبُوّة، لواحَدآخُر باش يْمَيَّز بين الأرواح، لواحَدآخُر نْواع من اللُغات، لواحَدآخُر باش يْتَرجَم اللُغات. ");
INSERT INTO arq_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","هَدا كامَل يْشَغّلو روح واحَد وْحيد، يَقسَم لكُل واحَد وَحدو كيما يْحَب. ");
INSERT INTO arq_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","خاطَر كيما الدات واحدة والطْراف بَزّاف، وكيما طْراف الدات والو بَزّاف بَصَّح هومَ دات واحدة، هَكداك المَسيح. ");
INSERT INTO arq_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","خاطَر حْنا كامَل –يْهود وَلاّ يونانِيّين وَلاّ عْبيد وَلاّ حْرار- تْعَمَّدنا في دات واحدة بروح واحَد وكامَل نَروينا بروح واحَد، ");
INSERT INTO arq_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","خاطَر الدات ماشي طَرف واحَد، بَزّاف. ");
INSERT INTO arq_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","لو كان الرْجَل تْقول: \"كي أنا ماشي اليَد، هِمّالا أنا ماشي من الدات\"، صَح هِيَ ماشي من الدات؟ ");
INSERT INTO arq_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","لو كان الوْدَن تْقول: \"كي أنا ماشي عين، هِمّالا أنا ماشي من الدات\"، صَح هِيَ ماشي من الدات؟ ");
INSERT INTO arq_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","لو كان الدات كامَل عين، وين يْكون السْمَع. لو كان كامَل سْمَع، وين يْكون الشَم؟ ");
INSERT INTO arq_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","فالواقَع، الله حَط كُل واحَد من الطْراف فالدات كيما حَب. ");
INSERT INTO arq_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","لو كان كامَل طَرف واحَد، وين تْكون الدات؟ ");
INSERT INTO arq_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","بَصَّح دُرك كايَن طْراف بَزّاف ودات واحدة، ");
INSERT INTO arq_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","العين ما تَقدَرش تْقول لليَد: \"ما نَسَّحقكَش\"، وَلا الراس يْقول للرَجلين: \"ما نَسحَقكُمش\"، ");
INSERT INTO arq_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","حَتّى طْراف الدات اللي يْبانو ضْعاف على الأخرين لازمين، ");
INSERT INTO arq_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","وطْراف الدات اللي حاسبينهُم عيب، نْلَتهاو بيهُم كْتَر، ونْقومو الكُترة باللي نَحَّشمو بيهُم، ونَعطيولهُم شان كْتَر، ");
INSERT INTO arq_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","خاطَر اللي يْليقو ما يَسَّحقوش نْلَتهاو بيهُم هَكداك. الله رَتَّب الدات وعْطا شان كْتَر للي مَخصوص شان، ");
INSERT INTO arq_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","باش ما تْنَقسَمش الدات، وكامَل الطْراف يْرَدّو بالهُم على بَعضهُم بَعض. ");
INSERT INTO arq_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ولو كان يَتوَجَّع طَرف من الدات، كامَل الطْراف يَتوَجّعو معاه، ولو كان يَتكَرَّم طَرف، يَفرَح مع كامَل الطْراف. ");
INSERT INTO arq_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","أنتومَ دات المَسيح، أنتومَ طْرافو، واحَد واحَد. ");
INSERT INTO arq_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","والله حَط فالكَنيسة ناس: واحَد الرُسُل، تْنين الأنبِيا، تْلاتة الشْيوخة، أومبَعد كايَن العْجايَب، أومبَعد هِبات الشْفا، المْعاونة، التَدبير، نْواع اللُغات. ");
INSERT INTO arq_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","كامَل رُسُل؟ كامَل أنبِيا؟ كامَل شْيوخة؟ كامَل يْديرو العْجَايَب؟ ");
INSERT INTO arq_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","كامَل عَندهُم هِبات الشْفا؟ كامَل يَهَّدرو لُغات؟ كامَل يْتَرجمو؟ ");
INSERT INTO arq_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","أتشَوّقو للهِبات الكُبار، ودُرك نْوَرّيلكُم الطْريق المْخَيَّرة. ");
INSERT INTO arq_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","لو كان نَهدَر لُغات بْني آدَم والمَلايكة، وما عَنديش المْحَبّة، نْكون حْديد يْطَنطَن وَلاّ طْبَل يْدَندَن، ");
INSERT INTO arq_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","لو كان تْكون عَندي النُبُوّة ونَعرَف كامَل الأسرار والعَلم بكْمالو، لو كان يْكون عَندي كامَل الإيمان اللي بيه نَنقُل الجْبال، وما عَنديش المْحَبّة، ما نْكون والو. ");
INSERT INTO arq_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","كي نْصَدَّق كامَل مْلاكي، ونْسَلَّم داتي باش تَنحرَق، وما عَنديش المْحَبّة، ما كْسَبت والو. ");
INSERT INTO arq_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","المْحَبّة تَصبَر، المْحَبّة مْليحة، ما تْغيرش، ما تْزوخش، ما تَتكَبَّرش، ");
INSERT INTO arq_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ما تْديرش اللي ما يْليقش، ما تْحَوَّسش على صْلاحها، ما تَزعَفش، ما تَحڤُدش، ");
INSERT INTO arq_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ما تَفرَحش بالضَلم وتَفرَح بالحَق، ");
INSERT INTO arq_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","تَستَر كُل شي، تامَن كُل شي، تَرجا كُل شي، تَحمَل كُل شي، ");
INSERT INTO arq_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","المْحَبّة ما تَفشَلش. النُبُوات يَحَّبسو، اللُغات يَنقَطعو، العَلم يْزول، ");
INSERT INTO arq_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","نَعَّرفو نَص ونَتنَبّؤو نَص، ");
INSERT INTO arq_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","بَصَّح كي يْجي الكْمال، يْزول النَص. ");
INSERT INTO arq_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","كي كُنت صْغير، كُنت نَهدَر كي الصْغير، نْخَمَّم كي الصْغير، نَفهَم كي الصْغير. كي وَلّيت راجَل، بَطَّلت الشي اللي يْخُص الصْغير. ");
INSERT INTO arq_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","اليوم رانا نْشوفو في مْراية، مْضَبَّب، بَصَّح داك الوَقت نْشوفو وَجه لوَجه. دُرك نَعرَف نَص، بَصَّح داك الوَقت نَعرَف بالكْمال كيما نَعرَفت. ");
INSERT INTO arq_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","هاد التْلاتة اللي يْدومو: الإيمان، الرْجا والمْحَبّة بَصَّح الصَح فيهُم هِيَ المْحَبّة. ");
INSERT INTO arq_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","حَوّسو على المْحَبّة، وأتشَوّقو للهِبات الروحِيّين، وبخْصاص باش تَتنَبؤو، ");
INSERT INTO arq_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","اللي يَهدَر لُغات يَهدَر مع الله ماشي مع الناس خاطَر واحَد ما يَفهَملو، ويْكون يْقول سْرار بالروح، ");
INSERT INTO arq_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","اللي يَتنَبّأ، يَهدَر مع الناس، يَبني، يْسَجَّع ويْعَزّي. ");
INSERT INTO arq_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","اللي يَهدَر لُغات يَبني روحو بَصَّح اللي يَتنَبّأ يَبني الكَنيسة، ");
INSERT INTO arq_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","مادابِيَّ كامَل تَهَّدرو لُغات بَصَّح خير لو كان تَتنَبّؤو. اللي يَتنَبّأ كْبير على اللي يَهدَر لُغات، غير وَلاّ كان يْتَرجَم، باش الكَنيسة تَتَّبنا. ");
INSERT INTO arq_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","دُرك يا الخاوة، فاش نْفيدكُم لو كان نْجيكُم نَهدَر لُغات في عوض ما نْقولَلكُم وَحي وَلاّ عَلم وَلاّ نُبُوّة وَلاّ دَرس؟ ");
INSERT INTO arq_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","فالجوق مَتلاً، لو كان الزَمّارة ما تْديرش صوت مْخالَف على الڤيتارة، كيفاش نْفَرّقو بين نَغمة الزَمّارة ونَغمة الڤيتارة؟ ");
INSERT INTO arq_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ولو كان صوت البوق ما كانش واضَح، شْكون يْوَجَّد روحو للحَرب؟ ");
INSERT INTO arq_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","أنتومَ تاني، وَلاّ ما تْقولوش باللُغة كْلام عَندو مَعنى، كيفاش يْنَعرف واش تْقال؟ تْكونو تَهَّدرو فالريح. ");
INSERT INTO arq_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","قَد ما كايَن فالدَنيا لُغات، واحدة فيهُم ماهي بلا مَعنى. ");
INSERT INTO arq_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","لو كان ما نَفهَمش المَعنى مْتاع كاش لُغة، نْكون بَرّاني على اللي راهو يَتكَلَّم بيها وهُوَ يْكون بَرّاني علِيَّ، ");
INSERT INTO arq_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","أنتومَ تاني، كي راكُم مَتشَوّقين للحاجات الروحِيّين، حَوّسو دايمًا يْكونو عَندكُم كْتَر، بَصَّح لبَنيان الكَنيسة. ");
INSERT INTO arq_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","اللي يَهدَر لُغات يَدعي باش يْوَلّي يْتَرجَم، ");
INSERT INTO arq_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","خاطَر كي نْصَلّي باللُغة، روحي تْكون فالصْلاة، بَصَّح عَقلي يْكون بلا فايدة، ");
INSERT INTO arq_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","واش هِمّالا؟ نْصَلّي بالروح بَصَّح نْصَلّي بالعْقَل، نْرَنَّم بالروح ونْرَنَّم بالعْقَل. ");
INSERT INTO arq_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","خاطَر، كي تْسَبَّح غير بالروح، كيفاش يَقدَر اللي يْكون قاعَد مع الغاشي يْقول \"آمين\" للشُكر اللي شْكَرتو وهُوَ ماشي فاهَم واش راك تْقول؟ ");
INSERT INTO arq_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","أنتَ، تْكون مْتَبَّت باللي راك تَشكُر مْليح، بَصَّح هاد الشي ما يَبنيش الآخُر. ");
INSERT INTO arq_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","نَحمَد الله اللي نَهدَر لُغات كْتَر منكُم كامَل، ");
INSERT INTO arq_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","بَصَّح فالكَنيسة، خير نْقول خَمس كَلمات بعَقلي باش نَعلَم الأخرين وَلا عَشر آلاف كَلمة باللُغة. ");
INSERT INTO arq_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","يا الخاوة، ما تْكونوش صْغار فالتَخمام، كونو صْغار فالشَر بَصَّح فالتَخمام كونو كْبار. ");
INSERT INTO arq_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","مَكتوب فالشَريعة: \"بلُغات أخرين، بفَم البْراوِيّة، رايَح نْكَلَّم هاد الشَعب، وهَكداك ما يَسَّمعوليش، يْقول الرَب\"، ");
INSERT INTO arq_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","يَعني، اللُغات هومَ مارة لغير المومنين ماشي للمومنين، بَصَّح النُبُوّة مارة للمومنين ماشي لغير المومنين. ");
INSERT INTO arq_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","كي تَتلَم الكَنيسة كامَل، وكامَل يْكونو يَهَّدرو لُغات، ويَدُّخلو ناس ماشي مومنين، ماشي يْقولو عليكُم مْهابَل؟ ");
INSERT INTO arq_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","بَصَّح لو كان يْكونو كامَل يَتنَبّؤو، ويَدخُل واحَد ماشي مومَن وَلاّ واحَد ما يَعرَفش، يَقتَنَع منهُم كامَل ويْعاوَد حْساباتو، ");
INSERT INTO arq_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","يَنكَشفو سْرار قَلبو ويْطيح ساجَد، يَعبَد الله ويَستَعرَف باللي الله صَح في وَسطكُم. ");
INSERT INTO arq_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","واش هِمّالا يا الخاوة؟ كي تَتلَمّو، واحَد عَندو مَزمور، واحَد عَندو دَرس، واحَد عَندو وَحي، واحَد عَندو لُغة، واحَد عَندو تَفسير، لازَم يْكون كُل شي للبَنيان. ");
INSERT INTO arq_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","وَلاّ كانَت الهَدرة باللُغة، يَهَّدرو زوج وَلاّ كَتّرو تْلاتة بالدالة، أومبَعد واحَد يْتَرجَم. ");
INSERT INTO arq_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","بَصَّح وَلاّ ما كانش اللي يْتَرجَم، اللي يَهدَر اللُغة غير يَسكُت فالكَنيسة، ويَهدَر بينو وبين روحو ومع الله. ");
INSERT INTO arq_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","والأنبيا، يَهَّدرو زوج وَلاّ تْلاتة والأخرين يْمَيّزو، ");
INSERT INTO arq_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","وَلاّ واحَدآخُر حاضَر عَندو وَحي، يَسكُت الأولاني، ");
INSERT INTO arq_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","خاطَر تَقَّدرو تَتنَبؤو بالواحَد باش الأخرين كامَل يَعَّلمو ويَتسَجّعو، ");
INSERT INTO arq_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","رْواح الأنبيا خاضعين للأنبيا، ");
INSERT INTO arq_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","خاطَر الله ماراهوش إله هَملة، الله إلَه سْلام. كيما في كامَل كْنايَس القَدّيسين، ");
INSERT INTO arq_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","لازَم النْسا يَسُّكتو فالكْنايَس، خاطَر ماشي مَسموحَلهُم يَهَّدرو، لازَم يْكونو خاضعين كيما تْقول الشَريعة. ");
INSERT INTO arq_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","وَلاّ يْحَبّو يَتعَلّمو، يْسَقسيو رْجالهُم فالدار، خاطَر عيب المْرا تَهدَر فالكَنيسة. ");
INSERT INTO arq_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","من عَندكُم اللي خْرَج كْلام الله؟ وَلاّ غير ليكُم اللي وْصَل؟ ");
INSERT INTO arq_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","وَلاّ كايَن واحَد شايَف روحو نَبي وروحي، يَستَعرَف باللي الحاجات اللي راني نَكتَبهمَّلكُم آمَر من الرَب، ");
INSERT INTO arq_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","وَلاّ ما عْرَفش، يَبقا ما يَعرَفش. ");
INSERT INTO arq_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","هِمّالا يا خاوتي، أتشَوّقو باش تَتنَبّؤو وما تَمَّنعوش الهَدرة باللُغة، ");
INSERT INTO arq_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","بَصَّح كُل شي لازَم يْكون بالطْبَع وبالنِضام. ");
INSERT INTO arq_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","نَعلَمكُم يا الخاوة، باللي الإنجيل اللي بَشَّرتكُم بيه، اللي قْبَلتوه واللي راكُم تابتين فيه، ");
INSERT INTO arq_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","واللي بيه تْنالو السْلاك لو كان تْشَدّو فالكَلمة اللي بَشَّرتكُم بيها، غير وَلاّ آمَنتو في باطَل. ");
INSERT INTO arq_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","قْبَل كُل شي عْطيتكُم الشي اللي سْبَقت قْبَلتو أنا، باللي على حْساب الكْتوب، المَسيح مات على جال دْنوبنا، ");
INSERT INTO arq_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","نَدفَن وقام فاليوم التالَت على حْساب الكْتوب. ");
INSERT INTO arq_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","شافو صَفا والتَلاميد الطْناش، ");
INSERT INTO arq_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","أومبَعد شافوه كْتَر من خَمس مْية خو على مَرّة، الكُترة منهُم ما زالهُم حَيّين للآن وكايَن اللي ماتو، ");
INSERT INTO arq_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","أومبَعد شافو يَعقوب أومبَعد كامَل الرُسُل. ");
INSERT INTO arq_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","مع الأخَّر كامَل، شَفتو أنا تاني، أنا اللي كي الصْغير المَطروح. ");
INSERT INTO arq_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","خاطَر أنا العُرّة فالرُسُل، وما نَستاهَلش نَتسَمّا رَسول كي حْڤَرت كَنيسة الله. ");
INSERT INTO arq_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","بنَعمة الله نْكون واش نْكون، ونَعَّمتو ما كانَتش بلا فايدة، بالعَكس، خْدَمت كْتَر منهُم كامَل، ماشي أنا على كُلِّ حال، نَعمة الله اللي معايَ. ");
INSERT INTO arq_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","أنا وَلاّ هومَ، هَدي هِيَ بْشارَتنا، وهَدا واش آمَنتو. ");
INSERT INTO arq_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","وَلاّ نْبَرّحو باللي المَسيح قام، كيفاش كايَن منكُم اللي يْقولو باللي القِيامة من الموت ما كانش منها؟ ");
INSERT INTO arq_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","وَلاّ ما كانش القِيامة من الموت، هِمّالا المَسيح تاني ما قامش. ");
INSERT INTO arq_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","وَلاّ المَسيح ما قامش من الموت، هِمّالا بْشارَتنا باطلة، وإيمانكُم تاني باطَل. ");
INSERT INTO arq_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","وحْنا وَلّينا شْهود زور فالله كي شْهَدنا فالله باللي حْيا المَسيح وهُوَ ما حْياهش، وَلاّ صَح الموتى ما يَحياوش. ");
INSERT INTO arq_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","خاطَر وَلاّ الموتى ما يْقوموش، هِمّالا المَسيح تاني ما قامش. ");
INSERT INTO arq_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","وَلاّ المَسيح ما قامش، هِمّالا إيمانكُم باطَل، ومازالكُم في دْنوبكُم، ");
INSERT INTO arq_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","واللي ماتو وهومَ مومنين بالمَسيح ضاعو. ");
INSERT INTO arq_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","وَلاّ رْجينا فالمَسيح غير على جال هاد الحْياة، هِمّالا حْنا المْغابَن فالناس. ");
INSERT INTO arq_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","بَصَّح دُرك المَسيح قام، وهُوَ البْكَر مْتاع اللي ماتو. ");
INSERT INTO arq_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","وكيما كانَت الموت ببْنادَم، القِيامة من الموت تاني ببْنادَم، ");
INSERT INTO arq_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","خاطَر كيما كامَل يْموتو بآدَم، كيف كيف كامَل يْقومو بالمَسيح، ");
INSERT INTO arq_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","بَصَّح كُل واحَد في مْقامو: المَسيح البْكَر، أومبَعد اللي ليه، كي يْجي. ");
INSERT INTO arq_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","أمبَعد تْجي الآخرة، كي يْسَلَّم المَلك لله الآب، بَعد ما يْكون هَد كُل رْياسة وحُكمة وقُوّة، ");
INSERT INTO arq_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","خاطَر لازَم يَملَك حَتّى يْحَط كامَل عَديانو تَحت رَجليه، ");
INSERT INTO arq_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","والعْدو الأخراني اللي يَنهَد هُوَ الموت. ");
INSERT INTO arq_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","صَح، حَط كُل شي تَحت رَجليه. كي يْقول باللي كُل شي نْطاعلو، مَعلوم من غير اللي طَوَّعلو كُل شي. ");
INSERT INTO arq_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","وكي يْنْطاعلو كُل شي، داك الساع الإبن هُوَ بالدات يَنطاع للي طَوَّعلو كُل شي باش يْكون الله كُل شي في كُل شي. ");
INSERT INTO arq_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","وَلاّ ما كاش، واش يْديرو اللي تْعَمّدو في عوض الموتى؟ وَلاّ الموتى ما يْقوموش، وَعلاش يَتعَمّدو في خاطَرهُم؟ ");
INSERT INTO arq_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","وحْنا، وَعلاش في كُل ساعة مْسَبّلين؟ ");
INSERT INTO arq_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","وحَق فَخري بيكُم فالمَسيح رَبنا يا خاوتي، كُل يوم نْموت. ");
INSERT INTO arq_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","وَلاّ بمَنطَق بْني آدَم اللي قاوَمت الهْوايَش في آفسُس، واش هِيَ الفايدة مْتاعي؟ وَلاّ الموتى ما يْقوموش، ناكلو ونَشُّربو كي غَدوة نْموتو. ");
INSERT INTO arq_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ما تَنغَرّوش، العَشرة الشينة تْفَسَّد التْرَبية الزينة. ");
INSERT INTO arq_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","وَلّيو للصْواب، وبَطّلو من الدْنوب، خاطَر كايَن فيكُم اللي ما يَعَّرفوش الله، نْقول هاد الشي باش نْحَشَّمكُم. ");
INSERT INTO arq_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","بَصَّح الواحَد يْقول: كيفاش يْقومو الموتى؟ وكيفاش تْكون الدات اللي يْجيو فيها؟ ");
INSERT INTO arq_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","يا الجايَح، اللي تَزَّرعو ما يْوَلّيش يَحيا قْبَل ما يْموت، ");
INSERT INTO arq_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","اللي تَزَّرعو، ما تَزَّرعوش فالدات اللي رايَح يْنوض بيها، أنتَ تَزرَع زَرّيعة، قَمح وَلاّ زَرّيعة أخرى. ");
INSERT INTO arq_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","والله يَعطيلها الدات اللي يْحَب، كُل زَرّيعة يَعطيلها الدات مْتاعها. ");
INSERT INTO arq_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","كُل دات وَحَّدها، دات بْني آدَم وَحَّدها، دات الهْوايَش وَحَّدها، دات الطْيور وَحَّدها ودات الحوت وَحَّدها. ");
INSERT INTO arq_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","وكايَن دات سْماوِيّة ودات أرضِيّة، بَصَّح كل واحَد وَحدو. السْماوي عَندو بْها، والبْها مْتاع الأرضي ماشي كيف كيف. ");
INSERT INTO arq_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","البْها مْتاع الشَمس وَحدو، مْتاع القْمَر وَحدو ومْتاع النْجوم وَحدو، حَتّى النْجوم كُل واحدة وبْهاها. ");
INSERT INTO arq_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","هَكداك القِيامة من الموت. يَنزرَع يَفسَد، يْقوم ما يَفسَدش، ");
INSERT INTO arq_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","يَنزرَع فالمْهانة، يْقوم فالشان، يَنزرَع فالضَعف، يْقوم فالقُوّة، ");
INSERT INTO arq_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","يَنزرَع دات نَفسانِيّة، يْقوم دات روحانِيّة. وَلاّ كايَن دات نَفسانِيّة، كايَن تاني دات روحانِيّة. ");
INSERT INTO arq_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","على هَدا اللي مَكتوب: \"آدَم، الإنسان الأوَّل، وَلاّ نَفس حَيّة، وآدَم الأخراني روح تَحيي\". ");
INSERT INTO arq_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ماشي الروحاني الأوَّل، يَسبَق النَفساني باش يْجي الروحاني. ");
INSERT INTO arq_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","الإنسان الأولاني من الأرض ومَخلوق من التْراب، الإنسان الأخراني من السْما، ");
INSERT INTO arq_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","اللي من التْراب يْكونو كيما اللي نَخلَق من التْراب والسْماوي يْكون كيما السْماوِيّين، ");
INSERT INTO arq_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","وكيما رْفَدنا صِفة اللي من التْراب، رايحين نَرَّفدو صِفة السْماوي. ");
INSERT INTO arq_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","هاو واش راني نْقول يا الخاوة، الدَم واللْحَم ما يَقَّدروش يَوَّرتو مَلَكوت الله، والفاني ما يَورَتش اللي ما يَفناش. ");
INSERT INTO arq_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","نْقولَلكُم سَر: ماشي كامَل رايحين نْموتو بَصَّح كامَل رايحين نَتبَدّلو، ");
INSERT INTO arq_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","تَم تَم، في رَمشة عين، مع البوق الأخراني. خاطَر رايَح يْبَوَّق، والموتى يْقومو ما يَفناوش، وحْنا نَتبَدّلو. ");
INSERT INTO arq_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","لازَم اللي بطْبيعتو يَفسَد يَلبَس واش ما يَفسَدش واللي بطْبيعتو يْموت يَلبَس واش ما يْموتش. ");
INSERT INTO arq_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","كي اللي بطْبيعتو يَفسَد يَلبَس واش ما يَفسَدش واللي بطْبيعتو يْموت يَلبَس واش ما يْموتش، داك الساع يَتحَقَّق الكْلام المَكتوب: \"نْبَلعَت الموت فالنُصرة\"، ");
INSERT INTO arq_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","وين راهي نُصَرتَك يا موت؟ وين راهو مَهمزَك يا موت؟ ");
INSERT INTO arq_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","مَهمَز الموت هِيَّ الخْطِيّة، وقُوّة الخْطِيّة هِيَ الشَريعة، ");
INSERT INTO arq_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","بَصَّح الحَمدُ لله اللي يَعطيلنا النُصرة برَبّنا يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","هَكدا، يا خاوتي العْزاز، كونو تابتين، ما تَتزَعزعوش، كَتّرو دايمًا الخَدمة للرَب، وأعَّرفو باللي شْقاكُم ماشي باطَل فالرَب. ");
INSERT INTO arq_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","باش تْلَمّو الصَدَقة للقَدّيسين، ديرو أنتومَ تاني كيما وَرّيت لكْنايَس غَلاطية، ");
INSERT INTO arq_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","كُل واحَد فيكُم، فاليوم الأوَّل من كُل جَمعة، يْحَط بجيهة ويْلَم على حْساب مَقدورو، باش ما تَستَنّاوش حَتّى وين نْجي وتْلَمّو. ");
INSERT INTO arq_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","كي نَوصَل، نَبعَت اللي تْكونو خَيَّرتوهُم ومعاهُم بْراوات، يَدّيو صَدَقَتكُم لأورشَليم، ");
INSERT INTO arq_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","وَلاّ كان لازَم نْروح أنا تاني، يْروحو معايَ. ");
INSERT INTO arq_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","نْجوز على مَقدونية ونْجي لعَندكُم خاطَر راني جايَز لتَمة. ");
INSERT INTO arq_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","بَلاك نَبقا عَندكُم ونْجَوَّز حَتّى الشْتا، باش أنتومَ تْوَصلّوني باش نْكَمَّل السْفَر مْتاعي. ");
INSERT INTO arq_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","هاد المَرّة، ما رانيش حاب نْشوفكُم بَرك في طْريقي، نَتمَنّا نَبقا عَندكُم شْوِيّة، وَلاّ حَب الرَب. ");
INSERT INTO arq_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","راني رايَح نَبقا في آفسُس حَتّى ليوم الخَمسين، ");
INSERT INTO arq_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","خاطَر باب كْبيرة نْحَلَّت قُدّامي وفيها بْشارة خير والعَديان بَزّاف. ");
INSERT INTO arq_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","وَلاّ وْصَل تيموتاوَس، بَلاكو تْخَلّيوَه يْخاف عَندكُم، خاطَر يَخدَم عَندكُم خَدمة الرَب كيما أنايَ، ");
INSERT INTO arq_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","واحَد ما يَحَّڤرو، وَصّلوه فالسْلام باش يْجيني، خاطَر راني نَستَنّا فيه مع الخاوة. ");
INSERT INTO arq_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","الأَخ أبولّوس، سَجَّعتو بَزّاف باش يْجي لعَندكُم مع الخاوة، بَصَّح ما راهوش حاب يْجي دُرك، يْجي نْهار تْكون السَبّة. ");
INSERT INTO arq_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","رَدّو بالكُم، شَدّو فالإيمان، كونو رْجال، كونو قْوِايا، ");
INSERT INTO arq_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","كُل شي لازَم يَندار عَندكُم بالمْحَبّة. ");
INSERT INTO arq_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","نْوَصّيكُم يا الخاوة، تَعَّرفو باللي عايلة سْتَفاناس هِيَ باكورة أخّائية، وباللي خَصّصو روحهُم باش يَخَّدمو القَدّيسين. ");
INSERT INTO arq_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","أنطاعو لناس كيما هَدو ولكامَل اللي يَخَّدمو معاهُم ويَشقاو. ");
INSERT INTO arq_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","راني فَرحان بمْجي سْتَفاناس وفُرتوناتوس وأخائيكوس، نَسّاوني غْيابكُم، ");
INSERT INTO arq_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","وهَدّنولي روحي وروحكُم. لازَم تَعَّرفو قيمة ناس كي هَدو. ");
INSERT INTO arq_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","كْنايَس آسيا يْسَلّمو عليكُم، أكيلا وبْريسكِلاّ والكَنيسة اللي في دارهُم يْسَلّمو عليكُم بَزّاف فالرَب، ");
INSERT INTO arq_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","الخاوة كامَل يْسَلّمو عليكُم، سَلّمو على بَعضكُم بَعض ببوسة مْقَدّسة. ");
INSERT INTO arq_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","السْلام منّي بيَدّي أنا بولَس، ");
INSERT INTO arq_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","مَنعول اللي ما يْحَبش الرَب، يا رب، أرواح، ");
INSERT INTO arq_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","نَعمة الرَب يَسوع معاكُم، ");
INSERT INTO arq_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","مْحَبّتي ليكُم كامَل في يَسوع المَسيح.");
INSERT INTO arq_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","بولَس، رَسول المَسيح يَسوع بمُراد الله، وتيموتاوَس الأَخ، لكَنيسة الله اللي في كورَنتوس، ولكُل القَدّيسين اللي في كامَل أَخائِية، ");
INSERT INTO arq_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","نَعمة وسْلام ليكُم من عَند الله، بابانا، والرَب يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","مْبارَك الله باباة رَبّنا يَسوع المَسيح، مول الرَحمة وإلَه كُل عْزا، ");
INSERT INTO arq_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","اللي يْعَزّينا في كُل شَدَّتنا، باش نَقَّدرو حْنا نْعَزّيو اللي يْكونو فالشَدّة بالعْزا اللي نْنالوه حْنا بالدات من الله، ");
INSERT INTO arq_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","خاطَر قَد ما يَكَّترو وْجاع المَسيح فينا، قَد ما يَكتَر بالمَسيح عْزانا. ");
INSERT INTO arq_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","وَلاّ كُنّا فالشَدّة، هاد الشي لعْزاكُم وخْلاصكُم، وَلاّ كُنّا مْعَزّيين، هاد الشي لعْزاكُم اللي يْخَلّيكُم تَحَّملو الوْجاع اللي رانا حْنا تاني نْقاصيوهُم. ");
INSERT INTO arq_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ورْجانا ليكُم تابَت، عارفين باللي كيما تْسالو فالوْجاع، تْسالو تاني فالعْزا. ");
INSERT INTO arq_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","وما راناش حابّين يا الخاوة، نْخَبّيو عليكُم الشَدّة اللي جَوَّزناها في آسيا، واللي قْوات علينا وكانَت فوق طاقَتنا، حَتّى آيَسنا نَبقاو حَيّين. ");
INSERT INTO arq_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","كُنّا قْبَلنا في قْلوبنا حُكم الموت، باش ما نْكونوش تاكلين على روحنا، ويْكون تْكالنا على الله اللي يْرَد الموتى للحْياة، ");
INSERT INTO arq_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","هُوَ اللي سَلَّكنا ومازال يْزيد يْسَلَّكنا من موت كي هَدي، فيه اللي حَطّينا رْجانا باش يْزيد يْسَلَّكنا. ");
INSERT INTO arq_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","وعلى جال اللي أنتومَ تْعاونونا بالصْلاة لينا، ناس بَزّاف يَقَّدرو يَحَّمدو الله في خاطَرنا على جال كَترة الهِبات اللي يَنَعطاولنا بصْلاتكُم. ");
INSERT INTO arq_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","خاطَر الشي اللي نَفَّخرو بيه هُوَ شْهادة ضَميرنا، باللي مْشينا في هاد الدَنيا، وبخْصاص معاكُم، بالصْفا والنِيّة مْتاع الله وبنَعمة الله ماشي بحِكمة الدات، ");
INSERT INTO arq_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ما نَكَّتبولكُم غير الشي اللي تَقَّدرو تَقراوَه وتَفَّهموه. نَتمَنّا تَفَّهمو مْليح مْليح، ");
INSERT INTO arq_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","كيما سْبَق وفْهَمتو والو شْوِيّة، باللي بينا اللي تَفَّخرو كيما نَفَّخرو بيكُم في يوم رَبّنا يَسوع. ");
INSERT INTO arq_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","بهاد التيقة اللي عَوَّلت من الأَوَّل نْجيكُم باش نْزيدلكُم فَرحة أخرى، ");
INSERT INTO arq_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ومن عَندكُم نْروح لمَقدونِية ونْعاوَد من مَقدونِية نْجي لعَندكُم وأنتومَ تْوَصّلوني لليَهودِيّة. ");
INSERT INTO arq_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","كي عَوَّلت على هاد الشي، بَنت ما نْخَمَّمش، وَلاّ نَتصَرَّف على هْوا الدات، وكْلامي فيه \"إيه\" و\"لالا\"؟ ");
INSERT INTO arq_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","يَشهَد الله باللي كْلامنا ليكُم ما راهوش \"إيه\" و\"لالا\"، ");
INSERT INTO arq_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","خاطَر، ابن الله، يَسوع المَسيح، اللي بَرَّحنا بيه ليكُم، أنا وسلوانَس وتيموتاوَس، ماكانش \"إيه\" و\"لالا\"، فيه ما كايَن غير \"إيه\". ");
INSERT INTO arq_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","خاطَر فيه ال\"إيه\" لكامَل وْعود الله، وعلى هَدا فيه اللي نْقولو \"آمين\" لمَجد الله بينا. ");
INSERT INTO arq_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","اللي يْتَبَّتنا معاكُم فالمَسيح واللي دْهَننا هُوَ الله، ");
INSERT INTO arq_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","هُوَ تاني اللي طْبَعنا بخاتمو، وعْطا عَربون الروح في قْلوبنا. ");
INSERT INTO arq_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","نْشَهَّد الله، على رَقَّبتي، اللي ما جيتش لكورَنتوس غير باش نْحافَض عليكُم. ");
INSERT INTO arq_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ما راناش سْياد على إيمانكُم، رانا نْعاونو فيكُم لفَرحكُم، خاطَر بالإيمان اللي راكُم تابتين. ");
INSERT INTO arq_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","وأنا، عَوَّلت ما نْزيدش نْروح لعَندكُم وأنا حْزين، ");
INSERT INTO arq_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","خاطَر وَلاّ أنا غْبَنتكُم، شْكون يْفَرَّحني من غير اللي نَغبَن مَنّي؟ ");
INSERT INTO arq_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","كْتَبت واش كْتَبت باش ما نَنغبَنش كي نْجي من الناس اللي لازَم يْفَرّحوني. راني مَتيَقَّن من جيهَتكُم، باللي فَرحتي هِيَ فَرحَتكُم كامَل. ");
INSERT INTO arq_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","خاطَر وأنا في شَدّة كْبيرة، والقَلب ضَيَّق، وببَزّاف الدْموع اللي كْتَبتَلكُم، ماشي باش تَحَّزنو بَصَّح باش تَعَّرفو مْحَبّتي الكْبيرة ليكُم. ");
INSERT INTO arq_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","وَلاّ كان واحَد تْسَبَّب فالحْزَن، ما حَزَّننيش أنا، حَزَّنكُم أنتومَ كُلكُم... شْوِيّة، باش ما نْمَرَّڤهاش. ");
INSERT INTO arq_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","هاد الراجَل، اللوم اللي جاه من الكُترة فيكُم يَكفيه. ");
INSERT INTO arq_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","دُرك بالعَكس، لازَم تْسامحوه وتْعَزّيوَه يْعود يَنتكَل من كُترة الحْزَن. ");
INSERT INTO arq_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","هِمّالا، نْسَجَّعكُم تْبَيّنولو المْحَبّة، ");
INSERT INTO arq_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","خاطَر على هَدا تاني اللي كْتَبتَلكُم، باش نْجَرَّبكُم ونْشوف وَلاّ طاعَتكُم كاملة في كُل شي. ");
INSERT INTO arq_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","اللي تْسامحوه في حاجة، أنا تاني نْسامحو، خاطَر أنا وَلاّ سامَحت في شي، نْكون سامَحت على جالكُم قُدّام المَسيح، ");
INSERT INTO arq_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","باش ما يَدغُلناش الشيطان، خاطَر نِيّتو ماشي خافية علينا. ");
INSERT INTO arq_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","كي جيت لتَرواس باش نْبَشَّر بإِنجيل المَسيح، والو نْحَلَّتلي باب فالرَب، ");
INSERT INTO arq_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","روحي ما رْتاحَتش خاطَر ما لْقيتش خويَ تيطَس. هِمّالا بَقّيتهُم على خير ورُحت لمَقدونية. ");
INSERT INTO arq_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","الحَمد لله اللي يْڤَوَّدنا دايمًا في نُصَّرتو، فالمَسيح، واللي يْعَبَّق بينا ريحة مَعرِفتو في كُل مْكان، ");
INSERT INTO arq_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","خاطَر قُدّام الله، حْنا ريحة المَسيح للسالكين وللهالكين، ");
INSERT INTO arq_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","لهَدو ريحة موت للموت وللأخرين ريحة حْياة للحْياة. وشْكون يَقدَر على هاد الشي؟ ");
INSERT INTO arq_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","حْنا ماشي كيما الكُترة اللي يْتاجرو بكْلام الله. حْنا بالصْفا، من عَند الله، قُدّام الله وفالمَسيح اللي نَهَّدرو. ");
INSERT INTO arq_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","نْزيدو تاني نَشُّكرو روحنا؟ وَلاّ نَسَّحقو كيما شي ناس نْجيبولكُم بْراوات يْوَصّيو فيهُم علينا ونْدّيو منكُم بْراوات تْوَصّيو فيهُم علينا؟ ");
INSERT INTO arq_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","أنتومَ بْرِيَّتنا، المَكتوبة في قْلوبنا، مَعروفة ومَقرِيّة من كُل الناس، ");
INSERT INTO arq_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","بايَن باللي أنتومَ بْرِيّة المَسيح وحْنا اللي وَصَّلناها، نْكَتبَت ماشي بالحْبَر، نْكَتبت بروح الله الحَي، ماشي على لْواح الحْجَر، على لْواح اللْحَم. ");
INSERT INTO arq_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","هَدي هِيَ التيقة اللي عَندنا بالمَسيح عَند الله. ");
INSERT INTO arq_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ماشي مَحسوب حْنا بالدات قادرين نْديرو حاجة من عَندنا، قُدرَتنا جايّة من عَند الله، ");
INSERT INTO arq_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","هُوَ اللي رَدّنا قادرين نْكونو خُدّام العَهَد الجْديد، ماشي مْتاع الحَرف، مْتاع الروح، خاطَر الحَرف يَقتَل بَصَّح الروح يَحيي. ");
INSERT INTO arq_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","وَلاّ خَدمة الموت المَنقوشة فالحْجَر كان عَندها البْها، حَتّى كانو بْني إسرائيل ما يَقَّدروش يْحَقّقو في وَجه موسى على جال بْها وَجهو واللي كان زايَل، ");
INSERT INTO arq_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","بْها خَدمة الروح ما يْكونش كْتَر؟ ");
INSERT INTO arq_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","وَلاّ خَدمة الحُكم بالموت كان عَندها البْها، بْها خَدمة الصْلاح ما يْكونش كْتَر؟ ");
INSERT INTO arq_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","هِمّالا، حَتّى اللي كان مْبَهّي ما وَلاّش هَكداك قُدّام هاد البْها الزايَد. ");
INSERT INTO arq_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","خاطَر وَلاّ الزايَل نْطبَع بالبْها كيفاش هِمّالا يْكون الدايَم؟ ");
INSERT INTO arq_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","وعلى حْساب اللي عَندنا هاد الرْجا، نَتعامَل بتيقة كاملة، ");
INSERT INTO arq_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ماشي كيما موسى اللي كان يْحَط حْجاب على وَجهو، باش الإِسرائيلِيّين ما يْشوفوش البْها الزايَل يْروح، ");
INSERT INTO arq_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","بَصَّح تَخمامهُم عاصي، خاطَر الحْجاب ما زالو مَحطوط عَندهُم وما تْنَحّاش للآن كي يَقراو العَهَد القْديم خاطَر فالمَسيح اللي يَتنَحّا، ");
INSERT INTO arq_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","وللآن، كي يَقراو شَريعة موسى، كايَن حْجاب على قْلوبهُم، ");
INSERT INTO arq_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","بَصَّح كي نَستَرجعو للرَب يَتنَحّا الحْجاب. ");
INSERT INTO arq_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","الرَب هُوَ الروح ووين يْكون روح الرَب، تْكون الحُرِيّة. ");
INSERT INTO arq_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","حْنا كامَل، اللي مْنَحّي الحْجاب من وَجهنا، نْشوفو كي اللي في مْراية بْها الرَب، ونَتبَدّلو لهَديك الصِفة بالدات، من بْها لبْها كيما يْكون من الرَب، الروح. ");
INSERT INTO arq_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","على هَدا، ما دام عَندنا هاد الخَدمة، اللي نَلناها بالرَحمة، ما لازَمش نَفَّشلو. ");
INSERT INTO arq_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ما نَقَّبلوش العار اللي يَندار فالخْفا، ما نْسيروش بالخْدَع وما نْزَوّروش كْلام الله. بالعَكس، كي نْبَيّنو الحَق، نَشَّهدو لروحنا في ضْمايَر كُل الناس، قُدّام الله. ");
INSERT INTO arq_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","بَصَّح، وَلاّ بْشارة إِنجيلنا ما زالَت مَحجوبة، راهي مَحجوبة عَند اللي راهُم رايحين يْضيعو، ");
INSERT INTO arq_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","اللي إلَه هاد الزْمان عْمالهُم تَخمامهُم، اللي ماشي مومنين، باش ما يْشوفوش نور بْها إنجيل المَسيح، اللي هُوَ صِفة الله. ");
INSERT INTO arq_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","خاطَر، حْنا ما راناش نْبَرّحو برْواحنا، رانا نْبَرّحو باللي يَسوع المَسيح هُوَ رَب، وحْنا خَدّامينكُم على جال يَسوع. ");
INSERT INTO arq_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","خاطَر الله اللي قال: \"من الضْلام يْضَوّي النور\"، هُوَ اللي ضَوّا في قْلوبنا، باش تَبرَق مَعرِفة بْها الله على وَجه المَسيح. ");
INSERT INTO arq_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","عَندنا هاد الكَنز فينا حْنا مْواعَن الطين، باش يْبان باللي هاد القُوّة الهايلة من الله، ماشي منّا. ");
INSERT INTO arq_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","رانا مْضَيّقين من كُل جيهة بَصَّح ماشي مَعفوسين، مْهَوّلين بَصَّح ماشي قاطعين لِيّاس، ");
INSERT INTO arq_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","مَحڤورين بَصَّح ماشي مَسموح فينا، طايحين بَصَّح ماشي مِيّتين، ");
INSERT INTO arq_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","دايمًا مْسَبّلين للموت كيما يَسوع، باش تْبان فينا تاني حْياة يَسوع، ");
INSERT INTO arq_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","خاطَر، حْنا اللي رانا حَيّين، رانا دايمًا مْسَلّمين للموت على جال يَسوع، باش حْياة المَسيح تاني تْبان في داتنا الفانية، ");
INSERT INTO arq_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","هَكدا، الموت تَخدَم فينا، والحْياة فيكُم. ");
INSERT INTO arq_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","وكي عَندنا روح إيمان واحدة، على حْساب ماهو مَكتوب: \"آمَنت وعلى هَدا هْدَرت\"، حْنا تاني نامنو وعلى هَدا نَهَّدرو، ");
INSERT INTO arq_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","عارفين باللي اللي عاوَد حْيا الرَب يَسوع، يَحيينا حْنا تاني مع يَسوع ويْوَقَّفنا معاكُم قُدّامو. ");
INSERT INTO arq_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","خاطَر، كُل شي على جالكُم، باش كي تْفيض النَعمة على ناس بَزّاف، تْفَيَّض الحَمد لمَجد الله. ");
INSERT INTO arq_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","على هَدا، ما نَفَّشلوش. والو يَفنا البْنادَم منّا من بَرّا، من الداخَل يَتجَدَّد يوم بَعد يوم، ");
INSERT INTO arq_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","خاطَر الشَدَّة مْتاع هاد الوَقت جايزة وخْفيفة، قُدّام المَجد الهايَل والدايَم اللي تْوَجَّدهولنا. ");
INSERT INTO arq_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","على هَدا، ما لازَمش نْشوفو للشي اللي بايَن، لازَم نْشوفو للشي المَخفي، خاطَر البايَن جايَز بَصَّح المَخفي دايَم. ");
INSERT INTO arq_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","خاطَر رانا عارفين باللي، وَلاّ سُكناننا فالأرض، واللي ماهو غير خيمة، رايَح يَنهَد، عَندنا سُكنان فالسْما، دار دايمة وماشي مَخدومة بيَدّين بْني آدَم. ");
INSERT INTO arq_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","على هَدا رانا نْنازعو هَكدا، مَتشَوّقين باش نَلَّبسو سُكناننا السْماوي، ");
INSERT INTO arq_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","هات بَرك نْبانو لابسين وماشي عَريانين. ");
INSERT INTO arq_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","على هَدا، وحْنا في هاد الخيمة، رانا نْنازعو كي اللي رافدين التْقيل، خاطَر حابّين، ما نَتعَرّاوش، نَلَّبسو باش الحْياة تَبلَع واش راهو فاني فينا. ");
INSERT INTO arq_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","اللي وَجَّدنا لهاد الشي هُوَ الله، وهُوَ اللي عْطالنا عَربون الروح. ");
INSERT INTO arq_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","واتقين هِمّالا في كُل وَقت، عارفين باللي ما دامنا ساكنين فالدات، رانا مَتغَرّبين بْعيد على الله. ");
INSERT INTO arq_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","خاطَر، نَمشيو بالإيمان، ماشي بالشوفة، ");
INSERT INTO arq_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","رانا واتقين وحابّين خير لو كان نْهاجرو من الدات ونَسُّكنو قُدّام الله، ");
INSERT INTO arq_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","على هَدا، نْديرو مَجهودنا باش نْنالو رْضاه، ساكنين وَلاّ مْهاجرين. ");
INSERT INTO arq_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","خاطَر، لازَم كامَل نَنكَشفو في دار شْرَع المَسيح، باش كُل واحَد يَحصَد واش دار بداتو، مْليح وَلاّ دوني. ");
INSERT INTO arq_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","على حْساب اللي نَعَّرفو الخوف من الله، رانا حابّين نْقَنّعو بْني آدَم. حْنا مَكشوفين لله، ونَتمَنّا نْكونو مَكشوفين تاني في ضْمايَركُم. ");
INSERT INTO arq_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ما راناش حابّين نْزيدو نَمَّدحو روحنا ليكُم، بَصَّح رانا حابّين نَعطيوكُم السَبّة باش تَتباهاو بينا، باش تَلقاو واش تْواجبو اللي يَتباهاو بالوَجه ماشي بالقَلب. ");
INSERT INTO arq_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","خاطَر، وَلاّ ما عَندناش العْقَل، هاد الشي يْخُص الله، وَلاّ عَندنا العْقَل، هاد الشي يْخَصّكُم. ");
INSERT INTO arq_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","خاطَر مْحَبّة المَسيح تْسيطَر علينا، مَقتَنعين بهاد الشي، واحَد مات على الكُل، هِمّالا كامَل ماتو، ");
INSERT INTO arq_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ومات على الكُل، باش الحَيّين ما يْزيدوش يَحياو ليهُم، يَحياو للي مات وعاوَد حْيا على جالهُم. ");
INSERT INTO arq_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","هِمّالا، حْنا من دُرك، ما لازَم نَحُّكمو على حَتّى واحَد على حْساب الضاهَر، والو عْرَفنا المَسيح على حْساب الضاهَر، دُرك ما وَلّيناش نَعَّرفوه بهاد الصِفة. ");
INSERT INTO arq_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","يَعني، وَلاّ الواحَد هُوَ فالمَسيح، هَدي خْليقة جْديدة، القْديم جاز، هاو الجْديد. ");
INSERT INTO arq_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","وكُل شي جاي من الله اللي صالَحنا معاه بالمَسيح، واللي عْطالنا كَلافة المُصالَحة. ");
INSERT INTO arq_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","خاطَر الله كان فالمَسيح، يْصالَح الدَنيا مع روحو، بلا ما يَحسَب غْلاطهُم، وحَط فينا كَلافة المُصالحة، ");
INSERT INTO arq_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","هِمّالا حْنا سُفَرا للمَسيح، كي اللي الله يْسَجَّع بينا. نَترَجّاوكُم بآسم المَسيح، أتصالحو مع الله. ");
INSERT INTO arq_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","اللي ما دارش الخْطِيّة، رَدّو ضْحِيّة خْطِيّة على جالنا، باش فيه نْوَلّيو صْلاح الله. ");
INSERT INTO arq_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","على حْساب اللي نَخَّدمو مع الله، نَطَّلبو منكُم ما تْخَلّيوش النَعمة اللي نَلتوها من الله بلا فايدة، ");
INSERT INTO arq_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","خاطَر يْقول: \"فالوَقت المْليح سْتاجَبتلَك. في يوم السْلاك، نَجّيتَك. هاو دُرك الوَقت المْليح، هاو دُرك يوم السْلاك.\" ");
INSERT INTO arq_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ما نَعطيو السَبّة فالعَترة لحَتّى واحَد، باش خَدمَتنا ما تَتلامش. ");
INSERT INTO arq_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","بالعَكس، في كُل شي نْبَيّنو روحنا خَدّامين الله، بالصْبَر الكْبير فالشْدايَد، فاللازمات، فالتَهوال، ");
INSERT INTO arq_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","فالضْرابي، فالحْباس، فالهول، فالعْيا، فسَهرات الليل، فالصْيام، ");
INSERT INTO arq_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","بالصْفا، بالعَلم، بتَسِعة الخاطَر، بالمْلاحة، بالروح القُدّوس، بمْحَبّة بلا تْنوفيق، ");
INSERT INTO arq_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","بكْلام الحَق، بقُدرة الله، بسْلاح الصْلاح فالهَجمة والمْحامية، ");
INSERT INTO arq_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","فالشان والمْهانة، مَدكورين بالمْليح وَلاّ بالدوني، شايفيننا خَدّاعين والو حَقّانِيّين، ");
INSERT INTO arq_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","غُرابا والو مَعروفين، فالمَمات والو حَيّين، مْعاقبين بَصَّح هانا ماشي مَقتولين، ");
INSERT INTO arq_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","مْغَبّنين بَصَّح دايمًا فَرحانين، ڤْلالين بَصَّح نَغنيو الأخرين، ما عَندنا والو بَصَّح مالكين كُل شي. ");
INSERT INTO arq_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","صارَحناكُم يا الكورَنتيّين، حَلّينالكُم قَلبنا، ");
INSERT INTO arq_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ما راكُمش فالضيق عَندنا، في قْلوبكُم اللي راكُم تْحَسّو هَكدا. ");
INSERT INTO arq_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","كافيونا، راني نَهدَر معاكُم كي وْلادي، أتوَسعولنا أنتومَ تاني. ");
INSERT INTO arq_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ما تْروحوش تَنحَطّو مع الكُفّار تَحت مَضمَض بَرّاني. خاطَر فاش يَشرَك الصْلاح مع الشَر، وفاش يَشرَك الضو مع الضْلام؟ ");
INSERT INTO arq_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","واش من العْقَد بين المَسيح وإبليس وواش هُوَ نْصيب المومَن مع الكافَر؟ ");
INSERT INTO arq_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","واش من العْقَد بين هَيكَل الله والأصنام؟ خاطَر حْنا هَيكَل الله الحَي كيما قال الله: \"نَسكُن في وَسطهُم وفي وَسطهُم نَمشي، ونْكون أنا إِلَههُم وهومَ يْكونو شَعبي، ");
INSERT INTO arq_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","على هَدا، أخُّرجو من وَسطهُم وأنفَرّقو عليهُم، يْقول الرَب، ما تْمَسّوش الناجَس وأنا نَقبَلكُم، ");
INSERT INTO arq_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","نْكون باباكُم وتْكونو وْلادي وبْناتي.\" يْقول الرَب القادَر. ");
INSERT INTO arq_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","على حْساب اللي نَلنا هاد الوْعود، يا الحْباب، هَيّا نَتطَهّرو حْنا بالدات من كُل خْماج مْتاع الدات والروح، نْكَمّلو نَتقَدّسو فالخوف من الله. ");
INSERT INTO arq_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ديرولنا مْكان، ما ضَرّينا حَتّى واحَد، ما فَلَّسنا حَتّى واحَد، ما فارَصنا في حَتّى واحَد، ");
INSERT INTO arq_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ما رانيش نْقول هَكدا باش نَحكُم عليكُم، خاطَر قُلتها من قْبَل: راكُم في قْلوبنا فالموت وفالحْياة. ");
INSERT INTO arq_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","عَندي تيقة كْبيرة فيكُم، نَفخَر بَزّاف بيكُم، تْسَجَّعت بَزّاف وراني طايَر بالفَرحة مع كامَل الشَدّة مْتاعنا. ");
INSERT INTO arq_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","فالصَح، من اللي وْصَلنا لمَقدونية، ما رَيَّحناش. تْضايَقنا من كُل جيهة، الدْواس دايَر بينا والخوف في قْلوبنا، ");
INSERT INTO arq_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","بَصَّح الله اللي يْعَزّي المَتواضعين، عَزّا قْلوبنا بالمْجي مْتاع تيطَس، ");
INSERT INTO arq_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","وماشي بَرك بالمْجي مْتاعو، بَصَّح بالعْزا اللي تْعَزّا منكُم. وَصَّلَّلنا شوقكُم الكْبير، ودْموعكُم، وغيرَتكُم علِيَّ حَتّى أنا زادَت كَبرَت فَرحتي. ");
INSERT INTO arq_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","خاطَر وَلاّ حَزَّنتكُم ببْرَيّتي، ما رانيش نادَ،. حَتّى لو كان نْدَمت، راني شايَف باللي هاد البْرِيّة والو حَزّنَتكُم في ساعة، ");
INSERT INTO arq_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","دُرك نَفرَح، ماشي على جال اللي حْزَنتو، بَصَّح على جال اللي حْزَنتو للتوبة. خاطَر حْزَنتو على حْساب مُراد الله، وهَكدا ما نْضَرّيتو منّا في حَتّى شي. ");
INSERT INTO arq_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","خاطَر الحْزَن على حْساب مُراد الله، يَدّي للتوبة اللي تْوَصَّل للسْلاك بلا نْدامة، بَصَّح الحْزَن مْتاع الدَنيا يَدّي للموت. ");
INSERT INTO arq_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","هاوليك هِمّالا هَدا حْزَنكُم بالدات اللي كان كيما يْحَب الله واش دار فيكُم: واش من الحَماس، واش من طْلَب السْماح، واش من النْدامة، واش من الخوف، واش من الشوق، واش من الغيرة، واش من المْحاسبة. بَيَّنتو بكُل صِفة باللي أنتومَ صافيين في هاد الدَعوة. ");
INSERT INTO arq_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","هِمّالا، كي كْتَبتَلكُم، ما كان هاد الشي لا على جال اللي ضْلَم وَلا على جال اللي نَضلَم، بَصَّح باش تْبان عَندكُم غيرَتكُم علينا قُدّام الله. ");
INSERT INTO arq_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","على هَدا، تْعَزّينا. زيد على هاد العْزا، زَدنا فْرَحنا كْتَر بفَرحة تيطَس على جال الهْنا اللي نالو منكُم في روحو، ");
INSERT INTO arq_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","خاطَر وَلاّ كُنت زُخت عليه بيكُم، راني ما تْحَشَّمتش، بَصَّح كيما قُلنالكُم الصَح في كُل شي، زوخنا بيكُم قُدّام تيطَس تاني كان مَبني على الصَح، ");
INSERT INTO arq_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","وزادَت مْحَبّتو ليكُم، مَتفَكَّر طاعَتكُم كامَل، كيفاش لاقيتوه بالخوف والرَعشة. ");
INSERT INTO arq_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","راني فَرحان اللي نَقدَر نَتكَل عليكُم في كُل شي. ");
INSERT INTO arq_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","نَعَّلموكُم يا الخاوة، بنَعمة الله اللي نَعطات لكْنايَس مَقدونِية، ");
INSERT INTO arq_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","في كامَل الشَدّة اللي مْجَوّزينها، فَرحَتهُم كانَت كْبيرة وكانو كْرام بالزْيادة والو ڤْلالين بَزّاف، ");
INSERT INTO arq_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","مَدّو بمْحَبّة خاطَر على حْساب مَقدورهُم، نَشهَد، وحَتّى فوق مَقدورهُم، ");
INSERT INTO arq_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","طَلبو ووَكّدو علينا باش يْكون ليهُم النْصيب في مْعاونة القَدّيسين. ");
INSERT INTO arq_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","دارو كْتَر ممّا تْمَنّينا، ووَهبو روحهُم للرَب قْبَل، أومبَعد لينا بمُراد الله. ");
INSERT INTO arq_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","على هَدا، سَجَّعنا تيطَس يْكَمَّل عندكُم هاد الخَدمة كيما كان سْبَق وبْداها. ");
INSERT INTO arq_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","وكيما عَندكُم كُل شي بالزْيادة، الإيمان، فَن الكْلام، العَلم، كُل صِفة حَماس، والمْحَبّة اللي زْرَعناها فيكُم، كونو كْرام في هاد الخَدمة بالزْيادة. ");
INSERT INTO arq_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ما رانيش نامَركُم، بَصَّح حَبّيت نْغَيَّركُم بالحَماس مْتاع الأخرين باش يْبان الصَح مْتاع مْحَبَّتكُم. ");
INSERT INTO arq_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","خاطَر تَعَّرفو نَعمة رَبّنا يَسوع المَسيح، هُوَ اللي كان مْرَفَّه ووَلاّ ڤَلّيل على جالكُم، باش تَترَفّهو بالفقر مْتاعو. ");
INSERT INTO arq_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","نَعطي راي في هَدا، هاد الشي يْليق بيكُم، خاطَر أنتومَ اللي ماشي بَرك بْديتو، بَصَّح كُنتو الأولانِيّين اللي حَبّيتو تْلَمّو الصَدَقة من العام اللي فات. ");
INSERT INTO arq_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","دُرك كَمّلو باش كيما تْحَمَّستو كي عَوَّلتو تْكونو هَكداك كي تْطَبّقو على حْساب مَقدوركُم. ");
INSERT INTO arq_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","فالصَح، كي يْكون الواحَد مْعَوَّل، يْنَقبَل منّو على حْساب واش عَندو ماشي على حْساب واش ما عَندوش، ");
INSERT INTO arq_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","خاطَر ماشي باش تْعاونو الأخرين، تَبقاو أنتومَ فالحوج. لازَم تْكونو مَتساويين. ");
INSERT INTO arq_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","في هاد الضُروف، اللي يْشيط عليكُم يْكَمَّل واش يْخَصّهُم، باش اللي يْشيط عليهُم تاني يْكَمَّل واش يْخَصّكُم وتْكونو مَتساويين، ");
INSERT INTO arq_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","على حْساب ماهو مَكتوب: \"اللي عَندو بَزّاف ما شاطش عليه، واللي عَندو شْوِيّة ما نْخَصّش\". ");
INSERT INTO arq_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","الحَمد لله اللي حَط في قَلب تيطَس بْحال هاد الحَماس ليكُم، ");
INSERT INTO arq_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","خاطَر كي سَجَّعناه قْبَل وتْحَمَّس كْتَر من العادة وراهو رايَح يْجيكُم بمْحَبّة خاطرو، ");
INSERT INTO arq_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","بْعَتنا معاه الأَخ اللي كامَل الكْنايَس يَمَّدحوه على جال خَدَّمتو للإِنجيل. ");
INSERT INTO arq_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","زيد بزْيادة، عَيّنوه الكْنايَس باش يْرافَقنا فالسْفَر كي نَدّيو الصَدقة. هاد الخَدمة اللي تْكَلَّفنا بيها لمَجد الرَب، شْهادة على حَماسنا. ");
INSERT INTO arq_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ما راناش حابّين كاش واحَد يْلومنا على جال الصَدَقة الكْبيرة اللي رانا مْكَلّفين بيها، ");
INSERT INTO arq_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","حابّين نْديرو الصَح ماشي بَرك قُدّام الرَب، وتاني قُدّام الناس. ");
INSERT INTO arq_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","بْعَتنا معاهُم الأَخ اللي جَرَّبنا حَماسو في شْحال من سَبّة واللي راهو مَتحَمَّس كْتَر هاد المَرّة على جال تيقتو الكْبيرة فيكُم. ");
INSERT INTO arq_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","من جيهة تيطَس، هُوَ رْفيقي ومْعاوني فالشي اللي يْخَصّكُم، ومن جيهة الخاوة، هومَ مَرسولين من الكْنايَس، مَجد المَسيح. ");
INSERT INTO arq_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","وَرّيو هِمّالا التْبوت مْتاع مْحَبَّتكُم قُدّام الكْنايَس وباللي عَندنا الحَق كي نْزوخو بيكُم. ");
INSERT INTO arq_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","في آمَر الصَدَقة للقَدّيسين، ماشي لازَم نَكتَبَّلكُم، ");
INSERT INTO arq_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","خاطَر نَعرَف شْطارَتكُم اللي نَتباها بيها قُدّام المَقدونِيّين. أخائِية راهي واجدة من العام اللي فات والكُترة نَعداو من حَماسكُم. ");
INSERT INTO arq_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","بْعَتَّلكُم الخاوة باش زوخنا بيكُم في هاد الشي ما يْكونش على باطَل، باش كيما قُلت تْكونو واجدين مْليح، ");
INSERT INTO arq_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","نْعودو لو كان يْجيو مْعايَ المَقدونِيّين وما يَلقاوكُمش واجدين، نَنبُخصو باش ما نْقولش تَنبُخصو، على اللي كُنّا واتقين فيكُم. ");
INSERT INTO arq_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","خَمَّمت اللي لازَم نَطلَب من الخاوة يَسَّبقونا لعَندكُم ويْوَجّدو من قْبَل البَرَكة اللي وْعَدتو بيها، باش تْكون واجدة كونها بَركة وماشي شَحّة. ");
INSERT INTO arq_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","هَكدا، اللي يَزرَع بالشَحّة يَحصَد تاني بالشَحّة، واللي يَزرَع بالزْيادة يَحصَد تاني بالزْيادة. ");
INSERT INTO arq_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","كُل واحَد هِمّالا يْمَد كيما سْبَق عَوَّل في قَلبو، ماشي فوق قَلبو وَلاّ بالسيف عليه، خاطَر الله يْحَب اللي يْمَد وهُوَ فَرحان، ");
INSERT INTO arq_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","والله قادَر يْفَيَّض عليكُم الخير من كُل نوع، باش يْكون عَندكُم في كُل وَقت واش لازَمَّلكُم وتْكون عَندكُم الزْيادة لفْعال الخير، ");
INSERT INTO arq_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","كيما نَكتَب: \"فَرَّق البَرَكة، مَد للڤْلالين، صْلاحو باقي للدْوام\". ");
INSERT INTO arq_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","اللي يَعطي الزَرّيعة للفَلاّح، والخُبز للقوت، يَعطيكُم الزَرّيعة ويْكَتَّرها ويْكَبَّر غَلّة صْلاحكُم، ");
INSERT INTO arq_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","وتَترَفّهو في كُل شي باش تْكونو كْرام وهاد الشي يْجيب الحَمد لله من الناس اللي نْوَصلولهُم الصَدَقة من عَندكُم، ");
INSERT INTO arq_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","خاطَر هاد الصَدَقة ماشي بَرك تْنوب على القَدّيسين في حوجهُم، هِيَ تاني تْكَتَّر الحَمد لله، ");
INSERT INTO arq_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","وكي يَعَّرفو قيمة هاد الصَدَقة، يَحَّمدو الله على طاعَتكُم اللي تَستَعرفو بيها ببْشارة المَسيح وعلى كونكُم كْرام كي تَقَّسمو خيركُم معاهُم ومع الكُل، ");
INSERT INTO arq_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","وفي صْلاتهُم ليكُم، يْبَيّنو مْعَزَّتكُم على جال نَعمة الله الفايضة عليكُم. ");
INSERT INTO arq_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","الحَمد لله على هِبتو اللي ما تْنَوصَفش. ");
INSERT INTO arq_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","أنا بولَس بنَفسي، المَتواضَع وأنا بيناتكُم والواعَر وأنا غايَب عليكُم، نَطلَب منكُم على وَجه حْنانة ومْلاحة المَسيح، ");
INSERT INTO arq_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","نَترَجّاكُم، باش ما نَتعامَلش معاكُم بالقْباحة كي نَحضَر عَندكُم، كيما راني مْعَوَّل نْدير وأنا مَنّي صَح مع اللي يَتَّهمونا باللي حْنا نْسيرو على حْساب الدات. ");
INSERT INTO arq_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","خاطَر صَح رانا عايشين فالدات بَصَّح ما نْحاربوش بمَنطَق بْني آدَم، ");
INSERT INTO arq_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","خاطَر السْلاح اللي نْحاربو بيه ماشي سْلاح بْني آدَم. بالعَكس، سْلاحنا عَندو القُدرة من الله باش يْهَد الحْصون. نْكَسّرو العَقليّات المَتكَبّرين، ");
INSERT INTO arq_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","وكُل قُدرة عالية تَوقَف ضَد مَعرِفة الله، ونَحَّكمو كُل تَخمام باش نَدّيوَه مْكَتَّف لطاعة المَسيح. ");
INSERT INTO arq_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","رانا واجدين باش نَتغَلّبو على كُل عَصيان غير تْكون طاعَتكُم كاملة. ");
INSERT INTO arq_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","شوفو الحاجات كيما راهُم. وَلاّ كان واحَد مَقتَنَع في روحو باللي هُوَ للمَسيح، لازَم يْعاوَد حْسابو في هاد الشي، باللي كيما هُوَ للمَسيح، هَكدا حْنا تاني. ");
INSERT INTO arq_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","وحَتّى لو كان نْكون نَفَخَر كْتَر من اللازَم بالحُكمة اللي عْطاهالنا الله لبَنيانكُم وماشي لهْلاككُم، ما رانيش حَشمان بهاد الشي. ");
INSERT INTO arq_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ما تَحَّسبونيش حاب نْخَوَّفكُم ببْراواتي، ");
INSERT INTO arq_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","خاطَر يْقولو، بْراواتو قاسيين وواعرين، بَصَّح كي يْكون حاضَر بداتو، ضْعيف وكَلمتو مَهيونة. ");
INSERT INTO arq_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","لازَم يَعرَف، اللي يَهدَر هَكدا، باللي كيما هومَ قْوالنا في بْراواتنا وحْنا غايبين، هَكداك فْعالنا وحْنا حاضرين. ");
INSERT INTO arq_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","خاطَر، ما نَقَّدروش نْساويو وَلاّ نْقارنو روحنا مع هَدوك اللي حاسبين روحهُم، وهومَ يْقيسو روحهُم بروحهُم ويْقارنو روحهُم بروحهُم، ما يَفَّهموش. ");
INSERT INTO arq_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","وحْنا، ما راناش رايحين نَعطيو قيمة لروحنا فوق الحَد. بالعَكس، قيمتنا هِيَ على حْساب الخَدمة اللي قْسَمهانا الله ووَصَّلنا حَتّى لعَندكُم. ");
INSERT INTO arq_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ما راناش نَتعَدّاو حْدودنا كي اللي ما وْصَلناش لعَندكُم، خاطَر وْصَلنا حَّتى لعَندكُم ببْشارة المَسيح. ");
INSERT INTO arq_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ما نْزوخوش بلا طْبَع بخَدمة الأخرين، بَصَّح نَتمَنّاو، وَلاّ زاد إيمانكُم، نَكَّبرو عَندكُم على قيس خَدمَتنا كْتَر وكْتَر، ");
INSERT INTO arq_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ونْبَعّدو بخْبَر الإِنجيل في مْدارب تانيين، ماشي نْزوخو بالشي اللي نْدار في حْدود ناس أخرين. ");
INSERT INTO arq_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","اللي يْزوخ، يْزوخ فالرَب. ");
INSERT INTO arq_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","خاطَر المْخَيَّر ماشي اللي يَمدَح روحو، اللي يَمَّدحو الرَب. ");
INSERT INTO arq_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","لو كان بَرك تَحَّملو منّي شْوِيّة هْبال، بَصَّح راكُم تَحَّملوني، ");
INSERT INTO arq_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","خاطَر نْغير عليكُم غيرة الله، وخْطَبتكُم لراجَل واحَد باش نْقَدَّمكُم للمَسيح كي العَضرة الطاهرة. ");
INSERT INTO arq_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","راني خايَف، لو كان، كيما الحْنَش غَر حَوّة بالحيلة مْتاعو، يْضيع تَخمامكُم بْعيد على الصْفا والوْفا للمَسيح. ");
INSERT INTO arq_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","وَلاّ الأولاني اللي يْجي يْبَرَّح بيَسوع آخُر من غير اللي بَرَّحنا بيه، وَلاّ تْنالو روح آخُر من غير اللي نَلتوه، وَلاّ إِنجيل آخُر من غير اللي قْبَلتوه، تَحَّملو مْليح. ");
INSERT INTO arq_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","نْشوف باللي ما راني ناقَص في حَتّى شي على هاد خْيار-الرُسُل. ");
INSERT INTO arq_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","وَلاّ كُنت ضْعيف فالكْلام، ما رانيش هَكداك فالعَلم، وبانَلكُم هاد الشي في شْحال من مَرّة وفي كُل حاجة قُدّام الكُل. ");
INSERT INTO arq_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","وَلاّ دَرت خْطِيّة كي هَبَّطت روحي باش تْكونو طالعين، وبَرَّحتَلكُم بالإِنجيل باطَل؟ ");
INSERT INTO arq_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","عَرّيت كْنايَس أخرين وقْبَلت منهُم خْلاص على خَدمَتكُم، ");
INSERT INTO arq_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","وكي كُنت عَندكُم ونْخَصّيت، ما فارَصت في حَتّى واحَد، والخاوة اللي جاو من مَقدونِية هومَ اللي تْكَفّلو بواش خَصني، وما قْبَلت نْكون في كَلافة حَتّى واحَد عَندكُم، وما رانيش رايَح نَقبَل. ");
INSERT INTO arq_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","وحَق المَسيح اللي فِيَّ، ما كاش اللي يْنَحّيلي هاد الشيعة في جْوايَه أخائِية. ");
INSERT INTO arq_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","عْلاش؟ خاطَر ما نْحَبكُمش؟ الله يَعلَم. ");
INSERT INTO arq_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","الشي اللي راني نْديرو، نْكَمَّل نْديرو، ونْنَحّي السَبّة للي راهُم يْحَوّسو على السَبّة باش يْكونو مْساويينا فالشي اللي يْزوخو بيه، ");
INSERT INTO arq_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ناس كي هَدو، هومَ رُسُل كَدّابين، خَدّامين خَدّاعين، يْمَتلو باللي هومَ رُسُل المَسيح. ");
INSERT INTO arq_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ماشي موغريبة، خاطَر الشيطان بالدات يْمَتَّل روحو مْلاك النور، ");
INSERT INTO arq_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ماشي حاجة كْبيرة وَلاّ الخَدّامين مْتاعو تاني يْمَتّلو روحهُم خَدّامين الصْلاح، هومَ اللي تَخلاص عليهُم على حْساب فْعالهُم. ");
INSERT INTO arq_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","نْعاوَد نْقول، حَتّى واحَد ما يَحسَبني مَهبول، وَلاّ أقَّبلوني هَكدا مَهبول باش أنا تاني نَقدَر نَمدَح روحي شْوِيّة. ");
INSERT INTO arq_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","اللي راني نْقول فيه، ما رانيش نْقول فيه على حْساب الرَب، بَصَّح كي اللي في هْبال، وأنا شايَف روحي قادَر نْزوح. ");
INSERT INTO arq_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","كي كايَن بَزّاف اللي يَمَّدحو روحهُم على حْساب الدات، أنا تاني نَمدَح روحي. ");
INSERT INTO arq_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","تَحَّملو مْليح المْهابَل، أنتومَ العاقلين، ");
INSERT INTO arq_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","تَحَّملو لو كان واحَد يَستَعبَدكُم، لو كان واحَد ياكُلكُم، لو كان واحَد يْفارَص فيكُم، لو كان واحَد يَتكَبَّر عليكُم، لو كان واحَد يَضرَبكُم للوَجه، ");
INSERT INTO arq_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","نْقولها، هَدا عار، شْحال كُنّا ضْعاف. بَصَّح باش قادرين يَتباهاو هومَ -راني نَهدَر كي المَهبول- أنا تاني نَقدَر نَتباها، ");
INSERT INTO arq_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","عَبرانِيّين هومَ؟ أنا تاني. إسرائيلِيّين هومَ؟ أنا تاني. من دَريّة إبراهيم هومَ؟ أنا تاني. ");
INSERT INTO arq_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","خَدّامين المَسيح هومَ؟ راني نَهدَر كي الجايَح، أنا كْتَر منهُم. بالعْيا؟ كْتَر، مَضروب؟ بَزّاف، فالحْباس؟ كْتَر، مَسبَّل للموت؟ شْحال من مَرّة، ");
INSERT INTO arq_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","خَمس مَرّات أدّيت من اليْهود رَبعين جَلدة غير واحدة، ");
INSERT INTO arq_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","تَلت مَرّات وأنا نَنضرَب بالحْطَب، مَرّة نَرجَمت بالحْجَر، تَلت مَرّات والبابور يَغرَق بِيَّ، جَوَّزت ليلة ونْهار في وَسط البْحَر، ");
INSERT INTO arq_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","سْفَر على رَجليَّ؟ شْحال من مَرّة. مْسَبَّل في هْلاك الويدان، هْلاك السَرّاقين، هْلاك زَرّيعتي، هْلاك الكُفّار، هْلاك المْدينة، هْلاك الخْلا، هْلاك البْحَر، هْلاك الخاوة الكَدّابين، ");
INSERT INTO arq_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","العْيا والشْقا، شْحال من ليلة بلا رْقاد، فالجوع والعْطَش، فالصْيام شْحال من مَّرة، فالبَرد والعْرا، ");
INSERT INTO arq_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","بلا الحاجات الأخرين: تَخمامي مْتاع كُل يوم، هَم كامَل الكْنايَس، ");
INSERT INTO arq_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","شْكون يَضعَف وأنا ما نَضعَفش؟ شْكون يْطيح وأنا ما نَنحرَقش؟ ");
INSERT INTO arq_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","وَلاّ لازَم يَنزاخ، أنا نْزوح بضَعفي. ");
INSERT INTO arq_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","الله باباة الرَب يَسوع، المْبارَك للدْوام، يَعرَف باللي ما رانيش نَكدَب. ");
INSERT INTO arq_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","في دِمَشق، حاكَم السَلطان الحارَت حَط عَسّاسين على مْدينة الدِمَشقِيّين باش يَحَّكموني، ");
INSERT INTO arq_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","وهَبّطوني من الطاقة في سَلّة على حيط الصور باش سْلَكت من يَدّو. ");
INSERT INTO arq_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","لازَم يَنزاخ؟ هاد الشي بلا فايدة. بَصَّح نْروح لرُؤيات ووَحي من الرَب. ");
INSERT INTO arq_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","نَعرَف إِنسان فالمَسيح، من رْبَعطاشَن سْنة -ما نَعرَف وَلاّ في داتو وَلاّ بغير داتو، الله يَعرَف- نَخطَف هاد الراجَل حَتّى للسْما التالتة. ");
INSERT INTO arq_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","وراني عارَف باللي هاد الإِنسان، في داتو ولا بغير داتو -ما نَعرَف، الله يَعرَف-، ");
INSERT INTO arq_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","باللي نَخطَف للجَنّة، وسْمَع كْلايَم ما يَتَّنطقوش، ماشي مَسموح للإِنسان باش يْقولهُم. ");
INSERT INTO arq_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","بهاد الراجَل نْزوخ، بَصَّح بِيَّ أنا ما نْزوخش، وما نْدير قيمة لروحي غير في ضَعفي. ");
INSERT INTO arq_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","لو كان حَبّيت نْدير قيمة لروحي، ما نْكونش ناقَص عْقَل، خاطَر نْقول الصَح. بَصَّح ما نَسمَحش لنَفسي، باش الواحَد يْقَيَّمني على حْساب واش يْشوف فِيَّ وواش يَسمَع منّي وماشي كْتَر، ");
INSERT INTO arq_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","وعلى جال هاد الوَحي الهايَل. على هَدا، وباش ما نَتكَبَّرش، نْحَطَّت في داتي شوكة، مَرسول من الشيطان باش يَضرَبني باش ما نَتكَبَّرش. ");
INSERT INTO arq_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","في هاد الآمَر، تْرَجّيت الرَب تَلت مَرّات باش يْبَعَّدها علِيَّ، ");
INSERT INTO arq_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","بَصَّح قاللي: \"تَكفيك نَعَّمتي، خاطَر القُدرة تَكمَل فالضَعف\". خير هِمّالا نْدير قيمتي في ضَعفي باش تْجي علِيَّ قُدرة المَسيح. ");
INSERT INTO arq_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","على هَدا، نَفرَح بالضَعف، بالسَبّان، باللازمات، بالحُڤرة، بالتَهوال، على جال المَسيح، خاطَر كي نْكون ضْعيف، تَم نْكون قْوي. ");
INSERT INTO arq_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","وَلّيت ناقَص عْقَل، أنتومَ اللي وَصَّلتوني. كان لازَم أنتومَ اللي تَمَّدحوني خاطَر ما راني ناقَص في حَتّى شي على هاد خْيار-الرُسُل، حَتّى وأنا والو. ");
INSERT INTO arq_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","مارات الرَسول نْدارو قُدّامكُم بشْحال من الصْبَر: مارات وعْجايَب ومُعجِزات. ");
INSERT INTO arq_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","واشَن هُوَ الشي اللي نَلتوه قَل من الكْنايَس الأخرين، من غير اللي ما صْرفتوش علِيَّ؟ أغَّفرولي هاد الباطَل. ");
INSERT INTO arq_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","هاي هَدي المَرّة التالتة، راني مْعَوَّل نْجي لعَندكُم وما رانيش رايَح نْخَلّيكم تَصَّرفو علِيَّ، خاطَر ما رانيش نْحَوَّس على شِيّكُم، راني نْحَوَّس عليكُم. خاطَر ماشي الدْراري اللي لازَم يْتَوّلو للوالدين، الوالدين هومَ اللي يْتَوّلو للدْراري. ");
INSERT INTO arq_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","وأنا بالفَرح نَصرَف عليكُم، ونَصرَف روحي على جال نْفوسكُم. وَلاّ أنا نْحَبكُم بالزْيادة، نَنحَب قَل؟ ");
INSERT INTO arq_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","صَح، ما كُنتش في كَلافَتكُم، بَصَّح جَوّاح كيما أنايَ، جَبتكُم بالحيلة. ");
INSERT INTO arq_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","كايَن واحَد من اللي بْعَتهُمَّلكُم، خَلّيتكُم تَصَّرفو عليه؟ ");
INSERT INTO arq_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","وَكَّدت على تيطَس وبْعَتت معاه الأَخ اللي دْكَرتو، تيطَس خَلاّكُم تَصَّرفو عليه؟ ماشي بروح واحدة اللي مْشينا؟ ماشي في طْريق واحدة؟ ");
INSERT INTO arq_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","من مُدّة وأنتومَ تْخَمّمو باللي حْنا نْحاميو على روحنا قُدّامكُم. قُدّام الله فالمَسيح نَهَّدرو، هَدا كامَل لبَنيانكُم يا الحْباب. ");
INSERT INTO arq_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","نْخاف فالصَح نْعود كي نَوصَل ما نَلقاكُمش كيما نْحَب، وما تَلقاونيش كيما تْحَبّو. بَلاك يْكون بيناتكُم دْواس، غيرة، زْعاف، مْشاحنة، تَقطاع، نَميمة، تْعيدير، هَملة، ");
INSERT INTO arq_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","نْزيد تاني كي نَوصل يْدَلّني الله قُدّامكُم ونَحزَن على بَزّاف منكُم اللي خْطاو من قْبَل وما تابوش على اللي داروه من النْجاسة والزِنا والفَسق. ");
INSERT INTO arq_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","هَدي هِيَ المَرّة التالتة اللي رايَح نْجي لعَندكُم، كُل دَعوة تَفرا على حْساب كْلام زوج شْهود وَلاّ تْلاتة. ");
INSERT INTO arq_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","قُلت من قْبَل، ودُرك نَسبَق نْقول وأنا غايَب، كيما قُلت وأنا حاضَر عَندكُم فالمَرّة التانية، للّي غَلطو من قْبَل وللأخرين كامَل. لو كان نْزيد نْجي، ما نَشفَقش. ");
INSERT INTO arq_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","كي راكُم تْحَوّسو على التْبوت باللي المَسيح يَهدَر فِيَّ، وهُوَ ماشي ضْعيف عَندكُم، بالعَكس، يْبَيَّن قُدَّرتو في وَسطكُم، ");
INSERT INTO arq_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","والو نَصلَب على جال الضَعف، بَصَّح راهو حَي بقُوّة الله. وحْنا فالصَح ضْعاف فيه، بَصَّح رايحين نْعيشو معاه بقُدرة الله اللي ليكُم. ");
INSERT INTO arq_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","شوفو روحكُم أنتومَ بالدات، وَلاّ عَندكُم الإيمان، جَرّبو روحكُم. وَلاّ ما تَعَّرفوش أنتومَ بالدات باللي المَسيح فيكُم؟ غير وَلاّ كُنتو خْسَرتو. ");
INSERT INTO arq_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","نَتمَنّا تَستَعرفو باللي حْنا ما خْسَرناش. ");
INSERT INTO arq_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","نَترَجّاو من الله ما تْديرو حَتّى شَر، ماشي باش نْبانو حْنا رابحين، بَصَّح باش تْديرو الخير والو نْكونو حْنا خاسرين. ");
INSERT INTO arq_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","خاطَر ما عَندنا حَتّى قُدرة ضَد الحَق، عَندنا القُدرة غير للحَق. ");
INSERT INTO arq_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","نَفَّرحو كُل مَرّة نْكونو ضْعاف بَصَّح أنتومَ قْوايا، الشي اللي نَطَّلبوه هُوَ كْمالكُم، ");
INSERT INTO arq_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","على هَدا، نَكتَب هاد الحاجات وأنا غايَب، باش وأنا حاضَر، ما نَتعامَلش بالقْساوة على حْساب الحُكمة اللي عْطاهالي الله للبَنيان ماشي للهَدّان. ");
INSERT INTO arq_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","الحَصون، يا الخاوة، كونو فَرحانين، أَخَّدمو لكْمالكُم. أتسَجّعو، يْكون عَندكُم تَخمام واحَد، عيشو في هْنا، وإلَه المْحَبّة والهْنا يْكون معاكُم. ");
INSERT INTO arq_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","سَلّمو على بَعضكُم بَعض ببوسة مْقَدّسة، القَدّيسين كامَل يْسَلّمو عليكُم. ");
INSERT INTO arq_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","نَعمة الرَب يَسوع المَسيح، ومْحَبّة الله، وشَركة الروح القُدّوس معاكُم كامَل.");
INSERT INTO arq_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","بولَس، رَسول لا من عَند الناس، وَلا من عَند بْنادَم، بَصَّح من عَند يَسوع المَسيح والله الآب اللي حْياه من الموت، ");
INSERT INTO arq_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","وكامَل الخاوة اللي معايَ، لكْنايَس غَلاطية، ");
INSERT INTO arq_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","نَعمة ليكُم وسْلام من عَند الله بابانا والرَب يَسوع المَسيح، ");
INSERT INTO arq_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","اللي سَلَّم روحو على جال دْنوبنا باش يْسَلَّكنا من هاد الزْمان الدوني على حْساب مُراد الله بابانا، ");
INSERT INTO arq_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ليه المَجد للدْوام، آمين. ");
INSERT INTO arq_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","نَستَغرَب اللي هَكدا بالخَف بَعَّدتو على اللي دْعاكُم بنَعمة المَسيح ودَرتو إنجيل واحَدآخُر. ");
INSERT INTO arq_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","فالصح، ما كانش إنجيل واحَدآخُر، بَصَّح كايَن اللي راهُم يْهَوّلو فيكُم وحَبّو يْحَرّفو إنجيل المَسيح. ");
INSERT INTO arq_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","مَنعول اللي يْبَرَّحَّلكُم بإنجيل ماشي كيما الإنجيل اللي بَرَّحنالكُم بيه، يا لوكان نْكونو حْنا وَلاّ مْلاك من السْما، ");
INSERT INTO arq_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","كيما قُلنا من قْبَل، ودُرك تاني نْزيد نْقول: لو كان يْجي واحَد يْبَرَّحَّلكُم بإنجيل ماشي كيما اللي تْبَشَّرتو بيه، يْكون مَنعول. ");
INSERT INTO arq_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","دُرك هِمّالا، نْحَوَّس نْرَضّي الناس وَلاّ الله؟ وَلاّ نْحَوّس نَعجَب الناس؟ لوكان مازَلني نَعجَب الناس، لوكان ما رانيش خادَم المَسيح. ");
INSERT INTO arq_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","نْقولَلكُم يا الخاوة، الإنجيل اللي بَرَّحتَّلكُم أنا بيه ما راهوش من بْنادَم، ");
INSERT INTO arq_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","خاطَر ما أدّيتوش وما تْعَلَّمتوش من عَند بْنادَم، بَصَّح جاني بوَحي من يَسوع المَسيح. ");
INSERT INTO arq_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ياخي سْمَعتو كيفاش كانَت سيرتي في دين اليَهودِيّة، كيفاش كُنت شاحَن نَحڤَر في كَنيسة الله ونْخَرَّب فيها، ");
INSERT INTO arq_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","كُنت نَتقَدَّم في دين اليَهودِيّة كْتَر من بَزّاف اللي كانو نْتاجي ومن زَرّيعتي، وكُنت شاد بَزّاف في عْوايَد جْدودي. ");
INSERT INTO arq_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","بَصَّح، كي حَب اللي خَيَّرني من اللي كُنت في كَرش يَمّا، ودْعاني بنَعَّمتو، ");
INSERT INTO arq_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","يْضَهَّرلي بْنو، باش نْبَرَّح بيه عَند اللي ماشي يْهود، تَم تَم، ما شاوَرت لا الدات وَلا الدَم، ");
INSERT INTO arq_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","وما طْلَعتش لأورشَليم عَند اللي كانو رُسَل قْبَل منّي، بَصَّح رُحت لبْلاد العْرَب وعاوَدت وَلّيت لدِمَشق. ");
INSERT INTO arq_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","أومبَعد، بَعد تَلت سْنين، طْلَعت لأورشَليم، باش نَتعَرَّف ببُطرُس وقْعَدت عَندو خْمَسطاشَن يوم، ");
INSERT INTO arq_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","وما شفت حَتّى رَسول واحَدآخُر من غير يَعقوب، خو الرَب. ");
INSERT INTO arq_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ما رانيش نَكدَب فالشي اللي راني نَكتَبَّلكُم فيه، الله شاهَد. ");
INSERT INTO arq_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","أومبَعد، رُحت لَجْوايَه سورِيّة وكيليكِيّة، ");
INSERT INTO arq_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","بَصَّح وَجهي ما كانش مَعروف عَند كْنايَس اليَهودِيّة اللي فالمَسيح. ");
INSERT INTO arq_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","كانو بَرك يَسَّمعو يَتقال: اللي كان يَحڤَر فينا، دُرك راهو يْبَرَّح بالإيمان اللي كان من قْبَل يْحَوَس يْهَدّو، ");
INSERT INTO arq_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","وكانو يْسَبّحو الله على جالي. ");
INSERT INTO arq_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","أومبَعد، بَعد رْبَعطاشَن سْنة، طْلَعت من دارة وجْديد لأورشَليم مع بَرنابا وأدّيت مْعايَ تيطَس تاني. ");
INSERT INTO arq_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","طْلَعت لتَمّة بَعد ما جاني وَحي. وَرّيتَلهُم الإِنجيل اللي راني نْبَرَّح بيه عَند اللي ماشي يْهود، وَرّيتو بالخْصوص للي عَندهُم الشان فيهُم يْعود يْكون الجْري اللي راني نَجري فيه واللي جْريتو في باطَل. ");
INSERT INTO arq_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","وتيطَس اللي مْعايَ، اللي كان يوناني، ما تْسَيَّفش عليه باش يَتخَتَّن، ");
INSERT INTO arq_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","على جال اللي دَخلو بيناتنا من اللي دايرين روحهُم خاوة، واللي دَخّلو روحهُم بيناتنا باش يْعَسّو الحُرِيّة اللي عَندنا فالمَسيح يَسوع ويْشوفو كيفاش يْحَطّونا تَحت عُبوديّة الشَريعة، ");
INSERT INTO arq_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","واللي دْقيقة واحدة ما خَلّيناهُمش يَغَّلبونا باش يَتبَتَّلكُم الحَق مْتاع الإِنجيل. ");
INSERT INTO arq_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","اللي عَندهُم الشان -مَهما كانو زْمان، هاد الشي ما يْهَمّنيش، الله ما يْفَرَّقش بين الناس- اللي عَندهُم الشان ما فَرضو عليَّ والو، ");
INSERT INTO arq_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","بالعَكس، كي شافو باللي تْسَلّمَتلي البْشارة بالإِنجيل للي ماشي مْخَتّنين كيما تْسَلّمَت لبُطرُس للمْخَتّنين، ");
INSERT INTO arq_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","صَح، -اللي خْدَم في بُطرُس للرُسولِيّة عَند المْخَتّنين، خْدَم فِيَّ للي ماشي يْهود- ");
INSERT INTO arq_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ويَعقوب وبُطرُس ويوحَنّا اللي يَتحَسبو هومَ العْرَص، كي شافو النَعمة اللي نَعطاتلي، عْطاولنا أَنا وبَرنابا اليَد اليْمنى، مارة مْتاع الشَركة، باش نْروحو حْنا للي ماشي يْهود وهومَ للمْخَتّنين. ");
INSERT INTO arq_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","وَصّاونا بَرك باش نَتفَكّرو الڤْلالين، وهاد الشي كان على قَلبي باش نْديرو. ");
INSERT INTO arq_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","بَصَّح كي جا بُطرُس لأَنطاكيا، وْقَفتلو فالوَجه، خاطَر كان غالَط. ");
INSERT INTO arq_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","خاطَر قْبَل ما يْجيو ناس من عَند يَعقوب، كان ياكُل مع اللي ماشي يْهود، وكي وَصلو، تْهَرَّب وجْبَد روحو خاطَر خاف من المْخَتّنين. ");
INSERT INTO arq_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","اليْهود الأُخرين تاني دَخلو مْعاه في هاد اللَعب، حَتّى بَرنابا طاح فالتْنوفيق مْتاعهُم. ");
INSERT INTO arq_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","بَصَّح كي شَفتهُم ما راهُمش يَمشيو تابتين على حْساب حَق الإِنجيل، قُلت لبُطرُس قُدّامهُم كامَل، وَلاّ أنتَ اللي يْهودي راك تْعيش كي اللي ماشي يْهودي ماشي كي اليْهودي، كيفاش تْحَب اللي ماشي يْهود يَتهَوّدو؟ ");
INSERT INTO arq_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","حْنا اللي أَصَلنا يْهود، ماشي من الأمات الخاطيين، ");
INSERT INTO arq_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","نَعَّرفو تاني باللي بْنادَم ما يْنالش الصْلاح بفْعال الشَريعة، غير بالإيمان بيَسوع المَسيح اللي يْنال الصْلاح، وحْنا بالمَسيح يَسوع اللي آمَنّا باش نْنالو الصْلاح بالإيمان بالمَسيح، ماشي بفْعال الشَريعة، خاطَر حَتّى واحَد ما يْنال الصْلاح بفْعال الشَريعة. ");
INSERT INTO arq_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","بَصَّح، فالوَقت اللي رانا نْحَوّسو نْنالو الصْلاح فالمَسيح، وَلاّ كُنّا ما زَلنا خاطيين، مَعنَتها المَسيح خادَم الخْطِيّة؟ حاشا. ");
INSERT INTO arq_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","خاطَر وَلاّ عاوَدت بْنيت الشي اللي هَدّيتو، مَعنَتها راني دايَر روحي مْخالَف للشَريعة. ");
INSERT INTO arq_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","إيه، أنا بالشَريعة مَت للشَريعة، باش نْعيش لله. نَصلَبت مع المَسيح، ");
INSERT INTO arq_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","راني عايَش، بَصَّح ماشي أنا، المَسيح هُوَ اللي راهو عايَش فِيَّ، اللي راني عايشو فالدات دُرك، راني عايشو فالإيمان بابن الله اللي حَبّني وسَلَّم روحو على جالي. ");
INSERT INTO arq_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ما نَنكُرش نَعمة الله، خاطَر لو كان الصْلاح يْجي بالشَريعة، هِمّالا المَسيح مات على باطَل. ");
INSERT INTO arq_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","يا الغَلاطِيّين الجايحين، شْكون سْحَركُم بَعد ما نَرسَم قُدّامكُم يَسوع المَسيح مَصلوب؟ ");
INSERT INTO arq_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","راني حاب نَعرَف هاد الشي بَرك مَنكُم: نَلتو الروح بفْعال الشَريعة وَلاّ كي سْمعتو بإيمان؟ ");
INSERT INTO arq_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","جايحين أنتومَ؟ بَعد ما بْديتو بالروح، دُرك تْكَمّلو بالدات؟ ");
INSERT INTO arq_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","كامَل واش تْعَدَّبتو على باطَل؟ وَلاّ على باطَل، ");
INSERT INTO arq_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","اللي يَعطيلكُم الروح ويْدير المُعجِزات في وَسطكُم، يْدير هاد الشي خاطَر تْطَبّقو الشَريعة وَلاّ خاطَر تامنو بالبْشارة؟ ");
INSERT INTO arq_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","كيما إبراهيم آمَن بالله ونَحسَبلو هاد الشي صْلاح، ");
INSERT INTO arq_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","أعَّرفو باللي اللي عَندهُم الإيمان، هومَ وْلاد إبراهيم. ");
INSERT INTO arq_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","الكْتوب كي عَرفو من قْبَل باللي الله يْمَد الصْلاح للأُمّات بالإيمان، سَبقو خَبّرو إبراهيم بهاد البْشارة \"كامَل الأُمّات يَتباركو فيك\"، ");
INSERT INTO arq_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","مَحسوب، اللي يامنو يَتباركو مع إبراهيم المومَن. ");
INSERT INTO arq_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","خاطَر كامَل اللي يْشَدّو في فْعال الشَريعة راهُم تَحت النَعلة، خاطَر مَكتوب: \"مَنعول كُل واحَد ما يَتبَتش في كامَل واش مَكتوب في كْتاب الشَريعة باش يْطَبّقو\"، ");
INSERT INTO arq_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","بايَن باللي حَتّى واحَد ما يْنال الصْلاح قُدّام الله بالشَريعة خاطَر الصالَح يَحيا بالإيمان، ");
INSERT INTO arq_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","الشَريعة ماشي قايمة على الإيمان، بَصَّح \"اللي يْطَبَّقها يْعيش بيها\"، ");
INSERT INTO arq_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","المَسيح فْدانا من نَعلة الشَريعة، ووَلاّ نَعلة على جالنا، خاطَر مَكتوب: \"مَنعول كُل من يَتعَلَّق فالحْطَب\". ");
INSERT INTO arq_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","باش تَوصَل البَركَة مْتاع إبراهيم حَتَّى للأُمّات فالمَسيح يَسوع، باش نْنالو وَعد الروح بالإيمان. ");
INSERT INTO arq_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","يا الخاوة، نْقول بمَنطَق بْني آدَم، واحَد ما يْبَطَّل عْقَد مَمضي وَلاّ يْزيد فيه والو إنسان اللي دارو. ");
INSERT INTO arq_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","الوْعود تْقالو لإِبراهيم ولْدَرِّيّتو. ما تْقالش: \"لَلدَرِّيّات مْتاعو\"، كي شْغُل كايَن بَزّاف، واحدة بَرك \"لدَرِّيّتَك\" اللي هِيَ المَسيح. ");
INSERT INTO arq_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","حَبّيت نْقول: الشَريعة اللي جات رَبع مْية وتْلاتين سْنة بَعد عَهَد مْتَبَّت من عَند الله ما تَقدَرش تْبَطّلو وتَمحي الوَعد مْتاعو، ");
INSERT INTO arq_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","خاطَر وَلاّ الوَرت يْجي من الشَريعة، مَعنَتها ماشي من الوَعد، بَصَّح الله عْطا نَعمة لإبراهيم بالوَعد. ");
INSERT INTO arq_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","هِمّالا عْلاش كايَن الشَريعة؟ الشَريعة زادَت جات على جال المَعصِيات، مابيد تْجي الدَرِّيّة اللي نْدارَلها الوَعد. هاد الشريعة وَصّلوها المَلايكة على يَد وْسيط. ");
INSERT INTO arq_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","والوْسيط ماشي وْسيط لواحَد بَرك، بَصَّح الله واحَد. ");
INSERT INTO arq_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","هِمّالا الشَريعة راهي ضَد وْعود الله؟ حاشا، لو كان تْمَدَّت شَريعة تَقدَر تَحيي، لو كان الصْلاح كان صَح يْجي من الشَريعة، ");
INSERT INTO arq_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","بَصَّح الكْتوب حَبسو كُل شي تَحت سيطَرة الخْطِيّة، باش بالإيمان بيَسوع المَسيح، يَتمَد الوَعد للمومنين. ");
INSERT INTO arq_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","قْبَل ما يْجي الإيمان، كُنّا مَحبوسين تَحت العَسَّة مْتاع الشَريعة، حَتّى وين يَنكشَف الإيمان، ");
INSERT INTO arq_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","هَكدا، الشَريعة هِيَ اللي ڤَوّدَتنا للمَسيح، باش نْنالو الصْلاح بالإيمان، ");
INSERT INTO arq_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","وكي جا الإيمان، ما وَلّيناش مَلزومين بهاد الڤَوّاد. ");
INSERT INTO arq_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","كامَل أنتومَ وْلاد الله بالإيمان بالمَسيح يَسوع، ");
INSERT INTO arq_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","أنتومَ كامَل اللي تْعَمَّدتو فالمَسيح، لْبَستو المَسيح، ");
INSERT INTO arq_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ما كايَن لا يْهودي وَلا يوناني، لا عَبد وَلا حُر، لا دْكَر وَلا نْتى، خاطَر كامَل راكُم واحَد فالمَسيح يَسوع. ");
INSERT INTO arq_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","وَلاّ كُنتو من المَسيح، مَعنَتها راكُم دَرِّيّة إبراهيم، وعلى حْساب الوَعد تَوَّرتو. ");
INSERT INTO arq_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","هِمّالا نْقول: قَد ما يَبقا الوارَت صْغير، ما كانش فَرق بينو وبين العَبد، والو هُوَ مول الشي كامَل، ");
INSERT INTO arq_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","يَبقا مَنطاع لْواصيين ومْوَكّلين حَتّى للوَقت اللي يْكون باباه حَدّدو من قْبَل. ");
INSERT INTO arq_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","حْنا تاني، كي كُنّا صْغار، كُنّا مَنطاعين للحاجات مْتاع الدَنيا، ");
INSERT INTO arq_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","بَصَّح كي وْصَل الوَقت، بْعَت الله وْليدو، مَزيود من مْرا، مَزيود تَحت سيطَرة الشَريعة، ");
INSERT INTO arq_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","باش يَفدي اللي كانو تَحت سيطَرة الشَريعة، باش نْنالو التَبني. ");
INSERT INTO arq_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","وعلى حْساب اللي أنتومَ وْلاد الله، بْعَت الله روح وْليدو في قْلوبنا، يْعَيَّط: \"آبا الآب\". ");
INSERT INTO arq_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","هَكدا، ما راكش عَبد، أنتَ إبن، وَلاّ أنتَ إبن، مَعنَتها تَورَت بنَعمة الله. ");
INSERT INTO arq_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","بَصَّح، زْمان، قْبَل ما تَعَّرفو الله، كُنتو مَنطاعين لآلِهة ماشي مْتاع الصَح، ");
INSERT INTO arq_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","بَصَّح دُرك بَعد ما عَرفتو الله، بَعد ما عْرَفكُم الله، كيفاش تْعاودو تْوَلّيو للخُرَّيفات والحاجات اللي ما عَندهُم حَتّى فايدة واللي راكُم حابّين تْعاودو تْوَلّيو تَنطاعولهُم؟ ");
INSERT INTO arq_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","تْعَسّو اليامات، الشْهور، المْواسَم والعْوام. ");
INSERT INTO arq_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","نْخاف عْليكُم نْعود نْكون خْدَمت على جالكُم في باطَل. ");
INSERT INTO arq_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","يا الخاوة، نْحَلَّلكُم، كونو كيما أنا، خاطَر أنا تاني كيما أنتومَ. وأنتومَ ما ضَرّيتوني في حَتّى شي، ");
INSERT INTO arq_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","راكُم عارفين باللي على جال مَرض فالدات اللي بَشَّرتكُم بالإنجيل المَرّة الأولى، ");
INSERT INTO arq_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ووالو كان المَرض اللي في داتي تَجرِبة ليكُم، ما حْڤَرتوني ما عَفتوني. سْتَقبَلتوني كي مْلاك الله، كي المَسيح يَسوع، ");
INSERT INTO arq_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","وين راهي فَرحَتكُم بِيّ؟ نَشهَدَّلكُم باللي لو كان قْدَرتو كُنتو تْنَحّيو عينيكُم وتَعطيوهُملي، ");
INSERT INTO arq_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","وَلّيت عْدوكُم كي نْقولَلكُم الصَح؟ ");
INSERT INTO arq_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","عَندهُم الغيرة عليكُم، بَصَّح ماشي للخير، حابّين يَعَّزلوكُم باش تْغيرو عليهُم، ");
INSERT INTO arq_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","مْليح تْكون الغيرة للخير دايمًا وماشي غير كي نْكون أنا عَندكُم. ");
INSERT INTO arq_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","يا وْلادي، اللي راني نْعاوَد نَولَدهُم بالوْجاع حَتّى يَتشَكَّل فيكُم المَسيح، ");
INSERT INTO arq_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","مادابِيَّ نْكون حاضَر عَندكُم دُرك، ونْبَدَّل النَبرة مْتاعي، خاطَر راني مَستَغرَب فيكُم. ");
INSERT INTO arq_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","قولولي، أنتومَ اللي راكُم حابّين تَبقاو تَحت سيطَرة الشَريعة، ما تَفَّهموش الشَريعة؟ ");
INSERT INTO arq_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","مَكتوب باللي إبراهيم سْعا زوج وْلاد: واحَد مالعَبدة والآخُر مالمْرا الحُرّة. ");
INSERT INTO arq_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","وْليد العَبدة زاد على حْساب الدات، ووْليد المْرا الحُرّة جا بالوَعد. ");
INSERT INTO arq_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","هادو رُموز: إيه، هاد النْسا هومَ زوج عْهود: الأولى مْتاع جْبَل سينا، زَيّدَت لَلعُبودِيّة وهِيَ هاجَر، ");
INSERT INTO arq_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","إيه، هاجَر هَدي هيَ جْبَل سينا في بْلاد العْرَب، وتَرمَز لأُورشَليم مْتاع دُرك، صَح راهي مَستَعبدة مْع وْلادها. ");
INSERT INTO arq_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","أورشَليم الفوقانِيّة حُرّة، وهِيَ يَمّانا، ");
INSERT INTO arq_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","إيه، مَكتوب: \"أَفَّرحي يا العاڤرة، يا اللي ما وْلَدتيش، نَڤزي من الفَرحة وعَيّطي يا اللي ما عْرَفتيش الوْجاع، خاطَر وْلاد المَهجورة كْتَر من وْلاد اللي عَندها راجَل\". ");
INSERT INTO arq_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","أنتومَ يا الخاوة، وْلاد الوَعد كيما إسحاق، ");
INSERT INTO arq_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","بَصَّح كيما كان اللي نْزاد على حْساب الدات يَحڤَر اللي نْزاد على حْساب الروح، دُرك تاني كيف كيف. ");
INSERT INTO arq_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","بَصَّح واش يْقول الكْتاب: \"حاوَز العَبدة ووْليدها، خاطَر وْليد العَبدة ما يَورَتش مْع وْليد المْرا الحُرّة، ");
INSERT INTO arq_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","على هَدا يا الخاوة، حْنا ماشي وْلاد العَبدة، حْنا وْلاد المْرا الحُرّة. ");
INSERT INTO arq_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","المَسيح حَرَّرنا للحُرِّيّة، هِمّالا أَتَّتبتو مْليح وما تْعاودوش تَحَّبسو روحكُم تَحت السيطَرة مْتاع العُبودِيّة، ");
INSERT INTO arq_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","شوفو، أنا بولَس نْقولَلكُم باللي لو كان تَتخَتّنو، المَسيح ما يْفيدكُم في والو. ");
INSERT INTO arq_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","نْعاوَد نَشهَد تاني باللي كُل واحَد يَتخَتَّن، لازَم عليه يْطَبَّق كامَل الشَريعة. ");
INSERT INTO arq_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","نَفرَقتو على المَسيح، أنتومَ اللي راكُم تْحَوّسو تْنالو الصْلاح بَالشَريعة، خْسَرتو النَعمة. ");
INSERT INTO arq_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","إيه، حْنا بالإيمان اللي رانا نَستَناو بالروح الرْجا مْتاع الصْلاح، ");
INSERT INTO arq_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","إيه، فالمَسيح يَسوع، ماشي الخْتانة وَلاّ غير الخْتانة اللي عَندهُم قيمة، الإيمان اللي يْبان بالمْحَبّة هُوَ اللي عَندو القيمة. ");
INSERT INTO arq_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","كُنتو تَجريو مْليح، شْكون اللي مْنَعكُم باش تْطيعو الحَق؟ ");
INSERT INTO arq_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","هاد الدْبارة الدونِيّة ماشي من عَند اللي يَدعيكُم. ");
INSERT INTO arq_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","شْوِيّة خْميرة تْخَمَّر العْجين كامَل، ");
INSERT INTO arq_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","أنا عَندي التيقة فيكُم فالرَب باللي ما رايَحش يْكون عَندكُم راي آخُر، اللي راهو يْهوَّل فيكُم، يْكون واش يْكون، رَبّي يْعاقبو. ");
INSERT INTO arq_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","أنا يا الخاوة، وَلاّ ما زَلني نْبَرَّح بالخْتانة، عْلاش هِمّالا ما زَلني مَحڤور؟ هِمّالا، خْلاصَت العَترة اللي فالصْليب. ");
INSERT INTO arq_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","نْشا الله يْزيدو يَتقَطّعو هومَ تاني اللي راهُم يَهَوّلو فيكُم. ");
INSERT INTO arq_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","أنتومَ، دْعاكُم الله للحُرِيّة يا الخاوة، بَصَّح ما تْرَدّوش هاد الحُرِيّة سَبّة باش تْعيشو على حْساب الدات، بَصَّح أَخَّدمو بَعضكُم بَعض بالمْحَبّة. ");
INSERT INTO arq_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","كامَل الشَريعة تْكَمّلَت في كَلمة واحدة، في: \"تْحَب قْريبَك كي نَفسَك\"، ");
INSERT INTO arq_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","بَصَّح وَلاّ تْعَضّو وتاكلو بَعضكُم بَعض، رَدّو بالكُم تْعودو تَفنيو بَعضكُم بَعض. ");
INSERT INTO arq_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","نْقولَلكُم بالعَكس، سيرو على حْساب الروح، داك الوَقت ما تْزيدوش كامَل تْتَبّعو شَهوة الدات، ");
INSERT INTO arq_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","صَح، الدات تَتشَهّا عَكس الروح والروح عَكس الدات، هَدو مَتعاكسين بيناتهُم، باش ما تَحَّسبوش روحكُم تَقَّدرو تْديرو واش تْحَبّو. ");
INSERT INTO arq_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","وَلاّ راكم تْسيرو بالروح، ما راكُمش تَحت الشَريعة. ");
INSERT INTO arq_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","فْعال الدات باينين: زِنا، نْجاسة، فَسق، ");
INSERT INTO arq_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","شَرك، سْحَر، كُره، عْداوة، غيرة، دْواس، مْعاندة، فْراق، بَدعات، ");
INSERT INTO arq_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","حْسَد، سَكرة، مْفارصة فالماكلة وحاجات كيما هَدو. نْحَدَّركُم كيما حَدَّرتكُم من قْبَل: اللي يْديرو هاد الشي ما يَوَّرتوش مَلَكوت الله. ");
INSERT INTO arq_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","غَلّة الروح مْحَبّة، فَرحة، سَلام، صْبَر، مْلاحة، خير، إيمان، ");
INSERT INTO arq_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","حْنانة، والواحد يْكون يَتحَكَّم في نَفسو. الشَريعة ماشي ضَد هاد الشي. ");
INSERT INTO arq_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","مْتاع المَسيح صَلبو الدات بهْواها وشَهواتها. ");
INSERT INTO arq_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","وَلاّ نْعيشو بالروح، بالروح نْسيرو، ");
INSERT INTO arq_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","ما لازَمش نْكونو مَغرورين، نَتحَدّاو بَعضنا بَعض، نْغيرو من بَعضنا بَعض. ");
INSERT INTO arq_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","يا الخاوة، لو كان يَتَّحكَم واحَد وهُوَ يْدير في غَلطة، أنتومَ الروحِيّين رَدّوه للطْريق بالمْلاحة. رَد بالَك خاطَر أنتَ بالدات تَقدَر تَتَّغوا. ");
INSERT INTO arq_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","أَرَّفدو بَعضكُم بَعض وهَكدا تْكونو راكُم تْكَمّلو شَريعة المَسيح. ");
INSERT INTO arq_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","وَلاّ كايَن واحَد حاسَب روحو حاجة، وهُوَ والو، راهو يْغَر في نَفسو. ");
INSERT INTO arq_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","كُل واحَد يْمَيَّز فْعالو، هَكدا يَفخَر بروحو وماشي بواحَدآخُر، ");
INSERT INTO arq_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","خاطَر كُل واحَد رايَح يَرفَد حْمالتو هُوَ. ");
INSERT INTO arq_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","اللي يَتعَلَّم الكَلمة لازَم يَقسَم شَيّو كامَل مع اللي يْعَلّمو، ");
INSERT INTO arq_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ما تَخَّدعوش روحكُم، ما يَقدَر حَتّى واحَد يَتمَسخَر بالله. واش يَزرَع بْنادَم، هَداك اللي يَحَّصدو، ");
INSERT INTO arq_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","خاطَر ال