﻿USE sofia;
DROP TABLE IF EXISTS sofia.arp_vpl;
CREATE TABLE arp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arp_vpl WRITE;
INSERT INTO arp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Hanau waunauthathee hadnedanuu hejadenenau hadjenanuu hauthase vavesee hauthedau hena hayauhuhau nanāe hājavaānethauwuthajauthaunin, ");
INSERT INTO arp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hasevenānauau nanaa hehethee jasesee vasesā hāenuu nau nejaanuu hanadedaunau; ");
INSERT INTO arp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hasethajaunau hethadee heee nananenau jea, vavesethaugudenau vahee hayauhuhau hehetheejasesee hadnewauthaunauwunathane nedānee, javaānethadee Theauthenus, ");
INSERT INTO arp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hadeaenauwu hethauwuu hena hayauhuhau nesechauhauthehane. ");
INSERT INTO arp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hena hese Herod, naja Judea, jasaa vevethahehe Zacharias haseede, hadauchunanede Abia: nau henene hedaunāhene Aarauneau, nau heneseedaunin Elisabeth. ");
INSERT INTO arp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nau haenesauuthāhenauau hathaāhenith Hejavaneauthu, thaunaugudethee vahee nanavaavedaunau nau hauchuwudaunau Vahadāde dejauthauwuvade. ");
INSERT INTO arp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nau hehauwunesaunenauau, hanau henee hehauwunesaune Elisabeth; nau wauwu haenesauu vaehahenenauau. ");
INSERT INTO arp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nau hethauwuu, henee daunausuvadanedaude hathaāhenith Hejavaneauthu hāenauauchaude, ");
INSERT INTO arp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nesedaunethe vevethahehehau, nesedaude hadnejaāde yehauthe hevadannauauwunene Vahadāhenith. ");
INSERT INTO arp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nau haunauude henanedanede haevevethahedaune jathee nauauchuu jaa. ");
INSERT INTO arp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nau haenauhauva hautheaune Vahadāde haetheaugune hejavese jaanaa. ");
INSERT INTO arp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nau hāenauhauwaude Zacharias, haejanethajau, nau nāthajaude haeedasaa. ");
INSERT INTO arp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hau nuu hautheaune, jevanāthajau hathāhuk, Zacharias: havevethahede nanedauwuhuu; nau hadasea Elisabeth hadjanesewaude hāau, nau Jaun hadeseau. ");
INSERT INTO arp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nau nananin hadaunauwuthajau nau hadeneethajau; nau hadnewauthathee neethajauthee hāejanesee. ");
INSERT INTO arp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hanau haudvasāthaa hathaāhenith Vahadāhenith, nau haudnehauwuvane daudause dadajevenenaje, wauāthe neauthunaje; nau haudnechauchaunaudede Hevadanauwauthauwunene Hejavaneauthu, haa hehethee hāejanesee. ");
INSERT INTO arp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nau haudnewauthaa dāeyaunenede Israel hadjaechuwauyāaunaude hesee Vahadāhenith Henesaunaunenau. ");
INSERT INTO arp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nau haudnedauwaunaude nauguu Vadanauwauthauwu nau neesenaudāhenith Elias hadjaechuwauyāauau vadauhau henesaunaunenau hesee dāeyaunauauau nau nejenedauvathee gaugauuthajaudenau hadauethadee; hadnesaanudede henanedanede hesanaa hesee Vahadāhenith. ");
INSERT INTO arp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nau Zacharias naudedusaene nuu? wauwu vanaehahenenau nau nadasea wauwu vadavehahenede, hathauhuk hautheaune. ");
INSERT INTO arp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nau hautheaune hanaāauchuhananadethāde, Nananenau Gabriel henee theaugudaunauau hathaāhede Hejavaneauthau; nau janeautheavānau haudnāedauwunathana, nau hadnauhauthehathana nuu neethajaude waunauyauau. ");
INSERT INTO arp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nau, naune, nananin haudnejanadene nau haudnehauwuneanade, haunaude hese nuu hayauhuhau nauauchaugu hethauwuu, hanau nananin daujethauwaudauwu nadanadede, nuu hadnethauwunauauchuu nauauchaugaune. ");
INSERT INTO arp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nau henanedanede haedauyauhauvanauau Zacharias, nau haegaugauanadauwu henee dauguthetheaugude vadannauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nau hāejenauāhede, haejeneanadetha: nau haeaenauwu daunauhauthāde vadannauauwuu: haevathasauwuna nau haejanade. ");
INSERT INTO arp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nau hethauwuu, henee, chauchaunu hese hāesevadanedaude haeyehau hesee nehayau hedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nau heee hena hese henene Elisabeth hanaāenesaunenith, nau haegauduse nehayau hayauthaunenethe hesese heee, hanaāenehede, ");
INSERT INTO arp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Hesau Vahadāde naasehānau hesee hāedaugauhauvānau hadgudanauwunānau nāedayāhede henanedaa. ");
INSERT INTO arp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nau nanedaudauchuauwaude hesese hautheaun Gabriel haejeautheawau hehethee Hejavaneauthu hesee hedan Gananee haseenaugu Nazareth, ");
INSERT INTO arp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hesāhedāeyaun haeenenehauwaune henanin Joseph haenaneeseenith, hehethee hedauauwuu David; nau hesāhedāeyaun Mare haenaaseede. ");
INSERT INTO arp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nau hautheaun haeedasaa, nau hanaāenehethāde, Haunauwuthajau, nananin vechauthane, Vahadāde hanedaudaunāne: hauwunaunane hesānaa. ");
INSERT INTO arp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nau hāenauhauwaude, haejanethajaude hedanadedaunin, nau haegaugauanade daun hadnesenaunenechuhude nuu hadnesauau. ");
INSERT INTO arp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nau hautheaun, Jevanāthajau, hathāhuk, Mare: hanau nananin vechauthāne Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nau, naune, nananin hadnenesaunin, nau hadneahene, nau JESUS hadeseau. ");
INSERT INTO arp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hadvasāthaa, nau Vāā Hejavaa hadethauva: nau Vahadāde Hejavaneauthau hadvenaude naja theaugudau henesaunaune David: ");
INSERT INTO arp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nau hadnajawaudauau hededanin Jacob jethauujenee; nau henajanede hadnehauwuthauuvadauaune. ");
INSERT INTO arp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hanaāenehethaude Mare nuu hautheaune, Haddusenesau nuu hanau nāhauwāenaunau henane? ");
INSERT INTO arp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nau hautheaun hanaāauchuhananadethāde, Hejavaneauthau Hevadanauwauthauwu hadnedasāne: nau naunauthauau Hejavaa haddugauyāaunāne; henaheee jea henee Naunaudāde hadnenesaunewaude Heau Hejavaneauthau hadnethade. ");
INSERT INTO arp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nau, naune, have Elisabeth, jea wauwu henesaunede hadneahede wauwu dauvadavehahenede: nau nuu nanedaudauchunethe hesese wauwu hehauwunesaune neethade. ");
INSERT INTO arp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hanau Hejavaneauthau vahee neneedede hayauhuhau. ");
INSERT INTO arp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nau naune, Vahadāde daununānau hahagu Mare, hadnaasauau nuu hasenehene, nau hautheaun hanaāenauthāde. ");
INSERT INTO arp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nau Mare hanaāethauwauthede hena hese, nau hanaāehaude jauaudanenauauwuu nauhauhaunee hesee hedan Juda; ");
INSERT INTO arp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nau hanaejedāde hedauauwunene Zacharias, nau haenaunenechautha Elisabeth. ");
INSERT INTO arp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nau hethauwuu, henee, Elisabeth hāenedauwauthaude daunaunenechuhunith Mare, dāeyaunaa haenauauwuja hethauwaudauau; nau Elisabeth haeechauchaunaude Vadanauwauthauwu: ");
INSERT INTO arp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nau haevasanade, nau hanaāenehede, Hauwunaunane hesānaa, nau hauwunaunade dāeyaunaa hethauwaudauau. ");
INSERT INTO arp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nau naudauhuthedasaa nuu, henee henaune Navahadāhewaunāde hadnedasānau? ");
INSERT INTO arp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hanau, naune, chauchaunu hanadedaunau haunaunenechauhude hāenedauwaudauwau naunaudaunuu, dāeyaunaa naunauauwujahede naunaudauau heee haunauwuthajaude. ");
INSERT INTO arp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nau hauwunaunade hesā henee hethauwuthajaude: hanau hena hayauhuhau hadnethauwunaasauau neethāedauwunade hehethee Vahadāhenith. ");
INSERT INTO arp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nau Mare hanaāenehede, Navadathuwu hauwaunehāde Vahadāhenith, ");
INSERT INTO arp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nau navadathuwu neethajaudaunaude Hejavaneauthu Nānayauhāde. ");
INSERT INTO arp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hanau nedaugauhauwaude hadavenuhuhau hedaununaunau: hanau, naune, hewaunehaa heejasesee vahee henaededaunau hauwunaunade hadnethanau. ");
INSERT INTO arp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hanau hena Naunaudāde vanasaunee hayauhuhau hasehānau; nau vadanaunee heneseede. ");
INSERT INTO arp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nau nauwunaunaude henee headaunādaunau henajāthee henaedede nau nausunee henaedede. ");
INSERT INTO arp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nenauhauthethāde hedāahede hejadenaa; neneāsauaunaude hesāethajauhuhau hedāhene. ");
INSERT INTO arp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nejananaude naunaudāhenethe hehethee hetheaugudaunene, nau nejejenanaude hadavenuhuhau. ");
INSERT INTO arp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Negaudauhaude hasenahehau nauguu hethadenee; nau nethauyādahehehau negudanaude jessaa. ");
INSERT INTO arp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nenedahewaude heau Israel, nedauyewuwude hedauwuyau; ");
INSERT INTO arp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Neesenehethaude havasevāene, Abraham nau hedāeyaunewau jethauujenee. ");
INSERT INTO arp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nau Mare haenedauguva hanāenethe hesese heee, nau hanaāejaehaude nehayau hedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wauhā Elisabeth hanaāevadauaudaude hadneejanesāde; nau hanaāeahede. ");
INSERT INTO arp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nau henedaudevādaunau nau henethesaunau haenedauwauthaa hasauwunaunāde Vahadāhenith haenauhauthehaa vanasaunee hauwunaunadede, nau haenetheneethajauvaa. ");
INSERT INTO arp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nau hethauwuu, henee hāenasaudauchunesee haejenauusanauau hadgauguusenith dāeyaunauau; nau haeadethanauau Zacharias, thauguu heneseedaunin henesaunaune. ");
INSERT INTO arp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nau henaune hegau, hāheyaugaune, Jaun hadnethade, ");
INSERT INTO arp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nau hathauhaugaunee hehauwuseenauau hādauānauau nuu neseede, ");
INSERT INTO arp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nau haevathasauwunanauau henesaunaunin, haadeneseenethe. ");
INSERT INTO arp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nau haenaudede dasewauthaunauha, nau haewauthaunauhā, Jaun haseede, hahagu. Nau haunauude haegaugauuthajaudene, ");
INSERT INTO arp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nau haegaunadenanauau, nau henethaune haegauchauunauaune, nau hanaāanadede, nau haevaveenethedauna Hejavaneathu. ");
INSERT INTO arp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nau nāthajaude haeedasā haunauude henee hathāeauchaunauthee: nau vahee nuu nehedaunau haegaugauudedaune jedauwuu hathāauau jauaudanenauauwuu Judea. ");
INSERT INTO arp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nau yahee hathāenedauvade haejenanauwu hedahenauau, haudduthā naa dāeyaunaa, hahagaunee? Nau hejadenene Vahadānith haeanedaudaunaa. ");
INSERT INTO arp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nau henesaunaune Zacharias haeechauchaunaudene Vadanauwauthauwu, nau haeaeyānautheda, ");
INSERT INTO arp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Vaveenethedaunaa Vahadāde Hejavaneauthau Israel; hanau haenauujāda nau daujauaudaunaudauau hedenanedanede, ");
INSERT INTO arp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nau thauwaudanaude henenese hadnenayauhānauau jedauwuu hedauauwunene hedaununaune David; ");
INSERT INTO arp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dau nausunanadede hedenaa Hevadanaeyāhewau neenaedenethe hāejeenaedenauau: ");
INSERT INTO arp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Henee hadnenanedanenauau hehethe haujauthavene, nau hehethee hejadenaa vahee hāthāasānavādaunene; ");
INSERT INTO arp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hethauwuu hauwunaunadede nesayānāedauwunaude havasevāene, nau hadnedauyewuwude Hevadanenesedauwau; ");
INSERT INTO arp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Deneauwauhude yesee havasevāene Abraham, ");
INSERT INTO arp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Henee hadvenānauau, jenāthajaude hehethee hejadenene haujauthavene hadnenayauhānauau hadnevevethedaunaunauau. ");
INSERT INTO arp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nauguu vadanaunee nau chuwuu hathaāhede, vahee hesee hadenaededaunene. ");
INSERT INTO arp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nau nananin, dāeyaunaa, haeyāhe Hejavaa haudnethane: hanau nananin hadnedauwaudauwu Vahadāde hadnesaanudene hevaunaa; ");
INSERT INTO arp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hadvāde haeyaude hadnenanedanedaunee hededane hadjaegudanauwunaude hewauchudaudenenenau, ");
INSERT INTO arp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hehethee havathee hauwunaunadede Hāsaunaunene; nanaa Naugusaje hehethee hejavaa hadnenauujādaunānauau, ");
INSERT INTO arp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hadvenaude hesee hathāetheaugunethe hadauveeyaunee nau hadaudugauyāsaa gaujauaudahede, hadnedauwaudauau hauauthene hesee hadaudādauyaunee. ");
INSERT INTO arp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nau dāeyaunaa haeeseau, nau hevadathuwu haedāeaune, nau haenaadaude hadaunechaudanee haunaude hesee hadneenauhauthethāde Israel. ");
INSERT INTO arp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nau hethauwuu hena hese hauchuwude haeneāsanau hehethee Caesar Augustus henee vahee henanedanede hadnayāadee. ");
INSERT INTO arp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Nau nuu nayāadede haenedauwunesede deauchuwunanenede Cyrenius Syria.) ");
INSERT INTO arp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nau vahee haeauāchaudene hadnayāadee haunauude hanesāde hesee nehayau hededan. ");
INSERT INTO arp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nau Joseph jea haeyehau hehethee Gananee, hehethee hedan Nazareth, jedauwuu Judea, jedauwuu hededan David Bethlehem neseee, (hanau naadahagu hedauauwunene nau nedānee David,) ");
INSERT INTO arp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hadnethenayāade naguu Mareheau heauthehewauthādaune hadnewaune wauwu haeehāthane heee henesaune. ");
INSERT INTO arp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nau hethauwuu, henee hajesenausunanedauthee, hese haevadauaunau hadneejanesāde. ");
INSERT INTO arp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nau hanaāejanesāde henedauwusaune heau, nau haeajetha, nau haeesevana hewauchuhauchave nedau vethehenethe; hanau haeneau vethehedaunauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nau hena vavade vedauauwuu haudānajauāhehauau haeaudenauau, haeaunaunehanauau haeaunauyauhauvanauau hedajauanenau vegau. ");
INSERT INTO arp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nau, wauhā, Vahadāde hedautheaune haeedasā, nau havathee haeseenauasāaunauau Vahadānith; nau haevasenāthajaunauau. ");
INSERT INTO arp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nau hautheaun jevanāthajauau hathāhaugaunee: hanau, naune, nauuchaudaunathana hethadee waunauyauau havathee neethajaude, nanaa heee vahee henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Heee nananena janesee nuu desenee hededan David Henayauthāhe, nananede Chris Vahadāde. ");
INSERT INTO arp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nau nuu hadneaenauwuna; Nananena hadveehauna dāeyaunaa hanajehede, saesee hewauchuhauchave nedauvethehethee. ");
INSERT INTO arp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nau nauhauhaunee hena haewauthanauau hejavaa hautheaunauau nauguu naa hautheau haevaveenethedaunanauau Hejavaneauthu, nau hasenehehaugaunee, ");
INSERT INTO arp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Havathee hauwaunede hesee Hejavaneauthau hejavaa, nau dasee vedauauwuu nanethauaunee, hethadee hathanavana henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nau hethauwuu, hautheaunauau haejaenauthā hesee hejavaa, Wauhā hadeehaunau Bethlehem, hanathadagaunee nuu haudānajauāhehauau, nau nauhaudauwuu nuu hayewhu javeauau, nanaa Vahadāde hāāedauwunādaunene. ");
INSERT INTO arp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nau haenauchuhanauusanauau, nau haeveehanauau Mare nau Joseph, nau dāeyaunauau haesaeseene hewauchuhauchauwauauwuu henee nedauvethehenethe hewauchuhauchāve. ");
INSERT INTO arp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nau hāenauhauwauthee, haeneānauthedanauau nuu hathauthedaunāhethee heee dāeyaunauau. ");
INSERT INTO arp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nau vahee hathāenedauvade haegaugauanadauwu henee hayauhuhau nuu hathauthedaunāthee haudānajauāhehau. ");
INSERT INTO arp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nau Mare haeaunaunede vahee nuu hayauhuhau, nau haegaugauanade hedahaa. ");
INSERT INTO arp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nau haudānajauāhehauau haejaesanauau, haevaveenethedaunanauau nau haevaveenethedaunanauau Hejavaneauthu heee vahee hanathadauvathee nau hathauhauthāthee, neethāedauwunāhethee. ");
INSERT INTO arp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nau hāenasaudauchunesee hadneegauguusede dāeyaunaa heneseede Jesus, haseadagu nuu haseede haenaneeseāde hautheaunau haunauau deejethāsee. ");
INSERT INTO arp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nau hesee hāewaudeauchaude hasaunee hedauchuwude Moses hāevadauaunee, haeyehauthanauau hesee Dadaunedan hadjenanauwunauthee Vahadāhenith; ");
INSERT INTO arp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Hathauthaunauhunee hauchuwudaunaa Vahadāde, Dajee haunauahee henee nedauwusau vadade hadnethade hesee Vahadāhenith:) ");
INSERT INTO arp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nau hadnausāyaudenee neesenehedaunee hauchuwudaunaa Vahadāde, Hanesethee vedāenauau, wauāthe hanesethee neauthuvedāesaunauau. ");
INSERT INTO arp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nau, naune, hena henane haeanedau Dādaunedan, Simeon haenaneeseede; nau naa henane haechuvā nau haeethauwuthajau, haeejauwuwude hadneneethajauthee Israel: nau Vadanauwauthauwu haethāsade. ");
INSERT INTO arp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nau haeeauthedaunaa Vadanauwauthauwu, henee hadjenauhaudauau gaujauaudahede, haunaude hadnauhauwaude Vahadāhenith Chris. ");
INSERT INTO arp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nau haejeheenauusa Vadanauwauthauwu jedauwuu Vadannauauwuu: nau hāene henehā Hejavaeneauthusau jedanāde hadnesehāde thauguu hasauau hauchuwude, ");
INSERT INTO arp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hanaāejavethenauanaude hejadenaa, nau haevaveenethedauna Hejavaneauthu nau hanaāenehede, ");
INSERT INTO arp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Vahadāhene, hewaunehaa nanehāejenanaude hauwauwaunave hadnaudauau nanethauaunee, hasauau hadanadede: ");
INSERT INTO arp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Heee nasesā naunauhauwauau havāde Henayauthāhe, ");
INSERT INTO arp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Naa nananin hadnesaanudene hathaāhedaunee vahee henanedanede; ");
INSERT INTO arp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hesee hadneesenee Hathāauau henanedanede, nau havathee hadnanedanede Israel. ");
INSERT INTO arp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nau Joseph nau henaune haegaugauanadauwu hena hayauhuhau hanasenehethavathe. ");
INSERT INTO arp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nau Simeon haevevethasa, nau haeāedauwuna Mareheau henaune, Naune, Naa dāeyaunaa haneejenanade hadneaunenauaudenenee nau hadneejaegauhadenenee hauwauhuu Israel; nau hanau nauhauthethau hadnevathevade; ");
INSERT INTO arp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(Haa, gaugauchu hadneegauchuguhune nehayau havadathuvaa jea;) henee gaugauuthajaudenau hauwauhuu vadauhau hadneauthasuu. ");
INSERT INTO arp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nau hena haenesā Anna, haeyāhe, hedaunau Phanuel, hanaadāde Aser: haewauthanenau hejajenewau, nau haenethenaedeva hechu nesaudauchu jajene hehethee neeesede; ");
INSERT INTO arp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nau haeenevesāne heee nasaudausauau yānenee jajene, nananede haeejethauunaude vadannauauwuu, hau haenesedauna Hejavaeneauthu nauguu naugauyaude nau vevethahede dajāee nau hesee. ");
INSERT INTO arp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nau haejejedā heee haevaveene jea Vahadāhenith, nau haeheauthedauna vahee nethāejauwuwudethee jauaudaunauthadede jedauwuu Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nau hāesedauthee vahee hayauhuhau hasauau hauchuwude Vahadāde, haejaesanauau hesee Gananee, hadahethee hedan Nazareth. ");
INSERT INTO arp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nau dāeyaunaa haeeseau, nau haedāeaune hevadathuwu, haeechauchaunaude haeyaude: nau Hejavaneauthu vadaude haethāsade. ");
INSERT INTO arp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nau wauhā henehā haeehaunenau hesee Dādaunedan hadauchuvejanenee vasevadanesee Hadavechauthadede. ");
INSERT INTO arp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nau denesenenee hejajenewau, haeehaunauau hesee Dādaunedan hanau nesedaudenee vasevadanesee. ");
INSERT INTO arp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nau hese hāevadauaunee, hāejāesathee, dāeyaunaa Hejavaneauthusau haenasedauusa Dādaunedan; nau Joseph nau henaune haejaenauwu. ");
INSERT INTO arp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hau henanedaa haenehauvā hathanauwauhaugaunee, nau haejanaugudaunee; hanaāenaudehauthee henedauānene nau henedaehāhene. ");
INSERT INTO arp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nau hāejeveehauthee, haejaesanauau hesee Dādaunedan, daunaudehauthee. ");
INSERT INTO arp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nau hethauwuu hāenasese hanaāeveehauthee jedauwuu vadannauauwuu, haetheaugune nahethāe hauthedahehau, haejaatheha, nau haenaunaudedauna. ");
INSERT INTO arp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nau vahee hathāenedauwauthāthee haegaugauanadauwu hedaeyaunene nau hedauchuhanehedaunene. ");
INSERT INTO arp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nau hāenauhauwauthee, haegaugauanavanauau: nau henaune, Nā, naudu hanesehāane? hathāhuk, naune hāsaunau nau nananenau nenaudehane nejeneethajaunee. ");
INSERT INTO arp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nau hathauhuk, naudu haenaudehena? gauhajaene nauchāe wauwu hanedaudauwau Nāsaunau henesethaude? ");
INSERT INTO arp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nau haejaenauwu hasenehethāthee. ");
INSERT INTO arp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nau hanaāenethaunaude, nau haenauusanauau Nazareth, nau haeethauwaudaunā: hau henaune haeaunaunedene vahee nuu nehedaunau hedahaa. ");
INSERT INTO arp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nau Hejavaneathusau haeneenaneaune hedaeyau nau hajedāde nau vechauthaude Hejavaneauthu nau henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wauhā yauthaunenee jajene wauwu neeenajanede Tiberius Caesar, Pontius Pinade nausunajawaudauau Judea, nau Herod nanajawaudauau Gananee, nau henauhauwauau Theneb nanajawaudauau Iturea nau vedauauwuu Trachonitis, nau Lysanias naja Abilene, ");
INSERT INTO arp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas nau Caiaphas vevethahenajanauau, Hejavaneauthu nanadede haeedasaa Jaun heau Zacharias nauaunee. ");
INSERT INTO arp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nau haeedade vahee vedauauwuu hanathaudanee Jordan, haeauthedaude dusaahede haudneaugauthuu gaugauuthajaudenau hadneegudanee wauchudaudenau; ");
INSERT INTO arp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Naathauthaunauhuu wauthaunauhanaa hedanadede Esaias haeyāhe, Jasaye haevasenehe nauaunee, Hesaanuu hathaāhede Vahadāhede, nesedee hevau chwuwuu. ");
INSERT INTO arp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hadauchugauaudayauau hadnechauchaunaa, nau hadauchāe hauane nau jauaudane hadjananee, nau jajāvāe hadchuvanee, nau hadauhauauyauau bau hadneyauthauau; ");
INSERT INTO arp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nau vahee henanedanede hadnauhaudauau Hejavaneathu hedenayauthaunene. ");
INSERT INTO arp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Haenaāenehethaude waunauthanee henanedanede henee hedasādaunau haddusaanaude, Hau hedenaededaunenau seseyānauau, hanaa hāedauwunādaunenau haddaugauhudauwuna nauthee hasenaunaude hadnauusanauau? ");
INSERT INTO arp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hethadee nesedee hadeheaenaunee hadnaugauthuu haugaugauuthajaudenenau jevaauthenehee hadahenauau, hāsaunaunene Abraham: hanau nāedauwunathana, Hejavaneauthau neene nesehaude nuu hauunaugānau Abraham hedāeyaunewau. ");
INSERT INTO arp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nau wauhā jea hauunauchu janenanee hethājee hauhaudee: vahee hauhaudee jeneeaudehuk vevenaudenau haddauwauhude, nau hadneewaudedaunaunee. ");
INSERT INTO arp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nau henanedanau haenaudedaunaa, hauddusedaune? hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hanaāāedauwunaude, Daun nanesevechudaunade, jevena daun janevechudaunenith; nau daun hevethenede jenaasedaude, hahagu. ");
INSERT INTO arp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wauhā haenaāenuusathee hauāyāhehauau haddusaahethee, Hechauhauthethāhe hauddusedaune, hathāhuk, ");
INSERT INTO arp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nau hathāhaugaunee, javaauthaunaudaunāthe henee nethautheavane. ");
INSERT INTO arp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nau vanenanenau hanaasedaunethe, hanaasenehethāde, Nau haddusedaune, hathāhuk? Nau javaauthasenehaa henaneda, hathāhaugaunee, javaauthenanedaunevaa henaneda, nau hadnanethauaunahedava haunaudaunadenenau. ");
INSERT INTO arp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nau henanedanau hathanavāhuk, nau vahee henanedanede haegaugauanavaa hedāhenenau Jaun wauau Chris haenane, nau wauāthe hajee; ");
INSERT INTO arp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jaun hanaāauchuhanehethaude, hathauhuk vahee, Hadneedusaanathana heee naje; hau hanesāde javaānaudāde javaāhenau jaunaude hewauhugu hewauaunaa nāhauwuneaugunavane, hadneedusaanāna heee Hejavaneauthu Vadanauwauthauwu heee heseda. ");
INSERT INTO arp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Henaunasāhau nanewauunauau, nau hadgaunauhauau heyauthee nedauthauayāde, nau hadnauānauau wauchuunethauauhanau nedauthānauau jenayaunau; hau jenethauayaunau hadvadauchauauau hesedaa nedaujesaudaunahee. ");
INSERT INTO arp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nau waunauthanee hanasejāesaunee hayauhuhau hanathauthedaunaude henanedanau. ");
INSERT INTO arp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hau Herod naja haeaunaunewau heee Herodias henauhauwauau Thenebeau henenene, nau vahee hathāewausaunee hanasedaude Herod, ");
INSERT INTO arp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Haewauhaunene nuu vahee henee dauaugauhude Jauneau duguhunauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wauhā hāevahesedusaahedaunee henanedanede, hethauwuu henee Hejavaneauthusau haenethedusaā, nau haeevevetha, hejavaa hanaāegaunanenee, ");
INSERT INTO arp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nau Hejavaneauthuvadanauwauthauwu haejejanauhusane hedanayaunaa hedanayau haenaasaunee waude vedāene nau hanadede haejenauusa hehethee hejavaa, hasenehehuk, Nananene vechauthauau Nāa, nananene vaveenethedaunathane. ");
INSERT INTO arp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nau Hejavaneauthusau nehayau wauwu wauau hanasauau jajeneva, hanane (hathanavade) heau Joseph, nananenith heau Heli, ");
INSERT INTO arp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nananenith heau Matthat, nananenith heau Levi, nananenith heau Melchi, nananenith heau Janna, nananenith heau Joseph, ");
INSERT INTO arp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Nananenith heau Mattathias, nananenith heau Amos, nananenith heau Naum, nananenith heau Esli, nananenith heau Nagge, ");
INSERT INTO arp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nananenith heau Maath, nananenith heau Mattathias, nananenith heau Semei, nananenith heau Joseph, nananenith heau Juda, ");
INSERT INTO arp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nananenith heau Jonanna, nananenith heau Rhesa, nananenith heau Zorobabel, nananenith heau Salathiel, nananenith heau Neri, ");
INSERT INTO arp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nananenith heau Melchi, nananenith heau Addi, nananenith heau Cosam, nananenith heau Elmodam, nananenith heau Er, ");
INSERT INTO arp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nananenith heau Jose, nananenith heau Eliezer, nananenith heau Jorim, nananenith heau Matthat, nananenith heau Levi, ");
INSERT INTO arp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nananenith heau Simeon, nananenith heau Juda, nananenith heau Joseph, nananenith heau Jonan, nananenith heau Eliakim, ");
INSERT INTO arp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nananenith heau Melea, nananenith heau Menan, nananenith heau Matthatha, nananenith heau Nathan, nananenith heau David, ");
INSERT INTO arp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nananenith heau Jesse, nananenith heau Obed, nananenith heau Booz, nananenith heau Salmon, nananenith heau Naason, ");
INSERT INTO arp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nananenith heau Aminadab, nananenith heau Aram, nananenith heau Esrom, nananenith heau Phares, nananenith heau Juda, ");
INSERT INTO arp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nananenith heau Jacob, nananenith heau Isaac, nananenith heau Abraham, nananenith heau Thara, nananenith heau Nachor, ");
INSERT INTO arp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nananenith heau Saruch, nananenith heau Ragau, nananenith heau Phalec, nananenith heau Heber, nananenith heau Sala, ");
INSERT INTO arp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nananenith heau Cainan, nananenith heau Arphaxad, nananenith heau Sem, nananenith heau Noe, nananenith heau Lamech, ");
INSERT INTO arp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nananenith heau Mathusala, nananenith heau Enoch, nananenith heau Jared, nananenith heau Maleleel, nananenith heau Cainan, ");
INSERT INTO arp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nananenith heau Enos, nananenith heau Seth, nananenith heau Adam, nananenith heau Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nau Hejavaneauthusau wauwu haeechauchaunaude Vadanauwauthauwu haejeehedesa hehethee Jordan, nau haeyehauthaa Vadanauwauthauwu nauaunee, ");
INSERT INTO arp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yāyauau hese hananeedauchunesee haenayāthehaa Haujaune, nau hena hesee haeheejevethe: nau hāevathenesee, haenaāasenade waunee. ");
INSERT INTO arp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nau Haujaune hathāhuk, hith nananene Haāthauwuāvaa Hejavaneauthau hāedauwunene naa hauunauga hadejauaujaunenede. ");
INSERT INTO arp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nau Hejavaneauthusau haeauchuhanehe hathauhuk, Wauthaunauhuu henane hehauwuunaede jauaujaunau jasaa, hau heee haunauude hedanadedaunene Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nau Haujaune haenauauhuchauhaa hauanee hadaujauudanenee, nau haenauhauthehaa vahee najanede hathāauauvaa henanedanede chauchaunu. ");
INSERT INTO arp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nau vahee nuu najawaude hadvenathane, nau hauwaunede, hathāhuk Haujaun: hanau henee nananenau devenanau; nau daun navadauvenau hadevenauau. ");
INSERT INTO arp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hith nananene henaheee hevevethedaunenagu, vahee hadnehanāhene. ");
INSERT INTO arp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nau Hejavaneauthusaun hanaāauchuhananadethāde nau hathāhuk, Hedehau naugauvaa, Haujau haugau hathauthaunauhuu, Nananene hadevevethedaunaude Vahadāde Hāsaunau, nau hanesāde haudnevevethedaunaude. ");
INSERT INTO arp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nau hanaāehauthāde Dādaunedan, nau haejenanaa naunauchuu vadannauauwuu, nau hith Haāthauwuāvaa Hejavaneauthau hauwujanauau hede hehethee, hathāhuk: ");
INSERT INTO arp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Haugau hathauthaunauhuu, Hadāedauwunaude hedautheaunau haddunānaune: ");
INSERT INTO arp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nau hejadenenau hadeejedunānaune, havaaugugauusene heaudaa dasee hauunaugāe. ");
INSERT INTO arp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nau Hejavaneauthusaun hanaāauchuhananadethāde nau hathāhuk, Hasenehee, Nananene jevanayāthehene Vahadāde Hāsaunau. ");
INSERT INTO arp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nau hāevathenayāthedaude vahee, hanaāejathāaude haujau najee, ");
INSERT INTO arp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nau Hejavaneauthusau hanaāejaenaudāhede Vadanauwauthauwu haduu Gananee: nau hanaāauthedaunenede hanaāeneāsanaunee vahee hathāauau Gananee nauanee. ");
INSERT INTO arp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nau haeechauhautheha vevethahenauauwuu, nau vahee haevaveeneha. ");
INSERT INTO arp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nau haenauusa Nazareth, needaunauuchauhade: nau dajauaunee nesedaude haeyehau vevethahenauauwuu vadanesee, nau haetheaugu dasauhaudauau wauthaunauha. ");
INSERT INTO arp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nau haevenau hewauthaunauhanene haeyāhew Esaias. Nau hāegaunanauau wauthaunauha, haeveede hadauwauthaunauhunee, ");
INSERT INTO arp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Vahadāde Hedauwauthauwu nanadeaunānau, hanau dehedusaanānau javeda hadnauthedaunu hethadenee waunauyaunee hadavenuhunethee: hanejevāde haudnenayauhu naudauwuthajauthee, hadnauthedanau haudjaejenanathee wauwaunauau, nau hadnejanauhauthāthee nanenauguthee, haud-jaejenanathee hasenethaunauau, ");
INSERT INTO arp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Haudnauthedaudauwau hethadee jaunaunauau jaje Vahadāde. ");
INSERT INTO arp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nau haeauauvane wauthaunauha nau haejaevena vevethahehew, nau hanaāejanaugude. Nau vasesā vahee hathāanedauthee vevethahenauauwuu haenāauhauvanauau. ");
INSERT INTO arp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nau hanaāejasesenehethaude, nuu desenee nuu hathauthaunauhuu hethauvaa haunaudaununenau. ");
INSERT INTO arp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nau vahee haesegaugauudedaunene, nau haegaugauanadauwu hethadenee hedanadedaunene hethāenehethaunene. Nau gaunuu jee heau Joseph? hahagaunee, ");
INSERT INTO arp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nau hanaāenehethaude, Nananena hadethauwunehesena nuu heeejegausudede, Naudaunehāhe, nehanenayauhade: henee nanāthadauwaunee nanāsedaunee Capernaum nanehasedaunee nechau hede nehayau havedauauwuvaa. ");
INSERT INTO arp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nau hathauhuk hethauwuu nehethathana, Hegau haeyāhe hehauwuvechauthau nehayau hevedauauwuvaa. ");
INSERT INTO arp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hau hadauthedaunathava hethauwuu, waunauthathee henevesānauau neanedauthee Israel, hesee deanedaude Elias, hejavaa denausunaugauhuu nasau jajene nau nedaudauchu hesese, devasauau hasenaude denanadesanauau vedauauwuu; ");
INSERT INTO arp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hau hehauwunesāhene hejevādaunene Elias, vavade Sarepta, hedan Sidon, hesā nananede henevesā. ");
INSERT INTO arp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nau newauthathee naugaugauwuhuhauau neanedauthee Israel deanedaude Eliseus haeyāhe; nau hehauwunesā henayauhade vavade Naaman Syrian. ");
INSERT INTO arp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nau vahee hathāetheauguthee vevethahenauauwuu, hāenedauwauduu nuu hayauhuhau, haeechauchaunaudenenau hasenaunaude, ");
INSERT INTO arp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nau haegauhānauau, nau haenunanatheguthanauau hedan, nau haeehauthanauau hauchauguu jauaudanee haduunee hededanenau needaunesehenee neaudnedauauwuguthauthee hauthedaunaānee. ");
INSERT INTO arp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hau haejavechautha hehethee nahethāe, haejathāau, ");
INSERT INTO arp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nau haenauusa Capernaum, hedan Gananee, nau haeauthedauna vadanesenenee, ");
INSERT INTO arp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nau haegaugauanadauwunenau hasechauhauthehaude hedanadedaunau, hanau hedanadedaunau haenauthaunenau. ");
INSERT INTO arp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nau vevethahenauauwuu henane haeanedau hevadathuwu haewauchāhene haujaun, nau haevasanade, ");
INSERT INTO arp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Jenehāaa; hathāhuk, haudduseha nananene Jesus Nazareth? gauhāejau haudnauauhāane? Haenaunathane hadāhene; Vadanauau Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nau Hejavaneauthusau haeneuva, dādaunauguu, hathauhuk, nau jenauchune. Nau haujau hāegauusewaude nahethāe hanaāejenauthaude nau haejaseneha. ");
INSERT INTO arp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nau vahee haegaugauanavaa, nau haeanadethadenenau jaee, nuu hayew hanadede; hathāhuk, hethauwuu nauguu haenauthenehetha haenesedauwauna wauchāhenethe haujaunau, nau hanaāejenauāhethee. ");
INSERT INTO arp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hanaāauthedaunenede nanadee jasesee gauānee vedauauwuu, ");
INSERT INTO arp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nau haegauhā haenauā vevethahenauauwuu, nau haejedā Simon hedauauwuu. Nau Simon henene henaunene haenaudauwauvāhene; nau haeautheawaunauthasanauau. ");
INSERT INTO arp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nau haetheaugudauna, nau haeneude hasauwauvahede; nau haenauthaa: nau nauhauhaunee haegauhā nau haedauyauhauvanauau. ");
INSERT INTO arp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wauhā hesese hāenaesade vahee hathāenethenauthee hasauwauvahehehau hanasejaechauwauvāhenethe haenauuchaudaunau; nau haedajevasana nau haeenayauha. ");
INSERT INTO arp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nau haujaunauau nauguu haevanauusanauau haewauthanauau, haeneānadenauau, nau haenehenauau, Nananene Chris Heau Hejavaneauthau. Nau haeneneuva haejechuwauanadeha: dauhaenauwunethe dau Chris denede. ");
INSERT INTO arp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nau hāesenenee, hanaāejathāaude hesee hadaunechaudanee, nau henanedanau haenaudehaa, nau haeedasaa, nau haedauduvaa, haudjenauthaude. ");
INSERT INTO arp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nau hanaāāedauwunaude, haudnauthedaudauwau najanede Hejavaneauthau gauchuhunee hedanau nauguu: haugaunaasejejenananau. ");
INSERT INTO arp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nau haeautheda vevethahenauauwuu Gananee. ");
INSERT INTO arp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nau hethauwuu, henanedanede haeneenavadaunedauwaudauwu hedanadedaunene Hejavaneauthu, haetheaugu sasethauwu neajee Gennesaret, ");
INSERT INTO arp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nau haenauhaude hanesanenee thewaunau haetheaugunenau sasethauwu neajee: hau naunauyāhehauau haeeyauhaudesanauau, nau haeanahesadenauau henauyaudenenau. ");
INSERT INTO arp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nau haejedā jasaa hethewaunene, Simon, nau haenehetha hadwauauwuhudede vanehaa hehethee vachuwauauwuu vedauauwuu. Nau haejanaugu, nau haeechauhautheha henanedanau hehethee thewaunaa. ");
INSERT INTO arp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wauhā hāevadauthedade, hanaāenehethaude Simon, wauauwuhude hadaudavee, nau henauwunau haunauyaude hadjathāne. ");
INSERT INTO arp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nau Simon hanaāauchuhananadethaude, Hechauhauthethāhe, naunaugaunenesethānauau, nau nāhauwuthauujathāva: hau hegaugaunauau hadnaaenauwuaudenau nauyaude haugau hasenehene. ");
INSERT INTO arp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nau hāesedauthee nuu haewauthanenau hejathaunenau, nau haethauwunauaune henauyaudenenau. ");
INSERT INTO arp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nau haeadethanauau henedaehahenau danachaugunethe jasaa thewaunaa, haudjaunethe, nau haudnedāhevāthee. Nau haenauusanenau, nau haeechauchaunaudenauau hanesanenee thewaunau hanaāenauwuuu. ");
INSERT INTO arp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hāenauhaudauau Simon Peda, haechauāgujanaugu hejaedayānene Hejavaneauthusaun, nauchu, hathāhuk; haugauhauhauganenau, Hau Vahadāhene. ");
INSERT INTO arp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Haejenaunethajau, nau vahee hethāenethaunādaunau daunauanauthee nauwu hejathaunenau. ");
INSERT INTO arp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nau nauguu James, nau Jaun, heauhau Zebedee, henedaehauhau Simon. Nau Hejavaneauthusau hanaāāedauwunaude Simon, Jevanāthajau, hewaunehaa heee nananene haudnesedanaude henanenauau. ");
INSERT INTO arp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nau hāenauuchaudethee hethewaunenau vedauauwuu, hanaāenauduu vahee, nau hanaāenethauguhauthee. ");
INSERT INTO arp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nau hethauwuu, hāanedaude jasaa hedan, naune henane haeechauchaunaude naunaujaunee haugauwude; hāenauhauwaude Hejavaneauthusaun haeuāneseve, nau haeautheava, Vahadāhene, vathehānenagu hadeneeyaudanene hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nau haeyethauha, nau haevasana, vanathehānau: heyaudāhe, hathaukuk. Nau nauhauhaunee naunaujaunee haugauwude haenauthaa. ");
INSERT INTO arp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nau haenesedauwaunā haudjāedauwunaunith henanedane: hau najesa hadnauhauthehau hadanayau vevethahevāhe, nau hadvā dauhenayauhane, Mosase neesedauvade, haudneāenuu. ");
INSERT INTO arp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hau haeneenanauthedaunene neānee: nau havathee haewautha henanedanede haeauānauuchaudene daujewaunejaathededaunee, nau haudnenayauhāthee hedasauwauvahedaunenau. ");
INSERT INTO arp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nau haejathāau hesee nauaunee, nau haevevetha. ");
INSERT INTO arp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nau hethauwuu jasaa hesee, hajesechauhauthethāde, Nesethajauhuhauau nau hechauhaudauwauhuhauau nanavaavede haetheaugunauau hejava, haejeehedesanauau hadauchāe hauwauhauauwudan Gananee, nau Judea, nau Dādaunedan: nau naunaudāde Vahadāde haetheaugu hadnenayauhaude. ");
INSERT INTO arp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nau, naune, henanenauau haenauuchauhanauau henanene heee hedauwune haeesevāhene nau haenayāthejedananauau, nau hadjenanauwunauthee hathaājenith, ");
INSERT INTO arp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nau hāejeveedethee haudnethejedanauthee hanau dauwauthaa henanedanede, hanaāenauauhusathee dasee hauauwuu, nau haejanauhaujānanauau, hehethee dasee hejavaa hauauwuu nauguu hedauwune nahethāe hathaājenith Hejavaneauthusaun. ");
INSERT INTO arp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nau hāenauhaudauwunith hedethauwuthajaudenenau, hanaāāedauwunaude, Henane, hauwauchudaude gaunudanauwunane. ");
INSERT INTO arp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nau wauthaunauhāhehauau Nau Nesethajauhuhauau hanaāejasesegaugauuthajauthee, Hanaa naa hananadede nehedaduhude Hejavaneauthu? hathāhuk. Hanaa haudgudanauau wauchudaude, vavade Hejavaneauthau, naanesāde? ");
INSERT INTO arp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hau hāaenauwunith Hejavaneauthusaun hegaugauuthajaudenenau, Haudusethajauva hadahenauau? hathāhaugaunee, ");
INSERT INTO arp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hayew gauchauaa, nehehāgu, Hauwauchudaude gaunudanauwunana; nau wauāthe gauhā nau javesa heheagu? ");
INSERT INTO arp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hau hadaenauwu henee Heau henane naunaudāde dasee hathāauauvadee negudanauau wauchudaude, (naasenehethauhaugu neasauwauvahedauwunith hesevahede) Hāedauwunathane, Gauhā, nau hedanau hauddau nau najesa nananene haudauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nau nauhauhaunee haethauwauthe hathaājenethe nau haeedane heaugusenadenau nau hanaāejathāaude hedauauwuu haevaveenethedauna Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nau vahee haegaugauuthajaudene nau haevaveenethedaunanauau Hejavaneauthu, nau haeechauchaunaudenauau nāthajaude, Naunaudauhauthānauau nuu desene, hāheagu. ");
INSERT INTO arp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nau hāevathedaude haejathāau nau haenauhauva hauāyāhe Levi hanaaseenith, haetheaugune nedauudanauau hauāyaunau, nau jethauguhu hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nau haevanauthā, haegauhā, nau haethauguha. ");
INSERT INTO arp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nau Levi haevasevetheheha nehayau hedauauwuu, nau haewauthanauau hauāyāhehauau nau hauthauau haenedauguvā. ");
INSERT INTO arp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hau wauthaunauhāhehau nau Nesethajauhuhauau haeaunevā hethauguhādaunau, naudu haenethevethehewauna nau haenedaveyāwauna hauāyāhehauau nau wauchudauhuhauau, hathāhaugaunee? ");
INSERT INTO arp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nau Hejavaneauthusaun hanaāauchuhananadethāthee, hathāedāenaedethee hehauwuvathehā naudaunehāhew; hau hathāasauwauvahethee. ");
INSERT INTO arp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nāhauwujenauusa haudnadethu hethahethee hau wauchudauhuhauau hadnaugaudanenee hegaugauuthajaudenenau. ");
INSERT INTO arp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nau hathāhuk naudu hethauguhādaunau Jaun denauaunenaugauyānethe, nau devevethahethee, nau naasedauthee hethauguhādaunenau Nesethajauhuhauau; hau hanethenaunauau havethehethee nau havaveyāthee? ");
INSERT INTO arp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nau hathāhaugaunee, Gauhājeneenesehauva dāeyaunauauau nedauenenedaunee hauauwuu naugauyaude hajesanedaudaunāthee waunenenehew? ");
INSERT INTO arp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hau hese haudnauauchuu, haudneedanauwunana waunenenehe, nau heee hadnaāenaugauyāthee hena hese. ");
INSERT INTO arp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nau hanaāanadethaude jea jegausauhānee; Henane hehauwu jenane waunauyaunee neauthayew hadaugauthāyaunee, hith hesedauhuk, nau hadauwauyaunee needaudenauuu, nau jasaa needanee hadau wauyaunee hehauwuneauchauna gauthāyaunee. ");
INSERT INTO arp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nau hegau henane hehauwujenane waunauyaunee vasevenenaje gauthānenevajaunaa; nau wauāthe wauyaugu vasevenenaje haddaudeauau nevajaunau, nau hadgusenauauau, nau nevajaunau haddenanaunauuu. ");
INSERT INTO arp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hau waunauyauau vasevenenaje hadedaunee hadauwauyauau nevajau, nau nanesauuthadee. ");
INSERT INTO arp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nau hegau henane hesevanaagu gauthānevasevenenaje nauhauhaunee haevathehaa waunauyaunee; hanau gauthāyauau hethadee, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nau hethauwuu naneseauwauau vadanesee, haeehedesa jenayaunaa; nau hethauguhādaunau haegaugauunauwu wauchuunethauauhanau, nau haevethenauau, haegauneegudenauau hejadenenau. ");
INSERT INTO arp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nau hauthauauau Nesethajauhuhau, Naudu hanesedauna waujaa nanavanau nesedaude vadanesee hathauhaugaunee? ");
INSERT INTO arp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nau Hejavaneauthusau hanaāauchuhananadethaude, Gauhājethaunauhaude nuu hasauau David neesedaude, nehayau deasenade, nau neethāenethaunāde. ");
INSERT INTO arp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Neesejedāde Hejavaneauthu hedauauwunene, nau needanauau nau nevethee nauhauthethājauaujau, nau haevena heethāenethaunaunau; waujaa nanavanau veyāgu hau jasaa vevethahevahehauau? ");
INSERT INTO arp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nau hanaāāedauwunāthee, Heau henane nanethadāde vadanesee. ");
INSERT INTO arp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nau hethauwuu jea jasaa vadanesee haejedā vevethahenauauwuu nau haeautheda: nau henane haeanedau hejavese hejadenaa haeesevane, ");
INSERT INTO arp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nau wauthaunauhāhehau nau Nesethajauhuhau haeaunauyauhauvaa, wauau haadenenayauthā vadanesee; hadnejauaudaunauthee dauhanājauwauaunauthee. ");
INSERT INTO arp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hau haeaenauwu hegaugauuthajaudenenau nau hanaāanadethaude henanene hesevenasanith, Gauhā nau yethaagu nahethāe. Nau haegauhā nau haeyethaagu. ");
INSERT INTO arp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hejavaneauthusau hanaāāedauwunaude, haudnaudedaunathana nananena hanesadee; Gaujenanavanau vadanesee hethadāgu hasedaunee, nau wauāthe wauchudauneagu? henayauhāgu henaedede, nau wauāthe nanaunehāgu? ");
INSERT INTO arp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nau hanaāenaunauānede vahee, hanaāāedauwunaude henanene, Segauha hajade. Nau hanaasedaude: nau hejade haeenayauhune jasaa hasaunee. ");
INSERT INTO arp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nau haeechauchaunaudenauau hasenaunaude: nau hanaāaunauchuwuhadethee daun haudnesehauthee Hejavaneauthusaun. ");
INSERT INTO arp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hethauwuu hena hese, haeehau hauanee haudnevevethahede, nau haunaude naugaunee haevevethedauna Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nau hāesenee, hanaāadethaude hethauguhādaunau; nau haeedana vadadauchunesenee, hanaāeneseaude vadauhanauau. ");
INSERT INTO arp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoneau (jea haeaugauthea Peda haseauhuk), nau Andwheau henauhauwauau, James nau Jaun, Thenib, nau Bathaunaumew, ");
INSERT INTO arp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, nau Taumis, James heau Atheas, nau Simon Zenautes haseadagu, ");
INSERT INTO arp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nau Judas James henauhauwauau, nau Judas Iskariot, hanane jea neheaudaunade Hejavaneauthusaun. ");
INSERT INTO arp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nau haejenauunethauna nau haetheaugunauau hethauauwuu, nau hadauchunanenethe hethauguhādaunau, nau haevasenauthenanedau henanedanede hehethee vahee Judea nau Dādaunedan, nau hehethee sasethauwu hadajee Tyre nau Sidon hethāejenauujaathehādaunau, nau haudnenayauhāthee hedasauwauvahedaunenau; ");
INSERT INTO arp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nau hathāenaunauthauwauvahethee wauchāhenethe haujaunau: nau haeenayauhaunauau, ");
INSERT INTO arp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nau haunauude hadauchaa haevadauvasanau hanau daunudesanaunee hevadaude nau haevahenayauha. ");
INSERT INTO arp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nau hanaāenāauhauwaude hethauguhādaunau, Hauwunaunana nananena hadavenuhunena; hanau nananena najanede Hejavaneauthau, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hauwunaunana nananena hathāasenana hewaunehaa: hanau nananena hadnegaudana. Hauwunaunana nananena hathāevewauhuna hewaunehaa, hanau nananena hadnauchaunena. ");
INSERT INTO arp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hauwunaunana nananena, henaneda hasānavānā, nau jaasauaunānā, nau naunaunauthevānā, nau hausāgudenauthe haneseedaunenau hadauwausaunee, haugau Henane Heāhene heee. ");
INSERT INTO arp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Haunauwuthajauau henee hesee heee, nau jajanauauau heee haunauwuthajaude: hanau, naune, hanavanasauau hadaugautheavadenenau hejavaa: hanau naneesedauyaugaune henesaunaunenau naneesehauhaugaunee haeyāhehau. ");
INSERT INTO arp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Hau naunauthauau hadnauauchaudaune hathāeveaunauaune; haugau hanesedanauwuna hauwauthenaedede. ");
INSERT INTO arp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Naunauthauau hadnauauchaudauna hathāegaudana; haudnasenana. Naunauthauau hadnauauchaudauna hathāauchaunena hewaunehaa, hadnaudauwuthajauna nau hadvewauhuna. ");
INSERT INTO arp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Naunauthauau hadnauauchaudauna, daunhāene vahee henaneda hāethadenee hasenehethānā, hanau henesaunaunenau naneesehauyaugaune jayaudauwaeyāhehau. ");
INSERT INTO arp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hau hadāedauwunathava nananena hathāenedauvana, Vechauthaa nananena haujauthavenau, heneehaa hasānavādaunenau, ");
INSERT INTO arp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hauwunaunaa hāwauwauchuvādaunenau, nau hevevethasaa hāwauwauchuhādaunenau nananena. ");
INSERT INTO arp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nau henee haudauauvāde hajāeaunaa nau naugautha venene; nau hedanauaugu nananene hauddu jevaedanau jea naudauguvechude jevaethaa. ");
INSERT INTO arp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hevenaa daun henaneda hānedauwunādaunenau nananene; nau jeva jaenedauwunaa hedanauwunānagu daun hanetheyaunenau. ");
INSERT INTO arp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Daun hasevathehānaune henaneda hesehānenagu, nechau jenaasehaude. ");
INSERT INTO arp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Hith nananena vechauthaunagu daun havechauthādaunenau nananena, haddusevaveeneva nananena? haugau wauwauchudauhuhauau nechau nevechauthauthee hethāevechauthādaunenau. ");
INSERT INTO arp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nau hith nananena hethadāgu hasehaunā daun hāneneehādaunenau, haddusevaveeneva nananena? hanau naneesedauhaugaunee wauwauchudauhuhauau. ");
INSERT INTO arp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nau hith nananena hehaunagu daun hāneejauaunaudaunādaunenau, haddusevaveeneva? hanau wauwauchudauhuhauau nechau neehauhaugaunee wauwauchudauhuhau, hadnejanaasesedanuu. ");
INSERT INTO arp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hau vechauthaa nananena haujauthavenau, nau hethadeha hasedauna, nau hehānagu, jevajavathehāe; nau nananena haudaugautheavadenenau hadvasauau, nau nananena hadnaāedāeyaunenena Javaājauuthee: nau neneneehaude nethāejevaveenenethe nau hauhauganau. ");
INSERT INTO arp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hedauwuyaunee nananena, nananena Hāsaunaunenau jea hasedauwuyaunede. ");
INSERT INTO arp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jevaauchuwuu, nau nananene hadnaajauchuwuhane: nau jevaduguthāe nau nananena hadnehauwuduguhuva: hejaegudanauwuyāe nau hadnejaegudanauwunane nananene: ");
INSERT INTO arp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vāe, nau hadnevenana nananene, vavesethajauauthāe, dāayāe, nau dāesathāe, nau haunauwauauthāe, hauchauva, henane hadvenāna. Nechau hadnaasethajauaudaunāna hasethajauauthānā hadnanesethajauaudaunana. ");
INSERT INTO arp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nau hanaāanadethaude haejejegausuhu, Gaunanenauguhu jenenauājetha nanenauguhu? Gauhaudjenesauujanesenauau gauuhanaa? ");
INSERT INTO arp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Thauguthāhe hehauwujavaāhe hechauhauthehādaune: hau haunauude hanesāde daun haunauudaunāde hathāhenith hechauhauthehādaune. ");
INSERT INTO arp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nau naudu hanauhaudauwu nananene hahavaa hejaheede hesesāe, hau haājevesehau havadauhaude hathāsewau hasesāe? ");
INSERT INTO arp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wauāthe hauddusenehethau nananene hahavaa, Jāedaā, hadaugauhauwunathe hajaheede hasesāe, hau daujenauhauwaude havadauhaude hathāsewau nehayau hasesāe? Nananene jayaudauwunaedehe, nedauau haugauhune havadauhaude hathāsewau nehayau hasesāe, nau hadenaāeneauvane hadenaāeneaugauhauwu jaheede hethāsathau hahavaa hesesāe. ");
INSERT INTO arp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hanau hauhaude hethahagu hehauwuseaude wausaunee vevenaudenau; nau wauāthe wauchahagu hauhaude hehauwuseaude hethadenee vevenaudenau. ");
INSERT INTO arp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hanau hadauchude hauhaude neaenaunede hanasaunee hevevenaudenau. Hanau hauchahevesee henanenauau hehauwunaadauhauānuu hauuyauchuwunau nau dauchuuwusee hehauwunaadauguunee dadajevenau. ");
INSERT INTO arp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Henane hethāde hehethee hethadenee heda nenauuchaudede hethadenee; hau wauchāhede henane wausaunee heda nenauuchaudede wausaunee: hanau waunauthaa hehethee hedahaa hede nanadenaunee. ");
INSERT INTO arp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nau naudu, Vahadāhene, Vahadāhene, haesena, hau nejesedauna hayauhuhau hasenehethathana? ");
INSERT INTO arp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Daun nādasāde nau nedaunānaugu hasenehenaunauau, nau hesedauhuk, haudnauhauthehathana haudnethāde: ");
INSERT INTO arp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Henanene henee nenesedenethe hauauwu naathāde, nau henee nejayauchauhuu, nau naneejenanauau hauauwuu dasee hauunaugāe: nau nauunauuu naje neje naunauthuu jaathāsāe henee hauauwuu, nau hehauwunauauvathāau: hanau daunāaudaa hauunaugāe. ");
INSERT INTO arp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hau jaathedehe, nau janenaasedauthe, naathāde henanenau henee nedasauauvānethe vedauauwuu; nau neje jaathāsāe naunauthuu, nau nauhauhaunee naunenauauau; nau thauwusāe henee hauauwuu nevasauau. ");
INSERT INTO arp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wauhā hāevathanadede vahee hanasenehede daujajaathehade henanedanede, haejedā Capernaum. ");
INSERT INTO arp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nau jasaa vanenenaja hewauwaune haevechautha haeaugauwune, nau haeyānajane. ");
INSERT INTO arp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nau hāenedauwauthaude Hejavaneauthusaun, haeautheava vachaugananenau Jews, haeadetha hadjaunith nau hadnenayauhaunith hewauwaune. ");
INSERT INTO arp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nau hāedauchauthee Hejavaneauthusaun, haeautheauwaunauthasanauau haugaunaunee, hanau hethāde naa henane naa haudneenesedaude, hathauhaugaunee: ");
INSERT INTO arp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hanau vechaudauau nadedanenau, nau nenesedaunānauau vevethahenauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Heee Hejavaneauthusau hanaāejasesenethaunāde. Nau hāeauchauau hauauwu, vanenenaja haejajedauaunanenau henedaehauhau, Vahadāhene, jevawauchuthajau Nananene: haugau wauchāhenau hadjedāne naudauauwuu, hathauhuk: ");
INSERT INTO arp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nanaa nāejewauchanavadede dauudasathane: hau vavade nehedau hanadede, nau naudautheau hadeenanedanede. ");
INSERT INTO arp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hanau nananenau nanethenanenenau naunaudāhenau, nanethenu vanenanenauau, nau naāāedauwunauau hanesāde yehau nau naāejathāaude; nau jasaa, Nahāje, hathauau nau jaunaude; nau naudautheau, Nesede, hathauau, nau nanesedaude. ");
INSERT INTO arp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hejavaneauthusau hāenedauwaudauau nuu hayauhuhau, haegaugauanava, nau haenauthegauthaagu, nau hanaāāedauwunaude henanedanau hethāethauguhādaunau, Hadāedauwunathava, Haunauau nāhauwuveehau vasee hethauwuthajuhu (naa hathāde henane), hegau, hehauwuu haduu Israel. ");
INSERT INTO arp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nau henee hathāautheavathee, hāejaenuusathee hauauwuu, haeveehanauau wauwaune haeenanedanene henee neasauwauvāhenith. ");
INSERT INTO arp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nau hethauwuu jasaa hesee, hanaāehaude hedan Nain haseenauyāgu; nau haewauthanenau hethauguhādaunau henethaunādaunau, nau hauwauhuu henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wauhā hāayānauusade hejavaaa dajanaunaa hedan, naune, naa najaa henane naunudanade, jasāsau henaune, nau haeenevesānene: nau haewauthane henanedanede hehethee hedan haenethaunaa. ");
INSERT INTO arp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nau hāenauhauwaude Vahadāde haeauwunauna, Najenaudāve, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nau haeedasa nau haevasane nauaunechauthau: nau hethāenauaunechauhādaunau haedādauyaugunenau. Haunaua, hāedauwunathane, Thauwauthe, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nau henee nenajaa haethauwaudaugu, nau haenaāejasesanadede, nau hanaāevenaude henaunene. ");
INSERT INTO arp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nau nāthajaude haeedasā vahee: nau haevaveenethedaunanauau Hejavaneauthu, Havathee haeyāhe hanejauaude hadedanene; nau, Hejavaneauthau haenauujādauna henesaunau, hahagaunee. ");
INSERT INTO arp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nau nuu dauauthedaunenede haenanadesanaune vahee Judea, nau nanadee gauānee vedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nau hethauguhādaunau Jaun haeauthedaunaa vahee nuu hayauhuhau. ");
INSERT INTO arp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nau Jaun haeadetha hanesenethe hethauguhādaunau haeyethautheava Hejavaneauthusaun, Gauhanane henee waudaudjaude? nau wauāthe gauhadnaudenauhauwau jasaa? ");
INSERT INTO arp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hāedauchauthee henanenauau, Jaun Dusaayāhe janādautheavānauau Nananene, hathauhaugaunee, hanaāenaudedaunauthee, Gauhanane henee waudaudjaude? nau wauāthe gauhadnaudenauhauwau jasaa. ");
INSERT INTO arp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nau vavade hāauchauau haeenayauha haewauthanenau vavavāauhuhau nau havathee haugauwude, nau wauchāhenith haujaun; nau haewauthanenau nanenauguhuhau haevena nauhauthau. ");
INSERT INTO arp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hejavaneathusaun hanaāāedauwunāthee, Najajathāauau, nau hadāedauwunauva Jaun hathāhaugaunee, hayewhu hanathauhauthāna nau hathadauvana; hasejaenauhauthāde nanenauguhu, jeneejavesāhe daujavesade, naunaujaunee hedaugauwudaunenau dauuyaudahethee, hayājadāhe daunedauvade, gaujauaudahehe daujaethauwauthede, hadavenuhu hethadenee waunauyaunee dauauthedaunade. ");
INSERT INTO arp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nau hauwunaunade daun najewauchuthajaudaunāde. ");
INSERT INTO arp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nau hāejathāaunethe Jaun hedautheaunau, hanaāejasesanadedauau henanedanede hasenaedenethe Jauneau, Hayew nananena haewaunenauhauthaunenau nauaunee? gaugauguyāse daunauauvasee? ");
INSERT INTO arp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hau hayew nananena hāewaunenauhauthaunenau? Gauhenane hedāchaunau hejajehaunenau hedāchaunau? Naune, nethāeneenuhuthee, nau neneenaedethee thanāsee nenauchuwunethe hedauauwunenenau. ");
INSERT INTO arp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hau hayew hāewaunenauhauthaunenau? Gauhaeyāhe? Haa, hadāedauwunathava nananena, nau javaāsee haeyāhehau. ");
INSERT INTO arp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Naa nananene, wauthaunesee, Naune, hadjejenanauau Naudautheau hathaaguna, hadnesedaunāna hauvaunenau sayānee Nananena. ");
INSERT INTO arp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Hanau nāedauwunathana, hadedanenau nethāenesaunevāna hesānauau hehauwujavaāse haeyāhe hathāde Jaun Dusaayāhe: hau hena haugajehede hanedauhuk henajanedaunene Hejavaneauthu javaāhehuk. ");
INSERT INTO arp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nau vahee henanedanede hathāenedaunāde, nau hauāyāhehauau, hanaāechuwauthethajaudaunauthee Hejavaneauthu, haenethedusaanā dusaayāhew Jauneau. ");
INSERT INTO arp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hau Nesethajauhuhauau nau nanavaavehehau yesee nehayau haeausagudenauau hevathehādaunene Hejavaneauthu, haejenethedusaanā (Jauneau). ");
INSERT INTO arp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nau Vahadāde hahagu, Hayew naudneedajenehethau henanedanede nuu henaedede? nau haethahenauthe? ");
INSERT INTO arp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Waude dāeyaunauauau hathahethee theaugunauthe haudaunanauauwuu, nau danadethadethee, nau nanāhethee, Nevadauhana, hau nananena nejevadana; naudauwuthajaudauwunana nananena, hau nejevewauhuna. ");
INSERT INTO arp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hanau denauusade Jaun Dusaayāhe dejevethee jauaujaunau nau deejevanaa vasevenenaje; nau nananena nanethenaude haujaun, nethauna. ");
INSERT INTO arp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Heau henane daunauusade dauvethede nau dauvanaa; Nauhauvaa naa henane naudaudāhe, nau vasevenenajevanehe, henedaehauhau hauāyāhehau nau wauwauchudauhuhau, nethauna. ");
INSERT INTO arp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hau haeyaude chaunuwuthajaudaunaude vahee hedāeyaunewau. ");
INSERT INTO arp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nau hanesāde Nesethajuhu haeadetha haudjewaunenethevethehevāde, nau haeyehau haejedā Nesethajauhu hedauauwunene, nau haejanaugu hadvethede. ");
INSERT INTO arp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nau, naune, hesā hedan, haeauhaugane, hāaenaunaude Hejavaneauthusaun daujanaugunith hadvethehenith Nesethajauhu hedauauwunene, haejāchaude jaāvasaa chauayau, ");
INSERT INTO arp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nau haetheaugu hegauwune heauthene haevewau, nau hanaāejasesahesadede heauthene heee hedejee nau haeheahenauwu heee henethaanene, nau haenedane heauthene, nau haechauane heee chauayau. ");
INSERT INTO arp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wauhā Nesethajuhu hāadethaude hāenauhauwaude, haejaevenanadethade, Naa Henane, haeyāheyaugu, hanaenaunaude daunhadāhenith nau daunhathāhenith nuu hesāne hevasanādaune: hanau wauwauchuduhu, hahagu. ");
INSERT INTO arp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nau Hejavaneauthusau hanaāāedauwunaude, Simon, haudnāedauwunathane nananene. Nau hanaāenehethaude, Hechauhauthethāhe, nanehe. ");
INSERT INTO arp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hena jasaa sayānedanauwuyau haenesenenau hesayānedanauwunādaunau: hanesāhenith yauthaunevadadausauau vāejethā, nau jasaa yauthauyauau. ");
INSERT INTO arp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nau hāeyauhuunee haunaudauhudaunene, haenanethauaunegudanauwuna nesauuu Jeāedauwune, hanaane hevechauthādaune javaānee? ");
INSERT INTO arp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon hanaāejaāedauwunaude, Nauchāe nananenith heneehejavaāgudanauwunaune. Nau hanaāāedauwunaude, Nananene neaenauwu. ");
INSERT INTO arp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nau hanaāeyethaagude hesāne, nau hanaāāedauwunaude Simoneau, Gauhaunauhauwau nananene naa hesā? Nananenau nejedānau haudauauwuu, nananene hāehauwuvene naje heee nauaudau: hau neheahesadede nauaudau heee hedejee, nau neheahenauau henethaa. ");
INSERT INTO arp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nananene hāehauwunedane hau naa hesā hāenauusanaunauau hehauwuthauujenenedane nauaudau. ");
INSERT INTO arp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Naudauguhua nauguu javeda nananene hajechauusānene hau naa hesā nechauanauau nauaudau heee chauayau. ");
INSERT INTO arp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Naa hāedauwunathane nananene hewauchudaudenau waunauthanee gaunudanauwunade; hanau dauvechauthāde javaānee hau daun vanehaa gaunudanauwunade vavade hasevechauthāde vanehaa. ");
INSERT INTO arp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nau hanaāāedauwunaude hesāne, nananene hauwauchudaudenau jaegudanauwunane. ");
INSERT INTO arp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nau hethāenedauguvādaunau dauvethehethee hanaāejasesanadethee hegaugauuthajaudenenauau hanaa naa negudanauau wauchudaudenau jea? ");
INSERT INTO arp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nau hanaāāedauwunaude hesāne, Nananene hadethauwaudaude henayauhāne nananene; najesa hadnauwauthenesane. ");
INSERT INTO arp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nau hethauwuu waunee haejathāau nanadee hadauchanenee hedan nau hajaseehedan, dauaunauthedade nau daunaunauhauthethāde neethajaude waunauyaunee hasaunee henajanedaunene Hejavaneauthu: nau vadadauchunesenee haenethaunaa, ");
INSERT INTO arp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nau jasaa hesānauau, haeenayauhau dewauchāhenethe haujaunau nau vavavāauhuhauau, Mare haseadagu Magdalene, naunudanavathe nesaudauchu wauchāhenethe haujaunau, ");
INSERT INTO arp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nau Joanna henene Chuza Herod hadāhevāhe, nau Susanna, nau haewauthanauau hauthauauau, hevenādaunau hethāenetheyaunenenau. ");
INSERT INTO arp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nau hāeneenawauthaa henanedanede dauauāchaudenee, nau haeedasaa hehethee nanadee hedane, hanaāeanadede jegausauhānee: ");
INSERT INTO arp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jenayāhe haewauneneāgude hejenayaunau: hauthauau haejajanesanau vaunaa; nau haeauguhudaunene, nau neahehauau hejavaa haeaudauvanauau. ");
INSERT INTO arp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nau hauthauau haedasegaugauusanau hauunagāe; nau chauchaunu hāeveseuu, haenadadanau, hanau daujenajenee. ");
INSERT INTO arp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nau hauthauau haejajanesanau hegauau dauchuuwusee; nau dauchuuwuse haenauguveseaunau, nau haeajedaunanā. ");
INSERT INTO arp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nau hauthauau haegaugauusanau dasee hadauuthadee vedauauwuu, nau haeveseaunau, nau haeneeaunau vadadausauau jenayaude. Nau hāenehedauau nuu hayauhuhau, haevasenehe, Daun henaudaununede, nanehanedauvade. ");
INSERT INTO arp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nau hethauguhādaunau haenaudedaunaa, duthanau nuu jegausudede, hathāhuk? ");
INSERT INTO arp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nau hahagu, Nananena vanenana haudnaenauwuna jaeyaunau henajanede Hejavaneauthau: hau hauthauauau janegausauhuthee; hadnenauhauthāthee havajenauhaudauwu, nedauvahehauau havajaenauwu. ");
INSERT INTO arp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Wauhā, heyew hasauau jegausudede: Jenayaunau hedenehede Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Henee vaunaa nanathee nenedauvathee; hanaāenauusade haujau, nau nedanauwunāthee hanadede hedahenauau, naseduhuu hethauwuthajauau, nau hadenanedanena. ");
INSERT INTO arp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Henee hauunaugāe nanathee, nanedauvanauthe nesedanuu hanadedaunau nauguu haunauwuthajaude; nau nuu hehauwuthājenenauau, vanehaa nethauwauduu, nau nauauchaudaunauthe vasehadede naneenaunegauhuthee. ");
INSERT INTO arp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nau henee nejajanesāe thauhauthauchauyauau dauchuuwusee nanathee, hanesenedauvanauthe, naneejathāauthee, nau neenadejethathee heee haunaunethaude nau nethauyādahede nau haunauwudaude, heee nuu henaedede, nau hehauwunauuchaudenauau vevenaudenau hadauuyauthaunee. ");
INSERT INTO arp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hau henee hadauuthadenee vedauauwuu nanathee, hethauvahethee nau hethadenee hedahenau nenedauwauduu hanadedaunau, naunaunedethee, nau nenauuchaudethee vevenaudenau heee jenauwauaunee. ");
INSERT INTO arp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hegau henane, hāesedeauchauuu nauauuthayau, hehauwaugau heee vasenau, nau wauāthe hehauwujenane thānee hauvaa; hau nethānauau nauauuthayau neetheaugunee daun janedāde hadenauhaudauau nauauuthayāgu. ");
INSERT INTO arp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hayewhu hehauwuyauthesa, haudjauthasenesehee; wauāthe hayewhu hehauwuyau hadjaenaunee nau hadnejaunauau hauthasauau. ");
INSERT INTO arp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Haunauyauhaudauwuu hanathadauvanā: daun nanethenaude, nananede haudnevenade; nau daunjanenethenaude, nananede haudnedanauwunade daun henetheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hanaāedasāde henaune nau henethesaunau, nau haejeneedasaa heee dauneethenadedaunenee. ");
INSERT INTO arp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nau haeāedauwunaa jachau hathāhuk, Hānau nau hāthesaunauau theauguthee jathee, vanadaunauhauvānaune. ");
INSERT INTO arp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nau hanaāauchuhananadede nau hanaāāedauwunaude, Nānau nau nāthesaunauau nuu nanathee nanedauwauduu hedanadedaunene Hejavaneauthu, nau naasedauthee. ");
INSERT INTO arp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wauhā hethauwuu jasaa hesee, haejedā thewaunaa nauguu hethauguhādaunau: nau hanaāāedauwunaude, hadeyehaunau hauchaunau neajee: nau hanaāejathethuauthee. ");
INSERT INTO arp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hau hajechuauthee haenaugau: nau hanaāenauasaa neajee haenaudasa; nau haeechauchaunane naje, nau haeanedaudauwugaujauaudahede. ");
INSERT INTO arp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nau hanaāedauchauthee, nau haeauwaudananauau, Hechauhauthethāhe, Hechauhauthethāe, gaujauaudāhenauau, hathauhaugaunee Hanaāethauwauthede, nau hanaāeneudauau hasāse nau dasenaunanaunee naje: nau hanaāedauunauuu, nau hanaāedādauyauau. ");
INSERT INTO arp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nau hanaāenehethaude, daude hadethauwaudadenenau? Nau haenāthajaunauau haejenaunethajaunauau, Dauhuthenane naa, hanathadagaunee; haauchuwudede hasāse nau naje, nau hanaāethauwaudaunāde. ");
INSERT INTO arp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nau hanaāenuusathee vedauauwuu Gadarenes, hauchaunau Gananee. ");
INSERT INTO arp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nau hāeyehaude vedauauwuu, hena haenuchaunaa jathee hedan jachau henanene, haenethena haujaun dajechauau, nau haevedauauchauna, haejenaede hauauwuu, hau nedauthānavathe gaujauaudahehehau. ");
INSERT INTO arp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hāenauhauwaude Hejavaneauthusaun haevasanade, nau haechaagujanaugudauna, nau hanaāevasanadethaude, Hauddusehathe, Hejavaneauthusau, Nananene Heau Hejavaneauthau javaājauuthee? Nenedauwunathane Nananene jevanaunauchauthehe. ");
INSERT INTO arp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Hanau haenesedauwauna wauchāhenith haujaun hadjenauahenith hehethee henanene. Hanau nauaunee dauhusedanāde: nau naunaunehade neduguhude heee vāejethāduguthaunau nau nesaunajethaunau; nau haegaugauchauagude heeduguhudaunau, nau haejathethasauaunaa haujaun hesee nauaunee.) ");
INSERT INTO arp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nau Hejavaneauthusaun haenaudedaunaa, Haudusee? hathāhuk, Nau hanaāāedauwunaude, Waunauthade: hanau dewauthanethe haujaunau hethāchaudaunādaunau. ");
INSERT INTO arp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nau haenedauwunanauau hadjenesedauwaunathee hadjeyehauthee hethauvaa. ");
INSERT INTO arp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nau hena haewauthanauau neauthuwauchu nevethehethee hauanee: nau haenedauwunanauau hadjenanāthee wauhaunee. Nau haejenana. ");
INSERT INTO arp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hanaāenauahethee haujaunauau hehethee henanene, nau haewauhaunesanauau neauthuwauchuu: nau vahee neauthuwauchu haejathegauhunauau neenanee janahuu yesee neajee, nau haevanadeavenauau. ");
INSERT INTO arp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hāene henee nauchauwauthee daunauhauduu hasedaudenenee, haedaugauhunauau, nau haejathāaunauau nau haeaunauthedanauau hedan nau vedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hanaāeyehaudenee hadnauhauwuu daun hasedaudenee; nau haeedauchau Hejavaneauthusau, nau haeveehau henane, heneenenauthāde haujaunau, haetheaugu heauthene Hejavaneauthusaun, haeedāchaunene, nau haechuwuthajaune: nau haenāthajaudene. ");
INSERT INTO arp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Henee nenauhauwauthee haeauthedanauau neesenayauhade nenethenaude haujaunau. ");
INSERT INTO arp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hadauchaa hathāauauvaa Gadarenes gauānee haejathethajenāhenauau; hanau dauusāhede: nau hanaāeyehaude nauauhuu jethee thewaunaa, nau hanaāejaesade. ");
INSERT INTO arp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wauhā henane nenauthāde haujaunau haenehethaa hadnenethaunāde: hau Hejavaneauthusau haejathethajenāhe, hathauhuk, ");
INSERT INTO arp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Jaeyehau haudauauwuu, nau hadnauhauthethā hathāenavasauau hayewhu Hejavaneauthau hasehāne nananene. Nau hanaāejathāaude, nau haeautheda nanadee hathāaunee hedan hathāenavasaunee hayewhu Hejavaneauthusaun hasehāde. ");
INSERT INTO arp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nau hethauwuu hāejaenauusade Hejavaneauthusau, henanedanede haeneethajaudaunaa: hanau haevadauyauhauwau. ");
INSERT INTO arp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nau, naune, haejenauusa henane Jairus haseagu, nau hadāhevāhe vevethahenauauwuu: nau haeuāneseve Hejavaneauthusaun heauthene, nau haeadetha hadjewaunejedānith hedauauwuu: ");
INSERT INTO arp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hanau haenesāhene hedaunau wauau hanesenee jajenevāhe, nau haeayānajane. Hau hajesesade henanedanede haevauhaunaa. ");
INSERT INTO arp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nau hesā haeevathaude nesenee jajene heee, haevathede haunauude hevāejethāwau heee naudaunehāhehau, hau haejenayauhau, ");
INSERT INTO arp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Haeedasa hegauwune, nau haevasane naunauchuu heduwune: nau chauchaunu haejenevathaude. ");
INSERT INTO arp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nau Hejavaneauthusau hanaa navasanāde hahagu? Hāevahethedauwaudenee, Peda, nau hathāenethaunāde, Hechauhauthethāhe, henanedanede vauhaunane nau naneethenane, nau hanaa navasanāde, nesehene? hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nau Hejavaneauthusau, hanaadee vasanānau, hahagu: haenauwau daujasesenauauau vadaude hehethee nananenau, hahagu. ");
INSERT INTO arp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nau hāenauhaudauau naa hesā daujeyauthesee haejeyehau haeahenauau, nau hanaāechauāgujanaugudaunaude, haeauthedauna hauthasee vahee henanedanede hathavasanaude, nau hasenayauhāde chauchaunu. ");
INSERT INTO arp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nau hanaāāedauwunaude, Nauddau, nanehāauwauthenaedene: nananene hadethauwuthajaude henayauhāne nananene; najesa haunauwuthajau. ");
INSERT INTO arp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hajesanadede, hena haejau hanesāde hehethee hadāhevahew vevethahenauauwuu, haeāedauwuna, Haudauna najaa; jevajenaunevene Hechauhauthethāhe. ");
INSERT INTO arp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hau hāenedaunāde Hejavaneauthusaun, haenaāāedauwunāde, jevanāthajau: hethauwuthajau vavade, nau haudnenayauhade, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nau hāejedāde hauauwuu, henanedane haejevadaujedāne, vavade Peda, nau James, nau Jaun, nau henesaunaune nau henaune hesāhedāeyaune. ");
INSERT INTO arp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nau vahee haevewauhudaune, nau haeaudauwuthajauhā: hau hanaāenehede, Jevavewauhuu; hehauwunaja, nauthe naugauhude. ");
INSERT INTO arp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nau haeauchauthanauau haevachunaunanauau, dauaenaunauthee daunajanethe. ");
INSERT INTO arp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nau haevanudana, nau hanaāedanaude hejadenene, nau hanaāanadethaude, Hesāhee, thauwauthe, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nau hevadathuwu haejaedasaa, nau haethauwauthe chauchaunu nau hanaāenehede hadnauchauvavathe. ");
INSERT INTO arp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nau henehā haegaudauwuthajaunenau: hau haeāedauwuna hadjāedauvanethe henanedaa hasedaude. ");
INSERT INTO arp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Hanaāadethaude vadadauchu nesenee hethauguhādaunau hauānee, nau haejaanauwuna naudahede nau hadvaheneedauthee nanadee vahee haujaunaa, nau hadnenayaudethee haugauwude. ");
INSERT INTO arp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nau haejenana hadnauthedaudauwunethe henajanedaunene Hejavaneauthu, nau hadnenayauhaunethe hasauwauvahehehau. ");
INSERT INTO arp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nau hanaāāedauwunaude, Jevaedanauwuu hayewhu heee hajavechaudenenau, daudause haugaudauhunau, daudause newaugusajaānauthau, daudause jauaujau, daudause vāejethā; daudause jevanesauguvechudaunaa. ");
INSERT INTO arp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nau daun hauauwuu hadaujedānā jenaadauna, nau jenaathejathāauna. ");
INSERT INTO arp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nau daun hajethauhauvādaunenau, hāenauahenā hena hedane, hadegauyāejaheva naudauuyāgu hadneaenaunathee. ");
INSERT INTO arp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nau hanaāejathāauthee, nau haeehedesanauau hauauwudan, haeauthedaudauwu hethadenee waunauyaunee, nau haevahenayauthānauau nanadee. ");
INSERT INTO arp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wauhā Herod naja haenedauva vahee hanasedaudenenee heee: nau haejaene, hanau haenaasenehedaunee gauuu, henee Jaun jaegauhāde hehethee denajaa; ");
INSERT INTO arp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nau gauuu, henee Elias naunauhauthethāde hedanayau: nau hauthauauau, hanesāde dajechauau haeyāhehauau jaegauhāde. ");
INSERT INTO arp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nau Herod haenehe, Jaun nedavaāsauau: hau hanaa naa, nanedauwauthau? Nau haevadaunauhauva. ");
INSERT INTO arp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nau vadauhanauau, hāejaenuusathee, haevahauthedaunaa hanasedaunethe. Nau hanaāedanaude, nau hanaāejathāauthee hevenanee hesee hadaunechaudanee hathauau hedan Bethsaida haseāgu. ");
INSERT INTO arp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nau henanedanede hāaenuu, hanaāethauguhauthee: nau haeesedana, nau haeauthedauna hasaunee henajanedaunene Hejavaneauthu, nau haeenayauha hathāevadauunayauhathee. ");
INSERT INTO arp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nau hāayānaesade, hanaāejenuusathee nesenee, nau hanaāenehethāde, Nanehāejathāaudenee henanedanede, hadeehaudenee hauauwudan nau vedauauwuu nauanee, nau hadenethee, nau hadejasedauthee vethewau: daunechaudaa hadaunauau. ");
INSERT INTO arp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hau, Venaa nananena hadevethehedaunee, hathauhuk. Nau hanaāāedauwunauthee, Hau nanethenauwunauau hehauwujavaānee hayauthaunāe jauaujaunau nau hanesethee nauwu; hanāyehaunee nau haunaudaunauhuu vethewau heee vahee nuu henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hanau wauau haeyauthaune vasevadadausauau henanenauau hanaadauchuthee. Nau hanaāāedauwunaude hethauguhādaunau, Janauguhaa yauyauthauyauaugunauha. ");
INSERT INTO arp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nau hanaasedauthee, nau haevajanauguhanauau. ");
INSERT INTO arp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hanaāedanauau hayauthaunanenee jauaujaunau nau hanesenethe nauwu, nau hanaāejenāauguaude hejavaa, haevevethasa, nau haenaāejeanauau, nau hanaāevenaude thauguthāhehau haudjenanauwunethe hathaājedaunenee henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nau haevethehedaune, nau haevahegaudaudene; nau haeauānenau jeyauwaunau hathāenathaudāe nesenee hanaadauchāe hanechauchaunāe nenethaudanee. ");
INSERT INTO arp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nau hethauwuu, haenesenane, dauvevethahede, Hethauguhādaunau haenethaunaa: nau hanaāenaudedaunaude, Hanaa nenehede henaneda daunanenau? hathauhuk; ");
INSERT INTO arp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hanaāauchuhananadethauthee, Dusaayā Jaun; hauhauthauauau nethee Elias; nau jasae nethee hanesāde dajechauau haeyāhehauau jaegauhāde. ");
INSERT INTO arp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hanaāenehethaude, hau hanaa nenehede nananena daunanenau? Peda hanaāauchuhanāedauwunaude, Chris Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nau haeneenadauduvā, nau haenesedauwaunā hadjāedauwunaunethe henanedanau henee; ");
INSERT INTO arp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Heau henane hadnasenede wauthanee heee hayewhu, nau hadnausāguthāde vachaugānanenau nau naja vevethahevahehauau nau wauthaunauhāhehauau, nau hadnaade, nau hadjaegauhāsanade nasese, hanathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nau hanaāevahāedauwunaude, Hith henaneda jethauguhānaugu nanehanaunauchauthehadede, nau jeedane henaugauchu hayauwusenenee, nau najeethauguhaa. ");
INSERT INTO arp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Daun haunaugaunayaudede hedenaedede hadnanadede: hau daun hanadede hedenaedede heee nadanayau, nananede hadnenayauhadede. ");
INSERT INTO arp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hauddusedau henane, vahesedanauaugu hathāauauvadenee, nau hanahadagu, nauwauāthe hausāguthadagu? ");
INSERT INTO arp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Daun naudauthedaunāde nau nadanadedaunau, nananenith Heau Henane haudnaudauthedaunaunith, hāenauusathe nehayau hadauvasāthanith, nau Henesaunaune hadauvasāthanith, nau vadanee hautheaunauau hadauvasāthanethe. ");
INSERT INTO arp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hau hadethauwauthedaunathava hauthauauau theauguthee hede, haudnehauwuvajadauwu gaujauaudahede, haunaude haudnauhauduu henajanedaunene Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nau hethauwuu wauau hanasaudauchuse hāesenehede, Hanaāedanaude Peda nau Jauneau nau Jameseau, nau hanaāenauauhusathee hauanee hadnevevethahethee. ");
INSERT INTO arp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nau hajesevevethahede haenauasāaune hedauchaveau haeanathadene, nau hedāchaunau haenaujaunenau nau haenaunauaugausauaunenau. ");
INSERT INTO arp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nau naune haeanadethaa hanesenethe henanenau, haenanenenau Mosaseau nau Eliaseau; ");
INSERT INTO arp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Daunauhauthethāde hedanayau haenausāaune, nau haeauthedaude haudgaujauaudāde hadvathechauchaunaudede hehethee Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hau Peda nau hethāenethaunādaunau haenauwaunanenau: nau hāauwaudauaunethe, haenauhaudauwunenau henauasāaude, nau hanesenethe henanenau haenethauguvaa. ");
INSERT INTO arp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nau hethauwuu, hāenauthāde, Peda hanaāanadethaude Hejavaneauthusaun, Hechauhauthethāhe, hethadee hasanedaunee hede: nau hadenesedauna hanasāe nenaunau; hanesadee Nananene, nau hanesadenee Mosese, nau hanesadenee Elias; haejaene daunhasenehede. ");
INSERT INTO arp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hajesanadede, haejenauusanau henaunauade, nau haeduguaunā: nau haenāthajaunaunauau daujedāthee henaunauadee. ");
INSERT INTO arp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nau haejeanadedaune hehethee henaunauadee, Naa nananede Navechauthau Nāa: nedaunaa, hāheagu. ");
INSERT INTO arp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nau hāesanadedaunee, Hejavaneauthusau haenesenane. Nau haeyaudenauau, nau haejāedauwunanauau henanedane hena hesee neanāthauhauduu. ");
INSERT INTO arp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nau hethauwuu, dauauthesenenee, hāejejanauhusathee hehethee jauaudanee, haegauāhenenau henanedanau hejajedauaunādaunenau. ");
INSERT INTO arp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nau, naune, henane hehethee henanedaa haevasanade, Hechauhauthethāhe, nenedauwunathane Nananene, daugauhauwune nāa: vavadenaanesāde nadāeyauneve, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nau, naune, haujaun hedanāde, nau chauchaunu haedauyānade; nau haethauwuguthaa haevevechauchaunaude jeda, nau haeasenehaa haejechuwauthenauthaa. ");
INSERT INTO arp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nau nananenau neautheawu hāthauguhādaunauau hadnausāguthauthee; nau nejeneedauthee. ");
INSERT INTO arp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nau Hejavaneauthusau hanaāauchuhananadethaude, Hau hāhauwuthauwuthajau nau daujechuwauthenaedene, haudedauhujesenedauguvathe, nau haddauhujesenethauguvathe? Jāsene nananene hāa hede. ");
INSERT INTO arp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nau hajesejaude, haujaun haeauneguthaa, nau haethauwuguthaa. Nau Hejavaneauthusau haeneneuva wauchāhenith haujaun, nau haeenayauha dāeyaunauau, nau haejaevena henesaunaunene. ");
INSERT INTO arp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nau haevagaugauanadauwu hasevasenaudāhenith Hejavaneauthu, Hau hajesegaugauanaduu haunauude vahee hayauhuhau Hejavaneauthusaun hanasedaunith, Haeāedauwuna hethauguhādaunau, ");
INSERT INTO arp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chuwauthee nuu hanadedaunau jedānauha haunaudaununenau; hanau heau henane hadvenavathe hejadenene henanenau. ");
INSERT INTO arp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hau haejaenauwu nuu hasenehenith, nau haeyaudaunaunauau, haejaenauwu: nau haeeadaunaudedaunanauau hasenehenith. ");
INSERT INTO arp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hanaāegaugauudedaunee, hanaadee haudvasāthaa. ");
INSERT INTO arp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nau Hejavaneauthusaun, haeaenauwu hanasethajauthee hedahenauau, haeedana dāeyaunauau, nau haeauyejanauguna, ");
INSERT INTO arp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nau hanaāāedauwunaude daun hanesedanaude nuu dāeyaunauau naneseedaunaa hadnesedanānau: nau daun nāsedanāde haudnesedanaude nājejenanādaune; daun javaānadavenuhunede haunauude nananena vahee nananede hadnaasevasāthaa. ");
INSERT INTO arp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nau Jaun hanaāauchuhanāedauwunaude, Hechauhauthethāhe, neenauhauwaunauau hanesāde nenuguthaude haujaunau heee haneseede; nau needauduwaunauau, hanau dauhujenethaunānauau. ");
INSERT INTO arp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nau Hejavaneauthusaun hanaāāedauwunāde, Jevadauduvaa hāhauwasānavāne nanesevānauau. ");
INSERT INTO arp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nau hethauwuu, hāenauauchaunee hadneejejanauhudanāde, haechuwuyethaāne hadnehaude Dādaunedan, ");
INSERT INTO arp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nau haeautheava sayānee: nau hanaāejathāaunethe, nau hāejedāthee hajasee hauauwudan Samaritans, hadnesaanudaunāde. ");
INSERT INTO arp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nau haejesedanaa, hanau dauyethaāsade Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nau hāene hethauguhādaunau James nau Jaun daunauhaudauwunethe nuu, hanaāenehenethe, Vahadāhene, gaujevadaunedauwaune heseda hadjejanauhusanauau hehethee hejavaa, nau hadnevadauchauuthee, neesedaude Elias? ");
INSERT INTO arp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hau hanaāeyethaādauusade, nau haeneneuva, Nananena hāhauwaenava daun vadathau nananena hadahena, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hanau Heau henane hehauwuujau hadnenauaudede henanedanau hedenaededaunenenau, hau hadnenayauhaude. Nau hanaāeyehauthee jasaa hajasee hauauwudan. ");
INSERT INTO arp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nau hethauwuu, hajesethaugudethee vau, jachau henanene hathāhuk, Vahadāhene, nananenau hadnethauguhathane nananene daun nananene hanasesanaune. ");
INSERT INTO arp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nau Hejavaneauthusau hathauhuk, Gauauwuauau neyāethee, nau neaheauau hejavaa nenauhuchaunethee; hau Heau henane heyauhuunee nedauusevaānede. ");
INSERT INTO arp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nau hanaāenehethaude jachau, Jethauguhu, hau hathāhuk, Vahadāhene, nedauau nawaunejenanau nāsaunau. ");
INSERT INTO arp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hejavaneauthusaun hanaāāedauwunāde, Nanehajenanauthee gaujauaudahehehauau negaujauaudāhenethee: hau jathāau nananene nau haddauthedaude henajanede Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nau jachau jee, hathāhuk, Vahadāhene, hadnethauguhathane nananene; hau jechuwauthehe nedauau nawaunenaunenechauthaunauau, hanedauthee nayāenau naudauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nau Hejavaneauthusaun hanaāāedauwunāde, Hegau henane, dunauaugu thauauauwujethau, nau jaaāyaugu, hehauwunaathā henajanedaunene Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nuu heee Vahadāde haeautheava hauthauau nesaudausauau jee, nau haeyeyethautheava hanenesenethe sayānee haunauude hedan nau vedauauwuu, haudnanādaunauusade. ");
INSERT INTO arp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Henaheee hanaāenehethaude, Jenayaunau hethauwuwauthāe haneseuu, hau nesethāhehauau hajewauthathee: vevethahee nananena heee Vahadāde deseuujenayaunau, hadejejenanaude nesethāhehau hejenayaunaa. ");
INSERT INTO arp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jathāauau nananena hathaāsana; naune nananenau janenanathana neānee waude haudāsaunauau hejee hauchāhee. ");
INSERT INTO arp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jevanewuunauwuu nesevāejethāwaunau, newaugusajaānauthau, nau wauaunau: nau jevanaunenāthedaunaa henane hauvaunenau. ");
INSERT INTO arp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nau daun hauauwuu nananena hadaujedānā, Dādauyauha nuu hauauwuu, nedauau hadeva. ");
INSERT INTO arp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nau hith heau dādaunee hanedauyaugaune, nananena hadādaunahedaunenau hadnaadaudauyānusaa: hau jene hadjaegauusedaunāna. ");
INSERT INTO arp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nau vavade hauauwuu hadanedauva, hadevetheva nau hadevanava daun hayauhuhau hauchauvadenenau: hanau nesethāhe naunaudaunade. Jevaenejedāe hauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nau daun hedan nananena hadaujedānā, nau hesedanānagu, hadevetheva daun hayauhuhau hajenanauwunādaunenau: ");
INSERT INTO arp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nau hadenayauhauva hasauwauvahehe daun hanedaude, nau hesau jeenanethāedauwunauna, Henajanede Hejavaneauthau hayāedasāna. ");
INSERT INTO arp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nau daun hedan nananena hadaujedānā, nau jesedanānagu hadjajathāauva hasesana hehethee hadaugauchaudāe hauauwudan, nau hesau jeenanesenehethauna, ");
INSERT INTO arp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Daudause nauthejahathaugu nananena hadedanaunenau, heejahadāheagu, neyesegaunuhudee nananena: hau nananena hadethauwaenava nuu, henajanede Hejavaneauthau hayāedasāna. ");
INSERT INTO arp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hau hadāedauwunathava, hadjavaānanethauauyauau hena hesee heee Sodom, javaānee heee hena hedan. ");
INSERT INTO arp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Naunauthauau hadnauauchaudauna, Chorazin; naunauthauau hadnauauchaudauna, Bethsaida; hanau havathenayauthau heheenesedaudeneagu jedauwuu Tyre nau Sidon, nuu hasehana nananena, dajechauau neaunaunevethajauduuhewauchudaudenenau, needanaugudaunee neauchuwaudenee naujuwau nau jaetha. ");
INSERT INTO arp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hau hadjavaānanethauauyauau heee Tyre nau Sidon hāenaudedaunadedaunee, javaānee nananena. ");
INSERT INTO arp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nau nananena, Capernaum, hanejanana yesee hejavaa, hadjaejanauhanee yesee hadauveeyauau. ");
INSERT INTO arp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Daun hajaathehādaunenau nananena hadjaathehānau; nau daun hauwauchānavādaunenau nananena haudwauchānavānau; nau daun nauwauchanavāde hadwauchanauwaude najejenanādaune. ");
INSERT INTO arp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nau nesaudausauau haejaenauusanauau nauguu neethajaude, hanaāāedauwunauthee, Vahadāhene, daudause haujaunauau hanechauwauaunaunauau heee nananene haneseede. ");
INSERT INTO arp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nau hanaāāedauwunāthee, Nenauhauwauau Haujau waude jahagude hasejanesaa hehethee hejavaa. ");
INSERT INTO arp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naune, Nananenau vanenathana nananena naudahede hadnauguhudaunauna seseyānauau nau hauwauhaudathee, nau nanadee vahee henaudahede haujau: nau hegau hadneaseneva. ");
INSERT INTO arp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hau vahee nuu jevaneethajaudauwuu, haujaunauau dauuchauwauaunauna; hau henauthauneneethajauau hanau nananena haneseedaunenau dauwauthaunauhuu hejavaa. ");
INSERT INTO arp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hena hāauchauau Hejavaneauthusau haeneethajaune hevadathuwu, nau hanaāenehede, Nananenau vaveenethedaunathane Nananene, Hau Nāchau, Vahadāhene hejavaa nau vedauauwuu, hanau Nananene dauyaudaunaude nuu hayauhuhau hehethee nadaunahehehauau nau hathauwunanenauau, nau hadnauhauthehauva dāeyaunauauau: hethauwuu, Nāsaunau; waude hethadee nananena hasesānenau. ");
INSERT INTO arp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Vahee hayauhuhau vanenānau Nāsaunau: nau hegau henane haenauna hanaadāne Heāhene, vavade Vāsaunau; nau hanaadāne Vāsaunau, vavade Vāa, nau nananede hanaadāne Heāwaune hadnenauhauthehāde. ");
INSERT INTO arp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nau hanaāejaedaugauhauwaude hethauguhādaunau, nau hanaāanadethaude hevenanee, Haunauwuthajaunauha hasesānenau dauhunauhaudauwuna hayauhuhau hānauhauthaunenau: ");
INSERT INTO arp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hanau nananenau hāedauwunathana, waunauthathee haeyāhehauau nau nenauchuwuthee nevadaunauhauduu hena hayauhuhau hānauhauthaunenau, hau hehauwuthauunauhaudauwu; nau devadaunedauwauduu hena hayauhuhau hānedauwauthaunenau, hau hehauwunedauwaudauwu. ");
INSERT INTO arp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nau, naune, jasaa nanavaavehe haetheaugu, nau haenaudayādauna, Hechauhauthethāhe, nauddusesedane jethauujenee henaedede? hathauhuk, ");
INSERT INTO arp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hanaāāedauwunāde, Hayew wauthaunesaa nanavaavedaunaa? Hādusasauhaude nananene? ");
INSERT INTO arp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nau hanaāāedauwunaude, Nananene hadvechauthau Vahadāde nananene Hejavaneauthau nauguu vahee nananene hadahaa, nau nauguu vahee nananene hadathuvaa, nau nauguu vahee nananene hadāahedaunaa, nau nauguu vahee nananene haugaugauuthajaudenaa; nau nananene hanedaudewau waude nehayau nananene. ");
INSERT INTO arp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nau hanaāāedauwunaude, Nananene hethauvāne: nanehasedaune, nau nananene hadnenaedene. ");
INSERT INTO arp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hau nananede, vanadauchuvanadede, hanaāenehethaude Hejavaneauthusaun, Nau hanaa nanedaudewau? hathauhuk, ");
INSERT INTO arp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nau Hejavaneauthusau hanaāauchuhanāedauwunaude, Jasaa henane haejathāau hehethee Dādaunedan hesee Jericho, nau haeesedanaa havedehehau, haethauwujedaunaa hedāchaunau, nau haeenesenehaa, nau haejathāaunenau, haenauthaa dauhayānajaa. ");
INSERT INTO arp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nau haejathedasaa jachau vevethahevahew hehethee: nau hāenauhauvāde, haejavechauthaa gauchuhunee. ");
INSERT INTO arp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nau vavade Levite, hāedadauau hadaunith, haeeda sa nau haenāauhauva, nau haejavechautha gauchuhunee. ");
INSERT INTO arp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nau jasaa Samaritan, daujādade, haeedasa hadaunith: nau hāenauhauwaude haeauwunauna, ");
INSERT INTO arp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nau haeyehau, nau haedugudauna hadauunesenenith, haeedaunauwuna javeda nau vasevenenaje, nau haedasana nehayau hedauneau, nau haenauuchauha vethehedaunauauwuu, nau haeaunauneha. ");
INSERT INTO arp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nau daunauganenee hāejathāaude, haeadane hanesanenee hevāejethāwau, nau haevena hadāhevahew, nau hadaunaunehau, hathauhuk; nau daun hasegaujauauthedanānaune jee, hāejaenauusanaune nananenau hadaunaudaunathane nananene. ");
INSERT INTO arp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hayewnau nuu hanasāe, hadeanathaunau, henedaudevādaune henee neesedanāde havedehehau? ");
INSERT INTO arp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nau hanaāāedauwunaude henee heauwunaunādaune. Hanaāenehethaude Hejavaneauthusau, nau jenaenesedaune nananene. ");
INSERT INTO arp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wauhā hethauwuu, daunausujavesathee, haenauusanauau jasaa hajaseehauauwudan: nau jasaa hesā haseagu Martha haejedana hedauauwunin. ");
INSERT INTO arp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nau haeenahavāe Mare haseeyaugaune, jea haejanaugude Hejavaneauthusaun heauthene, nau haenedauwaude hedanadedaunene. ");
INSERT INTO arp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hau Martha haeedauwauchune dauwauthanee hasedaude, nau haejeedasa, nau hanaāenehethaude, Vahadāhene, gauhajegaudauvanade daujenauthānau nahavaa daunesenesethānau? hāedauwunene hadenedahevānau. ");
INSERT INTO arp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nau Hejavaneauthusau hanaāauchuhanehethaude, Martha, Martha, nananene haunaunāhene nau dejanethajaudauwu waunauthāe hayauhuhau: ");
INSERT INTO arp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Hau hanesadee hayewhu chaunauguauau: nau Mare hayāchauhauau henee hethadenee hadāde, hehauwuneejathechauhau nauthee. ");
INSERT INTO arp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nau hethauwuu, henee, daunausuvevethahede haedaunanenee, hāejenedaude, hanesāhenith hethauguhādaune hathāhuk, Vahadāhene, jeechauhauthehāa hadnesevevethahee, waude Jaun jea neesechauhauthehaude hethauguhādaunau. ");
INSERT INTO arp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nau hanaāāedauwunaude, hāene nananena vanevethahenā jeenanesenehena, Hāsaunaunene Nananede hanedaude hejavaa, Vadanauha Nananene haneseede. Nananene hanajanede hanājaunauau. Nananene hathanavāane hadnaasedaunee hasauau hejavaa, nau jee nuu vedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hejevenāa hadauchusenee hayauwusenee vethewau. ");
INSERT INTO arp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nau jejaegudanauwunāa hewauchudaudenedaunau hanau nechau nejaegudanauwunade haunauude hanesāde nethāesayānedanauwunāade. Nau jevaechauhāa nedauvasehadee; hau haugaunayauhāa hehethee hadau wausauau. ");
INSERT INTO arp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nau hanaāāedauwunaude, hanaa nananena hadnenedaehahede, nau hadneyehaude thaudajaa, nau hadethaude, Va, jeehe hanasāe jauaujaunau; ");
INSERT INTO arp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Hanau nādae daunauujādaunānau, nau nananenau haeyauhuunee nauchauwaude? ");
INSERT INTO arp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nau hehethee jedauwuu hadnauchuhanehede nau hadnenehede, Jevajanethajuhu: dajanau wauwu haugauhude, nau nanesaunauau nanejauwu naudauvaa; nananenau nāhauwuneethauwauthe nau hajeneevenathane. ");
INSERT INTO arp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nananenau hāedauwunathana, hadnehauwuthauwauthene nau hadvenāde hanau dauhunedaehāwaude, auhanau dauneenāhede hadthauwauthenith nau hadvenāde daun hadauchuvathehāthe. ");
INSERT INTO arp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nau nananenau hāedauwunathana, Henedauwauau, nau hadnevenana; henaudethāe, nau hadneveedena; hewaudāhee (dajanau), nau hadnegaunedanauwunana. ");
INSERT INTO arp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hanau haunauude hanesāde nethāenedauwaude neneaudauwaude; nau henee nenaudethāde neveenauau; nau henee newaudāhaude (dajanaune) hadgaunanauwunade. ");
INSERT INTO arp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hith hāahenau nedauwunānagu jauaujaunau jasaa nananena henesaunaune, gauhadvenaa hauunaugane? wauāthe nedauwunāhuk nauwu, gauhadvena hauchuhanee gauhadnanene nauwunenith seseyāne? ");
INSERT INTO arp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wauāthe nedauwunāhuk naunau, gauhadvena hauwauhaudanethe? ");
INSERT INTO arp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hith nananena, hauhauganenagu, hadaenava hadnesevenauna hethadenee venadedaunau nananena hadāeyaunevenau: duthāee nananena hejavaa Hāsaunaunenau hadvenāva Vadanauwauthauwu nethāenedauwunauna? ");
INSERT INTO arp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nau neausāguthaude haujaun, nau heehauwanadene. Nau hethauwuu hāejathāaude haujau, hanaāejaanadede; nau henanedanede haegaugauuthajaudene. ");
INSERT INTO arp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hau jasaa hahagu, Nausāguthaude haujaunau heee Beelzehub najane haujaunaa. ");
INSERT INTO arp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nau hauthauau, haenaudayādaunaa, haenehethaa hadnauhauthaudenenee hehethee hejavaa. ");
INSERT INTO arp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hau haeaene hedenethajaudenene, haeāedauwuna, Hadauchaa najanede nanayāsenauaugu nehayau hadneyauhuu; nau hauauwuu hasānavadenaugu hauauwuu hadjanesaa. ");
INSERT INTO arp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hith, Haujau jea hasānavadagu, hauddusetheaugune henajanede? hanau nananena denehena nananenau deausāguthaugaunee haujaunauau hehethee Beelzebub. ");
INSERT INTO arp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nau hith nananenau hausāguthaugaunee hehethee Beelzebub haujaunauau, hanaa hāahenau hadnausāguthaude? hadedauchuwuwuna. ");
INSERT INTO arp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hau hith nananenau hejadenethedaunaugu Hejavaneauthau hausāguthaugaunee haujaunauau, hethauwuu henajanede Hejavaneauthau hedasāna. ");
INSERT INTO arp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Henane danāahethe hedauchuaunau haunaunedehuk hedauauwuu, hevatheyaunau nedādauyaunee: ");
INSERT INTO arp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hau hāejavaādāāhenethe javaāhehuk hedasāhuk, nau veavehāhaugu, hadnedanauwunāde vahee hedauchuaunau heaanadauwaudenau, nau hadjaanenee hesehaudenau. ");
INSERT INTO arp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Daun najenethaunāde hasānavānau: nau daun najenethauāyāvāde naneāsauauwaude. ");
INSERT INTO arp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Hāenauthauthe wauchāde haujau henanene, nehedesade hadaujenajenenee, denaudedede dauyānusenade; nau janeveedethe, naneenehede, nananenau hadjaesanau naudauauwuu needaujenauahenau. ");
INSERT INTO arp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nau jaenauusathe, neveedede nesewaudeauhunee nau neyaudauthaunenee. ");
INSERT INTO arp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naeneejathāaude, nau naneedanauwaude hanesaudauchunethe hauthauau haujaunau javaānauhauganenethe javaāhede; nau naneejedāthee, nau nanejanauguthee: nau waunee henee henane naeneejavaānauhauganede nedauaunejeethāde. ");
INSERT INTO arp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nau hethauwuu, hajeseanadede nuu hayauhuhau, jasaa hesā hehethee henanedaa haevasanade, nau hathauhuk, Hauwunaunade henesaunehe hājanesauthāde Nananene, nau hethanau nedaunenane. ");
INSERT INTO arp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hau hahagu, Haa, nausunee, nauwunaunathee nethāejaathededuu hedanadedaunene Hejavaneauthu, nau naunaunedethee. ");
INSERT INTO arp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nau henanedanede hāeneenanauthenanedauhuu, hanaāejasesenehede, Nuu nanaa wausauau henaedede: nevadaunauhauthāthee; nau hegau nauhauthaude hadvenaunauau, hau vavade nauhauthau nananede Jonas haeyāhe. ");
INSERT INTO arp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hanau Jonas neesenauhauthehaude Ninevites, nechau jea Heau henane hadnaathāde nuu henaedede. ");
INSERT INTO arp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nenauchuwusā janauhuu hadjaegauhāde naudedaunadenesee nauguu henanenau nuu henaedede, nau hadnauthauwuvāna: hanau dejewaunejaathehaude hehethee hāauauvadenee naunaudāhenith Solomon; nau naune, hejavaāhedaune Solomon hanedaunith. ");
INSERT INTO arp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Henanenauau hehethee Nineveh hadjaegauhāthee naudedaunadenesee nauguu nuu henaedede, nau hadnauthauwuvāna: hanau dauaugauthethajauduu hedauthedaunene Jonas; nau, naune, hejavaāhedaune Jonas hanedaunith. ");
INSERT INTO arp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hegau henane, hāesedeauchauuu nauauuthayau, hehauwujenane yauthee, daudause hehauwugaudauyauvasenaunaa, hau dasee nauauuthayauneetheaugunee, nethāejedāthee hadnenauhauduu naunauasādanee. ");
INSERT INTO arp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hanesenee vadanayannaa nanaa nevasesānee: nanaa hāenesadee hasesānenau nananena, nananene hadnaunauudauyauau hadanayau jea hanechauchaunaa hesee; hau hāene nananene hasesā wausuu, hadanayau jea hadnechauchaunaudene vaneeyauau. ");
INSERT INTO arp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Haunauyauhaudauwauau hanau henee hesee hathāsadaude nananene jeva veeyauha. ");
INSERT INTO arp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hith nananene haunauudauyaugu hadanayau hanau hadnechauchaunaudene hesee, hadnehauwugauuveeyau haunauude hadnechauchaunaa hesee, waude naunauasādāe nauauuthayau nevenāna hesee. ");
INSERT INTO arp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nau hajesanadede, jachau Nesethajauhu haeadethaa hadnethevethehewaude: nau haewaunejedā, nau haejanaugu dauvethede. ");
INSERT INTO arp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nau hāene Nesethajauhu nauhaudauau, haegaudauvanava daujaheseuhunith nedauau hajesejevethehenith. ");
INSERT INTO arp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nau Vahadāhenith hathāhuk, Hewaunehaa nananena Nesethajauhuhauau neyauthahenauwuna jathee vāenaunau nau saenaunau; hau nananena hethauvaa hanechauchaunaudena vahedayaude nau hauhauganede. ");
INSERT INTO arp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nananena janethauvahena, gaujenane Hejavaneauthau nenesedede jathee gaujee henesede jedauwuu? ");
INSERT INTO arp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Hau hevāe hauwuyau daun hanetheyaunenau; nau, naune, vahee hayauhuhau hadnesewaudeanauwunana? ");
INSERT INTO arp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hau naunauthauau hadnedasāna nananena Nesethajauhuhauau, hanau nananena hadvāna vadadauchu wauhaunauau nau naneujaudevejechau nau vahee hathāejajāesuu vejechau, nau hadjavechaudauwuna vavesauchuwude nau devechauthade Hejavaneauthau; nuu hāvachunaasedauna, nau hānanejenaudauwuna hauthauau nejesehee. ");
INSERT INTO arp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Naunauthauau hadnedasāna nananena Nesethajauhuhauau, hanau nananena devechaudauwuna najatheaugudaunau jedauwuu vevethahenauauwuu, nau dejachauthana nedauaudaunauvadee. ");
INSERT INTO arp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Naunauthauau hadnedasāna nananena, wauthaunauhāhehauau nau Nesethajauhuhauau, nanadaunahena, hanau nananena waude nedaugaudauyauhudaunee dejenauhauwuu, nau henanenauau nedasejavesathee hehauwaenaunā. ");
INSERT INTO arp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hanaāauchuhananadede hanesāde nanavaavehe, nau hathauhuk, Hechauhauthethāhe, nuu dauhanadene nananene naunaunauthevāana jea. ");
INSERT INTO arp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nau hathāhuk naunauthauau hadnedasāna nananena jea, nananena nanavaavehehauau, hanau nananena henenauchuna henanenauau nauguu henenauchude hehayaudee javechauhunee, nau nananena nehayau jevavasanauwuu henenauchudaunau heee hanesadee nananena hajadenenau. ");
INSERT INTO arp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Naunauthauau hadnedasāna nananena, hanau nananena denesedaunauna gaujauaudahenauauwu haeyāhehauau, nau hāsaunaunenau denauauthee. ");
INSERT INTO arp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hethauwuu nananena haeyāna henee nananena wauhaunee nanāsedauthee hāsaunaunenau: hanau denauauthee, nau nananena nenesedena hegaujauaudahenauauwunenau, ");
INSERT INTO arp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Naasauau jea hahagu hedaeyaude Hejavaneauthau, Hadjenanu haeyāhehauau nau vadauhanauau, nau hauthauau hadnenaathee nau hadnenaunaunauchauthehathee: ");
INSERT INTO arp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Henee hevaevenau vahee haeyāhehauau, hanedaunee hehethee davadeesehee vedauauwuu, hadneenaudedauwuhuu nuu henaedede; ");
INSERT INTO arp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hehethee hevaevaa Abel nauuu hevaevaa Zacharias henee nenajaa nahethāe jaanaa nau vadannauauwuu: hethauwuu nananenau nehethathana nananena, hadneenaudedauwuhuu nuu heee henaedede. ");
INSERT INTO arp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Naunauthauau hadnedasāna nananena nanavaavehehauau, hanau nananena dauhudanauwuna gaunaudauauha haeyaude: nananena hadnehauwujedāva nehayau, nau henee hathāejedāthee nananena najauaunauna. ");
INSERT INTO arp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nau daunenehedauau nuu hayauhuhau yesee, wauthaunauhāhehau nau Nesethajauhuhauau hanaāejaseseneenanaudedaunāde, nau haeneenadaunanauau hadnauthedaudauwunith hauwauhuu hayauhuhau; ");
INSERT INTO arp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Haeaudenauthaa, nau hadnesedanauwunethe hayewhu hehethee hedenene, hadnāedauwauthauthee. ");
INSERT INTO arp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gaunauwuu, hāene hena hauāchaudenee hauānee haejedaguu hadauchaa henanedanede, dauwauthaa haeaunauguhudaunadenauau, hanaāejasesāedauwunaude hethauguhādaunau nedauau vahee, Haunauyauhaudauwauau nananena gauhaujau Nesethajauhuhauau, nenadaunahethee. ");
INSERT INTO arp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hanau hehauwuyauthesa, hathāeyauthesaa, daudause hehauwuyauthesa, nethāejaenaunee. ");
INSERT INTO arp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hanau daun nananena hasanadenā veeyaugu hadnedauwuhuu hesenee; nau henee nananena hasenehenā waunaudaunuu jedauwuu hadnauchunana dasee hauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nau nananena hāedauwunathana Nādaehauhauau, Jevaesaa henee nenadethee henanedayāhau, nau heee hehauwauthesedaunauau. ");
INSERT INTO arp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hau nananena hāedauwunathana daun nananena hāchaunenau: Hesaa Naa, heee hesenaānagu naunaudāde hadgauusevāna hadaugauhauchanee; haa, Nananenau hāedauwunathana nananena, Hesaa. ");
INSERT INTO arp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Hayauthaunethee hajaseaheauau gujeaudaunaune heee hanesāenee nevaāhenee, nau hanesāde hehauwunauneethedaunā Hejavaneauthu? ");
INSERT INTO arp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hau daudausee hadauchāe hāthaanenau haudauguhuanenau vahenayāee. Jevanāthajauau henaheee: nananena javaānauwauhuana hadauchuthee hajaseaheauau. ");
INSERT INTO arp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jea Nananenau hāedauwunathana, Daun naujaudauthehāde hesee henanedaa, nananede Heāhene henanene jea hadnehauwaudauthehaa hesee hautheaunau Hejavaneauthuu. ");
INSERT INTO arp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hau henee nauyauhāde hesee henanedaa hadneyauhade hathaāhenethe hautheaunau Hejavaneauthuu. ");
INSERT INTO arp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nau daun hayādaunaude Heāhene henanene, hadjaegudanauwunade: hau nananede henee hauhauganedauau Vadanauwauthauwu hadnehauwujaegudanauwunau. ");
INSERT INTO arp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nau hāejedanānā vevethahenauauwuu, nau hauchuwunanenauau, nau najanauau, jevagaugauanadauwuu wauāthe daunhayewhu nananena hadnesauchuhanehena, wauāthe daun nananena hadnesenehena: ");
INSERT INTO arp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hanau Vadanauwauthauwu hadnāedauwunāna nauauchaugu daun nananena hadnesenehena. ");
INSERT INTO arp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nau hanesāde hehethee hananedaa hathauhuk, Hechauthethāhe, hanadesene nasaa, hadegaugauanauwaunauau vatheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nau hathāhuk, Henane, hanaa nanesehāde hadnauchuwuhathane nau hadjaanauwunathane nananene? ");
INSERT INTO arp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nau hasenehethauhuk, Haunauyauhaudauwauau, nau naseduhuu jevavathehāe: hanau henane hedenaedede hehauwunedahevaa wauthayāgaune hevatheyaunau henetheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nau haeanadetha haejegausudenanadetha, Vedauauwuu jasaa nethauyāsenane haenautheauthā: ");
INSERT INTO arp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nau hasethajauhuk nehayau, hewauau hauaudnesedaunaune, hanau hajenethenauwau jedauwuu hadnedauthānauwau navethenau, hahagu? ");
INSERT INTO arp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nau hanaāenehede, nuu hadnaasedaunau: hadthauwunauwau nathāyānauauwuu, nau hadnesedenau hadjavaāvasauau; nau hadnaadauthānauwau vahee navethenau nau navatheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nau hadnaāenehethauau navadathuwu, Vadathau, nananene nanethenauwu waunauthāe hanetheyaunau janenanee hadwauthāe jajene; hedanau nanethauaunenaedede, hevethehe, hevaveyā, nau haunauwunaede. ");
INSERT INTO arp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hau Hejavaneauthu hathāhuk, Nananene Hauhauga, nuu dauveeyauau nananene havadathuwu hadnedauwunane: heee hanaa hadnethenauau hajenayaunau? ");
INSERT INTO arp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nananede haenathaunau heveaunauaudenau, nau hehauwuveaunauau hesee Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nau hathauhuk hethauguhādaunau, Naa nehethathana, Jevaegaugauanadauwuu hadenaededaunenau, daun hadnevethedaunenau; daudause heee hadanayaunenau, daun hadnāsaunenau. ");
INSERT INTO arp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Henaedede javaāsaa vethevaa, nau vadanayau javaāsaa hāchaunaa. ");
INSERT INTO arp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gaugauanavaa huunauau: hanau dejejenayāthee nau dejegauausauhāthee; hehauwunethenauwu thāyānauauwu nau vethewau nedauthāsanenee; nau Hejavaneauthau nauchauwaude: gauhajavaāneenaedeva neahenaa? ");
INSERT INTO arp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nau hanaa nananena vanadauanāde heee neejahehee? ");
INSERT INTO arp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hith nananena wauhā jeneenesedaunagu henee haugajuhuu, naudu hajanethajaudauwuna hauthauau? ");
INSERT INTO arp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gaugauanadauwuu nenaugaānuu nejajaesaānuu neseveseuu: hehauwunesethānaunau, hehauwunethaudayānaunau; nau nausunee nāedauwunathana, henee Solomon vahee hevasāthade heehauwunaasenu hasaunee nuu. ");
INSERT INTO arp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hith wauhā Hejavaneauthau heneenudehuk wauchuunau, nuu desenee nauau, nau naugaagu hadneewaudedaunaunee; hāduthāejavaāvenāva hāchaunau, Hau nananena vanehaa hethauwuthajauna? ");
INSERT INTO arp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nau jevanaudedee nananena daun nananena hadnevethedaunenau, wauāthe daun hadnevaveyādaunenau, jevaauwaugaugauuthajauau. ");
INSERT INTO arp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hanau vahee nuu neauthudan hathāauauvaa nenaudethāthee: nau nananena Hāsaunaunenau haenauau henee nananena hāvathehādaunenau nuu hayauhuhau. ");
INSERT INTO arp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hau henaudedee nananena henajanede Hejavaneauthau; nau vahee nuu hayauhuhau hadnethedaunanauwunana nananena. ");
INSERT INTO arp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jevanāthajauau, hāhauwuwauthaheva; hanau nananena Hāsaunaunenau hayethanadauwunādaunenau hadvenāna henajanede. ");
INSERT INTO arp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Heaudaunaa henee hanetheyaunenau, nau hauwunaunaa hadavenuhuhauau; jasedauau nesevāejethāwaunau henee nejethauuthauauchusāe, haenathaude haneduu hejavaa henee nejethauuyauhuu, nedaujavedadenee, hehauwujuudenauau nuvanauauau. ");
INSERT INTO arp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hanau haduu hadaenathaunenau, hena hadahenau jea hadnaaduuu. ");
INSERT INTO arp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Duujehee, nau haunauauuthayaunenau gauhauchanauha; ");
INSERT INTO arp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nau nanehathahena henanenauau henee nedauyauhauwauthee hanau Hadahethedaunādaunenau, hāejejaesathe hehethee gauwuhaude; henee hāejenauusathe nau hadwaudāhaude, hadgaunanauwunade nauhauhaunee. ");
INSERT INTO arp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hauwunaunaa henee nesethāhehauau nananenethe, Vahadāde hāejenauusathe hadveenaude hadnaunauyauhauthānethe: hethauwāedauwunathana, hadduujede nehayau, nau hadjanauguhaude hadvethehenethe, nau hadjeedauchaude nau hadnaunauchauwaude. ");
INSERT INTO arp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nau hith jenauusahek naneseauwaude haunauyauhauthāhe, wauāthe jenauusahek nanaseauwaude haunauyauhauthāhe, nau hadveenaude hadnesaanunethe, hauwunaunaa henee nesethāhehauau. ");
INSERT INTO arp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nau nuu hāenauwuu, henee hith henane hedauauwuu haenauaugu daun hāauchaunee havedehew neeenauusanith, haunaunauyauhauwaude, nau hanājechuwauthedaunenauhunee hedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nananena hadnaaesaanuna jea, hanau Heau henane hadnauusade daun hāauchaunee hāejenauanauwaunā. ");
INSERT INTO arp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peda hanaāanadethaude, Vahadāhene, gauhanadethāa Nananene nuu heee jegausudede wauāthe vahee? ");
INSERT INTO arp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nau Vahadāde hahagu, Hanaa henee chuvahagu nau hesenaedehuk hadāhevāhe, nananede hadāhewaunādaune, hadnevenaude gauuu vethewau nauauchaunee? ");
INSERT INTO arp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hauwunaunaa henee nesethāhe, nananenith hadāhewaunādaune hāedasāthe hadveehāde hadnaasehāde. ");
INSERT INTO arp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hethauvaa hathāedauwunathana, henee hadnesehāde hadāhewaude vahee hethāenetheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hau nau hith henee nesethāhe hesethajauhuk, Nadāhewaunāde jeguthenauusahek; nau henenesegauhahek henanenau nesethāhehau nau hesānau, nau hevethehagaunee nau hevaveyāhaugaunee, nau henaunauneseavagaunee; ");
INSERT INTO arp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hadāhevāhe henee nesethāhe hadnauusanith hajesesenenee hāejejauwuwuhauthe, nau, neeejaenauau, nau hadgudanāde nau hadjenanaude jethauwaudahehau. ");
INSERT INTO arp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nau henee nesethāhe haenauaugu hadāhewaunādaune hathanavāde, nau jesaanuhuk, daudaus dejeesedaude hathanavāthe hadnenenesegauhude dejauaunee. ");
INSERT INTO arp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hau henee jaenauaugu, nau hesedauhauk neseneneseguhededaunenee hanājauwaunenesegauhude, hanau daun hauwauhuvenāde nananede hadnauwaunedauwunade; nau nananede henane hauwauhauhauthade, nananede hadnauwaunedauwunade. ");
INSERT INTO arp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Hadjejenanauwau heseda dasee vedauauwuu; nau hayew navathehāde wauwu gauhauchagu? ");
INSERT INTO arp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hau nanethenauwau dusaahede hadneedusaahedaunee; nau hanahauwaudauaunānau haunaude hesedaudeyāgu. ");
INSERT INTO arp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Haneejaude hadjenanauau dādaunee vedauauwuu haāthanaveva? hadāedauwunathava, Hegau; hau wauāthe hanāgauanauwau: ");
INSERT INTO arp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hanau hehethee heee yauthaunenanedauneagu hanesadee hauauwuu hadgauanee, hadnasaunauthee hanesenethe, nau hadnesaunauthee hanāenethe. ");
INSERT INTO arp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Henesaunaun hadgauanathee hadnasānauwaude heau, nau heau hadnasānavāde; hesā hadnasānauwaude hedaunau, nau hedaunau hadnasānavāde, hesā hesave hadnasānauwaude, nau hesave hadnasānavāde. ");
INSERT INTO arp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nau hanaāanadedauau jea henanedanede, hāenauhaudauwunā henaunauade jevechauuchaugu hehethee nesenaesade, chauchaunu nananena, Hadnauchuhajauwausauau; nau naenesauau. ");
INSERT INTO arp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nau hāenauhaudauwunā jenauhuu hanehedasāe, nananena, hadnasedaa; nau naenesauau. ");
INSERT INTO arp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nananena nanadaunahena, nananena naenauwuna hedauchaveau haunauau nau vedauauwuu; hau dusaudee haejaenauwuna nuu hewaunehaa? ");
INSERT INTO arp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Haa, nau naudu daudause nananena haejaenauwuna hasethadee? ");
INSERT INTO arp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hāeyehauthānā hasānavādaunenau hauchuwunanenau, nausujavesanagu, nayātheneneevaa hadeenayauhāna; havaehauthāva najanauchuwunanee, nau najanauchuwunane havavena duguthāhew, nau duguthāhe havathānāva duguthānauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Hāedauwunathana havajeneenauthauva, haunaude vathaunaudauhunagu havāejethāvenau. ");
INSERT INTO arp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hena hethaa heee jachau haeauthedaunaa Gananeans, hevaewu Pinade haewauhaunauwuaunenau nedauausāyāthee. ");
INSERT INTO arp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nau Hejavaneauthusaun haeauchuhananadethā, Nauchāe nananena henee nuu Gananeans heauhaugayaugaunee javaānee vahee Gananeans, hanau daujeneethajauduu hayauhuhau? ");
INSERT INTO arp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nananenau nāedauwunathana, Hegau: hau, vavade nananena jaaugauthethajaunagu, nananena hadnavahethahena gaujauaudahede. ");
INSERT INTO arp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wauāthe hena nasaudauchunee, dasee hayauauwuu jedauwuu Siloam dethauwunauauau, nau haenanaā, gaugauanadauwuu henee gauhujavaānauhauganenauau vahee henanedanede henee theaugude jedawuu Dādaunedan? ");
INSERT INTO arp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nananenau nāedauwunathana, Hegau, hau vavade nananena jeneethajauhadede, nananena hadnavahethahena gaujauaudahede. ");
INSERT INTO arp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Haeheanade jea nuu dajenehede; Jasaa henane haenethena hauuyauchunauhaudene haejenana jedauwuu dadajevenevese nethauchayaunaa; nau haejenauusa nau haenaunaudede vevenaudenau hanāvenee, hau haejeveede. ");
INSERT INTO arp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hanaāenehethaude nesethāhew hedadajevenevese nethauchayaunaa, Naune, nuu hanasāa jajene nananenau hanejaunau daujenaudedenau vevenaudenau nuu hauuyauchunauhaudee, hau hajeveedenau: dauwauhune; hadevachunauthauyauau vedauauwuu? ");
INSERT INTO arp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nau hanaāauchuhanadethāde, Vahadāhene, hauwaa nanehasene nuu heee jaje jea, nadeesenenesede, nau vehethe hadjenanauwau. ");
INSERT INTO arp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nau hith hāvāgaune vevenaudenau neee: nauhith jene, hadnaāedauwauhade. ");
INSERT INTO arp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nau haeechauhauthethā jasaa vevethahenauauwuu vadanesee. ");
INSERT INTO arp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nau, naune hena hesā haujaunehaeheaugauwu nasaudauchunee jajenee, nau haevajanā hauānee, nau haejeneechuwuwauthe nehayau. ");
INSERT INTO arp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nau hāene Hajavaneauthusau nauhauwaude, Haeadetha, nau hanaāāedauwunaude, Hesā, nananene haunaugunane hehethee hadaugauwudaunaa. ");
INSERT INTO arp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nau hanaāevasanaude: nau chauchaunu hanaāechuvāde, nau haevaveenethedauna Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nau hauchuwunane vevethahenauauwuu haeauchuhananade nauguu hasenaunaude, hanau henee Hejavaneauthusaun denayauthānith vadanesee, nau haeautheda henanedaa, Hena nanedaudauchāe hese henane heenesethādaunau hanānaneejauna nau hanānaneenayauhana, hau hegau vadanesee. ");
INSERT INTO arp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Vahadāde hanaāauchuhananadethaude, nau hathauhuk, Nananene nanadaunāhene, gauhājene dajee hanesahena vadanesee haugunauva hauwaugajevenau wauāthe naugauchaudaheauau hehethee hewauchuhauchauwauauwuu, nau gāyethaājethauva devanauhauna? ");
INSERT INTO arp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nau gaujenaasaunee naa hesā, hedaunau Ābraham, henee Haujau heduguthaune, naune, nuu nasaudauchunee jajene, hāaugunade hehethee nuu deduguhude vadanesee? ");
INSERT INTO arp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nau hāenehedauau nuu hayauhuhau, vahee hejauthauwau haeaudaudāhenenau: nau vahee henanedanede haeneethaujaudene heee vahee havathee hayauhuhau henee hesethaunau. ");
INSERT INTO arp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hanaāenehede, dusaune henajanede Hejavaneauthau? nau hayew naudnenehethau? ");
INSERT INTO arp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Waude nejenanenee mausdaude, henane nedanauau, nau neneāgudede hejenayaunaa; nau neveseaudede, nau hāhe haeavadauhaudene; nau neahehauau hejavaa negauusee hedānaa. ");
INSERT INTO arp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nau jea hanaāenehede, Hayew naudneedajenehethau henajanede Hejavaneauthau? ");
INSERT INTO arp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Waude nesaunauchaa henee hesā nedanauau nau nejenanauau nasau dejenauhunee thauauhanau haunaude devahenesaunadāe. ");
INSERT INTO arp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nau haeehedesa hauwauhauauwudane nau hajasedan, dechauhauthethāde, nau haejāda hesee Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hanaāanadethāde hanesāhenith, Vahadāhene, gaujewauthanauau henee henayauhathee? Nau hanaāāedauwunaude, ");
INSERT INTO arp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Neaunedauwauau hadejedāna hadaugaugunesāde dajanau: newauthana, Nananenau dāedauwunathana, hadnenaudedena hadnedaujedāna, hau hadnehauwuneedauva. ");
INSERT INTO arp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hāene hechauhauthethāhe hauauwuu thauwauthehuk, nau haugauhahagu dajanaune, nau nananena hanānaāetheauguna jathee, nau hanānaāewaudāhauna dajanau, hanānaāenehethauna, Vahadāhene, Vahadāhene, jegaunanauwunāa, nau hanānaāauchuhanehethāna nau hanānaasenehethāna, Hāhauwaenaunathe daun hadesane: ");
INSERT INTO arp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hanānaāenehethauna, Nevethehenauau nau nevaveyānauau hathaāhene, hau nananene dauthedaunāanehadaugauchaudee. ");
INSERT INTO arp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hau hadnaasenehede, Hāedauwunathane, Hāhauwaenaunathe daun hadesane; nayāsesave vahee nananena nesethāhehauau wauwauchudaude. ");
INSERT INTO arp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hena hadnevewauhudaunee nau hadnegaugauchaugudasenana, hāenauhauwaunā Abraham, nau Isaac, nau Jacob, nau vahee haeyāhehauau, Jedauwuu henajanede Hejavaneauthau, hau nananena nehayau nenuguthadena. ");
INSERT INTO arp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nau hadjenauuchaudenee hehethee nejeethevesesanith, nau hehethee nesenaesanith, nau hehethe nanavee, nau hehethee janauhuu, nau hadjanauguduu henajanedaunene Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nau, naune, hena hedauaude hadnedauvade, nau hena nanedauvade hadnedauchude. ");
INSERT INTO arp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hajesesenee hena haejenauusa jasaa Nesethajauhuhauau, hasenehethāhuk, Nauahe, nau jathāau, hanau Herod hadnaāne. ");
INSERT INTO arp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nau hanaāāedauwunāthee, Najesaa, nau hadāedauwunauva hena vachuhuu, Naune, nenuguthu haujaunauau, nau nenayauthānau nuu desenee nau naugaagu, nau nanaseauwauau hesee hadnaāesedaunau. ");
INSERT INTO arp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hau hadnenesanau nuu desenee, nau naugaagu, nau jea hathavenaugaagu: hanau hehauwunaasau henee haeyāhe denaade Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hau Dādaunedan, Dādaunedan, nanathee nenauauthee haeyāhehau, nau nenauchauwahathee hauunaugāe henee hejejenanauwunaudenenau; dauhudauchu naudnauāchauhaunauau nananena hadāeyaunewauau hauānee waude neauthuneahee dauānaude henesaunau hethauvaa hethaenaa, hau hāhauwuvathehāva. ");
INSERT INTO arp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Naune haudauauwunenau, naunaudauwunana hadnadauyewu: nau hethauwuu nāedauwunathana, Nananena hadnehauwunauhauwuva haunaude nauauchaugu hadneenehena, Hauwunaunaa henee jaunaude heee heneseedaunene Vahadāhenith. ");
INSERT INTO arp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nau hethauwuu, daujedāde hedauauwunene hanesāhenith najane Nesethajauhuhau hadvethee jauaujau vadanesee, henee haeaunauyauhauvaa. ");
INSERT INTO arp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nau, naune, hena jasaa henane hathaāhede haenenesaunenauau. ");
INSERT INTO arp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nau Hejavaneauthusau haeauchuhananadetha nanavaavehehau nau Nesethajauhuhau, gaujenanavanau henayauthaude vadanesee? hāthauhuk. ");
INSERT INTO arp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nau haedādaunaugunauau. Nau hanaāedanaunith nau haeenayauha, nau haejenana; ");
INSERT INTO arp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nau haeauchuhananadetha, Hanaa hedauneau naugauchaudahehau wauāth waugaje janesenayaugaune hadaudaunaudenee, nau gauchauchaunu gauhadnauuguthauva vadanesee? hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nau haeeyauhuune nesenehethauthee jea nuu hayauhuhau. ");
INSERT INTO arp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nau haedadajenehetha henee hathāadethavathee, hāenauhauwaude hasayāchauhauwunethe najatheaugudaunau; hanaāāedauwunaude, ");
INSERT INTO arp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Hāene nananena hadethaunā henanenauau gauwuhaudeneagu, jevajanauguu najatheaugudaunaa; havajavaānethā henane havajavaāheva henee hadethade; ");
INSERT INTO arp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nau henee hadethāde nau nananede hadjaude nau hadnethāne, Venene naa henane hadehedaugu; nau nananene haddayāhene janaugunenagu hesaudavaa. ");
INSERT INTO arp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hau hāene nananene hadethanenagu, haddeyehau nau hadjanaugu hesaudavaa henee hāene hadethāde hadjaude, hadethāne, Va javesa; hadnaāene nananene vechauthānaune henee hanethevethehevādaunauau. ");
INSERT INTO arp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hanau daun nanajathajaude nehayau hadnausādauaude; nau henee nausādauauadede nehayau hadnajanede. ");
INSERT INTO arp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hanaāenehethaude jea henee hadethādaune, Hāene nananene gauusevanenagu wauāthe hethunevethehevanenagu, jevaadesene hādaehauhauau, wauāthe hāthesaunauau, daudause hādauānauau, wauāthe nethauyādahagu hanedaudewau; havaadethaa jea, nau havaaunaudaunā. ");
INSERT INTO arp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hau hāene nananene vethehevanenagu, hadadethaunauau hadavenuhuhauau, henesenehehauau, jeneejavesahehauau, nanenauguhuhauau; ");
INSERT INTO arp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nau nananene hadnauwunaunane; hanau daujeneaunaudaunānaune: hanau nananene hadnaunaudaunane jaegauhadeneagu hathāethadee. ");
INSERT INTO arp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hāene hanesāde henee henethevethehevādaune daunedauwaudauwunith nuu hayauhuhau, Hauwunaunade henee hadvethee jauaujau henajanedaunene Hejavaneauthu, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hanaāāedauwunaude, jasaa henane haeavathethunevetheheva, nau haeauwauhadethānanena; ");
INSERT INTO arp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nau haejenana hewauwaune dauethunevethehedaunee hadnāedauwunaunith henee hadethavathe, Jenajesaa; vahee hayauhuhau wauwu hanesejenanee. ");
INSERT INTO arp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nau vahee haenesadene hathauchuwuhadethee hadnudanathee. Nanedauwauaude hasenehethauhuk, Neaudaunaudauwau vedauauwuu, nau hadneyehaunau nau hadnauhaudauwau: Nehethathane hadnudanene. ");
INSERT INTO arp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nau jasaa ahagu, Neaudaunauthu yauthauyauna hedauhuwaugaje, nau hadneyehaunau hadnayāduuhuu: nenehethathane hadnudanene. ");
INSERT INTO arp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nau jasaa hahagu, hedauwunenenau, nau naajeneejaunau. ");
INSERT INTO arp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hanaāejenauusade henee wauwau, nau hanaāenauhauthehaude hadāhewaunādaune nuu hayauhuhau. Wauhā hechauhauthethāhe hauauwuu hanaāasenaunade hanaāāedauwunaude hewauwaune, Yegauhu nauhauhaunee hadaugauchaudāe nau hadaugauchauchanee hedane, nau hadjāthaunauau hede hathāadavenuhunethee, nau henesenehehauau, nau jeneejavesahehauau, nau nanenauguhuhauau. ");
INSERT INTO arp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nau wauwau hasenehethauhuk, Vahadāhene, naasedaunau hasenehesene nau nausunauthauyauau, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nau Vahadāhede haeāedauwuna wauwaune, Yehau hathenavaunaa nau nethauchayaunaa nau hadjādasauaunaunauau hadejejedāthee, henee naudauauwuu hadeechauchaunaa. ");
INSERT INTO arp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hanau nāedauwunathane, henee hegau hena henanenauau neadethathee hadnehauwuvajadauwu nadethunevethehewau. ");
INSERT INTO arp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nau hena haenethaunau havathenanedanede: nau hanaāejaaagude, nau hanaāāedauwunaude, ");
INSERT INTO arp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Hith daun henane hedasānaugu, hau jasānauwauhuk henesaunaune, nau henaune, nau henene, nau dāeyaunauau, nau henethesaunau, nau hedasāwau, haa nau nehayau hedenaedede jea, nāhauwuneethauguhaa. ");
INSERT INTO arp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nau daun janenevaa henaugauchu, nau thauguhānaugu, nāhauwuneethauguhaa. ");
INSERT INTO arp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hanaa nananena vanadaunesedede hayauauwun gauhadjejanaugu nedauau hadnayādede hadauchuunee, wauau hanaadauchanenee hesehenee? ");
INSERT INTO arp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Havaene hesejenanauhuk hauunauganau, nau hanājeneesedede, vahee henee hathāenauhaudauau hadneevavavayaudenenee. ");
INSERT INTO arp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Naa henane nenesedede, hau hajeneesedede, hanāthāde. ");
INSERT INTO arp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wauāthe daun naja, vadauvauthauhuk jachau najane, hanājanaugude nedauau, nau hanāgaugauanadauau wauau haneene nauguu vadadauchu vasevadadausauau hadnenuchaunaude henee hejevenahedaunau nauguu nesauau vasevadadausauau? ");
INSERT INTO arp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wauāthe, hajesenausujechaugunethe, hanāyethautheavede, nau hanānayāthenedauāwaunaude. ");
INSERT INTO arp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nau naasauau, daun nananena henee janenaunaudauau vahee henetheyaunau, nāhauwuneethauguhaa. ");
INSERT INTO arp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nejauauwuu hethadee: hau hith nejauauwuu jevanujaudāgu, hayew hadneenejauauwujauau? ");
INSERT INTO arp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Daudause hehauwuuthade vedauauwuu, wauāthe heee vehethe; hau henanenauau hanāneāgudede. Daun henaudaununede heenedauvahek jaathedeha. ");
INSERT INTO arp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hanaāeauchaunāde vahee hauāyāhehau nau wauwauchudauhuhau heee hadjaathehāde. ");
INSERT INTO arp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nau Nesethajauhuhau nau Wauthaunauhāhehau haeneneedenenau, Naa henane hanesedanaude wauwauchudauhuhau, nau nanethevethehewaude, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nau haeauthaunanadetha, hasenehethauhuk, ");
INSERT INTO arp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Hanaa henane nananena hedauneede vadadausauau jauaunawaudā, hith hanauhauhuk hanesahenith, gauhadnautha theaudausauau nau theaudauchunee nauaunee, nau gauhadnaudeha henee naunethauaunith gauhaunaude hadveeha? ");
INSERT INTO arp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nau hāeveehauthe hadthāegauhaude hejaanaunaa, hadneneethajaude. ");
INSERT INTO arp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nau hāenauajegauhuthe, hadnadethaude hauānee henedaehauhau nau henedaudevādaunau, netheneethajaudauwunee hanau daujaveehauau naudauāve nenaunethauaude, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nananenau hāedauwunathana, nuu hadnaasauau neethajaude hayāene hāene hanesāde wauwauchuduhu haunaunevethajauhuk javaānee theaudausauau nau theaudauchunee hathauwunane janenethenauau haunevethajaude. ");
INSERT INTO arp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Daudause daun hesā nethenauaugu vadadauchu gauneevāejethā, hith hanadehuk hanesadenee gauneee, gauhadjedeauchauau nauauuthayau, nau gauhadwaudeau hauauwuu, nau gauhadvavesenaudene haunaude gauhadveede. ");
INSERT INTO arp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nau daun hāeveenuu hanadethaude henedaehauhau, nau henedaudevādaunau hauānee netheneethajauwuu, hanau daujaeveenauwau hanesadee nāanathau, hanāthaude. ");
INSERT INTO arp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Naasauau, Nananenau nāedauwunathana, haneduu neethajaude hathaāhethee hautheaunauau Hejavaneauthuu hanesāde wauwauchuduhu haunaunevethajauhuk. ");
INSERT INTO arp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nau hasenehehuk, jasaa henane neseyaugaune heauhau: ");
INSERT INTO arp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nau hajauchaugade haenehetha henesaunaune, Nāchau jevene gauuu vatheyaunau henee nāudnedadahedaunau. Nau hanaāgauuvenaude hethāenetheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nau haunauauhaejewauthanenau hese hajauchaugade hāesauānauau vahee hauānee, nauhanaāejathāaude hesee vavāaune vedauauwuu, nau hena hanaāevadauthedede hethāenetheyaunau heee hauhaugānenaedede. ");
INSERT INTO arp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nau hāevathedede vahee, hena haanaāenauauchauau naunauthauau hasenaude hena vedauauwuu; nau hanaāadavenuhunede. ");
INSERT INTO arp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nau hanaāeyehaude nau hanaāewauhaunesade nehayau hauwauhauauwunanenau henee vedauauwuu; nau haejenanaa hethauauwuu hadnauchauwaude neauthuwauchu. ");
INSERT INTO arp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nau hanāneanadauau hanāchauchaunaudede henaude heee jeyauwaunau henee neauthuwauchu hevethedaunenenau: hau hegau henanene hevenaa. ");
INSERT INTO arp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nau hāaenaudede hanaāenehede, Waunauthanethe hedautheaunau nāsaunau nenethenauau jauaujaunau naenedauchanenee nau nejeesesanenee, hau hadnenadaugauyānau? ");
INSERT INTO arp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hadgauhānau nau hadeyehaunau nāsaunau, nau hadnaasenehethauau, Nāchau, nananenau nanethenauwau wauchudaude hesee hayāene, nau yesee nananene, ");
INSERT INTO arp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nau nananenau hegau heee hāhauwautheāve: jenesehe waude haudautheaunauau. ");
INSERT INTO arp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nau hanaāegauhāde, nau hanaāedauchaude henesaunaune. Hau hajesejedauchaude, henesaunaune haenauhauvaa, nau haeauwunaunaa, nau haeyeseneegau, nau haeanaethesaunaunagutha, nau haenenedana. ");
INSERT INTO arp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nau heau hathāhuk, Nāchau, nananenau nanethenauwau wauchudaude yesee hayāene, nau nananene, nau nananenau hegau hāhauwautheneeāve. ");
INSERT INTO arp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hau henesaunaune hathauyaugaune hedautheaunene, Jādee chaunauguuthadee hu, nau hauyauunaa; nau thānauwunaa nechaunathathau hejadenaa, nau jedauaunenaa: ");
INSERT INTO arp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nau hadjāthauva hede daun gauchujāde wauuu, nau hadnauauva; nau hadvethehenauau, nau hadeaunauwuthajaunauau: ");
INSERT INTO arp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hanau naa nāa nenajaa, nau jaenaedede; nenaunethauaude, nau jaeveenade; nau hanaāejasesaunauwuthajauthee: ");
INSERT INTO arp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wauhā vanachauganith heau haeanedaune nauau: nau daunausujaude nau hāayānauusade hedauauwunenau, haenedauwaude haenevaudenene nau haevadaudenene. ");
INSERT INTO arp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nau haeadetha hanesānith haunauaheau, nau haenaudedauna dusedaudene hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nau haeāedauwunaa, Nananene hahavaa nauusade; nau nananene hāsaunau naunauaude gauchujānith wauuau, hanau daujaesedanaude nanethauaunee. ");
INSERT INTO arp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nau haeasenauna, nau haejejedā: hanaāejenauahenith henesaunaune, nau haedadadasevaa. ");
INSERT INTO arp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nau haeauchuhananadetha henesaunaune, Naune, nuu hawauthāe jajenee hāenesedaunathadenau, daudause hāhauwujethauwaudaunathe hanāene hanathauchuwuhunaune: hau haunauau nananene hāhauwuthauuvene haudāsau, henee hanānesedenau haunauwuthajaude nauguu nādaehauhauau: ");
INSERT INTO arp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hau chauchaunu hasenauusade naa hāa, hāgaujauauthedaunādaunau hāheenaededaunau heee henesahehau hesānau, nananene hanadaunaude gauchujānith wauuau. ");
INSERT INTO arp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nau hanaāāedauwunaude, nā, nananene nanethenaedevene, nau vahee henee nāthāenetheyaunau nanehanāhene. ");
INSERT INTO arp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dauudasadee henee haneenesehee haunauwuthajaude, nau hadneethajaunee: heee naa hahavaa denajaa, nau jaenaedede; nau denaunethauaude, nau jaeveenade. ");
INSERT INTO arp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nau hanaāāedauwunaude jea hethauguhādaunau, hena jasaa haenethauyādā henane, haenethena hadāhevahew; nau haenanene haeauthauwuvaa henee daunethauyādauchudede hevatheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nau haeadetha, nau hanaāenaudedaunaude, Duthanee henee daunedaunathane nananene? nayāde hāadāhevadenau hanau nananene hadnehauwuguthadāheva. ");
INSERT INTO arp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hadāhevāhe, Hewauau hauaudnesedaunaune? hasethaujauhuk, hanau navahadāhewaunāde haedanauwunānau nadadāhewau: hajeneenauchauhānau; thaununedauwauhunenau. ");
INSERT INTO arp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Haenauwau hadnesedaunau, henee hāenudanānaune hadāhewaude hadjedanethee hedauauwunenau. ");
INSERT INTO arp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hanaāadethaude haunauude hadāhewaunādaune hethāesayānedanauwunādaunene, nau hanaāāedauwunaude nanedauwauaunith, Dauhudauchanau hasayānedanauwunaudenau nananene nadāhewaunāde? ");
INSERT INTO arp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nau hāheyaugaune vadadausauau dejenauhuu javeda. Nau hanaāāedauwunaude Hedanau hauwauthaunauha, nau janaugu nauhauhaunee, nau hadwauthaunau yauthauyauau. ");
INSERT INTO arp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hanaāāedauwunaude jachau, nau dauhudauchanau hasayānedayaunau nananene? Nau hanaāāedauwunāde, Vadadausauau dejenauhunee thauauhanewauchuunau. Nau hanaāāedauwunaude, Hedanau hauwauthaunauha, nau hadwauthaunau nasaudausauau. ");
INSERT INTO arp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nau vahadāde haevaveenethedauna janechuvāhenith hadāhevahew, hanau dauhaenauau hasedaude: hanau dāeyaunauauau nuu hathāauauvaa hedenaededaunenau hāenuu javaānee hesenedāeyaunauauau. ");
INSERT INTO arp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nau nananenau hāedauwunathana nesedee nehayau henedaehāvadede heee nethauyādahede hehauwuthade; henee hāejenenaedenā hadeesedanāna nedaujethauujenenaededaunenee. ");
INSERT INTO arp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Henane henee chaunuvāde heee haugajuhuyāgu haneechuvāde jea vasee: nau henane henee janechuvāde vanehaa hehauwuuchuvā jea vanasaunee. ");
INSERT INTO arp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hith naaheene nananena jechuvahena hāhauwuuthaheva nethauyādahede hanaa hadvenāde nananene hadanethaude hethauwuu veaunauaude? ");
INSERT INTO arp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nau hith nananena hejechuvahenagu heee henehanahede jasaa henane hanaa hadvenāde nananena henee hanehanahede. ");
INSERT INTO arp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hegau nesethāhe hehauwuneenesedauna hanesenethe hechauhauthethāhehau: jachau hanāasānauwaude hanesāhenith, nau hanāvechauthaude jachau; wauāthe hanādudevede hanesānith, nau hanāthauchaunauhauwaude jachau. Nananena hāhauwuneenesedaunauva Hejavaneauthau nau nethauyādahehehauau. ");
INSERT INTO arp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nau Nesethajauhuhauau jea, haeveenauwu vāejethā, haenedauwaudauwu vahee nuu hayauhuhau: nau haeauchaudanavanauau. ");
INSERT INTO arp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nau hanaāāedauwunaude nananena nethadee hasehadenā hathaāhethee henanenauau; hau Hejavaneauthau naenauau hadahenau: hanau henee nechauguanavadethee henanedaa newauchanavathee hathaāhenethe Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nanavaavedaunau nau haeyāhehauau haunaude nauuu Jaun: heee hena henajanede Hejavaneauthau deheauthedaunee, nau haunauude henanenauau neheeneethenadethee. ");
INSERT INTO arp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nau hehauwunauthau hejavaa nau vedauauwuu heyauhuāgaune javaānee hanesadee haugajuhuu nanavaavede hadneeyauhuu. ");
INSERT INTO arp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Daun hausānaude henene, nau heneyaugu gauchuhunee, wauchudaudehaugauthenenede: nau daun hausāyaune nanewaude wauchudaude. ");
INSERT INTO arp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hena jasaa nethauyāsenane, haeneenu haevejayaunenau nau haegaugunesaunenau, nau haeneechauna hadauchusenenee: ");
INSERT INTO arp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nau hena jasaa nedauwuhu Lazarus haseagu, haesaese hedajanaunaa haevahaseva, ");
INSERT INTO arp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Haevadauugaudaude heee jeyauwaunau nejanesanenee hehethee nethauyāsenanene hevethehedaunene: jea hathave haeedasaa nau haenenesaudauwu hedasewaunau. ");
INSERT INTO arp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nau hethauwuu, henee nedauwuhu haenaja, nau haenauaunechauhaa hautheaunau yesee Abraham haenedauguva: nethauyāsenane jea haenaje, nau haejenanau; ");
INSERT INTO arp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nau hadauveeyaunee haeejenāauguau, haeaudauwuthajau, nau haenauhauva Abraham vavāaune, nau Lazarus haenedauguvane. ");
INSERT INTO arp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nau haeneduva nau hathauhuk, Nāchau Abraham, jeauwunaune, nau jeautheavene Lazarus, henee hadejegunauhade naunauchuu hejadenaa najee, nau hadedauyauvanauau nāthaune; hanau nananenau hanavachuunau nuu hesedaa. ");
INSERT INTO arp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hau Abraham hahagu, Nā, hāenau henee nananene deenaedene neesedanauwu neethadee hayauhuhau, nau neesaunee Lazarus neewausaunee hayauhuhau, hau hewaunehaa hauwauthenaedede, hau nananene naunauchauthenaedene. ");
INSERT INTO arp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nau jea vahee nuu, nahethāe nananee nau nananene haneduu vanasauau vanethaunauau janenanee: hadnejeneehedechaudenee hehethee hede hesee nananene hehauwuneau; daudause hehauwuneejeauchusanauau hadaunee, henee nevadaujauthee hehethee hethaa. ");
INSERT INTO arp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hanaāenehethaude, Vanevethedaunathane hena heee, Nāchau, henee nananene hadejejenanaude nāsaunau hedauauwuu: ");
INSERT INTO arp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Hanau yaunauthaunethee nauhauwauauau henee hadeāedauwunaude, jea havajaunenau nuu haduu naunauchauthauau. ");
INSERT INTO arp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham hanaāāedauwunaude nanethenauthee Mosaseau nau haeyāhehau; jaathehaunauha. ");
INSERT INTO arp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nau, hegau, nāchau Abraham: hau hith hanesāde jaeyehauhuk hehethee degaujauaudāde, haunaunaunevethajauthee, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nau hanaāāedauwunāde, Hith jenedaunauhaugaunee Mosaseau nau haeyāhehau, daudause hāhauwuneenadauwaunauau, daudause hanesāhenethe jaegauhāyaugaune hehethee degaujauaudāhenith. ");
INSERT INTO arp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Hanaāāedauwunaude hethauguhādaunau, Hāhauwuneene hau henee dauusenadenau hadnauauchuu: hau naunauthauau hadnauauchaudaude daunjaunaude. ");
INSERT INTO arp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hanāneene henee thauayānauunaugane henauānauyaugu, nau seāguthadagu hadaje, hauhanāheejegaudauvāhenethe henee haneedauusenanethe jachau nuu hajasedāeyaunauau. ");
INSERT INTO arp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Haunauyauhaudauwauau nehayau nananena: Hith hahavaenau havawauchuhāva, hadanadethauva; nau hith haunaunevethajauhuk, hadjaegudanauwunauva. ");
INSERT INTO arp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nau hith wauwauchuhānagu nesaudauchu hajesesenenee, nau nesaudauchu hajesesenenee naujaeyethaagudaunānagu, haunaunaunevethajaunau, hethānagu: nananena hadjaegudanauwunauva. ");
INSERT INTO arp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nau vadauhanauau, Vahadāhene, hethedaunanauwunāa hedethauwaudaudenede, hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nau Vahadāhenith hathāhaugaunee, Hith nananena hethauwaudauwunagu hethāee hethāuu mausdaude jenayaunau, nananena hanāna nuu segaumau hunauhaudene, Hanāgauchauhana hethājee, nau hanājenanauna hadajee; nau hanāthauwaudaunāna. ");
INSERT INTO arp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hau hanaa nananena, hanāwauwaunavede hanāthauauauwujethānith wauāthe hananajauānith, hanāthauna waunee hāenauusathe hehethee nauau, Najese nau hadjanaugu nau hadvethe? ");
INSERT INTO arp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hau hanājenaasenehethauna, Hesetheva nayaudenee hadnevethehenau, nau duujehe nehayau, nau hadjeenechaudaune haunaude hesevethehenaugu nau hesaveyānaugu; nau heauhauwune jenaevethehene nau hadevaveyā? ");
INSERT INTO arp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Gauhadvaveene henee wauwau hanau dauhunaasedaude henee hanasenehethāthe? Haunauchāe hegau. ");
INSERT INTO arp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Naathahena, hāene nananena vahesedaunagu hena hayauhuhau hathauchuwuhana, Hāhauwuneejavaājasethānau wauwaunauau; vavade nanesedaunauau hadnesedaunuu, hadeva. ");
INSERT INTO arp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nau hethauwuu, daunausuyehaude Dādaunedan, haeehedesa nahethāe Samaria nau Gananee. ");
INSERT INTO arp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nau hāewaudasade jasaa hauauwudan, haenuchaunaa vadadauchu henanenau haenaujaune hedaugauwudaunenau, haetheaugunenau vavāaune: ");
INSERT INTO arp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nau haeneduvanauau, nau hanaāenehethauthee, Hejavaneauthusau, Hecauhauthethāhe, jeauwunauāa. ");
INSERT INTO arp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nau hāenauhauwaude hanaāāedauwunaude, Waunenauhauthehaa hadanayaunenau vevethahevahehauau. Nau hethauwuu, henee daunausuyehauthee, haejegaudauvāhenauau. ");
INSERT INTO arp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nau hanesāde, hāenauhaudauau henee dauunayauhade, haejaaagu, nau haevasenehe dauvaveenethedaunaude Hejavaneauthu, ");
INSERT INTO arp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nau haeuāneseve heauthene, haevaveenethedauna: nau haenaadāde Samaritan. ");
INSERT INTO arp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nau Hejavaneauthusaun haeauchuhananadethā, gaujenayauhaunauau vadadauchu? hau daude theaudauchu? ");
INSERT INTO arp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hajenauhauvathee hajejaeyehauthee hadvaveenethedaunauthee Hejavaneauthu, vavade naa henewauuhu. ");
INSERT INTO arp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nau haeāedauwuna, Gauhā, najesa: nananene hadethauwaudaude henayauhāne. ");
INSERT INTO arp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nau hāenaudedaunāde Nesethajauhuhau, daun henajanedaunene Hejavaneauthu hadneenauauchaunee, Haeāedauwuna, Henajanede Hejavaneauthau hadnehauwunauauchaune nausujauwuwuhadagu: ");
INSERT INTO arp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Daudause hehedauneagu, Nauhaudauwuu hede, wauāthe, nauhaudauwuu hena, hanau, naune, henajanede Hejavaneauthau thanāsadena, ");
INSERT INTO arp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nau hanaāāedauwunaude hethauguhādaunau, Hese hadnauauchuu, hāene nananena vadaunauhaudauwunā jasae hese Heau henane, nau hadnehauwunauhaudava. ");
INSERT INTO arp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nau hadnanethāna, Nauhaudau hede; wauāthe nauhaudau hena; jevayehauau, wauāthe jevathauguhaa, ");
INSERT INTO arp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Waude hasauau jahagude, henee naunauasānauuu hehethee naugauthanee naugauauwuu hejavaa neenauasādaa jasaa naugauthanee naugauauwuu hejavaa; hadnaasauau jea Heau henane hadnaasaunee hedeseve. ");
INSERT INTO arp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Hau nedauau hadnanasenedauau wauthanee, nau hadnausāguthade nuu henaedede. ");
INSERT INTO arp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nau waudeneesaunee deenaedede Noe, hadnaasaunee jea hedeseve Heau henane. ");
INSERT INTO arp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Neauwauthevethehedaune, neauwauthevaveyaudenee, neauwauthenenedaunee, neenenehathee, haunaude nauuu henee Noe dejedāde havathee thewaunaa, nau haenaāenanadauwuauau, nau haenauauhā vahee. ");
INSERT INTO arp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Waudenaasauau jea deenaedede Lot; neauwauthevethehedaunee, neauwauthevaveyaudenee, neauwauthaudaunaudenee, neheaudaunaudenee hayauhuhau, neauwauthejenayaudenee, neauauvadenee; ");
INSERT INTO arp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hau hajesesenenee henee Lot haenaude Sodom haeesedanausaude nau haegauhauchanauauhauunauganauau hehethee hejavaa, nau haenauauhā vahee. ");
INSERT INTO arp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hadnaasauau hesee hāene Heau henane hāenauhauthethāthe. ");
INSERT INTO arp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Henee hesee, hāanedauthe dasee hauauwuu, nau hevatheyaunau jedauwuu hauauwuu, nanehajejeauwusade hadejedanauau: nau henee hanedaude nauau, nanehajejejaejaude. ");
INSERT INTO arp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dauyuuwuu Lot henene. ");
INSERT INTO arp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Daun vanadauunayaudede hedenaedede hadnanadede; nau daun hadnanadede hedenaedede hadnenayaudede. ");
INSERT INTO arp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nananenau nāedauwunathana, henee veeyaugu hadnesethee henanenauau hanesadenee hauau; hanesāde hadnedanade, nau jasaa hadnathauaude, ");
INSERT INTO arp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hanesethee hesānauau hadthauayāthee wauhaunee; hanesāde hadnedanade, nau jasaa hadnathauaude. ");
INSERT INTO arp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hanesethee henanenauau hadnanedauthee nauau; hanesāde hadnedanade nau jasaa hadnathauaude. ");
INSERT INTO arp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nau haeauchuhananadethanauau, Daude, Vahadāhene? Nau haeāedauwunā haduu vadanayau, hanaadauhauāneauhuthee neahehauau hauānee. ");
INSERT INTO arp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nau haeanadetha hauthaunauhānee nuu heee, hena henane hāvachudajauaunevevetha, nau hājethauujesevenauau; ");
INSERT INTO arp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hahagu haeanedau hedan hauchuwunane, haeejesa Hejavaneauthu, daudause hathauwunanenau: ");
INSERT INTO arp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nau haeanedau henevesā hena hedan; nau haejeedasa, Jeaugaunayewhu naujauthavaa, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nau haejevadaunaasedau: hau waunee hasethajauhuk, hewauāthe nejechauau Hejavaneauthau, nau hathauwunanenau; ");
INSERT INTO arp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hau nausunee hanau naa henevesā hajanauchuhānau, hadenayauhauau havaedajauaunejau navanadauchuhaa. ");
INSERT INTO arp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nau Vahadāde hasenehehuk, Jaathehaa hasenehede janechuvāhede hauchuwunane. ");
INSERT INTO arp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nau gauhujavaneauthau gauhadnenayauha nehayau hanayāsanaunau, hauwauaudaunādaunau hesee nau dajāee, hau negudauchuhaude? ");
INSERT INTO arp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nananenau nananena nāedauwunathana henee hadnauchuhanenayauhaude, Hau hāejauthe Heau henane, gauhadveede hethauwaudaude nuu hathāauauvaa. ");
INSERT INTO arp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nau haeauthaunanadetha jachau nethauwaudaunadenethe nehayau henee dauchuvahethee, nau newauchānauwauthee hauthauau: ");
INSERT INTO arp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Hanesethee henanenauau haeyehaunauau vevethahenauauwuu hadvevethahethee; hanesāde Nesethajuhu, nau jasaa hauāyāhe. ");
INSERT INTO arp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nesethajuhu haetheaugu nau haevevetha waude heee nehayau, Hejavaneauthau, nananenau vaveenethedaunathane, henee nāhauwunaathā hauthauau henanenauau hathahethee, hedanauwuyāhehauau, janechuvahethee, jatheaudauwuyāhehauau, daudause naa hathāde hauāyāhe. ");
INSERT INTO arp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nananenau nenaugauyānau nese hanesadee hauchauvadede, Nevānau vadadauchu vahee henee nāthāenetheyaunau. ");
INSERT INTO arp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nau hauāyāhe haetheaugu vavāaune, daudause haejejenāauguau hejavaa, hau haeanadesejāhede, Hejavaneauthau jeauwunaune wauchudaunau, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nananenau nāedauwunathana, naa henane haejaeyehau hedauauwuu haeauwunaunau haejavaāhe jachau: hanau dathājee hanesāde henee nevadaujavaānajanethee nehayau hadnauwujenanade; nau henee nenehanethaunadede hadnejanade. ");
INSERT INTO arp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nau haejādaunanauau jea hajasedāeyaunauau, hadnevasanaude; hau hāenauhaudauwunethe hethauguhādaunau, haeneneuvanauau. ");
INSERT INTO arp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hau Hejavaneauthusau haeadetha, nau hahagu, Nanehajauthee hajasedāeyaunauauau, nau jevadauduvaa: naathāhenethe henehanahedaunau henajanede Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Hethauwuu nāedauwunathana, Daun hadjesedanauau henajanedaunene Hejavaneauthu hasenaedenethe hajasedāeyaunauau hadnehauwuneejedā. ");
INSERT INTO arp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nau jachau hauchuwunanene haenaudedaunaa, Hethāhene Hechauhauthethāhe, nauddusedau hadnedanauwau jethauujenenaedede? hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nau Hejavaneauthsaun haeāedauwunaa, Naudu hethāde haesene? henaneda hehauwuthā, vavade hanesāde, nananede, Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nananene haenauwu nanavaavedaunau, Jevawauchudauau heee haugauthenenede, Jevanaa, Jevaaveda, Jevajayaudauwāedauwauthadee, Vechauchune nananene hāsaunau nau hānau. ");
INSERT INTO arp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nau hanaāenehede, Vahee nuu haunaunedenau heee daujeeseaunau. ");
INSERT INTO arp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wauhā Hejavaneauthusau hāenedauwaudauau nuu, Hanaāāedauwunaude, Hanesadee hāhauwusenethene: Vaheaudauna henee hāthāenetheyaunau, nau hadjaanauwunaunauau hadavenuhuhauau, nau nananene hadnethenauwu haenathau hejavaa, nau hadejau hadjethaugu. ");
INSERT INTO arp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nau hāenedauwaudauau nuu, haeaudauwuthajau: hanau deethauwunethauyā dāde. ");
INSERT INTO arp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nau Hejavaneauthausaun hāenauhaudauwunith henee dauaudauwuthajaude, Duthāenanauthaune henee nanethenuu veaunauaude hadnesejedāthee henajanedaunene Hejavaneauthu, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hanau hehauwujajathaune heee camel hehedesahagaunee hajasevāhau nedaudaunaudenee, javaāneenauthaunee nethauyāsenane hadnesejedāde henajanedaunene Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nau hathāenedauwauduu, Hanaa hadnenanedanede? hahagaunee. ");
INSERT INTO arp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nau hanaāenehenith, hayauhuhau hejethauuneethaunenau henanenauau neneedede Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hanaāenehede Peda, Naune, naunaudauwunauau vahee, nau thaunauguhane. ");
INSERT INTO arp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nau haeāedauwuna, Hethauwuu nāedauwunathana, hena haunauude henane henee hehauwunaude hedauauwuu, wauāthe henehā, wauāthe henauhauwauau, wauāthe henene wauāthe henesaunau, heee henajanedaunene Hejavaneauthu hedenaededaunene, ");
INSERT INTO arp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nananede hadjavaānesedanauau nuu hewaunehaa, nau hathāauauvaa hadnauusanauau henaedede hadnejethauuvadauauau. ");
INSERT INTO arp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hanaāedanaude nesenee, nau hanaāāedauwunaude, Naune, hadneyehaunauau Dādaunedan, nau vahee hayauhuhau hathāewauthaunauhuu haeyāhehauau heee Heau henane hethauwunauauchauau. ");
INSERT INTO arp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hanau hadvenavathe Neauthu, nau hadvavavanauchuhāde, nau hadnaunaunauchaudauchuhāde, nau hadneguthahayauthāde. ");
INSERT INTO arp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nau hadnenesegauhude, nau hadnaāde: nau nasese hadnaāejaegauhāde. ");
INSERT INTO arp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nau haejaenauwu nuu: nau nuu hauthedau haeyaudaunaunauau, daudause haejaenauwu hathauthedaunāthee. ");
INSERT INTO arp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nau hethauwuu, hāayāedadauau Jericho, jasaa haenanenaugu henane haetheaugu nedechaudenenee dauhunedauwaude: ");
INSERT INTO arp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nau haenedauwaude henanedanede dadavechaudenenee, haenaudedauva haesedaudenenee. ");
INSERT INTO arp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nau haeaāedauwunau, henee Jesus Nazareth hanehedesade. ");
INSERT INTO arp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nau hanaāevasanadede, Hejavaneauthusau, nananene Heau David, jeauwunaune, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nau henee nanedauvathee haeneneuvanauau haddādaunaugunith: hau haevasanade haugauthe, Nananene Heau David, jeauwunaune. ");
INSERT INTO arp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nau Hejavaneauthusau haedauusa, nau haeautheave hadjādaunade: nau hāayājenauusanith, haenaudedauna, ");
INSERT INTO arp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Hauddusehathe henee hadenaasehathane? hathauhuk. Nau hanaāāedauwunaude, Vahadāhene, nanaa hadeesedanauwau nauhaudauwaude. ");
INSERT INTO arp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nau Hejavaneauthusau haenehetha, hanesedanauwu nananene nauhaudauwaude: hadethauwaudaude henayauhāne. ");
INSERT INTO arp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nau chauchaunu haeesedane henauhaudauwaude, nau haethauguha, haevaveenethedauna Hejavaneauthu: nau vahee henanedanede, hāenauhauduu, haevaveenethedaunanauau Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nau Hejavaneauthusau haewaudasa nau haechaugusa Jericho. ");
INSERT INTO arp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nau, naune, haeanedau henane Zacchaeus haseagu, haenajawauna hauāyāhehau, nau haeveaunauau. ");
INSERT INTO arp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nau haeneenavadaunauhauva Hejavaneauthusaun haedāhenethe; nau haejeneene daunauthethenadedaunenee, heee daujaahede. ");
INSERT INTO arp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nau haesayāgau, nau haenauauhu sycomore hunauhaudee hadnauhauwaude: hanau hadnehedesanith. ");
INSERT INTO arp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nau Hejavaneauthusau hāejeedadauau, haeejaāne, nau haenauhauva, nau hathauhuk, Zacchaeus, nauhauhuhu, nau jeauwusa, hanau nuu desenee hadnanedaunau haudauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nau haenauhauhu, nau haejeauwusa, nau haeedasa nauguu neethajaude. ");
INSERT INTO arp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nau hāenauhauvāhede, vahee haeneānaune, Henee hadneejādavenethe henanene henee wauwauchudauhu, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nau Zacchaeus haetheaugu, nau haeāedauwuna Vahadāhenith; Naune, Vahadāhene, vayaugauuu naudaununaunau vanenu hadavenuhuhanau; nau hith hedanavanaugu hayewhu hehethee daun henane hanājayaudauvāedauwauthauau, hanājavaāvenauau yāyaunanee. ");
INSERT INTO arp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nau Hejavaneauthusaun haeāedauwunaa, Nuu desenee henayauthāhe hedadauau nuu hauauwuu, hanau nechau haneāvāde Abrahamvene. ");
INSERT INTO arp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hanau Heau henane nauusade hadnaudethāde nau hadnenayauhaude daun naunethauaunith. ");
INSERT INTO arp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nau hajesenedauwauduu nuu hayauhuhau, haeethedaunane nau haeauthaunauhānanadetha, hanau dauhuauchauau wauwu Dādaunedan, nau hanau daunauanaduu henee henajanedaunene Hejavaneauthu chauchaunu wauauhaadenauhauwu. ");
INSERT INTO arp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hanaāenehede henaheee, Jasaa naja haeehau vavāaune vedauauwuu hadnesedanauau heee nehayau najanede, nau hadjaejaude. ");
INSERT INTO arp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nau haeadetha vadadauchu hewauwaunauwau, nau haejaanauwuna vadadausauna vāejethā, nau haeāedauwuna, Hadeaudaunava haunaude jaenauusanaugu. ");
INSERT INTO arp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hau hauauwunanenau haeasānavaa, nau haeyethautheavedaunene thauguu, Nāhauwuvadaunethenauva naa henane nāhauwuvadaunajawaunāva, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nau hethauwuu, henee hāejaenauusade, haeesedane najanede, hanaāauchuwuhaude nuu wauwaunau hadnadethaude, hevenaunau vāejethā, henee hadnaenauau haedauchu dathājee henane haedauchujavaājasedethe heee hedaudaunaunau. ");
INSERT INTO arp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hanaāejenauusade nanedauvade, Vahadāhene, havāejethāwau javaājasedede vadadausauna vāejethā, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nau hanaāāedauwunaude, Hethadee, nananene hethāhene wauwau; hanau nananene nethauwaudauwu heee naugajuhuhuu hadnajawaudauwu vadadausauna hedan. ");
INSERT INTO arp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nau naneseauwaude haejenauusa, Vahadāhene, havāejethāwau javaājasedethee yauthauyauna vāejethā, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nau vavade hanaasenehethaude, Hadnehanāhene yauthauyauna hedan jea. ");
INSERT INTO arp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nau jasaa haejenauusa, Vahadāhene, Naune, heyewnau havāejethāwau, neaunaunedenau nejenanauwau hāheāhaunaa, hathāhuk: ");
INSERT INTO arp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Heee dauhusathane, hanau nananene daugaugaunauauwunanenene: nananene hedanau henee hājejenayaunau, nau hadegauuchu henee hājejenayaunau. ");
INSERT INTO arp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nau haeāedauwuna, hehethee nehayau hadenaa hadauchuwuhathane, nananene hauhauganene wauwau. Haenauwu henee daugaugaunauauwunanenenau, hedanauwau henee nājejenayaunau, nau hadgauuchauwau henee nājejenayaunau: ");
INSERT INTO arp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Naudu gauhājevā navāejethāwau nedauhaenaeevāejethā, henee hāejaenauusanaune hadeesedanauwau nehayau javaānee? ");
INSERT INTO arp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nau haeāedauwuna henee daunauthetheaugunethe, Hedanauwunaa vāejethā, nau hadevenau henee vadadauchuvāejethāvade. ");
INSERT INTO arp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(Nau hathāhuk, Vahadāhene, nanethenauau vadadauchuvāejethā.) ");
INSERT INTO arp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hanau hāedauwunathane, Henee dathājee hanesāde nanethenauau hadnevenade; nau henee janejasedede, daudause henee henetheyaunau hadnedanauwunade. ");
INSERT INTO arp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hau hena naujauthauwauau, henee najevadaunajawaunaunauau, hadjāthauva hede, nau hadnaunauauva hathaājenau. ");
INSERT INTO arp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nau hāesanāsenehede nuu, haenedauva, haenauauhuyehaunauau Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nau hethauwuu, hāayānauusade Bethphage nau Bethany, haua Olives haseāgu, Haesayānautheava hanesenethe hethauguhādaunau. ");
INSERT INTO arp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Najesaa nananena hesee hajasee hauauwudan hathaāsana, hathauhuk; nanaa waudasanagu hadveehauna dātheveehauchavesau hadduguhude, hehauwuthauune henane dachaugu: hadaugunauva, nau hadjāchaudauneva hede, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nau hith daun henane naudedaunānagu, Naudu hauaugunauna hethānagu? hesau jenaasenehethauna, hanau Vahadāde haddaununaude. ");
INSERT INTO arp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nau henee hautheavathee hanaāejathāauthee, nau haeveehanauau neesenehethaude. ");
INSERT INTO arp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nau daunausunaugunauthee dātheveehauchavesaune, hedauneenith, Naudu haaugunauna dātheveehauchavesau? hathāhaugaunee, ");
INSERT INTO arp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nau hanaāāedauwunauthee, Vahadāde haddaununaude. ");
INSERT INTO arp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nau haenauuchaudaunanauau Hejavaneauthusaun: nau haedadasanauwunanauau hedāchaunenau dasee dātheveehauchavesaun, nau haeaugaugunaunanauau Hejavaneauthusaun dasee. ");
INSERT INTO arp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nau daunausuyehaude, haesasaanauwu hedāchaunenau vaunaa. ");
INSERT INTO arp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nau hāayānauusade, wauwu haeauwusa hauanee Olives, haunauude hadauchude hethauguhādaunau hanaāaunauwuthajauthee nau haevaveenethedaunanauau Hejavaneauthu nauguu haevasānadedaune heee vahee hathāenauthaunee henesethaunene henee henauhauthaunenau; ");
INSERT INTO arp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Haunauwuthajauau Naja henee jaunaude haneneseede Vahadāhenith: danādauyauau hejavaa, nau vaveenethedauwuu javaājauudaa, hāheagu. ");
INSERT INTO arp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nau hauthauau Nesethajauhuhau hehethee henanedaa, Hechauhauthethāhe, neuwune hāthauguhādaunauau, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nau haeauchuhanāedauwuna nau hasenehethauhuk, Nananenau nāedauwunathana henee, hith nuu dādaunaugagaunee, hauunauganauau chauchaunu hadneduhuthee. ");
INSERT INTO arp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hau hāayānauusade, hāenauhaudauau hedan, nau haevewau, ");
INSERT INTO arp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hanaāenehede, hith heaenauwunagu, ha nananene, ha nuu hadeseve, hayauhuhau naathuu hadādaunahedaunaa, hau hewaunehaa yaunaudaunane hasesāe. ");
INSERT INTO arp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hanau hese hadnedasāna henee haujauthauwauau hadnesedethee havathegauuha heee nananene, nau hadnechauchuaunāna nauanee, nau hadnaunaunehāna daudauna hehethee, ");
INSERT INTO arp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nau hadnanaunauvaenāna, nau hadāeyaunewauau hanedauchaunawaunauau; nau hadnehauwunaudanauwunā hanesāhenith hauunaugane hanathaugunethe; hanau nananene daujaenauwu hāenauujādaunathana. ");
INSERT INTO arp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nau hanaāeyehaude vadanedaunauauwuu, nau hanaāenudanaude henee neaudaunanethe jedauwuu, nau henee naudaunanethe; ");
INSERT INTO arp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hanaāāedauwunaude, Wauthaunauhuu, Naudauauwuu haneauauwunee hadnevevethahedaunee: hau nananena haesedena nedaunaudee heyāenau havedehehauau. ");
INSERT INTO arp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nau haeautheda hayauwusenenee vadanedaunauauwuu. Hau najanauau vevethahevahehauau nau wauthaunauhāhehauau nau najavahehauau henanedanede haeneenanaudehaa hadnaāde, ");
INSERT INTO arp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nau haeeyauhuune nesenehāde hanau vahee henanedanede haenāedevenenau dauhujaathehāde. ");
INSERT INTO arp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nau hethauwuu, henee jasaa hena hesee, denausunauthedade henanedanede vadanedaunauauwuu, nau haeauthedaude waunauyaunee hethadenee, najanauau vevethahevahehauau nau wauthaunauhāhehau haeedasaa nauguu vachaugananenau, ");
INSERT INTO arp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nau hanaāanadethauthee, Jeauthedaunāa, hayew hāenaudahede hāenesedaude nuu hayauhuhau? wauāthe hanaa henee havenāde nuu hāenaudahede? ");
INSERT INTO arp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nau hanaāauchuhananāedauwunaude, Nechau hadnaudedaunathana hanesadee hayewhu; nau hadjeāedauwuneva: ");
INSERT INTO arp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Heedusaayāde Jaun, gauhuhuthaune hejavaa, wauāthe hehethee henanedaa? hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nau haeeegaugaugauudenauau, hith hesauhesenehethaunauaugu, hehethee hejavaa; hahagaunee, Naudu haejethauwaudaunauna? hanāthānauau. ");
INSERT INTO arp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hau hethaunauaugu, hehethee henanedaa; Vahee henanedanede hanāedaudauauvānauau hauunaugāe, hanau hethauwaenaunauthee henee Jauneau dauhaeyānith. ");
INSERT INTO arp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nau haeāedauwunanauau, daujeneauthedaunauthee daunathaunee. ");
INSERT INTO arp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nau Hejavaneauthusau hanaāāedauwunaude, Daudause gauhaudnauthedaunathava daun nāenaudahede nāenesedaude nuu hayauhuhau. ");
INSERT INTO arp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hanaāejasesanadedauau henanedanede heee dajenehede; Jasaa henane haejenane dadajevenevesenethauchayau, nau haeehathauauauwujethāhehau, nau haejathāau hesee vavāaune vedauauwuu haegudaunā. ");
INSERT INTO arp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hāenauauchaunee haeyethautheava wauwaune hesee thauauauwujethāhehau, henee hadjevenāde vevenaudenau hehethee dadajevenevesenethauchayaunaa: hau haeneneseguhuu, nau haejathethajenāhee jessaa. ");
INSERT INTO arp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nau jea haeyethautheava jachau wauwaune; nau haeneneseguhunauau jea, haedadayānauchuhanauau, nau haejathethajenāhee jessaa. ");
INSERT INTO arp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nau jea haeyethautheave nanaseauwaunee: nau haeanasenehanauau jea, nau haenuguthanauau. ");
INSERT INTO arp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hanaāenehede hadāhevāhe dadajevenevesaa, Hewauaujeesedaunaune? Hadautheawauau navechauthau nāa: Nauchāe hadeneehauthee hāenauhauwaunauthe. ");
INSERT INTO arp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hau thauauauwujethāhehauau hāenauhauwauthee, haegaugaugauudenauau, Naa nananede hadvanehanāde: nahājauau hadenauaune, henee headevanehanahedaunau hadenehanahenauau. ");
INSERT INTO arp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hanaāenuguthauthee dadajevenevesenethauchayaunaa, nau haenaanauau. Haudneduseha hadāhevāhe dadajevenevesenethauchayaunaa? ");
INSERT INTO arp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hadejaude nau hadnauauhaude nuu thauauauwujethāhehau, nau hadgauchuhuvāde dadajevenevesenethauchayau, hathauhuk, Nau hāenedauwauduu, hadnehauwunaasau, hahagaunee. ");
INSERT INTO arp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nau haenāauhauva, nau hanaāāedauwunaude, Dusau nuu henee wauthaunauhuu, Hauunauganau hauauvāhehauau hausāguthaunenau, hanānanenith hāhe hanadāde nedautheaunee? ");
INSERT INTO arp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Daun janesee dasee nuu hauunaugane hadthauusee, hau dasejaneseagu hanānauchauwuthauathāaunaude. ");
INSERT INTO arp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nau najanauau vevethahehehauau nau wauthaunauhāhehauau chauchaunu haegaugauanavanauau hadnesedanauthee; nau haeedauwu henanedanede heee dauhāenuu henee dauhuanadede nuu dajenehede heee. ");
INSERT INTO arp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nau haeaunauyauhauvanauau, nau haeautheavanauau haunauyauhauthāhehau, hadnanadaunethānethe hadchuvāhevathe henanenau, henee hadnesedanauwunethe hedanadedaunau, henee hadenauuchaudaunauthee hejadenenau nau naunaudāhenethe hauchuwunanene. ");
INSERT INTO arp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nau haenaunaudedaunanauau, Hechauhauthethāhe, haenaunee henee hasenehenaune nau nethauwuchauhauthethāne, daudause hāhauwujāvedaugauhauwaunauau henanedanauau hegau, hau hanechauhauthethāne hesee Hejavaneauthuu hethauwuu: ");
INSERT INTO arp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gaunaasauau heee nananee hadnevenade hauāyaunau Caesar, gauwauāthe hegau? ");
INSERT INTO arp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hau haeaenauwu henadaunedaudenenau, nau hanaāāedauwunaude, Naudu haevadauvasehena? ");
INSERT INTO arp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Jenauhauthehee vāejethāe. Hanaa hewauthaunenauaudene, nau hanaa hewauthaunauhanede? Haeauchuhanāedauwunanauau, Caesar. ");
INSERT INTO arp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nau hanaāāedauwunaude, Jauaunaudaunaa heee Caesar hayauhuhau henetheyaunau Caesar, nau Hejavaneauthau hayauhuhau henetheyaunau Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nau haejeneesedanauwu hedanadedaunene hathaājedaunenee henanedanede: nau haegaugauanadauwu hedauchuhanehedaunene, nau hanaāedādaunauguthee. ");
INSERT INTO arp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hanaāejeedauchauthee jasae Sadducees, hayāthajauhuhau henee hadjejaegauhadenenee: nau haenaudedaunanauau, ");
INSERT INTO arp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hechauhauthethāhe, Moses hathauthaunauwunānauau, Hith daun henane henauhauwauau gaujauaudāheyaugaune, heneneyaugaune, nau gaujauaudāheyaugaune jedāeyauneveyaugaune, henee henauhauwauau hanādanaude henenene, nau hanānesaunede heee henauhauwauau, hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hena heee haenesaudauchunauau henahavaevadehehauau: nau jasaa nedauau haeenene, nau haenaja haejedāeyauneve. ");
INSERT INTO arp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nau naneseauwaude haeneva, nau haenaja haejedāeyauneve. ");
INSERT INTO arp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nau nanaseauwaude haeneva; nau vavade hanaasene nanesaudauchuauwaude jea, nau haejenauthanauau dāeyaunauau, nau haegaujauaudāhenauau. ");
INSERT INTO arp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Waunee vahee hesā haegaujauaudā jea. ");
INSERT INTO arp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Henaheee jaegauhadeneyāgu hanaane hadnevādaune? heee hanesaudauchunethe daunevāde. ");
INSERT INTO arp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nau Hejavaneathusau haeauchuhanāedauwuna, dāeyaunauauau nuu hathāauauvaa nenevadedaunee, nau nenenehaudenee: ");
INSERT INTO arp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hau daun naunauguathee hadnenaededuu hena henaedede, nau jaegauhadeneagu hehethee gaujauaudahede, hadnehauwunevadedaune, hegau hadnenenehadedaune: ");
INSERT INTO arp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Daudause hadnehauwauthenajadene: hadnaathahedaunee hautheaunauau; nau hadnenesaunevāthee Hejavaneauthu, naathedāeyaunenedaunee jaegauhade. ");
INSERT INTO arp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wauhā henee gaujauaudahehehauau hadjaegauhāthee, Moses denauhauthehade jauauadee, deadethāde Vahadāhenith Hejavaneauthu Abraham, nau Hejavaneauthu Isaac, nau Hejavaneauthu Jacob. ");
INSERT INTO arp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hehauwuujavaneauthune heyauhaudade, hau henaedede: hanau vahee haneenaededaunenee. ");
INSERT INTO arp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hanaāene jasaa wauthaunauhāhe haeauchuhananadetha, Hechauhauthethāhe. Nananene hethade hasenehene. ");
INSERT INTO arp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nau heee haejauthenaudedaunanauau. ");
INSERT INTO arp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nau hanaāāedauwunaude, Naudu haena hanee Chris Dāvid dauhuāwaude? ");
INSERT INTO arp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nau Dāvid nehayau hasenehede wauthaunauhanaa Psalms, Vahadāde hasenehethaude Navahadāhewaunādaune, Hadjejanaugudaune hejavesanee, ");
INSERT INTO arp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Haunaude nadeesehaunauau haujauthauwauau hadnedaugāaugunene. ");
INSERT INTO arp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dāvid henaheee haeheenesea Vahadāhenith, dusee heau? ");
INSERT INTO arp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nau vahee henanedanede haenedaunau hanaāāedauwunaude hethauguhādaunau, ");
INSERT INTO arp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Waudauau wauthaunauhāhehauau, neneanaduu javesanee sauaunausāchaude, nau vechauduu jachauthadede nedauaudaunauvadedaunenee, nau najatheaugudaunau vevethahenauauwuu, nau najanau nedaugunethe vanethehedaunenee; ");
INSERT INTO arp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naudauvāe henevesānau hedauauwunene, nau hanau denauhauthethāthee deguthevevethahethee: hadnathee hanesedanuu vanasaunee gudanadede. ");
INSERT INTO arp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nau haeejaāne, nau haenauhauvā nethauyāsenanene haejenanauwu hevaudenenau haenathaunaa. ");
INSERT INTO arp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nau haenauhauva jea jachau hadavenuhu henevesāne haethāgudene hanesāenee nevaāhenee vāejethāau. ");
INSERT INTO arp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nau hanaāenehede, hethauwuu nananenau nāedauwunathana henee naa hadavenuhunede henevesā javaājenanauau vahee; ");
INSERT INTO arp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hanau vahee nuu nanethauyādahethee dejenanuu dejenanauwunauthee Hejavaneathu: hau hadavenuhunede hajenanauau vahee heenaededaunau hathāenethenauau. ");
INSERT INTO arp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nau haehegaugaugauudenauau vadannauauwuu, haseneehenee nauguu hethāhenethe hauunauganau nau hausāyaunau, hanaāenehede, ");
INSERT INTO arp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nuu hayauhuhau hānauhauthaunenau, hesee hadnauauchuu, hadnehauwunathauau hanesāde hauunauga hanathaugude hadvajanesee. ");
INSERT INTO arp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nau hanaāenaudedaunauthee, Hechauhauthethāhe, hau hadduunaasau nuu? nau hayew hadnauhauwuu hadnesauau hāene nuu hayauhuhau hadneenauauchuu? hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nau hanaāenehede, haunauyauhaudauwauau henee nananena hadejenanedaunehana: hanau hadnewauthathee hadjauthee Naneseedaunaa, Hanejavaneauthusaunenenau, hadnethee; nau hayānauauchauau: jevathauguhaa. ");
INSERT INTO arp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hau hāenedauwaudauwunā vauthadede nau jajayauthadede, jeva nathajauau, hanau nuu hayauhuhau hadnedauunauauchuu; hau hadneevadauauau hadguthauau. ");
INSERT INTO arp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hanaāāedauwunaude, jajaesenanedanedede hadnevauthadee jajaesenanedaa, nau najanede hadnevaudauau najanede: ");
INSERT INTO arp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nau hadnavathethauthauwunauauau vedauauawuu, nau hasenaude, nau havathaugauwude, nau naunaunauchaudauhauthaude nau hadvasauau naunauhauwuu hadnauauchauau hehethee hejavaa. ");
INSERT INTO arp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hau hadnejesejenauauchuu vahee nuu, hadnedanāna, nau hadnaunaunauchauthehāna, nau hadnevaudenee nananena hauāchaude, nau duguhunauauwuu, nau hadnenauuchauhana hathaājethee nenauchuwuthee nau hauchuwunanenauau hanau Naneseede heee. ");
INSERT INTO arp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nau hadnaasejenanauwunana heee haenathau. ");
INSERT INTO arp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hāenauwuu heeehena nananena hadahenauau, jevagaugauuthajauau nedauau daun hadnesenehena: ");
INSERT INTO arp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Hanau hadvenathana vade nau haeyaude, vahee hasānavādaunenau hadnehauwuneayādaunāva hegau hayethaagudaunādaunenau. ");
INSERT INTO arp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nau nananena hadnavethevāthee nesauuu hanehānenau, nau hāthesaunenau, nau hādauānenau, nau hādaehahenau; nau jasae nanaena hadneenaana. ");
INSERT INTO arp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nau hadneevahasānavāhena vahee henanedaa hanau naneseede heee. ");
INSERT INTO arp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hau hegau hāthaanenau haudauguhuanenauau haudnehauwugaujauaudāhenaunau. ");
INSERT INTO arp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hanāedevedaunenau hadnaunaunehaudde havadathuwunau. ");
INSERT INTO arp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nau hāenauhaudauwunā Dādaunedan hadnechauchuaunāna vanenanenauau, nanehāaenauwuna henee nauauhadede wauwu hadneaudaa, ");
INSERT INTO arp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nanehadaugauhuthee hesee hauanee hathāanedauthee Judaea; nau henee hathāanedauthee nahethāe nanehanauahethee; nau jevajejedānauha henee hathāanedauthee gauchuhunee vedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Hanau nuu hesee hadneauthedaudenee henee vahee hayauhuhau hathāewauthaunauhuu hadnethauwunaasauau. ");
INSERT INTO arp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Hau naunauthaunee hadnethauauvāhethee hathāenesaunethee, nau hathāeneaunauhuthee hena hesee, hanau hena hadnavathasenaudenee vedauauwuu, nau hasenaunaudaunāhenauau nuu henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nau hadneaunathāhethee gaugauthau, nau hadnejathechauhāthee hadwauwaunenethee vahee jajaesenanedanede: nau Dādaunedan hadnauguhethee Neauthu, haunaude Neauthu nauauchaudauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nau hadnauhauthaunee hesesee, nau vegusesee, nau hauthuuu; nau nanadee hathāauauvaa hadnaunauādaugauhudaunee jajaesenanedanede, hadnehauwaenauwu; hadaje nau hadnaunaudānaunee; ");
INSERT INTO arp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Henanenauau hedahenau hadnadenāthajaunee, nau hanau naunauyauhauduu hena hayauhuhau hadnauauchaunee dasee hathāauauvaa, hanau hathāenauthauau hejavaa hadnauauwunauauau. ");
INSERT INTO arp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nau hadnaāenauhauwauna Heau henane hadnenauusade henaunauade nauguu naunauthaunee nau hadnavathenauasāauau. ");
INSERT INTO arp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nau hāene nuu hayauhuhau hāenauauchuu, nauhadnaāenaunauānena; nau hadnejenāauguauna heee hadneejaenauthana hadnaāeaudaa. ");
INSERT INTO arp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nau hanaāedadajenehethaude; Nauhauvaa hauuyauchunauhaude, nau vahee hahaudenauau; ");
INSERT INTO arp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hāeguugauāhenauthe, hadnauhauwauna nau hadnaenauwuna nehayau henee veja dauhuaudaa. ");
INSERT INTO arp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hadnaasauau nananena hāenauhaudauwunā nuu hayauhuhau hadnethauwunaasauau, hāenauwuu henee henajanede Hejavaneauthau haneaudanee. ");
INSERT INTO arp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hethauwuu nāedauwunathana, nuu henaedede hadnehauwuvadauau, haunaude vahee hadnethauvāe. ");
INSERT INTO arp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hejavaa nau vedauauwuu hadneyauhuu; hau Nadanadedaunau hadnehauwuthauuyauhuunau. ");
INSERT INTO arp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nau haunauyauhaudauwauau nehayau, naseduhuu daunāene hadahenau havaehayaudenau heee haudauhauganedaunenau, nau havanadenenau, nau haunaunethaunenau nuu henaedede, nau henee hesee hadgauduaunāna hau hadnehauwaenava. ");
INSERT INTO arp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hanau waude nauyaudenau hadnauauchauau vahee hathāetheaugude dasee hathāauauvaa. ");
INSERT INTO arp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Haunauyauhaudauwauau henaheee, nau hevevethahee dajauaunee, henee nananena hadeheenauguana hadegauchuhuauwuna vahee nuu hayauhuhau henee hadnauauchuu, nau haddetheauguna hathaāhede Heau henane. ");
INSERT INTO arp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nau hesenee haeechauhauthethā vadanauauwuu; nau hāeveeyaunee haenauā, nau haeadāne hauanee henee neseeyāgu hauanee Olives. ");
INSERT INTO arp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nau vahee henanedanede haejevanauuchaudene naugusāje daunauganenee hadaude vadannauauwuu, heee dauhujaathehāde. ");
INSERT INTO arp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wauhā hadneevasevenee janenesaunauchauanauhuu jauaujaunau haeayānauauchau, Hadavechaude neseāgu. ");
INSERT INTO arp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nau najanau vevethahevahehau nau wauthaunauhāhehauau haegaugauanadauwunenau hadnesenaāde; hau haeedauwu henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hanaāejedāde Haujau Judas hejaveede Iscariot, haenethanedau vadadauchunesenee. ");
INSERT INTO arp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nau hanaāejathāaude, nau haeanadetha najanau vevethahevahehau nau haunauyauhauthāhehau, hadneseavedaudaunauwaude. ");
INSERT INTO arp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nau haeneethajaunauau, nau dechauchuwuhadethee hadvenāde vāejethā. ");
INSERT INTO arp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nau haesayānehetha, nau haeaunauyauhaudauwu hadneeneavedaudaunauwaude henanedanede. ");
INSERT INTO arp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hanaāenauauchauau hesee janenesaunauchauanauhuu jauaujaunau nanaa hadavechauthau hadnāede. ");
INSERT INTO arp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nau hanaāautheawaude Pedaheau nau Jauneau, Najesaa hadesaanudeva hadavechauthadede, hadevethenauau, hathāhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nau hanaāāedauwunauthee, Daudu hadauvathehāne hadnedauusaanuu? ");
INSERT INTO arp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nau hanaāāedauwunaude, Naune, hāejedānā hedan, hena henane hadnuchaunāna, hadnewauunauau hauānau hadjaāsanenee naje; hadethauguhauva hauauwuu hadnedaujedāde. ");
INSERT INTO arp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nau hadethauva henane hedauauwunede, Hechauhauthethāhe nejeethāne, daudu jādanauauwuu hadnedauvethenauau hadavechauthadede nauguu nāthauguhādaunauau? ");
INSERT INTO arp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nau hadnauhauthehāna vanasaunee dachauauwuu hadnesewaudeanee: hadnesaanuhuu. ");
INSERT INTO arp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nau hanaāeyehauthee, nau haeveedenauau neethāedauwunaude: nau hanaāesaanudethee hadavechauthadede. ");
INSERT INTO arp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nau hāenauauchaunee, hanaāejanaugude nauguu vadadauchunesenee hevadauhanau. ");
INSERT INTO arp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nau hanaāāedauwunaude, hethauwuvadauvethenau nuu hadavechauthadede naugu nananena hajesejasauwauwuthānau: ");
INSERT INTO arp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hanau nāedauwunathana, Nadnehauwauthevethe nuu, haunaude hadnauauchauau henajanede Hejavaneauthau. ");
INSERT INTO arp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nau hanaāedanauau vāenau, nau hanaāevāde vaveenede, nau hanaāenehede, Hedanauwuu nuu, nau hadjaanauwauva nehayau: ");
INSERT INTO arp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Hanau nāedauwunathana, Naudnehauwuvanethede dadajevenenaje, hanaude henajanede Hejavaneauthau nauauchauyāgu. ");
INSERT INTO arp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nau hanaāedanauau jauaujau, nau hanaāevade vaveenede, nau haejeane, nau haevena, Nuu nanaa nadanayau havenadenenau: nuu hadneejenauneethedaunena, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naasauau jea vāenau hāesethunevethehedaunee, Nuu vāenau waunauyauau hesānaavede Navaevaa, hanedaunauwunana, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Hau nauhauvaa, hejadenaa henee haneavedaudaunade nananenauau nanedauguvānauau vethehedaunaa. ");
INSERT INTO arp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nau hethauwuu Heau henane hadjathāaude, neesedauwaunade: hau naunauthaunee henee henane haneavedaudaunaudenenee. ");
INSERT INTO arp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nau hanaāenaunaudedaunadethee nehayau, hanaadee hadnesedaude nuu. ");
INSERT INTO arp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nau hena jea haeneenayaudenauau, hanaadee hadjavaāvasāthaa. ");
INSERT INTO arp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nau hanaāāedauwunaude, Nenauchuwuthee Neauthuu haevahadahethedauwu; nau henee nanethenuu naudahede nanadee hesenaedehehauau neseadagaunee. ");
INSERT INTO arp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hau jevanaathāhee: hau henee havasāthawaunādaunenau, hadenahavaewauva; nau henee naja waude henee henechauthāhehau. ");
INSERT INTO arp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hanaa vanasāthaa, henee vanethede, wauāthe henee henechauthāhe? gaujenane henee vanethede? hau hanedaudaunathana waude henee henechauthāhe. ");
INSERT INTO arp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nananena daudajauaunenethaunena denaunaunauchauthehanau. ");
INSERT INTO arp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nau janenanauwunathana najanede, waude Nāsaunau nejeesejenanauwunānau; ");
INSERT INTO arp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hadevethehena nau hadevaveyāna navethehedaunaa Nanajanedaunaa, nau hadetheaugudauwuna najatheaugudaunau hadnauchuwuhauna vadadauchunesenee jajaesenanedanede Israel. ");
INSERT INTO arp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nau Vahadāde hanaāenehede, Simon, Simon, nauhauwune, Haujau nevadaunethenāne, hadvachuuguthāne waude thauauhanewauchuunau: ");
INSERT INTO arp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hau nevevethasathane, henee hadethauwuthajaude hadejenadegaudenauau: nau hāejauaugauthethajaunaune hadedāewaunauau hahauwauauau. ");
INSERT INTO arp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nau haenehetha, Vahadāhene, Nananenau hanesaanunau hadnenenethaunathane, nesauna duguhunauauwuu, nau gaujauaudahedaunaa. ");
INSERT INTO arp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nau haeāedauwuna, hāedauwunathane, Peda, neauthuneāhe hadnehauwunedu nuu desenenee, hajesejenehenaune nasau hadnethedauwaune henee nananene daujaenaunene. ");
INSERT INTO arp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nau hanaāāedāuwunaude, Deathavejenanathana hāehauwunewauunava nesevāejethāwau, nau newaugusajaānauchu, nau wauaunau, gauhājevathehāva hayewhu? Hegau, hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hanaāāedauwunaude, hau hewaunehaa henee nanethenauau nesevāejethāwau nanehaedanauau, nau jea henewaugusajaānauchu; nau henee janenethenauau gaugauchu, nanehaeaudaunade heddu, nau jeaudaunaude gaugauchu. ");
INSERT INTO arp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hanau nāedauwunathana, henee nuu wauthaunauhuu hethauwunaathauthaunauhunau, Nau haewauhaunuau wauwauchudauhuhau: hanau nethauthedauthanau hethauvaa. ");
INSERT INTO arp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nau hathauhaugaunee, Vahadāhene, nauhaudau, heyewnau hanesāe gaugauthau. Nau haeāedauwuna, Naadauchāe. ");
INSERT INTO arp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nau haejenaua, nau haejathāau, nesedaude, haua nee Olives; nau hethauguhādaunau jea haethauguhaa. ");
INSERT INTO arp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nau hāanauusade, haeāedauwuna hevevethahee henee hadejejedāna vasehadede. ");
INSERT INTO arp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nau haejāvesa hehejese nejechauthaunenee, nau haechagujanaugu, nau haevevetha, ");
INSERT INTO arp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nāchau, hith Nananene vadauusedaunenagu, jegudanauwune nuu vāenau hehethee Nananenau: hau nāhauwuvathehaa, hau Nananene, hadnaasauau, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nau haenauhauva hautheaune hehethee hejavaa, haedadāevaa. ");
INSERT INTO arp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nau haeneenajeneethajau haeneenavevetha: nau heguwauaude waude davathejajaneauthee vaewauau dejanesee vedauauwuu. ");
INSERT INTO arp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nau hāegauhāde hehethee devevethahede, nau haejeedasa hethauguhādaunau, Haeveena haeseenaugauhunenau heee haudauwuthajaude, ");
INSERT INTO arp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nau haeāedauwuna, Naudu haenaugauhuna? gauhāe nau vevethahee, hadejejedāna vasehadede. ");
INSERT INTO arp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nau hajesanadede, haenauhauwu havathenanedanede, nau henee Judas neseade, jasaa vadadauchunesenee, haenedauva, nau haeayāedasa Hejavaneauthusaun hadnedanaude. ");
INSERT INTO arp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Hau Hejavaneauthusaun hathāhuk, Judas, gauhāavedaudauna Heau henane gauhadneenedanau? ");
INSERT INTO arp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hāene henethauguvādaunau daunauhaudauwunethe hadnesehade, Vahadāhene, gauhadjedauauwaunauau heee gaugauchu? hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nau hanesāde haedauauva hewauwaunavene vasnajane vevethahevahew, nau haegauadathāhe hejavese. ");
INSERT INTO arp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nau Hejavaneauthusau haeauchuhananadetha, Hauwaa nanesedau nuu. Nau haevasane henaudaununene, nau haeenayauha. ");
INSERT INTO arp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hejavaneauthusau hanaāenehethaude najavevethahevahehau, nau haunauyauhauthāhehau vadannauauwuu, nau vachaugananenau, hejewaunedasādaunau, Gauhāejauva, waude heee havedehe, nauguu gaugauthau nau vachau? ");
INSERT INTO arp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Denethenaedevathana hayauwusenee vadannauauwuu, nananena hāehauwudaneva: hau nuu nauauchaudauna, nau naunauthauau vaneeyauau. ");
INSERT INTO arp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hanaāedanauthee, nau haejathechauhanauau, nau haejedananauau Vasenajane vevethahevahew hedauauwunene. Nau Peda haejesedauchu. ");
INSERT INTO arp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nau hāesewaudedaunathee nahethāe hadauvasenejesauau, nau haeauājanaugunauau, Peda haejanaugudauna. ");
INSERT INTO arp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hau jasae hesāhedāeyaune haenauhauvaa daujanaugudaunaude hejava hesedaa, nau haenaunauchaudauhauvaa, nau hathāhuk, Naa henane jea nanethenaedewaude. ");
INSERT INTO arp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nau haeethedauwautha, Hesā, nahauwaenaunau, hathauhuk. ");
INSERT INTO arp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nau naunade jachau haenauhauvaa, nau hathāhuk, Nananene jea hanehedāhene. Nau Peda hahagu, Henane, nananenau hegau. ");
INSERT INTO arp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nau heee jasaye denauachauau waunee jachau haeethauwunehene, hathāhuk, hethauwuu naa jea nanethenaedewaude; hanau nananede Gananaean. ");
INSERT INTO arp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nau Peda hahagu, Henane, Nāhauwaene daun nesenehene. Nau chauchaunu, daunausunanadede, neauthuneāhe haenedu. ");
INSERT INTO arp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nau Vahadāde haejaaagu, nau haenāauhauva Pedaheau. Nau Peda haethauchuthajaude hedanadedaunene Vahadāhenith, neesenehethāde, Hajesejeneduhude neauthuneāhe, nananene hadnethedauwauchune nasauna. ");
INSERT INTO arp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nau Peda haenaua, nau haeneenavewau. ");
INSERT INTO arp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nau henanenauau henee daununauthee Hejavaneauthusaun haevavavanauchuhanauau, nau haedaudauauvaa. ");
INSERT INTO arp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nau hāesajeājethauthee, haeanadeāhenauau, nau haenaunaudedaunanauau, Haeyāhe, hanaa henee haudauauvāde? nethāhuk, ");
INSERT INTO arp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nau wauthanee haeewauwauchuvaa nanāsanadethāde. ");
INSERT INTO arp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nau chauchaunu hasenaugusājenee, vachaugananenauau henanedanede nau najanauau vevethahehehauau nau wauthaunauhāhehauau haeauāchaudaunanauau, nau haejedananauau hadauhanadethee, ");
INSERT INTO arp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Gauhanane Chris? jeāedauwunāa, hathauhaugaunee. Nau haeāedauwuna, Hith Nananenau hāedauwunathanagu, nananena hanājethauwaudaunena: ");
INSERT INTO arp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nau hith nananenau jea naudedaunathanagu, nananena hanājauchuhananadesena, wauāthe hanājejenanena. ");
INSERT INTO arp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hewaunehaa heee Heau henane hadtheaugude hejavese naunaudāhenith Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hanaāenehethee vahee, Gauhanane Heau Hejavaneauthau? Nau haeāedauwuna, Hasenehena Nananenau. ");
INSERT INTO arp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nau hahagaunee, Hehauwauthevathehāanauau naudedauyaunauau? hanau nehayau nanedaunaunauau Nehayau hedenaa. ");
INSERT INTO arp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nau haunauude henanedanede haegauhadene, nau haeyehaudaunanauau Pinade. ");
INSERT INTO arp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nau hanaāevavasevāde, Vaneenaunauau naa gauchuhuchaudede jajaesenanedanede, nau nedauduwaude hadjevenauthee hauāyaunau Caesar, daunahagu Chris Nenauchuwude, nethadede, hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nau Pinade haenaudedauna, Gauhanane Dauhunauchuwuhunene Jews? hathauhuk, Nau haeauchuhanāedauwunaa, Hethauvāne. ");
INSERT INTO arp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hanaāāedauwunaude Pinade najanau vevethahehehau nau henanedanede, Nāhauwuveedenaune wausaunee naa Henane. ");
INSERT INTO arp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nau haenaunauchauthedauhaudene, wauwauyauchudede henanedanede, hanechauhauthethāde hehethee vahee Jewsevedauauwuu, jejasesee hehethee Gananane nauuu nuu vedauauwuu, hathauhaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hāene Pinade nedauwauthaude Ganane, haenaudedauva wauau hagananenanene. ");
INSERT INTO arp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nau chauchaunu hāesaenauau henee daunaadāde Herod hadaunajavanethe, haeathavenane Herod, jea haeanedau Dādaunedan hena hesee. ");
INSERT INTO arp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nau hāene Herod nauhauwaude Hejavaneauthusaun haevaseneethajau: heee devadaunauhauwaude dajauaunee hanau dauhuwauthanedauwauthaude; nau haevadaunauhaudauwu jasaa venauneguthau hadnesedaunith. ");
INSERT INTO arp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Haenaunaudedauna hauwauhuu hanadedaunau; hau haejauchuhananadethaa. ");
INSERT INTO arp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nau najanau vevethahehehau nau wauthaunauhāhehau haetheaugunenau nau haenaunaunauchauthevaa. ");
INSERT INTO arp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nau Herod nauguu vauānanenau haejenananauaugaugauyaune, nau haevavavanauchuhanauau, nau haeneenuhanauau neaudahenenee hu, nau haevenanauau jea Pinade. ");
INSERT INTO arp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nau hajesesenenee Pinade nau Herod haeenedaehāvadenauau nesauuu: hanau nedauwuu haeasānavadenauau nehayau. ");
INSERT INTO arp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nau Pinade, hāesauānadethaude najanau vevethahehehau nau hauchuwunanenau nau henanedanede, ");
INSERT INTO arp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Haeāedauwuna, Nananena nauuchaudaunena naa Henane, nanahagu henee gauchuhuchaudede henanedanede: nau, naune, nananenau, haunauchuwuhauau hathaāhena, nāhauwuveedenaune wausaunee naa henane heee henee hayauhuhau nanāsevasewauna: ");
INSERT INTO arp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hegau, hehauwune Herod: hanau neathavejenanauwunathane; nau naune, hehauwuneenauau hehauwugaudauwudau. ");
INSERT INTO arp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hadnenesegauhaa, nau hadjenanauau. ");
INSERT INTO arp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Hanau hadnaugauhusenaasedaude hadjenanaude hanesāhenethe vasevethehedauneagu.) ");
INSERT INTO arp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nau haunauude haevasānadenauau jasānee, Hausāguthaa naa, nau jejenanauwunāaa Barabbas, hahagaune: ");
INSERT INTO arp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nananede hanau jasaa nejaevauāde hedan, nau hanau nenaade, nethānade duguhunauauwuu.) ");
INSERT INTO arp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pinade henaheee, haevadaujenana Hejavaneauthusaun, haeanadetha jea. ");
INSERT INTO arp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hau haeneānaune, Saethechuhuu, Saethechuhuu, hahagaunee. ");
INSERT INTO arp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nau haeāedauwuna nanaseauwaunee, Dusee, dusewauchudau? Nāhauwuveedenaune hadneegaujauauthehaude: Hadnaasedaunau hadnenesegauhaa, nau hadnaāejenanauau. ");
INSERT INTO arp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nau haeneenavasānadenauau, haeneenavadausaethechuhunauau. Nau haeneānadenauau nau najanau vevethahehehauau haeechauwauauwaunauau. ");
INSERT INTO arp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nau Pinade haechuwaudā henee hadnaasaunee hasevathehāthee. ");
INSERT INTO arp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nau haejenanauwuna nananede henee hanau nejaevauāde nau nenaade haethānau duguhunauauwuu; nananede heenedauwaudenenau; hau haevā Hejavaneauthusaun hathanauwauthee. ");
INSERT INTO arp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nau hāejathechauhauthee, haeedananauau hanesāhenith Simoneau, hehethee Cyrenene, hananeedesade vedauauwuu, nau hananene haenehanauwunanauau naugauchu, henee hadnanewauunauwunith thauguu Hejavaneauthusaun. ");
INSERT INTO arp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nau hena haethauguhaa havathenanedanede, nau hesānau, haeaudauwuthajauha nau haevewauhunauau heee. ");
INSERT INTO arp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hau Hejavaneauthusau haejaaāne haeāedauwuna, Dādaunedan hedaunauhau, jevahevewauhuu heee Nananenau, hau heevewauhuu nehayau, nau heee hadāeyaunevenau. ");
INSERT INTO arp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hanau, naune, hese janādauuu, hadneenehedaunee, Haunauwuthajauau jenesaunehehauau, nau henaudaunenau henee nejethauujanesāthee, nau hethanenau hehauwunethuaunenau. ");
INSERT INTO arp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Heee hadnaāejaseseneheduu hauane, Gauduaunānauau; naa jauaudane, gaudauyauhunauau. ");
INSERT INTO arp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hanau hith heenesedauhaugaunee nuu hayauhuhau janadanegauaheyaugaune hauhaudene, haudneedusedaune wautheyaugu? ");
INSERT INTO arp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nau hena haenesenauau gauchuhunee jea, wauwauchudauhuhau, haenethaunaa hadnaugunaade. ");
INSERT INTO arp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nau hāene hāedaduu, Calvary hanaaseenee, hena haesaethechuhunauau, nau wauwauchudauhuhau, hanesāhenith hejavese, nau jachau nauwauthe. ");
INSERT INTO arp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Haenaāenehede Hejavaneauthusau, Nāchau jaegudanauwunene; hanau daujāenuu hasedauthee. Nau haejaanauwaunenau, hedāchaunene, nau haeheedaudauusadaunenau. ");
INSERT INTO arp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nau henanedanede haetheaugudaune dauhasauhauvade. Nau hauchuwunanenau jea nauguu haeauchaudanavaa, haseneheyaugaune, Nenayauhaude hauthauau; Nanehanehanenayauhadede hethauwuu Chrisdeyaugu, Neayāsanāde Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nau vanenanenau jea haenaunaugauthedaunaa, haeedasaa, nau haevenaa naneujaudenee dadajevenenaje, ");
INSERT INTO arp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nau hathāhuk, Hethauwunajawaunaudagaunee Jews, henayauhade nehayau. ");
INSERT INTO arp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nau haewauthaunau jea haewauthaunauhune hejavaa hedanadedaunene Greek, nau Latin, nau Hebrew, Naa Nanajawaunaude Jews. ");
INSERT INTO arp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nau jachau wauwauchudauhu chaunaunauaunith haewauwauchuvaa, Hethauwuu Chrisdenagu, henayauhade Nehayau nau nananee, hathāhuk. ");
INSERT INTO arp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hau jachau haeauchuhananadene haedauduva, Gauhajeadaunau Hejavaneauthau, hanau nananene nanesadee hathauchuwuhane? hathauhuk, ");
INSERT INTO arp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nau neehanauau; hanau hanesedanauwunauau nanāsedaunauau: hau Naa hehauwuwauchudau. ");
INSERT INTO arp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nau hanaāenehethaude Hejaneauthusaun, Vahadāhene, dauyewuwuthedaune hāanauusanaune Hanajanede. ");
INSERT INTO arp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nau Hejavaneauthusaun hathāhuk. Hethauwuu hāedauwunathane, Nuu desenee hadnethenaedevene Paradise. ");
INSERT INTO arp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nau hāethauthaunesade, nau hanaāeveeyauau nanadee vahee hathāauauvaa haunaude nanasuusee hāenauauchauau. ");
INSERT INTO arp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nau hesese haeveenenauau, nau hauguthau Vadannauauwuu haethauwunauau nahethāe. ");
INSERT INTO arp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nau Hejavaneauthusau hāevasānadede, Nāchau, hajadenaa hadaunaunehau Navadathuwu, hahagu: nau hāesenehede nuu, haevadauwauthauwu. ");
INSERT INTO arp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wauhā vanenenaja hāenauhaudauau hasedaudenenee, Haeauwauaudauna Hejavaneauthu, Hethauwuu naa chaunuvāde Henane, hahagu. ");
INSERT INTO arp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nau vahee henanedanede henee hathāejeauānuusathee hadnauhauwauthee, haenauhaudauwu hanasedaudenenee, haeanadesejāhedenauau, nau haejaajegauhudaune. ");
INSERT INTO arp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nau vahee henedaehauhau, nau hesānau hethāethauguhādaunau hehethee Gananee, haetheaugunenau vavāaune, haenauhaudauwu nuu. ");
INSERT INTO arp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nau, naune, henane Joseph haeesee, najananadehe; nau haeethā, nau haechuvā: ");
INSERT INTO arp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Naa haejechuwaudā hasenehedaunenee nau hasedaunethe;) haenaadāde Arimathaea, hedan Jews: nananede jea nehayau haeejauwuwude henajanedaunene Hejavaneauthu. ");
INSERT INTO arp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naa haeyehau Pinade, nau haenedauwaude hedanayaunene Hejavaneauthusaun. ");
INSERT INTO arp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nau haejanana, nau haeauyauuna naunaujānaunee, nau haejenana nedauthānavathe gaujauaudahehehau hauunaugāe, haunauau henane haejethauujenanau. ");
INSERT INTO arp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nau hena hesee haeesaanudaune, nau vadanesee dayānauauchauau. ");
INSERT INTO arp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nau hesānau jea, hejenauunethaunādaunau hehethee Gananee, haethauguhaa, nau haenauhaudauwu hadausaesenanethe, nau hedanayaunene hathaudanee. ");
INSERT INTO arp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nau haejaenauthau, nau haeesaanudenauau hathāeneevaudenee nau chauayaunau; nau haedauyānusenauau vadanesee hasauau nanavaavede. ");
INSERT INTO arp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wauhā nanedauwaudaa hesee hauchauvadede, hajesejevesesanith haejeedadauwu hadausaesenanith, haenauuchaudenauau hathāeneevaudenee heesaanuthaunenau, nau jasae hauthauau nauguu. ");
INSERT INTO arp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nau haenauhauvanauau hauunaugane haeausānene hehethee hadausaesee. ");
INSERT INTO arp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nau haejedānauau, nau haejeveedenauau hedanayaunene Vahadāhenith Hejavaneauthusaun. ");
INSERT INTO arp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nau hethauwuu daugaudauwuthajauthee heee, naune, hanesenethe henanenau haetheaugudaunā haenauasāaunenau hedāchaunene: ");
INSERT INTO arp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nau daunāthajauthee, nau haenaunauagunauau vedauauwuu, haeāedauwunā, Naudu nananena haenaudehauna hanenaededaunaude nethee gaujauaudahehehau? ");
INSERT INTO arp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hehauwanedau hede, hau jaegauhāde: dauyewuwuu neethāedauwunāna denausunanedaude Gananee, ");
INSERT INTO arp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Neesenehede, Heau henane hadvenavathe hejadenene wauwauchudaunanenau, nau hadsaethechauhude, nau nasese hadjaegauhāde. ");
INSERT INTO arp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nau haedauyewuwunauau hedanadedaunene, ");
INSERT INTO arp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nau haenaudauwu hehethee needausaesenanith, nau haeauthedaunanauau vahee nuu hayauhuhau jasānee, nau vahee hauthauau. ");
INSERT INTO arp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Haenane Mare Magdalene, nau Joanna, nau Mare henaune James, nau hauthauauau hesānauau henee henethaunādaunenau, neauthedaunauthee nuu hayauhuhau vadauhanau. ");
INSERT INTO arp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nau hedanadedaunenau hathanadauwuyaugaune gaugauyaune, nau haejethauwaudaunaunauau. ");
INSERT INTO arp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hanaāegauhāde Peda, nau haeyeseneegau hadausaesenanith, nau haeewauguau, haenauhaude naunaujānaunee haeānaudanenau jessaa, nau haenaude, haegaugauanade hasaunee. ");
INSERT INTO arp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nau, naune, hanesenethe haeyehaunenau henee hajesesenee hajasee hauauwudan Emmaus haseagu, hehethee Dādaunedan wauau nesaudauchu nau gauuu daugauha. ");
INSERT INTO arp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nau haeanadenauau wauhaunee vahee nuu hayauhuhau hasaunee. ");
INSERT INTO arp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nau hethauwuu, henee, dauanadethee wauhaunee nau haenaunaudedaunadenauau, Hejavaneauthusau Nehayau haeeauchauna, nau haenethauna. ");
INSERT INTO arp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hau hesesānenau haedunenenau henee hadjaenaunauthee. ");
INSERT INTO arp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nau haeāedauwuna, Hayewnau hadanadedaunenau nuu henee nananena hānegudaudenenau, daujajāwauaunadena, nau daudaneāauna? ");
INSERT INTO arp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nau jasaa hanaaseede Cleopas, haeauchuhananadethaa, Gauhanane vavade dauhadavesane nuu Dādaunedan, nau gauhajaene hayauhuhau hasedaudenee hena nuu hesee? ");
INSERT INTO arp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nau haeāedauwuna, Hayewnau? Nau haeāedauwunaa, Heee Hejavaneauthusau Nazareth, nananede Haeyāhe naunaudāde hanasedaude nau hedanadede hathaāhenith Hejavaneauthu nau vahee henanedanede: ");
INSERT INTO arp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nau najanauau vevethahevahehauau nau hadauchuwunanevene neesevānethe gaujauaudahede hadneauchuwuhade, nau nesaethechauhude. ");
INSERT INTO arp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hau nejauwuwuhaunauau Nananede hadnenayaudede Israel: nau nauguu vahee nuu, desenee nanasāe hesee hāesenesedaudenee. ");
INSERT INTO arp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Haa, nau jasae hesānauau jea hadahenauau nenāvānauau, naugusāge neanedauthee hadausaesenanith; ");
INSERT INTO arp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nau dejeveedethee hedanayaunene, nejenuusathee, neauthedathee, henee jea haenauhauvanauau hautheaunau neethāhaugaunee henee daujaenaedeyaugaune. ");
INSERT INTO arp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nau hauthauauau hānethaunādaunene deyehaunauau hadausaesee, nau haeveedenauau vavade hesānauau neesenehenethe: hau haejenauhauvanauau. ");
INSERT INTO arp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hanaāāedauwunaude, Hau hāhauwaenava nau gaunauanuu hadahenau hethauwaudanee vahee henee haeyāhehauau nethauthedathee: ");
INSERT INTO arp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Naasauau Chris hadnasenede nuu, nau hadjedāde hadnedauvasāthaa. ");
INSERT INTO arp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nau jeeejasesee Mosese nau vahee haeyāhehauau, neevavesāedauwunaude heee vahee hanathauthaunauhunee hayauhuhau hadnesenaedede Nehayau. ");
INSERT INTO arp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nau haeeauchauwu hajasee hauauwudan hasesathee: nau nehayau haenanedauneha hadjavesade. ");
INSERT INTO arp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hau haeneenadaunanauau, hathauhaugaunee, Hanedaudaunāa: hayānaesade, nau hesee hayāenauwusanauau. Nau haejedā hadnanedaudaunaude. ");
INSERT INTO arp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nau hethauwuu, daujanaugude haenethevetheheva, Haeedane jauaujau, nau haevaveene, nau haejeane, nau haevena. ");
INSERT INTO arp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nau hesesānenau haegaunanenenau, nau hanaāaenaunauthee; nau haeeyauhaudenauau. ");
INSERT INTO arp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nau hadāhene gauhauchāe hethauvaa, hanathadagaunee jaee, deanadethānauau jāthee, nau hāegaunanauwunānauau wauthaunauhanau? ");
INSERT INTO arp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nau haegauhānauau chauchaunu nau haejaeyehaunauau Dādaunedan, nau haeveehanauau jasānee haeaunauudaunāhenenau, nau hauthauau henee hanedaudaunādaunenau, ");
INSERT INTO arp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vahadāde gauhāde hethauwuu, nau haenauhautheha Simon, hathahaugaunee. ");
INSERT INTO arp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nau haeauthedanauau hayauhuhau hanasedaunith hadesathee, nau hasaenaunāde daujeanauau jauaujau. ");
INSERT INTO arp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nau daunausunanadethee, Hejavaneauthusau Nehayau haetheaugu nahethāe hadauthee, nau hathāhaugaunee, Danādauyauau vanenathana. ");
INSERT INTO arp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hau haenānauaunauau nau haenāthajaunauau, nau hasethajauhaugaunee henee haenauhauvanauau vadathu. ");
INSERT INTO arp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nau hathauhuk, Naudu nananena haenāthajauna, nau naudu haegaugauuthajauna gauhānauha hadahenau? ");
INSERT INTO arp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nauhaudauwuu Najadenau nau Nauaudau, henee Nananenau nehayau: Vasanee, nau nauhauwuu; hanau vadathau hehauwudausānune nau hehauwudechaunave, hathauhauwuna. ");
INSERT INTO arp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nau dauhanadede, haenauhautheha hejadenau nau heaudau. ");
INSERT INTO arp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nau haejethauwuthajaunauau heee haunauwuthajaude, nau haegaugauuthajaunauau, Haeāedauwuna, Gauhajevetheneva hede? ");
INSERT INTO arp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nau haevenanauau hanesāhenith nauwu haeaujaunene, nau gauhauaugunaugauye. ");
INSERT INTO arp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nau haeedane, nau haevethe hathaājenethe. ");
INSERT INTO arp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nau haeāedauwuna, Nuu nanāe hanadedaunau hāauthedaunathadenenau, denausunethenaedevathana, henee vahee hayauhuhau hadnethauwunauauchuu, hanathauthaunauhuu henanavaavede Mosese, nau haeyāhehauau, nau psalms heee Nananenau. ");
INSERT INTO arp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hanaāegaunanauwunaude hadnaenauwunethe, henee hadnaenauwunethe wauthaunauhanau, ");
INSERT INTO arp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nau haeāedauwuna, Hathauthaunauhuu, nau naasauau Chris hadnasenede, nau hadjaegauhāde hehethee gaujauaudahede nasese: ");
INSERT INTO arp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nau henee haugauthegaugauuthajaude nau hadjaegudanee wauchudaudenau hadnautheduhunee heee Heneseede nanadee jajaesenanedanede, hehethee Dādaunedan. ");
INSERT INTO arp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nau nananena haenauwuna nuu hayauhuhau. ");
INSERT INTO arp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nau, naune, Nananenau vanenathana sayānee Nāsaunau hau theauguu hedan Dādaunedan, haunaude nananena hāchauwunagu nauguu naudahede hehethee hejavaa. ");
INSERT INTO arp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nau haejasesenedauwauna hajechaudanee Bethany, nau haeegauha, nau haevevethasa. ");
INSERT INTO arp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nau hethauwuu, daunausuvevethauchaude, Haenautha, nau haeejechauhau jethee hejavaa. ");
INSERT INTO arp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nau haevevethedaunanauau, nau haejaeyehaunauau Dādaunedan nauguu vaseneethajaude: ");
INSERT INTO arp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nau dajauaunee haeanedaunauau jedauwuu Vadannauauwuu, hauwaunede nau haevevethedaunanauau Hejavaneauthu. Hethauvaa. ");
ALTER TABLE arp_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
